﻿USE sofia;
DROP TABLE IF EXISTS sofia.padNT_vpl;
CREATE TABLE padNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES padNT_vpl WRITE;
INSERT INTO padNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hida vani Jesus Cristo kaija'ari avikhananavaki vaonina. Davi kohana kaija'ari namitharonisiagaki ada Jesus Cristo. Abraão kaija'ari namitharonisiagaki ada Davi. ");
INSERT INTO padNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Isaque kaabi'i ada Abraão kohana. Jacó kaabi'i ada Isaque kohana. Judá vakadiabi'i ada Jacó. ");
INSERT INTO padNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Peres Zera khama vakadiabi'i kohana ada Judá. Vakadiamia kohana Tamar oniki. Esrom kaabi'i ada Peres kohana. Arão kaabi'i ada Esrom kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadabe kaabi'i ada Arão kohana. Nasom kaabi'i ada Aminadabe kohana. Salmom kaabi'i ada Nasom kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boaz kaabi'i ada Salmom kohana. Boaz kaamia kohana Raabe oniki. Obede kaabi'i ada Boaz kohana. Obede kaamia kohana Rute oniki. Jessé kaabi'i ada Obede kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Davi kaabi'i ada Jessé kohana. Arabo kaka'da'dini ada Davi kohana. Salomão kaabi'i ada Davi kohana. Davia bivahoja'iki ida Urias kohana kagamo, Salomão kaamia ida. ");
INSERT INTO padNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Roboão kaabi'i ada Salomão kohana. Abias kaabi'i ada Roboão kohana. Asa kaabi'i ada Abias kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Josafá kaabi'i ada Asa kohana. Jorão kaabi'i ada Josafá kohana. Uzias kaabi'i ada Jorão kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jotão kaabi'i ada Uzias kohana. Acaz kaabi'i ada Jotão kohana. Ezequias kaabi'i ada Acaz kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manassés kaabi'i ada Ezequias kohana. Amom kaabi'i ada Manassés kohana. Josias kaabi'i ada Amom kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jeconias vakadiabi'i ada Josias kohana. Josias kohana hokina kari Babilônia kaija'arini va'ora vagathi'iki adani Israel kaija'ari Babilônia kaarabonia avikhara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israel kaija'ari Babilônia kaarabonia osahi vihina naothinia, hojaki ada Salatiel oniki. Salatiel kaabi'i ada Jeconias kohana. Zorobabel kaabi'i ada Salatiel kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiúde de kaabi'i ada Zorobabel kohana. Eliaquim kaabi'i Abiúde kohana. Azor kaabi'i ada Eliaquim kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadoque kaabi'i ada Azor kohana. Aquim kaabi'i ada Sadoque kohana. Eliúde kaabi'i ada Aquim kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleazar kaabi'i ada Eliúde kohana. Matã kaabi'i ada Eleazar kohana. Jacó kaabi'i ada Matã kohana. ");
INSERT INTO padNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","José kaabi'i ada Jacó kohana. Maria kamakhira ada José, Jesus kaamia ida Maria. Cristo ada Jesus Deua binagathogatho'iki. ");
INSERT INTO padNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Asia hojaki hida Jesus kaija'ari avikhananavaki varani vihina. Abraão kahanodi hanodina hanodi'ianana, hanodi'ianana, kahanodi'ianana onivani fori vihi'ianaha adani 14 vihiki vakadisai vahanodironisiagana va'oaniaro maina, oniaroa, hoja'aha ada Davi ovari maina. Davi abini'ina naothinia onivani fori vihiha adani 14 vaipohina vihiki afo'iana, vahanodi'ianana adani vakadihanodi vahanodironisiagana, oniania osahi vihi'aha adani Israel kaija'ari Babilônia kaarabonia. Babilônia kaarabonia avikhana naothinia 14 ipohini vani fori vihi'ianaha vahanodi'ianana adani vakadihanodi vahanodironisiagana, oniania, hoja'aha ada Cristo. ");
INSERT INTO padNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hari. Vara ovani'aki bana hida Jesus Cristo biva'bana'iki kamahini varani hini. Maria oniki ida Jesus kaamia. Joséa binofiki ida Maria-ra kanagamohavini. Joséa bivi'omaravini oadani kajahavido'ihi ida Maria. Ni-Joséa bivaisa'iki. Ma'onahai Jahaki vani ada Maria-ra vaisa'ara. Nokiariha ada Ma'onahai Jahaki. ");
INSERT INTO padNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ni-Joséa biogaki kaho ida niha ninini Maria kajahavidoni. Makhira hoariha kaisai bivanihamanihi. Maria kajahavidoni mani ida José kidigamo kaimoni-ra nofijanaravini hija. Jahaki, asohiki ida José kahojai, ni-binofiki ida Maria va'ini-ra anaipahihivini vahoariha vaviaha bianaathidanoararivini badani jaharikia kabadanini bikahivini. Ija'ari vaipohiki avigaravini oadani, binofiki ida akarai kapapirani-ra na'biravini, kidigamo hijanaria kaimoni ida Maria. ");
INSERT INTO padNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bikava'ibodivaranivini kaba'i ida Maria-ra kava'ipahinivini, Deus ibavi kaija'arini abono-ra nanokia'aha vadamia. Bini'aha ada Davi kohana kaija'ari namitharonisiagaki José oniki: —José, hari'a ikava'ibodivaranijana ida Maria-ra ikanagamohavini-ra ikava'ipahinivini. Ni-makhira bivaisaki ida Maria. Ma'onahai Jahaki vania bivaisaja ida. ");
INSERT INTO padNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Makhira isani ada isai Maria biakaijohara. 'Bana'aha inaoni bana ada isai ‘Jesua’. Jesus onina akava'ijoahi abono. Jesus va'ora akava'ijoaki bana adani kidija'ari vakamitharia kaimoni ida vakadihojai asohiriki abosini imai 'banania Ibavi Jaharika'oaki kania — niha ada Deus ibavi kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","'Bo'dakari Deua binava'isohijora'iki ada athi namoniva abono: “Kajahavidoki bana ida ima'inavi. 'Banaha ada isai ija'aria vanaonivini bana ‘Emanuel’.” Nimania ida Deus athi namoniva abono athi afojora. (Emanuel oniki Deus akadiania hojaki.) Hari. Oniaroa, Maria kania namitha'ihi ida athii. ");
INSERT INTO padNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Oniaroa, nokho'afora'aha ada José, binaaba'ihi ida Deus ibavi kaija'arini athi, kidigamo hika'oa'ia kaimoni ida Maria. ");
INSERT INTO padNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Maria kaisai 'banarina oadani Joséa ni-bivi'omapa'itxiki ida kidigamo. 'Bana'ina naothinia Jesus vania Joséa binaoni'aha ada isai. ");
INSERT INTO padNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hari. Judéia kaarabonia 'bana'aha ada Jesus, Belém sidajia. Jesua biva'banaki kari arabo kaka'da'dini ada Iroji. Jesua biva'banaki kari vani, nokiabiininira ada boviri karaho ja'di. Arabo napaja safinia bivikhamananiki kaniaja vahojaki adani makhira boviri-ra vada avani'asibakhiaki, avigaja kaimoni ida namitha'iariki. Vakadihojai oamani hiki ida. Judeus kaija'ari vihiriha adani. Hari. Vanoki'aha ada boviri ja'di, vaabono vakani'akhama'aha: —Judeus kaija'ari vakadika'da'di ja'di 'bana'ina karajomini o boviri ja'di. Anako'dihava ada isai tanaki. Oniaroa, vaibavia ai vihi'aha, Judéia kaarabonia Jerusaléa avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalém sidajia vakaikahi'aha, va'ora vanana'dohi'aha adani sidaji kaija'arini: —Ada hana vania isai 'bana'iki, ovari judeus kaija'ari-ra va'ora vaka'da'diki kaimoni ada? Akadiarabo arihojana vani anokira ada boviri ja'di, safinia bivikhamananiki kaniaja khamananina, kha'aha ada boviri hidiaja. Boviri ja'dia bikarajomiki ida ka'da'di danoki 'bana'ina, oniani hida haria rakhaja hida. Anofiki ida judeus kaija'ari vakadika'da'di-ra akanamasivivini — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Oniaroa, Irojia bikamitha'ihi ida makhira vakaikahina vamonina, bikamitha'ihi ida ka'da'di danoki 'bana'ina varani hina. Iroji ka'da'di hijanarina-ra finivini mani ida Iroji-ra anava'isokonija. Jerusalém sidaji kaija'arini Iroji-ra vifiniki, oniani ida ka'da'di ja'dini kavaranihi-ra avakava'isokonivini hija jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hari. Iroji va'ora baranaha'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama kidiania vajoronina. Va'ora nana'dohi'aha ada Iroji: —Hana hini ibavia 'banaki bana ada ija'ari hahavi vakadika'da'di Cristoa oniki? ");
INSERT INTO padNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Vagathani'ihi ida Iroji kana'dohi: —Judéia kaarabonia, Belém kasidajini vania 'banara bana ada. 'Bo'dakari Deus athi namoniva abono kohana binajiri'iki ida papira afojora: ");
INSERT INTO padNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belém sidaji kaija'arini a'oni. Hari'a avava'ini-ra anaipahihiva ida Belém sidaji pa'itxini. Pa'itxini kaba'i ida avakadisidaji, oniania 'banara bana ada akadija'ari vakadika'da'di. Israel kaija'ari vakadimahi nasohiva kaimoni ada ovari.” Nihi ida Deus athi papira hojaki. Nimania ida Deus athi namoniva abono kajirihi athini — Iroji-ra vani'aha adani judeus kaija'ari vaka'ojomo'iva abono. ");
INSERT INTO padNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Oniaroa, Iroji abono-ra ni'aha: —Va'ora okorijanahaki bana adani makhira boviri-ra vanoki'iki, isai-ra vakaragavini naothinia, ovahonariahiki bana ada abinina. Oniaroa, Iroji va'ora kaboa'i'aha adani makhira boviri-ra vanoki'iki, hi'adani safini khamananina kaniaja vikha'iki. Kidiania vikhajakosi'aha. Ni-ija'ari vahoariha o'oiki vakadiania. Irojia ni-binofiki ida vahoariha vakadivarani avigavini. Hari, va'ora nana'dohi'aha: —Hana hina masiko nokiabiininira ada boviri ja'di? ");
INSERT INTO padNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kidina'dohi vagathanivini naothinia Iroji va'ora karona'aha Belém sidajia avikha'ina. Va'ora honaria'aha: —Avikha'a Belém sidajia mahija isaia bivahojaki ibavini-ra avanana'dohivini. Avakaragaha, vajoi bana hida mahija hora avanava'isohivini. Onofiki jaboni ida isai-ra onavanavanahavini okanamasivira kaimoni — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Oniaroa, Iroji kania ai vihi'aha adani makhira. Hagihia avikharimananina vanoki'ianaha ada boviri ja'di vaviaha okhananavaki. Khai vani'aha ada boviri okhananavaki vanokivini, vava'i jaha'oamanira adani. Jesua bivahojaki namania akhano'aha ada boviri. ");
INSERT INTO padNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Oniaroa, Jesua bivahojaki gora avakhanoha, avikhajakosi'aha, va'ora vanoki'aha adani isai, kidiamia vihiki. Jesus viaha vakajo'atharari'aha vakanamasivi'aha. Oniania, vadaina-ra avarabikhai'aha, vidioni'ihi ida va'iga Jesus kaimoni. Vano'a'aha ouro, incenso, miha hikia. Kaidivaki ida ouro oniki. Misai mitxaki kaidivaki fori hiki ida incenso, miha hiki. ");
INSERT INTO padNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Joma vania Deus va'ora kaabani'aha adani makhira vadamia: —Hari'a bana avajoi Iroji kania! Oniaroa, hagihi hoariha vania vajoi'aha, vakadiarabo-ra avanajoiha'avini. ");
INSERT INTO padNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hari. Makhira ai vihina naothinia, Deus ibavi kaija'arini abono-ra nanokiaha José kania vadamia. José-ra ni'aha: —Irojia bana binofiki binaabinivini ada isai. Gaamanani'a, Egito kaarabonia va'ora avikha'a adani isai, kidiamia vihiki mahija avaraihotavini. Ira onava'isohiravini oadani hari'a vajoi hihida araboa. ");
INSERT INTO padNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Oniaroa, gaamanani'aha ada José. Joma vania ai vihi'aha, José va'ora avikha'aha Egito kaarabonia. ");
INSERT INTO padNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iroji abinirina oadani Egito kaarabonia vahoja'aha. 'Bo'dakari Deua binava'isohijora'iki ida athi namoniva abono: “Egito kaarabonia hojaki bana ada kodisai. Obaranahaki bana ada kodisai joira kaimoni.” Niha ada Deus. Hari. Jesus hoja'iki Egito kaarabonia, naothinia José va'ora avajoi'aha vakadiaraboa. Nimania ida namitha'iki Deus athi namoniva abono binava'isohijoravini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Oniaroa, Iroji va'ora nokhaha adani makhira boviri-ra vanoki'iki vajoina kidiania. Abono-ra ni'aha: —Hora vakorijanaha'iki adani makhira. Jokoa vajoijanariha adani kodiania. Hari, ihamahikaraho'aha ada Iroji. Oniaroa, bikava'ihoki'ihi ida makhira vakadivarani, badara hoarani boviri ja'di-ra vanokibiinini'avini. Va'ora honariaha adani kidisorara isai makhira isani-ra vanaabinihavini. Va'ora ni'aha: —Belém sidajia avikha'a mahija makhira isani-ra va'ora avanako'dihavini sidaji bodinia, sidaji hararania jaboni. Makhira isani badara 'bamikia vakabadarariki, vakabadaraki kaho-ra jaboni avakaraga'ihi, va'ora vanaabini bana. Va'ajihi'aha adani sorara, vanaaba'ihi ida Iroji athi. ");
INSERT INTO padNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nimania ida namitha'iki Deus athi namoniva abono Jeremias onikia bini'a'bo'da'iki: ");
INSERT INTO padNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kamithavahaki ida saani karaho Belém sidajia vakadisai hahavi vaabinina-ra vakaasara'ahapiki'iki adani gamo. Raquel kohana kidisai-ra va'ora kaasara'avini vani fori vihiki adani gamo vabarariariana. Raquea bikaabokariki ida kidisai-ra va'ora navijavavini, oniani ida va'ini najaharini hija.” ");
INSERT INTO padNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Oniaroa, abini'aha ada Iroji. Iroji abinina naothinia Deus ibavi kaija'arini abono-ra nanokia'ianaha José kania vadamia. Asia Egito kaarabonia vahojaha adani José. ");
INSERT INTO padNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Deus ibavi kaija'arinia bini'aha: —Vaabinihahavi'iki adani isai-ra vanaabinivini-ra vanofiki. José, gaamanani'a va'ora avajoi'a adani isai, kidiamia vihiki Israel kaarabonia. ");
INSERT INTO padNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hari. Oniaroa, ai vihi'aha adani José, va'ora avikhaha adani isai, kidiamia khama. Israel kaarabonia avajoi'aha. Judeus kaija'ari vaonina hoariha Israel kaija'ari. ");
INSERT INTO padNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hari, Joséa bikamitha'ihi ida ija'ari vakadivarani: —Abini'iki ada arabo kaka'da'dini Iroji. Judéia kaarabonia hojaki ada Iroji kohana kaisai Arquelau oniki, ovari maina ada Judéia kaaraboni kaija'arini vakadika'da'di hira — vakhani'aha. Oniani ida José vajoina-ra finivini hija. Vadamia Deua binava'isohi'ianaha ada José: —José, hari'a Judéia kaarabonia avajoi! Galiléia kaaraboni maina avikha — Deua bini'aha ada José vadamia. Oniaroa, avikha'aha Galiléia kaarabonia. Avakhano'aha. ");
INSERT INTO padNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaré sidaji oniki vania vahoja'aha. Nimania ida namitha'iki Deus athi namoniva abono kohana va'ora nava'isohijoravini hi'iki: “Nazaré sidaji kaija'arinia vanaoniki bana ada ovari okaronaki.” Niha ada Deus. ");
INSERT INTO padNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hari. Nazaré sidajia hojana kaba'i ada Jesus, Judéia kaarabonia khaha ada makhira Deua bikaronaki, onina João Batista. Amasia hojaki ada. Kagorarihi ida amasi. João Batista kania avikhaha adani ija'ari, va'ora ni'abakhia'aha: ");
INSERT INTO padNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Avakadihojai asohiriki-ra vakava'ipahinika'oa'a bana. Maakariki ida mahi Deus ija'ari hahavi-ra vaka'da'divini — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","'Bo'dakari Deus athi namoniva abono, Isaías kohana onikia vara bivani'ajora'iki ada João Batista. Isaías kohana athi jiriki hojaki Deus athi kapapirani pitania, niha: “Amasia hojaki ada makhira, ija'ari-ra vara ni'a'aha athi 'barakia: ‘Amaakariki ida avakadika'da'di kaikahina kamahini. Vanasohi bana ida avakadimahi, avakadika'da'di khana-ra vanaviahanokha bana!’ ” Nihi ida Deus athi. ");
INSERT INTO padNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","João Batista ni-bikaimahaki ida makari kaidivaki, kidimakari hiki ida camelo asafi amonahaki. Bikaimahaki jaboni jararia baasafi kacinturãohi. Kidi'bai hiki omavari, bahina a'bana hiki. Elias kohana kamakari, kidi'bai, kidihojai fori hiki ida João Batista kahojai. ");
INSERT INTO padNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalém sidaji kaija'arini vaipohiki João Batista kani-ra avanikhabakhiaki. Judéia kaaraboni kaija'arini jaboni vaipohiki João Batista kani-ra avanikhabakhiaki. Jordão vainia hojaki ida ibavi ipohiki kaija'arini João Batista kani-ra avanikhabakhiaki. Vaipohi'oamanira adani ija'ari João Batista kavarani-ra vakamithavini-ra vanofiki. ");
INSERT INTO padNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Vakava'ipahinivini vanofivini ida vakadihojai asohiriki afohahavi, oniania Deus kania vara vavani'avini Deus bina'biraja kaimoni. Vara vavani'avini naothinia, João Batista va'ora kana'aha afohanana Jordão vaini onikia. ");
INSERT INTO padNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hari. João Batista kania avikhaki adani farisio vaipohiki, sadosio vihiki. Farisio vaoniki vanaabajahakiki ida vakadija'ari avikhananavaki vakadihojai. Vanofiki jaboni João Batista va'ora kanavini. João Batista va'ora ni'aha: —Jahari kabadani-ra avakava'ipahinivini-ra avakahi'badaraki a'oni. Deua bikaronaki bana ida avakadihojai asohiriki abosini. Ni-avakaabokaki ida Deu-ra avakorijanahavini. ");
INSERT INTO padNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hojai asohikia vakahojai'a bana mahija Deus biogavini ida avakadihojai asohiriki-ra avanofijanaravini. ");
INSERT INTO padNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hari'a vakava'ibodivarani: “Deus va'ora nagathogatho'bo'da'iki adani Abraão, kidihanodi vanamitharonisiagaki vihiki, kidija'ari vihira kaimoni. Jahaki ada akadiabi'i okhananavaki Abraão kohana, oniani ida akadihojai asohiriki Deua bikava'ibodiravini hija, haria akava'ijoaki bana ada Deus.” Nimania ida avaabononi avani'a'badaravini. Asohiki ida Abraão kahojai. Avakadihojai ni-asohiki. Abraão kaisai vavijavaronisiagaki avihini kaba'i, ni-Deus a'onira akava'ijoaki. Deus va'ora akava'ijoaki adani vakadihojai asohiriki-ra vakava'ipahini'iki. ");
INSERT INTO padNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ihi'ai avani fori avihiki a'oni. Hojai asohikia avakahojairihi; ihi'ai avani bonobakhiariki fori avihihi. Makhira kajoriki fori hiki ada Deus. Khaki bana ada makhira binobaja kaimoni ida ihi'ai avani bonobakhiariki 'damani. Binahokahiki ida ihi'ai avani obaki siho kabodinia. Nini vani jaboni Deus va'ora arakhaki bana adani athi naabani vihiriki nahina jaharikia — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Asia João Batista va'ora vara ni'aha adani ija'ari vajoroniki: —A'onira okanaki ho paha bodinia. Avakadihojai asohirikia avaabononi avaka'da'digariavini-ra avigara kaimoni adani vahoariha. Khaki bana ada hoariha, ka'da'di ka'oa ada ovari. Hovani kidihonai abono ho. Arafiaki ida kidihojai asohika'oani. Kodihojai jahani fori hirihi ida kidihojai jahani arafiaki, kaba'i hora nagathogathovini oakodiara kaimoni. Ovaria bikaronaki ada Ma'onahai Jahaki ija'ari va'ini-ra nahonariahihiki kaimoni. Siho kakhororoki fori hiki bana ada Ma'onahai Jahaki ija'ari kania. Binihimaki bana ida ija'ari kahojai asohiriki — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Vara ni'ianaha ada João Batista. Ija'ari-ra kavarajomivini ida trigo 'ba'dani aka'diririhaki: —Aka'diririhaki ida trigo 'ba'dani aaniaja kaimoni ida ba'ba'da asafini. Anabavihi ida trigo 'ba'dani so'oroa. Siho kabodinia anahokahi'ihi ida asafini. Nimania jaboni ida onaothia khaki ija'ari-ra kanahoarihakhamavini. Va'ora aniki adani ija'ari hojai asohirikia vakahojaiki, ija'ari hojai asohikia vakahojaiki vahararana. Ovari va'ora vahojaki adani ija'ari hojai asohikia vakahojaiki kidiania. Va'ora nahokahiki adani hojai asohirikia vakahojaiki Ibavi Jaharika'oaki siho kaihimiriki kania — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oniaro kari, Galiléia kaarabonia hojaha ada Jesus. Hari. Oniaroa, ajihi'aha, okha'aha, Jordão vaini onikia akhanofoni'aha, João Batista-ra ni'aha: —Hora kana'a bana! ");
INSERT INTO padNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hari. João Batista bini'aha ada Jesus: —Iniani, ni-Jahari kabadania ikabadanirihi ikava'ipahinija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesua bini'aha: —Kaba'i, jahaki ida hora ikanavini. Hora ikanahi; Deua binofikia akabadanihahavihi — niha ada Jesus. Oniaroa, João Batista bikana'aha. ");
INSERT INTO padNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus kanana naothinia ogaimori'aha. Binoki'ihi ida nama arabikhajahaki. Binokiha jaboni ada Ma'onahai Jahaki gaari'ina kidiania, ho'doko aagariki fori hiki. ");
INSERT INTO padNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nama kamithavahaki ida athii: —Hi'o kodisai o. Onofijahakiki o. Khai oni'aki ida kodisai hojana. ");
INSERT INTO padNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","3","Hari. Oniaroa, Ma'onahai Jahakia biavikha'aha ada Jesus amasia, 40 mahi hoja'aha. Kaija'aririhi ida amasi. Ni-nahina-ra haki. 'Bairina mani ida Jesu-ra navai'ami'ia. Oniaroa, okha'aha ada Jahari Jesus kania. Bikaboroboro'aha ada Jesus bada bini'aja kaimoni ida badani Deua binofiriki. Jesua ni-bikapoaripa'itxiki ida athi. Jaharia bini'aha: —Deus kaisai ihihi, ja'di-ra 'bai aniha'a. ");
INSERT INTO padNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesua bini'aha: —Iniani, ni-Deus hora honariaki ja'di-ra 'bai oanihavini. Deus athi kapapirania hojaki hida athi: “Ni-'bai ka'oa binahokiki ida ija'ari. Deus athi hahavi-ra anaabavini mani ida ija'ari-ra nahokija.” — Jesua bini'aha ada Jahari. ");
INSERT INTO padNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Oniaroa, Jerusalém sidajia Jaharia biavikha'aha, ija'ari Deu-ra khai vani'avini kagorani 'da'dini a'ani sohiriama'oki kania, bini'aha: ");
INSERT INTO padNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Deus kaisai ihihi, araofarari'a bana nabo'ajaja. Deus athi kapapirania bini'aki: “Deus va'ora honariaki bana adani ibavi kaija'arini kadania ira avagathanivini, ivigarirariria kaimoni ida ja'di, iabononi a'bororia kaimoni jaboni.” ");
INSERT INTO padNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesua bigathanihi ida athi: —Iniani. Jokoa iathini-ra onaabarihi. Jokoa oaraofararirihi. Deus athi haria nava'isohiki hari jaboni: “Hari'a Deu-ra kaijo'a bana badani danokia kabadanina, iogaja kaimoni ida Deus hojana kadania.” ");
INSERT INTO padNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Oniaroa, arabo namahikia Jaharia biavikhaha ada Jesus. Binanokiahivini vihiha adani arabo hahavi kaija'arini, vakadiarabo, vakadinahina hiki. Jaha'oamanija ida hahavi Jesu-ra nanokiahivini hi'iki. Bini'aha ada Jesus: ");
INSERT INTO padNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Oviaha ikajo'athararihi hora ikanamasivivini, oniani ida hahavi ira onanokiahivini hi'ikia ira ono'avini hija bana — niha ada Jahari, Jesu-ra kaboroborovini, bada bini'aja kaimoni ida Deua binofiriki. ");
INSERT INTO padNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Oniaroa, Jesua bini'aha: —Jahari, ajihi'a. Jokoa ira okanamasivirihi. Deus athi kapapirania hojaki ida athi haria nava'isohiki kaimoni: “Deus ka'oa-ra kanamasivi'a bana avakadika'da'di hira kaimoni. Deus athi ka'oa-ra vanaaba'a.” — Jesua bini'aha ada Jahari. ");
INSERT INTO padNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oniaroa, ajihi'aha ada Jahari. Jesus kania vikha'aha adani Deus ibavi kaija'arini Jesu-ra vaakodiahavini. Naothinia, ajihi'aha ada Jesus amasia. ");
INSERT INTO padNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hari. Arabo kaka'da'dinia bivahonariahi'aha ada João Batista gathana cadeia avibaira kaimoni. Jesua bikamitha'ihi ida João monina cadeia hojana, oniani ida Galiléia kaarabonia arakhana hi'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ni-Nazaré sidajia ibavijanaki ada Jesus. Cafarnaum kasidajini vania okha'aha, hoja'aha. Galiléia ka'dakoni maakarinia hojaki ida Cafarnaum sidaji. Zebulom Naftali kaarabonia hojaki ida 'dako. ");
INSERT INTO padNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","15","Mahi 'bo'dakari Deus athi namoniva abono Isaías onikia bini'a'iki: “Deus va'ora kajoamoraki bana adani Zebulom kaaraboni kaija'arini, Naftali kaaraboni kaija'arini vihiki. Jordão vaini kahararakhamania hojaki ida vakadiarabo. Galiléia kaarabonia oniki jaboni ida vakadiarabo. Ni-Deu-ra avigariha adani. ");
INSERT INTO padNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bakibakiki fori hiki ida vakadiarabo vavaibaviki. Hari. Vanokiki bana ida vagani fori hiki karaho. Vagahahaviki bana ida vaibavi. Va'ora navagaki bana adani ija'ari vaabiniki fori vihiki. Ni-Deu-ra avigariha adani.” Nimania ida Deus athi kapapirani Isaías kohana binajiri'iki. Isaías kohana vara bivani'a'bo'da'iki hihida vaibavia Jesus aadahaonina, oniani ida kidivarani nanamithani hi'ia. ");
INSERT INTO padNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hari. Cafarnaum sidajia Jesus hojana vara bivani'a'ihi ida moni jahaki. Va'ora ni'aha adani ija'ari: —Avakadihojai asohiriki-ra vakava'ipahinika'oa bana. Maakari'iki ida mahi Deus ija'ari hahavi-ra vaka'da'divini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Oniaroa, Galiléia 'dako vadinia khabaoniha ada Jesus. Va'ora kanokiha adani araba abono vi'bamiki vakatahafahaki. Aajojahiki Simão Pedro, kajo'ojahiki André. ");
INSERT INTO padNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Va'ora kani'aha ada Jesus: —Hora vavaipohiha mahija badani hoariha a'onira oka'ojomo'ivini. A'onira oka'ojomo'ivini hiki ija'ari vahoariha-ra avakaboa'ivini kodija'ari vihira kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Oniaroa, vakahagi kabodinia vakanahojaha'ihi ida vakaditahafa, Jesu-ra vavaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Avikha'ianaha adani Jesus, va'ora vakanokiha adani araba abono vakahoariha vi'bamiki vakadiabi'i khama. Aajojahiki Tiago, kajo'ojahiki João. Vakadiabi'i Zebedeu oniki. Vakahagi kabodinia vahojaki adani. Bada vakhaniki adani tahafa-ra avakanaja'divini. Jesus va'ora baranahaha adani vi'bamiki: —Hora vavaipohiha! ");
INSERT INTO padNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jorakia vakahagi-ra vakanahojaha'aha. Vakaamina'aha ada vakadiabi'i. Jesu-ra vavaipohiha'aha. Avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hari. Galiléia kaaraboni kaibavinia aadahaoni'aha ada Jesus. Judeus kaija'ari Deu-ra vara vani'avini kagorani vaipohikia okhajakosioni'aha. Va'ora aka'ojomo'ioniha adani ija'ari. Jesus va'ora akanamonionivini hida Deus athi, ija'ari hahavi vakadika'da'di ada Deus. Va'ora anaihotaki jaboni adani ija'ari vakavamoniki. Ipohiki ida vakadikavamoni. ");
INSERT INTO padNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Síria kaaraboni kaija'arini vaipohikia jaboni avananamithaoni'ihi ida Jesus ija'ari-ra anaihotavini kavaranihi. Oniania va'ora vavikha'aha adani ija'ari vakavamoniki, vakabajadiki, varai'abakhiaki, vajo'o aba'oronisiagaki vihiki. Kavamoni ipohiki-ra vavahojaki adani ija'ari, va'ora vavikha'aha Jesus viaha. Jesus va'ora anaihotahahavimani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ija'ari vaipohiki Jesu-ra vavaipohiha'aha. Galiléia kaaraboni kaija'arini, Judéia kaaraboni kaija'arini, Decápolis kaaraboni kaija'arini, Jerusalém sidaji kaija'arini vihiki Jordão vaini banininiaja vahojaki Jesu-ra vavaipohiha'iki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Hari. Jesus va'ora noki'aha adani ija'ari vaipohiki. Oniania, ogaimori'aha arabo namahikia vithima'o'aha, kidipohi-ra va'ora ka'ojomo'ira kaimoni. Vajoroni'aha kidiania vavithiribanaoni'aha. Jesus va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Deus hora kajoamorarihi; ni-nahina-ra okaabokaki.” Nihi ida ija'ari. Nini vani Deua bivaka'da'diki ida ija'ari. ");
INSERT INTO padNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Jahari kabadania okabadanina mani hida hora naasaraja.” Nihi ida ija'ari. Deus vania binava'ijahaja bana ida ija'ari. ");
INSERT INTO padNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Jokoa hovani ka'oa oabono ovaka'da'dirihi. Deus hora vaka'da'divini-ra onofiki ho.” Nihi ida ija'ari. Nini vani, nahina hahavi araboa hojaki-ra vaka'da'diki ida ija'ari. ");
INSERT INTO padNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Onofi'oamanija ida badani Deua binofiki bada oni'avini.” Nihi ida ija'ari. Nini vani Deua bikajoamoraki hida ija'ari, bada bini'aja kaimoni hida badani Deua binofiki. ");
INSERT INTO padNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Onofiki ida hoariha-ra ova'adivini, ni-onamakhaniki.” Nihi ida ija'ari. Nini vani Deua biva'adija ida ija'ari. ");
INSERT INTO padNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Ni-onofipa'itxiki ida Jahari kahojaia okahojaina. Deus kahojai ka'oa vani ida onofija.” Nihi ida ija'ari. Nini vani binokira bana ada Deus. ");
INSERT INTO padNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Oanariakaki ida hoariha ihamahiki.” Nihi ida ija'ari. Nini vani ida ija'ari kahojai, Deus kahojai fori hija, oniani ida kidisaia Deus ija'ari-ra naonivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Deua bikajoamoraki ida ija'ari abononi nava'ibodivaraniki: “Hora vanajaharihariki adani, kaba'i bada oni'aki ida badani Deus hora honariavini hi'iki.” Nihi ida ija'ari. Nini vani Deua bivaka'da'diki ida ija'ari — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Vara ni'ianaha ada Jesus: —Kodipohi avihini mani ida vahoariha onii jaharikia a'onira vani'avini hija, a'onira vanajahariharivini hija jaboni, korijanahia vara vavani'aki bana ida varani avihini jaboni. Hari'a avava'ini soko iniva bana. Deus a'onira kajoamoraki bana a'oni. ");
INSERT INTO padNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","A'onira vanajahariharivini kaba'i, khai vakhani bana. Deua binaibavijahaki ida kidija'ari vajaharihariki vakadimoni kidinahina jahaki kidiania, va'ora naabosira kaimoni. Onivani fori vihiki jaboni adani Deus athi namoniva abono kohana. Mahi 'bo'dakari vajaharihari'iki jaboni adani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Hari. Jesus va'ora ni'aha adani kidipohi: —Jokira fori avihiki a'oni. Avakajokirahi ida baimana; ni-'baxaki. Hojai jahakia avakahojaihi; ija'ari vahoariha hojai jaharikia vakahojaiki-ra avanadabahi. Avaabononi avakava'igairi bana! Nahina binajaharihi ida jokira; ni-ponini jahajanaki. Hokahika'oaki ida jokira jahajanariki ija'ari vaadahakia vakada'aha'aha'iki ida. A'onivani jaboni, nahina bana binajahariki bana ida avakadihojai; ni-avajahajanaki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lamparina fori avihiki a'oni. Aha'diki ida lamparina, ni-bakibakini kania vahojaki adani ija'ari. Vagaki fori hihi ida avakadihojai jahaki; Deus kahagihi-ra anavagahi ija'ari hahavi vakadimoni. Hari. Sidaji arabo namahiki namania hojaki fori avihiki a'oni. Ahojariki ida sidaji. Ahojariki jaboni ida avakadihojai, ija'ari hahavia vanokiki ida. ");
INSERT INTO padNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Varaja akaasiaki kabodinia ahojaki kaimoni hirihi ida lamparina aha'diki. Anaibavihi ida lamparina aha'diki nama, ija'ari gora bodinia vahojaki-ra navagaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lamparina vagani fori hiva ida avakadihojai jahaki. Onofiki ida ija'ari vahoariha avakadihojai jahaki-ra vanokivini. Avakadihojai jahaki-ra vanokiha; khai vani'aha ada avakadiabi'i nama hojaki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesus va'ora ni'aha: —Hari'a avaabononi vani'a bana: “Kha'aha ada Jesus, binihimaja kaimoni ida Deus kava'isohihi jiriki Moisé-ra nava'isohi'bo'davini hi'iki. Binihima'iki jaboni ida ojomo'ihi kavaranihi Deus athi namoniva abono va'ora nava'isohi'bo'davini hi'iki adani akadija'ari avikhananavaki.” Hari'a vakava'ibodivarani hida athii-ra avanaabajanaravini. Onihimavini kaimoni hirihi ida hora rakhaja hida. Hora rakhaki ida ija'ari-ra va'ora onava'isohijahakivini Deus kava'isohihi jiriki nahina hini ida binofiki vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Vakava'ihoki bana hida kodivarani. Nama, arabo hiki hojani oadani, ni-ihimirihi ida Deus kava'isohihi, ni-athi pitani pa'itxi hoarani Deua bini'aki avisonirihi, namithahahaviki bana ida varani Deua bini'aki. Namithahahaviki bana ida varani Deua bivava'isohihijora'iki, nama, arabo hiki ihimini viahania. ");
INSERT INTO padNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ija'aria bikajoniki ida Deus kava'isohihi jiriki pitani pa'itxi, va'ora ka'ojomo'ivini hiki jaboni adani vahoariha Deus athi-ra vakajoniki, Deus ija'ari-ra vaka'da'divini kamahini ni-Deua biva'ahaki ida ija'ari vahoariha-ra va'ora vaka'da'divini. Ija'aria binaabahi ida Deus kava'isohihi jiriki, va'ora ka'ojomo'ivini hiki jaboni adani vahoariha vanaabavinia, Deus ija'ari-ra vaka'da'divini kamahini Deua bihonariaki bana ida ija'ari vahoariha-ra va'ora vaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A'onira onava'isohivini judeus kaija'ari vaka'ojomo'iva abono, farisio khama jaboni vaabono vara vavani'a'badaraki: “Jahaki ida akadihojai. Anaabajahakiki ida Deus kava'isohihi jiriki.” Vakhani'badarana. Ni-vanaabajahakiki ida Deus va'ora honariavini hiki. Va'oaniaro fori avihihi; ni-Deua khai bini'aki bana ida ka'da'di avihini kidiania. ");
INSERT INTO padNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","22","Asia vara ni'aha ada Jesus: —Avakamithabakhia'iki ida Deus kava'isohihi jiriki avakadija'ari avikhananavaki-ra va'ora no'avini hi'iki: “Hari'a kaabini. Ija'aria binaabinihi ida hoariha, ija'ari nasohiva abono viaha vahoariha avisahi ida ija'ari. Nasohiva abonoa bihonariaki kaabiniki abinini ka'da'di kaabosini hina.” Asohiki ida Deua bivava'isohihi'bo'daki athini. Hovani a'onira onava'isohijahakiki ho bana Deua binofikia. Iigamini-ra ikaihamahihi; Deua bihonariaki ida Jahari kabadani abosini-ra igathanivini. Ija'aria bini'ahi ida igamini: “Ijahari'oamanija.” Deua bihonariahi bana ida ija'ari Jahari kabadani abosini-ra gathanija kaimoni. Ija'aria bini'ahi ida igamini: “Iva'ihariki fori ihiki i, ni-nahina-ra iogarihi.” Deua bihonariaki vahabini bana ida ija'ari Ibavi Jaharika'oaki siho kabodinia okhani. ");
INSERT INTO padNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Deu-ra khai ani'avini kagorania ihojani vani ikava'ihokiki ida iigamini ira kaja'oriavini, hari'a bana Deu-ra kanava'iga kaho. Inako'di'imidia ada iigamini mahija ianariakavini. Naothinia ajoi'iana bana Deu-ra khai ani'avini kagorania mahija Deu-ra ikanava'igavini. ");
INSERT INTO padNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ija'ari ira anaathidanoarariki badani asohirikia ikabadaninia. Inasohijoraki bana ida avakadivarani. Ija'ari vakadihojai hiki ida ihamahiki-ra anariakajorakivini. Bianariakahi; ni-pohimajaki. Bianariakarihi; ija'ari nasohiva abonoa jaharikia biarakha'ihi. Ija'ari nasohiva abono ira arakhaki bana i sorara vasa'a kabodinia. Sorara ira obaiki bana i cadeia. Ija'ari nasohiva abono ira honariaki bana kadabadani asohiriki-ra inaabosivini jiniro karahoa. ");
INSERT INTO padNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ka'oa hiki hida kodivarani. Inaabosihahaviravini oadani ida jiniro, ni-cadeia iokhaonaniki bana. Jahari kabadania ikabadanihi; jorakia bana Deu-ra anariaka'a mahija jaharikia ira arakharavini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Vara ni'ianaha ada Jesus: —Avarigaki ida Deus kava'isohihi jiriki: “Hari'a makhira bivi'omava ida hoariha kagamo. Hari'a gamoa bivi'omava ada hoariha kamakhira. Jahari kabadani ida hojana hiki.” Asohiki ida Deua bivava'isohihi'bo'daki athini. ");
INSERT INTO padNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hovani a'onira onava'isohijahakiki bana Deua binofikia. Makhira vada bini'ahi ida gamo kidigamo hiriki, bivi'omavini binofiki ida, ovari va'i bodinia bivi'omaki fori hiki ida gamo. ");
INSERT INTO padNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ija'aria binokiki ida Jahari kabadani, binofiki ida bada bini'avini, bianivini jahaki ida nokhoni 'ba'dani aniaja, binahokahi'ihi ida nokhoni 'ba'dani bada bini'aria kaimoni ida Jahari kabadani. Jahari kabadani-ra bada ni'ahi; Ibavi Jaharika'oaki kania hokahihi. Jahariki ida abononi hahavi Ibavi Jaharika'oaki kania hokahini. Jahaki ida nokhoni 'ba'dani hoaranini kaba'i, Deus Ibavi Jahaka'oakia okhani. ");
INSERT INTO padNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ija'aria binofihi ida Jahari kabadani-ra bada ni'avini, biakava'boavini kajahaki ida sa'ani aniaja kahokahini, bada bini'aria kaimoni ida Jahari kabadani. Jahariki ida abononi hahavi Ibavi Jaharika'oaki kania okhani. Jahaki ida sa'ani kahoaranini kaba'i Deus Ibavi Jahaka'oaki okhani. ");
INSERT INTO padNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","32","Hari. Vara ni'iana ada Jesus: —Hojaki ida Deus kava'isohihi jiriki hoariha: “Makhira binofiki ida kidigamo-ra nahojahavini, binahojahavini viahania kidigamo-ra no'avini hiva ida papira jiriki kidigamo hijanaria kaimoni.” Asohiki ida Deua bivava'isohihi'bo'da'iki athini. Hovani a'onira onava'isohijahakiki bana ho Deua binofikia. Gamo makhira hoariha-ra vi'omaravini kaba'i kidimakhira binahojahahi, gamo hoariha-ra anakarara kaimoni, Jahari kahojaia kahojaiki ada makhira. Makhira hoariha bianakara'ihi ida gamo kidimakhira binahojaha'iki, jaharihi ida hojani hi'iki. Jaharihi jaboni ida makhira anakarani hi'iki kahojai. ");
INSERT INTO padNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","34","Asia vara ni'aha ada Jesus: —Avarigaki ida Deus kava'isohihi jiriki avakadija'ari avikhananavaki-ra va'ora no'avini hi'iki: “Deu-ra vara ini'avini hiki ida badani bada ini'aja kaimoni kidimoni, bada ini'a bana, hari'a inava'iponi'imarini bana.” Asohiki ida Deua bivava'isohihi'bo'daki athini. Hovani a'onira onava'isohijahakiki bana ho Deua binofikia. Ija'ari-ra inava'isohivini hiki ida badani bada ini'aki kaimoni, bada ini'a. Hari'a Deus onina-ra dioni, hoariha biogaja kaimoni ida iathini ka'oa hini. Hari'a nama onini-ra dioni jaboni biogaja kaimoni ida iathini ka'oa hini. Deus kavithi ibavini ida nama. ");
INSERT INTO padNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hari'a arabo onini-ra dioni jaboni hoariha biogaja kaimoni ida iathini ka'oa hini. Deus 'dama kakatirani ida arabo. Hari'a Jerusalém sidaji onini-ra dioni, hoariha biogaja kaimoni ida iathini ka'oa hini. Ija'ari hahavi vakadika'da'di danoki kasidaji ida Jerusalém. ");
INSERT INTO padNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hoariha-ra inava'isohivini hiki ida varani bada ini'a'iki kidimoni, hari'a i'da'dini onini-ra dioni, hoariha biogaja kaimoni ida ka'oa hini kadavarani. Ni-ikaabokaki ida ika'da'dini kaafani kahoarani-ra ikanavaforivini, ni-ikanapororovini, ni-ikaabokaki ida iabononi-ra ivaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hoariha-ra inava'isohivini hiki ida badani inamonahaki, inamonaha'a bana. Hari'a inava'iponi'imarini bana ida hoariha. Jahari kavarani ida hoariha-ra inava'iponi'imarinivini kavaranihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","39","Asia vara niha ada Jesus: —Avakadi'ojomo'ihi abono a'onira vanava'isohibakhiavini hiki ida Deus kava'isohihi jiriki: “Ija'aria bianahahahi ida hoariha nokhoni 'ba'dani, jakaho bina'da'diabosiva bianahahavini jaboni ida nokhoni 'ba'dani. Ija'aria bianahahahi ida hoariha inoni, jakaho bina'da'diabosiva bianahahavini jaboni ida inoni.” Asohiki ida Deua bivava'isohihi'bo'daki athini. Hovani a'onira onava'isohijahakiki bana ho Deua binofikia. Ija'ari hojai jaharikia vakahojaiki avakadiania, hari'a vana'da'diabosi bana. Ija'ari i'ba'dani-ra kapatahi, hari'a iana'da'diabosi bana. Jahaki ida iroiribanini pitanija bikapataja kaimoni jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ija'ari ira najahariharikia binofiki ida ija'ari nasohiva abono ira honariavini kadamakari-ra iarakhavini, iva'aha bana jaboni ida kadamakari hoariha-ra saarivini. ");
INSERT INTO padNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sorara ira gathihi daina ikaiba'ija kaimoni kidimoni napaja hirikia. Ikajoamoravini ikaiba'i bana ida daina napaja kidimoni. ");
INSERT INTO padNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ija'aria bikanikhariahi ida kadanahina, ino'a bana. Ija'aria birihavini binofihi ida kadanahina, ikanarihaivinihi bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","44","Asia vara niha ada Jesus: —Avakadi'ojomo'ihi abono a'onira vanava'isohibakhiavini hiki ida Deus kava'isohihi jiriki: “Va'ora nakaidiva bana adani kadava'ahi ka'oa. Hari'a va'ora nakaidiva adani vaimajahahiriki.” Vakhaniha. Hovani a'onira onava'isohijahakiki bana ho Deua binofikia. Va'ora nakaidiva bana adani a'onira vakaimajahariki. Deu-ra vakanikharia mahija a'onira vanajaharihariki-ra va'ora nakaidivavini. ");
INSERT INTO padNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Deus va'ora kajoamoraki adani ija'ari hojai jahakia vakahojaiki, ija'ari hojai jaharikia vakahojaiki vihiki. Deua binavagaki ada safini ija'ari hojai jahakia vakahojaiki, ija'ari hojai jaharikia vakahojaiki vanamana. Deua bihonariaki ada bahi ija'ari hahavi vakadimoni hina, ija'ari kahojai jahaki, ija'ari kahojai jahariki vakadimoni jaboni ada bahi. Vahoariha va'ora avakajoamoraki a'oni, oniani ida kodiabi'i kaisai a'onira nihaja. Deus va'ora kajoamorahahaviki adani ija'ari vajahaki vajahariki. Deus kahojaia vakahojai'a bana. ");
INSERT INTO padNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ija'ari Deu-ra avigariki va'ora vanakaidivavini adani nofini vihiki. Ija'ari hahavi hojani hiki ida nofini hiki-ra nakaidivavini. Avakadihojai jaboni ida va'ora avanakaidivaki adani a'onira vanofiki. Va'ora nakaidiva jaboni bana adani a'onira vanofiriki. Va'ora avanakaidivariha; ni-Deus avajahani arafiani-ra kahiki. Ni-Deus avakadihojai-ra naabosiki kidinahina jahakia. ");
INSERT INTO padNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Avakadihojai hiki va'ora avanavaravaraki adani avakadiva'ahi. Ija'ari Deu-ra avigariki jaboni va'ora vanavaravaraki adani nofini vihiki. Va'ora vanavaravara jaboni bana adani a'onira vanofiriki. Va'ora avanavaravarariha adani a'onira vanofiriki; ni-Deus avakadihojai jahani arafiani-ra kahiki. Ni-Deus avakadihojai-ra naabosiki kidinahina jahakia. ");
INSERT INTO padNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Deua binofiki ida ija'ari hahavi-ra va'ora avanakaidivavini. Nimania ida kidihojai jahaki. Kidihojai jahaka'oakia vakahojai'a bana. Jahaka'oaki ada avakadiabi'i nama hojaki. Ovari fori vihi'a bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Asia vara ni'aha ada Jesus: —Avaabononi avakava'igairi bana! Hari'a avaabononi vavaboraboraha! Hari'a avaabononi vara vani'a afohanana: “Onofiki ida vahoariha ojahana-ra vanokivini, oniani ida kodibadani jahakia va'ora onanokiahivini hija.” Hari'a vanokivini vanofi. Vanokivini avanofihi; ni-avakadiabi'i nama hojakia binaabosiki bana ida avakadibadani jahaki kidinahina jahakia. ");
INSERT INTO padNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kanahinariki-ra ino'avini hiki ida kadanahina, hari'a ija'ari hoariha-ra nanamitha bana ino'avini hikia. Ija'ari abononi vaboraborahakia bivajahaki ida vahoariha avigavini, oniani ida kagahinaibakhiani-ra kahibakhiavini hija. Judeus kaija'ari Deu-ra vara vani'avini kagorania abononi vaboraborahaki ida, hagihia adahaki abononi vaboraborahaki jaboni, ija'ari vahoariha-ra va'ora ananamithaonivini hiki ida kanahinariki-ra kajoamora'avini. Binofiki ida kidihojai jahaki-ra vara vani'avini khai vani'avini. Vakava'ibodivarani'a bana hida kodivarani. Ija'ari abononi vaboraborahahi; ni-Deua binaabosiki ida kanahinariki-ra kajoamoravini kidinahina jahakia. Kanahinariki-ra kajoamoravini abosinia gahina'iki hida ija'ari vahoariha kidihojai jahaki-ra vara vavani'avini. ");
INSERT INTO padNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ija'ari kanahinariki-ra ikajoamoravini kamahini, ahojaia ino'a bana mahija ija'ari hoariha ino'avini biogaravini, ni-kadava'ahi, ni-kadaija'ari igorani maakarinia hojakia biogavini jahaki. ");
INSERT INTO padNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hari'a avaabononi vavaboraboraha. Hari'a avakadibadani jahakia vahoariha-ra va'ora vananamitha. Avakadiabi'ia binokiki ida ahojaia kanahinariki-ra ikajoamoravini, ovaria binaabosiki bana ida kadabadani jahaki kidinahina jahakia. ");
INSERT INTO padNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Asia vara niha ada Jesus: —Deu-ra vara avani'avini, hari'a ija'ari abononi vaboraborahaki fori vihi. Va'oaniaro vavajahaki ida judeus kaija'ari Deu-ra vara vani'avini kagorania vigaana, vahoariha vanokija kaimoni ida Deu-ra vara vani'avini. Vavajahaki ida ija'ari vaipohikia vavaradahaki kania Deu-ra vara vani'avini, vahoariha va'ora vanokira kaimoni. Vakava'ibodivarani bana hida kodivarani. Ija'ari abononi vaboraborahahi; ni-Deua binaabosiki ida ija'ari. Deu-ra vara ni'avini abosinia gahina'iki hida ija'ari vahoariha kidihojai jahakia vakavaranina. ");
INSERT INTO padNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A'onivani, Deu-ra vara avani'avini, avagorani katokinia avikha afohanana bana, vaaka'oaha bana ida bakatha mahija hoariha a'onira nokiravini. Nokiariha ada avakadiabi'i nama hojaki. Ahojani kaba'i ida vara avani'avini kidimoni, ovaria binokiki ida, a'onira no'avini hiki bana ida avakanikhariavini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Deu-ra vara avani'avini vani hari'a vidioni'imarini afobakhia ida avaathini Deu-ra avani'avini hi'iki. Vakhanimanira adani ija'ari Deu-ra avigariki. Deua bikamithaki vavanihaki ida vakadivarani vana'oadaki. ");
INSERT INTO padNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hari'a va'oaniaro fori vihi. Deu-ra vara avani'avini viahania, ovaria biogaki ida nahina avakainamoki. ");
INSERT INTO padNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nimania bana hida varani Deu-ra vara avani'avini kaimoni: “Akadiabi'i nama ihojaki i. Anofiki ida ija'ari hahavi ijahaka'oani-ra avigavini. ");
INSERT INTO padNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anofiki ida ija'ari hahavi-ra va'ora ivaka'da'divini. Kadania nama vahojakia khai vani'aki ida kadabadania vakabadanina. Anofiki ida va'oaniaro fori arihina badani inofikia akabadanina jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hidakaba'i haria no'a bana 'baia, arihaki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Anofiki ida akadihojai asohiriki-ra ina'biravini. Vahoariha vakadihojai asohiriki akadiania aakava'i'birinivini vani fori hini anofiki jaboni ida akadihojai asohiriki-ra iakava'i'birinivini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Haria kajoamora bana mahija kaborohirohi arihina kaba'i, Jahari athi-ra akamitharavini. Haria kajoamora bana mahija Jahari kahojai-ra anofijanaravini. Ivani ka'da'di hoarana i, hahavi-ra ivaka'da'diki i. Idanoki i, ikaabokaki ida hahavi inofiki. Aradahaki ida ijahani vahoariha hahavi ni-vajahanana aradahaki. Nimania ida kadahojai mahi anokhomirikia. Hari ida vani oamani.” ");
INSERT INTO padNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Vahoariha vakadihojai asohiriki-ra avarakava'i'birinihi; avakadihojai asohiriki-ra akava'i'biriniha ada avakadiabi'i nama hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Vahoariha vakadihojai asohiriki-ra avarakava'i'birinirihi; ni-avakadiabi'i avakadihojai asohiriki-ra akava'i'biriniki jaboni. Va'ora avarakariakarihi; ni-Deus a'onira akariakaki jaboni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Asia vara niha ada Jesus: —Avi'bairini avahojani kamahini Deu-ra vara avani'aka'oaja kaimoni, hari'a avanokhoni-ra vanahamara mahija vahoariha avi'bairini avahojani-ra avigaravini. Ija'ari abononi vaboraborahakia vanofiki ida vahoariha avigavini. Vakava'ibodivarani bana hida kodivarani. Vi'bairina vahojana vahoariha va'ora khai vani'ara kaimoni, ni-Deua binaabosirihi bana ida vi'bairina vahojana. ");
INSERT INTO padNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Avi'bairini avahojani kamahini Deu-ra vara avani'aka'oaja kaimoni, visoko bana oni avanokhoni, avaka'da'dini-ra vakavamisaiha jaboni ");
INSERT INTO padNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mahija vahoariha avi'bairini avahojani-ra avigaravini. Nokiariha ada avakadiabi'i. Ovari hoarana biogaki ida avi'bairini avahojani. Binokihi ida avi'bairini avahojani, oniani ida a'onira naabosivini hija bana kidinahina jahakia — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Vara ni'ianaha ada Jesus: —Vanofi bana ida nahina jahaki Deus a'onira no'avini hiki bana kidiania. Hari'a avana'ba'di ida bana avakadinahina kaidivaki hidiaja. Ni-a'bo'daki ida kadanahina avarana'ba'diki hidiaja. Va'ba'ba bana binihimaki bana ida avakadinahina. Ferrugem jabonia bana binihimaki bana ida avakadinahina. Ija'aria avana'bakhajakosi hida avagorani, avakadinahina bavini hiki-ra vabo'diara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Avana'ba'di bana ida avakadinahina avanakaidivaki Deus kania nama mahija avanaibavijahavini. Ni-va'ba'ba, ni-ferrugem jabonia binihimaki bana ida avakadinahina. Ni-ija'aria vakaabokaki ida ibavi-ra vana'bakhanivini, vabo'diaja kaimoni ida avakadinahina avanakaidivaki. ");
INSERT INTO padNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Avakadinahina avanakaidivavini arafiahi; avakadinahina-ra avakava'ibodivaraniha'oadahahi. Deu-ra avanakaidivavini arafiahi; Deu-ra avakava'ibodivaraniha'oadahahi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Vara ni'ianaha ada Jesus: —Lamparina fori hiki ida ija'ari nokhoni vagani. Avanokhoni vagani jahahi; hahavi-ra avanokihi. Mahi vagania avaadahani fori hihi; nahina-ra avanokivini hiki avanokhoni jahani. ");
INSERT INTO padNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Avanokhoni 'ba'dani jaharihi; ni-nahina-ra avanokiki, joma bakibakinia adahai fori hiki hida. Jahari kabadania avakabadanihi; joma bakibakinia avaadahani fori avihiki bana a'oni. Avava'ini ogairiva bana mahija Jahari kabadania avakabadaniravini. Jahari kabadani-ra avakava'ipahinivini naothinia Jahari kabadania avakabadani'ianahi, joma bakibakinia avaadaha'ianaki fori avihi'ianahi bana. Jahari'oamanija ida bakibakiki fori hiki avaadaha'ianani bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Vara ni'ianaha ada Jesus: —Honai abonoa ni-bikaabokaki ida ka'da'di vi'bamiki vaathi-ra naabahaha'oadahavini. Bivajahaki ada ka'da'di hoarana, athi-ra naabavini jaboni. Bada bini'avini oadani ida ka'da'di kabadani, ni-bikaabokaki ida ka'da'di hoariha athi-ra naabavini, oniani ida bikajonivini hija. Ka'da'di ada Deus. Ka'da'di fori hiki ida jiniro. Ija'ari va'ini-ra nahonariahihivini fori hiki ida jiniro. Ija'aria biva'ahavini oadani ida jiniro va'ini nava'ihonariahihini hini, ni-biva'ahaki ada Deus va'i nahonariahihini hini. ");
INSERT INTO padNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Oniaroa, Jesus va'ora ni'aha adani ija'ari: —A'onira onava'isohiki bana ho. Hari'a avakava'isokoniha'oadaha ida 'bai avahaki kaimoni-ra avagathanivini, paha avi'aviki kaimoni-ra avagathanivini. Hari'a avakava'isokoniha'oadaha ida avakadimakari avakaimahaki-ra avavahojaravini. Avakadimahi hirihi ida avakadi'bai. Ni-avaabononi hirihi ida avakadimakari jaboni. Jahaki ida avakadi'bai-ra avanako'dihavini, makari-ra avavahojavini jaboni. Avanofivini kaba'i ida 'bai, makari hiki, hari'a avava'ini-ra nahonariahihiva bana ida makari, 'bai hiki. Deus a'onira no'avini hi'iki ida avakadimahi; a'onira kaijahitaki jaboni ada. ");
INSERT INTO padNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Vada va'ora vani'a bana adani igitha varaboki 'bai-ra vanako'dihavini, kaba'i ni-vava'i soko iniki. Ni-varakhajahaki, ni-vidoraki ida rakhajahi bononi. Ni-vanamonahaki ida bavi, rakhajahi bononi ibavijahani kagorani kaimoni, kaba'i avakadiabi'i nama hojaki va'ora kaijahitaki adani igitha. Deus va'ora nakaidivaki adani igitha varaboki, Deus a'onira nakaidivavini arafiaki a'oni. ");
INSERT INTO padNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Avarakava'isokonimanija koda ida avakadimahi-ra avana'oadavini? Iniani. Ni-avakaabokaki ida avakadimahi-ra avaranaipohivini. ");
INSERT INTO padNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ni-nahina kaimoni avarakava'isokoniki ida makari-ra avakainamovini. Vakava'ibodivarani bana ida hogoi movani avijavani. Ni-bada niki ida movai, ni-binamonahaki ida makari bikaimahaki kaimoni, kaba'i nokiani jahaki ida movai. ");
INSERT INTO padNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ka'oa hiki hida kodivarani. A'onira onava'isohivini hiki ada arabo vaka'da'diva Salomão oniki kohana. Kanahina'ahapikiki ada Salomão. Kaidivaki ida kidimakari, nokiani jahaki jaboni ida. Jahani kaba'i ida kidimakari nokiani, jahani nokiani arafiaki ida movai. ");
INSERT INTO padNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Deus vania binamonahaja ida hogoi movani nokiani jahaki. Hidakaba'i hojahi ida hogoi, afokajoma ara'okho'iki ida. Ija'aria bianaha'di'iki ida. Kaidivarini kaba'i ida hogoi, Deua bikahinanikaki ida. Deus a'onira nakaidivavini arafiaki a'oni, oniani ida bana a'onira kakodiavini hija avakadimakari avakainamokia. Deus a'onira kaijahitavini-ra avakajari'darihi; hari'a avava'ini soko iniva. ");
INSERT INTO padNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hari'a vanakama'da ida avava'ini soko iniha'oadahani. Hari'a vakhaniha: “Hanaja koda bana oabono oakaragaja 'baia, paha, makari hikia?” ");
INSERT INTO padNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Deu-ra avigarikia avakava'isokoniha'oadahaki ida vakainamoki. Avakadiabi'i nama hojakia biogaki ida nahina avakainamoki. ");
INSERT INTO padNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hari'a vakava'ibodivaraniha'oadaha'a bana ida makari, 'bai hiki. Vakava'ibodivarani afo'imidia bana ida Deua binofiki. Vava'aha ida Deus a'onira vaka'da'divini. Athi avanaabahaha'oadaha bana; a'onira kaijahitajahakiki ada. ");
INSERT INTO padNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hari'a hidakaba'i avakava'isokoni'a bana ida nahina afokajoma avakainamoki. Jakaho hojava ida afokajoma. Arajomaki ida nahina namithaki hidakaba'i avava'ini kidakidaria kaimoni. Hari'a avakava'isokonijora bana ida afokajoma namithaki kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Hari. Jesus va'ora ni'aha adani vajoroniki: —Hari'a va'ora avanaathidanoarari bana adani vahoariha Jahari kabadania vakabadanina, avarigaravini oadani ida vanamonahavini vanamonaharavini. Va'ora avaranaathidanoaraririha; ni-Deus a'onira anaathidanoarariki bana jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vara avavani'abakhiahi ida vahoariha vakadihojai jahaki; Deua vara bivani'ahi ida avakadihojai jahaki jaboni. Vara avavani'abakhiahi ida vahoariha vakadihojai jahariki; Deua vara bivani'ahi ida avakadihojai jahariki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hogoi moramorani nokhoi 'ba'dania hojaki fori hiki ida hojai jahariki. Inokhoni 'ba'dania hojani oadani ida ava pitani karaho, hari'a ikaijo'a ida hogoi moramorani iigamini nokho 'ba'dania aniani. ");
INSERT INTO padNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Inokhoni 'ba'dania ava pitani karaho aniarini oadani, hari'a iigamini-ra ni'a: “Aajo, onofiki ida hogoi moramorani pitani pa'itxi-ra oanivini inokhoni 'ba'dania.” ");
INSERT INTO padNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ijahani-ra ikahi'badaraki i. Imiro'a iani oni ava pitani karaho inokhoni 'ba'dania hojaki. Ianivini naothinia ikaabokaki ida vada inijahakini, oniani ida iigamini nokho 'ba'dania hogoi moramorani aniani-ra ikaabokavini hija. Bada ini'avini oadani ida hojai asohiriki, asohipa'itxirihi ida iigamini-ra inava'isohivini, bikava'ipahinija kaimoni ida kidihojai asohiriki. Imiro'a ikava'ipahini hida bana kadahojai, kadavarani asohiriki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Asia vara niha ada Jesus: —Hari'a vara va'ora vani'ahaha'oadaha adani Deu-ra vakajoniki Deus varani hina. A'onira vakaihamahiki adani. Jomahi vaihamahiki fori vihiki adani. Anakaidivava ida Deus athi. Nahina kaidivaki fori hiki ida. Ni-hirari-ra avano'avini hiki ida nahina kaidivaki. Avano'avini hija vaha, bikada'aha'ahamanihi vaha, ni-binakaidivaki vaha. Hirari fori vihiki adani hojai asohiriki-ra vakava'ipahinivini-ra vanofiriki. ");
INSERT INTO padNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Hari. Jesus va'ora ka'ojomo'iki adani ija'ari Deu-ra vakanikhariabakhiaki. Bini'aha: —A'onira onava'isohiki ho. Deu-ra vakanikharia bana avanofikia mahija avagathanivini. Deus kania vakanikhariaha'oadaha bana ida avanofiki mahija a'onira no'avini hini ida avakanikhariaki. ");
INSERT INTO padNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ija'ari hahavi nahina jahakia Deu-ra vakanikhariaha; vagathanihi ida vakanikhariaki. Ija'aria binako'diha ada Deus; bikaragaha. ");
INSERT INTO padNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kadaisai pãoa ira kanikhariahi, ja'di vania koda bana ino'ara ada? Iniani. Jokoa nahina jaharikia ino'ariha ada. ");
INSERT INTO padNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Abaisana ira kanikhariaha, makha vania koda bana ino'ara ada? Iniani. Jokoa nahina jaharikia ino'ariha ada. ");
INSERT INTO padNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A'onivani hojai asohirikia avakahojaini kaba'i, avarigaki ida nahina jahakia avakadisai-ra va'ora avano'avini. Jaha'oamanira ada avakadiabi'i nama hojaki. A'onira no'aki bana ada nahina jahaki avakanikhariavini hikia. ");
INSERT INTO padNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Avavajahaki ida vahoariha a'onira vakajoamoravini. Va'ora vakajoamora bana adani vahoariha. Nimania ida Deus kava'isohihi jiriki athini. Nimania jaboni ida Deus athi namoniva abono vaathi ija'ari-ra vaka'ojomo'ivini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Hari. Vara ni'ianaha ada Jesus. Kidivarani hiki ida hagihi rabodiki hagihi rabodiriki ija'aria vavaadahaki kaimoni. Va'ora ni'aha: —Bakatha karabodirikia avi'oi bana mahija hagihi rabodirikia avaadahavini. Ibavi Jahaka'oaki kania okhaki ida hagihi rabodiriki. Ibavi Jaharika'oaki kania okhaki ida hagihi rabodiki. Ija'ari vaipohiki vaadahaki hagihi rabodikia. Vakanako'divini kaba'i ida bakatha karabodiriki, ni-ija'ari hahavia vaakaragaki, oniani ida ija'ari vaipohiriki-ra naadahaja hagihi rabodirikia. ");
INSERT INTO padNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Asia vara niha ada Jesus: —Va'ora avakava'igairi bana adani Deus athi namoniva abono vihina vakahi'badaraki. Jahani kamithavahaki ida vanivaha vakadivarani, vanofiki ida a'onira vakaborovini bada avani'aja kaimoni ida Deua bivajahariki. Va'ora avakava'igairi bana. ");
INSERT INTO padNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Vada vani'abakhia bana ida Deus athi namoniva abono vakadihojai. Badani Deua bivajahariki-ra bada vani'aha; Deus athi namoniva abono vihirina va'ora avarigaha. Badani Deua bivajahaki-ra bada vani'aha; Deus va'ora karonavini va'ora avarigaha. Ija'ari kahojai-ra avanokivini vani avarigaja ida ija'ari jahani jaharini. Ni-hojai jaharikia kahojaiki ida ija'ari jahaki. ");
INSERT INTO padNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ihi'ai avani fori hiki ida ija'ari. Jahahi ida ihi'ai avani, jahahi ida ihi'ai bononi. Jaharihi ida ihi'ai avani, jaharihi jaboni ida bononi. ");
INSERT INTO padNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ihi'ai avani jahaki kania ni-hojaki ida ihi'ai bononi jahariki. Ihi'ai avani jahariki kania ni-hojaki ida ihi'ai bononi jahaki. Ihi'ai fori hiki ida ija'ari kahojai. Jahahi ida ija'ari, jahahi jaboni ida kidihojai. Jaharihi ida ija'ari, ni-jahaki ida kidihojai jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ija'aria binobaki ida ihi'ai avani ihi'ai bononi jahariki-ra vahojaki. Binobavini naothinia bio'boni'ihi siho kabodinia. ");
INSERT INTO padNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Oniaroa, vada avani'ahi ida Deus athi namoniva abono vakadihojai hahavi. Jaharihi ida vakadihojai va'ora avarigaha adani Deus kaija'ari vihina-ra vakahi'badaraki. ");
INSERT INTO padNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hari. Vara ni'ianaha ada Jesus: —Ni-avi'oiki bana adani ija'ari hahavi Deus ibavia nama ka'da'dia hora vanaonibakhiaki. Avi'oiki bana adani ija'ari kodiabi'i athi-ra vanaabaki. Nama hojaki ada kodiabi'i. ");
INSERT INTO padNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ija'ari-ra nasohivini kamahini ija'ari vaipohiki hora vani'aki bana ho: “Jesus, va'ora akanamonibakhiaki adani ija'ari vaipohiki Deus athia. Bajadi-ra ani'ahananaki jaboni hari: ‘Jesus Cristo ira honariaki i ija'ari kania akara'o'a.’ Akhanibakhiaki hari. Jesus, bada ani'abakhia'iki jaboni ida kadabadani danoki ipohiki.” Hora vani'aki bana adani ija'ari vaipohiki. ");
INSERT INTO padNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hari. Ogathaniki bana ida vaathi: “Hojai jaharikia avakahojaibakhiaki a'oni, oniani ida kodija'ari a'onira niharija. Ni-a'onira oogaki. Akara'o bana kodiania!” ");
INSERT INTO padNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Hari. Rajomi kavaranihi hoariha va'ora vara ni'aha ada Jesus: —Oathi-ra mitha ni'akia binaabaki ida oathi. Gora kaaraki-ra namonahaki vani fori hija hida ija'ari ogahaki. Bikhori'imidiahi ida hodi abihiaki, gora avani arokhojahani ibavini kaimoni a'daimaki. ");
INSERT INTO padNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gora a'diahini naothinia, ji'binini kama'da'ihi ida vaini kapahani. Vaini kapahani jorania bigathi'ihi ida gora avani, ni-ho'doho'do'iki ida gora. Abihiaki ida gora avani nami imani bodinia. ");
INSERT INTO padNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Gora-ra namonahaki vani fori hija jaboni ida ija'ari hoariha ogahariki, bikamithahi ida oathi, ni-binaaba'iki. Binamonahahi ida hodi abihiariki, arokhojahajahakirihi ida gora avani. Binaibavi'ihi ida gora avani hodi abihiariki bodinia. ");
INSERT INTO padNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gora a'diahini naothinia, ji'binini kama'da'ihi ida vaini kapahani. Vaini kapahani jorania bigathi'ihi ida gora avani, adari'ihi ihimika'oa'ihi ida gora — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Anokhomi'iki ida Jesus kavarani vara va'ora ni'avini hiki adani ija'ari vaipohiki. Vakava'ibodivarani'ihi ida niha ninini va'ora ka'ojomo'ivini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Vaabono vakani'akhama'aha: —Akadija'ari vaka'ojomo'iva abono fori hiriha ada Jesus. Jesua biogaki ida nahina Deua binofiki, oniani ida Deus athia va'ora ka'ojomo'ijahakivini hija. Akadija'ari vaka'ojomo'iva abono ni-Deu-ra avigajahakiki, ni-vavaasohihijahakiki ida Deus athi nahina hini Deua vara bivani'a'iki. ");
INSERT INTO padNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hari. Okharafoni'aha ada Jesus. Ija'ari vaipohikia vavaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Oniaroa, Jesus kania okha'aha ada makhira kavamoniki. Asafi hahavi namani-ra najaharikia kavamoniki ada. Binamaakari'aha kajo'atharari'aha Jesus viaha. Bini'aha: —Jesus, hora kajoamora bana! Hora inajahavini-ra inofihi; hora inajahahi — niha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesua bikanaibavi'ihi ida sa'a makhira namana, bikadasa'aha, bini'aha: —Ha'a, onofiki ida ira onajaha'avini. Jaha'a bana! Jorakia avisoni'ihi ida kidikavamoni asafi namania hojaki, jaha'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesua bini'aha: —Hari'a bana vahoariha-ra nanamitha'a ira onajaha'avini. Okha'a bana sasidotxi kania mahija iasafini namani-ra nokivini, biogaja kaimoni ida ijaha'ini. Deus kava'isohihi jirikia bihonariaki ida ija'ari jaha'iki Deu-ra kanava'igavini igitha abononi aha'dikia, vahoariha avigaja kaimoni ida jaha'iki. Sasidotxi ira nokivini naothinia inaaba'a bana ida Deus kava'isohihi jiriki — niha ada Jesus. Ajihi'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hari. Cafarnaum sidajia o'oi'aha ada Jesus. Jesu-ra karagararihaha ada Roma sidaji kaka'da'dini kasorarani. ");
INSERT INTO padNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Bini'aha: —Jesus, hora kajoamora bana! Kavamoniki ada kodihonai abono. Ada ogorana hojaha. Kavamonikarahoki ada. Imai 'banani karaho-ra kamithaki ada, ni-bikaabokaki ida giragirana — niha ada sorara vaka'da'diva. ");
INSERT INTO padNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesua bini'aha: —Ookhaki ho kadania, oanaihotaki bana ada kadahonai abono — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Roma sidaji kaka'da'dini kasorarania bigathani'ihi ida Jesus kavarani. Bini'aha: —Jesus, ivani ka'da'di i. Nahina ohirina mani ida ogorana io'oini-ra onofiravini hija. Ogorana iokharini kaba'i, napaja ihojani kaba'i, ihonaria bana ida kavamoni akara'oni aihotara kaimoni ada kodihonai abono. ");
INSERT INTO padNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hovani jaboni onaabaki ida athi hora vaka'da'diki hora honariabakhiavini hiki. Va'ora ovaka'da'diki adani vahoariha, oathi-ra vanaababakhiaki adani. Okhana ohonariaha ada sorara, okhamaniha. Hida khana obaranahaha ada hoariha, khamaniha. Kodihonai abono-ra ohonariahi hihida badani-ra namonaha, binamonahamanihi. Oathi-ra vanaabaki adani va'ora ovaka'da'diki. Ivani jaboni ka'da'di i. Nahina-ra ihonariahi; iathini-ra naabahi. Kavamoni akara'oni-ra ihonariahi kodihonai abono kania, akara'omanihi bana — Jesu-ra ni'aha ada sorara vakadika'da'di. ");
INSERT INTO padNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesua bikamitha'ihi ida sorara vakadika'da'di kavarani, bikava'ibodivaranikaraho'ihi. Ija'ari vaipohihana hiki-ra ni'aha: —Ni-okaraga'iaki kaho ada judeus kaija'ari hoarana hora kajari'dariki, hihada Roma sidaji kaka'da'dini kasorarani hora kajari'daravini fori hiki. Judeus kaija'ari hirina kaba'i, ni-hora kajari'daki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Asia vara niha ada Jesus: —A'onira onava'isohivini hiki. Deus kania nama vikhaki bana adani arabo hahavi kaija'arini, ija'ari Deus athi-ra vanaababakhia'iki. Arabo hahavia vikhaki bana adani, vavithirarina vi'baijabanaki bana adani Deus kania. Akadija'ari avikhananavaki Abraão kohana, Isaque kohana, Jacó kohana vakadiania vavithiki bana adani. ");
INSERT INTO padNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ija'ari vahoariha judeus kaija'ari vihina kaba'i, ni-vanofiki ida Deus athi-ra vanaabavini. Deus va'ora nagathogathovini kaba'i kidija'ari vihira kaimoni, ni-avi'oiki Deus ibavia. Oniani ida bana Deus va'ora nahokahivini hija Ibavi Jaharika'oakia. Bakibakini kania vaasara'oamanira adani. Vaofinina vakanada kakiroromisi'oamanira adani ija'ari Ibavi Jaharika'oakia vahojaki. ");
INSERT INTO padNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesua bini'aha ada Roma sidaji kaka'da'dini kasorarani: —Igorania ajoi'a. Ikajari'darihi ida kadahonai abono-ra oanaihotavini, oniani ida oanaihotavini hija — niha ada Jesus. Hari. Oniaroa, jorakia aihota'iki ada kidihonai abono. Hari. Joi'aha ada sorara vaka'da'diva gorana. ");
INSERT INTO padNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hari. Ajihi'aha ada Jesus. Pedro gorana okha'aha. Kaikahi'aha gora bodinia o'oi'aha. Pedro kamasodini kabaravaki, omaki. ");
INSERT INTO padNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesua biakaabada'ihi ida sa'ani. Jorakia radaha'ihi ida kidibarava. Gama'ihi, va'ora kahinanika'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hari. Mithani vaivaini vani Jesus kania ija'ari va'ora vavikha'aha adani ija'ari vaipohiki, vakabajadiki, vakavamoniki vihiki. Hoaranija Jesus bihonariahi ida bajadi akara'o'ini ija'ari kania, akara'omani'ihi. Ija'ari hahavi vakavamoniki avaihota'iki afohanana. Vara va'ora ni'aha, avaihotamani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","'Bo'dakari Deus athi namoniva abono Isaías onikia vara bivani'ajora'iki ida Jesus ija'ari-ra kajoamoravini. Niha ada Isaías kohana: “Ovari akadikavamoni-ra aniki, haria anaihotaki ada.” Hari. Jesua bada bini'a'iki ida kidibadani danoki, namitha'iki ida Isaías kohana bivava'isohihijora'iki. ");
INSERT INTO padNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hari. Jesus va'ora noki'aha adani ija'ari vaipohiki kidiania vajoroniki. Va'ora ni'aha adani kidipohi: —Avaakakafiani bana 'dako pitanija. ");
INSERT INTO padNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Oniaroa, Jesus kania okhaha ada judeus kaija'ari ka'ojomo'iva abono, bini'aha: —Jesus, onofiki ida ira ovaipohiha'avini. Ibavi hana hinia iokhahi, ookhahi jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Oniaroa, Jesua binava'isohi'aha ada makhira ipohina hina-ra nofiki kidimahi niha nininia, oniani ida athi bigathanivini hija: —Igitha vavahojaki ida vagorana ava hodinia akoirija kaimoni. Igitha varabokia vavahojaki ida vagorana ava vadinia. Hovani ija'ari hahavi vakadi'aajo ohina kaba'i, ni-hojaki ida ibavi oavakoiriki kaimoni — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hari. Jesus kania okhaha ada makhira hoariha, Jesus ipohina ada. Bini'aha: —Jesus, jakana oajoi'imidiava kaho kodiabi'i aba'ona-ra oka'damahavini naothinia bona ira ovaipohihahi. ");
INSERT INTO padNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesua bini'aha: —Iniani. Jakaho ija'ari abiniki-ra vaka'damava adani ija'ari vahoariha vahokina kaba'i Deus viaha vaabiniki fori vihiki. Ivani hora vaipohiha'a bana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","24","Hari. Kanava kabodinia vaki'dama'aha adani Jesus kidipohi khama. Ai vakihi'aha. 'Dako pitanija aavakakafianina kaba'i, jorakia kama'da'ihi ida sirisiriki danoki. Komini kana'bahaki kakatarararahaki kanava kanamani-ra akaradafarahanaki. Vadimaniha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Avikhamahana'aha adani Jesus ipohina kidiania, vakananokiaha'aha: —Jesus, Jesus, haria akava'ijoa, ahidananaki bana hari! Nokho afora'aha. ");
INSERT INTO padNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Gama'aha, bikaabani'ihi ida sirisiriki, komini kihiki. Jesua bini'ahi: —Radaha'a! Radaha'ihi ida sirisiriki, karadaha'ihi jaboni ida komini kana'bahaki. Ipohina-ra va'ora kani'a'aha: —Niha avakhanimanija avaofiniki? Deu-ra vavakaijoka bana. Avakajari'damanija ida Deus a'onira akadava'avini? ");
INSERT INTO padNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sirisiriki, komini kihiki jorakia karadahani mani ida va'ora nava'ibodivaranikarahoja. Vaabono vakani'akhama'aha: —Makhira ka'oa hiriha hada. Ni-anoki'iaki kaho ida ija'ari hoariha ovari fori hiki sirisiriki, komini kihikia athi bikamithaki — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hari. Galiléia oniki 'dakoa avakakafiani'aha adani Jesus. Gadara kaarabonia avako'omisi'aha. Avigaimori'aha. Oniaroa, Jesu-ra vakaragarariha'aha adani makhira vakabajadiki vi'bamiki, 'dama kania vikhanaiki adani. Ja'di kahodijama'oki bodinia vaibaviki adani makhira vakabajadiki. Vaihamahiki adani. Ija'ari va'ora vifinivini mani ida vamaakarina varadahana-ra vanofiravini hija. ");
INSERT INTO padNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Vakabajadikia vani'a'aha vabodi'barahana: —Jesus, ivani Deus kaisai i. Jakaho arihojava. Ni-kaikahiki kaho ida mahi jaharikia haria iarakhaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hari. Vahojamaniha adani hirari vaipohiki vi'baiki maakaria. ");
INSERT INTO padNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bajadi Jesu-ra vakanikhariadanoki'aha: —Haria va'adi bana! Aakara'ona-ra ihonariahi; haria karona'a hirari vakadiania mahija haria vavaadaha'avini. ");
INSERT INTO padNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Vaadaha'a — Jesus va'ora ni'aha adani bajadi. Hari. Makhira kania vakara'o'aha adani bajadi, hirari-ra vagathi'aha. Vaipohi'oamanira adani hirari. Vaki'darahaha'aha, avikharafoni'aha, arabo a'domarariki kania avaki'dafafoni'aha, avahidana'aha. ");
INSERT INTO padNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Oniaroa, vaofini'aha adani makhira hirari-ra avakadava'aki. Aviga'aha. Ija'ari vaibavia avakhano'aha, va'ora vakanamoni'aha makhira vi'bamiki vamonina. Vakhaniha'aha: —Jesus va'ora honaria'iki adani bajadi makhira vi'bamiki vakadiania avakara'o'ina. Ai vihi'aha adani bajadi. Ni-vakabajadijanaki adani makhira — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hari. Ija'ari afohahavi sidaji vahojaki moni-ra vakamitha'iki Jesus kania avikha'iki. Vanokiha, vani'aha: —Ajihi'a bana akadiaraboa. ");
INSERT INTO padNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hari. Kanava kabodinia vaki'dama'aha adani Jesus. 'Dako pitanija avakajoifiani'aha. Vigaimori'aha adani Jesus. Sidaji bivahojaki kania vakaikahi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hari. Vakaikahi'aha adani ija'ari Jesus bivahojaki kania. Vakaiba'iha ada makhira hoariha jo'o aba'oronisiagaki. Vibarari'aha Jesus viaha. Jesus abono-ra ni'aha: —Vakajari'darihi hida makhira jo'o aba'oronisiagaki-ra oanaihotavini-ra okaabokavini. Oniaroa, makhira kavamoniki-ra ni'a'aha: —Kodisai, khai ini'a! 'Bira'iki ida kadahojai asohiriki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Judeus kaija'ari vaka'ojomo'iva abono vaipohiriki vaabono vani'a'aha: —Jahariki ida Jesus kavarani. Deus ka'oa bikaabokaki hida hojai asohiriki-ra na'biravini. ");
INSERT INTO padNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesua biogaki ida vakava'ibodivaranivini, va'ora ni'aha: —Jahariki ida kodivarani-ra avakajari'davini. ");
INSERT INTO padNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Onaihotaki bana ada makhira, oanaihotavini avanokiha; avarigahi jaboni ida kidihojai asohiriki ona'biravini okaabokavini. ");
INSERT INTO padNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Deus hora karonavini hiki ija'ari kahojai asohiriki-ra ona'biravini. Hovani ija'ari hahavi vakadi'aajo ho — va'ora ni'aha ada Jesus. Makhira jo'o aba'oronisiagaki-ra ni'aha: —Gaa'a, adaha'a! Ijorani-ra nabiini'a, igorania okha'a bana! ");
INSERT INTO padNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hari. Aihota'aha ada makhira. Gaa'aha, jorana-ra nabiini'aha, gorana okha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oniaroa, ija'ari vanokiva vakava'ibodivaranikaraho'aha. Vaofini'aha. Deu-ra khai vani'a'aha: —Jaha'oamanira ada Deus! Ija'ari-ra no'avini danona, hoariha-ra anaihotavini-ra kaabokara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Oniaroa, ajihi'aha ada Jesus. Adahana kaba'i binokiha ada Mateus. Imposto gathaniva abono ada. Imposto kajinironi ida arabo kaka'da'dini kabadani kaimoni. Imposto kagorania vithiki ada Mateus. Jesua bini'aha: —Hora vaipohiha'a bana. Gaa'aha ada Mateus. Jesu-ra vaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Oniaroa, Mateus gorana avikha'aha adani Jesus. Vi'baina kaba'i vakaikahi'aha jaboni adani imposto gathaniva abono vaipohiki, ija'ari vahoariha hojai jaharikia vakahojaiki jaboni. Vi'baiki jaboni adani ija'ari Jesus kidipohi khama vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hari. Farisio vaipohiriki va'ora vanokiha adani Jesus vi'baijabanaki, va'ora vanana'dohi'aha adani Jesus ipohina: —Nahina kaimoni 'baijabanaki ada Jesus imposto gathaniva abono, hojai jahariki namonahava abono vakadiania jaboni? Akadihojai hipa'itxirihi hida a'baina hojai jaharikia vakahojaiki vakadiania — Jesus ipohina-ra va'ora vani'aha adani farisio. ");
INSERT INTO padNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesua bikamitha'ihi ida vakadina'dohi, va'ora ni'aha: —Onofiki ida va'ora oakava'ijoavini, oniani ida vakadiania hora no'baijabanaja. Kavamoni vani fori hija ida ija'ari kahojai asohiriki. Mijiko fori ohiki ho. Vakavamoniki vani adani mijiko-ra vanofira. Vakavamonirikia ni-vanofiki ada mijiko. ");
INSERT INTO padNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hojai asohikia vakahojaiki ni-va'ora obaranahaki. Hojai asohirikia vakahojaiki vani hadani va'ora obaranahara, vakava'ipahinika'oaja kaimoni ida vakadihojai asohiriki. Vada vani'a ida Deus athi kapapirani mahija a'onira ka'ojomo'ivini, avarigaja kaimoni Deus athi kapapirani haria nava'isohivini hiki ida: “Ni-onofiki ida igitha abononi aha'dikia hora avakanava'igavini. Onofiki ida vahoariha-ra va'ora avava'adivini.” Nihi ida Deus athi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hari. Jesus kania vamaakari'aha adani João Batista ipohina. Vani'aha: —Harivani, farisio khama akadihojai hiki ida a'bairina arihojabakhiana Deu-ra vara ani'aka'oaja kaimoni. Kadaipohi vakadihojai hirihi hida. Niha vakhanimanira adani kadaipohi vi'bairina vahojariki Deu-ra vara vani'aka'oara kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesua bigathanihi ida vaathi: —Vakadiania ohojahaha'oadahana mani ida vi'bairina va'ora nahojarija. Maisa hojana oadani, ni-vava'i mokara niki adani kanori abono. Maisa fori ohiki ho. Kanori abono ihinika kania vahojana vani fori vihira adani oipohina. Vi'baijahakiki adani kanori abono. Onivani fori vihira adani oipohina. Khaki bana ida mahi vakadiania oakara'ona kamahini, oniaroa, ni-'bai havahani-ra vanofiki mahi hahavi, Deu-ra vara vani'aka'oara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hari. Jesus va'ora ni'aha: —Vakava'ipahinika'oa bana ida avakadihojai 'bo'da mahija kodihojaia avakahojaivini. Ni-kabodihadihaki ida hojai 'bo'da kodihojai jahakia. Ija'aria ni-biakarabajaki ida makari 'biraki makari pitani ja'biriri'iarikia. Makari pitani ja'dinia akarabajaja vaha; sokoahi ida makari, ja'biririmanihi vaha ida pitani ja'dini, 'bira'ianahi vaha ida makari 'bo'da, a'ahapimanihi vaha ida makari 'birani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jesus va'ora ni'aha: —Vakava'ipahinika'oa bana ida avakadihojai 'bo'da mahija kodihojaia avakahojaivini. Ni-kabodihadihaki ida hojai 'bo'da kodihojai jahakia. Ni-ija'aria binabaviki ida vinho ja'dini igitha asafini 'bo'da bavi hikia. Thoromanihi ida vinho ja'dini. 'Dakhaki ida baasafi kabavihi 'bo'da, ni-a'bitxajanaki. Ija'aria binabavija vaha ida vinho igitha asafini 'bo'da; aka'bararakhamamanihi vaha; kavithimamanihi vaha ida vinho. Ni-jahajanaki ida bavi. Ija'aria binabaviki ida vinho ja'dini igitha asafini ja'dini bavi hikia. Ni-aka'bararakhamajanaki ida igitha asafini, ni-ahovarijanaki ida vinho — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hari. Jesus ija'ari-ra va'ora vara ni'avini oadani, kidiania khaha ada judeus kaija'ari nava'isohiva abono. Va'i bodinia abono-ra ni'aha ada makhira: —Ka'da'di oamani ada Jesus — oniani ida Jesus viaha nakajo'athararina hija. Jesu-ra kanikharia'aha ada makhira: —Hora kajoamora bana! Onofiki bana ida ogorana iokhani. Abini'iki ida kodisai. Kodiania okha'a bana. Isa'ani-ra kanaibaviha kodisai kania mahija ahokivini — niha ada makhira. —Jakaho kadania okhava — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Oniaroa, ajihi'aha ada makhira. Avikasiaga'aha adani Jesus kidipohi khama. ");
INSERT INTO padNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hari. Jesus naothia kha'ihi ida gamo kavamoniki. 12 badara ipohini amani aforarini hojaki hida gamo. ");
INSERT INTO padNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Abononi ni'ahi: —Jesus kakarahobi-ra okadasahi, oa'aihotahi. Oniaroa, Jesus kaida-ra kanamaakari'ihi. Bikadasa'ihi ida kidikarahobi. ");
INSERT INTO padNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hari. Roiribani'aha ada Jesus. Binoki'ihi ida gamo, bini'a'ihi: —Kodisai, khaii ni'a! Hora ikajari'daravini mani ida ira oanaihotavini hi'ia. Oniaroa, jorakia aihota'ihi ida gamo. ");
INSERT INTO padNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hari. Oniaroa, vakaikahi'aha adani Jesus judeus kaija'ari nava'isohiva abono gorana. O'oiha, va'ora nokiha adani ija'ari vabarariariaki, vahoariha va'ithohana ka'damahi viahania. Vava'i kidakida'aha saa vakhanina adani ija'ari vaipohiki. ");
INSERT INTO padNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesua biogaki ida isai-ra anahokivini, oniani ida va'ora ni'avini hija: —Abinirihi oni isai, vadika'oaki oni. Avakara'o hahavi hida! Jesus athi-ra vakajari'daki, oniani ida Jesu-ra vakanahahanihavini hija, vakanavaranihavini hija jaboni. Abinika'oani avigaki ida isai. ");
INSERT INTO padNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hari. Ija'ari vaipohiki avakara'ona naothinia, o'oi'aha ada Jesus isai bivahojaki kania. Jesua binamaakari'ihi ida isai aba'oni, biagathi'ihi ida sa'ani, ahoki'ihi, gama'ihi ida isai. Jaha'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Isai ahoki'iki monini varani hini akarafarakhama'iki ibavi maakariki hahavia. ");
INSERT INTO padNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hari. Ajihi'aha ada Jesus. Ibavi hoariha radahana kaba'i, Jesus naothia avikasiaga'aha adani makhira vi'bamiki, vakamaodorohaki. Vabodi'barahaki: —Jesus, ivani akadika'da'di i. Davi kohana haria vaka'da'divini fori ihiki i. Haria nakaidiva bana! ");
INSERT INTO padNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","O'oi'aha ada Jesus gora bodinia. Avakhano'aha adani makhira vakamaodorohaki, avi'oi'aha jaboni. Jesus va'ora ni'aha: —Avakajari'darihi hida a'onira oanaihotavini-ra okaabokavini; avaraihotahi. Vani'aha: —Ha'a, akajari'darihi ida a'aihotana. ");
INSERT INTO padNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesua bikadasa'ihi ida vanokho 'ba'dani. Va'ora ni'aha: —Avajari'darihi; avagahahi ida avanokhoni 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bikaabadavini naothinia avagaha'ihi. Jesus va'ora kaabanidanoki'aha: —Hari'a vananamitha hida a'onira oanaihotavini vahoariha vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hari. Ai vihi'aha. Jesus va'ora kaabanivini kaba'i, ibavi maakariki hahavi kaija'arini-ra va'ora vananamithavini hi'ihi ida vanokho anavagahani hiki. ");
INSERT INTO padNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hari. Makhira vi'bamiki va'ajihina naothinia, vahoariha vavikhaha ada makhira hoariha Jesus kania. Bajadia abani biana'dakharariki ada makhira. Jesua bihonariahi ida bajadi akara'o'ini. ");
INSERT INTO padNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bajadi ajihini naothinia vara ni'aha ada makhira. Ija'ari hahavi vahojakia vakava'ibodivaranikaraho'ihi ida Jesus kabadani danoki. Vaabono vakani'akhama'aha: —Ni-ija'ari hoariha ahararana hojaki kabadani niki-ra anokiki kidibadani fori hiki. ");
INSERT INTO padNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Oniania, vakhanihaha adani farisio: —Bajadi vaka'da'diva Jesu-ra no'a'iki danona, oniani ida bajadi ajihini-ra honariavini hija. ");
INSERT INTO padNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Oniaroa, sidaji ipohikia ija'ari ibavini ipohikia aadahaoni'aha ada Jesus. Judeus kaija'ari Deu-ra vara vani'avini kagorania o'oiki ada. Va'ora ka'ojomo'i'aha adani ija'ari. Jesus va'ora vara ni'avini hihi ida Deus monina jahaki. Va'ora vara ni'avini hiki ida Deus ija'ari hahavi-ra vaka'da'divini. Va'ora anaihotaki jaboni adani ija'ari vakavamonihahaviki. Ipohiki ida vakadikavamoni. ");
INSERT INTO padNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesus va'ora vada ni'aha adani ija'ari vaipohiki, va'ora nakaidiva'oamaniha. Abono-ra ni'aha: —Ovilia nahina va'ora akadava'ariki fori vihiki adani ija'ari. Vakaamiariki fori vihiki adani, ni-hojaki ida va'ora kajoamoraki. ");
INSERT INTO padNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesus va'ora ni'aha adani kidipohi: —Rakhajahi bononi a'diki ipohiki vani fori vihira adani ija'ari vaipohiki. Vanofiki ida vaabono gahinai vanihavini kodiania. Vaipohiriha adani Deus kahonai abono hora avigariki-ra vananamithaki varani ohina. ");
INSERT INTO padNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Deu-ra vakanikharia bana mahija va'ora karonavini adani kidihonai abono hora avigariki vakadiania. Omonina-ra vakamithavini vani, vaabono gahinai vanihavini kodiania. ");
INSERT INTO padNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","4","Hari. Oniaroa, Jesus va'ora baranahaki adani kidipohi kidiania vikhana. Va'ora naonivini adani 12 makhira vaipohina, athi avavaadahaoniva abono. Hi'adani 12 makhira vaonina Simão, André, Tiago, João, Filipe, Bartolomeu, Tomé, Mateus, Tadeu, Tiago hoariha, Simão o nacionalista, Judas Iscariotes vihiki. Badara ahoarabakosiki radaha'ihi naothinia Judas Iscariotes va'ora kakodiaki bana adani Jesu-ra vanaabinivini-ra vanofiki. Jesus Simão-ra no'avini onii hoariha Pedroa, igamina ada André. Tiago igamina ada João. Zebedeu kaisai adani. Tiago hoariha Alfeu kaisai. Imposto gathaniva abono ada Mateus. Jesus va'ora ni'aha adani 12 vihiki vaipohina: —A'onira ono'aki bana ho odanona, avakaabokaja kaimoni ida bajadi akara'o'ini-ra avahonariavini, avakaabokaja kaimoni jaboni ida ija'ari kavamoniki-ra avaranaihotahahavivini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Oniaroa, Jesus kania vahojaki adani kidipohi. 12 vihiki vaipohina adani. Va'ora ni'aha: —A'onira okaronaki ho akadija'ari vaibavia avarikhani. Hari'a avikha bana Samaria kasidajini kaibavinia. Hari'a avikha bana akadija'ari vihiriki vaibavia. ");
INSERT INTO padNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Judeus kaija'ari vaibavi ka'oa avikha bana. Ovilia akamadaki fori vihiki adani judeus kaija'ari, ni-avigajahakiki kaho ada Deus. ");
INSERT INTO padNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Oniani ida a'onira okaronavini hija vakadiania. Va'ora vani'a: “Deua binofiki a'onira vaka'da'divini”. ");
INSERT INTO padNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Va'ora vanajaha adani ija'ari asafi namani-ra najaharikia vakavamoniki, vakavamoniki vahoariha jaboni avanaihota'a bana. Va'ora avanahoki bana adani ija'ari vaabiniki. Ija'ari vakabajadiki-ra avanokihi; vahonaria bana ida bajadi afohanana akara'oja kaimoni. Avagahina'iki a'oni Deus danona, ija'ari-ra avaranaihotaja kaimoni, ni-aabosiki ida danona. Hari'a vakanikharia ida ija'ari-ra va'ora avaranaihotavini abosinia. ");
INSERT INTO padNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hari'a avavikha ida avaabononi avakaijahitavini kaimoni. Vanokha bana ada Deus a'onira kaijahitavini. Hari'a avavikha ida jiniro, jiniro 'ba'dani hiki avamasi'ahani bodinia. ");
INSERT INTO padNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Avadairini vani avikha'a bana. Hari'a avakavikha ida sacola. Hari'a avavikha ida avakadimakari odoki hoariha avakadi'abosihi kaimoni. Hari'a avakavikha ida sandália, ava avaabononi avanadadavini kaimoni. Avakadibadani hiki ida ija'ari-ra va'ora avaranaihotavini. Jahaki ida a'onira vano'avini hiki 'bai, vada ibavini hikia. Avakadibadani abosini ida a'onira vakaijahitavini. ");
INSERT INTO padNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ija'ari vaibavi avakaikahihi, vanako'di bana ida ija'ari a'onira gathanijahakiki gorania. Sidajia ava'ajihirini oadani gorania vahojahaha'oadaha bana mahija avi'baivini avavadini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ija'ari gorania avakaikahini, ija'ari vahojaki-ra va'ora vani'a'imidia bana: “Anofiki Deus a'onira no'avini va'i jahajahania.” ");
INSERT INTO padNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Vagorana a'onira vagathanijahakiki bana adani ija'ari, va'ora vanava'isohiha'a: “Deus a'onira no'a'iki a'oni va'i jahajahania.” Vagorana a'onira vanofiriha, ni-a'onira vagathanijahakiki, va'ora vanava'isohi bana: “Jokoa Deus a'onira no'arihi va'i jahajahania.” ");
INSERT INTO padNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A'onira vanofiriki vahabini bana adani gora kaija'arini, sidaji kaija'arini, ni-a'onira vagathaniki, ni-avaathini-ra mitha vani'avini-ra vanofiki jaboni, oniania va'ajihi'a bana. Ava'ajihini kaba'i va'ora vani'a bana: “A'dama-ra akana'dara'daravini hiki, aniaja kaimoni hida arabo khomakhomani a'dama hojaki, avarigaja kaimoni ida jaharini ariathi-ra avakajonivini.” ");
INSERT INTO padNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Vakava'ihoki bana ida Deus ija'ari hahavi-ra nasohivini kamahini. Deus va'ora va'adipa'itxiki adani Sodoma sidaji kaija'arini, Gomorra sidaji kaija'arini vihiki. Vajaharina kaba'i, Deus va'ora va'adipa'itxiki adani. Deus va'ora ni-va'adipa'itxiki adani hihida sidaji kaija'arini, avaathini-ra vakamithavini kaba'i vanofiriki. ");
INSERT INTO padNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Hari. Ija'ari a'onira vavajahariki vakadiania a'onira okaronaki bana ho. Ovilia fori avihiki a'oni. Va'oaniaro jomahi hiihiha fori vihiki adani. A'onira vaarivini-ra vanofiki fori vihiki adani. Hari. Makha biogaki ida abono-ra akadava'avini pohimajarara kaimoni. Makha fori vihi'a bana mahija avapohimajaravini. Ho'doko fori vihi'a bana jaboni mahija vahoariha-ra va'ora avanaibavijahajahakivini. Ho'dokoa ni-bikanapohimajaki ida kahoariha. ");
INSERT INTO padNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Avaabononi avakava'igairi'a bana. A'onira vavajahariki a'onira vagathiki bana a'oni, vakadija'ari vanasohiva abono vakadiania a'onira avarakhaki bana adani. Avavadadamiki bana ida omonina avakavaranijanarini. Judeus kaija'ari Deu-ra vara vani'avini kagorani bodinia dafi avihiki bana jaboni a'oni xikotxia. ");
INSERT INTO padNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Oipohina avihini mani ida a'onira avisavini hija bana arabo kaka'da'dini, arabo ipohiki kaka'da'dini vihiki vakadiania, a'onira avanaathidanoararivini kaimoni. Jaharikia a'onira avarakhavini hiki bana oipohina avihini-ra vavajaharivini. A'onira vanajahariharivini kaba'i, asia omonina-ra vara vavani'a bana. Judeus kaija'ari vihiriki adani hi'adani arabo kaka'da'dini, va'ora vanava'isohi bana adani jaboni omonina. ");
INSERT INTO padNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A'onira avanaathidanoararivini kamahini hari'a bana avakava'isokonijora ida vakadi'aathidanoarari avagathanivini. Vakadi'aathidanoarari avagathanivini kamahini, Deus a'onira nava'isohiki bana a'oni varani vara avavani'aki kaimonia. ");
INSERT INTO padNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ni-avakava'ibodivaraniki bana ida varani vara avavani'aki kaimoni. Ma'onahai Jahaki avava'ini-ra nahonariahihiki bana a'oni, a'onira nava'isohivini hiki ida varani kodiabi'ia binofiki. ");
INSERT INTO padNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Hora vanofiriki va'ora vani'aha adani arabo kaka'da'dini: “Jahaki ada oigamina abinina. Jesus ipohina hina mani ida abinina onofivini hija.” Vakhaniha. Hora vanofiriki vahoariha va'ora vani'aki bana adani arabo kaka'da'dini: “Jahaki ida kodisai vaabinina. Jesus ipohina vihina mani ida vaabinina va'ora onofivini hija.” Vakhaniha. Hora vanofiriki vahoariha va'ora vani'aki bana adani arabo kaka'da'dini: “Jahaki ida kodiamia, kodiabi'i vihiki vaabinina. Jesus ipohina vihina mani ida vaabinina va'ora onofivini hija.” Vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Oipohina avihini mani ida ija'ari vaipohiki a'onira vavajaharavini hija bana. Avaabinirini oadani oipohina avihini-ra avakajonirihi; hora avakava'ipahinirihi; Deus a'onira akadava'aki bana a'oni, ni-akamadaki bana ida avama'onahani, Deus kania avarikhaki bana a'oni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Asia vara niha ada Jesus: —A'onira onava'isohiki bana ho. Sidaji kaija'arini a'onira vanajahariharihi; aviga'a bana, sidaji hoariha avikha'a. Avakadibadani hiki bana ida judeus kasidajini hahavia avarikhani va'ora avarakanamonionira kaimoni omonina. Hovani ija'ari hahavi vakadi'aajo ho. Ojoina viahania, ni-a'diahi'iaki kaho ida avakadibadani Israel kaija'ari vahararana vakadisidaji hahavi. ");
INSERT INTO padNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ipohina ni-bihonariafiahaki ada kidi'ojomo'ihi abono. Honai abonoa ni-bivaka'da'diki ada kidika'da'di. Avakadika'da'di ohiki ho. ");
INSERT INTO padNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ipohina abononi ni'ahi: —Onofiki ida kodi'ojomo'iva abono fori ohina. Ija'ari kodihojai kidihojai fori hini-ra vakahihi; khai onihi — nimania ida ipohina athi. Onivani fori hiki jaboni ida honai abono athi. Ovaria binofiki ida kidika'da'di kahojaia kahojaina. Kidika'da'di kahojaia kahojaiha; khai ni'aha. Hari. Ija'ari hora vavajahariki hora vani'abakhiaki: “Ivani Biosibo Jahari i. Bajadi vakadika'da'di i.” Vakhaniki adani. Ija'ari hora no'avini hiki onii jaharikia. Kodija'ari avihini mani ida a'onira vano'avini hija bana onii jaharini arafiakia. ");
INSERT INTO padNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Hari. Vara ni'ianaha ada Jesus: —Hari'a bana va'ora vifini adani ija'ari. Ija'ari vakadihojai ogavaharini kaba'i hidakaba'i, khaki ida bana mahi hojai hahavi ogavahani kaimoni. Ni-ija'ari kahojai ahojajanaki bana. ");
INSERT INTO padNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A'onivani avaipohiriki, mitha avani'aki hida kodivarani. Vara vavani'aha'iana bana hida kodivarani mahija ija'ari vaipohikia vakamithavini. Vahoariha vahojarina oadani vara a'onira oni'abakhiaki ho. Ija'ari vaipohiki vahararana vananamitha'a bana hida kodivarani. ");
INSERT INTO padNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hari'a bana va'ora vifini adani ija'ari a'onira vanaabinivini-ra vanofiki. Ni-vakaabokaki ida avama'onahani-ra vanaabinivini. Avaabinini naothinia, ni-a'onira vanapohimajajanaki bana. Vifini bana ida Deus athi-ra avanaabaravini. Avaabinini naothinia, Deua bikaabokaki ida avaabononi, avama'onahani hiki-ra nahokahivini Ibavi Jaharika'oakia. Deu-ra vifini bana! ");
INSERT INTO padNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Deua bikaabokaki ida ija'ari-ra naabinivini. Bikaabokaki jaboni ida a'onira akadava'avini. Deus va'ora akadava'aki adani igitha varaboki. Kaidivariki ida kirikiri. Pavakari anihavini ida kirikiri 'bamiki abosini jiniro 'ba'dani pa'itxi. Kaidivarini kaba'i, Deus va'ora akadava'aki adani. Deua abinini binofiravini kaba'i, ni-abiniki ida kirikiri hoarani. ");
INSERT INTO padNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Hari'a avava'ini soko iniva! Deua binakaidivaki ida kirikiri. Deus a'onira nakaidivavini arafiaki a'oni. Deua biogaki ida hahavi. Biakogaki jaboni ida aka'da'di kaafani nihafori kihini kaipohini, oniani ida a'onira onava'isohivini hija, a'onira nakaidiva'oamanira ada Deus — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Vara ni'ianaha ada Jesus: —Ija'ari kodija'ari hini-ra kahihi vahoariha vaviaha; kodija'ari hini okahihi jaboni bana kodiabi'i nama hojaki viaha. ");
INSERT INTO padNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ija'ari kodija'ari hirini-ra kahihi vahoariha vaviaha; kodija'ari hirini okahihi jaboni bana kodiabi'i nama hojaki viaha — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Hari. Vara ni'ianaha ada Jesus: —Hari'a vakava'ibodivarani: Jesus kaikahina mani ida ija'ari vaabono vakanajahamisikhamavini hija. Okha'ina mani ida ija'ari vaabono vakanajahariharikhamavini hija. ");
INSERT INTO padNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Okha'ina mani ida hora vakajari'daki hora vakajari'dariki-ra va'ora vanajahariharivini hija. Isai kaabi'i, kaamia vihiki va'ora vanajaharihariki bana adani vakadisai. Isai va'ora vanajaharihariki bana adani vakadiabi'i, vakadiamia. Isai kaamia va'ora vanajaharihariki adani gamo isani vakadisai. Gamo isani va'ora vanajaharihariki adani vakadiamia. Gamo kamasodini va'ora vanajaharihariki adani vakadi'aboni gamo. Hora vakajari'daki va'ora vavajahariki bana adani hora vanofijahakiki. ");
INSERT INTO padNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ija'aria vakaimajahariki bana ida oipohina. Kidiabi'i, kidiamia, igamina vihikia vakaimajahapa'itxiriki bana ada oipohina. ");
INSERT INTO padNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ija'aria binofiki ida oipohina hini, jahaki ida hora nofivini arafiani, va'ora vanofiki adani kidiabi'i, kidiamia, kidisai vihiki. Hora nofivini arafiarihi; ni-bikaabokaki ida oipohina hini. ");
INSERT INTO padNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Deus athi-ra onaabavini mani ida hora avaka'itapoamisahanavini hija bana ava akasanakhamakia. Ija'ari abononi va'ahariki ida abinini kodimoni hini, bikajoniki jaboni ida oathi-ra naabavini, ni-arajomaki ida oipohina hini. ");
INSERT INTO padNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ija'aria bada bini'ahaha'oadahahi ida binofiki kidimoni hini, ni-bikava'ibodiki ida Deua binofiki. Kavithimaki ida kidimahi, ni-aja'diki, ni-bivahojaki ida mahi ja'dini anokhomiriki Deus kania. Oipohina bada bini'ahaha'oadahaki ida Deua binofikia kabadanini. Hokini oadani bikava'ibodivaraniki ida kidimahi Deua bihonariaja kaimoni, ni-oniani abononi honariaki binofikia, oniani ida Deus kania kidimahi ja'dini ananokhomirini hija bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Hari. Asia vara niha ada Jesus: —Ija'ari a'onira gathanihi, hora gathanihi jaboni. Ija'ari hora gathanihi, bigathaniki jaboni ada hora karona'iki. ");
INSERT INTO padNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ija'ari abononi ni'avini: “Hihada khaki Deua bikaronaki hada, vara bivani'aja kaimoni ida Deus athi, oniani ida ogathanijahakivini hija jaboni.” Deua binaabosiki bana ada bikaronaki. Binaabosiki jaboni ada karonana hiki gathanijahakina hiki. Ija'ari abononi ni'ahi: “Jahaki oni ija'ari kahojai, Deus kaija'ari oni, oniani ida ogathanijahakivini hija.” Deua binaabosiki bana ida kidija'ari hojai jahakia kahojaiki. Binaabosiki jaboni ida kidija'ari gathanijahakini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Vakava'ihoki bana hida kodivarani. Ija'ari abononi ni'ahi: “Kanabidini akaaforaki ida Jesus ipohina, paha pahisiriki-ra nofiki ida. Nahina hirini kaba'i ida ija'ari, Jesus ipohina hina mani ida okajoamoravini hija.” Pa'itxi kaba'i ida kidikajoamorahi; Deua binaabosiki bana hida. Ka'oa hiki ida Deua binaabosivini kavaranihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hari hi'ihi ida Jesus kavarani va'ora nava'isohi'iki adani 12 vihiki vaipohina, ibavi ipohikia avikhana. Va'ajihi'aha. Oniaroa, ajihi'aha ada Jesus jaboni, sidaji hoariha maakarinia aadahaoni'aha. Va'ora aka'ojomo'ioni'aha adani sidaji kaija'arini, vara bivani'aki ida Deus varani hina. ");
INSERT INTO padNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hari. Cadeia hojaki ada João Batista. Oniaroa, bikamitha'ihi ida Jesus Cristo kabadani varani hini. Va'ora baranahaha adani kidipohi kidiania vikhana. ");
INSERT INTO padNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Va'ora ni'aha: —Avikha'a bana Jesus kania. Jesu-ra vara vani'a bana: “Anokhaki ada aihotahi abono Deua bikaronaki. Ivani aihotahi abono, Deus ira karonaki i? Hoariha-ra anokhamania koda?” Vakhani bana — va'ora ni'aha ada João Batista. Ai vihi'aha adani João Batista ipohina. Jesus kania vakaikahi'aha. Vani'aha: —João Batista haria karonaki hari kadania, ira nana'dohiki ada: Anokhaki ada aihotahi abono Deua bikaronaki. Ivani aihotahi abono Deus ira karonaki i? Hoariha-ra anokhamania koda? — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus va'ora ni'aha: —João Batista kania avajoi'a, vananamitha'a bana ida kodibadani danoki avanoki'iki, kodivarani avakamitha'iki jaboni mahija aihotahi abono ohina-ra ogavini. ");
INSERT INTO padNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ija'ari vakamaodorohaki vanokho-ra oanavagaha'iki ho. Ija'ari vakabaha katonorohaki okanajaha'iki vaadaha'iki. Asafi namani-ra najaharikia kakavamoniki ija'ari onajaha'iki jaboni. Ija'ari vamorobo kamokhihaki oakanavagaha'iki, athi-ra vakamitha'iki. Ija'ari vaabiniki oanahoki'iki. Ija'ari vakanahinariki-ra onanamithavini hiki ida Deus monina jahaki. ");
INSERT INTO padNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Deus va'ora kajoamoraki adani ija'ari aihotahi abono ohina-ra vakajari'dariki — Jesus va'ora ni'aha adani João Batista ipohina. ");
INSERT INTO padNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hari. João Batista ipohina va'ajihina naothinia, Jesus va'ora vara ni'a'aha adani ija'ari vaipohiki vajoroniki. Kidivarani hi'aha ada João Batista. Jesus va'ora ni'aha: —Amasia hojana kari ada João Batista, nahina mani ida João Batista kania avanavanavanahaja? Avarigaki ada João Batista mosori sirisirikia bikanadarahaki fori hirina. ");
INSERT INTO padNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Avanavanavanahavini kari avarigaki ada João Batista makhira kanahinaki fori hirina, ni-João Batista bikaimahaki ida makari kaidivaki. Amasia ibaviriha ada makhira makari kaidivaki-ra kaimahaki. Arabo kaka'da'dini gorana vania hojara ada makhira makari kaidivaki-ra kaimahaki. Makhira kanahina'ahapikiki fori hiriha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","João Batista-ra avanavanavanahavini kari, avarigaki ada Deus athi namoniva abono hina. Deus athi namoniva abono oamani ada João Batista. João Batista va'ora aradaki adani Deus athi vanamoniva abono ija'ari vahoariha khama. Ovari miro'a vara bivani'aki ida Deus ija'ari-ra vaka'da'divini kavaranihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hari. Jesus va'ora vara ni'a'ianaha adani ija'ari vajoroniki. —Deus athi kapapirania hojaki ida João Batista varani hina. Deua bini'aha ada kidisai: “Okaronaki bana ada oathi namoniva abono iviahania okhananavana, va'ora nava'isohiki bana adani ija'ari vakadimahi-ra vanasohivini ikaikahini viahania.” Nihi ida João Batista varani hina Deus athi kapapirania hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Hari. Asia vara ni'aha ada Jesus: —Vakava'ibodivarani bana hida kodivarani. Akadija'ari avikhananavaki ni-avigahahaviki ida Deus ija'ari-ra vaka'da'divini kavaranihi. Ni-avigaki ida niha ninini Deu-ra vagathanivini vakadika'da'di kaimoni hina. João Batista vania biogaja ida, oniani ida João Batista aagahai akadija'ari avikhananavaki vakadi'ogahai-ra aradavini hija. Kaba'i, ni-João Batista binokiki ida mahi vara bivani'ajoraki. Ni-kama'da'iaki kaho ida Deus kania ija'ari vaabono gahinai vanihavini vakadika'da'di hira kaimoni. João Batista naothia ija'ari vagathaniki bana ada Deus vakadika'da'di hina, oniani ida vakadimahi nasohini hija. Ija'ari nahina hirini kaba'i, kidimahi jahania biaradaki ida João Batista kamahi jahani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Hari. João Batista kavarani hida: “Kama'da'iki ida Deus ija'ari-ra vaka'da'divini.” Ija'aria mitha vani'avini vani Deus kania vaabono gahinai vanihaki vakadika'da'di hira kaimoni. João Batista khana viahania Deus athi namoniva abono kohana hahavi vakadivarani hini: “Khaki bana ida mahi Deus ija'ari-ra va'ora vaka'da'divini kamahini. Ni-kama'da'iaki kaho ida mahi.” Vakhaniha. Nimania jaboni ida Deus kava'isohihi jiriki. João kavarani hi'iki ida mahi kaikahi'iki. Deu-ra vanofiriki va'ora vanadabaki adani Deu-ra vanofiki vakadika'da'di kaimoni hina. Ija'ari abono-ra nadanohi; avi'oiki ida Deus ija'ari-ra va'ora vaka'da'divini kania. ");
INSERT INTO padNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Deus athi namoniva abono kohana vara vavani'a'iki ada Elias kohana miro'a kha'ina. Ovaria bivava'isohihijoravini ida Deus ija'ari-ra vaka'da'divini kamahini kama'dani. Hovani a'onira onava'isohivini hiki bana ada Elias hana hina. Kodivarani-ra avakajari'daravini-ra avanofihi; avarigaha ada João Batista Elias kohana fori hina. ");
INSERT INTO padNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Avamorobohahi; mitha vani'ajahaki hida oathi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesus vara va'ora ni'a'ianaha adani ija'ari vajoroniki: —Va'ora okavarajomiki adani ija'ari hahavi hidakaba'i vahokiki. Isai vakasivanahaki fori vihiki hadani ija'ari. Ija'ari vajoroniki kania vakasivanahaki adani isai. Vaabono vakabodi'barahararahakhamaki adani isai: ");
INSERT INTO padNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Akadikasivanahi ida akarai kaihinikani. A'ithohahi; ni-avikhajo'iki. Akadikasivanahi hoariha ida ija'ari abini'iki. Akaasarahi ida aba'oi, ni-avaasarajabana'iki. Ni-avavajahaki ida khai akhanina, ni-avavajahaki jaboni ida ava'i mokara nini.” Vakhaniha adani isai vakasivanahaki. Jesus va'ora ni'aha: —Avakhanini vani isai kasivanahi-ra nofiriki fori avihija. Ni-avanofipa'itxiki ida Deus athi-ra avanaabavini. ");
INSERT INTO padNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","João Batista kha'aha avakadiania, ni-bihaki ida 'bai mahi hahavi. Ni-bi'aviki jaboni ida vinho. Kidihojai avanokiha; avani'aha: “Kabajadiki ada João Batista.” ");
INSERT INTO padNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Okha'ihi avakadiania, kodihojai fori hirihi ida kidihojai. Hovani ohaki ida 'bai, o'aviki jaboni ida vinho. Hora avanokihi, ni-hora avanofiki. Nimania ida hora avakanavaranihavini: “Vada vani'a o hi'o ko'bai nofiki o, hi'o vinho-ra nofiki o jaboni. Kidiva'ahi vihiki adani imposto gathaniva abono, Jahari kabadani-ra bada vani'aki-ra nofiki o jaboni.” Nimania ida hora avakanavaranihavini. Hari. Ija'aria bikajari'darihi ida Deus ka'ogahai jahani; sohika'oani biogahi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Oniaroa, Jesus vara va'ora vani'a'aha adani sidaji ipohiki kaija'arini kidibadani danoki vakajari'davinia. Nihaha: —Kodibadani ipohiki danoki-ra vanokibakhiavini kaba'i hora vakajari'daki adani. Ni-vaabono vaka'da'digariavini hiki ida Jahari kabadania vakabadanibakhiana, ni-vakava'ipahinipa'itxiki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","A'onivani, Corazim sidaji kaija'arini, jahariki bana ida avakadimoni. A'onivani, Betsaida sidaji kaija'arini, jahariki jaboni bana ida avakadimoni. Bada oni'avini kaba'i ida Deus kabadani danoki ipohiki avakadiania, ni-avakava'ipahini'iaki kaho ida Jahari kabadania avakabadanibakhiani. Bada oni'aja vaha ida Deus kabadani danoki Tiro sidaji, Sidom sidaji hikia; Jahari kabadani-ra vakava'ipahini'bo'damaniha vaha, vakaimahamanihi vaha ida makari jarojaroki, vanaibavimanihi vaha ida ofo'ofoni vaka'da'di kanamania. Vakhanina vani Deu-ra vananokiahivini hihi hida Jahari kabadani-ra vakava'ipahinivini. ");
INSERT INTO padNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A'onira onava'isohiki bana ho. Deus ija'ari hahavi-ra nasohivini kamahini bihonariaki bana ida imai 'banani ija'ari hojai asohirikia vakahojaiki Ibavi Jaharika'oaki kania avikhana. Deus va'ora va'adipa'itxiki bana adani Tiro sidaji kaija'arini, Sidom sidaji kaija'arini vihiki. Hojai asohirikia vakahojaina kaba'i, Deus va'ora va'adipa'itxiki adani. A'onivani Corazim, Betsaida sidajia avahojaki. Ni-Deus a'onira va'adipa'itxirihi bana. ");
INSERT INTO padNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A'onivani Cafarnaum sidaji kaija'arini, jahariki bana ida avakadimoni. Ni-avakava'ipahinipa'itxiki ida Jahari kabadani. Avakava'ibodivaranimanija koda ida Deus kania avarikhani Ibavi Jahaka'oakia. Ni-avarikhapa'itxiki. Deus ija'ari hahavi-ra nasohivini kamahini, Deus a'onira nahokahiki bana a'oni Ibavi Jaharika'oakia. Bada oni'avini kaba'i ida Deus kabadani danoki ipohiki avakadiania, ni-avakava'ipahini'iaki kaho ida Jahari kabadania avakabadanibakhiani. Bada oni'aja vaha ida Deus kabadani danoki Sodoma sidajia; Jahari kabadani-ra vakava'ipahini'bo'damaniha vaha; ni-Deus va'ora nihimaki vaha adani Sodoma kasidajini kaija'arini. Asia hojahi vaha ida sidaji. ");
INSERT INTO padNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Vakava'ibodivarani bana ida. Deus ija'ari hahavi-ra nasohivini kamahini bihonariaki bana ida imai 'banani ija'ari hojai asohirikia vakahojaiki vakadimoni. Sodoma sidaji kaija'arini ni-vanoki'iaki kaho ida kodibadani danoki, oniani ida bana Deus va'ora va'adipa'itxivini hija. A'onivani kodibadani-ra avanokivini kaba'i, asia hora avakajari'dahi, oniani bana ida Deus a'onira va'adipa'itxiravini hija — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Oniaroa, Deu-ra vara ni'aha ada Jesus: —Kodiabi'i, ivani ivaka'da'diki ida ija'ari hahavi nama, arabo hikia vahojaki. Khai ira oni'avini hiki ida idanoni-ra inanokiavini. Ija'ari vaabono vavaboraborahariki-ra va'ora inanokiahi'iki idanonia. Vakadi'ogahai pa'itxini-ra avigaki adani. Vahoariha vani adani vakadi'ogahai karaho-ra vakava'ibodivaranira, ni-vakadiania idanoni-ra inanokiaki. ");
INSERT INTO padNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hai oamani, kodiabi'i, jahaki hida inofi'iki. Va'ora inofiki adani vakadi'ogahai pa'itxini-ra avigaki idanoni-ra avigavini. ");
INSERT INTO padNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Hari. Jesus va'ora ni'aha adani vajoroniki: —Kodiabi'i hora no'avini hi'iki ida kidi'ogahai, kidinahina hahavi hiki. Ni-ija'aria biogaki ida Deus kaisai ohina. Kodiabi'i ka'oa biogaki ida. Ni-ija'aria biogaki ada kodiabi'i. Hovani ka'oa oogaki ada. Ija'ari kodiabi'i-ra ogavini-ra onofihi; oanigahihi, biogara kaimoni ada kodiabi'i. ");
INSERT INTO padNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Hari. Asia vara niha ada Jesus: —Daji khanaki-ra kaiba'iki fori hiki ida ija'ari abononi akava'ijoavini-ra kaijo'avini. Va'ora obaranahaki adani daji khanaki fori hiki-ra vakaiba'iki kodiania vikhana, oanija kaimoni ida vadaina. Avadaini-ra oanivini-ra avava'ahahi; ni-nahina-ra avarakava'isokonijanaki. ");
INSERT INTO padNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hora vavaipohiha'a mahija kodihojai-ra avaka'ojomo'ivini. Ovajahaki ida hoariha-ra okajoamoravini, va'ora onakaidivaki adani ija'ari. Oipohina avihihi; avakadihojai asohiriki-ra ona'birahi, avava'ini soko inijanaria kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Daji khanariki fori hiki ida hojai a'onira ohonariavini hiki. Daji horihoriki fori hiki ida hojai jahakia avakahojaini-ra ohonariavini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hari. Oniaroa, judeus kaija'ari vakadi'akoiri kamahini vani, avikafianiribani'aha adani Jesus trigo kasiroinia. Ipohina vihiki vavai'amina mani ida trigo bononi ja'dini-ra avara'birimivini hija. Varisi'ihi, vaha'ihi ida trigo 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Oniaroa, farisioa vanoki'ihi ida trigo bononi-ra varisivini, vani'aha ada Jesus: —Deus kava'isohihi jiriki ija'ari-ra honariavini hiki ija'ari bada nirini aakoirina kamahini. Ni-jahaki ida iipohini Deus kava'isohihi jiriki-ra vanaabaravini. ");
INSERT INTO padNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesua bigathani'ihi ida vaathi: —A'onira vara oni'avini hiki ada akadija'ari avikhananavaki Davi kohana. Deus athi kapapirania hojaki ida Davi varani hina. 'Bo'dakari vavai'amiha adani Davi kidipohi khama. ");
INSERT INTO padNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deu-ra khai vani'avini kagorani kania avikhajakosi'aha adani Davi. Hari. Gora bodinia kahoja'iki ida pão. Deu-ra kanava'iga'imidiaki ida pão, naothinia sasidotxi ka'oa vakahaki ida. Nimania ida Deus kava'isohihi jiriki haria nava'isohivini hiki. Sasidotxi vihiriha adani Davi kidipohi khama. Kaba'i, Davia bikaha'iki ida pão gora bodinia kahojaki. Kidipohi-ra va'ora no'avini kihi'ihi jaboni. Vavai'amikarahona mani ida sasidotxi va'ora va'adivini hija, pãoa va'ora no'avini hija. Ni-Deua bivajahariki ida pão-ra vakahavini. ");
INSERT INTO padNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Avanokiria koda ida Deus kava'isohihi jiriki pitani? Sasidotxia bada vani'aki ida badani Deua bihonariaki Deu-ra khai vani'avini kagorani kania aakoirina kamahini kaba'i. Sasidotxia vanakaidivaki ida Deu-ra khai vani'avini kagorani, oniani ida Deus vakadibadani aakoirina kamahini bivamakhaniravini hija. ");
INSERT INTO padNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka'oa oamani hida kodivarani. Avanakaidivavini kaba'i ida Deu-ra khai avani'avini kagorani, hojaki ada ija'ari hoarana avahararania avanakaidivavini arafiaki kaimoni — niha ada Jesus abono-ra vara vani'avini. ");
INSERT INTO padNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Asia vara niha ada Jesus: —Deus athi kapapirani haria nava'isohivini hiki ida: “Onofiki ida nahina hora avakanava'igavini. Onofikarahoki ida vahoariha-ra va'ora avava'adivini.” Avarigaja vaha hida athii nahina hini; ni-va'ora avaranaathidanoarari'imariniki vaha adani kodipohi Jahari kabadania vakabadaniriki. ");
INSERT INTO padNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hovani ija'ari hahavi vakadi'aajo ho. Hovani ka'oa oogaki ida badani hana hini jahaki ija'aria bada bini'aki kaimoni akoirina kamahini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Oniaroa, ajihi'aha ada Jesus. Okha'ianaha judeus kaija'ari Deu-ra vara vani'avini kagorania. Okhajakosi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hojamaniha ada makhira sa'a akasakarabakosiki. Vahojaki jaboni adani ija'ari Jesus kabadani-ra vavajahariki. Vavajaharihi ida Jesus ija'ari kavamoniki-ra anaihotavini avakoirina kamahini, oniani ida Jesu-ra avanaathidanoararivini hija. Vani'aha: —Inaabariki ida Deus kava'isohihi jiriki. Ni-biva'ahaki ida ija'ari kavamoniki-ra anaihotavini aakoirina kamahini. ");
INSERT INTO padNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesua bigathani'ihi ida athi: —Aakoirina kamahini voroniki ida ovilia hodi bihiaki bodinia, ija'aria bikaijo'aha'oadahaki ida kidi'ovilia-ra akava'ijoavini aakoirina kamahini. ");
INSERT INTO padNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jahaki ida ovilia-ra akajoamoravini aakoirina kamahini. Jahani arafiaki ida ija'ari-ra akajoamoravini, oniani ida Deus kava'isohihi jiriki ija'ari hoariha-ra kajoamoravini-ra va'ahavini hija aakoirina kamahini. ");
INSERT INTO padNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hari. Makhira-ra ni'aha: —Isa'ani-ra akanavira'a! Sa'a-ra akanavira'aha, akaihota'ihi ida sa'a. Sa'a kahoariha fori kihi'ihi ida sa'a akaihota'ini. ");
INSERT INTO padNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Oniaroa, vaihamahikaraho'aha adani farisio. Jesus makhira-ra anaihotavini mani ida vava'i najokojokoka'oani hija. Vaabono vara vakani'akhama'aha: —Ni-jahapa'itxiki ida ija'ari kavamoniki aihotani kabadanihia kabadanina aakoirina kamahini. Niha ani'a'aki koda ada Jesus. Abinina jahaki ada — vakhani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hari. Jesua biogaki ida vanaabinivini vanofivini oniaroa, ajihi'aha. Ija'ari vaipohikia vavaipohiha'aha. Jesus va'ora anaihota'aha adani ija'ari vakavamoniki hahavi. ");
INSERT INTO padNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Va'ora ni'a'aha: —Hari'a va'ora vananamitha bana adani ija'ari vahoariha kodibadani danokia okabadanina — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mahi 'bo'dakari Deus athi namoniva abono Isaías kohana onikia binajiri'iki ida Cristo varani hina namitha'iariki. Jesus vania bada bini'ahahavi'ia ida Isaías vara bivani'ajora'iki. ");
INSERT INTO padNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Isaías bini'ajora'iki: “Deua bini'aha: ‘Hada vani kodihonai abono. Onagathogatho'iki ada. Onofijahakiki ada. Khai hora ni'aki ida hojana hiki. Onaibaviki bana ada Ma'onahai Jahaki va'i bodinia. Ovari va'ora nava'isohiki bana adani arabo hahavi kaija'arini va'ora onasohira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Vara nina kamahini, ni-jahana abono-ra vaboraborahariha ada. Ni-kamadiaki fori hiriha ada bana hagihia ija'ari vaipohiki vajoroniki vahararana. Ija'ari vakadika'da'di hoariha fori hiriha bana ada. ");
INSERT INTO padNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Va'ora va'adiki bana adani vava'i jahajahariki. Mosori kaa'dariki fori hiki ida ija'ari va'ini jahajahariki. Ovaria binajahaki ida vakadimahi. Lamparina daijanariki fori hiki ida ija'ari Jahari kahojaia kahojaiki. Ovaria biakava'ijoaki ida bana. A'diahirini oadani ida kidibadani, binasohiha'oadahaki ida nahina Jaharia binajahariki. ");
INSERT INTO padNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Arabo hahavi kaija'arinia vakamithaki bana ida varani hina. Vaipohiki bana adani ija'ari vakaijokana vihiki.’ ” Nimania ida Deus athi kapapirania hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hari. Oniaroa, Jesus kania avavikha'aha ada makhira kabajadina bikanamaodorohaki, abani biana'dakharariki jaboni ada. Jesua bihonariaki ida bajadi akara'oni makhira kania. Nokho avagaha'ianaha, varavara'ianaha jaboni ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ija'ari vaipohiki vajoronikia vakava'ibodivaranikaraho'aha ada Jesus. Vanana'dohiha: —Ka'da'di koda ada Jesus. Davi kohana ka'da'di fori hina hiki koda ada. ");
INSERT INTO padNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Oniaroa, farisioa vakamithaki ida vakadina'dohi, vakhaniha: —Iniani, bajadi vakadika'da'di Biosibo Jahari onikia bino'aki ada Jesus danona, bikaabokaja kaimoni ida bajadi akara'o'ini. ");
INSERT INTO padNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesua biogamanihi ida vakava'ibodivaranivini, va'ora ni'aha: —Rajomi kavaranihi-ra vara ovani'aki bana ho, avarigaja kaimoni ida Jahari hora no'aravini danona. Arabo kaija'arini vaabono vakodakhamaha; vaabono vakanihimakhamaha. Sidaji kaija'arini vaabono vakodakhamaha; vaabono vakanihimakhamaha jaboni. Gora kaija'arini vaabono vakodakhamaha; vaabono vakanihimakhamaha jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Vakhaniha vaha jaboni adani Jahari kaija'ari vanokiariki, vaabono vakodakhamaha; vaabono vakanihimakhamaha jaboni. Ni-vahojajanaki vaha adani kidija'ari Jahari va'ora vaka'da'diki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Avakadivarani hiki ida Biosibo Jahari hora no'avini danona, bajadi akara'oni-ra ohonariaja kaimoni. Ni-asohiki ida avakadivarani. Avaipohini jabonia vakaabokaki ida bajadi akara'oni. Ka'oa hija vaha ida avakadivarani, Jahari vani koda danona va'ora no'ara adani avaipohini? Ni-Jahari va'ora no'ariha adani danona. Bajadi akara'oni-ra vakaabokavini mani ida Deus danona-ra avigavini hija. Bajadi akara'oni-ra vakaabokavini mani ida avakadivarani asohirikia avaipohini haria vananokiahivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Deus hora no'avini hiki hida odanona, oniani ida bajadi akara'oni-ra okaabokavini hija. Deus danona-ra ovahojavini mani ida Deus kha'ina-ra avarigavini hija, ija'ari-ra va'ora vaka'da'dira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ija'aria ni-bikaabokaki ida nahina makhira danoki gorana bodinia hojaki-ra saarivini. Makhira danoki-ra daboha'imidiaki ida ija'ari, oniani ida kidinahina ipohiki bisaarivini bikaabokavini hija. Makhira danoki fori hiki ada Jahari. Odanona biaradaki ida Jahari danona. Odaboha'iki fori hina mani ida bajadi akara'ona okaabokavini hija — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hari. Asia vara ni'aha ada Jesus: —Ija'ari hora kakodiariki ni-hora nofiki. Kodija'ari-ra va'ora onajoronivinia hora vaakodiariha; va'ora akarakhakhamaha. ");
INSERT INTO padNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ka'oa oamani ida oni'aki, Deua bikaabokaki ida hojai asohiriki-ra na'biravini. Ija'ari varani jaharikia Deu-ra vakanavaranihavini, Deua bikaabokahi ida varani jahariki-ra na'biravini jaboni. Ija'aria Jahari kabadani hini bikahihi ida Ma'onahai Jahaki kabadani, jokoa Deua bina'birarihi ida ija'ari kavarani jahariki. ");
INSERT INTO padNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hovani ija'ari hahavi vakadi'aajo ho. Varani jaharikia ija'ari hora kanavaranihahi; Deua bikaabokaki ida varani jahariki-ra na'biravini. Varani jaharikia ija'ari Ma'onahai Jahaki-ra kanavaranihahi; ni-Deua bina'biraki. Hokini oadani ida ija'ari, ni-Deua biakariakaki. Abinini naothinia asia hojaki ida kidivarani jahariki, ni-Deua bina'birapa'itxiki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Hari. Vara ni'ianaha ada Jesus: —Avanokihi ida kodibadani jahaki; avarigahi jaboni ida ojahaka'oana. Jahahi ida ihi'ai avani; jahahi ida jaboni ihi'ai bononi. Jaharihi ida ihi'ai avani; jaharihi jaboni ida ihi'ai bononi. Ikaijo'ahi ida ihi'ai; iogahi ida ihi'ai jahani jaharini. Nini vani iogaja ida ihi'ai avani jahani jaharini. Ija'ari kahojai fori hiki ida ihi'ai bononi. Ija'ari jahaki, kidihojai jahaki jaboni. Ija'ari jahariki, ni-kidihojai jahaki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Makha fori avihiki a'oni, ija'ari-ra avanapohimajaki fori avihiki a'oni. Ni-nihanikia vara avavani'aki ida varani asohiki. Jahari kahojai ija'ari va'ini bodinia bivajahahi; jahariki jaboni ida kidivarani. ");
INSERT INTO padNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ija'ari jahaki va'ini bodinia hojaki ida va'i bodini vara nini jahaki. Jahahi hida kidiva'ibodivarani, oniani ida varani jahaki-ra vara vani'avini hija. Ija'ari hojai jaharikia kahojaiki va'ini bodinia hojaki ida va'i bodini vara nini jahariki. Jaharihi hida kidiva'ibodivarani, oniani ida varani jahariki-ra vara vani'avini hija. Ija'aria vara bivani'aki ida bikava'ibodivaraniki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Deus ija'ari-ra nasohivini kamahini, Deua binava'ihokiki bana ida ija'ari hahavi afohanana varani jaharikia vakavaraninanaki. Deu-ra vananamithavini hiki bana ida varani hahavia vakavarani'ina. ");
INSERT INTO padNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Deua bikava'ihokiki ida bana ija'ari kavarani hahavi vara bivani'a'iki. Deua biogaki ida ija'ari kahojai abosini. Jahahi ida ija'ari, jahahi ida ija'ari vara bivani'a'iki, oniani ida Ibavi Jahaka'oaki kania okhani Deua bihonariavini hija bana. Jaharihi ida ija'ari, jaharihi ida ija'ari vara bivani'a'iki, oniani ida Ibavi Jaharika'oaki kania okhani Deua bihonariavini hija bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hari. Oniaroa, Jesus kania vahojaha adani judeus kaija'ari vaka'ojomo'iva abono vaipohiriki, farisio khama. Jesu-ra vani'a'aha: —Jesus, anokivini anofiki ida Deus kabadani danokia ikabadanini, aogaja kaimoni ida Deus ira karonavini. ");
INSERT INTO padNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesua bigathani'ihi ida vaathi: —Jahari kahojaia vakahojaiki adani ija'ari hidakaba'i vahokiki. Deu-ra vakajari'daki adani. Avanokivini avanofiki ida Deus kabadani danoki. Jokoa a'onira onanokiahirihi badani danokia. A'onira onanokiahivini hiki bana ida rajomi hoarani. Deus kabadani danoki Jonas kohana kania namitha'iki rajomi hini hoarania a'onira onanokiahiki bana ho. ");
INSERT INTO padNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vakava'ibodivarani'a bana ada Deus athi namoniva abono kohana Jonas oniki. 'Bo'dakari abaisana karahoa bikidafi'iki ada Jonas. Mahi ahoarabakosiki, joma ahoarabakosikia jaboni hoja'aha ada Jonas abaisana kaijona. Ni-abini'iki. Ka'damahaki fori hina hoja'iki ada. Onivani fori hija bana ida namithaki kodiania. Arabo nami bodinia ohojaki bana ho oka'damahana, mahi ahoarabakosikia, joma ahoarabakosikia jaboni. Abaisana kaijona khaonanina naothinia, Nínive sidaji kaija'arinia vanoki'aha ada Jonas. Vanokivini vani avigaha ada Jonas Deua bikaronavini. ");
INSERT INTO padNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive sidaji kaija'arinia vakamitha'iki ida Jonas va'ora kaabanivini, vakava'ipahinimani'ihi ida vakadihojai asohiriki. Deus ija'ari hahavi-ra nasohivini kamahini ija'ari vajoroniki vahararana vahojaki bana adani Nínive sidaji kaija'arini. A'onira avanaathidanoararivini hiki bana ida avakadihojai asohiriki-ra avakava'ipahiniravini. Hidakaba'i ohojaki ho avakadiania, oaradahaki ida Jonas jahana, a'onira okaabanidanokiki ho, ni-avanofiki ida avakadihojai asohiriki-ra avakava'ipahinivini. ");
INSERT INTO padNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Rajomi hoariha ida kodivarani. Deus ija'ari hahavi-ra nasohivini kamahini, ija'ari vajoroniki vahararana hojaki bana ida gamo Sabá sidaji kaija'arini vakadika'da'di. A'onira anaathidanoararivini hiki bana ida oathi-ra avakajari'davini. 'Bo'dakari hojaki ada Salomão oniki. Ogahaki ada Salomão. Sabá sidaji kaija'arini vakadika'da'dia binavanavanahaki ada, bikamithaja kaimoni ida Salomão athi jaboni. Hovani kodi'ogahai Salomão aagahai-ra aradaki. Hahavi-ra oogavini kaba'i, oathi-ra avakajari'daki a'oni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Hari. Vara ni'ianaha ada Jesus: —Ija'ari kania akara'o'ihi ida bajadi, adaha'ihi kaija'aririki kaarabonia. Binako'dihahi ida ibavi biavakoiriki kaimoni. Bikaragarihi ida ibavi, abononi ni'ahi: “Oajoiki bana ho ogorana. Ija'ari kania oakara'o'ina, kidiania oajoiki bana ho.” Oniaroa, joi'ihi bikaraga'ihi ida gora bodini jaha'ini dairiki. ");
INSERT INTO padNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Oniaroa, ajihi'ianahi ida bajadi va'ora anikha'aha adani ipohini 7 vihiki vaipohina vajaharina arafiaki, ija'ari kania vahojara kaimoni. Bajadi hoarani hojani kari, jaharini ida ija'ari kamahi. Bajadi vaipohiki vahoja'aha ija'ari kania, jaharini arafia'ihi ida ija'ari kamahi. Vakhanimanira bana adani ija'ari hidakaba'i hora vakajoniki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Oniaroa, Jesus ija'ari-ra va'ora ka'ojomo'ivini kaba'i, vikha'aha adani Jesus kaamia, kidikajo'o vihiki. Gora banininia vigaaboaha'aha vani'aha: —Anofiki ida Jesu-ra vara ani'avini — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Oniaroa, ija'ari Jesu-ra nava'isohi'aha: —Jesus, adani gora banininija vahojaha kadamia, kadakajo'o vihiki, ira vara vani'avini-ra vanofiki adani. ");
INSERT INTO padNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hari. Jesus va'ora ni'aha: —A'onira onanokiahivini hiki hadani kodiamia, kodikajo'o fori vihiki. ");
INSERT INTO padNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Oniaroa, Jesus va'ora arajo'i'aha adani ipohina, nihaha: —Vada va'ora vani'a'a hadani kodipohi. Kodiamia, kodikajo'o ka'oa fori vihiki adani. ");
INSERT INTO padNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ija'aria binofiki ida hojai jahaki kodiabi'i nama hojaki bivajahaki, binaabahi jaboni ida kodiabi'i athi; kodikajo'o, kodiamia fori vihiha. ");
INSERT INTO padNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hari. Oniaroa, gora bivahojaki kania khaonani'aha, ajihi'aha ada Jesus. Galiléia ka'dakoni vadini maakarinia okharafoni'aha, vithi'aha. Oniaroa, va'ora ka'ojomo'i'aha adani ija'ari vajoroniki. ");
INSERT INTO padNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ija'ari vaipohikia vavajoronivini mani ida naki'damana hija. Kanava vithi'aha, va'ora ka'ojomo'i'aha adani ija'ari pasapasania vahojaki vigaagaboahaki. ");
INSERT INTO padNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rajomi kavaranihia va'ora vara ni'a'aha: —Siroia okhaha ada makhira, binatxiotxiohi ida trigo 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Hagihi vadinia vararahi ida 'ba'dani hoarahanana. Avigariha adani igitha, vitxagatxagahahavi'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ja'di namania vararahi ida 'ba'dani hoariha. Abihiarihi ida nami ja'di namania. Odorihi ida nami, movajoraki'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","'Damani abohani abihiarini mani ida safini afana bianara'okhovini hija. ");
INSERT INTO padNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hogoi kajaroiki kania vararahi ida 'ba'dani hoariha. Mova'ihi ida jaboni hogoi, rakhajahi-ra najahari'ihi, ni-bono'iki. ");
INSERT INTO padNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Arabo jahakia vararahi ida 'ba'dani hoariha. Movahi, avijavahi, bono'ihi. Aipohi'ihi ida trigo 'ba'dani. Trigo avani hoarahanana 'ba'dani ipohini 100. Trigo avani hoarahanana bononi 'ba'dani ipohini 60. Trigo avani hoariha bononi 'ba'dani ipohini 30. ");
INSERT INTO padNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Avamorobohahi; mitha vani'ajahaki hida oathi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hari. Ija'ari vaipohiki vahojajanarina, Jesu-ra vanamaakari'aha adani ipohina, vanana'dohi'aha: —Nahina mani ida rajomi kavaranihia vara va'ora ini'abakhiavini hija? ");
INSERT INTO padNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesua bigathani'ihi ida vakadina'dohi: —Deua binofiki ida avarigavini, oniani ida Deus ka'da'di hina kavaranihia a'onira onanamithajahakivini hija. Ija'ari vahoariha ni-avigavini vanofiki ida varani Deus va'ora vaka'da'divini. Ogavahariki hida varani vakadimoni hini. ");
INSERT INTO padNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Avakamithabakhiaki hida oathi. Avanaabavini mani ida avakadi'ogahai-ra oana'ba'divini hija. Vahoariha oathi-ra vakamithaki, ni-vanaaba'iki ida oathi pa'itxi vakamithaki, oniani ida avakava'i'birinivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Vakhanina vani rajomi kavaranihia vara va'ora oni'avini. Vada vani'avini kaba'i ida kodibadani danoki, ni-vanofiki ida kodihojai-ra vanokivini. Oathi-ra mitha vani'avini kaba'i, ni-vanofiki ida nahina hini avigavini. ");
INSERT INTO padNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Namitha'iki ida vakadiania Deus athi namoniva abono Isaías kohana vara va'ora ni'ajoravini hi'iki: “Avakamithavini kaba'i ida athii, ni-avarigaki bana nahina nini. Vada avakhanini kaba'i, ni-nahina-ra avanokiki bana. ");
INSERT INTO padNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Avigavini vanofiravini mani ida vakadiva'ibodivarani ka'oahaki fori va'ora nihaja. Kamokhihaki fori kihiki ida vamorobo. Modo vani'aki fori hiki ida vanokho. Vava'i bodinia avigavini vanofija vaha; vakamithavini vakaabokamanihi vaha; vakaabokaki ida nahina-ra avigavini jaboni. Avigaja vaha hida Deus athi; kodiania vajoiribanimaniha vaha; va'ora anaihotamaniha vaha.” Nimania ida Deus athi Isaías vara bivani'ajora'iki. ");
INSERT INTO padNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Asia vara ni'aha ada Jesus. Kidipohi-ra va'ora ni'a'aha: —Deus a'onira kajoamoraki a'oni. Va'oaniaro fori avihiriki a'oni. Vagahaki fori hiki oni avanokhoni 'ba'dani. Kamokhihariki fori kihiki ida avamoroboni, oniani ida Deus athi nahina hini-ra avarigavini hija. ");
INSERT INTO padNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A'onivani avanokibakhiaki hida kodibadani, avakamithabakhiaki hida kodivarani. A'onira onava'isohiki bana ho, mahi 'bo'dakari vaipohiki adani Deus athi namoniva abono kohana, Deus kaija'ari kohana vahoariha khama vanofiki ida kodibadani-ra vanokivini, ni-vakaabokaki vanokivini. Kodivarani-ra vakamithavini-ra vanofiha, oniaro kari ni-vakaabokaki. ");
INSERT INTO padNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mitha vani'ajahaki bana hida kodivarani mahija trigo 'ba'dani karajomihi kavaranihi nahina hini-ra avarigavini. A'onira onava'isohivini hiki ida nahina hini. ");
INSERT INTO padNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Trigo 'ba'dani fori hiki hida oathi. Ija'ari fori hiki ida arabo. Hagihia vararahi ida trigo 'ba'dani. Igitha vitxagatxagahahavi'ihi. Onivani fori hini ija'ari vahoarahanana vakamithaja ida Deus ija'ari-ra vaka'da'divini kavaranihi. Ni-avigavini vanofiki ida varani nahina hini. Oniaroa, khaki ada Jahari Deus athi-ra anihavini va'ini bodinia, oniani ida Deus athi-ra avakava'i'birinivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ja'di namania vararahi ida trigo 'ba'dani hoariha. Kanamini odorini movajoraki'ihi. 'Damani abohani abihiarini mani ida anara'okhoni hija. Movani kama'dani vani ara'okho'ihi. Onivani fori vihira adani ija'ari vahoariha Deus athi-ra vakamithaki. Vanofihi, khai vakhanimaniha. ");
INSERT INTO padNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mahi ipohiriki vani khai vani'aja ida Deus athi. Deus kaija'ari vihina mani ida vahoariha va'ora vanajahariharivini hija. Nahina jahariki namithahi vakadiania, oniani ida Deus athi-ra vakava'ipahinivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hogoi jaroki 'damania vararahi ida trigo 'ba'dani hoariha. Hogoia binajaharihi, bonohi, ni-a'di'iki ida trigo bononi. Onivani fori vihira adani ija'ari vahoariha Deus athi-ra vakamithaki. Vakava'ibodivaraniha'oadahahi ida vakadi'bai-ra vanako'dihavini, vakadinahina-ra vakapavakarihavini, vakadibadani hiki. Vaabono vani'aha: Ni-nahina-ra okainamoki; jahahi ida kodimahi. Vakhaniki adani. Hari. Nahina ipohiki-ra vanofikarahovini mani ida Deus athi-ra vanofijahakiravini hija, oniani ida Deus athi-ra vanaabaravini hija jaboni. Onivani fori hija ida rakhajahi, ni-bonoki ida arabo rakhajahani, onivani fori vihiki adani ija'ari vamorobohariki fori vihina. ");
INSERT INTO padNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Arabo jahakia makhira binatxiotxiohi ida trigo 'ba'dani hoariha. Movahi, na'baha'ihi, bono'ihi. Aipohi'ihi ida 'ba'dani. Arabo jahaki fori vihiki adani. Onivani fori vihira adani ija'ari vahoariha Deus athi-ra vakamithaki. Vakamithahi, avigahi ida Deua binofiki bada vani'avini, oniani ida vanaabajahakivini hija. Trigo 'ba'dani 100 hiki vani fori vihira adani ija'ari Deus athi-ra vanaabajahakiki. Trigo 'ba'dani 60 hiki vani fori vihira adani ija'ari Deus athi-ra vanaabavini doronini. Trigo 'ba'dani 30 hiki vani fori vihira adani ija'ari Deus athi-ra vanaabavini pa'itxini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Oniaroa, Jesua vara bivani'a'ianahi ida rajomi kavaranihi. Va'ora ni'aha adani ija'ari vajoroniki: —Kodivarani hi'ianaki ida Deus ija'ari-ra vaka'da'divini. Makhira binatxiotxiohi ida trigo 'ba'dani jahaki kidisiroia. ");
INSERT INTO padNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Joma vania vavadi'aha adani makhira, kidija'ari hahavi khama. Vavadina kaba'i, kha'aha ada hoariha makhira-ra vajahariki. Trigo kasiroini kania binatxiotxiohi ida hogoi 'ba'dani trigo kania. Trigo nokiani fori hiki ida hogoi. Birakhaivini naothinia ajihi'aha ada makhira jahariki. ");
INSERT INTO padNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hari. Mova'ihi ida trigo 'ba'dani, movahi jaboni ida hogoi 'ba'dani. Na'baha'ihi, bono'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Oniaroa, siroi kaka'da'dini kania avikha'aha adani kidibadani abono, vani'aha: “Inatxiotxio'iki ida trigo 'ba'dani jahaki kadasiroia. Niha nimanija koda ida hogoi movajabanaki trigo hararania?” ");
INSERT INTO padNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Vakadika'da'dia bigathanihi ida vakadina'dohi: “Hora vajahariki kabadani ida hogoi 'ba'dani-ra natxiotxiovini kodisiroia.” Vanana'dohi'aha: “Inofimanija koda ida hogoi-ra arasohasohavini?” ");
INSERT INTO padNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ka'da'dia bigathanihi ida athi: “Iniani, jakaho hoja'imidiava ida hogoi. Avijavarini oadani ida hogoi nokiani trigo avani fori hiki ida. Avarasohahi ida hogoi, karasohajahahi ida trigo avani itxani jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A'dirini oadani ida bononi, jakaho hojava ida hogoi avani. A'boahahavini kamahini va'ora ohonariaki bana adani badani abono hogoi avani-ra varasoha'imidiavini, vanajoronivini vanahokahivini siho kabodinia. Hari hini ida hogoi kabadanihi, va'ora ohonariavini hiki trigo bononi-ra avibaivini trigo kagorania.” Niha ada vakadika'da'di — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hari. Vara ni'ianaha ada Jesus: —A'onira vara oni'avini hiki ida bana rajomi kavaranihi hoariha. Mostarda 'ba'dani avijavani vani fori hiki ida Deus ija'ari-ra vaka'da'divini. Itxanini arafiaki ida mostarda 'ba'dani. Ija'aria birakhaihi ida mostarda 'ba'dani kidisiroia. ");
INSERT INTO padNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Movahi, avijavahi, karahoki ida mostarda avani patxapatxahaki. Vadini avijavani na'bahaki jaboni. Igitha raboki kagorahaki vadinia. Itxani arafiaki ida ba'ba'da, kaba'i, mostarda 'ba'dani, movahi, avijava'ihi, karaho'ihi — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Hari. Asia vara niha ada Jesus: —Okavarajomiki bana ida Deus ija'ari-ra vaka'da'divini. Pão kaimani-ra kanathoramananiki vani fori hija ida Deus ija'ari-ra vaka'da'divini. Gamo vania bigathija ida pão-ra kanathoramananiki pa'itxi, binaibavi'ihi ida trigo karaho, biara'bira'ihi bavi hoarani bodinia. Pa'itxini kaba'i ida pão-ra kanathoramananiki, biara'biravini naothinia kathoramanani'ihi ida pão kaimani hahavi. Nimania ida Deus ija'ari-ra vaka'da'divini avijavani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus vara va'ora ni'aki adani ija'ari vajoroniki rajomi kavaranihi ipohikia. Rajomi kavaranihi ka'oa-ra vara vani'aki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","'Bo'dakari Deus athi namoniva abono kohana vara bivani'a'iki ida Jesus kahojai rajomi kavaranihia kavaranina, bini'aha: “Vara va'ora oni'avini hiki bana ida rajomi kavaranihi. Nahina ogavaharikia va'ora onanamithaki bana adani ija'ari hahavi.” Nihi ida Deus athi papira hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Oniaroa, Jesus va'ora nahojaha'aha adani ija'ari vaipohiki. Ai vihi'aha kidipohi khama, gora vavahojaki kania avikha'aha avikhajakosi'aha. Kidipohia vanamaakarimi'aha ada Jesus, vani'aha: —Ni-aogaki ida hogoi 'ba'dani txiotxioni karajomihi kavaranihi nahina hini. Haria nava'isohijahakivinihi bana ida varani nahina hini. ");
INSERT INTO padNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesua bigathanihi ida vaathi: —Hovani ija'ari hahavi vakadi'aajo ho. Makhira trigo 'ba'dani jahaki-ra natxiotxiovini vani fori ohija. ");
INSERT INTO padNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Arabo hahavi fori hiki ida siroi. Ija'ari Deua bivaka'da'diki fori hiki ida trigo 'ba'dani jahaki. Ija'ari Jaharia bivaka'da'diki fori hiki ida hogoi 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Makhira hogoi 'ba'dani-ra natxiotxioki fori hiki ada Jahari. A'boahahavini kamahini fori hiki ida mahi bana Deus ija'ari hahavi-ra nasohivini kamahini. Siroia vakabadaniki fori vihiki adani Deus ibavi kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Siroia vakabadanikia varasohahaviki ida hogoi, vanahokahiki ida siho kabodinia. Onivani fori hija ida bana namithaki Deus ija'ari-ra nasohivini kamahini. ");
INSERT INTO padNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Va'ora okaronaki bana adani Deus ibavi kaija'arini ija'ari vakadiania avikhana. Va'ora oni'aki bana adani: “Deus kaija'ari vahararana vahojaki adani ija'ari, ija'ari hoariha-ra vakaboroborobakhiaki Jahari kabadania vakabadanira kaimoni. Vahojaki jaboni adani Jahari kahojaia vakahojaiki. Va'ora vaani bana adani ija'ari vajahariki. ");
INSERT INTO padNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hogoi fori vihiki adani. Va'ora vanahokahi bana siho kabodinia. Vabarariaria'ahapikiki bana adani, vakanada-ra vakanakiroromisiki bana adani.” Va'ora oni'aki bana adani Deus ibavi kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Oniaroa, kodiabi'i nama hojaki va'ora vaka'da'diki adani kidija'ari. Vavagaki bana adani Deus kahojaia vakahojaiki, safini vagana fori vihiki adani bana. Avamorobohahi; oathi-ra mitha avani'ajahakihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Hari. Jesua vara bivani'ahi ida rajomi kavaranihi hoariha: —Okavarajomiki ida Deus ija'ari-ra vaka'da'divini, ija'ari jiniro 'ba'dani kaidivaki ahojaki-ra karagavini fori hini. Hoariha kasiroia adaha'aha ada makhira. Adahaha, bikaraga'ihi ida jiniro 'ba'dani kaidivaki ahojaki. Khaii ni'aha. Bikaragavini naothinia, bianahoja'ianahi ida jiniro 'ba'dani kaidivaki. Abono-ra ni'aha ada makhira: “Onofikarahoki hida siroi kodimoni hini. Hihavirihi vahabini hida jiniro okaragaki. Ida asia vahabini hojahi. Onofiki ida jiniro hahavi. Kodiani hirihi hida siroi. Okapavakarihi; ni-siroi kaka'da'dini siroi-ra onako'di'ianavini-ra nadabaki. Siroi kaidivaki arafiaki mani bana hida kodinahina hahavi-ra pavakari onihavini hija. Kodinahina abosini kajinironi-ra ogathanivini vani okapavakariki hida siroi.” Abono-ra ni'a'aha. Oniaroa ajihi'aha ada makhira. Siroi kaka'da'dini kania okha'aha, bikapavakari'ihi ida siroi. Nimania ida ija'ari Deu-ra nofikarahovini kidika'da'di hina — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hari. Jesua vara bivani'ahi ida rajomi kavaranihi hoariha: —Okavarajomiki ida Deus ija'ari-ra vaka'da'divini, makhira ja'di kaidivaki-ra nako'divini. Makhira bianako'dioniki ida ja'di jahaki kaidivaki, ja'di-ra pavakari vanihaki abono vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Oniaroa, bikaraga'ihi ida ja'di kaidivaki hoarani karaho. Jahaki kaidivani arafiaki ida. Binofi'oamani'ihi ida ja'di kaidivaki kidimoni hini. Kaidivani arafiani mani ida kidinahina hahavi-ra pavakari nihavini hija. Kidinahina hahavi abosini kajinironi-ra gathanivini vani bikapavakarihi ida ja'di hoarani kaidivani arafiaki. Hari. Nimania ida ija'ari Deu-ra nofikarahovini kidika'da'di hina — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hari. Jesua vara bivani'a'ihi ida rajomi kavarani hoariha: —Vara ovani'a'ianaki ida Deus ija'ari-ra vaka'da'divini nahina fori hini. Tahafa 'dakoa ija'aria biakosonavini vani fori hija ida. Ija'aria biakosonahi ida tahafa, bianagithi'aha ada abaisana ipohiki. ");
INSERT INTO padNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kaji'biniki ida tahafa, araba abonoa vakara'baniki avako'omisi'aha. Kaasia pasapasania vavithi'aha, vakanapitakhama'aha ada abaisana. Vanaibavi'aha ada abaisana havahaki kaimoni so'oroa. Vanahokahi'aha ada abaisana havahariki. ");
INSERT INTO padNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Abaisana-ra vakanapitakhamavini vani fori hiki ida Deus ibavi kaija'arini vakadibadani bana, ija'ari-ra nasohivini kamahini. Avikhaki bana adani Deus ibavi kaija'arini ija'ari vakadiania. Va'ora vaaniki bana adani ija'ari Jahari kahojaia vakahojaiki, ija'ari kahojai jahaki vahararana. ");
INSERT INTO padNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Va'ora vanahokahiki bana adani ija'ari Jahari kahojaia vakahojaiki siho kania. Oniania vabarariaria'ahapikiki bana adani, vakanada-ra vakanakiroromisiki bana adani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Oniaroa, Jesus va'ora nana'dohi'aha adani ipohina: —Avarigamanija hida rajomi kavaranihi va'ora vara oni'avini hi'iki nahina hini? —Ha'a, oogaki — vagathani'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesus va'ora ni'aha: —Vara a'onira oni'avini hiki ada judeus kaija'ari ka'ojomo'iva abono. Ovaria biogajahakiki ida athi jiriki Deus athi kapapirania hojaki. Oathi-ra kamithavini vani kodipohi hi'aha ada makhira. Kodipohi hina mani ida oathi-ra ka'ojomo'ivini hija. Ija'ari kanahina'ahapikiki fori hiki ada makhira. Dano'oamanija ida kidi'ogahai. Biogaki ida athi 'bo'da-ra vara vani'avini Deus athi kapapirania hojaki, biogaki jaboni ida oathi ja'dini-ra vara vani'avini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hari hi'ihi ida Jesus rajomi kavaranihia kavaranina, ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bivavijavaki kania joi'ianaha, kaikahi'aha. Jesua bivavijavaki ibavi onini Nazaré. Jesus va'ora ka'ojomo'i'aha adani judeus kaija'ari Deu-ra vara vani'avini kagorania. Oniania mitha vani'ahi ida kidivarani, Jesu-ra vakava'ibodivarani'aha. Vaabono vakani'akhama'aha: —Hanaja vani bivikhaja ida kidi'ogahai danoki? Niha bini'a'avini koda biogaja ida badani danoki? ");
INSERT INTO padNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aogajahakiki ada. Gora namonahava abono ada kidiabi'i. Kidiamia Maria. Jesus kakajo'o adani Tiago, José, Simão, Judas vihiki. ");
INSERT INTO padNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gamo isani kidikajo'o vihiki akadiania vahojaki jaboni. Ni-nahina bika'ojomo'iki ada. Ni-anofiki ida haria ka'ojomo'ivini. Akajari'daki hida kidivarani — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nazaré sidaji kaija'arinia ni-vanofipa'itxiki ada Jesus. Oniania, Jesus va'ora ni'aha: —Ibavi hahavi kaija'arinia vagathanijahakiki ada Deus athi namoniva abono. Kidija'aria bivavijavaki kania ni-vagathanijahakiki, igamina jaboni ni-vanofijahakiki, oniani ida Nazaré sidaji kaija'arini hora vagathanijahakiravini hija — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nazaré sidaji kaija'arinia vakajari'daki ada Jesus, oniani ida kidibadani danoki naipohirini hija vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hari. Irojia bikamitha'ihi ida Jesus varani hina. Galiléia kaaraboni kaka'da'dini ada Iroji oniki. ");
INSERT INTO padNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Oniaroa, va'ora ni'aha adani kidihonai abono: —Ada ahoki'aha João Batista kohana, oniani ida badani danoki-ra kaabokavini hija — niha ada Iroji. João Batista kohana joi'iki Irojia bivanihaki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Irojia bivahonariahi'iki ada João Batista kohana gatha'ina, sa'a kodabohani. Cadeia avibai'iki ada. João Batista kohana cadeia avibaivini viahania, Irojia bikanagamoha'iki ida kidikajo'o kagamo. Filipea oniki ada Irojia kakajo'o. Irodisi oniki ida Filipe kagamo Irojia bisaari'iki. ");
INSERT INTO padNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","João Batista kohana bini'abakhia'aha ada Iroji: —Ni-jahapa'itxiki ida kadakajo'o kagamo-ra ivahojavini. Nimania ida Deus kava'isohihi jiriki athini — niha ada João Batista. Iroji João Batista athi-ra vajaharavini mani ida João gathana-ra vahonariahivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Irojia binofiki ida João Batista-ra naabinivini. Judeus kaija'ari Deus athi namoniva abono hina vakahiki ada João Batista. Iroji ni-binofiki ida judeus kaija'ari-ra va'ora naihamahivini, oniani ida João Batista-ra naabiniravini hija. ");
INSERT INTO padNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hari. Mahi biva'banaki kamahini vani, ihinika karaho amonahani-ra honaria'aha ada Iroji. Va'ora kaboa'iha adani ija'ari vakanahina'ahapikiki. Vajoronihahavi'aha, khajakosihi ida Irodisi kaisai, khajo'ihi. Irojia khai bini'ahi ida kidinabadiahi khajoni. ");
INSERT INTO padNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Khajo'ini naothinia, Irojia bini'ahi: —Nahinaro-ra inofihi; ira ono'ahi. Jokoa ira onava'iponi'imarinirihi, ika'domakia ira ono'ahi. ");
INSERT INTO padNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Irodisia bihonaria'ihi ida kidisai João Batista ka'da'di aka'boani-ra kanikhariahavini. Oniania, kidinabadiahia bikanikhariaha'aha ada Iroji: —Onofiki hidakaba'i João Batista ka'da'dia hora ino'avini bavia kabaviki. ");
INSERT INTO padNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hari. Va'i mokara ni'aha ada Iroji. Ni-binofiki ida João Batista ka'da'di aka'boani. Kidikanori abonoa vakamitharija vaha ida athi; ni-bino'aki vaha ida kidinabadiahi bikanikhariakia. ");
INSERT INTO padNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Oniania, bihonariaha ada sorara: —Iakava'boaha bana ida João Batista ka'da'di. Ikavikha hida — bini'aha. Ajihiha ada sorara, cadeia okhaha, João Batista ka'da'di-ra akava'boaha'avini. ");
INSERT INTO padNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bavi bodinia bikanahoja'ihi. Bikavikha'ihi, ima'inavi-ra no'avini kihi'ihi. Bigathanihi ida bavi baka'da'dia daiki, biakosahi, kidiamia-ra no'avini kihi'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hari. João Batista kohana ipohina vakamitha'ihi ida monina, cadeia avikha'aha aba'ona avanikha'avini. Ja'di hodijama'okia avibaiha'ihi ida aba'ona. Naothinia Jesu-ra vananamithavini hi'ihi ida João Batista pohimaja'ina. ");
INSERT INTO padNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hari. Oniaroa, Jesua bikamitha'ihi ida João Batista kohana pohimaja'ina varani hini. Bikamithavini naothinia ovani oa ki'dama'aha aakha'aha ibavi kaija'aririki-ra akanikha'aha. Ija'ari vaipohikia avigaki ida ibavi hana hini Jesus okhana. Oniaroa, vaibavia ai vihinana'aha adani ija'ari vaipohiki afohanana 'dako vadinia vikhabaoni'aha. Jesus viaha avikhananava'aha. ");
INSERT INTO padNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hari. Ako'omisi'aha ada Jesus, ogaimori'aha, va'ora noki'aha adani ija'ari vaipohiki vaviahanokhaki. Va'ora nakaidivamaniha. Ija'ari vakavamoniki-ra va'ora anaihota'aha. ");
INSERT INTO padNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Safini ajora'ina vani kidipohia vanamaakari'aha ada Jesus, vani'a'aha: —Kamahijanarihi. Kagorarihi bana hida ibavi. Ni-hojaki 'bai vakadimoni. Va'ora honaria ai vihi'ina mahija ija'ari vahoariha vaibavia 'bai-ra vakapavakarihavini. ");
INSERT INTO padNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Iniani, ni-nahina kaimoni va'ora ohonariariha adani ai vihina. A'onivani 'baia va'ora vano'a — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Vagathani'ihi ida Jesus athi: —Pão sa'ai kahoarani kihiki oavani-ra akavahojaja. Abaisana 'bamiki oavani-ra jaboni avahojaja — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Kodiania vavikha bana o abaisana, pão kihiki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Oniaroa, Jesus va'ora honariaha adani ija'ari vaipohiki arabo namania kahogoini itxani vavithithionahana. Jesua biagathani'ihi ida pão sa'ai kahoarani abaisana 'bamiki kihiki, nama vada nimananiha, Deu-ra vara ni'a'aha: —Deus, ivani ijahaki i. 'Baia haria ino'a'iki i — niha ada Jesus. Bikanapitahatahahi ida pão, abaisana 'bamiki hiki. Kidipohi-ra va'ora no'avini kihi'ihi, vakaravinaja kaimoni ija'ari vaipohiki vakadiania. Oniaroa, vakaravina'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vi'baihahavi'aha, vava'i na'bihahavimani'aha. Vi'baina naothinia Jesus ipohina vanajoroni'ihi ida 'bai ahabarini. 12 so'oro-ra vanaji'biji'biha'aha 'bai ahabarinia. ");
INSERT INTO padNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Makhira 5 mil vaipohina vi'baiki, gamo, isai vihiki vi'baiki jaboni. Ija'ari va'ahapina oamani adani vi'baira. ");
INSERT INTO padNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hari. Pão-ra vakanajoronivini naothinia, Jesus ipohina-ra va'ora honariaha: —Vaki'dama'a mahija avarakhananava'avini, avarakafianija kaimoni — va'ora ni'aha. Hari. Ai vihi'aha. Avakakafianina kaba'i Jesus va'ora honariaha adani ija'ari vaipohiki avajoina vagorana. ");
INSERT INTO padNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Va'ora kaaminavini naothinia, arabo namahikia gaimoriha ada Jesus, Deu-ra vara ni'avini kaimoni. Arabo namanija jominikosoa'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hari. 'Dako bodi pania vakavanamina kaba'i adani ipohina, vakajomini'aha. Kanava-ra aagathaniki ida sirisiriki danoki, komini kana'bahakia bikosonafarahavini. ");
INSERT INTO padNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Avagarini vani, kha'aha ada Jesus kidipohi vakadiania, adahana paha namania. ");
INSERT INTO padNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Vanokihahavi'aha ada Jesus paha namania adahana, vakaimahida'aha. Paha kapamoarihi vavaniha'avini. Vaofinina, vakabarariaria'aha: —Paha kapamoarihi bana o khara! ");
INSERT INTO padNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesus va'ora kani'a'aha: —Khai hora vakani'a! Hovani Jesus ho. Hari'a vaimahida! ");
INSERT INTO padNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Oniaroa, niha ada Pedro: —Jesus, ivani oa i koda, hora honaria paha namania oadahana kadania ookhana. ");
INSERT INTO padNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Kha'a — Jesua bini'aha ada Pedro. Hari. Kanava kabodinia aki'dafina ada Pedro. Paha namania adaha'aha Jesus kania okhana. ");
INSERT INTO padNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hari. Pedroa bikamitha'ihi ida sirisiriki danoki, ofinimani'aha. Ofinina mani ida ani'omarina nakama'dani hija. Oniaroa, bodi'bara'aha: —Jesus, hora akava'ijoa bana! ");
INSERT INTO padNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jorakia Jesua bigathi'aha ada Pedro, bini'aha: —Pa'itxi'oamanija ida hora ikajari'daravini. Nahina mani ida hora ivakaijokajanaravini hija? ");
INSERT INTO padNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hari. Oniaroa, vaki'dama'bamakhama'aha. Radaha'ihi ida sirisiriki danoki. ");
INSERT INTO padNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kidipohia vakanamasivi'aha ada Jesus, vani'aha: —Ka'oa oamani ida Deus kaisai ihini. ");
INSERT INTO padNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hari. Vakajoifiani'aha adani Jesus. Genesaré ibavi onikia avako'omisi'aha. Avigaimori'aha. ");
INSERT INTO padNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Genesaré ibavi kaija'arini va'ora vanoki'aha, Jesu-ra avigajoraki'aha. Ija'ari Jesu-ra vanoki'iki avakahoaraharahanakhama'iki vakavamoniki-ra va'ora vanava'isohiha'avini afohahavi. Ija'ari vaipohiki va'ora avavikha'aha adani vakavamoniki Jesus kania va'ora anaihotara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Vakanikhariaha afohanana: —Jakaho kadamakari ihini-ra vakaabadava — vani'aha. Jesus kamakari ihini-ra vakaabadabadarisahakhamaha avaihotahahavi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hari. Jesus kania avikha'aha adani farisio vaipohiriki, judeus kaija'ari vaka'ojomo'iva abono khama. Jerusaléa vikhaki adani, Jesu-ra vara vani'ara kaimoni. Jesu-ra vanana'dohi'aha: ");
INSERT INTO padNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Akadija'ari avikhananavaki vakadihojai hiki ida ija'ari sa'ani-ra kosokovini arafiaki paha karahoa 'baini viahania. Nimania ida Deua bivajahavini vakahiki. Ni-niki ida iipohini vakadihojai. Nahina mani ida kadaipohi akadija'ari avikhananavaki vakadihojai-ra vakajonivini hija? Ni-asohiki ida vakadihojai. Ni-vi'baina viahania vasa'a-ra vakosokovini arafiaki, oniani ida akadija'ari avikhananavaki kahojai-ra vanaabaravini hija. ");
INSERT INTO padNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hari. Jesus va'ora ni'aha adani farisio: —A'onivani, nahina mani ida Deus kava'isohihi jiriki-ra avanaabaravini hija? Avarigavini kaba'i ida Deua binofiki bada avani'avini, avakajonibakhiaki ida. Avaranahoarihaki ida Deus athi, bada avani'aja kaimoni ida badani avakadija'ari avikhananavaki a'onira vaka'ojomo'ivini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Asia vara niha ada Jesus: —Deus kava'isohihi jiriki ija'ari-ra honariahi: “Va'ora vanakaidiva adani avakadiamia, avakadiabi'i vihiki.” Deus kava'isohihi jirikia bivahonariahivini abinini ida ija'ari kidiamia, kidiabi'i vihiki-ra kanavaranihaki varani jaharikia. Nimania ida Deus kava'isohihi jiriki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Asia vara niha ada Jesus: —Avaranahoarihaki ida Deus athi asohijanaria kaimoni. Nimania bana hida avakadi'ojomo'ihi athini asohiriki: Ija'ari kajiniroki Deu-ra kanava'igavini hini ida kidijiniro pitani. Ni-makhaniki ida kidiabi'i, kidiamia vihiki-ra va'ora kaijahitaravini, vakadinahina-ra vakainamovini kaba'i. Deu-ra kanava'igavini hini mani ida va'ora kaijahitaravini namakhanirini hija. Ojomo'ihi athini nikia ija'ari-ra avaka'ojomo'ivini jaharihi, ni-asohirihi ida. Nirihi ida Deus athi. Deua bihonariaki ida avakadiamia, avakadiabi'i vihiki-ra avanakaidivavini. Avakadimoni ni-makhaniki ida va'ora avanakaidivaravini. Ni-avanofiki ida Deus athi-ra avanaabavini. Avanofimanihi ida avakadija'ari avikhananavaki vakadihojaia avakahojaini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Asia vara niha ada Jesus: —Deus athi-ra avanofivini-ra avakahi'badaraki a'oni. A'onira vara vani'a'bo'da'iki ada Deus. Deus athi kapapirania Isaías kohana binajiri'iki ida athi: ");
INSERT INTO padNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Va'ini bodinia hora vanofipa'itxiravini kaba'i, ojahana-ra khai vani'abakhiaki adani ija'ari afo'badara, varani jahakia vara hora vavani'abakhiaki adani. ");
INSERT INTO padNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ni-nahina kaimoni hora vakanamasiviki. Vakadija'ari avikhananavaki vahojana-ra vanofivini mani ida oathi-ra vanaabaravini hija. Vakadihojaia vakahojaina va'ora ohonaria'bo'davini-ra vakahivini. Kodihonari hirihi ida vakadihojai hija.” Nimania ida Deus athi, papira hojaki athini — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hari. Oniaroa, Jesus va'ora baranaha'aha adani ija'ari vaipohiki, vikhara kaimoni kidiania. Vara va'ora ni'aha: —A'onivani afohahavi mitha vani'a hida kodivarani mahija avarigajahakivini. ");
INSERT INTO padNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni-'baia binamakhaniki ida ija'ari Deus viaha. Ija'ari varani jaharikia kavaranini mani ida ija'ari-ra najaharija Deus viaha. ");
INSERT INTO padNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Oniaroa, Jesu-ra vanamaakari'aha adani ipohina, vani'aha: —Iogamanija koda ida farisio kadavarani-ra vavajaharavini? ");
INSERT INTO padNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus va'ora ni'aha: —Deus jaharikia va'ora arakhaki bana adani. Hogoi 'ba'dani fori vihiki adani. Ni-hogoi 'ba'dani-ra rakhaiki ada kodiabi'i. Movahi ida ba'ba'da kodiabi'ia birakhairiki, birasohahi, binahokahihi. ");
INSERT INTO padNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hari'a va'ora vakava'ibodi adani farisio. Kamaodorohaki fori vihiki adani. Ija'ari vasohiva abono vakamaodorohaki adani. Makhira kamaodorohakia bibananiki ada hoariha kamaodorohaki; hodi bodinia avavoronijakosi'bamakhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Oniaroa, Pedro Jesu-ra ni'aha: —Haria nanamithajahakivinihi bana hida 'bai kavaranihi vara va'ora ini'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus va'ora ni'aha: —Vahoariha fori avihimania koda? Ni-nahina-ra avarigaria koda? ");
INSERT INTO padNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ija'aria biobaihi ida kidi'bai bodinia, bikidafihi, kaijonia okhahi, kia'ihi. Ni-'baia binamakhaniki ida ija'ari. ");
INSERT INTO padNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ija'ari va'ini bodinia hojaki ida va'ini bodini vara nini jahariki. Varani jahariki-ra vara vani'avini mani ida ija'ari-ra najaharija Deus viaha. ");
INSERT INTO padNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bikava'ibodivarani'imidiaki ida hojai jahariki. Binofihi; bada bini'ahi. Hida vani mani va'i bodini vara nini jaharika'oaki. Binofiki ida kaabinina. Binofiki ida kidigamo hiriki-ra vi'omavini. Binofiki ida kidimakhira hiriki-ra vi'omavini. Binofiki ida gamo-ra odoraonivini. Bikava'ibodivarani'imidiaki jaboni ida hojai asohiriki hoariha, oniani ida hojai asohirikia kanahojaini hija. Bibo'diaki ida hoariha kanahina. Korijanahia kavaranibakhiaki ida ija'ari, onii jaharikia kanavaraniki ida ija'ari hoariha. ");
INSERT INTO padNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hojai asohirikia kahojaini mani ida ija'ari-ra najaharija Deus viaha. 'Bai viahania ija'ari sa'ani-ra kosokohi arafiarihi, ni-ija'ari-ra najahariki Deus viaha. ");
INSERT INTO padNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hari. Ai vihi'aha adani Jesus, Tiro sidaji, Sidom sidaji kaaraboni-ra avanikhahavini avamaakari'aha. ");
INSERT INTO padNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Oniaroa, avakhano'aha, Jesu-ra namaakari'ihi ida gamo. Israel kaija'ari hirihi ida gamo, Canaã kaaraboni kaija'arini ida. Binamaakari'aha ada Jesus, bodi'bara'ihi: —Jesus, ivani ka'da'di i, Davi kohana kahanodi namitharonisiagaki i. Hora va'adi bana. Kabajadiki ida kodisai, bajadia binajaharikarahoki ida kodisai kamahi. ");
INSERT INTO padNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesua ni-bigathaniki ida athini. Oniaroa, kidipohia vanamaakariha ada Jesus, vani'aha: —Ihonaria bana oni gamo akara'o'ini. Anaothia kasiagaha'oadahaki oni, bodi'baraha'oadahaki ida jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Oniaroa, Jesua bini'ahi ida gamo: —Deus hora honariavini hiki Israel kaija'ari-ra va'ora okajoamoravini. Ovilia avakamadaki fori vihiki adani. Ni-hora honariaki kaho ija'ari vahoariha-ra va'ora okajoamoravinia. ");
INSERT INTO padNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jesus viaha kajo'atharari'ihi ida gamo, bini'aha: —Hora kajoamora bana! ");
INSERT INTO padNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesua bini'a'ihi: —Isai-ra va'ora ano'avini hiki ida 'bai. Jomahi-ra va'ora ono'avini hiki ida 'bai isaia vakai'dariki. Jahariki ida isai vi'bairina kaba'i, jomahi-ra va'ora ano'avini hini isai vakadi'baia — niha ada Jesus. Jesus judeus kaija'ari-ra kavarajomivini isai fori vihina. Judeus kaija'ari vihiriki-ra va'ora kavarajomivini jomahi fori vihina. ");
INSERT INTO padNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Oniaroa, gamoa bigathani'ihi ida Jesus athi: —Hai oamani. Jomahi fori ohiki ho. Ija'ari vi'baina kaba'i, jomahi vaitxanava vahahi hida ija'ari vakadi'bai moramorani gora nabo'ania vararaki. Kadaija'ari ohirina kaba'i onofiki ida kodisai-ra ikajoamoravini. ");
INSERT INTO padNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesua bini'a'ihi: —Gamo, hora ikajari'dari'oamanija. Ida akara'o'ihi bajadi kadaisai kania — gamo-ra ni'aha ada Jesus. Vara nina kaba'i ada Jesus, aihota'ihi ida gamo kaisai. ");
INSERT INTO padNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Oniaroa, ajihi'aha, okhaha, Galiléia kaaraboni ka'dakonia kaikahi'aha ada Jesus. Gaimori'aha arabo namahikia vithima'o'aha. ");
INSERT INTO padNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jesus kania avikha'aha adani ija'ari vaipohiki. Va'ora vavikha'aha adani ija'ari vakavamoniki, vajo'o aba'oronisiagaki, vatonorohaki, vakamaodorohaki, vaabani a'dakharariki vihiki. Kavamoni ipohiki-ra vavahojaki adani ija'ari va'ora vavikha'aha Jesus viaha. Jesus va'ora anaihotahahavimani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Vakava'ibodivaranikaraho'ihi ida Jesus kabadani danoki. Va'ora vanoki'aha adani vaabani a'dakhararijanariki vavaravara'ina. Va'ora vanokiki jaboni adani ija'ari vajo'o aba'oronisiagaki, ija'ari vatonorohaki vaadaha'ina. Va'ora vanokiki jaboni adani ija'ari vakamaodorohaki vanokho avagaha'ini. Ija'ari Jesus kabadani danoki-ra vanokivini mani ida Deu-ra khai vani'avini hija. ");
INSERT INTO padNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hari. Jesus va'ora anaihota'aha adani ija'ari vaipohiki naothinia, ipohina-ra va'ora baranaha'aha, va'ora ni'aha: —Va'ora onakaidivaki va'oani ija'ari vaipohiki. Mahi ahoarabakosikia kodiania vahojana. Vakadi'bai-ra vakainamovini hiki, napaja vikhana. Vi'bairina oadani ni-onofiki ida ai vihina va'ora ohonariavini. Vaibavia avakakhakhamana vaha va'ora ohonariara vaha; vajarona binafajafajahamaniha vaha; hagihia vai'ami va'ora narai'ahamaniha vaha. ");
INSERT INTO padNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ipohina vani'aha ada Jesus: —Pão kahojarihi bana hihida ibavia kakapavakari vahaki kaimoni. Niha akani'a'aki koda bana hida pão va'ora ano'avini kihiki kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—Nihafori kihimanija ida pão avakavahojaki? — va'ora ni'aha ada Jesus. Jesus athi-ra vagathani'aha: —Akavahojaki ida 7 pão kihiki kaipohini, avahojaki abaisana 'bamiki ka'oa jaboni — vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oniaroa, Jesus va'ora honaria'aha adani ija'ari vaipohiki vavithionahana. ");
INSERT INTO padNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Biagathani'ihi ida pão, abaisana hiki, Deu-ra ni'a'aha: —Deus, ivani ijahaki i, pãoa haria ino'a'iki i. Hari. Bikanapitahataha'ihi, ipohina-ra va'ora no'avini kihi'ihi vakaravinaja kaimoni. Oniania, vakaravina'ihi ija'ari vaipohiki vakadimoni kihini. ");
INSERT INTO padNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jesua bianaipohi'ianaha ada abaisana, pão kihiki. Vi'baihahavi'aha, vaakhari'aha. Vi'baina naothinia Jesus ipohina vanajoroni'ihi ida 'bai ahabarini. Vanaji'biji'biha'ihi ida 7 so'oro ipohini. ");
INSERT INTO padNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Makhira 4 mil vaipohina vi'baiki, gamo, isai vihiki vi'baiki jaboni. Ija'ari va'ahapina oamani adani vi'baira. ");
INSERT INTO padNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hari. Jesus va'ora kaamina'aha adani ija'ari vaipohiki, naothinia vaki'dama'aha adani Jesus, ai vakihi'aha, avakakafianiha, Magadã kaarabonia avako'omisi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hari. Magadã kaarabonia avako'omisi'aha adani Jesus. Oniaroa, vikhaha adani farisio, sadosio khama, Jesu-ra vara vani'ahavini. Vakajari'daki ada Jesus Deua bikaronavini, oniani ida vakaijo'avini hija. Vani'aha: —Anofiki ida kadabadani danoki-ra anokivini. Deus kabadani danoki fori hini vani bana bada ini'a mahija Deus ira karonavini-ra aogavini — Jesu-ra vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hari. Jesus va'ora ni'aha: —Mithani vaivaini vani avanokiki ida nama nadarani, avakhanihi: “Nadaraki ida nama, ni-kharariki bana ada bahi afokajoma.” ");
INSERT INTO padNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Vagavagani avanokihi ida nama nadarani, avakhanihi: “Pororoki nadaraki hiki ida nama, kharariki bana ada bahi hidakaba'i.” Vada avani'aki ida nama, avarigajoraha ada safini, bahi hiki kamahina. Kodibadani danoki-ra avanokivini kaba'i, ni-avarigapa'itxiki ida hana ohina. ");
INSERT INTO padNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jahari kahojaia vakahojaiki adani ija'ari hidakaba'i vahokiki, Deu-ra vanofi'badaraki adani. Oniani ida badani danokia okabadanina hora avakanikhariavini hija. A'onira onanokiahivini hiki bana ida rajomi hoarani ka'oa. Jonas kohana varani hina rajomi hini hoarania a'onira onanamithaki bana ho. Jona-ra kajoamoravini kari, Deua binanokia'iki ida danona. Onivani fori hi'ianaja bana, hora kajoamoravini kamahini binanokia'ianaki ida danona — va'ora ni'aha ada Jesus. Hari. Ajihi'aha. Ibavi hoariha okhaha. ");
INSERT INTO padNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hari. Avakakafiani'aha adani Jesus Galiléia ka'dakonia, avako'omisi'aha. Jesus ipohina avakakava'i'birinihi ida pão-ra avakavikhavini. ");
INSERT INTO padNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oniaroa, Jesus va'ora ni'aha: —Avaabononi avakava'igairi bana! Hari'a bana vagathani bana ida farisio sadosio khama vakadipão-ra kanathoramananiki. ");
INSERT INTO padNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Vakamithahi, ni-avigajahakiki ida Jesus va'ora nava'isohivini hiki. Farisio vakadihojaia Jesus va'ora kaabaniki adani. Pão vakavanihavini ida Jesus kavarani. Oniania, vaabono vara vakani'akhama'aha: —Pão-ra akavikharihi, oniani ida haria kaabanivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesua bikamithaki ida vakadivarani, va'ora ni'aha: —Nahina kaimoni mani ida pão-ra avakavahojaravinia avaabononi vara avakani'akhamavini hija? Ni-hora avavakaijokajahakiki kaho. ");
INSERT INTO padNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ni-avarigaki kaho ida kodivarani nahina hini. Avakava'ihokiria ida pão sa'ai kahoarani kihiki-ra okanapitahatahavini kari, 5 mil ija'ari-ra va'ora okano'bai'iki ho, 12 so'oro-ra avanaji'biji'biha'iki a'oni pão akahabarinia. ");
INSERT INTO padNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pão 7-ra okanapitahatahavini kari, 4 mil vihiki vaipohina vakadimoni, 7 so'oro-ra avanaji'biji'biha'iki a'oni pão akahabarinia. ");
INSERT INTO padNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Avarigaria koda hida kodivarani. Vakava'ibodivaranijahaki bana. Pão-ra kanathoramananiki kihirihi ida kodi'ojomo'ihi athini. Farisio, sadosio khama vakadihojai ida kodikaabanahi hija, vakadihojaia avakahojairia kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oniania, Jesus ipohina aviga'ihi ida kidivarani. Ni-Jesus va'ora kaabanivini hiki ida pão-ra kanathoramananiki. Farisio, sadosio khama vakadihojai kavaranihi vani ida Jesus va'ora kaabanivini hija, va'oaniaro fori vihirara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hari. Oniaroa, Cesaréia de Filipe sidaji maakarinia avikha'aha adani Jesus. Vakaikahi'aha, va'ora nana'dohi'aha adani kidipohi: —Hovani ija'ari hahavi vakadi'aajo ho. Hora vara vavani'aha adani vahoariha. Nahina nimania ida hora vara vavani'avini? ");
INSERT INTO padNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Vahoariha vani'aha: Ivani João Batista kohana i iahoki'ia. Vahoariha vani'aha: Ivani Elias kohana i iahoki'ia. Vahoariha vani'aha jaboni: Ivani Jeremias kohana i iahoki'ia. Deus athi namoniva abono hoariha kohana mani i iahoki'ia — ipohina vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus va'ora nana'dohi'ianaha adani ipohina: —A'onivani, nahina nimania ida hora vara avavani'avini? ");
INSERT INTO padNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Pedroa bini'aha: —Ivani Cristo i. Ija'ari hahavi vakadika'da'di i. Deus ira karonaki i. Deus hokiki kaisai oamani i. ");
INSERT INTO padNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesua bini'aha ada Simão Pedro: —Simão Pedro, Deus ira kajoamora'iki i. Ni-ija'ari ira nava'isohivini hiki ida Cristo ohina. Deus nama hojaki vani ira nava'isohivini ohija. ");
INSERT INTO padNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ka'oa hiki hida vara ira oni'avini hiki bana. Ivani Pedro i, ja'di onini ida ionini hija. Ka'da'dia hora inaonivini vani ja'di kaaraki gora nabo'ani dadani fori ihiki i. Gora hoarani fori vihiki adani kodija'ari hahavi va'ora oani'iki. Va'ora onajoromisiki fori vihiki adani hora vakajari'dariki ja'di kaaraki namania, Deus ibavi kaimoni hida gora. Jahari, kidija'ari khama ni-vakaabokaki bana ida kodija'ari-ra va'ora vanihimavini. Kodija'ari vani adani Jahari danona-ra vanihimara. ");
INSERT INTO padNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ogorana fori vihiki adani kodija'ari hahavi-ra va'ora ovaka'da'diki nama. Ira ono'aki bana ho ogorana kachavenia. Ija'ari chave-ra kavahojakia biakadava'aki ida gora. Ivani kodichave-ra ikavahojavini va'ora iakadava'aki bana adani va'ora ovaka'da'diki. Kodija'ari-ra ovaka'da'divini vani fori hiki ira ohonariavini va'ora ivaka'da'divini. Nahina-ra iva'aharihi araboja; Deua biva'ahariki nama kidiania jaboni. Nahina-ra iva'ahahi; Deua biva'ahahi nama kidiania jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Oniaroa, Jesus va'ora kaabani'aha adani kidipohi: —Hari'a vahoariha-ra bana vananamitha'a Cristo ohina. ");
INSERT INTO padNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hari. Oniaroa, Jesus va'ora nava'isohijoravini hiki kidipohia avigaja kaimoni nahina namithaki bana. Va'ora ni'aha: —Jerusalém sidajia ookhaki ho. Ohojana kaba'i hora vanaima'banakarahoki bana adani judeus kaija'ari vanava'isohiva abono, sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono vihiki khama. Va'ora vahonariaki bana adani ija'ari vahoariha hora vanaabinivini. Mahi ahoarabakosiki radahahi, oahokiki bana ho. ");
INSERT INTO padNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Oniaroa, Pedroa biavikhapa'itxiha ada Jesus. Bikaabanivini bini'aha: —Hari'a varani nikia kavarani. Jokoa kadania namitharihi ida vara hora ini'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Roiribani'aha ada Jesus, Pedro-ra kaabani'aha: —Jahari, akara'o'a! Pedro, ja'di hoariha fori ihiki i, ja'di ija'ari-ra ka'damanokhoki fori ihiki i. Iathini, ija'ari athini fori hiki. Ni-inofiki ida Deua binofiki. Deua binofiki ida oni'aki. ");
INSERT INTO padNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Oniaroa, ipohina-ra va'ora ni'aha: —Kodipohi avihini-ra avanofihi; vakava'ipahini ida avanofiki mahija Deua binofiki ka'oa-ra bada avani'avini. Avava'ini bodini vara ni'ava: “Anofiki ida Jesus ipohina arihi'ina. Haria vanaabiniha; haria vanaabiniha. Jakaho Deus athi-ra anaabava kaho.” ");
INSERT INTO padNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hari. Asia vara niha ada Jesus: —Ija'aria bada bini'ahaha'oadahahi ida binofiki kidimoni, ni-bikava'ibodiki ida Deua binofiki, akamadaki fori hiki bana ida kidimahi. Kavithimaki ida. Ni-bivahojaki ida mahi ja'dini anokhomiriki Deus kania. Oipohina omonina jahakia kavaranini mani ida vahoariha vanaabinivini hija, oniani ida Deus kania oipohina-ra arakhaja. ");
INSERT INTO padNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ija'ari vakadinahina ipohiki-ra vanofivini arafiaki mani ida Deu-ra vanofijahakiravini hija, vaabinina kamahini Ibavi Jaharika'oakia avikhaha. Ibavi Jaharika'oakia okhahi ida ija'ari; ni-khaonanijanaki. Ni-arajomaki ida kidinahina ipohiki khaonanini-ra naabosivini kaimoni hini. ");
INSERT INTO padNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hovani ija'ari hahavi vakadi'aajo ho. Ojoiki bana ho ija'ari vakadiania. Ojoina kamahini bana, Deus ibavi kaija'arini hora vavaipohihaki ho. Ija'aria vanokiki bana ida kodiabi'i jahana danona vagana kodiania. Oniaroa, ija'ari-ra onasohiki bana ho. Va'ora oni'ananaki bana adani vahoariha: “Onaabosiki bana ida avakadihojai jahaki kodinahina jahakia.” Va'ora oni'ananaki bana adani vahoariha: “Onaabosiki bana ida avakadihojai jahariki nahina jaharikia.” ");
INSERT INTO padNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Vakava'ibodivarani bana ida kodivarani. Ojoina kamahini va'ora ovaka'da'diki bana adani ija'ari. Vaabinirina oadani adani ija'ari hahavi ahararana vahojaki, vanokiki bana ida va'ora oni'avini hiki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hari. Radahahi ida 6 mahi ipohini. Oniaroa, arabo namahikia vigaimoriha adani Jesus, va'ora avigaimori'aha adani Pedro, Tiago, Tiago kakajo'o João oniki vihiki ka'oa. ");
INSERT INTO padNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Avakhanomori'aha, kama'da'ihi ida Jesus vagana nokiani. Nokho vagani vanoki'aha ada Jesus, safini vagana fori hiki ida. Kidimakari vaforini vagaki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Oniaroa, Jesus ipohina avahoarabakosiki va'ora vanoki'aha adani ija'ari kohana avaja'dina vi'bamiki. Hoarana onina Moisés. Hoariha onina Elias. Jesus khama vara vakhani'aha adani vi'bamiki. ");
INSERT INTO padNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Oniaroa, Pedro Jesu-ra ni'aha: —Aajo, hida vania arihojana jahaja. Inofihi ida gora itxani ahoarabakosiki-ra onamonahavini, onamonahahi. Hoarani kadaimoni, hoariha Moisés kaimoni, hoariha Elias kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro vara nina kaba'i, khaha ada bahi vaforiki vagaki vanamana hi'aha. Bahi vaforiki kania vakamitha'ihi ida athii: —Hi'o kodisai, onofijahakiki o, ova'i-ra khai ni'aki o. Mitha vani'a oni kodisai athi. ");
INSERT INTO padNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jesus ipohina vakamitha'ihi ida athii, vaimahidakaraho'aha, ava'bisonirari'aha. ");
INSERT INTO padNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus va'ora namaakari'aha, va'ora kadasaha, va'ora ni'aha: —Vigaamanani'a, hari'a vaimahida! ");
INSERT INTO padNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Vada vakhaniribani'aha, ni-vahoariha-ra va'ora vanokijanaki. Jesus oavani ada vanoki'aha vakadiania hojana. ");
INSERT INTO padNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ai vihi'aha, vajoifonina vani, va'ora honaria'aha: —Hari'a bana vahoariha-ra va'ora vara vani'a arabo namahikia avanoki'ikia. Hovani ija'ari hahavi vakadi'aajo ho. Oabinina oahokina kamahini vahoariha-ra va'ora vara vani'a bana hidakaba'i avanoki'ikia. ");
INSERT INTO padNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oniaroa, Jesu-ra vani'aha adani kidipohi: —Jesus, nahina mani ida judeus kaija'ari vaka'ojomo'iva abono haria vani'abakhiavini hija: “Deua bikarona'imidiaki ada Elias, naothinia bikaronaki ada Cristo oniki.” Vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus va'ora ni'aha: —Asohiki ida vakadivarani. Okhananavaki ada Elias kohana fori hiki ija'ari-ra va'ora nava'isohijoravini hiki vakadimahi-ra vanasohivini okaikahina viahania. ");
INSERT INTO padNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A'onira onava'isohivini hiki ada kaikahi'ina Elias fori hiki. Ni-avigaki ada makhira Elias kohana fori hiki hina, oniani ida vanaima'banavini hi'ia. Nimania bana ida ija'ari hora vanaima'banavini jaboni bana. Hovani ija'ari hahavi vakadi'aajo ho — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hari. Kidipohia aviga'iki ada hana hina Elias kohana fori hiki. João Batista vani ada Jesua vara bivani'ara. ");
INSERT INTO padNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hari. Ija'ari vaipohiki vakadiania vajoifoni'aha adani Jesus. Kha'aha ada makhira, Jesu-ra namaakari'aha, viaha kajo'atharari'aha. ");
INSERT INTO padNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Bini'aha: —Jesus, iva'adi bana o kodisai. Kavamonikarahoki ada. Rai'abakhiaki ada. Rai'ana vani adarina siho kabodinia, kafariki ada paha bodinia jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kadaipohi vakadiania ovikha'iki o kodisai, ni-avanaihotavini vakaabokaki — niha ada isai kaabi'i. ");
INSERT INTO padNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Oniaroa, Jesus va'ora ni'aha adani ipohina: —A'onivani asia Deu-ra avakajari'daki a'oni. Ova'i-ra avanamokaraki a'oni. Avanokibakhiaki ida Deus kabadani danokia okabadanina, kaba'i, ni-Deu-ra avavakaijokaki a'onira kakodiara kaimoni kidibadani danokia avakabadanini. Isai kaabi'i-ra ni'aha: —Kodiania vavikha bana o isai! ");
INSERT INTO padNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Vavikha'aha, oniaroa, Jesua bini'ahi ida bajadi: —Bajadi, isai kania akara'o'a! Jorakia akara'o'ihi ida bajadi, aihota'aha ada isai. ");
INSERT INTO padNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hari. Bianaihotavini naothinia, ipohina vanamaakari'aha ada Jesus, vanana'dohi'aha: —Jesus, niha akhanimanija hi'oni bajadi akara'oni-ra akaabokariki? ");
INSERT INTO padNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Asia Deu-ra avakajari'daki a'oni. Vakava'ihoki bana hida kodivarani. Pa'itxi ida mostarda 'ba'dani. Mostarda 'ba'dani ahapini fori hija vaha ida Deu-ra avakajari'daravini; avakaabokahi vaha ida arabo namahiki-ra avahonariavini: “Arabo namahiki, akara'o'a, oniaja okha'a.” Deu-ra avakajari'darihi; okhahi ida arabo namahiki. Deu-ra avakajari'darija vaha; avakaabokahi vaha ida badani danoki hana hini avanofiki. ");
INSERT INTO padNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Avi'bairini avahojarihi, Deu-ra avakanikhariaja kaimoni danona, ni-avakaabokaki ida bajadi, hi'ida bajadi danoki fori hiki akara'oni. ");
INSERT INTO padNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Hari. Oniaroa, Galiléia kaarabonia vajoroni'aha adani Jesus kidipohi khama. Va'ora ni'aha: —Hovani ija'ari hahavi vakadi'aajo ho. Ija'ari hora avarakhaki bana ho vahoariha hora vanaabinira kaimoni. Mahi ahoarabakosiki radahahi, oahokiki bana ho — va'ora ni'aha ada Jesus. Vakamitha'ihi ida Jesus athi, vava'i mokara nikaraho'aha adani ipohina. ");
INSERT INTO padNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Oniaroa, Cafarnaum sidaji onikia avakhano'aha adani Jesus kidipohi khama. Pedro kania avikha'aha adani makhira Deu-ra khai vani'avini kagorani ka'impostoni-ra vagathaniki. Pedro-ra vanamaakariha, vanana'dohi'aha: —Jesua binaabosimanija ida imposto kajinironi Deu-ra khai vani'avini kagorani kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Ha'a, binaabosiki ida — va'ora ni'aha ada Pedro. Gora okhajakosi'aha ada Pedro, Jesus miro'a vani ada vara ni'aha: —Simão Pedro, nahina mani ida ikava'ibodivaranija? Ija'ari hana vihina vanaabosiki ida imposto kajinironi arabo ipohiki vaka'da'diva vakadiania? Arabo vaka'da'diva va'ora vahonariamanira adani vakadiarabo kaija'arini, vakadiarabo kaija'arini vihiriki imposto kajinironi-ra vanaabosivini? ");
INSERT INTO padNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Arabo kaija'arini vihiriki vania vanaabosiki ida — niha ada Pedro. —Hai oamani, asohiki ida ini'aki. Kadavarani hiki ida arabo vaka'da'diva ni-va'ora honariaki adani kidiarabo kaija'arini vanaabosivini. ");
INSERT INTO padNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hari. Deua bivaka'da'diki ida gora ija'ari khai ni'ana vihiki. Deus kaisai ohina kaba'i onaabosiki bana ida Deu-ra khai ani'avini kagorani ka'impostoni. Ni-onofiki ida imposto gathaniva abono haria vaka'da'digariavini. Anaabosirihi; Deu-ra khai ani'avini kagorani-ra anakaidivariki haria vavanihaha. Oniania, okharafoni'a bana 'dako vadinia mahija ikanaba'dahavini. Ira'bani bana ada abaisana ovari miro'a ianagithiki kaikoakana ahoni. Abaisana bodia, ikaragaki bana ida jiniro 'ba'dani. Arajomaki ida imposto-ra inaabosivini jiniro ikaragaki kadaimoni hini, kodimoni hini jaboni. Jiniro-ra ianivini naothinia, okha'a bana mahija imposto kajinironi-ra inaabosihavini — niha ada Jesus. Oniaroa, okha'aha ada Pedro Jesus athi-ra naabaha'avini. ");
INSERT INTO padNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hari. Oniaroa, Jesu-ra vanamaakari'aha adani ipohina, vanana'dohi'aha: —Jesus, Deus ija'ari hahavi-ra va'ora vaka'da'divini kamahini, hana hina ada akadiania hojana jahara haria vaka'da'diki kaimoni hina? ");
INSERT INTO padNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesua bikaboa'i'aha ada isai pa'itxi, vaviaha binahojaha, va'ora ni'a'aha: ");
INSERT INTO padNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Vakava'ibodivarani bana hida kodivarani. Vakava'ipahini'a bana ida avaabononi avavaboraborahavini. Isai pa'itxi kidiabi'i-ra vakaijokavini vani fori vihi'a. Isai pa'itxi fori avihirihi; ni-avari'oiki bana Deus ija'ari-ra va'ora vaka'da'divini ibavinia. ");
INSERT INTO padNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Avanofihi ida avari'oini Deus ija'ari-ra va'ora vaka'da'divini ibavinia, isai fori vihi'a bana, hora avavakaijokajahakivini. Nimania ida ija'ari kahojai hora kakodiavini ija'ari hahavi-ra va'ora ovaka'da'divinia. ");
INSERT INTO padNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Deus va'ora vajahaki adani isai, va'ora kakodiavini va'ora nofiki. Ija'ari abononi ni'ahi: “Jesus kaija'ari ohina mani ida isai-ra ogathanijahakivini hija.” Nihi. Bigathanihi ida isai hihida isai fori hihi, hora gathanivini jaboni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Vara ni'ianaha ada Jesus: —Va'ora onakaidivaki adani isai hora vavakaijokaki. Ija'ari va'ora kaborobakhiaha adani isai, hora vakava'ipahinira kaimoni, isai-ra kaborovini kabadanihi, Deua binaabosivini bana nahina jaharikia. Jahaki ida ja'di karaho ija'ari mathani ahoni paha bihiakia hokahini, ahidaja kaimoni ida ija'ari isai-ra kaboroboroki. ");
INSERT INTO padNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jahari'oamanija ida ija'ari hora vanofiriki oipohina-ra kaborovini hora vakava'ipahinira kaimoni. Namithaki bana ida ija'ari hora vakava'ipahinivini. Jahariki ida oipohina-ra va'ora vakaboroboroki vakadimoni. ");
INSERT INTO padNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Avaabononi avakava'igairi bana mahija Jahari kabadania avakabadaniravini. Ija'aria binofihi ida Jahari kabadani-ra bada ni'avini, biakava'boavini kajahaki ida sa'ani, bada bini'aria kaimoni ida Jahari kabadani. Jahari kabadania kabadanihi; Ibavi Jaharika'oaki siho kaihimiriki kania hokahihi. Jahaki ida sa'ani kahoaranini kaba'i Deus Ibavi Jahaka'oakia okhani. Jahariki ida sa'ani ko'bamini kaba'i Ibavi Jaharika'oakia hokahini. Ija'aria binofihi ida Jahari kabadani kania adahani, biakava'boavini kajahaki ida 'damani kahoarani, bada bini'aria kaimoni ida Jahari kabadani. Jahaki ida 'damani kahoaranini kaba'i Deus Ibavi Jahaka'oakia okhani. Jahariki ida 'damani ko'bamini kaba'i, Ibavi Jaharika'oaki siho kaihimiriki kania hokahini. ");
INSERT INTO padNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ija'aria binokivini bivajahahi ida Jahari kabadani, bianivini jahaki ida nokhoni 'ba'dani hoarani, vada bini'aria kaimoni ida Jahari kabadani. Jahaki ida nokhoni 'ba'dani hoaranini kaba'i Deus Ibavi Jahaka'oakia okhani. Jahariki ida nokhoni 'ba'dani 'bamini kaba'i, Ibavi Jaharika'oaki siho kaihimiriki kania hokahini. ");
INSERT INTO padNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Hari. Asia vara ni'aha ada Jesus: —Va'ora vanakaidiva bana adani isai hora vakajari'dariki. Ka'oa hiki hida vara a'onira oni'avini hiki. Deus ibavi kaija'arini va'ora avakadava'aha'oadahaki adani isai hora vakajari'dariki. Kodiabi'i nama hojaki kania vahojahaha'oadaki adani. Va'ora onakaidivavini arafiaki adani isai. ");
INSERT INTO padNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Hovani ija'ari hahavi vakadi'aajo ho. Hora rakhaki hida va'ora oakava'ijoahavini adani Deus kahagihi-ra varagariki kidiania avikhara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","A'onira okavarajomivini hiki ada ovilia akadava'ava abono. Makhira va'ora vahojaki adani 100 ovilia vaipohina. Hari. Hoarana akamada'iki. Oniaroa, binako'dihaki ada. Va'ora nahoja'imidia'aha adani ovilia vahoariha 99 vihiki arabo namahikia hogoi-ra vahavini. Va'ora nahoja'imidiaha, binako'diha'aha ada ovilia akamadaki. ");
INSERT INTO padNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A'onira onava'isohivini hiki, khai bini'avini ida ovilia-ra karagavini. Khai va'ora ni'avini kaba'i adani kidi'ovilia avakamadariki, khai bini'avini arafiaki ida kidi'ovilia akamadaki bikaraga'iki. ");
INSERT INTO padNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Onivani fori hiki ida kodiabi'i nama hojaki kahojai. Ni-binofipa'itxiki ida isai hoarani akamadani Ibavi Jaharika'oakia okhani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Asia vara niha ada Jesus: —Iigaminia bada bini'aki ida Jahari kabadani, okha'a bana kidiania mahija kidibadani asohirikia inava'isohivini. Hari'a vahoariha vakadiania vara ivani'a ida iigamini kabadani asohiriki. Iigamini kahojakosoana okha'a kidiania mahija a'onivani avi'bamiki vara avakhanivini. Inava'isohivini hiki athini-ra kamithaha; joiribani'aha Deus kania okhara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Inava'isohivini hiki athini-ra kamithariha; va'ora anikha bana adani iigamini hoarana vi'bamiki. Va'ora vavikha bana kidiania mahija vara avani'avini. Nimania hida athii Deus athi kapapirania hojaki: “Ija'ari akaathidanoarari kamahini va'ora vikha bana adani kidibadani jahariki nokiva vi'bamiki avahoarabakosiki vara vavani'aja kaimoni ida nahina vanoki'iki.” ");
INSERT INTO padNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hari. Iigamini avaathini-ra kamithariha, kidibadania vara va'ora vani'a bana adani Deus kaija'ari vajoroniki. Vaathi binaabariha; vani'a bana: “Arigamina ihijanarihi, Jahari kabadani abono ihi'oamani'ia.” Vani'a bana. ");
INSERT INTO padNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Oniaroa, a'onira onava'isohiki bana ho: Ija'ari kahojai-ra ava'aharihi araboa; Deua biva'aharihi jaboni nama. Ija'ari kahojai-ra ava'ahahi araboa; Deua biva'ahahi jaboni nama. ");
INSERT INTO padNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Avi'bamini avahojani Deu-ra vara avani'avini vani, avakanikharia'bamakhamahi ida nahina hoarani avanofi'bamakhamaki, kodiabi'i nama hojakia bada bini'aki bana ida avakanikhariavini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ibavi hana hini kodija'ari vi'bamiki avahoarabakosiki vakajoronikosoaha vara hora vani'ara kaimoni, ohojaki bana ho vahararana. ");
INSERT INTO padNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hari. Oniaroa, Jesus kania okhamiha ada Pedro, binana'dohi'aha: —Jesus, oigamina bada bini'abakhiaki ida badani asohiriki kodiania, vara bivani'aki ida varani jahariki kodiania jaboni. Nihafori himani'ia koda ida oakariakavini? Arajomamani'ia koda ida 7 hiki ipohini oakariakavini? ");
INSERT INTO padNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesua bigathani'ihi ida Pedro kana'dohi: —Iniani, arajomarihi ida 7 hiki ipohini iakariakavini. Arajomaki ida mahi hahavi iakariakavini. Deus kidija'ari-ra honariavini hiki hoariha-ra akariakabakhiajorakivini. Onivani fori hiki bana ida Deus kahojai. ");
INSERT INTO padNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Oniaroa, Jesus va'ora ni'a'aha: —A'onira onanamithavini hiki bana hida rajomi kavaranihi. Okavarajomiki ada Deus ija'ari-ra vaka'da'divini arabo kaka'da'dinia. Hojaki ada arabo kaka'da'dini. Ovaria binofiki ida kidihonai abono afohanana jiniro abosiriki kapapirani-ra avanavathavini. ");
INSERT INTO padNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hari. Kama'da'ihi ida kidibadani. Vahoariha vavikha'aha ada honai abono jiniro karaho-ra naabosiriki. Ipohi'oamanija ida jiniro 'ba'dani binaabosiriki. ");
INSERT INTO padNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kajiniroriha ada honai abono, ni-bikaabokaki ida jiniro abosiriki-ra naabosivini. Oniaroa, kidika'da'dia bini'aha: “Hora inaabosiravini mani ida pavakari ira onihavini hija bana. Ivani, kadagamo, avakadisai, kadanahina hahavi-ra pavakari onihaki bana ho, abosija kaimoni ida jiniro hora inaabosiravini hiki.” Ka'da'dia bini'aha. ");
INSERT INTO padNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hari. Ka'da'di viaha kajo'atharari'aha ada kidihonai abono, biakava'isokonivini ida pavakari vihina kidigamo khama, bikanikhariaha: “Haria va'adi bana. Hari'a kaho bana, viahanokha kaho mahija kadajiniro-ra onaabosihahavivini.” ");
INSERT INTO padNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ka'da'dia bikamithahi ida athi, va'ora nakaidivamaniha, bini'aha: “Ira oakariakaki bana ho. Ona'biraki bana ida jiniro karaho inaabosiriki kapapirani, hora inaabosijanaria kaimoni. Ba ajihi'a.” ");
INSERT INTO padNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Oniaroa, ajihi'aha ada honai abono, bikaragarari'aha ada kidibadani-ra vaipohivini naabosi'iarina hiki. Jiniro pa'itxi oamani ida binaabosi'iarija kidiania. Oniani ida kanabidi biagathivini hija, sa'a kakhanamisikia biradihadihavini hija. Bini'aha: “Kodijiniro hora inaabosi'iaravini hikia, hora naabosi bana.” ");
INSERT INTO padNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Oniaroa, hoariha viaha kajo'atharari'aha ada jiniro pa'itxi-ra naabosiriki, bikanikharia'aha: “Hora va'adi bana. Hari'a kaho bana, viahanokha kaho mahija kadajiniro-ra onaabosivini.” ");
INSERT INTO padNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Iniani, jokoa ira onokharihi. Hora inaabosiravini mani ida cadeia ira obaivini hija bana. Hora inaabosiravini oadani, ihojaki bana i cadeia.” Niha ada ka'da'di kahonai abono jiniro karaho-ra naabosi'iariki. ");
INSERT INTO padNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Oniaroa, vakadika'da'di kahonai abono vahoariha vanoki'iki ida vaipohina hoariha-ra nahojavini, vakaihamahi'aha, vakadika'da'di kania avikha'aha, vakanamoni'aha hoariha kabadani hikia. ");
INSERT INTO padNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ka'da'dia bikamitha'ihi ida vakadivarani, bihonariaha ada kidibadani abono jiniro karaho-ra naabosiriki khajakosina. Khajakosi'aha, bini'aha: “Honai abono jahariki. Hora ikanikhariahi; ira ova'adimanihi. Ona'bira'iki ida jiniro karaho inaabosi'iariki kapapirani, ira oakariaka'iki ho. ");
INSERT INTO padNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jahari'oamanija ida hoariha athi-ra ikamitharavini, iipohini-ra iakariakaravini. Hora ikanikhariahi; ira ova'adimanihi. Jahaki ida hoariha-ra iva'adivini jaboni.” ");
INSERT INTO padNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ka'da'dia bikaihamahikaraho'aha ada kidihonai abono, bihonariaha osahina cadeia, bini'aha: “Ovahonariahiki ida jiniro karaho inaabosi'iarikia hora inaabosivini. Jaharikia ira oarakhaki bana ho. Kodijiniro karaho abosihahavi'iarini oadani, cadeia ihojaki bana i.” Niha ada ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hari hi'ihi ida rajomi kavaranihia Jesus va'ora ka'ojomo'ivini adani ija'ari namithaki kaimoni vakadiania: —Ka'da'di fori hiki ada kodiabi'i nama hojaki. A'onivani kidihonai abono fori avihiki a'oni. Hoariha-ra iakariakarihi; ni-ira akariakaki ada kodiabi'i jaboni. Hoariha-ra iakariakaka'oaravini oadani, jaharikia ira arakhaki bana ada — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hari. Va'ora vara ni'avini naothinia, Galiléia kaarabonia va'ajihi'aha adani Jesus. Jordão vainia avikafiani'aha. Judéia kaarabonia avajoi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jesus naothia vikasiaga'aha adani ija'ari vâipohiki. Jesus va'ora anaihotahahavi'aha adani vakavamoniki ija'ari vahararana vahojaki. ");
INSERT INTO padNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jesu-ra vanamaakari'aha adani farisio vaipohiriki. Jesus Deus kava'isohihi-ra kajonivini-ra vanofivini, oniani ida vakaborovini hija. Vanana'dohi'aha: —Deus kava'isohihi jirikia hojaki ida makhira kidigamo-ra nahojahavini kavaranihi. Gamoa bada bini'aki ida badani kidimakhira bivajahariki, Deua biva'ahamanira ada makhira kidigamo-ra nahojahavini? ");
INSERT INTO padNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus va'ora ni'aha: —Avanokiria koda ida athi Deus athi kapapirani pitania hojaki? Niha: “Hahavi-ra nakama'davini kari ada Deus, va'ora namonaha'iki adani makhira, kidigamo khama.” ");
INSERT INTO padNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Niha ada Deus: “Kidigamo-ra anakaravini mani ida makhira kidiamia, kidiabi'i vihiki-ra va'ora aakara'ovini hija. Makhira, kidigamo khama avakarana viahania vi'bamiha. Avaakara'ina naothinia, ija'ari hoarani fori vihina vahoja'aha kidigamo khama.” Nimania ida Deus athi. ");
INSERT INTO padNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Deus va'ora anakara'iki adani makhira, kidigamo khama, ija'ari hoarani fori vihira kaimoni. Deus vani va'ora anakaramisi'aha. Hari'a ija'ari vaabono avakakara'okhamava! ");
INSERT INTO padNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisioa vanana'dohi'ianaha: —Nahina mani ida Deus kava'isohihi jiriki makhira kidigamo-ra nahojahavini-ra va'ahavini hija? Binahojahavini viahani ida kidigamo, papira jirikia bino'a'ihi kidigamo hijanaria kaimoni. Bino'avini naothinia bihonaria'ihi ajihini. Nimania ida Moisés athi akadija'ari avikhananavaki-ra va'ora honariavini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus va'ora ni'aha: —Ni-vanofiki ida Deus athi-ra vanaabajahakivini, oniani ida Moisés kohana makhira-ra va'ahavini hija kidigamo-ra nahojahavini. Asia vakhanina adani ija'ari vahokiki hidakaba'i. A'onivani jaboni ni-Deus athi-ra avanaabajahakivini-ra avanofiki. Hahavi kama'dani kari vani ni-makhira kidigamo-ra nahojahavini Deua binofiki. ");
INSERT INTO padNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka'oa hiki hida kodivarani. Gamo makhira hoariha-ra vi'omaravini kaba'i, kidimakhira binahojahahi, gamo hoariha-ra anakarara kaimoni, Jahari kabadania kabadaniki ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesus ipohina vani'aha: —Jesus, jahariki ida makhira kidigamo-ra nahojahavini-ra ikahivini. Kidigamo-ra vajahajanaravini kaba'i, jahaki ida bivahojahaha'oadahavini ikahivini, oniani ida makhira gamo-ra anakaravini jahariki-ra akava'ibodivaranivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus va'ora ni'aha: —Ni-ija'ari hahavia vakaabokaki ida akararini hojani. Deua binofiki ida ija'ari akarani hojani. Hojaki ida ija'ari hoariha Deua binofiki akararini. ");
INSERT INTO padNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ni-makhira hahavia bikaabokaki ida kagamoni. Vahoariha vatanana isai vihina vani vakaabokarija ida. Makhira vahoariha isai-ra vanamonahavini-ra vakaabokaravini hiki vakananafa ka'ba'dani kaaniani, oniani ida vagamona-ra vakaabokaravini hija. Vahoariha ni-vanofiki ida avakarana, vanofiki ida vaabono gahinai vanihavini Deus kania, kidibadani ka'oa vakabadanira kaimoni, oniani ida avakarana-ra vanofiravini hija. Ija'aria vanofiki ida avakararina vahojana, vakadimoni hida ojomo'ihi kavaranihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hari. Oniaroa, ija'ari va'ora vavikhaha adani vakadisai Jesus kania. Vanofiki ida Jesus vakadisai-ra va'ora kaabadaronahavini, Deu-ra kanikhariavini isai vakadimoni afohanana. Ipohina va'ora vakaabani'aha: —Hari'a va'ora vavikha va'oani isai! ");
INSERT INTO padNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hari. Jesus va'ora ni'aha: —Jakaho vikhava va'oani isai kodiania. Hari'a va'ora vakaabani kodiania vikhana. Hi'adani isai fori vihiki vani hadani Deu-ra vanofijahakira. Isai vania vanofira ada Deus va'ora vaka'da'dira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Oniaroa, Jesus isai-ra va'ora kaabadaronahahahavi'aha. Deu-ra kanikharia'aha va'ora kajoamorara kaimoni. Va'ora kaabadavini naothinia ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hari. Oniaroa, Jesu-ra namaakari'aha ada makhira, binana'dohi'aha: —Jesus, onofiki bana ida kodimahi anokhomirini Deus kania. Hana hini badani jahaki ida bada oni'aja kaimoni, oabinina kamahini Ibavi Jahaka'oakia ookhaja kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesua bigathani'ihi ida kidina'dohi: —Nahina kaimoni hora inana'dohivini hiki ida badani jahaki? Deus oavani ada jahara. Mahi anokhomiriki-ra inofihi Deus kania, inaaba'a bana ida Deus kava'isohihi jiriki afohahavi. ");
INSERT INTO padNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","— Hana hini va'isohihi jirikia hora ihonariahi onaabaja kaimoni? — binana'dohi'aha. Jesua bini'aha: “Hari'a hoariha-ra naabini. Hari'a ivi'oma oni makhira hoariha kagamo. Hari'a bo'dia. Hari'a hoariha-ra korijanahia akaraganaha. ");
INSERT INTO padNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ikamitha'a oni kadabi'i, kadamia vihiki ira vara vani'avini. Iabono inakaidivavini vani fori iniha ida ija'ari hoariha-ra inakaidivavini.” Nimania hida Deus kava'isohihi jiriki. ");
INSERT INTO padNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Niha ada makhira: —Jesus, onaabaki hida Deus kava'isohihi jiriki afobakhia. Nahina hoariha-ra bada oni'avini jahaja koda? ");
INSERT INTO padNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesua biogaki ida makhira kidinahina-ra nofivini arafiani, oniani ida bini'avini hija: —Kadahojai jahaka'oani-ra inofihi, kadanahina-ra pavakari niha'a afohahavi. Ija'ari vakanahinariki-ra va'ora no'avinihi ida jiniro. Deus ibavia nama iokhani kamahini, ikanahina'ahapiki'ianaki bana i. Kadapavakarihi naothinia, hora vaipohiha'a. ");
INSERT INTO padNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hari. Mitha bini'ahi ida Jesus athi. Kidinahina ahapini gahinai hini varani hini mani ida va'i mokara ni'akarahoni hija. Ni-no'ai hini binofiki, oniania, ajihi'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hari. Jesus va'ora ni'aha adani kidipohi: —Ka'oa hiki hida kodivarani. Vakanahina'ahapikiki, vakadinahina ipohiki-ra vanofivini mani ida Deu-ra vagathaniravini hija vakadika'da'di kaimoni hina — va'ora ni'avini. ");
INSERT INTO padNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jesus va'ora kavarajomiki adani ija'ari vakanahinakarahoki cavalo avi jo'onia okhajavarina-ra kaabokaravini fori vihina: —Avi jo'onia cavalo okhajavarina-ra kaabokariki fori vihiki adani vakanahina'ahapikiki. Vakadinahina-ra vanofijahakivini mani ida Deus vakadika'da'di hina-ra vagathaniravini hija, oniani ida Deus ibavia va'ora arakharija. Ni-vakaabokaki ida avikhana. Ija'ari vakadinahina-ra vavakaijokavini oadani, ni-vakaabokaki ida Deus ibavia avikhana. ");
INSERT INTO padNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesus ipohina vakamithahi ida athi, vakava'ibodivarani'ahapiki'ihi, vanana'dohi'aha: —Ka'oa mani ida koda iathini, ni-nihanikia ija'ari abononi akava'ijoaki, Ibavi Jaharika'oakia okharia kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Oniaroa, Jesus vada va'ora ni'aha, va'ora ni'a'aha: —Ni-ija'ari abononi akava'ijoavini-ra kaabokaki. Deus ka'oa ija'ari-ra akava'ijoavini-ra kaabokaki. Deua bikaabokaki ida badani hahavi danoki bada ni'ani. ");
INSERT INTO padNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hari. Pedroa bini'aha: —Harivani akadinahina, agorana, akadija'ari vihiki-ra va'ora anahojahahahavi'iki hari, ira avaipohihaja kaimoni. Nahina agahinaki bana hari? ");
INSERT INTO padNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus va'ora ni'aha: —Ka'oa hiki hida kodivarani: Hovani ija'ari hahavi vakadi'aajo ho. Hahavi aja'dini kamahini vani, ka'da'di kavithi ibavinia ovithiki bana ho. Jahaki vagaki nokiani ida ka'da'di kavithi ibavini. A'onivani oipohina avihini mani ida kodiania a'onira navithijabanaja bana. 12 avihiki a'oni. 12 hiki ida ka'da'di kavithi ibavini avakadimoni. A'onivani va'ora avanasohiki bana adani Israel kaija'ari hahavi. ");
INSERT INTO padNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kodipohia binahojaha'iki ida gorana, igamina, kidiabi'i, kidiamia, kidisai, kidiarabo hiki, vara bivani'aka'oaja kaimoni ida omonina jahaki, ovari abinirina oadani gahinaki bana ada nahina ipohikia. Pa'itxi ida binahojahaki, karaho ida bigathaniki bana. Karaho ida binahojahaki, karaho arafiaki ida bigathaniki bana. Abinina naothinia gahinaki jaboni ada bana kidimahi jahaki anokhomiriki Deus kania. ");
INSERT INTO padNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hari. Ija'ari vaipohiki Deus va'ora baranahavini va'oaniaro miro'a avi'oiki bana adani Deus ija'ari-ra vaka'da'divini kania. Ija'ari vahoariha va'oaniaro miro'a Deus va'ora baranahavini kaba'i avi'oisiagaki adani, vahoariha ni-avi'oiki Deus ija'ari-ra vaka'da'divini kania. ");
INSERT INTO padNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hari. Jesus va'ora ni'aha: —A'onira vara oni'avini hiki ida bana rajomi kavaranihi. Uva kasiroini kaka'da'dini honai abono-ra nako'dihavini vani fori hiki ida Deus ija'ari-ra vaka'da'divini. Mahi avagani kama'dani ajihi'aha ada ka'da'di, honai abono-ra va'ora nako'dihavini, kidiuva kasiroinia bada vakhanira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Honai abono-ra va'ora karagaha, va'ora ni'aha: “Kodisiroia bada avakhanini-ra avanofihi; a'onira ono'avini hiki ida jiniro 'ba'dani prata amonahaki hoarani afohanana, mahi hoarani badani abosini.” Va'ora ni'aha. Vani'aha: “Jahaki ida badani abosini. Bada akhaniki hari kadasiroia.” Vakhani'aha. Vakadihojai hiki ida honai abono gahinana hiki jiniro 'ba'dani prata amonahaki hoarania, kidibadani abosini mahi hahavi. Oniaroa, va'ora karona'aha kidisiroia bada vakhanihana. Ajoi'aha ada ka'da'di gorana. ");
INSERT INTO padNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Safini namahikajomana vani, ajihi'ianaha ada ka'da'di, ija'ari 'bai-ra vakapavakarivini ibavini kania okha'aha. Va'ora noki'aha adani makhira vakabadaniriki. ");
INSERT INTO padNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hari. Va'ora ni'aha: “Kodiuva kasiroinia avikha'a mahija bada avakhanivini. Mithani vani a'onira ono'aja bana avakadibadani abosinia asohiki.” Va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Avikha'aha adani makhira bada vakhanira kaimoni kidisiroia. Safini sohirarina okha'ianaha ija'ari 'bai-ra kapavakarihavini ibavini kania, makhira vahoariha bada vakhaniriki-ra va'ora karagaha'ianaha, va'ora nava'isohivini hi'ihi ida mithani vakadibadani binaabosivini. Naothinia, va'ora karona'ianaha adani makhira kidisiroia. Safini aadosina vani, onivani fori hi'ianahi ida ka'da'di kabadani. ");
INSERT INTO padNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Safini ajorana vani okha'ianaha ada ka'da'di. Va'ora noki'aha adani makhira vahoariha bada vakhaniriki, va'ora nana'dohi'aha: “Niha avakhanimanija mahi oadani bada avakhaniriki?” ");
INSERT INTO padNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ni-ka'da'di haria honariafiahaki badania.” Vakhaniha. Oniaroa, uva kasiroini kaka'da'dini va'ora ni'aha: “A'onivani jaboni kodisiroia avikha'a mahija bada avakhanivini.” ");
INSERT INTO padNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hari. Mithani vani ka'da'dia bini'aha ada kidisiroi akadava'ava abono: “Va'ora baranaha adani honai abono mahija va'ora inaabosivini vakadibadani abosinia. Va'ora naabosi'imidia adani makhira kodisiroia avikhaki safini ajorana. Safini aadosina vakadibadani kama'daki maina-ra va'ora naabosi bana. Safini khanomananina vakadibadani kama'daki maina-ra va'ora naabosi bana. Va'ora naabosisiaga adani mahi oadani bada vakhaniki.” Niha ada ka'da'di. Oniaroa, siroi avakadava'ava abonoa binaabaki ida athi. ");
INSERT INTO padNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Makhira safini ajorana vakadibadani kama'daki vagahina'iki jiniro 'ba'dani hoarani afohanana. ");
INSERT INTO padNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hari. Makhira mahi avagani vakadibadani kama'daki vava'i bodini vara ni'iki: “Mahi oadani bada akhani'iki hari. Ka'da'dia binaipohiki bana ida akadibadani abosini.” Vaabono vani'aha. Ni-ka'da'dia binaipohiki ida vakadibadani abosini. Va'oaniaro maina vagahina'aha vakadibadani abosini jiniro 'ba'dani hoarania afohanana. ");
INSERT INTO padNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Vagathani'ihi ida jiniro, vakadika'da'di-ra vaka'da'digaria'aha: ");
INSERT INTO padNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Hi'adani aripohina safini ajorana bada vakhanipa'itxiki adani. Harivani mahi oadani bada akhani'iki hari safini afakia. Akadibadani abosini vakadibadani abosini fori hiki. Ni-asohiki ida ka'da'di badani-ra naabosivini nini.” ");
INSERT INTO padNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hari. Vakadika'da'dia bini'aha ada makhira hoarana: “Ivani, mitha ini'a bana hida kodivarani. Asohiki ida ira ono'avini jiniro 'ba'dani hoarani. Kodisiroia iokhani viahania ira onava'isohivini hiki ida kadabadani abosini. Jahani ikahiki ida jiniro 'ba'dani hoarania ira onaabosivini. ");
INSERT INTO padNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oniania igathani'a hida kadabadani abosini, igorania okha'a. Onofiki ida kodisiroia okasiagaki-ra ono'avini hini kidibadani abosini ipohini, kadabadani abosini ipohini vani fori hija ida ono'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kodijiniro oamani hida. Kodijiniroa ono'avini onofihi; ono'ahi. Ono'avini onofirihi; ni-ono'aki. Asohiriki ivanihamanija ida hoariha-ra ono'avini hiki jiniro 'ba'dani hoarani? Iakabaimanija ida hoariha-ra okajoamoravini?” Niha ada ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hari. Anokhomi'ihi ida Jesus rajomi kavaranihia kavaranina. Jesus va'ora ni'aha adani vajoroniki: —Makhira mahi avagani badania kabadanini kama'daki fori vihiki adani kodihojai-ra va'oaniaro imidia vagathaniki vakadika'da'di ohina. Makhira safini ajorana vakadibadani kama'daki fori vihiki adani vahoariha vikasiagaki va'ora ovaka'da'diki. Vakhanina vani va'ora onaibavijahajahakiki adani oipohina va'ora ovaka'da'diki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hari. Oniaroa, ai vihi'aha adani Jesus, Jerusalém sidajia avigaimori'aha. Vaadahana kaba'i, ipohina 12 vihiki-ra va'ora avikharibanipa'itxi'aha, vahoariha vakamitharia kaimoni ida kidivarani, va'ora nava'isohi'ianavini hiki ida namitha'iariki: ");
INSERT INTO padNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Mitha vani'a. Jerusaléa aokhaki hari. Hovani ija'ari hahavi vakadi'aajo ho. Hora avarakhaki bana adani vahoariha sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama vasa'a kabodinia. Va'oaniaro vakhaniki bana adani: “Jahaki ida abinina.” Vakhaniki bana adani. ");
INSERT INTO padNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Oniani ida ija'ari Deu-ra avigariki vasa'a kabodinia hora avarakhavini hija bana. Oniaroa, hora avigarahaki bana adani, hora vidafiavini, ava akasanakhamakia hora avaka'itapoamisahanaki, hora vanaabiniki bana adani. Hari. Mahi ahoarabakosiki radaha'ihi oahokiki bana ho — va'ora nava'isohijora'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Oniaroa, Jesu-ra vanamaakari'aha adani Zebedeu kaisai vi'bamiki vakadiamia khama. Jesus viaha aasiarari'ihi ida vakadiamia, Jesu-ra kanikhariavini hiki kajoamorani hina. ");
INSERT INTO padNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesua binana'dohi'ihi: —Nahina mani ida inofija? —Ija'ari hahavi-ra ivaka'da'divini kamahini, va'ora honaria bana adani kodisai i'dihania vavithina ija'ari-ra va'ora vavaka'da'divini kadania. Va'ora onofiki hadani kodisai hoarana ipitani aniaja vithina, hoariha ipitani kajasonija vithina — nihi. ");
INSERT INTO padNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus va'ora ni'aha adani kidisai: —Ni-avakadiamia biogajahakiki ida bikanikhariaki avakadimoni hini. Okapoariki bana ida oimana 'banani. A'onivani avakapoarimania koda bana ida avaimani 'banani jaboni? Hofori avihimania koda bana? —Ha'a, ni-akajoniki ida aimana 'banani — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hari. Va'ora ni'aha ada Jesus: —Avakapoarimania bana ida avaimani 'banani. Hofori avihiki bana a'oni, avakamithaki jaboni bana ida avaimani 'banani. Avavithini-ra avanofihi o'dihana. Kodibadani hirihi ida ija'ari-ra onagathogathovini o'dihana vavithira kaimoni. Kodiabi'ia binaibavijahaki ida ibavi opitana ka'aniajanija kajasonija jaboni, va'ora nagathogatho'iki adani ija'ari vavithiki kaimoni o'dihana. ");
INSERT INTO padNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hari. Oniaroa, vakadivarani kamithamahani vihiha adani 10 vihiki vaipohina, oniani ida Tiago, João vihiki-ra va'ora vakaja'oriavini hija. Va'oaniaroa vanofihananaki ida vithi ibavini jahaki Jesus 'dihana vavithina, Jesus ija'ari hahavi-ra vaka'da'divini kamahini. ");
INSERT INTO padNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hari. Jesus va'ora baranaha'aha adani ipohina hahavi vamaakarina. Va'ora ni'aha: —Va'ora avarigamanira adani ija'ari Deu-ra avigariki vakadika'da'di vahojana. Va'ora avavadadamiki adani vakadija'ari. Ija'ari Deu-ra avigariki vakadika'da'di va'ora vahonariafiahaki adani jaboni vakadipamoari vaathi naabani vihina. ");
INSERT INTO padNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ni-onofiki ida ija'ari-ra avahonariavini va'oaniaro ija'ari-ra vahonariavini fori hini. Ka'da'di avihini-ra avanofihi; vahoariha vakadihonai abono fori vihi'a bana. ");
INSERT INTO padNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ka'da'di avihini-ra avanofihi; vahoariha-ra va'ora vaakodia bana! ");
INSERT INTO padNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hovani ija'ari hahavi vakadi'aajo ho. Vahoariha-ra va'ora okajoamoravini hida hora rakhaja. Vahoariha hora vakajoamoravini hirihi hida hora rakhaja. Ibavi Jaharika'oakia avikhaki bana adani ija'ari vaipohiki. Oabono ova'ahaki ho oabinina ija'ari hahavi-ra va'ora oakava'ijoaja kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hari. Jericó sidajia vikhaonani'aha adani Jesus. Ija'ari vaipohikia vavaipohiha'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ai vihina kaba'i, hagihi vadinia vavithima'o'aha adani makhira vi'bamiki vakamaodorohaki. Vakamithaki ida Jesus varani hina. Jesus radahana-ra vanamoniha adani vahoariha. Vakamithahi, vabodi'baraha'aha: —Jesus, ivani Davi kohana kaija'ari namitharonisiagaki i, haria va'adi bana! ");
INSERT INTO padNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ija'ari vaipohiki vahoariha va'ora vakaabaniha: —Vavisoni'a bana! Hari'a bana vabodi'barahajana! Ni-avavisoniki. Va'ora vakaabaniha, va'ora ana'baraha'oamanihi. —Jesus, haria va'adi bana! ");
INSERT INTO padNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ogaakosoaha ada Jesus, va'ora baranaha'aha adani vakamaodorohaki, va'ora nana'dohi'aha: —Nahina mani hida avanofija? ");
INSERT INTO padNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Jesus, anofiki hida anokho-ra ianavagahavini — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus va'ora nakaidivaki adani vakamaodorohaki. Vanokho 'ba'dani bikadasa'aha. Jorakia avagaha'ihi ida vanokho 'ba'dani, oniaroa, Jesu-ra vavaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hari. Ai vihi'aha adani Jesus, Jerusalém sidaji-ra avanamaakari'aha. Vakaikahi'imidiana ibavi Betfagé onikia. Arabo'oa namahiki monte das Oliveiras onikia kanapajahikhamarihi ida ibavi Betfagé oniki. Hari. Avamaakarina kaba'i va'ora honaria'aha adani ipohina vi'bamiki: ");
INSERT INTO padNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Avikhananava'a bana, ibavi banininia avakaikahihi, avakaragaki bana ida jumenta ahosagaki, jumento pa'itxi hojaki jaboni kidiamia ahona. Va'ora vakokhari adani vi'bamiki, hida kodiania vavikha bana. ");
INSERT INTO padNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ija'ari a'onira vahabini bana vanana'dohivini hiki ida avakadibadani. Va'ora vanava'isohi bana: “Jesua birihavini binofi'imidiaki hada.” Oniania, ija'ari va'ora vava'ahaki bana adani jumenta kodiania va'ora avavikhavini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Namitha'iki ida Deus athi namoniva abono kohana vara bivani'ajora'iki: ");
INSERT INTO padNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalém sidaji kaija'arini-ra vara vani'a: Hidakaba'i kaikahiki ada avakadika'da'di. Ni-abono-ra vaboraborahariha ada. Jumento pa'itxi vania bivaadahara ada.” ");
INSERT INTO padNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oniaroa, va'ajihi'aha adani Jesus ipohina vi'bamiki, avikhananava'aha vanaabaja kaimoni ida Jesus athi. ");
INSERT INTO padNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jesus kania vajoi'aha, va'ora avavikha'aha adani jumenta, kidisai pa'itxi khama. Jumento namana avarakasi'ihi ida vakadikarahobi. Okasi'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hagihi bodi pania jumento viaha ija'ari vaipohikia vanahojahi ida vakadikarahobi. Nini vani ija'ari vakadika'da'di kaikahina-ra khai vani'ara. ");
INSERT INTO padNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Avikhananavaki vabodi'baraha'iki, avikasiagaki jaboni vabodi'baraha'iki vakhanibakhiaha: —Ka'da'di o Jesus. Khai ani'ava o Davi kohana kaisai namitharonisiagaki. Deua bikajoamoraki hi'o kha'iki akadiania! Deua bikarona'iki ada kha'iki. Jahaki vagaki ada Deus! ");
INSERT INTO padNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hari. Jerusalém sidajia o'oi'aha ada Jesus. Ija'ari vaipohikia vanajora'aha vava'i kidakida'aha, vaabono vakanana'dohikhama'aha: —Hana hina ada kha'ara? ");
INSERT INTO padNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ija'ari vâipohiki Jesu-ra vavaipohihaki va'ora vani'aha: —Deus athi namoniva abono o Jesus. Nazaré sidaji kaija'arini o, Galiléia kaaraboni kaija'arini o. ");
INSERT INTO padNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hari. Deu-ra khai vani'avini kagorani kavasiribanini bodinia okhajakosi'aha ada Jesus. Va'ora noki'aha adani ija'ari igitha-ra pavakari vanihaki. Ija'aria vakapavakarivini hiki ida igitha Deu-ra vakanava'igavini kaimoni hini. Jesus va'ora aakoja'aha adani pavakarihi abono hahavi. Va'ora aakojaha jaboni adani igitha-ra vakapavakarihaki. Jiniro-ra avanaabosiki vakadimesa-ra akanaadarioni'aha. Ho'doko-ra pavakari vakanihaki vakadivithi ibavini-ra akanaadarioni'aha. Athii khanakia va'ora ni'aha, ai vihi'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Va'ora ni'aha: —Deus athi kapapirania hojaki hida athi: “Deu-ra khai vani'avini kagorani hida Deu-ra vara vani'ara kaimoni.” Niki ida papira athini. Bo'di ibavini avavanihamanija hida gora. Igitha kaidivani-ra avanakarahovini mani ida ija'ari-ra avabo'diabakhiavini hija — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Oniaroa, Deu-ra khai vani'avini kagorani kavasiribanini bodinia hojana kaba'i ada Jesus, vikha'aha adani ija'ari vakamaodorohaki, vakabaha katonorohaki vihiki, Jesus va'ora anaihota'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hari. Sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama vanoki'ihi ida Jesus kabadani danoki ipohiki, va'ora vakamitha'aha adani jaboni isai vabodi'barahaki: —Khai ani'ava ada Jesus. Davi kohana kaisai namitharonisiagaki ada — vakhaniha adani isai Deu-ra khai vani'avini kagorani kavasiribanini bodinia vahojaki. Oniani ida Jesu-ra vakaihamahikarahovini hija sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama. ");
INSERT INTO padNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesu-ra vani'aha: —Ikamitharia koda ida isai vara ira vavani'avini? Ni-jahaki. Jesus va'ora ni'aha: —Ha'a, okamithaki ida isai vakadivarani. Avanokiria koda ida Deus athi kapapirani athini: “Deus va'ora ka'ojomo'iki adani isai vadorohana, isai vaitxanava Deu-ra khai vani'ajahakira kaimoni.” ");
INSERT INTO padNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hari. Jesus va'ora nahojaha'aha, sidajia ajihi'aha, ibavi Betânia onikia okha'aha. Joma hoja'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hari. Ka'afokajomani vagavagani Jerusaléa avajoi'aha adani Jesus kidipohi khama. Vai'ami'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bianoki'ihi ida figira avani hagihi vadinia. Binavanavanaha'ihi, akhano'aha, binako'dihi ida ihi'ai, ni-bikaraga'iki, bikaraga'ihi ida afani ka'oa. Oniaroa, Jesua bini'a'ihi ida figira avani: —Hari'a bonojana! Jorakia ara'okhohahavi'ihi ida figira avani. ");
INSERT INTO padNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ipohina vanoki'ihi, vakava'ibodivaranikaraho'ihi, vani'aha: —Jorakia ara'okhohahavi'iki ida figira avani. ");
INSERT INTO padNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Oniaroa, Jesus va'ora ni'aha adani ipohina: —A'onira onava'isohiki bana ho: Avava'ini kakhakhamarini vani Deu-ra avakajari'darihi; avakaabokahi jaboni ida figira avani-ra avaranara'okhovini, oanara'okhovini vani fori hini. Badani danoki ipohiki-ra avakaabokaki bana a'oni. Avakaabokaki jaboni ida arabo namahiki-ra avahonariavini: “Arabo nama hiki, akara'o'a, iabono nahokahi'a paha bihiaki bodinia.” Deu-ra avakajari'darihi; namithaki bana ida. ");
INSERT INTO padNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Deu-ra avakajari'darihi; avagathanihi ida kidiania avakanikhariaki. ");
INSERT INTO padNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hari. Deu-ra khai vani'avini kagorani kavasiribanini bodinia joi'ianaha ada Jesus. Va'ora ka'ojomo'ivini kaba'i adani ija'ari, Jesu-ra vanamaakari'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama. Vanana'dohi'aha: —Nahina vani ira honariavini hija ida kadabadani-ra bada ini'avini? ");
INSERT INTO padNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Va'ora ni'aha ada Jesus: —A'onira onana'dohi'imidiaki bana ho. Kodina'dohi-ra avagathanihi; a'onira onava'isohivini hiki bana ada hana hina hora honariaki. ");
INSERT INTO padNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","26","Hora vananamitha'a bana, João Batista kohana va'ora kana'iki adani ija'ari vakadihojai asohiriki-ra vakava'ipahini'iki. Hana hina vani João Batista kohana-ra honariaja ija'ari-ra va'ora kanara kaimoni? Deus vania koda bihonariara ada João Batista ija'ari-ra kanavini? Ija'ari vania koda bihonariara ada João Batista ija'ari-ra kanavini? — va'ora nana'dohi'aha ada Jesus. Oniaroa, vaabono vakani'akhama'aha adani sasidotxi vavaka'da'diva: —Anofirihi ida João Batista Deua bihonariavini-ra akahivini. Ni-anofiki jaboni ida Deus João Batista-ra honariaravini-ra akahivini. Deus João Batista-ra karonavini-ra akahihi; jaharihi ida João Batista athi-ra akajari'davini Jesua bikahivini. Deus João Batista-ra karonaravini-ra akahihi; ija'ari haria vakaihamahihi. Haria vakaihamahivini hiki João Batista Deus athi namoniva abono hina-ra vakajari'daravini — vaabono vakani'akhama'aha adani sasidotxi vavaka'da'diva. ");
INSERT INTO padNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Oniaroa, Jesu-ra vani'a'aha: —Ni-aogaki ida João Batista ija'ari-ra kanavini, Deua bihonariavini bihonariaravini. Va'ora ni'aha ada Jesus: —Hora avananamitharihi; ni-a'onira onanamithaki jaboni hora honariakia — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hari. Jesua vara bivani'ahi ida rajomi kavaranihi: —Vakava'ibodivarani bana hida kodivarani. Hojaki ada makhira. Vi'bamiki adani kidisai. Imakhinava adani. Aajojahiki-ra ni'aha ada vakadiabi'i: “Kodisai, kodiuva kasiroinia okha'a bana hidakaba'i mahija bada inini.” ");
INSERT INTO padNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Iniani, ookhana-ra onofirihi.” Niha ada aajojahiki. Mitihini bikava'ibodivaranirari'ihi ida athi, abono-ra ka'da'digaria'aha, siroia okha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Oniaroa, kajo'ojahiki-ra ni'a'aha ada vakadiabi'i: “Kodisai, kodisiroia okha'a bana hidakaba'i mahija bada inini.” “Hai, jakaho ba ookhava.” Niha, kidiabi'i athi-ra gathanivini. Kaba'i, ni-okhaki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Oniaroa, Jesus va'ora nana'dohiha adani kidivarani kamithani vihiki: —Hana hina vania bada bini'a'ia ida vakadiabi'ia binofiki? —Aajojahiki vania bada bini'a'ia ida — Jesus kana'dohi-ra vagathani'aha. Hari. Jesus va'ora ni'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama: —Ija'ari Jahari kabadania vakabadaniki vakadihojai-ra vakava'ipahini'avini mani ida Deus ija'ari-ra vaka'da'divini kania va'ora ani'oija va'oaniaro imidia. A'onivani avajahaka'oaki avavanihavini mani ida jorakia a'onira ani'oirija Deus kania. A'onivani Deus athi-ra avanaabavini-ra avakahivini kaba'i, ni-avanaaba'iaki kaho. Ija'ari hojai jaharikia kahojaiki Deus kania vaabono gahinai vanihaki. A'onivani ni-Deu-ra avanofi'iaki kaho a'onira vaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","João Batista kohana vania vara bivani'a'imidiaja ida badani Deua binofiki, ija'aria avigaja kaimoni ida hagihi Deus kania okhaki. João Batista athi-ra avakamithavini kaba'i, avakajari'dahi. Imposto gathaniva abono vani adani vajari'dariha. Gamo makhira-ra avidoraonibakhiaki vani adani jaboni vajari'dariha. Avanoki'avini kaba'i ida Jahari kabadani-ra vakava'ipahinivini, a'onivani ni-avakava'ipahini'iaki ida Jahari kabadania avakabadanibakhiani, avaabononi gahinai avanihaja kaimoni Deus kania — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Hari. Oniaroa, rajomi kavaranihia Jesus va'ora vara ni'aha adani ija'ari vajoroniki. —Mitha vani'a! Ka'da'dia bivahonariahihi ida siroi uva rakhajahani ibavini kaimoni. Bivahonariahihi ida uva avani rakhajahani. Bono'ihi havahaki kaimoni ida ihi'ai uva oniki. Varakhaivini naothinia bivahonariahihi kavasiribanini ida uva kasiroini. Binamonahaki ida ja'di kabavihi karaho bihiaki uva bavini kaimoni, uva-ra vakada'aha'ahavini hiki a'bani aniaja kaimoni. A'diahi'ihi ida uva bavini, bivahonariahihi ida gora namahiki amonahani, kidisiroi-ra akadava'avini ibavini kaimoni ida gora. Hari hi'ihi ida kidibadani, va'ora honariaha adani badani abono avakadava'aja kaimoni ida kidiuva avani. Avakadava'ahi ida uva avani, bono'ini kamahini a'bani pitani vakadimoni, pitani vakadika'da'di kaimoni. Bivahonariahivini naothinia ajihi'aha. Ibavi hoariha napaja hikia okha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Oniaroa, uva a'dihani kamasikoni vani ka'da'di va'ora karona'aha adani kidihonai abono vaipohiriki. Va'ora ni'aha: “Avikha'a uva avakadava'ava abono vakadiania mahija kodiuva a'bani pitani-ra avagathanivini kodimoni.” Hari. Va'ajihi'aha, uva kasiroini kania vakaikahi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Uva avakadava'ava abono va'ora vagathiha, vidafiaha'aha ada hoariha, vanaabini'aha ada hoariha, vanagaha'aha ada hoariha ja'dia. ");
INSERT INTO padNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hari, ka'da'di va'ora karona'ianaha adani kidihonai abono vahoariha vaipohiki uva avakadava'ava abono vakadiania avikhana. Avikha'aha, vakaikahi'aha. Vakaikahina vani va'ora vanajahariharivini jaboni, vahoariha vani fori vihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hari. Naothinia ka'da'dia bikarona'aha ada kidisai hoarana, uva avakadava'ava abono vakadiania okhana. Abono-ra ni'aha ada ka'da'di: “Kodisai-ra vagathanijahakiki bana adani uva avakadava'ava abono.” Oniaroa, okha'aha ada ka'da'di kaisai. ");
INSERT INTO padNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Uva avakadava'ava abonoa avanoki'aha khana. Vaabono vakani'akhama'aha: “Hada vani akadika'da'di kaisai. Ka'da'di abinina kamahini kidisai vania bigathanija ida kidiabi'i kaarabo afohahavi. Anaabiniva mahija kidiarabo avahojavini.” Vaabono vakanava'isohikhamavini. ");
INSERT INTO padNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hari. Kaikahi'aha ada ka'da'di kaisai, vagathiha, uva kasiroini banininia avarahokaonani'aha, vanaabini'aha. ");
INSERT INTO padNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hari. Jesus va'ora nana'dohi'aha adani ija'ari vajoroniki: —Ka'da'di joina kamahini niha va'ora ni'a'aki koda bana adani uva avakadava'ava abono? ");
INSERT INTO padNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Vani'aha: —Va'ora vahonariahiki bana vaabinina adani uva avakadava'ava abono. Vahoariha maina-ra va'ora honariaki bana ada, kidiuva kasiroini akadava'ani vihira kaimoni. Uva a'dini kamasikoni va'oaniaroa vano'aki bana ada ka'da'di kidiuva a'bani pitania. ");
INSERT INTO padNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hari. Jesus va'ora ni'a'aha: —Avanoki'iki ida Deus athi kapapirani pitani athini: “Hojaki ida ja'di jahaki, ja'di kagorahi dadani kaimoni. Gora namonahava abonoa ni-vanofiki ida ja'di karaho. Jahani kaba'i ni-vanofiki ida ja'di. Vanofiravini kaba'i, Deua binagathogatho'iki ida ja'di karaho. Akava'ibodivarani'iki ida ja'di Deua binagathogatho'iki. Jahani arafiaki ida ja'di karaho.” ");
INSERT INTO padNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Oniaroa, Jesus va'ora ni'aha: —Ka'oa oamani hida oathi. Deus vani va'ora nagathogatho'ara adani judeus kaija'ari, kidija'ari vihira kaimoni. A'onivani judeus kaija'ari avihini kaba'i, ni-avanofiki ada Deus avakadika'da'di hina, oniani ida a'onira nofijanaravini hija. Va'ora nagathogathoki bana adani ija'ari vahoariha hojai Deua binofikia vakahojaina — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jesus abono-ra kavarajomivini ja'di karahoa. Va'ora ni'aha: —Ija'ari hana hini voronirarihi ja'di karaho namania; 'boro'borohi ida ija'ari. Ija'ari hoariha namania voronirarihi ida ja'di karaho, akhomahi ida ija'ari — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Rajomi kavaranihi-ra mitha vani'aha adani sasidotxi vavaka'da'diva, farisio khama. Vaabono vakani'akhama'aha: —Jesu-ra agathanijahakiravini mani ida Jesus varani arihina-ra vara vani'avini hija. Jesus haria kavarajomivini vihiki adani uva avakadava'ava abono uva a'bania vakadika'da'di-ra vakaathiriki — vaabono vakani'akhamaha. ");
INSERT INTO padNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Oniania, Jesu-ra vagathivini-ra vanofi'aha. Ija'ari vaipohiki-ra vifinivini mani ida Jesu-ra vagathiravini hija. Ija'ari vaipohiki vaabono vani'aha: —Deus athi namoniva abono ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Hari. Rajomi kavaranihi hoariha va'ora vara ni'aha ada Jesus: ");
INSERT INTO padNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Okavarajomiki ida Deus ija'ari-ra vaka'da'divini, arabo ka'da'dini akarai kaihinikani amonahani-ra vahonariahivini kidisai kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Arabo kaka'da'dini va'ora karonaki adani kidihonai abono va'ora avanaaminaonivini adani kanori abono baranahi vihi'ina afojora. Ni-vikhana-ra vanofiki afohanana. ");
INSERT INTO padNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hari. Arabo kaka'da'dini va'ora karona'ianaha adani honai abono vahoariha, va'ora nava'isohijoravini hiki ida athi vanamoniki kaimoni kanori abono vakadiania: “A'diahiki ida akarai kaihinikani amonahani kabadanihi. Va'ora ovahonariahiki adani 'daama kahidari vadorohana, 'daama kahidari vana'bahaki vabasinaki vihiki jaboni vaabinina. Akai'iki ida ihinika ko'baini. Vikha'a bana ihinika kania.” Niha. ");
INSERT INTO padNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Oniaroa, avikha'aha adani honai abono, va'ora vanava'isohira kaimoni adani kanori abono. Kanori abonoa mitha vani'ahi ida ka'da'di athi va'ora kaboa'i'avini, ni-vanofiki ida avikhana. Avikha'aha afohanana vakadibadani kania bada vakhanira kaimoni. Hoariha kidisiroia okha'iki, hoariha kidinisika-ra pavakari nihavini ibavinia okha'iki. ");
INSERT INTO padNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Vahoariha va'ora vagathi'aha adani honai abono, va'ora vidafia'aha, va'ora vanaabini'aha. ");
INSERT INTO padNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hari. Ihamahikaraho'aha ada arabo kaka'da'dini. Va'ora karona'aha adani kidisorara kanori abono vakadiania avikhana, va'ora vani'aha: “Kanori abono vakadiania avikha'a mahija va'ora avanaabinivini. Avanaha'diha'a bana ida vaibavi.” ");
INSERT INTO padNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hari. Kanori abono vaabinihahavina naothinia arabo kaka'da'dini va'ora vara ni'a'ianaha adani kidihonai abono: “Va'ora onofivini vanivaha kodihinika kania vikhana. Hora vanofiki va'ora ovanihavini. Hora vakajonivini mani ida akarai kaihinikani kania vahojana va'ora onofijanaravini hija. ");
INSERT INTO padNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oniania, avikha bana. Hagihia ija'ari-ra va'ora avakaragahi, va'ora vakaboa'ihahavi'a bana akarai kaihinikani kania vikhana.” ");
INSERT INTO padNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hari. Ai vihi'aha adani honai abono, hagihi ipohikia avaadahaonina, va'ora vakaraga'aha adani ija'ari hojai jahakia vakahojaiki, hojai jaharikia vakahojaiki jaboni, va'ora vakaboa'ihahavi'aha akarai kaihinikani kania vajoronina. Akarai kaihinikani kagorani kania vakaikahi'ina adani kanori abono, vagathanihanana'ihi ida makari jahaki vakaimahaki kaimoni gora bodinia, oniania ji'bini'ihi ida gora ija'aria. ");
INSERT INTO padNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Oniaroa, kaikahi'aha ada arabo kaka'da'dini, va'ora navanavanaha'aha adani kanori abono. Binoki'aha ada makhira, ovaria ni-bikaimahaki ida ihinika kavamakarini jahaki. ");
INSERT INTO padNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka'da'dia binana'dohi'aha: “Ivani, nihaniki vania ikhajakosija ihinika kagorania ikaimaharavini oadani ida makari jahaki?” Makhira ni-bigathani'iki ida na'dohi hina. ");
INSERT INTO padNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Oniaroa, ka'da'di va'ora honariaha adani kidihonai abono: “Vakodaboha bana hida makhira sa'a, 'dama kihiki. Baniniaja vanahokahi'a bakibakini kania. Oniaja abarariariaki bana ada, kakiroromisiki bana ida kanada.” ");
INSERT INTO padNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Hari hi'ihi ida rajomi kavaranihi Jesua vara bivani'a'iki. Va'ora ni'aha adani vajoroniki: —Vaipohiki adani ija'ari Deus va'ora kaboa'iki kidiania vikhana. Vaipohiriki vani adani va'ora nagathogathoha kidija'ari kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hari. Jesus kania ai vihi'aha adani farisio. Vaabono vakanava'isohikhama'aha: —Jahaki ida Jesu-ra anana'dohibakhiavini asohijanarija kaimoni ida kidivarani, oniani ida anaathidanoararivini hija. ");
INSERT INTO padNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Oniaroa, farisio va'ora vahonariaha adani vaipohina, Iroji ipohina vaipohiriki khama Jesus kania avikhana, Jesu-ra vakaboroborora kaimoni vakadina'dohia. Hari. Jesus kania avikha'aha adani makhira. Vani'a'aha: —Jesus, aogaki ida ija'ari vava'i-ra ivajaharavini kadavarania. Ija'ari hahavi-ra va'ora ika'ojomo'ivini hiki ida badani Deua binofiki bada vani'ahaha'oadahaja kaimoni. Ija'aria vavajaharavini kaba'i ida kadavarani, ni-ianahoarihaki oni iathini khai va'ora ni'aja kaimoni. Vara ivani'aka'oaki ida varani ka'oa hini. ");
INSERT INTO padNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Haria nanamitha bana Deus kava'isohihia: Deus haria honariamanija imposto kajinironia arabo kaka'da'dini-ra ano'avini? Jahamanija koda ida arabo ipohiki kaka'da'dini athi-ra anaabavini? — Jesu-ra vani'aha. César oniki ada arabo ipohiki kaka'da'dini. ");
INSERT INTO padNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Vakaborovini-ra ogaki ada Jesus. Oniania, va'ora ni'aha: —Deus athi-ra avanofivini-ra avakahi'badaraki a'oni. Ni-avarigavini avanofidoroki ida avakadina'dohi. Avanofiki ida hora avarakaraganahavini, oniani ida hora avakaboroka'oavini hija. ");
INSERT INTO padNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hora vakavikha jiniro 'ba'dania mahija imposto kajinironi-ra vada oni'avini — va'ora ni'aha. Hari. Vavikha'ihi. ");
INSERT INTO padNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesus va'ora nana'dohivini hi'ihi ida jiniro 'ba'dani: —Hana hina onina mani hida? Hana hina ka'da'di akamoani mani hida? ");
INSERT INTO padNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vani'aha: —César ka'da'di akamoani mani oni. Onina mani oni jaboni. Oniaroa, Jesus va'ora ni'aha: —Césa-ra vano'a bana kidinahina binofikia. Deu-ra bana vano'a jaboni kidinahina binofikia — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Vakamithahi ida Jesus athi, vakava'ibodivarani'ihi ida niha ninini vakadina'dohi bigathanivini. Ni-Jesu-ra vanana'dohijanaki, va'ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hari. Oniaroa, mitihini vikha'aha adani sadosio. Sadosio vakadivarani hiki ida ija'ari abinini naothinia abononi ahokirini. Hari. Jesus kania vamaakari'aha adani sadosio. ");
INSERT INTO padNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Vani'aha: —Jesus, Moisés kohana ija'ari-ra va'ora ka'ojomo'ivini hida: “Isarina oadani abini'aha ada aajojahiki, kaariha hi'ihi ida kidigamo, kajo'ojahikia bianakara'ihi ida kaariha, bivaisaja kaimoni ida gamo, kidi'aajo kohana kaisai hija kaimoni ida kidisai.” Nimania ida Moisés athi Deus kava'isohihi jirikia hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hari. Ahararana vahojaha adani 7 vihiki imakhinava kohana. Vaigamina adani. Aajojahikia bianakara'ihi ida kidigamo. Kidigamo-ra vaisaravini oadani abini'aha. ");
INSERT INTO padNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Oniaroa, kidikajo'oa bianakara'ihi ida kidigamo kaariha biniha'iki. Bivaisaravini vani abini'aha ovari maina. Kidikajo'o hoariha bianakara'ianahi ida vakadigamo kaariha vanihaki. Bivaisaravini vani abini'ianaha ovari jaboni. Kidikajo'o hoariha bianakara'ianahi ida vakadigamo kaariha vanihaki. Onivani fori vihira adani kajo'ojahiki vahoariha avanakarahananavini ida kaariha afohanana. Vavaisaravini vani vaabini'aha afohanana. ");
INSERT INTO padNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Vaabinihahavina naothinia abini'ihi ida gamo jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haria nanamitha bana Deus kava'isohihia: 7 vaigamina vaabinina viahania avanakarahanana'iki ida gamo. Ija'ari kohana ahokini kamahini, hana hina vani bana kagamo hija ida gamo? ");
INSERT INTO padNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","30","Hari. Jesus va'ora ni'aha: —Iniani, asohirihi ida avani'aki! Ija'ari abinini ahokini kamahini makhira ni-vaagamojanaki. Gamo ni-vakamakhirajanaki jaboni. Deus ibavi kaija'arini avakararina vani fori hija ida ija'ari ahokiki. Ni-avarigaki ida Deus athi papira hojaki. Deus athi-ra avarigaravini mani ida avakadivarani-ra avakanasohikhamaravini hija. Avarigarihi jaboni ida Deus danona. ");
INSERT INTO padNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hora avanana'dohivini hiki ida ija'ari abiniki ahoki'ini. Deus athi kapapirani a'onira nava'isohivini hiki. Deua bini'aha: ");
INSERT INTO padNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Moisés, hovani Abraão kaDeus ho, Isaque kaDeus ho, Jacó kaDeus ho.” Niha ada Deus. Deus Moisé-ra vara ni'avini kari, vaabini'bo'da'iki adani Abraão, Isaque, Jacó vihiki. Kidimoni vihina asia vahokiki adani, ni-ihimiki ida vakadimahi. Avahoki'iki adani ija'ari vaabini'iki, asia vakadiDeus hiki ada Deus — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Oniaroa, ija'ari vaipohiki vajoronikia vakamitha'ihi ida Jesus kavarani, vakava'ibodivarani'ihi ida kidi'ojomo'ihi athini. ");
INSERT INTO padNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Oniaroa, Jesus vakadina'dohi bigathanijahakivini mani ida sadosio vaathi-ra viso ni'aja. Hari. Farisio vihikia vakamitha'iki ida sadosio Jesus khama vara vakhanina. Jesus sadosio vaathi-ra anavisonivini mani ida farisio Jesus kania va'ora najoronija. ");
INSERT INTO padNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Farisio vahararana hojaha ada judeus kaija'ari ka'ojomo'iva abono. Binofiki ida Jesu-ra kaborovini jaboni, bianahoarihaja kaimoni ida kidivarani, oniania binana'dohi'aha: ");
INSERT INTO padNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Jesus, ivani ija'ari ka'ojomo'iva abono i. Ipohiki ida honari Deus kava'isohihi jiriki kania. Hana hini honari ida Deus kava'isohihi jiriki hahavi-ra aradaja? ");
INSERT INTO padNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Hari. Jesua bigathanihi ida kidina'dohi: —Deua binofiki ida kidiva'isohihi hahavi anaabavini. Ira onava'isohiki bana ho hida va'isohihi Deua binofivini arafiaki. “Akadika'da'di hiki ada Deus. Inofijahaki'a afoha'oadaha o Deus. Bada inini oadani inofijahaki'a o Deus. Iva'ini bodini vara nini oadani inofijahaki'a o Deus. Mahi, joma hiki inofijahaki'a afoha'oadaha.” Nimania ida va'isohihi jiriki. ");
INSERT INTO padNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Onivani fori hija ida va'isohihi hoariha Deua binofiki-ra anaabavini jaboni. Deus haria honariavini hiki ija'ari hahavi-ra anofijahakivini. Nihi ida Deus kava'isohihi jiriki. “Iabononi inofijahakivini vani fori va'ora niha va'oani ija'ari hahavi.” Nihi ida athi. ");
INSERT INTO padNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ija'aria vanaabajahakihi hida honari 'bamiki, vanaabahahaviki jaboni ida Deus kava'isohihi jiriki, Deus athi namoniva abono kohana afohahavi vaathi hiki ida ija'ari-ra va'ora vaka'ojomo'ivini hi'iki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Oniaroa, vajoroni'aha adani farisio. Jesus va'ora nana'dohi'aha: ");
INSERT INTO padNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Cristo-ra avakava'ibodivaranihi, nahina ida avakava'ibodivaranija? Hana hina kahanodi ada Cristo Deua bikaronara ija'ari-ra vaka'da'dira kaimoni? Vagathani'ihi ida Jesus athi: —Davi kohana kahanodi namitharonisiagaki ada. Va'ora nana'dohi'ianaha ada Jesus: ");
INSERT INTO padNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Nahina mani ida Davi kidihanodi-ra ka'da'dia naonivini hija? Ma'onahai Jahaki Davi va'i-ra nahonariahihivini vani kidika'da'dia binaoni'ara ada Cristo. Davia bini'aha: ");
INSERT INTO padNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Deua bini'aha ada kodika'da'di Cristo oniki: ‘I'damani kanabo'ania va'ora oobaiki adani bana ira vavajahariki, va'ora ikada'aha'ahaki kaimoni. Va'ora onihimahahaviravini oadani, vithi bana hida opitana aniaja ka'da'di ihini kodiania.’ Kodika'da'di-ra ni'aha ada Deus.” Nihi ida Davi kohana athi afojora. ");
INSERT INTO padNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Asia vara ni'aha ada Jesus: —Davi kohana kahanodi hina kaba'i ada Cristo, ni-Davia kidihanodia binaoniki ada Cristo. Binaonivini ada Cristo ‘kodika'da'di’. Kidihanodi hina kaba'i kidika'da'di oamani ada — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Viso vakhani'aha adani farisio, ni-avigaki ida Jesus athi-ra vagathanivini. Ni-Jesu-ra vanana'dohijanaki, vakaipahi'iki ida vanana'dohivini. ");
INSERT INTO padNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hari. Jesus kania vahojaki adani kidipohi, ija'ari vaipohiki khama. ");
INSERT INTO padNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Va'ora ni'aha: —Judeus kaija'ari vaka'ojomo'iva abono, farisio khama, avigaki ida Deus kava'isohihi Moisés kohana binajiri'bo'da'iki. A'onira vaka'ojomo'ivini hiki ida Moisés kohana athi niha ninini avanaabaja kaimoni ida va'isohihi. ");
INSERT INTO padNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Vanaaba bana hihida Deus kava'isohihi jiriki a'onira vaka'ojomo'ivini hiki. Jahaki ida vakadivarani, ni-jahaki ida vakadihojai. Hari'a vakabanafo ida vakadihojai; ni-vanaabaki ida Deus athi a'onira vaka'ojomo'ivini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Va'ora okavarajomiki adani farisio, makhira daji khanaki-ra dabovini ija'ari hoariha ama'adosia biarakasivini fori vihina. Daji khanaki fori hiki ida kaaji ipohiki. Va'oaniaroa vanaipohiki ida kaaji avavakaajija kaimoni. A'onira vahonariavini hiki ida va'isohihi-ra avanaabavini, va'oaniaroa ni-vanaabaki. ");
INSERT INTO padNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Vaabono vavaboraborahaki adani farisio, oniani ida vakadibadani ija'aria vada bini'avini vanofivini hija. Avarakakosi'ihi ida athii pitani oadaki Deus athi kapapirani hojaki. Papira hoariha avarakakosivini naothinia papira bavini-ra avibaiha, vidabomisija kaimoni ida papira bavini vaatha. Vavadi-ra vidabovini hi'ihi jaboni, ija'ari hoariha va'ora nokira kaimoni. Makhira hahavia vakaimahaki ida papira bavini pa'itxi Deu-ra vara vani'avini oadani. Farisio vania vanakarahoja ida vakadipapira bavini, Deu-ra vanofikarahoki vahoariha va'ora vavanihara kaimoni. Vada vani'a jaboni ida farisio vakadimakari ihini vadini sirasirahani oadaki. Makhira hahavia vavahojaki ida makari ihini sirasirahani oadaki. Akaahohaninikhamaki ida vakadikarahobi vakaimahaki nokhoni. Farisio vani adani makari ihini sirasirahani-ra vana'oadahara vahoariha vanokija kaimoni, Deus athi-ra vanaabajahakiki vahoariha va'ora vavanihara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ija'ari vakadihinika ko'baini amonahani kamahini farisio vihikia vanofiki ida vithi ibavini jahakia vavithina, kanori abono vahoariha vajoroniki va'ora vanokira kaimoni. Judeus kaija'ari Deu-ra vara vani'avini kagorania vahojana kamahini, vanofiki jaboni ida vavithina ka'da'di kavithi ibavini jahakia. ");
INSERT INTO padNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ija'ari vajoroniki vaibavia vavajahaki ida ija'ari va'ora vaka'ivanitivini, ija'ari ogahai abono-ra ka'ivanitivini fori hini. Vavajahaki ida ija'ari va'ora naonivini “ogahai abono a'oni”. ");
INSERT INTO padNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ni-vakadihojaia avakahojaini-ra onofiki. Ni-onofiki ida ija'ari a'onira vanaonivini “ogahai abono”. Avaigamini a'oni. Avavahojaki ada ogahai abono hoarana ka'oa a'onira ka'ojomo'iki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hihida araboa avahojani oadani hari'a avakadiabi'ia vanaoni ada hoariha. Hoarana ada avakadiabi'i nama hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hari'a bana va'ora khai vani'a adani ija'ari vahoariha “haria vasohiva” a'onira vanaonivini. Hojaki ada a'onira vasohiki hoarana Cristo oniki ka'oa. ");
INSERT INTO padNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Deua bihonariaki ada avakadiania ka'da'di hina-ra nofiki, ipohina kahonai abono hina. ");
INSERT INTO padNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ija'ari abononi vaboraborahaki vahoariha vaviaha: “Hovani ojahaka'oaki ho.” Deua bini'aki bana ida ija'ari: “Ni-nahina ihipa'itxirihi.” Va'ini aipahihiki bana ida. Ija'ari hoariha bikava'ibodivaraniki ida nahina hirini, Deua bini'aki bana ida ija'ari: “Ivani ijaha'oamanija.” ");
INSERT INTO padNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hari. Asia vara ni'aha ada Jesus: —Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini. Farisio, mitha vani'a jaboni hida a'onira vara oni'avini. Deus athi-ra avanofivini-ra avakahi'badaraki a'oni! Jahariki bana ida avakadimoni. Ija'ari gora jahaki o'oini vani fori hija ida Deu-ra gathanivini kidika'da'di kaimoni hina. Avakaka'oaha'ihi ida bakatha ija'ari avi'oirara kaimoni. Ni-avanofiki ida avari'oini. Ni-va'ora avava'ahaki jaboni adani Deu-ra vanofiki avi'oina. ");
INSERT INTO padNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini. Farisio, mitha vani'a jaboni hida a'onira vara oni'avini. Deus athi-ra avanofivini-ra avakahi'badaraki a'oni! Jahariki bana ida avakadimoni. Va'ora avakajoamora'badarabakhiaki adani kaariha afohanana. Kaariha kanahina, gorani hiki-ra avisaarivini kaba'i, Deu-ra vara avani'a'badaravini athini oadaki, vahoariha avajahaka'oani-ra vakahira kaimoni. Deus va'ora arakhaki jaharika'oani arafiaki bana nikia vakabadaniki. ");
INSERT INTO padNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini. Farisio, mitha vani'a jaboni hida a'onira vara oni'avini. Deus athi-ra avanofivini-ra avakahi'badaraki a'oni. Jahariki bana ida avakadimoni. Avanofiki ida ija'ari Deu-ra khai ni'a'badaravini, Deu-ra khai avani'a'badaravini vani fori hiki, oniani ida arabo hahavia a'onira anaadahaonija, avanako'dihahi ida ija'ari Deu-ra ogariki, Deu-ra kanamasivivini-ra nofiki kaimoni. Avakaragahi, avaka'ojomo'iki avakadihojai 'badara. Avaka'ojomo'ivini naothinia arafiaki ida kidihojai 'badara. Deus ija'ari-ra nasohivini kamahini, Deus a'onira ni'aki bana ada: “Onaabosiki bana ida avakadihojai 'badara nahina jaharikia Ibavi Jaharika'oakia. Arafiaki ida avakadija'ari-ra va'ora avaka'ojomo'ivini vakadihojai jaharini. Ibavi Jaharika'oakia nahina jahariki-ra vagathanivini oana'ba'diki bana.” Niki bana ida Deus a'onira vara ni'avini hiki bana. ");
INSERT INTO padNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Vajorami kamaodorohaki fori avihiki a'oni! Avakadiva'ibodivarani hiki ida jiniro ka'oa. Avakadi'ojomo'ihi athini hida: “Deu-ra khai vani'avini kagorani onini ija'aria bidionivini hoariha biogaja kaimoni ida kidivarani ka'oa hini, ni-makhaniki ida hoariha-ra nava'iponi'imarinivini. Deu-ra khai vani'avini kagorani bodinia hojaki ida jiniro. Deua binakaidivaki ida jiniro ija'aria vakanava'igavini hiki. Ija'aria bidionihi ida jiniro onini, hoariha biogaja kaimoni ida kidivarani ka'oa hini, ni-jahaki ida hoariha-ra nava'iponi'imarinivini.” Avakhani'badaraki a'oni. ");
INSERT INTO padNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Avava'ihariki fori avihiki a'oni. Avakamaodorohaki fori avihiki a'oni jaboni. Asohirihi ida avakadi'ojomo'ihi kavaranihi. Nahina ida Deua binakaidivaja? Deua binakaidivavini arafiaki ida gora ija'ari Deu-ra khai vani'avini. Deua binakaidiva'bamakhamaki ida khai ani'avini kagorani, jiniro gora bodinia hojaki jaboni. Ni-nahina kaimoni ija'aria bidioniki ida jiniro onini, gora onini hiki. Ni-Deua binofiki ida hoariha-ra anava'iponi'imarinivini. ");
INSERT INTO padNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Avakadi'ojomo'ihi athini hoariha hida: “Ija'aria bidionihi ida Deu-ra kanava'igavini igitha abononi aha'dini ibavini onini ija'ari hoariha biogaja kaimoni ida kidivarani ka'oa hini, ni-makhaniki ida hoariha-ra nava'iponi'imarinivini. Deu-ra kanava'igavini ibavini namania hojaki ida igitha abononi aha'diki. Ija'aria bidioniki ida igitha abononi aha'diki onini, ni-jahaki ida hoariha-ra nava'iponi'imarinivini.” Avakhani 'badaraki a'oni. ");
INSERT INTO padNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Vajorami kamaodorohaki fori avihiki a'oni! Deua binakaidivavini arafiaki ida kanava'igana ibavini. Deua binakaidiva'bamakhamaki ida kanava'igana ibavini, igitha abononi aha'diki hiki jaboni. Ni-nahina-ra kaimoni ija'aria bidioniki ida igitha abononi aha'diki onini, kanava'igana ibavini onini hiki. Ni-Deua binofiki ida hoariha-ra anava'iponi'imarinivini. ");
INSERT INTO padNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Oniania ija'aria bidioniki ida Deus kanava'igana ibavini onini, hoariha biogaja kaimoni ida kidivarani ka'oa hini, vara bivani'aki jaboni ida nahina hahavi Deus kanava'igana ibavini namania hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ija'aria bidioniki ida Deu-ra khai vani'avini kagorani onini, hoariha biogaja kaimoni ida kidivarani ka'oa hini, vara bivani'aki jaboni ada Deus gora bodinia hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ija'aria bidioniki ida nama onini, hoariha biogaja kaimoni ida kidivarani ka'oa hini, vara bivani'aki jaboni ida Deus kavithi ibavini, vara bivani'ara jaboni ada Deus kavithi ibavini namania vithiki. ");
INSERT INTO padNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini. Farisio, mitha vani'a jaboni hida a'onira vara oni'avini. Deus athi-ra avanofivini-ra avakahi'badaraki a'oni! Jahariki ida avakadimoni bana! Avanajoroniki ida nahina hahavi avagahinani hiki, avanapitahataha'iki ida sa'ai ko'bamihani hini. Kaidivarini kaba'i ida 'bai kakabodihini afani, chá afani hiki avanapitahataha'iki jaboni. Deus kava'isohihi jiriki pitani-ra avanaabavini kaba'i, ni-avanaabaki ida va'isohihi jiriki hahavi. Deua binofiki ida hojai asohikia avakahojaini. Binofiki jaboni ida ija'ari vahoariha-ra va'ora avanakaidivavini. Binofiki jaboni ida athi avanaabajahakivini. Nimania ida hojai binofikia avakahojaini. Jahaki ida avakadinahina pitania Deu-ra avano'avini. Jahani arafiaki ida hahavi Deua binofiki-ra avanaabavini. ");
INSERT INTO padNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vajorami kamaodorohaki fori avihiki a'oni! Avanofivini kaba'i ida Deus kava'isohihi jiriki pitani pa'itxi-ra avanaabavini, ni-avavamakhaniki ida hojai jahaki pitani karaho-ra avaragarivini. ");
INSERT INTO padNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini. Farisio, mitha vani'a jaboni hida a'onira vara oni'avini. Deus athi-ra avanofivini-ra avakahi'badaraki a'oni. Jahariki bana ida avakadimoni. Ija'ari prato-ra sokojahakiriki fori avihiki a'oni. Visokohi ida copo, prato hiki namanija, ni-bodinija avisokoki. Jahahi ida avanokiani. Copo, prato hiki bodini sokoariki fori hiki ida nahina jahariki avava'ini bodinia ahojaki. Vahoariha vakadinahina-ra avanofivini mani ida avisaaribakhiavini hija. Avanofivini arafiaki ida avakadinahina a'ba'dini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Vara oni'aki ada farisio. Kamaodorohaki fori ihiki i! Iani'imidia ida nahina jahariki ahojaki iva'ini bodinia. Aniani naothinia, sohiki jaboni bana ida kadahojai ija'aria vanokiki. ");
INSERT INTO padNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini. Farisio, mitha vani'a jaboni hida a'onira vara oni'avini. Deus athi-ra avanofivini-ra avakahi'badaraki a'oni! Jahariki bana ida avakadimoni. A'onivani aba'oi ka'damahani ibavini fori avihiki a'oni. Ija'aria vanavaforiki ida ibavi namanija, jahaja kaimoni ida nokiani. Aba'oi ka'damahani ibavinia hojaki imai 'bathani, jaroi hiki. ");
INSERT INTO padNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jahaki ida avakadihojai nokiani. Ija'aria ni-vanokiki ida avava'ini bodini. Ni-vanokiki ida korijanahi kavaranihi, hojai asohiriki hiki avava'ini bodinia hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Asia vara niha ada Jesus: —Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini. Farisio, mitha vani'a jaboni hida a'onira vara oni'avini. Deus athi-ra avanofivini-ra avakahi'badaraki a'oni! Jahariki ida avakadimoni bana. Avakanajahaki ida afohanana Deus athi namoniva abono kohana vaka'damana kanamani, kajahaja kaimoni ida 'dama kanamani. Avanaibaviki ida ja'di karaho ija'ari vajahaki kohana vaka'damana 'da'dini a'ani namania, va'ora avakava'ihokira kaimoni. Avanajahaki jaboni ida ja'di. ");
INSERT INTO padNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Avakhanihi: “Akadi'arahoda avikhananavaki vahokina kari arihokija vaha; ni-vakadibadania akabadaniki vaha; ni-va'ora anaabiniki vaha adani Deus athi namoniva abono kohana afohanana.” Nimania ida avaathini. ");
INSERT INTO padNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ija'ari Deus athi namoniva abono-ra naabiniki kaija'ari vanamitharonisiagaki a'oni avakahiki a'oni. ");
INSERT INTO padNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Asia mani avakadija'ari avikhananavaki vakadibadania avakabadaniha'oadahaja. Avana'diahiki ida badani vanakama'daki. ");
INSERT INTO padNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Makha 'banana fori avihiki a'oni, ija'ari-ra avanapohimajavini. Avakadihojai makha kahojai fori hi'oamanija! Ni-nihanikia avaabononi avarakava'ijoaki bana. Deus a'onira karonaki bana a'oni Ibavi Jaharika'oakia avarikhani. ");
INSERT INTO padNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","A'onira onava'isohijoraki bana a'oni. Va'ora okaronahananaki bana adani Deus athi namoniva abono, ija'ari avigahaki, ija'ari vaka'ojomo'iva vihiki jaboni avakadiania. Va'ora avagathihananaki bana adani, va'ora avanaabiniki adani vahoarahanana, ava akasanakhamaki kania va'ora avaraka'itapoamisahananaki adani vahoariha, va'ora avidafiaki adani vahoariha. Akadija'ari Deu-ra vara avani'avini kagorani bodinia va'ora avanajaharihariki bana adani vahoariha sidaji ipohikia avigaonanibakhiana ava'aihotara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nimania bana ida Jahari kabadania avakabadanini. Oniani ida Deus kaija'ari hahavi kidai vihiki vaabinina abosini-ra avagathanivini hija bana. Avakadi'arahoda avikhananavaki va'ora vanaabinihananaki adani ija'ari vaipohiki hojai jahakia vakahojaiki. Hojai jahakia kahojaina kaba'i ada Abel, ovari miro'a vanaabini'iki ada. Badara ipohiki radahani naothinia, vakadija'ari vikharonisiagakia vanaabini'aha ada Zacarias kohana jaboni. Baraquias kohana kaisai ada. Deus athi namoniva abono ada Zacarias. Igitha aha'dini ibavini, Ibavi Katokini Jahaka'oakia kahararakhamania vanaabini'iki ada. ");
INSERT INTO padNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ka'oa hiki hida kodivarani. Deus jaharikia va'ora arakhaki bana adani ija'ari hidakaba'i vahokiki. Vakadihojai jahariki, vakadija'ari avikhananavaki kahojai jahariki hiki abosini ida nahina jaharikia vagahinana bana. ");
INSERT INTO padNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Hari. Kidivarani anokhomi'aha ada Jesus, va'ora ni'a'aha: —Jerusalém sidaji kaija'arini! Va'ora avanaabinibakhiaki adani Deus athi namoniva abono. Ja'dia va'ora avanagahabakhiaki adani athi avikhava abono Deus va'ora karona'iki avakadiania. Kaba'i, a'onira onakaidivaki ho. Onofiki ida a'onira oakava'ijoavini. Arakava kidisai-ra bihini nabo'ania najoroniki fori a'onira onihavini-ra onofibakhiahi, ni-avanofipa'itxiki! ");
INSERT INTO padNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A'onira oakava'ijoavini-ra avanofiravini mani ida Deus avakadisidaji-ra kava'ipahinivini hija bana. ");
INSERT INTO padNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka'oa hiki hida kodivarani, Jerusalém sidaji kaija'arini a'onira vara oni'avini hiki. Ni-jorakia okha'ianaki bana ho avakadiania. Hora vanoki'ianavini kamahini Jerusalém sidaji kaija'arini hora vanofiki adani, vara vavani'aki bana hida varani ohina: “Khaki ada ovari Deua bikaronaki ija'ari-ra vaka'da'dira kaimoni. Deua bikajoamoraki bana ada khaki.” Niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hari. Deu-ra khai vani'avini kagorani kavasiribanini bodinia okhaonani'aha ada Jesus. Ajihina kaba'i kidipohia vanamaakari'aha ada Jesus, vani'aha: —Jesus, vada ini'a oni Deu-ra khai ani'avini kagorani, jahaki ida nokiani — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Oniaroa, Jesus va'ora ni'aha: —Avanokiki ida gora karaho jahaki. A'onira onava'isohiki bana ho. Deu-ra vanofiriki vania bana vanihimaka'oaja ida Deu-ra khai ani'avini kagorani. Ja'di na'bahaki-ra vanathararavini kamahini, ni-hojajanaki ida ja'di hoarani, ja'di hoariha namania — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hari. Monte das Oliveiras arabo namahikia avigaimori'aha. Vithi'aha ada Jesus. Vahoariha vahojarina kaba'i Jesu-ra vanamaakari'aha adani ipohina, vanana'dohi'aha: —Jesus, mahi nihaforija vani vanihimaki ida Deu-ra khai ani'avini kagorani? Nihanikia bana aogaja ida ijoini kamahini amaakarini? Nihanikia bana aogaja jaboni ida nama, arabo hahavi hiki ihimini kamahini amaakarini? — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Oniaroa, Jesua bigathanihi ida vaathi: —Avaabononi avakava'igairi'a bana! Vahoariha a'onira vakorijanahavini-ra bana vanofiki a'oni. Vakajari'da bana ida vaathi. ");
INSERT INTO padNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vikhaki bana adani korijanahi abono, vakhaniki bana adani afohanana: “Hovani Cristo ho. Deus hora karona'iki avakadika'da'di ohina kaimoni.” Vakhaninanaki bana adani afo'badara. Ija'ari vaipohikia vakajari'darihi bana ida vakadikorijanahi. ");
INSERT INTO padNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Avakamithaki bana ida ija'ari vaabono vakodakhamavini kavaranihi. Ibavi maakariki, napaja hikia, ija'ari vaabono vakodakhamaki bana. Varani vihina avakamithavini kamahini, hari'a vaofini! Vaabono vakodakhama'imidiaki adani ija'ari, ni-vaihimi'iaki kaho adani arabo hahavi kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Arabo kahijava va'ora vidaki bana adani arabo hoariha kahijava. Arabo kaka'da'dini kidisorara khama va'ora vidaki adani arabo hoariha kaka'da'dini kaija'arini. Ibavi ipohikia ho'doho'doki bana ida arabo afobakhia. Mahi ipohikia ija'aria vakainamoki bana ida vakadi'bai. ");
INSERT INTO padNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Namithani kamahini ida a'onira onava'isohivini hiki, avarigaki bana ida mahi jaharika'oani kama'dani. Pa'itxi ida gamo ka'banarahi kama'dani, naothinia karahoki ida gamo imani 'banani. Onivani fori hija bana ida ija'ari vapohimaja'ina kamahini vara a'onira oni'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hari. Naothinia hora vavajahariki a'onira vagathiki bana jaboni a'oni avahoarahanana, a'onira avarakhaki bana adani vahoariha vakadiania, a'onira vanaima'banara kaimoni. A'onira vanaabiniki bana adani. Oipohina avihini mani ida hora vavajahariki arabo hahavi vahojaki a'onira vavajaharivini hija jaboni bana. ");
INSERT INTO padNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kodivarani namithani kamahini kodija'ari vaipohiki hora vakava'ipahiniki bana. Kodija'ari vihijanariki va'ora avarakhaki bana adani hora vanofijahakiki, vahoariha va'ora vanaabinira kaimoni. Ni-vaabono vakaimajahakhamapa'itxiki adani hora vakava'ipahini'iki. ");
INSERT INTO padNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Oniaroa, ibavi ipohikia ija'ari Deus athi namoniva abono vihina-ra vakahi'badaraki bana adani. Vahoariha vaipohikia vakajari'darihi bana ida vakadikorijanahi athini. ");
INSERT INTO padNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aipohiki bana ida Jahari kabadania ija'ari vakabadanibakhiana ibavi hahavia, oniani ida kodija'ari ipohiki vaabono vakanofikhamajahakijanaravini hija bana. ");
INSERT INTO padNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Avaabinirini oadani oipohina avihini-ra avakajonirihi; Deus a'onira va'adiki bana a'oni, kidiania avarikhaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hari. Arabo hahavi kaija'arinia vakamithaki bana ida omonina jahaki, avarigaja kaimoni ida ka'oa hini vakadika'da'di ohina. Oniaro, naothinia khaki bana ida mahi nama, arabo hahavi hiki ihimini kamahini. ");
INSERT INTO padNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Hari. Asia vara ni'aha ada Jesus: —Avanokiki bana ida nahina jaharika'oaki ija'aria vakaimajahapa'itxiriki Deu-ra khai vani'avini kagorani bodinia. A'onivani vada avani'a'iki hida papira, vakava'ihoki bana ida Daniel kohana kava'isohihi. Deus athi kapapirania hojaki ida Daniel kohana kava'isohihi. Ovaria vara bivani'aja hida hihida pohimajahi ija'ari-ra naimahidaki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nokiani kamahini ida pohimajahi, avigajoraki bana! Judéia kaarabonia avahojahi; arabo namahikia avigajoraki bana! ");
INSERT INTO padNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gora 'da'dini a'ani kavasiribaninia avarakoirihi; avigarijoraki bana! Hari'a avi'oi avagorania, avakadinahina-ra avaranikhavini. ");
INSERT INTO padNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Siroia bada avakhanihi; avigajoraki bana! Hari'a avakadimakari-ra avanikha avagorania. ");
INSERT INTO padNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ija'ari avigana kamahini jahariki ida vakajahavidoki vakadimoni. Jahariki jaboni ida vaisapa'itxiki vakadimoni. Ni-vakaabokaki ida va'ora vavaki'darahavini. ");
INSERT INTO padNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Deu-ra vara vani'a mahija pahisiriki kamasikoni namitharavini hida avigana kamahini. Deu-ra vara vani'a mahija aakoirina kamahini namitharavini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ojoina kamahini maakarini viahania, ija'ari hahavia vaimahidakarahoki, vava'i soko ini'ahapikini arafiaki. Jahari'oamanija ida mahi jaharini arafiaki. Deus hahavi-ra namonahavini naothinia ni-ija'aria vakamitha'iaki kaho ida vava'i soko ini'ahapikini arafiaki ibavi hahavia vahojaki. Ojoina kamahini naothinia ija'aria ni-vakamitha'ianaki ida vava'i soko ini'ahapikini arafiaki afojana ojoina kamahini viahani fori hiki. ");
INSERT INTO padNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Deua binaipohirihi bana ida mahi vaimana 'banani arafiani-ra vakamithavini kaimoni, vaihimihahavirara kaimoni adani ija'ari. Deus va'ora kakodiaki adani kidija'ari va'ora nagathogatho'iki. Va'ora va'adivini mani ida imai 'banani arafiani kamahini Deua binaipohiravini hija bana. ");
INSERT INTO padNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ija'ari vahabini a'onira ni'aki bana a'oni: “Vada vani'a hada vani Cristo.” Nihi ida ija'ari. Athini vakajari'da bana. Hoariha vahabini a'onira ni'aki bana a'oni: “Vada vani'a Cristo ada.” Vakhaniha. Athini vakajari'da bana jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vikhaki bana adani ija'ari a'onira vakorijanahaki kaimoni. Vahoarahanana vaabono vani'a'badaravini: “Hovani Cristo ho. Deus hora karonaki ho.” Vahoariha vaabono vani'a'badaravini: “Hovani Deus athi namoniva abono ho.” Vakhaninanaha. Vakaabokaki bana ida badani danoki, kodibadani danoki fori hiki. Vanofiki ida ija'ari hahavi-ra vakorijanahavini. Vakaabokaravini kaba'i, vakaijo'aki ida ija'ari Deua binagathogatho'iki-ra vakorijanahavini, Deu-ra vanofijanarara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mitha vani'a hida a'onira onava'isohijoravini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ija'ari vahabini a'onira ni'aki bana a'oni: “Vavanavanaha amasia hojaki ada Cristo.” Hari'a bana avikha'a amasia. Ija'ari vahabini a'onira ni'aki bana a'oni: “Vada vani'a hada ahojaha Cristo.” Nihi ida ija'ari. Vaathi vakajari'da bana. ");
INSERT INTO padNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hovani ija'ari hahavi vakadi'aajo ho. Bahi korikorihana nama hahavi-ra navagajorakivini vani fori hiki ida ojoina. ");
INSERT INTO padNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ija'ari hahavi ojoina-ra vanokivini kamahini avigaki ida hana ohojana. Ija'ari majori vajoronina-ra vanokivini vani, avigaki ida aba'oi 'bathaki hana hojani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hari. Asia vara ni'aha ada Jesus: —Imai 'banani arafiaki kamahini naothinia, mokhiniki bana ada safini. Ni-vagaki ada masiko jaboni, vorovorohananaki bana ada boviri. Deua binaho'doho'doki ida nama vaaniara kaimoni adani ka'da'di danoki nama vahojaki. ");
INSERT INTO padNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oniaroa, ija'ari hahavia vanokiki bana ida ojoina karajomini nama nokiani. Vabarariariaki bana adani arabo hahavi kaija'arini. Vanokiki bana ida ojoirarina bahi vaforiki hararana. Vanokiki jaboni ida bana ojahana odanona ovagana ija'ari hahavi vakadi'aajo ohina. ");
INSERT INTO padNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ojoina kamahini ija'aria vakamithaki bana ida trombeta ithoni, rabojahavahaki ida trombeta. Oniaroa, Deus va'ora karonaki bana adani ibavi kaija'arini ibavi hahavia, arabo hahavia avikhana, va'ora vanajoronihahavira kaimoni adani ija'ari Deus va'ora nagathogatho'iki kidiania. ");
INSERT INTO padNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hari. Asia vara ni'aha ada Jesus: —Okavarajomiki ida ojoina kamahini figira avani afani aja'dini fori hini. Avanokihi ida afani aja'dinani, avarigahi ida amoroki amaakarini. ");
INSERT INTO padNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Onivani fori hija ida ojoina viahani karajomini. Namitha'ihi ida vara a'onira oni'avini hi'iki, ojoina amaakarini-ra avarigahi. ");
INSERT INTO padNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka'oa oamani ida oni'aki. Vaabinirina oadani adani ija'ari rajomi-ra vanokiki, namithahahaviki bana ida a'onira oni'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ihimiki bana ida arabo hahavi, nama hiki jaboni. Namithaki hida oathi a'onira oni'avini hiki. Mahi hahavi anokhomiriki hida oathi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Hari. Asia vara ni'aha ada Jesus: —Ija'aria ni-avigaki ida ojoina kamahini. Deus ibavi kaija'arinia avigarihi jaboni ida ojoina kamahini. Hovani, Deus kaisai ohina kaba'i, ni-oogaki ida ojoina kamahini. Kodiabi'i ka'oa vania biogaja ida. ");
INSERT INTO padNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ojoina kamahini fori hiki ida namitha'iki Noé kohana hokina kari. ");
INSERT INTO padNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Arabo hahavi kapahani viahania, Noé ava'doroa avi'oirina oadani, ni-ija'aria vakava'ibodivaranipa'itxiki ada Deus. Ni-vanofiki ida Deus athi-ra vanaabavini. Vakava'ibodivaraniha'oadahaki ida vakadimahi, vakadi'bai, makhira gamo khama avaakarana. ");
INSERT INTO padNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ija'aria ni-avigaki kaho ida nahina namithaki kaimoni. Noé ava'doroa avi'oina naothinia, Deua bikarona'iki ida paha karaho, avahidahahavi'iki adani ija'ari. Onivani fori hija bana ida ojoina kamahini, vava'i kadihini hini. ");
INSERT INTO padNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Onokiana kamahini, makhira vi'bamiki bada vakhaniki bana vakadisiroia. Deua bianiha bana ada hoarana. Hojaroniki bana ada hoariha. ");
INSERT INTO padNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Gamo vi'bamiki vako'baihaki adani. Deua bianihi ida hoarani. Hojaroniki bana ida hoariha. ");
INSERT INTO padNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Avakadika'da'di ohiki ho. Ni-avarigaki ida ojoina kamahini, oniani ida mahi, joma hahavia hora avanokhavini-ra ohonariavini hija. ");
INSERT INTO padNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","A'onira onava'isohivini hiki. Kabo'dinofiki kaikahina-ra ogajorara vaha ada goraki; binaviahanokhamaniha vaha; ni-biva'ahaki ida bo'di abonoa gorana bianahoroavini. ");
INSERT INTO padNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Avakhanini vani a'onira ohonariaja hora avanokhahaha'oadahavini. Ija'ari hora vanaviahanokharavini kamahini vani ojoija bana. ");
INSERT INTO padNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Hari. Asia vara ni'aha ada Jesus: —A'onivani honai abono jahaki fori vihi'a bana. Hovani honai abono kaka'da'di fori ohiki ho. Vara a'onira oni'avini hiki bana ada honai abono ogahaki, kidika'da'di athi-ra naabaki ada. Kidika'da'dia bihonariaha: “Iakadava'a bana hida ogorana. Va'ora no'a bana adani kodihonai abono vahoariha vakadi'baia mahi hahavi.” Niha ada ka'da'di. Ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hari. Ka'da'di athi-ra naabahaha'oadahaha; ka'da'di joina kamahini, jahaki ada honai abono kidimoni hina. ");
INSERT INTO padNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ka'oa hiki hida kodivarani. Ka'da'dia bini'aki bana ada kidihonai abono: “Inaabajahaki'iki ida ira ohonariavini hi'iki, oniani ida kodinahina hahavi, ogorana, arabo hiki-ra iakadava'avini maina ira ohonariavini hija.” Niha ada ka'da'di. Onivani fori hija bana hida vara a'onira oni'avini hiki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hari'a bana honai abono jahariki fori vihi'a! Ni-kidika'da'di athi-ra naabaki. Abono-ra ni'aha ada honai abono: “Agathinahaki ada kodika'da'di.” Niha ada honai abono. ");
INSERT INTO padNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Oniani ida honai abono vahoariha-ra va'ora dafiabakhiavini hija. Honai abono ko'bainofiki, kakavinofiki jaboni afobakhia, makhira vahoariha vakahanobakhiaki vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oniaroa, joi'aha ada ka'da'di. Ni-kidihonai abonoa binokhajanaki ida joina, ni-biogaki ida joina kamahini. ");
INSERT INTO padNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hari. Jaharikia ka'da'dia biarakha'aha ada honai abono, binaima'banakarahoki bana ada. Nimania ida honai abono kidika'da'di kabadania kabadani'badarana abosini. Kidihojai jahariki abosini fori hiki ida vahoariha vajahana-ra vakahi'badaravini abosini Ibavi Jaharika'oakia. Abarariariaki bana ada, kanada kakiroromisiki jaboni bana ada — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hari. Vara ni'ianaha ada Jesus: —Deus ija'ari-ra vaka'da'divini kamahini fori hiki ida namithaki bana ima'inavi sa'ai ko'bamihani vihiki vakadiania. Kodija'ari fori vihiki adani ima'inavi. Hovani maisa fori ohiki ho. Ima'inavia avikhahi ida vakadilamparina; maisa-ra vakaragararihara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sa'ai kahoarani vihiki avigahariki adani. Vahoariha sa'ai kahoarani vihiki avigahaki. ");
INSERT INTO padNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ima'inavi avigahariki avavikhaki ida vakadilamparina, ni-avavikhaki ida basina vakadilamparina-ra vanadai'ianavini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Vahoariha vani adani basina-ra avakavikhaha. Aforahi ida vakadilamparina vanadai'ianaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hari. Ni-khajorakiki ada maisa. Vanaviahanokhavini oadani vanoko'isihahavi'aha adani ima'inavi, vavadi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Joma jararini vani kaikahi'aha ada maisa, vakamitha'ihi ida bodi'barahi: “Maisa hada kaikahi'ara. Avikha'a kidiania mahija avakaragararivini.” ");
INSERT INTO padNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Oniaroa, vanokho'afora'aha adani ima'inavi hahavi, vakadilamparina-ra avanaha'di'aha. ");
INSERT INTO padNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hari. Ima'inavi vava'ihariki fori vihiki va'ora vani'aha adani vahoariha: “Haria vano'a avakadibasina kapa'itxia, daijanarinia binamokhiha'iki hida akadilamparina.” ");
INSERT INTO padNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Vahoariha vakabasinakia vagathani'ihi ida vaathi: “Iniani, basina kapa'itxi oavani hida akavahojaja, ni-arajomaki avakadimoni bana. Basina-ra avanofihi, vakapavakariha.” ");
INSERT INTO padNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Oniaroa, ima'inavi vava'ihariki fori vihiki ai vihi'aha, basina-ra vakapavakariha'avini. Vakapavakarihana kaba'i vani, kaikahi'aha ada maisa. Hi'adani ima'inavi vakabasinaki vanaviahanokhaki ada maisa, avi'oi'aha kidiania akarai kaihinikani kania. Oniaroa, akarai kaihinikani kaka'da'dinia bivahonariahihi ida bakatha ka'boni avi'oijanarara kaimoni adani ija'ari vakaikahi'iariki. ");
INSERT INTO padNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hari. Mitihini vani vakaikahi'aha adani ima'inavi vava'ihariki fori vihiki vabodi'baraha'aha: “Akadika'da'di, avakarabikhai bana hida bakatha, ao'oina-ra anofiki hari jaboni.” ");
INSERT INTO padNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Maisa bigathani'ihi ida vaathi: “Ni-a'onira oogaki.” ");
INSERT INTO padNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hari hi'ihi ida Jesus rajomi kavaranina va'ora ni'a'aha: —Avaabononi avakava'igairi bana! Ni-avarigaki ida mahi hana hini ojoina kamahini, oniaroa a'onira ohonariavini hora avanokhavini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Hari. Asia vara ni'aha ada Jesus: —Vara a'onira oni'avini hiki bana ida niha ninini va'ora onaabosiki adani va'ora ovaka'da'diki vakadibadani. Oabono okavarajomivini bana ada ka'da'di. Napaja adahaki ada ka'da'di. Ajihina viahania va'ora baranaha'aha adani kidihonai abono, va'ora honariavini hiki ida kidijiniro, kidiarabo, gorana hiki-ra avakadava'avini. ");
INSERT INTO padNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka'da'dia binofiki ida kidijiniro avana'ba'divini, oniani ida jiniroa va'ora no'avini hija. Ka'da'di va'ora kava'ibodivarani'imidiaha adani kidihonai abono, hana hina biogavini ida jiniro karaho akadava'ania kabadanina, hana hina biogavini ida jiniro doroniki akadava'ania kabadanina, hana hina biogavini ida jiniro pa'itxi akadava'ania kabadanina. 5 mil jiniro 'ba'dania bino'aki ada honai abono hoariha. 2 mil jiniro 'ba'dani bino'aki ada honai abono hoariha. 1 mil jiniro 'ba'dani bino'aki ada honai abono hoariha. Jiniroa va'ora no'avini naothinia ajihi'aha ada ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ajihi'aha ada honai abono 5 mil jiniro 'ba'dani-ra gathani'iki. Bada nina vani biana'ba'dija ida jiniro, bigathaniki ida 5 mil jiniro 'ba'dani hoariha. ");
INSERT INTO padNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Onivani fori hiki ada honai abono 2 mil jiniro 'ba'dani-ra gathaniki. Bada nina vani bigathaniki ida 2 mil jiniro 'ba'dani hoariha. ");
INSERT INTO padNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Honai abono hoariha bigathaniki ida 1 mil jiniro 'ba'dani, okhaonani'aha, bikhori'ihi ida nami, bianahoja'ihi ida kidika'da'di kajiniro. ");
INSERT INTO padNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hari. Radaha'aha ada masiko ipohiki, oniania joi'aha ada vakadika'da'di. Va'ora baranaha'ianaha adani kidihonai abono, biogaja kaimoni ida kidijiniro avakadava'aki. ");
INSERT INTO padNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ovari miro'a o'oi'aha ada honai abono 5 mil jiniro 'ba'dani-ra gathani'iki. Biarakha'ihi ida jiniro 'ba'dani kidika'da'di kania bini'a'aha: “Hora ino'avini hi'iki hida 5 mil jiniro 'ba'dani. Bada onina vani oana'ba'di'ia hida jiniro. 10 mil hiki hida ipohini ovahoja'iki.” ");
INSERT INTO padNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Oniaroa, kidika'da'dia bini'aha: “Ivani honai abono jahaki i. Iakadava'ajahakiki hida ira ono'avini hi'iki. Jiniro pa'itxi-ra iakadava'ajahakivini mani ida kodinahina karaho-ra iakadava'avini maina-ra ovahonariahivini hija bana. Khai ini'a kodiania! Kodibadania ikabadanijahakini mani ida kodinahina-ra akavapitavini hija.” ");
INSERT INTO padNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hari. Ovari maina o'oi'aha ada honai abono 2 mil jiniro 'ba'dani-ra gathani'iki. Biarakha'ihi ida jiniro 'ba'dani kidika'da'di kania, bini'a'aha: “Hora ino'avini hi'iki hida 2 mil jiniro 'ba'dani. Bada onina vani oana'ba'di'ia hida jiniro. 4 mil hiki hida ipohini ovahoja'iki.” ");
INSERT INTO padNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Oniaroa, kidika'da'dia bini'aha: “Ivani honai abono jahaki i. Iakadava'ajahakiki hida ira ono'avini hi'iki. Jiniro pa'itxi-ra iakadava'ajahakivini mani ida kodinahina karaho-ra iakadava'avini maina-ra ovahonariahivini hija bana. Khai ini'a kodiania! Kodibadania ikabadanijahakini mani ida kodinahina-ra akavapitavini hija.” ");
INSERT INTO padNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hari. Ovari maina o'oi'aha ada honai abono 1 mil jiniro 'ba'dani-ra gathani'iki, bini'aha ada kidika'da'di: “Ira oogaki ho. Ka'da'di ihini mani ida ija'ari iathini-ra naabaravini-ra iva'aharavini hija. Va'ora ihonariaki adani kadahonai abono varakhajahana kadaimoni, a'ba'dija kaimoni ida kadanahina. Va'ora ihonariaki adani jaboni rakhajahi bononi-ra vanajoroniki, vanaji'binija kaimoni ida kadatrigo kagorani. Kadaimoni ida vakadibadani, ni-a'ba'dipa'itxiki ida kadahonai abono vakadinahina. ");
INSERT INTO padNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ira ofini'avini mani ida nami bodinia kadajiniro-ra oanahojahavini hi'ia. Vada ini'a, hida vani kadajiniro.” ");
INSERT INTO padNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hari. Ka'da'dia bigathanihi ida honai abono athi: “Honai abono jahariki oamani i! Ikajoniaha'oamanija! Ikava'ibodivaraniki ida avakadibadani abani kodimoni hini, a'ba'dija kaimoni ida kodinahina. ");
INSERT INTO padNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nimania ida hora ikava'ibodivaranivini, jahaja vaha ida kodijiniro-ra iana'ba'divini-ra ikaijo'avini. Jahaja vaha ida kodijiniro-ra iarakhavini sidaji kajinironi-ra avakadava'aki vakadiania; okaikahina kodijiniro-ra vanajoiha; hora vano'avini hiki vaha jaboni ida vakadirihai abosini. Nahina mani ida va'ora ikanarihairavini hija?” Niha ada ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","30","Roiribani'aha, va'ora ni'aha adani kidihonai abono vahoariha: “Visaari oni 1 mil jiniro 'ba'dani bivahoja'iki! Kodihonai abono 10 mil jiniro 'ba'dani-ra vahojaki-ra vano'a bana jiniro avisaari'ikia. Vanahokahi'a bana ada honai abono bakibakini kania. Bakibakinia abarariariaki bana ada, kanada kakiroromisiki bana ada. Ni-nahina jahaki kabadaniriha ada.” Niha ada ka'da'di. Deua bino'aki ida kidinahina ija'aria biakadava'aja kaimoni. Biakadava'ajahakihi; Deua bianaipohihi ida nahina biakadava'aki. Ija'aria biakadava'ajahakirihi ida nahina pa'itxi Deua bino'avini hiki, Deua bianiki bana ida nahina pa'itxi bivahojaki — va'ora ni'a'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Hari. Jesus va'ora ni'aha: —Hovani ija'ari hahavi vakadi'aajo ho. Okha'ianana kamahini ka'da'di ohiki bana ho, ija'ari hahavi-ra ohonariaja kaimoni. Okhana kamahini Deus ibavi kaija'arini hora vavaipohihaki bana. Ka'da'di kavithi ibavinia ovithiki bana ho. ");
INSERT INTO padNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Oviaha vajoroniki bana adani arabo hahavi kaija'arini. Ovilia akadava'ava abono fori ohiki ho. Ovilia akadava'ava abono va'ora kanapitakhamavini adani ovilia, boji vihiki. Va'ora nahojaki adani ovilia pitana aniaja, va'ora nahojaki adani boji pitana jasoja. Onivani fori va'ora onihara bana adani ija'ari va'ora onasohivini. Ija'ari vahoariha opitana aniaja vahojaki. Ija'ari vahoariha opitana jasoja vahojaki. ");
INSERT INTO padNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oniaroa, vakadika'da'di ohi'ina vani, va'ora oni'aki bana adani opitana aniaja vahojaki: “Hojai jahakia avakahojaiki a'oni. Kodiabi'i a'onira kajoamoraki a'oni. Vikha'a mahija avagathanivini ida kodiabi'i a'onira kaibavijahahivini hi'iki, ka'da'di avihiki bana a'oni. Arabo amonahani viahania binaibavijaha'iki ida. ");
INSERT INTO padNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ovai'amina, 'baia hora avano'a'iki a'oni. Okanabidi akaaforani, paha hora avano'a'iki a'oni. Avakadija'ari ohirina kaba'i, hora avagathanijahaki'iki a'oni avagorania. ");
INSERT INTO padNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Okamakaririna, hora avano'a'iki a'oni makaria okaimahaki kaimoni. Okavamonina, hora avakajoamoraki a'oni. Cadeia ohojana, hora avanavanavanaha'iki a'oni.” Oni'aki bana ida ija'ari opitana aniaja hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ija'ari hojai jahakia vakahojaiki oathi-ra vagathaniki bana: “Mahi nihaforija koda ira akajoamora'ia? Mahi nihaforija ivai'amini ira ano'aja 'baia? Ni-akava'ihoki'iki ida ikanabidini akaafora'ini paha ira ano'avini. ");
INSERT INTO padNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni-akava'ihokiki jaboni ida arabo hoariha kaija'arini ihini ira agathani'avini agorana. Ni-akava'ihoki'iki ida ikamakaririni makaria ira ano'a'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni-akava'ihoki'iki jaboni ida ikavamonini-ra anokivini. Ni-akava'ihokiki ida cadeia kabodinia ihoja'ini ira anavanavanaha'avini. Mahi nihaforija koda ira akajoamora'ia?” Hora vani'aki bana. ");
INSERT INTO padNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hari. Vakadika'da'di ohina vani, va'ora oni'aki bana adani: “A'onira onava'isohivini hiki hora avanokiravini kaba'i, oigamina hoariha kanahinariki-ra avakajoamorahi, hora avakajoamora'oamanija.” ");
INSERT INTO padNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hari. Oniaroa, va'ora oni'aki bana adani opitana jasoja vahojaki: “Avakara'o'a kodiania! Hojai jaharikia avakahojaiki a'oni. Deus a'onira vajahariki a'oni. Avikha'a Ibavi Jaharika'oaki kania, siho kaihimiriki kania. Hojaki ida Ibavi Jaharika'oaki, Jahari, kidija'ari khama vaibavi ida. ");
INSERT INTO padNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ovai'amina, ni-'baia hora avano'aki. Okanabidi akaaforani, ni-paha hora avano'aki. ");
INSERT INTO padNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Avakadija'ari ohirina kaba'i, ni-hora avagathaniki avagorania. Okamakaririna, ni-makaria hora avano'a'iki. Okavamonina, ni-hora avakajoamoraki. Cadeia ohojana, ni-hora avanavanavanaha'iki.” Va'ora oni'aki bana adani opitana jasoja vahojaki. ");
INSERT INTO padNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Oniaroa, hora vani'aki bana adani: “Mahi nihaforija koda ira anokija ivai'amini, ikanabidini akaafora'ini, akadija'ari ihirini, ikamakaririni, ikavamonini, cadeia ihoja'ini? Ni-akava'ihoki'iki ida ira anokivini. Mahi nihaforija koda ira akajoamorarija?” ");
INSERT INTO padNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Va'ora oni'aki bana adani: “A'onira onava'isohiki bana ho, oigamina vahoariha vakanahinariki-ra avakajoamorabakhiarihi; ni-hora avakajoamoraki.” Va'ora onava'isohiha. ");
INSERT INTO padNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hari hi'ihi ida Jesus kavarani, ija'ari ka'ojomo'ihia kavaranina, va'ora nava'isohivini hiki ida namitha'iariki. Jesus va'ora ni'aha: —Hojai jaharikia vakahojaiki avikhaki bana Ibavi Jaharika'oaki kania, imai 'banani ibavini kania. Vakadimahi vavahojaki idiaja ni-ihimijanaki. Hojai jahakia vakahojaiki vani adani avikha'aha bana Ibavi Jahaka'oakia. Vakadimahi vavahojaki idiaja ni-ihimijanaki. ");
INSERT INTO padNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hari hi'ihi ida Jesus kavarani ija'ari-ra va'ora ka'ojomo'ivini. Va'ora ni'aha adani kidipohi: ");
INSERT INTO padNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Avarigaki ida mahi 'bamiki radahani naothinia anamonahaki bana ida Páscoa kaihinikani. Hovani ija'ari hahavi vakadi'aajo ho. Páscoa kaihinikani amonahani vani hora avarakhaki bana adani vahoariha. Ava akasanakhamakia hora avaka'itapoamisira kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Oniaroa, Caifás gorana vajoroni'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama. Sasidotxi hahavi vakadika'da'di Caifás oniki. ");
INSERT INTO padNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Vaabono vara vakani'akhama'aha: —Ija'aria avigaravini kaba'i, agathiva ada Jesus, anaabinira kaimoni. Niha ani'a'avini agathiki koda ada? ");
INSERT INTO padNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Páscoa kaihinikani kania vajoroniki adani ija'ari vaipohiki Jesu-ra vavajahaki. Ihinika-ra anamonahavini oadani ni-Jesu-ra agathivini jahaki. Jesu-ra agathihi; haria vidaha bana adani ija'ari — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Oniaroa, Betânia ibavia hoja'aha ada Jesus. Simão hoariha gorana hoja'aha. Mahi 'bo'dakari Jesua biani'iki ida Simão kakavamoni asafi namania hojaki. ");
INSERT INTO padNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Simão gorana o'oi'ihi ida gamo, bivikhami'ihi ida misai mitxaki, kaidivani arafiaki. Ja'di vaforiki ida misai bavini hija. Abononi ni'a'ihi: —Mahi ipohijanariki bana ida Jesus abinina kamahini. Okavamisaihaki ada abinina viahania. 'Baina kaba'i ada Jesus, gamoa binamaakari'aha biahoari'ihi ida misai Jesus 'da'di a'ania. ");
INSERT INTO padNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesus ipohina vanokihi ida gamo kabadani, vaihamahi'aha, vanana'dohi'aha: —Nahina kaimoni gamoa binakavithimaki ida misai? ");
INSERT INTO padNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pavakari binihaja vaha; jiniro ahapini-ra gathanihi vaha; vakanahinariki-ra vaha va'ora no'avini himanihi vaha ida jiniro — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Oniaroa, Jesua bioga'iki ida vakadivarani nahina hini, va'ora ni'aha: —Jakana hojava kaho. Nahina kaimoni athi khanakia avani'aki hida gamo? Jahaki ida kidibadani kodimoni hini. ");
INSERT INTO padNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mahi hahavi vani vahojara adani vakanahinariki avakadiania va'ora avakajoamorara kaimoni. Ni-mahi hahavi ohojaki avakadiania hora avakajoamoraja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hora kavamisaihavini hiki oabinina viahania. Ja'di hodijama'oki bodinia oaba'ona-ra avibaivini viahani mani ida hora kavamisaihavini hija. ");
INSERT INTO padNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ka'oa oamani hida oni'aki. Arabo hahavi, ibavi hahavia ija'aria vara bivani'aki bana ida omonina jahaki, vara vavani'aki jaboni bana hida gamo kabadani jahaki. Vakava'ihokiki bana hida gamo kabadani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oniaroa, abono-ra ni'a'aha ada Jesus ipohina Judas Iscariotes oniki: —Hari. Oarakhaki bana ada Jesus sasidotxi vavaka'da'diva vasa'a kabodinia. Oniaroa, ajihi'aha, okha'aha vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Judas Iscariotes va'ora ni'aha adani sasidotxi vavaka'da'diva: —Nihafori jiniro 'ba'dania hora avano'aja bana Jesu-ra avakadiania oarakhavini abosini kaimoni? Hari. Varajoma'ihi hida 30 jiniro 'ba'dani prata amonahaki ipohini, Juda-ra vano'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ajihi'aha ada Judas, abono-ra ni'aha: —Niha oni'a'aki koda hada Jesus oarakhavini vakadiania? ");
INSERT INTO padNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hari. Oniaroa, kama'da'ihi ida judeus kaija'ari vakadihinika. Ihinika amonahani oadani pão kathoramananiriki vakahaki adani. Hari. Jesus ipohina vanamaakariha, vanana'dohi'aha: —Jesus, hanaja vania hojahi ibavi Páscoa kaihinikani ko'baini-ra anamonahavini kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesua bigathani'ihi ida vakadina'dohi: —Jerusalém sidajia avikha'a bana. Vanako'diha bana ada makhira vara oni'ajora'iki. Vani'a bana: “Jesus ira nava'isohivini hiki bana ida akadiania hojana kamahini ipohijanarini. Binofiki ida Páscoa kaihinikani ihinika ko'baini arihavini kidipohi khama igorania.” Vani'a bana. ");
INSERT INTO padNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hari. Ai vihi'aha adani Jesus ipohina, vakaraga'ihi ida makhira ibavi Jesua bini'a'iki. Vanamonaha'iki ida ihinika ko'baini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mithani vaivaini vani vakaikahi'aha adani Jesus Páscoa kaihinikani ko'baini kania. Mesa kai'oarinia vadosidosiriaha'aha, vi'baina-ra vakavahojaivini ida. Vigaakosoa'aha adani Jesus ipohina 12 vihiki. ");
INSERT INTO padNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Vi'baina kaba'i Jesua bini'a'aha: —Ka'oa oamani hida oni'aki. Hoarana avakadiania hojaki hora arakhaki bana vahoariha hora vanaabinija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Avakava'isokonivini, avigaravini ada Jesu-ra arakhaki. Vani'aha afohanana: —Jesus, vara hora ivani'amanija koda? Jokoa ira oarakharihi — vakhaninana'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus va'ora ni'aha: —Hoarana hora arakhaki ho, hi'o pão-ra oakoba'ahavini-ra ovi'bamivini hiki, hihada vani hada hora arakhara vahoariha vasa'a kabodinia, hora vanaabinira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hovani ija'ari hahavi vakadi'aajo ho. Oabiniki bana ho. Deus athi kapapirania binamonijoraki ida oabinina. Jahariki bana ida kidimoni hora arakhaki kaimoni. Deua binaima'banakarahoki bana ada Ibavi Jaharika'oakia. Namitharara vaha; ni-pohimajaki vaha — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Oniaroa, Judas Iscariotes Jesus kava'ahi 'badara bini'aha: —Jesus, vara hora ivani'amanija koda? Jokoa ira oarakharihi. Jesua bini'aha: —Ivani oa hora iarakhaja bana. ");
INSERT INTO padNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hari. Vi'baina kaba'i Jesua bikanabiini'ihi ida pão, Deu-ra ni'a'aha: —Deus, ivani ijahaki i. Pãoa haria ino'aki i — ni'aha. Vara nina naothinia, bikanapitahatahahi, kidipohi-ra va'ora no'avini kihi'ihi, va'ora ni'aha: —Vaagathani'a hida pão mahija avakahahahavivini. Oimana hida pão. ");
INSERT INTO padNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Vakahavini naothinia, copo maina-ra nabiiniha. Deu-ra vara ni'a'ianaha: —Deus, ivani ijahaki i. Vinho haria ino'aki i. Vinho kacoponi maina va'ora no'a'aha. Va'ora ni'a'aha: —Vi'avihahavi. ");
INSERT INTO padNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hihida vinho oamana hida. Oabinina kamahini oamana ahovariki bana. Oabono ova'ahaki ho oabinina, ija'ari vaipohiki-ra va'ora oakava'ijoaja kaimoni. Oamana-ra anahovariki bana vakadihojai asohiriki 'birani abosini kaimoni. Oamana ahovarini mani ida Deu-ra vakajari'daravini va'ora kapoarivini hija, kidija'ari vihira kaimoni, oniani ida kidiania va'ora arakhaja bana. Nimania ida Deus kava'iponahi a'bo'daki ja'dini. ");
INSERT INTO padNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka'oa oamani ida oni'aki. Jokoa oabinirina oadani o'avijanarihi hida vinho. Deus a'onira vaka'da'divini kamahini kidiania nama o'avi'ianaki bana ida vinho ja'dini avakadiania — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Oniaroa, vi'avivini naothinia, moro vaahia'aha Deu-ra khai vani'avini. Ai vihi'aha. Arabo namahiki monte das Oliveiras onikia avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hari. Jesus va'ora ni'a'aha adani Pedro: —Deus athi kapapirania hojaki hida athii: “Ovilia akadava'ava abono-ra onaabiniki bana ho. Avigaki bana adani ovilia.” Nihi ida athii. Hihida joma hora avanahojahaki bana a'oni afohahavi avarigani. Ovilia avigana vani fori avihija bana avarigani. ");
INSERT INTO padNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Oahokina naothinia, Galiléia kaarabonia a'onira onaviahanokhaki bana ho — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Oniaroa, Pedroa bini'aha: —Ira vanahojahavini kaba'i adani vahoariha, hovani ni-ira onahojahaki — niha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesua bini'aha ada Pedro: —Ka'oa oamani hida ira oni'avini hiki. Hihida joma arakava ahiana viahania, ivani iathini nija bana: “Jesus ipohina ohirihi.” Ahoarabakosikia oipohina ihirini-ra ikahiki bana i — Jesua bini'aha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Oniaroa, Pedro bini'aha: —Iniani, oabinihi kadania, oabinihi, jokoa iipohini ohirina-ra okahirihi — niha ada Pedro. Vahoariha vani'avini afohahavi: —Jokoa iipohini arihirina-ra akahirihi — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hari. Ai vihi'ianaha adani Jesus, Getsêmani ibavi maakariki-ra avanikhahavini. Avakhanoha, ipohina-ra va'ora ni'aha: —Onia vavithima'o, okhananavaki ho Deu-ra vara oni'aki ho. ");
INSERT INTO padNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Vavithima'ona, Jesus va'ora ni'aha adani Zebedeu kaisai vi'bamiki, Pedro jaboni: —Pedro, Tiago, João, hora vavaipohiha bana! Ai vihi'aha adani avako'bamahakhamaki. Va'i mokara nikaraho'aha ada Jesus. Va'i rogo inikarahoki ada jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Va'ora ni'aha: —Kodiva'isoko'ini karaho hora naabinikamariki ho. Hida vahoja. Vanoki bana! — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Okhananavapa'itxiha, aasiama'oha, Deu-ra vara ni'a'aha: —Kodiabi'i, oakava'isokonihi ida ija'ari hahavi vakadihojai asohirini abosini-ra ogathanivini. Nahina hahavi-ra ikaabokaki. Hora vanaima'banavini inofirihi; hora iva'adivini-ra ikaabokaki i. Hora vanaima'banavini inofihi; onofiki jaboni. Nahina-ra inofihi; onofiki jaboni — Deu-ra ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hari. Pedro vakadiania joimiha ada Jesus. Pedro vavadina-ra karagaha'aha, va'ora ni'aha: —Pedro, avavadimanija? Avanokipa'itxini-ra koda avakaabokaria? ");
INSERT INTO padNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hari'a vavadi! Deu-ra vara vani'a bana mahija Jahari athi a'onira kaboroborovini-ra avakamitharavini. Jahari kahojai-ra avanofiravini kaba'i, ni-avakaabokaki ida Jahari a'onira kaboroborovini-ra avakajonivini. ");
INSERT INTO padNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ajoimi'ianaha ada Jesus, Deu-ra vara ni'a'ianaha. Bini'aha: —Kodiabi'i, oogaki ida hora vanaima'banavini-ra inofivini, oniani ida hora vanaima'banavini-ra okapoarivini hija. Nahina-ra inofihi; onofiki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kidipohi vakadiania joimi'ianaha. Vavadi'ianana vani va'ora karaga'ianaha. Vanokho'da'bo'da'bo'ianamaniha. Ni-vakaabokaki ida vanokina. ");
INSERT INTO padNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ajoimi'ianaha ada Jesus, ahoarabakosikia Deu-ra vara ni'a'ianaha, oniani ida athi hi'ianahi. ");
INSERT INTO padNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oniaroa, kidipohi vakadiania okhami'ianaha, va'ora ni'a'aha: —Asia mani avavadija avarakoirini? Hari. Kama'da'iki ida oimana 'banani. Hovani ija'ari hahavi vakadi'aajo ho. Hoariha hora arakhaki bana ada, makhira vajahariki vasa'a kabodinia. ");
INSERT INTO padNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Vigaa'a. Ai arihi'ava. Vada vani'a o vasa'a kabodinia hora arakhaki kaikahina. ");
INSERT INTO padNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Hari. Jesus vara nina kaba'i, kaikahi'aha ada ipohina Judas Iscariotes oniki. Judas va'ora vikha'aha adani ija'ari vaipohiki vakasa'aiki. Vavikhahi ida ava, tarasara hiki, vakadisa'ai kaimoni. Sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama va'ora vakarona'aha adani vakasa'aiki Juda-ra vavaipohihara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas va'ora ni'avini vakaikahina viahania: —Hi'ada makhira oka'ivanitiki, oramosiki vani-ra vagathijahaki bana — va'ora nava'isohijoraha ada Judas. Jesu-ra vakavarajomivini hiki Juda biramosivini. ");
INSERT INTO padNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hari. Jesus vavahojaki kania vakaikahi'aha adani Judas, binamaakari'aha, bini'aha: —Aajo, ivaniti. Deus ira no'aki i va'i jahajahania. Hari. Jesu-ra ramosi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesua bini'aha ada Judas: —Judas, bada ini'ajoraki'a ida inofiki! Hari. Vakasa'aiki Jesu-ra vanamaakari'aha, vagathi'aha, vidabo'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesus ipohina hoarana bidioni'ihi ida tarasara fori hiki bavinia, binoba'aha ada sasidotxi vakadika'da'di kahonai abono, biava'boarabakosi'ihi ida morobo. ");
INSERT INTO padNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Oniaroa, Jesua bini'aha: —Inaibavijaha bana oni kadasa'ai! Ija'aria binaabinihi ida hoariha sa'aia, hoariha bikavasa'aihaki ida jaboni bana. ");
INSERT INTO padNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ikava'ibodivarani ida kodiabi'i hora akava'ijoavini-ra kaabokaravini. Deus hora akava'ijoavini-ra okanikhariaja vaha; Deus va'ora karonajorakiha vaha adani ibavi kaija'arini vaipohiki kodiania hora vaakodiara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ni-onofiki ida hora vaakodiavini. Hora vaakodiara vaha oabinirina kaimoni; ni-namithaki vaha ida Deus athi papira hojaki vara hora vani'ajoravini hi'iki. Onofiki ida Deus hora vara vani'avini namithani kodiania. ");
INSERT INTO padNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naothinia, Jesus va'ora ni'aha: —Ija'aria vavikhaki ida ava, tarasara hiki vagathira kaimoni ada kaabiniki. Onivani fori hini avavikhaja ida avakadisa'ai hora avagathija kaimoni. Okaabiniki hora avavanihamania koda? Mahi hahavi ija'ari-ra oka'ojomo'ihi Deu-ra khai ani'avini kagorani kavasiribanini bodinia, ni-hora avagathi'iki. ");
INSERT INTO padNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Namitha'iki ida Deus athi namoniva abono kohana vanajiri'bo'da'iki Deus athi kapapirania — va'ora ni'aha ada Jesus. Hari. Jesu-ra vanahojaha'aha adani ipohina, aviga'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hari. Oniaroa, hi'adani ija'ari Jesu-ra vagathi'iki sasidotxi vaka'da'diva gorana avisa'aha, Caifás oniki ada. Sasidotxi vakadika'da'di gorana bodinia vajoroniha adani judeus kaija'ari vaka'ojomo'iva abono, judeus kaija'ari vanava'isohiva abono khama. ");
INSERT INTO padNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hari. Napaja kasiagaha ada Pedro. Sasidotxi vakadika'da'di gorana khanona, gora i'oarini kavasiribanini bodinia o'oi'aha ada Pedro, vithima'o'aha, gora avakadava'ava abono vakadiania, va'oaniaro sorara fori vihiki adani. Pedroa binokhaki ida Jesus monina-ra kamithavini. ");
INSERT INTO padNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","60","Sasidotxi vavaka'da'diva, judeus kaija'ari vanasohiva abono vavaka'da'diva khama vaabono vara vakani'akhama'aha. Vanofiki Jesus abinina-ra vavahonariahivini. Vanako'diki ida badani asohiriki Jesus kania, ni-vakaragaki. Jesus athi kamithava abono-ra va'ora vakaboa'iha Jesu-ra avakaraganahara kaimoni afohanana. Jesu-ra vakanavaranihavini adani ija'ari vaipohiki afohanana. Korijanahia vakavaranina mani ida vakadivarani-ra avakanasohikhamaravini hija. ");
INSERT INTO padNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hari. Makhira vi'bamiki vahoariha avi'oi'aha. Sasidotxi vavaka'da'diva-ra va'ora vani'aha: —Akamithaki ida Jesus athi. Bini'aki: “Onathararavini bana ida Deu-ra khai ani'avini kagorani. Mahi ahoarabakosikia onamonaha'ianaki bana ida gora.” Nimania ida Jesus athi akamitha'iki — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Oniaroa, gaa'aha ada sasidotxi vakadika'da'di. Jesu-ra nana'dohi'aha: —Igathanivini inofiria ida ira vakanavaranihavini? ");
INSERT INTO padNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesua viso bini'ahi ida athi, ni-bigathaniki. Oniaroa, sasidotxi vakadika'da'dia bini'aha: —Iathini-ra kamithara kaimoni ada Deus hokiki, ira ohonariavini hiki hida kodina'dohi-ra igathanivini. Ivani Cristo Deus ira nagathogatho'iki i, ija'ari hahavi vakadika'da'di ihija kaimoni? Deus kaisai mani i? ");
INSERT INTO padNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesua bigathani'ihi ida athi: —Ivani hora ini'aja Deus kaisai ohina. Ka'oa hini hida kadavarani. Hovani ija'ari hahavi vakadi'aajo ho. Deus danoki pitana aniaja ovithiki bana ho. Ka'da'di ohina. Ovithina-ra avanokiki bana a'oni. Bahi vaforiki namana vani nama ogarina-ra avanokija bana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Oniaroa, sasidotxi vakadika'da'dia bina'bira'ihi ida kidikarahobi bikaimahaki, bikavarajomija kaimoni ida Jesus Deus hina kavaranihi-ra vajaharavini. Va'ora ni'aha: —Jahariki ida Jesus kavarani. Deus kaisai hina-ra kahi'badaraki ada. Nahina kaimoni va'ora anihajanariha adani Jesus vara vani'ava abono. Akamitha'iki hida Jesus Deus kaisai hina-ra kahivini. ");
INSERT INTO padNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Niha ani'a'aki koda hada Jesus? Vagathani'ihi ida athi: —Jahariki hida kidivarani. Jahaki ida abinina — vakhanihahavi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Naothinia Jesus nokho-ra vakai'bai'aha, vidajaha'aha jaboni. Vahoariha vakajoiri'aha. ");
INSERT INTO padNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Vani'aha: —Aihotahi abono, hana hina vani ira kajoirija? ");
INSERT INTO padNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hari. Gora banininia asia hojaha ada Pedro vithi'ina. Kha'ihi ida sasidotxi vakadika'da'di kabadani abono. Pedro-ra namaakari'ihi, bini'aha: —Ivani ivaipohihara ada Jesus oniki. ");
INSERT INTO padNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro abono-ra vajari'daha ija'ari vahojaki vaviaha: —Iniani, ovaipohihariha ada. Ni-oogajahakiki ida kadavarani nahina nini. ");
INSERT INTO padNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hari. Ajihi'aha, gora kavasiribanini kaathania okhamiha. Badani abono hoariha binokiha, vahoariha-ra va'ora ni'ahi: —Ovani hi'o Jesus ipohina, Nazaré sidaji oniki kaija'arini ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedroa bini'a'ianahi: —Iniani, ipohina ohirihi. Deua bikamithaki ida a'onira oni'avini hiki, ni-oogaki ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mitihini vahojakia vanamaakari'aha ada Pedro, vani'a'ianaha: —Hai oamani, kidipohi oamani i, iathini fori hiki ida Jesus athi, Galiléia kaaraboni kaija'arini a'oni afo'bamakhama. ");
INSERT INTO padNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Oniaroa, Pedro va'ora ni'aha: —Deua bikamithaki hida kodivarani. Ni-oogaki ada makhira. Ipohina ohirihi. Korijanahia okavaranihi, Deus hora naima'banakarahovini-ra onofihi. Oniaroa, ahia'aha ada arakava. ");
INSERT INTO padNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedroa bikava'ihoki'ihi ida Jesus athi: “Hihida joma arakava ahiana viahania, ivani inihaki i: ‘Jesus ipohina ohirihi.’ Ahoarabakosikia inihi.” Jesus athi-ra kava'ihokiha, ajihi'aha ada Pedro, asara'ahapiki'aha. ");
INSERT INTO padNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hari. Oniaroa, vagavagani vaabono vara vakani'akhamaha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama. Vakhaniha: —Deus kaisai hina-ra kahi'badaraki ada Jesus. Jahaki ida abinina bana. ");
INSERT INTO padNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Naothinia Jesus dabohana-ra vavahonariahi'aha, Pilatos kania avisa'aha ada Jesus, avarakha'aha. Arabo kaka'da'dini ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Oniaroa, Judas Iscariotea bikamitha'ihi ida Jesus varani hina, judeus kaija'ari vanava'isohiva abono abinina-ra vavahonariahivini-ra vanofivini. Hi'o Judas Iscariotes Jesu-ra arakha'iki. Monina-ra kamitha'aha, abono-ra ka'da'digaria'aha. Hari. Sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono vakadiania okha'aha ada Judas. Kaikahi'aha, binajoiki ida jiniro 'ba'dani 30 hiki ipohini vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Va'ora ni'aha: —Asohiri'oamanija ida Jahari kabadania okabadanina. Oarakha'iki ada Jesus avakadiania. Ni-Jesua bada bini'apa'itxiki ida Jahari kabadani! Judas Iscariote-ra vani'aha: —Ni-akava'ibodiki ida kadabadani asohini asohirini. Ba ivani inasohi. ");
INSERT INTO padNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Oniaroa, Judas Iscariotea bisonarari'ihi ida jiniro Deu-ra khai vani'avini kagorani bodinia, va'ora nahojaha'aha, ajihi'aha. Okha'aha kanabidi-ra akanafora'aha, abono-ra naabini'aha. ");
INSERT INTO padNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judas Iscariotes ajihi'ina naothinia sasidotxi vavaka'da'diva vidora'ihi ida jiniro, vakhaniha'aha: —Niha ani'a'aki koda hida jiniro? Hihida jiniro Juda-ra ano'avini hi'iki Jesu-ra arakhavini anaabosivini abinira kaimoni ada Jesus. Ni-jahaki ida jiniro ija'ari abinini abosini hiki, ija'ari Deu-ra vakanava'igavini kaimoni hini. Nimania ida Deus kava'isohihi jiriki athini. Oniania, ni-jahaki aobaivini hida jiniro bavinia Deu-ra khai ani'avini kagorani bodinia hojaki — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oniaroa, naothinia vaabono vakanava'isohikhamavini hi'ihi ida ibavi-ra vanaabosivini, jiniro Judas Iscariotea binajoi'ikia. Hojaki ida ibavi ija'ari nami-ra vikhorivini ibavini vakadibavi amonahani kaimoni. Vakapavakari'ihi ida ibavi. Vanaabosivini naothinia, ija'aria vanamonaha'ihi ida ka'damahi ibavini kaimoni. Judeus kaija'ari vihiriki vaba'ona ka'damahani ibavini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ama ahovari'iki abosini ida jiniro, oniani ida ibavi-ra vanaonivini hija: “Ibavi ama biavahovari'ikia.” ");
INSERT INTO padNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nimania ida Deus athi namoniva abono kohana Jeremias oniki athi. Jeremia vara bivani'ajora'iki ida namithaki kaimoni: “Vidora'ihi ida jiniro 'ba'dani 30 hiki ipohini. Israel kaija'ari vaabono vakanava'isohikhamavini hiki ida jiniro ipohini, vanaabosira kaimoni ada ovari. ");
INSERT INTO padNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Vakapavakari'iki ida ibavi ija'ari nami-ra khorivini ibavini. Nimania ida Deus hora honariavini hiki okapavakari'iki.” ");
INSERT INTO padNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Oniaroa, Pilatos viaha hojaki ada Jesus. Pilatoa binana'dohi'aha: —Ivani, judeus kaija'ari vaka'da'diva i? —Ha'a, ka'oa oamani ida ini'aki — Jesua bini'aha. ");
INSERT INTO padNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pilatos kania sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama, Jesu-ra avanaathidanoarari'aha, ni-Jesua bigathani'iki ida vakadivarani. ");
INSERT INTO padNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatoa binana'dohi'ianaha ada Jesus: —Ikamitharia ida ira avanaathidanoarari'ahapikivini athini? ");
INSERT INTO padNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ni-Jesua bigathaniki ida Pilatos athi. Pilatoa bikava'ibodivaranikarahohi ida Jesua athi bigathaniravini. ");
INSERT INTO padNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hari. Páscoa ihinika kamahini Pilatoa biva'ahaki ada makhira hoarana cadeia kabodinia hojaki ajihina, aihotara kaimoni. Ihinika-ra vanamonahakia vanagathogatho'iki ada makhira hana hina cadeia okhaonanina-ra vanofivini. Pilatos hojana hiki ida makhira-ra arakhaonanivini. ");
INSERT INTO padNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hari. Hojaki ada Barrabás oniki cadeia kabodinia. Ija'ari vaipohikia avigaki ada Barrabás. ");
INSERT INTO padNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Oniaroa, Pilatos kania vajoroni'aha adani ija'ari vâipohiki. Pilatos va'ora ni'aha: —Hana hina makhira-ra koda cadeia okhaonanina-ra avanofija? Barrabás vani ada avanofira? Jesus vani ada avanofira? Hi'o Cristoa avanaoniki. ");
INSERT INTO padNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatos abono-ra ni'avini: —Ija'ari vaipohikia vavajahaki ada Jesus. Jesu-ra avakabaivini adani sasidotxi vavaka'da'diva. Vakadi'akabajahi oamani ida Jesu-ra avarakhavini hija kodiania — abono-ra ni'aha ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ija'ari-ra nasohivini kagorani bodinia vithi'aha ada Pilatos. Kidigamoa bikarona'ihi ida athini kidimoni, bini'aha ada kidimakhira: —Hari'a jaharikia iarakha bana ada Jesus. Ni-nahina jaharikia kabadaniki. Hihida joma kodivadami hiki ada ovari. Hora naimahidaki hida onokivini kodivadamia — nihi ida Pilatos kagamo athini bikarona'iki. ");
INSERT INTO padNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama va'ora vara vani'abakhiaki afodanoki adani ija'ari vaipohiki Barrabás arakhana-ra vakanikhariavini. Oniania, vanaaba'ihi ida sasidotxi vavaka'da'diva vakadihonari. Pilato-ra vani'aha: —Anofiki bana ada Barrabás iarakhavini akadiania. Anofiki ida Jesus abinina-ra ivahonariahivini. ");
INSERT INTO padNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Oniaroa, va'ora nana'dohi'ianaha ada Pilatos: —Hana hina makhira koda ada oarakhavini avanofira avakadiania? Pilato-ra vani'aha: —Barrabás vani ada anofira. ");
INSERT INTO padNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatos va'ora nana'dohi'ianaha: —Niha oni'a'aki koda ada Jesus, Cristoa avanaoniki? —Ivahonariahi ava akasanakhamakia aka'itapoamisahanana abinira kaimoni — vani'a'aha ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatos va'ora nana'dohi'ianaha: —Nahina kaimoni ida Jesu-ra ovahonariahivini hija abinina? Nahina mani ida kidibadani jahariki hija? — va'ora nana'dohiha ada Pilatos. Bodi'barahia vani'aha. —Ivahonariahi bana ava akasanakhamakia aka'itapoamisahana'ina. ");
INSERT INTO padNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoa ni-bikaabokajanaki ida ija'ari vaipohiki vakadibodi'barahi. Ni-athi vakamithapa'itxijanaki. Pilatos va'ora fini'iki adani ija'ari vaipohiki kidisorara-ra va'ora vidavini, oniani ida kidihonai abono-ra ni'avini hija: —Hora kavikha paha osa'a-ra okosokoja kaimoni. Hari. Ija'ari vaipohikia vanokivini kaba'i, Pilatoa bikosoko'ihi ida sa'a, va'ora ni'aha: —Osa'a hida okosokoja, avarigaja kaimoni ida Jesus abinina-ra onofiravini. A'onivani avanofija ida abinina — va'ora ni'aha ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ija'ari vajoronikia ni-vavamakhaniki ida Jesus abinina, oniani ida Pilatos athi-ra vagathanivini hija: —Jahaki ida abinina; harivani agathaniki ida abinina abosini nahina jaharikia. Akadija'ari vanamitharonisiagakia vagathaniki jaboni bana ida nahina jahariki Jesus abinina abosini. ");
INSERT INTO padNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Oniaroa, Pilatoa bivahonariahi'aha ada Barrabás arakhana aihotara kaimoni. Pilatos sorara-ra va'ora honariavini Jesu-ra vidafiahavini xikotxia. Ja'di sajoki va'a ipohikia ahoki ida xikotxi oniki. Vidafiahavini naothinia, Pilatoa bivahonariahi'aha ada Jesus aka'itapoamisahanana ava akasanakhamakia abinira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hari. Avaka'itapoamisahanavini viahania, sorara vania avavikhamiha ada Jesus ibavi hoariha Pilatos gorana bodinia. Avavikhamiha, va'ora vakaboa'iha adani sorara vaipohiki vajoronira kaimoni. Vabodi pana hojaha ada Jesus avigarahara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Oniaroa, vaani'ihi ida kidikarahobi bikaimahaki. Avanaragarahivini hi'ihi ida karahobi nadaraki. ");
INSERT INTO padNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Vakanamonahahi ida kajamari kajaroki. Ka'da'dia avakaragari'ihi. Vanaibavi'ihi ida ava sa'a aniaja, arabo kaka'da'dinia bivahojaki fori hiki. Jesus viaha vakajo'atharari'aha. Judeus kaija'ari vakadika'da'di hina vakahi'badara'aha. Jesu-ra vani'ahahaviha: —Ivani judeus kaija'ari vaka'da'diva i — vani'abakhiaha. ");
INSERT INTO padNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jesu-ra vakai'bai'aha. Visaari'ihi ida ava, ka'da'di vakodafia'aha jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Oniaroa, avigarahavini naothinia, vaani'ihi ida karahobi nadaraki, Jesu-ra vakanakarahobi'ianara kaimoni kidikarahobia. Oniaroa, ai vavaniha'aha ava akasanakhamakia avaka'itapoamisahanara kaimoni ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hari. Ai vavanihaha. Avikhana kaba'i vakaragarari'aha ada Simão. Cirene sidaji kaija'arini ada. Hari. Sorara Simão-ra vanokiha, vahonaria'aha: —Ivani, Jesu-ra kakaiba'ahivini hihida ava akasanakhamaki — sorara vani'aha ada Simão. ");
INSERT INTO padNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hari. Bikaiba'i'ihi ida ava akasanakhamaki. Oniaroa, Gólgota ibavi onikia vakaikahi'aha. (Gólgota ibavi oniki ka'da'di kajaroni kaibavini ida.) ");
INSERT INTO padNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sorara Jesu-ra vano'avini hiki ida vinho a'bani bariokhana kabodiki. Imana 'banani fai inija kaimoni. Bikaijo'ahi, ni-binofiki. ");
INSERT INTO padNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hari. Ava akasanakhamakia Jesu-ra avaka'itapoamisahana'aha adani sorara. Varagaamananivini ida ava akasanakhamaki nami khorahaki bodinia. Hari hi'ihi ida vakadibadani. Oniaroa, vakosonakhamaki ida ja'di pitani jiriki, avigaja kaimoni ida kidimakari ravina'ini. ");
INSERT INTO padNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Naothinia, vavithiriama'o'aha adani sorara Jesu-ra avakadava'avini. ");
INSERT INTO padNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hari. Jesus ka'da'di kanamania avakaka'itapoamisi'ihi ida tábua kajiriki rajomi kaimoni, ija'aria avigaja kaimoni ida nahina kaimoni Jesu-ra vanaabinivini. Vanajirivini athini: “Hihada Jesus. Judeus kaija'ari vakadika'da'di hada.” Jesu-ra avanaathidanoararivini hiki judeus kaija'ari vakadika'da'di hina-ra kahivini. ");
INSERT INTO padNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hari. Sorara vani va'ora vavikhaha adani daiki-ra avanahoroabakhiaki vi'bamiki. Va'ora avaka'itapoamisahana'aha jaboni. Vanaibavi'aha ada hoariha Jesus pitana aniaja, vanaibavi'aha ada hoariha Jesus pitana kajasonija. ");
INSERT INTO padNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hari. Ija'ari varadaha'aha avigaraha'aha ada Jesus. Jesu-ra vakaihimoravini oamani ida varani niki-ra vara vavani'avini hija. Onii jaharikia Jesu-ra vani'aha: ");
INSERT INTO padNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Deu-ra khai ani'avini kagorani-ra inathararavini-ra ikahiki i, mahi ahoarabakosikia ianaja'divini ikahiki i. Deus kaisai ihini-ra ikahiki i; iabono akava'ijoa'a. Iabono ani'a ava akasanakhamakia — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jesu-ra avigaraha'aha jaboni adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono, judeus kaija'ari vanava'isohiva abono vihiki. Vaabono vakani'akhama'aha: ");
INSERT INTO padNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jesus va'ora akava'ijoa'iki adani vahoariha. Ni-abono-ra maha akava'ijoavini-ra kaaboka'iki. Akadija'ari vaka'da'diva hiriha o. Abono-ra anivini anokiha, ava akasanakhamakia gaarina anokiha; ni-akajari'dajanaki. ");
INSERT INTO padNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jesua bivakaijokaki ada Deus. Deus kaisai hina-ra kahiki ada jaboni. Ka'oa hija vaha ida kidivarani; Deua binofiha vaha; biakava'ijoaha vaha — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hi'adani vi'bamiki avaka'itapoamisahanakia avigarahaki jaboni ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hari. Safini sohirarina vani bakibakini kama'da'ihi ida arabo afohahavi. Safini ajorana vani avagani kama'da'ianahi. ");
INSERT INTO padNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Safini ajorana vani bodi'baraha'aha ada Jesus athia: —“Eli, Eli, lemá sabactani” — niha ada Jesus athia. “KodiDeus, kodiDeus, niha onina mani hida hora inahojahavini hi'ia?” — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ija'ari vahojakia vakamithahi ida kidibodi'barai, vakhaniha: —Mitha vani'a. Elias kohana-ra baranahaki ada — vakhaniha. Elias kohana-ra baranahaki vavanihaha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ki'daraha'aha ida ija'ari athi-ra kamithaki, bianathorani'ihi ida makari fori hiki vinho kaidivarikia. Ava oadaki sanarahakia binahoja'ihi. Bivikhahi, Jesus viaha biarakasi'ihi, Jesua binadomidomija kaimoni ida vinho a'bani. ");
INSERT INTO padNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Vahoariha ava akasanakhamaki kania vahojakia vani'aha ada vinho-ra vikhaki: —Hari'a kaho. Ada kaho vahabini khaha Elias, ava akasanakhamakia biakava'ijoara kaimoni ada Jesus. Vada ani'ava. ");
INSERT INTO padNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Oniaroa, bodi'bara'ianaha ada Jesus, abini'aha. ");
INSERT INTO padNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hari. Abinina kaba'i 'bira'ihi ida makari katokihi Deu-ra khai vani'avini kagorani ka'oahafianihiki. Makaria bikatapafiaki ida gora pitani Ibavi Katokini Jahaka'oaki oniki ija'ari o'oiria kaimoni. Khiorarini akapitakhama'ihi. Ho'doho'do'ihi ida arabo. 'Boro'boro'ihi ida ja'di na'bahaki. ");
INSERT INTO padNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Arabikhaja'ihi ida ija'ari vaba'ona ka'damahani ibavini ipohiki, Deus athi-ra vanaaba'iki kohana vaipohiki avahoki'iki 'dama kania vikhaonani'iki. Jesus ahoki'ina naothinia, Jerusalém sidajia avi'oi'aha adani ija'ari avahoki'iki, ija'ari vahoariha va'ora vanoki'aha. ");
INSERT INTO padNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Oniaroa, ava akasanakhamaki kania vahojaki adani sorara, sorara kaka'da'di khama. Jesu-ra avakadava'aki adani. Vanoki'ihi ida arabo ho'doho'doki, vakamithaki jaboni ada Jesus bodi'bara'ina. Jesus abinina-ra vanoki'aha, vaimahidakaraho'aha, vani'aha: —Deus kaisai oamani hada hihada makhira. ");
INSERT INTO padNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hari. Vahojamaniha adani gamo ava akasanakhamaki kania. Abinina vanokivini napaja pa'itxia. Galiléia kaarabonia Jesus hojana kari, Jesu-ra vavaipohihabakhia'iki adani gamo, Jesu-ra vakaijahitavini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gamo vahararana vahojaki adani Maria Madalena. Tiago, José vihiki vakadiamia Maria oniki jaboni hojaki. Zebedeu kaisai vakadiamia jaboni hojaki gamo vahoariha vakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hari. Mithani vaivaini kaikahi'aha ada makhira kanahinaki José oniki. Arimatéia sidaji kaija'arini ada. Jesus ipohina ada José de Arimatéia. ");
INSERT INTO padNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hari. Pilatos kania okha'aha, bikanikharia'ihi ida Jesus aba'ona, bika'damahaja kaimoni. Pilatoa bihonariaha ada sorara Jesus aba'ona-ra arakhavini José kania. ");
INSERT INTO padNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Oniaroa, Joséa bianikha'ihi ida Jesus aba'ona ava akasanakhamaki kania, bikarafoa'ihi makari jahakia. ");
INSERT INTO padNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ka'damahi ibavini biavikha'ihi. Ja'di hodijama'oki bodinia biobaiha'ihi ida Jesus aba'ona. Mahi ipohiriki viahania Joséa bihonaria'iki ida hodi khorahani ja'di karaho bodinia José abinina kamahini ka'damahana ibavini kaimoni. Vakadihojai hiki. Hari. Jesus aba'ona-ra obaivini naothinia, bika'oaha'ihi ida ja'di hodini kaathani, ja'di karahoa. Ajihi'aha ada José. ");
INSERT INTO padNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ja'di hodijama'oki viahania vavithi'aha adani Maria Madalena, Maria hoariha khama, José vakadibadani-ra vada vani'avini. José ajihina naothinia, va'ajihi'aha adani gamo jaboni. ");
INSERT INTO padNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hari. Ka'afokajomani vani vajoroni'ianaha adani sasidotxi vaka'da'diva, farisio vihiki khama Pilatos kania. Vakadi'akoiri kamahini hini kaba'i vani vajoroniki adani. Hari. Vani'a'aha ada Pilatos: ");
INSERT INTO padNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Pilatos, akava'ihokiki ida Jesus kohana abinirina oadani haria ni'avini hi'iki athi: “Radaha'ihi ida mahi ahoarabakosiki oahokiki bana ho.” Nimania ida korijanahi abono athi. ");
INSERT INTO padNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Oniania va'ora honaria bana adani sorara Jesus ka'damana-ra avakadava'avini. Mahi ahoarabakosiki radaharini oadani vahojara kaimoni, kidipohi aba'ona bo'dihirija kaimoni. Vabo'diavini naothinia va'ora vani'aki bana adani vahoariha: “Ahoki'iki ada Jesus.” Jahariki ida Jesus kohana kakorijanahi, jaharini arafiaki bana ida ipohina vakadikorijanahi, Jesus ahoki'ina-ra vakahivini bana — va'ora ni'aha adani sasidotxi vavaka'da'diva. ");
INSERT INTO padNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatos va'ora ni'aha: —Jakaho va'ora ova'ahava adani kodisorara aba'oi ka'damani-ra avakadava'avini. Va'ora avavikha'a hadani sorara mahija Jesus ipohina aba'ona vabo'diaravini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ai vihi'aha adani sasidotxi vavaka'da'diva. Ka'damahi kania avikha'aha, avanathana'ihi ida ja'di katapani karaho namanija, avigaja kaimoni ida ija'ari avi'oirina ja'di kahodihi bodinia. Vanaibavivini naothinia va'ora vanahojaha adani sorara aba'oi ka'damahani ibavini-ra avakadava'avini. ");
INSERT INTO padNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hari. Avakoirina kamahini naothinia, domingo vani, mahi avagani kama'dani avikha'ianaha adani Maria Madalena, Maria hoariha khama aba'oi ka'damahani kania vavanavanaha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hari. Jorakia ho'doho'dodanoki'ihi ida arabo. Deus ibavi kaija'arini gaari'aha nama. Jesus ka'damahana kania akhanorari'aha. Biani'ihi ida ja'di, ja'di hodi jama'oki ka'oahajanaria kaimoni. Bianivini naothinia, vithi'aha ja'di namania. ");
INSERT INTO padNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bahi kabanabanahi nokiana fori hiki ida Deus ibavi kaija'arini nokiana. Vaforini arafiaki ida kidimakari. ");
INSERT INTO padNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Dama kania vahojaki jaboni adani sorara. Vaimahidakaraho'aha, oniani ida va'ora nathararaja varai'a'ina, vaabiniki fori vihiki adani. ");
INSERT INTO padNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Oniaroa, 'dama kania avakhano'aha adani gamo. Gamo-ra va'ora ni'aha ada Deus ibavi kaija'arini: —Hari'a vaimahida! Oogaki ida Jesus ava akasanakhamakia aka'itapoamisahanaki-ra avanako'dihavini. ");
INSERT INTO padNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ni-hida hojajanariha ada. Ada ahoki'aha. Nimania ida abinina viahania a'onira nava'isohijoravini hi'iki. Vada vani'ajakosi hida aba'ona hojani ibavini — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Vara ni'a'ianaha ada Deus ibavi kaija'arini: —Ai vihi'a mahija Jesus ipohina-ra va'ora avanava'isohihavini, va'ora vani'a bana: “Ada ahoki'aha Jesus. Galiléia kaarabonia a'onira naviahanokhaki bana ada. Idiaja avanokiki bana ada. Onivani fori hija ida kidivarani a'onira ni'ajoravini hiki.” Va'ora vani'a bana — Deus ibavi kaija'arini va'ora ni'aha adani gamo. ");
INSERT INTO padNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hari. Ka'damahi ibavinia jorakia va'ajihi'aha adani gamo. Vaimahidakarahona kaba'i khai vakhanikaraho'aha jaboni. Vaki'darahaha'aha Jesus ipohina vakadiania va'ora vananamithavini hija kaimoni ida vanoki'iki, vakamitha'iki hiki. ");
INSERT INTO padNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Oniaroa, jorakia gamo vakadiania abono-ra nanokiaha ada Jesus. Bini'aha: —Deus a'onira no'aki a'oni va'i jahajahania! Jesu-ra vanamaakari'aha, 'dama vakajara'ba'ba'aha, Jesu-ra vakanamasivi'aha. ");
INSERT INTO padNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oniaroa, va'ora ni'aha ada Jesus: —Hari'a vaofini! Kodipohi kania avikha'a bana. Va'ora vanava'isohi bana: Galiléia kaarabonia avikha'a bana, idiaja oabono onanokiaki ho avakadiania. ");
INSERT INTO padNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hari. Ai vihi'aha adani gamo. Hagihia avikhana kaba'i, ai vihi'aha adani 'dama-ra avakadava'aki vaipohiriki. Sidajia avajoi'ina sasidotxi vavaka'da'diva vakadiania avikha'aha, va'ora vananamithavini hi'ihi ida vanoki'iki 'dama kania. ");
INSERT INTO padNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Oniaroa, sasidotxi vavaka'da'diva va'ora vakaboa'i'aha adani judeus kaija'ari vanava'isohiva abono vajoronina. Vaabono vakanava'isohikhama'aha: —Va'ora ano'aki bana adani sorara jiniro karahoa vananamithajanaria kaimoni ida vanoki'iki vahoariha vakadiania — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Oniaroa, va'ora vani'aha adani sorara: —A'onira ano'avini hiki hida jiniro karaho Jesus monina-ra vara avavani'ajanaravini abosini. Vahoariha vakadiania vani'a bana: “Joma vania avadina kaba'i, vikha'aha adani Jesus ipohina, aba'oi-ra vabo'diaha'aha.” Vani'a bana. ");
INSERT INTO padNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilatoa vahabini bikamithaki bana ida varani avihini, haria nana'dohivini hiki ida avavadini varani hini. Pilato-ra anaariakaki bana hari avakadimoni, jaharikia a'onira arakharara kaimoni — sorara-ra vani'aha adani sasidotxi vavaka'da'diva. ");
INSERT INTO padNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hari. Sorara vagathani'ihi ida jiniro, sasidotxi vavaka'da'diva vaathi-ra vanaaba'aha, ni-vara vavani'a'iki ida vanoki'iki. Vara vavani'a'ihi ida sasidotxi vavaka'da'diva va'ora vahonariavini hiki. Judeus kaija'ari vaipohikia vakamitha'ihi ida sorara vakadikorijanahi. Asia mani judeus kaija'ari vaipohiki vakadikorijanahi-ra vakajari'dariha. ");
INSERT INTO padNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hari. Galiléia kaarabonia avikha'aha adani Jesus ipohina 11 vihiki. Arabo namahiki Jesua bivava'isohihijoraki kania avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Avakhano'aha, Jesu-ra vanoki'aha, vakanamasivi'aha. Vahoariha vanokivini kaba'i vava'i kosakhamani hini. ");
INSERT INTO padNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hari. Jesus va'ora anamaakari'aha, va'ora ni'a'aha: —Ogathaniki ida ogahai danoki hahavi ovaka'da'dija kaimoni ida hahavi namajaja hojaki, arabo hojaki jaboni. Okaabokaki ida hahavi onofiki. ");
INSERT INTO padNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Oniani ida arabo hahavi kaija'arini vaibavia avarikhani-ra ohonariavini hija. Vara vavani'a bana hida omonina mahija oathi-ra vanaabavini, oipohina vihira kaimoni. Va'ora vikana bana adani kodiania vaabono gahinai vanihaki. Va'ora avikanavini kamahini vidioni bana ida Deus akadiabi'i onina, vidioni jaboni hida oonina, Deus kaisai ohina, vidioni jaboni ida Ma'onahai Jahaki onina mahija Deus kaija'ari vihina. ");
INSERT INTO padNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Va'ora vaka'ojomo'ivinihi bana hida kodihonari hahavi-ra vanaabavini. Vakava'ihokiha'oadahaha bana ida avakadiania ohojana mahi hahavi. Mahi anokhomirini oadani ohojahaha'oadahaki bana ho avakadiania — va'ora ni'aha ada Jesus. Hari ida vani oamani Mateus kavarani anokhomi'ini.");
INSERT INTO padNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesus Cristo kavarani hiki ida monina jahaki. Deus kaisai ada Jesus Cristo. ");
INSERT INTO padNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hida vani varani moni jahaki kama'dani. 'Bo'dakari hojaki ada Deus athi namoniva abono Isaías oniki. Isaías kohana binajiri'iki ida Deus athi kapapirani pitani. Bini'aki: —Deus Jesu-ra nava'isohivini: “Kodisai, iokhani viahania okaronaki bana ada makhira oathi avikhava abono hira kaimoni. Ovari va'ora nava'isohiki adani ija'ari hahavi ikaikahini-ra vanaviahanokhara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Oniaroa, amasia hojaki bana ada iviahania okaronaki, ija'ari-ra va'ora ni'a'aha bana athi 'barakia: ‘Amaakariki ida akadika'da'di kaikahina kamahini. Vanamonaha'a ida hagihi sohiki akadika'da'dia bivaadahaki kaimoni. Vanajaha'a ida hagihi kidimoni.’ ” Nimania ida Isaías kohana athi papira hojaki. Isaías kohana vara bivani'aki ida hagihi-ra najahaki, kidivarani ka'oa ida ija'ari kamahi-ra nasohija. ");
INSERT INTO padNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hari. Oniaroa, kaikahi'aha ada makhira Deua bikaronaki, onina João Batista. Amasia hojaki ada. Kagorarihi ida amasi. Hari. Va'ora nava'isohibakhiaki adani ija'ari vaipohiki. Va'ora ni'avini: —Jahari kahojai-ra vakava'ipahinika'oa bana. Hari'a vanofijana bana ida Jahari kahojaia avakahojaibakhiani mahija a'onira okanavini, Deua bina'biraja kaimoni ida avakadihojai asohiriki bada avani'abakhiaki — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","João Batista kania vakhano'aha adani ija'ari vaipohiki. Judéia kaaraboni kaija'arini João kani-ra avanikhabakhiaki. Jerusalém sidaji kaija'arini João kani-ra avanikhabakhiaki jaboni. João kavarani-ra vakamithavini-ra vanofiki. Deus kania vara vavani'avini hiki ida vakadihojai asohiriki hahavi. Vakava'ipahinivini vanofivini, Deus bina'biraja kaimoni ida vakadihojai asohiriki. Vara vavani'avini naothinia, João va'ora kana'aha afohanana Jordão vaini onikia. ");
INSERT INTO padNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","João Batista kamakari hiki ida camelo asafi amonahaki. Bikaimahaki jaboni jararia baasafi kacinturãohi. Kidi'bai hiki omavari fori hiki, bahina a'bana hiki. ");
INSERT INTO padNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hari. João Batista ija'ari-ra va'ora ni'aha: —Onaothia khaki bana ada hoariha. Ka'da'di ka'oa ada ovari. Hovani kidihonai abono ho. Arafiaki ida kidihojai asohika'oani. Kodihojai jahani fori hirihi ida kidihojai jahani arafiaki, kaba'i hora nagathogathoha oakodiara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Hovani a'onira okanaja paha bodinia. Ovaria bikaronaki bana ada Ma'onahai Jahaki avava'ini-ra nahonariahihiki kaimoni — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Oniaro kari, Galiléia kaarabonia hojaha ada Jesus. Nazaré sidajia hojaha. Oniaroa, ajihi'aha, okha'aha Jordão vaini onikia. João Batista kania akhanofoni'aha. Joãoa bikana'aha ada Jesus vainia. ");
INSERT INTO padNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus kanana naothinia ogaimori'aha. Binoki'ihi ida nama arabikhajahavahaki, binokiha jaboni ada Ma'onahai Jahaki gari'ina kidiania, ho'doko aagariki fori hina. ");
INSERT INTO padNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nama kamithavahaki ida Deus athi: —Ivani kodisai i. Ira onofijahakiki i. Khai oni'aki ida ihojani. ");
INSERT INTO padNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Oniaroa, Ma'onahai Jahakia bihonariaha ada Jesus amasia okhana. Kaija'aririhi ida amasi. ");
INSERT INTO padNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hari. 40 mahi vani hojara ada Jesus amasia. Mahi hahavi okhaha ada Jahari Jesus kania bikaborobakhia'aha ada Jesus, bada bini'aja kaimoni ida badani Deua bivajahariki. Jesua ni-bikapoaripa'itxiki ida athi. Tapo'ija vahojaki jaboni amasia. Oniaroa, vigaariha adani Deus ibavi kaija'arini Jesu-ra akadava'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hari. Arabo kaka'da'dinia gathana bivahonariahi'aha ada João Batista, cadeia avibaira kaimoni. Hari. Oniaroa, Galiléia kaarabonia okha'aha ada Jesus. Ija'ari-ra vara va'ora ni'avini hi'ihi ida Deus monina jahaki. ");
INSERT INTO padNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Va'ora ni'aha: —Hidakaba'i Deua binofiki ida athi avanaabavini. Maakariki ida mahi Deus ija'ari hahavi-ra vaka'da'divini. Avakadihojai asohiriki-ra vakava'ipahinika'oa bana. Hari'a vanofijana. Vavakaijokaka'oa bana ida Deus monina varani hini. A'onira akava'ijoavini-ra nofiki bana ada — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Oniaroa, Galiléia 'dako vadinia khabaoniha ada Jesus, va'ora kanokiha adani araba abono vi'bamiki vakatahafahaki. Aajojahiki Simão Pedro, kajo'ojahiki André. ");
INSERT INTO padNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus va'ora kani'aha: —Hora vavaipohiha mahija badani hoariha a'onira oka'ojomo'ivini. A'onira oka'ojomo'ivini hiki ija'ari vahoariha-ra avakaboa'ivini kodija'ari vihira kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oniaroa, vakahagi kabodinia vakanahoja'ihi ida vakaditahafa, Jesu-ra vavaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Avikha'ianaha adani Jesus, va'ora vakanokiha adani araba abono vahoariha vako'bamiki, vakadiabi'i khama. Aajojahiki Tiago, kajo'ojahiki João. Vakadiabi'i Zebedeu oniki. Vakahagi kabodinia vahojaki adani. Bada vakhaniki adani tahafa-ra avakanaja'divini. ");
INSERT INTO padNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus va'ora baranahaha adani vi'bamiki: —Hora vavaipohiha! Jorakia vakahagi-ra vakanahojaha'aha. Vakaamina'aha ada vakadiabi'i, vakadihonai abono vihiki jaboni, Jesu-ra vavaipohiha'aha. Avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hari. Cafarnaum sidaji onikia avakhanoha adani Jesus, vahoja'aha. Avakoirina kamahini judeus kaija'ari Deu-ra vara vani'avini kagorania avi'oi'aha. Va'ora ka'ojomo'i'aha adani ija'ari vajoroni'iki. ");
INSERT INTO padNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vakava'ibodivaraniki ida va'ora ka'ojomo'ivini niha ninini Jesua biogajahakiki ida nahina Deua binofiki, oniani ida Deus athia va'ora ka'ojomo'ijahakivini hija. Judeus kaija'ari vaka'ojomo'iva abonoa ni-avigajahakiki, Jesus fori vihiriha adani. ");
INSERT INTO padNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hari. Oniaroa, judeus kaija'ari Deu-ra vara vani'avini kagorania hojaha ada makhira kabajadiki. Bodi'baraha'aha: ");
INSERT INTO padNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesus, nahina hida akadiania inofija? Haria inihimamaniki i koda? Ira oogaki ho. Ivani ijahaka'oaki i, Deus ira karonavini hida ikhani — makhira bini'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Oniaroa, Jesua bikaabani'ihi ida bajadi: —Avisoni'a! Makhira kania akara'o'a bana! ");
INSERT INTO padNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hari. Bajadia binarai'aha ada makhira, bodi'bara'ihi, ajihi'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vahoariha mitha vani'a'ihi, vakava'ibodivarani'ihi ida Jesus kavarani. Vaabono vakani'akhama'aha: —Nahina nimania ida Jesus ka'ojomo'ihi athini ja'dini akamithabiinini'iki. Ka'da'di oamani ada Jesus. Ovaria bikaabokaki ida bajadi akara'o'ini-ra honariavini. Bajadia binaaba'iki ida athi — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ija'aria vara avavani'aoni'iki ida Jesus varani hina. Galiléia kaaraboni kaija'arini vaipohikia vakamitha'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hari. Oniaroa, judeus kaija'ari Deu-ra vara vani'avini kagorania ai vihi'aha adani Jesus, kidipohi khama, Tiago João vihiki. Simão, André vihiki vagorana avikha'aha adani Jesus. Vakaikahiha, gora bodinia avi'oi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simão kamasodini kabaravaki, omaki. Jesu-ra vara vani'avini hi'ihi hida kidikavamoni. ");
INSERT INTO padNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bivi'omaki kania okhamiha ada Jesus, sa'ani biagathi'ihi, bikajoamoravini biragama'ihi. Oniaroa, jorakia radaha'ihi ida kidibarava, va'ora kahinanika'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hari. Mithani vaivaini vani, Jesus kania ija'ari va'ora vavikha'aha adani ija'ari vahoariha vaipohiki vakavamoniki. Vakabajadiki-ra va'ora vavikha'avini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gora banininija vajoronihahaviha adani sidaji kaija'arini vâipohiki bakatha. ");
INSERT INTO padNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Vakavamoniki-ra va'ora anaihota'aha ada Jesus. Ipohiki ida vakadikavamoni. Ija'ari vaipohiki vakavamoniki ava'aihota'iki afohanana. Jesua bihonariahi ida bajadi akara'o'ini ija'ari kania, akara'omani'ihi. Bajadia avigaki ada Jesus Deus kaisai hina, oniani ida Jesus bajadi vara vakhanina-ra va'aharavini hija. ");
INSERT INTO padNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hari. Oniaroa, ka'afokajomani avagarini vani gama'aha ada Jesus, ajihi'aha, kaija'aririki kani-ra anikhaha'avini. Amasia kaikahi'aha, Deu-ra vara ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Oniaroa, vanokho'afora'aha adani Simão. Ai vihi'aha, Jesu-ra avanako'dionivini. ");
INSERT INTO padNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Vakaraga'aha, Jesu-ra vani'a'aha: —Ira vanako'dihahaviki adani ija'ari vâipohiki — vani'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Va'ora ni'aha: —Ija'ari vahoariha vaibavi maakarikia aokha'ava mahija Deus athia va'ora okanamonivini, oniani hida hora arakhaja — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Oniaroa, avaadahaoni'aha Galiléia kaaraboni kaibavinia vahihavi'aha. Judeus kaija'ari Deu-ra vara vani'avini kagorani hahavia va'ora kanamonivini hiki hida Deus athi. Jesus va'ora nokiha adani ija'ari vakabajadiki, bajadi akara'o'ini-ra honaria'aha. ");
INSERT INTO padNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hari. Jesus kania kha'aha ada makhira kavamoniki. Asafi hahavi namani-ra najaharikia kakavamoniki ada. Binamaakari'aha, kajo'atharari'aha Jesus viaha. Bini'aha: —Jesus, hora kajoamora bana. Hora inajahavini-ra inofihi; hora inajahahi — niha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesua binakaidivamaniha, bikanaibavi'ihi ida sa'a makhira namana, bikadasa'aha, bini'aha: —Ha'a. Onofiki ida ira onajahavini. ");
INSERT INTO padNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Vara nina kaba'i avisoni'ihi ida kidikavamoni asafi namania. Jaha'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hari. Jesua bikaabanidanoki'aha: ");
INSERT INTO padNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Hari'a bana vahoariha-ra nanamitha'a ira onajaha'avini. Okha'a bana sasidotxi kania mahija iasafini namani-ra nokivini, biogaja kaimoni ida ijaha'ini. Deus kava'isohihi jirikia bihonaria'iki ida ija'ari jaha'iki Deu-ra kanava'igavini igitha abononi aha'dikia vahoariha avigaja kaimoni ida jaha'iki. Sasidotxi ira nokivini naothinia inaaba'a bana ida Deus kava'isohihi jiriki. Okha'a bana mahija oathi-ra inaabavini — Jesua bini'a'aha. ");
INSERT INTO padNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hari. Ajihi'aha ada makhira. Ija'ari vaipohiki vakadiania vara biavani'aoni'ihi ida Jesua bianaihota'avini. Sidaji bodinia ija'ari vaipohikia vanokhaha ada Jesus kaikahina. Oniaroa, ni-o'oijanaki ada Jesus sidajia. Amasia, ibavi kagorariki kania hoja'aha. Ibavi ipohikia avikhaonaninanibakhia'aha adani ija'ari Jesus kani-ra avanikhaha'avini. ");
INSERT INTO padNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hari. Mahi hoariha Cafarnaum sidajia ajoi'aha ada Jesus. Jorakia okhaoni'ihi ida varani gorana bodinia hoja'ina. ");
INSERT INTO padNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hari. Vajoroni'aha adani ija'ari vaipohiki, vanaji'bini'ihi ida gora bodini. Ni-hojajanaki ida ibavi gora bodinia. Gora kaathani banininija vahojaki jaboni adani ija'ari vaipohiki. Jesus va'ora kanamonivini hi'ihi ida Deus athi. ");
INSERT INTO padNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hari. Jesus kania vavikha'aha ada makhira jo'o aba'oronisiagaki, makhira avako'bamahakhamakia vakaiba'i'aha. ");
INSERT INTO padNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gora ji'biniki ija'ari vâipohikia, ni-nihanikia makhira jo'o aba'oronisiagaki-ra avavi'oiki gora bodinia. Ni-vakaabokaki ida Jesus kania vamaakarina. Oniaroa, avavikasiha gora 'da'dini a'ani sohiriama'okia avavikasi'aha. Vana'bakhamanani'ihi ida gora 'da'dini a'ani, kharani'ihi, jorai damomisikia avanahiririrari'aha ada makhira Jesus viaha. ");
INSERT INTO padNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus abono-ra ni'aha: —Vakajari'darihi hida makhira jo'o aba'oronisiagaki-ra oanaihotavini-ra okaabokavini. Oniaroa, makhira kavamoniki-ra ni'a'aha: —Kodisai. 'Bira'iki ida kadahojai asohiriki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hari. Vavithiriahana vakaroiribani'aha adani judeus kaija'ari vaka'ojomo'iva abono. Vaabono vani'a'aha: ");
INSERT INTO padNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Jahariki ida Jesus kavarani. Deus ka'oa bikaabokaki ida hojai asohiriki na'birani. Deus hiriha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesua biogaki ida vakava'ibodivaranivini, va'ora ni'aha: —Jahariki ida kodivarani-ra avakajari'davini. ");
INSERT INTO padNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Oanaihotaki bana ada makhira. Oanaihotavini avanokiha; avarigaki jaboni ida kidihojai asohiriki ona'bira'avini okaaboka'avini. ");
INSERT INTO padNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Deus hora karonavini hiki ija'ari kahojai asohiriki-ra ona'biravini. Hovani ija'ari hahavi vakadi'aajo ho — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Hari. Makhira jo'o aba'oronisiagaki-ra ni'aha: —Gaa'a! Ijorani-ra nabiini'a, igorania okha'a bana! ");
INSERT INTO padNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hari. Vanokivini kaba'i, jorakia aihota'aha ada makhira. Gaa'aha, jorana-ra nabiini'aha, gorana okha'aha. Oniaroa, ija'ari vanokiva vakava'ibodivaranikaraho'aha. Deu-ra khai vani'a'aha: —Jaha'oamanija hida Deus kabadani anokibiininiki hidakaba'i. ");
INSERT INTO padNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hari. Ajihi'ianaha ada Jesus. Galiléia ka'dakonia okhanai'ianaha. Ija'ari vaipohiki vajoroni'aha kidiania, va'ora ka'ojomo'i'aha. ");
INSERT INTO padNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Adahana kaba'i binokiha ada Levi. Alfeu kaisai ada Levi. Imposto gathaniva abono ada Levi. Imposto kajinironi ida arabo kaka'da'dini kabadani kaimoni. Hari. Imposto kagorania vithi'aha ada Levi. Jesua bini'a'aha: —Hora vaipohiha'a bana. Gaa'aha ada Levi, Jesu-ra vaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Oniaroa, naothinia, Levi gorana avikha'aha adani Jesus, vakaikahi'aha, avikhajakosi'aha. Vi'baiha adani Jesus, kidipohi khama. Vi'baiki kidiania jaboni adani imposto gathaniva abono vaipohiki. Vakadiania vahojaki jaboni adani ija'ari hojai jaharikia vakahojaiki. Va'oaniaro Jesu-ra vavaipohihaki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hari. Judeus kaija'ari vaka'ojomo'iva abono va'ora vanokiha adani Jesus vi'baijabanaki. Farisio vihiki adani ija'ari ka'ojomo'iva abono. Farisio va'ora vanokiha adani Jesus vi'baijabanana, Jesus ipohina-ra va'ora vanana'dohi'aha: —Niha nimanira ada Jesus 'baijabanaki imposto gathaniva abono vakadiania? Hojai jahariki namonahava abono vahoariha vakadiania 'baijabanaki jaboni ada. Akadihojai hipa'itxirihi hida a'baina vakadiania — Jesus ipohina-ra va'ora vani'aha adani farisio. ");
INSERT INTO padNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesua bikamitha'ihi ida vakadina'dohi. Va'ora ni'a'aha: —Onofiki ida va'ora oakava'ijoavini, oniani ida vakadiania hora no'baijabanaja. Kavamoni vani fori hija ida ija'ari kahojai asohiriki. Ni-va'ora obaranahaki adani hojai asohikia vakahojaiki. Mijiko fori ohiki ho. Vakavamoniki vani adani mijiko-ra vanofira. Vakavamonirikia ni-vanofiki ada mijiko. Hojai asohirikia vakahojaiki vani hadani va'ora obaranahara vakava'ipahinija kaimoni ida vakadihojai asohiriki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hari. João Batista ipohina ni-mahi hahavi vi'baiki. 'Bai-ra vavahojavini kaba'i, vi'bairina vahojana Deu-ra vara vani'ara kaimoni. Farisio vahojana hiki ida jaboni. Hari. Vahoariha vani'aha ada Jesus: —Vi'bairina vahojaki adani João ipohina, farisio khama, Deu-ra vara vani'aka'oara kaimoni. Vahojana oamani oni. Kadaipohi vakadihojai hirihi hida. Niha vakhanimanira adani kadaipohi vi'bairina vahojariki Deu-ra vara vani'aka'oara kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Oniaroa, Jesua bigathanihi ida vaathi: —Vakadiania ohojahaha'oadahana mani ida vi'bairina va'ora nahojarija. Maisa fori ohiki ho. Kanori abono ihinika kania vahojana vani fori vihira adani oipohina. Vi'baijahakiki adani kanori abono. Onivani fori vihira adani oipohina. ");
INSERT INTO padNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Khaki bana ida mahi vakadiania oakara'ona kamahini, oniaroa, ni-'bai havahani-ra vanofiki mahi hahavi Deu-ra vara vani'aka'oara kaimoni — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hari. Jesus va'ora ni'aha: —Vakava'ipahinika'oa bana ida avakadihojai 'bo'da mahija kodihojaia avakahojaivini. Ni-kabodihadihaki ida hojai 'bo'da kodihojai jahakia. Ija'aria ni-biakarabajaki ida makari 'biraki makari pitani ja'biriri'iarikia. Makari pitani ja'dinia akarabajaja vaha; sokoahi ida makari, ja'biririmanihi vaha ida pitani ja'dini, 'bira'ianahi vaha ida makari 'bo'da; a'ahapimanihi vaha ida makari 'birani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hari. Jesus va'ora ni'aha: —Vakava'ipahinika'oa bana ida avakadihojai 'bo'da mahija kodihojaia avakahojaivini. Ni-kabodihadihaki ida hojai 'bo'da kodihojai jahakia. Ni-ija'aria binaibaviki ida vinho ja'dini igitha asafini 'bo'da bavi hikia. Thoromanihi ida vinho ja'dini. 'Dakhaki ida baasafi kabavihi 'bo'da, ni-abitxajanaki. Ija'aria binaibavija vaha ida vinho igitha asafini 'bo'da; aka'bararakhamamanihi vaha; kavithimamanihi vaha ida vinho. Ni-jahajanaki ida bavi. Ija'aria binaibaviki ida vinho ja'dini igitha asafini ja'dini bavi hikia. Ni-aka'bararakhamajanaki ida igitha asafini, ni-ahovarijanaki ida vinho — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Hari. Oniaroa, judeus kaija'ari vakadi'akoiri kamahini vani, avikafianiribani'aha adani Jesus trigo kasiroinia. ");
INSERT INTO padNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Oniaroa, farisioa vanoki'ihi ida Jesus ipohina trigo bononi-ra varisivini, vani'aha ada Jesus: —Deus kava'isohihi jiriki ija'ari-ra honariavini hiki ija'ari bada nirini aakoirina kamahini. Nahina mani ida iipohini Deus kava'isohihi jiriki-ra vanaabaravini hija? ");
INSERT INTO padNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesua bigathanihi ida vaathi: —A'onira vara oni'avini hiki ada Davi kohana. Deus athi kapapirania hojaki ida Davi varani hina. 'Bo'dakari vavai'ami'aha adani Davi kohana kidipohi khama, ni-vavahojaki ida vakadi'bai. ");
INSERT INTO padNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Oniaroa, Deu-ra khai vani'avini kagorani kania avikhajakosi'aha adani Davi. Hari. Gora bodinia kahoja'iki ida pão sasidotxia ka'oa vakahaki kaimoni. Sasidotxi Deu-ra kanava'iga'imidiavini kihiki ida pão. Sasidotxi vaoniki adani Deus kabadani abono. Davi kohana hokina kari, Abiatar oniki ada sasidotxi vaka'da'diva. Deus kava'isohihi jirikia bini'aha: “Sasidotxi ka'oa vakahaki kaimoni ida pão Deu-ra khai vani'avini kagorani bodinia kahojaki.” Nimania ida Deus kava'isohihi jiriki athini. Sasidotxi vihiriha adani Davi kohana kidipohi khama. Kaba'i, Davia bikahaki ida pão gora bodinia kahojaki. Kidipohi-ra va'ora no'avini kihi'ihi jaboni. Ni-Deua bivajahariki ida pão-ra vakahavini. ");
INSERT INTO padNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Oniaroa, Jesus va'ora ni'aha: —Ija'ari vakadimoni ida akoirini kamahini Deua binamonahaki. Aakoirina kamahini kaimoni hirihi ida Deus ija'ari-ra namonahavini. ");
INSERT INTO padNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hovani ija'ari hahavi vakadi'aajo ho. Hovani ka'oa oogaki ida badani hana hini jahaki ija'aria bada bini'aki kaimoni aakoirina kamahini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hari. Oniaroa, okha'ianaha ada Jesus judeus kaija'ari Deu-ra vara vani'avini kagorania. Okhajakosi'aha. Hojamaniha ada makhira sa'a akasakarabakosiki. ");
INSERT INTO padNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Vahojaki jaboni adani ija'ari Jesus kabadani-ra vavajahariki. Vavajaharihi hida Jesus ija'ari kavamoniki-ra anaihotavini avakoirina kamahini, oniani ida Jesu-ra vada vani'avini hihi. Bianaihotaha; Jesu-ra vakaihamahi'aha. Vanofiki ida Jesu-ra avanaathidanoararivini: —Inaabariki ida Deus kava'isohihi jiriki. Ni-biva'ahaki ida ija'ari kavamoniki-ra ianaihotavini aakoirina kamahini. ");
INSERT INTO padNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Oniaroa, Jesua bini'aha ada makhira sa'a akasakarabakosiki: —Gaa'a. Hida kha kodiania. ");
INSERT INTO padNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesus va'ora nana'dohi'aha adani vahoariha: —Nahina mani ida papira athinia Deus ija'ari aakoirina kamahini va'ora vara vani'avini hija? Hana hini badani koda ida Deus kava'isohihi jiriki haria va'ahavini hija aakoirina kamahini? Biva'ahamanija koda ida hoariha-ra aakodiavini? Ha'a. Biva'ahamanija koda ida hoariha-ra ava'adiravini? Iniani. Biva'ahamanija koda ida hoariha-ra aakava'ijoavini? Ha'a. Biva'ahamanija koda ida hoariha abinini. Iniani. Hana hini badani ida Deus kava'isohihi jirikia bihonariaja aakoirina kamahini bada ani'avini? — va'ora ni'aha ada Jesus. Ni-nahina Jesus athi-ra vagathani'iki. Viso vakhani'oamaniha adani ija'ari. ");
INSERT INTO padNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Oniaroa, va'ora vada ni'aribani'aha ada Jesus, ihamahi'ina. Ija'ari-ra vava'adiravini mani ida Jesus va'i-ra mokara ni'a'ia. Makhira-ra ni'aha: —Isa'ani-ra akanavira'a. Sa'a-ra akanavira'aha, akaihota'ihi ida sa'a. ");
INSERT INTO padNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Oniaroa, judeus kaija'ari Deu-ra vara vani'avini kagorania avikhaonaniha adani farisio, Iroji ipohina khama. Jesus makhira-ra anaihotavini mani ida vava'i najokojokoni hija. Vaabono vara vakani'akhama'aha: —Ni-jahapa'itxiki ida ija'ari kavamoniki aihotani kabadanihia kabadanina aakoirina kamahini. Niha ani'a'aki koda ada Jesus. Abinina jahaki ada — vakhani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Oniaroa, ai vihi'aha adani Jesus, ipohina khama. Galiléia ka'dakonia avakhanofoniha. Avikharafonisiagaha adani ija'ari vâipohiki Jesus vanaothia Galiléia kaaraboni kaija'arini, Judéia kaaraboni kaija'arini, ");
INSERT INTO padNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalém sidaji kaija'arini, Iduméia kaaraboni kaija'arini, Jordão vaini oniki banininija kaija'arini, Tiro sidaji 'dihani kaija'arini, Sidom sidaji 'dihani kaija'arini vihiki avikharafonisiagaki Jesus vanaothia. Vahihavifoni'aha adani ija'ari vâipohiki vajoroni'ina. Jesus kabadani varani hini-ra vakamithavini mani ida va'ora rakhaonanihahavija Jesus kania. Va'ora anaihotaha adani ija'ari vaipohiki. ");
INSERT INTO padNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Vakavamonikia vanofiki ida Jesu-ra vakaabadavini, avaihotara kaimoni. Ija'ari vaipohikia vakaabadabadarisahakhamaha ada Jesus vakahararahakhama'aha, ara'ara'aha ada Jesus. Oniania, Jesus va'ora nava'isohiha adani kidipohi: —Vakavikha oni kanava mahija kamaakarivini. Hora vana'ara'araki hadani ija'ari vaipohiki. Oki'damana-ra onofiki ho. ");
INSERT INTO padNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ija'ari vaipohiki vahararana vahojaki jaboni adani ija'ari vakabajadiki. Kabajadikia binokiha ada Jesus, adari'aha Jesus viaha, bodi'baraha: —Ivani Deus kaisai i — Jesu-ra ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Oniaroa, Jesua bini'aha: —Hari'a va'ora nanamitha Deus kaisai ohina — bajadi-ra kaabanidanoki'aha ada Jesus. Onivani fori vihiha adani vakabajadiki vahoariha vaakaikahirisahakhama'ina. ");
INSERT INTO padNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hari. Oniaroa, ajihi'aha ada Jesus. Arabo namahikia ogaimori'aha. Jesus va'ora baranaha'aha adani makhira va'ora nofiki kidiania vikhara kaimoni. Athi vanaaba'aha, avigaimoriha Jesu-ra vanamaakari'aha. ");
INSERT INTO padNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Va'ora nagathogatho'iki adani 12 makhira vaipohina, va'ora naonivini athi avavaadahaoniva abono. Va'ora ni'aha: — A'onira onagathogatho'iki ho hora avavaipohihaja kaimoni. A'onira okaronaki bana ho ija'ari-ra avakanamonija kaimoni omonina jahakia. ");
INSERT INTO padNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","A'onira ono'aki bana ho odanona. Ija'ari vakabajadiki-ra avanokihi; bajadi-ra vahonaria bana akara'oja kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Hi'adani 12 vihiki vaonina Simão, Tiago, João, André, Filipe, Bartolomeu, Mateus, Tomé, Tiago, Tadeu, Simão Zelotes, Judas Iscariotes vihiki adani. Jesus Simão-ra no'avini onii hoariha Pedroa. Zebedeu kaisai vi'bamiki Tiago, João vihiki va'ora no'avini onii hoariha Boanerges. (Boanerges ariathia Bahi Tararahaki.) Tiago hoariha Alfeu kaisai. Badara ahoarabakosiki radaha'ihi naothinia, Judas Iscariotes va'ora kakodiaki bana adani Jesu-ra vanaabinivini-ra vanofiki. ");
INSERT INTO padNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hari. Joi'aha ada Jesus gorana. Ija'ari vaipohiki vajoroni'ianana mani ida Jesus, ipohina khama va'ora kano'baiharija. ");
INSERT INTO padNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesus igamina vakamitha'ihi ida varani hina, vaabono vakani'akhama'aha: —Anikhava ada arigamina mahija agorana hoja'avini. Ija'aria kabajadiki vavanihaki ada. ");
INSERT INTO padNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Oniaroa, vakhaniha adani judeus kaija'ari vaka'ojomo'iva abono Jerusaléa vikha'iki. Vakhaniha: —Bajadi vakadika'da'di Biosibo Jahari onikia Jesus va'i-ra nahonariahihivini. Biosiboa bino'aki ada Jesus danona, bikaabokaja kaimoni ida bajadi akara'o'ini — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oniaroa, ija'ari-ra baranaha'aha ada Jesus kidiania. Va'ora ni'aha: —Rajomi kavaranihi-ra vara ovani'aki bana ho, avarigaja kaimoni ida Biosibo Jahari hora no'aravini danona. Ni-ova'i-ra nahonariahihiki ada Jahari. Ova'i-ra nahonariahihira vaha; ni-abono-ra vahonariahiki akara'ona. Ni-Jahari akara'ona abono-ra vahonariahiki. ");
INSERT INTO padNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Arabo kaija'arini vaabono vakodakhamaha; vaabono vakanihimakhamaha. ");
INSERT INTO padNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Gora kaija'arini vaabono vakodakhamaha; vaabono vakanihimakhamaha. ");
INSERT INTO padNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Vakhaniha vaha jaboni adani Jahari kaija'ari vanokiariki. Vaabono vakodakhamara vaha; vaabono vakanihimakhamaha vaha jaboni, ni-vahojajanaki vaha adani kidija'ari, Jahari va'ora vaka'da'diki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Makhira danoki fori hiki ada Jahari. Ija'aria ni-bikaabokaki ida nahina makhira danoki gorana bodinia hojaki-ra saarivini. Makhira danoki-ra daboha'imidiaki ida ija'ari, oniani ida kidinahina ipohiki bisaarivini bikaabokavini hija. ");
INSERT INTO padNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ka'oa oamani ida oni'aki. Deua bikaabokaki ida hojai asohiriki-ra na'biravini. Ija'ari varani jaharikia Deu-ra vakanavaranihavini, Deua bikaabokaki ida varani jahariki-ra na'biravini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ija'aria Jahari kabadani hini bikahihi ida Ma'onahai Jahaki kabadani, jokoa Deua bina'birarihi ida ija'ari kavarani jahariki. Ni-Deua biakava'i'biriniki ida varani. Mahi hahavi ni-biakariakapa'itxiki. ");
INSERT INTO padNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Anokhomi'ihi ida Jesus kavarani. Jesus va'ora kaabanidanokivini hi'ihi ida kabajadina vakahivini. ");
INSERT INTO padNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Oniaroa, vikhamai'aha adani Jesus kaamia, kidikajo'o vihiki. Gora banininia vigaaboaha'aha. Jesus baranahi hina-ra vavahonariahi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ija'ari vaipohiki vavithiriahaki vahararana vabodi pana hojaha ada Jesus. Oniaroa, Jesu-ra vanava'isohi'aha: —Jesus, adani gora 'dihania vahojaha kadamia, kadakajo'o vihiki. Ira vibaranahaki adani. ");
INSERT INTO padNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus va'ora ni'aha: —A'onira onanokiahivini hiki hadani kodiamia kodikajo'o ka'oa vihiki. ");
INSERT INTO padNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Oniaroa, Jesus vada va'ora ni'aribanaonivini adani ija'ari vavithiriahaki, va'ora ni'aha: —Kodiamia, kodikajo'o fori avihiki a'oni. ");
INSERT INTO padNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ija'aria binofihi ida hojai jahaki kodiabi'i nama hojakia bivajahaki; binaabahi jaboni ida kodiabi'i athi; kodiamia, oigamina fori vihiha. ");
INSERT INTO padNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hari. Mahi hoariha Galiléia ka'dakoni vadini maakarinia okharafoniha ada Jesus. Ija'ari vaipohiki vavajoronivini mani ida naki'damana hija kanava. Aakhanaipa'itxiha ada Jesus, kanava vithi'aha, va'ora ka'ojomo'i'aha adani ija'ari pasapasania vahojaki. ");
INSERT INTO padNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Rajomi kavaranihia va'ora vara ni'a'aha: ");
INSERT INTO padNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Mitha vani'a. Siroia okhaha ada makhira binatxiotxiohi ida trigo 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hagihi vadinia vararahi ida 'ba'dani hoarahanana. Avigariha adani igitha vitxagatxagahahavi'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ja'di namania vararahi ida 'ba'dani hoariha. Abihiarihi ida nami ja'di namania. Odorihi ida nami, movajoraki'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","'Damani abohani abihiarini mani ida safini afana bianara'okhovini hija. ");
INSERT INTO padNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hogoi kajaroiki kania vararahi ida 'ba'dani hoariha. Movahi ida jaboni hogoi, rakhajahi-ra najahari'ihi, ni-bono'iki. ");
INSERT INTO padNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Arabo jahakia vararahi ida 'ba'dani hoariha. Movahi, avijavahi, bono'ihi. Aipohi'ihi ida trigo 'ba'dani. Trigo avani hoarahanana bononi 'ba'dani ipohini 30. Trigo avani hoarahanana bononi 'ba'dani ipohini 60. Trigo avani hoariha bononi 'ba'dani ipohini 100. ");
INSERT INTO padNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hari. Kidirajomi kavaranihi anokhomi'ini, va'ora ni'aha ada Jesus: —Avamorobohahi; mitha vani'ajahaki bana hida kodivarani. ");
INSERT INTO padNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hari. Ija'ari vaipohiki vahojajanarina, Jesu-ra vani'aha adani ipohina vahoariha khama: —Ni-aogajahakiki ida rajomi kavaranihia ikavaranini. Haria nanamithajahaki bana — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus va'ora ni'aha: —Deua binofiki ida avarigavini, oniani ida Deus ka'da'di hina kavaranihia a'onira onanamithajahakivini hija. Ija'ari vahoariha ni-avigavini vanofiki ida varani Deus va'ora vaka'da'divini. Vakadiania vara ovani'aki ida rajomi kavaranihi, avigajorakiria kaimoni hida kodivarani. ");
INSERT INTO padNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Oathi-ra mitha vani'avini kaba'i, ni-nahina hini avigaki. Avigaja vaha ida Deus athi nahina hini; Deus kania vaabono gahinai vanihamaniha vaha; vakadihojai asohiriki-ra vakava'ipahinika'oamaniha vaha, Deus bina'biramaniha vaha ida vakadihojai asohiriki. ");
INSERT INTO padNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Oniaroa, asia vara niha ada Jesus: —Avarigarihi hida rajomi kavaranihi hoarani, nihanikia koda avarigaki ida rajomi kavaranihi hoariha afohahavi? ");
INSERT INTO padNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Oniaroa, Jesus va'ora nanamithavini hi'ihi ida rajomi kavaranihi: —Trigo 'ba'dani txiotxioni vani fori hija ida Deus athi kavaranihi. Deus athi fori hiki ida trigo 'ba'dani. Vara bivani'ahi ida Deus athi, trigo 'ba'dani-ra natxiotxiovini vani fori hihi. ");
INSERT INTO padNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hagihia vararahi ida trigo 'ba'dani. Igitha vaha'ihi. Onivani fori vihira adani ija'ari vahoarahanana Deus athi-ra vakamithaki. Hari. Oniaroa, khaki ada Jahari Deus athi-ra anihavini va'ini bodinia, oniani ida Deus athi-ra vakava'i'birinivini hija. ");
INSERT INTO padNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Ja'di namania vararahi ida trigo 'ba'dani hoariha. Kanamini odorini movajoraki'ihi. 'Damani abohani abihiarini mani ida anara'okhoni hija. Movani kama'dani vani ara'okho'ihi. Onivani fori vihira adani ija'ari vahoariha Deus athi-ra vakamithaki. Vanofihi, khai vakhanimaniha. Mahi ipohiriki vani khai vani'aja ida Deus athi. Deus kaija'ari vihina kama'da'ini mani ida vahoariha va'ora vanajahariharivini hija, oniani ida Deus athi-ra vakava'ipahinivini hija. ");
INSERT INTO padNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Hogoi jaroki 'damania vararahi ida trigo 'ba'dani hoariha. Hogoia binajaharihi, bonohi, ni-a'diki ida trigo bononi. Onivani fori vihira adani ija'ari vahoariha Deus athi-ra vakamithaki. Vakava'ibodivaraniha'oadahahi ida vakadi'bai-ra vanako'dihavini, vakadinahina-ra vakapavakarihavini, vakadibadani hiki. Vakadinahina aipohini-ra vanofiki adani. Jiniro-ra vanofikarahovini mani ida Deus athi-ra vanofijahakiravini hija, oniani ida Deus athi-ra vanaabaravini hija jaboni. Onivani fori hija ida rakhajahi, ni-bono'iki. Onivani fori vihiki adani ija'ari vamorobohariki fori vihina. ");
INSERT INTO padNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hari. Arabo jahakia makhira binatxiotxiohi ida trigo 'ba'dani hoariha. Movahi, na'baha'ihi, bono'ihi. Aipohi'ihi ida 'ba'dani. Arabo jahaki fori vihiki adani. Onivani fori vihira adani ija'ari vahoariha Deus athi-ra vakamithaki. Vakamithahi, avigahi ida Deua binofiki bada vani'avini, oniani ida vanaabajahakivini hija. Trigo 'ba'dani 30 hiki vani fori vihira adani ija'ari Deus athi-ra vanaabavini pa'itxini. Trigo 'ba'dani 60 hiki vani fori vihira adani ija'ari Deus athi-ra vanaabavini doronini. Trigo 'ba'dani 100 hiki vani fori vihira adani ija'ari Deus athi-ra vanaabajahakiki. ");
INSERT INTO padNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hari. Jesus va'ora vara ni'a'ianavini hihi ida rajomi kavaranihi hoariha. Jesus va'ora ni'aha: —Lamparina vagani fori hiki hida kodivarani. Gora vagani-ra anofihi; ni-si'aha akaasiaki kabodinia anahojaki ida lamparina, ni-cama kanabo'ania anahojaki jaboni. Gora bodini nama vania anahojahi ida lamparina, vagaja kaimoni ida gora bodini. ");
INSERT INTO padNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hidakaba'i ahojaki ida ija'ari kava'ibodivarani. Khaki ida mahi kodivarania binanokiaki bana ida ija'ari kava'ibodivarani, nahina hoarani ahojajanaria kaimoni. Vagani kania hojani fori hiki ida. ");
INSERT INTO padNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Avamorobohahi; mitha vani'ajahaki bana hida kodivarani. ");
INSERT INTO padNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mitha vani'ajahaki bana hida kodivarani mahija avarigajahaki'avini. Hari'a va'ora anaathidanoarari bana adani vahoariha Jahari kabadania vakabadanina, avarigaravini oadani vanamonahavini vanamonaharavini. Va'ora avaranaathidanoarariha; Deus a'onira anaathidanoararihi bana jaboni. Deus a'onira anaathidanoararivini arafiaki bana a'oni. ");
INSERT INTO padNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Oathi-ra avanaabahi; Deus a'onira kakodiahi avarigajahakija kaimoni ida kodivarani. Oathi-ra avanaabarihi; avarakava'i'birinihi ida pa'itxi avariga'iki — va'ora ni'a'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Rajomi kavaranihi hoariha va'ora vara ni'avini. Jesua bini'aha: —Ba'ba'da avijavani vani fori hini hida Deus ija'ari-ra vaka'da'divini. Ija'aria bikarakhaihi ida jaro'oa ka'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ni-biakogaki ida kidiba'ba'da niha khanikhanini kamovani, kavijava'ini. Bikarakhaivini naothinia joma vadihi, mahia nokihi. Binokha'ihi ida kidirakhajahi mova'ini, karaho'ini. Ni-biakogaki ida jaro'oa kavijavani niha khanikhanini. Ni-biakogaki jaboni ida kabono'ini niha khanikhanini. Biogaravini kaba'i namitha'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Araboa mova'ihi ida kidiba'ba'da, jahahi, bono'ihi. Afani afo'imidia nokiaki naothinia avani maina hida avijavahi. Karaho'ihi, mova'ihi, bono'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na'baha'ihi ida bononi, a'di'ihi, aniani kamahini a'boahahavihi ida avani — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hari. Vara ni'a'ianaha ada Jesus: —A'onira vara oni'avini hiki ida bana rajomi kavaranihi hoariha. Mostarda 'ba'dani avijavani fori hiki ida Deus ija'ari-ra vaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Itxanini arafiaki ida mostarda 'ba'dani. Ija'aria birakhaihi ida mostarda 'ba'dani kidisiroia. Movahi, avijavahi, karahoki ida mostarda avani. Patxapatxahaki ida. Vadini avijavani na'bahaki jaboni. Igitha raboki kagorahaki vadinia afani hararania. Itxanini arafiaki ida ba'ba'da, kaba'i, mostarda 'ba'dani movahi, avijava'ihi, karaho'ihi — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rajomi kavarani ipohikia kavaraniha ada Jesus. Binofiki ida ija'aria kidivarani vakamithavini, avigajahakija kaimoni nahina hini. ");
INSERT INTO padNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rajomi kavaranihi ka'oa-ra vara vani'aki ada Jesus. Ija'ari vaipohiki vahojajanarina, ipohina-ra va'ora vara ni'ahahavivini hi'ihi ida kidivarani nahina hini, avigajahakija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hari. Mithani asia mani kanava kabodinia hojaha ada Jesus. Hari. Ipohina-ra va'ora ni'aha: —Aakakafiani'ava. ");
INSERT INTO padNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hari. Va'ora vakaamina'aha adani ija'ari vaipohiki, vaki'dama'aha adani Jesus, ipohina khama. 'Dako pitanija Jesu-ra avakavikafiani'aha. Kanava kaipohiki aakafianisiagaki. ");
INSERT INTO padNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hari. Avakakafianina kaba'i, kama'da'ihi ida sirisiriki danoki. Komini kana'bahakia biakapahakaraho'ihi ida kanava. ");
INSERT INTO padNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hari. Vadisiaga'aha ada Jesus. Ka'da'di kanabo'ania kahojahi ida 'da'dijora. Avikhamahana'aha adani Jesus ipohina kidiania. Vakananokiaha'aha: —Jesus, Jesus. Haria akava'ijoa bana! Aahidananaki bana hari! Haria koda inakaidivaria? ");
INSERT INTO padNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nokho afora'aha. Gama'aha, bikaabani'ihi ida sirisiriki, komini kihiki. Jesua bini'ahi: —Radaha'a! Radaha'ihi ida sirisiriki. Karadaha'ihi ida komini kana'bahaki. ");
INSERT INTO padNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ipohina-ra va'ora kani'a'aha: —Niha avakhanimanija avaofiniki? Deu-ra vavakaijoka bana! Avakajari'damanija ida Deus a'onira akadava'avini? — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Komini jorakia karadahani mani ida va'ora naimahidaja. —Makhira ka'oa hiriha hada. Ni-anoki'iaki kaho ida ija'ari hoariha ovari fori hiki sirisiriki, komini kihikia athi bikamithaki — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hari. Galiléia 'dakoa avakakafianiha adani Jesus. Gerasa kaarabonia avako'omisi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Avigaimori'aha. Oniaroa, Jesu-ra karagarariha'aha ada makhira kabajadiki 'dama kania khanaina. ");
INSERT INTO padNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ja'di kahodijama'oki bodinia ibaviki ada makhira kabajadiki. Ija'aria vagathibakhiaha, vanofiki ida vanaahovini correntea, ni-vakaabokaki ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bikana'bararaharahabakhiamanihi ida corrente sa'a, 'dama hiki kodabohabakhiani hiki. Ni-nahina bikaabokaki ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mahi oadani, joma oadani, 'dama kania adahana, arabo namahikia adahana jaboni, bodi'baraha'aha, abono-ra vasiinanaha'aha ja'dia. ");
INSERT INTO padNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hari. Kabajadikia napaja bianokiha ada Jesus. Ki'darahaha'aha, kajo'atharari'aha Jesus viaha. ");
INSERT INTO padNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesua bini'aha: —Bajadi, akara'o'a! Kabajadikia bini'aha bodi'barahana: —Jesus, nahina hida kodiania inofija? Ivani Deus danoki nama hojaki kaisai i. Deus onina ira okanikhariaki bana ho. Hari'a jaharikia haria arakha bana. ");
INSERT INTO padNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesua binana'dohiha ada makhira kabajadiki: —Nahina ionija? Bigathanihi ida Jesus athi: —Oonina ipohiki. Bajadi vâipohiki hora vagathivini mani ida ija'ari hora vanaonivini hija Îpohikia. ");
INSERT INTO padNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hari'a va'ora karona bana ibavi hoariha avikhana — Jesu-ra ni'a'aha ada makhira kabajadiki. ");
INSERT INTO padNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hari. Arabo namahikia vahojamaniha adani hirari vaipohiki vi'baiki. ");
INSERT INTO padNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bajadi Jesu-ra vakanikhariadanoki'aha: —Haria karona'a hirari vakadiania mahija haria vavaadaha'avini. ");
INSERT INTO padNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Vaadaha'a! — Jesus va'ora ni'aha adani bajadi. Hari. Makhira kania vakara'o'aha adani bajadi, hirari-ra vagathi'aha. Hirari vaipohina 2 mil. Vâipohi'oamanira adani hirari. Vaki'darahaha'aha, avikharafoniha, arabo a'domarariki kania avaki'dafafoni'aha, avahidana'aha. ");
INSERT INTO padNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Oniaroa, vaofini'aha adani makhira hirari-ra avakadava'aki, aviga'aha. Ija'ari vaibavia avakhano'aha, va'ora vakanamoni'aha hirari vapohimaja'ina. Ija'ari gorania vakaikahinana'aha, va'ora vakanamoni'aha. Oniaroa, moni kamithava va'ora vanavanavanaha'aha adani hirari vapohimaja'iki. ");
INSERT INTO padNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus kania avikhaha. Vanoki'aha ada makhira kabajadijanarina. Jahana vani vanoki'aha. Vithina, kamakari'ina jaboni vanoki'aha. Ni-kabajadijanaki. ");
INSERT INTO padNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hirari-ra avakadava'aki va'ora vani'aha adani vaavanavanahaki: —Anoki'iki ada Jesus makhira kabajadiki-ra anaihota'avini. Va'ora anoki'iki adani hirari vapohimaja'ina. ");
INSERT INTO padNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hari. Gerasa kaaraboni kaija'arini adani moni-ra vakamitha'iki. Vakava'ibodivarani'aha. Jesu-ra vifini'aha. Vani'aha: —Ajihi'a bana akadiaraboa. ");
INSERT INTO padNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hari. Ajihi'aha ada Jesus. Ki'damana kaba'i, kabajadijanariki Jesu-ra kanikhariadanoki'aha: —Onofiki ida kadania ookhana. ");
INSERT INTO padNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesua bini'aha: —Iniani. Igorania ajoi'a bana mahija kadaija'ari-ra va'ora vara ini'avini hini hida Deus ira kajoamoravini, Deus ira va'adivini. ");
INSERT INTO padNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Oniaroa, ajihi'aha ada makhira Decápolis kaaraboni kaija'arini-ra va'ora kanamonivini hi'ihi ida Jesua bikajoamora'avini, oniani ida ija'ari hahavi Jesu-ra vakava'ibodivaranikarahovini hija. ");
INSERT INTO padNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hari. Oniaroa, avakajoifianiha adani Jesus kidipohi khama. Avako'omisiha, vahojamaniha adani ija'ari vaipohiki Jesu-ra vanokhavini kaasia. Oniaroa, Jesus kania okha'aha ada makhira Jairo oniki. ");
INSERT INTO padNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Judeus kaija'ari Deu-ra vara vani'avini kagorani kakadava'ava abono ada Jairo. Va'i bodinia abono-ra ni'aha: —Ka'da'di oamani ada Jesus, — oniani ida Jesus viaha nakajo'athararina hija. ");
INSERT INTO padNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jesu-ra kanikhariadanoki'aha ada Jairo: —Onofiki bana ida ogorana iokhani. Kodisai kavamonikarahoki. Abinihani amaakariki ida. Kodisai-ra kaabadaha bana mahija aihotavini — niha ada Jairo. ");
INSERT INTO padNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Oniaroa, Jesus khama avikha'aha. Avikhaha adani ija'ari vaipohiki jaboni. Vaadahana kaba'i, Jesu-ra vaka'dokho'dokhorisahakhamaki. ");
INSERT INTO padNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hari. Ija'ari vahararana hojajabanaki ida gamo kavamoniki. 12 badara ipohini amani aforarini hojahi ida gamo. ");
INSERT INTO padNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mijiko vaipohikia vanaihabakhiavini kaba'i, ni-aihota'iaki. Mijikoa vavaima'bana'ahapikihi ida gamo. Bivaihimi'imarini'ihi ida kidijiniro. Ni-ahajanipa'itxiki. ");
INSERT INTO padNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Oniaroa, bikamithahi ida Jesus varani hina. Abononi ni'ahi: —Jesus kakarahobi-ra okadasahi; oa'aihotahi. Oniaroa, Jesus kaida-ra kanamaakari'ihi. Vahoariha vanokiravini kaba'i, bikadasahi ida Jesus kakarahobi. ");
INSERT INTO padNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jorakia afora'ihi ida amani. Aihotani-ra oga'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hari. Jesua bioga'ihi ida hoarani aihota'ini. Biogaki ida danona ija'ari-ra najaha'avini. Roiribani'aha, va'ora nana'dohi'aha adani ija'ari: —Hana hini mani ida kodikarahobi-ra kadasaja? ");
INSERT INTO padNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ipohina avigarihi ida gamo jaha'ini, Jesu-ra vani'aha: —Va'ora inokirara adani ija'ari vaipohiki ira vaka'dokho'dokhohahaviki. Nahina kaimoni mani ida haria inana'dohivini hija kadakarahobi kadasahi hinia? ");
INSERT INTO padNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus naothi-ra nokiribani'aha, biogaja kaimoni ida kidikarahobi kadasini hiki. ");
INSERT INTO padNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hari. Jahani-ra oga'ihi ida gamo. Jesu-ra namaakarihi imahidani, jaroni tharararahani. Jesus viaha 'bisoni'ihi, binanamitha'ihi ida aihota'ini. ");
INSERT INTO padNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Oniaroa, Jesua bini'a'ihi: —Oigamina, hora ikajari'daravini mani ida ira anaihota'ia. Adaha'a bana, iva'ini jahajaha'ini. Jesu-ra kaamina'ihi, ajihi'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hari. Oniaroa, vara nina kaba'i ada Jesus, Jairo kahonai abono vaipohiriki vakhano'aha. Jesu-ra vakaragarari'aha, vani'aha: —Ida abini'ihi kadaisai. Ni-nahina kaimoni iavikhajanariha o Jesus — Jairo-ra vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesua bikamithamanihi ida vakadivarani. Oniaroa, Jairo-ra ni'aha: —Hari'a ofini. Hari'a jari'da! ");
INSERT INTO padNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hari. Jesua binofirihi ida ija'ari vaipohiki gora avikhana kidiania. Va'ora va'ahaki adani Pedro, Tiago, Tiago kakajo'o João vihiki ka'oa avikhana kidiania. ");
INSERT INTO padNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairo gorana vakaikahi'aha, avi'oi'aha, va'ora vanokiha adani ija'ari vaipohiki saa vakhaniki, vabodi'barahana aba'oi-ra vavaasaravini. ");
INSERT INTO padNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oniaroa, Jesus va'ora ni'a'aha: —Niha avakhanimanija saa avakhani'ahapikiki? Aba'oi-ra avavaasaraki jaboni. Abinirihi oni isai, vadika'oaki oni — va'ora ni'aha ada Jesus. Jesua biogaki ida isai-ra anahokivini, oniani ida va'ora ni'avini hija: —Abinirihi oni isai. Vadika'oaki oni. ");
INSERT INTO padNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesus athi-ra vakajari'davini hiki abinirini bikahivini, oniani ida Jesu-ra vakanahahanihavini hija. Abinika'oani avigaki ida isai. Oniaroa, Jesus va'ora honaria'aha avakara'ona. Va'ora avavikhajakosiha adani isai kaamia, kidiabi'i, Jesus ipohina avahoarabakosiki vihiki. Isai aba'oni omariama'oki kania avikhami'aha. ");
INSERT INTO padNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hari. Biagathi'ihi ida isai sa'ani, Jesua bini'a'ihi: —Talita cumi. (Ariathia: — “Isai, gama'a!”) ");
INSERT INTO padNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hari. Jorakia ahoki'ihi, gama'ihi ida isai. Jaha'ini, adaha'ianahi. 12 badara ipohini-ra vahojaki ida isai. Oniaroa, vakava'ibodivaranikaraho'ihi ida Jesus isai-ra anahoki'avini. ");
INSERT INTO padNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hari. Jesus va'ora kaabani'aha: —Hari'a bana vahoariha vakadiania vananamitha'a bana hida kodibadani. Oniaroa, Jesus va'ora honaria'aha: —Vano'a bana ida isai 'baia! ");
INSERT INTO padNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hari. Oniaroa, ai vihi'aha adani Jesus, ipohina khama. Bivavijavaki kania joi'ianaha. Jesua bivavijavaki ibavi onini Nazaré sidaji. ");
INSERT INTO padNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Avakoirina kamahini vani judeus kaija'ari Deu-ra vara vani'avini kagorani kania avikhaha, Jesus va'ora ka'ojomo'i'aha adani ija'ari. Oniania, mitha vani'ahi ida kidivarani, Jesu-ra vakava'ibodivarani'aha. Vaabono vakani'akhama'aha: —Hanaja vania bika'ojomo'i'ia ida kidibadani? Hanaja vania bivikhaja ida kidi'ogahai danoki? Niha bini'a'avini koda biogaja ida badani danoki? ");
INSERT INTO padNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aogajahakiki ada. Gora namonahava abono ada. Kidiamia Maria. Jesus kakajo'o adani Tiago, José, Judas, Simão vihiki. Gamo isani kidikajo'o vihiki akadiania vaibaviki jaboni, oniani ida haria ka'ojomo'ivini-ra anofiravini hija — vaabono vakani'akhama'aha. Nazaré sidaji kaija'arinia ni-vanofipa'itxiki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Oniania, Jesus va'ora ni'aha: —Ibavi hahavi kaija'arinia vagathanijahakiki ada Deus athi namoniva abono. Kidija'aria bivavijavaki kania ni-vagathanijahakiki. Igamina jaboni ni-vanofijahakiki, oniani ida Nazaré sidaji kaija'arini hora vagathanijahakiravini hija — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nazaré sidaji kaija'arinia vakajari'daki ada Jesus, oniani ida kidibadani danoki-ra kaabokaravini hija. Ija'ari vaipohiriki vania vanofira ada Jesus. Vakajari'dariha ada, oniani ida va'ora kaabadavini, va'ora anaihotavini hija. ");
INSERT INTO padNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesua bikava'ibodivarani'ihi ida vakajari'davini. ");
INSERT INTO padNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hari. Jesus va'ora ka'ojomo'iha adani ija'ari ibavi maakarinia vahojaki. Oniaroa, va'ora baranahaha adani 12 vihiki vaipohina kidiania. Va'ora ni'aha: —Avi'bami'baminanani a'onira oakakaronanakhamaki ho. A'onira ono'aki bana ho odanona. Ai vihi'a bana. Ija'ari vakabajadiki-ra avanokihi; bajadi avakara'ona-ra vahonaria bana va'ajihira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Avadairini vani avikha'a bana. Hari'a avavikha hida bavi, 'bai bavini, jiniro hiki. Ava ka'oa-ra avavikha, avakadidadahi kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Vaakaimaha bana hida sandália ava'damania. Hari'a avavikha ida avakadimakari odoki hoariha avakadi'abosihi kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Asia vara niha ada Jesus: —Ija'ari vaibavi avakaikahihi, vanako'di bana ida ija'ari a'onira gathanijahakiki gorania. Sidaji ava'ajihirini oadani gorania vahojahaha'oadaha bana mahija avi'baivini, avavadini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hari. Ibavi kaija'arini a'onira vanofirihi; ni-vanofiki jaboni ida avakadivarani-ra vakamithavini, va'ajihi bana. Ava'ajihini viahania, vana'dara'dara bana oni khomakhomani avakadisandália hojaki. Ija'ari Deus athi-ra vakajoniki-ra avakavarajomivini ida sandália-ra avakana'dara'daravini — va'ora nava'isohiha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Oniaroa, vi'bami'baminanana ai vihi'aha adani Jesus ipohina. Avikha'aha, ija'ari-ra va'ora vakanamonivini hiki ida Jesus varani hina. Vakhaniha: —Vakava'ipahini bana ida avakadihojai asohiriki. Vanaaba bana ida Deus athi — va'ora vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Va'ora vahonariabakhiaha adani bajadi ija'ari kania avakara'o'ina. Va'ora avanaihotabakhiaha adani vakavamoniki vaipohiki. Vakabasinapa'itxivini ida vaatha, va'ora avanaihotara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hari. Ija'ari vaibavi ipohikia vakamithahi ida Jesus varani hina. Irojia jaboni bikamitha'ihi. Galiléia kaaraboni kaka'da'dini ada Iroji oniki. Ija'ari Jesus varani hina-ra vakamithaki, vani'aha: —Ada ahoki'aha João Batista kohana, oniani ida badani danoki-ra kaabokavini hija. ");
INSERT INTO padNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vahoariha vakhaniha: —Iniani. João Batista kohana hiriha ada Jesus. Elias kohana ahoki'iki ada. Vahoariha vani'aha: —Deus athi namoniva abono ada Jesus. Deus athi namoniva abono kohana fori hiki ada — vaabono vakani'akhama'aha adani ija'ari vaipohiki. ");
INSERT INTO padNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Irojia bikamitha'iki ida Jesus varani hina, abono-ra ni'aha: —Okavahonariahi'iki ida João Batista ka'da'di aka'boani. Ahoki'ina joi'oamani'ara ada João. João Batista ahoki'ina oamani ada Jesus — abono-ra ni'aha ada Iroji. ");
INSERT INTO padNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hari. Irojia bivahonariahi'iki ada João Batista kohana gatha'ina, sa'a kodabohani. Cadeia avibai'iki ada. João Batista kohana cadeia avibaivini viahania Irojia bikanagamoha'iki ida kidikajo'o kagamo. Filipea oniki ada Iroji kakajo'o. Irodisi oniki ida Filipe kagamo Irojia bisaari'iki. ");
INSERT INTO padNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Oniania, João Batista bini'aha ada Iroji: —Ni-jahapa'itxiki ida kadakajo'o kagamo-ra ivahojavini. Nimania ida Deus kava'isohihi jiriki athini — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Oniaroa, João-ra kaihamahi'ihi ida Irodisi, João-ra naabinivini-ra nofi'ihi. Ni-bikaabokaki. ");
INSERT INTO padNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Irojia ni-biva'ahaki ida João-ra naabinivini. Irojia biogaki ida João Batista makhira jahaka'oaki hina. Hojai asohikia kahojaiki ada, oniani ida João Batista-ra finivini hija. João Batista vara nina-ra kamithavini mani ida Iroji va'i-ra karakhakhamaja, kaba'i, bivajahaki ida João Batista kavarani-ra mitha ni'avini. ");
INSERT INTO padNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hari. Mahi biva'banaki kamahini vani, ihinika karaho amonahani-ra vahonariahi'aha ada arabo kaka'da'dini Iroji oniki. Bivahonariahivini ida ihinika ko'baini ahapini amonahani, kanori abono vaipohikia vahaki kaimoni. Va'ora kaboa'iha adani kidibadani abono Galiléia kaaraboni vakadika'da'di, sorara vakadika'da'di vihiki. Va'ora kaboa'i'aha adani ija'ari vakainisika'ahapikiki. ");
INSERT INTO padNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Vajoronihahavi'aha, khajakosihi ida Irodisi kaisai, khajo'ihi. Kanori abono hahavia vavajahaki ida kidikhajoi. Irojia jaboni khai bini'ahi ida kidinabadiahi khajoni. Khajo'ini naothinia, Irojia bini'ahi: —Nahinaro-ra inofihi, ira ono'ahi. ");
INSERT INTO padNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Deus viaha vara ira oni'ahi, ira ono'ahi ika'domakia. Jokoa ira onava'ipohi'imarinirihi, ika'domakia ira ono'ahi. Kodiarabo-ra oakanapitakhamavini-ra inofihi; oakanapitakhamahi kadaimoni hini — bini'ahi ida kidinabadiahi. ");
INSERT INTO padNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mitha bini'a'ihi, ajihihi, kidiamia kania okha'ihi. Binana'dohihi: —Mamai, nahina mani ida okanikhariaja kidiania? Kidisai-ra ni'ahi: —Iakanikharia ida João Batista ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ajihi'ianahi, jorakia ajoihi, kidibadia-ra ni'ahi: —Onofiki hidakaba'i João Batista ka'da'dia hora ino'avini bavia kabaviki. ");
INSERT INTO padNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Va'i mokara ni'aha ada Iroji. Ni-binofiki ida João Batista ka'da'di aka'boani. Kidikanori abonoa vakamitharija vaha ida athi; ni-bino'aki vaha ida kidinabadiahi bikanikhariakia. ");
INSERT INTO padNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Oniania, bihonariaha ada sorara: —Iakava'boaha bana ida João Batista ka'da'di. Ikavikha hida — bini'aha. Ajihiha ada sorara, cadeia okhaha, João Batista ka'da'di-ra akava'boaha'avini. ");
INSERT INTO padNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bavi bodinia bikanahoja'ihi. Bikavikhahi, ima'inavi-ra no'avini kihi'ihi. Bigathanihi ida bavi baka'da'dia daiki, biakosahi, kidiamia-ra no'avini kihi'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","João Batista kohana ipohina vakamitha'ihi ida monina, cadeia avikha'aha, aba'ona avanikha'avini. Ja'di hodijama'okia avibaiha'ihi ida aba'ona. ");
INSERT INTO padNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hari. Oniaroa, Jesus kania vajoi'aha adani kidipohi Jesus athi-ra avavaadahaoni'iki. Vananamithavini hihi ida vaadahana bada vakhani'ina, ija'ari-ra va'ora vaka'ojomo'iki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus kania vaakaikahirisahakhamaki adani ija'ari vaipohiki, vikha'iki, ai vihi'iki adani ija'ari afoha'oadaha, oniani ida Jesus, ipohina khama vi'baina-ra vakaabokaravini hija. Oniania, ipohina-ra va'ora ni'aha: —Ai arihi'ava. Kaija'aririki kania aokha'ava mahija avarakoiripa'itxi'avini. ");
INSERT INTO padNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Vaki'damaha, kaija'aririki kani-ra avakanikhaha'avini. ");
INSERT INTO padNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hari. Ija'ari vaipohiki va'ora vanoki'aha adani Jesus, ipohina khama vaki'damana. Va'ora avigaki adani Jesus ai vakihina, oniani ida Jesu-ra vanajoikahivini hija. Vaibavia vikhaonaninanibakhiaha adani ija'ari vaipohiki, 'dako vadinia vikhabaoniha, Jesus avako'omisina-ra vanaviahanokha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Avako'omisi'aha adani Jesus, va'ora nokiha adani ija'ari vâipohiki. Va'ora nakaidivamaniha. Va'ora kava'ibodivarani'aha: —Ovilia nahina va'ora akadava'ariki fori vihiki adani ija'ari. Ni-avigaki ida Deus va'ora akadava'avini. Oniania, va'ora ka'ojomo'i'aha varani ipohikia. ");
INSERT INTO padNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hari. Safini ajora'ina vani vikha'aha adani ipohina, Jesu-ra vani'a'aha: —Kamahijanarihi. Kagorarihi bana hida ibavi. ");
INSERT INTO padNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Va'ora honaria ai vihi'ina mahija ija'ari vahoariha vaibavia 'bai-ra vakapavakarihavini. ");
INSERT INTO padNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Iniani. A'onivani 'baia va'ora vano'a — niha ada Jesus. Hari. Vagathanihi ida Jesus athi: —Ida hanaja vania 'bai-ra akapavakarivini hihadani ija'ari hahavi-ra va'ora ano'avini kaimoni? Ni-arajomaki ida 200 jiniro 'ba'dani hiki pão-ra akanaabosivini kaimoni hini, vagahinara kaimoni pão kabobini kapa'itxi afohanana — Jesu-ra vani'a'aha. (Mahi hoarani kavabadanini abosini fori hiki ida jiniro 'ba'dani hoarani.) ");
INSERT INTO padNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Oniaroa, Jesus va'ora ni'aha: —Nihafori kihimanija oni pão avakavahojaki? Vakanavanavanaha oni pão kaipohini niha fori kihini. Vakanavanavanaha'ihi, vajoina, vani'aha: —Pão sa'ai kahoarani kihiki oavani-ra akavahojaja, abaisana 'bamiki oavani-ra jaboni avahojaja. ");
INSERT INTO padNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Hari. Jesus va'ora honariavini adani ija'ari vaipohiki: —Vajoronionaha'a bana, vavithionaha'a afohahavi. Vajoroni'a 50 avihiki avaipohini, vavithijabana'a. Vajoroni'a 100 avihiki avaipohini vavithijabana'a jaboni — va'ora ni'aha ada Jesus. Oniaroa, 50, 100 vihiki vaipohina, onivani fori vihina adani ija'ari vaipohiki vavithijabanana hogoi itxani namania vavithionahana. ");
INSERT INTO padNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesua bigathaniha ada abaisana 'bamiki, pão sa'ai kahoarani kihiki, nama vada nimanani'aha, Deu-ra vara ni'a'aha: —Deus, ivani ijahaki i. 'Baia haria ino'a'iki i — niha ada Jesus. Oniaroa, bikanapitahatahahi ida pão, ipohina-ra va'ora no'avini kihi'ihi. Va'ora honaria'aha: —Vakaravina'a hida pão, ija'ari hahavia vakahaja kaimoni. Binapitahatahaha ada abaisana 'bamiki va'ora ravinavini hi'aha jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hari. Vi'baihahavi'aha vava'i na'bihahavimani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vi'baina naothinia, Jesus ipohina vakanajoroni'ihi ida pão akahabarini, abaisana ahabarina jaboni. 12 so'oro-ra vanaji'biji'biha'aha 'bai ahabarini. ");
INSERT INTO padNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Makhira 5 mil vaipohina vi'baiki, gamo, isai vihiki jaboni. Ija'ari va'ahâpina oamani adani vi'baira. ");
INSERT INTO padNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hari. Pão-ra vakanajoronivini naothinia, Jesus ipohina-ra va'ora honariaha: —Vaki'dama'a mahija avarakhananava'avini, Betsaida ibavi oniki-ra avarakanikafianija kaimoni — va'ora ni'aha. Avakakafianina kaba'i Jesus va'ora honariaha adani ija'ari vaipohiki avajoi'ina vagorana. ");
INSERT INTO padNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ipohina-ra va'ora kaaminavini naothinia, arabo namahikia gaimoriha ada Jesus, Deu-ra vara ni'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Arabo namanija jominikosoa'aha ada Jesus. 'Dako bodi pania vakavanamina kaba'i adani ipohina, vakajomini'aha. ");
INSERT INTO padNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kanava-ra aagathanihi ida sirisiriki danoki. Vakavanamina kaba'i ni-vakaadahajanaki. Sirisirikia bikanadaanivini ida kanava. Jesus va'ora akanokiha. Avagarini oadani, kha'aha ada Jesus kidipohi vakadiania, adahana paha namania. ");
INSERT INTO padNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Va'ora karadavini kaba'i vakanoki'aha. Vanokihahavi'aha paha namania adahana. ");
INSERT INTO padNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Paha kapamoarihi vakavanihavini, va'ora kanaimahida'iki. Vakabodi'baraha'aha. Oniaroa, Jesus va'ora kani'a'aha: —Khai hora vakani'a! Hovani Jesus ho. Hari'a vaimahida! — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hari. Ki'dama'aha. Radaha'ihi ida sirisiriki. Jesus paha namania adahana vani ida vava'i nakidakidani hija. Vaimahida'aha. ");
INSERT INTO padNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Vanokivini kaba'i ida Jesus pão-ra akanaipohivini, ni-aviga'iaki ida badani hahavi danoki-ra kaabokavini. Asia ni-vavakaijokajahakiki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hari. Vakajoifiani'aha adani Jesus kidipohi khama. Genesaré arabo onikia avako'omisi'aha. Vakanaaho'ihi ida kanava kaasia. ");
INSERT INTO padNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Vigaimori'aha. Genesaré arabo kaija'arini va'ora vanoki'aha adani Jesus. Va'ora avigajoraki'aha. ");
INSERT INTO padNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ija'ari Jesu-ra vanoki'iki avakahoaraharahanakhama'iki vahoariha-ra va'ora vanava'isohiha'avini adani sidaji kaija'arini afohahavi Jesus vaakaikahi'ina. Jesus varani hina-ra vakamithavini, Jesu-ra vanajoikahivini hiki. Vakavamoniki-ra vavikhaha Jesus kania, va'ora anaihotara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ibavi ipohikia aadahaoni'aha ada Jesus. Ibavi kagorani ipohikia aadahaonina, kagora'ipohiriki kania aadahaonina, siroi kagorania aadahaonina jaboni. Pavakarihi ibavinia ija'ari va'ora vibarari'aha adani vakavamoniki vajorana namania. Kha'aha ada Jesus, vakavamonikia vani'aha afohanana: —Jakaho kadakarahobi ihini-ra akaabadava — vani'aha. Jesus kakarahobi ihini-ra vakaabadabadarisahakhamaha, avaihotahahavi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hari. Jesus kania vajoroni'aha adani farisio, judeus kaija'ari vaka'ojomo'iva abono khama vaipohiriki. Jerusaléa vikha'iki adani. ");
INSERT INTO padNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Va'ora vanokiha adani Jesus ipohina vi'baina. Vi'baina viahania ni-vasa'a-ra vakosokovini arafiaki adani Jesus ipohina. Farisio kahojaia vakahojairiki adani Jesus ipohina. Farisio va'ora vaka'ojomo'ivini hiki adani judeus kaija'ari niha ninini asohini ija'ari sa'ani-ra kosokovini. ");
INSERT INTO padNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Judeus kaija'aria vanaababakhiaki ida ojomo'ihi athini vakadija'ari avikhananavakia va'ora vanava'isohi'bo'davini hi'iki. Arafiaki ida farisio ojomo'ihi athini-ra vanaabavini. Vakadihojai hiki ida vi'baina viahania vasa'a-ra vakosokovini arafiani. ");
INSERT INTO padNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Vakadihojai hoariha ida nahina havahaki-ra vakapavakarivini, visokovini arafiani vahavini viahania. Visokovini arafiaki jaboni ida 'bai bavini, paha bavini, si'aha kihiki. Farisio vahojana hida nahina-ra visokovini arafiani. ");
INSERT INTO padNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hari. Farisio va'ora vanokiha adani Jesus ipohina vasa'a-ra vakosokovini arafiarini vi'baina. Oniaroa, Jesu-ra vanana'dohi'aha: —Nahina mani ida kadaipohi akadija'ari avikhananavaki kahojai-ra vakajonivini hija? Vasa'a-ra vakosokovini anarafiaravini hija vi'baina viahania. ");
INSERT INTO padNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus va'ora ni'aha adani farisio: —Deus athi-ra avanofivini-ra avakahi'badaraki a'oni. Ni-Deus a'onira honariavini hirihi hida avakadihojai niki. Deua vara bivani'a'bo'da'iki ida avakadihojai niha ninini. Isaías kohana binajiri'iki hida Deus athi. Asohiki ida varani avihini. Niha ada Deus: “Vava'i bodinia hora vanofipa'itxiravini kaba'i, ojahana-ra khai vani'abakhiaki adani ija'ari afo'badara, varani jahakia vara hora vavani'abakhiaki adani. ");
INSERT INTO padNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ni-nahina kaimoni hora vakanamasiviki. Vakadija'ari avikhananavaki vahojana vanofivini mani ida oathi-ra vanaabaravini hija. Vakadihojaia vakahojaina va'ora ohonaria'bo'davini-ra vakahivini. ");
INSERT INTO padNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kodihonari hirihi ida vakadihojai hija.” Nimania ida Deus athi papira hojaki athini. Asia vara niha ada Jesus: —Avakadija'ari avikhananavaki vahojana mani ida avakadihojai hija. ");
INSERT INTO padNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Avarigavini kaba'i ida Deua binofiki bada avani'avini, avakajonibakhiamanihi. Avanahoarihaki ida Deus athi, bada avani'aja kaimoni ida badani avanofiki. Nimania bana hida avakadihojai. ");
INSERT INTO padNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","'Bo'dakari Moisés kohana binajiri'iki ida Deus kava'isohihi jiriki. Ija'ari-ra honariaki: “Va'ora vanakaidiva adani avakadiamia, avakadiabi'i vihiki, vara a'onira vani'avini vanaaba'a.” Deua kava'isohihi jirikia bivahonariahivini abinini ida ija'ari kidiamia, kidiabi'i vihiki-ra vakanavaranihaki. Nimania ida Deus kava'isohihi jiriki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Asia vara niha ada Jesus: —Avanahoarihaki ida Deus athi asohijanaria kaimoni. Nimania bana hida avakadi'ojomo'ihi athini asohiriki. “Ija'ari kajiniroki Deu-ra kanava'igavini hini ida kidijiniro pitani, ni-makhaniki ida ija'ari kidiamia, kidiabi'i vihiki-ra va'ora kaijahitaravini, vakadinahina-ra vakainamovini kaba'i. ");
INSERT INTO padNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Deu-ra kanava'igavini hini mani ida va'ora kaijahitaravini namakhanirini hija.” ");
INSERT INTO padNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nimania ida varani asohiriki ija'ari-ra va'ora avaka'ojomo'ivini hiki. Ni-nirihi ida Deus athi. Ni-avanofiki ida Deus athi. Avanahoariha'oamanija ida. Avanofiki ida avakadija'ari avikhananavaki vahojana. Vakadihojaia va'ora avaka'ojomo'ibakhiaki adani ija'ari. Ni-va'ora avaka'ojomo'ivini hiki ida Deua binofiki. Onivani fori hija ida avakadihojai ipohiki asohiriki — Jesus va'ora ni'aha adani farisio. ");
INSERT INTO padNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Oniaroa, Jesus va'ora baranaha'ianaha adani ija'ari vaipohiki vikhara kaimoni kidiania. Vara va'ora ni'aha: —A'onivani afohahavi, mitha vani'a hida kodivarani mahija avarigajahakivini. ");
INSERT INTO padNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni-'baia binamakhaniki ida ija'ari Deus viaha. Ija'ari varani jaharikia kavaranini mani ida ija'ari-ra najaharija Deus viaha. ");
INSERT INTO padNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Avakamithavini avanofihi; mitha vani'ajahaki bana hida kodivarani hiki. ");
INSERT INTO padNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hari. Ai vihi'aha adani Jesus, ipohina khama. Avikhaha, gora bodinia avikhajakosi'aha. Oniaroa, Jesu-ra vanana'dohi'aha: —Haria nanamithajahakivinihi bana hida vara va'ora ini'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—Vahoariha fori avihimania koda? Ni-nahina-ra avarigaria koda? Ija'ari va'ini bodinia hojaki ida ija'ari-ra najahariki. ");
INSERT INTO padNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","'Bai ni-hojaki ija'ari va'ini bodinia. Ija'aria biobaihi ida kidi'bai bodinia, bikidafihi, kaijonia okhahi, kia'ihi. Ni-va'ini bodinia o'oiki ida 'bai. Ni-hojaki ida 'bai kaaji hiki ija'ari-ra najahariki Deus viaha. ");
INSERT INTO padNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Va'ini bodinia hojaki ida ija'ari va'ini bodini vara nini jahariki. Varani jahariki-ra vara vani'avini mani ida ija'ari-ra najaharija Deus viaha. ");
INSERT INTO padNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bikava'ibodivarani'imidiaki ida hojai jahariki. Binofihi; bada bini'ahi. Hida vani mani va'i bodini vara nini jaharika'oaki. Binofiki ida makhira kidigamo hiriki khama vaabono vakavi'omakhamavini. Binofiki ida bo'diani. Binofiki ida kaabinina. ");
INSERT INTO padNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Binofiki ida hoariha kagamo-ra vi'omavini. Binofiki ida hoariha kamakhira-ra vi'omavini. Binofiki ida hoariha kanahina. Binofiki ida hojai hahavi Deua bivajahariki. Binofiki ida korijanahani. Binofiki ida kidihojai jahariki kaipahivahaki. Binofiki ida akabajahani. Binofiki ida hoariha-ra kanavaranihavini. Binofiki ida abononi vaboraborahavini. Va'ini bajadidi'oamanija hida ija'ari. ");
INSERT INTO padNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ija'ari va'ini bodini khaonaniki ida nahina ija'ari-ra najahariki Deus viaha. Jahariki ida ija'ari kava'ibodivarani, oniani ida hojai jahariki-ra bada ni'avini hija — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hari. Ai vihi'aha adani Jesus, Tiro sidaji kaaraboni-ra avanikhahavini. Avakhano'aha, gora bodinia avikhajakosi'aha. Ni-Jesua binofiki ida vahoariha avigavini gora bodinia hojana. Ni-amithihipa'itxiki ida avigavini. ");
INSERT INTO padNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Oniaroa, gamo vania biogaha ada Jesus hojana. Israel kaija'ari hirihi ida gamo. Siro-Fenícia kaaraboni kaija'arini ida. Kabajadiki ida gamo kaisai. Hari. Jesus varani hina-ra kamitha'ihi, khamai'ihi. Jesus viaha kajo'atharari'ihi, Jesu-ra kanikharia'ihi: —Ida kodisai kabajadiki hojahi. Ihonaria bana ida bajadi akara'o'ini. ");
INSERT INTO padNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesua bini'a'ihi: —Isai-ra va'ora ano'avini hiki ida 'bai. Jomahi-ra va'ora ano'avini hiki ida 'bai isaia vakai'dariki. Jahariki ida isai vi'bairina kaba'i, jomahi-ra va'ora ano'avini hini isai vakadi'baia — niha ada Jesus. Jesus judeus kaija'ari-ra va'ora kavarajomivini isai fori vihina. Judeus kaija'ari vihiriki-ra va'ora kavarajomivini jomahi fori vihina. ");
INSERT INTO padNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Oniaroa, gamoa bigathani'ihi ida Jesus athi: —Hai oamani. Jomahi fori ohiki ho. Isai vi'baina kaba'i, jomahi vaitxanava vahahi ida vakadi'bai moramorani gora nabo'ania vararaki. Kadaija'ari ohirina kaba'i, onofiki ida kodisai-ra ikajoamoravini — Jesu-ra ni'ahi. ");
INSERT INTO padNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hari. Jesua vara bini'a'ihi ida gamo: —Jahaki ida kadavarani. Hora ivakaijokajahakivini mani ida kadaisai-ra oanaihotavini hija. Ba ajihi'a. Ida akara'o'ihi bajadi kadaisai kania. ");
INSERT INTO padNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ajihi'ihi ida isai kaamia, gorania ajoi'ihi, cama kanamania isai-ra karaga'ihi. Ni-kabajadijanaki ida isai. ");
INSERT INTO padNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hari. Tiro kaarabonia ai vihi'aha adani Jesus. Sidom sidaji onikia avikafianiha, Decápolis kaarabonia avikafianiha, Galiléia 'dako-ra avanikhahavini. ");
INSERT INTO padNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jesus kania avavikha'aha ada makhira morobo kavagahariki, abani a'dakharariki hiki. Vani'aha: —Ikaabada bana mahija morobo akavagahavini, abani jaboni varavara'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ija'ari vaipohiki-ra va'ora avakakara'opa'itxi'aha ada Jesus. Makhira morobo-ra kaka'oahaha'aha sa'a nokhonia. Biakatho'ihi ida i'bana, sa'a nokhoni-ra kai'bai'aha, bikadasa'ihi ida makhira abani. ");
INSERT INTO padNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Vada nimanani'aha, va'i aharoroni ada Jesus, bini'aha athia: —Ifata. (Ariathi hini: —Imoroboni akavagaha'ava.) ");
INSERT INTO padNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Morobo akavagahani, athi-ra kamitha'aha, abani ni-a'dakhararijanaki, sohimaina'ihi ida kidivarani. ");
INSERT INTO padNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus va'ora ni'aha: —Hari'a vahoariha-ra vananamitha — niha ada Jesus. Va'ora kaabanibakhiavini vananamitharia kaimoni, vananamitha'ahapikimani'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vakamithava Jesu-ra vakava'ibodivarani'aha afo'ahapiki. Vaabono vakani'akhama'aha: —Jahaki ida kidibadani! Bikaabokaki ida moroboni kavagahariki-ra akanavagahavini, abani a'dakharariki jaha'iki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hari. Oniaroa, mahi hoariha vajoroni'ianaha adani ija'ari vaipohiki Jesus kania. Vako'baijanariha adani. Oniaroa, ipohina-ra va'ora baranaha'aha, va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Va'ora onakaidivaki va'oani ija'ari vaipohiki. Mahi ahoarabakosikia kodiania vahojaha. Vakadi'bai-ra vakainamovini hiki napaja vikhana. ");
INSERT INTO padNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Vi'bairina oadani ni-onofiki ida ai vihina ohonariavini. Vaibavia avakakhanakhamana vaha va'ora ohonariara vaha; vai'ami vajarona binafajafajahamaniha vaha; hagihia vai'ami va'ora narai'ahamaniha vaha. ");
INSERT INTO padNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ipohina vani'a'aha ada Jesus: —Pão kahojarihi bana hihida ibavia kakapavakari vahaki kaimoni. Niha akani'a'aki koda bana hida pão va'ora ano'avini kihiki kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—Nihafori kihimanija ida pão avakavahojaki? — va'ora ni'aha ada Jesus. Jesus athi-ra vagathani'aha: —Akavahojaki 7 pão kihiki kaipohini — vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Oniaroa, Jesus va'ora honaria'aha adani ija'ari vaipohiki vavithionahana. Biagathani'ihi ida pão, Deu-ra vara ni'a'aha: —Deus, ivani ijahaki i, pãoa haria ino'a'iki i. Hari. Bikanapitahataha'ihi, ipohina-ra va'ora no'avini kihi'ihi vakaravinaja kaimoni. Oniania, vakaravina'ihi ija'ari vaipohiki vakadimoni kihi'ini. ");
INSERT INTO padNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hari. Vavahoja'aha ada abaisana ipohiriki akaiki jaboni. Deu-ra vara ni'a'ianaha ada Jesus: —Deus, ivani ijahaki i, abaisana haria ino'a'iki i. Hari. Varavinavini va'ora honaria'aha adani kidipohi, varavinamani'aha ada abaisana. ");
INSERT INTO padNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jesua biakanaipohi'ianaha ada abaisana, pão kihiki. Vi'baihahavi'aha, vaakhari'aha. Vi'baina naothinia, Jesus ipohina vanajoroni'ihi ida 'bai ahabarini. Vanaji'biji'biha'ihi ida 7 so'oro ipohini. ");
INSERT INTO padNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vaipohina 4 mil vihiki adani ija'ari vi'baiki. Hari. Jesus va'ora kaamina'aha adani ija'ari vaipohiki, ai vihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Naothinia, vaki'dama'aha adani Jesus, ipohina khama. Ai vakihi'aha, avakakafianiha, Dalmanuta kaarabonia avako'omisi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hari. Oniaroa, vikhaha adani farisio, Jesu-ra vara vani'ahavini. Vakajari'daki ida Jesus Deua bikaronavini, oniani ida vakaijo'avini hija. Vani'aha: —Anofiki ida kadabadani danoki-ra anokivini. Deus kabadani danoki fori hini vani bana bada ini'a mahija Deus ira karonavini-ra aogavini — Jesu-ra vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Va'i mokara ni'aha ada Jesus, va'i aitapiahi va'i aharoro'aha. Va'ora ni'aha: —Nahina kaimoni mani ida ija'aria vakanikhariavini hija badani danoki-ra vanokivini. Ka'oa oamani ida oni'aki. Jokoa va'ora onanokiahiriha adani kodibadani danokia. ");
INSERT INTO padNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hari. Jesus va'ora nahojaha'aha adani farisio. Vaki'dama'aha, ipohina khama. Avakakafiani'ianaha. ");
INSERT INTO padNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hari. Jesus ipohina avakakava'i'birini'ihi ida pão-ra avakavikhavini. Vakavahojaki ida pão kahoarani ka'oa. ");
INSERT INTO padNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Avakakafianina kaba'i Jesus va'ora kanava'isohi'aha: —Avaabononi avakava'igairi bana! Hari'a bana vagathani ida farisio, Iroji khama vakadipão-ra kanathoramananiki. ");
INSERT INTO padNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vakamithahi, ni-avigajahakiki ida Jesus va'ora nava'isohivini hiki. Farisio vakadihojaia Jesus va'ora kaabaniki adani. Pão vakavanihavini ida Jesus kavarani. Oniania, vaabono vara vakani'akhama'aha: —Pão-ra akavikharihi, oniani ida haria kaabanivini hija. ");
INSERT INTO padNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesua bikamithaki ida vakadivarani. Va'ora ni'aha: —Nahina kaimoni mani ida pão-ra avakavahojaravinia avaabononi vara avakani'akhamavini hija? Mitha avani'avini kaba'i hida oathi, ni-nahina nini avarigaki? Asia mani avakajari'daja? ");
INSERT INTO padNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Avanokhoni 'ba'dahani kaba'i, ni-nahina-ra avanokiki. Avamorobohani kaba'i, ni-nahina-ra avakamithaki. ");
INSERT INTO padNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Avakava'ihokiria ida pão sa'ai kahoarani kihiki-ra okanapitahatahavini kari 5 mil ija'ari-ra va'ora ono'bai'avini. Nihafori so'oro ipohini-ra avanaji'biji'biha'ia pão akahabarinia? —12 so'oro — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesus va'ora nana'dohi'ianaha: —Pão 7 kihiki-ra okanapitaha'iki, 4 mil ija'ari-ra va'ora ono'bai'iki ho. Nihafori so'oro ipohini-ra avanaji'biji'biha'iki pão akahabarinia? —7 so'oro — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Avarigajahakirihi kaho ida kodivarani? — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hari. Oniaroa, avako'omisiha adani Jesus. Betsaida ibavia vakaikahi'aha. Oniaroa, Jesus kania avavikha'aha ada makhira kamaodorohaki. Jesu-ra vakanikhariaha makhira-ra kaabadavini, nokho avagahara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sa'a biagathiha, Betsaida ibavia banininia Jesua biakakavanamaonani'aha. Biravisovini ida nokho 'ba'dani i'bana. Bikaabadaha, binana'dohi'aha: —Nahina-ra inokiria? ");
INSERT INTO padNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hari. Vada ni'aha ada makhira. Bini'a'aha ada Jesus: —Ija'ari-ra onoki'avini ava adahaki fori vihina. ");
INSERT INTO padNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nokho 'ba'dani namani bikaabada'ianaha. Vada vada'ianaha, nokho 'ba'dani avagahajahaki'iki, aihota'ini. ");
INSERT INTO padNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesua bihonariaha: —Igorania okha'a. Hari'a kaho Betsaida ibavia kaho ajoi. ");
INSERT INTO padNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hari. Oniaroa, Cesaréia de Filipe ibavia avikha'aha adani Jesus, ipohina khama. Avikhana kaba'i, va'ora nana'dohi'aha: —Hora vara vavani'aha adani vahoariha, nahina nimania ida hora vara vavani'avini? ");
INSERT INTO padNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Vahoariha vani'aha: Ivani João Batista kohana i iahoki'ia. Vahoariha vani'aha: Ivani Elias kohana i iahoki'ia. Vahoariha vani'aha jaboni: Ivani Deus athi namoniva abono kohana i iahoki'ia — ipohina vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Oniaroa, Jesus va'ora nana'dohi'ianaha adani ipohina: —A'onivani, nahina nimania ida hora vara avavani'avini? Pedroa bini'aha: —Ivani Cristo i. Ija'ari hahavi vakadika'da'di i. ");
INSERT INTO padNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Ha'a, hovani Cristo ho. Deus hora karona'iki ho. Hari'a vahoariha-ra bana vananamitha'a bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hari. Oniaroa, Jesus va'ora nanamithajoravini hiki ida nahina namithaki kaimoni kidiania. Va'ora ni'aha: —Hovani ija'ari hahavi vakadi'aajo ho. Oimana bana hida 'banakarahoja. Hora vakajoniki adani judeus kaija'ari vanava'isohiva abono. Hora vakajoniki jaboni bana adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama. Hora vakajoniki hora vavahonariahiki bana ija'ari vahoariha hora vanaabinija kaimoni. Mahi ahoarabakosiki radahahi oahokiki bana ho. ");
INSERT INTO padNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Va'ora nava'isohijoravini hiki avigajahakija kaimoni. Hari. Pedroa biavikhapa'itxiha ada Jesus. Bikaabanivini bini'aha: —Hari'a varani nikia kavarani. ");
INSERT INTO padNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Roiribani'aha ada Jesus, ipohina-ra vada va'ora ni'aha, Pedro-ra kaabani'aha: —Jahari, akara'o'a! Ni-Deus kava'ibodivarani fori hiki ida kadava'ibodivarani. Ni-inofiki ida Deua binofiki. Deua binofiki ida oni'aki. ");
INSERT INTO padNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Oniaroa, Jesus va'ora baranahavini adani ija'ari vaipohiki, ipohina vihiki. Va'ora ni'aha: —Kodipohi avihini-ra avanofihi; vakava'ipahini ida avanofiki mahija Deua binofiki ka'oa-ra bada avani'avini. Avava'ini bodinia vara ni'ava: “Anofiki Jesus ipohina arihi'ina. Haria vanaabiniha; haria vanaabiniha. Jakaho Deus athi-ra anaabava kaho.” ");
INSERT INTO padNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Hari. Asia vara niha ada Jesus: —Ija'aria bada bini'ahaha'oadahahi ida binofiki kidimoni, ni-bikava'ibodiki ida Deua binofiki, akamadaki fori hiki bana ida kidimahi. Kavithimaki ida. Ni-bivahojaki ida mahi ja'dini anokhomiriki Deus kania. Oipohina omonina jahakia kavaranini mani ida vahoariha vanaabinivini hija, oniani ida Deus kania oipohina-ra arakhaja. ");
INSERT INTO padNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ija'ari vakadinahina ipohiki-ra vanofivini arafiani mani ida Deu-ra vanofijahakiravini hija. Vaabinina kamahini Ibavi Jaharika'oakia avikhaha. Ibavi Jaharika'oakia okhahi ida ija'ari, ni-khaonanijanaki. ");
INSERT INTO padNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ni-arajomaki ida kidinahina ipohiki khaonanini-ra naabosivini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ija'ari vaipohikia vakajari'daki ada Deus. Vakadihojai jahariki-ra vanofivini mani ida Deus athi-ra vakamitharavini hija. Hora avakaipahihi; ojoina kamahini a'onira okaipahihi jaboni. Oathi-ra avakaipahihi; ojoina kamahini a'onira okaipahihi jaboni bana. Hovani ija'ari hahavi vakadi'aajo ho. Kodiabi'i ibavia ookhaki bana ho. Ojoina kamahini bana Deus ibavi kaija'arini hora vavaipohihaki bana ho. Ija'aria vanokiki bana ida kodiabi'i jahana, danona, vagana kodiania. Nokiaki jaboni bana ida Deus ibavi kaija'arini vajahana kodiania. ");
INSERT INTO padNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Vakava'ibodivarani bana ida kodivarani. Khaki bana ida mahi Deus ija'ari-ra nanokiahivini ka'da'di danoki hina. Vaabinirina oadani bana adani ija'ari ahararana vahojaki, vanokiki bana ida va'ora oni'avini hiki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hari. Radahahi ida 6 mahi ipohini. Oniaroa, arabo namahikia vigaimori'aha adani Jesus. Va'ora avigaimoriha adani Pedro, Tiago, João vihiki ka'oa. Avakhanomori'aha, kama'da'ihi ida Jesus vagana nokiani. Nokho vagani vanoki'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Safini vagana fori hiki ida. Kidimakari vaforini vagaki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Oniaroa, Jesus ipohina avahoarabakosiki va'ora vanoki'aha adani ija'ari kohana avaja'dina vi'bamiki. Hoarana onina Elias. Hoariha onina Moisés. Jesus khama vara vakhani'aha adani vi'bamiki. ");
INSERT INTO padNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Oniaroa, Pedro Jesu-ra ni'aha: —Aajo, hida vania arihojana jahaja. Oniania, onamonahaki bana ida gora itxani ahoarabakosiki. Hoarani kadaimoni, hoariha Moisés kaimoni, hoariha Elias kaimoni — niha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hari. Vaimahidakaraho'aha adani Jesus ipohina. Visoni'aha ada Pedro, ni-biogaki ida vara bivani'avini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Oniaroa, kha'aha ada bahi vaforiki. Amokhinina va'ora karahobarari'aha. Bahi kania vakamitha'ihi ida athii: —Hi'o kodisai, onofijahakiki o. Mitha vani'a oni kodisai athi. ");
INSERT INTO padNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hari. Vada vakhaniribani'aha, ni-vahoariha-ra va'ora vanokijanaki. Jesus oavani ada vanoki'aha vakadiania hojana. ");
INSERT INTO padNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ai vihi'aha, vajoifonina vani va'ora honaria'aha: —Hari'a bana vahoariha-ra va'ora vara vani'a arabo namahikia avanoki'ikia. Hovani ija'ari hahavi vakadi'aajo ho. Oabinina oahokina kamahini vahoariha-ra va'ora vara vani'a bana hidakaba'i avanoki'ikia. ");
INSERT INTO padNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Vakava'ibodivarani'ihi ida athi. Vikharafonina kaba'i vaabono vakanana'dohikhama'aha: —Ni-aogajahakiki ida Jesus abinina ahokina kavaranina. ");
INSERT INTO padNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Oniaroa, Jesu-ra vani'aha adani kidipohi: —Jesus, nahina mani ida judeus kaija'ari vaka'ojomo'iva abono haria vani'abakhiavini hija: “Deua bikarona'imidiaki bana ada Elias, naothinia bikaronaki ada Cristo oniki.” Vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesus va'ora ni'aha: —Asohiki ida vakadivarani. Okhananavaki ada Elias kohana fori hiki, ija'ari-ra va'ora nava'isohijoravini hiki vakadimahi-ra vanasohivini, okaikahina viahania. A'onira onava'isohivini hiki ada kaikahi'ina Elias fori hiki. Ni-aviga'iki ada makhira Elias kohana fori hina, oniani ida vanaima'banavini hi'ia. Nimania ida Deus athi kapapirania bivava'isohihijoraki. Elias fori hiki-ra vakajonivini. Hovani ija'ari hahavi vakadi'aajo ohina kaba'i, hora vanaima'banaki jaboni bana adani. Hora vakajoniki jaboni bana. Nimania ida hora vanaima'banavini Deus athi kapapirania bivava'isohihijoraki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hari. Oniaroa, vakhanofoni'aha adani Jesus, Pedro, João, Tiago vihiki. Va'ora vanamaakari'aha adani Jesus ipohina vahoariha. Vahararana va'ora vanoki'aha adani ija'ari vaipohiki. Vahojaki jaboni adani judeus kaija'ari vaka'ojomo'iva abono vaipohiriki. Vaabono vara vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hari. Ija'ari vaipohiki va'ora vanokiha adani Jesus vakaikahi'ina, vakava'ibodivarani'ihi, vaki'daraha'aha, Jesu-ra vaka'ivaniti'aha. ");
INSERT INTO padNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Va'ora nana'dohi'aha: —Nahina mani hida avakadivarani hija? ");
INSERT INTO padNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hoarana bigathani'ihi ida Jesus athi: —Jesus, kodisai mani hada ovikhara kadania. Bajadia bigathivini mani ida abani ana'dakhararini hija. ");
INSERT INTO padNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bajadia bigathivini mani ida binaadaribakhiavini hija. I'bana thorothoronaniki bodia, kanada kakiroromisiki rai'ana. Kadaipohi-ra va'ora okanikhariahi bajadi akara'oni-ra vahonariara kaimoni. Vahonariavini kaba'i, ni-akara'o'iki ida bajadi — niha ada isai kaabi'i. ");
INSERT INTO padNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Oniaroa, Jesus va'ora ni'aha adani vajoroniki: —A'onivani, asia Deu-ra avakajari'daki a'oni. Ova'i-ra avanamokaraki a'oni. Avanokibakhiaki ida Deus kabadani danokia okabadanina, kaba'i, ni-Deu-ra avavakaijokaki a'onira kakodiara kaimoni kidibadani danokia avakabadanini. Isai kaabi'i-ra ni'aha: —Kodiania ivikha o kadaisai. ");
INSERT INTO padNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Vavikhavini kaba'i ada isai, bajadia binoki'aha ada Jesus. Bajadia binarai'a'aha ada isai. Rai'aha, adari'aha, roaroa'aha i'bana thorothoronani'iki bodia. ");
INSERT INTO padNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isai kaabi'i-ra nana'dohiha ada Jesus: —Niha ninimania hida kama'dani? —Isai pa'itxina kari vani kama'daja hida rai'ana. ");
INSERT INTO padNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Siho kabodinia bajadia biosonabakhiaki hada, paha bodinia biosonabakhiaki jaboni hada, abinira kaimoni. Isai-ra ianaihotavini-ra ikaabokahi; isai-ra kajoamora bana. Haria nakaidiva bana! Haria kajoamora jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesua bini'aha: —Oanaihotavini ikajari'dariha; oanaihotaha. Deu-ra kajari'darikia bikaabokaki ida badani danoki hahavi. ");
INSERT INTO padNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Isai kaabi'ia bigathanijorakihi ida Jesus athi: —Okajari'darihi oni. Ira ovakaijokavini-ra onofiki ho. Hora kakodia bana mahija ojari'daravini. ");
INSERT INTO padNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Oniaroa, Jesus va'ora noki'aha adani ija'ari vaipohiki vamaakarina, bajadi-ra ni'a'aha: —Bajadi, isai abani-ra iana'dakharari'iki i. Morobo ikanamokhiha'iki i jaboni. Ira ohonariavini isai kania akara'o'a! Hari'a igathijana! ");
INSERT INTO padNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesus vara nina naothinia, bodi'baraha'ihi ida bajadi, binarai'akaraho'aha ada isai, ajihi'ihi ida bajadi. Isai abono aba'oi fori hini hoja'iki. Oniaroa, vanokiva vani'aha: —Ada abini'aha isai. ");
INSERT INTO padNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesua biagathihi ida isai sa'a, biragaa'aha. Aihota'aha ada isai. ");
INSERT INTO padNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hari. Ai vihi'aha adani Jesus. Gora avikha'aha. Avi'oina naothinia, ipohina vanana'dohi'aha: —Jesus, niha akhanimanija bajadi akara'oni-ra akaabokariki? ");
INSERT INTO padNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Deus khama vara avakhanirihi; ni-avakaabokaki oni bajadi fori hiki akara'oni. ");
INSERT INTO padNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hari. Oniaroa, ai vihi'aha adani Jesus, ipohina khama. Galiléia kaarabonia varadahana. Jesua ni-binofiki ida hana vahojana vahoariha avigavini. ");
INSERT INTO padNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Binofiki va'ora ka'ojomo'ivini adani ipohina ka'oa. Vaadahana kaba'i, va'ora ka'ojomo'i'aha: —Hovani ija'ari hahavi vakadi'aajo ho. Ija'ari vakadiania hora avarakhaki bana ho, vahoariha hora vanaabinira kaimoni. Mahi ahoarabakosiki radahahi, oahokiki bana ho — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hari. Ipohina mitha vani'ahi, ni-nahina nini avigaki. Vifinivini mani ida vanana'dohiravini hija. ");
INSERT INTO padNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hari. Oniaroa, Cafarnaum sidajia avakhano'aha. Gora bodinia avi'oi'ina, Jesus va'ora nana'dohi'aha: —Ariadahana oadani, nahina mani oni avakadivarani hija? ");
INSERT INTO padNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Vaadahana kaba'i, vaabono vakanana'dohikhama'aha adani Jesus ipohina: —Hana hina ada akadiania hojana jahara haria vaka'da'diki kaimoni? —Hovani ka'da'di ohina jahaja — vakhanihahavi'aha afohanana. Ka'da'di vihina kavaranihi-ra vakaipahivini mani ida Jesus kana'dohi-ra vagathaniravini hija. ");
INSERT INTO padNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hari. Vithi'aha ada Jesus, kidipohi-ra va'ora baranahaha, va'ora ni'aha: —Jakaho vahoariha-ra kakodiava ada ka'da'di hina-ra nofiki. Jakaho ija'ari hahavi vakadihonai abono hiva ada ka'da'di hina-ra nofiki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hari. Vahararana hojahi ida isai, bianikhahi, bikaba'ona'ihi, va'ora ni'a'aha: ");
INSERT INTO padNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ija'ari hora nofijahakivini mani ida isai-ra gathanijahakivini hija, oniani ida hora gathanijahakivini hija jaboni. Hora gathanijahakihi; bigathanijahakiha ada hora karona'iki jaboni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hari. Oniaroa, Joãoa bini'aha ada Jesus: —Aajo, anoki'iki ada makhira bajadi akara'oni-ra honariavini. Bidioniki ida ionini akara'oja kaimoni ida bajadi. Aripohina hiriha ada, oniani ida akaabanivini hija: “Ni-Jesus ira honariaki bajadi akara'oni-ra ihonariavini. Ikava'ipahini bana ida kadabadani.” Ani'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Oniaroa, Jesua bigathanihi ida João athi: —Hari'a vakaabani ada makhira! Hora kajari'daravini mani ida badani danoki-ra kaabokavini hija. Hora kajari'dariki ni-hora kanavaranihaki. ");
INSERT INTO padNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ija'ari akadibadani-ra nadabarihi; haria kakodiahi. ");
INSERT INTO padNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Hari. Asia vara niha ada Jesus. Va'ora ni'aha: —Ka'oa hiki bana ida vara a'onira oni'avini hiki. Ija'ari a'onira no'aki bana a'oni paha kodipohi a'oni. Hovani onaabosiki ida kodipohi-ra kajoamoraki. ");
INSERT INTO padNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hari. Vara ni'ianaha ada Jesus: —Va'ora onakaidivaki adani isai hora vavakaijokaki. Ija'ari va'ora kaboroborobakhiaha adani isai, hora vakava'ipahinira kaimoni, isai-ra kaborovini kabadanihi, Deua binaabosivini bana nahina jaharikia. Jahaki ida ja'di karaho ija'ari mathani ahoni paha bihiakia hokahini, ahidaja kaimoni ida ija'ari isai-ra kaboroboroki. ");
INSERT INTO padNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Avaabononi avakava'igairi bana mahija Jahari kabadania avakabadaniravini. Ija'aria binofihi ida Jahari kabadani-ra bada ni'avini, biakava'boavini kajahaki ida sa'ani, bada bini'aria kaimoni ida Jahari kabadani. Jahari kabadania kabadanihi; Ibavi Jaharika'oakia okhahi. Jahaki ida sa'ani kahoaranini kaba'i, Deus Ibavi Jahaka'oakia okhani. Jahariki ida sa'ani ko'bamini kaba'i, Ibavi Jaharika'oakia hokahini. ");
INSERT INTO padNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ibavi Jaharika'oakia ija'aria bikamithaki ida imai 'banani arafiaki. Ni-kamokhiki ida siho kakaraho. Ni-karadahaki ida siho kaafani. ");
INSERT INTO padNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ija'aria binofihi ida Jahari kabadani kania adahani, biakava'boavini kajahaki ida 'damani kahoarani, bada bini'aria kaimoni ida Jahari kabadani. Jahaki ida 'damani kahoaranini kaba'i, Deus Ibavi Jahaka'oakia okhani. Jahariki ida 'damani ko'bamini kaba'i, Ibavi Jaharika'oakia hokahini. ");
INSERT INTO padNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ibavi Jaharika'oakia ija'aria bikamithaki ida imai 'banani arafiaki. Ni-kamokhiki ida siho kakaraho. Ni-karadahaki ida siho kaafani. ");
INSERT INTO padNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ija'aria binokihi bivajahaki ida Jahari kabadani, bianivini jahaki ida nokhoni 'ba'dani hoarani, vada bini'aria kaimoni ida Jahari kabadani. Jahaki ida nokhoni 'ba'dani hoaranini kaba'i, Deus Ibavi Jahaka'oakia okhani. Jahariki ida nokhoni 'ba'dani 'bamini kaba'i, Ibavi Jaharika'oakia hokahini. ");
INSERT INTO padNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ibavi Jaharika'oakia ija'aria bikamithaki ida imai 'banani arafiaki. Ni-ihimiki ida 'bathaki arafiaki. Ni-kamokhiki ida siho kakaraho. ");
INSERT INTO padNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jokira fori hiki ida ija'ari kamahi. Jokira binajahaki ida igitha abono aha'diki ija'ari gahinai binihaki Deus kania. Siho fori hiki ida ija'ari jahariharini. Deua biva'ahaki ida ija'ari jahariharini, binajahaja kaimoni ida ija'ari kamahi, binadanoja kaimoni ida jari'darini. ");
INSERT INTO padNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jokira fori vihiki adani ija'ari Deu-ra vanofiki. Jahaki ida jokira, 'bai-ra naponiki kaimoni hini. Jokira jahaki fori avihihi; avaabononi avakanakaramisikhamahi. Nahina binajaharihi ida jokira, ni-ponini jahajanaki. Jokira ponini jahajanariki fori avihihi; ni-nahina jahaki avihiki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hari. Ai vihi'aha adani Jesus. Judéia kaarabonia avikha'aha. Jordão vainia avikafianiha. Nobanija vihi'aha. Vajoroni'ianaha adani ija'ari vaipohiki. Jesu-ra vanamaakari'aha. Va'ora ka'ojomo'i'aha. Kidihojai oamani ida ija'ari vaipohiki-ra va'ora ka'ojomo'ivini. ");
INSERT INTO padNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jesus kania vikhaha adani farisio vaipohiriki. Vaabono vani'aha: —Jesua ni-bikapoariki ida Deus kava'isohihi jiriki. Jesus Deus kava'isohihi-ra kajonivini-ra vanofivini, oniani ida vakaborovini hija. Vanana'dohi'aha: —Deus kava'isohihi jirikia hojaki ida makhira kidigamo-ra nahojahavini kavaranihi. Gamoa bada bini'ahi ida badani kidimakhira bivajahariki, Deua biva'ahamanira ada makhira kidigamo-ra nahojahavini? ");
INSERT INTO padNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus va'ora ni'aha: —Nahina mani ida Moisés kohana a'onira honariavini hija? ");
INSERT INTO padNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Farisioa vani'aha ada Jesus: —Moisés kohana biva'ahaki ada makhira kidigamo-ra nahojahavini. Binahojahavini viahania papira jirikia bino'a'ihi, kidigamo hijanaria kaimoni. Bino'avini naothinia, bihonaria'ihi ajihini. Nimania ida Moisés athi Deus kava'isohihi jirikia hojaki — Jesu-ra vani'aha adani farisio. ");
INSERT INTO padNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus va'ora ni'aha: —Ni-avanofiki ida Deus athi-ra avanaabajahakivini, oniani ida Moisés kohana makhira-ra va'ahavini hija, kidigamo-ra nahojahavini. Asia vakhaniki adani ija'ari vahokiki hidakaba'i, Deus athi-ra vanaabajahakivini-ra vanofiravini. ");
INSERT INTO padNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Deus va'ora namonahaki adani makhira gamo khama. ");
INSERT INTO padNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kidigamo-ra anakaravini mani ida makhira, kidiamia, kidiabi'i vihiki-ra va'ora aakara'ovini hija. ");
INSERT INTO padNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Makhira, kidigamo khama avaakarana viahania vi'bamiha. Avaakara'ina naothinia, ija'ari hoarani fori vihina vahoja'aha kidigamo khama. ");
INSERT INTO padNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Deus vani va'ora anakaramisi'ara adani. Hari'a ija'ari vaabono vakanahoarihakhamava. ");
INSERT INTO padNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hari. Anokhomi'ihi ida Jesus kavarani. Ai vihi'aha, gora bodinia avi'oi'aha. Ipohina vanana'dohi'aha kidivarania. ");
INSERT INTO padNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Vakadina'dohi bigathani'aha: —Makhira binahojahahi ida kidigamo, gamo hoariha-ra anakarara kaimoni, jahari'oamanija ida makhira kahojai. ");
INSERT INTO padNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Gamoa binahojahaha ada kidimakhira, makhira hoariha-ra anakaraja kaimoni, jahari'oamanija ida gamo kahojai — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hari. Oniaroa, ija'ari va'ora vavikhaha adani vakadisai Jesus kania. Vanofiki ida Jesus vakadisai-ra va'ora kajoamoravini. Oniaroa, kidipohi va'ora vakaabani'aha adani isai-ra vavikhaki: —Hari'a va'ora vavikha va'oani isai. ");
INSERT INTO padNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus ipohina-ra va'ora nokiha, va'ora kaja'oria'aha, va'ora ni'a'aha: —Jakaho vikhava va'oani isai kodiania. Hari'a va'ora vakaabani kodiania vikhana. Hi'adani isai fori vihiki vani hadani Deu-ra vanofijahakira. Isai vania vanofira ada Deus va'ora vaka'da'dira kaimoni. Isai fori vihi'a bana mahija Deu-ra avagathanivini, avakadika'da'di hi'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Vakava'ibodivarani hida oathi. Isai fori vihi'a mahija Deu-ra avagathanivini avakadika'da'di hi'ara kaimoni. Isai fori avihirihi; jokoa avakadika'da'di hiriha ada Deus, jokoa Deus ibavia avarikharihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Oniaroa, Jesus isai-ra va'ora gathanihanana'aha, va'ora kaabadaronahahahavi'aha, Deu-ra kanikharia'aha va'ora kajoamorara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hari. Ajihina kaba'i ada Jesus, kha'aha ada makhira ki'darahana. Jesus viaha kajo'atharari'aha, bini'a'aha: —Jesus, ijaha'oamanija. Onofiki bana ida kodimahi anokhomiriki Deus kania. Hana hini badani jahaki ida bada oni'aja kaimoni, oabinina kamahini Ibavi Jahaka'oakia ookhaja kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesua bigathani'ihi ida kidina'dohi: —Nahina ida ojahana-ra ikahivini hija? Deus oavani ada jahara. Ni-nahina hoariha jahaki. ");
INSERT INTO padNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Iogaki ida Deus kava'isohihi jiriki. “Hari'a hoariha-ra naabini! Hari'a ivi'oma oni makhira hoariha kagamo! Hari'a bo'dia! Hari'a hoariha-ra korijanahia akaraganaha! Hari'a hoariha-ra korijanaha! Ikamitha'a oni kadabi'i, kadamia vihiki ira vara vani'avini.” Nimania hida Deus kava'isohihi jiriki. ");
INSERT INTO padNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hari. Niha ada makhira: —Jesus, isai ohina kari vani, onaabaja hida Deus kava'isohihi jiriki afobakhia. ");
INSERT INTO padNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesua vada bini'a'aha, bivajahamanihi ida hojana, bini'a'aha: —Ida asia mani hojahi badani hoarani bada ini'aki kaimoni. Okha'a bana. Kadanahina, kadainisika hiki-ra pavakari niha'a afohahavi. Ija'ari vakanahinariki-ra va'ora no'avinihi ida kadajiniro. Deus ibavia iokhani kamahini ni-nahina-ra bana ikainamoki. Kadapavakarihi naothinia hora vaipohiha'a. ");
INSERT INTO padNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hari. Makhira mitha bini'a'ihi ida Jesus athi. Kidinahina ahapini gahinai hini varani hini mani ida va'i mokara ni'ani hija. Ni-no'ai hini binofiki. Ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hari. Jesua binokiribani'aha, ipohina-ra va'ora ni'a'aha: —Vakanahina'ahapikiki vakadinahina ipohiki-ra vanofivini mani ida Deu-ra vagathaniravini hija vakadika'da'di kaimoni hina. ");
INSERT INTO padNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Vakava'ibodivarani'ihi ida athi. Jesus va'ora ni'a'ianaha: —Oipohina, vakadinahina va'ora kakodiaki vaabono vavanihavini mani ida Deu-ra vagathaniravini hija vakadika'da'di kaimoni. Ija'aria vanofivini kaba'i ida Deus ibavia okhani, ni-vakaabokaki. ");
INSERT INTO padNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Oniaroa, Jesus va'ora kavarajomiki adani ija'ari cavalo avi jo'onia okhajavarina-ra kaabokaravini vani fori vihina. Avi jo'onia cavalo okhajavarina-ra kaabokariki fori vihiki adani vakanahina'ahapikiki. Vakadinahina-ra vanofijahakivini mani ida Deus vakadika'da'di hina-ra vagathaniravini hija, oniani ida Deus ibavia va'ora arakharija. Ni-vakaabokaki ida avikhana. Ija'ari vakadinahina-ra vavakaijokavini oadani, ni-vakaabokaki ida Deus ibavia avikhana. ");
INSERT INTO padNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jesus ipohina vakamithahi ida athi. Vakava'ibodivarani'ahapiki'ihi, vaabono vakanana'dohikhama'aha: —Ka'oa mani ida koda iathini, ni-nihanikia ija'ari abononi akava'ijoaki, Ibavi Jaharika'oakia okharia kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Oniaroa, Jesus vada va'ora ni'aha, va'ora ni'a'aha: —Ni-ija'ari abononi akava'ijoavini-ra kaabokaki. Deus ka'oa ija'ari-ra akava'ijoavini-ra kaabokaki. Deua bikaabokaki ida badani hahavi danoki bada ni'ani. ");
INSERT INTO padNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hari. Pedroa bini'aha: —Mitha ini'a. Harivani akadinahina, agorana, akadija'ari vihiki-ra va'ora anahojahahahavi'iki hari, ira avaipohihaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus va'ora ni'aha: —Ka'oa hiki ida kodivarani. Kodipohia binahojaha'iki ida gorana, igamina, kidiabi'i, kidiamia, kidisai, kidiarabo hiki, vara bivani'aka'oaja kaimoni ida omonina jahaki, ovari abinirina oadani gahinaki bana nahina ipohikia. ");
INSERT INTO padNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Pa'itxi-ra nahojahaki, karaho ida bigathaniki bana. Karahohi ida binahojahaki, karahoni arafiaki ida bigathaniki bana. Kodipohia binahojahi ida kidinahina hoarani hora kakodiaja kaimoni, Deua bianaipohi'ianahi 100 hiki ipohinia. Hora vanofiriki va'ora vavajahariki jaboni adani oipohina, oniani ida va'ora vanajahariharivini hija bana. Hari. Abinina naothinia gahinaki jaboni bana kidimahi jahaki anokhomirikia Deus kania. ");
INSERT INTO padNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hari. Ija'ari vaipohiki va'oaniaro miro'a Deus va'ora baranahavini, avi'oisiagaki adani Deus ija'ari-ra vaka'da'divini kania. Ija'ari vahoariha Deus va'ora baranahavini-ra vakamitharonisiagaki, va'oaniaro miro'a avi'oiki bana adani Deus ija'ari-ra vaka'da'divini kania — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hari. Oniaroa, ai vihi'aha adani Jesus, Jerusalém sidajia avikharimananina. Okhananavaha ada Jesus. Avikasiagaha adani ipohina. Jesu-ra vakava'ibodivarani'aha. Vahoariha avikasiagaki vava'i soko iniki. Ipohina vihiki-ra va'ora avikhananavapa'itxiha, va'ora nava'isohi'ianavini hiki ida namitha'iariki kidiania. ");
INSERT INTO padNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Mitha vani'a. Jerusaléa aokhaki hari. Hovani ija'ari hahavi vakadi'aajo ho. Hora avarakhaki bana adani vahoariha sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama vasa'a kabodinia. Va'oaniaro vakhaniki bana adani: “Jahaki ida abinina.” Vakhaniki bana adani. Oniani ida ija'ari Deu-ra avigariki vasa'a kabodinia hora avarakhavini hija bana. ");
INSERT INTO padNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Oniaroa, hora avigarahaki bana adani, hora vakaathovini, hora vidafiavini, hora vanaabiniki bana adani. Hari. Mahi ahoarabakosiki radaha'ihi, oahokiki bana ho — va'ora nava'isohijora'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hari. Oniaroa, Jesu-ra vanamaakariha adani Tiago, João khama. Va'oaniaro Zebedeu kaisai 'bamakhama adani. Jesu-ra vani'aha: —Aajo, anofiki bana ida bada ini'aki ira akanikhariavini hiki. ");
INSERT INTO padNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—Nahina mani hida avanofija? — Jesus va'ora nana'dohi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Vani'aha: —Ija'ari hahavi-ra ivaka'da'divini kamahini ijahani ivagani nokiaki bana i, ija'ari khai ira vani'aki bana adani. I'dihania avithina-ra anofiki hari, hoarana ipitani aniaja, hoariha ipitani kajasonija — Jesu-ra vani'aha adani Tiago, João khama. ");
INSERT INTO padNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Va'ora ni'aha: —Ni-avarigajahakiki ida avakanikhariaki. Okapoariki bana ida oimana 'banani. A'onivani avakapoarimania koda bana ida avaimani 'banani jaboni? Ni-okajoniki bana ida hora vanajahariharivini. Avakajonimania koda ida bana a'onira vanajahariharivini? Hofori avihimania koda bana? ");
INSERT INTO padNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Vani'aha ada Jesus: —Ha'a. Ni-akajoniki ida aimana 'banani — vani'aha. Oniaroa, Jesus va'ora ni'aha: —Avakapoariki bana ida avaimani 'banani. Ni-avakajoniki bana ida a'onira vanajahariharivini. Hofori avihiki bana a'oni. ");
INSERT INTO padNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Avavithini-ra avanofihi o'dihana. Kodibadani hirihi ida ija'ari-ra onagathogathovini o'dihana vavithira kaimoni. Deua binaibavijahaki ida ibavi opitana ka'aniajanija kajasonija jaboni, va'ora nagathogatho'iki adani ija'ari vavithiki kaimoni o'dihana. ");
INSERT INTO padNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hari. Oniaroa, vakadivarani kamithamahani vihiha adani 10 vihiki vaipohina, oniani ida Tiago, João vihiki-ra va'ora vakaja'oriavini hija. ");
INSERT INTO padNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hari. Jesus va'ora baranaha'aha adani ipohina hahavi vamaakarina. Va'ora ni'aha: —Va'ora avarigamanira adani ija'ari Deu-ra avigariki vakadika'da'di vahojana. Va'ora avavadadamiki adani vakadija'ari. Ija'ari Deu-ra avigariki vakadika'da'di va'ora vahonariafiahaki adani jaboni vakadipamoari vaathi naabani vihira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ni-onofiki ida ija'ari-ra avahonariavini, va'oaniaro ija'ari-ra vahonariavini fori hini. Ka'da'di avihini-ra avanofihi; jakaho ija'ari hahavi kahonai abono fori vihi'a bana. ");
INSERT INTO padNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ka'da'di avihini-ra avanofihi; vahoariha-ra va'ora vaakodia bana! ");
INSERT INTO padNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hovani ija'ari hahavi vakadi'aajo ho. Vahoariha-ra va'ora okajoamoravini hida hora rakhaja. Vahoariha hora vakajoamoravini hirihi hida hora rakhaja. Ibavi Jaharika'oakia avikhaki bana adani ija'ari vaipohiki. Oabono ova'ahaki ho oabinina ija'ari hahavi-ra va'ora oakava'ijoaja kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hari. Jericó sidajia avakhano'aha adani Jesus ipohina khama. Ija'ari vaipohiki va'ora vavaipohihaha adani Jesus. Ai vihi'ianaha. Ai vihina kaba'i Bartimeu kamaodorohaki hagihi vadinia vithima'oki. Jiniro kanikhariava abono ada Bartimeu, Timeu kaisai ada. ");
INSERT INTO padNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hari. Hagihi vadinia vithima'ona kaba'i vani, bikamithahi ida Jesus varani hina. Jesus radahana-ra vanamoniha adani vahoariha. Bikamithahi, bodi'baraha'aha: —Jesus, ivani Davi kohana kaija'ari namitharonisiagaki i, hora va'adi bana! ");
INSERT INTO padNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ija'ari vaipohiki vahoariha vakaabaniha: —Avisoni'a bana! Hari'a bana bodi'barahajana! Ni-avisoniki. Vakaabaniha ana'barahana hi'oamanihi. —Jesus, hora va'adi bana! ");
INSERT INTO padNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ogaakosoa'aha ada Jesus, va'ora honaria'aha: —Vibaranaha bana! Oniaroa, vibaranaha'aha. —Khai ini'a bana ida ira baranahavini! Jorakia bana gaa'a — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Biani'ihi ida kidikarahobi. Binahojaha'ihi, gaajoraki'aha, Jesus kania okha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesua binana'dohiha: —Nahina mani hida inofija kodiania? —Jesus, onofiki hida onokho-ra ianavagahavini — bini'aha. ");
INSERT INTO padNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Oniaroa, Jesua bini'aha: —Ba adaha'a! Hora ikajari'daravini mani ida inokhoni-ra najaha'ia. Jorakia vagaha'ihi ida nokho 'ba'dani. Oniaroa, Jesus naothia kasiagajabana'aha. ");
INSERT INTO padNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hari. Ai vihi'aha adani Jesus, Jerusalém sidaji-ra avanamaakari'aha. Vakaikahi'imidiana arabo'oa namahiki kania, monte das Oliveiras onikia. Ibavi 'bamiki kahararakhamania hojahi ida arabo'oa namahiki. Ibavi hoariha Betfagé oniki. Ibavi hoariha Betânia oniki. ");
INSERT INTO padNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Hari. Avamaakarina kaba'i Jesus va'ora honaria'aha adani ipohina vi'bamiki: —Avikhananava'a bana. Ibavi kahararakhamania avakaikahihi, avakaragaki bana o jumento pa'itxi ahosagaki. Jumento pa'itxi ni-nahina okasiki kaho namana. Avakokhariha, hida kodiania vavikha bana. ");
INSERT INTO padNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ija'ari a'onira vahabini bana vanana'dohivini hiki avakadibadani. Va'ora vanava'isohi bana: “Jesua birihavini binofi'imidiaki hada. Naothinia asa'ianaha ibavia.” Va'ora vani'a bana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oniaroa, avikha'aha adani vi'bamiki. Vakaraga'aha ada jumento pa'itxi hagihia ahosagaki gora banininia. Vakaragaha, vakokhari'aha. ");
INSERT INTO padNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Vakokharivini kaba'i, kajumentoki va'ora nana'dohi'aha: —Nahina mani oni avakadibadani hija? Nahina kaimoni mani o jumento-ra avakokharivini hija? ");
INSERT INTO padNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","—Jesua biriha'imidiavini binofivini mani ida akokharivini hija. Birihavini naothinia asa'ianaha ibavia — va'ora vani'a'aha. —Ba avavikha — va'ora vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Oniaroa, Jesus kania vavikha'aha. Jumento pa'itxi namana avarakasi'ihi ida vakadikarahobi. Okasi'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jesus radahana kaba'i, ija'aria vanahojahi ida vakadikarahobi jumento viaha hagihia. Vahoariha avava'boa'ahapikihi ida avaafani. Vanahoja'aha jumento viaha hagihia. Vakadihojai oamani ida vakadibadani hija. Ka'da'di jahaki viaha vanahojavini ida vakadikarahobi, avaafani hiki. ");
INSERT INTO padNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hari. Avikhananavaki vabodi'bara'iki, avikasiagaki jaboni vabodi'bara'iki. Khai vakhanina mani ida athii 'barakia Deus jahana-ra vara vavani'avini hija: —Jahaki vagaki ada Deus! Deua bikarona'iki ada Jesus kha'ina, ija'ari vakadika'da'di hira kaimoni. Deus, ikajoamora bana ada ikarona'iki akadiania! ");
INSERT INTO padNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Davi kohana kaisai namitharonisiagaki ada. Ovari fori hiki ada Jesus. Akadija'ari-ra va'ora vaka'da'diki bana ada. Khai ani'ava ada Deus. Vabodi'barabakhiaha adani ija'ari vâipohiki. Khai vani'a'ihi ida Jesus kha'ina. ");
INSERT INTO padNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Hari. Jerusalém sidajia vakaikahi'aha adani Jesus. Deu-ra khai vani'avini kagorania avikha'aha. Jesua vada bini'a'ihi ida gora kavasiribanini bodini. Mithani vani avajoi'aha. Betânia avikha'aha adani Jesus 12 vihiki vaipohina khama. ");
INSERT INTO padNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hari. Ka'afokajomani Betânia ai vihi'ianaha. Jerusaléa avajoi'aha adani Jesus kidipohi khama. Vai'ami'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bianoki'ihi ida figira avani napaja. Afani hogoki ida figira avani. Binavanavanaha'ihi, binako'dihi ida ihi'ai. Figira avani kania akhanoha, bikaraga'ihi ida avaafani ka'oa. Ni-kidibonoi kamasikoni hiki kaho. ");
INSERT INTO padNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesua bini'a'ihi ida figira avani: —Ni-nahina bihajanaki ida ibononi. Kidivarani kamithamahani vihiha adani Jesus ipohina. ");
INSERT INTO padNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hari. Jerusalém sidajia vakaikahi'ianaha adani Jesus kidipohi khama. Deu-ra khai vani'avini kagorani kavasiribanini bodinia avikhajakosi'ianaha. Jesus va'ora noki'aha adani ija'ari vaipohiki igitha-ra pavakari va'ora vanihaki. Ija'ari vakapavakarivini hiki ida igitha Deu-ra vakanava'igavini kaimoni hini. Jesus va'ora aakoja'aha adani pavakarihi abono. Va'ora aakojaha jaboni adani igitha-ra vakapavakarihaki. Jiniro anabosiva vakadimesa-ra akanaadarioni'aha. Ho'doko-ra pavakari vakanihaki vakadivithi ibavini-ra akanaadarioni'aha. ");
INSERT INTO padNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Athi khanakia va'ora ni'aha ai vihira kaimoni. Va'ora ni'aha: —Hari'a avakadinahina-ra vakaiba'i Deu-ra khai ani'avini kagorani kavasiribanini bodinia. ");
INSERT INTO padNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Oniaroa, va'ora ka'ojomo'i'aha, va'ora ni'a'aha: —Deus athi kapapirania hojaki hida athi: “Deu-ra khai vani'avini kagorani vania vakaikahiha adani arabo hahavi kaija'arini, Deu-ra vara vani'ara kaimoni.” Niki ida papira athini. Bo'di abono ibavini avavanihamanija hida gora? Igitha kaidivani-ra avanakarahovini mani ida ija'ari-ra avabo'diabakhiavini hija — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hari. Jesus va'ora aakojavini kavaranihi-ra vakamithavini adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama. Vaabono vakani'akhama'aha: —Jahaki ada abinina Jesus. Nihanikia kodavaha anaabinira ada? Jesus ka'ojomo'ihi athini-ra vavajahaki adani ija'ari vaipohiki. Va'ora afiniki adani Jesu-ra vavajahaki. Jesu-ra anaabinihi; haria vakaihamahikarahoki bana adani — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mithani vaivaini ai vihi'ianaha adani Jesus Jerusaléa. ");
INSERT INTO padNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hari. Oniaroa, ka'afokajomani Jerusaléa avajoi'ianaha. Vanoki'ianahi ida figira avani ara'okhohahaviki, 'damania ara'okho'iki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedroa bikava'ihokihi ida Jesus kavarani. Oniaroa, bini'a'aha: —Aajo, vada ini'a ida figira 'damania ara'okho'iki. Inajahari'iki oni hidanija aradahana, abonobakhiajanarini ikahi'iki oni, oniani ida figira-ra anara'okho'ia. ");
INSERT INTO padNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Oniaroa, Jesus va'ora ni'aha adani ipohina: —A'onira onava'isohiki bana ho. ");
INSERT INTO padNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Avava'ini kakhakhamarini vani Deu-ra avakajari'darihi; badani danoki ipohiki-ra avakaabokaki bana a'oni. Avakaabokaki jaboni ida arabo namahiki-ra avahonariavini: “Arabo namahiki, akara'o'a! Iabono nahokahi'a paha bihiaki bodinia.” Deu-ra avakajari'darihi; namithaki bana ida avani'aki. ");
INSERT INTO padNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A'onira onava'isohivini hiki, Deu-ra avakajari'darihi; avagathanihi ida kidiania avakanikhariaki. Avagathanivini avakajari'darihi; avagathanihi. ");
INSERT INTO padNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Deu-ra avakanikhariavini viahania vahoariha-ra va'ora avakariaka'a bana. A'onira vanaihamahi'iki adani vahoariha, avakava'i'birini'a bana ida vakadihojai asohiriki mahija avakadiabi'i nama hojaki avakadihojai asohiriki-ra na'biravini jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Hoariha kahojai asohiriki-ra avarakava'i'birinirihi; ni-avakadihojai asohiriki-ra na'biraki ada avakadiabi'i nama hojaki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hari. Jerusaléa vakaikahi'ianaha adani Jesus. Deu-ra khai vani'avini kagorani kavasiribanini bodinia avikhajakosi'ianaha. Jesus kania avikhami'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono, judeus kaija'ari vaka'ojomo'iva abono vihiki. ");
INSERT INTO padNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesu-ra vanana'dohi'aha: —Nahina vani ira honariavini hija ida kadabadani-ra bada ini'avini? ");
INSERT INTO padNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Va'ora ni'aha ada Jesus: —A'onira onana'dohi'imidiaki bana ho. Kodina'dohi-ra avagathanihi; a'onira onava'isohivini hiki bana ada hana hina hora honariaki. ");
INSERT INTO padNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hora vananamitha'a bana, João Batista kohana va'ora kana'iki adani ija'ari vakadihojai asohiriki-ra vakava'ipahini'iki. Hana hina vani João Batista kohana-ra honariaja ija'ari-ra va'ora kanara kaimoni? Deus vania koda bihonariara ada João Batista ija'ari-ra kanavini? Ija'ari vania koda bihonariara ada João Batista ija'ari-ra kanavini? — va'ora nana'dohi'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","Oniaroa, vaabono vakani'akhama'aha adani sasidotxi vavaka'da'diva: —Anofirihi ida João Batista Deua bihonariavini-ra akahivini. Ni-anofiki jaboni ida Deus João Batista-ra honariaravini-ra akahivini. Deus João Batista-ra karonavini-ra akahihi; jaharihi ida João Batista athi-ra akajari'davini Jesua bikahivini. Deus João Batista karonaravini-ra akahihi; ija'ari haria vakaihamahihi. Haria vakaihamahivini hiki João Batista Deus athi namoniva abono hina-ra vakajari'daravini — vaabono vakani'akhama'aha adani sasidotxi vavaka'da'diva. ");
INSERT INTO padNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Oniaroa, Jesu-ra vani'a'aha: — Ni-aogaki ida João Batista Deua bihonariavini bihonariaravini ija'ari-ra kanavini. Oniaroa, Jesus va'ora ni'a'aha: —Hora avananamitharihi; ni-a'onira onanamithaki jaboni hora honariakia — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hari. Oniaroa, rajomi kavaranihia Jesus va'ora vara ni'aha adani ija'ari vajoroniki. —Ka'da'dia bivahonariahihi ida siroi uva rakhajahani ibavini kaimoni. Bivahonariahihi ida uva avani rakhajahani. Bono'ihi havahaki kaimoni ida ihi'ai uva oniki. Varakhaivini naothinia, bivahonariahihi kavasiribanini ida uva avani kasiroini. Binamonahaki ida ja'di kabavihi karaho bihiaki, uva bavini kaimoni, uva-ra vakada'aha'ahavini hiki a'bani aniaja kaimoni. A'diahi'ihi ida uva bavini, bivahonariahihi ida gora namahiki amonahani, kidisiroi-ra akadava'avini ibavini kaimoni ida gora. Hari hi'ihi ida kidibadani, va'ora honariaha adani badani abono avakadava'aja kaimoni ida kidiuva avani. Avakadava'ahi ida uva avani, bono'ini kamahini a'bani pitani vakadimoni, pitani vakadika'da'di kaimoni. Bivahonariahivini naothinia, ajihi'aha. Ibavi hoariha napaja hikia okha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Oniaroa, uva a'dihani kamasikoni vani, ka'da'di va'ora karona'aha ada kidihonai abono. Bini'aha: “Okha'a bana uva avakadava'ava abono vakadiania mahija kodivinho pitani-ra igathanivini kodimoni.” Hari. Ajihi'aha, uva kasiroini kania kaikahi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Uva avakadava'ava abonoa vagathi'aha, vidafiaha'aha ada makhira. Dairina vani vahonaria'aha ajihi'ina. ");
INSERT INTO padNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hari. Ka'da'dia bikarona'ianaha ada honai abono hoariha, uva akadava'ava abono vakadiania okhana. Kaikahina vani, vanajaharihari'aha, ka'da'di vakodafiaha'aha, vakanasii'ihi jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hari. Ka'da'dia bikarona'ianaha ada honai abono hoariha. Okhaha, kaikahi'aha, vanaabini'aha. Hari. Ka'da'di va'ora karonabakhiaha adani kidihonai abono vâipohiki afohanana. Uva avakadava'ava abono va'ora vidafiahaha adani ka'da'di kahonai abono. Vahoariha-ra va'ora vanaabinika'oa'iki. ");
INSERT INTO padNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hari. Ka'da'dia bivahojamaniha ada kidisai hoarana. Binakaidivaki ada kidisai. Abono-ra ni'aha ada ka'da'di: “Kodisai-ra vagathanijahakiki bana adani uva avakadava'ava abono.” Oniaroa, bikarona'aha ada kidisai. ");
INSERT INTO padNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Uva avakadava'ava abonoa vanoki'aha khana. Vaabono vakani'akhama'aha: “Hada vani akadika'da'di kaisai. Ka'da'di abinina kamahini kidisaia bigathaniki ida kidiabi'i kaarabo afohahavi. Anaabiniva mahija kidiarabo avahojavini.” Vaabono vakanava'isohikhamavini. ");
INSERT INTO padNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hari. Kaikahi'aha ada ka'da'di kaisai, vagathiha, vanaabini'aha, aba'ona vanahokahi'aha uva kasiroini banininia. ");
INSERT INTO padNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Hari. Jesus va'ora vara ni'aha adani kidirajomi kavaranihi kamithani vihiki: —A'onira onava'isohivini hiki bana ida ka'da'dia bada bini'aki kaimoni. Okhaki bana ada ka'da'di va'ora naabinihaki adani uva akadava'ava abono bana. Vahoariha maina-ra va'ora honariaki bana ada kidiuva kasiroini akadava'ani vihira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hari. Jesus va'ora ni'aha: —Avanoki'iki ida Deus athi kapapirani athini: “Hojaki ida ja'di jahaki, ja'di kagorahi dadani kaimoni. Gora namonahava abonoa ni-vanofiki ida ja'di karaho. Jahani kaba'i, ni-vanofiki ida ja'di. ");
INSERT INTO padNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Vanofiravini kaba'i, Deua binagathogatho'iki ida ja'di karaho. Akava'ibodivarani'iki ida ja'di Deua binagathogatho'iki. Jahani arafiaki ida ja'di karaho.” Nimania ida Deus athi papira hojaki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Rajomi kavaranihi-ra mitha vani'aha adani judeus kaija'ari vavaka'da'diva, vahoariha khama. Vaabono vakani'akhama'aha: —Jesus haria kavarajomivini vihiki adani uva avakadava'ava abono, vinhoa vakadika'da'di-ra vakaathirivini — vaabono vakani'akhama'aha. Oniania, Jesu-ra vagathivini-ra vanofi'aha, cadeia avibaivini vanofiha. Ija'ari vaipohiki-ra vifinivini mani ida Jesu-ra vagathiravini hija. Ai vihi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hari. Judeus kaija'ari vavaka'da'diva vaabono vakanava'isohikhama'aha: —Jahaki ida Jesu-ra anana'dohibakhiavini, asohijanaria kaimoni ida kidivarani, oniani ida anaathidanoararivini hija. Oniaroa, farisio va'ora vahonariaha adani vaipohina, Iroji ipohina vaipohiriki khama Jesus kania avikhana, Jesu-ra vakaboroborora kaimoni vakadina'dohia. ");
INSERT INTO padNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Oniaroa, Jesus kania avikha'aha, vani'a'aha: —Jesus, aogaki ida ija'ari vava'i-ra ivajaharavini kadavarania. Ija'ari hahavi-ra va'ora ika'ojomo'ivini hiki ida badani Deua binofiki, bada vani'ahaha'oadahaja kaimoni. Ija'aria vavajaharavini kaba'i ida kadavarani, ni-ianahoarihaki oni iathini khai va'ora ni'aja kaimoni. Vara ivani'aka'oaki ida varani ka'oa hini. Haria nanamitha bana Deus kava'isohihia: Deus haria honariamanija imposto kajinironia arabo kaka'da'dini-ra ano'avini? Jahamanija koda ida arabo ipohiki kaka'da'dini athi-ra anaabavini? — Jesu-ra vanana'dohi'aha. César oniki ada arabo ipohiki kaka'da'dini. ");
INSERT INTO padNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Vakaboroka'oavini-ra ogaki ada Jesus. Oniania, va'ora ni'aha: —Avajahani-ra avakahi'badaraki a'oni! Ni-avarigavini avanofidoroki ida avakadina'dohi. Avanofiki ida hora avakaraganahavini, oniani ida hora avakaboroka'oavini hija. Hora vakavikha jiniro 'ba'dania mahija imposto kajinironi-ra vada oni'avini — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hari. Vavikha'ihi, Jesus va'ora nana'dohi'aha: —Hana hina onina mani hida? Hana hina ka'da'di akamoani mani hida? Vani'avini: —César ka'da'di akamoani, onina hiki mani oni. ");
INSERT INTO padNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Oniaroa, Jesus va'ora ni'a'aha: —Césa-ra vano'a bana kidinahina binofikia. Deu-ra bana vano'a jaboni kidinahina binofikia — va'ora ni'aha. Vakamithahi ida Jesus athi, vakava'ibodivarani'ihi ida niha ninini vakadina'dohi bigathanivini. ");
INSERT INTO padNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hari. Oniaroa, vikha'aha adani sadosio. Sadosio vakadivarani hiki ida ija'ari abinini naothinia abononi ahokirini. Hari. Jesus kania vamaakari'aha adani sadosio. Vani'aha: ");
INSERT INTO padNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Jesus, Moisés kohana ija'ari-ra va'ora ka'ojomo'ivini hida: “Isarina oadani abini'aha ada aajojahiki, kaariha hi'ihi ida kidigamo, kajo'ojahikia bianakara'ihi ida kaariha, bivaisaja kaimoni ida gamo, kidi'aajo kohana kaisai hija kaimoni ida kidisai.” Nimania ida Moisés athi Deus kava'isohihi jirikia hojaki. ");
INSERT INTO padNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hari. Ahararana vahoja'iki adani 7 imakhinava kohana, 7 vihiki vaigamina adani. Aajojahikia bianakara'ihi ida kidigamo. Kidigamo-ra vaisaravini oadani abini'aha. ");
INSERT INTO padNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oniaroa, kidikajo'oa bianakara'ihi ida kidigamo kaariha biniha'iki. Bivaisaravini vani abini'aha ovari maina. Kidikajo'o hoariha bianakara'ianahi ida vakadigamo kaariha vanihaki. Bivaisaravini vani abini'ianaha jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kidikajo'o hoariha bianakara'ianahi ida vakadigamo kaariha vanihaki. Onivani fori hija ida kajo'ojahiki vahoariha avanakarahananavini ida kaariha afohanana. Vavaisaravini vani vaabini'aha afohanana. Vaabinihahavina naothinia, abini'ihi ida gamo jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Haria nanamitha bana Deus kava'isohihia. 7 vaigamina vaabinina viahania avanakarahanana'iki ida gamo. Ija'ari kohana ahokini kamahini, hana hina vani bana kagamo hija ida gamo? ");
INSERT INTO padNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","25","Hari. Jesus va'ora ni'aha: —Iniani. Asohirihi ida avani'aki! Ija'ari abinini ahokini kamahini, makhira ni-vaagamojanaki. Gamo ni-vakamakhirajanaki jaboni. Deus ibavi kaija'arini avakararina vani fori hija ida ija'ari ahokiki. Ni-avarigaki ida Deus athi papira hojaki. Deus athi-ra avarigaravini mani ida avakadivarani-ra avakanasohikhamaravini hija. Avarigarihi jaboni ida Deus danona. ");
INSERT INTO padNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hora avanana'dohivini hiki ida ija'ari abiniki ahoki'ini. Deus athi kapapirani a'onira nava'isohivini hiki ada Moisés kohana. Ovania binokija ida ava patxaniki ha'diki. Ha'dini kaba'i ni-ihimiki. Vada bini'avini oadani, Deua bini'aha: “Moisés. Hovani Abraão kaDeus ho, Isaque kaDeus ho, Jacó kaDeus ho.” Niha ada Deus. Vaabini'bo'da'iki adani Abraão, Isaque, Jacó vihiki. ");
INSERT INTO padNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kidimoni vihina asia vahokiki adani, ni-ihimiki ida vakadimahi. Ni-avahokijanana va'ora avakahiki, oniani ida avakadivarani-ra avakanasohikhamaravini hija. Avahoki'iki adani ija'ari vaabini'iki, asia vakadiDeus hiki ada Deus — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hari. Vara vaabono vakani'akhamavini kaba'i adani Jesus, sadosio vihiki, kaikahi'aha ada judeus kaija'ari ka'ojomo'iva abono. Abono-ra ni'aha: —Jesua biogajahakiki ida Deus athi. Jahaki ida vakadina'dohi bigathanivini — abono-ra ni'aha. Oniaroa, ovari maina Jesu-ra nana'dohi'aha: —Ipohiki ida honari Deus kava'isohihi jiriki kania. Hana hini honari ida Deus kava'isohihi jiriki hahavi-ra aradaja? ");
INSERT INTO padNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Hari. Jesua bigathanihi ida kidina'dohi: —“Israel kaija'ari mitha vani'a! Ka'da'di oamani ada akadiDeus. Ovani ka'oa ada akadika'da'di hira. ");
INSERT INTO padNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Inofijahaki'a afoha'oadaha o Deus akadika'da'di o. Bada inini oadani, inofijahaki'a o Deus. Iva'ini bodini vara nini oadani, inofijahaki o Deus. Mahi, joma hiki inofijahaki'a afoha'oadaha.” Nimania ida honari jiriki. ");
INSERT INTO padNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Onivani fori hija ida honari hoariha Deua binofiki anaabavini jaboni. Deus haria honariavini hiki ija'ari hahavi-ra anofijahakivini. Nihi ida Deus kahonari: “Iabononi inofijahakivini vani fori va'ora niha va'oani ija'ari hahavi.” Nihi ida athi. Ija'aria vanaabajahakihi hida honari 'bamiki, vanaabahahaviki jaboni ida Deus kahonari — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jesu-ra ni'aha ada judeus kaija'ari ka'ojomo'iva abono: —Hai oamani Jesus. Asohiki ida iathini. Hojaki ada Deus hoarana ka'oa. Ni-hojaki ada Deus hoariha. ");
INSERT INTO padNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bada akhanina kaba'i anofijahakiha ada Deus, ava'i bodini vara nini kaba'i anofijahakiha, mahi oadani, joma oadani anofijahakiha, ija'ari hahavi-ra anofijahakihi jaboni, ariabono anofijahakivini vani fori anihavini, onivani fori hini Deua binofivini jaboni. Jahaki ida Deus kahonari-ra anaabavini. Kidihonari anaabariha; ni-arajomaki ida Deu-ra akanava'igavini igitha abononi aha'diki, nahina hoariha hikia. ");
INSERT INTO padNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesua mitha bini'a'ihi ida athi, bikava'ibodivaranivini hiki ada judeus kaija'ari ka'ojomo'iva abono ogahana. Jesua bini'aha: —Ida amaakarihi Deu-ra igathanivini kadaka'da'di kaimoni hina — niha ada Jesus. Hari hihi ida vakadivarani. Ni-Jesu-ra vanana'dohijanaki, vakaipahihi ida vanana'dohivini. ");
INSERT INTO padNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Oniaroa, Deu-ra khai vani'avini kagorani kavasiribanini bodinia Jesus va'ora ka'ojomo'iha adani ija'ari. Jesua bini'aha: —Akadija'ari vaka'ojomo'iva abono vaathi hini: Davi kohana kahanodi namitharonisiagaki ada Cristo. Vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma'onahai Jahaki Davi va'i-ra nahonariahihivini vani kidika'da'dia binaoni'ara ada Cristo. “Deua bini'aha ada kodika'da'di Cristo oniki: ‘I'damani kanabo'ania va'ora oobaiki bana adani ira vavajahariki. Va'ora ikada'aha'ahaki kaimoni. Va'ora onihimahahaviravini oadani, vithi bana hida opitana aniaja ka'da'di ihini kodiania.’ Kodika'da'di-ra ni'aha ada Deus.” Nihi ida Davi kohana athi afojora. ");
INSERT INTO padNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Asia vara ni'aha ada Jesus: —Davi kohana kahanodi hina kaba'i ada Cristo, Davia binaoniki ada Cristo ‘kodika'da'di’. Nahina mani ida Davi kidihanodi-ra ka'da'dia naonivini hija? — Jesus va'ora nana'dohiha adani ija'ari. Ni-avigaki ida vagathanivini. ");
INSERT INTO padNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hari. Ija'ari vaipohikia vavajahaki ida Jesus vara nina-ra vakamithavini. Jesus va'ora vani'aha: —Avaabononi avakava'igairi bana judeus kaija'ari vaka'ojomo'iva abono vakadihojai mahija avakabanaforavini. Vajahaka'oaki vaabono vavanihavini. Makari oadaki-ra vakaimahavini hija, vahoariha vada va'ora vani'ara kaimoni. Judeus kaija'ari vaka'ojomo'iva abono ija'ari vaipohiki vahararana vahojana, vanofiki ida ija'ari vakadika'da'di-ra vaka'ivanitivini vani fori vihina, va'ora vaka'ivanitivini. Judeus kaija'ari Deu-ra vara vani'avini kagorania avikhajakosiha, ija'ari vakadika'da'di vaibavi kania vavithina-ra vanofi'aha, vahoariha va'ora khai vani'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ija'ari va'ora vakaboa'ivini kamahini ija'ari vaipohiki vi'baina vakadiania, judeus kaija'ari vaka'ojomo'iva abonoa vanofiki ida ibavi jahakia vavithina, vahoariha ka'da'di vihiki va'ora vavanihara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Va'ora vakajoamora'badaraha afobakhia adani kaariha afohanana. Kaariha kanahina, gorani hiki-ra visaarivini kaba'i, Deu-ra vara vani'a'badaraki athii oadakia, vahoariha vajahaka'oaki va'ora vavanihara kaimoni. Deus va'ora arakhaki bana jaharini arafiakia nikia vakabadaniki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Hari. Deu-ra khai vani'avini kagorania hojaha ada Jesus. Jiniro bavini hiki kania okhami'aha ada Jesus. Vithiha, vada va'ora ni'aha adani ija'ari vaipohiki, niha vani'a'avini ida vakadijiniro-ra avibaivini bavinia. Deus kaimoni ida jiniro avibaiki. Oniaroa, Jesus va'ora noki'aha adani ija'ari vakajiniro'ahapikiki, avibaihi ida jiniro ipohiki bavi bodinia. ");
INSERT INTO padNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Oniaroa, kaikahihi ida kaariha kajiniroriki. Biobai'ihi ida jiniro 'ba'dani 'bamiki kaidivariki. Kaidivari'oamanija ida jiniro 'ba'dani 'bamiki. ");
INSERT INTO padNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Oniania, ipohina-ra va'ora ni'aha ada Jesus: —Ka'oa oamani ida oni'aki, jiniro karaho oamani oni kaariha biobaija. Jiniro pa'itxi mani ida vahoariha avibaija. Avibaivini naothinia, vakadijiniro asia ipohiki. ");
INSERT INTO padNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Asia vavahojaki hida jiniro karaho vakadinahina abosini kaimoni. Kaariha biobaihi ida jiniro 'bamiki bivahoja'iki. Ni-nahina-ra vahojajanaki ida kaariha kidinahina abosini kaimoni. Jiniro kaidivaki oamani ida Deu-ra no'avini hija. ");
INSERT INTO padNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hari. Deu-ra khai vani'avini kagorani kavasiribanini bodinia vikhaonaniki adani Jesus, ipohina khama. Hoarana bini'aha: —Jesus, vada ini'a oni ja'di na'bahaki. Na'baha'oamanija ida ja'di gora katokinia hojaki. Jahaki ida Deu-ra khai ani'avini kagorani. ");
INSERT INTO padNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Oniaroa, Jesua bini'aha: —Inokihi ida gora karaho jahaki. A'onira onava'isohiki bana ho. Deu-ra vanofiriki vania bana vanihimaka'oaja ida Deu-ra khai ani'avini kagorani. Ja'di na'bahaki-ra vanathararavini kamahini ni-hojajanaki ida ja'di hoarani, ja'di hoariha namania — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hari. Monte das Oliveiras arabo namahikia avigaimori'aha. Vithi'aha ada Jesus. Vahojakosoana, Jesu-ra vani'aha adani Pedro, Tiago, João, André vihiki: ");
INSERT INTO padNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Jesus, mahi nihaforija vani vanihimaki ida Deu-ra khai ani'avini kagorani? Nihanikia bana aogaja ida ijoini kamahini amaakarini? Nihanikia bana aogaja jaboni ida nama, arabo hahavi hiki ihimini kamahini amaakarini? — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hari. Jesus va'ora ka'ojomo'i'aha: —Avaabononi avakava'igairi'a bana. Vahoariha a'onira vakorijanahavini-ra bana vanofiki a'oni. Vakajari'da bana ida vaathi. ");
INSERT INTO padNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vikhaki bana adani korijanahi abono, vakhaniki bana adani afohanana: “Hovani Cristo ho. Deus hora karona'iki avakadika'da'di ohija kaimoni.” Vakhaninanaki bana adani afo'badara. Ija'ari vaipohikia vakajari'darihi bana ida vakadikorijanahi. ");
INSERT INTO padNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Avakamithaki bana ida ija'ari vaabono vakodakhamavini kavaranihi. Ibavi maakariki, napaja hikia ija'ari vaabono vakodakhamaki bana. Varani vihina avakamithavini kamahini, hari'a vaofini! Vaabono vakodakhama'imidiaki adani ija'ari, ni-ihimi'iaki kaho ida arabo hahavi kaija'arini vakadimahi. ");
INSERT INTO padNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Arabo kahijava va'ora vidaki bana adani arabo hoariha kahijava. Arabo kaka'da'dini kidisorara khama va'ora vidaki adani arabo hoariha kaka'da'dini kaija'arini. Ibavi ipohikia ho'doho'doki bana ida arabo afobakhia. Mahi ipohikia ija'aria vakainamoki ida vakadi'bai. Gamo 'banarahani kama'dani vani fori hija ida oni'aki. ");
INSERT INTO padNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hari. Jesus va'ora nava'isohijoraki adani kidipohi: —Avaabononi avakava'igairi'a bana! A'onira vavajahariki a'onira avarakhaki a'oni bana ija'ari vanasohiva abono vasa'a kabodinia. Cadeia a'onira avibaiki bana adani. A'onira vanajahariharibakhiaki bana adani. Judeus kaija'ari Deu-ra vara vani'avini kagorania a'onira avarakhaki bana adani, dafi avihiki bana jaboni a'oni xikotxia. Oipohina avihini mani ida a'onira avisavini hija bana arabo kaka'da'dini vakadiania. Arabo kaka'da'dini vaviaha avahojani kamahini vara vavani'a bana ida omonina jahaki. ");
INSERT INTO padNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ija'ari hahavi vakadimahi anokhomini viahania, arabo hahavi kaija'arinia vakamithaki bana ida omonina jahaki. ");
INSERT INTO padNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A'onira vavajaharavini mani ida a'onira vagathivini hija bana. Arabo kaka'da'dini vakadiania a'onira avarakhavini kamahini, hari'a avakava'isokonijora ida varani vara va'ora avani'avini hiki kaimoni. Vara va'ora avani'avini kamahini, Ma'onahai Jahaki vani bana a'onira nava'isohija bana varania vara avavani'aja kaimoni. Vara vavani'a bana ida kidiva'isohihi. ");
INSERT INTO padNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Hora vanofiriki va'ora vani'aha adani arabo kaka'da'dini: “Jahaki ada oigamina abinina. Jesus ipohina hina mani ida abinina onofivini hija.” Vakhaniha. Hora vanofiriki vahoariha va'ora vani'aki bana adani arabo kaka'da'dini: “Jahaki ida kodisai vaabinina. Jesus ipohina vihina mani ida vaabinina va'ora onofivini hija.” Vakhaniha. Hora vanofiriki vahoariha va'ora vani'aki bana adani arabo kaka'da'dini: “Jahaki ida kodiamia, kodiabi'i vihiki vaabinina. Jesus ipohina vihina mani ida vaabinina va'ora onofivini hija”. Vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Oipohina avihini mani ida ija'ari vaipohiki a'onira vavajaharavini hija bana. Avaabinirini oadani oipohina avihini-ra avakajonirihi; hora avakava'ipahinirihi; Deus a'onira akadava'aki bana a'oni, ni-akamadaki bana ida avama'onahani, Deus kania avarikhaki bana a'oni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hari. Asia vara ni'aha ada Jesus: —Avanokiki bana ida nahina jaharika'oaki ija'aria vakaimajahapa'itxiriki Deu-ra khai ani'avini kagorani bodinia. A'onivani vada avani'a'iki hihida papira, vakava'ihoki bana ida Daniel kohana kava'isohihi Deus athi kapapirania hojaki. Ovaria vara bivani'aja hida hihida pohimajahi ija'ari-ra naimahidaki kaimoni. Nokiani kamahini ida pohimajahi, avigajoraki bana! Judéia kaarabonia avahojahi; arabo namahikia avigajoraki bana! ");
INSERT INTO padNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Gora 'dihania avarakoirihi; avigajoraki bana! Hari'a avi'oi avagorania, avakadinahina-ra avaranikhavini. ");
INSERT INTO padNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Siroia bada avakhanihi; avigajoraki bana! Hari'a avakadimakari-ra avanikha avagorania. ");
INSERT INTO padNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ija'ari avigana kamahini jahariki bana ida gamo vakajahavidoki vakadimoni. Jahariki jaboni ida vaisapa'itxiki vakadimoni, ni-vakaabokaki ida va'ora vavaki'darahavini. ");
INSERT INTO padNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Deu-ra vara vani'a mahija pahisiriki kamasikoni namitharavini hida avigana kamahini. ");
INSERT INTO padNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ojoina kamahini maakarini viahania ija'ari hahavia vaimahidakarahoki, vava'i soko inini arafiaki. Jahari'oamanija ida mahi jaharini arafiaki. Deus hahavi-ra namonahavini naothinia ni-ija'aria vakamitha'iaki kaho ida vava'i soko inini arafiaki ibavi hahavia vahojaki. Ojoina kamahini naothinia ija'aria ni-vakamitha'ianaki ida vava'i soko ini'ahapikini arafiaki afojana, ojoina kamahini viahani fori hiki. ");
INSERT INTO padNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Deua binaipohirihi bana ida mahi vaimana 'banani arafiani-ra vakamithavini kaimoni, vaihimihahavirara kaimoni adani ija'ari. Deus va'ora akava'ijoaki bana adani kidija'ari va'ora nagathogatho'iki. Va'ora va'adivini mani ida imai 'banani arafiani kamahini Deua binaipohiravini hija bana. ");
INSERT INTO padNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Hari. Ija'ari vahabini a'onira ni'aki bana a'oni: “Vada vani'a hada vani Cristo.” Nihi ida ija'ari. Vaathi vakajari'da bana. Hoariha vahabini a'onira ni'aki bana a'oni: “Vada vani'a Cristo ada.” Vakhaniha. Vaathi vakajari'da bana jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Vikhaki bana adani ija'ari a'onira vakorijanahaki kaimoni. Vahoarahanana vaabono vani'a'badaravini: “Hovani Cristo ho. Deus hora karonaki ho.” Vahoariha vaabono vani'a'badaravini: “Hovani Deus athi namoniva abono ho.” Vakhaninanaha. Vakaabokaki bana ida badani danoki, kodibadani danoki fori hiki. Vanofiki ida ija'ari hahavi-ra vakorijanahavini. Vakaabokaravini kaba'i, vakaijo'aki ida ija'ari Deua binagathogatho'iki-ra vakorijanahavini, Deu-ra vanofijanarara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","A'onira onava'isohijoravini hiki, va'ora avakajari'dara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Hari. Asia vara ni'aha ada Jesus: —Imai 'banani arafiaki kamahini naothinia, mokhiki bana ada safini. Ni-vagaki ada masiko jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Vorovorohananaki bana ada boviri. Deua binaho'doho'doki ida nama vaaniara kaimoni adani ka'da'di danoki nama vahojaki. ");
INSERT INTO padNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oniaroa, ija'ari hahavia vanokiki bana ida ojoina karajomini nama nokiani. Vanokiki bana ida ojoirarina bahi vaforiki hararana. Vanokiki jaboni ida bana ojahana, odanona, ovagana, ija'ari hahavi vakadi'aajo ohina. ");
INSERT INTO padNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Oniaroa, Deus va'ora karonaki bana adani ibavi kaija'arini ibavi hahavia, arabo hahavia avikhana, va'ora najoronihahavira kaimoni adani ija'ari Deus va'ora nagathogatho'iki kidiania. ");
INSERT INTO padNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Hari. Asia vara ni'aha ada Jesus: —Okavarajomiki ida ojoina kamahini figira avani afani aja'dini fori hini. Avanokihi ida afani aja'dinani, avarigahi ida amoroki amaakarini. ");
INSERT INTO padNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Onivani fori hija ida ojoina viahani karajomini. Namitha'ihi ida vara a'onira oni'avini hi'iki, ojoina amaakarini-ra avarigahi. ");
INSERT INTO padNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ka'oa oamani ida oni'aki. Vaabinirina oadani adani ija'ari rajomi-ra vanokiki, onanamithahahaviki bana ida a'onira oni'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ihimiki bana ida arabo hahavi, nama hiki jaboni. Namithaki hida oathi a'onira oni'avini hi'iki. Mahi hahavi anokhomiriki hida oathi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hari. Asia vara ni'aha ada Jesus: —Ija'aria ni-avigaki ida ojoina kamahini. Deus ibavi kaija'arinia avigarihi jaboni ida ojoina kamahini. Hovani Deus kaisai ohina kaba'i, ni-oogaki ida ojoina kamahini. Kodiabi'i ka'oa vania biogaja ida. ");
INSERT INTO padNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ojoina kamahini-ra avarigaravini kaba'i, rajomi namithaki-ra vanokha bana, mahi, joma hahavia hora avanokhavini a'onira ohonariaki bana ho. ");
INSERT INTO padNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A'onira onava'isohivini hiki ida ojoina kamahini fori hiki. Ka'da'dia binofiki ida ibavi napaja adahana. Ajihina viahania kidihonai abono-ra va'ora no'avini badania. Bihonariavini jaboni ada bakatha kakadava'ava abono va'i ogairini. ");
INSERT INTO padNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ka'da'di fori ohimanija bana. Hora vanokha bana! Kidihonai abono, bakatha kakadava'ava abono vihiki fori avihiki a'oni. Kidihonai abonoa avarigariki ida ka'da'di joina. A'onivani ni-avarigaki jaboni ida ojoina kamahini. Mithani vahabini bana ojoiki ho. Mahia vahabini bana ojoiki ho. Joma 'bo'dahini vahabini bana ojoiki ho. Vagavagani vahabini bana ojoiki ho. ");
INSERT INTO padNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vaviahanokha bana mahija avavadirini-ra okaragavini. A'onira ohonariavini hiki ojoina-ra avanokhavini. ");
INSERT INTO padNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Va'ora onava'isohivini hiki hora vanokhavini adani ija'ari hahavi jaboni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Hari. Oniaroa, mahi 'bamiki radahani naothinia judeus kaija'aria vanamonahaki bana ida Páscoa kaihinikani. Ihinika-ra vanamonahavini oadani pão kathoramananiriki-ra vakahaha. Hari. Vajoroni'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama, vaabono vara vakani'akhama'aha: —Ija'aria avigaravini kaba'i, agathihava ada Jesus, anaabinira kaimoni. Niha ani'a'avini agathiki koda ada? Mahi 'bamiki radahahi anamonahaki bana ida Páscoa kaihinikani. Ihinika kania vajoroniki bana adani ija'ari vaipohiki Jesu-ra vavajahaki. Ihinika-ra anamonahavini oadani, ni-Jesu-ra agathivini jahaki. Jesu-ra agathihi; haria vidaha bana adani ija'ari — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Oniaroa, Betânia ibavia hoja'aha ada Jesus. Simão hoariha gorana hoja'aha. Mahi 'bo'dakari Jesua biani'iki ida Simão kakavamoni asafi namania hojaki. Simão gorana Jesus 'baina kaba'i, o'oi'ihi ida gamo, bivikhami'ihi ida misai mitxaki, kaidivani arafiaki. Misai onini naado. Hari. Bivikhami'ihi ida misai bavini, biako'danikhama'ihi, biahoari'ihi ida misai Jesus 'da'di a'ania. ");
INSERT INTO padNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Vahoariha vaihamahi'aha, vaabono vakani'akhama'aha: —Nahina kaimoni gamoa binakavithimaki ida misai. ");
INSERT INTO padNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pavakari binihaja vaha; jiniro ahapini-ra gathanimanihi vaha; vakanahinariki-ra va'ora no'avini himanihi vaha ida jiniro. Misai kaidivani 300 jiniro 'ba'dani prata amonahani ipohini — vaabono vakani'akhama'aha. Athii khanakia vani'ahi ida gamo. ");
INSERT INTO padNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Oniaroa, Jesus va'ora ni'a'aha: —Jakana hojava kaho. Nahina kaimoni athii khanakia avani'aki hida gamo? Jahaki ida kidibadani kodimoni hini. ");
INSERT INTO padNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mahi hahavi vani vahojara adani vakanahinariki avakadiania va'ora avakajoamorara kaimoni. Ni-mahi hahavi ohojaki avakadiania hora avakajoamoraja kaimoni. Oabinina amaakariki bana ho. ");
INSERT INTO padNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hora kajoamoravini-ra nofivini mani ida nikia kanabadanini hija. Hora kamisaivini hija oabinina viahania. ");
INSERT INTO padNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ka'oa oamani hida oni'aki. Arabo hahavi, ibavi hahavia ija'ari vara bivani'aki bana ida omonina jahaki, vara vavani'aki jaboni bana hida gamo kabadani jahaki. Vakava'ihokiki bana hida gamo kabadani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hari. 12 vihiki adani Jesus ipohina. Hoarana Judas Iscariotes oniki. Oniaroa, sasidotxi vavaka'da'diva vakadiania okha'aha ada Judas. Va'ora ni'aha: —Jesu-ra oarakhavini-ra avanofihi; oarakhaha avakadiania. ");
INSERT INTO padNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Oniaroa, Judas kavarani-ra mitha vani'aha, khai vakhani'aha, vani'aha: —Jiniroa ira ano'aki bana hari, Jesu-ra iarakhavini-ra anaabosija kaimoni — vani'aha. Hari. Ajihi'aha ada Judas, abono-ra ni'aha: —Niha oni'a'aki koda hada Jesus oarakhavini vakadiania — abono-ra ni'aha ada Judas. ");
INSERT INTO padNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hari. Ihinika kama'dani kamahini vani, ovilia vadorohana vaipohiki-ra vanaabini'aha adani judeus kaija'ari, Páscoa kaihinikani ko'baini kaimoni. Vakahaki jaboni ida pão kathoramananiriki, ovilia imana hiki, avakava'i'biriniria kaimoni ida mahi 'bo'dakari Deus vakadi'arahoda avikhananavaki-ra va'ora va'adivini. Oniaroa, ihinika kama'dani kamahini vani ipohina vanana'dohi'aha ada Jesus: —Ida hanaja vania hojahi ibavi Páscoa kaihinikani ko'baini-ra anamonahavini kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Oniaroa, va'ora karonaha adani vi'bamiki, va'ora ni'a'aha: —Jerusalém sidajia avikha'a bana. Avanokiki bana ada makhira paha bavini-ra kaiba'iki. Gora bodinia okhajakosiha, avikhajakosi jaboni bana. ");
INSERT INTO padNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gora kaka'da'dini-ra bana vani'a: “Jesus vani haria honariavini hida ira anana'dohihavini hija, ida hanaja vania hojahi Páscoa kaihinikani ko'baini-ra anamonahavini ibavini kaimoni kodipohi khama?” ");
INSERT INTO padNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A'onira nanokiahivini hiki bana ida ibavi, gora ka'obani kakanamajakhamaki kania. Nahinaro avanofiki, hoja'iki afohahavi. Hi'oni ibavia 'bai-ra vanamonaha'a bana akadimoni — va'ora niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hari. Ai vihi'aha adani vi'bamiki. Sidajia avikha'aha. Vakaraga'ihi ida ibavi Jesus va'ora nava'isohijoravini hi'iki. Oniaroa, Páscoa kaihinikani ko'baini-ra vanamonaha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mithani vaivaini vani vakaikahi'aha adani Jesus Páscoa kaihinikani ibavini kania. Vakaikahi'aha, avikasi'aha gora ka'obani kakanamajakhamakia. Vaagakosoa'aha adani Jesus 12 vihiki ipohina khama. ");
INSERT INTO padNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Vi'baina kaba'i Jesua bini'a'aha: —Ka'oa oamani ida oni'aki. Hoarana avakadiania hojaki hora arakhaki bana, vahoariha hora vanaabinija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vava'i mokara ni'aha, Jesu-ra vani'ahahavi'aha afohanana: —Aajo, vara hora ivani'amanija koda? Jokoa ira oarakharihi — vakhaninana'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus va'ora ni'aha: —Hoarana hora arakhaki ho, hi'o pão-ra oakoba'ahavini-ra ovi'bamivini hiki, hihada vani hada hora arakhara vahoariha vasa'a kabodinia, hora vanaabinira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hovani ija'ari hahavi vakadi'aajo ho. Oabiniki bana ho. Deus athi kapapirania binamonijoraki ida oabinina. Jahariki bana ida kidimoni hora arakhaki kaimoni. Deua binapohimajaki bana ada hora arakhaki. Namitharara vaha; ni-pohimajaki vaha — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hari. Vi'baina kaba'i, Jesua bikanabiini'ihi ida pão, Deu-ra ni'a'aha: —Deus, ivani ijahaki i. Pãoa haria ino'a'iki i. Vara nina naothinia, bikanapitahataha'ihi, kidipohi-ra va'ora no'avini kihi'ihi, va'ora ni'aha: —Vaagathani'a hida pão mahija avakahahahavivini. Oimana hida pão. ");
INSERT INTO padNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vakahavini naothinia, copo maina-ra nabiiniha, Deu-ra vara ni'a'ianaha: —Deus, ivani ijahaki i. Vinho haria ino'a'iki i. Vinho kacoponi maina va'ora no'a'aha. Va'ora ni'aha: —Vi'avihahavi. ");
INSERT INTO padNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Va'ora ni'aha: —Hihida vinho oamana hida. Oabinina kamahini oamana ahovariki bana. Oabono ova'ahaki ho oabinina, ija'ari vaipohiki-ra va'ora oakava'ijoaja kaimoni. Oamana ahovariki bana, vakadihojai asohiriki 'birani abosija kaimoni. Oamana ahovarini mani ida Deu-ra vakajari'dariki-ra va'ora kapoarivini hija, kidija'ari vihira kaimoni, oniani ida kidiania va'ora arakhaja bana. Nimania ida Deus kava'iponahi a'bo'daki ja'dini. ");
INSERT INTO padNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ka'oa oamani ida oni'aki. Jokoa oabinirina oadani o'avijanarihi hida vinho. Deus a'onira vaka'da'divini kamahini kidiania nama o'avi'ianaki bana hida vinho ja'dini avakadiania — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Oniaroa, vi'avivini naothinia, moroa vaahiaha Deu-ra khai vani'avini. Ai vihi'aha. Arabo namahiki monte das Oliveiras oniki avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hari. Jesus va'ora ni'a'aha adani Pedro: —Deus athi kapapirania hojaki hida athii: “Ovilia akadava'ava abono-ra onaabiniki bana ho. Avigaki bana adani ovilia.” Nihi ida athii. Hihida joma hora avanahojahaki bana a'oni afohahavi avarigani. Ovilia avigana vani fori avihija bana avarigani. ");
INSERT INTO padNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Oahokina naothinia, Galiléia kaarabonia a'onira onaviahanokhaki bana ho — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Oniaroa, Pedroa bini'aha: —Ira vanahojahavini kaba'i adani vahoariha, hovani ni-ira onahojahaki — niha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesua bini'aha ada Pedro: —Ka'oa oamani ida ira oni'avini hiki. Hihida joma arakava ahiana ako'bamini viahania, ivani iathini nija bana: “Jesus ipohina ohirihi.” Ahoarabakosikia oipohina ihirini-ra ikahiki bana i — Jesua bini'aha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Oniaroa, Pedro bini'adanoki'aha: —Iniani, oabinihi kadania oabinihi. Jokoa iipohini ohirina-ra okahirihi — niha ada Pedro. Vahoariha vani'avini afohahavi: —Jokoa iipohini arihirina-ra akahirihi — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hari. Ai vihi'ianaha adani Jesus, Getsêmani ibavi maakariki-ra avanikhahavini. Avakhanoha, ipohina-ra va'ora ni'aha: —Onia vavithima'o, okhananavaki ho, Deu-ra vara oni'aki ho. ");
INSERT INTO padNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Vavithima'ona, Jesus va'ora ni'aha: —Pedro, Tiago, João, hora vavaipohiha bana. Ai vihi'aha adani avako'bamahakhamaki. Va'i mokara nikarahoha ada Jesus. Va'i rogo inikarahoki ada jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Va'ora ni'aha: —Kodiva'isoko'ini karaho hora naabinikamariki ho. Hida vahoja. Vanoki bana! — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Okhananavapa'itxiha, aasiama'oha, Deu-ra vara ni'a'aha: —Kodiabi'i, okava'isokonihi ida ija'ari hahavi vakadihojai asohirini abosini-ra ogathanivini. Nahina hahavi-ra ikaabokahi. Hora vanaima'banavini inofirihi; hora iva'adivini-ra ikaabokaki i. Hora vanaima'banavini inofihi; onofiki jaboni. Nahina-ra inofihi; onofiki jaboni — Deu-ra ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hari, Pedro vakadiania joimiha ada Jesus. Pedro vavadina-ra karaga'aha, va'ora ni'aha: —Simão Pedro, ivadimania? Inokipa'itxini-ra koda ikaabokaria? Hari'a vavadi! ");
INSERT INTO padNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Deu-ra vara vani'a bana mahija Jahari athi a'onira kaboroborovini-ra avakamitharavini. Jahari kahojai-ra avanofiravini kaba'i, ni-avakaabokaki ida Jahari a'onira kaboroborovini-ra avakajonivini. ");
INSERT INTO padNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ajoimi'ianaha ada Jesus, Deu-ra vara ni'a'ianaha. Bini'aha: —Kodiabi'i, oogaki ida hora vanaima'banavini-ra inofivini, oniani ida hora vanaima'banavini okapoarivini hija. Nahina-ra inofihi; onofiki jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pedro vakadiania joimi'ianaha. Vavadi'ianana vani va'ora karaga'ianaha. Vanokho'da'bo'da'bo'ianamaniha. Ni-vakaabokaki ida vanokina. Jesus vara va'ora ni'aha, ni-avigaki ida vagathanivini kaimoni. Ajoimi'ianaha ada Jesus, ahoarabakosikia Deu-ra vara ni'a'ianaha, oniani ida athi hi'ianahi. ");
INSERT INTO padNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Oniaroa, kidipohi vakadiania okhami'ianaha, va'ora ni'a'aha: —Asia mani avavadija, avarakoirini? Hari. Kama'da'iki ida oimana 'banani. Hovani ija'ari hahavi vakadi'aajo ho. Hoariha hora arakhaki bana ada, makhira vajahariki vasa'a kabodinia. ");
INSERT INTO padNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Vigaa'a. Ai arihi'ava. Vada vani'a o, vasa'a kabodinia hora arakhaki kaikahina. ");
INSERT INTO padNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Hari. Vara nina kaba'i, kaikahi'aha ada ipohina Judas Iscariotes oniki. Judas va'ora vikha'aha adani ija'ari vaipohiki vakasa'aiki. Vavikhaki ida ava, tarasara hiki, vakadisa'ai kaimoni. Vakasa'aiki-ra va'ora vakarona'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono, judeus kaija'ari vaka'ojomo'iva abono vihiki, Judas va'ora vaipohihara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas va'ora ni'avini vakaikahina viahania: —Hi'ada makhira oka'ivanitiki, oramosiki vani-ra vagathi bana — va'ora nava'isohijora'aha ada Judas. Jesu-ra vakavarajomivini hiki Juda biramosivini. ");
INSERT INTO padNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hari. Jesus vavahojaki kania vakaikahi'aha adani Judas, binamaakari'aha, bini'aha: —Aajo, ivaniti. Jesu-ra ramosi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hari. Vakasa'aiki Jesu-ra vagathi'aha, vidaboha'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesus ipohina hoarana bidioni'ihi ida tarasara fori hiki bavinia, bidafia'aha ada sasidotxi vakadika'da'di kahonai abono, biava'boarabakosi'ihi ida morobo. ");
INSERT INTO padNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Oniaroa, Jesua bini'aha: —Ija'aria vavikhaki ida ava, tarasara hiki vagathira kaimoni ada kaabiniki. Onivani fori hini avavikhaja ida avakadisa'ai hora avagathija kaimoni. Okaabiniki hora avavanihamania koda? ");
INSERT INTO padNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mahi hahavi a'onira oka'ojomo'ihi Deu-ra khai ani'avini kagorani kavasiribanini bodinia, ni-hora avagathi'iki. Namitha'iki ida Deus athi vanamoniva abono kohana vanajiri'bo'da'iki Deus athi kapapirania — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Oniaroa, Jesu-ra vanahojaha'aha adani ipohina, aviga'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kasiaga'aha ada imakhinava. Bikaimaha'ihi ida kidikarahobi ka'oa, abono-ra karafoavini hini. Hari. Vahoariha vagathi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Binahojaha'ihi ida kidikarahobi, rajorajona oga'aha, gathana-ra finivini. ");
INSERT INTO padNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hari. Oniaroa, sasidotxi vakadika'da'di gorana avisaha ada Jesus. Sasidotxi vaka'da'diva gorana bodinia vajoroniha adani judeus kaija'ari vaka'ojomo'iva abono, judeus kaija'ari vanava'isohiva abono vihiki. ");
INSERT INTO padNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hari. Napaja kasiaga'aha ada Pedro. Sasidotxi vakadika'da'di gorana khanona, gora i'oarini kavasiribanini bodinia o'oi'aha ada Pedro. Vithima'o'aha siho ka'dihania gora avakadava'ava abono vakadiania, va'oaniaro sorara fori vihiki adani. Vithi'aha vakadiania abono-ra naragi'aha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sasidotxi vavaka'da'diva, judeus kaija'ari vanasohiva abono vavaka'da'diva khama vaabono vara vakani'akhama'aha. Vanofiki Jesus abinina-ra vavahonariahivini. Vanako'diki ida badani asohiriki Jesus kania, ni-vakaragaki. ");
INSERT INTO padNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jesus athi kamithava abono-ra va'ora vakaboa'iha, Jesu-ra avakaraganahara kaimoni afohanana. Jesu-ra vakanavaranihavini adani ija'ari vaipohiki afohanana. Korijanahia vakavaranina mani ida vakadivarani-ra avakanasohikhamaravini hija. ");
INSERT INTO padNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hari. Judeus kaija'ari vanasohiva abono vavaka'da'diva vahararana vigaamanani'aha adani Jesus athi kamithava abono vahoariha, Jesu-ra avakaraganahara kaimoni. Jesus athi vakamithava va'ora vani'aha: ");
INSERT INTO padNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Akamithaki ida Jesus athi. Bini'aki: “Onathararaki bana ida Deu-ra khai ani'avini kagorani ija'aria vanamonaha'iki. Mahi ahoarabakosikia onamonaha'ianaki bana ida gora hoariha ija'aria vanamonahariki.” Nimania ida Jesus athi akamitha'iki — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Vanahoarihabakhiaki ida vakadivarani, oniani ida vakadivarani anasohijanarini hija. ");
INSERT INTO padNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Oniaroa, gaa'aha ada sasidotxi vakadika'da'di maina vahararana bodi pania. Jesu-ra nana'dohi'aha: —Igathanivini inofiria ida ira vakanavaranihavini? ");
INSERT INTO padNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesua viso bini'ahi ida athi, ni-bigathaniki. Oniaroa, sasidotxi vakadika'da'dia binana'dohi'ianaha: —Ivani Cristo, Deus ira nagathogatho'iki i? Deus jahaki kaisai mani i? ");
INSERT INTO padNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Ha'a. Hovani Deus kaisai Cristo ho. Hovani ija'ari hahavi vakadi'aajo ho. Deus danoki pitana aniaja ovithiki bana ho ka'da'di ohina. Ovithina-ra avanokiki bana a'oni. Bahi vaforiki hararana vani nama ogarina-ra avanokija bana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Oniaroa, sasidotxi vakadika'da'dia bina'bira'ihi ida kidikarahobi bikaimahaki, bikavarajomija kaimoni ida Jesus Deus hina kavaranihi-ra vajaharavini. Va'ora ni'aha: —Jesus Deus kaisai hina-ra kahi'badaraki. Nahina kaimoni va'ora anihajanariha adani Jesus vara vavani'ava abono. ");
INSERT INTO padNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Akamitha'iki hida Jesus Deus kaisai hina-ra kahivini. Jahari'oamanija ida kidivarani. Niha ani'a'aki koda hada Jesus? Vagathani'ihi ida athi: —Jahariki hida kidivarani. Jahaki ida abinina — vakhanihahavi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Oniaroa, ija'ari vaipohiriki Jesu-ra vakai'bai'aha. Vahoariha nokho makaria vakarahobavini vakajoiri'aha, Jesu-ra vakahomaravini: —Hana hina vani ira kajoirija? — vani'aha. Sorara jabonia vagathi'aha ada Jesus, vida'aha. ");
INSERT INTO padNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Hari, gora banininia asia hojaha ada Pedro. Kha'ihi ida sasidotxi vakadika'da'di kabadani abono. ");
INSERT INTO padNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Binoki'aha ada Pedro abono-ra naragivini siho ka'dihania. Vada bini'aha, ni'ihi: —Ivani ivaipohihara ada Nazareno, Jesus oniki. ");
INSERT INTO padNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedroa bini'ahi: —Iniani. Ovaipohihariha ada. Ni-oogajahakiki ida kadavarani nahina nini. Hari. Ajihi'aha, gora kavasiribanini kaathania okhamina. Ahia'aha ada arakava. ");
INSERT INTO padNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Badani abonoa binoki'aha ada Pedro, vahoariha maakarinia vahojaki-ra ni'a'ianahi: —Ovani hi'o Jesus ipohina. ");
INSERT INTO padNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Oniaroa, Pedroa bini'a'ianahi: —Iniani. Ipohina ohirihi. Viso vakhanina afo'imidia, naothinia vahojakia vani'a'ianaha ada Pedro: —Hai oamani, kidipohi oamani i, kadarabo Galiléia jaboni. ");
INSERT INTO padNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Oniaroa, Pedro va'ora ni'aha: —Deua bikamithahi ida kodivarani. Ni-oogaki ada makhira, ipohina ohirihi. Korijanahia okavaranihi; Deus hora naima'banakarahovini-ra onofihi. ");
INSERT INTO padNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Oniaroa, ahia'ianaha ada arakava, ahiana ako'bamini. Pedroa bikava'ihoki'ihi ida Jesus athi: “Hihida joma arakava ahiana ako'bamini viahania, ivani iniha'iki i: ‘Jesus ipohina ohirihi.’ Ahoarabakosikia inihi.” Jesus athi-ra kava'ihokiha, asara'ahapiki'aha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hari. Oniaroa, vagavagani vaabono vara vakani'akhamaha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono, judeus kaija'ari vaka'ojomo'iva abono, judeus kaija'ari vanasohiva abono vavaka'da'diva vihiki. Vakhaniha: —Deus kaisai hina-ra kahi'badaraki ada Jesus. Jahaki ida abinina bana. Vaabono vara vakani'akhamavini naothinia, Jesus dabohana-ra vavahonariahi'aha. Pilatos kania avisaha ada Jesus, avarakha'aha. Arabo kaka'da'dini ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Oniaroa, Pilatoa binana'dohiha: —Ivani judeus kaija'ari vakadika'da'di mani i? —Ha'a, ka'oa oamani ida ini'aki — Jesua bini'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sasidotxi vavaka'da'diva Jesu-ra avanaathidanoarari'iki Pilatos kania. ");
INSERT INTO padNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoa binana'dohi'ianaha ada Jesus: —Jokoa igathaniria oni vaathi? Ikamitharia ida ira avanaathidanoarari'ahapikivini athini? ");
INSERT INTO padNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ni-Jesua bigathani'iki ida Pilatos athi. Pilatoa bikava'ibodivaranikaraho'ihi ida Jesua athi bigathaniravini. ");
INSERT INTO padNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hari. Páscoa ihinika kamahini Pilatoa biva'ahaki ada makhira hoarana cadeia kabodinia hojaki ajihina, aihotara kaimoni. Ihinika-ra vanamonahakia vanagathogatho'iki ada makhira hana hina cadeia okhaonanina vanofivini. Pilatos hojana hiki ida makhira-ra arakhaonanivini. ");
INSERT INTO padNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hari. Hojaki ada Barrabás cadeia kabodinia. Kaabiniki ada. Barrabás kidipohi khama va'ora vidaha adani arabo kaka'da'dini kahonai abono, kidisorara vihiki. Sorara vani va'ora vagathiha adani Barrabás, va'ora avibai'aha cadeia kabodinia. ");
INSERT INTO padNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Oniaroa, Pilatos kania vajoroni'aha adani ija'ari vâipohiki. Pilato-ra vani'aha: —Kadahojai ida makhira hoarana-ra iarakhavini akadiania, cadeia kabodinia hojaki. Anofiki ada hoarana-ra iarakhaonanivini — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Va'ora ni'aha ada Pilatos: —Jesus judeus kaija'ari vaka'da'diva-ra avanaoniki-ra oarakhaonanivini-ra avanofimania koda bana? ");
INSERT INTO padNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatos abono-ra ni'avini: —Ija'ari vaipohikia vavajahaki ada Jesus. Jesu-ra avakabaiki adani sasidotxi vavaka'da'diva. Vakadi'akabajahi oamani ida Jesu-ra avarakhavini hija kodiania — abono-ra ni'aha ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sasidotxi vavaka'da'diva va'ora vara vani'abakhiaki afodanoki adani ija'ari vaipohiki Barrabás arakhana-ra vakanikhariavini. Oniania, vanaaba'ihi ida sasidotxi vavaka'da'diva vakadihonari. ");
INSERT INTO padNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatos kana'dohi-ra vagathani'aha adani ija'ari vaipohiki: —Iniani. Anofiriha ada Jesus. Anofiki bana ada Barrabás. Oniaroa, va'ora nana'dohi'ianaha ada Pilatos: —Niha oni'a'aki koda ada Jesus, judeus kaija'ari vakadika'da'di avanaoniki? ");
INSERT INTO padNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bodi'barahia vani'aha: —Ivahonariahi'a aka'itapoamisahana'ina o Jesus, ava akasanakhamakia abinira kaimoni — Pilato-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatos va'ora nana'dohi'aha: —Nahina kaimoni mani ida Jesu-ra ovahonariahivini hija abinina? Nahina mani ida kidibadani jahariki hija? — va'ora nana'dohi'aha ada Pilatos. Bodi'barahi vani'aha: —Ivahonariahi bana ava akasanakhamakia aka'itapoamisahana'ina. ");
INSERT INTO padNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Oniania, Pilatoa bivahonariahi'aha ada Barrabás arakhana, khai vakhanira kaimoni adani ija'ari vaipohiki. Pilatos sorara-ra va'ora honariavini Jesu-ra vidafiahavini xikotxia. Ja'di sajoki va'a ipohikia ahoki ida xikotxi oniki. Pilatos kasorara vidafiahavini naothinia, Pilatoa bivahonariahiha ada Jesus aka'itapoamisahanana ava akasanakhamakia abinira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hari. Avaka'itapoamisahanavini viahania, sorara vania avavikhamiha ada Jesus ibavi hoariha Pilatos gorana bodinia. Avavikhamiha, va'ora vakaboa'iha adani sorara vaipohiki vajoronira kaimoni, Jesu-ra avigarahara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Vaani'ihi ida kidikarahobi. Avanaragarahivini hihi ida karahobi nadaraki. Vakanamonahahi ida kajamari kajaroki. Ka'da'dia avakaragari'ihi. Vakadika'da'di hina vakahi'badara'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jesu-ra vani'ahahaviha: —Ivani judeus kaija'ari vakadika'da'di i — vani'abakhiaha. ");
INSERT INTO padNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ka'da'di vakodafiaha ava. Jesu-ra vakai'bai'aha. Jesus viaha vakajo'atharari'aha, vakanamasivi'badaravini. ");
INSERT INTO padNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Oniaroa, avigaraha'avini naothinia, vaani'ihi ida karahobi nadaraki, Jesu-ra vakanakarahobi'ianara kaimoni kidikarahobia. Oniaroa, ai vavaniha'aha, ava akasanakhamakia avaka'itapoamisahanara kaimoni ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hari. Ai vavaniha'aha. Avikhana kaba'i, vakaragarari'aha ada Simão. Cirene sidaji kaija'arini ada Simão. Kidisai vi'bamiki, hoarana Alexandre oniki, hoariha Rufo oniki. Amasi kania khaki ada Simão. Hari. Sorara Simão-ra vanokiha, vahonaria'aha: —Ivani, Jesu-ra kakaiba'ahi hihida ava akasanakhamakia — sorara vani'aha ada Simão. ");
INSERT INTO padNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hari. Bikaiba'i'ihi ida ava akasanakhamaki. Oniaroa, Gólgota ibavi onikia Jesu-ra avisa'aha adani sorara. Gólgota ibavi oniki ariathia ka'da'di kajaroni kaibavini ida. Vakaikahi'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sorara Jesu-ra vano'avini hini vanofihi ida vinho miha kabodiki, imana 'banani fai inija kaimoni. Binofiravini mani ida bigathaniravini hija. ");
INSERT INTO padNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hari. Ava akasanakhamakia Jesu-ra avaka'itapoamisahana'aha adani sorara. Varagaamananivini ida ava akasanakhamaki nami khorahaki bodinia. Hari hi'ihi ida vakadibadani. Oniaroa, vakosonakhamaki ida ja'di pitani jiriki, avigaja kaimoni ida kidimakari ravina'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Safini namahikajomana vani Jesu-ra avaka'itapoamisahana'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hari. Jesus ka'da'di kanamania avakaka'itapoamisi'ihi ida tábua kajiriki rajomi kaimoni, ija'aria avigaja kaimoni ida nahina kaimoni Jesu-ra vanaabinivini. Vanajirivini athini: “Judeus kaija'ari vakadika'da'di hada.” Jesu-ra avanaathidanoararivini hiki judeus kaija'ari vakadika'da'di hina-ra kahivini. ");
INSERT INTO padNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hari. Sorara vani va'ora vavikhaha adani daiki-ra avanahoroabakhiaki vi'bamiki. Va'ora avaka'itapoamisahana'aha jaboni. Vanaibavi'aha ada hoarana Jesus pitana aniaja, vanaibavi'aha ada hoariha Jesus pitana kajasonija. ");
INSERT INTO padNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Deus athi kapapirania hoja'iki ida Cristo varani hina: “Ija'ari jaharikia kabadaniki-ra vakanabadanihavini vani fori hija ida vakanabadanihavini.” Oniani ida Jesu-ra vakanabadanihavini hija badani jaharikia. Namitha'iki kidiania ida Deus athi kapapirania bini'a'iki. ");
INSERT INTO padNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hari. Ija'ari varadaha'aha avigaraha'aha ada Jesus. Jesu-ra vakaihimoravini oamani ida varani niki-ra vara vavani'avini hija. Onii jaharikia Jesu-ra vani'aha: —Deu-ra khai ani'avini kagorani-ra inathararavini-ra ikahiki i, mahi ahoarabakosikia ianaja'divini ikahiki i. ");
INSERT INTO padNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iabono akava'ijoa. Iabono ani'a ava akasanakhamakia — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jesu-ra avigaraha'aha jaboni adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama. Vaabono vakani'akhama'aha: —Jesus va'ora akava'ijoa'iki adani vahoariha. Ni-abono-ra maha akava'ijoavini-ra kaaboka'iki. ");
INSERT INTO padNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jesu-ra vani'aha: —Deus ira nagathogathovini-ra ikahiki i. Ivani Cristo, akadija'ari vakadika'da'di ihidorohi, iabono ani'a ava akasanakhamakia. Igarini-ra anokihi; ni-ira akajari'daki — vani'aha. Hi'adani vi'bamiki avaka'itapoamisahanakia avigarahaki jaboni ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hari. Safini sohirarina vani bakibakini kama'da'ihi ida arabo afohahavi. Safini ajorana vani avagani kama'da'ianahi. ");
INSERT INTO padNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Safini ajorana vani bodi'baraha'aha ada Jesus athia: —Eloí, Eloí, lemá sabactani? — niha ada Jesus athia. “KodiDeus, kodiDeus, niha onina mani hida hora inahojahavini hi'ia?” — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ija'ari vahojakia vakamithahi ida kidibodi'barai, vakhaniha: —Mitha vani'a. Elias kohana-ra baranahaki ada — vakhaniha. Elias kohana-ra baranahaki vavanihaki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ki'daraha'aha ida ija'ari athi-ra kamithaki, bianathoranihi ida makari fori hiki vinho kaidivarikia. Ava oadaki sanarahakia binahoja'ihi. Bivikhahi, Jesus viaha biarakasihi, Jesua binadomidomija kaimoni ida vinho a'bani. Ava akasanakhamaki kania ija'ari-ra va'ora ni'aha ada vinho-ra vikhaki: —Hari'a kaho. Ada kaho vahabini khaha Elias, ava akasanakhamakia biakava'ijoara kaimoni ada Jesus. Vada ani'ava. ");
INSERT INTO padNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oniaroa, bodi'bara'ianaha ada Jesus, abini'aha. ");
INSERT INTO padNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hari. Abinina kaba'i 'bira'ihi ida makari katokihi Deu-ra khai vani'avini kagorani ka'oahafianihiki. Makaria bikatapafiaki ida gora pitani Ibavi Katokini Jahaka'oaki oniki ija'ari o'oiria kaimoni. Khiorarini akapitakhama'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Oniaroa, Jesus aba'ona nabo'ani viahania hojaha ada sorara kaka'da'di. Jesus bodi'barana-ra kamithaha, Jesus abinina-ra noki'aha, bini'aha: —Deus kaisai oamani hada hihada makhira. ");
INSERT INTO padNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Hari, vahojamaniha adani gamo ava akasanakhamaki kania. Abinina vanokivini napaja pa'itxia. Galiléia kaarabonia Jesus hojana kari Jesu-ra vavaipohihabakhia'iki adani Maria Madalena, Salomé, Maria hoariha vihiki. José, Tiago vihiki vakadiamia ida Maria hoariha. Kajo'ojahiki ada Tiago. Gamo vani va'ora vako'baiha'ara adani, va'ora vakaijahita'ara adani Jesus, ipohina khama. Ai vihiha adani Jesus Galiléia kaarabonia, ai vihi'iki jaboni adani gamo avahoarabakosiki, gamo vahoariha khama. Jerusaléa avikhahahavi'iki adani. Páscoa kaihinikani amonahani kania. ");
INSERT INTO padNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Hari. Avakoirina kamahini viahani vani abini'ara ada Jesus. Ihinika ko'baini amonahani kamahini vani abini'ara ada. Jesus abini'ina-ra oga'aha ada José de Arimatéia. Ija'ari nava'isohiva abono ada José de Arimatéia. Jahana vani vakahiha ada José. Joséa binokha'iki ida mahi Deus ija'ari hahavi-ra va'ora vaka'da'divini. Hari. Pilatos kania okha'aha, Pilato-ra finivini kaba'i bini'aha: —Pilatos, iva'aha bana ida Jesus aba'ona-ra oanivini ava akasanakhamaki kania, oka'damahaja kaimoni? ");
INSERT INTO padNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatoa bikava'ibodivarani'iki ida Jesus abinijoraki'ina monini. Bivahonariahi'aha ada sorara vakadika'da'di anikha'ahi hina. Khano'aha ada sorara, Pilatoa binana'dohi'aha: —Ada abinimani'aha Jesus? —Ha'a, ada abini'aha — niha ada sorara. ");
INSERT INTO padNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilatoa bini'aha ada José: —Ha'a. Ba ianiha ida Jesus aba'ona. ");
INSERT INTO padNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Oniaroa, Joséa bikapavakarihi ida makari vaforiki jahaki. Ava akasanakhamaki kania biavikha'ihi. Bianikha'ihi ida Jesus aba'ona, bikarafoa'ihi makaria. Ka'damahi ibavinia biavikha'ihi. Ja'di hodijama'oki bodinia biobaiha'ihi ida Jesus aba'ona. Vakadihojai hiki. Hari. Jesus aba'ona-ra obaivini naothinia, vaka'oaha'ihi ida ja'di hodini kaathani, ja'di karahoa. Ajihi'aha ada José. ");
INSERT INTO padNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kidibadani Maria Madalena, Maria hoariha khama vada vani'aki. Aba'oi biavi'oiki ibavini-ra vanoki'iki adani gamo. Tiago, José vihiki vakadiamia ida Maria hoariha. ");
INSERT INTO padNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hari. Avakoirina kamahini naothinia, misai fori hiki-ra vakapavakari'aha adani Maria Madalena, Salomé, Maria hoariha vihiki. Hi'ida Maria hoariha Tiago vakadiamia ida. Jesus aba'ona-ra vakavamisaihara kaimoni misai fori hikia. Vahojana oamani ida aba'oi-ra vakavamisaihavini. ");
INSERT INTO padNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ka'afokajomani domingo vani mahi avagani kama'dani aba'oi ka'damahani ibavini kani-ra avanikhaha'aha. Safini anadaranimananikajomana vani avakhano'aha ja'di hodijama'oki kania. ");
INSERT INTO padNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Avakhanorina oadani vaabono vakanana'dohikhama'aha: —Nahina vania koda bianiki ida ja'di hodijama'oki katapani akadimoni? Avakhanona, vada vakhaniha, vanoki'ihi ida ja'di hodini kaathani katapajanarini. Ania'iki ida ja'di. Kâraho oamani ida ja'di. ");
INSERT INTO padNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ja'di hodijama'oki bodinia avi'oi'aha, vanoki'aha ada imakhinava Deua bikarona'iki hodi ka'aniajania vithina. Bikaimahaki makari vaforiki, oadaki. Vanokiha, vaimahida'aha. ");
INSERT INTO padNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Imakhinava va'ora ni'aha: —Hari'a vaimahida! Oogaki ida Jesus ava akasanakhamakia aka'itapoamisahanaki-ra avanako'dihavini. Ni-hida hojajanariha ada. Ada ahoki'aha. Vada vani'ajakosi hida aba'ona bivahoja'iki ibavini — va'ora ni'aha. Vada avani'ajakosihi ida aba'ona hojani ibavini. ");
INSERT INTO padNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vara ni'ianaha ada imakhinava: —Ai vihi'a! Pedro Jesus ipohina vahoariha-ra va'ora vanava'isohiha'a: “Ada ahoki'aha Jesus. Galiléia kaarabonia a'onira naviahanokhaki bana ada. Idiaja avanokiki bana ada. Onivani fori hija ida kidivarani a'onira ni'ajoravini hi'iki.” Va'ora vani'a bana — niha ada imakhinava. ");
INSERT INTO padNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Oniaroa, ka'damahi ibavinia vikhaonani'aha. Aviga'ina, vaki'darahaha'aha. Vaimahida'aha, ni-vahoariha-ra vara vani'a'iki hagihia, vaofinina. ");
INSERT INTO padNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hari. Domingo vagavagani vani ahoki'aha ada Jesus. Oniaroa, Maria Madalena miro'a kania abono-ra nanokiaha ada Jesus. 'Bo'dakari kabajadiki ida Maria Madalena. 7 bajadi vaipohina Jesus va'ora honaria'iki avakara'o'ina kidiania, ni-kabajadijanaki. Hari. Maria miro'a binoki'aha ada Jesus ahoki'ina naothinia. ");
INSERT INTO padNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ajihi'ihi, Jesus ipohina vakadiania okha'ihi. Vava'i mokara ni'ani hiki Jesu-ra vakaasaravini. Kaikahi'ihi ida Maria, va'ora ni'ahi: —Hari'a vaasarajana! Ada ahoki'aha Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mitha vani'ahi ida Maria kavarani, Jesus ahokina kavaranini. Vakajari'damani'ihi. ");
INSERT INTO padNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hari. Oniaroa, amasia avikharimanani'aha adani vi'bamiki. Vakadiania abono-ra nanokia'aha ada Jesus. Jesu-ra vanoki'aha, ni-ovari nokiana fori hijanaki. ");
INSERT INTO padNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Avajoiha adani vi'bamiki, vara vavani'a'aha ada Jesus, ipohina vahoariha vakadiania. Vakadivarani vakajari'damaniha. ");
INSERT INTO padNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hari. Oniaroa, kidipohi 11 vihiki vakadiania abono-ra nanokia'aha ada Jesus. Vako'baikosoana kaba'i abono-ra nanokiaha. Jesus va'ora kaabanivini hiki ida ahokina kavaranihi vakajari'davini. Va'ora ni'aha: —Jahari'oamanija ida avakadijari'di. Hora vanokiha adani vahoariha. A'onira vananamitha'iki jaboni ida oahokina, kaba'i avakajari'dahi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hari. Oniaroa, va'ora honariavini adani ipohina: —Arabo hahavia avikha'a bana! Ija'ari hahavi-ra vara va'ora vani'a bana omonina jahakia. ");
INSERT INTO padNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Va'ora ohonariaki adani hora vakajari'dariki vikanana, oniani ida va'ora oakava'ijoavini hija bana. Va'ora onava'isohivini hiki adani hora vakajari'daki vakadihojai asohiriki abosini-ra vagathanivini bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jesus va'ora nava'isohiki adani kidipohi: —Hora vakajari'darikia vakaabokaki jaboni ida kodibadani danoki. Hora vakajari'darikia vakaabokaki ida bajadi akara'oni-ra vahonariavini. Vani'avini: “Bajadi, Jesus ira honariavini, akara'o'a bana.” Hora vakajari'darikia vakaabokaki bana ida athii ogavaharikia vaathina. ");
INSERT INTO padNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hora vakajari'darikia vakaabokaki ida makha-ra vagathivini, va'ora ananiha ni-'banaki. Hora vakajari'dariki veneno-ra vi'aviha, ni-vamakhaniki. Hora vakajari'dariki ija'ari vakavamoniki-ra va'ora vakaabadaha, avaihotaha — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hari. Jesus kavarani anokhomini naothinia, Deua bigathani'aha ada Jesus. Deus pitana ka'aniajania vithi'aha, ka'da'di hi'ina. ");
INSERT INTO padNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Oniaroa, ai vihi'aha adani Jesus ipohina. Ibavi hahavia vara vavani'a'ihi ida Jesus monina. Vakadika'da'di ada Jesus, oniani ida va'ora kakodiavini hija. Badani danoki-ra vakaabokavini hiki, Jesus va'ora kakodiavini. Jesus kabadani danoki-ra vanokiki adani vahoariha oniania, vakhaniha'aha: —Ka'oa oamani ida Jesus monina vara haria vani'avini hiki. Hari ida vani oamani Marcos kavarani anokhomi'ini.");
INSERT INTO padNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kodiva'ahi Teófilo. Ija'ari vaipohikia vanofi'iki ida jirihi-ra vanamonahavini. Vakadipapira jirini athini hiki ida Jesus vanokiva abono haria vanava'isohivini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Va'oaniaroa vanoki'iki ida Jesus kabadani, vakamitha'iki ida kidivarani, oniani ida haria vanava'isohivini hija Jesus monina. ");
INSERT INTO padNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hovani jaboni, kodiva'ahi Teófilo, onamonahavini onofiki ida Jesus monina kapapirani athini. Va'ora onako'di'imidiaki adani Jesus vanokiva abono hora vanava'isohijahakira kaimoni kidibadani kama'dani, oadani hikia. ");
INSERT INTO padNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Oogahahavivini naothinia onamonaha'iki ida papira jirini, iogaja kaimoni ida Jesus varani hina ka'oa hini, hoariha ira ka'ojomo'ivini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hari. Iroji va'ora vaka'da'divini kari adani Judéia kaaraboni kaija'arini, hojaki ada Deus kabadani abono Zacarias oniki. Sasidotxi oniki ada Deus kabadani abono. Zacarias kaija'ari vakadiabi'i okhananavaki ada Abias oniki. Sasidotxi hahavi adani Abias kohana kaija'ari vavijavaronisiagaki. Zacarias kagamo Isabel oniki. Kidiabi'i okhananavaki kaija'ari vavijavaronisiagaki adani jaboni sasidotxi vihiki. ");
INSERT INTO padNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarias kidigamo khama bada vani'abakhiaki ida badani asohiki Deua bivajahaki, vanaababakhiaki ida Deus kahonari jiriki afohahavi. ");
INSERT INTO padNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ni-vaisaki adani Zacarias, kidigamo khama. Isabel ni-bikaabokaki ida isani. Na'arihavi vihi'bamakhama'aha, kidimakhira khama. ");
INSERT INTO padNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Sasidotxi vakadibadani hiki ida misai mitxaki fori hiki incenso oniki avanaha'divini, Deu-ra khai vani'avini kagorani bodinia. Sasidotxi hoarana ka'oa okhajakosiki, bianaha'dija kaimoni ida incenso. Hari. Zacarias maina-ra vanagathogatho'aha, incenso-ra anaha'dira kaimoni. Oniaroa, Deu-ra khai vani'avini kagorani kania okha'aha ada Zacarias, okhajakosi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Incenso-ra anaha'divini oadani ija'ari vaipohiki baniniaja vahojaki, Deu-ra vara vani'avini. ");
INSERT INTO padNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarias kania nokia'aha ada Deus ibavi kaija'arini. Incenso ha'diki ibavini altar oniki aniaja. ");
INSERT INTO padNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacaria binokiha, rapata'aha, ni-biogaki ida bada bini'aki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Deus ibavi kaija'arinia bini'aha: —Zacarias, hari'a rapata! Deua bikamitha'iki ida avakadikanikhari kidiania. Isaki bana ida kadagamo. 'Banaha ada avakadisai, vanaoni bana João. ");
INSERT INTO padNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Isai 'bana'ina ira khai ni'aki bana i. Vava'i khaiinikarahoki bana adani ija'ari vaipohiki jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Deua binagathogathoki ada isai, karaho'ina ija'ari vaipohikia avigaki ada bana. Hari'a bana bi'aviva ida vinho, kavi hiki. Isai tanana kari vani hojara bana ada Ma'onahai Jahaki kidiania, va'i nahonariahihini hiki kaimoni kidimahi oadakia. ");
INSERT INTO padNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Va'ora nava'isohibakhiaki bana adani Israel kaija'ari vanofija kaimoni ida Deus athi-ra vanaabavini. VakadiDeus ada. ");
INSERT INTO padNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Deus athi vikhava abono bana ada kadaisai. Deus athi namoniva abono Elias kohana fori hiki bana ada. Elias kohana bada bini'aki ida Deus kabadani danoki, onivani fori hija bana ida kidibadani danoki jaboni. Ija'ari-ra va'ora kaabanibakhiaki bana ada, oniani ida bana isai vaabono avakakariakakhamavini hija vakadiamia, vakadiabi'i vihiki khama. Deus athi-ra vanaabarikia vakamithaki bana ida kadaisai kakaabanahi, hojai asohikia vakahojai'ianara kaimoni. Kadaisai athi-ra vakamithaki bana adani Israel kaija'ari, oniani ida ka'da'di Cristo khana-ra vanokhavini hija. ");
INSERT INTO padNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Oniaroa, Zacaria binana'dohi'aha ada Deus ibavi kaija'arini: —Nihaniki vania iathini-ra okajari'dariki ho? Na'arihavi arihi'oamanija kodigamo khama. ");
INSERT INTO padNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Deus ibavi kaija'arinia vara bini'a'ianaha: —Hovani Deus kahonai abono ho, Gabriel ooniki ho. Deus hora karonavini hiki varani jahakia ira onava'isohihaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kodivarani-ra ikajari'davini kaba'i, Deua binofivini kamahini namithaki bana ida oni'aki. Oathi-ra ikajari'davini mani ida iabanini-ra nakhanahaja. Kadaisai banini hirina oadani, ni-ivaravarani-ra ikaabokajanaki bana — niha ada Deus ibavi kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Vara nina oadani, baniniaja vahojaha adani ija'ari vaipohiki Zacarias khaonanina-ra vanokhavini. Vakava'ibodivaranihi ida agathanina hiki Deu-ra khai vani'avini kagorani bodinia. ");
INSERT INTO padNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Khaonani'aha, ni-vara nina-ra kaabokajanaki ada Zacarias. Oniaroa, ija'aria avigaki ida vadami fori hiki-ra noki'avini Deu-ra khai vani'avini kagorani bodinia. Vara nina-ra kaabokaravini kaba'i, va'ora nava'isohi'aha adani ija'ari sa'a namithaki kaimonia. ");
INSERT INTO padNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hari hi'ihi ida Zacarias kabadani Deu-ra khai vani'avini kagorani bodinia, gorana ajoi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hari. Mahi ipohiriki vani kajahavido'ihi ida Isabel. Gora bodinia hojahaha'oadahahi 5 masiko ipohina. Abononi ni'ahi: ");
INSERT INTO padNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Badara ipohiki oisana-ra onofivini kaba'i, ni-oisaki. Deus vani hora kajoamoraja, oniani ida hora naisa'ia, ni-ija'ari hora vakaihiponirijanaki. ");
INSERT INTO padNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Hari. Oniaroa, 6 masiko ipohina vani kajahavido'ihi ida Isabel. Oniaro kari Deua bikarona'iki ada ibavi kaija'arini Gabriel oniki Nazaré sidajia okhana. Galiléia kaarabonia hojaki ida Nazaré sidaji. ");
INSERT INTO padNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Deus ibavi kaija'arinia bivikhaki ida Deus athi Maria kaimoni. Ima'inavi ida Maria, ni-makhani'iaki kaho. Kidimakhira kaimoni ada José. José ka'arahoda okhananavaki ada arabo kaka'da'dini kohana Davi oniki. ");
INSERT INTO padNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hari. Maria kania kaikahi'aha ada Deus ibavi kaija'arini Gabriel oniki, bini'ahi: —Maria, khai ini'a hida kodivarani Deus ira kajoamorakaraho'iki i. Hojaki ada kadaka'da'di Deus kadania. ");
INSERT INTO padNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oniaroa, Maria bikamithahi ida Deus ibavi kaija'arini athi, ni-biogaki ida niha ninini. Bikava'ibodivarani'ihi ida Gabriel kavarani nahina hini. ");
INSERT INTO padNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hari. Vara ni'ianaha ada Deus ibavi kaija'arini: —Maria, hari'a iva'ini soko iniva! Deua khai bini'aki ida ihojani. ");
INSERT INTO padNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iisaki bana i. Makhira isani bana ada kadaisai, inaonivini bana ada kadaisai Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ka'da'di jahaki danoki kaimoni bana ada. Deus danoki nama hojaki kaisai ada bana. Ija'aria vani'avini Deus kaisai hina. Deua binagathogathoki ada ovari ka'da'di hira kaimoni. Kidija'ari okhananavaki Davi oniki ka'da'di hina vani fori hira bana ada. ");
INSERT INTO padNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jacó kohana kaija'ari vanamitharonisiagaki vakadika'da'di kaimoni ada afoha'oadaha. Ni-ihimirihi ida ija'ari-ra vaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hari. Maria bini'aha ada Deus ibavi kaija'arini: —Ni-nihanikia namitharihi ida hora ini'avini hiki. Ima'inavi oamani ho. Ni-okamakhiraki kaho. ");
INSERT INTO padNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Deus ibavi kaija'arinia bigathani'ihi hida Maria athini: —Ma'onahai Jahaki danoki khaki bana kadania. Deus nama hojaki danona ira avi'onanivini mani bana ida ira naisaja bana, oniani ida Deus kaisai jahaka'oakia kadaisai-ra vanaonivini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ikava'ihokiki ida hoarihaja iigamini Isabel oniki. Ni-bikaabokaki ida isai-ra namonaha'avini vakhaniha adani ija'ari. Na'arihavi hini kaba'i, kajahavido'iki ida Isabel. 6 masiko bivahoja'iki kajahavido'ini. ");
INSERT INTO padNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Deua bikaabokaki ida badani danoki hahavi binofiki. ");
INSERT INTO padNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria bini'aha: —Hovani Deus kahonai abono ho. Jakana namitha'ava kaho ida vara hora ini'avini hi'iki kodiania. Oniaroa, ajoi'aha ada Deus ibavi kaija'arini Deus kania. ");
INSERT INTO padNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hari. Mahi ipohiriki radahani vani ibavijahaha'ihi ida Maria kidinahina-ra. Ibavijahahani naothinia, okha'ihi Judéia kaarabonia. Namahimahionahaki ida Judéia kaaraboni. Zacarias kidigamo khama vavahojaki kasidajinia okha'ihi ida Maria. ");
INSERT INTO padNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Oniaroa, kaikahi'ihi, Zacarias vagorana o'oi'ihi, bika'ivanitihi ida Isabel. ");
INSERT INTO padNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabel bikamitha'ihi ida Maria bika'ivanitivini, oniania, 'dori'dorihani bikamitha'ihi ida kidisai jahani bodinia. Hari. Isabel va'ini-ra nahonariahihi'aha ada Ma'onahai Jahaki, varavara'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Athii 'barakia bini'ahi ida Maria: —Deus va'ora kajoamoraki adani gamo vahoariha. Ivani ira kajoamoravini arafiaki ada. Deua bikajoamorakarahoki bana ada kadaisai. ");
INSERT INTO padNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kodika'da'di kaimoni ada kadaisai. Nahina ohipa'itxirihi, kodika'da'di kaamia kodiania khaki. ");
INSERT INTO padNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hora ika'ivanitivini vani giragira'ia hida kodisai ojaha bodinia khai ira ni'avini. ");
INSERT INTO padNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Deus ira nava'isohijoravini-ra ikajari'daravini, oniani ida ira kajoamoravini hija — Isabea bini'ahi ida Maria. ");
INSERT INTO padNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hari. Nihi ida Maria: —Okava'ibodivarani'iki ida Deus jahana. ");
INSERT INTO padNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Khai oni'a'aha ada Deus, hora kava'ibodivarani'aha. Kodi'aihotahi abono ada. ");
INSERT INTO padNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Hovani kidihonai abono ohiki ho, nahina ohipa'itxirihi. Deus badani hahavi danoki-ra kaabokaki. Ovaria bada bini'a'iki ida kidibadani jahaki, danoki kodiania, oniani ida vahoariha hora vara vavani'abakhiavini hija, gamo Deua bikajoamorakaraho'iki. Jahaka'oaki ada Deus. ");
INSERT INTO padNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Deus va'ora va'adiki adani ija'ari avikhananavaki, ija'ari vanamitharonisiagaki, ija'ari hidakaba'i vahokiki athi naabani vihiki. ");
INSERT INTO padNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Deua bianaviraki bana ida vadi danoki, va'ora nihimaki bana adani ija'ari vaabono vavaboraborahaki. Binihimaki jaboni ida vakadibadani asohiriki bada vani'avini vanofiki. ");
INSERT INTO padNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Va'ora aniki adani arabo kaka'da'dini vadanoki ka'da'di vihijanarara kaimoni. Va'ora kakodiaki adani vakanahinariki. ");
INSERT INTO padNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Deus va'ora no'aki adani vavai'amiki 'baia, kidinahina hikia. Ni-Deus va'ora no'aki adani vakanahinakarahoki kidinahina. Va'ora honariaki adani ai vihi'ina. ");
INSERT INTO padNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Deua binanamitha'iki ida athi a'bo'daki akadija'ari avikhananavaki-ra va'ora nava'iponivini hi'iki, va'ora kakodia'aha adani Israel kaija'ari. Deus kahonai abono vihiki adani Israel kaija'ari. ");
INSERT INTO padNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Va'ora akadava'ahaha'oadahaki adani Abraão, Abraão kaija'ari vanamitharonisiagaki vihiki — nihi ida Maria. ");
INSERT INTO padNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hari. Masiko ahoarabakosiki vani hoja'ihi ida Maria Isabel vakadiania. Naothinia ajihi'ihi, Nazaré sidajia joi'ianahi. ");
INSERT INTO padNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hari. 'Bana'ihi ida Isabel. Makhira ada isai. ");
INSERT INTO padNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oniaroa, ija'ari Isabel gorani maakarinia vahojaki, kidija'ari vihiki khama, vakamitha'iki ida Isabel kaisai 'bana'ina monina. Vaabono vakani'akhama'aha: —Ada banini hi'aha Isabel kaisai. Jahaki ada Deus vakadimoni hina. Na'arihavi hini kaba'i, Deua bikajoamoravini isa'ihi — vakhani'aha. Khai vakhani'aha adani ija'ari vaipohiki Isabel khama. ");
INSERT INTO padNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hari. Semana hoarani-ra vahoja'aha ada isai, vakarajomi'aha siikosida rajomia. Isaia bivahojaki kania vakaikahi'aha adani Zacarias, Isabel, vakadija'ari vihiki. Sasidotxia bikarajomi'aha ada isai, Deus kaija'ari hira kaimoni. Vanofiki ida isai-ra vanaonivini Zacarias, kidiabi'i onina. ");
INSERT INTO padNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Isabel va'ora ni'aha: —Iniani. Kodisai-ra anaonivini João. ");
INSERT INTO padNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Oniania, vakhani'aha: —Akadija'ari vakadiania ni-hojaki ada makhira João oniki. ");
INSERT INTO padNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ni-varavarana-ra kaaboka'iaki kaho ada isai kaabi'i, oniani ida vasa'a vanana'dohivini hija: —Hana hini onii ida inofija kadaisai onina kaimoni hini? ");
INSERT INTO padNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacaria bikanofiki ida tábua kapitani kapa'itxi, isai onina-ra najirivini ibavini kaimoni. Biagathani'ihi, bikanajiri'ihi. “Isai onina João.” Ija'ari vahojakia vakava'ibodivaranikaraho'aha. ");
INSERT INTO padNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Oniania, Zacarias bikaaboka'ianahi ida varavara'ianana, athi jahakia Deu-ra vara ni'a'aha. ");
INSERT INTO padNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ija'ari Zacarias gorana maakarinia vahojakia vakava'ibodivaranikaraho'aha ada Zacarias varavara'ianana. Ija'ari vaibavi ipohikia avaadahaoni'aha, vara vavani'a'ihi ida isai monina. Judéia kaaraboni namahimahionahakia akarafarakhama'iki ida isai monina. ");
INSERT INTO padNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ija'ari vakamithava vakava'ibodivarani'ihi, vaabono vakanana'dohikhama'aha: —Karaho'aha ada isai, nahina koda bana kabadanira ada? Deus danona hojani-ra avigavini mani ida isai kania. ");
INSERT INTO padNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hari. Oniaroa, Ma'onahai Jahaki Zacarias va'i-ra nahonariahihi'aha. Zacaria vara bivani'ahi ida nahina namitha'iariki Deua binava'isohivini hi'iki. Bini'aha: ");
INSERT INTO padNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Vara avani'ava ida Deus akadika'da'di jahana, ovani ada Israel kaija'ari vakadiDeus hira. Va'ora akava'ijoa'iki adani kidija'ari gathaki fori vihijanarara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Deua bikaronaki ada aihotahi abono danoki haria kajoamoraki kaimoni hina. Deus kahonai abono Davi kohana oniki kahanodi namitharonisiagaki ada aihotahi abono. ");
INSERT INTO padNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Deus va'ora nava'isohi'bo'da'iki adani athi namoniva abono vajahaka'oaki kohana. Oniaroa, vananamitha'ihi ida Deus athi. Vani'aha: ");
INSERT INTO padNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Deua bikaronaki bana ada aihotahi abono akadiania. Akadija'ari-ra va'ora akava'ijoaki bana ada ija'ari haria vavajahariki vasa'a kabodinia.” Vakhaniha adani Deus athi namoniva abono. ");
INSERT INTO padNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Zacarias asia vara niki: —'Bo'dakari Deua vara bivani'aki ida akadija'ari avikhananavaki-ra va'ora va'adivini, binanamithaki jaboni ida athi jahaka'oaki Deus kava'iponahi a'bo'daki. ");
INSERT INTO padNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Deua binava'isohijora'iki ada akadi'arahoda okhananavaki Abraão Deus kava'iponahi a'bo'dakia. Deua bini'aha: “Abraão. Deus ka'oa ohina mani ida ira onava'iponi'imariniravini hija. Va'ora oakava'ijoaki bana adani kadaija'ari vanamitharonisiagaki. Va'ora osaariki bana adani ija'ari va'ora vavajahariki vasa'a kabodinia. Va'ora ova'aha'iki bana adani kadaija'ari, vaofinirina oadani bada vani'ahaha'oadahaki bana ida kodibadani”. Deua bini'aha ada Abraão kohana — niha ada Zacarias. ");
INSERT INTO padNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Asia vara niha ada Zacarias: —Deua binofiki ida haria akava'ijoavini akadimahi-ra nasohira kaimoni, bada ani'aja kaimoni ida badani Deua bivajahaki mahi hahavi arihokina oadani — niha ada Zacarias. ");
INSERT INTO padNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zacaria bini'aha ada kidisai tanaki: —Ivani, kodisai, ija'ari ira vanaonivini Deus danoki nama hojaki athi namoniva abono. Deus ira karonaki bana aihotahi abono viaha-ra iavikhananavavini. Hagihi nasohiva abono fori ihiki i. Va'ora inava'isohiki bana adani ija'ari vakadimahi-ra vanasohira kaimoni, vakadika'da'di kaikahina viahania. ");
INSERT INTO padNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ija'ari-ra inava'isohivini hiki bana ida Deus vakadihojai asohiriki, vakadivarani asohiriki hiki bina'biravini. Vakava'ipahinihi, oniani ida va'ora akava'ijoavini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Deus va'ora nakaidivaki adani ija'ari, binofiki va'ora va'adivini. Mahi vagani fori hiki ida Deus ija'ari-ra akava'ijoavini varani hini. Joma bakibakini vahojani vani fori hiki ida ija'ari Deu-ra avigariki. Ija'ari vaabini'iki vaibavia vahojaki fori vihiki adani. Deua binakama'da'ihi ida mahi vagani nokiani akadiania. Deus kania khaki ida vagaki. Vajaforia bana binavagahahaviki ida bakibakini. Vagaki ida Deus athi haria avanamithahavini Deus kahagihia ava'i jahajahaja kaimoni — niha ada Zacarias. ");
INSERT INTO padNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hari. Avijava'aha ada Zacarias kaisai João oniki. Danoki ada. Isai va'i-ra nahonariahihi'aha ada Ma'onahai Jahaki. Deu-ra nofijahakiki ada. Kidibadani kama'darini oadani, hojaha ada João amasia, ibavi kaija'aririki kania. Israel kaija'aria aviga'iariha kaho ada João. Oniaroa, kama'da'ihi ida kidibadani vakadiania Deus athia va'ora ka'ojomo'ivini. ");
INSERT INTO padNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Hari. Oniaroa, arabo hahavi kaka'da'dini Augusto oniki va'ora honariaha adani kidihonai abono vaipohiki: —Va'ora varajoma adani ija'ari kodiarabo hahavia vahojaki mahija va'ora oogavini nihafori vihina vaipohina — niha ada Augusto. Va'ora varajomavini kari Síria kaaraboni kaka'da'dini ada Cirênio oniki. ");
INSERT INTO padNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Oniaroa, ija'ari hahavi avikhaki vakadiabi'i avikhananavakia vava'banaki ibavini afohanana. ");
INSERT INTO padNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hari. José kaabi'i okhananavaki ada arabo kaka'da'dini Davi kohana oniki. Davi kohana biva'banaki kasidajini Belém oniki. Hari. Galiléia kaarabonia hojaha ada José, Nazaré sidaji onikia hojaha. ");
INSERT INTO padNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Oniaroa, ajihi'aha, Belém sidajia avikha'aha Maria khama varajomara kaimoni. José kagamo kaimoni ida Maria. Bivi'omapa'itxirina kaba'i vani kajahavido'ihi ida Maria. Ija'ari vakadivada ibavini ija'aria binaji'binivini mani ida 'daama kahidari vagorana Maria José khama va'ora nahojaja. ");
INSERT INTO padNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hari. Belém sidajia vahojana kaba'i kama'da'ihi ida isai 'banarahana. ");
INSERT INTO padNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'Bana'aha ada kidisai ahivaja'i. Bikarafoa'aha ada kidisai makaria. 'Daama kahidari vakadi'bai bavinia bibarari'aha ada kidisai i'oarinia. ");
INSERT INTO padNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hari. Belém sidaji maakarinia amasia vahojaki adani ovilia avakadava'ava abono. Joma oadani va'ora avakadava'aki adani ovilia. ");
INSERT INTO padNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Oniaroa, Deua bikaronaki ada ibavi kaija'arini ovilia avakadava'ava abono vakadiania. Nokiaki jaboni ida vagaki jahaki vakadiania. Nama gaari'ihi ida safini vagana fori hiki ovilia avakadava'ava abono vanamana, oniani ida va'ora narapata'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Deus ibavi kaija'arini va'ora ni'aha: —Hari'a varapata! Hora rakhaki hida moni jahakia a'onira okanamonihavini. Ija'ari hahavi vakadimoni ida moni jahaki, khai vakhanira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hidakaba'i Belém sidajia 'bana'iki ada isai Cristoa oniki. Ija'ari hahavi vakadi'aihotahi abono kaimoni ada. Avakadika'da'di ka'oa ada Cristo. ");
INSERT INTO padNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Va'ora avakaragaki bana adani José, Maria, isai tanaki 'daama kahidari vagorana. Isai 'daama kahidari vakadi'bai bavinia hojaki, kidiamia i'oarinia. Makaria bikarafoaki ada isai. Nimania ida bana isai tanaki-ra avakaragavini, oathi ka'oa hini-ra avarigaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hari. Deus ibavi kaija'arini vara va'ora ni'avini kaba'i, vanokia'aha adani Deus ibavi kaija'arini vahoariha vaipohiki. Vaipohi'oamanira adani. Deus kamoroa vaahia'aha. Vakadimoro kaathi hiki ida Deus jahana. Vakhaniha: ");
INSERT INTO padNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Jaha'oamanira ada Deus danoki nama hojaki! Deus va'ora no'aki adani ija'ari va'ora nakaidivaki va'i jahajahania, vaabono avaakakariakakhamara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Oniaroa, avajoisi'aha adani Deus ibavi kaija'arini Deus kania nama. Ovilia avakadava'ava abono vaabono vakani'akhama'aha: —Aokhava bana Belém sidajia! Anavanavanahava ida Deus haria nava'isohivini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hari. Jorakia avikha'aha avakhano'aha, va'ora vakaraga'aha adani José, Maria khama vanoki'aha ada isai tanaki 'daama kahidari vakadi'bai bavini bodinia omana. ");
INSERT INTO padNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ovilia avakadava'ava abono va'ora vananamitha'aha adani Maria, isai monina Deus ibavi kaija'arinia vara bivani'ajora'ikia. ");
INSERT INTO padNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ovilia avakadava'ava abono vaathi-ra vakamitha'aha adani ija'ari, vakava'ibodivaranikaraho'ihi ida isai monina. ");
INSERT INTO padNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria jaboni bikava'ibodivarani'ihi ida namitha'iki. Va'ini bodinia abononi vara ni'ahi kidisai monina Deus vara bivani'a'ikia. ");
INSERT INTO padNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hari. Ai vihi'aha adani ovilia-ra avakadava'aki, amasia avajoi'aha. Vaadahana kaba'i vaahia'aha, Deu-ra vani'aha: —Ivani ijahaki i, akadimoni ihini! Haria inanamitha'iki isai monina. Haria inanokiahivini hiki ada isai jaboni, Deus ibavi kaija'arini haria vara vani'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hari. Semana hoarani radaha'ihi, José, Maria khama avavikha'aha ada isai, vakarajomira kaimoni siikosida rajomia. Isai banini hi'ina viahani, Deus ibavi kaija'arini Maria-ra nava'isohijora'iki isai-ra Jesus vania vanaonira kaimoni, oniani ida vakadisai-ra vanaonivini hija Jesua. ");
INSERT INTO padNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Hari. José, Maria khama avavikha'aha ada Jesus Jerusalém sidajia. Vanamonaha'imidiaki ida ihinika ija'ari abononi sokovini jahaja kaimoni Deus viaha, vanaabaja kaimoni ida Deus kava'isohihi jiriki. 'Bo'dakari Moisés kohana bivava'isohihi'iki Deus kava'isohihi jirikia: “Deus kaimoni ada makhira isani ahivaja'i. 40 mahi ipohini isai 'banana naothinia sasidotxi kania vavikha'aha ada isai. Vakavikha'ihi jaboni bana ida ho'doko ko'bamiki, sasidotxi Deu-ra kanava'igavini kaimoni ida igitha abononi aha'diki. Isai kaamia abononi najahaki jaboni bana Deus ija'ari-ra honariavini hikia. Rajomi ida ija'ari abononi najahavini Deus viaha.” Nimania ida Deus kava'isohihi jiriki. Hari. José Jesu-ra avavikhaha Deu-ra khai vani'avini kagorania, Deus kania gahinai vanihara kaimoni ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hari. Jerusalém sidajia ibaviki ada makhira Simeão oniki. Oniaroa, Deu-ra khai vani'avini kagorania vakaikahina vani kaikahi'aha ada Simeão jaboni. Deu-ra nofijahakiki ada, athi binaababakhiaki jaboni ada. Ma'onahai Jahaki Simeão va'i-ra nahonariahihivini. Simeão binokhahaha'oadahaki ada aihotahi abono Deua bikaronaki, Israel kaija'ari-ra akava'ijoaki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma'onahai Jahakia bini'a'bo'da'iki: —Simeão. Iabinini viahania, inokiki bana ada aihotahi abono Cristoa oniki Deua bikaronaki — Simeão-ra ni'a'iki ada Ma'onahai Jahaki. ");
INSERT INTO padNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Oniaroa, Ma'onahai Jahakia binava'isohi'aha ada Simeão Deu-ra khai vani'avini kagorania okhana. Hari. Okha'aha. Oniaroa, vakaikahi'aha adani José, Maria khama, Jesu-ra avavikhajakosi'aha vanaabaja kaimoni ida Deus kava'isohihi jiriki. ");
INSERT INTO padNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeãoa bigathani'aha ada Jesus. Deu-ra vara ni'a'aha ada Simeão athi jahakia: ");
INSERT INTO padNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","— Deus Kodika'da'di. Hidakaba'i hora inanokiahivini hi'iki ada aihotahi abono, oniani ida ova'i-ra najaha'ia. Aihotahi abono-ra onokiravini oadani, ni-onofiki kaho ida oabinina. Onoki'iki ada aihotahi abono, ni-makhanijanaki ida oabinina. ");
INSERT INTO padNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Onoki'iki ada aihotahi abono ikarona'iki ija'ari hahavi-ra akava'ijoara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mahi vagani fori hiki ada. Va'ora ka'ojomo'iki bana adani judeus kaija'ari vihiriki avigaja kaimoni ida Deus kania avikhana. Kadaija'ari mani adani Israel kaija'ari. Vahoariha khai vani'aki bana ida Israel kaija'ari vakadiani miro'a aihotahi abono-ra ikaronavini — niha ada Simeão. ");
INSERT INTO padNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José, Maria khama vakava'ibodivaranikarahoki ida Simeão isai-ra vara vani'avini. ");
INSERT INTO padNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Oniaroa, Simeãoa bini'a'aha ada Deus: —Deus, va'ora kajoamora bana hadani Maria. Jesus kaamia maina-ra vara ni'aha ada Simeão: —Deus vania binagathogatho'ara hada hihada isai. Israel kaija'ari vaipohikia vavajahariki bana hada kadaisai. Deus va'ora nihimaki bana adani kadaisai-ra vanofiriki. Iva'ini mokara niki bana i. Hado sajoki iva'ini-ra nahadoki fori hiki bana ida iva'ini mokara nini karahoni. Israel kaija'ari vahoariha vani adani kadaisai-ra vanofira bana. Deus va'ora akava'ijoaki bana adani. Deua binanokiaki bana ida ija'ari va'ini bodini vara nini, kadaisai-ra vanofivini vanofiravini — niha ada Simeão. ");
INSERT INTO padNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hari. Deu-ra khai vani'avini kagorani bodinia hojaki jaboni ida Deus athi namoniva abono Ana oniki. Na'arihavi hi'iki ida. Kidiabi'i kohana onina Fanuel. Kidi'arahoda okhananavaki Aser oniki. Kamakhira'iki ida Ana. 7 badara ipohini bivahoja'iki ada kidimakhira, oniania, abini'aha, kaariha hi'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ana bivahojaki ida 84 badara ipohini. Deu-ra khai vani'avini kagorani kavasiribanini bodinia hojahaha'oadahaki ida Ana, ni-khaonaniki. Mahi, joma hikia, Deu-ra kanamasivibakhiaki ida. Kidihojai hiki ida. Mahi ipohiki ni-'baiki ida, Deu-ra vara ni'abakhia'oamanija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hari. Oniaroa, José, Maria vakadiania khami'ihi. Deu-ra khai ni'avini hiki aihotahi abono-ra karona'avini. Deu-ra ni'a'ihi ida Ana: —Deus, ijahaki i akadimoni ihini. Aihotahi abono-ra ikarona'iki i akadimoni. Naothinia Ana vara va'ora ni'aha adani ija'ari: —A'onivani avanokhaki ada aihotahi abono Deua bikarona'iki akadija'ari-ra akava'ijoara kaimoni. Hada vani isai aihotahi abono kaimoni — va'ora ni'ahi ida Ana. ");
INSERT INTO padNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Oniaroa, sasidotxi kania vavikhaha ada Jesus, Deus kania gahinai vanihara kaimoni. José, Maria khama vanaaba'ihi ida Deus kava'isohihi jiriki. Oniaroa, Galiléia kaarabonia avajoi'aha, Nazaré sidajia hojaki ida vagorana. ");
INSERT INTO padNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hari. Avijava'ina danomani'aha ada Jesus, karahomanihi ida kidi'ogahai. Deua bikajoamoraha'oadahamani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hari. Badara hahavi avikha'aha adani Jesus kaamia, kidibadia vihiki Jerusalém sidajia, vanakanorija kaimoni ida judeus kaija'ari vakadihinika Páscoa oniki. ");
INSERT INTO padNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hari. 12 badara ipohini-ra vahojavini vani kidiamia avavikha'aha ada Jesus Jerusaléa. ");
INSERT INTO padNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hari hi'ihi ida ihinika, ai vihi'aha vagorana avajoi'aha. Jesus vani ada hojaroni'aha Jerusaléa. José, Maria khama ni-aviga'iki ada Jesus hojaroni'ina. Vakadija'ari vakadiania avajoi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hojaki vavanihaha ada Jesus vakadija'ari vakadiania, oniani ida mahi oadani va'ora naadahaja. Mithani vani Jesu-ra vanako'di'aha vakadija'ari vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Vakaragaravini mani ida Jerusaléa va'ora anajoija. ");
INSERT INTO padNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mahi ahoarabakosiki vani vanako'di'aha. Deu-ra khai vani'avini kagorania vakaraga'aha ada Jesus. Judeus kaija'ari vaka'ojomo'iva abono vahararana vithiki ada Jesus. Mitha bini'a'iki ida vakadivarani, va'ora nana'dohibakhiaki jaboni ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Isai hina kaba'i ada Jesus, biogajahakiki ida Deus athi, vakadina'dohi bigathanivini biogajahakiki jaboni, oniani ida Jesus athi-ra vakamithakia vakava'ibodivaranikarahovini hija. ");
INSERT INTO padNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hari. Jesu-ra vanoki'aha adani kidiamia, kidibadia khama, vakava'ibodivaranikaraho'aha jaboni. Kidiamia bini'aha: —Kodisai, niha inimanija Jerusaléa ihojaroni'iki? Kadabadia khama ira akava'isokonikarahovini hiki iavisonini. Ira anako'di'iki hari akadija'ari vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Oniaroa, Jesua bini'ahi ida kidiamia: —Mamai, nahina mani ida hora avanako'dihavini hija? Avarigaria koda ida kaikahi'ini mahi kodiabi'i-ra khai vani'avini kagorania ohojana kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jesus kavarani-ra mitha vani'avini kaba'i, ni-avigaki ida nahina nini vara va'ora ni'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oniaroa, José, Maria vakadiania ajoi'aha ada Jesus, Nazaré kasidajinia avikha'aha. Binaaba'ihi ida kidiamia, kidibadia vihiki vaathi. Kidiamia bikava'ibodivarani'ihi ida namitha'iki Deu-ra khai vani'avini kagorani bodinia. ");
INSERT INTO padNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Karaho'aha ada Jesus, kidi'ogahai karaho'iki jaboni. Deus, ija'ari hahavi khama vavajahaki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Hari. Judéia kaarabonia khaha ada makhira Deua bikaronaki, onina João Batista. Amasia hojaki ada. Kagorariki ida amasi. Zacarias kaisai ada. Oniaroa, João Batista-ra vara ni'aha ada Deus: —João, va'ora nanamitha bana adani ija'ari hahavi omonina. Va'ora ka'ojomo'i bana oathia ira onava'isohivini hi'ikia — niha ada Deus. Oniaro kari, arabo hahavi kaka'da'dini hiki ada Tibério. 15 badara ipohini vani arabo hahavi kaija'arini-ra va'ora vaka'da'dira ada Tibério. Oniaro kari, Judéia kaaraboni kaka'da'dini ada Pôncio Pilatos. Galiléia kaaraboni kaka'da'dini ada Iroji. Ituréia kaaraboni, Traconites kaaraboni hiki kaka'da'dini ada Iroji kakajo'o Filipe oniki. Abilene kaaraboni kaka'da'dini ada Lisânias. Sasidotxi vavaka'da'diva adani Anás, Caifás khama. ");
INSERT INTO padNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hari. Oniaroa, ajihi'aha ada João Batista. Jordão vaini kaarabonia aadahaoni'aha, ija'ari-ra va'ora ni'abakhia'aha: —Avakadihojai asohiriki-ra vakava'ipahinika'oa bana mahija a'onira okanavini, Deua bina'biraja kaimoni ida avakadihojai asohiriki bada avani'abakhiaki — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'Bo'dakari Deus athi namoniva abono Isaías kohana onikia vara bivani'ajora'iki ida João Batista ija'ari-ra ka'ojomo'ivini. Isaías kohana athi jiriki hojaki Deus athi kapapirani pitania: “Amasia hojaki ada makhira, ija'ari-ra vara ni'a'aha athi 'barakia: ‘Amaakariki ida akadika'da'di kaikahina kamahini. Vanasohi bana ida avakadimahi, avakadika'da'di khana-ra vanaviahanokha bana! Vanamonaha'a bana ida hagihi sohiki akadika'da'dia bivaadahaki kaimoni. Hagihi sohiki fori hiki ida ija'ari kamahi sohiki. ");
INSERT INTO padNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Vanaimamamananaha ida arabo da'bada'bahani hahavi. Vanasohi bana ida hagihi tonotonohani sohija kaimoni. Vanaimamamananahana bana jaboni ida hagihi da'bada'bahani, arabo tiratirahania jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ija'ari hahavia vanokiki bana ada aihotahi abono Deua bikaronaki.’ Niki ida Isaías athi.” Isaías kohana vara bivani'aki ida hagihi sohini. Kidivarani ka'oa ida ija'ari kamahi-ra nasohija. ");
INSERT INTO padNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hari. Vajoroniha adani ija'ari vaipohiki João Batista kania, vanofiki ida João Batista va'ora kanavini. Va'ora ni'aha adani ija'ari hahavi: —Jahari kahojai-ra avakava'ipahinivini-ra avakahi'badaraki a'oni. Deua bikaronaki bana ida avakadihojai asohiriki abosini. Nahina jahariki-ra avagathaniriki avaabononi avavanihamanija koda bana ida avakadihojai asohiriki abosini? ");
INSERT INTO padNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Avahojani hiva ida hojai asohiki mahija hojai asohiriki-ra avanofijanaravinia Deu-ra avananokiahivini. Hari'a avaabononi vakanavaranihakhama: “Akadiabi'i okhananavaki ada Abraão kohana”. Asohiki ida Abraão kahojai. Avakadihojai ni-asohiki. Abraão kaisai vavijavaronisiagaki avihini kaba'i, ni-Deus a'onira akava'ijoaki. Deus va'ora akava'ijoaki adani vakadihojai asohiriki-ra vakava'ipahini'iki. ");
INSERT INTO padNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ihi'ai avani fori avihiki a'oni. Hojai asohikia avakahojairihi; ihi'ai avani bonobakhiariki fori avihihi. Makhira kajoriki fori hiki ada Deus. Khaki bana ada makhira binobaja kaimoni ida ihi'ai avani bonobakhiariki 'damania. Binahokahiki ida ihi'ai avani obaki siho kabodinia. Nini vani jaboni Deus va'ora arakhaki bana adani athi naabani vihiriki nahina jaharikia — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hari. João Batista athi-ra vakamitha'ikia vanana'dohi'aha: —Nahina-ra koda bana bada ani'aki hari, jaharikia Deus haria arakharia kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Oniaroa, João Batista bigathani'ihi ida vakadina'dohi: —Avavahojaki ida karahobi 'bamiki; kanahinariki-ra vano'a hoarania. Ivahojahi ida 'bai; kanahinariki-ra no'a pitania — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hari. Vakaikahi'aha adani imposto gathaniva abono vaipohiriki jaboni João Batista kania, vanana'dohi'aha: —Nahina-ra koda bana bada ani'aki hari, jaharikia Deus haria arakharia kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Avakadibadani hiki ida imposto kajinironi-ra avagathanivini arabo hahavi kaka'da'dini kaimoni. Hari'a vanakaraho ida imposto kajinironi-ra avakanikhariavini ija'ari vakadiania. Asohirihi ida vakadijiniro avaanivini avakadimoni hini — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Vahararana vahojaha adani sorara jaboni, vanana'dohi'aha: —Harivani, nahina-ra koda bana bada ani'aki hari, jaharikia Deus haria arakharia kaimoni? —Hari'a vahoariha vakadibadani asohirini-ra avanaathidanoarari'imarini vakadijiniro-ra avarakhara kaimoni avakadiania. Khai vani'a avakadibadani abosini kajinironi ipohini avagathaniki — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","João Batista athi-ra vakamithakia vanokhahaha'oadahaki ada aihotahi abono Deua bikaronaki, oniania vaabono vakani'akhamabakhiaha: —Aihotahi abono mani koda ada João Batista? ");
INSERT INTO padNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Oniaroa, João Batista va'ora ni'aha: —A'onira okanaki ho paha bodinia. Khaki bana ada hoariha, ka'da'di ka'oa ada ovari. Hovani kidihonai abono ho. Arafiaki ida kidihojai asohika'oani. Kodihojai jahani fori hirihi ida kidihojai jahani arafiaki, kaba'i hora nagathogathovini oakodiara kaimoni. Ovaria bikaronaki ada Ma'onahai Jahaki ija'ari va'ini-ra nahonariahihiki kaimoni. Siho kakhororoki fori hiki bana ada Ma'onahai Jahaki ija'ari kania khana. Binihimaki ida ija'ari kahojai asohiriki — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hari. Vara ni'ianaha ada João Batista. Ija'ari-ra kavarajomivini ida trigo 'ba'dani aka'diririhaki: —Aka'diririhaki ida trigo 'ba'dani aaniaja kaimoni ida ba'ba'da asafini. Anabavihi ida trigo 'ba'dani so'oroa. Siho kabodinia anahokahi'ihi ida asafini. Nimania jaboni ida onaothia khaki ija'ari-ra kanahoarihakhamavini. Va'ora aniki adani ija'ari hojai asohikia vakahojaiki, ija'ari hojai asohikia vakahojaiki vahararana. Ovari va'ora vahojaki adani ija'ari hojai asohikia vakahojaiki kidiania. Va'ora nahokahiki adani ija'ari hojai asohirikia vakahojaiki Ibavi Jaharika'oaki siho kaihimiriki kania. ");
INSERT INTO padNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hari. João Batista vara bivani'aki ida Deus monina jahaki, ija'ari-ra nava'isohi'aha Deua binofiki vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","João Batista vara bini'aha ada arabo kaka'da'dini Iroji oniki: —Ni-Deua bivajahapa'itxiki ida kadakajo'o kagamo Irodisi oniki-ra ivahojavini. Ipohiki ida kadahojai asohiriki hoariha jaboni — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hari. Irojia ni-bivajahaki ida João Batista kava'isohihi, oniani ida kidihojai asohiriki-ra anarafiavini hija. Bivahonariahi'aha ada João Batista cadeia o'oina. ");
INSERT INTO padNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hari. João Batista cadeia hojana viahania ija'ari vaipohiki avikhabakhia'iki kidiania, va'ora kana'aha. Oniaroa, Jesus João Batista kania akhanofoni'iki jaboni. João Batista Jesu-ra kana'iki. Kanana naothinia Deu-ra vara ni'aha ada Jesus. Vara nina kaba'i, binoki'ihi ida nama arabikhajahaki. ");
INSERT INTO padNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jesus kania gaari'aha ada Ma'onahai Jahaki, ho'doko kanokiani fori hiki ada. Nama kamithavahaki ida athii: —Ivani kodisai i. Ira onofijahakiki i. Khai oni'aki ida ihoja'ini. ");
INSERT INTO padNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hari. Jesus kabadarana ipohini 30 hi'ini, ija'ari ka'ojomo'ivini kama'da'aha. Jesus kaabi'i ija'aria vavanihaki ada José. Eli kohana kaisai ada José. ");
INSERT INTO padNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matate kohana kaisai ada Eli. Levi kohana kaisai ada Matate. Melqui kohana kaisai ada Levi. Janai kohana kaisai ada Melqui. José kohana kaisai ada Janai. Matatias kohana kaisai ada José. ");
INSERT INTO padNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Amós kohana kaisai ada Matatias. Naum kohana kaisai ada Amós. Esli kohana kaisai ada Naum. Nagai kohana kaisai ada Esli. ");
INSERT INTO padNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maate kohana kaisai ada Nagai. Matatias kohana kaisai ada Maate. Semei kohana kaisai ada Matatias. José kohana kaisai ada Semei. Joda kohana kaisai ada José. Joanã kohana kaisai ada Joda. ");
INSERT INTO padNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Resa kohana kaisai ada Joanã. Zorobabel kohana kaisai ada Resa. Salatiel kohana kaisai ada Zorobabel. Neri kohana kaisai ada Salatiel. ");
INSERT INTO padNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melqui kohana kaisai ada Neri. Adi kohana kaisai ada Melqui. Cosã kohana kaisai ada Adi. Elmadã kohana kaisai ada Cosã. Er kohana kaisai ada Elmadã. ");
INSERT INTO padNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josué kohana kaisai ada Er. Eliézer kohana kaisai ada Josué. Jorim kohana kaisai ada Eliézer. Matate kohana kaisai ada Jorim. Levi kohana kaisai ada Matate. ");
INSERT INTO padNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeão kohana kaisai ada Levi. Judá kohana kaisai ada Simeão. José kohana kaisai ada Judá. Jonã kohana kaisai ada José. Eliaquim kohana kaisai ada Jonã. ");
INSERT INTO padNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleá kohana kaisai ada Eliaquim. Mena kohana kaisai ada Meleá. Matata kohana kaisai ada Mena. Natã kohana kaisai ada Matata. Davi kohana kaisai ada Natã. ");
INSERT INTO padNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jessé kohana kaisai ada Davi. Obede kohana kaisai ada Jessé. Boaz kohana kaisai ada Obede. Sala kohana kaisai ada Boaz. Nassom kohana kaisai ada Sala. ");
INSERT INTO padNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadabe kohana kaisai ada Nassom. Admim kohana kaisai ada Aminadabe. Arni kohana kaisai ada Admim. Esrom kohana kaisai ada Arni. Peres kohana kaisai ada Esrom. Judá kohana kaisai ada Peres. ");
INSERT INTO padNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacó kohana kaisai ada Judá. Isaque kohana kaisai ada Jacó. Abraão kohana kaisai ada Isaque. Tera kohana kaisai ada Abraão. Nacor kohana kaisai ada Tera. ");
INSERT INTO padNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruque kohana kaisai ada Nacor. Ragaú kohana kaisai ada Seruque. Faleque kohana kaisai ada Ragaú. Éber kohana kaisai ada Faleque. Sala kohana kaisai ada Éber. ");
INSERT INTO padNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainã kohana kaisai ada Sala. Arfaxade kohana kaisai ada Cainã. Sem kohana kaisai ada Arfaxade. Noé kohana kaisai ada Sem Lameque kohana kaisai ada Noé. ");
INSERT INTO padNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusalém kohana kaisai ada Lameque. Enoque kohana kaisai ada Metusalém. Jarete kohana kaisai ada Enoque. Maleleel kohana kaisai ada Jarete. Cainã kohana kaisai ada Maleleel. ");
INSERT INTO padNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos kohana kaisai ada Cainã. Sete kohana kaisai ada Enos. Adão kohana kaisai ada Sete. Deus kaisai ada Adão. Deua binamonaha'iki ada Adão. ");
INSERT INTO padNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hari. Jordão vaini onikia ajihi'aha ada Jesus. Ma'onahai Jahaki Jesus va'i-ra nahonariahihivini. Ma'onahai Jahakia biavikha'aha ada Jesus amasia. 40 mahi hoja'aha. Kaija'aririhi ida amasi. ");
INSERT INTO padNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ni-nahina-ra haki. 'Bairina mani ida Jesu-ra navai'ami'ia. Oniaroa, okha'aha ada Jahari Jesus kania. Bikaboroboro'aha ada Jesus bada bini'aja kaimoni ida badani Deua binofiriki. Jesua ni-bikapoaripa'itxiki ida athi. ");
INSERT INTO padNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jaharia bini'aha: —Deus kaisai ihihi; ja'di-ra 'bai aniha'a. ");
INSERT INTO padNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesua bini'aha: —Iniani. Ni-Deus hora honariaki ja'di-ra 'bai oanihavini. Deus athi kapapirania hojaki ida athi: “Ni-'bai ka'oa binahokiki ida ija'ari. Deus athi hahavi-ra anaabavini mani ida ija'ari-ra nahokija.” — Jesua bini'aha ada Jahari. ");
INSERT INTO padNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Oniaroa, arabo namahikia Jaharia biavikhaha ada Jesus, binanokiahivini vihiha adani arabo hahavi kaija'arini, vakadiarabo hiki. Jorakia binanokiahiha. ");
INSERT INTO padNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Bini'aha ada Jesus: —Va'ora ohonariaha'oadahaki adani ija'ari hahavi, vakadika'da'di ohiki ho. Hora kanamasivi'a bana! Hora ikanamasivihi; va'ora ihonariavini va'ora ova'ahaha vakadika'da'di ihija kaimoni. Vakadinahina kaidivakia ira ono'ahi jaboni. Ogathanihi ida arabo hahavi, ohonariaki ida ija'ari hahavi, vakadika'da'di vihiki, kodibadani-ra bada vani'ara kaimoni. Kodiani hahavi adani ija'ari. Hoariha ka'da'di hina-ra onofihi; ova'ahaha. Hora ikanamasivihi; vakadika'da'di ihini-ra ova'ahahi — niha ada Jahari, Jesu-ra kaborovini, bada bini'aja kaimoni ida Deua bivajahariki. ");
INSERT INTO padNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hari. Jesua bini'aha: —Iniani. Jokoa ira okanamasivirihi. Deus athi kapapirania hojaki ida athi haria nava'isohiki kaimoni: “Deus ka'oa-ra kanamasivi'a bana, avakadika'da'di hira kaimoni. Deus athi ka'oa-ra vanaaba'a.” — Jesua bini'aha ada Jahari. ");
INSERT INTO padNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Oniaroa, Jerusalém sidajia Jaharia biavikhaha ija'ari Deu-ra khai vani'avini kagorani 'da'dini a'ani sohiriama'oki kania, bini'aha: —Araofarari'a bana nabo'ajaja. Deus kaisai ihini mani ida ira akadava'ajahakivini hija, iahaharia kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Deus athi kapapirania bini'aki: “Deus va'ora honariaki adani ibavi kaija'arini kadania ira avagathanivini, ivigarirariria kaimoni ida ja'di, iabononi a'bororia kaimoni jaboni.” Nimania ida Deus athi — Jaharia bini'aha. Asia vara niki ada Jahari: —Deus kaisai ihihi; araofarari'a nabo'ajaja mahija Deus ira akadava'avini-ra ikaijo'avini. ");
INSERT INTO padNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesua bigathanihi ida athi: —Iniani. Jokoa iathini-ra onaabarihi. Jokoa oaraofararirihi. Deus athi haria nava'isohiki hari jaboni: “Hari'a Deu-ra kaijo'a bana badani danokia kabadanina, iogaja kaimoni ida Deus hojana kadania.” ");
INSERT INTO padNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Oniaroa, hari hi'imidia'ihi ida Jesus Jaharia bikaboroborovini. Jesua ni-binaabaki ida Jahari athi. Ajihi'aha ada Jahari. Binokhahi ida mahi hoariha Jesu-ra kaboroboro'ianavini kamahini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hari. Galiléia kaarabonia ajoi'aha ada Jesus. Ma'onahai Jahaki danona Jesus va'i-ra nahonariahihiha. Ija'ari hahavia vakamithaki ida Jesus varani hina Galiléia kaarabonia. ");
INSERT INTO padNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judeus kaija'ari Deu-ra vara vani'avini kagorania, Jesus va'ora ka'ojomo'ibakhiaki adani ija'ari vajoroniki. Vakamithava vara vaabono vakani'akhama'aha: —Jahaki ida Jesus kavarani. ");
INSERT INTO padNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hari. Okha'aha ada Jesus Nazaré sidajia, ibavi bivavijavaki kania. Jesus hojana hiki ida judeus kaija'ari Deu-ra vara vani'avini kagorania okhana avakoirina kamahini. Oniania, okhajakosi'aha ada Jesus, vithi'aha. Hojana oadani, gaamanani'aha vara bivani'aja kaimoni ida Deus athi kapapirani. ");
INSERT INTO padNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Deus athi kapapirani akadava'ava abonoa biarakha'ihi ida Deus athi kapapira pitani Jesus kania. Isaías kohana athi kapapirani ida. Jesua biarabikhaihi, bikaraga'ihi ida athii pitani Cristo varani hina-ra vava'isohihijoravini. Niha: ");
INSERT INTO padNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ma'onahai Jahaki hora avi'onanivini. Hora nagathogathovini hiki vakanahinariki-ra va'ora onanamithavini Deus monina jahakia. Hora nagathogathovini hiki va'ora oakava'ijoara kaimoni adani ija'ari vagathaki. Hora nagathogathovini hiki ija'ari vakamaodorohaki vanokho 'ba'dani-ra oanavagahavini. Hora nagathogathovini hiki jaboni va'ora oakava'ijoara kaimoni adani ija'ari vahoariha va'ora vanajaharihariki. ");
INSERT INTO padNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Hora nagathogathovini hiki jaboni va'ora vara oni'ara kaimoni adani ija'ari hahavi: ‘Deua binofiki ida kidija'ari va'ora oakava'ijoavini.’ ” Nimania ida Isaías kohana athi — vara niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesua binahoja'imidia'ihi ida papira. Deus athi kapapirani akadava'ava abono-ra no'avini hi'ihi. Vithi'ianaha ada Jesus. Ija'ari judeus kaija'ari Deu-ra vara vani'avini kagorania vajoroniki Jesu-ra vada vani'ahaha'oadaha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesus va'ora ni'aha: —Deus hora nagathogathovini hiki bada oni'aja kaimoni ida badani athi kapapirania vara a'onira oni'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Varani-ra vakamitha'iki vaabono vara vakani'akhama'iki: —Jahaki o Jesus. Avajahaki ida vara bivani'a'iki athi. Akava'ibodivaraniki ida kidivarani jahaki. José kaisai mani koda ada Jesus? Nihaniki vania biogaja ida Deus athi nahina hini? — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus va'ora ni'aha: —Hora vara avani'aki bana a'oni varani pa'itxia. “Mijiko ihini, iabono anaihota'a.” Hora avani'aki bana jaboni a'oni: “Akamitha'iki ida varani ihini Cafarnaum kasidajinia ija'ari vakavamoniki-ra va'ora ianaihota'avini. Ka'oa hihi ida varani ihini, hihida sidaji Nazaré onikia iavijavaki i, bada ini'a jaboni ida kadabadani danoki.” — Hora avani'aki bana a'oni. ");
INSERT INTO padNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Asia vara niki ada Jesus: — A'onira onava'isohiki bana ho. Deus athi namoniva abono-ra vagathanijahakiriha adani ibavi bivavijavaki kasidajini kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mitha vakhani'a. Vara ovani'aki ada Deus athi namoniva abono Elias kohana varani hina. Kidija'aria vagathanijahakiriha ada Elias kohana. Elias hokina kari Deu-ra kanikharia'iki ada. Badara ahoarabakosiki khararijanariha ada bahi. Vai'ami abani vihi'iki adani arabo kaija'arini hahavi. Vaipohiki adani kaariha Israel kaija'ari vahararana vahojaki, vakainamoki ida vakadi'bai. ");
INSERT INTO padNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kaba'i, ni-Israel kaija'ari kaariha vihiki vakadiania Deua bikarona'iki ada Elias okhana. Arabo hoariha kaija'arini kaariha kania Deua bikarona'iki ada Elias, Sarepta sidajia okhana, Sidom kaarabonia. ");
INSERT INTO padNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Vara ovani'aki jaboni ada Deus athi namoniva abono hoariha Eliseu oniki. Kidija'aria vagathanijahakiriha ada Eliseu kohana. Eliseu hokina kari vaipohiki adani ija'ari asafi namani-ra najaharikia vakavamoniki, Israel kaija'ari vahararana vahojaki. Ni-Deus va'ora anaihotaki. Naamã hoarana Síria kaaraboni kaija'ari vani ada Deua binajaha'ara. A'onivani fori hiki hida oabono vara ovani'avini. Deus athi namoniva abono ohina mani ida oibavi ovavijavaki kasidajini kaija'arini hora vagathanijahakiravini hija — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesus athi-ra mitha vani'aha adani ija'ari vajoroniki judeus kaija'ari Deu-ra vara vani'avini kagorania, vavajahari'ihi ida kidivarani, vaihamahikaraho'aha. ");
INSERT INTO padNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Oniaroa, vigaamanani'aha, Jesu-ra vagathi'aha avarahokaonani'aha sidaji banininija. Arabo namahiki kania hojaki ida Nazaré sidaji. Jesu-ra avavikha'aha. Ipa'ita namahiki kania vanofiki ida Jesu-ra avarokojohofonivini abinira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ni-vakaabokaki avarokojohofonivini. Radaha'oamani'aha ada Jesus ija'ari vaipohiki vahararana, ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hari. Okha'aha ada Jesus Cafarnaum sidajia Galiléia kaarabonia. Akhano'aha, hoja'aha. Avakoirina kamahini judeus kaija'ari Deu-ra vara vani'avini kagorania avi'oi'aha. Va'ora ka'ojomo'i'aha adani ija'ari vajoroni'iki. ");
INSERT INTO padNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Vakava'ibodivaraniki ida va'ora ka'ojomo'ivini niha ninini Jesua biogajahakiki ida nahina Deua binofiki, oniani ida Deus athia va'ora ka'ojomo'ijahakivini hija. ");
INSERT INTO padNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oniaroa, judeus kaija'ari Deu-ra vara vani'avini kagorania hojaha ada makhira kabajadiki. Bodi'baraha'aha: ");
INSERT INTO padNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesus, nahina hida akadiania inofija? Haria inihimamaniki i koda? Ira oogaki ho. Ivani ijahaka'oaki i, Deus ira karonaki i — makhira bini'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Oniaroa, Jesua bikaabani'ihi ida bajadi: —Avisoni'a! Makhira kania akara'o'a bana! Hari. Bajadia binarai'aha ada makhira vajoroniki vaviaha, ajihi'ihi ida bajadi. Ni-makhanina hojaroni'iki ada makhira. ");
INSERT INTO padNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vahoariha mitha vani'a'ihi, vakava'ibodivarani'ihi ida Jesus kavarani. Vaabono vakani'akhama'aha: —Nahina nimania ida Jesus kavarani. Ka'da'di oamani ada. Danoki ida kidibadani. Bikaabokaki ida bajadi akara'o'ini ija'ari kania. Bajadia binaaba'iki ida athi — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Galiléia kaarabonia akarafarakhamaki ida Jesus monina. ");
INSERT INTO padNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hari. Judeus kaija'ari Deu-ra vara vani'avini kagorania ajihi'aha ada Jesus. Simão gorana okha'aha. Kaikahi'aha gora bodinia o'oi'aha. Kabaravakarahoki ida Simão kamasodini. Simão Jesu-ra vara vani'avini hi'ini hida kidikavamoni. ");
INSERT INTO padNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Oniaroa, bivi'omaki kania okhamiha ada Jesus. Bini'ahi: —Barava, akara'o'a gamo kania! Jorakia radaha'ihi ida kidibarava. Gama'ihi ida Simão kamasodini. Va'ora kahinanika'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hari. Mithani vaivaini vani, Jesus kania ija'ari va'ora vavikha'aha adani vakadiva'ahi vakavamoniki. Ipohiki ida vakadikavamoni. Jesus va'ora kaabadaronaha'aha adani ija'ari vakavamoniki, va'ora anaihota'aha. ");
INSERT INTO padNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vahararana vahojaki adani ija'ari vakabajadiki. Ija'ari vakadiania avakara'o'aha adani bajadi, vabodi'baraha'aha: —Jesus, ivani ka'da'di i! Deus kaisai i! Bajadia avigaki ada aihotahi abono Deua bikarona'iki, oniani ida vara vakhanijanarina Jesus va'ora kaabanivini hija. ");
INSERT INTO padNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hari. Oniaroa, ka'afokajomani vagavagani sidajia okhaonani'aha ada Jesus. Kaija'aririki kani-ra anikhaha'avini. Akhano'aha hoja'aha. Ija'ari Jesu-ra vanako'dihavini, vakaraga'aha amasia. Vanofirihi ida Jesus ajihina ibavi hoariha okhana. ");
INSERT INTO padNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Oniania, ija'ari vaipohiki-ra va'ora ni'aha ada Jesus: —Sidaji ipohiki, ija'ari vahoariha vakadiania ookhaki ho. Nini vani Deua binofija ida. Va'ora okanamonivini hiki Deus ija'ari hahavi-ra vaka'da'divini kavaranihia. Binofiki ida ija'ari hahavi-ra vaka'da'divini, vakamithahahavija kaimoni ida Deus athi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oniaroa, ibavi hahavia aadahaoni'aha ada Jesus. Judeus kaija'ari Deu-ra vara vani'avini kagorania va'ora aka'ojomo'ionivini, va'ora kanamonivini hi'ihi ida Deus athi. ");
INSERT INTO padNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hari. Galiléia 'dako vadinia hojaha ada Jesus. Ija'ari vaipohiki vaabono vakana'ara'arakhamavini hiki, Jesus athi-ra vakamithavini-ra vanofivini. Jesua vara bivani'a'ihi ida Deus athi. ");
INSERT INTO padNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Oniaroa, bikanokihi ida kanava ko'bamiki akarahokamoriki. Araba abonoa vakosokohi ida vakaditahafa vakanahojahaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Simão kakanava-ra kakanikhariaha ada Jesus. Simãoa biakarahokafoni'ihi, vaki'dama'aha avakakhanaipa'itxi'aha. Kanava kabodinia hoja'aha vithina va'ora ka'ojomo'iha adani ija'ari kaasia pasapasania vahojaki. ");
INSERT INTO padNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hari hi'ihi ida kidivarani, Simão-ra ni'aha: —Simão, avakakhanaipa'itxi bihiani kania. Avakosona'iana ida avakaditahafa, abaisana-ra avarakanagithija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simãoa bini'aha: —Jesus, joma oadani ariaraba'iki hari, ni-nahina-ra akanagithi'iki. Haria ihonariahi; akosona'ianahi ida tahafa. ");
INSERT INTO padNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hari. Paha bihiani kania avakakhanaiha, avakosona'ianahi, avakanagithi'aha ada abaisana ipohiki. Abaisana ipohikia bikana'birakamari'ihi ida vakaditahafa. ");
INSERT INTO padNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Oniaroa, va'ora vakobaranahaha adani vakahoariha kanava kahoariha vakahagiki va'ora vaakodiara kaimoni. Vaakha'aha, vakano'bamamisi'ihi ida kanava. Vakanaji'bini'ihi ida kanava ko'bamiki abaisana. Ka'biri'birihanana'ihi ida kanava ko'bamiki, ako'omarikamari'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Hari. Simão Pedroa binokiha ada abaisana ipohiki vagathi'iki, bikava'ibodivarani'ihi ida Jesus kabadani danoki. Jesus viaha kajo'atharari'aha, bini'aha: —Kodika'da'di, ijahaki i. Ojahari'oamanija. Kodihojai jahariki ova'i-ra anaipahihiki, oniani ida iakara'oni-ra onofivini hija — Jesu-ra ni'aha ada Simão Pedro. ");
INSERT INTO padNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simão ko'bami Zebedeu kaisai vi'bamiki, Tiago, João vihiki. Vakava'ibodivarani'aha jaboni ada abaisana ipohiki avakanagithi'iki. Simão-ra ni'aha ada Jesus: —Hari'a hora fini! Abaisana-ra avanako'dijanarihi bana. Ija'ari vani bana adani va'ora avanako'dihara va'ora avibaranahara, kodija'ari vihira kaimoni — va'ora nava'isohi'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hari. Avakarahokamori'ianahi ida vakadikanava. Vanahojaha'ihi ida vakadinahina, Jesu-ra vavaipohiha'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hari. Sidaji bodinia hojaki ada Jesus, kidiania okha'aha ada makhira kavamoniki. Asafi hahavi namani-ra najahariki kakavamoniki ada. Jesu-ra noki'aha. 'Bisoni'aha Jesus viaha. Bikanikharia'aha: —Jesus, hora kajoamora bana! Hora inajahavini-ra inofihi; hora inajahahi — niha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Oniaroa, Jesua bikanaibavi'ihi ida sa'a makhira namana, bikadasa'aha, bini'aha: —Ha'a, onofiki ida ira onajahavini. Jaha'a bana! Jorakia avisoni'ihi ida kidikavamoni asafi namania hojaki jaha'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesua bini'aha: —Hari'a inanamitha'a hida ira onajahavini. Sasidotxi kania okha'a bana mahija iasafini namani-ra nokivini, biogaja kaimoni ida ijaha'ini. Deus kava'isohihi jirikia bihonariaki ida ija'ari jaha'iki Deu-ra kanava'igavini igitha abononi aha'dikia, vahoariha avigaja kaimoni ida jaha'iki. Sasidotxi ira nokivini naothinia inaaba'a bana ida Deus kava'isohihi jiriki — niha ada Jesus. Hari. Ajihi'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ija'ari vaipohikia avananamithaoni'iki ida Jesus ija'ari-ra anaihotavini kavaranihi. Ija'ari vakavamoniki vaipohiki vikhaki kidiania va'ora anaihotara kaimoni. Vajoronibakhiaki jaboni adani ija'ari vaipohiki kidivarani vakamithara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hari. Okhabakhia'aha ada Jesus ibavi kaija'aririki kania, Deus khama vara vaabono vakani'akhamara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Hari. Mahi hoariha gora bodinia hoja'aha ada Jesus. Va'ora ka'ojomo'i'aha adani ija'ari. Vakadiania vajoroni'aha adani farisio, judeus kaija'ari vaka'ojomo'iva abono khama. Jesus maakarina vavithi'aha. Galiléia kaaraboni, Judéia kaaraboni, Jerusalém sidaji hikia vikhaki adani ija'ari. Jesus kania Deus danona hojani mani ida Jesus ija'ari kavamoniki-ra va'ora anaihotavini-ra kaabokavini hija. ");
INSERT INTO padNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hari. Vakaikahi'aha adani makhira Jesus bivahojaki kania. Vavikha'aha ada makhira hoariha jo'o aba'oronisiagaki jorana namania omaki. Vanofiki ida vavikhajakosivini Jesus kania. ");
INSERT INTO padNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ji'biniki ida gora ija'ari vâipohikia, ni-nihanikia makhira jo'o aba'oronisiagaki-ra avavikhajakosiki. Avavikasiha, gora 'da'dini a'ani sohiriama'okia avavikasi'aha. Vana'bakhamanani'ihi ida gora 'da'dini a'ani, kharani'ihi, jorai damomisikia avaragari'aha, avanahiririrarivini ada makhira ija'ari vajoroniki vakadiania. Vibarari'aha Jesus viaha. ");
INSERT INTO padNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus abono-ra ni'aha: —Vakajari'darihi hida makhira jo'o aba'oronisiagaki-ra oanaihotavini-ra okaabokavini. Oniaroa, makhira kavamoniki-ra ni'a'aha: —Kodiva'ahi, 'bira'iki ida kadahojai asohiriki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Judeus kaija'ari vaka'ojomo'iva abono, farisio khama vaabono vakani'akhama'aha: —Jahariki ida Jesus kavarani. Deus ka'oa bikaabokaki hida hojai asohiriki na'birani. Deus hiriha ada Jesus. Makhira ka'oa ni-bikaabokaki ida ija'ari kahojai asohiriki-ra na'biravini. ");
INSERT INTO padNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesua biogaki ida vakava'ibodivaranivini, va'ora ni'aha: —Jahariki ida kodivarani-ra avakajari'davini. ");
INSERT INTO padNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Oanaihotaki bana ada makhira. Oanaihotavini avanokiha; avarigahi jaboni ida kidihojai asohiriki ona'biravini okaabokavini. Deus hora karonavini hiki ija'ari kahojai asohiriki-ra ona'biravini. Hovani ija'ari hahavi vakadi'aajo ho — va'ora ni'aha ada Jesus. Oniaroa, makhira jo'o aba'oronisiagaki-ra ni'aha: —Gaa'a, adaha'a. Ijorani-ra nabiini'a, igorania okha'a bana. ");
INSERT INTO padNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vanokivini kaba'i jorakia gaa'aha, jorana-ra nabiini'aha, gorana okha'aha. Khai bini'ahaha'oadahavini ida Deus jahana. ");
INSERT INTO padNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Oniaroa, ija'ari vanokiva vakava'ibodivaranikaraho'aha. Vaofinikaraho'aha. Deu-ra khai vani'aha: —Jaha'oamanija ida Deus kabadani anoki'iki hidakaba'i. ");
INSERT INTO padNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hari. Oniaroa, ajihi'aha ada Jesus. Adahana kaba'i binoki'aha ada Levi. Imposto gathaniva abono ada Levi. Imposto oniki ida jiniro arabo kaka'da'dini kabadani kaimoni. Imposto kagorania vithiki ada Levi. Jesua bini'aha: —Hora vaipohiha'a bana. ");
INSERT INTO padNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Oniaroa, gaa'aha ada Levi. Binahojaha'ihi ida kidibadani, kidinahina hahavi, Jesu-ra vaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hari. Levia bivahonariahihi ida 'bai karaho amonahani, va'ora kaboa'i'aha adani Jesus, kanori abono vaipohiki vihiki gorana vikhana. Vakadiania vahojaha adani imposto gathaniva abono vaipohiki, ija'ari vahoariha jaboni vavithiki vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hari. Farisio, judeus kaija'ari vaka'ojomo'iva abono khama va'ora vanokiha adani Jesus vi'baijabanaki. Va'ora vanokiha va'ora vakaja'oria'aha adani Jesus ipohina, va'ora vani'aha: —Niha avakhanimanija avi'baijabanaki imposto gathaniva abono vakadiania? Hojai jaharikia vakahojaiki vakadiania avi'baijabanaki a'oni jaboni. Akadihojai hipa'itxirihi hida a'baina hojai jaharikia vakahojaiki vakadiania — Jesus ipohina-ra va'ora vani'aha adani farisio. ");
INSERT INTO padNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesua bigathani'ihi ida vakadivarani: —Mijiko fori ohiki ho. Kavamoni vani fori hija ida hojai asohiriki. Vakavamonirikia ni-vanofiki ada mijiko. Vakavamoniki vani adani mijiko-ra vanofira. ");
INSERT INTO padNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Hojai asohikia vakahojaiki ni-va'ora obaranahaki. Hojai asohirikia vakahojaiki vani hadani va'ora obaranahara. Va'ora obaranahavini oamani hida hora rakhaja, vakava'ipahinika'oaja kaimoni ida vakadihojai asohiriki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hari. Jesu-ra vani'aha adani ija'ari: —João Batista ipohina ni-mahi hahavi vi'baiki. 'Bai-ra vavahojavini kaba'i vi'bairina vahojana Deu-ra vara vani'aka'oara kaimoni. Farisio vakadihojai onivani fori hija ida jaboni. Kadaipohi vakadihojai hirihi hida. Mahi hahavi vi'baiki, paha-ra vi'aviki jaboni adani. ");
INSERT INTO padNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesua bigathanihi ida vaathi: —Vakadiania ohojahaha'oadahana mani ida vi'bairina va'ora nahojarija. Maisa hojana oadani, ni-nahina va'ora honariaki adani kanori abono vi'bairina vahojana akarai kaihinikani kania. Maisa fori ohiki ho. Kanori abono ihinika kania vahojana vani fori vihira adani oipohina. Vi'baijahakiki adani kanori abono. Onivani fori vihira adani oipohina. ");
INSERT INTO padNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Khaki bana ida mahi vakadiania oakara'ona kamahini, oniaroa, ni-'bai havahani-ra vanofiki mahi hahavi Deu-ra vara vani'aka'oara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hari. Jesus va'ora ni'aha: —Vakava'ipahinika'oa bana ida avakadihojai 'bo'da mahija kodihojaia avakahojaivini. Ni-kabodihadihaki ida hojai 'bo'da kodihojai jahakia. Ni-ija'aria bianiki ida makari pitani pa'itxi makari ja'dini amonahaki kania, makari 'bo'da akarabajani kaimoni hini. Makari pitani aniaja vaha; makari ja'dini-ra najaharimanihi vaha. Akaramisihi hida makari pitani ja'dini, 'bira'ianahi ida makari 'bo'da. ");
INSERT INTO padNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hari. Asia vara niha ada Jesus: —Vakava'ipahinika'oa bana ida avakadihojai 'bo'da mahija kodihojaia avakahojaivini. Ni-kabodihadihaki ida hojai 'bo'da kodihojai jahakia. Ni-ija'aria binabaviki ida vinho ja'dini igitha asafini 'bo'da bavi hikia. Thoromananihi ida vinho ja'dini. 'Dakhaki ida baasafi kabavihi 'bo'da, ni-a'bitxajanaki. Ija'aria binabavija vaha ida vinho igitha asafini 'bo'da; aka'bararakhamamanihi vaha; kavithimamanihi vaha ida vinho. Ni-jahajanaki ida bavi. ");
INSERT INTO padNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ija'aria binabaviki ida vinho ja'dini igitha asafini ja'dini bavi hikia. ");
INSERT INTO padNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ija'aria bikaijo'ahi ida vinho 'bo'da, bi'avi'ihi, ni-binofijanaki ida vinho ja'dini. Nini vani ija'aria bivajahaja ida kidihojai 'bo'da, oniani ida bini'avini hija: “Jaha'oamanija ida vinho 'bo'da.” — niha ada Jesus. Jesus judeus kaija'ari vahojana 'bo'da-ra kavarajomivini vinho 'bo'da fori hini. ");
INSERT INTO padNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hari. Oniaroa, judeus kaija'ari vakadi'akoiri kamahini vani avikafianiribani'aha adani Jesus trigo kasiroinia. Vaadahana kaba'i, ipohina vihikia avara'birimi'ihi ida trigo bononi ja'dini, varisi'ihi, vaha'ihi ida trigo 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hari. Farisio vaipohirikia vanoki'ihi ida trigo bononi-ra varisivini, vani'aha ada Jesus: —Deus kava'isohihi jiriki ija'ari-ra honariavini hiki ija'ari bada nirihi aakoirina kamahini. Nahina mani ida Deus kava'isohihi jiriki-ra avanaabaravini hija? ");
INSERT INTO padNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesua bigathani'ihi ida vaathi: —A'onira vara oni'avini hiki ada akadija'ari avikhananavaki Davi kohana. Deus athi kapapirania hojaki ida Davi varani hina. 'Bo'dakari vavai'amiha adani Davi kohana kidipohi khama. ");
INSERT INTO padNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Deu-ra khai vani'avini kagorani kania avikhajakosi'aha adani Davi. Hari. Gora bodinia kahoja'iki ida pão sasidotxi ka'oa vakahaki kaimoni. Sasidotxi Deu-ra kanava'iga'imidiavini kihiki ida pão. Sasidotxi vaoniki adani Deus kabadani abono. Deus kava'isohihi jirikia bini'aha: “Sasidotxi ka'oa vakahaki kaimoni ida pão Deu-ra khai vani'avini kagorani bodinia kahojaki.” Nimania ida Deus kava'isohihi jiriki athini. Sasidotxi vihiriha adani Davi, kidipohi khama. Kaba'i, Davia bikaha'iki ida pão gora bodinia kahojaki, kidipohi-ra va'ora no'avini kihi'ihi jaboni. Ni-Deua bivajahariki ida pão-ra vakahavini. ");
INSERT INTO padNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hovani ija'ari hahavi vakadi'aajo ho. Hovani ka'oa oogaki ida badani hana hini jahaki ija'aria bada bini'aki kaimoni aakoirina kamahini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hari. Avakoirina kamahini hoariha okha'ianaha ada Jesus judeus kaija'ari Deu-ra vara vani'avini kagorania. Okhajakosi'aha va'ora ka'ojomo'i'aha adani ija'ari vajoroniki. Vahararana hojaha ada makhira sa'a kaka'aniajani akasakarabakosiki. ");
INSERT INTO padNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vahojaki jaboni adani judeus kaija'ari vaka'ojomo'iva abono vaipohiriki farisio vaipohiriki khama. Vavajaharihi ida Jesus ija'ari kavamoniki-ra anaihotavini avakoirina kamahini, oniani ida Jesu-ra vada vani'avini hihi. Bianaihotaha; Jesu-ra vakaihamahi'aha. Vanofiki ida Jesu-ra avanaathidanoararivini: —Inaabariki ida Deus kava'isohihi jiriki. Ni-biva'ahaki ida ija'ari kavamoniki-ra ianaihotavini aakoirina kamahini. ");
INSERT INTO padNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesua bioga'iki ida vakava'ibodivaranivini. Oniania, bini'aha ada makhira sa'a akasakarabakosiki: —Gaa'a onia! Gaamanani'aha ada makhira, Jesus kania khami'aha. ");
INSERT INTO padNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesus va'ora ni'aha adani farisio: —A'onira onana'dohiki bana ho. Hana hini badani koda ida Deus kava'isohihi jiriki haria va'ahavini hija aakoirina kamahini? Biva'ahamanija koda ida hoariha-ra aakodiavini? Ha'a. Biva'ahamanija koda ida hoariha-ra ava'adiravini? Iniani. Biva'ahamanija koda ida hoariha-ra aakava'ijoavini? Ha'a. Biva'ahamanija koda ida hoariha abinini? Iniani. Hana hini badani ida Deus kava'isohihi jiriki bihonariaja aakoirina kamahini bada ani'avini? — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Oniaroa, va'ora vada ni'aribani'aha ada Jesus. Makhira-ra ni'aha: —Isa'ani-ra akanavira'a! Sa'a-ra akanavira'aha, akaihota'ihi ida sa'a jorakia. ");
INSERT INTO padNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Oniaroa, vaihamahikaraho'aha adani farisio. Jesus makhira-ra anaihotavini mani ida vava'i najokojokoka'oani hija. Vaabono vara vakani'akhama'aha: —Ni-jahapa'itxiki ida ija'ari kavamoniki aihotani kabadanihia kabadanina aakoirina kamahini. Niha ani'a'aki koda ada Jesus? Abinina jahaki ada — vakhani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hari. Oniaroa, ajihi'aha ada Jesus. Arabo namahikia ogaimori'aha. Joma oadani hoja'aha Deu-ra vara ni'avini. ");
INSERT INTO padNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ka'afokajomani vani vagavagani va'ora baranaha'aha adani kidipohi kidiania vikhana. Va'ora nagathogatho'iki adani 12 makhira vaipohina, va'ora naonivini athi avavaadahaoniva abono. ");
INSERT INTO padNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Hi'adani 12 makhira vaonina Simão, André, Tiago, João, Filipe, Bartolomeu, Mateus, Tomé, Tiago hoariha, Simão o nacionalista, Judas Iscariotes vihiki. Judas Iscariotes va'ora kakodiaki bana adani Jesu-ra vanaabinivini-ra vanofiki. Jesus Simão-ra no'avini onii hoariha Pedroa, igamina ada André. Tiago hoariha Alfeu kaisai. ");
INSERT INTO padNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hari. Jesus va'ora nagathogatho'aha adani athi avavaadahaoniva abono. Naothinia avikharafoni'aha. Jesus ipohina vahoariha vakadiania vakaikahi'aha ibavi sohiriama'oki kania vahojaki adani. Ija'ari vaipohiki vajoroni'iki vakadiania. Judéia kaaraboni, Jerusalém sidaji hiki kaija'arini adani. Tiro sidaji, Sidom sidaji hiki kaija'arini adani vahoariha. 'Dako karaho vadinia hojaki ida sidaji 'bamiki. ");
INSERT INTO padNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesus kania vajoroni'aha adani ija'ari vaipohiki, mitha vani'aja kaimoni ida kidivarani. Vakavamonikia vanofiki ida Jesus va'ora anaihotavini. Vikha'aha adani ija'ari vakabajadiki jaboni. Bajadi va'ora najahariharibakhiaki adani. Jesus vani ada va'ora anaihota'aha. ");
INSERT INTO padNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Vakavamoniki hahavia vanofiki ida Jesu-ra vakadasavini avaihotara kaimoni. Jesus kabadani danoni mani ida ija'ari vakavamoniki-ra va'ora anaihotahahavivini hija. ");
INSERT INTO padNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hari. Jesus vada va'ora ni'aha adani ipohina, va'ora ni'aha: —A'onivani avakanahinariki a'oni. Deus avakadika'da'di hina mani ida a'onira kajoamoravini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A'onivani hidakaba'i avavai'amiki a'oni. Deus a'onira kajoamoraki bana a'oni. Deua bivahojaki ida nahina ahapini avakadimoni. A'onivani hidakaba'i avaasaraki a'oni. Deus a'onira kajoamoravini mani ida a'onira khai ni'aja bana. ");
INSERT INTO padNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Hora avanofijahakivini mani ida vahoariha a'onira vavajaharavini hija, a'onira vanofiriki, a'onira vani'avini onii jaharikia, a'onira vakanavaranihavini varani jaharikia. “Vajahariki adani Jesus ipohina.” A'onira vani'aki bana adani. Hovani ija'ari hahavi vakadi'aajo ho. Kodija'ari avihini mani ida Deus a'onira kajoamoravini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Avakadiania namithani kamahini, avava'ini jahajahani vahoja'a bana. Khai vakhani'a. Hojaki bana ida Deus kanahina jahaki kidiania nama, binaibavijahajora'iki avakadimoni hini. Hi'adani ija'ari a'onira vavajahariki, 'bo'dakari vakadija'ari avikhananavaki va'ora vanajaharihari'iki adani Deus athi namoniva abono kohana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Hari. Vara ni'ianaha ada Jesus: — Va'ora okaabaniki adani vahoariha vakanahina'ahapikiki avahararania vahojaki. A'onivani hidakaba'i avakadinahina ipohiki-ra avavahojaki a'oni. Jahariki bana ida avakadimoni. Avakanahinajanarini kamahini ni-khai avakhanijanaki. ");
INSERT INTO padNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A'onivani hidakaba'i ni-nahina-ra avakainamorihi. Jahariki bana ida avakadimoni. Avakanahinajanarini kamahini, vai'ami abani avihiki bana a'oni. A'onivani haha avakhaniki a'oni hidakaba'i. Jahariki ida avakadimoni bana. Mahi jahariki khani kamahini ni-khai avakhanijanarihi, avaasara'oamanija bana. ");
INSERT INTO padNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","A'onivani avakadihojai jaharini kaba'i vahoariha avakadihojai jahani-ra vakahibakhiaki. Jahariki bana ida avakadimoni hini. 'Bo'dakari vahojaki adani Deus athi namoniva abono vihina-ra vakahi'badaraki. Va'oaniaro jaboni vakadihojai jaharini kaba'i vahoariha vakadihojai jahani vakahibakhiaki adani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hari. Asia vara niha ada Jesus: —Mitha vani'ajahaki bana hida kodivarani. Va'ora vanofijahaki bana adani ija'ari a'onira vanofiriki. Va'ora kakodia bana adani ija'ari a'onira vanofipa'itxiriki. ");
INSERT INTO padNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Deu-ra vakanikharia bana vakadimoni, vani'a bana: “Deus, va'ora kajoamora bana adani haria vakaijorahavini-ra vanofiki. Va'ora kajoamora bana adani haria vanajaharihariki.” Deu-ra vani'a bana. ");
INSERT INTO padNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ija'ari i'ba'dani-ra kapatahi, iva'aha oni pitanija jaboni-ra kapatavini. Ija'aria bisaarihi ida kadakarahobi, iva'aha bana jaboni ida kadamakari-ra avikhavini. ");
INSERT INTO padNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ija'aria bikanikhariahi ida kadanahina, ino'a bana. Kadanahina-ra saariha, hari'a kadanahina joini-ra kanikharia. ");
INSERT INTO padNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Avanofihi ida vahoariha a'onira vanaibavijahajahakivini, oniania va'ora vanaibavijahajahaki jaboni bana. ");
INSERT INTO padNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ija'ari hahavi hojani hiki ida nofini hiki-ra nofivini. Ija'ari jaharikia jaboni binofivini ida nofini hiki. Deus kidinahina jahakia a'onira naabosivini-ra avanofihi; va'ora vanofijahaki bana jaboni adani ija'ari a'onira vanofiriki. ");
INSERT INTO padNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ija'ari hahavi hojani hiki ida kakodiani hiki-ra kakodiavini. Ija'ari jaharikia jaboni biakodiaki ida kakodiani hiki. Deus kidinahina jahakia a'onira naabosivini-ra avanofihi; va'ora vaakodia bana adani ija'ari a'onira vaakodiariki. ");
INSERT INTO padNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ija'ari kidinahina joiribanini-ra ogahi, hoariha-ra kanarihaivini hihi ida kidinahina. Ija'ari hahavi hojani hiki ida kidinahina najoiribanini hiki-ra kanarihaivini. Ija'ari jahariki jaboni ija'ari jahariki hoariha-ra kanarihaivini hiki ida kidinahina. Deus kidinahina jahakia a'onira naabosivini-ra avanofihi; vanajoiravini avarigavini kaba'i, va'ora vakanarihai bana jaboni avakadinahina. ");
INSERT INTO padNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hari. Nini vani onofija ida avakadihojai. Va'ora vanofijahaki bana adani a'onira vanofiriki. Va'ora vaakodia bana jaboni. Avakadinahina va'ora avakanarihaiha, hari'a vakanikharia ida avakadinahina avakanarihaihivini hiki joini. Nini vani onofija ida avakadihojai. Deus a'onira naabosiki bana a'oni kidinahina jahaki karahoa. Deus danoki nama hojaki kaisai avihiki a'oni. Deus jaboni va'ora kajoamoraki adani ija'ari hojai asohirikia vakahojaiki, va'ora kajoamoraki adani Deu-ra khai vani'ariki. ");
INSERT INTO padNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Avakadihojai nini vani-ra nofira ada Deus. Jahaki ada avakadiabi'i nama hojaki, ovari fori vihi'a bana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Hari. Jesus va'ora ni'aha adani vajoroniki: —Hari'a va'ora avanaathidanoarari bana adani vahoariha Jahari kabadania vakabadanina, avarigaravini oadani ida vanamonahavini vanamonaharavini. Va'ora avaranaathidanoaraririha; ni-Deus a'onira anaathidanoarariki bana jaboni. Hari'a vahoariha-ra vara vani'a: Avajahariki a'oni. Jahaki ida Ibavi Jaharika'oakia avarikhani. Nihi ida avakadivarani, Deus jaboni avajaharini-ra kahiki bana a'oni, a'onira karonaki ada jaboni bana Ibavi Jaharika'oakia. Vahoariha vakadihojai asohiriki-ra avarakava'i'birinihi; avakadihojai asohiriki-ra akava'i'biriniha ada Deus. ");
INSERT INTO padNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vahoariha-ra avano'ahi; Deus a'onira no'ahi jaboni. Nini vani nahina karahoa avagahinaja. Ni-Deua binapa'itxirihi ida a'onira no'avini hiki kaimoni, karaho oamani ida avagahinani kaimoni bana. Deua binaji'biniki bana ida avakadibavi avagahinani hikia bana aho'doararihi, ji'bini'ianahi ida avakadibavi, dai'ianahi ji'bini'ianahi. Avanapa'itxihi ida vahoariha-ra avano'avini hiki, Deua binapa'itxihi jaboni ida a'onira no'avini hiki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hari. Asia vara ni'aha ada Jesus: —Makhira kamaodorohakia ni-bikaabokaki ida hoariha kamaodorohaki-ra bananivini hagihia. Bikaijo'ahi; hodi bodinia avavoronijakosi'bamakhama'aha. ");
INSERT INTO padNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hari. Ni-ojomo'ihi abonoa bivaka'da'diki ada va'ora ka'ojomo'iki. Ojomo'ihi abonoa ni-aviga'iaki kaho ida va'ora ka'ojomo'ikia biogaki. A'diahi'ihi ida va'ora ka'ojomo'ivini, bona aviga'ihi ida va'ora ka'ojomo'iki biogaki. ");
INSERT INTO padNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hari. Asia mani vara niha ada Jesus: —Hogoi moramorani nokhoi 'ba'dania hojaki fori hiki ida hojai jahariki. Inokhoni 'ba'dania hojani oadani ida ava pitani karaho, hari'a ikaijo'a ida hogoi moramorani iigamini nokho 'ba'dania aniani. ");
INSERT INTO padNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Inokhoni 'ba'dania ava pitani karaho aniarini oadani, hari'a iigamini-ra ni'a: “Aajo, onofiki ida hogoi moramorani pitani pa'itxi-ra oanivini inokhoni 'ba'dania.” Ijahani-ra ikahi'badaraki i. Imiro'a iani oni ava pitani karaho inokhoni 'ba'dania hojaki. Ianivini naothinia, ikaabokaki ida vada inijahakini, oniani ida iigamini nokho 'ba'dania hogoi moramorani aniani-ra ikaabokavini hija. Bada ini'avini oadani ida hojai asohiriki, asohipa'itxirihi ida iigamini-ra inava'isohivini, bikava'ipahinija kaimoni ida kidihojai asohiriki. Imiro'a ikava'ipahini hida bana kadahojai, kadavarani asohiriki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hari. Vara ni'ianaha ada Jesus: —Ihi'ai avani fori hiki ida ija'ari. Jahahi ida ihi'ai avani, jahahi ida jaboni ihi'ai bononi. Jaharihi ida ihi'ai avani, jaharihi jaboni ida ihi'ai bononi. ");
INSERT INTO padNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ikaijo'ahi ida ihi'ai; iogahi ida ihi'ai jahani jaharini. Nini vani iogaja ida ihi'ai avani jahani jaharini. Ija'ari kahojai fori hiki ida ihi'ai bononi. Ija'ari kahojai-ra inokivini vani iogaja ida ija'ari jahani jaharini. Ni-hojai jaharikia kahojaiki ida ija'ari jahaki. ");
INSERT INTO padNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ija'ari va'ini bodinia hojaki ida va'i bodini vara nini jahaki. Jahahi hida kidiva'ibodivarani, oniani ida varani jahaki-ra vara vani'avini hija. Ija'ari hojai jaharikia kahojaiki va'ini bodinia hojaki ida va'i bodini vara nini jahariki. Jaharihi ida kidiva'ibodivarani, oniani ida varani jahariki-ra vara vani'avini hija. Ija'aria vara bivani'aki ida bikava'ibodivaraniki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Asia vara niha ada Jesus: —Oathi-ra avanaabaravini oadani, hari'a ka'da'dia hora vanaonibakhia. ");
INSERT INTO padNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","A'onira onava'isohivini hiki ida rajomi kavaranihi, nahina fori hiki ida. Kodiania khahi ida ija'ari, mitha bini'ahi ida oathi, binaabamani'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Gora kaaraki-ra namonahaki vani fori hija hida ija'ari. Bikhori'imidiahi ida hodi abihiaki, gora avani arokhojahani ibavini kaimoni a'daimaki. Gora a'diahini naothinia, ji'binini kama'da'ihi ida vaini kapahani. Vaini kapahani jorania bigathi'ihi ida gora avani, ni-ho'doho'doki ida gora. Abihiaki ida gora avani nami imani bodinia. ");
INSERT INTO padNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Hari. Gora-ra namonahaki vani fori hija jaboni ida ija'ari hoariha. Bikamithahi ida oathi, ni-binaaba'iki. Binamonahahi ida hodi abihiariki, arokhojahajahakirihi ida gora avani. Binaibavi'ihi ida gora avani hodi abihiariki bodinia. Gora a'diahini naothinia, ji'binini kama'da'ihi ida vaini kapahani. Vaini kapahani jorania bigathi'ihi ida gora avani, adari'ihi ihimika'oa'ihi ida gora — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hari hi'ihi ida Jesus ija'ari-ra ka'ojomo'ivini kavaranihi, okha'aha, Cafarnaum sidajia akhano'aha. ");
INSERT INTO padNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Cafarnaum sidajia hojaha ada Roma sidaji kaka'da'dini kasorarani. Kavamonikarahoki ada kidihonai abono, abinina amaakariki ada. Binakaidivaki ada kidihonai abono. ");
INSERT INTO padNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Oniaroa, Roma sidaji kaka'da'dini kasorarania bikamithahi ida Jesus varani hina. Va'ora ni'aha adani judeus kaija'ari vanava'isohiva abono: —Avikha Jesus kania mahija avibaranahavini. Vakanikharia bana kodihonai abono-ra anaihotara kaimoni — ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Oniaroa, va'ajihi'aha. Jesus kania avakhano'aha. Vakanikhariadanoki'aha: —Jesus, akadiania kha'a bana. Kavamoni karahoki ada sorara vakadika'da'di kahonai abono, abinihana amaakariki ada. ");
INSERT INTO padNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Akadija'ari hiriha ada sorara vakadika'da'di, kaba'i akadija'ari-ra nofijahakiha. Amonahani bivahonariahiki ida akadija'ari Deu-ra vara vani'avini kagorani akadimoni. Kidihonai abono ikajoamoravini jahaki — vakhaniha adani judeus kaija'ari vanava'isohiva abono. ");
INSERT INTO padNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hari. Okha'aha ada Jesus vakadiania. Jesua bianikhaki gora-ra vanamaakari'aha. Oniaroa, Roma sidaji kaka'da'dini kasorarani va'ora ni'aha adani kidiva'ahi: —Jesus kania avikha'a mahija oathia avanava'isohivini: “Jesus, ni-onofiki ida ira onadabavini kodiania ikhani. Ijahani fori ohirina mani ida ogorana io'oini-ra okaboa'iravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ivani ka'da'di i. Nahina ohirina mani ida kadania okhana-ra onofiravini hija. Vara ira oni'avini-ra okaipahiki ho. Ogorana iokharini kaba'i, napaja ihojani kaba'i, ihonaria bana ida kavamoni akara'oni, aihotara kaimoni ada kodihonai abono. ");
INSERT INTO padNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hovani jaboni onaabaki ida athi hora vaka'da'diki hora honariabakhiavini hiki. Va'ora ovaka'da'diki adani vahoariha, oathi-ra vanaababakhiaki adani. Okhana ohonariaha ada sorara, okhamaniha. Hida khana obaranahaha ada hoariha, khamaniha. Kodihonai abono-ra ohonariahi hihida badani-ra namonaha, binamonahamanihi. Oathi-ra vanaabaki adani va'ora ovaka'da'diki. Ivani jaboni ka'da'di i. Nahina-ra ihonariahi; iathini-ra naabahi. Kavamoni akara'oni-ra ihonariahi bana kodihonai abono kania, akara'omanihi bana.” ");
INSERT INTO padNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesua bikamitha'ihi ida sorara vakadika'da'di kavarani, bikava'ibodivaranikaraho'ihi. Roiribani'aha ada Jesus, ija'ari vaipohiki Jesu-ra vavaipohihaki-ra va'ora ni'aha. —Ni-okaraga'iaki kaho ada judeus kaija'ari hoarana hora kajari'dariki, hihada Roma sidaji kaka'da'dini kasorarani hora kajari'daravini fori hiki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hari. Avajoi'aha adani Roma sidaji kaka'da'dini kasorarani kava'ahi. Gorana vakaikahi'aha vanoki'aha ada honai abono aihota'ina. Jesu-ra kajari'daravini mani ida kidihonai abono anaihotana hija. ");
INSERT INTO padNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hari. Oniaroa, Roma sidaji kaka'da'dini kasorarani kava'ahi va'ajihina naothinia, avikha'aha adani Jesus, kidipohi khama. Ija'ari vaipohiki va'ora vavaipohiha'aha. Naim sidaji onikia avikhajabana'aha. ");
INSERT INTO padNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hari. Abini'aha ada imakhinava. Kaariha ida imakhinava kaamia. Kaariha bivahojaki isai hoarana ka'oa. Abini'iki ada kidisai. Naim sidaji kavasiribanini kaathania avamaakari'aha adani Jesus. Vamaakarina kaba'i Jesus va'ora nokiha adani aba'oi-ra vakaiba'iki vikhaonanina. Ai vavanihavini hiki ida aba'oi vaka'damaja kaimoni. Ija'ari vaipohiki va'ora vavaipohihaha adani aba'oi-ra vaka'damahaki. ");
INSERT INTO padNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Vakaikahi'aha adani Jesus kaariha kania, binakaidivamanihi ida gamo, bini'ahi: —Hari'a asarajana kaho. ");
INSERT INTO padNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Oniaroa, bikanamaakarihi ida aba'oi bavini, biakadasa'ihi. Avigaakosoa'aha adani aba'oi-ra vakaiba'iki. Bini'ahi ida imakhinava aba'ona: —Imakhinava, ira ohonariahi, gamamanani'a bana! ");
INSERT INTO padNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Gamamanani'aha ada imakhinava, vara ni'aha. Jesua bino'a'ianahi ida kaariha kidisaia. ");
INSERT INTO padNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hari. Imakhinava-ra vanokiki varapata'iki. Deu-ra khai vani'a'aha. Vakhani'aha: —Hidakaba'i akadiania kaikahi'iki hada Deus athi namoniva abono. Danoki ida kidibadani. Deua bikaronaki ada ovari va'ora kajoamorara kaimoni adani kidija'ari. ");
INSERT INTO padNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Oniani ida Judéia kaarabonia ibavi maakaria Jesus monina-ra akanarafarakhamaja. ");
INSERT INTO padNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Hari. João Batista ipohina vanava'isohi'aha, kaariha kaisai-ra anahoki'avini ada Jesus. João Batista bikamithahi ida vakadivarani, va'ora baranahaha adani kidipohi vi'bamiki kidiania vikhana. ");
INSERT INTO padNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","João Batista va'ora ni'aha: —Avikha'a bana akadika'da'di Jesus kania. Jesu-ra vara vani'a bana: “Anokhaki ada aihotahi abono Deua bikaronaki. Ivani aihotahi abono Deus ira karonaki i? Hoariha-ra anokhamania koda?” Vakhani bana — va'ora ni'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ai vihi'aha adani João Batista ipohina vi'bamiki. Jesus kania vakaikahi'aha. Vani'aha: —João Batista haria karonaki hari kadania, ira nana'dohiki ada: “Anokhaki ada aihotahi abono Deua bikaronaki. Ivani aihotahi abono Deus ira karonaki i? Hoariha-ra anokhamania koda?” — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Oniaroa, Jesus va'ora anaihota'aha adani vakavamoniki vaipohiki. Vakabajadiki vakadibajadi bihonaria'iki akara'o'ini. Vakamaodorohaki vaipohiki jaboni vanokho Jesua bianavagaha'iki. ");
INSERT INTO padNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Naothinia, Jesua bigathani'ihi ida vi'bamiki vakadina'dohi. Va'ora ni'aha: —João Batista kania avajoi'a. Vananamitha'a bana ida kodibadani danoki avanoki'iki, kodivarani avakamitha'iki jaboni mahija aihotahi abono ohina-ra ogavini. Ija'ari vakamaodorohaki vanokho-ra oanavagaha'iki ho. Ija'ari vakabaha katonorohaki okanajaha'iki vaadaha'iki. Asafi namani-ra najaharikia kakavamoniki ija'ari onajaha'iki jaboni. Ija'ari vamorobo kamokhihaki oakanavagaha'iki, athi-ra vakamitha'iki. Ija'ari vaabiniki oanahoki'iki. Ija'ari vakanahinariki-ra onanamithavini hiki ida Deus monina jahaki. ");
INSERT INTO padNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Deus va'ora kajoamoraki bana adani ija'ari oathi-ra vakajari'dariki — Jesus va'ora ni'aha adani vi'bamiki. ");
INSERT INTO padNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hari. João Batista ipohina vi'bamiki va'ajihina naothinia, Jesus va'ora vara ni'a'aha adani ija'ari vaipohiki vajoroniki. Kidivarani hi'aha ada João Batista. Jesus va'ora ni'aha: —Amasia hojana kari ada João Batista. Nahina mani ida João Batista kania avanavanavanahaja? Avarigaki ida João Batista mosori sirisirikia bikanadarahaki fori hirina. ");
INSERT INTO padNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Avanavanavanahavini kari avarigaki ada João Batista makhira kanahinaki fori hirina. Ni-João Batista bikaimahaki ida makari kaidivaki. Amasia ibaviriha ada makhira makari kaidivaki-ra kaimahaki. Arabo kaka'da'dini gorana vania hojara ada makhira makari kaidivaki-ra kaimahaki. Makhira kanahina'ahapikiki fori hiriha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","João Batista-ra avanavanavanahavini kari avarigaki ada Deus athi namoniva abono hina. Deus athi namoniva abono oamani. João Batista va'ora aradahaki adani Deus athi vanamoniva abono ija'ari vahoariha khama. Ovari miro'a vara bivani'aki ida Deus ija'ari-ra vaka'da'divini kavaranihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hari. Jesus va'ora vara ni'a'ianaha adani ija'ari vajoroniki. —Deus athi kapapirania hojaki ida João Batista varani hina Deua bini'aha ada kidisai: “Okaronaki bana ada oathi namoniva abono iviahania okhananavana va'ora nava'isohiki bana adani ija'ari vakadimahi-ra vanasohivini ikaikahini viahania.” Nihi ida João Batista varani hina Deus athi kapapirania hojaki. ");
INSERT INTO padNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Hari. Asia vara ni'aha ada Jesus: —Akadija'ari avikhananavakia ni-avigahahaviki ida Deus ija'ari-ra vaka'da'divini kavaranihi. Ni-avigaki ida niha ninini Deu-ra vagathanivini vakadika'da'di kaimoni hina. João Batista vania biogaja ida, oniani ida João Batista aagahai akadija'ari avikhananavaki vakadi'ogahai aradavini hija. Kaba'i, ni-João Batista binokiki ida mahi vara bivani'ajoraki. Ni-kama'da'iaki kaho ida Deus kania ija'ari vaabono gahinai vanihavini vakadika'da'di hira kaimoni. João Batista naothia ija'aria vagathaniki bana ada Deus vakadika'da'di hina, oniani ida vakadimahi nasohini hija. Ija'ari nahina hirini kaba'i, kidimahi jahania biaradahaki ida João Batista kamahi jahani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ija'ari vaipohiki, imposto gathaniva abono khama vajoronikia mitha vani'a'ihi ida Jesus kavarani. Va'oaniaroa vakamitha'imidia'iki ida João Batista kavarani. João Batista kavarani hiki ida badani asohiki Deua binofiki. Athi-ra vanaabavini-ra vanofivini, oniani ida João Batista va'ora kanavini hija. ");
INSERT INTO padNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vahoariha vanofirihi ida João Batista va'ora kanavini. Va'oaniaro farisio, vahoariha judeus kaija'ari vaka'ojomo'iva abono. Vakhanimanira adani Deua binofiki-ra vakajoniki. ");
INSERT INTO padNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hari. Jesus vara va'ora ni'a'ianaha adani ija'ari vajoroniki: —Va'ora okavarajomiki adani ija'ari hahavi hidakaba'i vahokiki. ");
INSERT INTO padNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Isai vakasivanahaki fori vihiki hadani ija'ari. Ija'ari vajoroniki kania vakasivanahaki adani isai. Vaabono vakabodi'barahararahakhamaki adani isai: “Akadikasivanahi ida akarai kaihinikani. A'ithohahi; ni-avikhajo'iki. Akadikasivanahi hoariha ida ija'ari abini'iki. Akaasarahi ida aba'oi, ni-avaasarajabana'iki. Ni-avavajahaki ida khai akhanina, ni-avavajahaki jaboni ida ava'i mokara nini.” Vakhaniha adani isai vakasivanahaki. Jesus va'ora ni'aha: —Avakhanini vani isai kasivanahi-ra nofiriki fori avihija. Ni-avanofipa'itxiki ida Deus athi-ra avanaabavini. ");
INSERT INTO padNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","João Batista kha'aha avakadiania, ni-bihaki ida 'bai mahi hahavi. Ni-bi'aviki jaboni ida vinho. Kidihojai avanokiha; avani'aha: “Kabajadiki ada João Batista.” ");
INSERT INTO padNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Okha'ihi avakadiania, kodihojai fori hirihi ida kidihojai. Hovani ohaki ida 'bai, o'aviki jaboni ida vinho. Hora avanokihi, ni-hora avanofiki. Nimania ida hora avakanavaranihavini. “Vada vani'a o hi'o ko'bai nofiki o, hi'o vinho-ra nofiki o jaboni. Kidiva'ahi vihiki adani imposto gathaniva abono, Jahari kabadani-ra bada vani'aki-ra nofiki o jaboni.” Nimania ida hora avakanavaranihavini. ");
INSERT INTO padNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hari. Ija'aria bikajari'darihi ida Deus ka'ogahai jahani; sohika'oani biogahi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hari. Simãoa bikaboa'iha ada Jesus kidiania 'baira kaimoni. Farisio ada Simão. Farisio vaoniki vavajahaki ida vakadija'ari avikhananavaki vakadihojai. Oniaroa, Simão gorana okha'aha ada Jesus. Okhajakosiha, vithiha, vi'bai'aha. ");
INSERT INTO padNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sidajia hojaki ida gamo. Kamakhirarini kaba'i makhira ipohikia kabadanibakhiaki ida. Asohiri'oamanija ida gamo kahojai. Hari. Gamoa bikamithahi ida Jesus varani hina, Simão gorana 'baina. Okhahi, biavikha'ihi ida misai bavini ji'biniki. ");
INSERT INTO padNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Okhajakosihi, Jesus kaida kaikahi'ihi. Jesus 'dama ka'dihania kabajo'okhonarari'ihi, asara'ihi. Kidihojai asohirikia va'ini bianaipahihivini mani ida naasarani hija. Bikana'bahi ida Jesus 'dama nokhoni a'bania, bikanajoha'ihi ida 'dama ka'da'dini kaafania. Bikaramosihi ida Jesus 'dama, biakamisai'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hari. Simãoa binokihi ida gamo Jesu-ra kamisaivini, bikava'ibodivaranihi ida gamo. Simão abono-ra ni'aha: —Asohiri'oamanija ida gamo kahojai. Ni-Jesua biogaki ida gamo hojai asohirikia kahojaini. Gamo kahojai asohiriki-ra ogara vaha; ni-abono-ra khai vani'aki vaha gamoa bikamisaivini. Jesus gamo kabadani-ra ogaravini mani ida Deus athi namoniva abono hina okajari'davini hija — abono-ra ni'aha ada Simão. ");
INSERT INTO padNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Oniaroa, Jesua bini'aha ada Simão: —Simão, vara ira oni'avini-ra onofiki bana ho. —Hai — niha ada Simão. ");
INSERT INTO padNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hari. Jesua bini'aha rajomi kavaranihia: —Makhira kajiniro'ahapikiki kania jiniro-ra varihaha adani makhira vi'bamiki. Hoariha birihahi ida jiniro prata amonahaki karaho 500 hiki kaidivani. Hoariha birihahi ida jiniro prata amonahaki pa'itxi 50 hiki kaidivani. ");
INSERT INTO padNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ihimi'ihi ida jiniro varihaki, ni-nahina-ra vavahojajanaki vakadirihai-ra vanaabosivini kaimoni. Va'ora kanarihaiki va'ora va'adimani'aha, va'ora ni'aha: “Ni-onofiki ida jiniro a'onira okanarihaivini hiki aabosini. Ni-nahina abosiriki hojajanaki.” Va'ora ni'aha. Oniaroa, Jesua bini'aha ada Simão: —Simão, hana hina vania binofikarahora ada va'ora kanarihaiki? Hana hina vania binofipa'itxira ada va'ora kanarihaiki? ");
INSERT INTO padNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Jiniro karaho-ra rihakia vahabini binofikarahoki ada va'ora kanarihaiki — niha ada Simão. —Ka'oa oamani ida ini'aki — Jesua bini'aha. ");
INSERT INTO padNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hari. Roiribani'aha ada Jesus, gamo-ra vada ni'a'aha, Simão-ra ni'aha: —Simão, vada ini'a hida gamo. Jiniro karaho fori hiki hida gamo kabadani asohiriki ipohiki. Kidihojai asohiriki ipohiki ona'biravini mani ida hora nofijahakivini hija. Akadihojai oamani ida kaikahiki-ra paha ano'avini 'damani-ra kosokovini kaimoni. Igorania okaikahihi, ni-paha hora ino'aki o'dama kosokoani kaimoni. Gamo vania bikosoko'ihi ida o'dama nokhoni a'bania, bikanajoha'ihi ka'da'dini kaafania. ");
INSERT INTO padNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Akadihojai hiki ida gora kaka'da'dinia biramosivini ida kaikahiki. Akadihojai hini kaba'i, ni-hora iramosiki okaikahina. Gamo vani ida o'dama-ra karamosiha'oadaha'ihi kaikahi'ini. ");
INSERT INTO padNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Akadihojai ida gora kaka'da'dinia bikavamisaihavini ada 'baiki kidiania. Ni-hora misaia ino'aki o'da'di-ra oakamisaivini kaimoni. Gamo vani ida o'dama-ra kavamisaihahi misai kaidivakia. ");
INSERT INTO padNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Simão, ira onava'isohivini hiki bana ho, kidihojai asohiriki ipohiki ona'biravini mani ida hora nofikarahovini hija. Ija'ari hoariha kahojai asohiriki ipohiriki-ra ona'biravini mani ida hora nofipa'itxivini hija — Simão-ra ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hari. Gamo-ra ni'aha ada Jesus: —Kadahojai asohiriki-ra ona'bira'iki ho. ");
INSERT INTO padNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Vahoariha vavithijabanaki vakadiania vaabono vani'aha: —Jesua bikaabokamanija koda ida gamo kahojai asohiriki-ra na'biravini? Deus ka'oa bikaabokaki ida hojai asohiriki na'birani. ");
INSERT INTO padNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesua bini'ahi ida gamo: —Hora ikajari'daravini mani ida Deus ira akava'ijoavini hija. Iva'ini jahajahani, okha'a bana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hari. Oniaroa, ibavi ipohikia avaadahaoni'aha adani Jesus, vara bivani'avini ida Deus monina jahaki, ija'ari-ra nava'isohi'aha Deua vaka'da'dira kaimoni. Jesus ipohina 12 vihiki vaipohina kidiania avikha'iki. ");
INSERT INTO padNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Avaadahaonijabanaki adani gamo vaipohiriki jaboni Jesus vakadiania. Vaonina Maria Madalena, Joana, Susana vihiki. Jesus va'ora anaihota'iki adani gamo, oniani ida vavaipohihavini hija. Gamo vakabajadiki Jesus va'ora najaha'iki. Maria Madalena, bajadi vaipohina 7 vihikia vagathi'iki ida. Jesua bihonaria'ihi ida bajadi akara'o'ini. Joana kamakhira onina Cuza. Cuza Iroji kahonai abono ada. Iroji arabo kaka'da'dini ada. Cuza biakadava'aki ida Iroji kanahina. Jesus va'ora ka'ojomo'ivini oadani adani ija'ari, Susana Jesu-ra vakaijahitaki, gamo vahoariha jaboni Jesu-ra vaakodiaki. Vakadinahina pa'itxi, jiniro, 'bai hikia Jesu-ra vaakodia'aha. ");
INSERT INTO padNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hari. Oniaroa, ija'ari vaipohiki vikhaki Jesus kania. Sidaji ipohiki kaija'arinia vanofiki vanokivini ada Jesus. Oniaroa, vajoroniha, va'ora ka'ojomo'i'aha adani ija'ari vahojaki. Rajomi kavaranihia va'ora vara ni'a'aha: ");
INSERT INTO padNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Siroia okhaha ada makhira binatxiotxiohi ida trigo 'ba'dani. Hagihi vadinia vararahi ida 'ba'dani hoarahanana. Ija'aria vakada'aha'aha'ihi ida trigo 'ba'dani, ni-mova'iki. Avigariha adani igitha, vitxagatxaga'ihi jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ja'di namania vararahi ida 'ba'dani hoariha. Foraki ida nami. Movani kama'dani vani ara'okho'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hogoi kania vararahi ida 'ba'dani hoariha. Mova'ihi ida jaboni hogoi, rakhajahi-ra najahari'ihi, ni-bono'iki. ");
INSERT INTO padNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Arabo jahakia vararahi ida 'ba'dani hoariha. Movahi, avijavahi, bono'ihi. Aipohi'ihi ida trigo 'ba'dani. Trigo avani hoarahanana 'ba'dani ipohini 100. Avakamithavini avanofihi; mitha vani'ajahaki hida oathi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hari. Jesus ipohina vanana'dohi'aha: —Ni-aogajahakiki ida rajomi kavaranihi kadavarani hiki. ");
INSERT INTO padNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus va'ora ni'aha: —Deua binofiki ida avarigavini, oniani ida Deus ka'da'di hina kavaranihia a'onira onanamithajahakivini hija. Ija'ari vahoariha ni-avigavini vanofiki ida varani Deus va'ora vaka'da'divini. Vakadiania vara ovani'aki ida rajomi kavaranihi, avigajorakiria kaimoni hida kodivarani. Oathi-ra mitha vani'avini kaba'i, ni-nahina nini avigaki. ");
INSERT INTO padNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Oniaroa, Jesus va'ora nanamithavini hi'ihi ida rajomi kavaranihi. —Trigo 'ba'dani txiotxioni vani fori hija ida Deus athi kavaranihi. Deus athi fori hiki ida trigo 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hagihia vararahi ida trigo 'ba'dani. Igitha vitxagatxagahahavi'ihi Onivani fori hini ija'ari vahoarahanana vakamithaja ida Deus athi. Hari. Oniaroa, khaki ada Jahari Deus athi-ra anihavini va'ini bodinia, vakajari'daja kaimoni, oniani ida Deus va'ora akava'ijoaravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ja'di namania vararahi ida trigo 'ba'dani hoariha. Kanamini odorini movajoraki'ihi. 'Damani abohani abihiarini mani ida anara'okhoni hija. Movani kama'dani vani ara'okho'ihi. Onivani fori hini ija'ari vahoariha Deus athi-ra vakamithaki. Vanofihi, khai vakhanimaniha. Mahi ipohiriki vani khai vani'aja ida Deus athi. Jorakia vakajari'da'ihi. Kama'da'ihi ida Jahari va'ora kaboroborovini, oniani ida Deus athi-ra vakava'ipahinivini hija. ");
INSERT INTO padNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hogoi 'damania vararahi ida trigo 'ba'dani hoariha. Hogoia binajaharihi, bonohi, ni-a'di'iki ida trigo bononi. Onivani fori vihira adani ija'ari vahoariha Deus athi-ra vakamithaki. Vakava'ibodivaraniha'oadahahi ida vakadi'bai-ra vanako'dihavini, vakadinahina-ra vakapavakarihavini, vakadibadani hiki. Vakadiva'ikhaiini 'badara vava'i biakanara'banahanakhamavini. Jiniro-ra vanofikarahovini mani ida Deus athi-ra vanofijahakiravini hija, oniani ida Deus athi-ra vanaabaravini hija jaboni. Onivani fori hija ida arabo rakhajahani bonorini. ");
INSERT INTO padNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hari. Arabo jahakia makhira binatxiotxiohi ida trigo 'ba'dani hoariha. Movahi, karaho'ihi, bono'ihi. Aipohi'ihi ida 'ba'dani. Trigo avani bononi 'ba'dani ipohini 100. Onivani fori hini vahoariha vakamithaja ida Deus athi. Vava'i bodinia vanaibavijahaki ida. Deu-ra vanofivini mani ida athi vanaabajahakivini hija jaboni. Ni-vakava'ipahiniki ida Deus athi, oniani ida vakadihojai jahaki ana'ba'dini hija — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hari. Jesus va'ora vara ni'a'ianavini hihi hida rajomi kavaranihi hoariha. Jesus va'ora ni'aha: —Kodivarani fori hiki ida lamparina vagani. Lamparina-ra anaha'dihi, ni-si'aha akaasiaki kabodinia anahojaki ida lamparina, ni-cama kanabo'ania anahojaki. Gora bodini nama vania anahojahi ida lamparina vagaja kaimoni ida gora bodini. Ija'ari avi'oikia vanokiki ida gora bodini vagani. ");
INSERT INTO padNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hidakaba'i ahojaki ida ija'ari kava'ibodivarani. Khaki ida mahi kodivarania binanokiaki bana ida ija'ari kava'ibodivarani, nahina hoarani ahojajanaria kaimoni. Vagani kania hojani fori hiki ida. ");
INSERT INTO padNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mitha vani'ajahaki bana hida kodivarani. Mitha avakhanijahakihi; avarigajahakihi hida avariga'iariki. Oathi-ra avanaabahi; Deus a'onira kakodiahi avarigajahakija kaimoni hida kodivarani. Oathi-ra avanaabarihi; avarakava'i'birinihi ida pa'itxi avariga'iki — va'ora ni'a'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hari. Oniaroa, Jesus kania vikhamai'aha adani kidiamia, kidikajo'o vihiki. Ija'ari vaipohiki vahararana hojaha ada Jesus, oniani ida vanamaakariravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oniaroa, ija'aria binava'isohi'aha ada Jesus: —Adani gora baninija vahojaha kadamia, kadakajo'o vihiki, ira vara vani'avini-ra vanofiki. ");
INSERT INTO padNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hari. Jesus va'ora ni'aha adani ija'ari hahavi vajoroniki: —Ija'ari Deus athi-ra vakamithajahakihi, vanaabajahakihi jaboni; kodiamia, oigamina fori vihiki adani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hari. Mahi hoariha, Galiléia ka'dakoni vadinia vahojaha adani Jesus kidipohi khama. Vaki'dama'aha kanava kabodinia. Va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","—Aakakafiani'ava. 'Dako pitanija Jesu-ra avakavikafiani'aha adani kidipohi. Avakakafianina kaba'i, vadi'aha ada Jesus. Sirisiriki danoki kama'da'ihi. Komini kana'bahakia biakapahakaraho'ihi ida kanava, ka'biri'biri'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oniaroa, kidipohia vanamaakari'aha ada Jesus, vakananokiahi'aha vani'aha: —Jesus, Jesus, aahidana'iki bana hari! Nokho afora'aha. Gama'aha, bikaabani'ihi ida sirisiriki, komini kihiki. Jesua bini'ahi: —Radaha'a! Radaha'ihi ida sirisiriki, karadaha'ihi jaboni ida komini kana'bahaki. ");
INSERT INTO padNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oniaroa, kidipohi-ra va'ora ni'aha: —Nahina mani ida Deus a'onira akadava'avini-ra avakajari'davini hija? Sirisiriki komini kihiki jorakia karadahani mani ida va'ora naimahidaja. Vakava'ibodivaranikaraho'aha. Oniaroa, vaabono vakani'akhama'aha: —Makhira ka'oa hiriha hada? Ni-anoki'iaki kaho ida ija'ari hoariha ovari fori hiki sirisiriki, komini kihikia athi bikamithaki — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hari. Galiléia ka'dakonia avikafianiha adani Jesus. Gerasa kaarabonia avako'omisi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Vigaimoriha. Makhira kabajadiki Jesu-ra karagarariha'aha. 'Dama kania ibaviki ada makhira. Badara ipohiki ni-ibaviki gora bodinia. Barobarona adahaki ada makhira. Bajadia bigathibakhiaki ada. Bikana'bararaharahabakhiamanihi hida corrente sa'a, 'dama kihiki kodabohabakhiani kihiki, sidaji kaija'arinia vanaahobakhiavini ada. Bajadia biavikhabakhiaki ada amasia. Hari. Kabajadikia binokiha ada Jesus, bodi'baraha'aha, kajo'atharari'aha Jesus viaha. Jesua bini'aha: —Bajadi, akara'o'a! Kabajadikia bini'a'aha bodi'barahana: —Jesus, nahina hida kodiania inofija? Ivani Deus danoki nama hojaki kaisai i. Hari'a jaharikia haria arakha bana! ");
INSERT INTO padNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesua binana'dohiha ada makhira kabajadiki: —Nahina ionija? Bigathanihi ida Jesus athi: —Bajadi vaipohiki hora vagathivini mani ida ija'ari hora vanaonivini hija Îpohikia. ");
INSERT INTO padNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Oniaroa, bajadia vakanikhariaha ada Jesus: —Hari'a haria karona Ibavi Jaharika'oakia aokhana — Jesu-ra vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hari. Arabo namahiki maakarinia vahojamaniha adani hirari vaipohiki vi'baiki. Bajadi Jesu-ra vakanikharia'aha: —Haria karona'a hirari vakadiania mahija haria vavaadaha'avini. —Vaadaha'a! — Jesus va'ora ni'aha adani bajadi. ");
INSERT INTO padNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hari. Makhira kania vakara'o'aha adani bajadi, hirari-ra vagathi'aha. Vaki'darahaha'aha, avikharafoni'aha, arabo a'domarariki kania avaki'dafafoni'aha, avahidana'aha. ");
INSERT INTO padNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Oniaroa, vaofini'aha adani makhira hirari-ra avakadava'aki, aviga'aha. Ija'ari vaibavia avakhano'aha, va'ora vakanamoni'aha hirari vapohimaja'ina. ");
INSERT INTO padNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Oniaroa, ija'ari vaipohiki moni kamithava va'ora vanavanavanaha'aha adani hirari vapohimaja'iki. Jesus kania avikha'aha. Vanoki'aha ada makhira kabajadijanarina. Jahana vani vanoki'aha. Vithina, kamakari'ina jaboni vanoki'aha. Bajadi ai vihi'ina naothinia ni-kabajadijanaki. Vakava'ibodivaranikaraho'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hirari avakadava'ava abono va'ora vani'aha adani vavanavanahaki: —Anoki'iki ada Jesus makhira kabajadiki-ra anaihota'avini. ");
INSERT INTO padNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Oniaroa, Jesu-ra vifini'aha adani Gerasa kaaraboni kaija'arini moni-ra vakamitha'iki. Vani'aha: —Ajihi'a bana akadiaraboa! ");
INSERT INTO padNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hari. Ajihi'aha ada Jesus. Ki'damana kaba'i kabajadijanariki Jesu-ra kanikhariadanoki'aha: —Onofiki kadania ookhana! Jesua bini'aha: ");
INSERT INTO padNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Iniani. Igorania ajoi'a bana mahija kadaija'ari-ra va'ora vara ini'avini hini hida Deus ira kajoamoravini, Deus ira va'adivini. Oniaroa, ajihi'aha ada makhira, sidaji kaija'arini-ra va'ora kanamonivini hi'ihi ida Jesua bikajoamora'avini. ");
INSERT INTO padNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hari. Oniaroa, avakajoifianiha adani Jesus kidipohi khama. Avako'omisiha, vahojamaniha adani ija'ari vâipohiki Jesu-ra vanokhavini. Khai vani'a'ihi ida Jesus vakajoifianina. ");
INSERT INTO padNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oniaroa, Jesus kania kha'aha ada makhira Jairo oniki. Judeus kaija'ari Deu-ra vara vani'avini kagorani akadava'ava abono ada Jairo. Va'i bodinia abono-ra ni'aha: —Ka'da'di oamani ada Jesus — oniani ida Jesus viaha nakajo'athararina hija. ");
INSERT INTO padNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Oniaroa, Jesu-ra kanikharia'aha ada Jairo: —Onofiki bana ida ogorana iokhani. Kodisai kavamonikarahoki. Abinihani amaakariki ida. Hoarani oamani ida kodisai. Kabadarani 12 hiki ida ipohini — niha ada Jairo. Oniaroa, ai vihi'aha adani Jairo Jesus khama. Vaadahana kaba'i ija'ari vâipohiki Jesu-ra vaka'dokho'dokhorisahakhamaki. ");
INSERT INTO padNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hari. Ija'ari vahararana hojajabanaki ida gamo kavamoniki. 12 badara ipohini amani aforarini hojaki ida gamo. Mijiko vaipohikia vanaihabakhiavini kaba'i, ni-ahajanipa'itxiki ida gamo. Bivaihimi'imarinihi ida kidijiniro. ");
INSERT INTO padNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Oniaroa, Jesus kaida-ra kanamaakari'ihi. Vahoariha vanokiravini kaba'i, bikadasahi ida Jesus kakarahobi ihini. Afora'ihi ida amani. ");
INSERT INTO padNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Oniaroa, Jesus va'ora nana'dohi'aha adani ija'ari: —Hana hini mani ida kodikarahobi-ra kadasaja? —Ni-aogaki, ni-ira akadasarihi — vakhanihahavi'aha. Oniaroa, Pedroa bini'aha: —Jesus, ija'ari vâipohiki vahararana ihojaki i. Ira vaka'dokho'dokhohahaviki adani — niha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Oniaroa, Jesus va'ora ni'aha: —Ija'ari hora kadasa'iki ho. Oogaki ida odanona ija'ari-ra anaihota'avini. ");
INSERT INTO padNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ni-gamoa bikaabokajanaki ida aihota'ini-ra anahojavini. Jesua bikaja'oriaki abononi vanihavini mani ida naimahidani hija. Tharararani mani ida na'bisonini hija Jesus viaha. Ija'ari vaipohiki vaviaha Jesu-ra ni'a'ihi: —Badara ipohiki vani okavamonija. Ira okajari'daravini mani ida hora ianaihotavini-ra oogavini hija, oniani ida kadakarahobi-ra okadasavini hija. Ojaha'iki ho — nihi ida gamo. ");
INSERT INTO padNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hari. Jesua bini'a'ihi: —Kodisai, hora ikajari'daravini mani ida ira oanaihotavini hi'ia. Adaha'a, iva'ini jahajaha'ini. ");
INSERT INTO padNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Hari. Oniaroa, vara nina kaba'i ada Jesus, Jairo kahonai abono akhano'aha. Bini'aha ada Jairo: —Ida abini'ihi kadaisai. Ni-nahina kaimoni iavikhajanariha o Jesus — Jairo-ra ni'a'aha. ");
INSERT INTO padNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesua bikamithahi ida vakadivarani. Oniaroa, Jairo-ra ni'aha: —Hari'a ofini. Hari'a jari'da. Ahokiki bana ida kadaisai — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hari. Avikha'ianaha adani Jesus. Jairo gorana vakaikahi'aha. Jesua binofirihi ida ija'ari vaipohiki gora avi'oina kidiania. Avi'oiki adani Pedro, João, Tiago vihiki. Hojaki ada isai kaabi'i, hojaki ida isai kaamia jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Va'ora vanokiha adani ija'ari isai aba'oni-ra vavaasaraki. Jesua biogaki ida isai-ra anahokivini, oniani ida va'ora ni'avini hija: —Hari'a vaasara. Abinirihi oni isai, vadika'oaki oni. ");
INSERT INTO padNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jesus athi-ra vakajari'daki, oniani ida Jesu-ra vakanahahanihavini hija. Abinika'oani avigaki ida isai. ");
INSERT INTO padNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hari. Jesua binamaakari'ihi ida isai aba'oni, biagathi'ihi ida sa'ani, athi 'barakia bini'a'ihi: —Isai, gama'a! ");
INSERT INTO padNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oniaroa, jorakia ahoki'ihi, gama'ihi ida isai. Adaha'ianahi, jaha'ini. Isai kaamia-ra va'ora ni'aha ada Jesus: —Isai-ra 'baia vano'a'a bana. ");
INSERT INTO padNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Oniaroa, isai kaabi'i, kidiamia hikia vakava'ibodivarani'ihi ida isai-ra anahoki'avini. Oniania, Jesus va'ora kaabani'aha: —Hari'a bana vahoariha vakadiania vananamitha'a bana hida kodibadani. ");
INSERT INTO padNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Hari. Oniaroa, Jesus va'ora baranahaha adani 12 vihiki vaipohina kidiania. Va'ora ni'aha: —A'onira ono'aki bana ho odanona. Ija'ari vakabajadiki-ra avanokihi; bajadi-ra vahonaria bana akara'oja kaimoni. Ija'ari vakavamoniki-ra va'ora avanokihi; va'ora avanaihota bana. Deus a'onira kakodiavini mani bana ida va'ora avaranaihotavini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","3","Hari. Jesus va'ora ni'aha: —A'onira okaronaki ho. Hahavi-ra va'ora vara avani'avini hiki bana ida moni Deus akadika'da'di hina. Va'ora avanaihotaha bana adani ija'ari vakavamoniki jaboni. Avadairini vani avikha'a bana. Hari'a avavikha ida ava avaabononi avanadadavini kaimoni. Hari'a avavikha ida 'bai bavini, 'bai, jiniro hiki. Hari'a avavikha ida avakadimakari odoki hoariha avakadi'abosihi kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sidaji kaija'arini a'onira vanofihi; vahoja'a bana. Sidaji ava'ajihirini oadani gora hoarania vahoja'a bana mahija avi'baivini, avavadini jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sidaji kaija'arini a'onira vanofiriha; jorakia bana va'ajihi. Ava'ajihini viahania vana'dara'dara bana oni khomakhomani avakadisandália hojaki. Ija'ari Deus athi-ra vakajoniki-ra avakavarajomivini ida sandália-ra avakana'dara'daravini — va'ora nava'isohi'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hari. Oniaroa, ai vihi'aha adani Jesus ipohina, sidaji itxani avaadahaoni'aha, ija'ari-ra va'ora vakanamonivini hi'ihi ida Jesus monina jahaki. Va'ora avanaihotabakhiaha adani vakavamoniki vaibavia vahojaki. ");
INSERT INTO padNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hari. Galiléia kaaraboni kaka'da'dini ada Iroji oniki. Irojia bikamitha'ihi ida Jesus kabadani danoki varani hini. Oniaroa, va'i kidakida'aha. Vakhani'aha adani ija'ari vaipohiriki: —Ada ahoki'aha João Batista kohana. ");
INSERT INTO padNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Vahoariha vani'avini Elias kohana ahoki'ina abono-ra nanokia'iki. Vahoariha Deus athi namoniva abono okhananavaki kohana ahoki'ina hina vakahi'aha. Vakadivarani Iroji va'i-ra nakidakida'iki. ");
INSERT INTO padNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Oniania bini'aha: —Okavahonariahi'iki ida João Batista kohana ka'da'di aka'boani. Hana hina mani makhira ada? Kidibadani danoki varani hini okamithabakhiaki. Oniaroa, Irojia binofiki binokivini ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hari. Oniaroa, Jesus kania vajoi'aha adani kidipohi Jesus athi-ra avavaadahaoni'iki. Vananamithavini hihi ida vaadahana bada vakhani'ina. Oniaroa, Jesus va'ora avikha'aha adani kidipohi ka'oa. Betsaida sidaji maakarini avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hari. Ija'ari vaipohikia avigaki ida ibavi vavahojaki, oniaroa, avikasiaga'aha. Vakadiania avakhano'aha, Jesus va'ora gathani'aha. Vara va'ora ni'avini hiki ida moni jahaki ka'da'di hina ada Deus. Ija'ari vakavamoniki-ra va'ora anaihota'aha jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hari. Vajomini'aha, vikha'aha adani 12 ipohina, Jesu-ra vani'a'aha: —Kagorarihi bana hida ibavi. Kamahijanarihi. Va'ora honaria bana ai vihi'ina mahija ija'ari vahoariha vagorana avikhavini, 'bai-ra vakapavakarihavini, vada ibavini-ra vanako'dihavini jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Oniaroa, Jesus va'ora ni'aha: —Iniani. A'onivani 'baia va'ora vano'a. Oniaroa, vagathani'ihi ida Jesus athi: —Pão sa'ai kahoarani kihiki oavani-ra akavahojaja. Abaisana 'bamiki oavani-ra jaboni avahojaja. Aokhamaniki koda hari 'bai-ra akapavakarihavini ija'ari vaipohiki vakadimoni? — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Makhira 5 mil vihiki vahabini adani vahojaki. Jesus va'ora honaria'aha adani kidipohi: —Va'ora vanajoronionaha'a bana adani ija'ari. Vavithina va'ora vahonaria bana. Va'ora vanajoroni va'oani 50 vihiki vahabini vaipohina afonana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hari. Jesus ipohina va'ora vahonaria'aha vavithionahana adani ija'ari hahavi 50 vihiki vaipohina. ");
INSERT INTO padNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Oniaroa, Jesua bigathani'aha ada abaisana 'bamiki, pão sa'ai kahoarani kihiki, nama-ra vada ni'amanani'aha, Deu-ra vara ni'a'aha: —Deus, ivani ijahaki i. 'Baia haria ino'aki i — niha ada Jesus. Naothinia, bikanapitahataha'ihi ida pão, abaisana 'bamiki hiki. Kidipohi-ra va'ora no'avini kihi'ihi. Va'ora honaria'aha: —Vakaravina bana hida pão, abaisana hiki, ija'ari vavithiki vi'bai'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hari. Vi'baihahavi'aha, vava'i na'bihahavimani'aha. Vi'baina naothinia, Jesus ipohina vanajoroni'ihi ida 'bai ahabarini. 12 so'oro-ra vanaji'biji'biha'aha 'bai ahabarinia. ");
INSERT INTO padNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hari. Oniaroa, gaakosoa'aha ada Jesus, Deu-ra vara ni'aha. Kidipohi kidiania avamaakari'aha. Jesus va'ora nana'dohi'aha: —Hora vara vavani'aha adani vahoariha, nahina nimania ida hora vara vavani'avini? ");
INSERT INTO padNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kidipohia vagathani'ihi ida Jesus kana'dohi, vani'aha: —Vahoariha vani'aha: ivani João Batista kohana i iahoki'ia. Vahoariha vani'aha: ivani Elias kohana i iahoki'ia. Vahoariha vani'aha: ivani Deus athi namoniva abono kohana okhananavaki i iahoki'ia — ipohina vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Oniaroa, Jesus va'ora nana'dohi'ianaha adani ipohina: —A'onivani, nahina nimania ida hora vara avavani'avini? Pedroa bini'aha: —Ivani, Cristo Deua bikarona'iki i. ");
INSERT INTO padNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hari. Oniaroa, Jesus va'ora kaabani'aha adani kidipohi: —Hari'a vahoariha-ra bana vananamitha'a Cristo ohina, hi'ada Deua binagathogatho'iki. ");
INSERT INTO padNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Oniaroa, Jesus va'ora nava'isohijoravini hiki kidipohia avigaja kaimoni ida nahina namithaki. Va'ora ni'aha: —Hovani ija'ari hahavi vakadi'aajo ho. Oimana bana hida 'banakarahoja. Hora vakajoniki bana adani judeus kaija'ari vanava'isohiva abono. Hora vakajoniki jaboni adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama. Hora vakajoniki, hora vavahonariahiki ija'ari vahoariha hora vanaabinija kaimoni. Mahi ahoarabakosiki radahahi, oahokiki bana ho — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hari. Naothinia Jesus vara va'ora ni'a'ianaha adani ija'ari vaipohiki vahojaki kidiania. Va'ora ni'aha: —Kodipohi avihini-ra avanofihi; vakava'ipahini ida avanofiki mahija Deua binofiki ka'oa-ra bada avani'avini. Avava'ini bodini vara ni'ava: “Anofiki ida Jesus ipohina arihi'ina. Haria vanaabiniha; haria vanaabiniha. Jakaho Deus athi-ra anaabava kaho.” ");
INSERT INTO padNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hari. Asia vara niha ada Jesus: —Ija'aria bada bini'ahaha'oadahahi ida binofiki kidimoni hini, akamadaki fori hiki bana ida kidimahi. Kavithimaki ida. Ni-bivahojaki ida mahi ja'dini anokhomiriki Deus kania. Oipohina omonina jahakia kavaranini mani ida vahoariha vanaabinivini hija, oniani ida Deus kania oipohina-ra arakhaja. ");
INSERT INTO padNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ija'ari vakadinahina ipohiki-ra vanofivini arafiani mani ida Deu-ra vanofijahakiravini hija. Vaabinina kamahini Ibavi Jaharika'oakia avikhaha. Ibavi Jaharika'oakia okhahi ida ija'ari; ni-khaonanijanaki. Ni-arajomaki ida kidinahina ipohiki khaonanini-ra naabosivini kaimoni hini. ");
INSERT INTO padNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hora avakaipahihi; ojoina kamahini a'onira okaipahihi jaboni. Oathi-ra avakaipahihi; ojoina kamahini a'onira okaipahihi jaboni. Hovani ija'ari hahavi vakadi'aajo ho. Kodiabi'i ibavia ookhaki bana ho. Ojoiki bana ho ija'ari vakadiania. Ojoina kamahini bana Deus ibavi kaija'arini hora vavaipohihaki ho. Ija'aria vanokiki bana ida kodiabi'i jahana, danona, vagana kodiania. Nokiaki jaboni bana ida Deus ibavi kaija'arini vajahana kodiania. ");
INSERT INTO padNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Vakava'ibodivarani bana hida kodivarani. Khaki bana ida mahi Deus ija'ari-ra nanokiahivini ka'da'di hina. Vaabinirina oadani bana adani ija'ari ahararana vahojaki, vanokiki bana ida va'ora oni'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hari. Radahahi ida 6 mahi ipohini. Oniaroa, Jesus va'ora vigaimori'aha adani Pedro, Tiago, João vihiki. Arabo namahikia vigaimori'aha, Deu-ra vara vani'ara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Deu-ra vara ni'avini kaba'i, kama'da'ihi ida Jesus vagana nokiani. Kidimakari vaforiki vagaki jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Oniaroa, Jesus kania vanokia'aha adani makhira vi'bamiki kohana avaja'dina, Jesu-ra vara vani'a'aha. Hoarana onina Moisés. Hoariha onina Elias. ");
INSERT INTO padNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Vai'oaria nokiahi ida vagaki safini vagana fori hiki. Jesus khama vara vakhani'aha adani vi'bamiki. Vakadivarani hiki ida Jesus abinina bana Jerusalém sidajia. Nimania ida kidimoni hini Deua binofiki. ");
INSERT INTO padNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hari. Vakadivada'banaki adani Pedro, Tiago, João vihiki. Oniaroa, vanokho'afora'aha, vanoki'ihi ida Jesus nokiana vagani. Va'ora vanoki'aha jaboni adani makhira kohana avaja'di'ina vi'bamiki Jesus kania. ");
INSERT INTO padNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oniaroa, makhira vi'bamiki va'ajihina kaba'i, Pedro Jesu-ra ni'aha: —Aajo, hida vania arihojana jahaja. Oniania, anamonahaki bana ida gora itxani ahoarabakosiki. Hoarani kadaimoni, hoariha Moisés kaimoni, hoariha Elias kaimoni. Vara nina kaba'i ada Pedro, ni-biogaki ida kidivarani. ");
INSERT INTO padNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Vara nina kaba'i, kha'aha ada bahi vaforiki. Bahi vaforiki amokhinina va'ora karahoba'aha. Bahi magimagina bodia vahojaha, ni-nahina-ra vanokijanaki, oniani ida Jesus ipohina-ra va'ora naimahidaja. ");
INSERT INTO padNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bahi kania vakamitha'ihi ida athii: —Hi'o kodisai, onagathogatho'iki o. Mitha vani'a bana oni kodisai athi! ");
INSERT INTO padNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Athii naothinia, Jesu-ra vanoki'ianaha, ni-vahoariha vahojajanaki. Jesus oavani ada vakadiania hoja'ara. Viso vakhani'aha adani Jesus ipohina. Ni-vahoariha-ra va'ora vananamithavini hi'iki ida arabo namahikia vanoki'iki. ");
INSERT INTO padNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hari. Mahi hoariha vajoifoni'aha adani Jesus, Pedro, João, Tiago vihiki. Vakhanofoniha, ija'ari vaipohiki vajoroniki va'ora vakaragarari'aha. ");
INSERT INTO padNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oniaroa, hojaha ada makhira ija'ari vajoroniki vahararana, athi 'barakia Jesu-ra ni'aha: —Jesus, ira okanikhariavini hiki kodisai-ra ikajoamoraja kaimoni. Hoarana oamani ada kodisai. ");
INSERT INTO padNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bajadia bigathibakhiaki ada kodisai. Bigathivini kamahini bodi'barabakhiaki ada kodisai, rai'aha i'bana thorothoronaniki bodia. Bajadia bianahahabakhiaki ada kodisai, ni-biva'ahaki aihotana. ");
INSERT INTO padNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kadaipohi-ra va'ora okanikhariavini hiki bajadi akara'oni-ra vahonariara kaimoni. Vahonariavini kaba'i, ni-akara'o'iki ida bajadi. ");
INSERT INTO padNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hari. Jesus va'ora ni'aha adani vajoroniki: —A'onivani, ova'i-ra mokara avani'aki a'oni. Avanokibakhiaki ida Deus kabadani danokia okabadanina, kaba'i, ni-Deu-ra avavakaijokaki a'onira kakodiara kaimoni kidibadani danokia avakabadanini. Isai kaabi'i-ra ni'aha: —Kodiania ivikha o kadaisai. ");
INSERT INTO padNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bivikhavini kaba'i ada isai, bajadia binarai'a'ianaha, bajadia bisonarari'aha arabo namania. Oniaroa, Jesua bini'ahi ida bajadi: —Bajadi, isai kania akara'o'a bana! Jesua bianaihota'aha ada isai, kidiabi'i kania biarakha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Vanokiva vakava'ibodivarani'ihi ida Deus danona. Hari. Ija'ari vaipohikia vakava'ibodivaranihi ida Jesus kabadani danoki. Oniaroa, Jesus kidipohi-ra va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Vakava'ihoki bana hida vara a'onira oni'avini hiki. Hovani ija'ari hahavi vakadi'aajo ho. Ija'ari vakadiania hora avarakhaki bana ho, vahoariha hora vanaabinira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hari. Jesus ipohina mitha vani'ahi ida kidivarani, ni-nahina nini avigaki. Jesus ni-va'ora nanamithavini hiki ida athi nahina hini. Ni-Deua binofi'iaki kaho avigavini ida Jesus kavarani nahina hini. Vifinivini mani ida kidivarani nahina hini vanana'dohiravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hari. Oniaroa, vaabono vakanana'dohikhama'aha adani Jesus ipohina: —Hana hina ada akadiania hojana jahara haria vaka'da'diki kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesua biogaki ida nahina vakava'ibodivaraniki. Isai-ra anikhaha, i'oaria binahojahi ida isai. ");
INSERT INTO padNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kidipohi-ra va'ora ni'aha: —Ija'ari hora nofijahakivini mani ida isai-ra gathanijahakivini hija, oniani ida hora gathanijahakivini hija jaboni. Hora gathanijahakiha; bigathanijahakiha ada hora karona'iki. Ija'ari abononi ni'ahi: Ka'da'di ohirihi. Deua vara bini'ahi ida ija'ari: Ka'da'di ihiki i. ");
INSERT INTO padNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hari. Oniaroa, Joãoa bini'aha ada Jesus: —Aajo, anoki'iki ada makhira bajadi akara'o'ina-ra honariavini. Aripohina hiriha ada, oniani ida akaabanivini hija: “Ni-Jesus ira honariaki bajadi akara'oni-ra ihonariavini. Ikava'ipahini bana ida kadabadani.” Ani'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Oniaroa, Jesua bigathani'ihi ida João athi: —Hari'a vakaabani ada makhira. Ija'ari a'onira kanavaraniharihi; a'onira kakodiahi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hari. Jesua biogaki ida Deus ibavia ajoina kamahini amaakarini, oniani ida kidipohi-ra va'ora ni'avini hija: —Jerusalém sidajia aokha'ava. ");
INSERT INTO padNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesus va'ora honariaha adani ija'ari vaipohiriki avikhananavana. Va'ora ni'aha: —Vanako'diha'a bana ida vada ibavini akadimoni. Hari. Oniaroa, avikhananava'aha adani va'ora karonaki. Samaria kaaraboni kaija'arini vaibavia avakhano'aha, vanako'di'ihi ida gora Jesua vavavadiki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ni-Samaria kaaraboni kaija'arini va'ora vanofiki vaibavia vavadina adani Jesus. Jerusalém okhana avigavini mani ida Jesu-ra vagathanivini-ra vanofiravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hari. João, Tiago khama vakamitha'ihi ida varani vada ibavinia Jesu-ra vakaathirivini adani Samaria kaaraboni kaija'arini. Oniaroa, Jesu-ra vani'aha: —Inofimanija ida siho kaha'dini nama kakhanorarini-ra akavahonariahivini, vaihimira kaimoni adani ija'ari ira vanofiriki? ");
INSERT INTO padNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Oniaroa, roiribani'aha ada Jesus, va'ora ni'aha adani João, Tiago khama: —Iniani. Ni-jahapa'itxiki ida avakadivarani. Jokoa va'ora onihimariha adani. ");
INSERT INTO padNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Oniaroa, ai vihi'aha, ija'ari vaibavi hoariha avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hari. Hagihia vaadahana kaba'i adani Jesus, makhira Jesu-ra vara ni'a'iki: —Jesus, onofiki ida ira ovaipohiha'avini. Ibavi hana hinia iokhahi, ookhaki ho jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Oniaroa, Jesua binava'isohi'aha ada makhira ipohina hina-ra nofiki kidimahi niha nininia, oniani ida athi bigathanivini hija: —Igitha vavahojaki ida vagorana ava hodinia akoirija kaimoni. Igitha varabokia vavahojaki ida vagorana ava vadinia. Hovani ija'ari hahavi vakadi'aajo ohina kaba'i, ni-ovahojaki ida ibavi oavakoiriki kaimoni — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hari. Jesua bini'aha ada makhira hoariha: —Hora vaipohiha'a. Jesus athi-ra gathani'aha: —Jesus, jakana oajoi'imidiava kaho kodiabi'i aba'ona-ra oka'damahavini, naothinia bona ira ovaipohihahi. ");
INSERT INTO padNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesua bini'aha: —Iniani. Jakaho ija'ari abiniki-ra vaka'damahava adani ija'ari vahoariha vahokina kaba'i Deus viaha vaabiniki fori vihiki. Ivani bana okha'a mahija Deus ija'ari-ra vaka'da'divini kavaranihi-ra iananamithaonivini — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hari. Makhira hoariha bini'aha ada Jesus: —Onofiki ida ira ovaipohihavini. Iva'ahamanija koda bana ida va'ora okaamina'imidiavini adani kodiabi'i, kodiamia, oigamina vihiki, naothinia ira ovaipohiha'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Oniaroa, Jesua binava'isohi'aha ada makhira ipohina hina-ra nofiki kidimahi niha nininia, oniani ida athi bigathanivini hija: —Ija'aria binakama'dahi ida arabo-ra najahavini kidirakhajahi ibavini kaimoni hini, a'diahirini kaba'i binahojahi ida badani. Onivani fori hija ida ija'ari hora vaipohihaki joiribanini. Ija'ari niki, ni-jahaki Deua bivaka'da'divini ipohina kaimoni hini. ");
INSERT INTO padNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hari. Oniaro kari, Jesus va'ora nagathogatho'aha adani 72 vihiki vaipohina vahoariha. Va'ora karona'aha adani vi'bami'baminanana avikhananavaki. Jesus va'ora honaria'aha avikhana sidaji, ibavi hikia avikhananava'ina. ");
INSERT INTO padNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Va'ora karonavini viahania va'ora ni'aha: —Vaipohiki adani ija'ari Deus varani hina-ra vakamitha'iariki kaho. Vaipohiriki adani Deus varani hina-ra vara vavani'aki. Deu-ra vakanikharia mahija va'ora karonavini adani ija'ari vaipohiki Deus athi-ra vara vavani'ara kaimoni, ibavi ipohikia. ");
INSERT INTO padNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hari. Avikha'a bana. A'onira okaronavini ovilia fori avihini, jomahi vaihamahiki fori vihiki vakadiania avarikhani. ");
INSERT INTO padNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hari'a avavikha ida jiniro bavini, 'bai bavini, sandália kihiki. Avarikhani oadani hari'a bana ija'ari-ra vaka'ivaniti mahija avavaravararini a'onira agathiniravini. ");
INSERT INTO padNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ija'ari vagorana avakaikahihi gora kaka'da'dini-ra vani'a'imidia: “Anofiki ida Deus ira no'avini va'i jahajahania.” ");
INSERT INTO padNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Gora kaka'da'dinia bigathanijahakihi ida vara avani'avini hiki, vanava'isohiha'a: “Deus ira no'aki bana i va'i jahajahania.” Gora kaka'da'dinia bikapoaririhi ida avakadivarani, ava'ajihini viahania vani'a bana: “Jokoa Deus ira no'arihi va'i jahajahania.” ");
INSERT INTO padNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gora hoarani vania bana vahoja'a mahija avi'baivini, avi'avivini jaboni ida a'onira no'avini hiki, oniani ida avakadibadani abosini a'onira kaijahitavini hija. Hari'a bana gora hahavia vi'bai'a. ");
INSERT INTO padNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hari. Sidajia avakaikahini a'onira vagathanijahakiha; vaha bana ida 'bai a'onira vano'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Va'ora avanaihota bana adani ija'ari vakavamoniki sidajia vahojaki. Va'ora vani'a adani ija'ari: “Deua binofiki ida a'onira vaka'da'divini.” ");
INSERT INTO padNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ibavi hoariha avakaikahihi, sidaji kaija'arini a'onira vagathanijahakirihi, va'ajihi bana! Ava'ajihini kaba'i, va'ora vani'a bana: ");
INSERT INTO padNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“A'dama-ra akana'dara'daravini hiki, aniaja kaimoni hida arabo khomakhomani a'dama hojaki, avarigaja kaimoni ida jaharini ariathi-ra avakajonivini. Vakava'ibodivarani bana hida: Deua binofiki ida a'onira vaka'da'divini, athi avanaabara kaimoni.” Va'ora vani'a bana — Jesus va'ora ni'aha adani 72 vihiki vaipohina. ");
INSERT INTO padNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hari. Vara ni'ianaha ada Jesus: —Ka'oa oamani hida kodivarani. Deus ija'ari hahavi-ra nasohivini kamahini va'ora honariaki bana adani ija'ari hojai asohirikia vakahojaiki, Ibavi Jaharika'oaki kania avikhana. Hojai asohirikia vakahojaina kaba'i adani Sodoma sidaji kaija'arini, Deus va'ora va'adipa'itxiki bana adani. Ni-va'ora va'adipa'itxiki bana adani sidaji hoariha kaija'arini avaathini-ra vakajoniki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hari. Vara ni'ianaha ada Jesus: —A'onivani Corazim sidaji kaija'arini, jahariki bana ida avakadimoni. A'onivani Betsaida sidaji kaija'arini, jahariki jaboni bana ida avakadimoni. Bada oni'avini kaba'i ida Deus kabadani danoki ipohiki avakadiania, ni-avakava'ipahini'iaki kaho ida Jahari kabadania avakabadanibakhiani. Bada oni'aja vaha ida Deus kabadani danoki Tiro sidaji, Sidom sidaji hikia, Jahari kabadani-ra vakava'ipahini'bo'damaniha vaha, vakaimahamanihi vaha ida makari jarojaroki, vanaibavimanihi vaha ida ofo'ofoni vaka'da'di kanamania. Vakhanina vani Deu-ra vananokiahivini hihi ida Jahari kabadani-ra vakava'ipahinivini. ");
INSERT INTO padNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Oniaroa, Deus ija'ari hahavi-ra nasohivini kamahini, va'ora honariaki bana adani ija'ari hojai asohirikia vakahojaiki Ibavi Jaharika'oaki kania avikhana. Deus va'ora va'adipa'itxiki bana adani Tiro sidaji kaija'arini, Sidom sidaji kaija'ari vihiki. Hojai asohirikia vakahojaina kaba'i, Deus va'ora va'adipa'itxiki adani. A'onivani Corazim, Betsaida sidajia avahojaki, ni-Deus a'onira va'adipa'itxirihi bana. ");
INSERT INTO padNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A'onivani Cafarnaum sidaji kaija'arini, jahariki bana ida avakadimoni. Ni-avakava'ipahinipa'itxiki ida Jahari kabadani. Avakava'ibodivaranimanija koda ida Deus kania avarikhani Ibavi Jahaka'oakia? Ni-avarikhapa'itxiki. Deus a'onira nahokahiki bana a'oni Ibavi Jaharika'oakia — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hari. Jesus va'ora ni'aha adani kidipohi: —Ija'ari hana hini avaathini-ra kamithahi; oathi-ra kamithahi jaboni. Ija'ari hana hini a'onira kapoaririhi; ni-hora vakapoariki jaboni. Ija'ari hora kapoaririhi; ni-bikapoariki jaboni ada hora karona'iki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hari. Oniaroa, Jesus kania vajoi'aha adani 72 vihiki vaipohina. Khai vakhani'aha, Jesu-ra vani'aha: —Bajadi ai vihina-ra ahonariahi; ai vihi'aha afonana. Bajadi-ra ani'ahi: “Jesus ira honariavini iakara'oni,” oniani ida bajadi ariathi-ra vanaabavini hija. ");
INSERT INTO padNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Oniaroa, Jesua bigathani'ihi ida vaathi: —Hai oamani. Onoki'iki ada Jahari nama voroni'ina. Bahi tararariki fori hina nama gaari'ina. ");
INSERT INTO padNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mitha vani'a, a'onira ono'avini hiki ida Deus danona. Makha, akoro hiki-ra avakada'ahahi; ni-avamakhaniki. Avakadibadani danoki arafiani mani ida Jahari kabadani danoki-ra avakada'ahavini hija, oniani ida a'onira namakhaniravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hari. Khai avani'apa'itxi bana ida bajadi avakadikaabanahi-ra kamitha'avini. Khai avani'avini arafiava bana ida kodija'ari avihini. Deua binajiri'iki ida avaonini kidiania. ");
INSERT INTO padNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Oniaroa, Ma'onahai Jahaki danona Jesus kania hojani mani ida Jesu-ra khai ni'akarahoja. Bini'aha: —Kodiabi'i, ivani ivaka'da'diki ida ija'ari hahavi nama, arabo hikia vahojaki. Khai ira oni'avini hiki ida idanoni-ra inanokiavini. Ija'ari vaabono vavaboraborahariki-ra va'ora inanokiahi'iki idanonia. Vakadi'ogahai pa'itxini-ra avigaki adani. Vahoariha vani adani vakadi'ogahai karaho-ra vakava'ibodivaranira, ni-vakadiania idanoni-ra inanokiaki. Hai oamani, kodiabi'i, jahaki hida inofi'iki. Va'ora inofiki adani vakadi'ogahai pa'itxini-ra avigaki idanoni-ra avigavini. ");
INSERT INTO padNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hari. Jesus va'ora ni'aha adani vajoroniki: —Kodiabi'i hora no'avini hi'iki ida kidi'ogahai, kidinahina hahavi hiki. Ni-ija'aria biogaki ida Deus kaisai ohina. Kodiabi'i ka'oa biogaki ida. Ni-ija'aria biogaki ada kodiabi'i. Hovani ka'oa oogaki ada. Ija'ari kodiabi'i-ra ogavini-ra onofihi; oanigahihi, biogara kaimoni ada kodiabi'i. ");
INSERT INTO padNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hari. Roiribani'aha ada Jesus, vahoariha vakamitharia kaimoni ida ipohina-ra va'ora vara ni'avini: —Deus va'ora kajoamoraki bana adani ija'ari vahoariha kodibadani danoki-ra vanokivini, avanokivini vani fori hiki. ");
INSERT INTO padNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A'onira onava'isohivini, Deus athi namoniva abono kohana vaipohiki, arabo vaka'da'diva kohana vaipohiki khama vanofi'iki ida avanokiki-ra vanokivini, ni-vanoki'iki. Vanofi'iki ida avakamithaki-ra vakamithavini jaboni. Ni-vakamitha'iki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hari. Jesus kania kha'aha ada judeus kaija'ari ka'ojomo'iva abono. Binofiki ida Jesu-ra kaborovini, bianahoarihaja kaimoni ida kidivarani, oniania, binana'dohi'aha: —Jesus, ivani ija'ari ka'ojomo'iva abono i. Nahina-ra koda bana bada oni'aja ovahojaja kaimoni ida kodimahi anokhomiriki Deus kania? ");
INSERT INTO padNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hari. Jesua bigathanihi ida kidina'dohi: —Deus athi kapapirani haria nava'isohivini hiki ida Deua binofiki bada ani'aki kaimoni, kidiania aokhaja kaimoni. Nahina mani ida Deua binofija, athi kapapirani haria ni'avini hi'iki? ");
INSERT INTO padNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Judeus kaija'ari ka'ojomo'iva abonoa bini'aha: —Deus athi kapapirani haria nava'isohivini hiki: “Akadika'da'di hiki ada Deus. Inofijahaki'a afoha'oadaha o Deus. Bada inini oadani inofijahaki'a o Deus. Iva'ini bodini vara nini oadani inofijahaki'a o Deus. Mahi, joma hiki inofijahaki'a afoha'oadaha. Iabononi inofijahakivini vani fori va'ora niha va'oani ija'ari hahavi.” Nimania ida athi Deus athi kapapirania hojaki — Jesu-ra ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Oniaroa, Jesua bini'aha: —Asohiki ida ini'aki. Inaaba'a oni Deus athi ini'a'iki mahija mahi ja'dini anokhomiriki-ra ivahojavini — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Judeus kaija'ari ka'ojomo'iva abono va'i aipahirara kaimoni bini'a'aha ada Jesus: —Hana hini ija'ari hoariha ida onakaidivaja? ");
INSERT INTO padNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oniania, Jesua vara bini'aha rajomi kavaranihia, bini'aha: —Hari. Jerusalém sidajia ajihi'aha ada makhira, Jericó sidajia okharafoni'aha. Hagihi vadinia vahojamaniha adani makhira vakaabini'iki avahojaki. Vanofiki ida ija'ari radahaki-ra vidafiavini, avanahoroaja kaimoni ida ija'ari daini. Oniaroa, kharafoni'aha ada makhira daiki. Vakaabiniki avahojaki vakadiania akhano'aha, vikhaonani'aha, makhira-ra vagathi'aha, vidafiahaha, avanahoroahi ida daina. Abinina amaakarini vanahojahaha ada makhira. Ai vavanihahi ida daina. ");
INSERT INTO padNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hari. Sasidotxi maina ada hagihia okharafonisiaga'aha. Binamaakariha ada makhira kidai hi'iki. Deus kabadani abono hina kaba'i, ni-binakaidivaki ada makhira kidai hi'iki. Bianokiha, ni-binofiki bikajoamoravini, oniani ida biakakara'ofianiribanivini hija, radaha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Oniaroa, mitihini okharafonisiagaha ada judeus kaija'ari ka'ojomo'iva abono jaboni. Okharafonina kaba'i bianokiha ada makhira kidai hi'iki. Deus athi-ra ogavini kaba'i, ni-binakaidivaki ada makhira kidai hi'iki. Bianokiha, bikajoamoraravini vani ovari maina biakakara'ofianiribani'aha, radaha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hari. Mitihini okharafonisiagaha ada Samaria kaaraboni kaija'arini. Makhira kidai hiki kania akhano'aha, binavanavanaha'aha. Binakaidivakarahomaniha. Judeus kaija'arini hirina kaba'i, binaaba'ihi ida Deus athi. ");
INSERT INTO padNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Oniaroa, binaihahi ida siina ipohiki basina, vinho hikia. Binaihavini naothinia bidabohi ida siina. Siina bidabovini naothinia kidicavalo namana biarakasi'aha ada makhira. Biva'ajihi'aha. Vada ibavini kania biosa'aha. Vakaikahina biakadava'aha. ");
INSERT INTO padNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hari. Ka'afokajomani ajihina viahania, Samaria kaaraboni kaija'arinia bino'aha ada gora kaka'da'dini jiniro 'ba'dani 'bamikia. Mahi 'bamiki kavabadanini abosini fori hiki ida jiniro. Bini'aha: “Iakadava'a bana hada makhira. Ikapavakari bana ida bikainamoki kidimoni hini. Arajomarihi hida jiniro kidinahina abosini kaimoni hini, kadania ojoi'ianana kamahini ira ono'a'ianaki bana ho jiniroa.” ");
INSERT INTO padNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hari hi'ihi ida rajomi kavaranihi, Jesua binana'dohi'aha ada judeus kaija'ari ka'ojomo'iva abono: —Makhira avahoarabakosikia vanokiha ada kidai hi'iki. Hana hina vania binakaidivara ada? ");
INSERT INTO padNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Judeus kaija'ari ka'ojomo'iva abonoa bini'aha: —Samaria kaaraboni kaija'arini vania binakaidivara ada makhira. Jesua bini'aha: —Asohiki ida ini'aki. Deua binofiki ida ija'ari hoariha-ra akajoamoravini. Imaina, ija'ari-ra jaboni nakaidiva bana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Hari. Avikha'ianaha adani Jesus, kidipohi khama. Ija'ari vaibavia avakhano'aha. Marta va'ora kaboa'i'aha gorania avi'oina. ");
INSERT INTO padNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta kakajo'o onini Maria. Hari. Vithi'aha ada Jesus va'ora ka'ojomo'i'aha. Jesus maakarina vithiriama'o'ihi ida Maria. Mitha bini'ahi ida Jesus kavarani. ");
INSERT INTO padNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Oniaroa, gora bodinia bada niha'oadahaki ida Marta. Jesus kania maakari'ihi, bini'aha: —Ikava'ibodiria koda hida kodikajo'o hora kakodiaravini. Hovani ohoarana bada oni'aki hida gora bodini kabadanihi karaho. Ihonaria bana mahija hora kakodiavini. ");
INSERT INTO padNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hari. Jesua bigathanihi ida athini: —Marta, iva'ini aitapia'iki i ija'ari vaipohiki-ra va'ora ikabadanivini. ");
INSERT INTO padNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ira onava'isohivini hiki ida badani jahani arafiaki. Badani jahani arafiaki ida kodiania hojani oathi-ra kamithavini. Maria binagathogatho'iki ida nahina jahani arafiaki. Jokoa ohonariarihi hida kodiania ajihini — Marta-ra ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hari. Oniaroa, Jesua vara bini'aha ada Deus. Anokhomi'ihi ida kidivarani, kidipohia bikanikharia'aha: —Aajo, haria ka'ojomo'i bana Deu-ra vara ani'aja kaimoni. Vakhanina vani João va'ora ka'ojomo'ira adani ipohina. ");
INSERT INTO padNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Oniaroa, Jesua bigathani'ihi ida athi: —Nimania bana hida varani Deu-ra vara avani'avini kaimoni: “Akadiabi'i, anofiki ida ija'ari hahavi ijahaka'oani-ra avigavini. Anofiki ida ija'ari hahavi-ra va'ora ivaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hidakaba'i haria no'a bana 'baia, arihaki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Anofiki ida akadihojai asohiriki-ra ina'biravini. Vahoariha vakadihojai asohiriki-ra aakava'i'birinivini vani fori hini anofivini jaboni ida akadihojai asohiriki-ra iakava'i'birinivini jaboni. Haria kajoamora bana mahija kaborohirohi arihina kaba'i Jahari athi-ra akamitharavini.” Nimania hida Deu-ra vara avani'avini. ");
INSERT INTO padNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Oniaroa, Jesus va'ora ni'aha adani ipohina: —Vakava'ibodivarani'a bana ada kadava'ahi igorania kaikahi'ina joma 'bo'da hini. Vai'amina kaba'i ni-nahina hojapa'itxirihi igorania bihaki kaimoni. Oniaroa, kadava'ahi hoariha gorana iokhamaihi, ikanikhariaha: “Hora kanarihai bana pão akahoarabakosikia. Ada kaikahi'aha kodiva'ahi, napaja khaki ada. Ni-nahina-ra ovahojaki bihaki kaimoni.” ");
INSERT INTO padNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Vakava'ibodivarani'a bana ida iathini-ra gathanionanivini: “Hari'a kodivada-ra ka'baraha. Kaka'oaha'iki ida gora kaathani. A'oma'iki hari kodisai khama. Ni-onofiki ida ogamana ira ono'aja kaimoni pãoa.” Jesus va'ora ni'aha adani ipohina: ");
INSERT INTO padNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Ka'oa hiki hida kodivarani. Kidiva'ahi hina kaba'i, ni-binofiki ida gamana bikajoamorara kaimoni. Bikanikhariaha'oadahavini mani ida ragamana hija, kidiva'ahi-ra no'ara kaimoni nahina biakanikhariakia. ");
INSERT INTO padNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Oniani ida a'onira onava'isohivini hija; Deu-ra vakanikharia bana avanofikia mahija avagathanivini. Deus kania vakanikhariaha'oadaha bana ida avanofiki mahija a'onira no'avini hini ida avakanikhariaki. Ija'ari hahavi nahina jahakia Deu-ra vakanikhariaha; vagathanihi ida vakanikhariaki. Ija'aria binako'diha ada Deus; bikaragaha. ");
INSERT INTO padNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kadaisai ira kanikhariahi abaisana, makha vania koda bana ino'ara ada? Iniani. Jokoa nahina jaharikia ino'ariha ada. ");
INSERT INTO padNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Banafa ira kanikhariaha, akoro vania koda bana ino'ara ada? Iniani. Jokoa nahina jaharikia ino'ariha ada. ");
INSERT INTO padNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A'onivani hojai asohirikia avakahojaini kaba'i, avarigaki ida nahina jahakia avakadisai-ra avano'avini. Jaha'oamanira ada avakadiabi'i nama hojaki. Bikaronaki bana ada Ma'onahai Jahaki avakanikhariavini hiki. ");
INSERT INTO padNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hari. Oniaroa, Jesua bihonariaki ida bajadi akara'oni makhira kania. Kabajadina oadani ada makhira ni-varavarana-ra kaabokaki. Akara'o'ihi ida bajadi, varavara'aha ada makhira. Ija'ari vâipohiki vajoronikia vakava'ibodivaranikaraho'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hari. Vahoariha vaipohiriki vani adani vakhaniha: —Bajadi vakadika'da'di Biosibo Jahari onikia bino'aki ada Jesus danona, bikaabokaja kaimoni ida bajadi akara'o'ini. ");
INSERT INTO padNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hari. Vahoariha vanofiki ida Jesu-ra vakaborovini bianahoarihaja kaimoni ida kidivarani, oniania, Jesu-ra vani'aha: —Anokivini anofiki ida Deus kabadani danoki-ra bada ini'avini. Bada ini'ahi; Deus danona-ra ivahojavini-ra aogahi — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hari. Jesua biogamanihi ida vakadiva'ibodivarani, va'ora ni'aha: —Rajomi kavaranihi-ra vara ovani'aki bana ho, avarigaja kaimoni ida Biosibo Jahari vakadika'da'di hora no'aravini danona. Arabo kaija'arini vaabono vakodakhamaha; vaabono vakanihimakhamaha. Gora kaija'arini vaabono vakodakhamaha; vaabono vakanihimakhamaha jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Vakhaniki jaboni adani Jahari kaija'ari vanokiariki vaabono vakodakhamara vaha; vaabono vakanihimakhamamaniha vaha; ni-vahojajanaki vaha adani kidija'ari Jahari va'ora vaka'da'diki kaimoni. Asia vara niki ada Jesus: —Avakadivarani hiki ida Biosibo Jahari hora no'avini danona bajadi akara'oni-ra ohonariaja kaimoni. Ni-asohiki ida avakadivarani. ");
INSERT INTO padNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Avaipohini jabonia vakaabokaki ida bajadi akara'oni. Ka'oa hija vaha ida avakadivarani, Jahari vani koda danona va'ora no'ara adani avaipohini? Ni-Jahari va'ora no'ariha adani danona. Bajadi akara'oni-ra vakaabokavini mani ida Deus danona-ra avarigavini hija. Bajadi akara'oni-ra vakaabokavini mani ida avakadivarani asohirikia avaipohini haria vananokiahivini hija. ");
INSERT INTO padNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Deus hora no'avini hiki hida odanona, oniani ida bajadi akara'oni-ra okaabokavini hija. Deus danona-ra ovahojavini mani ida Deus avakadiania kha'ina-ra avarigavini hija, ija'ari-ra va'ora vaka'da'dira kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Asia vara ni'aha ada Jesus: —Makhira danoki fori hiki ada Jahari. Makhira danoki kasa'aikia biakadava'avini oadani ida gorana, ni-avisonipa'itxiki ida kidinahina. ");
INSERT INTO padNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Khaki bana ada makhira hoariha danona arafiaki kasa'aiki jaboni. Ovaria bidaki hihada makhira, bianahoroaja kaimoni ida gorana, bisaariki ida makhira abono-ra vakaijokaki kasa'ai. Bisaariki jaboni ida kidinahina hahavi biravinaja kaimoni vahoariha vakadiania — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hari. Asia vara ni'aha ada Jesus: —Ija'ari hora kakodiariki, ni-hora nofiki. Kodija'ari-ra va'ora onajoronivinia hora kakodiariha; va'ora akarakhakhamaha — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Hari. Vara ni'ianaha ada Jesus: —Ija'ari kania akara'o'ihi ida bajadi, adaha'ihi kaija'aririki kaarabonia. Binako'dihahi ida ibavi biavakoiriki kaimoni. Bikaragarihi, abononi ni'ahi: “Oajoiki bana ho ogorana. Ija'ari kania oakara'o'ina, kidiania oajoiki bana ho.” ");
INSERT INTO padNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Oniaroa, joi'ihi, bikaraga'ihi ida gora bodini jaha'ini dairiki. ");
INSERT INTO padNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Oniaroa, ajihi'ianahi ida bajadi, va'ora anikha'aha adani ipohini 7 vihiki vaipohina vajaharina arafiaki, ija'ari kania vahojara kaimoni. Bajadi hoarani hojani kari, jaharihi ida ija'ari kamahi. Bajadi vaipohiki vahoja'aha ija'ari kania, jaharini arafia'ihi ida ija'ari kamahi — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Anokhomi'ihi ida Jesus kavarani, athini 'barakia Jesu-ra ni'ahi ida gamo ija'ari vaipohiki vahararana hojaki: —Deua bikajoamoraki ida kadamia ira namonaha'iki jahani bodinia, ira kanajohohaki jaboni ida. ");
INSERT INTO padNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesua bigathani'ihi ida athini: —Deus va'ora kajoamora'oamanira adani ija'ari Deus athi-ra vakamithaki, vanaabaki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hari. Oniaroa, vajoroni'ianaha adani ija'ari vaipohiki Jesus vahararana. Vara va'ora ni'aha: —Jahari kahojaia vakahojaiki adani ija'ari hidakaba'i vahokiki. Avanokivini avanofiki ida Deus kabadani danoki, rajomi kaimoni ida Deus kodiania hojana. Jokoa a'onira onanokiahirihi badani danokia. A'onira onanokiahivini hiki bana ida rajomi hoarani. Deus kabadani danoki Jonas kohana kania namitha'iki rajomi hoarania a'onira ono'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Vakava'ibodivarani'a bana ada Deus athi namoniva abono kohana Jonas oniki. 'Bo'dakari Deua bikarona'iki ada Jonas Nínive sidajia okhana, va'ora kaabanira kaimoni adani ija'ari. Jona-ra karonavini vani fori hora nihara ada Deus, hora karonavini jaboni, a'onira okaabanija kaimoni. Jona-ra anahokivini vani fori hora nihara bana ada Deus, hora anahokivini jaboni, avarigaja kaimoni hida varani ka'oa hini. Hovani ija'ari hahavi vakadi'aajo ho. ");
INSERT INTO padNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hari. Deus ija'ari hahavi-ra nasohivini kamahini, ija'ari vajoroniki vahararana hojaki bana ida Sabá sidaji kaija'arini vakadika'da'di. A'onira anaathidanoararivini hiki ida oathi-ra avakajari'davini. 'Bo'dakari hojaki ada Salomão oniki. Ogahaki ada Salomão. Sabá sidaji kaija'arini vakadika'da'dia binavanavanahaki ada, bikamithaja kaimoni ida Salomão athi jaboni. Hahavi-ra oogavini kaba'i, oathi-ra avakajari'daki a'oni. ");
INSERT INTO padNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hari. Deus ija'ari hahavi-ra nasohivini kamahini, ija'ari vajoroniki vahararana vahojaki bana adani Nínive sidaji kaija'arini. A'onira avanaathidanoararivini hiki ida avakadihojai jahariki-ra avakava'ipahiniravini. 'Bo'dakari Nínive sidaji kaija'arinia vakamitha'iki ida Jonas va'ora kaabanivini, vakava'ipahinimani'ihi ida vakadihojai asohiriki. Hidakaba'i ohojaki ho avakadiania, a'onira okaabanidanokiki ho kaba'i, ni-avanofiki ida avakadihojai asohiriki-ra avakava'ipahinivini. Hahavi-ra oogavini kaba'i, oathi-ra avakajari'daki a'oni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hari. Asia vara ni'aha ada Jesus: —Ija'aria bianaha'dihi ida lamparina, ni-bianahojaki. Ni-varaja kanabo'ania binaibaviki jaboni. Nama vania binaibavihi, ija'ari o'oihi binokijahakija kaimoni ida gora bodini vagani. ");
INSERT INTO padNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lamparina fori hiki ida ija'ari nokhoni vagani. Avanokhoni vagani jahahi; hahavi-ra avanokihi. Mahi vagania avaadahani fori hihi nahina-ra avanokivini hiki avanokhoni jahani. Avanokhoni jaharihi; ni-nahina-ra avanokiki, joma bakibakinia adahai fori hiki hida. Jahari kahojaia avakahojaihi; joma bakibakinia avaadahani fori avihiki bana a'oni. ");
INSERT INTO padNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hari. Avava'ini ogairiva bana mahija Jahari kahojaia avakahojairavini. ");
INSERT INTO padNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jahari kahojaia avakahojairihi; avaabononi hahavi mahi vagania hojaki fori hihi. Jahari kahojaia avakahojaihi; joma bakibakinia avahojaki fori avihihi. ");
INSERT INTO padNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hari. Anokhomi'ihi ida Jesus kavarani, farisioa bikaboa'i'aha ada Jesus gorana 'baira kaimoni. Okhaha ada Jesus, okhajakosiha mesa kania vithi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisioa bikava'ibodivaranikaraho'aha ada Jesus. Judeus kaija'aria vakosokovini arafiaki ida vasa'a vi'baina viahania. Jesua vahojana binaabaravini mani ida farisio-ra nava'ibodivaranija. ");
INSERT INTO padNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Oniaroa, Jesus va'ora ni'aha: —Farisio, mitha vani'a hida a'onira vara oni'avini! Ija'ari prato-ra sokojahakiriki fori avihiki a'oni. Bisokohi ida copo, prato hiki namanija, ni-bodinija bisokoki. Jahahi ida avanokiani. Nokiarihi ida avava'ini bodini vara nini jaharika'oaki, avava'ini joko nini jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Avajahani-ra avakahi'badaraki a'oni. Deua binokiki ida ija'ari jahani bodini hahavi, namanija jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ija'ari kanahinariki-ra avakadinahina avakajoamorajahakihi; avakadiva'ibodivarani jahahi. Ni-nahina kaimoni avanaababakhiaki ida akadija'ari vakadihojai, avasa'ani-ra avakosokovini arafiani. ");
INSERT INTO padNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisio, mitha vani'a hida a'onira vara oni'avini! Jahariki ida avakadimoni bana! Avanajoroniki ida nahina hahavi avagahinani hiki, avanapitahatahaki ida sa'ai ko'bamihani hiki. Avanajoiribaniki ida pitani hoarani Deus kania. Chá afani, nahina hoariha havahaki kaimoni jaboni avanapitahatahaki. Jahaki ida Deus athi-ra avanaabavini, Deu-ra avano'avini hiki ida pitani. Asohiriki ida Deus athi-ra avanaabahahaviravini. Ni-avanofiki ida ija'ari-ra avanaibavijahajahakivini. Ni-Deu-ra avanofijahakiki jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisio, mitha vani'a hida a'onira vara oni'avini! Jahariki ida avakadimoni bana! Avanofivini arafiaki ida ka'da'di kavithi ibavinia avavithini akadija'ari Deu-ra vara ani'avini kagorania. Ija'ari vahoariha vaipohiki vakadika'da'di-ra vaka'ivanitivini vani fori hini hida a'onira vaka'ivanitivini-ra avanofivini. ");
INSERT INTO padNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Farisio, mitha vani'a hida a'onira vara oni'avini! Avajahani-ra avakahi'badaraki a'oni. Jahariki ida avakadimoni bana! Akadija'ari vakadikaaji hiki ida aba'oi ka'damahani namani, ni-jahaki ida 'dama kanamania avaadahani. A'onivani aba'oi ka'damahani ibavini nokiariki fori avihiki a'oni. Ija'aria bikanokiravini mani ida 'dama kanamania naadahani hija — Jesus va'ora ni'aha adani farisio. ");
INSERT INTO padNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oniaroa, judeus kaija'ari ka'ojomo'iva abonoa bini'aha ada Jesus: —Jesus, nimania hijanani ida kadavarani, haria ikanavaranihavini jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesua bigathani'ihi ida athi: —Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira oni'avini! Jahariki ida avakadimoni bana jaboni! Daji khanaki fori hiki ida kaaji ipohiki. Kaaji ipohiki-ra avavahonariahivini fori hiki ida daji khanaki-ra avanaibavibakhiavini vahoariha vama'adosia vavajadojadoja kaimoni. Ni-avanofipa'itxiki ida va'ora avaakakodiavini vadaina-ra vakaiba'ivini. Ni-avasa'ani hoarania va'ora avaakakodiaki. ");
INSERT INTO padNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Judeus kaija'ari vaka'ojomo'iva abono, mitha vani'a hida a'onira oni'avini! Jahariki ida avakadimoni bana! Avakadiabi'i avikhananavaki va'ora vanaabiniki adani Deus athi namoniva abono kohana. Avanaibaviki ida ja'di karaho avanajahaja kaimoni ida Deus athi namoniva abono kohana vaka'damahana ibavini, avakarajomiki ida ka'damahi ibavini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Avarigaki ida 'bo'dakari va'ora vanaabinivini, avavajahaki ida va'ora vanaabinivini, oniani ida Deus athi namoniva abono kohana vaka'damana-ra avakakarajomivini hija. Va'oaniaro 'bo'dakari va'ora vanaabini'iki adani. A'onivani avanajahaki ida vaka'damana. A'onivani va'oaniaro fori avihi'oamanija. ");
INSERT INTO padNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Deua biogahahaviki ida namithaki kaimoni. 'Bo'dakari niha ada Deus: “Va'ora okaronabakhiaki bana adani oathi namoniva abono, oathi avaadahaoniva abono vaipohiki vihiki, judeus kaija'ari vakadiania avikhana afobakhia. Judeus kaija'ari va'ora vanaabiniki bana adani va'ora okaronaki vahoarahanana, va'ora vanajaharihariki bana adani vahoariha.” Niha ada Deus. ");
INSERT INTO padNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hari. Asia vara niha ada Jesus: —Deus jaharikia va'ora arakhaki bana adani ija'ari hahavi hidakaba'i vahokiki. Deus athi namoniva abono hahavi kidai vihi'iki abosini ida jaharikia Deus va'ora arakhavini hija. ");
INSERT INTO padNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Deus hahavi-ra namonahabiininivini kari, kidai hi'ina abini'iki ada Abel. Abel naothia kidai vihi'ina vaabini'aha adani Deus athi namoniva abono vaipohiki afohanana. Naothinia Zacarias jaboni kidai hi'iki, Deu-ra khai vani'avini kagorani bodinia. Igitha aha'dini ibavini, Ibavi Katokini Jahaki kahararakhamania abini'iki ada Zacarias kohana. Ka'oa hiki hida kodivarani. Deus jaharikia va'ora arakhaki bana adani ija'ari hidakaba'i vahokiki. Deus kaija'ari hahavi kidai vihi'iki vaabinina abosija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Judeus kaija'ari ka'ojomo'iva abono, mitha vani'a hida a'onira vara oni'avini! Jahariki ida avakadimoni bana! Avaranahojaki ida Deus varani hina asohiki, Deu-ra avigarara kaimoni adani ija'ari vahoariha. Ni-avanofiki ida Deus varani hina asohiki-ra avarigavini. Ni-avanofiki jaboni ida vahoariha avigavini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hari. Jesus ajihina viahania, judeus kaija'ari ka'ojomo'iva abono, farisio khama vaabono vara vakani'akhama'aha. Vaihamahina Jesu-ra vakanavaraniha'aha. Jesu-ra vanana'dohi'aha na'dohi ipohikia. ");
INSERT INTO padNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jesu-ra avakaraganahavini-ra vanofivini mani ida Jesus athi-ra mitha vani'ajahakivini hija. Vanofiki ida vakamithavini nahina asohiriki Jesua bini'a'iki, Jesu-ra avanaathidanoararira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hari. Oniaroa, Jesus vakadiania vajoroniha adani ija'ari vaipohiki. Vaipohi'oamanira adani. Vaabono vaaka'dokho'dokhokhamaki adani, va'dama-ra vaakada'aha'ahakhama'iki adani jaboni. Jesus vara va'ora ni'a'imidiaha adani kidipohi: —Farisio Deu-ra vanofiki vaabono vavanihavini mani ida vakadihojai nasohirini hija. Avaabononi avakava'igairi bana mahija vakadihojai avanofiravini. ");
INSERT INTO padNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ija'ari vakadihojai ogavaharini kaba'i hidakaba'i, khaki bana ida mahi hojai hahavi ogavahani kamahini. Nahina ija'aria bianahojaki, khaki bana ida mahi vahoariha avigavini kamahini. ");
INSERT INTO padNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ija'aria bianahojavini kaba'i ida kidivarani, vahoariha avigaria kaimoni, khaki bana ida mahi ija'ari hahavi avigavini kamahini. Gora bodinia avakahojakosoani vara avakhanihi, vahoariha vakamitharia kaimoni, gora 'da'dini a'ani sohiriama'oki kania vahoariha vakabodi'barahaki ida avakadivarani ahojaki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Hari. Vara ni'ianaha ada Jesus: —Kodiva'ahi, ka'oa hiki hida vara a'onira oni'avini hiki. Hari'a bana va'ora vifini adani ija'ari a'onira vanaabinivini-ra vanofiki. Avaabinini naothinia, ni-a'onira vanapohimajavini-ra vakaabokajanaki bana. ");
INSERT INTO padNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A'onira onava'isohivini hiki bana ada avifiniki kaimoni. Vifini bana ida Deus athi-ra avanaabaravini! Deus a'onira naabinivini naothinia, bikaabokaki ida a'onira nahokahivini Ibavi Jaharika'oakia. Vara oni'a'ianaki ida oni'aki, vifini bana ida Deus athi-ra avanaabaravini! ");
INSERT INTO padNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kaidivariki ida kirikiri. Pavakari anihahi ida kirikiri abosini jiniro pa'itxi sa'ai kahoarani hiki. Kaidivarini kaba'i, Deus va'ora akadava'aki adani, ni-biakava'i'biriniki ida hoarani. ");
INSERT INTO padNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hari'a avava'ini soko iniva! Deua binakaidivaki ida kirikiri, Deus a'onira nakaidivavini arafiaki a'oni! Deua biogaki ida hahavi. Biakogaki ida avaka'da'di kaafani nihafori kihini kaipohini, oniani ida a'onira onava'isohivini hija, a'onira nakaidiva'oamanira ada Deus — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Hari. Vara ni'ianaha ada Jesus: —A'onira vara oni'avini hiki, ija'ari kodija'ari hini-ra kahihi vahoariha vaviaha; kodija'ari hini okahihi jaboni bana Deus ibavi kaija'arini vaviaha. ");
INSERT INTO padNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ija'ari kodija'ari hirini-ra kahihi vahoariha vaviaha; kodija'ari hirini okahihi jaboni bana Deus ibavi kaija'arini vaviaha. ");
INSERT INTO padNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Hari. Ija'ari hora kanavaranihahi, Deua bikaabokaki ida varani jahariki-ra na'biravini. Ija'ari Ma'onahai Jahaki-ra kanavaranihahi, jokoa Deua biakariakapa'itxirihi ida ija'ari varani jaharikia kavaraniki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Vara ni'ianaha ada Jesus: —Kodija'ari avihini mani ida vahoariha badani jaharikia avakabadanini-ra vakahi'badaravini hija, oniani ida a'onira avarakhavini hija judeus kaija'ari vanasohiva abono vakadiania, judeus kaija'ari Deu-ra vara vani'avini kagorania. Kodija'ari avihini mani ida vahoariha a'onira avarakhavini hija jaboni bana ija'ari vakadiarabo vaka'da'diva vakadiania, jaharikia a'onira avarakhara kaimoni. A'onira avakaraganahavini kamahini, hari'a bana avakava'isokonijora vakadi'akaraganahi avagathanivini. ");
INSERT INTO padNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Vakadi'akaraganahi avagathanivini kamahini, Ma'onahai Jahaki a'onira nava'isohiki bana varani vara avavani'aki kaimonia — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hari. Oniaroa, ija'ari vaipohiki vahararana hojaha ada makhira. Ovaria bini'aha: —Jesus, ada abini'aha kodiabi'i. Ihonaria bana ada kodi'aajo mahija akadiabi'i kohana kanahina-ra napitavini, pitania ogahinaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesua bini'aha: —Xoni, jokoa onasohirihi ida avakadi'aathidanoarari. Kodibadani hirihi ida. Ni-kodibadani hiki ida avakadiabi'i kohana kanahina-ra onapitavini. ");
INSERT INTO padNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Oniaroa, va'ora ni'aha adani vajoroniki: —Avava'ini ogairiva bana mahija hoariha kanahina-ra avakava'ibodivaraniha'oadaharavini. Avakadimahi hirihi ida nahina avavahojaki. Ipohini kaba'i ida nahina avavahojaki, ni-avakadimahi hiki. Kanahina'ahapikini kaba'i ida ija'ari, ni-kidinahina ipohikia biakodiaki ida ija'ari gahinaja kaimoni mahi anokhomirikia — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hari. Oniaroa, rajomi kavaranihia va'ora vara ni'a'ianaha: —Hojaha ada makhira kanahina'ahapikiki. Kidirakhajahi abani bononi ipohiki. ");
INSERT INTO padNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oniaroa, bikava'ibodivarani'ihi: “Ni-arajomaki ida kodirakhajahi bononi kagorani, onaibavijahaja kaimoni. Niha oni'a'aki koda ida kodirakhajahi bononi?” ");
INSERT INTO padNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Asia abono-ra ni'avini: “Hai oamani, oogaki ida. Onathararaki bana ida kodirakhajahi bononi kagorani. Onamonaha'ianahi bana ida gora na'bahaki, onaibavijahaja kaimoni ida kodirakhajahi bononi, kodinahina hahavi. ");
INSERT INTO padNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A'diahihi bana ida kodibadani, oabono oni'ahi: Hovani makhira khaii niki ho! Ovahojaki ida nahina ahapini. Badara ipohiki vani ni-nahina-ra okainamoki. Oakoirihi, nahina jahaki-ra onofihi; ohahi. Nahina jahaki-ra onofihi; o'avihi jaboni. Khai oniki bana ho.” ");
INSERT INTO padNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Oniaroa, Deua bini'aha: “Iva'ini bajadidi'oamanija! Ikava'ibodivaranika'oaki ida kadanahina ahapini. Hihida joma iabiniki bana i. Ni-ivahojajanaki bana ida kadanahina inaibavijahajahaki'iki. Hoariha gahinani hiki bana ida kadanahina.” ");
INSERT INTO padNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Hari. Jesua biananokhomi'ihi ida rajomi kavaranihi. Jesus vara va'ora ni'a'ianaha adani ija'ari: —Vakhanimanira adani ija'ari Deu-ra vakava'ibodivaranipa'itxiriki. Vaabono vavidorahaki adani vakanahina'ahapikira kaimoni. Deus va'ora vara vani'aha: “Vakanahina'ahapikiki vaabono vavanihaki adani va'ora onokiki, vakanahinarina va'ora okahiha.” Niha ada Deus — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Oniaroa, Jesus va'ora ni'aha adani ipohina: —A'onira onava'isohiki bana ho. Hari'a avakava'isokoniha'oadaha ida 'bai avahaki kaimoni-ra avagathivini. Hari'a avakava'isokoniha'oadaha ida avakadimakari avakaimahaki-ra avavahojaravini. ");
INSERT INTO padNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Avakadimahi hirihi ida avakadi'bai. Ni-avaabononi hirihi ida avakadimakari. Jahaki ida avakadi'bai-ra avanako'dihavini, makari avavahojavini jaboni. Avanofivini kaba'i ida 'bai, makari hiki, hari'a avava'ini-ra nahonariahihiva bana ida makari, 'bai hiki. Deus a'onira no'avini hi'iki ida avakadimahi; a'onira kaijahitaki jaboni ada. ");
INSERT INTO padNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Vada va'ora vani'a bana adani kosoro. 'Bai-ra vanako'divini kaba'i, ni-vava'i soko iniki. Ni-varakhajahaki, ni-vidoraki ida rakhajahi bononi. Ni-vanamonahaki ida bavi, rakhajahi bononi ibavijahani kagorani kaimoni, kaba'i Deus va'ora kaijahitaki adani kosoro. Deus va'ora nakaidivaki adani igitha varaboki, Deus a'onira nakaidivavini arafiaki a'oni! ");
INSERT INTO padNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Avarakava'isokonimanija koda ida avakadimahi-ra avana'oadavini? Iniani. Ni-avakaabokaki ida avakadimahi-ra avaranaipohivini. ");
INSERT INTO padNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Badani pa'itxi oamani ida ija'ari kidimahi-ra anaipohivini kabadanihi, kaba'i ni-bikaabokaki. Ni-nahina kaimoni avarakava'isokoniki ida 'bai, makari hiki-ra avakainamovini. ");
INSERT INTO padNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Vakava'ibodivarani bana ida hogoi movani avijavani. Ni-bada niki ida movai, ni-binamonahaki ida makari bikaimahaki kaimoni. Ka'oa hiki hida kodivarani. A'onira onava'isohivini hiki ada arabo vaka'da'diva Salomão oniki kohana. Kanahina'ahapikiki ada Salomão. Kaidivaki ida kidimakari, nokiani jahaki jaboni ida. Jahani kaba'i ida kidimakari nokiani, jahani nokiani arafiaki ida movai. ");
INSERT INTO padNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Deus vania binamonahaja ida hogoi movani nokiani jahaki. Hidakaba'i hojahi ida hogoi, afokajoma ara'okho'iki ida, ija'aria bianaha'di'iki ida. Kaidivarini kaba'i ida hogoi, Deua bikahinanikaki ida. Deus a'onira nakaidivavini arafiaki a'oni, oniani ida bana a'onira kakodiavini hija avakadimakari avakainamokia. Deus a'onira kaijahitavini-ra avakajari'darihi. Hari'a avava'ini soko iniva! ");
INSERT INTO padNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hari'a vakava'ibodivaraniha'oadaha'a bana ida avakadi'bai avahaki kaimoni, nahina avi'aviki kaimoni. Hari'a avakava'isokoni! ");
INSERT INTO padNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Deu-ra avigarikia vakava'ibodivaraniha'oadahaki ida vakainamoki. Avakadiabi'i nama hojakia biogaki ida nahina hahavi avakainamoki. ");
INSERT INTO padNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vakava'ibodivarani afo'imidia bana ida Deua binofiki. Vava'aha ada Deus a'onira vaka'da'divini. Athi vanaabahaha'oadahaha; a'onira kaijahitajahakiha. ");
INSERT INTO padNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kodipohi, hari'a bana avava'ini soko iniva! Avakadiabi'ia khai bini'aki ida kidinahina avavaka'da'divini kidiania, ovaria bivaka'da'divini fori hini. ");
INSERT INTO padNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pavakari vaniha'a ida avakadinahina hahavi. Ija'ari vakanahinariki-ra va'ora vano'avinihi ida avakadijiniro. Vanaibavijaha bana ida avanakaidivaki Deus kania nama. Ni-ihimiki ida avanaibavijahaki. Bo'di abonoa ni-bikaabokaki bianivini, ni-va'ba'ba binihimaki jaboni bana. ");
INSERT INTO padNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Avakadinahina-ra avanakaidivavini arafiahi; avakadinahina-ra avakava'ibodivaraniha'oadahahi. Deu-ra avanakaidivavini arafiahi; Deu-ra avakava'ibodivaraniha'oadahahi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Hari. Rajomi kavaranihia kavarani'ianaha ada Jesus: —Honai abonoa vanokhaha ada vakadika'da'di akarai kaihinikani kania joina. Vakadimakari vakaimaha'iki, vakadilamparina avanaha'di'iki, joina vanokhavini. ");
INSERT INTO padNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hari. Hihada honai abono fori vihi'a bana. Avakadika'da'di joina-ra vanokha'a bana! Vakadika'da'di joina vani bakatha-ra too too kani'a'aha, kidihonai abono jorakia avakarabikhai'ihi ida bakatha. ");
INSERT INTO padNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oniaroa, vakadika'da'di va'ora karaga'aha adani honai abono vanokina, joina vanokhavini, jahaki ida vakadimoni. Ka'oa hiki hida a'onira oni'avini hiki. Vakadika'da'dia binaibavijahaki bana ida ibavi vavi'baiki ibavini kaimoni, vavithiriama'ona va'ora honariaha, va'ora ko'baiha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Joiki vahabini bana ada joma 'bo'da hini. Joiki vahabini bana ada joma jararini. Joina vanokhavini vani va'ora karagaha; jahaki ida vakadimoni bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hari. Jesus rajomi kavaranihi hoariha-ra vara vani'a'ianaha: —Ni-ija'aria avigaki ida daji anahoroava abono khana kamahini. Gora kaka'da'dinia biogaja vaha ida mahi daji anahoroava abono khana, ni-gorana o'oina biva'ahaki vaha, ni-biva'ahaki ida kidinahina ahoroani. ");
INSERT INTO padNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hovani ija'ari hahavi vakadi'aajo ho. Onivani fori hija ida ojoina kamahini. Ni-avarigaki ida mahi hana hini ojoina kaimoni. Oniani ida a'onira ohonariavini hija, hora vanaviahanokhahaha'oadaha bana! ");
INSERT INTO padNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hari. Oniaroa, Pedroa binana'dohi'aha ada Jesus: —Aajo, akadimoni ka'oa mani ida rajomi kavaranihi haria vara ini'avini hi'iki? Ija'ari hahavi vakadimoni mani koda ida kadavarani? ");
INSERT INTO padNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Oniaroa, Jesua bigathani'ihi ida kidina'dohi: —A'onivani honai abono jahaki fori vihi'a bana! Hovani honai abono kaka'da'di fori ohiki ho. Vara a'onira oni'avini hiki bana ada honai abono ogahaki, kidika'da'di athi-ra naabaki ada. Kidika'da'dia bihonariaha: “Iakadava'a bana hida ogorana. Va'ora no'a bana adani kodihonai abono vahoariha vakadi'baia mahi hahavi.” Niha ada ka'da'di. Ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hari. Ka'da'di athi-ra naabahaha'oadahaha; ka'da'di joina kamahini, jahaki ada honai abono kidimoni hina. ");
INSERT INTO padNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ka'oa hiki hida kodivarani. Ka'da'dia bini'aki bana ada kidihonai abono: “Inaabajahaki'iki ida ira ohonariavini hi'iki, oniani ida kodinahina hahavi, ogorana, arabo hiki-ra iakadava'avini maina ira ohonariavini hija.” Niha ada ka'da'di. Onivani fori hija bana hida vara a'onira oni'avini hiki jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hari'a bana honai abono jahariki fori vihi'a! Ni-kidika'da'di athi-ra naabaki. Abono-ra ni'aha ada honai abono: “Agathinahaki ada kodika'da'di.” Niha ada honai abono. Oniani ida honai abono vahoariha-ra va'ora dafiabakhiavini hija. Gamo, makhira vihiki adani honai abono va'ora najaharihari'iki. Ko'bainofiki ada honai abono, kakavinofiki jaboni ada, kahanobakhiaki ada. ");
INSERT INTO padNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Oniaroa, joi'aha ada ka'da'di. Ni-kidihonai abonoa binokhajanaki joina, ni-biogaki ida joina kamahini. Hari. Jaharikia ka'da'dia biarakha'aha ada honai abono, binaima'banakarahoki bana ada. Bihonariaha ada honai abono Ibavi Jaharika'oakia okhana, Deus athi-ra vanaabariki vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Asia vara niha ada Jesus: —Hari. Honai abonoa biogavini kaba'i ida kidika'da'di binofiki, ni-bada bini'aki. Bikajoniki ida bada bini'avini, oniani ida kidika'da'di xikotxia bidafia'ahapikivini hija. ");
INSERT INTO padNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hari. Honai abono hoariha ni-biogajahakiki ida kidika'da'di binofiki. Ovari hikia bada bini'a'iki ida kidika'da'di bivajahariki. Kidika'da'dia bidafiaki ada honai abono jaboni. Ni-arafiaki ida bidafiavini xikotxia. Kajoniahaki fori hiriha ada. Onivani fori hija ida Deus kahonai abono Deus kanahina-ra akadava'avini. Deua biarakhaki ida kidinahina ipohiki kidihonai abonoa biakadava'aja kaimoni. Deua binokhaki ida kidihonai abono kidinahina ipohiki ana'ba'dini hina. Deus kidinahina ipohiki-ra arakhahi; kidinahina ipohini a'ba'dini arafiaki-ra nokhaha joiribanini kidiania. ");
INSERT INTO padNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Hari. Asia vara niha ada Jesus: —Hora rakhaki Jahari kabadani-ra onihimavini, siho nahina jahariki-ra akanaha'diki fori ohina. Onofiki ida jorakia nahina jahariki-ra oanaha'divini hari hi'ini. ");
INSERT INTO padNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Jahari kabadani-ra onihimavini kamahini oabinina, oimana 'banakarahoki bana ho. Hari hini kamahini oimana 'banani radahani-ra onofihi. ");
INSERT INTO padNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Asia vara ni'aha ada Jesus: —Hari'a vakava'ibodivarani: Jesus kaikahina mani ida ija'ari vaabono vakanajahamisikhamavini hija. Okha'ina mani ida hora vakajari'daki hora vakajari'dariki-ra va'ora vanajahariharivini hija. ");
INSERT INTO padNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ija'ari vaipohina sa'ai kahoarani vihiki adani gora bodinia vahojaki. Ija'ari avahoarabakosiki, ija'ari vi'bamiki khama vaabono vaakaja'oriakhamaki. ");
INSERT INTO padNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Isai kaabi'i, kaamia vihiki va'ora vanajaharihariki bana adani vakadisai. Isai va'ora vanajahariki bana adani vakadiabi'i, vakadiamia. Isai kaamia va'ora vanajaharihariki adani gamo isani vakadisai. Gamo isani va'ora vanajaharihariki adani vakadiamia. Gamo kamasodini va'ora vanajaharihariki adani vakadi'aboni gamo. Vakadi'aboni va'ora vanajaharihariki adani vakadimasodini. Hora vakajari'daki va'ora vavajahariki bana adani hora vanofijahakiki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hari. Jesus va'ora ni'aha adani ija'ari vajoroniki. —Avanokiha ada bahi pororona, avakhanihi: “Kharariki bana ada bahi.” Avakhanihi. Kharari'oamanira ada bahi. ");
INSERT INTO padNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hojariha ada bahi vaforiki nama, avakhanihi: “Afaki bana ida hidakaba'i.” Avakhanihi. Afa'oamanija bana ida mahi. ");
INSERT INTO padNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Avanokiki ida nama rajomi, avarigajoraha ada bahi, safini hiki kamahina. Avanokivini kaba'i hida kodibadani, ni-avarigapa'itxiki ida nahina namithaki kaimoni. Ogahai abono avihini-ra avakahi'badaraki a'oni. ");
INSERT INTO padNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hari. Jesua biananokhomi'ihi ida kidivarani. Va'ora ni'aha: —Nahina mani ida avaabononi avanasohivini-ra avarigaravini hija? Vakava'ibodivaranihanana bana. ");
INSERT INTO padNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ija'ari ira anaathidanoarariki badani jaharikia ikabadaninia, inasohijoraki bana ida avakadivarani. Jahaki ida hojai ihamahiki-ra ianariakajorakivini. Jahari kabadania ikabadanihi; jorakia inasohi. Ija'ari nasohiva abono kania ikaikahini viahania, inasohi bana ida kadavarani. Ianariaka bana ada ira anaathidanoarariki. Ianariakariha; ira osaki bana ada ija'ari nasohiva abono kania. Ija'ari nasohiva abono ira arakhaki bana i sorara vasa'a kabodinia. Sorara ira obaiki bana i cadeia. Ija'ari nasohiva abono ira honariaki bana kadabadani jahariki-ra inaabosivini jiniro karahoa. ");
INSERT INTO padNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ka'oa hiki hida kodivarani. Inaabosihahaviravini oadani ida jiniro, ni-cadeia iokhaonaniki bana. Jahari kabadania ikabadanihi; jorakia bana Deu-ra anariaka'a mahija jaharikia ira arakharavini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hari. Vara nina kaba'i ada Jesus, vakaikahi'aha adani ija'ari vahoariha, vara Jesu-ra vani'aha: —Ikamithamanija ida Galiléia kaaraboni kaija'arini vamonina? Arabo kaka'da'dini Pilatos oniki va'ora vahonariahiki adani vaabinina. Deu-ra khai vani'avini kagorani bodinia igitha abononi aha'dikia Deu-ra vakanava'igavini oadani, Pilatos kahonai abono va'ora vanaabini'iki adani. ");
INSERT INTO padNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Oniaroa, Jesus va'ora ni'aha: —Va'ora avakava'ibodivaraniki adani judeus kaija'ari Galiléia kaarabonia vikhaki. Vakadihojai asohiriki aradahaki avavanihamania, oniani ida va'ora napohimajaja? ");
INSERT INTO padNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iniani. Ni-vakadihojai asohiriki aradahaki ida ija'ari vahoariha vakadihojai asohiriki. Ka'oa hiki hida kodivarani. Avakadihojai asohiriki-ra avakava'ipahinirihi; a'onivani jaboni avaabiniki bana a'oni, va'oaniaro fori avihini. ");
INSERT INTO padNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Va'ora vakava'ibodivarani adani ija'ari 18 vaipohina Siloé ibavi onikia vahojaki. Gora namahiki adari'iki vanamana, va'ora naabini'iki adani. Vakadihojai asohiriki arafiaki va'ora avavanihavini, oniani ida va'ora napohimajaja. Vakadihojai asohiriki ni-aradahaki adani Jerusalém sidaji kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ka'oa hiki hida kodivarani. Avakadihojai asohiriki-ra avakava'ipahinirihi; a'onivani jaboni avaabiniki bana a'oni, va'oaniaro fori avihini. ");
INSERT INTO padNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hari. Oniaroa, Jesus rajomi kavaranihi-ra vara vani'a'aha: —Uva avani kasiroini-ra vahojaha ada makhira. Uva avani hararania hojaki ida figira avani. Hari. Makhira kasiroikia binako'diha'ihi ida figira bononi, ni-bonoki ida avani. ");
INSERT INTO padNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Oniaroa, bini'aha ada siroi akadava'ava abono: “Vada ini'a hida figira avani. Badara ahoarabakosikia onako'dihi hida figira bononi, ni-nahina-ra okaraga'iaki kaho. Iava'boa hida avani. Ni-nahina kaimoni kodisiroia hojaki hida figira avani bonoriki.” ");
INSERT INTO padNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hari. Siroi akadava'ava abonoa bini'aha ada makhira: “Jakaho hojava afo'imidia hida figira avani badara hoarani ka'oa. Okhoriribanaoniki bana hida avani 'damani. Onaibaviki bana ida nami jahaki hoariha, bonoja kaimoni hida figira avani. ");
INSERT INTO padNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Badara hoariha bonohi hida avani; ni-oava'boaki bana. Bonorihi; a'boani ivahonariahihi.” Niha ada siroi akadava'ava abono. — Rajomi kavaranihi-ra ananokhomi'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Hari. Ija'ari akoiri kamahini okhaha ada Jesus judeus kaija'ari Deu-ra vara vani'avini kagorania, va'ora ka'ojomo'i'aha adani ija'ari vajoroniki. ");
INSERT INTO padNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Oniaroa, kaikahi'ihi ida gamo kavamoniki. 18 badara ipohini vani bajadia binakavamonija ida gamo. Vatxinini adahaki ida gamo. Ni-bikaabokaki ida abononi nasohimananivini. ");
INSERT INTO padNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Oniaroa, Jesua binoki'ihi ida gamo, kidiania khamini bikaboa'i'ihi, bini'a'ihi: —Xoni, hida kha kodiania, ia'aihota'iki i. ");
INSERT INTO padNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oniaroa, Jesua bikanaibavihi ida sa'a gamo namania. Jorakia abononi nasohi'ihi. Deu-ra khai ni'a'ihi ida gamo. Bini'ahi: —Jahaki ada Deus, danoki ada. Hora anaihota'iki ada. ");
INSERT INTO padNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hari, ihamahi'aha ada judeus kaija'ari Deu-ra vara vani'avini kagorani akadava'ava abono. Akoiri kamahini gamo-ra anaihotavini mani ida Jesu-ra kaihamahivini hija. Oniania, va'ora ni'aha adani ija'ari vajoroniki: —6 mahi ipohini vani ija'ari bada vakhanina jahaja. Hojaki ida mahi hoarani akadi'akoiri kamahini kaimoni. Hari'a akoiri kamahini vikha avaraihotaja kaimoni. Ija'ari bada vakhanina kamahini vikha bana. ");
INSERT INTO padNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Oniaroa, Jesua bigathani'ihi ida athi: —Deus athi-ra avanaabavini-ra avakahi'badaraki a'oni. Aakoirina kamahini hahavi bada avakhaniki a'oni. 'Daama kahidari vagorana avarikhaki a'oni, va'ora avakokharihaki adani avakadi'daama kahidari, burro vihiki, va'ora avarisavini vaha kania vi'avija kaimoni ida paha. ");
INSERT INTO padNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hihida gamo oanaihota'iki Abraão kahanodi namitharonisiagaki hida. 18 badara ipohini vani Jaharia bidabomisiki fori hija hida. Nahina mani ida aakoirina kamahini aihotani najaharini hija? — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Oniaroa, Jesu-ra vavajahariki vava'i-ra anaipahihi'ihi ida Jesus vara va'ora ni'avini hi'iki. Ija'ari vaipohiki vani adani khai vakhanira Jesus kidibadani danoki-ra bada ni'abakhiavinia. ");
INSERT INTO padNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hari. Vara ni'ianaha ada Jesus: —A'onira vara oni'avini hiki ida bana rajomi kavaranihi. Mostarda 'ba'dani avijavani vani fori hiki ida Deus ija'ari-ra vaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ija'aria birakhaihi ida mostarda 'ba'dani kidisiroia. Movahi, avijavahi, karaho'oamanija ida mostarda avani. Vadini avijavani na'bahaki jaboni. Igitha raboki kagorahaki vadinia. Nimania ida Deus ija'ari-ra vaka'da'divini avijavani — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hari. Asia vara niha ada Jesus: —Okavarajomiki bana ida Deus ija'ari-ra vaka'da'divini. Pão kaimani-ra kanathoramananiki vani fori hija ida Deus ija'ari-ra vaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gamo vania bigathija ida pão-ra kanathoramananiki pa'itxi, binaibavi'ihi ida trigo karaho, biara'bira'ihi bavi hoarani bodinia. Pa'itxini kaba'i ida pão-ra kanathoramananiki, biara'biravini naothinia kathoramanani'ihi ida pão kaimani hahavi. Nimania ida Deus ija'ari-ra vaka'da'divini avijavani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hari. Aadahaoni'aha ada Jesus sidaji karaho, sidaji pa'itxi hikia, Jerusalém sidaji-ra anikhaha'avini. Ija'ari vaibavia akhano'aha va'ora aka'ojomo'ioni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ija'aria binana'dohi'aha: —Ija'ari vaipohiriki vani koda adani Deus va'ora akava'ijoara bana? ");
INSERT INTO padNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesua bigathani'ihi ida kidina'dohi: —Hari'a vava'aha ida nahina a'onira nadabavini bakatha karabodirikia avari'oini. Ka'oa hiki hida a'onira vara oni'avini hiki. Ija'ari vaipohikia vanofiki ida avi'oina, ni-vakaabokaki bana. ");
INSERT INTO padNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Oniaroa, rajomi kavaranihia vara va'ora ni'a'aha ada Jesus. Kidivarani hiki ida ija'ari Deus athi-ra naabariki. Va'ora ni'aha: —Gora kaka'da'dini fori hiki ada Deus. Deus ibavi fori hiki ida gora. Hari. Gaamanani'aha ada gora kaka'da'dini, biaka'oaha'ihi ida gora kaathani. Hari. A'onivani gora banininia avahojaki bana a'oni, too too avakhaniha'oadahani: “Akadika'da'di, anofiki ida ao'oina!” A'onira ni'aki bana ada: “Ni-a'onira oogaki, ni-hana hini kaija'ari avihini-ra oogaki.” ");
INSERT INTO padNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Avagathanihi ida athi: “A'bai'iki hari kadania. Akadisidajia haria ika'ojomo'iki hari jaboni.” ");
INSERT INTO padNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A'onira ni'a'ianaki bana ada: “Ni-a'onira oogaki, ni-hana hina kaija'ari avihini-ra oogaki. Avakadihojai asohirihi afobakhia, avakara'o bana kodiania!” — va'ora ni'aha ada Jesus. Hari. Jesus va'ora ni'aha adani vajoroniki: ");
INSERT INTO padNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Va'ora avaranokijakosiki bana adani Abraão, Isaque, Jacó, Deus athi namoniva abono hahavi vihiki Deus kania. A'onivani baniniaja avahojaki bana a'oni. Avari'oini-ra avakaabokaravini mani ida a'onira naasara'ahapikija bana, avakanadani-ra avakanakiroromisiki bana a'oni! ");
INSERT INTO padNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hari. Oniaroa, vajoroniki bana jaboni adani ija'ari vaipohiki arabo hahavia vikhaki Deus athi-ra vanaabaki. Vavithirariki bana adani vajoronina mesa kai'oarinia Deus ibavi kania vi'baijabanara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hari. Ija'ari vaipohiki Deus va'ora baranahasiagavini va'oaniaro miro'a avi'oiki bana adani Deus ija'ari-ra vaka'da'divini kania. Ija'ari vahoariha va'oaniaro miro'a Deus va'ora baranahavini kaba'i, avi'oisiagaki adani vahoariha, Deus ija'ari-ra vaka'da'divini kania. ");
INSERT INTO padNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hari. Vara nina kaba'i ada Jesus, vamaakariha adani farisio vaipohiriki, vani'aha: —Ajihi'a bana hihida ibavia. Irojia binofiki bana ida ira naabinivini. ");
INSERT INTO padNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hari. Jesus va'ora ni'aha: —Jahari kabadani namonahava abono ada Iroji. Avikha bana kidiania. Vananamitha'a bana hida kodivarani okaronaki: “Hidakaba'i bajadi akara'o'ini-ra ohonariaki ho, ija'ari vakavamoniki-ra va'ora oanaihotaki ho jaboni. Afokajoma oniani kodibadani hi'ianahi. Afokajoma hoariha bana ona'diahiki hida kodibadani.” Iroji-ra vani'a bana. ");
INSERT INTO padNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hari. Asia vara niha ada Jesus: —Deua binofiki ida Jerusaléa ookhana, oniani ida hidakaba'i, afokajoma, afokajoma hoariha hora anaadahaonija. Jerusalém sidaji ka'oa Deus athi namoniva abono-ra va'ora vanaabinibakhiavini, oniani ida Jerusaléa hora arakhaja. ");
INSERT INTO padNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Oniaroa, Jesus va'ora ni'aha: —Jerusalém sidaji kaija'arini! Va'ora avanaabinibakhia'iki adani Deus athi namoniva abono. Ja'dia va'ora avanagahabakhia'iki adani athi avikhava abono Deus va'ora karona'iki avakadiania. Kaba'i, a'onira onakaidivaki ho, onofiki ida a'onira oakava'ijoavini. Arakava kidisai-ra bihini nabo'ania najoroniki fori a'onira onihavini-ra onofihi, ni-avanofipa'itxiki. ");
INSERT INTO padNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A'onira oakava'ijoavini-ra avanofiravini mani ida Deus avakadisidaji-ra kava'ipahinivini hija bana. Ka'oa hiki hida kodivarani Jerusalém sidaji kaija'arini a'onira vara oni'avini hiki. Ni-jorakia okha'ianaki bana ho avakadiania. Hora vanoki'ianavini kamahini Jerusalém sidaji kaija'arini hora vanofiki adani, vara vavani'aki bana hida varani ohina: “Khaki ada ovari Deua bikaronaki ija'ari-ra vaka'da'dira kaimoni. Deua bikajoamoraki bana ada khaki.” — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hari. Oniaroa, akoiri kamahini vani o'oi'ara ada Jesus farisio vakadika'da'di gorana 'baira kaimoni kidiania. Ija'ari vahoariha vada vani'ahaha'oadahaha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oniaroa, hojaha ada makhira jaro'barara kakavamoniki, Jesu-ra namaakari'aha. ");
INSERT INTO padNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Oniaroa, Jesus va'ora nana'dohi'aha adani judeus kaija'ari vaka'ojomo'iva abono farisio khama: —Akadija'ari kahonari jirikia biva'ahamanija koda ida ija'ari ija'ari kavamoniki-ra anaihotavini aakoirina kamahini? Biva'ahamanija koda ida? Biva'aharia koda ida? ");
INSERT INTO padNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hari. Viso vakhaniha. Ni-vagathani'iki ida Jesus kana'dohi. Oniaroa, Jesua bikaabada'aha ada makhira jaro'barara kakavamoniki, bianaihotaha, ajihi'ina bihonaria'aha. ");
INSERT INTO padNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bianaihotavini naothinia va'ora ni'aha adani vajoroniki: —Ija'ari-ra oanaihotavini aakoirina kamahini vani fori hiki ida avakadisai-ra avakajoamoravini aakoirina kamahini. Voroniki vahabini bana ida avakadisai paha aniani ibavini bihiakia. Joraki vania koda bana avaanira bana ada avakadisai? Ha'a. Voroniki vahabini bana ada avakadi'daama kahidari paha aniani ibavini bihiakia. Joraki vania koda bana avaanira bana ada, aakoirina kamahini kaba'i? Ha'a. ");
INSERT INTO padNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hari. Ni-vakaabokaki ida Jesus kana'dohi-ra vagathanivini. ");
INSERT INTO padNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hari. Oniaroa, Jesus vada va'ora ni'aha adani ija'ari vakaikahiki. Gora kaka'da'dini va'ora kaboa'ivini hiki vi'baira kaimoni kidiania. Vanako'dihaki ida ibavi jahaki mesa kania vavithira kaimoni gora kaka'da'dini maakarina. Oniaroa, Jesus va'ora ka'ojomo'i'aha: ");
INSERT INTO padNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ija'ari ira kaboa'ihi akarai kaihinikani kania ikanorini, hari'a bana inako'di ida ibavi jahaki mesa kania ivavithiki kaimoni. Ira kaboa'ikia vahabini bikaboa'i'iki jaboni ada ija'ari vaka'da'diva. ");
INSERT INTO padNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ikava'ibodivarani bana, ija'ari vaka'da'diva kaikahina viahania, ivani ivithijorakihi ibavi jahakia. Oniaroa, kaikahiha ada ka'da'di. Ira kaboa'ikia binako'diki bana ida ibavi jahaki ka'da'di kaimoni. Ibavi jahakia ivithini-ra nokiha, ira ni'aki bana ada: “Ka'da'di hada hoariha, ino'avinihi bana ida ibavi jahaki ivavithiki kidimoni hini.” Nimania bana ida varani iva'ini-ra anaipahihiki. Igaamananihi napaja pa'itxia ivithirari'ihi. Jahariki hida kadaimoni hini. ");
INSERT INTO padNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Oniania, ira onava'isohivini hiki bana ida hojai hoariha jahaki. Akarai kaihinikani kania ikaikahini vani vithi'imidia bana ira kaboa'i'iki napaja nina pa'itxia. Iva'aha bana ida hoariha vithini ibavini jahakia. Oniaroa, ira kaboa'i'iki ira ni'aki bana i: “Kodiva'ahi, khami bana mahija ibavi jahakia ivithivini.” Kanori abono vahoariha vanokiki bana ida ivithirarini, vaabono vakani'akhamavini: “Haria kaboa'ikia bihonariaki hada ibavi jahakia vithina. Ka'da'di jahaki vahabini ada.” Jahaki hida kadaimoni hini. ");
INSERT INTO padNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hari. Ija'ari abononi ni'ahi: “Hovani ojahaka'oaki ho.” Deus bini'aki bana ida ija'ari: “Ivani ni-nahina ihipa'itxirihi.” Va'ini aipahihiki bana ida. Ija'ari hoariha bikava'ibodivaraniki ida nahina hirini. Deus bini'aki bana ida ija'ari: “Ivani ijaha'oamanija.” — Jesus va'ora ni'aha adani vajoroniki. ");
INSERT INTO padNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hari. Oniaroa, Jesua bini'aha ada va'ora kaboa'i'iki: —Avakadihojai hiki ida va'ora ikaboa'ivini adani kadava'ahi, iigamini, kadabi'i, kadamia, vakadija'ari vihiki, ija'ari vakanahina'ahapikiki vihiki igorani maakarinia vahojaki, vi'baira kaimoni igorania, bona ira vakaboa'iha jaboni vagorana, ira vako'baihavini-ra avanaabosira kaimoni. Va'ora ikaboa'ivini ira vanaabosivini mani ida Deus ira naabosiravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hari. A'onira onava'isohivini hiki ida hojai jahani arafiaki. Ija'ari vi'baina-ra ikaboa'ivini kamahini kadania, va'ora kaboa'i'a bana adani vakanahinariki, vatonorohaki, vajo'o aba'oronisiagaki, vakamaodorohaki vihiki. ");
INSERT INTO padNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Va'ora ikaboa'iha, bona Deus ira kajoamorahi. Va'oaniaroa ni-vakaabokaki ida va'ora iko'baihavini-ra vanaabosivini. Deus vani ira naabosija bana. Ija'ari hojai jahakia vakahojaibakhiaki kohana avahokina kamahini vani, Deus ira naabosiki bana i — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hari. Asia mesa kania vavithiha, vi'baina, hoarana Jesus athi-ra mitha ni'akia bini'aha: —Jesus, Deus kidija'ari-ra vaka'da'divini kamahini khai vakhaniki adani vi'baiki kidiania. ");
INSERT INTO padNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Oniaroa, Jesua vara bivani'ahi ida rajomi kavaranihi ija'ari Deus kania 'baini. —Ihinika ko'baini karaho-ra honariaha ada ka'da'di. Bikaronahi ida athi va'ora kaboa'iha adani kanori abono vaipohiki. ");
INSERT INTO padNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ihinika ko'baini a'diahini kamahini bikarona'ianaha ada kidihonai abono, va'ora nava'isohihavini adani kidikanori abono vaipohiki: “Vikha'a. Ida a'diahi'ihi ihinika ko'baini kaimoni.” Nihi ida ka'da'di athi. ");
INSERT INTO padNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hari. Va'ora kaboa'iha, ni-vanofiki vanaabavini hida ka'da'di athi. Hoariha bini'aha ada honai abono: “Okapavakari'iki ida siroi, oniani ida onavanavanahavini onofivini hija. Jokoa ookharihi kidihinika onakanorivini. Ookharihi bana iathini-ra onaabahavini.” ");
INSERT INTO padNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hari. Hoariha bini'aha: “Va'ora okapavakariki adani 'daama kahidari sa'ai ko'bamihani vihiki, varahokaja kaimoni ida ava siroi kanamini-ra nakhomakhomaki. Okaijo'aki ida bana vakadibadani, kodisiroi-ra bada vani'ara kaimoni adani 'daama kahidari. Jokoa ookharihi kidihinika onakanorivini. Ookharihi bana iathini-ra onaabahavini.” ");
INSERT INTO padNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hari. Hoariha bini'aha ada honai abono: “Oagamo'iki ho hidakaba'i, oniani ida hora arakharija bana. Ookharihi bana iathini-ra onaabahavini.” ");
INSERT INTO padNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hari. Ija'ari vaipohiki vakadiania aadahaoniha ada honai abono ihinika-ra avaaminavini. Ni-avikhana-ra vanofiki. Vaipohikia vanaabarihi ida ka'da'di athi. Ka'da'di kania joi'aha ada kidihonai abono, binamonihi ida vani'aki. Hari. Ihamahi'aha ada ka'da'di. Kidihonai-ra ni'aha: “Ajihi'a jorakia. Okha'a bana hagihi, sidaji hikia. Va'ora anikha'a adani vakanahinariki, vatonorohaki, vajo'o aba'oronisiagaki, vakamaodorohaki vihiki mahija kodihinika-ra vanakanorivini. Vaibavia va'ora nako'diha'a.” Niha ada ka'da'di. Hari. Ajihi'ianaha ada honai abono, va'ora nako'diha'ianavini adani ija'ari vahoariha. ");
INSERT INTO padNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Va'ora kaboa'ivini naothinia joi'ianaha, bini'a'ianaha ada ka'da'di: “Kodika'da'di, onaaba'iki ida iathini ija'ari-ra va'ora onako'dihavini, kadaihinika-ra oavaaminavini. Ni-ji'bini'iaki kaho ida kanori abono vaibavi.” ");
INSERT INTO padNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Oniaroa, ka'da'dia bihonaria'ianaha ada kidihonai abono: “Ajihi'iana. Ibavi hoariha kagorani hoaraharahakia aadahaoni'a. Va'ora honaria bana adani ija'ari vahoariha vikhana mahija ogorana ji'binivini ija'aria. ");
INSERT INTO padNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Jokoa kodiania vi'bairiha adani vahoariha va'ora okaboa'i'iki. Ni-oathi-ra vanaaba'iki.” Niha ada ka'da'di — va'ora ni'aha ada Jesus. Jesus athi hini ida Deus ija'ari-ra kaboa'ivini kidiania avikhana. Athi naabani vihiha; kidiania avikhaha. ");
INSERT INTO padNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hari. Oniaroa, ija'ari vaipohiki Jesu-ra vavaipohiha'aha. Roiribani'aha, va'ora nava'isohi'aha: ");
INSERT INTO padNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ija'aria binofiki ida oipohina hini, jahaki ida hora vanofivini arafiani. Ija'ari hora nofivini arafiarihi; ni-bikaabokaki ida oipohina hini. Oipohina va'ora nofiki adani kidiabi'i, kidiamia, igamini, kidigamo, kidisai vihiki. Oniani abononi nofihi jaboni ida oipohina. Arafiarihi ida hora nofivini; ni-oipohina hirihi ida ija'ari. ");
INSERT INTO padNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ija'ari hora vavaipohihaki, ija'ari ava akasanakhamaki-ra kaiba'ivini fori hiki. Ija'ari ava akasanakhamaki-ra kaiba'ivini fori hirihi, ni-oipohina hini-ra kaabokarihi. Ija'ari abononi va'aharihi ida abinini kodimoni hini, bikajonihi jaboni ida oathi-ra naabavini, ni-arajomaki ida oipohina hini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hari. Rajomi kavaranihia kavaraniki ada Jesus. Oniaroa, va'ora ni'aha: —Ija'ari ja'di kagorahi namahiki-ra namonahavini-ra nofihi, vithi'imidiahi, bikava'ibodivarani'imidiahi ida amonahani kaidivani, biogaja kaimoni ida kidijiniro arajomani arajomarini. ");
INSERT INTO padNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bikava'ibodivaraniravini vani binakama'da'ihi ida gora namahiki-ra namonahavini. A'diahirini kaba'i bikainamoki bana ida kidijiniro, ni-bikaabokaki ida binaa'diahivini. Oniaroa, ija'ari varadahakia vada vani'aki bana ida gora a'diahiriki, vakanavaraniha'aha ada makhira va'i bodinia vara niriki, vaabono vakani'akhama'aha: ");
INSERT INTO padNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Binakavithimaki ida kidijiniro. Binakama'da'iki ida gora kaidivaki amonahani, ni-bikaaboka'iki ida binaa'diahivini.” ");
INSERT INTO padNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","32","Hari. Rajomi kavaranihi hoariha kavaraniki ada Jesus. Jesus va'ora ka'ojomo'iki adani ipohina vihina-ra vanofiki vakava'ibodivaranijahakivini afo'imidia vanaabahahavija kaimoni ida Deua bihonariaki. Jesua bikavarajomiki ada Deus arabo kaka'da'dini kasorara'ahapikiki fori hina. Bikavarajomiki ida ipohina hini-ra nofiki arabo kaka'da'dini kasorara vaipohiriki fori hina. Oniaroa, Jesus va'ora ni'aha: —Arabo kaka'da'dini va'ora vaka'da'di'aha adani sorara vaipohiriki. Bikamithaki ida arabo hoariha kaka'da'dini monina. Vaipohiki adani hoariha kasorara. Hoariha kidisorara khama va'ora vidara kaimoni adani sorara vaipohiriki-ra vahojaki. Sorara vaipohiriki vakadika'da'dia bikamithahi ida vahoariha vamonina, vithi'imidiaha, bikava'ibodivaranijahakiki ida varajomana varajomarina kidisorara vaipohina, va'ora vidara kaimoni adani vikhaki. Abono-ra ni'aki bana ada sorara vaipohiriki vakadika'da'di: “Ni-avarajomapa'itxiki adani kodisorara va'ora adara kaimoni adani vahoariha. Napaja vahojana kaba'i vani, va'ora okaronaki bana adani oathi avikhava abono arabo hoariha kaka'da'dini kania, oathi forakia vani'ara kaimoni, ariabono akodakhamarija kaimoni kidisorara khama.” Hari hi'ihi ida rajomi kavaranihia Jesus va'ora vara ni'avini. Va'ora ni'aha adani ija'ari vahojaki: ");
INSERT INTO padNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Nimania ida ija'ari oipohina hini-ra nofiki. Bikava'ibodivarani'imidiava ida hora vaipohihavini. Kidinahina hahavi-ra nahojaha'imidiava ida oipohina hini-ra nofiki. Binahojaharihi; ni-oipohina hini-ra kaabokaki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Vara ni'ianaha ada Jesus: —Jahaki ida jokira, 'bai-ra naponiki kaimoni hini. Nahina binajaharihi, ni-ponini jahajanaki. ");
INSERT INTO padNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ija'aria binahokahika'oaki ida jokira jahajanariki, ni-nahina kaimoni hini jahaki. Ni-arajomaki ida jokira jahajanariki 'bai kajokirani kaimoni hini. Jokira fori hiki ida kodipohi, nahina binajahariki bana ida kidihojai; ni-jahajanaki jaboni. Avamorobohahi; mitha vani'a bana hida kodivarani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hari. Oniaroa, Jesus kania vakaikahi'aha adani imposto gathaniva abono, ija'ari hojai jahariki vakahojaiki vahoariha khama. Vanofiki ida Jesus kavarani-ra vakamithavini. Imposto oniki ida jiniro arabo kaka'da'di kabadani abosini kaimoni. Vakadihojai jaharini vahoariha va'ora vakahibakhiaki adani imposto gathaniva abono. ");
INSERT INTO padNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hari. Farisio, judeus kaija'ari vaka'ojomo'iva abono khama va'ora vanokiha adani Jesus kania vakaikahiki, vaabono vara vakani'akhama'aha, vakhaniha: —Ni-jahapa'itxiki ida Jesus ija'ari hojai jaharikia vakahojaiki-ra va'ora gathanivini. Jesus 'baina vakadiania jaboni — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Oniani ida Jesus vara va'ora ni'avini hija rajomi kavaranihia: —A'onira okavarajomivini hiki ada ovilia akadava'ava abono. ");
INSERT INTO padNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Hari. Va'ora ivahojaki adani 100 ovilia vaipohina. Va'ora iakadava'avini kaba'i, hoarana akamada'iki. Inako'dimanira ada ovilia akamadaki? Ha'a, inako'di'oamanira ada. Va'ora inahoja'imidia'aha adani ovilia 99 vihiki avakamadariki vaibavia, naothinia kada'ovilia akamada'iki-ra ianako'dioniki i. Ikaragaravini oadani ianako'dioniki bana ada. ");
INSERT INTO padNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hari. Ikaraga'aha, khaii inihi, ikama'adosihavini ivajoiki ada kada'ovilia. ");
INSERT INTO padNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hari. Igorania ivakaikahiha, va'ora ibaranahaki adani kadava'ahi, ija'ari vahoariha vagorana maakariki, va'ora ini'aha: “Khai vakhani'a kodiania. Ada okaraga'aha kodi'ovilia akamada'iki.” ");
INSERT INTO padNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Oniaroa, Jesus va'ora ni'aha: —Onivani fori hija bana ida Deus ibavi kaija'arini vakadiania. Va'ora khai vani'aki adani ija'ari 99 hiki hojai asohikia vakahojaiki. Khai vani'avini arafiaki ida ija'ari hoarani Jahari kahojai-ra kava'ipahinika'oaki. ");
INSERT INTO padNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Hari. Oniaroa, Jesus vara va'ora ni'a'ianavini hiki ida rajomi kavaranihi hoariha: —Hari. Gamoa bivahojahi ida jiniro 'ba'dani prata amonahaki 10 hiki ipohini. Binakaidivaki ida jiniro 'ba'dani. Oniaroa, bianakamada'ihi ida jiniro 'ba'dani hoarani. Kidijiniro 'ba'dani-ra nako'dimanija ida gamo? Ha'a. Binako'diki ida. Oniaroa, bianaha'di'imidiahi ida kidilamparina, gora bodinia binako'dija kaimoni. Biaragahi ida gora bodini, vajaforia binako'di'ihi ida jiniro. Bikaragaravini oadani binako'dihi. ");
INSERT INTO padNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hari. Bikaragahi, khaii ni'ihi. Va'ora kaboa'iha adani kidiva'ahi, ija'ari vahoariha vagorana maakarinia vahojaki, va'ora ni'aha: “Khai vakhani'a kodiania. Ida okaraga'ihi kodijiniro 'ba'dani hoarani akamada'iki.” Oniaroa, Jesus va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—A'onira onava'isohivini hiki bana adani Deus ibavi kaija'arini khai vakhanina. Gamo kidinahina kaidivaki-ra karagavini vani fori vihira adani Deus ibavi kaija'arini jaboni khai vakhanina. Ija'ari hoarania bikava'ipahinihi ida kidihojai asohiriki, oniani ida khai va'ora ni'aja. Ija'ari hojai asohiriki kahojaiki fori hiki ida jiniro 'ba'dani akamada'iki. ");
INSERT INTO padNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hari. Oniaroa, Jesus vara va'ora ni'a'ianaha rajomi kavaranihi hoariha: —Hari. Makhira va'ora vahojaki adani imakhinava vi'bamiki. ");
INSERT INTO padNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Oniaroa, kajo'ojahikia bini'aha hada kidiabi'i: “Papai, iabinini kamahini kodi'aajo khama agahinaki hari bana kadanahina. Onofiki ida pitani ogahinana hini hidakaba'i.” Niha ada kajo'ojahiki. Oniaroa, vakadiabi'ia binapita'ihi ida kidinahina kidisai vi'bamiki vakadimoni hini. ");
INSERT INTO padNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hari. Mahi ipohiriki radahani naothinia, kajo'ojahikia binaibavijaha'ihi ida kidinahina hahavi, ajihi'aha, arabo hoariha-ra anikhaha'avini. Ibavi napaja hikia kaikahi'aha. Jahari kabadani ipohikia kabadanibakhiaki ada. Nahina binofiki bikapavakariki. Binakavithimaki ida kidijiniro hahavi kidiabi'ia bino'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hari. Ihimihahavi'ihi ida jiniro. Oniaroa, ni-khararijanaki ada bahi, ni-movaki ida arabo kaija'arini vakadirakhajahi. Ija'ari hahavia vakainamoki ida vakadi'bai. Imakhinava jabonia bikainamoki ida kidi'bai, kidinahina hahavi. ");
INSERT INTO padNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Vai'amina mani ida badani-ra anako'dionivini hija 'bai-ra naabosivini kaimoni. Ka'da'di-ra ni'aha: “Onofiki ida hora badania ino'avini 'bai ohaki-ra onaabosivini kaimoni.” Ka'da'dia bini'aha: “Kodihiraria vavahojaki kania okha'a mahija va'ora iakadava'avini.” Oniaroa, hirari vakadiania okha'aha ada imakhinava. ");
INSERT INTO padNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Vai'ami abani hina hoja'aha. Vai'amikarahona mani ida hirari vakadi'bai-ra havini-ra nofivini hija. Ni-ija'aria 'baia vano'apa'itxiki, ni-vava'ahaki ida hirari vakadi'bai-ra havini. ");
INSERT INTO padNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Oniaroa, va'i bodinia vara ni'aha: “Vako'bai'ahapikiki adani kodiabi'i kahonai abono. Ahabaribakhiaki ida vakadi'bai. Hida ohojana vai'ami hora naabiniki ho bana. ");
INSERT INTO padNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kodiabi'i gorana oajoiki ho. Okaikahina oni'aha: ‘Papai, bada oni'a'iki ida hojai asohiriki Deua bivajahariki, ivajahariki jaboni ida. ");
INSERT INTO padNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jahari kabadania okabadanina mani ida ova'i-ra anaipahihija, oniani ida kadaisaia hora inaonivini ova'i-ra anaipahihija. Onofiki kadahonai abono ohina.’ Nimania ida bana kodiabi'i-ra vara oni'avini kaimoni okaikahina.” Abono-ra ni'a'aha ada imakhinava. ");
INSERT INTO padNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Oniaroa, ajihi'aha, joi'aha kidiabi'i gorana-ra anikhaha'avini. Napaja khana kaba'i, kidiabi'ia bianoki'aha ada imakhinava joi'ina. Kidiabi'ia binakaidivamaniha, ki'daraha'aha, bikajara'ba'ba'aha ada kidisai, biramosi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hari. Imakhinava bini'a'aha ada kidiabi'i: “Papai, bada oni'a'iki ida hojai asohiriki Deua bivajahariki, ivajahariki jaboni ida. Jahari kabadania okabadanina mani ida ova'i-ra anaipahihija, oniani ida kadaisaia hora inaonivini ova'i-ra anaipahihija.” ");
INSERT INTO padNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Imakhinava vara nina kaba'i, kidiabi'i va'ora ni'aha adani kidihonai abono: “Jorakia avanikha'a ida makari jahaki, ja'dini mahija avaranabosihavini makari jahakia. Vanaibavi bana ada sa'avithinahi sa'a. Vakanaibavi oni sandália 'dama jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Avanikha'a bana ada 'daama kahidari dorona basinaki mahija avanaabinivini. Haria vako'baiha'a mahija kodisai joina kaikahi'ina-ra khai ani'avini ko'baini. ");
INSERT INTO padNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Abini'iki fori hiki ada kodisai, ahoki'iki fori hiki ada. Napaja hoja'iki ada, joiribani'iki ada.” Oniaroa, khai vakhaniha adani ija'ari. ");
INSERT INTO padNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Hari. Aajojahikia ni-bioga'iaki kaho ada kidikajo'o joina. Siroi vania hojaha ada aajojahiki. Hari hi'ihi ida kidibadani, kidiabi'i gorana joi'aha. Binamaakarihi ida vagorana, bikamitha'ihi ida música ithoni, ija'ari vikhajoki, vaahiaki hiki. ");
INSERT INTO padNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Oniania, bibaranaha'aha ada honai abono, binana'dohi'aha: “Nahina mani ida música-ra agorana bodinia na'ithoja?” ");
INSERT INTO padNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Honai abonoa bigathanihi ida kidina'dohi: “Ada joiribani'aha kadakajo'o. Ni-kavamoniki, ni-pohimajaki, ni-abiniki jaboni. Oniani ida kadabi'i 'daama kahidari dorona basinaki abinina-ra vahonariahivini hija, 'bai jahaki amonahaja kaimoni kidimoni.” ");
INSERT INTO padNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hari. Ihamahi'aha ada aajojahiki, ni-binofiki ida vagorana o'oina. Oniaroa, khaonani'aha ada kidiabi'i kidiania. Kidisai-ra ni'aha: “Kodisai, onofiki ida io'oini akadiania.” O'oina-ra nofiravini kaba'i, kidiabi'ia bikaboa'ihaha'oadahaha. ");
INSERT INTO padNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Aajojahikia bini'aha ada kidiabi'i: “Papai, badara ipohiki bada oniha'oadahaki ho kadaimoni. Kadabadani abono fori ohiha'oadahaki ho. Ni-iathini-ra onaabariki hoaranija. Jahani kaba'i ida kodibadani, ni-nahina hora ino'aki. Ni-boji dorona hoarana hora ino'aki kodimoni, onamonahaja kaimoni ida 'bai jahaki, kodiva'ahi khama khai akhanijabanaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hi'ada kadaisai hoariha binakavithimahahavi'iki ida kadajiniro. Gamo vakadihojai asohiriki-ra va'ora avavadionika'oaki ada. Joi'aha ada kadaisai, ivahonariahi'aha ada 'daama kahidari dorona basinaki abinina kidi'bai kaimoni.” Niha ada aajojahiki. ");
INSERT INTO padNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Oniaroa, kidiabi'ia bini'aha: “Kodisai, mahi hahavi vani kodiania ihojaja. Nahina hahavi ovahojaki, kadani ida jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kadakajo'o joina-ra khai ani'avini jahaki hari. Khai akhanina mani ida ihinika kidimoni onamonahavini hija. Abini'iki fori hiki ada kadakajo'o, ahoki'ianahi fori hiki ada. Napaja hoja'ina, joiribani'iki ada.” Niha ada vakadiabi'i. Anokhomi'ihi ida rajomi kavaranihia Jesus vara va'ora ni'avini hiki. ");
INSERT INTO padNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hari. Oniaroa, Jesus va'ora vara ni'aha adani kidipohi rajomi kavaranihia: —Hojaki ada ka'da'di kanahina'ahapikiki. Hojaki jaboni ada ka'da'di kahonai abono, ovaria biakadava'ahahavi'iki ida kidika'da'di kanahina, inisika hiki. Hari. Ija'ari vahoariha vani'aha ada ka'da'di: “Kadahonai abonoa binakavithimaki ida kadajiniro.” ");
INSERT INTO padNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hari. Oniaroa, ka'da'dia bihonariaha ada kidihonai abono khana. Bini'aha: “Vahoariha vara ira vavani'avini kodijiniro-ra inakavithimavini-ra vakahivini. Ni-iakadava'ajahakiki ida kodijiniro. Inajiri bana ida papira, va'ora oogara kaimoni adani ija'ari kodijiniro-ra variha'iki. Jiniro abosiriki kapapirani-ra onokivini naothinia, ni-onofijanaki ida kodihonai abono ihini.” Niha ada ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hari, honai abonoa bikava'ibodivarani'ihi ida kidika'da'di athi. Abono-ra ni'aha: “Kodika'da'dia ni-binofijanaki ida kidinahina oakadava'avini. Niha oniki koda ho? Odanorina mani ida badani khanaki-ra okaabokaravini hija. Ni-okaabokaki ida nami khorahani kabadanihi. Vahoariha vakadiania jiniro-ra okanikhariavini ova'i-ra anaipahihiki bana ho. Niha oniki koda ho? ");
INSERT INTO padNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hai! Ooga'oamanija bana ida bada oni'aki kaimoni. Inisika kajinironi abosiriki kapapirani-ra onamonahahi, inisika abosiriki kajinironi onapa'itxihi. Hora vavajahaki bana adani vahoariha. Kodika'da'di kainisika-ra oakadava'ajanarihi, vagorana hora vagathanijahakiki bana adani.” ");
INSERT INTO padNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Abono-ra nava'ibodivaranijora'aha ada honai abono. Oniaroa, va'ora baranaha'aha adani makhira kidika'da'di kainisika-ra naabosi'iariki. Binana'dohi'aha ada hoarana: “Nihafori himania ida inisika kajinironi kodika'da'di-ra inaabosi'iaravini hiki?” Bigathani'ihi ida kidina'dohi: ");
INSERT INTO padNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Okapavakari'iki ida basina kabavini karaho 100 hiki ipohini. Ni-abosi'iaki ida basina.” Niha ada makhira. Oniaroa, ka'da'di kahonai abonoa bihonaria'aha: “Hidavani papira basina kaidivani kakapapirani. Inapa'itxi bana ida basina kaidivani kajinironi. Inajiri bana ida basina bavini 50 hiki ipohini.” Niha ada ka'da'di kahonai abono. ");
INSERT INTO padNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Makhira binajirivini naothinia, ka'da'di kahonai abonoa binana'dohi'aha ada hoariha: “Ivani, nihafori himanija ida inisika kajinironi inaabosiriki?” Makhira bigathani'ihi ida kidina'dohi: “Okapavakari'iki ida karagoahi kaso'oroni 1 mil hiki ipohini. Ni-abosi'iaki ida karagoahi okapavakari'iki.” Ni'aha. Oniaroa, ka'da'di kahonai abonoa bihonaria'aha: “Inapa'itxi bana ida karagoahi kaidivani kajinironi. Inajiri bana 800.” Niha ada ka'da'di kahonai abono. ");
INSERT INTO padNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hari. Oniaroa, ka'da'dia bikamitha'ihi ida kidihonai abono varani hina. Bini'aha: “Jaharini kaba'i ida kodijiniro-ra iakadava'ajahakiravini, jahaki ida ikava'ibodivaranijora'avini kadamahi. Honai abono ogahaki i.” Oniaroa, Jesus va'ora nava'isohivini ida rajomi kavaranihi nahina hini. Va'ora ni'aha: —Deu-ra vanofirikia avigaki ida vakadinahina-ra vakava'ibodivaranijoravini a'ba'dija kaimoni. Deu-ra vanofikia ni-avigajahakiki, ni-vakava'ibodivaranijoraki. ");
INSERT INTO padNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ka'da'di kahonai abonoa bikava'ibodivaranijoravini mani ida vakanahinariki-ra va'ora kakodiavini hija. Binofiki ida kidijiniro ihimini naothinia va'oaniaro maina vakajoamoravini. A'onivani jaboni va'ora vakajoamora bana adani vakanahinariki mahija avakadinahina a'ba'divini Deus kania. Avakaikahini avagahinahi. ");
INSERT INTO padNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oniani ida a'onira onava'isohivini hija. Ija'aria biogajahakihi ida hoariha kanahina pa'itxi-ra akadava'avini; biogahi jaboni ida nahina karaho-ra akadava'avini. Ija'aria biogarihi ida hoariha kanahina pa'itxi-ra akadava'ajahakivini; ni-biogaki ida jaboni hoariha kanahina karaho-ra akadava'avini. ");
INSERT INTO padNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Avarigarihi ida hoariha kanahina kaidivaki-ra avarakadava'avini; ni-Deus a'onira no'aki kidinahina kaidivakia avarakadava'aki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Avarakadava'ajahakirihi ida hoariha kanahina. Ni-vahoariha no'ai hini vanofiki avakadimoni hini. ");
INSERT INTO padNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hari. Honai abonoa ni-bikaabokaki ida ka'da'di vi'bamiki vaathi-ra naabahaha'oadahavini. Bivajahaki ada ka'da'di hoarana, athi-ra naabavini jaboni. Bada bini'avini oadani ida ka'da'di kabadani, ni-bikaabokaki ida ka'da'di hoariha athi-ra naabavini, oniani ida bikajonivini hija. Ka'da'di ada Deus. Ka'da'di fori hiki ida jiniro. Ija'ari va'ini-ra nahonariahihivini fori hiki ida jiniro. Ija'aria biva'ahavini oadani ida jiniro va'ini nahonariahihini hini, ni-biva'ahaki ada Deus va'i nahonariahihini hini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hari. Farisioa vakamitha'ihi ida Jesus athi. Jiniro-ra vanofijahakivini mani ida Jesus athi-ra vakanahahanihavini hija. ");
INSERT INTO padNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Oniaroa, Jesus va'ora ni'aha: —Vahoariha avakadihojai-ra vada vani'ahi; avajahaka'oaki a'onira vavanihaha. Deus vania biogaja ida avakadiva'ibodivarani. Ija'aria vavajahaki ida avakadihojai. Deus vania bivajahapa'itxirija ida — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Oniaroa, Jesus va'ora ni'aha adani ija'ari vajoroniki: —Moisés kohana binajiri'bo'da'iki ida Deus kava'isohihi jiriki. Deus athi namoniva abonoa vanajiri'bo'da'iki jaboni ida Deus va'ora nava'isohijoravini hi'iki. João Batista kharina oadani, ija'aria mitha vani'abakhiahi ida Deus athi vanajiri'iki. João Batista naothia kama'da'iki ida Deus monina jahaki akarafarakhama'ini. Ija'aria vakamithaki ida Deus ka'da'di hina kavaranihi. Vanofiki afohanana ida Deus va'ora vaka'da'divini, oniani ida kidiania vakaikahina vaabono avanadodovini hija. ");
INSERT INTO padNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hari. Asia vara ni'aha ada Jesus: —Ihimiki bana ida nama, arabo hiki. Ni-ihimirihi ida Deus kava'isohihi jiriki. Ni-athi pitani pa'itxi hoarani Deua vara bivani'aki avisonirihi. ");
INSERT INTO padNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hari. Deua bivajahariki ida makhira kidigamo-ra nahojahavini, gamo hoariha-ra anakaravini. Ni-asohipa'itxiki ida kidihojai. Makhira hoariha bianakaraki ida gamo kidimakhira binahojaha'iki, hi'ada makhira jaboni badani Deua bivajaharikia kabadaniki ada. Adultério oniki ida vakadibadani niki. ");
INSERT INTO padNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Asia vara ni'aha ada Jesus: —Hojaki ada makhira kanahina'ahapikiki. Bikaimahaki ida makari kaidivaki. Va'ora kaboa'ibakhiaki adani kidiva'ahi ihinika karaho ko'baini-ra vahara kaimoni. Ni-nahina-ra kainamoki ada makhira. ");
INSERT INTO padNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hari. Hojamaniha ada makhira hoariha kanahinariki, onina Lázaro. Samosamohi na'bahaki abani hiki ada Lázaro. Oniaroa, kanahina'ahapikiki gorana banininija hojabakhiaha ada Lázaro. ");
INSERT INTO padNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Binokhahi ida hoariha ko'bai ahabarini abono-ra vidorahavini kaimoni hini. Jomahia kidisamosamohi avakaabanaha. ");
INSERT INTO padNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hari. Oniaroa, abini'aha ada Lázaro. Deus ibavi kaija'arinia avisa'aha Deus ibavia. Akadi'arahoda okhananavaki Abraão kohana 'dihana vithi'aha ada Lázaro. Vi'baijabanaki adani ija'ari Deus kania, khai vakhanina. Hari. Abini'aha ada makhira kanahina'ahapikiki jaboni, ka'damaha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ija'ari abini'iki abononi ibavinia okha'aha. Oniaroa, bikamithahi ida imana 'banani karaho Ibavi Jaharika'oaki kania. Hari. Napaja nobanija va'ora anokifiani'aha adani Abraão, Lázaro khama. Abraão 'dihana hojaha ada Lázaro. ");
INSERT INTO padNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Oniania, abono-ra vibaranaha'aha: “Bi'i Abraão, hora va'adi bana. Ihonaria bana ada Lázaro sa'a nokhoni-ra na'bavini paha mahija oabani-ra na'bavini. Afora'oamanija hida oabani. Okamithaki hida oimana 'banani karaho, siho kakhororoki kabodinia ohojaki ho.” ");
INSERT INTO padNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraãoa bini'aha: “Iniani, kodisai. Ikava'ihokiria ida iabinirini oadani kadanahina jahaki-ra igathanibakhiavini. Lázaro, ni-nahina jahaki-ra gathaniki abinirina oadani. Hidakaba'i Lázaroa khai bini'a'iki ida Ibavi Jahaka'oakia hoja'ina. Imaina, ikamitha'iki ida iimani 'banani karaho. ");
INSERT INTO padNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aakhaninihakhamaki ida hodi bihiani arafiaki, oadaki, rabodiki. Ni-nahina okafianini-ra kaabokaki. Ni-idiaja hodi pitanija hojaki, ni-kafianini-ra kaabokaki jaboni. Iborohiha'oadahaki i.” Niha ada Abraão. ");
INSERT INTO padNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Oniaroa, Abraão-ra ni'aha ada makhira: “Bi'i Abraão, ikarona'a o bana Lázaro kodiabi'i gorana okhana. ");
INSERT INTO padNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kodikajo'o sa'ai kahoarani vihiki vahojaki kodiabi'i gorana. Va'ora kaabaniva ada Lázaro mahija imai 'banani arafiani ibavini kania vikharavini.” ");
INSERT INTO padNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraãoa bini'aha: “Iniani. Kadakajo'oa vavahojaki ida Deus athi kapapirani, Moisés kohana, Deus athi namoniva abono vahoariha khama vanajiri'iki, kadakajo'o-ra va'ora kaabaniki kaimoni. Jakana papira athini-ra vanaaba'ava kaho.” ");
INSERT INTO padNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Makhira bini'a'ianaha: “Iniani. Bi'i Abraão, arajomarihi ida Deus athi kapapirani. Lázaro kohana ahoki'ina-ra vanokiha; ni-vakajari'dajanaki ida Deus athi. Vakava'ipahinika'oahi ida Jahari kahojai.” ");
INSERT INTO padNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraãoa bini'aha: “Iniani. Moisés kohana athi-ra vakajari'daki adani, vakajari'daki jaboni ida Deus athi namoniva abono vaathi, vakajari'daki bana jaboni ida ahoki'iki athi.” Niha ada Abraão. A'diahi'ihi ida rajomi kavaranihi, Jesus vara va'ora ni'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Oniaroa, Jesus va'ora ni'aha adani kidipohi: —Ija'ari va'ora kaborobakhiaki adani ija'ari vahoariha, Jahari kabadania vakabadanira kaimoni. Hoariha-ra kaborovinia kabadanihi, Deua binaabosiki bana ida nahina jaharikia. ");
INSERT INTO padNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jahaki ida ja'di karaho ija'ari mathani ahoni paha bihiakia hokahini ahidaja kaimoni ida ija'ari kodija'ari-ra kaboroboroki. Jahari'oamanija ida oipohina-ra kaborovini Jahari kabadania kabadanija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Iabono akava'igairi bana. Ikaabani bana ada iigamini Jahari kabadania kabadaniki mahija bikava'ipahinivini. Bikava'ipahinihi; hari'a ikava'ihokijana bana ida kidihojai asohiriki. ");
INSERT INTO padNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Khahi ida iigamini, ira ni'ahi: “Jahari'oamanija ida kodihojai kadania, hora akariaka bana.” Nihi. Iakariaka bana ida iigamini. Hari'a ikava'ihokijana ida bada bini'a'iki. Kidihojai asohiriki ira naihamahi'ianahi; kadania ira kanikharia'ianahi, iakariaka'iana bana! Mahi hoarani bada bini'abakhiaki ida ivajahariki, ira kanikhariabakhiahi jaboni, iakariaka bana jaboni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hari. Oniaroa, Jesus athi avavaadahaoniva abonoa vakanikharia'aha: —Aajo, haria kajoamora bana mahija avijavavini ida Deu-ra akajari'daravini. ");
INSERT INTO padNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Oniaroa, Jesus va'ora ni'aha: —Pa'itxini kaba'i ida Deu-ra avakajari'daravini, Deu-ra avakanikhariavini hihi, a'onira no'avini hihi ida avakanikhariaki. Deu-ra avakajari'daravini oadani, avakaabokaki ida ihi'ai avani rasohani-ra avahonariavini: “Rasohahi oni 'damani abohani, paha bihiakia irakhaihi.” Ihi'ai avani-ra avahonariahi bana, Deu-ra avakajari'darihi, oniani ida Deua binanamithavini hija bana avakanikhariaki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Hari. Vara ni'ianaha ada Jesus: —Rajomi kavaranihia okavaraniki bana ho. Ka'da'di ihiki i. Ivahojaki ada kadahonai abono. Kadahonai abono ira kasiroihaki, va'ora akadava'aki jaboni adani kada'ovilia. Mahi oadani bada bini'aki ida badani ihonariavini hi'iki. Hari. Mithani vaivaini joina vani ni-kadahonai abono-ra ini'aki: “Hidiaja kha mahija i'baivini.” ");
INSERT INTO padNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ni-niki ida kadavarani. Kadahonai abono-ra ini'ahi: “Hora ko'baiha'a. A'diahihi ida 'bai, hora kavikha bana oibavia mahija o'bai'imidiavini. O'baina naothinia imaina i'baihi.” ");
INSERT INTO padNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nimania ida ka'da'di kidihonai abono-ra vara ni'avini. Honai abonoa bada bini'ahahavivini kaba'i ida kidika'da'di bihonariavini hiki, ni-kidika'da'dia bini'aki: “Ijaha'oamanija kodibadani-ra bada ini'ahahavi'iki i.” Ni-niki ida kidivarani. ");
INSERT INTO padNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Onivani fori avihini jahaja. Deus kahonai abono avihiki a'oni. Deus a'onira honariavini hi'ikia avakabadanihahavi'ini naothinia avaabononi vani'a'a bana: “Ni-nahina arihijahakirihi. Deus kahonai abono ka'oa arihiki hari. Haria honariavini hiki ida badani jahakia akabadanina. Ni-nahina jahani arafiakia akabadaniki.” ");
INSERT INTO padNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hari. Oniaroa, Galiléia kaarabonia ajihiha ada Jesus. Samaria kaarabonia okafianiha, Jerusalém sidaji-ra anikhaha'aha. Aadahaonina oadani ibavi kagoraki kania maakarinia akhano'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hari. Sidaji banininia vahojaki adani 10 vihiki makhira vakavamoniki. Asafi namani-ra najaharikia vakavamonina mani ida va'ora nahojaja napaja sidaji banininija. Jesus kania avikhana kaba'i, ni-Jesu-ra vanamaakariki. ");
INSERT INTO padNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Oniaroa, vibaranaha'aha: —Jesus, haria va'adi bana. ");
INSERT INTO padNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus va'ora noki'aha, va'ora ni'aha: —Ai vihi'a bana mahija sasidotxi vakadiania avarikhavini. Sasidotxi-ra vananokiahivini hi'oni avaasafini namani jaha'iki — va'ora ni'aha ada Jesus. Oniaroa, avikhana kaba'i vajahahahavi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hari. Hoarana abono-ra noki'aha kavamonijanarina, ajoi'aha Jesus kania. Samaria kaaraboni kaija'arini ada makhira ajoi'iki. Ajoina oadani bodi'barahaha Deus jahana-ra khai ni'avini. Jesus kania akhano'aha, ");
INSERT INTO padNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hari. Jesus viaha kajo'atharari'aha, Jesu-ra khai ni'a'aha: —Jesus ijahaki i kodimoni ihini, hora inajaha'iki i — niha. ");
INSERT INTO padNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesua bini'aha: —Va'ora onajaha'iki adani makhira vaipohina 10 vihiki. Deu-ra khai ni'a'iki ada hihada makhira hoarana, akadija'ari hirina kaba'i. Adani hanaja vahojaha vahoariha 9 vihiki? ");
INSERT INTO padNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Niha vakhanimanira adani vahoariha vajoiriki Deu-ra khai vani'ara kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hari. Jesua bini'aha ada jaha'iki: —Gaa'a, adaha'a. Hora ikajari'daravini mani ida ira onajahavini hi'ia — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hari. Oniaroa, farisio vaipohirikia vanana'dohi'aha ada Jesus: —Asia mani kamahini ipohija ida Deus ija'ari hahavi-ra va'ora vaka'da'divini kama'dani? Jesua vakadina'dohi bigathani'aha: —Nokiariki bana ida Deus ija'ari-ra vaka'da'divini kama'dani. ");
INSERT INTO padNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni-ija'aria binava'isohirihi ida hoariha: “Vada ini'a hida kama'dani.” Ni-ija'aria bini'aki jaboni: “Vada ini'a oni kama'dani.” Nokiarihi bana ida Deus ija'ari-ra vaka'da'divini. Deua bivaka'da'divini ida ija'ari va'ini bodinia. ");
INSERT INTO padNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hari. Jesus va'ora nava'isohi'aha adani kidipohi: —Khaki bana ida mahi hora avanoki'ianavini-ra avanofivini kamahini, hidakaba'i hora avanokivini fori hiki. Ohojana kaba'i avakadiania, ni-hoaranija hora avanoki'ianaki hora avanokivini fori hiki hidakaba'i. ");
INSERT INTO padNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vahoariha a'onira vani'aki bana a'oni: “Vada vani'a hada vani Cristo.” Vahoariha a'onira vani'aki bana a'oni jaboni: “Vada vani'a hi'o Cristo.” A'onira vani'avini kamahini, hari'a bana vanavanavanaha'a. ");
INSERT INTO padNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bahi korikorihana nama-ra navagajorakivini vani fori hija bana ida ojoina kamahini. Hovani ija'ari hahavi vakadi'aajo ho. A'onira onava'isohijoravini hiki ida bana okha'ianana viahani namithaki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Oimana 'banakaraho'imidiaki bana ho. Ija'ari hidakaba'i vahokiki hora vakajoniki. ");
INSERT INTO padNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé kohana ava'doroa o'oina viahani kari fori hiki bana ida ojoina kamahini. ");
INSERT INTO padNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé o'oirina oadani, ni-ija'aria vakava'ibodivaranipa'itxiki ada Deus. Ni-vanofiki ida Deus athi-ra vanaabavini. Vakava'ibodivaraniha'oadahaki ida vakadimahi, vakadi'bai, makhira gamo khama avaakarana hiki. Noé ava'doroa o'oina naothinia, Deua bikarona'iki ida paha karaho, avahidahahavi'iki adani ija'ari. ");
INSERT INTO padNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hari. Onivani fori hija ida jaboni Ló kohana hojana. Sodoma sidajia akara'orina oadani, ni-vanofiki ida Deus athi-ra vakamithavini, ni-vakava'ibodivaranipa'itxiki jaboni ada Deus. Ija'ari hahavi vi'baibakhiaki, vakapavakariki ida vakadinahina, pavakari vanihaki jaboni ida vakadinahina, varakhajahaki adani, vanamonahaki jaboni ida vagorana. Nimania ida vakadimahi. ");
INSERT INTO padNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hari. Ló Sodoma sidajia akara'ona naothinia, Deua bikanakhanorari'ihi ida siho kaha'dini, siho kanadarani kihiki, va'ora naabinihahavi'aha adani Sodoma sidaji kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Onivani fori hija ida jaboni bana onokiana kamahini. ");
INSERT INTO padNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Va'ora onava'isohijoraki bana adani ija'ari gora 'da'dini a'ani sohiriama'okia vahojana onokiana kamahini: “Avigajoraki'a bana. Hari'a avikhajakosi bana avagorania, avakadinahina-ra avaranikhavini.” Va'ora onava'isohijoraki adani ija'ari vakadisiroia vahojaki, vagorana avajoirara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Vakava'ihoki bana ida Ló kagamo kohana varani hini. Vada va'ora ni'aribanivini mani ida napohimajani hi'ia. ");
INSERT INTO padNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hari. Ija'ari va'ini bodinia abononi ni'ahi: “Jesus kaija'ari ohina-ra avigaha adani vahoariha; hora vanaabiniha. Jesus kaija'ari ohirina-ra okahiki bana ho.” Nihi ida ija'ari va'ini bodini vara nini, abinini kamahini Ibavi Jaharika'oaki kania okhahi. Ija'ari va'ini bodini abononi ni'ahi: “Jesus kaija'ari ohina mani ida vahoariha hora vanaabinivini-ra vanofivini hija. Oabinihi; oabinihi. Jokoa kidija'ari ohirina-ra okahirihi.” Nihi ida ija'ari va'ini bodini vara nini, abinini kamahini Ibavi Jahaka'oaki kania okhahi. ");
INSERT INTO padNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hari. Onokiana kamahini joma vavadiki bana adani ija'ari vi'bamiki vagorana. Deua bianiki ida bana ija'ari hoarani, hojaroniki ida bana ija'ari hoariha. Ka'oa hiki ida a'onira onava'isohijoravini hiki bana. ");
INSERT INTO padNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Gamo vi'bamikia vigihahi ida boda jo'doni. Deua bianiki ida hoarani. Hojaroniki bana ida hoariha. Makhira vi'bamiki bada vakhaniki jaboni bana vakadisiroia. Deua bianiki bana ada hoarana. Hojaroniki bana ada hoariha — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Oniaroa, ipohina vanana'dohi'aha ada Jesus: —Aajo, hanaja vania bana namithaja ida haria ini'avini hi'iki? Jesus va'ora ni'aha: —Aba'oi 'bathaki hojaroni'ihi; vajorahaki adani majori. Onivani fori vihira bana adani vahojaroniki bana, 'banakarahoki bana ida vaimana — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hari. Oniaroa, Jesua vara bivani'a'ihi ida rajomi kavaranihi kidipohi ka'ojomo'ini hiki kaimoni, Deu-ra vara vani'ahaha'oadahara kaimoni. Bigathaniravini oadani ida Deu-ra kanikhariaha'oadahavini hiki, vakanikhariaki ida. Niha ada Jesus: ");
INSERT INTO padNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Hari. Sidajia hojaha ada ija'ari nasohiva abono jahariki. Va'i bodinia vara ni'aha: “Ni-onofiki ada Deus. Ni-okava'ibodiki ida vahoariha kodibadani-ra vavajaharavini.” ");
INSERT INTO padNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hari. Hojaki jaboni ida kaariha. Ija'ari nasohiva abono kania okhabakhia'ihi ida kaariha, bini'aha: “Hora kajoamora bana. Ija'ari hora nofirikia binofiki ida kodinahina-ra saarivini. Hora kakodia bana mahija hora najahariharijanaravini.” Nihi ida gamo. ");
INSERT INTO padNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Hari. Masiko ipohiki radahaha. Kaariha bikanikhariabakhiavini kaba'i ida kajoamorahi hini, ni-binofiki ida kaariha-ra najaharihariki-ra kaabanivini. Oniaroa, abono-ra ni'aha: “Deu-ra onofiravini kaba'i, ni-okava'ibodiki ida vahoariha kodibadani-ra vavajaharavini, kaba'i ni-okaabokajanaki ida kaariha hora kanikhariabakhiavini. Kaariha ova'i-ra kai'dokabakhiavini mani ida kidi'aathidanoarari athini onasohivini hija, kidinahina bikanabadanihajanaria kaimoni. Hora kanikhariabakhiavini hora kanabajadi'iki fori ohiki ho.” Abono-ra ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hari hihi ida rajomi kavaranihi, Jesus va'ora nava'isohi'aha: —Vakava'ibodivaranijahaki ida ija'ari nasohiva abono athi. Kidihojai asohirini kaba'i, bikajoamora'iki ida gamo, athinia va'i bikai'dokarara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hari. Jaha'oamanira ada Deus. Ovaria bikamithaki bana ida kidija'ari mahi, joma hikia kanikhariabakhiana hiki. Ni-bikajoniki bana ida va'ora kajoamoravini. Jorakia bigathaniki ida vakanikhariavini hiki. ");
INSERT INTO padNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ka'oa hiki hida kodivarani. Ija'aria vanofiki ida Deus kaija'ari-ra va'ora vanajahariharivini, kidija'aria vakanikhariavini hiki ida va'ora kajoamoravini, bona va'ora kajoamorajorakiki adani. Hovani ija'ari hahavi vakadi'aajo ho. Ojoina kamahini va'ora okaragamanira koda adani ija'ari Deu-ra vakajari'dariki? ");
INSERT INTO padNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hari. Oniaroa, vahojaha adani ija'ari vaabono vakava'ibodivaraniki afohanana: —Hovani ojahaka'oaki ho, ni-ija'ari hoariha fori ohirihi. Hoariha ni-jahapa'itxiki — vahojana hiki ida vakadiva'ibodivarani. Oniaroa, Jesua vara bivani'a'ianahi ida rajomi kavaranihi hoariha. Jesus vara va'ora ni'aha adani ija'ari vahojana jahani-ra vakahi'badaraki: ");
INSERT INTO padNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Deu-ra khai vani'avini kagorania avikhaha adani makhira vi'bamiki. Farisio ada hoarana. Imposto gathaniva abono ada hoariha. ");
INSERT INTO padNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Avikhajakosi'aha adani vi'bamiki. Ija'ari vaviaha gaakosoa'aha ada farisio hoarana, abono-ra ni'aha: “Deus, khai ira oni'avini hiki ida ohojana. Ni-hoariha kanahina-ra oakabaiki, ni-obo'diaki ida hoariha kanahina, ni-korijanahia okavaraniki, ni-ovavadiki ida hoariha kagamo. Khai oni'aki ida ija'ari vahoariha vakadihojai jaharikia okahojairina. Khai ira oni'avini hiki jaboni ida imposto gathaniva abono fori ohirina. Kabo'dinofiki ada. ");
INSERT INTO padNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Deus, mahi 'bamiki, semana hahavi o'bairina ohojabakhiana vara ira oni'aka'oaja kaimoni. Kodibadani abani hahavi-ra ogathanivini vani, onapitavini ida sa'ai ko'bamihani hini. Oanajoiribaniki pitani hoarani kadania.” Niha ada farisio. ");
INSERT INTO padNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hari. Imposto gathaniva abono ni-okhajakosijahakiki. Bakatha kania hojana kaba'i, Deu-ra vara ni'a'aha. Kidihojai asohirini-ra kaipahivini mani ida nama vada ni'amananirina hija. Makho'ini-ra kakapata'aha, bini'aha: “Deus, hora va'adi bana, asohiri'oamanija ida kodihojai.” Niha ada imposto gathaniva abono. ");
INSERT INTO padNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesus va'ora ni'aha adani ija'ari: —Ka'oa oamani hida kodivarani. Va'i jahajahani gorana joi'aha ada imposto gathaniva abono. Deua biakariakaki ada. Ni-biakariakaki ada farisio. Ija'ari abononi ni'ahi: “Hovani hojai jahakia okahojaika'oaki ho.” Deua bini'ahi hida ija'ari: “Ni-jahaki ida kadahojai. Ni-khai oni'aki ida iabononi ivaboraborahavini.” Ija'ari jahania abononi vaboraborahavini mani ida Deua binava'i'aipahihivini hija bana. Ija'ari abononi ni'ahi: “Ova'i-ra anaipahihiki hida kodihojai asohiriki.” Deua bini'ahi: “Oviaha iva'ini aipahihini mani ida khai ira oni'avini hija.” — Jesus va'ora ni'aha adani vajoroni'iki. ");
INSERT INTO padNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hari. Oniaroa, ija'ari va'ora vavikha'aha adani vakadisai Jesus kania. Vanofiki ida Jesus vakadisai-ra va'ora kajoamoravini. Oniaroa, kidipohi va'ora vanokiha adani ija'ari, va'ora vakaabani'aha: —Hari'a va'ora vavikha va'oani isai. ");
INSERT INTO padNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Oniania, Jesus va'ora baranaha'aha adani isai kidiania, va'ora ni'a'aha adani ipohina: —Jakaho kodiania vikhava va'oani isai. Hari'a va'ora vakaabani kodiania vikhana. Hi'adani isai fori vihiki vani hadani Deu-ra vanofijahakira. Isai vania vanofira ada Deus va'ora vaka'da'dira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Vakava'ibodivarani hida oathi. Isai fori vihi'a mahija Deu-ra avagathanivini avakadika'da'di hi'ara kaimoni. Isai fori avihirihi; jokoa avakadika'da'di hiriha ada Deus, jokoa Deus ibavia avarikharihi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hari. Jesus kania khaha ada judeus kaija'ari vanava'isohiva abono. Bini'aha: —Jesus, ijaha'oamanija. Onofiki bana ida kodimahi anokhomirini. Onofiki ida oabinina kamahini Deus kania ookhana. Hana hini badani jahaki ida bada oni'aja kaimoni, oabinina kamahini Ibavi Jahaka'oakia ookhaja kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesua bigathani'ihi ida kidina'dohi: —Nahina ida ojahana-ra ikahivini hija? Deus oavani ada jahara. Ni-nahina hoariha jahaki. ");
INSERT INTO padNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Iogaki ida Deus kava'isohihi jiriki: “Hari'a ivi'oma oni makhira hoariha kagamo. Hari'a hoariha-ra naabini. Hari'a bo'dia. Hari'a hoariha-ra korijanahia akaraganaha. Ikamitha'a oni kadabi'i, kadamia vihiki ira vara vani'avini.” Nimania hida Deus kava'isohihi jiriki. ");
INSERT INTO padNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Niha ada makhira: —Jesus, isai ohina kari vani onaabahaha'oadahaja hida Deus kava'isohihi jiriki. ");
INSERT INTO padNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hari. Jesua mitha bini'ahi ida kidivarani, bini'aha: —Ida asia mani hojahi badani ahoaraniki bada ini'aki kaimoni. Kadanahina-ra pavakari niha'a afohahavi. Ija'ari vakanahinariki-ra va'ora no'avinihi ida kadajiniro. Deus ibavia nama iokhani kamahini, ni-nahina-ra bana ikainamoki. Kadapavakarihi naothinia, hora vaipohiha'a. ");
INSERT INTO padNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hari. Makhira mitha bini'ahi ida Jesus athi. Kidinahina ahapini gahinai hini varani hini mani ida va'i mokara ni'ani hija. Ni-no'ai hini binofiki. ");
INSERT INTO padNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Oniaroa, Jesua binokiha ada makhira, va'i mokara ni'ina, oniania bini'aha: —Vakanahina'ahapikiki vakadinahina ipohiki-ra vanofivini mani ida Deu-ra vagathaniravini hija, vakadika'da'di kaimoni hina — va'ora ni'avini. ");
INSERT INTO padNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Oniaroa, Jesus va'ora kavarajomiki adani ija'ari cavalo avi jo'onia okhajavarina-ra kaabokaravini fori vihina: —Avi jo'onia cavalo okhajavarina-ra kaabokariki fori vihiki adani vakanahina'ahapikiki. Vakadinahina-ra vanofijahakivini mani ida Deus vakadika'da'di hina-ra vagathaniravini hija, oniani ida Deus ibavia va'ora arakharija. Ni-vakaabokaki ida avikhana. Ija'ari vakadinahina-ra vavakaijokavini oadani, ni-vakaabokaki ida Deus ibavia avikhana. ");
INSERT INTO padNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ija'aria vakamitha'ihi ida Jesus kavarani, vanana'dohi'aha: —Ka'oa mani ida koda iathini, ni-nihanikia ija'ari abononi akava'ijoaki, Ibavi Jaharika'oakia okharia kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Oniaroa, Jesus va'ora ni'aha: —Ni-ija'ari abononi akava'ijoavini-ra kaabokaki. Deus ka'oa ija'ari-ra akava'ijoavini-ra kaabokaki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hari. Pedroa bini'aha: —Mitha ini'a. Harivani akadinahina, agorana, akadija'ari vihiki-ra va'ora anahojahahahavi'iki hari, ira avaipohihaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesua bigathani'ihi ida Pedro athi: —Hai oamani. A'onira onava'isohivini hiki bana, kodipohia binahojaha'iki ida gorana, kidigamo, igamina, kidisai, kidija'ari hoariha vihiki, vara biavani'aka'oaja kaimoni ida omonina jahaki, ");
INSERT INTO padNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ovari abinirina oadani gahinaki bana nahina ipohikia. Nahina gahinana hiki binahojaha'iki-ra aradaki. Abinina naothinia gahinaki jaboni ada bana kidimahi jahaki anokhomiriki Deus kania. ");
INSERT INTO padNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hari. Oniaroa, Jesus va'ora avikhananavapa'itxiha adani kidipohi, va'ora ni'a'aha: —Mitha vani'a, Jerusalém sidaji-ra anikhahaki bana hari. Jerusaléa akaikahina vani, namithahahavija bana ida Deus athi namoniva abono vara hora vavani'a'bo'davini hi'iki. Deus athi kapapirania hojaki ida ija'ari hahavi ka'aajo varani hina. ");
INSERT INTO padNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ija'ari Deu-ra avigariki vasa'a kabodinia akadija'ari hora avarakhaki bana. Va'oaniaro hora avigarahaki bana, varani jaharikia vara hora vani'aki, hora vakai'baivini. ");
INSERT INTO padNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hora vidafiavini naothinia hora vanaabiniki bana adani. Hari, mahi ahoarabakosiki radaha'ihi, oahokiki bana ho. ");
INSERT INTO padNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hari. Jesus kavarani-ra vakamithavini kaba'i adani kidipohi, ni-avigapa'itxiki ida nahina hini va'ora vara ni'avini hiki. Ahojaki ida kidivarani. Ni-avigaki ida Jesus va'ora nava'isohijoravini kavaranihi. ");
INSERT INTO padNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hari. Jericó sidaji onikia maakarinia avakhano'aha adani Jesus, ipohina khama. Oniaroa, makhira kamaodorohaki hagihi vadinia vithima'oki. Jiniro-ra kanikhariabakhiaki ada. ");
INSERT INTO padNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hari. Va'ora kamitha'aha adani ija'ari vaipohiki varadahana, va'ora nana'dohi'aha: —Nahina kaimoni mani ida ija'ari vaipohiki-ra va'ora najoronija? ");
INSERT INTO padNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hari. Ija'aria vagathanihi ida makhira kana'dohi: —Jesus mani ada radahara — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Oniaroa, bodi'barahaha ada makhira kamaodorohaki: —Jesus, ivani Davi kohana kaija'ari namitharonisiagaki i, hora va'adi bana! ");
INSERT INTO padNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hari. Avikhananavakia vakaabani'aha: —Avisoni'a bana. Hari'a bodi'barahajana. Ni-avisonipa'itxiki ada makhira. Vakaabaniha ana'barahana hi'oamanihi. —Jesus, hora va'adi bana! ");
INSERT INTO padNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ogaakosoaha ada Jesus, va'ora honaria'aha: —Avanikha bana ada makhira kamaodorohaki. Akhano'aha, Jesua binana'dohi'aha: ");
INSERT INTO padNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Nahina mani hida inofija kodiania? —Jesus, onofiki hida onokho-ra ianavagahavini — bini'aha. ");
INSERT INTO padNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Oniaroa, Jesua bini'aha: —Inokhoni ha'dini avaga'ava! Hora ikajari'daravini mani ida inokhoni-ra najaha'ia. ");
INSERT INTO padNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hari. Jorakia vagaha'ihi ida nokho 'ba'dani. Jesus naothia kasiagajabana'aha. Deu-ra khai ni'aha ada makhira. Ija'ari vaipohikia vanokiha ada makhira nokho avagaha'iki, Deu-ra khai vani'ahahavi'aha jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hari. Jericó sidajia akhano'aha ada Jesus, okafianiribani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jericóa hojaki ada makhira Zaqueu oniki. Imposto gathaniva abono vakadika'da'di ada. Kanahina'ahapikiki ada. ");
INSERT INTO padNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hari. Zaqueua bikamithahi ida varani, Jesus radahana. Binokivini binofiki ada Jesus. Pasapasaki ada. Ija'ari vaipohiki Zaqueu viaha vahojaki. Ni-nihanikia Jesu-ra nokiki. ");
INSERT INTO padNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Oniaroa, ki'darahahaha ada Zaqueu Jesu-ra anaviahanokha'avini. Hagihi vadinia figira avani kania okasi'aha, Jesus radahaki-ra nokivini-ra nofivini. Vikha'aha adani Jesus, ija'ari vaipohiki vahararana adahana. ");
INSERT INTO padNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Figira avani kania avakhano'aha, figira miini-ra vada ni'amanani'aha ada Jesus, Zaqueu-ra ni'a'aha: —Zaqueu, jorakia ogari'a bana mahija igorania aokhavini. Kadania ohojaki bana ho hidakaba'i. ");
INSERT INTO padNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hari. Ogarijoraki'aha ada Zaqueu, khai bini'a'ihi ida Jesus kidiania hojana-ra kahivini. ");
INSERT INTO padNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vahoariha khai vani'apa'itxiriha ada okhana. —Makhira hojai asohirikia kahojaiki gorana okhaki ada Jesus — vakhani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oniaroa, gorana vahoja'aha, gaa'aha ada Zaqueu, Jesu-ra ni'a'aha: —Jesus, mitha ini'a hida kodivarani. Ni-asohiki ida kodibadani bada oni'aki afobakhia, oniani ida kodijiniro-ra onapitavini hija bana. Ija'ari vakanahinariki-ra va'ora ono'avini hiki bana ida pitani hoarani hoarahanana. Onajoiki bana ida nahina obo'dia'iki vahoariha vakadiania. Ija'ari kanahina hoarani-ra obo'dia'iki ho, onajoiki bana ida ako'bamahakhamaki afohanana — niha ada Zaqueu. ");
INSERT INTO padNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Oniaroa, Jesus bini'aha: —Deus va'ora akava'ijoa'iki hadani Zaqueu, kidija'ari gorana vahojaki. Hihada makhira Abraão kahanodi kharonisiagaki jaboni hada. ");
INSERT INTO padNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hovani ija'ari hahavi vakadi'aajo ho. Hora rakhaki hida va'ora onako'dihavini adani ija'ari Deus kahagihi-ra varagariki va'ora oakava'ijoara kaimoni — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hari. Ija'ari vaipohikia vakamitha'ihi ida Jesus Zaqueu khama vara vakhanina, vaabono vakani'akhama'aha: —Jerusalém sidaji-ra anamaakarihi. Jesus kaikahina vani kama'daki koda bana ida Deus ija'ari hahavi-ra vaka'da'divini kamahini — vaabono vakani'akhama'aha. Oniaroa, Jesus vara va'ora ni'a'aha adani ija'ari vaipohihana vihi'iki. Vara bivani'ahi ida rajomi kavaranihi, avigaja kaimoni ida Jerusaléa kaikahina kama'dajorakiriki Deus ija'ari hahavi-ra vaka'da'divini kamahini. ");
INSERT INTO padNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Niha ada Jesus: —Oabono okavarajomivini hiki bana ada makhira kanahinaki arabo hoariha napaja hiki-ra anikhaha'avini. Hari. Ajihi'aha ada ka'da'di. Kidiabi'ia bihonariavini hiki ada kidisai arabo hoariha kaija'arini-ra vaka'da'dihavinia. Araboa gahinana naothinia joira kaimoni ada ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hari. Ajihina viahania ada ka'da'di, va'ora baranaha'aha adani kidihonai abono 10 vihiki vaipohina kidiania vikhana. Va'ora no'avini hiki afohanana jiniro 'ba'dani hoarahanana. Ouro ida jiniro 'ba'dani, kaidivaki ida. Va'ora ni'a'aha: “Ojoirina oadani bada vakhani'a mahija kodijiniro 'ba'dani-ra avarana'ba'divini.” ");
INSERT INTO padNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kidiarabo kaija'arinia ni-vavajahapa'itxiki ada ka'da'di. Ni-vanofiki ida vakadika'da'di hina. Oniaroa, ajihina naothinia va'ora vakarona'aha adani vaathi avikhava abono arabo-ra avanikhaha'avinia vakhanira kaimoni: “Ni-anofipa'itxiki ada makhira akadika'da'di kaimoni hina.” Vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Oniaroa, arabo napaja hiki hojana ada makhira, binakama'da'ihi ida ija'ari-ra va'ora vaka'da'divini kabadanihi. Oniaroa, joi'aha kidiaraboa. Kaikahi'aha, va'ora baranaha'ianaha adani kidihonai abono kidijiniro gathanina vihi'iki. Binofiki ida kidijiniro vagathani'iki ipohini-ra ogavini. ");
INSERT INTO padNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hari. Kidiania kha'aha ada kidihonai abono hoarana, bini'aha ada kidika'da'di: “Hora ino'avini hi'iki ida jiniro 'ba'dani kaidivaki hoarani. Bada onina vani oana'ba'di'ia ida jiniro, 10 hiki hida ipohini ovahoja'iki.” ");
INSERT INTO padNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kidika'da'dia bini'aha: “Jaha'oamanija ida kadabadani. Ivani honai abono jahaki i. Kodinahina pa'itxi-ra iakadava'ajahakivini mani ida ka'da'di ira onihavini hija. Onofiki ida sidaji 10 ipohini kaija'arini-ra va'ora ivaka'da'divini.” ");
INSERT INTO padNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Oniaroa, kidiania kha'aha ada kidihonai abono hoariha, bini'aha ada ka'da'di: “Hora ino'avini hi'iki ida jiniro 'ba'dani kaidivaki hoarani. Bada onina vani oana'ba'dija ida jiniro 5 hi'iki ipohini hida ovahoja'iki.” ");
INSERT INTO padNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ka'da'dia bini'aha: “Ira ohonariavini 5 sidaji hiki ipohini kaija'arini maina-ra ivaka'da'divini.” ");
INSERT INTO padNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Oniaroa, kaikahi'aha ada honai abono hoariha, bini'aha ada kidika'da'di: “Hida vani kadajiniro 'ba'dani. Okarafoa'iki ida kadajiniro makaria, oanahoja'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ira oogaki ho. Ka'da'di ihini mani ida ija'ari iathini-ra naabaravini-ra iva'aharavini hija. Ka'da'di ihini mani ida hoariha kania kidinahina isaarivini hija, kidirakhajahi jaboni ianivini hija.” ");
INSERT INTO padNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Hari. Ka'da'dia bigathanihi ida honai abono athi: “Honai abono jahariki oamani i. Hora ikava'ibodivaraniki i: Arabo kaka'da'dini hiki ada kodika'da'di, oniani ida athi onaabaravini-ra va'aharavini hija. Bisaariki ida jaboni hoariha kanahina, bianiki ida rakhajahi bononi birakhaiki. Nini vani ikahija ida ohojana. Ni-asohipa'itxiki ida bada inirini kodijiniro-ra iana'ba'diravini, oniani ida ira onaima'banavini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sidaji kajinironi-ra avakadava'aki vakadiania kodijiniro-ra iarakhaja vaha; okaikahina kodijiniro-ra vanajoiki adani, hora vano'avini hiki vaha jaboni ida vakadirihai abosini. Nahina mani ida va'ora ikanarihairavini hija?” ");
INSERT INTO padNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Oniaroa, ka'da'di va'ora ni'aha adani ija'ari vahoariha vahararana vahojaki: “Visaari oni jiniro 'ba'dani hoarani bivahoja'iki. Kodihonai abono hoariha-ra vano'avinihi bana oni jiniro. Hi'o jiniro 'ba'dani 10 hiki ipohini-ra vahojaki vani-ra vano'avinihi bana.” ");
INSERT INTO padNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Honai abono vahoariha vani'aha ada vakadika'da'di: “Bivahoja'iki ida jiniro 'ba'dani 10 hiki ipohini. Inofimanija koda ida jiniro 'ba'dani hoariha ano'a'ianavini?” ");
INSERT INTO padNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hari. Ka'da'dia bigathani'ihi ida vaathi: “Ka'oa hida kodivarani a'onira oni'avini hiki. Deua bino'aki ida ija'ari kidinahina biakadava'aja kaimoni. Biakadava'ajahakihi; Deua bianaipohihi ida nahina biakadava'a'iki. Ija'aria biakadava'ajahakirihi ida nahina pa'itxi Deua bino'avini hiki; Deua bianiki bana ida nahina pa'itxi bivahojaki.” ");
INSERT INTO padNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Asia vara niki ada ka'da'di: “Va'ora vavikha adani ija'ari hora vavajahariki, vakadika'da'di ohina-ra vanofiriki. Va'ora vavikha kodiania mahija va'ora avanaabinivini.” Niha ada ka'da'di — va'ora ni'aha ada Jesus. Jesus abono-ra kavarajomivini hiki ada ka'da'di. Vara va'ora ni'avini hiki ida niha ninini va'ora naabosivini adani va'ora vaka'da'diki vakadibadani. ");
INSERT INTO padNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hari hini ida Jesus kavarani, vaadaha'ianaha adani Jesus, Jerusalém sidaji-ra avanikhahavini. Okhananavaki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Arabo'oa namahiki monte das Oliveiras onikia vakaikahi'aha. Ibavi 'bamiki kahararakhamania hojaki ida arabo'oa namahiki. Ibavi hoarani Betfagé oniki. Ibavi hoariha Betânia oniki. ");
INSERT INTO padNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hari. Avamaakarina kaba'i va'ora honaria'aha adani ipohina vi'bamiki: —Avikhananava'a bana. Ibavi banininia avakaikahihi, avakaragaha ada jumento pa'itxi ahosagaki. Jumento pa'itxi ni-nahina okasiki kaho namana. Avakokhariha, hida kodiania vavikha bana. ");
INSERT INTO padNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ija'ari a'onira vahabini bana vanana'dohivini hiki avakadibadani. Va'ora nava'isohi bana: “Jesua birihavini binofi'imidiaki hada.” ");
INSERT INTO padNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Oniaroa, avikha'aha adani vi'bamiki. Vakaraga'aha ada jumento pa'itxi Jesua bivava'isohihijora'iki. ");
INSERT INTO padNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Vakaragaha, vakokhari'aha. Vakokharivini kaba'i, kajumentoki va'ora nana'dohiha'aha: —Nahina kaimoni mani oni jumento-ra avakokharivini hija? ");
INSERT INTO padNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Jesua birihavini binofi'imidiaki hada — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Oniaroa, Jesus kania vavikha'aha, jumento pa'itxi namana avarakasi'ihi ida vakadikarahobi. Okasina vaakodia'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesus radahana kaba'i, ija'aria vanahojahi ida vakadikarahobi jumento viaha hagihia. Vakadihojai oamani ida vakadibadani hija. Ka'da'di jahaki viaha vanahojavini ida vakadikarahobi. ");
INSERT INTO padNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hari. Jerusalém maakarinia avakhano'aha adani Jesus. Monte das Oliveiras vikharafonina kaba'i, ija'ari vaipohikia vavaipohiha'aha. Khai vakhanina mani ida athii 'barakia Deus jahana-ra vara vavani'avini hija: —Jahaki ida Deus kabadani danoki anoki'iki. ");
INSERT INTO padNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Deua bikarona'iki ada Jesus kha'ina, ija'ari vakadika'da'di hira kaimoni. Deus, ikajoamora bana ada ikarona'iki i akadiania. Anofiki ida Deus ibavia nama vahojaki vava'i jahajahani-ra vavahojavini. Anofiki ida Deus jahana vagana-ra khai vani'avini! ");
INSERT INTO padNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hari. Ija'ari vaipohiki vahararana vahojaki adani farisio vaipohiriki, Jesu-ra vani'aha: ");
INSERT INTO padNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Jesus, va'ora honaria bana adani kadaipohi viso vakhanina! Oniaroa, Jesus va'ora ni'aha: —Ka'oa ida kodivarani. Ija'ari khai hora vani'akia ni-vakaabokaki ida viso vakhanina. Viso vakhanira vaha; hagihia ja'di hojaki bodi'baraki vaha — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hari. Jerusalém sidajia amaakari'aha ada Jesus, binoki'ihi, asara'aha. Jerusalém sidaji kaija'arini vapohimajana mani bana ida Jesu-ra naasaraja. ");
INSERT INTO padNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nihaha: —Avapohimajaki bana a'oni. Hidakaba'i avarigaja vaha ida avapohimajajanarini vaha; ni-avamakhaniki vaha. Ni-avarigavini avanofiki. ");
INSERT INTO padNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Khaki bana ida mahi ija'ari vaipohiki a'onira vavajahariki avakadisidaji-ra avanahoroavini. Mahi ipohikia ni-sidaji kaija'arinia vakaabokaki ida avikhaonanina, ni-ija'ari va'ora kavikhajakosiki bana 'baia. Vikhoriribanaoniki ida nami sidaji kavasiribanini i'oarini banininija, ija'ari vikhaonanijanarara kaimoni. Bihiaki ida nami khoraharibanaoniki. ");
INSERT INTO padNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Va'ora vanaabiniki bana adani sidaji kaija'arini hahavi, vanihimahahaviki bana ida vagorana. Tharara'oamanija bana ida gora hahavi, sidaji kavasiribanini hiki. Ni-hojajanaki bana ida ja'di gora amonahani kaimoni, ja'di hoariha namania. Deua binofi'iki ida Jerusalém sidaji kaija'arini-ra va'ora akava'ijoavini. Avanofiravini mani ida a'onira napohimajaja bana. ");
INSERT INTO padNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hari. Oniaroa, Deu-ra khai vani'avini kagorani kavasiribanini bodinia okhajakosi'aha ada Jesus. Va'ora noki'aha adani ija'ari vaipohiki igitha-ra pavakari vanihaki. Ija'aria vakapavakarivini hiki ida igitha Deu-ra vakanava'igavini kaimoni hini. Jesus va'ora aakoja'aha adani pavakarihi abono. Athii khanakia va'ora ni'aha ai vihira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Oniaroa, va'ora nava'isohi'aha: —Deus athi kapapirania hojaki ida athi: “Ija'ari Deu-ra vara vani'ara kaimoni hihida gora.” Niki ida papira athini. Bo'di ibavini avavanihamanija koda hida gora. Igitha kaidivani-ra avanakarahovini mani ida ija'ari-ra avabo'diabakhiavini hija — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hari. Mahi hahavi Jesus ija'ari-ra va'ora ka'ojomo'i'aha Deu-ra khai vani'avini kagorani kavasiribanini bodinia. Jesu-ra vanaabinivini-ra vanofiki adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono, judeus kaija'ari vanava'isohiva abono vihiki. ");
INSERT INTO padNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Vanofivini kaba'i ida Jesu-ra vanaabinivini, ni-vakaabokaki. Va'ora vifiniki adani ija'ari vaipohiki vahararana Jesus bivahojaki kania, oniani ida Jesu-ra vagathiravini hija. Ija'ari vaipohikia mitha vani'abakhiaki ida Jesus athi. ");
INSERT INTO padNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Hari. Deu-ra khai vani'avini kagorani kavasiribanini bodinia hoja'ianaha ada Jesus. Va'ora ka'ojomo'i'ianaha adani ija'ari. Kidivarani hiki ida Deus monina jahaki. Jesus kania avikhami'aha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono, judeus kaija'ari vaka'ojomo'iva abono vihiki. ");
INSERT INTO padNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jesu-ra vanana'dohi'aha: —Nahina vani ira honariavini hija ida kadabadani-ra bada ini'avini? ");
INSERT INTO padNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Va'ora ni'aha ada Jesus: —A'onira onana'dohi'imidiaki bana ho. Hora vananamitha'a bana, João Batista kohana va'ora kana'iki adani ija'ari vakadihojai asohiriki-ra vakava'ipahini'iki. ");
INSERT INTO padNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hana hina vani João Batista kohana-ra honariaja ija'ari-ra va'ora kanara kaimoni? Deus vania koda bihonariara ada João Batista ija'ari-ra kanavini. Ija'ari vania koda bihonariara ada João Batista ija'ari-ra kanavini? — va'ora nana'dohiha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Oniaroa, vaabono vakani'akhama'aha adani sasidotxi vavaka'da'diva: —Anofirihi ida João Batista Deua bihonariavini-ra akahivini. Ni-anofiki jaboni ida João Batista Deua bihonariaravini-ra akahivini. Deus João Batista-ra karonavini-ra akahihi; jaharihi ida João Batista athi-ra akajari'davini Jesua bikahivini. Deus João Batista-ra karonaravini-ra akahihi; ija'ari haria vakaihamahihi. Haria vakaihamahivini hiki João Batista Deus athi namoniva abono hina-ra vakajari'daravini. Ija'ari vaipohiki vajoronikia vakajari'darihi ida Deus João Batista kohana-ra honariavini ija'ari-ra kanavinia. Afiniki ida ija'ari haria vanagahavini ja'dia — vaabono vakani'akhama'aha adani sasidotxi vavaka'da'diva. ");
INSERT INTO padNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Oniaroa, Jesu-ra vani'a'aha: —Ni-aogaki ida João Batista ija'ari-ra kanavini, Deua bihonariavini bihonariaravini. ");
INSERT INTO padNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Oniaroa, va'ora ni'aha ada Jesus: —Hora avananamitharihi; ni-a'onira onanamithaki jaboni hora honariakia — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hari. Oniaroa, rajomi kavaranihia Jesus va'ora vara ni'aha adani ija'ari vajoroniki: —Ka'da'dia bivahonariahihi ida siroi uva rakhajahani ibavini kaimoni. Bivahonariahihi ida uva avani rakhajahani. Bono'ihi havahaki kaimoni ida ihi'ai uva oniki. Varakhaivini naothinia, va'ora honariaha adani badani abono avakadava'aja kaimoni ida kidiuva avani. Avakadava'ahi ida uva avani, bono'ini kamahini a'bani pitani vakadimoni, pitani vakadika'da'di kaimoni. Bivahonariahivini naothinia ajihi'aha. Ibavi hoariha napaja hikia okha'aha. Mahi ipohiki hoja'aha, ni-joijorakiki ada ka'da'di. ");
INSERT INTO padNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Oniaroa, uva a'dihani kamasikoni vani ka'da'di va'ora karona'aha ada kidihonai abono. Bini'aha: “Okha'a uva avakadava'ava abono vakadiania mahija kodiuva a'bani pitani-ra igathanivini kodimoni.” Hari. Ajihi'aha, uva kasiroini kania kaikahi'aha. Uva avakadava'ava abonoa vidafiaha'aha ada makhira. Dairina vani vahonaria'aha ajihi'ina. ");
INSERT INTO padNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hari. Ka'da'dia bikarona'ianaha ada honai abono hoariha, uva avakadava'ava abono vakadiania okhana. Kaikahina vani, vidafiaha'aha ada hoariha, vanajahariharivini jaboni. Dairina vani ajoi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hari. Ka'da'dia bikarona'ianaha ada honai abono hoariha. Okha'aha, kaikahi'aha, vanajahariharivini, sii'aha jaboni akara'o'ina vahonaria'aha. ");
INSERT INTO padNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Oniaroa, abono-ra ni'aha ada ka'da'di: “Nahina-ra koda onamonahaki ho? Hai, oogaki ida. Okaronaki ada kodisai hoarana. Onofijahakiki ada. Kodisai-ra vagathanijahakiki bana adani uva avakadava'ava abono.” ");
INSERT INTO padNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Oniaroa, okha'aha ada ka'da'di kaisai. Uva avakadava'ava abonoa vanoki'aha khana. Vaabono vakani'akhama'aha: “Hada vani akadika'da'di kaisai. Ka'da'di abinina kamahini kidisaia bigathanija ida kidiabi'i kaarabo afohahavi. Anaabiniva mahija kidiarabo avahojavini.” Vaabono vakanava'isohikhama'aha. ");
INSERT INTO padNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hari. Kaikahi'aha ada ka'da'di kaisai, vagathi'aha, uva kasiroini banininia avarahokaonani'aha, vanaabini'aha. Hari. Jesus va'ora vara ni'a'aha adani kidirajomi kavaranihi kamithani vihiki: —A'onira onava'isohivini hiki bana ida ka'da'di bada bini'aki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Okhaki bana ada ka'da'di, va'ora naabinihaki adani uva avakadava'ava abono bana. Vahoariha maina-ra va'ora honariaki bana ada, kidiuva kasiroini akadava'ani vihira kaimoni. Hari. Vakamithava avigaki ida Jesus uva avakadava'ava abono fori vihina va'ora kahivini, oniani ida vani'avini hija: —Jokoa vahabini Deua biva'aharihi ida vapohimajana. ");
INSERT INTO padNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus vada va'ora ni'avini, va'ora ni'aha: —Deus athi kapapirania bivava'isohihijora'iki hida athii: “Hojaki ida ja'di jahaki gora avani dadani kaimoni. Gora vanamonahava abonoa ni-vanofiki hida ja'di. Jahani kaba'i, ni-vanofiki. Vanofiravini kaba'i, Deua binagathogatho'iki ida ja'di karaho. ");
INSERT INTO padNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ija'ari hana hini voronirarihi ja'di karaho namania; 'boro'borohi ida ija'ari. Ija'ari hoariha namania voronirarihi ida ja'di karaho; akhomahi ida ija'ari.” Jesus abono-ra kavarajomivini ja'di karahoa. ");
INSERT INTO padNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hari. Rajomi kavaranihi-ra mitha vani'aha adani judeus kaija'ari vaka'ojomo'iva abono, sasidotxi vakadika'da'di khama. Vaabono vakani'akhamaha: —Jesu-ra agathanijahakiravini mani ida Jesus varani arihina-ra vara vani'avini hija. Uva avakadava'ava abonoa haria kavarajomivini ada Jesus — vaabono vakani'akhama'aha. Oniani ida Jesu-ra vagathivini-ra vanofivini hija cadeia avibaira kaimoni. Ija'ari vaipohiki-ra vifinivini mani ida Jesu-ra vagathiravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oniaroa, Jesu-ra avanaathidanoararivini-ra vanofiha, oniani ida makhira vahoariha-ra vara va'ora vani'avini hija: —A'onira ano'aki bana hari jiniroa, Jesu-ra avakaboroborovini abosini kaimoni. Jesus kania avikha'a mahija avanana'dohibakhiavini. Hari'a avakaborovini-ra ogava ada Jesus. Avakadina'dohia vakaboroha mahija arabo vaka'da'diva athi-ra kajonivini. Arabo vaka'da'diva athi-ra anaabavini jaharini-ra kahiha; Jesu-ra anaathidanoararihi varani jaharikia kavaranina, oniania, arabo vaka'da'diva kania arakhaki bana ada Jesus — sasidotxi vaka'da'diva va'ora ni'aha adani makhira. ");
INSERT INTO padNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hari. Jesus kania avikha'aha adani makhira, vani'aha: —Jesus, aogaki ida kada'ojomo'ihi athini asohini ija'ari-ra vara ini'abakhiavini hi'iki. Ija'aria vavajaharavini kaba'i ida kadavarani, ni-ianahoarihaki oni iathini khai va'ora ni'aki kaimoni. Vara ivani'aka'oaki ida varani ka'oa hini. Ija'ari hahavi-ra va'ora ika'ojomo'ivini hiki ida hojai Deua binofikia vakahojaina. ");
INSERT INTO padNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Haria nanamitha bana Deus kava'isohihia. Deus haria honariamanija imposto kajinironia arabo kaka'da'dini-ra ano'avini? Jahamania koda ida arabo ipohiki kaka'da'dini athi-ra anaabavini? — Jesu-ra vani'aha. César oniki ada arabo ipohiki kaka'da'dini. ");
INSERT INTO padNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Vakaborovini-ra ogaki ada Jesus. Oniania, va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Hora vakavikha jiniro 'ba'dania mahija imposto kajinironi-ra vada oni'avini — va'ora ni'aha. Hari. Vavikha'ihi. Jesus va'ora nana'dohivini hi'ihi jiniro 'ba'dani: —Hana hina onina mani hida? Hana hina ka'da'di akamoani mani hida? Vani'avini: —César ka'da'di akamoani mani oni. Onina mani oni jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Oniaroa, Jesus va'ora ni'aha: —Césa-ra vano'a bana kidinahina binofikia. Deu-ra bana vano'a jaboni kidinahina binofikia — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ija'ari vaipohikia vakamitha'iki ida Jesus vakadina'dohi bigathanivini. Vakaijo'abakhiavini kaba'i ida Jesu-ra vakaboroborovini vakadina'dohia, ni-nahina asohirikia kavaraniki. Ni-va'ora nava'isohivini hiki ida arabo vaka'da'diva athi-ra vakajonivini. Jesus kavarani asohika'oani mani ida va'ora viso ni'aja. Vakava'ibodivaranikaraho'ihi ida vakadina'dohi bigathanivini. ");
INSERT INTO padNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hari. Oniaroa, vikha'aha adani sadosio. Sadosio vakadivarani hiki ida ija'ari abinini naothinia abononi ahokirini. Hari. Jesus kania vikha'aha adani sadosio. ");
INSERT INTO padNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Vani'aha: —Jesus, Moisés kohana ija'ari-ra va'ora ka'ojomo'ivini hida: “Isarina oadani abini'aha ada aajojahiki, kaariha hi'ihi ida kidigamo, kajo'ojahikia bianakara'ihi ida kaariha, bivaisaja kaimoni ida gamo, kidi'aajo kaisai hija kaimoni ida kidisai.” Nimania ida Moisés athi Deus kava'isohihi jirikia hojaki. ");
INSERT INTO padNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hari. Ahararana vahoja'iki adani 7 vihiki imakhinava kohana, vaigamina adani. Aajojahikia bianakara'ihi ida kidigamo. Kidigamo-ra vaisaravini oadani abini'aha. ");
INSERT INTO padNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oniaroa, kidikajo'oa bianakara'ihi ida kidigamo kaariha biniha'iki. Bivaisaravini vani abini'aha ovari maina. ");
INSERT INTO padNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kidikajo'o hoariha bianakara'ianahi ida vakadigamo kaariha vanihaki. Bivaisaravini vani abini'ianaha jaboni. Kidikajo'o hoariha bianakara'ianahi ida vakadigamo kaariha vanihaki. Onivani fori vihira adani kajo'ojahiki vahoariha avanakarahananavini ida kaariha afohanana, vavaisaravini vani vaabini'aha afohanana. ");
INSERT INTO padNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Vaabinihahavina naothinia oniaro maina abini'ihi ida gamo jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Haria nanamitha bana Deus kava'isohihia. 7 vaigamina vaabinina viahania avanakarahanana'iki ida gamo. Ija'ari kohana ahokina kamahini, hana hina vani bana kagamo hija ida gamo? ");
INSERT INTO padNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hari. Jesus va'ora ni'aha: —Avakaraki adani makhira, kidigamo khama hidiaja, vahokina oadani. ");
INSERT INTO padNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Vaabinina naothinia, Deus va'ora anahokiki bana adani ija'ari hidiaja athi naabani vihi'iki. Deus ibavi kania ija'ari vakaikahiha, ni-avakarajanaki. ");
INSERT INTO padNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Deus ibavi kaija'arini avakararina vani fori hija ida ija'ari ahoki'iki. Ni-vaabinijanaki. Deus va'ora anahokivini mani ida kidisai va'ora nihaja. ");
INSERT INTO padNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Deus athi kapapirania hojaki ida Moisés haria nava'isohijoravini hiki athi, ija'ari abini'iki Deua bianahokivini varani hini. 'Bo'dakari Moisés kohana binokiki ida ava patxaniki ha'diki. Ha'dini kaba'i ni-ihimiki. Vada bini'avini oadani, Deua bini'aha: “Moisés, hovani Abraão kaDeus, Isaque kaDeus, Jacó kaDeus, vakadiDeus ho.” Niha ada Deus. ");
INSERT INTO padNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Deus Moisé-ra vara ni'avini kari, vaabini'bo'da'iki adani Abraão, Isaque, Jacó vihiki. Deus kaimoni vihina asia vahokiki adani, ni-ihimiki ida vakadimahi. Avahoki'iki adani ija'ari vaabini'iki, asia vakadiDeus hiki ada Deus — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Oniaroa, judeus kaija'ari vaka'ojomo'iva abono Jesu-ra vani'aha: —Jahaki ida kadavarani. ");
INSERT INTO padNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ni-Jesu-ra vanana'dohijanaki. Vakaipahi'iki ida vanana'dohivini. ");
INSERT INTO padNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hari. Vara ni'ianaha ada Jesus, va'ora nana'dohi'aha adani judeus kaija'ari vaka'ojomo'iva abono: —Nahina mani ida Cristo Davi kohana kahanodi hina-ra avakahivini hija? Asia vara ni'aha ada Jesus: ");
INSERT INTO padNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","— Davi kohana binajiri'iki ida Deus athi kapapirani pitani Salmos oniki, niha: “Deua bini'aha ada kodika'da'di Cristo oniki: ");
INSERT INTO padNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‘I'damani kanabo'ania va'ora oobaiki bana adani ira vavajahariki, va'ora ikada'aha'ahaki kaimoni. Va'ora onihimahahaviravini oadani, vithi bana hida opitana aniaja ka'da'di ihini kodiania.’ Kodika'da'di-ra ni'aha ada Deus.” Niha ada Davi kohana athi afojora. ");
INSERT INTO padNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Asia vara ni'aha ada Jesus: —Davi kohana kahanodi hina kaba'i ada Cristo, Davia binaoniki ada Cristo ‘kodika'da'di.’ Kidihanodi hina kaba'i, kidika'da'di oamani ada — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hari. Ija'ari vaipohikia vakamithahi ida Jesus kavarani. Kidipohi-ra va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Avaabononi avakava'igairivinihi bana ida judeus kaija'ari vaka'ojomo'iva abono vakadihojai mahija avakabanaforavini. Vajahaka'oaki vaabono vavanihavini mani ida makari oadaki-ra vakaimahavini hija, vahoariha vada va'ora vani'ara kaimoni. Judeus kaija'ari vaka'ojomo'iva abono ija'ari vaipohiki vahararana vahojana, vanofiki ida ija'ari vakadika'da'di-ra vaka'ivanitivini vani fori vihina va'ora vaka'ivanitivini. Judeus kaija'ari Deu-ra vara vani'avini kagorania avikhajakosiha, ija'ari vakadika'da'di vaibavi kania vavithina-ra vanofi'aha, vahoariha va'ora khai vani'ara kaimoni. Ija'ari va'ora vakaboa'ivini kamahini adani ija'ari vaipohiki vi'baina vakadiania, judeus kaija'ari vaka'ojomo'iva abonoa vanofiki ida ibavi jahakia vavithina, vahoariha ka'da'di vihiki va'ora vavanihara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Va'ora vakajoamora'badaraha afobakhia adani kaariha afonana. Kaariha kanahina, gorani hiki-ra visaarivini kaba'i, Deu-ra vara vani'a'badaraha athii oadakia, vahoariha vajahaka'oaki va'ora vavanihara kaimoni. Deus va'ora arakhaki jaharika'oani arafiaki bana va'oani nikia vakabadaniki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Hari. Deu-ra khai vani'avini kagorani kavasiribanini bodinia hojaha ada Jesus. Vada va'ora ni'aha adani ija'ari, niha vani'a'avini ida vakadijiniro-ra avibaivini bavinia. Deus kaimoni ida jiniro avibaiki. Oniaroa, Jesus va'ora noki'aha adani ija'ari vakajiniro'ahapikiki jiniro-ra avibaivini bavinia. ");
INSERT INTO padNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Binokiki jaboni ida kaariha kajiniroriki. Biobai'ihi ida jiniro 'ba'dani 'bamiki kaidivariki. Kaidivari'oamanija ida jiniro 'ba'dani 'bamiki. ");
INSERT INTO padNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Oniania, ija'ari-ra va'ora ni'aha ada Jesus: —Ka'oa hida oathi. Jiniro karaho oamani oni kaariha biobaija. Jiniro pa'itxi mani ida vahoariha avibaija. ");
INSERT INTO padNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Avibaivini naothinia, vakajiniro'ahapikiki asia vavahojaki hida jiniro karaho, vakadinahina abosini kaimoni. Kaariha biobaihi ida jiniro 'bamiki bivahojaki. Ni-nahina-ra vahojajanaki ida kaariha kidinahina abosini kaimoni. Jiniro kaidivaki oamani ida Deu-ra no'avini hija. ");
INSERT INTO padNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hari. Oniaroa, ija'ari vaipohirikia vara vavani'avini ida Deu-ra khai vani'avini kagorani. Vakhaniha: —Jahaki ida nokiani Deu-ra khai ani'avini kagorani. Na'baha'oamanija ida ja'di gora katokinia hojaki. Kaidiva'oamanija ida nahina ija'ari Deu-ra vakanava'igavini. Oniania, Jesus va'ora ni'aha: ");
INSERT INTO padNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Kaikahiki ida mahi, ihimiki kaimoni ida hahavi avanokiki. Deu-ra vanofiriki vania bana vanihimaka'oaja ida Deu-ra khai ani'avini kagorani. Ja'di na'bahaki-ra vanathararavini kamahini, ni-hojajanaki ida ja'di hoarani, ja'di hoariha namania — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hari. Jesu-ra vanana'dohi'aha: —Jesus, mahi nihaforija vani vanihimaki ida Deu-ra khai ani'avini kagorani? Nihanikia bana aogaja ida thararani kamahini amaakarini? ");
INSERT INTO padNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Oniaroa, Jesua bigathanihi ida vaathi: —Avaabononi avakava'igairi bana! Vahoariha a'onira vakorijanahavini-ra bana vanofiki a'oni. Vakajari'da bana ida vaathi. Vikhaki bana adani korijanahi abono, vakhaniki bana afohanana adani: “Hovani Cristo ho, Deua hora karonaki avakadika'da'di ohina kaimoni.” Vakhaninanaki bana jaboni adani: “Kaikahi'iki ida mahi Deua bivava'isohihijora'iki.” Hari'a va'ora vavaipohiha bana adani nikia vakavarani'badaraki. ");
INSERT INTO padNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Avakamithabakhiaki bana ida varani vihina, arabo hoariha kaija'arini ija'ari vahoariha-ra va'ora vidavini vakadiarabo avanahoroaja kaimoni. Arabo hoariha kaija'arini vaabono vakodakhamaki bana varani vihina-ra avakamithahi; hari'a vaofini! Namitha'imidiaki bana ida vara a'onira oni'avini hiki. Namitha'ini kaba'i, ni-amaakariki kaho ida ija'ari hahavi vakadimahi anokhomini. ");
INSERT INTO padNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hari. Asia vara niha ada Jesus: —Arabo kahijava va'ora vidaki bana adani arabo hoariha kahijava. Arabo kaka'da'dini kidisorara khama va'ora vidaki adani arabo hoariha kaka'da'dini kaija'arini. ");
INSERT INTO padNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Oniaroa, ibavi ipohikia ho'doho'dobakhiaki ida arabo afobakhia. Mahi ipohikia ija'aria vakainamoki bana ida vakadi'bai. Kavamoni karaho ipohiki ija'ari vaipohikia vagathiki bana. Jahari'oamanija bana ida ija'ari pohimajaki. Nokiabakhiaki bana ida Deus karajomi ipohiki nama jararinia. ");
INSERT INTO padNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nokiabakhiani viahania hora vavajahariki a'onira vanajahariharibakhiaki bana a'oni. A'onira avibaibakhiaki jaboni bana adani cadeia. Akadija'ari Deu-ra vara ani'avini kagorania hora vavajahariki a'onira avarakhaki a'oni bana akadija'ari vanava'isohiva abono vasa'a kabodinia. Vakamithaki ida a'onira vakanavaranihavini, oniani ida cadeia a'onira avibaivini hija bana. Oipohina avihini mani ida ija'ari kaka'da'dini vakadiania vahoariha a'onira avisavini hija, a'onira avanaathidanoararivini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Arabo kaka'da'dini vaviaha avahojani kamahini, vara vavani'a bana ida omonina jahaki. ");
INSERT INTO padNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Avaabononi vakava'ibodivaranijora bana: “Jokoa oakava'isokonirihi ida hora avakaraganahavini kamahini varani vara va'ora oni'avini hiki kaimoni.” Avaabononi vani'ajora bana. ");
INSERT INTO padNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","A'onira avanaathidanoararivini kamahini, a'onira onava'isohiki bana ho varani vakadi'aathidanoarari avagathanija kaimoni. A'onira ono'aki jaboni bana ho kodi'ogahaia. A'onira vavajahariki avaathini-ra vakamithahi; ka'oa hini avigahi. Avakadivarani viso va'ora ni'aki bana adani. ");
INSERT INTO padNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hari. Avahoarahananani a'onira avarakhaki bana adani avakadiamia, avakadiabi'i, avaigamini, avakadija'ari vahoariha, avakadiva'ahi vihiki vahoariha, a'onira avibaira kaimoni cadeia kabodinia. Hora vanofiravini mani ida a'onira cadeia avibaivini hija. Avahoarahananani a'onira vanaabiniki bana adani. ");
INSERT INTO padNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Oipohina avihini mani ida ija'ari vaipohiki a'onira vavajaharavini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","A'onira vanajahariharivini kaba'i, Deus a'onira akadava'aki bana a'oni. Ni-akamadaki bana ida avama'onahani, Deus ibavia avarikhaki bana a'oni. ");
INSERT INTO padNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Hari'a bana oipohina avihini-ra vakava'ipahini'a. Avakava'ipahinirihi; Deus a'onira akava'ijoahi. ");
INSERT INTO padNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Hari. Asia vara ni'aha ada Jesus: —Jerusalém kavasiribanini banininija vahojaribanaonina kamahini adani sorara vaipohiki, avarigaki bana ida mahi ipohirikia vanihimavini bana hida sidaji. ");
INSERT INTO padNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sorara vahojaribanaonina-ra avanokivini kamahini avigava adani ija'ari Judéia kaarabonia vahojaki arabo namahiki-ra avanikhavini. Sidaji bodinija vahojaha; khaonanijorakiva bana. Vakadisiroi bada vakhanina; hari'a sidajia avi'oiva bana. ");
INSERT INTO padNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Hari. Imai 'banani karaho kamahini bana ida a'onira onava'isohijoravini hija. Deus athi kapapirania bivava'isohihijoraki ida mahi ija'ari-ra napohimajavini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jaharini arafiaki bana ida ija'ari vapohimajana kamahini gamo vakajahavidoki, gamo vaisapa'itxiki vihiki vakadimoni hini. Khaki bana ida imai 'banani karaho arabo hahavi kaija'arini vakadimoni. Jahariki Deus va'ora arakhaki bana adani ija'ari vakadihojai asohiriki abosini kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oniaroa, Jerusalém sidaji ahoroani kamahini ija'ari vakadisa'aia va'ora visaka'aha adani Jerusalém sidaji kaija'arini vaipohiki, va'ora vanaabini'aha. Vahoariha gathai vihi'ina osahi vihina arabo hoariha ipohikia, vakadiaraboa vahojajanarara kaimoni. Deu-ra avigarikia visaariki ida Jerusalém sidaji avakadiania. Deus va'ora va'ahavini oadani, Deu-ra avigarikia vavahojaki hida sidaji. ");
INSERT INTO padNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Hari. Asia vara ni'aha ada Jesus: —Deua bianahoarihaki bana ada safini, masiko, boviri hiki vagana rajomi kaimoni nama nokiaki. Arabo hahavi kaija'arini vava'i soko inikarahoki bana. Komini ka'ithoni akarafiani mani ida ija'ari-ra va'ora naofinija. ");
INSERT INTO padNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Arabo hahavi kaija'arinia vakava'ibodivaraniki bana ida va'ora napohimajaki kaimoni, oniani ida va'ora naimahidakarahoja bana. Vaimahidakarahona mani ida va'ora narai'aja bana. Deua binaho'doho'doki ida nama vaaniara kaimoni adani ka'da'di danoki nama vahojaki. ");
INSERT INTO padNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oniaroa, ija'ari hahavi hora vanokiki. Bahi vaforiki hararana ojoirarina. Hovani ija'ari hahavi vakadi'aajo ho. Ija'aria vanokiki bana ida ojahana, odanona, ojoirarina kamahini. ");
INSERT INTO padNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hari. Kama'dani kamahini ida a'onira oni'avini hi'iki, hari'a vajoiribani, vanokha bana ida ojoina. Khai vani'a bana ida jorakia a'onira oakava'ijoavini. ");
INSERT INTO padNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Oniaroa, Jesua vara bivani'a'ihi ida rajomi kavaranihi: —Okavarajomiki ida ojoina kamahini figira avani afani aja'dini fori hini. Vakava'ibodivarani'a bana ida figira avani, ihi'ai avani hoariha hiki. ");
INSERT INTO padNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Avanokihi ida afani aja'dinani, avarigahi ida amoroki amaakarini. ");
INSERT INTO padNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Avanokiki bana hida a'onira oka'ojomo'ivini hiki namithaki, avarigaki ida ojoina kamahini amaakarini. Onivani fori hija ida ojoina viahani karajomini. Avanokihi, avarigaki bana ida Deus ija'ari hahavi-ra va'ora vaka'da'divini kamahini amaakarini. ");
INSERT INTO padNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Vaabinirina oadani adani ija'ari rajomi-ra vanokiki, onanamithahahaviki bana ida a'onira oni'ajoravini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ihimiki bana ida arabo hahavi, nama hiki jaboni. Namithaki hida oathi a'onira oni'avini hiki. Mahi hahavi anokhomiriki hida oathi — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hari. Jesua biananokhomi'ihi ida kidivarani, va'ora ni'aha: —Avava'ini ogairiva bana! Hari'a vakava'ibodivaraniha'oadaha ida ihinika amonahani, kavi-ra avi'avivini, avakadinahina-ra avakainamovini jaboni. Ojoina va'ora narapataki bana adani niki-ra vakava'ibodivaraniha'oadahaki, oniani ida avava'ini ogairini-ra ohonariavini hija. ");
INSERT INTO padNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","36","Ikoaka fori hiki ida ojoina kamahini. Abaisana ikoaka-ra nokiravini mani ida anagithina hija. Ija'ari vava'i ogairirini mani ida ojoina va'ora narapataja. Agithiki fori vihiki adani. Ojoina-ra avarakava'igairihi; ni-avarapataki. Ojoina-ra avarakava'igairihi; Deu-ra avakanikhariabakhiahi, a'onira nadanora kaimoni, oniani ida a'onira napohimajarija, a'onira oakava'ijoavini hija bana. Ojoina kamahini jaboni avaofinirini oviaha avahojaja kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hari. Oniaroa, mahi hahavi Jesus va'ora ka'ojomo'iki adani ija'ari Deu-ra khai vani'avini kagorani kavasiribanini bodinia. Joma ajihiki ada Jesus sidajia. Arabo namahiki maakarinia vadiki ada. Monte das Oliveiras oniki ida arabo namahiki Jesua joma oadani bivahojaki. ");
INSERT INTO padNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vagavagani okha'ianaha ada Jesus Deu-ra khai vani'avini kagorania. Ija'ari vaipohiki jaboni avikha'iki, mitha vani'aja kaimoni ida Jesus kavarani. ");
INSERT INTO padNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hari. Oniaroa, amaakarihi ida ihinika Páscoa oniki kamahini. Ihinika-ra vanamonahavini oadani, pão kathoramananiriki-ra vakahaha. ");
INSERT INTO padNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Oniaroa, sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama, vanofiki ida Jesus abinina. Ija'ari vaipohiki Jesu-ra vavajahavini mani ida va'ora vifinivini hija. Vaabono vara vakani'akhama'aha: —Ija'ari Jesu-ra vavajahakia vanokiravini kaba'i, agathihava ada Jesus anaabinira kaimoni. Niha ani'a'avini agathiki koda ada? — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hari. 12 vihiki vaipohina adani Jesus ipohina. Hoarana Judas Iscariotes oniki. Jaharia biavi'onani'aha ada Judas. ");
INSERT INTO padNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Oniaroa, sasidotxi vavaka'da'diva vakadiania okha'aha. Vahojaki vakadiania adani Deu-ra khai vani'avini kagorani avakadava'ava abono vakadika'da'di. Vakadiania akhano'aha ada Judas. Va'ora ni'aha; —Jesu-ra oarakhavini-ra avanofihi; oarakhaha avakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Oniaroa, Judas kavarani-ra mitha vani'aha, khai vakhani'aha, vani'aha: —Jiniroa ira ano'aki bana hari, Jesu-ra iarakhavini-ra anaabosivini — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juda bivajahamanihi ida vakadivarani. Ajihi'aha, abono-ra ni'aha: —Niha oni'a'aki koda hada Jesus oarakhavini vakadiania. Ni-onofiki ida ija'ari vaipohiki Jesu-ra oarakhavini-ra vanokivini. ");
INSERT INTO padNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hari. Ihinika kama'dani kamahini vani ovilia vadorohana vaipohiki-ra vanaabini'aha adani judeus kaija'ari, Páscoa kaihinikani ko'baini kaimoni. Vakahaki jaboni ida pão kathoramananiriki, ovilia imana hiki, avakava'i'biriniria kaimoni ida mahi 'bo'dakari Deus vakadi'arahoda avikhananavaki-ra va'ora va'adi'avini. ");
INSERT INTO padNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Oniaroa, ihinika kama'dani kamahini, Jesus va'ora honariaha adani Pedro, João vihiki: —Avikhananava bana mahija Páscoa ihinika ko'baini-ra avanamonahavini akadimoni. ");
INSERT INTO padNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Oniaroa, Jesu-ra vanana'dohi'aha: —Ida hanaja vania ihinika ko'baini-ra anamonahavini ibavini kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus va'ora ni'aha: —Mitha vani'a; sidaji kaathania avarikhajakosihi; avanokiki bana ada makhira paha bavini-ra kaiba'iki. Avikha bana kidiania. Gora bodinia okhajakosiha, avikhajakosi jaboni bana. ");
INSERT INTO padNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Gora kaka'da'dini-ra vani'a bana: “Jesus vani haria honariavini hida ira anana'dohivini hija: Ida hanajaja vania hojahi Páscoa kaihinikani ko'baini-ra anamonahavini ibavini kaimoni?” ");
INSERT INTO padNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A'onira bana nanokiahivini hiki ida bana ibavi, gora ka'obani kakanamajakhamaki. Nahinaro avanofiki hoja'iki afohahavi. Hi'oni ibavia 'bai-ra vanamonaha'a akadimoni — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hari. Sidajia avikha'aha, vakaraga'ihi ida ibavi Jesus va'ora nava'isohijoravini hi'iki. Oniaroa, vako'baiha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hari. Mithani vaivaini vani vakaikahi'aha adani Jesus, athi avavaadahaoniva abono khama, Páscoa ihinika ko'baini ibavinia. Mesa kai'oarinia dosi vakhaniriaha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesus va'ora ni'aha: —Onofi'oamanija ida Páscoa ko'baini-ra ohavini avakadiania, oimana 'banani kama'dani viahania. ");
INSERT INTO padNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ka'oa hiki ida varani a'onira onava'isohijoravini hiki. Deus ija'ari hahavi-ra vaka'da'diravini oadani, ni-oha'ianaki ida Páscoa ko'baini. ");
INSERT INTO padNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Oniaroa, Jesua binabiini'ihi ida vinho kacoponi, Deu-ra ni'a'aha: —Deus, ivani ijahaki i, vinho haria ino'a'iki i. Deu-ra vara ni'avini naothinia va'ora ni'aha adani ipohina: —Vagathani'a hida vinho mahija avi'avihahavi'avini. ");
INSERT INTO padNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ka'oa hiki hida varani a'onira onava'isohijoravini hi'iki. Deus ija'ari hahavi-ra vaka'da'diravini oadani, ni-o'avijanaki kaho hida vinho. ");
INSERT INTO padNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hari. Vara nina naothinia, Jesua bikanabiini'ihi ida pão, Deu-ra ni'a'aha: —Deus, ivani ijahaki i. Pãoa haria ino'a'iki i. Deu-ra vara ni'avini naothinia, bikanapitahatahahi va'ora no'avini kihi'ihi, va'ora ni'aha: —Oimana hida pão. Avakadimoni ida oimana 'banani oabono ova'ahavini. Vakaha hida pão. Vakava'ihoki bana ida oimana 'banani karaho avakadimoni. ");
INSERT INTO padNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hari. Vi'baina naothinia Jesus vinho kacoponia va'ora no'a'ianaha, va'ora ni'aha: —Hihida vinho oamana hida. Deua bivava'isohihi'iki hida kidiva'iponahi a'bo'daki ja'dini kidija'ari vakadimoni hini. Deus kava'isohihi ja'dini karajomini hida oamana ahovariki avakadimoni. ");
INSERT INTO padNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Vakava'ibodivarani'a bana. Mesa kai'oarinia dosi vakhaniriaha'aha, hojaki ada kodiva'ahi hina-ra kahi'badaraki, hora arakhaki bana vahoariha vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hovani ija'ari hahavi vakadi'aajo ho. Oabiniki bana ho. Nimania ida Deua binofiki kodimoni hini. Deua binapohimajaki bana ada hora arakhaki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Oniaroa, Jesus athi avavaadahaoniva abono vaabono vakanana'dohikhamavini hi'aha ada hana hina Jesu-ra arakhaki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hari. Jesus ipohina vaabono vara vakani'akhamadanoki'aha: —Hana hina ada akadiania hojana jahara akadika'da'di kaimoni hina? Vaabono vakanana'dohikhamavini, ka'da'di vihina-ra vanofinana'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Oniaroa, Jesus va'ora ni'aha: —Arabo vaka'da'diva vasa'a kabodinia vahojaki adani vakadiarabo kaija'arini va'ora vahonariaki kaimoni. Ija'ari vakadiva'ahia va'ora vanaoniki adani ija'ari vakadika'da'di. ");
INSERT INTO padNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ni-onofiki ida vakadihojaia avakahojaini. Onofiki ida ka'da'di hina-ra nofiki vahoariha-ra kakodiavini. Onofiki ida ija'ari-ra honariaki honai abono fori hina hojana. ");
INSERT INTO padNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hari. Mesa kania hojaki ada makhira 'baiki. Hoariha 'baia bikavikhaki ada. Hana hina ada hoariha-ra vaka'da'dira? Avarigaki ida mesa kania vithiki, ovani ada ka'da'di hira. Avakadika'da'di ohina kaba'i, avahararania honai abono fori ohina ohojaki ho. ");
INSERT INTO padNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","Vahoariha hora vanajahariharivini oadani, kodiania avahojaha'oadahahi, ni-hora avakava'ipahiniki, oniani ida ka'da'di avihini-ra ovahonariahivini hija. Kodiabi'i ka'da'di ohina-ra honariavini vani fori hiki ida a'onira ohonariavini ka'da'di avihini. ");
INSERT INTO padNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kodija'ari hahavi-ra va'ora ovaka'da'divini kamahini, a'onivani kodimesa kai'oarinia avavithiki bana a'oni, avi'baiki bana a'oni kodiania. 12 vihiki vaipohina adani Israel kaisai. Ija'ari-ra onasohivini kamahini, a'onivani avavithiki bana a'oni ka'da'di kavithi kania, va'ora avanasohira kaimoni adani Israel kaija'ari hahavi. Ka'da'di avihini mani ida vakadihojai hahavi avarigavini hija, hana hini asohiki asohiriki, avahonariaja kaimoni ida vakadihojai abosini. ");
INSERT INTO padNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Hari. Jesua bini'aha ada Simão Pedro: —Simão, Simão, mitha nijahaki'a bana. Jaharia binofiki ida a'onira kaijo'avini. Kodiabi'ia biva'ahaki bana ada. Makhira biaka'diririhi ida trigo 'ba'dani aniaja kaimoni ida ba'ba'da asafini. Onivani fori hira bana ada Jahari a'onira kaijo'avini. ");
INSERT INTO padNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Simão, Deu-ra vara oni'a'iki ho ira kakodiara kaimoni hora ivakaijokaha'oadahaja kaimoni. Kodiania ijoiribanini kamahini, vara va'ora ni'a bana adani iigamini mahija khai hora vani'a'ianavini. ");
INSERT INTO padNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Oniaroa, Pedroa bigathanihi ida Jesus athi: —Ira vagathiki vahabini bana adani vahoariha, cadeia ira avibaiki vahabini bana adani, ira vanaabiniki vahabini bana adani jaboni. Onofiki ida kadania ohojana cadeia, onofiki ida oabinina kadania jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesua bini'aha: —Ira onava'isohijoravini hiki hida joma arakava ahiana viahania, ahoarabakosikia hora iogaravini-ra ikahiki bana i. ");
INSERT INTO padNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hari. Oniaroa, Jesus va'ora nana'dohi'aha: —Vahoariha vakadiania a'onira okarona'avini kari varani ohina-ra avananamitha'iki a'oni, ni-ova'aha'iki ida jiniro bavini, sandália kihiki-ra avarakavikhavini. Nahina mani ida avakainamoja? —Iniani. Ni-nahina-ra akainamorihi — vagathani'ihi ida Jesus kana'dohi. ");
INSERT INTO padNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","— A'onira onava'isohi'ianaki ho. Jiniro bavini, 'bai bavini hiki-ra avavahojahi; avavikha'a bana. Tarasara fori hiki-ra avavahojarihi avakadisa'ai kaimoni, pavakari vaniha'a bana ida avakadimakari odoki mahija tarasara fori hiki-ra avakapavakarihavini. ");
INSERT INTO padNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hari. Deus athi kapapirania hojaki ida varani ohina: “Ija'aria vanajaharihariki ada Jahari kabadania kabadaniki. Onivani fori hira ada ovari jahariharina.” Namithaki bana kodiania hida Deus athia bini'aki. Deus athi kapapirani hora vara vani'ajoravini mani ida Deua binanamithavini hija bana. ");
INSERT INTO padNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oniaroa, Jesus ipohina vani'aha: —Hidavani hihida tarasara fori hiki 'bamiki. —Arajomaki ida — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hari. Oniaroa va'ajihi'aha adani Jesus kidipohi khama. Monte das Oliveiras avikha'aha. Vakadihojai hiki ida monte das Oliveiras avikhana. ");
INSERT INTO padNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ibavi bianikhaki kania avakhano'aha, Jesus va'ora ni'aha: —Deu-ra vara vani'a bana mahija Jahari athi a'onira kaborovini-ra avakamitharavini. ");
INSERT INTO padNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hari. Ajihi'aha, okhamipa'itxi'aha, kajo'atharari'aha, Deu-ra vara ni'a'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Bini'aha: —Kodiabi'i, hora vanaima'banavini inofirihi; hora iva'adivini-ra ikaabokahi. Hora vanaima'banavini inofihi; onofihi jaboni. Nahina-ra inofihi; onofiki jaboni — Deu-ra ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Oniaroa, kha'aha ada Deus ibavi kaija'arini Jesus va'i-ra vajahaki kaimoni, bikaabokaja kaimoni ida imana 'banani arafiaki. ");
INSERT INTO padNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesua biakava'isokonikarahoki ida namithaki kaimoni, oniani ida Deu-ra vara ni'adanoki'ianavini hija. Anikhoakaraho'aha ada Jesus. Arabo namania kabo kaborari'ihi ida Jesus amana anikhoana hiki. ");
INSERT INTO padNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hari. Deu-ra vara ni'avini naothinia, gaamanani'aha, kidipohi vakadiania joimi'aha, vavadina vani va'ora karaga'aha. Vava'i mokara nikarahoni va'ora navadi'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Va'ora ni'aha: —Niha avakhanimanija avavadiki? Vigaa'a. Deu-ra vara vani'a mahija Jahari athi a'onira kaborovini-ra avakamitharavini. ");
INSERT INTO padNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Oniaroa, vara nina kaba'i vakaikahi'aha adani ija'ari vaipohiki. Vahararana hojaha ada Judas Iscariotes. Jesus ipohina ada. Judas va'ora bananiha adani ija'ari vaipohiki. Jesus kania maakari'aha, biramosira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Oniaroa, Jesua bini'aha: —Judas, hora ikavarajomivini mani ida hora iramosivini, avigaja kaimoni ida hana hina-ra vagathivini? ");
INSERT INTO padNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hari. Jesus ipohina vahoariha va'ora vanoki'aha adani ija'ari, avigaki ida namithaki kaimoni. Jesu-ra vani'aha: ");
INSERT INTO padNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","—Jesus, inofimanija koda ida akadisa'ai-ra adionivini, va'ora adara kaimoni? Oniaroa, Jesus ipohina hoarana bidioni'iki ida tarasara fori hiki, binoba'aha ada sasidotxi vaka'da'diva kahonai abono, biava'boarabakosi'ihi ida morobo aniaja. ");
INSERT INTO padNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesus va'ora kaabani'aha: —Hari'a bana va'ora vida! Oniaroa, bikadasa'ihi ida makhira morobo, aihota'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hari. Ija'ari vaipohiki vahararana vahojaki adani sasidotxi vavaka'da'diva, Deu-ra khai vani'avini kagorani avakadava'ava abono vakadika'da'di, judeus kaija'ari vanava'isohiva abono vihiki. Jesus va'ora ni'aha: —Ija'aria vavikhaki ida ava, tarasara hiki vagathira kaimoni ada kaabiniki. Onivani fori hini avavikhaja ida avakadisa'ai hora avagathija kaimoni. Okaabiniki hora avavanihamania koda? ");
INSERT INTO padNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mahi hahavi a'onira oka'ojomo'ihi Deu-ra khai ani'avini kagorani kavasiribanini bodinia, ni-hora avagathi'iki. Hidakaba'i kaikahini ida mahi hora avakaaboka'avini kamahini. Hora kaaboka'iki jaboni ada Jahari. ");
INSERT INTO padNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hari. Oniaroa, vagathi'aha ada Jesus, avisa'aha sasidotxi vakadika'da'di gorana. Napaja kasiaga'aha ada Pedro. ");
INSERT INTO padNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Gora kavasiribanini kaathania o'oi'aha. Asia gora baninija hojaki ada. Vahoariha avakanaha'di'ihi ida siho, vakadiragi ibavini kaimoni. Okhami'aha ada Pedro vahoariha vahararana, vithi'aha siho ka'dihania. ");
INSERT INTO padNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Oniaroa, kha'ihi ida badani abono. Binoki'aha ada Pedro abono-ra naragivini siho ka'dihania. Vada bini'aha, nihi: —Hihada makhira Jesus kania adahaki hada jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro bini'ahi ida gamo: —Iniani, ni-oogaki ada ovari. ");
INSERT INTO padNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Oniaroa, mitihini makhira maina binoki'aha ada Pedro, bini'aha: —Ivani jaboni Jesus ipohina i. Pedroa bigathani'ihi hida makhira athi: —Iniani, ovaipohihariha ada. ");
INSERT INTO padNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Oniaroa, mitihitihini hoariha bini'adanoki'ianaha: —Ka'oa oamani ida Jesus ipohina ihini. Galiléia kaaraboni kaija'arini jaboni i. ");
INSERT INTO padNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","— Iniani, oogariha ada vara hora ini'avini hiki — niha ada Pedro. Vara nina kaba'i, ahia'aha ada arakava. ");
INSERT INTO padNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hari. Gora bodinia roiribani'aha ada Jesus, vada bini'aonani'aha ada Pedro. Oniaroa, Pedroa bianokijakosi'aha ada Jesus, bikava'ihoki'ihi ida Jesus athi: —Hihida joma arakava ahiana viahania, ivani inihaki i: “Oogariha o Jesus.” Ahoarabakosikia ini'iki i. ");
INSERT INTO padNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jesus athi-ra kava'ihokiha, ajihi'aha ada Pedro, asara'ahapiki'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Oniaroa, Jesu-ra avakadava'aki Jesu-ra avigarahaki, vakajoiri'aha jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nokho makaria vakarahobavini vakajoiri'aha, Jesu-ra vakahomaravini vanana'dohi'aha: —Hana hina vani ira kajoirija? — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Varani jaharikia Jesu-ra vara vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hari. Oniaroa, vakajoronikosoakajoma'aha adani judeus kaija'ari vanava'isohiva abono, sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono vihiki khama. Judeus kaija'ari vanasohiva abono vavaka'da'diva vajoroniki. Vajoronina naothinia vavahonariahivini ada Jesus avakadava'ava vavikhavini. ");
INSERT INTO padNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Vakadiania Jesu-ra vavikha'aha, sasidotxi vavaka'da'diva vanana'dohi'aha: —Jesus, haria nanamitha'a. Ivani Cristo i? Deus ira nagathogatho'iki i? Jesus va'ora ni'aha: —Cristo ohina-ra okahihi; hora avakajari'dahi. ");
INSERT INTO padNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A'onira onana'dohi'imidiahi; ni-kodina'dohi-ra avagathaniki. ");
INSERT INTO padNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hovani ija'ari hahavi vakadi'aajo ho. Deus danoki pitana aniaja ovithiki bana ho. Ka'da'di ohina. ");
INSERT INTO padNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Oniaroa, vanana'dohihahavi'aha: —Deus kaisai mani i? —A'onivani Deus kaisai ohina-ra avakahiki a'oni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Vakhaniha: —Jahariki ida Jesus kavarani. Deus kaisai hina-ra kahi'badaraki ada. Nahina kaimoni va'ora anihajanariha adani Jesus vara vani'ava abono. Akamitha'iki hida Jesus Deus kaisai hina-ra kahivini. ");
INSERT INTO padNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hari. Oniaroa, vigaa'aha adani judeus kaija'ari vanasohiva abono hahavi, Jesu-ra avisa'aha Pilatos kania. ");
INSERT INTO padNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Vakaikahiha, Pilato-ra vani'aha Jesu-ra avakaraganahavini: —Agathi'iki hada hihada makhira Jesus oniki. Ovari va'ora ni'abakhiaki adani ija'ari vaipohiki: “Hari'a vanaabajana ida arabo ipohiki kaka'da'dini César oniki athi. Hari'a Césa-ra vano'ajana avakadi'imposto kajinironia. Hovani Cristo ho, Deus hora nagathogatho'iki ho, avakadika'da'di ohija kaimoni.” Niha ada Jesus — Pilato-ra vani'aha vakorijanahavini. ");
INSERT INTO padNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Oniaroa, Pilatoa binana'dohi'aha ada Jesus: —Ivani, judeus kaija'ari vakadika'da'di mani i? Jesua bigathanihi ida kidina'dohi: —Ivani, judeus kaija'ari vakadika'da'di ohina-ra ikahiki i. ");
INSERT INTO padNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hari. Pilatos va'ora ni'aha adani sasidotxi vavaka'da'diva, ija'ari vaipohiki vajoroniki khama: —Ni-nahina jaharikia kabadaniki hada makhira. Badani jahariki-ra bada ni'aravini mani ida abinina ovahonariahiravini hija. ");
INSERT INTO padNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Vani'adanoki'aha afobakhia: —Pilatos, Judéia kaaraboni kaija'arini hahavi-ra va'ora narifirafiraki ada kidivarani, kidibadani hikia. Kama'da'iki ida va'ora narifirafiravini Galiléia kaarabonia. Akadiani maina khaki ada — vani'aha ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hari. Pilatoa bikamitha'ihi ida vakadivarani, va'ora nana'dohi'aha: —Hihada makhira Galiléia kaaraboni kaija'arini mani koda hada? — Ha'a, Galiléia kaaraboni kaija'arini o — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hari. Galiléia kaaraboni kaka'da'dini Iroji oniki hojaki jaboni Jerusaléa. Kha'iki ada ovari jaboni Páscoa kaihinikani kama'dani viahania. Pilatoa bikamitha'ihi ida Jesus varani hina Galiléia kaarabonia kha'ina, va'ora honaria'aha adani sasidotxi vavaka'da'diva: —Galiléia kaaraboni kaija'arini mani hada Jesus. Galiléia kaaraboni kaka'da'dini ada Iroji. Iroji kania avisa'a hada Jesus mahija ovari avakadi'aathidanoarari-ra nasohivini. ");
INSERT INTO padNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Oniaroa, Irojia khai bini'a'iki ida Pilatos Jesu-ra karonavini kidiania. Bikamithabakhia'iki ida Jesus varani hina, mahi ipohikia binokivini binofiki ada Jesus. Irojia binofiki ida Jesus kidibadani danoki-ra bada ni'avini binokija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oniaroa, Irojia binana'dohivini hi'ihi ida na'dohi ipohiki. Ni-Jesua bigathaniki ida kidina'dohi. Viso ni'oamani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vakadiania vahojaki adani sasidotxi vavaka'da'diva, judeus kaija'ari vaka'ojomo'iva abono khama. Jesu-ra avanaathidanoararibakhia'aha kidibadani jahariki ipohini vakahi'badara'aha. ");
INSERT INTO padNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Oniaroa, Iroji, kidisorara vihiki khama avigaraha'aha ada Jesus, vakaihiponiriha ada, oniani ida ka'da'di kamakari jahaki kaidivakia Jesu-ra avanaragarahivini hija. Avanaragarahivini naothinia, Iroji va'ora honaria'aha Jesu-ra vanajoivini Pilatos kania. ");
INSERT INTO padNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hari. Iroji kania Jesu-ra karonavini viahania ada Pilatos, ni-Iroji khama vaabono vaakariakakhamaki. Bikaronavini kamahini vaabono vakanofikhamajahaki'aha. ");
INSERT INTO padNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hari. Pilatos kania Jesu-ra avisa'ianaha adani sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama. Vajoroni'ianaha, vahoariha khama. ");
INSERT INTO padNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilatos va'ora ni'aha: —Hora avakavikhavini hiki hada makhira. Avakadi'aathidanoarari athini hiki ada Jesus, ija'ari vaipohiki-ra va'ora narifirafirabakhiavini. Avaviahania Jesu-ra onana'dohivini hi'iki ida kidivarani, badani hiki. Ni-nahina jaharikia kabadanina okaragaki. Ka'oa hiriki ida Jesus varani hina hora vara avani'avini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Irojia vara bini'a'iki jaboni ada Jesus. Ni-nahina jahariki-ra karagaki jaboni. Bikaragaravini mani ida akadiania Jesu-ra najoivini hija. Ka'oa hirini ida Jesu-ra avakaraganahavini athini, oniani ida Jesu-ra ovahonariahiravini hija abinina. ");
INSERT INTO padNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Va'ora ohonariaki bana adani kodisorara Jesu-ra vidafiahavini xikotxia, naothinia ajihina ova'ahaki bana ada — va'ora ni'aha ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hari. Páscoa ihinika kamahini Pilatoa biva'ahaki ada makhira hoarana cadeia kabodinia hojaki ajihina. Ihinika-ra vanamonahakia vanagathogathoki ada makhira hana hina cadeia okhaonanina vanofiki. Pilatos hojana hiki ida makhira-ra arakhaonanivini. ");
INSERT INTO padNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hari. Kama'da'ihi ida ija'ari vaipohiki vabodi'barahana: —Hihada vani abinina-ra anofija. Iarakha'a bana ada Barrabás akadiania, ajihira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Hari. Cadeia hojaki ada Barrabás. Barrabás kidipohi khama vakajoniki ada Pilatos va'ora vaka'da'divini, oniani ida Pilatos kasorara va'ora vidavini hija. Pilatos kasorara hoarana-ra vanaabini'aha. Oniaroa, sorara vagathi'bo'da'iki ada Barrabás, cadeia hojaroni'aha. ");
INSERT INTO padNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hari. Pilatoa binofiki ida Jesu-ra arakhavini ajihira kaimoni, oniania, va'ora vara ni'a'ianaha adani ija'ari vaipohiki. ");
INSERT INTO padNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Vabodi'bara'ianaha: —Ivahonariahi'a aka'itapoamisahanana o Jesus ava akasanakhamakia, abinira kaimoni — Pilato-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Oniaroa, Pilatos va'ora nana'dohi'ianaha: —Nahina mani ida kidibadani jahariki hija? Badani jaharikia kabadanirina mani ida nahina jahariki-ra okaragaravini hija, oniani ida abinina ovahonariahiravini hija. Va'ora ohonariaki bana adani kodisorara Jesu-ra vidafiavini xikotxia, naothinia ajihina ova'ahaki bana ada — va'ora ni'aha ada Pilatos. ");
INSERT INTO padNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bodi'barahi ka'oa vahoja'aha: —Ivahonariahivini ava akasanakhamakia aka'itapoamisahana'ina. Ni-Pilatoa bikaabokajanaki ida vakadibodi'barai. Va'ora no'avini hiki ida vanofiki. ");
INSERT INTO padNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Oniaroa, Pilatoa bivahonariahiha ada Jesus abinina. Nimania ida vakanikhariabakhiaki. ");
INSERT INTO padNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hari. Pilatoa bivahonariahi'aha ada Barrabás arakhana, aihotara kaimoni. Ovari-ra cadeia nahojana hiki sorara-ra dafiavini, kaabiniki ada jaboni. Pilatoa biarakha'aha ada Jesus ava akasanakhamakia avaka'itapoamisahanakia abinira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hari. Oniaroa, Jesu-ra ai vavaniha'aha adani Pilatos kasorara. Avikhana kaba'i, vakaragarari'aha ada Simão. Cirene sidaji kaija'arini ada. Amasia khana vanoki'aha, vagathi'aha, vani'aha: —Ivani, Jesu-ra kakaiba'ahi hihida ava akasanakhamaki — sorara vani'aha ada Simão. Oniaroa, Jesus naothia ava akasanakhamaki-ra avikasiagaki ada Simão. ");
INSERT INTO padNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hari. Ija'ari vaipohiki jaboni avikasiagaki. Vahararana vahojaki adani gamo Jesu-ra vakaasaravini vaabarariariaki. ");
INSERT INTO padNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus vada va'ora ni'aribani'aha, va'ora ni'a'aha: —A'onivani gamo Jerusalém sidaji kaija'arini a'oni. Hari'a hora vakaasarajana. Avaabononi vakaasara bana, avakadisai-ra va'ora vakaasara jaboni bana. ");
INSERT INTO padNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Khaki bana ida mahi jahariki ija'aria vani'aki: “Jahaki ida gamo vaisariki vakadimoni hini. Mahi jaharini oadani ni-vakamithaki ida isai 'banani, ni-isai-ra vakanajohohaki jaboni bana.” ");
INSERT INTO padNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kaikahiki bana ida mahi ija'aria vani'aki: “Anofiki ida arabo namahiki aadafanahani anamana ariabinija kaimoni.” Vani'aki bana jaboni ida arabo namahiki: “Nami haria ka'dama'a mahija ariabinivini.” ");
INSERT INTO padNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nimania hida hora vanaima'banavini, ava amaki fori ohina kaba'i. Niha vani'a'aki koda ida a'onira vanaima'banavini arafiani ava ara'okhoki fori avihiki a'oni. ");
INSERT INTO padNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hari. Sorara va'ora vavikhaha adani jaboni makhira vi'bamiki Jahari kabadani arafiakia vakabadaniki, va'ora avaka'itapoamisahanara kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Oniaroa, avavikha'aha Gólgota ibavi onikia avavakhano'aha, Jesu-ra avaka'itapoamisahana'aha, varagaamanani'ihi ida ava akasanakhamaki nami khorahaki bodinia. Gólgota ibavi oniki pamoari athini ka'da'di kajaroni kaibavini ida. Ava akasanakhamakia va'ora avaka'itapoamisahana'aha adani vi'bamiki jaboni. Vanaibavi'aha ada hoarana Jesus pitana aniaja, vanaibavi'aha ada hoariha Jesus pitana kajasonija. ");
INSERT INTO padNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Oniaroa, Jesua bini'aha: —Kodiabi'i, ina'bira hida bana vakadibadani jahariki kodiania mahija va'ora iakariakavini. Ni-avigaki ida bada vani'aki. Oniaroa, sorara vania varavina'ihi ida Jesus kamakari. Vakosonakhamaki ida ja'di pitani jiriki, avigaja kaimoni hida kidimakari ravina'ini. ");
INSERT INTO padNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hari. Ija'ari vaipohiki Jesu-ra vada vani'a'aha. Judeus kaija'ari vanava'isohiva abono avigaraha'aha ada Jesus. Vani'abakhiaha: —Jesus va'ora akava'ijoaha adani vahoariha. Cristo hina-ra kahiha. Deua binagathogathovini-ra kahiha. Abono-ra akava'ijoava, ava akasanakhamakia abono-ra ani'ava — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sorara jaboni avigaraha'aha ada Jesus. Vanamaakari'aha, avarakasihi ida vinho kaidivariki viaha. ");
INSERT INTO padNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Vani'aha: —Jesus, judeus kaija'ari vakadika'da'di i; iabono akava'ijoa bana. ");
INSERT INTO padNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hari. Jesus ka'da'di kanamania kahoja'iki ida tábua kajiriki. Tábua kajirini athini: “Judeus kaija'ari vakadika'da'di hada.” ");
INSERT INTO padNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hoarana Jahari kabadani arafiakia kabadaniki ava akasanakhamakia hojaki varani jaharikia Jesu-ra kanavaraniha'aha jaboni: —Cristo ihi'badarani-ra ikahimanija? Iabono akava'ijoa'a bana. Haria akava'ijoa jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jahari kabadani arafiakia kabadaniki hoariha bikaabani'aha ada 'bamina: —Deu-ra ifiniria? Akadibadani abosini ida ariabinihahavina-ra vavahonariahivini. ");
INSERT INTO padNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Asohiki ida haria vanaima'banavini. Hojai jaharikia akabadanibakhiana abosini ida aimana 'banani. Ovaria ni-bada bini'a'iki ida badani asohiriki. ");
INSERT INTO padNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Oniaroa, bini'aha ada Jesus: —Jesus, ka'da'di ihini ijoini kamahini, hora kava'ihoki bana mahija hora iva'adivini. ");
INSERT INTO padNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesua bigathanihi ida athi: —Ka'oa oamani hida kodivarani. Hidakaba'i Deus kania namajaja ihojaki bana i kodiania. ");
INSERT INTO padNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hari. Safini sohirarina amaakarina vani, kama'da'ihi ida safini vagajanarina. Bakibaki'iki ida arabo hahavi. Safini ajora'ina avagani kama'da'ianahi. ");
INSERT INTO padNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Oniaroa, 'bira'ihi ida makari katokihi judeus kaija'ari Deu-ra khai vani'avini kagorani ka'oahafianihiki. Khiorarini akapitakhama'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Oniaroa, bodi'bara'aha ada Jesus: —Kodiabi'i, isa'ani kabodinia oarakhaki bana hida oma'onahana. Bodi'barana naothinia abini'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hari. Roma sidaji kaka'da'dini kasorarani maakarina hojakia binoki'ihi ida namitha'iki, Deu-ra khai ni'a'aha, bini'aha: —Hojai jahaki ka'oa kahojaiki hada makhira. ");
INSERT INTO padNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nokiva abono vahoariha ava akasanakhamaki kania vajoronikia vanoki'ihi ida namitha'iki, vanoki'aha ada Jesus abinina. Vagorana vajoi'aha vajaforia. Vava'i mokara nini mani ida va'ora nabarariariaja, vani'aha: —O Jesus maha, o Jesus maha — vamakho'ini-ra vakapatapataha'oadahavini vava'i mokara nini. ");
INSERT INTO padNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Oniaroa, Jesus kava'ahi hahavi napaja pa'itxi vahojaki vada vakhanina. Gamoa jaboni abinina vanoki'aha. Galiléia kaarabonia Jesus aadahaonina kari, gamoa vavaipohihaki ada. ");
INSERT INTO padNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Hari. Ava akasanakhamaki maakarini kania hojaki ada José de Arimatéia jaboni. Judéia kaarabonia hojaki ida sidaji Arimatéia oniki. Jahana vani vakahiha ada José. Asohiki ida kidihojai. Binokhaki ida mahi Deus ija'ari hahavi-ra va'ora vaka'da'divini. Jesu-ra kajari'dariki ada. Vahoariha vaipohikia abinina vanofiha ada Jesus, Joséa ni-abinina binofipa'itxiki. ");
INSERT INTO padNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hari. Pilatos kania okha'aha, bikanikharia'ihi ida Jesus aba'ona, bika'damahaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Oniaroa, ava akasanakhamaki kania okha'ianaha, biani'ihi ida Jesus aba'ona, bikarafoa'ihi makari jahakia. Ka'damahi ibavinia biavikha'ihi. Ja'di hodijama'oki bodinia biobaiha'ihi ida Jesus aba'ona. Khorahaja'diniki ida ja'di hodijama'oki. ");
INSERT INTO padNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hari. Safini ajorana vakadi'akoiri kama'dani viahania vaka'dama'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Avikhamaniha adani jaboni gamo Galiléia kaarabonia, aba'oia biavi'oiki ibavini-ra vanoki'aha. Vanoki'ihi ida Jesus aba'ona niha vani'a'avini biobaivini. ");
INSERT INTO padNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Naothinia vajoi'aha gora vavahojaki kania. Vanakabodi'ihi ida basina fori hiki misaia, Jesus aba'ona-ra vakavamisaihavini kaimoni. Misai-ra vanakabodivini naothinia avakoiri'aha adani gamo. Deus kava'isohihi jiriki ida va'ora honariaja avakoirina kamahini. ");
INSERT INTO padNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hari. Domingo vani mahi avagani kama'dani avikha'ianaha adani gamo aba'oi ka'damahani ibavini kania. Avavikha'ihi ida misai vanakabodi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Oniaroa, avakhano'aha vanoki'ihi ida ja'di hodini kaathani katapajanarini. Ania'iki ida ja'di. ");
INSERT INTO padNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hari. Avikhajakosi'aha, ni-vakaragaki ida Jesus vakadika'da'di aba'ona. ");
INSERT INTO padNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Vakava'ibodivarani'ihi ida Jesus aba'ona hojajanarini, ni-avigaki ida aba'ona niha ninini avisoni'ini. Vava'i bodini vara nini kaba'i, vaviaha vanokiajoraki'aha adani makhira vi'bamiki. Vakaimahaki ida makari vagaki. ");
INSERT INTO padNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hari. Vaimahida'aha adani gamo. Vaimahidakarahona mani ida va'ora hasi ni'aja. Vanokho-ra vaka'oaha'aha. Oniaroa, va'ora vani'aha adani gamo: —Nahina mani ida aba'oi ka'damahani ibavini kania ija'ari ahokiki-ra avanako'dihavini hija? ");
INSERT INTO padNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ni-hida hojajanariha ada Jesus. Ada ahoki'aha. Vakava'ibodivarani'a bana ida a'onira ni'avini hi'iki Galiléia kaarabonia avahojani kari. ");
INSERT INTO padNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jesus a'onira ni'a'iki a'oni: “Hovani ija'ari hahavi vakadi'aajo ho. Vahoariha hora avarakhaki bana ija'ari vakadihojai asohiriki vasa'a kabodinia, ava akasanakhamakia hora avaka'itapoamisahanaki bana adani. Oabinina naothinia radahahi ida mahi ahoarabakosiki oniaroa, oahokiki bana ho.” A'onira ni'a'iki ada. ");
INSERT INTO padNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Gamoa mitha vani'a'ihi ida makhira vaathi, vakava'ihoki'iki ida Jesus athi va'ora nava'isohijoravini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oniaroa, ai vihi'aha, vajoi'aha. Jesus ipohina 11 vihiki vaipohina vakadiania va'ora vananamithavini hi'ihi ida vanoki'iki, vakamitha'iki. Vahoariha-ra va'ora vananamitha'aha jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hari. Hi'adani gamo aba'oi ka'damahani ibavini kania avikha'iki vaonina Maria Madalena, Joana, Tiago kaamia Maria oniki vihiki. Gamo vahoariha jaboni va'ora vavaipohiha'avini 'dama kania. Va'ajihina naothinia Jesus athi avavaadahaoniva abono vakadiania avikha'aha adani gamo, va'ora vananamithara kaimoni vanoki'ikia. ");
INSERT INTO padNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Oniaroa, vakamitha'ihi ida gamo vakadivarani, vakajari'damanihi. Vakava'ibodivaraniki ida ija'ari kabajadiki kavarani fori hini ida gamo vakadivarani. ");
INSERT INTO padNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hari. Pedro vani ada gaa'aha, ajihi'aha, ki'daraha'aha, aba'oi ka'damahani ibavini kani-ra anikha'avini. Akhano'aha, vada biani'ajakosi'ihi ida ja'di hodijama'oni, binoki'ihi ida makari, Jesus aba'ona karafoani hiki. Ni-nahina hoariha-ra noki'iki ada Pedro. Oniaroa, gora vavahojaki kania joi'aha, bikava'ibodivaranikaraho'ihi ida namitha'iki. ");
INSERT INTO padNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hari. Domingo vani va'ajihi'aha adani Jesus ipohina vi'bamiki. Emaús ibavi-ra avanikhahavini. Emaús kanapajahikhamarihi ida Jerusalém sidaji. Safini sohirarina va'ajihi'aha, mithani vaivaini vakaikahira kaimoni. ");
INSERT INTO padNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Vaadahana kaba'i, vaabono vara vakani'akhama'aha. Vakadivarani hiki ida Jesus abini'ina, aba'ona avisoni'ini ja'di hodijama'okia. ");
INSERT INTO padNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Vara vakhanina kaba'i, va'ora namaakari'aha ada Jesus, adaha'aha vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesus ipohina vanoki'aha ada makhira, ni-avigajorakiki ada makhira Jesus hina. Deua biva'aharihi ida Jesus hina avigavini. ");
INSERT INTO padNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Oniaroa, Jesus va'ora nana'dohi'aha: —Nahina mani hida avakadivarani hija? ");
INSERT INTO padNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Vada vakhani'aha vava'i mokara ni'ini, Cleopas onikia bini'a'aha: —Ivani ihoarani Jerusaléa ihojani kaba'i iogaria koda ida namitha'iki hidanija, hidanija hoariha hiki? ");
INSERT INTO padNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","— Nahina mani ida namitha'ia? — va'ora nana'dohi'aha. Vagathani'ihi ida kidina'dohi: —Ada pohimaja'aha Jesus. Nazaré kasidajini kaija'arini ada. Deus athi namoniva abono ada. Ija'ari vaipohikia vakava'ibodivaraniki ida Deus kidibadani danoki, kidivarani hiki-ra kakodiavini. Ija'ari hoariha kabadani fori hirihi ida kidibadani danoki. Kidivarani Deus kavarani fori hiki ida. ");
INSERT INTO padNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sasidotxi vavaka'da'diva, judeus kaija'ari vanava'isohiva abono khama Jesu-ra avarakha'iki Pilatos kania, ovaria bivahonariahira kaimoni abinina. Oniaroa, Jesu-ra vanaabini'iki adani, ava akasanakhamakia avaka'itapoamisaha'iki ada. ");
INSERT INTO padNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Akadija'ari-ra va'ora akava'ijoaki kaimoni avanihaki ada Jesus, haria vavajaharikia vavahojajanaria kaimoni hida akadiarabo. Hidanija hoariha viahania pohimaja'iki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Akadiania vahojaki adani gamo Jesu-ra avavaipohioni'iki. Hidakaba'i vagavagani vani avikha'aha adani va'oaniaro Jesus aba'ona ka'damahani ibavinia, ni-vakaraga'iki ida aba'ona. Vajoi'aha akadiania haria vani'a'aha: “Va'ora anoki'iki adani Deus ibavi kaija'arini 'dama kania. Haria vanava'isohivini hi'iki ida Jesus ahoki'ina.” Vakhani'aha. Akava'ibodivaranikarahoki ida gamo vakadivarani. ");
INSERT INTO padNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Vakadivarani mitha vani'avini naothinia, aipohina vi'bamiki 'dama kania avikha'aha. Vanoki'iki ida aba'ona ka'damahani ibavini dairini. Gamo haria nava'isohivini fori hiki ida vanoki'iki. Ni-Jesu-ra vanoki'iki — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Oniaroa, Jesus va'ora ni'aha: —Asia avarigariki ida varani Deus athi namoniva abono Cristo-ra vara vavani'a'bo'davini. Avakajari'daki ida vakadivarani. Ni-avarigajorakiki ida vakadivarani nahina hini. ");
INSERT INTO padNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Deua binofiki ida Cristo imana 'banani. Binofiki ida abini'ina naothinia kidiania ajoina. Deua khai bini'aki bana ida kidibadani jahaki ija'ari vahararana. Vithi ibavini jahaki vagaki Deus 'dihana Cristo-ra no'avini — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Oniaroa, Jesus va'ora nava'isohijahaki'aha papira athinia Deus vara bivani'ajora'iki ada Cristo. Jesus va'ora nava'isohi'imidiavini hiki ida Cristo varani hina Moiséa binajiri'iki. Naothinia va'ora nava'isohihi ida Cristo varani hina Deus athi namoniva abono hahavia vanajirihanana'iki. ");
INSERT INTO padNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hari. Vanamaakari'ihi ida ibavi Jesus ipohina avanikhaki. Vagorana vakaikahi'ina radahana-ra nofi'aha ada Jesus, ni-okhajakosi'iki. ");
INSERT INTO padNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Oniaroa, Jesu-ra vakaboa'ibakhiadanokivini hiki vakadiania hojara kaimoni. Ni-aviga'iaki kaho ida Jesus vakadiania adahana. Vani'aha: —Akadiania hoja'a bana. Bakibakini kama'da'iki hida joma. Oniaroa, okhajakosi'aha ada Jesus kidipohi vi'bamiki vakadiania. ");
INSERT INTO padNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mesa kania vithi'aha vakadiania. Jesua bikanabiini'ihi ida pão, Deu-ra ni'a'aha: —Deus, ivani ijahaki i, pãoa haria ino'a'iki i. Deu-ra vara ni'avini naothinia, Jesua bikanapitahatahahi ida pão, va'ora no'avini kihi'ihi. ");
INSERT INTO padNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Oniaroa, vanokho avagahaki fori vihi'aha, Jesu-ra vanoki'aha, aviga'iki ada Jesus. Jorakia avisoni'aha, ni-vanokijanaki. ");
INSERT INTO padNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Oniaroa, Jesus ipohina bini'aha ada hoariha: —Hagihia ariadahana oadani Jesus vara haria ni'avini hiki ida varani hina Deus athi kapapirania hoja'iki, akamitha'iki ida ava'i bodinia khai akhanina. ");
INSERT INTO padNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hari. Jorakia vigaa'aha, ai vihi'aha Jerusaléa vajoi'aha. Va'ora vakaraga'aha adani Jesus ipohina 11 vihiki vajoroniki vahoariha khama. ");
INSERT INTO padNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Vajoroniki va'ora vani'aha adani vi'bamiki: —Ka'oa hiki ida Jesus ahoki'ina varani hini. Simãoa binoki'iki ada akadika'da'di Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Oniaroa, Jesus ipohina vi'bamiki va'ora vananamithavini hi'ihi ida varani hina, hagihia va'ora vaipohiha'avini. Va'ora vani'aha: —Ni-aogajorakiki ada Jesus akadiania adaha'ina. Pão-ra kanapitahataha'aha ada Jesus bona aoga'aha. ");
INSERT INTO padNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hari. Vanoki'ava vahoariha-ra va'ora vara vani'avini kaba'i, jorakia abono-ra nanokia'aha ada Jesus vahararana. Va'ora ni'aha: —Onofiki ida avava'ini jahajahani. ");
INSERT INTO padNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Va'ora narapata'ihi ida Jesus abono-ra nanokia'avini, vaimahida'aha, Jesus ma'onahana-ra vanoki'iki vaabono vavaniha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Oniaroa, Jesus va'ora ni'aha: —Niha avakhanimanija avarapataki? Niha avakhanimanija avajari'daki? ");
INSERT INTO padNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Vada vakani'a bana hida osa'a, o'dama kihiki mahija hora avarigavini. Hora vakaabada mahija oahokina-ra avakajari'daravini. Oma'onahana ohija vaha; ni-hojaki ida oimana, ojarona hiki. Vada hora avani'ahi; oimana-ra avanokihi, ojarona-ra avanokihi jaboni. ");
INSERT INTO padNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hari. Vara nina naothinia, va'ora nanokiahivini kihi'ihi ida sa'a, 'dama kihiki. ");
INSERT INTO padNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vakava'ibodivaranikaraho'ihi ida vanoki'iki, khai vakhanina kaba'i, asia vajari'daki adani. Oniaroa, Jesus va'ora nana'dohi'aha: —Ida hojamanihi 'bai ohaki kaimoni? ");
INSERT INTO padNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jesu-ra vano'a'aha abaisana kodanahakia. ");
INSERT INTO padNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bigathani'aha, vada vani'avini oadani biha'aha. ");
INSERT INTO padNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bihavini naothinia va'ora ni'aha: —Oabinina viahania avakadiania ohojana oadani, vara a'onira oni'abakhia'iki ho afojora athi kapapirania Deus vara hora vani'ajoravini hi'iki. Deus kava'isohihi jirikia hojaki ida varani ohina. Deus athi namoniva abonoa vanajiri'bo'da'iki jaboni ida varani ohina. Moro kakapapirana hojaki jaboni ida varani ohina. Deua bivava'isohihijoraki ida athi kapapirania namithaki kaimoni kodiania. ");
INSERT INTO padNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Oniaroa, Jesus va'ora kajoamora'aha, avigaja kaimoni ida Deus athi papira hojaki. ");
INSERT INTO padNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Va'ora ni'aha; —Deus athi kapapirania vara bivani'ajora'iki ada Cristo. Hovani Cristo ho, Deus hora karona'iki, ija'ari-ra oakava'ijoaja kaimoni. Papira jirini athini ida Deus oimana 'banani-ra nofivini. Binofiki ida oabini'ina, binofiki ida mahi ahoarabakosikia 'dama kania ohojana. Binofiki ida oahoki'ina. ");
INSERT INTO padNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Deua binofiki jaboni ida arabo hahavi kaija'arini-ra va'ora avarakanamonionivini omonina jahakia. Va'ora vanava'isohi bana: “Jesus Cristo a'onira honariavini, vakava'ipahinika'oa bana ida Jahari kabadania avakabadanibakhiani mahija Deua bina'biravini mahija a'onira akariakavini jaboni.” Va'ora vara vani'a bana. Jerusalém kaija'arini-ra va'ora avakanamonioni afo'imidia. Naothinia arabo hahavi kaija'arini vakadiania avikha'a mahija va'ora avarakanamonionivini. ");
INSERT INTO padNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A'onivani avanokihahavi'iki ida kodibadani afohahavi. Avanokiki jaboni ida oimana 'banani, oabini'ina naothinia oahoki'ina. Va'ora vananamithavini hida avanoki'iki. ");
INSERT INTO padNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hovani okaronaki bana ada Ma'onahai Jahaki kodiabi'ia bivava'isohihijora'iki avakadiania okhana. Hojana oadani ada Ma'onahai Jahaki, a'onira no'aha Deus danona. Kharina oadani, Jerusaléa vanokha bana — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hari. Oniaroa, Jerusalém sidajia Jesus va'ora avikhaonani'aha adani kidipohi. Va'ora avikharimanani'aha Betânia ibavia. Vakaikahi'aha. Jesua bikanabiini'ihi ida sa'a, Deu-ra ni'a'aha: —Deus, va'ora kajoamora bana hadani oipohina — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Vara nina oadani, akara'o'aha ada Jesus vakadiania. Nama okasi'ina vani, Deua bigathani'aha. ");
INSERT INTO padNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jesu-ra vakanamasivi'aha adani ipohina. Jerusalém sidajia avajoi'aha khai vakhanina. ");
INSERT INTO padNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hari. Mahi hahavi Deu-ra khai vani'avini kagorani kavasiribanini bodinia vahojaha, Deu-ra khai vani'ahaha'oadaha'aha. Hari ida vani oamani Lucas kavarani anokhomi'ini.");
INSERT INTO padNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hahavi amonahani kama'dani viahania hojahaha'oadahaki ada Athiia oniki. Deus kania hojaki ada Athiia oniki. Deus mani ada Athiia onira. ");
INSERT INTO padNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hahavi kama'dani viahania Deus kania hojahaha'oadahaki ada Athiia oniki. ");
INSERT INTO padNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Deua binakama'da'iki ida hahavi hojaki. Athiia oniki vania binamonaha'ia ida. Deua binakama'daravini oadani, ni-nahina hoariha hojaki. ");
INSERT INTO padNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ni-nahina binahokiki ada Athiia oniki, ovani oa hokihaha'oadahara ada. Ovaria binakama'daki ida ija'ari kamahi anokhomiriki Deus kania. Vagaki ada Athiia oniki. Binavagaki ida ija'ari kava'ibodivarani, Deu-ra ogaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bakibakini kania kha'iki ada Athiia oniki. Bakibakinia ni-bikaabokaki ida mahi vagani fori hiki-ra namokhivini. Nimania jaboni ida Athiia oniki vagana. Ni-ija'ari vakadihojai jaharikia bikaabokaki ida Athiia oniki-ra vanadabavini. ");
INSERT INTO padNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hari. Deua bikarona'iki ada makhira João Batista oniki, Athiia oniki monina-ra avikhananavaki. ");
INSERT INTO padNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","João-ra arakhananavaki Jesus Cristo monina-ra vara vani'ara kaimoni ija'ari vakadiania, ija'ari hahavia vakamithaja kaimoni ida Athiia oniki vagana kavaranihi, kidiania vaabono gahinai vanihara kaimoni. Jesus Cristo onina hoariha ida Athii. ");
INSERT INTO padNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Athiia oniki hiriha ada João Batista. João Batista hiriha ada ija'ari kava'ibodivarani-ra navagara. Athiia oniki vani ada ija'ari kava'ibodivarani-ra navagara, Deu-ra avigara kaimoni. João-ra rakhaki ija'ari vakadiania vara bivani'aja kaimoni ida Athiia oniki vagana kavaranihi. ");
INSERT INTO padNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ka'oa hiki ida Athiia oniki vagana. Kha'aha ada Athiia oniki, Deu-ra avigara kaimoni adani arabo hahavi kaija'arini. Athiia oniki imidia ija'ari vakadiva'ibodivarani-ra navaga'iki. ");
INSERT INTO padNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hi'ada Athiia oniki araboa kha'iki ija'ari vakadiania. Deus, Athiia oniki khama vanamonahavini kaba'i ida arabo, ija'ari hiki, ni-ija'aria aviga'iaki ada Jesus Cristo Deus hina, ni-vavakaijokaki. ");
INSERT INTO padNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kidija'ari vakadiarabo kania kha'aha, ni-judeus kaija'aria vagathaniki. ");
INSERT INTO padNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Judeus kaija'ari vahoariha vaipohiriki vani adani Jesu-ra vagathanijahaki'ara. Vajari'dariki vania vavakaijokara ada, oniani ida Deus kaisai va'ora nihaja. ");
INSERT INTO padNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ija'ari kaisai vani ida gamo jahani bodinia namithaja. Makhira binofihi ida gamo-ra vaisavini, oniani ida vakadisai-ra vanamonahavini hija. Ni-nikia Deus kidisai-ra va'ora namonaha'iki. Deus va'ora nofiki adani ija'ari kidisai vihira kaimoni, ovani oa va'ora nagathogathora adani ija'ari, oniani ida vakadiabi'i nihana hija. ");
INSERT INTO padNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hari. Oniaroa, ija'ari hi'ina ada Jesus Cristo, akadiania kha'aha, hoja'aha. Harivani, Jesus ipohina hari, anoki'iki ida jahana arafiaki. Ija'ari-ra nakaidivavini arafiani mani ida ija'ari-ra va'ora kajoamoravini hija. Ka'oa hiki ada Athiia oniki. Jaha'oamanija ida Athiia oniki kahojai, danoki ada, ogahaki ada jaboni. Deus kaisai hoarana ada, oniani ida Deus kahojaia kanahojaina hija. Deus kaisaia binanokiaki ida Deus danona, jahana, vagana hiki. ");
INSERT INTO padNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João Batista vara bivani'a'iki ada Athiia oniki. Varani 'barakia vara va'ora ni'a'aha adani ija'ari vajoroniki kidiania: —Hada vani hihada a'onira onava'isohivini hi'iki. Onaothia khaki bana ada ovari. Ka'da'di ka'oa ada. Hovani ni-ka'da'di ohirihi. Homiro'a o'banana kaba'i, otanana viahania hoja'bo'da'iki ada — va'ora ni'a'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesus haria nakaidivavini arafiani mani ida haria kajoamorahahavivini hija afobakhia. A'ba'dibakhiaki ida haria kajoamoravini. Bikava'ibodivaraniha'oadahaki ida haria kajoamorabakhiavini, oniani ida haria kajoamoraha'oadahavini hi'ia. ");
INSERT INTO padNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hari. Moisés kohana bigathani'bo'da'iki ida Deus kava'isohihi jiriki. Bigathanihi, va'ora honariaha adani ija'ari vanaabaja kaimoni. Deua biakava'ijoaki ida ija'ari va'isohihi jiriki hahavi-ra naabahaha'oadaha'iki. Nimania ida Moisés athi. Moisés kohana athi fori hirihi ida Jesus Cristo athi. Jesus Cristo vani haria kakodiaja Deus athi-ra anaabavini. Jesus Cristo vania binanokiaja ida Deus ija'ari-ra kajoamoravini niha ninini. Ka'oa mani ida Jesua bivikhaki ija'ari-ra akava'ijoavini kavaranihi. ");
INSERT INTO padNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni-ija'aria binoki'iaki kaho ada Deus. Kidisai hoarana vania binokira ada. Kidiabi'i 'dihana hojaki ada. Deus hiki jaboni ada. Ovaria binanokiaki ida Deus danona, jahana, vagana hiki niha ninina, aogara kaimoni ada Deus. ");
INSERT INTO padNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judeus kaija'ari vanava'isohiva abono Jerusaléa vahojaki va'ora vahonariaha adani sasidotxi, judeus kaija'ari vaka'ojomo'iva abono vihiki João Batista kania avikhana, vanana'dohira kaimoni. Avakhanoha, vanana'dohi'aha: —Hana ihini mani i? Cristo mani i? Ivani Deus ira karonaja ija'ari hahavi-ra va'ora ivaka'da'di'ia kaimoni i? ");
INSERT INTO padNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Vakadina'dohi bigathanimani'aha. Va'ora nava'isohijahakivini, va'ora ni'aha: —Ni-Cristo Deua bikaronaki ohirihi. ");
INSERT INTO padNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hari. João Batista-ra vanana'dohi'ianaha: —Cristo ihirini-ra ikahihi, hana ihini mani i? Elias kohana ahokina mani i? —Iniani. Elias kohana ohirihi — João va'ora ni'aha. —Deus athi namoniva abono Moisés kohana vara bivani'ajoraki mani i? —Iniani — vaathi bigathani'ianamaniha. ");
INSERT INTO padNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hari. João Batista-ra vani'a'ianaha: —Haria nanamitha bana hana ihini, aogaja kaimoni ida kadavarani. Anofiki va'ora anava'isohivini adani haria vakaronaki akhana kadania. Nahina mani ida iabono vara ivani'avini hija? ");
INSERT INTO padNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","João Batista bigathani'ihi ida vakadina'dohi. Vara bivani'a'ihi ida Deus athi namoniva abono Isaías kohana oniki kavarani 'bo'dakari: —Hovani ija'ari amasia adahaki athii 'barakia oathiki ho: “Vanajaha ida hagihi akadika'da'dia bivaadahaki kaimoni.” Nimania ida Isaías kohana vara hora vani'a'bo'da'avini. Hagihi najahani fori hiki hida kodibadani, ija'ari-ra onava'isohivini hiki Jahari kahojai-ra vakava'ipahinira kaimoni, akadika'da'di khana viahania — va'ora ni'a'aha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisio adani makhira João Batista-ra vanana'dohibakhia'iki. ");
INSERT INTO padNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","João Batista-ra vanana'dohi'ianaha: —Ni-Cristo, ni-Elias kohana, ni-Deus athi namoniva abono anokhaki ihirihi. Nahina mani ida ija'ari-ra ikanavini hija? ");
INSERT INTO padNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","João Batista va'ora ni'aha: —Va'ora okanavini paha bodinia. Va'ora ohonaria'iki adani ija'ari kanai karajomihia. Avakadiania hojaki ada hoariha avariga'iariki. ");
INSERT INTO padNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kodika'da'di ka'oa ada ovari. Onaothia khaki bana ada. Ka'da'di oamani ada ovari. Hovani kidihonai abono ho. Arafiaki ida kidihojai jahaka'oaki. Ovari fori ohirihi bana, kaba'i hora nagathogatho'iki ada, oakodiara kaimoni — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betânia ibavia vara vaabono vakani'akhama'aha adani João Batista, nana'dohina vihiki khama. João Batista ija'ari-ra kanavini ibavini nobanija Jordão vainia. ");
INSERT INTO padNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ka'afokajomani vani João Batista bianokiha ada Jesus kidiania kha'ina. Niha ada João: —Ada vani hi'ada ovilia dorona fori hiki Deua bikaronaki. Hojai Deua bivajahariki abosini ida ija'ari abinini. Ovilia dorona-ra anaabinihi; ija'ari-ra akava'ijoaha. Onivani fori hija bana ida ovilia dorona fori hiki abinina, haria akava'ijoara kaimoni. Ovaria bianiki bana ida ija'ari hahavi vakadihojai asohiriki. ");
INSERT INTO padNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Vara ovani'a'iki ada ovari. Kodivarani hi'iki ada: “Onaothia khaki bana ada hoariha. Ka'da'di oamani ada ovari. Hovani ni-ka'da'di ohirihi. Homiro'a o'banana kaba'i, otanana viahania hoja'bo'da'iki ada.” Nimania hida kodivarani a'onira onanamithavini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","33","Oniaroa, João Batista va'ora nava'isohi'iki adani vajoroniki, niha ninina Cristo-ra ogavini: —Jesus khana viahania ni-ooga'iaki ada makhira hana hina ovilia dorona fori hiki. Deus hora honaria'avini ija'ari-ra okanavini. Oniaroa, hora nava'isohijoravini hi'iki jaboni ada makhira hana hina Cristo hina: “Inokiki bana ada Ma'onahai Jahaki garina makhira kania, hoja'ina kidiania. Ovaria bikaronaki bana ada Ma'onahai Jahaki okhana ija'ari vakadiania, vava'i nahonariahihini hiki kaimoni.” Nimania ida Deus hora nava'isohijoravini athini. Asia vara niha ada João Batista: —Oniaroa, onoki'iki ada Ma'onahai Jahaki nama gari'ina, ho'doko kanokiani fori hi'ina. Makhira kania hoja'iki ada Ma'onahai Jahaki. Oniania ooga'aha ada makhira Cristo hina. Hora rakhaki hida ija'ari-ra va'ora okanaja kaimoni paha bodinia. Onanamithaki ada onaothia khaki, akadija'aria avigara kaimoni Cristo hina. ");
INSERT INTO padNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Oniaroa, onoki'iki ada Ma'onahai Jahaki gari'ina, hoja'ina kidiania. Onokivini vani ooga'iki ada makhira Deus hora nava'isohijoravini hi'iki, oniani ida onanamithavini hija Deus kaisai hina ada makhira — niha ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ka'afokajomani João Batista binoki'ianaha ada Jesus. Asia hojamaniha ada João Batista ija'ari-ra kanavini ibavini kania. Kidiania vahojaki adani kidipohi vi'bamiki. ");
INSERT INTO padNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hari. João Batista binokiha ada Jesus radahana, va'ora ni'aha: —Adavani hi'ada ovilia dorona fori hiki Deua bikarona'iki. ");
INSERT INTO padNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","João Batista athi-ra vakamitha'aha adani ipohina vi'bamiki, oniaroa Jesus naothia avikasiaga'aha. ");
INSERT INTO padNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Viaharibani'aha ada Jesus, va'ora noki'aha adani vikasiagaki, va'ora nana'dohi'aha: —Nahina mani hida kodiania avanako'dija? —Jesus, hanaja vania iibavija? ");
INSERT INTO padNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Vanavanavanaha — Jesus va'ora ni'a'aha. Oniaroa, Jesu-ra vavaipohiha'aha adani vi'bamiki. Vanoki'ihi ida gora Jesua bivahojaki. Safini ajorana vani vakaikahi'aha, avikhajakosi'aha. Kidiania vahoja'ina safini-ra avavapahisiri'aha. Naothinia ai vihi'aha adani vi'bamiki. ");
INSERT INTO padNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Vi'bamiki adani João Batista ipohina Jesus naothia avikasiaga'iki. André oniki ada hoarana João Batista athi-ra kamitha'iki. Jesus naothia okasiaga'iki ada André. ");
INSERT INTO padNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hari. Andréa binako'diha'imidiaha ada kidi'aajo. Simão Pedro oniki ada. Bini'a'aha: —Aajo, ada akaraga'aha Deua bikaronaki, Messias oniki — niha ada André. (Messias onina athii hoariha Cristo. Aihotahi abono ada.) ");
INSERT INTO padNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Oniaroa, Jesus kania Andréa biavikha'aha ada kidi'aajo. Simão, André khama vakadiabi'i onina João jaboni. Jesua vada bini'aha ada Simão, bini'aha: —Ionini Simão. Ja'di onini ida ionini hi'ia. Ira ono'avini hiki onii hoariha Cefas — niha'aha ada Jesus. (Ja'di karaho onini ida Pedro ariathia. Pedro onina ida Cefas judeus kaija'ari vaathia.) ");
INSERT INTO padNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ka'afokajomani vani Jesua binofiki ida Galiléia kaarabonia okhana. Okhana viahania Filipe-ra nako'di'aha, bikaraga'aha, bini'a'aha: —Filipe, hora vaipohiha'a bana. Oniaroa, Filipea bivaipohiha'aha. ");
INSERT INTO padNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida sidaji kaija'arini ada Filipe. André, Pedro khama vaibavi ida Betsaida sidaji oniki jaboni. ");
INSERT INTO padNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Hari. Filipea binako'dihaha ada kidiva'ahi Natanael oniki, bikaraga'aha, bini'a'aha: —Natanael, akaraga'iki ada makhira Moisés kohana vara bivani'a'bo'da'iki. Deus kava'isohihi jiriki kapapirania Moiséa binajiri'iki ida varani hina. Deus athi namoniva abono kohana vahoariha jabonia vanajiri'iki ida varani hina. Jesus oniki ada ovari. José oniki ada Jesus kabadia. Nazaré sidajia avijava'iki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaea bini'aha ada Filipe: —Okajari'daki ida nahina jahaki Nazaré sidajia namitha'iki. Ni-Nazaré sidajia namithaki ada Cristo Deua bikaronaki. —Inavanavanaha mahija inokivini — Filipea bigathanihi ida athi. Va'ajihi'aha, Jesus kania avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Oniaroa, Jesua binokiha ada Natanael khana kidiania, va'ora ni'aha adani ipohina: —Hi'o khaki Israel kaija'ari oamani o. Ni-ija'ari-ra nava'iponi'imariniki. ");
INSERT INTO padNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jesu-ra namaakari'aha, Natanaea binana'dohi'aha ada Jesus: —Nihaniki vania hora iogaja hora inokibiininivini kaba'i? Jesua bini'a'aha ada Natanael: —Filipe ira baranahavini viahania ivithima'oni-ra onoki'iki ho figira avani nabo'ani amokhinini kania. ");
INSERT INTO padNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaea bini'a'aha: —Jesus, ivani Deus kaisai i. Ivani akadija'ari vakadika'da'di kaimoni i — niha ada Natanael va'i bodini vara nikaraho'ini. ");
INSERT INTO padNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesua bigathanihi ida Natanael athi: —Figira avani amokhininia ira onokivini-ra okahihi, oniani ida hora ivakaijokavini hija. Kodi'ogahai pa'itxi hida ira onanokiahivini hija. Inokiki bana ida kodi'ogahai danoki karaho. ");
INSERT INTO padNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesus va'ora ni'aha: —Ka'oa hiki hida kodivarani vara a'onira oni'avini hiki bana: Avanokiki bana ida nama arabikhajahani, Jacó kohana binokiki fori hiki. Va'ora avanokiki jaboni adani Deus ibavi kaija'arini avikasina, vigarina kodiania. Ija'ari Deus kania okasini kakara'inani ka'oa ho. Ija'ari hahavi vakadi'aajo ho — va'ora ni'a'aha ada Jesus. Oniaroa, ai vihi'aha adani Jesus kidipohi khama. ");
INSERT INTO padNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hari. Oniaroa, mahi 'bamiki radahani Caná sidajia amonaha'ihi ida akarai kaihinikani. Galiléia kaarabonia hojaki ida Caná sidaji oniki. Hojamanihi ida Jesus kaamia akarai kaihinikani kania. ");
INSERT INTO padNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus kidipohi khama kaboa'ahi vihiki jaboni avikha'aha. ");
INSERT INTO padNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hari. Ihimi'ihi ida vinho. Kidiamia bini'a'aha ada Jesus: —Kodisai, ida ihimi'ihi vinho. ");
INSERT INTO padNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesua bigathani'ihi ida kidiamia athini: —Mamai, ni-onofiki ida kodibadania hora inava'isohivini. Ni-kha'iaki kaho ida kodibadani ka'oa kama'dani kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Oniaroa, Jesus kaamia va'ora ni'aha adani vinho-ra varavina'iki: —Bada vani'a bana hida kodisai a'onira nava'isohivini hiki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hari. Gora vavahojaki bodinia hojaki ida paha bavini na'bahaki 6 hiki ipohini. Ja'di kabavihi ida. Paha bavini hoarani 80 litro-ra gathiki ji'binija kaimoni, hoariha 100 litro-ra gathiki. Onivani fori hija jaboni ida paha bavini hoariha afohanana. Ja'di kabavihia baviki ida paha Deus kava'isohihi jiriki-ra vanaabara kaimoni. Judeus kaija'aria vanaababakhia'iki ida va'isohihi jiriki athini va'ora nava'isohivini hiki, niha vakhanikhanina vaabono visokovini vajahara kaimoni Deus viaha, va'ora kapoarira kaimoni. Vakadihojai hiki ida vasa'a, va'dama vaabono hiki-ra visokobakhiavini kaihinikani. Va'isohihi jiriki-ra vanaabavini kaimoni ida paha ja'di kabavihia hojaki. ");
INSERT INTO padNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hari. Jesus va'ora ni'aha adani vinho-ra varavina'iki: —Vanaji'bini bana hida paha bavini hahavi. Oniaroa, vanaji'binihahavimani'ihi. ");
INSERT INTO padNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Vanaji'binivini naothinia Jesus va'ora honaria'aha: —Vaani bana oni paha pa'itxi paha bavinia hojaki. Avisami akarai kaihinikani vaka'da'diva kania — va'ora ni'aha ada Jesus. Vanaaba'ihi ida Jesus athi. ");
INSERT INTO padNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Avisami'ihi ida paha vinho ihi'iki akarai kaihinikani-ra vaka'da'diki kania. Bikaijo'a'ihi ida paha vinho ihi'iki. Ihinika-ra vaka'da'dikia ni-biogaki ida vinho ibavi hana hinia khani. Vinho-ra varavinakia avigaki ida paha hahavi ja'di kabavihia hojaki vinho ihi'ini. Oniaroa, ihinika vaka'da'diva bibaranaha'aha ada maisa, ");
INSERT INTO padNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","bini'aha: —Maisa hahavi kahojai oamani ida vinho kaidivaki-ra ravina'imidiavini, kanori abono vi'avija kaimoni. Vi'avibakhiavini naothinia va'ora no'a'ianaki adani vinho kaidivariki maina. Ivani inaibavijaha'imidiaki ida vinho kaidivaki jahaki. Vinho hoariha ihimini naothinia haria ino'avini hiki hida vinho jahani arafiaki — maisa-ra ni'a'aha ada akarai kaihinikani vaka'da'diva abono. Vaabono vara vakani'akhamavini kaba'i, ni-aviga'iaki ida paha vinho ihi'iki. ");
INSERT INTO padNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nimania ida Jesus kidibadani danoki-ra nakama'da'avini. Caná sidajia kama'da'iki ida kidibadani danoki. Galiléia kaarabonia hojaki ida sidaji. Rajomi ida Jesus kabadani danoki. Jesua binanokiabiininiki ida jahana danona arafiaki vakadiania, oniani ida ipohina vakajari'daravini hija. ");
INSERT INTO padNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Oniaroa, Cafarnaum sidajia avikharafoni'aha adani Jesus, kidiamia, kidikajo'o, ipohina vihiki, oniaroa vahoja'aha mahi ipohirikia. ");
INSERT INTO padNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Oniaroa, amaakarihi ida Páscoa kaihinikani amonahani kamahini. Gaimori'aha ada Jesus Jerusalém sidajia ihinika amonahani kamahini viahania. ");
INSERT INTO padNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akhano'aha, Deu-ra khai vani'avini kagorani kavasiribanini bodinia okhajakosi'aha. Va'ora noki'aha adani makhira 'daama kahidari, ovilia, ho'doko kihiki-ra pavakari vakaniha'iki. Ija'aria vakapavakarivini hiki ida igitha Deu-ra vakanava'igavini kaimoni hini. Jesus va'ora noki'aha adani jaboni jiniro anaabosiva abono bada vakhanina vakadimesa kai'oarinia. Arabo hoariha kajinironi-ra avakanaabosikhamavini hiki, Jerusalém kajinironia vakajinirora kaimoni adani napaja vikhaki ija'ari. ");
INSERT INTO padNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Oniaroa, Jesua binamonaha'ihi ida va'a kaxikotxihi, va'ora aakojaonanira kaimoni adani ija'ari, 'daama kahidari, ovilia vihiki Deu-ra khai vani'avini kagorani kavasiribanini bodinia vahojaki. Biakanadari'ihi ida jiniro anaabosiva abono vakadimesa. Biakanavararakhama'ihi ida vakadijiniro. ");
INSERT INTO padNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Va'ora honariaha adani makhira ho'doko-ra pavakari vakanihaki: —Vaani hida avakadipavakari hiki hahavi. Hari'a vakanapavakarihi'ibaviniha hida kodiabi'i gorana. Nahina pavakari nihani ibavini hirihi hida gora — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kidipohia vakava'ihoki'ihi ida athii Deus athi kapapirania hojaki: “Deus, ija'ari ira khai vani'avini kagorani-ra onakaidivakarahoki ho. Siho akaha'diki fori kihiki hida gora-ra onakaidivavini ova'i bodinia.” Nihi hida athii pitani papira hojaki. ");
INSERT INTO padNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judeus kaija'ari vanava'isohiva abonoa ni-vavajahaki ida pavakarihi abono-ra va'ora aakojaonanivini, oniania Jesus kania avikha'aha, vanana'dohi'aha: —Aogavini anofiki ida Deus ira honariavini ira honariaravini va'ora iakakojaonanivini. Anokivini anofiki ida badani danokia ikabadanini, aogaja kaimoni ida ka'oa hini Deus ira honariavini. ");
INSERT INTO padNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesua bigathani'ihi ida vakadina'dohi: —Vanatharara bana hida Deu-ra khai ani'avini kagorani. Mahi ahoarabakosikia hovani oanaja'dija bana hida. ");
INSERT INTO padNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jesu-ra vani'a'aha: —46 badara ipohini vani gora vanamonahava abonoa vanamonaha'ia hida gora. Ivani koda ianaja'diki hida gora mahi ahoarabakosikia? — Jesu-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Deu-ra khai vani'avini kagorania kavaranina kaba'i ada Jesus, ovani oa abono-ra vara vani'ara ada. Kidivarani hiki ida abinina mahi ahoarabakosikia ahoki'ina. ");
INSERT INTO padNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hari. Jesus abinina naothinia ahoki'ina, kidipohia vakava'ihoki'iki ida Jesus athi vara abono-ra vani'avini hi'iki, oniani ida Deus athi kapapirani-ra vakajari'daravini hija, Jesus athi ni-vakajari'daki jaboni. ");
INSERT INTO padNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Oniaroa, Páscoa kaihinikani amonahani oadani hoja'aha ada Jesus Jerusalém sidajia. Ija'ari vaipohikia vanoki'ihi ida badani danoki ipohiki-ra bada ni'a'avini, oniani ida Jesu-ra vavakaijokavini hija. ");
INSERT INTO padNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Jesus ni-va'ora vakaijokaki. Ovari va'ora ogaki adani ija'ari hahavi, biogaki ida ija'ari hahavi vakadiva'ibodivarani. Ni-ija'aria vakaabokaki ida Jesu-ra nava'isohivini hiki biogarikia. Biogahahavimani'ia ida ija'ari kava'ibodivarani afohanana. ");
INSERT INTO padNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hari. Oniaroa, hojaha ada makhira Nicodemos oniki. Judeus kaija'ari nava'isohiva abono ada. Farisio jaboni ada. Jahaki ada. Biogavini binofiki ida Jesus ka'ojomo'ihi athini. ");
INSERT INTO padNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Joma vania okha'aha ada Nicodemos Jesus kania, bini'a'aha: —Jesus, aogaki ida ija'ari ka'ojomo'iva abono ihini. Deus ira karona'iki i. Deus ira kakodiarija vaha; ni-ikaabokaki ida badani danokia ikabadanibakhiani. ");
INSERT INTO padNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesua bigathanihi ida Nicodemos athi: —Deus va'ora nofiki adani ija'ari hahavi Deu-ra avigavini vakadika'da'di hina. Ka'oa hi'oamanija hida varani ira onava'isohivini hiki. Namitha'ianarini oadani ida ija'ari, ni-bikaabokaki ida Deu-ra ogavini kidika'da'di hina. ");
INSERT INTO padNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemoa ni-biogaki ida Jesus kavarani nahina hini, oniani ida binana'dohi'ianavini hija: —Bikaabokamanija koda ida makhira kidiamia jahani bodinia okhajakosi'ianana 'bana'ianara kaimoni? Nihaniki vania namitha'ianara ada makhira, na'arihavi hi'ina kaba'i? ");
INSERT INTO padNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesua bini'a'aha: —Ka'oa hi'oamanija hida varani. Namitha'iarini oadani ida ija'ari, ni-bikaabokaki ida Deu-ra ogavini kidika'da'di hina. 'Bana'ianahi ida ija'ari, paha kana'ihi, o'oi'aha ada Ma'onahai Jahaki kidiania, oniani ida Deua bivaka'da'divini hi'ia. ");
INSERT INTO padNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ija'ari kaisai vani ida gamo jahani bodinia namithaja. Ma'onahai Jahaki ija'ari kahojai-ra anaabosivini mani ida Deus kaisai nihani hija. ");
INSERT INTO padNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hari'a ija'ari 'bana'ianaki kavaranihi ira ka'barava. Vava'aha bana ada Ma'onahai Jahaki avakadimahi-ra najahavini hidiaja mahija Deus a'onira vaka'da'divini. ");
INSERT INTO padNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Rajomi kavaranihia okavaraniki bana ho. Sirisiriki voovooni roiroiki. Ija'aria bikamithahi ida sirisiriki ithoni, ni-biogaki ida sirisiriki hanajaja khani, ni-biogaki jaboni hanajaja okha'ini. Okavarajomiki ada Ma'onahai Jahaki sirisiriki fori hina. Ni-ija'aria binokiki khana. Ni-ija'aria biogaki ada Ma'onahai Jahaki ija'ari kava'ibodivarani-ra anaabosivini niha bini'a'avini — Jesua bini'a'aha ada Nicodemos. ");
INSERT INTO padNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemoa binana'dohi'ianaha: —Nihaniki vania namithaki ida hora inava'isohivini hiki ija'ari kava'ibodivarani aabosini? ");
INSERT INTO padNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesua bini'aha: —Ioga'iaria koda hida ira onava'isohivini hi'iki, Israel kaija'ari ka'ojomo'iva abono ihini kaba'i? ");
INSERT INTO padNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ka'oa hi'oamanija hida varani. Vara avani'aki ida nahina aogaki, a'onira ananamithavini hi'iki ida anoki'iki, kaba'i avanofihi ida ariathi-ra avakajari'davini farisio vahoariha khama. ");
INSERT INTO padNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A'onira onava'isohivini hi'iki ida nahina namithaki hidiaja, araboja; oathi-ra avakajari'daha'oadahaki a'oni. A'onira onava'isohiki bana ho nahina namithaki Deus kania nama; avakamithavini kaba'i hida oathi ka'oa hini, avakajari'damanihi. ");
INSERT INTO padNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni-ija'ari okasi'iaki kaho Deus kania nama. Ija'ari hahavi vakadi'aajo vani ada okasi'ara. Ovari gari'iki jaboni. Hovani ija'ari hahavi vakadi'aajo ho — Jesua bini'a'aha ada Nicodemos. ");
INSERT INTO padNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hari. Mahi 'bo'dakari amasia vaadahana kari Moisés kohana biaka'itapoamisi'ihi ida makha amovana ava nokhonia, biragaamanani'ihi ida ava. Onivani fori hija bana ida ija'ari hahavi vakadi'aajo-ra ava kania avaka'itapoamisahanavini, varagaamananiki bana ida ava. ");
INSERT INTO padNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ija'ari abononi gahinai nihahi ija'ari hahavi vakadi'aajo kania; bivakaijokaha; mahi ja'dini anokhomiriki-ra vahojahi. ");
INSERT INTO padNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Deus va'ora nakaidivavini arafiaki adani ija'ari hahavi, oniani ida kidisai-ra karonavini hija vakadiania. Hoarana ada Deus kaisai. Ija'ari Deus kaisai kania abononi gahinai nihahi; mahi ja'dini anokhomiriki-ra vahojahi Deus kania. Ni-Deus kahagihi-ra anakamadaki ida ija'ari, ni-Ibavi Jaharika'oakia okhaki. ");
INSERT INTO padNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Deua bikaronaki ada kidisai ija'ari hahavi-ra akava'ijoara kaimoni. Vakadihojai asohiriki abosini-ra vagathanivini kaimoni hirihi ida kidisai-ra karonavini hija. ");
INSERT INTO padNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ni-Deua bihonariaki ida ija'ari kidisai vakaijokana hiki Ibavi Jaharika'oakia okhani. Deua bini'a'bo'da'iki ida kidisai hoarana vakaijokana hiriki Ibavi Jaharika'oakia okhani. Jesu-ra vakaijokaravini mani ida Ibavi Jaharika'oakia arakhani hija bana. ");
INSERT INTO padNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kha'aha ada Deus kaisai ija'ari vakadiania. Mahi vagani fori hiki ada. Ija'ari Jahari kahojaia vakahojaibakhiana mani ida Deus kaisai-ra vanofiravini hija. Hojai asohiriki-ra vanofivini mani ida vakadiva'ibodivarani vagani-ra vanofiravini hija, oniani ida bakibakinia adahai fori hiki-ra vavajahavini hija, oniani ida ija'ari-ra nasohivini kamahini Ibavi Jaharika'oakia va'ora arakhaja bana. ");
INSERT INTO padNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ija'aria bivajahaki ida Jahari kahojaia kahojaini, oniani ida vagaki fori hiki-ra karamonavini hija, oniani ida Cristo-ra aakara'ovini hija. Vagaki kania maakarija vaha; nokiahi vaha ida kidihojai jaharini. Binofirihi ida kidihojai asohiriki-ra kava'ipahinivini, oniani ida bianahojavini hija, vahoariha avigaria kaimoni ida kidihojai jahariki. ");
INSERT INTO padNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ija'ari hoariha vani ida Deus kahojai jahakia kahojaija. Ni-Cristo-ra aakara'oki, bikaimajahaki ida vagaki. Binofiki ida vahoariha Deus kahojai jahaki-ra vanokivini kidiania, avigaja kaimoni ida Deus athi niha ninini ija'aria binaabavini. ");
INSERT INTO padNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hari. Oniaroa, Jesus kidipohi khama ai vihi'aha, Judéia kaarabonia avikha'aha. Mahi ipohiriki vahoja'aha. Vahoarahanana va'ora kana'aha adani ija'ari athi naabani vihiki. Rajomi kaimoni ida kanai. ");
INSERT INTO padNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hari. Enom ibavi oniki Salim maakarinia hojaha ada João Batista. Ovari jaboni ija'ari-ra va'ora kanaronaha'iki. Vaini vadinia hojaki ida Enom ibavi oniki. ");
INSERT INTO padNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ni-cadeia hoja'iaki kaho ada João Batista. ");
INSERT INTO padNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oniaroa, João Batista ipohina, judeus kaija'ari vaka'da'diva hoarana khama vaabono avakanaathidanoararikhama'aha. Vakadivarani hiki ida kanai hana hini asohiki ija'ari-ra najahavini Deus viaha. ");
INSERT INTO padNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hari. João Batista kania avikha'aha, vani'aha: —Ikava'ihokimanira ada makhira Jesus oniki kadania hoja'iki Jordão vaini nobanija? Vara ivani'a'iki ada makhira. Ovari maina ija'ari-ra kana'iki ada. Ifori hiki ada. Ija'ari vaipohiki avikhaki kidiania. Ni-vaipohijanaki adani ija'ari kadania vikhaki — João Batista-ra vani'aha. ");
INSERT INTO padNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","João Batista va'ora ni'aha: —Khai oni'aki ida Jesus kania avikhana. Deua binofiravini oadani, ni-nahina namithaki akadiania. Namitha'iki ida Deua binofiki, oniani ida Jesus kania va'ora arakha'ia. ");
INSERT INTO padNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","A'onivani avakamithabakhiaki ida kodivarani. Oabono oni'ahi: Cristo ohirihi. Deus hora honariavini Cristo khana viahania. ");
INSERT INTO padNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Okavarajomivini ada ovari maisa fori hina. Ija'ari akarani kamahini maisa vania bivahojaja ida kidigamo kaimoni. Maisa maakarina hojaki ada kidiva'ahi. Maisa kava'ahi kaimoni hirihi ida gamo. Maisa kava'ahi fori ohiki ho. Khai oni'aki ida maisa athi-ra mitha oni'avini. Ija'ari vaipohiki Jesus vakadika'da'di hina-ra vanofivini mani ida khai hora ni'aja. ");
INSERT INTO padNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Avaipohiki bana adani ija'ari Jesus va'ora vaka'da'diki. Ava'ba'dina oadani adani kidipohi, kodipohi vani adani vaihimiki fori vihira. Nimania ida Deua binofiki — João Batista va'ora ni'aha adani ipohina. ");
INSERT INTO padNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hari. Deus kania nama gari'iki ada Cristo, ovaria biogahahaviki ida ogavahaki kaimoni. Ija'ari hahavi vakadika'da'di ada. Ija'ari araboa vanamithaki ni-hahavi-ra avigaki. Avigaki ida vahararana namithaki, vara vavani'aki jaboni ida vanoki'iki, vakamitha'iki hiki vahararana. Hahavi-ra vaka'da'diki ada ovari nama Deus kania gari'iki. ");
INSERT INTO padNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ovaria bivava'isohihiki ida binoki'iki, bikamitha'iki Deus kania nama. Kaba'i, ija'ari vaipohikia vakajari'daki ida moni va'ora kanamonivini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ija'ari Deus monina-ra vakaijokakia binanokiahi ida Deus athi ka'oa hini. ");
INSERT INTO padNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Cristo Deua bikarona'ikia vara bivani'aha'oadahaki ida varani Deua binofiki. Deua bikaronaki ada Ma'onahai Jahaki Cristo kania okhana va'i nahonariahihihaha'oadahana hira kaimoni. Kidiania hojana arafiaki ada Ma'onahai Jahaki. ");
INSERT INTO padNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Deua binakaidivaki ada kidisai. Kidiabi'ia biarakha'ihi ida hahavi hojaki Jesus Cristo sa'a kabodinia bivaka'da'dija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ija'ari Jesu-ra vakaijokahi; mahi ja'dini anokhomiriki-ra vahojahi. Ija'ari Jesus athi-ra naabarihi; ni-bivahojaki bana ida mahi ja'dini anokhomiriki. Bigathanihaha'oadahaki bana ida kidihojai asohiriki abosini Ibavi Jaharika'oakia. ");
INSERT INTO padNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Hari. Oniaroa, farisioa vakamitha'ihi ida Jesus varani hina, vaipohiki adani ija'ari Jesus ipohina hina-ra vanofiki, oniani ida va'ora kanavini hija. Vaipohiriki vani adani João Batista va'ora kana'ara. ");
INSERT INTO padNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ni-Jesus va'ora kana'iki adani ija'ari athi naabani vihi'iki. Kidipohi vani adani va'ora vikanara. ");
INSERT INTO padNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hari. Jesua bikamitha'ihi ida varani hina joiribanini kidiania. Oniania Judéia kaarabonia ajihi'ianaha, Galiléia kaaraboni-ra anajoiha'ianavini. ");
INSERT INTO padNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judéia kaaraboni, Galiléia kaaraboni hiki kahararakhamania hojaki ida Samaria kaaraboni. Hari. Jesua binofiki ida hagihi Samaria kaarabonia radahaki okhana. ");
INSERT INTO padNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria kaarabonia vaadaha'ina kaba'i adani Jesus, Sicar sidaji 'dihania avakhano'aha. Sicar sidaji maakarinia hojaki ida arabo pitani Jacó kohana kidisai José kohana-ra no'a'bo'davini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Arabo pitania hojaki ida paha aniani ibavini Jacó kohana bikhori'iki. Hari. Safini sohirarina vani avakhano'aha adani Jesus paha aniani ibavinia. Napaja vaadahana mani ida Jesu-ra va'ora nafajafajaha'ia. Vithirari'aha ada Jesus nami khorahaki kaja'diribaniki ihini vadinia. ");
INSERT INTO padNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Vithina kaba'i, ai vihi'aha adani ipohina 'bai-ra vakapavakariha'avini sidajia. Jesus hojaroni'ina, akhano'ihi ida Samaria anani kapahahaki. Jesua bini'a'ihi: —Hora bana paha o'aviki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Gamoa bini'a'aha: —Ivani judeus kaija'ari i. Hovani samaria anani ho. Avakadija'ari akadija'ari khama ni-vaabono vakaimajahakhamaki. Ni-kadaija'aria vakaimajahaki ida akadipaha bavini, oniani ida paha hora ikanikhariavini-ra okava'ibodivaranikarahovini hija. ");
INSERT INTO padNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesua bini'a'ihi: —Ni-hora iogaki. Ni-iogaki jaboni ida Deus ija'ari-ra no'avini hiki. Paha ija'ari-ra nahokikia Deua bino'aki ida ija'ari. Hora iogaja vaha; kodiania ikanikhariahi vaha ida paha vara ovani'a'iki; ira ono'amanihi vaha. ");
INSERT INTO padNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Gamoa bigathanihi ida Jesus athi: —Bihiaki hida hodi. Ni-ivahojaki hida bavi ahoki paha-ra ikhinimafarivini kaimoni. Hanajaroha paha ija'ari-ra nahokiki-ra ikaragaki koda i? ");
INSERT INTO padNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Asia vara nihi ida gamo: —'Bo'dakari akadi'arahoda okhananavaki Jacó kohana bikhoriki hida paha aniani ibavini hodi. Bi'avi'iki ida kidikhorahi kapahani, kidisai kohana vi'aviki jaboni ida, vakadigitha vi'aviki hida hodi kapahani jaboni. Hojaroniki ida nami khorahaki kapahani akadimoni hi'ini. Kidija'ari vanamitharonisiagaki hari. Ka'da'di hi'iki ada Jacó kohana. Ivani ka'da'di mani koda i? Jacó kohana ka'da'di hina-ra iaradamanija? ");
INSERT INTO padNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesua bini'a'ihi: —Hihida hodi kapahani ija'aria bi'avibakhiavini kaba'i, mitihini kanabidini akaafora'ianaki. ");
INSERT INTO padNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ni-niki ida paha okavagahinaivini onofiki. Hoaranija ija'aria bi'avihi; ni-akaaforajanaki ida kanabidini mahi anokhomirikia. Vaini ka'da'dini kapahani kama'dani vani fori hija ida paha ija'ari va'ini bodinia khaonanini. Ija'ari-ra nahokiki fori hiki ida paha, oniani ida kidimahi ananokhomijanarini hi'ia. ");
INSERT INTO padNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Gamoa bini'aha ada Jesus: —Hora bana hida paha ini'akia mahija okanabidi akaaforajanaravini, hihida paha khinimahafarini ibavinia okapahahajanaria kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","— Ianikha'imidia'a ada kadamakhira — Jesua bini'a'ihi. ");
INSERT INTO padNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","— Iniani, okamakhirarihi — bini'aha. Jesua bigathanihi ida athini: —Ka'oa hi'oamanija hida iathini, ikamakhirarini-ra ikahivini. ");
INSERT INTO padNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Makhira sa'ai kahoarani vihiki vania ikamakhira'ia. Ni-kadamakhira ka'oa hiki ada kadamakhira hiki. Kadani hiriha ada. Ka'oa hiki ida ikamakhirarini-ra ikahivini. ");
INSERT INTO padNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hari. Gamoa bikava'ibodivarani'ihi ida Jesus kavarani kidihojai niha nininia ogani hina. Bini'aha: —Deus athi namoniva abono oamani i — niha'ihi ida gamo. ");
INSERT INTO padNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ni-binofiki ida abononi vara vani'avini, oniaroa gamoa binana'dohiha ada Jesus vakadija'ari kahojaia: —Hihida arabo namahiki Samaria kaarabonia akadija'ari avikhananavaki kohana Deu-ra vakanamasivi'iki. Judeus kaija'ari vani adani haria vani'abakhiara: “Ni-asohiki hida Samaria kaarabonia Deu-ra avakanamasivivini ibavini hini. Jerusalém sidaji vania jahaja ida Deu-ra vakanamasivivini ibavini hini.” Nimania ida kadaija'ari vaathi afobakhia. ");
INSERT INTO padNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesua bini'a'ihi ida gamo: —Onofiki hida oathi-ra ikajari'daravini. Khaki bana ida mahi ija'ari Deu-ra vakanamasivijahakivini kamahini. Ni-hihida arabo namahiki ka'oa Samaria kaarabonia vakanamasiviki ada Deus. Ni-Deu-ra khai vani'avini kagorani ka'oa Jerusaléa hojakia ija'aria vakanamasiviki ada Deus jaboni. Ibavi hahavi vania ija'ari Deu-ra vakanamasivivini jahaja. ");
INSERT INTO padNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","A'onivani Samaria kaaraboni kaija'arini Deu-ra avakanamasivibakhiavini kaba'i, ni-Deu-ra avarigaki. Harivani judeus kaija'ari hari. Deu-ra aogaki hari. Akanamasivibakhiaki ada. Judeus kaija'ari hiki ada ovari ija'ari-ra akava'ijoaki kaimoni Deua bikaronaki. ");
INSERT INTO padNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Khaki bana ida mahi ija'ari Deu-ra vakanamasivijahakivini kamahini. Kama'da'iki ida mahi. Ma'onahai Jahaki ija'ari-ra va'ora kakodiavini, vakaabokaja kaimoni ida Deu-ra vakanamasivika'oavini niha ninini Deua binofivini. Deu-ra vanofika'oavini mani ida vakanamasivijahakivini hija bana. Vakanamasivivini hiki vakadiabi'i ada Deus. Vakadiabi'i va'ora nako'diki adani kanamasivina vihiki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ma'onahai ada Deus. Nokiariha ada. Ma'onahai Jahakia biakodiaki ida ija'ari va'ini bodinia Deu-ra vakanamasivira kaimoni. Nimania ida Deua binofiki ija'ari kanamasivina hiki va'ini bodinia — gamo-ra ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Gamoa bini'aha: —Aogaki bana ada aihotahi abono khana Deua bikaronaki, Cristo oniki. Khana kamahini haria nava'isohivini hiki Deus athi hahavi nahina hini. ");
INSERT INTO padNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesua bigathanihi ida athini: —Hovani Cristo ho, vara ira oni'aja. ");
INSERT INTO padNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hari. Oniaroa, vakhano'aha adani Jesus ipohina 'bai-ra vakapavakarihavini vajoi'ina. Vakava'ibodivaranikaraho'ihi ida Jesus gamo-ra vara ni'avini. Vakadihojai hirihi ida, kaba'i ni-vanana'dohiki ida gamoa binofiki. Ni-vanana'dohiki jaboni ada Jesus: —Nahina mani ida gamo-ra vara ini'avini hija? — ni-vani'a'iki. Vava'i bodini oavania vara vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oniaroa, ajihi'ihi ida gamo. Binahojahahi ida kidipaha bavini, ajoi'ihi. Sidaji hi'ini vani va'ora vara ni'aha adani sidaji kaija'arini: ");
INSERT INTO padNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","— Vanavanavanaha'a bana ada makhira kodibadani hahavia okabadanina hora nanamitha'iki. Cristo mani koda ada okaraga'ara nami khorahakia kania? — va'ora ni'ahi ida gamo. ");
INSERT INTO padNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jesus monina-ra vakamithavini vani avikhaonani'aha adani sidaji kaija'arini vaipohiki Jesu-ra vanavanavanahavini. ");
INSERT INTO padNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hari. Avakhanorina oadani Jesus ipohina vani'aha: —Jesus, 'bai'a bana. ");
INSERT INTO padNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Va'ora ni'aha: —Iniani. Ovahojaki ida 'bai avarigariki. ");
INSERT INTO padNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hari. Vaabono vakanana'dohikhama'aha: —Ija'aria koda bivikhamani'ia ida 'bai kidimoni? ");
INSERT INTO padNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus va'ora ni'a'aha: —Iniani. Ni-nahina bivikhaki ida 'bai. Hora karonakia bihonaria'iki ida badani bada oni'avini binofiki. 'Bai ohaki kaimoni fori hiki ida kidibadania okabadanina. Onofiki ida badani hora honariavini hiki-ra ona'diahivini. ");
INSERT INTO padNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nimania ida ija'ari vakadivarani afobakhia: “Masiko ako'bamahakhamaki radahana naothinia a'diki bana ida akadirakhajahi bononi.” Vakhaniki adani. Hi'adani ija'ari kodiania vikhaki rakhajahi bononi a'diki fori vihiki adani. Vada va'ora vani'ajahaki bana adani ija'ari vikhaki, trigo kasiroini fori vihiki adani. A'dihi ida rakhajahi bononi. Hidakaba'i ija'aria biava'boaki ida. Hidakaba'i kodiania vaabono gahinai vanihaki adani vikhaki. ");
INSERT INTO padNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Honai abonoa biava'boaki ida kidika'da'di karakhajahi bononi, oniani ida kidibadani abosini-ra gathanivini hija. Deus karakhajahi bononi a'diki fori vihiki adani hora vakajari'dariki. A'boahi kabadanihi abosini ida mahi ja'dini anokhomiriki Deus kania gahinana hija. Khai vakhanijabanaki adani ija'ari varakhajahaki, ija'ari ava'boahaki khama. Khai vani'aki ida rakhajahi a'diki a'boani abosini. ");
INSERT INTO padNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ka'oa hiki ida varani ija'aria vani'abakhiaki: “Makhira hoarana binatxiotxiohi ida rakhajahi 'ba'dani. A'dini kamahini makhira hoariha biava'boaki ida.” Vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nimania bana hida varani namitha'iki avakadiania. Vahoariha vanatxiotxio'imidiaki fori hiki ida Deus athi, naothinia avana'diahi'ihi ida vakadibadani. Vahoariha vananamitha'imidiahi ida varani ohina. A'onimaina omonina-ra vara avavani'avini vani avaathini-ra vakajari'dariha adani. A'onira okaronavini hiki ija'ari hora avigariki vakadiania. Rakhajahi a'diki avani a'boaki kabadanihi fori hiki ida omonina va'ora avakanamonivini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Oniaroa, Samaria kaaraboni kaija'arini vaipohiki Sicar sidajia vahojakia vakamitha'iki ida gamo athini, va'ora nanamithavini hi'iki ida kidibadani hahavi Jesua binava'isohivini hi'iki, oniani ida Jesu-ra vakajari'daravini hija. ");
INSERT INTO padNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Oniaroa, Jesus kania avakhano'aha, vakaboa'idanokiha vakadiania hojara kaimoni. Oniaroa, mahi 'bamiki hoja'aha ada Jesus vakadiania. ");
INSERT INTO padNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hojaha. Vakamithahi ida athi, oniani ida ija'ari Jesu-ra vakajari'dariki-ra va'ora ana'ba'dija. ");
INSERT INTO padNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Gamo-ra vani'aha: —Ni-akajari'da'imidiaki ida Jesu-ra vara ivani'avini. Hidakaba'i ni-akajari'daki ida kidivarani akamitha'iki. Aogaki ada ija'ari hahavi akava'ijoava abono hina. ");
INSERT INTO padNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hari. Oniaroa, Samaria kaarabonia mahi 'bamiki vahoja'aha adani Jesus Sicar sidaji kaija'arini vakadiania. Naothinia va'ajihi'aha, Galiléia kaarabonia avajoi'aha. ");
INSERT INTO padNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Niha ada Jesus: —Deus athi namoniva abono-ra vagathanijahakiriha adani ibavi bivavijavaki kasidajini kaija'arini — nimania ida Jesus abono-ra vara vani'avini athini. ");
INSERT INTO padNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hari. Galiléia kaarabonia ajoi'aha ada Jesus. Kaikahina vani Jesu-ra vagathanijahaki'aha adani Galiléia kaaraboni kaija'arini. Va'oaniaro jaboni avikha'iki Jerusalém sidajia vanakanorija kaimoni ida Páscoa kaihinikani. Jerusaléa vakanorina oadani, vanoki'iki ida Jesus kabadani danoki, oniani ida joi'ina vakadiania vagathanijahakivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hari. Oniaroa, Galiléia kaarabonia Caná sidajia joi'aha ada Jesus. Caná sidajia hojana kari ada Jesus, paha-ra vinho aniha'iki ada. Hari. Cafarnaum sidajia hojaha ada ija'ari-ra vaka'da'diki. Va'ora honariafiahaki adani sidaji kaija'arini arabo kaka'da'dini kaimoni. Arabo kaka'da'dini kahonai abono ada ovari. Kavamonikarahoha ada Cafarnaum sidaji kaija'arini vakadika'da'di kaisai. ");
INSERT INTO padNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hari. Ija'ari-ra vaka'da'dikia bikamitha'ihi ida Jesus varani hina Judéia kaarabonia ajihi'ina, Galiléia kaarabonia khano'ina. Oniaroa, Jesus kania akhano'aha, Jesu-ra kanikharia'aha: —Jesus, kodisai kania aokha'ava bana mahija ianaihotavini. Abinihana amaakariki ada kodisai. Ada Cafarnaum sidajia hojaha. ");
INSERT INTO padNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesua bini'a'aha: —A'onivani avanokiravini oadani ida badani danoki ija'ari-ra nava'ibodivaranikarahoki, hora avakajari'daki a'oni. ");
INSERT INTO padNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ija'ari vaka'da'diva bini'aha: —Jesus, aokhajorakiva bana. Kodisai ada abinihana amaakarira. ");
INSERT INTO padNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesua bini'a'aha: —Ajoi'a bana igorania. Ada aihota'aha kadaisai. Ni-makhira bikajari'dajanaki ida Jesus athi, ajoi'aha gorana. ");
INSERT INTO padNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Okharimanani'ina kaba'i, vikha'aha adani kidihonai abono kidiania, vaabono vaakaragararikhama'aha hagihia, vakanamoni'aha: —Ada aihota'aha kadaisai. ");
INSERT INTO padNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Va'ora nana'dohi'aha: —Safini nihafori hikajomana vani akabaravarina kama'da'ara ada kodisai? Vagathani'ihi ida kidina'dohi: —Hidanija safini aadosina vani akabaravari'ara ada isai. ");
INSERT INTO padNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Isai kaabi'ia bikava'ihoki'ihi ida safini aadosi'ina hidanija Jesua bini'avini: —Aihotaki bana ada kadaisai — oniani ida makhira, gorana kaija'arini khama Jesu-ra vakajari'daravini hija. ");
INSERT INTO padNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judéia kaarabonia okhana viahania ada Jesus, bada bini'aroniki ida badani danoki karajomihi hoarani. Ajoina Galiléia kaarabonia bada bini'a'iki ida badani danoki karajomihi hoariha, ija'aria avigara kaimoni ada Jesus Deus kaisai hina. ");
INSERT INTO padNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hari. Oniaroa isai-ra anaihotavini naothinia, ogaimori'ianaha ada Jesus Jerusaléa. Judeus kaija'aria vanamonaha'ianahi ida ihinika hoariha Deu-ra khai vani'ara kaimoni, oniani ida Jesu-ra arakha'ianaja Jerusaléa. ");
INSERT INTO padNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalém kavasiribanini bodinia hojaki ida ja'di khorahaki kapahaki karaho. Ibavi onini judeus kaija'ari vaathia Betezata. Betezata kamaakarikhamaki ida bakatha ija'ari ovilia-ra avavi'oivini ibavini. Hari. Paha i'oarinia hojaribanaoniki ida amokhini. Sa'ai kahoarani hiki ida amokhini ipohini. ");
INSERT INTO padNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Amokhini kania vi'omaonahaki adani ija'ari vaipohiki vakavamoniki. Vahojaki adani vakamaodorohaki, vatonorohaki, vajo'o aba'oronisiagaki vihiki. Vanokhaki ida paha kitxokitxoni. ");
INSERT INTO padNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ni-mahi hahavi kitxokitxoki ida paha. Deus ibavi kaija'arini vania binakitxokitxoja ida paha. Paha kitxokitxoni kamahini aki'dafafoni'imidiaki ida ija'ari kavamoniki hoarani, aihota'ihi. ");
INSERT INTO padNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hari. Amokhini kania hojaha ada makhira jo'o aba'oronisiagaki. 38 badara ipohini ni-adahaki ada makhira. ");
INSERT INTO padNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Oniaroa, amokhini kania akhano'aha ada Jesus, binokiha ada omaki, biogamanihi ida badara ipohini bivakavamoni'iki. Binana'dohi'aha: —Ia'aihotani-ra inofimanija? ");
INSERT INTO padNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Bigathanihi ida Jesus kana'dohi: —Ha'a, onofiki ida oa'aihotana. Paha kitxokitxoni kamahini ni-nahina hora kajoamoraki. Oviaha-ra avavasokovini, ni-nihanikia oabono oarahokafoniki paha kitxokitxoki kania. Ookharafonina kaba'i, hoariha miro'a aki'dafafoniki oviaha. ");
INSERT INTO padNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesua bini'aha: —Gama'a, inabiini'a o ijorani, adaha'a. ");
INSERT INTO padNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jorakia aihota'aha ada makhira. Gamaha, jorana-ra nabiiniha, adaha'aha. Hari. Judeus kaija'ari vakadi'akoiri kamahini vani Jesus makhira-ra anaihota'aha. ");
INSERT INTO padNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oniania judeus kaija'ari vanava'isohiva abonoa vanokiha ada makhira jorana-ra kaiba'ivini, vani'a'aha: —Hidakaba'i akadi'akoiri kamahini hida. Akadija'ari avikhananavaki vakadiva'isohihi jirikia biva'aharihi ida ija'ari jorai-ra kaiba'ivini akadi'akoiri kamahini. Inaabarihi ida va'isohihi jiriki papira hojaki. ");
INSERT INTO padNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Va'ora ni'aha: —Hi'ada hora anaihota'iki hora honariavini ojorana-ra okaiba'ivini. ");
INSERT INTO padNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vanana'dohi'aha: —Hana hina makhira ira honariaja ijorani-ra ikaiba'ivini? ");
INSERT INTO padNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hari. Ni-bioga'iki ada makhira anaihotana hi'iki. Makhira-ra anaihotavini naothinia ajihijoraki'aha ada Jesus, ija'ari vaipohiki vahararana okhami'aha, oniani ida makhira aihota'ikia biogaravini hi'ia. ");
INSERT INTO padNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Oniaroa, Deu-ra khai vani'avini kagorani kavasiribanini bodinia okhajakosi'aha ada Jesus, biakaragajakosi'aha ada makhira bianaihota'iki, bini'aha: —Iabono akava'igairi bana. Ia'aihota'iki i. Hari'a hojai asohirikia kahojaijana. Hojai nikia ikahojai'ianahi; ipohimajani arafiaki bana i — Jesus bini'a'aha. ");
INSERT INTO padNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Oniaroa, ajihi'aha ada makhira. Judeus kaija'ari vanava'isohiva abono vakadiania okhaha, va'ora nava'isohi'aha: —Jesus vani ada hora anaihota'ara — va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hari. Vaihamahi'aha. Vakadi'akoiri kamahini Jesua bivakaajiravini mani ida vanajahariharivini vanofivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus kania vikhami'aha. Jesua bigathani'ihi ida vaathi: —Kodiabi'i vani va'ora kajoamoraha'oadahara adani ija'ari. Hovani jaboni va'ora okajoamoraha'oadahaki adani. Kodiabi'i ada Deus. ");
INSERT INTO padNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesus kavarani va'ora naihamahi'ianaha adani judeus kaija'ari vanava'isohiva abono. Va'ora naihamahibiininiki ida vakadi'akoiri kamahini Jesua bivakaajiravini. Va'ora naihamahi'ianaki ida Deua kaabi'ina-ra kahivini. Deus hina-ra kahivini va'ora naihamahi'ahapiki'aha, oniani ida Jesu-ra vanaabinivini-ra vanofivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hari. Oniaroa, Jesua bigathani'ihi ida judeus kaija'ari vanava'isohiva abono vakadi'aathidanoarari: —Ka'oa hiki hida kodivarani vara a'onira oni'avini hiki bana. Deus kaisai ohina kaba'i, ni-hovani oa okaabokaki ida badani Deua bihonariaki. Bada oni'aki ida badani kodiabi'ia bada bini'avini onokiki. Badani hoariha ni-bada oni'aki. Onivani fori hija hida kodibadani. Badani hahavi kodiabi'ia bada bini'aki, kidisai ohina mani ida bada oni'avini hija jaboni. ");
INSERT INTO padNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kodiabi'i hora nakaidivavini mani ida kidibadani bada bini'akia hora nanokiahihahavivini hija. Hora nanokiahivini hiki bana ida badani jahani arafiaki bada oni'aki kaimoni. Kodibadani a'onira ka'baraki bana a'oni. ");
INSERT INTO padNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kodiabi'i kabadani hiki ida ija'ari abini'iki-ra anahokivini, va'ora no'avini hiki mahi ja'dini anokhomiriki kidiania. Kodibadani jaboni kodiabi'i kabadani fori hiki. Ija'ari hana hini-ra mahi ja'dinia ono'avini-ra onofihi; ono'ahi. ");
INSERT INTO padNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ni-kodiabi'ia bivahonariahiki bana ida ija'ari hahavi vakadihojai abosinia. Kodiabi'i hora no'avini hiki ida ogahai danoki okaabokaja kaimoni ida vakadihojai onasohivini, va'ora ohonariafiahavini afohanana Ibavi Jahaka'oaki Ibavi Jaharika'oaki hikia avikhana. ");
INSERT INTO padNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Deua binofiki ida ija'ari hora vavava'ihavini, oniani ida vakadihojai onaabosivinia hora honariavini hija bana. Binofiki ida hora vavava'ihavini, Deu-ra vavava'ihavini vani fori hini. Ija'ari hora kaipahirihi; ni-Deu-ra kaipahiki jaboni. Ija'ari hora kaipahirihi; ni-bikaipahiki jaboni ada kodiabi'i hora karona'iki. ");
INSERT INTO padNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ka'oa hiki hida kodivarani. Ija'aria bikamithahi ida oathi, binaabahi, bikajari'dariha ada Deus hora karona'iki, oniani ida mahi ja'dini anokhomiriki-ra vahojavini hija. Ija'ari vakadihojai asohiriki abosini kamahini ni-vahararana hojajanaki ida ija'ari hora vakaijokaki. Ni-hagihi Ibavi Jaharika'oakia okhakia adahajanaki ida ija'ari hora vakaijokaki. Kama'da'iki ida kidimahi anokhomiriki Deus kania. ");
INSERT INTO padNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ka'oa hiki hida kodivarani. Khaki ida mahi, kama'da'iki ida mahi hovani Deus kaisai ho, va'ora vara oni'ara kaimoni adani ija'ari vaabiniki fori vihiki. Deu-ra avigaravini mani ida vaabiniki fori va'ora nihaja. Oathi-ra vanaabaha; va'ora oanahokiha, kama'daja kaimoni ida vakadimahi ja'dini anokhomiriki. ");
INSERT INTO padNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kodiabi'ia binakama'daki ida ija'ari kamahi ja'dini anokhomiriki. Kodiabi'i kabadani fori hiki jaboni hida kodibadani. Kodiabi'i hora honariabakhiavini hiki ida ija'ari kamahi ja'dini anokhomiriki-ra onakama'davini. ");
INSERT INTO padNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kodiabi'i hora nava'isohi'bo'davini: — Kodisai, ija'ari hahavi vakadi'aajo ihini mani ida vakadihojai inasohivini ira ohonariavini hija. Kadabadani hiki ida ija'ari hahavi vakadihojai jahaki jahariki abosini nahina hinia va'ora inava'isohivini — hora ni'a'aha ada kodiabi'i. ");
INSERT INTO padNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hari'a a'onira ka'barava hida kodivarani. Khaki bana ida mahi ija'ari kohana hahavi oathi-ra vakamithavini kamahini. ");
INSERT INTO padNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Vavaka'damahaki kania vikhaonanihahaviki bana adani ija'ari vaabini'iki. Hi'adani ija'ari badani jahakia vakabadanibakhiaki avahoki'ina Deus kania avikasiki bana adani, kidiania vahojara kaimoni mahi anokhomirikia. Vahoariha vani adani Jahari kahojaia vakahojaibakhiara avahoki'iki bana adani jaboni. Va'ora ohonariavini hiki Ibavi Jaharika'oakia avikha'ina. ");
INSERT INTO padNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Asia vara niha ada Jesus: —Ni-hovani ka'oa okaabokarihi hida ija'ari kahojai-ra onasohivini kabadanihi. Kodiabi'i vani hora nava'isohivini hija ida ija'ari kamahi jahani jaharini, oniani ida nahina binofiki-ra onasohivini hija. Ni-hovani ka'oa oabono ohonariaki, onaabaki ida hora karona'iki athi, oniani ida ija'ari vakadihojai abosini-ra onasohivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Oabono vara ovani'ahi Deus hora karonavini, ni-avarigaki hida kodivarani ka'oa hini ka'oa hirini. ");
INSERT INTO padNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hoja'iki ada hoariha Deus hora karonavinia kavaraniki. Oogaki ida kidivarani ka'oa hini vara hora vani'avini. ");
INSERT INTO padNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","A'onivani va'ora avakarona'iki adani avaathini avikhava abono João Batista kohana kania. Ka'oa hiki ida kidivarani vara hora vani'ajoravini. ");
INSERT INTO padNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ija'ari hora nanamitharavini kaba'i, hovani oogaki ida varani ka'oa hini oabono vara ovani'avini. A'onivani avanofiki ida ija'ari hoariha vara hora vani'avini, oniani ida João Batista kavarania a'onira onava'ihokivini hi'ia. A'onira oakava'ijoavini kaimoni mani ida João Batista kavarani ka'oa hini-ra okahivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Lamparina ha'dini vagani fori hiki ida João Batista kavarani. Kidivarani avakamithavini oadani lamparina vagani kania avaadahaki fori avihiki a'oni. Mahi ipohiriki kidivarani khai a'onira ni'a'iki a'oni. ");
INSERT INTO padNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ija'ari João Batista kavarani-ra vakamitha'ikia avigapa'itxihi ida Deus hora karona'avini. Hari. Vara a'onira oni'avini hiki bana ida kodibadani danoki, avarigaja kaimoni ida Deus hora karona'avini. Kodiabi'i hora no'avini hi'iki ida danona, okaabokaja kaimoni ida badani danoki hora honariavini hi'iki. Badani danokia ija'ari-ra onanokiahivini, oniani ida kodiabi'i hora karonavini-ra avarigavini hija. Deus hora kakodiarija vaha; ni-okaabokaki ida badani danoki-ra onamonahavini. ");
INSERT INTO padNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kodiabi'ia jaboni vara bivani'aki ida hora karona'avini kavaranihi. A'onivani ni-avakamitha'iaki ida vara nina, ni-avanoki'iaki ida nokho. ");
INSERT INTO padNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Avakadiva'ibodivarania hojaja vaha ida kodiabi'i athi; oathi-ra avakapoarimanihi vaha. Hora avakajari'dahi, avakajonihi jaboni ida kodiabi'i hora karonavini varani hini. ");
INSERT INTO padNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Deus athi kapapirania hojaki jaboni ida Deus hora karona'avini kavaranihi. Vada avani'abakhiaki ida Deus athi papira hoja'iki. Avakava'ibodivaraniki ida papira athini a'onira nava'isohivini hiki mahi jahaki ja'dini anokhomirikia avagahinaja kaimoni. Deus athi papira hoja'iki hora vara vani'a'iki ho. ");
INSERT INTO padNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kaba'i, ni-kodiania avikhani-ra avanofiki, avagahinaja kaimoni mahi jahaki ja'dini anokhomirikia. ");
INSERT INTO padNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","A'onira oogaki ho niha avakhanikhanini. Deus va'i-ra avavajahavini-ra avanofiki a'oni. Oogaki ida avava'ini bodinia Deu-ra avanofiravini, oniani ida khai hora avani'a'imarinivini-ra onofiravini hija. ");
INSERT INTO padNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Hora rakhaki avakadiania kodiabi'i hora karona'avini. Ni-hora avagathaniki. Khaki vahabini ida ija'ari hoariha avakadiania Deua bikaronariki, avagathaniki ada ovari. ");
INSERT INTO padNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hojaki ada Deus hoarana, ni-hojaki ada hoariha. Ni-avanofika'oaki afodoro ida hojai Deua bivajahakia avakahojaini, Deus avakadihojai jahani-ra kahira kaimoni. Avanofi'oamanija ida vahoariha avajahaka'oani-ra vakahivini. Avavajaha'oamanija hida varani nikia avaabononi avakani'akhamavini. Nini oadani ida avakadiva'ibodivarani, ni-avakaabokaki ida hora avakajari'daravini. ");
INSERT INTO padNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Avakava'ibodivarani'imariniki ida Moisés kohana kahonari jiriki-ra avanaabavini. Ija'ari kahojai abosini kamahini ni-hovani Deus viaha a'onira oanaathidanoarariki bana honari jiriki-ra avanaabaravini. Moisé-ra avavakaijokavini kaba'i, ovari a'onira anaathidanoararira Deus viaha athi avanaabaravinia. ");
INSERT INTO padNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés athi-ra avanaabaki avaabononi avavanihavini. Ni-avanaabaki. Moiséa binajirijora'iki ida varani ohina. Moisés athi-ra avakajari'darija vaha; ni-oathi-ra avakajari'daki jaboni. ");
INSERT INTO padNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Avakajari'daki ida Moisés vara hora vani'a'bo'davini papira jirikia, oniani ida kodivarani-ra avakajari'davini hija. ");
INSERT INTO padNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hari. Oniaroa, Galiléia ka'dakonia avakakafiani'aha adani Jesus. Galiléia ka'dakoni onini hoariha Tiberíades ka'dakoni. ");
INSERT INTO padNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ija'ari vaipohikia vavaipohiha'aha ada Jesus. Ija'ari vakavamoniki-ra va'ora anaihotavini vanokibakhiavini mani ida vavaipohihavini hija. ");
INSERT INTO padNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Arabo namahikia avigaimori'aha adani Jesus, kidipohi khama. Va'oaniaro miro'a avakhanomori'aha, vavithionaha'aha. Vigaimorisiaga'aha adani ija'ari vaipohiki. ");
INSERT INTO padNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Amaakariki ida Páscoa kaihinikani amonahani kamahini. ");
INSERT INTO padNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus vada niribani'aha, va'ora noki'aha adani ija'ari vaipohiki vigaimorisiagaki vamaakari'ina, oniania binana'dohi'aha ada Filipe: —Filipe, hanaja vania koda bana 'bai-ra akapavakarija hihadani ija'ari hahavi-ra va'ora ano'avini kaimoni? ");
INSERT INTO padNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesua biogaki ida niha ninini va'ora no'avini adani ija'ari 'baia. Binofiki ida Filipe-ra kaijo'avini, oniani ida binana'dohivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipea bigathani'ihi ida kidina'dohi: —Ni-hanaja pão-ra aakapavakarihaki vakadimoni. Ni-arajomaki ida 200 hiki jiniro 'ba'dani pão-ra akanaabosivini kaimoni hini, vagahinara kaimoni pão kabobini kapa'itxia afohanana — Jesu-ra ni'a'aha. Mahi hoarani kavabadanini abosini fori hiki ida jiniro 'ba'dani prata amonahaki hoarani. ");
INSERT INTO padNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hari. Vara niha ada Jesus ipohina André oniki. Simão kakajo'o ada André. Bini'aha: ");
INSERT INTO padNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Jesus, hada hojaha isai ahararana, pão sa'ai kahoarani kihiki-ra kavahojaki. Pão kakaidivariki hida cevada kaoniki. Abaisana 'bamiki-ra vahojaki hada. Ni-ija'ari hahavi hida vahojaki-ra va'ora anarajomaki hada abaisana isai vahi'ana. ");
INSERT INTO padNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Va'ora vahonaria'a hadani ija'ari vaipohiki vavithionahana — Jesus va'ora ni'aha adani ipohina. Hojaki ida arabo namani kahogoini itxani vavithionahara kaimoni. Ija'ari vahararana vahojaki adani makhira 5 mil vihiki vaipohina. ");
INSERT INTO padNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesua biagathi'ihi ida pão, Deu-ra ni'aha: —Deus, ivani ijahaki i, pãoa haria ino'a'iki i — niha ada Jesus. Naothinia biakarakha'ihi ida pão kidipohia vakaravinaja kaimoni. Ija'ari vavithionahaki-ra va'ora vano'afiaha'aha. Onivani fori hi'ianaha ada abaisana. Deu-ra khai ni'avini naothinia biarakha'aha ada abaisana, kidipohia vakavagahinaifiaha'aha. ");
INSERT INTO padNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vi'baihahavi'aha vava'i na'bihahavimani'aha. Vaakharaha'ina naothinia ipohina-ra ni'a'aha ada Jesus: —Vakanajoroni ida pão akahabarini kabobihani, abaisana ahabarina hiki. Ni-onofiki ida 'bai ahabarini kavithimani — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Oniaroa, vanajoroni'ihi ida 'bai ahabarini. Vanaji'biji'biha'ihi ida 12 so'oro pão akahabarinia. ");
INSERT INTO padNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ija'ari vajoronikia vanoki'ihi ida badani danoki karajomini Jesua bada bini'a'iki, oniani ida vaabono vakani'akhamavini hija: —Hada vani hihada Deus athi namoniva abono anokhaki. Moisés kohana vara bivani'ajora'iki ada ovari ija'ari vakadiania kha'iki — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Vanofiki ada Jesus vakadiarabo kaka'da'dini hina, oniani ida Jesu-ra avavadadamivini-ra vanofivini hija. Ni-Jesua binofipa'itxiki. Biogaki ida vagathivini vanofivini, oniani ida arabo namahiki kania Jesus hoarana-ra aragaimori'ianaja. ");
INSERT INTO padNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hari. Oniaroa, mithani vaivaini vani avikharafoniha adani Jesus ipohina. ");
INSERT INTO padNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Vaki'damaha, avakajoifiani'aha, Cafarnaum sidaji-ra avakanikhahavini. Vakavanamina kaba'i, vakajomini'aha. Ni-vakadiania kha'iaki kaho ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Oniaroa, jorakia kaikahihi ida sirisiriki danoki, kana'bahaki ida komini. ");
INSERT INTO padNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Arabo-ra vakananapajahivini vani avakanoki'aha ada Jesus paha namania adahana, va'ora kanamaakari'aha. Vakanoki'aha, va'ora kanaimahida'aha. ");
INSERT INTO padNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","— Hari'a vaimahida. Hovani Jesus ho — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Oniaroa, khai vani'ahi ida Jesus ki'dama'ina vakadiania. Jorakia avakakhanomisi'aha avakanikhaki kania. Avako'omisiha, vigaimoraha'aha. ");
INSERT INTO padNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Hari. Oniaroa, nobanija asia vahojaroniha adani ija'ari vaipohiki Jesus va'ora 'baia no'a'iki. Avakogaki ida kanava kahoarani ka'oa adamia kahojani vi'baina kaba'i. Ija'ari vaipohikia avigaki ida Jesus ipohina vaka'ajihi'ina kanava kahoarania, ni-ki'damana vanokiki ada Jesus vakadiania. Arabo vania vanahojahavini avigaha. Ka'afokajomani vani ni-ija'aria avigaki ada Jesus hanaja okha'ina. Ija'ari vaipohikia asia vakadiania hojaki vavanihaha ada Jesus. Kidipohi vakadiani vania okha'ara ada. Vahojaronikia vanako'di'aha, ni-vakaraga'iki. Vanako'divini kaba'i vakaikahi'aha adani ija'ari vahoariha Tiberíades sidajia vikhaki. Kaipohiki ida vakadikanava. Avi'omisi'aha adani ija'ari vaipohiki, Jesus Deu-ra khai ni'avini kania ija'ari-ra va'ora 'baia no'avini ibavini maakarinia. ");
INSERT INTO padNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ija'ari vaipohiki vava'i-ra kadi hiki ida Jesus hojajanarina. Jorakia vaki'dama'aha kanava afohanana avikafianisiagara kaimoni, Jesu-ra vanako'diha'avini nobanija Cafarnaum sidajia. ");
INSERT INTO padNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hari. Oniaroa, avakhanofianisiagaha adani ija'ari vaipohiki. Vakaraga'aha ada Jesus nobanija, vanana'dohi'aha: —Jesus, nihaforija ikaikahija hida? ");
INSERT INTO padNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus va'ora ni'aha: —Ka'oa hiki hida varani. Hora avanako'divini hiki ida pão-ra avakaha'avini, avava'ini na'bi'ini. Ni-kodibadani danoki-ra avarigavini-ra avanofivini hirihi hida hora avanako'dihavini hija. Pão-ra oakanaipohivini kaba'i, ni-avarigaki ida Deus hora karonavini okhana avakadiania. ");
INSERT INTO padNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ni-hovani ka'oa hora avanako'diharihi. 'Bai vani ida avanako'dihaja kodiania. Ni-a'bo'daki ida ija'ari vakadi'bai vahaki. Hojaki ida 'bai hoariha ija'ari kamahi-ra ananokhomiriki. Bada vani'a mahija 'bai vara ovani'aki-ra avagathanivini, avakadimahi-ra ananokhomiriki kaimoni. Hovani ija'ari hahavi vakadi'aajo ho. Kodiabi'i ada Deus. Hora ni'a'aha: “Kodisai, ira okaronavini hiki ija'ari vakadiania va'ora ino'ara kaimoni mahi ja'dini anokhomirikia” Hora ni'a'iki ada. Hora karonavini mani ida a'onira ono'avini hija bana 'bai ija'ari kamahi-ra ananokhomirikia. ");
INSERT INTO padNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hari. Jesu-ra vanana'dohi'aha: —Nahina mani ida Deua binofija bada ani'avini, agahinaja kaimoni 'bai vara ivani'akia? ");
INSERT INTO padNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus va'ora ni'a'aha: —Iniani, ni-nahina-ra bada avani'arihi. Deua binofiki ida hora karona'avini avakajari'daravini. Binofiki ida hora avavakaijokavini. Nimania ida Deua binofiki. ");
INSERT INTO padNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Vani'aha: —Amasia vaadahana kari adani akadija'ari avikhananavaki, vahabakhiaki ida maná. Vakadikiivi ida maná. Deus athi kapapirania hojaki hida athi: “Ovari va'ora no'avini hiki ida 'bai nama gariki vahaki kaimoni.” Hari. Moisés kohana va'ora no'avini hi'iki ida maná nama gari'iki, akadija'ari avikhananavakia vahaki kaimoni. Anokivini anofiki ida badani danokia ikabadanini kidibadani danoki fori hiki, aogaja kaimoni ida Deus ira karona'avini, Moisé-ra karona'avini vani fori ihini. Hana hini badani danokia haria inanokiahihi? Ni-ira akajari'dajanaki. ");
INSERT INTO padNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesua bigathanihi ida vaathi: —Ka'oa hiki hida kodivarani. Moisés kohana hiriha ada maná va'ora no'ara. Deus vani ada va'ora no'a'ara. Maná hirihi ida 'bai ka'oa hini nama gariki. Kodiabi'i vani ija'ari-ra va'ora no'avini hija ida 'bai ka'oa hini kidiania gariki. ");
INSERT INTO padNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","'Bai ka'oa Deua bikavagahinai'iki ada ovari nama gari'iki. Ovaria bianaja'diki ida ija'ari kamahi anokhomiria kaimoni — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Vani'aha: —Jesus, haria no'abakhia hihida 'bai ini'akia. ");
INSERT INTO padNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus va'ora ni'aha: —Hovani oa 'bai havahaki ija'ari kamahi anokhomiriki ho. Ija'ari kodiania abononi gahinai nihahi; ni-vai'amijanaki, va'ini na'bihaha'oadahaki fori hiki ida. Ija'ari hora kajari'dariki, hora vakaijokaki, ni-kanabidini akaaforajanaki fori hiki. ");
INSERT INTO padNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Hari. A'onira onava'isohivini hiki, hora avanokivini kaba'i, ni-hora avavakaijokaki. ");
INSERT INTO padNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kodiania vikhahahaviki bana adani ija'ari kodiabi'i hora no'avini vihi'iki. Ni-okajoniki ida ija'ari kodiania khaki abononi gahinai nihavini-ra nofiki. ");
INSERT INTO padNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nama Deus kania ohojana ogari'ihi. Hora rakhaki badani Deua binofikia okabadanija kaimoni. Badani onofikia okabadanina hirihi hida hora rakhaja. ");
INSERT INTO padNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kodiabi'ia binofiki va'ora oakadava'ajahakivini adani ija'ari hora no'avini vihi'iki. Hora karonakia ni-binofiki ida ija'ari hoarani akamadaki okharini kidiania. Binofiki ida ija'ari kahojai abosini kamahini Deus hora no'avini vihi'iki-ra va'ora oanahokihahavivini, vavahojaja kaimoni ida mahi ja'dini anokhomiriki Deus kania. ");
INSERT INTO padNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kodiabi'i va'ora nofiki adani Deus kaisai ohina-ra vakajari'dariki mahi anokhomiriki-ra vavahojavini, oniani ida ija'ari kahojai abosini kamahini hora vavakaijokaki-ra va'ora oanahokivini hija Deus kania — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Oniaroa, judeus kaija'ari vanava'isohiva abonoa vavajahariki ida Jesus abono-ra vara vani'avini: “Hovani oa 'bai havahaki ija'ari kamahi anokhomiriki ho nama gariki ija'ari vakadiania ho.” Nimania ida Jesus kavarani vavajahariki. ");
INSERT INTO padNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Oniania vaabono vakani'akhama'aha afohanana: —Hihada Jesus José kohana kaisai hada. Va'ora aogavini kaba'i adani kidiabi'i, kidiamia vihiki, nama garina-ra kahi'aha. Ni-nama gaririha ada. ");
INSERT INTO padNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus va'ora ni'aha: —Hari'a kodivarani asohirini-ra vakahijana. ");
INSERT INTO padNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kodiabi'i hora karonaki ija'ari-ra baranaharavini oadani, ni-ija'ari ka'oa bikaabokaki ida kodiania abononi gahinai nihavini. Ija'ari kahojai abosini kamahini oanahokiki bana ida ija'ari abononi gahinai nihaki kodiania, bivahojaja kaimoni ida mahi ja'dini anokhomiriki. ");
INSERT INTO padNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Deus athi namoniva abono kohana vaathi kapapirania hojaki hida athii: “Deus va'ora ka'ojomo'iki bana adani ija'ari hahavi.” Nimania ida papira athini. Ija'aria bikamithahi ida kodiabi'i ka'ojomo'ihi athini, binaabahi jaboni, oniani ida kodiania ija'ari-ra rakhaja, abononi gahinai nihaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","A'onira onava'isohivini hiki: ni-ija'aria binoki'iaki kaho ada kodiabi'i. Hovani ohoarana onoki'ara ada kodiabi'i, kidiania okha'iki ho. Ni-ija'ari hoariha binokiki. ");
INSERT INTO padNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ka'oa hiki hida varani. Ija'ari kodiania abononi gahinai niha'ikia bivahojaki ida mahi ja'dini anokhomiriki. ");
INSERT INTO padNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hovani oa 'bai havahaki ija'ari kamahi anokhomiriki ho. ");
INSERT INTO padNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Asia vara niki ada Jesus: —Amasia akadija'ari avikhananavakia vaha'iki ida maná. Maná-ra vahavini kaba'i, vaabini'iki adani. Anokhomiki ida vakadimahi. ");
INSERT INTO padNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Deus kania gariki ida 'bai havahaki ija'ari kamahi-ra ananokhomiriki. Ija'aria bihahi; ni-anokhomiki bana ida kidimahi Deus kania. ");
INSERT INTO padNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Hovani oa 'bai havahaki ija'ari kamahi anokhomiriki. Deus kania ohoja'ina, ogari'iki ho ija'ari vakadiania. Ija'aria bihahi; ni-anokhomiki ida kidimahi Deus kania nama. Oimana mani hida 'bai havahaki ija'ari kamahi-ra ananokhomiriki. Oabono ova'ahaki bana ho oabinina, ija'aria vavahojaja kaimoni ida mahi ja'dini anokhomiriki — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesus kavarani va'ora naihamahi'aha, vaabono vakani'akhama'aha: —Ni-bikaabokaki ida haria no'avini imana arihaki kaimoni — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus va'ora ni'a'aha: —Ka'oa hiki hida kodivarani. Hovani ija'ari hahavi vakadi'aajo ho. Ija'aria biharihi hida oimana, bi'avirihi jaboni hida oamana; ni-bivahojaki ida mahi ja'dini anokhomiriki. ");
INSERT INTO padNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ija'aria bihahi hida oimana, bi'avihi jaboni hida oamana, oniania bivahojahi ida mahi ja'dini anokhomiriki, oniani ida ija'ari kahojai abosini kamahini ija'ari-ra oanahokivini hija bana Deus kania — va'ora ni'aha ada Jesus. Vakamithavini kaba'i ida Jesus abono-ra kavarajomivini, ni-avigaki ida kidivarani nahina hini. Jesua bikavarajomiki ida ija'ari abononi gahinai nihaki kidiania, imana havahani, amana aavahania, Jesua bianaja'dija kaimoni ida kidimahi. ");
INSERT INTO padNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Asia vara niki ada Jesus: —Ka'oa hiki hida oimana ija'ari bihaki kaimoni. Ka'oa hiki hida oamana ija'aria bi'aviki kaimoni. Ija'ari oimana-ra hahi; oamana-ra avihi; ni-kidimahi anokhomijanaki. ");
INSERT INTO padNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kodiania akaramisi'iki ida ija'ari oimana-ra haki, oamana-ra aviki. Kidiania oakaramisi'iki ho jaboni. ");
INSERT INTO padNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hora karona'iki ada kodiabi'i. Ovani oa abono-ra nahokihaha'oadahara ada. Hokina vani fori ohija jaboni. Kodiabi'i hora no'avini hiki hida kodimahi hidiaja ovahojaki. Onivani fori hija jaboni ida ija'ari oimana-ra haki. Kodiania akaramisini mani ida kidimahi nahokihaha'oadahani hija. ");
INSERT INTO padNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nimania hida 'bai havahaki ija'ari kamahi anokhomiriki Deus kania nama hojaki gari'iki. 'Bai havahaki ija'ari kamahi anokhomiriki fori hiriki ida maná akadija'ari avikhananavakia vaha'iki. Vahavini kaba'i, vaabini'iki adani. Anokhomi'iki ida vakadimahi. Ija'ari 'bai havahaki ija'ari kamahi anokhomiriki-ra hahi; ni-kidimahi anokhomiki — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hari. Cafarnaum sidajia hojaha ada Jesus, va'ora ka'ojomo'i'iki adani judeus kaija'ari Deu-ra vara vani'avini kagorania vahojaki. ");
INSERT INTO padNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hari. Oniaroa, Jesus kavarani-ra vakamitha'aha adani ipohina vaipohiki, vaabono vakani'akhama'aha: —Ni-aogaki ida kidi'ojomo'ihi athini nahina nini. Ni-jahaki ida kidivarani haria ni'avini hi'iki. Hari'a akapoariva hida athi — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ni-nahina vani'aki ada Jesus, kaba'i biogaki ida kidivarani vavajaharavini vaabono vara vakani'akhamavini, oniani ida va'ora nana'dohivini hija: —Avanofimanija ida hora avanahojahavini kodivarania? ");
INSERT INTO padNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hovani ija'ari hahavi vakadi'aajo ho. Kodivarani-ra avakajari'daki a'oni. Oibavi nama oajoisina-ra avanokija vaha; asia mani koda hora avakajari'daja? ");
INSERT INTO padNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ma'onahai Jahaki vani ada ija'ari kamahi-ra anaja'di'ara. Ni-ija'aria bikaabokaki ida kidimahi-ra anahokiha'oadahavini. Kodivarani vara a'onira oni'avini hikia bivikhaki ada Ma'onahai Jahaki avakadiania, ovania bianahokiha'oadahaja ida avakadimahi. ");
INSERT INTO padNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kaba'i, vahojaki adani hora vakajari'daki avakadiania — va'ora ni'aha ada Jesus. Jesus va'ora ogajoraki adani ija'ari vajari'daki. Biogajoraki ada hana hina arakhana hiki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hari. Asia vara niki ada Jesus: —Avakadiania vahojaki adani hora vakajari'daki, oniani ida a'onira oni'avini hi'ia: Kodiabi'i ija'ari-ra baranaharavini oadani, ni-ija'ari ka'oa bikaabokaki ida kodiania abononi gahinai nihavini — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hari. Oniaroa, Jesus ipohina vaipohiki vajoiribani'aha, ni-vavaipohihajanaki. ");
INSERT INTO padNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oniania Jesus va'ora nana'dohi'aha adani 12 vihiki vaipohina: —A'onivani avanofimanija ida ava'ajihini jaboni? ");
INSERT INTO padNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simão Pedroa bini'a'aha: —Iniani, Jesus. Hana hini koda haria vasohiki hari? Ivani haria inanamithavini hi'ia ida ija'ari kamahi ja'dini anokhomiriki varani hini, agahinana hija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Deus kahonai abono jahaka'oaki ihini-ra akajari'darihi. Aogaki ida Deus ira nagathogathovini akadika'da'di ka'oa ihija kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesua bigathanihi ida athi: —A'onira onagathogatho'iki ho, 12 avihiki. Jahari ada hoarana avakadiania hojaki. ");
INSERT INTO padNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesua vara bivani'ajoraki ada ipohina Simão Iscariotes kaisai Judas oniki. Ovania bana biarakhara ada Jesus vahoariha vasa'a kabodinia. ");
INSERT INTO padNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hari. Oniaroa, vakadivarani naothinia Galiléia kaarabonia aadahaoni'aha ada Jesus. Judéia kaarabonia Jesu-ra naadahajanariki judeus kaija'ari vanava'isohiva abonoa vanaabinivini vanofivini. ");
INSERT INTO padNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ni-ipohijanaki ida mahi judeus kaija'ari ihinika hoariha-ra vanamonahavini Deu-ra khai vani'ara kaimoni. 8 mahi ipohini vakaihinikana oadani vavadina baniniaja, vakava'ihokija kaimoni ida vakadija'ari avikhananavaki vavadina amokhinia amasia avaadahaonina oadani. Ihinika onini Amokhini Kaihinikani. ");
INSERT INTO padNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Oniaroa, Jesus igamina ka'oa vani'aha: —Aajo, hihida ibavia ajihi'a. Judéia kaarabonia okha'a mahija kadaipohi vahoariha kadabadani danoki-ra vanokivini. ");
INSERT INTO padNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ija'aria binofihi ida vahoariha vaipohikia kidibadani avigavini, ni-bianahojaki ida badani vanokiria kaimoni. Badani danokia ikabadanibakhiaki i, vanokiva ida bada ini'aki — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Igamina vakajari'daki jaboni ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus va'ora ni'aha: —Ni-kha'iaki kaho ida mahi asohiki ookhana kamahini ihinika kania. Mahi hana hini avanofihi, asohiki ida avarikhani. ");
INSERT INTO padNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A'onira vavajahaki adani ija'ari Deu-ra vanofiriki. Hovani hora vavajahariki. Va'ora onava'isohibakhiavini hiki ida vakadihojai jahariki, oniani ida hora vavajaharavini hija. ");
INSERT INTO padNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","A'onimiro'a avigaimori'a ihinika amonahani ibavini kania. Ni-oogaimorina-ra onofiki kaho. Ni-kaikahi'iaki kaho ida mahi ookhana kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Vara va'ora ni'avini naothinia hojaroni'aha ada Jesus Galiléia kaarabonia. ");
INSERT INTO padNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hari. Oniaroa, Jerusaléa avikha'aha adani Jesus kakajo'o Amokhini Kaihinikani-ra avanikhahavini. Ai vihina naothinia okasiaga'aha ada Jesus. Ni-ija'aria vanoki'iki. Ahojai vania okha'aha. ");
INSERT INTO padNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judeus kaija'ari vanava'isohiva abonoa avanako'dioniha ada Jesus ihinika amonahani ibavinia. Vanana'dohibakhiaha: —Ada hana hojaha Jesus? ");
INSERT INTO padNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ija'ari vaipohiki vajoroniki vaabono vara vakani'akhamaki: —Jahaki ada makhira. Vahoariha vani adani vakhaniha: —Iniani. Va'ora korijanahabakhiaki adani ija'ari. ");
INSERT INTO padNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ni-vana'bara'iki ida vaathi. Va'ora vifiniki adani vakadija'ari vanava'isohiva abono, oniani ida athii 'bararikia Jesu-ra vakanavaranihavini hija. ");
INSERT INTO padNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hari. Ihinika ajararini vani kaikahi'aha ada Jesus. Ija'ari Deu-ra khai vani'avini kagorani kavasiribanini bodinia o'oi'aha, va'ora ka'ojomo'i'aha adani ija'ari vajoroniki. ");
INSERT INTO padNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jesus athi-ra vakava'ibodivaranikaraho'aha adani judeus kaija'ari vavaka'da'diva, vakhaniha: —Ni-akadi'ojomo'ihi abonoa vaka'ojomo'i'iki hada makhira Deus athi kapapirania. Nihaniki vania biogaja ida? Karahoki ida kidi'ogahai. ");
INSERT INTO padNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus va'ora ni'aha: —Ni-okava'ibodivarani'imidiaki hida ojomo'ihi athini. Deus hora karonaki ho. Ovari hora nava'isohivini hi'iki hida a'onira oka'ojomo'ivini hi'iki. ");
INSERT INTO padNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ija'ari nahina Deua binofiki-ra naabahi, biogaki bana ida kodi'ojomo'ihi athini Deus kania khani. Biogaki jaboni ida kodi'ojomo'ihi athini-ra onakama'daravini. Deus vania binakama'daja ida. ");
INSERT INTO padNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hari. Ija'ari kidiva'ibodivarania va'ora nanamithavini hiki adani vahoariha; binofiki ida kidi'ogahai karaho avigavini, abononi vaboraborahaja kaimoni. Ni-niki ida kodihojai. Hovani athi vikhava abono ho. Athi vikhava abonoa ni-vara bivani'aki ida kidiva'ibodivarani. Vara bivani'aki ida karonana hiki athi. Binofiki ida athi-ra karonaki ka'ogahai karaho-ra vakamithavini, khai vani'ara kaimoni ada karonana hi'iki. Ka'oa hiki ida athi vikhava abono athi. Ni-ija'ari-ra korijanahaki. Hovani athi vikhava abono ho. ");
INSERT INTO padNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Deus kava'isohihi jirikia Moisés kohana va'ora nava'isohi'iki adani akadija'ari avikhananavaki. Ni-ija'ari hoarani avakadiania hojakia binaabaki afojahaki ida Deus kava'isohihi jiriki. Nahina mani ida hora avanaabinivini-ra avarakaimasikivini hija? ");
INSERT INTO padNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Vakamithava vagathanihi ida kidina'dohi: —Ikabajadi'oamanija! Nahina ira akaimasikirihi ira naabinivini. ");
INSERT INTO padNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus va'ora ni'aha: —Bada oni'a'iki ida badani danoki hoarani akadi'akoiri kamahini, oniani ida avakava'ibodivaranikarahovini hi'ia. Ni-avavajahaki ida akadi'akoiri kamahini ija'ari-ra oanaihotavini. ");
INSERT INTO padNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Akadi'akoiri kamahini hini kaba'i, avakarajomiki ada isai tanaki, avanaabaja kaimoni ida Deus kava'isohihi Moisés kohana binajiri'iki. Ni-Moiséa bihonariabiininiki ida siikosida karajomihi. Moisés namithana viahania kidija'ari miro'a vanakama'daja ida siikosida karajomihi. ");
INSERT INTO padNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Vakadihonari avanaabavini isai-ra avakarajomivini akadi'akoiri kamahini hini kaba'i. Akadi'akoiri kamahini ija'ari-ra oanaihotahi; hora avakaihamahi'ihi. Hora avaranaathidanoararivini, hora avani'a'iki a'oni: “Inaabarihi ida Moisés kohana kahonari. Ni-jahaki ida bada inini akadi'akoiri kamahini, makhira-ra ianaihotavini.” Avakhaniki a'oni. ");
INSERT INTO padNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Avanokihi ida hoariha kahojai, hari'a jorakia asohirini vakahi bana. Avarigahi ida kidihojai Deua bivajahaki bivajahariki, oniania kidihojai asohini asohirini avakahivini jahaja. ");
INSERT INTO padNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hari. Oniaroa, ija'ari vahoarahanana Jerusaléa vahojakia vani'a'aha: —Hi'o makhira, akadija'ari vanava'isohiva abonoa vanofimanira koda o vanaabinivini? ");
INSERT INTO padNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Vada vani'a. Ija'ari vaipohiki vahararana vara niki ada, ni-nahina bianaathidanoaraririha ada. Akadika'da'dia avigamanira koda ada Jesus, Cristo hina, Deua bikaronaki hina? — vaabono vakani'akhama'aha. ");
INSERT INTO padNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","—Cristo khana kamahini ni-ija'aria avigaki bana ida ibavi bivikhaki kani. Aogaki ida makhira bivavijavaki ibavini — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ija'ari Deu-ra khai vani'avini kagorani kavasiribanini bodinia Jesus va'ora ka'ojomo'ivini kaba'i, athi 'barakia va'ora ni'aha: —Hora avarigaki hora avavanihamania koda? Ibavi hana hini kaija'arini ohina-ra avarigamania koda jaboni? Hovani ka'oa oabono ovikharihi hida. Ni-ija'ari-ra nava'iponi'imariniki ada hora karona'iki. Ni-avarigariha ada hora karona'iki. ");
INSERT INTO padNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hovani oa oogara ada. Kidiani oavania okhaja. Hora karona'iki ada — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Vanofivini kaba'i ida Jesu-ra vagathivini, ni-nahina bigathiki. Ni-kaikahi'iaki kaho ida mahi Deus Jesu-ra vagathivini-ra va'ahavini. ");
INSERT INTO padNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ija'ari vajoroniki vahararana vahojaki adani ija'ari vaipohiki Jesu-ra vakajari'dariki. Vani'aha: —Ipohiki ida makhira kabadani danoki. Cristo oamani ada Jesus. Ija'ari hoariha hira vaha ada Cristo; bikaabokamanija koda ida badani danoki arafiaki, Jesus kabadani-ra aradaki? Akajari'dariha ada Jesus, Cristo hina Deua bikarona'iki — vakhani'aha. ");
INSERT INTO padNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Hari. Farisioa vakamitha'ihi ida ija'ari vajoroniki athii 'bararikia Jesus varani hina vaabono vara vakani'akhamaki. Farisioa vanofiki ida Jesus gathana. Oniaroa, sasidotxi vavaka'da'diva, farisio khama va'ora vahonariaha adani sorara: —Jesus kania avikha'a mahija avagathivini. Vavikha hida akadiania — va'ora vani'aha. ");
INSERT INTO padNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hari. Jesus va'ora ni'aha adani ija'ari vajoroniki: —Mahi ipohirikia ohojaki ho avakadiania. Naothinia oajoiki bana ho hora karonaki kania. ");
INSERT INTO padNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hora avanako'dihaki bana a'oni, ni-hora avakaragaki bana. Ni-avakaabokaki bana ida ovahojaki kania avarikhani. ");
INSERT INTO padNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judeus kaija'ari vaabono vakanana'dohikhama'aha: —Hana vania koda okhaki ada akaragarara kaimoni? Arabo hoariha kasidajinia okhamaniki koda ada, va'ora ka'ojomo'ira kaimoni adani akadija'ari vihiriki? ");
INSERT INTO padNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Vaabono vakani'akhama'aha: —Haria ni'ajora'iki ada: Anako'dihavini, ni-akaragaki bana. Ni-akaabokaki ida aokhana bivahojaki kania. Ni-aogaki ida kidivarani nahina nini — vakhani'aha. ");
INSERT INTO padNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hari. Oniaroa, anokhomini amaakari'iki ida Amokhini Kaihinikani amonahani. Hari. Ahoarani'iki hida mahi karaho ihinika a'diahini kamahini. Oniaroa, vahararana gaa'aha ada Jesus, athi 'barakia va'ora ni'a'aha: —Jahaki ida ija'ari kanabidini akaaforaki kodiania khani, bi'avija kaimoni ida ono'avini hiki kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Deus athi kapapirania hojaki hida varani ohina: “Hora vakaijokajahakikia va'ini bodinia sororonaniki fori hiki ida paha ija'ari-ra nahokiki. Vaini kapahani sororonaniki fori hiki ida.” Niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesua bikavarajomiki ada Ma'onahai Jahaki paha sororonanikia fori hina. Jesus kavarani-ra kajari'darikia bigathaniki bana ada Ma'onahai Jahaki. Oniaro kari ni-Deua bikarona'iaki kaho ada Ma'onahai Jahaki vajari'dariki vakadiania. Ni-abini'iaki kaho ada Jesus. Ni-ajoisi'iaki kaho ada Jesus Deus Ibavi Jahaka'oaki vagaki kania, oniani ida Ma'onahai Jahaki-ra arakha'iarija ija'ari vajari'dariki vakadiania. ");
INSERT INTO padNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus kavarani-ra vakamithaki adani ija'ari vajoroniki, vakhaniha vahoarahanana: —Hi'o makhira, Deus athi namoniva abono anokhaki o — vakhaniha. ");
INSERT INTO padNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Vakhaniha adani vahoariha: —Cristo mani o. Vahoariha vani adani vakhaniha: —Iniani, ni-Galiléia kaarabonia khaki ada Cristo oniki. ");
INSERT INTO padNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Deua bivava'isohihijoraki ada Cristo: Akadija'ari okhananavaki Davi kohana oniki kahanodi namitharonisiagaki ada Cristo. Biva'banaki Belém sidaji. Davi kohana bivavijavaki ida sidaji Belém. Nimania ida haria nava'isohijora'iki athii Deus athi kapapirania hojaki — vakhaniha adani ija'ari Jesu-ra vakajari'daki, avigaravini kaba'i ida Jesua biva'banaki ibavini. ");
INSERT INTO padNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Oniaroa, vahoariha vakajari'daki ida Jesus athi. Vahoariha vani adani Jesus athi-ra vakajari'dariha. ");
INSERT INTO padNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vakadiania vahojaki adani ija'ari Jesu-ra vagathivini-ra vanofiki. Ni-nahina bigathi'iki kaho. ");
INSERT INTO padNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hari. Oniaroa, avajoi'aha adani sorara sasidotxi vavaka'da'diva, farisio vihiki vakadiania. Sorara-ra va'ora vanana'dohi'aha: —Nahina mani ida Jesu-ra avavikharavini hija? ");
INSERT INTO padNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sorara va'ora vani'aha: —Ni-ija'ari hoariha vara bivani'aki ida varani Jesus kavarani fori hiki — vakhaniha, Jesus athi-ra vakajari'daravini. ");
INSERT INTO padNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisio va'ora avakaihamahi'aha adani sorara, va'ora vani'aha: —A'onira korijanahamanira koda ada jaboni Jesus? ");
INSERT INTO padNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Judeus kaija'ari vanava'isohiva abonoa vakajari'dahahaviki ada Jesus. Harivani, Farisio jaboni akajari'daki ada. Akajari'dahahaviki ada. ");
INSERT INTO padNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ija'ari vahoariha Deus kava'isohihi jiriki-ra avigariki. Deus va'ora nihimaki bana adani — vakhaniha adani farisio Jesu-ra vakajari'daki. ");
INSERT INTO padNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hari. Vakadiania hojaha ada farisio Nicodemos oniki. Mahi ipohiki viahania joma kaba'i, binavanavanaha'iki ada Jesus. Hari. Nicodemos va'ora ni'aha adani ipohina: ");
INSERT INTO padNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Ni-akamitha'iaki kaho ida Jesus abono-ra vajari'davini. Moisés kohana va'ora nava'isohi'iki adani akadija'ari avikhananavaki: “Hari'a ija'ari kabadani asohirini-ra vakahiva adani ija'ari vanasohiva abono, vakamitharavini oadani ida abononi vajari'davini. Avigaravini oadani ida kidihojai, hari'a jaharikia avarakhava ida ija'ari.” Niki ida Moisés athi papira hojaki. Ni-akamitha'iaki kaho ida Jesus abono-ra vajari'davini. Ni-asohiki ida kidihojai asohirini akahivini, anana'dohiravini oadani — va'ora ni'a'aha ada Nicodemos. ");
INSERT INTO padNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Vagathani'ihi ida athi: —Ivani jaboni Galiléia kaaraboni kaija'arini mani koda i? Vada ini'a bana ida Deus athi kapapirani jiriki mahija Galiléia kaarabonia Deus athi namoniva abono kharina-ra iogavini — Nicodemo-ra vani'aha. Galiléia kaarabonia 'banaki vavanihaki ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hari. Oniaroa, vagorana vajoi'aha adani ija'ari. Jesus vani ada ogaimori'aha arabo namahikia monte das Oliveiras onikia. ");
INSERT INTO padNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ka'afokajomani mahi avagani kama'dani vani joifoni'ianaha ada Jesus Deu-ra khai vani'avini kagorani kavasiribanini bodinia. Vajoroni'aha adani ija'ari vaipohiki kidiania. Vithirariha, va'ora ka'ojomo'ihahavi'aha. ");
INSERT INTO padNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Va'ora ka'ojomo'ivini kaba'i, vakaikahi'aha adani judeus kaija'ari vaka'ojomo'iva abono, farisio khama. Jesus kania vavikha'ihi ida gamo, vahonariahi gaani vaviaha. Hoariha kamakhira-ra vi'omavini vani farisioa vagathija ida gamo. Oniaroa, Jesus kania vavikha'ihi. ");
INSERT INTO padNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesu-ra vani'a'aha: —Ivani ija'ari ka'ojomo'iva abono i. Haria nava'isohi bana: Kamakhiraki hida gamo. Hoariha kamakhira-ra vi'omavini kaba'i, agathi'iki hida. ");
INSERT INTO padNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Deus kava'isohihi jiriki Moisés kohana akadija'ari avikhananavaki-ra no'avini hi'iki haria honariavini gamo nikia kabadaniki ja'dia anagahavini abinija kaimoni. Ivani, nahina haria ini'aja koda bana? — Jesu-ra vanana'dohi'aha. ");
INSERT INTO padNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Avigavini kaimoni hirihi ida vanana'dohivini hija. Vanofiki ida Jesu-ra vakaijo'avini nahina nini vakamithaja kaimoni ida athi. Moisés kohana kahonari-ra kajoniha; avanaathidanoarariha. Hari. Hasi nirari'aha ada Jesus, jiriha'aha nami khomakhomani namania sa'a. ");
INSERT INTO padNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Asia avanana'dohi'dohibakhiaha. Gaamanani'aha, va'ora ni'a'aha: —Ba ovari miro'a gamo-ra aviniva ja'dia ada Jahari kabadania kabadani'iariki. ");
INSERT INTO padNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hasi nirari'ianaha, jiriha'ianaha nami khomakhomani namania. ");
INSERT INTO padNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesus athi-ra mitha vani'avini vani ai vihinana'aha adani gamo-ra avanaathidanoarariki hahavi. Makhira na'arihavi vihiki miro'a adani ai vihi'aha. Vahojaroni'aha adani Jesus, gamo khama. Asia gaaki ida gamo Jesus viaha. ");
INSERT INTO padNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Oniaroa gaamanani'ianaha ada Jesus, bini'a'ihi: —Gamo, adani hanaja ija'ari avikha'aha? Vahojaronirara adani ira vanagahavini-ra vanofiki? Vanofijanaria koda ida kadabadani asohiriki abosini-ra vavahonariahivini? ");
INSERT INTO padNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Iniani — nihi ida gamo. —Ni-kadabadani asohiriki abosini-ra ovahonariahiki jaboni. Ba ajihi'a. Hari'a Jahari kabadania kabadanijana — gamo-ra ni'a'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Hari. Oniaroa, Jesus vara va'ora ni'a'ianaha adani farisio: —Hovani oa onavagaja ida ija'ari hahavi vakadiva'ibodivarani. Ija'ari hora vaipohihakia bivahojaki ida mahi ja'dini anokhomiriki. Kidiva'ibodivarani onavagavini mani ida bakibakiki fori hikia naadahajanarini hija — va'ora ni'a'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisioa vani'aha: —Ivani oa iabono vara ivani'a'ia. Ni-hojaki ida ija'ari hoariha kadavarani ka'oa hinia haria kanamoniki kaimoni. Hojarini mani ida ka'oa hini ka'oa hirini aogaravini hija. ");
INSERT INTO padNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus va'ora ni'aha: —Hovani ohoarana oabono vara ovani'avini kaba'i, ka'oa hiki hida kodivarani. Oogaki ida ibavi ovikhaki. Oogaki jaboni ida ibavi oanikhaki kaimoni. A'onivani ni-avarigaki ida ibavi ovikhaki, ni-avarigaki jaboni ida ibavi oanikhaki. ");
INSERT INTO padNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Avarigaravini kaba'i ida hoariha kahojai, kidiva'ibodivarani hiki, avarakaraganahaki ida kidihojai, kidibadani, kidivarani hiki, asohirini avakahivini. Ni-nikia Deus ija'ari-ra nasohiki. Ni-hovani oa ija'ari-ra onasohirihi. ");
INSERT INTO padNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ija'ari-ra onasohija vaha; asohihi vaha ida kodivarani. Ni-ohoarana ohojaki, kodiabi'i hora karona'iki ho, ovari kodiania hojaki. Hora kakodiavini mani ida ija'ari-ra onasohivini kavaranihi-ra nasohika'oaja. ");
INSERT INTO padNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Akadiva'isohihi jiriki kapapirania hojaki hida honari: “Ija'ari vi'bamiki vania vanokija ida, vakamithaja ida jaboni ija'ari hoariha kahojai asohiriki. Ija'ari vanasohiva abono vaviaha o'oiva ida ija'ari hojani jahariki nokiva abono, vara bivani'aja kaimoni ida binoki'iki, bikamitha'iki hiki. Khaonanini naothinia hoariha maina ida o'oi'ihi, vara bivani'aja kaimoni ida binoki'iki, bikamitha'iki hiki. Onivani fori hi'ianahi ida kidivarani ija'ari vanasohiva abono vakadiania. Vakadivarani hi'bamakhama'ihi ida vanoki'iki, ka'oa hini aviga'ihi.” Nihi ida papira athini. ");
INSERT INTO padNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Hovani kodiabi'i khama ija'ari hojani nokiva abono vi'bamiki fori arihiki hari. Oabono vara ovani'aki ho. Kodiabi'i jaboni vara hora vani'a'iki ho, oathi ka'oa hini-ra kahiki ada. Onivani fori hi'ianaja hida akadivarani afo'bamakhama, oniani ida ka'oa hini avarigavini hija kodiabi'i hora karona'avini — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—Ada hana hojaha kadabi'i? — Jesu-ra vanana'dohi'aha. Jesus va'ora ni'a'aha: —Ni-hora avarigaki hana ohina. Ni-kodiabi'i-ra avarigaki jaboni hana hina. Hora avarigaja vaha; kodiabi'i-ra avarigahi jaboni vaha. ");
INSERT INTO padNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hari. Deu-ra khai vani'avini kagorani kavasiribanini bodinia vara niha ada Jesus. Ija'ari Deu-ra vakanava'igavini kajinironi bavini kania hojaha ada Jesus, ija'ari-ra va'ora ka'ojomo'ivini. Ni-nahina bigathiki ada Jesus, ni-kha'iaki kaho ida mahi Deus Jesu-ra vagathivini-ra va'ahavini. ");
INSERT INTO padNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Hari. Oniaroa, Jesus va'ora ni'a'ianaha: —Ai ohiki bana ho. Hora avanako'di'imariniki a'oni. Jahari kahojaia avakahojaini oadani vani avaabinija bana. Ni-avakaabokaki ida avarikhani ibavi oanikhahaki kania — va'ora ni'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Oniania vaabono vakani'akhama'aha adani judeus kaija'ari: —Jesus haria ni'avini ibavi bianikhahakia aokhana-ra akaabokaravini. Abono-ra naabinimaniki koda hada? ");
INSERT INTO padNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus va'ora ni'aha: —A'onivani araboja ava'banaki a'oni. Hovani oibavi namajaja. Arabo kaija'arini avihiki a'oni. Hovani arabo kaija'arini ohirihi, ");
INSERT INTO padNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","oniani ida a'onira onava'isohijoravini hi'ia: Jahari kahojaia avakahojaini oadani vani avaabiniki a'oni bana. Oonina Hovani oa ho. Avakajari'dahi ida oonina Hovani oa hini, avaabinini kamahini, asia avakadihojai asohiriki-ra avavahojaki a'oni bana. ");
INSERT INTO padNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jesu-ra vanana'dohi'aha: —Hana ihini mani i? Jesua bigathani'ihi ida vakadina'dohi: —Kodivarani kama'dani vani a'onira onava'isohija oonina Hovani oa ho. ");
INSERT INTO padNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hojaki ida varani karaho avihinia okavaranina kaimoni. Avakadihojai asohiriki-ra onasohivini kavaranihi hojaki jaboni, kaba'i ni-varani avihinia okavaraniki. Ka'oa hiki ada hora karona'iki. Kidivarani okamithaha; vara ovani'a'ihi ija'ari araboa vahojakia vakamithaja kaimoni. Hora nava'isohiravini oadani, ni-nahina oniki — va'ora ni'a'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesus kavarani-ra vakamithavini kaba'i, ni-nahina hini avigaki, ni-avigaki ida kidiabi'i nama hojaki-ra vara vani'avini. ");
INSERT INTO padNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Avigaravini mani ida Jesus va'ora ni'avini hija: —Ija'ari hahavi vakadi'aajo ho. Ava akasanakhamaki kania hora avaragaamananivini kamahini, avarigaki ida Hovani oa ohina. Avarigaki jaboni ida kodiabi'i hora honariaravini oadani vara onirina. Hora nava'isohiha varania bona vara ovani'ahi ida kidivarani. ");
INSERT INTO padNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kodiania hojahaha'oadahaki ada hora karona'iki. Khai bini'aki ida badani bivajahakia okabadaniha'oadahana, oniani ida hora nahojaharavini hija — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesus kavarani-ra vakamithavini vani ija'ari vaipohiki kidivarani vakajari'dariha ada. ");
INSERT INTO padNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hari. Oniaroa, Jesus va'ora ni'aha adani judeus kaija'ari vajari'dariki: —Oathi-ra avanaababakhiahi; kodipohi ka'oa avihihi. ");
INSERT INTO padNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Avarigaki bana ada Deus ka'oa hina. Ka'oa hina avarigaha; ni-ija'ari kapavakarivahaki fori avihijanaki. ");
INSERT INTO padNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Vagathani'ihi ida Jesus athi: —Abraão kahanodi avijavaronisiagaki arihiki hari. Ovari kapavakarivahariki ada. Ovari fori arihiki hari jaboni. Ni-nahina haria kapavakari'iaki vakadihonai abono gathaki arihija kaimoni. Ni-aogaki ida kadavarani nahina hini vara haria ini'avini hiki: ni-ija'ari kapavakarivahaki fori arihijanarihi — Jesu-ra vani'a'aha. ");
INSERT INTO padNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus va'ora ni'aha: —Ka'oa hiki hida varani a'onira onava'isohivini hiki. Honai abono kapavakarivahakia ni-bikaabokaki ida abono-ra saarivini kidika'da'di sa'a kabodinia. Jahari kahojaia kahojaihi ida ija'ari, ni-bikaabokaki ida abononi saarivini Jahari sa'a kabodinia. ");
INSERT INTO padNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ka'da'di kidihonai abono gathaki-ra pavakari nihavini-ra nofiha; pavakari binihaha. Ni-hojahaha'oadahaki ada honai abono gathaki kidika'da'di gorana. Ka'da'di kaisai hiriha ada honai abono kapavakarivahaki. Ka'da'di ni-pavakari binihaki ada kidisai. Hojahaha'oadahaki ada kidiabi'i gorana. ");
INSERT INTO padNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Deus kaisai ho. Jahari sa'a kabodinia a'onira oakava'ijoahi; ni-avagathajanaki fori avihiki, avakaabokaki ida hojai asohiriki-ra avakava'ipahinivini. ");
INSERT INTO padNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A'onira oogaki ho. Abraão kohana kahanodi vavijavaronisiagaki a'oni. Kodi'ojomo'ihi kavaranihi-ra avakajonivini mani ida hora avanaabinivini-ra avanofivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Vara ovani'aki ida varani kodiabi'i hora nava'isohivini hi'iki. A'onivani bada avani'aki ida badani avakadiabi'i a'onira ka'ojomo'ivini hi'iki. Jahari kaisaia a'onira onaonivini hiki avanamonahavini hida Jahari kahojai. ");
INSERT INTO padNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Vagathani'ihi ida Jesus athi: —Akadi'arahoda okhananavaki ada Abraão kohana. Anaonivini ada Abraão akadiabi'i. Oniania Jesus va'ora ni'a'aha: —Abraão kohana kaisai avihija vaha; kidibadani fori hikia avakabadanimanihi vaha. ");
INSERT INTO padNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hovani vara ovani'aja hida athi ka'oa hini Deus hora nava'isohivini hi'iki. Athi ka'oa hini-ra vara ovani'avini kaba'i, asia hora avanaabinivini-ra avanofihi. Abraão kahojai fori hirihi ida avakadihojai. ");
INSERT INTO padNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jahari kahojaia avakahojaiki a'oni. Avakadiabi'i kahojai fori hiki ida avakadihojai — va'ora ni'aha ada Jesus. Vagathanihi ida Jesus athi: —Akadiabi'i hoarana hina aogaki Deus. Deus kaisai ka'oa arihiki hari. Isai kaabi'iriki fori arihirihi. ");
INSERT INTO padNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Oniania, Jesus va'ora ni'a'aha: —Deus avakaabi'ija vaha; hora avanofijahakimanihi vaha. Deus kani vania okhaja, hidavania ohoja'ia. Ni-hovani ka'oa oabono ovikharihi. Deus vani hora karonaja. ");
INSERT INTO padNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Niha avani'amania hida oathi avakamithavini kaba'i avakamithariki fori avanihaki? Ni-avanofipa'itxiki ida kodivarani-ra avarigavini nahina hini. ");
INSERT INTO padNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jahari kaisai oamani a'oni, oniani ida nahina Jaharia bikava'inofinofiki-ra avanofivini hija. Hahavi amonahani vani kaabinira ada Jahari. Nahina ka'oa hini-ra vajaharavini mani ida kidiania nahina sohiki-ra nofiravini hija. Jahari kahojai oamani ida korijanahia kavaranina. Korijanahi abono ada. Korijanahi abono hahavi kaabi'i fori hiki ada. ");
INSERT INTO padNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Varani ka'oa hinia okavaranina mani ida kodivarani-ra avakajari'davini hija. ");
INSERT INTO padNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hana hina biogaja ida badani Deua bivajahariki onamonaha'iki? Ni-bada oni'arihi ida Jahari kabadani. Hora bana nanamithava ada kodibadani asohirini-ra kahiki. Varani ka'oa-ra vara ovani'a'iki ho. Niha avani'amania hida kodivarani avakajari'daki? ");
INSERT INTO padNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Deus kaija'aria vanaabaki ida Deus kavarani. Kidija'ari avihirini mani ida kidivarani avanaabaravini hija — niha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hari. Oniaroa, vani'aha ada Jesus: —Asohi'oamani'ia ida akadivarani ira vara avani'avini, Samaria kaaraboni kaija'arini fori ihiki i. Bajadi iva'ini-ra nahonariahihi'iki i jaboni. ");
INSERT INTO padNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Oniaroa, Jesus va'ora ni'aha: —Iniani, ni-bajadi ova'i-ra nahonariahihirihi. Ovava'ihaki ada kodiabi'i. A'onivani ni-hora avavava'ihaki. ");
INSERT INTO padNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ni-ojahana kavaranihi-ra onako'dirihi kodimoni hini. Kodiabi'i vani hora vara vani'aja varani jahakia. Ovari akadivarani-ra nasohiki bana. Oasohina-ra kahiki bana ada kodiabi'i. ");
INSERT INTO padNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ka'oa hiki hida kodivarani. Ni-abiniki bana ida ija'ari oathi-ra naabaki. ");
INSERT INTO padNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Oniaroa, judeus kaija'ari vanava'isohiva abonoa vani'aha: —Kadavarani-ra akamithahi; aogajahakihi ida bajadi iva'ini-ra nahonariahihivini. Abini'bo'da'iki ada Abraão kohana. Vaabinihananaki adani Deus athi vanamoniva abono. Ija'ari iathini-ra naabaki, ni-abinini ikahiki. ");
INSERT INTO padNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abini'iki ada Abraão. Ovari miro'a akadija'ari avikhananavaki vakadiabi'i ada. Ka'da'di ada. Abraão ka'da'di hina-ra iaradamanija? Vaabiniki jaboni adani Deus athi vanamoniva abono. Hana ihini mani i, iabono vara ivani'aja? — vani'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Ojahana kavaranihia vara oabono oni'aja vaha; ni-avarigaki vaha ida kodivarani ka'oa hini ka'oa hirini. Kodiabi'i vani ada ojahana kavaranihi-ra vara vani'ara. Ovari ada avakadiDeus hina avakahira. ");
INSERT INTO padNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ni-avariga'iariha ada. Hovani oogara ada. Deu-ra ogaravini-ra okahija vaha; korijanahi abono ohihi vaha, a'onifori ohihi vaha. Oogaki ada, athi onaabahaha'oadahaki ada. ");
INSERT INTO padNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Avakadiabi'i Abraãoa khai bini'akaraho'iki ida kidiania okhana-ra nokivini araboa. Hora nokijora'avini mani ida khai ni'ana hija — Jesus va'ora ni'aha. ");
INSERT INTO padNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Vani'aha ada Jesus: —Ni-ivahoja'iaki ida badara 50 hiki ipohini. Nihaniki vania inokira ada Abraão? ");
INSERT INTO padNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesua bigathani'ihi ida vakadina'dohi: —Hovani oa ho. Abraão namithana viahania homiro'a ohojaja — va'ora ni'a'aha. ");
INSERT INTO padNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hari. Oniaroa, vanabiini'ihi ida ja'di Jesu-ra vanagahara kaimoni, oniania, Jesus abono-ra anahoja'aha. Deu-ra khai vani'avini kagorani kavasiribanini bodinia okhaonani'aha, ajihi'aha. ");
INSERT INTO padNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hari. Oniaroa, adahana kaba'i ada Jesus, makhira kamaodorohaki-ra noki'aha. Kamaodorohana vani 'banara ada. ");
INSERT INTO padNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesus ipohina vanana'dohi'aha: —Jesus, niha nimanira ada makhira 'banana kamaodorohana namithaki? Asohirini mani ida kidihojai kanamaodorohana hija? Kidiabi'i, kidiamia vihiki vakadihojai asohirini mani ida kanamaodorohana hija? ");
INSERT INTO padNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesua bigathani'ihi ida vakadina'dohi: —Iniani, ni-hojai asohirikia bikanamaodorohariha ada. Ni-kidiabi'i, kidiamia khama vakadihojai asohirikia bikanamaodorohaki. Kamaodorohana mani ida Deua bianaihotavini ija'aria vanokivini hija bana. Deus ka'oa bikaabokaki hida makhira nokho 'ba'dani-ra anavagahavini. ");
INSERT INTO padNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mahi oadani bada akhaniva hora karonaki kabadani-ra bada ani'avini. Joma bakibakini khani vani ni-ija'aria bikaabokajanaki ida kidibadani. ");
INSERT INTO padNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ija'ari vakadiania ohojana oadani onavagaki fori hiki ida ija'ari kava'ibodivarani. ");
INSERT INTO padNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Vara nina naothinia, Jesua bikathorari'ihi ida arabo namani, binakabodihadihahi ida i'bana namia. Biraviso'ihi ida ka'baka'bani makhira nokho 'ba'dani asafini namania. ");
INSERT INTO padNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bini'aha: —Okha'a ja'di khorahaki kapahani kania Siloé onikia mahija inokhoni-ra isokovini — bini'aha. Ariathia Siloé onini ida ‘Karonahi hina’. Hari. Okha'aha ada makhira, bisoko'ihi ida nokho. Nokho avagaha'ini vani joi'aha. ");
INSERT INTO padNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bivahojaki gora maakarini kaija'arinia vanoki'aha ada makhira kamaodorohajanarina. Hi'ada jiniro-ra kanikhariabakhiavini vanokiki ni-kamaodorohajanaki. Vaabono vakanana'dohikhama'aha: —Ada vani mani jiniro kanikhariabakhiava abono ada? ");
INSERT INTO padNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vahoariha vani'aha: —Ha'a, ovani oa ada. Vahoariha vani adani vakhaniha: —Iniani. Ovari hiriha ada. Ovari nokiana fori hiki ada. Makhira kamaodorohajanariki va'ora ni'aha: —Ha'a, hovani jiniro kanikhariava abono niavaha ho. ");
INSERT INTO padNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Vanana'dohi'aha: —Nihaniki vania inokhoni avagaha'ia? ");
INSERT INTO padNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Va'ora ni'a'aha: —Hi'ada makhira Jesus onikia binakabodihadihahi ida i'bana namia, biraviso'ihi ida ka'baka'bani onokho 'ba'dani asafini namania. Hora honariavini hi'iki Siloé ibavi onikia ookhana, onokho-ra osokohavini. Hari. Ookha'ihi, onokho-ra osokovini naothinia jorakia avagaha'ihi hida onokho 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Vanana'dohiha: —Ada hanaja vania hojaha? —Ni-oogajanaki — va'ora ni'a'aha. ");
INSERT INTO padNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Hari. Oniaroa, avavikha'aha ada makhira kamaodorohajanariki farisio vakadiania. ");
INSERT INTO padNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hari. Judeus kaija'ari vakadi'akoiri kamahini vani Jesua binakabodija ida i'bana namia, bianaihota'iki jaboni ada makhira kamaodorohaki. ");
INSERT INTO padNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisio maina vanana'dohiha ada makhira: —Nihaniki vania bianavagahaja ida inokhoni 'ba'dani? Va'ora ni'a'aha: —Biraviso'iki ida ka'baka'bani onokho 'ba'dani asafini namania. Osokovini naothinia avagaha'ihi hida onokho 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisio vaipohirikia vani'aha: —Akajari'daki ida kamaodorohaki-ra anaihotaki Deua bikaronavini. Ni-bivakaajiki hida akadi'akoiri kamahini. Bikajoniki ida Deus kahonari jiriki. Farisio vahoariha vani adani vakhaniha: —Makhira hojai asohirikia kabadanibakhiaki hira vaha; ni-bikaabokaki vaha hida badani danoki afobakhia — vakhaniha. Vahoariha vajari'daki, vahoariha vani adani ni-vajari'daha. ");
INSERT INTO padNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisioa vanana'dohi'ianaha ada makhira: —Kadavarani hiki ada inokhoni 'ba'dani-ra anavagaha'iki. Nahina mani ida Jesu-ra ikava'ibodivaranivini hija? —Deus athi namoniva abono mani ada okava'ibodivaranira — va'ora ni'a'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judeus kaija'ari vanava'isohiva abonoa vakajari'da'ihi ida makhira kamaodorohana. Kidiabi'i, kidiamia vaathi-ra vakamitharavini oadani vakajari'daki ida vara abono-ra vani'avini, oniani ida va'ora vakaboa'ivini hija. ");
INSERT INTO padNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Avakhanoha adani kidiabi'i, farisio va'ora vanana'dohi'aha: —Avakadisai mani hada? Tanana vani kamaodorohara hada avakadisai? Nihaniki vania hidakaba'i avagaha'ia hida nokho 'ba'dani? ");
INSERT INTO padNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kidiabi'i va'ora ni'a'aha: —Aogaki hada akadisai hina. Aogaki jaboni ida banini hi'ina tanana nokho 'ba'dani vagaharini. ");
INSERT INTO padNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ni-aogaki hida niha ninini nokho 'ba'dani avagaha'ini. Ni-aogaki jaboni ada nokho 'ba'dani anavagahani hi'iki. Ni-isai hijanaki. Vanana'dohi bana mahija a'onira nanamithavini hana hina bianavagahavini ida nokho 'ba'dani. ");
INSERT INTO padNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Makhira kaabi'i, kaamia va'ora vifiniki adani vakadija'ari vanava'isohiva abono, oniani ida avigaravini vakahivini hija. Mahi 'bo'dakari judeus kaija'ari vanava'isohiva abono vaabono vara vakani'akhamajoravini: —Deu-ra vara ani'avini kagorania aakakojava ida ija'ari Jesu-ra kajari'dariki, Cristo hina-ra kahiki — vakhaniha, oniani ida kamaodorohajanariki kaabi'i akojahi vihina-ra vifinivini hija, ");
INSERT INTO padNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","oniani ida vakadina'dohi vagathaniravini hija. Va'ora vani'aha: —Isai hijanariha ada akadisai. Vanana'dohi bana ida namitha'iki kidiania. ");
INSERT INTO padNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Oniaroa, vahonariaha ada kamaodorohajanariki o'oi'ianana vakadiania, vani'a'aha: —Deua mitha bini'aki hida kadavarani. Varani ka'oa hinia kavarani bana akadiania. Aogaki ada makhira ira anaihotaki hojai asohirikia kabadanibakhiana — vani'aha. ");
INSERT INTO padNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Va'ora ni'a'aha ada makhira: —Oogariha ada hojai asohirikia kabadanina kabadanirina. Oogaki ida okamaodoroha'ina. Oogaki hida onokho 'ba'dani-ra anavagaha'avini — va'ora ni'a'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Vani'a'aha: —Nahina mani ida binamonaha'ia kadania? Nihaniki vania inokhoni 'ba'dani-ra anavagahara ada? — vanana'dohi'ianaha. ");
INSERT INTO padNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—A'onira onanamithavini hi'iki ida. Ni-avakamithavini avanofiki. Nahina mani ida avakamitha'ianavini avanofivini hija? Avanofimanija koda ida kidipohi avihini? ");
INSERT INTO padNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Avakaihamahi'aha. Varani jaharikia vara vani'a'aha ada makhira: —Ivani inaabaki ida hi'ada makhira athi. Harivani anaabaki ida Moisés kohana athi. ");
INSERT INTO padNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aogaki ida Deus Moisés kohana-ra vara ni'a'bo'davini. Ni-aogapa'itxiki ada Jesus oniki. Ni-aogaki ada hi'ada makhira hanajaja khana — vakhani'aha. ");
INSERT INTO padNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Va'ora ni'a'aha ada makhira: —Okava'ibodivaranikarahoki ida Deua bikaronavini avarigaravini. Hora anaihotavini kaba'i, ni-avarigaki ada Jesu-ra karona'iki. ");
INSERT INTO padNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aogaki ida ija'ari hojai asohirikia kabadanibakhiaki, ni-Deua bino'aki nahina bikanikhariakia. Ija'ari Deu-ra vava'ihahi, athi naabani hihi jaboni, oniani ida nahina bikanikhariakia Deua bino'avini hija. ");
INSERT INTO padNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hahavi amonahani naothinia ni-nahina bikamitha'iaki kaho ida ija'ari tanani kamaodorohaki-ra anaihotaki varani hini. Ija'aria ni-vakaabokaki hida badani. Hidakaba'i Jesus vani ada onokho 'ba'dani-ra anaihota'ara. ");
INSERT INTO padNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Deus kania kharara vaha ada makhira hora anaihota'iki; ni-bikaabokaki vaha ida kidibadani danoki — va'ora ni'a'aha ada makhira. ");
INSERT INTO padNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Vani'aha: —Ivani itanani kari hojai asohirikia ikabadaniha'oadahaki i. Ni-jahaki ida haria ika'ojomo'ivini-ra ikaijo'avini — vani'aha. Oniaroa, avakakoja'aha, Deu-ra vara vani'avini kagorania ajihina vahonaria'aha. ");
INSERT INTO padNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Hari. Oniaroa, Jesua bikamithahi ida makhira akojahi hina varani hini, binako'dihaha, bikaraga'aha, binana'dohi'aha: —Ivakaijokamanira ada ija'ari hahavi ka'aajo? ");
INSERT INTO padNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Makhira bini'aha ada Jesus: —Hora nanamitha'a bana hana hina mahija ovakaijokavini. ");
INSERT INTO padNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesua bini'a'aha: —Inoki'iki ada. Ovari ada ira vara ni'ara. ");
INSERT INTO padNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Kodika'da'di, ira ovakaijokaki ho — niha ada makhira, Jesus viaha kajo'atharari'ina, bikanamasivi'aha. ");
INSERT INTO padNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Niha ada Jesus: —Hora rakhaki ija'ari vakadiania ija'ari kahojai jahani jaharini-ra onanokiavini, va'ora onasohira kaimoni. Oniania oanavagahaja ida ija'ari kamaodorohaki nokhoni 'ba'dani. Ija'ari oathi-ra kajonivini mani ida nokhoni 'ba'dani vagahariki fori nihani hija. ");
INSERT INTO padNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesus maakarina vahojaha adani farisio, vakamitha'ihi ida kidivarani, vanana'dohi'aha: —Kadavarani hiria koda ida akamaodorohana jaboni? ");
INSERT INTO padNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus va'ora ni'a'aha: —Avanokhoni 'ba'dani vagaharija vaha; hojai asohirikia avakahojaini kaba'i, Deua bina'biramanihi vaha hida avakadihojai asohiriki. Avakamaodoroharini-ra avakahivini mani ida avakadihojai asohiriki Deua bina'biraravini hija bana. ");
INSERT INTO padNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Hari. Jesus vara va'ora ni'avini hiki ida rajomi kavaranihi hoariha. —Ka'oa hiki hida kodivarani. Ovilia vakavasiribanina kania kahojaki ida bakatha kahoarani ka'oa. Ovilia vakavasiribanina kaathania okhajakosiha ada ovilia akadava'ava abono. Kidiani adani ovilia. Bo'di abono, ovilia naabiniva abono hiki ni-ovilia vakavasiribanina kaathania okhajakosiki. Okasiribani'oamaniha. ");
INSERT INTO padNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ovilia akadava'ava abono vani ada bakatha kania okhajakosira. ");
INSERT INTO padNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bakatha kania hojaki ada makhira hoariha bakatha-ra akadava'aki, bo'di abono o'oirara kaimoni. Bakatha akadava'ava abonoa biakarabikhaihi ida ovilia vakavasiribanina kaathani, o'oira kaimoni ada ovilia akadava'ava abono. Ovilia avigaki ida va'ora akadava'aki athi va'ora baranahavini afohanana vaonina, va'ora obananionaniki ada. ");
INSERT INTO padNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Va'ora obananionanivini naothinia okhananava'iki ada ovilia akadava'ava abono, vikasiagaki adani ovilia. Va'ora rakasiagaki athi avigavini. ");
INSERT INTO padNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Va'ora akadava'ariki naothia ni-avikasiagaki. Kidiania avakara'o'iki adani. Athi avigaravini mani ida va'ora ragaafanahaja. ");
INSERT INTO padNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesua biananokhomi'ihi ida kidirajomi, ni-avigaki ida kidivarani va'ora ka'ojomo'ivini hi'iki nahina hini. ");
INSERT INTO padNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesus va'ora vara ni'a'ianaha: —Ka'oa hiki hida kodivarani. Hovani oa ovilia vakavasiribanina kaathani fori ohiki ho. Kodiania avi'oiki fori vihiki adani ovilia va'ora oakadava'ara kaimoni. Kodiania avikhaonaniki fori vihiki adani, va'ora okahinanikara kaimoni. Ovilia fori vihiki adani kodija'ari. ");
INSERT INTO padNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ovilia bo'diava abono fori vihiki adani vahoariha va'oaniaro miro'a vikhaki. Ovilia naabiniva abono fori vihiki adani. Vajahariki adani. Kodija'ari-ra va'ora vakorijanahavini Deu-ra vakava'ipahinira kaimoni. Ni-kodija'aria vanaabaki ida vaathi. ");
INSERT INTO padNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Hovani oa ovilia vakavasiribanina kaathani fori ohiki ho. Vakavasiribanina bodinia vahojana oadani adani ovilia, ni-nahina va'ora namakhaniki. Vakavasiribanina kaathania va'ora arakhaonaniki hogoi-ra vahahara kaimoni. Kodiania khajakosiki fori hiki ida ija'ari kodiania abononi gahinai nihaki. Onivani fori hija ida ija'ari hora kajari'dariki-ra oakava'ijoavini, oakadava'avini jaboni, makhaniria kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bo'di abono-ra rakhaki ovilia vakadiania, binofiki ida ovilia-ra bo'diavini, va'ora naabinivini, va'ora nihimavini. Hora rakhaki ija'ari vakadiania va'ora ono'avini mahi ja'dini jahaki anokhomirikia. Jaha'oamanija ida mahi ja'dini vavahojaki kaimoni hidiaja, Deus kania jaboni — va'ora ni'a'aha ada Jesus. ");
INSERT INTO padNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Rajomi hoariha Jesus abono-ra kavarajomi'aha. Va'ora ni'a'aha: —Hovani oa ovilia akadava'ava abono jahaki fori ohiki ho. Va'ora oakadava'ajahakiki adani kodija'ari. Oabono ova'ahaki ho oabinina kodija'ari-ra va'ora oakava'ijoaja kaimoni. ");
INSERT INTO padNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hari. Hojaki ada honai abono ovilia-ra akadava'aki. Kidiani vihiriha adani ovilia. Ka'oviliakia binaabosiki ada honai abono jiniroa, va'ora akadava'ara kaimoni adani kidi'ovilia. Va'ora akadava'avini vani binokihi ida jomahi hiihiha khani, ovilia-ra va'ora arihavini. Oniaroa, oga'aha ada honai abono. Jomahia biari'iki ida ovilia, vahoariha vaofinina avakaganakhama'iki. Ovilia akadava'ava abono jahaki ni-ogaki. Ni-biva'ahaki ida jomahi kidi'ovilia arini vihina. ");
INSERT INTO padNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Honai abono ni-ovilia-ra va'ora nakaidivaki, onia