﻿USE sofia;
DROP TABLE IF EXISTS sofia.pac_vpl;
CREATE TABLE pac_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pac_vpl WRITE;
INSERT INTO pac_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yê-su Crit tớq te tŏ́ng toiq Davit; alứng Davit tớq te tŏ́ng toiq A-praham. Nhéq máh nốh achúc achiac Yê-su la idô: ");
INSERT INTO pac_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A-praham la a-ám I-sac. I-sac la a-ám Yacốp. Yacốp la a-ám Yuda alứng nhéq máh em ai án. ");
INSERT INTO pac_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda la a-ám Pharêt alứng Sê-rah; a-i nha-án bar náq ngki la Tamar. Pharêt la a-ám Hê-trôn. Hê-trôn la a-ám Aram. ");
INSERT INTO pac_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram la a-ám Ami-nadap. Ami-nadap la a-ám Nasôn. Nasôn la a-ám Sal-môn. ");
INSERT INTO pac_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sal-môn la a-ám Bô-at; a-i Bô-at la Rahap. Bô-at la a-ám Ô-bêt; a-i Ô-bêt la Rutơ. Ô-bêt la a-ám Yê-sai. ");
INSERT INTO pac_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yê-sai la a-ám puo Davit. Davit la a-ám Sa-lamôn; alứng a-i Sa-lamôn la Bat-siba. Te nsuoi a-i án la campái Urie. ");
INSERT INTO pac_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sa-lamôn la a-ám Rê-habuam. Rê-habuam la a-ám Abie. Abie la a-ám Asa. ");
INSERT INTO pac_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa la a-ám Yê-hô-saphat. Yê-hô-saphat la a-ám Yô-ram. Yô-ram la a-ám Usiah. ");
INSERT INTO pac_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiah la a-ám Yô-tham. Yô-tham la a-ám Ahat. Ahat la a-ám Hê-sakie. ");
INSERT INTO pac_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hê-sakie la a-ám Ma-nasê. Ma-nasê la a-ám Amôn. Amôn la a-ám Yô-sie. ");
INSERT INTO pac_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yô-sie ama Yê-canie alứng nhéq máh em ai Yê-canie, ndóng ticuoi Ba-bulôn cŏp achô ticuoi Isa-ra-el nga cruong nha-án ính táq sol. ");
INSERT INTO pac_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Vít ticuoi Ba-bulôn cŏp dông ticuoi Isa-ra-el nga cruong nha-án, dyơ Yê-canie ama Sial-tiel. Sial-tiel la a-ám Saru-babel. ");
INSERT INTO pac_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Saru-babel la a-ám Abi-yut. Abi-yut la a-ám Alia-kim. Alia-kim la a-ám Asô. ");
INSERT INTO pac_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asô la a-ám Sadôc. Sadôc la a-ám Achim. Achim la a-ám E-li-yut. ");
INSERT INTO pac_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","E-li-yut la a-ám E-lia-sơ. E-lia-sơ la a-ám Mathan. Mathan la a-ám Yacốp. ");
INSERT INTO pac_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yacốp la a-ám Yô-sep. Yô-sep la cayieq Mari. Mari la a-i Yê-su, án ndon ngai dŏq Crit. ");
INSERT INTO pac_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iki, te pang A-praham tingôi pang Davit la mui chít la puan pang ticuoi. Náp te pang Davit tớq pang ticuoi Ba-bulôn cŏp ticuoi Isa-ra-el dông nga cruong Ba-bulôn la mui chít la puan pang ticuoi. Alứng te pang ticuoi Ba-bulôn cŏp ticuoi Isa-ra-el dông nga cruong Ba-bulôn tingôi pang Yê-su Crit la mui chít la puan pang ticuoi tưi. ");
INSERT INTO pac_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Carnian Yê-su Crit la veng arớq máh parnai ndô tông. Mari khoiq ưq táq campái Yô-sep. Nha-án iyốh bíq abŏ́h munơi, ma Mari khoiq át cháq-iki nhơ te Arvai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Co Yô-sep la ticuoi partát, án lớiq ính Mari cơt achiet táq ngai. Án át parngíh tớq mít ính táh Mari, ma lớiq ính ngai chom. ");
INSERT INTO pac_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ndóng án yôl parngíh ngê ngki, án mpáu. Án hôm mui náq tarneng Yang Arbang-pilŏ́ng tớq nga án. Tarneng ngki tông idô: “Yô-sep te tŏ́ng toiq Davit ơi! Mái êq adáh ial Mari táq campái mái, án át cháq-iki co te Arvai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Urớh án carnian acái conh. Mái cóq anốh acái ngki la Yê-su, co acái ngki ính choi tamống nhéq máh ticuoi án alứng táh luaih nha-án.” ");
INSERT INTO pac_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nhéq arnáq ndô cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông acớiq na ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh. ");
INSERT INTO pac_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ticuoi ngki khoiq tông idô: “Chô-mát bôn munáq cumor plŏt át cháq-iki, alứng án carnian acái conh. Ngai anốh acái ngki la Ê-manual.” (Parnai Ê-manual titoiq lieh la: ‘Yang Arbang-pilŏ́ng át alứng he.’) ");
INSERT INTO pac_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tư Yô-sep ayư te bíq, án peh nhéq máh parnai tarneng Yang Arbang-pilŏ́ng khoiq patáp án, dyơ án ial Mari táq campái. ");
INSERT INTO pac_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma án lớiq bíq munơi alứng Mari tingôi vít ingái Mari carnian acái conh pông. Alứng án anốh acái ngki la Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Khoiq Yê-su carnian tớq vel Bet-lahem, vúng Yudê, ndóng ngki Hê-rôt cơt puo. Vít ngki bôn ticuoi tubáiq ndon rian te pantôr tớq nga vel pưt Yaru-salem; ma cruong nha-án la te anga pandang ngốh. ");
INSERT INTO pac_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nha-án plốh idô: “Tumo dyơ munáq mbơiq carnian, urớh án cơt puo top Isa-ra-el? He khoiq hôm pantôr te anga pandang ngốh, cơt tíc án khoiq carnian. Iki he tớq tudô ính sang tám án.” ");
INSERT INTO pac_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tư puo Hê-rôt sáng parnai ngki, án sáng crŏ́q lư, alứng nhéq máh ticuoi tớq vel Yaru-salem sáng crŏ́q tưi. ");
INSERT INTO pac_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iki Hê-rôt parŏm nhéq máh ticuoi sút top teng rit sang Yang Arbang-pilŏ́ng, alứng máh thới sái rit. Alứng án plốh nha-án idô: “Tớq ntúq mmo Crit carnian?” ");
INSERT INTO pac_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nha-án ôi idô: “Crit carnian tớq vel Bet-lahem, vúng Yudê. Co bôn munáq tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh idô: ");
INSERT INTO pac_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ơ vel Bet-lahem tớq cruong Yuda ơi! Mái la tới vel bôn chức két, khán tali alứng máh vel sút tớq cruong Yuda. Co bôn munáq tớq te mái, án bôn chức pưt lư. Án ayông máh ticuoi prái Cư, la ticuoi Isa-ra-el.’” ");
INSERT INTO pac_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Vít ngki Hê-rôt arô clôp máh ticuoi tubáiq. Dyơ án plốh nha-án idô: “Ndóng mmo táp inha hôm pantôr ngki ngốh?” Dyơ nha-án táq-ntêr dyôn án chom. ");
INSERT INTO pac_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dyơ án yua máh ticuoi tubáiq pôq nga vel Bet-lahem, alứng án patáp nha-án idô: “Inha pôq suo simớt simơi ngai-acái ngki. Tớq inha tumúh án, inha tớq táq-ntêr a cư nư. Co cư ính pôq sang tám án tưi.” ");
INSERT INTO pac_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cua nha-án cammáng parnai puo tông, nha-án pôq sa. Nha-án hôm sa pantôr ngki át pa anga pandang ngốh. Pantôr ngki pôq nsuoi nha-án, alứng trín aryư ntúq ngai-acái ngki át. ");
INSERT INTO pac_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tớq nha-án hôm pantôr, ngki nha-án sáng bui ơn lư. ");
INSERT INTO pac_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tư nha-án mot tớq dúng, nha-án hôm ngai-acái alứng Mari a-i ngai-acái. Dyơ nha-án chóh tarcol sang ngai-acái ngki. Alứng nha-án pốh hip ndon bôn crơng ngáih, dyơ angốh mŏp sang dyôn ngai-acái ngki, bôn dyeng, calớu rŏq, alứng sêt thum. ");
INSERT INTO pac_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dyơ Yang Arbang-pilŏ́ng tông nha-án tớq parnáu lớiq dyôn nha-án chô nnáng nga dúng Hê-rôt. Iki nha-án chô nga cruong nha-án na carna cannŏ́h loi. ");
INSERT INTO pac_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tớq vít ticuoi tubáiq chô, bôn mui tarneng Yang Arbang-pilŏ́ng tớq nga Yô-sep na parnáu, alứng tông idô: “Mái yôr táp, dông ngai-acái alứng a-i án ngốh, alứng pôq nga cruong Ê-yip-tô. Inha át dơ tớq cruong ngki tingôi cư tớq tông lieh inha, co puo Hê-rôt suo ính cachet ngai-acái ngki.” ");
INSERT INTO pac_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ndóng Yô-sep yôr tayứng ngki yôl ngiau. Dyơ án dông ngai-acái nha a-i acái ngki pôq nga cruong Ê-yip-tô. ");
INSERT INTO pac_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nha-án át tớq ngki tingôi ingái Hê-rôt cuchet. Arnáq ndô cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông na ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh idô: “Cư arô acái conh cư dyôn ngốh te cruong Ê-yip-tô.” ");
INSERT INTO pac_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tớq Hê-rôt chom ticuoi tubáiq clúq án, iki án sáng uan lư. Dyơ án yua ngai pôq cachet nhéq máh ngai-acái conh te bar cumo asiar tớq vel Bet-lahem, alứng tớq máh vel paniar vel ngki. Án ngiaih te ingái ticuoi tubáiq táq-ntêr dyôn án chom te nha-án hôm pantôr tíc. ");
INSERT INTO pac_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iki cơt tarvớiq simớt parnai Yê-ramie la ticuoi tang ngcang khoiq tông te inớh idô: ");
INSERT INTO pac_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ngai sáng sieng cucloiq cucling te vel Rama; la sieng Rachel nhiem atíh co án alang máh acái án. Án lớiq cammáng parnai ngai khêr án, co án lớiq bôn nnáng acái.” ");
INSERT INTO pac_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Vít Hê-rôt cuchet, bôn mui tarneng Yang Arbang-pilŏ́ng tớq nga Yô-sep na parnáu sa, tớq cruong Ê-yip-tô, ");
INSERT INTO pac_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","alứng tông án idô: “Yôr tayứng. Dông ngai-acái alứng a-i án chô lieh nga cruong Isa-ra-el, co ticuoi ính cachet ngai-acái khoiq cuchet dyơ.” ");
INSERT INTO pac_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iki Yô-sep yôr tayứng, dyơ án dông ngai-acái alứng a-i acái ngki chô lieh nga cruong Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma tư Yô-sep sáng ngai táq-ntêr Achê-lau cơt puo tớq vúng Yudê, cláp lieh Hê-rôt a-ám án, iki Yô-sep lớiq dáh chô nga tuki. Dyơ Yang Arbang-pilŏ́ng tông án na parnáu sa. Co iki Yô-sep pôq át nga vúng Ca-lilê loi. ");
INSERT INTO pac_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yô-sep pôq át nga vel Na-saret. Iki cơt tarvớiq simớt parnai ticuoi tang ngcang te inớh khoiq tông idô: “Ngai dŏq án la ticuoi Na-saret.” ");
INSERT INTO pac_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ndóng ngki, Yon táq tíc na dơq tớq cato parnai ŏ te Yang Arbang-pilŏ́ng nga ntúq aih, tớq vúng Yudê. ");
INSERT INTO pac_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Án cato idô: “Cóq inha ngin luaih pien cơt mít tamme loi, co khoiq tumán lư dyơ ingái Yang Arbang-pilŏ́ng cơt sút.” ");
INSERT INTO pac_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ê-sai la ticuoi tang ngcang khoiq tông te Yon idô: “Bôn sieng tubau yứng te ntúq aih, idô: ‘Cóq inha pangcra carna dyôn Ưlla he. Cháh báng dyôn tinớng carna dyôn án pôq.’” ");
INSERT INTO pac_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yon ndô báq tớc tampớc te sóc pannán lac-da. Alứng án kitớn pa-eu ngcár tớq tarving án. Án cha aliem, alứng ngoiq dơq canyiel te arưih. ");
INSERT INTO pac_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bôn ticuoi prái te vel Yaru-salem alứng chôp cruong Yudê, díh ticuoi át paniar dơq crong Yôr-dan hơ tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nha-án ngin luaih, dyơ Yon táq tíc na dơq dyôn nha-án tớq crong Yôr-dan. ");
INSERT INTO pac_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tư Yon hôm clứng ticuoi te top Pha-rasi alứng te top Sa-dusê tớq nga án, ính án táq tíc na dơq dyôn nha-án, iki án tông ada nha-án idô: “Inha pla arớq cusánh tur. Inha lớiq têq viar vít te Yang Arbang-pilŏ́ng táq inha tớq án táq máh ticuoi luaih, tớq ingái talloiq. ");
INSERT INTO pac_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cóq inha táq arnáq ŏ. Ndô la tíc inha khoiq ngin luaih pien cơt mít tamme loi. ");
INSERT INTO pac_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Êq parngíh inha têq viar vít te tôt, co inha ngin idô: ‘A-praham la achúc achiac he.’ Cư tông inha arlớih lư, khán Yang Arbang-pilŏ́ng ính, têq án ial búl teng cơt tŏ́ng toiq A-praham. ");
INSERT INTO pac_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hoi-ndô arớq bôn mui pla achát payơ tumán tôm along. Tôm mmo lớiq bôn culái ŏ, ngai ính cớl alứng arpớt tớq uih. ");
INSERT INTO pac_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Cư táq tíc dyôn inha na dơq, la tíc inha pien cơt mít tamme loi. Ma án ndon tớq tatun cư, án ngki bôn chức clưi te cư. Cư lớiq crái díh léh ntár cơp te dyưng án, co chức cư la két lư. Án ính táq tíc dyôn inha na Arvai Yang Arbang-pilŏ́ng alứng na uih. ");
INSERT INTO pac_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ati án kéu adêng, dyơ án u-om nhéq máh sro án. Callong mmo chong, án dŏq tớq tanic. Ma acam ngki án chŏ́ng tớq uih chéh lớiq nai pát.” ");
INSERT INTO pac_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ndóng ngki Yê-su ngốh te vúng Ca-lilê pôq nga dơq crong Yôr-dan, co án ính Yon táq tíc na dơq dyôn án. ");
INSERT INTO pac_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma Yon suon lớiq ính táq tíc na dơq dyôn án. Yon tông idô: “Piaiq lư la cana táq tíc na dơq dyôn cư. Co imo cana tớq nga cư, ính cư táq tíc na dơq dyôn cana?” ");
INSERT INTO pac_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Yê-su ôi Yon idô: “Hoi-ndô cóq mái táq tíc na dơq dyôn cư. He cóq táq cứp nốh ndon Yang Arbang-pilŏ́ng khoiq yua he táq.” Cua Yê-su tông iki; Yon táq tíc na dơq dyôn án. ");
INSERT INTO pac_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cua Yê-su ráp tíc na dơq, dyơ án sớr te dơq. Iki pilŏ́ng arớq ngai pốh, alứng án hôm Arvai Yang Arbang-pilŏ́ng siar te pilŏ́ng arớq achếq cacu bôt tớq cháq án. ");
INSERT INTO pac_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mui parrứh ngki, bôn sieng Yang Arbang-pilŏ́ng tubau te pilŏ́ng tông idô: “Ndô la Acái cư, án ndon cư amoih lư. Cư sáng bui cannính lư alứng án.” ");
INSERT INTO pac_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Vít ngki Arvai Yang Arbang-pilŏ́ng dông Yê-su pôq nga ntúq aih, dŏq dyôn yang Satán chim Yê-su na tardông án táq luaih. ");
INSERT INTO pac_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yê-su ót tanna nhéq puan chít ingái puan chít idáu. Vít ngki án sáng pinhaih lư. ");
INSERT INTO pac_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dyơ yang Satán tớq táp nga Yê-su, alứng tông idô: “Khán mái lư Acái Yang Arbang-pilŏ́ng, áu mái táq máh búl ndô dyôn cơt crơng tanna.” ");
INSERT INTO pac_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Yê-su ôi án idô: “Tớq tám uráq Yang Arbang-pilŏ́ng khoiq taran idô: ‘Ticuoi lớiq bôn tumống co nhơ nưm te cha crơng tanna, ma ticuoi bôn tumống co nhơ te cứp parnai ngốh te ngcang Yang Arbang-pilŏ́ng.’” ");
INSERT INTO pac_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Vít ngki yang Satán dông Yê-su mot tớq vel pưt Yaru-salem, la vel mmar na Yang Arbang-pilŏ́ng. Án dyôn Yê-su sớr tayứng tớq mpien mpuong Dúng Sang Pưt, ");
INSERT INTO pac_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","alứng án tông idô: “Khán mái lư Acái Yang Arbang-pilŏ́ng, áu mái póng asiar, co tớq tám uráq Yang Arbang-pilŏ́ng khoiq taran idô: ‘Yang Arbang-pilŏ́ng ính yua máh tarneng án kiaq me níc mái. Nha-án ính dơ mái na ati nha-án, lớiq dyôn dyưng mái cơt bác chol amớh tớq búl.’” ");
INSERT INTO pac_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Yê-su ôi lieh án idô: “Ma lư tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô tưi: ‘Inha êq chim Yang Arbang-pilŏ́ng Ưlla inha.’” ");
INSERT INTO pac_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dyơ yang Satán dông Yê-su sớr tớq cóh ayống lư loi. Án apáh dyôn Yê-su me cứp cruong pưt tớq cúc cuteq ndô, alứng cứp nốh chức ang-ưr tớq máh cruong ngki. ");
INSERT INTO pac_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Alứng án tông Yê-su idô: “Nhéq máh nốh ndô cư ính mŏp a mái, khán mái chóh tarcol sang cư.” ");
INSERT INTO pac_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yê-su ôi án idô: “Mái tôi yông te ndô, Satán! Co tớq tám uráq Yang Arbang-pilŏ́ng khoiq taran dyơ idô: ‘Cóq inha sang tám nưm Yang Arbang-pilŏ́ng Ưlla inha, alứng táq nưm arnáq án sớng.’” ");
INSERT INTO pac_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dyơ yang Satán ngốh táp te Yê-su, alứng bôn tarneng Yang Arbang-pilŏ́ng tớq choi Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tớq Yê-su sáng hanh khoiq ngai cŏp Yon, iki án pôq nga vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Cua án ngốh te vel Na-saret, án mot át tớq vel Cabê-na-um loi. Vel ndô át tớq tor dơq clóng Ca-lilê, tớq cruong Sa-bulôn nha cruong Nep-tali. ");
INSERT INTO pac_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Án táq iki dyôn cơt tarvớiq simớt parnai Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng ");
INSERT INTO pac_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","khoiq tông idô: “Cruong Sa-bulôn nha cruong Nep-tali ơi! Cruong inha át pa dyáng atóh dơq crong Yôr-dan, keng carna pôq nga clóng Ca-lilê. Vúng Ca-lilê bôn ticuoi tới ticuoi Isa-ra-el át. ");
INSERT INTO pac_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Máh ticuoi ndon át tớq ntúq ngiau, nha-án bôn hôm callong tráh ang lư. Alứng máh ticuoi át tớq ntúq cuchet, nha-án bôn hôm ang claq nga nha-án.” ");
INSERT INTO pac_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Náp te ngki, Yê-su tabớq cato ngê Yang Arbang-pilŏ́ng. Án cato idô: “Cóq inha pien cơt mít tamme loi, co tumán lư dyơ, Yang Arbang-pilŏ́ng cơt sút.” ");
INSERT INTO pac_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ndóng Yê-su pôq paniar tor clóng Ca-lilê, án hôm bar náq em ai, nốh Si-môn (ngai dŏq Phi-er) alứng Anrê. Nha-án bar náq lai mben tớq clóng dơq, co nha-án la ticuoi táq arnáq suo buaiq. ");
INSERT INTO pac_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yê-su tông nha-án idô: “Inha veng tapun cư, dyơ cư ính táq dyôn inha cơt ticuoi suo ticuoi arớq inha suo buaiq tưi.” ");
INSERT INTO pac_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ndóng ngki táp nha-án táh mben; dyơ nha-án veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yê-su pôq mubiq loi; dyơ án hôm bar náq em ai cannŏ́h loi, nốh Yacơ alứng Yon. Nha-án bar náq át clam lieh mben tớq tuoc munơi alứng a-ám nha-án, nốh Sê-badê. Yê-su arô bar náq em ai ngki. ");
INSERT INTO pac_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ndóng ngki táp nha-án bar náq táh tuoc, alứng pôq te a-ám nha-án, dyơ veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yê-su pôq chôp vúng Ca-lilê, án cato parnai ŏ te Yang Arbang-pilŏ́ng cơt sút tớq máh dúng rum ticuoi Isa-ra-el, alứng án táq bánh máh ticuoi bôn cứp nốh a-ái. ");
INSERT INTO pac_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Máh arnáq Yê-su táq cơt parhanh cứp ntúq tớq cruong Si-ri. Alứng ngai dông nga án nhéq máh ticuoi ndon bôn a-ưi nốh a-ái, idô: A-ái ntróq, yang saq piyúh, a-ái yúh kisong, alứng a-ái cớng cháq. Yê-su táq bánh nhéq máh ticuoi a-ái ngki. ");
INSERT INTO pac_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Co iki bôn clứng lư ticuoi veng tapun Yê-su. Máh ticuoi ngki tớq te vúng Ca-lilê, cruong Dê-ca-palớt, vel pưt Yaru-salem, vúng Yudê, alứng cruong pa dyáng atóh dơq crong Yôr-dan. ");
INSERT INTO pac_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tư Yê-su hôm ticuoi clứng tớq nga án, iki án sớr nga cóh; dyơ án ticu. Top rian te án ticu tumán án. ");
INSERT INTO pac_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dyơ Yê-su tabớq cato nha-án idô: ");
INSERT INTO pac_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bún lư máh ticuoi ndon ngin mít cannính nha-án lớiq bôn ŏ, co Yang Arbang-pilŏ́ng cơt sút tớq mít cannính nha-án. ");
INSERT INTO pac_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bún lư máh ticuoi ndon sáng anguaq tớq pang ndô, co urớh Yang Arbang-pilŏ́ng táp khêr nha-án. ");
INSERT INTO pac_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bún lư máh ticuoi ndon bôn mít lambŏt, co urớh Yang Arbang-pilŏ́ng dyôn nha-án cơt ưlla cúc cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bún lư máh ticuoi ndon tél-sél ính táq arnáq tinớng ŏ, co urớh Yang Arbang-pilŏ́ng dyôn nha-án bôn arớq cannính nha-án ính. ");
INSERT INTO pac_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bún lư máh ticuoi ndon sáng sruiq táq ticuoi cannŏ́h, co urớh Yang Arbang-pilŏ́ng sáng sruiq táq nha-án tưi. ");
INSERT INTO pac_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bún lư máh ticuoi ndon bôn mít cannính lớiq bôn luaih amớh, co urớh nha-án bôn hôm Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bún lư máh ticuoi ndon tardông yớu át artoi, co urớh Yang Arbang-pilŏ́ng dŏq ticuoi ngki la acái acon án. ");
INSERT INTO pac_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bún lư máh ticuoi ndon tumúh dieiq arức co tian nha-án veng ngê Yang Arbang-pilŏ́ng, co urớh nha-án bôn cơt ưlla tưi ntúq Yang Arbang-pilŏ́ng sút tớq pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bún lư inha, tớq ticuoi cannŏ́h pandyớp inha, táq inha, alứng ton inha táq máh callong saq, co tian inha veng ngê cư. ");
INSERT INTO pac_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cóq inha sáng bui alứng ơn, co urớh inha bôn cống a-ưi tớq pilŏ́ng. Co máh ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh khoiq chiuq ngai táq nha-án muchứng inha tưi.” ");
INSERT INTO pac_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Inha la arớq boi dyôn máh ticuoi tớq cúc cuteq ndô. Ma khán boi cơt atieh, táq imo dyôn boi ngki têq cơt báq lieh? Lư lớiq têq táq amớh nnáng. Ngai adúh boi ngki tớq cuteq dyôn ticuoi dếq. ");
INSERT INTO pac_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Inha la arớq ang claq dyôn máh ticuoi ndon át tớq cúc cuteq ndô. Inha la arớq mui vel pưt tớq mpien cóh ayống. Lư lớiq têq catốq vel ngki. ");
INSERT INTO pac_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Muchứng ngki tưi, lớiq bôn ngai bet den tớu, dyơ catứp tớq yáng. Ma lư ngai dŏq den tớu tớq aruong den dyôn ang claq nga máh ticuoi tớq dúng. ");
INSERT INTO pac_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Muchứng ngki tưi, cóq inha dyôn ang te inha claq nga máh ticuoi dyôn bôn hôm máh arnáq ŏ inha táq, dyơ nha-án lư ayô A-ám inha tớq pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Inha êq parngíh cư tớq nga tudô co ính pupít phep rit Môi-se, lớiq la máh parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh. Cư lớiq bôn tớq co ính pupít máh parnai ngki, ma cư tớq co ính táq dyôn máh parnai ngki cơt lư. ");
INSERT INTO pac_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cư tông inha arlớih lư, khán yôl bôn pilŏ́ng alứng cuteq, lư lớiq bôn pít mui callong amớh te phep rit ndô tingôi sút nhéq pang. ");
INSERT INTO pac_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iki, khán ticuoi mmo táh mui callong két hơn te cannŏ́h tớq phep rit ngki, alứng cato ticuoi cannŏ́h dyôn táh tưi, ticuoi ngki cơt két hơn te cannŏ́h tớq top Yang Arbang-pilŏ́ng sút. Ma ticuoi mmo peh phep rit ngki alứng cato ticuoi cannŏ́h dyôn peh tưi, ticuoi ngki lư cơt pưt hơn te cannŏ́h tớq top Yang Arbang-pilŏ́ng sút. ");
INSERT INTO pac_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iki cư tông inha, khán inha ính mot tớq top Yang Arbang-pilŏ́ng sút, inha cóq veng ngê Yang Arbang-pilŏ́ng dyôn ŏ clưi te máh thới sái rit alứng máh ticuoi Pha-rasi.” ");
INSERT INTO pac_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Inha khoiq sáng dyơ ngai tông ada ticuoi te inớh idô: ‘Êq cachet ticuoi. Ticuoi mmo cachet ticuoi cannŏ́h, ngai lư dông tarsưq án.’ ");
INSERT INTO pac_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma cư tông inha idô: Khán ticuoi mmo sáng nháih ada em ai án, Yang Arbang-pilŏ́ng lư sưq án. Ticuoi mmo pi-ốh em ai án na tông idô: ‘Mái achơ lư,’ Yang Arbang-pilŏ́ng lư sưq án. Ma khán ticuoi mmo chau alứng pupap em ai án, Yang Arbang-pilŏ́ng lư apŏ́ng án tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Iki, khán inha ính dông crơng mŏp sang dyôn Yang Arbang-pilŏ́ng nga parông sang, ma inha ayư te em ai inha yôl uan ada inha, ");
INSERT INTO pac_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","iki cóq inha dŏq crơng ính mŏp sang tớq dúng sang avai. Dyơ cóq inha píh chô tar-ŏ lieh alứng em ai inha, ki-náq inha dông crơng mŏp sang dyôn Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tớq inha tarluaih alứng ticuoi cannŏ́h, alứng ticuoi ngki ính dông inha nga ntúq ngai tarsưq, iki cóq inha sŏ́ng achái artoi lieh alứng án ndóng inha iyốh tớq nga ntúq ngki. Khán inha lớiq sŏ́ng artoi achái, dáh lơ ngai dông inha nga ticuoi tarsưq dyôn sưq inha. Iki ticuoi tarsưq ính mŏp inha dyôn ngai crál tớq coq tôt. ");
INSERT INTO pac_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Inha lớiq têq ngốh te coq tôt tingôi inha dyôn máh práq arớq ticuoi tarsưq tông. ");
INSERT INTO pac_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Inha khoiq sáng dyơ ngai tông idô: ‘Êq láh parlưi.’ ");
INSERT INTO pac_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma cư tông inha idô: Ticuoi mmo me nga ticuoi cán, alứng mít cannính án parngíh ính bôn cán ngki, callong luaih tớq mít cannính ticuoi ngki la muchứng án khoiq láh parlưi cán ngki dyơ. ");
INSERT INTO pac_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Khán callong mát pa atớm ma dông inha táq luaih, cóq inha culáiq táh callong mát ngki. Khaq inha pít nưm mui callong mát sớng, aláng inha pít nhéq cháq tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Alứng khán ati atớm ma dông inha táq luaih, cóq inha cŏ́h adúh ati ngki. Khaq inha pít nưm mui pa ati sớng, aláng inha pít nhéq cháq tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bôn ngai khoiq tông idô: ‘Ticuoi mmo ính táh campái, án cóq táq chớiq partáh dyôn campái án.’ ");
INSERT INTO pac_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma cư tông inha idô: Khán ticuoi mmo táh campái, ma campái án lớiq bôn láh parlưi conh cannŏ́h, arnáq ngki án táq dyôn campái án bôn luaih tớq campái án ial cayieq tamme. Alứng ticuoi conh ndon ial cán ngki la bôn luaih arớq láh parlưi campái ngai. ");
INSERT INTO pac_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Inha khoiq sáng dyơ ngai tông te ticuoi te inớh idô: ‘Khán inha cantŏ́h callih amớh ma bôiq nốh Yang Arbang-pilŏ́ng, ngki inha lớiq têq táh nnáng.’ ");
INSERT INTO pac_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma cư tông inha idô: Khán inha ính sŏ́ng mui arnáq amớh, inha êq bôiq nốh amớh. Êq bôiq pilŏ́ng, co pilŏ́ng la ntúq Yang Arbang-pilŏ́ng át. ");
INSERT INTO pac_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Êq bôiq cúc cuteq, co cuteq la Yang Arbang-pilŏ́ng táp ưlla. Êq bôiq vel pưt Yaru-salem, co vel ngki la vel na Yang Arbang-pilŏ́ng, Án ndon Puo Sút Pưt. ");
INSERT INTO pac_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Alứng inha êq bôiq díh plô sóc inha, co inha lớiq têq táq mui ntráih sóc clŏq lớiq la com. ");
INSERT INTO pac_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Khán piaiq, inha tông ‘piaiq.’ Khán lớiq piaiq, inha tông ‘Lớiq piaiq.’ Khán inha tông a-ưi parnai loi, parnai ngki tớq te yang Satán. ");
INSERT INTO pac_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Inha khoiq sáng dyơ ngai tông idô: ‘Mát palieh mát; kineng palieh kineng.’ ");
INSERT INTO pac_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma cư tông inha idô: Êq carlieh dơq ada ticuoi táq inha. Khán ngai páh tabang inha pa atớm, cóq inha to dyôn án páh pa aviar hơ. ");
INSERT INTO pac_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Khán ngai dông inha nga ticuoi tarsưq co ính bôn au inha pa tadưp, ngki cóq inha luaiq díh au thor culái tieh hơ dyôn án. ");
INSERT INTO pac_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Khán ngai patot inha pôq mui ki-lô-met, cóq inha pôq lớng bar ki-lô-met alứng án. ");
INSERT INTO pac_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Khán ticuoi mmo seq amớh te inha, cóq inha dyôn án ngki. Alứng khán ticuoi mmo ính manh amớh te inha, cóq inha dyôn án manh ngki. ");
INSERT INTO pac_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Inha khoiq sáng dyơ ngai tông idô: ‘Cóq inha amoih yớu inha, alứng a-ính ticuoi picon inha.’ ");
INSERT INTO pac_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma cư tông inha idô: Cóq inha amoih máh ticuoi picon inha, alứng cóq inha cớu dyôn ticuoi ndon táq dieiq arức inha. ");
INSERT INTO pac_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Táq iki, inha lư bôn cơt acái acon A-ám inha tớq pilŏ́ng. Co án dyôn mát pandang claq nga ticuoi ŏ alứng ticuoi lới. Alứng án dyôn bo srôq ticuoi tinớng ŏ, alứng ticuoi lớiq tinớng ŏ. ");
INSERT INTO pac_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Khán inha amoih nưm ticuoi amoih inha, amớh loi Yang Arbang-pilŏ́ng ính dyôn inha bôn cống? Lư ticuoi ial práq thêq la táq muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Alứng khán inha pasôl ŏ nưm em ai inha, inha lớiq ndái amớh te ticuoi cannŏ́h. Díh ticuoi lớiq nai sáng te nốh Yang Arbang-pilŏ́ng la táq muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Iki, cóq inha bôn mít cannính arớq A-ám inha tớq pilŏ́ng, án ndon ŏ cứp nốh. ");
INSERT INTO pac_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Cóq inha me a-ŏ! Tớq inha táq arnáq ính veng ngê Yang Arbang-pilŏ́ng, inha êq táq co ính ngai ayô inha. Khán inha táq iki, A-ám inha tớq pilŏ́ng lớiq dyôn inha bôn cống te arnáq inha táq. ");
INSERT INTO pac_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Iki tớq inha ính choi ticuoi kidit, inha êq dyôn ticuoi cannŏ́h chom, co ính ngai ayô inha. Ticuoi náh-nnan báq táq iki tớq dúng rum, alứng tớq carna hơ. Nha-án ính lư ticuoi cannŏ́h hôm alứng ayô nha-án. Ma cư tông inha arlớih lư, nha-án khoiq bôn ráp dyơ cống nha-án. ");
INSERT INTO pac_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma tớq inha ính choi ticuoi kidit, cóq inha táq clôp, êq dyôn ngai hôm. ");
INSERT INTO pac_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tam inha táq clôp, ma A-ám inha tớq pilŏ́ng hôm máh arnáq inha táq, alứng án dyôn inha bôn cống te máh arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tớq inha cớu, inha êq soi ticuoi ndon táq náh-nnan. Ticuoi ngki báq tayứng cớu tớq dúng rum alứng tớq carna, co ính ticuoi hôm nha-án cớu, dyơ ngai ayô nha-án. Ma cư tông inha arlớih lư, nha-án khoiq bôn ráp dyơ cống te arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma tớq inha cớu, cóq inha mot tớq callúng alứng catáng callống. Át ntúq ngki, inha cớu nga A-ám inha ndon inha lớiq nai hôm. Ma án lư hôm inha cớu tớq ntúq clôp ngki, alứng án dyôn inha bôn cống. ");
INSERT INTO pac_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Tớq inha cớu, inha êq cớu alứp-adưq lớiq cơt callong arớq ticuoi lớiq chom Yang Arbang-pilŏ́ng. Nha-án parngíh cóq cớu a-ưi parnai ki-náq yang nha-án cammáng. ");
INSERT INTO pac_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Inha êq táq arớq ticuoi ngki. Co A-ám inha tớq pilŏ́ng khoiq chom dyơ nốh amớh inha ớq, te nsuoi inha iyốh seq te án. ");
INSERT INTO pac_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Iki tớq inha cớu, cóq inha cớu idô: ‘Cucúh A-ám he tớq pilŏ́ng ơi! Seq inha dyôn nhéq tưh ticuoi dyám náp nốh inha. ");
INSERT INTO pac_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Seq inha cơt sút nhéq tưh ticuoi tớq cúc cuteq ndô. Alứng seq inha dyôn ngai peh ngê inha tớq cúc cuteq ndô muchứng ngai peh ngê inha tớq pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Seq inha dyôn he bôn khám cha ingái ndô. ");
INSERT INTO pac_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Seq inha táh luaih he muchứng he khoiq táh luaih ngai táq ada he. ");
INSERT INTO pac_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Seq inha êq dyôn he tumúh callong chim ntáng lư, alứng êq dyôn yang Satán tardông he táq arnáq saq. Co nhéq nốh sút, nhéq nốh chức, alứng nhéq nốh ang-ưr át níc alứng inha, sút pang lang dơi. Amen.’ ");
INSERT INTO pac_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Khán inha táh luaih ticuoi cannŏ́h táq ada inha, A-ám inha tớq pilŏ́ng lư táh luaih inha tưi. ");
INSERT INTO pac_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma khán inha lớiq táh luaih ngai táq ada inha, A-ám inha tớq pilŏ́ng lư lớiq táh tưi luaih inha. ");
INSERT INTO pac_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tớq inha ót tanna ính parngíh te ngê Yang Arbang-pilŏ́ng, inha êq táq chưq pangu mát móh arớq ticuoi náh-nnan báq táq. Nha-án táq ngki co ính ticuoi cannŏ́h chom nha-án ót tanna. Cư tông inha arlớih lư, nha-án khoiq bôn dyơ cống te arnáq nha-án táq. ");
INSERT INTO pac_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma tớq inha ót tanna ính parngíh te ngê Yang Arbang-pilŏ́ng, cóq inha buaiq mát móh alứng cachic sóc pôi. ");
INSERT INTO pac_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Êq dyôn ticuoi cannŏ́h chom inha ót tanna. Ma nưm A-ám inha chom. A-ám ndon inha lớiq nai hôm, lư án hôm máh arnáq clôp inha táq, alứng án lư dyôn inha bôn cống te máh arnáq inha táq. ");
INSERT INTO pac_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Inha êq pachúng parŏm dŏq mun tớq pang ndô, la ntúq camuar crớm, taréh cha, alứng siveng têq mot tôiq. ");
INSERT INTO pac_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma cóq inha pachúng parŏm dŏq mun tớq pilŏ́ng, la ntúq lớiq bôn camuar crớm, taréh cha, alứng siveng lớiq têq mot tôiq. ");
INSERT INTO pac_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Co ntúq mmo inha dŏq máh mun inha, mít cannính inha át parngíh níc te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mát ticuoi la arớq tabong dyôn cháq. Khán mát inha bôn hôm, nhéq cháq inha lư cơt ang. ");
INSERT INTO pac_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma khán mát inha cơt sơm, nhéq cháq inha lư cơt ngiau til-nhil tháng. Alứng khán ngê inha parngíh ang, ma lớiq lư ang, ngki inha cơt ngiau lư loi. ");
INSERT INTO pac_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Lớiq bôn ticuoi mmo têq cơt sol dyôn bar náq ưlla. Piaiq án a-ính ưlla ndô, ma amoih ưlla ngki, lớiq la án dyám náp ưlla ndô, ma pamat ưlla ngki. “Muchứng ngki tưi, inha lớiq têq veng ngê Yang Arbang-pilŏ́ng trap alứng veng ngê ham ntưn tớq pang ndô. ");
INSERT INTO pac_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Co iki cư tông inha, êq rớu-ri te tanna inha ính cha, te dơq inha ính ngoiq, alứng te tampớc inha ính tớc. Callong he bôn tumống la pưt hơn te he bôn tanna cha. Alứng he bôn cháq chớn la pưt hơn te he bôn tampớc tớc. ");
INSERT INTO pac_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Inha me nga máh achếq ndon pár tớq pilŏ́ng. Án lớiq bôn chớt choi, lớiq bôn sot, alứng lớiq bôn pachúng amớh dŏq tớq tinong. Ma A-ám inha tớq pilŏ́ng chứm chiam án. Alứng Yang Arbang-pilŏ́ng ayáu inha a-ưi hơn te máh achếq. ");
INSERT INTO pac_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Lớiq bôn ticuoi mmo têq to anhúq án dyôn cơt toiq hơn, co nhơ te án rớu-ri a-ưi. ");
INSERT INTO pac_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Alứng co imo inha rớu-ri te máh tampớc tớc? Inha me nga pier sác. Pier ngki lớiq cóq táq arnáq dŏq bôn tampớc tớc. ");
INSERT INTO pac_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma cư tông inha arlớih lư, puo Sa-lamôn ndon súc lư, án lớiq bôn sứp tampớc dêu ŏ arớq pier ndô. ");
INSERT INTO pac_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yang Arbang-pilŏ́ng táp táq dyôn pier sác cơt amaiq. Ma pier ngki tumống muhoi sớng. Ingái ndô án lang; ingái parnô án cardyop, dyơ ngai adúh tớq uih. Ma clưi te pier ngki loi Yang Arbang-pilŏ́ng lư dyôn inha bôn tampớc tớc. Co imo inha tin biq lư? ");
INSERT INTO pac_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Iki inha êq rớu-ri, dyơ tông idô: ‘Amớh he ính táq dyôn bôn tanna cha, bôn dơq ngoiq, lớiq la bôn tampớc tớc tớq ingái tatun?’ ");
INSERT INTO pac_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Máh nốh ndô, ticuoi ndon lớiq chom Yang Arbang-pilŏ́ng báq rớu-ri. Ma A-ám inha tớq pilŏ́ng khoiq chom dyơ, nốh amớh inha cóq bôn. ");
INSERT INTO pac_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nsuoi lư, cóq inha suo dyôn Yang Arbang-pilŏ́ng cơt sút tớq mít cannính inha, alứng suo ngê tinớng ŏ te án. Dyơ án lư dyôn inha bôn máh nốh ngki. ");
INSERT INTO pac_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iki inha êq rớu-ri te ingái parnô. Parnô la phê ingái parnô. Dieiq arức ingái mmo, inha chiuq ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Inha êq tíq ticuoi cannŏ́h, dŏq Yang Arbang-pilŏ́ng lớiq tíq inha tưi. ");
INSERT INTO pac_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Co máh-mmo inha tíq ticuoi cannŏ́h, Yang Arbang-pilŏ́ng lư tíq lieh inha máh ngki tưi. Alứng máh-mmo inha ngiaih luaih yớu, Yang Arbang-pilŏ́ng lư ngiaih luaih inha máh ngki tưi. ");
INSERT INTO pac_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Imo inha hôm sál tớq mát yớu, ma inha lớiq chom bôn mêng pan cadíl tớq mát inha? ");
INSERT INTO pac_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Alứng imo inha dáh lư tông yớu idô: ‘Dyôn cư tuváih angốh sál te mát mái,’ ma inha lớiq chom bôn mêng pan cadíl tớq mát inha? ");
INSERT INTO pac_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Inha la ticuoi táq náh-nnan sớng! Cóq inha ial viang mêng pan te mát inha avai, ki-náq têq inha hôm arlớih, alứng têq inha ial sál te mát yớu. ");
INSERT INTO pac_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Inha êq ial crơng mmar na Yang Arbang-pilŏ́ng, dyơ dyôn acho. Alứng êq ial crơng ngáih, dyơ dyôn alic. Máh pannán ngki lớiq chom ayáu. Cua án dếq kisier crơng ngki, dyơ án píh cáp inha.” ");
INSERT INTO pac_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Khán inha seq, ngki inha bôn. Khán inha suo, ngki inha tumúh. Khán inha acóh callống, ngki ngai pốh dyôn. ");
INSERT INTO pac_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Co cứp náq ticuoi ndon seq, ngki án bôn. Ticuoi mmo suo, ngki án tumúh. Ticuoi mmo acóh callống, ngki ngai pốh dyôn. ");
INSERT INTO pac_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Máh inha ndon khoiq bôn acái, khán acái inha seq beng, inha dyôn án búl lớiq? ");
INSERT INTO pac_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Alứng khán án seq buaiq, inha dyôn án cusánh lớiq? ");
INSERT INTO pac_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Inha la máng ticuoi lới, ma inha chom dyôn crơng ŏ nga acái inha. Lư clưi te ngki loi A-ám inha tớq pilŏ́ng, án dyôn inha bôn crơng ŏ khán inha seq te án. ");
INSERT INTO pac_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Iki máh arnáq amớh inha ính ticuoi cannŏ́h táq dyôn inha, cóq inha táq muchứng ngki tưi dyôn nha-án. Táq iki, inha veng simớt simơi máh phep rit Yang Arbang-pilŏ́ng khoiq patáp na Môi-se, alứng parnai án tông na ticuoi tang ngcang án.” ");
INSERT INTO pac_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Cóq inha mot ngáh callống hep, co callống pơh alứng carna pưt pôq nga ntúq uih chéh níc-níc. Alứng clứng ticuoi rêh pôq tớq carna ngki. ");
INSERT INTO pac_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma ngáh callống hep alứng carna arức ngki pôq nga ntúq tumống. Ma biq náq ticuoi tumúh carna ngki.” ");
INSERT INTO pac_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cóq inha me dyôn a-ŏ, dáh lơ bôn ticuoi táq náh-nnan tang ngcang Yang Arbang-pilŏ́ng tớq nga inha. Rớp nha-án la arớq pannán cưu, ma mít cannính nha-án la arớq acho cruong pla lư. ");
INSERT INTO pac_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Têq inha acớl, tớq inha hôm máh arnáq nha-án táq. Tôm tangháng carbớuq calang lớiq nai cơt culái nho. Alứng tôm tangháng tarrieih lớiq nai cơt culái tarúng. ");
INSERT INTO pac_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tôm along ŏ cơt culái ŏ, alứng along saq cơt culái saq. ");
INSERT INTO pac_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tôm along ŏ lớiq nai cơt culái saq, alứng tôm along saq lớiq nai cơt culái ŏ. ");
INSERT INTO pac_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tôm along mmo lớiq bôn culái ŏ, ngki ngai cớl, dyơ arpớt tớq uih. ");
INSERT INTO pac_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Muchứng ngki tưi, inha têq acớl ticuoi táq náh-nnan tang ngcang Yang Arbang-pilŏ́ng, tớq inha hôm máh arnáq nha-án táq.” ");
INSERT INTO pac_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tới cứp náq dŏq cư Ưlla ma têq mot tớq ntúq Yang Arbang-pilŏ́ng sút tớq pilŏ́ng. Ma nưm nha-án ndon táq veng cannính A-ám cư tớq pilŏ́ng táp têq mot. ");
INSERT INTO pac_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tớq ingái ngki, bôn a-ưi ticuoi tông cư idô: ‘Ưlla ơi! Ưlla ơi! Nhơ te nốh inha he cato parnai ŏ te Yang Arbang-pilŏ́ng. Nhơ te nốh inha he chuih angốh yang saq alứng táq a-ưi arnáq sileh.’ ");
INSERT INTO pac_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma cư ính ôi nha-án idô: ‘Cư lớiq chom inha. Inha tôi yông te cư. Inha la ticuoi táq arnáq saq.’” ");
INSERT INTO pac_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Iki, ticuoi mmo cammáng alứng peh parnai cư, ticuoi ngki la arớq ticuoi tubáiq pitứng dúng tớq mpien búl cantar. ");
INSERT INTO pac_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tớq bo chớn, dơq carlúh bóh, alứng cuyiel arpuq hớp, dúng ngki lớiq dứm, co ticuoi pitứng dúng ngki tớq mpien búl. ");
INSERT INTO pac_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ticuoi mmo cammáng parnai cư, ma án lớiq peh, án la arớq ticuoi achơ pitứng dúng tớq chuah. ");
INSERT INTO pac_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tớq bo chớn, dơq carlúh bóh, alứng cuyiel arpuq hớp, dúng ngki sruq alứng arlóh nhéq!” ");
INSERT INTO pac_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cua Yê-su tông máh parnai ngki, máh ticuoi clứng át paniar án, sáng dut lư te ngê án cato, ");
INSERT INTO pac_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","co án cato arớq ticuoi bôn chức lư, ma tới arớq thới sái rit báq cato. ");
INSERT INTO pac_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tư Yê-su siar te cóh, bôn clứng ticuoi veng tatun pa crŏ́ng án. ");
INSERT INTO pac_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bôn munáq conh a-ái bŏ́q tớq nga Yê-su alứng chóh tarcol chứng mát án, tông idô: “Ưlla ơi! Khán Ưlla ính, Ưlla têq táq dyôn cư cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yê-su capơiq ticuoi a-ái ngki, alứng tông idô: “Cư ính! Dyôn mái cơt bánh.” Ndóng ngki táp ticuoi a-ái bŏ́q cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dyơ Yê-su patáp án idô: “Êq táq-ntêr dyôn ticuoi cannŏ́h chom te arnáq ndô. Ma cóq mái pôq apáh cháq mái dyôn ticuoi teng rit sang Yang Arbang-pilŏ́ng me. Dyơ cóq mái dông mŏp sang dyôn Yang Arbang-pilŏ́ng máh nốh ndon Môi-se khoiq patáp te inớh. Ndô la tíc mái apáh dyôn ticuoi cannŏ́h chom mái khoiq cơt bánh dyơ.” ");
INSERT INTO pac_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ndóng Yê-su mot tớq vel Cabê-na-um, bôn munáq ticuoi Rô-ma, án sút mui culám líng tớq nga Yê-su, alứng seq idô: ");
INSERT INTO pac_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ưlla ơi! Munáq prái tarráih na cư a-ái cớng ráh-ariaq lư.” ");
INSERT INTO pac_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yê-su ôi án idô: “Cư lư pôq táq dyôn án cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma ticuoi sút líng ngki tông idô: “Ưlla ơi, lớiq piaiq dyôn Ưlla mot tớq dúng cư. Ma cư seq Ưlla tông dyôn án cơt bánh sớng la piaiq dyơ. ");
INSERT INTO pac_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Cư bôn ticuoi ndon sút cư, alứng cư cơt sút ticuoi cannŏ́h tưi. Khán cư yua ticuoi ndô: ‘Pôq!’ án lư pôq. Khán cư yua ticuoi ngki: ‘Tớq nga tudô!’ án lư tớq. Khán cư yua ticuoi táq arnáq cư: ‘Táq idô!’ án lư táq.” ");
INSERT INTO pac_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ndóng Yê-su sáng parnai ngki, án sáng dut lư. Dyơ án tông ada máh ticuoi át paniar án idô: “Cư tông inha arlớih lư, cư lớiq nai hôm nnáu te ticuoi Isa-ra-el ma tin arớq ticuoi ndô. ");
INSERT INTO pac_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Alứng cư tông inha idô tưi: Urớh bôn clứng ticuoi tớq te anga pandang ngốh alứng anga pandang pát. Nha-án bôn ticu cha tớq ntúq Yang Arbang-pilŏ́ng sút tớq pilŏ́ng munơi alứng A-praham, I-sac, nha Yacốp. ");
INSERT INTO pac_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma máh ticuoi Isa-ra-el ndon ngai dŏq ticuoi prái Yang Arbang-pilŏ́ng ma lớiq bôn tin, Yang Arbang-pilŏ́ng ính adúh nha-án nga ntúq ngiau, la ntúq nhiem cucloiq cucling, alứng caltưat kineng tabang co sáng dieiq arức lư.” ");
INSERT INTO pac_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Cua ngki, Yê-su tông ticuoi sút líng ngki idô: “Mái chô nga dúng. Máh callong mái tin, lư mái bôn.” Ndóng ngki táp prái tarráih ticuoi sút líng ngki cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ndóng Yê-su mot tớq dúng Phi-er, án hôm cuya-cán Phi-er bíq tuor co a-ái atóq cháq. ");
INSERT INTO pac_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Án capơiq tớq cháq ayáq ngki, dyơ a-ái atóq cháq cơt pít táp. Ayáq ngki têq yôr alứng angốh tanna dyôn án cha. ");
INSERT INTO pac_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tớq ibư ngai dông clứng ticuoi bôn yang saq piyúh nga Yê-su. Yê-su chuih angốh yang saq na parnai án. Alứng án táq bánh cứp náq ticuoi ndon bôn a-ái cannŏ́h hơ. ");
INSERT INTO pac_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Án táq iki la dyôn cơt tarvớiq simớt parnai Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông idô: “Án chiuq tanhir arnáq dieiq arức tang he, alứng án ial dông nhéq máh nốh he a-ái.” ");
INSERT INTO pac_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tớq Yê-su hôm clứng ticuoi át paniar án, dyơ án yua top rian te án padyang án pa dyang atóh dơq clóng. ");
INSERT INTO pac_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bôn munáq thới sái rit tớq nga án alứng tông idô: “Thới ơi! Tumo thới pôq, cư ính veng tapun thới tuki tưi.” ");
INSERT INTO pac_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Yê-su ôi án idô: “Ayŏ́ng bôn cưp, achếq bôn sáp, ma Acái Yang Cơt Ticuoi lớiq bôn ntúq dyôn án bíq.” ");
INSERT INTO pac_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bôn munáq loi ndon rian te án, tông idô: “Ưlla ơi! Dyôn a-ám cư cuchet avai, tớq cua cư tứp án, cư lư veng tapun Ưlla.” ");
INSERT INTO pac_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma Yê-su ôi án idô: “Mái veng tapun cư sớng. Dŏq ticuoi ndon lớiq tin cư, chứm chiam ticuoi cannŏ́h ndon lớiq tin cư.” ");
INSERT INTO pac_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yê-su sớr tớq tuoc, dyơ top rian te án pôq alứng án tưi. ");
INSERT INTO pac_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Vít ngki ticớr bôn arpuq hớp lư, táq dyôn dơq lampóh kichíh tớq tuoc; dyơ tuoc tumán ính trim. Ma ndóng ngki Yê-su bíq. ");
INSERT INTO pac_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Top rian te Yê-su pôq pasớt án, alứng tông idô: “Ưlla ơi! Choi bơ! He tumán ính cuchet dyơ!” ");
INSERT INTO pac_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yê-su ôi nha-án idô: “Imo inha adáh? Imo inha tin biq lư?” Dyơ Yê-su yôr tayứng dyŏq cuyiel alứng dơq lampóh. Iki dơq alứng cuyiel tangít táp. ");
INSERT INTO pac_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cứp náq ticuoi sáng dut lư, alứng tông idô: “Imo cuyiel arpuq alứng dơq lampóh ma cammáng ticuoi ndô?” ");
INSERT INTO pac_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tư Yê-su tớq pa dyáng atóh dơq clóng ngki, án mot tớq cruong Yê-rasê. Án tumúh bar náq ticuoi bôn máh yang saq piyúh chón ngốh te carlom cumuiq. Nha-án crêng lư; lớiq bôn ngai dáh pôq pha ntúq nha-án át. ");
INSERT INTO pac_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ndóng nha-án hôm Yê-su, nha-án hiar yứng lư idô: “Ơ Acái Yang Arbang-pilŏ́ng ơi! Amớh inha ính táq ada he? Iyốh tớq ngư he cóq chiuq toiq bap. Ma imo inha ính táq dyôn he chiuq toiq bap hoi-ngki?” ");
INSERT INTO pac_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tumán ntúq ngki bôn mui cantóh alic át suo cha. ");
INSERT INTO pac_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yang saq ngki cucúh seq te Yê-su idô: “Khán inha chuih angốh he, he seq inha dyôn he mot tớq cantóh alic ngki.” ");
INSERT INTO pac_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yê-su yua máh yang saq ngki idô: “Inha pôq táp!” Dyơ yang saq ngốh táp te cháq ticuoi ngki alứng mot tớq cantóh alic loi. Dyơ cantóh alic ngki lúh chái lư na acáng alứng páh-apŏ́ng nga dơq clóng, dyơ tumic cuchet nhéq. ");
INSERT INTO pac_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Máh ticuoi bán alic lúh chô nga vel, alứng táq-ntêr cứp callong te bar náq ndon yang saq piyúh dyôn ngai chom tưi. ");
INSERT INTO pac_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dyơ cứp náq ticuoi tớq vel ngốh te vel, ính tumúh Yê-su. Tớq nha-án hôm Yê-su, nha-án seq án ngốh te cruong nha-án. ");
INSERT INTO pac_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yê-su sớr lieh tớq tuoc. Dyơ án dyang lieh pa dyáng atóh dơq clóng, alứng mot tớq vel án bôm. ");
INSERT INTO pac_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bôn máh ticuoi conh dông munáq a-ái cớng nga án. Ticuoi ngki bíq tớq carrang. Án hôm mít nha-án tin lư. Iki án tông ada conh a-ái cớng idô: “Yớu ơi! Êq adáh amớh, luaih mái cư táh dyôn!” ");
INSERT INTO pac_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma ndóng ngki bôn thới sái rit át ngki tưi. Nha-án parngíh tớq mít idô: “Ticuoi ndô acraiq Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Yê-su khoiq chom nha-án parngíh iki. Dyơ án plốh nha-án idô: “Imo inha parngíh callong saq arớq iki tớq mít inha? ");
INSERT INTO pac_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Parnai mmo inha sáng ien hơn cư tông? Ien cư tông ticuoi a-ái cớng idô: ‘Luaih mái cư táh dyôn,’ lớiq la ‘Mái yôr tayứng, dyơ pôq.’ ");
INSERT INTO pac_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma hoi-ndô cư ính táq dyôn ticuoi a-ái ndô cơt bánh, dŏq inha chom arlớih lư, cư Acái Yang Cơt Ticuoi bôn chức tớq cúc cuteq ndô. Cư têq táh luaih ticuoi.” Cua ngki Yê-su tông ticuoi a-ái cớng idô: “Cư yua mái yôr tayứng! Ial dual carrang mái! Dyơ chô lieh nga dúng mái!” ");
INSERT INTO pac_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dyơ ticuoi a-ái ngki yôr tayứng alứng chô nga dúng án. ");
INSERT INTO pac_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ndóng ticuoi clứng hôm arnáq ngki nha-án sáng laq lư, dyơ nha-án ayô Yang Arbang-pilŏ́ng co án dyôn ticuoi bôn chức iki. ");
INSERT INTO pac_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Dyơ Yê-su ngốh te ntúq ngki. Ndóng án pôq, án hôm munáq conh, nốh Mathie, ticu táq arnáq tớq dúng ngai ial práq thêq. Án yua Mathie idô: “Mái veng tapun cư!” Dyơ Mathie yôr tayứng alứng veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cua ngki Yê-su ticu cha tớq dúng Mathie. Át ngki bôn clứng ticuoi tớq cha munơi alứng Yê-su nha top rian te án. Nha-án la ticuoi ial práq thêq alứng máh ticuoi luaih cannŏ́h hơ. ");
INSERT INTO pac_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bôn ticuoi te top Pha-rasi hôm arnáq ngki, dyơ nha-án plốh top rian te Yê-su idô: “Imo thới inha cha munơi alứng ticuoi ial práq thêq nha ticuoi luaih cannŏ́h?” ");
INSERT INTO pac_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tư Yê-su sáng nha-án tông iki, án ôi nha-án idô: “Ticuoi bánh ŏ, lớiq bôn seq ngai palai. Ma nưm ticuoi a-ái sớng seq ngai palai. ");
INSERT INTO pac_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tớq tám uráq Yang Arbang-pilŏ́ng te inớh khoiq tông idô: ‘Cư ính inha munáq sruiq táq munáq hơn te cư ính inha dông máh pannán mŏp sang a cư.’ Cóq inha pôq rian dyôn chom arlớih te parnai ngki. Cư lớiq bôn tớq nga tudô dŏq arô ticuoi ndon ngin nha-án tinớng ŏ, ma cư tớq nga tudô dŏq arô ticuoi ndon chom nha-án bôn luaih.” ");
INSERT INTO pac_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Cua ngki top rian te Yon tớq nga Yê-su, alứng nha-án plốh idô: “Imo top he alứng top Pha-rasi báq ót tanna dŏq parngíh te ngê Yang Arbang-pilŏ́ng, ma top rian te thới lớiq bôn táq muchứng he?” ");
INSERT INTO pac_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yê-su ôi nha-án idô: “Khán bôn conh ial campái, ndóng yớu án pôq arsuoi alứng án, nha-án sáng bui. Ma tư ngai ial dông án, iki yớu án ót tanna dŏq ayư lieh án. ");
INSERT INTO pac_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Lớiq bôn ngai cupêl prới tamme tớq tampớc khoiq anhoh. Khán ngai táq iki, campêl ngki cucrónh alứng tiyot prới anhoh. Dyơ tarhaq cơt pơh lư loi. ");
INSERT INTO pac_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Alứng lớiq bôn ngai cleng sieu tamme tớq aluoi ngcár khoiq tieq. Khán ngai táq iki, sieu lư táq dyôn aluoi ngcár cơt pôih alứng pidŏ́h. Dyơ aluoi ngcár alứng sieu cơt pít nhéq. Ma sieu tamme, cóq cleng tớq aluoi ngcár tamme. Iki aluoi ngcár alứng sieu lớiq cơt pít.” ");
INSERT INTO pac_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ndóng Yê-su tông nha-án iki, bôn munáq conh ndon sút mui dúng rum ticuoi Isa-ra-el tớq nga Yê-su. Án chóh tarcol chứng mát Yê-su, alứng tông idô: “Acái cán cư khoiq cuchet dyơ. Cư seq thới tớq capơiq tớq cháq án, dyơ án lư têq bôn tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iki Yê-su yôr tayứng pôq munơi alứng conh ngki, bôn díh top rian te án hơ pôq. ");
INSERT INTO pac_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ndóng ngki bôn munáq cán át tớq pa crŏ́ng Yê-su. Cán ngki a-ái dyứp nnai khoiq mui chít la bar cumo, aham án lớiq nai dyớt. Iki án capơiq tôiq mbaiq au thor Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Án parngíh idô: “Khán cư bôn capơiq biq tampớc Yê-su, cư lư cơt bánh táp.” ");
INSERT INTO pac_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yê-su píh tilêq me nga crŏ́ng. Tư án hôm cán ngki, án tông idô: “Mun ơi, mái êq adáh. Co mái tin, cháq mái cơt bánh.” Ndóng ngki táp cán ngki cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cua ngki Yê-su mot tớq dúng ticuoi sút dúng rum ticuoi Isa-ra-el. Án hôm máh ticuoi rurưp alứng máh ticuoi nhiem cucloiq yứng lư. ");
INSERT INTO pac_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Án tông nha-án idô: “Nhéq náq inha ngốh táp te dúng ndô! Cán ndô lớiq bôn cuchet; án bíq sớng!” Ma máh ticuoi ngki cacháng ayê Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tớq máh ticuoi ngki ngốh nhéq te dúng, Yê-su mot tớq callúng mun ndon khoiq cuchet. Dyơ án tec ayôr mun ngki. Iki mun ngki yôr tayứng. ");
INSERT INTO pac_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dyơ arnáq ndô cơt parhanh mưt-mư cứp ntúq tớq vúng ngki. ");
INSERT INTO pac_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tư Yê-su ngốh te ntúq ngki, bôn bar náq ticuoi sot mát veng lamloi án. Nha-án tubau yứng lư idô: “Ưlla ơi! Ưlla ndon te tŏ́ng toiq puo Davit! Seq Ưlla sruiq táq he hơ!” ");
INSERT INTO pac_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ndóng Yê-su mot tớq dúng, bar náq ticuoi sot ngki tớq nga án. Dyơ án plốh nha-án idô: “Inha lư tin cư têq táq arnáq ndô lớiq?” Nha-án bar náq ôi idô: “He lư tin, Ưlla ơi!” ");
INSERT INTO pac_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dyơ Yê-su capơiq tớq mát nha-án, alứng án tông idô: “Dyôn cơt arớq inha tin!” ");
INSERT INTO pac_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iki mát nha-án cơt plang. Ma Yê-su patáp nha-án cáng lư idô: “Inha êq táq-ntêr dyôn ticuoi cannŏ́h chom te arnáq ndô!” ");
INSERT INTO pac_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma vít nha-án ngốh te dúng ngki, nha-án táq-ntêr cứp ntúq tớq vúng ngki te arnáq Yê-su khoiq táq. ");
INSERT INTO pac_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ndóng bar náq ticuoi sot ngốh te ntúq ngki, bôn ticuoi cannŏ́h dông nga Yê-su munáq ticuoi lúng. Án cơt lúng co bôn yang saq táq án. ");
INSERT INTO pac_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cua Yê-su chuih angốh yang saq te ticuoi lúng, dyơ ticuoi lúng ngki têq tacang. Nhéq máh ticuoi sáng dut lư alứng nha-án tông idô: “He lớiq nai hôm arnáq sileh arớq ndô tớq nga cruong Isa-ra-el!” ");
INSERT INTO pac_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma top Pha-rasi tông idô: “Yang ndon sút nhéq tưh yang saq táp dyôn ticuoi ndô bôn chức têq chuih angốh yang saq.” ");
INSERT INTO pac_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yê-su pôq alang máh vel pưt vel két, alứng án cato tớq máh dúng rum ticuoi Isa-ra-el. Án cato parnai ŏ te Yang Arbang-pilŏ́ng cơt sút, alứng án táq bánh cứp nốh a-ái. ");
INSERT INTO pac_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tớq án hôm ticuoi clứng, mít án sáng sruiq táq ada máh ticuoi ngki, co nha-án sáng dieiq arức alứng át parsáng parsaiq arớq pannán cưu ớq ticuoi kiaq me. ");
INSERT INTO pac_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iki Yê-su tông top rian te án idô: “Sro tớq pidái pơh khoiq dom dyơ, ma bôn biq náq ticuoi pôq sot sro ngki. ");
INSERT INTO pac_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cóq inha cớu seq te Ưlla pidái, dyôn án yua a-ưi náq ticuoi pôq sot sro ngki.” ");
INSERT INTO pac_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yê-su arô top mui chít la bar náq rian te án tớq nga án. Án dyôn nha-án bôn chức têq chuih angốh yang saq, alứng têq táq bánh ticuoi te cứp nốh a-ái. ");
INSERT INTO pac_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nốh top mui chít la bar náq dyưng ati Yê-su la idô: Tôm lư la Si-môn ndon ngai dŏq Phi-er hơ, alứng Anrê a-em Si-môn. Alứng bôn bar náq em ai, nốh Yacơ nha Yon, acái conh Sê-badê. ");
INSERT INTO pac_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Tatun loi la Phi-lip, Batê-lami, Thô-mat, Mathie ndon ial práq thêq, Yacơ acái conh Al-phê, alứng Thadê. ");
INSERT INTO pac_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Alứng bôn Si-môn Sê-lôt nha Yuda I-cari-ôt ndon culieu Yê-su dyôn ngai cachet. ");
INSERT INTO pac_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yê-su yua mui chít la bar náq ndô pôq táq arnáq án, alứng án patáp nha-án idô: “Inha êq pôq nga cruong ticuoi tới ticuoi Isa-ra-el, alứng êq mot tớq vel ticuoi Sa-mari. ");
INSERT INTO pac_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma inha pôq nưm nga ticuoi Isa-ra-el sớng; co nha-án la arớq pannán cưu khoiq clu carna. ");
INSERT INTO pac_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Inha pôq cato idô: ‘Khoiq tumán dyơ Yang Arbang-pilŏ́ng cơt sút!’ ");
INSERT INTO pac_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cóq inha táq bánh máh ticuoi a-ái, alứng choi máh ticuoi ndon khoiq cuchet dyôn tumống lieh. Cóq inha táq bánh ticuoi a-ái bŏ́q, alứng chuih angốh yang saq te cháq ticuoi. Inha khoiq ráp dyơ máh nốh ndon cư choi mat. Iki, cóq inha choi mat ticuoi cannŏ́h tưi. ");
INSERT INTO pac_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Inha êq dông dyeng, práq, lớiq la apán kem tớq tái inha. ");
INSERT INTO pac_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Êq báq tui arớq ticuoi suseq. Êq dông au cannŏ́h, lớiq la murúp cơp cannŏ́h, lớiq la mui ntráih tarlông cannŏ́h. Ticuoi mmo táq arnáq choi ticuoi cannŏ́h, cóq ticuoi cannŏ́h choi lieh ticuoi ngki dyôn bôn crơng tanna. ");
INSERT INTO pac_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ndóng inha tớq nga vel pưt lớiq la vel két, cóq inha mot tớq vel ngki, alứng suo ticuoi ndon ráp pasôl ŏ inha. Dyơ inha át tớq dúng ticuoi ngki tingôi ingái inha ngốh te vel ngki. ");
INSERT INTO pac_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ndóng inha mot tớq dúng, cóq inha tông ada máh ticuoi tớq abŏ́h ngki idô: ‘Seq dyôn inha át bánh suanh ien ŏ.’ ");
INSERT INTO pac_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Khán ticuoi tớq abŏ́h ngki ráp pasôl ŏ inha, nha-án lư bôn ráp callong bánh suanh ien ŏ. Ma khán nha-án lớiq ráp pasôl ŏ inha, callong inha tông ngki chô lieh nga inha. ");
INSERT INTO pac_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Khán bôn mui abŏ́h lớiq la mui vel ma lớiq ráp pasôl ŏ inha, alứng lớiq ính cammáng parnai inha cato, ndóng inha ngốh te ntúq ngki, cóq inha tangkhír cuteq mbúi te dyưng, táq tíc ticuoi tớq ntúq ngki lớiq ráp inha. ");
INSERT INTO pac_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cư tông inha arlớih lư, tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, án táq tôt nha-án ndon át tớq vel ngki dyôn tumúh dieiq arức hơn te ticuoi tớq vel Sadôm alứng vel Camô-rơ te inớh.” ");
INSERT INTO pac_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ndô! Cư yua inha pôq arớq pannán cưu pôq pandi máh acho cruong. Iki, cóq inha hôi tubáiq arớq cusánh, alứng khun arớq achếq cacu. ");
INSERT INTO pac_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cóq inha me a-ŏ, co bôn ticuoi ính cŏp inha, dyơ dông inha tớq nga ticuoi sút dúng rum, alứng nha-án tính inha tớq ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Co inha veng tapun cư, iki ngai dông inha tớq nga ticuoi sút alứng nga ticuoi puo. Táq iki dŏq inha bôn cato ngê cư chứng mát nha-án, alứng chứng mát ticuoi tới ticuoi Isa-ra-el hơ. ");
INSERT INTO pac_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tớq ngai mŏp inha nga ticuoi sút, inha êq rớu-ri nsuoi te inha ính tông. Ndóng ngki inha lư bôn ráp parnai inha ính tông. ");
INSERT INTO pac_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Parnai ngki tới tớq te inha bôm, ma tớq te Arvai A-ám inha tớq pilŏ́ng. Án táp tông dyôn inha chom parnai ngki. ");
INSERT INTO pac_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Em ai ính cŏp tartuoq em ai, nha mŏp dyôn ngai cachet, alứng a-ám táq muchứng ngki tưi ada acái án. Acái acon uan ada a-i a-ám, alứng nha-án mŏp a-i a-ám dyôn ngai cachet. ");
INSERT INTO pac_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Chô-mát nhéq tưh ticuoi lư a-ính inha, la co tian inha veng ngê cư. Ma ticuoi mmo rap tanhir tingôi sút pang tumống án, Yang Arbang-pilŏ́ng lư choi tamống án. ");
INSERT INTO pac_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tớq ngai táq dieiq arức inha tớq mui vel, ngki cóq inha lúh nga vel cannŏ́h. Cư tông inha arlớih lư, inha iyốh táq cua máh arnáq inha ính táq tớq cứp vel tớq cruong Isa-ra-el nsuoi te cư Acái Yang Cơt Ticuoi tớq lieh nga cúc cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ticuoi rian lớiq bôn pưt hơn te thới. Alứng ticuoi sol lớiq bôn pưt hơn te ticuoi ưlla. ");
INSERT INTO pac_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iki, ticuoi rian cóq sáng bui cannính khán án cơt muchứng thới án. Alứng ticuoi sol cóq sáng bui cannính khán án cơt muchứng ưlla án tưi. Khán ngai acraiq ticuoi sút tớq abŏ́h tông án la Bên-sabul, lư ntáng hơn te ngki loi ngai acraiq máh ticuoi tớq abŏ́h án.” ");
INSERT INTO pac_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Iki inha êq adáh ticuoi. Máh nốh ngai pul catốq hoi-ngki, chô-mát máh nốh ngki ngai lớiq têq pul catốq nnáng. Alứng arnáq amớh ngai táq clôp hoi-ngki, chô-mát ngai lớiq têq táq clôp nnáng. ");
INSERT INTO pac_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Máh parnai amớh cư khoiq cato nưm dyôn inha hoi-ndô, cóq inha cato lieh parnai ngki dyôn cứp náq ticuoi chom tưi. Ndô la arớq cư cato inha tớq ntúq ngiau, ma inha cóq cato lieh parnai ngki tớq ntúq ang. ");
INSERT INTO pac_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Inha êq adáh ticuoi ndon têq cachet nưm cháq inha, ma arvai inha, nha-án lớiq têq cachet. Ma cóq inha adáh nưm Yang Arbang-pilŏ́ng sớng, co Yang Arbang-pilŏ́ng têq cachet cháq inha, alứng arvai inha, díh têq án apŏ́ng tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Inha báq plới bar lám achếq téc-téc, ma tarnáp án nưm mui nhac sớng. Ma lớiq bôn mui lám te achếq téc-téc ngki cuchet, khán A-ám inha tớq pilŏ́ng lớiq dyôn. ");
INSERT INTO pac_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Cứp ntráih sóc tớq plô inha, Yang Arbang-pilŏ́ng khoiq ngiaih nhéq dyơ. ");
INSERT INTO pac_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iki inha êq adáh amớh, co Yang Arbang-pilŏ́ng ayáu tarngứh inha hơn te a-ưi lám achếq téc-téc. ");
INSERT INTO pac_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ticuoi mmo ngin án át mui mít alứng cư chứng mát ticuoi cannŏ́h, muchứng ngki tưi cư lư ngin lieh án chứng mát A-ám cư tớq pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma ticuoi mmo calôih cư chứng mát ticuoi cannŏ́h, muchứng ngki tưi cư calôih lieh án chứng mát A-ám cư tớq pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Inha êq parngíh cư tớq nga tudô dông atớq callong ien ŏ nga cứp náq ticuoi tớq cuteq ndô. Cư lớiq bôn tớq dông callong ien ŏ, ma cư tớq dŏq dông pla dau. ");
INSERT INTO pac_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cư tớq dŏq táq dyôn munáq lớiq sŏ́ng ada munáq. Acái conh ính chíl a-ám. Acái cán ính chíl a-i. Tarmôt ính chíl cuya-cán. ");
INSERT INTO pac_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Díh ticuoi át mui abŏ́h munáq uan ada munáq. ");
INSERT INTO pac_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ticuoi mmo amoih a-i a-ám án hơn te amoih cư, án ngki lớiq piaiq cơt ticuoi cư. Alứng ticuoi mmo amoih acái conh lớiq la acái cán án hơn te amoih cư, án ngki lớiq piaiq cơt ticuoi cư. ");
INSERT INTO pac_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ticuoi mmo lớiq ial dual bôm along calláng án alứng veng tapun cư, án ngki lớiq piaiq cơt ticuoi cư. ");
INSERT INTO pac_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ticuoi mmo ayáu tarngứh án, tarngứh án lư cơt pít. Ma ticuoi mmo chiuq pít tarngứh án, co tian án veng tapun cư, tarngứh án lư lớiq nai pít.” ");
INSERT INTO pac_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ticuoi mmo pasôl ŏ inha la arớq ticuoi ngki pasôl ŏ cư tưi. Alứng ticuoi mmo pasôl ŏ cư, la arớq ticuoi ngki pasôl ŏ án ndon yua cư tớq tưi. ");
INSERT INTO pac_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ticuoi mmo pasôl ŏ ticuoi tang ngcang Yang Arbang-pilŏ́ng co án la tang ngcang Yang Arbang-pilŏ́ng, án lư bôn cống muchứng ticuoi tang ngcang Yang Arbang-pilŏ́ng tưi. Alứng ticuoi mmo pasôl ŏ ticuoi tinớng ŏ co án la ticuoi tinớng ŏ, án lư bôn cống muchứng ticuoi tinớng ŏ tưi. ");
INSERT INTO pac_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Khán ticuoi mmo dyôn mui choc dơq nga munáq ticuoi két tớq top rian te cư co án la ticuoi rian te cư, iki án lư bôn cống te arnáq án táq.” ");
INSERT INTO pac_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cua Yê-su patáp top mui chít la bar náq rian te án te máh callong ngki; dyơ án ngốh te ntúq ngki, alứng pôq cato tớq máh vel át paniar ngki loi. ");
INSERT INTO pac_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ndóng ngki Yon yôl át tớq coq tôt. Án sáng ngai táq-ntêr te arnáq Crit táq. Iki án yua ticuoi te top rian te án tớq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Án yua nha-án plốh Yê-su idô: “Thới ơi! Lư ma lớiq, thới la munáq ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống nhéq tưh ticuoi? Lớiq la cóq he ngcong ticuoi cannŏ́h loi?” ");
INSERT INTO pac_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yê-su ôi nha-án idô: “Inha chô tông Yon te máh arnáq inha khoiq sáng alứng khoiq hôm. ");
INSERT INTO pac_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ticuoi sot cơt plang. Ticuoi dyuat têq pupôq. Ticuoi a-ái bŏ́q cơt bánh. Ticuoi túng têq sáng. Ticuoi khoiq cuchet bôn tumống lieh. Alứng máh ticuoi kidit bôn sáng tưi parnai ŏ te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bún lư ticuoi mmo lớiq sáng lô co án tin cư.” ");
INSERT INTO pac_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tớq vít top rian te Yon chô lieh nga Yon, dyơ Yê-su táq-ntêr te Yon dyôn ticuoi clứng ngki chom. Alứng án plốh nha-án idô: “Ndóng inha pôq tumúh Yon tớq ntúq aih, amớh inha ính hôm tớq ntúq ngki? Inha ính me cuyiel phớt sác pitứng pitốq lớiq? ");
INSERT INTO pac_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Khán lớiq iki, amớh inha ính hôm? Inha ính hôm munáq sứp au dêu ŏ lớiq? Ticuoi sứp au dêu ŏ ngki át tớq dúng puo. ");
INSERT INTO pac_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma amớh inha ính hôm tớq ntúq ngki? Inha ính hôm ticuoi tang ngcang Yang Arbang-pilŏ́ng lớiq? Cư tông inha arlớih lư, Yon la ticuoi tang ngcang Yang Arbang-pilŏ́ng tưi, ma án bôn chức pưt hơn te máh ticuoi cannŏ́h ndon tang ngcang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ticuoi tang ngcang Yang khoiq taran acớiq te Yon tớq tám uráq Yang Arbang-pilŏ́ng te inớh, idô: ‘Cư Yang Arbang-pilŏ́ng yua ticuoi tampeng cư pôq nsuoi, dŏq thuan carna dyôn mái.’ ");
INSERT INTO pac_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cư tông inha arlớih lư, nhéq tưh ticuoi ndon cán carnian tớq cúc cuteq ndô, lớiq bôn nnáu pưt hơn te Yon ndon báq táq tíc na dơq. Ma cư tông inha idô tưi: Ticuoi mmo bôn chức két hơn te cannŏ́h tớq top Yang Arbang-pilŏ́ng sút, ticuoi ngki lư bôn chức pưt hơn te chức Yon. ");
INSERT INTO pac_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Te ingái Yon táq tíc na dơq tingôi hoi-ndô, bôn ticuoi cato te Yang Arbang-pilŏ́ng cơt sút. Alứng bôn a-ưi ticuoi ndon tin khớm tél-sél ính mot choi top Yang Arbang-pilŏ́ng sút dyôn cơt rêng asớr. ");
INSERT INTO pac_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yang Arbang-pilŏ́ng khoiq tông acớiq te án cơt sút na ticuoi tang ngcang án te inớh, alứng na phep rit Môi-se. Án tông na nha-án tingôi tớq pang Yon. ");
INSERT INTO pac_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Khán inha tin parnai nha-án tông te Ê-li te inớh, iki inha têq chom arlớih Yon la muchứng Ê-li tưi. ");
INSERT INTO pac_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng. ");
INSERT INTO pac_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Máh ticuoi tớq pang ndô la arớq amớh? Máh ticuoi tớq pang ndô la arớq ngai-acái parlơ tớq ngcưm. Mui top ngai-acái arô yớu nha-án ");
INSERT INTO pac_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","alứng tông idô: ‘He khoiq plŏ́ng tirel alứng parlơ táq aryoc. Ma inha lớiq bôn mot ayưn nha pon liauq alứng he! Alứng he parlơ tallêng ticuoi cuchet, ma inha lớiq sŏ́ng mot nhiem cucloiq alứng he!’ ");
INSERT INTO pac_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yon tớq nga ndô, án lớiq bôn ngoiq cha arớq ticuoi cannŏ́h, ma án cha nưm aliem alứng ngoiq nưm dơq canyiel. Iki ngai tông án bôn yang saq piyúh. ");
INSERT INTO pac_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma cư Acái Yang Cơt Ticuoi tớq, cư ngoiq cha muchứng ticuoi cannŏ́h tưi. Iki ngai tông te cư idô: ‘Ngki! Án ham lư ngoiq alứng án cha tham! Díh án cơt yớu alứng ticuoi ial práq thêq nha ticuoi luaih cannŏ́h!’ Ma khán ticuoi mmo lư tubáiq, urớh ngai chom án la lư tubáiq, co ngai hôm máh arnáq án khoiq táq.” ");
INSERT INTO pac_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dyơ Yê-su tíq máh ticuoi tớq vel ndon án khoiq táq a-ưi arnáq sileh, co nha-án lớiq ính ngin luaih pien cơt mít tamme loi. ");
INSERT INTO pac_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Án tông ada nha-án idô: “Bap lư tớq nga inha ndon át tớq vel Côr-sín alứng vel Bet-sada! Khán cư táq arnáq sileh tớq vel Tirơ alứng vel Sadôn muchứng cư khoiq táq tớq vel inha, lư khoiq dưnh dyơ máh ticuoi tớq vel ngki ngin luaih pien cơt mít tamme loi. Alứng khoiq dưnh dyơ nha-án tớc tampớc tallêng alứng pức abŏ́h tớq cháq nha-án, táq tíc nha-án sáng anguaq co nha-án bôn luaih. ");
INSERT INTO pac_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ma cư tông inha, tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, ingái ngki án sáng sruiq táq ada ticuoi tớq vel Tirơ alứng vel Sadôn hơn te án sáng sruiq táq ada inha. ");
INSERT INTO pac_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Inha ndon át tớq vel Cabê-na-um ơi! Inha parngíh inha têq sớr bôm nga pilŏ́ng lớiq? Urớh Yang Arbang-pilŏ́ng ính apŏ́ng inha tớq ntúq uih chéh níc-níc. Khán cư táq arnáq sileh tớq vel Sadôm muchứng cư khoiq táq tớq vel inha, vel Sadôm ngki lư yôl níc tingôi hoi-ndô. ");
INSERT INTO pac_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma cư tông inha idô: Tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, ingái ngki án sáng sruiq táq ada ticuoi tớq vel Sadôm hơn te án sáng sruiq táq ada inha.” ");
INSERT INTO pac_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ndóng ngki Yê-su cớu idô: “A-ám ơi! A-ám la Ưlla pilŏ́ng alứng cuteq! Cư si-ơn mái, co mái khoiq apáh ngê mái dyôn ticuoi arớq ngai-acái ndon iyốh rian amớh bôn chom tưi. Ma mái catốq ngê ndô te máh ticuoi tubáiq ndon khoiq rian a-ưi. ");
INSERT INTO pac_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Lư piaiq, A-ám ơi! Cư ayô mái, co mái sáng bui cannính táq iki. ");
INSERT INTO pac_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cứp nốh ndon A-ám cư khoiq mŏp dyôn cư. Lớiq bôn ngai chom Acái Yang Arbang-pilŏ́ng, ma nưm A-ám án táp chom án. Alứng lớiq bôn ngai chom A-ám tớq pilŏ́ng, ma nưm Acái táp chom A-ám. Ticuoi mmo Acái Yang Arbang-pilŏ́ng rêh, án lư apáh dyôn ticuoi ngki chom te A-ám án tớq pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cua Yê-su cớu iki, dyơ án tông idô: “Nhéq máh inha ndon aleq aláh alứng dual crơng ntáng ơi! Inha rôp nga cư! Cư ính táq dyôn inha cơt pít aleq aláh. ");
INSERT INTO pac_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cư bôn mít khun alứng lớiq suo ính ngai ayô cư. Cóq inha ial dual lieq na cư alứng rian te cư. Iki arvai inha bôn át ien ŏ níc. ");
INSERT INTO pac_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Co lieq cư la ien, alứng pardual cư la ng-hiel.” ");
INSERT INTO pac_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Bôn mui Ingái Angô, Yê-su alứng top rian te án mot tớq pidái sro bali. Ndóng nha-án mot tớq pidái, top rian te án sáng pinhaih lư. Iki ntơnh nha-án pôq ntơnh nha-án carớt sro bali alứng sréh cha. ");
INSERT INTO pac_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tớq ticuoi Pha-rasi hôm iki, nha-án tông ada Yê-su idô: “Ngki! Top rian te thới táq lớiq cơt rit rong tớq Ingái Angô.” ");
INSERT INTO pac_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yê-su ôi nha-án idô: “Imo arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng te puo Davit khoiq táq? Davit alứng top veng tapun án sáng pinhaih lư. ");
INSERT INTO pac_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iki Davit mot tớq dúng sang Yang Arbang-pilŏ́ng. Án alứng yớu án cha beng ngai dŏq chứng mát Yang Arbang-pilŏ́ng. Khán veng phep rit ticuoi Isa-ra-el, án alứng yớu án lớiq têq cha beng ngki. Co beng ngki nưm máh ticuoi teng rit sang sớng têq cha. ");
INSERT INTO pac_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Alứng arớq inha lớiq nai dŏc te phep rit Môi-se te máh ticuoi teng rit sang báq mot táq arnáq tớq Dúng Sang Pưt tớq Ingái Angô, ma nha-án lớiq bôn táq luaih. ");
INSERT INTO pac_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma cư tông inha idô: Át ntúq ndô, bôn munáq pưt hơn te Dúng Sang ngki. ");
INSERT INTO pac_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tớq tám uráq Yang Arbang-pilŏ́ng te inớh khoiq tông idô: ‘Cư ính inha munáq sruiq táq munáq hơn te cư ính inha dông máh pannán mŏp sang dyôn cư.’ Khán inha chom arlớih te parnai ngki, inha lớiq dáh tông nha-án bôn luaih khán nha-án lớiq bôn luaih. ");
INSERT INTO pac_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cư Acái Yang Cơt Ticuoi la Ưlla Ingái Angô.” ");
INSERT INTO pac_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yê-su pôq te ntúq ngki, dyơ án mot tớq dúng rum ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Át ngki bôn munáq ticuoi dyuat ati. Máh ticuoi tớq dúng rum plốh Yê-su idô: “Veng rit he, têq lớiq he táq bánh ticuoi a-ái tớq Ingái Angô?” Nha-án plốh iki, co suo callong luaih ính cauq Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yê-su ôi nha-án idô: “Khán munáq te inha bôn pannán cưu arbúc tớq prúng tớq Ingái Angô, án lư arơq cưu ngki te prúng, piaiq lớiq? ");
INSERT INTO pac_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yang Arbang-pilŏ́ng ayáu tarngứh ticuoi hơn te ayáu tarngứh pannán cưu. Co iki he munáq têq choi munáq tớq Ingái Angô.” ");
INSERT INTO pac_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dyơ Yê-su tông ticuoi dyuat ati idô: “Mái angốh ati mái!” Tư ticuoi dyuat angốh ati, ati án cơt bánh táp, cơt ŏ muchứng ati pa lớiq dyuat tưi. ");
INSERT INTO pac_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Máh ticuoi Pha-rasi ngốh te dúng rum ngki, dyơ nha-án tanghúng ính cachet Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tư Yê-su chom nha-án ính cachet án, iki án ngốh te ntúq ngki, ma bôn clứng ticuoi veng án. Alứng án táq bánh cứp náq ticuoi ndon bôn a-ái. ");
INSERT INTO pac_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Án patáp nha-án êq dyôn ticuoi cannŏ́h chom án la nnáu. ");
INSERT INTO pac_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Án patáp iki dŏq cơt tarvớiq simớt parnai Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng, khoiq tông te inớh idô: ");
INSERT INTO pac_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ndô la ticuoi táq arnáq cư, án ndon cư khoiq rêh. Cư amoih lư án, alứng mít cannính cư sáng bui lư alứng án. Cư dyôn án bôn Arvai cư. Urớh án pau callong tinớng tupứng nga máh ticuoi tớq cứp cruong. ");
INSERT INTO pac_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Án lớiq tarmien alứng lớiq tông yứng ada ngai. Alứng án lớiq táq-ntêr yứng tớq carna tớq vel. ");
INSERT INTO pac_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Máh ticuoi la arớq arŏ́ng khoiq liat tor-cor, ma án lớiq péq them; alứng nha-án arớq den tớu luliauq ính pát, ma án lớiq pupát them tingôi ingái callong tinớng tupứng te Yang Arbang-pilŏ́ng tớq. ");
INSERT INTO pac_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nhéq tưh ticuoi át ngcong án choi tamống nha-án.” ");
INSERT INTO pac_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Vít ngki ngai dông munáq conh ndon sot mát alứng lúng tớq nga Yê-su, co yang saq táq án. Yê-su táq dyôn mát án cơt plang, alứng táq dyôn ngcang án têq táq-ntêr. ");
INSERT INTO pac_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nhéq máh ticuoi sáng dut lư, dyơ nha-án plốh idô: “Án ndô la ticuoi te tŏ́ng toiq puo Davit ndon he ngcong lớiq?” ");
INSERT INTO pac_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma tư top Pha-rasi sáng ticuoi clứng táq-ntêr iki, nha-án tông idô: “Án ndô chuih angốh yang saq co yang Bên-sabul dyôn án bôn chức táq arnáq ngki. Yang Bên-sabul la yang ndon sút nhéq yang saq.” ");
INSERT INTO pac_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yê-su chom nha-án parngíh iki. Dyơ án tông ada nha-án idô: “Khán bôn mui cruong ma munáq tarchíl munáq, lớiq cơt nnáng cruong. Alứng khán mui vel lớiq la mui abŏ́h ma munáq tarchíl munáq, lớiq cơt nnáng vel, lớiq la abŏ́h. ");
INSERT INTO pac_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Khán top yang Satán ma chuih angốh top án bôm, la arớq nha-án tarchíl tartuoq. Iki lớiq têq cơt nnáng top. ");
INSERT INTO pac_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Inha tông cư chuih angốh yang saq co yang Bên-sabul dyôn cư bôn chức táq arnáq ngki. Ma khán máh ticuoi veng inha ma táq arnáq muchứng ngki tưi, inha lớiq tông nha-án bôn chức te yang Bên-sabul. Co iki nha-án táp ính tíq inha. ");
INSERT INTO pac_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma khán cư chuih angốh yang saq co nhơ Arvai Yang Arbang-pilŏ́ng dyôn cư táq, arnáq ngki apáh dyôn inha chom arlớih la Yang Arbang-pilŏ́ng cơt sút khoiq tớq nga inha dyơ. ");
INSERT INTO pac_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Khán ngai ính mot dúng ticuoi bánh rêng, alứng ính ial nhéq crơng án, cóq ngai chóq án avai, ki-náq têq ngai talóh dúng án, alứng ial máh crơng án. ");
INSERT INTO pac_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ticuoi mmo ma lớiq sŏ́ng át mui mít alứng cư, la arớq án chíl cư. Alứng ticuoi mmo ma lớiq choi ticuoi cannŏ́h dyôn veng ngê cư, la muchứng án catáng ticuoi cannŏ́h lớiq dyôn veng ngê cư. ");
INSERT INTO pac_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iki cư tông inha idô: Ticuoi mmo bôn luaih amớh, alứng ticuoi mmo acraiq nốh Yang Arbang-pilŏ́ng, nhéq nốh luaih ngki têq táh. Ma khán ticuoi mmo acraiq Arvai Yang Arbang-pilŏ́ng, Yang Arbang-pilŏ́ng lư lớiq nai táh luaih ngki. ");
INSERT INTO pac_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ticuoi mmo tông saq te cư Acái Yang Cơt Ticuoi, Yang Arbang-pilŏ́ng yôl têq táh luaih dyôn án. Ma khán ticuoi mmo tông saq te Arvai Yang Arbang-pilŏ́ng, Yang Arbang-pilŏ́ng lư lớiq nai táh luaih ngki, te pang ndô tingôi pang urớh.” ");
INSERT INTO pac_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yê-su tông loi idô: “Khán ính bôn culái ŏ, cóq bôn tôm along ŏ. Khán bôn tôm lớiq ŏ, culái la lớiq ŏ tưi. Khán inha hôm culái, ngki inha chom díh tôm. ");
INSERT INTO pac_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Inha la arớq cusánh bôn pih! Inha la ticuoi lới. Imo têq bôn parnai ŏ ngốh te ngcang inha? Ngê amớh bôn tớq mít cannính ticuoi, ngcang ticuoi táq-ntêr angốh ngê ngki. ");
INSERT INTO pac_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ticuoi partát ŏ bôn ngê ŏ tớq mít cannính án. Iki arnáq ŏ ngốh te mít án. Alứng ticuoi lới, bôn ngê saq tớq mít cannính án, iki arnáq saq ngốh te mít án. ");
INSERT INTO pac_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma cư tông inha idô: Ticuoi mmo tông parnai lớiq cơt callong, Yang Arbang-pilŏ́ng ính sưq án te callong ngki tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Co iki, Yang Arbang-pilŏ́ng ính sưq inha te máh parnai inha tông. Khán inha tông parnai ŏ, ngki án chom inha la ticuoi tinớng ŏ. Ma khán inha tông parnai lớiq ŏ, án chom inha la ticuoi lới, alứng án táq tôt inha.” ");
INSERT INTO pac_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Vít ngki, bôn máh thới sái rit alứng máh ticuoi te top Pha-rasi seq te Yê-su idô: “Thới ơi! He ính me thới táq arnáq sileh.” ");
INSERT INTO pac_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma Yê-su ôi nha-án idô: “Inha ticuoi tớq pang ndô lới lư, inha lớiq sang nnáng Yang Arbang-pilŏ́ng. Inha seq mui tíc sileh te cư, ma cư lớiq táq dyôn inha. Urớh inha lư bôn nưm mui tíc sileh muchứng Yô-na la ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh. ");
INSERT INTO pac_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yô-na át tớq pallúng buaiq pưt nhéq pe ingái pe idáu. Muchứng ngki tưi, cư Acái Yang Cơt Ticuoi át tớq ping cumuiq nhéq pe ingái pe idáu. ");
INSERT INTO pac_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yô-na pôq cato parnai Yang Arbang-pilŏ́ng tớq vel Ni-navê. Dyơ ticuoi tớq vel ngki ngin luaih pien cơt mít tamme loi. Iki, máh ticuoi ngki ính tíq ticuoi tớq pang ndô tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi. Co hoi-ngki tớq ntúq ndô bôn munáq pưt hơn te Yô-na! ");
INSERT INTO pac_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Alứng puo cán cruong Sê-ba te inớh, án ính tíq ticuoi tớq pang ndô tưi tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi. Án têq tíq iki, co án tớq te cruong yông ính cammáng ngê tubáiq te puo Sa-lamôn táq-ntêr. Ma hoi-ndô tớq ntúq ndô bôn munáq tubáiq hơn te Sa-lamôn! ");
INSERT INTO pac_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tư yang saq ngốh te cháq ticuoi, dyơ án pôq suo ntúq preng cupróng ính angô, ma án lớiq tumúh. ");
INSERT INTO pac_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Dyơ án parngíh idô: ‘Cư ính píh chô lieh nga ntúq cư khoiq ngốh te nsuoi.’ Tư án píh chô lieh nga ntúq ngki, án hôm nưm ntúq mat sớng. Ntúq ngki práh priel alứng khoiq pangcra carsiat nhéq dyơ. ");
INSERT INTO pac_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dyơ án pôq alứng dông achô tupul náq yang saq cannŏ́h loi dyôn át munơi alứng án tớq ntúq ngki. Máh yang ngki saq hơn te án. Iki thôq ticuoi ngki cơt saq hơn te nsuoi loi. Arớq ngki tưi máh ticuoi tớq pang saq ndô bôn ráp thôq saq hơn te nsuoi loi.” ");
INSERT INTO pac_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ndóng Yê-su yôl cato ticuoi clứng, bôn a-i alứng máh a-em conh án tớq. Nha-án át tayứng culái tieh ính táq-ntêr alứng án. ");
INSERT INTO pac_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bôn munáq ticuoi tớq tông Yê-su idô: “Ngki! A-i alứng máh a-em conh thới át culái tieh. Nha-án ính táq-ntêr alứng thới.” ");
INSERT INTO pac_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma Yê-su plốh án idô: “Nnáu la a-i cư? Alứng nnáu la em ai cư?” ");
INSERT INTO pac_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dyơ Yê-su turô nga top rian te án alứng tông idô: “Ndô la a-i alứng em ai cư! ");
INSERT INTO pac_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Máh ticuoi táq veng ngê A-ám cư tớq pilŏ́ng, nha-án la em ai, em ơi, alứng a-i cư.” ");
INSERT INTO pac_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tớq ingái ngki Yê-su ngốh te dúng, alứng pôq ticu tumán tor dơq clóng. ");
INSERT INTO pac_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bôn clứng ticuoi át rum paniar án. Iki án sớr ticu tớq tuoc. Ma máh ticuoi clứng yôl át tayứng tớq tor. ");
INSERT INTO pac_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dyơ án cato máh ticuoi ngki te a-ưi nốh tớq parnai acám idô: “Bôn munáq ticuoi pôq trứh callong mma. ");
INSERT INTO pac_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ndóng án trứh, bôn callong atôh tớq carna. Dyơ achếq srúp tŏ́h callong ngki. ");
INSERT INTO pac_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bôn callong cannŏ́h atôh tớq cuteq kida, tadưp bôn máng cantar. Callong ngki dáh chái lư, co cuteq lớiq sru. ");
INSERT INTO pac_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma tớq mát pandang ngốh puoq téng-péng, bát ngki cơt ngngot, co riaih lớiq sru. Dyơ án ráng. ");
INSERT INTO pac_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bôn callong cannŏ́h loi atôh tớq cuteq bôn sác tangháng. Tư sác tangháng dáh, án cluom nhéq bát ndon mbơiq dáh te callong ticuoi trứh. ");
INSERT INTO pac_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Alứng bôn callong cannŏ́h loi atôh tớq cuteq ŏ. Callong ngki dáh ŏ alứng cơt culái ŏ. Mui tôm cơt mui culám callong. Mui tôm loi cơt tupát chít callong. Alứng mui tôm cannŏ́h loi cơt pe chít callong. ");
INSERT INTO pac_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng.” ");
INSERT INTO pac_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Top rian te Yê-su tớq nga án alứng plốh idô: “Co imo thới cato tớq parnai acám ada máh ticuoi ngki?” ");
INSERT INTO pac_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yê-su ôi nha-án idô: “Co Yang Arbang-pilŏ́ng khoiq dyôn inha chom máh parnai catốq te Yang Arbang-pilŏ́ng cơt sút, ma án lớiq dyôn máh ticuoi ngki chom. ");
INSERT INTO pac_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ticuoi mmo khoiq bôn dyơ, urớh cư dyôn án bôn a-ưi lư loi. Ma ticuoi mmo ớq, máh callong án khoiq bôn, urớh cơt pít nhéq. ");
INSERT INTO pac_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cư cato máh ticuoi ngki tớq parnai acám la co nha-án me ma lớiq hôm, nha-án cammáng ma lớiq sáng alứng lớiq apúh. ");
INSERT INTO pac_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Co nha-án, iki cơt tarvớiq simớt parnai Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông idô: ‘Tam inha cammáng níc, ma inha lớiq apúh. Tam inha me níc, ma inha lớiq hôm. ");
INSERT INTO pac_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Co máh ticuoi ndô bôn mít cớng, nha-án capát cutor lớiq ính sáng. Alứng nha-án casot mát lớiq ính hôm. Khán mát nha-án hôm, cutor nha-án sáng, alứng mít cannính nha-án apúh, dáh lơ nha-án ính píh lieh, dyơ ngin luaih pien cơt mít tamme loi, iki cư lư palai nha-án dyôn cơt bánh.’ ");
INSERT INTO pac_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ma inha bôn callong bún a-ưi lư. Inha bôn mát têq bôn hôm, alứng bôn cutor têq bôn sáng. ");
INSERT INTO pac_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cư tông inha arlớih lư, bôn a-ưi náq ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh, alứng bôn clứng ticuoi tinớng ŏ, máh nha-án ngki tél-sél tháng ính hôm máh arnáq inha hôm hoi-ndô, ma nha-án lớiq bôn hôm. Alứng nha-án ính lư sáng máh parnai inha sáng hoi-ndô, ma nha-án lớiq bôn sáng. ");
INSERT INTO pac_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Iki, inha cammáng dyôn acláng parnai acám te munáq ticuoi trứh callong la acám te amớh. ");
INSERT INTO pac_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bôn ticuoi cammáng parnai ŏ te Yang Arbang-pilŏ́ng cơt sút, ma nha-án lớiq apúh. Dyơ yang Satán tớq pur ial viang parnai ŏ ngki te mít cannính nha-án. Ndô la arớq callong mma atôh tớq cuteq tớq carna. ");
INSERT INTO pac_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bôn callong mma atôh tớq cuteq kida tadưp máng cantar. Ndô la arớq ticuoi ndon cammáng parnai ŏ te Yang Arbang-pilŏ́ng, alứng chái lư nha-án ráp ial bui hơr. ");
INSERT INTO pac_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma callong tin nha-án lớiq bôn riaih sru. Iki nha-án tin muhoi sớng. Khán nha-án tumúh dieiq arức co tian nha-án tin parnai Yang Arbang-pilŏ́ng, ngki nha-án lớiq tin nnáng. ");
INSERT INTO pac_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bôn callong mma atôh tớq cuteq bôn sác tangháng. Ndô la arớq ticuoi ndon cammáng parnai ŏ te Yang Arbang-pilŏ́ng. Ma mít nha-án át lo khít tớq pang ndô, alứng nha-án ham súc bôn. Máh nốh ngki cluom viang parnai Yang Arbang-pilŏ́ng, dyơ táq dyôn lớiq cơt culái. ");
INSERT INTO pac_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Alứng bôn callong mma cannŏ́h loi atôh tớq cuteq ŏ. Ndô la arớq ticuoi ndon cammáng parnai ŏ te Yang Arbang-pilŏ́ng, alứng nha-án apúh arlớih arlêng. Dyơ nha-án cơt culái. Mui tôm cơt culái mui culám callong. Mui tôm cannŏ́h cơt culái tupát chít callong. Alứng mui tôm cannŏ́h loi cơt culái pe chít callong.” ");
INSERT INTO pac_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yê-su cato nha-án tớq parnai acám loi idô: “Yang Arbang-pilŏ́ng cơt sút la arớq munáq conh chớt sro chong ŏ tớq pidái. ");
INSERT INTO pac_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma bôn mui idáu, ndóng máh ticuoi bíq, án ndon uan ticuoi ưlla pidái mot trứh callong sác ayuoq yáq nưan tớq pidái ngki. Cua án trứh, án ngốh te pidái. ");
INSERT INTO pac_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tớq sro dáh alứng panung, callong sác yáq nưan ngki dáh tưi. ");
INSERT INTO pac_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iki máh ticuoi prái tarráih tớq tông ưlla nha-án idô: ‘Ưlla ơi! Lư ma lớiq, ưlla chớt nưm sro sớng tớq pidái ưlla? Khán iki, te mmo sác yáq nưan tớq?’ ");
INSERT INTO pac_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ưlla ôi nha-án idô: ‘Bôn munáq ndon uan ada cư táq arnáq ngki.’ Máh ticuoi prái tarráih plốh sa idô: ‘Ưlla ính he pôq rưc viang tôm sác yáq nưan ngki lớiq?’ ");
INSERT INTO pac_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ưlla ôi nha-án: ‘Êq. Cư adáh ndóng inha rưc tôm yáq nưan, inha rưc díh tôm sro. ");
INSERT INTO pac_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","He dŏq tôm sro alứng tôm yáq nưan pưt munơi tingôi tớq ingái he sot. Tư ingái ngki tớq, cư ính yua nha-án ndon sot sro idô: Inha rưc tôm yáq nưan avai. Inha cunhóm alứng apŏ́ng máh tôm yáq nưan tớq uih. Cua ngki inha sot sro alứng cacháq tớq tinong sro na cư.” ");
INSERT INTO pac_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yê-su cato nha-án tớq parnai acám sa idô: “Yang Arbang-pilŏ́ng cơt sút la arớq mui callong mma me. ");
INSERT INTO pac_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bôn ticuoi ial callong ndô dông trứh tớq pidái. Callong ndô la két clưi nhéq te máh callong cannŏ́h. Ma tớq án dáh, án pưt hơn nhéq te máh bát cannŏ́h. Án cơt arớq tôm along, têq achếq táq sáp tớq abeng án.” ");
INSERT INTO pac_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yê-su cato nha-án mui parnai acám loi idô: “Yang Arbang-pilŏ́ng cơt sút la arớq bôt táq dyôn beng mi cơt pôih. Bôn ticuoi cán ial mubiq bôt pôih cacháq tớq bôt mi a-ưi tớq adéh púng, alứng án cacháq dơq nha crơng cannŏ́h hơ; cua ngki án cuvír. Dyơ crơng ndon khoiq carchúc ngki cơt pôih nhéq.” ");
INSERT INTO pac_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yê-su cato cứp nốh ndô tớq parnai acám ada máh ticuoi clứng ngki. Cứp parnai án cato nha-án la nhéq tớq parnai acám. ");
INSERT INTO pac_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Án táq iki dyôn cơt tarvớiq simớt parnai munáq ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh khoiq tông te án idô: “Ndóng cư táq-ntêr alứng nha-án, cư tông tớq parnai acám te callong ndon Yang Arbang-pilŏ́ng catốq te ingái án teng pilŏ́ng cuteq.” ");
INSERT INTO pac_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cua ngki Yê-su ngốh te ticuoi clứng; dyơ án mot tớq dúng. Top rian te án tớq alứng seq idô: “Thới ơi! He seq thới angốh ngê te parnai acám te sro alứng sác ayuoq yáq nưan.” ");
INSERT INTO pac_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yê-su ôi nha-án idô: “Án ndon chớt sro chong ŏ la acám te Acái Yang Cơt Ticuoi. ");
INSERT INTO pac_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pidái la acám te máh cruong tớq cúc cuteq ndô. Callong mma ŏ la acám te nhéq máh ticuoi ndon cơt acái acon Yang Arbang-pilŏ́ng. Sác yáq nưan la acám te nhéq máh ticuoi ndon cơt acái acon yang Satán. ");
INSERT INTO pac_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Án ndon chớt callong sác yáq nưan la acám te yang Satán, án uan ada Ưlla pidái. Tớq ngư sot sro la acám te ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi. Nha-án ndon sot sro la acám te máh tarneng Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nha-án ính rưc alứng cunhóm sác yáq nưan ngki apŏ́ng tớq uih. Muchứng ngki tưi, Yang Arbang-pilŏ́ng ính táq ada ticuoi luaih tớq ingái án sưq nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Acái Yang Cơt Ticuoi ính yua máh tarneng án pôq cứp ntúq án sút, dyôn pachúng nhéq máh ticuoi táq luaih alứng máh ticuoi paryông ticuoi cannŏ́h táq luaih. ");
INSERT INTO pac_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dyơ máh tarneng ngki ính apŏ́ng nha-án tớq ntúq uih chéh níc-níc. Ntúq ngki nha-án chiuq toiq bap lư. Nha-án nhiem cucloiq alứng caltưat kineng tabang co sáng dieiq arức lư. ");
INSERT INTO pac_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ndóng ngki, máh ticuoi tinớng ŏ bôn át tớq ntúq A-ám nha-án tớq pilŏ́ng sút. Nha-án cơt arớq mát pandang claq tớq ntúq ngki. Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng.” ");
INSERT INTO pac_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Yang Arbang-pilŏ́ng cơt sút la arớq crơng ngáih ngai tứp tớq pidái. Tớq ticuoi cannŏ́h tumúh crơng ngki, án cabur dyôn clôp lieh alứng án sáng ơn lư. Dyơ án chô táiq nhéq máh mun án, cua ngki án pôq plới tám pidái ngki.” ");
INSERT INTO pac_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Yang Arbang-pilŏ́ng cơt sút la arớq munáq suo ính plới hôt tieq clŏq ŏ lư. ");
INSERT INTO pac_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tớq án tumúh mui callong hôt clŏq ŏ hơn te cannŏ́h. Dyơ án pôq táiq nhéq máh mun án. Cua ngki án pôq plới callong hôt ngki.” ");
INSERT INTO pac_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Alứng cư acám idô: Yang Arbang-pilŏ́ng cơt sút la arớq mben ngai lai tớq dơq. Mben ngki cŏp cứp nốh buaiq. ");
INSERT INTO pac_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tư buaiq chuot pớnh mben, máh ticuoi suo buaiq lúq mben asớr tớq tor. Dyơ nha-án ticu rêh buaiq. Buaiq mmo ŏ, nha-án cacháq tớq adư. Buaiq mmo lớiq ŏ, nha-án adúh. ");
INSERT INTO pac_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, án táq muchứng ngki tưi. Án yua máh tarneng án pôq pachúng máh ticuoi, alứng rêh payáh ticuoi lớiq ŏ te ticuoi tinớng ŏ. ");
INSERT INTO pac_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dyơ máh tarneng ngki ính apŏ́ng máh ticuoi lớiq ŏ tớq uih chéh níc-níc. Tớq ntúq ngki nha-án chiuq toiq bap lư. Nha-án nhiem cucloiq alứng caltưat kineng tabang co sáng dieiq arức lư.” ");
INSERT INTO pac_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Cua ngki Yê-su plốh top rian te án idô: “Máh nốh ndô inha apúh, ma lớiq?” Nha-án ôi: “Ơq. He apúh dyơ.” ");
INSERT INTO pac_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yê-su tông loi idô: “Co iki cứp náq thới sái rit top Isa-ra-el ndon khoiq rian alứng chom te ngê Yang Arbang-pilŏ́ng cơt sút, nha-án têq cato te ngê tieq alứng ngê tamme dyôn ticuoi cannŏ́h chom. Ndô la arớq ticuoi ưlla dúng angốh máh mun án, díh crơng tieq alứng crơng tamme.” ");
INSERT INTO pac_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tớq cua Yê-su cato parnai acám, dyơ án ngốh te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Án chô lieh nga vel án, la vel Na-saret. Át ngki án tabớq cato tớq dúng rum ticuoi Isa-ra-el. Nha-án ndon cammáng parnai án cato sáng dut lư. Dyơ nha-án plốh idô: “Te mmo án bôn ngê tubáiq ndô? Alứng co imo án têq táq arnáq sileh? ");
INSERT INTO pac_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Lư lớiq, án la acái ticuoi thơq táq pan? Lư lớiq, Mari la a-i án, alứng Yacơ, Yô-sê, Si-môn, nha Yudê la a-em conh án? ");
INSERT INTO pac_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Alứng lư lớiq, máh amoq adứp án át mui vel alứng he? Ma te mmo án bôn máh ngê ngki?” ");
INSERT INTO pac_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dyơ nha-án pamat Yê-su; nha-án sáng uan lư te án cato iki. Án tông nha-án loi idô: “Khán bôn munáq ticuoi tang ngcang Yang Arbang-pilŏ́ng pôq cato tớq vel cannŏ́h, máh ticuoi tớq vel ngki dyám náp án. Ma khán án cato tớq vel án bôm, alứng tớq abŏ́h án bôm, nha-án lớiq dyám náp án.” ");
INSERT INTO pac_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Co nha-án lớiq tin, iki Yê-su lớiq táq a-ưi arnáq sileh tớq vel án. ");
INSERT INTO pac_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ndóng ngki puo Hê-rôt An-tipa sáng ngai táq-ntêr te Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Án tông ada ticuoi tampeng án idô: “Conh ngki la lư Yon ndon báq táq tíc na dơq. Án yôr tumống lieh te ping. Co iki án bôn chức têq táq arnáq sileh.” ");
INSERT INTO pac_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hê-rôt tông iki, co te nsuoi án khoiq yua líng cŏp alứng chóq Yon, dyơ crál tớq coq tôt. Hê-rôt táq iki la co tian Hê-rô-die campái án. Tôm lư, Hê-rô-die la campái Phi-lip a-em conh án. ");
INSERT INTO pac_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Khoiq a-ưi chư Yon tông puo Hê-rôt idô: “Khán mái ial campái a-em mái, iki mái táq luaih tớq phep rit!” ");
INSERT INTO pac_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Iki Hê-rôt ính cachet Yon, ma án adáh ticuoi prái, co nha-án tin Yon la ticuoi tang ngcang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma tớq mui ingái, Hê-rôt táq pêl cha bui ayư ingái a-i án carnian án; dyơ acái cumor Hê-rô-die tớq ayưn pon liauq chứng mát máh ticuoi tumoi. Alứng Hê-rôt sáng bui lư. ");
INSERT INTO pac_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iki án ưq alứng cantŏ́h callih ada cumor ngki idô: “Amớh mái seq, cư lư dyôn mái ngki.” ");
INSERT INTO pac_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Iki cumor ngki seq arớq a-i án khoiq yua án, idô: “Cư seq plô Yon ndon báq táq tíc na dơq. Seq puo cacháq plô án tớq adien hoi-ngki táp!” ");
INSERT INTO pac_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Puo sáng anguaq lư. Ma co án khoiq cantŏ́h callih chứng mát máh tumoi, iki án yua ngai táq arớq cumor ngki seq. ");
INSERT INTO pac_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Án yua ngai mot tớq coq tôt, dyơ ticŏ́h ticong Yon. ");
INSERT INTO pac_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ngai cacháq plô Yon tớq adien, alứng dông mŏp nga cumor ngki. Dyơ cumor ngki dông achô dyôn a-i án. ");
INSERT INTO pac_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Cua ngki top rian te Yon tớq ial alứng tứp cháq Yon. Dyơ nha-án pôq táq-ntêr dyôn Yê-su chom te arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tư Yê-su sáng te arnáq ngki, án ngốh te ntúq án át. Án sớr tớq tuoc alứng pôq nga ntúq lớiq bôn ngai át, án ính át munáq án sớng. Ma clứng ticuoi sáng ngai táq-ntêr án pôq; iki nha-án ngốh te máh vel alứng ticaq veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tư Yê-su siar te tuoc, án hôm ticuoi clứng. Án sáng sruiq táq ada nha-án, dyơ án táq bánh máh nốh nha-án a-ái. ");
INSERT INTO pac_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tumán mát pandang tangcưl cóh, top rian te Yê-su tớq nga án, alứng tông idô: “Ntúq ndô yông te ntúq ticuoi át, alứng tumán idáu dyơ. Seq thới yua máh ticuoi ndô chô alứng mot tớq máh vel paniar ndô, dyôn nha-án plới bôm crơng tanna cha.” ");
INSERT INTO pac_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yê-su ôi nha-án idô: “Nha-án lớiq túh cóq chô te ndô. Inha táp dyôn nha-án bôn crơng tanna cha.” ");
INSERT INTO pac_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma nha-án tông Yê-su idô: “He bôn crơng tanna biq lư. He bôn nưm sông lám beng alứng bar lám buaiq sớng.” ");
INSERT INTO pac_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yê-su yua nha-án idô: “Dông beng alứng buaiq nga cư.” ");
INSERT INTO pac_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yê-su yua máh ticuoi clứng ticu tớq cuteq. Dyơ án ial sông lám beng alứng bar lám buaiq; án tingưi asớr nga pilŏ́ng alứng si-ơn Yang Arbang-pilŏ́ng bôn crơng tanna cha ndô. Cua ngki án péq beng. Dyơ án mŏp nga top rian te án mpô dyôn máh ticuoi ngki cha. ");
INSERT INTO pac_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Cứp náq ticuoi cha sái nhéq. Cua nha-án cha, top rian te Yê-su pachúng lieh máh ntie, bôn mui chít la bar crie. ");
INSERT INTO pac_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nhéq máh ticuoi conh sasai ndon cha la sám sông ngin náq, ma lớiq ngiaih ticuoi cán alứng ngai-acái. ");
INSERT INTO pac_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cua ngki Yê-su yua top rian te án sớr tớq tuoc, alứng pôq nsuoi án pa dyáng atóh dơq. Dyơ án yua máh ticuoi clứng ngki chô nga vel nha-án. ");
INSERT INTO pac_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Vít ticuoi clứng chô, Yê-su sớr tớq cóh munáq án co ính cớu nga tuki. Tớq idáu dyơ, án át munáq án tớq cóh ngki. ");
INSERT INTO pac_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma top rian te Yê-su át tớq tuoc pandi dơq clóng. Bôn cuyiel phớt plớq tuoc alứng táq dyôn dơq lampóh kichíh tuoc nha-án hớp lư. ");
INSERT INTO pac_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pilŏ́ng tumán sưm-turưm, Yê-su tớq nga nha-án. Án ticaq tớq lar dơq clóng. ");
INSERT INTO pac_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tư top rian te án hôm án ticaq tớq lar dơq clóng, nha-án sáng adáh lư, alứng nha-án táq-ntêr idô: “Ndô la yang cumuiq ớiq!” Iki nha-án hiar yứng lư co sáng adáh. ");
INSERT INTO pac_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ndóng ngki táp Yê-su tông nha-án idô: “Dyôn mít inha át ien ŏ. Ndô la cháq cư. Êq adáh.” ");
INSERT INTO pac_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dyơ Phi-er tông idô: “Ưlla ơi! Khán lư Ưlla, cư seq Ưlla dyôn cư ticaq pôq tớq lar dơq nga Ưlla.” ");
INSERT INTO pac_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yê-su ôi án: “Mái tớq nga tudô!” Dyơ Phi-er siar te tuoc. Án ticaq tớq lar dơq ính pôq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma ndóng án ticaq bôn cuyiel phớt nga cháq án, ngki án sáng adáh lư. Tư án tumán ính trim, án arô yứng lư idô: “Ưlla ơi! Choi bơ!” ");
INSERT INTO pac_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ndóng ngki táp Yê-su ntớp ati Phi-er, alứng lúq án asớr te dơq. Dyơ Yê-su tông án idô: “Callong tin mái biq lư! Imo mái yôl mamu?” ");
INSERT INTO pac_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dyơ Yê-su alứng Phi-er sớr tớq tuoc, dyơ cuyiel lớiq phớt nnáng. ");
INSERT INTO pac_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Top rian te Yê-su ndon át tớq tuoc cucúh sang Yê-su, alứng tông idô: “Ưlla la lư Acái Yang Arbang-pilŏ́ng!” ");
INSERT INTO pac_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Vít nha-án dyang dơq clóng, nha-án tớq nga ntúq Canê-saret. ");
INSERT INTO pac_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ticuoi tớq ntúq ngki acớl Yê-su. Iki nha-án táq-ntêr chôp ntúq dyôn ngai chom. Dyơ ngai dông máh ticuoi a-ái tớq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Alứng nha-án seq Yê-su dyôn máh ticuoi a-ái capơiq mbaiq au thor án. Ticuoi mmo capơiq, cháq ticuoi ngki cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tatun ngki bôn máh ticuoi Pha-rasi alứng máh thới sái rit tớq nga Yê-su. Nha-án tớq te vel pưt Yaru-salem alứng plốh Yê-su idô: ");
INSERT INTO pac_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Imo top rian te thới lớiq veng phep rit achúc achiac he? Imo nsuoi nha-án chicha ma lớiq arau ati veng phep rit?” ");
INSERT INTO pac_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yê-su ôi nha-án idô: “Imo inha táh máh callong Yang Arbang-pilŏ́ng khoiq patáp, ma inha veng rit inha bôm? ");
INSERT INTO pac_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yang Arbang-pilŏ́ng khoiq patáp idô: ‘Cóq inha dyám náp a-i a-ám inha. Alứng ticuoi mmo acraiq a-i a-ám án, án cóq chiuq cuchet.’ ");
INSERT INTO pac_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yang Arbang-pilŏ́ng tông iki, ma inha tông idô: ‘Têq ngai tông a-i a-ám idô: “Máh nốh cư têq choi inha, cư khoiq ưq sang dyôn Yang Arbang-pilŏ́ng dyơ.” ");
INSERT INTO pac_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Khán iki, lớiq choi a-i a-ám la dyơ.’ Ma ticuoi ngki lớiq bôn dyám náp a-i a-ám án. Iki inha pitŏ́ng níc rit ticuoi, ma inha táh máh callong Yang Arbang-pilŏ́ng khoiq patáp. ");
INSERT INTO pac_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Inha la ticuoi táq náh-nnan sớng! Lư piaiq arớq parnai Ê-sai khoiq tông te inha idô: ");
INSERT INTO pac_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Máh ticuoi ndô ayô cư nưm na ngcang sớng, ma mít cannính nha-án át yông te cư. ");
INSERT INTO pac_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nha-án sang cư ma sang lớiq cơt callong. Nha-án cato te phep rit, ma phep rit ngki chóng ngốh te ticuoi.’” ");
INSERT INTO pac_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Cua ngki Yê-su arô ticuoi clứng tớq nga án. Án cato nha-án idô: “Cóq inha cammáng alứng apúh! ");
INSERT INTO pac_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nhéq máh crơng tanna ticuoi cacháq tớq ngcang lớiq bôn táq dyôn ticuoi cơt lớiq práh veng rit. Ma khán ticuoi bôn ngê saq tớq mít, ngcang ticuoi tông angốh, lư ngê ngki táq dyôn ticuoi cơt lớiq práh veng rit.” ");
INSERT INTO pac_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Cua ngki top rian te Yê-su tớq tông án idô: “Thới chom ma lớiq, top Pha-rasi sáng uan lư te máh parnai thới tông te idứh?” ");
INSERT INTO pac_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yê-su ôi nha-án tớq parnai acám idô: “Tôm along mmo A-ám cư tớq pilŏ́ng lớiq bôn chóh, urớh án lư rưc adúh tôm ngki. ");
INSERT INTO pac_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Iki, inha êq parngíh amớh te nha-án. Nha-án la arớq ticuoi sot mát ma ính ayông ticuoi sot mát cannŏ́h. Dyơ nha-án arbúc munơi tớq prúng.” ");
INSERT INTO pac_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dyơ Phi-er seq te Yê-su idô: “Seq thới tông arlớih lư loi te parnai acám ngki.” ");
INSERT INTO pac_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yê-su plốh nha-án idô: “Imo inha nnáng iyốh apúh sa? ");
INSERT INTO pac_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Inha nnáng iyốh hôm sa lớiq? Crơng tanna mot tớq ngcang, lôn nga pallúng, dyơ ngốh na parlôiq. ");
INSERT INTO pac_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma parnai saq ndon ngốh te ngcang, parnai ngki tớq te mít cannính alứng táq dyôn ticuoi cơt lớiq práh veng rit. ");
INSERT INTO pac_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Máh callong saq ndon chóng ngốh te mít ticuoi la idô: Parngíh arnáq saq, cachet ticuoi, láh parlưi, tới campái cayieq ma bíq munơi, titôiq, pathu, alứng u saq. ");
INSERT INTO pac_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nhéq nốh ngki táq dyôn ticuoi cơt lớiq práh veng rit. Khán ticuoi cha tanna ma lớiq bôn arau ati, arnáq ngki lớiq bôn táq dyôn án cơt lớiq práh veng rit.” ");
INSERT INTO pac_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Vít ngki Yê-su ngốh te ntúq ngki, dyơ án mot tớq máh ntúq tumán vel Tirơ alứng vel Sadôn. ");
INSERT INTO pac_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bôn cán te top Cana-an ndon át tớq ntúq ngki tớq nga Yê-su, alứng tông yứng lư idô: “Ưlla ơi! Ưlla te tŏ́ng toiq puo Davit, seq Ưlla sruiq táq cư hơ! Acái cán cư a-ái ớp lư, co bôn yang saq piyúh án.” ");
INSERT INTO pac_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma Yê-su lớiq ôi án amớh. Top rian te Yê-su tớq nga Yê-su alứng tông idô: “Seq thới yua cán ndô chô, co án veng níc he, alứng tarseq tarsuong níc aváih lư.” ");
INSERT INTO pac_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yê-su ôi idô: “Yang Arbang-pilŏ́ng yua cư tớq nưm nga top Isa-ra-el sớng. Nha-án la arớq pannán cưu clu carna.” ");
INSERT INTO pac_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cua Yê-su tông iki. Cán ngki tớq nha mpop tumán dyưng Yê-su, alứng tông idô: “Cucúh Ưlla cư ơi! Seq Ưlla choi cư hơ!” ");
INSERT INTO pac_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma Yê-su ôi idô: “Lớiq crái ial crơng tanna ngai-acái, dyơ adúh dyôn acho cha.” ");
INSERT INTO pac_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Cán ngki ôi Yê-su idô: “Lư piaiq Ưlla tông. Ma acho têq cha ntie mbáh ndon sráh tadưp kichơng.” ");
INSERT INTO pac_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dyơ Yê-su ôi cán ngki idô: “Mái la cán ndon tin khớm lư. Nốh mái seq, cư lư dyôn mái bôn.” Ndóng Yê-su tông iki, acái cán án cơt bánh táp. ");
INSERT INTO pac_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yê-su ngốh te ntúq ngki, pôq tumán clóng Ca-lilê loi. Dyơ án sớr ticu tớq king. ");
INSERT INTO pac_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Clứng ticuoi tớq nga Yê-su. Nha-án dông nga án máh ticuoi bôn a-ưi nốh a-ái, la idô: Ticuoi dyuat, ticuoi sot mát, ticuoi lúng, ticuoi tarliaih, alứng a-ưi ticuoi a-ái cannŏ́h hơ. Nha-án dŏq máh ticuoi a-ái ngki tumán dyưng Yê-su. Dyơ Yê-su táq bánh nhéq máh ticuoi a-ái ngki. ");
INSERT INTO pac_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Máh ticuoi ngki sáng dut lư tớq nha-án hôm ticuoi lúng têq tacang, ticuoi tarliaih cơt ŏ lieh, ticuoi dyuat têq pupôq, ticuoi sot mát cơt plang. Dyơ nha-án ayô Yang Arbang-pilŏ́ng ndon top Isa-ra-el sang. ");
INSERT INTO pac_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yê-su arô top rian te án tớq nga án, alứng án tông idô: “Cư sáng sruiq táq lư ada ticuoi clứng ndô, co nha-án át alứng cư khoiq pe ingái dyơ, alứng nha-án ớq crơng tanna cha. Cư lớiq ính nha-án chô pallúng nnŏ́h sớng, dáh lơ nha-án dứm tớq carna.” ");
INSERT INTO pac_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Top rian te Yê-su plốh án idô: “Imo he ính táq dyôn bôn khám crơng tanna chiam máh ticuoi clứng ndô, co ntúq ndô yông lư te ntúq ticuoi át?” ");
INSERT INTO pac_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yê-su plốh lieh nha-án idô: “Sếq lám beng inha bôn?” Nha-án ôi: “He bôn tupul lám beng alứng bar pe lám buaiq két.” ");
INSERT INTO pac_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yê-su yua ticuoi clứng ngki ticu tớq cuteq. ");
INSERT INTO pac_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iki án ial tupul lám beng alứng bar pe lám buaiq két. Dyơ án si-ơn Yang Arbang-pilŏ́ng bôn crơng tanna ngki. Cua ngki án péq beng alứng buaiq, dyơ án avôi nga top rian te án mpô dyôn ticuoi clứng ngki cha. ");
INSERT INTO pac_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nhéq máh ticuoi ngki cha sái nhéq. Dyơ top rian te Yê-su pachúng lieh ntie clưi te máh ticuoi ngki cha, bôn pớnh tupul achoiq. ");
INSERT INTO pac_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Máh ticuoi conh sasai ndon cha tanna ngki sám puan ngin náq, lớiq ngiaih máh ticuoi cán alứng ngai-acái. ");
INSERT INTO pac_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Cua ngki Yê-su yua ticuoi clứng ngki chô. Dyơ án sớr tớq tuoc, alứng pôq nga vel Ma-cadan loi. ");
INSERT INTO pac_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bôn máh ticuoi Pha-rasi alứng ticuoi Sa-dusê tớq nga Yê-su. Nha-án ính chim Yê-su. Iki nha-án seq mui tíc sileh te Yê-su, co ính chom án lư bôn chức te Yang Arbang-pilŏ́ng ma lớiq. ");
INSERT INTO pac_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yê-su ôi nha-án idô: “Ndóng mát pandang tumán ính plot, khán bôn pilŏ́ng cusáu-sáu, inha tông: ‘Ingái parnô puoq.’ ");
INSERT INTO pac_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Alứng tớq iláih pilŏ́ng mbơiq ang sưm-turưm, khán inha hôm pilŏ́ng cusáu-sáu sa, inha tông idô: ‘Ingái ndô bôn bo chớn.’ Iki inha chom acớl te pilŏ́ng, bo lớiq la puoq, ma inha lớiq chom tíc ndon Yang Arbang-pilŏ́ng ính inha chom te ngê án tớq pang ndô. ");
INSERT INTO pac_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ticuoi tớq pang ndô lới lư, alứng nha-án lớiq ính peh parnai Yang Arbang-pilŏ́ng. Nha-án seq te cư mui tíc sileh, ma cư lớiq táq dyôn nha-án, ma bôn nưm mui tíc sileh na Yô-na sớng.” Dyơ Yê-su ngốh te nha-án, alứng pôq nga ntúq cannŏ́h loi. ");
INSERT INTO pac_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tớq top rian te Yê-su dyang pa dyáng atóh dơq clóng, nha-án clớiq dông beng. ");
INSERT INTO pac_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dyơ Yê-su tông nha-án idô: “Inha át dyôn ahôi. Cóq inha át yông te bôt pôih top Pha-rasi alứng top Sa-dusê.” ");
INSERT INTO pac_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nha-án tanghúng lieh te parnai Yê-su tông. Alứng nha-án munáq táq-ntêr ada munáq idô: “Án tông iki la co he clớiq dông beng.” ");
INSERT INTO pac_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tư Yê-su sáng nha-án táq-ntêr iki, án tông nha-án idô: “Inha ndon tin biq lư ơi! Imo inha tanghúng te ớq beng cha? ");
INSERT INTO pac_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Imo inha iyốh apúh sa? Inha ayư lớiq te sông lám beng ndon cư khoiq chiam sông ngin náq ticuoi? Ndóng ngki inha pachúng lieh bôn sếq crie clưi te ngai cha? ");
INSERT INTO pac_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Alứng inha ayư lớiq te tupul lám beng ndon cư khoiq chiam puan ngin náq ticuoi? Ndóng ngki inha pachúng lieh bôn sếq achoiq clưi te ngai cha? ");
INSERT INTO pac_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tớq cư tông inha te bôt pôih te top Pha-rasi alứng top Sa-dusê, ma imo inha lớiq apúh parnai ngki la parnai acám? Cư lớiq bôn táq-ntêr te beng mi.” ");
INSERT INTO pac_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cua Yê-su tông iki, top rian te án chom án lớiq bôn táq-ntêr te bôt pôih táq dyôn beng mi cơt pôih. Ma án táq-ntêr te ngê top Pha-rasi alứng top Sa-dusê cato. ");
INSERT INTO pac_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tư Yê-su mot tớq máh ntúq tumán vel Sê-sarê Phi-lip, án plốh top rian te án idô: “Máh ticuoi táq-ntêr te cư Acái Yang Cơt Ticuoi la nnáu?” ");
INSERT INTO pac_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nha-án ôi: “Bôn ticuoi tông thới la Yon ndon táq tíc na dơq. Bôn ticuoi tông thới la Ê-li. Alứng bôn ticuoi cannŏ́h loi tông thới la Yê-ramie, lớiq la munáq ticuoi tang ngcang Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yê-su plốh nha-án loi idô: “Ma inha tông cư la nnáu?” ");
INSERT INTO pac_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Si-môn Phi-er ôi Yê-su idô: “Thới la Crit, án ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi. Thới la Acái Yang Arbang-pilŏ́ng ndon tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dyơ Yê-su tông Phi-er idô: “Bún lư mái, Si-môn acái Yô-na! Parnai ndô tới te ticuoi, ma tớq te A-ám cư tớq pilŏ́ng dyôn mái chom. ");
INSERT INTO pac_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Cư tông mái idô: Mái la arớq búl, iki mái bôn nốh Phi-er loi. Alứng tớq búl ndô cư ính ayứng top tin na cư. Callong cuchet lớiq têq rap top ngki. ");
INSERT INTO pac_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Cư dyôn mái bôn chức tớq top Yang Arbang-pilŏ́ng sút. Iki nốh amớh mái dyŏq, Yang Arbang-pilŏ́ng dyŏq nốh ngki tưi. Alứng nốh amớh mái lớiq dyŏq, Yang Arbang-pilŏ́ng lớiq dyŏq tưi.” ");
INSERT INTO pac_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Cua Yê-su tông iki, án patáp top rian te án êq táq-ntêr dyôn ngai chom án la Crit ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi. ");
INSERT INTO pac_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Vít ngki Yê-su tabớq angốh ngê dyôn top rian te án chom arlớih lư. Án tông idô: “Cư cóq pôq nga vel pưt Yaru-salem. Tớq ntúq ngki, cư cóq chiuq a-ưi nốh dieiq arức te máh ticuoi sút tớq sớu, máh ticuoi sút top teng rit sang, alứng máh thới sái rit, ính táq cư. Dyơ nha-án cachet cư, ma catám ingái pe, cư yôr tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Iki Phi-er dông Yê-su ngốh nga culái tieh. Dyơ án tông Yê-su idô: “Ưlla ơi! Seq Yang Arbang-pilŏ́ng êq dyôn máh arnáq ndô tớq nga Ưlla!” ");
INSERT INTO pac_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yê-su píh mang nga Phi-er alứng tông ada án idô: “Satán! Mái át pa crŏ́ng cư! Mái êq catáng lớiq dyôn cư táq cua máh arnáq cư! Mái lớiq bôn parngíh te arnáq Yang Arbang-pilŏ́ng! Ma mái parngíh nưm te ngê ticuoi sớng!” ");
INSERT INTO pac_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cua ngki Yê-su tông top rian te án idô: “Khán bôn ticuoi mmo ính veng tapun cư, cóq án táh ngê án bôm. Cóq án ial dual bôm along calláng án, alứng cóq án veng tapun cư. ");
INSERT INTO pac_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ticuoi mmo ayáu tarngứh án, tarngứh án lư cơt pít. Ma ticuoi mmo chiuq pít tarngứh co tian án veng ngê cư, tarngứh án lư lớiq nai pít. ");
INSERT INTO pac_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Khán ticuoi mmo bôn túc palec crơng crớu tớq pang ndô, ma án táh viang tarngứh án, amớh la tarnáp dyôn án? Alứng án ính ial amớh dŏq pien lieh tarngứh án? ");
INSERT INTO pac_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Urớh Acái Yang Cơt Ticuoi tớq munơi alứng tarneng Yang Arbang-pilŏ́ng, alứng án bôn chức ang-ưr lư te A-ám án. Ndóng ngki, án dyôn nhéq tưh ticuoi ráp cống veng lieh máh arnáq nha-án khoiq táq. ");
INSERT INTO pac_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cư tông inha arlớih lư, bôn máh ticuoi tayứng tớq ntúq ndô hoi-ngki, nha-án lớiq bôn cuchet nsuoi tingôi nha-án bôn hôm Acái Yang Cơt Ticuoi cơt sút.” ");
INSERT INTO pac_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vít tupát ingái loi, Yê-su dông Phi-er alứng bar náq em ai la Yacơ nha Yon, sớr alứng án tớq cóh ayống. Nưm nha-án puan náq táp át tuki. ");
INSERT INTO pac_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iki Yê-su palít cơt rớp ndái loi chứng mát nha-án pe náq. Mang án claq arớq mát pandang, alứng tampớc án clŏq tarbal mát. ");
INSERT INTO pac_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ndóng ngki nha-án pe náq hôm Môi-se nha Ê-li táq-ntêr alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dyơ Phi-er tông Yê-su idô: “Ưlla ơi! He át tớq ntúq ndô la ŏ lư. Khán Ưlla ính, he ính táq pe lám panu, mui lám dyôn Ưlla, mui lám dyôn Môi-se, alứng mui lám loi dyôn Ê-li.” ");
INSERT INTO pac_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ndóng Phi-er yôl táq-ntêr iki, bôn tulúc clŏq siar cluom catáng nha-án. Alứng bôn sieng tubau tông te tulúc idô: “Án ndô la Acái cư, ndon cư amoih lư. Amớh án táq la cư sáng bui nhéq. Amớh án tông inha, cóq inha cammáng án.” ");
INSERT INTO pac_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tư nha-án pe náq te top rian te Yê-su sáng sieng ngki, nha-án adáh lư alứng mpop mui tatứp tớq cuteq. ");
INSERT INTO pac_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yê-su tớq alứng capơiq nha-án, nha tông idô: “Inha yôr tayứng! Êq adáh!” ");
INSERT INTO pac_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iki nha-án tingưi asớr, nha-án hôm nưm munáq Yê-su sớng. ");
INSERT INTO pac_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ndóng nha-án siar te cóh, Yê-su patáp nha-án pe náq idô: “Inha êq táq-ntêr dyôn ngai chom te máh arnáq inha khoiq hôm ingái ndô, tingôi ingái cư Acái Yang Cơt Ticuoi cuchet alứng tumống lieh te ping.” ");
INSERT INTO pac_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dyơ top rian te Yê-su plốh án idô: “Imo thới sái rit tông Ê-li cóq tớq nsuoi Crit?” ");
INSERT INTO pac_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yê-su ôi nha-án idô: “Ê-li lư tớq nsuoi, dŏq atức cứp nốh dyôn cơt tamme lieh. ");
INSERT INTO pac_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma cư tông inha, Ê-li khoiq tớq dyơ, alứng ticuoi lớiq chom alứng lớiq acớl án. Ma arnáq amớh ngai ính táq ada án, lư ngai khoiq táq dyơ. Urớh ngai ính táq muchứng ngki tưi ada cư Acái Yang Cơt Ticuoi.” ");
INSERT INTO pac_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Cua ngki top rian te Yê-su apúh la ndóng Yê-su tông te Ê-li, la án acám te Yon ndon táq tíc na dơq. ");
INSERT INTO pac_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ndóng nha-án píh lieh nga ntúq bôn ticuoi clứng, ma bôn munáq conh tớq nga Yê-su. Án chóh tarcol alứng seq idô: ");
INSERT INTO pac_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ưlla ơi! Seq Ưlla sruiq táq acái conh cư hơ, co án a-ái yúh kisong alứng ráh-ariaq lư. Tớq án mứh, án dứm tớq uih, lớiq la tớq dơq. ");
INSERT INTO pac_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cư khoiq dông án nga top rian te Ưlla, ma nha-án lớiq têq táq bánh.” ");
INSERT INTO pac_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iki Yê-su ôi idô: “Ơ inha ticuoi tớq pang ndô ơi! Inha lớiq tin, alứng inha lới lư. Nnáng dưnh máh-mmo cư cóq át alứng inha? Alứng nnáng dưnh máh-mmo cư cóq chiuq tanhir inha lớiq tin cư? Dông ngai-acái ngki tớq nga cư!” ");
INSERT INTO pac_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iki Yê-su pi-ốh yang saq. Dyơ yang saq ngki ngốh te cháq ngai-acái; ngai-acái cơt bánh táp. ");
INSERT INTO pac_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Vít ngki Yê-su át nưm alứng top rian te án sớng. Nha-án plốh Yê-su idô: “Co imo he chuih angốh yang saq ngki lớiq rap?” ");
INSERT INTO pac_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yê-su ôi nha-án idô: “Co inha lớiq tin simớt simơi. Cư tông inha arlớih lư, khán inha bôn callong tin pưt máh mui callong me, lư inha têq yua cóh ndô idô: ‘Mái pôq te ntúq ndô, dyơ át nga ntúq cannŏ́h loi!’ Khán inha bôn callong tin li callong me, cóh ngki lư pôq. Khán inha tin simớt simơi, arnáq amớh inha ính táq, lư cơt arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ticuoi mmo ính rap chuih angốh yang saq arớq ndô, cóq án cớu simớt lư alứng ót tanna.” ");
INSERT INTO pac_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ndóng top rian te Yê-su rum tớq vúng Ca-lilê, Yê-su tông nha-án idô: “Tumán dyơ ngai mŏp cư Acái Yang Cơt Ticuoi nga ati ticuoi sút. ");
INSERT INTO pac_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nha-án lư cachet cư, ma catám ingái pe, cư yôr tumống lieh.” Iki top rian te án sáng anguaq lư. ");
INSERT INTO pac_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ndóng Yê-su alứng top rian te án tớq nga vel Cabê-na-um, bôn máh ticuoi te Dúng Sang Pưt ndon ial práq thêq tớq nga Phi-er, alứng plốh án idô: “Thới mái dyôn práq thêq nga Dúng Sang Pưt, ma lớiq?” ");
INSERT INTO pac_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Phi-er ôi: “Án dyôn.” Tư Phi-er mot tớq dúng, Yê-su plốh táp án idô: “Si-môn ơi! Amớh mái parngíh te máh puo tớq pang ndô ial práq thêq te mmo? Nha-án ial práq te cruong nha-án bôm, lớiq la ial te cruong ndon nha-án khoiq chíl rap?” ");
INSERT INTO pac_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phi-er ôi Yê-su idô: “Nha-án ial práq thêq te cruong cannŏ́h.” Iki Yê-su tông loi án idô: “Khán iki, máh ticuoi ndon át tớq cruong bôm lớiq túh cóq dyôn práq thêq. ");
INSERT INTO pac_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma he lớiq ính nha-án ndon ial práq thêq dyôn Dúng Sang Pưt sáng lớiq êm ada he. Iki mái pôq abáih buaiq tớq dơq clóng. Buaiq tôm lư mái bôn, cóq mái caq ngcang; dyơ mái ial mui callong práq te ngcang án. Práq ngki cứp dyôn he mŏp práq thêq nga Dúng Sang ngki. Dyơ mái dông achô alứng dyôn nga nha-án ndon ial práq thêq.” ");
INSERT INTO pac_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ndóng ngki top rian te Yê-su tớq nga án alứng plốh idô: “Tớq top Yang Arbang-pilŏ́ng sút, nnáu pưt hơn nhéq te cannŏ́h?” ");
INSERT INTO pac_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yê-su arô munáq ngai-acái alứng dyôn án tayứng pandi top nha-án. ");
INSERT INTO pac_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Dyơ Yê-su tông idô: “Cư tông inha arlớih lư, khán inha lớiq pien mít cơt arớq ngai-acái ndô, inha lớiq têq mot tớq top Yang Arbang-pilŏ́ng sút. ");
INSERT INTO pac_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ticuoi mmo asiar cháq arớq ngai-acái ndô, ticuoi ngki lư cơt pưt hơn nhéq te cannŏ́h tớq top Yang Arbang-pilŏ́ng sút. ");
INSERT INTO pac_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Alứng ticuoi mmo ráp munáq ngai-acái arớq ndô co ticuoi ngki tin cư, ngki án lư ráp díh cư hơ. ");
INSERT INTO pac_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ticuoi mmo tardông munáq ngai-acái ndon khoiq tin cư dyôn lớiq tin nnáng, the ngai tacoi búl pưt tớq ticong án, dyơ apŏ́ng án tớq dơq ving-cavang, nsuoi te án ính tardông ngai-acái dyôn calôih táh cư. ");
INSERT INTO pac_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bap lư dyôn ticuoi tớq pang ndô, co bôn a-ưi nốh ính tardông nha-án táq luaih. Máh nốh ngki cóq tớq, ma bap lư tớq nga ticuoi ndon tardông ticuoi cannŏ́h táq luaih. ");
INSERT INTO pac_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Khán ati lớiq la dyưng inha ma tardông inha táq luaih, cóq inha cŏ́h adúh viang ati lớiq la dyưng inha. Khaq inha bôn tumống alứng bôn mot tớq ntúq Yang Arbang-pilŏ́ng sút bôn mui pa ati lớiq la mui pa dyưng acút, aláng bôn cứp bar pa ati lớiq la dyưng ma Yang Arbang-pilŏ́ng ardyóng adúh inha tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Alứng khán callong mát inha tardông inha táq luaih, cóq inha culáiq adúh viang callong mát ngki. Khaq inha pít mui callong mát alứng bôn tumống, aláng bôn cứp bar callong mát ma Yang Arbang-pilŏ́ng ardyóng adúh inha tớq ntúq uih chéh níc-níc.” ");
INSERT INTO pac_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Inha me a-ŏ! Êq pamat munáq ticuoi mmo te máh ngai-acái ndô. Co cư tông nhéq máh inha idô: Máh tarneng ndon kiaq me ngai-acái ndô át níc chứng mát A-ám cư tớq pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Acái Yang Cơt Ticuoi tớq nga cúc cuteq ndô, la co ính choi tamống máh ticuoi clu carna. ");
INSERT INTO pac_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Inha parngíh imo, khán bôn munáq conh bôn mui culám lám cưu, ma bôn mui lám cưu clu carna, amớh táp án ính táq? Lư án dŏq tikiaih chít tikiaih lám tớq rong sác tớq cóh, dyơ án pôq suo táp mui lám cưu ndon khoiq clu carna, lư lớiq? ");
INSERT INTO pac_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cư tông inha arlớih lư, khán án tumúh lieh cưu ngki, án lư sáng bui hơn te tikiaih chít tikiaih lám cưu ndon lớiq bôn pít. ");
INSERT INTO pac_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Muchứng ngki tưi, A-ám inha tớq pilŏ́ng lớiq ính pít mui náq ticuoi mmo te máh ngai-acái ndô.” ");
INSERT INTO pac_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Khán bôn munáq em ai ma táq luaih ada mái, cóq mái pôq tông án nưm inha bar náq sớng te arnáq án khoiq táq luaih. Khán án cammáng parnai mái, ngki inha cơt artoi lieh. ");
INSERT INTO pac_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma khán án lớiq cammáng parnai mái, cóq mái dông mui náq, lớiq la bar náq pôq alứng mái nga án, dŏq bar pe náq cammáng te parnai inha táq-ntêr alứng parchen inha. ");
INSERT INTO pac_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma khán án lớiq cammáng sa bar pe náq ngki, iki cóq inha táq-ntêr dyôn top ticuoi tin chom tưi; ma khán án lớiq peh top tin, ngki inha táq ada án arớq ticuoi lớiq tin, lớiq la arớq ticuoi ial práq thêq. ");
INSERT INTO pac_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Cư tông inha arlớih lư, nốh amớh inha dyŏq, Yang Arbang-pilŏ́ng dyŏq nốh ngki tưi. Alứng nốh amớh inha lớiq dyŏq, Yang Arbang-pilŏ́ng lớiq dyŏq tưi nốh ngki. ");
INSERT INTO pac_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Alứng cư tông inha sa, khán bôn bar náq tớq cúc cuteq ndô ma sŏ́ng mui mít seq mui nốh amớh te A-ám cư tớq pilŏ́ng, án lư dyôn inha bôn callong ngki. ");
INSERT INTO pac_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Co khán bôn bar pe náq át rum munơi ính veng ngê cư, cư lư át munơi alứng nha-án.” ");
INSERT INTO pac_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dyơ Phi-er tớq nga Yê-su alứng plốh idô: “Ưlla ơi! Khán em ai cư táq luaih ada cư, sếq chư cư cóq táh luaih dyôn án? Tupul chư piaiq lớiq, Ưlla?” ");
INSERT INTO pac_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yê-su ôi án idô: “Cư lớiq bôn tông nưm tupul chư sớng. Ma cóq inha táh luaih tupul chít chư tupul. ");
INSERT INTO pac_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Co Yang Arbang-pilŏ́ng cơt sút la arớq munáq ticuoi puo. Puo ngki ính plốh lieh práq te máh prái tarráih ndon tu án. ");
INSERT INTO pac_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tôm lư ngai dông munáq ndon tu puo tớq nga puo; ticuoi ngki tu án lớiq chom sếq ức vêu práq. ");
INSERT INTO pac_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma ticuoi ngki lớiq bôn amớh ính culieh máh práq án tu puo. Iki puo yua ngai dông táiq án, alứng táiq díh acái campái án dyôn cơt sol ticuoi cannŏ́h. Alứng ngai táiq díh mun án hơ, dyơ ial práq tarnáp ngki culieh práq án tu puo. ");
INSERT INTO pac_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ma ticuoi ngki chóh tarcol chứng mát puo, alứng án tarseq tarsuong níc idô: ‘Seq cucúh puo. Seq puo êq iyốh cartál. Aplaiq seq the bo lo khít avai, dyơ aplaiq lư culieh nhéq práq ndon aplaiq tu puo.’ ");
INSERT INTO pac_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tư puo sáng ticuoi ngki thưoc iki, án sáng sruiq táq ada ticuoi ngki. Dyơ án táh nhéq máh práq ticuoi ngki tu án. Alứng án dyôn ticuoi ngki chô. ");
INSERT INTO pac_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ma tư ticuoi ngki ngốh te puo, án tumúh munáq yớu ndon prái tarráih muchứng án tưi, ma yớu ngki tu án biq sớng. Ma án ngóq ticong yớu ngki, alứng tông idô: ‘Mái culieh táp práq ndon mái tu cư.’ ");
INSERT INTO pac_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ticuoi ndon tu án mpop tớq cuteq alứng tarseq idô: ‘Seq inha êq iyốh cartál. Aplaiq seq the bo lo khít avai, dyơ aplaiq lư culieh nhéq práq ndon aplaiq tu inha.’ ");
INSERT INTO pac_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ma án lớiq chiuq. Án dyôn ngai cŏp ticuoi ndon tu án, alứng crál tớq coq tôt tingôi ticuoi ngki culieh nhéq tu. ");
INSERT INTO pac_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tư ticuoi prái tarráih cannŏ́h hôm án táq iki, nha-án sáng lớiq êm, dyơ nha-án chô táq-ntêr dyôn puo chom. ");
INSERT INTO pac_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Iki puo arô lieh ticuoi ngki, alứng tông ada án idô: ‘Mái la ticuoi lớiq ŏ. Cư khoiq táh nhéq máh práq ndon mái tu cư, co mái khoiq thưoc cư. ");
INSERT INTO pac_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ma imo mái lớiq sruiq táq yớu muchứng cư sruiq táq ada mái?’ ");
INSERT INTO pac_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Puo sáng nháih lư. Dyơ án yua ngai crál ticuoi ngki tớq coq tôt tingôi ticuoi ngki culieh nhéq tu.” ");
INSERT INTO pac_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Dyơ Yê-su tông loi idô: “Muchứng ngki tưi, A-ám cư tớq pilŏ́ng ính táq ada inha, khán inha lớiq táh luaih dyôn em ai inha nhéq te mít cannính.” ");
INSERT INTO pac_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cua Yê-su tông parnai ngki, án ngốh te vúng Ca-lilê, dyơ mot tớq vúng Yudê ndon át pa dyáng atóh crong Yôr-dan. ");
INSERT INTO pac_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Át tuki bôn clứng ticuoi veng tapun án, alứng án táq bánh máh nốh ticuoi a-ái. ");
INSERT INTO pac_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bôn máh ticuoi Pha-rasi tớq nga Yê-su ính chim án. Nha-án plốh án idô: “Veng phep rit he, têq lớiq ticuoi conh táh campái khán án lớiq ính nnáng?” ");
INSERT INTO pac_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yê-su ôi nha-án idô: “Arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô: ‘Tôm lư, Yang Arbang-pilŏ́ng teng ticuoi conh alứng ticuoi cán.’ ");
INSERT INTO pac_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Alứng Yang Arbang-pilŏ́ng khoiq tông idô: ‘Co iki ticuoi conh ính yáh te a-i a-ám án, dyơ án át munơi alứng campái án. Iki nha-án bar náq campái cayieq cơt arớq munáq sớng.’ ");
INSERT INTO pac_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iki nha-án lớiq cơt nnáng bar náq, ma cơt arớq munáq sớng. Co iki Yang Arbang-pilŏ́ng amúh nha-án dyôn cơt campái cayieq, alứng ticuoi mmo la lớiq têq payáh nha-án dyôn partáh.” ");
INSERT INTO pac_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Máh ticuoi Pha-rasi ngki plốh sa Yê-su idô: “Ma Môi-se khoiq patáp he, khán ticuoi mmo ính táh campái, án cóq táq chớiq partáh dyôn campái án, dyơ têq án táh.” ");
INSERT INTO pac_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Yê-su ôi lieh nha-án idô: “Môi-se patáp inha têq táh campái la co tian inha bôn mít cớng alứng lớiq ính peh parnai Yang Arbang-pilŏ́ng. Ma te tôm lư Yang Arbang-pilŏ́ng lớiq dyôn táq arớq ngki. ");
INSERT INTO pac_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cư ính tông inha idô: Khán ticuoi mmo táh campái, ma campái án lớiq bôn láh parlưi conh cannŏ́h, lư án táp láh parlưi khán án ial campái tamme.” ");
INSERT INTO pac_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Top rian te Yê-su tông án idô: “Khán cơt arnáq iki, khaq êq ial campái cayieq.” ");
INSERT INTO pac_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yê-su ôi nha-án idô: “Máh parnai cư tông inha hoi-ngki, lớiq bôn cứp náq ticuoi têq ráp ial parnai ngki. Nưm nha-án ndon Yang Arbang-pilŏ́ng choi têq ráp ial parnai ngki. ");
INSERT INTO pac_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bôn máh ticuoi lớiq ính ial campái la co cháq nha-án lớiq ŏ te ingái a-i carnian. Bôn ticuoi cannŏ́h loi lớiq têq ial campái la co ngai khoiq lát. Alứng bôn ticuoi cannŏ́h loi lớiq ính ial campái la co ính táq arnáq Yang Arbang-pilŏ́ng nhéq te tarngứh tarhơ. Ticuoi mmo rap peh máh parnai ndô, dyôn án peh.” ");
INSERT INTO pac_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bôn ticuoi dông máh ngai-acái tớq nga Yê-su ính án capơiq alứng cớu dyôn ngai-acái. Ma top rian te Yê-su dyŏq máh ticuoi ndon dông ngai-acái. ");
INSERT INTO pac_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yê-su tông nha-án idô: “Inha dyôn ngai-acái tớq nga cư. Êq catáng nha-án, co tớq top Yang Arbang-pilŏ́ng sút bôn nưm ticuoi ndon bôn mít cannính arớq ngai-acái.” ");
INSERT INTO pac_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cua Yê-su capơiq tớq ngai-acái, dyơ án pôq te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bôn munáq conh tớq nga Yê-su, alứng plốh idô: “Thới ơi! Arnáq ŏ amớh cư cóq táq dŏq cư têq bôn tumống níc-níc?” ");
INSERT INTO pac_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yê-su ôi án idô: “Imo mái plốh cư te arnáq ŏ? Nưm Yang Arbang-pilŏ́ng táp lư ŏ. Khán mái ính bôn tumống níc-níc, cóq mái peh máh parnai Yang Arbang-pilŏ́ng khoiq patáp na Môi-se.” ");
INSERT INTO pac_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Conh ngki plốh sa idô: “Parnai patáp amớh?” Yê-su ôi án: “Êq cachet ticuoi; êq láh parlưi; êq titôiq; êq pathu; ");
INSERT INTO pac_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","cóq dyám náp a-i a-ám; alứng cóq amoih yớu muchứng mái amoih cháq mái bôm.” ");
INSERT INTO pac_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Conh ngki ôi idô: “Cứp parnai patáp ngki cư khoiq peh nhéq dyơ. Ma parnai patáp amớh loi cư iyốh táq?” ");
INSERT INTO pac_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yê-su tông sa án idô: “Khán mái ính lư táq dyôn piaiq cứp nốh, ngki cóq mái pôq táiq nhéq máh mun mái, dyơ ial práq ngki choi máh ticuoi kidit. Khán mái táq iki, mái lư bôn mun ngáih tớq pilŏ́ng. Dyơ mái tớq veng tapun cư.” ");
INSERT INTO pac_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cua Yê-su tông iki, conh ngki pôq te ngki alứng sáng anguaq lư, co án la ticuoi súc. ");
INSERT INTO pac_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Cua ngki Yê-su tông top rian te án idô: “Cư tông inha arlớih lư, dieiq lư dyôn máh ticuoi súc mot tớq top Yang Arbang-pilŏ́ng sút. ");
INSERT INTO pac_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Alứng cư tông inha loi idô: Pannán lac-da lŏt hŏ́ng tarúm ien hơn te ticuoi súc mot tớq top Yang Arbang-pilŏ́ng sút.” ");
INSERT INTO pac_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tư top rian te Yê-su sáng iki, nha-án sáng dut lư alứng plốh idô: “Khán iki, nnáu têq mot tớq top Yang Arbang-pilŏ́ng sút?” ");
INSERT INTO pac_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yê-su me nga nha-án alứng tông idô: “Ticuoi lớiq têq táq bôm arnáq ngki, ma Yang Arbang-pilŏ́ng táp têq táq cứp arnáq.” ");
INSERT INTO pac_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Phi-er ráp ngcang Yê-su idô: “He khoiq táh nhéq cứp nốh he bôn, co he veng tapun thới. Tớq urớh he bôn ráp cống amớh?” ");
INSERT INTO pac_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yê-su tông nha-án idô: “Cư tông inha arlớih lư, ndóng cư Acái Yang Cơt Ticuoi ticu tớq ntúq cư sút tớq cúc cuteq tamme, ndóng ngki mui chít la bar náq inha ndon veng tapun cư bôn ticu tớq ntúq sút ndon ang-ưr lư dŏq sưq mui chít la bar top ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Alứng khán ticuoi mmo táh dúng, táh em ai, táh em ơi, táh a-i a-ám, táh acái acon, lớiq la táh pidái na, co án ính veng ngê cư, án bôn lieh clưi culám chư hơn te máh nốh án khoiq táh te nsuoi. Alứng chô-mát án bôn tumống níc-níc hơ. ");
INSERT INTO pac_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma a-ưi ticuoi ndon pưt hoi-ngki, chô-mát nha-án cơt két loi. Alứng a-ưi ticuoi ndon két hoi-ngki, chô-mát nha-án cơt pưt loi.” ");
INSERT INTO pac_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Yang Arbang-pilŏ́ng cơt sút la arớq ticuoi ưlla nưong nho. Te iláih lư án pôq suo ticuoi thuthe dyôn táq arnáq tớq nưong án. ");
INSERT INTO pac_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ưlla ngki ính dyôn cống ticuoi thuthe mui ingái mui callong práq. Dyơ án yua nha-án pôq táq arnáq tớq nưong án. ");
INSERT INTO pac_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tớq mát pandang turống crêng, án pôq suo sa ticuoi thuthe dyôn táq arnáq tớq nưong án. Án pôq nga ntúq parlới, án tumúh máh ticuoi tayứng ntúq ngki, lớiq bôn táq amớh. ");
INSERT INTO pac_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iki án tông nha-án idô: ‘Inha pôq táq arnáq tớq nưong cư. Cư ính dyôn inha cống piaiq veng te arnáq inha táq.’ ");
INSERT INTO pac_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Iki nha-án pôq. Tớq pandang tứng alứng pandang viet, án pôq suo sa ticuoi thuthe, alứng yua ngai pôq táq tớq nưong án. ");
INSERT INTO pac_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Alứng tớq mát pandang tangcưl cóh, án pôq sa nga ntúq parlới. Án tumúh ticuoi cannŏ́h loi ndon lớiq bôn táq arnáq amớh. Dyơ án plốh nha-án idô: ‘Imo nhéq ingái inha át níc tớq ntúq ndô lớiq táq amớh?’ ");
INSERT INTO pac_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nha-án ôi idô: ‘Co lớiq bôn ngai arô he dyôn pôq thuthe.’ “Iki ưlla ngki tông ada nha-án idô: ‘Dyơ, inha pôq táq tớq nưong cư.’ ");
INSERT INTO pac_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Tớq ibư khoiq tumán idáu, ưlla ngki yua ticuoi tampeng án alứng tông idô: ‘Pôq arô máh ticuoi thuthe alứng dyôn práq cống nha-án. Nsuoi lư, mái dyôn cống nha-án ndon tớq táq tatun. Cua ngki mái dyôn cống nha-án ndon tớq táq nsuoi lư.’ ");
INSERT INTO pac_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Nha-án ndon tớq táq ndóng pandang tangcưl cóh tớq nga tampeng, dyơ án dyôn nha-án bôn munáq mui callong práq. ");
INSERT INTO pac_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Iki máh ticuoi ndon tớq táq nsuoi parngíh nha-án bôn práq cống a-ưi hơn te ticuoi ndon tớq táq tatun. Ma tư nha-án tớq nga tampeng, tampeng ngki dyôn nha-án bôn práq cống munáq mui callong práq tưi. ");
INSERT INTO pac_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cua nha-án ial práq, nha-án tarsuon alứng ưlla nưong. ");
INSERT INTO pac_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nha-án tông idô: ‘Máh ticuoi tớq táq tatun, nha-án táq arnáq nưm sám chen mui adéh dôi. Ma he táq nhéq ingái. He chiuq tieng puoq alứng chiuq aleq nhéq ingái. Ma imo ưlla dyôn práq cống he muchứng nha-án.’ ");
INSERT INTO pac_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma ưlla ngki ôi munáq te top nha-án idô: ‘Yớu ơi! Cư lớiq bôn lop inha. Inha khoiq sŏ́ng alứng cư, inha táq mui ingái, cư dyôn inha bôn cống mui callong práq. ");
INSERT INTO pac_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Iki inha ial práq cống inha, dyơ chô. Khán cư ính dyôn máh ticuoi ndon tớq táq tatun li-arli alứng inha, ");
INSERT INTO pac_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","cư têq táq iki, piaiq lớiq? Imo inha i-ôiq na yớu tớq inha hôm cư táq arnáq ŏ?’” ");
INSERT INTO pac_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Iki nha-án ndon tớq tatun, urớh nha-án cơt arớq ticuoi nsuoi lư. Alứng nha-án ndon tớq nsuoi lư, urớh nha-án cơt arớq ticuoi tatun tháng.” ");
INSERT INTO pac_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ndóng Yê-su sớr nga vel pưt Yaru-salem, án dông nưm top rian te án sớng pôq alứng án. Ndóng nha-án pôq tớq carna, án tông nha-án idô: ");
INSERT INTO pac_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Inha cammáng! He sớr nga vel Yaru-salem. Át tuki ngai ính mŏp Acái Yang Cơt Ticuoi nga ati máh ticuoi sút top teng rit sang Yang Arbang-pilŏ́ng alứng nga máh thới sái rit. Nha-án ính anát án cóq cuchet. ");
INSERT INTO pac_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dyơ nha-án ính mŏp án nga ticuoi tới ticuoi Isa-ra-el. Ticuoi ngki ayê tar-ac án, prớih án, alứng téh án tớq along calláng. Ma catám ingái pe, án yôr tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cua ngki, campái Sê-badê alứng bar náq acái conh án tớq nga Yê-su. Cán ngki chóh tarcol chứng mát Yê-su alứng seq mui nốh te Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yê-su plốh án idô: “Nốh amớh mái ính bôn?” Án ôi idô: “Seq thới dyôn bar náq acái conh cư ticu munáq pa atớm munáq pa aviar thới, tớq thới cơt sút.” ");
INSERT INTO pac_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Yê-su ôi nha-án idô: “Inha lớiq chom díh callong inha seq! Rap lớiq, inha ngoiq mui choc alứng cư?” Nha-án ôi án idô: “He rap.” ");
INSERT INTO pac_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dyơ Yê-su tông lieh nha-án idô: “Urớh inha cóq ngoiq mui choc alứng cư. Ma cư lớiq têq dyôn inha ticu pa atớm lớiq la pa aviar cư. Arnáq ndô nưm A-ám cư táp têq rêh.” ");
INSERT INTO pac_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tư mui chít náq cannŏ́h tớq top rian te Yê-su sáng arnáq ndô, nha-án uan lư ada bar náq em ai ngki. ");
INSERT INTO pac_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iki Yê-su arô top ngki tớq nga án, alứng án tông idô: “Inha khoiq chom dyơ, ticuoi ndon sút máh ticuoi prái cruong cannŏ́h, nha-án bôn chức pưt lư alứng ial chức ngki padớm máh ticuoi prái. ");
INSERT INTO pac_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma inha êq táq arớq nha-án. Ticuoi mmo ính cơt pưt tớq top inha, cóq án cơt prái tarráih inha. ");
INSERT INTO pac_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Alứng ticuoi mmo ính cơt pưt clưi nhéq te cannŏ́h tớq top inha, cóq án cơt sol inha. ");
INSERT INTO pac_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Muchứng ngki tưi Acái Yang Cơt Ticuoi khoiq tớq, án lớiq ính ngai hớu án, ma án ính hớu ngai. Alứng án ial tarngứh án chiuq cuchet tang dyôn nhéq tưh ticuoi dyôn têq bôn tumống.” ");
INSERT INTO pac_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ndóng Yê-su alứng top rian te án ngốh te vel Yê-ri-cô, bôn clứng ticuoi veng tapun án. ");
INSERT INTO pac_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bôn bar náq conh sot mát át ticu tor carna. Tư nha-án sáng Yê-su pôq pha tumán nha-án, ngki nha-án tubau yứng lư idô: “Ưlla te tŏ́ng toiq Davit ơi! Seq Ưlla sruiq táq he hơ!” ");
INSERT INTO pac_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Máh ticuoi clứng pi-ốh nha-án alứng dyŏq idô: “Êq tacang!” Ma nha-án tubau yứng lư loi: “Ưlla te tŏ́ng toiq Davit ơi! Seq inha sruiq táq he hơ!” ");
INSERT INTO pac_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iki Yê-su trín. Án arô bar náq ngki tớq nga án alứng plốh idô: “Nốh amớh inha ính cư táq dyôn inha?” ");
INSERT INTO pac_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nha-án ôi: “Ưlla ơi! Seq Ưlla táq dyôn mát he cơt plang!” ");
INSERT INTO pac_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yê-su sáng sruiq táq nha-án, dyơ án capơiq tớq mát nha-án. Ndóng ngki táp mát nha-án cơt plang. Dyơ nha-án veng tapun Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tư Yê-su alứng top rian te án tumán ính tớq vel Yaru-salem, nha-án khoiq tớq vel Bê-phayê tớq pangcong king o-li-vê, Yê-su yua bar náq top rian te án idô: ");
INSERT INTO pac_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Inha mot tớq vel chứng mát inha. Ndóng inha tớq nga parngốh vel, inha lư tumúh mui lám icán aséh a-êp alứng acái án, ngai chóq dŏq tớq lác tuki. Inha lếh alứng tec bar lám pannán ngki dông nga cư. ");
INSERT INTO pac_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Khán bôn ngai plốh inha, dyôn inha ôi idô: ‘Ưlla he ính manh. Cua ngki án dông culieh lieh.’” ");
INSERT INTO pac_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Máh nốh ndô cơt tarvớiq simớt parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông te inớh idô: ");
INSERT INTO pac_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Cóq inha pau tông dyôn ticuoi prái tớq vel Yaru-salem chom idô: ‘Inha me tuki! Puo inha chón tớq nga inha. Án la ticuoi asiar cháq, alứng án diq aséh a-êp nha aséh a-êp lơ-lơ.’” ");
INSERT INTO pac_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iki nha-án bar náq top rian te Yê-su pôq táq arớq Yê-su khoiq yua nha-án. ");
INSERT INTO pac_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nha-án dông acái alứng icán aséh a-êp nga Yê-su. Alứng nha-án lêp tampớc tớq crŏ́ng aséh. Dyơ Yê-su sớr diq tớq crŏ́ng aséh. ");
INSERT INTO pac_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Clứng ticuoi lêp tampớc nha-án tớq carna. Bôn ticuoi mot tớq arưih tupáiq pŏ ính lêp tớq carna. ");
INSERT INTO pac_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Án ndon pôq nsuoi, án ndon veng tatun, nha-án sŏ́ng crau yứng lư idô: “Ô-sana! Lư ayô án ndon te tŏ́ng toiq puo Davit! Seq Yang Arbang-pilŏ́ng dyôn callong bún nga án ndon tớq nhơ nốh Ưlla. Ô-sana! Lư ayô Yang Arbang-pilŏ́ng!” ");
INSERT INTO pac_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ndóng Yê-su mot tớq vel Yaru-salem, nhéq máh ticuoi át tớq vel cơt parchul parchial alứng plốh idô: “Ticuoi ndô la nnáu?” ");
INSERT INTO pac_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ticuoi clứng ngki ôi idô: “Ndô la Yê-su. Án la ticuoi tang ngcang Yang Arbang-pilŏ́ng, án tớq te vel Na-saret, vúng Ca-lilê.” ");
INSERT INTO pac_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yê-su mot tớq ngcưm Dúng Sang Pưt. Alứng án chuih angốh nhéq máh ticuoi táiq plới tớq Dúng Sang. Án kitúh cutứp kichơng ngai tarpien práq alứng kichơng ngai ticu táiq achếq cacu. ");
INSERT INTO pac_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Án tông ada nha-án idô: “Tớq tám uráq Yang Arbang-pilŏ́ng te inớh khoiq tông idô: ‘Ngai dŏq dúng cư la dúng ien cớu seq.’ Ma inha khoiq táq dúng ndô cơt arớq cưp dyôn ticuoi siveng mot catốq!” ");
INSERT INTO pac_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Cua ngki bôn máh ticuoi sot alứng ticuoi dyuat tớq nga Yê-su nga Dúng Sang Pưt. Dyơ Yê-su táq bánh nhéq nha-án. ");
INSERT INTO pac_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma máh ticuoi sút top teng rit sang alứng máh thới sái rit sáng nháih lư tớq nha-án hôm Yê-su táq arnáq sileh, alứng tớq nha-án sáng ngai-acái crau cariau yứng lư idô: “Ô-sana! Lư ayô án ndon te tŏ́ng toiq puo Davit!” ");
INSERT INTO pac_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iki nha-án plốh Yê-su idô: “Thới sáng lớiq, te máh ngai-acái ndô crau cariau?” Yê-su ôi nha-án idô: “Cư sáng. Imo arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng? Án khoiq tông idô: ‘Yang Arbang-pilŏ́ng ơi, inha táq dyôn ngcang ngai-acái díh nha-án ndon yôl uq tóh cứh ayô inha.’” ");
INSERT INTO pac_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Cua ngki Yê-su ngốh te nha-án, alứng pôq nga vel Bê-thani loi. Idáu ngki án bíq tớq vel ngki. ");
INSERT INTO pac_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ang iláih parnô, ndóng Yê-su pôq tớq carna ính chô lieh nga vel Yaru-salem, án sáng pinhaih. ");
INSERT INTO pac_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Án hôm tôm tarúng tớq tor carna, dyơ án pôq tumán tôm ngki. Án hôm nưm ula, ớq culái. Iki án tông ada tôm ngki idô: “Te hoi-ngki tingôi chô-mát mái lớiq cơt culái nnáng!” Ndóng ngki táp tôm ngki cơt ráng. ");
INSERT INTO pac_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tư top rian te Yê-su hôm arnáq ngki, nha-án sáng dut lư, dyơ nha-án plốh Yê-su idô: “Co imo tôm ndô cơt ráng chái lư?” ");
INSERT INTO pac_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yê-su ôi idô: “Cư tông inha arlớih lư, khán inha tin khớm alứng lớiq bôn mít cathơn-thơn, inha têq táq muchứng cư khoiq táq ada tôm ndô tưi. Alứng inha têq táq arnáq cannŏ́h hơ. Inha têq yua cóh ndô idô: ‘Mái arơq bôm alứng pŏ́ng tớq dơq ving-cavang.’ Dyơ lư cơt iki. ");
INSERT INTO pac_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Khán inha lư tin, nốh amớh inha cớu seq, inha lư bôn nốh ngki.” ");
INSERT INTO pac_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yê-su mot lieh nga ngcưm Dúng Sang Pưt. Ndóng án cato máh ticuoi tớq ngki, bôn máh ticuoi sút top teng rit sang alứng máh ticuoi sút tớq sớu tớq nga ngki tưi, alứng nha-án plốh Yê-su idô: “Te mmo thới bôn chức táq arnáq ndô? Nnáu dyôn thới bôn chức ndô?” ");
INSERT INTO pac_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yê-su ôi nha-án idô: “Cư ính plốh inha mui nốh tưi. Khán inha ôi cư, cư táq-ntêr dyôn inha chom nnáu dyôn cư bôn chức táq arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Arnáq tíc na dơq Yon táq, te mmo án bôn chức ngki, te Yang Arbang-pilŏ́ng lớiq la te ticuoi?” Dyơ nha-án tanghúng idô: “Khán he ôi án: ‘Arnáq tíc na dơq ndô tớq te Yang Arbang-pilŏ́ng,’ cumáiq án plốh lieh he idô: ‘Khán iki, imo inha lớiq tin Yon?’ ");
INSERT INTO pac_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma khán he ôi án idô: ‘Arnáq tíc na dơq ndô chóng tớq te ticuoi,’ ngki he adáh ticuoi prái, co nha-án tin, Yon la ticuoi tang ngcang Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iki nha-án ôi Yê-su idô: “He lớiq chom.” Dyơ Yê-su ôi lieh nha-án idô: “Dyơ! Cư lớiq táq-ntêr tưi dyôn inha chom nnáu dyôn cư bôn chức têq táq arnáq ndô.” ");
INSERT INTO pac_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Amớh inha parngíh te parnai acám ndô? Bôn munáq conh ndon bôn bar lám acái conh. Dyơ a-ám tớq nga án ndon ai, alứng yua idô: ‘Acái ơi! Ingái ndô mái pôq táq arnáq tớq nưong he, nư anoq.’ ");
INSERT INTO pac_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Acái án ôi idô: ‘Cư lớiq ính pôq.’ Ma tatun loi án parngíh lieh; dyơ án pôq táq. ");
INSERT INTO pac_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Dyơ a-ám ngki tớq nga án ndon a-em loi, alứng yua án muchứng ngki tưi. Án ôi idô: ‘Ơq.’ Ma án lớiq pôq. ");
INSERT INTO pac_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Te bar náq acái conh ngki, án mmo táq veng a-ám nha-án yua?” Nha-án ôi Yê-su idô: “Án ndon ai.” Dyơ Yê-su tông loi idô: “Cư tông inha arlớih lư, máh ticuoi ial práq thêq alứng máh cán táiq cháq bôn mot nsuoi inha tớq top Yang Arbang-pilŏ́ng sút. ");
INSERT INTO pac_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Co Yon khoiq tớq alứng apáh dyôn inha chom carna tinớng ŏ, ma inha lớiq tin parnai án. Ma máh ticuoi ial práq thêq alứng máh cán táiq cháq tin parnai án. Inha khoiq hôm dyơ máh arnáq ngki, ma inha nnáng lớiq ngin luaih pien cơt mít tamme loi, alứng lớiq tin máh parnai án cato.” ");
INSERT INTO pac_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Inha cammáng mui parnai acám cannŏ́h loi idô: Bôn munáq ticuoi chóh ntớng nho tớq nưong. Án táq carrong paniar nưong. Án píq prúng alứng tabôt búl caviel prúng, ien dếq culái nho dyôn dơq hoi tớq prúng ngki. Alứng án táq panu hơ tớq nưong. Cua ngki án dyôn ticuoi cannŏ́h táq dơ nưong án. Alứng nha-án sŏ́ng chúng munơi máh culái tớq nưong ngki. Cua ngki án pôq nga cruong cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tớq ngư culái nho dom, án yua máh ticuoi sol pôq ial phê án te nha-án ndon táq dơ nưong. ");
INSERT INTO pac_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma ticuoi táq dơ nưong cŏp máh ticuoi sol ngki. Án ndon nha-án tính. Án ndon nha-án cachet. Án ndon nha-án alpóh tớq búl. ");
INSERT INTO pac_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dyơ ưlla ngki yua máh ticuoi sol cannŏ́h loi pôq ial, clứng hơn te nsuoi. Ma nha-án ndon táq dơ nưong táq ada máh ticuoi ngki muchứng te nsuoi sa. ");
INSERT INTO pac_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tớq talloiq tháng, ưlla ngki yua acái conh án táp pôq nga ticuoi táq dơ nưong. Án parngíh idô: ‘Nha-án lư dyám náp acái conh cư.’ ");
INSERT INTO pac_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ma tư ticuoi táq dơ nưong hôm acái conh ưlla nưong tớq, nha-án tanghúng idô: ‘Án ndô la acái tŏ́ng ưlla. He! He cachet viang án. Dyơ máh mun án cơt na he nhéq!’ ");
INSERT INTO pac_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dyơ nha-án cŏp acái conh ưlla, lúq ndŏ́h angốh án te nưong, alứng cachet án. ");
INSERT INTO pac_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Iki, tớq ưlla ngki pôq nga nưong, amớh án ính táq ada nha-án táq dơ nưong án?” ");
INSERT INTO pac_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Máh ticuoi ngki ôi Yê-su idô: “Lư án cachet nhéq máh ticuoi lớiq ŏ ngki. Dyơ án dyôn ticuoi cannŏ́h loi táq dơ nưong án. Tớq ngư culái nho dom, ticuoi ngki lư mpô culái nho dyôn án.” ");
INSERT INTO pac_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dyơ Yê-su tông lieh nha-án idô: “Imo arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô: Cúc búl ticuoi táq dúng khoiq adúh, búl ngki cơt búl lác tớq tol dúng. Arnáq ndô la arnáq Yang Arbang-pilŏ́ng táq, alứng cơt arnáq ŏ lư chứng mát he. ");
INSERT INTO pac_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iki cư tông inha idô: Yang Arbang-pilŏ́ng lớiq dyôn inha mot tớq top án sút, ma án dyôn ticuoi cannŏ́h loi mot. Máh ticuoi ngki ính lư táq arnáq ŏ, cơt arớq cuteq ama culái ŏ. ");
INSERT INTO pac_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ticuoi mmo dứm tớq búl ndô, án prớm lớng. Ma khán búl ndô atôh piaiq cháq ticuoi mmo, cháq ticuoi ngki alíq tháng.” ");
INSERT INTO pac_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tư máh ticuoi sút top teng rit sang alứng máh ticuoi Pha-rasi sáng Yê-su tông máh parnai acám ngki la acám te nha-án. ");
INSERT INTO pac_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Iki nha-án suo ngê ính cŏp Yê-su, ma nha-án adáh ticuoi prái, co máh ticuoi prái tin Yê-su la ticuoi tang ngcang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yê-su cato tớq parnai acám sa idô: ");
INSERT INTO pac_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yang Arbang-pilŏ́ng cơt sút la arớq puo tiráp tiríng asớr campái dyôn acái conh án. ");
INSERT INTO pac_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Án yua máh prái tarráih án pôq cớiq máh ticuoi ndon án khoiq mơi dyôn tớq cha arsuoi. Ma máh ticuoi ngki lớiq ính tớq. ");
INSERT INTO pac_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Iki án yua prái tarráih cannŏ́h loi pôq, alứng patáp nha-án idô: ‘Inha tông máh ticuoi ndon cư khoiq mơi idô: “Puo he tiráp tiríng cua dyơ dŏq cha arsuoi. Carrŏ́q tangcáh alứng carrŏ́q lơ-lơ plứm ŏ, án khoiq kiac cua dyơ; alứng cứp arnáq la án khoiq thuan cua dyơ. Iki seq mơi inha tớq hớu cha arsuoi.’” ");
INSERT INTO pac_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ma máh ticuoi ndon puo khoiq mơi lớiq cammáng. Nha-án ính lư táq nưm arnáq nha-án sớng. Án ndon pôq táq pidái. Án ndon pôq táiq plới. ");
INSERT INTO pac_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Máh ticuoi cannŏ́h cŏp prái tarráih na puo. Nha-án tính alứng cachet hơ. ");
INSERT INTO pac_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iki puo sáng uan lư. Dyơ án yua máh líng án pôq cachet lieh máh ticuoi ndon khoiq cachet prái tarráih án. Alứng máh líng ngki chŏ́ng nhéq vel nha-án. ");
INSERT INTO pac_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dyơ puo arô lieh máh prái tarráih án alứng patáp idô: ‘Arnáq cha arsuoi khoiq tiráp tiríng cua dyơ. Ma máh ticuoi ndon cư khoiq mơi lớiq piaiq tớq hớu cha arsuoi ndô. ");
INSERT INTO pac_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hoi-ngki inha pôq cứp paryéh. Ticuoi mmo inha tumúh, inha mơi ticuoi ngki dyôn tớq hớu cha arsuoi ndô.’ ");
INSERT INTO pac_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iki máh prái tarráih puo pôq nga carna. Ticuoi mmo nha-án tumúh, nha-án dông ticuoi ngki tớq hớu cha arsuoi puo táq. Nha-án dông máh ticuoi ŏ alứng máh ticuoi lớiq ŏ hơ. Iki tớq callúng ndon puo khoiq thuan dŏq ính cha arsuoi, bôn tot máng ticuoi. ");
INSERT INTO pac_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tư puo mot tớq callúng máh ticuoi tớq hớu arsuoi át, ma án hôm munáq lớiq bôn sứp au ngai báq tớc pôq cha arsuoi. ");
INSERT INTO pac_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dyơ án plốh ticuoi ngki idô: ‘Yớu ơi! Imo mái tớq hớu cha arsuoi ma lớiq sứp au ngai báq tớc ndóng hớu cha arsuoi?’ Ma ticuoi ngki lớiq chom ôi amớh. ");
INSERT INTO pac_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dyơ puo yua prái tarráih án idô: ‘Inha chóq dyưng ati ticuoi ndô, alứng ardyóng adúh án te ndô nga ntúq ngiau. Ntúq ngki ngai nhiem cucloiq, alứng caltưat kineng tabang co sáng dieiq arức lư.’” ");
INSERT INTO pac_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dyơ Yê-su tông loi idô: “Bôn clứng ticuoi ndon Yang Arbang-pilŏ́ng khoiq arô, ma bôn biq náq sớng án rêh.” ");
INSERT INTO pac_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Vít ngki top Pha-rasi pôq tanghúng, dyơ nha-án sisuo ngê ính táq dyôn Yê-su táq-ntêr thét. ");
INSERT INTO pac_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nha-án yua ticuoi te top nha-án alứng te top Hê-rôt tớq nga Yê-su. Máh ticuoi ngki tông Yê-su idô: “Thới ơi! He chom dyơ thới la ticuoi tinớng. Alứng thới cato piaiq lư te ngê Yang Arbang-pilŏ́ng. Chứng mát thới nhéq máh ticuoi la li-arli. Co iki thới lớiq dyám náp ticuoi bôn chức. ");
INSERT INTO pac_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iki he seq thới tông he. Amớh thới parngíh, piaiq ma lớiq he cóq dyôn práq thêq nga puo Rô-ma?” ");
INSERT INTO pac_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Yê-su chom nha-án chim án, ính án lớiq chom ôi. Iki án tông ada nha-án idô: “Inha la ticuoi náh-nnan! Imo inha sisuo talíh te cư? ");
INSERT INTO pac_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Inha dông dyôn cư me práq thêq ngki!” Dyơ nha-án dông nga Yê-su me mui callong práq. ");
INSERT INTO pac_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yê-su plốh nha-án idô: “Rớp ndô alứng tarran ndô arớq nnáu?” ");
INSERT INTO pac_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nha-án ôi idô: “Puo Rô-ma.” Dyơ Yê-su tông nha-án idô: “Crơng puo Rô-ma, inha culieh lieh dyôn puo Rô-ma, alứng crơng Yang Arbang-pilŏ́ng cóq inha culieh lieh dyôn Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ndóng nha-án sáng Yê-su ôi iki, nha-án sáng dut lư. Dyơ nha-án ngốh te Yê-su, pôq nga ntúq cannŏ́h loi. ");
INSERT INTO pac_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ingái ngki bôn máh ticuoi te top Sa-dusê tớq nga Yê-su. Nha-án tông ticuoi khoiq cuchet lớiq têq tumống lieh. ");
INSERT INTO pac_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nha-án tông Yê-su idô: “Thới ơi! Môi-se khoiq taran tông he idô: ‘Khán munáq conh cuchet, ma án iyốh bôn acái, munáq te em ai án cóq atŏ́ng campái án, dŏq pitŏ́ng lieh acái dyôn ai án ndon khoiq cuchet.’ ");
INSERT INTO pac_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tớq top he bôn tupul náq em ai. Án ndon ai pông khoiq ial campái. Ma án cuchet iyốh bôn acái. Iki a-em pandi cóq atŏ́ng campái ai. ");
INSERT INTO pac_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Alứng muchứng ngki tưi te a-em pandi tingôi a-em tuloiq. Nhéq em ai ngki atŏ́ng campái ai, alứng nha-án cuchet tưi. ");
INSERT INTO pac_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tớq talloiq tháng, cán ngki cuchet tưi. ");
INSERT INTO pac_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tư máh ticuoi cuchet bôn tumống lieh, cán ngki cơt campái nnáu, co nha-án tupul náq em ai bôn ưlla nhéq cán ngki?” ");
INSERT INTO pac_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yê-su ôi nha-án idô: “Inha táq-ntêr lớiq crái, co inha lớiq chom arlớih te parnai Yang Arbang-pilŏ́ng khoiq taran te inớh, alứng inha lớiq chom díh chức pưt lư na Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tư ticuoi cuchet bôn tumống lieh, nha-án lớiq cơt nnáng campái cayieq, ma nha-án cơt muchứng top tarneng Yang Arbang-pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma te arnáq ticuoi khoiq cuchet bôn tumống lieh, imo arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô: ");
INSERT INTO pac_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Cư la Yang Arbang-pilŏ́ng ndon A-praham sang, I-sac sang, alứng Yacốp sang.’ He chom ticuoi cuchet lớiq têq sang nnáng Yang Arbang-pilŏ́ng, nưm ticuoi tumống sớng têq sang án.” ");
INSERT INTO pac_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tư ticuoi clứng sáng Yê-su tông iki, nha-án sáng dut lư te máh parnai án tông. ");
INSERT INTO pac_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tớq top Pha-rasi sáng Yê-su ôi tingôi táq dyôn top Sa-dusê cớng ngcang, iki nha-án parchúng tanghúng. ");
INSERT INTO pac_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bôn munáq te ticuoi ngki la thới pasoi phep rit Isa-ra-el. Án tớq alứng plốh co ính chim Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Án plốh idô: “Thới ơi! Tớq phep rit he, bôn parnai patáp amớh pưt clưi nhéq te cannŏ́h?” ");
INSERT INTO pac_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yê-su ôi án idô: “Cóq inha amoih Yang Arbang-pilŏ́ng Ưlla inha nhéq te mít cannính, nhéq te tarngứh tarhơ, alứng nhéq te parngíh inha. ");
INSERT INTO pac_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Parnai patáp ndô pưt clưi nhéq te parnai patáp cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Alứng parnai patáp bar pưt clưi te cannŏ́h la idô: ‘Cóq inha amoih yớu muchứng inha amoih cháq inha bôm.’ ");
INSERT INTO pac_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Khán inha bôn bar parnai patáp ndô, lư inha bôn nhéq cứp nốh te phep rit Yang Arbang-pilŏ́ng khoiq patáp na Môi-se, alứng nhéq parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq cato.” ");
INSERT INTO pac_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ndóng top Pha-rasi yôl át tanghúng tớq ntúq ngki, Yê-su plốh nha-án idô: ");
INSERT INTO pac_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Amớh inha parngíh te munáq Crit? Án la te tŏ́ng toiq nnáu?” Nha-án ôi idô: “Án la te tŏ́ng toiq puo Davit.” ");
INSERT INTO pac_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iki Yê-su plốh sa: “Khán iki, imo Arvai Yang Arbang-pilŏ́ng dyôn puo Davit dŏq Crit la ‘Ưlla’? Co te inớh puo Davit khoiq tông idô: ");
INSERT INTO pac_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yang Arbang-pilŏ́ng tông tớq Ưlla cư idô: “Mái ticu pa atớm cư tingôi ingái cư mŏp nha-án ndon ính cachet mái, át tadưp allang dyưng mái.”’ ");
INSERT INTO pac_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Khán Davit dŏq Crit la Ưlla, ngki imo têq Davit dŏq ticuoi te tŏ́ng toiq án bôm la Ưlla?” ");
INSERT INTO pac_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Cua Yê-su tông iki, ngai lớiq chom ôi mui callong amớh nnáng. Alứng náp te ingái ngki ngai lớiq dáh plốh nnáng án. ");
INSERT INTO pac_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cua ngki Yê-su cato máh ticuoi clứng alứng top rian te án idô: ");
INSERT INTO pac_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Thới sái rit alứng ticuoi Pha-rasi tang Môi-se cơt ticuoi cato inha. ");
INSERT INTO pac_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iki, cóq inha peh alứng veng tapun máh parnai nha-án cato inha. Ma inha êq soi máh arnáq nha-án táq, co nha-án cato nưm na ngcang, ma nha-án lớiq táq arớq nha-án cato. ");
INSERT INTO pac_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nha-án cato inha dyôn veng phep rit dieiq lư, cơt arớq nha-án dyôn inha dual crơng ntáng. Ma ati nha-án lớiq bôn arơq choi amớh crơng ntáng te inha. ");
INSERT INTO pac_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Cứp arnáq nha-án táq, nha-án ính ticuoi cannŏ́h hôm. Nha-án cacháq parnai Yang Arbang-pilŏ́ng tớq hop ngcár pưt hơn te ticuoi cannŏ́h. Dyơ nha-án chóq hop ngki tớq prŏ́ng alứng tian tớq payiel. Alứng nha-án táq paryoi tớq au thor nha-án toiq hơn te ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nha-án ính lư ticu pa tanieng tớq ngai mơi nha-án tớq cha. Alứng nha-án ính bôn kichơng ticu ŏ clưi nhéq te cannŏ́h tớq dúng rum. ");
INSERT INTO pac_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nha-án ính ticuoi cannŏ́h pasôl ŏ ndóng nha-án át alứng ticuoi clứng. Alứng nha-án ính ngai dŏq nha-án la thới. ");
INSERT INTO pac_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma inha êq suo ính ticuoi cannŏ́h dŏq inha la thới, co inha bôn nưm munáq sớng thới, alứng nhéq náq inha la em ai. ");
INSERT INTO pac_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Alứng inha êq dŏq ticuoi tớq cúc cuteq ndô la A-ám inha, co inha bôn nưm munáq A-ám sớng, án ndon át tớq pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Alứng inha êq suo ính ticuoi cannŏ́h dŏq inha la ticuoi sút, co inha bôn nưm munáq sút sớng. Án la Crit. ");
INSERT INTO pac_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Khán bôn ticuoi tớq top inha ma ính cơt pưt clưi nhéq te ticuoi cannŏ́h, cóq ticuoi ngki cơt prái tarráih inha. ");
INSERT INTO pac_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ticuoi mmo ma asớr cháq bôm, urớh ticuoi ngki cơt két. Alứng ticuoi mmo ma asiar cháq bôm, urớh ticuoi ngki cơt pưt. ");
INSERT INTO pac_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Bap lư tớq nga inha thới sái rit alứng ticuoi Pha-rasi, la ticuoi táq náh-nnan! Co inha catáng ticuoi lớiq dyôn mot tớq top Yang Arbang-pilŏ́ng sút. Inha lớiq ính mot, iki inha catáng ticuoi cannŏ́h lớiq dyôn mot tưi! ");
INSERT INTO pac_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Bap lư tớq nga inha thới sái rit alứng ticuoi Pha-rasi, la ticuoi táq náh-nnan! Co inha lop máh dúng cán cammai, alứng inha cớu toiq ính ngai tông inha la tinớng ŏ. Co iki, chô-mát tôt inha ntáng hơn te ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Bap lư tớq nga inha thới sái rit alứng ticuoi Pha-rasi, la ticuoi táq náh-nnan! Inha pôq a-ưi ntúq dŏq suo ticuoi dyôn veng ngê inha. Tư nha-án veng ngê inha, ngki inha táq dyôn nha-án cơt saq hơn te inha; inha táq dyôn nha-án cóq chiuq bar chư hơn te inha át tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Bap lư tớq nga inha ndon arớq ticuoi sot mát, ma ính ayông ticuoi cannŏ́h. Inha tông ticuoi cannŏ́h idô: ‘Khán ticuoi mmo cantŏ́h callih bôiq nốh Dúng Sang Pưt, án lớiq táq veng parnai ngki la têq. Ma khán ticuoi mmo cantŏ́h callih bôiq nốh dyeng tớq Dúng Sang Pưt, án cóq táq veng parnai án khoiq cantŏ́h ngki.’ ");
INSERT INTO pac_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ticuoi achơ alứng sot mát ơi! Nốh mmo pưt hơn, dyeng lớiq la Dúng Sang Pưt, ndon táq dyôn dyeng ngki cơt mmar na Yang Arbang-pilŏ́ng? ");
INSERT INTO pac_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Alứng inha tông idô hơ: ‘Khán ticuoi mmo cantŏ́h callih bôiq nốh parông sang tớq Dúng Sang Pưt, án lớiq táq veng parnai ngki la têq. Ma khán ticuoi mmo cantŏ́h callih bôiq nốh crơng sang tớq parông, ngki cóq án táq veng.’ ");
INSERT INTO pac_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Inha la arớq ticuoi sot mát! Nốh mmo pưt hơn, crơng mŏp sang lớiq la parông sang, ndon táq dyôn crơng ngki cơt mmar na Yang Arbang-pilŏ́ng? ");
INSERT INTO pac_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iki, khán ticuoi mmo cantŏ́h callih bôiq nốh parông, la muchứng án khoiq cantŏ́h ada crơng sang tớq parông ngki tưi. ");
INSERT INTO pac_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Alứng khán ticuoi mmo cantŏ́h callih bôiq nốh Dúng Sang Pưt, la muchứng án khoiq cantŏ́h callih ada Yang Arbang-pilŏ́ng tưi, co Dúng Sang ngki la ntúq Yang Arbang-pilŏ́ng át. ");
INSERT INTO pac_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Alứng khán ticuoi mmo cantŏ́h callih bôiq nốh pilŏ́ng, la muchứng án khoiq cantŏ́h callih bôiq ntúq Yang Arbang-pilŏ́ng ticu, alứng án ndon ticu cơt sút ngki. ");
INSERT INTO pac_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Bap lư tớq nga inha thới sái rit alứng ticuoi Pha-rasi, la ticuoi táq náh-nnan! Co inha mŏp sang dyôn Yang Arbang-pilŏ́ng mui phê te bát bai asai akieu inha, ma inha lớiq peh máh callong pưt hơn tớq phep rit Yang Arbang-pilŏ́ng. Callong pưt ngki la idô: Cóq inha táq arnáq tinớng tupứng, cóq bôn mít cannính sruiq táq ticuoi cannŏ́h, alứng cóq táq arnáq piaiq dyôn ticuoi cannŏ́h têq tin inha. Cư lớiq bôn yua inha táh arnáq mŏp sang, ma máh nốh pưt hơn la cóq inha táq. ");
INSERT INTO pac_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Inha la arớq ticuoi sot mát ma ính ayông ticuoi cannŏ́h! Inha dyớq anhui te dơq ngoiq, ma khán bôn pannán lac-da, ngki inha lôn táp.” ");
INSERT INTO pac_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Bap lư tớq nga inha thới sái rit alứng ticuoi Pha-rasi, la ticuoi táq náh-nnan! Co inha bôn mít cannính arớq tingan alứng adien ngai arau ính práh nưm culái tieh, ma tớq callúng bôn máng prớq. Prớq ngki la acám te inha tarpún alứng cha ngoiq thưong. ");
INSERT INTO pac_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ơ máh ticuoi Pha-rasi ơi, inha la arớq ticuoi sot! Nsuoi lư cóq inha arau tingan dyôn práh pa callúng avai. Khán inha táq iki, pa tieh tingan lư práh tưi! ");
INSERT INTO pac_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Bap lư tớq nga inha thới sái rit alứng ticuoi Pha-rasi, la ticuoi táq náh-nnan! Inha la arớq ping cumuiq ngai sa táq práh ŏ lư. Culái tieh ping la ŏ alứng amaiq lư, ma tớq callúng ping bôn máng nghang alứng nnáq túng-búng tháng. ");
INSERT INTO pac_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Inha la muchứng ngki tưi. Inha ính ticuoi cannŏ́h tông inha la tinớng ŏ, ma mít cannính inha bôn máng callong luaih, alứng inha táq náh-nnan sớng. ");
INSERT INTO pac_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Bap lư tớq nga inha thới sái rit alứng ticuoi Pha-rasi, la ticuoi táq náh-nnan! Inha táq ping ŏ dyôn ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh. Alứng inha táq amaiq lư máh ping ticuoi tinớng ŏ. ");
INSERT INTO pac_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Alứng inha báq lư tông idô: ‘Khán he át mui prôq alứng achúc achiac he te inớh, he lư lớiq táq arớq nha-án ndon cachet máh ticuoi tang ngcang ngki.’ ");
INSERT INTO pac_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tớq inha tông iki, inha ngin inha la ticuoi te tŏ́ng toiq ticuoi ndon khoiq cachet ticuoi tang ngcang ngki. ");
INSERT INTO pac_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Áu, inha pôq táp! Inha táq dyôn cua nhéq máh arnáq achúc achiac inha! ");
INSERT INTO pac_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Inha la ticuoi ndon bôn mít cannính lới lư, pla arớq cusánh. Lư inha lớiq têq viar vít te Yang Arbang-pilŏ́ng sưq inha, alứng ardyóng adúh inha tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iki cư tông inha idô: Urớh cư yua máh ticuoi tang ngcang cannŏ́h, máh ticuoi tubáiq, alứng máh thới tớq nga inha. Bôn ticuoi te top ngki, inha ính cachet alứng téh tớq along calláng. Án ndon inha ính tính tớq dúng sang. Alứng án ndon inha ính chuih angốh te vel ndô dyôn át nga vel tutíh. ");
INSERT INTO pac_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iki tôt nha-án ndon khoiq cachet ticuoi tinớng ŏ tớq cuteq ndô, Yang Arbang-pilŏ́ng ính dyôn inha tamprêq tưi tôt ngki, co inha la tŏ́ng toiq nha-án. Tôt ngki bôn te ingái nha-án cachet Aben la ticuoi tinớng ŏ te inớh, alứng tingôi tớq ingái nha-án cachet Sa-chari la acái conh Ba-rachi. Inha khoiq cachet Sa-chari tớq callúng Dúng Sang Pưt, tumán parông sang. ");
INSERT INTO pac_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cư tông inha arlớih lư, cứp nốh tôt ngki tớq nga inha ndon át tớq pang ndô! ");
INSERT INTO pac_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ơ ticuoi tớq vel Yaru-salem, ticuoi tớq vel Yaru-salem ơi! Inha la ticuoi báq cachet ticuoi tang ngcang Yang Arbang-pilŏ́ng, alứng inha alpóh tớq búl ada máh ticuoi Yang Arbang-pilŏ́ng yua dyôn tớq nga inha. Bôn a-ưi chư dyơ cư ính pachúng parŏm nhéq máh inha arớq ntruoi icán catrốc arô acái dyôn át tadưp nnár án. Ma inha lớiq ính! ");
INSERT INTO pac_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Co iki Dúng Sang Pưt inha piaiq ngai táh, dyơ cơt arngol. ");
INSERT INTO pac_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cư tông inha idô: Te hoi-ngki tingôi chô-mát, inha lớiq bôn hôm nnáng cư, tingôi tớq ingái inha tông idô: ‘Bún lư án ndon tớq táq arnáq nhơ nốh Ưlla he.’” ");
INSERT INTO pac_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tư Yê-su ngốh te Dúng Sang Pưt, dyơ án ticaq na carna, top rian te án tớq nga án alứng turô dyôn án me máh dúng ndon át tớq callúng carrống paniar Dúng Sang Pưt. ");
INSERT INTO pac_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yê-su tông nha-án idô: “Inha hôm máh dúng pưt ndô lớiq? Chô-mát búl ngai táq dúng pưt ndô lớiq bôn tarkít nnáng munơi, ma cơt partáh nhéq.” ");
INSERT INTO pac_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ndóng Yê-su ticu tớq king O-li-vê, nưm top rian te án tớq nga án alứng plốh án idô: “Thới ơi! Seq thới tông he nnáng dưnh máh-mmo arnáq ndô tớq? Bôn tíc amớh apáh dyôn he chom te thới tớq lieh nga cúc cuteq ndô, alứng ingái talloiq?” ");
INSERT INTO pac_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yê-su ôi nha-án idô: “Cóq inha át dyôn ahôi. Êq dyôn ngai pilốh inha. ");
INSERT INTO pac_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chô-mát bôn a-ưi náq tớq alứng bôiq nốh cư, díh tông idô: ‘Cư táp la Crit!’ Alứng nha-án pilốh ticuoi a-ưi lư. ");
INSERT INTO pac_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tư inha sáng parhanh ngai tarchíl tumán-mán yông-yông, inha êq crŏ́q amớh. Arnáq ndô cóq tớq nsuoi avai. Ma iyốh tớq ingái talloiq tháng. ");
INSERT INTO pac_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Top ndô ính tarchíl tartáq alứng top ngki; cruong ndô ính tarchíl tartáq alứng cruong ngki. Bôn a-ưi ntúq ớq tanna cha. Alứng bôn a-ưi ntúq cuteq arsáu alứng cacưt. ");
INSERT INTO pac_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Máh nốh ngki tớq nsuoi avai, arớq cán mbơiq sáng a-ái ndóng ính cuop cumo. Ma yôl bôn a-ưi nốh dieiq arức loi ính tớq tatun. ");
INSERT INTO pac_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tớq máh ingái ngki, ngai ính mŏp inha nga ati ticuoi lớiq ŏ dyôn nha-án ariaq alứng cachet. Alứng nhéq tưh ticuoi a-ính inha, la co tian inha veng ngê cư. ");
INSERT INTO pac_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ndóng ngki bôn a-ưi náq ticuoi khoiq veng ngê cư, nha-án táh viang ngê cư, co lớiq rap veng tapun nnáng. Nha-án munáq cauq munáq dyôn ticuoi sút cachet; alứng munáq a-ính munáq. ");
INSERT INTO pac_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bôn a-ưi náq ticuoi tớq, alứng ngin nha-án la ticuoi tang ngcang Yang Arbang-pilŏ́ng. Ma nha-án táq-ntêr a-uai sớng, co ính tardông clứng ticuoi arbúc tớq ngê nha-án. ");
INSERT INTO pac_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Co ngê saq pôq pláh cứp ntúq, iki ticuoi ndon munáq amoih munáq te nsuoi, cơt lớiq amoih nnáng. ");
INSERT INTO pac_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma máh ticuoi ndon rap tanhir tingôi sút pang tumống nha-án, Yang Arbang-pilŏ́ng lư choi tamống nha-án. ");
INSERT INTO pac_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Urớh lư bôn ticuoi pôq cato parnai ŏ te Yang Arbang-pilŏ́ng cơt sút nga cứp cruong tớq cúc cuteq ndô, dyôn máh ticuoi têq chom. Cua ngki lư tớq ingái talloiq tháng.” ");
INSERT INTO pac_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Urớh inha hôm máh nốh ndon Daniel la ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông te inớh. Daniel tông acớiq, la bôn ticuoi dông dŏq crơng prớq nga Dúng Sang Pưt ndon Yang Arbang-pilŏ́ng lớiq ính me. (Ticuoi mmo dŏc parnai ndô, cóq parngíh dyôn simớt.) ");
INSERT INTO pac_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ingái ngki máh ticuoi tớq vúng Yudê, cóq lúh sớr át nga cóh loi. ");
INSERT INTO pac_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Án ndon át tớq mpuong dúng, êq siar alứng mot ial nnáng crơng te dúng. ");
INSERT INTO pac_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Án ndon át tớq pidái, êq chô ial nnáng tampớc te dúng. ");
INSERT INTO pac_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tớq ingái ngki, toiq bap lư nha-án ndon át cháq-iki, alứng nha-án ndon a-uq acái. ");
INSERT INTO pac_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Iki, cóq inha cớu seq êq dyôn inha lúh tớq kisái ngngiat alứng tớq Ingái Angô. ");
INSERT INTO pac_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tớq ingái ngki bôn dieiq arức hơn te tôm Yang Arbang-pilŏ́ng teng pilŏ́ng cuteq tingôi tớq hoi-ndô. Alứng urớh, lớiq bôn nnáng dieiq arức arớq ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Khán Yang Arbang-pilŏ́ng lớiq bôn aroiq lieh máh ingái ngki, lư lớiq bôn nnáu têq tumống nnáng. Ma co án ính choi máh ticuoi án khoiq rêh, iki án aroiq lieh máh ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Khán ngai tông inha idô: ‘Ndô! Án ndon át ndô la lư Crit!’, lớiq la ‘Tutíh! Án ndon át nga ngki la lư Crit!’, inha êq náp parnai ngki. ");
INSERT INTO pac_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Co urớh bôn ticuoi tới lư Crit, alứng tới lư ticuoi tang ngcang Yang Arbang-pilŏ́ng, ính tớq. Nha-án ính táq tíc sileh alứng arnáq laq lư, dŏq pilốh tarthu inha. Khán têq, nha-án ính pilốh díh ticuoi ndon Yang Arbang-pilŏ́ng khoiq rêh hơ. ");
INSERT INTO pac_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cóq cammáng! Cư tông inha dyôn chom nsuoi te máh arnáq ngki iyốh tớq. ");
INSERT INTO pac_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Iki, khán bôn ngai tông inha idô: ‘Tutíh! Bôn munáq Crit át tớq ntúq aih!’, inha êq pôq nga ntúq ngki. Lớiq la khán nha-án tông idô: ‘Tutíh! Munáq Crit át catốq tớq dúng ngki!’, inha êq náp. ");
INSERT INTO pac_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Co cư Acái Yang Cơt Ticuoi tớq, la arớq lilaiq cáng te pứp mát pandang ngốh tớq pứp mát pandang pát. ");
INSERT INTO pac_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ntúq mmo bôn ticuoi cuchet, ntúq ngki lư bôn calang srúp rum cha sáiq cumuiq.” ");
INSERT INTO pac_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yê-su tông loi idô: “Vít te máh ingái dieiq arức lư ngki, mát pandang lớiq bôn claq nnáng, alứng kisái lớiq bôn tráh nnáng. Pantôr atôh te pilŏ́ng, alứng máh nốh bôn chức tớq pilŏ́ng la arsáu nhéq. ");
INSERT INTO pac_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tớq ingái ngki tớq pilŏ́ng bôn tíc te Acái Yang Cơt Ticuoi. Dyơ nhéq tưh ticuoi tớq cúc cuteq ndô nhiem cucloiq co sáng adáh. Nha-án hôm cư Acái Yang Cơt Ticuoi tớq pandi tulúc bôn chức pưt alứng bôn rớp ang-ưr lư. ");
INSERT INTO pac_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bôn sieng tangcoi yứng lư, dyơ cư yua máh tarneng cư pôq pachúng cứp náq ticuoi ndon cư khoiq rêh te cứp anga, alứng te cứp ntúq pưn pilŏ́ng crôp ndô.” ");
INSERT INTO pac_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Inha cammáng, cư acám te tôm tarúng. Khán abeng along yôl nhom, án tambáiq acứp ula. Iki inha chom khoiq tumán ính tớq dyơ kisái puoq. ");
INSERT INTO pac_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Muchứng ngki tưi, khán inha hôm máh nốh ndô tớq, inha lư chom Acái Yang Cơt Ticuoi tumán ính tớq dyơ alứng khoiq tamŏ́c ngáh callống. ");
INSERT INTO pac_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cư tông inha arlớih lư, nhéq tưh ticuoi tớq pang ndô lớiq bôn pít nsuoi te máh nốh ngki tớq. ");
INSERT INTO pac_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Chô-mát pilŏ́ng alứng cuteq cơt pít, ma parnai cư tông lớiq nai pít.” ");
INSERT INTO pac_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Lớiq bôn ngai chom ingái mmo, lớiq la ndóng mmo arnáq ngki tớq. Máh tarneng alứng Acái Yang Arbang-pilŏ́ng la lớiq chom tưi ingái ngki. Nưm munáq A-ám cư táp chom ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Acái Yang Cơt Ticuoi tớq lieh nga cúc cuteq ndô la arớq pang Nô-ê te inớh. ");
INSERT INTO pac_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tớq pang Nô-ê, nsuoi arlám dơq ính tớq, máh ticuoi tớq pang ngki cha ngoiq bui ŏ lư. Nha-án ial campái cayieq muchứng te ưlling tingôi tớq ingái Nô-ê sớr tớq tuoc. ");
INSERT INTO pac_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nha-án lớiq chom amớh tháng te nốh ính tớq nga nha-án. Ma ndóng arlám dơq tớq, dyơ dơq ngki dông calúh nhéq nha-án. Ingái Acái Yang Cơt Ticuoi tớq lieh nga cúc cuteq ndô la muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ndóng ngki bôn bar náq conh át tớq pidái. Tarneng Yang Arbang-pilŏ́ng ial dông munáq, ma munáq loi, ngki án dŏq. ");
INSERT INTO pac_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Alứng ndóng ngki bôn bar náq cán cuclóh sro. Tarneng ial dông munáq, ma munáq loi, ngki án dŏq. ");
INSERT INTO pac_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iki cóq inha cayôn níc, co inha lớiq chom ingái mmo Ưlla inha tớq lieh nga inha. ");
INSERT INTO pac_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Cóq inha ayư dyôn simớt te callong ndô: Khán ticuoi ưlla dúng ma chom ndóng mmo ticuoi siveng ính mot titôiq tớq dúng án, án lư cayôn níc lớiq dyôn ticuoi siveng têq mot titôiq. ");
INSERT INTO pac_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iki cóq inha cayôn níc, co inha lớiq chom ndóng mmo cư Acái Yang Cơt Ticuoi tớq lieh. Cư lư tớq ndóng ingái inha lớiq bôn parngíh amớh te cư tớq.” ");
INSERT INTO pac_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Khán bôn prái tarráih tubáiq alứng tinớng tupứng, ưlla dúng lư chóh án dyôn cơt sút dŏq kiaq me nhéq máh prái tarráih cannŏ́h. Amớh ưlla yua án chiam, án lư chiam ngki. ");
INSERT INTO pac_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Khán prái tarráih táq piaiq máh arnáq ưlla yua án táq, án lư sáng bui ndóng ưlla án chô! ");
INSERT INTO pac_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cư tông inha arlớih lư, urớh ưlla ngki dyôn prái tarráih ngki kiaq me nhéq máh mun án. ");
INSERT INTO pac_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma khán prái tarráih ngki táq thét, dáh lơ án parngíh tớq mít idô: ‘Yôl dưnh ki-náq ưlla cư chô.’ ");
INSERT INTO pac_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Iki án tính máh ticuoi táq arnáq ưlla án, alứng án cha ngoiq munơi alứng ticuoi bol plêc. ");
INSERT INTO pac_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bôn mui ingái, ưlla ngki chô, ma prái tarráih ngki lớiq chom, alứng án lớiq parngíh amớh te ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Iki ưlla ngki ticŏ́h prái tarráih ngki a-ưi béq tớq dau. Alứng án dyôn prái tarráih ngki át munơi alứng ticuoi táq náh-nnan tớq ntúq ngai nhiem cucloiq alứng caltưat kineng tabang co sáng dieiq arức lư. ");
INSERT INTO pac_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ndóng ngki, Yang Arbang-pilŏ́ng cơt sút la arớq mui chít náq cumor carring. Nha-án ial den tớu, dyơ pôq côn án ndon ial campái. ");
INSERT INTO pac_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sông náq cumor la achơ, ma sông náq loi la tubáiq. ");
INSERT INTO pac_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nha-án ndon achơ ngki dông den tớu, ma nha-án lớiq bôn dông calưi tớu. ");
INSERT INTO pac_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma nha-án ndon tubáiq dông den tớu alứng dông calưi tớu tớq be hơ. ");
INSERT INTO pac_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iki án ndon ial campái dyut lư tớq. Dyơ máh cumor ngki, án ndon bíq tưt, án ndon bíq ngiar tháng. ");
INSERT INTO pac_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tớq tardi dáu ngai arô yứng lư idô: ‘Ngki! Án ndon ial campái khoiq tớq dyơ! Inha ngốh ráp án!’ ");
INSERT INTO pac_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nhéq máh cumor ngki ayư, alứng nha-án thuan den tớu nha-án. ");
INSERT INTO pac_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nha-án ndon achơ tông ada nha-án ndon tubáiq idô: ‘Seq inha cáh tớu inha dyôn he hơ, co den tớu he khoiq nhéq tớu dyơ.’ ");
INSERT INTO pac_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ma nha-án ndon tubáiq ôi idô: ‘He lớiq têq cáh mmớh. Dáh tớu he lớiq khám dyôn inha alứng he. Piaiq lư la inha pôq plới te ticuoi táiq tớu.’ ");
INSERT INTO pac_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma ndóng nha-án pôq plới, án ndon ial campái tớq. Dyơ sông náq cumor ndon yôl bôn tớu, bôn mot hớu cha arsuoi munơi alứng án ndon ial campái. Dyơ ngai catáng callống. ");
INSERT INTO pac_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Vít ngki, máh cumor ndon pôq plới tớu chô. Nha-án arô idô: ‘Ai tamme ơi! Ai tamme ơi! Pốh callống dyôn he mot tưi!’ ");
INSERT INTO pac_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma ai tamme ôi idô: ‘Cư tông inha arlớih lư, cư lớiq chom inha.’” ");
INSERT INTO pac_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dyơ Yê-su tông loi idô: “Iki, cóq inha át cayôn níc, co inha lớiq chom ingái mmo, alứng ndóng mmo Acái Yang Cơt Ticuoi tớq lieh nga cúc cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yang Arbang-pilŏ́ng cơt sút la arớq munáq conh pôq tumoi cruong yông. Ndóng án tumán ính pôq, án arô ticuoi táq arnáq án, alứng mŏp dyôn nha-án kiaq me práq mun án. ");
INSERT INTO pac_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Án dyôn cứp náq veng án parngíh ticuoi ngki têq táq. Munáq án dyôn sông nen. Munáq án dyôn bar nen. Ma munáq loi, án dyôn nưm mui nen sớng. Dyơ án pôq tumoi. ");
INSERT INTO pac_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Án ndon ráp sông nen pôq táiq plới táp. Dyơ án bôn lơi sông nen. ");
INSERT INTO pac_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Án ndon ráp bar nen táq muchứng ngki tưi, alứng án bôn lơi bar nen. ");
INSERT INTO pac_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma án ndon ráp nưm mui nen sớng, án píq prúng, dyơ án tứp práq ngki. ");
INSERT INTO pac_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Dưnh cumo lo kisái ưlla ngki píh chô. Án plốh lieh te máh práq án khoiq dyôn nga nha-án. ");
INSERT INTO pac_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ticuoi ndon khoiq ráp sông nen, án dông atớq sông nen loi nga ưlla án. Alứng án tông idô: ‘Ưlla ơi! Ưlla khoiq dyôn cư sông nen, ma hoi-ngki cư bôn lơi sông nen loi.’ ");
INSERT INTO pac_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ưlla ngki ôi án: ‘Máh arnáq mái táq la piaiq lư. Mái la ticuoi hôi alứng tinớng tupứng. Mái khoiq táq tinớng tupứng ada nốh két ndô. Iki cư dyôn mái bôn cơt ưlla a-ưi nốh pưt loi. Alứng cư dyôn mái bôn callong bui ơn át munơi alứng cư.’ ");
INSERT INTO pac_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ticuoi ndon khoiq ráp bar nen, án dông atớq bar nen cannŏ́h loi nga ưlla án. Alứng án tông idô: ‘Ưlla ơi! Ưlla khoiq dyôn cư bar nen, ma hoi-ngki cư bôn lơi bar nen loi.’ ");
INSERT INTO pac_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ưlla ngki ôi án idô: ‘Máh arnáq mái táq la piaiq lư. Mái la ticuoi táq arnáq ŏ alứng piaiq lư. Mái khoiq táq ŏ lư ada nốh két ndô. Iki cư dyôn mái bôn cơt ưlla a-ưi nốh pưt loi. Alứng cư dyôn mái bôn callong bui ơn át munơi alứng cư tưi.’ ");
INSERT INTO pac_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tatun ngki, ticuoi ndon khoiq ráp mui nen, án tớq tưi alứng tông idô: ‘Ưlla ơi! Cư chom ưlla la ticuoi cát lư. Ưlla lớiq chớt, ma ưlla ính sot. Ưlla lớiq táq, ma ưlla ính ial. ");
INSERT INTO pac_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cư adáh, iki cư dông tứp práq ưlla tớq cuteq. Hoi-ngki cư culieh lieh práq ngki dyôn ưlla.’ ");
INSERT INTO pac_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ưlla ngki ôi án idô: ‘Mái la ticuoi lới alứng aláh lư. Mái chom dyơ, cư lớiq chớt, ma cư ính sot. Cư lớiq táq, ma cư ính ial. ");
INSERT INTO pac_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Khán iki, ŏ hơn la mái dyôn ticuoi cannŏ́h váq práq cư. Dyơ tớq ingái cư píh chô, cư bôn práq ngki alứng bôn práq lơi hơ. ");
INSERT INTO pac_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Iki, cóq ial viang práq te ticuoi ndô, dyơ dyôn nga án ndon khoiq bôn mui chít nen. ");
INSERT INTO pac_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Co án ndon bôn, cư dyôn án bôn a-ưi lư loi, tingôi clưi tớc clưi cha. Ma án ndon lớiq bôn, ngki cư dyôn án ớq lớng. ");
INSERT INTO pac_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma ticuoi ndon ớq lơi, cóq ardyóng adúh án te ndô nga ntúq ngiau. Ntúq ngki ngai nhiem cucloiq alứng caltưat kineng tabang co sáng dieiq arức lư.’” ");
INSERT INTO pac_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Tư Acái Yang Cơt Ticuoi tớq lieh na bôn chức ang-ưr munơi alứng máh tarneng án, ndóng ngki án ticu tớq kichơng puo ndon ang-ưr. ");
INSERT INTO pac_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ndóng ngki, nhéq tưh ticuoi ính rum chứng mát án, alứng án ính cayáh nha-án cơt bar top, arớq ticuoi kiaq me cưu cayáh cưu te mbeq. ");
INSERT INTO pac_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dyơ án dyôn máh cưu át pa atớm án, ma máh mbeq ngki án dyôn át pa aviar án. ");
INSERT INTO pac_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dyơ Puo ngki tông nha-án ndon át pa atớm idô: ‘A-ám cư dyôn inha bôn callong bún a-ưi. Inha mot cơt sút tớq ntúq Yang Arbang-pilŏ́ng khoiq thuan dŏq mun dyôn inha. Mun ndô án khoiq thuan dŏq dyôn inha te ingái án teng túc culám khám nốh tớq pilŏ́ng alứng tớq cúc cuteq. ");
INSERT INTO pac_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ndóng cư sáng pinhaih, inha khoiq chiam cư dyôn bôn cha. Ndóng cư hál dơq, inha khoiq dyôn cư ngoiq. Ndóng cư la tumoi laq, inha khoiq pasôl cư, alứng dyôn cư mot tớq dúng inha. ");
INSERT INTO pac_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ndóng cư ớq tampớc, inha khoiq dyôn cư bôn tampớc. Ndóng cư a-ái, inha khoiq tớq partê cư. Ndóng cư át tớq coq tôt, inha khoiq tớq alang cư.’ ");
INSERT INTO pac_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dyơ nha-án ndon tinớng ŏ plốh idô: ‘Ưlla ơi! Ndóng mmo he hôm Ưlla pinhaih alứng he chứm chiam Ưlla? Lớiq la Ưlla hál dơq alứng he dyôn Ưlla ngoiq? ");
INSERT INTO pac_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndóng mmo he hôm Ưlla la tumoi laq alứng he pasôl ŏ Ưlla, alứng dyôn Ưlla mot tớq dúng he? Lớiq la Ưlla ớq tampớc alứng he dyôn Ưlla bôn tampớc? ");
INSERT INTO pac_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Alứng ndóng mmo he hôm Ưlla a-ái, lớiq la át tớq coq tôt, ma he pôq alang Ưlla?’ ");
INSERT INTO pac_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Puo ngki ôi lieh nha-án idô: ‘Cư tông inha arlớih lư, ndóng inha táq máh arnáq ngki ada munáq em ai cư ndon lớiq bôn tarnáp amớh, la arớq inha táq dyôn cư tưi!’ ");
INSERT INTO pac_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Cua ngki, puo ngki tông nha-án ndon át pa aviar án idô: ‘Inha tôi yông te cư, co Yang Arbang-pilŏ́ng khoiq pupap inha. Án dyôn inha át tớq ntúq uih chéh níc-níc, la ntúq án khoiq thuan dŏq dyôn yang Satán alứng máh tarneng yang ngki. ");
INSERT INTO pac_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndóng cư sáng pinhaih, inha lớiq bôn dyôn cư tanna cha. Ndóng cư hál dơq, inha lớiq bôn dyôn cư ngoiq. ");
INSERT INTO pac_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ndóng cư la tumoi laq, inha lớiq bôn pasôl ŏ ada cư, alứng lớiq dyôn cư mot tớq dúng inha. Ndóng cư ớq tampớc, inha lớiq bôn dyôn cư bôn tampớc. Ndóng cư a-ái alứng át tớq coq tôt, inha lớiq bôn pôq alang cư.’ ");
INSERT INTO pac_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dyơ nha-án plốh puo idô: ‘Ưlla ơi! Ndóng mmo he hôm Ưlla pinhaih, lớiq la hál dơq, lớiq la tumoi laq, lớiq la ớq tampớc tớc, lớiq la a-ái alứng át tớq coq tôt, ma he lớiq bôn choi Ưlla?’ ");
INSERT INTO pac_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Puo ôi lieh nha-án idô: ‘Cư tông inha arlớih lư, ndóng inha lớiq choi munáq em ai cư ndon lớiq bôn tarnáp amớh, la arớq inha lớiq choi cư tưi.’ ");
INSERT INTO pac_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iki máh nha-án ndon lớiq tarchoi cóq mot át níc tớq ntúq dieiq arức lư. Ma máh ticuoi tinớng ŏ bôn mot tớq ntúq bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tư Yê-su tông cua nhéq máh parnai ngki, án tông top rian te án idô: ");
INSERT INTO pac_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Inha khoiq chom dyơ, yôl bar ingái loi top Isa-ra-el ính cha bui ayư Ingái Ngốh. Ingái ngki la ingái ngai mŏp cư Acái Yang Cơt Ticuoi, dyôn ngai téh cư tớq along calláng.” ");
INSERT INTO pac_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ndóng ngki máh ticuoi sút top teng rit sang alứng máh ticuoi sút tớq sớu parchúng tanghúng tớq dúng Cai-pha la ariaih top teng rit sang. ");
INSERT INTO pac_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nha-án tanghúng dŏq suo ngê ính cŏp alứng cachet Yê-su, ma nha-án lớiq ính ticuoi cannŏ́h chom. ");
INSERT INTO pac_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nha-án tông idô: “He lớiq têq táq iki tớq ingái cha bui, co adáh ticuoi clứng tarchơiq tớq vel he.” ");
INSERT INTO pac_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ndóng Yê-su át tớq vel Bê-thani, án át tớq dúng Si-môn la ticuoi a-ái bŏ́q te nsuoi. ");
INSERT INTO pac_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Dyơ bôn munáq cán tớq nga Yê-su. Án dông mui lám be ngai táq tớq búl ‘a-labat’. Tớq be ngki bôn dơq thum dát lư. Ndóng Yê-su át chicha, án tốq dơq thum tớq plô Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tư top rian te Yê-su hôm án táq iki, nha-án sáng nháih, alứng nha-án táq-ntêr idô: “Imo cán ndô táq iki; án pirê mat dơq thum ngki? ");
INSERT INTO pac_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Khán táiq dơq thum ndô, lư bôn a-ưi práq, alứng têq ial práq ngki choi máh ticuoi kidit!” ");
INSERT INTO pac_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yê-su chom nha-án táq-ntêr iki, dyơ án tông nha-án idô: “Imo inha táq dyôn cán ndô sáng anguaq? Cán ndô táq arnáq ŏ lư a cư. ");
INSERT INTO pac_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Máh ticuoi kidit át níc alứng inha. Ma cháq cư lớiq bôn át níc alứng inha. ");
INSERT INTO pac_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cán ndô khoiq tốq dơq thum tớq cháq cư, la thuan dŏq dyôn ngai tứp cư tớq ping. ");
INSERT INTO pac_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cư tông inha arlớih lư, cứp ntúq tớq cúc cuteq ndô, tớq ngai cato parnai ŏ te Yang Arbang-pilŏ́ng, lư ngai cato díh arnáq cán ndô táq hơ, dŏq dyôn máh ticuoi ayư te án.” ");
INSERT INTO pac_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Vít ngki Yuda I-cari-ôt la munáq te top mui chít la bar náq ndon rian te Yê-su, án tớq nga ticuoi sút top teng rit sang, ");
INSERT INTO pac_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","alứng tông nha-án idô: “Khán cư mŏp Yê-su nga inha, ngki amớh inha ính dyôn cư?” Iki nha-án dyôn án pe chít callong práq. ");
INSERT INTO pac_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cua ngki, Yuda suo ngê ính culieu Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tớq máh ingái top Isa-ra-el cha bui ayư Ingái Ngốh, nhéq tupul ingái nha-án cha beng lớiq pôih. Tớq ingái mui, top rian te Yê-su tớq nga án alứng plốh idô: “Ntúq mmo thới ính he pôq thuan dyôn thới cha pêl bui?” ");
INSERT INTO pac_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yê-su ôi nha-án idô: “Inha mot tớq vel, inha lư tumúh munáq ticuoi ưlla dúng. Inha tông án idô: ‘Thới tông: Ingái Yang Arbang-pilŏ́ng khoiq anát dyôn cư tumán ính tớq dyơ. Cư alứng top rian te cư ính cha pêl bui ayư Ingái Ngốh tớq dúng mái.’” ");
INSERT INTO pac_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Iki top rian te Yê-su pôq táq arớq Yê-su patáp nha-án. Alứng nha-án thuan dŏq cha pêl bui tớq dúng ngki. ");
INSERT INTO pac_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tớq aryum-yum Yê-su ticu cha munơi alứng top mui chít la bar náq rian te án. ");
INSERT INTO pac_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ndóng nha-án chicha, Yê-su tông nha-án idô: “Cư tông inha arlớih lư, bôn munáq te top inha ính culieu cư.” ");
INSERT INTO pac_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nhéq top rian te án sáng anguaq lư, alứng muchư munáq plốh án idô: “Cư lớiq Ưlla?” ");
INSERT INTO pac_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yê-su ôi nha-án idô: “Án ndon túq beng mui tingan alứng cư, lư án ngki táp culieu cư. ");
INSERT INTO pac_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Acái Yang Cơt Ticuoi cóq cuchet dŏq táq veng tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông te án. Ma bap lư ada ticuoi ndon culieu Acái Yang Cơt Ticuoi! Khaq a-i án êq carnian án!” ");
INSERT INTO pac_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda ndon ính culieu Yê-su, án plốh idô: “Cư lớiq thới?” Yê-su ôi án: “Lư piaiq arớq mái plốh.” ");
INSERT INTO pac_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ndóng nha-án chicha, Yê-su ial beng alứng si-ơn Yang Arbang-pilŏ́ng, dyơ án péq beng alứng avôi dyôn top rian te án. Án tông idô: “Inha ráp cha, ndô la cháq cư.” ");
INSERT INTO pac_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Vít ngki án ial choc loi. Án si-ơn Yang Arbang-pilŏ́ng, dyơ án avôi dyôn top rian te án, alứng án tông idô: “Nhéq náq inha ngoiq, ");
INSERT INTO pac_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ndô la aham cư ndon ngốh táq tíc Yang Arbang-pilŏ́ng khoiq carhŏt parnai tamme ada nhéq tưh ticuoi. Nhơ te aham cư, Yang Arbang-pilŏ́ng táh luaih dyôn ticuoi. ");
INSERT INTO pac_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cư tông inha idô: Cư lớiq ngoiq nnáng dơq nho ndô, tingôi tớq ingái cư ngoiq dơq nho tamme munơi alứng inha tớq ntúq A-ám cư sút.” ");
INSERT INTO pac_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cua nha-án cứh mui alhoiq ayô, dyơ nha-án ngốh te ngki, sớr nga king O-li-vê loi. ");
INSERT INTO pac_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ndóng ngki Yê-su tông nha-án idô: “Idáu ndô táp nhéq náq inha táh cư. Tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô: ‘Cư dyôn ngai cachet viang ticuoi kiaq me cưu; dyơ top cưu án lúh pláh chap nhéq.’ ");
INSERT INTO pac_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma tư cư tumống lieh, cư pôq nsuoi inha nga vúng Ca-lilê.” ");
INSERT INTO pac_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phi-er tông Yê-su idô: “Khán nhéq máh ticuoi táh thới, cư lư lớiq táh thới mmớh!” ");
INSERT INTO pac_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yê-su ôi án idô: “Cư tông mái arlớih lư, idáu ndô táp, ntruoi iyốh ticár, mái calôih cư khoiq pe chư.” ");
INSERT INTO pac_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Phi-er ôi idô: “Khán ngai cachet cư munơi alứng thới la thôi. Cư lư lớiq calôih thới mmớh!” Alứng nhéq top ngki tông muchứng Phi-er tưi. ");
INSERT INTO pac_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dyơ Yê-su alứng top rian te án pôq nga nưong Kêt-se-manê. Yê-su tông top rian te án idô: “Inha át ticu ndô nư. Cư ính pôq cớu nga tuki.” ");
INSERT INTO pac_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma Yê-su dông nưm Phi-er alứng bar náq em ai acái conh Sê-badê pôq alứng án. Ndóng ngki táp án sáng anguaq alứng rớu lư. ");
INSERT INTO pac_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Án tông nha-án pe náq idô: “Mít cư sáng anguaq lư, cư lớiq rap tumống nnáng. Inha át pớn ndô. Inha cayôn alứng cư.” ");
INSERT INTO pac_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tư Yê-su pôq biq te nha-án; án mpop tớq cuteq mui tatứp alứng cớu idô: “Ơ A-ám cư ơi! Khán têq, cư seq mái atức viang choc dieiq arức ndô dyôn vít te cư. Ma cư lớiq ính veng cannính cư bôm, ma cư veng cannính mái sớng.” ");
INSERT INTO pac_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dyơ Yê-su chô lieh nga pe náq ndon rian te án. Án tumúh nha-án bíq. Dyơ án plốh Phi-er idô: “Imo muhúiq sớng la inha lớiq rap cayôn alứng cư? ");
INSERT INTO pac_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cóq inha ayư alứng cớu seq êq dyôn ngai tardông inha táq luaih. Mít inha ngki bánh rêng, ma sac sáiq inha ngki ieuq.” ");
INSERT INTO pac_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yê-su pôq chư bar ính cớu nga ntúq tuki sa. Án cớu idô: “A-ám cư ơi! Khán mái lớiq ính atức choc dieiq arức ndô dyôn vít te cư, ma mái ính cư cóq ngoiq, ngki cư veng cannính mái sớng.” ");
INSERT INTO pac_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Dyơ Yê-su chô lieh nga pe náq, ma án tumúh nha-án bíq sa. Nha-án lớiq rap caplang mát; co ngcơr mát nha-án acứp níc. ");
INSERT INTO pac_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yê-su pôq sa te nha-án, alứng án pôq cớu chư pe. Án cớu muchứng parnai te nsuoi sa. ");
INSERT INTO pac_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dyơ án chô lieh nga top rian te án alứng án tông nha-án idô: “Imo inha yôl bíq alứng angô sa? Ngư cư khoiq tumán tớq dyơ. Ngai khoiq culieu Acái Yang Cơt Ticuoi nga ati ticuoi luaih. ");
INSERT INTO pac_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yôr tayứng! He pôq! Inha me án ndon culieu cư khoiq tớq dyơ!” ");
INSERT INTO pac_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ndóng Yê-su yôl táq-ntêr alứng nha-án, Yuda la munáq te top mui chít la bar náq ndon rian te Yê-su, tớq munơi alứng ticuoi clứng. Máh ticuoi ngki tớq te ticuoi sút top teng rit sang alứng ticuoi sút tớq sớu. Nha-án dông dau alứng tarcál. ");
INSERT INTO pac_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Án ndon culieu Yê-su khoiq tông tíc dyôn máh ticuoi ngki chom idô: “Khán inha hôm cư honh ticuoi mmo, án ngki ớiq inha ính bôn. Dyơ inha cŏp án!” ");
INSERT INTO pac_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iki Yuda tớq táp nga Yê-su, alứng án tông idô: “Bánh tưi thới.” Dyơ án honh Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yê-su tông án: “Yớu ơi! Arnáq amớh mái ính táq, mái táq adứh!” Dyơ ngai tớq kéu alứng cŏp Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bôn munáq te top veng tapun Yê-su, thot dau te sor, dyơ án tráh munáq sol ariaih top teng rit sang, crái mui pa cutor alứng ti-ŏ́h. ");
INSERT INTO pac_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yê-su tông án idô: “Mái cacháq lieh dau mái tớq sor. Ticuoi mmo kéu dau, án lư cuchet lieh na dau. ");
INSERT INTO pac_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mái chom lớiq, khán cư ính, cư têq seq te A-ám cư dyôn choi cư, dyơ án lư yua mui chít la bar pớl tarneng dyôn tớq choi cư. ");
INSERT INTO pac_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma khán cư táq iki, lớiq bôn tarvớiq nnáng arớq parnai Yang Arbang-pilŏ́ng khoiq tông tớq tám uráq te inớh. Uráq ngki tông te máh arnáq ndô cóq tớq.” ");
INSERT INTO pac_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dyơ Yê-su plốh máh ticuoi clứng loi: “Imo inha tớq nga ndô dông dau alứng côn ính cŏp cư? Inha parngíh cư la ticuoi siveng lớiq? Cứp ingái cư át cato tớq Dúng Sang Pưt ma inha lớiq bôn cŏp cư. ");
INSERT INTO pac_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma arnáq ndô táq dyôn cơt tarvớiq simớt parnai tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông na ticuoi tang ngcang án te inớh.” Dyơ top rian te Yê-su mmar lúh táh nhéq Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iki nha-án cŏp Yê-su, alứng dông án nga dúng Cai-pha, la ariaih top teng rit sang. Máh ticuoi sút tớq sớu alứng thới sái rit tớq rum nga ntúq ngki tưi. ");
INSERT INTO pac_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Phi-er veng yông-yông tatun crŏ́ng Yê-su. Án mot tớq ngcưm dúng ariaih top teng rit sang. Án ticu munơi alứng máh ticuoi kiaq Dúng Sang Pưt, án ính chom amớh nha-án ính táq ada Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iki máh ticuoi sút top teng rit sang alứng ticuoi bôn chức cannŏ́h sisuo ticuoi ndon têq ton apít Yê-su. Nha-án ính cachet Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bôn a-ưi ticuoi tớq ton apít Yê-su, ma lớiq cơt callong. Ma ticuoi sút ngki lớiq tumúh mui callong lớiq ŏ amớh te Yê-su. Tatun tháng, bôn bar náq loi tớq ton apít Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nha-án tông idô: “Ticuoi ndô tông: ‘Cư talóh Dúng Sang Pưt, dyơ têq cư táq lieh tớq pe ingái la dyơ táp.’” ");
INSERT INTO pac_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Iki ariaih top teng rit sang yôr tayứng, alứng plốh Yê-su idô: “Máh parnai ticuoi ndô cauq mái, lư mái tông iki ma lớiq? Alứng amớh mái ính ôi lieh nha-án?” ");
INSERT INTO pac_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Yê-su át tưl-vưl sớng, án lớiq tông mui callong amớh. Dyơ ariaih ngki tông loi idô: “Cư bôiq nốh Yang Arbang-pilŏ́ng, án ndon tumống níc, nhơ nốh án, cư yua mái cantŏ́h callih ada he, mái la Crit Acái Yang Arbang-pilŏ́ng, ma lớiq?” ");
INSERT INTO pac_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yê-su ôi án idô: “Lư piaiq arớq mái tông. Ma cư tông inha idô: Chô-mát inha hôm Acái Yang Cơt Ticuoi ticu pa atớm Yang Arbang-pilŏ́ng Sút Pưt Lư, alứng án tớq pandi tulúc te pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iki ariaih top teng rit sang haq tampớc án bôm, táq tíc án sáng anguaq lư. Alứng án tông ada nhéq máh ticuoi ngki idô: “Án tông iki la arớq án acraiq Yang Arbang-pilŏ́ng dyơ. Chớm he ính plốh nnáng ticuoi cannŏ́h. Inha khoiq sáng dyơ parnai án táq-ntêr. ");
INSERT INTO pac_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Inha parngíh imo te callong ngki?” Nha-án ôi idô: “Piaiq lư án cóq cuchet!” ");
INSERT INTO pac_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dyơ nha-án cuchóh tớq mang Yê-su, alứng dớm án hơ. Ma bôn ticuoi cannŏ́h páh án, ");
INSERT INTO pac_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","alứng plốh idô: “Crit ơi! Khán mái lư ticuoi tang ngcang Yang Arbang-pilŏ́ng, áu mái tông he, nnáu dớm mái?” ");
INSERT INTO pac_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phi-er át ticu tớq ngcưm dúng. Dyơ bôn munáq cán prái tarráih ticuoi ariaih top teng rit sang tớq nga Phi-er, alứng án tông idô: “Mái át alứng Yê-su la ticuoi te vúng Ca-lilê.” ");
INSERT INTO pac_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma Phi-er calôih Yê-su chứng mát máh ticuoi ngki idô: “Cư lớiq apúh amớh mái tông.” ");
INSERT INTO pac_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dyơ án pôq nga ngáh callống carrống. Bôn cán cannŏ́h loi hôm án, alứng tông ada máh ticuoi át tumán ngki idô: “Ticuoi ndô át alứng Yê-su te vel Na-saret.” ");
INSERT INTO pac_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Phi-er calôih Yê-su sa, alứng án cantŏ́h callih idô: “Cư lớiq chom nnáu án ngki!” ");
INSERT INTO pac_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Muhoi loi, bôn máh ticuoi át tumán ngki tớq nga Phi-er, alứng tông idô: “Lư simớt mái la te top ngki tưi, co tammieng mái in tháng án.” ");
INSERT INTO pac_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma Phi-er cantŏ́h callih clŏq plô clŏq sóc. Alứng án ôi tarmien níc idô: “Cư lớiq chom án!” Ndóng ngki táp ntruoi ticár. ");
INSERT INTO pac_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dyơ Phi-er ayư lieh te máh parnai Yê-su khoiq tông ada án idô: “Ntruoi iyốh ticár, mái calôih cư khoiq pe chư.” Iki Phi-er ngốh te ngki; dyơ án nhiem ức-áh pi-ưl tháng. ");
INSERT INTO pac_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tớq ang iláih parnô, mbơiq sưm-turưm, nhéq máh ticuoi sút top teng rit sang alứng nhéq máh ticuoi sút tớq sớu, tanghúng alứng suo ngê ính cachet Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nha-án chóq Yê-su alứng dông nga Phi-lat ticuoi Rô-ma, án ndon sút tớq cruong ngki. ");
INSERT INTO pac_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tư Yuda ndon khoiq culieu Yê-su sáng ticuoi sút tông idô: Yê-su cóq cuchet, iki án sáng anguaq lư co te arnáq án khoiq táq. Dyơ án dông culieh lieh práq pe chít callong nga máh ticuoi sút top teng rit sang alứng nga máh ticuoi sút tớq sớu. ");
INSERT INTO pac_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Án tông idô: “Cư khoiq táq luaih dyơ, co cư khoiq culieu munáq ticuoi ndon lớiq bôn luaih amớh.” Ma nha-án ôi Yuda idô: “Callong ngki tới arnáq he. Tam mái!” ");
INSERT INTO pac_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iki Yuda adúh táh práq ngki tớq Dúng Sang Pưt. Dyơ án ngốh dyáq, án chóq panuar alứng casrít ticong án bôm. ");
INSERT INTO pac_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Máh ticuoi sút top teng rit sang peh ial práq ngki alứng tông idô: “Práq ndô la tarnáp te aham ticuoi. Iki veng phep rit he lớiq têq dŏq práq ndô tớq Dúng Sang Pưt.” ");
INSERT INTO pac_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iki nha-án tanghúng. Cua ngki nha-án plới mui tám cuteq tớq práq ngki. Cuteq ngki nha-án plới te ticuoi thơq táq adéh na cuteq tubát. Nha-án plới tám cuteq ngki ien ính tứp ticuoi te cruong cannŏ́h ndon cuchet tớq cruong nha-án. ");
INSERT INTO pac_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Co iki, tingôi ingái ndô ngai anốh cuteq ngki la Tám Cuteq Aham Ticuoi Cuchet. ");
INSERT INTO pac_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Iki cơt tarvớiq simớt parnai Yê-ramie la ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông idô: “Ngai ial pe chít callong práq, dyơ plới mui tám cuteq te ticuoi thơq táq adéh cuteq tubát, arớq Ưlla cư khoiq yua cư táq. Pe chít callong práq la tarnáp te ticuoi Isa-ra-el khoiq anát dyôn tarngứh án.” ");
INSERT INTO pac_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yê-su tayứng chứng mát Phi-lat la ticuoi Rô-ma, án ndon sút tớq cruong ngki. Phi-lat plốh Yê-su idô: “Mái la lư puo top Isa-ra-el lớiq?” Yê-su ôi: “Lư piaiq mái tông.” ");
INSERT INTO pac_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iki máh ticuoi sút top teng rit sang alứng máh ticuoi sút tớq sớu cauq Yê-su. Ma Yê-su lớiq ôi amớh. ");
INSERT INTO pac_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dyơ Phi-lat plốh sa: “Mái sáng ma lớiq ngai cauq mái te a-ưi nốh?” ");
INSERT INTO pac_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Yê-su lớiq bôn ôi mui callong amớh. Iki ticuoi sút ngki sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tớq ingái ticuoi Isa-ra-el rum cha bui ayư Ingái Ngốh, nha-án bôn rit la ticuoi sút tớq cruong cóq taláh munáq ticuoi tôt, veng mít cannính ticuoi prái rêh. ");
INSERT INTO pac_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ndóng ngki bôn munáq ticuoi tôt, nốh Ba-raba. Cứp náq ticuoi chom nhéq nốh án. ");
INSERT INTO pac_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iki, ndóng ticuoi clứng át rum, Phi-lat plốh nha-án idô: “Ticuoi mmo inha ính cư taláh dyôn inha, Ba-raba lớiq la Yê-su ndon ngai dŏq Crit?” ");
INSERT INTO pac_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Phi-lat chom arlớih máh ticuoi sút i-ôiq camíq te Yê-su, co máh ticuoi prái na nha-án ính lư veng tapun Yê-su. Co iki nha-án dông Yê-su tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ndóng Phi-lat ticu tớq ntúq án tarsưq, campái án cơiq parnai nga án idô: “Mái êq táq amớh ada ticuoi ngki, co án lớiq bôn táq luaih amớh. Ibư inô cư mpáu te án, alứng ingái ndô cư sáng crŏ́q lư.” ");
INSERT INTO pac_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma máh ticuoi sút top teng rit sang alứng máh ticuoi sút tớq sớu chachuoq máh ticuoi clứng dyôn tarseq te ticuoi sút taláh Ba-raba, ma cachet Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Án ndon sút ngki plốh ticuoi clứng idô: “Te bar náq ticuoi ndô, inha ính cư taláh nnáu?” Nha-án ôi: “Ba-raba!” ");
INSERT INTO pac_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Phi-lat plốh sa: “Khán iki, amớh inha ính cư táq ada Yê-su ndon ngai dŏq Crit?” Nha-án ôi: “Téh án tớq along calláng!” ");
INSERT INTO pac_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dyơ Phi-lat plốh sa: “Co imo? Alứng amớh án táq luaih ada inha?” Ma nha-án ôi yứng hơn te nsuoi loi idô: “Téh án tớq along calláng!” ");
INSERT INTO pac_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tư Phi-lat chom án lớiq têq táq amớh dŏq choi Yê-su, alứng án adáh ticuoi clứng tarchơiq lư loi, iki án ial dơq, dyơ arau ati chứng mát nha-án, alứng án tông idô: “Arnáq ndô cư táq tíc, cư lớiq ính chúng tôt te ticuoi ndô cuchet. Callong ndô tam inha.” ");
INSERT INTO pac_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nhéq máh ticuoi clứng ôi idô: “Tôt te ticuoi ndô cuchet, seq dyôn tớq nga he alứng nga acái acon he hơ.” ");
INSERT INTO pac_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iki Phi-lat taláh Ba-raba dyôn ticuoi clứng. Ma Yê-su, ngki án dyôn ngai prớih. Vít ngki án mŏp Yê-su dyôn nha-án dông téh tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dyơ máh líng Phi-lat dông amot Yê-su tớq pốt. Ntúq ngki bôn líng clứng lư tớq át paniar Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nha-án luaiq tampớc Yê-su, alứng nha-án asứp án au thor ntứm cusáu. ");
INSERT INTO pac_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nha-án táq carvang tangháng alứng tapưng tớq plô Yê-su, alứng nha-án dyôn án cadyiq tarlông pa atớm. Cua ngki nha-án chóh tarcol chứng mát án, alứng ayê tar-ac án idô: “Cucúh ngai sasai, puo Isa-ra-el!” ");
INSERT INTO pac_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nha-án cuchóh tớq cháq Yê-su alứng ial tarlông tính plô án hơ. ");
INSERT INTO pac_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cua nha-án ayê tar-ac Yê-su, dyơ nha-án luaiq au thor alứng asứp lieh tampớc án bôm. Dyơ nha-án dông angốh án dŏq téh tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tư nha-án ngốh vít te vel, nha-án tumúh munáq conh tớq carna, nốh Si-môn, ticuoi te cruong Si-rên. Nha-án patot án dyôn dual along calláng Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nha-án tớq nga ntúq nốh Cô-cô-tha. Parnai ndô titoiq lieh la: ‘Ntúq Nghang Cudoh Plô’. ");
INSERT INTO pac_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Át ntúq ngki ngai avôi Yê-su dyôn ngoiq sieu carchúc crơng atáng. Yê-su iel, ma án lớiq lôn. ");
INSERT INTO pac_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dyơ nha-án téh Yê-su tớq along calláng. Alứng nha-án mpô tampớc Yê-su na séng anhúq, ticuoi mmo bôn la thôi. ");
INSERT INTO pac_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Cua ngki nha-án ticu kiaq Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tớq tanieng plô Yê-su, nha-án dŏq mui mêng pan; alứng nha-án taran callong luaih án, la idô: NDÔ LA YÊ-SU, PUO TICUOI ISA-RA-EL. ");
INSERT INTO pac_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngai téh bar náq ticuoi siveng tumán Yê-su, munáq pa atớm, munáq pa aviar. ");
INSERT INTO pac_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Máh ticuoi pôq pha ntúq ngki culớl culan ayê tar-ac Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nha-án tông idô: “Mái ndô ớiq tông ính talóh Dúng Sang Pưt. Dyơ mái ính táq lieh pe ingái la dyơ táp. Áu, hoi-ngki mái choi tamống cháq mái bôm. Khán mái lư Acái Yang Arbang-pilŏ́ng, mái siar te along calláng ngki.” ");
INSERT INTO pac_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Díh máh ticuoi sút top teng rit sang, máh thới sái rit, alứng máh ticuoi sút tớq sớu, la ayê tar-ac Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Top nha-án tông idô: “Ticuoi cannŏ́h têq án choi tamống, ma cháq án bôm, lớiq hôm têq án choi. Khán án lư puo Isa-ra-el, dyôn án siar bôm te along calláng. Khán án siar, he lư tin án tưi. ");
INSERT INTO pac_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Án tin Yang Arbang-pilŏ́ng, alứng án tông án la Acái Yang Arbang-pilŏ́ng. Khán án lư simớt iki, dyôn Yang Arbang-pilŏ́ng choi tamống án hoi-ngki.” ");
INSERT INTO pac_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Díh bar náq siveng ndon ngai téh tớq along calláng mui parrứh alứng Yê-su, la ayê tar-ac Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Te mát pandang tứng tingôi mát pandang viet, cơt ngiau nhéq tớq cruong ngki. ");
INSERT INTO pac_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tớq pandang tallóh pưt, Yê-su arô yứng lư idô: “Ê-li, Ê-li, lama-sabac-tani?” Parnai ndô titoiq lieh la: “Yang Arbang-pilŏ́ng cư ơi! Yang Arbang-pilŏ́ng cư ơi! Imo mái táh cư?” ");
INSERT INTO pac_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tư ticuoi tayứng tumán sáng Yê-su arô, iki nha-án tông idô: “Án arô Ê-li!” ");
INSERT INTO pac_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bôn munáq te nha-án lúh ial mui cúc nsol. Án talứm tớq sieu adyóq, alứng án chóq nsol ngki tớq callêh. Dyơ án pidáng dyôn Yê-su kidyớp. ");
INSERT INTO pac_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma ticuoi cannŏ́h tông idô: “He pớn avai. He me Ê-li tớq choi án, ma lớiq!” ");
INSERT INTO pac_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yê-su cuc yứng lư loi, dyơ án pít tarngứh. ");
INSERT INTO pac_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ndóng ngki táp, prới ngai yéng tớq Dúng Sang Pưt cơt tarhaq te tanieng tớq tadưp, cơt bar tarrec. Cuteq cacưt alứng máh búl cơt picháh. ");
INSERT INTO pac_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ping cumuiq arớq ngai pốh, dyôn a-ưi náq ticuoi khoiq cuchet ndon veng ngê Yang Arbang-pilŏ́ng bôn tumống lieh. ");
INSERT INTO pac_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Vít Yê-su tumống lieh, máh ticuoi ndon khoiq cuchet ngốh te ping, alứng nha-án mot tớq vel pưt Yaru-salem. Tớq vel ngki bôn clứng ticuoi hôm nha-án. ");
INSERT INTO pac_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ndóng ngki bôn munáq sút mui culám líng alứng top líng án át kiaq Yê-su. Nhéq náq nha-án hôm cuteq cacưt alứng hôm máh nốh cannŏ́h hơ. Iki nha-án sáng adáh lư, alứng nha-án tông idô: “Lư simớt, ticuoi ndô la Acái Yang Arbang-pilŏ́ng!” ");
INSERT INTO pac_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bôn a-ưi náq cán ndon át yông-yông tingưi me nga Yê-su. Nha-án khoiq veng Yê-su te vúng Ca-lilê, alứng nha-án chứm chiam án. ");
INSERT INTO pac_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tớq top cán ngki bôn Mari te vel Mac-dala, Mari a-i Yacơ nha Yô-sê, alứng a-i bar náq acái conh Sê-badê. ");
INSERT INTO pac_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tớq pilŏ́ng aryum, bôn munáq ticuoi súc ndon tớq te vel Ari-mathê, nốh Yô-sep. Án la ticuoi rian te Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Án tớq nga Phi-lat, alứng án seq cumuiq Yê-su. Phi-lat yua ngai dyôn cumuiq Yê-su nga án. ");
INSERT INTO pac_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iki Yô-sep ial cumuiq Yê-su, dyơ án sŏm tớq prới tamme práh ŏ. ");
INSERT INTO pac_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dyơ án dŏq cumuiq ngki tớq ping tamme na án; ping ngki ngai var tớq búl côl. Dyơ án vih búl catáng viang ngáh ping. Cua ngki án chô. ");
INSERT INTO pac_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari te vel Mac-dala alứng Mari cannŏ́h, ticu tingưi me nga ngáh ping. ");
INSERT INTO pac_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ingái parnô la Ingái Angô. Ingái ngki máh ticuoi sút top teng rit sang alứng máh ticuoi Pha-rasi pôq nga Phi-lat. ");
INSERT INTO pac_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nha-án tông Phi-lat idô: “Avốq ơi! He ayư ndóng ticuoi a-uai ngki yôl tumống, án tông idô: ‘Cư cuchet, ma vít pe ingái, cư yôr tumống lieh.’ ");
INSERT INTO pac_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iki he seq avốq yua ngai kiaq carsiat ping ngki tớq pe ingái. Iki top rian te Yê-su lớiq têq mot tôiq cháq cumuiq ngki. Khán nha-án bôn tôiq, nha-án lư tông ticuoi cannŏ́h idô: ‘Yê-su cuchet, alứng án khoiq tumống lieh.’ Khán nha-án tông Yê-su tumống lieh, parnai a-uai ngki ntáng hơn te parnai a-uai ngai tông án la Crit.” ");
INSERT INTO pac_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Phi-lat ôi nha-án idô: “Inha dông líng pôq kiaq ping ngki; tam cannính inha.” ");
INSERT INTO pac_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iki nha-án ngốh te ngki. Dyơ nha-án kitíh ta tớq búl ngki dŏq lớiq dyôn nnáu pốh, alứng nha-án yua líng kiaq. ");
INSERT INTO pac_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Vít Ingái Angô, tớq ingái mui tớq tún tamme, iláih ngki pilŏ́ng ang mbơiq sưm-turưm, Mari te vel Mac-dala alứng Mari cannŏ́h pôq clơ ping Yê-su. ");
INSERT INTO pac_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ndóng ngki cuteq cacưt hớp lư, co bôn tarneng Yang Arbang-pilŏ́ng siar vih búl ngai khoiq catáng ngáh ping Yê-su; dyơ án ticu tớq búl ngki. ");
INSERT INTO pac_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rớp án arớq lilaiq, alứng tampớc án clŏq tarbal mát. ");
INSERT INTO pac_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Máh líng kiaq ping sáng adáh lư alứng dyandyír. Nha-án cơt arớq ticuoi cuchet. ");
INSERT INTO pac_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tarneng ngki tông máh cán ngki idô: “Inha êq adáh. Cư chom inha suo Yê-su ndon ngai khoiq téh tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Án lớiq át nnáng tớq ndô. Án khoiq tumống lieh dyơ, arớq án khoiq tông te nsuoi. Inha tớq tudô, me nga ntúq ngai dŏq án te nsuoi. ");
INSERT INTO pac_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dyơ inha pôq adứh, pôq táq-ntêr dyôn máh top rian te án chom idô: ‘Yê-su khoiq tumống lieh dyơ. Hoi-ngki án pôq nsuoi inha nga vúng Ca-lilê. Át ntúq ngki, inha lư bôn tumúh án!’ Cóq inha ayư máh parnai cư khoiq tông inha.” ");
INSERT INTO pac_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Iki máh cán ngki ngốh te ping. Ntơnh nha-án crŏ́q, ntơnh nha-án sáng ơn hơ. Nha-án talúh chô táq-ntêr dyôn máh top rian te Yê-su chom. ");
INSERT INTO pac_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ndóng ngki táp Yê-su tớq tumúh nha-án, alứng án cabánh nha-án idô: “Bánh tưi inha.” Cán ngki tớq nga Yê-su, kiau dyưng án alứng sang án. ");
INSERT INTO pac_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dyơ Yê-su tông nha-án idô: “Inha êq adáh. Inha pôq tông em ai cư dyôn nha-án pôq nga vúng Ca-lilê. Át ntúq ngki nha-án bôn tumúh cư.” ");
INSERT INTO pac_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ndóng cán ngki pôq tớq carna, líng ndon kiaq ping Yê-su chô nga vel, alứng tông máh ticuoi sút top teng rit sang chom te cứp nốh nha-án khoiq hôm. ");
INSERT INTO pac_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Máh ticuoi sút ngki parchúng tanghúng alứng máh ticuoi sút tớq sớu. Dyơ nha-án dyôn práq máh líng ndon kiaq ping a-ưi lư. ");
INSERT INTO pac_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Alứng nha-án patáp idô: “Dyôn inha táq-ntêr idô: ‘Tớq idáu, ndóng he bíq, bôn top rian te Yê-su tớq tôiq cumuiq Yê-su.’ ");
INSERT INTO pac_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma khán Phi-lat ticuoi sút sáng te arnáq ndô, he ính tartông choi inha, lớiq dyôn án táq amớh ada inha.” ");
INSERT INTO pac_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iki máh ticuoi líng ngki ial práq, alứng nha-án táq veng arớq máh parnai ngai yua nha-án. Iki arnáq ndô cơt parhanh pardŏ́h tớq cruong ticuoi Isa-ra-el tingôi díh ingái ndô. ");
INSERT INTO pac_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mui chít la mui náq top rian te Yê-su, sớr nga cóh tớq vúng Ca-lilê, la ntúq Yê-su khoiq patáp nha-án. ");
INSERT INTO pac_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tư nha-án hôm Yê-su, nha-án sang án; ma bôn ticuoi ndon lớiq lư tin te arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yê-su tớq nga nha-án alứng tông idô: “Nhéq máh nốh chức tớq pilŏ́ng alứng tớq cuteq, Yang Arbang-pilŏ́ng khoiq mŏp dyôn cư dyơ. ");
INSERT INTO pac_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iki cóq inha pôq cato cứp náq ticuoi dyôn nha-án cơt arớq ticuoi rian te cư tưi. Cóq inha táq tíc na dơq dyôn nha-án nhơ nốh A-ám, nhơ nốh Acái, alứng nhơ nốh Arvai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cóq inha tông nha-án dyôn peh cứp parnai ndon cư khoiq patáp inha. Alứng cư lư át alứng inha níc, te hoi-ndô tingôi ingái talloiq tháng.”");
INSERT INTO pac_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ndô tabớq cato parnai ŏ te Yê-su Crit, Acái Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng; án khoiq taran acớiq te Yon te inớh idô: “Urớh Cư Yang Arbang-pilŏ́ng yua ticuoi tampeng cư tớq nsuoi mái, dŏq thuan carna dyôn mái. ");
INSERT INTO pac_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sieng án tubau yứng lư te ntúq aih idô: ‘Cóq inha pangcra carna dyôn Ưlla. Cháh báng dyôn tinớng carna dyôn án pôq.’” ");
INSERT INTO pac_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Iki Yon lư tớq. Án át tớq ntúq aih, alứng án táq tíc na dơq dyôn nhéq máh ticuoi. Án pôq táq-ntêr dyôn nhéq máh ticuoi chom te arnáq tíc na dơq. Rit ndô táq tíc ticuoi khoiq ngin luaih pien cơt mít tamme loi, dŏq Yang Arbang-pilŏ́ng táh luaih nha-án. ");
INSERT INTO pac_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iki máh ticuoi át tớq vúng Yudê alứng tớq vel pưt Yaru-salem tớq nga án. Nha-án ngin luaih, dyơ án táq tíc na dơq dyôn nha-án tớq dơq crong Yôr-dan. ");
INSERT INTO pac_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yon báq tớc tampớc ngai táq na sóc pannán lac-da. Án kitớn eo ngcár tớq tarving. Án cha aliem alứng ngoiq dơq canyiel te arưih. ");
INSERT INTO pac_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Parnai án tông la idô: “Tatun bôn munáq loi tớq. Án ngki bôn chức pưt clưi cư. Cư lớiq crái díh lếh ntár cơp te dyưng án, co cư bôn chức két lư. ");
INSERT INTO pac_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Cư táq tíc dyôn inha na dơq sớng, ma án táq tíc dyôn inha na Arvai Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Vít te máh ingái ngki, Yê-su tớq te vel Na-saret, vúng Ca-lilê. Dyơ Yon táq tíc na dơq dyôn Yê-su tớq dơq crong Yôr-dan. ");
INSERT INTO pac_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tư Yê-su sớr te dơq, án hôm pilŏ́ng arớq ngai pốh, alứng bôn Arvai Yang Arbang-pilŏ́ng siar arớq achếq cacu bôt tớq cháq án. ");
INSERT INTO pac_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mui parrứh ngki bôn sieng tubau te pilŏ́ng tông idô: “Mái la Acái cư ndon cư amoih lư. Cư sáng bui cannính lư alứng mái.” ");
INSERT INTO pac_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hoi-ngki táp Arvai Yang Arbang-pilŏ́ng dông Yê-su pôq nga ntúq aih. ");
INSERT INTO pac_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yê-su át tớq ntúq aih nhéq puan chít idáu puan chít ingái. Ndóng máh ingái ngki yang Satán tớq thứq án, ính tardông án táq luaih. Án át tớq ntúq bôn pannán cruong, alứng tarneng Yang Arbang-pilŏ́ng siar choi án. ");
INSERT INTO pac_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Vít ngai cacháq Yon tớq coq tôt, Yê-su mot tớq vúng Ca-lilê, án cato parnai ŏ te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Án tông idô: “Khoiq tớq ngư dyơ, alứng tumán lư dyơ Yang Arbang-pilŏ́ng cơt sút máh ticuoi tin án. Iki cóq inha ngin luaih pien cơt mít tamme loi, alứng tin parnai ŏ te Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ndóng Yê-su pôq tớq tor dơq clóng Ca-lilê, án hôm bar náq em ai, nốh Si-môn alứng Anrê. Nha-án lai mben tớq dơq clóng, co arnáq nha-án la suo buaiq. ");
INSERT INTO pac_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yê-su tông nha-án idô: “Inha veng tapun cư, dyơ cư pasoi inha cơt ticuoi suo ticuoi arớq inha suo buaiq ndô tưi.” ");
INSERT INTO pac_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ndóng ngki táp nha-án táh mben, dyơ veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yê-su pôq biq loi, dyơ án hôm bar náq em ai cannŏ́h, nốh Yacơ alứng Yon, acái conh Sê-badê. Nha-án át clam mben tớq tuoc. ");
INSERT INTO pac_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ndóng ngki táp Yê-su tubau nha-án. Iki nha-án dyôn a-ám nha-án nốh Sê-badê át tớq tuoc alứng ticuoi thuthe. Dyơ nha-án bar náq veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Vít ngki, Yê-su alứng top rian te án mot tớq vel Cabê-na-um. Tớq ingái angô Yê-su mot tớq dúng rum alứng cato tớq ngki. ");
INSERT INTO pac_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nhéq ticuoi sáng dut lư te parnai án cato. Án cato arớq ticuoi bôn chức lư, ma tới arớq thới sái rit báq cato. ");
INSERT INTO pac_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tớq dúng rum ngki bôn munáq ticuoi bôn yang saq piyúh, alứng án hiar yứng lư idô: ");
INSERT INTO pac_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Amớh inha ính bôn te he, Yê-su te vel Na-saret? Mái tớq nga tudô co ính cachet he lớiq? Cư acớl mái tớq te Yang Arbang-pilŏ́ng, alứng mái lớiq bôn luaih amớh.” ");
INSERT INTO pac_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yê-su dyŏq yang saq ngki, idô: “Êq tacang! Mái ngốh viang te cháq ticuoi ndô!” ");
INSERT INTO pac_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Cua ngki yang saq carvít pitứng pitốq ticuoi ngki, dyơ án ngốh. Ndóng án ngốh, án hiar yứng lư. ");
INSERT INTO pac_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Máh ticuoi sáng dut lư, alứng munáq plốh munáq idô: “Imo têq án táq arnáq ndô? Án tông parnai tamme alứng bôn chức laq lư. Án dyŏq yang saq, alứng yang saq peh parnai án.” ");
INSERT INTO pac_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chái lư máh arnáq Yê-su táq cơt parhanh nga cứp vel ndon át tumán vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Vít Yê-su ngốh te dúng rum, án pôq munơi alứng Yacơ nha Yon, dyơ mot tớq dúng Si-môn nha Anrê. ");
INSERT INTO pac_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cuya-cán Si-môn bíq rom a-ái atóq cháq. Dyơ ngai tông dyôn Yê-su chom te ayáq ndô a-ái. ");
INSERT INTO pac_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yê-su tớq nga ayáq ngki, dyơ Yê-su tec ayôr. Tư ayáq ngki yôr, cháq án lớiq atóq nnáng, alứng rap lieh án angốh tanna dyôn tumoi cha. ");
INSERT INTO pac_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tớq ibư, mát pandang plot dyơ, ngai dông nhéq máh ticuoi a-ái alứng ticuoi bôn yang saq piyúh tớq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nhéq máh ticuoi tớq vel ngki parchúng culái tieh, tumán ngáh callống. ");
INSERT INTO pac_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yê-su táq bánh clứng ticuoi bôn a-ưi nốh a-ái. Án chuih angốh yang saq te cháq ticuoi hơ. Án lớiq dyôn yang saq táq-ntêr amớh, co yang saq acớl án. ");
INSERT INTO pac_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tớq ingái parnô, Yê-su ayư te cláih lư, pilŏ́ng iyốh ang. Án ngốh te vel, dyơ pôq nga ntúq ớq ticuoi át, co án ính cớu seq nga ntúq tuki. ");
INSERT INTO pac_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Si-môn alứng yớu án pôq suo Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tớq nha-án tumúh Yê-su, nha-án tông án idô: “Nhéq náq ticuoi suo ính tumúh thới.” ");
INSERT INTO pac_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yê-su ôi nha-án idô: “He cóq pôq tớq vel cannŏ́h loi, la máh vel át paniar ndô. Cư ính cato tớq vel ngki hơ. A-ám cư yua cư tớq nga tudô dŏq táq arnáq ndô.” ");
INSERT INTO pac_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iki Yê-su pôq cato tớq cứp dúng rum ticuoi Isa-ra-el tớq vúng Ca-lilê. Án chuih angốh yang saq te cháq ticuoi hơ. ");
INSERT INTO pac_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bôn munáq ticuoi a-ái bŏ́q tớq nga Yê-su. Án chóh tarcol alứng cucúh cucuoi idô: “Khán Ưlla ính, Ưlla têq táq dyôn cư cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yê-su sáng sruiq táq, dyơ án angốh ati capơiq ticuoi ngki, alứng tông idô: “Cư ính! Dyôn mái cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ndóng ngki táp ticuoi ngki cơt bánh a-ái bŏ́q. Cháq án cơt ŏ lieh. ");
INSERT INTO pac_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nsuoi te Yê-su ính yua án chô, Yê-su patáp án idô: ");
INSERT INTO pac_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Êq táq-ntêr dyôn ticuoi cannŏ́h chom te arnáq ndô. Ma mái pôq apáh cháq mái dyôn ticuoi teng rit sang me. Dyơ mái dông crơng mŏp sang dyôn Yang Arbang-pilŏ́ng máh nốh ndon Môi-se khoiq patáp te inớh. Arnáq ndô la tíc dyôn ticuoi cannŏ́h chom mái khoiq bánh dyơ.” ");
INSERT INTO pac_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma tư án ngốh vít te Yê-su, án pôq táq-ntêr dyôn ngai chom te arnáq Yê-su khoiq palai án. Arnáq ndô cơt rŏ́h mưt-mư. Khán Yê-su ính mot tớq vel mmo, án lớiq dyôn ngai hôm án. Án át culái tieh vel, tớq ntúq ớq ticuoi át. Ma nnáng bôn ticuoi te cứp ntúq tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Vít bar pe ingái loi, Yê-su chô lieh nga vel Cabê-na-um. Tư ngai sáng hanh án khoiq píh chô nga dúng án, ");
INSERT INTO pac_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","iki ngai pôq parchúng clứng lư nga tuki. Tớq ngáh callống lớiq bôn nnáng ntúq mot, nhéq tot máh ticuoi. Iki Yê-su cato parnai ŏ te Yang Arbang-pilŏ́ng dyôn nha-án cammáng. ");
INSERT INTO pac_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ndóng ngki bôn puan náq crang munáq ticuoi a-ái cớng dông nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma tư nha-án hôm clứng lư ticuoi át kiar Yê-su, nha-án lớiq chom na mmo ính mot nga Yê-su. Iki nha-án pốh mpuong dúng tardáng Yê-su át, dyơ atiar asiar carrang díh ticuoi a-ái ngki. ");
INSERT INTO pac_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tư Yê-su chom mít nha-án tin lư, iki án tông ticuoi a-ái cớng idô: “Acái ơi! Luaih mái, cư khoiq táh dyôn.” ");
INSERT INTO pac_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bôn máh thới sái rit ticu tớq ngki tưi. Nha-án parngíh idô: ");
INSERT INTO pac_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Imo ticuoi ndô tông iki? Án ính táq chức arớq Yang Arbang-pilŏ́ng tưi. Parnai án tông la arớq án acraiq Yang Arbang-pilŏ́ng dyơ. Lớiq bôn ticuoi mmo têq táh luaih. Nưm munáq Yang Arbang-pilŏ́ng táp têq táh luaih.” ");
INSERT INTO pac_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ndóng ngki táp Yê-su chom nha-án parngíh iki tớq mít cannính nha-án. Iki án plốh nha-án idô: “Imo inha parngíh iki? ");
INSERT INTO pac_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Parnai mmo inha sáng ien hơn cư tông: ‘Luaih mái, cư khoiq táh dyơ,’ lớiq la: ‘Mái yôr tayứng. Mái ial dual carrang mái, dyơ mái chô!’ ");
INSERT INTO pac_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma hoi-ndô cư ính táq dyôn ticuoi a-ái ndô cơt bánh, dyôn inha chom arlớih arlêng lư, cư Acái Yang Cơt Ticuoi bôn chức tớq cúc cuteq ndô. Cư têq táh luaih dyôn.” Dyơ ngki Yê-su tông ticuoi a-ái cớng idô: ");
INSERT INTO pac_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Cư yua mái yôr tayứng. Mái ial dual carrang mái, dyơ chô!” ");
INSERT INTO pac_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iki ticuoi ngki yôr tayứng. Án ial táp carrang án, dyơ án ngốh te ticuoi clứng. Tư nha-án hôm iki, nha-án sáng dut lư, alứng nha-án ayô Yang Arbang-pilŏ́ng. Nha-án tông idô: “He lớiq nai hôm arnáq arớq ndô.” ");
INSERT INTO pac_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Vít ngki Yê-su pôq sa nga tor dơq clóng. Clứng lư ticuoi parchúng lieh paniar án; dyơ án cato nha-án. ");
INSERT INTO pac_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ndóng án pôq, án hôm Lê-vi, acái Al-phê, át ticu tớq dúng ngai ial práq thêq. Iki, Yê-su yua Lê-vi idô: “Mái veng tapun cư.” Iki Lê-vi yôr tayứng alứng veng tapun án. ");
INSERT INTO pac_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cua ngki Yê-su pôq cha dôi nga dúng Lê-vi. Ma át ngki bôn clứng ticuoi ndon ial práq thêq, alứng ticuoi luaih cannŏ́h hơ át cha munơi alứng Yê-su nha top rian te án. Co bôn clứng ticuoi veng tapun án. ");
INSERT INTO pac_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bôn thới sái rit ndon cơt top Pha-rasi hôm Yê-su át cha munơi alứng ticuoi ial práq thêq nha ticuoi luaih cannŏ́h. Iki nha-án plốh top rian te Yê-su idô: “Imo án cha munơi alứng ticuoi ial práq thêq nha ticuoi luaih cannŏ́h?” ");
INSERT INTO pac_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yê-su sáng nha-án táq-ntêr iki, dyơ án tông nha-án idô: “Ticuoi bánh ŏ lớiq bôn seq dyôn ngai palai, ma nưm ticuoi a-ái sớng seq dyôn ngai palai. Cư tớq nga ndô, cư lớiq bôn arô ticuoi ndon ngin nha-án tinớng ŏ, ma cư arô ticuoi ndon chom nha-án bôn luaih.” ");
INSERT INTO pac_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Máh ticuoi rian te Yon alứng máh ticuoi Pha-rasi báq rêh ingái dŏq ót tanna co ính parngíh te ngê Yang Arbang-pilŏ́ng. Nha-án tớq plốh Yê-su idô: “Top rian te Yon alứng ticuoi ndon veng tapun top Pha-rasi, nha-án rêh ingái dŏq ót tanna. Ma imo top rian te thới lớiq táq arớq nha-án?” ");
INSERT INTO pac_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yê-su ôi lieh nha-án idô: “Khán bôn conh ial campái, ndóng yớu pôq carring, nha-án lớiq ót tanna co nha-án sáng bui. ");
INSERT INTO pac_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma tư ngai ial dông án, iki yớu án ót tanna dŏq ayư lieh án. ");
INSERT INTO pac_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Lớiq bôn ngai cupêl prới tamme tớq tampớc khoiq anhoh. Khán ngai táq iki, ntúq campêl ngki cucrónh alứng tiyot prới anhoh. Iki tarhaq ngki cơt pơh lư loi. ");
INSERT INTO pac_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Alứng lớiq bôn ngai cleng sieu tamme tớq aluoi ngcár tieq. Khán ngai táq iki, sieu ngki cơt pi-óq alứng táq dyôn aluoi ngcár cơt pôih, dyơ pidŏ́h. Ma sieu tamme, cóq cleng tớq aluoi ngcár tamme.” ");
INSERT INTO pac_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bôn mui Ingái Angô, Yê-su alứng top rian te án mot tớq pidái sro bali. Ntơnh nha-án pôq, ntơnh nha-án carớt sro bali. ");
INSERT INTO pac_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Top Pha-rasi tông ada Yê-su idô: “Imo top rian te thới táq lớiq cơt rit rong tớq Ingái Angô.” ");
INSERT INTO pac_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yê-su plốh nha-án idô: “Imo arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng tông te puo Davit khoiq táq? Davit alứng top veng tapun án ớq crơng tanna alứng nha-án sáng pinhaih lư. ");
INSERT INTO pac_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iki Davit mot tớq dúng sang Yang Arbang-pilŏ́ng. Án cha alứng án dyôn yớu án cha tưi beng ngai dŏq chứng mát Yang Arbang-pilŏ́ng. Beng ndô nưm ticuoi teng rit sang Yang Arbang-pilŏ́ng sớng têq cha. Ndóng ngki Abie-tha cơt ariaih top teng rit sang.” ");
INSERT INTO pac_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yê-su tông nha-án sa idô: “Co ticuoi, iki Yang Arbang-pilŏ́ng teng Ingái Angô. Tới co Ingái Angô, ma án teng ticuoi. ");
INSERT INTO pac_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cư Acái Yang Cơt Ticuoi la Ưlla tưi Ingái Angô.” ");
INSERT INTO pac_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bôn mui ingái, Yê-su mot sa tớq dúng rum ticuoi Isa-ra-el, alứng bôn munáq dyuot ati át tớq dúng sang ngki tưi. ");
INSERT INTO pac_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Alứng bôn ticuoi cannŏ́h át me nga Yê-su, co ính chom án táq bánh ticuoi dyuot tớq Ingái Angô ma lớiq. Nha-án sisuo callong luaih co ính cauq Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yê-su yua ticuoi dyuot ati idô: “Mái yôr tayứng chứng mát máh ticuoi ndô.” ");
INSERT INTO pac_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dyơ Yê-su plốh nha-án ndon át paniar ngki idô: “Khán veng rit he, amớh inha sáng piaiq hơn ngai táq tớq Ingái angô, piaiq ngai táq ŏ lớiq la táq saq? Piaiq ngai choi tamống lớiq la ngai cachet? Arnáq amớh inha sáng ŏ hơn?” Ma nha-án lớiq ôi amớh. ");
INSERT INTO pac_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yê-su me chôp nhéq nga nha-án. Án sáng uan lư co nha-án bôn mít cớng. Án yua ticuoi dyuot ngki idô: “Mái angốh ati!” Tư án angốh ati, dyơ ati án cơt bánh táp. ");
INSERT INTO pac_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iki top Pha-rasi ngốh táp te dúng rum alứng pôq tumúh top veng tapun puo Hê-rôt. Nha-án tanghúng ính cachet Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Vít ngki Yê-su alứng top rian te án ngốh te ngki, dyơ pôq nga tor dơq clóng. Ma bôn ticuoi clứng lư te vúng Ca-lilê tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tớq ngai sáng hanh te arnáq Yê-su táq, iki a-ưi ticuoi te vúng Yudê, te vel pưt Yaru-salem, te vúng I-dumê, te cruong ndon át anga pandang ngốh crong Yôr-dan, te vúng paniar vel Tirơ, alứng te vel Sadôn, tớq tưi. ");
INSERT INTO pac_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dyơ Yê-su yua top rian te án pôq manh tuoc, co án lớiq ính ticuoi clứng ngki tarsón cháq án. ");
INSERT INTO pac_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Co Yê-su khoiq táq bánh a-ưi ticuoi a-ái, iki clứng lư ticuoi a-ái tớq, munáq tarsón munáq co ính capơiq cháq án. ");
INSERT INTO pac_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma tư yang saq hôm Yê-su, nha-án mpop rarop chứng mát Yê-su. Nha-án tông yứng lư idô: “Inha la Acái Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma Yê-su dyŏq yang saq ngki êq táq-ntêr dyôn ticuoi cannŏ́h chom án la nnáu. ");
INSERT INTO pac_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yê-su sớr nga cóh, alứng án arô máh ticuoi ndon án ính dyôn tớq nga án. Iki nha-án tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Án rêh mui chít la bar náq dyôn át alứng án. Án anốh nha-án la top dyưng ati, alứng án patáp nha-án pôq tumo, cato tuki. ");
INSERT INTO pac_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Án dyôn nha-án bôn chức têq chuih angốh yang saq. ");
INSERT INTO pac_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Máh nốh top mui chít la bar náq án khoiq rêh la idô: Si-môn ndon Yê-su anốh Phi-er; ");
INSERT INTO pac_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yacơ alứng a-em án Yon, nha-án bar náq la acái conh Sê-badê. Yê-su anốh nha-án Bô-anêt loi. Parnai Bô-anêt titoiq lieh la ‘arớq crứm’. ");
INSERT INTO pac_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bôn díh Anrê, Phi-lip, Batê-lami, Mathie, Thô-mat, Yacơ acái conh Al-phê, Thadê, Si-môn Sê-lôt, ");
INSERT INTO pac_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","alứng Yuda I-cari-ôt, án ndon culieu Yê-su dyôn ngai cachet. ");
INSERT INTO pac_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Vít ngki Yê-su chô lieh nga dúng; dyơ clứng ticuoi pôq parchúng lieh nga ngki. Yê-su alứng top rian te án ớq díh chicha, co tot clứng ticuoi. ");
INSERT INTO pac_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tư em ai Yê-su sáng arnáq ndô, nha-án tớq ính dông angốh Yê-su te ticuoi clứng, co nha-án sáng ngai tông idô: “Án la arớq ticuoi yúh.” ");
INSERT INTO pac_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bôn máh thới sái rit siar te vel Yaru-salem. Nha-án tông idô: “Yê-su têq chuih angốh yang saq la co nhơ yang Bên-sabul ndon ariaih nhéq tưh yang saq át alứng án, alứng dyôn án bôn chức têq táq arnáq ngki.” ");
INSERT INTO pac_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iki Yê-su arô máh ticuoi ngki tớq nga án; dyơ án tông nha-án tớq parnai acám idô: “Imo hôi yang Satán chuih cháq án bôm? ");
INSERT INTO pac_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Khán mui cruong ma caryáh cơt bar top, dyơ top ndô tarchíl alứng top ngki, iki lớiq têq cơt nnáng cruong. ");
INSERT INTO pac_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Khán mui abŏ́h ma par-ốh tartuoq, ngki lớiq têq cơt nnáng abŏ́h. ");
INSERT INTO pac_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Khán top yang Satán, ma munáq tarchíl munáq, top ngki cơt partáh, alứng lớiq têq cơt nnáng top, dyơ cơt pít nhéq. ");
INSERT INTO pac_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Lớiq bôn ngai têq mot tớq dúng ticuoi bánh rêng alứng tôiq ial nhéq crơng án, khán ngai lớiq chóq án nsuoi. Cua ngki ngai têq pur ial nhéq crơng tớq dúng án. ");
INSERT INTO pac_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Cư tông inha arlớih lư, khán ticuoi mmo acraiq nốh Yang Arbang-pilŏ́ng, lớiq la táq luaih cannŏ́h, nhéq luaih ngki Yang Arbang-pilŏ́ng têq táh dyôn. ");
INSERT INTO pac_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma khán ticuoi mmo acraiq Arvai Yang Arbang-pilŏ́ng, lư Yang Arbang-pilŏ́ng lớiq nai táh luaih dyôn ticuoi ngki. Ticuoi ngki bôn luaih níc-níc.” ");
INSERT INTO pac_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yê-su cato iki co nha-án tông idô: “Bôn yang saq át alứng án.” ");
INSERT INTO pac_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dyơ a-i alứng a-em Yê-su tớq nga tuki. Nha-án tayứng culái tieh dúng alứng yua ngai pôq cớiq Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Clứng ticuoi ticu paniar Yê-su. Ngai tông án idô: “Ngki! A-i alứng a-em thới át culái tieh. Nha-án ính tumúh thới.” ");
INSERT INTO pac_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma Yê-su plốh lieh nha-án idô: “Nnáu la a-i alứng a-em cư?” ");
INSERT INTO pac_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dyơ án caplang me nga máh ticuoi ndon ticu paniar án, alứng án tông idô: “Ndô la a-i alứng a-em cư. ");
INSERT INTO pac_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nha-án ndon táq veng ngê Yang Arbang-pilŏ́ng la a-i alứng a-em cư.” ");
INSERT INTO pac_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yê-su tabớq cato sa tumán tor dơq clóng. Clứng lư ticuoi tớq nga án. Iki án sớr ticu tớq tuoc át tớq dơq. Ma máh ticuoi clứng ngki át tớq tor dơq. ");
INSERT INTO pac_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dyơ án cato nha-án te a-ưi nốh tớq parnai acám idô: ");
INSERT INTO pac_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Inha cammáng! Bôn munáq ticuoi pôq trứh callong mma. ");
INSERT INTO pac_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ndóng án trứh, bôn callong atôh tớq carna. Dyơ achếq srúp tóh cha viang callong ngki. ");
INSERT INTO pac_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bôn callong cannŏ́h atôh tớq cuteq kida, tadưp nhéq cantar. Dyơ chái lư callong ngki hŏn, co cuteq lớiq bôn sru. ");
INSERT INTO pac_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma tớq mát pandang ngốh puoq téng-péng lư, bát ngki cơt ngngot, co riaih lớiq sru. Dyơ án ráng. ");
INSERT INTO pac_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bôn callong cannŏ́h atôh tớq cuteq bôn a-ưi sác tangháng. Tư sác tangháng hŏn, án cluom nhéq bát te callong ticuoi trứh. Iki bát ngki lớiq cơt culái. ");
INSERT INTO pac_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Alứng bôn callong cannŏ́h loi atôh tớq cuteq ŏ. Callong ngki hŏn ŏ alứng cơt culái ŏ. Mui tôm cơt pe chít callong. Mui tôm loi cơt tupát chít callong. Mui tôm loi cơt mui culám callong.” ");
INSERT INTO pac_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dyơ Yê-su tông loi idô: “Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng.” ");
INSERT INTO pac_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tớq ticuoi clứng chô nhéq dyơ, Yê-su át alứng mui chít la bar náq top rian te án, dyơ nha-án plốh án te parnai acám ngki. ");
INSERT INTO pac_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yê-su tông nha-án idô: “Yang Arbang-pilŏ́ng khoiq dyôn inha chom dyơ parnai clôp te Yang Arbang-pilŏ́ng cơt sút; ma máh ticuoi cannŏ́h sáng máh parnai ngki nưm tớq parnai acám sớng. ");
INSERT INTO pac_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yang Arbang-pilŏ́ng tông iki, dŏq dyôn: ‘Ngai me níc, ma lớiq hôm. Ngai sáng níc, ma lớiq apúh. Khán ngai hôm alứng apúh, dáh lơ ngai ính tin alứng veng tapun Yang Arbang-pilŏ́ng tưi. Dyơ Yang Arbang-pilŏ́ng táh luaih dyôn ngai tưi.’” ");
INSERT INTO pac_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yê-su plốh nha-án idô: “Khán inha lớiq chom parnai acám ndô, imo têq inha chom máh parnai acám cannŏ́h? ");
INSERT INTO pac_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ticuoi ndon trứh callong, la án trứh parnai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bôn ticuoi ráp ial parnai Yang Arbang-pilŏ́ng arớq callong atôh tớq carna. Tư ngai cato parnai ngki, nha-án cammáng parnai ngki, ma yang Satán tớq táp alứng ial nhéq parnai ngki te mít nha-án. ");
INSERT INTO pac_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bôn ticuoi cannŏ́h ráp ial parnai ngki arớq callong atôh tớq cuteq kida, tadưp nhéq cantar. Tư ngai cato parnai ngki, nha-án cammáng alứng chái lư nha-án sŏ́ng tin parnai ngki bui ŏ. ");
INSERT INTO pac_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma nha-án lớiq bôn riaih sru. Nha-án tumống muhoi sớng. Khán nha-án tumúh dieiq arức co tian nha-án tin parnai ngki, ngki nha-án lớiq tin nnáng. ");
INSERT INTO pac_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bôn ticuoi cannŏ́h loi ráp ial parnai ngki arớq callong atôh tớq cuteq bôn sác tangháng. Tư ngai cato parnai ngki, nha-án cammáng parnai ngki. ");
INSERT INTO pac_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ma mít nha-án át lo khít tớq pang ndô; nha-án ham súc bôn alứng ham máh arnáq cannŏ́h hơ. Dyơ máh arnáq ngki cluom viang nhéq parnai ngki, táq dyôn lớiq cơt culái. ");
INSERT INTO pac_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma bôn ticuoi cannŏ́h loi ráp ial parnai Yang Arbang-pilŏ́ng arớq callong atôh tớq cuteq ŏ. Tư ngai cato parnai ngki, nha-án cammáng alứng ial lư máh parnai ngki. Nha-án cơt culái. Mui tôm cơt pe chít. Mui tôm cơt tupát chít. Mui tôm loi cơt mui culám.” ");
INSERT INTO pac_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yê-su tông loi idô: “Lớiq bôn ngai bet den tớu, dyơ catứp tớq yáng, lớiq la dŏq tadưp kichơng. Ma lư ngai dŏq tớq aruong den. ");
INSERT INTO pac_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Muchứng ngki tưi, nốh amớh ngai catốq hoi-ndô, urớh nhéq tưh ticuoi bôn hôm arlớih máh nốh ngki. Nốh amớh ngai táq clôp hoi-ndô, urớh nhéq tưh ticuoi bôn chom arlớih nốh ngki. ");
INSERT INTO pac_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng.” ");
INSERT INTO pac_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yê-su cato loi nha-án idô: “Cóq inha cammáng dyôn arlớih te parnai ndon inha sáng cư tông. Máh-mmo inha dyôn ticuoi cannŏ́h, lư máh ngki tưi Yang Arbang-pilŏ́ng dyôn lieh inha, alứng án dyôn clưi te ngki loi. ");
INSERT INTO pac_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ticuoi mmo khoiq bôn dyơ, Yang Arbang-pilŏ́ng dyôn án bôn a-ưi lư loi. Ma ticuoi mmo lớiq bôn, máh callong án khoiq bôn dyơ, lư pít lieh nhéq.” ");
INSERT INTO pac_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yê-su tông loi idô: “Yang Arbang-pilŏ́ng cơt sút la arớq munáq ticuoi chớt sro tớq pidái. Dyơ án chớt, án chô nga dúng. ");
INSERT INTO pac_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Idáu án bíq, ingái án pôq táq arnáq. Ma sro ndon án chớt ngki chóng ính hŏn bôm. Cua sro hŏn, tôm sro cơt pưt asớr. Ma ticuoi ưlla sro lớiq chom imo callong mma ngki hŏn. ");
INSERT INTO pac_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cuteq apu ama sro ngki dyôn hŏn. Nsuoi lư bôn ula, alứng tatun bôn panung. Ma tatun loi bôn culái. ");
INSERT INTO pac_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tớq sro dom, ưlla pidái ial liem pôq ráiq sro, co khoiq tớq ngư dyơ ráiq sro.” ");
INSERT INTO pac_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yê-su plốh loi: “He ính tông te Yang Arbang-pilŏ́ng cơt sút la arớq amớh? Alứng he ính ial parnai acám amớh acám te sút ngki? ");
INSERT INTO pac_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sút ngki la arớq mui callong me. Ndóng ngai trứh callong ngki tớq cuteq, callong ngki két clưi nhéq te callong cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma tớq án hŏn, án pưt clưi nhéq te tôm sác cannŏ́h. Án bôn abeng pưt, têq dyôn achếq táq sáp tớq ngki.” ");
INSERT INTO pac_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yê-su cato parnai Yang Arbang-pilŏ́ng tớq a-ưi parnai acám dyôn nha-án têq chom máh-mmo nha-án têq apúh. ");
INSERT INTO pac_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Án lớiq bôn cato nha-án amớh ma lớiq cato tớq parnai acám. Ma tớq án át alứng top rian te án, án angốh ngê dyôn nha-án chom arlớih lư te máh nốh te parnai acám. ");
INSERT INTO pac_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ingái ngki tớq sưm-turưm, Yê-su tông top rian te án idô: “Pôq he! He pôq dyáng atóh loi.” ");
INSERT INTO pac_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dyơ top nha-án ngốh te ticuoi clứng, alứng dông Yê-su na tuoc. Bôn tuoc cannŏ́h pôq tưi. ");
INSERT INTO pac_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma tatun ngki bôn cuyiel arpuq alứng dơq lampóh hớp lư. Dơq kichíh tớq tuoc alứng lampóh saiq amot tớq tuoc tumán ính trim. ");
INSERT INTO pac_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yê-su bíq tacual tarcual nga soi tuoc. Top rian te án pasớt án alứng tông idô: “Thới ơi! Imo thới lớiq rớu? He tumán ính cuchet dyơ!” ");
INSERT INTO pac_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yê-su yôr tayứng; án dyŏq cuyiel alứng yua dơq clóng idô: “Át a-ŏ. Mái êq lampóh nnáng.” Dyơ cuyiel tangít, alứng bôn ien ŏ lieh. ");
INSERT INTO pac_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dyơ án plốh nha-án idô: “Imo inha adáh? Imo inha iyốh tin sa?” ");
INSERT INTO pac_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma nha-án sáng chếq. Dyơ munáq plốh munáq idô: “Ticuoi ndô la nnáu? Imo cuyiel alứng dơq cammáng án!” ");
INSERT INTO pac_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tớq Yê-su alứng top rian te án khoiq ticáng clóng Ca-lilê, nha-án tớq nga cruong Yê-rasê. ");
INSERT INTO pac_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tư Yê-su siar te tuoc, ndóng ngki táp ticuoi conh ndon bôn yang saq piyúh ngốh te carlom cumuiq tớq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Án át níc tớq carlom cumuiq. Lớiq bôn ngai têq tacáp án nnáng tớq ntár sic. ");
INSERT INTO pac_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A-ưi cantứq te nsuoi ngai clieng dyưng nha ati án tớq callieng alứng sic. Ma án táq sic ti-ŏ́h nhéq alứng án alcáiq nhéq callieng, alứng lớiq bôn ngai bôn rêng têq táq dyôn án cơt alvai lieh. ");
INSERT INTO pac_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Idáu alứng ingái án át níc tớq carlom cumuiq, lớiq la tớq cóh. Án hiar níc alứng án chic cháq án bôm na búl dyôn bác. ");
INSERT INTO pac_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ma tớq án hôm Yê-su nnáng te yông, án lúh nga Yê-su, alứng án chóh tarcol chứng mát Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Án hiar yứng lư idô: “Amớh inha ính táq ada he, Yê-su? Inha la Acái Yang Arbang-pilŏ́ng, án ndon sút clưi nhéq te cannŏ́h. He seq te inha chứng mát Yang Arbang-pilŏ́ng êq táq toiq bap ada he.” ");
INSERT INTO pac_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Án tông iki co án khoiq sáng Yê-su yua án idô: “Yang saq! Mái ngốh táp te cháq ticuoi ndô.” ");
INSERT INTO pac_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dyơ Yê-su plốh án: “Amớh nốh mái?” Án ôi: “Nốh he la Pớl, co he bôn clứng lư.” ");
INSERT INTO pac_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ticuoi ngki tarseq tarsuong te Yê-su êq chuih top yang saq te cruong ngki. ");
INSERT INTO pac_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tumán ngki bôn cóh alứng bôn cantóh alic át suo cha. ");
INSERT INTO pac_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iki máh yang saq seq te Yê-su idô: “Dyôn he mot tớq cantóh alic ngki.” ");
INSERT INTO pac_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yê-su dyôn nha-án mot. Iki nha-án ngốh te cháq ticuoi, dyơ mot tớq cantóh alic. Dyơ cantóh alic ngki lúh chái lư na acáng alứng páh-apŏ́ng nga dơq clóng, dyơ tumic cuchet nhéq. Alic ngki bôn sám bar ngin lám. ");
INSERT INTO pac_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Máh ticuoi bán alic lúh chô tông ticuoi tớq vel alứng ticuoi ndon át tớq panu pidái chom tưi te arnáq nha-án khoiq hôm. Máh ticuoi ngki pôq me amớh ndon táq ada alic. ");
INSERT INTO pac_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tư nha-án tớq nga Yê-su, nha-án hôm ticuoi ndon bôn pớl yang saq át hoi-nsuoi ticu tớq ngki. Án tớc tampớc alứng lớiq bôn cơt yúh nnáng. Iki nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Máh ticuoi ndon khoiq hôm arnáq te ticuoi bôn yang saq piyúh alứng te cantóh alic, iki nha-án chô táq-ntêr dyôn ticuoi cannŏ́h chom tưi. ");
INSERT INTO pac_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dyơ máh ticuoi ngki seq Yê-su ngốh te cruong nha-án. ");
INSERT INTO pac_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iki Yê-su sớr lieh tớq tuoc. Ndóng ngki táp ticuoi bôn yang saq te nsuoi tớq nga Yê-su, alứng án cucúh cucuoi seq pôq tưi alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma Yê-su lớiq dyôn án pôq, alứng yua án idô: “Mái chô nga dúng, alứng táq-ntêr dyôn máh ticuoi tớq abŏ́h mái chom te máh arnáq Yang Arbang-pilŏ́ng khoiq choi mái, alứng sruiq táq mái.” ");
INSERT INTO pac_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iki án chô. Dyơ án táq-ntêr dyôn máh ticuoi tớq cruong Dê-ca-palớt chom tưi te arnáq pưt Yê-su khoiq táq dyôn án. Nhéq máh ticuoi ngki sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Vít ngki Yê-su sớr lieh tớq tuoc alứng píh lieh pa dyang atóh dơq. Tư Yê-su tớq nga tor pa dyáng atóh, bôn clứng lư ticuoi tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bôn munáq conh nốh Yaru, án cơt sút mui dúng rum ticuoi Isa-ra-el. Án chóh tarcol alứng mpop tumán dyưng Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Án cucúh seq te Yê-su idô: “Acái cán cư a-ái ntróq lư, tumán ính cuchet dyơ. Cư seq thới pôq capơiq tớq cháq án, dyôn án têq cơt bánh alứng bôn tumống.” ");
INSERT INTO pac_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iki Yê-su pôq alứng án. Clứng ticuoi cannŏ́h veng Yê-su tưi. Nha-án át chôp paniar Yê-su alứng són Yê-su hơ. ");
INSERT INTO pac_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bôn munáq cán ndon bôn a-ái dyứp nnai khoiq muchít la bar cumo dyơ, alứng lớiq nai dyớt. ");
INSERT INTO pac_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Án khoiq pôq tumúh a-ưi náq ticuoi palai. Án pít nhéq tien práq dŏq palai, ma lớiq bôn khaq amớh. Ma hoi-ndô án a-ái ntáng lư loi. ");
INSERT INTO pac_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tư án sáng ngai táq-ntêr te Yê-su, iki án pôq át tớq pandi ticuoi clứng. Án át pa crŏ́ng Yê-su; dyơ án capơiq au thor Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Co án khoiq parngíh idô: “Ncháng cư bôn capơiq tampớc Yê-su sớng, cư lư cơt bánh táp.” ");
INSERT INTO pac_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ndóng ngki táp aham án dyớt, alứng án lớiq sáng a-ái nnáng tớq cháq án. ");
INSERT INTO pac_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yê-su chom táp rêng ngốh te cháq án dyôn cơt arnáq ndô. Án píh me nga ticuoi clứng, alứng án plốh idô: “Nnáu capơiq au cư?” ");
INSERT INTO pac_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Top rian te Yê-su ôi: “Thới hôm dyơ, bôn clứng ticuoi tarsón thới. Imo nnáng thới plốh: ‘Nnáu capơiq cư?’” ");
INSERT INTO pac_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma Yê-su tilêq me nga ticuoi clứng ính chom ticuoi mmo capơiq au án. ");
INSERT INTO pac_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Cán ngki dyandyír adáh lư, co án khoiq capơiq au Yê-su, dyơ cơt bánh. Iki án tớq nga Yê-su, alứng án mpop tumán dyưng Yê-su. Án tông Yê-su tinớng lư. ");
INSERT INTO pac_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yê-su tông án idô: “Ama ơi! Cháq mái cơt bánh, co mái tin. Mái chô bánh suanh ien ŏ. Mái lư lớiq cơt a-ái nnáng arớq ndô.” ");
INSERT INTO pac_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ndóng Yê-su nnáng táq-ntêr alứng cán ngki, bôn bar pe náq te dúng Yaru ndon sút mui dúng rum ticuoi Isa-ra-el, tớq. Nha-án tông Yaru idô: “Acái cán mái khoiq cuchet dyơ. Imo mái nnáng pidieiq thới?” ");
INSERT INTO pac_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma Yê-su lớiq cammáng parnai nha-án tông. Án tông Yaru idô: “Êq adáh, mái tin sớng.” ");
INSERT INTO pac_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Vít ngki Yê-su dyôn Phi-er, Yacơ, alứng Yon a-em Yacơ, pôq alứng án. Ma ticuoi cannŏ́h, án lớiq dyôn pôq. ");
INSERT INTO pac_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tư nha-án tớq nga dúng Yaru, Yê-su hôm clứng ticuoi nhiem atíh alứng cuc yứng lư. ");
INSERT INTO pac_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Án mot tớq dúng alứng plốh nha-án idô: “Imo inha nhiem alứng cuc yứng lư? Mun ngki lớiq bôn cuchet; án bíq sớng.” ");
INSERT INTO pac_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma nha-án ayê tar-ac Yê-su. Iki Yê-su chuih angốh nhéq nha-án te dúng. Án dông a-i a-ám cán ngki alứng pe náq top rian te án sớng mot nga ntúq ngai dŏq cumuiq. ");
INSERT INTO pac_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Án tec ati mun ngki alứng tông idô: “Tali-tha cumi.” Parnai ndô titoiq lieh la “Mun ơi! Mái yôr tayứng.” ");
INSERT INTO pac_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ndóng ngki táp mun ngki yôr tayứng. Dyơ án têq pôq lieh. (Anhúq án khoiq bôn muchít la bar cumo.) Máh ticuoi ndon át ngki sáng dut lư tớq nha-án hôm mun ngki tumống lieh. ");
INSERT INTO pac_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma Yê-su patáp nha-án idô: “Êq táq-ntêr te arnáq ndô dyôn ticuoi cannŏ́h chom. Inha ial crơng tanna dyôn án cha.” ");
INSERT INTO pac_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Vít ngki Yê-su ngốh te ntúq ngki; án chô lieh nga vel án la vel Na-saret. Top rian te án pôq alứng án tưi. ");
INSERT INTO pac_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tớq Ingái Angô án pôq cato tớq dúng rum ticuoi Isa-ra-el. Máh ticuoi ndon cammáng sáng dut lư. Nha-án tarplốh idô: “Te mmo conh ndô bôn parnai idô? Imo án bôn callong tubáiq a-ưi lư, alứng têq táq a-ưi arnáq sileh?” ");
INSERT INTO pac_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Alứng nha-án tông loi: “Lư ma lớiq, án la thơq táq pan, acái Mari? Lư ma lớiq án la ai Yacơ, Yuda, alứng Si-môn? Lư ma lớiq, a-em cán án át alứng he?” Nha-án pamat Yê-su co nha-án sáng lớiq êm te parnai án cato iki. ");
INSERT INTO pac_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yê-su tông nha-án idô: “Khán bôn munáq ticuoi pôq cato parnai Yang Arbang-pilŏ́ng tớq vel cannŏ́h, ticuoi tớq vel ngki lư dyám náp án. Ma khán án cato tớq vel án bôm, lớiq la tớq abŏ́h án bôm, lư nha-án lớiq dyám náp án.” ");
INSERT INTO pac_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Iki Yê-su lớiq têq táq a-ưi arnáq sileh tớq vel án bôm. Ma án capơiq nưm tớq pe puan náq ticuoi a-ái sớng, alứng táq dyôn nha-án cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Án sáng dut lư, co ticuoi tớq vel ngki lớiq tin. Dyơ án pôq cato nga cứp vel ndon át tumán vel ngki loi. ");
INSERT INTO pac_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yê-su arô top mui chít la bar náq ndon rian te án, alứng án yua nha-án pôq tudô, pôq tuki, pôq tutíh, bar náq pôq munơi. Án dyôn nha-án bôn chức rap chuih angốh yang saq. ");
INSERT INTO pac_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Án patáp nha-án idô: “Inha pôq pitứng, pôq pitốq, êq dông amớh. Êq dông crơng tanna; êq báq tui; alứng êq dông práq. Ma têq inha dông mui ntráih tarlông. ");
INSERT INTO pac_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Têq dếq cơp. Ma êq sứp bar pláh au.” ");
INSERT INTO pac_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dyơ án patáp loi nha-án idô: “Inha mot tớq vel mmo, inha át tớq mui dúng sớng tingôi ingái inha ngốh te vel ngki. ");
INSERT INTO pac_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Khán inha mot tớq vel, ma ngai lớiq ráp pasôl ŏ inha, alứng ngai lớiq ính cammáng parnai inha; tớq inha ngốh te vel ngki, cóq inha tangkhír cuteq mbúi te dyưng, táq tíc ticuoi tớq vel ngki lớiq ráp inha.” ");
INSERT INTO pac_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iki nha-án mui chít la bar náq ngốh te ngki. Nha-án cato máh ticuoi cóq pien cơt mít tamme loi. ");
INSERT INTO pac_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nha-án chuih angốh a-ưi yang saq, alứng nha-án tir dơq nseng o-li-vê tớq cháq máh ticuoi a-ái dyôn cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Puo Hê-rôt An-tipa khoiq sáng te arnáq ndô, co nốh Yê-su cơt rŏ́h mưt-mư cứp vel. Bôn ticuoi ndon tông idô: “Yon ndon táq tíc na dơq yôr tumống lieh te ping. Co iki án bôn chức têq táq arnáq sileh.” ");
INSERT INTO pac_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma bôn ticuoi cannŏ́h tông idô: “Án ndô la Ê-li.” Bôn ticuoi cannŏ́h loi tông idô: “Án ndô la munáq tang ngcang Yang Arbang-pilŏ́ng, arớq ticuoi tang ngcang te inớh tưi.” ");
INSERT INTO pac_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma tư Hê-rôt An-tipa sáng ngai táq-ntêr te Yê-su, án tông idô: “Yon ndon cư khoiq yua ngai ticŏ́h ticong te nsuoi, hoi-ndô án tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Án tông iki, co án khoiq dyôn ngai cŏp Yon te nsuoi, alứng cacháq tớq coq tôt. Án táq iki la co tian Hê-rô-die campái án sáng uan lư ada Yon. Co te nsuoi Hê-rô-die la campái Phi-lip, a-em án. Ma án ial cán ngki táq campái án loi. ");
INSERT INTO pac_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ma Yon khoiq tíq án idô: “Khán mái ial campái a-em mái, iki mái táq luaih tớq phep rit.” ");
INSERT INTO pac_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Co Yon khoiq tông iki a-ưi chư, iki Hê-rô-die sáng uan lư ada Yon, alứng án ính Hê-rôt An-tipa cachet Yon. ");
INSERT INTO pac_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ma án lớiq têq, co Hê-rôt adáh Yon, co Hê-rôt chom Yon la ticuoi tinớng ŏ alứng mmar na Yang Arbang-pilŏ́ng. Iki Hê-rôt An-tipa lớiq dyôn ngai cachet Yon. Tư án cammáng parnai Yon cato, án cơt tambang parngíh. Ma án ính lư cammáng Yon cato. ");
INSERT INTO pac_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma ingái Hê-rô-die bôn cachet Yon la ingái Hê-rôt An-tipa cha ayư ingái a-i án carnian án. Iki án táq mui pêl pưt dŏq cha bui alứng máh ticuoi sút tadưp án, ticuoi sút líng, alứng ticuoi ndon bôn chức tớq vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tư acái cán Hê-rô-die mot tớq callúng ngai cha, án ayưn pon liauq. Hê-rôt alứng máh tumoi sáng bui lư te án ayưn. Dyơ Hê-rôt tông án idô: “Amớh mái ính bôn, mái seq te cư. Cư lư dyôn a mái ngki.” ");
INSERT INTO pac_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hê-rôt cantŏ́h callih ada cán ngki idô: “Amớh mái seq te cư, cư lư dyôn mái nốh ngki. Khán mái ính bôn mui calláh cruong cư, la cư dyôn.” ");
INSERT INTO pac_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dyơ cán ngki ngốh chô plốh a-i án idô: “Nốh amớh mái ính cư seq te puo Hê-rôt?” A-i án ôi: “Mái seq plô Yon ndon táq tíc na dơq.” ");
INSERT INTO pac_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cán ngki talúh táp nga puo Hê-rôt alứng seq idô: “Cư seq plô Yon ndon táq tíc na dơq. Seq mái cacháq plô án tớq adien hoi-ngki táp.” ");
INSERT INTO pac_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Puo sáng anguaq lư, ma co án khoiq cantŏ́h callih chứng mát máh ticuoi tumoi, iki án lớiq ính táh nnáng parnai án khoiq ưq te nsuoi. ");
INSERT INTO pac_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dyơ puo yua líng pôq ticŏ́h ticong Yon alứng dông nga cán ngki. Líng ngki mot tớq coq, alứng ticŏ́h ticong Yon. ");
INSERT INTO pac_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Líng ngki dŏq plô Yon tớq adien, dyơ dông achô dyôn cán ngki. Dyơ cán ngki dông achô dyôn a-i án. ");
INSERT INTO pac_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tớq top rian te Yon sáng arnáq ngki, nha-án pôq ial cháq Yon dông tứp tớq ping. ");
INSERT INTO pac_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Máh ticuoi dyưng ati ndon Yê-su khoiq yua dyôn pôq cato tớq cứp vel, nha-án píh chô nga Yê-su, alứng tông án te máh arnáq nha-án khoiq táq alứng khoiq cato. ");
INSERT INTO pac_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yê-su tông lieh nha-án idô: “He pôq nưm he sớng nga ntúq lớiq bôn ticuoi át. He át angô tuki avai.” Án tông iki co clứng ticuoi lulieh pôq chô níc nga án, tingôi nha-án ớq díh chicha. ");
INSERT INTO pac_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dyơ nha-án sớr tớq tuoc, ính pôq mui ntúq ớq ticuoi át. ");
INSERT INTO pac_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma clứng ticuoi hôm nha-án pôq, alứng ngai acớl nha-án. Iki ngai talúh te máh vel pôq côn nga ntúq Yê-su ính tớq. ");
INSERT INTO pac_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tư Yê-su siar te tuoc, án hôm clứng lư ticuoi. Án sáng sruiq táq, co nha-án arớq pannán cưu ớq ticuoi kiaq me. Iki án tabớq cato nha-án a-ưi nốh. ");
INSERT INTO pac_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tumán mát pandang tangcưl cóh, top rian te Yê-su tớq nga án alứng tông án idô: “Ntúq ndô yông te ticuoi át, alứng khoiq tumán idáu dyơ. ");
INSERT INTO pac_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Seq thới yua ticuoi clứng ndô chô, mot tớq vel paniar ndô, alứng dyôn nha-án plới bôm crơng tanna cha.” ");
INSERT INTO pac_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Yê-su ôi nha-án idô: “Inha táp dyôn nha-án bôn crơng tanna cha.” Iki nha-án plốh Yê-su: “Thới ính he pôq plới crơng tanna tớq bar culám callong práq dyôn cứp náq ticuoi ndô cha lớiq?” ");
INSERT INTO pac_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yê-su plốh lieh nha-án idô: “Sếq lám beng inha bôn? Inha pôq me avai.” Tư nha-án me, nha-án tông án idô: “He bôn sông lám beng, alứng bar lám buaiq.” ");
INSERT INTO pac_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dyơ Yê-su yua top rian te án mpô máh ticuoi ngki ticu cơt top tớq sác asam. ");
INSERT INTO pac_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Iki nha-án ticu cơt a-ưi top. Mui top bôn mui culám náq. Mui top bôn sông chít náq. ");
INSERT INTO pac_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yê-su ial sông lám beng alứng bar lám buaiq. Dyơ án tingưi nga pilŏ́ng alứng si-ơn Yang Arbang-pilŏ́ng bôn crơng tanna ndô. Cua ngki án péq beng alứng avôi dyôn top rian te án mpô dyôn máh ticuoi cha. Án dyôn mpô bar lám buaiq hơ dyôn nhéq máh ticuoi ngki cha. ");
INSERT INTO pac_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Cứp náq cha sái nhéq. ");
INSERT INTO pac_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cua nha-án cha, top rian te Yê-su pachúng lieh máh beng alứng buaiq ndon clưi te nha-án cha, bôn pớnh mui chít la bar carie. ");
INSERT INTO pac_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Máh ticuoi conh sasai bôn sông ngin náq ndon cha beng ngki. ");
INSERT INTO pac_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Cua ngki Yê-su yua top rian te án sớr tớq tuoc alứng pôq nsuoi án nga tor pa dyáng atóh nga vel Bet-sada. Dyơ án yua máh ticuoi clứng ngki chô nga vel nha-án. ");
INSERT INTO pac_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Vít nha-án chô, án sớr tớq cóh ính cớu seq tuki. ");
INSERT INTO pac_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tớq pilŏ́ng khoiq idáu dyơ, top rian te Yê-su át tớq tuoc pandi dơq clóng. Ma Yê-su át munáq án tớq pứh tumán dơq. ");
INSERT INTO pac_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yê-su hôm top rian te án cor tuoc dieiq arức lư, co cuyiel phớt plớq tuoc nha-án. Pilŏ́ng tumán sưm-turưm, Yê-su tớq nga nha-án. Án ticaq tớq lar dơq. Án tumán pôq tilớt nha-án. ");
INSERT INTO pac_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma tư nha-án hôm án ticaq pôq tớq lar dơq, nha-án parngíh cumuiq lánh; ngki nha-án hiar yứng lư. ");
INSERT INTO pac_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Co cứp náq nha-án hôm nhéq, iki nha-án sáng adáh lư. Ma ndóng ngki táp Yê-su tông nha-án idô: “Dyôn mít inha át ien ŏ. Ndô la cháq cư. Êq adáh.” ");
INSERT INTO pac_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dyơ án sớr át tớq tuoc alứng nha-án tưi, alứng cuyiel tangít. Nha-án sáng dut lư, ");
INSERT INTO pac_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","co nha-án lớiq bôn apúh te arnáq Yê-su táq ndóng án péq beng te nsuoi. Co mít nha-án yôl cớng. ");
INSERT INTO pac_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dyơ nha-án dyang dơq na tuoc nga cruong Canê-saret, alứng nha-án chóq tuoc tớq tor. ");
INSERT INTO pac_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tư nha-án siar te tuoc, máh ticuoi acớl táp Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dyơ nha-án mmar talúh chô nga vel nha-án, alứng dông ticuoi a-ái tớq carrang. Khán nha-án sáng Yê-su át tớq ntúq mmo, nha-án dông ticuoi a-ái nga ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nga ntúq mmo Yê-su pôq, tam vel két lớiq la vel pưt, ma ngai dông ticuoi a-ái parchúng nga ntúq ngki. Nha-án cucúh seq te Yê-su dyôn máh ticuoi a-ái capơiq biq mbaiq au thor án. Ticuoi mmo capơiq, cháq ticuoi ngki lư cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bôn ticuoi te top Pha-rasi alứng thới sái rit tớq te vel Yaru-salem át rum paniar Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nha-án hôm top rian te Yê-su chicha ma lớiq arau ati veng rit. ");
INSERT INTO pac_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Co top Pha-rasi alứng nhéq máh ticuoi Isa-ra-el cannŏ́h, khán nha-án lớiq arau ati veng rit achúc achiac, ngki nha-án lớiq têq cha. ");
INSERT INTO pac_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tớq nha-án chô te ntúq táiq plới, khán nha-án lớiq arau ati, ngki nha-án lớiq têq cha. Alứng bôn a-ưi rit cannŏ́h loi nha-án veng, arớq rit arau adéh tingan. ");
INSERT INTO pac_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iki máh ticuoi Pha-rasi alứng thới sái rit plốh Yê-su idô: “Imo top rian te thới lớiq táq veng rit achúc achiac he? Imo nha-án cha ma lớiq arau ati veng rit?” ");
INSERT INTO pac_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yê-su ôi nha-án idô: “Te inớh, Ê-sai khoiq taran piaiq lư te inha, la ticuoi táq náh-nnan sớng. Yang Arbang-pilŏ́ng yua án tông idô: ‘Máh ticuoi ndô ayô cư nưm na ngcang, ma mít cannính nha-án át yông te cư. ");
INSERT INTO pac_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nha-án sang tám cư, ma nha-án sang tám lớiq cơt callong. Nha-án cato máh rit rong ndon chóng ngốh te ticuoi.’” ");
INSERT INTO pac_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Alứng Yê-su tông loi idô: “Inha táh máh callong ndon Yang Arbang-pilŏ́ng khoiq patáp, ma inha capol khớm lư rit rong ticuoi.” ");
INSERT INTO pac_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Dyơ Yê-su achuon nha-án idô: “Crái ớiq! Cư hôm ŏ lư inha táh máh callong ndon Yang Arbang-pilŏ́ng khoiq patáp, dŏq inha cadyiq rit rong ticuoi khớm lư. ");
INSERT INTO pac_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Môi-se khoiq tông dyơ idô: ‘Inha cóq dyám náp a-i a-ám inha. Ticuoi mmo ma chau anôi a-i a-ám, ticuoi ngki cóq chiuq cuchet.’ ");
INSERT INTO pac_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Ma inha cato ngai têq tông ada a-i a-ám idô: ‘Máh nốh cư têq choi inha, cư khoiq dŏq ‘côr-ban’ dyơ.’ (Parnai ‘côr-ban’ titoiq lieh la ‘khoiq ưq mŏp sang dyôn Yang Arbang-pilŏ́ng.’) ");
INSERT INTO pac_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Khán inha tông iki la arớq inha catáng lớiq dyôn ngai choi a-i a-ám ngai. ");
INSERT INTO pac_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iki inha khoiq táh dyơ parnai Yang Arbang-pilŏ́ng, ma inha pitŏ́ng níc rit inha bôm. Alứng inha táq a-ưi arnáq muchứng iki tưi.” ");
INSERT INTO pac_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cua ngki Yê-su arô lieh ticuoi clứng dyôn tớq nga án, alứng án tông nha-án idô: “Nhéq máh inha cóq cammáng cư. Cóq inha chom dyôn arlớih. ");
INSERT INTO pac_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Cứp nốh culái tieh ndon mot tớq cháq ticuoi lớiq bôn táq dyôn ticuoi cơt lớiq práh veng rit. Ma ngê ndon ngốh te mít ticuoi táq dyôn ticuoi cơt lớiq práh veng rit. ");
INSERT INTO pac_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng.” ");
INSERT INTO pac_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tư Yê-su ngốh te ticuoi clứng, alứng án mot tớq dúng, dyơ top rian te án plốh án te parnai acám ngki. ");
INSERT INTO pac_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yê-su plốh lieh nha-án idô: “Imo inha iyốh apúh sa? Inha chom ma lớiq, crơng tanna te culái tieh mot tớq pallúng, lớiq nai táq dyôn ticuoi cơt lớiq práh veng rit. ");
INSERT INTO pac_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Co crơng ngki lớiq bôn mot tớq mít, ma mot tớq pallúng sớng, dyơ ngốh na pannôq.” Yê-su tông iki dŏq dyôn ticuoi chom cứp nốh tanna la práh veng rit. ");
INSERT INTO pac_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Dyơ Yê-su cato loi idô: “Ngê amớh ngốh te mít ticuoi, ngê ngki táq dyôn ticuoi cơt lớiq práh veng rit. ");
INSERT INTO pac_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Co ngê ndon ngốh te mít ticuoi la idô: Parngíh ính táq arnáq lớiq ŏ, tới campái cayieq ma bíq munơi, titôiq, cachet ticuoi, ");
INSERT INTO pac_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","láh parlưi, ham crơng, táq pla-mpla, lứp, táq tanghang, i-ôiq camíq, acraiq asáh, ính ngai ayô, alứng táq yúh yúh. ");
INSERT INTO pac_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nhéq máh arnáq saq ndô ngốh te mít ticuoi, alứng táq dyôn ticuoi cơt lớiq práh veng rit.” ");
INSERT INTO pac_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Cua Yê-su tông iki, án ngốh te ngki, alứng pôq nga cruong paniar vel Tirơ nha vel Sadôn. Án mot tớq mui dúng. Án lớiq ính ticuoi cannŏ́h chom án át tuki, ma lớiq têq catốq cháq án. ");
INSERT INTO pac_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bôn munáq cán tớq alứng mpop tumán dyưng Yê-su. Cán ndô khoiq sáng hanh te Yê-su, alứng án bôn mui náq acái cán bôn yang saq piyúh. ");
INSERT INTO pac_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Án la ticuoi Créc; án tới ticuoi Isa-ra-el. A-i án carnian án tớq cruong Sarô-phê-nasi. Án seq Yê-su chuih angốh yang saq te cháq acái án. ");
INSERT INTO pac_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Yê-su ôi án idô: “Crái lư la dyôn ngai-acái cha dyơ avai. Lớiq crái ial crơng tanna ngai-acái adúh dyôn acho cha.” ");
INSERT INTO pac_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Án ôi Yê-su: “Lư crái Ưlla tông. Ma acho têq cha ntie mbáh ngai-acái táq sráh tadưp kichơng.” ");
INSERT INTO pac_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dyơ Yê-su tông án idô: “Co mái khoiq tông iki, hoi-ndô têq mái chô. Yang saq khoiq ngốh dyơ te cháq acái mái.” ");
INSERT INTO pac_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iki án chô nga dúng. Án hôm acái án bíq tớq kichơng; alứng yang saq khoiq ngốh dyơ te cháq acái án. ");
INSERT INTO pac_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Cua ngki Yê-su ngốh te vel Tirơ, dyơ pôq tilớt vel Sadôn, alứng án pôq pha cruong Dê-ca-palớt, tớq nga dơq clóng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ngai dông nga Yê-su munáq ticuoi lúng alứng túng cutor. Ngai cucúh cucuoi seq Yê-su capơiq tớq ticuoi ngki dyôn án cơt bánh. ");
INSERT INTO pac_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yê-su dông angốh ticuoi ngki te ticuoi clứng. Dyơ án chuaiq bar pa hŏ́ng cutor ticuoi ngki. Cua ngki án cuchóh tớq ndem ati alứng tir dơq avie tớq ntaq ticuoi ngki. ");
INSERT INTO pac_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dyơ án tingưi nga pilŏ́ng. Án tangứh clŏ́ng, dyơ án tông ticuoi ngki idô: “Ep-phata.” Titoiq lieh la: “Pốh!” ");
INSERT INTO pac_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ndóng ngki táp cutor ticuoi ngki têq sáng, alứng ngcang án têq tacang. Alứng án táq-ntêr arlớih. ");
INSERT INTO pac_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yê-su dyŏq máh ticuoi át ngki êq táq-ntêr dyôn ticuoi cannŏ́h chom. Ma máh-mmo Yê-su dyŏq nha-án, máh ngki tưi nha-án táq-ntêr. ");
INSERT INTO pac_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nha-án sáng dut lư tớq mít, alứng nha-án tông idô: “Máh arnáq án táq la ŏ nhéq. Án dyôn ticuoi túng têq sáng, alứng ticuoi lúng têq tacang.” ");
INSERT INTO pac_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tớq callúng máh ingái ngki, bôn clứng ticuoi tớq sa nga Yê-su. Co nha-án ớq crơng tanna cha, iki Yê-su arô top rian te án tớq nga án, alứng án tông nha-án idô: ");
INSERT INTO pac_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cư sáng sruiq táq lư máh ticuoi ndô, co nha-án át alứng cư khoiq pe ingái dyơ, ma crơng tanna nha-án khoiq nhéq. ");
INSERT INTO pac_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Khán cư yua nha-án chô nga dúng nha-án, ma pallúng nha-án pinhaih, cumáiq nha-án dứm tớq carna, co a-ưi náq te nha-án tớq te vel yông.” ");
INSERT INTO pac_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Top rian te án plốh án idô: “Imo he ính táq dyôn bôn crơng tanna chiam nhéq máh ticuoi ndô cha dyôn asái, co ntúq ndô yông te vel ticuoi át?” ");
INSERT INTO pac_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yê-su plốh lieh nha-án: “Máh-mmo inha bôn beng?” Nha-án ôi: “Tupul lám.” ");
INSERT INTO pac_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dyơ Yê-su yua nhéq máh ticuoi ngki ticu tớq cuteq. Án ial tupul lám beng, alứng án si-ơn Yang Arbang-pilŏ́ng bôn crơng tanna ndô. Cua ngki án péq beng alứng avôi dyôn top rian te án mpô dyôn máh ticuoi ngki cha. Iki top rian te án mpô dyôn máh ticuoi ngki. ");
INSERT INTO pac_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nha-án bôn bar pe lám buaiq két hơ. Yê-su si-ơn Yang Arbang-pilŏ́ng bôn crơng tanna ndô, dyơ án yua top rian te án mpô buaiq hơ. ");
INSERT INTO pac_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tớq nhéq máh ticuoi ngki cha sái, top rian te Yê-su pachúng lieh crơng tanna clưi te nha-án cha, bôn pớnh tupul achoiq. ");
INSERT INTO pac_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bôn sám puan ngin náq ticuoi át tớq ntúq ngki. Dyơ Yê-su yua ticuoi ngki chô lieh nga dúng nha-án. ");
INSERT INTO pac_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Vít ngki án sớr tớq tuoc alứng top rian te án. Dyơ nha-án pôq nga cruong Dal-manu-tha. ");
INSERT INTO pac_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bôn máh ticuoi Pha-rasi tớq nga Yê-su; nha-án tarmien alứng án. Nha-án seq mui tíc sileh te án, ính chim án, co nha-án lớiq tin chức án tớq te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yê-su tangứh clŏ́ng, dyơ án ôi nha-án idô: “Imo ticuoi tớq pang ndô sisuo níc tíc sileh te cư? Cư tông inha arlớih lư, cư lớiq dyôn ticuoi tớq pang ndô bôn hôm tíc amớh.” ");
INSERT INTO pac_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cua án tông iki, dyơ án ngốh te nha-án, alứng án sớr lieh tớq tuoc dyang pa dyáng atóh. ");
INSERT INTO pac_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Top rian te Yê-su clớiq dông beng. Nha-án bôn nưm mui lám beng sớng tớq tuoc. ");
INSERT INTO pac_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dyơ Yê-su patáp nha-án idô: “Cóq inha át ahôi. Cóq inha át yông te bôt pôih top Pha-rasi alứng puo Hê-rôt An-tipa.” ");
INSERT INTO pac_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iki nha-án munáq táq-ntêr alứng munáq idô: “Án tông iki, co he ớq beng.” ");
INSERT INTO pac_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yê-su sáng nha-án táq-ntêr iki, dyơ án plốh nha-án idô: “Imo inha át táq-ntêr te he ớq beng? Imo inha iyốh sáng alứng iyốh chom sa? Mít inha nnáng cớng lớiq? ");
INSERT INTO pac_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imo inha bôn mát, ma lớiq bôn hôm? Inha bôn cutor, ma lớiq bôn sáng? Inha ayư ma lớiq, ");
INSERT INTO pac_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ndóng cư péq sông lám beng dyôn sông ngin náq cha, bôn sếq carie pớnh inha pachúng lieh te máh ntie ngai cha?” Nha-án ôi idô: “Bôn mui chít la bar carie.” ");
INSERT INTO pac_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yê-su plốh sa: “Alứng ndóng cư péq tupul lám beng dyôn puan ngin náq cha, bôn sếq achoiq pớnh inha pachúng lieh te máh ntie ngai cha?” Nha-án ôi: “Bôn tupul achoiq.” ");
INSERT INTO pac_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yê-su plốh sa nha-án idô: “Inha apúh ma iyốh?” ");
INSERT INTO pac_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Vít ngki nha-án tớq nga vel Bet-sada. Ngai dông nga Yê-su munáq ticuoi sot mát, alứng seq Yê-su capơiq án. ");
INSERT INTO pac_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yê-su tec ati ticuoi ngki, alứng dông angốh nga culái tieh vel. Dyơ ngki Yê-su proih dơq avie tớq mát án alứng capơiq tớq cháq án, dyơ Yê-su plốh án idô: “Mái hôm amớh?” ");
INSERT INTO pac_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ticuoi ngki tangngơq asớr alứng ôi idô: “Cư hôm ticuoi pupôq, ma cư hôm lớiq arlớih; cơt arớq tôm along pupôq pitứng pitốq sớng.” ");
INSERT INTO pac_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yê-su capơiq sa mát ticuoi sot ngki. Iki ticuoi ngki me clớn; dyơ mát án bôn hôm, alứng án hôm cứp nốh arlớih lư. ");
INSERT INTO pac_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yê-su yua án chô lớng nga dúng, alứng patáp án idô: “Êq mot tớq vel.” ");
INSERT INTO pac_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Vít ngki Yê-su alứng top rian te án pôq sa. Nha-án mot tớq máh vel ndon át paniar vel Sê-sarê Phi-lip. Ndóng nha-án pôq tớq carna, Yê-su plốh top rian te án idô: “Ticuoi cannŏ́h báq tông cư la nnáu?” ");
INSERT INTO pac_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nha-án ôi idô: “Bôn ticuoi tông thới la Yon ndon táq tíc na dơq. Bôn ticuoi tông thới la Ê-li. Alứng bôn ticuoi cannŏ́h loi tông thới la munáq tang ngcang Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yê-su plốh nha-án loi idô: “Ma inha tông cư la nnáu?” Phi-er ôi: “Thới la Crit, án ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi.” ");
INSERT INTO pac_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yê-su patáp nha-án êq dyôn ticuoi cannŏ́h chom te nốh ndô. ");
INSERT INTO pac_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cua ngki Yê-su tabớq cato top rian te án idô: “Urớh cư Acái Yang Cơt Ticuoi cóq chiuq a-ưi nốh dieiq arức. Máh ticuoi sút tớq sớu, máh ticuoi sút top teng rit sang, alứng máh thới sái rit, nha-án lớiq ính cư, alứng cachet cư. Ma vít pe ingái, cư lư tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yê-su tông parnai ndô arlớih lư dyôn nha-án cammáng. Iki Phi-er seq Yê-su ngốh te top nha-án, alứng án dyŏq Yê-su êq táq-ntêr nnáng arớq iki. ");
INSERT INTO pac_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma Yê-su tilêq me nga top rian te án, alứng án dyŏq Phi-er idô: “Yang Satán, mái êq catáng cư! Mái át pa crŏ́ng cư! Mái lớiq bôn parngíh te ngê Yang Arbang-pilŏ́ng. Ma mái parngíh nưm te ngê ticuoi sớng.” ");
INSERT INTO pac_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cua ngki Yê-su arô ticuoi clứng alứng top rian te án tớq nga án. Dyơ án cato nha-án idô: “Khán bôn ticuoi mmo ma ính veng tapun cư, cóq án táh nhéq ngê án bôm. Cóq án dual bôm along calláng án alứng veng tapun cư. ");
INSERT INTO pac_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ticuoi mmo ayáu tarngứh án, tarngứh ticuoi ngki lư pít. Ma ticuoi mmo chiuq pít tarngứh án, co tian te ngê cư alứng parnai ŏ te cư, tarngứh ticuoi ngki lư lớiq nai pít. ");
INSERT INTO pac_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Khán ticuoi mmo bôn túc palec tec pacan crơng crớu tớq pang ndô, ma án pít tarngứh, ngki án bôn tarnáp amớh? ");
INSERT INTO pac_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Alứng nốh amớh ticuoi têq pien lieh tarngứh án? ");
INSERT INTO pac_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ticuoi tớq pang ndô lớiq ính sang Yang Arbang-pilŏ́ng, alứng nha-án bôn luaih a-ưi. Khán ticuoi mmo ma achiet te cư, alứng achiet te parnai cư chứng mát ticuoi tớq pang ndô, urớh cư Acái Yang Cơt Ticuoi, lư achiet lieh ticuoi ngki, tư cư siar lieh te pilŏ́ng munơi alứng tarneng ndon práh ŏ na Yang Arbang-pilŏ́ng. Ingái ngki, cư bôn chức ang-ưr te A-ám cư.” ");
INSERT INTO pac_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yê-su cato nha-án loi idô: “Cư tông inha arlớih lư, bôn ticuoi át tayứng tớq ntúq ndô hoi-ngki, nha-án lư lớiq cuchet tingôi nha-án bôn hôm Yang Arbang-pilŏ́ng cơt sút alứng bôn chức lư.” ");
INSERT INTO pac_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vít tupát ingái, Yê-su dông Phi-er, Yacơ, alứng Yon, sớr alứng án tớq cóh ayống. Nưm nha-án puan náq táp át tớq ngki. Dyơ Yê-su palít cơt armaiq ndái loi chứng mát mu pe náq ngki. ");
INSERT INTO pac_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tampớc Yê-su clŏq tarbal mát. Lớiq bôn ticuoi mmo têq táq prới clŏq arớq ngki. ");
INSERT INTO pac_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Alứng nha-án hôm Ê-li nha Môi-se át tớq ngki tưi. Bar náq ngki táq-ntêr alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phi-er tông Yê-su idô: “Thới ơi! He át ndô la ŏ lư. He ính táq pe lám panu, mui lám dyôn thới, mui lám dyôn Môi-se, alứng mui lám loi dyôn Ê-li.” ");
INSERT INTO pac_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma Phi-er tông lớiq cơt nốh, co nha-án pe náq sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dyơ tulúc siar cadứp taryư plô nha-án, alứng bôn sieng tubau tông te tulúc idô: “Ndô la Acái Cư, án ndon cư amoih lư. Amớh án tông, cóq inha cammáng alứng peh án.” ");
INSERT INTO pac_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ndóng ngki táp mu pe náq caplang me nga tudô nga tuki, ma nha-án lớiq hôm nnáu nnáng, hôm nưm munáq Yê-su táp át alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ndóng nha-án siar te cóh, Yê-su patáp mu pe náq idô: “Nhéq nốh inha khoiq hôm tớq ntúq ndô, inha êq táq-ntêr dyôn ticuoi cannŏ́h chom tingôi tớq ingái cư Acái Yang Cơt Ticuoi cuchet alứng tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iki nha-án peh parnai Yê-su patáp. Ma nha-án munáq plốh munáq idô: “Callong amớh táp án tông te án cuchet alứng tumống lieh?” ");
INSERT INTO pac_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dyơ nha-án plốh lieh Yê-su idô: “Imo thới sái rit tông Ê-li cóq tớq nsuoi Crit?” ");
INSERT INTO pac_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yê-su ôi nha-án: “Ê-li cóq tớq nsuoi, dŏq atức cứp nốh dyôn cơt tamme lieh. Khán iki, imo parnai Yang Arbang-pilŏ́ng khoiq taran te Acái Yang Cơt Ticuoi cóq chiuq a-ưi nốh dieiq arức, alứng lớiq bôn ngai dyám náp án? ");
INSERT INTO pac_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma cư tông inha, Ê-li khoiq tớq dyơ. Ma máh arnáq lớiq ŏ ngai ính táq ada án, ngai khoiq táq dyơ; dŏq dyôn cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông te nsuoi.” ");
INSERT INTO pac_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tư Yê-su alứng pe náq ngki chô lieh nga top rian te án cannŏ́h, ma nha-án hôm clứng ticuoi tớq parchúng paniar top ngki, ma bôn thới sái rit át tarmien alứng top ngki. ");
INSERT INTO pac_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tư ticuoi clứng ngki hôm Yê-su, nha-án ticớr alứng palŏ́ng táp nga án, dyơ nha-án carbánh carsuanh án. ");
INSERT INTO pac_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yê-su plốh nha-án idô: “Inha tarmien amớh alứng top rian te cư?” ");
INSERT INTO pac_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bôn munáq te ticuoi clứng ngki ôi idô: “Thới ơi! Cư dông acái conh cư tớq nga thới, co yang saq táq án dyôn cơt lúng. ");
INSERT INTO pac_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tớq yang saq piyúh án, yang ngki atáih án tớq cuteq. Dyơ apôh ngốh te ngcang án. Án caltưat kineng tabang, alứng cháq án cơt cớng nhéq. Cư khoiq seq top rian te thới chuih viang yang saq, ma nha-án chuih lớiq rap.” ");
INSERT INTO pac_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yê-su tông ada nha-án idô: “Inha ndon át tớq pang ndô ơi, inha lớiq bôn tin tháng. Nnáng dưnh máh-mmo cư át alứng inha? Nnáng dưnh máh-mmo cư cóq chiuq inha lớiq tin? Áu! Inha dông ngai-acái conh ngki nga cư.” ");
INSERT INTO pac_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dyơ nha-án dông ngai-acái ngki nga Yê-su. Tư yang saq hôm Yê-su, án carpíl táp ngai-acái ngki. Dyơ ngai-acái ngki dứm tớq cuteq pampíl-pampaiq, pilốh piliang, alứng ngốh apôh te ngcang hơ. ");
INSERT INTO pac_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yê-su plốh a-ám ngai-acái ngki idô: “Máh-mmo dưnh dyơ án a-ái iki?” A-ám ngki ôi idô: “Te án yôl két két. ");
INSERT INTO pac_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Alứng a-ưi chư dyơ yang saq bóh án tớq uih alứng kitúh án tớq dơq, ính án cuchet. Khán thới têq choi, cư seq thới sruiq táq he hơ.” ");
INSERT INTO pac_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yê-su plốh lieh án idô: “Imo mái tông, ‘Khán thới têq choi?’ Khán ticuoi mmo lư tin, nốh amớh la têq án táq nhéq.” ");
INSERT INTO pac_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ndóng ngki táp a-ám ngki tông yứng lư idô: “Lư cư tin! Seq thới choi cư dyôn táh viang mít lớiq tin!” ");
INSERT INTO pac_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tư Yê-su hôm clứng ticuoi palŏ́ng ính me, iki án dyŏq yang saq idô: “Yang ndon táq dyôn cơt lúng alứng túng idô: ‘Cư yua mái ngốh táp te cháq án, alứng êq píh mot lieh.’” ");
INSERT INTO pac_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Vít ngki yang saq hiar yứng lư, án carvít ngai-acái pitứng pitốq; dyơ án ngốh. Ngai-acái ngki cơt arớq cuchet, alứng bôn a-ưi náq tông idô: “Án khoiq cuchet dyơ.” ");
INSERT INTO pac_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Yê-su kéu ati án alứng tec ayôr dyôn tayứng, dyơ án têq tayứng. ");
INSERT INTO pac_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Vít ngki Yê-su alứng top rian te án mot tớq dúng, dyơ nha-án plốh án idô: “Co imo he chuih yang saq ngki lớiq rap?” ");
INSERT INTO pac_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yê-su ôi nha-án idô: “Khán inha lớiq cớu seq nhéq te tarngứh tarhơ, lư inha chuih lớiq rap yang saq ndô.” ");
INSERT INTO pac_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dyơ nha-án ngốh te ntúq ngki, pôq tilớt vúng Ca-lilê. Ma Yê-su lớiq ính ticuoi cannŏ́h chom ntúq mmo án ính pôq, ");
INSERT INTO pac_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","co án ính cato nưm top rian te án sớng. Án tông nha-án idô: “Tumán dyơ ngai ính mŏp cư Acái Yang Cơt Ticuoi nga ati ticuoi sút. Ngai lư cachet cư. Ma vít pe ingái, cư tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma top rian te án lớiq apúh parnai ngki, ma nha-án lớiq dáh plốh. ");
INSERT INTO pac_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dyơ ngki nha-án tớq nga vel Cabê-na-um. Tư Yê-su át tớq dúng, án plốh nha-án idô: “Ndóng he pôq tớq carna, amớh inha tarlái?” ");
INSERT INTO pac_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma nha-án át parvưl sớng, lớiq chom amớh ính ôi, co ndóng nha-án pôq tớq carna, nha-án tarmien án mmo tớq top nha-án pưt clưi nhéq te cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yê-su ticu alứng arô mui chít la bar náq, dyơ án cato nha-án idô: “Ticuoi mmo ính cơt pưt te clưi yớu, cóq án cơt tadưp yớu, alứng táq arnáq choi nhéq máh ticuoi cannŏ́h.” ");
INSERT INTO pac_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Cua ngki Yê-su tec munáq ngai-acái alứng dyôn tayứng pandi top rian te án. Dyơ án cabêm ngai-acái alứng tông nha-án idô: ");
INSERT INTO pac_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ticuoi mmo ráp munáq ngai-acái ndô, co ticuoi ngki tin cư, lư ticuoi ngki ráp díh cư tưi. Alứng ticuoi mmo ráp cư, tới ticuoi ngki ráp nưm munáq cư sớng, ma ticuoi ngki ráp díh án ndon yua cư tớq nga tudô hơ.” ");
INSERT INTO pac_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dyơ Yon tông Yê-su idô: “Thới ơi! He khoiq hôm munáq ticuoi chuih angốh yang saq, án bôiq nốh thới. Ma he lớiq dyôn án táq nnáng arnáq iki, co án tới te top he.” ");
INSERT INTO pac_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Yê-su tông idô: “Inha êq catáng án, co lớiq bôn ticuoi mmo têq táq arnáq sileh nhơ nốh cư, dyơ muhoi án tông pamat cư. ");
INSERT INTO pac_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ticuoi mmo lớiq chíl he, án la yớu he tưi. ");
INSERT INTO pac_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cư tông inha arlớih lư, khán ticuoi mmo dyôn inha ngoiq mui choc dơq co inha bôn mui mít alứng Crit, ticuoi ngki lư bôn ráp cống te arnáq án khoiq táq.” ");
INSERT INTO pac_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Khán ticuoi mmo ma tardông munáq ngai-acái ndon khoiq tin cư, dyôn táq luaih, the ngai tacoi búl pưt tớq ticong án alứng apŏ́ng án tớq dơq sru, aláng dyôn án táq arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Khán ati inha ma tardông inha táq luaih, cóq inha cŏ́h viang ati inha. Khaq bôn ati acút ma bôn mot tớq ntúq Yang Arbang-pilŏ́ng sút, aláng bôn cứp bar pa ati ma mot tớq ntúq uih chéh níc-níc. Át ngki bôn uih lớiq nai pát. ");
INSERT INTO pac_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Alứng bôn mpang róc sáiq nha-án, mpang ngki lớiq nai cuchet, alứng uih lớiq nai pát. ");
INSERT INTO pac_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Khán dyưng inha ma tardông inha táq luaih, cóq inha cŏ́h viang dyưng inha. Khaq bôn dyưng acút ma bôn mot tớq ntúq Yang Arbang-pilŏ́ng sút, aláng bôn cứp bar pa dyưng ma Yang Arbang-pilŏ́ng ardyóng adúh inha tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Bôn mpang róc cha sáiq ticuoi ndon át tớq ntúq ngki, ma mpang ngki lớiq nai cuchet, alứng uih lớiq nai pát. ");
INSERT INTO pac_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Khán mát inha ma tardông inha táq luaih, cóq inha culáiq viang mát inha. Khaq bôn mui callong mát sớng ma bôn mot tớq ntúq Yang Arbang-pilŏ́ng sút, aláng bôn bar callong mát ma Yang Arbang-pilŏ́ng ardyóng adúh inha tớq ntúq uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bôn mpang róc sáiq ticuoi ndon át tớq ntúq ngki, ma mpang ngki lớiq nai cuchet, alứng uih lớiq nai pát. ");
INSERT INTO pac_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Urớh ticuoi cứp náq cóq tumúh dieiq arức arớq ngai cacháq boi tớq tanna, lớiq la arớq ngai bóh dyeng tớq uih, ki-náq cơt práh ŏ. ");
INSERT INTO pac_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Boi la crơng ŏ, ma khán boi cơt atieh, iki imo têq táq dyôn boi ngki cơt báq lieh? Cóq inha táq arnáq ŏ arớq boi; cóq munáq át ŏ ada munáq.” ");
INSERT INTO pac_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Vít ngki Yê-su ngốh te ntúq ngki, mot tớq vúng Yudê, alứng dyang pa dyáng atóh dơq Yôr-dan. Bôn clứng ticuoi tớq nga án; dyơ án cato nha-án muchứng án báq cato te ưlling. ");
INSERT INTO pac_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bôn máh ticuoi Pha-rasi tớq plốh Yê-su co ính chim án, nha-án plốh idô: “Veng rit he, têq táh campái lớiq?” ");
INSERT INTO pac_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yê-su plốh lieh nha-án idô: “Amớh Môi-se patáp inha?” ");
INSERT INTO pac_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nha-án ôi: “Môi-se patáp he, khán ticuoi mmo ính táh campái, án cóq taran chớiq partáh dyôn campái án, dyơ têq án táh.” ");
INSERT INTO pac_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma Yê-su tông lieh nha-án idô: “Co tian inha bôn mít cớng, co iki án taran parnai patáp ngki dyôn inha. ");
INSERT INTO pac_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma te tôm lư, ndóng Yang Arbang-pilŏ́ng teng cứp nốh, án teng ticuoi conh alứng ticuoi cán. ");
INSERT INTO pac_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Co iki ticuoi conh cóq yáh te a-i a-ám, dyơ át munơi alứng campái. ");
INSERT INTO pac_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Dyơ nha-án bar náq cơt arớq munáq sớng. Nha-án lớiq cơt nnáng bar náq, ma cơt arớq munáq sớng. ");
INSERT INTO pac_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iki, khán Yang Arbang-pilŏ́ng amúh nha-án dyôn cơt campái cayieq, ticuoi mmo la lớiq têq payáh nha-án dyôn partáh.” ");
INSERT INTO pac_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tư Yê-su alứng top rian te án chô lieh nga dúng, top rian te án plốh lieh án te arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yê-su ôi nha-án idô: “Ticuoi mmo táh campái, dyơ ial campái tamme, arnáq ngki la arớq án láh parlưi. ");
INSERT INTO pac_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Khán campái táh cayieq, dyơ ial cayieq tamme, arnáq ngki la arớq án láh parlưi tưi.” ");
INSERT INTO pac_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dyơ ngai dông máh ngai-acái tớq nga Yê-su, ính án capơiq tớq ngai-acái. Ma top rian te Yê-su dyŏq ticuoi ndon dông ngai-acái. ");
INSERT INTO pac_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tư Yê-su hôm iki, án pi-ốh alứng án tông nha-án idô: “Inha dyôn ngai-acái tớq nga cư. Êq catáng nha-án, co tớq top Yang Arbang-pilŏ́ng sút bôn nưm ticuoi ndon bôn mít cannính arớq ngai-acái. ");
INSERT INTO pac_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cư tông inha arlớih lư, ticuoi mmo ma lớiq sŏ́ng dyôn Yang Arbang-pilŏ́ng cơt sút arớq ngai-acái sŏ́ng, lư ticuoi ngki lớiq têq mot tớq top Yang Arbang-pilŏ́ng sút.” ");
INSERT INTO pac_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dyơ Yê-su cabêm máh ngai-acái, án capơiq tớq nha-án, alứng tông callong bún dyôn nha-án hơ. ");
INSERT INTO pac_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ndóng Yê-su chón pôq tớq carna, bôn munáq conh talúh tớq nga án, alứng chóh tarcol chứng mát án. Dyơ conh ngki plốh án idô: “Thới ơi! Thới la ŏ lư. Amớh cóq cư táq dyôn têq bôn tumống níc-níc?” ");
INSERT INTO pac_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yê-su plốh lieh án idô: “Imo mái dŏq cư, ŏ? Nưm Yang Arbang-pilŏ́ng táp ŏ. ");
INSERT INTO pac_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mái chom dyơ te parnai Yang Arbang-pilŏ́ng patáp: ‘Êq cachet ticuoi; êq láh parlưi; êq titôiq; êq tông parnai lớiq lư; êq lop yớu; ma cóq dyám náp a-i a-ám.’” ");
INSERT INTO pac_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Conh ngki ôi Yê-su idô: “Thới ơi! Nhéq nốh ngki cư khoiq peh te ndóng cư yôl cháh-cucháh.” ");
INSERT INTO pac_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yê-su me nga án alứng sáng amoih lư. Dyơ Yê-su tông án idô: “Mái yôl clớiq mui nốh. Cóq mái pôq táiq nhéq máh mun mái, dyơ mpô práq tarnáp ngki dyôn ticuoi kidit. Iki mái lư bôn mun ngáih tớq pilŏ́ng. Dyơ mái tớq veng tapun cư.” ");
INSERT INTO pac_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tư án sáng Yê-su tông iki, án chóh mát alứng ngốh te ngki, án sáng anguaq lư, co án la ticuoi súc. ");
INSERT INTO pac_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dyơ Yê-su carlang me paniar án, alứng án tông top rian te án idô: “Dieiq lư dyôn máh ticuoi súc têq mot tớq top Yang Arbang-pilŏ́ng sút.” ");
INSERT INTO pac_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tư Yê-su tông iki, top rian te án sáng dut lư. Ma Yê-su tông nha-án idô: “Máh acái cư ơi! Ticuoi mmo ính mot tớq top Yang Arbang-pilŏ́ng sút, dieiq lư dyôn án. ");
INSERT INTO pac_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pannán lac-da mot hŏ́ng tarúm ien hơn te ticuoi súc ính mot tớq top Yang Arbang-pilŏ́ng sút.” ");
INSERT INTO pac_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Top rian te Yê-su sáng dut lư, alứng nha-án plốh Yê-su idô: “Khán iki, nnáu têq mot tớq top Yang Arbang-pilŏ́ng sút?” ");
INSERT INTO pac_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yê-su me nga nha-án alứng tông idô: “Máh ticuoi lớiq têq táq bôm arnáq ngki, ma Yang Arbang-pilŏ́ng têq táq cứp arnáq.” ");
INSERT INTO pac_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phi-er tông Yê-su idô: “Ndô! He khoiq táh cứp nốh he bôn, co ính veng tapun thới.” ");
INSERT INTO pac_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yê-su tông nha-án idô: “Cư tông inha arlớih lư, khán bôn ticuoi mmo táh dúng su, em ai, a-i a-ám, acái, alứng táh pidái, co án veng tapun cư alứng veng tapun parnai ŏ te Yang Arbang-pilŏ́ng, ");
INSERT INTO pac_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ticuoi ngki lư bôn lieh máh nốh tớq pang ndô mui culám chư hơn te nốh án khoiq táh, arớq dúng su, em ai, a-i, acái, alứng pidái. Án cóq tumúh dieiq arức hơ. Ma urớh, án lư bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A-ưi náq cơt pưt hoi-ndô, urớh nha-án cơt két loi, alứng a-ưi náq ndon cơt két hoi-ndô, urớh nha-án cơt pưt loi.” ");
INSERT INTO pac_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yê-su alứng top rian te án pôq na carna sớr nga vel pưt Yaru-salem. Yê-su pôq nsuoi nha-án. Nha-án sáng dut lư. Ma máh ticuoi ndon veng tatun nha-án sáng adáh. Yê-su dông mui chít la bar náq ngốh te top ngki, alứng tông nha-án te máh arnáq tumán ính tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Án tông idô: “Inha cammáng! He cóq sớr nga vel Yaru-salem. Át tớq vel ngki, ngai mŏp cư Acái Yang Cơt Ticuoi nga ticuoi sút top teng rit sang Yang Arbang-pilŏ́ng, alứng nga thới sái rit. Nha-án ính anát cư cóq cuchet; alứng nha-án mŏp cư nga ticuoi tới ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Máh ticuoi ngki ayê tar-ac cư, cuchóh tớq cư, prớih cư, alứng cachet cư. Ma vít pe ingái, cư yôr tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Vít ngki Yacơ alứng Yon acái Sê-badê tớq nga Yê-su, alứng seq te án idô: “Thới ơi! He ính thới táq arớq callong he ính seq.” ");
INSERT INTO pac_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yê-su plốh nha-án: “Arnáq amớh inha ính cư táq dyôn inha?” ");
INSERT INTO pac_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nha-án ôi: “Dyôn he ticu munáq pa atớm, munáq pa aviar thới, ndóng thới cơt sút alứng bôn chức ang-ưr lư.” ");
INSERT INTO pac_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yê-su ôi nha-án idô: “Inha lớiq chom díh callong inha seq. Rap lớiq inha ngoiq mui choc alứng cư? Alứng rap lớiq inha ráp tíc na dơq munơi alứng cư?” ");
INSERT INTO pac_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nha-án ôi: “He rap.” Ma Yê-su tông lieh nha-án idô: “Urớh inha cóq ngoiq mui choc alứng cư, alứng cóq inha ráp tíc na dơq munơi alứng cư hơ. ");
INSERT INTO pac_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma cư lớiq têq dyôn inha ticu pa atớm, lớiq la pa aviar cư. Arnáq ndô nưm Yang Arbang-pilŏ́ng táp têq rêh.” ");
INSERT INTO pac_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tư mui chít náq te top rian te Yê-su tưi bôn sáng arnáq ngki, nha-án sáng uan lư ada Yacơ alứng Yon. ");
INSERT INTO pac_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dyơ Yê-su arô nhéq top ngki dyôn tớq nga án, alứng án tông idô: “Inha khoiq chom dyơ, ticuoi sút tớq pang ndô ính lư patot ticuoi prái dyôn cơt sol nha-án, alứng ính lư padớm ticuoi prái dyôn tumúh dieiq arức. ");
INSERT INTO pac_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma inha êq táq arớq iki. Ticuoi mmo ính cơt pưt tớq top inha, án cóq cơt prái tarráih inha. ");
INSERT INTO pac_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Alứng ticuoi mmo ính cơt pưt clưi nhéq te cannŏ́h tớq top inha, án cóq cơt sol máh ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Muchứng ngki tưi, cư Acái Yang Cơt Ticuoi tớq nga tudô, cư lớiq ính ngai hớu cư, ma cư ính hớu ticuoi cannŏ́h. Alứng cư mŏp tarngứh cư bôm dŏq chiuq cuchet tang nhéq tưh ticuoi.” ");
INSERT INTO pac_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Vít ngki Yê-su alứng top rian te án tớq nga vel Yê-ri-cô. Nha-án ngốh te vel ngki munơi alứng ticuoi clứng, ma ndóng ngki nha-án tumúh munáq ticuoi sot mát át ticu suseq tớq tor carna; nốh án Ba-timê, acái conh Timê. ");
INSERT INTO pac_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tư án sáng ngai táq-ntêr Yê-su te vel Na-saret pôq pha, iki án tubau yứng lư idô: “Ơ Yê-su te tŏ́ng toiq puo Davit ơi! Seq inha sruiq táq cư hơ!” ");
INSERT INTO pac_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bôn a-ưi ticuoi dyŏq án êq tacang, ma án arô yứng lư loi idô: “Ơ inha te tŏ́ng toiq puo Davit ơi! Seq inha sruiq táq cư hơ!” ");
INSERT INTO pac_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yê-su trín, alứng án yua idô: “Arô ticuoi sot ngki tớq nga cư.” Dyơ ngai arô ticuoi sot alứng tông án idô: “Mái êq adáh. Mái yôr tayứng pôq. Yê-su arô mái!” ");
INSERT INTO pac_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iki ticuoi ngki caraiq táh au thor án. Dyóiq táp án yôr tayứng alứng pôq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yê-su plốh án: “Amớh mái ính cư táq dyôn mái?” Án ôi: “Thới ơi! Seq dyôn mát cư cơt plang!” ");
INSERT INTO pac_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yê-su yua án idô: “Pôq! Co mái tin, mát mái cơt plang.” Ndóng ngki táp mát án cơt plang, dyơ án veng tapun Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tư Yê-su alứng top rian te án tumán ính tớq vel pưt Yaru-salem, nha-án mbơiq tớq vel Bê-phayê alứng vel Bê-thani nga pứh king O-li-vê. Tư nha-án tớq parngốh vel, Yê-su yua bar náq top rian te án idô: ");
INSERT INTO pac_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Inha mot tớq vel chứng mát he. Ndóng inha tớq parngốh vel, inha bôn tumúh mui lám aséh a-êp tasư, iyốh ngai diq; ngai chóq dŏq tớq lác. Inha lếh aséh alứng lúq dông nga cư. ");
INSERT INTO pac_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Khán bôn ngai plốh inha: ‘Imo inha táq iki?’ Dyôn inha ôi idô: ‘Ưlla he ính manh. Cua ngki án dông culieh lieh.’” ");
INSERT INTO pac_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iki nha-án bar náq pôq alứng tumúh acái aséh a-êp ngai chóq dŏq tumán parngốh dúng, tớq tor carna. Dyơ nha-án lếh aséh ngki. ");
INSERT INTO pac_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Máh ticuoi át tayứng tumán ngki plốh nha-án idô: “Inha lếh táq amớh aséh ndô?” ");
INSERT INTO pac_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nha-án ôi arớq Yê-su khoiq patáp; dyơ máh ticuoi ngki dyôn nha-án dông achô. ");
INSERT INTO pac_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Vít nha-án dông achô aséh nga Yê-su, nha-án lêp tampớc tớq crŏ́ng aséh. Dyơ Yê-su sớr diq tớq crŏ́ng aséh ngki. ");
INSERT INTO pac_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A-ưi náq ticuoi lêp tampớc tớq carna. Bôn ticuoi ndon mot tớq arưih tupáiq pŏ ính lêp tớq carna. ");
INSERT INTO pac_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bôn nha-án ndon pôq nsuoi, nha-án ndon pôq tatun; nha-án crau yứng lư idô: “Ô-sana! Seq Yang Arbang-pilŏ́ng dyôn callong bún nga án ndon tớq nhơ nốh Ưlla! ");
INSERT INTO pac_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Seq callong bún tớq nga puo ndon tớq te puo Davit achúc achiac he! Ô-sana! Lư ayô Yang Arbang-pilŏ́ng!” ");
INSERT INTO pac_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yê-su mot tớq vel pưt Yaru-salem, dyơ án mot tớq Dúng Sang Pưt. Án me chôp nhéq paniar ngki; ma co pilŏ́ng tumán idáu, iki án ngốh te ngki, dyơ pôq alứng top mui chít la bar náq rian te án nga vel Bê-thani. ");
INSERT INTO pac_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ang iláih parnô, ndóng nha-án ngốh te vel Bê-thani, Yê-su sáng pinhaih. ");
INSERT INTO pac_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nnáng te yông án hôm mui tôm tarúng bôn ula pu lư. Án pôq tumán alứng me, ma lớiq hôm bôn culái amớh, bôn nưm ula, co iyốh tớq ngư tarúng cơt culái. ");
INSERT INTO pac_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yê-su tông ada tôm tarúng ngki idô: “Te hoi-ndô tingôi chô-mát, lớiq bôn nnáu cha nnáng culái mái.” Top rian te Yê-su la sáng tưi án tông parnai ngki. ");
INSERT INTO pac_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vít ngki nha-án tớq nga vel Yaru-salem. Yê-su mot sa tớq Dúng Sang Pưt. Dyơ án mbơiq chuih angốh máh ticuoi ndon át tantáiq parlới tớq Dúng Sang Pưt. Án arơq kitúh kichơng ngai pien práq, alứng kichơng ngai ticu táiq achếq cacu. ");
INSERT INTO pac_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Alứng án lớiq dyôn ngai dông crơng lulieh pôq táq carna tớq Dúng Sang Pưt. ");
INSERT INTO pac_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dyơ án tông ada nha-án idô: “Inha lớiq chom te Yang Arbang-pilŏ́ng khoiq taran idô lớiq: ‘Ngai dŏq dúng cư la dúng dyôn nhéq tưh ticuoi tớq cớu seq.’ Ma inha táq dúng cư cơt arớq cưp dyôn ticuoi siveng mot catốq.” ");
INSERT INTO pac_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Máh ticuoi sút top teng rit sang alứng máh thới sái rit sáng te arnáq Yê-su táq iki, dyơ nha-án sisuo ngê ính cachet Yê-su. Ma nha-án adáh, co bôn clứng ticuoi sáng dut alứng sáng piaiq lư te máh parnai Yê-su tông. ");
INSERT INTO pac_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tớq ibư, Yê-su alứng top rian te án ngốh te vel ngki. ");
INSERT INTO pac_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ang iláih parnô, tư nha-án pôq pha tôm tarúng, nha-án hôm tôm ngki khoiq ráng te riaih díh tuo. ");
INSERT INTO pac_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phi-er ayư lieh te máh parnai Yê-su khoiq tông ada tôm ngki; dyơ án tông Yê-su idô: “Thới ơi! Me tuki! Tôm tarúng ndon thới pupap ingái inô khoiq ráng dyơ.” ");
INSERT INTO pac_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yê-su patáp sa nha-án idô: “Cóq inha tin Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cư tông inha arlớih lư, khán ticuoi mmo tông cóh ndô, idô: ‘Mái arơq bôm alứng apŏ́ng bôm tớq dơq ving-cavang,’ alứng khán ticuoi ndô lớiq bôn mít mamu, ma án tin khớm lư parnai án tông, iki arnáq ngki lư cơt dyôn án. ");
INSERT INTO pac_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iki cư tông inha, amớh inha cớu seq, cóq inha tin inha khoiq bôn dyơ callong ngki. Iki tớq urớh lư inha bôn.” ");
INSERT INTO pac_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Tớq inha tayứng cớu seq, khán bôn ticuoi mmo khoiq táq luaih ada inha, cóq inha táh luaih dyôn ticuoi ngki. Iki A-ám inha tớq pilŏ́ng táh luaih inha tưi. ");
INSERT INTO pac_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Khán inha lớiq bôn táh luaih yớu, iki A-ám inha át tớq pilŏ́ng lớiq táh luaih inha tưi.” ");
INSERT INTO pac_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Vít ngki nha-án tớq lieh nga vel Yaru-salem. Tư Yê-su ticaq tớq callúng Dúng Sang Pưt, máh ticuoi sút top teng rit sang, máh thới sái rit, alứng máh ticuoi sút tớq sớu, tớq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Alứng nha-án plốh án idô: “Te mmo thới bôn chức táq arnáq ndô? Nnáu dyôn thới bôn chức ngki?” ");
INSERT INTO pac_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yê-su ôi nha-án: “Cư ính plốh inha mui callong tưi. Khán inha ôi cư, cư lư tông inha nnáu dyôn cư bôn chức táq arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Arnáq tíc na dơq Yon táq, te mmo arnáq ngki tớq, tớq te Yang Arbang-pilŏ́ng lớiq la te ticuoi? Seq inha ôi cư.” ");
INSERT INTO pac_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nha-án munáq tanghúng munáq idô: “Khán he ôi án: ‘Arnáq tíc na dơq ndô tớq te Yang Arbang-pilŏ́ng,’ ngki án ính plốh lieh he: ‘Khán iki, imo inha lớiq tin án?’ ");
INSERT INTO pac_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma khán he ôi án: ‘Rit tíc na dơq ndô chóng tớq te ticuoi,’ ngki he adáh ticuoi clứng, co nha-án tin Yon la ticuoi tang ngcang Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iki nha-án ôi Yê-su idô: “He lớiq chom.” Yê-su ôi lieh nha-án idô: “Dyơ! Cư lớiq tông inha tưi nnáu dyôn cư bôn chức táq arnáq ndô.” ");
INSERT INTO pac_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dyơ Yê-su tabớq cato máh ticuoi sút ngki tớq parnai acám idô: Bôn munáq ticuoi conh chóh ntớng nho tớq nưong. Án táq carrong chôp paniar nưong. Án píq prúng alứng tabôt búl caviel prúng ien dếq culái nho dyôn dơq nho hoi nga prúng. Án táq panu atieng hơ dŏq kiaq nưong. Cua ngki án dyôn ticuoi táq dơ nưong án. Nha-án sŏ́ng chúng munơi máh culái tớq nưong ngki. Dyơ ngki án pôq nga cruong cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tớq ngư culái nho dom, ticuoi ưlla ndô yua sol án pôq nga ticuoi táq dơ nưong. Án yua ticuoi sol ial phê án te ticuoi táq dơ nưong. ");
INSERT INTO pac_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tư ticuoi sol tớq nga nưong, ticuoi táq dơ nưong cŏp án, tính án, alứng chuih angốh án. Nha-án dyôn án chô ati nnŏ́h sớng. ");
INSERT INTO pac_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dyơ ưlla nưong yua ticuoi sol cannŏ́h loi pôq. Ma nha-án tính plô án alứng pandyớp pandyér án. ");
INSERT INTO pac_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ưlla ngki yua ticuoi sol cannŏ́h loi pôq. Nha-án cachet sol ngki. Nha-án táq muchứng te nsuoi sa; án ndon nha-án tính, án ndon nha-án cachet. ");
INSERT INTO pac_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ưlla ndô nnáng bôn mui náq acái conh ndon án amoih lư. Tớq talloiq tháng, án yua acái án loi pôq nga nưong. Án parngíh idô: ‘Nha-án lư dyám náp acái cư.’ ");
INSERT INTO pac_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ma máh ticuoi táq dơ nưong tanghúng idô: ‘Ndô la acái tŏ́ng ưlla. He! He cachet viang án. Iki nhéq mun án cơt na he loi.’ ");
INSERT INTO pac_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dyơ nha-án cŏp alứng cachet conh ngki. Dyơ nha-án lúq angốh án te nưong nga culái tieh. ");
INSERT INTO pac_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Imo táp ưlla nưong ính táq ada nha-án? Lư án tớq cachet nhéq máh ticuoi táq dơ nưong, dyơ án mŏp dyôn ticuoi cannŏ́h loi táq dơ nưong án. ");
INSERT INTO pac_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Imo arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô: ‘Cúc búl ticuoi táq dúng khoiq adúh, búl ngki cơt búl lác tớq tol dúng. ");
INSERT INTO pac_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Arnáq ndô Ưlla he táp khoiq táq, la arnáq sileh lư chứng mát he.’” ");
INSERT INTO pac_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Máh ticuoi sút te arnáq sang ndon sáng Yê-su tông iki, nha-án suo ngê ính cŏp án, co nha-án chom án táq-ntêr parnai acám ndô te nha-án. Ma nha-án adáh ticuoi clứng. Iki nha-án ngốh te án, dyơ pôq nga ntúq cannŏ́h loi. ");
INSERT INTO pac_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Vít ngki ngai yua ticuoi te top Pha-rasi alứng ticuoi veng ngê Hê-rôt tớq nga Yê-su, dyôn nha-án sisuo callong thét te Yê-su táq-ntêr. ");
INSERT INTO pac_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Top nha-án tớq nga Yê-su alứng tông án idô: “Thới ơi! He chom dyơ thới la ticuoi tinớng. Chứng mát thới, nhéq tưh ticuoi li-arli nhéq. Co iki thới lớiq bôn dyám náp ticuoi bôn chức. Thới tông ngê Yang Arbang-pilŏ́ng crái lư. Veng phep rit he, crái lớiq he cóq dyôn práq thêq nga puo Rô-ma?” ");
INSERT INTO pac_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma Yê-su chom nha-án sisuo ngê. Iki án plốh lieh nha-án idô: “Imo inha suo callong luaih te cư? Inha dông mui callong práq dyôn cư me.” ");
INSERT INTO pac_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iki nha-án dông mui callong práq nga án. Dyơ án plốh nha-án idô: “Rớp alứng tarran ndô arớq nnáu?” Nha-án ôi: “Puo Rô-ma.” ");
INSERT INTO pac_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iki Yê-su tông nha-án: “Crơng puo Rô-ma, cóq culieh lieh dyôn puo Rô-ma; crơng Yang Arbang-pilŏ́ng, cóq culieh lieh dyôn Yang Arbang-pilŏ́ng.” Nha-án sáng dut lư te parnai Yê-su tông. ");
INSERT INTO pac_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bôn ticuoi te top Sa-dusê tớq nga Yê-su. Nha-án tông ticuoi khoiq cuchet lớiq têq tumống lieh. ");
INSERT INTO pac_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nha-án plốh Yê-su idô: “Thới ơi! Môi-se khoiq taran dyôn he chom, khán ai cuchet, ma campái án yôl tumống, alứng nha-án iyốh bôn acái, iki munáq te em ai án cóq atŏ́ng cán ngki táq campái, dŏq bôn acái cơt acái tŏ́ng ai. ");
INSERT INTO pac_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Acám bôn tupul náq em ai. Ai pông ial campái, dyơ án cuchet ma iyốh bôn acái. ");
INSERT INTO pac_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Iki a-em tandi án atŏ́ng campái ai. Ma án cuchet iyốh bôn acái tưi. Iki a-em carlớh la táq muchứng top ai tưi. ");
INSERT INTO pac_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nha-án tupul náq atŏ́ng cán ngki táq campái. Ma nhéq náq nha-án cuchet nsuoi iyốh bôn acái; ma tatun tháng, cán ngki cuchet tưi. ");
INSERT INTO pac_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tư máh ticuoi cuchet bôn tumống lieh, cán ngki cơt campái nnáu? Co tupul náq em ai ưlla nhéq cán ngki.” ");
INSERT INTO pac_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yê-su tông lieh nha-án idô: “Inha táq-ntêr lớiq crái, co inha lớiq chom arlớih te tám uráq Yang Arbang-pilŏ́ng ndon ngai khoiq taran te inớh; alứng inha lớiq chom díh chức pưt na Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tư nha-án ndon khoiq cuchet bôn tumống lieh, nha-án lớiq bôn cơt nnáng campái cayieq. Ma nha-án át tớq pilŏ́ng muchứng top tarneng Yang Arbang-pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te arnáq ticuoi cuchet tumống lieh, imo arớq inha lớiq nai dŏc tớq tám uráq Môi-se khoiq taran te arbu bôn uih chéh ma lớiq ngcat. Tớq ntúq ngki Yang Arbang-pilŏ́ng táq-ntêr alứng Môi-se idô: ‘Cư la Yang Arbang-pilŏ́ng ndon A-praham sang, I-sac sang, alứng Yacốp sang.’ ");
INSERT INTO pac_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“He chom ticuoi cuchet lớiq têq sang nnáng Yang Arbang-pilŏ́ng. Nưm ticuoi tumống sớng têq sang án. Lư inha lớiq chom amớh tháng.” ");
INSERT INTO pac_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bôn munáq te top thới sái rit tớq nga tuki, alứng án sáng nha-án tarlái iki. Án sáng Yê-su ôi ŏ lư, iki án plốh Yê-su idô: “Te máh callong Yang Arbang-pilŏ́ng patáp, callong mmo pưt clưi nhéq te cannŏ́h?” ");
INSERT INTO pac_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yê-su ôi án: “Callong pưt clưi nhéq te cannŏ́h ndon Yang Arbang-pilŏ́ng patáp la idô: ‘Top Isa-ra-el ơi! Cóq inha cammáng: Yang Arbang-pilŏ́ng, Ưlla he, la munáq án sớng cơt Ưlla! ");
INSERT INTO pac_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cóq inha amoih Yang Arbang-pilŏ́ng, Ưlla inha, nhéq te mít cannính, nhéq te tarngứh tarhơ, nhéq te parngíh, alứng nhéq te rêng inha.’ ");
INSERT INTO pac_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Alứng callong patáp bar ndon pưt clưi nhéq te cannŏ́h la idô: ‘Cóq inha amoih yớu muchứng inha amoih cháq inha bôm.’ Callong patáp cannŏ́h lớiq bôn pưt clưi te bar callong patáp ndô.” ");
INSERT INTO pac_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Án ndon te top thới sái rit ôi lieh Yê-su idô: “Thới ơi! Thới tông tinớng lư. Lư crái, nưm munáq Yang Arbang-pilŏ́ng táp la Ưlla. Vít te Yang Arbang-pilŏ́ng, lớiq bôn yang cannŏ́h nnáng sút. ");
INSERT INTO pac_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Khán he amoih Yang Arbang-pilŏ́ng nhéq te mít cannính, nhéq te tarngứh tarhơ, nhéq te parngíh alứng nhéq te bánh rêng, alứng khán he amoih yớu muchứng he amoih cháq bôm, arnáq ndô lư ŏ hơn te bóh sang máh pannán, lớiq la mŏp sang máh crơng dyôn Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yê-su sáng án ôi tubáiq lư, dyơ Yê-su tông lieh án idô: “Tumán lư dyơ mái bôn mot tớq top Yang Arbang-pilŏ́ng sút.” Vít ngki lớiq bôn nnáu nnáng dáh plốh Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ndóng Yê-su cato tớq Dúng Sang Pưt, án plốh idô: “Imo thới sái rit tông: Crit tớq te tŏ́ng toiq Davit? ");
INSERT INTO pac_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma to Davit táp tông nhơ te Arvai Yang Arbang-pilŏ́ng yua án tông idô: ‘Yang Arbang-pilŏ́ng tông Ưlla cư idô: “Mái ticu pa atớm cư tingôi ingái mmo cư mŏp ticuoi picon mái, át tadưp allang dyưng mái.’” ");
INSERT INTO pac_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","To Davit táp dŏq Crit la ‘Ưlla’. Iki imo têq Davit dŏq ticuoi te tŏ́ng toiq án bôm la Ưlla?” Ticuoi clứng ngki sáng bui lư te Yê-su tông iki. ");
INSERT INTO pac_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ndóng Yê-su cato, án tông idô: “Inha êq táq arớq thới sái rit. Nha-án ính lư sứp au thor amaiq lư, alứng ính ticuoi cannŏ́h pasôl ŏ ndóng nha-án át alứng ticuoi clứng. ");
INSERT INTO pac_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ndóng nha-án át tớq dúng rum, nha-án ính bôn kichơng ticu ŏ clưi nhéq te cannŏ́h, alứng tớq ngai mơi nha-án tớq cha, nha-án ính lư ticu pa tanieng. ");
INSERT INTO pac_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nha-án lop máh dúng cán cammai; nha-án cớu seq toiq lư ính ngai ayô nha-án la ticuoi tinớng ŏ. Ma urớh, tôt nha-án ntáng hơn te ticuoi cannŏ́h.” ");
INSERT INTO pac_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Vít ngki Yê-su ticu tumán ntúq ngai cacháq práq sang. Án me nga ticuoi clứng cacháq práq sang. Máh ticuoi súc cacháq práq a-ưi lư. ");
INSERT INTO pac_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ma bôn munáq cán cammai kidit lư tớq ntúq ngki. Án cacháq bar nhac práq kem ndon tarnáp biq lư. ");
INSERT INTO pac_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dyơ Yê-su arô top rian te án tớq nga án, alứng án tông idô: “Cư tông inha arlớih lư, cán cammai kidit ndô cacháq práq sang a-ưi hơn te máh ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Co ticuoi cannŏ́h cacháq práq sang clưi te nha-án tớc cha; ma cán cammai ndô, ớq lư; máh-mmo án bôn, án cacháq nhéq máh ngki.” ");
INSERT INTO pac_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tư Yê-su ngốh te Dúng Sang Pưt, bôn munáq te top rian te án tông idô: “Thới ơi! Me tuki! Búl alứng Dúng Sang Pưt ngki ŏ lư!” ");
INSERT INTO pac_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Yê-su plốh lieh án: “Mái hôm dúng pưt ndô lớiq? Urớh búl ngai táq dúng ndô lớiq tarbôt nnáng munơi. Án partáh nhéq.” ");
INSERT INTO pac_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Vít ngki Yê-su ticu tớq king O-li-vê chứng mát Dúng Sang Pưt. Phi-er, Yacơ, Yon, alứng Anrê, nưm nha-án puan náq táp át alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nha-án plốh Yê-su idô: “Seq thới tông he, nnáng dưnh máh-mmo arnáq ndô tớq? Bôn tíc amớh apáh nsuoi te arnáq ndô ính tớq?” ");
INSERT INTO pac_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yê-su tông nha-án idô: “Cóq inha át ahôi. Êq dyôn ngai pilốh inha. ");
INSERT INTO pac_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Urớh bôn a-ưi náq cliau nốh cư. Nha-án tông: ‘Cư táp la Crit!’ Alứng nha-án pilốh clứng ticuoi. ");
INSERT INTO pac_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Tư inha sáng parhanh ngai tarchíl tumán-mán yông-yông, inha êq adáh amớh. Arnáq ndô cóq tớq nsuoi avai. Ma iyốh tớq ingái talloiq tháng. ");
INSERT INTO pac_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lư bôn top ndô tarchíl tartáq alứng top ngki; cruong ndô tarchíl tartáq alứng cruong ngki. Bôn a-ưi ntúq cuteq cacưt alứng ớq tanna cha. Máh arnáq ndô tớq la te tôm sớng. Ma nnáng bôn a-ưi nốh dieiq arức loi tớq. ");
INSERT INTO pac_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Co iki, cóq inha me a-ŏ. Lư ngai cŏp alứng dông inha tớq nga ticuoi sút. Ngai tính inha tớq dúng rum top Isa-ra-el. Inha cóq tayứng chứng mát ticuoi sút alứng ticuoi puo co tian inha veng tapun cư, dŏq inha tông dyôn nha-án chom tưi te ngê cư. ");
INSERT INTO pac_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Top veng tapun cư cóq cato parnai ŏ te Yang Arbang-pilŏ́ng dyôn nhéq tưh ticuoi chom nsuoi avai. ");
INSERT INTO pac_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tư ngai cŏp alứng dông sưq inha, ma inha êq adáh. Inha êq rớu-ri nsuoi amớh inha ính tông. Ma inha tông veng parnai Yang Arbang-pilŏ́ng dyôn inha tông. Co parnai ngki tới parnai inha, ma parnai Arvai Yang Arbang-pilŏ́ng tông. ");
INSERT INTO pac_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tớq pang ngki, em ai ính culieu tartuoq em ai, alứng mŏp dyôn ngai cachet; a-ám ính culieu acái. Acái ính tarchíl a-i a-ám, alứng mŏp dyôn ngai cachet. ");
INSERT INTO pac_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nhéq tưh ticuoi a-ính inha la co tian inha veng tapun cư. Ma ticuoi mmo rap chiuq tingôi cloiq pang án, Yang Arbang-pilŏ́ng lư choi tamống án. ");
INSERT INTO pac_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Urớh inha bôn hôm ngai dŏq tớq Dúng Sang Pưt crơng prớq alứng arnáq luaih ndon Yang Arbang-pilŏ́ng lớiq ính hôm. (Ticuoi mmo dŏc parnai ndô, cóq án parngíh dyôn arlớih lư te parnai ndô.) Ingái ngki ticuoi tớq vúng Yudê, cóq lúh sớr át nga cóh. ");
INSERT INTO pac_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Án ndon át tớq mpuong dúng, êq siar alứng mot ial nnáng crơng te dúng. ");
INSERT INTO pac_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Án ndon át tớq pidái, êq chô ial nnáng tampớc te dúng. ");
INSERT INTO pac_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tớq ingái ngki, toiq bap lư dyôn ticuoi ndon át cháq-iki alứng ticuoi ndon a-uq acái. ");
INSERT INTO pac_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cóq inha cớu seq te Yang Arbang-pilŏ́ng êq dyôn máh arnáq ndô tớq ndóng kisái ngngiat. ");
INSERT INTO pac_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Co tớq máh ingái ngki, bôn dieiq arức clưi nhéq te ingái Yang Arbang-pilŏ́ng teng pilŏ́ng cuteq tingôi hoi-ndô. Dyơ tatun lớiq bôn dieiq arức nnáng arớq ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Khán Yang Arbang-pilŏ́ng lớiq aroiq lieh máh ingái ngki, lư lớiq bôn ngai têq tumống nnáng. Ma co án ính choi máh ticuoi ndon án khoiq rêh, iki án aroiq lieh máh ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Khán ngai tông inha idô: ‘Me! Án ndô la Crit!’, lớiq la ‘Me! Án tíh la Crit!’, inha êq tin parnai ngki. ");
INSERT INTO pac_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Co urớh bôn ticuoi tới lư Crit, alứng tới ticuoi tang ngcang Yang Arbang-pilŏ́ng. Nha-án táq tíc laq dŏq pilốh inha. Khán têq, nha-án ính pilốh díh ticuoi ndon Yang Arbang-pilŏ́ng khoiq rêh hơ dyôn táq arnáq saq arớq nha-án tưi. ");
INSERT INTO pac_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Iki cóq inha me a-ŏ. Nhéq nốh ndô, cư tông dyôn inha chom nsuoi te arnáq ngki iyốh tớq. ");
INSERT INTO pac_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tớq vít máh ingái dieiq arức lư, mát pandang lớiq claq nnáng, alứng kisái lớiq clưng nnáng. ");
INSERT INTO pac_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Pantôr atôh te pilŏ́ng, alứng máh nốh ndon bôn chức tớq pilŏ́ng la Yang Arbang-pilŏ́ng táq dyôn arsáu nhéq. ");
INSERT INTO pac_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Cua ngki, ngai bôn hôm cư Acái Yang Cơt Ticuoi siar te pandi tulúc bôn chức pưt lư, alứng armaiq ang-ưr. ");
INSERT INTO pac_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ndóng ngki cư yua tarneng Yang Arbang-pilŏ́ng pachúng cứp náq ticuoi ndon cư khoiq rêh te máh pứp pilŏ́ng crôp, alứng te máh pứp cúc cuteq ndô.” ");
INSERT INTO pac_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yê-su tông loi idô: “Cóq inha cammáng parnai cư acám te tôm tarúng. Ndóng abeng along ngki nnáng nhom, án mbơiq ráh-aruat ula. Iki inha chom khoiq tumán ính tớq kisái puoq. ");
INSERT INTO pac_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Muchứng ngki tưi, khán inha hôm máh nốh ngki tớq, iki inha chom cư Acái Yang Cơt Ticuoi tumán ính tớq dyơ alứng khoiq tamŏ́c ngáh callống. ");
INSERT INTO pac_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cư tông inha arlớih lư, nhéq tưh ticuoi tớq pang ndô lớiq bôn cuchet pít nsuoi te máh arnáq ndô tớq. ");
INSERT INTO pac_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Urớh pilŏ́ng alứng cuteq cơt pít, ma parnai cư cato lớiq nai pít. ");
INSERT INTO pac_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lớiq bôn ngai chom ingái mmo lớiq la ndóng mmo arnáq ngki tớq. Máh tarneng tớq pilŏ́ng, díh Acái Yang Arbang-pilŏ́ng la lớiq chom tưi ingái ngki. Nưm munáq A-ám cư táp chom ingái ngki. ");
INSERT INTO pac_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Iki cóq inha me a-ŏ alứng cayôn níc, co inha lớiq chom ndóng mmo arnáq ndô tớq. ");
INSERT INTO pac_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Arnáq ndô la arớq munáq ticuoi pôq tumoi nga cruong yông. Tư án ngốh te dúng, án anát arnáq dyôn máh prái tarráih án, alứng án patáp ticuoi kiaq callống, cóq át cayôn níc. ");
INSERT INTO pac_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iki cóq inha cayôn níc, co inha lớiq chom ndóng mmo ưlla dúng chô. Piaiq lơ án chô idáu, lớiq la tardi dáu. Piaiq lơ án chô tớq ntruoi ticár, lớiq la cháh claq la bôn. ");
INSERT INTO pac_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cóq inha mmứng níc. Dáh lơ tarplơl án chô, dyơ án tumúh inha bíq. ");
INSERT INTO pac_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Máh parnai cư tông inha hoi-ngki, cư lư tông dyôn nhéq tưh ticuoi chom tưi, la idô: Cóq inha cayôn níc!” ");
INSERT INTO pac_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yôl bar ingái loi ticuoi tớq cruong Isa-ra-el ính cha ayư Ingái Ngốh. Dyơ nha-án Táq Cha Beng Mi ớq bôt pôih. Iki ticuoi sút top teng rit sang alứng thới sái rit suo ngê ính cŏp Yê-su, alứng ính cachet án, ma nha-án lớiq ính ticuoi cannŏ́h chom. ");
INSERT INTO pac_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nha-án tanghúng idô: “He lớiq têq táq iki tớq ingái cha bui. Adáh ticuoi clứng ngki tarchơiq.” ");
INSERT INTO pac_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ndóng Yê-su át tớq vel Bê-thani, án át tớq dúng Si-môn, la ticuoi hoi-ntre bôn a-ái bŏ́q. Ndóng Yê-su chicha, bôn munáq cán tớq nga Yê-su; án dông mui be dơq thum. Be ngki ngai táq tớq búl nốh ‘a-labat’. Dơq thum tớq be ngki dát lư; nốh ‘nar’. Ndóng án peng be alứng tốq dơq thum tớq plô Yê-su, ");
INSERT INTO pac_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","bôn ticuoi át ngki sáng lớiq êm án táq iki, dyơ nha-án tông idô: “Imo án pirê dơq thum ndô? ");
INSERT INTO pac_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Khán táiq dơq thum ndô, bôn práq clưi te cống ngai thuthe pe culám ingái. Crái lư la án táiq dơq thum ndô, dyơ ial práq choi máh ticuoi kidit.” Iki nha-án pi-ốh cán ngki. ");
INSERT INTO pac_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Yê-su tông nha-án idô: “Tam án. Imo inha táq dyôn án sáng anguaq? Án khoiq táq arnáq ŏ dyôn cư. ");
INSERT INTO pac_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ticuoi kidit át níc alứng inha. Hoi mmo inha ính choi la têq inha choi. Ma cháq cư lớiq át níc alứng inha. ");
INSERT INTO pac_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Arnáq amớh cán ndô táq hoi-ndô la dyôn án táq. Án khoiq tốq dơq thum tớq cháq cư, dŏq thuan nsuoi te ngai dông tứp cư. ");
INSERT INTO pac_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cư tông inha arlớih lư, cứp ntúq tớq cúc cuteq ndô, tớq ngai cato parnai ŏ te Yang Arbang-pilŏ́ng, lư ngai tông díh te arnáq cán ndô khoiq táq hơ, dŏq ticuoi cannŏ́h ayư án tưi.” ");
INSERT INTO pac_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ma Yuda I-cari-ôt la munáq te top mui chít la bar náq, án tớq nga máh ticuoi sút top teng rit sang, co án ính culieu Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tư nha-án sáng iki, nha-án sáng êm lư, dyơ nha-án ưq chang práq a Yuda. Iki Yuda sisuo ngê ính culieu Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tớq ingái ticuoi Isa-ra-el Cha Beng Mi Ớq Bôt Pôih alứng kiac pannán cưu dŏq cha ayư Ingái Ngốh, ingái ngki top rian te Yê-su plốh án idô: “Ntúq mmo thới ính he pôq thuan dyôn thới cha pêl bui ndô?” ");
INSERT INTO pac_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yê-su yua bar náq top rian te án idô: “Inha mot tớq vel ngki. Dyơ inha lư tumúh munáq conh tikel yáng dơq. Inha veng tapun lamloi án. ");
INSERT INTO pac_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Khán án mot dúng mmo, inha mot dúng ngki tưi, alứng tông ưlla dúng ngki idô: ‘Thới plốh idô: “Tumo mong ráp tumoi, co cư alứng top rian te cư ính cha pêl bui dŏq ayư Ingái Ngốh?’” ");
INSERT INTO pac_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Án ính turô mong tớq trơn tanieng dyôn inha. Tớq mong ngki bôn cứp nốh tarnứng. Dyơ inha thuan tanna dyôn he cha tớq ntúq ngki.” ");
INSERT INTO pac_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nha-án bar náq ngốh te ngki, dyơ mot tớq vel. Nha-án tumúh arớq Yê-su khoiq tông te nsuoi. Dyơ nha-án thuan tanna dŏq cha pêl bui. ");
INSERT INTO pac_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tớq sưm-turưm ibư, Yê-su alứng top mui chít la bar náq tớq nga tuki. ");
INSERT INTO pac_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ndóng nha-án ticu cha, Yê-su tông idô: “Cư tông inha arlớih lư, bôn munáq te top inha ndon cha munơi alứng cư hoi-ndô, urớh án culieu cư.” ");
INSERT INTO pac_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Top mui chít la bar náq sáng anguaq lư, dyơ muchư munáq plốh Yê-su idô: “Cư láng lớiq, thới?” ");
INSERT INTO pac_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yê-su ôi nha-án idô: “Ticuoi ndô la munáq te top mui chít la bar náq; án túq beng mui tingan alứng cư. ");
INSERT INTO pac_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cư Acái Yang Cơt Ticuoi cóq cuchet arớq tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông dyơ. Ma án ndon culieu Acái Yang Cơt Ticuoi, bap lư tớq nga án. Piaiq lư la a-i án êq carnian án.” ");
INSERT INTO pac_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ndóng nha-án cha, Yê-su ial beng. Án si-ơn Yang Arbang-pilŏ́ng, dyơ án péq beng alứng avôi nga top rian te án, alứng án tông idô: “Inha ráp. Ndô la cháq cư.” ");
INSERT INTO pac_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vít ngki án ial choc dơq nho. Dyơ án si-ơn Yang Arbang-pilŏ́ng alứng avôi nga top rian te án. Dyơ nhéq náq nha-án ngoiq. ");
INSERT INTO pac_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Alứng Yê-su tông nha-án idô: “Ndô la aham cư. Aham ndô ngốh táq tíc Yang Arbang-pilŏ́ng khoiq par-ưq ada nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cư tông inha arlớih lư, cư lớiq ngoiq nnáng dơq nho tingôi ingái cư ngoiq lieh dơq nho tamme tớq ntúq Yang Arbang-pilŏ́ng sút.” ");
INSERT INTO pac_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cua nha-án cứh ayô, nha-án ngốh te ngki, alứng sớr tớq king O-li-vê. ");
INSERT INTO pac_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yê-su tông nha-án idô: “Cumáiq nhéq náq inha lúh táh nhéq cư. Co tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô: ‘Cư dyôn ngai cachet viang ticuoi kiaq me cưu, dyơ top cưu lúh pláh chap nhéq.’ ");
INSERT INTO pac_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma tớq cư tumống lieh, cư pôq nsuoi inha nga vúng Ca-lilê.” ");
INSERT INTO pac_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phi-er ôi Yê-su idô: “Khán nhéq máh ticuoi táh thới, cư lư lớiq táh thới.” ");
INSERT INTO pac_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yê-su ôi lieh Phi-er idô: “Cư tông mái arlớih lư, idáu ndô táp, ntruoi iyốh ticár chư bar, mái lư calôih cư pe chư.” ");
INSERT INTO pac_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Phi-er ôi cáng lư idô: “Khán ngai cachet cư munơi alứng thới, la dyơ. Cư lư lớiq calôih thới mmớh!” Dyơ nhéq náq top ngki tông muchứng Phi-er tưi. ");
INSERT INTO pac_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tư nha-án tớq nga ntúq nưong, nốh Kêt-se-manê, Yê-su tông top rian te án idô: “Inha át ndô nư. Cư ính pôq cớu nga tuki.” ");
INSERT INTO pac_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Án dông Phi-er, Yacơ, Yon pôq alứng án. Dyơ án mbơiq sáng dieiq arức alứng anguaq lư tớq mít parngíh án. ");
INSERT INTO pac_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Án tông idô: “Cư sáng anguaq lư, lớiq rap tumống nnáng. Inha át pớn tớq ndô. Inha cayôn alứng cư.” ");
INSERT INTO pac_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dyơ Yê-su pôq yông biq loi. Án mpop tớq cuteq, alứng cớu seq, khán têq, êq dyôn arnáq ndô tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Án cớu idô: “A-ám cư ơi! Amớh mái ính táq, têq nhéq mái táq. Cư seq mái atức viang choc dieiq arức ndô dyôn vít te cư. Ma cư lớiq ính veng cannính cư bôm, ma cư ính veng nưm cannính mái sớng.” ");
INSERT INTO pac_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Cua ngki Yê-su píh lieh nga pe náq ngki, án tumúh nha-án bíq. Dyơ án plốh Phi-er idô: “Si-môn ơi! Mái bíq áh? Imo mái lớiq rap máih muhoi sớng alứng cư? ");
INSERT INTO pac_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cóq inha cayôn alứng cớu, dŏq inha têq viar vít te táq luaih. Mít inha lư rêng, ma cháq inha ngki ieuq.” ");
INSERT INTO pac_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iki Yê-su pôq cớu sa. Án cớu seq muchứng te nsuoi. ");
INSERT INTO pac_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dyơ án píh lieh nga ntúq nha-án át, án tumúh nha-án bíq sa, co mát nha-án ntáng lư, lớiq rap caplang. Iki nha-án lớiq chom imo ính ôi án. ");
INSERT INTO pac_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tư Yê-su píh lieh nga ntúq nha-án át chư pe, dyơ án plốh nha-án idô: “Imo inha yôl bíq alứng angô níc? Inha êq bíq nnáng. Khoiq tớq dyơ án ndon culieu cư Acái Yang Cơt Ticuoi nga ati ticuoi luaih. ");
INSERT INTO pac_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yôr tayứng! He pôq! Inha me! Án ndon culieu cư khoiq tớq dyơ.” ");
INSERT INTO pac_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ndóng Yê-su yôl tông iki, Yuda tớq táp. Án la te top mui chít la bar náq rian te Yê-su. Bôn clứng ticuoi tớq alứng án, nha-án dông dau alứng tarcál. Nha-án tớq co máh ticuoi sút top teng rit sang, thới sái rit, alứng ticuoi sút tớq sớu, yua. ");
INSERT INTO pac_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda ndon culieu Yê-su khoiq tông tíc dyôn máh ticuoi ngki chom idô: “Án mmo inha hôm cư honh, án ngki ớiq inha ính bôn. Dyơ inha cŏp án, alứng inha caring án dông te ntúq ngki.” ");
INSERT INTO pac_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dyơ Yuda tớq táp nga Yê-su alứng tông idô: “Thới ơi!” Dyơ án honh Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iki nha-án kéu alứng cŏp Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Munáq te nha-án ndon tayứng tumán ngki thot dau te sor, dyơ tráh munáq sol ariaih top teng rit sang, crái cutor alứng ti-ŏ́h mui pa cutor. ");
INSERT INTO pac_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma Yê-su plốh nha-án idô: “Imo inha tớq nga tudô dông dau alứng tarcál ính cŏp cư? Inha parngíh cư la ticuoi siveng? ");
INSERT INTO pac_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cứp ingái cư cato tớq Dúng Sang Pưt, ma inha lớiq bôn cŏp cư. Ma arnáq ndô la dyôn cơt tarvớiq simớt máh tám uráq Yang Arbang-pilŏ́ng khoiq tông te inớh.” ");
INSERT INTO pac_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dyơ máh nha-án ndon át alứng Yê-su lúh táh nhéq án. ");
INSERT INTO pac_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bôn munáq ticuoi conh bánh ndon veng tapun Yê-su. Án apeng nưm prới sớng tớq cháq án. Ngai yúng prới án, co ính cŏp án. ");
INSERT INTO pac_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Dyơ án luaiq táh prới, alứng án lúh mu-rarat. ");
INSERT INTO pac_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tư ngki, nha-án dông Yê-su nga ariaih top teng rit sang. Máh ticuoi sút top teng rit sang, ticuoi sút tớq sớu, alứng thới sái rit tớq parchúng tuki tưi. ");
INSERT INTO pac_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phi-er veng yông-yông tatun Yê-su, dyơ án mot tớq ngcưm dúng ariaih ngki. Án ticu heng uih munơi alứng máh ticuoi kiaq dúng ariaih. ");
INSERT INTO pac_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Máh ticuoi sút top teng rit sang, alứng ticuoi bôn chức cannŏ́h suo callong luaih ính cachet Yê-su. Ma nha-án lớiq tumúh callong luaih amớh. ");
INSERT INTO pac_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bôn a-ưi ticuoi tớq ton apít Yê-su, ma parnai nha-án apít lớiq muchứng. ");
INSERT INTO pac_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bôn ticuoi yôr tayứng ton apít Yê-su idô: ");
INSERT INTO pac_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“He khoiq sáng án tông idô: ‘Cư ính lóh dúng sang ndon ati ticuoi táq. Ma tớq pe ingái sớng cư táq tamme lieh dúng ndô, ma tới ati ticuoi táq.’” ");
INSERT INTO pac_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma parnai nha-án ton apít lớiq muchứng. ");
INSERT INTO pac_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dyơ ariaih top teng rit sang yôr tayứng pandi nha-án. Án plốh Yê-su idô: “Imo mái lớiq ôi? Mái sáng lớiq, máh parnai nha-án cauq mái?” ");
INSERT INTO pac_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Yê-su át tưl-vưl sớng. Án lớiq tacang amớh. Ariaih ngki plốh sa Yê-su: “Mái lư Crit, Acái Yang Arbang-pilŏ́ng ndon he sang tám lớiq?” ");
INSERT INTO pac_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yê-su ôi: “Lư piaiq! Urớh inha bôn hôm Acái Yang Cơt Ticuoi ticu pa atớm Yang Arbang-pilŏ́ng ndon bôn chức pưt lư, alứng án tớq pandi tulúc te pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dyơ ticuoi ariaih ngki haq tampớc án bôm, alứng án tông idô: “Chớm plốh nnáng ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Inha khoiq sáng dyơ parnai án tông la arớq án acraiq Yang Arbang-pilŏ́ng. Amớh inha parngíh te arnáq ndô?” Nhéq náq nha-án sŏ́ng mui mít, alứng anát Yê-su cóq cuchet. ");
INSERT INTO pac_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bôn ticuoi cuchóh tớq Yê-su. Nha-án tian mát Yê-su, dyơ dớm án alứng plốh idô: “Nnáu dớm mái?” Alứng máh ticuoi kiaq án, páh án hơ. ");
INSERT INTO pac_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ndóng ngki Phi-er yôl át tớq ngcưm. Bôn munáq cán prái tarráih ariaih top teng rit sang tớq nga ngki. ");
INSERT INTO pac_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tư án hôm Phi-er át heng uih, án me clŏ́h Phi-er alứng án tông ada Phi-er idô: “Mái la ticuoi át alứng Yê-su, te vel Na-saret.” ");
INSERT INTO pac_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma Phi-er calôih idô: “Tới! Cư lớiq chom amớh mái tông! Cư lớiq apúh mái tông!” Dyơ Phi-er ngốh te ntúq ngki. Ma ndóng ngki táp ntruoi ticár. ");
INSERT INTO pac_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mui chư loi, cán ngki hôm sa Phi-er, dyơ án tông ticuoi ndon át tayứng ntúq ngki idô: “Ticuoi ndô la te top ngki tưi.” ");
INSERT INTO pac_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma Phi-er calôih sa. Muhoi loi, máh ticuoi tayứng ngki tông ada Phi-er idô: “Mái la lư te top ngki tưi, co mái la ticuoi Ca-lilê.” ");
INSERT INTO pac_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Phi-er cantŏ́h callih clŏq plô clŏq sóc ada nha-án. Án ôi suon níc idô: “Inha tông cư te top án ngki, ma cư lớiq acớl díh rớp án.” ");
INSERT INTO pac_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ndóng ngki táp ntruoi ticár chư bar. Dyơ Phi-er ayư lieh te parnai Yê-su khoiq tông án idô: “Ntruoi iyốh ticár chư bar, mái khoiq calôih cư pe chư.” Tư Phi-er parngíh lieh te callong ngki, án nhiem tức-ức tháng. ");
INSERT INTO pac_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tớq ang iláih parnô, mbơiq aryum, máh ticuoi sút top teng rit sang, máh ticuoi sút tớq sớu, alứng máh thới sái rit, parchúng munơi, alứng tanghúng nha máh ticuoi sút cannŏ́h. Cua nha-án tanghúng, nha-án chóq Yê-su, alứng dông asuoi án nga Phi-lat. ");
INSERT INTO pac_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Phi-lat plốh Yê-su: “Mái la puo ticuoi Isa-ra-el lớiq?” Yê-su ôi: “Lư piaiq arớq mái tông.” ");
INSERT INTO pac_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Máh ticuoi sút top teng rit sang cauq Yê-su; nha-án tông Yê-su táq a-ưi arnáq saq. ");
INSERT INTO pac_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dyơ Phi-lat plốh sa Yê-su idô: “Imo mái lớiq ôi? Mái sáng dyơ nha-án cauq mái a-ưi nốh.” ");
INSERT INTO pac_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Yê-su lớiq ôi amớh. Iki Phi-lat sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tớq ingái ticuoi Isa-ra-el parchúng táq pêl bui cha ayư Ingái Ngốh, tớq cứp cumo Phi-lat báq taláh munáq ticuoi tôt, veng cannính ticuoi prái. ");
INSERT INTO pac_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ingái ngki tớq coq bôn munáq ticuoi nốh Ba-raba. Án la te top ính tarpíh sút, alứng án khoiq cachet ticuoi hơ. ");
INSERT INTO pac_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ticuoi clứng tớq nga Phi-lat, alứng seq Phi-lat táq arớq te cumo nsuoi sa. ");
INSERT INTO pac_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Phi-lat plốh nha-án idô: “Inha ính cư taláh puo ticuoi Isa-ra-el lớiq?” ");
INSERT INTO pac_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Phi-lat chom máh ticuoi sút top teng rit sang sáng uan ada Yê-su, co bôn clứng ticuoi veng tapun Yê-su. Iki nha-án dông Yê-su tớq nga án. ");
INSERT INTO pac_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma máh ticuoi sút top teng rit sang yua ticuoi clứng seq Phi-lat taláh Ba-raba, tới Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Phi-lat plốh lieh nha-án idô: “Amớh inha ính cư táq ada ticuoi ndon inha dŏq puo ticuoi Isa-ra-el?” ");
INSERT INTO pac_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nha-án ôi yứng lư idô: “Téh án tớq along calláng!” ");
INSERT INTO pac_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Phi-lat plốh sa nha-án: “Co imo? Án táq luaih amớh?” Ma nha-án ôi yứng lư loi: “Téh án tớq along calláng!” ");
INSERT INTO pac_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Phi-lat ính crái cannính ticuoi clứng. Iki án taláh Ba-raba dyôn nha-án, dyơ án yua ngai carvít Yê-su. Vít ngki án mŏp Yê-su dyôn ngai dông téh tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dyơ top líng caring Yê-su dông nga ngcưm dúng báq ngai tarsưq ticuoi. Nha-án arô parchúng nhéq top líng. ");
INSERT INTO pac_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nha-án asứp Yê-su au thor ntứm eng, alứng nha-án táq carvang tangháng apưng tớq plô Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dyơ nha-án táq náh-nnan carbánh carsuanh án idô: “Cucúh ngai sasai puo ticuoi Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nha-án ial ale tính tớq plô Yê-su, alứng cuchóh tớq cháq án. Nha-án cucúh cucuoi táq náh-nnan sang tám án hơ. ");
INSERT INTO pac_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cua nha-án ayê tar-ac, nha-án luaiq táh au thor ntứm eng. Dyơ nha-án asứp lieh tampớc án bôm. Cua ngki nha-án dông angốh téh án tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ndóng ngki bôn munáq, nốh Si-môn, te cruong Si-rên, a-ám Alec-sandơ nha Ru-phu, án chô te vel cannŏ́h alứng pôq pha carna ngki. Án chô te culái tieh vel. Líng patot án dual along calláng Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nha-án dông Yê-su nga ntúq ngai dŏq Cô-cô-tha. Parnai ndô titoiq lieh la ‘Ntúq Nghang Cudoh Plô’. ");
INSERT INTO pac_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dyơ nha-án dyôn Yê-su ngoiq sieu carchúc dơq tarháu nốh ‘mưr’. Ma Yê-su lớiq ngoiq. ");
INSERT INTO pac_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nha-án téh án tớq along calláng. Dyơ nha-án ial tampớc án, alứng mpô na séng anhúq tampớc ngki, ticuoi mmo bôn la thôi. ");
INSERT INTO pac_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ndóng mát pandang turông crêng, nha-án téh án tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dyơ nha-án taran tớq mêng pan tanieng plô Yê-su idô: “TICUOI NDÔ LA PUO TICUOI ISA-RA-EL.” ");
INSERT INTO pac_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nha-án téh bar náq ticuoi siveng munơi alứng Yê-su, munáq pa atớm, munáq pa aviar Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Arnáq ndô cơt tarvớiq tớq tám uráq Yang Arbang-pilŏ́ng te inớh khoiq tông idô: “Ngai ngiaih án la arớq ticuoi luaih tưi.” ");
INSERT INTO pac_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ticuoi ndon pôq pha ntúq ngai cachet Yê-su, nha-án ca-ot alứng ayê tar-ac Yê-su idô: “Mái ndô ớiq tông mái lóh dúng sang Yang Arbang-pilŏ́ng, dyơ táq lieh pe ingái la dyơ táp. ");
INSERT INTO pac_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Áu mái siar te along calláng ngki, choi tamống cháq mái bôm!” ");
INSERT INTO pac_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Máh ticuoi sút top teng rit sang alứng thới sái rit ayê tar-ac Yê-su tưi. Nha-án tông idô: “Ticuoi cannŏ́h têq án choi tamống, ma cháq án bôm lớiq hôm têq án choi. ");
INSERT INTO pac_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Khán án lư Crit alứng puo ticuoi Isa-ra-el, dyôn án siar te along calláng dyôn he hôm. Iki he lư tin án tưi.” Díh bar náq conh ndon ngai téh tớq along calláng mui parrứh alứng Yê-su, la ayê tar-ac Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Te mát pandang tứng tingôi mát pandang tallóh pưt, cơt ngiau nhéq tớq cruong ngki. ");
INSERT INTO pac_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tớq mát pandang viet, Yê-su arô yứng lư idô: “Ê-lô-i, Ê-lô-i, lama-sabac-tani?” Parnai ngki titoiq lieh la: “Yang Arbang-pilŏ́ng cư ơi. Imo mái táh cư?” ");
INSERT INTO pac_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bôn ticuoi tayứng tumán ngki sáng án arô iki. Dyơ nha-án tông idô: “Ngki! Án arô Ê-li.” ");
INSERT INTO pac_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma bôn munáq te nha-án talúh chô ial mui cúc nsol. Án talứm nsol ngki tớq sieu adyóq alứng chóq tớq callêh. Dyơ án pidáng dyôn Yê-su kidyớp. Án tông idô: “He pớn avai. He me Ê-li tớq talíh asiar án ma lớiq.” ");
INSERT INTO pac_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Yê-su hiar yứng lư, dyơ án pít tarngứh. ");
INSERT INTO pac_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bôn prới ngai yéng tớq Dúng Sang Pưt tarhaq te tanieng tớq tadưp cơt bar tarrec. ");
INSERT INTO pac_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ndóng ngki bôn munáq sút mui culám náq líng át tayứng chứng mát Yê-su. Tư án hôm Yê-su pít tarngứh, án tông idô: “Ticuoi ndô la lư Acái Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bôn top cán át yông-yông me nga tuki. Tớq top cán ngki bôn Mari te vel Mac-dala, Salô-mê, alứng Mari a-i Yacơ Két nha Yô-sê. ");
INSERT INTO pac_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Te nsuoi, ndóng Yê-su át tớq vúng Ca-lilê, pe náq cán ndô báq veng tapun Yê-su, alứng chứm chiam án. Alứng bôn a-ưi cán cannŏ́h hơ ndon báq pôq munơi alứng Yê-su, ndóng án ticứh nga vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ingái ngki la ingái ngai thuan nsuoi Ingái Angô. Tớq ibư tumán ntruoi mot lốc, ");
INSERT INTO pac_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yô-sep te vel Ari-mathê tớq nga Phi-lat. Án la munáq te top ticuoi sút ndon ngai dyám náp lư. Alứng án ngcong Yang Arbang-pilŏ́ng cơt sút. Án lớiq adáh seq cumuiq Yê-su te Phi-lat. ");
INSERT INTO pac_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Phi-lat sáng dut lư ngai táq-ntêr Yê-su khoiq cuchet. Iki án arô sút mui culám náq líng tớq nga án, co án ính plốh te Yê-su cuchet ma iyốh. ");
INSERT INTO pac_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tư Phi-lat chom te sút líng ngki Yê-su khoiq cuchet dyơ, iki án dyôn cumuiq Yê-su nga Yô-sep. ");
INSERT INTO pac_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yô-sep ial mui pláh prới. Dyơ án alíh asiar Yê-su te along calláng; án sŏm Yê-su tớq prới clŏq, alứng án dŏq cumuiq Yê-su tớq ping búl ndon ngai khoiq var. Dyơ án vih búl catáng ngáh ping. ");
INSERT INTO pac_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari te vel Mac-dala alứng Mari a-i Yô-sê, hôm ntúq ngai dŏq cumuiq Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vít ingái angô, Mari te vel Mac-dala, Mari a-i Yacơ alứng Salô-mê, dông crơng thum ính cacháq tớq cumuiq Yê-su. ");
INSERT INTO pac_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ingái mui tớq tún ngki, tớq ang iláih, mát pandang mbơiq ngốh, nha-án tớq nga ping. ");
INSERT INTO pac_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nha-án munáq plốh munáq idô: “Nnáu ính vih búl te ngáh ping dyôn he?” ");
INSERT INTO pac_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Búl ngki pưt lư. Ma tư nha-án tingưi me, nha-án hôm búl khoiq ngai vih dyơ. ");
INSERT INTO pac_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nha-án mot tớq ping, nha-án hôm munáq conh bánh sứp au thor clŏq, ticu pa atớm tớq ntúq ngki. Iki nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma conh ngki tông nha-án idô: “Inha êq adáh. Cư chom inha suo Yê-su te vel Na-saret, án ndon ngai téh tớq along calláng. Án lớiq át nnáng tớq ntúq ndô. Án tumống lieh dyơ. Inha me ntúq ngai dŏq án. ");
INSERT INTO pac_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dyơ inha chô táq-ntêr dyôn top rian te Yê-su alứng Phi-er chom idô: ‘Yê-su pôq nsuoi inha nga vúng Ca-lilê. Inha pôq tuki, inha lư tumúh án arớq án khoiq tông inha te nsuoi dyơ.’” ");
INSERT INTO pac_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iki mu cán ngki lúh ngốh te ping. Nha-án sáng dut alứng dyandyír, co sáng adáh lư. Nha-án lớiq dáh táq-ntêr dyôn ticuoi cannŏ́h chom, co nha-án sáng chếq lư. ");
INSERT INTO pac_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ingái mui tớq tún ngki, Yê-su yôr tumống lieh te cuchet. Iláih ngki yôl cláih lư, án pôq apáh cháq án dyôn Mari te vel Mac-dala hôm. Mari la ticuoi ndon án khoiq chuih angốh tupul náq yang saq te nsuoi. ");
INSERT INTO pac_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dyơ Mari pôq táq-ntêr dyôn top rian te Yê-su chom tưi te arnáq án khoiq hôm. Ma top rian te Yê-su át nhiem alứng sáng anguaq. ");
INSERT INTO pac_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tư nha-án sáng Mari táq-ntêr: Yê-su khoiq tumống lieh alứng án khoiq hôm Yê-su. Ma nha-án lớiq tin parnai án. ");
INSERT INTO pac_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cua ngki bôn bar náq conh te top Yê-su ngốh te vel Yaru-salem. Yê-su apáh cháq án cơt armaiq ndái dyôn bar náq ngki hôm. ");
INSERT INTO pac_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bar náq ngki chô táq-ntêr dyôn top rian te Yê-su chom nha-án khoiq hôm Yê-su. Ma top ngki lớiq tin sa parnai nha-án táq-ntêr. ");
INSERT INTO pac_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tatun loi, Yê-su apáh cháq án dyôn top mui chít la mui náq hôm ndóng nha-án chón chicha. Án tíq nha-án co nha-án bôn mít cớng, alứng lớiq tin ticuoi ndon khoiq hôm án bôn tumống lieh. ");
INSERT INTO pac_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Án yua nha-án idô: “Inha pôq nga cứp cruong tớq cúc cuteq ndô, alứng cato dyôn nhéq tưh ticuoi chom tưi parnai ŏ te cư. ");
INSERT INTO pac_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ticuoi mmo tin cư alứng ráp táq tíc na dơq, cư lư choi tamống ticuoi ngki. Ma ticuoi mmo lớiq tin cư, ticuoi ngki cóq chiuq tôt bôm. ");
INSERT INTO pac_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Máh ticuoi ndon lư tin cư, nha-án têq táq arnáq sileh idô: Nhơ nốh cư, nha-án rap chuih angốh yang saq; nha-án chom táq-ntêr cang ndái; nha-án têq kéu cusánh bôn pih, ma lớiq cơt amớh; nha-án ngoiq crơng bol, ma lớiq bol; alứng nha-án capơiq tớq ticuoi a-ái têq cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cua Yê-su tông iki, Yang Arbang-pilŏ́ng asớr án nga pilŏ́ng, alứng án ticu pa atớm Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dyơ top rian te Yê-su pôq cato níc parnai ŏ te Yê-su. Alứng Yang Arbang-pilŏ́ng dyôn nha-án bôn chức têq táq arnáq sileh. Co iki ticuoi têq chom arlớih lư parnai nha-án cato la parnai lư piaiq.");
INSERT INTO pac_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ơ avốq Theu-phulơ ơi! Bôn clứng ticuoi khoiq catóng taran te máh arnáq Yê-su khoiq táq. Máh parnai ngki khoiq tớq nga he dyơ. ");
INSERT INTO pac_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Máh ticuoi ngki chom te arnáq Yê-su, co nha-án bôn sáng te ticuoi ndon bôn hôm Yê-su te tôm lư. Dyơ nha-án cato máh parnai ŏ ngki dyôn he chom tưi. ");
INSERT INTO pac_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tôm lư, cư khoiq catóng rian dyôn chom arlớih lư te máh parnai nha-án cato. Co iki cư ính taran cơt lơp te máh parnai ngki dyôn mái. ");
INSERT INTO pac_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Cư táq iki ính mái chom simớt lư te máh parnai nha-án khoiq tông mái. ");
INSERT INTO pac_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ndóng pang Hê-rôt cơt puo vúng Yudê, bôn munáq te top teng rit sang Yang Arbang-pilŏ́ng, nốh Sa-chari. Án la te tŏ́ng toiq Abie, ticuoi teng rit sang te inớh. Campái Sa-chari nốh Ê-li-sabet, te tŏ́ng toiq Arôn tưi. ");
INSERT INTO pac_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nha-án bar náq la ticuoi tinớng ŏ chứng mát Yang Arbang-pilŏ́ng. Nha-án peh máh callong Yang Arbang-pilŏ́ng patáp, alứng nha-án ớq callong luaih dyôn ngai têq tíq. ");
INSERT INTO pac_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nha-án ớq acái, co Ê-li-sabet la ticuoi cut, alứng nha-án khoiq ieuq hơ. ");
INSERT INTO pac_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Top teng rit sang Yang Arbang-pilŏ́ng bôn rit mpô táq arnáq cơt top. Bôn mui ingái, top Sa-chari rêh ticuoi na tarséng dyôn mot táq arnáq teng rit sang chứng mát Yang Arbang-pilŏ́ng, ma crái Sa-chari. Nha-án dyôn án mot bet crơng thum tớq parông, tớq callúng Dúng Sang Pưt. ");
INSERT INTO pac_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ndóng án mot bet crơng thum, bôn clứng ticuoi át rum cớu culái tieh. ");
INSERT INTO pac_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dyơ bôn tarneng Yang Arbang-pilŏ́ng tớq nga án. Tarneng ngki tayứng pa atớm parông ngai báq bet crơng thum. ");
INSERT INTO pac_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tư Sa-chari hôm tarneng ngki, án sáng dut alứng adáh lư. ");
INSERT INTO pac_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma tarneng ngki tông idô: “Sa-chari ơi! Mái êq adáh. Yang Arbang-pilŏ́ng khoiq ráp dyơ parnai mái cớu. Ê-li-sabet campái mái, urớh án carnian mui lám acái conh. Cóq inha anốh ngai-acái ngki nốh Yon. ");
INSERT INTO pac_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Urớh mái sáng bui ơn lư co mái bôn acái conh. Alứng clứng ticuoi sáng bui tưi tớq ingái acái conh ngki carnian, ");
INSERT INTO pac_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","co án cơt pưt lư chứng mát Yang Arbang-pilŏ́ng. Án lớiq têq ngoiq sieu, díh cứp nốh ndon táq dyôn bol. Alứng bôn Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính án, náp te ingái a-i án carnian án. ");
INSERT INTO pac_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Urớh án táq dyôn clứng ticuoi Isa-ra-el píh tin lieh Yang Arbang-pilŏ́ng, Ưlla nha-án. ");
INSERT INTO pac_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Urớh án pôq nsuoi Ưlla alứng án bôn mít cannính nha chức arớq Ê-li la ticuoi tang ngcang Yang Arbang-pilŏ́ng. Iki án táq dyôn a-ám alứng acái cơt lieh mui mít. Alứng án ính táq dyôn nha-án ndon cớng ngan píh cơt ticuoi tinớng ŏ lieh. Án táq máh nốh ngki ính choi máh ticuoi dyôn pien lieh mít cannính, dŏq Ưlla têq cơt Ưlla nha-án.” ");
INSERT INTO pac_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sa-chari plốh tarneng ngki idô: “Imo têq cư chom arnáq ngki lư cơt? Cư alứng campái cư khoiq ieuq dyơ.” ");
INSERT INTO pac_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma tarneng ngki ôi án idô: “Nốh cư la Capriel. Cư la tarneng Yang Arbang-pilŏ́ng ndon báq tayứng chứng mát án. Án yua cư tớq tông mái dyôn chom te nốh ŏ ndô. ");
INSERT INTO pac_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hoi-ndô ngcang mái cơt lúng tingôi ingái máh nốh ndô tớq, co mái lớiq náp parnai cư. Tư máh arnáq ndô tớq, ngki cơt tarvớiq simớt cư khoiq tông.” ");
INSERT INTO pac_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndóng ngki bôn clứng ticuoi át pớn Sa-chari culái tieh. Nha-án sáng laq lư Sa-chari át dưnh tớq dúng sang. ");
INSERT INTO pac_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tư Sa-chari ngốh, án lớiq têq táq-ntêr mui callong amớh nnáng. Iki nha-án chom án khoiq hôm Yang Arbang-pilŏ́ng apáh baih dyôn án hôm. Amớh Sa-chari ính táq-ntêr la án táq-ntêr tớq ati sớng, co ngcang án khoiq cơt lúng. ");
INSERT INTO pac_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tớq cua máh ingái Sa-chari táq arnáq tớq dúng sang, dyơ án chô nga dúng án. ");
INSERT INTO pac_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Vít máh ingái ngki, Ê-li-sabet campái án, át cháq-iki. Dyơ Ê-li-sabet át níc tớq dúng alứng lớiq ngốh pôq tumo sám bôn sông kisái. ");
INSERT INTO pac_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Alứng án tông idô: “Hoi-ndô cư sáng bui ơn lư, co Yang Arbang-pilŏ́ng dyôn cư át cháq-iki; iki cư lớiq sáng achiet táq ticuoi cannŏ́h nnáng co cư ớq acái.” ");
INSERT INTO pac_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ê-li-sabet át cháq-iki khoiq tupát kisái dyơ. Tớq kisái ngki, Yang Arbang-pilŏ́ng yua tarneng án, Capriel, pôq nga vel Na-saret, vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Capriel dông parnai Yang Arbang-pilŏ́ng nga munáq cumor plŏt, nốh Mari. A-i a-ám án khoiq par-ưq dyôn án tar-ial alứng munáq conh, nốh Yô-sep. Yô-sep la te tŏ́ng toiq Davit, puo ticuoi Isa-ra-el te inớh. ");
INSERT INTO pac_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tarneng ngki tớq nga Mari, alứng pasôl idô: “Bánh tưi Mari. Yang Arbang-pilŏ́ng lư át alứng mái, alứng án dyôn mái bôn callong bún pưt lư!” ");
INSERT INTO pac_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tư Mari sáng parnai tarneng tông iki, án sáng dut alứng crŏ́q lư. Án lớiq chom co imo tarneng tông ada án parnai ngki. ");
INSERT INTO pac_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tarneng ngki tông án idô: “Mari ơi! Mái êq adáh, co Yang Arbang-pilŏ́ng khoiq rêh mái dyôn bôn callong bún. ");
INSERT INTO pac_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lớiq dưnh nnáng mái lư át cháq-iki; dyơ mái carnian mui lám acái conh. Cóq mái anốh nốh án la Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Urớh án cơt sút, alứng ngai dŏq án la Acái Yang Arbang-pilŏ́ng ndon sút clưi nhéq te cannŏ́h. Yang Arbang-pilŏ́ng Ưlla he ính chóh án dyôn cơt puo muchứng achúc achiac án Davit te inớh tưi. ");
INSERT INTO pac_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Án lư cơt níc puo máh tŏ́ng toiq Yacốp tingôi sút nhéq pang!” ");
INSERT INTO pac_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari ôi tarneng ngki idô: “Imo têq cơt nốh ndô nga cư? Cư lớiq nai bíq munơi alứng ticuoi conh.” ");
INSERT INTO pac_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma tarneng ôi án idô: “Tatun, Arvai Yang Arbang-pilŏ́ng lư át alứng mái. Alứng Yang Arbang-pilŏ́ng ndon sút clưi nhéq te cannŏ́h kiaq me mái. Iki mái bôn acái práh ŏ lư. Ngai dŏq acái mái la Acái Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mái ayư te ơi mái Ê-li-sabet. Án la ticuoi khoiq ieuq, alứng ngai tông án la ticuoi cut. Ma hoi-ngki án át cháq-iki mui lám acái conh. Án át cháq-iki khoiq tupát kisái dyơ. ");
INSERT INTO pac_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yang Arbang-pilŏ́ng têq táq nhéq cứp arnáq.” ");
INSERT INTO pac_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dyơ Mari ôi idô: “Cư la ticuoi táq arnáq Yang Arbang-pilŏ́ng. Cư seq máh nốh mái tông, dyôn tớq nga cư.” Vít ngki tarneng ngốh te Mari. ");
INSERT INTO pac_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tớq callúng máh ingái ngki, Mari thuan pôq nga mui vel ndon át tớq king cóh vúng Yudê. Án pôq chái lư, co ính tớq adứh nga vel ngki. ");
INSERT INTO pac_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tư án tớq, án mot tớq dúng Sa-chari, alứng án cabánh Ê-li-sabet. ");
INSERT INTO pac_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ndóng Ê-li-sabet sáng Mari cabánh án, iki acái tớq pallúng án táq-arto. Alứng Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính án. ");
INSERT INTO pac_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dyơ án tông yứng lư idô: “Yang Arbang-pilŏ́ng dyôn mái bôn callong bún hơn nhéq te máh ticuoi cán! Alứng acái tớq pallúng mái, án bôn callong bún tưi! ");
INSERT INTO pac_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Co imo a-i Ưlla cư tớq alang cư? Arnáq ndô la pưt lư dyôn cư! ");
INSERT INTO pac_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ndóng cư sáng parnai mái cabánh cư, acái tớq pallúng cư táq-arto, co án sáng bui tưi. ");
INSERT INTO pac_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bún lư mái, co mái tin, iki lư cơt arớq parnai Yang Arbang-pilŏ́ng tông ada mái!” ");
INSERT INTO pac_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dyơ Mari tông idô: “Cư ayô Ưlla cư nhéq te tarngứh. ");
INSERT INTO pac_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Alứng mít cannính cư sáng bui hơr lư, co Yang Arbang-pilŏ́ng la Yang ndon choi tamống cư. ");
INSERT INTO pac_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Cư la ticuoi ngáq sớng ndon táq arnáq án, ma án nnáng me alứng choi cư. Te hoi-ndô tingôi tatun, cứp pang ticuoi dŏq cư la ticuoi bôn callong bún, ");
INSERT INTO pac_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","co Yang Arbang-pilŏ́ng ndon bôn chức pưt lư táq arnáq ŏ ada cư. Nốh án la práh ŏ lư. ");
INSERT INTO pac_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Án sruiq táq máh ticuoi ndon dyám náp án te pang inớh tingôi pang chô-mát. ");
INSERT INTO pac_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Án khoiq táq arnáq pưt lư na ati án táp. Alứng án khoiq chuih máh ticuoi ndon parngíh nha-án pưt hơn alứng ŏ hơn te ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Án khoiq táq ada nha-án ndon sút pưt cơt lớiq sút pưt nnáng. Ma án khoiq asớr nha-án ndon két dyôn cơt pưt. ");
INSERT INTO pac_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Án khoiq dyôn máh ticuoi ớq cơt bôn cứp nốh ŏ. Ma án táq dyôn máh nha-án ndon súc cơt chô ati nnŏ́h sớng. ");
INSERT INTO pac_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Án lớiq bôn clớiq máh callong án khoiq carhŏt ada achúc achiac he. Alứng án khoiq choi máh ticuoi Isa-ra-el ndon táq arnáq án. ");
INSERT INTO pac_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Án sruiq táq A-praham alứng máh tŏ́ng toiq A-praham níc-níc!” ");
INSERT INTO pac_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Cua Mari tông máh parnai ngki, dyơ án át alứng Ê-li-sabet bôn pe kisái. Vít ngki án chô lieh nga dúng án. ");
INSERT INTO pac_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dyơ tớq ngư Ê-li-sabet carnian acái, án carnian mui lám acái conh. ");
INSERT INTO pac_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Máh ticuoi tớq vel ngki, alứng máh em ai án khoiq sáng te arnáq Yang Arbang-pilŏ́ng sruiq táq Ê-li-sabet. Iki nha-án sáng bui tưi alứng Ê-li-sabet. ");
INSERT INTO pac_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tớq ngai-acái ngki bôn ticol ingái, nha-án pôq táq rit kít dyôn án. Nha-án ính anốh nốh án la Sa-chari, soi nốh a-ám án. ");
INSERT INTO pac_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma a-i án tông idô: “Lớiq! He dŏq nốh án la Yon.” ");
INSERT INTO pac_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma máh ticuoi ngki tông idô: “Tớq sớu mái lớiq bôn ngai bôn nốh arớq iki!” ");
INSERT INTO pac_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dyơ nha-án plốh a-ám acái ngki na ati. Co nha-án ính chom, amớh án ính dŏq nốh acái án. ");
INSERT INTO pac_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sa-chari seq mui mêng pan két; dyơ án taran tớq pan idô: “Nốh án la Yon.” Iki nhéq ticuoi ngki sáng dut lư! ");
INSERT INTO pac_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ndóng ngki táp Sa-chari têq lieh táq-ntêr, alứng án ayô Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Máh ticuoi tớq vel ngki sáng laq lư. Alứng arnáq ndô cơt rŏ́h mưt-mư cứp ntúq tớq king cóh vúng Yudê. ");
INSERT INTO pac_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Máh ticuoi ndon sáng te arnáq ndô, nha-án cadyom dŏq tớq mít, alứng munáq plốh munáq idô: “Ngai-acái ndô urớh án cơt imo?” Co Yang Arbang-pilŏ́ng át alứng án. ");
INSERT INTO pac_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dyơ Sa-chari a-ám ngai-acái bôn Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính án. Iki án cato parnai te Yang Arbang-pilŏ́ng idô: ");
INSERT INTO pac_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Cóq he ayô Ưlla he, la Yang Arbang-pilŏ́ng ticuoi Isa-ra-el sang. Lư án tớq choi máh ticuoi án, alứng án thái nha-án te callong luaih. ");
INSERT INTO pac_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Án dyôn munáq ndon bôn chức lư tớq choi tamống he. Munáq ngki tớq te tŏ́ng toiq puo Davit ndon táq arnáq Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nhéq nốh ndô Yang Arbang-pilŏ́ng khoiq tông te inớh na máh ticuoi tang ngcang án ndon práh ŏ lư. ");
INSERT INTO pac_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Án khoiq ưq ính choi he dyôn vít te ticuoi picon, alứng te ati ticuoi a-ính he. ");
INSERT INTO pac_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Án khoiq amoih achúc achiac he. Alứng án lớiq nai clớiq te máh callong án khoiq carhŏt te nsuoi. ");
INSERT INTO pac_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Án khoiq carhŏt ada A-praham achúc achiac he idô: ");
INSERT INTO pac_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Án ính choi he dyôn vít te ati ticuoi picon, alứng ính dyôn he táq arnáq án lớiq sáng adáh amớh; ");
INSERT INTO pac_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","án táq iki la dŏq he têq át tinớng nha práh ŏ chứng mát án nhéq pang tumống he. ");
INSERT INTO pac_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Acái cư ơi! Urớh ngai dŏq mái la munáq tang ngcang Yang Arbang-pilŏ́ng, án ndon sút clưi nhéq te cannŏ́h, co mái bôn pôq nsuoi Ưlla he, alứng cháh carna dyôn án. ");
INSERT INTO pac_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Alứng mái tông dyôn máh ticuoi án bôn chom, la Yang Arbang-pilŏ́ng táh luaih nha-án dŏq án têq choi tamống nha-án. ");
INSERT INTO pac_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Co Yang Arbang-pilŏ́ng he sáng sruiq táq, iki án dyôn munáq ndon án rêh tớq nga he, dŏq choi tamống ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ticuoi ngki tớq te pilŏ́ng, alứng án táq dyôn máh ticuoi ndon át tớq ntúq ngiau lớiq sáng adáh nnáng cuchet. Alứng án ayông he pôq tớq carna ien ŏ.” ");
INSERT INTO pac_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dyơ ngai-acái ngki pưt asớr, alứng án bôn mít cannính ính lư veng ngê Yang Arbang-pilŏ́ng. Án át tớq ntúq aih tingôi ingái án tabớq táq arnáq dŏq apáh dyôn máh ticuoi Isa-ra-el hôm. ");
INSERT INTO pac_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Máh ingái ngki Acu-tơ puo Rô-ma, cơt sút nhéq máh cruong paniar ngki. Án yua nhéq máh ticuoi pôq taran nốh tớq pứng abŏ́h, co án ính chom máh-mmo clứng ticuoi prái án. ");
INSERT INTO pac_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ndô la chư tôm lư ngai náp ticuoi, ndóng Curê-nie cơt sút tadưp Acu-tơ, tớq cruong Si-ri. ");
INSERT INTO pac_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nhéq máh ticuoi mmar chô nga vel nha-án, dŏq taran nốh tớq pứng abŏ́h tớq vel nha-án bôm. ");
INSERT INTO pac_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iki Yô-sep ngốh te vel Na-saret, vúng Ca-lilê. Án pôq nga vúng Yudê, vel Bet-lahem la vel Davit. Án mot vel ndô, co án la te tŏ́ng toiq Davit. ");
INSERT INTO pac_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Án ính taran nốh tớq pứng abŏ́h nga tuki. Alứng án dông díh Mari la cán ngai ưq dyôn án ial táq campái. Ma Mari khoiq át cháq-iki dyơ. ");
INSERT INTO pac_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ndóng nha-án át tớq ngki, tớq ngư Mari carnian acái. ");
INSERT INTO pac_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Dyơ án carnian acái conh pông. Án a-ul án tớq prới, alứng dŏq tớq tinaq sác, co máh dúng tớq vel ngki khoiq kitát nhéq ticuoi, lớiq bôn ntúq dyôn nha-án bíq. ");
INSERT INTO pac_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tớq cruong ngki bôn ticuoi át bán pannán cưu, alứng tớq idáu nha-án át kiaq cưu tớq rong. ");
INSERT INTO pac_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tớq idáu ngki, bôn mui tarneng Yang Arbang-pilŏ́ng tớq nga nha-án, alứng ang te Yang Arbang-pilŏ́ng claq paniar nha-án; iki nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tarneng ngki tông nha-án idô: “Êq adáh! Cư tớq tông inha mui nốh ŏ alứng bui ơn lư dyôn nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ingái ndô tớq vel Davit, bôn munáq khoiq carnian dŏq choi tamống inha. Munáq ndô la Crit; án la Ưlla he. ");
INSERT INTO pac_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndô la tíc dyôn inha: Inha lư tumúh acái cusáu hưr ngai acuom tớq prới. Án bíq tớq tinaq sác.” ");
INSERT INTO pac_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ndóng ngki táp bôn clứng lư tarneng Yang Arbang-pilŏ́ng át munơi alứng tarneng ngki. Nhéq tưh nha-án ayô Yang Arbang-pilŏ́ng, idô: ");
INSERT INTO pac_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Lư ayô Yang Arbang-pilŏ́ng ndon át tớq pilŏ́ng. Án dyôn callong ien ŏ tớq nga cúc cuteq ndô, la dyôn nga ticuoi ndon án sáng bui cannính.” ");
INSERT INTO pac_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tư nhéq máh tarneng ngki ngốh te ticuoi bán cưu, alứng sớr lieh nga pilŏ́ng, dyơ ticuoi bán cưu munáq tardông munáq idô: “He! He pôq nga vel Bet-lahem. He pôq me arnáq ndon khoiq tớq arớq Yang Arbang-pilŏ́ng khoiq tông he.” ");
INSERT INTO pac_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dyơ nha-án pôq chái lư; nha-án tumúh Mari, Yô-sep, alứng ngai-acái ndon mbơiq carnian. Án bíq tớq tinaq sác. ");
INSERT INTO pac_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tớq nha-án hôm iki, dyơ nha-án pôq táq-ntêr dyôn ticuoi cannŏ́h chom tưi te máh parnai nha-án khoiq sáng te tarneng khoiq tông te ngai-acái ngki. ");
INSERT INTO pac_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Cứp náq ticuoi ndon cammáng parnai top bán cưu táq-ntêr sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Mari cadyom dŏq tớq mít án nhéq arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Iki ticuoi bán cưu, ntơnh nha-án chô ntơnh nha-án ayô Yang Arbang-pilŏ́ng, co máh arnáq nha-án khoiq sáng alứng hôm, la lư cơt in ngai khoiq tông nha-án. ");
INSERT INTO pac_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Náp te ingái carnian ngai-acái ngki bôn ticol ingái, dyơ a-i a-ám án táq rit kít dyôn án veng phep rit ticuoi Isa-ra-el. Ingái ngki nha-án anốh acái nha-án la Yê-su. Nha-án ial nốh arớq tarneng Yang Arbang-pilŏ́ng khoiq tông nha-án ndóng Mari iyốh át cháq-iki. ");
INSERT INTO pac_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Vít ngki Yô-sep alứng Mari dông acái nha-án nga vel pưt Yaru-salem dŏq táq rit sarau veng phep rit Môi-se khoiq tông, alứng ính mŏp sang acái nha-án dyôn Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Co Yang Arbang-pilŏ́ng khoiq patáp ticuoi Isa-ra-el te inớh idô: “Cứp náq acái conh pông cóq inha dông mŏp sang dyôn Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Alứng nha-án ính mŏp sang crơng dyôn Yang Arbang-pilŏ́ng hơ, co Yang Arbang-pilŏ́ng khoiq patáp ticuoi Isa-ra-el idô: “Cua cán bíq ớr-uih cóq án dông nga dúng sang mui cu achếq cacu lớiq la bar lám achếq catru yưl.” ");
INSERT INTO pac_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bôn munáq conh tớq vel Yaru-salem, nốh Si-mê-ôn. Án la ticuoi tinớng ŏ alứng peh simớt simơi parnai Yang Arbang-pilŏ́ng. Án ngcong níc ingái Yang Arbang-pilŏ́ng dyôn munáq ticuoi tớq choi tamống ticuoi Isa-ra-el. Arvai Yang Arbang-pilŏ́ng át níc alứng án. ");
INSERT INTO pac_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Alứng Arvai Yang Arbang-pilŏ́ng tông dyôn án chom, án lớiq cuchet nsuoi te án bôn hôm Crit ndon Yang Arbang-pilŏ́ng rêh dŏq choi tamống ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ingái ngki Arvai Yang Arbang-pilŏ́ng dông Si-mê-ôn mot tớq Dúng Sang Pưt. Ndóng ngki a-i a-ám Yê-su dông Yê-su nga Dúng Sang Pưt, co ính táq veng phep rit Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Si-mê-ôn ial cabêm ngai-acái ngki alứng si-ơn Yang Arbang-pilŏ́ng idô: ");
INSERT INTO pac_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yang Arbang-pilŏ́ng ơi! Khoiq tớq dyơ arnáq inha ưq ada cư. Hoi-ngki khán inha dyôn cư ndon táq arnáq inha cuchet, la cư sáng bui lư, ");
INSERT INTO pac_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","co mát cư khoiq hôm dyơ án ndon inha rêh dyôn choi tamống ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Arnáq ndô inha thuan chứng mát nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Án la arớq tabong tabal carna dyôn máh ticuoi tới ticuoi Isa-ra-el. Nhơ án, nhéq tưh ticuoi bôn ayô ticuoi Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A-i a-ám Yê-su sáng dut lư te parnai Si-mê-ôn tông te acái nha-án. ");
INSERT INTO pac_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dyơ Si-mê-ôn cớu seq callong bún dyôn nha-án, alứng án tông Mari a-i Yê-su idô: “Acái mái ndô, Yang Arbang-pilŏ́ng khoiq rêh án dyôn a-ưi náq ticuoi Isa-ra-el têq át tumán lieh Yang Arbang-pilŏ́ng nhơ te án, alứng dyôn a-ưi náq ticuoi Isa-ra-el át yông te Yang Arbang-pilŏ́ng la co te án. Án ính apáh ngê Yang Arbang-pilŏ́ng dyôn máh ticuoi chom. Ma lư bôn clứng ticuoi ính tông chíl án. ");
INSERT INTO pac_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Cứp callong máh ticuoi catốq dŏq tớq mít cannính, urớh máh callong ngki cơt mpáh nhéq. Alứng bôn callong anguaq lư tớq nga mái cơt arớq pla coih achít tớq mít cannính mái.” ");
INSERT INTO pac_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bôn munáq ayáq ieuq loi tớq nga ngki tưi, nốh án la Ana, acái Pha-nual, top Asêr. Án la ticuoi tang ngcang Yang Arbang-pilŏ́ng tưi. Te nsuoi, án bôn cayieq; án át alứng cayieq án bôn tupul cumo. ");
INSERT INTO pac_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Cua ngki án át cammai tingôi anhúq án bôn ticol chít la puan cumo. Án lớiq bôn ngốh te Dúng Sang Pưt. Ingái alứng idáu án át sang tám níc Yang Arbang-pilŏ́ng. Án báq cớu alứng ót tanna. ");
INSERT INTO pac_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma ndóng ngki táp án tớq nga a-i a-ám Yê-su. Dyơ án si-ơn Yang Arbang-pilŏ́ng, alứng án tông te ngai-acái ndô dyôn máh ticuoi ndon át ngcong munáq ndon Yang Arbang-pilŏ́ng rêh dyôn tớq taláh vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cua a-i a-ám Yê-su táq máh nốh veng phep rit Yang Arbang-pilŏ́ng khoiq patáp ticuoi Isa-ra-el, dyơ nha-án chô lieh nga dúng nha-án tớq vel Na-saret, vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yê-su pưt asớr alứng cơt bánh rêng. Án tubáiq lư. Alứng Yang Arbang-pilŏ́ng dyôn án bôn callong bún a-ưi. ");
INSERT INTO pac_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cứp cumo a-i a-ám Yê-su báq pôq nga vel pưt Yaru-salem dŏq cha bui ayư Ingái Ngốh. ");
INSERT INTO pac_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tớq Yê-su bôn mui chít la bar cumo, nha-án pôq sa nga vel Yaru-salem dŏq táq veng rit cha bui. ");
INSERT INTO pac_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cua ingái cha bui, nha-án ính chô lieh nga dúng. Ma Yê-su yôl át tớq vel Yaru-salem. A-i a-ám án lớiq chom án át lieh. ");
INSERT INTO pac_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nha-án parngíh án chô alứng yớu ndon pôq munơi. Iki nha-án pôq nhéq mui ingái. Tớq idáu, nha-án suo plốh máh em ai alứng yớu te vel nha-án. ");
INSERT INTO pac_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma nha-án lớiq tumúh án. Iki nha-án píh lieh nga vel Yaru-salem, alứng suo án nga tuki. ");
INSERT INTO pac_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Vít pe ingái, nha-án bôn tumúh án tớq Dúng Sang Pưt. Án ticu munơi alứng top thới pasoi te phep rit ticuoi Isa-ra-el. Án cammáng alứng plốh nha-án. ");
INSERT INTO pac_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Máh ticuoi ndon cammáng sáng dut te parnai án ôi tubáiq lư. ");
INSERT INTO pac_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tớq a-i a-ám án hôm án, ngki nha-án sáng dut lư. A-i án tông án idô: “Acái ơi! Imo acái táq arớq ndô ada he? A-ám mái alứng cư tál lư suo mái.” ");
INSERT INTO pac_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yê-su ôi nha-án idô: “Co imo inha suo cư? Imo inha lớiq chom cư cóq át tớq dúng A-ám cư?” ");
INSERT INTO pac_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma nha-án lớiq apúh te parnai acái nha-án tông. ");
INSERT INTO pac_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dyơ Yê-su chô alứng a-i a-ám án nga vel Na-saret. Alứng án cammáng nhéq máh parnai a-i a-ám án tông. Ma a-i án cadyom dŏq tớq mít máh arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tư Yê-su pưt asớr, án cơt tubáiq lư loi. Alứng máh arnáq án táq la ŏ asớr lư loi chứng mát Yang Arbang-pilŏ́ng alứng chứng mát ticuoi hơ. ");
INSERT INTO pac_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ndóng ngki Tuber-rơ, puo Rô-ma, cơt sút cruong ngki khoiq mui chít la sông cumo dyơ. Pon-ti Phi-lat cơt sút tadưp Tuber-rơ tớq vúng Yudê. Hê-rôt An-tipa cơt sút tớq vúng Ca-lilê. Phi-lip a-em Hê-rôt, cơt sút tớq cruong I-turê alứng Tra-canit; Li-sanie cơt sút tớq cruong Abi-lên. ");
INSERT INTO pac_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","An-na alứng Cai-pha cơt ariaih máh top teng rit sang Yang Arbang-pilŏ́ng. Ndóng ngki parnai Yang Arbang-pilŏ́ng tớq nga Yon, acái conh Sa-chari, ndóng án át tớq ntúq aih. ");
INSERT INTO pac_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Án pôq pau tông tớq máh cruong paniar crong Yôr-dan te arnáq táq tíc na dơq. Rit na dơq ndô la táq tíc te ticuoi khoiq pien cơt mít tamme loi, dŏq Yang Arbang-pilŏ́ng táh luaih dyôn nha-án. ");
INSERT INTO pac_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Án táq muchứng Ê-sai ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh idô: “Bôn sieng tubau yứng lư te ntúq aih idô: ‘Cóq inha pangcra carna dyôn Ưlla he. Cháh báng dyôn tinớng carna dyôn án pôq. ");
INSERT INTO pac_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Máh ahuar cóh cóq inha puan dyôn pớnh. Alứng máh plô cóh cóq inha píq tali dyôn cơt clúng. Máh carna cóc véc cóq inha báng dyôn tinớng. Alứng máh carna tanghúc-tanghúr, cóq inha cabur dyôn ali-li. ");
INSERT INTO pac_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iki, cứp náq ticuoi têq hôm alứng chom Yang Arbang-pilŏ́ng lư choi tamống ticuoi!’” ");
INSERT INTO pac_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bôn clứng ticuoi tớq nga Yon ính án táq tíc na dơq dyôn nha-án. Án tông nha-án idô: “Inha pla arớq cusánh tur. Inha lớiq têq viar vít te Yang Arbang-pilŏ́ng táq inha, tớq án táq máh ticuoi luaih tớq ingái talloiq. ");
INSERT INTO pac_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cóq inha táq arnáq ŏ. Ndô la tíc inha khoiq pien cơt mít tamme loi. Êq parngíh inha têq viar vít te tôt co inha ngin idô: ‘A-praham la achúc achiac he.’ Cư tông inha arlớih lư, khán Yang Arbang-pilŏ́ng ính, án têq ial búl, dyơ teng cơt tŏ́ng toiq A-praham! ");
INSERT INTO pac_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hoi-ndô arớq bôn mui pla achát payơ tumán máh tôm along. Tôm mmo lớiq bôn culái ŏ, ngai ính cớl, dyơ arpớt tớq uih.” ");
INSERT INTO pac_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dyơ máh ticuoi ngki plốh Yon idô: “Khán iki, amớh he cóq táq?” ");
INSERT INTO pac_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yon ôi nha-án idô: “Ticuoi mmo bôn bar pláh au, cóq án dyôn ticuoi ndon ớq au. Ticuoi mmo bôn crơng tanna, cóq án táq muchứng ngki tưi.” ");
INSERT INTO pac_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bôn máh ticuoi ndon ial práq thêq tớq nga Yon, ính án táq tíc na dơq dyôn nha-án. Nha-án plốh idô: “Thới ơi! Amớh he cóq táq?” ");
INSERT INTO pac_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yon tông nha-án idô: “Inha êq ial práq thêq clưi te ngai anát.” ");
INSERT INTO pac_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Alứng máh líng plốh tưi idô: “Ma he, amớh he cóq táq?” Yon tông nha-án idô: “Inha êq padớm ticuoi cannŏ́h cóq dyôn inha práq, alứng êq cauq apít ticuoi cannŏ́h. Inha êq parngíh ính bôn práq a-ưi hơn te práq kisái inha.” ");
INSERT INTO pac_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tớq ticuoi clứng sáng máh parnai Yon tông, nha-án át ngcong alứng parngíh te Yon, án la Crit ma lớiq. ");
INSERT INTO pac_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yon tông nha-án idô: “Cư táq tíc dyôn inha nưm na dơq. Ma án ndon tớq tatun cư, án ngki bôn chức pưt hơn te cư. Cư lớiq crái díh lếh ntár cơp te dyưng án, co chức cư két lư. Án táp táq tíc dyôn inha na Arvai Yang Arbang-pilŏ́ng alứng na uih. ");
INSERT INTO pac_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ati án kéu adêng dŏq om nhéq máh sro. Sro mmo chong, án dŏq tớq tanic. Ma sro mmo acam, ngki án apŏ́ng tớq uih chéh lớiq nai pát dyôn ngcat nhéq.” ");
INSERT INTO pac_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dyơ Yon cato a-ưi parnai cannŏ́h loi dyôn ticuoi ngki chom parnai ŏ te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma Yon tíq puo Hê-rôt An-tipa, co án khoiq ial Hê-rô-die, campái a-em án. Alứng án khoiq táq arnáq saq cannŏ́h hơ. ");
INSERT INTO pac_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Alứng án táq saq pilư loi, co án khoiq crál Yon tớq coq tôt. ");
INSERT INTO pac_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ndóng Yon táq tíc na dơq dyôn máh ticuoi ngki, án táq díh dyôn Yê-su hơ. Tư Yê-su cớu, pilŏ́ng cơt arớq ngai pốh, ");
INSERT INTO pac_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","alứng bôn Arvai Yang Arbang-pilŏ́ng siar te pilŏ́ng arớq achếq cacu bôt tớq cháq Yê-su. Alứng bôn sieng Yang Arbang-pilŏ́ng tubau tông te pilŏ́ng idô: “Mái la Acái cư, án ndon cư amoih lư. Cư sáng bui cannính lư alứng mái.” ");
INSERT INTO pac_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ndóng Yê-su tabớq táq arnáq án bôm, anhúq án sám pe chít cumo. Veng ngê ticuoi, án la acái conh Yô-sep. Yô-sep la acái conh He-li. ");
INSERT INTO pac_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","He-li la acái conh Mathat. Mathat la acái conh Lê-vi. Lê-vi la acái conh Mêl-ki. Mêl-ki la acái conh Yanê. Yanê la acái conh Yô-sep. ");
INSERT INTO pac_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yô-sep la acái conh Ma-tathie. Ma-tathie la acái conh Amôt. Amôt la acái conh Nahum. Nahum la acái conh E-sali. E-sali la acái conh Nakê. ");
INSERT INTO pac_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakê la acái conh Mat. Mat la acái conh Ma-tathie. Ma-tathie la acái conh Samên. Samên la acái conh Yô-séc. Yô-séc la acái conh Yô-da. ");
INSERT INTO pac_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yô-da la acái conh Yô-anan. Yô-anan la acái conh Rê-sa. Rê-sa la acái conh Saru-babel. Saru-babel la acái conh Sial-tiel. Sial-tiel la acái conh Nari. ");
INSERT INTO pac_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nari la acái conh Mêl-ki. Mêl-ki la acái conh Adi. Adi la acái conh Cusam. Cusam la acái conh El-madan. El-madan la acái conh E-rơ. ");
INSERT INTO pac_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","E-rơ la acái conh Yô-sua. Yô-sua la acái conh E-lia-se. E-lia-se la acái conh Yô-rim. Yô-rim la acái conh Mathat. Mathat la acái conh Lê-vi. ");
INSERT INTO pac_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lê-vi la acái conh Si-mê-ôn. Si-mê-ôn la acái conh Yuda. Yuda la acái conh Yô-sep. Yô-sep la acái conh Yô-nam. Yô-nam la acái conh Alia-kim. ");
INSERT INTO pac_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Alia-kim la acái conh Malie. Malie la acái conh Me-na. Me-na la acái conh Ma-tatha. Ma-tatha la acái conh Nathan. Nathan la acái conh Davit. ");
INSERT INTO pac_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davit la acái conh Yê-sai. Yê-sai la acái conh Ô-bêt. Ô-bêt la acái conh Bô-at. Bô-at la acái conh Sal-môn. Sal-môn la acái conh Nasôn. Nasôn la acái conh Ami-nadap. ");
INSERT INTO pac_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ami-nadap la acái conh At-min. At-min la acái conh Arni. Arni la acái conh Hê-trôn. Hê-trôn la acái conh Pharêt. Pharêt la acái conh Yuda. ");
INSERT INTO pac_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda la acái conh Yacốp. Yacốp la acái conh I-sac. I-sac la acái conh A-praham. A-praham la acái conh Thara. Thara la acái conh Nahor. ");
INSERT INTO pac_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor la acái conh Sê-ruc. Sê-ruc la acái conh Rêu. Rêu la acái conh Pê-léc. Pê-léc la acái conh Ê-bêr. Ê-bêr la acái conh Sê-lah. ");
INSERT INTO pac_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sê-lah la acái conh Cai-nan. Cai-nan la acái conh Apac-sat. Apac-sat la acái conh Sem. Sem la acái conh Nô-ê. Nô-ê la acái conh Lamec. ");
INSERT INTO pac_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec la acái conh Mê-thu-sala. Mê-thu-sala la acái conh Ê-nóc. Ê-nóc la acái conh Yaret. Yaret la acái conh Maha-lalê. Maha-lalê la acái conh Kê-nan. ");
INSERT INTO pac_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kê-nan la acái conh Ê-nôih. Ê-nôih la acái conh Sêt. Sêt la acái conh Adam. Alứng Adam la acái conh Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tư Yê-su chô te dơq crong Yôr-dan, Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính án. Arvai ngki dông án pôq nga ntúq aih. ");
INSERT INTO pac_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Át ngki yang Satán án ndon sút nhéq yang saq tớq chim Yê-su nhéq puan chít ingái puan chít idáu co ính tardông Yê-su táq luaih. Nhéq máh ingái ngki, Yê-su lớiq bôn cha amớh. Vít ngki Yê-su sáng pinhaih. ");
INSERT INTO pac_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yang Satán tông Yê-su idô: “Khán mái lư Acái Yang Arbang-pilŏ́ng, áu mái táq búl ndô dyôn cơt crơng tanna.” ");
INSERT INTO pac_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Yê-su ôi án idô: “Tớq tám uráq Yang Arbang-pilŏ́ng khoiq taran idô: ‘Ticuoi lớiq bôn tumống co nhơ te nưm cha crơng tanna sớng.’” ");
INSERT INTO pac_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dyơ yang Satán dông Yê-su sớr tớq cóh. Án apáh dyôn Yê-su me nhéq tưh cruong tớq cúc cuteq ndô mui carbáih mát sớng. ");
INSERT INTO pac_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Alứng yang Satán tông idô: “Lư cư dyôn mái sút nhéq tưh cruong ndô, alứng cư dyôn mái bôn máh ntưn tớq cruong ndô, co ngai khoiq mŏp dyôn cư cơt ưlla cứp cruong ndô. Nnáu cư ính dyôn la cư dyôn. ");
INSERT INTO pac_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Khán mái chóh tarcol sang cư, cư lư mŏp nhéq dyôn a mái.” ");
INSERT INTO pac_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yê-su ôi lieh idô: “Tớq tám uráq Yang Arbang-pilŏ́ng khoiq taran idô: ‘Cóq inha sang tám Yang Arbang-pilŏ́ng la Ưlla inha, alứng táq nưm arnáq án sớng.’” ");
INSERT INTO pac_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dyơ yang Satán dông Yê-su mot tớq vel Yaru-salem. Án dyôn Yê-su sớr tayứng tớq mpuong Dúng Sang Pưt ayống lư. Alứng án tông idô: “Khán mái lư Acái Yang Arbang-pilŏ́ng, áu mái póng asiar, ");
INSERT INTO pac_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","co tớq tám uráq Yang Arbang-pilŏ́ng khoiq taran idô: ‘Yang Arbang-pilŏ́ng yua máh tarneng án tớq bán kiaq níc mái. ");
INSERT INTO pac_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nha-án lư dơ mái na ati nha-án, lớiq dyôn dyưng mái cơt bác chol amớh tớq búl.’” ");
INSERT INTO pac_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Yê-su ôi lieh idô: “Tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông dyơ idô: ‘Inha êq chim Yang Arbang-pilŏ́ng Ưlla inha.’” ");
INSERT INTO pac_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cua yang Satán chim Yê-su cứp nốh, dyơ án tôi te Yê-su alứng pớn ingái tatun loi. ");
INSERT INTO pac_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dyơ Yê-su chô nga vúng Ca-lilê, alứng án bôn chức te Arvai Yang Arbang-pilŏ́ng, dyơ arnáq ngki cơt parhanh cứp ntúq paniar ngki. ");
INSERT INTO pac_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Án cato tớq dúng rum tớq vúng ngki, alứng cứp náq ticuoi át tớq ngki ayô án. ");
INSERT INTO pac_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dyơ Yê-su pôq nga vel Na-saret, la vel án át te ndóng án yôl két. Tớq Ingái Angô án mot tớq dúng rum arớq án báq táq te nling. Án tayứng ính dŏc te parnai Yang Arbang-pilŏ́ng chứng mát máh ticuoi tớq dúng rum. ");
INSERT INTO pac_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bôn ticuoi avôi nga án tám uráq Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh. Án pốh uráq ngki, alứng án suo ntúq Ê-sai taran idô: ");
INSERT INTO pac_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yang Arbang-pilŏ́ng dyôn Arvai án cơt sút tớq mít cannính cư, co án khoiq rêh alứng chóh cư dŏq cato parnai ŏ te án dyôn ticuoi kidit. Án khoiq yua cư pôq pau nga máh ticuoi tớq coq tôt têq nha-án bôn tarcláh; alứng pau nga máh ticuoi sot dyôn têq cơt plang. Án khoiq yua cư choi máh ticuoi ndon ngai padớm dyôn nha-án bôn át ien ŏ. ");
INSERT INTO pac_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Alứng án yua cư tông te cumo ndon Ưlla ính tớq choi tamống ticuoi!” ");
INSERT INTO pac_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cua Yê-su dŏc máh parnai ngki, dyơ án catứp tám uráq alứng avôi lieh nga ticuoi táq arnáq tớq dúng rum ngki, dyơ án ticu. Cứp náq ticuoi tớq dúng rum me clớn nga án. ");
INSERT INTO pac_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Án tông nha-án idô: “Máh parnai inha sáng cư dŏc tớq tám uráq Yang Arbang-pilŏ́ng, lư cơt tarvớiq tớq ingái ndô.” ");
INSERT INTO pac_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dyơ máh ticuoi táq-ntêr ŏ te Yê-su, alứng nha-án sáng dut lư máh parnai án tông êm ŏ lư. Nha-án munáq plốh munáq idô: “Ticuoi ndô la acái conh Yô-sep, lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yê-su tông nha-án idô: “Dáh lơ inha ial parnai acám ính tông cư idô: ‘Ticuoi báq palai ơi! Áu mái palai cháq mái bôm.’ Alứng dáh lơ inha parngíh ính tông cư idô: ‘He khoiq sáng dyơ te máh arnáq sileh mái táq tớq vel Cabê-na-um. Ma hoi-ngki he seq mái táq muchứng ngki tưi tớq vel mái.’” ");
INSERT INTO pac_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yê-su tông loi idô: “Cư tông inha arlớih lư, máh ticuoi át mui vel alứng ticuoi tang ngcang Yang Arbang-pilŏ́ng, nha-án lớiq bôn dyám náp ticuoi tang ngcang ngki. ");
INSERT INTO pac_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Alứng cư tông inha arlớih lư idô, tớq pang Ê-li bôn a-ưi cán cammai tớq cruong Isa-ra-el, ndóng pilŏ́ng lớiq bôn bo nhéq pe cumo tupát kisái. Iki máh ticuoi tớq cruong ngki cơt pinhaih lư, ớq crơng tanna cha. ");
INSERT INTO pac_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma Yang Arbang-pilŏ́ng lớiq bôn yua Ê-li pôq nga cán cammai tớq cruong Isa-ra-el. Án yua Ê-li pôq nga mui náq cán cammai tớq vel Sarê-phat, tumán vel Sadôn. ");
INSERT INTO pac_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ê-li-sa la ticuoi tang ngcang Yang Arbang-pilŏ́ng tưi. Tớq pang án, bôn a-ưi náq ticuoi a-ái bŏ́q tớq cruong Isa-ra-el. Ma nha-án lớiq bôn cơt bánh; bôn nưm munáq ticuoi a-ái bŏ́q te cruong Si-ri sớng cơt bánh, nốh Naman.” ");
INSERT INTO pac_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tớq máh ticuoi tớq dúng rum sáng Yê-su tông iki, nha-án nháih lư ada Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nha-án yôr tayứng mui parrứh, dyơ nha-án ndŏ́h Yê-su te dúng rum, alứng dông án nga culái tieh vel. Vel nha-án át tớq cóh. Nha-án dông án nga acáng ính kitúh án te plô acáng ngki. ");
INSERT INTO pac_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma Yê-su pôq plian pandi ticuoi clứng, dyơ án loiq ngốh viang te top nha-án. ");
INSERT INTO pac_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Cua ngki Yê-su pôq nga vel Cabê-na-um, vúng Ca-lilê. Tớq Ingái Angô án cato máh ticuoi tớq vel ngki. ");
INSERT INTO pac_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Máh ticuoi ngki sáng dut lư te parnai án tông, co án tông arớq ticuoi bôn chức lư. ");
INSERT INTO pac_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tớq dúng rum ngki bôn munáq conh bôn yang saq piyúh. Án hiar yứng lư idô: ");
INSERT INTO pac_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Imo inha ính táq ada he, Yê-su te vel Na-saret? Inha tớq nga tudô ính cachet he lớiq? Cư acớl inha tớq te Yang Arbang-pilŏ́ng, alứng inha la án ndon práh ŏ lư.” ");
INSERT INTO pac_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yê-su dyŏq yang saq idô: “Êq tacang! Mái ngốh viang te cháq ticuoi ndô!” Yang saq padứm ticuoi ngki chứng mát nhéq máh ticuoi, dyơ án ngốh, ma án lớiq bôn táq bác chol amớh ticuoi ngki. ");
INSERT INTO pac_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Máh ticuoi ndon hôm arnáq ngki sáng dut lư, dyơ munáq plốh munáq idô: “Parnai amớh án tông ma laq lư? Ticuoi ndô bôn chức têq chuih angốh yang saq te cháq ticuoi, alứng yang saq peh án!” ");
INSERT INTO pac_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dyơ parnai nha-án táq-ntêr te Yê-su cơt rŏ́h mưt-mư cứp ntúq tớq máh vel ngki. ");
INSERT INTO pac_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yê-su ngốh te dúng rum, dyơ mot tớq dúng Si-môn. Cuya-cán Si-môn a-ái atóq cháq ớp lư. Dyơ nha-án seq Yê-su táq bánh cuya-cán Si-môn. ");
INSERT INTO pac_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yê-su tayứng tumán ayáq ngki alứng yua callong a-ái ngki ngốh. Dyơ ayáq ngki cơt bánh lieh; án rap yôr táq tanna dyôn tumoi cha. ");
INSERT INTO pac_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tớq pandang plot dyơ, ngai dông clứng ticuoi bôn a-ưi nốh a-ái tớq nga Yê-su. Án capơiq tớq cháq máh ticuoi a-ái, dyơ máh ticuoi a-ái ngki cơt bánh. ");
INSERT INTO pac_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Án chuih yang saq dyôn ngốh te máh cháq ticuoi hơ. Yang saq ngki hiar alứng tông idô: “Inha la Acái Yang Arbang-pilŏ́ng!” Yê-su dyŏq yang saq êq tacang, co yang saq chom dyơ án la Crit ndon Yang Arbang-pilŏ́ng rêh dŏq choi tamống ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ang iláih mbơiq sưm-turưm Yê-su ngốh te vel ngki. Dyơ án pôq nga ntúq aih. Bôn clứng ticuoi suo án; ndóng nha-án tumúh án, nha-án seq án êq ngốh te vel nha-án. ");
INSERT INTO pac_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma Yê-su tông nha-án idô: “Cư cóq pôq cato parnai ŏ te Yang Arbang-pilŏ́ng cơt sút dyôn vel cannŏ́h chom tưi. A-ám cư yua cư tớq nga tudô la co te arnáq ngki.” ");
INSERT INTO pac_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iki Yê-su cato tớq máh dúng rum chôp ntúq ticuoi Isa-ra-el át. ");
INSERT INTO pac_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bôn mui ingái Yê-su tayứng tumán tor dơq clóng Canê-saret. Bôn clứng ticuoi, munáq tarsón munáq, ính át tumán Yê-su, alứng ính cammáng án cato parnai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yê-su hôm bar lám tuoc tumán tor dơq. Ticuoi báq suo buaiq khoiq pachít tuoc ntúq ngki. Dyơ nha-án pieh mben. ");
INSERT INTO pac_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yê-su sớr tớq tuoc Si-môn, alứng án seq Si-môn dông angốh yông biq te tor. Án ticu tớq tuoc, dyơ án cato máh ticuoi ndon át tớq tor. ");
INSERT INTO pac_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cua án cato, án yua Si-môn idô: “Mái cor angốh tuoc mái nga ntúq dơq sru. Dyơ inha lai mben.” ");
INSERT INTO pac_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Si-môn ôi án idô: “Thới ơi! He khoiq táq nhéq idáu, ma lớiq bôn chuot amớh. Ma khán thới yua, ngki cư lư lai mben.” ");
INSERT INTO pac_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tư nha-án lai, buaiq chuot mben a-ưi lư; mben tumán ính tarhaq. ");
INSERT INTO pac_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nha-án cavoiq alứng tubau yớu te muoi lám tuoc loi dyôn tớq lôiq buaiq choi nha-án. Yớu ngki tớq choi, alứng nha-án cacháq buaiq pớnh tớq bar lám tuoc, táq dyôn tuoc tumán ính trim. ");
INSERT INTO pac_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tư Si-môn Phi-er hôm arnáq ngki, án chóh tarcol chứng mát Yê-su, alứng án tông idô: “Seq Ưlla tôi yông te cư, co cư la ticuoi luaih!” ");
INSERT INTO pac_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Si-môn alứng yớu án sáng dut lư, co bôn buaiq a-ưi. ");
INSERT INTO pac_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yacơ alứng Yon, acái conh Sê-badê, sáng dut tưi tớq nha-án hôm buaiq ngki. Nha-án ưlla munơi alứng Si-môn te arnáq suo buaiq. Yê-su tông Si-môn idô: “Êq adáh! Te ndô chô-mát, mái lư suo ticuoi arớq mái suo buaiq ndô.” ");
INSERT INTO pac_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dyơ nha-án pe náq lúq asớr tuoc tớq cóh. Nha-án táh nhéq cứp nốh, dyơ veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ndóng Yê-su át tớq mui vel, án tumúh conh a-ái bŏ́q ớp lư. Tư ticuoi ngki hôm Yê-su, án cucúh mpop tớq cuteq chứng mát Yê-su. Án seq te Yê-su idô: “Ưlla ơi! Khán Ưlla ính, Ưlla têq táq dyôn cư cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yê-su angốh ati capơiq tớq cháq án alứng tông idô: “Cư ính, dyôn mái cơt bánh!” Ndóng ngki táp án cơt bánh tháng te a-ái bŏ́q. ");
INSERT INTO pac_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yê-su patáp án idô: “Êq táq-ntêr dyôn ticuoi cannŏ́h chom te arnáq ndô. Ma cóq mái pôq apáh cháq mái dyôn ticuoi teng rit sang Yang Arbang-pilŏ́ng me. Alứng mái mŏp sang crơng dyôn Yang Arbang-pilŏ́ng arớq Môi-se khoiq patáp te nsuoi. Ndô la tíc dyôn ticuoi cannŏ́h chom mái khoiq cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma arnáq Yê-su táq dyôn ticuoi ngki cơt rŏ́h mưt-mư. Clứng ticuoi tớq cammáng parnai án tông, alứng nha-án seq án táq bánh máh nốh nha-án a-ái. ");
INSERT INTO pac_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma Yê-su báq ngốh te ntúq ticuoi át, dyơ pôq cớu nga ntúq anguaq labang. ");
INSERT INTO pac_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bôn mui ingái ndóng Yê-su chón cato, bôn máh ticuoi Pha-rasi alứng máh thới sái rit tớq ticu nga ntúq ngki tưi. Nha-án tớq te cứp vel tớq vúng Ca-lilê, vúng Yudê, alứng te vel pưt Yaru-salem. Yê-su bôn chức te Yang Arbang-pilŏ́ng dyôn án têq táq bánh máh ticuoi a-ái tớq ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bôn máh ticuoi conh crang munáq conh a-ái cớng tớq carrang. Nha-án ính mot tớq dúng ính dŏq án chứng mát Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma bôn clứng ticuoi át tớq dúng khoiq tot dyơ; iki nha-án lớiq chom na mmo ính mot. Dyơ nha-án crang asớr ticuoi a-ái tớq mpuong dúng. Nha-án pốh mpuong dúng alứng atiar carrang conh a-ái asiar pandi ticuoi clứng chứng mát Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tư Yê-su hôm nha-án lư tin, iki án tông ticuoi a-ái idô: “Yớu ơi! Luaih mái, cư táh dyôn!” ");
INSERT INTO pac_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Thới sái rit alứng ticuoi Pha-rasi parngíh tớq mít nha-án idô: “Ticuoi ndô la nnáu, ma án ính táq chức arớq Yang Arbang-pilŏ́ng tưi? Parnai án tông la arớq án acraiq Yang Arbang-pilŏ́ng. Co lớiq bôn ticuoi mmo têq táh luaih. Nưm Yang Arbang-pilŏ́ng táp têq táh luaih.” ");
INSERT INTO pac_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma Yê-su chom nha-án parngíh iki; dyơ án plốh nha-án idô: “Imo inha parngíh iki? ");
INSERT INTO pac_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Parnai mmo inha sáng ien hơn cư tông? Ien cư tông ticuoi a-ái cớng idô: ‘Luaih mái cư táh dyôn,’ lớiq la ‘Mái yôr tayứng, dyơ pôq.’ ");
INSERT INTO pac_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma hoi-ndô cư ính táq dyôn ticuoi a-ái ndô cơt bánh, dŏq inha chom arlớih lư, cư Acái Yang Cơt Ticuoi bôn chức tớq pang ndô alứng têq táh luaih dyôn ticuoi.” Cua ngki Yê-su tông ticuoi a-ái cớng idô: “Cư yua mái yôr tayứng! Ial dual carrang mái. Dyơ mái chô lieh nga dúng mái!” ");
INSERT INTO pac_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ndóng ngki táp ticuoi a-ái ngki yôr tayứng chứng mát máh ticuoi. Án ial dual carrang alứng án chô nga dúng, alứng án ayô Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nhéq máh ticuoi ngki sáng dut alứng adáh lư. Dyơ nha-án ayô Yang Arbang-pilŏ́ng alứng tông idô: “Ingái ndô he khoiq hôm arnáq sileh lư!” ");
INSERT INTO pac_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Vít ngki Yê-su ngốh te ntúq ngki. Ndóng án pôq tớq carna, án hôm munáq conh nốh Lê-vi, ticu tớq dúng ngai ial práq thêq, co án la ticuoi ial práq thêq. Yê-su yua án idô: “Mái veng cư!” ");
INSERT INTO pac_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lê-vi táh nhéq máh crơng án, dyơ án yôr tayứng alứng veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Cua ngki Lê-vi táq mui pêl pưt ráp Yê-su. Bôn clứng ticuoi, díh máh ticuoi ial práq thêq hơ tớq cha alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma máh ticuoi Pha-rasi alứng máh thới sái rit tíq top rian te Yê-su, idô: “Imo inha cha munơi alứng ticuoi ial práq thêq alứng máh ticuoi luaih?” ");
INSERT INTO pac_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yê-su ôi nha-án idô: “Ticuoi bánh ŏ lớiq bôn seq ngai palai. Ma nưm ticuoi a-ái sớng seq ngai palai. ");
INSERT INTO pac_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Cư lớiq bôn tớq nga tudô dŏq arô ticuoi ndon ngin nha-án tinớng ŏ, ma cư tớq nga tudô dŏq arô ticuoi ndon chom nha-án bôn luaih, dyôn têq nha-án ngin luaih pien cơt mít tamme loi.” ");
INSERT INTO pac_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Máh ticuoi Pha-rasi alứng thới sái rit tông Yê-su idô: “Máh top rian te Yon, a-ưi pêl nha-án ót tanna co ính parngíh te ngê Yang Arbang-pilŏ́ng alứng cớu. Máh ticuoi rian te top Pha-rasi la táq muchứng ngki tưi. Ma top rian te thới, ngki cha ngoiq níc.” ");
INSERT INTO pac_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yê-su ôi nha-án tớq parnai acám idô: “Khán bôn conh ial campái, ndóng yớu án pôq arsuoi alứng án, nha-án lớiq ót tanna co nha-án sáng bui. ");
INSERT INTO pac_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma tư ngai dông án nga cannŏ́h, iki yớu án ót tanna, dŏq ayư lieh án.” ");
INSERT INTO pac_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yê-su tông tớq parnai acám loi idô: “Lớiq bôn nnáu haq mui mêng prới te au tamme, dyơ dyih cupêl tớq au anhoh. Khán nha-án táq iki, au tamme cơt rúng, alứng campêl lớiq bôn tarmot alứng au anhoh. ");
INSERT INTO pac_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Alứng lớiq bôn nnáu cleng sieu tamme tớq aluoi ngcár khoiq tieq. Khán nha-án táq iki, sieu lư táq dyôn aluoi ngcár cơt pôih alứng pidŏ́h. Dyơ aluoi ngcár alứng sieu cơt pít nhéq. ");
INSERT INTO pac_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma sieu tamme cóq cleng tớq aluoi ngcár tamme. ");
INSERT INTO pac_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lư lớiq bôn nnáu ính ngoiq sieu tamme, khán án khoiq ngoiq sieu tieq dyơ, co án ính tông idô: ‘Sieu tieq iam hơn.’” ");
INSERT INTO pac_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tớq mui Ingái Angô, Yê-su alứng top rian te án pôq pha pidái sro bali. Top rian te Yê-su carớt sro bali alứng cutar, dyơ nha-án sréh cha. ");
INSERT INTO pac_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bôn ticuoi te top Pha-rasi plốh nha-án idô: “Imo inha táq lớiq cơt rit rong tớq Ingái Angô?” ");
INSERT INTO pac_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yê-su ôi nha-án idô: “Imo arớq inha lớiq nai dŏc tớq tám uráq Yang Arbang-pilŏ́ng tông te puo Davit khoiq táq, tớq án alứng top veng án sáng pinhaih? ");
INSERT INTO pac_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davit mot tớq dúng sang alứng án cha beng ngai mŏp sang Yang Arbang-pilŏ́ng. Ma veng rit ticuoi Isa-ra-el, án alứng yớu án lớiq têq cha beng ngki. Beng ngki nưm máh ticuoi teng rit sang Yang Arbang-pilŏ́ng sớng têq cha.” ");
INSERT INTO pac_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Alứng Yê-su tông loi idô: “Cư Acái Yang Cơt Ticuoi la Ưlla tưi Ingái Angô.” ");
INSERT INTO pac_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bôn mui Ingái Angô loi, Yê-su mot cato máh ticuoi tớq dúng rum. Át ngki bôn munáq dyuat ati pa atớm. ");
INSERT INTO pac_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Máh thới sái rit alứng máh ticuoi Pha-rasi suo ngê ính cauq Yê-su. Iki nha-án tituaiq me simớt lư nga Yê-su, ính chom án táq bánh ticuoi a-ái tớq Ingái Angô ma lớiq. ");
INSERT INTO pac_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Yê-su chom nha-án parngíh iki. Dyơ án tông ticuoi dyuat ati idô: “Mái yôr tayứng chứng mát máh ticuoi ndô.” Ticuoi ngki yôr tayứng táp. ");
INSERT INTO pac_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dyơ Yê-su tông máh ticuoi át paniar ngki idô: “Cư ính plốh inha: Veng rit he, ŏ he táq ŏ lớiq la táq saq tớq Ingái Angô? Ŏ he choi tamống, lớiq la cachet ticuoi?” ");
INSERT INTO pac_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Cua ngki Yê-su clang me nga máh ticuoi ngki, alứng án tông ticuoi dyuat idô: “Mái angốh ati!” Tư ticuoi ngki angốh, ati án cơt bánh. ");
INSERT INTO pac_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Iki máh ticuoi ngki sáng nháih táp, alứng nha-án tanghúng imo táp ính táq Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Vít ngki, Yê-su sớr tớq cóh ính cớu nga tuki. Án cớu seq te Yang Arbang-pilŏ́ng nhéq idáu. ");
INSERT INTO pac_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tớq ang iláih, án arô máh ticuoi rian te án, alứng án rêh mui chít la bar náq te top nha-án. Án dŏq mui chít la bar náq ndô la ticuoi dyưng ati án, ");
INSERT INTO pac_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nốh nha-án la idô: Si-môn ndon Yê-su anốh Phi-er hơ. Anrê a-em Si-môn. Yacơ, Yon, Phi-lip, Batê-lami, ");
INSERT INTO pac_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathie, Thô-mat, Yacơ acái conh Al-phê, Si-môn Sê-lôt, ");
INSERT INTO pac_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda acái conh Yacơ, alứng Yuda I-cari-ôt ndon culieu Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Vít ngki, Yê-su siar te cóh munơi alứng ticuoi clứng ndon rian te án. Nha-án tayứng tớq ntúq clúng, ma bôn clứng lư ticuoi tớq te vúng Yudê, te vel pưt Yaru-salem, alứng te tor dơq ving-cavang ndon tumán vel Tirơ nha vel Sadôn. ");
INSERT INTO pac_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nhéq máh ticuoi ngki tớq ính cammáng Yê-su cato, alứng ính án táq bánh máh nốh nha-án a-ái. Nha-án ndon bôn yang saq piyúh la cơt bánh tưi. ");
INSERT INTO pac_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nhéq máh ticuoi a-ái ngki suo ính capơiq Yê-su, co Yê-su bôn chức têq táq bánh te a-ái. ");
INSERT INTO pac_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yê-su me nga top rian te án alứng cato idô: “Bún lư inha ndon kidit, co Yang Arbang-pilŏ́ng cơt sút tớq mít cannính inha! ");
INSERT INTO pac_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bún lư inha ndon pinhaih hoi-ndô, co urớh inha cơt sái! Bún lư inha ndon nhiem hoi-ndô, co urớh inha bôn cacháng bui hơr loi! ");
INSERT INTO pac_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bún lư inha tớq ngai a-ính inha, calôih inha, pamat inha, alứng tông lớiq ŏ ada inha co tian inha veng ngê Acái Yang Cơt Ticuoi! ");
INSERT INTO pac_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ndóng nha-án táq iki, cóq inha sáng bui alứng ơn canchơl, co Yang Arbang-pilŏ́ng dyôn inha bôn cống pưt lư tớq pilŏ́ng. Achúc achiac nha-án táq muchứng ngki tưi ada máh ticuoi tang ngcang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma bap lư inha ndon súc hoi-ndô, co inha bôn nưm callong bún tớq pang ndô sớng! ");
INSERT INTO pac_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Alứng bap lư inha ndon cha sái hoi-ndô, co urớh Yang Arbang-pilŏ́ng dyôn inha cơt pinhaih! Alứng bap lư inha ndon cacháng bui hơr hoi-ndô, co urớh Yang Arbang-pilŏ́ng dyôn inha nhiem cucloiq! ");
INSERT INTO pac_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Bap lư inha tớq nhéq tưh ticuoi ayô níc inha. Te inớh, achúc achiac nha-án la táq muchứng ngki tưi ada ticuoi táq náh-nnan tang ngcang Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Cư tông inha ndon cammáng cư idô: Cóq inha amoih máh ticuoi picon inha. Cóq inha táq ŏ ada ticuoi a-ính inha. ");
INSERT INTO pac_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cóq inha cớu seq callong bún dyôn nha-án ndon chau inha. Alứng cóq inha cớu choi nha-án ndon táq saq ada inha. ");
INSERT INTO pac_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Khán ngai páh tabang inha mui pa, cóq inha pidáng dyôn ngai páh mui pa loi. Alứng khán ngai ial au thor culái tieh, ngki cóq inha luaiq díh au te pưn hơ dyôn nha-án. ");
INSERT INTO pac_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ticuoi mmo seq amớh te inha, inha dyôn án ngki. Alứng khán án ial crơng inha, inha êq seq lieh crơng ngki te án. ");
INSERT INTO pac_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amớh inha ính ticuoi cannŏ́h táq dyôn inha, cóq inha táq dyôn nha-án muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Khán inha amoih nưm ticuoi amoih inha, amớh loi Yang Arbang-pilŏ́ng ính dyôn inha bôn cống? Díh nha-án ndon lớiq veng ngê Yang Arbang-pilŏ́ng báq amoih ticuoi amoih nha-án. ");
INSERT INTO pac_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Alứng khán inha táq ŏ ada nha-án ndon táq ŏ ada inha, amớh Yang Arbang-pilŏ́ng ính dyôn inha bôn cống? Ticuoi lớiq veng ngê Yang Arbang-pilŏ́ng báq táq iki. ");
INSERT INTO pac_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Khán inha dyôn ticuoi cannŏ́h váq práq inha, ma inha ngcong bôn lieh práq te nha-án, amớh Yang Arbang-pilŏ́ng ính dyôn inha bôn cống? Ticuoi lớiq veng ngê Yang Arbang-pilŏ́ng, báq dyôn ticuoi cannŏ́h váq tưi práq nha-án, alứng nha-án ngcong bôn lieh práq ngki. ");
INSERT INTO pac_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma cóq inha amoih ticuoi picon inha. Cóq inha táq ŏ ada nha-án. Alứng cóq inha dyôn nha-án váq práq inha, ma inha êq ngcong bôn lieh práq ngki te nha-án. Iki, urớh inha lư bôn cống ŏ alứng bôn cơt acái acon Yang Arbang-pilŏ́ng, án ndon sút clưi nhéq te cannŏ́h. Co án táq ŏ ada ticuoi lới alứng ticuoi lớiq chom si-ơn. ");
INSERT INTO pac_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cóq inha sruiq táq ticuoi cannŏ́h muchứng A-ám inha tớq pilŏ́ng sruiq táq inha.” ");
INSERT INTO pac_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yê-su tông loi idô: “Inha êq tíq ticuoi cannŏ́h, iki Yang Arbang-pilŏ́ng lớiq tíq inha tưi. Alứng êq tông ticuoi cannŏ́h táq lớiq crái, iki Yang Arbang-pilŏ́ng lớiq tông inha táq lớiq crái tưi. Cóq inha táh luaih ticuoi cannŏ́h táq ada inha; iki Yang Arbang-pilŏ́ng lư táh luaih inha tưi. ");
INSERT INTO pac_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Khán inha dyôn crơng nga ticuoi cannŏ́h mui carie, Yang Arbang-pilŏ́ng lư culieh lieh inha clưi te ngki. Máh carie án dyôn inha, án avít, án chêh, alứng án cacháq pớnh bun. Co máh-mmo inha choi yớu, án lư choi lieh inha máh ngki tưi.” ");
INSERT INTO pac_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yê-su cato top ngki tớq parnai acám idô: “Ticuoi sot mát lớiq têq ayông ticuoi sot cannŏ́h. Khán án ayông, bar náq nha-án arbúc nhéq tớq prúng. ");
INSERT INTO pac_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Án ndon rian lớiq bôn pưt hơn te thới. Ma cứp náq ndon rian, tớq án rian dyơ, iki án cơt arớq thới tưi. ");
INSERT INTO pac_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Imo inha hôm sál tớq mát yớu, ma inha lớiq chom mêng pan catáng mát inha? ");
INSERT INTO pac_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Alứng imo inha dáh lư tông yớu idô: ‘Dyôn cư tuváih angốh sál te mát mái,’ ma inha lớiq chom mêng pan cadíl mát inha? Inha la ticuoi táq náh-nnan sớng! Cóq inha ial angốh mêng pan te mát inha avai. Ki-náq têq inha hôm arlớih, alứng têq ial sál te mát yớu.” ");
INSERT INTO pac_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Lớiq nai bôn tôm along ŏ cơt culái saq, alứng lớiq nai bôn tôm along saq cơt culái ŏ. ");
INSERT INTO pac_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Khán inha hôm culái, lư inha chom díh tôm. Lớiq nai bôn ngai cáiq culái tarúng te tôm tangháng carbớuq calang. Alứng lớiq nai bôn ngai cáiq culái nho te tôm tangháng tái. ");
INSERT INTO pac_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ticuoi partát ŏ bôn ngê ŏ tớq mít cannính án. Iki arnáq ŏ ngốh te mít án. Ma ticuoi lới, bôn ngê saq tớq mít cannính án. Iki arnáq saq ngốh te mít cannính án. Ngê amớh bôn tớq mít cannính ticuoi, ngcang ticuoi lư táq-ntêr ngê ngki.” ");
INSERT INTO pac_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Imo inha dŏq cư: ‘Ưlla! Ưlla!’ Ma inha lớiq peh máh parnai cư tông? ");
INSERT INTO pac_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ticuoi mmo tớq nga cư, dyơ cammáng alứng peh máh parnai cư, ticuoi ngki la arớq amớh? ");
INSERT INTO pac_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ticuoi ngki la arớq conh pitứng dúng. Án píq prúng dyôn sru, alứng cacháq búl tớq prúng táq dyôn tinol cơt khớm. Tư dơq pưt tớq, dơq clúh dúng, ma dúng ngki lớiq cacưt, co ticuoi táq dúng cacháq búl táq dyôn khớm lư. ");
INSERT INTO pac_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ticuoi ndon cammáng parnai cư ma lớiq peh, án la arớq conh pitứng dúng tớq cuteq mat. Án píq prúng tidưl, alứng lớiq cacháq búl tớq prúng. Tư dơq pưt tớq, dơq clúh dúng ngki hớp lư, dyơ dúng ngki dứm alứng arlóh nhéq.” ");
INSERT INTO pac_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cua Yê-su cato máh parnai ngki dyôn ticuoi clứng cammáng, án mot tớq vel Cabê-na-um. ");
INSERT INTO pac_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tớq vel ngki, bôn munáq ticuoi Rô-ma, cơt sút mui culám náq líng. Án bôn ticuoi sol ndon án amoih. Ma sol ngki a-ái ớp lư alứng tumán cuchet. ");
INSERT INTO pac_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tư sút líng ngki sáng ngai táq-ntêr te Yê-su, iki án yua máh ticuoi te top sút tớq sớu top Isa-ra-el pôq nga Yê-su alứng seq Yê-su tớq táq bánh ticuoi sol án. ");
INSERT INTO pac_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nha-án tớq nga Yê-su, alứng seq nhéq te tarngứh tarhơ idô: “Sút líng ngki la ticuoi partát. Iki he seq thới choi án. ");
INSERT INTO pac_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Án amoih lư ticuoi Isa-ra-el, alứng án táq dúng rum dyôn he hơ.” ");
INSERT INTO pac_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iki Yê-su pôq alứng nha-án. Ndóng Yê-su tumán ính tớq nga dúng, bôn sút líng ngki yua yớu án tớq nga Yê-su alứng tông idô: “Ưlla ơi, cư lớiq dáh pôq cớiq Ưlla dyôn mot tớq dúng cư. ");
INSERT INTO pac_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Alứng cư lớiq piaiq díh tớq nga Ưlla. Ma cư seq Ưlla tông dyôn sol cư cơt bánh, la piaiq dyơ. ");
INSERT INTO pac_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Co cư bôn tưi ticuoi ndon sút cư, alứng cư cơt sút ticuoi cannŏ́h tưi. Khán cư yua líng ndô: ‘Pôq!’, ngki án pôq. Khán cư yua líng ngki: ‘Tớq tudô!’, ngki án tớq. Khán cư yua ticuoi sol cư: ‘Táq ndô!’, ngki án táq.” ");
INSERT INTO pac_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ndóng Yê-su sáng parnai ngki, án sáng dut lư. Dyơ án tông ada máh ticuoi át paniar án idô: “Cư tông inha arlớih lư, cư lớiq nai hôm ngai te ticuoi Isa-ra-el tin arớq ticuoi ndô.” ");
INSERT INTO pac_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Máh ticuoi ndon ticuoi sút líng yua pôq nga Yê-su, nha-án chô nga dúng, alứng nha-án hôm sol ticuoi sút líng khoiq bánh. ");
INSERT INTO pac_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ingái tatun loi, Yê-su mot tớq vel Na-in. Top rian te án alứng clứng ticuoi cannŏ́h pôq alứng án. ");
INSERT INTO pac_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tư Yê-su tớq nga parngốh vel, piaiq ngai crang angốh ticuoi cuchet. A-i ticuoi cuchet la cán cammai; án bôn nưm mui lám acái conh ngki táp. Bôn clứng ticuoi te vel pôq munơi alứng án. ");
INSERT INTO pac_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tư Yê-su hôm cán cammai ngki, án sáng sruiq táq alứng tông idô: “Mái êq nhiem.” ");
INSERT INTO pac_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dyơ Yê-su tớq capơiq along cumuiq; máh ticuoi crang cumuiq ngki trín. Yê-su tông idô: “A-em ơi! Cư yua mái yôr!” ");
INSERT INTO pac_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ticuoi cuchet ngki yôr ticu, alứng mbơiq táq-ntêr lieh. Dyơ Yê-su mŏp án dyôn a-i án. ");
INSERT INTO pac_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nhéq máh ticuoi sáng adáh lư, alứng nha-án ayô Yang Arbang-pilŏ́ng idô: “Munáq tang ngcang Yang Arbang-pilŏ́ng ndon bôn chức pưt lư khoiq tớq pandi top he dyơ!” Alứng nha-án tông loi idô: “Yang Arbang-pilŏ́ng tớq choi tamống máh ticuoi ndon veng ngê án.” ");
INSERT INTO pac_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Te arnáq Yê-su khoiq táq cơt parhanh cứp ntúq tớq vúng Yudê alứng máh cruong tumán vúng ngki. ");
INSERT INTO pac_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Top rian te Yon tớq tông Yon te arnáq nha-án hôm Yê-su khoiq táq. Yon arô bar náq top rian te án, ");
INSERT INTO pac_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","alứng án yua nha-án pôq plốh Yê-su idô: “Thới ơi! Lư ma lớiq, thới la munáq ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi? Lớiq la cóq he ngcong ticuoi cannŏ́h loi?” ");
INSERT INTO pac_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tư bar náq ngki tớq nga Yê-su nha-án tông idô: “Yon báq táq tíc na dơq yua he tớq plốh thới idô: ‘Thới la munáq ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi lớiq? Lớiq la cóq he ngcong ticuoi cannŏ́h loi?’” ");
INSERT INTO pac_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ndóng nha-án yôl át tớq ngki, Yê-su táq bánh a-ưi nốh ticuoi a-ái, bôn díh ticuoi a-ái tarui alứng ticuoi bôn yang saq piyúh hơ. Alứng án táq dyôn máh ticuoi sot mát cơt plang. ");
INSERT INTO pac_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dyơ Yê-su ôi bar náq top rian te Yon idô: “Inha chô tông Yon te máh arnáq inha khoiq sáng alứng khoiq hôm. Ticuoi sot cơt plang. Ticuoi dyuat têq pupôq. Ticuoi a-ái bŏ́q cơt bánh. Ticuoi túng têq bôn sáng. Ticuoi khoiq cuchet yôr tumống lieh. Alứng máh ticuoi kidit bôn sáng tưi parnai ŏ te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bún lư ticuoi ndon lớiq táh ngê cư!” ");
INSERT INTO pac_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Vít top rian te Yon chô, Yê-su tông te Yon dyôn máh ticuoi clứng ngki cammáng. Alứng án plốh nha-án idô: “Ndóng inha pôq tumúh Yon tớq ntúq aih, amớh inha ính hôm tớq ntúq ngki? Inha ính hôm cuyiel phớt sác pitứng pitốq lớiq? ");
INSERT INTO pac_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Khán lớiq iki, amớh inha ính hôm? Inha ính hôm munáq ndon sứp au dêu ŏ lớiq? Ticuoi ndon sứp au dêu alứng tớc cha thưong, ngki át tớq dúng puo. ");
INSERT INTO pac_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma amớh inha ính hôm tớq ntúq ngki? Inha ính hôm ticuoi tang ngcang Yang Arbang-pilŏ́ng lớiq? Cư tông inha arlớih lư, Yon la ticuoi tang ngcang tưi, ma án bôn chức pưt hơn te ticuoi tang ngcang cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tớq tám uráq te inớh, ticuoi tang ngcang khoiq taran acớiq te Yon idô: ‘Cư Yang Arbang-pilŏ́ng yua tampeng cư tớq nsuoi mái, dŏq thuan carna dyôn mái pôq.’ ");
INSERT INTO pac_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cư tông inha, cứp náq ticuoi ndon cán carnian tớq cúc cuteq ndô, lớiq bôn nnáu pưt hơn te Yon ndon báq táq tíc na dơq. Ma cư tông inha idô tưi: Ticuoi mmo lớiq bôn pưt amớh tớq top Yang Arbang-pilŏ́ng sút, lư Yang Arbang-pilŏ́ng dyôn ticuoi ngki bôn chức pưt hơn te chức Yon.” ");
INSERT INTO pac_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Máh ticuoi ndon bôn sáng te parnai Yon tông, díh nha-án ndon ial práq thêq, nhéq náq nha-án ngin Yang Arbang-pilŏ́ng la tinớng ŏ. Iki nha-án seq Yon táq tíc na dơq dyôn nha-án. ");
INSERT INTO pac_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma máh ticuoi Pha-rasi alứng máh thới sái rit lớiq ính náp alứng lớiq ính veng ngê Yang Arbang-pilŏ́ng. Iki nha-án lớiq dyôn Yon táq tíc na dơq dyôn nha-án. ");
INSERT INTO pac_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yê-su tông loi: “Máh ticuoi tớq pang ndô la arớq amớh? ");
INSERT INTO pac_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Máh ticuoi tớq pang ndô la arớq ngai-acái át parlơ tớq ngcưm. Bôn mui top ngai-acái arô yớu nha-án idô: ‘He khoiq plŏ́ng tirel alứng parlơ aryoc. Ma inha lớiq mot ayưn alứng he! Alứng he parlơ táq arpưp, ma inha lớiq bôn sŏ́ng mot nhiem cucloiq alứng he!’ ");
INSERT INTO pac_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yon ndon táq tíc na dơq tớq nga ndô, lớiq ngoiq cha arớq ticuoi cannŏ́h; ma án cha nưm aliem alứng ngoiq nưm dơq canyiel. Dyơ inha tông án bôn yang saq át. ");
INSERT INTO pac_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma cư Acái Yang Cơt Ticuoi, cư tớq ngoiq cha muchứng ticuoi cannŏ́h tưi. Iki inha tông te cư idô: ‘Ngki! Án ngoiq cha tham lư! Díh án cơt yớu alứng ticuoi ial práq thêq nha ticuoi luaih cannŏ́h!’ ");
INSERT INTO pac_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma ticuoi ndon lư tubáiq, urớh ngai ngin án la lư ticuoi tubáiq, co ngai hôm te máh arnáq án táq.” ");
INSERT INTO pac_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bôn munáq te top Pha-rasi mơi Yê-su tớq cha mui pêl nga dúng án. Dyơ Yê-su pôq cha. ");
INSERT INTO pac_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tớq vel ngki, bôn munáq cán ndon táq a-ưi arnáq saq. Án khoiq sáng ngai táq-ntêr te Yê-su tớq chicha nga dúng ticuoi Pha-rasi; dyơ án dông mui be dơq thum. Be ngki ngai táq tớq búl, nốh a-labat. ");
INSERT INTO pac_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Án tayứng pa crŏ́ng tumán dyưng Yê-su. Án nhiem alứng tandyŏ́h dơq mát dyứp nhéq dyưng Yê-su. Dyơ án chut dyưng Yê-su tớq sóc án. Án honh hit dyưng Yê-su, dyơ án tốq dơq thum tớq dyưng Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tư ticuoi Pha-rasi ndon mơi Yê-su hôm iki, án parngíh tớq mít án idô: “Khán ticuoi ndô lư munáq tang ngcang Yang Arbang-pilŏ́ng, ngki án chom cán ndon capơiq án la nnáu. Alứng án chom cán ndô táq a-ưi arnáq saq.” ");
INSERT INTO pac_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yê-su tông ticuoi ngki idô: “Si-môn ơi! Cư bôn mui parnai ính tông mái.” Si-môn ôi: “Ơq thới. Seq thới tông.” ");
INSERT INTO pac_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dyơ Yê-su tông án idô: “Bôn bar náq váq práq te ticuoi parai práq. Munáq tu sông culám. Munáq loi tu sông chít. ");
INSERT INTO pac_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma bar náq ngki lớiq bôn amớh ính culieh tu án ndon parai práq. Iki án ndon parai práq táh nhéq máh práq nha-án tu án. Ma te bar náq ngki, nnáu amoih hơn án ndon parai práq?” ");
INSERT INTO pac_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Si-môn ôi: “Cư parngíh, án ndon tu a-ưi ngki amoih hơn.” Yê-su tông idô: “Lư crái mái tông.” ");
INSERT INTO pac_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dyơ Yê-su me nga cán ngki alứng tông Si-môn idô: “Mái hôm lớiq cán ndô? Án arau dyưng cư tớq dơq mát án. Alứng án ial sóc án táp chut dyưng cư. Ma tư cư tớq nga dúng mái, mái lớiq bôn ial dơq dyôn cư arau dyưng. ");
INSERT INTO pac_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Alứng mái lớiq bôn honh hit cư veng rit alang tumoi. Ma cán ndô honh hit níc dyưng cư, te ndóng cư mot tớq dúng tingôi hoi-ndô. ");
INSERT INTO pac_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mái lớiq bôn ial dơq nseng tir tớq plô cư veng rit alang tumoi. Ma cán ndô tốq dơq thum dát lư tớq dyưng cư. ");
INSERT INTO pac_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iki cư tông mái: Cán ndô lư bôn luaih a-ưi, ma cư khoiq táh dyôn án, co án amoih lư cư. Ticuoi mmo ma parngíh án bôn biq sớng luaih dyôn cư táh, ticuoi ngki amoih cư biq tưi.” ");
INSERT INTO pac_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dyơ Yê-su tông cán ngki idô: “Luaih mái, cư khoiq táh dyơ.” ");
INSERT INTO pac_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Máh ticuoi ndon át cha alứng Yê-su, nha-án parngíh idô: “Ticuoi ndô la nnáu, ma án dáh tông án táh luaih dyôn ticuoi?” ");
INSERT INTO pac_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dyơ Yê-su tông sa cán ngki idô: “Yang Arbang-pilŏ́ng khoiq choi tamống mái, co mái tin lư cư. Mái pôq bánh suanh ien ŏ.” ");
INSERT INTO pac_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Vít ngki, Yê-su mot tớq a-ưi vel két vel pưt alứng cato parnai ŏ te Yang Arbang-pilŏ́ng cơt sút. Top mui chít la bar náq rian te án pôq munơi alứng án. ");
INSERT INTO pac_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Alứng bôn máh cán hơ pôq alứng Yê-su. Te máh cán ngki bôn cán ndon yang saq piyúh, ma Yê-su khoiq chuih angốh, alứng bôn cán ndon Yê-su táq bánh te a-ưi nốh a-ái. Nốh máh cán ngki la idô: Mui la Mari te vel Mac-dala, án ndon bôn tupul lám yang saq khoiq ngốh te cháq án. ");
INSERT INTO pac_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Bar la Yô-ana, campái Chusa. Chusa táq arnáq dyôn puo Hê-rôt An-tipa. Pe la Su-sana. Alứng bôn a-ưi cán cannŏ́h hơ. Nhéq nha-án ial práq nha-án bôm dŏq choi Yê-su alứng top rian te Yê-su dyôn bôn crơng tanna cha. ");
INSERT INTO pac_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Clứng lư ticuoi te a-ưi vel tớq nga Yê-su. Dyơ Yê-su cato nha-án tớq parnai acám idô: ");
INSERT INTO pac_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Bôn munáq ticuoi pôq trứh callong. Ndóng án trứh, bôn callong atôh tớq carna. Ticuoi dếq callong ngki, alứng bôn achếq tớq tŏ́h cha. ");
INSERT INTO pac_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bôn callong cannŏ́h atôh tớq cuteq a-ưi búl. Tư callong ngki hŏn, án cơt ráng nhéq, co ớq dơq. ");
INSERT INTO pac_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bôn callong cannŏ́h atôh tớq cuteq bôn riaih sác tangháng. Tư sác tangháng dáh, án cluom nhéq bát mbơiq dáh. ");
INSERT INTO pac_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Alứng bôn callong cannŏ́h loi atôh tớq cuteq ŏ. Callong ngki dáh alứng pưt asớr, dyơ cơt culái. Mui tôm bôn mui culám callong.” Yê-su tông loi idô: “Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng.” ");
INSERT INTO pac_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Top rian te Yê-su plốh án te parnai ndô la acám te amớh. ");
INSERT INTO pac_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yê-su ôi nha-án idô: “Máh parnai catốq te Yang Arbang-pilŏ́ng cơt sút, Yang Arbang-pilŏ́ng dyôn inha chom. Ma ticuoi cannŏ́h cammáng nưm parnai acám sớng. Iki nha-án me, ma lớiq bôn hôm; nha-án cammáng, ma lớiq apúh.” ");
INSERT INTO pac_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ngê te parnai acám ngki la idô: Callong ndon ticuoi trứh la acám te ticuoi pôq cato parnai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma callong atôh tớq carna la acám te ticuoi ndon cammáng parnai Yang Arbang-pilŏ́ng, ma yang Satán tớq ial viang parnai ngki te mít cannính nha-án, táq dyôn nha-án lớiq têq tin. Dyơ Yang Arbang-pilŏ́ng lớiq têq choi tamống nha-án. ");
INSERT INTO pac_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Callong atôh tớq cuteq bôn búl, la acám te ticuoi ndon cammáng alứng tin parnai Yang Arbang-pilŏ́ng na êm ŏ lư. Ma parnai ngki lớiq bôn mot tớq mít cannính nha-án. Nha-án tin muhoi sớng; tớq nha-án tumúh dieiq arức, nha-án buq co tian nha-án tin, dyơ nha-án lớiq ính tin nnáng. ");
INSERT INTO pac_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Callong ndon atôh tớq cuteq bôn a-ưi sác tangháng la acám te ticuoi ndon cammáng parnai ŏ ngki, ma nha-án lo khít tớq pang ndô, ham súc alứng ham thưong. Máh nốh ngki cluom nhéq parnai ŏ ngki, dyơ táq dyôn nha-án lớiq cơt culái. ");
INSERT INTO pac_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma callong atôh tớq cuteq ŏ, la acám te ticuoi ndon cammáng parnai ŏ ngki, alứng nha-án bôn mít cannính ŏ, ính dyám náp Yang Arbang-pilŏ́ng. Nha-án cadyom dŏq níc parnai ngki, dyơ tớq ngư bôn culái, nha-án cơt culái a-ưi lư.” ");
INSERT INTO pac_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Lớiq bôn ngai bet den tớu, dyơ catứp tớq yáng, lớiq la dŏq tadưp kichơng bíq. Ma lư ngai dŏq den tớu tớq mong, dyôn ang claq chôp callúng. Iki ticuoi mot tớq callúng ngki têq hôm arlớih. ");
INSERT INTO pac_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Muchứng ngki tưi, nốh amớh cư catốq hoi-ndô, chô-mát cư dyôn nhéq tưh ticuoi chom arlớih lư máh nốh ngki. Alứng nốh amớh cư catáng hoi-ndô, chô-mát cư lớiq catáng nnáng. ");
INSERT INTO pac_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Parnai amớh inha sáng cư cato, cóq inha ayáu parnai ngki. Ticuoi mmo khoiq bôn dyơ, cư dyôn án bôn a-ưi lư loi. Ma ticuoi mmo ớq, cư lư ial lieh nhéq máh callong án parngíh án bôn.” ");
INSERT INTO pac_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A-i alứng a-em conh Yê-su tớq ính tumúh Yê-su, ma nha-án lớiq têq mot nga án, co tot máh ticuoi tớq dúng. ");
INSERT INTO pac_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bôn ticuoi tớq tông Yê-su idô: “A-i alứng a-em conh thới át culái tieh ính tumúh thới.” ");
INSERT INTO pac_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma Yê-su tông nha-án idô: “A-i alứng em ai cư la máh ticuoi ndon cammáng alứng peh parnai Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bôn mui ingái, Yê-su sớr tớq tuoc alứng top rian te án. Dyơ án tông nha-án idô: “He dyang pa dyáng atóh dơq clóng ndô.” Dyơ nha-án tabớq dyang. ");
INSERT INTO pac_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tớq pandi dơq, Yê-su bíq. Ma ndóng ngki bôn cuyiel arpuq hớp lư, táq dyôn dơq carsaiq amot tớq tuoc tingôi ính pớnh. Dyơ top rian te Yê-su sáng crŏ́q lư, co tuoc tumán ính trim. ");
INSERT INTO pac_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iki nha-án tớq pasớt Yê-su alứng tông idô: “Thới ơi, thới ơi! He tumán ính cuchet.” Yê-su yôr tayứng. Án dyŏq cuyiel alứng dơq lampóh. Dyơ cuyiel alứng dơq ngki tangít, alứng cơt ien ŏ lieh. ");
INSERT INTO pac_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yê-su plốh top rian te án idô: “Tumo callong tin inha?” Ma nha-án sáng dut alứng adáh lư. Munáq plốh munáq idô: “Ticuoi ndô la nnáu? Án dyŏq cuyiel alứng dơq, dyơ cuyiel alứng dơq peh án!” ");
INSERT INTO pac_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nha-án dyang pa dyáng atóh dơq clóng tớq nga cruong Yê-rasê. Cruong ndô át chứng vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ndóng Yê-su siar te tuoc, bôn munáq conh te cruong ngki bôn yang saq piyúh, án tớq nga Yê-su. Án át khakhốl-khốl khoiq dưnh dyơ. Án lớiq bôn át tớq dúng, ma án át níc tớq carlom cumuiq. ");
INSERT INTO pac_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tư án hôm Yê-su, án hiar yứng lư, án chóh tarcol alứng tông yứng lư idô: “Amớh inha ính táq ada he, Yê-su? Inha la Acái Yang Arbang-pilŏ́ng, án ndon sút clưi nhéq te cannŏ́h. He seq inha êq táq he toiq bap.” ");
INSERT INTO pac_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yang saq tông iki, co Yê-su khoiq yua yang saq ngốh te cháq ticuoi ngki. A-ưi chư yang saq táq án. Alứng khán ticuoi cannŏ́h cŏp alứng tacáp án tớq sic, lớiq la clieng tớq panuar, án táq ti-ŏ́h nhéq. Alứng yang saq báq dông án pôq nga ntúq aih. ");
INSERT INTO pac_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yê-su plốh ticuoi ngki idô: “Amớh nốh mái?” Án ôi: “Nốh he la Pớl.” Án tông iki, co bôn a-ưi lư yang saq át tớq cháq án. ");
INSERT INTO pac_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Máh yang saq ngki seq Yê-su êq yua nha-án pôq nga ntúq bôn uih chéh níc-níc. ");
INSERT INTO pac_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tớq cóh ngki bôn mui cantóh alic chón suo cha. Iki, máh yang saq ngki seq te Yê-su dyôn nha-án mot tớq cantóh alic. Yê-su dyôn nha-án mot. ");
INSERT INTO pac_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iki nha-án ngốh te cháq ticuoi, dyơ mot tớq cantóh alic loi. Cantóh alic ngki lúh chái lư na acáng alứng páh-apŏ́ng nga clóng dơq, dyơ tumic cuchet nhéq. ");
INSERT INTO pac_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tớq ticuoi bán máh alic hôm cơt arnáq iki, nha-án talúh chô tông máh ticuoi tớq vel alứng tớq panu pidái chom. ");
INSERT INTO pac_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Clứng ticuoi tớq ính me arnáq ndon mbơiq cơt. Nha-án tớq nga Yê-su, alứng nha-án hôm ticuoi ndon bôn yang saq piyúh te nsuoi ticu tumán dyưng Yê-su. Án tớc tampớc alứng lớiq bôn yúh nnáng. Iki nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Máh ticuoi ndon hôm arnáq Yê-su táq dyôn ticuoi bôn yang saq piyúh, nha-án táq-ntêr dyôn ticuoi ndon lớiq hôm bôn chom tưi te arnáq Yê-su khoiq táq dyôn ticuoi ngki cơt bánh. ");
INSERT INTO pac_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nhéq máh ticuoi tớq cruong Yê-rasê seq Yê-su pôq viang te cruong nha-án, co nha-án sáng adáh lư. Dyơ Yê-su sớr tớq tuoc alứng ngốh te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ticuoi ndon yang saq khoiq ngốh te cháq, án seq pôq alứng Yê-su tưi. Ma Yê-su yua án chô, alứng patáp án idô: ");
INSERT INTO pac_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mái chô nga dúng mái. Dyơ mái táq-ntêr te cứp arnáq Yang Arbang-pilŏ́ng khoiq choi mái.” Iki ticuoi ngki pôq cứp ntúq tớq vel án, alứng án táq-ntêr lieh te cứp arnáq Yang Arbang-pilŏ́ng khoiq choi án. ");
INSERT INTO pac_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tư Yê-su dyang lieh pa dyáng atóh dơq clóng ngki, bôn clứng ticuoi pasôl án bui ŏ, co nha-án át pớn án tớq ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma bôn munáq conh, nốh Yaru, tớq nga ngki tưi. Án la ticuoi sút mui dúng rum ticuoi Isa-ra-el tớq vel ngki. Án chóh tarcol alứng mpop tumán dyưng Yê-su. Án seq Yê-su tớq nga dúng án, co acái cán án a-ái ớp lư. ");
INSERT INTO pac_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Án bôn nưm mui lám ngki táp acái. Acái án mbơiq mui chít la bar cumo, ma a-ái tumán ính cuchet. Ndóng Yê-su pôq na carna, bôn clứng lư ticuoi tarsón án. ");
INSERT INTO pac_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Alứng bôn munáq cán át ntúq ngki bôn a-ái dyứp nnai khoiq mui chít la bar cumo dyơ, aham án ngốh lớiq nai dyớt. Tien práq án arlóh nhéq co dyôn ngai palai, ma lớiq bôn bánh. ");
INSERT INTO pac_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Án plian amot pa crŏ́ng Yê-su, dyơ án capơiq mbaiq au thor Yê-su. Ndóng ngki táp aham án dyớt. ");
INSERT INTO pac_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yê-su plốh idô: “Nnáu capơiq cư?” Ma lớiq bôn nnáu ngin. Dyơ Phi-er tông idô: “Thới ơi! Clứng lư ticuoi át tumán thới, alứng nha-án tarsón thới.” ");
INSERT INTO pac_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma Yê-su tông lieh idô: “Bôn ticuoi capơiq cư, co cư sáng chức cư ngốh te cháq cư.” ");
INSERT INTO pac_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tư cán ndon capơiq au Yê-su chom lớiq têq catốq nnáng, iki cháq án dyandyír alứng án mpop tumán dyưng Yê-su. Án ngin ada Yê-su chứng mát máh ticuoi clứng. Án tông dyôn Yê-su chom co imo án tớq capơiq au Yê-su, alứng án cơt bánh tháng. ");
INSERT INTO pac_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yê-su ôi án idô: “Mun ơi! Co mái tin, cháq mái cơt bánh. Mái chô ien ŏ.” ");
INSERT INTO pac_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ndóng Yê-su yôl táq-ntêr alứng cán ngki, bôn munáq ticuoi te dúng Yaru ndon sút dúng rum tớq nga Yaru, alứng tông án idô: “Acái cán mái khoiq cuchet dyơ. Mái êq pidieiq nnáng thới.” ");
INSERT INTO pac_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yê-su sáng ticuoi ngki tông iki, dyơ án tông Yaru idô: “Êq adáh! Mái tin sớng. Cumáiq acái mái lư cơt bánh lieh.” ");
INSERT INTO pac_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tư Yê-su tớq nga dúng Yaru, án dyôn Phi-er, Yacơ, Yon, alứng a-i a-ám mun ngki sớng mot tớq dúng alứng án. Ma ticuoi cannŏ́h, án lớiq dyôn mot. ");
INSERT INTO pac_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nhéq máh ticuoi nhiem atíh mun ndon khoiq cuchet. Ma Yê-su tông idô: “Êq nhiem! Án lớiq bôn cuchet, án bíq sớng.” ");
INSERT INTO pac_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nha-án ndon sáng Yê-su tông iki, nha-án ayê tar-ac Yê-su, co nha-án chom arlớih mun ngki khoiq cuchet dyơ. ");
INSERT INTO pac_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma Yê-su tec ati mun ndon khoiq cuchet, alứng án arô idô: “Mun ơi! Mái yôr tayứng!” ");
INSERT INTO pac_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iki arvai mun ngki chô lieh nga án, alứng án yôr táp. Dyơ Yê-su yua nha-án dyôn mun ngki cha tanna. ");
INSERT INTO pac_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A-i a-ám mun ngki sáng dut lư, ma Yê-su patáp nha-án êq táq-ntêr dyôn ticuoi cannŏ́h chom te arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yê-su arô top mui chít la bar náq rian te án, dyôn tớq nga án. Án dyôn nha-án bôn chức têq chuih angốh yang saq piyúh ticuoi, alứng têq táq bánh máh ticuoi a-ái. ");
INSERT INTO pac_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dyơ án yua nha-án pôq cato te Yang Arbang-pilŏ́ng cơt sút, alứng án yua nha-án táq bánh máh ticuoi a-ái. ");
INSERT INTO pac_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Alứng án patáp nha-án idô: “Inha êq dông crơng amớh. Êq dông tarlông. Êq báq tui. Êq dông tanna. Êq dông práq. Alứng êq dông bar pláh au. ");
INSERT INTO pac_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tư inha mot tớq vel, cóq inha át mui dúng sớng tingôi inha ngốh te vel ngki. ");
INSERT INTO pac_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Khán inha mot tớq vel mmo, ma ngai lớiq ráp pasôl ŏ inha, tớq inha ngốh te vel ngki, cóq inha tangkhír cuteq mbúi te dyưng. Ndô la táq tíc ticuoi tớq vel ngki lớiq ráp pasôl inha.” ");
INSERT INTO pac_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iki nha-án pôq nga vel két vel pưt alứng cato parnai ŏ te Yang Arbang-pilŏ́ng. Nha-án táq bánh máh ticuoi a-ái. ");
INSERT INTO pac_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hê-rôt An-tipa ndon sút tớq vúng Ca-lilê, sáng te máh arnáq Yê-su táq. Iki án tambang parngíh, co án sáng ngai táq-ntêr te Yon táq tíc na dơq khoiq tumống lieh te cuchet. ");
INSERT INTO pac_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bôn ticuoi tông, Ê-li khoiq tớq lieh dyơ. Alứng bôn ticuoi tông, bôn munáq tang ngcang Yang Arbang-pilŏ́ng khoiq tumống lieh te cuchet. ");
INSERT INTO pac_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma Hê-rôt tông idô: “Cư khoiq cŏ́h ticong Yon, ma ticuoi ndô la nnáu, án ndon cư sáng ngai táq-ntêr te arnáq án táq?” Iki Hê-rôt suo ính tumúh Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Máh ticuoi dyưng ati Yê-su chô lieh alứng tông án te máh arnáq nha-án khoiq táq. Án dông nha-án pôq alứng án nga mui ntúq tumán vel Bet-sada. Ntúq ngki lớiq bôn ngai át. ");
INSERT INTO pac_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tư máh ticuoi chom Yê-su pôq nga ntúq ngki, iki clứng lư nha-án veng án. Án pasôl alứng cato nha-án te Yang Arbang-pilŏ́ng cơt sút. Alứng án táq bánh ticuoi ndon a-ái. ");
INSERT INTO pac_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tumán mát pandang tangcưl cóh, top rian te Yê-su tớq nga án alứng tông idô: “Seq thới yua ticuoi clứng ndô chô nga vel két vel pưt tumán ndô, dyôn nha-án suo ntúq át alứng plới bôm tanna cha, co ntúq ndô yông te ntúq ticuoi át.” ");
INSERT INTO pac_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ma Yê-su tông nha-án idô: “Inha táp dyôn nha-án bôn crơng tanna cha.” Nha-án tông idô: “He bôn nưm sông lám beng, alứng bar lám buaiq. Thới ính he pôq plới tanna dyôn máh ticuoi ndô cha lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bôn conh sasai sám sông ngin náq át tớq ntúq ngki. Dyơ Yê-su tông top rian te án idô: “Inha yua nha-án ticu, mui ntúq sám sông chít náq.” ");
INSERT INTO pac_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dyơ top rian te Yê-su yua ticuoi clứng ngki ticu. ");
INSERT INTO pac_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yê-su ial sông lám beng alứng bar lám buaiq ngki. Dyơ án tingưi asớr nga pilŏ́ng, alứng si-ơn Yang Arbang-pilŏ́ng bôn crơng tanna ndô. Cua ngki án péq beng alứng mŏp dyôn top rian te án mpô dyôn máh ticuoi cha. ");
INSERT INTO pac_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Máh ticuoi ngki cha sái nhéq. Cua nha-án cha, top rian te Yê-su pachúng lieh máh ntie, bôn mui chít la bar carie. ");
INSERT INTO pac_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bôn mui ingái ndóng Yê-su chón cớu munáq án, ma top rian te án tớq nga án. Dyơ án plốh nha-án idô: “Máh ticuoi clứng ngki tông cư la nnáu?” ");
INSERT INTO pac_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nha-án ôi idô: “Bôn ticuoi tông thới la Yon ndon báq táq tíc na dơq. Bôn ticuoi tông thới la Ê-li. Alứng bôn ticuoi cannŏ́h loi tông thới la ticuoi tang ngcang Yang Arbang-pilŏ́ng ndon tumống lieh te cuchet.” ");
INSERT INTO pac_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yê-su plốh sa nha-án idô: “Ma inha tông cư la nnáu?” Phi-er ôi idô: “Thới la Crit, án ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi!” ");
INSERT INTO pac_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yê-su patáp nha-án êq táq-ntêr dyôn ticuoi cannŏ́h chom te callong ndô. ");
INSERT INTO pac_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Alứng án tông loi idô: “Chô-mát, cư Acái Yang Cơt Ticuoi, cóq chiuq a-ưi nốh dieiq arức. Máh ticuoi sút tớq sớu, máh top teng rit sang Yang Arbang-pilŏ́ng, alứng máh thới sái rit, a-ính cư alứng cachet cư. Ma catám ingái pe, cư yôr tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cua ngki, Yê-su tông nha-án idô: “Khán bôn ticuoi mmo ính veng tapun cư, cóq án táh viang ngê án bôm. Cứp ingái án cóq ial dual bôm along calláng án, alứng cóq án veng tapun cư. ");
INSERT INTO pac_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ticuoi mmo ayáu tarngứh án, tarngứh ticuoi ngki lư pít. Ma ticuoi mmo chiuq pít tarngứh án co tian án veng ngê cư, tarngứh ticuoi ngki lư lớiq nai pít. ");
INSERT INTO pac_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Khán ticuoi mmo bôn túc palec crơng crớu tớq pang ndô, ma án táh lớiq la pít tarngứh, ngki bôn tarnáp amớh dyôn án? ");
INSERT INTO pac_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Khán ticuoi mmo achiet te cư alứng te parnai cư chứng mát máh ticuoi tớq pang ndô, urớh cư Acái Yang Cơt Ticuoi la achiet tưi ticuoi ngki tớq ingái cư tớq lieh nga cúc cuteq ndô. Ingái ngki cư tớq munơi alứng máh tarneng Yang Arbang-pilŏ́ng, alứng cư bôn chức ang-ưr te A-ám cư. ");
INSERT INTO pac_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cư tông inha arlớih lư, bôn máh ticuoi át tayứng tớq ntúq ndô hoi-ngki, nha-án lớiq cuchet tingôi nha-án bôn hôm Yang Arbang-pilŏ́ng cơt sút.” ");
INSERT INTO pac_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Vít Yê-su tông máh parnai ngki sám bôn ticol ingái loi, án dông Phi-er, Yon, nha Yacơ sớr alứng án nga cóh, co ính cớu tớq ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ndóng Yê-su cớu, án palít cơt rớp ndái loi, alứng tampớc án clŏq tarbal mát. ");
INSERT INTO pac_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bôn bar náq tớq táq-ntêr alứng án, la Môi-se alứng Ê-li. ");
INSERT INTO pac_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Rớp nha-án ang-ưr, alứng nha-án táq-ntêr te arnáq Yê-su táq dyôn cua tớq án chiuq cuchet tớq vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma Phi-er alứng yớu án sáng ính bíq. Tư nha-án ayư, nha-án hôm rớp Yê-su ang-ưr, alứng bôn bar náq ticuoi tayứng munơi alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tư vít bar náq ngki pôq te Yê-su; Phi-er tông Yê-su idô: “Thới ơi! He át ndô la ŏ lư. He ính táq pe lám panu, mui lám dyôn thới, mui lám dyôn Môi-se, alứng mui lám loi dyôn Ê-li.” Ma Phi-er suo táq-ntêr lớiq cơt callong. ");
INSERT INTO pac_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ndóng Phi-er yôl táq-ntêr iki, bôn tulúc cadứp nha-án. Iki nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Alứng bôn sieng tubau tông te tulúc idô: “Ndô la Acái cư, án ndon cư khoiq rêh. Amớh án tông, cóq inha cammáng alứng peh án!” ");
INSERT INTO pac_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tư arngiac sieng ngki, nha-án hôm nưm Yê-su sớng át tớq ntúq ngki. Iki nha-án lớiq bôn táq-ntêr dyôn ticuoi cannŏ́h chom te arnáq nha-án khoiq hôm, tingôi ingái Yê-su cuchet alứng tumống lieh. ");
INSERT INTO pac_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Máh ingái parnô loi, tớq nha-án siar te cóh, bôn clứng lư ticuoi tớq tumúh Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bôn munáq te ticuoi clứng ngki tubau yứng lư idô: “Thới ơi! Cư seq thới choi acái conh cư. Cư bôn nưm mui lám án táp. ");
INSERT INTO pac_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ma bôn yang saq báq piyúh án. Án báq hiar tớq yang saq nhác án, dyơ ngốh apôh te ngcang. Yang ngki carnhác-carnhál alứng táq tum nhéq cháq án, ma lớiq nai ngốh te cháq án! ");
INSERT INTO pac_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cư khoiq canưi máh top rian te thới dyôn chuih angốh yang saq te cháq acái cư, ma nha-án chuih lớiq rap.” ");
INSERT INTO pac_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yê-su ôi idô: “Inha ndon át tớq pang ndô ơi! Imo inha lớiq tin alứng lới lư! Nnáng dưnh máh-mmo cư cóq át alứng inha, alứng chiuq inha lớiq tin cư? Dông ngai-acái ngki nga cư!” ");
INSERT INTO pac_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ndóng ngai-acái conh ngki tớq, yang saq carvít alứng atáih án tớq cuteq. Yê-su yua yang saq ngki ngốh táp te cháq ngai-acái. Dyơ ngai-acái cơt bánh lieh. Yê-su mŏp lieh án nga a-ám án. ");
INSERT INTO pac_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nhéq máh ticuoi sáng dut te Yang Arbang-pilŏ́ng bôn chức pưt lư têq táq iki. Ndóng máh ticuoi ngki yôl sáng dut te arnáq Yê-su táq, ngki Yê-su tông top rian te án idô: ");
INSERT INTO pac_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Inha cammáng dyôn simớt máh parnai cư tông inha hoi-ndô! Tumán dyơ ngai ính mŏp cư Acái Yang Cơt Ticuoi nga ati ticuoi sút!” ");
INSERT INTO pac_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma nha-án lớiq apúh te parnai ngki. Yang Arbang-pilŏ́ng catốq parnai ngki lớiq dyôn nha-án chom. Alứng nha-án lớiq dáh plốh Yê-su te callong ngki. ");
INSERT INTO pac_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Top rian te Yê-su tarmien, nnáu pưt hơn te cannŏ́h tớq top nha-án. ");
INSERT INTO pac_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yê-su chom nha-án parngíh iki, dyơ án tec mui náq ngai-acái dyôn tayứng tumán án. ");
INSERT INTO pac_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Alứng án tông top rian te án idô: “Ticuoi mmo ráp ngai-acái arớq ndô co án tin cư, ticuoi ngki lư ráp cư tưi. Alứng ticuoi mmo ráp cư, la muchứng ticuoi ngki ráp díh án ndon yua cư tớq nga tudô tưi. Ticuoi mmo két hơn te ticuoi cannŏ́h tớq top inha, ticuoi ngki lư pưt hơn te ticuoi cannŏ́h.” ");
INSERT INTO pac_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yon tông Yê-su idô: “Thới ơi! He khoiq hôm munáq ticuoi chuih angốh yang saq, alứng án bôiq nốh thới. Ma he lớiq dyôn án táq nnáng arnáq iki, co án tới te top he.” ");
INSERT INTO pac_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma Yê-su tông Yon idô: “Inha êq catáng án. Ticuoi mmo lớiq chuoq rúc inha, la arớq án choi inha tưi.” ");
INSERT INTO pac_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tumán ính tớq ingái Yê-su sớr lieh nga pilŏ́ng, Yê-su parngíh ính pôq nga vel pưt Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Án yua máh ticuoi dông parnai pôq nsuoi. Nha-án mot tớq mui vel na ticuoi Sa-mari dŏq thuan dyôn Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma ticuoi tớq vel ngki lớiq ráp Yê-su, co nha-án chom, án ính pôq nga vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tư Yacơ alứng Yon la top rian te Yê-su, chom callong ngki, iki nha-án plốh Yê-su idô: “Ưlla ơi! Ưlla ính he arô uih te pilŏ́ng siar chŏ́ng viang nha-án lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma Yê-su tilêq me nga nha-án, alứng dyŏq nha-án êq parngíh iki. ");
INSERT INTO pac_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dyơ nha-án pôq nga vel cannŏ́h loi. ");
INSERT INTO pac_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ndóng nha-án pôq na carna, bôn munáq conh tớq nga Yê-su alứng tông idô: “Thới ơi! Tumo thới pôq, cư seq veng thới pôq nga tuki tưi.” ");
INSERT INTO pac_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yê-su ôi án idô: “Ayŏ́ng bôn cưp, achếq bôn sáp, ma Acái Yang Cơt Ticuoi lớiq bôn ntúq dyôn án bíq.” ");
INSERT INTO pac_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yê-su yua munáq conh cannŏ́h idô: “Mái veng tapun cư.” Ma conh ngki ôi idô: “Ưlla ơi! Dyôn a-ám cư cuchet avai. Tớq cua cư tứp án, cư lư veng tapun Ưlla.” ");
INSERT INTO pac_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yê-su tông lieh án idô: “Dyôn nha-án ndon lớiq bôn mui mít alứng cư, chứm chiam ticuoi ndon lớiq bôn mui mít alứng cư. Ma mái cóq pôq cato te arnáq Yang Arbang-pilŏ́ng cơt sút.” ");
INSERT INTO pac_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bôn ticuoi cannŏ́h tông idô: “Ưlla ơi! Cư ính veng Ưlla tưi, ma cư seq chô carbánh abŏ́h cư avai.” ");
INSERT INTO pac_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yê-su tông án idô: “Ticuoi táq vông tớq ro, khán án kéu crơng cái, án cóq êq tilêq me nga crŏ́ng. Táq iki carna vông án lư tinớng ŏ. Ticuoi táq arnáq Yang Arbang-pilŏ́ng la muchứng ngki tưi. Khán án bôn bar mít, Yang Arbang-pilŏ́ng lớiq têq cơt sút án.” ");
INSERT INTO pac_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Vít ngki Yê-su rêh tupul chít la bar náq. Án yua nha-án pôq nsuoi án, mui top bar náq, dyôn mot tớq cứp vel cứp ntúq án parngíh ính pôq. ");
INSERT INTO pac_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Án cato nha-án idô: “Sro tớq pidái pơh khoiq dom dyơ, ma bôn biq náq ticuoi pôq sot. Cóq inha tarseq tarsuong te Ưlla pidái dyôn án yua a-ưi náq pôq sot sro ngki. ");
INSERT INTO pac_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Inha pôq! Cư yua inha pôq arớq cưu acái át pandi acho cruong. ");
INSERT INTO pac_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Inha êq dông práq. Êq báq tui arớq ticuoi suseq. Êq dông bar rúp cơp. Alứng tớq inha tumúh yớu tớq carna, inha êq ticu táq-ntêr alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dúng mmo inha mot, tôm lư cóq inha tông idô: ‘Seq Yang Arbang-pilŏ́ng choi abŏ́h ndô bôn bánh suanh ien ŏ níc.’ ");
INSERT INTO pac_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Khán ticuoi tớq abŏ́h ngki lư ính Yang Arbang-pilŏ́ng dyôn nha-án bôn callong bún ngki, Yang Arbang-pilŏ́ng lư dyôn. Ma khán nha-án lớiq ính, Yang Arbang-pilŏ́ng dyôn inha loi bôn callong bún ngki. ");
INSERT INTO pac_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Inha cóq át mui dúng sớng. Inha êq pôq át dúng ndô dúng ngki. Alứng tanna amớh ngai angốh dyôn inha cha, inha cha tanna ngki. Ticuoi ndon táq arnáq choi ticuoi cannŏ́h, ticuoi cannŏ́h cóq choi lieh án dyôn têq bôn crơng tanna cha. ");
INSERT INTO pac_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tớq inha mot tớq vel, khán ngai ráp pasôl ŏ inha, iki cóq inha cha máh crơng tanna nha-án dyôn. ");
INSERT INTO pac_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tớq vel ngki, cóq inha táq bánh máh ticuoi a-ái. Alứng cóq inha tông nha-án idô: ‘Tumán dyơ, Yang Arbang-pilŏ́ng cơt sút inha.’ ");
INSERT INTO pac_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma tớq inha mot tớq vel, ma ticuoi tớq vel ngki lớiq ráp pasôl ŏ inha, cóq inha ngốh lieh na carna alứng tông idô: ");
INSERT INTO pac_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Díh cuteq mbúi te vel inha ndon bôt tớq dyưng he la he tangkhír angốh nhéq, táq tíc inha lớiq ráp he. Ma cóq inha chom arlớih lư tưi, khoiq tumán tớq dyơ Yang Arbang-pilŏ́ng cơt sút!’” ");
INSERT INTO pac_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dyơ Yê-su tông loi idô: “Cư tông inha simớt lư, tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, án táq nha-án ndon át tớq vel ngki dyôn tumúh dieiq arức ntáng hơn te ticuoi tớq vel Sadôm te inớh.” ");
INSERT INTO pac_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Bap lư tớq nga inha ndon át tớq vel Côr-sín! Alứng bap lư inha ndon át tớq vel Bet-sada! Khán cư táq arnáq sileh tớq vel Tirơ alứng vel Sadôn muchứng cư khoiq táq tớq vel inha, lư dưnh dyơ ticuoi tớq vel ngki ngin luaih pien cơt mít tamme loi. Alứng lư dưnh dyơ nha-án tớc tampớc tallêng alứng pức abŏ́h tớq cháq nha-án, táq tíc nha-án sáng anguaq co nha-án bôn luaih. ");
INSERT INTO pac_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, ingái ngki án sáng sruiq táq ada ticuoi tớq vel Tirơ nha vel Sadôn hơn te án sáng sruiq táq ada top inha. ");
INSERT INTO pac_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Alứng inha ndon át tớq vel Cabê-na-um ơi! Inha parngíh inha têq sớr bôm nga pilŏ́ng lớiq? Lư simớt, urớh Yang Arbang-pilŏ́ng apŏ́ng inha tớq ntúq uih chéh níc-níc!” ");
INSERT INTO pac_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dyơ Yê-su tông ada tupul chít la bar náq ngki idô: “Ticuoi mmo cammáng parnai inha la muchứng án cammáng parnai cư tưi. Alứng ticuoi mmo lớiq ính cammáng parnai inha la muchứng án lớiq ính cammáng parnai cư tưi. Alứng ticuoi mmo lớiq ính cammáng parnai cư, la muchứng ticuoi ngki lớiq ính cammáng parnai án ndon yua cư tớq tưi.” ");
INSERT INTO pac_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Top tupul chít la bar náq ngki píh chô alứng sáng bui lư. Nha-án tông Yê-su idô: “Ưlla ơi! Máh yang saq lư peh parnai he ndóng he bôiq nốh Ưlla alứng yua án ngốh!” ");
INSERT INTO pac_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yê-su tông nha-án idô: “Cư khoiq hôm yang Satán atôh te pilŏ́ng chái lư arớq lilaiq. ");
INSERT INTO pac_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Inha cammáng! Cư dyôn inha bôn chức têq dếq cusánh nha ngcứm catam, alứng cư dyôn inha rap chíl lieh yang Satán. Alứng lớiq bôn nốh amớh têq táq inha. ");
INSERT INTO pac_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inha êq ơn co yang saq peh inha. Ma cóq inha ơn, co Yang Arbang-pilŏ́ng khoiq taran nốh inha tớq pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ndóng ngki Arvai Yang Arbang-pilŏ́ng dyôn Yê-su sáng hơr lư. Iki án tông Yang Arbang-pilŏ́ng idô: “A-ám cư tớq pilŏ́ng ơi! A-ám lư Ưlla pilŏ́ng alứng Ưlla cúc cuteq ndô! Cư si-ơn mái khoiq apáh ngê mái dyôn ticuoi ndon arớq ngai-acái két ndô, la nha-án ndon iyốh rian amớh. Ma mái catốq ngê ndô te ticuoi tubáiq, la nha-án ndon khoiq rian a-ưi. Lư piaiq, A-ám ơi! Cư ayô mái, co callong ngki ŏ lư chứng mát mái. ");
INSERT INTO pac_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“A-ám cư khoiq mŏp cứp nốh dyôn cư, alứng lớiq bôn ticuoi mmo chom te Acái Yang Arbang-pilŏ́ng, ma nưm A-ám án táp chom cứp callong. Alứng lớiq bôn ticuoi mmo chom te A-ám tớq pilŏ́ng, ma nưm Acái Yang Arbang-pilŏ́ng táp chom. Alứng ticuoi mmo Acái Yang Arbang-pilŏ́ng rêh, án lư apáh dyôn ticuoi ngki chom te A-ám tớq pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Cua ngki Yê-su píh me nga top rian te án, alứng án tông nưm dyôn nha-án sớng idô: “Bún lư ticuoi mmo bôn hôm máh nốh inha hôm. ");
INSERT INTO pac_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cư tông inha arlớih lư, bôn a-ưi náq ticuoi tang ngcang Yang Arbang-pilŏ́ng, alứng a-ưi náq puo ính lư hôm máh arnáq inha hôm hoi-ndô, ma nha-án ớq bôn hôm. Alứng nha-án ính lư sáng máh callong inha sáng hoi-ndô, ma nha-án ớq bôn sáng.” ");
INSERT INTO pac_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bôn munáq thới sái rit Isa-ra-el tớq nga Yê-su. Án plốh co ính chim Yê-su, idô: “Thới ơi! Amớh cư cóq táq dyôn têq bôn tumống níc-níc?” ");
INSERT INTO pac_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yê-su ôi idô: “Amớh ngai khoiq taran tớq phep rit Yang Arbang-pilŏ́ng? Tớq inha dŏc, amớh inha sáng te parnai ngki?” ");
INSERT INTO pac_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ticuoi ngki ôi idô: “Parnai Yang Arbang-pilŏ́ng tông idô: ‘Cóq inha amoih Yang Arbang-pilŏ́ng Ưlla inha, nhéq te mít cannính, nhéq te rêng, alứng nhéq te parngíh inha.’ Alứng án tông loi idô: ‘Cóq inha amoih yớu muchứng inha amoih cháq inha bôm.’” ");
INSERT INTO pac_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yê-su ôi ticuoi ngki idô: “Lư piaiq mái tông. Khán mái táq iki, lư mái bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma ticuoi ngki ính apáh án cơt ticuoi tinớng ŏ. Iki án plốh Yê-su loi idô: “Nnáu la yớu cư?” ");
INSERT INTO pac_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yê-su ôi án tớq parnai acám idô: “Bôn munáq conh pôq tớq carna, siar te vel Yaru-salem pôq nga vel Yê-ri-cô. Ndóng án pôq tớq carna, bôn ticuoi siveng palŏ́ng pur nhéq crơng án, alứng nha-án tính án tumán ính cuchet hơ, dyơ nha-án lúh táh. ");
INSERT INTO pac_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ingái ngki bôn munáq te top teng rit sang Yang Arbang-pilŏ́ng pôq carna ngki tưi. Án hôm ticuoi tumán ính cuchet ngki, ma án pôq viar viang. ");
INSERT INTO pac_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Muchứng ngki tưi tớq ticuoi táq arnáq tớq Dúng Sang Pưt hôm ticuoi chol ngki, án tớq tingơ muhoi, dyơ án pôq viar viang. ");
INSERT INTO pac_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma bôn munáq te vúng Sa-mari pôq tớq carna ngki tưi. Tư án hôm ticuoi chol ngki, án sáng sruiq táq. ");
INSERT INTO pac_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Án tớq nga ticuoi chol ngki, dyơ án tốq dơq tarháu alứng sieu tớq ntúq bác nha tian tớq prới. Cua ngki án arơq ticuoi chol asớr tớq aséh a-êp án, dyơ án dông ticuoi chol ngki nga dúng tumoi bíq, alứng án chứm chiam. ");
INSERT INTO pac_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tớq ingái parnô án ial bar callong práq te tui án dyôn nga ticuoi ưlla dúng. Alứng án patáp ưlla dúng ngki idô: ‘Cư seq inha me choi ticuoi ndô. Urớh, tớq cư chô lieh na carna ndô, máh-mmo a-ưi práq inha pít dyôn án cha, cư lư culieh lieh dyôn inha.’” ");
INSERT INTO pac_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cua Yê-su tông parnai acám ndô, dyơ án plốh ticuoi ndon chim án idô: “Te ticuoi pe náq ngki, nnáu la yớu ticuoi chol ndon ticuoi siveng khoiq pur?” ");
INSERT INTO pac_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Án ndon sái rit Isa-ra-el ôi lieh Yê-su idô: “Ticuoi ndon choi án la yớu án.” Iki Yê-su tông lieh án idô: “Cóq mái pôq táq muchứng ticuoi ngki tưi.” ");
INSERT INTO pac_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ndóng Yê-su alứng top rian te án pôq tớq carna, nha-án mot tớq mui vel. Tớq vel ngki bôn munáq cán, nốh Mathê. Mathê ráp pasôl ŏ lư Yê-su, alứng dyôn Yê-su mot tớq dúng án. ");
INSERT INTO pac_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mathê bôn munáq a-em cán, nốh Mari. Mari ticu tumán dyưng Yê-su alứng cammáng Yê-su cato. ");
INSERT INTO pac_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Mathê mmaq tál táq a-ưi arnáq. Iki án tớq nga Yê-su alứng tông idô: “Ưlla ơi! A-em cư dyôn munáq cư sớng táq arnáq. Imo Ưlla parngíh te callong ndô? Cư seq Ưlla yua án tớq choi cư hơ.” ");
INSERT INTO pac_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma Yê-su ôi án idô: “Ơ Mathê, Mathê ơi! Arức lư dyôn mái; mái rớu-ri alứng tál a-ưi arnáq. ");
INSERT INTO pac_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ma bôn mui nốh sớng cóq mái rêh. Mari khoiq rêh dyơ nốh ngki, alứng nốh ngki lớiq bôn ngai têq ial te án.” ");
INSERT INTO pac_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bôn mui ingái Yê-su át cớu tớq mui ntúq. Cua án cớu, bôn munáq top rian te án seq idô: “Ưlla ơi! Seq Ưlla pasoi he dyôn chom cớu muchứng Yon khoiq pasoi top rian te án.” ");
INSERT INTO pac_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yê-su tông nha-án idô: “Tớq inha cớu, cóq inha cớu idô: ‘Cucúh A-ám ơi! Seq inha dyôn nhéq tưh ticuoi dyám náp nốh inha. Seq inha cơt sút tớq mít cannính ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Seq inha dyôn he bôn khám cha cứp ingái. ");
INSERT INTO pac_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Seq inha táh luaih he khoiq táq, co he khoiq táh luaih ngai táq ada he. Seq inha êq dyôn yang Satán tardông he táq arnáq saq.’” ");
INSERT INTO pac_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yê-su tông top rian te án loi idô: “Cư acám idô: Inha bôn yớu, alứng inha pôq nga dúng án ma khoiq tardi dáu, alứng inha tông idô: ‘Ai ơi! Cư seq manh pe long asớq mái, ");
INSERT INTO pac_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","co bôn tumoi tớq nga dúng cư, ma cư lớiq bôn amớh ính angốh dyôn tumoi cha.’ ");
INSERT INTO pac_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dáh lơ yớu ngki ính ôi inha idô: ‘Mái êq pidieiq cư hoi-ndô, co cư khoiq cliang callống dyơ. Cư alứng acái acon cư khoiq bíq. Cư lớiq têq yôr ial nnáng dyôn mái.’ ");
INSERT INTO pac_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma cư tông inha idô: Yớu ngki lư lớiq ính yôr ial asớq dyôn inha co inha la yớu án, ma án yôr ial asớq dyôn inha, co tian inha pidieiq án. ");
INSERT INTO pac_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Alứng cư tông inha idô: Khán inha seq, ngki inha bôn. Khán inha suo, ngki inha tumúh. Khán inha acóh callống, ngki ngai pốh dyôn. ");
INSERT INTO pac_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Co cứp náq ticuoi ndon seq, ngki án bôn. Án suo, ngki án tumúh. Án acóh callống, ngki ngai pốh dyôn. ");
INSERT INTO pac_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Máh inha ndon khoiq bôn acái, khán acái inha seq buaiq, inha dyôn án cusánh lớiq? ");
INSERT INTO pac_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Alứng khán án seq tirial ntruoi, inha dyôn án ngcứm catam lớiq? ");
INSERT INTO pac_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Inha la máng ticuoi lới, ma nnáng inha chom dyôn crơng ŏ nga acái inha. Lư clưi te ngki loi A-ám inha tớq pilŏ́ng ính dyôn inha bôn Arvai án, khán inha seq te án!” ");
INSERT INTO pac_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ndóng ngki Yê-su chuih angốh yang saq ndon táq munáq ticuoi cơt lúng. Tớq vít yang saq ngốh, ticuoi ngki têq tacang lieh. Dyơ ticuoi clứng ngki sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma bôn ticuoi te top nha-án tông idô: “Án ndô chuih angốh yang saq co nhơ yang Bên-sabul ndon sút nhéq tưh yang saq, dyôn án bôn chức.” ");
INSERT INTO pac_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Alứng bôn ticuoi cannŏ́h ính chim Yê-su; dyơ nha-án seq mui tíc te án, co ính chom án bôn chức te Yang Arbang-pilŏ́ng ma lớiq. ");
INSERT INTO pac_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma Yê-su chom nha-án parngíh iki, dyơ án tông nha-án idô: “Khán bôn mui cruong, top ndô tarchíl alứng top ngki, lư lớiq cơt cruong nnáng. Alứng khán bôn mui abŏ́h, ma munáq tarluaih ada munáq, lư lớiq cơt nnáng abŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Inha tông cư chuih angốh yang saq co nhơ yang Bên-sabul dyôn cư bôn chức. Ma khán top yang Satán munáq tarchíl munáq, iki lư lớiq cơt nnáng top yang Satán. ");
INSERT INTO pac_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Khán cư chuih angốh yang saq co nhơ yang Bên-sabul dyôn cư bôn chức, ngki nnáu dyôn ticuoi veng inha bôn chức têq chuih yang saq? Lư simớt ticuoi te top inha táp ính tíq inha. ");
INSERT INTO pac_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma khán cư chuih angốh yang saq co Yang Arbang-pilŏ́ng dyôn cư táq, ngki arnáq ndô apáh dyôn inha chom la Yang Arbang-pilŏ́ng cơt sút khoiq tớq nga inha dyơ. ");
INSERT INTO pac_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Khán bôn ticuoi bánh rêng lư, alứng án bôn a-ưi crơng pla dŏq bán kiaq crơng án, ticuoi cannŏ́h lư lớiq têq talóh crơng án. ");
INSERT INTO pac_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma khán bôn ticuoi bánh rêng hơn te án, ticuoi ngki lư rap chíl án, alứng ial nhéq crơng pla te án, dyơ mpô dyôn ticuoi ndon pôq munơi alứng ticuoi bánh ngki. ");
INSERT INTO pac_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ticuoi mmo lớiq sŏ́ng mui mít alứng cư, ticuoi ngki lư lớiq ính cư. Alứng ticuoi mmo lớiq dông ticuoi cannŏ́h tớq nga cư, la muchứng án catáng ticuoi cannŏ́h lớiq dyôn veng ngê cư tưi. ");
INSERT INTO pac_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Tư yang saq ngốh te cháq ticuoi, dyơ án pôq suo ntúq preng cupróng ính angô, ma án lớiq tumúh. Dyơ án parngíh idô: ‘Cư ính chô lieh nga ntúq cư khoiq ngốh te nsuoi.’ ");
INSERT INTO pac_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tư án chô nga ntúq ngki, án hôm nưm ntúq mat, práh priel, alứng máh crơng khoiq atức carsiat dyơ. ");
INSERT INTO pac_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iki án pôq cớiq alứng dông achô tupul náq yang saq dyôn át munơi alứng án tớq ntúq ngki. Máh yang ngki saq hơn te án. Iki thôq ticuoi ngki cơt saq hơn te nsuoi loi.” ");
INSERT INTO pac_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ndóng Yê-su cato parnai ngki, bôn munáq cán te ticuoi clứng tông yứng lư ada án idô: “Bún lư cán ndon carnian thới, alứng dyôn thới uq tóh!” ");
INSERT INTO pac_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma Yê-su ôi án idô: “Callong ngki la piaiq tưi, ma bún hơn te ngki loi la ticuoi ndon cammáng alứng peh parnai Yang Arbang-pilŏ́ng!” ");
INSERT INTO pac_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ndóng ticuoi clứng át rum paniar Yê-su, án tông nha-án idô: “Lới lư máh ticuoi át tớq pang ndô! Nha-án seq te cư mui tíc sileh, ma cư lớiq táq dyôn nha-án. Co nha-án khoiq bôn dyơ tíc sileh te Yô-na ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh. ");
INSERT INTO pac_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yô-na la mui tíc sileh dyôn máh ticuoi tớq vel Ni-navê. Muchứng ngki tưi, cư Acái Yang Cơt Ticuoi la mui tíc sileh dyôn máh ticuoi tớq pang ndô. ");
INSERT INTO pac_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, ngki bôn cán puo cruong Sê-ba, án tíq ticuoi tớq pang ndô. Án têq tíq iki, co án tớq te cruong yông lư, án ính cammáng parnai tubáiq puo Sa-lamôn. Ma hoi-ndô, tớq ntúq ndô bôn munáq tubáiq hơn te Sa-lamôn! ");
INSERT INTO pac_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tớq ingái Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi, máh ticuoi tớq vel Ni-navê te inớh tíq máh ticuoi tớq pang ndô. Nha-án têq tíq iki, co tớq nha-án sáng parnai Yô-na cato, dyơ nha-án ngin luaih táp, alứng pien cơt mít tamme loi. Ma hoi-ndô, tớq ntúq ndô bôn munáq pưt hơn te Yô-na!” ");
INSERT INTO pac_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yê-su tông loi idô: “Lớiq bôn ngai bet den tớu, dyơ pul catốq, lớiq la catứp tớq yáng. Ma lư ngai dŏq tớq aruong den, dŏq cứp náq ticuoi ndon mot têq hôm ang. ");
INSERT INTO pac_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mát ticuoi la arớq tabong dyôn cháq. Khán mát inha hôm, nhéq cháq inha cơt ang. Ma khán mát inha lớiq hôm, nhéq cháq inha cơt ngiau. ");
INSERT INTO pac_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iki cóq inha me dyôn a-ŏ. Dáh lơ ngê inha parngíh ang, lớiq bôn ang. ");
INSERT INTO pac_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Khán inha veng callong ang, alứng lớiq veng callong ngiau, iki mít cannính inha, lư cơt ang nhéq. Ndô la arớq den tớu claq dyôn inha têq hôm ang.” ");
INSERT INTO pac_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cua Yê-su tông iki, bôn munáq te top Pha-rasi mơi Yê-su tớq cha mui pêl nga dúng án. Iki Yê-su pôq cha. ");
INSERT INTO pac_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma tư ticuoi Pha-rasi ndô hôm Yê-su lớiq arau ati veng rit nsuoi ính cha, iki án sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iki Yê-su tông án idô: “Inha top Pha-rasi bôn mít cannính arớq tingan alứng adien ngai arau práh nưm culái tieh, ma tớq callúng bôn máng prớq. Prớq ngki la inha tarpún crơng ngai alứng lới lư! ");
INSERT INTO pac_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ơ inha ndon achơ lư ơi! Án ndon teng cháq ticuoi, lư án teng díh mít cannính ticuoi hơ. ");
INSERT INTO pac_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma cóq inha bôn mít cannính ính choi ticuoi kidit. Iki inha cơt práh díh tớq callúng alứng tớq tieh. ");
INSERT INTO pac_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Bap lư tớq nga inha ticuoi Pha-rasi! Lư inha dông mŏp sang máh bát bai asai akieu dyôn Yang Arbang-pilŏ́ng muoi phê te mui chít phê. Ma inha lớiq peh parnai án patáp inha dyôn táq tinớng tupứng, alứng inha lớiq lư amoih Yang Arbang-pilŏ́ng. Cư lớiq ính inha táh arnáq mŏp sang ngki, ma cóq inha táq díh bar callong tatun ngki hơ. ");
INSERT INTO pac_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Bap lư tớq nga inha ticuoi Pha-rasi! Inha ính bôn lư kichơng ticu ŏ clưi nhéq te cannŏ́h tớq dúng rum. Alứng inha ính ticuoi cannŏ́h pasôl ŏ inha ndóng inha át alứng ticuoi clứng. ");
INSERT INTO pac_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bap lư tớq nga inha ticuoi Pha-rasi! Inha la arớq ping cumuiq lớiq bôn táq tíc. Iki ticuoi cannŏ́h pôq alứng dếq ping ngki, ma ngai lớiq chom ntúq ngki prớq lư.” ");
INSERT INTO pac_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bôn munáq thới sái rit tông ada Yê-su idô: “Thới ơi! Thới tông iki la muchứng thới tíq he ndon sái rit tưi!” ");
INSERT INTO pac_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yê-su tông án idô: “Bap lư tớq nga inha ndon sái rit! Inha sái ticuoi cannŏ́h dyôn veng phep rit dieiq lư, arớq inha dyôn nha-án dual crơng ntáng. Ma ati inha lớiq ial choi amớh crơng ntáng te nha-án. ");
INSERT INTO pac_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bap lư tớq nga inha! Inha táq ping ŏ dyôn ticuoi tang ngcang Yang Arbang-pilŏ́ng, ma lư achúc achiac inha táp khoiq cachet ticuoi tang ngcang ngki. ");
INSERT INTO pac_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iki, ndô la muchứng inha sŏ́ng alứng arnáq achúc achiac inha khoiq táq, co nha-án khoiq cachet máh ticuoi tang ngcang, dyơ inha táq ping dyôn máh ticuoi tang ngcang. ");
INSERT INTO pac_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma callong tubáiq te Yang Arbang-pilŏ́ng tông idô: ‘Urớh cư yua máh ticuoi tang ngcang cư alứng máh ticuoi dyưng ati cư tớq nga nha-án. Bôn ticuoi te top ngki, nha-án ính cachet alứng bôn ticuoi nha-án ính tính.’ ");
INSERT INTO pac_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Iki tôt nha-án ndon khoiq cachet máh ticuoi tang ngcang, tôt ngki Yang Arbang-pilŏ́ng dyôn nga máh ticuoi tớq pang ndô hơ. ");
INSERT INTO pac_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tôt ngki bôn te ingái nha-án cachet Aben, tingôi tớq ingái nha-án cachet Sa-chari. Ngai khoiq cachet Sa-chari tớq callúng Dúng Sang Pưt tumán parông sang. Cư tông inha arlớih lư, cứp nốh tôt ngki, lư tớq nga ticuoi tớq pang ndô hơ! ");
INSERT INTO pac_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Bap lư tớq nga inha thới sái rit! Co inha lớiq veng ngê Yang Arbang-pilŏ́ng simớt lư. Alứng khán ticuoi cannŏ́h ính veng, ngki inha catáng! Ndô la arớq inha cliang ngáh callống ndon inha lớiq ính mot, alứng inha lớiq ính ticuoi cannŏ́h mot tưi!” ");
INSERT INTO pac_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tớq Yê-su ngốh te dúng ngki, máh thới sái rit alứng máh ticuoi Pha-rasi angốh ngê ính chíl Yê-su, alứng nha-án plốh án te a-ưi nốh. ");
INSERT INTO pac_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nha-án cammáng níc ính suo callong luaih te Yê-su táq-ntêr, dŏq têq bôn cauq án. ");
INSERT INTO pac_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ndóng ngki bôn ticuoi a-ưi ngin náq át rum tớq ngki, tingôi munáq dếq dyưng munáq. Nsuoi lư la Yê-su tabớq cato top rian te án idô: “Cóq inha át yông te bôt pôih top Pha-rasi. Bôt pôih ngki la nha-án táq náh-nnan veng ngê Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Khán bôn nốh amớh ngai pul catốq hoi-ndô, chô-mát ngai lớiq têq pul catốq nnáng. Alứng arnáq amớh ngai táq clôp hoi-ndô, chô-mát ngai lớiq têq táq clôp nnáng. ");
INSERT INTO pac_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iki, parnai amớh inha khoiq tông dyôn biq náq chom, urớh clứng lư ticuoi chom parnai ngki. Alứng callong amớh inha carhaiq tớq cutor tớq callúng clôp, urớh cứp náq ticuoi bôn chom te callong ngki. ");
INSERT INTO pac_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Inha la yớu cư. Cư tông inha arlớih lư idô: Êq adáh ticuoi ndon têq cachet cháq inha, ma vít nha-án cachet inha, nha-án lớiq têq táq amớh ada arvai inha. ");
INSERT INTO pac_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma cư ính tông dyôn inha chom, nnáu cóq inha adáh. Cóq inha adáh Yang Arbang-pilŏ́ng, co án bôn chức têq cachet cháq inha, alứng án têq apŏ́ng arvai inha tớq ntúq uih chéh níc-níc. Cư tông inha arlớih lư, cóq inha adáh án! ");
INSERT INTO pac_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Inha báq plới sông lám achếq téc-téc, ma tarnáp án nưm bar su práq. Ma Yang Arbang-pilŏ́ng lớiq bôn clớiq mui lám te máh achếq ngki. ");
INSERT INTO pac_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Alứng díh cứp ntráih sóc tớq plô inha, Yang Arbang-pilŏ́ng khoiq ngiaih dyơ. Iki, inha êq adáh amớh nnáng, co Yang Arbang-pilŏ́ng ayáu tarngứh inha hơn te máh achếq ngki. ");
INSERT INTO pac_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Alứng cư tông inha idô: Ticuoi mmo ngin án bôn mui mít alứng cư chứng mát ticuoi cannŏ́h, muchứng ngki tưi cư Acái Yang Cơt Ticuoi ngin án chứng mát máh tarneng Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma khán ticuoi mmo calôih cư chứng mát ticuoi cannŏ́h, muchứng ngki tưi cư calôih lieh án chứng mát máh tarneng Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ticuoi mmo acraiq cư Acái Yang Cơt Ticuoi, ngki têq Yang Arbang-pilŏ́ng táh luaih dyôn án. Ma khán án acraiq Arvai Yang Arbang-pilŏ́ng, lư Yang Arbang-pilŏ́ng lớiq nai táh luaih dyôn. ");
INSERT INTO pac_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Tớq ngai dông inha nga dúng rum lớiq la chứng mát ticuoi sút, inha êq rớu-ri nsuoi te amớh inha ính tông. ");
INSERT INTO pac_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lư ndóng ngki táp Arvai Yang Arbang-pilŏ́ng ính tông inha te máh parnai inha cóq tông.” ");
INSERT INTO pac_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bôn munáq te ticuoi clứng ngki tông ada Yê-su idô: “Thới ơi! Seq thới yua ai cư mpô mun a-ám he dyôn cư.” ");
INSERT INTO pac_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yê-su tông án idô: “Cư ớq chức dŏq sưq inha, lớiq la mpô mun dyôn inha bar náq.” ");
INSERT INTO pac_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dyơ Yê-su tông máh ticuoi át paniar ngki idô: “Inha át dyôn ahôi, êq dyôn mít cannính inha cơt ham; co pang tumống ticuoi lớiq bôn át alứng ntưn mpoq a-ưi.” ");
INSERT INTO pac_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yê-su cato nha-án tớq parnai acám idô: “Bôn ticuoi súc, tớq pidái án bôn culái along a-ưi lư. ");
INSERT INTO pac_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dyơ án parngíh idô: ‘Lớiq bôn nnáng ntúq ính dŏq máh culái te pidái cư. Imo cư ính táq hoi-ndô?’ ");
INSERT INTO pac_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dyơ án parngíh loi idô: ‘Cư táq idô: Talóh tinong tieq, dyơ táq tinong tamme dyôn pưt hơn te nsuoi. Dyơ cư pachúng dŏq máh sro alứng máh crơng cư tớq tinong tamme. ");
INSERT INTO pac_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dyơ án parngíh idô hơ: Cư khoiq bôn a-ưi lư dyơ. Tớq a-ưi cumo cư lớiq túh cóq tutáq nnáng, co cư yôl bôn crơng tanna cha. Cư át ien, tớc sớng alứng ngoiq cha sớng.’ Iki án parngíh. ");
INSERT INTO pac_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma Yang Arbang-pilŏ́ng tông ada án idô: ‘Mái achơ lư. Idáu ndô táp nhéq pang tumống mái. Dyơ máh ntưn mái khoiq pachúng parŏm cơt na nnáu?’” ");
INSERT INTO pac_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dyơ Yê-su tông idô: “Muchứng ticuoi ngki tưi, Yang Arbang-pilŏ́ng ính táq ada ticuoi ham alứng pachúng a-ưi crơng, ma nha-án lớiq bôn súc amớh chứng mát Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dyơ Yê-su cato top rian te án idô: “Iki cư tông inha idô, inha êq rớu-ri te pang tumống inha; amớh inha ính cha lớiq la ính tớc. ");
INSERT INTO pac_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Co he bôn tumống la pưt hơn te he bôn tanna. Alứng he bôn cháq chớn la pưt hơn te he bôn tampớc. ");
INSERT INTO pac_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Inha me nga achếq a-aq. Achếq ngki lớiq bôn chớt choi, lớiq bôn sot, alứng lớiq bôn dŏq crơng tanna amớh tớq dúng. Ma Yang Arbang-pilŏ́ng chứm chiam achếq ngki. Yang Arbang-pilŏ́ng ayáu inha hơn te máh achếq ngki. ");
INSERT INTO pac_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Lớiq bôn ticuoi mmo têq to anhúq án dyôn cơt toiq co nhơ te án rớu-ri. ");
INSERT INTO pac_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Khán inha lớiq têq táq mui arnáq két arớq iki, ngki imo inha rớu-ri níc te nốh cannŏ́h? ");
INSERT INTO pac_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Inha me nga pier. Pier ngki lớiq túh cóq táq tampớc tớc. Ma cư tông inha arlớih lư idô: Puo Sa-lamôn ndon súc lư, án lớiq bôn sứp tampớc dêu arớq pier ndô. ");
INSERT INTO pac_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lư Yang Arbang-pilŏ́ng táp dyôn pier sác cơt amaiq. Ma pier tumống muhoi sớng. Ingái ndô án cháh, ingái parnô án angom. Lư simớt, clưi te pier ngki loi Yang Arbang-pilŏ́ng dyôn inha bôn tampớc tớc. Co imo inha tin biq lư? ");
INSERT INTO pac_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Inha êq rớu-ri te crơng ngoiq cha. ");
INSERT INTO pac_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Máh nốh ndô ticuoi ndon lớiq chom Yang Arbang-pilŏ́ng báq rớu-ri. Ma A-ám inha tớq pilŏ́ng chom dyơ, inha cóq bôn máh nốh ngki. ");
INSERT INTO pac_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ma cóq inha suo dyôn Yang Arbang-pilŏ́ng cơt sút tớq mít cannính inha. Khán iki, án lư dyôn inha bôn máh nốh ngki hơ. ");
INSERT INTO pac_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Máh yớu cư ơi! Inha nưm biq náq, ma inha êq adáh amớh, co A-ám inha tớq pilŏ́ng sáng bui cannính dyôn inha bôn chức tớq ntúq án sút. ");
INSERT INTO pac_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Cóq inha táiq ntưn mpoq inha, dyơ choi ticuoi kidit. Alứng cóq inha ial máh crơng ngáih ndon lớiq têq rúng; dyơ dŏq máh crơng ngki tớq pilŏ́ng, la ntúq máh crơng ngki lớiq nai pít; siveng lớiq têq mot tôiq, alứng atóh lớiq têq cha. ");
INSERT INTO pac_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Co tớq ntúq mmo inha dŏq máh mun inha, mít cannính inha lư át parngíh níc te ntúq ngki.” ");
INSERT INTO pac_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Cóq inha thuan nsuoi, alứng cóq inha át cayôn níc. ");
INSERT INTO pac_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Inha cóq táq muchứng máh ticuoi táq arnáq báq pớn ưlla nha-án chô te arieu. Tớq ưlla chô, ưlla acóh ngáh callống. Dyơ nha-án pốh táp dyôn ưlla nha-án. ");
INSERT INTO pac_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Máh ticuoi táq arnáq ngki sáng bui lư tớq ưlla chô, co ưlla nha-án hôm nha-án át pớn níc alứng lớiq bôn bíq. Cư tông inha arlớih lư, ưlla ngki ính hớu lieh nha-án. Án ính dyôn nha-án ticu, alứng án táp ính angốh crơng tanna dyôn nha-án cha. ");
INSERT INTO pac_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Piaiq ưlla ngki chô tardi dáu, lớiq la chô iláih cúng bôn. Ma máh ticuoi táq arnáq án nnáng sáng bui lư, co nha-án khoiq thuan nhéq dyơ. ");
INSERT INTO pac_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Cóq inha chom tưi idô: Khán ưlla dúng chom ndóng mmo ticuoi siveng ính mot titôiq tớq dúng án, lư án cayôn níc, lớiq dyôn ticuoi siveng têq mot titôiq tớq dúng án. ");
INSERT INTO pac_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Máh ngki tưi, cóq inha tiráp dŏq, co inha lớiq chom ndóng mmo cư Acái Yang Cơt Ticuoi tớq lieh. Cư lư tớq ndóng inha lớiq parngíh amớh te cư tớq.” ");
INSERT INTO pac_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phi-er plốh Yê-su idô: “Ưlla ơi! Ưlla tông parnai acám ndô dyôn nưm na he, lớiq la dyôn cứp náq ticuoi?” ");
INSERT INTO pac_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yê-su ôi idô: “Khán bôn ticuoi tampeng ŏ alứng tubáiq, ưlla lư chóh án dyôn cơt sút dŏq me máh ticuoi táq arnáq ưlla án. Amớh ưlla yua án chiam, lư án chiam ngki. ");
INSERT INTO pac_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Khán tampeng ngki táq piaiq máh arnáq ưlla án yua, án lư sáng bui ndóng ưlla án chô. ");
INSERT INTO pac_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cư tông inha arlớih lư, urớh ưlla ính dyôn tampeng ngki kiaq me nhéq máh mun án. ");
INSERT INTO pac_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma khán tampeng ngki la ticuoi saq, lư án parngíh idô: ‘Yôl dưnh ki-náq ưlla cư chô.’ Iki án tính máh ticuoi táq arnáq ưlla án, díh cán díh conh, alứng án pôq cha ngoiq bol plêc níc. ");
INSERT INTO pac_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Dyơ ưlla án chô, ma án lớiq chom ingái ngki, alứng lớiq parngíh amớh te callong ngki. Iki ưlla án lư tráh án, alứng dyôn án át munơi alứng máh ticuoi ndon lớiq peh. ");
INSERT INTO pac_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ticuoi sol ndon chom te máh ngê ưlla, ma án lớiq thuan alứng lớiq peh, ưlla lư dyôn ngai tính án ớp lư. ");
INSERT INTO pac_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma sol ndon lớiq chom amớh te máh ngê ưlla án, alứng án táq arnáq luaih, ưlla ngki yua ngai tính án biq sớng, co án lớiq chom. Ticuoi mmo ngai dyôn a-ưi, ngai lư ngcong bôn lieh a-ưi tưi te ticuoi ngki. Alứng ticuoi mmo ngai cơiq a-ưi, ngki ngai plốh ial lieh te ticuoi ngki a-ưi tưi.” ");
INSERT INTO pac_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Cư tớq nga tudô la arớq cư dông uih dŏq chŏ́ng cúc cuteq ndô. Cư ính lư arnáq ngki vít adứh. ");
INSERT INTO pac_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Cư cóq chiuq a-ưi nốh dieiq arức; alứng mít cannính cư dieiq arức lư, tingôi máh arnáq ngki cua! ");
INSERT INTO pac_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Inha parngíh cư tớq nga cuteq ndô dyôn ticuoi át ien ŏ lớiq? Tới iki! Cư tớq nga tudô, dŏq táq dyôn ticuoi cơt partáh. ");
INSERT INTO pac_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Te ingái ndô tingôi chô-mát, khán bôn mui abŏ́h ma bôn sông náq, nha-án munáq lớiq sŏ́ng ada munáq. Pe náq lớiq sŏ́ng alứng bar náq; alứng bar náq lớiq sŏ́ng alứng pe náq. ");
INSERT INTO pac_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A-ám lớiq sŏ́ng alứng acái conh; acái conh lớiq sŏ́ng alứng a-ám. A-i lớiq sŏ́ng alứng acái cán; acái cán lớiq sŏ́ng alứng a-i. Cuya cán lớiq sŏ́ng alứng tarmôt, alứng tarmôt lớiq sŏ́ng alứng cuya-cán.” ");
INSERT INTO pac_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yê-su cato máh ticuoi clứng loi idô: “Tớq inha hôm tulúc com tớq te anga pandang pát, inha báq tông pilŏ́ng ính bo. Ngki lư bo. ");
INSERT INTO pac_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Alứng tớq inha hôm cuyiel phớt te anga cruong puoq, inha báq tông cruong inha ính puoq tưi. Ngki lư puoq. ");
INSERT INTO pac_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Inha la ticuoi táq náh-nnan chom a-ưi nốh! Inha acớl tíc tớq cuteq alứng tớq pilŏ́ng, ma inha lớiq acớl tíc ndon Yang Arbang-pilŏ́ng ính inha chom te ngê án tớq pang ndô. ");
INSERT INTO pac_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Imo inha lớiq chom rêh callong mmo lư piaiq? ");
INSERT INTO pac_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tớq inha tarluaih alứng ticuoi cannŏ́h, dyơ ticuoi ngki ính dông inha pôq tumúh ticuoi sút, cóq inha artoi achái alứng án, nsuoi inha tumúh ticuoi sút. Khán inha lớiq bôn artoi chái, dáh lơ án dông inha tớq nga ticuoi tarsưq dyôn sưq inha. Iki ticuoi tarsưq ính mŏp inha dyôn ngai crál tớq coq tôt. ");
INSERT INTO pac_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Inha lớiq têq ngốh nnáng te coq tôt ngki, tingôi inha dyôn cứp nhéq máh práq arớq ticuoi tarsưq tông.” ");
INSERT INTO pac_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ndóng ngki bôn ticuoi át tớq ngki tông Yê-su te arnáq Phi-lat cachet máh ticuoi Ca-lilê ndóng nha-án kiac pannán sang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yê-su ôi nha-án idô: “Amớh inha parngíh te máh ticuoi Ca-lilê ndon cuchet ngki, nha-án bôn luaih ntáng hơn te máh ticuoi Ca-lilê cannŏ́h lớiq? ");
INSERT INTO pac_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tới iki! Cư tông inha arlớih lư, khán inha lớiq pien cơt mít tamme loi, inha cóq cuchet muchứng nha-án tưi. ");
INSERT INTO pac_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Alứng amớh inha parngíh te mui chít ticol náq ndon át tớq ntúq Saluam, ndóng ngôl ayống arlíh catát nha-án? Inha parngíh nha-án bôn luaih hơn te máh ticuoi cannŏ́h tớq vel Yaru-salem lớiq? ");
INSERT INTO pac_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tới iki! Cư tông inha arlớih lư, khán inha lớiq pien cơt mít tamme loi, inha lư cuchet muchứng nha-án tưi.” ");
INSERT INTO pac_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dyơ Yê-su tông nha-án tớq parnai acám idô: “Bôn munáq ticuoi conh bôn mui tôm tarúng dáh tớq nưong án. Án pôq suo culái tớq tôm ngki, ma lớiq hôm culái. ");
INSERT INTO pac_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iki án yua ticuoi kiaq nưong idô: ‘Me! Khoiq pe cumo ndô dyơ, cư tớq suo culái te tôm ndô, ma lớiq hôm culái. Dyơ mái cớl táh viang tôm ndô. Khán dŏq la nưm candúh cuteq.’ ");
INSERT INTO pac_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ma ticuoi kiaq nưong ôi idô: ‘Ưlla ơi! Seq mái dŏq tôm ndô tumống mui cumo avai. Cư ính píq prúng paniar tôm ndô, dyơ cư ính cacháq phún. ");
INSERT INTO pac_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tớq cumo tatun, khán án cơt culái, ngki he bôn cha. Ma khán án lớiq cơt culái, ngki he cớl táh.’” ");
INSERT INTO pac_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bôn mui Ingái Angô, Yê-su cato tớq dúng rum. ");
INSERT INTO pac_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Át ngki bôn munáq cán tarcốn crŏ́ng khoiq mui chít ticol cumo dyơ, co bôn mui lám yang saq táq dyôn án lớiq têq tayứng tinớng. ");
INSERT INTO pac_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tớq Yê-su hôm cán ngki, án arô idô: “Ama ơi! Hoi-ndô, ama lớiq bôn a-ái iki nnáng!” ");
INSERT INTO pac_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Cua ngki, Yê-su capơiq tớq cháq cán ngki. Ndóng ngki táp crŏ́ng án cơt tinớng, alứng án ayô Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma ticuoi sút dúng rum ngki sáng uan lư, co Yê-su táq bánh ticuoi a-ái tớq Ingái Angô. Iki án tông máh ticuoi át ngki idô: “Bôn tupát ingái dyôn ticuoi táq arnáq. Máh ingái ngki inha têq tớq nga tudô dyôn ngai táq bánh. Ma inha êq tớq seq ngai táq bánh inha tớq Ingái Angô!” ");
INSERT INTO pac_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma Yê-su ôi ticuoi sút ngki idô: “Inha la ticuoi táq náh-nnan sớng! Nhéq máh inha ndon bôn carrŏ́q, lớiq la aséh át tớq coq, inha lư pốh dyôn án ngốh ngoiq dơq tớq Ingái Angô. ");
INSERT INTO pac_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Cán ndô la te tŏ́ng toiq A-praham muchứng inha tưi, ma yang Satán khoiq chóq án nhéq mui chít ticol cumo dyơ. Ŏ láng lớiq, khán taláh án tớq Ingái Angô?” ");
INSERT INTO pac_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ndóng Yê-su tông iki, máh ticuoi ndon uan án, sáng achiet lư. Ma máh ticuoi prái sáng bui cannính te máh arnáq ŏ Yê-su táq. ");
INSERT INTO pac_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yê-su tông loi idô. “Yang Arbang-pilŏ́ng táq sút la arớq amớh? Alứng nốh amớh têq cư acám te sút ngki? ");
INSERT INTO pac_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sút ngki la arớq mui callong me. Bôn munáq conh ial callong ngki pôq trứh tớq pidái. Dyơ callong ngki dáh, alứng pưt asớr cơt arớq tôm along. Têq achếq táq sáp tớq abeng.” ");
INSERT INTO pac_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yê-su acám loi idô: “Yang Arbang-pilŏ́ng táq sút la arớq amớh? ");
INSERT INTO pac_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sút ngki la arớq bôt pôih. Bôn ticuoi cán ial mubiq bôt pôih cacháq tớq bôt mi a-ưi tớq adéh púng, alứng án cacháq dơq nha crơng cannŏ́h hơ; cua ngki án cuvír. Dyơ crơng ndon khoiq carchúc ngki cơt pôih nhéq.” ");
INSERT INTO pac_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ndóng Yê-su pôq na carna ính pôq nga vel pưt Yaru-salem, án yéh tớq vel két vel pưt, alứng cato ticuoi tớq máh vel ngki. ");
INSERT INTO pac_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bôn munáq plốh án idô: “Ưlla ơi! Yang Arbang-pilŏ́ng choi tamống ticuoi nưm biq náq sớng lớiq?” Yê-su tông máh ticuoi ngki idô: ");
INSERT INTO pac_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Cóq inha catóng mot tớq ngáh callống hep. Cư tông inha arlớih lư, bôn clứng ticuoi ính mot tớq ngáh callống hep, ma nha-án ớq bôn mot. ");
INSERT INTO pac_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Tớq ưlla dúng yôr catáng ngáh callống, nhéq máh inha át tayứng culái tieh át acóh callống alứng arô idô: ‘Ưlla ơi! Seq Ưlla pốh callống dyôn he mot!’ Ma Ưlla ngki ôi inha idô: ‘Cư lớiq chom inha, alứng cư lớiq chom te mmo inha tớq!’ ");
INSERT INTO pac_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dyơ inha tông lieh idô: ‘He khoiq ngoiq cha munơi alứng Ưlla, alứng Ưlla khoiq cato tớq vel he!’ ");
INSERT INTO pac_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma Ưlla ôi lieh idô: ‘Cư lớiq chom inha, alứng cư lớiq chom te mmo inha tớq. Inha tôi yông te cư, co inha la máng ticuoi lới!’ ");
INSERT INTO pac_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tớq urớh inha nhiem alứng caltưat kineng tabang co sáng dieiq arức lư ndóng inha hôm A-praham, I-sac, Yacốp, alứng máh ticuoi tang ngcang Yang Arbang-pilŏ́ng, át tớq ntúq Yang Arbang-pilŏ́ng sút, ma inha át culái tieh, lớiq têq mot. ");
INSERT INTO pac_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bôn máh ticuoi tớq te anga pandang ngốh, anga pandang pát, anga tanieng alứng anga tadưp. Nha-án bôn ticu cha tớq ntúq Yang Arbang-pilŏ́ng sút tớq pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Máh nha-án ndon két hoi-ndô, chô-mát nha-án cơt pưt loi. Alứng máh nha-án ndon pưt hoi-ndô, chô-mát nha-án cơt két loi.” ");
INSERT INTO pac_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ndóng ngki bôn máh ticuoi te top Pha-rasi tớq nga Yê-su alứng tông án idô: “Cóq thới ngốh te ntúq ndô, pôq nga ntúq cannŏ́h loi, co puo Hê-rôt An-tipa ính cachet thới.” ");
INSERT INTO pac_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma Yê-su ôi nha-án idô: “Inha pôq nga Hê-rôt ndon ính lư tarthu, alứng tông án idô: ‘Nnáng biq ingái sớng cư chuih angốh yang saq alứng táq bánh máh nốh ticuoi a-ái. Tớq cư táq cua nhéq máh arnáq cư, cư lư cuchet.’ ");
INSERT INTO pac_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ma hoi-ndô alứng urớh, cóq cư veng ngê Yang Arbang-pilŏ́ng, dyơ sớr nga vel Yaru-salem, co ticuoi tang ngcang Yang Arbang-pilŏ́ng lớiq têq cuchet culái tieh vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ơ vel Yaru-salem, inha ndon át tớq vel Yaru-salem ơi! Inha la ticuoi báq cachet ticuoi tang ngcang alứng tíq búl ada máh ticuoi ndon Yang Arbang-pilŏ́ng yua dyôn tớq nga inha. Bôn a-ưi chư dyơ cư ính pachúng parŏm nhéq máh inha arớq ntruoi cán catrốc arô acái án dyôn át tadưp nnár án. Ma inha lớiq ính! ");
INSERT INTO pac_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hoi-ngki cư lớiq pôq cláh clơ nnáng abŏ́h inha. Cư tông inha idô: Urớh inha lớiq bôn hôm nnáng cư, tingôi ingái inha tông idô: ‘Bún lư án ndon tớq nhơ nốh Ưlla he.’” ");
INSERT INTO pac_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bôn mui Ingái Angô, Yê-su pôq cha mui pêl tớq dúng munáq ticuoi sút top Pha-rasi. Máh ticuoi át tớq ngki me níc nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ticớr bôn munáq conh a-ái áih tớq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yê-su plốh máh thới sái rit alứng máh ticuoi Pha-rasi idô: “Veng rit he, têq he táq bánh ticuoi a-ái tớq Ingái Angô lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nha-án át parvưl sớng, lớiq bôn ôi amớh. Iki Yê-su tec ticuoi a-ái ngki alứng táq bánh. Dyơ Yê-su yua án chô. ");
INSERT INTO pac_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cua ngki Yê-su tông idô: “Khán bôn munáq te inha bôn acái conh lớiq la carrŏ́q ma arbúc tớq dơq yieng tớq Ingái Angô, inha lư lúq asớr ndóng ngki táp, piaiq lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma nha-án lớiq têq ôi Yê-su amớh te callong ngki. ");
INSERT INTO pac_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yê-su hôm máh ticuoi tumoi rêh ntúq ticu pa tanieng. Iki án tông nha-án tớq parnai acám idô: ");
INSERT INTO pac_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tớq ngai mơi inha pôq arieu, inha êq suo ntúq ticu pa tanieng. Dáh lơ bôn munáq pưt hơn te inha tớq tưi. ");
INSERT INTO pac_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Iki ticuoi ndon mơi inha tớq alứng tông inha idô: ‘Inha tôi te ndô, dyôn ticuoi ndô loi ticu.’ Callong ngki táq dyôn inha cơt achiet, alứng inha cóq pôq ticu pa tadưp loi. ");
INSERT INTO pac_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma khán ngai mơi inha, ŏ lư la inha át pa tadưp. Dyơ án ndon mơi inha tớq alứng tông inha idô: ‘Ai ơi! Seq ai sớr ticu pa tanieng.’ Iki án ndon mơi inha apáh án dyám náp inha chứng mát máh ticuoi tumoi. ");
INSERT INTO pac_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Co ticuoi mmo asớr cháq bôm, urớh án lư cơt két. Ma ticuoi mmo asiar cháq bôm, urớh án lư cơt pưt.” ");
INSERT INTO pac_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Cua ngki Yê-su tông ticuoi ndon mơi án idô: “Ndóng mái ính táq mui pêl cha bui tớq iláih lớiq la ibư, mái êq mơi yớu, lớiq la em ai, lớiq la ticuoi súc tớq vel mái. Dáh lơ nha-án ính mơi mái tưi, dŏq culieh dơq mái khoiq mơi nha-án. ");
INSERT INTO pac_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma tớq mái táq mui pêl cha bui, cóq mái mơi máh ticuoi kidit, máh ticuoi tarliaih, máh ticuoi dyuat, alứng máh ticuoi sot mát. ");
INSERT INTO pac_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dyơ mái bôn callong bún a-ưi, co máh ticuoi ngki ớq amớh ính culieh dyôn mái. Ma lư Yang Arbang-pilŏ́ng táp culieh cống mái tang nha-án tớq ingái ticuoi tinớng ŏ tumống lieh te cuchet.” ");
INSERT INTO pac_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bôn munáq ticu cha ntúq ngki sáng Yê-su tông iki, dyơ án tông Yê-su idô: “Bún lư nha-án ndon bôn cha tanna tớq ntúq Yang Arbang-pilŏ́ng sút!” ");
INSERT INTO pac_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Yê-su ôi án idô: “Bôn munáq conh táq mui pêl bui, alứng án mơi clứng ticuoi tớq cha. ");
INSERT INTO pac_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tớq ngư cha, án yua tampeng án pôq cớiq máh ticuoi khoiq án mơi idô: ‘Inha tớq cha! Khoiq cua dyơ he thuan tanna!’ ");
INSERT INTO pac_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ma máh ticuoi ndon án khoiq mơi arớq nha-án bôn mui mít lớiq ính pôq. Bôn munáq te top nha-án tông idô: ‘Cư khoiq plới mui tám cuteq dŏq táq pidái. Cư seq luaih, cư cóq pôq me!’ ");
INSERT INTO pac_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Bôn munáq loi tông idô: ‘Cư khoiq plới sông cu carrŏ́q. Cư seq luaih, cư cóq pôq me carrŏ́q.’ ");
INSERT INTO pac_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Alứng bôn munáq loi tông idô: ‘Cư mbơiq ial campái. Iki cư lớiq têq pôq.’ ");
INSERT INTO pac_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dyơ tampeng ngki chô tông lieh ưlla án máh callong nha-án tông. Ưlla ngki sáng uan lư, dyơ án yua tampeng án idô: ‘Mái pôq chái nga máh carna alứng cứp paryéh tớq vel; pôq mơi máh ticuoi kidit, máh ticuoi dyuat, alứng máh ticuoi sot mát, dyôn tớq nga tudô.’ ");
INSERT INTO pac_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tớq tampeng ngki chô, án tông idô: ‘Ưlla ơi! Cư khoiq táq arớq ưlla yua, ma tớq dúng ưlla yôl bôn ntúq át.’ ");
INSERT INTO pac_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dyơ ưlla ngki yua tampeng án idô: ‘Mái ngốh te vel, pôq nga carna pưt alứng cứp paryéh két hơ. Khán mái tumúh ticuoi mmo, dyôn mái cucúh cucuoi mơi ticuoi ngki tớq, dŏq táq dyôn tot dúng cư. ");
INSERT INTO pac_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma máh ticuoi cư khoiq mơi te nsuoi tơ va munáq têq tớq cha bui tớq dúng cư.’” ");
INSERT INTO pac_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bôn clứng ticuoi pôq munơi alứng Yê-su. Dyơ án píh me nga nha-án alứng tông idô: ");
INSERT INTO pac_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Khán ticuoi mmo ính veng ngê cư, ma ticuoi ngki amoih a-i a-ám án, lớiq la acái campái án, lớiq la em ai ơi án, lớiq la amoih tarngứh án bôm hơn te án amoih cư, ticuoi ngki lớiq têq veng ngê cư. ");
INSERT INTO pac_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ticuoi mmo lớiq ial dual along calláng án bôm, alứng lớiq veng tapun cư simớt lư, ticuoi ngki lớiq têq cơt ticuoi rian te cư. ");
INSERT INTO pac_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Khán bôn munáq te inha ma ính táq mui lám dúng pưt, tôm lư án cóq tíng te máh along ale kire ntớng, alứng parngíh án bôn khám ma lớiq. ");
INSERT INTO pac_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Khán án lớiq táq iki, dáh lơ tớq án pitứng dúng, ma lớiq khám máh crơng ính táq dyôn dyơ. Tớq cứp náq ticuoi hôm dúng ngki lớiq dyơ, nha-án ính cacháng ayê án, ");
INSERT INTO pac_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nha tông idô: ‘Ticuoi ndô khoiq táq dúng, ma lớiq cơt dyơ nnáng!’ ");
INSERT INTO pac_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Alứng khán bôn puo ndon bôn mui van líng, ma án ính pôq chíl puo ndon bôn bar van líng, tôm lư puo ngki cóq parngíh imo án ính táq dyôn bôn rap. ");
INSERT INTO pac_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Khán án chom lớiq têq rap, ndóng puo cannŏ́h yôl át yông, án cóq yua máh tampeng án pôq seq te puo ngki êq chíl nnáng, ma dyôn át artoi. ");
INSERT INTO pac_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Muchứng ngki tưi, khán bôn ticuoi te inha ma lớiq táh cứp nốh án bôn, án lớiq têq cơt ticuoi rian te cư. ");
INSERT INTO pac_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Boi la crơng ŏ. Ma khán boi cơt atieh, imo ính táq dyôn cơt báq lieh? ");
INSERT INTO pac_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lớiq têq ial boi ngki cacháq tớq cuteq, lớiq la cacháq tớq créq pannán dŏq táq phún. Nưm cóq adúh táh. Ticuoi mmo bôn cutor ính cammáng, ngki dyôn án cammáng!” ");
INSERT INTO pac_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bôn máh ticuoi ial práq thêq alứng ticuoi luaih cannŏ́h hơ tớq ính cammáng Yê-su cato. ");
INSERT INTO pac_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Máh ticuoi Pha-rasi alứng máh thới sái rit tíq Yê-su idô: “Ticuoi ndô át munơi alứng ticuoi luaih, nha chicha alứng nha-án hơ.” ");
INSERT INTO pac_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dyơ Yê-su cato nha-án tớq parnai acám idô: ");
INSERT INTO pac_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Khán bôn munáq te inha bôn mui culám cưu ma pít mui lám, lư án dŏq tikiaih chít tikiaih lám tớq rong sác. Dyơ án pôq suo táp mui lám cưu ngki tingôi án tumúh lieh, lư lớiq? ");
INSERT INTO pac_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tớq án tumúh lieh cưu ngki, án sáng bui lư. Dyơ án arơq cưu ngki dual tớq tarlang, ");
INSERT INTO pac_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","alứng dông achô nga dúng. Vít ngki án arô yớu án alứng tông idô: ‘Seq inha tớq, alứng sŏ́ng bui munơi alứng cư! Co cư khoiq tumúh lieh dyơ cưu ndon pít.’ ");
INSERT INTO pac_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Cư tông inha idô: Muchứng parnai acám ndô, Yang Arbang-pilŏ́ng sáng bui lư khán bôn munáq ticuoi luaih ma ngin luaih pien cơt mít tamme loi. Yang Arbang-pilŏ́ng sáng bui te munáq ngki hơn te án sáng bui te tikiaih chít tikiaih náq ndon parngíh nha-án tinớng ŏ, alứng lớiq cóq pien cơt mít tamme loi.” ");
INSERT INTO pac_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Lớiq la khán bôn munáq cán bôn mui chít callong práq, ma pít mui callong, amớh án táq? Án lư bet den tớu, prêh dúng, alứng suo me nhéq tớq máh tol dúng tingôi án bôn tumúh lieh práq ngki. ");
INSERT INTO pac_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tớq án tumúh, án lư arô máh yớu alứng tông idô: ‘Seq inha tớq, alứng sŏ́ng bui munơi alứng cư! Co cư khoiq tumúh lieh práq ndon pít.’ ");
INSERT INTO pac_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cư tông inha idô: Muchứng parnai acám ndô, máh tarneng Yang Arbang-pilŏ́ng sáng bui lư khán bôn munáq ticuoi luaih tớq ngin luaih pien cơt mít tamme loi.” ");
INSERT INTO pac_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yê-su tông loi idô: “Bôn munáq a-ám ndon bôn bar lám acái conh. ");
INSERT INTO pac_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Acái tuloiq seq te a-ám án idô: ‘A-ám ơi! Cư seq mái mpô máh mun mái dyôn he. Cư ính bôn phê cư hoi-ndô táp.’ Iki a-ám nha-án mpô mun án dyôn bar náq acái án. ");
INSERT INTO pac_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma lớiq dưnh, acái tuloiq ngki ial crơng crớu, dyơ án pôq. Án ngốh te cruong án, pôq cuang nga cruong yông. Át ngki án talóh nhéq tien práq. ");
INSERT INTO pac_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tư án tớc cha séch nhéq práq án, ma tớq cruong ngki piaiq pinhaih lư. Dyơ án tabớq ớq tưi. ");
INSERT INTO pac_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Án seq thuthe te munáq ticuoi tớq cruong ngki, dyơ ticuoi ngki yua án pôq nga rong sác alứng bán alic. ");
INSERT INTO pac_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Án sáng pinhaih lư. Án ính cha tanna alic, ma ngai lớiq dyôn án cha. ");
INSERT INTO pac_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iki án srúh parngíh alứng ayư lieh idô: ‘Ơ nga dúng a-ám cư bôn clứng ticuoi thuthe. Nha-án cha dôi ngốh clưi cliai. Ma cư tumán cuchet tarriat. ");
INSERT INTO pac_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cư ính píh chô lieh nga a-ám cư, alứng tông án idô: “A-ám ơi! Cư táq luaih ada Yang Arbang-pilŏ́ng alứng ada mái hơ. ");
INSERT INTO pac_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cư la ticuoi lớiq ŏ. Seq a-ám êq dŏq nnáng cư la acái. Ma seq a-ám dyôn cư cơt arớq ticuoi thuthe tưi.”’ ");
INSERT INTO pac_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ndóng ngki táp án yôr tayứng alứng píh chô nga a-ám án. “Ndóng án nnáng át te yông, a-ám án hôm arớq-rớq. A-ám án sáng sruiq táq, dyơ a-ám án pilŏ́ng nga án, kiau alứng honh hit án. ");
INSERT INTO pac_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Án tông a-ám án idô: ‘A-ám ơi! Cư khoiq táq luaih ada Yang Arbang-pilŏ́ng alứng ada mái hơ. Cư la ticuoi lớiq ŏ, alứng lớiq díh piaiq a-ám dŏq cư la acái.’ ");
INSERT INTO pac_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma a-ám án yua ticuoi sol idô: ‘Áu, inha táq adứh! Dông au dêu ŏ clưi nhéq te cannŏ́h asứp án. Ial tammiat tamiat tớq ati án, alứng patruq cơp tớq dyưng án. ");
INSERT INTO pac_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Alứng inha cŏp acái carrŏ́q plứm alứng kiac. He cha. He bui ơn, ");
INSERT INTO pac_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","co acái cư ndô arớq án khoiq cuchet, ma hoi-ndô arớq án bôn tumống lieh. Te nsuoi án khoiq pít, ma hoi-ndô cư tumúh lieh!’ Iki nha-án cha bui ơn lư. ");
INSERT INTO pac_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ndóng ngki ai pông yôl táq pidái. Tư án chô tumán ính tớq dúng, án sáng sieng nha-án cứh, nha-án pon liauq. ");
INSERT INTO pac_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Án arô munáq ticuoi thuthe, alứng plốh idô: ‘Amớh ngai táq?’ ");
INSERT INTO pac_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ticuoi ngki ôi: ‘A-em mái chô. A-ám mái khoiq kiac acái carrŏ́q plứm, co acái án chô bánh suanh.’ ");
INSERT INTO pac_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iki án sáng nháih lư. Án lớiq ính mot nnáng tớq dúng. Dyơ a-ám án ngốh khêr án. ");
INSERT INTO pac_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Án tông ada a-ám án idô: ‘Lớiq chom sếq cumo ndô dyơ cư táq arnáq arớq ticuoi sol dyôn mái. Amớh mái yua cư táq, cư táq ngki. Ma mái lớiq nai dyôn cư mui lám acái mbeq dŏq cư cha bui alứng yớu. ");
INSERT INTO pac_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma hoi-ndô acái tuloiq mái chô, alứng án khoiq talóh nhéq máh tien práq mái nga máh cán táiq cháq. Ma yôl mái kiac acái carrŏ́q plứm dyôn án.’ ");
INSERT INTO pac_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A-ám án ôi idô: ‘Acái ơi! Mái ngki át níc alứng cư. Nhéq máh crơng cư la cơt na mái. ");
INSERT INTO pac_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma he cóq táq bui ŏ, co a-em mái arớq án khoiq cuchet, ma hoi-ndô arớq án tumống lieh. Arớq án khoiq pít, ma hoi-ndô he bôn tumúh lieh.’” ");
INSERT INTO pac_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yê-su tông top rian te án idô: “Bôn munáq conh súc ndon bôn munáq ticuoi tampeng kiaq me mun án. Ma ngai cauq tampeng ngki talóh máh mun ưlla án. ");
INSERT INTO pac_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dyơ ưlla ngki arô án, alứng plốh án idô: ‘Amớh cư sáng ngai táq-ntêr mái táq lớiq ŏ ada cư? Mái lái lieh te arnáq mái kiaq me máh mun cư, co mái lớiq têq cơt nnáng ticuoi kiaq me máh mun cư.’ ");
INSERT INTO pac_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iki tampeng ngki parngíh idô: ‘Ưlla cư tumán ính táh cư. Án lớiq dyôn cư kiaq me nnáng mun án. Imo cư ính táq hoi-ndô? Cư ớq bánh rêng dŏq táq pidái. Khán pôq suseq, ngki cư achiet táq ngai. ");
INSERT INTO pac_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hoi-ndô cư chom dyơ amớh cư ính táq. Dyơ tớq ingái cư lớiq bôn cơt nnáng ticuoi kiaq me mun án, ingái ngki cư nnáng bôn yớu ndon ráp cư, alứng dyôn cư át tớq dúng nha-án.’ ");
INSERT INTO pac_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Iki án arô máh ticuoi tu ưlla án, alứng án plốh ticuoi ndon tớq nsuoi idô: ‘Máh-mmo mái tu ưlla cư?’ ");
INSERT INTO pac_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ticuoi ngki ôi: ‘Cư tu mui culám calung tớu o-li-vê.’ Án tông idô: ‘Dyơ! Cư dyôn mái tu sông chít calung sớng.’ ");
INSERT INTO pac_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dyơ án plốh ticuoi cannŏ́h loi idô: ‘Ma mái, máh-mmo mái tu?’ Ticuoi ngki ôi: ‘Cư tu mui culám tanic sro.’ Iki án tông idô: ‘Cư dyôn mái tu ticol chít tanic sớng.’ ");
INSERT INTO pac_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Vít ngki, ưlla ngki ayô ticuoi kiaq me ndon saq ngki, co án táq tubáiq. Máh ticuoi lớiq veng ngê Yang Arbang-pilŏ́ng báq táq ada yớu nha-án tubáiq hơn te ticuoi ndon veng ngê Yang Arbang-pilŏ́ng báq táq ada yớu nha-án. ");
INSERT INTO pac_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Cư tông inha loi idô: Khán inha bôn a-ưi crơng ntưn, cóq inha dyôn ticuoi cannŏ́h hơ; iki máh crơng ngki táq dyôn inha bôn a-ưi yớu. Dyơ tớq ingái ntưn inha pít nhéq, ingái ngki Yang Arbang-pilŏ́ng ính dyôn inha át tớq ntúq têq tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Khán inha táq tinớng tupứng te arnáq két, inha lư táq tinớng tupứng tưi te arnáq pưt. Alứng khán inha táq lớiq tinớng tupứng te arnáq két, inha lư táq lớiq tinớng tupứng tưi te arnáq pưt. ");
INSERT INTO pac_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Iki khán inha lớiq táq tinớng tupứng te ntưn inha tớq pang ndô, imo têq Yang Arbang-pilŏ́ng dyôn inha bôn mun ndon lớiq nai pít tớq pilŏ́ng? ");
INSERT INTO pac_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Alứng khán inha lớiq táq tinớng tupứng te crơng ngai cơiq nga inha, ngki lư lớiq bôn ngai ính mŏp crơng dyôn inha cơt ưlla. ");
INSERT INTO pac_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Lớiq bôn ngai têq cơt sol dyôn bar ưlla. Piaiq án a-ính ưlla ndô, ma amoih ưlla ntíh; lớiq la án dyám ưlla ndô, ma pamat ưlla ntíh. Muchứng ngki tưi, inha lớiq têq veng ngê Yang Arbang-pilŏ́ng alứng ngê ham ntưn tớq pang ndô trap munơi.” ");
INSERT INTO pac_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Máh ticuoi Pha-rasi ndon sáng Yê-su tông iki, nha-án ayê Yê-su, co nha-án ayáu máh crơng ntưn tớq pang ndô. ");
INSERT INTO pac_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yê-su tông ada nha-án idô: “Inha táq arnáq ính ngai tông inha la ticuoi tinớng ŏ, ma Yang Arbang-pilŏ́ng chom mít cannính inha. Nốh amớh ticuoi báq parngíh ŏ lư, nốh ngki lớiq ŏ amớh chứng mát Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Yang Arbang-pilŏ́ng cato ticuoi na phep rit Môi-se alứng na máh parnai ticuoi tang ngcang án tingôi tớq pang Yon táq tíc na dơq. Tớq vít pang Yon, bôn ngai cato parnai ŏ te Yang Arbang-pilŏ́ng cơt sút. Alứng cứp náq ticuoi ính lư mot tớq top Yang Arbang-pilŏ́ng sút, ma nha-án parngíh nha-án têq mot co nhơ te rêng nha-án bôm. ");
INSERT INTO pac_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pilŏ́ng alứng cuteq cơt pít la ien hơn te mui callong te phep rit Yang Arbang-pilŏ́ng cơt pít. ");
INSERT INTO pac_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ticuoi mmo táh campái, dyơ ial campái tamme, arnáq ngki la arớq án láh parlưi. Alứng khán ticuoi mmo ial cán rang, arnáq ngki la arớq án láh parlưi tưi.” ");
INSERT INTO pac_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Bôn munáq conh súc; án sứp au dêu lư, alứng cứp ingái án tớc cha thưong. ");
INSERT INTO pac_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Alứng bôn munáq conh kidit, nốh La-sarơ. Ngai dông dŏq án át culái tieh dúng ticuoi súc ngki, tumán ngáh callống. Cháq án máng mpeh. ");
INSERT INTO pac_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Án ngcong bôn cha tanna sráh atôh te kichơng ticuoi súc. Alứng bôn acho tớq iel mpeh án. ");
INSERT INTO pac_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Vít ngki án cuchet, alứng bôn tarneng Yang Arbang-pilŏ́ng dông án dyôn át munơi alứng A-praham. Tớq tatun, ticuoi súc ngki cuchet tưi, alứng ngai dông tứp. ");
INSERT INTO pac_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tư ticuoi súc ngki át tớq ntúq uih chéh níc-níc án sáng dieiq arức lư. Iki án tingưi asớr, án hôm A-praham át yông lư te án. Alứng án hôm La-sarơ át munơi alứng A-praham. ");
INSERT INTO pac_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iki án arô yứng lư idô: ‘Ơ A-praham la achúc achiac cư ơi! Seq inha sruiq táq cư hơ. Seq inha yua La-sarơ tớq nga cư, alứng dyôn án talứm ati án tớq dơq, dyơ tadyŏ́h tớq ntaq cư, co cư sáng dieiq arức lư tớq uih ndô!’ ");
INSERT INTO pac_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ma A-praham ôi án idô: ‘Acái ơi! Mái ayư lieh te ndóng mái yôl tumống, mái khoiq thưong lư, ma La-sarơ ngki kidit alứng dieiq arức lư. Hoi-ndô án bôn át tớq ntúq ndô ien ŏ; ma mái át tớq ntúq ngki dieiq arức lư. ");
INSERT INTO pac_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Alứng mui callong loi, bôn tanor sru alứng pơh lư pandi he. Ticuoi mmo ính dyang te ntúq he pôq nga mái, la lớiq têq. Alứng ticuoi mmo ính dyang te ntúq mái pôq nga he, la lớiq têq tưi.’ ");
INSERT INTO pac_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dyơ ticuoi súc ngki tông loi idô: ‘Khán iki, cư seq inha yua La-sarơ pôq nga dúng a-ám cư, ");
INSERT INTO pac_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","co cư yôl bôn sông náq em ai át ngki. Dyôn La-sarơ catớih nha-án, dŏq nha-án lớiq át tớq ntúq dieiq arức lư ndô.’ ");
INSERT INTO pac_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma A-praham tông idô: ‘Em ai mái khoiq bôn parnai Môi-se tông, alứng parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh tông. Dyôn em ai mái cammáng alứng peh parnai nha-án.’ ");
INSERT INTO pac_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ticuoi súc ngki tông loi idô: ‘Ơ A-praham la achúc achiac cư ơi! Nha-án lư lớiq cammáng parnai máh ticuoi ngki. Ma khán ticuoi cuchet bôn tumống lieh pôq tông nha-án, lư nha-án pien cơt mít tamme loi.’ ");
INSERT INTO pac_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma A-praham tông lieh án idô: ‘Khán em ai mái lớiq cammáng parnai Môi-se alứng máh ticuoi tang ngcang khoiq tông, nha-án lư lớiq náp tưi ticuoi cuchet ma tumống lieh.’” ");
INSERT INTO pac_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yê-su tông top rian te án idô: “Lư bôn a-ưi nốh ính tardông ticuoi táq luaih, ma bap lư tớq nga ticuoi ndon tardông ngki. ");
INSERT INTO pac_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Khán ticuoi ngki tardông munáq ngai-acái dyôn lớiq tin nnáng cư, ŏ hơn la ngai tacoi búl pưt tớq ticong án, alứng apŏ́ng án tớq dơq ving-cavang te nsuoi án ính tardông ngai-acái. ");
INSERT INTO pac_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Inha me a-ŏ mít cannính inha bôm! Khán yớu inha táq luaih ada inha, cóq inha dyŏq án. Alứng khán án ngin luaih, cóq inha táh luaih dyôn án. ");
INSERT INTO pac_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Khán yớu inha táq luaih ada inha tupul chư tớq mui ingái, ma khán án tớq ngin kho inha tớq tupul chư tưi idô: ‘Seq mái táh luaih cư nư,’ iki cóq inha táh luaih dyôn án.” ");
INSERT INTO pac_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Top dyưng ati Yê-su seq idô: “Seq Ưlla táq dyôn he tin a-ưi lư loi.” ");
INSERT INTO pac_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yê-su tông nha-án idô: “Khán inha bôn callong tin két ali mui callong me, lư têq inha yua tôm along idô: ‘Along ơi, mái rưc bôm tôm mái, dyơ mái chóh bôm tớq dơq ving-cavang,’ tôm along ngki lư peh inha.” ");
INSERT INTO pac_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Khán munáq te top inha bôn sol tal pidái, lớiq la bán pannán cưu, tớq sol ngki chô ibư, ưlla án lớiq bôn tông ada án idô: ‘Áu mái mot cha avai.’ ");
INSERT INTO pac_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma ưlla án báq tông idô: ‘Áu mái táq tanna dyôn cư. Alứng mái thái tampớc, dyơ mái át hớu cư tingôi cư cha dyơ. Vít ki-náq têq mái cha.’ ");
INSERT INTO pac_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Alứng ưlla ngki lớiq bôn si-ơn ticuoi sol, co sol ngki peh parnai án yua. ");
INSERT INTO pac_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma inha la muchứng sol ngki tưi. Tớq inha táq cua máh arnáq Yang Arbang-pilŏ́ng yua inha táq, cóq inha tông idô: ‘He la sol Yang Arbang-pilŏ́ng. He lớiq ngcong án ayô he, co he táq nưm arnáq án yua he táq sớng.’” ");
INSERT INTO pac_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ndóng Yê-su pôq nga vel pưt Yaru-salem, án pôq pha carlớn vúng Sa-mari alứng vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ndóng án chón mot tớq vel, án tumúh mui chít náq ticuoi a-ái bŏ́q. Nha-án át yông te án. ");
INSERT INTO pac_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nha-án arô yứng lư idô: “Ưlla Yê-su ơi! Sruiq táq he hơ!” ");
INSERT INTO pac_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tư Yê-su hôm nha-án, dyơ án tông idô: “Inha pôq apáh cháq inha dyôn ticuoi teng rit sang me arớq phep rit Môi-se khoiq patáp.” Ndóng nha-án pôq, nha-án cơt bánh a-ái bŏ́q. ");
INSERT INTO pac_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bôn munáq te top mui chít náq ngki, tư án hôm án khoiq bánh dyơ, iki án píh lieh nga Yê-su, alứng si-ơn Yang Arbang-pilŏ́ng yứng lư. ");
INSERT INTO pac_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Án cucúh mpop chứng mát Yê-su alứng si-ơn Yê-su. Án la ticuoi Sa-mari. ");
INSERT INTO pac_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yê-su plốh idô: “Bôn mui chít náq khoiq cơt bánh, piaiq lớiq? Ma tumo dyơ nha-án tikiaih náq ngki? ");
INSERT INTO pac_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nưm munáq ndô táp tớq si-ơn Yang Arbang-pilŏ́ng. Alứng án la ticuoi te cruong cannŏ́h.” ");
INSERT INTO pac_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dyơ Yê-su yua án idô: “Mái yôr tayứng. Co mái tin, mái cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bôn ticuoi te top Pha-rasi plốh Yê-su, nnáng máh-mmo dưnh náq Yang Arbang-pilŏ́ng cơt sút? Yê-su ôi nha-án idô: “Yang Arbang-pilŏ́ng cơt sút la án lớiq bôn apáh tíc dyôn ticuoi hôm arlớih arlêng. ");
INSERT INTO pac_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Lớiq bôn ngai têq tông idô: ‘Ndô! Yang Arbang-pilŏ́ng cơt sút tớq ntúq tudô, lớiq la ntúq tuki!’ Ngai lớiq têq tông iki, co Yang Arbang-pilŏ́ng cơt sút la tớq mít cannính inha.” ");
INSERT INTO pac_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dyơ Yê-su tông top rian te án idô: “Urớh, tớq ingái inha ính lư hôm Acái Yang Cơt Ticuoi át tớq cúc cuteq ndô, nưm mui ingái sớng la piaiq táp, ma inha lớiq bôn hôm. ");
INSERT INTO pac_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bôn ticuoi cannŏ́h ính tông ada inha idô: ‘Acái Yang Cơt Ticuoi át ntúq tudô, lớiq la át ntúq tuki.’ Ma inha êq pôq, alứng êq náp parnai nha-án. ");
INSERT INTO pac_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Arớq lilaiq cáng tớq pilŏ́ng te pứp ndô tớq pứp ntíh, cư Acái Yang Cơt Ticuoi tớq la muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma nsuoi ingái ngki tớq, cư cóq chiuq a-ưi nốh dieiq arức, alứng máh ticuoi tớq pang ndô lớiq ráp cư. ");
INSERT INTO pac_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ingái cư Acái Yang Cơt Ticuoi tớq lieh nga cúc cuteq ndô la arớq pang Nô-ê te inớh tưi. ");
INSERT INTO pac_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tớq pang Nô-ê, cứp náq ticuoi cha ngoiq bui lư, alứng nha-án ial campái muchứng te nling tingôi tớq ingái Nô-ê sớr tớq tuoc. Dyơ dơq arlám tớq, alứng cứp náq ticuoi tớq pang ngki cuchet nhéq. ");
INSERT INTO pac_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Alứng ngư cư Acái Yang Cơt Ticuoi tớq lieh la arớq tớq pang Lot te inớh. Máh ticuoi tớq pang ngki cha ngoiq bui ơn, nha-án táiq plới, chớt choi, alứng táq dúng pidái. ");
INSERT INTO pac_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma ingái Lot ngốh te vel Sadôm, Yang Arbang-pilŏ́ng apŏ́ng cachie alứng pla uih cơt arớq bo atốh te pilŏ́ng, dyơ cứp náq ticuoi tớq vel ngki cuchet nhéq. ");
INSERT INTO pac_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ingái cư Acái Yang Cơt Ticuoi tớq la muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Tớq ingái ngki, ticuoi mmo át tớq mpuong dúng, cóq án êq siar alứng mot ial nnáng crơng te dúng. Ticuoi mmo át táq pidái, cóq án êq chô ial nnáng crơng te dúng. ");
INSERT INTO pac_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cóq inha ayư lieh te campái Lot te inớh! ");
INSERT INTO pac_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ticuoi mmo ayáu tarngứh, tarngứh ticuoi ngki lư pít. Ma ticuoi mmo chiuq pít tarngứh, tarngứh ticuoi ngki lư lớiq nai pít. ");
INSERT INTO pac_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Cư tông inha arlớih lư, tớq idáu ngki bôn bar náq bíq mui ntúq. Yang Arbang-pilŏ́ng ial dông munáq; ma munáq loi, án dŏq. ");
INSERT INTO pac_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Alứng bôn bar náq cán chón cuclóh sro. Yang Arbang-pilŏ́ng ial dông munáq, ma munáq loi, án dŏq. ");
INSERT INTO pac_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Alứng bôn bar náq conh át tớq pidái. Yang Arbang-pilŏ́ng ial dông munáq; ma munáq loi, án dŏq.” ");
INSERT INTO pac_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cua Yê-su tông iki, top rian te án plốh idô: “Ưlla ơi! Arnáq ndô ính tớq nga ntúq mmo?” Yê-su ôi nha-án tớq parnai acám idô: “Ntúq mmo bôn ticuoi cuchet, ntúq ngki lư bôn calang srúp rum cha sáiq cumuiq.” ");
INSERT INTO pac_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dyơ Yê-su cato top rian te án tớq mui parnai acám, co án ính nha-án chom cóq nha-án cớu níc alứng êq pê cannính. ");
INSERT INTO pac_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Án tông idô: “Tớq mui vel bôn munáq ticuoi tarsưq. Án lớiq adáh Yang Arbang-pilŏ́ng alứng lớiq dyám náp ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tớq vel ngki bôn munáq cán cammai. Án tớq níc nga ticuoi tarsưq, alứng án tông idô: ‘Seq avốq sưq tinớng tupứng dyôn cư alứng ticuoi ndon táq cư!’ ");
INSERT INTO pac_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Khoiq dưnh lư dyơ án táq iki, ma ticuoi tarsưq lớiq cammáng. Ma bôn mui ingái, ticuoi tarsưq parngíh idô: ‘Cư lớiq adáh Yang Arbang-pilŏ́ng, alứng cư lớiq dyám náp díh ticuoi hơ. ");
INSERT INTO pac_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ma co cán cammai ndô tớq seq níc te cư, iki cư choi án. Khán cư lớiq choi, án lư tớq pidieiq níc cư, alứng táq dyôn cư sáng ngới!’” ");
INSERT INTO pac_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dyơ Yê-su tông loi idô: “Inha sáng ma lớiq te parnai ticuoi tarsưq ngki tông? Án sưq, ma sưq lớiq tinớng tupứng. ");
INSERT INTO pac_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ma Yang Arbang-pilŏ́ng sưq la piaiq lư, án ính choi ticuoi veng ngê án, la ticuoi ndon arô án cứp ingái cứp idáu. Án lư tớq choi táp nha-án, alứng lớiq dyut. ");
INSERT INTO pac_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Alứng cư tông dyôn inha chom tưi, Yang Arbang-pilŏ́ng sưq tinớng tupứng lư dyôn máh ticuoi ndon veng ngê án, alứng án táq chái lư. Ma tư cư Acái Yang Cơt Ticuoi tớq lieh nga cúc cuteq ndô, cư bôn tumúh ticuoi ndon lư tin Yang Arbang-pilŏ́ng lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yê-su cato loi tớq parnai acám te máh ticuoi ndon parngíh nha-án tinớng ŏ alứng pamat ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Án tông idô: “Bôn bar náq conh mot tớq Dúng Sang Pưt ính cớu. Munáq la ticuoi Pha-rasi, munáq loi la ticuoi ial práq thêq. ");
INSERT INTO pac_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ticuoi Pha-rasi tayứng cớu iláq lư idô: ‘Cucúh Yang Arbang-pilŏ́ng ơi, cư si-ơn inha, co cư lớiq bôn táq luaih arớq ticuoi cannŏ́h. Cư lớiq bôn ham crơng. Cư lớiq bôn tarphíq tarthu ngai. Cư lớiq bôn tarpíh campái ngai. Cư si-ơn inha, cư lớiq cơt arớq ticuoi ial práq thêq ndô. ");
INSERT INTO pac_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cư ót tanna mui tún bar ingái. Alứng te máh mun cư, khán cư bôn mui chít phê, ngki cư mŏp sang mui phê dyôn inha.’ ");
INSERT INTO pac_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ma ticuoi ial práq thêq ngki át yông te ticuoi Pha-rasi. Án lớiq dáh tingưi nga pilŏ́ng. Án tứm apơm án bôm táq tíc án sáng anguaq lư. Alứng án tông idô: ‘Ơ Yang Arbang-pilŏ́ng ơi! Seq inha sruiq táq cư hơ, co cư la ticuoi luaih!’” ");
INSERT INTO pac_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Dyơ Yê-su tông idô: “Cư tông inha arlớih lư, ticuoi ial práq thêq ndô chô nga dúng, án lư cơt tinớng ŏ chứng mát Yang Arbang-pilŏ́ng. Ma ticuoi Pha-rasi ngki lớiq bôn tinớng ŏ amớh chứng mát Yang Arbang-pilŏ́ng. Khán ticuoi mmo asớr cháq bôm ính cơt pưt, urớh ticuoi ngki cơt két. Alứng ticuoi mmo asiar cháq dyôn cơt két hoi-ndô, urớh án lư cơt pưt.” ");
INSERT INTO pac_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bôn máh ticuoi dông ngai-acái nga Yê-su, co ính án capơiq tớq máh ngai-acái. Ma top rian te Yê-su dyŏq nha-án êq dông máh ngai-acái nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma Yê-su arô ngai-acái dyôn tớq nga án; dyơ án tông idô: “Inha dyôn ngai-acái tớq nga cư. Êq catáng nha-án, co tớq top Yang Arbang-pilŏ́ng sút bôn nưm ticuoi ndon bôn mít cannính arớq ngai-acái ndô. ");
INSERT INTO pac_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cư tông inha arlớih lư, ticuoi mmo lớiq sŏ́ng dyôn Yang Arbang-pilŏ́ng cơt sút arớq ngai-acái sŏ́ng, ticuoi ngki lớiq têq mot tớq top Yang Arbang-pilŏ́ng sút.” ");
INSERT INTO pac_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bôn munáq ticuoi sút tớq top Isa-ra-el tớq plốh Yê-su idô: “Thới ơi! Thới la lư ŏ. Amớh cóq cư táq dyôn têq bôn tumống níc-níc?” ");
INSERT INTO pac_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yê-su plốh lieh án: “Imo mái dŏq cư ŏ? Nưm Yang Arbang-pilŏ́ng táp ŏ. ");
INSERT INTO pac_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mái chom dyơ máh callong Yang Arbang-pilŏ́ng patáp idô: Êq láh parlưi; êq cachet ticuoi; êq titôiq; êq táq-ntêr a-uai; alứng cóq dyám náp a-i a-ám.” ");
INSERT INTO pac_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ticuoi ngki tông idô: “Cứp callong patáp ngki cư khoiq peh te ndóng cư yôl cháh-cucháh.” ");
INSERT INTO pac_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tư Yê-su sáng án tông iki, Yê-su tông lieh án idô: “Mái yôl clớiq mui nốh. Cóq mái chô táiq nhéq máh mun mái; dyơ ial práq ngki choi máh ticuoi kidit. Khán mái táq iki, mái lư bôn mun tớq pilŏ́ng. Dyơ cóq mái tớq alứng veng tapun cư.” ");
INSERT INTO pac_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma tư án sáng Yê-su tông iki, án sáng anguaq lư, co án la ticuoi súc. ");
INSERT INTO pac_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yê-su hôm án anguaq. Dyơ Yê-su tông loi idô: “Máh ticuoi súc, dieiq lư dyôn nha-án mot tớq top Yang Arbang-pilŏ́ng sút! ");
INSERT INTO pac_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pannán lac-da lŏt hŏ́ng tarúm la ien hơn te ticuoi súc ính mot tớq top Yang Arbang-pilŏ́ng sút.” ");
INSERT INTO pac_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Máh ticuoi ndon sáng Yê-su tông iki, nha-án plốh idô: “Khán iki, nnáu têq bôn tumống níc-níc?” ");
INSERT INTO pac_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yê-su ôi nha-án idô: “Ticuoi lớiq têq táq bôm arnáq ngki, ma Yang Arbang-pilŏ́ng têq táq cứp arnáq.” ");
INSERT INTO pac_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dyơ Phi-er tông Yê-su idô: “Ndô! He khoiq táh cứp nốh he bôn, co he ính veng tapun thới.” ");
INSERT INTO pac_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yê-su tông máh ticuoi ngki idô: “Cư tông inha arlớih lư, ticuoi mmo táh dúng su, táh a-i a-ám, táh em ai, alứng táh acái campái, co án ính Yang Arbang-pilŏ́ng cơt sút, ");
INSERT INTO pac_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","án lư bôn lieh tớq pang ndô a-ưi hơn te máh nốh án khoiq táh. Alứng chô-mát, án lư bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yê-su dông nưm top rian te án sớng, dyơ án tông nha-án idô: “Inha cammáng! He sớr nga vel Yaru-salem. Át tớq vel ngki, lư cơt tarvớiq máh parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh khoiq taran te Acái Yang Cơt Ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngai mŏp án nga ati ticuoi tới ticuoi Isa-ra-el. Nha-án ayê tar-ac án, acraiq án, alứng cuchóh tớq cháq án. ");
INSERT INTO pac_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nha-án prớih alứng cachet án. Ma catám ingái pe, án yôr tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma top rian te Yê-su lớiq apúh te parnai Yê-su tông, co parnai ngki sru lư. Iki nha-án lớiq chom arlớih callong amớh Yê-su chón tông. ");
INSERT INTO pac_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tư Yê-su tumán ính tớq vel Yê-ri-cô, bôn munáq conh sot mát át suseq tor carna. ");
INSERT INTO pac_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ndóng án sáng ticuoi clứng pôq pha tumán án, án plốh idô: “Bôn arnáq amớh?” ");
INSERT INTO pac_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Máh ticuoi ngki ôi: “Yê-su te vel Na-saret pôq pha tumán ndô.” ");
INSERT INTO pac_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Iki ticuoi sot ngki arô yứng lư idô: “Ơ Yê-su te tŏ́ng toiq Davit ơi! Seq Ưlla sruiq táq cư hơ.” ");
INSERT INTO pac_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ticuoi ndon pôq tớq carna dyŏq án êq tacang. Ma án arô yứng lư loi: “Ơ Ưlla te tŏ́ng toiq Davit ơi! Seq Ưlla sruiq táq cư hơ.” ");
INSERT INTO pac_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yê-su trín alứng yua ngai dông ticuoi sot ngki nga án. Tư ticuoi sot ngki tớq, án plốh: ");
INSERT INTO pac_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Amớh mái ính cư táq dyôn mái?” Ticuoi sot ôi Yê-su: “Ưlla ơi! Seq Ưlla táq dyôn mát cư cơt plang!” ");
INSERT INTO pac_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dyơ Yê-su tông án idô: “Áu, dyôn mát mái cơt plang! Co mái tin, mát mái cơt plang.” ");
INSERT INTO pac_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ndóng ngki táp mát án cơt plang. Dyơ án veng Yê-su alứng ayô Yang Arbang-pilŏ́ng. Tư ticuoi clứng hôm iki, nha-án ayô Yang Arbang-pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yê-su pôq pha pandi vel Yê-ri-cô. ");
INSERT INTO pac_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Át tớq vel ngki bôn munáq conh, nốh Sachê. Án la ticuoi sút máh ticuoi ial práq thêq, alứng án súc lư. ");
INSERT INTO pac_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Án ính me Yê-su. Ma án a-êp, iki án lớiq bôn hôm Yê-su, co ticuoi clứng dáh-cadíl án. ");
INSERT INTO pac_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iki án talúh pôq nsuoi máh ticuoi clứng. Dyơ án sớr tớq tôm along luah ính hôm Yê-su pôq pha tumán along ngki. ");
INSERT INTO pac_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ndóng Yê-su tớq nga ntúq tôm along ngki, án tingưi asớr, alứng án tông Sachê idô: “Sachê ơi! Mái siar achái, co ingái ndô cư cóq át tớq dúng mái.” ");
INSERT INTO pac_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Iki Sachê siar táp, alứng án ráp pasôl Yê-su bui ŏ lư. ");
INSERT INTO pac_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Máh ticuoi ndon hôm nhannha-nhannhóm idô: “Ticuoi ndô pôq át nga dúng ticuoi luaih.” ");
INSERT INTO pac_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma Sachê tayứng chứng mát nhéq máh ticuoi ngki, alứng án tông Yê-su idô: “Ưlla ơi! Máh mun cư, cư ial tadi dŏq choi máh ticuoi kidit. Alứng khán bôn ticuoi mmo cư khoiq lop án mui phê, hoi-ndô cư culieh lieh án puan phê.” ");
INSERT INTO pac_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yê-su tông án idô: “Ingái ndô Yang Arbang-pilŏ́ng choi tamống abŏ́h ndô, co án la te tŏ́ng toiq A-praham muchứng he tưi. ");
INSERT INTO pac_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Cư Acái Yang Cơt Ticuoi tớq nga ndô ính suo alứng ính choi tamống máh ticuoi khoiq clu carna.” ");
INSERT INTO pac_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Cua ngki, Yê-su cato tớq parnai acám sa ada ticuoi ndon khoiq sáng án tông iki. Án tumán ính tớq vel Yaru-salem dyơ, alứng máh ticuoi parngíh khoiq tumán tớq dyơ ingái Yang Arbang-pilŏ́ng cơt sút tớq cruong nha-án. ");
INSERT INTO pac_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iki Yê-su tông idô: “Bôn munáq ticuoi sút pôq nga cruong cannŏ́h, alứng ính máh ticuoi sút tớq cruong ngki chóh án cơt puo tớq cruong án bôm. Vít ngki án ính chô lieh nga cruong án. ");
INSERT INTO pac_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nsuoi án ính pôq, án arô mui chít náq ticuoi táq arnáq án. Án dyôn mui náq mui nen práq, alứng án patáp idô: ‘Inha táq imo dyôn práq ndô bôn lơi tingôi tớq ingái cư chô lieh.’ ");
INSERT INTO pac_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Máh ticuoi prái tớq cruong án, nha-án a-ính án, alứng lớiq ính án cơt puo nha-án. Iki nha-án yua ngai pôq tông ticuoi sút ndon ính chóh án dyôn cơt puo idô: ‘He lớiq ính ticuoi ndô cơt puo he.’ ");
INSERT INTO pac_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ma ticuoi ngki bôn cơt puo, dyơ án chô lieh nga cruong án. Án arô máh ticuoi táq arnáq án ndon khoiq ráp práq, co án ính chom máh-mmo a-ưi nha-án bôn lơi te práq ngki. ");
INSERT INTO pac_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ticuoi tớq nsuoi tông idô: ‘Ưlla ơi! Cư bôn lơi mui chít nen te mui nen ndon ưlla khoiq dyôn cư.’ ");
INSERT INTO pac_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ticuoi sút tông án idô: ‘Ŏ lư mái táq! Mái la ticuoi ŏ táq arnáq cư! Co mái táq ŏ te práq biq ndô, iki cư ính chóh mái dyôn cơt sút tớq mui chít vel.’ ");
INSERT INTO pac_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bôn munáq loi tớq, alứng tông idô: ‘Ưlla ơi! Cư bôn lơi sông nen te mui nen ndon ưlla khoiq dyôn cư.’ ");
INSERT INTO pac_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ticuoi sút ngki tông án idô: ‘Cư ính chóh mái dyôn cơt sút tớq sông vel.’ ");
INSERT INTO pac_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Alứng bôn munáq loi tớq, alứng tông idô: ‘Ưlla ơi! Ndô la práq nen ưlla khoiq dyôn cư. Cư cadyom dŏq práq ndô tớq prới. ");
INSERT INTO pac_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Cư adáh ưlla, co cư chom ưlla crêng lư. Ưlla lớiq táq, ma ưlla ính ial. Ưlla lớiq chớt, ma ưlla ính sot.’ ");
INSERT INTO pac_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ticuoi sút ngki tông ada án idô: ‘Mái la ticuoi lới lư ndon táq arnáq cư! Parnai mái tíq mái bôm. Mái khoiq chom dyơ cư ayáu práq cư. Alứng mái chom cư lớiq táq, ma cư ính ial. Cư lớiq chớt, ma cư ính sot. ");
INSERT INTO pac_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Khán iki, co imo mái lớiq dyôn ticuoi cannŏ́h váq práq cư. Dyơ tớq ingái cư chô lieh, cư bôn práq ngki alứng bôn lơi hơ.’ ");
INSERT INTO pac_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Vít ngki, ticuoi sút tông máh ticuoi át paniar ngki idô: ‘Ial lieh práq mui nen ngki te án. Dyơ dyôn nga ticuoi ndon bôn mui chít nen.’ ");
INSERT INTO pac_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ma máh ticuoi ngki tông ticuoi sút idô: ‘Ưlla ơi! Án khoiq bôn mui chít nen dyơ!’ ");
INSERT INTO pac_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma ticuoi sút ôi nha-án idô: ‘Án ndon bôn a-ưi, cư dyôn án bôn a-ưi lư loi. Ma án ndon lớiq bôn, cư dyôn án ớq lớng. ");
INSERT INTO pac_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma máh nha-án ndon lớiq ính cư cơt puo nha-án, dông nha-án tudô, alứng cachet nhéq nha-án chứng mát cư táp!’” ");
INSERT INTO pac_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cua Yê-su tông iki, án pôq carlíq máh ticuoi ndon pôq nga vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tư tumán ính tớq vel Bê-phayê alứng vel Bê-thani, nga ntúq king O-li-vê, án yua bar náq top rian te án pôq nsuoi. ");
INSERT INTO pac_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Án patáp nha-án idô: “Inha pôq nga vel ngki. Ndóng inha tớq parngốh vel, inha lư tumúh mui lám acái aséh a-êp ndon iyốh ngai diq. Ngai chóq dŏq án tớq ntúq ngki. Inha lếh alứng dông án nga cư. ");
INSERT INTO pac_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Khán ngai plốh inha: ‘Imo inha lếh aséh ndô?’ Dyôn inha ôi idô: ‘Ưlla he ính manh.’” ");
INSERT INTO pac_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dyơ nha-án bar náq pôq alứng hôm arớq Yê-su khoiq tông nha-án. ");
INSERT INTO pac_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ndóng nha-án lếh aséh, ticuoi ưlla aséh plốh nha-án idô: “Inha lếh aséh ndô táq amớh?” ");
INSERT INTO pac_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nha-án ôi án idô: “Ưlla he ính manh aséh ndô.” ");
INSERT INTO pac_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dyơ nha-án dông achô aséh a-êp ngki dyôn Yê-su. Cua ngki nha-án ial tampớc nha-án lêp tớq crŏ́ng aséh. Dyơ nha-án kitưq Yê-su sớr ticu tớq crŏ́ng aséh. ");
INSERT INTO pac_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ndóng Yê-su pôq, nha-án lêp tampớc tớq carna dyôn án dếq. ");
INSERT INTO pac_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tư án pôq tumán ính tớq vel Yaru-salem nga ntúq carna siar te king O-li-vê, bôn clứng ticuoi ndon rian te án crau cariau. Nha-án si-ơn alứng ayô Yang Arbang-pilŏ́ng yứng lư, co nha-án khoiq hôm máh arnáq sileh. ");
INSERT INTO pac_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nha-án tông idô: “Seq Yang Arbang-pilŏ́ng tốq callong bún dyôn puo ndô, án ndon tớq nga ndô nhơ nốh Yang Arbang-pilŏ́ng. Seq dyôn bôn callong ien ŏ tớq pilŏ́ng, alứng seq parnai ayô tớq nga Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tớq ticuoi clứng ngki bôn díh ticuoi Pha-rasi hơ. Nha-án tông Yê-su idô: “Thới ơi! Cóq thới dyŏq máh ticuoi rian te thới êq crau cariau nnáng.” ");
INSERT INTO pac_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma Yê-su ôi nha-án idô: “Khán máh ticuoi ndô lớiq crau cariau iki, cư tông inha arlớih lư, Yang Arbang-pilŏ́ng lư dyôn búl loi crau cariau.” ");
INSERT INTO pac_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tư Yê-su tumán ính tớq vel Yaru-salem, án me clang nga vel ngki, dyơ án nhiem. ");
INSERT INTO pac_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Alứng án tông idô: “Ingái ndô cư ính lư máh inha ndon át tớq vel pưt ndô chom cóq táq imo dyôn têq át ien ŏ. Ma hoi-ndô, te callong ndô inha lớiq apúh. ");
INSERT INTO pac_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Urớh, tớq máh ingái ticuoi picon inha ính puon cuteq lavíng paniar vel inha, alứng nha-án lớiq dyôn inha ngốh te vel. Nha-án catáng cứp carna. ");
INSERT INTO pac_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nha-án ính cachet cứp náq inha, alứng talóh nhéq vel pưt inha. Nha-án lớiq dyôn mui nốh amớh tớq vel inha nnáng plŏt, co inha lớiq chom ingái Yang Arbang-pilŏ́ng khoiq tớq ính choi tamống inha!” ");
INSERT INTO pac_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yê-su mot tớq Dúng Sang Pưt, dyơ án chuih angốh nhéq máh ticuoi táiq plới tớq ngki. ");
INSERT INTO pac_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Án tông ada nha-án idô: “Tớq tám uráq Yang Arbang-pilŏ́ng te inớh khoiq tông idô: ‘Dúng na cư ntúq dŏq cớu seq.’ Ma inha táq dúng ndô cơt arớq cưp dyôn ticuoi siveng mot catốq!” ");
INSERT INTO pac_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Cứp ingái Yê-su cato tớq Dúng Sang Pưt. Máh ticuoi sút top teng rit sang, máh thới sái rit, alứng máh ticuoi sút cannŏ́h, suo ngê ính cachet Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma nha-án lớiq chom amớh ính táq dyôn ngai bôn cachet Yê-su, co máh ticuoi ính lư cammáng parnai án cato. ");
INSERT INTO pac_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bôn mui ingái Yê-su cato parnai ŏ te Yang Arbang-pilŏ́ng dyôn máh ticuoi tớq Dúng Sang Pưt cammáng. Ndóng ngki bôn máh ticuoi sút top teng rit sang, máh thới sái rit, alứng máh ticuoi sút tớq sớu, tớq nga án alứng plốh idô: ");
INSERT INTO pac_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Cóq mái táq-ntêr a he, mái bôn chức amớh dŏq táq arnáq ndô? Nnáu dyôn mái bôn chức ndô?” ");
INSERT INTO pac_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yê-su ôi nha-án: “Cư ính plốh inha mui callong tưi. Cóq inha ôi cư: ");
INSERT INTO pac_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tíc na dơq ndon Yon táq, te mmo arnáq ngki tớq, te Yang Arbang-pilŏ́ng lớiq la te ticuoi?” ");
INSERT INTO pac_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dyơ nha-án tanghúng idô: “Khán he ôi án: ‘Arnáq Yon táq tớq te Yang Arbang-pilŏ́ng,’ cumáiq án plốh lieh he idô: ‘Khán iki, imo inha lớiq tin Yon?’ ");
INSERT INTO pac_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma khán he ôi án: ‘Arnáq Yon táq chóng tớq te ticuoi,’ ngki máh ticuoi prái lư tíq búl ada he, co nha-án tin Yon la ticuoi tang ngcang Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iki nha-án ôi Yê-su idô: “He lớiq chom.” ");
INSERT INTO pac_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yê-su ôi lieh nha-án idô: “Dyơ! Cư lớiq tông a inha chom tưi nnáu dyôn cư bôn chức táq máh arnáq ndô.” ");
INSERT INTO pac_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yê-su cato máh ticuoi clứng ngki tớq parnai acám idô: “Bôn munáq conh chóh ntớng nho tớq nưong. Dyơ án dyôn máh ticuoi táq dơ nưong án. Án alứng máh ticuoi ngki sŏ́ng chúng munơi máh culái. Cua ngki án pôq nga cruong cannŏ́h dưnh lư. ");
INSERT INTO pac_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tớq ngư culái dom, ưlla ngki yua ticuoi sol tớq nga nha-án ndon táq dơ nưong dyôn ial phê án te nha-án. Ma nha-án tính ticuoi sol, alứng chuih sol ngki chô ati nnŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dyơ ưlla ngki yua sol cannŏ́h loi pôq nga nưong. Ma nha-án ndon táq dơ nưong tính ticuoi sol ngki tưi, alứng nha-án acraiq án; dyơ nha-án chuih án dyôn chô ati nnŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Vít ngki ưlla yua munáq sol loi. Ma ticuoi táq dơ nưong táq ada sol ngki cơt bác chol, alứng nha-án chuih angốh án. ");
INSERT INTO pac_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dyơ ưlla ngki parngíh idô: ‘Imo loi cư ính táq? Cư ính yua acái conh ndon cư ayáu lư loi pôq. Lư nha-án dyám náp án.’ ");
INSERT INTO pac_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ma tư nha-án ndon táq dơ nưong hôm acái conh ưlla, dyơ nha-án tanghúng idô: ‘Ndô la lư acái tŏ́ng na ưlla. He! He cachet viang án! Dyơ máh mun án cơt na he!’ ");
INSERT INTO pac_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dyơ nha-án lúq ndŏ́h acái ưlla angốh te nưong, alứng nha-án cachet án. Iki, imo táp ưlla ngki ính táq ada nha-án? ");
INSERT INTO pac_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Lư án tớq cachet táh nhéq nha-án, alứng án dyôn ticuoi cannŏ́h loi táq dơ nưong án.” Máh ticuoi ndon sáng parnai ngki tông idô: “Êq dyôn cơt arnáq arớq iki!” ");
INSERT INTO pac_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma Yê-su me nga nha-án alứng plốh idô: “Khán tới iki, amớh la ngê te parnai tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông te inớh idô: ‘Cúc búl ticuoi táq dúng khoiq adúh, búl ngki cơt búl lác tớq tol dúng.’ ");
INSERT INTO pac_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ticuoi mmo dứm tớq búl ndô, án prớm lớng. Ma khán búl ndô atôh piaiq cháq ticuoi, ticuoi ngki alíq tháng.” ");
INSERT INTO pac_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Máh ticuoi sút top teng rit sang alứng máh thới sái rit suo ngê ính cŏp Yê-su, co nha-án chom Yê-su tông parnai acám ngki te nha-án. Ma nha-án lớiq dáh cŏp Yê-su, co nha-án adáh máh ticuoi prái. ");
INSERT INTO pac_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma nha-án tituaiq níc te Yê-su. Dyơ nha-án yua ticuoi pôq cammáng te Yê-su cato. Máh ticuoi ngki táq náh-nnan arớq ticuoi partát ŏ, ma callong lư la nha-án tớq suo callong luaih dŏq têq bôn cŏp án, alứng mŏp án nga ati ticuoi sút. ");
INSERT INTO pac_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Máh ticuoi suo ngê ngki plốh Yê-su idô: “Thới ơi! He chom dyơ thới tông piaiq níc. Alứng chứng mát thới, nhéq tưh ticuoi la li-arli nhéq. Thới cato te ngê Yang Arbang-pilŏ́ng piaiq lư. ");
INSERT INTO pac_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Iki he seq thới tông he: Amớh thới parngíh, crái lớiq khán he dyôn práq thêq nga puo Rô-ma?” ");
INSERT INTO pac_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma Yê-su khoiq chom nha-án bôn ngê ính chim án; dyơ án tông ada nha-án idô: ");
INSERT INTO pac_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Inha dông dyôn cư me mui callong práq! Callong práq ndô bôn rớp alứng tarran arớq nnáu?” ");
INSERT INTO pac_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nha-án ôi: “Puo Rô-ma.” Dyơ Yê-su tông lieh nha-án idô: “Crơng puo Rô-ma, cóq inha culieh lieh dyôn puo Rô-ma, alứng crơng Yang Arbang-pilŏ́ng, cóq inha culieh lieh dyôn Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndóng Yê-su yôl át cato ticuoi clứng, máh ticuoi ndon chim Yê-su lớiq bôn tumúh mui callong luaih amớh te parnai Yê-su cato. Iki nha-án sáng dut lư te parnai Yê-su ôi. Dyơ nha-án lớiq bôn tacang amớh nnáng. ");
INSERT INTO pac_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bôn ticuoi te top Sa-dusê tớq nga Yê-su. Nha-án tông ticuoi khoiq cuchet lớiq têq tumống lieh. Nha-án tông Yê-su idô: ");
INSERT INTO pac_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Thới ơi! Môi-se khoiq taran dyôn he chom idô: ‘Khán munáq conh khoiq ial campái ma án cuchet, ma campái án yôl tumống, alứng nha-án iyốh bôn acái, iki em ai án cóq atŏ́ng campái án, dŏq pitŏ́ng lieh dyôn án.’ ");
INSERT INTO pac_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tớq top he bôn tupul náq em ai. Án ndon ai pông khoiq ial campái. Ma án cuchet iyốh bôn acái. ");
INSERT INTO pac_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iki a-em pandi án atŏ́ng campái án. ");
INSERT INTO pac_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Alứng muchứng ngki tưi, te a-em pandi tingôi a-em tuloiq. Tupul náq nha-án la táq muchứng nhéq. Ma nha-án cuchet iyốh bôn acái. ");
INSERT INTO pac_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tớq talloiq tháng, cán ngki cuchet tưi. ");
INSERT INTO pac_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tư máh ticuoi cuchet bôn tumống lieh, cán ngki cơt campái án mmo? Co nha-án tupul náq ưlla nhéq cán ngki!” ");
INSERT INTO pac_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yê-su ôi nha-án idô: “Cán conh ial campái cayieq nưm tớq pang ndô sớng. ");
INSERT INTO pac_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma nha-án ndon tin Yang Arbang-pilŏ́ng, lư Yang Arbang-pilŏ́ng dyôn nha-án tumống lieh te cuchet, alứng án dyôn nha-án tumống níc-níc. Nha-án lớiq ial nnáng campái cayieq. ");
INSERT INTO pac_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nha-án cơt arớq tarneng Yang Arbang-pilŏ́ng tưi; nha-án lớiq nai cuchet nnáng. Nha-án lư cơt acái acon Yang Arbang-pilŏ́ng, co nha-án khoiq tumống lieh te cuchet. ");
INSERT INTO pac_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma te arnáq ticuoi cuchet bôn tumống lieh, Môi-se khoiq dyôn he chom arlớih lư te callong ngki, ndóng án taran te arbu bôn uih chéh, ma lớiq ngcat. Ntúq ngki án anốh Yang Arbang-pilŏ́ng la: ‘Yang Arbang-pilŏ́ng A-praham sang, I-sac sang, alứng Yacốp sang.’ ");
INSERT INTO pac_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","He têq chom nha-án tumống lieh te cuchet, co ticuoi cuchet lớiq têq sang nnáng Yang Arbang-pilŏ́ng. Nưm nha-án ndon yôl tumống sớng têq sang án, alứng nhéq tưh ticuoi bôn tumống co nhơ te án.” ");
INSERT INTO pac_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cua Yê-su tông iki, máh ticuoi te top thới sái rit ráp parnai Yê-su idô: “Thới ơi! Lư piaiq máh parnai thới tông!” ");
INSERT INTO pac_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Vít ngki, nha-án lớiq dáh plốh Yê-su mui callong amớh nnáng. ");
INSERT INTO pac_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yê-su plốh nha-án idô: “Co imo ticuoi báq tông Crit tớq te tŏ́ng toiq puo Davit? ");
INSERT INTO pac_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","To Davit táp tông tớq tám uráq Parnai Cứh Ayô idô: ‘Yang Arbang-pilŏ́ng tông Ưlla cư idô: “Mái ticu pa atớm cư tingôi ingái cư dyôn ticuoi picon mái át tadưp allang dyưng mái, cơt sol mái.”’ ");
INSERT INTO pac_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","To Davit táp dŏq Crit la ‘Ưlla’. Ngki imo têq Davit dŏq ticuoi te tŏ́ng toiq án bôm ‘Ưlla’?” ");
INSERT INTO pac_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ndóng clứng ticuoi át cammáng parnai Yê-su, án tông top rian te án idô: ");
INSERT INTO pac_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Inha êq táq arớq thới sái rit. Nha-án ính lư sứp au thor dát, alứng ính lư ticuoi cannŏ́h pasôl ŏ ndóng nha-án át alứng ticuoi clứng. Nha-án ính bôn kichơng ticu ŏ clưi nhéq te cannŏ́h tớq dúng rum, alứng nha-án ính ticu pa tanieng tớq ngai mơi nha-án tớq cha. ");
INSERT INTO pac_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nha-án lop máh mun cán cammai, alứng nha-án cớu toiq lư ính ngai tông nha-án la ticuoi tinớng ŏ. Ma chô-mát, tôt nha-án ntáng hơn te máh ticuoi cannŏ́h!” ");
INSERT INTO pac_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yê-su me nga ntúq ngai cacháq práq sang tớq Dúng Sang Pưt. Án hôm ticuoi súc cacháq práq tớq ngki. ");
INSERT INTO pac_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Alứng án hôm munáq cán cammai kidit lư, cacháq bar nhac práq kem ndon tarnáp biq lư. ");
INSERT INTO pac_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yê-su tông idô: “Cư tông inha arlớih lư, cán cammai ndô kidit lư, ma án cacháq práq sang a-ưi hơn te ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Co máh ticuoi cannŏ́h cacháq práq clưi te nha-án tớc cha, ma cán cammai ndô ớq lư. Máh-mmo án bôn, án cacháq nhéq máh ngki.” ");
INSERT INTO pac_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bôn ticuoi te top rian te Yê-su achuon te Dúng Sang Pưt ndon ŏ lư, co ngai táq tớq búl ŏ. Ngai táq dúng ngki na búl dát, alứng mŏp sang máh crơng ndon ŏ lư dyôn Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ma Yê-su tông nha-án idô: “Máh nốh ndon inha hôm tớq ntúq ndô hoi-ndô, chô-mát án lớiq tarbôt nnáng munơi; án partáh nhéq.” ");
INSERT INTO pac_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nha-án plốh Yê-su idô: “Thới ơi! Seq thới tông dyôn he chom, nnáng dưnh máh-mmo arnáq ndô tớq? Alứng bôn tíc amớh apáh nsuoi te arnáq ndô ính tớq?” ");
INSERT INTO pac_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yê-su ôi nha-án idô: “Cóq inha át dyôn ahôi; êq dyôn ngai pilốh inha. Chô-mát bôn a-ưi náq bôiq nốh cư, alứng nha-án tông idô: ‘To cư táp la Crit!’ Alứng nha-án tông idô hơ: ‘Ingái talloiq ính tớq dyơ!’ Ma inha êq náp parnai nha-án. ");
INSERT INTO pac_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tư inha sáng parhanh ngai tarchíl alứng ngai tarpíh ính cơt sút, inha êq crŏ́q. Co arnáq ndô cóq tớq nsuoi avai. Ma iyốh tớq ingái talloiq tháng.” ");
INSERT INTO pac_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yê-su tông loi idô: “Ingái ngki bôn top ndô tarchíl tartáq alứng top ngki, alứng cruong ndô tarchíl tartáq alứng cruong ngki. ");
INSERT INTO pac_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bôn a-ưi ntúq cuteq arsáu alứng cacưt. Bôn a-ưi ntúq ớq tanna cha. Alứng cơt a-ái arcúh, munáq tôiq na munáq. Máh nốh chếq ndô lư tớq, alứng bôn a-ưi tíc sileh tớq te pilŏ́ng hơ. ");
INSERT INTO pac_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma nsuoi máh nốh ngki tớq, bôn ticuoi cŏp inha alứng táq dieiq arức lư. Nha-án dông inha nga dúng rum ticuoi Isa-ra-el dyôn ngai sưq inha, alứng nha-án crál inha tớq coq tôt hơ. Ngai dông inha chứng mát máh puo alứng chứng mát máh ticuoi sút la co tian inha veng ngê cư. ");
INSERT INTO pac_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Máh arnáq ngki táq dyôn inha têq bôn cato te ngê cư. ");
INSERT INTO pac_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Cóq inha êq rớu-ri nsuoi te amớh inha ính tông ada ticuoi sút. ");
INSERT INTO pac_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ndóng ngki táp cư ính tông inha alứng dyôn inha bôn ngê tubáiq têq tông parnai piaiq ada nha-án ndon ính táq inha. Dyơ nha-án lớiq têq tamien amớh nnáng. ");
INSERT INTO pac_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Lư a-i a-ám, em ai, khơi cuya, alứng yớu inha, ính mŏp inha nga ati ticuoi sút. Bôn ticuoi te top inha, án ndon ngai táq, án ndon ngai cachet. ");
INSERT INTO pac_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nhéq tưh ticuoi a-ính inha co tian inha veng ngê cư. ");
INSERT INTO pac_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma mui ntráih sóc tớq plô inha la lớiq pít. ");
INSERT INTO pac_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Co inha chiuq tanhir níc, iki inha bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Tớq inha hôm clứng líng át paniar vel pưt Yaru-salem, inha têq chom khoiq tumán ngai ính talóh vel ngki. ");
INSERT INTO pac_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ndóng ngki nha-án ndon át tớq vúng Yudê cóq lúh sớr át tớq cóh loi. Nha-án ndon át tớq vel Yaru-salem cóq ngốh te vel. Alứng nha-án ndon át culái tieh vel Yaru-salem cóq êq chô nnáng nga vel. ");
INSERT INTO pac_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ingái ngki la ingái Yang Arbang-pilŏ́ng táq tôt top Isa-ra-el co tian nha-án lớiq peh, dyôn cơt tarvớiq simớt parnai ngai khoiq taran tớq tám uráq Yang Arbang-pilŏ́ng te inớh. ");
INSERT INTO pac_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tớq ingái ngki, toiq bap lư dyôn máh ticuoi cán ndon át cháq-iki alứng máh cán a-uq acái. Co ingái ngki dieiq arức lư tớq nga cruong cuteq ndô, alứng Yang Arbang-pilŏ́ng táq máh ticuoi ndô. ");
INSERT INTO pac_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Án ndon ngai tráh tớq dau. Án ndon ngai cŏp dông cơt sol nga cruong cannŏ́h. Alứng máh ticuoi tới ticuoi Isa-ra-el ính dếq cliet vel Yaru-salem tingôi sút pang nha-án.” ");
INSERT INTO pac_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Vít ngki, bôn tíc sileh tớq mát pandang, mát kisái, alứng máh pantôr hơ. Alứng tớq cuteq ndô bôn a-ưi cruong sáng dut alứng adáh lư, co dơq ving-cavang lampóh hớp lư alứng hô yứng lư. ");
INSERT INTO pac_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ticuoi pít mít co sáng adáh, alứng nha-án crŏ́q lư co máh nốh dieiq arức tớq nga cứp cruong. Alứng máh nốh bôn chức tớq pilŏ́ng, Yang Arbang-pilŏ́ng táq dyôn arsáu nhéq. ");
INSERT INTO pac_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Vít ngki ngai hôm Acái Yang Cơt Ticuoi tớq pandi tulúc; án bôn chức pưt lư alứng rớp án ang-ưr lư. ");
INSERT INTO pac_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ndóng inha hôm nốh ndô tabớq tớq, inha tayứng alứng tingưi asớr, co tumán tớq dyơ ingái Yang Arbang-pilŏ́ng choi tamống inha.” ");
INSERT INTO pac_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dyơ Yê-su tông nha-án tớq parnai acám idô: “Inha me tôm along tarúng alứng tôm along cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tớq inha hôm along pứh ula, inha chom tumán ính tớq dyơ kisái puoq. ");
INSERT INTO pac_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Muchứng ngki tưi, tớq inha hôm máh arnáq cư tông inha hoi-ndô, inha chom Yang Arbang-pilŏ́ng cơt sút khoiq tumán ính tớq dyơ. ");
INSERT INTO pac_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cư tông inha arlớih lư, ticuoi tớq pang ndô lớiq cuchet nsuoi te máh nốh ndô tớq. ");
INSERT INTO pac_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chô-mát, pilŏ́ng alứng cuteq cơt pít nhéq, ma parnai cư tông lớiq nai pít.” ");
INSERT INTO pac_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Cóq inha bán ŏ cháq bôm. Êq dyôn mít cannính inha ính ngoiq cha a-ưi, lớiq la bol plêc; alứng êq rớu-ri adáh ớq tớc, ớq cha tớq pang tumống inha. Khán iki, tớq ingái cư tớq lieh nga cúc cuteq ndô, dáh lơ inha lớiq parngíh amớh te cư tớq lieh. Co ingái ngki cư tớq chái lư arớq tihŏ láih. ");
INSERT INTO pac_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Alứng ingái ngki tớq nga cứp náq ticuoi tớq cúc cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Iki cóq inha me a-ŏ alứng cớu dyôn inha têq viar vít te nốh dieiq arức ngki, alứng cớu seq te Acái Yang Cơt Ticuoi têq ngin inha la ticuoi tinớng ŏ chứng mát án tớq ingái án sưq nhéq tưh ticuoi.” ");
INSERT INTO pac_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Cứp ingái Yê-su cato tớq Dúng Sang Pưt, ma tớq idáu án pôq át tớq king O-li-vê. ");
INSERT INTO pac_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tớq ang iláih cláih lư, bôn clứng ticuoi tớq nga Dúng Sang Pưt ính cammáng Yê-su cato. ");
INSERT INTO pac_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tumán ính tớq ingái top Isa-ra-el Cha Beng Mi Ớq Bôt Pôih, la ingái nha-án ayư lieh Ingái Ngốh. ");
INSERT INTO pac_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Máh ticuoi sút top teng rit sang alứng máh thới sái rit suo ngê ính cachet Yê-su. Ma nha-án adáh máh ticuoi prái. ");
INSERT INTO pac_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ndóng ngki yang Satán mot tớq mít Yuda I-cari-ôt, án la munáq te top mui chít la bar náq rian te Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dyơ án pôq tumúh máh ticuoi sút top teng rit sang alứng máh sút ticuoi kiaq Dúng Sang Pưt. Án tanghúng alứng nha-án táq imo têq án bôn mŏp Yê-su nga nha-án. ");
INSERT INTO pac_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Máh ticuoi ngki sáng ơn lư, alứng nha-án ưq chang án práq. ");
INSERT INTO pac_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Án khoiq chen ưq alứng nha-án; dyơ án suo carna ndóng mmo ŏ dyôn nha-án cŏp Yê-su ma lớiq bôn clứng ticuoi át tumán Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tư tớq Ingái Cha Beng Mi Ớq Bôt Pôih, ticuoi Isa-ra-el cóq kiac cưu acái veng phep rit Yang Arbang-pilŏ́ng tông dyôn ayư lieh Ingái Ngốh. ");
INSERT INTO pac_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iki Yê-su yua Phi-er alứng Yon idô: “Inha pôq thuan tanna dyôn he cha ayư lieh Ingái Ngốh.” ");
INSERT INTO pac_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma nha-án plốh Yê-su: “Ntúq mmo thới dyôn he pôq thuan?” ");
INSERT INTO pac_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yê-su tông nha-án idô: “Ndóng inha mot tớq vel, inha lư tumúh munáq conh tikel yáng dơq. Inha veng tatun crŏ́ng ticuoi ngki. Dúng mmo án mot, inha mot dúng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Dyơ inha tông ticuoi ưlla dúng ngki idô: ‘Thới ính plốh mái idô: Tumo callúng mong tumoi? Tớq callúng ngki cư ính cha pêl bui ayư Ingái Ngốh alứng top rian te cư.’ ");
INSERT INTO pac_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dyơ án ính turô mui callúng pưt tớq ntrôn tanieng dyôn inha. Tớq callúng ngki bôn cứp nốh máh crơng tarnứng. Dyơ inha thuan tớq callúng ngki.” ");
INSERT INTO pac_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dyơ nha-án bar náq pôq, alứng nha-án tumúh arớq Yê-su khoiq tông nha-án. Iki nha-án thuan mui pêl dŏq cha ayư Ingái Ngốh. ");
INSERT INTO pac_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tớq ngư chicha, Yê-su ticu alứng top mui chít la bar náq dyưng ati án. ");
INSERT INTO pac_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dyơ án tông nha-án idô: “Cư ính lư cha ngoiq alứng inha dŏq ayư Ingái Ngốh nsuoi te cư cóq chiuq dieiq arức. ");
INSERT INTO pac_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cư tông inha arlớih lư, cư lớiq cha ngoiq nnáng alứng inha arớq pêl ndô, tingôi cơt tarvớiq máh nốh ngai ayư lieh te Ingái Ngốh tớq ingái Yang Arbang-pilŏ́ng cơt sút.” ");
INSERT INTO pac_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Cua Yê-su tông iki, án ial choc dơq alứng si-ơn Yang Arbang-pilŏ́ng. Dyơ án tông idô: “Inha ráp ial alứng mpô dơq nho ndô dyôn inha ngoiq. ");
INSERT INTO pac_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cư tông inha arlớih lư, cư lớiq ngoiq nnáng dơq nho ndô tingôi tớq ingái Yang Arbang-pilŏ́ng cơt sút.” ");
INSERT INTO pac_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Án ial beng alứng si-ơn Yang Arbang-pilŏ́ng. Dyơ án péq beng, alứng avôi dyôn nha-án. Dyơ án tông idô: “Ndô la cháq cư ndon cuchet tang inha. Cóq inha táq arớq ndô dŏq ayư níc cư.” ");
INSERT INTO pac_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cua nha-án cha, Yê-su táq muchứng ngki sa. Án ial choc dơq, dyơ án tông idô: “Dơq ndô la aham cư. Aham ndô ngốh táq tíc Yang Arbang-pilŏ́ng khoiq par-ưq parnai tamme ada inha. ");
INSERT INTO pac_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ma bôn munáq te top inha ndon cha munơi alứng cư hoi-ndô, án ính culieu cư. ");
INSERT INTO pac_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Acái Yang Cơt Ticuoi cóq pôq tớq carna Yang Arbang-pilŏ́ng anát dyôn án pôq. Ma bap lư tớq nga ticuoi ndon culieu án.” ");
INSERT INTO pac_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dyơ nha-án tabớq munáq plốh munáq idô: “Nnáu táp te top he ính táq arnáq ndô?” ");
INSERT INTO pac_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Top rian te Yê-su tarmien tartuoq ính chom nnáu pưt hơn te cannŏ́h tớq top nha-án. ");
INSERT INTO pac_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yê-su tông nha-án idô: “Tớq pang ndô máh ticuoi puo ính lư ticuoi prái cơt sol nha-án. Alứng máh ticuoi bôn chức ính lư ngai ayô nha-án, táq-ntêr nha-án la ticuoi báq choi yớu. ");
INSERT INTO pac_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma inha êq táq iki. Khán ticuoi mmo te inha ính cơt sút hơn, cóq án cơt arớq ticuoi két. Alứng án ndon ính cơt sút, cóq án hớu ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ticuoi mmo inha hôm pưt hơn, án ndon ticu cha sớng lớiq la án ndon teng crơng tanna? Lư án ndon ticu cha sớng pưt hơn. Ma cư át alứng inha arớq ticuoi hớu sớng. ");
INSERT INTO pac_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Top inha át níc alứng cư ndóng cư tumúh a-ưi callong dieiq arức; inha lớiq bôn táh cư. ");
INSERT INTO pac_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","A-ám cư khoiq anát cư dyôn cơt sút. Muchứng ngki tưi cư ính anát inha dyôn cơt sút. ");
INSERT INTO pac_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Cư dyôn inha cha ngoiq munơi alứng cư, ndóng cư cơt sút. Alứng cư dyôn inha ticu sưq mui chít la bar top ticuoi Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Ơ Si-môn, Si-môn ơi! Yang Satán khoiq seq ính bôn inha. Án ính táq dieiq arức inha arớq ngai om yê sro. ");
INSERT INTO pac_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma cư khoiq cớu dyôn mái, dŏq mái lớiq pít callong tin. Tư mái tin lieh cư, cóq mái choi máh em ai mái dyôn nha-án tin khớm lư loi.” ");
INSERT INTO pac_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma Phi-er ôi Yê-su idô: “Ưlla ơi! Cư sŏ́ng pôq tưi alứng Ưlla. Tam ngai crál tớq coq tôt lớiq la ngai cachet cư la thôi.” ");
INSERT INTO pac_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Yê-su ôi Phi-er idô: “Phi-er ơi! Ntruoi iyốh ticár, mái khoiq calôih cư pe chư.” ");
INSERT INTO pac_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yê-su plốh top rian te án idô: “Ndóng cư yua inha pôq ma cư lớiq dyôn inha dông tui, lớiq la tái práq, lớiq la cơp, amớh inha ớq ndóng ngki?” Nha-án ôi: “He lớiq bôn ớq amớh.” ");
INSERT INTO pac_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dyơ Yê-su tông loi idô: “Ma hoi-ndô cư tông inha idô: Nnáu bôn tui, dyôn án dông. Nnáu bôn tái práq, dyôn án kitớn. Nnáu ớq dau, dyôn án táiq au, dyơ plới dau. ");
INSERT INTO pac_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Parnai Yang Arbang-pilŏ́ng tông te cư idô: ‘Ngai ngiaih án arớq ticuoi luaih tưi.’ Hoi-ndô cóq cơt tarvớiq máh parnai ngai khoiq tông te cư. Alứng máh parnai cannŏ́h hơ ngai khoiq tông te cư la cóq cơt tarvớiq tưi.” ");
INSERT INTO pac_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Top rian te Yê-su tông án idô: “Ưlla ơi! Ndô! Khoiq bôn dyơ bar pla dau.” Yê-su ôi: “Ơq. Piaiq dyơ.” ");
INSERT INTO pac_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yê-su ngốh te ntúq ngki pôq nga king O-li-vê loi, la ntúq án báq pôq te nsuoi. Alứng máh top rian te án pôq alứng án tưi. ");
INSERT INTO pac_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tư nha-án tớq nga ntúq ngki, án tông top rian te án idô: “Cóq inha cớu êq dyôn ngai tardông inha táq luaih.” ");
INSERT INTO pac_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yê-su ngốh te nha-án bôn sám mui chít achớng. Dyơ án chóh tarcol alứng cớu. ");
INSERT INTO pac_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Án cớu idô: “A-ám ơi! Khán mái sŏ́ng, seq mái atức viang choc dieiq arức ndô dyôn vít te cư. Ma A-ám êq veng cannính cư ính, ma veng arớq A-ám ính.” ");
INSERT INTO pac_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dyơ bôn munáq tarneng te pilŏ́ng tớq nga Yê-su, alứng choi án dyôn bôn mít cannính rap chiuq máh arnáq dieiq arức. ");
INSERT INTO pac_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yê-su sáng dieiq arức lư tớq mít cannính án. Dyơ án cớu seq nhéq tarngứh tarhơ. Bôn pahor ngốh te cháq án arớq aham tandyŏ́h tớq cuteq. ");
INSERT INTO pac_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tư Yê-su yôr te cớu, án píh lieh nga top rian te án, alứng hôm nha-án bíq. Nha-án sáng aleq co nha-án rớu-ri alứng anguaq lư. ");
INSERT INTO pac_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yê-su plốh nha-án: “Imo inha bíq? Cóq inha ayư! Alứng cóq inha cớu seq dyôn têq viar vít te ngai tardông inha táq luaih.” ");
INSERT INTO pac_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ndóng Yê-su yôl tông top rian te án, bôn clứng ticuoi tớq munơi alứng Yuda ndon te top mui chít la bar náq rian te án tưi. Yuda ayông máh ticuoi clứng ngki tớq nga án. Dyơ Yuda honh án. ");
INSERT INTO pac_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma Yê-su plốh Yuda idô: “Imo mái honh cư Acái Yang Cơt Ticuoi? Mái ính culieu cư, piaiq lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tư top rian te Yê-su hôm arnáq iki, ngki nha-án plốh Yê-su idô: “Ưlla ơi! Piaiq lớiq, khán he tráh nha-án tớq dau?” ");
INSERT INTO pac_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bôn munáq te nha-án tráh munáq sol ariaih top teng rit sang Yang Arbang-pilŏ́ng, ti-ŏ́h cutor pa atớm. ");
INSERT INTO pac_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yê-su tông idô: “Êq! Dyôn nha-án tíng táq.” Dyơ án pateng cutor ticuoi ngki dyôn cơt ŏ lieh. ");
INSERT INTO pac_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dyơ Yê-su tông ada máh ticuoi sút top teng rit sang, máh líng kiaq Dúng Sang Pưt, alứng máh ticuoi sút tớq sớu, ndon tớq cŏp án idô: “Imo inha dông dau alứng tarcál tớq cŏp cư, arớq inha ính cŏp ticuoi siveng? ");
INSERT INTO pac_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cứp ingái cư át níc alứng inha tớq Dúng Sang Pưt, ma inha lớiq táq amớh ada cư. Ma ingái ndô, inha têq veng cannính inha bôm, la ngê ngiau.” ");
INSERT INTO pac_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dyơ nha-án cŏp Yê-su, alứng dông án nga dúng ariaih top teng rit sang Yang Arbang-pilŏ́ng. Ma Phi-er veng yông-yông tatun crŏ́ng Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tư nha-án mot tớq ngcưm dúng, nha-án achúq uih. Dyơ nha-án ticu heng uih munơi, bôn díh Phi-er hơ heng alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma bôn munáq cán ndon táq arnáq tớq dúng ngki hôm Phi-er ticu heng uih. Án me clớn níc nga Phi-er, dyơ án tông idô: “Ticuoi ndô át alứng Yê-su tưi.” ");
INSERT INTO pac_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma Phi-er calôih idô: “Mái êq la mun! Cư lớiq chom án.” ");
INSERT INTO pac_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dyơ muhoi loi, bôn ticuoi cannŏ́h loi hôm Phi-er, alứng án tông idô: “Mái la te top ngki tưi.” Ma Phi-er ôi: “Cư tới te top ngki daih!” ");
INSERT INTO pac_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Vít ngki, muhoi loi, bôn munáq conh cannŏ́h acớl Phi-er; dyơ án tông idô: “Lư simớt ticuoi ndô át alứng Yê-su, co án la ticuoi Ca-lilê.” ");
INSERT INTO pac_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma Phi-er ôi: “Cư lớiq chom amớh mái tông.” Ndóng Phi-er yôl tông iki, ntruoi ticár táp. ");
INSERT INTO pac_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dyơ Yê-su tilêq me nga Phi-er, iki Phi-er ayư lieh te parnai Yê-su khoiq tông án idô: “Ntruoi iyốh ticár, mái khoiq calôih cư pe chư.” ");
INSERT INTO pac_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dyơ Phi-er ngốh te ngki, alứng án nhiem tức-ức tháng. ");
INSERT INTO pac_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nha-án ndon cŏp Yê-su ayê tar-ac án alứng tính án. ");
INSERT INTO pac_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ngai tian mát án, dyơ tông idô: “Áu mái tông, mái ndon tang ngcang Yang Arbang-pilŏ́ng, nnáu chốc mái?” ");
INSERT INTO pac_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Alứng a-ưi nốh cannŏ́h hơ nha-án acraiq asáh Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tớq ang iláih, máh ticuoi sút tớq sớu, máh ticuoi sút top teng rit sang, alứng máh thới sái rit, tớq rum munơi. Ngai dông Yê-su tớq nga nha-án. Dyơ nha-án plốh án idô: ");
INSERT INTO pac_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Khán mái la lư Crit, cóq mái tông he.” Ma Yê-su ôi nha-án idô: “Khán cư tông inha, la inha lớiq náp cư mmớh. ");
INSERT INTO pac_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Alứng khán cư plốh inha, la inha lớiq ôi cư tưi. ");
INSERT INTO pac_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma te ndô tớq chô-mát, cư Acái Yang Cơt Ticuoi lư át ticu pa atớm Yang Arbang-pilŏ́ng Sút Pưt Lư.” ");
INSERT INTO pac_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dyơ nhéq máh nha-án plốh Yê-su: “Mái la lư Acái Yang Arbang-pilŏ́ng lớiq?” Yê-su ôi: “Lư piaiq arớq inha tông.” ");
INSERT INTO pac_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dyơ nha-án tông idô: “Chớm he ính plốh nnáng ticuoi cannŏ́h. He khoiq sáng te ngcang án táp tông, la piaiq dyơ.” ");
INSERT INTO pac_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ndóng ngki nhéq top sút ngki dông asuoi Yê-su nga Phi-lat. ");
INSERT INTO pac_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tớq ntúq ngki nha-án cauq apít Yê-su idô: “He tumúh ticuoi ndô tardông ticuoi tớq cruong he táq lớiq ŏ, alứng án dyŏq idô: ‘Inha êq dyôn práq thêq nga puo ticuoi Rô-ma.’ Díh án ngin án táp la Crit, puo ticuoi Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Phi-lat plốh Yê-su: “Lư ma lớiq, mái la puo ticuoi Isa-ra-el?” Yê-su ôi án: “Lư piaiq arớq mái tông.” ");
INSERT INTO pac_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dyơ Phi-lat tông máh ticuoi sút top teng rit sang alứng máh ticuoi prái idô: “Cư lớiq tumúh mui callong luaih amớh te ticuoi ndô.” ");
INSERT INTO pac_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma nha-án yua níc Phi-lat dyôn táq Yê-su. Nha-án tông idô: “Ticuoi ndô pôq chuoq rúc chôp cruong Isa-ra-el. Tôm lư án chuoq rúc tớq vúng Ca-lilê. Ma hoi-ngki án pôq chuoq rúc tudô loi.” ");
INSERT INTO pac_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tư Phi-lat sáng nha-án tông iki, án plốh nha-án idô: Yê-su la ticuoi te vúng Ca-lilê, lớiq? ");
INSERT INTO pac_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tư Phi-lat chom Yê-su la ticuoi Ca-lilê. Iki án chom, ticuoi sút Yê-su la puo Hê-rôt An-tipa. Dyơ án yua ngai dông Yê-su nga Hê-rôt, co ingái ngki Hê-rôt át tớq vel pưt Yaru-salem tưi. ");
INSERT INTO pac_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tư Hê-rôt hôm Yê-su, án sáng ơn lư. Co khoiq dưnh lư dyơ án ính tumúh Yê-su, co án khoiq sáng a-ưi nốh ngai táq-ntêr te Yê-su, alứng án ngcong bôn hôm Yê-su táq arnáq sileh. ");
INSERT INTO pac_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dyơ án plốh Yê-su a-ưi callong. Ma Yê-su lớiq ôi án mui callong amớh. ");
INSERT INTO pac_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Máh ticuoi sút top teng rit sang alứng máh thới sái rit tayứng cauq chuoq níc Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dyơ Hê-rôt alứng líng án táq Yê-su arớq táq ada mbớr-plŏng. Alứng nha-án ayê tar-ac án hơ. Nha-án asứp án au thor arớq puo báq sứp. Dyơ nha-án dyôn ngai asuoi lieh án nga Phi-lat. ");
INSERT INTO pac_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Náp te ingái ngki Hê-rôt cơt artoi lieh alứng Phi-lat, co te nsuoi nha-án munáq tar-uan ada munáq. ");
INSERT INTO pac_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dyơ Phi-lat pachúng lieh máh ticuoi sút top teng rit sang, máh ticuoi sút te cứp arnáq, alứng máh ticuoi prái; ");
INSERT INTO pac_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","alứng án tông ada nha-án idô: “Inha dông ticuoi ndô tớq nga cư, inha tông án tardông ticuoi táq lớiq piaiq. Ma cư khoiq plốh án chứng mát inha, alứng cư lớiq tumúh mui callong luaih amớh arớq inha khoiq cauq án. ");
INSERT INTO pac_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Alứng Hê-rôt la lớiq tumúh luaih amớh tưi; co iki án dông lieh ticuoi ndô nga cư. Lớiq bôn nốh amớh ticuoi ndô táq ma cóq ráp tôt cuchet. ");
INSERT INTO pac_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iki cư ính tính án, dyơ taláh.” ");
INSERT INTO pac_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Veng rit tớq ingái cha bui, Phi-lat cóq taláh munáq ticuoi tôt. ");
INSERT INTO pac_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma máh ticuoi clứng ngki tông mui parrứh yứng lư idô: “Dông cachet viang án! Taláh dyôn he Ba-raba!” ");
INSERT INTO pac_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ba-raba la ticuoi ngai khoiq crál tớq coq tôt, co án chuoq rúc ticuoi tớq vel ngki, alứng án khoiq cachet ticuoi hơ. ");
INSERT INTO pac_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Phi-lat ính lư taláh Yê-su; dyơ án táq-ntêr lieh alứng ticuoi clứng ngki. ");
INSERT INTO pac_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma nha-án tông yứng lư loi: “Téh án tớq along calláng! Téh án tớq along calláng!” ");
INSERT INTO pac_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Dyơ Phi-lat plốh nha-án chư pe idô: “Amớh inha hôm án táq luaih? Cư lớiq tumúh callong amớh dyôn têq cachet án. Iki cư tính án, dyơ taláh.” ");
INSERT INTO pac_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma nha-án yua níc Phi-lat alứng tông yứng lư dyôn téh Yê-su tớq along calláng. Dyơ máh parnai nha-án cơt sit lư. ");
INSERT INTO pac_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iki Phi-lat dyôn máh líng táq arớq nha-án seq. ");
INSERT INTO pac_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Alứng Phi-lat taláh Ba-raba dyôn nha-án, arớq nha-án khoiq seq te idứh. Ba-raba cơt tôt co tian án chuoq rúc ticuoi tớq vel ngki, alứng án khoiq cachet ticuoi hơ. Ma Phi-lat mŏp Yê-su dyôn nha-án; nha-án ính táq amớh la tam nha-án. ");
INSERT INTO pac_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ndóng nha-án dông angốh Yê-su te vel, nha-án tumúh munáq conh, nốh Si-môn, te cruong Si-rên, án chô te culái tieh vel. Nha-án cŏp án, alứng yua án dual along calláng Yê-su. Dyơ án veng tapun pa crŏ́ng Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bôn clứng lư ticuoi veng Yê-su, bôn díh cán hơ, alứng nha-án nhiem atíh. ");
INSERT INTO pac_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ma Yê-su tilêq nga crŏ́ng, dyơ án tông ada nha-án idô: “Cán te vel Yaru-salem ơi! Inha êq nhiem te cư. Ma inha nhiem te cháq inha bôm, alứng te acái acon inha. ");
INSERT INTO pac_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Urớh, lư tớq ingái ngai ính tông idô: ‘Bún lư ticuoi cut alứng ticuoi lớiq nai carnian acái. Alứng bún lư ticuoi bôn tóh, ma lớiq nai a-uq acái.’ ");
INSERT INTO pac_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ingái ngki nha-án ính seq te cóh idô: ‘Cóh ơi! Mái arlíh catát viang he!’ “Alứng nha-án ính seq te máh king idô: ‘Máh king ơi! Mái pul culứp viang he.’” ");
INSERT INTO pac_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Dyơ Yê-su acám loi idô: “Khán along mống ma ngai pớiq táh, ngki imo loi ngai ính táq ada along ráng?” ");
INSERT INTO pac_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Alứng ngai dông bar náq ticuoi luaih ính cachet nha-án munơi alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tư nha-án tớq nga ntúq ngai dŏq Ntúq Nghang Cudoh Plô, ntúq ngki táp ngai cachet pe náq ngki, téh nha-án tớq along calláng. Ngai téh Yê-su tớq along calláng pandi. Ma bar náq ticuoi luaih, ngki ngai téh munáq pa atớm munáq pa aviar Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dyơ Yê-su tông idô: “A-ám ơi! Seq A-ám táh luaih dyôn nha-án ndon táq cư, co nha-án lớiq chom amớh nha-án chón táq.” Dyơ máh líng mpô tampớc Yê-su na séng anhúq, nnáu bôn la thôi. ");
INSERT INTO pac_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bôn máh ticuoi prái át me níc ada Yê-su. Alứng máh ticuoi sút ngki ayê tar-ac Yê-su idô: “Ticuoi cannŏ́h án têq choi tamống. Khán án lư Crit, án ndon Yang Arbang-pilŏ́ng rêh, hoi-ndô dyôn án choi tamống cháq án bôm.” ");
INSERT INTO pac_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Díh máh ticuoi líng hơ ayê tar-ac Yê-su tưi. Nha-án pidáng sieu adyóq dyôn án ngoiq, ");
INSERT INTO pac_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","alứng nha-án tông idô: “Khán mái lư puo ticuoi Isa-ra-el, áu mái choi tamống cháq mái bôm.” ");
INSERT INTO pac_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dyơ ngai taran dŏq tớq mêng pan tanieng plô Yê-su idô: TICUOI NDÔ LA PUO TICUOI ISA-RA-EL. ");
INSERT INTO pac_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nha-án bar náq ndon ngai téh munơi alứng Yê-su, án ndon munáq tông atưt Yê-su idô: “Khán mái lư Crit, áu mái choi tamống cháq mái, alứng choi tamống he hơ.” ");
INSERT INTO pac_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma án ndon munáq loi dyŏq ticuoi ngki idô: “Mái lớiq adáh Yang Arbang-pilŏ́ng táq mái lớiq? Mái alứng án, ngai táq muchứng nhéq. ");
INSERT INTO pac_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ngai táq he la crái lư, co ngai culieh dơq te máh arnáq he khoiq táq. Ma án lớiq bôn táq luaih amớh.” ");
INSERT INTO pac_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dyơ ticuoi ndon dyŏq ngki tông Yê-su idô: “Yê-su ơi! Tớq mái cơt sút urớh, seq mái êq clớiq cư.” ");
INSERT INTO pac_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dyơ Yê-su ôi án idô: “Cư tông mái simớt lư, ingái ndô táp mái bôn át alứng cư tớq cruong ien ŏ tớq pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ndóng mát pandang turống tứng, cơt ngiau nhéq chôp cruong ngki tingôi mát pandang tallóh két. ");
INSERT INTO pac_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mát pandang cơt pát dáu, alứng prới ngai yéng tớq Dúng Sang Pưt tarhaq cơt bar tarrec. ");
INSERT INTO pac_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yê-su cuc yứng lư idô: “A-ám ơi! Cư achúh arvai cư nga mái.” Tớq cua án tông, án ti-ŏ́h táp tarngứh. ");
INSERT INTO pac_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bôn munáq ticuoi sút mui culám náq líng hôm máh arnáq ndô. Án ayô Yang Arbang-pilŏ́ng, alứng án tông idô: “Lư simớt, ticuoi ndô la ticuoi tinớng ŏ.” ");
INSERT INTO pac_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nhéq máh ticuoi rum tumán ngki sáng anguaq lư. Dyơ nha-án chô nga dúng nha-án. ");
INSERT INTO pac_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Máh ticuoi arcớl Yê-su, alứng máh cán ndon veng án te vúng Ca-lilê, nha-án át yông-yông me clang máh arnáq ngai táq ada án. ");
INSERT INTO pac_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Bôn munáq conh, nốh Yô-sep, te top sút ticuoi Isa-ra-el. Án la ticuoi ŏ alứng tinớng lư. ");
INSERT INTO pac_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Án lớiq sŏ́ng alứng top sút ndóng top sút ndon táq Yê-su. Án la te vel Ari-mathê, vúng Yudê. Alứng án ngcong Yang Arbang-pilŏ́ng cơt sút. ");
INSERT INTO pac_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Án pôq nga Phi-lat alứng seq cumuiq Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dyơ án tớq talíh cumuiq Yê-su te along calláng. Án sŏm tớq prới, alứng án tứp tớq ping búl ngai khoiq var dŏq. Ping ngki iyốh tứp ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ingái ngki la ingái ngai thuan, co tumán ính tớq Ingái Angô. ");
INSERT INTO pac_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Máh cán ndon veng Yê-su te vúng Ca-lilê pôq tapun Yô-sep, alứng me ping Yê-su. Nha-án hôm ngai dŏq cumuiq Yê-su tớq ping. ");
INSERT INTO pac_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cua ngki nha-án chô nga dúng. Nha-án thuan crơng thum ính cacháq tớq cumuiq Yê-su. Alứng tớq Ingái Angô, nha-án angô tưi veng parnai Yang Arbang-pilŏ́ng khoiq patáp. ");
INSERT INTO pac_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ingái mui, tớq tún tatun, te cláih lư máh cán ngki pôq nga ping Yê-su. Nha-án dông máh crơng thum ndon nha-án khoiq thuan. ");
INSERT INTO pac_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nha-án hôm búl catáng ngáh ping khoiq ngai vih angốh. ");
INSERT INTO pac_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma tư nha-án mot tớq callúng ping, nha-án lớiq hôm nnáng cumuiq Yê-su. ");
INSERT INTO pac_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nha-án át tayứng ngki co sáng dut lư. Ma ndóng ngki táp nha-án hôm bar náq conh sứp au clŏq lư tarbal mát. ");
INSERT INTO pac_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Máh cán ngki sáng adáh lư, dyơ nha-án tangngop nga cuteq. Ma conh ngki tông nha-án idô: “Imo inha suo ticuoi tumống tớq ntúq ndô? Ntúq ndô ngai dŏq nưm ticuoi cuchet sớng. ");
INSERT INTO pac_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Án ndon inha suo, án lớiq át ndô; án khoiq tumống lieh dyơ. Inha ayư, amớh án khoiq tông inha ndóng án yôl át alứng inha tớq vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Án tông idô: ‘Acái Yang Cơt Ticuoi cóq tớq nga ati ticuoi saq. Nha-án cachet án na téh án tớq along calláng. Ma catám ingái pe, án yôr tumống lieh.’” ");
INSERT INTO pac_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iki máh cán ngki ayư lieh te máh parnai Yê-su khoiq tông. ");
INSERT INTO pac_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dyơ nha-án chô te ping. Nha-án táq-ntêr lieh máh nốh ngki dyôn top mui chít la mui náq rian te Yê-su chom. Alứng nha-án táq-ntêr dyôn máh ticuoi cannŏ́h hơ chom. ");
INSERT INTO pac_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Máh cán ndon táq-ntêr máh nốh ngki dyôn top dyưng ati Yê-su chom, la Mari te vel Mac-dala, Yô-ana, Mari a-i Yacơ, alứng máh cán cannŏ́h ndon pôq alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma top rian te Yê-su lớiq náp parnai máh cán ngki táq-ntêr. Nha-án parngíh máh cán ngki chóng táq-ntêr sớng. ");
INSERT INTO pac_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Phi-er yôr tayứng. Án talúh táp nga ping Yê-su. Án tangngop lileng tớq ping, án hôm nưm prới nnŏ́h sớng. Dyơ án chô, alứng án sáng dut lư tớq mít án te arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ingái ngki táp bôn bar náq rian te Yê-su pôq na carna ính pôq nga vel Êm-ma-ut. Vel ngki yông te vel Yaru-salem sám mui chít la mui ki-lô-met. ");
INSERT INTO pac_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ndóng nha-án pôq, munáq táq-ntêr alứng munáq te máh arnáq khoiq cơt. ");
INSERT INTO pac_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ndóng nha-án yôl táq-ntêr iki, Yê-su táp pôq munơi alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nha-án hôm Yê-su, ma nha-án lớiq acớl. ");
INSERT INTO pac_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yê-su plốh nha-án idô: “Callong amớh inha tarlái te idứh?” Nha-án trín, ma mát móh nha-án anguaq lư. ");
INSERT INTO pac_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Munáq te bar náq ngki, nốh Clêu-ba, án plốh idô: “Nưm munáq mái táp te máh ticuoi tumoi ndon át tớq vel Yaru-salem ma lớiq chom te arnáq ngai táq tớq bar pe ingái ndô lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yê-su plốh án: “Arnáq amớh ngai táq?” Nha-án ôi án idô: “Máh arnáq te Yê-su, ticuoi te vel Na-saret. Án la ticuoi tang ngcang Yang Arbang-pilŏ́ng. Sileh lư máh arnáq án táq, alứng parnai án tông la sit lư chứng mát Yang Arbang-pilŏ́ng alứng nhéq máh ticuoi. ");
INSERT INTO pac_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma máh ticuoi sút top teng rit sang, alứng máh ticuoi cannŏ́h ndon sút he, nha-án yua ngai cachet án na téh tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma nsuoi te ngki, he tin lư án la ticuoi ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi Isa-ra-el. Te máh arnáq ngki cơt khoiq bôn pe ingái ndô dyơ. ");
INSERT INTO pac_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Alứng bôn cán te top he táq-ntêr a he te arnáq ndon táq dyôn he sáng dut lư. Nha-án pôq te cláih lư nga ping Yê-su, ");
INSERT INTO pac_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ma nha-án lớiq hôm cumuiq Yê-su. Dyơ nha-án tớq nga he alứng táq-ntêr dyôn he chom te nha-án khoiq hôm tarneng, alứng te tarneng ngki tông dyôn nha-án chom la Yê-su khoiq tumống lieh dyơ. ");
INSERT INTO pac_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bôn ticuoi cannŏ́h te top he pôq nga ping. Alứng nha-án hôm arớq máh cán ngki khoiq táq-ntêr, ma nha-án lớiq hôm Yê-su.” ");
INSERT INTO pac_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dyơ Yê-su tông nha-án idô: “Achơ lư inha, alứng dyut lư inha tin máh parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông te inớh. ");
INSERT INTO pac_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Imo inha lớiq chom Crit cóq chiuq callong dieiq arức ndô? Cua ngki án bôn ráp chức ang-ưr lư.” ");
INSERT INTO pac_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dyơ Yê-su tabớq roih lieh te parnai Môi-se taran tingôi tớq máh parnai ticuoi tang ngcang khoiq tông, dyôn nha-án chom nhéq te máh tám uráq Yang Arbang-pilŏ́ng te inớh khoiq tông te án. ");
INSERT INTO pac_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tumán nha-án ính tớq nga vel nha-án ính pôq, ma Yê-su táq náh-nnan ính pôq tilớt vel ngki. ");
INSERT INTO pac_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma nha-án cayúng Yê-su alứng tông idô: “Seq mái át alứng he avai. Khoiq ibư alứng tumán idáu dyơ.” Iki Yê-su mot át alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tớq nha-án ticu chicha, Yê-su ial beng alứng si-ơn Yang Arbang-pilŏ́ng. Dyơ án péq beng alứng avôi dyôn nha-án cha. ");
INSERT INTO pac_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ndóng ngki táp nha-án apúh alứng acớl Yê-su. Ma Yê-su palláiq táp, nha-án lớiq hôm nnáng án. ");
INSERT INTO pac_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nha-án munáq táq-ntêr ada munáq idô: “Lư lớiq, mít cannính he sáng bui tamprơl ndóng án táq-ntêr ingái ndô tớq carna, alứng ndóng án angốh ngê dyôn he chom te parnai Yang Arbang-pilŏ́ng?” ");
INSERT INTO pac_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dyơ nha-án tiyốq píh chô lieh táp nga vel Yaru-salem. Nha-án tumúh top mui chít la mui náq rian te Yê-su át rum munơi alứng ticuoi cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iki nha-án bôn sáng tưi te máh top rum ngki táq-ntêr idô: “Lư simớt, Ưlla he khoiq tumống lieh dyơ! Si-môn khoiq tumúh án.” ");
INSERT INTO pac_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dyơ bar náq ngki loi táq-ntêr dyôn máh ticuoi ndon rum ngki chom te máh arnáq nha-án khoiq hôm tớq carna, alứng te arnáq nha-án acớl Yê-su ndóng án péq beng. ");
INSERT INTO pac_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nha-án yôl táq-ntêr iki, to Yê-su táp palôh pandi nha-án. Alứng án tông nha-án idô: “Inha át ien ŏ.” ");
INSERT INTO pac_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma nha-án adáh alứng dyandyír, co nha-án parngíh cumuiq Yê-su lánh nha-án. ");
INSERT INTO pac_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yê-su plốh nha-án idô: “Imo inha adáh? Alứng imo inha mamu? ");
INSERT INTO pac_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Inha me nga dyưng ati cư. Lư cháq cư táp. Inha tớq capơiq me, dyơ inha chom cư la ticuoi, co cumuiq lớiq bôn sáiq alứng nghang arớq cư.” ");
INSERT INTO pac_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cua Yê-su tông iki, án apáh dyôn nha-án me dyưng ati án. ");
INSERT INTO pac_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nha-án yôl iyốh tin, co nha-án sáng bui alứng sáng dut lư. Iki Yê-su plốh nha-án idô: “Tớq ntúq ndô inha bôn crơng tanna lớiq?” ");
INSERT INTO pac_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nha-án dyôn nga án mui béq buaiq ớng. ");
INSERT INTO pac_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iki án ial cha buaiq ngki chứng mát nha-án táp. ");
INSERT INTO pac_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Alứng án tông nha-án idô: “Nhéq máh callong ndô cư tông inha ndóng cư nnáng át alứng inha. Cư khoiq tông inha, cóq cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông te cư tớq phep rit Môi-se, tớq parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng, alứng tớq tám uráq Parnai Cứh Ayô te inớh.” ");
INSERT INTO pac_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dyơ án cato arlớih lư dyôn nha-án apúh te máh parnai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Án tông nha-án idô: “Khoiq ngai taran dyơ te Crit cóq chiuq a-ưi arnáq dieiq arức, alứng ngai cachet án, ma catám ingái pe, án yôr tumống lieh te cuchet. ");
INSERT INTO pac_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Alứng nhơ te nốh án, cóq ngai pôq cato dyôn cứp cruong chom, ticuoi cóq ngin luaih pien cơt mít tamme loi, dŏq Yang Arbang-pilŏ́ng táh luaih nha-án. Tôm lư, cóq ngai cato tớq vel pưt Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Inha táp cư dyôn dông parnai ndô, co inha khoiq hôm máh arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cư táp dyôn inha bôn máh nốh A-ám cư khoiq ưq ính dyôn inha. Ma cóq inha át pớn tớq vel Yaru-salem avai, dyôn tingôi inha bôn Arvai Yang Arbang-pilŏ́ng siar át alứng inha.” ");
INSERT INTO pac_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dyơ Yê-su dông nha-án ngốh te vel ngki, pôq nga vel Bê-thani loi. Án payơ bar pa ati alứng tông callong bún dyôn nha-án. ");
INSERT INTO pac_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ndóng án yôl tông callong bún dyôn nha-án, án ngốh te nha-án alứng án sớr nga pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nha-án sang tám án; dyơ nha-án chô lieh nga vel Yaru-salem, alứng sáng bui lư. ");
INSERT INTO pac_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nha-án pôq níc nga Dúng Sang Pưt dŏq ayô alứng si-ơn Yang Arbang-pilŏ́ng.");
INSERT INTO pac_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Te tôm lư, ndóng Yang Arbang-pilŏ́ng iyốh teng mui nốh amớh, parnai Yang Arbang-pilŏ́ng khoiq bôn dyơ. Án át níc alứng Yang Arbang-pilŏ́ng. Án la lư Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Án át alứng Yang Arbang-pilŏ́ng te inớh tháng. ");
INSERT INTO pac_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nhơ án, Yang Arbang-pilŏ́ng teng túc culám khám nốh tớq tadưp alứng tớq tanieng. Lớiq bôn mui nốh amớh Yang Arbang-pilŏ́ng teng ma lớiq nhơ te án. ");
INSERT INTO pac_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nhơ án, bôn callong tumống. Callong tumống ndô la callong ang dyôn nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Callong ang claq tớq ntúq ngiau, alứng callong ngiau lớiq rap pupát callong ang ndô. ");
INSERT INTO pac_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Bôn munáq conh ndon Yang Arbang-pilŏ́ng yua dyôn tớq cato te callong ang ndô. Nốh án la Yon. Án ính cứp náq ticuoi bôn sáng te callong ang ndô, dyơ tin. ");
INSERT INTO pac_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yon la tới callong ang, ma Yon tớq cato te callong ang ndô. ");
INSERT INTO pac_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Callong ang ndô la Yê-su Crit. Án la lư callong ang. Án tớq táq arnáq án tớq cúc cuteq ndô. Án tabal tớq mít cannính cứp náq ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Án át tớq cuteq ndô. Án táp teng cúc cuteq ndô, ma ticuoi tớq cuteq ndô lớiq acớl án. ");
INSERT INTO pac_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Án tớq nga cruong cuteq án bôm, ma ticuoi lớiq ráp án. ");
INSERT INTO pac_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Khán ticuoi mmo ráp alứng tin án, án lư dyôn ticuoi ngki bôn chức têq cơt acái acon Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yang Arbang-pilŏ́ng táp táq dyôn nha-án cơt acái acon án; ma tới arớq ticuoi cán carnian acái, lớiq la apu ama, lớiq la veng ngê ticuoi parngíh. ");
INSERT INTO pac_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Parnai Yang Arbang-pilŏ́ng bôn sac sáiq cơt ticuoi tưi. Án át munơi alứng he. He khoiq hôm án bôn chức sút pưt lư, la chức Acái Yang Arbang-pilŏ́ng. Án bôn mít cannính ính choi mat máh ticuoi, alứng bôn mít cannính piaiq níc. ");
INSERT INTO pac_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yon pôq pau tông te Yê-su idô: “Cư khoiq tông inha dyơ te ticuoi ndô idô: Án tớq tatun cư, ma án bôn chức hơn te cư. Co te cư iyốh cơt, án khoiq bôn dyơ tớq pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","“Nhéq máh he khoiq bôn a-ưi callong bún, co nhơ án choi mat he. ");
INSERT INTO pac_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yang Arbang-pilŏ́ng khoiq dyôn top Isa-ra-el bôn phep rit án na Môi-se, ma callong choi mat alứng callong piaiq tớq te Yê-su Crit. ");
INSERT INTO pac_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lớiq bôn ticuoi mmo hôm Yang Arbang-pilŏ́ng. Ma Acái Yang Arbang-pilŏ́ng khoiq tông dyôn nhéq tưh ticuoi chom te Yang Arbang-pilŏ́ng. Yang Arbang-pilŏ́ng bôn nưm mui lám Acái sớng. Án alứng Yang Arbang-pilŏ́ng la li-arli, alứng án bôn mui mít alứng A-ám án.” ");
INSERT INTO pac_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ndô la parnai Yon tông, ndóng top Isa-ra-el át tớq vel Yaru-salem, ngai yua bar pe náq te top teng rit sang Yang Arbang-pilŏ́ng alứng te top Lê-vi, tớq plốh Yon idô: “Thới la nnáu?” ");
INSERT INTO pac_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yon ngin te máh arnáq án táq. Án lớiq bôn catốq. Án ôi bar náq ngki idô: “Cư tới Crit.” ");
INSERT INTO pac_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dyơ nha-án plốh sa Yon: “Khán iki, thới la nnáu? Thới la Ê-li lớiq?” Yon ôi: “Cư tới Ê-li.” Nha-án plốh sa: “Thới la ticuoi tang ngcang Yang Arbang-pilŏ́ng ndon he ngcong lớiq?” Yon ôi nha-án: “Tới.” ");
INSERT INTO pac_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nha-án plốh sa: “Khán iki, thới la nnáu? Seq thới tông dyôn he chom, dŏq he têq chô táq-ntêr lieh dyôn ticuoi ndon yua he tớq nga tudô. Seq thới tông thới la nnáu?” ");
INSERT INTO pac_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yon ôi nha-án muchứng parnai Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng, idô: “Cư la sieng tubau yứng lư te ntúq aih idô: ‘Cóq inha cháh báng dyôn tinớng carna dyôn Ưlla he.’” ");
INSERT INTO pac_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bôn ticuoi te top Pha-rasi tớq ");
INSERT INTO pac_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","alứng plốh Yon idô: “Khán thới tới Crit, tới Ê-li, tới munáq tang ngcang Yang Arbang-pilŏ́ng, iki imo thới táq tíc na dơq dyôn máh ticuoi?” ");
INSERT INTO pac_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yon ôi idô: “Cư táq tíc dyôn ticuoi la na dơq sớng, ma bôn munáq tớq tatun cư, alứng án tayứng pandi inha hoi-ndô. Ma inha lớiq chom án. ");
INSERT INTO pac_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Cư lớiq crái díh lếh ntár cơp te dyưng án, co cư bôn chức két lư.” ");
INSERT INTO pac_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nhéq arnáq ngki cơt tớq vel Bê-thani, pa dyáng atóh crong Yôr-dan, la ntúq Yon báq táq tíc na dơq. ");
INSERT INTO pac_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Máh ingái parnô loi, Yon hôm Yê-su pôq nga án. Dyơ án tông idô: “Ntíh! Inha me! Án la Acái Cưu te Yang Arbang-pilŏ́ng. Án la arớq pannán ngai kiac sang dyôn Yang Arbang-pilŏ́ng táh luaih dyôn nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Cư khoiq tông dyơ te án idô: ‘Bôn munáq tớq tatun cư, án bôn chức pưt hơn te cư. Te iyốh carnian cư, án khoiq bôn dyơ tớq pilŏ́ng.’ ");
INSERT INTO pac_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te nsuoi, cư lớiq chom tưi án la Crit. Ma cư khoiq táq tíc na dơq dyôn top Isa-ra-el têq chom án arlớih lư.” ");
INSERT INTO pac_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yon tông lieh idô: “Cư khoiq hôm Arvai Yang Arbang-pilŏ́ng siar te pilŏ́ng arớq achếq cacu. Dyơ Arvai ngki át alứng án. ");
INSERT INTO pac_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tớq ingái ngki cư iyốh chom tưi án la Crit, ma Yang Arbang-pilŏ́ng yua cư táq tíc na dơq idô: ‘Tớq mái hôm munáq ndon bôn Arvai Yang Arbang-pilŏ́ng siar át, án la ticuoi ndon táq tíc na Arvai Yang Arbang-pilŏ́ng.’ ");
INSERT INTO pac_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Cư khoiq hôm dyơ callong ndô. Cư tông inha arlớih lư, Yê-su la lư Acái Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ingái parnô loi, Yon ndon táq tíc na dơq át lieh tớq ntúq ngki alứng bar náq top rian te án. ");
INSERT INTO pac_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tư án hôm Yê-su pôq pha, án me nga Yê-su alứng án tông idô: “Ngki! Inha me! Án ndô táp la Acái Cưu Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tư bar náq top rian te án sáng án tông iki, dyơ nha-án veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yê-su tilêq hôm nha-án veng pa lamloi án, dyơ án plốh nha-án idô: “Amớh inha ính bôn, inha veng tapun cư?” Nha-án ôi: “Tớq mmo thới át?” ");
INSERT INTO pac_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yê-su ôi nha-án: “Inha tớq me.” Iki nha-án veng tapun Yê-su alứng hôm ntúq Yê-su át. Dyơ nha-án át alứng Yê-su mui ingái, co mát pandang khoiq tangcưl cóh. ");
INSERT INTO pac_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anrê a-em Si-môn Phi-er, la munáq te bar náq ndon khoiq sáng Yon táq-ntêr, dyơ nha-án veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anrê pôq tumúh Si-môn ai án, alứng án tông idô: “He khoiq tumúh dyơ án ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi.” (Tớq cang Créc la ‘Crit’.) ");
INSERT INTO pac_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Anrê dông Si-môn pôq nga Yê-su. Yê-su me nga Si-môn alứng tông án idô: “Nốh mái Si-môn, acái Yô-na, ma hoi-ndô, cư anốh mái nốh tamme, la Sê-pha.” (Sê-pha tớq cang Créc la ‘Phi-er’, alứng Phi-er titoiq lieh la ‘Búl’.) ");
INSERT INTO pac_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Máh ingái parnô loi, Yê-su parngíh ính pôq nga vúng Ca-lilê. Tư án pôq, án tumúh Phi-lip, alứng tông án idô: “Mái veng tapun cư!” ");
INSERT INTO pac_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Phi-lip át mu vel alứng Anrê nha Phi-er. Vel ngki nốh Bet-sada. ");
INSERT INTO pac_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dyơ Phi-lip tumúh Na-thanial alứng tông án idô: “He khoiq tumúh dyơ án ndon Môi-se khoiq taran tớq Tám Uráq Phep Rit top Isa-ra-el. Alứng ticuoi cannŏ́h ndon tang ngcang Yang Arbang-pilŏ́ng te inớh khoiq tông te munáq ndô tưi. Nốh án la Yê-su, acái Yô-sep, te vel Na-saret.” ");
INSERT INTO pac_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma Na-thanial plốh idô: “Bôn tarnáp amớh ngốh te vel Na-saret?” Phi-lip ôi: “Áu, mái pôq me avai.” ");
INSERT INTO pac_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tư Yê-su hôm Na-thanial tớq nga án, án tông idô: “Án ndô la lư ticuoi Isa-ra-el, án ớq lớng ngê tarphíq.” ");
INSERT INTO pac_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na-thanial plốh Yê-su: “Imo thới chom te mít cư?” Yê-su ôi án idô: “Cư khoiq chom dyơ te Phi-lip iyốh arô mái, ndóng mái át tadưp tôm tarúng.” ");
INSERT INTO pac_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na-thanial tông loi idô: “Thới ơi! Thới la lư Acái Yang Arbang-pilŏ́ng. Alứng thới la lư Puo ticuoi Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yê-su tông idô: “Cư mbơiq tông, ‘Cư khoiq chom dyơ mái, ndóng mái át tadưp tôm tarúng,’ ma imo mái tin táp? Urớh mái lư bôn hôm arnáq pưt clưi te ndô loi!” ");
INSERT INTO pac_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yê-su tông loi: “Cư tông inha arlớih lư, urớh inha bôn hôm pilŏ́ng arớq ngai pốh, alứng bôn tarneng Yang Arbang-pilŏ́ng sớr alứng siar nga Acái Yang Cơt Ticuoi.” ");
INSERT INTO pac_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Vít bar ingái loi, bôn ngai cha arsuoi tớq vel Cana, vúng Ca-lilê. A-i Yê-su át tớq ngki. ");
INSERT INTO pac_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ngai mơi Yê-su alứng top rian te án pôq cha arsuoi tưi. ");
INSERT INTO pac_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tớq sieu khoiq nhéq dyơ, a-i Yê-su tông Yê-su idô: “Hoi-ngki sieu nha-án khoiq nhéq dyơ.” ");
INSERT INTO pac_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yê-su ôi a-i án idô: “Lớiq bôn amớh, a-i. Ndô tới arnáq cư. Ngư cư táq iyốh tớq.” ");
INSERT INTO pac_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iki a-i Yê-su tông ada ticuoi cupơ idô: “Amớh án yua inha táq, inha táq ngki.” ");
INSERT INTO pac_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Top Isa-ra-el bôn rit cóq arau ati nsuoi ính cha. Ma ntúq ngki bôn tupát lám yáng búl veng rit ngki. Mui lám yáng têq cacháq dơq bar pe chít aluoi. ");
INSERT INTO pac_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yê-su yua ticuoi cupơ idô: “Hoi-ngki inha cacháq dơq dyôn pớnh nhéq tớq máh yáng ngki.” Ticuoi cupơ cacháq dơq pớnh li tambír yáng. ");
INSERT INTO pac_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Vít ngki Yê-su yua nha-án loi idô: “Hoi-ngki inha póc dơq te yáng, dyơ angốh dyôn tháu ke ngoiq.” Ticuoi cupơ dông angốh dơq ngki dyôn tháu ke. ");
INSERT INTO pac_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tớq tháu ke ngoiq chim, ma dơq ngki khoiq cơt sieu nho. Tháu ke lớiq chom te mmo sieu ndô tớq, ma top cupơ ndon póc dơq ngki chom. Iki tháu ke arô ticuoi ndon ial campái, ");
INSERT INTO pac_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","alứng tông idô: “Tớq ngai mơi tumoi, ngai báq dyôn tumoi ngoiq sieu iam nsuoi. Tớq tumoi ngoiq a-ưi dyơ, ngki ngai dông angốh sieu atieh loi. Ma chư ndô, inha angốh sieu iam tatun.” ");
INSERT INTO pac_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yê-su táq dơq dyôn cơt sieu tớq vel Cana, vúng Ca-lilê. Ndô la arnáq sileh tôm lư án táq. Án táq iki la án apáh chức ang-ưr án. Iki top rian te án tin án. ");
INSERT INTO pac_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Vít ngki, Yê-su, a-i án, a-em conh án, alứng top rian te án, nhéq nha-án siar lieh nga vel Cabê-na-um. Dyơ nha-án át tớq ngki bar pe ingái. ");
INSERT INTO pac_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tumán tớq ingái top Isa-ra-el cha bui ayư lieh Ingái Ngốh. Iki Yê-su sớr nga vel pưt Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tớq Dúng Sang Pưt, Yê-su tumúh ticuoi tantáiq carrŏ́q, pannán cưu, alứng achếq cacu. Alứng bôn ticuoi pien práq hơ tớq ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iki Yê-su táq mui ntráih ntár, dyơ án prớih angốh nhéq pannán te dúng sang, díh cưu, díh carrŏ́q, alứng án kitúh kichơng ticuoi pien práq, tingôi máh práq lalưai nhéq. ");
INSERT INTO pac_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dyơ Yê-su chuih ticuoi ndon tantáiq achếq cacu, alứng án tông idô: “Inha angốh táp achếq cacu te ntúq ndô. Inha êq táq dúng A-ám cư cơt arớq ntúq táiq plới.” ");
INSERT INTO pac_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Top rian te Yê-su ayư lieh ngai khoiq taran tớq tám uráq Yang Arbang-pilŏ́ng te inớh, idô: “Nhéq mít cannính cư sáng ayáu lư dúng sang Yang Arbang-pilŏ́ng. Iki, cơt arớq uih atóq lư tớq mít cư.” ");
INSERT INTO pac_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Cua ngki top Isa-ra-el plốh Yê-su idô: “Tíc sileh amớh thới ính apáh dyôn he chom, thới bôn chức táq arnáq ndô?” ");
INSERT INTO pac_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yê-su ôi nha-án idô: “Khán talóh dúng sang ndô, cư táq lieh pe ingái la dyơ táp.” ");
INSERT INTO pac_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ticuoi Isa-ra-el plốh sa Yê-su: “Ma imo têq thới táq lieh dúng sang ndô nưm pe ingái sớng? He táq dúng sang ndô nhéq puan chít tupát cumo.” ");
INSERT INTO pac_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma parnai ngki Yê-su acám te cháq án táp la arớq dúng sang. ");
INSERT INTO pac_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tớq vít Yê-su cuchet, dyơ tumống lieh, top rian te Yê-su ayư lieh te parnai Yê-su tông hoi-ndô. Dyơ nha-án tin lư máh parnai tớq tám uráq Yang Arbang-pilŏ́ng alứng máh parnai Yê-su tông. ");
INSERT INTO pac_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yê-su át lieh tớq vel Yaru-salem tingôi ingái top Isa-ra-el cha bui ayư lieh Ingái Ngốh. Ndóng Yê-su át ngki, bôn clứng ticuoi tin án, co nha-án hôm arnáq sileh án khoiq táq. ");
INSERT INTO pac_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma án lớiq náp nha-án, co án chom mít cannính nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Lớiq túh nnáu tông án te mít cannính ticuoi, co án khoiq chom arlớih lư dyơ te mít ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bôn munáq te top Pha-rasi nốh Ni-cudem. Án la te top sút ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bôn mui idáu án tớq nga Yê-su alứng tông idô: “Thới ơi! He khoiq chom dyơ thới tớq te Yang Arbang-pilŏ́ng. Lớiq bôn ngai têq táq arnáq sileh arớq thới táq, khán Yang Arbang-pilŏ́ng lớiq choi dyôn táq máh arnáq ngki.” ");
INSERT INTO pac_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ma Yê-su ôi idô: “Cư tông mái arlớih lư, khán ticuoi mmo lớiq carnian lieh, án lớiq bôn hôm Yang Arbang-pilŏ́ng cơt sút.” ");
INSERT INTO pac_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dyơ Ni-cudem plốh lieh idô: “Imo hôi ticuoi khoiq ieuq ma carnian lieh? Lư ticuoi mmo la lớiq têq mot nnáng tớq pallúng a-i, dyơ carnian lieh mui chư loi!” ");
INSERT INTO pac_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yê-su ôi lieh án idô: “Cư tông mái arlớih lư, khán bôn ticuoi ma lớiq carnian lieh na dơq alứng na Arvai Yang Arbang-pilŏ́ng, ticuoi ngki lớiq têq mot tớq top Yang Arbang-pilŏ́ng sút. ");
INSERT INTO pac_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Khán carnian na ticuoi la ticuoi sớng, ma khán carnian na Arvai Yang Arbang-pilŏ́ng, iki bôn Arvai Yang Arbang-pilŏ́ng át tớq mít cannính án. ");
INSERT INTO pac_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mái êq dut te callong cư tông mái: Inha cóq carnian lieh. ");
INSERT INTO pac_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Muchứng cuyiel phớt tưi, tumo án ính phớt la án phớt. Mái têq sáng hô cuyiel, ma mái lớiq chom te mmo án tớq, alứng tumo án ính pôq. Muchứng cuyiel ngki tưi dyôn nhéq tưh ticuoi ndon carnian lieh na Arvai Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Vít Yê-su tông Ni-cudem iki, Ni-cudem plốh lieh idô: “Dut ớiq! Imo têq ticuoi khoiq ieuq ma carnian lieh tamme?” ");
INSERT INTO pac_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yê-su ôi lieh idô: “Mái la thới pasoi ticuoi Isa-ra-el, ma imo mái lớiq apúh nốh ndô? ");
INSERT INTO pac_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cư tông mái arlớih lư, he tông te máh nốh he khoiq chom alứng khoiq hôm, ma lớiq bôn ngai te inha ính cammáng parnai he. ");
INSERT INTO pac_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cư khoiq tông inha te máh nốh tớq cúc cuteq ndô, ma inha lớiq tin cư; iki imo loi khán cư tông te máh nốh tớq pilŏ́ng? ");
INSERT INTO pac_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lớiq nai bôn ticuoi sớr nga pilŏ́ng. Ma bôn munáq sớng khoiq sớr nga pilŏ́ng. Munáq ndô la Acái Yang Cơt Ticuoi, án ndon khoiq siar te pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Te inớh Môi-se tayŏ́ng cusánh ndon táq tớq apán tớq ntúq aih. Urớh ngai tayŏ́ng Acái Yang Cơt Ticuoi muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Iki, khán ticuoi mmo tin án, ticuoi ngki lư bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yang Arbang-pilŏ́ng bôn nưm mui lám Acái sớng. Co án amoih nhéq tưh ticuoi, iki án dyôn Acái án siar át tớq cuteq ndô. Ticuoi mmo tin Acái án, arvai ticuoi ngki lớiq nai cuchet nnáng, ma bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yang Arbang-pilŏ́ng lớiq bôn yua Acái án siar nga cuteq ndô dŏq sưq ticuoi, ma án ính choi tamống nhéq tưh ticuoi co nhơ te Acái án. ");
INSERT INTO pac_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ticuoi mmo khoiq tin Acái Yang Arbang-pilŏ́ng, Yang Arbang-pilŏ́ng lư lớiq táq ticuoi ngki. Ma ticuoi mmo lớiq tin, án taroi ính táq ticuoi ngki, co ticuoi ngki lớiq tin Acái án. ");
INSERT INTO pac_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yang Arbang-pilŏ́ng taroi ính táq ticuoi ngki la co idô: Callong ang khoiq tớq dyơ nga cúc cuteq ndô, ma ticuoi ayáu callong ngiau hơn te callong ang, la co nha-án táq arnáq saq. ");
INSERT INTO pac_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nhéq máh ticuoi ndon táq arnáq saq a-ính lư callong ang. Nha-án lớiq ính tớq nga callong ang, co nha-án adáh ngai chom te máh arnáq saq nha-án khoiq táq. ");
INSERT INTO pac_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma ticuoi mmo veng tapun arnáq piaiq, nha-án ính lư tớq nga callong ang. Nha-án ính callong ang apáh nha-án peh máh ngê Yang Arbang-pilŏ́ng ính nha-án táq.” ");
INSERT INTO pac_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cua Yê-su cato iki, án alứng top rian te án mot tớq vúng Yudê. Nha-án át nga tuki co ính táq tíc na dơq dyôn ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ndóng ngki Yon táq tíc na dơq tớq ntúq Anôn, tumán vel Salim, co ntúq ngki bôn a-ưi dơq. Alứng bôn ticuoi tớq níc nga Yon ính án táq tíc na dơq dyôn nha-án. ");
INSERT INTO pac_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ndóng ngki ngai iyốh crál Yon tớq coq tôt.) ");
INSERT INTO pac_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Vít ngki, top rian te Yon tarmien alứng munáq ticuoi Isa-ra-el te rit sarau. ");
INSERT INTO pac_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dyơ top rian te Yon tớq nga án alứng tông idô: “Thới ơi! Munáq ndon át alứng thới, ndóng thới át pa dyáng atóh dơq crong Yôr-dan, án ndon thới khoiq tông dyôn he chom, hoi-ndô án táq tíc na dơq dyôn ticuoi. Alứng a-ưi ticuoi tớq nga án.” ");
INSERT INTO pac_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yon ôi nha-án idô: “Ticuoi lớiq têq táq mui arnáq amớh khán Yang Arbang-pilŏ́ng lớiq dyôn án táq. ");
INSERT INTO pac_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Inha chom dyơ cư khoiq tông idô: ‘Cư tới Crit. Ma Yang Arbang-pilŏ́ng yua cư tớq nsuoi Crit.’ ");
INSERT INTO pac_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Callong ndô la arớq parnai acám idô: Khán bôn munáq pôq tarcớiq campái, yớu án pôq munơi alứng án. Ma nha-án lớiq têq cơt ưlla cán ngki. Ma nha-án sáng bui tưi alứng yớu nha-án. Hoi-ndô cư bôn nưm callong bui sớng tớq mít cannính cư, co Crit khoiq tớq dyơ. ");
INSERT INTO pac_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Án ngki cóq cơt pưt asớr, ma cư cóq cơt két asiar. ");
INSERT INTO pac_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Án ndon tớq te tanieng, án pưt clưi nhéq te cannŏ́h. Ma án ndon tớq te cúc cuteq, lư cơt na cúc cuteq, alứng án tông nưm nốh tớq cuteq sớng. Ma án ndon tớq te pilŏ́ng, án pưt clưi nhéq te cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Án tông te máh nốh án khoiq hôm alứng khoiq sáng, ma lớiq bôn ngai ính cammáng parnai án. ");
INSERT INTO pac_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ticuoi mmo náp parnai án tông, la ticuoi ngki ngin Yang Arbang-pilŏ́ng la piaiq lư. ");
INSERT INTO pac_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yang Arbang-pilŏ́ng khoiq yua Yê-su tớq cato parnai Yang Arbang-pilŏ́ng. Co iki Yang Arbang-pilŏ́ng dyôn Yê-su bôn Arvai án. ");
INSERT INTO pac_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A-ám amoih Acái, alứng án mŏp túc nốh dyôn Acái án cơt sút. ");
INSERT INTO pac_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ticuoi mmo tin Acái Yang Arbang-pilŏ́ng, ticuoi ngki lư bôn tumống níc-níc. Ma ticuoi mmo lớiq peh parnai Acái Yang, ticuoi ngki lớiq têq bôn tumống níc-níc alứng án táq ticuoi ngki.” ");
INSERT INTO pac_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Top Pha-rasi khoiq sáng ngai táq-ntêr bôn a-ưi ticuoi veng tapun Yê-su, alứng án táq tíc na dơq dyôn ticuoi a-ưi hơn te Yon. ");
INSERT INTO pac_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma callong lư, ati Yê-su lớiq bôn táq tíc na dơq dyôn ticuoi, nưm top rian te án táp táq. ");
INSERT INTO pac_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tư án chom top Pha-rasi khoiq sáng ngai tông iki, dyơ án ngốh táp te vúng Yudê; án píh chô lieh nga vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma carna ndon án ính pôq cóq pôq pha vúng Sa-mari. ");
INSERT INTO pac_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tớq vúng Sa-mari, Yê-su tớq nga vel Su-kha. Vel ngki tumán ntúq rong Yacốp khoiq dyôn Yô-sep acái conh án te inớh. ");
INSERT INTO pac_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Alứng bôn dơq yieng Yacốp khoiq píq te inớh tớq ntúq ngki. Yê-su sáng aleq lư, co án pôq níc. Iki án ticu tumán dơq yieng; ma ndóng ngki mát pandang khoiq tumán tứng. ");
INSERT INTO pac_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bôn munáq cán Sa-mari tớq dyít dơq. Dyơ Yê-su seq te cán ngki idô: “Ơi ơi! Seq ngoiq tưi dơq mái!” ");
INSERT INTO pac_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ma ndóng ngki top rian te Yê-su mot tớq vel, ính plới crơng tanna.) ");
INSERT INTO pac_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Cán ngki ôi án idô: “Áu! Mái la ticuoi Isa-ra-el, ma imo mái seq ngoiq dơq te cư? Co cư la ticuoi Sa-mari.” (Án tông iki co top Isa-ra-el lớiq artoi alứng top Sa-mari.) ");
INSERT INTO pac_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yê-su ôi án idô: “Khán mái chom te callong Yang Arbang-pilŏ́ng ính choi mat, alứng khán mái chom án ndon seq ngoiq dơq te mái, piaiq lư la mái seq te án, iki án lư dyôn mái bôn dơq têq dyôn tumống.” ");
INSERT INTO pac_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Cán ngki ôi lieh Yê-su idô: “Thới ơi! Thới ớq crơng póc dơq, alứng dơq yieng ndô sru lư. Iki te mmo thới bôn dơq têq dyôn tumống? ");
INSERT INTO pac_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Achúc achiac he Yacốp khoiq píq dơq yieng ndô dyôn he. Án alứng nhéq acái conh án díh máh pannán án, nhéq nha-án ngoiq tưi dơq te yieng ndô te inớh. Thới sút hơn te Yacốp lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma Yê-su ôi lieh idô: “Ticuoi ndon ngoiq dơq te yieng ndô, ngki nnáng hál. ");
INSERT INTO pac_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma ticuoi mmo ngoiq dơq cư dyôn án, án lư lớiq nai hál nnáng. Co dơq cư dyôn cơt arớq dơq abóc hoi níc tớq mít cannính án. Alứng dơq ngki dyôn án bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Cán ngki tông idô: “Thới ơi! Seq thới dyôn cư bôn tưi dơq ngki, ien cư lớiq bôn hál nnáng, alứng lớiq túh tớq dyít nnáng dơq te yieng ndô.” ");
INSERT INTO pac_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yê-su ôi án: “Mái chô cớiq cayieq mái nga dúng, dyơ mái tớq tumúh lieh cư nga tudô nư.” ");
INSERT INTO pac_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Cán ngki ôi: “Cư ớq cayieq.” Yê-su ôi lieh án idô: “Mái ôi crái lư! Mái ớq cayieq. ");
INSERT INTO pac_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ma mái khoiq bôn cayieq sông náq dyơ; conh ndon át alứng mái hoi-ndô, án tới cayieq mái. Lư crái arớq mái khoiq ôi.” ");
INSERT INTO pac_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Cán ngki tông lieh idô: “Thới ơi! Mbơiq ngki cư chom thới la ticuoi tang ngcang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Achúc achiac he khoiq sang Yang Arbang-pilŏ́ng dưnh dyơ tớq cóh ndô, ma inha top Isa-ra-el tông ntúq sang Yang Arbang-pilŏ́ng nưm tớq vel Yaru-salem.” ");
INSERT INTO pac_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yê-su tông idô: “Ơi ơi! Seq mái tin parnai cư. Tumán ính tớq dyơ ingái ticuoi ính sang A-ám he tớq pilŏ́ng, nha-án lớiq cóq sang tớq cóh ndô lớiq la tớq vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Inha top Sa-mari iyốh chom arlớih nnáu lư inha sang. Ma he top Isa-ra-el khoiq chom arlớih dyơ nnáu he sang, co Yang Arbang-pilŏ́ng choi tamống ticuoi nhơ te top Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma tumán ính tớq, alứng khoiq tớq dyơ ingái ticuoi ính sang tám piaiq lư, nha-án sang nhéq te mít cannính, alứng sang crái lư. A-ám he ính lư ticuoi sang án arớq iki. ");
INSERT INTO pac_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yang Arbang-pilŏ́ng la lư Yang. Iki, ticuoi mmo ính sang án, cóq sang nhéq mít cannính alứng sang dyôn piaiq.” ");
INSERT INTO pac_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Cua Yê-su tông iki, cán ngki tông loi idô: “Cư khoiq chom dyơ, urớh lư tớq án ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi, nốh án la Crit. Tư án tớq, án tông dyôn he chom cứp nốh.” ");
INSERT INTO pac_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yê-su tông ada án: “Cư ndon táq-ntêr alứng mái hoi-ndô táp la án.” ");
INSERT INTO pac_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ndóng ngki top rian te Yê-su tớq lieh nga án. Nha-án sáng dut lư án táq-ntêr alứng cán ngki. Ma lớiq bôn nnáu plốh cán ngki: “Amớh mái ính bôn?” Alứng lớiq bôn nnáu plốh Yê-su: “Imo thới táq-ntêr alứng án?” ");
INSERT INTO pac_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dyơ cán ngki táh aluoi dơq alứng án chô táq-ntêr dyôn ticuoi tớq vel chom. ");
INSERT INTO pac_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Án tông idô: “Áu inha pôq me munáq ticuoi ndon tông nheq te máh arnáq cư khoiq táq. Ticuoi ndô lư Crit, ma lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iki nhéq máh ticuoi tớq vel pôq nga ntúq Yê-su át. ");
INSERT INTO pac_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ndóng máh ticuoi ndon ngốh te vel nnáng dira carna, top rian te Yê-su patot án idô: “Thới ơi, chicha dôi avai.” ");
INSERT INTO pac_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma Yê-su ôi nha-án idô: “Cư bôn crơng tanna cha dyơ, ma inha lớiq chom crơng tanna ngki.” ");
INSERT INTO pac_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iki top rian te án, munáq plốh munáq idô: “Bôn ticuoi dông tanna dyôn án cha lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Yê-su tông idô: “Crơng tanna cư la cư táq veng cannính án ndon yua cư tớq, alứng táq dyôn dyơ arnáq án ính cư táq. ");
INSERT INTO pac_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lư ma lớiq, he báq tông idô: ‘Yôl puan kisái loi tớq ngư apot?’ Ma cư tông inha idô: Inha clang me nga pidái. Sro khoiq dom alứng tớq dyơ ngư apot. ");
INSERT INTO pac_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ticuoi sot sro chón bôn ráp cống alứng chón pachúng dŏq culái ndon dyôn têq bôn tumống níc-níc. Iki ticuoi chớt alứng ticuoi sot sáng bui munơi. ");
INSERT INTO pac_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Báq ngai tông idô: ‘Ticuoi ndô chớt, ticuoi ngki sot.’ Parnai ndô lư crái. ");
INSERT INTO pac_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Cư khoiq yua inha sot tớq pidái ndon inha lớiq bôn chớt. Ticuoi cannŏ́h khoiq táq pidái ngki, ma inha bôn ial tưi culái te cống rêng nha-án.” ");
INSERT INTO pac_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A-ưi náq ticuoi Sa-mari tớq vel ngki tin Yê-su, co nhơ cán ngki tông nha-án idô: “Ticuoi ngki tông nheq te máh arnáq cư khoiq táq.” ");
INSERT INTO pac_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iki, tư ticuoi Sa-mari tớq nga Yê-su, nha-án cayúng Yê-su dyôn át alứng nha-án. Dyơ Yê-su át tớq ntúq ngki bôn bar ingái. ");
INSERT INTO pac_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Alứng bôn a-ưi náq loi mot tin tớq nha-án sáng parnai Yê-su cato. ");
INSERT INTO pac_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Máh ticuoi tin tông ada cán ngki idô: “Te nsuoi, he tin Yê-su co nhơ mái tông he, ma hoi-ndô he sáng án táp cato. Iki he chom arlớih, án la ticuoi choi tamống nhéq tưh ticuoi.” ");
INSERT INTO pac_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Vít bar ingái, Yê-su ngốh te ngki, án ính pôq lieh nga vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Te nsuoi Yê-su khoiq tông dyơ idô: “Ticuoi tang ngcang Yang Arbang-pilŏ́ng, lớiq bôn ngai dyám náp án tớq cruong án bôm.” ");
INSERT INTO pac_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tư Yê-su tớq nga vúng Ca-lilê, ticuoi Ca-lilê pasôl án bui ŏ, co nha-án khoiq hôm máh arnáq án táq tớq vel pưt Yaru-salem ndóng nha-án pôq cha bui veng rit Ingái Ngốh. ");
INSERT INTO pac_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iki Yê-su tớq lieh nga vel Cana, vúng Ca-lilê. Tớq vel ngki Yê-su khoiq táq dyôn dơq cơt sieu nho. Alứng bôn munáq ticuoi sút, acái conh án bíq rom a-ái tớq vel Cabê-na-um. ");
INSERT INTO pac_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tư ticuoi sút ndô sáng ngai táq-ntêr Yê-su khoiq ngốh te vúng Yudê, alứng pôq nga vúng Ca-lilê, iki án tớq nga Yê-su. Án seq Yê-su pôq nga vel Cabê-na-um alứng táq bánh acái conh án. Co acái án khoiq tumán cuchet dyơ. ");
INSERT INTO pac_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yê-su tông án idô: “Khán inha lớiq hôm tíc sileh, inha lớiq tin.” ");
INSERT INTO pac_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ticuoi sút ngki ôi idô: “Ưlla ơi! Seq Ưlla pôq alứng cư, atôm ndóng acái cư yôl tumống.” ");
INSERT INTO pac_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yê-su ôi án idô: “Pôq! Mái chô. Hoi-ndô acái conh mái lớiq bôn cuchet.” Iki án tin parnai Yê-su tông; dyơ án chô. ");
INSERT INTO pac_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ndóng án pôq dira carna; án tumúh máh ticuoi sol án. Ticuoi sol án tông án idô: “Acái conh ưlla khoiq bánh dyơ.” ");
INSERT INTO pac_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ticuoi sút ngki plốh nha-án: “Ndóng mmo acái cư môih lieh?” Nha-án ôi: “Acái ưlla pít atóq cháq ingái inô, ndóng pandang viet-mát.” ");
INSERT INTO pac_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ticuoi sút ngki ayư lieh ndóng Yê-su tông án idô: “Hoi-ndô acái conh mái lớiq bôn cuchet.” Iki án alứng nhéq abŏ́h án tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ndô la chư bar Yê-su táq arnáq sileh tớq vúng Ca-lilê, vít án ngốh te vúng Yudê. ");
INSERT INTO pac_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tatun ngki Yê-su pôq nga vel Yaru-salem loi. Ingái ngki top Isa-ra-el cha bui veng rit nha-án. ");
INSERT INTO pac_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tớq vel Yaru-salem, tumán ngáh callống, nốh Callống Pannán Cưu, bôn mui alúq dơq. Tớq cang Isa-ra-el dŏq Bê-thada. Paniar alúq ndô bôn sông ntúq ntrôn. ");
INSERT INTO pac_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Máh ticuoi a-ái ndon bíq tớq ntrôn ngki la idô: Ticuoi sot, ticuoi dyuat, alứng ticuoi a-ái cớng. (Máh ticuoi a-ái át pớn dơq alúq calchớq, ");
INSERT INTO pac_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","co bôn mui tarneng Yang Arbang-pilŏ́ng siar táq dyôn dơq calchớq. Tớq dơq calchớq, án mmo siar nsuoi, án ngki cơt bánh.) ");
INSERT INTO pac_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tớq ntúq ngki bôn munáq conh a-ái khoiq pe chít ticol cumo. ");
INSERT INTO pac_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yê-su hôm conh ngki bíq tớq ntúq ngki, alứng Yê-su chom án a-ái khoiq dưnh dyơ. Iki Yê-su plốh án: “Mái ính cơt bánh lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Conh ngki ôi: “Avốq ơi! Lớiq bôn nnáu choi asiar cư tớq dơq alúq ndóng dơq ndô calchớq. Cư ính siar, ma lớiq atôm ticuoi cannŏ́h; nha-án siar nsuoi cư.” ");
INSERT INTO pac_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yê-su tông án idô: “Mái yôr tayứng! Ial nchiauq mái. Dyơ mái ticaq pôq!” ");
INSERT INTO pac_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ndóng ngki táp ticuoi a-ái ngki cơt bánh tháng. Án ial nchiauq alứng ticaq pôq. Ingái ngki la Ingái Angô veng rit top Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iki bôn ticuoi Isa-ra-el tông ada ticuoi ndon khoiq bánh ngki idô: “Ingái ndô la Ingái Angô. Veng rit he, mái lớiq têq ial nchiauq tớq ingái ndô.” ");
INSERT INTO pac_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Án ôi idô: “Án ndon táq dyôn cư cơt bánh yua cư idô: ‘Mái ial nchiauq mái, dyơ mái ticaq pôq.’” ");
INSERT INTO pac_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dyơ nha-án plốh án idô: “Nnáu yua mái ial nchiauq, dyơ dyôn mái ticaq pôq?” ");
INSERT INTO pac_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma ticuoi khoiq bánh ngki lớiq chom nnáu táq dyôn án cơt bánh, co Yê-su mot plian tớq ticuoi clứng. ");
INSERT INTO pac_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tớq tatun, Yê-su tumúh lieh ticuoi ndon a-ái cơt bánh ngki tớq Dúng Sang Pưt. Dyơ Yê-su tông án idô: “Hoi-ndô mái khoiq bánh dyơ. Mái êq táq nnáng arnáq luaih. Khán mái táq, dáh lơ mái tumúh dieiq arức clưi te nsuoi loi.” ");
INSERT INTO pac_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ticuoi ngki ngốh te ntúq ngki, alứng án táq-ntêr dyôn top Isa-ra-el chom Yê-su táp khoiq táq dyôn án cơt bánh. ");
INSERT INTO pac_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Co tian Yê-su táq arnáq sileh tớq Ingái Angô, iki top Isa-ra-el suo ngê ính táq án. ");
INSERT INTO pac_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yê-su tông nha-án idô: “A-ám cư táq níc arnáq tingôi hoi-ndô; iki cư táq muchứng án tưi.” ");
INSERT INTO pac_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Co Yê-su tông iki, top Isa-ra-el suo a-ưi ngê ính cachet án. Nha-án tông án táq bar nốh lớiq crái. Tới nưm án táh phep rit sớng, ma án dŏq Yang Arbang-pilŏ́ng la A-ám án hơ. Án tông iki la muchứng án ngin án li-arli alứng Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yê-su tông top Isa-ra-el idô: “Cư tông inha arlớih lư, cư Acái Yang Arbang-pilŏ́ng lớiq têq táq mui callong amớh nưm munáq cư. Acái táq veng tapun A-ám án táq. Arnáq amớh A-ám án táq, Acái lư táq muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Co A-ám amoih Acái, iki A-ám apáh Acái túc nốh arnáq án táq. Urớh, A-ám ính apáh dyôn Acái hôm arnáq ndon pưt clưi te ndô, dŏq dyôn inha sáng dut lư loi. ");
INSERT INTO pac_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Co A-ám khoiq dyôn ticuoi cuchet bôn tumống lieh, muchứng ngki tưi Acái dyôn callong tumống nga nhéq tưh ticuoi ndon án ính dyôn. ");
INSERT INTO pac_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A-ám lớiq sưq máh ticuoi. Ma án dyôn Acái án bôn chức sưq máh ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Iki, ticuoi mmo dyám náp A-ám, ticuoi ngki cóq dyám náp díh Acái hơ. Ticuoi mmo lớiq dyám náp Acái, ticuoi ngki lớiq dyám náp díh A-ám ndon yua Acái tớq nga cúc cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Cư tông inha arlớih lư, ticuoi mmo cammáng parnai cư, alứng tin án ndon yua cư tớq, ticuoi ngki bôn tumống níc-níc, alứng lớiq bôn ngai sưq nnáng án. Án vít te callong cuchet; ma án bôn nưm callong tumống sớng. ");
INSERT INTO pac_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cư tông inha arlớih lư, tumán ính tớq alứng khoiq tớq dyơ ingái ticuoi khoiq cuchet bôn sáng sieng Acái Yang Arbang-pilŏ́ng; dyơ arvai nha-án bôn tumống. ");
INSERT INTO pac_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Co A-ám bôn chức dyôn ticuoi bôn tumống, iki án dyôn Acái bôn chức dyôn ticuoi bôn tumống tưi. ");
INSERT INTO pac_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Alứng A-ám khoiq dyôn Acái bôn chức sưq ticuoi, co án la Acái Yang Cơt Ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Inha êq dut te callong ndô, co lư tớq ingái ticuoi cuchet ndon ngai khoiq tứp tớq ping bôn sáng tưi sieng Acái ngki. ");
INSERT INTO pac_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Dyơ nha-án ngốh te ping. Ticuoi mmo khoiq táq arnáq ŏ, ticuoi ngki ngốh alứng tumống ien ŏ. Ma ticuoi mmo khoiq táq arnáq saq, ticuoi ngki ngốh tưi, ma nnáng Yang Arbang-pilŏ́ng sưq alứng dyôn án ráp tôt. ");
INSERT INTO pac_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Cư lớiq têq táq amớh khán veng cannính cư bôm. Ma parnai amớh cư sáng te A-ám cư, cư lư sưq ticuoi veng lieh parnai ngki. Iki cư sưq tinớng lư, co cư lớiq veng cannính cư bôm, ma cư táq veng cannính án ndon yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Khán cư tông parnai cư bôm, parnai ndô lớiq lư amớh. ");
INSERT INTO pac_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma A-ám cư tông te cư tưi, alứng cư chom parnai án tông te cư la crái lư. ");
INSERT INTO pac_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Inha khoiq yua ngai tớq nga Yon, alứng án khoiq tông te cư la nhéq callong lư. ");
INSERT INTO pac_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma cư, cư lớiq bôn ráp parnai ndô te ticuoi. Cư tông inha parnai ndô dŏq Yang Arbang-pilŏ́ng têq choi tamống inha. ");
INSERT INTO pac_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yon la arớq tabong claq dyôn ang. Inha ính callong ang te án muhoi sớng. ");
INSERT INTO pac_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ma pưt hơn te parnai Yon khoiq cato te cư la bôn arnáq A-ám cư khoiq mŏp dyôn cư táq. Arnáq ndô táp apáh dyôn ticuoi chom A-ám cư yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Alứng A-ám cư, án ndon yua cư tớq, án tông te cư tưi. Inha lớiq nai sáng sieng án, lớiq nai hôm armaiq án, ");
INSERT INTO pac_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","alứng parnai án lớiq bôn át tớq mít inha, co inha lớiq tin cư ndon A-ám yua dyôn tớq. ");
INSERT INTO pac_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Inha suo rian a-ưi te parnai Yang Arbang-pilŏ́ng, co inha parngíh têq bôn tumống níc-níc co nhơ te inha rian parnai ngki. Alứng parnai Yang Arbang-pilŏ́ng táp tông te cư, ");
INSERT INTO pac_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ma nnáng inha lớiq ính tớq nga cư dyôn inha bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ticuoi ayô cư lớiq bôn tarnáp amớh. ");
INSERT INTO pac_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma cư khoiq chom dyơ inha. Cư chom mít inha lớiq amoih Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cư khoiq tớq tudô bôn chức te A-ám cư, ma nnáng inha lớiq ính ráp cư. Ma khán bôn ticuoi cannŏ́h tớq cliau chức án bôm, ngki chái lư inha ráp án. ");
INSERT INTO pac_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Inha ính lư ticuoi cannŏ́h ayô inha, ma inha lớiq suo dyôn Yang Arbang-pilŏ́ng ayô inha; nưm munáq án táp la lư Yang. Iki, imo têq inha tin án? ");
INSERT INTO pac_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Inha êq parngíh cư ính cauq inha nga A-ám cư. Lư to Môi-se táp khoiq cauq inha, án ndon inha ngcong tớq choi inha. ");
INSERT INTO pac_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Khán inha lư tin Môi-se, ngki inha tin cư tưi, co Môi-se khoiq taran te cư. ");
INSERT INTO pac_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma khán inha lớiq tin parnai Môi-se khoiq taran, imo inha têq tin parnai cư tông inha hoi-ndô?” ");
INSERT INTO pac_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Vít ngki, Yê-su dyang lieh clóng Ca-lilê. Clóng ndô ngai dŏq clóng Tubê-riet hơ. ");
INSERT INTO pac_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Clứng lư ticuoi veng tapun Yê-su, co nha-án hôm te arnáq sileh Yê-su khoiq táq bánh ticuoi a-ái. ");
INSERT INTO pac_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yê-su sớr tớq cóh, dyơ án ticu ntúq ngki alứng top rian te án. ");
INSERT INTO pac_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ndóng ngki tumán ính tớq ingái top Isa-ra-el cha bui ayư Ingái Ngốh. ");
INSERT INTO pac_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tư Yê-su tingơ, án hôm clứng ticuoi tớq nga án; dyơ án tông Phi-lip idô: “Ntúq mmo he ính pôq plới crơng tanna dyôn khám máh ticuoi ndô cha?” ");
INSERT INTO pac_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yê-su plốh iki ính chim Phi-lip sớng, co án khoiq chom dyơ arnáq án ính táq. ");
INSERT INTO pac_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Phi-lip ôi idô: “Khán ngai thuthe bar culám ingái, dyơ ial práq cống ngki plới tanna dyôn máh ticuoi ndô cha munáq mui mêng sớng la lớiq cứp.” ");
INSERT INTO pac_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Bôn munáq loi, te top rian te Yê-su, nốh Anrê, a-em Si-môn Phi-er. ");
INSERT INTO pac_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Án tông idô: “Bôn munáq ngai-acái conh át tớq ndô. Án bôn sông lám beng alứng bar lám buaiq. Ma imo têq khám dyôn máh ticuoi ndô cha?” ");
INSERT INTO pac_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yê-su ôi idô: “Dyôn ticuoi clứng ndô ticu.” Tớq ntúq ngki bôn sác asam; dyơ nha-án ticu. Nhéq máh ticuoi conh sasai bôn sám sông ngin náq. ");
INSERT INTO pac_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yê-su ial beng alứng si-ơn Yang Arbang-pilŏ́ng. Cua ngki án mpô dyôn máh ticuoi ndon ticu ngki. Án táq muchứng ngki tưi ada buaiq. Dyơ dyôn nha-án tíng cha máh-mmo nha-án ính cha. ");
INSERT INTO pac_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tư nhéq máh ticuoi cha sái dyơ, Yê-su yua top rian te án idô: “Inha pachúng lieh máh ntie clưi te ngai cha. Êq táh mui nốh amớh.” ");
INSERT INTO pac_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iki nha-án pachúng lieh máh ntie bôn mui chít la bar carie, clưi te ngai cha. ");
INSERT INTO pac_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tớq máh ticuoi ngki hôm Yê-su táq arnáq sileh ndô, nha-án tông idô: “Lư simớt, ticuoi ndô la munáq tang ngcang Yang Arbang-pilŏ́ng, ndon Yang Arbang-pilŏ́ng khoiq yua dyôn tớq nga cúc cuteq ndô.” ");
INSERT INTO pac_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yê-su chom máh ticuoi ngki parngíh ính cŏp án, alứng ính patot án dyôn cơt puo. Iki án ngốh te ntúq ngki, alứng án sớr nga cóh munáq án. ");
INSERT INTO pac_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tớq ibư, top rian te Yê-su siar nga tor dơq clóng. ");
INSERT INTO pac_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Dyơ nha-án sớr tớq tuoc ính dyang pa dyáng atóh dơq clóng, pôq nga vel Cabê-na-um. Pilŏ́ng khoiq ngiau, ma Yê-su iyốh tớq nga nha-án. ");
INSERT INTO pac_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Cuyiel phớt hớp lư, alứng dơq calchớq. ");
INSERT INTO pac_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tư top rian te Yê-su khoiq cor tuoc clưi tupát ki-lô-met dyơ, nha-án hôm Yê-su ticaq tớq lar dơq, tumán ính tớq nga tuoc nha-án. Iki nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma Yê-su tông nha-án idô: “Ndô la cháq cư. Inha êq adáh.” ");
INSERT INTO pac_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Cua ngki, nha-án dyôn Yê-su sớr tớq tuoc; ma ndóng ngki táp tuoc nha-án tớq nga tor, nga ntúq nha-án ính pôq. ");
INSERT INTO pac_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ang iláih parnô, ticuoi clứng ngki yôl át tớq ntúq Yê-su chiam nha-án. Nha-án chom ibư inô, tớq ntúq ndô bôn nưm mui lám sớng tuoc. Alứng nha-án chom Yê-su lớiq bôn sớr tớq tuoc alứng top rian te án. Ma nưm top rian te án sớng át tớq tuoc ngki. ");
INSERT INTO pac_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma ingái ngki bôn tuoc cannŏ́h tớq te vel Tubê-riet. Tuoc ndô pôq pha tumán ntúq Yê-su khoiq si-ơn Yang Arbang-pilŏ́ng bôn beng, alứng dyôn ticuoi clứng cha. ");
INSERT INTO pac_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tư ticuoi clứng chom Yê-su alứng top rian te án lớiq át tớq ntúq ngki, iki nha-án sớr tớq tuoc alứng pôq suo Yê-su nga vel Cabê-na-um. ");
INSERT INTO pac_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tư ticuoi clứng tumúh Yê-su pa dyáng atóh dơq clóng, dyơ nha-án plốh án idô: “Thới ơi! Ndóng mmo thới tớq nga tudô?” ");
INSERT INTO pac_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yê-su ôi nha-án idô: “Cư tông inha arlớih lư, inha suo cư tới co inha khoiq hôm arnáq sileh cư táq, ma inha suo cư co ingái inô inha khoiq cha sái crơng tanna cư dyôn. ");
INSERT INTO pac_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Inha êq táq arnáq dŏq sisuo crơng tanna tớq pang ndô sớng. Co tanna ndô cơt nsốq. Ma cóq inha sisuo tanna dyôn inha têq bôn tumống níc-níc. Tanna ndô, Acái Yang Cơt Ticuoi táp têq dyôn inha bôn, co Yang Arbang-pilŏ́ng, A-ám án, khoiq dyôn án bôn chức táq arnáq iki.” ");
INSERT INTO pac_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dyơ top nha-án plốh Yê-su idô: “Amớh he cóq táq, dŏq táq arnáq Yang Arbang-pilŏ́ng ính he táq?” ");
INSERT INTO pac_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yê-su ôi nha-án idô: “Arnáq Yang Arbang-pilŏ́ng ính inha táq la idô: Cóq inha tin án ndon Yang Arbang-pilŏ́ng khoiq yua dyôn tớq nga tudô.” ");
INSERT INTO pac_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Top nha-án plốh sa: “Bôn tíc sileh amớh thới ính táq dyôn he hôm, dyôn he têq tin thới? Tíc amớh nếq thới ính táq? ");
INSERT INTO pac_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Achúc achiac he te inớh cha beng ndon siar te pilŏ́ng tớq ntúq aih. Callong ndô ngai khoiq taran tớq tám uráq Yang Arbang-pilŏ́ng idô: ‘Án dyôn nha-án bôn cha beng siar te pilŏ́ng.’” ");
INSERT INTO pac_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yê-su ôi lieh nha-án idô: “Cư tông inha arlớih lư, tới Môi-se dyôn inha cha beng te pilŏ́ng. Ma nưm A-ám cư táp dyôn inha bôn cha beng lư, beng ngki án asiar te pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Beng na Yang Arbang-pilŏ́ng dyôn la án ndon siar te pilŏ́ng, alứng dyôn nhéq tưh ticuoi bôn tumống.” ");
INSERT INTO pac_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nha-án ôi lieh idô: “Thới ơi! Seq thới dyôn he bôn níc beng ngki.” ");
INSERT INTO pac_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yê-su tông nha-án idô: “Cư táp la beng dyôn ticuoi bôn tumống. Ticuoi mmo tớq nga cư, ticuoi ngki lớiq nai sáng pinhaih. Alứng ticuoi mmo tin cư, ticuoi ngki lớiq nai sáng hál. ");
INSERT INTO pac_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma cư tông inha arlớih lư, inha hôm cư, ma inha lớiq tin cư. ");
INSERT INTO pac_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nhéq máh ticuoi ndon A-ám cư dyôn tớq nga cư, nha-án lư tớq nga cư. Alứng máh ticuoi ndon tớq nga cư, cư lớiq nai chuih nha-án. ");
INSERT INTO pac_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Cư siar te pilŏ́ng, tới co ính veng cannính cư bôm, ma cư ính veng cannính án ndon yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cannính án ndon yua cư tớq la idô: Te nhéq máh ticuoi ndon án khoiq dyôn cư, mui náq la án lớiq ính pít. Alứng tớq ingái talloiq, án ính cư dyôn máh ticuoi cuchet bôn tumống lieh. ");
INSERT INTO pac_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Co A-ám cư ính nhéq tưh ticuoi ndon chom Acái án alứng tin Acái án, bôn tumống níc-níc. Alứng tớq ingái talloiq, cư dyôn nhéq tưh ticuoi ngki bôn tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cua Yê-su tông iki, top Isa-ra-el ngki lái nhannha-nhannhóm te Yê-su, co án khoiq tông idô: “Cư la beng ndon siar te pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Top Isa-ra-el tông idô: “Lư ma lớiq, ticuoi ndô la Yê-su, acái Yô-sep? He chom a-i a-ám án. Imo têq án tông án siar te pilŏ́ng?” ");
INSERT INTO pac_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yê-su ôi nha-án idô: “Inha êq lái nhannha-nhannhóm nnáng. ");
INSERT INTO pac_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Khán A-ám cư tớq pilŏ́ng, án ndon yua cư tớq nga tudô, lớiq tec ticuoi dyôn tớq nga cư, ticuoi ngki lư lớiq têq tớq nga cư. Alứng tớq ingái talloiq, cư lư dyôn ticuoi ngki yôr tumống lieh. ");
INSERT INTO pac_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ngai khoiq taran tớq tám uráq ticuoi tang ngcang Yang Arbang-pilŏ́ng idô: ‘Yang Arbang-pilŏ́ng ính pasoi nhéq tưh ticuoi.’ Ticuoi mmo cammáng parnai A-ám, alứng rian te án, ticuoi ngki lư tớq nga cư. ");
INSERT INTO pac_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Lớiq bôn nnáu hôm A-ám tớq pilŏ́ng, ma nưm munáq án ndon tớq te Yang Arbang-pilŏ́ng táp khoiq hôm A-ám. ");
INSERT INTO pac_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cư tông inha arlớih lư, ticuoi mmo tin cư, ticuoi ngki lư bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Cư la beng dyôn nhéq tưh ticuoi têq bôn tumống. ");
INSERT INTO pac_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Achúc achiac inha khoiq cha mana te pilŏ́ng tớq ntúq aih, ma nha-án nnáng cuchet. ");
INSERT INTO pac_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma beng ndon siar te pilŏ́ng; ticuoi mmo bôn cha, ticuoi ngki lớiq nai cuchet nnáng. ");
INSERT INTO pac_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Cư la beng tumống ndon khoiq siar te pilŏ́ng. Khán ticuoi mmo cha beng ndô, ticuoi ngki bôn tumống níc-níc. Beng ndô la sáiq cư ndon dyôn nhéq tưh ticuoi têq bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Cua Yê-su tông iki, ticuoi te top Isa-ra-el tarmien tartuoq, alứng plốh idô: “Imo têq ticuoi conh ndô dyôn he cha sáiq án?” ");
INSERT INTO pac_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yê-su tông lieh nha-án idô: “Cư tông inha arlớih lư, khán inha lớiq cha sáiq Acái Yang Cơt Ticuoi, alứng lớiq ngoiq aham án, inha lớiq têq bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ticuoi mmo cha sáiq alứng ngoiq aham cư, ticuoi ngki bôn tumống níc-níc, alứng tớq ingái talloiq, cư lư dyôn ticuoi ngki tumống lieh. ");
INSERT INTO pac_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Co sáiq cư la lư crơng tanna, alứng aham cư la lư crơng ngoiq. ");
INSERT INTO pac_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ticuoi mmo cha sáiq cư alứng ngoiq aham cư, ticuoi ngki át mui mít alứng cư, alứng cư át mui mít alứng án. ");
INSERT INTO pac_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A-ám ndon tumống níc-níc khoiq yua cư tớq. Cư tumống co nhơ A-ám tớq pilŏ́ng dyôn cư bôn tumống. Muchứng ngki tưi, ticuoi mmo cha cư, ticuoi ngki lư bôn tumống co nhơ cư. ");
INSERT INTO pac_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ndô la beng siar te pilŏ́ng. Beng ndô ndái te beng ndon siar te pilŏ́ng te inớh, ndon achúc achiac inha khoiq cha. Nha-án cha ma nha-án nnáng cuchet. Ma ticuoi mmo cha beng cư dyôn, ticuoi ngki bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Máh parnai ndô Yê-su cato tớq dúng rum ticuoi Isa-ra-el tớq vel Cabê-na-um. ");
INSERT INTO pac_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A-ưi náq te top veng tapun Yê-su cammáng Yê-su cato iki, alứng nha-án tông idô: “Callong án pasoi dieiq lư. Nnáu têq apúh máh parnai ngki?” ");
INSERT INTO pac_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yê-su chom nha-án nhannha-nhannhóm iki; dyơ án tông nha-án idô: “Callong ndô táq dyôn inha lớiq ính veng cư nnáng lớiq? ");
INSERT INTO pac_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Khán iki, imo inha parngíh, khán inha hôm Acái Yang Cơt Ticuoi sớr lieh nga ntúq án át te nsuoi? ");
INSERT INTO pac_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lư Arvai Yang Arbang-pilŏ́ng táp táq dyôn arvai ticuoi bôn tumống, ma sac sáiq ticuoi ớq tarnáp amớh. Máh parnai cư khoiq cato inha la táq-ntêr te arvai alứng callong tumống. ");
INSERT INTO pac_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma yôl bôn ticuoi te inha lớiq tin cư.” Yê-su tông iki, co án khoiq chom te nsuoi dyơ, bôn ticuoi lớiq ính tin án, alứng án chom dyơ bôn mui náq tớq top án táp ính culieu án. ");
INSERT INTO pac_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Alứng Yê-su tông loi idô: “Co iki cư tông inha te nsuoi, khán A-ám cư lớiq dyôn, lư lớiq bôn ngai tớq nga cư.” ");
INSERT INTO pac_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tư Yê-su tông máh parnai ngki, bôn a-ưi náq te top ndon veng tapun án píh chô lieh, lớiq ính veng nnáng. ");
INSERT INTO pac_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yê-su plốh top mui chít la bar náq idô: “Inha ính táh cư tưi lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Si-môn Phi-er ôi idô: “Ưlla ơi! Lớiq bôn nnáu nnáng he ính veng tapun. Nưm munáq Ưlla táp bôn parnai têq dyôn ticuoi bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","He tin alứng chom arlớih lư, Ưlla la munáq ndon Yang Arbang-pilŏ́ng rêh, alứng Ưlla la án ndon práh ŏ lư.” ");
INSERT INTO pac_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dyơ Yê-su ôi idô: “Cư khoiq rêh inha mui chít la bar náq. Ma bôn mui náq te top inha veng ngê yang saq.” ");
INSERT INTO pac_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yê-su tông iki la án tông te Yuda, acái conh Si-môn I-cari-ôt. Yuda la te top mui chít la bar náq, ma urớh Yuda ính culieu án. ");
INSERT INTO pac_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Vít ngki, Yê-su pôq chôp nhéq vúng Ca-lilê. Án lớiq ính mot tớq vúng Yudê, co ticuoi Isa-ra-el tớq vúng ngki ính cachet án. ");
INSERT INTO pac_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma tumán ính tớq ingái top Isa-ra-el cha bui ayư lieh Ingái Chóh Panu. ");
INSERT INTO pac_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mu a-em Yê-su tông án idô: “Ŏ lư mái ngốh te ntúq ndô, alứng pôq nga vúng Yudê, dyôn máh ticuoi ndon veng tapun mái bôn hôm máh arnáq sileh mái táq. ");
INSERT INTO pac_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Co lớiq bôn nnáu táq arnáq catốq khán án ính ticuoi cannŏ́h chom te arnáq án táq. Máh arnáq amớh mái táq, cóq mái táq apáh dyôn cứp náq hôm.” ");
INSERT INTO pac_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ma lư a-em Yê-su táp lớiq tin án. ");
INSERT INTO pac_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iki Yê-su ôi nha-án idô: “Iyốh tớq ngư cư apáh dyôn cứp náq ticuoi chom. Ma ngư inha pôq, ndóng mmo la têq. ");
INSERT INTO pac_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Máh ticuoi tớq pang ndô lớiq têq a-ính inha, ma nha-án a-ính cư, co cư tông te arnáq nha-án táq saq lư. ");
INSERT INTO pac_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Dyôn inha pôq cha bui ayư Ingái Chóh Panu. Cư iyốh ính pôq, co iyốh tớq ngư cư pôq.” ");
INSERT INTO pac_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cua Yê-su tông iki, án nnáng át tớq vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ma vít a-em conh Yê-su pôq, án pôq tưi, ma pôq carláiq carlieu. ");
INSERT INTO pac_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tớq ntúq ngai cha bui, ticuoi Isa-ra-el suo Yê-su alứng plốh idô: “Tumo án ngki?” ");
INSERT INTO pac_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Alứng bôn clứng ticuoi táq-ntêr te Yê-su. Bôn án ndon tông idô: “Yê-su la ticuoi ŏ.” Ma bôn án ndon tông: “Tới. Yê-su la ticuoi báq tarthu.” ");
INSERT INTO pac_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma lớiq bôn ngai dáh táq-ntêr dyôn ticuoi cannŏ́h sáng, co nha-án adáh ticuoi sút top Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ndóng tupul ingái nha-án cha bui ayư lieh Ingái Chóh Panu. Ma catám ingái puan, Yê-su pôq nga Dúng Sang Pưt, alứng án tabớq cato tớq ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ticuoi Isa-ra-el sáng dut lư, alứng nha-án plốh idô: “Án ndô lớiq nai rian, ma imo án chom a-ưi lư?” ");
INSERT INTO pac_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yê-su ôi nha-án idô: “Máh parnai cư tông inha hoi-ndô, tới tớq te cư bôm, ma tớq te án ndon yua cư tớq nga tudô. ");
INSERT INTO pac_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Khán ticuoi mmo ính veng cannính Yang Arbang-pilŏ́ng, ticuoi ngki cóq chom arlớih lư te parnai cư cato la tớq te Yang Arbang-pilŏ́ng, tới tớq te cư bôm. ");
INSERT INTO pac_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ticuoi mmo cato veng cannính án bôm, ticuoi ngki la ticuoi sisuo ính ngai ayô. Ma ticuoi mmo táq arnáq ính ngai ayô Yang Arbang-pilŏ́ng, án ndon yua ticuoi ngki tớq, ticuoi ngki táq crái lư alứng lớiq bôn mui callong amớh lớiq tinớng tupứng át tớq mít ticuoi ngki. ");
INSERT INTO pac_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Môi-se khoiq dyôn inha bôn phep rit Yang Arbang-pilŏ́ng. Ma lớiq bôn ngai te inha peh phep rit ngki. Co tian amớh inha ính cachet cư?” ");
INSERT INTO pac_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ticuoi clứng ôi Yê-su idô: “Thới bôn yang saq piyúh. Nnáu ính cachet thới?” ");
INSERT INTO pac_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yê-su ôi lieh nha-án idô: “Cư khoiq táq mui arnáq sileh tớq Ingái Angô nưm mbơiq mui chư sớng, ma inha sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Môi-se dyôn inha táq rit kít. Ma khán piaiq tớq Ingái Angô, inha lư táq tưi rit ngki. (Ma callong lư la rit ndô lớiq bôn tớq te Môi-se, ma tớq te achúc achiac inha.) ");
INSERT INTO pac_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Inha táq rit kít dyôn acái conh tớq Ingái Angô, la co inha lớiq ính táh rit Môi-se, ma co imo inha uan cư táq bánh ticuoi a-ái tớq Ingái Angô? ");
INSERT INTO pac_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Khán inha hôm ticuoi táq amớh, inha êq chái tíq án. Ma khán inha ính tíq, cóq inha tituaiq dyôn chom arlớih avai.” ");
INSERT INTO pac_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bôn ticuoi te vel Yaru-salem plốh idô: “Ticuoi ndô lớiq, ngai ính cachet án? ");
INSERT INTO pac_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hoi-ndô án chón cato, ma nha-án lớiq bôn táq-ntêr amớh. Ticuoi sút chom ma lớiq, án ndô la Crit? ");
INSERT INTO pac_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","He chom te mmo ticuoi ndô tớq, ma tư Crit tớq, lư lớiq bôn ngai chom te mmo án tớq.” ");
INSERT INTO pac_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ndóng Yê-su cato tớq Dúng Sang Pưt, án tông yứng lư idô: “Inha chom cư lớiq? Alứng inha chom te mmo cư tớq lớiq? Tới cư ính tớq bôm. Ma án ndon yua cư tớq, án ngki la Yang Arbang-pilŏ́ng ndon piaiq lư. Ma inha lớiq chom án. ");
INSERT INTO pac_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Cư chom án, co cư tớq te án, alứng án táp yua cư tớq.” ");
INSERT INTO pac_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Cua Yê-su tông iki, bôn ticuoi ính cŏp án, ma lớiq bôn ngai dáh angốh ati cŏp án, co iyốh tớq ngư án cóq cuchet. ");
INSERT INTO pac_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma te top ticuoi clứng ngki bôn a-ưi náq sŏ́ng tin Yê-su. Nha-án plốh idô: “Khán Crit tớq, án táq arnáq sileh a-ưi hơn te ticuoi ndô táq, lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Top Pha-rasi sáng ticuoi clứng táq-ntêr iki te Yê-su. Iki nha-án alứng máh ticuoi sút top teng rit sang yua ticuoi kiaq Dúng Sang Pưt pôq cŏp Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma Yê-su tông idô: “Yôl biq ingái sớng cư át alứng inha. Vít ngki cư chô lieh nga án ndon yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ingái ngki inha suo cư, ma inha lớiq tumúh cư. Alứng ntúq cư át, inha lớiq têq pôq nga ntúq ngki.” ");
INSERT INTO pac_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Iki ticuoi Isa-ra-el ngki munáq plốh munáq: “Ntúq mmo án ndô ính pôq, ma he suo án lớiq tumúh? Aláng án ính pôq tớq nga ticuoi Isa-ra-el ndon át cruong yông, dŏq cato ticuoi tới ticuoi Isa-ra-el tớq cruong ngki lớiq? ");
INSERT INTO pac_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Idứh án tông idô: ‘Inha suo cư, ma inha lớiq tumúh cư.’ Alứng án tông idô loi: ‘Ntúq cư át, inha lớiq têq pôq nga ntúq ngki.’ Amớh táp án chón tông te callong ngki?” ");
INSERT INTO pac_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ingái talloiq ngai cha bui Ingái Chóh Panu, la ingái ngki pưt clưi nhéq te ingái te nsuoi. Tớq ingái ngki, Yê-su yôr tayứng alứng tông yứng lư idô: “Khán ticuoi mmo sáng hál dơq, dyôn án tớq nga cư alứng ngoiq. ");
INSERT INTO pac_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Alứng ticuoi mmo tin cư, la arớq dơq ndon dyôn tumống hoi níc te mít cannính án. Callong ngki ngai khoiq taran dyơ tớq tám uráq Yang Arbang-pilŏ́ng te inớh.” ");
INSERT INTO pac_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yê-su tông iki, án cato te Arvai Yang Arbang-pilŏ́ng. Ticuoi mmo tin Yê-su, urớh ticuoi ngki lư bôn ráp Arvai Yang Arbang-pilŏ́ng. Ma ingái ngki Arvai Yang Arbang-pilŏ́ng iyốh tớq, co Yê-su iyốh cuchet alứng iyốh sớr lieh nga pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tư máh ticuoi sáng Yê-su tông iki, bôn ngai tông idô: “Ticuoi ndô la Ticuoi Tang Ngcang ndon Yang Arbang-pilŏ́ng khoiq rêh.” ");
INSERT INTO pac_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma ticuoi cannŏ́h tông idô: “Án ndô la lư Crit.” Ma bôn ticuoi cannŏ́h loi tông idô: “Crit lớiq bôn tớq te vúng Ca-lilê. ");
INSERT INTO pac_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Co tớq tám uráq Yang Arbang-pilŏ́ng te inớh tông Crit tớq te tŏ́ng toiq Davit. Alứng Crit cóq carnian tớq vel Bet-lahem, la vel Davit khoiq át.” ");
INSERT INTO pac_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iki ticuoi clứng ngki mui top tông idô, mui top tông iki, te Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tớq top ngki bôn ticuoi ính cŏp Yê-su, ma lớiq bôn ngai dáh angốh ati cŏp án. ");
INSERT INTO pac_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Vít ngki bôn máh ticuoi te top kiaq Dúng Sang Pưt chô lieh nga máh ticuoi sút top teng rit sang alứng nga top Pha-rasi, dyơ nha-án plốh máh ticuoi ngki idô: “Co imo inha lớiq cŏp án?” ");
INSERT INTO pac_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Máh ticuoi ngki ôi: “He lớiq nai sáng ticuoi mmo táq-ntêr arớq ticuoi ndô.” ");
INSERT INTO pac_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Top Pha-rasi plốh sa: “Inha náp máh parnai án pilốh ngki lớiq? ");
INSERT INTO pac_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bôn ticuoi mmo te ticuoi sút lớiq la ticuoi te top Pha-rasi, tin án lớiq? ");
INSERT INTO pac_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma ticuoi clứng ndô lớiq chom amớh te phep rit Môi-se. Co iki Yang Arbang-pilŏ́ng taroi ính táq nha-án.” ");
INSERT INTO pac_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Bôn munáq te top ticuoi sút, nốh Ni-cudem. Hoi nsuoi án khoiq tớq tumúh Yê-su. Án plốh ticuoi sút cannŏ́h idô: ");
INSERT INTO pac_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Khán veng phep rit he, têq lớiq he sưq ticuoi khán he iyốh tarsưq te arnáq án khoiq táq?” ");
INSERT INTO pac_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Máh ticuoi sút ngki ôi Ni-cudem idô: “Mái tớq te vúng Ca-lilê tưi lớiq? Khán mái suo tớq tám uráq Yang Arbang-pilŏ́ng, lư mái lớiq tumúh ntúq mmo tông te munáq ticuoi tang ngcang Yang Arbang-pilŏ́ng tớq te vúng Ca-lilê.” ");
INSERT INTO pac_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Cua ngki, top nha-án ngốh te Dúng Sang Pưt, alứng chô lieh nga dúng nha-án. ");
INSERT INTO pac_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma Yê-su sớr tớq king O-li-vê. ");
INSERT INTO pac_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tớq ang iláih, Yê-su pôq sa nga Dúng Sang Pưt. Át ntúq ngki bôn clứng ticuoi parchúng paniar án. Iki án ticu alứng cato nha-án. ");
INSERT INTO pac_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Top thới sái rit alứng top Pha-rasi dông asuoi munáq cán nga án. Cán ndô láh parlưi. Nha-án dyôn cán ndô tayứng tớq pandi nhéq máh ticuoi ndon át paniar Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Dyơ nha-án tông Yê-su idô: “Thới ơi! Bôn ticuoi tumúh cán ndô láh parlưi. ");
INSERT INTO pac_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tớq phep rit Môi-se khoiq tông he, khán ticuoi mmo táq lớiq ŏ arớq iki, cóq cachet án tíq na búl. Ma imo thới ính tông te arnáq ndô?” ");
INSERT INTO pac_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nha-án plốh iki co ính chim Yê-su. Nha-án suo ngê ính cauq án. Ma án tangngop taran tớq ndem ati án tớq cuteq. ");
INSERT INTO pac_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma nha-án ndon dông cán ngki plốh níc án, iki án yôr tayứng alứng tông idô: “Khán bôn munáq te inha lớiq nai táq luaih, dyôn án ngki ial búl tíq ada cán ndô nsuoi.” ");
INSERT INTO pac_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dyơ Yê-su tangngop taran tớq cuteq sa. ");
INSERT INTO pac_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tư nha-án sáng Yê-su tông iki, nha-án mmar ngốh te ntúq ngki, ticuoi ieuq ngốh nsuoi, tingôi yôl nưm Yê-su alứng cán ngki sớng át tớq ngki. ");
INSERT INTO pac_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yê-su yôr tayứng alứng plốh cán ngki idô: “Mun ơi! Tumo dyơ máh ticuoi ndon ính tíq mái? Nha-án nnáng ính táq tôt mái lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Cán ngki ôi: “Lớiq bôn nnáu nnáng, Ưlla ơi.” Yê-su tông án: “Iki cư lớiq táq tôt mái tưi. Mái têq pôq, ma êq táq nnáng luaih.” ");
INSERT INTO pac_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yê-su cato loi máh ticuoi Isa-ra-el idô: “Cư la callong ang dyôn nhéq tưh ticuoi. Ticuoi mmo veng tapun cư, án lớiq pôq nnáng tớq ntúq ngiau, ma án bôn callong ang. Ticuoi mmo bôn callong ang ndô, ticuoi ngki bôn díh callong tumống.” ");
INSERT INTO pac_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Top Pha-rasi tông idô: “Hoi-ndô thới cato te thới bôm. Iki he lớiq tin parnai thới.” ");
INSERT INTO pac_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yê-su ôi nha-án idô: “Tam cư cato te ngê cư bôm, ma máh parnai cư la crái lư, co cư chom te mmo cư tớq, alứng tumo cư ính pôq. Ma inha lớiq chom te mmo cư tớq, alứng tumo cư ính pôq. ");
INSERT INTO pac_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Inha sưq ticuoi veng ngê tớq pang ndô, ma cư iyốh nai sưq ticuoi mmo. ");
INSERT INTO pac_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma khán cư sưq, máh parnai cư tông la crái lư, co A-ám ndon yua cư tớq át alứng cư. Cư lớiq bôn át munáq sớng. ");
INSERT INTO pac_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tớq phep rit inha, ngai khoiq taran idô: ‘Khán bar náq tông muchứng, têq náp parnai ngki.’ ");
INSERT INTO pac_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Cư tông te cháq cư bôm, alứng A-ám ndon yua cư tớq, án khoiq tông tưi te cư.” ");
INSERT INTO pac_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dyơ top Pha-rasi plốh Yê-su idô: “Tumo A-ám thới át?” Yê-su ôi nha-án: “Inha lớiq chom cư, lớiq la A-ám cư. Khán inha chom cư, inha chom tưi A-ám cư.” ");
INSERT INTO pac_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yê-su cato máh parnai ndô tớq Dúng Sang Pưt tumán ntúq ngai cacháq práq sang. Ma ngai iyốh cŏp án, co iyốh tớq ngư án cóq cuchet. ");
INSERT INTO pac_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Cua ngki Yê-su tông sa nha-án idô: “Urớh cư pôq te inha, alứng inha suo cư, ma inha lư cuchet tớq callong luaih inha. Ntúq cư pôq, inha lớiq têq pôq.” ");
INSERT INTO pac_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dyơ ticuoi Isa-ra-el plốh idô: “Imo án tông he lớiq têq pôq nga ntúq án pôq? Dáh lơ án ính pôq dyáq?” ");
INSERT INTO pac_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma Yê-su tông loi idô: “Inha tớq te tadưp, ma cư ngki tớq te tanieng. Inha cơt te cuteq, ma cư lớiq bôn cơt te cuteq. ");
INSERT INTO pac_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cư khoiq tông inha dyơ, tớq inha cuchet, inha nnáng bôn luaih. Khán inha lớiq tin cư án ndon khoiq bôn dyơ, iki tớq inha cuchet, inha yôl bôn luaih.” ");
INSERT INTO pac_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nha-án plốh Yê-su: “Thới la nnáu?” Yê-su ôi nha-án: “Cư la án ndon cư khoiq tông inha te tôm lư. ");
INSERT INTO pac_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Cư yôl bôn a-ưi callong loi ính tíq inha. Ma án ndon yua cư tớq la tinớng lư. Cư tông dyôn nhéq tưh ticuoi chom te máh parnai cư khoiq sáng te án.” ");
INSERT INTO pac_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma nha-án lớiq apúh te parnai Yê-su tông te A-ám tớq pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iki Yê-su tông nha-án idô: “Tớq ingái inha téh Acái Yang Cơt Ticuoi tớq along calláng, ingái ngki inha chom arlớih lư cư la nnáu. Alứng ndóng ngki inha chom arlớih lư cư lớiq bôn táq veng chức cư bôm, ma máh parnai cư cato la tớq te A-ám cư; án khoiq tông a cư. ");
INSERT INTO pac_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Án ndon yua cư tớq, án át níc alứng cư. Án lớiq táh dyôn cư át munáq, co máh arnáq cư táq, cư táq ính án sáng bui cannính.” ");
INSERT INTO pac_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tư ngai sáng Yê-su tông iki, bôn a-ưi náq te nha-án tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yê-su cato ticuoi Isa-ra-el ndon khoiq tin án idô: “Khán inha cammáng parnai cư pasoi, inha lư cơt ticuoi veng tapun cư. ");
INSERT INTO pac_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dyơ inha bôn chom callong piaiq la amớh; lư callong piaiq ndô taláh inha te cơt sol.” ");
INSERT INTO pac_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma máh ticuoi ngki ôi Yê-su idô: “He la te tŏ́ng toiq A-praham. He lớiq nai cơt sol ngai. Imo thới tông taláh he te cơt sol?” ");
INSERT INTO pac_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yê-su tông nha-án idô: “Cư tông inha arlớih lư, ticuoi mmo táq luaih, ticuoi ngki cơt sol dyôn callong luaih. ");
INSERT INTO pac_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Khán ticuoi mmo ính táh ticuoi sol, án têq táh, ma án lớiq têq táh acái conh án bôm. Co acái ngki át níc tớq dúng án. ");
INSERT INTO pac_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Iki, khán Acái Yang Arbang-pilŏ́ng taláh inha, lư inha lớiq bôn cơt nnáng sol. ");
INSERT INTO pac_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Cư chom inha te tŏ́ng toiq A-praham. Ma inha nnáng ính cachet cư, co inha lớiq ính cammáng parnai cư. ");
INSERT INTO pac_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Cư tông máh parnai ndon cư khoiq sáng te A-ám cư, ma inha veng máh parnai inha khoiq sáng te a-ám inha.” ");
INSERT INTO pac_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Máh ticuoi ngki ôi idô: “A-praham la a-ám he.” Ma Yê-su tông lieh idô: “Khán inha lư te tŏ́ng toiq A-praham, cóq inha táq arnáq muchứng A-praham tưi. ");
INSERT INTO pac_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Cư cato inha la callong piaiq ndon cư khoiq bôn te Yang Arbang-pilŏ́ng, ma inha parngíh ính cachet cư. A-praham lớiq bôn táq iki. ");
INSERT INTO pac_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inha táq veng arnáq a-ám inha, ma a-ám inha tới A-praham.” Nha-án ôi Yê-su idô: “He tới acái tarríh. He bôn nưm mui sớng a-ám. Yang Arbang-pilŏ́ng la lư A-ám he.” ");
INSERT INTO pac_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yê-su tông ada nha-án idô: “Khán Yang Arbang-pilŏ́ng lư A-ám inha, iki inha amoih cư, co cư tớq te Yang Arbang-pilŏ́ng. Hoi-ngki cư át ndô, cư lớiq tớq veng ngê cư bôm, ma Yang Arbang-pilŏ́ng yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Imo inha lớiq apúh sa te parnai cư tông? Inha lớiq apúh, co inha lớiq ính cammáng parnai cư. ");
INSERT INTO pac_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Inha la acái conh yang Satán. Án la a-ám inha. Alứng inha ính lư veng ngê a-ám inha. Te tôm lư, yang Satán ính lư cachet ticuoi. Án lớiq cadyiq callong piaiq, co án lớiq bôn mui callong piaiq amớh át tớq mít án. Án tông níc parnai a-uai, án táq veng ngê án bôm, co án ính lư callong a-uai, alứng án la a-ám callong a-uai. ");
INSERT INTO pac_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Cư tông inha callong piaiq, ma inha lớiq tin cư. ");
INSERT INTO pac_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Bôn nnáu te inha bôn tíc têq cauq cư táq luaih? Khán cư tông parnai piaiq, ngki imo inha lớiq tin cư? ");
INSERT INTO pac_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ticuoi mmo lư acái Yang Arbang-pilŏ́ng, ticuoi ngki cammáng parnai Yang Arbang-pilŏ́ng. Ma inha lớiq ính cammáng parnai Yang Arbang-pilŏ́ng, co inha tới acái án.” ");
INSERT INTO pac_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Máh ticuoi Isa-ra-el acraiq Yê-su idô: “Piaiq lớiq, mái la ticuoi Sa-mari alứng bôn yang saq piyúh?” ");
INSERT INTO pac_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yê-su ôi nha-án idô: “Cư lớiq bôn yang saq piyúh. Cư dyám náp nưm A-ám cư sớng, ma inha lớiq dyám náp cư. ");
INSERT INTO pac_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Cư lớiq bôn suo ính ngai ayô cư. Ma bôn munáq suo callong ngki dyôn cư. Án ính sưq inha alứng cư. ");
INSERT INTO pac_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cư tông inha arlớih lư, khán bôn ticuoi peh parnai cư, án lư lớiq nai cuchet.” ");
INSERT INTO pac_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tư Yê-su tông iki, ticuoi Isa-ra-el tông idô: “Hoi-ndô he chom arlớih lư mái bôn yang saq. A-praham khoiq cuchet dyơ. Alứng máh ticuoi tang ngcang Yang Arbang-pilŏ́ng la khoiq cuchet tưi. Ma hoi-ndô mái tông, khán ticuoi peh parnai mái, ticuoi ngki lư lớiq nai cuchet. ");
INSERT INTO pac_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mái pưt hơn te achúc achiac he A-praham lớiq? Ma A-praham khoiq cuchet dyơ, alứng máh ticuoi tang ngcang la khoiq cuchet tưi. Mái parngíh mái la nnáu?” ");
INSERT INTO pac_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yê-su ôi nha-án idô: “Khán cư ayô cháq cư bôm, lư lớiq bôn tưr amớh. Án ndon ayô cư la A-ám cư, la án ndon inha ngin Yang Arbang-pilŏ́ng inha. ");
INSERT INTO pac_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Inha lớiq chom án, ma cư chom án. Khán cư tông cư lớiq chom án, ngki cư tông a-uai muchứng inha tưi. Ma lư cư chom án, alứng cư peh parnai án. ");
INSERT INTO pac_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Achúc achiac inha A-praham tél-sél lư ính hôm cư tớq nga cúc cuteq ndô. Án khoiq hôm dyơ callong ndô, iki án bui ơn lư.” ");
INSERT INTO pac_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Máh ticuoi Isa-ra-el ngki tông idô: “Pang mái iyốh tớq sông chít cumo. Ma imo mái tông mái khoiq hôm A-praham?” ");
INSERT INTO pac_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yê-su ôi lieh nha-án idô: “Cư tông inha arlớih lư, te iyốh carnian A-praham, cư khoiq bôn dyơ.” ");
INSERT INTO pac_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Cua Yê-su tông iki, ticuoi Isa-ra-el peh búl ính tíq án. Ma án plian tớq ticuoi clứng; dyơ án ngốh te Dúng Sang Pưt. ");
INSERT INTO pac_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ndóng Yê-su pôq, án hôm munáq ticuoi sot mát te a-i carnian. ");
INSERT INTO pac_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Top rian te Yê-su plốh Yê-su idô: “Thới ơi! Mát ticuoi ndô cơt sot te ingái a-i án carnian án, co nnáu táq luaih, án lớiq la a-i a-ám án?” ");
INSERT INTO pac_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yê-su ôi nha-án idô: “Tới co án lớiq la a-i a-ám án táq luaih. Ma Yang Arbang-pilŏ́ng ính apáh arnáq pưt lư na ticuoi sot ndô. ");
INSERT INTO pac_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ndóng yôl ingái, he cóq táq cứp arnáq án ndon yua cư tớq. Tư idáu dyơ, lớiq bôn ngai têq táq nnáng arnáq. ");
INSERT INTO pac_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ndóng cư át tớq cúc cuteq ndô, cư la callong ang dyôn nhéq tưh ticuoi.” ");
INSERT INTO pac_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cua Yê-su tông iki, án cuchóh tớq cuteq. Án carchúc dơq avie alứng cuteq mbúi dyôn cơt apúc. Dyơ án tir apúc ngki tớq mát ticuoi sot. ");
INSERT INTO pac_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dyơ án yua ticuoi sot idô: “Pôq! Mái pôq buaiq mang tớq dơq alúq Saluam.” (Parnai Saluam titoiq lieh la ‘Ngai yua’.) Iki ticuoi sot pôq buaiq mang, dyơ mát án cơt plang. Dyơ ngki án píh chô nga dúng. ");
INSERT INTO pac_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ticuoi ndon át mui vel alứng án, alứng máh ticuoi ndon khoiq hôm án át suseq te hoi-nsuoi, nha-án plốh idô: “Án ndô la ticuoi sot mát báq ticu suseq, piaiq lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bôn ticuoi ôi: “Piaiq, lư án.” Ma ticuoi cannŏ́h tông: “Tới án. Armaiq ticuoi ndô in ticuoi sot ngki tưi.” Ma ticuoi sot tông idô: “Cư táp la ticuoi sot ngki.” ");
INSERT INTO pac_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Iki nha-án plốh án: “Khán mái lư ticuoi sot ngki, co imo mát mái cơt plang?” ");
INSERT INTO pac_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Án ôi nha-án idô: “Bôn munáq conh, nốh Yê-su, án talóc apúc, dyơ tir tớq mát cư, alứng án yua cư pôq buaiq mang tớq dơq alúq Saluam. Iki cư pôq buaiq mang. Dyơ mát cư cơt plang.” ");
INSERT INTO pac_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nha-án plốh lieh án idô: “Tumo ticuoi ngki hoi-ndô?” Án ôi: “Cư lớiq chom tumo án.” ");
INSERT INTO pac_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Cua ngki ngai dông ticuoi sot ndon khoiq cơt plang nga top Pha-rasi. ");
INSERT INTO pac_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ingái Yê-su talóc apúc alứng táq dyôn mát ticuoi sot cơt plang la Ingái Angô. ");
INSERT INTO pac_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iki top Pha-rasi plốh ticuoi sot ngki idô: “Amớh táp mái táq dyôn mát mái cơt plang?” Ticuoi sot ôi nha-án idô: “Bôn ticuoi tir apúc tớq mát cư, dyơ cư pôq buaiq mang; iki cư bôn hôm arlớih lư.” ");
INSERT INTO pac_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bôn ticuoi te top Pha-rasi tông idô: “Ticuoi ndô lớiq bôn tớq te Yang Arbang-pilŏ́ng, co án táh phep rit Ingái Angô.” Ma bôn ticuoi cannŏ́h tông idô: “Imo têq ticuoi luaih táq arnáq sileh ndô?” Dyơ top Pha-rasi paryáh cơt bar top, mui top tông idô, mui top tông iki. ");
INSERT INTO pac_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iki top Pha-rasi plốh sa ticuoi sot idô: “Amớh mái tông te ticuoi ndon táq dyôn mát mái cơt plang?” Ticuoi sot ôi: “Án la ticuoi tang ngcang Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma máh ticuoi Isa-ra-el lớiq tin ticuoi ngki lư sot te nsuoi, dyơ cơt plang. Iki nha-án pôq cớiq a-i a-ám án. ");
INSERT INTO pac_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Dyơ nha-án plốh a-i a-ám án idô: “Án ndô lư acái conh inha lớiq? Án lư sot te ingái inha carnian án lớiq? Co imo hoi-ndô mát án cơt plang?” ");
INSERT INTO pac_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A-i a-ám án ôi idô: “He tông arlớih lư, án lư acái conh he. Alứng he hôm mát án sot te ingái he carnian án. ");
INSERT INTO pac_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma imo mát án cơt plang hoi-ndô la he lớiq chom tưi. Alứng he lớiq chom nnáu táq dyôn mát án cơt plang. Inha plốh án. Án khoiq sasai dyơ. Án têq ôi inha.” ");
INSERT INTO pac_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A-i a-ám án tông iki, co nha-án adáh top Isa-ra-el. Co top Isa-ra-el khoiq patáp dyơ, khán ticuoi mmo tông Yê-su la Crit ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi, ticuoi ngki lớiq têq mot rum nnáng tớq dúng rum nha-án. ");
INSERT INTO pac_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Co te callong ngki, a-i a-ám ticuoi sot ma tông idô: “Án khoiq sasai dyơ. Inha plốh án.” ");
INSERT INTO pac_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mui chư loi, top Pha-rasi arô ticuoi sot alứng tông án idô: “Cóq mái ayô nưm Yang Arbang-pilŏ́ng sớng. He khoiq chom dyơ ticuoi ngki la ticuoi luaih.” ");
INSERT INTO pac_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma ticuoi sot ôi nha-án idô: “Cư lớiq chom án la ticuoi luaih ma lớiq. Ma cư chom nưm mui nốh sớng. Hoi nsuoi mát cư sot, ma hoi-ndô mát cư khoiq cơt plang!” ");
INSERT INTO pac_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dyơ top Pha-rasi plốh án sa: “Ticuoi ngki táq amớh dyôn mái? Imo táp án táq dyôn mát mái cơt plang?” ");
INSERT INTO pac_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ticuoi sot ôi: “Cư khoiq tông inha dyơ, ma inha lớiq náp. Co imo inha ính cư táq-ntêr sa? Inha ính veng tapun án tưi lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Top Pha-rasi sáng nháih lư tớq mít; dyơ nha-án tông idô: “Mái veng ngê ticuoi ngki! Ma he veng ngê Môi-se! ");
INSERT INTO pac_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","He chom Yang Arbang-pilŏ́ng khoiq tông na Môi-se. Ma ticuoi ngki he lớiq chom te mmo án tớq.” ");
INSERT INTO pac_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ticuoi sot ôi idô: “Cư dut lư! Inha lớiq chom te mmo án tớq, ma án khoiq táq dyôn mát cư cơt plang! ");
INSERT INTO pac_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","He chom Yang Arbang-pilŏ́ng lớiq cammáng ticuoi luaih, ma án cammáng nưm ticuoi dyám náp án, alứng veng ngê án. ");
INSERT INTO pac_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Te tôm Yang Arbang-pilŏ́ng teng cúc cuteq ndô, lớiq nai sáng bôn ticuoi têq táq dyôn ticuoi sot te ingái a-i án carnian ma cơt plang. ");
INSERT INTO pac_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Khán ticuoi ngki lớiq tớq te Yang Arbang-pilŏ́ng, ngki án lớiq têq táq mui arnáq sileh amớh.” ");
INSERT INTO pac_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ma top Pha-rasi tông loi idô: “Mái la ticuoi luaih te ingái a-i mái carnian mái! Imo mái ính cato he?” Vít ngki nha-án chuih angốh án. ");
INSERT INTO pac_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yê-su sáng nha-án chuih ticuoi sot. Dyơ án tớq tumúh ticuoi sot, alứng án plốh idô: “Mái tin Acái Yang Cơt Ticuoi lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ticuoi sot ôi: “Thới ơi, án ngki la nnáu? Seq thới tông dyôn cư chom. Cư ính tin án tưi.” ");
INSERT INTO pac_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yê-su tông lieh: “Mái khoiq hôm dyơ án; án ndon táq-ntêr alứng mái hoi-ndô la án táp.” ");
INSERT INTO pac_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Iki ticuoi sot ôi: “Ưlla ơi! Lư cư tin!” Dyơ án cucúh sang Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yê-su tông loi: “Cư tớq nga cúc cuteq ndô dŏq amar ticuoi. Cư táq dyôn ticuoi sot cơt plang, alứng táq dyôn ticuoi plang ŏ cơt sot.” ");
INSERT INTO pac_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bôn ticuoi te top Pha-rasi sáng Yê-su tông iki. Dyơ nha-án plốh Yê-su idô: “Thới tông he la ticuoi sot tưi lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yê-su ôi nha-án idô: “Khán inha ngin inha la ticuoi sot, inha lớiq bôn luaih amớh. Ma hoi-ndô, inha ngin mát inha plang ŏ, iki luaih inha yôl át níc.” ");
INSERT INTO pac_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yê-su tông loi idô: “Cư tông inha arlớih lư, ticuoi mmo lớiq mot tớq coq pannán cưu na ngáh, ma án mot na cannŏ́h, án la ticuoi siveng, alứng mot ính titôiq. ");
INSERT INTO pac_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Án ndon mot na ngáh la lư ticuoi kiaq bán cưu. ");
INSERT INTO pac_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ticuoi kiaq ngáh coq pốh callống dyôn ticuoi kiaq bán cưu mot, alứng máh cưu cammáng sieng án arô. Án bôiq nốh cưu, alứng án dông angốh máh cưu te coq. ");
INSERT INTO pac_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tớq án ayông cưu, án pôq nsuoi, alứng máh cưu veng án, co cưu acớl tammieng án. ");
INSERT INTO pac_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma cưu lớiq veng ticuoi laq. Lư án lúh te ticuoi laq, co án lớiq acớl tammieng ticuoi ngki.” ");
INSERT INTO pac_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yê-su cato parnai acám ndô, ma ticuoi ngki lớiq apúh te callong án cato. ");
INSERT INTO pac_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iki Yê-su tông lieh nha-án idô: “Cư tông inha arlớih lư, cư la ngáh coq pannán cưu. ");
INSERT INTO pac_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Máh ticuoi ndon tớq nsuoi cư, la ticuoi siveng alứng ticuoi titôiq. Alứng top cưu lớiq cammáng nha-án. ");
INSERT INTO pac_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Cư la ngáh coq. Ticuoi mmo mot na ngáh, ticuoi ngki bôn tumống. Án têq mot alứng ngốh suo cha, alứng án bôn tumúh níc crơng tanna. ");
INSERT INTO pac_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ticuoi siveng mot co ính titôiq, ính cachet, alứng ính talóh pupít. Ma cư tớq ính dyôn máh cưu bôn tumống, alứng lớiq ớq mui nốh amớh. ");
INSERT INTO pac_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Cư la ticuoi kiaq me ŏ. Ticuoi kiaq me ŏ mŏp tarngứh án tang dyôn cưu têq tumống. ");
INSERT INTO pac_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ticuoi thuthe bán cưu, án lớiq cơt ưlla cưu. Khán án hôm acho cruong tớq, án lúh táh nhéq máh cưu. Iki acho cruong palŏ́ng cáp cưu; dyơ máh cưu lúh pláh chap nhéq. ");
INSERT INTO pac_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ticuoi thuthe lúh co án la ticuoi thuthe bán sớng. Án lớiq ayáu cưu. ");
INSERT INTO pac_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Cư la ticuoi kiaq me ŏ. A-ám tớq pilŏ́ng chom cư, alứng cư chom A-ám; muchứng ngki tưi cư chom cưu cư, alứng cưu cư chom cư. Cư bui mŏp tarngứh cư dyôn máh cưu cư têq bôn tumống. ");
INSERT INTO pac_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bôn cưu cannŏ́h la na cư tưi, ma cưu ngki lớiq át tớq coq ndô. Cư cóq pôq pong achô máh cưu ngki. Urớh cưu ngki cammáng sieng cư. Dyơ máh cưu parchúng cơt mui top sớng, alứng bôn munáq sớng kiaq me. ");
INSERT INTO pac_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“A-ám tớq pilŏ́ng amoih lư cư, co cư bui cannính chiuq cuchet. Cư mŏp tarngứh cư, dŏq cư têq ial lieh tarngứh ngki. ");
INSERT INTO pac_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lớiq bôn ngai têq ial tarngứh cư, ma cư chóng bui mŏp tarngứh cư. Cư bôn chức mŏp iki. Alứng cư bôn chức têq ial lieh tarngứh cư. Chức ndô, A-ám cư táp dyôn cư bôn.” ");
INSERT INTO pac_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cua Yê-su tông iki, top Isa-ra-el paryáh cơt bar top. ");
INSERT INTO pac_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mui top tông idô: “Ticuoi ndô bôn yang saq piyúh. Án la ticuoi yúh. Imo inha cammáng parnai án?” ");
INSERT INTO pac_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma top cannŏ́h tông idô: “Khán yang saq lư piyúh án, imo têq án tông máh parnai ngki. Imo ticuoi bôn yang saq têq táq dyôn ticuoi sot mát cơt plang?” ");
INSERT INTO pac_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tư kisái ngngiat tớq vel pưt Yaru-salem, top Isa-ra-el cha bui ayư ingái nha-án bôn lieh dúng sang te inớh. ");
INSERT INTO pac_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yê-su mot tớq Dúng Sang Pưt, alứng án lulieh pôq chô tớq Ntrôn Sa-lamôn. ");
INSERT INTO pac_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Top Isa-ra-el rum paniar Yê-su alứng plốh án idô: “Nnáng dưnh máh-mmo thới ính he ngcong ngóh-arngóh? Khán thới la Crit, seq thới tông dyôn he chom arlớih.” ");
INSERT INTO pac_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yê-su ôi nha-án idô: “Cư khoiq tông inha dyơ, ma inha lớiq tin. Cư têq táq arnáq ndô la co nhơ A-ám cư dyôn cư bôn chức; arnáq ndô apáh cư tớq te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma inha lớiq tin cư, co inha tới top pannán cưu cư. ");
INSERT INTO pac_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Cưu cư cammáng sieng cư. Cư chom án, alứng án veng tapun cư. ");
INSERT INTO pac_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Cư dyôn án bôn tumống níc-níc; iki án lớiq nai cuchet. Ticuoi mmo la lớiq têq ndŏ́h án te ati cư. ");
INSERT INTO pac_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","A-ám cư pưt clưi nhéq te cannŏ́h. Án dyôn cư bôn cưu ngki. Ticuoi mmo la lớiq têq ndŏ́h cưu ngki te ati A-ám cư. ");
INSERT INTO pac_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Cư alứng A-ám cư la mui.” ");
INSERT INTO pac_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tư Yê-su tông iki, top Isa-ra-el ial búl ính tíq ada án. ");
INSERT INTO pac_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Yê-su tông nha-án idô: “Cư khoiq táq a-ưi arnáq ŏ arớq A-ám cư khoiq yua cư táq. Co tian amớh inha ính tíq búl ada cư?” ");
INSERT INTO pac_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Top Isa-ra-el ôi án idô: “He lớiq ính tíq búl ada mái co mái táq arnáq ŏ. Ma he ính tíq búl ada mái co mái acraiq Yang Arbang-pilŏ́ng. Mái la ticuoi ngáq sớng, ma imo mái ngin mái la Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yê-su tông lieh nha-án idô: “Tớq phep rit inha, bôn ticuoi khoiq taran te Yang Arbang-pilŏ́ng idô: ‘Inha cơt arớq yang tưi.’ ");
INSERT INTO pac_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","He chom dyơ parnai Yang Arbang-pilŏ́ng la piaiq níc; alứng Yang Arbang-pilŏ́ng arô ticuoi ndon ráp parnai án la ‘yang’ tưi. ");
INSERT INTO pac_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma cư, ngki A-ám cư khoiq rêh cư, alứng án yua cư tớq nga cúc cuteq ndô. Iki, imo inha tông cư acraiq Yang Arbang-pilŏ́ng tớq cư tông cư la Acái Yang Arbang-pilŏ́ng? ");
INSERT INTO pac_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Khán cư lớiq táq arnáq A-ám cư, inha êq tin cư. ");
INSERT INTO pac_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma khán cư táq arnáq án, tam inha lớiq ính tin cư, ma cóq inha tin te máh arnáq cư khoiq táq. Iki inha têq chom arlớih, A-ám cư át mui mít alứng cư, alứng cư át mui mít alứng A-ám cư.” ");
INSERT INTO pac_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Cua Yê-su tông iki, top Isa-ra-el sisuo sa ngê ính cŏp án. Ma án pôq viang te nha-án; dyơ nha-án lớiq têq bôn cŏp án. ");
INSERT INTO pac_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yê-su dyang lieh dơq crong Yôr-dan, alứng pôq nga ntúq Yon báq táq tíc na dơq hoi-nsuoi. Yê-su át ntúq ngki; ");
INSERT INTO pac_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ma bôn clứng ticuoi tớq nga án. Nha-án tông idô: “Yon lớiq bôn táq mui arnáq sileh amớh, ma máh parnai Yon tông te ticuoi ndô la piaiq nhéq.” ");
INSERT INTO pac_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iki bôn a-ưi ticuoi tớq ntúq ngki tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bôn munáq conh a-ái, nốh La-sarơ. Án át tớq vel Bê-thani. Án át munơi alứng em ơi án la Mari alứng Mathê. ");
INSERT INTO pac_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari la cán ndon tốq dơq thum tớq cháq Yê-su, alứng chut dyưng Yê-su tớq sóc án bôm. La-sarơ ndon a-ái la amieng án. ");
INSERT INTO pac_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bar náq em ơi yua ticuoi pôq tông Yê-su idô: “Ưlla ơi! Án ndon Ưlla amoih lư, hoi-ndô án a-ái.” ");
INSERT INTO pac_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tư Yê-su sáng iki, án tông idô: “La-sarơ lư a-ái, ma án lớiq cuchet mmớh. Co nhơ te án a-ái, ticuoi bôn ayô Yang Arbang-pilŏ́ng alứng Acái Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yê-su amoih Mathê, Mari, alứng La-sarơ. ");
INSERT INTO pac_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tư Yê-su sáng hanh La-sarơ a-ái, án át lieh tớq ntúq ngki bar ingái loi. ");
INSERT INTO pac_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Vít bar ingái, án tông top rian te án idô: “He píh chô lieh nga vúng Yudê.” ");
INSERT INTO pac_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma top rian te án tông án idô: “Thới ơi! Iyốh dưnh te top Isa-ra-el ính tíq búl ada thới. Ma imo hoi-ndô thới ính pôq lieh nga tuki?” ");
INSERT INTO pac_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yê-su ôi nha-án idô: “Pên ingái tớq cúc cuteq ndô bôn ang, ma lớiq? Khán ticuoi pôq tớq ingái, án lớiq dứm; án têq hôm, co ang. ");
INSERT INTO pac_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma khán án pôq tớq idáu, lư án dứm, co ngiau.” ");
INSERT INTO pac_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cua Yê-su tông iki, án tông loi idô: “Yớu he La-sarơ bíq ngiar, ma hoi-ndô cư ính pôq pasớt án.” ");
INSERT INTO pac_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Top rian te Yê-su ôi idô: “Ưlla ơi! Khán án bíq, ngki ŏ.” ");
INSERT INTO pac_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Callong lư la Yê-su tông La-sarơ khoiq cuchet dyơ, ma top rian te án parngíh án tông La-sarơ bíq sớng. ");
INSERT INTO pac_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iki án tông nha-án arlớih lư idô: “La-sarơ khoiq cuchet dyơ. ");
INSERT INTO pac_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Cư ơn tưi cư lớiq bôn tớq ndóng án a-ái. Ma hoi-ndô cư ính pôq táq dyôn inha têq tin khớm lư. He! He pôq me án!” ");
INSERT INTO pac_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Cua ngki, Thô-mat ndon ngai dŏq nốh Di-dim hơ, án tông ada yớu cannŏ́h ndon rian te Yê-su idô: “He pôq tưi, dŏq he sŏ́ng cuchet munơi alứng thới.” ");
INSERT INTO pac_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tư Yê-su pôq nga ntúq ngki, án sáng ngai táq-ntêr ngai tứp La-sarơ khoiq puan ingái dyơ. ");
INSERT INTO pac_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Vel Bê-thani yông te vel pưt Yaru-salem tumán pe ki-lô-met, ");
INSERT INTO pac_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","alứng a-ưi náq te top Isa-ra-el pôq bíq alang Mathê nha Mari, co amieng nha-án khoiq cuchet. ");
INSERT INTO pac_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tư Mathê sáng ngai táq-ntêr Yê-su mbơiq tớq parngốh vel, iki án pôq côn Yê-su. Ma Mari yôl át tớq dúng. ");
INSERT INTO pac_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mathê tông Yê-su idô: “Ưlla ơi! Khán Ưlla át tudô ndóng ngki, amieng cư lớiq cuchet mmớh. ");
INSERT INTO pac_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma cư chom díh hoi-ndô, nốh amớh Ưlla seq te Yang Arbang-pilŏ́ng, lư án dyôn.” ");
INSERT INTO pac_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yê-su tông Mathê idô: “Amieng mái lư tumống lieh.” ");
INSERT INTO pac_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mathê ôi idô: “Cư chom amieng cư lư tumống lieh tớq ingái talloiq. Ingái ngki nhéq tưh ticuoi khoiq cuchet bôn tumống lieh nhéq.” ");
INSERT INTO pac_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yê-su tông lieh Mathê idô: “To cư táp têq dyôn ticuoi cuchet bôn tumống lieh, alứng cư têq dyôn nha-án bôn tumống. Ticuoi mmo tin cư, tam án khoiq cuchet ma án yôl tumống. ");
INSERT INTO pac_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Alứng ticuoi mmo nnáng tumống alứng tin cư, án lớiq nai cuchet. Mái tin callong ndô lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mathê ôi idô: “Lư cư tin, Ưlla ơi! Cư tin Ưlla la Crit, Acái Yang Arbang-pilŏ́ng, án ndon Yang Arbang-pilŏ́ng yua dyôn tớq nga cúc cuteq ndô.” ");
INSERT INTO pac_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cua Mathê tông iki, án chô nga dúng, alứng án carhaiq Mari a-em án idô: “Thới tớq dyơ. Án ính tumúh mái.” ");
INSERT INTO pac_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tư Mari sáng iki, yóiq táp án yôr, alứng án pôq nga Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yê-su iyốh mot tớq vel. Án yôl át tớq ntúq Mathê tumúh án. ");
INSERT INTO pac_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ticuoi Isa-ra-el ndon bíq alang Mari, hôm Mari yôr chái lư alứng ngốh te dúng; iki nha-án veng lamloi án. Nha-án parngíh án pôq nhiem nga ping amieng án. ");
INSERT INTO pac_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tư Mari tớq nga ntúq Yê-su át, alứng án hôm Yê-su, iki án mpop tumán dyưng Yê-su alứng tông idô: “Ưlla ơi! Khán Ưlla át tudô ndóng ngki, amieng cư lớiq bôn cuchet mmớh.” ");
INSERT INTO pac_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tư Yê-su hôm Mari alứng máh ticuoi Isa-ra-el ndon veng Mari nhiem, iki Yê-su sáng sruiq táq, alứng sáng anguaq lư. ");
INSERT INTO pac_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dyơ án plốh idô: “Ntúq mmo inha tứp án?” Nha-án ôi: “Ưlla ơi! He pôq me!” ");
INSERT INTO pac_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yê-su nhiem. ");
INSERT INTO pac_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iki ticuoi Isa-ra-el tông idô: “Áu! Me! Án amoih lư La-sarơ!” ");
INSERT INTO pac_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma bôn ticuoi cannŏ́h tông idô: “Ticuoi ndô khoiq táq dyôn mát ticuoi sot cơt plang. Khán án át tớq ntúq ndô ndóng La-sarơ iyốh cuchet, têq láng lớiq án táq dyôn La-sarơ lớiq cuchet?” ");
INSERT INTO pac_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yê-su tớq nga ping. Mít án sáng anguaq lư sa. Ping ndô tớq cưp, alứng bôn búl pưt catáng ngáh cưp. ");
INSERT INTO pac_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yê-su yua idô: “Cóq inha vih angốh búl te ngáh cưp.” Ma Mathê amoq ticuoi cuchet ngki tông idô: “Ưlla ơi! Hoi-ndô sac án khoiq nsốq dyơ, co án át ngki khoiq puan ingái.” ");
INSERT INTO pac_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yê-su plốh loi idô: “Cư khoiq tông inha lớiq, khán inha tin, inha lư bôn hôm chức ang-ưr te Yang Arbang-pilŏ́ng?” ");
INSERT INTO pac_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iki nha-án vih búl. Dyơ Yê-su tingưi nga pilŏ́ng alứng tông idô: “A-ám cư ơi! Cư si-ơn mái khoiq cammáng cư. ");
INSERT INTO pac_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Cư chom mái cammáng níc cư, ma cư tông iki co ính máh ticuoi át tumán cư hoi-ndô chom arlớih, mái yua cư tớq nga tudô.” ");
INSERT INTO pac_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cua Yê-su tông iki, án arô yứng lư idô: “La-sarơ ơi! Mái ngốh te ntúq ngki!” ");
INSERT INTO pac_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","La-sarơ ngốh te ping. Ma dyưng ati án nhéq ngai sŏm tớq prới. Alứng bôn prới cannŏ́h pul mang alứng plô án. Dyơ Yê-su yua nha-án idô: “Inha lếh máh prới ngai sŏm alứng dyôn án pôq.” ");
INSERT INTO pac_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iki a-ưi ticuoi Isa-ra-el ndon bíq alang Mari hôm arnáq Yê-su táq. Iki nha-án tin án tưi. ");
INSERT INTO pac_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma bôn ticuoi te top nha-án pôq nga top Pha-rasi alứng tông te máh arnáq Yê-su khoiq táq. ");
INSERT INTO pac_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Iki top Pha-rasi alứng máh ticuoi sút top teng rit sang arô nhéq máh ticuoi sút top Isa-ra-el dyôn tớq; dyơ nha-án tanghúng idô: “Imo he ính táq hoi-ndô? Me nga ticuoi ndô; án khoiq táq a-ưi arnáq sileh dyơ. ");
INSERT INTO pac_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Khán he dyôn án táq níc arớq iki, nhéq máh ticuoi lư tin án. Dyơ ticuoi Rô-ma tớq talóh Dúng Sang Pưt alứng cruong he.” ");
INSERT INTO pac_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bôn munáq ticuoi te top ngki, nốh Cai-pha. Cumo ngki án cơt ariaih top teng rit sang Yang Arbang-pilŏ́ng. Án tông idô: “Inha lớiq chom amớh tháng. ");
INSERT INTO pac_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Inha lớiq bôn tituaiq. Khán dŏq ticuoi ndô, prái he lư cuchet nhéq, alứng cruong he la arlóh nhéq tưi. The he dyôn munáq án sớng cuchet, aláng nhéq máh ticuoi he cuchet.” ");
INSERT INTO pac_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ma máh parnai Cai-pha tông, tới chóng ngốh te mít án bôm. Máh parnai án tông te Yê-su chiuq cuchet tang máh ticuoi Isa-ra-el, lư Yang Arbang-pilŏ́ng táp dyôn án tông acớiq, co tớq cumo ngki án cơt ariaih top teng rit sang. ");
INSERT INTO pac_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Alứng Yê-su lớiq bôn cuchet tang dyôn nưm ticuoi Isa-ra-el sớng, ma án cuchet tang dyôn cứp náq ticuoi ndon cơt acái acon Yang Arbang-pilŏ́ng. Hoi-ndô máh ticuoi ndô át parsáng parsaiq tớq a-ưi ntúq; ma urớh nha-án parchúng cơt mui top sớng. ");
INSERT INTO pac_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Náp te ingái ngki, top Isa-ra-el sisuo ngê ính cachet Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iki Yê-su lớiq pôq nnáng munơi alứng ticuoi clứng te top Isa-ra-el. Ma án pôq nga ntúq aih, tumán vel Ep-ra-im. Án át tuki alứng top rian te án. ");
INSERT INTO pac_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tumán ính tớq ingái ticuoi Isa-ra-el cha ayư Ingái Ngốh. Iki clứng ticuoi át culái tieh vel pưt Yaru-salem, co nha-án ính táq veng rit sarau cháq nsuoi ingái ính cha bui veng rit. ");
INSERT INTO pac_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Máh ticuoi ngki suo níc Yê-su. Nha-án át tayứng tớq Dúng Sang Pưt, alứng munáq plốh munáq idô: “Imo mái parngíh, án tớq cha bui ayư ingái Ngốh tưi, ma lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Máh ticuoi sút top teng rit sang alứng top Pha-rasi patáp máh ticuoi ngki idô: “Khán ticuoi mmo chom ntúq Yê-su át, cóq án pôq kichóq dyôn he chom, co he ính cŏp Yê-su.” ");
INSERT INTO pac_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tupát ingái nsuoi te ingái top Isa-ra-el cha ayư Ingái Ngốh, Yê-su khoiq tớq nga vel Bê-thani, la ntúq La-sarơ át. La-sarơ la ticuoi ndon Yê-su khoiq amôih te cuchet. ");
INSERT INTO pac_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Át ntúq ngki nha-án táq mui pêl cha bui dyôn Yê-su. Mathê angốh crơng tanna dyôn Yê-su cha. La-sarơ ticu cha munơi alứng án. ");
INSERT INTO pac_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ndóng ngki Mari ial be dơq thum nốh ‘nar’. Dơq thum ngki bôn tarnáp dát lư. Mari tốq dơq thum tớq dyưng Yê-su, dyơ án chut dyưng Yê-su tớq sóc án. Chôp dúng ngki sáng hơi thum chal-chức. ");
INSERT INTO pac_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bôn munáq top rian te Yê-su, nốh Yuda I-cari-ôt, án ndon ính culieu Yê-su tông idô: ");
INSERT INTO pac_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Imo án lớiq táiq dơq thum ndô, dyơ ial práq ngki choi ticuoi kidit? Tarnáp dơq thum ndô li práq cống ngai thuthe tớq pe culám ingái.” ");
INSERT INTO pac_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Án tông iki, tới co án ính choi ticuoi kidit, ma án ính culứp práq, co án la ticuoi cadyiq práq chúng tớq top rian te Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ma Yê-su tông idô: “Tam án. Lư piaiq án thuan dŏq dơq thum ndô dyôn ingái ngai tứp cư. ");
INSERT INTO pac_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ticuoi kidit át níc alứng inha. Ma cư lớiq át níc alứng inha.” ");
INSERT INTO pac_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Máh ticuoi Isa-ra-el sáng ngai táq-ntêr Yê-su át tớq vel Bê-thani. Iki clứng lư nha-án pôq nga tuki. Nha-án pôq tới co ính tumúh nưm Yê-su, ma nha-án ính hôm díh La-sarơ, án ndon Yê-su khoiq amôih lieh te cuchet. ");
INSERT INTO pac_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Iki máh ticuoi sút top teng rit sang sisuo ngê ính cachet díh La-sarơ hơ, ");
INSERT INTO pac_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","la co te La-sarơ bôn clứng ticuoi Isa-ra-el táh nha-án, dyơ tin Yê-su loi. ");
INSERT INTO pac_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ingái parnô loi, clứng ticuoi ndon tớq cha bui ayư Ingái Ngốh, nha-án sáng hanh Yê-su tumán ính mot vel pưt Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iki nha-án ial ngcống pŏ alứng pôq côn Yê-su. Nha-án crau cariau yứng lư idô: “Ô-sana! Seq Yang Arbang-pilŏ́ng dyôn callong bún nga ticuoi ndon tớq nhơ te nốh Ưlla. Lư ayô puo ticuoi Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yê-su tumúh mui lám acái aséh a-êp, dyơ án sớr diq tớq crŏ́ng aséh ngki, táq muchứng ngai khoiq taran tớq tám uráq Yang Arbang-pilŏ́ng te inớh, idô: ");
INSERT INTO pac_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Vel Yaru-salem ơi, êq adáh amớh. Hoi-ndô puo inha chón tớq. Án diq tớq crŏ́ng acái aséh a-êp.” ");
INSERT INTO pac_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ingái ngki top rian te Yê-su iyốh chom arlớih te máh parnai ndô. Ma tư Yê-su cuchet alứng yôr tumống lieh, ki-náq nha-án apúh te parnai Yang Arbang-pilŏ́ng tông ndô la te Yê-su. Alứng nha-án ayư lieh, nha-án táq tarvớiq simớt parnai Yang khoiq tông te Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Máh ticuoi ndon hôm Yê-su arô La-sarơ dyôn ngốh te ping alứng dyôn tumống lieh, nha-án táq-ntêr mưt-mư te arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Co iki clứng ticuoi pôq tumúh Yê-su, co nha-án khoiq sáng hanh te arnáq sileh ndô. ");
INSERT INTO pac_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dyơ top Pha-rasi munáq táq-ntêr alứng munáq idô: “Ngki! Inha hôm lớiq? Nhéq máh ticuoi veng tapun án. Táq imo la he lớiq rap án mmớh.” ");
INSERT INTO pac_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tớq ingái cha ayư, bôn ticuoi Créc pôq nga vel pưt Yaru-salem, ính sang tám tớq ngki tưi. ");
INSERT INTO pac_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Top ticuoi Créc ngki tớq nga Phi-lip, la ticuoi vel Bet-sada, vúng Ca-lilê. Nha-án seq te Phi-lip idô: “Avốq ơi! He ính hôm lư Yê-su.” ");
INSERT INTO pac_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Phi-lip pôq táq-ntêr Anrê; dyơ Anrê alứng Phi-lip pôq táq-ntêr Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yê-su tông nha-án idô: “Tumán tớq dyơ ngư Yang Arbang-pilŏ́ng apáh chức ang-ưr Acái Yang Cơt Ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cư tông inha arlớih lư, khán bôn mui callong sro ngai chóh tớq cuteq, tư mát pidŏ́h, callong ngki cơt pít. Khán ngai lớiq chóh, callong ngki yôl níc mui callong sớng. Ma khán ngai chóh, callong ngki cơt a-ưi culái. ");
INSERT INTO pac_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ticuoi mmo ayáu tarngứh án tớq pang ndô, tarngứh án cơt pít. Ma ticuoi mmo lớiq ayáu tarngứh án tớq pang ndô, án lư bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ticuoi mmo ính táq arnáq cư, cóq án veng tapun cư. Ntúq mmo cư át, án át ntúq ngki tưi. Alứng ticuoi mmo táq arnáq cư, A-ám cư lư ráp tapông án. ");
INSERT INTO pac_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Hoi-ndô mít cannính cư sáng dieiq arức lư. Ma têq cư tông idô lớiq: ‘A-ám ơi! Choi cư dyôn viar vít te callong cuchet ndô?’ Cư lớiq têq tông iki, co cư tớq nga cúc cuteq ndô dŏq chiuq cuchet. ");
INSERT INTO pac_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A-ám ơi, seq mái táq dyôn nhéq tưh ticuoi ayô nốh ang-ưr mái!” Cua Yê-su tông iki, sieng Yang Arbang-pilŏ́ng tông te pilŏ́ng idô: “Cư khoiq táq dyôn ticuoi ayô nốh ang-ưr cư, alứng urớh cư táq muchứng ngki sa.” ");
INSERT INTO pac_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Máh ticuoi clứng át tớq ngki sáng sieng cơt arớq sieng crứm sớng. Bôn ticuoi ndon tông: “Tarneng Yang Arbang-pilŏ́ng táq-ntêr alứng Yê-su.” ");
INSERT INTO pac_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma Yê-su tông idô: “Sieng ndô tông a inha, tới a cư. ");
INSERT INTO pac_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hoi-ndô khoiq tớq ngư Yang Arbang-pilŏ́ng sưq nhéq tưh ticuoi tớq cúc cuteq ndô. Alứng án chuih angốh nhéq yang ndon sút tớq cúc cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma tư ngai tayŏ́ng cư tớq along calláng, cư lư tec dông nhéq tưh ticuoi tớq nga cư.” ");
INSERT INTO pac_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yê-su tông iki, án ính ticuoi chom na amớh án cuchet. ");
INSERT INTO pac_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Máh ticuoi ngki tông idô: “Tớq phep rit he, ngai tông Crit tumống níc-níc. Iki, imo thới tông Acái Yang Cơt Ticuoi cóq ngai tayŏ́ng tớq along calláng? Nnáu la Acái Yang Cơt Ticuoi?” ");
INSERT INTO pac_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yê-su ôi nha-án idô: “Yôl biq ingái sớng inha bôn callong ang. Hoi-ndô cóq inha pôq tớq callong ang ndô, co inha lớiq chom ndóng mmo tarkhứp callong ngiau tớq. Dyơ inha lớiq chom tumo ính pôq. ");
INSERT INTO pac_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ndóng inha yôl bôn callong ang, cóq inha tin callong ang, dyôn inha bôn cơt arớq acái acon callong ang tưi.” Cua Yê-su tông iki, án ngốh te nha-án, alứng án pôq catốq te nha-án. ");
INSERT INTO pac_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tam Yê-su khoiq táq a-ưi arnáq sileh chứng mát nha-án, ma nnáng nha-án lớiq tin án. ");
INSERT INTO pac_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iki cơt tarvớiq simớt parnai Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh idô: “Ưlla ơi! Bôn nnáu nếq náp parnai he cato? Bôn nnáu nếq hôm chức pưt lư te Yang Arbang-pilŏ́ng?” ");
INSERT INTO pac_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Co iki nha-án lớiq chom tin, co Ê-sai khoiq taran ntúq cannŏ́h idô: ");
INSERT INTO pac_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yang Arbang-pilŏ́ng táq dyôn mát nha-án cơt sot, alứng táq dyôn mít nha-án cơt cớng. Iki mát nha-án lớiq hôm. Alứng mít nha-án lớiq apúh. Nha-án lớiq ính tớq nga cư, dŏq cư táq dyôn nha-án cơt bánh.” ");
INSERT INTO pac_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ê-sai khoiq tông acớiq parnai ndô te Yê-su, co án khoiq hôm chức ang-ưr na Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tam cơt iki, ma yôl bôn a-ưi náq tin Yê-su, bôn díh ticuoi sút hơ. Ma nha-án lớiq dáh tông ticuoi cannŏ́h chom nha-án tin, co nha-án adáh top Pha-rasi chuih angốh nha-án te dúng rum. ");
INSERT INTO pac_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iki nha-án ính lư ticuoi cannŏ́h ayô nha-án clưi te nha-án ính Yang Arbang-pilŏ́ng ayô nha-án. ");
INSERT INTO pac_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Vít ngki, Yê-su tông yứng lư idô: “Ticuoi mmo tin cư, ticuoi ngki tới tin nưm munáq cư, ma ticuoi ngki tin díh án ndon yua cư tớq nga tudô hơ. ");
INSERT INTO pac_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ticuoi mmo hôm cư, ticuoi ngki hôm díh án ndon yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Cư la callong ang dyôn cúc cuteq ndô. Ticuoi mmo tin cư, ticuoi ngki lớiq át nnáng tớq callong ngiau. ");
INSERT INTO pac_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ticuoi mmo sáng parnai cư, ma án lớiq peh, cư lớiq tíq án. Co cư tớq nga tudô tới ính tíq ticuoi, ma cư tớq ính choi tamống nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ticuoi mmo lớiq ráp cư, alứng lớiq náp ial parnai cư; lư bôn parnai tíq án. Tớq ingái talloiq, máh parnai cư khoiq cato ngki táp tíq án. ");
INSERT INTO pac_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Cư lớiq bôn cato te chức cư bôm. Ma A-ám ndon yua cư tớq nga tudô táp khoiq yua cư cato máh parnai ngki. ");
INSERT INTO pac_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Cư chom máh parnai án patáp têq dyôn ticuoi bôn tumống níc-níc. Iki, máh parnai cư cato, la cư cato veng máh parnai A-ám cư khoiq yua cư cato.” ");
INSERT INTO pac_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yôl mui ingái loi, ki-náq ticuoi Isa-ra-el cha ayư Ingái Ngốh. Ingái ngki Yê-su chom khoiq tumán tớq ingái án pôq te cúc cuteq ndô, alứng chô lieh nga A-ám án. Án amoih nhéq tưh ticuoi tớq cúc cuteq ndô, la ticuoi ndon bôn mui mít alứng án. Án amoih nha-án tingôi sút cloiq. ");
INSERT INTO pac_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yê-su alứng top rian te án rum cha pêl ibư. Yang Satán khoiq táq tớq mít Yuda, acái Si-môn I-cari-ôt, dyôn culieu Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yê-su chom A-ám án khoiq dyôn án bôn chức têq sút cứp nốh. Alứng án chom án tớq te Yang Arbang-pilŏ́ng, alứng án tumán ính chô lieh nga Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Iki án yôr tayứng te ntúq chicha. Dyơ án luaiq au thor, alứng án ial khán toiq kitớn tớq tarving. ");
INSERT INTO pac_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Cua ngki án cacháq dơq tớq tháu, dyơ án tabớq arau dyưng top rian te án. Alứng án ial khán te tarving án, chut dyưng nha-án. ");
INSERT INTO pac_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tư án tớq nga Si-môn Phi-er, iki Phi-er plốh án idô: “Ưlla ơi! Ưlla ính arau dyưng cư hơ lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yê-su ôi án: “Mái lớiq apúh te arnáq cư táq hoi-ndô, ma tatun mái lư chom arlớih.” ");
INSERT INTO pac_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Phi-er dyŏq Yê-su idô: “Lớiq crái Ưlla arau dyưng cư.” Ma Yê-su ôi án: “Khán cư lớiq arau, mái lớiq têq cơt mui mít alứng cư.” ");
INSERT INTO pac_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dyơ Si-môn Phi-er tông idô: “Khán iki, Ưlla ơi, êq arau nưm dyưng sớng. Ma arau díh ati alứng plô cư hơ!” ");
INSERT INTO pac_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yê-su tông án idô: “Ticuoi mmo khoiq hom dơq, nhéq cháq án khoiq práh dyơ. Ma án cóq arau lieh dyưng án. Hoi-ndô nhéq inha khoiq práh dyơ, ma yôl bôn munáq te inha lớiq práh.” ");
INSERT INTO pac_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yê-su tông munáq te nha-án lớiq práh, co án khoiq chom dyơ ticuoi ndon ính culieu án. ");
INSERT INTO pac_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Cua án arau dyưng nha-án, án sứp lieh au thor án, dyơ án ticu lieh tớq ntúq chicha. Dyơ án plốh nha-án idô: “Inha apúh lớiq te arnáq cư táq dyôn inha? ");
INSERT INTO pac_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Inha arô cư la thới alứng Ưlla. Lư piaiq inha arô cư bar nốh ngki. ");
INSERT INTO pac_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Cư la Ưlla alứng thới inha, ma cư arau dyưng dyôn inha. Iki inha cóq munáq arau dyưng munáq muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Cư táq dŏq paryông inha dyôn têq inha táq muchứng cư khoiq táq dyôn inha. ");
INSERT INTO pac_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cư tông inha arlớih lư, ticuoi sol lớiq nai pưt clưi te ưlla án, alứng ticuoi tampeng lớiq nai pưt clưi te ticuoi yua án pôq. ");
INSERT INTO pac_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Khán inha chom nhéq máh nốh ndô, alứng inha lư veng, iki inha bôn callong bún. ");
INSERT INTO pac_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ma cư lớiq tông te nhéq tưh inha. Cư chom máh ticuoi ndon cư khoiq rêh. Ma lư cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông te inớh idô: ‘Bôn munáq ndon cha dôi alứng cư, urớh án cơt arớq ala bar pláh ính táq cư.’ ");
INSERT INTO pac_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Cư tông inha nsuoi te arnáq ngki iyốh tớq. Ma tư arnáq ngki tớq, inha lư tin cư la án ndon khoiq bôn dyơ. ");
INSERT INTO pac_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cư tông inha arlớih lư, ticuoi mmo cammáng parnai ticuoi ndon cư yua pôq cato, la muchứng án cammáng parnai cư tưi. Alứng ticuoi mmo cammáng parnai cư, la muchứng ticuoi ngki cammáng parnai án ndon yua cư tớq tưi.” ");
INSERT INTO pac_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cua Yê-su tông iki, án sáng dieiq arức lư tớq mít án. Dyơ án tông idô: “Cư tông inha arlớih lư, bôn munáq te top inha ính culieu cư.” ");
INSERT INTO pac_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Top rian te Yê-su parngơ alứng munáq me nga munáq, co nha-án lớiq chom Yê-su chón tông te nnáu. ");
INSERT INTO pac_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cư ndon artoi lư alứng Yê-su, cư át ting án ndóng ngki. ");
INSERT INTO pac_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Si-môn Phi-er cavoiq cư, alứng yua cư idô: “Mái plốh Yê-su, án táq-ntêr te nnáu.” ");
INSERT INTO pac_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iki cư sic tumán Yê-su alứng plốh idô: “Seq Ưlla tông he, ticuoi ngki la nnáu?” ");
INSERT INTO pac_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yê-su ôi idô: “Hoi-ndô cư ính túq mui mêng beng tớq tingan, dyơ avôi nga ticuoi ndon ính culieu cư.” Iki Yê-su ial mui mêng beng. Án túq beng tớq tingan. Dyơ án avôi nga Yuda, acái Si-môn I-cari-ôt. ");
INSERT INTO pac_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tư Yuda ráp beng, ndóng ngki táp yang Satán mot tớq mít án. Dyơ Yê-su tông ada án idô: “Arnáq amớh mái ính táq, mái táq adứh!” ");
INSERT INTO pac_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Máh ticuoi ndon ticu cha tớq ntúq ngki lớiq apúh te parnai Yê-su tông ada Yuda. ");
INSERT INTO pac_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bôn ticuoi parngíh Yê-su yua Yuda pôq plới crơng tanna, lớiq la pôq choi ticuoi kidit, co Yuda la ticuoi cadyiq práq chúng tớq top nha-án. ");
INSERT INTO pac_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cua Yuda ráp beng, án ngốh táp. Ndóng ngki pilŏ́ng khoiq idáu dyơ. ");
INSERT INTO pac_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Vít Yuda ngốh, Yê-su tông idô: “Hoi-ndô ngai bôn hôm chức ang-ưr Acái Yang Cơt Ticuoi. Alứng ngai ayô Yang Arbang-pilŏ́ng co nhơ te Acái án. ");
INSERT INTO pac_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Khán bôn ngai ayô chức ang-ưr Yang Arbang-pilŏ́ng co nhơ te Acái án, lư muchứng ngki tưi Yang Arbang-pilŏ́ng táq dyôn ngai ayô chức ang-ưr Acái án co nhơ te án. Alứng án táq dyôn ngai ayô án táp. ");
INSERT INTO pac_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Inha acái cư ơi! Cư át alứng inha nnáng biq ingái sớng. Inha ính suo cư; ma cư tông inha muchứng cư khoiq tông ticuoi Isa-ra-el dyơ, idô: ‘Ntúq cư pôq, inha lớiq têq pôq nga ntúq tuki.’ ");
INSERT INTO pac_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Hoi-ndô cư ính patáp inha mui callong tamme. Callong ndô la idô: Cư khoiq amoih inha, iki inha cóq munáq amoih munáq muchứng ngki tưi. ");
INSERT INTO pac_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Khán inha munáq amoih munáq, iki nhéq tưh ticuoi chom inha veng ngê cư khớm lư.” ");
INSERT INTO pac_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Si-môn Phi-er plốh Yê-su idô: “Ưlla ơi! Tumo Ưlla ính pôq?” Yê-su ôi án: “Ntúq cư pôq, hoi-ndô mái lớiq têq veng cư. Ma urớh mái têq veng tapun cư.” ");
INSERT INTO pac_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Iki Phi-er plốh loi: “Ưlla ơi! Co imo cư lớiq têq veng tapun Ưlla hoi-ndô? Cư rap cuchet munơi alứng Ưlla.” ");
INSERT INTO pac_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma Yê-su ôi án: “Lư mái rap chiuq cuchet munơi alứng cư lớiq? Cư tông mái arlớih lư, ntruoi iyốh ticár, mái khoiq calôih cư pe chư.” ");
INSERT INTO pac_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yê-su cato loi idô: “Inha êq sáng dieiq arức tớq mít inha. Tin Yang Arbang-pilŏ́ng alứng tin cư. ");
INSERT INTO pac_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tớq dúng A-ám cư bôn a-ưi ntúq át. Hoi-ndô cư pôq thuan ntúq dyôn inha. Khán callong ndô lớiq lư, cư lớiq tông inha. ");
INSERT INTO pac_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tớq cua cư thuan ntúq dyôn inha át, cư lư tớq lieh, alứng dông inha pôq át alứng cư. Ntúq mmo cư át, inha lư át ntúq ngki tưi. ");
INSERT INTO pac_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Inha chom tumo cư ính pôq, alứng inha chom dyơ carna pôq tuki.” ");
INSERT INTO pac_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thô-mat plốh Yê-su idô: “Ưlla ơi! He lớiq chom tumo Ưlla ính pôq. Imo têq he chom carna pôq dyôn tớq nga tuki?” ");
INSERT INTO pac_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yê-su ôi án idô: “Cư la carna pôq; cư la callong lư; alứng cư la callong tumống. Lớiq bôn ngai têq tớq nga A-ám cư, khán án lớiq pôq na cư. ");
INSERT INTO pac_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Khán inha chom cư, inha chom tưi A-ám cư. Ma te ndô chô-mát, inha lư chom án, alứng inha khoiq hôm án dyơ.” ");
INSERT INTO pac_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Phi-lip tông idô: “Seq Ưlla apáh A-ám Ưlla dyôn he me, la piaiq táp.” ");
INSERT INTO pac_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yê-su ôi án idô: “Phi-lip ơi! Cư át alứng inha khoiq dưnh dyơ, ma imo mái iyốh chom cư sa? Ticuoi mmo khoiq hôm cư, la muchứng án khoiq hôm A-ám cư tưi. Imo mái seq cư apáh A-ám cư dyôn inha hôm? ");
INSERT INTO pac_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Imo inha lớiq tin cư át mui mít alứng A-ám, alứng A-ám át mui mít alứng cư? Máh parnai cư cato inha, tới parnai cư bôm, ma parnai A-ám ndon át mui mít alứng cư; án táp táq máh arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cóq inha tin tớq cư tông cư át mui mít alứng A-ám, alứng A-ám át mui mít alứng cư. Ma khán inha lớiq tin, iki cóq inha tin te máh arnáq sileh cư khoiq táq. ");
INSERT INTO pac_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cư tông inha arlớih lư, ticuoi mmo tin cư, ticuoi ngki ính táq arnáq muchứng cư tưi. Ma án táq arnáq pưt clưi te ngki loi, co hoi-ndô cư chô lieh nga A-ám cư. ");
INSERT INTO pac_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Callong amớh inha seq nhơ nốh cư, cư lư dyôn inha bôn callong ngki. Cư táq iki ính ngai ayô chức ang-ưr A-ám tớq pilŏ́ng nhơ te Acái án. ");
INSERT INTO pac_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Khán inha seq callong amớh nhơ nốh cư, cư lư dyôn inha bôn callong ngki.” ");
INSERT INTO pac_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Khán inha amoih cư, cóq inha peh máh parnai cư patáp. ");
INSERT INTO pac_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Dyơ cư seq te A-ám cư, alứng án dyôn inha bôn Arvai piaiq lư. Arvai ngki tang cư dŏq choi inha, alứng án át níc alứng inha. Ma máh ticuoi lớiq tin, nha-án lớiq têq bôn Arvai ndô, co nha-án lớiq acớl alứng lớiq chom án. Ma inha chom án, co án át níc alứng inha, alứng án át tớq mít inha. ");
INSERT INTO pac_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Cư lớiq bôn táh inha dyôn cơt arớq acái pantưi. Cư lư tớq lieh nga inha. ");
INSERT INTO pac_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yôl biq ingái sớng, máh ticuoi tớq pang ndô lớiq hôm nnáng cư, ma inha hôm cư. Co cư tumống, urớh inha bôn tumống tưi. ");
INSERT INTO pac_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tư ingái ngki tớq, inha chom arlớih cư át mui mít alứng A-ám cư, alứng inha át mui mít alứng cư, muchứng cư át mui mít alứng inha. ");
INSERT INTO pac_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ticuoi mmo ráp ial máh parnai cư patáp alứng peh, ticuoi ngki lư amoih cư. A-ám cư amoih án ndon amoih cư. Cư amoih án tưi, alứng cư apáh ngê cư dyôn án chom.” ");
INSERT INTO pac_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Cua Yê-su tông iki, Yuda (tới Yuda I-cari-ôt) plốh Yê-su idô: “Ưlla ơi, co imo Ưlla apáh ngê Ưlla nưm dyôn he, ma Ưlla lớiq apáh dyôn máh ticuoi tớq pang ndô chom tưi?” ");
INSERT INTO pac_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yê-su ôi án idô: “Ticuoi mmo amoih cư, ticuoi ngki peh máh parnai cư. A-ám cư amoih án. Cư alứng A-ám cư tớq nga án, alứng át níc alứng án. ");
INSERT INTO pac_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma ticuoi mmo lớiq amoih cư, ticuoi ngki lớiq peh parnai cư. Parnai inha sáng hoi-ndô, tới parnai cư, ma parnai A-ám ndon yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Cư tông máh parnai ndô, ndóng cư yôl át alứng inha. ");
INSERT INTO pac_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma Arvai Yang Arbang-pilŏ́ng ndon A-ám cư yua tớq tang cư dŏq choi inha, Arvai ngki cato inha túc nốh; alứng án ính choi inha ayư lieh te máh parnai cư khoiq tông inha. ");
INSERT INTO pac_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Cư dyôn callong ien ŏ át tớq mít inha. Callong ien ŏ cư bôm cư dyôn nga inha. Cư dyôn inha lớiq arớq ticuoi tớq pang ndô dyôn. Inha êq táq dyôn mít cannính inha sáng dieiq arức, alứng inha êq adáh. ");
INSERT INTO pac_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Inha khoiq sáng dyơ cư tông: ‘Cư ngốh te inha, ma urớh cư tớq lieh nga inha.’ Khán inha amoih cư, inha sáng ơn tưi tớq cư chô lieh nga A-ám cư, co A-ám pưt clưi te cư. ");
INSERT INTO pac_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cư tông inha nsuoi máh arnáq ngki iyốh tớq, dŏq tư máh arnáq ngki tớq, inha tin simớt lư. ");
INSERT INTO pac_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Cư lớiq táq-ntêr a-ưi nnáng alứng inha, co yang ndon sút tớq cúc cuteq ndô tumán ính tớq dyơ. Ma án lớiq têq cơt sút cư. ");
INSERT INTO pac_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma cư táq máh nốh ndô, dyôn nhéq tưh ticuoi chom arlớih cư amoih A-ám cư. Alứng cư peh nhéq máh parnai A-ám cư khoiq patáp cư. Inha yôr tayứng! He ngốh te ntúq ndô!” ");
INSERT INTO pac_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yê-su tông loi idô: “Cư la ntớng piaiq lư. Alứng A-ám cư la án ndon kiaq me nưong. ");
INSERT INTO pac_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Abeng mmo lớiq cơt culái, án cớl táh abeng ngki. Alứng abeng mmo cơt culái, án asa dyôn práh. Iki abeng ngki cơt culái a-ưi lư loi. ");
INSERT INTO pac_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Inha khoiq cơt práh la co nhơ te parnai cư khoiq cato inha. ");
INSERT INTO pac_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cóq inha át níc mui mít alứng cư, alứng cư át níc mui mít alứng inha. Khán abeng mmo tiduah te ntớng, abeng ngki lớiq têq cơt culái. Muchứng ngki tưi, khán inha lớiq át níc mui mít alứng cư, inha lớiq têq cơt culái amớh. ");
INSERT INTO pac_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Cư la ntớng. Inha la abeng. Ticuoi mmo át níc mui mít alứng cư, alứng cư át níc mui mít alứng án, ticuoi ngki cơt a-ưi culái. Khán inha tiduah te cư, ngki inha lớiq têq táq amớh. ");
INSERT INTO pac_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ticuoi mmo lớiq át níc mui mít alứng cư, ngai váng angốh án arớq ngai váng abeng ntớng tưi. Dyơ abeng ngki cơt ráng, alứng ngai ial abeng ngki adúh tớq uih dyôn ngcat nhéq. ");
INSERT INTO pac_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Khán inha át níc mui mít alứng cư, alứng parnai cư át níc tớq mít inha, callong amớh inha seq, lư inha bôn callong ngki. ");
INSERT INTO pac_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Khán inha cơt a-ưi culái, iki ticuoi cannŏ́h lư chom inha veng ngê cư, alứng inha apáh chức ang-ưr A-ám cư hơ. ");
INSERT INTO pac_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Cư amoih inha muchứng A-ám cư amoih cư. Cóq inha cadyiq níc callong amoih te cư. ");
INSERT INTO pac_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Khán inha peh parnai cư patáp, iki inha cadyiq níc callong amoih te cư, muchứng cư peh máh parnai A-ám cư patáp, alứng cư cadyiq níc callong amoih te án. ");
INSERT INTO pac_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Cư khoiq cato inha dyơ te máh nốh ndô, dyơ cư têq dyôn callong bui át tớq mít inha, alứng dyôn inha bôn máng callong bui sớng. ");
INSERT INTO pac_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Parnai cư patáp la idô: Cóq inha munáq amoih munáq, muchứng cư khoiq amoih inha. ");
INSERT INTO pac_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Callong amoih pưt clưi nhéq te cannŏ́h, la bôn munáq mŏp tarngứh án dŏq choi yớu án. ");
INSERT INTO pac_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Khán inha la yớu cư, cóq inha peh parnai cư patáp. ");
INSERT INTO pac_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Cư lớiq bôn dŏq nnáng inha ticuoi sol, co sol lớiq chom amớh ưlla án táq. Ma cư dŏq inha la yớu cư, co cư dyôn inha chom cứp nốh ndon cư khoiq sáng te A-ám cư. ");
INSERT INTO pac_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Inha lớiq bôn rêh cư, ma cư rêh inha, alứng cư chóh inha dyôn cơt culái, culái ngki plŏt ŏ níc. Iki callong amớh inha seq te A-ám nhơ nốh cư, A-ám cư lư dyôn inha bôn callong ngki. ");
INSERT INTO pac_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Máh parnai cư patáp inha la idô: Inha cóq munáq amoih munáq.” ");
INSERT INTO pac_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Khán ticuoi tớq pang ndô a-ính inha, cóq inha chom tưi nha-án khoiq a-ính cư nsuoi inha. ");
INSERT INTO pac_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Khán inha sŏ́ng munơi alứng ticuoi tớq pang ndô, nha-án lư amoih inha arớq em ai tưi. Ma cư khoiq rêh inha te máh ticuoi ngki. Alứng inha lớiq sŏ́ng nnáng alứng nha-án. Co iki nha-án a-ính inha. ");
INSERT INTO pac_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cóq inha ayư parnai cư khoiq cato inha idô: ‘Ticuoi sol lớiq nai pưt hơn te ưlla án.’ Khán nha-án khoiq táq cư, nha-án lư táq inha tưi. Khán nha-án cammáng parnai cư, nha-án lư cammáng tưi parnai inha. ");
INSERT INTO pac_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nha-án ính táq máh arnáq ndô ada inha la co tian cư, co nha-án lớiq chom án ndon yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Khán cư lớiq tớq cato nha-án, ngki nha-án lớiq chom nha-án bôn luaih. Ma hoi-ndô nha-án lớiq têq suon nnáng nha-án lớiq bôn luaih amớh. ");
INSERT INTO pac_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ticuoi mmo a-ính cư, lư án a-ính díh A-ám cư tưi. ");
INSERT INTO pac_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Khán cư lớiq táq máh arnáq ndon ticuoi cannŏ́h lớiq têq táq, ngki nha-án lớiq têq chom nha-án bôn luaih. Ma hoi-ndô nha-án khoiq hôm dyơ máh arnáq ngki, ma nha-án yôl a-ính cư alứng A-ám cư. ");
INSERT INTO pac_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma arnáq ndô cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông te inớh idô: ‘Cư lớiq bôn táq luaih amớh, ma nha-án chóng a-ính cư.’ ");
INSERT INTO pac_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Urớh án ndon cư yua tớq choi inha, án tớq te A-ám cư. Án la Arvai piaiq lư, alứng án cato te cư. ");
INSERT INTO pac_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Alứng inha cóq cato te cư tưi, co inha khoiq át alứng cư te tôm tháng.” ");
INSERT INTO pac_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Cư tông inha nhéq máh nốh ndô dyôn inha lớiq arbúc. ");
INSERT INTO pac_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Urớh ticuoi Isa-ra-el chuih angốh inha te dúng rum nha-án. Alứng ingái ngki ngai cachet inha, co nha-án parngíh nha-án táq arnáq Yang Arbang-pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nha-án táq iki, co nha-án lớiq chom A-ám cư alứng lớiq chom cư. ");
INSERT INTO pac_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cư tông dyôn inha chom máh nốh ndô te nốh ndô iyốh tớq, dŏq inha ayư cư khoiq tông inha dyơ. Te nsuoi cư lớiq túh cóq tông inha te máh nốh ndô, co cư yôl át alứng inha. ");
INSERT INTO pac_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ma hoi-ndô cư ính chô lieh nga án ndon yua cư tớq nga tudô, ma lớiq bôn nnáu te inha plốh cư idô: ‘Tumo thới ính pôq?’ ");
INSERT INTO pac_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ma co cư khoiq tông inha te máh nốh ndô, iki inha sáng anguaq lư. ");
INSERT INTO pac_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma hoi-ndô cư tông inha callong lư, co cư pôq te inha, iki cơt tarnáp dyôn inha. Khán cư lớiq ngốh te inha, án ndon choi inha lớiq têq tớq nga inha. Ma khán cư pôq, cư lư yua án tớq nga inha. ");
INSERT INTO pac_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tư án tớq, án cato nhéq tưh ticuoi dyôn chom arlớih te callong luaih, te callong tinớng ŏ, alứng te callong tarsưq. ");
INSERT INTO pac_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Án tông te callong luaih co ticuoi lớiq tin cư. ");
INSERT INTO pac_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Án tông te callong tinớng ŏ, co cư chô lieh nga A-ám cư, alứng inha lớiq hôm nnáng cư. ");
INSERT INTO pac_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Án tông te callong tarsưq, co Yang Arbang-pilŏ́ng khoiq sưq yang ndon sút tớq cúc cuteq ndô alứng khoiq anát tôt dyôn yang ngki. ");
INSERT INTO pac_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Yôl bôn a-ưi callong loi cư ính tông inha, ma callong ngki ntáng lư; inha lớiq rap chiuq mmớh. ");
INSERT INTO pac_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tư Arvai Piaiq Lư tớq, án ayông inha pôq tớq máh callong piaiq. Án lớiq tông inha te ngê án bôm, ma án tông te máh callong án khoiq sáng. Alứng án tông inha te máh callong ndon iyốh tớq hơ. ");
INSERT INTO pac_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Án ính apáh chức ang-ưr te cư, co án ial parnai cư, alứng án tông dyôn inha chom tưi. ");
INSERT INTO pac_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nhéq máh mun A-ám cư la na cư. Iki têq cư yua Arvai Yang Arbang-pilŏ́ng dyôn ial parnai cư, dyơ pôq tông dyôn inha chom tưi.” ");
INSERT INTO pac_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Yôl lớiq dưnh, inha lớiq bôn hôm nnáng cư. Náp te ingái ngki lớiq dưnh, inha bôn hôm lieh cư.” ");
INSERT INTO pac_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Top rian te Yê-su, munáq plốh munáq idô: “Amớh táp án tông idô: ‘Yôl lớiq dưnh, inha lớiq bôn hôm nnáng cư. Náp te ingái ngki lớiq dưnh, inha bôn hôm lieh cư.’ Alứng án tông: ‘Cóq cư chô lieh nga A-ám cư.’ ");
INSERT INTO pac_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Alứng amớh loi án tông: ‘Lớiq dưnh nnáng’? He lớiq chom amớh án chón tông he.” ");
INSERT INTO pac_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yê-su khoiq chom nha-án ính plốh án te callong ngki. Iki án tông nha-án idô: “Cư khoiq tông inha dyơ: Nnáng lớiq dưnh, inha lớiq bôn hôm nnáng cư. Náp te ingái ngki lớiq dưnh, inha bôn hôm lieh cư. Imo inha munáq plốh munáq te callong ndô? ");
INSERT INTO pac_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cư tông inha arlớih lư, urớh inha nhiem alứng sáng anguaq lư, ma máh ticuoi tớq pang ndô sáng bui hơr lư. Inha sáng anguaq, ma callong anguaq ngki têq cơt callong bui hơr lieh. ");
INSERT INTO pac_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Arnáq ndô la arớq cán chón carnian acái. Ndóng án carnian, án sáng a-ái lư, co khoiq tớq cuop cumo dyơ. Ma cua án carnian acái, án lớiq ayư nnáng te callong án chiuq dieiq arức, ma án sáng bui, co án carnian acái tớq pang ndô. ");
INSERT INTO pac_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Inha la muchứng ngki tưi. Hoi-ndô inha sáng anguaq lư, ma urớh cư hôm lieh inha. Ingái ngki inha sáng bui hơr lieh, alứng lớiq bôn ngai têq ial callong bui ngki te inha. ");
INSERT INTO pac_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tớq ingái ngki, inha lớiq plốh mui callong amớh nnáng te cư. Cư tông inha arlớih lư, A-ám cư dyôn inha bôn callong amớh inha seq nhơ nốh cư. ");
INSERT INTO pac_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tingôi hoi-ndô inha iyốh seq amớh nhơ te nốh cư. Inha seq, ngki inha bôn, dyơ inha bôn nưm callong bui sớng tớq mít cannính inha. ");
INSERT INTO pac_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Cư khoiq tông inha máh callong ndô tớq parnai acám. Ma urớh cư lớiq tông nnáng tớq parnai acám. Ingái ngki cư tông dyôn inha chom arlớih lư te A-ám cư. ");
INSERT INTO pac_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tớq ingái ngki, inha seq nhơ nốh cư. Cư lớiq bôn tông cư ính seq te A-ám cư dyôn inha, ");
INSERT INTO pac_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","co A-ám cư amoih inha tưi, co inha khoiq amoih cư alứng tin cư lư tớq te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Te nsuoi cư ngốh te A-ám cư, dyơ cư tớq nga cúc cuteq ndô. Hoi-ndô cư pôq te cúc cuteq ndô, alứng chô lieh nga A-ám cư.” ");
INSERT INTO pac_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Cua Yê-su cato iki, top rian te án tông idô: “Hoi-ndô thới cato arlớih lư. Thới lớiq cato nnáng tớq parnai acám. ");
INSERT INTO pac_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hoi-ndô he apúh thới chom cứp nốh, alứng lớiq túh ngai plốh nnáng thới. Co iki he tin thới lư tớq te Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yê-su ráp ngcang nha-án idô: “Hoi-ndô inha lư tin lớiq? ");
INSERT INTO pac_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tumán ính tớq dyơ ngư inha mmar pláh chô lieh nga dúng inha, alứng inha táh cư dyôn át munáq sớng. Ma cư lớiq át munáq, co A-ám cư át níc alứng cư. Ma ngư ngki khoiq tớq dyơ. ");
INSERT INTO pac_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cư khoiq tông inha te máh parnai ndô, dyôn inha bôn callong ien ŏ co inha át mui mít alứng cư. Tớq pang ndô, inha lư tumúh a-ưi nốh dieiq arức. Ma cóq inha át avứng! Cư khoiq rap dyơ pang ndô!” ");
INSERT INTO pac_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cua Yê-su tông iki, án tingưi asớr nga pilŏ́ng alứng cớu idô: “A-ám ơi! Ngư cư khoiq tớq dyơ. Hoi-ndô cư seq mái apáh chức ang-ưr cư dyôn máh ticuoi chom, dyôn cư Acái têq apáh lieh chức ang-ưr na mái. ");
INSERT INTO pac_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mái khoiq dyôn cư Acái bôn cơt sút cứp náq ticuoi. Iki têq cư dyôn nhéq tưh ticuoi ndon mái khoiq mŏp a cư bôn tumống níc-níc. ");
INSERT INTO pac_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Callong tumống níc-níc la ndô: Ticuoi bôn chom mái. Nưm mái táp la Yang Arbang-pilŏ́ng piaiq lư. Alứng nha-án bôn chom cư Yê-su Crit, án ndon mái khoiq yua dyôn tớq nga cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Cư khoiq apáh dyơ chức ang-ưr mái tớq cuteq ndô. Alứng cư khoiq táq cua dyơ máh arnáq mái yua cư táq. ");
INSERT INTO pac_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A-ám ơi, hoi-ndô cư chô át lieh alứng mái. Cư seq mái dyôn cư bôn chức ang-ưr át alứng mái, muchứng cư khoiq bôn te nsuoi, ndóng mái iyốh teng cúc cuteq ndô. ");
INSERT INTO pac_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Máh ticuoi ndon mái khoiq mŏp dyôn cư bôn tớq pang ndô, cư khoiq tông nha-án te mái. Nha-án la ticuoi mái; mái khoiq mŏp nha-án dyôn cư. Alứng nha-án khoiq peh parnai mái. ");
INSERT INTO pac_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hoi-ndô nha-án chom arlớih lư máh nốh mái khoiq dyôn cư la tớq te mái. ");
INSERT INTO pac_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Cư khoiq cato nha-án te máh parnai mái khoiq tông cư; alứng nha-án khoiq ráp ial máh parnai ngki. Nha-án chom arlớih lư cư tớq te mái, alứng nha-án khoiq tin mái yua cư tớq tudô. ");
INSERT INTO pac_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Cư cớu seq dyôn nha-án. Cư lớiq bôn cớu seq dyôn máh ticuoi tớq pang ndô, ma cư cớu seq dyôn nha-án ndon mái khoiq mŏp dyôn cư, co nha-án la ticuoi mái. ");
INSERT INTO pac_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nhéq tưh ticuoi cư la ticuoi mái tưi, alứng nhéq tưh ticuoi mái la ticuoi cư tưi. Dyơ ngai têq bôn ayô chức ang-ưr cư co nhơ te nha-án. ");
INSERT INTO pac_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Cư lớiq át nnáng tớq cúc cuteq ndô. Ma nha-án yôl át níc tớq cuteq ndô. Alứng cư chô lieh nga mái. A-ám ơi, mái la práh ŏ lư! Cư seq mái kiaq ayáu nha-án nhơ chức te nốh mái, la nốh ndon mái khoiq dyôn nga cư. Seq mái táq iki, dyôn nha-án têq át mui mít muchứng he tưi. ");
INSERT INTO pac_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ndóng cư át alứng nha-án, cư kiaq ayáu nha-án co nhơ chức te nốh mái, la nốh ndon mái khoiq dyôn nga cư. Cư khoiq kiaq nha-án, ma pít nưm munáq sớng, ticuoi cannŏ́h lớiq bôn pít. Án ndon pít la án ndon khoiq anát dyôn pôq nga ntúq uih chéh níc-níc, dyôn cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông te inớh. ");
INSERT INTO pac_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Hoi-ndô cư chón chô nga mái. Ma cư tông nhéq máh nốh ndô ndóng cư yôl át tớq pang ndô, dyôn nha-án bôn máng callong bui te cư tớq mít cannính nha-án. ");
INSERT INTO pac_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Cư khoiq cato nha-án te parnai mái. Co iki ticuoi tớq pang ndô a-ính nha-án, co nha-án lớiq veng ngê tớq pang ndô, muchứng cư lớiq veng ngê tớq pang ndô tưi. ");
INSERT INTO pac_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Cư lớiq bôn seq mái dông angốh nha-án te pang ndô, ma cư seq mái kiaq ayáu nha-án dyôn vít te ati yang ndon sút máh yang saq. ");
INSERT INTO pac_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nha-án lớiq veng ngê tớq pang ndô, muchứng cư lớiq veng ngê tớq pang ndô tưi. ");
INSERT INTO pac_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Parnai mái la piaiq lư. Cư seq mái payáh nha-án te ticuoi tớq pang ndô nhơ te parnai piaiq na mái. ");
INSERT INTO pac_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mái khoiq yua cư tớq nga ticuoi tớq pang ndô, muchứng ngki tưi cư yua nha-án ndon veng cư pôq nga máh ticuoi tớq pang ndô. ");
INSERT INTO pac_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cư chóng payáh bôm te ngê tớq pang ndô, dyôn cư têq át mui mít alứng mái. Cư táq iki dyôn nha-án ndon veng tapun cư têq payáh te arnáq tớq pang ndô, dyơ nha-án têq át mui mít alứng mái. ");
INSERT INTO pac_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Cư lớiq bôn seq dyôn nưm nha-án sớng. Ma cư seq díh dyôn nhéq tưh ticuoi ndon tin cư co nhơ te parnai nha-án cato. ");
INSERT INTO pac_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Cư seq dyôn nhéq tưh nha-án át mui mít, muchứng mái át mui mít alứng cư, alứng cư át mui mít alứng mái. Alứng cư seq mái dyôn nha-án át mui mít alứng he tưi, dyôn máh ticuoi cannŏ́h tớq pang ndô têq tin mái khoiq yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Cư khoiq dyôn nha-án bôn chức ang-ưr muchứng mái khoiq dyôn cư bôn, dyôn nha-án têq át mui mít muchứng he tưi. ");
INSERT INTO pac_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Cư át mui mít alứng nha-án, alứng mái át mui mít alứng cư. Iki dyôn nhéq tưh nha-án têq át mui mít tưi, dyơ máh ticuoi tớq pang ndô bôn chom arlớih lư mái khoiq yua cư tớq nga tudô, alứng dyôn nha-án chom mái amoih nha-án muchứng mái amoih cư tưi. ");
INSERT INTO pac_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“A-ám ơi! Máh ticuoi mái khoiq mŏp dyôn cư, ntúq mmo cư át, cư ính nha-án át ntúq ngki tưi. Iki nha-án têq hôm chức ang-ưr cư, la chức ang-ưr mái khoiq dyôn cư bôn co mái amoih cư te nsuoi mái iyốh teng pilŏ́ng cuteq. ");
INSERT INTO pac_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","A-ám ơi! Mái la tinớng lư. Ticuoi tớq pang ndô lớiq chom mái. Ma cư chom mái, alứng nha-án ndon veng tapun cư chom mái khoiq yua cư tớq. ");
INSERT INTO pac_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Cư khoiq cato nha-án dyôn chom mái tưi. Alứng te ndô tớq chô-mát, cư ính cato loi callong ndô dyôn mái têq amoih nha-án muchứng mái amoih cư, alứng dyôn cư têq át mui mít níc alứng nha-án.” ");
INSERT INTO pac_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cua Yê-su cớu iki, án alứng top rian te án ngốh te ntúq ngki; dyơ nha-án dyang pa dyáng atóh dơq soq Ki-trôn. Tớq ntúq ngki bôn nưong; dyơ Yê-su alứng top rian te án mot tớq nưong ngki. ");
INSERT INTO pac_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda ndon culieu Yê-su chom ntúq ngki, co Yê-su báq rum ngki alứng top rian te án. ");
INSERT INTO pac_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iki Yuda ayông mui top líng, máh tampeng ticuoi sút top teng rit sang, alứng top Pha-rasi, pôq nga nưong ngki. Nha-án kéu crơng pla, den tớu, alứng tabong. ");
INSERT INTO pac_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yê-su khoiq chom dyơ máh arnáq ính tớq nga án. Iki án pôq nga ticuoi ngki alứng án plốh idô: “Nnáu inha sisuo?” ");
INSERT INTO pac_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nha-án ôi: “He suo Yê-su, án ndon te vel Na-saret.” Yê-su ôi nha-án: “Cư ndô la án.” Yuda ndon culieu Yê-su tayứng munơi alứng top ngki tưi. ");
INSERT INTO pac_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tư Yê-su ôi: “Cư ndô la án,” iki nha-án ndon ính cŏp Yê-su carlun alứng tilieng dứm. ");
INSERT INTO pac_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dyơ Yê-su plốh sa nha-án: “Nnáu inha suo?” Nha-án ôi sa: “He suo Yê-su, án ndon te vel Na-saret.” ");
INSERT INTO pac_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yê-su ôi sa nha-án idô: “Cư khoiq tông inha dyơ, cư ndô la án. Khán inha suo cư, ngki inha yua máh ticuoi ndô pôq nhéq avai.” ");
INSERT INTO pac_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yê-su tông parnai ngki dyôn cơt tarvớiq simớt parnai án khoiq tông te nsuoi idô: “A-ám ơi, cư lớiq bôn táq pít munáq ticuoi mmo ndon mái khoiq mŏp a cư.” ");
INSERT INTO pac_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Si-môn Phi-er bôn mui pla dau. Án thot dau te sŏr, dyơ án tráh sol ariaih top teng rit sang, ti-ŏ́h cutor pa atớm. Nốh ticuoi sol ngki la Mal-chu. ");
INSERT INTO pac_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yê-su yua Phi-er idô: “Mái cacháq lieh dau mái tớq sŏr! Hoi-ndô cư cóq ngoiq te tingan A-ám cư dyôn cư ngoiq.” ");
INSERT INTO pac_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ndóng ngki top líng, ticuoi sút líng, alứng máh tampeng ticuoi sút top Isa-ra-el, top nha-án cŏp Yê-su, alứng chóq án. ");
INSERT INTO pac_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nha-án dông án nga An-na cuya-conh Cai-pha. Tớq cumo ngki Cai-pha cơt ariaih top teng rit sang. ");
INSERT INTO pac_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Cai-pha la ticuoi ndon khoiq tông top Isa-ra-el te nsuoi, idô: “The he dyôn munáq ndô sớng cuchet, aláng dyôn nhéq máh ticuoi he cuchet.” ");
INSERT INTO pac_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si-môn Phi-er alứng munáq loi top rian te Yê-su veng tapun Yê-su. Án ndon ariaih top teng rit sang acớl munáq ngki. Co iki án bôn mot munơi alứng Yê-su tớq ngcưm paniar dúng ticuoi ariaih top teng rit sang. ");
INSERT INTO pac_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ma Phi-er át culái tieh ngáh callống. Iki munáq ndon arcớl ariaih top teng rit sang, píh lieh nga ngáh callống, alứng án seq te cán ndon kiaq callống dyôn Phi-er mot tưi. ");
INSERT INTO pac_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Cán ngki plốh Phi-er idô: “Mái la top rian te ticuoi ngki lớiq?” Phi-er ôi: “Cư tới te top ngki.” ");
INSERT INTO pac_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Máh ticuoi táq arnáq alứng ticuoi líng át tớq ntúq ngki sáng ngngiat. Iki nha-án achúq uih alứng heng. Phi-er tayứng heng uih munơi alứng nha-án tưi. ");
INSERT INTO pac_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ariaih top teng rit sang plốh Yê-su te top rian te án, alứng te parnai án cato. ");
INSERT INTO pac_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yê-su ôi idô: “Cư khoiq tông arlớih lư dyôn nhéq máh ticuoi chom. Cư cato níc tớq dúng rum alứng tớq Dúng Sang Pưt nga ntúq nhéq máh ticuoi Isa-ra-el báq rum. Cư lớiq bôn catốq mui callong amớh te máh parnai cư cato. ");
INSERT INTO pac_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Imo inha plốh cư? Piaiq lư la inha plốh nha-án ndon khoiq sáng te parnai cư cato. Nha-án khoiq chom dyơ te parnai ngki.” ");
INSERT INTO pac_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cua Yê-su tông iki, bôn munáq tampeng ticuoi sút páh Yê-su, alứng tông idô: “Imo mái tông iki chứng mát ariaih top teng rit sang?” ");
INSERT INTO pac_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yê-su ôi án idô: “Khán cư tông lớiq piaiq, ngki seq mái tông cư. Ma khán cư tông piaiq, ngki imo mái páh cư?” ");
INSERT INTO pac_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Cua ngki An-na yua ngai dông Yê-su nga Cai-pha ndon ariaih top teng rit sang. Ma nha-án yôl chóq Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Phi-er yôl tayứng heng uih. Ma bôn ticuoi plốh Phi-er: “Mái la top rian te án ngki lớiq?” Phi-er ôi idô: “Cư tới te top án.” ");
INSERT INTO pac_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bôn munáq sol ariaih top teng rit sang át ntúq ngki tưi. Án la em ai ticuoi ndon Phi-er khoiq tráh cutor. Án plốh Phi-er idô: “Arớq cư khoiq hôm mái tớq nưong alứng án ngki, lư lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma Phi-er calôih sa Yê-su. Ndóng ngki táp ntruoi ticár. ");
INSERT INTO pac_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tớq ang iláih yôl cláih lư, nha-án dông Yê-su te dúng Cai-pha nga ntúq báq tarsưq ticuoi. Ma máh ticuoi Isa-ra-el lớiq ính mot tớq ntúq ngai tarsưq, co tán khán nha-án mot tớq ntúq ngki nsuoi te nha-án cha ayư Ingái Ngốh. ");
INSERT INTO pac_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Co top Isa-ra-el lớiq ính mot nga ntúq ngai tarsưq, iki Phi-lat la ticuoi sút ntúq ngki ngốh nga nha-án, alứng án plốh nha-án idô: “Inha bôn callong amớh ính cauq ticuoi ndô?” ");
INSERT INTO pac_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nha-án ôi idô: “Khán án ndô lớiq táq pla-mpla, he lớiq dông án nga avốq.” ");
INSERT INTO pac_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Phi-lat tông nha-án idô: “Cóq inha dông achô lieh án; dyơ inha táq ada án veng rit inha bôm.” Ma ticuoi Isa-ra-el ngki ôi idô: “He ớq chức têq cachet ticuoi.” ");
INSERT INTO pac_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Arnáq ndô cơt tarvớiq simớt parnai Yê-su khoiq tông te nsuoi, na mmo án cóq cuchet. ");
INSERT INTO pac_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Vít ngki Phi-lat mot lieh tớq dúng, alứng án arô Yê-su. Dyơ án plốh Yê-su idô: “Mái la lư puo top Isa-ra-el lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yê-su plốh lieh án idô: “Parnai ndô mái chóng ính plốh, lớiq la bôn ticuoi tông dyôn mái chom te cư?” ");
INSERT INTO pac_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Phi-lat ôi lieh idô: “Imo têq cư chom! Cư tới ticuoi Isa-ra-el. Ticuoi mái alứng ticuoi sút top teng rit sang tớq cruong mái dông mái nga cư. Amớh táp mái táq luaih?” ");
INSERT INTO pac_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yê-su ôi lieh idô: “Cư tới ticuoi sút tớq pang ndô. Khán cư cơt sút tớq pang ndô, ngki ticuoi prái cư lư chíl lieh top Isa-ra-el, lớiq dyôn nha-án cŏp cư. Ma chức cư tới tớq pang ndô.” ");
INSERT INTO pac_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Phi-lat plốh lieh: “Khán iki, mái la puo lớiq?” Yê-su ôi: “Piaiq arớq mái tông, cư la puo. Cư siar cơt ticuoi tớq pang ndô co ính cato te callong lư. Ticuoi mmo bôn callong lư tớq mít án, ticuoi ngki lư cammáng parnai cư.” ");
INSERT INTO pac_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Phi-lat plốh sa: “Amớh la callong lư?” Cua Phi-lat tông iki, án ngốh te dúng, án pôq lieh nga ticuoi Isa-ra-el. Alứng án tông nha-án idô: “Cư lớiq tumúh mui callong luaih amớh te ticuoi ngki. ");
INSERT INTO pac_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma tớq ingái inha cha ayư Ingái Ngốh, inha bôn rit têq rêh munáq te top ticuoi tôt dyôn cư taláh. Iki inha ính cư taláh puo top Isa-ra-el lớiq?” ");
INSERT INTO pac_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nha-án ráp ngcang Phi-lat yứng lư idô: “Êq taláh án! Ma taláh Ba-raba!” (Ba-raba la munáq te top tarpíh ính cơt sút.) ");
INSERT INTO pac_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Cua ngki Phi-lat arô lieh Yê-su, dyơ án yua ngai prớih Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Top líng táq carvang tangháng alứng tapưng tớq plô Yê-su, alứng nha-án asứp Yê-su au thor ntứm eng. ");
INSERT INTO pac_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dyơ nha-án tớq tumán Yê-su alứng ayê án idô: “Cucúh ngai sasai puo Isa-ra-el!” Nha-án páh Yê-su hơ. ");
INSERT INTO pac_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Phi-lat ngốh sa nga ticuoi Isa-ra-el alứng tông nha-án idô: “Ndô! Cư dông án nga inha, dyôn inha chom arlớih, cư lớiq tumúh mui callong luaih amớh te án.” ");
INSERT INTO pac_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ndóng Yê-su ngốh, án yôl pưng carvang tangháng alứng sứp au thor eng. Phi-lat tông ticuoi clứng idô: “Inha me nga ticuoi ndô!” ");
INSERT INTO pac_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tư máh ticuoi sút top teng rit sang alứng tampeng te Dúng Sang Pưt hôm Yê-su, nha-án tông yứng lư idô: “Téh án tớq along calláng! Téh án tớq along calláng!” Ma Phi-lat tông ada nha-án idô: “Áu inha dông alứng téh án tớq along calláng! Ma cư lớiq tumúh mui callong luaih amớh te án.” ");
INSERT INTO pac_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Top Isa-ra-el ôi lieh idô: “Veng phep rit he, án cóq cuchet, co án khoiq tông, án la Acái Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tư Phi-lat sáng parnai ngki, án sáng crŏ́q lư. ");
INSERT INTO pac_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dyơ án mot lieh tớq callúng ntúq tarsưq, alứng án plốh Yê-su idô: “Te mmo mái tớq?” Ma Yê-su lớiq ôi amớh. ");
INSERT INTO pac_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Phi-lat tông idô: “Imo mái lớiq ôi cư? Mái chom lớiq, cư bôn chức têq taláh mái, lớiq la téh mái tớq along calláng?” ");
INSERT INTO pac_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yê-su ôi án idô: “Khán Yang Arbang-pilŏ́ng lớiq dyôn chức a mái, ngki mái lớiq têq táq amớh ada cư. Iki, ticuoi ndon dông cư tớq nga mái, án ngki bôn luaih ntáng hơn te mái.” ");
INSERT INTO pac_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tớq Phi-lat sáng iki, án suo ngê ính taláh Yê-su. Ma ticuoi Isa-ra-el tông yứng lư sa idô: “Khán avốq taláh ticuoi ndô, avốq lớiq têq artoi nnáng alứng puo Rô-ma. Ticuoi mmo ngin án la puo, la arớq án chíl puo Rô-ma dyơ.” ");
INSERT INTO pac_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tư Phi-lat sáng iki, án dông angốh Yê-su, alứng án ticu tớq kichơng báq tarsưq. Kichơng ngki át tớq ntúq ngai dŏq Ngcưm Búl, ma tớq cang Isa-ra-el dŏq Ca-batha. ");
INSERT INTO pac_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ndóng ngki mát pandang tumán tứng, tớq ingái ngki ticuoi Isa-ra-el thuan cha ayư Ingái Ngốh. Phi-lat tông ticuoi Isa-ra-el idô: “Ndô la puo inha!” ");
INSERT INTO pac_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma máh ticuoi ngki tông yứng lư idô: “He lớiq ính án! Téh viang án tớq along calláng!” Phi-lat plốh sa nha-án: “Inha ính cư téh puo inha tớq along calláng lớiq?” Ma máh ticuoi sút top teng rit sang ôi idô: “Án tới puo he! Puo he la nưm puo Rô-ma sớng!” ");
INSERT INTO pac_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Cua ngki Phi-lat mŏp Yê-su nga nha-án, dyôn nha-án dông téh án tớq along calláng. Dyơ nha-án dông angốh án te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ndóng nha-án dông angốh Yê-su te vel, nha-án yua Yê-su dual bôm along calláng án nga ntúq ngai dŏq Ntúq Nghang Cudoh Plô. Tớq cang Isa-ra-el dŏq ntúq ngki Cô-cô-tha. ");
INSERT INTO pac_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tớq ntúq ngki ngai téh Yê-su tớq along calláng. Ma bôn bar náq cannŏ́h loi ngai téh ngki tưi, munáq pa atớm, munáq pa aviar Yê-su. Yê-su át pandi bar náq ngki. ");
INSERT INTO pac_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Phi-lat taran tớq mui mêng pan idô: “YÊ-SU TE VEL NA-SARET. ÁN LA PUO TICUOI ISA-RA-EL.” Dyơ án téh clưap mêng pang ngki tớq along calláng Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bôn a-ưi náq ticuoi Isa-ra-el dŏc chưq tớq mêng ngki, co ntúq nha-án cachet Yê-su la tumán vel. Alứng ngai khoiq taran tớq mêng pan tớq pe cang: Cang Isa-ra-el, cang Rô-ma, alứng cang Créc. ");
INSERT INTO pac_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ma máh ticuoi sút top teng rit sang tông Phi-lat idô: “Avốq êq taran ‘án la Puo Ticuoi Isa-ra-el.’ Piaiq lư la avốq taran ‘án chóng ngin án la puo ticuoi Isa-ra-el.’” ");
INSERT INTO pac_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ma Phi-lat ôi nha-án idô: “Cư khoiq taran cua dyơ te parnai ndô. Cư lớiq ính atức nnáng.” ");
INSERT INTO pac_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Vít máh líng téh Yê-su tớq along calláng, nha-án ial tampớc Yê-su alứng mpô cơt puan phê, munáq mui phê. Nha-án ial au thor Yê-su hơ. Au ndô ngai tanh mui sáiq sớng, alứng lớiq bôn ntih te tanieng díh tadưp. ");
INSERT INTO pac_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Dyơ top líng ngki, munáq tông munáq idô: “He êq haq au thor ndô. He séng anhúq au ndô. Án mmo bôn la dyơ.” Iki cơt tarvớiq simớt parnai Yang Arbang-pilŏ́ng khoiq tông te inớh idô: “Nha-án mpô tampớc cư báq tớc, alứng séng anhúq au thor cư.” Iki la arnáq máh líng ngki táq. ");
INSERT INTO pac_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Máh cán ndon tayứng tumán along calláng Yê-su, la a-i Yê-su, i-két Yê-su, Mari campái Clô-ba, alứng Mari te vel Mac-dala. ");
INSERT INTO pac_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tư Yê-su hôm a-i án alứng cư ndon artoi lư alứng án, át tayứng tumán ngki, dyơ án tông a-i án idô: “A-i ơi! Ndô la acái mái.” ");
INSERT INTO pac_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cua ngki Yê-su tông cư idô: “Ndô la a-i mái.” Vít ngki cư dông a-i Yê-su pôq át tớq dúng cư. ");
INSERT INTO pac_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Vít ngki Yê-su tông idô: “Cư sáng hál lư dơq.” Án chom khoiq cua dyơ máh arnáq ngai taran tông te án tớq tám uráq Yang Arbang-pilŏ́ng te inớh. Co iki án tông parnai ngki dyôn cơt tarvớiq simớt tớq tám uráq. ");
INSERT INTO pac_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tớq ntúq ngki bôn mui lám yáng sieu adyóq. Nha-án ial mui cúc nsol talứm tớq sieu, dyơ chóq tớq callêh, alứng pidáng nga ngcang Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cua Yê-su kidyớp, án tông idô: “Arnáq cư khoiq cua nhéq dyơ!” Vít ngki Yê-su tangngop plô asiar, dyơ pít tarngứh. ");
INSERT INTO pac_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ingái ngki la ingái top Isa-ra-el thuan ính cha bui tớq ingái parnô, la Ingái Angô pưt lư. Iki top Isa-ra-el lớiq ính dŏq cumuiq tớq along calláng tớq Ingái Angô; khán nha-án táq iki, ngki tán. Iki nha-án seq Phi-lat yua ngai pieih dyưng ticuoi ndon ngai téh dyôn ticớih, alứng yua ngai talíh asiar cumuiq te along calláng. ");
INSERT INTO pac_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Iki máh líng tớq pieih dyưng bar náq ticuoi ndon ngai téh munơi alứng Yê-su dyôn ticớih. ");
INSERT INTO pac_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma tư nha-án tớq nga Yê-su, nha-án hôm Yê-su khoiq cuchet. Iki nha-án lớiq pieih dyưng Yê-su dyôn ticớih. ");
INSERT INTO pac_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma bôn munáq líng ial coih chớt avếh Yê-su. Dyơ aham alứng dơq ngốh te pangha ngki. ");
INSERT INTO pac_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Cư khoiq hôm máh arnáq ndô. Cư táp táq-ntêr lieh te arnáq ndô, alứng máh parnai cư tông la callong lư. Cư chom arlớih cư tông callong lư, alứng cư tông iki dyôn inha têq tin. ");
INSERT INTO pac_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nhéq máh arnáq ndô tớq dyôn cơt tarvớiq simớt tám uráq Yang Arbang-pilŏ́ng khoiq tông te inớh, idô: “Nghang án mui ntráih la lớiq bôn ticớih.” ");
INSERT INTO pac_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Alứng bôn ntúq cannŏ́h loi tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông idô: “Nha-án tingưi me nga án ndon nha-án khoiq chớt.” ");
INSERT INTO pac_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cua ngki Yô-sep te vel Ari-mathê seq cumuiq Yê-su te Phi-lat. Yô-sep la ticuoi veng tapun Yê-su tưi, ma án veng tapun clôp, co án adáh top Isa-ra-el. Phi-lat dyôn án ial, dyơ án pôq ial cumuiq Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Bôn díh Ni-cudem pôq alứng án. Ni-cudem la ticuoi ndon pôq alang Yê-su mui idáu nsuoi. Án dông crơng thum carchúc te bar nốh along. Crơng thum ngki ntáng pe chít la pe kilô. ");
INSERT INTO pac_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nha-án bar náq ial cumuiq Yê-su, dyơ sŏm tớq prới. Nha-án cacháq crơng thum tớq prới clŏq ngki veng rit top Isa-ra-el báq thuan nsuoi dông tứp cumuiq. ");
INSERT INTO pac_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tumán ntúq ngai cachet Yê-su bôn mui nưong. Tớq nưong ngki bôn mui lám ping tamme, ngai var dŏq ien ính tứp cumuiq. ");
INSERT INTO pac_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Co ingái ngki la ingái thuan cha bui, alứng ping ngki tumán ntúq ngai cachet Yê-su, iki nha-án tứp Yê-su tớq ping ngki. ");
INSERT INTO pac_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ingái mui tớq tún ngki, yôl cláih lư, pilŏ́ng ang mbơiq sưm-turưm, Mari te vel Mac-dala pôq nga ping Yê-su. Án hôm arớq khoiq ngai vih búl pưt te ngáh ping. ");
INSERT INTO pac_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Iki án lúh chô tông Si-môn Phi-er alứng cư. Mari tông he idô: “Khoiq ngai ial dyơ Ưlla he te ping, alứng lớiq chom ntúq mmo ngai dŏq án.” ");
INSERT INTO pac_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Iki Phi-er alứng cư pôq nga ping. ");
INSERT INTO pac_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","He talúh, ma cư talúh chái hơn te Phi-er. Iki cư tớq nsuoi nga ping. ");
INSERT INTO pac_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Cư lileng tớq ping, cư hôm nưm prới mat sớng. Ma cư lớiq bôn mot tớq callúng ping. ");
INSERT INTO pac_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tư Si-môn Phi-er tớq, án mot táp tớq callúng ping. Án hôm nưm prới mat sớng. ");
INSERT INTO pac_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Alứng án hôm prới ngai pul plô Yê-su khoiq ngai láp alứng ngai dŏq mmar te prới ngai sŏm cháq Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vít ngki cư mot tưi. Cư hôm alứng cư náp lư. ");
INSERT INTO pac_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ndóng ngki he iyốh chom arlớih te parnai Yang Arbang-pilŏ́ng khoiq tông te Yê-su cóq cuchet alứng yôr tumống lieh. ");
INSERT INTO pac_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Vít ngki he bar náq chô lieh nga dúng. ");
INSERT INTO pac_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma Mari yôl tayứng nhiem tớq culái tieh ping. Ndóng án nhiem, án tangngop lileng tớq ping. ");
INSERT INTO pac_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Án hôm bar náq tarneng Yang Arbang-pilŏ́ng sứp au clŏq, alứng ticu ntúq ngai dŏq cumuiq Yê-su te nsuoi. Munáq ticu pa plô, munáq ticu pa dyưng. ");
INSERT INTO pac_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nha-án plốh Mari idô: “Ama ơi! Mái nhiem táq mmớh?” Mari ôi: “Khoiq ngai ial Ưlla cư, alứng cư lớiq chom tumo ngai dông dŏq án.” ");
INSERT INTO pac_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cua ngki Mari tilêq alứng án hôm Yê-su tayứng tớq lamloi án, ma án lớiq acớl Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yê-su tông án idô: “Ama ơi! Amớh mái nhiem? Nnáu mái suo?” Mari parngíh Yê-su la ticuoi asa nưong. Iki án ôi idô: “Avốq ơi! Khán avốq dông angốh cumuiq ngki, seq avốq tông dyôn cư chom ntúq mmo avốq dŏq. Cư ính pôq ial án.” ");
INSERT INTO pac_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yê-su tông án idô: “Mari.” Mari píh me nga Yê-su, alứng án tông idô: “Ra-buni ơi!” (Parnai ‘ra-buni’ titoiq lieh la ‘thới’.) ");
INSERT INTO pac_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yê-su tông Mari idô: “Êq capơiq cư, co cư iyốh sớr nga A-ám cư. Ma hoi-ndô mái pôq nga em ai cư, alứng tông nha-án idô: ‘Cư sớr nga A-ám cư alứng A-ám inha. Cư sớr nga Yang Arbang-pilŏ́ng cư alứng Yang Arbang-pilŏ́ng inha.’” ");
INSERT INTO pac_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari te vel Mac-dala chô nga top rian te Yê-su. Án tông nha-án idô: “Cư khoiq hôm dyơ Ưlla he.” Alứng án tông nha-án te máh parnai Yê-su khoiq patáp án. ");
INSERT INTO pac_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ingái mui tớq tún ngki, tớq ibư top rian te Yê-su rum mui ntúq. Nha-án clieng callống, co nha-án adáh ticuoi Isa-ra-el. Dyơ Yê-su tớq tayứng pandi nha-án. Án tông idô: “Inha át ien ŏ.” ");
INSERT INTO pac_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cua Yê-su tông iki, án apáh dyôn nha-án me allang ati alứng avếh án. Top rian te án sáng ơn lư, co nha-án bôn hôm lieh Ưlla nha-án. ");
INSERT INTO pac_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yê-su tông sa idô: “Inha át ien ŏ. A-ám cư khoiq yua cư pôq; muchứng ngki tưi cư yua inha pôq.” ");
INSERT INTO pac_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Cua Yê-su tông iki, án cahơ ada nha-án, alứng án tông idô: “Inha ráp ial Arvai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Khán inha táh luaih ngai, luaih ngki lư pít. Alứng khán inha lớiq táh luaih ngai, luaih ngki lư yôl.” ");
INSERT INTO pac_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thô-mat, ngai dŏq án Di-dim hơ, án la te top mui chít la bar náq tưi, ma án lớiq át alứng top ngki tớq ingái Yê-su tớq chư nsuoi. ");
INSERT INTO pac_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tư nha-án tông Thô-mat nha-án khoiq hôm Ưlla nha-án, ma Thô-mat lớiq tin parnai nha-án. Án tông idô: “Khán cư lớiq hôm callêr díng tớq allang ati án, alứng khán cư lớiq bôn capơiq tarrô ati cư tớq callêr ngki, alứng khán ati cư lớiq bôn capơiq tớq avếh án, cư lư lớiq tin.” ");
INSERT INTO pac_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Vít ticol ingái, top rian te Yê-su át tớq dúng ngki sa. Ma chư ndô Thô-mat át alứng nha-án. Nha-án clieng sa ngáh callống. Ma Yê-su tớq tayứng sa pandi nha-án. Yê-su tông idô: “Inha át ien ŏ.” ");
INSERT INTO pac_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Cua ngki Yê-su tông Thô-mat idô: “Ndô la allang ati cư. Mái angốh tarrô ati mái, dyơ capơiq tớq allang ati cư! Alứng mái angốh ati mái, dyơ capơiq tớq avếh cư. Mái êq cớng ngan nnáng. Ma cóq mái tin!” ");
INSERT INTO pac_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thô-mat ôi táp: “Ưlla cư, alứng Yang Arbang-pilŏ́ng cư!” ");
INSERT INTO pac_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yê-su tông lieh Thô-mat idô: “Co mái bôn hôm cư, iki mái tin. Ma bún lư dyôn nha-án ndon lớiq nai hôm cư, ma tin cư.” ");
INSERT INTO pac_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yê-su táq a-ưi arnáq sileh chứng mát top veng tapun án, ma cư lớiq bôn taran nhéq máh nốh ngki tớq tám uráq ndô. ");
INSERT INTO pac_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma máh callong ndon cư khoiq taran tớq tám uráq ndô, cư taran dyôn inha tin Yê-su la Crit, la Acái Yang Arbang-pilŏ́ng. Khán inha tin iki, inha lư bôn tumống níc-níc co nhơ te nốh án. ");
INSERT INTO pac_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Vít te ngki Yê-su tớq nga top rian te án mui chư loi nga tor clóng Tubê-riet. Máh nốh nha-án la idô: ");
INSERT INTO pac_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Si-môn Phi-er, Thô-mat (ngai dŏq Di-dim hơ), alứng Na-thanial te vel Cana vúng Ca-lilê, he bar náq la acái conh Sê-badê, alứng bar náq loi la top rian te Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Si-môn Phi-er tông nha-án idô: “Cư pôq lai mben suo buaiq.” Dyơ nha-án tông idô: “He pôq alứng mái tưi.” Iki nhéq náq he sớr tớq tuoc. He suo nhéq mui idáu, ma ớq bôn díh mui lám buaiq. ");
INSERT INTO pac_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ang iláih mbơiq sưm-turưm, Yê-su át tumán tor dơq ngki, ma he lớiq chom án la Yê-su. ");
INSERT INTO pac_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yê-su tubau he idô: “Yớu ơi! Inha bôn buaiq lớiq?” He ôi: “Ớq díh mui lám.” ");
INSERT INTO pac_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yê-su tông loi: “Inha lai mben pa atớm loi, dyơ inha bôn buaiq.” Tư he táq arớq án yua, mben he chuot buaiq a-ưi lư. He lớiq rap lúq asớr mben tớq tuoc. ");
INSERT INTO pac_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dyơ cư ndon artoi lư alứng Yê-su, tông Phi-er idô: “Án la Ưlla he!” Tư Si-môn Phi-er sáng cư tông: “Án la Ưlla he,” iki Phi-er sứp táp au, co ndóng án ính táq arnáq án khoiq luaiq dŏq au. Cua ngki án póng tớq dơq. ");
INSERT INTO pac_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","He veng tatun Phi-er na tuoc. Alứng he lúq mben khoiq pớnh máng buaiq. He át yông te tor bôn sám mui culám cớt sớng. ");
INSERT INTO pac_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tư he tớq nga tor, he hôm uih carhông alứng bôn buaiq nha beng tớq tupéh. ");
INSERT INTO pac_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yê-su yua he idô: “Inha dông biq buaiq mbơiq chuot nga tudô.” ");
INSERT INTO pac_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dyơ Si-môn Phi-er pôq lúq táp mben nga tor. Mben ngki khoiq chuot máng buaiq; bôn buaiq pưt mui culám sông chít la pe lám, ma mben lớiq prúh. ");
INSERT INTO pac_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yê-su tông he idô: “Inha tớq cha avai.” Lớiq bôn nnáu te top rian te án dáh plốh án idô: “Mái la nnáu?” Co nhéq náq he khoiq chom dyơ án la Ưlla. ");
INSERT INTO pac_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iki án pôq ial beng; dyơ án avôi dyôn he cha, alứng án avôi buaiq hơ. ");
INSERT INTO pac_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Pe cantứq ndô dyơ Yê-su tumúh top rian te án, tớq vít án yôr tumống lieh te cuchet. ");
INSERT INTO pac_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cua cha, Yê-su plốh Si-môn Phi-er idô: “Si-môn acái Yô-na ơi! Mái amoih cư hơn nhéq te callong cannŏ́h lớiq?” Phi-er ôi: “Ơq. Ưlla chom dyơ cư amoih Ưlla.” Yê-su tông án idô: “Mái chiam cưu na cư nư.” ");
INSERT INTO pac_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mui chư loi Yê-su plốh Phi-er idô: “Si-môn acái Yô-na ơi! Lư mái amoih cư lớiq?” Phi-er ôi sa: “Ơq. Ưlla chom dyơ cư amoih Ưlla.” Yê-su tông án sa: “Mái bán kiaq pannán cưu na cư nư.” ");
INSERT INTO pac_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mui chư loi, Yê-su plốh sa Phi-er: “Si-môn acái Yô-na, ơi! Lư mái amoih cư lớiq?” Iki Phi-er sáng anguaq, co Yê-su plốh án khoiq pe chư dyơ, idô: “Lư mái amoih cư lớiq?” Dyơ Phi-er ôi sa: “Ưlla ơi! Ưlla khoiq chom cứp nốh dyơ. Ưlla chom cư amoih Ưlla.” Dyơ Yê-su tông án sa: “Cóq mái chiam pannán cưu na cư nư. ");
INSERT INTO pac_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cư tông mái arlớih lư, ndóng mái yôl bánh, mái têq ial cannính mái bôm. Mái ính pôq tumo, ngki mái pôq. Ma urớh, tớq mái ieuq, mái yáng ati mái, alứng ngai ính chóq tarving mái. Dyơ ngai dông mái nga ntúq mái lớiq ính pôq.” ");
INSERT INTO pac_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yê-su tông iki, án tông na mmo Phi-er cuchet. Urớh máh ticuoi lư hôm Phi-er cuchet arớq iki, dyơ nha-án ayô Yang Arbang-pilŏ́ng. Cua ngki Yê-su yua Phi-er idô: “Cóq mái veng tapun cư!” ");
INSERT INTO pac_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phi-er tilêq nga lamloi. Án hôm cư ndon artoi lư alứng Yê-su, át tớq ngki tưi. Cư la ticuoi ndon át ting Yê-su ndóng he cha dôi pêl ibư. Cư táp khoiq plốh Yê-su, nnáu ính culieu án. ");
INSERT INTO pac_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tư Phi-er hôm cư, án plốh Yê-su idô: “Ưlla ơi! Án ndô cuchet na amớh?” ");
INSERT INTO pac_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yê-su ôi Phi-er idô: “Khán cư ính án tumống tingôi cư tớq lieh nga tudô, mái tituaiq táq amớh? Ma mái, cóq mái veng tapun cư.” ");
INSERT INTO pac_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Cua Yê-su tông iki, parnai ngki cơt rŏ́h mưt-mư nga ticuoi ndon tin Yê-su. Iki nha-án parngíh Yê-su tông cư lớiq cuchet nnáng. Ma Yê-su lớiq bôn tông cư lớiq bôn cuchet. Yê-su tông la idô: “Khán cư ính án tumống tingôi cư tớq lieh nga tudô, mái tituaiq táq amớh?” ");
INSERT INTO pac_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","To cư táp la ticuoi te top rian te Yê-su, ndon tông máh nốh ndô, alứng cư khoiq taran máh nốh ndô tưi. Inha têq náp ial, co máh parnai ndô la parnai lư. ");
INSERT INTO pac_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yôl bôn a-ưi arnáq loi Yê-su khoiq táq. Cư parngíh, khán ngai taran nhéq cứp nốh ngki, chôp cúc cuteq ndô la lớiq khám ntúq dyôn dŏq máh tám uráq ngki.");
INSERT INTO pac_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Cư la Luca cơiq uráq ndô dyôn yớu cư, Theu-phulơ. Te nsuoi cư khoiq taran mui pứng uráq dyôn mái chom arlớih arlêng te máh arnáq Yê-su khoiq táq. Tớq uráq ngki cư tông nhéq te arnáq Yê-su khoiq táq alứng máh parnai án khoiq cato te nsuoi, ndóng án iyốh sớr nga pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nsuoi án ính sớr, Arvai Yang Arbang-pilŏ́ng dyôn án patáp top nha-án ndon án khoiq rêh cơt top dyưng ati án, dyôn nha-án chom amớh nha-án cóq táq. ");
INSERT INTO pac_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yê-su khoiq tumúh a-ưi nốh dieiq arức. Vít án cuchet, án tumống lieh alứng án tớq nga top rian te án. Ndóng ngki án táq a-ưi tíc dyôn nha-án chom arlớih arlêng, án lư tumống lieh. Án át alứng top rian te án nhéq puan chít ingái puan chít idáu, alứng cato nha-án te arnáq Yang Arbang-pilŏ́ng cơt sút. ");
INSERT INTO pac_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bôn mui chư, ndóng Yê-su át rum alứng top rian te án, án patáp nha-án idô: “Inha êq ngốh iyốh te vel Yaru-salem. Ma inha át pớn dyôn tingôi tớq Arvai Yang Arbang-pilŏ́ng ndon A-ám cư khoiq ưq ính dyôn inha, arớq cư khoiq tông inha te nsuoi dyơ. ");
INSERT INTO pac_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yon khoiq táq tíc na dơq dyôn inha la na dơq sớng, ma lớiq dưnh nnáng Arvai Yang Arbang-pilŏ́ng lư tớq, alứng án mot át tớq mít cannính inha. Ndô la inha ráp tíc na Arvai Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ndóng top veng tapun Yê-su rum alứng án, nha-án plốh án idô: “Hoi-ndô Ưlla ính táq dyôn cruong Isa-ra-el cơt sút bôm lớiq?” ");
INSERT INTO pac_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yê-su ôi nha-án idô: “Inha lớiq túh cóq chom te arnáq ndô. Máh arnáq ngki nưm Yang Arbang-pilŏ́ng táp chom, co án táp anát máh arnáq ngki dyôn cơt chô mát. ");
INSERT INTO pac_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma tư Arvai Yang Arbang-pilŏ́ng mot át tớq mít cannính inha, án lư dyôn inha rap pôq cato te cư dyôn nhéq tưh ticuoi chom. Urớh inha bôn cato te cư tớq vel pưt Yaru-salem, vúng Yudê, vúng Sa-mari, alứng cứp cruong pưn pilŏ́ng crôp ndô.” ");
INSERT INTO pac_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cua Yê-su tông iki, dyơ Yang Arbang-pilŏ́ng táq dyôn án yưr sớr nga pilŏ́ng, alứng bôn tulúc catáng viang cháq án. Nha-án ndon át tớq tadưp, lớiq hôm nnáng án. ");
INSERT INTO pac_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tư Yê-su sớr nga pilŏ́ng, nha-án át tingưi níc. Ndóng ngki táp bôn bar náq conh sứp au clŏq át tumán top nha-án, ");
INSERT INTO pac_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","alứng bar náq ngki tông nha-án idô: “Máh ticuoi te vúng Ca-lilê ơi! Imo inha át tayứng ntúq ndô alứng me níc nga pilŏ́ng? Yê-su ndon inha hôm sớr nga pilŏ́ng, urớh án siar lieh nga cúc cuteq ndô, muchứng inha khoiq hôm án sớr hoi-ndô tưi.” ");
INSERT INTO pac_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tư top veng tapun Yê-su sáng parnai ngki, nha-án siar te king O-li-vê alứng chô lieh nga vel Yaru-salem. King ndô yông te vel Yaru-salem sám mui ki-lô-met. ");
INSERT INTO pac_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nha-án pôq nga dúng nha-án báq rum te nling, alứng nha-án sớr tớq trơn bar, mot át tớq mui callúng. Máh ticuoi rum tớq dúng ngki bôn idô: Phi-er, Yon, Yacơ, Anrê, Phi-lip, Thô-mat, Batê-lami, Mathie, Yacơ acái conh Al-phê, Si-môn Sê-lôt, alứng Yuda acái conh Yacơ. ");
INSERT INTO pac_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nhéq náq nha-án báq rum alứng sŏ́ng cớu mui mít mui cannính tớq ntúq ngki. Bôn máh ticuoi cán, díh Mari a-i Yê-su, alứng máh a-em conh Yê-su hơ át rum ngki. ");
INSERT INTO pac_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bôn mui ingái tatun, Phi-er yôr tayứng ính tông top tin Yê-su ndon át rum ngki. Top nha-án bôn sám mui culám bar chít náq. Phi-er tông idô: ");
INSERT INTO pac_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nhéq máh em ai em ơi, ơi! Máh parnai tớq tám uráq Yang Arbang-pilŏ́ng khoiq tông te inớh, he hôm lư cơt tarpiaiq te arnáq Yuda I-cari-ôt khoiq táq. Yuda táq arớq Arvai Yang Arbang-pilŏ́ng dyôn Davit tông acớiq te Yuda dông ticuoi pôq cŏp Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Án la lư te top he alứng táq arnáq muchứng he tưi. ");
INSERT INTO pac_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ma án ial práq ngai chang, dyơ án ayông carna dyôn ngai cŏp Yê-su. Cua ngki án pôq plới mui tám cuteq, ma tatun án dyáq. Pallúng án pôih alứng pidŏ́h, dyơ roiq án lalưai culái tieh. ");
INSERT INTO pac_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tư máh ticuoi át tớq vel Yaru-salem sáng te arnáq ngki, nha-án anốh ntúq ngki la Hakel-dama. Hakel-dama titoiq lieh la ‘Ntúq cuteq bôn aham ticuoi’. ");
INSERT INTO pac_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nhéq nốh ndô puo Davit khoiq tông tớq tám uráq Parnai Cứh Ayô idô: ‘Seq inha táq dyôn dúng án cơt dúng arngol, alứng lớiq bôn ngai át nnáng tớq dúng ngki.’ Alứng Davit tông mui parnai loi tớq ntúq ngki idô: ‘Dyôn ticuoi cannŏ́h loi táq tang arnáq án táq.’” ");
INSERT INTO pac_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Phi-er tông sa idô: “Tớq top he cóq bôn lieh munáq dyôn táq arnáq alứng he. Cóq he rêh munáq ndon át alứng he te ingái Yon táq tíc na dơq dyôn Yê-su tingôi ingái Yang Arbang-pilŏ́ng asớr án nga pilŏ́ng. Cóq munáq ngki khoiq hôm Yê-su cuchet alứng tumống lieh, dŏq têq án cato munơi alứng he dyôn ticuoi cannŏ́h chom.” ");
INSERT INTO pac_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iki nha-án angốh bar náq ticuoi, ma dyôn rêh ial nưm munáq sớng. Nốh bar náq ngki la Mathiet alứng Yô-sep. Yô-sep ngai dŏq án Ba-saba lớiq la Yutu. ");
INSERT INTO pac_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Dyơ top nha-án cớu idô: “Ưlla he ơi! Inha chom cứp callong tớq mít cannính ticuoi. Ưlla ơi, he seq inha apáh dyôn he chom ticuoi mmo te bar náq ndô inha ính rêh dyôn cơt dyưng ati inha cláp Yuda. Co Yuda khoiq táh arnáq ndô, dyơ án pôq át tớq ntúq ticuoi lớiq ŏ loi.” ");
INSERT INTO pac_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Cua nha-án cớu, dyơ nha-án séng, co ính rêh munáq te bar náq ngki. Dyơ piaiq Mathiet. Iki Mathiet mot táq arnáq munơi alứng top mui chít la mui náq. Dyơ ngai dŏq top nha-án la mui chít la bar náq top dyưng ati Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tớq ingái top Isa-ra-el cha bui Nhéq Ingái Apot, top veng tapun Yê-su pôq rum mui ntúq. ");
INSERT INTO pac_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ndóng nha-án rum ticớr sớng bôn sieng te pilŏ́ng arớq sieng cuyiel hớp lư. Sieng ndô vava chôp dúng nha-án át. ");
INSERT INTO pac_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nha-án hôm pla uih cơt arớq ntaq, dyơ paryáh alứng bôt tớq cháq cứp náq ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dyơ Arvai Yang Arbang-pilŏ́ng mot cơt sút tớq mít nha-án. Alứng nha-án mbơiq táq-ntêr tớq a-ưi cang, co Arvai Yang Arbang-pilŏ́ng dyôn nha-án táq-ntêr. ");
INSERT INTO pac_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ingái ngki tớq vel Yaru-salem bôn ticuoi Isa-ra-el te cứp cruong tớq rum. Nha-án veng phep rit Yang Arbang-pilŏ́ng khớm lư. ");
INSERT INTO pac_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tư nha-án sáng sieng ngki, iki nha-án tớq rum nga dúng top veng Yê-su át. Cứp náq ticuoi mmar sáng ngai táq-ntêr tớq cang nha-án bôm; iki nha-án sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nha-án sáng sileh lư, alứng nha-án tông idô: “Nhéq máh ticuoi ndon táq-ntêr la ticuoi Ca-lilê, ");
INSERT INTO pac_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ma imo nha-án táq-ntêr tớq cang na he arlớih lư? ");
INSERT INTO pac_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","He la ticuoi te a-ưi cruong, la te cruong Bathê, Mê-die, E-lam, Mê-sapô-tamie, Yudê, Cap-badôc, Pôn-tu, Asie, ");
INSERT INTO pac_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phu-rayie, Bam-phuli, Ê-yip-tô, alứng Li-bie tumán Si-rên. Alứng bôn ticuoi tumoi te cruong Rô-ma hơ. ");
INSERT INTO pac_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mui phê te top he la lư ticuoi Isa-ra-el. Mui phê loi la ticuoi te top cannŏ́h ndon sŏ́ng soi phep rit Isa-ra-el. Mui phê la ticuoi Crêt, alứng Arap. He la ticuoi te ndái cruong, ma he sáng nha-án cato tớq cang he te máh arnáq pưt ndon Yang Arbang-pilŏ́ng khoiq táq.” ");
INSERT INTO pac_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iki nhéq máh nha-án ticớr alứng sáng dut lư. Dyơ munáq plốh munáq: “Amớh táp arnáq ndô?” ");
INSERT INTO pac_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma bôn máh ticuoi ayê tar-ac tông idô: “Nha-án bol sieu.” ");
INSERT INTO pac_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dyơ Phi-er alứng mui chít la mui náq top án, yôr tayứng. Phi-er tông ticuoi clứng ngki yứng lư idô: “Ticuoi Isa-ra-el alứng nhéq máh inha ndon át tớq vel Yaru-salem ơi! Seq inha cammáng dyôn arlớih te parnai cư tông inha. ");
INSERT INTO pac_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inha parngíh he bol sieu. Ma he lớiq bôn bol sieu. Mbơiq pandang turống crêng, carlŏm mmo he bol? ");
INSERT INTO pac_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Máh parnai inha sáng hoi-ndô, la parnai Yô-el ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông te inớh idô: ");
INSERT INTO pac_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Yang Arbang-pilŏ́ng patáp ticuoi idô: Tư tumán ính tớq ingái talloiq, cư tốq Arvai cư dyôn nhéq tưh ticuoi. Dyơ máh acái cán, acái conh inha, têq cato parnai ŏ na cư. Máh ticuoi conh bánh te top inha, ngki cư tông na apáh baih. Alứng máh ticuoi conh ieuq te top inha, ngki cư tông na parnáu. ");
INSERT INTO pac_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tớq ingái ngki cư tốq Arvai cư ada máh ticuoi táq arnáq cư, díh conh díh cán, dyôn nha-án têq cato parnai ŏ te cư. ");
INSERT INTO pac_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cư lư táq tíc sileh tớq pilŏ́ng alứng tớq cuteq, la idô: Aham, uih chéh, alứng cunhieq. ");
INSERT INTO pac_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mát pandang cơt ngiau, alứng mát kisái cơt cusáu arớq aham. Tớq inha hôm tíc ndô, ngki inha chom khoiq tumán dyơ ingái pưt alứng ang-ưr la ingái Ưlla inha tớq. ");
INSERT INTO pac_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma cứp náq ticuoi ndon arô seq nhơ nốh Yang Arbang-pilŏ́ng, Yang Arbang-pilŏ́ng lư choi tamống ticuoi ngki.’” ");
INSERT INTO pac_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Dyơ Phi-er tông sa idô: “Ticuoi Isa-ra-el ơi! Seq inha cammáng parnai cư. Yê-su la ticuoi te vel Na-saret, ma Yang Arbang-pilŏ́ng dyôn án táq a-ưi arnáq sileh alứng máh tíc hơ, la dyôn inha chom arlớih lư án tớq te Yang Arbang-pilŏ́ng. Inha khoiq sáng dyơ te arnáq sileh alứng te tíc ndô. ");
INSERT INTO pac_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ma Yang Arbang-pilŏ́ng khoiq thuan arnáq ndô te nsuoi, dyôn inha têq táq ada Yê-su. Yang Arbang-pilŏ́ng khoiq chom te nsuoi, inha lư mŏp Yê-su nga ticuoi lớiq ŏ dyôn nha-án cachet án na téh tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ma Yang Arbang-pilŏ́ng dyôn Yê-su tumống lieh. Ndóng ngki arớq callong cuchet chóq Yê-su khớm lư, ma Yang Arbang-pilŏ́ng lếh Yê-su te callong cuchet. Án lớiq dyôn callong cuchet cơt sút Acái án. ");
INSERT INTO pac_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Puo Davit khoiq tông te inớh te máh arnáq ndô, idô: ‘Cư chom arlớih lư Yang Arbang-pilŏ́ng át níc alứng cư. Co án át alứng cư, iki lớiq bôn callong amớh têq catáng cư lớiq dyôn át vứng ŏ. ");
INSERT INTO pac_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Co iki cư sáng bui ơn lư, alứng tớq cư táq-ntêr la bôn máng callong bui sớng. Lớiq bôn amớh cháq cư cuchet. Ma cư chom arlớih arlêng lư, urớh cư bôn tumống lieh, ");
INSERT INTO pac_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","co Ưlla lớiq bôn táh cư dyôn át tớq ntúq ticuoi cuchet át. Ưlla lớiq dyôn án ndon práh ŏ cơt alíq nsốq. ");
INSERT INTO pac_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Inha khoiq turô dyôn cư chom carna pôq nga ntúq bôn tumống níc-níc. Chứng mát inha, mít cư sáng bui ơn lư.’” ");
INSERT INTO pac_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Dyơ Phi-er cato loi idô: “Em ai ơi! Cư ính tông dyôn inha chom arlớih lư te Davit achúc achiac he. Án khoiq cuchet alứng ngai tứp án tớq ping. Ping ngki yôl níc tingôi ingái ndô. ");
INSERT INTO pac_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ma Davit la ticuoi tang ngcang Yang Arbang-pilŏ́ng tưi. Davit chom arlớih arlêng Yang Arbang-pilŏ́ng khoiq ưq ada án, urớh bôn munáq te tŏ́ng toiq án bôn cơt puo cláp án. ");
INSERT INTO pac_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davit la pang nsuoi, ma Crit la pang tatun. Davit khoiq chom nsuoi te Crit cóq cuchet alứng tumống lieh. Davit chom arlớih lư arvai Yê-su lớiq át dưnh tớq ntúq ticuoi cuchet át, alứng cháq Yê-su lớiq alíq nsốq. ");
INSERT INTO pac_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Te callong Yê-su tumống lieh, mát he khoiq hôm dyơ. Co iki he têq tông dyôn inha chom arlớih lư. ");
INSERT INTO pac_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yang Arbang-pilŏ́ng dyôn Yê-su ticu pa atớm án. Iki Yang Arbang-pilŏ́ng táq tíc án amoih Yê-su clưi nhéq te cannŏ́h. Án dyôn Arvai án nga Yê-su arớq án khoiq ưq te nsuoi. Dyơ Yê-su cơiq Arvai Yang Arbang-pilŏ́ng dyôn át tớq pang ndô hoi-ngki. Iki arnáq te inha sáng alứng hôm hoi-ndô, la Arvai Yang Arbang-pilŏ́ng táp táq. ");
INSERT INTO pac_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Alứng máh parnai Davit cato, tới án tông te cháq án bôm sớr nga pilŏ́ng. Ma Davit tông idô: ‘Yang Arbang-pilŏ́ng tông Ưlla cư idô: Mái ticu pa atớm cư tingôi ingái mmo cư dyôn ticuoi picon mái, át tadưp allang dyưng mái, cơt sol mái.’” ");
INSERT INTO pac_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dyơ Phi-er cato loi idô: “Máh ticuoi Isa-ra-el ơi! Cư tông dyôn inha chom arlớih lư te callong ndô. Yê-su ndon inha khoiq téh tớq along calláng, lư án táp Yang Arbang-pilŏ́ng dyôn cơt Ưlla alứng Crit.” ");
INSERT INTO pac_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tư top nha-án sáng parnai ndô, nha-án sáng anguaq lư. Dyơ nha-án plốh Phi-er alứng top dyưng ati cannŏ́h idô: “Em ai ơi! Imo he cóq táq hoi-ndô?” ");
INSERT INTO pac_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phi-er ôi nha-án idô: “Cóq inha pien cơt mít tamme loi, alứng cóq inha ráp tíc na dơq nhơ nốh Yê-su Crit. Iki Yang Arbang-pilŏ́ng táh luaih inha, alứng Arvai Yang Arbang-pilŏ́ng át alứng inha hơ. ");
INSERT INTO pac_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yang Arbang-pilŏ́ng khoiq par-ưq ính dyôn Arvai án nga inha, dyôn díh nga acái acon inha alứng máh ticuoi te cruong cannŏ́h hơ. Yang Arbang-pilŏ́ng Ưlla he, án dyôn nhéq tưh ticuoi ndon án rêh bôn Arvai án.” ");
INSERT INTO pac_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Phi-er táq-ntêr a-ưi lư loi te arnáq Yê-su. Alứng án dyŏq nha-án idô: “Cóq inha táh nhéq máh arnáq saq, dyôn inha têq viar vít te callong dieiq arức ndon ính tớq nga tŏ́ng toiq ticuoi luaih.” ");
INSERT INTO pac_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bôn sám pe ngin náq ticuoi tin parnai Phi-er cato; alứng nha-án ráp tíc na dơq lớng, táq tíc nha-án tin Yê-su Crit. Iki nha-án sŏ́ng mui mít alứng top veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nha-án pôq rum níc alứng top dyưng ati Yê-su Crit. Nha-án rum cớu munơi, alứng péq beng cha ayư Yê-su khoiq cuchet tang nha-án. ");
INSERT INTO pac_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nhéq máh ticuoi sáng dut lư, alứng top dyưng ati Yê-su táq a-ưi arnáq sileh arớq Yang Arbang-pilŏ́ng dyôn nha-án táq. ");
INSERT INTO pac_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nhéq máh ticuoi tin cơt níc mui mít. Máh crơng nha-án bôn, nha-án sŏ́ng chúng munơi. ");
INSERT INTO pac_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nha-án táiq máh mun nha-án; dyơ pachúng práq mui ntúq. Ticuoi mmo ớq, nha-án choi ticuoi ngki. ");
INSERT INTO pac_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cứp ingái nha-án pôq rum tớq ngcưm Dúng Sang Pưt. Alứng nha-án cha bui munơi hơ, mui ingái tớq dúng án ndô, mui ingái loi tớq dúng án ngki. Nha-án át bui êm lư, co nha-án bôn mui mít mui lom. ");
INSERT INTO pac_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nha-án báq lư ayô Yang Arbang-pilŏ́ng. Nhéq máh ticuoi tớq vel pưt Yaru-salem ayô top tin Yê-su. Alứng cứp ingái Yang Arbang-pilŏ́ng dyôn ticuoi mot tin Yê-su, dyơ cơt mui top alứng top tin Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cứp ingái tớq pandang viet, top veng tapun Yê-su pôq rum cớu tớq Dúng Sang Pưt top Isa-ra-el. Bôn mui ingái, Phi-er alứng Yon pôq cớu nga ntúq ngki tưi. ");
INSERT INTO pac_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nha-án tumán ính tớq ngáh callống ngai dŏq Callống Amaiq. Tumán callống ngki, nha-án hôm ticuoi conh dyuat ticu. Án dyuat te a-i án carnian án. Cứp ingái ngai dông dŏq án tớq ntúq ngki, dyôn án seq práq te ticuoi ndon mot na ngáh callống ngki. ");
INSERT INTO pac_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tư ticuoi dyuat hôm Phi-er alứng Yon ính mot tớq dúng sang, án seq práq te nha-án. ");
INSERT INTO pac_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iki Phi-er alứng Yon me clớn ada án, dyơ Phi-er tông án idô: “Mái me nga he ndô.” ");
INSERT INTO pac_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iki ticuoi dyuat me nga nha-án, alứng án parngíh nha-án ính dyôn án práq. ");
INSERT INTO pac_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma Phi-er tông án idô: “Práq dyeng cư lớiq bôn tưi. Ma nốh amớh cư bôn, cư ính choi mái ngki. Nhơ nốh Yê-su Crit te vel Na-saret, cư yua mái yôr tayứng alứng pôq!” ");
INSERT INTO pac_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Phi-er tec ati atớm ticuoi dyuat dyôn yôr tayứng. Ndóng ngki táp dyưng án cơt bánh. ");
INSERT INTO pac_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yóiq táp án yôr. Dyơ án mot tớq ngcưm dúng sang munơi alứng Phi-er nha Yon. Ntơnh án pôq, ntơnh án ơn canchơl ayô Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nhéq máh ticuoi tớq dúng sang hôm án ticaq pôq alứng ayô Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Alứng nha-án acớl án la ticuoi báq côn seq práq tumán ngáh Callống Amaiq. Iki nha-án sáng dut lư tư nha-án hôm dyưng án cơt ŏ. ");
INSERT INTO pac_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tớq dúng sang ngki bôn mui lám ntrôn ngai dŏq Ntrôn Sa-lamôn. Phi-er alứng Yon át tớq ntrôn ngki, díh án ndon dyưng cơt ŏ lieh hơ át ngki. Bôn clứng ticuoi talúh parlŏ́ng nga ntúq nha-án át, alứng máh ticuoi ngki sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tư Phi-er hôm ticuoi clứng tớq, dyơ án plốh nha-án idô: “Top Isa-ra-el ơi! Imo inha sáng dut lư te arnáq ndô? Imo inha me clớn níc nga he? Inha parngíh he bôn chức têq táq bôm arnáq ndô lớiq? Alứng inha parngíh he ŏ hơn te ticuoi cannŏ́h chứng mát Yang Arbang-pilŏ́ng, lớiq? Tới iki! ");
INSERT INTO pac_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yang Arbang-pilŏ́ng ndon achúc achiac he A-praham, I-sac, alứng Yacốp sang, dyôn Yê-su la ticuoi táq arnáq án bôn chức ang-ưr lư. Ma inha mŏp Yê-su nga Phi-lat ticuoi sút tớq cruong ndô. Tớq Phi-lat ính taláh Yê-su, inha lớiq dyôn án taláh. ");
INSERT INTO pac_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Inha calôih Yê-su la ticuoi tinớng tupứng alứng práh ŏ. Ma inha seq Phi-lat taláh ticuoi pla ndon khoiq cachet ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Inha cachet Yê-su, án ndon dyôn he têq bôn tumống, ma Yang Arbang-pilŏ́ng dyôn án tumống lieh. He chom arnáq ndô la lư piaiq, co he khoiq hôm. ");
INSERT INTO pac_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Inha acớl ticuoi dyuat ndô. Co he tin Yê-su alứng co nhơ te nốh án, iki ticuoi ndô cơt bánh. Lư Yê-su táp táq arnáq ndô dyôn inha bôn hôm. ");
INSERT INTO pac_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Em ai ơi! Cư chom inha alứng máh ticuoi sút inha khoiq cachet Yê-su, la co inha lớiq chom amớh te arnáq inha chón táq. ");
INSERT INTO pac_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma callong ndô Yang Arbang-pilŏ́ng khoiq tông te inớh na ticuoi tang ngcang án. Nha-án tông Crit cóq chiuq a-ưi nốh dieiq arức. Parnai ndô cơt tarpiaiq alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Iki, cóq inha pien cơt mít tamme loi, alứng píh veng tapun ngê Yang Arbang-pilŏ́ng, dyôn án pupít máh luaih inha. Khán inha táq iki, Yang Arbang-pilŏ́ng lư choi mít cannính inha cơt práih pruaih lieh. ");
INSERT INTO pac_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Alứng urớh, Yang Arbang-pilŏ́ng yua Crit siar lieh nga cúc cuteq ndô, muchứng án khoiq tông te nsuoi dyơ. ");
INSERT INTO pac_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ma hoi-ndô, Yê-su cóq át tớq pilŏ́ng tingôi ingái Yang Arbang-pilŏ́ng pangcra cúc cuteq ndô dyôn ŏ lieh arớq án mbơiq teng te tôm lư. Án khoiq tông iki te inớh na máh ticuoi tang ngcang án ndon práh ŏ lư. ");
INSERT INTO pac_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Môi-se la munáq te top ticuoi tang ngcang ngki, án tông idô: ‘Urớh Yang Arbang-pilŏ́ng yua munáq te top he cơt ticuoi tang ngcang án muchứng cư tưi. Cóq inha cammáng alứng peh máh parnai án cato. ");
INSERT INTO pac_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ticuoi mmo lớiq peh parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng, ticuoi ngki lớiq têq cơt nnáng prái Yang Arbang-pilŏ́ng.’ ");
INSERT INTO pac_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Samu-el alứng máh ticuoi tang ngcang Yang Arbang-pilŏ́ng ndon tớq tatun Samu-el, nhéq máh nha-án khoiq tông te arnáq he hôm tớq pang hoi-ndô. ");
INSERT INTO pac_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Máh ticuoi tang ngcang Yang Arbang-pilŏ́ng la achúc achiac he tưi. Alứng he chúng tưi máh nốh Yang Arbang-pilŏ́ng khoiq par-ưq alứng achúc achiac he A-praham. Yang Arbang-pilŏ́ng carhŏt idô: ‘Co nhơ te tŏ́ng toiq mái, urớh cứp top ticuoi pưn pilŏ́ng crôp ndô bôn ráp callong bún.’ ");
INSERT INTO pac_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Iki Yang Arbang-pilŏ́ng dyôn Yê-su la ticuoi táq arnáq án tớq nga inha avai. Án dyôn inha bôn callong bún nsuoi, alứng dyôn inha têq viar vít te ngê saq ndon inha báq táq.” ");
INSERT INTO pac_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ndóng Phi-er alứng Yon yôl cato, máh ticuoi sút te top teng rit sang, máh ticuoi sút líng kiaq me Dúng Sang Pưt, alứng máh ticuoi te top Sa-dusê tớq táp nga ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Máh ticuoi ngki sáng uan lư ada Phi-er alứng Yon, co nha-án tông te Yê-su khoiq tumống lieh. Alứng nha-án tông co nhơ Yê-su tumống lieh, iki máh ticuoi têq bôn tumống lieh muchứng Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Iki máh ticuoi sút cŏp bar náq ngki alứng crál tớq coq tôt, co ingái ngki khoiq tumán idáu dyơ. Ma ingái parnô nha-án ính plốh bar náq ngki. ");
INSERT INTO pac_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma bôn clứng lư ticuoi tin parnai nha-án bar náq ngki cato; máh ticuoi conh bôn sám sông ngin náq. ");
INSERT INTO pac_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tớq ingái parnô loi, máh ticuoi sút top Isa-ra-el, máh ticuoi sút tớq sớu, alứng máh thới sái rit, tớq rum nga vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nha-án pôq tumúh An-na ndon ariaih top teng rit sang Yang Arbang-pilŏ́ng. Alứng bôn máh ticuoi te dúng An-na át tớq ngki tưi, díh Cai-pha, Yon, alứng Alec-sandơ. ");
INSERT INTO pac_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Top nha-án yua ngai dông Phi-er alứng Yon tớq nga nha-án; dyơ nha-án plốh bar náq ngki idô: “Nnáu dyôn inha bôn chức táq bánh ticuoi dyuat ngki? Amớh nốh án?” ");
INSERT INTO pac_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndóng ngki Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính Phi-er, dyơ án tông idô: “Conh anhi ơi! Cư seq tông inha. ");
INSERT INTO pac_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Khán inha ính chom co imo he têq choi ticuoi dyuat cơt bánh, ");
INSERT INTO pac_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","cóq inha alứng nhéq máh ticuoi Isa-ra-el chom arlớih te arnáq ndô. Arnáq ndô nưm Yê-su Crit táp têq táq. Yê-su la te vel Na-saret, alứng inha khoiq téh án tớq along calláng. Ma Yang Arbang-pilŏ́ng dyôn án tumống lieh. ");
INSERT INTO pac_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Án la arớq cúc búl ndon inha táq dúng khoiq adúh, ma búl ngki cơt búl lác tớq tol dúng. ");
INSERT INTO pac_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pưn pilŏ́ng crôp ndô lớiq bôn nnáu têq choi tamống he. Ma Yang Arbang-pilŏ́ng dyôn nưm munáq Yê-su táp têq choi tamống he.” ");
INSERT INTO pac_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Máh ticuoi sút ngki sáng dut lư te parnai Phi-er alứng Yon cato clŏ́q lư, co nha-án chom bar náq ndô la ticuoi prái mat sớng, alứng lớiq bôn rian a-ưi. Ma bar náq ndô cơi át alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma máh ticuoi sút ngki lớiq chom ính tíq amớh te arnáq Phi-er alứng Yon táq, co nha-án hôm ticuoi dyuat khoiq cơt bánh tayứng tumán Phi-er nha Yon hơ. ");
INSERT INTO pac_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Iki nha-án yua Phi-er alứng Yon ngốh te ntúq nha-án rum, co nha-án ính tanghúng nưm nha-án sớng. ");
INSERT INTO pac_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nha-án tông idô: “Imo he ính táq ada bar náq ndô? Nhéq máh ticuoi tớq vel Yaru-salem khoiq hôm dyơ te arnáq sileh nha-án táq dyôn ticuoi dyuat ngki. He lớiq têq suon nha-án lớiq bôn táq arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma he êq dyôn arnáq ndô cơt rŏ́h mưt-mư dyôn ticuoi cannŏ́h chom. Iki he cóq dyŏq nha-án êq cato nnáng te nốh Yê-su.” ");
INSERT INTO pac_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Cua ngki nha-án arô lieh Phi-er alứng Yon dyôn mot tớq ntúq nha-án tanghúng. Nha-án dyŏq bar náq ngki êq pôq cato nnáng te nốh Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma Phi-er alứng Yon ôi máh ticuoi sút ngki idô: “Imo inha parngíh, arnáq amớh Yang Arbang-pilŏ́ng hôm ŏ hơn, ŏ he peh inha, ma ŏ he peh parnai Yang Arbang-pilŏ́ng? ");
INSERT INTO pac_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Lớiq têq khán he lớiq pôq cato máh arnáq he khoiq hôm te Yê-su táq alứng te máh parnai he khoiq sáng án cato; he cóq pôq cato dyôn ticuoi cannŏ́h chom tưi.” ");
INSERT INTO pac_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma máh ticuoi sút ngki parưt a-ưi nốh ada Phi-er alứng Yon lớiq dyôn pôq cato nnáng parnai ndô. Cua nha-án dyŏq iki, dyơ nha-án taláh. Nha-án lớiq têq táq amớh ada bar náq ngki, co nha-án adáh ticuoi prái táq lieh nha-án. Nhéq máh ticuoi prái ayô Yang Arbang-pilŏ́ng co án choi ticuoi dyuat ndô. ");
INSERT INTO pac_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Anhúq ticuoi dyuat ngki khoiq clưi puan chít cumo dyơ. ");
INSERT INTO pac_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tư máh ticuoi sút taláh Phi-er alứng Yon, nha-án chô lieh nga top nha-án, alứng táq-ntêr lieh te máh parnai ticuoi sút top teng rit sang alứng ticuoi sút tớq sớu khoiq tông ada nha-án. ");
INSERT INTO pac_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iki top nha-án sŏ́ng cớu mui mít idô: “Yang Arbang-pilŏ́ng Ưlla nhéq tưh ticuoi ơi! Inha táp khoiq teng pilŏ́ng, cúc cuteq, dơq ving-cavang, alứng túc nốh át tớq ngki. ");
INSERT INTO pac_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Te inớh inha khoiq tông na achúc achiac he Davit, te máh parnai Arvai inha dyôn án cato. Án khoiq tông idô: ‘Co imo máh ticuoi tớq cúc cuteq ndô uan lư Yang Arbang-pilŏ́ng? Co imo nha-án tanghúng te ngê ớq tarnáp? ");
INSERT INTO pac_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Máh puo tớq cúc cuteq ndô alứng máh ticuoi sút tanghúng munơi, alứng sŏ́ng ính chíl Yang Arbang-pilŏ́ng alứng Puo ndon Yang Arbang-pilŏ́ng khoiq rêh.’ ");
INSERT INTO pac_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Te máh arnáq ndô Davit khoiq tông piaiq lư te inớh; hoi-ndô he hôm arnáq ngki khoiq tớq dyơ. Hê-rôt An-tipa alứng Pon-ti Phi-lat khoiq rum tớq vel Yaru-salem munơi alứng máh ticuoi Isa-ra-el nha máh ticuoi te cruong cannŏ́h, ính táq Yê-su. Yê-su la ticuoi táq arnáq inha ndon práh ŏ lư. Nưm munáq án táp inha rêh dyôn choi tamống ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Máh ticuoi sút ngki rum munơi, alứng nha-án táq arớq inha khoiq anát te inớh. ");
INSERT INTO pac_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hoi-ndô Ưlla he ơi! Inha sáng dyơ parnai máh ticuoi sút ính táq he. Seq inha choi dyôn mít he cơt clŏ́q lư loi dŏq têq cato parnai ŏ inha. ");
INSERT INTO pac_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","He seq inha palai máh ticuoi a-ái dyôn cơt bánh. He seq inha apáh arnáq sileh alứng tíc te chức pưt lư na inha, nhơ te nốh Yê-su ndon táq arnáq inha, la án ndon práh ŏ lư.” ");
INSERT INTO pac_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cua nha-án cớu, dúng nha-án rum cơt cacưt alứng Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính nha-án. Dyơ nha-án cato parnai Yang Arbang-pilŏ́ng clŏ́q lư loi. ");
INSERT INTO pac_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nhéq máh top tin cơt mui mít mui lom. Ticuoi mmo bôn mun, án lớiq cơt ưlla munáq án sớng, ma nhéq náq ticuoi tin cơt ưlla chúng mun ngki. ");
INSERT INTO pac_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Parnai top dyưng ati Yê-su tông te Ưlla nha-án tumống lieh cơt sit lư. Alứng Yang Arbang-pilŏ́ng tốq callong bún dyôn máh top ndon veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tớq top nha-án lớiq bôn nnáu ớq amớh. Ticuoi mmo bôn ntúq cuteq lớiq la dúng, alứng nha-án sáng bui cannính ính choi yớu, nha-án táiq máh mun nha-án ");
INSERT INTO pac_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","alứng dông práq ngki nga top mui chít la bar náq dyưng ati Yê-su. Dyơ top ngki mpô máh práq ngki dyôn ticuoi ndon ớq. ");
INSERT INTO pac_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Bôn munáq conh, nốh Yô-sep, sớu Lê-vi, tớq te con Sip-rơ. Án bôn mui lang pidái, dyơ án táiq pidái ngki alứng dông práq tarnáp pidái nga top mui chít la bar náq. Top ngki anốh án nốh tamme la Ba-naba. Parnai Ba-naba titoiq lieh la ‘Khêr ticuoi ndon bôn callong anguaq’. ");
INSERT INTO pac_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ma bôn munáq conh, nốh A-nanie. Án alứng campái án Sapi-ra, nha-án táiq tưi mui tám cuteq. ");
INSERT INTO pac_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mui phê te práq tarnáp ngki, A-nanie dông nga top dyưng ati Yê-su. Ma mui phê loi, án cayíq dŏq. Campái án la chom tưi án táq iki. ");
INSERT INTO pac_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dyơ Phi-er tông ada A-nanie idô: “A-nanie ơi! Imo mái veng cannính yang Satán? Mái lứp ada Arvai Yang Arbang-pilŏ́ng te práq tarnáp inha táiq cuteq, alứng inha ial dŏq mui phê te práq ngki, ma mái dyôn nưm mui phê sớng. ");
INSERT INTO pac_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndóng inha iyốh táiq, cuteq ngki lư na inha. Práq tarnáp táiq cuteq ngki la lư práq inha. Imo inha tông khoiq mŏp nhéq práq tarnáp cuteq ngki, ma inha ial dŏq lieh mui phê? Inha lớiq lứp ticuoi, ma lư inha lứp Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cua Phi-er tông iki, ndóng ngki táp A-nanie dứm, dyơ cuchet lớng. Iki nhéq máh ticuoi sáng crŏ́q lư. ");
INSERT INTO pac_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dyơ máh ticuoi conh bánh mot sŏm cumuiq ngki. Cua nha-án sŏm, nha-án dông tứp táp. ");
INSERT INTO pac_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Vít ngki, sám chen pe adéh dôi, dyơ campái A-nanie loi mot tớq ntúq ngki. Án iyốh chom cayieq án khoiq cuchet. ");
INSERT INTO pac_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phi-er plốh án idô: “Inha dông nhéq dyơ máh práq tarnáp inha táiq cuteq ngki, ma lớiq?” Cán ngki ôi: “Ơq. Práq he táiq cuteq khoiq nhéq cayieq cư dông dyơ.” ");
INSERT INTO pac_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phi-er tông idô: “Imo inha bar náq sŏ́ng mui mít ính chim Arvai Yang Arbang-pilŏ́ng? Cayieq mái khoiq ngai dông tứp. Hoi-ndô nha-án ndon tứp cayieq mái, khoiq chô tớq ngáh callống dyơ. Lư nha-án ính dông tứp mái loi.” ");
INSERT INTO pac_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tư án sáng Phi-er tông iki, án dứm, dyơ án cuchet tưi. Máh ticuoi conh bánh mot alứng bôn hôm án khoiq cuchet; dyơ nha-án dông tứp án tumán ping cayieq án. ");
INSERT INTO pac_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iki, tư nhéq máh top tin Yê-su alứng ticuoi cannŏ́h sáng te arnáq ndô, nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Top dyưng ati Yê-su táq a-ưi arnáq sileh chứng mát máh ticuoi tớq vel ngki. Alứng máh ticuoi veng tapun Yê-su báq rum tớq Ntrôn Sa-lamôn tớq Dúng Sang Pưt. Iki nha-án cơt mui mít mui lom. ");
INSERT INTO pac_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Máh ticuoi iyốh tin ayô top veng tapun Yê-su, ma nha-án lớiq dáh mot alứng top veng tapun Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma bôn ticuoi mot tin cơt clứng lư loi, bôn díh conh, díh cán. ");
INSERT INTO pac_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Báq ngai dông dŏq máh ticuoi a-ái tớq tor carna, alứng dyôn nha-án bíq tớq nchiauq alứng carrang. Nha-án át pớn Phi-er tớq, co ính mol Phi-er cadứp nha-án dyôn cơt bánh. ");
INSERT INTO pac_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Clứng ticuoi te vel cannŏ́h ndon át tumán vel pưt Yaru-salem, nha-án dông máh ticuoi a-ái alứng ticuoi bôn yang saq piyúh nga tuki. Dyơ máh ticuoi ngki lư cơt bánh nhéq. ");
INSERT INTO pac_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma ariaih top teng rit sang alứng yớu án te top Sa-dusê, sáng uan lư ada top mui chít la bar náq dyưng ati Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dyơ nha-án cŏp top ngki alứng crál tớq coq tôt. ");
INSERT INTO pac_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma tớq idáu bôn mui tarneng Yang Arbang-pilŏ́ng pốh ngáh callống coq tôt, alứng dông angốh top mui chít la bar náq te coq ngki. ");
INSERT INTO pac_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Tarneng ngki yua nha-án idô: “Inha pôq cato nga ngcưm Dúng Sang Pưt dyôn máh ticuoi chom imo táp Yang Arbang-pilŏ́ng khoiq dyôn tarngứh tamme ndô.” ");
INSERT INTO pac_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iki nha-án peh parnai tarneng ngki. Tớq ang iláih, nha-án mot cato tớq ngcưm Dúng Sang Pưt. Ndóng nha-án cato, ariaih top teng rit sang alứng yớu án mot rum alứng ticuoi sút top Isa-ra-el. Máh ticuoi sút ngki yua líng pôq ial top mui chít la bar náq te coq tôt, dyơ dông nga ntúq nha-án át rum. ");
INSERT INTO pac_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ma tư líng mot tớq coq tôt, nha-án lớiq hôm nnáng top mui chít la bar náq. Dyơ nha-án chô tông máh ticuoi sút ");
INSERT INTO pac_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","idô: “Tư he tớq nga coq tôt, he hôm coq tôt lớiq bôn ngai pốh, alứng ticuoi kiaq coq ngki yôl át. Ma tư he pốh callống, he lớiq hôm nnáng top ngki tớq coq.” ");
INSERT INTO pac_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tư ticuoi sút líng ndon kiaq me dúng sang alứng máh ticuoi sút top teng rit sang sáng parnai ngki, nha-án sáng dut lư, alứng nha-án át parngíh, ma lớiq chom arnáq amớh loi top mui chít la bar náq ính táq. ");
INSERT INTO pac_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Cua ngki bôn ticuoi tớq tông nha-án idô: “Máh ticuoi ndon inha khoiq crál tớq coq tôt ibư inô, hoi-ndô nha-án cato máh ticuoi tớq ngcưm Dúng Sang Pưt.” ");
INSERT INTO pac_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dyơ ticuoi sút líng dông líng án pôq cớiq top mui chít la bar náq. Ma nha-án táq alvai lư, co nha-án adáh máh ticuoi prái tíq búl ada nha-án, khán nha-án táq háng ada top ngki. ");
INSERT INTO pac_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tư top líng dông top dyưng ati Yê-su mot tayứng chứng mát ticuoi sút alứng ariaih top teng rit sang, dyơ ariaih ngki tông top dyưng ati ngki idô: ");
INSERT INTO pac_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“He khoiq dyŏq inha êq pôq cato nnáng te ngê Yê-su. Ma inha lớiq peh he. Hoi-ngki parnai ndô cơt parhanh mưt-mư chôp vel Yaru-salem. Alứng inha cato ticuoi cannŏ́h hơ, ính ngai táq-ntêr he khoiq cachet Yê-su.” ");
INSERT INTO pac_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phi-er alứng yớu án ôi idô: “The he peh parnai Yang Arbang-pilŏ́ng, aláng peh parnai ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lư inha khoiq cachet Yê-su tớq along calláng. Ma Yang Arbang-pilŏ́ng achúc achiac he sang te inớh, án khoiq choi Yê-su dyôn tumống lieh. ");
INSERT INTO pac_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yang Arbang-pilŏ́ng dyôn Yê-su át pa atớm án alứng cơt sút pưt lư, dŏq Yê-su têq choi tamống ticuoi. Yang Arbang-pilŏ́ng ính choi top Isa-ra-el, án ính nha-án pien cơt mít tamme loi; dyơ án têq táh luaih dyôn nha-án. ");
INSERT INTO pac_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","He khoiq hôm dyơ, alứng he ính tông lieh te máh arnáq ngki. Alứng Arvai Yang Arbang-pilŏ́ng la tông iki tưi. Khán ticuoi mmo peh, Yang Arbang-pilŏ́ng lư dyôn Arvai án át lớng alứng ticuoi ngki.” ");
INSERT INTO pac_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tớq ticuoi sút sáng iki, nha-án sáng uan lư loi. Nha-án ính cachet top mui chít la bar náq. ");
INSERT INTO pac_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ma bôn munáq te top nha-án yôr tayứng, nốh Cama-liel, te top Pha-rasi. Án la thới sái rit ticuoi Isa-ra-el, alứng ngai dyám náp lư án. Án yua líng dông angốh top mui chít la bar náq te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dyơ án tông máh ticuoi sút ngki idô: “Em ai ơi! Cóq inha táq ŏ daih ada top mui chít la bar náq ndô. ");
INSERT INTO pac_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cóq inha ayư te munáq ticuoi, nốh Thêu-da. Án ính ngai parngíh án la ticuoi pưt. Bôn sám puan culám náq báq veng án. Ma vít ngai cachet án, top veng án lúh pláh cứp ntúq, alứng arnáq nha-án táq cơt pít nhéq. ");
INSERT INTO pac_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Vít ngki, tớq callúng máh ingái ngai ngiaih ticuoi prái, dyơ bôn munáq nốh Yuda, te vúng Ca-lilê. Án sớr cơt sút, alứng bôn clứng ticuoi veng án. Ma ngai cachet án tưi, alứng top veng án la lúh pláh nhéq. ");
INSERT INTO pac_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Iki cư tông inha hoi-ndô, inha êq táq amớh ada top mui chít la bar náq ndô. Khán parnai nha-án tông alứng arnáq nha-án táq chóng ngốh te mít nha-án bôm, lớiq dưnh arnáq ngki lư cơt pít nhéq. ");
INSERT INTO pac_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma khán arnáq nha-án táq tớq te Yang Arbang-pilŏ́ng, lư inha lớiq têq pupít. Khán inha ính pupít arnáq ngki la arớq inha chíl Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Iki máh ticuoi sút ngki cammáng parnai Cama-liel. Nha-án arô lieh top mui chít la bar náq dyôn tớq nga nha-án. Dyơ nha-án yua ngai tính top ngki. Alứng nha-án dyŏq top ngki êq cato nnáng te parnai Yê-su. Cua nha-án patáp, nha-án taláh. ");
INSERT INTO pac_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Top mui chít la bar náq ngốh te ntúq ngki. Nha-án sáng bui lư, co Yang Arbang-pilŏ́ng dyôn nha-án rap chiuq máh callong dieiq arức co tian nha-án dyám náp Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Cứp ingái top nha-án mot tớq Dúng Sang Pưt, alứng tớq máh dúng ticuoi hơ; nha-án cato níc parnai ŏ te Yê-su Crit. ");
INSERT INTO pac_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Máh ingái ngki top veng tapun Yê-su cơt clứng lư loi. Alứng tớq top nha-án bôn máh ticuoi Isa-ra-el táq-ntêr cang Créc. Máh ticuoi ngki u idô: “Cứp ingái cán cammai tớq top he ráp crơng tớc tanna cha, ma lớiq li arớq cán cammai top Isa-ra-el ndon táq-ntêr cang Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iki top mui chít la bar náq arô top veng tapun Yê-su dyôn tớq parchúng munơi, alứng tông idô: “Lớiq piaiq, he mui chít la bar náq ớq bôn cato parnai Yang Arbang-pilŏ́ng, co mmaq mpô crơng tanna dyôn inha. ");
INSERT INTO pac_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Iki, cóq inha rêh tupul náq te top inha, án ndon tubáiq alứng bôn Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít nha-án. Dyơ he ính pachúh dyôn nha-án tupul náq ngki loi cơt sút te arnáq mpô tampớc tớc tanna cha dyôn inha. ");
INSERT INTO pac_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma he yôl cớu choi níc, alứng he bôn pôq cato parnai Yang Arbang-pilŏ́ng hơ.” ");
INSERT INTO pac_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tư top veng tapun Yê-su sáng parnai ngki, nha-án sáng bui lư. Iki nha-án rêh Satien la ticuoi tin khớm lư, alứng án bôn Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính án. Alứng nha-án rêh ticuoi cannŏ́h hơ, bôn nốh Philip, Prô-curơ, Ni-canor, Tamôn, Barmê-na, alứng Ni-cula te vel Anti-ôt. Ndóng nsuoi, Ni-cula veng phep rit Isa-ra-el, ma tatun án tin Yê-su loi. ");
INSERT INTO pac_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tupul náq ngki át chứng mát top mui chít la bar náq dyưng ati Yê-su. Dyơ nha-án capơiq tớq cháq tupul náq alứng cớu, táq tíc ticuoi ngki tabớq táq arnáq Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Co iki parnai Yang Arbang-pilŏ́ng cơt rứh a-ưi ntúq, alứng bôn clứng ticuoi tớq vel Yaru-salem mot tin. Alứng bôn a-ưi náq te top teng rit sang tin tưi. ");
INSERT INTO pac_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Satien la ticuoi tin Yê-su khớm lư. Arvai Yang Arbang-pilŏ́ng dyôn án bôn chức têq táq arnáq sileh chứng mát máh ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma bôn ticuoi te mui dúng rum ticuoi Isa-ra-el tarmien alứng Satien. A-ưi náq te dúng rum ngki la ticuoi sol ndon ngai khoiq taláh. Nha-án tớq te vel Si-rên, vel Alec-santri, cruong Si-lasi, alứng cruong Asie. ");
INSERT INTO pac_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Arvai Yang Arbang-pilŏ́ng dyôn Satien ôi ticuoi ngki tubáiq lư. Iki top nha-án lớiq chom imo ính tông Satien. ");
INSERT INTO pac_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Dyơ top nha-án chang práq ticuoi cannŏ́h dyôn ton apít Satien. Máh ticuoi ngki tông idô: “He khoiq sáng Satien acraiq Môi-se alứng Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iki top ngki chuoq rúc máh ticuoi tớq vel ngki, máh ticuoi sút tớq sớu, alứng máh thới sái rit ính táq Satien. Dyơ nhéq nha-án tớq cŏp Satien, alứng dông án nga ticuoi sút. ");
INSERT INTO pac_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nha-án dông atớq sa ticuoi ndon ton apít Satien, dyơ ticuoi ngki tông idô: “Ticuoi ndô báq táq-ntêr pamat Dúng Sang Pưt alứng ayê phep rit Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","He khoiq sáng án tông te munáq ticuoi nốh Yê-su, te vel Na-saret, la ticuoi ndon ính talóh Dúng Sang Pưt alứng ính pien máh phep rit Môi-se khoiq patáp he.” ");
INSERT INTO pac_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nhéq máh ticuoi rum ntúq ngki me clớn níc nga Satien. Nha-án hôm mang án cơt arớq mang tarneng. ");
INSERT INTO pac_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dyơ ariaih top teng rit sang Yang Arbang-pilŏ́ng plốh Satien idô: “Máh callong nha-án tông ngki lư ma lớiq?” ");
INSERT INTO pac_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Satien ôi idô: “Nhéq máh em ai, conh anhi ơi! Seq inha cammáng parnai cư nsuar. Yang Arbang-pilŏ́ng he bôn chức ang-ưr clưi nhéq te yang cannŏ́h; án khoiq tớq cato achúc achiac he A-praham te inớh. Ndóng ngki A-praham yôl át tớq cruong Mê-sapô-tamie; án iyốh pôq nga cruong Haran. ");
INSERT INTO pac_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yang Arbang-pilŏ́ng yua án idô: ‘Mái ngốh te cruong mái, alứng táh nhéq abŏ́h mái. Dyơ mái pôq át nga cruong ndon cư ính apáh a mái.’ ");
INSERT INTO pac_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Iki A-praham ngốh te cruong Caldê, dyơ pôq át nga cruong Haran. Ma tư a-ám án cuchet, Yang Arbang-pilŏ́ng dông án pôq át tớq cruong he át hoi-ndô loi. ");
INSERT INTO pac_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yang Arbang-pilŏ́ng iyốh dyôn A-praham bôn cơt ưlla cuteq ndô. Ma Yang Arbang-pilŏ́ng ưq alứng án nha tŏ́ng toiq án idô: Urớh nha-án bôn cơt ưlla nhéq cruong ndô tingôi tớq pang ache achón nha-án. Ma ndóng Yang Arbang-pilŏ́ng tông iki, án iyốh bôn acái. ");
INSERT INTO pac_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Alứng Yang Arbang-pilŏ́ng tông A-praham loi idô: ‘Urớh tŏ́ng toiq mái cóq át tớq cruong ndon nha-án lớiq bôn cơt ưlla. Tớq cruong ngki nha-án cơt sol nhéq puan culám cumo, alứng ticuoi ưlla nha-án táq dieiq arức lư ada nha-án. ");
INSERT INTO pac_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ma tatun loi, cư ính carlieh dơq ada ticuoi tớq cruong ndon táq dyôn ache achón mái cơt sol. Cua ngki, ache achón mái bôn ngốh te cruong ngki, alứng bôn sang tám cư tớq ntúq ndô.’ ");
INSERT INTO pac_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dyơ Yang Arbang-pilŏ́ng carhŏt ada A-praham, alứng Yang Arbang-pilŏ́ng yua án táq rit kít dyôn acái conh án. Rit ndô la tíc án carhŏt ada Yang Arbang-pilŏ́ng. Tư án bôn acái conh, án anốh acái ngki la I-sac. Catám ingái ticol, náp te ingái carnian I-sac, án táq rit kít dyôn I-sac. Muchứng ngki tưi, I-sac táq rit kít dyôn Yacốp, acái conh án. Alứng Yacốp táq rit kít ndô dyôn máh acái conh án. Án bôn mui chít la bar náq acái conh, la achúc achiac he. ");
INSERT INTO pac_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Bôn munáq te máh achúc achiac he acái conh Yacốp, nốh Yô-sep. Máh ai Yô-sep uan ada án. Iki nha-án táiq án. Dyơ ticuoi te cruong Ê-yip-tô dông án dyôn cơt sol nga cruong ngki. Ma Yang Arbang-pilŏ́ng át níc alứng án. ");
INSERT INTO pac_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Iki Yang Arbang-pilŏ́ng choi Yô-sep dyôn vít te máh arnáq dieiq arức ngai ính táq án. Yang Arbang-pilŏ́ng táq tớq mít cannính puo cruong Ê-yip-tô táq ŏ ada án. Alứng Yang Arbang-pilŏ́ng dyôn án cơt tubáiq lư. Iki puo cruong ngki chóh án cơt sút tớq cruong ngki, alứng cơt sút díh tớq dúng puo hơ. ");
INSERT INTO pac_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ndóng ngki bôn a-ưi cumo ớq crơng tanna tớq cruong Ê-yip-tô alứng tớq cruong Cana-an, lớiq bôn crơng tanna amớh tháng. Toiq bap lư máh ticuoi tớq cruong ngki. Alứng achúc achiac he te inớh pôq ruráh suo crơng tanna, ma lớiq bôn. ");
INSERT INTO pac_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tư Yacốp sáng ngai táq-ntêr te cruong Ê-yip-tô bôn crơng tanna, iki án yua acái conh án, la máh achúc achiac he te inớh pôq nga cruong Ê-yip-tô chư tôm lư. ");
INSERT INTO pac_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tư nha-án pôq chư tatun loi, Yô-sep dyôn nha-án chom án la em ai nha-án. Alứng án dyôn em ai án bôn tumúh puo cruong Ê-yip-tô. ");
INSERT INTO pac_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iki án patáp Yacốp a-ám án dyôn dông nhéq sớu pôq át alứng án tớq cruong Ê-yip-tô. Nhéq máh ticuoi tớq sớu án la tupul chít la sông náq. ");
INSERT INTO pac_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dyơ Yacốp pôq át tớq cruong Ê-yip-tô. Án alứng máh achúc achiac he te inớh át lớng tớq cruong ngki tingôi sút nhéq pang tumống nha-án. ");
INSERT INTO pac_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Vít ngki ngai dông achô lieh cumuiq nha-án nga vel Se-kem, alứng dŏq tớq ping tớq cưp ndon A-praham khoiq plới te máh acái conh Hamor. ");
INSERT INTO pac_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Khoiq tumán tớq ingái Yang Arbang-pilŏ́ng ính táq arớq án khoiq ưq alứng A-praham te nsuoi, dyơ tŏ́ng toiq he cơt rứh clứng lư tớq cruong Ê-yip-tô. ");
INSERT INTO pac_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Dyơ bôn munáq loi cơt puo tớq cruong Ê-yip-tô, ma án lớiq chom amớh te Yô-sep. ");
INSERT INTO pac_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Puo ndô dông dieiq arức lư máh achúc achiac he te inớh. Án patot ticuoi mbơiq carnian acái conh cóq pôq phôt. Án táq iki, co án ính tŏ́ng toiq achúc achiac he cơt pít nhéq. ");
INSERT INTO pac_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tớq ingái dieiq arức ngki, a-i Môi-se carnian Môi-se. Yang Arbang-pilŏ́ng sáng bui lư ada Môi-se. A-i a-ám án parléh án tớq dúng, nhéq pe kisái. ");
INSERT INTO pac_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tư nha-án lớiq têq catốq nnáng, iki nha-án dông phôt Môi-se nga dơq; nha-án cacháq án tớq ar-áu két. Ma bôn acái cán puo tumúh; dyơ cán ngki ial táq acái. ");
INSERT INTO pac_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Iki Môi-se bôn rian nhéq máh ngê tubáiq te ticuoi Ê-yip-tô. Dyơ parnai án tông la sit lư, alứng hôi lư án táq arnáq. ");
INSERT INTO pac_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Tư Môi-se bôn puan chít cumo, án ính pôq alang em ai em ơi án ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ndóng án pôq, án tumúh munáq ticuoi Ê-yip-tô tính munáq ticuoi Isa-ra-el. Án sáng sruiq táq ticuoi Isa-ra-el ngki, alứng án tớq choi. Dyơ án cachet ticuoi Ê-yip-tô. ");
INSERT INTO pac_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Môi-se parngíh máh ticuoi Isa-ra-el chom Yang Arbang-pilŏ́ng dyôn án tarchoi nha-án. Ma nha-án lớiq chom te callong ndô. ");
INSERT INTO pac_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ingái parnô loi, Môi-se tumúh bar náq ticuoi Isa-ra-el carchet. Dyơ án dyŏq nha-án êq carchet. Án tông nha-án idô: ‘Inha la lư em ai. Ma imo inha munáq pi-ốh munáq, munáq táq munáq?’ ");
INSERT INTO pac_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ma án ndon tính yớu, án kitúh Môi-se, alứng án tông idô: ‘Nnáu chóh mái cơt ticuoi sút dŏq parchen he? ");
INSERT INTO pac_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Mái ính cachet cư arớq mái khoiq cachet ticuoi Ê-yip-tô ingái inô tưi, lớiq?’ ");
INSERT INTO pac_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tư Môi-se sáng parnai ngki, án adáh lư. Dyơ án lúh te cruong Ê-yip-tô, pôq át tớq cruong Madian loi. Tớq cruong ngki án ama bar náq acái conh. ");
INSERT INTO pac_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nhéq puan chít cumo Môi-se át tớq ntúq aih, tumán cóh Si-nai. Vít ngki bôn mui tarneng Yang Arbang-pilŏ́ng tớq apáh dyôn án hôm uih chéh tớq arpul arbu. ");
INSERT INTO pac_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tư Môi-se hôm uih, án sáng dut lư. Dyơ án ticaq pôq tumán ính me arŏ́q lư arbu ngki, ma án sáng sieng Yang Arbang-pilŏ́ng tông án idô: ");
INSERT INTO pac_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Cư la Yang Arbang-pilŏ́ng achúc achiac inha A-praham sang, I-sac sang, alứng Yacốp sang.’ Dyơ Môi-se dyandyír co sáng adáh lư, alứng án lớiq dáh me nnáng nga uih ngki. ");
INSERT INTO pac_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dyơ Yang Arbang-pilŏ́ng tông án idô: ‘Mái luaiq viang cơp te dyưng mái. Ntúq cuteq mái tayứng ndô la ntúq práh ŏ na Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Cư khoiq hôm dyơ máh ticuoi prái cư chiuq a-ưi nốh dieiq arức tớq cruong Ê-yip-tô. Cư khoiq sáng dyơ máh ticuoi cư cucloiq cucling. Iki cư siar nga ndô ính choi tamống nha-án. Ma hoi-ndô cư yua mái píh lieh nga cruong Ê-yip-tô.’ ");
INSERT INTO pac_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Te nsuoi, Môi-se ính choi tưi top Isa-ra-el, ma nha-án lớiq ính án choi. Alứng nha-án tông idô: ‘Nnáu chóh mái cơt sút dŏq parchen he?’ Ma tarneng ndon át tớq arbu uih chéh ngki tông Môi-se chom arlớih lư, la Yang Arbang-pilŏ́ng táp rêh án dyôn cơt sút top Isa-ra-el, alứng dyôn choi tamống nha-án. ");
INSERT INTO pac_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Iki Môi-se dông angốh top Isa-ra-el te cruong Ê-yip-tô. Án táq a-ưi arnáq sileh tớq cruong Ê-yip-tô, alứng ndóng án choi nha-án dyang dơq ving cavang Cusáu, alứng ndóng nha-án át ntúq aih. Nha-án át ntúq ngki nhéq puan chít cumo. ");
INSERT INTO pac_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Môi-se tông top Isa-ra-el idô: ‘Urớh Yang Arbang-pilŏ́ng yua munáq ticuoi te top inha dyôn cơt ticuoi tang ngcang án muchứng cư tưi.’ ");
INSERT INTO pac_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Môi-se át alứng top achúc achiac he la ticuoi Isa-ra-el te inớh tớq ntúq aih, alứng án táp táq-ntêr alứng tarneng Yang Arbang-pilŏ́ng tớq cóh Si-nai. Ndóng ngki án ráp parnai dyôn têq bôn tumống te Yang Arbang-pilŏ́ng, dyơ án tông dyôn he chom tưi. ");
INSERT INTO pac_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ma achúc achiac he lớiq cammáng Môi-se. Dyơ nha-án ính táh Môi-se, alứng nha-án ính chô lieh nga cruong Ê-yip-tô. ");
INSERT INTO pac_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ndóng Môi-se yôl át tớq cóh Si-nai, achúc achiac he yua Arôn idô: ‘Seq mái táq rup yang dŏq ayông he. Co he lớiq chom bôn arnáq amớh cơt ada Môi-se, la ticuoi ndon dông angốh he te cruong Ê-yip-tô.’ ");
INSERT INTO pac_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iki nha-án táq mui lám rup carrŏ́q acái. Dyơ nha-án tutức sang rup ngki. Nha-án cha alứng parlơ bui. Nha-án ơn lư bôn rup nha-án tốq bôm. ");
INSERT INTO pac_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iki Yang Arbang-pilŏ́ng nguai te nha-án, alứng táh dyôn nha-án tíng sang mát pandang, mát kisái, alứng máh pantôr. Nha-án ngin nốh ngki la yang nha-án. Ma máh nốh ngki, Yang Arbang-pilŏ́ng khoiq tông tớq tám uráq ticuoi tang ngcang án te inớh idô: ‘Top Isa-ra-el ơi! Ndóng inha át tớq ntúq aih puan chít cumo, cư lớiq bôn yua inha dông crơng mŏp sang dyôn cư. ");
INSERT INTO pac_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Lư inha cliau dúng prới yang Mô-lêc. Alứng inha cliau rup pantôr táq tíc inha sang yang Rê-phan. Nốh amớh inha ính sang, inha táq rup ngki. Co te arnáq ngki cư mŏp inha dyôn ngai cŏp dông nga cruong Ba-bulôn.’” ");
INSERT INTO pac_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Satien tông loi idô: “Ndóng achúc achiac he át tớq ntúq aih, nha-án sŏ́ng dông mui lám Dúng Sang Prới ien sang tám Yang Arbang-pilŏ́ng. Dúng ngki nha-án táq veng arớq Yang Arbang-pilŏ́ng khoiq tông nha-án na Môi-se, alứng arớq Yang Arbang-pilŏ́ng khoiq apáh dyôn Môi-se hôm. ");
INSERT INTO pac_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Achúc achiac he te inớh dyôn pang acái nha-án bôn ưlla tưi Dúng Sang Prới ngki. Ndóng Yô-sua dông achúc achiac he mot tớq cruong ndon Yang Arbang-pilŏ́ng khoiq ưq ính dyôn nha-án cơt ưlla, nha-án dông díh Dúng Sang Prới ngki. Yang Arbang-pilŏ́ng chuih máh ticuoi tớq cruong ngki, dyơ dyôn top he loi át. Alứng Dúng Sang Prới ngki yôl níc tớq cruong ndô tingôi ingái Davit cơt puo top Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yang Arbang-pilŏ́ng sáng bui lư ada Davit. Alứng Davit seq Yang Arbang-pilŏ́ng dyôn án bôn táq dúng pưt ien sang tám Yang Arbang-pilŏ́ng Ưlla achúc achiac he Yacốp sang. ");
INSERT INTO pac_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma Yang Arbang-pilŏ́ng lớiq dyôn Davit táq Dúng Sang Pưt. Yang Arbang-pilŏ́ng dyôn Sa-lamôn, acái conh Davit, táq Dúng Sang ngki. ");
INSERT INTO pac_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ma Yang Arbang-pilŏ́ng ndon sút clưi nhéq te cannŏ́h lớiq át tớq dúng sang ticuoi táq. Án khoiq tông ada ticuoi tang ngcang án idô: ");
INSERT INTO pac_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Pilŏ́ng cơt kichơng dyôn cư ticu, alứng cúc cuteq cơt ntúq cư achúh dyưng. Khán iki, imo inha parngíh ính táq dúng dyôn cư át? Cư lớiq nai aleq. Imo inha táq dúng dyôn cư angô? ");
INSERT INTO pac_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Cư táp teng cứp nốh ndon khoiq bôn, piaiq lớiq?’” ");
INSERT INTO pac_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Dyơ Satien tông loi idô: “Inha bôn mít cớng lư. Alứng cutor inha lớiq ính cammáng. Inha lớiq peh parnai Yang Arbang-pilŏ́ng alứng lớiq dyôn Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít inha. Inha táq muchứng tháng achúc achiac inha te inớh. ");
INSERT INTO pac_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nha-án khoiq táq dieiq arức máh ticuoi tang ngcang Yang Arbang-pilŏ́ng. Nha-án cachet máh ticuoi tông acớiq dyôn nha-án chom, urớh bôn munáq Acái Yang Arbang-pilŏ́ng siar nga cúc cuteq ndô. Alứng hoi-ndô án khoiq tớq dyơ nga cúc cuteq ndô, ma inha khoiq culieu án alứng cachet án. ");
INSERT INTO pac_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tarneng Yang Arbang-pilŏ́ng khoiq tông dyôn inha chom phep rit te Yang Arbang-pilŏ́ng, ma inha lớiq peh parnai ngki.” ");
INSERT INTO pac_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tư ticuoi sút sáng máh parnai ngki, nha-án sáng la-ưn táp tớq mít nha-án. Alứng nha-án caltưat kineng tabang ada Satien. ");
INSERT INTO pac_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma Satien bôn Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính án. Dyơ án tingưi asớr nga pilŏ́ng, alứng án hôm chức ang-ưr lư te Yang Arbang-pilŏ́ng. Alứng án hôm Yê-su át tayứng pa atớm Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dyơ án tông idô: “Tíh! Inha tingưi nga pilŏ́ng! Cư hôm pilŏ́ng arớq ngai pốh, alứng cư hôm Acái Yang Cơt Ticuoi át tayứng pa atớm Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tư máh ticuoi ngki sáng Satien tông parnai ngki, nha-án capát cutor alứng hiar yứng lư. Dyơ nha-án palŏ́ng nga Satien. ");
INSERT INTO pac_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nha-án ndŏ́h Satien angốh culái tieh vel. Alứng nha-án ial búl tíq ada Satien tingôi cuchet. Top ticuoi ndon cachet Satien, yua munáq ticuoi bánh, nốh Salơ, kiaq me tampớc nha-án. ");
INSERT INTO pac_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ndóng nha-án tíq búl ada Satien, Satien cớu idô: “Ưlla Yê-su ơi! Seq inha ráp ial arvai cư.” ");
INSERT INTO pac_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Iki án chóh tarcol alứng tông yứng lư idô: “Ưlla ơi! Seq inha êq náp máh luaih ndon nha-án táq ada cư hoi-ndô.” Cua án tông iki, án cuchet. ");
INSERT INTO pac_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Alứng Salơ sŏ́ng alứng nha-án ndon cachet Satien. Ndóng ngki top veng tapun Yê-su tớq vel pưt Yaru-salem mbơiq tumúh ngai táq dieiq arức lư. Iki top nha-án mmar lúh pláh nhéq. Bôn án ndon át lieh tớq vúng Yudê, alứng bôn án ndon lúh át nga vúng Sa-mari. Ma top mui chít la bar náq dyưng ati Yê-su yôl át tớq vel pưt Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bôn mui top conh ndon dyám náp Yang Arbang-pilŏ́ng, nha-án ial cumuiq Satien dông tứp. Nha-án nhiem atíh án. ");
INSERT INTO pac_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma Salơ ính pupít nhéq ticuoi tin Yê-su. Iki án pôq suo cứp dúng. Khán án tumúh ticuoi tin, án lúq angốh díh cán, díh conh, dông crál tớq coq tôt. ");
INSERT INTO pac_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Máh ticuoi tin ndon lúh te vel Yaru-salem, án ndon pôq tudô, án ndon pôq tuki, dŏq cato parnai ŏ te Yê-su Crit. ");
INSERT INTO pac_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Phi-lip la munáq te top ndon mpô máh crơng tớq top tin, án siar nga vúng Sa-mari alứng cato te Crit dyôn máh ticuoi tớq vúng ngki chom. ");
INSERT INTO pac_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Co Phi-lip táq a-ưi arnáq sileh, iki bôn clứng lư ticuoi tớq vúng ngki cammáng parnai án cato. ");
INSERT INTO pac_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bôn a-ưi náq ticuoi bôn yang saq piyúh. Tư Phi-lip chuih angốh yang saq te máh cháq ticuoi, yang ngki hiar yứng lư. Máh ticuoi a-ái cớng alứng máh ticuoi dyuat, la án táq dyôn cơt bánh nhéq. ");
INSERT INTO pac_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Co iki ticuoi tớq vúng Sa-mari bôn máng callong bui. ");
INSERT INTO pac_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Bôn munáq conh, nốh Si-môn, tớq vel Sa-mari. Te nsuoi án la ticuoi mo. Ticuoi tớq vel Sa-mari sáng dut lư te máh arnáq án táq. Án ính ngai ayô án, alứng ính nốh án pardŏ́h parhanh la mo khéh lư. ");
INSERT INTO pac_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Máh ticuoi sút alứng máh ticuoi prái tớq vel ngki cammáng níc parnai án tông. Nha-án tông idô: “Ticuoi ndô bôn chức arớq chức Yang Arbang-pilŏ́ng tưi.” ");
INSERT INTO pac_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Máh ticuoi tớq vel ngki veng tapun Si-môn, co nha-án khoiq sáng te dưnh dyơ máh arnáq án táq. ");
INSERT INTO pac_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma tư Phi-lip cato parnai ŏ te Yang Arbang-pilŏ́ng cơt sút alứng te Yê-su Crit, bôn ticuoi tớq vel ngki mot tin alứng ráp tíc na dơq, bôn díh conh díh cán. ");
INSERT INTO pac_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Si-môn tin alứng ráp tíc na dơq tưi. Tumo Phi-lip pôq, Si-môn pôq tuki tưi. Iki Si-môn bôn hôm máh arnáq sileh Phi-lip táq. Án sáng dut lư tớq mít án. Án lớiq chom te mmo Phi-lip bôn chức têq táq arnáq iki. ");
INSERT INTO pac_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tư top mui chít la bar náq ndon át tớq vel Yaru-salem sáng ngai táq-ntêr ticuoi tớq vel Sa-mari tin parnai Yang Arbang-pilŏ́ng, iki nha-án yua Phi-er alứng Yon pôq me. ");
INSERT INTO pac_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tư Phi-er alứng Yon tớq nga vel ngki, nha-án cớu dyôn ticuoi ndon khoiq tin, alứng seq Yang Arbang-pilŏ́ng dyôn Arvai án át alứng máh ticuoi ngki, ");
INSERT INTO pac_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","co Arvai Yang Arbang-pilŏ́ng iyốh tớq át alứng máh ticuoi ngki. Ma nha-án khoiq ráp tíc na dơq nhơ nốh Ưlla Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tư Phi-er alứng Yon capơiq tớq cháq máh ticuoi tin, iki Arvai Yang Arbang-pilŏ́ng mot át táp tớq mít nha-án. ");
INSERT INTO pac_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tư Si-môn hôm Phi-er alứng Yon capơiq tớq cháq ticuoi, alứng Arvai Yang Arbang-pilŏ́ng mot át táp tớq mít ticuoi, iki án dông práq nga nha-án, co án ính bôn tưi chức ngki. ");
INSERT INTO pac_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Án tông idô: “Cư seq inha dyôn cư bôn tưi chức ndô, dŏq cư capơiq tớq cháq ticuoi cannŏ́h dyôn nha-án têq bôn Arvai Yang Arbang-pilŏ́ng tưi.” ");
INSERT INTO pac_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma Phi-er ôi án idô: “Práq mái alứng cháq mái lư pít mui parrứh! Co imo mái parngíh chức Yang Arbang-pilŏ́ng têq plới tớq práq? ");
INSERT INTO pac_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mái lớiq têq táq arnáq ndô, co mít cannính mái lớiq bôn tinớng ŏ chứng mát Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Iki cóq mái táh viang ngê tieq, dyơ ial mít tamme loi. Alứng cóq mái cớu seq nga Yang Arbang-pilŏ́ng, dáh lơ án táh luaih dyôn mái te arnáq mái khoiq parngíh ính táq. ");
INSERT INTO pac_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Cư hôm mít mái tél-sél lư ính táq arnáq muchứng he, alứng bôn callong luaih cơt sút tớq mít mái.” ");
INSERT INTO pac_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dyơ Si-môn ôi Phi-er idô: “Seq mái cớu nga Yang Arbang-pilŏ́ng choi cư, dyôn máh arnáq ngki êq tớq nga cư.” ");
INSERT INTO pac_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Cua Phi-er alứng Yon cato parnai Yang Arbang-pilŏ́ng tớq vúng Sa-mari, alứng cato te máh arnáq Yê-su táq arớq nha-án khoiq hôm, nha-án chô lieh nga vel Yaru-salem. Ndóng nha-án pôq na carna, nha-án mot cato parnai ŏ te Yang Arbang-pilŏ́ng tớq máh vel át paniar carna vúng Sa-mari. ");
INSERT INTO pac_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bôn mui tarneng tớq tông Phi-lip idô: “Mái thuan, dyơ pôq anga tadưp. Mái pôq tớq carna te vel Yaru-salem pôq nga vel Casa, la carna pôq cláh báng tupứng ntúq aih.” ");
INSERT INTO pac_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Iki Phi-lip yôr tayứng, dyơ pôq. Tớq carna án hôm munáq conh te cruong Ê-thie-bi. Conh ndô la ticuoi dyưng ati puo cán tớq cruong Ê-thie-bi. Án kiaq me máh ntưn puo cán, nốh Candac. Conh ndô khoiq pôq sang tám Yang Arbang-pilŏ́ng tớq vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ma hoi-ndô án chô nga cruong án na kien aséh. Án át tớq kien aséh alứng án dŏc tám uráq Ê-sai la ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh. ");
INSERT INTO pac_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Arvai Yang Arbang-pilŏ́ng tông Phi-lip idô: “Mái tarveng ticuoi ndon át tớq kien aséh.” ");
INSERT INTO pac_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Phi-lip tarveng; dyơ án atôm kien aséh. Án sáng ticuoi ndon át tớq kien aséh ngki dŏc tám uráq Ê-sai. Iki án plốh ticuoi ngki idô: “Máh callong mái khoiq dŏc, mái apúh lớiq?” ");
INSERT INTO pac_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Conh ngki ôi Phi-lip idô: “Imo têq cư apúh, co lớiq bôn ngai cato cư.” Iki án mơi Phi-lip sớr át tớq kien aséh, alứng ticu munơi alứng án. ");
INSERT INTO pac_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Conh ngki dŏc tớq tám uráq Ê-sai, idô: “Ngai dông ticuoi ndô arớq ngai dông pannán cưu ính kiac. Muchứng ngai kít sóc acái cưu, ma án át arngiac sớng, muchứng ngki tưi ticuoi ndô lớiq tacang amớh. ");
INSERT INTO pac_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Án lớiq bôn táq luaih amớh, ma ngai ayê alứng táq án. Ngai cachet án, alứng án ớq acái tŏ́ng, co ngai lớiq ính án bôn tumống nnáng tớq cúc cuteq ndô.” ");
INSERT INTO pac_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Cua án dŏc, án plốh Phi-lip idô: “Máh parnai Ê-sai tông ndô la án tông te nnáu? Án tông te cháq án bôm, lớiq la te ticuoi cannŏ́h? Seq mái tông cư hơ.” ");
INSERT INTO pac_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dyơ Phi-lip luoh ngcang cato parnai ŏ te Yê-su. Tôm lư án tông arlớih lư dyôn ticuoi ngki chom parnai ndô la Ê-sai taran te Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ndóng nha-án pôq na carna, dyơ nha-án tớq nga ntúq bôn dơq. Ticuoi Ê-thie-bi tông idô: “Tíh! Mái me dơq ngki. Têq mái táq tíc na dơq dyôn cư hoi-ndô, ma lớiq?” ");
INSERT INTO pac_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Phi-lip ôi án: “Khán mái tin nhéq tarngứh tarhơ, cư têq táq tíc na dơq dyôn mái.” Ticuoi ngki ôi: “Lư cư tin Yê-su Crit la Acái Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Iki ticuoi Ê-thie-bi dyôn kien aséh trín tumán dơq. Dyơ nha-án bar náq siar nga dơq, alứng Phi-lip táq tíc na dơq dyôn án. ");
INSERT INTO pac_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tư nha-án sớr te dơq, Arvai Yang Arbang-pilŏ́ng arơq dông Phi-lip nga ntúq cannŏ́h loi. Ticuoi Ê-thie-bi lớiq hôm nnáng Phi-lip, ma án pôq nưm munáq án táp na carna ngki, alứng mít án sáng bui lư. ");
INSERT INTO pac_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma Yang Arbang-pilŏ́ng achúh Phi-lip tớq vel Asô-tut. Dyơ Phi-lip cato parnai ŏ te Yê-su Crit tớq cứp vel paniar carna án pôq tingôi tớq nga vel Sê-sarê. ");
INSERT INTO pac_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma Salơ yôl sáng uan lư ada top veng tapun Yê-su, alứng ính cachet nhéq top ngki. ");
INSERT INTO pac_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Iki án pôq seq chớiq te ariaih top teng rit sang dyôn án têq cŏp máh ticuoi tin díh conh, díh cán, ndon át tớq vel Damac. Án ính apáh chớiq ndô dyôn ticuoi sút máh dúng rum ticuoi Isa-ra-el tớq vel Damac chom arlớih lư án têq cŏp ticuoi. Ticuoi ndon án ính cŏp la top veng tapun Yê-su; án ính chóq nha-án alứng dông nga vel pưt Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tư ticuoi sút dyôn Salơ bôn chớiq, dyơ án pôq. Ndóng án pôq na carna tumán ính tớq vel Damac, án ticớr hôm ang claq asiar te pilŏ́ng nga án. ");
INSERT INTO pac_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Án dứm tớq cuteq, alứng án sáng sieng tubau idô: “Salơ ơi! Ơ Salơ! Imo mái táq cư?” ");
INSERT INTO pac_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Salơ ôi: “Ưlla ơi! Inha la nnáu?” Sieng ngki ôi án: “Cư la Yê-su, án ndon mái táq dieiq arức. ");
INSERT INTO pac_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mái yôr táp, alứng mot tớq vel. Tớq vel ngki bôn ticuoi tông dyôn mái chom amớh mái cóq táq.” ");
INSERT INTO pac_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Máh ticuoi pôq alứng Salơ sáng dut lư, lớiq têq tacang amớh nnáng; nha-án sáng sieng ma lớiq hôm nnáu. ");
INSERT INTO pac_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dyơ Salơ yôr tayứng. Tư án caplang, mát án cơt sot. Iki yớu án tec chuor amot nga vel Damac. ");
INSERT INTO pac_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nhéq pe ingái án lớiq bôn hôm amớh, alứng án lớiq cha ngoiq. ");
INSERT INTO pac_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tớq vel Damac, bôn munáq te top veng tapun Yê-su, nốh A-nanie. Yang Arbang-pilŏ́ng apáh dyôn A-nanie hôm Yê-su. Yê-su arô án idô: “A-nanie ơi!” A-nanie ôi Yê-su: “Ơq Ưlla. Amớh Ưlla ính cư táq?” ");
INSERT INTO pac_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yê-su tông án idô: “Cóq mái pôq hoi-ndô táp nga carna ngai dŏq Carna Tinớng; mái suo munáq conh te vel Tarsơ, nốh Salơ. Án át tớq dúng Yuda. Hoi-ndô Salơ cớu seq nga cư. ");
INSERT INTO pac_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Alứng Yang Arbang-pilŏ́ng khoiq apáh dyôn Salơ hôm munáq conh, nốh A-nanie, tớq capơiq tớq cháq án dyôn mát án têq cơt plang lieh.” ");
INSERT INTO pac_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A-nanie ôi idô: “Ưlla ơi! Cư khoiq sáng ngai táq-ntêr te ticuoi ndô, án khoiq táq dieiq arức lư top inha tớq vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Alứng hoi-ndô án bôn chớiq te máh ticuoi sút top teng rit sang, dyôn án têq cŏp máh ticuoi tin Ưlla tớq vel Damac ndô.” ");
INSERT INTO pac_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ma Yê-su tông án idô: “Cóq mái pôq táq arớq cư khoiq yua mái, co cư khoiq rêh ticuoi ndô. Cư dyôn án dông nốh cư dyôn cơt parhanh cứp ntúq chôp cruong ticuoi Isa-ra-el alứng ticuoi tới ticuoi Isa-ra-el, díh nga máh puo nha-án hơ. ");
INSERT INTO pac_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Cư ính dyôn án chom máh arnáq dieiq arức án cóq chiuq, co án cliau nốh cư.” ");
INSERT INTO pac_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iki A-nanie pôq alứng mot tớq dúng Yuda. Án capơiq tớq cháq Salơ, alứng án tông Salơ idô: “Salơ ơi! Mái la em ai cư. Ưlla he Yê-su khoiq tumúh mái tớq carna. Án yua cư tớq nga mái, dŏq táq dyôn mát mái cơt plang lieh, alứng án dyôn Arvai án cơt sút tớq mít mái.” ");
INSERT INTO pac_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ndóng ngki táp, arớq atôh mbớr ndon táq dyôn mát án sot, dyơ mát án cơt plang lieh. Án yôr tayứng alứng ráp tíc na dơq. ");
INSERT INTO pac_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Án cha lieh dôi, alứng án sáng bánh rêng lieh. Dyơ án át tớq vel Damac alứng top veng tapun Yê-su, biq ingái loi. ");
INSERT INTO pac_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dyơ Salơ pôq táp nga dúng rum ticuoi Isa-ra-el, alứng án cato te Yê-su la lư Acái Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nhéq máh ticuoi ndon sáng parnai án cato, nha-án sáng dut lư. Alứng nha-án tông idô: “Án ndô lớiq, khoiq talóh top veng tapun Yê-su tớq vel Yaru-salem? Alứng án tớq nga tudô co ính cŏp máh ticuoi ndon veng tapun Yê-su. Án ính chóq alứng dông nha-án nga máh ticuoi sút top teng rit sang.” ");
INSERT INTO pac_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ma parnai Salơ cato cơt sit asớr. Tư top Isa-ra-el át tớq vel Damac sáng án cato te Yê-su, la munáq ndon Yang Arbang-pilŏ́ng rêh dŏq choi tamống ticuoi, iki nha-án lớiq têq tarmien nnáng. ");
INSERT INTO pac_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Vít ngki, máh ticuoi sút top Isa-ra-el tanghúng ính cachet Salơ. ");
INSERT INTO pac_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nha-án côn tớq máh ngáh callống carrống vel, ính cachet án. Ma án sáng ngai táq-ntêr nha-án ính cachet án. ");
INSERT INTO pac_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Iki tớq idáu, top veng tapun Yê-su sớr tớq carrống. Nha-án dyôn Salơ át tớq atéh, dyơ nha-án atiar án asiar nga pa culái tieh carrống vel. ");
INSERT INTO pac_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tư Salơ tớq nga vel Yaru-salem, án ính mot rum alứng top veng tapun Yê-su tớq vel ngki. Ma top ngki adáh án, co nha-án lớiq náp án khoiq tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma Ba-naba pôq asuoi Salơ nga top dyưng ati Yê-su. Alứng án tông dyôn nha-án chom Salơ khoiq hôm Yê-su tớq carna alứng khoiq sáng Yê-su tông Salơ. Án tông Salơ khoiq cato parnai ŏ te Yê-su clŏ́q lư tớq vel Damac. ");
INSERT INTO pac_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Co iki nha-án dyôn Salơ át alứng nha-án tớq vel Yaru-salem. Salơ pôq chôp vel Yaru-salem, alứng án cato clŏ́q lư parnai ŏ te Yê-su Crit. ");
INSERT INTO pac_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Án cato alứng tanghúng nha mui top ticuoi Isa-ra-el ndon táq-ntêr parnai Créc. Ma máh ticuoi ngki sisuo ngê ính cachet án. ");
INSERT INTO pac_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tư top veng tapun Yê-su sáng iki, nha-án dông Salơ nga vel Sê-sarê loi. Tớq ingái tatun, nha-án dyôn án sớr tớq tuoc alứng chô lieh nga vel án bôm la vel Tarsơ. ");
INSERT INTO pac_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Vít ngki máh top tin tớq vúng Yudê, vúng Ca-lilê, alứng vúng Sa-mari, lớiq bôn tumúh nnáng dieiq arức. Nha-án sŏ́ng mui mít munáq catớih tông munáq te ngê Yê-su. Alứng Arvai Yang Arbang-pilŏ́ng khêr mít nha-án dyôn sáng ien ŏ lieh. Ticuoi tin Yê-su cơt clứng lư loi, alứng nha-án dyám náp Ưlla. ");
INSERT INTO pac_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ndóng ngki Phi-er báq lư pôq alang cứp ntúq ndon bôn ticuoi tin tớq máh vúng ngki. Iki án pôq alang top tin Yê-su tớq vel Li-da. ");
INSERT INTO pac_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tớq vel ngki Phi-er tumúh munáq conh, nốh Ê-nê, ndon a-ái cớng. Án bíq tớq nchiauq khoiq bôn ticol cumo dyơ. ");
INSERT INTO pac_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phi-er tông án idô: “Ê-nê ơi! Yê-su Crit táq dyôn mái cơt bánh. Mái yôr tayứng, alứng pom nchiauq mái!” Ndóng ngki táp Ê-nê yôr tayứng. ");
INSERT INTO pac_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nhéq máh ticuoi tớq vel Li-da alứng vúng Sarôn hôm Ê-nê cơt bánh. Iki nha-án tin Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tớq vel Yôp-pa bôn munáq cán tớq top tin, nốh Ta-butha. Tớq cang Créc nốh án la Dôr-ca. Cán ndô táq arnáq ŏ níc, alứng án choi a-ưi náq ticuoi kidit. ");
INSERT INTO pac_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ndóng ngki án a-ái, dyơ án cuchet. Yớu án ial dơq arau cháq án veng rit nha-án cơi táq. Cua nha-án arau, nha-án dŏq cumuiq ngki tớq callúng trơn bar tớq dúng. ");
INSERT INTO pac_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Vel Yôp-pa át tumán vel Li-da. Iki, tư top veng tapun Yê-su tớq vel Yôp-pa sáng hanh Phi-er át tớq vel Li-da, dyơ nha-án yua bar náq ticuoi pôq cớiq Phi-er. Nha-án seq Phi-er idô: “Seq mái tớq nga vel he hoi-ndô táp.” ");
INSERT INTO pac_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Iki Phi-er pôq alứng nha-án. Tư án tớq nga dúng, nha-án dông án sớr tớq callúng trơn bar. Bôn cán cammai clứng lư át tớq callúng ngki. Nha-án nhiem alứng angốh tampớc Dôr-ca khoiq dyih dyôn nha-án te nsuoi. ");
INSERT INTO pac_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phi-er yua nha-án ngốh te callúng ngki. Dyơ án chóh tarcol alứng cớu. Cua án cớu, án píh me nga cumuiq, alứng án tông idô: “Ta-butha ơi! Mái yôr tayứng!” Ndóng ngki táp cán ndon khoiq cuchet caplang lieh mát. Tư án hôm Phi-er, án yôr ticu. ");
INSERT INTO pac_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Phi-er tec ati án dyôn yôr tayứng. Dyơ Phi-er arô top veng tapun Yê-su alứng máh cán cammai. Án dông angốh cán ngki dyôn nha-án hôm, cán ngki khoiq tumống lieh. ");
INSERT INTO pac_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iki arnáq ndô cơt parhanh chôp vel Yôp-pa, alứng bôn clứng lư ticuoi mot tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phi-er át tớq vel Yôp-pa lớiq chom sếq ingái loi. Án át alứng munáq conh, nốh Si-môn. Si-môn la ticuoi thơq táq ngcár pannán dyôn cơt ŏ. ");
INSERT INTO pac_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tớq vel Sê-sarê bôn munáq conh, nốh Cor-nai. Án sút mui culám náq líng. Top líng ndô la mui phê te top ndon ngai dŏq top I-tali. ");
INSERT INTO pac_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cor-nai la ticuoi ŏ alứng khun. Án alứng nhéq abŏ́h án dyám náp alứng sang Yang Arbang-pilŏ́ng. Án ial práq choi máh ticuoi kidit. Án cớu seq níc nga Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bôn mui ingái, tớq pandang viet, Yang Arbang-pilŏ́ng apáh baih dyôn án hôm mui tarneng Yang Arbang-pilŏ́ng tớq nga án, alứng arô án idô: “Cor-nai ơi!” ");
INSERT INTO pac_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ma Cor-nai sáng adáh lư. Án me clớn níc nga tarneng ngki, alứng án plốh idô: “Ưlla ơi! Amớh inha ính bôn?” Tarneng ngki ôi án: “Yang Arbang-pilŏ́ng khoiq sáng dyơ máh parnai mái cớu seq. Alứng án khoiq chom te máh práq ndon mái choi ticuoi kidit. Co iki án ayư níc mái. ");
INSERT INTO pac_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hoi-ndô cóq mái yua ticuoi pôq suo munáq conh, nốh Si-môn, tớq vel Yôp-pa. Ngai dŏq án la Phi-er hơ. Mái seq án tớq nga dúng mái. ");
INSERT INTO pac_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ticuoi ưlla dúng Phi-er át, nốh Si-môn tưi. Án la ticuoi thơq táq ngcár pannán dyôn cơt ŏ. Dúng án tumán tor dơq ving-cavang.” ");
INSERT INTO pac_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tư tarneng ngki ngốh, Cor-nai arô bar náq prái tarráih án, alứng án arô munáq líng hơ. Ticuoi líng ndô dyám náp Yang Arbang-pilŏ́ng tưi, alứng án chóng ính choi Cor-nai. ");
INSERT INTO pac_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cor-nai tông pe náq ngki dyôn chom te máh parnai tarneng khoiq tông án. Dyơ án yua nha-án pôq nga vel Yôp-pa. ");
INSERT INTO pac_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Máh ingái parnô, tumán pandang tứng, pe náq ngki chón pôq na carna tumán vel Yôp-pa; Phi-er sớr tớq mpuong clúng dúng, án ính cớu ngki. ");
INSERT INTO pac_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ndóng ngki án sáng pinhaih pallúng. Ma ndóng án pớn ngai táq tanna, án hôm muoi arnáq Yang Arbang-pilŏ́ng apáh baih a-án. ");
INSERT INTO pac_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Án hôm pilŏ́ng arớq ngai pốh, alứng arớq prới chír lư; alứng arớq ngai chóq ntớng tớq puan tol prới ngki; dyơ ngai atiar asiar prới ngki te pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tớq prới ngki bôn cứp nốh pannán, ndon ticaq pôq, ndon pôq nhál-nhíc, alứng ndon pár. ");
INSERT INTO pac_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Alứng Phi-er sáng sieng tông án idô: “Phi-er ơi! Mái yôr tayứng. Máh pannán ndô têq mái cha. Pannán mmo mái ính cha, mái ial táq cha pannán ngki.” ");
INSERT INTO pac_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma Phi-er ôi idô: “Lớiq mmớh! Cư lớiq ính cha, Ưlla ơi! Te két tingôi pưt, cư lớiq nai cha crơng tanna lớiq práh veng rit Isa-ra-el.” ");
INSERT INTO pac_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma sieng ngki tông lieh Phi-er idô: “Nốh amớh Yang Arbang-pilŏ́ng khoiq táq práh, mái êq tông lớiq práh.” ");
INSERT INTO pac_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pe chư sieng ngki tông Phi-er iki. Dyơ prới ngki arớq ngai lúq asớr lieh nga pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phi-er sáng dut lư te máh nốh án khoiq hôm. Ndóng án át parngíh te arnáq ngki, nha-án pe náq te dúng Cor-nai bôn tumúh dúng Si-môn. Nha-án át tumán ngáh callống dúng Si-môn. ");
INSERT INTO pac_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nha-án tubau idô: “Bôn ticuoi nốh Si-môn Phi-er át tớq dúng ndô lớiq?” ");
INSERT INTO pac_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ndóng ngki Phi-er yôl parngíh te máh nốh án khoiq hôm, ma Arvai Yang Arbang-pilŏ́ng tông án idô: “Bôn pe náq ticuoi tớq nga tudô, nha-án ính tumúh mái. ");
INSERT INTO pac_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mái siar tumúh nha-án, alứng mái êq adáh amớh pôq alứng nha-án, co cư yua nha-án tớq nga tudô.” ");
INSERT INTO pac_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Iki Phi-er siar tumúh nha-án, alứng tông idô: “Cư la án ndon inha suo. Amớh inha ính bôn?” ");
INSERT INTO pac_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nha-án ôi: “He tớq nga tudô co Cor-nai ticuoi sút mui culám náq líng yua he tớq. Án la ticuoi tinớng ŏ alứng dyám náp Yang Arbang-pilŏ́ng. Nhéq máh ticuoi Isa-ra-el chom Cor-nai la ticuoi ŏ. Alứng tarneng Yang Arbang-pilŏ́ng yua án mơi mái pôq nga dúng án, dyôn án têq bôn sáng tưi te parnai mái cato.” ");
INSERT INTO pac_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Iki Phi-er mơi nha-án pe náq mot tớq dúng, alứng bíq mui idáu. Tớq ang iláih parnô, Phi-er alứng tupát náq te top veng tapun Yê-su tớq vel Yôp-pa pôq alứng pe náq conh ngki. ");
INSERT INTO pac_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Máh ingái parra loi, nha-án tớq nga vel Sê-sarê. Cor-nai át pớn nha-án tớq dúng. Cor-nai khoiq pachúng máh em ai alứng yớu ndon artoi lư dyôn tớq rum nga dúng án. ");
INSERT INTO pac_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tư Phi-er tớq, Cor-nai ngốh tumúh án. Alứng Cor-nai chóh tarcol cucúh án; Cor-nai parngíh án la yang. ");
INSERT INTO pac_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma Phi-er tec ati Cor-nai dyôn yôr tayứng, alứng tông idô: “Mái yôr tayứng. Cư la ticuoi muchứng mái tưi.” ");
INSERT INTO pac_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ndóng nha-án yôl táq-ntêr, nha-án mot tớq dúng. Ma Phi-er hôm clứng ticuoi rum tớq dúng ngki. ");
INSERT INTO pac_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Dyơ Phi-er tông nhéq máh nha-án idô: “Inha chom dyơ phep rit Isa-ra-el lớiq dyôn ticuoi Isa-ra-el artoi alứng ticuoi te cruong cannŏ́h. Ma Yang Arbang-pilŏ́ng khoiq tông cư, êq tông munáq ticuoi mmo lớiq práh veng rit. ");
INSERT INTO pac_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Co iki cư lớiq adáh tớq nga tudô. Hoi-ngki cư ính chom, co imo inha seq cư tớq nga tudô?” ");
INSERT INTO pac_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cor-nai ôi án idô: “Ingái ntre, cư cớu tớq dúng cư ndóng pandang viet arớq hoi-ngki. Ticớr bôn munáq ticuoi tayứng chứng mát cư. Án tớc tampớc ang-ưr lư, ");
INSERT INTO pac_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","alứng án tông cư idô: ‘Cor-nai ơi! Yang Arbang-pilŏ́ng khoiq sáng dyơ mái cớu, alứng án khoiq chom dyơ te máh arnáq mái choi ticuoi kidit. Co iki án ayư níc mái. ");
INSERT INTO pac_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hoi-ndô cóq mái yua ticuoi pôq nga vel Yôp-pa, alứng mơi munáq conh nốh Si-môn, ngai dŏq án la Phi-er hơ. Mái seq án tớq nga dúng mái. Hoi-ngki án át tớq dúng Si-môn, tor dơq ving-cavang. Si-môn la ticuoi thơq táq ngcár pannán dyôn cơt ŏ.’ ");
INSERT INTO pac_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ndóng ngki táp cư yua ticuoi pôq mơi mái dyôn tớq nga tudô. Iki, cư ơn lư mái bôn tớq nga tudô. Hoi-ngki Yang Arbang-pilŏ́ng hôm nhéq náq he ndon rum ndô ính cammáng máh parnai Yang Arbang-pilŏ́ng khoiq yua mái cato a he.” ");
INSERT INTO pac_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Cua Cor-nai tông iki, Phi-er tông nha-án idô: “Hoi-ndô cư chom arlớih arlêng, la Yang Arbang-pilŏ́ng táq dyôn nhéq tưh ticuoi li-arli nhéq. ");
INSERT INTO pac_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tớq cứp cruong, khán bôn ticuoi dyám náp Yang Arbang-pilŏ́ng alứng táq arnáq tinớng ŏ, án lư sáng bui cannính dyôn ticuoi ngki cơt acái acon án tưi. ");
INSERT INTO pac_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Inha khoiq chom dyơ Yang Arbang-pilŏ́ng dyôn parnai ŏ án nga ticuoi Isa-ra-el. Parnai ndô tông idô: Ticuoi mmo peh parnai ŏ te Yê-su Crit, mít cannính ticuoi ngki cơt ien ŏ níc. Yê-su Crit la Ưlla nhéq tưh ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Inha khoiq sáng dyơ te Yon, án tông máh ticuoi dyôn ráp tíc na dơq. Vít ngki Yê-su tabớq cato parnai ŏ te Yang Arbang-pilŏ́ng tớq vúng Ca-lilê. Cua ngki án cato tớq vúng Yudê loi. ");
INSERT INTO pac_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Inha chom Yê-su la ticuoi te vel Na-saret, alứng Yang Arbang-pilŏ́ng rêh án, alứng dyôn án bôn Arvai Yang. Iki án bôn chức pưt lư. Án pôq tudô pôq tuki dŏq táq arnáq ŏ, alứng chuih angốh yang saq te cháq ticuoi, co Yang Arbang-pilŏ́ng át alứng án. ");
INSERT INTO pac_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","He khoiq hôm máh arnáq Yê-su táq tớq cruong Isa-ra-el alứng vel Yaru-salem; iki he têq tông lieh dyôn inha chom. Top Isa-ra-el khoiq cachet Yê-su na tayŏ́ng tớq along calláng. ");
INSERT INTO pac_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ma catám ingái pe, Yang Arbang-pilŏ́ng dyôn Yê-su tumống lieh. Tư Yê-su tumống lieh, Yang Arbang-pilŏ́ng dyôn top he hôm lieh Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ma án lớiq dyôn nhéq tưh ticuoi hôm Yê-su. Án dyôn nưm nha-án ndon án khoiq rêh te nsuoi sớng bôn hôm. Tớq Yê-su bôn tumống lieh, nhéq top he bôn cha ngoiq munơi alứng Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yê-su yua top he pôq cato dyôn cứp náq ticuoi chom te án. Alứng án yua he cato dyôn ticuoi chom án la munáq ndon Yang Arbang-pilŏ́ng khoiq rêh dyôn sưq nhéq tưh ticuoi, díh ticuoi yôl tumống alứng ticuoi khoiq cuchet. ");
INSERT INTO pac_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nhéq máh ticuoi tang ngcang Yang Arbang-pilŏ́ng te inớh khoiq taran te arnáq Yê-su táq. Alứng nha-án tông ticuoi mmo tin Yê-su, lư Yang Arbang-pilŏ́ng táh luaih dyôn ticuoi ngki nhơ nốh Yê-su.” ");
INSERT INTO pac_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ndóng Phi-er yôl cato iki, Arvai Yang Arbang-pilŏ́ng mot cơt sút tớq mít máh ticuoi ndon cammáng Phi-er cato. ");
INSERT INTO pac_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tupát náq ndon tớq munơi alứng Phi-er te vel Yôp-pa, nha-án sáng dut lư ticuoi tới ticuoi Isa-ra-el bôn Arvai Yang Arbang-pilŏ́ng tưi. Tupát náq ngki la ticuoi Isa-ra-el ndon khoiq tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nha-án sáng máh ticuoi tớq dúng Cor-nai táq-ntêr tớq mmar cang, alứng ayô Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Dyơ Phi-er tông loi idô: “Máh ticuoi ndô bôn Arvai Yang Arbang-pilŏ́ng arớq he khoiq bôn te nsuoi. Lớiq bôn ngai têq catáng lớiq dyôn nha-án ráp tíc na dơq.” ");
INSERT INTO pac_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Iki Phi-er yua ngai táq tíc na dơq dyôn nha-án nhơ nốh Yê-su Crit. Nha-án ndon mbơiq ráp tíc na dơq seq Phi-er át alứng nha-án pe puan ingái loi. ");
INSERT INTO pac_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Vít ngki top mui chít la bar náq dyưng ati Yê-su alứng nhéq máh ticuoi tin tớq vúng Yudê, nha-án sáng ngai táq-ntêr ticuoi tới ticuoi Isa-ra-el khoiq tin parnai Yang Arbang-pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bôn mui top te ticuoi tin parngíh ticuoi mmo ính veng tapun Yê-su, cóq nha-án táq rit kít arớq ticuoi Isa-ra-el tưi. Tư Phi-er chô lieh nga vel Yaru-salem, nha-án tíq án ");
INSERT INTO pac_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","idô: “Mái khoiq pôq át alứng ticu cha munơi nha ticuoi iyốh táq rit kít.” ");
INSERT INTO pac_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ma Phi-er roih lieh dyôn nha-án chom te máh arnáq án khoiq hôm. ");
INSERT INTO pac_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Án tông idô: “Bôn mui ingái, ndóng cư át tớq vel Yôp-pa, cư pôq cớu. Dyơ Yang Arbang-pilŏ́ng apáh dyôn cư hôm arớq prới chír lư alứng arớq ngai chóq ntớng tớq puan tol tớq prới ngki, dyơ arớq ngai atiar asiar te pilŏ́ng nga cư. ");
INSERT INTO pac_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cư me alứng hôm arlớih lư prới ngki. Dyơ cư hôm cứp nốh pannán dúng alứng pannán cruong, ndon ticaq pôq, ndon pôq nhál-nhíc, alứng ndon pár. ");
INSERT INTO pac_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Alứng cư sáng sieng tông cư idô: ‘Phi-er ơi! Mái yôr tayứng. Máh pannán ndô mái têq cha. Pannán mmo mái ính cha, mái ial táq cha pannán ngki.’ ");
INSERT INTO pac_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ma cư ôi sieng ngki idô: ‘Lớiq mmớh! Cư lớiq ính cha, Ưlla ơi! Te két tingôi pưt, cư lớiq nai cha crơng tanna lớiq práh veng rit Isa-ra-el.’ ");
INSERT INTO pac_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ma sieng ngki tông lieh cư: ‘Nốh amớh Yang Arbang-pilŏ́ng khoiq táq práh, mái êq tông lớiq práh.’ ");
INSERT INTO pac_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Sieng ngki tông cư bôn pe chư. Vít ngki arớq ngai lúq asớr lieh prới ngki nga pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ndóng ngki táp bôn pe náq ticuoi te vel Sê-sarê át culái tieh dúng cư át. Nha-án tớq suo ính tumúh cư. ");
INSERT INTO pac_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Alứng Arvai Yang Arbang-pilŏ́ng tông cư êq adáh amớh pôq alứng nha-án. Iki bôn tupát náq em ai te top veng tapun Yê-su tớq vel Yôp-pa pôq alứng cư nga dúng Cor-nai. ");
INSERT INTO pac_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cor-nai tông he te arnáq án khoiq hôm tarneng Yang Arbang-pilŏ́ng palôh tớq dúng án. Tarneng ngki tông án idô: ‘Mái yua ticuoi pôq mơi Si-môn Phi-er dyôn tớq nga tudô; hoi-ngki án át tớq vel Yôp-pa. ");
INSERT INTO pac_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Phi-er ính tông mái alứng nhéq ticuoi tớq abŏ́h mái chom na amớh Yang Arbang-pilŏ́ng têq choi tamống inha.’ ");
INSERT INTO pac_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ndóng cư cato nha-án ndon rum tớq dúng ngki, Arvai Yang Arbang-pilŏ́ng mot cơt sút tớq mít nha-án, muchứng Arvai Yang Arbang-pilŏ́ng khoiq mot tớq mít he te nsuoi. ");
INSERT INTO pac_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tư ngki cư ayư lieh te parnai Yê-su khoiq tông he te nsuoi idô: ‘Yon táq tíc na dơq dyôn inha la na dơq sớng, ma urớh Yang Arbang-pilŏ́ng ính táq tíc na Arvai án táp dyôn inha.’ ");
INSERT INTO pac_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Co iki Yang Arbang-pilŏ́ng dyôn Arvai án nga ticuoi tới ticuoi Isa-ra-el hơ, muchứng án khoiq dyôn nga he ndon tin Yê-su Crit Ưlla he, te nsuoi tưi. Inha parngíh cư têq dyŏq Yang Arbang-pilŏ́ng lớiq dyôn táq iki, lớiq? Arnáq amớh án ính táq, ngki án táq.” ");
INSERT INTO pac_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tư top ngki sáng Phi-er tông iki, nha-án lớiq têq tíq amớh nnáng. Ma nha-án ayô Yang Arbang-pilŏ́ng idô: “Lư Yang Arbang-pilŏ́ng táp dyôn ticuoi tới ticuoi Isa-ra-el bôn pien cơt mít tamme loi, alứng án choi tamống nha-án tưi.” ");
INSERT INTO pac_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Vít ingái ngai cachet Satien, máh top veng tapun Yê-su chiuq a-ưi dieiq arức. Dyơ nha-án ngốh te vel Yaru-salem, án ndon pôq pitứng, án ndon pôq pitốq. Bôn ticuoi pôq nga cruong Phê-nasi, con Sip-rơ, alứng vel Anti-ôt. Ntúq mmo nha-án pôq, nha-án cato parnai ŏ te Yang Arbang-pilŏ́ng tớq ntúq ngki. Ma nha-án cato nưm ticuoi Isa-ra-el sớng. ");
INSERT INTO pac_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma tớq top veng tapun Yê-su, bôn máh conh te con Sip-rơ alứng cruong Si-rên, pôq nga vel Anti-ôt alứng cato parnai ŏ te Yê-su Ưlla he, dyôn ticuoi tới ticuoi Isa-ra-el chom tưi. ");
INSERT INTO pac_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yang Arbang-pilŏ́ng choi nha-án cato parnai ŏ te Yang Arbang-pilŏ́ng. Iki bôn clứng lư ticuoi mot tin alứng veng ngê Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tư top tin tớq vel Yaru-salem sáng ngai táq-ntêr bôn clứng ticuoi tớq vel Anti-ôt tin Yê-su, iki nha-án yua Ba-naba pôq alang vel Anti-ôt. ");
INSERT INTO pac_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tư Ba-naba tớq nga vel ngki, án hôm Yang Arbang-pilŏ́ng tốq a-ưi callong bún dyôn máh ticuoi tớq vel ngki. Iki án sáng bui tưi, alứng án patáp ticuoi tin tớq ngki dyôn tin khớm lư loi, alứng veng nưm ngê Yê-su sớng. ");
INSERT INTO pac_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ba-naba la ticuoi partát ŏ, alứng án tin Yê-su khớm lư. Alứng Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít án. Ndóng ngki bôn clứng ticuoi mot tin Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Vít ngki Ba-naba pôq suo Salơ nga vel Tarsơ. ");
INSERT INTO pac_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tư án tumúh Salơ, án dông Salơ pôq nga vel Anti-ôt. Nha-án át tớq ntúq ngki nhéq mui cumo, alứng rum munơi nha top tin Yê-su. Alứng nha-án cato top ngki a-ưi loi te parnai ŏ Yang Arbang-pilŏ́ng. Tớq vel ngki ngai mbơiq dŏq top veng ngê Yê-su la Top Yê-su Crit. ");
INSERT INTO pac_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tớq callúng máh ingái ngki, bôn máh ticuoi tang ngcang Yang Arbang-pilŏ́ng te vel Yaru-salem pôq nga vel Anti-ôt. ");
INSERT INTO pac_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bôn munáq te top ngki, nốh A-cabut. Án yôr tayứng alứng tông acớiq parnai te Arvai Yang Arbang-pilŏ́ng yua án tông. Án tông idô: “Tumán ính tớq ingái máh cruong tớq pưn pilŏ́ng crôp ndô ớq crơng tanna cha.” Dyơ tatun, máh arnáq ngki lư cơt arớq án khoiq tông, la ndóng Calôt cơt puo cruong Rô-ma. ");
INSERT INTO pac_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Iki top veng tapun Yê-su tớq vel Anti-ôt sŏ́ng dyôn práq nga yớu ndon veng tapun Yê-su tớq vúng Yudê. ");
INSERT INTO pac_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Máh-mmo nha-án bôn, nha-án choi máh ngki. Cua nha-án pachúng práq, dyơ nha-án yua Ba-naba alứng Salơ dông asuoi práq ngki nga ticuoi sút top veng tapun Yê-su tớq vúng Yudê. ");
INSERT INTO pac_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ndóng ngki puo Hê-rôt Acri-pa táq dieiq arức lư máh top tin. ");
INSERT INTO pac_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Án dyôn ngai tráh Yacơ ai Yon tớq dau. ");
INSERT INTO pac_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tư Hê-rôt dyôn ngai cachet Yacơ, iki ticuoi Isa-ra-el sáng bui lư. Tư án hôm ticuoi Isa-ra-el sáng bui te arnáq ndô; iki án cŏp Phi-er loi. Ingái ngki ticuoi Isa-ra-el Cha Beng Mi Ớq Bôt Pôih. ");
INSERT INTO pac_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Puo Hê-rôt crál Phi-er tớq coq tôt, alứng án yua líng mui chít tupát náq át kiaq Phi-er. Vít top Isa-ra-el cha ayư Ingái Ngốh, Hê-rôt ính cachet Phi-er loi. ");
INSERT INTO pac_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iki ngai crál Phi-er tớq coq tôt. Ma máh top tin cớu seq níc nga Yang Arbang-pilŏ́ng dyôn choi Phi-er. ");
INSERT INTO pac_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Idáu ngki nha-án kiaq Phi-er carsiat lư, co ingái parnô puo Hê-rôt ính cachet Phi-er. Nha-án dyôn Phi-er bíq pandi bar náq ticuoi líng. Nha-án clieng dyưng ati án tớq bar ntráih sic. Alứng bôn líng cannŏ́h kiaq ngáh callống coq tôt. ");
INSERT INTO pac_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma ticớr bôn tarneng Yang Arbang-pilŏ́ng palôh tớq coq tôt tumán Phi-er. Alứng bôn ang claq chôp callúng coq tôt. Tarneng ngki tampéh tớq nghang nnier Phi-er, pasớt án ayư, alứng tông án idô: “Mái yôr tayứng!” Ndóng ngki táp sic cơt tarcaq te ati Phi-er. ");
INSERT INTO pac_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Alứng tarneng ngki tông Phi-er idô: “Mái caléh lieh au alứng dếq cơp.” Cua Phi-er dếq cơp, tarneng ngki tông sa idô: “Mái sứp lieh au thor, dyơ veng cư.” ");
INSERT INTO pac_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Iki Phi-er ngốh veng tarneng ngki. Án lớiq chom arlớih, tarneng ngki dông án ngốh te coq tôt lớiq la mpáu sớng. ");
INSERT INTO pac_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ma nha-án pôq vít bar ntúq líng kiaq, dyơ nha-án tớq nga ngáh callống taq, ngốh nga pa tieh. Ma callống taq ngki tarpốh bôm; iki nha-án ngốh. Tư nha-án pôq na carna, tarneng ngki pliep lớiq hôm nnáng. ");
INSERT INTO pac_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iki Phi-er chom arlớih lư, án lớiq bôn mpáu. Dyơ án parngíh idô: “Hoi-ngki cư chom arlớih arlêng te arnáq ndô la arnáq lư. Yang Arbang-pilŏ́ng dyôn tarneng tớq choi cư dyôn vít te puo Hê-rôt ính cachet, alứng dyôn vít te top Isa-ra-el ính táq cư.” ");
INSERT INTO pac_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ndóng Phi-er yôl parngíh te arnáq ngki, án tớq nga dúng Mari a-i Yon Mac. Bôn clứng ticuoi te top veng tapun Yê-su át rum cớu ngki. ");
INSERT INTO pac_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Phi-er acóh callống pa tieh dúng. Bôn munáq cán táq arnáq tớq dúng ngki, nốh Rô-da; án pôq me ính chom nnáu acóh callống. ");
INSERT INTO pac_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tư cán ndô acớl tammieng Phi-er, án sáng bui lư. Ma án clớiq pốh callống dyôn Phi-er mot, co hớp ính pôq táq-ntêr dyôn máh ticuoi tớq dúng chom. Alứng án tông idô: “Phi-er át tayứng pa tieh ngáh callống.” ");
INSERT INTO pac_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ticuoi tớq dúng ngki tông án idô: “Mái la yúh!” Ma án ôi lieh idô: “Lớiq! Án lư át culái tieh dúng.” Ma nha-án tông án sa idô: “Sieng ndô la sieng tarneng ndon bán kiaq Phi-er. Tới Phi-er.” ");
INSERT INTO pac_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma Phi-er acóh callống alứng arô sa dyôn nha-án pốh callống. Tư nha-án pốh callống, nha-án hôm Phi-er. Iki nha-án sáng dut lư. ");
INSERT INTO pac_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Phi-er avít ati dyŏq nha-án êq tacang, alứng án tông nha-án imo táp Yang Arbang-pilŏ́ng táq dyôn án bôn tarcláh te coq tôt. Dyơ án patáp nha-án idô: “Inha tông máh arnáq ndô dyôn Yacơ alứng máh em ai he chom tưi.” Cua ngki Phi-er ngốh pôq nga ntúq cannŏ́h loi. ");
INSERT INTO pac_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ang mbơiq sưm-turưm, líng kiaq coq tôt sáng crŏ́q lư, co nha-án lớiq chom imo Phi-er palláiq viang te coq tôt. ");
INSERT INTO pac_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Puo Hê-rôt yua ticuoi pôq arvớt Phi-er. Ma nha-án lớiq tumúh. Dyơ puo Hê-rôt plốh máh líng kiaq coq tôt, ma nha-án lớiq chom imo Phi-er bôn ngốh te coq. Iki Hê-rôt yua ngai cachet nhéq máh líng ngki. Vít ngki puo Hê-rôt ngốh te vúng Yudê, pôq át tớq vel Sê-sarê loi. ");
INSERT INTO pac_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tư Hê-rôt át tớq vel Sê-sarê, bôn mui top ticuoi te vel Tirơ alứng vel Sadôn ính tumúh án. Te nsuoi Hê-rôt uan lư ada máh ticuoi tớq bar vel ngki. Ma hoi-ndô nha-án ính artoi lieh alứng Hê-rôt, co ính bôn crơng tanna te cruong Hê-rôt, dŏq nha-án têq bôn tumống. Iki nha-án tớq táq-ntêr nsuoi alứng munáq dyưng ati puo Hê-rôt, nốh Ba-latut. Nha-án ính Ba-latut tông puo Hê-rôt chom nha-án ính át artoi lieh alứng puo. ");
INSERT INTO pac_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tớq ingái ngki puo Hê-rôt tớc tampớc dêu lư, alứng án ticu tớq kichơng puo. Án táq-ntêr ŏ lư ada ticuoi prái. ");
INSERT INTO pac_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tư máh ticuoi prái sáng án tông iki, nha-án tông yứng lư idô: “Parnai ndô tới parnai ticuoi, ma parnai yang.” ");
INSERT INTO pac_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ndóng ngki táp bôn munáq tarneng Yang Arbang-pilŏ́ng táq Hê-rôt dyôn cơt a-ái ớp lư. Bôn bor cha tớq pallúng án; dyơ án cuchet. Yang Arbang-pilŏ́ng táq Hê-rôt la co tian án lớiq dyám náp Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Vít ngki, parnai ŏ te Yang Arbang-pilŏ́ng cơt sit lư loi, alứng bôn clứng ticuoi mot tin. ");
INSERT INTO pac_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tư Ba-naba alứng Salơ táq cua nhéq arnáq choi yớu tớq vel Yaru-salem, dyơ nha-án píh chô lieh nga vel Anti-ôt. Nha-án dông díh Yon Mac pôq alứng nha-án. ");
INSERT INTO pac_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Top tin tớq vel Anti-ôt bôn máh ticuoi tang ngcang Yang Arbang-pilŏ́ng alứng máh ticuoi cannŏ́h hơ cato parnai ŏ te Yang Arbang-pilŏ́ng. Nốh nha-án la idô: Ba-naba, Si-mê-ôn (ngai dŏq Ni-yê hơ), Lusi-ut te cruong Si-rên, Mana-en (la arớq em ai puo Hê-rôt An-tipa, co ngai parléh nha-án munơi ndóng nha-án yôl ngai-acái), alứng Salơ. ");
INSERT INTO pac_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bôn mui ingái, ndóng nha-án sang tám Yang Arbang-pilŏ́ng alứng ót tanna, Arvai Yang Arbang-pilŏ́ng tông nha-án idô: “Inha rêh Ba-naba alứng Salơ dŏq mmar dyôn nha-án táq nưm máh arnáq cư yua.” ");
INSERT INTO pac_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Cua nha-án ót tanna alứng cớu, dyơ nha-án capơiq tớq Ba-naba alứng Salơ, alứng nha-án yua bar náq ngki pôq táq arnáq arớq Arvai Yang Arbang-pilŏ́ng khoiq yua. ");
INSERT INTO pac_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iki Ba-naba alứng Salơ ngốh te ngki, dyơ pôq nga vel Sê-lusi arớq Arvai Yang Arbang-pilŏ́ng yua nha-án. Te vel ngki nha-án pôq na tuoc nga con Sip-rơ. ");
INSERT INTO pac_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tư nha-án tớq nga con Sip-rơ, nha-án siar te tuoc tớq vel Sa-lamít. Dyơ nha-án mot tớq dúng rum ticuoi Isa-ra-el tớq vel ngki, co ính cato parnai ŏ te Yang Arbang-pilŏ́ng. Bôn díh Yon Mac hơ pôq alứng nha-án, dŏq tarchoi nha-án. ");
INSERT INTO pac_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Vít ngki nha-án pôq cláh con Sip-rơ dyôn tingôi tớq nga vel Baphô. Tớq vel Baphô, nha-án tumúh munáq ticuoi Isa-ra-el, nốh Bayê-su. Án la ticuoi mo alứng ticuoi táq náh-nnan tang ngcang Yang Arbang-pilŏ́ng. Bayê-su bôn nốh Ê-luma hơ. ");
INSERT INTO pac_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ê-luma la yớu Sê-yut Phalut, la ticuoi sút tớq con Sip-rơ. Sê-yut Phalut la ticuoi tubáiq lư; án arô Ba-naba nha Salơ tớq nga án, co án ính cammáng parnai ŏ te Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ma Ê-luma catáng, lớiq ính Sê-yut Phalut cammáng alứng tin parnai ŏ ngki. ");
INSERT INTO pac_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ma Salơ, ngai dŏq án nốh Phau-lô hơ, án me clớn níc nga Ê-luma. Alứng Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít án. ");
INSERT INTO pac_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Án tông ada Ê-luma idô: “Mái la ticuoi báq lứp yớu, alứng ính lư tarphíq tarthu. Mái la acái yang Satán. Mái ính pupít ngê tinớng ŏ. Imo mái lớiq ính ticuoi veng ngê tinớng ŏ te Yang Arbang-pilŏ́ng? ");
INSERT INTO pac_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Hoi-ndô Yang Arbang-pilŏ́ng táq dyôn mái cơt sot. Lớiq chom máh-mmo dưnh mái ớq bôn hôm pandang claq.” Ndóng ngki táp Ê-luma cơt sot. Dyơ án pupơr suo ticuoi ính ngai tec án. ");
INSERT INTO pac_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tư ticuoi sút hôm arnáq ngki, án sáng dut lư, alứng án tin Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Vít ngki Phau-lô alứng yớu án sớr lieh tớq tuoc, alứng ngốh te vel Baphô pôq nga vel Pêr-ca tớq cruong Bam-phuli. Át tớq vel ngki, Yon Mac lớiq pôq nnáng alứng nha-án, dyơ án chô lieh nga vel Yaru-salem. ");
INSERT INTO pac_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dyơ Ba-naba alứng Phau-lô ngốh te vel Pêr-ca pôq nga vel Anti-ôt tớq cruong Bi-sadi. Tớq Ingái Angô, nha-án bar náq mot rum tớq dúng rum ticuoi Isa-ra-el tớq vel ngki. ");
INSERT INTO pac_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Cua ngai dŏc uráq te phep rit Môi-se khoiq tông te inớh dyôn top Isa-ra-el, alứng cua ngai dŏc te tám uráq ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh, nha-án ndon cơt sút dúng rum ngki tông Ba-naba nha Phau-lô idô: “Em ai ơi! Khán inha bôn parnai ính catớih he ndon têq choi he dyôn cơt rêng asớr, seq inha tông dyôn top he chom tưi.” ");
INSERT INTO pac_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Iki Phau-lô yôr tayứng alứng avít ati lớiq dyôn nha-án tacang. Dyơ án tông nha-án idô: “Nhéq máh em ai ticuoi Isa-ra-el ơi! Alứng nhéq náq inha ndon dyám náp Yang Arbang-pilŏ́ng, seq inha cammáng. ");
INSERT INTO pac_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yang Arbang-pilŏ́ng ndon máh ticuoi Isa-ra-el sang, lư án táp khoiq rêh achúc achiac he te inớh. Ndóng nha-án át tớq cruong Ê-yip-tô, án khoiq dyôn nha-án cơt rứh clứng lư. Tư án dyôn top he ngốh te cruong Ê-yip-tô, cứp náq ticuoi chom án bôn chức pưt lư. ");
INSERT INTO pac_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Top Isa-ra-el át tớq ntúq aih nhéq puan chít cumo. Nha-án báq lư lớiq peh parnai Yang Arbang-pilŏ́ng, ma Yang Arbang-pilŏ́ng yôl tarchoi nha-án. ");
INSERT INTO pac_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Alứng tớq cruong Cana-an, Yang Arbang-pilŏ́ng pupít tupul top, dyơ dyôn top he loi bôn ưlla tám cuteq máh top ngki. ");
INSERT INTO pac_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Arnáq ngki cơt sám puan culám sông chít cumo. Vít ngki Yang Arbang-pilŏ́ng rêh ticuoi dŏq sưq top Isa-ra-el, tingôi tớq pang Samu-el la ticuoi tang ngcang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Cua ngki top Isa-ra-el seq Yang Arbang-pilŏ́ng dyôn nha-án bôn puo. Iki Yang Arbang-pilŏ́ng dyôn Salơ cơt puo nha-án. Salơ la acái conh Ki-sơ, top Bên-yamin, alứng án cơt puo puan chít cumo. ");
INSERT INTO pac_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Vít ngki Yang Arbang-pilŏ́ng táh Salơ, dyơ án chóh Davit loi cơt puo. Alứng án tông te Davit idô: ‘Davit acái conh Yê-sai, án bôn mui mít alứng cư. Amớh cư ính án táq, án lư táq ngki.’ ");
INSERT INTO pac_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Yang Arbang-pilŏ́ng khoiq par-ưq te nsuoi ính dyôn munáq te tŏ́ng toiq Davit tớq choi tamống ticuoi Isa-ra-el. Munáq ndô la Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ndóng Yê-su iyốh tớq, Yon khoiq tông ticuoi Isa-ra-el cóq ráp tíc na dơq, la táq tíc nha-án ngin luaih pien cơt mít tamme loi. ");
INSERT INTO pac_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tớq Yon táq máh arnáq Yang Arbang-pilŏ́ng yua án khoiq tumán cua dyơ, án tông idô: ‘Cư tới án ndon inha ngcong. Ma tatun, án ndon inha ngcong lư tớq. Cư lớiq crái díh léh ntár cơp te dyưng án, co chức cư két lư.’ ");
INSERT INTO pac_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Em ai ơi! He la te tŏ́ng toiq A-praham, alứng máh inha ndon dyám náp Yang Arbang-pilŏ́ng, Yang Arbang-pilŏ́ng dyôn he bôn parnai án, dŏq he tin án lư têq choi tamống ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ticuoi prái tớq vel Yaru-salem alứng máh ticuoi sút ndóng ngki, nha-án lớiq chom Yê-su la acái Yang Arbang-pilŏ́ng. Cứp Ingái Angô tớq dúng sang, nha-án dŏc tám uráq ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh, ma nha-án lớiq apúh. Ma tớq nha-án cachet Yê-su, nha-án táq dyôn cơt tarvớiq simớt ticuoi tang ngcang khoiq tông acớiq. ");
INSERT INTO pac_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Máh ticuoi tớq vel Yaru-salem suo callong luaih ính cachet Yê-su, ma nha-án lớiq tumúh mui callong luaih amớh têq cachet án. Ma nha-án át tarseq níc te Phi-lat dyôn nha-án cachet án. ");
INSERT INTO pac_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tớq nha-án bôn táq cua nhéq máh arnáq arớq ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh te Yê-su, dyơ nha-án alíh asiar cumuiq Yê-su te along calláng alứng dông tứp tớq ping. ");
INSERT INTO pac_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma Yang Arbang-pilŏ́ng dyôn Yê-su tumống lieh te cuchet, ");
INSERT INTO pac_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","alứng máh ticuoi ndon pôq alứng Yê-su te vúng Ca-lilê díh tớq vel Yaru-salem bôn hôm án a-ưi ingái. Hoi-ngki top ngki pôq cato ticuoi Isa-ra-el ndon iyốh chom te arnáq Yê-su khoiq táq. ");
INSERT INTO pac_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Iki he tớq cato parnai ndô dyôn inha chom tưi, la parnai Yang Arbang-pilŏ́ng khoiq par-ưq alứng achúc achiac he te inớh. ");
INSERT INTO pac_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tớq Yang Arbang-pilŏ́ng dyôn Yê-su tumống lieh, án táq dyôn tarpiaiq máh callong án khoiq ưq alứng achúc achiac he. Án khoiq tông máh callong ndô tớq phê bar tớq tám uráq Cứh Ayô. Án tông te Yê-su idô: ‘Mái la acái cư. Ingái ndô cư lư cơt A-ám mái.’ ");
INSERT INTO pac_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Alứng bôn mui ntúq loi tớq tám uráq, Yang Arbang-pilŏ́ng tông te Yê-su idô: ‘Cư dyôn mái bôn máh callong bún ndon cư khoiq ưq ada Davit te inớh.’ ");
INSERT INTO pac_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Alứng bôn ntúq cannŏ́h loi tớq tám uráq Cứh Ayô, Davit tông idô: ‘Inha lớiq dyôn án ndon práh ŏ, cơt abuoiq.’ ");
INSERT INTO pac_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ndóng Davit yôl tumống, án táq máh arnáq Yang Arbang-pilŏ́ng yua án táq. Ma tư án cuchet, ngai tứp án tớq ping achúc achiac án. Cháq án cơt abuoiq. ");
INSERT INTO pac_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma Yang Arbang-pilŏ́ng táq dyôn Yê-su tumống lieh, alứng cháq án lớiq bôn abuoiq amớh. ");
INSERT INTO pac_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Iki em ai ơi, cư ính inha chom arlớih lư, nưm munáq Yê-su táp têq táh luaih dyôn inha. ");
INSERT INTO pac_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Máh phep rit Môi-se dyôn inha lớiq têq táq dyôn inha cơt tinớng ŏ chứng mát Yang Arbang-pilŏ́ng. Ma ticuoi mmo tin Yê-su, ticuoi ngki lư cơt tinớng ŏ chứng mát Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iki inha me a-ŏ, dŏq inha têq viar vít te nốh dieiq arức ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq tông te inớh idô: ");
INSERT INTO pac_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Máh inha ndon ayê tar-ac parnai Yang Arbang-pilŏ́ng, cóq inha cammáng dyôn arlớih. Cóq inha sáng crŏ́q, co callong cuchet khoiq tớq dyơ, alứng cư ính táq arnáq tớq pang inha, ma inha lớiq tin, tam bôn ngai cato inha te arnáq ngki.’” ");
INSERT INTO pac_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tư Phau-lô alứng Ba-naba ngốh te dúng rum ngki, bôn ticuoi seq nha-án cato sa parnai ngki tớq Ingái Angô tatun. ");
INSERT INTO pac_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Cua nha-án rum, nha-án mmar chô. Ma bôn a-ưi náq te top Isa-ra-el alứng te top cannŏ́h ndon veng phep rit Isa-ra-el, nha-án pôq alứng Phau-lô nha Ba-naba. Iki Phau-lô alứng Ba-naba cato alứng patáp nha-án êq táh máh callong Yang Arbang-pilŏ́ng choi mat nha-án. ");
INSERT INTO pac_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tớq Ingái Angô tún tatun loi, nhéq máh ticuoi te vel ngki pôq rum, co ính cammáng parnai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tư ticuoi Isa-ra-el hôm clứng lư ticuoi rum, iki nha-án sáng a-ính lư, co nha-án lớiq ính ticuoi cammáng parnai Phau-lô. Dyơ nha-án pamat Phau-lô. ");
INSERT INTO pac_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ma Phau-lô alứng Ba-naba cato clŏ́q lư loi idô: “Cư cóq cato parnai Yang Arbang-pilŏ́ng dyôn inha ticuoi Isa-ra-el sáng nsuoi. Ma co inha lớiq ính cammáng, la arớq inha lớiq ính tumống níc-níc. Co iki, hoi-ngki he pôq cato ticuoi tới ticuoi Isa-ra-el loi. ");
INSERT INTO pac_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yang Arbang-pilŏ́ng táp yua he táq iki, alứng án tông idô: ‘Cư chóh inha dyôn cơt arớq callong ang dyôn ticuoi tới ticuoi Isa-ra-el, dyôn nhéq tưh ticuoi tớq cúc cuteq ndô bôn chom tưi cư ính choi tamống nha-án.’” ");
INSERT INTO pac_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tư ticuoi tới ticuoi Isa-ra-el sáng parnai ngki, nha-án sáng bui ơn lư, alứng nha-án ayô parnai Yang Arbang-pilŏ́ng. Máh ticuoi ndon Yang Arbang-pilŏ́ng arô dyôn têq tumống níc-níc, nha-án tin lư parnai ngki. ");
INSERT INTO pac_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Iki parnai Yang Arbang-pilŏ́ng cơt parhanh mưt-mư tớq cruong ngki. ");
INSERT INTO pac_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ma ticuoi Isa-ra-el pôq chachuoq ada máh ticuoi sút tớq vel alứng máh ticuoi ayáq ndon sang tám Yang Arbang-pilŏ́ng. Máh ayáq ngki, ngai dyám náp lư. Iki máh ticuoi Isa-ra-el chuih Phau-lô alứng Ba-naba dyôn ngốh te cruong cuteq nha-án. ");
INSERT INTO pac_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Co iki Phau-lô alứng Ba-naba tangkhír cuteq mbúi te dyưng, táq tíc ticuoi tớq vel ngki lớiq ính cammáng. Dyơ nha-án pôq nga vel I-cuni loi. ");
INSERT INTO pac_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma máh ticuoi khoiq tin tớq vel Anti-ôt sáng bui lư, alứng Arvai Yang Arbang-pilŏ́ng cơt sút tớq mít cannính nha-án. ");
INSERT INTO pac_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tư Phau-lô alứng Ba-naba tớq nga vel I-cuni, nha-án mot cato tớq dúng rum ticuoi Isa-ra-el. Parnai nha-án cato cơt sit lư. Iki clứng ticuoi te top Isa-ra-el alứng ticuoi tới ticuoi Isa-ra-el náp alứng tin Yê-su tưi. ");
INSERT INTO pac_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ma máh ticuoi Isa-ra-el ndon lớiq ính tin parnai Yang Arbang-pilŏ́ng, nha-án chachuoq ticuoi tới ticuoi Isa-ra-el dyôn uan ada máh ticuoi khoiq tin. ");
INSERT INTO pac_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Iki Phau-lô alứng Ba-naba át cato parnai Yang Arbang-pilŏ́ng dưnh lư tớq vel ngki. Nha-án cato clŏ́q lư. Alứng Yang Arbang-pilŏ́ng apáh dyôn ticuoi chom parnai nha-án chón cato la lư parnai Yang Arbang-pilŏ́ng, co án dyôn nha-án bôn chức têq táq arnáq sileh. ");
INSERT INTO pac_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ma máh ticuoi tớq vel ngki caryáh cơt bar top. Mui top ính veng top Isa-ra-el ndon lớiq tin. Ma mui top loi ính veng Phau-lô alứng Ba-naba. ");
INSERT INTO pac_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dyơ ticuoi Isa-ra-el ndon lớiq tin pôq tanghúng alứng ticuoi tới ticuoi Isa-ra-el nha máh ticuoi sút tớq vel, ính táq Phau-lô alứng Ba-naba, díh ial búl hơ ính tíq ada nha-án. ");
INSERT INTO pac_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ma tư Phau-lô alứng Ba-naba sáng iki, nha-án lúh viang te vel ngki, dyơ pôq nga cruong Lu-cani alứng mot tớq vel Lutra alứng Der-bơ díh máh vel paniar ngki hơ. ");
INSERT INTO pac_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nha-án cato parnai ŏ te Yê-su Crit tớq máh vel ngki. ");
INSERT INTO pac_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tớq vel Lutra bôn munáq conh dyuat dyưng te a-i án carnian án. Án lớiq têq pupôq. ");
INSERT INTO pac_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Án cammáng tưi parnai Phau-lô cato. Tư Phau-lô me clớn níc nga án, Phau-lô hôm án lư tin Yang Arbang-pilŏ́ng têq táq dyôn dyưng án cơt bánh. ");
INSERT INTO pac_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Iki Phau-lô yua án idô: “Mái yôr tayứng!” Yóiq táp án yôr. Dyơ án ticaq pôq. ");
INSERT INTO pac_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tư ticuoi clứng hôm Phau-lô táq arnáq ndô, nha-án sŏ́ng munơi tông yứng lư tớq cang nha-án bôm, la cang Lu-cani idô: “Nha-án bar náq ndô la yang ớiq! Yang palít cơt ticuoi.” ");
INSERT INTO pac_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dyơ nha-án anốh Ba-naba la yang Yubi-tơ. Ma nha-án anốh Phau-lô la yang Mer-curi, co án la ticuoi ng-hiel ngcang arớq yang ngki. ");
INSERT INTO pac_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Top sang yang Yubi-tơ, bôn mui lám parông tumán parngốh vel. Án ndon cadyiq tampức yang ngki dông carrŏ́q tangcáh alứng pier nga ngáh callống carrống vel, co ính tức Ba-naba alứng Phau-lô. ");
INSERT INTO pac_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tư Ba-naba alứng Phau-lô sáng top ngki ính sang nha-án, nha-án haq tampớc bôm táq tíc nha-án lớiq ính top ngki táq iki. Dyơ nha-án talúh nga ticuoi clứng, alứng tông yứng lư idô: “Em ai ơi! Imo inha ính tức he? ");
INSERT INTO pac_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","He la ticuoi muchứng inha tưi. He tớq tudô la ính cato inha parnai ŏ. Inha êq tutức nnáng yang cannŏ́h, co yang ngki lớiq têq choi inha. Ma cóq inha sang tám nưm Yang Arbang-pilŏ́ng sớng. Nưm án táp la Yang tumống níc. Nưm án táp teng pilŏ́ng, cuteq, dơq, alứng cứp nốh át tớq ngki. ");
INSERT INTO pac_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ndóng pang inớh, Yang Arbang-pilŏ́ng chiuq dyôn máh ticuoi veng ngê nha-án bôm. ");
INSERT INTO pac_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma Yang Arbang-pilŏ́ng yôl táq a-ưi tíc ŏ dyôn nhéq tưh ticuoi chom arlớih lư, án la Yang ndon sút pưt lư. Án dyôn inha bôn li puoq bo, bôn crơng tarnóh crái tớq ngư, alứng bôn khám crơng tanna. Iki mít inha sáng bui lư.” ");
INSERT INTO pac_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ma Phau-lô tumán ính pê te arnáq dyŏq nha-án êq tức án alứng Ba-naba. ");
INSERT INTO pac_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ma lớiq dưnh, top Isa-ra-el tớq te vel Anti-ôt cruong Bi-sadi, alứng te vel I-cuni. Nha-án tardông ticuoi prái veng nha-án, dyơ nha-án tíq búl ada Phau-lô co ính cachet viang án. Tư nha-án parngíh Phau-lô khoiq cuchet, dyơ nha-án lúq angốh án culái tieh vel. ");
INSERT INTO pac_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ma tớq top tin át rum paniar Phau-lô, iki Phau-lô yôr tayứng alứng mot lieh tớq vel. Máh ingái parnô loi, Phau-lô alứng Ba-naba ngốh te vel ngki, pôq nga vel Der-bơ. ");
INSERT INTO pac_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tớq vel Der-bơ, nha-án cato sa parnai ŏ te Yê-su Crit, alứng bôn clứng ticuoi tin Yê-su. Cua nha-án cato tớq vel Der-bơ, nha-án píh chô lieh nga vel Lutra, vel I-cuni, alứng vel Anti-ôt tớq cruong Bi-sadi. ");
INSERT INTO pac_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tớq máh vel ngki, Phau-lô alứng Ba-naba catớih máh ticuoi veng tapun Yê-su dyôn tin nhéq tarngứh tarhơ, alứng cadyiq dyôn khớm máh callong khoiq tin dyơ. Nha-án tông top ngki idô: “Khán he ính mot tớq ntúq Yang Arbang-pilŏ́ng sút, he cóq chiuq a-ưi nốh dieiq arức.” ");
INSERT INTO pac_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Phau-lô alứng Ba-naba rêh ticuoi dyôn cơt sút top tin tớq cứp vel. Nha-án rum cớu alứng ót tanna. Dyơ nha-án mŏp nga Yang Arbang-pilŏ́ng máh ticuoi ndon nha-án khoiq rêh, seq Yang Arbang-pilŏ́ng kiaq me máh ticuoi ngki, co máh ticuoi ngki tin Yang Arbang-pilŏ́ng khớm lư. ");
INSERT INTO pac_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Vít ngki Phau-lô nha Ba-naba pôq tilớt cruong Bi-sadi, dyơ tớq nga cruong Bam-phuli. ");
INSERT INTO pac_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nha-án mot tớq vel Pêr-ca, alứng cato parnai Yang Arbang-pilŏ́ng tớq vel ngki. Cua ngki nha-án mot tớq vel A-talie loi; dyơ nha-án sớr tớq tuoc chô lieh nga vel Anti-ôt, cruong Si-ri. ");
INSERT INTO pac_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Top tin tớq vel Anti-ôt khoiq rum cớu dyôn Phau-lô nha Ba-naba, ndóng nha-án iyốh pôq cato. Nsuoi nha-án ính pôq, top ngki khoiq cớu seq Yang Arbang-pilŏ́ng choi nha-án dyôn pôq táq arnáq Yang Arbang-pilŏ́ng. Hoi-ndô nha-án khoiq táq cua dyơ máh arnáq ngki. ");
INSERT INTO pac_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tư Phau-lô alứng Ba-naba tớq lieh nga vel Anti-ôt, nha-án pachúng lieh máh top tin, co ính tông máh top ngki chom tưi te máh arnáq Yang Arbang-pilŏ́ng khoiq choi nha-án. Alứng nha-án ính tông dyôn top ngki chom te Yang Arbang-pilŏ́ng dyôn ticuoi tới ticuoi Isa-ra-el tin tưi parnai án. ");
INSERT INTO pac_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Iki Phau-lô nha Ba-naba át dưnh alứng top veng tapun Yê-su tớq vel Anti-ôt, cruong Si-ri. ");
INSERT INTO pac_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Vít ngki bôn ticuoi te vúng Yudê tớq tông top tin tớq vel Anti-ôt idô: “Khán ticuoi mmo iyốh táq rit kít veng phep rit Môi-se, Yang Arbang-pilŏ́ng lớiq choi tamống ticuoi ngki.” ");
INSERT INTO pac_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Phau-lô alứng Ba-naba lớiq sŏ́ng te callong ngki. Iki nha-án tarmien hớp lư alứng top em ai te vúng Yudê. Dyơ máh top tin Yê-su tớq vel ngki yua nha-án bar náq, díh máh ticuoi cannŏ́h te top ngki pôq plốh top dyưng ati Yê-su alứng máh ticuoi sút top tin Yê-su nga vel Yaru-salem te callong ndô. ");
INSERT INTO pac_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Top tin tớq vel Anti-ôt pôq atớl Phau-lô nha Ba-naba alứng máh ticuoi cannŏ́h hơ dyôn vít parngốh vel, dyơ nha-án pôq nga vel Yaru-salem. Ndóng nha-án pôq nga vel Yaru-salem, nha-án pôq tilớt cruong Phê-nasi alứng vúng Sa-mari. Nha-án cato máh ticuoi ndon tin Yê-su tớq bar ntúq ngki dyôn chom tưi te ticuoi tới ticuoi Isa-ra-el tin Yê-su. Tư máh top tin sáng parnai ngki, top ngki sáng bui lư. ");
INSERT INTO pac_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tư top Phau-lô alứng Ba-naba tớq nga vel Yaru-salem, top tin tớq vel ngki, díh top dyưng ati Yê-su, alứng máh ticuoi sút cannŏ́h, carbánh carsuanh bui ŏ lư top ngki. Dyơ Phau-lô alứng Ba-naba táq-ntêr te máh arnáq Yang Arbang-pilŏ́ng khoiq dyôn nha-án táq. ");
INSERT INTO pac_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ma bôn ticuoi te top Pha-rasi ndon khoiq tin Yê-su tayứng ngki tưi, alứng tông idô: “Máh ticuoi tới ticuoi Isa-ra-el, khán nha-án ính veng ngê Yê-su, cóq nha-án táq rit kít, alứng veng máh callong Môi-se khoiq patáp top Isa-ra-el te inớh.” ");
INSERT INTO pac_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iki top dyưng ati Yê-su alứng máh ticuoi sút top tin Yê-su, parchúng tanghúng ính tituaiq lieh te arnáq ndô. ");
INSERT INTO pac_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nha-án tanghúng dưnh lư; dyơ Phi-er yôr tayứng alứng tông nha-án idô: “Em ai ơi! Inha khoiq chom dyơ te ndóng Yang Arbang-pilŏ́ng rêh cư pôq cato máh ticuoi tới ticuoi Isa-ra-el dyôn chom tưi te parnai ŏ te Yê-su Crit, alứng dyôn nha-án tin tưi parnai ngki. ");
INSERT INTO pac_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yang Arbang-pilŏ́ng chom nhéq tớq mít cannính ticuoi. Alứng tư Yang Arbang-pilŏ́ng dyôn ticuoi tới ticuoi Isa-ra-el bôn Arvai án muchứng án khoiq dyôn he, ngki án apáh dyôn he chom, án ính máh ticuoi tới ticuoi Isa-ra-el tin án tưi. ");
INSERT INTO pac_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Án amoih nha-án li-arli alứng he. Ticuoi mmo lư tin án, án táq dyôn mít ticuoi ngki cơt práh ŏ loi. ");
INSERT INTO pac_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ma hoi-ngki, co imo inha ính chim Yang Arbang-pilŏ́ng? Imo inha ính patot ticuoi tin ndon tới ticuoi Isa-ra-el cóq veng phep rit dieiq lư? Phep rit ndô, he alứng achúc achiac he te inớh, la lớiq rap táq veng. ");
INSERT INTO pac_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tới iki! He tin Yang Arbang-pilŏ́ng choi tamống he la nhơ te callong choi mat na Yê-su Ưlla he. Alứng Yang Arbang-pilŏ́ng táq muchứng ndô tưi dyôn máh ticuoi tới ticuoi Isa-ra-el ndon khoiq tin Yê-su.” ");
INSERT INTO pac_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Cua ngki top nha-án lớiq táq-ntêr nnáng, ma nha-án cammáng Ba-naba nha Phau-lô roih lieh te máh arnáq sileh Yang Arbang-pilŏ́ng khoiq táq, ndóng nha-án bar náq cato parnai án dyôn ticuoi tới ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cua nha-án bar náq tông iki, dyơ Yacơ loi tông idô: “Em ai ơi! Seq inha cammáng cư. ");
INSERT INTO pac_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Si-môn Phi-er khoiq tông he te máh arnáq Yang Arbang-pilŏ́ng rêh ticuoi tới ticuoi Isa-ra-el, la ính nha-án cơt acái acon Yang Arbang-pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Máh arnáq ndô cơt tarvớiq simớt parnai ticuoi tang ngcang Yang Arbang-pilŏ́ng khoiq taran te inớh idô: ");
INSERT INTO pac_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bôn mui ingái, cư lư tớq pangcra lieh cruong cuteq Davit, cơt arớq ngai pangcra mui láng dúng ndon khoiq rúng arlóh. Cư lư pangcra carrống vel dyôn cơt ŏ lieh arớq te nsuoi. ");
INSERT INTO pac_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Iki máh ticuoi tớq cứp cruong bôn têq veng ngê cư. Cư táq iki dyôn ticuoi tới ticuoi Isa-ra-el têq cơt top cư tưi. ");
INSERT INTO pac_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Máh arnáq ndô Yang Arbang-pilŏ́ng khoiq tông te inớh dyơ.’” ");
INSERT INTO pac_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yacơ tông loi idô: “Veng tarngứh cư la idô: Máh ticuoi tới ticuoi Isa-ra-el ndon ính veng ngê Yang Arbang-pilŏ́ng, he êq táq dieiq ada nha-án. ");
INSERT INTO pac_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ma cóq he taran chớiq catớih nha-án êq cha nnáng crơng ngai tutức. Khán tới campái cayieq êq bíq munơi. Êq cha sáiq pannán ngai éc, alứng êq cha aham. ");
INSERT INTO pac_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","He patáp iki, co cứp Ingái Angô ticuoi Isa-ra-el dŏc níc te phep rit Môi-se tớq dúng rum ticuoi Isa-ra-el tớq cứp vel, te pang inớh tingôi pang hoi-ngki.” ");
INSERT INTO pac_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Cua Yacơ tông iki, top dyưng ati Yê-su alứng máh ticuoi sút top tin sŏ́ng alứng Yacơ. Nha-án rêh Yuda Ba-saba alứng Si-la, la bar náq ndon cơt ticuoi sút tớq top tin Yê-su, alứng dyôn bar náq ndô pôq nga vel Anti-ôt alứng Phau-lô nha Ba-naba. ");
INSERT INTO pac_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Iki nha-án dông chớiq ngai khoiq taran idô: “Em ai ơi! He la top dyưng ati Yê-su alứng top tin Yê-su tớq vel Yaru-salem nha máh ticuoi sút top ngki, he taran chớiq ndô cơiq alang máh em ai he ndon tới ticuoi Isa-ra-el tớq vel Anti-ôt, cruong Si-ri, alứng cruong Si-lasi hơ. ");
INSERT INTO pac_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","He sáng hanh bôn ticuoi te top he khoiq tớq cato inha, dyơ táq dyôn inha cơt tambang parngíh. Ma he lớiq bôn yua nha-án pôq tông inha iki. ");
INSERT INTO pac_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Co iki, he sŏ́ng munơi yua bar náq te top he pôq alứng yớu he la Phau-lô nha Ba-naba, tớq alang inha. ");
INSERT INTO pac_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Lớiq chom sếq cantứq dyơ Ba-naba alứng Phau-lô chiuq ngai táq co tian nha-án dông parnai ŏ te Yê-su Crit Ưlla he. ");
INSERT INTO pac_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Iki he yua Yuda alứng Si-la pôq tông inha dyôn chom arlớih lư te parnai tớq chớiq ndô. ");
INSERT INTO pac_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Arvai Yang Arbang-pilŏ́ng khoiq choi he têq tanghúng te arnáq ndô; iki he sŏ́ng munơi, lớiq ính inha veng phep rit dieiq arức. Ma he taran dyôn inha pe puan nốh tớq chớiq ndô, dyôn inha táq veng la idô: ");
INSERT INTO pac_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Inha êq cha nnáng crơng tanna ngai khoiq tức. Êq cha aham. Êq cha sáiq pannán ngai éc. Khán tới campái cayieq êq bíq munơi. Khán inha peh máh callong patáp ndô, inha lư táq piaiq. Nhéq máh ngki táp he ính patáp inha. Seq Yang Arbang-pilŏ́ng dyôn inha át bánh suanh ien ŏ níc.” ");
INSERT INTO pac_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dyơ top tin Yê-su tớq vel pưt Yaru-salem yua Yuda nha Si-la pôq alứng Phau-lô nha Ba-naba nga vel Anti-ôt. Tư nha-án tớq nga vel ngki, nha-án pachúng top tin Yê-su alứng avôi chớiq nga top ngki. ");
INSERT INTO pac_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tư top ngki dŏc chớiq ngki, iki nha-án chom arlớih lư, dyơ nha-án sáng bui lư te parnai yớu catớih nha-án. ");
INSERT INTO pac_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Dyơ Yuda alứng Si-la tông top tin Yê-su tớq vel ngki dyôn tin khớm lư loi te ngê Yang Arbang-pilŏ́ng. Yuda alứng Si-la la ticuoi tang ngcang Yang Arbang-pilŏ́ng tưi. ");
INSERT INTO pac_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tớq Yuda alứng Si-la át ngki khoiq dưnh dyơ, top tin Yê-su carbánh carsuanh nha-án dyôn chô ien ŏ nga vel Yaru-salem, dŏq chô tumúh lieh máh ticuoi ndon yua nha-án pôq. ");
INSERT INTO pac_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ma Si-la yôl ính át lieh tớq vel Anti-ôt. ");
INSERT INTO pac_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Phau-lô alứng Ba-naba át lieh tớq vel Anti-ôt. Nha-án bar náq alứng clứng ticuoi cannŏ́h hơ cato níc parnai ŏ te Yê-su tớq vel ngki. ");
INSERT INTO pac_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Vít máh ingái ngki, Phau-lô pachôq Ba-naba idô: “He! He pôq alang lieh máh em ai he nga vel he khoiq pôq cato parnai ŏ te Yê-su ndóng nsuoi. He pôq me amớh nha-án táq pôq hoi-ngki.” ");
INSERT INTO pac_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ba-naba sŏ́ng pôq, alứng ính dông Yon Mac pôq alứng nha-án tưi. ");
INSERT INTO pac_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ma Phau-lô lớiq ính Yon Mac pôq alứng nha-án, co Yon Mac khoiq táh nha-án tớq cruong Bam-phuli te nsuoi, alứng lớiq ính choi nnáng arnáq nha-án. ");
INSERT INTO pac_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Iki Ba-naba alứng Phau-lô tarmien te callong ndô; dyơ nha-án mmar pôq. Ba-naba dông Yon Mac sớr tớq tuoc, dyơ pôq nga con Sip-rơ. ");
INSERT INTO pac_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ma Phau-lô dông Si-la pôq alứng án. Cua top tin Yê-su cớu seq Yang Arbang-pilŏ́ng choi nha-án, dyơ nha-án pôq tưi. ");
INSERT INTO pac_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nha-án pôq pha cruong Si-ri alứng cruong Si-lasi. Nha-án cato máh top tin Yê-su tớq cruong ngki dyôn tin khớm lư loi. ");
INSERT INTO pac_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Cua ngki Phau-lô alứng Si-la pôq lieh nga vel Der-bơ nha vel Lutra. Tớq vel Lutra, nha-án tumúh munáq ticuoi te top veng tapun Yê-su, nốh Ti-muthê. A-i Ti-muthê la ticuoi Isa-ra-el ndon khoiq tin Yê-su; ma a-ám Ti-muthê la ticuoi Créc. ");
INSERT INTO pac_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Top tin Yê-su tớq vel Lutra alứng vel I-cuni ayô Ti-muthê la ticuoi partát lư. ");
INSERT INTO pac_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Iki Phau-lô ính dông Ti-muthê pôq alứng nha-án. Ma nsuoi nha-án ính ngốh te vel ngki, Phau-lô dyôn Ti-muthê táq rit kít veng phep rit Isa-ra-el. Phau-lô táq tíc iki, co a-ưi ntúq nha-án ính pôq bôn a-ưi ticuoi Isa-ra-el. Alứng Phau-lô adáh ticuoi ngki lớiq êm ada Ti-muthê, co ticuoi ngki chom a-ám án la ticuoi Créc, tới ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tư nha-án mot tớq máh vel, nha-án táq-ntêr dyôn top tin Yê-su chom te puan nốh ndon top dyưng ati Yê-su alứng máh ticuoi sút top tin Yê-su tớq vel Yaru-salem khoiq anát dyôn ticuoi tới ticuoi Isa-ra-el cóq táq veng. ");
INSERT INTO pac_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iki top tin tớq máh vel ngki tin khớm lư loi. Alứng cứp ingái bôn a-ưi náq ticuoi mot tin. ");
INSERT INTO pac_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Arvai Yang Arbang-pilŏ́ng lớiq dyôn Phau-lô alứng yớu án mot cato parnai ŏ te Yê-su Crit tớq cruong Asie. Iki nha-án pôq nga cruong Phu-rayie alứng cruong Ca-lati. ");
INSERT INTO pac_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tư nha-án tớq nga carlớn cruong Mi-sie, nha-án ính mot tớq cruong Bi-thuni, ma Arvai Yê-su lớiq dyôn nha-án mot. ");
INSERT INTO pac_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Iki nha-án pôq tilớt cruong Mi-sie, dyơ mot tớq vel Trô-at. ");
INSERT INTO pac_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tớq idáu, Yang Arbang-pilŏ́ng apáh baih dyôn Phau-lô hôm munáq conh te cruong Ma-sadôn. Ticuoi ngki tayứng alứng tarseq te Phau-lô idô: “Seq mái tớq nga cruong Ma-sadôn choi he hơ!” ");
INSERT INTO pac_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tư Phau-lô hôm conh ngki, Phau-lô alứng yớu án, díh cư Luca, thuan pôq nga cruong Ma-sadôn. He chom arlớih lư, Yang Arbang-pilŏ́ng ính he pôq cato parnai ŏ te Yê-su Crit tớq cruong ngki. ");
INSERT INTO pac_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Dyơ he sớr tớq tuoc tớq vel Trô-at ính pôq nga con Samô-trasơ. Máh ingái parnô loi, he tớq nga vel Nie-buli, tớq cruong Ma-sadôn. ");
INSERT INTO pac_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tớq he siar te tuoc, he pôq nga vel Phi-lip la vel pưt tớq cruong Ma-sadôn, ndon ticuoi Rô-ma cơt sút. He át tớq vel ngki bar pe ingái. ");
INSERT INTO pac_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tớq Ingái Angô, he ngốh te vel alứng pôq nga dơq soq, la ntúq top Isa-ra-el báq rum cớu tumán tor dơq. He ticu alứng cato parnai ŏ te Yê-su Crit dyôn máh cán ndon rum ngki cammáng. ");
INSERT INTO pac_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tớq top ngki bôn munáq cán te vel Thie-turơ, nốh Li-die. Án táiq prới ntứm eng ŏ lư. Án la ticuoi sang Yang Arbang-pilŏ́ng tưi, alứng Yang Arbang-pilŏ́ng pốh mít án dyôn náp ial máh parnai Phau-lô cato. ");
INSERT INTO pac_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Iki Li-die alứng nhéq abŏ́h án ráp tíc na dơq. Cua ngki án seq te he idô: “Khán inha náp cư lư tin Yê-su, ngki cư seq inha mot át tớq dúng cư.” Co án tarseq níc dyôn he mot át dúng án, iki he mot nga dúng án. ");
INSERT INTO pac_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bôn mui ingái, ndóng he pôq nga ntúq he báq rum cớu, he tumúh munáq cán sol ndon bôn yang saq piyúh án. Cán ndô cơt mo mammưl, alứng máh ưlla án bôn práq a-ưi lư nhơ te arnáq án táq. ");
INSERT INTO pac_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Án veng Phau-lô alứng he, alứng án tông yứng lư idô: “Ticuoi ndô táq arnáq Yang Arbang-pilŏ́ng ndon sút clưi nhéq te cannŏ́h, alứng nha-án cato inha te ngê Yang Arbang-pilŏ́ng têq choi tamống inha.” ");
INSERT INTO pac_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Cán ndô tông níc iki khoiq a-ưi ingái. Iki Phau-lô sáng pê cammáng án át tông níc arớq iki; dyơ Phau-lô píh me nga án, alứng tông ada yang saq idô: “Nhơ nốh Yê-su Crit, cư yua mái ngốh táp te cháq cán ndô.” Tư Phau-lô tông iki, yang saq ngốh táp te cháq cán ngki. ");
INSERT INTO pac_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tư máh ticuoi ưlla cán ngki chom nha-án lớiq bôn nnáng práq te cán ngki cơt mo mammưl, iki nha-án cŏp Phau-lô alứng Si-la. Nha-án lúq angốh bar náq ngki nga ntúq ticuoi sút át. ");
INSERT INTO pac_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tớq nha-án tumúh ticuoi sút; nha-án tông idô: “Bar náq ndô la ticuoi top Isa-ra-el. Hoi-ngki nha-án tardông clứng ticuoi tarchơiq tớq vel he. ");
INSERT INTO pac_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nha-án cato phep rit ndái te phep rit cruong he. He la ticuoi Rô-ma; he lớiq têq veng phep rit nha-án cato.” ");
INSERT INTO pac_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Máh ticuoi prái rum munơi ính táq Phau-lô alứng Si-la. Alứng ticuoi sút ngki yua ngai puar nhéq tampớc nha-án alứng tính. ");
INSERT INTO pac_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Cua ngai tính ớp lư, dyơ nha-án nhát amot tớq coq tôt. Alứng ticuoi sút patáp án ndon sút coq tôt, cóq kiaq dyôn a-ŏ bar náq ndô. ");
INSERT INTO pac_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iki ticuoi sút coq ngki crál Phau-lô alứng Si-la tớq mui callúng coq tôt ndon khớm lư. Án tacáp anúh tớq dyưng nha-án bar náq ngki. ");
INSERT INTO pac_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Idáu ngki tớq tardi dáu, Phau-lô nha Si-la cớu alứng cứh ayô Yang Arbang-pilŏ́ng. Máh ticuoi tôt tớq coq ngki sáng nha-án táq iki. ");
INSERT INTO pac_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ma ndóng ngki táp cuteq cacưt hớp lư. Coq tôt la cơt cacưt nhéq, alứng máh ngáh callống coq cơt arớq ngai pốh. Máh sic ngai tacáp ticuoi tôt cơt tarcaq nhéq. ");
INSERT INTO pac_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tư ticuoi sút coq tôt ayư, án hôm ngáh callống tarpốh. Iki án thot dau te sŏr ính chớt cháq án bôm, co án parngíh máh ticuoi tôt khoiq tarcláh nhéq dyơ. ");
INSERT INTO pac_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ma Phau-lô tông yứng lư idô: “Mái êq dyáq! Nhéq náq he yôl át tớq coq!” ");
INSERT INTO pac_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dyơ ticuoi sút coq ngki arô ngai dông tabong tabal nga án. Án lúh amot nga coq chái lư. Án sáng crŏ́q alứng dyandyír. Án chóh tarcol chứng mát Phau-lô alứng Si-la. ");
INSERT INTO pac_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Án dông angốh nha-án te coq, alứng án plốh idô: “Yớu ơi! Cư cóq táq amớh dyôn têq bôn tumống níc-níc?” ");
INSERT INTO pac_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nha-án ôi án idô: “Cóq mái tin Yê-su Ưlla he, dyơ mái alứng abŏ́h mái, lư bôn tumống níc-níc.” ");
INSERT INTO pac_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Cua ngki nha-án cato parnai ŏ te Yê-su dyôn án alứng máh ticuoi tớq abŏ́h án cammáng. ");
INSERT INTO pac_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Idáu ngki yôl tardi dáu, ticuoi sút coq dông tarháu palai bác nha-án. Cua án palai, án alứng nhéq náq tớq abŏ́h án ráp tíc na dơq. ");
INSERT INTO pac_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Cua ngki án dông Phau-lô alứng Si-la mot tớq dúng án, alứng án angốh crơng tanna dyôn nha-án cha. Án alứng nhéq abŏ́h án tin Yang Arbang-pilŏ́ng; iki nha-án sáng bui hơr lư. ");
INSERT INTO pac_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tớq ang iláih parnô, máh ticuoi sút tớq vel ngki yua ticuoi tampeng nha-án pôq tông ticuoi sút coq tôt dyôn taláh Phau-lô alứng Si-la. ");
INSERT INTO pac_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Dyơ ticuoi sút coq tôt tông Phau-lô idô: “Máh ticuoi sút yua cư taláh inha. Hoi-ngki inha ngốh te ndô. Tumo inha ính pôq, ngki inha pôq ien ŏ nư.” ");
INSERT INTO pac_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ma Phau-lô tông lieh máh tampeng ngki idô: “He la ticuoi Rô-ma tưi. Te nsuoi máh ticuoi sút iyốh chom callong luaih, ma imo nha-án tính he ớp lư dyôn clứng ticuoi hôm. Alứng nha-án crál he tớq coq tôt. Ma hoi-ngki nha-án ính taláh he, ma nha-án táq clôp, lớiq ính ticuoi cannŏ́h chom. He lớiq sŏ́ng te arnáq nha-án táq iki. Nha-án táq lớiq crái ada he ticuoi Rô-ma. Khán nha-án ính taláh he, cóq nha-án tớq taláh bôm.” ");
INSERT INTO pac_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Dyơ máh ticuoi tampeng dông máh parnai Phau-lô tông ngki atớq nga ticuoi sút. Tư máh ticuoi sút chom Phau-lô alứng Si-la la ticuoi Rô-ma, iki nha-án sáng adáh lư. ");
INSERT INTO pac_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Dyơ máh ticuoi sút ngki pôq táp nga coq tôt seq luaih Phau-lô alứng Si-la, alứng seq nha-án ngốh viang te vel. ");
INSERT INTO pac_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Iki Phau-lô alứng Si-la ngốh te coq tôt alứng mot tớq dúng Li-die. Tớq dúng ngki, nha-án rum alứng khêr máh top tin Yê-su dyôn tin khớm lư. Cua nha-án khêr, nha-án ngốh te vel ngki. ");
INSERT INTO pac_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tư Phau-lô alứng Si-la pôq tilớt vel Amphi-bulit alứng vel Ablô-ni, dyơ nha-án mot vel Tê-salô-nica loi. Tớq vel ngki bôn mui láng dúng rum ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Cứp Ingái Angô, Phau-lô báq mot tớq dúng rum ticuoi Isa-ra-el. Co iki án mot dúng rum ngki, tớq vel ngki. Pe cantứq Ingái Angô, Phau-lô cato te tám uráq Yang Arbang-pilŏ́ng dyôn máh ticuoi rum ngki. ");
INSERT INTO pac_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Án tông nha-án dyôn chom te Crit ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống ticuoi, cóq chiuq a-ưi dieiq arức alứng chiuq ngai cachet; ma Crit lư tumống lieh. Alứng án tông nha-án idô: “Yê-su ndon cư tông dyôn inha chom, la Crit.” ");
INSERT INTO pac_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bôn ticuoi te top Isa-ra-el náp parnai ngki, dyơ nha-án veng ngê Phau-lô alứng Si-la. Bôn clứng ticuoi Créc ndon dyám náp Yang Arbang-pilŏ́ng mot tin Yê-su tưi. Alứng bôn a-ưi náq cán ndon ngai dyám tớq vel ngki la mot tin tưi. ");
INSERT INTO pac_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ma ticuoi Isa-ra-el ndon lớiq ính tin, nha-án sáng uan lư. Iki nha-án pôq suo ticuoi lới alứng ticuoi pla, dyôn chachuoq tớq vel ngki. Nha-án mot táp tớq dúng Yasôn, suo Phau-lô alứng Si-la co ính cŏp dông bar náq ngki nga ticuoi clứng. ");
INSERT INTO pac_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ma tư nha-án lớiq tumúh Phau-lô alứng Si-la tớq dúng Yasôn, iki nha-án cŏp Yasôn alứng máh ticuoi cannŏ́h ndon tin Yê-su. Nha-án lúq angốh top ngki dyôn át tayứng chứng mát ticuoi sút vel. Dyơ nha-án cauq Phau-lô alứng Si-la idô: “Bar náq ngki mot cruong mmo, nha-án tarchơiq tớq cruong ngki. Hoi-ngki nha-án mot tớq vel he loi. ");
INSERT INTO pac_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma Yasôn dyôn bar náq ngki át tớq dúng án. Nha-án khoiq táh phep rit puo Rô-ma, alứng nha-án tông bôn puo cannŏ́h loi cơt sút. Nốh puo ndô la Yê-su.” ");
INSERT INTO pac_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tớq máh ticuoi prái alứng ticuoi sút sáng callong nha-án cauq, iki nhéq máh nha-án chachuoq ntáng lư loi. ");
INSERT INTO pac_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Dyơ nha-án yua ngai pôq cŏ́h pôq ngin Yasôn alứng máh ticuoi tin Yê-su. Cua ngki nha-án taláh Yasôn alứng máh ticuoi tin Yê-su dyôn chô. ");
INSERT INTO pac_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tớq idáu ngki, top tin Yê-su yua Phau-lô alứng Si-la pôq nga vel Bê-rê. Tư nha-án tớq nga vel Bê-rê, nha-án mot tớq dúng rum ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ticuoi Isa-ra-el tớq vel ngki bôn mít lambŏt hơn te ticuoi tớq vel Tê-salô-nica. Nha-án cammáng alứng ính chom arlớih lư parnai Yang Arbang-pilŏ́ng. Iki nha-án rian tám uráq Yang Arbang-pilŏ́ng cứp ingái, co ính chom parnai Phau-lô cato crái tớq parnai Yang Arbang-pilŏ́ng, ma lớiq. ");
INSERT INTO pac_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","A-ưi náq ticuoi Isa-ra-el tớq vel ngki tin Yê-su; alứng bôn ticuoi Créc hơ tin, díh conh díh cán ndon ngai dyám náp tớq vel ngki. ");
INSERT INTO pac_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ma tư top Isa-ra-el tớq vel Tê-salô-nica sáng Phau-lô cato parnai Yang Arbang-pilŏ́ng tớq vel Bê-rê loi, iki nha-án pôq tapun nga vel ngki tưi, alứng chachuoq máh ticuoi vel ngki hơ. ");
INSERT INTO pac_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Iki top tin Yê-su tớq vel ngki dyôn Phau-lô ngốh táp, alứng pôq nga tor dơq ving-cavang. Ma Si-la alứng Ti-muthê yôl át tớq vel Bê-rê. ");
INSERT INTO pac_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bôn ticuoi pôq asuoi Phau-lô nga vel Athên. Tư nha-án ính píh chô, Phau-lô patáp nha-án tông Si-la alứng Ti-muthê, dyôn tớq chái nga án khán têq. ");
INSERT INTO pac_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ndóng Phau-lô át pớn Si-la alứng Ti-muthê tớq vel Athên, án hôm ticuoi tớq vel ngki sang a-ưi rup yang. Iki án sáng anguaq lư. ");
INSERT INTO pac_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iki Phau-lô cato níc tớq dúng rum ticuoi Isa-ra-el. Án cato ticuoi Isa-ra-el alứng máh ticuoi ndon dyám náp Yang Arbang-pilŏ́ng. Cứp ingái án cato tớq ntúq táiq plới hơ, co án ính máh ticuoi bôn sáng. ");
INSERT INTO pac_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dyơ bôn ticuoi te top Ep-curien alứng top Satuoc tớq tarmien alứng án. Bar top ngki rian te máh ngê tubáiq tớq pang ndô. Nha-án tông te Phau-lô idô: “Ticuoi achơ ndô, amớh án ính tông?” Ma bôn ticuoi cannŏ́h tông idô: “Dáh lơ án tông te yang ndon he lớiq chom.” Nha-án tông iki, co Phau-lô cato parnai ŏ te Yê-su, alứng án tông Yê-su tumống lieh te cuchet. ");
INSERT INTO pac_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ticuoi ngki dông Phau-lô nga mui ntúq ndon ticuoi sút báq tanghúng. Ntúq ndô át tớq cóh Arêu-ba. Nha-án tông ada Phau-lô idô: “He ính chom arlớih lư te nốh tamme ndon mái cato ngki la amớh? ");
INSERT INTO pac_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","He sáng laq lư te parnai mái cato; hoi-ngki he ính chom nhéq máh nốh te parnai mái cato ngki.” ");
INSERT INTO pac_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Tư máh ticuoi Athên alứng máh ticuoi te top cannŏ́h ndon át tớq vel ngki sáng te arnáq tamme, nha-án tél-sél lư ính tanghúng te arnáq ngki. Nha-án lớiq ính táq arnáq nnáng.) ");
INSERT INTO pac_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Phau-lô tayứng tớq ntúq nha-án rum tớq cóh Arêu-ba, alứng tông idô: “Ticuoi tớq vel Athên ơi! Cư chom dyơ inha sang tám yang inha khớm lư. ");
INSERT INTO pac_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Co tớq cư pôq tớq vel inha, cư hôm a-ưi thư parông yang inha sang, alứng cư hôm mui lám parông ngai tarran chưq idô: ‘Parông ndô la parông yang ndon iyốh chom nốh.’ Iki inha ính sang yang ngki, ma inha iyốh chom. Ma nốh yang ngki ớiq cư ính tông inha. ");
INSERT INTO pac_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yang ngki la Yang Arbang-pilŏ́ng. Án táp teng pilŏ́ng cuteq, alứng cứp nốh át tớq ngki. Án ưlla nhéq máh nốh tớq pilŏ́ng alứng tớq cúc cuteq. Ma án lớiq át tớq parông ati ticuoi táq. ");
INSERT INTO pac_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yang Arbang-pilŏ́ng lớiq túh cóq bôn ticuoi choi, co án bôn cứp nốh. Alứng án táp dyôn máh ticuoi bôn tumống, bôn tarngứh, alứng bôn cứp nốh. ");
INSERT INTO pac_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Yang Arbang-pilŏ́ng teng cứp top ticuoi, la nhơ te munáq ticuoi. Án dyôn máh top ticuoi ndô át tớq cứp cruong chôp cúc cuteq ndô. Nưm án táp anát dyôn cứp top ticuoi, ingái top ngki tớq alứng ntúq top ngki át, te iyốh bôn top ngki. ");
INSERT INTO pac_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yang Arbang-pilŏ́ng táq iki, dyôn nhéq tưh ticuoi têq suo án alứng têq tumúh án. Ma án lớiq bôn át yông te he. ");
INSERT INTO pac_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Yang Arbang-pilŏ́ng táp choi he dyôn bôn tumống, têq pupôq, alứng chom tutáq. Callong ndô la arớq ticuoi te top inha khoiq taran dyơ idô: ‘Co yang teng he, iki he cơt acái án.’ ");
INSERT INTO pac_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Khán he lư acái Yang Arbang-pilŏ́ng, he êq parngíh Yang Arbang-pilŏ́ng arớq rup ngai táq na dyeng, práq, lớiq la búl. Nhéq nốh ngki ticuoi chóng táq arớq nha-án khoiq parngíh. ");
INSERT INTO pac_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ma te nsuoi, Yang Arbang-pilŏ́ng me sớng nga máh ticuoi táq arnáq iki, co nha-án iyốh chom. Ma hoi-ngki, Yang Arbang-pilŏ́ng tông dyôn nhéq tưh ticuoi chom, nha-án cóq pien cơt mít tamme loi. ");
INSERT INTO pac_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Co Yang Arbang-pilŏ́ng khoiq anát ingái chô-mát, án dyôn munáq ndon án khoiq rêh tớq sưq tinớng tupứng lư ada nhéq tưh ticuoi tớq cúc cuteq ndô. Án khoiq dyôn Yê-su tumống lieh, dŏq cơt tíc dyôn ngai chom arlớih lư án rêh Yê-su dyôn sưq nhéq tưh ticuoi.” ");
INSERT INTO pac_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tư nha-án sáng parnai Phau-lô tông ticuoi cuchet têq tumống lieh, bôn ticuoi ayê tar-ac Phau-lô. Ma bôn ticuoi cannŏ́h tông idô: “Tatun, he ính cammáng sa te parnai mái cato arớq hoi-ngki.” ");
INSERT INTO pac_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dyơ Phau-lô ngốh te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ma bôn máh ticuoi te top ngki náp alứng tin; nha-án pôq alứng Phau-lô. Munáq te ticuoi ngki, nốh Dê-ni, la te top ticuoi sút ndon báq tanghúng tớq cóh Arêu-ba. Alứng bôn munáq cán, nốh Da-mari, tin tưi. Alứng bôn ticuoi cannŏ́h hơ tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Vít ngki Phau-lô ngốh te vel Athên, dyơ pôq nga vel Cô-rin-tô loi. ");
INSERT INTO pac_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tớq vel ngki, Phau-lô tumúh munáq conh te top Isa-ra-el, nốh Aki-la, te cruong Pôn-tu; campái án nốh Barit-sin. Bar náq campái cayieq ndô mbơiq tớq nga vel Cô-rin-tô te cruong I-tali, co puo Calôt chuih angốh nhéq máh ticuoi Isa-ra-el te vel pưt Rô-ma tớq cruong I-tali. Dyơ Phau-lô pôq alang bar náq ngki. ");
INSERT INTO pac_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Án mot át alứng nha-án, co nha-án táq arnáq muchứng án tưi. Nha-án táq dúng tớq prới; dyơ táiq dŏq bôn tampớc tớc tanna cha. ");
INSERT INTO pac_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cứp Ingái Angô Phau-lô cato tớq dúng rum ticuoi Isa-ra-el, co ính ticuoi Isa-ra-el alứng ticuoi Créc tin Yê-su. ");
INSERT INTO pac_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tư Si-la alứng Ti-muthê tớq te cruong Ma-sadôn, ndóng ngki Phau-lô catóng cato níc top Isa-ra-el dyôn chom arlớih lư, Yê-su la án ndon nha-án át ngcong alứng án ndon Yang Arbang-pilŏ́ng rêh dyôn choi tamống nha-án. ");
INSERT INTO pac_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ma ticuoi Isa-ra-el át tớq vel ngki lớiq ính cammáng alứng acraiq Phau-lô. Iki Phau-lô tamprúh tampớc táq tíc nha-án lớiq ính cammáng parnai án cato. Alứng án tông nha-án idô: “Khán inha lớiq ính arvai inha bôn tumống níc alứng Yang Arbang-pilŏ́ng, ngki tam inha. Mpual cư khoiq vít dyơ. Hoi-ngki cư ính pôq cato ticuoi tới ticuoi Isa-ra-el loi.” ");
INSERT INTO pac_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Iki Phau-lô ngốh te nha-án, dyơ mot tớq dúng Ti-tiu Yutu. Yutu la ticuoi sang tám Yang Arbang-pilŏ́ng tưi, alứng dúng án át tumán dúng rum ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Bôn munáq loi, nốh Crit-bu. Án la ticuoi sút tớq dúng rum ticuoi Isa-ra-el ngki. Án alứng nhéq abŏ́h án tin Yê-su. Alứng bôn clứng ticuoi Cô-rin-tô sáng parnai ŏ te Yê-su Crit, ngki nha-án tin alứng ráp tíc na dơq. ");
INSERT INTO pac_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bôn mui idáu, Yê-su apáh Phau-lô alứng tông án idô: “Mái êq adáh. Cóq mái cato níc parnai ŏ te cư. Êq cabip ngcang. ");
INSERT INTO pac_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Cư át níc alứng mái. Ticuoi mmo la lớiq têq táq mái. Tớq vel ndô bôn clứng ticuoi cơt na cư.” ");
INSERT INTO pac_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iki Phau-lô át tớq vel ngki nhéq mui cumo tadi, alứng án cato níc parnai Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ndóng Cali-ô cơt sút tớq cruong Achai, bôn máh ticuoi te top Isa-ra-el ính táq Phau-lô. Iki nha-án dông Phau-lô nga Cali-ô dyôn parchen parnai. ");
INSERT INTO pac_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nha-án cauq Phau-lô idô: “Ticuoi ndô tardông máh ticuoi tin Yang Arbang-pilŏ́ng, ma lớiq piaiq tớq phep rit.” ");
INSERT INTO pac_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tư Phau-lô ính ôi lieh, Cali-ô tông top Isa-ra-el ngki idô: “Inha top Isa-ra-el ơi! Khán án ndô ma titôiq, lớiq la cachet ticuoi, lớiq la táq arnáq saq cannŏ́h, ngki têq cư parchen dyôn inha. ");
INSERT INTO pac_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ma khán inha uan án, co án cato parnai ndái te phep rit inha, ngki tam inha. Cư lớiq ính tarsưq te arnáq ndô.” ");
INSERT INTO pac_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iki Cali-ô yua ngai chuih angốh nha-án te ntúq ngki. ");
INSERT INTO pac_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dyơ máh ticuoi clứng cŏp Sô-then, la ticuoi sút dúng rum ticuoi Isa-ra-el tớq vel ngki. Nha-án tính án chứng mát ntúq ngai tarsưq. Ma Cali-ô táq arớq lớiq hôm. ");
INSERT INTO pac_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phau-lô át tớq vel Cô-rin-tô a-ưi ingái. Tatun ngki, án carbánh carsuanh top veng Yê-su tớq ntúq ngki, dyơ ngki án pôq nga vel Sen-crơ. Aki-la alứng Barit-sin pôq munơi alứng án. Tớq vel Sen-crơ, án cuah sóc táq caloh, la tíc án khoiq par-ưq mui nốh alứng Yang Arbang-pilŏ́ng. Vít ngki, nha-án pe náq sớr tớq tuoc pôq nga cruong Si-ri. ");
INSERT INTO pac_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tư nha-án tớq nga vel Ê-phê-sô, Phau-lô pôq mmar te Aki-la alứng Barit-sin. Dyơ án mot tớq dúng rum ticuoi Isa-ra-el, alứng án cato ticuoi Isa-ra-el tớq dúng rum ngki. ");
INSERT INTO pac_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Máh ticuoi ngki seq án át dưnh alứng nha-án, ma án hớn ính pôq nga ntúq cannŏ́h. ");
INSERT INTO pac_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tớq án ính ngốh te nha-án, án tông idô: “Khán Yang Arbang-pilŏ́ng dyôn, chô-mát cư tớq lieh nga inha.” Cua án tông iki, án sớr tớq tuoc alứng ngốh te vel Ê-phê-sô. ");
INSERT INTO pac_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tư án tớq nga vel Sê-sarê, án sớr alang top tin Crit tớq vel Yaru-salem. Vít ngki án pôq nga vel Anti-ôt loi. ");
INSERT INTO pac_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Án át tớq vel Anti-ôt a-ưi ingái, dyơ án pôq chôp cruong Ca-lati alứng Phu-rayie. Án catớih top veng Yê-su tớq bar cruong ngki dyôn tin khớm lư. ");
INSERT INTO pac_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tớq máh ingái ngki, bôn munáq ticuoi nốh A-blô, án át tớq nga vel Ê-phê-sô. Án la ticuoi Isa-ra-el te vel Alec-santri. Án cato tubáiq lư, alứng án chom a-ưi te tám uráq Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bôn ticuoi khoiq cato án te ngê Yê-su. Án bôn mít ính cato dyôn crái lư te Yê-su. Ma án chom nưm te arnáq tíc na dơq ndon Yon khoiq táq sớng. ");
INSERT INTO pac_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","A-blô cato clŏ́q lư tớq dúng rum ticuoi Isa-ra-el. Tư Aki-la alứng Barit-sin sáng án cato iki, nha-án dông án pôq nga dúng nha-án; dyơ nha-án cato án dyôn chom arlớih lư te ngê Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Vít ngki A-blô ính pôq nga cruong Achai. Iki top tin Yê-su tớq vel Ê-phê-sô taran chớiq alang dyôn án dông nga top tin tớq cruong Achai, dyôn nha-án pasôl ŏ án. Tư án tớq nga cruong Achai, án choi a-ưi lư máh top tin Yê-su, la ticuoi ndon Yang Arbang-pilŏ́ng choi mat. ");
INSERT INTO pac_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tớq A-blô tarmien alứng ticuoi Isa-ra-el, án ial parnai te tám uráq Yang Arbang-pilŏ́ng tông dyôn nha-án chom arlớih lư Yê-su la Crit, án ndon Yang Arbang-pilŏ́ng khoiq rêh dyôn choi tamống ticuoi; co iki nha-án lớiq têq suon nnáng. ");
INSERT INTO pac_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ndóng A-blô át tớq vel Cô-rin-tô, Phau-lô chón pôq tilớt cruong ndon án khoiq pôq te nsuoi, dyơ án chô lieh nga vel Ê-phê-sô. Tớq vel ngki, án tumúh ticuoi tin. ");
INSERT INTO pac_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Dyơ án plốh nha-án idô: “Tư inha tin, Arvai Yang Arbang-pilŏ́ng mot át tớq mít inha, ma iyốh?” Nha-án ôi: “He lớiq nai sáng lớng te Arvai Yang Arbang-pilŏ́ng.” ");
INSERT INTO pac_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Iki Phau-lô plốh nha-án loi idô: “Ndóng inha ráp tíc na dơq, inha veng ngê amớh?” Nha-án ôi: “He veng ngê Yon ndon táq tíc na dơq dyôn ticuoi.” ");
INSERT INTO pac_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phau-lô tông nha-án idô: “Yon lư táq tíc na dơq dyôn ticuoi ndon pien cơt mít tamme loi. Ma Yon cato dyôn ticuoi chom nha-án cóq tin munáq ndon tớq tatun án. Munáq ngki la Yê-su.” ");
INSERT INTO pac_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tư nha-án sáng iki, nha-án ráp tíc na dơq nhơ nốh Yê-su loi. ");
INSERT INTO pac_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tớq Phau-lô capơiq tớq nha-án, Arvai Yang Arbang-pilŏ́ng mot táp tớq mít nha-án. Dyơ nha-án táq-ntêr máh cang ndon nha-án lớiq nai rian. Alứng nha-án cato tang ngcang Yang Arbang-pilŏ́ng. ");
INSERT INTO pac_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Top nha-án la nhéq ticuoi conh sasai bôn sám mui chít la bar náq. ");
INSERT INTO pac_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nhéq pe kisái Phau-lô cato níc tớq dúng rum ticuoi Isa-ra-el. Án cato clŏ́q lư parnai te Yang Arbang-pilŏ́ng cơt sút tớq mít ticuoi, ính nha-án tin ngê ngki. ");
INSERT INTO pac_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ma bôn ticuoi te top nha-án bôn mít cớng, lớiq ính peh parnai ngki. Alứng nha-án tông lớiq ŏ te ngê Yê-su. Iki Phau-lô alứng máh ticuoi tin ngốh te ntúq ngki, dyơ mot tớq dúng rian ndon Ti-ranu cơt ưlla. Cứp ingái Phau-lô cato tớq dúng ngki. ");
INSERT INTO pac_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Phau-lô cato tớq dúng ngki nhéq bar cumo. Iki máh ticuoi tớq cruong Asie cammáng parnai ŏ te Yê-su, díh ticuoi Isa-ra-el, díh ticuoi tới ticuoi Isa-ra-el. ");
INSERT INTO pac_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yang Arbang-pilŏ́ng dyôn Phau-lô bôn chức têq táq a-ưi arnáq sileh. ");
INSERT INTO pac_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Khán ticuoi ial khán lớiq la tampớc Phau-lô, dyơ patéuq tớq cháq ticuoi a-ái, ticuoi a-ái cơt bánh táp, alứng yang saq ngốh táp te cháq ticuoi. ");
INSERT INTO pac_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bôn mui top ticuoi Isa-ra-el pôq tudô pôq tuki ính chuih angốh yang saq te cháq ticuoi. Nha-án parngíh khán nha-án bôiq nốh Yê-su, nha-án têq chuih angốh yang saq arớq Phau-lô báq táq. Iki nha-án yua yang saq idô: “Nhơ te nốh Yê-su, án ndon Phau-lô báq cato, he yua mái ngốh viang te cháq ticuoi ndô.” ");
INSERT INTO pac_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Máh ticuoi ndon táq arớq ngki la tupul náq acái conh Sê-va. Sê-va la te top ticuoi sút top teng rit sang. ");
INSERT INTO pac_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma yang saq ôi tupul náq ngki idô: “Yê-su, cư chom, alứng Phau-lô, cư acớl, ma inha la nnáu?” ");
INSERT INTO pac_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Iki ticuoi ndon bôn yang saq palŏ́ng nga tupul náq ngki. Án bánh hơn te nha-án. Án táq nha-án chol ớp lư, alứng nha-án ngốh te dúng ngki mu-rarat. ");
INSERT INTO pac_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Arnáq ndô cơt pardŏ́h parhanh chôp vel Ê-phê-sô. Tư máh ticuoi Isa-ra-el alứng máh ticuoi tới ticuoi Isa-ra-el sáng iki, nhéq nha-án sáng adáh lư. Alứng bôn a-ưi náq loi tớq vel ngki dyám náp nốh Yê-su Ưlla he. ");
INSERT INTO pac_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bôn clứng ticuoi te top tin Yê-su ngin kho máh arnáq luaih nha-án, alứng nha-án tông dyôn ticuoi cannŏ́h chom nha-án khoiq veng ticuoi mo. Ma hoi-ngki nha-án lớiq ính veng nnáng. ");
INSERT INTO pac_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","A-ưi náq te top nha-án táq arớq ticuoi mo te nsuoi. Ma hoi-ngki nha-án pachúng máh uráq nha-án khoiq rian cơt mo, dyơ chŏ́ng chứng mát ticuoi clứng. Khán tíng lieh tarnáp te chớiq ngki bôn sám sông chít ngin callong práq tieq. ");
INSERT INTO pac_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Iki parnai ŏ te Yê-su cơt parhanh mưt-mư alứng cơt sit lư loi. ");
INSERT INTO pac_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Cua ngki Phau-lô parngíh ính pôq pha cruong Ma-sadôn alứng cruong Achai, ính pôq nga vel pưt Yaru-salem. Án tông idô: “Vít cư pôq nga vel Yaru-salem, cư ính pôq nga vel pưt Rô-ma loi.” ");
INSERT INTO pac_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Phau-lô yua Ti-muthê alứng Ê-rat pôq nsuoi án nga cruong Ma-sadôn. Nha-án la ticuoi báq táq arnáq choi án. Ma án yôl át tớq cruong Asie. ");
INSERT INTO pac_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ndóng ngki tớq vel Ê-phê-sô bôn clứng ticuoi uan máh top Yê-su Crit. ");
INSERT INTO pac_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Bôn munáq tớq vel ngki, nốh Dê-matri. Án la thơq táq rup yang cán na práq, nốh yang ngki la Dien. Án alứng yớu án bôn lơi a-ưi lư te táiq rup ngki. ");
INSERT INTO pac_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dê-matri arô máh yớu án alứng máh ticuoi ndon táq arnáq muchứng án. Án tông nha-án idô: “Em ai ơi! Inha chom dyơ, he khoiq bôn a-ưi lơi te arnáq he táq. ");
INSERT INTO pac_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Inha hôm alứng sáng dyơ te arnáq Phau-lô khoiq táq. Án tông máh ticuoi idô: ‘Yang ndon ati ticuoi táq la tới lư yang.’ Khoiq bôn clứng ticuoi tin parnai án, tới nưm ticuoi tớq vel Ê-phê-sô sớng tin, ma chôp cruong Asie la tin tưi. ");
INSERT INTO pac_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Arnáq ndô lúp lư dyôn he. Dáh lơ arnáq he táq cơt pít mat. Alứng dáh lớiq dưnh nnáng dúng sang yang Dien ndô lớiq bôn ngai dyám náp nnáng. Hoi-ngki clứng ticuoi tớq cruong Asie alứng tớq máh cruong cannŏ́h hơ sang yang Dien; ma urớh, dáh lơ ngai lớiq ính sang nnáng yang Dien.” ");
INSERT INTO pac_vpl VALUES ("AC19_28","074_19_28