﻿USE sofia;
DROP TABLE IF EXISTS sofia.pabNT_vpl;
CREATE TABLE pabNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pabNT_vpl WRITE;
INSERT INTO pabNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Exe baberakoa kaxairatyaka Jesus Cristo nahetakomaniyerenai nexare. Jesus Cristo atyo Davi jikolahare, Davi atyo Abraão jikolahare. ");
INSERT INTO pabNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão atyo Isaque kaisani, Isaque atyo Jacó kaisani, Jacó atyo Judá kaisani, iximarenenai enaxenanenai xoaha kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá atyo Peres, Zera xoaha kaisani, Tamar atyo inityoha. Peres atyo Esrom kaisani, Esrom atyo Arão kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão atyo Aminadabe kaisani, Aminadabe atyo Nasom kaisani, Nasom atyo Salmom kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmom atyo Boaz kaisani, inityo atyo Raabe. Boaz atyo Obede kaisani, inityo atyo Rute. Obede atyo Jessé kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessé atyo Davi kaisani hoka Davi atyo xekohaseti kalorexe tyaona. Hatyaoseta Davi atyo Salomão kaisani, inityo atyo Urias ene exanityo. ");
INSERT INTO pabNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomão atyo Roboão kaisani, Roboão atyo Abias kaisani, Abias atyo Asa kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa atyo Josafá kaisani, Josafá atyo Jorão kaisani, Jorão atyo Uzias kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias atyo Jotão kaisani, Jotão atyo Acaz kaisani, Acaz atyo Ezequias kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias atyo Manassés kaisani, Manassés atyo Amom kaisani, Amom atyo Josias kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias atyo Jeconias kaisani, iximarenenai xoaha kaisani Israel yerenai kaxolatyakaha hoka kakolatyakehenahere Babilônia xeta xowakiya. ");
INSERT INTO pabNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hatyo Babilônia xeta kakolatyakehenahere najikinita Jeconias atyo Salatiel kaisani, Salatiel atyo Zorobabel kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel atyo Abiúde kaisani, Abiúde atyo Eliaquim kaisani, Eliaquim atyo Azor kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor atyo Sadoque kaisani, Sadoque atyo Aquim kaisani, Aquim atyo Eliúde kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúde atyo Eleazar kaisani, Eleazar atyo Matã kaisani, Matã atyo Jacó kaisani. ");
INSERT INTO pabNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacó atyo José kaisani hoka José atyo Maria exanene. Hatyo atyo Jesus nityo, Kalorexe Enore Aohenere nityo atyo Maria. ");
INSERT INTO pabNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nikare enahetakomaniyerenai hoka Abraão ta exakerexe kaxihatyakaha Davi tyaohenere kijiya hoka 14-hareha. Nikare Davi ta kaxihatyakehenahitiyaha, Babilônia xeta kakolatyakehenahere kijiya hoka 14-hareha tehitiya. Hatyo kakolatyakehenahere najikinita kaxihatyakehenahitiyaha, Cristo tyaohenere kijiya hoka 14-hareha tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus tyaohenere atyo exakerexe: inityo Maria tyaohenere José kakoa nahitita tifalo, Enore nisekohare nikare mokene. ");
INSERT INTO pabNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tifalo hoka hatyaoseta José maisa tyaona ekakoa aokowihitita. Hoka José atyo waiyexehare hoka maisa Maria kairaehalotyaka aokita hoka hatyo hiyeta memereta emaisaheta hawenakakoaneha aokowita hoka maisa kasemakita maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hatyohare tahi ahekoita ene hoka Enore xaxikala anjo kaotyaka enomana inijihinako hoka nexa ihiye: — José, Davi jikolahare, awa atyo hamaikohare hawenane Maria kakoa tahi, Enore nisekohare atyo atifalokisene. ");
INSERT INTO pabNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Awenakisaite haisani enamokose. Tyaonaite hoka maika hakaixaretene Jesus. Hatyo atyoite iyehetehena haliti haomanerenai iniyalahare enómaneha nonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tyotya nikare tyaona, iraiti xakaisasehare xakaitere akerexeta kawenatyakeheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Exakere iniraine xairatyoare tyaonita iraiti waiyexe nanekoa: Ohiro mawatyalisakahaloite tifalo hoka awenakisaite enamokose hoka enexare ite Emanuel. Wiyako maniya atyo, “Enore tyaonita winekoni”, nita. ");
INSERT INTO pabNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hatyaoseta José kaose hoka Enore xaxikala anjo iraetere ekakoa akereta hatyaonero Maria kakoa tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Xakore hoka maisa atyo watyaliyene hekoti tyaohenere ityani kijiya. Tyaona ityani hoka José atyo Jesus nexarexe kaixaretya xoima. ");
INSERT INTO pabNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus tyaona wenakalati Belém nali, Judéia koa nali, Herodes xekohaseti tyaonitere xowakiya. Hatyo xowakiya Jesus tyaona najikini haiyanai halitinai tyoaha kamai nihikoane maniyata Jerusalém nali xeta. Waiyoreta xoresenai kakoa hatyo kaokiterenai hoka ");
INSERT INTO pabNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","kaokaha hoka nexaha, — Aliyako tyaona xoima judeunai xekohase maheta? Wiyaiya exoresera kamai nihikoane maniyata hoka wisoa wawaiyetene wimaxalo ekakoa maheta — nexaha axahene. ");
INSERT INTO pabNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hatyo tahi sema xekohaseti Herodes hoka amaikohare, tyotya hatyo Jerusalém tyaoniterenai tehitiya amaikohareha. ");
INSERT INTO pabNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hatyaoseta Herodes ahohisakoatya sacerdotenai xekohasenai, Moisés xaotyakira kakoa waiyoreterenai xoaha hoka axahene: — Aliyekoa Cristo nawenane xaokita? nexa axahene. ");
INSERT INTO pabNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hoka nexaha ihiye: — Wenakalati Belém nali Judéia koa. Nikarexe iraiti xakaisasehare xairatya etahi akiti. Exakere xairatyoare tyaonita: ");
INSERT INTO pabNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Hiso, wenakalati Belém Judéia koa nali, maisa hikirane xini haiyanai wenakalatinai Judéia koa nali nonitata. Hihiyetaite kaotyakehena xekohaseti kalorexe hoka kaxaikohena nokaxaikoniharenai Israel hotyalinai. ");
INSERT INTO pabNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hatyaoseta Herodes kawisa kamai nihikoane maniyata tyoiterenai, hawawaha heko irai ekakoaha maheta. — Xoana xowaka kaisere xorese kaotyaka xomana? Xiyakai rota nohiye — nexa axahene. ");
INSERT INTO pabNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Irai ekakoaha hoka hatyo najikinita axikatyahene Belém xeta. — Xiyane xatawa waiyekehalaka hatyo xoima xahita. Maika xikaokene hoka xisoa xakaixakaheta natyo hoka natyo tehitiya noxani nowaiyene hoka nawaiyetene, nomaxalo ekakoa — nexa ihiyeha hoka axikatyahene. ");
INSERT INTO pabNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nexa ihiyeha hoka hatyo tyoiterenai jiya xanehenahitiyaha. Ahoti waiyehenahitiyaha xorese waiyahitereta kamai nihikoane maniya nali. Hatyo xorese enahetaha maniya xane, xane amematyoa hatyo xoima tyaonitere hao akiti. ");
INSERT INTO pabNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Waiyaha xorese hoka masakare ihalahareha. ");
INSERT INTO pabNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Xane kaokaha, xane isoaha hatyako hoka waiyaha xoima inityo Maria kakoa. Meholokoaha hakaolise kakoa enomana, awaiyetyahene, maxaloha ekakoa. Hatyo najikinita majiholatyaha haitinihareha hoka isaha enomana maxaimanehareta ouro, incenso, mirra xoaha. (Incenso atyo kakeratyaka hoka airaxekoa mokita, mirra atyo airaxero akerehare airaxe). ");
INSERT INTO pabNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hatyaoseta Enore kaixakatya hatyo tyoiterenai inijihinakoha hoka maisa haikoahenahitaha Herodes tyaonitere nali maheta. Hiyeta hoka haikoahenahititaha hawaikoheraha xeta haho ahoti. ");
INSERT INTO pabNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hatyo tyoiterenai xaneheta najikini hatya anjo Enore nalitare kaotyaka José ana inijihinako, nexa ihiye: — Hisekoahena Egito xeta xoima kakoa, exahe inityo xoaha kakoa. Maika xisaona heko nali, ekakoitaite nakaixakaheta xiso. Kalikini Herodes tawita xoima aisene maheta — nexa anjo José hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nexa hoka José kaose hoka tekoa xoima exahe inityo xoaha kakoa makiyita Egito xeta. ");
INSERT INTO pabNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hatyo nali tyaonaha Herodes kamane kijiya. Nikare tyaonaha Enore iraiti xakaisasehare hiye iraetere akereta kawenatyakeheta maheta. Exakere xairatyoare tyaonita: Nakawiheta nityani hoka Egito nalita tyoheta. ");
INSERT INTO pabNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hatyaoseta Herodes kamai nihikoane maniyata tyohenerenai xahita atyahahena xakore, makaokeneha enomana hoka ehare. — Kaxiyani, maoseratyaha natyo — nexa hoka ehare, kahenehare tyaona. Hoka axikatya sorarenai aisaha maheta enamokosenai hinama wanone katyahakoretaterenai Belém naliyerenai, exahe ehaliyita wenakalatisenai koarenai hoka. Nikare ahekotya, xorese kaotyakehenere xakaihenahere ihiye hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nikarexe tyaonaha iraiti xakaisasehare Jeremias iraehenere akereta kawenatyakeheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama yerenai sema osexati, hokotyanika Raquel tiyita haisani mokosenai kawa. Tiya hoka maisa aliyakere kaxemaxalotyakita, tyotya ityaninai wainiha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hatyaoseta Herodes waini hoka ekamane najikini maniya hatya anjo Enore nalitare kaotyaka José ana inijihinako Egito nali hoka nexa ihiye: ");
INSERT INTO pabNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","— Nikahena hoka xoima exahe inityo xoaha kakoa hahaikoaheta Israel waikoherakoa. Aisa xoima aokowiterenai koxaka waini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hatyaoseta José haikoaheta xoima exahe inityo xoaha kakoa Israel waikoherakoa xeta. ");
INSERT INTO pabNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hoka semehena atyo José, Herodes ityani Arquelau atyo xekohaseti tyaonita Judéia koa hanexe wenekoare. Semene José hoka maira haxanene kakoa hatyo maniya. Hatyaoseta Enore aotyakihitiyene inijihinako hoka xane Galiléia koa. ");
INSERT INTO pabNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Xane tyaona wenakalati Nazaré nali. Nikare tyaona iraiti xakaisaseharenai niraene akereta kawenatyakeheta maheta. Exakere xairatyoare tyaonita: Nazaré yere nexahaite exaokaka. ");
INSERT INTO pabNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hatyo xowakiya João Batista xane maharexakiti Judéia koa nali hoka xakaihakahena iraiti naliyerenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hoka nehena: — Xahalakihena iniyalahare xománe, Xekohaseti Kalorexe Enore nalitare okoi kaotyakehena — nita ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","João tahi iraiti xakaisasehare Isaías toahiya xairatya exakere: Hatya haliti kawijita maharexakiti nali: “Memere ahoti xamohena Xekohaseti naheta, maika totaho xamohena enaheta maniya”. ");
INSERT INTO pabNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","João ijoita kamelo niyali nomakere, ijiterone atyo militihi. Nijita iri, exahe maha hoka hiyokita. ");
INSERT INTO pabNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tyotya Jerusalém nali tyaoniterenai, Judéia koa tyaoniterenai, exahe one Jordão maniya tyaoniterenai hoka tyoaha enomana, semaha maheta iniraine. ");
INSERT INTO pabNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","— Alitere iniyalahare kahare wisoma, xakore hoka wahalakisa iniyalahare wawenane waokowita — nexaha ihiye hoka João batixatyahene one Jordão xaiya. ");
INSERT INTO pabNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hoka João atyo waiyehena, fariseunai exahe saduceunai atyo tyoahitaha João batixatyahene maheta. Hoka nehena: — Xiso atyo owi akereta xiyalijinihare. Xala irae xihiye hoka motyaite maisa iniyalahare xikaxomokaka xaokita, Enore kaheneharexe iniyalahare axikahenere xowaka? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","— Maika xoalini hare waiyexe xisomehena hoka xahotikisa iniyalahare xawenane xihalakira maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hoka awa atyo exakere xahekotya: “Abraão atyo wahetahare hoka maisaiya Enore ehareta wihiye”, xehena. Hiyaiya, aliterexe nomita xihiye, exe sehali kakoita hiyetaiya Enore aikawatya Abraão jikolahare maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","— Hiyaiya, xawatise atyo memere tyaonita, irikotya maheta atyakatenai ityahare kakoita. Tyotya atyakatenai mawaiyerihare kalitereharenai atyoite kaxityokaka hoka kaxawatyaka irikatyaose — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","— Natyo atyo nabatixatya xiso one kakoa iniyalahare xománe xihalakira xahotikisa maheta. Hoka tyoaite hatya najikini maniya, noxahehare atyo. Hakíjitini kolatyakaiya aoka nohiye hoka nihalahareya nakolatene enomana, noxahehare hoka. Hatyo atyoite batixatya xiso Isekohaliti waiyexe kakoa, exahe irikati kakoa xoaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","— Abali koxaka ekahekoa, hatyo kakoaite haware moka trigo ekate nonitata hoka trigo ite moka exomokakala ako, hoka keratyaite ekate irikati mawakenehare tyaonitere koni — nexa João ihiyeha. (Halitinai xaokaka nikare João iraeta). ");
INSERT INTO pabNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hatyo xowakiya Jesus tyoa hikoa Galiléia koa nalita, tyoa one Jordão nali, João batixatene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Xakore hoka kaokehena Jesus hoka João nehena iraehena ekakoa: — Natyoiya kahane habatixatya, hiso tyatyo noxahehare. Aliyakereyatya nabatixatya hiso? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hoka Jesus nehena ihiye: — Kala naokitere akere wisaona. Nikare ite hoka tyotya wisoma Enore aokitere akereta — nexa Jesus. Nexa Jesus hoka João tyakeko iniraine hoka batixatene. ");
INSERT INTO pabNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Batixatene najikinita, Jesus kenekoahetehena onexata hoka enokoa totakore tyaona hoka waiyehena atyo Jesus, Enore Nisekohare exoahena enomana, motya watyaha hoka tyoa tyoka ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Enokoata iraiti nehena: — Exe atyo nityani, noxiyakawali, nihalahare mokita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hatyaoseta Enore Nisekohare axanekisa Jesus maharexakiti Tihanare hasakaharetene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesus tyaona 40-ki ferakene, 40-ki makene. Maisa kanakairare hoka hatyaoseta nakehena. ");
INSERT INTO pabNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hatyaoseta ehasakaharetyase tyoa kaoka enomana hoka nehena ihiye: — Enore ityaniya atyo hiso hoka exe sehalinai haikawatya nakairati hoka hikanakaira — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hoka Jesus nexa ihiye: — Exakerexe Iraiti Waiyexe xairatyoare tyaonita: Maisa nakairati xema taita xini haliti nawenane tyaonita. Enore iraihenere tyotya xema tehitiya wenati tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hatyaoseta Tihanare noloka Jesus Jerusalém nali xeta waiyexe wenakalati nali hoka xane ekakoa Iraexatyakalati Hana maiyeho hoka iraehena ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","— Enore ityaniya hiso hoka hahalaisoaheta exaoseta. Hiyaiya, exakerexe Iraiti Waiyexe xairatyoare tyaonita: Enore ite axikatya anjonai hoka kaxaiko hiso. Otokahaite hiso hakaheha kakoa hoka maisa hikijinai hekoti kawe hamokita sehalinai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Hoka Jesus nexa ihiye: — Iraiti tehitiya exakerexe xairatyoare tyaonita: Awa atyo hahasakaharetya Hiyekohase Enore. ");
INSERT INTO pabNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hatyo najikinita Tihanare noloka Jesus hatya tyairi heno enoakiya hoka hotikisa enomana hakakoare waikohekoa, waiyexe wenati, xiyehaliti xoalini hare kahare hotikisa enomana hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","— Hameholokoaiya nahalakoi, hawaiyityaiya natyo hoka exeharenai tyotya nisa homana — nexa Tihanare Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hoka Jesus nexa ihiye: — Hiyanehetehena, Ahalakoahaliti! Iraiti Waiyexe exakere nexa: Hawaiyehena hiyekohase Enore, exahe ekoamaniya taita hisaohena. ");
INSERT INTO pabNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nexa Jesus hoka hatyaoseta Tihanare halakisene hoka anjonai tyoa kaokaha enomana hoka kahinaetene. ");
INSERT INTO pabNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hatyaoseta Jesus sema João xolatyaka hoka haikoaheta Galiléia koa xeta. ");
INSERT INTO pabNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Xakore hoka maisa Nazaré nali tyaonita hoka xane wenakalati Cafarnaum nali tyaona. One Galiléia xa haliya, Zebulom, Naftali xoaha waikohera koa. ");
INSERT INTO pabNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nikare tyaona iraiti xakaisasehare Isaías iraetere akereta kawenatyaka maheta: ");
INSERT INTO pabNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulom, Naftali xoaha waikohera one kaloxere maniya, Jordão xa halakoiya maniya, Galiléia koa xoaha nali, majudeuneharenai tyaonitere nali. ");
INSERT INTO pabNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hatyonai atyo makaliroti koni tyaonahitaha hoka xaokanatyakalati kalorexe ite kaotyaka enomanaha. Hoka xaokanatyakalatite aokanahena makaliroti koni wainihenerenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hatyo najikinita Jesus xakaihena hairaine ihiyeha. Nehena: — Xahalakihena iniyalahare xománe, Xekohaseti enokoatare okoi kalorexe tyaohena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hatyaoseta Jesus tona kilihijita ene one Galiléia xa hoka waiya hinamahare haximarene kakoarenai, Simão Pedro, André xoaha. Maka kakoa mairatyahitaha, mairatyatiyenai hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hoka Jesus nexa ihiyeha: — Xisohena noximi hoka naotyakisa xiso hoka halitinai nolokasehare xisaona — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nexa ihiyeha hoka halakisaha rotita maka kohase hiyakakala hoka xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hatyaoseta Jesus jiyihitiya, maisekoneseta waiyihitiya hinamahare haximarene kakoarenai, Tiago, João xoaha, Zebedeu ityaninai. Tyaonahitaha kanowa ako hanexeha kakoa, tyomaharehenahititaha hahiyakakalaha. ");
INSERT INTO pabNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jesus kawisahene hoka halakisaha rotita hanexeha exahe hakanowaneha xoaha hoka xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hatyaoseta Jesus xane hakakoare Galiléia koa tonakoatya. Kaokehena wenakalati hoka aotyakisahitene xahohisakoatyakalati hanako. Iraiti waiyexe xakaita ihiyeha Xekohaseti Kalorexe Enore nalitare kaotyakene tahi. Haiyaharenai hokakiterenai aiyatelikihitita ekahehareha nonitata. ");
INSERT INTO pabNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ekakoita etahi akiti semaha hakakoare Síria koa maniya. Hatyo hiyeta halitinai kolatya hokakiterenai Jesus ana, kahare hawareharexe kahehaliti kakoarenai, tihanare kamilakoretiterenai, hatyahalitinai, wainitatereharenai exahe maetonaneharenae xoaha hoka tyotya aiyatelikihenahititene. ");
INSERT INTO pabNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hoka kahare halitinai xaneta exema Galiléia koa yerenai, Decápolis nalitarenai, Jerusalém nalitarenai, Judéia koa nalitarenai, one Jordãoxa halakoiya tarenae xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Haxowakiya Jesus hisoaka halitinai waiya hoka kakoha tyairi henose hoka xane tyoka. Hoka exaotyakiraharenae tyoa kaokaha ehaliya ");
INSERT INTO pabNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","hoka aotyakihenahene, nehena ihiyeha: ");
INSERT INTO pabNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","— Waiye kaiserehare atyo maxaokowiharetyoanehare tyaonitereharenai. Hiyaiya, Xekohaseti enokoatare waikohera atyo enomanereha. ");
INSERT INTO pabNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","— Waiye kaiserehare atyo tiyitereharenai. Hiyaiya, Enore atyoite emaxalokihenahitene. ");
INSERT INTO pabNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","— Waiye kaiserehare atyo waiyexeharexenai. Hiyaiya, kaxekaka atyoite enomanaha Enore aokitereharenai. ");
INSERT INTO pabNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","— Waiye kaiserehare atyo Enore aokitere akereta tyaona aokowitereharenai. Hiyaiya, hatyo aokahitere akereta atyoite mokahene. ");
INSERT INTO pabNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","— Waiye kaiserehare atyo airakoanetitereharenai haiyaharenai. Hiyaiya, Enore atyoite airakoaneharetyahene tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","— Waiye kaiserehare atyo iniyalahare maomanehare ahekoiterenai. Hiyaiya, waiyaha atyoite Enore. ");
INSERT INTO pabNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","— Waiye kaiserehare atyo waiyexe wenati atyahitereharenai. Hiyaiya, Enore atyoite haisani akereta mokahene. ");
INSERT INTO pabNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","— Waiye kaiserehare atyo kairaeharetyakitereharenai Enore aokitere akereta tyaonahitere hiyeta. Hiyaiya, Xekohaseti enokoatare waikohera atyo enomanereha. ");
INSERT INTO pabNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","— Waiye kaiserehare atyo xikairawaiyakehena, xikairaeharetyakehena exahe kahare iniyalahare kairaityakehena xitahi, nokoamaniye xisaonitere hiyeta hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Maika xihalaharehena, nikare mohenaha xiso hoka. Hiyaiya, kalorexe xibakatyakala atyo ityakaisakahare tyaonita xomana enokoa nali. Hiyaiya, nikare atyo kairaeharetyaka iraeti xakaisaseharenai xahetakomaniyereharenai. ");
INSERT INTO pabNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","— Xiso atyo salo akere xisaonita halitinai koni. Xakore hoka salo atyo makexenehena hoka maisa atyo saloheta xini. Maisa atyo xoare hare niyahareheta xini. Hoka kaxawatyakita atyo hoka jiyitereharenai tyahakitene — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","— Xiso atyo xaokanatyakalati akere xisaonita tyotya halitinai koni. Hiyaiya, maisaiya aliyakere hateroakijita wenakalati tyairi heno kaomakehenere. ");
INSERT INTO pabNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nikare maisa xala hare aotakatya xaokanatyakalati hoka koho katyahe mokare. Hoka kaxaotakatyakehena hoka exomokakaose terota kaxomokakita hoka tyotya hatyako tyaoniterenai ana aokanatita. ");
INSERT INTO pabNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nikareta tehitiya xiyaokanala aokanahena, haiyanai waiyaha maheta xoalini hare waiyexe xománe hoka ihalahareha Xexe enokoa tyaonitere kakoa maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","— Awa atyo motya notyoa nemaisaheta maheta Moisés exahe iraiti xakaisaseharenai xaotyakira xaohena. Maisa atyo notyoa nemaisahetene maheta xini. Notyoa atyo exaotyakiraha akereta kaomakeheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aliterexe nomita xihiye: hekotataite waikohe, enokoa xoaha tyaonitata hoka maisaiya xoare hare kaxemaiyaretyakihitita xaotyakiye ahotare, maisaiya hase hekoti kaxemaiyaretyakihitita. Nikare taite kawenatyaka tyotya xoalini hare miyane kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hatyo hiyeta xala xamani atyoite matyakekotya kiranexe xaotyakisati hoka hatya aotyakisa hoka nikareta tyaona hoka hatyo atyoite haiyaharenai katyahakoreta tyaona, Enore nalitare Kalorexe tyaohetehenere xowaka. Xakore hoka xala xamani atyoite tyakeko xaotyakiyaho hoka hatya aotyakisa hoka nikare tyaona hoka kalorexe atyoite tyaona Enore nalitare Kalorexe tyaohetehenere xowaka. ");
INSERT INTO pabNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hiyeta hoka nomita xihiye: maisaiya fariseunai exahe xaotyakiyaho kakoa waiyoreterenai xahe nawaiye xisaonita hoka maisaiya aliyakere Xekohaseti enokoatare waikohera xiyaneta. ");
INSERT INTO pabNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","— Koxaka xasema xahetakomaniyereharenai hiye niraityaka: Awa atyo xaisa. Xala xamani atyoite aisa haliti hoka kakolatyakaite kalorexe ana. ");
INSERT INTO pabNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","— Hoka natyo atyo nomita xihiye: xala xamaniya ehare taita hahinaehare hiye hoka kakolatyaka atyoite kalorexe ana. Xala xamaniya nexa hahinaehare hiye: “Maisa xoare niyahare hiso”, nexaiya ihiye hoka kakolatyakaiya kalorexe ana. Xala xamaniya hahinaehare hatyaharene aoka hoka irikati koni haxanene atyo aheteretita. ");
INSERT INTO pabNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","— Hatyo hiyeta maika hafetatya haokowihena kirakahare Enore ana hoka hotehetehena hihinaehare xéharene hihiye hoka ");
INSERT INTO pabNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hahalakisa hatyo kirakahare ekeratyakaose haliya hoka hiyane wenati waiyexe haoheta hihinaehare ana. Hatyaosetaite hahaikoaheta hoka hafetatene Enore ana. ");
INSERT INTO pabNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","— Hoka maika hatya kahalakoaharehena hikakoa hoka kolatya hiso kalorexe ana aokowihena hoka maika ahotita hirae ekakoa. Waiya aliya hoka kalorexe ana kaoka hikakoa hoka isaiya hiso kalorexe ana hoka hatyo kalorexeya isa hiso sorare ana hoka berexo akoiya moka hiso. ");
INSERT INTO pabNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aliterexe nomita, maisaiya habakaita tyotya hoka maisaiya hahikoahitita berexo akota — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","— Koxaka xasema xahetakomaniyereharenai hiye niraityaka: Awa atyo hatya nohiroxa xiwatyali. ");
INSERT INTO pabNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hoka natyo atyo nomita: xala xamaniya atyo wahakotya hatya ohiro ana, kasaniya watyalini aokowita hoka hatyoiya koxaka iniyalahare tyoma haxahekola kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","— Hiyeta hoka hifihini maniyere hiyoseya iniyalahare axomokanikijita hiso hoka holokotya hiyene hoka haxawatene. Ehekoretaiya meta hatyo ini akiti hiháre hiyetare. Hoka maisaiya atyo ehekoreta xini hiháre mainikere kakoareta hikaxawatyaka irikati koni hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nikare hifihini maniyereya hikahiya iniyalahare axomokanikijita hiso hoka hirikotene hoka haxawatene. Ehekoretaiya meta hatyo ini akiti hiháre hiyetare. Hoka maisaiya atyo ehekoreta xini, hiháre mainikere kakoareta hikaxawatyaka irikati koni hoka — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","— Exakere tehitiya kairaityaka koxakereharenai hiye: Xala xamani haiyanityo halakiheta aokowita hoka maika isa enomana babera halakisati baberanexa hoka axikahetene. ");
INSERT INTO pabNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hoka natyo atyo nomita: hatyaiya haiyanityo halakiheta, maisa xakoreya hatya ena watyaliyene hoka hatyoiya atyo maisa waiyeta. Waiya aliya hoka hatya kakoa tyaohetehitiya hoka iniyalahareya tyoma. Exahe hatyo ena tyaohenere ekakoaiya iniyalahare tehitiya tyoma — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","— Koxaka xasema xahetakomaniyereharenai hiye kairaetyakehenere: “Awa atyo xahalakisa xisoma xaokowiterehare, xakore hoka maika xisomehena xisoma xaokowiterehare Xekohaseti hiye xiraehenere”. ");
INSERT INTO pabNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hoka natyo atyo nomita: awa atyo exaliti harenai xakaixaretya xikatyakekotyaka maheta. Awa atyo enokoa xakaixaretya, hiyaiya, Enore nokahakala atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Exahe waikohe tahi hoka xakaixaretya, hiyaiya, hatyo heno atyo mokita hakiji. Exahe Jerusalém xakaixaretya, hiyaiya, hatyo atyo Xekohaseti Kalorexe nawenakala. ");
INSERT INTO pabNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Awa atyo xiserinai xakaixaretya. Hiyaiya, maisaiya xisonai hakaseta sekatise xaiyomakasetita xamani, exahe xakiyakasetita xamani. ");
INSERT INTO pabNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Maika xehena taita: “Há”, xehena xamani, “Mahaiya”, xehena taita. Hiyaiya, xoare xexa xamani atyoite hatyo xahexe hoka hatyohare atyo Tihanare nalita tyoita — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","— Koxaka xasema exakere kairaityakehenere: Hatyaiya wataka hiyose hoka hatyo nahalakoa hawataka exose, hatyaiya taika haikoli hoka hatyo nahalakoa enaikoli hataika, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hoka natyo atyo nomita xihiye: awa atyo hatya iniyalahare mohena xiso hoka hatyo nahalakoa iniyalahare xamokene. Hoka maika hatya mokohena hiso hitanakoli hiye hoka hamaniya tanakoli tehitiya hehaika enomana hoka mokohitiya. ");
INSERT INTO pabNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hoka maika hatya aiyateretyoa hihiye, kolatya maheta hima hoka hisene enomana, exahe himanase tehitiya hisa enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Hoka maika sorare aiyateretyoa hihiye hakolatya maheta kolare hakilometrone enomana hoka maika hinama kilometrone hakolatene enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hoka maika hatya axehena hiso xoalini hare hoka hisene enomana. Exahe hatya axehena hiso xoalini hare hoka isehetene homana maheta hoka hisene enomana — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","— Koxaka xasema kairaityakehenere: Hawaiyehena hihinaeharenai hoka hikirawanehena hahalakoaharenai. ");
INSERT INTO pabNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hoka natyo atyo nomita xihiye: maika xawaiyehena xahalakoahenerenai, xiraexahena kirawaneterenai xiso ana. ");
INSERT INTO pabNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nikareya xisaona hoka Xexe enokoa tyaonitere ityaninaiya xisaona. Hiyaiya, waiyexeharexenai, mawaiyexeharexenai xoaha ana atyo kamai axaokanatyakijita, exahe hoka aonekijita atyo waiyexe tyomiterenai, iniyalahare tyomiterenai xoaha ana. ");
INSERT INTO pabNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hiyaiya, awaiyetiterenai xiso taitaiya xawaiyetita hoka xoanere hoka xoalini hare Enore xekane xahita xatyahita? Hiyaiya, nikare atyo kalorexe noloxa resebetyaseharenai haxawaiyetyaseharenai awaiyetyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hoka xihinaehare hiye taitaiya xikatyawaxita hoka hatyohare atyo maisa xoanereta xini. Hiyaiya, matyakekoneharenai kakoita atyo nikare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hiyeta waiye maniyaira xisaona Xexe enokoa waiye tyaonitere akereta — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","— Hiriharíra! Hoka awa atyo hawenanaho waiyexe xema hisaonitere hiyeta, hatyoharenai hisoma halitinai haotita, waiyaha hiso maheta taita. Nikareya hisaona hoka maisaiya xoare hare Hexe enokoa tyaonitere ijita homana. ");
INSERT INTO pabNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hoka maika xoalini hare hisehena maxiyeharehare ana hoka awa atyo hatyoharenai hiyakaikoatya, teraharetyoarenae akereta. Nikare atyo tyaonahitaha, halitinai ihalahareha ekakoaha maheta taita. Hoka exeharíra xotyaxematya: koxaka atyo kaxekaka enomanaha xoalinihare. ");
INSERT INTO pabNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Maika hakahinaehena hatya maxiyeharehare, himeteneta nikare hisoma hoka maisa hihinaehare hekoti hikahinaera waiyita. ");
INSERT INTO pabNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hoka hatyoharenai atyoite metereta tyaohena. Hoka Hexe atyoite waiya hatyoharenai himeteneta hisomehenerehare hoka isaite homana xoalini hare waiyexe hatyo nahalakoa — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","— Maika xiraexahena hoka awa atyo teraharetyoarenae iraexaitere akereta xisaona. Hatyonai atyo tityoaha xahohisakoatyakalati hanako exahe ahotiaho hare hoka iraexatyahitaha, kasani halitinai waiyahene aokahitaha hoka. Hoka exeharíra xotyaxematya: koxaka atyo kaxekaka enomanaha xoalinihare. ");
INSERT INTO pabNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Hiyeta xiraexatya xaokowihena hoka xiyane xihanako hoka xajihotyoa hoka xiwawaharenai xiraexatya Xexe Enore hiye hoka maisa xikawaiyakita. Xexe Enore atyoite waiyehena xisomitere ximeteneta hoka isehena xomana xoalinihare waiyexe hatyo nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","— Xiraexahena hoka awa atyo Enore maniya mawenaneharenai akereta xiraexatya. Hatyonai atyo iraexahena hoka hatyaoseta iraexaheta xoahita, motya iraexatyaha kahareki hoka Enore semene aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Awa atyo hatyonai akereta xiraexatya. Xexe Enore atyo koxaka otita xoalini hare xaokitere xiyaxane nahitita. ");
INSERT INTO pabNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","— Hiyeta hoka exakere xiraexatya: Wexe Enore, hiso atyo enokoa hisaonita. Kasani tyotyaha aiminisaha hiso waokita. ");
INSERT INTO pabNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Hisohena ali Xekohaseti hisaona maheta. Kasani ali waikohekoa haokitere akereta tyaona waokita, enokoa nali kaomakitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kasani nakairati hisa womana tyotyaki ferakene waokita. ");
INSERT INTO pabNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Himaotyanehetehena iniyalahare wisomitereharenai, haiyaharenai iniyalahare mohenere wiso wimaotyanehititere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hoka awa atyo hahalakihena wiso hoka wikahasakaharetyakehena. Xakore hoka maika iniyalahare nonitata hiyehetehena wiso. Hiyaiya, homanere atyo waikohe. Iyateliti exahe kaihalaharetyaketa mene hikakoa waokita, xoaha taita. ");
INSERT INTO pabNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","— Ximaotyanehetaiya haiyanai iniyalahare mohenere xiso hoka Xexe enokoa tyaonitere tehitiyaiya maotyaneheta iniyalahare xománe. ");
INSERT INTO pabNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Hoka maisaiya atyo ximaotyanehitita haiyanai iniyalahare mohenere xiso hoka Xexe enokoa tyaonitere tehitiyaiya atyo maisa maotyaneta iniyalahare xománe — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","— Maika ximanakairehena Enore hiyeta hoka awa atyo xamaikohare tiho xisaohena, teraharetyoarenae akereta. Hatyonai atyo nikare tyaonahitaha, kasani haiyanai ana emanakaireneha waiyekehalaka aokahitaha hoka. Hoka xotyaxematyaira exeharenai: koxaka atyo xoalinihare kaxekaka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hoka maika himanakairehena Enore hiyeta hoka hatihatihotyoa hoka hatilikoa hoka ");
INSERT INTO pabNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","maisa haiyanai otita himanakairene maheta. Hoka Xexe Enore mawaiyakahare takita atyoite waiya tyotya himeteneta hisomiterehare hoka isa homana xoalini hare waiyexe hatyo nahalakoa — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","— Awa atyo xixiyeharenae kahare xamoka xaokowi ali waikohekoa. Hatyoharenai atyo kirakahare sesekita, exahe kaijikali tyaonita hoka mawenekoareta, exahe kaiwarexenai hoka isoaha hatyako hoka kaiwitene. ");
INSERT INTO pabNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Maika enokoa nali xixiyehare xamoka xaheta maniya. Hatyo nali atyoite maisa kirakahare aiyalaharetitene, exahe kaijikali tyaonita, exahe hoka maisaiya kaiwarexenai isoaha hoka kaiwitene. ");
INSERT INTO pabNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aliye xamaniya xixiyehare xamokita hoka hatyo nali tehitiya atyoite xiyahekola tyaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","— Xiyosenai atyo xaokanatyakalati akereta tyaonita xiháre hiye. Xiyosenaiya waiyese hoka waiyeya xiyaiyakatya. ");
INSERT INTO pabNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Hoka xiyosenaiya atyo maisa waiyesexe hoka makaliroti koni atyo xisaonita. Nikareya xiyahekola iniyalahare maniya tyaonita hoka makaliroti koni atyo xisaonita. Hatyo makaliroti atyo kahenehare — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","— Hatitaiya wakahare hoka maisaiya aliyakere hinamahare kaxekohaseta. Nikareya hoka hatya awaiyetita, hatya maisa awaiyetyare xoahaiya. Tyakekota hatya, hatya maisa tyakekore xoahaiya. Nikare tehitiyaiya maisa aliyakere Enore maniya hahekoita, olo xiyehaliti harenai maniya hahekoita xoaha haxowakita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","— Hiyeta hoka nomita xihiye: awa atyo xamaikoharehena nakairati, erati harenai xaokiterenai xawenane niyahare kakoa, exahe imiti xaokitereharenai xiyisoane niyahare kakoa hoka. Xoana wenati kore atyo maisa nakairati xahehare xini? Xoana xiháre kore atyo maisa imiti xahehare xini? ");
INSERT INTO pabNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xiyaiyehena kotehalasenai ainakoitereharenai. Maisa atyo fityareha hanakaira, maisa imexareha, maisa mokareha hanakairaha hahanakoha. Xakore hoka Wexe enokoa tyaonitere atyo ijita enakaira enomanaha. Hoka xoana maisa korala exe kotehalanai xahexehare xini xiso? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","— Awa atyo xamaikohare mene xawenane kakoa. Hityokahokoseya hoka hiwahahare hisaoheta haokowita hoka hamaikohareta hoka hiyamaikoharene atyo maisa xoarehare tyomare. ");
INSERT INTO pabNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","— Xoana hoka xamaikohareta ximaimene kakoa? Xiyaiyehena, iyitinai waiyehare kekoarehitaha. Maisa hakareha exahe maisa tyomare haimaha. ");
INSERT INTO pabNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Xakore hoka nomita xihiye: Salomão xekohaseti tyaonitere xowakiya kalorexe xakore hoka maisa imiti exe iyitinai nawaiyehare akere ako isoare. ");
INSERT INTO pabNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Enore xaokalita atyo atyamokose ime harenae waiyehare tyaonita. Kalini waiyehare tyaonitaha hoka makani wainihenahitaha hoka kakeratyakahitaha irikatyaose. Hatyo hiyeta aliterexe ite kaimatya tehitiya xiso. Hoka xityakekone atyo kirane. ");
INSERT INTO pabNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","— Hiyeta hoka awa atyo exakere xexa xamaikohare: “Aliyakotaite wikaokehena winakaira werane exahe wima hoka?” ");
INSERT INTO pabNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hiyaiya, hahotyaliharenai atyo nikare taweta menahitaha tyotya hatyoharenai. Hoka Xexe enokoa tyaonitere atyo waiyoreta tyotya xaokitereharenai kakoa hoka hatyoharenai atyoite isa xomana. ");
INSERT INTO pabNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hiyeta hoka Enore maniya hotohare xawenane xamoka, exahe Enore aokitere akereta xisaona hoka hatyo atyoite isehena xomana tyotya xoalini harenai. ");
INSERT INTO pabNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hiyeta hoka awa atyo xamaikohare makaniye ferakene kakoa. Hiyaiya, hatyo kamaetaliye ferakene atyo maisa waiyekehalakere xomana. Maika xahekohena xisaonitere ferakene kakoa taita — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","— Awa atyo xiraeharetya haiyaharenai, waiya aliya hoka xikairaeharetyaka tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Hiyaiya, xahekoitere haiyaharenai kakoa akeretaite Enore moka xiso, exahe haiyanai xamokitere akeretaite moka xiso. ");
INSERT INTO pabNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","— Xoana hoka holoxotise xihinaehare xose ako tyaonitere atyo xiyaiyita hoka maisa atyo atya taose xiyose ako tyaonitere xiyaiyare? ");
INSERT INTO pabNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aliyakereya xihinaehare hiye xehena: “Nikahena hoka niyeheta holoxotise hiyose akota”, owene xakore tyaonita atya taose xiyose ako hoka? ");
INSERT INTO pabNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Xasemehena, teraharetyoarenai, xiyehetehena hotohare atya taose xiyose akota hoka hatyaosetaite waiye xiyaiyakaheta hoka xiyeheta holoxotise xihinaehare xose akota — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","— Awa atyo xisa kajolonai ana Enore anerenai, waiye aliya hoka kahalakoahareha xikakoa hoka tyalokaha xiso. Exahe awa atyo xaxawatya sehalise kaxaimanexe bolokonai ana. Waiya aliya hoka tyahakahene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","— Xaxehena hoka xikaoxekaka. Xataweniya hoka xikaokene. Xamokotyaiya hati jihola hiye hoka majiholateniya xomana. ");
INSERT INTO pabNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hiyaiya, tyotya axiterenai ana atyo kaxekaka, tawiterenenai atyo kaokitene, jihore atyo majiholatyoita mokotitereharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","— Xoana, hatya xinekonitare ityaniya axehena hanexe nakairati hoka isaiya sehali enomana? ");
INSERT INTO pabNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Xoana, isaiya enomana owi, kohase axehena hoka? ");
INSERT INTO pabNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Xiyaiya, maisa xakore xawaiyexe hoka xawaiyore atyo xijita xoalini hare waiyexe xityaninai ana. Nikare tehitiyaite Xexe enokoa tyaonitere isehena xoalini hare waiyexe axiterenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","— Aliyakere xamani halitinai moka xiso xaokita hoka nikareta tehitiya xamohena halitinai. Exe atyo Moisés, iraiti xakaisaseharenai xoaha xaotyakira — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","— Xisoahenaira xisoakalati kiranahore. Hiyaiya, hatya xisoakalati kaloahore, exahe waiye netonatyaka atyo, xakore hoka mawenekoaretyati aho atyo. Hoka kahare haliti tonita enaho. ");
INSERT INTO pabNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Xisoakalati kiranexe aho atyo howitihare netonatyaka, xakore hoka wenati waiyexe xetare atyo hoka haiyanai taita atyo tonita enaho — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","— Xiriharira iraiti xakaisaseharenai metalaharenai kakoa. Kaokahaite xomana hoka kalanero maxalijiniharenehare akeretaite tyaonaha, xakore hoka exahekolaha atyo kahenehare. Ahoxa xalijiniharexe akereta atyoite. ");
INSERT INTO pabNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Maika waiyekehalakahare xomana enawenaneha hiyeta. Katohere katenai kalihena hoka maisa atyo uvali kaliye. Exahe atya kaewero katenai kalihena hoka maisa halohalose kaliye. ");
INSERT INTO pabNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nikareta atya kanakairoare kate kalihena hoka waiyexe atyali kalita. Nikare tehitiya atya ewaxirahare kate kalihena hoka maisa waiyexe atyali xini kalita. ");
INSERT INTO pabNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nikareta kanakairoare kate ite kalihena hoka maisaiya manakairatyakahaliri kalita, maisaiya atya manakairatyakahare kate hoka atyali kanakairoare kalita. ");
INSERT INTO pabNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tyotya atyakatenai manakairatyakahaliri kaliterenai atyo kaxityokaka hoka kaxawatyakahitaha irikati aose. ");
INSERT INTO pabNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nikare ite waiyekehalakaharehena xomana iraiti xakaisasehare metalaharenai enómaneha hiyeta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","— Kahare haiyaharenai nexahitaha: “Xekohaseti, Xekohaseti”, nitaha nohiye. Xakore hoka maisaite tyotya hatyoharenai Xekohaseti enokoatare waikoherakoa xaneta. Hoka Baba enokoa tyaonitere aokitere akereta tyaoniterenai taita atyoite nali xane. ");
INSERT INTO pabNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hatyo xowakehenaite hoka kahare ite nehenaha nohiye: “Xekohaseti, xekohaseti, hexare kakoa wiyakai iraeti Enore tahi, hexare kakoa kahare tihanarenai waxanikiheta halitinai nonitata, kahare maomakahare waiyexe wisoma”, nexahaite nohiye. ");
INSERT INTO pabNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Xakore hoka nomihenaite ihiyeha: “Maisa nowaiyanihare xini xiso. Xakikisoahetehena noniti, xiso atyo iniyalahare taita nomaseharenai”, nomihenaite ihiyeha — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","— Xala xamani atyo sema exe niraeni hoka tyaona exema hoka haliti hatya waiyorexe tyomehenere hahana sehali heno akerexeta atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tyoma hahana mematene hoka one kaloxehena hoka kahekoakoa moka exahita, exahe kinatyawiniti hoholatya hatyo hati xahita. Xakore hoka maisa exoakijitene, waiye nomakere sehali heno hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hoka xala xamani atyo sema exe niraeni hoka maisa tyaonita exema hoka haliti mairiharenehare tyomehenere hahana kaiholokoa akereta atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tyoma hahana mematene hoka one kaloxehena hoka kahekoakoa moka exahita, exahe kinatyawiniti hoholatya hatyo hati xahiyita hoka exoakikoatene. Exoakikoatene hoka mawenekoaretiterene akereta atyo — nexa Jesus xakai ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus halakisa hairaine hoka halitinai hakaharetyoa exaotyakira kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Maisa atyo xaotyakiyaho kakoa waiyoreterenai akerexeta xini aotyakijita hoka. Iraeta atyo iyateliti kakoare hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hatyaoseta Jesus exoaheta tyairi henoseta. Hoka hisoaka haliti xane exema. ");
INSERT INTO pabNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hatyaoseta jijikoahiti kahehare aijitere tyoa kaoka ehaliya hoka hakaoliri kakoa meholokoa enomana hoka nehena: — Xekohaseti, hawaiyehihetaiya natyo haokowi hoka hawaiyehihetaiya natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nexa hoka Jesus hakahe ekaokakisa ihiye hoka nehena: — Há, naokaite. Hawaiyehiheta atyo — nexa. Nexa taita ihiye hoka waiyehiheta rotita jijikoahitere nonitata. ");
INSERT INTO pabNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hatyaoseta Jesus nexa ihiye: — Hasemehena, awa atyo exehare hiyakaihena hatya hiye. Hiyanehena sacerdote nali hoka waiyahareheta hiso. Hatyaosetaite haisa kirakahare hoka fetatene Enore ana, Moisés aotyakihenere akereta. Hoka tyotyaha waiyoreha hikinaterehenere kakoa — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hatyaoseta Jesus xane kaoka wenakalati Cafarnaum nali. Kaokehena hoka hatya sorarenai xekohasehare tyoa ahalakoatene, irai maheta ekakoa, kasani Jesus aiyatelikiheta ewakanehare enomana aokita hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Hoka nexa: — Xekohaseti, nowakanihare kalore hokakita nohanyakota. Maisa moxomoxore, masakare waolitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","— Notyoaite hoka naiyatelikihetene homana — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Hoka sorare xekohasehare nehena ihiye: — Maisaiya hijoíta nohanyako, Xekohaseti. Hiyaiya, natyo atyo hikatyahakohare. Kala hiraihena taita hoka nowakanihare kinatereheta nomani — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","— Natyo tehitiya atyo haiyanai xekohasetinai katyahakoreta notyaonita hoka wakatyahitaha natyo. Nosorarexinai atyo nowakani xema tyaonahitaha. Niraihena hatya hiye: “Hiyane”, nomihena ihiye hoka xaneta. Hatya hiye, “Hisohena”, nomihena hoka tyoita. Exahe nowakanihare hiye, “Hisoma nikare”, nomihena hoka tyomita — nexa sorare xekohasehare Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hatyaoseta Jesus hakaharetyoa sema hatyo iniraine hoka nexa haxema tyoiterenai hiye: — Kaxiyani, aliterexe niraeta xihiye, maisa xoana xowaka exakere kalore tyakekotyati nowaiyare Israel hotyalinai koni — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","— Xotyaxematyaira exeharenai: kahare halitinaite tyohena, kamai nihikoane maniyata, exahe kamai xisoane maniyata hoka tyokehena mexa haliya Abraão, Isaque, Jacó harenai kakoa, Xekohaseti enokoatare kalorexe tyaohenere xowaka. ");
INSERT INTO pabNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hoka hatyo nali tyoka mahetarenai ene ite kaxawatyaka makaliroti koni. Hoka hatyo nalite tiyaha exahe haikolinaiha, “karai, karai”, nexa mokaha — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hatyaoseta Jesus nehena sorare xekohasehare hiye: — Hiyanehetehena hihana xeta. Hityakekone akereta koxaka kaomaka — nexa ihiye. Hatyo xowakita ewakanehare kinatereheta. ");
INSERT INTO pabNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hatyaoseta Jesus xane Pedro hanako, waiyehena atyo, owene atyo Pedro nimasero kamakoa ehokotyoita, watyahiseta hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hoka Jesus otokene ekahe hiye hoka ewatyahisene tyoteheta enonita. Hoka ainakoaheta, xane enakaira tyoma enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Makakoahena hoka halitinai Jesus ana kahare tihanare kamilakoreraharenai kolatyaha hoka haserore irae hoka tihanare axanikihitita. Exahe haiyanai hoka hokakiterenai tyotyaha aiyatelikihitita. ");
INSERT INTO pabNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesus nikare tyoma iraiti xakaisasehare Isaías xakaitere akere kawenatyakeheta maheta: “Hatyo atyo kolatya wikahehare, exahe wihokakene hoka kolatya”, nexa atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hatyaoseta Jesus waiya haliti hisoakene hahoko haliya, hoka irae haxaotyakiraharenai hiye, xaneha maheta Galiléia xa halakoiya maniya. ");
INSERT INTO pabNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hatyaoseta hatya xaotyakiyaho kakoa waiyoretere tyoa kaoka hoka nexa ihiye: — Xaotyakisatiye, notyoaite hiyema, aliyo xamani hiyanehena hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hoka Jesus nexa: — Wakarenai atyo kahanere waikoako, exahe kotehalanai hoka kaihexe — nexa Jesus ihiye. — Xakore hoka Haliti Ityani atyo maisa xoare ako kawiniye — nexa. (Haxaokakita “Haliti Ityani”, Jesus nexa.) ");
INSERT INTO pabNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hatyaoseta hatya Jesus xaotyakirahare nehena: — Xekohaseti, awisa hoka noxani nahaikoaheta hoka baba waini hoka nafetene hotohare hoka hatyaosetaite notyoa hiyema — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hoka Jesus nexa ihiye: — Hisohena noximi, kotare kamatinai fityaha hakamane hatyanai — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hatyaoseta Jesus isoa kanowa ako hoka exaotyakiraharenai tehitiya xaneha exema. ");
INSERT INTO pabNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Xanahitaha onexa hoka kinatyawiniti kaoka enomanaha, one ainakiyatya hoka jiyahaotita kanowa. Jesus hatyo xowaka nemakita. ");
INSERT INTO pabNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hatyaoseta exaotyakiraharenai kaosetene hoka nexaha ihiye: — Xekohaseti, hakahinaehena wiso, wiwainihenaore — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hoka Jesus nexa: — Xoana hoka ximairita? Xoana hoka inira xityakekone tyaonita? nexa ihiyeha. Nexa ihiyeha hoka tityoaheta hoka watyali hoholati, one xoaha hoka tyotya, memakeheta. ");
INSERT INTO pabNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hatyaoseta exaotyakiraharenai hakaharetyoaha hoka nexaha: — Xoare halitini ala exe hoka one, hoholati xoaha hiye irae hoka aokitere akereta tyaonaha? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hatyaoseta Jesus xane Galiléiaxa halakoiya maniya, Gadara koa nali xane kaoka. Kaoka taita hatyo nali hoka hinamahare tihanarenai kamilakoreranai tyoa ahalakoatene. Xawatyakalatinai koni tyaonahitaha hoka hatyo nalita tyoahita. Kinatereha, xalijinihareha hoka maisa xala hare hatyo ahoti aho jiya aokowiye. ");
INSERT INTO pabNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tyoa ahalakoatyaha Jesus hoka nexaha: — Xoare haoka wihiye, Enore Ityani? Xoana, hisoa hoka iniyalahare hamoka wiso maheta imiyanaose ferakene nahitita? nexaha kawiyatyaha kinatyaxa. ");
INSERT INTO pabNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hatyo xowaka bolokonai hatyo haliyita nisakoatita. ");
INSERT INTO pabNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hoka tihanarenai nehena Jesus hiye: — Haihikoaheta haokowita wiso halitinai milakota hoka haxikatya wiso bolokonai milako — nexaha tihityoaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","— Xiyanehena atyo — nexa Jesus. Hatyaoseta tihanarenai hikoaheta halitinai milakota hoka xane isoaha bolokonai milako. Hatyaoseta bolokonai tema exoahenahitaha tyairi henota hoka xane exoaha hokoxa, monaha hoka tyotyaha wainiha. ");
INSERT INTO pabNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hatyaoseta boloko kaxaikotyasenai tekoahenahitaha hoka xanehenahitaha wenakalati xeta hoka xakaihaha hatyo tahi naliyerenai hiye, hatyo hinamahare halitinai kakamilakotyakiterenai tahi. ");
INSERT INTO pabNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hatyaoseta hatyo wenakalati tyaoniterenai tyotya tyoaha waiyaha Jesus maheta. Tyoa waiyahene hoka kasani Jesus xaneneheta hatyo ewaikoheraha koata aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hatyaoseta Jesus xane tyokeheta kanowa ako hoka haikoaheta halakoiya maniya, xane kaokeheta hawenakala. ");
INSERT INTO pabNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hatyaoseta kaokeheta hoka kolatyaha hatya maetonanehare exetolisoakala kakoita enomana. Jesus waiya ityakekoneha hoka nexa maetonanehare hiye: — Nohinaehare, hihalaharehena, koxaka kaxemaisatyakeheta iniyalahare hománe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nexa hoka haiyaharenai xaotyakiyaho kakoa waiyoreterenai ahekohenaha hatyakoiyaharenaiha: — Exe haliti maisa aiminisare Enore — nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hoka Jesus otya exahekolaha hoka nehena: — Xoana hoka hatyohare iniyalahare xahekotita? ");
INSERT INTO pabNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Xoarehare ala haxerore niraetyaka: “Iniyalahare hománenai atyo kaxemaisatyakeheta”, nerekatihenaite, xoana, “Hatityoahetehena hoka hatohetehena”, nerekatihena koríte? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hiyaiya, nahotikisaite xomana. Natyo Haliti Ityani atyo iyateliti kakoare notyaonita ali waikohekoa halitinai nómane iniyalahare emaisatyaheta maheta — nexa. Hatyaoseta ehaikoa hoka nexa maetonanehare hiye: — Hatityoahetehena hoka hiyehetehena hiyetolisoakala hoka hiyanehetehena hihana xeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nexa hoka maetonanehare tityoaheta hoka xaneheta hahana xeta. ");
INSERT INTO pabNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kahare haliti wahakoita hoka waiyaha hatyohare hoka mairaha. Hatyo hiyeta ihalahareha Enore kakoa, iyateliti isehenahere halitinai ana hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hatyaoseta Jesus xanehitita ene nalita hoka waiya hatya haliti, Mateus nexarexe, tyokita olo resebityakaose nali hoka: — Hisohena noximi — nexa Jesus ihiye. Hoka Mateus tityoaheta hoka xane exema. ");
INSERT INTO pabNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hatyaoseta Jesus xane Mateus hanako hoka kanakaira. Kanakairita hoka kahare haiyaharenai olo resebityaseharenai, haiyanai iniyalahare nomaseharenai xoaha kaokaha hoka tyokaha mexa haliya hoka kanakairaha Jesus exahe exaotyakiraharenai xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hoka haiyaharenai fariseunai waiyaha Jesus enekonyaha hoka axaha exaotyakiraharenai: — Xoana hoka Xiyaotyakisase kanakairita exe olo resebityaseharenai exahe iniyalahare tyomiterenai xoaha kakoa? nexaha axahene. ");
INSERT INTO pabNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hoka Jesus sema hatyo exaxanahene hoka nehena: — Mahokakeneharenai atyo maisa wairatyare aokare haomana, hoka hokakiterenai wairatyare aokita haomana. ");
INSERT INTO pabNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Maika xahekohena exe iraiti kaxairatyakehenere iraiti waiyexe nanekoa hoka waiyekehalaka xomana. Hiyaiya, nexa atyo: Kasani maisa kirakahare kafetatyaka nomani naokare. Kasani haliti waiye moka hahinaehare naokita exahe airakoaneharetene naokita. Hiyaiya, notyoa atyo naotyakisa maheta iniyalahare nomaseharenai, maisa atyo waiyexeharexenai naotyakisa maheta xini — nexa Jesus iniraineha nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hatyaoseta João xaotyakiraharenai tyoa kaokaha Jesus ana hoka axahene: — Wiso, exahe fariseunai kahaliki wimanakairita Enore hiyeta. Hoka hiyaotyakiraharenai atyo maisa manakairere Enore hiyeta. Xoana hoka? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hoka Jesus nexa ihiyeha: — Wenakakoati ana kakaexakatyakehenerenai atyo maisa amaikoharexe, kaiyanityohenere enaliha tyaonita hoka. Hoka haxowakaite kaiyanityohenere kaiyakeheta enekonitaha, hoka hatyo xowaka atyoite manakairehenaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","— Exe tehitiya: maisa xala hare tinolaharehena imiti xololo hoka imiti waitare kakoa tinolaharetyare. Waiya aliya hoka waitare taose emolisoa hoka halalahitiya imiti xololo hoka exahehariya ehalalakoane moka. ");
INSERT INTO pabNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","— Exe tehitiya: maisa atyo vinho waitarexa kaxomokakere toahiyere militirise nomaka ako. Nikareya kaxomokaka hoka halalakoaiya militirise hoka vinhoxaiya iratyoa tyotya, exaheya militirise hoka mawenekoare. Hatyo hiyeta vinho waitarexa militirise waitare ako taita kaxomokakita. Nikare hoka waiye — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus iraetata halitinai hiye hoka hatya xekohaseti judeu tyoa kaoka enomana, meholokoa hakaolise kakoa enahalakoa hoka nehena: — Nityani owa waini. Hisohena hoka hikahe hekaokakisa ihiye hoka kaseheta nomani — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nexa hoka Jesus xane exema. Exaotyakiraharenai tehitiya xane. ");
INSERT INTO pabNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ahotita xanahitaha hoka hatya ohiro kaoka Jesus haliya, ihiniri maniya. 12-terehokoanehena hokakita, timalati hikoata minita ihiyeta. Hatyo tyoa ihinirako maniyata hoka ekaokakisa hakahe inima kilihi hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Exakere ahekohalotyoita: — Nekaokakisa taitaiya nokahe inima kilihi hiye hoka nawaiyehaloheta — nita. ");
INSERT INTO pabNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hatyaoseta Jesus terehokoa waiyahokotyoa hoka waiya hatyo ohiro hoka nehena ihiye: — Ehekore nikare hisaonita! Hawaiyehaloheta atyo hityakekone hiyeta — nexa. Exowakita hatyo ohiro waiyehaloheta rotita. ");
INSERT INTO pabNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hatyo najikinita Jesus jiyihitiya xekohaseti hana xeta. Xane kaokehena hoka sema exaimahalikiraha xerati xafityati niyahare. Kahare sema werahaliti, osexati hare hoka ");
INSERT INTO pabNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nexa ihiyeha: — Xahikoahetehena xityotya alita. Exe xoimahaloti maisa waini xini, nemakitata — nexa. Nexa hoka koexahalisahene, ehatyaharene aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hatyaoseta hikoahetaha hoka Jesus isoa hatyo kamati tyaonitere ako, otokene ekahe hiye hoka kaseheta hoka tityoaheta. ");
INSERT INTO pabNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hatyo tahi tyotya hakakoare hatyokoarenai sema. ");
INSERT INTO pabNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hatyo nalita Jesus jiyihitiya hoka ahoti, hinamahare maxosehare kawihisexematene: — Hairakoaneharehena wiso, Davi jikolahare — nexaha kawiyatyaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hatyaoseta Jesus xane isoa hatyako hoka maxoseharenai xane kaokaha ehaliya hoka Jesus nexa axahene: — Xoana xityakekota nowairatyani xiso kakoa? nexa. — Há, wityakekota atyo — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hatyaoseta Jesus ekaokakisa hakahe exosenaiha hiye hoka nexa: — Maika kaomaka xityakekone akereta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hatyaoseta exosenaiha waiyeheta hoka waiyakatyarehetaha. Hatyaoseta Jesus nexa ihiyeha: — Xasemehena, awa atyo xiyakaihenene hatya hiye. Xasemaira niraeni — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nexa xakore ihiyeha hoka xanehenahitaha hoka xakaikoatyaha hatyo tahi tyotya hatyo koarenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hatyo hinamaharenai xanehetaha Jesus nonita hoka haiyaharenai kolatyaha mairainehare enomana. Tihanare kamilakoretitene hoka mairainititene. ");
INSERT INTO pabNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hatyaoseta Jesus axanekiheta tihanare hoka iraeheta. Hatyaoseta tyotyaha hakaharetyoaha hoka nexaha: — Maisa xoana xowaka exakere wiyaiyare ali Israel waikoherakoa — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hoka fariseunai nehena: — Kala tihanarenai xekohasehare tyaonita ekakoa hoka aiyatelikisene hoka axanekihitita tihanarenae halitinai nonitata — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hatyaoseta Jesus xaneta wenakalatinai nihatyaka, aotyakisahitene xahohisakoatyakalati hanako. Iraiti Waiyexe kalorexe enokoatare tahi xakaita ihiyeha. Hoka aiyatelikihitita halitinai, ekahehareha exahe ehokakeneha nonitata. ");
INSERT INTO pabNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesus waiya haliti hisoakere hoka airakoaneharetyahene. Hatyo halitinai kirakoane tyaonahitaha, exahe makahinaetyakahareha hoka. Motya kalanero makaxaikotyakahare tyaonitere akereta tyaonahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hatyaoseta Jesus nexa haxaotyakiraharenai hiye: — Nakairati xírikotyaka atyo kahare. Xakore atyo hoka hatenitiyenai atyo maisa kaharexe. ");
INSERT INTO pabNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Xaxehena masene xekohasehare hoka axikahitiya hatenitiye hoka irikotyahene — nexa Jesus. (Halitinai xaokaka nikare iraeta). ");
INSERT INTO pabNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Hatyaoseta Jesus kawisa 12-hare haxaotyakiraharenai hoka isa enomanaha iyateliti axanekihenahitaha isekohaliti metalaharenai, tyotya kakaheharexenai exahe hokakiterenai hoka aiyatelikihenahitaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Exe atyo 12-hare exaotyakiraharenai nexare: hetatiye atyo Simão, Pedro tehitiya atyo enexarexe, haximarene André kakoa. Tiago haximarene João kakoita, Zebedeu ityaninai atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe, Bartolomeu, Tomé, Mateus xoaha. Mateus atyo kalorexe noloxa resebityasehare. Alfeu ityani Tiago, Tadeu, ");
INSERT INTO pabNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simão Canaã yere, Judas Iscariotes xoaha. Hatyo Judas atyo Jesus matawatyasehare. ");
INSERT INTO pabNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hatyaoseta Jesus axikatya hatyo 12-hare halitinai koni. Xanehenaha hoka nexa ihiyeha: — Awaira atyo majudeuneharenai tyaonitere nali xiyanehena, exahe awa atyo xiyane xikaokehena Samaria yerenai nawenakalanai nali. ");
INSERT INTO pabNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xiyanira xatawehena Israel hotyalinai xahita hotohare. Hatyonai atyo kalaneronai hehanitere akereta tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xiyane hoka xiyakai iraiti ihiyeha. “Okoi Xekohaseti enokoatare kalorexe tyaohena”, xexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xawaiyehiheta jijikoahiterenai, hokakiti harenai xaiyatelikiheta. Xekasekiheta kamatinai enomanaha, xaxanikiheta tihanarenai enonyahitaha xoaha. Maxaimanehareta atyo kaxekakita xomana hoka hatyo hiyeta xisehena maxaimanehareta. ");
INSERT INTO pabNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Awa atyo xakolahena xibosane ako ouro, prata exahe cobre hoko harenai. ");
INSERT INTO pabNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Xiyanehena hoka awa atyo xisakolane, ximanase hinamate, xiberekatane, xatyakasera harenai xakolatya. Hiyaiya, hakiterenaiya atyo maisa aliyakere makahinaetyakahare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","— Xiyane xikaokehena wenakalati exahe kiranexe wenakalatikoa hoka xatawa haliti waiyexe xahita, hoka waiye moka xiso hoka xisaona ehaliya xiyaneneheta kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Maika xisoahena hatyako hoka xexa: “Wenati waiyexe waoka xomana”, xexa. ");
INSERT INTO pabNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hatyoako tyaoniterenai waiye mokaha xiso hoka maika mehexaikohaliti xaoka enomanaha. Hoka maika maisa waiyexeharexeha hoka xemaisaheta enonyahitaha xiraehenere. ");
INSERT INTO pabNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aliyako xamani hatyako exahe wenakalati tyaoniterenai maisa waiye mokahitaha xiso, exahe maisa semaxematyaha aokowiyahitaha xiraine hoka maika nalita xiyanehitiya hoka xiberekatane xamokotyahatya xexoakiheta maheta waikohese naliyerenai waiyane maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aliterexe nomita xihiye: imiyanaose Enore axalihenere halitinai xowakiyaite, iniyalahare moka hatyo wenakalati tyaoniterenai Sodoma exahe Gomorra xahexe ite mokahene — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","— Xasemehena: naxikaita atyo xiso halitinai koni kalaneronai xanetere ahoxanai koni akereta. Hiyeta hoka xiriharíra xisaona owi akereta, watyaha maxalijiniharenehare tyaonitere akeretaira xisaona enekonyaha. ");
INSERT INTO pabNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xiriharíra xisaona. Hiyaiya, olatyahaite xiso hoka nolokahaite xiso kalorexenai ana, mokonasetyahaite xiso xahohisakoatyakalati hanako. ");
INSERT INTO pabNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nohiyetaite xikakolatyaka xekohaseti exahe kalorexenai ana, axaliha maheta xiso. Hatyo xowakiyaite xiyakai iraiti waiyexe enomanaha, exahe majudeuneharenai ana hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Awa atyo kolahenaha xiso axahenaha xiso maheta hoka ximawaiyeharehena xiraene kakoa. Hatyo xowakehena atyoite hoka Enore isehena xomana iraiti xirai maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hiyaiya, xiraehenere atyoite maisa xiraene xini, xakore hoka Xexe Nisekohare atyoite iraehena xikoamaniyata — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","— Haiyaharenaite haximarene kaiserehare isehena hoka kaxaisakehena. Nikaretaite enexenaiha haisaninaeha mohena. Hoka ityaninaehaite kahalakoahareha hanexenaeha hanityonaeha kakoa hoka axaisakisahene. ");
INSERT INTO pabNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tyotyahaite kirawaneha xiso nohiyiti. Hoka xala xamani atyoite tyaona noximi miyanitiye ferakene kijiya hoka hatyo atyoite kaiyakeheta iniyalahare nonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","— Maika hakoa wenakalati tyaoniterenai iniyalahare mohenaha xiso hoka xisekoa hakoa xeta. Aliterexe nomita xihiye: maisaite komita ene xiyaneta Israel hotyalinai nawenakala nihatyaka hekoti Haliti Ityani tyoaneneheta nahitita. ");
INSERT INTO pabNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","— Maisa exaotyakirahare haxaotyakisase xahexe tyaonare, exahe wakahare hoka haxekohase xahexe tyaonare. ");
INSERT INTO pabNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Exaotyakirahare atyoite haxaotyakisase akereta tyaohena, exahe wakahare hoka haxekohase akereta. “Belzebu, tihanare xekohasehare”, nexahaiya exekohaseha xaokaka hoka ewakaneharenai tehitiyaiya atyoite exahehare nexare niyalahare kakaexaretyaka. ");
INSERT INTO pabNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","— Xakore atyo hoka awa atyo ximaira halitinai. Hiyaiya, tyotya xoalini hare kaxateroakisakiterenaite maxateroakisakeheta, metahare tyaoniterenaite kawaiyakeheta. ");
INSERT INTO pabNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Maika exe makaliroti koni wiwawaharenai niraetere xihiye xiyakai halitinai hiye, exahe nawaiyeta niraetere xihiye kinatyaxa xiyakaiheta hati maiyeho nalita. ");
INSERT INTO pabNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","— Awa atyo ximairehena, aisehena hoka xiháre taita aijitere hoka xíyawa maxaisanetere. Hoka maika ximairehena Enore. Hatyoiya atyo mawenekoaretya xiso xiháre, xíyawa harenai kakoita irikati koni. ");
INSERT INTO pabNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","— Haiya xowaka hinamali kotehalase kabetityakita olo hokosenai xaimanexe. Xakore atyo hoka hatyonaiya atyo maisa ixoita waikoa Enore maxaokareneta. ");
INSERT INTO pabNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hoka xiso atyo xisekasenai kakoita tyotya ixihatyakahare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hatyo hiyeta awa atyo ximawaiyehare. Hiyaiya, hisoakere kotehalasenai xahehare atyo xiso. ");
INSERT INTO pabNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","— Hoka tyotya iraihenere nomaniye aokowihenerenai haotikatita tahite natyoisa nirae Baba enokoa tyaonitere haotita. ");
INSERT INTO pabNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Xala xamani atyo maisa nokoamaniye nawenatyasehare aokowita halitinai haoti hoka natyo tehitiyaiya atyo Baba haoti, “Maisa atyo exe nokoamaniye nawenatyasehare xini”, nomi. ");
INSERT INTO pabNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","— Awa atyo motya notyoa waiyexe wenati nakolatya maheta halitinai ana xaohena. Notyoa naxalijinihalikisa maheta halitinai. ");
INSERT INTO pabNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Notyoa atyo naxalijinihalikisa haliti hoka kahalakoahareha hanexenai kakoa maheta, exahe haloti hoka kahalakoahalo maheta hanityo kakoa. Haiyahalonai haimaseronaeha kakoa kahalakoahaloha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nikare ite hoka haliti nahalakoahare kaheneharexe atyoite ehanako tyaoniterenai terota. ");
INSERT INTO pabNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","— Xala xamani atyoite awaiyetita hanityo exahe hanexe noxahexe hoka maisaiya atyo aliyakere noximi tyaonita. Xala xamaniya awaiyetita haisaninai noxahexe hoka maisaiya atyo aliyakere noximi tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Xala taita xamaniya atyo kolatya atyalihose xaimaholatyaka hakamanetyakala niyahare hoka tyoa noximi hoka hatyoiya atyo noximi tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Xala xamani atyoite wenati waiyexe tawita hoka meta atyoite enonita. Hoka xala xamani atyoite nokoamaniye tyaonita hoka nohiyiti waini hoka hatyo atyoite kaoka wenati waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","— Xala xamani atyo waiye mokita xiso hoka waiye atyo mokita natyo. Nikare waiye mokita natyo hoka waiye atyo mokita noxaxikatyasehare Enore. ");
INSERT INTO pabNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Xala xamani atyoite waiye moka iraiti xakaisasehare, Enore niraine kakoare aokene hoka kaxekakaite enomana xoalini hare waiyexe hatyo nahalakoa. Xala xamani atyoite waiye mokita waiye maniya tyaonitere, waiye maniya tyaonitere hiyeta hoka, hatyo nahalakoaite kaxekaka enomana xoalini hare waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","— Xotyaxematya exeharenai: xala xamani atyoite hakobone one wehexere taita isa noxaotyakirihare ana, noxaotyakirihare aohenere hiyeta hoka hatyo nahalakoa atyoite kaxekaka enomana xoalini hare waiyexe — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hatyaoseta Jesus miyatya hairaine 12-hare haxaotyakiraharenai hiye hoka xanehitiya hatyo nalita, xane aotyakihitiya, xakaihitiya iraiti waiyexe hatyo haliyaseta wenakalati tyaoniterenai koa. ");
INSERT INTO pabNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hatyo xowaka João koxaka berexo ako tyaonita hoka sema Cristo nómanenai tahi hoka haxaotyakiraharenai axikatya Jesus axaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","— Xoana hiso etake kaokehenere, xoana hatya korite watyahahitiya? ");
INSERT INTO pabNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","— Xahaikoahetehena hoka xiyakai João hiye xasemehenere, xiyaiyehenere tahi — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","— Maxoseharenai waiyakahitita, mawaiye netonaneharenai waiye netonanehitita, jijikoahiti tawaneharenai waiyehihitita, masemakalaharenai semakahitita, kamatinai kasehitita. Exahe Iraiti Waiyexe atyo kaxakaisakita maoloxaharenae hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Waiye kaiserehare atyo tyakekoterenai natyo hoka maisa amaikoharexe nokakoi — nexa Jesus João xaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","João xaotyakiraharenai xaneheta hoka Jesus iraihena João tahi halitinai hiye: — Xiyanehenere maharexakahare xahalakoahenere João xowaka, xoarehare xatyahita xiyaiyane maheta? Xoana kána kase hoholati hoholaitere? ");
INSERT INTO pabNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hoka xoare xiyaiya maheta xiyane? Xoana hatya haliti imiti waiyehare akore xiyaiya xaokowi? Imiti waiyeharexe ako ijoiterenai atyo tyaonita hati wahaharexe ako. ");
INSERT INTO pabNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hoka xiyakaihena nohiye: xoare xatyahita xiyaiya maheta? Xoana iraiti xakaisasehare aliterexe? Aliterexe atyo nomita xihiye: xiyaiyehenere atyo iraiti xakaisasehare xahehare. ");
INSERT INTO pabNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Exakere xairatyoare tyaonita Iraiti Waiyexe nanekoa João tahi: Hasemehena, naxikatyaite haliti haheta maniya niraini kakoare hoka memere moka ahoti haheta maniya. ");
INSERT INTO pabNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","— Aliterexe nomita xihiye: João Batista atyo tyotya halitinai xahehare. Xakore hoka xala xamani atyo ekatyahakohareta tyaonita enokoa nali hoka hatyo atyo João xahehare tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","João Batista xakaihakaitere xowakiyata kalikini kijiya enokoatare tahi iniyalahare kairaetyakita. Xalijiniharexenai iraeta etahi, kasani jiyahaotyahene aokowiyahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hiyaiya, Moisés exahe iraiti xakaisaseharenai xoaha xakaiha Enore xaotyakira João kaotyakehenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Xityakeko atyo iniraeneha xaokowi hoka xityakeko: João atyo Elias, hatyo haikoahaneheta atyo aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","— Hoka xoare kakoaite naimenekohena kalikiniyerenai? Kalikiniyerenai atyo motya xoimanai tyokitere wetekokoa akereta tyaonahitaha, hahotyali kawiyatitere hahotyali ana akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Waemahalikisa wenakakoati anere xerati xakore hoka maisa xaholikoita. Wiyera xafityati anere xerati xakore hoka maisa xitiyita”. ");
INSERT INTO pabNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","— Hiyaiya, João atyo manakairita, maeraneta vinhoxa hoka tyotya nexahitaha: “Tihanare atyo tyaonita ekakoa!” ");
INSERT INTO pabNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hoka Haliti Ityani kanakairihena, terehena, hoka nexahitaha: “Xiyaiyehena, exe haliti atyo kanakairatetyoita, teratetyoita, etake kalorexe noloxa resebetyaseharenai exahe iniyalahare nomaseharenai xoaha hinaihare!” Xakore atyoite hoka ekakoitaite Enore nawaiyorene katyakekotyakehena — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hatyaoseta Jesus amaikohare wenakalatinai koa tyaoniterenai hiyeta. Kahare xoalini hare maomakahare waiyexe tyoma ehaotiha hoka maisa halakisahitaha iniyalahare háomaneha hoka hatyo hiyeta Jesus amaikohare. Hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","— Kirakoane ite hisaohena, wenakalati Corazim! Kirakoane ite hisaohena, wenakalati Betsaida! Hiyaiya, waiyexenai mawaiyakaharenai kaomakehenere hatyo hinaliyeya atyo kaomakere wenakalatikoanai Tiro, Sidom xoaha nali hoka hatyo naliyerenaiya atyo koxaka toahiyita halakihenahitaha háomaneha iniyalahare. Hotikisahaiya atyo aokowiha iniyalahare hahalakiraha hoka tyokahaiya atyo tataolate nimere exahe mokahaiya irikati niyehe haseriha hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Natyo atyo nomita: Xaxalisati Ferakene ite Enore ite airakoaneharetya Tiro, Sidom xoahanae koa tyaoniterenai xiso Corazim, Betsaida xoahanae koa tyaoniterenai nonitata. ");
INSERT INTO pabNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","— Exahe xiso wenakalati Cafarnaum nali tyaoniterenai: xoana xiyahekola hiye motyaite enokoa xikaoka xaokita? Xikaxawatyaka atyoite kamatinai tyaonitere nali. Ekoiya atyo maomakahare waiyexe kaomakere wenakalati Sodoma nali, xinali kaomakehenere akereta hoka kalikiniya atyo hekotata tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Xasemehena, xaxalisati ferakenehena xowakiyaite Enore ite airakoaneharetya Sodoma yerenai xiso Cafarnaum nali tyaoniterenai nonitata — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hatyo xowakiya Jesus nexa: — Abá, hiso atyo enokoa, waikoa xoaha Xekohasehare. Nihalahare hikakoa, hawaiyekehalakehenere hitahi akiti xoimanai exahe mawaiyoreharenai ana hiyeta. Hoka waiyorexe, semarexe tyaohenerenai ana atyo metahare hamoka hitahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aliterexe, Abá, hatyoharenai atyo kaomaka hiyaokala exahe haokitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Baba atyo halakisa nomani tyotya xoalini hare. Maisa atyo xala hare waiyorexe Ityani kakoa. Enexe taita atyo waiyoreta ekakoa. Maisa atyo xala hare waiyorexe Enexe kakoa. Ityani taita atyo waiyoreta ekakoa, exahe haiyaharenai ana awaiyekehalakatene hoka hatyonai tehitiya atyo waiyoreta ekakoa — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","— Xisohena nomani, xityotya xiso xikirahareterenai xikolalanai timinitere xihiye hoka nekawinikisa xiso. ");
INSERT INTO pabNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nokoamaniye nawenatyaseharenai xisaohena hoka xawaiyore noxaotyakiraho kakoa. Natyo atyo nawaiyexehare, maisa atyo noxalijiniharexe, xisaonaiya noximi hoka xikaokaiya xikawinini niyahare. ");
INSERT INTO pabNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Xoalini hare xisoma naokitereharenai atyo maisa howitiharexe xini, kolare namokitere xiheno atyo amala — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hatyo najikinita, sábado xowaka Jesus jiyehena trigo xafityaka koni. Hoka exaotyakiraharenai nakita hoka trigo xawase taikaha hoka esé kanakairaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hatyaoseta fariseunai waiyahene hoka nexaha Jesus hiye: — Hiyaiyehena, hiyaotyakiraharenai sábado xowaka wiyaotyakisakaho mahokoanetiterehare tyomahitaha — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hoka Jesus nehena: — Xoana maisa xasemare Davi, ihinaeharenai xoaha nakita hoka tyomehenere? ");
INSERT INTO pabNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davi atyo isoa Enore hanako hoka nakairati Enore anere fetatyaka kanakaira hahinaeharenai kakoa. Nikare xakore xaotyakisatyaho mahokoanetita hoka. Sacerdotenai taita xakore nikare kanakairita hatyo nakairati hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","— Xoana maisa xakaixaritita babera Moisés xaotyakira xairatyoare tyaohenere nanekoa? Sábado xowaka atyo sacerdotenai Iraexatyakalati Hanako hakahitaha xakore hoka maisa atyo xaotyakiyaho aokitere akereta tyaonareha. Xakore hoka maisa atyo kairaityakere etahiha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","— Aliterexe nomita xihiye: ali hatya hatyo hati xahehare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xawaiyoretaiya exakerexe xairatyoare tyaohenere iraiti waiyexe nanekoa nehenere: “Kasani maisa kirakahare kafetatyaka nomani naokare. Kasani haliti waiye moka hahinaehare naokita exahe airakoaneharetene naokita”, nitere kakoa hoka maisaiya iniyalahare xamokita haliti waiyexeharexe. ");
INSERT INTO pabNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hiyaiya, Haliti Ityani tehitiya atyo sábado Xekohasehare — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Hatyaoseta Jesus, hatyo nalita xaneheta hoka xane xahohisakoatyakalati hana xeta. ");
INSERT INTO pabNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Xane isoa hatyoako hoka hatyo nali hatya haliti hamaniya nirakahexe tyaonita. Hatyaoseta haiyaharenai Jesus iraeharetyaha aokowiterenai emaxaiminirene xaotyakisatyaho hiyeta axehenahene: — Xoana wiyaotyakisakahohiyetaiya waiyehena wawairatya sábado xowaka? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hoka Jesus nehena: — Xikakalaneroxereya hoka exoaiya tolokoako sábado xowaka hoka maisaiya xiyehititene? ");
INSERT INTO pabNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Haliti atyo kalanero xahexe. Hiyeta hoka sábado xowaka haiyanai wakahinaetya aokita wiyaotyakisakaho — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hatyaoseta Jesus nexa hatyo haliti nirakahexe hiye: — Haimahena hikahe — nexa. Aimatya hakahe hoka waiyeheta, hakakoa hamaniya kahe kakoa tyaoneheta. ");
INSERT INTO pabNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hatyaoseta fariseunai hikoaheta hatyoakota. Ehareha Jesus hiye hoka aisahene aokowihenaha hoka iraekakoahenaha, ahekohenaha haxaisanahene tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus hatyo tahi sema hoka hatyo nalita xaneheta. Hoka kahare haliti xane exema hoka hokakiterenai tyotya aiyatelikiheta. ");
INSERT INTO pabNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hatyaoseta halitinai hiye hatahi akiti maxakaisakene aoka. ");
INSERT INTO pabNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nikarexe tyaona iraiti xakaisasehare Isaías iraetere akereta kawenatyakeheta maheta. Exakerexe atyo xairatya: ");
INSERT INTO pabNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Owene atyo nowakanihare naohenere, nawaiyititere, nihalahare mokita. Nisekohare ite nisa enomana hoka waiye ahekotya tyotya halitinai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Maisaite ehareta halitinai hiye, maisaite kinatyaxa iraeta halitinai kakoa. Maisaite xala hare semita iniraine wenakalati naho. ");
INSERT INTO pabNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Maisaite katyahita atya kano taikoane, maisaite ewakatita xaokanatyakalati ikalira aokanaitere. Hekoite aiyateretyoa wenati waiyexe maniya hoka ekakoita moka halitinai hatyoaho. ");
INSERT INTO pabNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Waikohekoa nihatyaka tyaoniterenaite atyahaha exahita tyaonaha exema maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hatyaoseta kolatyaha Jesus ana hatya haliti maxosehare, mairainehare. Tihanare nikare mokitene. Hatyaoseta Jesus awaiyehetene hoka waiyakaheta, iraiheta xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Halitinai waiyene hoka hakaharetyoaha. — Xoana exe haliti ala Davi jikolahare? nexa axakakoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hoka fariseunai semaha hatyo tahi hoka nehenaha: — Maisata Davi jikolahare xinika. Belzebu tihanarenai xekohasehareta isa iyateliti enomana hoka axanikihitita tihanarenai halitinai nonitata — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hatyaoseta Jesus otya exahekolaha hoka nehena: — Hakoa waikohekoa tyaoniterenaiya kirawanekakoaha hoka maisaiya kinatere tyaonehenahititaha, exaoretyakakoahaiya. Nikareya wenakalati tyaoniterenai exahe halyako tyaoniterenai kirawanekakoaha hoka xaorehaiya. ");
INSERT INTO pabNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nikareya Ahalakoahaliti wakaneharenai hatyokakoaha kirawanekakoaha hoka aliyakereya kinatere tyaohenahitiyaha? Xaorehaiya hoka maisaiya kinaterehenahititaha hoka kamawenekoaretyakaha rotitaiya. ");
INSERT INTO pabNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hoka xiso atyo Belzebu isa haiyatere nomani hoka hatyo kakoa naxanikihitita tihanarenai xaokita. Nikareya hoka xala isa iyateliti xiyaotyakiraharenai ana hoka axanekihitita tihanarenai halitinai nonitata? Nikare xaokita hoka maisaiya tyakekota xiso xiyaotyakiraharenai. ");
INSERT INTO pabNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aliterexe atyo Enore nisekohare niyatere hiyeta naxanikihitita isekohalitinai hoka hatyoharenai atyo hotikijita Enore koamaniya nawenatyaka koxaka kaokehenerehare xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","— Maisaiya xala hare ijoita haliti kinaterexe hanako hoka kaiwaharetitene maxolatyakahareta. Olatene hotohariya atyo hoka hatyaosetaiya kolaharetene ehanakota. ");
INSERT INTO pabNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","— Xala xamani atyo maisa kahinaetyare natyo hoka kahalakoahareta atyo nokakoi, xala xamani atyo maisa ahohisakoatyare nohakakoani hoka exaoretita atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","— Hiyeta hoka nomita: tyotya halitinai iniyalahare tyomitereharenai atyoite kamaotyanetyakeheta, exahe Enore kairaeharetyakiterehare tehitiya atyoite kamaotyanetyakeheta. Hoka xala xamaniya atyo Isekohaliti Waiyexe iraeharetya hoka maisaiya atyo aliyakere kaxemaisatyakehitita. ");
INSERT INTO pabNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Xala xamaniya iraeharetya Haliti Ityani hoka enajikini maniya emaotyanetyaka aoheta hoka kamaotyanetyakehetaiya atyo. Hoka xala xamaniya atyo iraeharetya Isekohaliti Waiyexe hoka maisaiya atyo aliyakere kaxemaisatyakehitita, kaliniye waikohekoa exahe etare tyohitiyere waikohekoa xowaka hoka kamaotyanetyakehitita. ");
INSERT INTO pabNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","— Atyali waiyexe xahiyoka xaokowita hoka atya kate waiyexe xafitya. Atya kate waiyexe atyo maisa ewaxirali kaliye, atya kate ewaxirahare atyo maisa waiyeri kaliye. Tyotya atyanai atyo irínai hiyeta waiyekehalakaharetaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","— Xisonae atyo xikahenehare owi akereta. Maisa xawaiyexe hoka aliyakeriya waiyexe xiraihena? Aliyakere xamani xiyahekola hoka xiyahekola akereta xahikoaita xikanasakota. ");
INSERT INTO pabNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Haliti waiyexe atyo kahare xoalini hare waiye ahekoita hoka hatyo akiti iraeta. Hoka haliti mawaiyexeharexe atyo kahare xoalini hare ewaxirahare ahekoita hoka hatyohare iniyalahare tahi atyo iraeta. ");
INSERT INTO pabNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","— Xasemehena niraini: miyanitiye xowaka Enore axalihenere halitinai xowakaite hatya xakini iraehetehena iniyalahare iraehenere tahi Enore hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hatyo xirainenai hiyeta atyoite xawaiyekehalakaharehena, xoana aliterexe xamani iniyalahare xisoma, xoana maisa xamani hoka — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hatyaoseta haiyanai xaotyakiyaho kakoa waiyoreterenai, fariseunai xoaha nehenaha Jesus hiye: — Kasani wiyaiya xoalini hare hománe waokowita, wityakeko maheta hiso, Xaotyakisatiye — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","— Kalikiniyerenai atyo maisa waiyexe, maisa tyakekoreha. Axahitaha xoalini hare nomaka tyakekoha maheta. Xakore hoka maisaiya xoare hare kaomakita ewaiyaneha maheta. Iraiti xakaisasehare Jonas tyaohenere akere taitaite kahotikisaka enomanaha tyakekoha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonas atyo hanamaki ferakene, hanamaki makene xoaha tyaona onexere najako. Nikare tehitiyaite Haliti Ityani hanamaki ferakene, hanamaki makene xoaha tyaona waikoako. ");
INSERT INTO pabNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","— Xaxalisati ferakenite Nínive nali tyaoniterenai tityoaha hoka iraeharehena xiso. Hiyaiya, halakisaha atyo iniyalahare háomaneha, semaha Jonas niraene hoka. Hoka natyo atyo nomita: kalikini ali tyaonitere atyo Jonas xahehare. ");
INSERT INTO pabNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Xaxalisati ferakenite xekohasetiro Sabá yolo ite tityoa hoka iraeharehena xiso. Hiyaiya, sekota atyo tyoa sema maheta Salomão nawaiyore xaotyakiranai. Hoka natyo atyo nomita: kalikini ali tyaonitere atyo Salomão xahehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","— Xasemehena, isekohaliti iniyalahare hikoahetehena haliti milakota hoka xane tonakoaita maonexakoahare akiti, tawita hakawininaose. Maisaiya kaokita hoka ");
INSERT INTO pabNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nita: “Nahaikoahetaite nohani nali xeta, notyohenere nalita”, nita. Hatyaoseta haikoaheta hoka hati aokitere firakore, iyomakore, waiye xomokakotyakere ana kaokihitita. ");
INSERT INTO pabNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hatyaoseta haikoaheta hoka xane nolokita hahotyali 7-harenai isekohalitinai exahehare niyalaharenai, hoka tyotyaha xane tyaonahitaha nali. Hatyo hiyeta hatyohare haliti nawenane hetatiye xahehare howitiharene tyaonita. Hoka nikarite kalikiniyerenai iniyalahare tyomiterenai tyaonaha — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Hatyaoseta Jesus iraetata halitinai kakoa hoka inityo, iximarenenai kaokaha. Menanakita tyaonaha, kasani iraeha ekakoa aokowiyahitaha hoka kawisahene. ");
INSERT INTO pabNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hatyaoseta hatya xane nexa Jesus hiye: — Hasemehena, hityo, hiximarenenai owene menanaka, iraeha aokowiyahitaha hikakoa — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hoka Jesus nehena: — Xalatya mama? Xalatya noximalininae? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hatyaoseta hotikisa haxaotyakiraharenai ana hoka nehena: — Xiyaiyehena, owene atyo mama, noximalininai. ");
INSERT INTO pabNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Xala xamani atyo tyaonita Baba enokoa tyaonitere aokitere akereta hoka hatyonai atyo noximalini, noximaloni, mama naokita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hatyo ferakeneta Jesus hikoaheta hatyakota, xane Galiléia xa haliya, xane tyoka one haliya hoka aotyakihena halitinai. ");
INSERT INTO pabNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ekakoita kaharehena halitinai hohisakoita enomana hoka xane kakoha kanowa ako hoka tyoka. Hoka halitinai atyo kaiholokoa tityoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Xakaihakahena ihiyeha kahare xoalini hare tahi hoka metahare hairaine moka enomanaha hoka nehena: — Hatya haliti xane fitya maheta hahananeharese. ");
INSERT INTO pabNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fitita ene hanakatise hoka haiyasenae exoa ahoti kilihi hoka kotehalanai kanakairehetene tyotya. ");
INSERT INTO pabNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Haiyasenai ehananese exoa kahare sehali tyaonitere akiti, inira waikohe akiti. Hatyo hanakatisenae haxerore hikoa, komita ene maisa waikohe aka hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hatyaoseta kamai hikoahena hoka watere aisehetene, maisa hateko katyahareta hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Haiyasenae exoa katohere tyaonitere akiti hoka katoherenae kinatere exahita hoka jiyahaotyahene, maisa aliyakere tyaona xaka. ");
INSERT INTO pabNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Haiyasenae atyo exoa waiyexe waikohe akiti, tyaonaha atyo waiyehare. Haiyanai 100-se kaséta, haiyanai 60-se kase, haiyanai 30-se xoaha atyo kaseha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","— Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hatyaoseta Jesus xaotyakiraharenae iraehenaha ekakoa: — Xoana hoka metahare hiraine hamoka hoka haotyakisahitene? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hoka Jesus nehena: — Xomana atyo Enore hotikijita ekoa maniya nawenatyaka metahareterehare hoka enomanaha atyo maisa hotikisarene. ");
INSERT INTO pabNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Xala xamani atyoite xoalini hare kakoare hoka kaxekakihitiyaite enomana hoka exahexe tyaona enomana. Hoka xala xamani atyoite maisa xoare hare enali aka hoka exahe inira kakoare hoka kaiyakeheta atyoite enonitata. ");
INSERT INTO pabNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hiyeta hoka metahare namokita niraini enomanaha. Hatyo halitinai atyo wahakotyahitaha xakore hoka maisa waiyakatyareha, semahitene xakore hoka maisa waiyekehalakere enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nikare tyaonahitaha iraiti xakaisasehare Isaías iraetere akereta tyaonaha maheta. Exakere Isaías xairatya: Xasemitene xakore hoka maisaite waiyekehalakita xomana, xawahakotyaite xakore hoka maisaite xoare xiyaita. ");
INSERT INTO pabNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Exe halitinai xahekola atyo maisa waiyexe, jihotyaha hatanakoakoha exahe haxosenaiha hoka. Ikoiya awa nikare tyaonahitaha hoka exosenahaiya waiyakaita, etanakoakonahaiya semita, waiyeya exahekolaha tyaonita hoka tyaonehenahitahaiya nokoamaniye hoka waiyeya namohenahitene, nexa Enore. ");
INSERT INTO pabNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Hoka Jesus nehitiya: — Waiye kaiserehare xiyosenai waiyakaita, exahe xitanakoakonai hoka semakaita. ");
INSERT INTO pabNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aliterexe nomita xihiye: toahiya kahare iraiti xakaisaseharenai, halitinai Enore anere hotyalinai harenai semaha aokowiha exe xasemitere, waiyaha aokowiha ene exe xiyaitere. Xakore hoka maisa aliyakere. ");
INSERT INTO pabNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","— Xasemehena hoka nawaiyekehalakatya xomana xafityatiye tahi kakoa, naimenekotya hoka metahare niraehenere. ");
INSERT INTO pabNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Haiyanai xakore atyo semaha iraiti, Xekohaseti enokoatare maniya nawenatyaka tahi akiti hoka maisa atyo waiyekehalakere enomanaha hoka hatyonai atyo hanakatise exoahenere ahoti kilihi akereta tyaonahitaha. Hoka Tihanare tyoa hoka iyehitita enonyahitaha kairaityakehenere ihiyeha hoka maotyanehenahititene. ");
INSERT INTO pabNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hanakatise exoahenere kaharexe sehalise akiti atyo semehena iraiti waiyexe hoka haihalahareneha kakoa aokahiterene haomanaha akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Xakore atyo hoka maisa atyo waha tyaonare exema, maisa katyaharexe hoka. Kirawanehenahene Iraiti Waiyexe hiyeta hoka haxerore halakihititere iraiti xema hawenane. ");
INSERT INTO pabNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Haiyanai atyo hanakatise exoahenere katohere koni akereta. Semaha xakore iraiti hoka ahekotyahitaha hawenaneha akiti exahe wisekoliti hare kakoa, exahe hawenaneha keharere akiti kakoa hoka maotyanehenahititaha iraiti hoka maisa tyaonareha exema. ");
INSERT INTO pabNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hoka haiyanai atyo hanakatise kaxafityakitere waikohekoa waiyexe akereta. Hatyonai atyo semaha iraeti hoka tyaonaha exema, exahe waiyekehalakita enomanaha hoka haiyaharenai 100-se, haiyanai 60-se, exahe haiyanai hoka 30-se xahexe kaseta. ");
INSERT INTO pabNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Hatyaoseta Jesus aimenekohitiya enomanaha hátahi. Hoka nehena: — Xekohaseti enokoatare koamaniya nawenatyaka atyo hatya haliti hanakatise waiyexe fititere hamasenekoa akereta atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Haxowaka xatini tyotyaha nemakahitaha hoka tyoa enahalakoahareha hoka fitya manakairatyakahare joio aokahitere trigo koni hoka xaneheta. ");
INSERT INTO pabNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hatyaoseta hananehalitinae hikoa hoka kekoareha, kaenaseha. Hoka hatyaoseta manakairatyakahare tehitiya kaotyaka. ");
INSERT INTO pabNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hatyaoseta ewakaneharenai tyoa iraehena hatyo masene waikatehare hiye: “Xekohaseti, waiyexe hanakatise takita atyo hafitya himasenekoa. Hoka aliyakere ala hoka manakairatyakahare tehitiya tyaona?” nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Kala hatya wahalakoahare nikare moka wiso”, nexa ihiyeha. Hoka nexa axahene: “Xoana, wamalaheta manakairatyakahare haokita?” nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Maisaiya”, nexa. “Waiya aliya hoka hatyo xamalahetehena hoka xamalaka tehitiyaiya trigo. ");
INSERT INTO pabNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kotare trigo exahe manakairatyakahare xoaha kekoareha haxawalita ixirikotyakaha kijiya. Hoka hatyo xowakehenaite hoka nomite ixirikotyaseharenai hiye: ‘Xamalahetaira manakairatyakahare hotohare hoka xolahisetyahene hoka xakeratyahene. Jikiniti maniyaira xirikotya trigo hoka xamokahene nakairati nitini ako’ ”, nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hatyaoseta Jesus aimenekohitiya enomanaha hatisa tahi. Hoka nehena ihiyeha: — Xekohaseti enokoatare koamaniya nawenatyaka atyo mostardase akereta. Hiyaiya, hatyo atyo kiranexe haiyanai hanakatise nonitata. Hoka hatya haliti atyo hatyo hanakatise fehena ");
INSERT INTO pabNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","hoka kekoarehena atyo hoka haiyanai xahehare kate atyo tyaonita. Hatyo hiyeta atyakate atyo tyaonita hoka kotehalasenai waiyehenene hoka haiheha tyomitaha ekanohinai koni — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Hatyaoseta Jesus aimenekohitiya enomanaha hátahi. Hoka nehena: — Xekohaseti enokoatare koamaniya nawenatyaka atyo hatya ohiro iya kaorehetyakalati hoka trigohe kakoa kaketatitere akereta. Hoka hatyaoseta wahasehena hoka tamomotere akereta atyo — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus iraihena halitinai kakoa hoka haxaimenekola kakoa taita iraeta ihiyeha. Maisa xoare nexa iraexe ihiyeha hamaxaimenekolahareneta. ");
INSERT INTO pabNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iraiti xakaisasehare xairala akereta kawenatyakeheta maheta nikare Jesus iraeta. Exakere iraiti xakaisasehare xairala: Niraehenaite hoka noxaimenikoli kakoa taitaite nirae ekakoaha. Masemakahare tyaoniterehare hetati waikohe kaomakehenere xowakiyere tahi akitite noxakai ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hatyaoseta Jesus xaneheta halitinai nonita hoka xane isoa hatyako hoka exaotyakiraharenai xane ehaliya hoka axehenahene: — Hawaiyekehalakatya womana manakairatyakahare tahi akiti — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hoka Jesus nexa: — Haliti Ityani xaokaka atyo, “Hanakatise waiyexe xafityasehare”, nomita. ");
INSERT INTO pabNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tyotya halitinai xaokaka atyo, “Masenekoa”, nomita. Enore maniya tyaoniterenai xaokaka atyo, “Waiyexe hanakatise”, nomita. Ahalakoahaliti maniya tyaoniterenai xaokaka atyo, “Manakairatyakahare”, nomita. ");
INSERT INTO pabNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tihanare xaokaka atyo, “Enahalakoahare”, “Manakairatyakahare xafityasehare”, nomita. Miyanitiye ferakene xaokaka atyo, “Ixirikotyakaosehena”, nomita. Anjonai xaokaka atyo, “Hatenitiyenai”, nomita. ");
INSERT INTO pabNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hatyo manakairatyakahare kamalakaka hoka kaxawatyakehenere irikati koni akereta tehitiya atyoite miyanitiye xowakehena hoka ");
INSERT INTO pabNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Haliti Ityanite axikatya anjonai ahohisakoatya maheta iniyalahare nomaseharenai exahe iniyalahare axomokanekihenerenai ");
INSERT INTO pabNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","hoka xawatyahene ite irikati kalorexe kiritere koni. Hatyo nalite tiyahenaha masakare exahe, “karai, karai”, nexaite mohenaha haikolinaiha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hatyaosetaite Enore maniya tyaoniterenaite waiye tyaonaha hanexeha Enore nawenakala. Nalite weroka tyaonaha kamae akereta — nexa. — Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","— Xekohaseti koamaniya nawenatyaka atyo xoalini hare kaloxaimanexe metahare tyaonitere hakoa waikohekoa akereta hoka hatya haliti kaokehenene hoka ateroakihitiyerene akereta. Hoka ihalahare hoka xane betetya tyotya haxiyeharenai hoka haikoaheta hoka hatyo waikohe iyitere akereta atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","— Xekohaseti koamaniya nawenatyaka tehitiya atyo hatya haliti pérolanai niyasehare akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hoka kaoka hatya pérola kaloxaimanexe hoka tyotya betetya haxiyeharenae, haikoaheta hoka hatyo sehalise pérola iyitere akereta atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","— Xekohaseti koamaniya nawenatyaka atyo maka kaxawatyakitere one xaiya hoka hiyitere kahare kohase hawareharexe xakini akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kahare kohase isoa enako hoka mairatyatiyenai noloka ahikoatyahene kaiholokoa hoka tyokaha hoka imexakonisahene maheta. Waiyexe kohasenai haitinihareha ako mokahita hoka ewaxirahare kohasenai atyo xawatyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Miyanitiye xowaka tehitiyaite nikareta tyaona. Anjonaite xane haware moka mawaiyexehareharenai waiyexeharexenai nonitata. ");
INSERT INTO pabNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hoka xawatyahaite mawaiyexehareharenai irikati kalorexe kiritere koni. Hatyo nalite tiyahenaha hoka haikolinaiha, “karai, karai”, nexa mokaha — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Hatyaoseta Jesus axa haxaotyakiraharenai: — Xoana, tyotya exe noxakaitere xihiye akiti waiyekehalaka xomana? nexa ihiyeha. — Há, waiyekehalaka womana — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hoka Jesus nexa: — Hatya haliti kaxaotyakisakitere Enore nawenanaho kakoa atyo kaisaniye hotyali akereta hoka xoalini hare hatyakaira hiyeta waitare exahe toahiyere, waiyexe makere iyihititere hoka ijitere haiyanityo haisaninai ana akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hatyaoseta Jesus halakisa hairaene metaharexe hoka hikoaheta hatyo nalita ");
INSERT INTO pabNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hoka xaneheta hawenakala xeta. Hoka hatyo nali aotyakijita xahohisakoatyakalati hanako hoka iniraene semehenerenai hakaharetyoaha hoka axakakoahenaha: — Aliyotala enawaiyore tyoita enomana? Exahe iyateliti hoka maomakahare waiyexe tyomita? ");
INSERT INTO pabNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Xoana maisa hoka etake hati nomasehare ityani xini? xoana maisa hoka Maria ityani xini? Xoana maisa hoka Tiago, José, Simão, Judas xoaha naxenane xini? ");
INSERT INTO pabNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Xoana maisa hoka iximalonenai xini ali tyaonita? Hoka aliyotala exehare iniyatere tyaonita enomana? nexaha, ");
INSERT INTO pabNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","maisa awaiyetyareha Jesus hoka. Hoka Jesus nehena: — Iraeti xakaisasehare atyo kaxaiminisakita hakakoare. Xakore atyo hoka ewaikohera, enawenakala, ehana nali atyo maisa kaxaiminisakere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Maisa tyakekoreha hoka hatyo hiyeta Jesus maisa kahare tyomita maomakahare waiyexe hatyo nali. ");
INSERT INTO pabNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hatyo xowakiya Herodes Galiléia koa xekohaseti tyaonita hoka sema Jesus tahi. ");
INSERT INTO pabNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Semene hoka nexa hawakaneharenai hiye: — Kala maisa hoka João Batista kaseheta. Hiyeta hoka kahare maomakahare waiyexe tyomita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Koxaka Herodes niraene xema João otokaha hoka olatyahene hoka berexotyakalati ako mokahene Herodias xemere. Hatyo nahitita Herodes tyaonita ene hatyo ohiro kakoa, iximarene Filipe exanityo xakore hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","João Batista koxaka hatyo nahitita nexa Herodes hiye: — Xaotyakiyaho atyo mahokoanetita hiximarene exanityo kakoa hawenane. ");
INSERT INTO pabNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes aisene aokowi, xakore hoka mairita judeunai João iraiti xakaisasehare aokahitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hatyaoseta Herodes nawenanaose ferakene xane hikoa hoka hisehaliti tyomaha kalore hoka Herodias ityani xoimahaloti holikoahena tyotyaha enahalakoa hoka awaiyetya exoholikoane Herodes ");
INSERT INTO pabNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hoka nexa xoimahaloti hiye: — Xoarenai xamaniya nisa homana haoka hoka haxa natyo hoka niseniya homana, alitere naokita. Maisa namaoseraita xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hanityo xaotyakira ximita nehena: — Xama hisa nomani kalikinita João Batista seri balatoahekoa — nexa xoimahaloti Herodes hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes semene hoka amaikohare. Xakore hoka hatyo iraihenere tyotya hakaixakalaharenai haotita hiyetaiya atyo maisa aliyakere maxekaneta xoimahaloti ana. ");
INSERT INTO pabNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hoka hatyaoseta axikatya sorarenai irikotyaha maheta João Batista seri berexo akota. ");
INSERT INTO pabNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kolatyaha eseri balatoahekoa hoka isahene xoimahaloti ana hoka kolatene hanityo ana. ");
INSERT INTO pabNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hatyo najikinita João xaotyakiraharenai semene hoka tyoaha kolahenahitaha ehare hoka fityahene. Fityahene hoka xane xakaihahene Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hatyaoseta Jesus sema João kamane tahi hoka kanowako xaneheta hatyo nalita. Hoka hawawaharenai xane maharexakiti xeta. Hoka halitinai ana waiyekehalakita xanehenere akiti hoka xaneha exema tonareha hawenakalataha. ");
INSERT INTO pabNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hatyaoseta Jesus exoahena kanowa akota hoka waiya kahare halitinai hoka airakoaneharetyahene, aiyatelikiheta tyotya hokakiterenai. ");
INSERT INTO pabNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hatyaoseta makehena hoka exaotyakiraharenai tyoa iraeha Jesus kakoa hoka nexaha ihiye: — Hiyaiyehena, makehena wihiye. Ali maharexakiti maisa xoare hare aka. Haxikahetehena exe halitinai hoka xanehetaha hoka xaneha wenakalatinai hoka iyaha nakairati hoka kanakairaha — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hoka Jesus nexa: — Maisaiya xoare maheta exe halitinai xanehitita. Xisota xisehena nakairati enomanaha — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","— Winali atyo 5-tohase nakairati, hinama kohase xoaha taita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","— Xamehenene ali — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Isahene enomana hoka hatyaoseta irai halitinai kakoa tyokaha maheta ime koa. Hatyo najikinita iya 5-tohase nakairati, hinama kohase xoaha hoka wahakotya enoxeta hoka iraexatya Enore hiye. Hoka taikasetya nakairati hoka isene haxaotyakiraharenai ana hoka exaotyakiraharenai irakene halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hatyaoseta tyotyaha kanakairaha hoka fakatehareha. Hatyaoseta exaotyakiraharenai imexakoaheta emawaneha hoka 12-te koho kaise makere mokaha nakairati mawane kakoare. ");
INSERT INTO pabNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hatyo kanakairehenerenai atyo 5.000-hare ena taita. Ohironai, xoimanai tehitiya kahare kanakairaha, hoka maisa atyo ohironai, xoimanai harenai kaxihatyakita. ");
INSERT INTO pabNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hatyo najikinita Jesus haxaotyakiraharenai kakoa irai hoka kakohahenahitaha kanowako hoka xanehenahitaha enaheta maheta halakoiya. Hoka hatyo nase Jesus jinaheta halitinai. ");
INSERT INTO pabNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jinaheta halitinai najikinita Jesus xane kakoha tyairi henose hawawaharenai iraexatya maheta. Makehena ihiyeha hoka hatyo nali hawawaharenai tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hatyo xowaka kanowa koxaka nekesexehetehena xanehitita exaotyakiraharenae kakoare. One takoiyaxala mokotyoita kinatyaxa kanowa hiye hoka hoholati hoholasekoatyahitene, xanehenahititere maniyata hoholatita hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hatyaoseta okoi ferakoahena hoka Jesus xane hikoaheta enomanaha, tonita one heno. ");
INSERT INTO pabNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hatyaoseta exaotyakiraharenai waiyaha Jesus netonane one heno hoka mairaha hoka nehenaha: — Kala maisa hoka isekohaliti! nexaha hoka hamairaneha kawiyatyaha. ");
INSERT INTO pabNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hoka Jesus nexa: — Awa atyo ximaira, natyo ta. Awa atyo ximaira natyo — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hoka Pedro nehena: — Xekohaseti, hisota atyo hoka hakawisa natyo hoka natona one heno hatyo hisaonitere kijiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","— Ahá, hisohena — nexa Jesus. Nexa ihiye hoka Pedro exoa kanowa akota hoka tohena one heno Jesus maniya. ");
INSERT INTO pabNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hatyaoseta hoholati hoholala kehexa. Mairehena hoka isoahena onexa. Hoka kawiyatya Jesus ana: — Xekohaseti, hotohetehena natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Haxerore Jesus aimatya hakahe enomana, otoheta Pedro hoka nehena: — Xoana hoka inira hityakekota! Xoanere hoka maisa hityakekore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hatyaoseta hatyo hinamanai kakohaheta kanowa ako hoka haxerore hoholati memakeheta. ");
INSERT INTO pabNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Exaotyakiraharenai meholokoa awaiyetyaha Jesus hoka nexaha: — Aliterexe kore Enore Ityani hiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hatyaoseta imahotyoaha hoka xane kaokaha Genesaré koa nali. ");
INSERT INTO pabNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hatyo nali halitinai ana Jesus waiyekehalakahare hoka xane kaexakatyaha tyotya hatyokoa tyaoniterenai. Semaha Jesus kaokene hoka kahare kolatyaha hokakitinai enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hoka axahitene, kasani inima kilihi hiye hekoti ekaokakisaha hakaheha aokowiyahitaha. Hoka tyotya hakaheha ekaokakihenerenai inima kilihi hiye kinaterehitita. ");
INSERT INTO pabNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hatyaoseta haiyaharenai fariseunai, haiyanai judeunai xaotyakiraho kakoa waiyoreterenai xoaha tyoaha Jerusalém nalita, Jesus kakoa iraeha maheta, hoka axehenahene: ");
INSERT INTO pabNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","— Xoana hoka maisa hiyaotyakiraharenae tyaonareha wahetakomaniyereharenai xaotyakira xema? Hiyaiya, maisa tihahisoareha hanakairaha nahitita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus nehena ihiyeha: — Hoka xoana atyo hoka xiso maisa xisaonare Enore xaotyakira xema hoka xahetakomaniyereharenai xaotyakiraho xema taita xisaonita? ");
INSERT INTO pabNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Hiyaiya Enore atyo nexa: Waiyira xaiminihena xexe, xityo hoka. Nexa tehitiya: Xala xamaniya atyo hanexe, hanityo iraeharetya hoka waiye xaisaka, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","— Hoka xiso atyo exakerexe xaotyakijita: hatyaiya kaoloxere kahinaetya maheta ene hanexe, hanityo xakore hoka nexaiya ihiyeha, “Enore ana nisene”, nexaiya hoka maisa kahinaetita hanexe exahe hanityo hoka xomana atyo hatyohare ehekoreta. ");
INSERT INTO pabNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nikare maisaiya hanexe exahe hanityo waiye aiminijita hoka xomana atyo hatyohare ehekoreta. Hatyo hiyeta nikare atyo xaotyakijita hoka xahalakijita atyo Enore xaotyakira hoka xisaonita atyo xiyaotyakisakaho xema taita. ");
INSERT INTO pabNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","— Xiso atyo teraharetyoarenai! Isaías nika aliterexe exakere xairatya xitahi: ");
INSERT INTO pabNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Exe halitinai waiye iraetaha notahi, nexa Enore, xakore hoka exahekolaha atyo seko tyaonita noniti. ");
INSERT INTO pabNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maisa atyo awaiyetyahitaha natyo kaisere xini. Hiyaiya, halitinai xaotyakira kakoa atyo aotyakisahitaha hoka Enore xaotyakiraho aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hatyaoseta Jesus ahohisakoatya halitinai hoka nehena ihiyeha: — Waiye xasema hoka waiyekehalaka xomana: ");
INSERT INTO pabNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Maisa atyo hatya kanasako ijoitere xini aiyalaharetita enawenane. Hoka ekanasakota hikoahititerehare atyo aiyalaharetita enawenane — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hatyaoseta exaotyakiraharenai xane kaokaha ehaliya hoka nehenaha: — Hasemehena, hiraetere maisa waiyeta fariseunai hiye. Xoana hatyo akiti hasemita? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hoka Jesus nexa ihiyeha: — Tyotya hananehaliti Baba enokoa tyaonitere maxaferaharene atyoite kamalakakeheta. ");
INSERT INTO pabNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Awa atyo ximawaiyehare ekakoaha. Hatyonai atyo maxoseharenai hoka maxoseharenai xotokahisase tyaoniterenai akereta. Maxosehare atyoite hatya maxosehare otokahijita hoka hatyo hinamanaite xane tolokoako exoaha — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hatyaoseta Pedro axene: — Hawaiyekehalakatya womana hatyo metaharexe hiyakaitere tahi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","— Xoana, haiyanai akerexeta xiso, maisa waiyekehalakere hekoti xomana? nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","— Hiyaiya, xoare xamani atyo hatya kanasako ijoita hoka enajako atyo xaneta. Hatyaoseta atyo hikoahitita ehare hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hoka xoare xamani atyo ekanasakota, exahekola emahiyase hiyeta hikoita hoka hatyohare atyo aiyalaharetita enawenane. ");
INSERT INTO pabNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Hiyaiya, mahiyaseti hiyeta atyo iniyalahare xahekotyati tyoita, xaisati, ohiro watyalisaka, xoalini hare iniyalahare. Hiyaiya, hatyo iniyalahare xahekotyati hiyeta tehitiya haiya xowaka haliti kaiwita, maoseraita, iraeharetita. ");
INSERT INTO pabNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hatyoharenai atyo aiyalaharetita enawenane. Hoka himatihahisoaneharetaiya atyo hikanakaira hoka hatyohare atyo maisa aiyalaharetyare hawenane — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hatyaoseta Jesus xaneheta hatyo nalita, xane Tiro, Sidom xoaha nali. ");
INSERT INTO pabNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Xane kaoka hatyo nali hoka hatya ohiro Canaã yolo hikoa enomana hoka kawiyatya enomana: — Hairakoanehalohena natyo, Xekohaseti Davi jikolahare! Nityani xoimahaloti tihanare kamilakoretita hoka maisa waiye tyaonare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nexa hoka Jesus mema tyaona. Hatyaoseta exaotyakiraharenai xane kaokaha ehaliya hoka nehenaha: — Haxikahetehena exe ohiro. Hiyaiya, tyoita wiyema hoka kirasaka kawiyatya minita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hatyaoseta Jesus nexa: — Nokaxaxikatyaki atyo Israel hotyalinai ana taita. Hatyonai atyo kalaneronai hehaniterenai akereta tyaonahitaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nexa hoka ohiro tyoa meholokoa ikiji haliya hoka nehena: — Hakahinaehena natyo, Xekohaseti! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","— Maisa atyo ehekoreta xini xoimanai nonitata kaiyakeheta nakairati hoka kaxawatyakita kajolonai ana — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hoka ohiro nexa: — Alitere haokita, Xekohaseti. Xakore atyo hoka kajolonai tehitiya atyo kanakairita nakairati holoxo exoahena exekohasenaiha mexane katyahe hoka — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","— Ohiro, kalore atyo hityakekota! nexa Jesus. — Haokitere akeretaite kaomaka — nexa. Nexa taita ihiye hoka hatyo ohiro ityani exowakita kinatoloheta. ");
INSERT INTO pabNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hatyaoseta Jesus hatyo nalita haikoaheta hoka xane Galiléia xa haliya. Hatyaoseta xane kakoha tyairi henose, hoka tyoka. ");
INSERT INTO pabNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hatyaoseta hatyo Jesus tyaonitere nali kahare halitinai xaneta hoka kolatyahitaha mawaiye netonaneharenai, maxoseharenai, mairaeneharenai, mawaiyehalitinai exahe haiyanai hokakiterenai xoaha hoka mokahitene ikiji haliya hoka tyotya aiyatelikihenahititene. ");
INSERT INTO pabNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Halitinai hakaharetyoaha, waiyaha mairaeneharenai niraeneheta, mawaiyehalitinai niyatereheta, mawaiye netonaneharenai nawaiye netonaneheta exahe maxoseharenai waiyakareheta hoka. Hoka ihalahareha Israel yerenai nEnorexa kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hatyaoseta Jesus kawisa haxaotyakiraharenai hoka nehena: — Nakanakaharetita exe halitinai. Hanamakihena tyaonahitaha nohaliye hoka ali maisa xoare nakairati aka. Maisa naxikahenahitene matyaisakaharahitaha naokowiye, waiye aliya hoka exoaha hanaka hiyeta ahotyaho — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hoka exaotyakiraharenai axehenahene: — Hoka aliyakereya ali maharexakiti wikaokehena nakairati exe halitinai ana? Hisoakaha atyo — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","— Xoanama tohase nakairati xinali? nexa Jesus axahene. — Sete tohase nakairati, haiyanai kohase xoaha — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hatyaoseta Jesus irae halitinai hiye hoka waikoa tyokaha. ");
INSERT INTO pabNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tyokaha hoka hatyaoseta isaha Jesus ana sete tohase nakairati exahe kohasenai xoaha hoka: — Ehekore nakairati hisa womana, Abá — nexa iraexatya Enore hiye. Hatyaoseta taikasetene hoka isene haxaotyakiraharenai ana, hoka hatyonai irakene halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tyotyaha kanakairaha hoka fakatehareha. Exaotyakiraharenai kaisehenahitaha kohokijinai ako hoka 7-te kaisero emawaneha imexehenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hatyo kanakairehenerenai atyo 4.000-hare enanai taita. Ohironai, xoimanai tehitiya kahare kanakairaha, hoka maisa atyo ohironai, xoimanai harenai kaxihatyakita. ");
INSERT INTO pabNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hatyaoseta Jesus axikaheta halitinai. Hatyo najikinita kakohaheta kanowako hoka xane Magadã koa nali. ");
INSERT INTO pabNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hatyaoseta haiyaharenai fariseunai, saduceunai xoaha xaneha Jesus kakoa iraeha maheta, kasani hasakaharetyahene aokowiyahitaha hoka xoalini hare nomaka aokaha ihiye hoka waiyaha maheta, xoana aliterexe xamani Enore nalita tyoita iniyatere, maisa xamani. ");
INSERT INTO pabNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hoka Jesus nehena: — Makehena atyo xihiye hoka xita: “Waiye akaite wihiye, hiyaiya, enokoa xotyakoa”, xita. ");
INSERT INTO pabNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nikare weta hoka xita: “One ite wihiye, hiyaiya, xotya aka exahe makalikoa xoaha”, xita. Xawahakohena atyo enokoa hoka waiyekehalakita atyo xomana hatyoharenae. Xakore hoka maisa atyo waiyekehalakere xomana kalikini kaotyakitereharenai. ");
INSERT INTO pabNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kalikiniyerenai atyo maisa waiyexe, maisa tyakekohatiyeha! Xoalini hare nomaka atyo aokaha nohiye tyakekoha maheta. Xakore hoka Jonas tyaohenere akere taitaite kaomaka enomanaha tyakekoha maheta — nexa ihiyeha. Hatyaoseta kikisoaheta enonyahita hoka xaneheta. ");
INSERT INTO pabNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Xanehenaha halakoiya maniya hoka exaotyakiraharenai maotyaneha nakairati hakolalaha. ");
INSERT INTO pabNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hoka Jesus nehena: — Xasemehena, xirihalira fariseunai, saduceunai xoaha kaorehityakala kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","— Kala nakairati wimakolarehenere hiyeta nikareta — nexa exaotyakiraharenai hatyo kakoaha iraikakoahenaha. ");
INSERT INTO pabNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus sema iniraikakoaneha hoka nehena: — Xoana hoka xiraikakoita nakairati ximakolarehenere hiyeta? Xoana hoka inira xityakekone tyaonita? ");
INSERT INTO pabNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Xoana maisa waiyekehalakere xomana? Xoana maisa xotyare 5-tohase nakairati nirahenere 5.000-hare halitinai ana? Exowaka, xoanamate kohokiji xekaiseheta? ");
INSERT INTO pabNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Xoana maisa xotyare sete tohase nakairati nirahenere 4.000-hare halitinai ana? Exowaka, xoanamate kohokiji xekaiseheta? ");
INSERT INTO pabNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","—“Maika xirihare fariseunai, saduceunai xoaha kaorehityakala kakoa”, nomi xakore hoka maisa atyo nakairati tahi xini niraeta. Xoana maisa waiyekehalakere xomana? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hoka hatyaoseta exaotyakiraharenai ana iniraene waiyekehalaka. Maisa nakairati kaorehityakala kakoa kaxaikoawiha maheta xini hoka fariseunai, exahe saduceunai xaotyakira kakoa irihareha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hatyaoseta Jesus xane wenakalati Cesaréia de Filipe maniya. Hatyo nali axehena haxaotyakiraharenai: — Xala halitinai aokita natyo Haliti Ityani? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","— Haiyanai atyo João Batista aokahitaha hiso. Haiyanai tehitiya atyo Elias aokahitaha hiso. Nikare haiyanai Jeremias aokahitaha hiso. Haiyanai tehitiya iraiti xakaisasehare aokahitaha hiso — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","— Hoka xiso atyo xala xaokita natyo? nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Pedro nehena ihiye: — Hiso atyo Enore Kalorexe Aohenere. Hiso atyo Enore Ityani — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","— Waiye kaiserehare nikare hiraeta, Simão, João ityani — nexa Jesus. — Maisa haliti xini awaiyekehalakatene homana. Baba enokoa tyaonitere atyo awaiyekehalakatene homana — nexa Jesus Pedro hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","— Hiyeta hoka nomita hihiye: hiso atyo Pedro hoka exe sehali henoite notyoma nohani. (Tyotya ekoa maniya tyaoniterenai xaokaka, “Nohani”, nita). Maisaiya efaharenai kinatere tyaonita exahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nisaite homana enokoa majiholatyakala. Hoka xoare xamani atyoite hamahokoanetya ali waikohekoa hoka enokoa nali atyoite kamahokoanetyaka tehitiya. Hoka xoare xamani atyoite haoka ali waikohekoa hoka kaxaokaka tehitiya atyoite enokoa nali — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hatyaoseta Jesus haxaotyakiraharenai hiye hatyohare maxakaisakene haiyanai hiye aoka. ");
INSERT INTO pabNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hatyaoseta Jesus iraehena mametaharenehare haxaotyakiraharenai hiye: — Jerusalém terota noxani hoka hatyo nalite judeunai nityohalitiranai, saduceunai xekohaseharenai, xaotyakiyaho kakoa waiyoreterenai harenaite iniyalahare axomokakihena natyo kalore. Nokaxaisakite hoka hanamaki ferakene najikinitaite nokaseheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hatyaoseta Pedro nolokene haware hoka nehena ihiye: — Maisaiya nikareta xini. Maisaiya nikare hikaxomokakita, Xekohaseti — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hoka Jesus ehaikoahareheta hoka nexa Pedro hiye: — Hakikisoahetehena nahitita, Ahalakoahaliti! Hiso atyo sehali kajiyakoatyakitere akereta nahotiri hisaonita. Hiyaiya, haliti xahekola akereta atyo hahekoita, maisa atyo Enore ahekoitere akereta xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hatyaoseta Jesus nexa haxaotyakiraharenai hiye: — Xala xamani atyo tyaona nokoamaniye aokowihena hoka maika hatyota maotyanoawi hoka maika kolatya haberekotyaka niyahare atyalihose xaimaholatyaka hoka tyaona noximi. ");
INSERT INTO pabNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hiyaiya, xala xamani atyoite wenati waiyexe tawita hoka meta atyoite enonita. Xakore hoka xala xamani atyoite nohiyiti kaxaisaka hoka kaiyakeheta atyoite hoka wenati waiyexe nali hikoa. ");
INSERT INTO pabNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hoka xoare mahetaiya hatya haliti hakakoare waikohekoa xiyehaliti harenai kakoa tyaona hoka hatyaoseta waini? Maisaiya xoare hare bakatya hoka ekasekihititene. ");
INSERT INTO pabNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hiyaiya, Haliti Ityanite tyoheta Hanexe werokene kakoa, anjo haomanerenai kakoa hoka sema halitinai tahi hoka enómanenaiha akereta mohenahene. ");
INSERT INTO pabNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","— Exeharíra xotyaxematya: ali haiyaharenai tyaonitereharenaite maisa wainahitaha hamawaiyaneneharahita Haliti Ityani tyohetehenere xowaka nahitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hatyaoseta 6-ki ferakene najikinita Jesus noloka Pedro, haximarene kakoarenai Tiago, João xoaha hoka hatyonai kakoa taita xane tyairi wahaharexe heno. ");
INSERT INTO pabNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hoka nali hawareharexe tyaona ehaotyahitaha. Itiho weroka tyaona, motya kamai. Exahe inimanai hoka iyomate tyaona, motya xaokanatyakalati. ");
INSERT INTO pabNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hatyaoseta Moisés, Elias kaotyaka hoka hatyo hanamahare Jesus xaotyakiraharenai waiyaha iniraeneha Jesus kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hatyaoseta Pedro nehena: — Ehekoreta ali wisoa, Xekohaseti. Haokaiya atyo hoka notyoma hanama hatirise exaose. Hatya homanere, hatya Moisés anere, hatya Elias anere xoaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Maisa halakihenere hekoti hairaine Pedro hoka kaiminiti werokali kaotyaka ehaoha hoka hatyo konita semaha iraiti: — Exe atyo Nityani, Noxiyakawali. Kalore aihalahalinikijita natyo. Xasemaxematyaira iniraine — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Exaotyakiraharenai semaha hatyo iraiti hoka kalore mairaha hoka exoaha hatiho kakoa waikoa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hatyaoseta Jesus tyoa totohenahitene hoka nehena: — Xainakoahetehena, awa atyo ximaira — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hatyaoseta waiyahokotyoahenahitehenaha xakore, Jesus takitehena waiyehenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Exoahenahitehenaha tyairi henota hoka Jesus aotyakisahene hoka waiyehenahere maisa xala hare hiye xakaiha aokita Haliti Ityani kasehetehenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hatyaoseta exaotyakiraharenai axene: — Xoanere hoka xaotyakiyaho kakoa waiyoreterenai Elias hotohare ite tyoheta aokahitaha? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hoka nexa: — Aliterexe atyoite Elias hotohare tyoa hoka tyotya xoalini hare memere mohena. ");
INSERT INTO pabNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hoka natyo atyo nomita xihiye: Elias atyo koxaka tyoa. Xakore hoka maisa waiyekehalakita enomanaha hoka iniyalahare mokahene haxahekolaha akereta. Nikareta tehitiyaite Haliti Ityani iniyalahare mokaha — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hatyaoseta exaotyakiraharenai ana waiyekehalaka Jesus niraene. João Batista xaokaka nikare iraeta. ");
INSERT INTO pabNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hatyaoseta xanehenahitaha haliti hisoakere koni xeta hoka hatya haliti tyoa Jesus haliya hoka meholokoa hakaolise kakoa hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","— Xekohaseti, hairakoaneharehena nityani! Wainitata exahe kalore kaweta ihiye. Hatyahareta hoka haiya xowaka ixoita irikatyaose exahe onexaiya hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Notyoa ekakoa hiyaotyakiraharenai ana hoka maisa xoana mokahitene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hoka Jesus nehena: — Haliti matyakekoneharenai, mawaiyexehareharenai! Otene kijiyaite notyaohena xihaliya? Otene kijiyaite naiyasetyoa xikakoa? Xisohena xoimahaliti kakoa ali. ");
INSERT INTO pabNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hatyaoseta Jesus watyali tihanare hoka kikisoaheta hoka xoimahaliti waiyeheta rotita. ");
INSERT INTO pabNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hatyaoseta hawawaha heko axehenaha Jesus exaotyakiraharenai: — Xoanala hoka maisa aliyakere etake tihanare waxanikihitita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","— Komita maisa xityakekore hoka — nexa Jesus. — Aliterexe nomita xihiye: xityakekotaiya, exahe mostardase akerehare inira hekoti xityakekotaiya hoka xexaiya exe tyairi hiye: “Hakikisoahena alita, hiyane exe maniya”, xexaiya ihiye, xityakekota hoka kikisoaiya. Nikareya xisaona hoka iyatelitiya tyaona xomana hoka tyotya xoalinihariya xisoma — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","— Hoka hatyohare isekohaliti atyo iraexatyati, manakairiti xoaha xema taita kaxaxanikisakihitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Exaotyakiraharenai hohisakoa Galiléia nali hoka Jesus nexa: — Haliti Ityanite kaxekakehena halitinai ana ");
INSERT INTO pabNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","hoka aisahenite. Xakore hoka hanamaki najikinitaite hoka kaseheta — nexa. Nexa hoka exaotyakiraharenai amaikohareha kalore. ");
INSERT INTO pabNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hatyaoseta Jesus haxaotyakiraharenai kakoa kaokaha wenakalati Cafarnaum nali. Kaokaha hoka kalorexe noloxa resebityaseharenai tyoa axaha Pedro: — Xoana xiyaotyakisasehare maisa isare olo Iraexatyakalati Hana niyahare? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","— Há, ijita — nexa Pedro ihiyeha. Hatyaoseta Pedro xane isoahetehena hatyako hoka Jesus hotohare irae ekakoa: — Simão, xoanere atyo hiyahekola? Xala ala ijita olo xoalinihare xaimane aliyere xekohaseti ana: ali tyaoniterenai xamani, hakoatarenai kore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","— Hakoatarenae — nexa Pedro. — Ehekore — nexa Jesus. — Nikare atyo ala hoka ali tyaoniterenai maisa xoare maheta olo isahitaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","— Xakore hoka maisaiya atyo wexamaikohalikisahitene. Hatyo hiyeta hiyane haxawahihena rotita mairatise. Maika hanoloka haihikoatya hetatiye kohase hanolohenere hoka ekanasakoite olo hokose hiyaiya hoka hatyoite noxekani, hiyekane hakakoanexe. Hatyaosetaite hiyane hisa noxekani, hiyekane niyahare enomanaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hatyo xowaka exaotyakiraharenae tyoaha Jesus haliya hoka axehenahene: — Xekohaseti enokoa nalitare kalorexe tyaohena hoka xala atyo masakare kalorexe hatyo nali? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nexaha hoka Jesus kawisa hatya xoima hoka enahetaha mokene ");
INSERT INTO pabNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","hoka nehena: — Aliterexe nomita xihiye: maisaiya xehawareharetita xawenane exahe xoima akereta xisaohitita hoka maisaiya hatyo nali xiyaneta. ");
INSERT INTO pabNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hoka xala xamaniya maxahenerehare exe xoima tyaonitere akereta tyaona hoka hatyo atyoite kalorexe tyaona enokoa nali. ");
INSERT INTO pabNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Xala xamani atyoite waiye moka xoima exakerehare hoka natyo atyo waiye mokita. ");
INSERT INTO pabNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","— Hoka exehare xoima mokosenai tyakekotereharenai natyoiya atyo hatya iniyalahare aomanekisa hoka halakihenahitaha hawenaneha nokoamaniye hoka ehekoretaiya atyo kaxawatyaka one kaloxere xaiya sehali kaloliro mehetyakalati kaxolatyaka ihino hiye hoka maisa ahowitikisa xoimanai nawenane maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","— Kaxiyani, halitinai iniyalahare aomanekijita haiyaharenae hoka hatyo hiyeta haiyanai halakisahitaha hawenaneha waiyexe maniyata! Nikare terota atyoite kawenatyakehena. Xakore hoka kirakoane atyoite kaxomokaka nikare axomokaniki akahenere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","— Hiyeta hoka hikahe exahe hikiji harenai iniyalahare aomanekijita hiso hoka hirikotene hoka haxawatene. Ehekoretaiya himakahehare, himakijihare hiyane wenati waiyexe nali. Hoka maisaiya atyo ehekoreta xini hikahe, hikijinai kakoita mainikere hikaxawatyaka irikati mawakenehare nali hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Maika hiyose iniyalahare aomanekijita hiso hoka holokotya hiyene hoka haxawatene. Ehekoretaiya hamaniya xoserore kakoa hiyane wenati waiyexe nali hoka maisaiya atyo ehekoreta xini manene hiyosenai kakoita hikaxawatyaka irikati mawakenehare nali hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","— Xiriharira hoka maisa ximaxaiminirita hatya hekoti exehare xoimairanai. Aliterexe niraehena xihiye, ekahinaetyaseharenaiha anjonai atyo tyaotaha minita Baba enokoa tyaonitere haliya. ");
INSERT INTO pabNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","— Hiyaiya, Haliti Ityani atyo tyoa taweheta, iyeheta maheta mititereharenae — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","— Xoanere atyo xiyahekola? Hatya halitiya 100-ri kakalaneroxere hoka haliya meta hoka xoanaiya tyaohena? Halakisaite 99-ri tyairi heno nisakoatyahitere nalita hoka xane ite taweheta kalanero metehenere. ");
INSERT INTO pabNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aliterexe nomita xihiye, kaokeheteniya hoka ihalahareya ekakoa, hatyo 99-ri mameteneharenai tyaoniterenai xahexe. ");
INSERT INTO pabNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nikareta tehitiya Xexe enokoa tyaonitere. Kasani maisa hatya hekoti exehare xoimanai meta aokare. ");
INSERT INTO pabNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","— Hihinaehareya iniyalahare tyoma hikakoa hoka hiyane hahotikisa iniyalahare enómane enomana. Maika hatyoharenai metahare hisoma, xiso hinamanai taita. Semaiya atyo hiraene hoka hihinaehare atyo waiye maniya hamoheta. ");
INSERT INTO pabNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Maisa semaxemaita hiraine hoka hiyanehitiya hatya exahe hinamahare kakoa enomana hoka hiraehitiya ekakoa ehaotyahita hoka xoalinihare kairaetyakehena hoka semaha. ");
INSERT INTO pabNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hoka maisaiya exahe semita hatyonai niraene hoka maika tyakekohatiyenai hotyali hiye hiyakaini. Hoka maika maisa sema aokowita hatyonai niraene hoka majudeunehare akereta, kalorexe noloxa resebityasehare akereta hamokene. ");
INSERT INTO pabNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","— Aliterexe nomita xihiye: xoare xamaniya atyoite xamahokoanitya ali waikohekoa hoka enokoa nali tehitiyaiya atyoite kamahokoanityaka. Nikare ite xoare xamani xaoka ali waikohekoa hoka enokoa nali tehitiya atyoite kaxaokaka. ");
INSERT INTO pabNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","— Xasemehena: ali waikohekoa atyoite hinama hare xinekonitarenai iraexahenaha hoka axehenaha hatyohare makere hoka hatyohare atyoite Baba enokoa tyaonitere tyoma enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Hiyaiya, aliyako xamaniya atyoite hinamahare, hanamahare hohisakoita nokoamaniye tyaonahitaha hoka natyo tehitiya atyoite enekoniha notyaonita — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hatyaoseta Pedro xane Jesus haliya hoka axehenene: — Xekohaseti, nohinaehareya fera iniyalahare mohena natyo hoka xoanamakiya nomaotyaniheta iniyalahare exomokala natyo? Xoana, 7-kiya hoka ehekore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","— Maisaiya. Maisaiya atyo 7-ki taita himaotyanehitita. Maika kahareki himaotyanehitita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","— Hiyaiya, wenati Xekohaseti enokoatare koa maniya atyo motya hatya kalorexe ewakaneharenai kakotanetere hoka habakatyaka aokitere ihiyeha akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Habakatyaka aokita hoka hetatiye kaoka enomana, hatyo atyo kalore kakotanetene. ");
INSERT INTO pabNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Xakore hoka ewakanehare maisa kaoloxere hoka maisa xoare kakoa bakatita hakotane. Hoka exekohase ebetetyaka aoka wakaharenai akereta, exanityo, ityaninai, tyotya ixiyehare harenai hoka habakatyaka aoka. ");
INSERT INTO pabNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hoka ewakanehare hakaolise kakoa meholokoa haxekohase nahalakoa hoka axene: “Awa atyo hikaholawaka nokakoi, nabakatyaite hiso!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nexa hoka exekohase airakoaneharetene hoka emaiyareheta ekotane hoka halakisene hoka xaneheta. ");
INSERT INTO pabNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","— Hikoaheta enonita hoka ahalakoatya hahinaehare hakitere kakoa hoka hatyo kakotanetene 100-hokose olo hoka otoka hatyo hahinaehare ekoloako hoka xalawasekoatene hoka nehena ihiye: “Hikakotanetere natyo habakahena!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nexa hoka ihinaehare hakaolise kakoa meholokoa enahalakoa hoka axehenene: “Awa atyo hikaholawaka nokakoi, nabakatyaite hiso”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nexa xakore hoka maisa tyakekota iniraene, hoka xane berexoako mokene ebakala hakotane kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hatyaoseta haiyaharenai wakaharenai waiyaha nikare tyaohenere hoka maisa waiyeta ihiyeha hoka xane xakaihahene haxekohaseha hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hatyaoseta exekoseha kawiheta hatyo wakahare hoka nehena: “Kaxiyani, himaisakaisere. Tyotya hikakotanetere natyo atyo nemaiyareheta, hirae nohiye hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Xoana hoka maisa hairakoaneharitita hihinaehare nairakoaneharehenere hiso akereta?” nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Exekohase ehare ihiye hoka axikatene berexoako xeta, iniyalahare mokahene maheta, tyotya hakotane bakahetehenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hatyaoseta Jesus halakihena hairaine hoka nexa: — Nikare ite Baba enokoa tyaonitere moka xiso, maisa ximaotyanehitita kaiserehare xihinaehare iniyalahare mohenere xiso hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus hatyohare tahi irae najikinita, xaneheta Galiléia koa nalita hoka xane Judéia koa maniya Jordãoxa halakoiya. ");
INSERT INTO pabNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kahare haliti xane exema. Hoka hatyo nali kaokaha hoka hokakiterenai aiyatelikiheta. ");
INSERT INTO pabNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hatyaoseta haiyanai fariseunai tyoaha ehaliya hoka hasakaharetyahene maheta axehenahene: — Xoana wiyaotyakisakaho hiyetaiya hatya haliti waiyehena xoalini hare xemere halakiheta haiyanityo? ");
INSERT INTO pabNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Hoka Jesus nehena: — Xoana maisala xakaixaretyare iraeti kaxairatyakehenere nehenere: “Hetati xowaka Enore tyoma ena, ohiro”, nehenere? ");
INSERT INTO pabNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hatyo xowaka nexa Enore: Hiyeta hatya halitite halakisa hanexe, hanityo hoka tyaona haiyanityo kakoa hoka hatyo hinamanaite haterore tyaonaha, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","— Hatyo hiyeta maisa atyo hinamaha xini, xakore hoka hateroreha atyo. Hatyo hiyeta halitiya maisa exaorehitita Enore hahotyalita mohenerehare — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hatyaoseta fariseunai axehitiyene: — Hoka xoana atyo hoka Moisés atyo hatya halitiya halakiheta aokowihena haiyanityo hoka halakisati baberanexa isa enomana hoka axikahetene aoka? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hatyaoseta Jesus nehena: — Maisa xawaiye xahekolere hoka Moisés nikare irae. Xakore hoka maisa atyo hetati kaomakehenere xowakiya nikarexe ene xini. ");
INSERT INTO pabNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hiyeta hoka nomita: hatya halitiya halakiheta haiyanityo, maisa xakore hatya watyaliyene hoka xaneya hatya ohiro kakoa tyaohitiya hoka iniyalahareya atyo tyoma. Hatyaiya xane ehalakirahalo kakoa tyaohitiya hoka iniyalahareya atyo tyoma — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hatyaoseta Jesus xaotyakiraharenai nehenaha: — Nikarexeya hatyo haliti nawenane haiyanityo kakoa hoka ehekoretaiya atyo maisa xoare maheta kakaiyanityotyakita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hoka Jesus nehena: — Exe xaotyakisati atyo maisa tyotya anere xini. Enore nikare tyaona aohenerenai anere taita atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hiyaiya, kahare xoalini hare hiyeta atyo haiyaharenai maiyanityota. Haiyaharenai atyo maiyanityohare terota maheta tyaona. Haiyaharenai atyo kaxaikoharetyakaha hoka maisa aliyakere kaiyanityohitaha. Haiyanai atyo maisa kaiyanityoreha Enore koamaniya hawenaneha hiyeta. Hoka xala xamani atyo exe xaotyakiye xema tyaona aokowita hoka tyaona — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hatyo najikinita haiyaharenai kolatyaha xoimamokosenai Jesus ana, ekaokakisa hakahe ihiyeha hoka iraexatya etahiha maheta. Hoka exaotyakiraharenae mahokoanetya etyoaneneha enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hoka Jesus nehena: — Kotare xoimanai tyoa nomani, awa atyo xamahokoanitya etyoaneneha nomani. Hiyaiya, Xekohaseti enokoatare waikoherakoa atyo exe xoimairanai tyaonitere akereharenai anere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hatyaoseta ekaokakisa hakahe xoimanai hiye hoka iraexatya enomanaha. Hatyo najikinita xaneheta hatyo nalita. ");
INSERT INTO pabNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hatyaoseta haxowaka xoimahaliti kaoka Jesus ana hoka axehenene: — Waiyexe Xaotyakisatiye, xoareya notyoma waiyexe hoka wenati waiyexe matyotenehare nali noxani? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","— Xoanere hoka xekohaseti waiyexe haokita natyo? Waiyexe atyo haterore, Enore takita atyo waiyexe — nexa Jesus. — Wenati waiyexe matyotenehare koamaniya hisaona haokowita hoka Xaotyakiyenai xema hisaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","— Xoarenai hatyo xaotyakiyenai? nexa axene. Hoka Jesus nexa: — Awa atyo haisa, awa atyo iniyalahare hisoma ohiro kakoa, awa atyo hikaiwa, awa atyo hamaoseratya. ");
INSERT INTO pabNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Haiminisa hexe, hityo xoaha, hawaiyehena haiyanai hiso hawaiyetyoawitere akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","— Haokitere akereta noxoiminita notyaonita tyotya hatyo xaotyakiyenai xema — nexa. — Xoareya notyomihitiya? nehitiya hatyo xoimahaliti. ");
INSERT INTO pabNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Hoka Jesus nexa: — Waiyexe maniya kaiserehare hisaoheta haokowita hoka hiyane tyotya hixiyeharenai habetetya hoka hisa olo maoloxaharenai ana. Nikare ite hisaona hoka hikaoloxere hikaxiyeharexe hisaona enokoa nali. Hatyaosetataite hisoheta hoka hisoa noximi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hatyohare xoimahaliti sema hoka amaikohare hoka xaneheta, kahare kaxiyeharexe hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Xaneheta hoka Jesus nehena haxaotyakiraharenai hiye: — Aliterexe nomita xihiye: howitihare atyo kaoloxere nawenane Xekohaseti enokoatare koamaniya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","— Hoka niraehitiyaite: howitihare atyo kaoloxere nawenane Xekohaseti enokoatare koamaniya. Kamelo howitihare kaxajiyakisakitere awiyahi nakoako xahehare howitini atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Exaotyakiraharenai sema hatyohare hoka hakaharetyoaha hoka axahene: — Nikarite hoka xalaite kaiyakehetehena? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hatyaoseta Jesus wahakotya enomanaha hoka nehena: — Halitinai ana atyo hatyohare howitihare. Xakore hoka Enore ana atyo maisa xoare hare howitiharexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","— Hiyaiya, tyotya atyo wahalakiharetyoa hoka wisoa hiyema. Hoka xoanere ite kaxekakehena womana — nexa Pedro axene. ");
INSERT INTO pabNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hoka Jesus nexa: — Aliterexe nomita xihiye: tyotya xoalinihare Enore ewaitarehetehenere hoka Haliti Ityani tyokehenere haokahakala waiyeharexe heno xowakaite, xiso nokoamaniye xisaohenerenai tehitiyaite xisoka 12-okahakalati heno hoka 12-hotyali Israel hotyalinai xekohasenai xisaona. ");
INSERT INTO pabNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hoka tyotya haiyaharenai nohiyiti halakihenere hahana, haximarenenai, haximalonenai, hanexe, hanityo, haisaninai, hawaikohera harenai hoka kahaliki atyoite hatyoharenai kaxekakeheta enomanaha, wenati waiyexe matyotenehare tehitiyaite kaxekaka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hoka kalikini atyo kahare kalorexe tyaoniterenai atyoite wakahare tyaoheta, hoka kahare wakahare tyaoniterenai atyoite kalorexe tyaoheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus nehena: — Enore koamaniya nawenatyaka atyo uva katenai xekohasehare weta xane hoka hatenitiyenai hiye irae hoka hakaha enomana emasenekoa aokitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hawenanaho akereta irae ekakoaha, hahoko olo kakoa haki ferakene bakatyahene aokowi hoka axikatyahene hakaha maheta ehananehare koni. ");
INSERT INTO pabNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Eno kamaihena hoka xanehitiya wenakalati nekesekoa hoka waiya haiyaharenai, maisa xoare tyomareha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hoka nexa ihiyeha: “Xiyane xisonai tehitiya xahaka nomasenikoi. Nabakatyaite xiso enaosexeta”, nexa ihiyeha hoka xaneha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nikare totahikoa, makakoahena hoka nikareta iraihitiya haiyanai hatenitiye hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Komita waikoitehena kamai hoka xanehitiya hoka waiyehitiya haiyaharenai. Hekotata maisa xoare tyomareha hoka nehena ihiyeha: “Xoana hoka waha aka ali xisaonita, maisa xoare hare xisomare?” nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Maisa xala hare iraexe wikakoa hoka maisa wahakare”, nexaha ihiye. Hoka nexa ihiyeha: “Xiso tehitiya xiyane xahaka nohananihare koni”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","— Maka hoka masene waikatehare nexa kaxaikotyatiye hiye: “Hiyane hakiterenai hakawihetehena hoka habakahenahene. Maika miyanitiye kawakatyakehenere hotohare habakatya. Nikare makere, hoka hetati kawakatyakehenere ite miyanitiye habakatya”, nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hatyo makehena hahenerenai ana hahoko xakini olo hoko isa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hatyaoseta motyalaite hetati hahenerenai xahekolaha hiye hoka exahereha kabakatyaka aokahitaha. Xakore hoka nikareta tehitiya hahoko xakini olo hoko isa enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bakatyahene hoka maisa waiyeta ihiyeha hoka ehareha masene waikatehare hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hoka nehenaha: “Exe miyanitiye kaxahakakisakehenerenai atyo inirita hakaha hoka wiso atyo wahaka watere nase, waha aka. Xakore hoka wiso akereta atyo habakatyahene”, nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hatyaoseta exekohaseha nehena hatya hiye: “Hasemehena, nohinaehare, maisa atyo namaoseraita hiso. Xoana maisa niraehenere hikakoa xowaka hahoko olo kakoa haki ferakene nabakatya hiso hoka hahaka nomani naoka hoka haohenere hotyare?” nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Hoka hotohena holoxa hoka hiyanehetehena hihana xeta. Hiyaiya, kasani exe haliti miyanitiye naxikahenere ana nisehenere homana akereta nisa naokowita”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“Xoana maisaiya kore naokitere akereta noloxi kakoa notyomita? Xoana hokoawahareta kore ihiye, waiye namokiterene hiyeta?” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesus halakihena hairaine hoka nexa: — Nikare ite kalikini hetatiye tyaoniterenai miyanitiye tyaoheta hoka kalikini miyanitiye tyaoniterenai atyoite hetatiye tyaoheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hatyaoseta Jesus xanehena Jerusalém xeta hoka haxaotyakiraharenai kakoa irae hawawaha heko tonahitaha hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","— Xasemehena, wiyaneta Jerusalém xeta. Hatyo nalite Haliti Ityani kamatawatyakehena sacerdotenai xekohasenai ana, xaotyakiyaho kakoa waiyoreterenai ana. Hatyonaite exaisaka aokaha hoka ");
INSERT INTO pabNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","majudeuneharenai anaite halakihenahene. Hoka hatyonaite koexahalisene, mokonasetene, berekotyahene ite atyalihose xaimaholatyaka hiye. Xakore hoka hanamaki ferakene najikinitaite kaseheta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hatyaoseta Zebedeu exanityo kaoka haisaninai kakoa Jesus ana, meholokoa enomana axene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","— Xoare haoka? nexa Jesus. Hoka nehena: — Kalorexe hisaohenere xowakaite kasani nityaninai tyokaha hihaliya naokita, hatya hifihini maniya, hatya hiwatone maniya xoaha — nexa axa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nexa hoka Jesus nehena ityaninai hiye: — Maisa atyo xawaiyorexe xaxitereharenai kakoa. Xoana xisonaiya xisera erakakalati akore noterehenere? nexa. (Hakamane xaokaka nikareta Jesus.) — Há, wisereniya — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hoka Jesus nexa: — Aliterexe atyoite xisera nerakakali akorexa. Hoka maisaiya atyo natyonai xala nokane xamani nofihini maniya, nowatoni maniya xoaha naokita. Hatyo okahakalatinai atyo Baba aohenerenai anere taita, hoka hatyo ana isene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hatyaoseta 10-hare exaotyakiraharenai semaha hatyohare tahi hoka ehareha hatyo haximarene kakoarenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hatyaoseta Jesus kawisahene tyotyaha hahaliya hoka nehena: — Xekohasetinai atyo wakatita halitinai, exahe kalorexenai atyo wakatyahitene. Hatyohare atyo waiyekehalakita xomana. ");
INSERT INTO pabNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hoka xisonaiya atyo maisa nikare xisaonita. Xala xamani atyoite xinekonitare kalorexe tyaona aokowita hoka maika hahena hahinaeharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Exahe xala xamani xinekonitare kalorexe tyaona aokowita hoka maika xiwakanehare tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hiyaiya, Haliti Ityani kakoita tyoa maisa kahakaka enomana maheta xini, xakore hoka tyoa haka maheta, exahe waini hoka iyeheta maheta kahare haliti — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hatyaoseta jiyehenahitiyaha wenakalati Jericó nalita hoka kahare haliti xane Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hatyaoseta hinamahare maxoseharenai ahoti kilihi tyokiterenai semaha Jesus jiyane hoka kawiyahena: — Xekohaseti, Davi jikolahare, hairakoaneharehena wiso! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hatyaoseta kahare haliti xaneterenai mahokoanetya ekawiraha, exahe mema tyaonaha aokahitaha. Xakore hoka exahehare kinatyaxa kawiyatyaha: — Xekohaseti, Davi jikolahare, hairakoaneharehena wiso! nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hatyaoseta Jesus tityoa hoka kawisa maxoseharenai hoka axahene: — Xoana namoka xiso xaokita? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","— Kasani hakaxoseheta wiso waokita — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus airakoaneharetya maxoseharenai hoka ekaokakisa hakahe exosenaiha hiye. Hatyaoseta waiyakatyarehenahitehena rotita. Hatyaoseta xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Xane exaolitiki henaha Jerusalém hoka kaokaha wenakalati Betfagé nali, Oliveiras tyairiya haliya. Hatyo nalita, Jesus axikatya hinamahare haxaotyakiraharenai haheta maniya exakerexe iraiti kakoa: ");
INSERT INTO pabNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","— Xiyane exe wenakalati waheta maniya tyaonitere nali. Hoka nalite xiyaiya boriko exolatyakahare haisanirise kakoa. Hoka maika xaolika hatyo hinamanai hoka xisoa ekakoaha ali. ");
INSERT INTO pabNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Maika xala xamani xoare nehena xihiye hoka xexa: “Xekohaseti aokahitene haomana”, xexa. Nikare ite xirae hoka halakisahene rotita xomana. ");
INSERT INTO pabNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nikare tyaona iraiti xakaisasehare xairahenere akereta tyaona maheta: ");
INSERT INTO pabNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Maika xexa Jerusalém yerenai hiye: kalikini atyo xiyekohase kaokehena. Hatyo atyo waiyexehare hoka tyokita boriko ityani heno”, nehenere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hatyaoseta exaotyakiraharenai xaneha enaheta maniya hoka Jesus aokitere akereta tyomaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kaokaha boriko exahe ityanirise xoaha kakoa hoka haimanaeha mokaha ehenoha hoka Jesus tyoka eheno. ");
INSERT INTO pabNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jiyehenahitiyaha hoka kahare halitinai xanetere exema mokahitaha haimanasenaiha waikoa enaheta maniya. Haiyaharenai xane iyaliti irikotyaha hoka mokahitaha ahotyaho. ");
INSERT INTO pabNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hatyaoseta enaheta xaneterenai, enajikinita tyoiterenai xoaha kawiyahenaha: — Wihalahareta, Davi jikolahare kakoa! Xekohaseti Enore, waiyira hamohena hexare kakoa tyoiterehare! Wihalahareta hikakoa, Enore! nexaha ihalaharahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hatyaoseta Jesus kaoka Jerusalém nali hoka tyotya naliyerenai wahakohenaha enomana hoka axakakoahenaha: — Xala hatyo kaokehena womana? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hoka halitinai nexa ekoaxatyaha: — Exe atyo iraiti xakaisasehare Jesus, wenakalati Nazaré nalitare, Galiléia koatare — nexa exemata tyoiterenai ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hatyaoseta Jesus xane isoa Iraexatyakalati Hanako hoka aihikoaheta tyotya hatyoako iyakaiterenai, betetiterenai xoaha. Olo ehaikoakihititere mexanenai herawatya, watyaha betiterenai nokahakalanai harenai exoakikoatya ");
INSERT INTO pabNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","hoka nehena: — Exakere xairatyoare tyaonita Enore niraine babera waiyexe nanekoa: “Nohani atyoite Iraexatyakalati Hana kaxaokaka”, nexa. Xakore hoka xiso atyo kaiwarexenai xalijiniharexe xateroakisakala niyahare xamokene — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hatyaoseta maxoseharenai, maetonaneharenai xaneha Jesus ana Iraexatyakalati Hanako hoka tyotyaha aiyatelikihenahitene. ");
INSERT INTO pabNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Xakore hoka sacerdotenai xekohasenai, iraiti kakoa waiyoreterenai harenai ehareha ihiye, hokakiterenai aiyatelikihititere hiyeta, exahe Iraexatyakalati Hanako xoimanai kawiyakotitere harenai semaha: — Davi jikolahare kakoa wihalahareta! nexahitere harenai hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ehareha hoka nehenaha Jesus hiye: — Xoana, hasemita iniraineha? — Há, nasemitene. Xoana, maisa xiyaiyare Iraiti Waiyexe nanekoa exakerexe kaxairatyakehenere: “Enore aotyakisa xoima kiranexe, xoima aokokitaterenai harenai waiyexe taita iraeha maheta”, nehenere? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hatyaoseta Jesus halakisahene hoka hatyo wenakalatita xaneheta hoka xane wenakalati Betânia nali hoka nali nemaka. ");
INSERT INTO pabNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kamaetali haikoahitita Jerusalém xeta hoka naka. ");
INSERT INTO pabNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hoka waiya halohalo kate, ahoti kilihita tyaonita hoka xane waiyakatetene iri xahita. Xakore hoka maisa kaliye, ehana taita. Hoka nehena halohalo kate hiye: — Maisaiya exehekota hikalihitita — nexa ihiye. Nexa hoka halohalo kate nirihena rotita. ");
INSERT INTO pabNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Exaotyakiraharenai waiya hatyohare hoka hakaharetyoaha hoka nexaha: — Xoana haxerore níra — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hoka Jesus nehena: — Aliterexe nomita xihiye: xityakekotaiya hoka maisa ximatyakekoneta hoka exe namokitere halohalo kate akeretaiya xisoma. Maisaiya exakere taita xini. Exaheya xexa exe tyairi hiye: “Hakikisoahena hatyaoseta hoka hiyane hexoahena onexa”, xexaiya ihiye hoka nikareya tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Xityakekotaiya hoka xiraexahena hoka xoalini hare xaxehena hoka xaokitere akeretaiya atyo tyaona xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hatyaoseta Jesus haikoaheta Iraexatyakalati Hana xeta. Hatyaoseta aotyakijita halitinai hoka sacerdotenai xekohasenai, judeunai nityohalitiranai xoaha tyoa kaokaha ehaliyita hoka axehenahene: — Xala niraine kakoare hiso hoka nikare hisaonita? Xala xaokala xema nikare hisaonita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hoka Jesus nehena: — Natyo tehitiyaite naxa xiso. Xekoaxatyaite nomani hoka noxakaite xihiye noxaxikatyasehare tahi. ");
INSERT INTO pabNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xala niraene xema João batixatya haliti? Xoana Enore niraene xema, halitinai niraene xema kore? nexa ihiyeha. Nexa hoka iraikakoahenaha: —“Enore niraene xema”, wexaiya hoka nexaiya axa wiso: “Enore niraene xema hoka xoana hoka maisa xityakekota João?” nexaiya wihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Halitinai niraene xema”, wexaiya hoka maisaiya waiyeta halitinai hiye hoka xoana xamaniya mokaha wiso. João atyo iraiti xakaisasehare aokahitaha — nexa iraikakoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hatyo hiyeta nexaha Jesus hiye: — Maisa wawaiyorexe João akiti kakoa — nexaha. Nexaha ihiye hoka Jesus nehena: — Natyo tehitiyaite maisa noxakaita xala niraene xema exeharenai notyomita — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus nihitiya: — Xasemehena, xoanere atyo xiyahekola? Hatya haliti hinamahare kaisaniye. Hoka nexa haisani hetatiyehare hiye: “Hiyane hahaka wimasenekoa, haré”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nexa xakore hoka “Maisa noxani nahaka naokowiye, abá”, nexa hanexe hiye. Nexa ihiye hoka enajikini maniya kehexaharetyoaheta hoka xane haka hanexe aokitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Enexeha nikareta tehitiya iraihitiya haisani xoimere kakoa hoka, “Há, noxanite nahaka, abá”, nexa hanexe hiye xakore hoka maisa xaneta. ");
INSERT INTO pabNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","— Xala hare hanexe aokitere akereta tyaona? nexa Jesus axahene. — Ityani hetatiyehare — nexaha. Hoka Jesus nehena: — Kalorexe noloxa resebityaseharenai, enatyalolonai xoaha atyo iniyalahare tyomahitaha, xakore hoka hatyonai hotohare atyo tyaonahitaha Enore koamaniya xahitita. ");
INSERT INTO pabNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hiyaiya, João Batista atyo tyoa hotikisa maheta xomana aliterexe ahotyaho, xakore hoka maisa xityakekotene. Hoka olo resebityaseharenai, enatyalolonai xoaha atyo tyakekone. Hoka xiso atyo hatyoharenai xiyaiya xakore hoka maisa xahalakijita iniyalahare xománe xityakekotene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus nexa: — Xasemehena exe xaimenekotyati: hatya haliti fitya uva katenai hamasenekoa hoka talahokotya hamasenekoa. Tyoma uva kakatyakala vinhoxa tyoma maheta, enoakiya kahainatya hakakoare waiyakoatya hamasene maheta. Hatyaoseta haiyanai halitinai ana halakisene, kaxaikoahene hoka xonehena hoka irakakakoahenahitene maheta. Hatyaoseta xane hakiti seko akiya. ");
INSERT INTO pabNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hatyaoseta inimexaka xowakehena hoka masene xekohasehare axikatya hawakaneharenai masene kaxaikotyaseharenae ana holini iseheta enomana maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Xane kaokaha hoka masene kaxaikotyaseharenai otokaha ewakaneharenai hoka hatya mokotyaha, hatya aisaha, hatya sehali kakoa mokohenaha xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hatyo najikinita exekohase axikahitiya hawakaneharenai hetati axikahenere xahe. Xakore hoka masene kaxaikotyaseharenai nikareta mohenahitiyene. ");
INSERT INTO pabNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hatyo najikinita axikatya haisani kaiserehare, ahekotya hoka: “Nityani atyoite naxikatya hoka aiminisahene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Xakore hoka masene kaxaikotyaseharenai waiyaha ityani hoka nexaha: “Exe atyo masene xekohasehare ityani. Nika waisene hoka masene ite womanere tyaona!” nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hatyaoseta otokaha ityani hoka sekose xaneha ekakoa masene nonitata hoka aisahene. ");
INSERT INTO pabNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hatyaoseta Jesus axehenahene: — Hoka hatyo masene xekohasehare ite kaokehetehena hoka xoanaite mohena hatyo masene kaxaikotyaseharenai? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hoka nexaha: — Aisaite hatyo masene kaxaikotyaseharenai xalijiniharexenai hoka hahotyalinai anisaite halakihitiyene. Hoka hatyonai atyoite iseheta enomana holini, inimexaka ferakenehena hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hoka Jesus nehena: — Xoana koxaka xakaixaretya Iraeti waiyexe nanekoa exakere nehenere: “Sehali hati nomaseharenai maxaokarehenere atyo hati tononako kaxomokaka. Xekohaseti xekane atyo. Hoka hatyo atyo waiye kaiserehare”, nehenere? ");
INSERT INTO pabNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hoka Jesus nihitiya: — Hatyo hiyeta nomita xihiye: Enore waikoherakoa atyo xomanere xakore atyo hoka kaxemaisatyaka xonita hoka kahalakisaka atyoite hahotyaliharenai Enore aokitere akereta tyaoniterenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","— Xala xamani atyoite exoa hatyo sehali heno hoka taikoehekoa atyoite. Hoka hatyo sehaliya atyo hatya heno exoa hoka miyoheteniya atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdotenai xekohasenai, fariseunai xoaha semaha hatyo Jesus xakaini metaharexe hoka otyahene, exaokakaha terota atyo nikare iraeta. ");
INSERT INTO pabNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hatyo hiyeta otokahene aokowiha, xakore hoka mairahitaha halitinai, halitinai Jesus iraiti xakaisasehare aokahitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Hatyaoseta Jesus haxaimenekola kakoa xakaihitiya ihiyeha hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","— Xekohaseti enokoa tyaonitere koamaniya nawenatyaka atyo hatya xekohaseti ityani kaiyanityohena hoka tyoma hisehaliti haisani nawenakakoane niyahare akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hoka axikatya hawakaneharenai kaixakatyaha maheta kaexakahenerenai. Xakore hoka maisa tyoa aokowiyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hatyaoseta axikahitiya haiyaharenai hawakaneharenai hoka nexa ihiyeha: “Maika xiyakai xikaexakalaharenai hiye. Koxaka tyotya memere hisehaliti. ‘Koxaka naisa bowi mokosenai, bowi koloterenai hoka koxaka tyotya memere. Kasani tyoaha hisehaliti ana naokita!’ ” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","— Xakore hoka ekaixakalaharenai maisa hatyoharenaeta aokahitaha hoka xane tyomaha aokowiterehare ana xaneha. Hatya xane hamasenekoa nali, hatya xanehena haxiyehare nitini xomokakala nali xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Haiyaharenai otokaha ewakaneharenai hoka mokohekoatyahene hoka aisahene. ");
INSERT INTO pabNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hatyo hiyeta xekohaseti ehare hoka axikatya hasorarexanai aisaha maheta hatyo katawanakahenerenai, exahe enawenakalaha hoka kerahaotya maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hatyo najikinita kawisa hawakaneharenai hoka nexa: “Wenakakoati niyahare hisehaliti notyomehenere mema, xakore hoka wikaexakalaharenai atyo maisa tyoahitaha, maisa waiyexeha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hoka xiyanehena kalikini ahotyahonai hoka xakaexakatya tyotya xahalakoahenerenai”. ");
INSERT INTO pabNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","— Hatyaoseta ewakaneharenai xaneha ahotyaho hoka ahohisakoatyaha tyotya ahalakoahenerenai, waiyexeharexenai, mawaiyexeharexenai xoaha. Hoka hisehaliti tyaohenere ako kaise haliti moka. ");
INSERT INTO pabNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hatyaoseta xekohaseti isoa waiya maheta kakaexakatyakehenerenai hoka waiya hatya haliti maisa hisehaliti anere imiti ako xini ijoita. ");
INSERT INTO pabNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hoka axene: “Nohinaehare, aliyakere ali hisoa, maisa xakore hisehaliti anere imiti akore xini hiso hoka?” nexa. Nexa hoka maisa xoare nita. ");
INSERT INTO pabNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hatyaoseta xekohaseti nexa hawakaneharenai hiye: “Xolatya exe haliti kijinai, exahe ewaotyalinai xoaha hiye hoka xaxawahetene menanaka makaliroti koni. Hatyo nalite tiya, exahe karai, karai, nexaite haikolinai moka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesus halakihena hairaine hoka nehena: — Hiyaiya, kahare atyo kakaexakatyakita, xakore hoka haiyanai taita atyo kaxaokakita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hatyaoseta fariseunai hikoahenahitaha hoka ahekotyaha hasakaharetyaha Jesus maheta, kasani ehaikoare irae hoka iniraine kakoita iraeharetyahene aokowita. ");
INSERT INTO pabNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hatyaoseta axikatyaha haxaotyakiraharenai, Herodes koamaniya tyaoniterenai xoaha nexaha Jesus hiye maheta: — Xekohaseti, hawaiyexeharene atyo waiyekehalakita womana, aliterexe atyo haotyakijita Enore aokitere akereta. Maisa atyo haiyanai xahekola hityakekore, hakakoa atyo halitinai hiyaiyita. ");
INSERT INTO pabNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hoka xoanere atyo hiyahekola: xoana wiyaotyakisakaho hiyetaiya hoka wisehenaite olo kalorexe Roma yere ana, maisaiya kore? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nexaha hoka Jesus otya inirawaneneha hoka nehena: — Teraharetyoarenae, xoana hoka xahasakaharetya xaokowita natyo? ");
INSERT INTO pabNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xamehena olo hokose xijitere hoka nowaiya! nexa. Nexa hoka isaha olo hokose enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Hoka Jesus axehenahene: — Xala nexare exahe niyakotini tiho exe olo hokose hiye? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hoka nexaha: — Kalorexe Roma yere — nexaha. — Xoare xamani atyo kalorexe Roma yere anere hoka kalorexe ana xisene. Hoka Enore anere hoka Enore ana xisene — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Semaha nikare iniraine hoka hakaharetyoaha. Hoka halakisaha Jesus hoka xanehenahitaha enonita. ");
INSERT INTO pabNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hatyo ferakeneta haiyaharenai saduceunai tyoaha Jesus ana. Enomanaha haliti wainihena hoka maisa kasehetere. Tyoaha Jesus haliya hoka nexaha: ");
INSERT INTO pabNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","— Xekohaseti, Moisés atyo exakerexe aotyakisa: “Hatya haliti wainihena hoka haiyanityo maisanihalota halakisa hoka iximarene atyoite tyaohena hatyo wainiyanenehenolo kakoa hoka kaisanihenaha hoka enaxenane wainihenere ityani atyoite kaxaokaka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","— Hasemehena, winekoni ene 7-hare haximarene kakoarenai tyaonita hoka enaxenaneha kaiyanityo hoka waini maisanihareta. Hoka iximarene ihiyetare tyaohitiya ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Xakore hoka nikareta maisanihareta wainihitiya, exahe ihiyetareha hoka tyaohitiya ekakoa hoka wainihitiya. Nikare makere hatyo 7-harenai waini tyotya. ");
INSERT INTO pabNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Waini tyotehenahere najikinita waini ohiro. ");
INSERT INTO pabNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","— Nikarite hoka xala exanityo kaisere ite hatyo ohiro tyaohetehena, kamatinai kasehetehenere xowakiya? Hiyaiya, tyotyaha atyo tyaonaha ekakoa! nexaha Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Hoka Jesus nexa ihiyeha: — Xiso atyo ehaikoare xahekotita. Maisa atyo xawaiyorexe Iraiti Waiyexe xairatyoare tyaonitere kakoa, exahe Enore niyatere kakoa hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","— Hiyaiya, kamatinai atyoite kasehetehena hoka anjonai enokoa nali tyaonitere akereta atyoite tyaonaha, maisaiya atyo tyaonakakoahenahititaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","— Hoka xoana maisa kamatinai kasehetehenere tahi xasemare Enore niraene? Exakere atyo nexa: ");
INSERT INTO pabNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Natyo atyo Abraão, Isaque, Jacó xoaha Nenorexa”, nehenere. Hoka exeharenai atyo hotikijita: Enore atyo kasexenai Nenorexa hoka maisa atyo kamatinai Nenorexa xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hatyoharenai halitinai semaha hoka hakaharetyoaha exaotyakira kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hatyaoseta fariseunai ahohisakoatyakakoaha, semaha saduceunai maxekoaxarene Jesus ana hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Enekoniha hatya xaotyakiyaho kakoa waiyoretere kasani hasakaharetya aokowita Jesus hoka axene: ");
INSERT INTO pabNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","— Xaotyakisatiye, xoare masakare waiyexe tyotya xaotyakiyahonai konitare? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hoka Jesus nehena: — Hawaiyehena kaiserehare hiyekohase Enore, hisaonehena exema maniya takita, hahekohena ekoamaniya takita. ");
INSERT INTO pabNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","— Exe iraiti atyo masakarexe waiyexe tyotya xaotyakiyahonai konitare. ");
INSERT INTO pabNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hatya ihiyetare tehitiya komitaene hetatiye akereta: Hawaiyehena haiyaharenai hawaiyityoawitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","— Tyotya Moisés xaotyakiraho, iraeti xakaisaseharenai xaotyakira harenai atyo exe hinamanai xaotyakiyenai nali kaxakaisakehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hatyaoseta fariseunai hohisakoahitataha hoka Jesus axehenahene: ");
INSERT INTO pabNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","— Xoare atyo xiso xahekotita Enore Kalorexe Aohenere Cristo tahi akiti? Xala jikolahare xaokitene? nexa. — Cristo atyo Davi jikolahare — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hoka Jesus axehenahitiyene: — Hoka xoanere hoka Davi Isekohaliti Waiyexe kaxaihakohenere xowaka Haxekohase aokene? Hiyaiya, exakere atyo Davi irai: ");
INSERT INTO pabNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nexa Xekohaseti Noxekohase hiye: “Hisokehena nofihini maniya, hahalakoaharenai hikijinai katyahe namohenere kijiya”, nexa. (Enahalakoaharenai mehotyaka xaokaka nikareta iraeta.) ");
INSERT INTO pabNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hatyo hiyeta Davi atyo Haxekohase aokene hoka aliyakereya Enore Kalorexe Aohenere Davi jikolahare tyaohena xaokita? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nexa Jesus ihiyeha hoka maisa xala harenai ekoaxahenahitita enomana. Hatyo najikinita maisa xala harenai kinatya tyako axehititene. ");
INSERT INTO pabNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hatyaoseta Jesus iraihena haxaotyakiraharenai, halitinai xoaha kakoa hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","— Iraiti kakoa waiyoreterenai, exahe fariseunai xoaha atyo waiyore awaiyekehalakatyahitaha Moisés xaotyakiraho. ");
INSERT INTO pabNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hatyo hiyeta maika xasemaxematya iniraineha, exahe aokahitere akereta xisaona. Hoka awa atyo tyaonahitere akereta xisaohena. Hiyaiya, maisa atyo aotyakisahiterene akereta xini tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","— Timenere kolare atyo mokahitaha halitinai heno hoka maisa atyo kahinaetyarahene, maisa hakahihikase kakoa hekoti kahinaetyahene hoka hatyo kolare kolatyareha. ");
INSERT INTO pabNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Xoalini hare atyo tyomahitaha kawaiyakaha maheta. Xiyaiyehena, kalose xairatyahitaha Iraiti Waiyexe nanekoatare hoka olatyahitaha hatyaolinaeha, hakanoha hiye. Xiyaiyehena inimanaeha kanotini nerore. ");
INSERT INTO pabNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hisehaliti xowakehena hoka waiyexe okahakalati aose tyokaha aokowiyahitaha, exahe xahohisakoatyakalati hanako hoka okahakalati waiyexe koa taita tyokaha aokowitaha, kaxaiminisaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nikare wetekokoa jiyehenaha hoka kasani xaiminisati kakoa kakatyawaxatyaka ihiyeha aokahitaha, exahe “Xaotyakisatiye”, kakaixaretyakaha. ");
INSERT INTO pabNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","— Hoka xisoiya atyo maisa nikareta, “Xaotyakisatiye”, xikakaexaretyakita. Hiyaiya, xityotya atyo hahinaehare kakoarenai taita hoka haterore atyo Xiyaotyakisase. ");
INSERT INTO pabNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hoka ali waikohekoa atyo awa hatyatere xexe xaoka. Hiyaiya, haterore atyo Xexe enokoa nali tyaonitere. ");
INSERT INTO pabNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Maisaiya “Xekohaseti”, xikaxaokakita. Hiyaiya, haterore atyo Xiyekohase, Cristo. ");
INSERT INTO pabNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Xinekoni xekohaseti tyaonitere atyo etakehare hakiterehare. ");
INSERT INTO pabNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hiyaiya, xala xamani atyoite kalorexe aokowita hoka wakahare atyoite kaxomokaka, hoka xala xamani atyoite maisa haiyanae xahehare aokowita hoka kalorexe atyoite kaxomokaka — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","— Kaxiyani, xiso iraiti kakoa waiyoreterenai, exahe xiso fariseunai, teraharetyoarenae makere! Maikaite iniyalahare xikaxomokaka. Xiso atyo xamahokoanitita haiyanai nawenane Enore koamaniya. Maisa xakore Enore koamaniya xisaonare hoka xamahokoanitita haiyanai nawenane ekoamaniya. ");
INSERT INTO pabNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","— Kaxiyani, xiso iraiti kakoa waiyoreterenai, xiso fariseunai, teraharetyoarenae makere! Maikaite iniyalahare xikaxomokaka. Xiso atyo wainiyaneneronai xiyehalo xametakijita, xikaiwita hoka waha xiraexaita xateraharetyoa maheta. Hatyo hiyetaite masakare iniyalahare xikaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","— Kaxiyani, xiso iraiti kakoa waiyoreterenai, exahe xiso fariseunai, teraharetyoarenae makere! Maikaite iniyalahare xikaxomokaka. Xiso atyo ximahotyoa one kaloxere hoka xiyaneta hakakoare waikohekoa xatawa maheta haliti hoka xiyaotyakiraho tyaona maheta. Hoka hatya atyo xikaokehena hoka xiyahehare irikati mawakenehare xetare terota xamokitene. ");
INSERT INTO pabNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","— Maikaite iniyalahare xikaxomokaka. Xiso atyo maxoseharenai xotokahisaseharenae xaokowita xakore hoka xiso tehitiya atyo ximaxosehare. Xiso atyo exakere xaotyakijita: “Xala xamaniya atyo kaexaretya Iraexatyakalati Hana iniraene katyakekotyaka maheta hoka maisa nikare tyaonita hoka ehekoreya. Hoka xala xamaniya atyo kaexaretya ouro werokere Iraexatyakalati Hanako tyaonitere iniraene katyakekotyaka maheta hoka nikare atyoite tyaohena”, xita. ");
INSERT INTO pabNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Maotikonexenai, maxoseharenai! Xoare hare masakare waiye: Ouro werokere, xoana, Iraexatyakalati Hana hotikijitere ouro kore? ");
INSERT INTO pabNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Exakere tehitiya xaotyakijita: “Hatyaiya kaexaretya kirakahare fetatyakalaose iniraene katyakekotyaka maheta hoka maisa nikare tyaonita hoka ehekoreya. Hoka kaexaretya fetatyakalatyaose nali kirakahare tyaonitere kakoa hoka nikare atyoite tyaohena”, xita. ");
INSERT INTO pabNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Maxoseharenai! Xoare hare masakare waiye: kirakahare, xoana, fetatyakalati hotikijitere kirakahare kore? ");
INSERT INTO pabNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hiyeta hoka xala xamani atyo kaexaretita fetatyakalati tahi hoka kirakaharenai eheno tyaoniterenai tehitiya kaexaretita. ");
INSERT INTO pabNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Exahe xala xamaniya kaexaretya Iraexatyakalati Hana iniraene katyakekotyaka maheta hoka Iraexatyakalati Hana, exahe Enore nali tyaonitere tehitiya kaexaretita. ");
INSERT INTO pabNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Xala xamani atyo kaexarehena enokoa tahi hoka kaexaritita atyo Enore nokahakala, exahe Enore tyokitere eheno tehitiya kaexaretita. ");
INSERT INTO pabNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","— Kaxiyani, xiso iraiti kakoa waiyoreterenai, xiso fariseunai, teraharetyoarenae makere! Maikaite iniyalahare xikaxomokaka. Xiso atyo xijita xinakaira hiyeta Enore ana holini: hortelã, erva-doce, cominho, atya hana kanakoairoarenae xoaha hiyeta, xakore hoka maisa atyo xityakekore xaotyakiyaho masakare waiyexe: wenati waiyexe, waiyexehaliti, Enore tyakekotyaka harenai. Exeharenai xema tehititaiya xisaonita hoka ehekoreya. ");
INSERT INTO pabNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Xiso atyo maxoseharenai xotokahisaseharenae xaokowita xakore hoka xiso tehitiya atyo ximaxosehare. Xakowatita atyo nisarese, xakore hoka xatyokita atyo kamelo. ");
INSERT INTO pabNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","— Kaxiyani, xiso iraiti kakoa waiyoreterenai, xiso fariseunai, teraharetyoarenae makere! Maikaite iniyalahare xikaxomokaka. Xatihita atyo kobo, balatoahe harenai ihiniri maniya xakore hoka enakoha atyo kaise tyaonita xiyalijiniharene exahe xokoawaharene kakoare. ");
INSERT INTO pabNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseu maxosehare! Hatihehetehena kobo nakoako hoka ehenekoa maniya tehitiyaite iyomeheta tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","— Kaxiyani, xiso iraiti kakoa waiyoreterenai, xiso fariseunai, teraharetyoarenae makere! Maikaite iniyalahare xikaxomokaka. Xiso atyo motya xawatyakalati nitini iyomere kakoa kaxonatyakitere akereta xisaonita. Henekoa maniya atyo waiyehareha hoka enakoakoha atyo kamati nahe, xetako harenai. ");
INSERT INTO pabNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nikareta atyo xisaonita. Henekoa maniya atyo motya haliti waiyexenai ene xiso, xakore hoka xityako atyo kaise tyaonita ximaoserala, iniyalahare xománe. ");
INSERT INTO pabNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","— Kaxiyani, xiso iraiti kakoa waiyoreterenai, exahe xiso fariseunai, teraharetyoarenae makere! Maikaite iniyalahare xikaxomokaka. Xiso atyo waiyehare xawatyakalati xisomita iraiti xakaisaseharenai ana, exahe xawaiyeharehitita toahiya xowaka waiye maniya tyaohenerenai xawatyakalanai. ");
INSERT INTO pabNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hoka xita: “Wisoiya atyo wahetakomaniyereharenai tyaonitere xowakiya wisaonita hoka maisaiya atyo tyaonahitere akereta wisaonita, maisaiya atyo waijita iraiti xakaisaseharenai”, xita. ");
INSERT INTO pabNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nikare atyo xiraehena hoka iraiti xakaisaseharenai aisehenerenai jikolaharenai terota atyo xaokowita. ");
INSERT INTO pabNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hatyo hiyeta hekota atyo xisomita, xamematita xahetereharenai tyomitereharenai! ");
INSERT INTO pabNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","— Owi aisarexenai, owi ityaninai! Xoana hoka xatyahaharetyoita ximaxawatyakene irikati koni? ");
INSERT INTO pabNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hiyeta hoka nomita xihiye: naxikatyaite iraiti xakaisaseharenai, waiyorexenai, xaotyakisatiyenai xoaha xomana. Hoka haiyanaite xaisa, haiyanaite xaberekotya atyalihose xaimaholatyaka hiye, haiyanai tehitiyaite xamokonasetya xahohisakoatyakalati hanako, exahe wenakalatinai nihatyakaite xehokatetyahene. ");
INSERT INTO pabNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hatyo hiyeta iniyalahare maomaneharenai iniyalahare mohenere, exahe aisehenere xahetakomaniyereharenai atyoite xiheno kaxomokaka, iniyalahare maomanehare Abel kaxaisakehenereta, Baraquias ityani Zacarias xaisehenere Iraexatyakalati Hana, fetatyakalati xoaha nenekesene xaisehenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aliterexe nomita xihiye: tyotya hatyoharenaite kalikiniyerenai heno tehitiyaite kaxomokaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesus halakihena hairaine hoka nexa: — Jerusalém, Jerusalém! Hiso atyo haijita iraiti xakaisaseharenai, sehali kakoa hamokotita Enore xaxikalaharenai! Kahaliki xakore naxakoloharetya naokowita hihotyaliharenai takoira haisani mokosenai hatane katyahe mokitere akereta, xakore hoka maisa atyo haoka. ");
INSERT INTO pabNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hoka kalikini atyoite hihana kahalakisakehena kaiserehare. ");
INSERT INTO pabNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aliterexe nomita: Maisa atyoite hiyaiyehitita natyo exakere hiraehenere kijiya: “Xekohaseti Enore, waiye kaiserehare atyo hatyo hexare kakoa tyoiterehare”, hehenere kijiya — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hatyaoseta Jesus hikoaheta Iraexatyakalati Hanakota hoka xanehetehena ene hoka exaotyakiraharenai xaneha ehaliya hoka hotikisaha enomana Iraexatyakalati Hana, hatinasenai. ");
INSERT INTO pabNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hoka Jesus nexa: — Xoana tyotya hatyoharenai xiyaita? Haxowaka ferakenite tyotya exe xiyaiyitereharenai kamawenekoaretyakeheta. Hoka maisaiya hatya sehali hatya sehali heno tyaohitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hatyaoseta Jesus tyokita Oliveiras tyairiya heno hoka exaotyakiraharenai xaneha ehaliya hoka axehenahene hawawaharenai heko: — Xoana xowakaite hatyoharenai kaotyakehena? Xoare hare hotohare ite kaotyakehena hoka hotikihena hisoaneneheta ferakene exahe tyotya xoalini hare miyanaose hoka? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hoka Jesus nehena: — Xirihalira xisaona hoka maisa xala hare maoseraita xiso. ");
INSERT INTO pabNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hiyaiya, kaharetyaite kaotyakehena nexare kakoa hoka nehenaha: “Natyo atyo Enore Kalorexe Aohenere”, nehenaha. Hoka kahare halitite maoserahenaha. ");
INSERT INTO pabNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","— Awa atyo ximairehena xasemehena xaisakakoati nemahare, exahe xaisakakoati tahi hoka. Tyotya hatyoharenaite kaotyaka, xakore hoka maisa atyoite imiyanaosehenere. ");
INSERT INTO pabNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hahotyalihare ite xane hahotyalihare kakoa aisakakoahena, hakoatare ite xane hakoatare kakoa aisakakoahena. Haiyanae koaite waikohe tatakoahena, nakitite tyaohena. ");
INSERT INTO pabNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hatyo harenai atyoite hetati xoima kawetere akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","— Hatyo najikinitaite berexotyahaite xiso iniyalahare xikaxomokaka maheta. Hoka xikaxaisakaite. Tyotyahaite kirawaneha xiso nohiyiti. ");
INSERT INTO pabNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hatyo xowakiyaite kahare haliti halakisa hatyakekone hoka iraeharehena, kirawanehena hahinaeharenai. ");
INSERT INTO pabNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kahare ite iraeti xakaisaseharenai metalaharenai kaotyaka hoka kahare halitinai maoserahenaha. ");
INSERT INTO pabNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hoka iniyalahare ite exaoretyoa hoka haiyaharenai xawaiyeraite awehetya. ");
INSERT INTO pabNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Xakore hoka xala xamani atyoite heko kinatere tyaona nokoamaniye imiyanaose kijiya hoka hatyo atyoite kaiyakeheta. ");
INSERT INTO pabNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iraeti Waiyexe enokoatare Xekohaseti tyoaneneheta tahi atyoite kaxakaisaka hakakoare wenakalatikoanai, tyotya haliti hotyalinai semene maheta. Hatyaoseta atyoite miyanitiye ferakene kaotyakehena. ");
INSERT INTO pabNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesus nihitiya: — Maika xiyaiyehena “Kaheneharexe, exahe wenati xaiyalaharetyasehare” waiyexe aose nali hoka maika xala xamani Judéia nali tyaonita hoka ");
INSERT INTO pabNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tekoahenaira tyairinai koni xeta. (Iraiti xakaisasehare Daniel xakai hatyo tahi. Maika hatyo “Kaheneharexe, exahe wenati xaiyalaharetyasehare” aokitere ekaixarityasehare ana waiyekehalaka). ");
INSERT INTO pabNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","— Maika xala xamani hahana heno tyaonita hoka tekoahena rotitaira hoka awa atyo isoahetehena hoka xoalini hare iyehetehena. ");
INSERT INTO pabNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Maika xala xamani mase tyaonita hoka awa atyo haikoahetehena hahana xeta haima kolaheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kaxiyani, hatyo xowakiya atyoite howitihare tyaohena tifalonai exahe xoimaisanironai ana hoka! ");
INSERT INTO pabNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Maika xiraexatya Enore hiye hoka maisa hatyo harenai tihere xowaka kaotyakita, exahe sábado xowaka hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Hiyaiya, hatyo xowakehena atyoite hoka wenati atyoite howitihare tyaohena. Maisa xoana xowaka nikare tyaonare Enore tyomehenere waikohekoa xowakiyata. Maisaiya atyoite nikare tyaohitita haxowakiya. ");
INSERT INTO pabNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Xakore hoka Xekohaseti atyo aikiranetya hatyo wenati howitiharexe ferakenenae. Maisaiya nikarexe hoka maisaiya xala hare makamanehare tyaonita. Xakore hoka Enore iyeheta aokowihenerenai hiyeta atyo hatyo ferakenenae kaxakiranityakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","— Maika hatya nehena xihiye: “Xiyaiyehena, Kalorexe Enore Aohenere ali tyaonita”, nehena xamani, “Owene tyaonita”, nehena hoka awa atyo xityakekone. ");
INSERT INTO pabNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hiyaiya, kaotyakaite iraeti xakaisaseharenai exahe Enore Kalorexe Aohenere metalaharenai hoka tyomahaite kahare xoalini hare maomakahare katyakekotyakaha maheta hoka maoserahenaha haliti. Aiyateretyoahaite maoseratyaha maheta Enore haomanerehare aohenerenai. ");
INSERT INTO pabNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","— Waiyira xasema: exe harenaetya noxakaita xihiye kaotyakehenere nahitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","— Maika nehenaha: “Xiyaiyehena, owene Enore Kalorexe Aohenere tyaonita maharexakiti”, nehenaha hoka awa atyo xiyane nali. Exahe xoana nehenaha xamani: “Xiyaiyehena, owene teroita”, nehenaha hoka awa atyo xityakeko. ");
INSERT INTO pabNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hiyaiya, kahihiye hoka enokoa nali hamaniyata xane hamaniya werokakoa mokita. Nikareta atyoite tyaona Haliti Ityani tyoaneneheta xowaka. ");
INSERT INTO pabNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","— Aliyako xamani atyoite kamati tyaonita hoka hatyo nalite olohonai hohisakoahena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hatyaoseta Jesus nexa: — Hatyo howitihare tyaohenere ferakenenai najikinitaite kamae ite makaliro tyaona, kaimare ite hoka maisa aokanahitita. Xoresenaite exoa enokoata, exahe enokoa kinatere tyaoniterenaite komita maiyaterehare tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","— Hatyaosetaite kaotyakeheta Haliti Ityani enokoa. Hoka tyotya halitinai waikohekoa tyaoniterenaite waiyahaite Haliti Ityani xexoaneheta kaiminiti konita, haiyatere exahe hawerokene kakoa hoka tiyahenaha hamairane. ");
INSERT INTO pabNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hatyaosetaite koneta kaemahare kinatyaxa hoka axikatyaite hawakaneharenae anjonai waikohekoa nihatyaka maniya. Hoka anjonaite ahohisakoatya Enore haomana aohenerenai tyotya hakakoareta — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hoka Jesus nihitiya: — Waiyexira xasemehena halohalo kate tahi. Hiyaiya, ekanohinai atyo tihorehetehena, exahe ehanahinai atyo hikoahetehena hoka waiyekehalakita atyo xomana enonenehetehena. ");
INSERT INTO pabNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nikareta tehitiyaite exeharenai kaotyakehena hoka waiyekehalakaira xomana Haliti Ityani okoi haikoahetehenerehare. ");
INSERT INTO pabNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Xotyaxematya exehare: exeharenai tyaite kaotyaka exe kasetatereharenai makamaneharene nahitita. ");
INSERT INTO pabNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Enokoa exahe waikohe harenai tyaite maiyareheta, xakore hoka niraini tyatyoite tyaota mene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesus nihitiya: — Eferakene exahe exowakehena atyoite hoka maisa xala hare ana waiyekehalakere, maisa atyo anjonai enokoa tyaoniterenai ana waiyekehalakere, maisa atyo Enore Ityani ana hekoti waiyekehalakere, xakore hoka Enexe Enore ana taita atyo waiyekehalakita. ");
INSERT INTO pabNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","— Haliti Ityani tyoaneneheta atyoite Noé xowakiya kawenatyakehenere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hiyaiya, one morehenere nahitita halitinai kanakairitaha, terahitaha, exahe enanai ohironai harenai hoka tyaonakakoahitaha harenai, Noé isoahenere kanowa kalorexe kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nikare tyaonahitaha exowaka hoka maisa one morehenere akiti waiyekehalakere enomanaha hoka one more exahitaha hoka aisa miyatyahene. — Nikareta tehitiya atyoite Haliti Ityani tyoaneneheta. ");
INSERT INTO pabNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hatyo xowakaite hinamahare halitinaite hakita masenekoa. Hoka hatyaite kakolatyaka, hatya atyoite kahalakisaka enaoseta. ");
INSERT INTO pabNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hinamahalo ohironaite mehetyakalati hiye mehetyahitaha trigo, hoka hahaloite kakolatyaka hoka hahaloite enaoseta kahalakisaka xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","— Maika xikaxaikoawihena. Hiyaiya, maisa atyo waiyekehalakere xomana Xiyekohase kaokeneheta ferakene. ");
INSERT INTO pabNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Exeharenai xotyaxematya: hati waikatehareya atyo waiyoreta kaiwarexe kaokene kakoa hoka atyahiteniya hoka maisaiya ehanakota kaiwaharetitene. ");
INSERT INTO pabNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hatyohiyeta xiso tehitiya ximemere xisaohena. Hiyaiya, Haliti Ityani atyoite tyoheta ximaxatyahaneneharene xowaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Hoka Jesus nihitiya: — Xoanere haretya wakahare tyakekohatiye exahe iriharexe? Hatyohare atyo etakehare exekohase hawenekoare halakisene hoka kaxaikoterehare ehana exahe ijiterehare nakairati wakaharenai ana enaose kamaehena hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Waiye kaiserehare atyo wakahare nikare tyomiterehare, exekohase kaokehetehena hoka waiyiterehare. ");
INSERT INTO pabNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aliterexe nomita xihiye: exekohase ite hatyo wakahare ana tyotya haxiyeharenai halakisa kaxaikone maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hoka maisaiya atyo waiyexe wakahare hoka exakeriya ahekotya: “Noxekohase atyo howitihareta hatyoaneneheta kakoa”, nexaiya, hoka ");
INSERT INTO pabNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","hatyaosetaiya mokonasehenaiya haiyaharenai wakaharenai exahe wakahalonai, hoka kanakairehenaiya, terehenaiya hekatikarenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hoka exekohase ite tyoheta, ewakanehare maxatyaharenehareta, mawaiyekehalakitere enomana xowaka. ");
INSERT INTO pabNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hoka iniyalahare ite hawakanehare moka, exahe matyakekoneharenai xomokaka akeretaite kaxomokaka aoka. Hoka nalite tiyahena exahe karai, karai, nexa mohena haikoli. ");
INSERT INTO pabNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hoka Jesus nexa: — Hatyo xowaka atyoite Enore koamaniya nawenatyaka atyoite 10-halo xoimahalotinai kolatyaha haxaokanatyakalaha hoka xane ahalakoatyahitere ");
INSERT INTO pabNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","kaiyanityohenere akereta. 5-halonai atyo maisa irihalolo hoka 5-halo atyo irihalo. ");
INSERT INTO pabNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hatyo 5-halo mairihalonehalonai atyo kolatyaha haxaokanatyakalaha hoka maisa atyo kolatyahitaha exá haxaokanatyakalaha niyahare. ");
INSERT INTO pabNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hoka irihalolonai atyo kolatyaha haitimaxaha haxaokanatyakalaha niyahare. ");
INSERT INTO pabNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","— Kaiyanityohenere wahehena makaokeneta hoka nemahenaha, enemakaha kawehena hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hoka wahaxatihena hoka semaha kawawi: “Kaiyanityohenere kaokehena! Xisohena hoka xahalakoatene!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","— Hatyaoseta hatyo 10-halo xoimahalotinai kaosehetaha hoka aotakahenahitaha haxaokanatyakalanai. ");
INSERT INTO pabNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hoka hatyo mairihalonehalonai nehenaha hahinaehalonaiha hiye: “Xama inira xisa womana xitimaxa hiyeta. Wiyaokanatyakala wakehena wonita”, nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","— “Maisaiya aliyakere”, nexaha hatyo ihinaehalonai irihalolonai ihiyeha. “Witimaxaiya maisa xihakakoaneta, exahe wihakakoaneta. Xaokita atyo hoka xiyane xiya!” nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","— Hatyaoseta xoimahaloti mairihalonehalonai xaneha iyaha maheta haitimaxaha hoka emakanetaha kaiyanityohenere kaoka. Hoka 5-halo xoimahalotinai memere tyaoniterenai isoaha exema enawenakakoane hisehare ana hoka jihore jihotyoa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","— Hatyo najikinita haiyahalonai kaokeheta hoka kawihenaha: “Xekohaseti, xekohaseti! hamajiholatya hoka wisoa”, nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","— Hoka kaiyanityohenere nehena: “Maisa nowaiyanihalo xini xiso! Maisaiya namajiholaita xomana!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hoka Jesus halakihenahairaene hoka nehena: — Hiyeta maika xikaxaikoawihena. Hiyaiya, maisa atyo xawaiyorexe Haliti Ityani tyoaneneheta ferakene kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Hoka Jesus nehitiya: — Enore koamaniya nawenatyaka tehitiya atyoite hatya haliti xanehena maheta hoka kawisa hawakaneharenai hoka halakijitere haxiyehare enomanaha hoka kaxaikoahitere enomana maheta akereta atyoite. ");
INSERT INTO pabNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hoka olo isa enomanaha, enawaiyoreha hakakoane akereta. Hatya ana 5.000 hokose olo isa, hatya ana tehitiya 2.000 hokose, hatya ana tehitiya 1.000 hokose isa. Hatyaoseta xane. ");
INSERT INTO pabNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hoka wakahare 5.000 hokose olo resebehenere xane haka hatyo haoloxa kakoa hoka 5.000 akekoarehitiyene. ");
INSERT INTO pabNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nikare tehitiya 2.000 resebehenere haka haoloxa kakoa hoka 2.000 akekoarekihitiyene. ");
INSERT INTO pabNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Hoka 1.000 resebehenere atyo xane seka toloko hoka waikoako tolokotya haxekohase noloxa, ateroakisene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","— Hatyaoseta wahakiyehena najikinita exekohaseha haikoaheta hoka axehenahitehenene haoloxa tahi. ");
INSERT INTO pabNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hoka wakahare 5.000 hokose olo resebehenere xane hoka iseheta enoloxa enomana 5.000 kajiyanehenere kakoita hoka nehena: “Xekohaseti, hisa atyo nomani 5.000 hokose olo. Hoka hiyaiyehena, owene 5.000 nakajiyanehenerene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—“Waiye kaiserehare, wakahare waiyexe, tyakekohatiye atyo hiso”, nexa exekohase. “Hiso atyo hirihare hikaxaiko inirere olo. Hatyo hiyeta exaheharite nisa homana hoka hikaxaiko. Hisohena hoka wimaxalohare!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","— Hatyaoseta wakahare 2.000 hokose resebehenere xane hoka nehena: “Xekohaseti, hisa atyo nomani 2.000 hokose olo. Hoka hiyaiyehena, owene 2.000 nakajiyanehenerene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Waiye kaiserehare, wakahare waiyexe, tyakekohatiye”, nexa exekohase. “Hiso atyo hirihare hikaxaikota inirere olo. Hatyo hiyeta exahehare ite nisa homana hoka hikaxaiko. Hisohena hoka wimaxalohare!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","— Hatyaoseta wakahare 1.000 resebehenere xane hoka nehena: “Xekohaseti, waiyekehalakita atyo nomani hiyalijiniharene. Himixita atyo himaxaferene akitita, hahotyalikijita atyo himaxawakoarene akitita. ");
INSERT INTO pabNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nomaira hoka hatyo hiyeta nateroakisa holoxa waikoako. Hiyaiyehena, owene holoxa”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—“Wakahare mahakaiserexe, maxaharehatiye!” nexa. “Waiyekehalakita atyo homana noximexani nomaxafirinihare akitita, nahotyalikihititere nomaxawakoalinihare akitita. ");
INSERT INTO pabNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Hoka ekoiya noloxi olo xomokakala hanako hamokare hoka nahaikoahetehenaiya hoka exahexeya naresebehetene”, nexa. — Hatyaoseta ehaikoahareheta hoka nehena hawakaneharenai hiye: ");
INSERT INTO pabNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Xiyeheta enoloxa enonita hoka xisene 10.000 hokose kaoloxehenere ana. ");
INSERT INTO pabNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hiyaiya, xala xamani atyoite kalore kakoare hoka kaxekakihitiyaite enomana hoka exahehare ite tyaona enomana. Hoka xala xamani atyoite maisa xoare kakoare, exahe inirere kakoare ene hoka kaiyaketa atyoite enonitata. ");
INSERT INTO pabNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hoka xaxawatene menanaka makaliroti koni wakahare maisakaiserexe. Hoka nalite tiya exahe haikoli hoka karai, karai, nexa moka” — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","— Haliti Ityani kalorexe tyaohetehenere hoka tyohetehenere tyotya anjonai kakoa xowakaite tyoka haokahakala waiyexe heno. ");
INSERT INTO pabNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hatyaosetaite tyotya halitinai waikohekoa tyaoniterenaite hohisakoaha enahalakoa hoka haware xakinite mokahene, kalanero nonitata haware kabala mokitere ekaxaikotyasehare akeretaite. ");
INSERT INTO pabNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kalaneronai aokitere ite hafihini maniya moka, hoka kabalanai aokiterite hawatone maniya. ");
INSERT INTO pabNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hatyaosetaite kalorexe nehena hafihini maniya mohenerenai hiye: “Xasemehena, xiso baba awaiyehenerenai! Xisohena hoka xisaona wenakalati Baba hetati waikohe, enokoa xoaha tyomehenere xowakiyita tyomehenere nali. ");
INSERT INTO pabNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hiyaiya, nonakita ene hoka xatyaisa natyo. Noinita ene hoka xerakisa natyo. Hahotyalihare xakore natyo hoka xihanako xaisoakisa natyo. ");
INSERT INTO pabNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nomaimahiro ene hoka xakaimatya natyo. Nohokakita ene hoka xikaxaiko natyo. Berexo ako notyaonita hoka xisoa xiyaiya natyo”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","— Hoka waiyexeharexenaite axehena: “Xekohaseti, xoana xowaka hinakita ene hoka watyaisa hiso, exahe hoinita ene hoka werakisa hiso? ");
INSERT INTO pabNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Xoana xowaka hahotyalihare xakore wiyaiya hiso hoka waiye wamoka hiso wihanako, exahe himaimahiro ene hoka wakaimatya hiso? ");
INSERT INTO pabNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Xoana xowaka hihokakita ene, exahe berexo ako hisaonita hoka wisoa wiyaiya hiso?” nexahaite. ");
INSERT INTO pabNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hatyaosetaite Kalorexe nehena: “Aliterexe nomita xihiye: nikare atyo xamoka nohinaeharenai kirakoane tyaoniterenai hoka natyo atyo nikare xamokita”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","— Hatyaosetaite nehena hawatone maniya mohenerenai hiye: “Xakikisoahetehena noniti, xiso Enore nirawanakorenai! Xiyanehena irikati matyotenehare koni memere kaxomokakehenere Tihanare, ewakaneharenai anjonai anere nali. ");
INSERT INTO pabNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hiyaiya, nonakitere xowaka maisa xatyaijita natyo, noinitere xowaka maisa xerakijita natyo. ");
INSERT INTO pabNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hahotyalihare xakore natyo hoka maisa xihanako xaisoakijita natyo, nomaimahiro xakore hoka maisa xakaimaita natyo. Nohokakita, exahe berexo ako xoaha xakore notyaonita hoka maisa xisoa xiyaita natyo”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","— Hatyaosetaite axehenahene: “Xekohaseti, xoana xowaka hinakita, hoinita, hahotyalihare, himaimahiro, hihokakita, berexo ako hisaonita hoka wiyaiya hiso hoka maisa wakahinaetita hiso?” nexahaite. ");
INSERT INTO pabNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hatyaosetaite kalorexe nehena: “Aliterexe nomita xihiye: tyotyaki ximakahinaerehenere nohinaeharenai kirakoane tyaoniterenai xowaka atyo natyo atyo ximakahinairita”, nexaite. ");
INSERT INTO pabNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hatyaoseta Jesus halakihena hairaene hoka nexa: — Hatyonai atyoite xaneha irikati matyotenehare tyaonitere nali hoka waiyexenai atyoite xaneha wenakalati waiyexe nali hoka waiye tyaonaha mene matyotenehare — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hatyaoseta Jesus miyatya hatyoharenai tahi haxaotyakira hoka nexa haxaotyakiraharenai hiye: ");
INSERT INTO pabNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","— Waiyekehalakita atyo xomana: Hinamaki ferakene taitehena atyo hoka hisehaliti Páscoa tyaohena. Hoka Haliti Ityanite kamatawatyakehena atyalihose xaimaholatyaka hiye kaberekotyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hatyaoseta sacerdotenai xekohasenai, judeu nityohalitiranaiha harenai ahohisakoatyakakoaha xekohaseti Caifás hanako. ");
INSERT INTO pabNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Hoka ahekotyaha: hametenetaha otokaha Jesus hoka aisahene aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Xakore hoka nehenaha: — Maisaiya nikare wisaonita hisehaliti xowaka, waiya aliya hoka halitinai xalijinihare tyaona — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hoka Jesus wenakalati Betânia nali tyaonita jijikoahiti tawanehare Simão hanako hoka ");
INSERT INTO pabNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","hatya ohiro kaoka enomana airaxero karore kahekoalo. Hoka Jesus kanakairita ene hoka eseri heno airaxero owika. ");
INSERT INTO pabNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hoka exaotyakiraharenai waiyaha hatyoharenai hoka ehareha hoka nexaha: — Xoanere hoka nikare tyaonita? Hiyaiya, airaxero meta. ");
INSERT INTO pabNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ikoiya atyo airaxero kabetetyaka kalo xaimane hoka hatyo oloiya kaxekaka maoloxaharenai ana! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hoka Jesus ana waiyekehalakita iniraineha hoka nehena: — Xoana hoka xexamaikohalonikijita exe ohiro? Hiyaiya, waiyexe atyo tyoma nomani. ");
INSERT INTO pabNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hiyaiya, maoloxaharenai atyoite tyaota mene xinekoni hoka natyoiya atyo maisa notyaoneta minita xinekoni. ");
INSERT INTO pabNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nokamani nahitita atyo tyoa airaxeharetya noháre, noxafityaki niyahare. ");
INSERT INTO pabNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aliterexe nomita xihiye: tyotya hakakoare Iraiti Waiyexe kaxakaisakehena nali atyoite kaxakaisaka exe tyomehenere nomani hoka otyaxemahenahitahaite exe ohiro. ");
INSERT INTO pabNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hatyaoseta 12-hare exaotyakiraharenai konitare, Judas Iscariotes nexarexe, xane iraehena sacerdotenai xekohasenai kakoa ");
INSERT INTO pabNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","hoka nehena: — Xoanereya xabakatya natyo hoka namatawatya Jesus xomana? nexa. Hatyaoseta ihatyaha 30 hokose olo prata nomaka hoka isaha enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hatyo najikinita Judas ahekohena Jesus hamatawala tahi akiti kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hatyaoseta hetatiye ferakene hisehaliti nakairati makaorehetyakahare kakanakairatyaka aokahitere xowaka xane hikoa. Hoka exaotyakiraharenai xaneha Jesus haliya hoka axahene: — Aliye nali wisoma nakairati hisehaliti Páscoa niyahare haokita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hoka nexa ihiyeha: — Xiyanehena wenakalati xeta hoka xatawa hatya haliti hoka xexa ihiye: “Xekohaseti nexa: ‘Noferakini xane hikoa. Noxaotyakiriharenai, natyo harenaite wotyaxemahena Páscoa ferakene hihanako’ ”, xexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hatyaoseta exaotyakiraharenai Jesus aokitere akereta tyaonaha hoka tyomaha nakairati Páscoa niyahare. ");
INSERT INTO pabNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Maka hoka Jesus 12-hare haxaotyakiraharenai kakoa tyoka kanakairaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kanakairahita hoka Jesus nehena: — Aliterexe nomita xihiye: hatya xinekonitare ite matawahena natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nexa hoka kalore amaikohareha hoka hatya xakini axehenaha Jesus: — Xoana maisa natyo xini haokita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hoka Jesus nehena: — Hatya nohakakoani balatoahekoa maikitere nakairatite matawahena natyo. ");
INSERT INTO pabNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Haliti Ityanite wainihena Iraiti Waiyexe iraetere akereta, xakore hoka kirakoane atyoite tyaohena Haliti Ityani matawahenere! Waiye kaiserehareya atyo mawenanehareta tyaonare! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hatyaoseta Judas, ematawatyasehare, axehenene: — Xaotyakisatiye, xoana maisa natyo xini haokita? nexa. — Hoka hisota atyo nikare hiraeta — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kanakairahitaha hoka Jesus iya nakairati hoka iraexatya Enore hiye. Hatyaoseta taikasetene hoka isene haxaotyakiraharenai ana hoka nehena: — Xotohena hoka xikanakaira. Exe atyo noháre — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hatyaoseta iyehitiya erakakalati hoka iraexahitiya Enore hiye. Hatyaoseta isene haxaotyakiraharenai ana hoka nehena: — Xiserehena xityotya inira xakini. ");
INSERT INTO pabNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hiyaiya, exe atyo notimalaxi, kaxiratyakehenere kahare haliti wanahiya, kaxemaisatyakeheta maheta iniyalahare enómaneha. Exe timalati hiyeta atyo waitare wenati tyaoheta halitinai ana Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aliterexe nomita xihiye: exaoseta atyoite maisa noterehitita exehare vinhoxa xikakoa. Xakore hoka noterehitiya atyoite waitarexa vinhoxa xikakoa Baba nawenakala nali — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hatyaoseta xeraha haxaka xerati hoka xaneha Oliveiras tyairiya nali. ");
INSERT INTO pabNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hoka hatyo nali Jesus nexa: — Exe xatinite xisekoahena, xahalakihena natyo. Hiyaiya, iraiti waiyexe kaxairatyakehenere atyo nexa: “Naisaite kaxaikotyatiye hoka tyotyaite ekaxaikoneharenai xaore”. ");
INSERT INTO pabNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Xakore hoka nokasehetehenere najikinitaite noxani xaheta maniya Galiléia xeta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hatyaoseta Pedro nehena Jesus hiye: — Maisaiya atyo natyo nahalakijita hiso, exahe haiyanai nikare tyaona hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hoka Jesus nexa Pedro hiye: — Aliterexe nomita hihiye: awisa xatinite, takoira makawiraharenetaite, hanamaki hateraharetyoa, himawaiyaneneharene ite haoka natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hoka Pedro nexa: — Maisaiya xoana hekota nomawaiyanihare naokita hiso, exahite kotare nowaini hihakakoane — nexa. Tyotya exaotyakiraharenai nikare makere iraeha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hatyaoseta Jesus xane haxaotyakiraharenai kakoa Getsêmani aokahitere nali hoka nexa: — Alita xisokehena hoka noxani exe waheta maniya hoka niraexatya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hatyaoseta noloka Pedro, hinamahare Zebedeu ityaninai xoaha hoka hatyo nali Jesus haxamaikoharene kehexa, exahe hamawaiyeharene, ");
INSERT INTO pabNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","hoka nehena: — Kalore noxamaikohalini nokihixita nohiye, motya aijita ene natyo. Alitehena xiso hoka xikaose hoka xiyaiyahokotyoa nohakakoani — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nexa hoka xanehitiya sekose aka hoka meholokoa hatiho kakoa waikoa hoka iraexatya: — Abá, haokitaiya atyo hoka hemaisaheta noniti exe erakakalati noxemakawatikisase. Xakore hoka maisaiya atyo naokitere akereta xini kaomaka hoka maika atyo haokitere akereta kaomaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hatyaoseta haikoaheta hoka waiyehena atyo, hanamahare exaotyakiraharenai atyo nemakita hoka nehena Pedro hiye: — Xoana maisaiya ini hekoti xikaose hoka xiyaiyahokotyoita nohakakoani? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xikaose hoka xiraexatya, maisa xikahasakaharetyakita maheta. Xiyahekola atyo waiye maniya tyaonita, xakore hoka xiháre atyo maisa kinaterexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hatyaoseta xane iraexahitiya ihinamakinihena hiye hoka nehena: — Abá, exe erakakalati noxemakawatikisaseya maisa kaxemaisatyakehitita nomaeraninihareta hoka maika haokitere akeretaite kaomaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hatyaoseta haikoaheta haxaotyakiraharenai ana hoka nemakahitataha waiyahene. Enemakaha kalore kaweta hoka maisa aliyakere kaosexeha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hatyaoseta Jesus xanehitiya enonyahitaha hoka ehanamakinihena hiye iraexahenere akereta iraexahitiya. ");
INSERT INTO pabNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hatyaoseta haikoaheta haxaotyakiraharenai ana hoka nehena: — Xoana xisemakitata, xikawinitata? Xasemehena, enaose xane hikoa hoka Haliti Ityani atyo kamatawatyakehena iniyalahare nomaseharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Xatityoahetehena hoka wiyaneheta. Xiyaiya, owene haliti nomatawatyasehare kaokehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus iraetata ene hoka Judas kaoka, hatyo 12-hare exaotyakiraharenai konitare. Kahare haliti tyoa exema, kesekase, atyalihose harenai kakoare. Sacerdotenai xekohasenai, exahe judeunai nityohalitiranai xoaha xaxikala xema tyoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ematawatyasehare koxaka irae ekakoaha hoka aimenekohena hoka nehena: — Nasohitanakolihenerira xotoka, hatyo terota atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hatyaoseta Judas kaoka hoka xane Jesus haliya hoka nehena: — Xoana waiye hisaonita, Xaotyakisatiye? nexa hoka sohitanakolisene. ");
INSERT INTO pabNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hoka Jesus nehena ihiye: — Nohinaehare, xoare xamani atyo hisoma haokowita hoka hisomehenene rotita! nexa. Hatyaoseta kaokaha hoka otokaha Jesus hoka olatyahene. ");
INSERT INTO pabNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hatyaoseta hatya Jesus haliya tyaonitere iya kesekase hoka mokotya sacerdote xekohasehare wakanehare hoka aikotya itinihe. ");
INSERT INTO pabNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hoka Jesus nehena: — Hamohetehena hikeserakase. Hiyaiya, xala xamaniya atyo kesekase kakoa aisa hoka hatyohare kakoitaiya atyo kaxaisaka. ");
INSERT INTO pabNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Xoana hiyahekola hiye ala, Baba naxa kahinaetya natyo maheta hoka motyaiyala maisa 12-hotyali anjonai axikaita nomani haokita? ");
INSERT INTO pabNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Xakore hoka nikareya notyaona hoka aliyakereya Iraiti Waiyexe nali xakaihenere akereta kawenatyakehena? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hatyaoseta Jesus nehena halitinai hiye: — Xoana hoka xisoa xotohena natyo maheta hoka kesekase, atyalihose harenai kakoa xisoa nomani hoka haliti xalijiniharexe akereta xamoka natyo? Hiyaiya, ferakiti nihatyaka notyaonita xikakoa Iraexatyakalati Hanako, xakore hoka maisa atyo xotokare natyo. ");
INSERT INTO pabNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Exakere xakore atyo xamokita natyo hoka iraeti xakaisaseharenai xairahenere Iraeti Waiyexe nanekoa akereta atyo kawenatyaka maheta — nexa. Hatyaoseta exaotyakiraharenai halakisa Jesus hoka tekoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hatyaoseta Jesus xotokasenai kolatene sacerdotenai xekohase, Caifás nexarexe hana nali. Hatyo nali koxaka hohisakoaha xaotyakiyaho kakoa waiyoreterenai, judeunai nityohalitiranai xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hoka Pedro xane Jesus xema sekoseta sacerdotenai xekohasehare hana talala hoko kijiya. Isoa hoka tyoka sorarenai haliya waiya maheta, aliyakere xamani mohenaha Jesus hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hatyaoseta sacerdotenai xekohaseharenai, tyotya kalorexenai xoaha semaha aokowiha xoalinihare maoserare Jesus tahi hoka aisahene aokowihenaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Xakore hoka maisa xoarehare semahitaha etahi. Kahareha xakore tityoaha hoka iraeha hamaoseralaha etahi hoka. Hatyaoseta hinamahare haliti maoseratyaliyenai tityoa hoka nehenaha: ");
INSERT INTO pabNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","— Exe haliti atyo exakere irai: “Nahatahetaiya Enore anere Iraexatyakalati Hana hoka notyomeheteniya hanamaki ferakene kakoita”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hatyaoseta sacerdotenai xekohasehare tityoa hoka axehena Jesus: — Xoana, maisaite xoare hiraeta exe hiraeharetyaka nahalakoa? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nexa xakore hoka Jesus mema tyaona. Hatyaoseta sacerdotenai xekohasehare axehitiyene: — Kasani hekoaxatya nomani naoka. Hiyaiya, Enore haotita niraeta hikakoa. Xoana hiso Enore Kalorexe Aohenere, Enore Ityani? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hoka Jesus nexa: — Hiso atyo nikare hiraeta. Xakore hoka aliterexe atyo niraeta xihiye: exaoseta atyoite xiyaiyehena Haliti Ityani nokane Enore kinaterexe fihini maniya, exahe exexoaneheta enokoata kaiminiti konita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hatyaoseta sacerdotenai xekohasehare halalaka haima (hotikisa maheta haxamaikoharene) hoka nehena: — Iniyalahare atyo irae! Maisaiya atyo xoare maheta etahi akiti hatya xakai wihiye waohitita! Hiyaiya, xasema atyo iniyalahare iniraene Enore tahi! ");
INSERT INTO pabNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hoka xoanaite wamohenene? nexa. Hoka nehenaha: — Nikare iniyalahare atyo irae hoka waiye xaisaka. ");
INSERT INTO pabNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hatyaoseta xatahotihotyahene, exahe itihokoa mokohenahene hoka ");
INSERT INTO pabNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nexahitaha: — Hotehena “Enore Kalorexe Aohenere”: xalatya mokotya hiso? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hatyo xowaka Pedro tyokita menanaka wetekokoa hoka sacerdotenai xekohasehare wakanehalo hikoa enomana hoka nehena: — Hiso tehitiya ene Jesus Galiléia yere xema hisaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hoka Pedro teraharetyoahena hoka tyotyaha ehaotitaha nehena: — Maisa atyo waiyekehalakere nomani hatyo hiraetere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hatyaoseta xane hatyo wetekokoa xisoakala nali hoka hatya wakahalo waiyehitiyene hoka nehena nali tyaoniterenai hiye: — Exe haliti atyo Jesus Nazaré yere xema ene tyaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nexa hoka Pedro teraharetyoahitiya: — Aliterexe naokita, maisa atyo nowaiyanihare xini hatyo haliti! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hatyo najikinita nali tyaoniterenai xane kaokaha Pedro haliya hoka nehenaha ihiye: — Hiraene hiyeta atyo hawaiyekehalakahare. Hiso tehitiya atyo aliterexe enekonitareha — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hatyaoseta Pedro nehena: — Aliterexe niraeta, maisa hatyo haliti nowaiyanihare xini! Ikoiya namaoseraita hoka ehekoretaiya Enore hatyohare hiyeta iniyalahare moka natyo — nexa. Hatyo xowaka takoira kawihena ");
INSERT INTO pabNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","hoka Pedro oteheta Jesus niraene: “Takoira makawiraharenetaite hanamaki hateraharetyoa hoka himawaiyanenehare ite haoka natyo”, nehenere. Hatyaoseta Pedro kikisoaheta hatyo nalita hoka tiya, kalore amaikohare hoka. ");
INSERT INTO pabNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kamaetali witita sacerdotenai xekohasenai, judeunai nityohalitiranaiha xoaha ahekohenaha Jesus haxaisaneha tahi. ");
INSERT INTO pabNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hatyaoseta olatyaha Jesus hoka xaneha ekakoa kalorexe Pilatos nali, isahene enomana hoka aisene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hatyaoseta Judas ematawatyasehare waiya Jesus xaisakehena hoka kehexaharetyoaheta hoka xane iseheta 30-hokose olo sacerdotenai xekohasenai exahe judeunai nityohalitiranaiha ana hoka ");
INSERT INTO pabNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nehena ihiyeha: — Iniyalahare notyoma namatawahenere haliti iniyalahare maomanehare hiyeta — nexa ihiyeha. Hoka nexaha: — Xoana, wisoiyatya hoka? Hiso kahane — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hatyaoseta Judas xawatya olohokosenai Iraexatyakalati Hanako hoka hikoaheta. Hatyo najikinita xane erahokoa hahino hiye hoka aisoawi. ");
INSERT INTO pabNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hatyaoseta sacerdote xekohasenai iyehetaha hatyo olo hokosenai hoka nehenaha: — Exe olo atyo timalati xaimane hoka wiyaotyakisakaho hiyetaiya atyo maisa exe olo wamokita Iraexatyakalati Hana anere kaxomokakitere olo kajalise ako — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hatyaoseta iraikakoahenahere najikinita hatyo olo kakoa xane iyaha “Barohe Hiye Hakatyasehare Waikohera”, aokahitere, sekotarenai xawatyakala niyahare maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hatyo hiyeta hatyo waikohe xaokaka kalikini kijiyehena “Timalati Waikoherakoa”, nerekatita. ");
INSERT INTO pabNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nikare tyaona iraiti xakaisasehare Jeremias iraetere akereta: Iyehenahitaha 30-hokose olo Israel yerenai tyakekohenahere ebakatyaka xaimane hoka ");
INSERT INTO pabNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","hatyo kakoa iyaha barohe hiye hakatyasehare waikohera, Xekohaseti notyoma aohenere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hatyaoseta Jesus tityoita kalorexe Pilatos nahalakoa hoka Pilatos axehenene hoka nehena: — Xoana, judeunai xekohase kalorexe hiso? nexa. — Hiso atyo nikare hiraeta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Xakore hoka maisa xoare ekoaxatyare sacerdotenai xekohasenai, judeunai nityohalitiranai niraene nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hatyaoseta Pilatos nehena: — Xoana maisa hasemare iniraehareraha hiso? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Xakore hoka Jesus mema tyaohitiya, hoka kalorexe hakaharetyoa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hisehaliti Páscoa xowakehena nihatyaka Pilatos aihikoahitita hatya berexo ako tyaonitere halitinai xaxane ximita. ");
INSERT INTO pabNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hatyo xowakiya hatya ewaiyanehareha kaiserehare berexo ako tyaonita, Barrabás nexarexe. ");
INSERT INTO pabNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hatyaoseta halitinai hohisakoaha hoka Pilatos axehenahene: — Xalaite naihikoaheta xomana xaohena: xoana Barrabás, xoana Jesus etake Enore Kalorexe Aohenere aokahitere kore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Waiyekehalakita atyo enomana sacerdotenai xekohaseharenai nokoawaharene Jesus hiye. Hatyohare hiyeta tyoaha ekakoa enali hoka isahene enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hatyaoseta Pilatos tyokitata ene kalorexe nokahakalaose nali hoka exanityo axikaxatya hairaine enomana: — Hahalakihena hatyo haliti iniyalahare maomanehare. Hiyaiya, exe xatini nojihini ako maisa waiye notyaonare ihiyeta, kalore namaikohalo ihiyeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Xakore hoka sacerdotenai xekohaseharenai, judeunai nityohalitiranai xoaha aiyateretyoahitaha halitinai xahita, axaha Pilatos hoka aihikoaheta Barrabás hoka Jesus xaisaka aokaha ihiye maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hatyaoseta kalorexe axehenahene: — Exe hinamaharenai konita, xala hare kaisere naihikoaheta xaokita? nexa. — Barrabás — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hoka Pilatos axahene: — Hoka xoana atyoite namohena Jesus, etake Enore Kalorexe Aohenere aokahitere? nexa. — Haberekohenene atyalihose xaimaholatyaka hiye! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hoka Pilatos axehenahitiyene: — Hoka xoaretya iniyalahare tyoma? nexa. Hatyaoseta aiyateretyoaha kawiyatyaha: — Haberekohenene atyalihose xaimaholatyaka hiye! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hatyaoseta Pilatos xakore waiya hoka maisa terota jiyahaotyarahene, exahe halitinaiya enajikini maniya ehareha ihiye aokita hoka axa one hoka tihahisoaheta halitinai nahalakoita hoka nehena: — Maisa atyo natyo hare xini exe haliti xaisaka naoka, xakore hoka xiso atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hoka tyotya halitinai nexaha: — Maika exe wainihenere hiyeta iniyalahare wikaxomokaka, exahe wijikolaharenai hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hatyaoseta Pilatos aihikoaheta Barrabás enomanaha. Hatyaoseta wakatya sorarenai hoka mokonasetyaha Jesus militihi aohenere najikinita halakisene enomanaha berekotyahene atyalihose xaimaholatyaka hiye maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hatyaoseta Pilatos sorarexanai kolatyaha Jesus kalorexe hanako nali hoka ahohisakoatyaha tyotya sorarenai hoka exahiyatyahene. ");
INSERT INTO pabNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hatyaoseta inima aitoakisaha hoka aisoakisahene imiti nase xotere ako. ");
INSERT INTO pabNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tyomaha xolatyaolisoakalati katohere kakoare hoka mokahene eseri hiye, atyakasese mokaha ekahekoa ifihini maniya. Hatyaoseta meholokoaha hakaolise kakoa enahalakoa hoka hirahenahene hoka nehenaha: — Hawaiyeta womana, judeunai xekohase! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hatyaoseta xataholisahene, exahe iyaha atyakase ekahekoata hoka mokotyahitene eseri hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Koexahalihenaherene najikinita aitoakihenahitaha imiti xotere nase hoka aisoakihenahitene inimako. Hatyaoseta xaneha ekakoa berekotyahene maheta atyalihose xaimaholatyaka hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Xanahitaha ene hoka ahotyaho ahalakoatyaha hatya haliti, Simão nexarexe, wenakalati Cirene yere, hoka otokaha Simão hoka Jesus berekotyakala niyahare atyalihose xaimaholatyaka kolatyaka aokaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hatyaoseta xane kaokaha Gólgota nexarexe nali. (Gólgota atyo “Seriti nahe akerehare aose”, nita.) ");
INSERT INTO pabNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kaokaha nali hoka isaha vinhoxa kaketaxatyaka nikanati kakoare Jesus ana terene maheta. Hoka hasakene hoka maisa terene aokowita. ");
INSERT INTO pabNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hatyaoseta berekotyahene atyalihose xaimaholatyaka hiye hoka hatyo najikinita hasakaharetyakakoaha hoka Jesus nima irakakakoaha hatyokakoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hatyo najikinita tyokaha hoka wahakohenaha Jesus ana. ");
INSERT INTO pabNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eseri haomaniya mokaha taba taose xairatise kakoare, haxawaiyekehalakalaha kakoare: ");
INSERT INTO pabNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hinamahare kaiwarexe tehitiya berekotyaha atyalihose xaimaholatyakanai hiye ehakakoane, hahare ifihini maniya, hahare ewatone maniya xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hoka hatyo nali jiyiterenai koexahalisahene. Matyakekotyahitene exahe xalawalisaha hakaiyeheha hoka nexahitaha: ");
INSERT INTO pabNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","— Hisoiya atyo hamawenekoaretya Iraexatyakalati Hana hoka hanamaki ferakene kakoitaiya hisomehetene haoka. Aliterexe atyo Enore Ityani hiso hoka hexoahetehena hiberekotyaka aoseta hoka hisota hiyoawihetehena! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hoka sacerdotenai xekohasenai, iraiti kakoa waiyoreterenai, judeunai nityohalitiranai harenae tehitiya koexahalihenahene hoka nehenaha: ");
INSERT INTO pabNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","— Haiyanai atyo iyeheta iniyalahare nonitata hoka maisaiya atyo hatyota iyoawihitita! Xoana, maisa Israel yerenai xekohase xini? Hoka kalikinitaiya atyo iyoawiheta haberekotyakaoseta hoka wityakekoneya atyo. ");
INSERT INTO pabNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Enore atyo tyakekota, exahe Enore Ityani aokowi. Hatyo hiyeta wawahakohena atyoite, xoana Enore xamani ala iyehetene aokowita kalikini! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kaiwarexenai ehaliya kaberekotyakehenerenai kakoita tehitiya kirawanahene hoka aiyalatyaha enomana. ");
INSERT INTO pabNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hatyaoseta totahikoahena hoka makalirohena hakakoare waikohekoa. Hoka makaliro tyaona makakoahena kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Makakoahena hoka Jesus kinatyaxa kawiyatya: — Eli, Eli, lemá sabactani — nexa. Exe iraeti atyo exakerexe nita: — Nenorexi, Nenorexi, xoana hoka hahalakisa natyo? nita. ");
INSERT INTO pabNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Haiyaharenai nali tyaoniterenai, semaha hatyohare hoka nexaha: — Elias atyo kawihena — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hatyaoseta hatya tema xane vinho xaiya mitoloka tihaharetyoakalati hoka atyakase keteho mokene hoka aimatene Jesus ana, terene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hoka haiyaharenai atyo nehenaha: — Awijira hoka wiyaiya, xoana xamanite hoka Elias tyoa iyehetene! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hatyaoseta Jesus kinatyaxa kawiyahitiya hoka waini. ");
INSERT INTO pabNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hatyo xowaka Iraexatyakalati Hanako imiti taose sololoitere halakoa nekese hoka hinama taose tyaona. Eno maniyata halalakoa waikoa maniya exoaheta. Waikohe tatakoa, exahe sehali kalolironai hoka ehekoa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Xawatyakalatinai majiholatyoaheta hoka kahare Enore koamaniya tyaoniterenai koxaka wainihenerenai kasehetaha ");
INSERT INTO pabNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","hoka hikoahenahitaha xawatyakalatinai akota. Hoka Jesus kasehetehenere najikinita xanehenahitaha Wenakalati Waiyexe nali hoka hatyo nali kahare halitinai waiyehenahitene. ");
INSERT INTO pabNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hatyaoseta sorare xekohasehare, esorarexanai harenai, Jesus ana wahakoiterenai, waiyaha waikohe tatakoane exahe xoalinihare hoka mairaha hoka nexaha: — Aliterexe atyo Enore Ityani ene! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hoka hatyo nali haiyahalonai ohironai tyaonita hoka sekota wahakotyahitaha. Tyoaha atyo Jesus xema Galiléia ta, exahe kahinaetyahitene ene. ");
INSERT INTO pabNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Enekoniha Maria Madalena, Maria, Tiago, José xoaha nityo, Zebedeu ityaninai nityo xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Okoi makehena hoka kaoka hatya haliti kaoloxere, José nexarexe, wenakalati Arimatéia nalitare. Hatyo tehitiya atyo Jesus nawenatyasehare. ");
INSERT INTO pabNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hoka José xane Pilatos axeheta Jesus háre. Hoka Pilatos exekakeheta enomana aoka. ");
INSERT INTO pabNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hatyaoseta José iyeheta eháre hoka olahisetene imiti kese taosero waitare taose kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Hoka xane mokene haomanere xawatyakalati ako. Hatyo sehali sekakohenere atyo maisa wahehena xini tyaonita. Hatyaoseta talirika sehali kalorexe taose jihotya maheta hatyo xawatyakalati. Hatyaoseta xaneheta. ");
INSERT INTO pabNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Exowaka Maria Madalena, hatya Maria xoaha, tyokahitaha hatyo xawatyakalati haliya. ");
INSERT INTO pabNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kamaetali, hatyo memere mohenahere sábado ferakene nahetere nahitita sacerdotenai xekohasenai, fariseunai xoaha hohisakoaha Pilatos kakoa ");
INSERT INTO pabNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hoka nehenaha: — Kalorexe, waiye atyo wotita. Kasetatere xowaka etake maoseratyaliye nexa: “Hanamaki ferakene najikinitaite hoka nokaseheta”, nitere. ");
INSERT INTO pabNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hatyo hiyeta haxikatya sorarenai hoka waiye exawatyakala kaxaikoha hanamaki ferakene. Hoka maisa exaotyakiraharenai iyehenahititaha eháre hoka nexahita halitinai hiye: “Kaseheta”, nexahitaha. Hiyaiya, hatyo miyanitiye maoserahenahereya atyo hetatiye xaheharehena niyahare — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hatyaoseta Pilatos nehena ihiyeha: — Owene sorarenai. Xiyane waiye xikaxaiko exawatyakala — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nexa hoka xaneha xawatyakalati jihola hiye mokaha baberane maisa xala hare watyalini maheta, exahe halakisaha sorarenai hatyo nali kaxaikoaha maheta xawatyakalati. ");
INSERT INTO pabNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sábado najikinita, domingo xowaka witita, Maria Madalena, hatya Maria xoaha xaneha waiyaha maheta xawatyakalati. ");
INSERT INTO pabNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hatyaoseta waikohekoa kalore tatakoa. Hoka Enore nalitare hatya anjo tyoa enokoata hoka iyeheta sehali xawatyakalati jihola hoka tyoka eheno. ");
INSERT INTO pabNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Motya kahihiye. Inimanai hoka iyomate kaiserehare. ");
INSERT INTO pabNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hatyaoseta ihiyeta sorarenai kalore mairaha hoka tatakoaha hoka exoaha waikoa, motya ekamane tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hatyaoseta anjo nehena ohironai hiye: — Awa atyo ximaira! Notita atyo xiso, xatawita atyo Jesus, etake kaberekotyakehenere atyalihose xaimaholatyaka hiye xáhita. ");
INSERT INTO pabNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Maisa atyo aliheta aka. Koxaka atyo kaseheta hairaine aoseta. Xisohena hoka mohenaherene aose xiyaiya. ");
INSERT INTO pabNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hoka xiyanehetehena hoka xexa exaotyakiraharenai hiye: “Koxaka kaseheta hoka xanehenaite xaheta Galiléia nali xeta. Nalite xiyaiyehetene”, xexa ihiyeha. Xotyaxematyaira exe niraitere — nexa anjo ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hatyaoseta ihalahalo haikoahenahitaha xawatyakalati nalita. Mairahitaha, xakore hoka ihalahaloha. Hoka tema xanehenahitaha, xakaiha maheta exaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hatyaoseta eharehena rotita Jesus ahalakoahenahitene hoka nehena: — Kasani ximehexaiko xisaona naoka! nexa. Nexa ihiyeha hoka xane kaokaha ehaliyita hoka meholokoa, awaiyityahene. ");
INSERT INTO pabNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hatyaoseta Jesus nehena: — Awa atyo ximaira. Xiyaneheta hoka xirai nohinaeharenai hiye hoka xaneha Galiléia xeta hoka nalite waiyehenahitaha natyo — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ohironai ahotitata xanehenahititaha hoka haiyanai sorarenai xawatyakalati kaxaikoterenai xanehenahitaha wenakalati hoka sacerdotenai xekohasenai hiye hatyo hawaiyaneha tahi xakaiha. ");
INSERT INTO pabNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hatyaoseta hatyo kalorexenai ahohisakoatyaha judeunai nityohalitiranai hoka iraekakoaha. Hatyaoseta kalore olo isaha sorarenai ana, ");
INSERT INTO pabNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","hoka nexaha ihiyeha: — Maika xexa: “Exaotyakiraharenai makiya tyoaha hoka wisemakiterenase ala iyehenahitaha eháre”, xexa. ");
INSERT INTO pabNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hoka exahe kalorexe semehenene hoka wijiyahaotenite xiraehenere akereta hoka maisa xoana mokita xiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hatyaoseta sorarenai tyaonaha hatyo olo kakoa hoka sacerdotenai xekohasenai aokitere akereta tyaonaha. Hatyo iraiti exaoretyoa hakakoare judeunai koni, heko kalikini kijiyehena hatyo tahi nikare kasemakita. ");
INSERT INTO pabNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hatyaoseta 11-hare exaotyakiraharenai xane Galiléia xeta. Hoka xaneha tyairi heno Jesus haxahalakoatyaka aohenere nali. ");
INSERT INTO pabNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hatyaoseta waiyehenahitaha Jesus hoka meholokoaha awaiyityahitene. Xakore hoka haiyaharenai atyo katyakoiyahare ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hatyaoseta Jesus kaoka ehaliyahitaha hoka nehena: — Enokoa, waikohekoa xoaha Xekohasehare atyo notyaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","— Hatyo hiyeta xiyane xaotyakihena tyotya haliti hotyalinai hoka nokoamaniye nawenatyasehare tyaonaha maheta. Hoka maika xabatixahenahene Baba nexare kakoa, Ityani nexare kakoa, Isekohaliti Waiyexe nexare kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Xaotyakihenahene hoka tyotya naokitere akere tyaonaha. Hoka xasemehena, tyotyaki ferakene ite nokaxaiko xiso miyanitiye ferakene kijiya — nexa Jesus haxaotyakiraharenai hiye.");
INSERT INTO pabNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iraiti Waiyexe Enore Ityani Jesus Cristo tahi akiti hetati xowakiya ");
INSERT INTO pabNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Enore niraine xakaisasehare Isaías xairahenere akereta: ");
INSERT INTO pabNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Enore nexa: “Nirainikakoare naxikatya haheta maniya memere moka maheta haheta maniya. Hoka kawijita maharexakahare nali: Memere ahoti xamohena Xekohaseti naheta, maika totaho xamohena enaheta maniya,” nita. ");
INSERT INTO pabNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hatyo hiyeta João Batista kaotyaka maharexakiti hoka batixaita halitinai, xakaita Iraiti Waiyexe ihiyeha. — Xahalakihena iniyalahare xománe hoka xikabatixatyaka hoka Enore maotyaneheta iniyalahare xománe — nita João ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tyotya Judéia koa tyaoniterenai, exahe wenakalati Jerusalém yerenai hoka xaneha João nali hoka iniyalahare háomaneha tahi xakaita ihiye, maisa teraharetyoita, hoka tyotya batixatyahene one Jordão xa nali. ");
INSERT INTO pabNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","João nima atyo camelo niyali nomakere hoka ijiterone atyo militihi. Iri nijita exahe maha hoka hiyokita. ");
INSERT INTO pabNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","— Najikinitaite hatya noxahehare tyohena — nita halitinai hiye. — Hoka maisaiya aliyakere natyonae nameholokoa hoka ikijitini xolahi hekoti namaxolaita. Hiyaiya, natyo atyo ekatyahakohare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","— Natyo atyo nabatixaita xiso one kakoa hoka hatyo atyoite batixahena xiso Isekohaliti Waiyexe kakoa — nita. ");
INSERT INTO pabNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hatyo xowaka Jesus tyoa wenakalati Nazaré nalita, Galiléia koa nalita hoka João batixatene one Jordão xa nali. ");
INSERT INTO pabNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hikoaheta onexata taita hoka waiyehena atyo Jesus, enokoa totakore tyaona hoka hatyoakota Isekohaliti Waiyexe exoahena enomana watyaha akerehare. ");
INSERT INTO pabNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Enokoata iraiti kasemaka: — Hiso atyo nityani noxiyakawali, hawaiyeta nomani, kalore haihalahalinikijita natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hatyo najikinita Isekohaliti Waiyexe axikatya Jesus maharexakahare nali. ");
INSERT INTO pabNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hatyo nali 40-ki ferakene tyaona. Hatyo nali Ahalakoahaliti hasakaharetene. Hatyo nali tehitiya kirakahare xalijiniharexenai tyaonita xakore hoka anjonai atyo kaxaikotene. ");
INSERT INTO pabNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hatyaoseta João kaberexotyakehenere najikinita Jesus xane Galiléia koa Iraiti Waiyexe Xekohaseti Enore nalitare tyohenere tahi akiti xakai maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","— Aimenekohenere aosetya xane hikoahena. Okoitya xekohaseti Enore nalitare kaokehena, xahalakihenaira xománe iniyalahare hoka Iraiti Waiyexe xityakekohena — nita ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Haxowakiya Jesus tonakilihijita one Galiléia hoka waiya hinamahare haximarene kakoarenae Simão Pedro, André xoaha. Maka kakoa mairatyahitaha, mairatyatiyenai hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","— Xisohena noximi hoka naotyakisa xiso hoka haliti nolokasehare xisaona — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hatyaoseta halakisaha rotita kohase hiyakakala hoka xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jiyehitiya maisekoneta hoka waiya hinamahare haximarene kakoarenai Tiago, João xoaha, Zebedeu ityaninai. Kanowako tinolaharehenahititaha maka kohase hiyakakala. ");
INSERT INTO pabNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kawisahene hoka halakisaha rotita hanexeha Zebedeu, ewakaneharenai harenai kanowakota hoka xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hatyaoseta Jesus haxaotyakiraharenae kakoa xane kaoka wenakalati Cafarnaum nali. Sábado ferakene xane xahohisakoatyakalati hanako aotyakisa halitinai maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Exaotyakira semaha hoka hakaharetyoaha, iraeta atyo iyateliti kakoare hoka. Maisa judeunai xaotyakiraho kakoa waiyoreterenai akereta xini aotyakijita hoka hatyo hiyeta hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aotyakijita ene hoka tihanare kamilakorerahare tyaonita enekonyaha hoka kinatyaxa irai Jesus kakoa: ");
INSERT INTO pabNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","— Xoare haoka wihiye, Jesus Nazaré yere? Xoana hisoa hamawenekoaretya maheta wiso? Waiye atyo hawaiyekehalakahareta nomani. Hiso atyo Enore Xaxikalahare Waiyexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hoka Jesus nexa tihanare hiye: — Nikareta hirae hoka hahikoahetehena hatyo haliti nonitata! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hatyaoseta tihanare atatakoakisene, awerahalikikoatene hoka hikoaheta enonita. ");
INSERT INTO pabNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hatyo hiyeta tyotyaha hakaharetyoaha hoka axakakoahenaha: — Xoanere kaisere? Xoanere, waitare xaotyakiye kakoala aotyakijita? Xiyaiya, iraihena tihanarenai kakoa hoka tyakekota iniraine — nexakakoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hatyo hiyeta tyotya Galiléia koa yerenae haxerore semaha Jesus tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hatyaoseta Jesus haxaotyakiraharenai kakoa hikoahenahitaha xahohisakoatyakalati hanakota hoka xaneha rotita Tiago, João xoaha kakoa Simão Pedro, André xoaha hana nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Exowaka Simão nimasero hokakita hoka ehokotyoita, watyahiseta hoka. Hatyaoseta Jesus kaoka taita hoka xakai etahi akiti ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hatyaoseta xane ehokotyoitere nali hoka otokene ekahe hiye hoka aokanikisene. Aokanikihetene hoka ewatyahisene tyoteheta enonita hoka xane nakairati tyoma enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Okoi kamai isoahena hoka kolatyaha tyotya hokakiterenae, exahe tihanare kamilakoreraharenae Jesus ana. ");
INSERT INTO pabNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tyotya hatyo wenakalati tyaoniterenai xane hohisakoaha hati kanase nali. ");
INSERT INTO pabNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus kahare haliti aiyatelikiheta tyotya kawakiti hawarehare kahehare kakoarenae, exahe kahare axanekiheta tihanarenae enonyahitaha. Hatyo tihanarenae ana atyo waiyekehalakahareta Jesus hoka hatyo hiyeta Jesus mairaenityahitene. ");
INSERT INTO pabNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kamaetali makahekoasetata hoka Jesus kaose hoka xane maharexakahare hoka nali iraexatya. ");
INSERT INTO pabNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Xane hoka hatyaoseta Simão Pedro, hahinaeharenae kakoa tawaha hakakoare Jesus xahita. ");
INSERT INTO pabNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Xane kaokehenahitene hoka: — Tyotyahaore tawahitaha hiso — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hoka Jesus nexa ihiyeha: — Wiyala hakiti wenakalati wihaliyeterenai nali hoka noxakai Iraiti Waiyexe ihiyeha. Hatyo niyahare notyoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hatyaoseta Jesus xane tyotya wenakalatinae Galiléia koa nali hoka Iraiti Waiyexe xakaita ihiyeha xahohisakoatyakalati hanakonai, exahe tihanarenai hoka axanekihitita. ");
INSERT INTO pabNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hatyaoseta jijikoahiti kahehare aijitere kaoka Jesus ana, hakaoliri kakoa meholokoa enomana axene maheta. — Hawaiyehihetaiya natyo haokowi hoka hawaiyehihetaiya natyo — nexa Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus airakoaneharetene hoka hakahe ekaokakisa ihiye hoka nexa ihiye: — Há, naokaite. Hawaiyehiheta atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hatyaoseta jijikoahiti kahehare tyoteheta enonita hoka kinatereheta. ");
INSERT INTO pabNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hatyaoseta Jesus kinatyaxa irai ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","— Awaira atyo hiyakaikoahena exehare hatya hiye. Hiyane sacerdote nali hoka hahotikisoa enomana. Hatyaosetaite Moisés aokitere akereta hisa enomana hoka Enore ana fetatene. Hoka tyotyaha waiyoreha hikinaterehenere kakoa — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Xakore hoka xaneheta hoka hakakoare xakaikoatene hoka tyotyaha semaha etahi. Hatyo hiyeta maisaiya Jesus aliyakere wenakalatinai koa xanehitita hoka maharexakahare nali xane tyaonita hoka hakakoare wenakalatinae tyaoniterenae tawitene. ");
INSERT INTO pabNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Akaiki ferakene najikinita Jesus haikoaheta wenakalati Cafarnaum nali xeta. Kaokeheta hahanako taita hoka haxerore nali tyaoniterenai semaha ekaokeneheta ");
INSERT INTO pabNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","hoka kahare haliti ehana nali xane. Kahare halitinai hohisakoa hoka hati kaise mokaha. Haiyaharenai menanakita tyaonita, maisa aliyakere hati kanase nali hekoti xane kaokareha. Jesus xakaitere Iraiti Waiyexe ihiyeha nase ");
INSERT INTO pabNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","haiyaharenai haliti hatya maetonanehare kolatya Jesus ana. ");
INSERT INTO pabNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kaokaha xakore hoka maisa aliyakere isoahitaha Jesus ana ekakoa, kahare halitinai hoka. Maisa aliyakere isoareha hoka kakohaha hatiri hoka hati taose iyaha hoka Jesus hototene exoakisahene exehokotyoakala kakoita. ");
INSERT INTO pabNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus waiya ityakekoneha hoka maetonanehare hiye nexa: — Hasemehena, iniyalahare hománenai atyo kaxemaisatyakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Judeunai xaotyakisakaho kakoa waiyoreterenai nali tyokita hoka ahekohenaha: ");
INSERT INTO pabNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","— Xoanala hoka nikare iraeta? Maisa aiminisare Enore. Hiyaiya, Enore taita atyo emaiyarehitita iniyalahare kaomakitereharenai. ");
INSERT INTO pabNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus otya rotita exahekolaha hoka nehena: — Xoana hoka nikare xahekotita? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","— Xoarehare ala haxerore niraetyaka maetonanehare hiye: “Iniyalahare hománenai atyo kaxemaisatyakeheta”, nerekatihenaite, xoana, “Hatityoahetehena hoka hatohetehena”, nerekatihena koríte? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","— Hiyaiya, nahotikisaite xomana. Natyo Haliti Ityani iyateliti kakoare atyo notyaonita ali waikohekoa hoka nohiyeta haliti nómane iniyalahare kaxemaisatyakeheta — nexa. Hatyaoseta nexa maetonanehare hiye: ");
INSERT INTO pabNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","— Hatityoahetehena hiyehetehena hiyetolisoakala hoka hiyanehetehena hihana xeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nexa taita ihiye hoka tityoaheta ehaotitaha, haxetolisoakala iyeheta hoka hikoaheta hatyo nalita. Tyotyaha hakaharetyoaha: — Maisa xoana xowaka exakere wiyaiyehenere — nexaha ihalahareha Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hatyaoseta Jesus xanehitiya one Galiléia haliya. Kahare haliti kaoka enomana hoka aotyakisahitene. ");
INSERT INTO pabNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tonita ene Jesus hoka waiya Alfeu ityani Levi, owene tyokita kalorexe noloxa bakatyakaose. — Hisohena noximi — nexa Jesus ihiye hoka tityoaheta hoka xane Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wahasehena hoka Jesus xane Levi hana nali kanakaira haxaotyakiraharenai kakoa. Kahare kalorexe noloxa resebetyaseharenai, iniyalahare nomaseharenai hare kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Judeunai xaotyakiraho kakoa waiyoreterenai, fariseunae xoaha waiyahita Jesus nakaira hatyo olo resebityaseharenai, nikareterenai xoaha kakoa hoka axaha exaotyakiraharenae: — Xoana hoka kanakairita, terita xoaha exe halitinai kakoa? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus sema exaxaneha hoka nehena ihiyeha: — Mahokakeneharenai atyo maisa wairatyare aokare haomana, hoka hokakiterenai wairatyare aokita haomana. Notyoa atyo naotyakisa maheta iniyalahare nomaseharenai, maisa atyo waiyexeharexenai naotyakisa maheta xini — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Haxowakiya João Batista xaotyakiraharenai, fariseunai xoaha manakairahitaha Enore hiyeta. Hoka haiyaharenai axa Jesus: — João xaotyakiraharenai exahe fariseunai xaotyakiraharenai xoaha maisa kanakairare Enore hiyeta. Xoana atyo hoka hiyaotyakiraharenai maisa nikare tehitiya tyaonare? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus nexa: — Xoana, wenakakoati xowakehena hoka ekaixakatyakaharenai manakairahare tyaonita xaowita? Kaiyanityohenereya enekoniha tyaonita hoka maisaiya manakairahare tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hoka haxowakaite kaiyanityohenere kaiyakeheta enekonitaha. Hoka hatyo xowaka atyoite manakairehenaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","— Maisa atyo katinolaharetyakehetere imiti xololo, imiti waitare taose mawane kakoa. Waitare taose mawaneya ityotyolisoahetehena hoka halalakaiya imiti xololo, aeroakotyaiya ehalalakoane — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","— Maisa atyo vinho waitarexa kaxomokakere toahiyere militirise nomaka ako. Nikareya kaxomokaka hoka halalakoaiya militirise hoka vinhoxaiya iratyoa tyotya, exaheya militirise hoka mawenekoare. Hatyo hiyeta vinho waitarexa militirise waitare ako taita kaxomokakita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sábado ferakene xowaka Jesus haxaotyakiraharenai kakoa tonahitaha hoka jiyakonihenahitaha trigo xafityaka hoka haetonaneta exaotyakiraharenae irikotyaha trigo xawase hoka ese kanakairaha. ");
INSERT INTO pabNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hatyaoseta fariseunae axehena Jesus: — Xoana hoka nikare hiyaotyakiraharenai tyaonita? Wiyaotyakisakaho sábado xowaka mahokoanititerehare tyomahitaha — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hoka Jesus nexa: — Xoana maisa xasemare Davi tahi akiti, manakairahare hoka nakehenere hahinaeharenae kakoa? ");
INSERT INTO pabNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Isoa Enore hanako. Exowaka Abiatar kaxaikota Enore hana. Isoa hoka kanakaira nakairati Enore ana fetatyakere, isa tehitiya hahinaeharenae ana hoka kanakairaha. Wiyaotyakisakaho hiyeta atyo maisa hatyatere kanakairita hatyo nakairati. Sacerdotenae anere taita atyo hatyo nakairati — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesus nehitiya: — Haliti hiyeta atyo Enore tyoma sábado. Maisa atyo sábado hiyeta xini tyoma haliti. ");
INSERT INTO pabNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nikare hoka Haliti Ityani atyo sábado ferakene xekohase — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Haxowakiya Jesus isoahitiya xahohisakoatyakalati hanako. Isoa hoka waiya hatya haliti hamaniya nirakahexe. ");
INSERT INTO pabNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hatyo nali haiyaharenai halitinai wahakotyahita Jesus ana, sábado xowakiyaiya wairatya hatyo haliti hoka iraeharetyahene aokowitaha emaxaiminirene xaotyakisatyaho hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hatyaoseta Jesus nexa mawaiyekahehare hiye: — Hisohena ali — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hatyaoseta axehena wahakoiterenai: — Xoare nexa sábado ferakene xaokaka wiyaotyakisakaho? Xoareya wisoma hatyo ferakene: waiyexe, iniyalahare kore? Xoana haliti wainihenerite wakahinaehena, wahalakihenene kore ite hoka wainihena? nexa ihiyeha. Nexa ihiyeha hoka mema tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mema tyaonaha hoka Jesus wahakotya enomanaha hoka eharehena, amaikoharehena xoaha, maisa semaxematyaha aokowiyeha iniraine hoka. Hatyaoseta Jesus nexa mawaiyekahehare hiye: — Haimahena hikahe — nexa ihiye. Nexa hoka aimatya hakahe hoka waiyeheta rotita ekahe. ");
INSERT INTO pabNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hatyaoseta fariseunai hikoahenahitaha hatyoakota hoka Herodes hiyetarenai kakoa iraekakoaha. Jesus tahi ahekotyaha aisahene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Hatyaoseta Jesus haxaotyakiraharenai kakoa xanehitiya Galiléia xa nali. Xanehitiya hoka kahare halitinai xaneha exema Galiléia koa yerenai, Judéia koa yerenai, ");
INSERT INTO pabNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalém yerenai, Iduméia koa yerenai, Jordão xa halakoiya maniya tarenai, wenakalati Sidom, Tiro xoaha maniya tarenai xoaha, kahare halitinai xaneha Jesus xema waiyahene maheta, semahitaha enómane tahi akiti hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hatyaoseta Jesus axikatya haxaotyakiraharenai tawaha kanowa enomana maheta, kasani maisa halitinai ehotyasekoatyahene aokita hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Koxaka kahare haliti aiyatelekiheta hoka hatyo hiyeta tyotya hokakiterenai kasani Jesus hiye hakahe hekoti ekaokakisa aokowiyahitaha hoka herawasetyakakoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tihanare kamilakoreraharenai waiya Jesus hoka exoaha ikiji haliya hoka kinatyaxa kawiyatyahitaha: — Hiso atyo Enore Ityani — nexahita ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nexahitaha hoka Jesus mahokoanitya nikare iniraineha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hatyo najikinita Jesus kakoha tyairi heno hoka kawihena aohenerenai haomana hoka tyoaha enomana. 12-hare ");
INSERT INTO pabNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","haliti aoka haomana ehaliya tyaonaha maheta, exahe hoka axikatyahene xakaihaha Iraiti Waiyexe maheta. Hatyo 12-hare iraiti kakoarenae aoka. ");
INSERT INTO pabNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Isatehitiya iyateliti enomanaha hokakiterenai aiyatelikiheta maheta, exahe tihanare kamilakoreraharenai nonita tihanarenai axanekihenahitaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hatyo 12-harenai atyo exenai: Simão nexarexe hoka Pedro nexare kaixarehenahitiyene. ");
INSERT INTO pabNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiago, João xoaha Zebedeu ityaninai hoka Boanerges nexare kaixarehenahitiyene, wiyako maniya atyo, “Onetalolo ityaninai”. ");
INSERT INTO pabNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André, Filipe, Bartolomeu, Mateus, Tomé, Alfeu ityani Tiago, Tadeu, Simão Cananeu, ");
INSERT INTO pabNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariotes xoaha. Hatyo Judas atyo Jesus matawatyasehare. ");
INSERT INTO pabNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hatyaoseta Jesus xaneheta hahana nali hoka kahare haliti hohisakoahitiya ehana nali hoka maisa aliyakere Jesus, exaotyakiraharenai kanakairareha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hatyaoseta Jesus hinaeharenai semaha etahi hoka xaneha enomana nolokahene maheta. Haiyaharenai ehatyaharene aokahitereha hiyeta xane nolokahene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Judeunai nawenatyakaho kakoa waiyoreterenai tyohenere Jerusalém ta nexahitaha exaokaka: — Kala Belzebu tihanarenai xekohase tyaonita ekakoa. Hatyohiyeta tihanarenai xekohasehare iyateliti ijita enomana hoka halitinai nonita tihanare axanekihitita — nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hoka Jesus kawisahene hoka aotyakihenahene hoka nehena: — Aliyakeriya Ahalakoahaliti hatyota axikatyoawihetehena xaokita? ");
INSERT INTO pabNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hiyaiya, hakoa waikoherakoa tyaoniterenai hatyo kakoaha makereya kirawanekakoaha hoka mehotyakakoahaiya. ");
INSERT INTO pabNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Exahiya hatya haliti kaiyanityore, kaisaniye tyaonitere hotyaliya kirawanekakoaha hoka maisaiya kinatere tyaonehenahititaha, exaoretyakakoahaiya. ");
INSERT INTO pabNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","— Nikareya Ahalakoahaliti hotyalinai: hatyo makere kirawanekakoaha hoka maisaiya aliyakere tyaohenahititaha hoka mehohaiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","— Hiyaiya, maisaiya xala hare haliti kinaterexe hanako ijoita hoka kaiwaharetitene, ameteniya olatene hotohare hoka kaiwaharetene, xoare xamani kolatya aokowita ehanakota hoka — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","— Xotyaira exe niraini, tyotya halitinai iniyalahare tyomitereharenai atyoite kamaotyanetyakeheta, exahe Enore kairaeharetyakiterehare tehitiya atyoite kamaotyanetyakeheta. ");
INSERT INTO pabNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Hoka xala xamaniya atyo iraeharetya Isekohaliti Waiyexe hoka maisaiya atyo kaxemaisatyakihitita hekoti. Hiyaiya, hatyo iniyalahare atyo maxemaisatyakahare — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nikare Jesus irae haiyaharenai tihanare kamilakoretiterene aokahitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hatyaoseta Jesus nityo iximarenenai harenai kaokaha hoka menanakita tyaonaha hoka ekawisaka aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kahare haliti tyokita ehaliya hoka haiyanai xane xakaini ihiye: — Hasemehena, hityo, hiximarenenai xoaha menanakita tyaonahitaha, tawahita hiso — nexaha Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","— Xala mama, xala noximalininai xaokita? nexa Jesus axahene. ");
INSERT INTO pabNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hatyaoseta wahakotahisa hahaliya tyokiterenai ana hoka nehena: — Xasemehena, owene atyo mama noximalininai xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xalanai xamaniya atyo tyakeko Enore niraine hoka tyaona exema hoka hatyonai atyo mama noximalini noximaloni — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Haxowakiya Jesus aotyakihitiya halitinai Galiléia xa haliya. Haliti kahare hohisakoahitiya ehaliya hoka xane tyoka kanowako one kilihi halitinai tyaonitere haliyaseta hoka hekotaha hatyo kaiholo kilihi. ");
INSERT INTO pabNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesus aotyakihenahene kahare xoalini hare kakoa hoka iraeti metaharexe kakoa taita aotyakihenahene hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","— Xasemehena: hatya haliti xane hahananeharese fitya maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Fitita hanakatise hoka haiyasenai exoa ahoti kilihi, hoka kotehalasenai exoa hoka tyotya kanakairehenahitene. ");
INSERT INTO pabNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Haiyasenai tehitiya sehali tyaonitere akiti exoa, inira waikohe tyaonitere akiti hoka haxeroreta hikoa. ");
INSERT INTO pabNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hatyaoseta kamai hikoahena hoka watere aisehetene, maisa hateko katyahareta hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Haiyasenai xane exoa katohere koni hoka katohere jiyahaotene hoka maisa kalita. ");
INSERT INTO pabNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Haiyasenai waikohe waiyexe akiti xane exoa. Hikoa, waiyehare tyaona, kahare kali. Haiyakate 30-se, 60-se, 100-se hare kaseha — nexa Jesus xakaihakatya ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","— Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hatyaoseta halitinai xaneheta hoka Jesus haliya hekotehenerenai hohisakoaha 12-hare exaotyakiraharenai kakoa hoka axehenahene: — Xoare hexa haokowita hanakatise tahi akiti? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hoka Jesus nehena: — Xomana atyo Enore metaharexe hakoamaniya nawenatyaka hotikijita. Hoka haiyaharenai ana atyoite metaharexe taita kaxakaihakatyakehena. ");
INSERT INTO pabNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hoka waiyehena hoka maisa waiyekehalakita enomanaha, exahe semehenaha hoka maisa waiyekehalakita enomanaha maheta. Hoka hatyo hiyeta maisa Enore tyakekoahitaha maheta, exahe maisa iniyalahare enómaneha kamaotyanetyakihitita maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hatyaoseta Jesus axehenahene: — Xoana maisa waiyekehalakita exe noxakaitere xihiye? Hoka aliyakere ite waiyekehalakehena xomana haiyanai noxakaitere? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hatyaoseta Jesus awaiyekehalakehena xakaihenere enomanaha: — Hatyo hanakatise xafityasehare atyo Enore niraene xakaisasehare. ");
INSERT INTO pabNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Haiyaharenai semehenereharenae Iraiti atyo hanakatise ahoti kilihi exoahenere akereta tyaonahita. Semaha taita iraiti hoka Ahalakoahaliti iyihititene rotita enonyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Haiyaharenai semehenerenae Iraiti atyo hanakatise xane sehalise tyaonitere akiti exoahenere akereta tyaonahita. Semehenaha hatyo Iraiti hoka awaiyetyahitene haihalahareneha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Xakore hoka maisa atyo waha tyaonare Iraiti Waiyexe xema, maisa katyaharexe hoka. Kirawanehenahene Iraiti Waiyexe hiyeta hoka haxerore halakihititere iraiti xema hawenane. ");
INSERT INTO pabNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hoka haiyaharenae atyo hanakatise katohere koni xane exoahenere akereta tyaonahitaha. Semahitaha xakore atyo iraiti ");
INSERT INTO pabNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","hoka háwenaneha akiti kakoa atyo ahekotyahitaha, kehalahaliti tahi, xiyehaliti harenai tahi atyo ahekotyahitaha, kasani xoalini hare tyomaha aokowihitaha hoka. Nikarehena hoka maisa aliyakere Iraiti Waiyexe xema tyaonareha hoka maisa xoare tyomareha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hoka haiyaharenae atyo waikohe waiyexe akiti exoahenere hanakatise akereta tyaonahita. Semaha Iraiti hoka awaiyetyahene hoka tyaonaha exema, hoka kahare tyomaha Enore ana, haiyakate 30-se, 60-se, 100-se kasetere akereta tyaonahitaha — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hatyaoseta Jesus nihitiya ihiyeha: — Xoana, xaokanatyakalati xaotakahena hoka koho katyahe, kama katyahe xamokita? Maiha atyo nikarexe xini. Exomokakaose terota atyo wamokitene, waiye aokanakatya maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","— Hiyaiya, tyotya kaxateroakisakitere harenai atyoite kawaiyaka, exahe tyotya masemakahare tyaonitereharenai atyoite kasemaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","— Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hatyaoseta nehitiya ihiyeha: — Xirihalira xisaona xoalini hare xasemehena hoka. Hiyaiya, aliyakerexe xamaniya xamoka haiyaharenai hoka hatyo xamohenerene akeretaiya atyo Enore moka xiso. Hoka hatyo xaheharite mohitiyata xiso. ");
INSERT INTO pabNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","— Xala xamani atyoite xoalini hare kakoare hoka kaxekakehitiyaite enomana hoka xala xamani atyoite maisa xoare kakoare hoka inira tyaohenere enomana atyoite kaiyakeheta enonita — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","— Enore koamaniya nawenatyakaho atyo exakerexe: motya atyo hatya haliti hamasenekoa fititerehare hanakatise akereta. ");
INSERT INTO pabNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hoka hatyaoseta xane nemaka, kaosehena hoka exafera hikoa, kekoare hoka mawaiyekehalakiterehare ekekoarene enomana akereta atyo. ");
INSERT INTO pabNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Waikohe atyo hatyota akekoarenekijitene. Hetati hikoahenere xowaka kirane tyaonita, hatyaoseta kaenaseta, hatyaoseta kaséta. ");
INSERT INTO pabNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hatyaoseta nirehena hoka kataikore kakoa irikotitene, ixirikotyakaose xane hikoa hoka — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus nehitiya: — Xoare kakoa hakakoa Enore koamaniya nawenatyaka akiti? Aliyakereya noxakaini xihiye hoka waiyekehalaka xomana? ");
INSERT INTO pabNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","— Hanakatise kiranexe mostardase akerehare atyo Enore koamaniya nawenatyaka akiti. Tyotya hanakatise katyahakorese atyo hatyo mostarda se. ");
INSERT INTO pabNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kiranese xakore hoka hafeteniya hoka hikoa kekoareya hoka tyotya hananehaliti xahehareya tyaona. Kahareya kakanohikoa hoka kotehalasenaiya haihe tyoma ekate — nexa Jesus xakaita ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Exakere Jesus iraeta halitinai kakoa. Xakaihena hoka aimenekoita taita, xoalini hare kakoa. Kasani nikare xakai ihiyeha hoka waiyekehalaka enomanaha aokita hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nikare xakaihena hoka aimenekoita taita halitinai ana. Hoka hawawaha heko atyo haxaotyakiraharenai ana awaiyekehalakahititene. ");
INSERT INTO pabNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hatyo ferakene makehena hoka Jesus nexa haxaotyakiraharenai hiye: — Wiyala Galiléia xa halakoiya maniya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hatyaoseta halitinai axikahenahitaha. Hatyaoseta kanowa ako Jesus haxaotyakiraharenai kakoa xane. Koxaka Jesus enahititaha hatyo kanowa ako tyaonita. Hatyaoseta haiyanai kanowa tehitiya xane exemaha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nekesexehena xanahitaha hoka hoholati kaoka enomanaha. Hoholasekoatyahene, one ainakiyatya hoka kalorehena kanowa ako ijoita. ");
INSERT INTO pabNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus nemakita kanowa tyokolyako maniya, haseri kahainatya hoka. Hatyaoseta exaotyakiraharenai kaosetene. — Hikaosehena! Wiwainihenaoreka! Xoana maisa kore himawaiyeharexe wikamane kakoa? nexaha kaosetyahene. ");
INSERT INTO pabNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hatyaoseta Jesus kaose hoka tityoaheta hoka watyali hoholati one ainakiyatitere. — Mema xisaona — nexa. Nexa hoka mahohoreheta, memaxeheta one, mema akeheta. ");
INSERT INTO pabNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hatyaoseta haxaotyakiraharenai hiye nexa: — Xoana hoka ximairita? Xoana hoka maisa xityakekore? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hatyaoseta exaotyakiraharenai kalore mairaha hoka iraikakoahenaha: — Xoare halitini ala exe hoka one, hoholati xoaha hiye irae hoka aokitere akereta tyaonaha? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hatyaoseta xane kaokaha Gerasa nali, Galiléia xa halakoiya maniya. ");
INSERT INTO pabNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Exoa taita kanowakota hoka hatya haliti kawaiyaneharexe atihotene. ");
INSERT INTO pabNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Xawatyakalatinai nalita tyoita, hatyo nali tyaonita. Maisaiya aliyakere xala harenai olatitene, mahaiya kamatiherahi kakoa hekoti holatitene. ");
INSERT INTO pabNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kamatiherahi kakoa olatyahitene kahaliki ekano, ikinoli hare hiye, xakore hoka irikokoaitatene. Maisaiya xala harenai jiyahaowitene. ");
INSERT INTO pabNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tyairinai koni exahe xawatyakalatinai koni tyaonita. Wáhaka makiya, ferakoa xoaha tonakoaita, kawikoaita, sehali hiye kawe mokoita xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesus kanowa akota exoa taita hoka sekota waiyene hoka tema xane enomana. Hoka hakaolise kakoa xane meholokoa enahalakoa, Jesus atyo exahehare hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","— Jesus, Enore Kalorexe Ityani, xoare haoka nohiye? Enore nexare kakoa nirai hikakoa, awaira atyo iniyalahare hamohena natyo — nexa kinatyaxa irae. ");
INSERT INTO pabNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesus koxaka hatyo nahitita nexa: — Tihanare, hahikoahetehenaira exe haliti nonitata — nexa. Hoka hatyo hiyeta nikare iraeta Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hatyaoseta Jesus axene: — Xoare nexare hiso? nexa axene. — Nexare atyo Hisoakere, wikahare hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hatyaoseta Jesus hiye maisa tihanarenai xaxikatyakeheta hatyo nalita hakiti xeta aokita. ");
INSERT INTO pabNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Exowaka kahare bolokonai nali tyaonita, kanakairakoatyahita tyairi henose ");
INSERT INTO pabNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","hoka Jesus hiye irae tihanarenai: — Haxikahena wiso hoka wisoa bolokonai milako — nexaha Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hatyaoseta tihanarenai axikaheta haliti nonitata hoka xane bolokonai milako isoaha hoka bolokonai tema tyairi henota, xane onexa exoaha hoka monaha hoka wainiha. Hatyo bolokonai komitaene 2.000-li. ");
INSERT INTO pabNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hatyaoseta bolokonai kaxaikotyasenai tekoaheta nalita hoka xane xakaikoatyaha hatyo tahi akiti wenakalati, exahe hatyo wenakalati haliyita tyaoniterenai hiye. Hoka kahareha xaneha hatyo nali waiyaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus tyaonitere nali xane kaokaha hoka waiyehenaha atyo, owene atyo haliti hatyaharetere tyokita, kaimere tyaonita, waiyeheta atyo exahekola. Waiyahene hoka mairaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hatyaoseta koxaka waiyehenerenenai xakaihakatya ihiyeha haliti, exahe bolokonai xoaha tahi akiti ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hatyaoseta kasani Jesus xaneheta ewaikoherataha aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hatyaoseta Jesus xane kakohahetehena kanowa ako hoka haliti tihanare ehatyahalinikihenere awaiyehetehenere iraehena ihiye: — Waiyehenaiya notyoa hiyema? nexa axene. ");
INSERT INTO pabNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Maisa exema xane aokita Jesus hoka nexa ihiye: — Hiyanehetehena hihana nali hoka hihinaeharenai hiye hiyakaihena Xekohaseti awaiyehetehenere hiso tahi akiti. Exahe airakoaneharehenere hiso tahi akiti — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nexa ihiye hoka xaneheta hoka xakaihakatya Decapolis naliyerenai hiye Jesus tyomehenerehare enomana tahi. Hoka tyotyaha hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hatyaoseta Jesus haikoaheta hatyo nalita halakoiya maniya hoka kahare haliti xane ahalakoatene kaiholokoa nali. ");
INSERT INTO pabNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hatyaoseta hatya haliti Jairo nexarexe, xahohisakoatyakalati hana kaxaikotyasehare tyoa Jesus ana kaoka hoka ikiji haliya meholokoa. ");
INSERT INTO pabNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","— Nityani ohiro mokose wainihena. Hisohena hoka hikahe hekaokakisa ihiye hoka kinatoloheta hoka maisa wainita — nexa axa Jesus tihityoa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nexa hoka Jesus xane exema. Kahare haliti tehitiya xane exema hoka ehotyasetyakakoaha xanahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hatyaoseta hatya ohiro xane kaoka halitinai koni. 12-terehokoanehena timalati hikoata minita ihiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kahaliki wairatyarenai ana xane hoka exahehare ewaolitihalokisahitene. Koxaka haoloxa miyatya wairatyarenai hiye. Xakore hoka maisa waiyehetolo hekoti hoka aerorityoitata ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sema Jesus tahi hoka xane halitinai koni hoka Jesus hiniri maniyata ekaokakisa hakahe inima hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Exakere ahekoita: — Nekaokakisa taitaiya nokahe inima hiye hoka nokinatoloheta — nita hoka ");
INSERT INTO pabNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","hakahe ekaokakisa inima hiye taita hoka waiyeheta. Hoka kehexa hahiyeta timalati tyoteneheta. ");
INSERT INTO pabNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hatyaoseta Jesus kehexa rotita iyateliti hikoahenere ihiyeta hoka terehokoa wahakotya halitinai ana hoka nehena: — Xala hakahe ekaokakisa nimi hiye? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Hoka exaotyakiraharenai nehena: — Hiyaiya, kahare haliti ehotyasekoaita hiso. Hoka xoana hoka nikare haxita? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hoka Jesus wahakohokotyoitata, kasani waiya aokowita inima hiye hakahe ekaokakihenere hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hatyaoseta hatyo ohiro tyoa Jesus kiji haliya meholokoa, tatakoa hamairane, otya haxaiyatolokisakeheta hoka. Hatyaoseta tyotya xakai Jesus hiye hahokakene tahi. ");
INSERT INTO pabNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hatyaoseta Jesus nexa: — Hityakeko natyo hoka hikinatoloheta. Awa atyo himawaiyehalo, hikinatoloheta atyo. Hiyanehetehena himehexaikohalone kakoa — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iraetata ene hatyo ohiro kakoa hoka xahohisakoatyakalati hana kaxaikotyasehare Jairo wakaneharenai kaokaha hoka nexaha ihiye: — Koxakatya hityani waini. Kotare Xekohaseti matyoanenehare hihana nali, waiya aliya hoka kirahare haetonane hiyeta — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus sema hatyo iraiti hoka nexa Jairo hiye: — Awaira atyo himawaiyeharehena. Hityakekohena taitaira natyo — nexa Jairo hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hatyaoseta xaneha Jairo hana xeta. Pedro, haximarene kakoarenae Tiago, João xoaha xane exema aoka. Maisa hatehitiya aokita. ");
INSERT INTO pabNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hatyaoseta xane kaokaha Jairo hana nali hoka isoaha. Waiyehena atyo werahaliti, osexati hare. Kahare tiyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hoka nehena: — Xoana hoka kalore xitiyita, exahe nikare xisaonita? Xoimahalotita maisa waini xinika, nemakitata — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hatyaoseta ehatyaharene aokitaha hoka Jesus aihikoahenahitene. Hatyaoseta enexe, inityo, hanamahare xanehenere exema xoaha taita isoa hatyo xoimahaloti tyaonitere ako. ");
INSERT INTO pabNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Isoa hoka otokene ekahe hiye hoka nehena: — Talita cumi! nexa. Exakere atyo iraeta: — Xoimahaloti, hainakoahetehena! nita atyo. ");
INSERT INTO pabNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nexa ihiye hoka ainakoaheta, tohetehena rotita, xoimahaloti 12-wanone henolo hoka. Hatyaoseta tyotya hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hatyaoseta Jesus hatyohare maxakaikoatyakene aoka ihiyeha. Hatyaoseta xoimahaloti tyaisaka aoka ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hatyaoseta Jesus haikoaheta haxaotyakiraharenai kakoa wenakalati Nazaré xeta, toahiya tyaonitere nali. ");
INSERT INTO pabNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hoka sábado ferakenehena hoka xane xahohisakoatyakalati hanako hoka aotyakihena halitinai. Semaha Jesus niraene hoka hakaharetyoa mokahene hoka axakakoaha: — Aliyotala enawaiyore tyoita enomana? Aliyetala exe haliti waiyore tyoita exakere? Aliyakere ala tyomita exehare maomakaharenai? ");
INSERT INTO pabNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Xoana, maisa hoka okahakalati hati hare nomasehare xini? Xoana maisa hoka Maria ityani xini, exahe Tiago, José, Judas, Simão xoaha naxenane xini? Xoana, maisa hoka iximalonenai xini ali tyaonita? nexaha, maisa awaiyetyareha Jesus hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hoka Jesus nexa ihiyeha: — Iraiti xakaisasehare atyo kaxaiminisakita hakoakiti. Xakore atyo hoka kaokehetehena atyo hawaikohera hawenakala, hahinaeharenai koni hoka maisa kaxaiminisakere — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hatyo hiyeta maisaiya aliyakere xoare hare metaharexe nomakere tyomita Nazaré nali. Haiyanai hokakiterenai hiye taita hakahe ekaokakisa hoka aiyatelikihenahititene. ");
INSERT INTO pabNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus atyo hakaharetyoa ematyakekoneha hiyeta. Hatyaoseta Jesus xaneta wenakalatinai nihatyaka hoka aotyakisahitene. ");
INSERT INTO pabNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hatyaoseta 12-hare haxaotyakiraharenai kawisa, hoka hinamahare xakini axikatyahene. Iyateliti isa enomanaha axanikihetaha isekohaliti iniyalahare halitinai nonitata maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Maisa xoare hare kolatyaka aokita ihiyeha ahoti niyahare. Atyakase taita kolatyaka aoka ihiyeha tonohisoaha maheta. Maisa nakairati, boná, olo hare kolatyaka aokita ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Berekataiya atyo waiyehena mokaha hoka maisaiya atyo xoare maheta hate hekoti kajiyanexe imitinase kolatyahitaha aoka ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hoka nehitiya: — Maika xikaokehena wenakalati hoka hali hatyakota xisaona xiyanenehitiya hatyo nalita kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maika wenakalati xikaokehena hoka maisa waiye mokahitaha xiso, exahe naliyerenai maisa semaha aokowiyahita xiraene hoka maika nalita xiyanehitiya hoka xiberekatane xamokotyahatya xexoakiheta maheta waikohese emaxawaiyereneha xiso hiyeta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hatyaoseta exaotyakiraharenai xaneha iraeti xakaiha halitinai hiye maheta, halitinai iniyalahare hawenaneha halakisaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kahare axanikihenahititaha isekohaliti iniyalahare halitinai nonita, exahe kolotenitiya mohenaha hokakiterenai seri hiye hoka aiyatelikihenahititene. ");
INSERT INTO pabNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tyotya hatyoharenai tahi xekohaseti Herodes sema hakakoare halitinai xakaikoatyahitere Jesus tahi hiyeta. Haiyaharenai nita: — Kala João Batista kaseheta. Hatyo hiyeta xoalini hare metaharexe nomakere tyomita — nexahitaha exaokaka. ");
INSERT INTO pabNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Haiyanai atyo: — Kala Elias — nita. Haiyanai tehitiya: — Kala iraiti xakaisasehare terota, toahiyereharenai akerexe — nexahitaha Jesus xaokaka. ");
INSERT INTO pabNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes sema hatyoharenai tahi hoka nexa: — Kala João Batista. Iseri xirikotyaka naoka hoka kalikini ala kaseheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","João Batista kamane nahitita Herodes niraene xema João otokaha, olatyahene, berexo ako jihotyahene Herodias xemere. Hatyo nahitita Herodes tyaonita hatyo ohiro kakoa, iximarene Filipe exanityo xakore hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hatyo hiyeta João Batista watyali Herodes: — Awa atyo hiximarene exanityo kakoa hisaona, Xaotyakiyaho atyo mahokoanetita hiximarene exanityo kakoa hawenane. ");
INSERT INTO pabNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hatyo hiyeta Herodias kirawaneta João, kasani aisene aokowita. Xakore hoka maisaiya aliyakere aijitene, ");
INSERT INTO pabNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","enenala Herodes mairitene exahe haliti waiyexe aokitene. Hatyo hiyeta Herodes waiye kaxaikotene. Semehena iniraene hoka waiyeta ihiye, xakore hoka maisa aliyakere ahekotya xaka mokene. Xakore hoka iraehena hoka awaiyetita iniraene. ");
INSERT INTO pabNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hoka Herodias atyo atyahita terota João kamane ferakene. Hatyaoseta xane hikoa enenala Herodes nawenane ferakene hoka hahisehare tyoma. Kalore nakairati tyoma, oloniti harenai hoka kaixakatya xekohasetinai taita, Galiléia koa tarenai, sorare xekohasenai harenai hoka tyoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hatyaoseta Herodias ityani xoimahaloti isoa hatyo nali hoka holikoahena. Herodes, ekaixakalaharenai xoaha awaiyetyaha exoholikoane hoka hatyo hiyeta xekohaseti Herodes nexa xoimahaloti hiye: — Xoare xamani haoka hiyoholikoane xaimane hoka niseniya homana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","— Exahiya kalore haoka hoka niseniya homana. Alitere naokita, maisa namaoseraita xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nexa ihiye hoka hikoaheta xane hanityo axa maheta, xoare xamani haxoholikoane xaimane axa aohena hoka. Hoka inityo nexa: — João Batista seri haxene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hatyaoseta kaholawaka haikoaheta Herodes tyaonitere nali hoka axene: — Xama João Batista seri hisehena nomani balatoahekoa kalikinita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes sema hatyo hoka amaikohare. Xakore hoka koxaka tyotya haliti haoti irae hoka hatyo hiyeta maisa aliyakere matyakekotita xoimahaloti xaxane. ");
INSERT INTO pabNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hoka axikatya rota sorare, João Batista seri kolatya maheta. Hatyaoseta sorare xane berexo ako hoka irikotya João seri. ");
INSERT INTO pabNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mokene balatoahekoa hoka isene xoimahaloti ana. Hatyaoseta hatyo xoimahaloti xane isene hanityo ana. ");
INSERT INTO pabNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hatyaoseta João Batista xaotyakiraharenai sema etahi hoka tyoa kolahenahitene hoka fityahene. ");
INSERT INTO pabNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hatyaoseta Jesus xaotyakiraharenai kaokeheta enomana hoka xakaihakahenaha Jesus hiye tyotya tyomehenereharenaiha, aotyakihenahereha harenai tahi. ");
INSERT INTO pabNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nali kahare haliti kaokehitita, xanehitita xoaha hoka Jesus, exaotyakiraharenai xoaha komita ene maisa aliyakere kanakairareha hekoti. Hoka Jesus nehena ihiyeha: — Xisohena hoka wiyane wiwawa maharexakahare hoka inira xikawini — nexa haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hatyaoseta xaneha hawawaha kanowa ako maharexakahare. ");
INSERT INTO pabNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Xakore hoka halitinai waiyaxematyahene hoka otyahene hoka tyotya hatyo nalitarenai tema xaneha one kilihi hoka enahityahitaha xane kaokaha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hatyaoseta Jesus xane kaoka hatyo nali hoka exoahena kanowa akota hoka waiya hatyo halitinai hoka airakoaneharetyahene. Motya kalanero makaxaikotyakahare akere tyaonahitaha hoka kahare xoalini hare aotyakihenahene. ");
INSERT INTO pabNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Waikoa kamaitehena hoka Jesus xaotyakiraharenai xane iraehena ekakoa. — Okoi makehena, maisa ali xoare aka. ");
INSERT INTO pabNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Haxikahetehena exe halitinai hoka xanehenahitaha wenakalatinai kaharewaikatexe akiti nali hoka xoalini hare iyaha hoka kanakairaha — nexaha Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Xakore hoka Jesus nexa: — Xisota xisehena nakairati enomanaha. — Xoana wiyane 200-hokose olo kakoa wiya nakairati enomanaha haokita? nexaha Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","— Xoanama tohase nakairati xinali? xiyane xiyaiya — nexa. Xane waiyaha hoka: — 5-tohase nakairati, hinama kohase xoaha taita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hatyaoseta Jesus nehena halitinai hiye: — Xisokehena hahotyali xakini ime koa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hoka hatyaoseta hahotyali xakini xane tyokaha. Haiya hotyalinai 100-hare, haiya hotyalinai 50-hare xakini tyokaha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hatyaoseta Jesus otoka 5-tohase nakairati, hinama kohase xoaha hoka enokoa xeta wahakotya hoka iraexatya Enore hiye: — Ehekore nakairati hisa womana, Abá — nexa. Hatyaoseta irikosetene hoka isene haxaotyakiraharenai ana, hoka hatyo exaotyakiraharenai irakene halitinai ana. Kohase nikareta iraka tyotya halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tyotya kanakairaha hoka fakatehareha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hatyaoseta awaiyehotyalikihetaha halitinai nakaira mawane hoka 12-te koho kaisero mohenahitaha nakairati, kohase xoaha mawane. ");
INSERT INTO pabNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hatyo nakairati kanakairahenerenai 5.000-hare halitinai. ");
INSERT INTO pabNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hatyo najikinita Jesus haxaotyakiraharenai kakoa irai hoka kakohahenahitaha kanowako hoka xanehenahitaha enaheta maheta halakoiya Betsaida nali xeta. Hoka hatyo nase Jesus jinaheta halitinai. ");
INSERT INTO pabNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hatyaoseta jinaheta halitinai hoka xane tyairi heno iraexatya maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","One nekesexehena exaotyakiraharenai xaneta hoka makehena ihiyeha. Hoka exowaka Jesus hekota waikohekoa hawawaharenai tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hatyaoseta waiya haxaotyakiraharenai xaeremola howitiharene hoholati hoholasekoatyahiterene hiyeta, xanehenahititere maniyata hoholatita hoka. Hatyaoseta okoi ferakoahena hoka Jesus xane hikoaheta enomanaha, tonita one heno. Okoi jiyahene hoka ");
INSERT INTO pabNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","hatyaoseta Jesus netonane one heno waiyaha hoka motya isekohaliti aokahitene hoka hamairaneha kawiyatyaha. ");
INSERT INTO pabNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tyotya waiyahene hoka kalore mairaha. Hoka Jesus nexa ihiyeha: — Awa atyo ximaira! Natyo ta, awa ximaira natyo — nexa ihiyeha, ");
INSERT INTO pabNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","hoka xane kanowa ako kakohaheta enaliha. Hatyaoseta hoholati amematyoaheta. Hoka exaotyakiraharenai mairaha, hakaharetyoaha. — Xoanere kaisere? nexa mokahitene. ");
INSERT INTO pabNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Maisa otehenahititaha halitinai tyaihenere nakairati kakoa, maisa waiye ahekohenahititaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hatyaoseta Jesus, exaotyakiraharenai harenai imahotyoaha Galiléia xa. Hoka xane takoaha kaiholokoa Genesaré waikoherakoa nali hoka katilikaha hakanowane hatyo nali. ");
INSERT INTO pabNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kanowa akota exoaha taita hoka Jesus waiyekehalakahare rotita hatyo naliyerenai ana hoka ");
INSERT INTO pabNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","hatyaoseta tyotya wenakalati xaneha hahinaehare hokakiterenai kolatyaha enomana maheta. Hatyaoseta hokakiterenai exehokotyoakalaha kakoita kolatyaha, exahe aliyo xamani Jesus xanehena hoka semehenahene hoka hatyo nali kolatyahitaha hokakiterenai enomana. ");
INSERT INTO pabNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Exahe wenakalati kiranexe hare koa kaokehena hoka koxaka hokakitinai mokahitaha enaheta hoka axahitene, kasani inima kilihi hiye hekoti ekaokakisaha hakaheha aokowiyahitaha. Hoka tyotya hakaheha ekaokakihenerenai inima kilihi hiye kinaterehitita. ");
INSERT INTO pabNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hatyaoseta haiyaharenai fariseunai, haiyanai judeunai xaotyakiraho kakoa waiyoreterenai Jerusalém nalita kaokehenerenai Jesus haliya hohisakoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hoka waiyaha Jesus xaotyakiraharenai haiyaxa kahitita kanakairehenahere. Matihahisoanehareta kanakairaha, maisa fariseunai aokitere akereta xini tyaonahitaha. Hoka maisa waiyeta ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Judeunai exahe fariseunai atyo hahetako maniyereharenai xaotyakiraho xema tyaonahitaha, waiye atyo tihahisoaha hotohare hoka kanakairahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Xiyehaliti hanakota atyo iyehenaha nakairati hoka tihahene hotohare atyo hoka kanakairahitene. Haiyaharenai xaotyakisatyaho xema tehitiya tyaonahitaha hoka tihahitaha kanote, matalo, tinihaliti harenai. ");
INSERT INTO pabNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hatyaoseta fariseunai, judeunai xaotyakiraho kakoa waiyoreterenai axehena Jesus: — Xoana hoka hiyaotyakiraharenai maisa tyaonareha wahetakomaniyereharenai xaotyakiraho xema hoka matihahisoanehareta kanakairahitaha? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hoka Jesus ekoaxatya enomanaha: — Maoseratyaliyenai! aliterexe nika Isaías xairatya xitahi akiti exakerexe: Exe halitinai atyo waiye iraetaha notahi, nita Enore. Xakore hoka exahekolaha atyo maisa nokoamaniye xini tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hoka maisa atyo tyaonahitaha nokoamaniye kaisere. Hiyaiya, halitinai xaotyakira kakoa atyo aotyakisahitaha hoka Enore xaotyakiraho aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Hoka Jesus nehitiya: — Xiso atyo xahalakijita Enore xaotyakiraho hoka halitinai xaotyakiraho xema xisaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","— Xiso atyo xawaiyore xahalakijita Enore xaotyakiraho. Hoka toahiyere xawenanaho xema taita xisaonita. ");
INSERT INTO pabNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hiyaiya, exakere Moisés nexa: Waiyira xaiminihena xexe, xityo hoka. Nexa tehitiya: Xala xamaniya atyo hanexe, hanityo iraeharetya hoka waiye xaisaka, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","— Hoka xiso atyo xita, “Xala xamaniya atyo kaoloxere hoka hanityo, hanexe kahinaetya maheta ene hoka Enore anaiya isa hatyo haoloxa hoka hatyo najikinitaiya atyo maisa aliyakere ");
INSERT INTO pabNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kahinaehitita hanityo, hanexe xoaha hoka ehekoreya”, xita atyo. ");
INSERT INTO pabNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nikare atyo xisaohena hoka maisa atyo Enore xaotyakiraho xema xini xisaonita. Hoka toahiyere xawenanaho xema atyo xisaonita hoka xahetakomaniyereharenai tyaonitere akereta xisaonita. Hoka nikarehare kahare xoalini hare xisomita. ");
INSERT INTO pabNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hatyaoseta Jesus kawihitiya halitinai hoka nehena: — Waiyira xasema xityotya exe niraetereharenai hoka waiyekehalaka xomana. ");
INSERT INTO pabNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Xoalini hareya hatya haliti hiye isoa hoka hatyoiya atyo maisa aiyalaharetita enawenane. Hoka xoalini hare atyo hikoahetehena hatya haliti hiyeta hoka hatyohare atyo aiyalaharetita enawenane — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","— Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hatyaoseta Jesus halakisa halitinai hoka isoa hatyako. Hatyaoseta exaotyakiraharenai axene hatyo haxaimenekola kakoa xakaihakahenere tahi. ");
INSERT INTO pabNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hoka nexa: — Xoana haiyaharenai akereta tehitiya maisa waiyekehalakita xomana? Hatyo isoahenere haliti kanasakoiya atyo maisa aiyalaharetita enawenane. ");
INSERT INTO pabNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hiyaiya, atyohenene atyo hoka maisa atyo exahekola hiye xini xaneta, enajako atyo xaneta. Hatyo najikinita atyo eháre hiyeta hikoahitita — nexa. Nikare Jesus iraeta hoka tyotya nakairati kakanakairatyakere aoka. ");
INSERT INTO pabNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hoka nehitiya: — Xoalini hare hikoahititerehare hatya hiyeta atyo aiyalaharetita enawenane. ");
INSERT INTO pabNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Hiyaiya, mahiyaseti hiyeta atyo iniyalahare xahekotyati tyoita hoka kaomakita kaiwati, xaisati, ");
INSERT INTO pabNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ohiro watyalisaka, xiyehaliti maiyasetyaka, irawaniti, maoseratyati, otokitaterehare, okoawahaliti, iraeharetyati, xahenityati, mawaiye xahekotyati harenai. ");
INSERT INTO pabNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tyotya hatyoharenai atyo mahiyaseti hiyeta hikoita hoka aiyalaharetita halitinai nawenane — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hatyaoseta Jesus xaneheta hatyo nalita, xane wenakalatinai Tiro, Sidom xoaha nali. Xane kaoka hoka isoa hatyako. Kasani maisa xala hare ekaokene sema aokare xakore hoka maisaiya aliyakere masemakita. ");
INSERT INTO pabNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Hatya ohiro ityani isekohaliti iniyalahare ehatyahalokijita hoka sema Jesus kaokene tahi hoka tyoa enomana hoka enahalakoa hakaolise kakoa meholokoa. ");
INSERT INTO pabNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Hatyo ohiro atyo hakoakitiyolo, sirofenícia yolo atyo. Hoka axene, kasani isekohaliti iniyalahare axikaheta ityani nonitata aoka ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hoka Jesus nexa ihiye: — Kotare xoimanai hotohare kanakaira. Hiyaiya, maisaiya atyo ehekoreta xini xoimanai nonitata kaiyakeheta nakairati hoka haxawatene kajolonai ana hoka — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","— Alitere haokita, Xekohaseti — nexa hatyo ohiro. — Hoka kajolonai atyo kanakairita xoimanai nakaira holoxo exoahena mexakoata hoka — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","— Hekoaxahenere nomani hiyeta hiyanehetehena hihana nali. Koxaka hityani nonitata isekohaliti iniyalahare kikisoaheta — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hatyaoseta hatyo ohiro xane kaokeheta hahana nali hoka waiyehena atyo, ityani atyo ehokotyoita haxehokotyoakala koa. Koxaka atyo isekohaliti iniyalahare kikisoaheta enonitata. ");
INSERT INTO pabNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hatyaoseta Jesus xaneheta wenakalati Tirota hoka jiyeheta Sidom, Decapolis xoaha nali hoka xane kaokeheta Galiléia xa nali. ");
INSERT INTO pabNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hatyaoseta haiyaharenai kolatya hatya haliti masemakalahare exahe komita ene maisa iraexe. Hoka axaha Jesus, ekaokakisa hakahe ihiye maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hatyaoseta Jesus nolokene haware halitinai nonita. Hoka hakahihi etanakoako moka. Hatyo najikinita xatahotya hoka ininise hiye xolotene. ");
INSERT INTO pabNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hatyaoseta wahakotya enokoa, kalore iyawinisoa hoka nehena: — Efatá! nexa. Exakere atyo nita: “Hamajiholatyoahetehena!” nita atyo. ");
INSERT INTO pabNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hatyaoseta hatyo haliti masemakalahare tanakoako waiyeheta. Exahe ininise tehitiya waiyeheta hoka waiye iraeheta. ");
INSERT INTO pabNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hatyaoseta Jesus mahokoanetya exakainiha hatyoharenai. Nikare iraehena ihiyeha hoka exahehare xane xakaikoatyahitaha hatyoharenai tahi. ");
INSERT INTO pabNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hoka haiyaharenai semehena hatyoharenai tahi hoka hakaharetyoahitaha hoka nexahitaha: — Kaxiyani, waiye kaiserehare tyomita! Hiyaiya, masemakalaharenai asemakihitita, mairaeneharenai hoka airainikihitita — nexahita. ");
INSERT INTO pabNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hatyaoseta haxowakiya hohisakoa halitinai Jesus tyaonitere nali. Hatyaoseta maisa xoare kanakaireheta xaka hoka Jesus kawisa haxaotyakiraharenai hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","— Nairakoaneharitita exe halitinai. Hiyaiya, hanamaki ferakenehena tyaonahitaha nohaliye hoka kalikini maisa xoare kanakairareha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naxikahenahiteniya matyaisakaharahitaha enawenakalanaiha xeta hoka exoahaiya ahotyaho hanakaha hiyeta. Hiyaiya, haiyaharenai atyo sekota tyoita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hatyaoseta exaotyakiraharenai axahene: — Hoka aliyakereya exe maharexakahareta wikaokehena nakairati hoka watyaihena exe halitinai haoka? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","— Xoanama tohase nakairati xinali? nexa axahene. — 7-tohase — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hatyaoseta Jesus halitinai kakoa irae waikoa tyokaha maheta. Hatyaoseta iya hatyo 7-tohase nakairati hoka iraexatya Enore hiye: — Ehekore nakairati hisa womana, Abá — nexa. Hatyaoseta taikasetene hoka haxaotyakiraharenai ana isene hoka irakene halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Haiyaharenai kohase tehitiya enaliha hoka Jesus iraexatya Enore hiye: — Ehekore nakairati hisa womana, Abá — nexa hoka hatyaoseta wakatya haxaotyakiraharenai hoka irakene halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tyotyaha kanakairaha, fakatehareha. Hatyaoseta kaise exaotyakiraharenai enakairaha mawaneha 7-te kohokiji kaisehenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hatyo kanakairehenerenai atyo 4.000-hare haliti. Hatyaoseta Jesus axikaheta hatyo halitinai. ");
INSERT INTO pabNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hatyaoseta kanowa ako xaneheta haxaotyakiraharenai kakoa Dalmanuta koa maniya. ");
INSERT INTO pabNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xane kaoka taita hatyo nali hoka fariseunai kaoka enomana hoka iraehenaha ekakoa, hasakaharetyahene aokowiyahitaha hoka xoalini hare nomaka aokaha ihiye hoka waiyaha maheta, xoana aliterexe xamani Enore nalita tyoita iniyatere, maisa xamani. ");
INSERT INTO pabNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hatyaoseta kalore iyawinisoa hoka nehena: — Xoare mahetala xoalini hare nomaka aokita exe halitinai tyakekoha maheta? Aliterexe nomita xihiye, maisaiya xoare hare notyomita exe halitinai ana tyakekoha maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hatyaoseta Jesus xaneheta. Kanowa ako kakohaheta hoka haikoaheta one halakoiya maniya. ");
INSERT INTO pabNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xanehenaha hoka exaotyakiraharenai maotyaneha nakairati hakolalaha hoka hatita taita kolatyaha kanowa ako. ");
INSERT INTO pabNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hatyaoseta Jesus iraehena ekakoaha hoka nehena: — Xasemehena, xirihalira fariseunai, Herodes xoaha kaoretyakala kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Hatyaoseta hatyo kakoaha irae kakoahenaha hoka nehenaha: — Exakere irae kala maisa nakairati wakolatita hoka — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hoka Jesus sema iniraekakoaneha hoka axehenahene: — Xoana hoka ximakolalaharene nakairati tahi xiraekakoita? Xoana maisa xawaiyorexe, exahe maisa waiyekehalakere niraini xomana? Xoana hoka ximawaiye xahekolere hoka maisa waiyekehalakere exeharenai xomana? ");
INSERT INTO pabNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Xoana hoka xikaxosexe xakore hoka maisa xiyaiyare? Xikatanakoakore xakore hoka maisa xasemare? ");
INSERT INTO pabNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xoana, maisa xotyare 5-tohase nakairati nirahenere 5.000-hare halitinai ana? Xoanamate koho kaisero exowaka emawane ximexeheta? nexa Jesus axahene. — 12-te kaisero — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hatyaoseta Jesus axehenahitiyene: — Hoka 7-tohase nakairati nirahenere 4.000-hare halitinai ana xowaka, xoanamate koho kaisero ximexeheta? — 7-te kaisero wimexeheta — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","— Xoana, hekota maisa waiyekehalakere niraini xomana? nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hatyaoseta Jesus xane kaoka wenakalati Betsaida nali haxaotyakiraharenai kakoa. Hatyaoseta haiyaharenai kolatyaha hatya maxosehare hoka Jesus axaha, hakahe ekaokakisa ihiye maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hoka Jesus ekahe hiyeta otoka maxosehare hoka xane ekakoa sekose aka wenakalati nonitata. Hatyaoseta haxataho xolotya exose hiye hoka hakahe ekaokakisa ihiye hoka axene: — Xoana, xoalini hare hiyaiyita? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","— Nowaiyita halitinai, xakore hoka motya atya kate tonita ene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hatyaoseta Jesus hakahe ekaokakihitiya exose hiye. Hatyaoseta maxosehare waiye waiyakaheta. Waiyeheta hoka tyotya xoalini hare waiye waiyeheta. ");
INSERT INTO pabNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hatyaoseta Jesus axikaheta hatyo haliti ehana xeta. Hoka halitinai koni emaxaneneheta aoka. ");
INSERT INTO pabNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hatyaoseta Jesus haxaotyakiraharenai kakoa xane wenakalatinai Cesaréia de Filipe koa maniya. Xanahitaha hoka ahotyaho haxaotyakiraharenai axa: — Xala aokita natyo halitinai? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hoka exaotyakiraharenai nexa: — Haiyaharenai atyo João Batista aokahitaha hiso, haiyaharenai atyo Elias aokahitaha hiso, haiyaharenai atyo iraeti xakaisasehare aokahitaha hiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","— Hoka xiso atyo xala xaokita natyo? nexa ihiyeha. — Hiso atyo Enore Kalorexe Aohenere — nexa Pedro Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hoka Jesus hatyohare maxakaisakene aoka ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hatyaoseta Jesus aotyakihena haxaotyakiraharenai hoka nehena: — Haliti Ityanite kaxemawatikisaka kalore. Maisaite aokahitene haomanaha judeunai xekohaseharenai, sacerdote xekohaseharenai, judeunai xaotyakiraho kakoa waiyoreterenai harenai. Hoka kaxaisakaite hoka hanamaki ferakene najikinitaite kaseheta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus waiyekehalaka iraeta ekakoaha. Xakore hoka Pedro nolokene haware hoka matyakekotya iniraene. — Awa atyo nikare hirae — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hatyaoseta Jesus ehaikoaheta hoka wahakotya haxaotyakiraharenai ana hoka Pedro niraene tehitiya matyakekotya hoka nehena: — Hakikisoahetehena nahiti maniyata, Ahalakoahaliti! Halitinai ahekoitere akereta atyo hahekoita, maisa atyo Enore ahekoitere akereta xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hatyaoseta Jesus kawisa halitinai exahe haxaotyakiraharenai xoaha hoka iraehena ekakoaha: — Xala xamani atyo tyaona nokoamaniye aokowihena hoka maika hatyota maotyanoawi hoka maika kolatya haberekotyaka niyahare atyalihose xaimaholatyaka hoka tyaona noximi. ");
INSERT INTO pabNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Xala xamani atyoite tawita hawenane waiyexe hoka maisaite kaokitene. Hoka xala xamani atyoite nohiyeti exahe Iraeti Waiyexe hiyeta kaxaisaka hoka hatyo atyoite kaoka wenati waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","— Xoare mahetaiya hatya haliti hakakoare waikohekoa xiyehaliti harenai kakoa tyaona hoka hatyaoseta waini? ");
INSERT INTO pabNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Maisaiya xoare hare bakatya hoka ekasekihititene. ");
INSERT INTO pabNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hiyaiya, xala xamani atyoite haihareta natyo, niraeni xoaha kakoa kalikini xowaka exe matyakekoneharenai, mawaiyexehareharenai haoti hoka haxowakiyaite Haliti Ityani tyohetehena Hanexe werokene kakoa, anjonai waiyexeharexenai kakoa hoka haihare tehitiyaite ekakoa — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hatyaoseta Jesus nehitiya ihiyeha: — Exe harira xotya: haiyaharenai ali tyaoniterenaite maisa hamawaiyanehareta wainita Enore nalitare kaokehenere haiyatere kakoa nahitita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hatyaoseta 6-ki ferakene najikinita Jesus noloka Pedro, Tiago, João xoaha hoka hatyonai kakoa taita xane tyairi enoakiyere heno xeta. Hoka hatyo nali hawareharexe tyaona ehaotyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Inima iyomate, werokate tyaona. Maisaiya hatya tihatiro hekoti nikare niyomene tihita. ");
INSERT INTO pabNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hatyaoseta Moisés, Elias kaotyaka hoka hatyo hanamahare Jesus xaotyakiraharenai waiyaha iniraeneha Jesus kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hatyaoseta Pedro nehena: — Xaotyakisatiye, waiye nawenatyaka ali. Nika wisoma hanamalise hatirisenai: hatya homanere, hatya Moisés anere, hatya Elias anere xoaha — nexa, ");
INSERT INTO pabNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","maisa waiyore iraexe. Exahe tyotya Jesus xaotyakiraharenai mairaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hatyaoseta kaiminiti exoa hoka exahiyatene hoka hatyo konita iraiti semaha hoka nehena: — Exe atyo nityani noxiyakawali, xasemaxematyaira iniraene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hatyaoseta waiyasekoatyaha xakore hoka Jesus taita waiyehenahitaha hahaliyaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hatyo hekota tyairi henota exoahenahitehenaha hoka Jesus hatyohare waiyehenerehareha maxakaisakene aoka ihiyeha Haliti Ityani kasehetehenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hoka tyakekoha iniraene, xakore hoka hatyo kakoaha iraekakoahitaha kasehetehenere nehenere tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hatyaoseta axaha Jesus: — Xoana hoka judeunai xaotyakiyaho kakoa waiyoretereharenai Elias hotohare ite tyoheta aokaha? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Hoka Jesus nexa: — Aliterexe ite Elias hotohare tyoheta hoka tyotya memere mohena xoalini hare. Hoka xoaneretya hoka Iraiti Waiyexe kaxairatyakehenere, Haliti Ityanite kaxemakawatikisaka, exahe maisa ite kaxaiminisakita, nita? nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","— Xakore hoka noxakainite xihiye: Elias atyo koxaka tyoheta hoka maisa waiye mokahitene. Aokahitere akereta mokahene iraiti kaxairatyakehenere etahi akiti akereta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hatyaoseta hikoahenahitehenaha haiyaharenai Jesus xaotyakiraharenai ana hoka waiyaha kahare haliti ehokoha haliya. Haiyaharenai xaotyakiyaho kakoa waiyoreterenai kinatyaxa iraeta ekakoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hatyaoseta halitinai waiyaha Jesus kaokene eharehena rota hoka tema xaneha enomana, katyawaxaha ihiye maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Hatyaoseta Jesus axehena hatyo xaotyakiyaho kakoa waiyoreterenai: — Xoare tahi kinatyaxa xirae kakoita? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hatyaoseta hatya haliti halitinai konitare nehena: — Xaotyakisatiye, nakolatya nityani homana hiyaiyene maheta. Isekohaliti iniyalahare kakoare hoka maisa iraexe. ");
INSERT INTO pabNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Haiya xowaka mawaiye nisekohaliti ehatyahalikihenene hoka exoa waikoa hoka kilinakota ekanase, kinatya tyalokakoaita hoka kinatyakase tyaonita. Koxaka hiyaotyakiraharenai hiye nirae axanikihenahitaha mawaiye nisekohaliti enonitata maheta. Xakore hoka maisa aliyakere axanikihenahititene enonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hatyaoseta Jesus nexa: — Haliti matyakekoneharenai! Otene kijiyaite notyaona xinekoni? Otene kijiyaite naiyasetyoa xikakoa? Xisohena ali xoimahaliti kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hatyaoseta xoimahaliti kolatyaha Jesus ana. Hoka exehatyahalikisase waiya Jesus hoka xoimahaliti etatakoakisa hoka waikoa exoakisene hoka tekehirisoakoatya hoka kilinako ekanase tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Hatyaoseta Jesus axa enexe: — Xoana hekota exakere hityani tyaona? Hoka enexe nexa: — Haxoimeneta exakere tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kahaliki irikatyaose, onexa harenai axexoatyanikijitene aisene maheta. Hoka hawaiyore atyo hoka hakahinaehena wiso. Hairakoaneharehenaira wiso! ");
INSERT INTO pabNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","— Xityakekotaiya atyo hoka. Xala xamani atyo tyakekota hoka kaomakaiya atyo enomana — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","— Notyakekota atyo! Hoka hakahinaehena natyo hoka exahehare notyakeko! nexa enexe kawiyatya, tiya xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hatyaoseta Jesus atyo waiyehena, kaharehena atyo halitinai ehaliya makere hohisakoita hoka exehatyahalikisase hiye nexa: — Isekohaliti masemakalahare, mairaenehare, hahikoahetehena exe xoimahaliti nonitata hoka waiyehenaira ehekota hehatyahalikihititene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hatyaoseta isekohaliti kawiyatya hoka atekehirisoakisa xoimahaliti hoka kikisoaheta enonita hoka motya ekamane mokene. Hatyo hiyeta haiyaharenai motyala waini aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hoka Jesus otoheta xoimahaliti kahe hiye hoka atityoakihetene hoka tityoaheta. ");
INSERT INTO pabNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hatyaoseta Jesus xane isoaheta hatyako hoka exaotyakiraharenai hawawaharenaiha heko axahene: — Xoanere ala hoka maisa aliyakere waxanikihitita etake isekohaliti? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","— Hatyohare isekohaliti atyo iraexatyati exahe manakairiti xoaha xema taita kaxaxanikisakihitita — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hatyaoseta Jesus xanehitiya hatyo nalita haxaotyakiraharenai kakoa hoka Galiléia koa nali jiyaha. Jesus kasani maisa xala hare ana waiyekehalaka tyaonitere akiti aokare, hawawahare heko irae aokowita haxaotyakiraharenai kakoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesus aotyakijita haxaotyakiraharenai hoka nita ihiyeha: — Haliti Ityanite kaxékaka halitinai ana hoka aisahene ite. Xakore hoka hanamaki ferakene najikinitaite kaseheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nexa ihiyeha hoka maisa waiyekehalakere Jesus niraene enomanaha. Hoka haiharahitene hoka maisa axarahene hekoti. ");
INSERT INTO pabNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hatyaoseta Jesus haxaotyakiraharenai kakoa kaokeheta wenakalati Cafarnaum nali. Hoka hatyako isoahenahitaha hoka Jesus axehena haxaotyakiraharenai: — Xoare tahi ahoti kinatyaxa xirae kakoita? nexa, axahene. ");
INSERT INTO pabNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Hoka mema tyaonaha enomana, ahotyaho hakalorexeneha tahi irae kakoahitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hatyaoseta Jesus tyoka hoka kawisa haxaotyakiraharenai hoka nexa ihiyeha: — Xala xamani atyoite kalorexe tyaona aokowita hoka maika tyotya halitinai wakanehare, ekahinaetyasehare tyaona — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hatyaoseta Jesus iya xoima hoka enenekeseneha mokene. Hoka hakano talako mokene hoka iraehena haxaotyakiraharenai kakoa: ");
INSERT INTO pabNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","— Xala xamani atyoite nohiyeti hatya xoima waiye moka hoka natyo atyo waiye mokita. Hoka xala xamani atyoite waiye mokita natyo hoka maisa atyoite natyo taita xini waiye mokita, noxaxikatyasehare tehitiya atyoite waiye mokita — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hatyaoseta João nehena: — Xaotyakisatiye, wiyaiya hatya haliti xaxanikireheta isekohaliti iniyalahare halitinai nonitata hexare kakoa hoka wamahokoanetya nikare enómane. Maisa winekonitare xini hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Hoka Jesus nexa: — Awa atyo xamahokoanetene. Hiyaiya, maisaiya xala hare metaharexe maomakahare waiyexe tyomita nexare kakoa hoka hatyo najikinita iniyalahare iraehitita notahi. ");
INSERT INTO pabNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hiyaiya, xala xamani atyo maisa kahalakoaharexe wikakoa hoka hatyo atyo wikahinaetyasehare — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","— Xotyaxematyaira exehare: xala xamani atyoite hákobone one isa xomana, Cristo koamaniya xawenane hiyeta hoka hatyo ana atyoite xoalini hare waiyexe kaxekaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","— Hoka exehare xoima mokosenai tyakekotereharenai natyoiya atyo hatya iniyalahare aomanekisa hoka halakihenahitaha hawenaneha nokoamaniye hoka ehekoretaiya atyo kaxawatyaka one kaloxere xaiya sehali kaloliro kaxolatyaka ihino hiye hoka maisa ahowitikisa xoimanae nawenane maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","— Maika hikahe iniyalahare axomokanikijita hiso hoka maika hirikotene! Hiyaiya, waiye kaiserehareya atyo hamaniya kahe kakoa taita hiyane wenati matyotenehare nali. Hoka maisaiya atyo waiyeta hinama kahe kakoa hikaxawatyaka irikati mawakenehare nali hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hiyaiya, hatyo nali atyo xeteti, irikati harenai hoka maisa tyotere. ");
INSERT INTO pabNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Maika hikiji iniyalahare axomokanikijita hiso hoka hirikotene. Hiyaiya, waiye kaiserehareya atyo hamaniya kiji kakoa taita hiyane wenati matyotenehare nali. Hoka maisaiya atyo waiyeta hinama kiji kakoita hikaxawatyaka irikati mawakenehare nali hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hiyaiya, hatyo nali atyo xeteti, irikati harenai hoka maisa tyotere. ");
INSERT INTO pabNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Maika hiyose iniyalahare aomanekijita hiso hoka maika holokotya hiyene. Hiyaiya, waiye kaiserehareya atyo hamaniya xose kakoa taita hiyane Enore tyaonitere nali. Hoka maisaiya atyo waiyeta hinama xose kakoita hikaxawatyaka irikati mawakenehare nali hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hiyaiya, hatyo nali atyo xeteti, irikati harenai hoka maisa tyotere. ");
INSERT INTO pabNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","— Hiyaiya, hatya xakini atyoite kasalotyakehena irikati kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Salo atyo waiye. Hoka ekexeniya atyo tyotehena hoka maisa atyo saloheta xini. Maika xirihare xisaohena hoka waiyira xamoka kakoahena haiyanai kakoa — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hatyaoseta Jesus xaneheta hatyo nalita hoka xane Judéia koa xeta hoka imahotyoa one Jordão xa. Hoka kahare haliti hohisakoahitiya ehaliya hoka aotyakihenahitiyene, aotyakijitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hatyaoseta haiyanai fariseunai hasakaharetene aokowihenaha hoka axahene: — Wiyaotyakisakaho hiyetaiya waiyehenaiya hatya haliti haiyanityo halakiheta? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hoka Jesus haxaxane kakoa ekoaxatya enomanaha: — Xoare nexa tya Moisés aotyakisa xiso? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hoka nexaha: — Hatyaiya atyo halakihetehena haiyanityo hoka halakisakakoati baberaxa iseheta enomana hoka axikahetene, aoka Moisés — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hoka Jesus nexa: — Nikare Moisés aotyakisa xiso, maisa xawaiye xahekolere hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Xakore hoka hetati xowaka tyotya xoalini hare kaomakehenere xowaka atyo exakere kaxairatyaka: Enore tyoma ena, ohiro xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hatyo hiyeta hatya ena ite kaiyanityohena hoka halakisa hanexe, hanityo xoaha hoka haiyanityo kakoa haxawalita tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Hoka hatyo hinamanaite haterore tyaohenahitaha. Nikare ite hoka maisa atyoite hinamehenahitaha xini hoka haterore henahitaha atyoite. ");
INSERT INTO pabNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hatyo hiyeta maisaiya hatya haliti hatyonai exaorehitita Enore hahotyalita mohenerehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hatyaoseta xane isoahenahitaha hatyako hoka exaotyakiraharenai axene hatyo wenakakoati tahi. ");
INSERT INTO pabNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hoka Jesus nexa ihiyeha: — Enaiya halakiheta haiyanityo hoka hatya ohiro kakoa tyaohitiya hoka iniyalahare atyo tyomita haiyanityo xahita. ");
INSERT INTO pabNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Exahe hatya ohiroiya haiyanene halakiheta hoka hatya ena kakoa tyaoheta hoka iniyalahare tehitiya atyo tyomita — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hatyo najikinita haiyaharenai kolatyaha xoimamokosenai Jesus ana, ekaokakisa hakahe ihiyeha hoka waiyexe wenati aoka enomanaha maheta. Xakore hoka exaotyakiraharenai mahokoanetyahene. ");
INSERT INTO pabNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hoka Jesus waiya nikare enawenaneha hoka maisa waiyeta ihiye hoka nexa: — Kotare xoimanai tyoa nomani, awa atyo xamahokoanetyahene. Hiyaiya, Xekohaseti Enore naliye waikohekoa atyo exe xoimairanai akereta tyaoniterenai anere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","— Aliterexe nomita xihiye: xala xamani atyoite maisa exe xoimanai akereta Enore niraene tyakekota hoka maisaiya aliyakere tyaonahitaha exema — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hatyaoseta Jesus xakoloharetya xoimanai hoka eseriha hiye hakahe ekaokakisa hoka wenati waiyexe aoka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hatyaoseta Jesus xanehitiya ene hoka hatya haliti tema tyoa hoka hakaolise kakoa exoa enahalakoa hoka axehenene: — Waiyexe Xaotyakisatiye, xoareya notyoma hoka kaxekaka nomani wenati waiyexe matyotenehare? nexa axene. ");
INSERT INTO pabNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Hoka Jesus nexa: — Xoana hoka waiyexe haoka natyo? Enore taita atyo waiyexe, maisa atyo hatehitiya aka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","— Maisa hoka koxaka hiyaiya exe xaotyakiyahonai: “Awa atyo haisa, awa atyo iniyalahare hisoma ohiro kakoa, awa atyo hikaiwa, awa atyo hamaoseratya, haiminisa hexe, hityo xoaha” nitere — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","— Xaotyakisatiye, noxoiminita atyo hatyo xaotyakiyahonai xema notyaonita — nexa hatyo xoimahaliti. ");
INSERT INTO pabNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nexa hoka Jesus wahakotya enomana hoka awaiyetene hoka nexa: — Exe taitehena himaomanehare: hiyane tyotya habetehena hixiyeharenai hoka maoloxaharenai ana olo hisehena. Nikare ite hisaona hoka hikaoloxahare, hikaxiyeharexe hisaona enokoa nali. Hatyaosetaite hisoheta hoka hisoa noximi — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hatyohare hatyo haliti sema hoka kalore amaikohare hoka xaneheta, kahare kaxiyeharexe hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hatyaoseta Jesus wahakotya haxaotyakiraharenai ana hoka nehena: — Kaxiyani, howitihare atyo kaxiyeharexenai nawenane Enore koamaniya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Exaotyakiraharenai sema iniraene hoka hakaharetyoaha. Xakore hoka Jesus nehitiya ihiyeha: — Nohinaeharenai, howitihare atyo kaoloxerenai nawenane Enore koamaniya. ");
INSERT INTO pabNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hiyaiya, howitihare atyo kaoloxere nawenane Enore koamaniya, kamelo howitihare kaxajiyakisakitere awiyahi nakoako xahehare howitini atyo. ");
INSERT INTO pabNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Exaotyakiraharenai hakaharetyoaha, semaha hatyoharenai hoka hatyo kakoaha nexa kakoaha: — Nikareya hoka xalaiya kaiyakehetehena? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hatyaoseta Jesus wahakotya enomanaha hoka nexa: — Halitinai ana atyo hatyoharenai howitihare, xakore hoka maisa atyo Enore ana xini howitihareta. Hiyaiya, Enore ana atyo maisa xoare hare howitiharexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hatyaoseta Pedro nehena Jesus hiye: — Hiyaiyehena, wisotya tyotya wahalakiharetyoa hoka hikoamaniya wisaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Hoka Jesus nexa: — Aliterexe nomita xihiye, xala xamani atyoite halakisa hahana, haximarenenai, hahahalonai, hanityo, hanexe, haisaninai, hawaikohera harenai, nohiyeti exahe Iraiti Waiyexe xoaha hiyeta hoka ");
INSERT INTO pabNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kaxekakehitiyaite enomana. Kahalikite kaxekakehitiya enomana, ehananai, iximarenenai, enahahalonai, inityonai, enexenai, ityaninai, ewaikoheranai. Xakore hoka haiyaharenaite kirawanehenahene. Hoka haxowakehena atyoite hoka wenati waiyexe matyotenehare kaxekaka enomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","— Kahare kalikini kalorexe tyaoniterenai atyoite hatyo xowakiya wakahare tyaohenahitaha. Nikare ite kalikini kahare wakahare tyaoniterenaite exowakehena hoka kalorexe ite tyaonaha — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hatyaoseta Jesus, exaotyakiraharenai harenai xanahitaha Jerusalém xeta. Enahetaha tonita hoka exaoyakiraharenai enajikinita tonahitaha. Hoka hakaharetyoa mokahene, exahe haiyaharenai enajikinita xaneterenai mairahitaha. Hatyaoseta Jesus haware xane haxaotyakiraharenai kakoa hoka xakai ihiyeha haxaisaka tahi hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","— Xasemehena, wiyaneta atyo Jerusalém xeta. Nalite Haliti Ityani kamatawatyakehena sacerdotenai xekohaseharenai ana, xaotyakisatyaho kakoa waiyoretere harenai ana xoaha. Hoka exaisakaite aokaha hoka hahotyalihare halitinai anaite halakisahene aisahene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hoka hatyonaite koexahalisene, xataholisene, mokotyahene ite, exahe aisahene ite. Xakore hoka hanamaki ferakene najikinitaite kaseheta — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hatyo najikinita Zebedeu ityaninai, Tiago, João xoaha, xaneha Jesus haliya hoka nexaha: — Xekohaseti, hasemehena, waxiterehare hisehena womana — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","— Xoare nisa xomana xaokita? nexa Jesus axahene. ");
INSERT INTO pabNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hoka nexaha: — Kasani kalorexe hisaohenere xowakaite, hiyane hisokehenere hokahakala waiyexe heno xowakaite, wisoka hihaliya waokowita. Hatya hifihini maniya, hatya hiwatone maniya xoaha waokita — nexaha axahene. ");
INSERT INTO pabNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hoka Jesus nexa: — Maisa atyo xawaiyorexe xaxitereharenai kakoa. Xoana waiyehenaiya xisera erakakalati akore noterehenere, exahe waiyehenaiya xikabatixatyaka nokabatixatyakihenere akereta? nexa ihiyeha (hakamane xaokaka nikareta Jesus). ");
INSERT INTO pabNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hoka nexaha: — Há, waiyehenaiya — nexaha. Hoka Jesus nexa: — Aliterexe nomita xihiye: xiseraite erakakalati akore noterehenere hiyeta, exahe xikabatixatyakaite nokabatixatyakihenere akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","— Hoka xisoka xaokowitere nofihini maniya, nowatoni maniya xoaha xaokowitere atyo maisa nomaniye xini. Enore atyo hatyoharenai memere moka, isá aokowihenereharenai anere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hatyohare 10-hare exaotyakiraharenai semaha hoka ehareha Tiago, João xoaha hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hatyo hiyeta Jesus tyotya kawisahene hahaliya makere, hoka nehena: — Xiyaiya, xekohasetinai atyo wakatita halitinai, exahe kalorexenai atyo wakatyahitene. Exe harenai atyo waiyekehalakita xomana. ");
INSERT INTO pabNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Hoka maisaiya atyo nikare xisaonita. Xala xamani atyoite xinekonitare kalorexe tyaona aokowita hoka maika hahena hahinaeharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Maika xala xamani atyo kalorexe tyaona aokowita hoka hatyo atyoite tyotya halitinai wakanehare tyaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","— Hiyaiya, Haliti Ityani kakoita atyo tyoa hoka maisa atyo kahakaka enomana maheta xini. Haka maheta atyo tyoa, exahe waini hoka kahare halitinai iyeheta maheta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hatyaoseta Jesus xane kaoka haxaotyakiraharenai kakoa wenakalati Jericó nali. Hatyaoseta xanehitiya hatyo wenakalatita haxaotyakiraharenai kakoa, exahe kahare halitinai xoaha kakoa. Hoka waiya hatya maxosehare Bartimeu nexarexe, Timeu ityani. Hatyo atyo maxosehare. Ahoti kilihi tyokita hoka olo axita haomana. ");
INSERT INTO pabNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hoka sema Jesus Nazaré yere jiyanehena hoka kawiyatya: — Jesus, Davi jikolahare, hairakoaneharehena natyo! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hatyaoseta haiyaharenai mahokoanetya iniraene, mema xoaha tyaona aokaha, xakore hoka exahehare kawiyahitiya: — Davi jikolahare, hairakoaneharehena natyo! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hatyaoseta Jesus tityoa hoka nexa: — Xakawihena maxosehare ali — nexa. Hatyaoseta kawihenahene hoka nexaha: — Hihalaharehenaira! Hatityoahetehena. Hiyaiya, kawijita atyo hiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hatyaoseta Bartimeu xawatya haihiri hoka ihalahare tityoaheta hoka xane Jesus haliya. ");
INSERT INTO pabNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","— Xoare notyoma homana haokita? nexa Jesus axene. — Xaotyakisatiye! kasani nowaiyakatyareheta naokowita! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","— Hiyanehetehena, kalikini atyo hawaiyeheta hityakekone hiyeta — nexa Jesus ihiye. Nexa hoka hatyaoseta Bartimeu waiyakahetehena rotita hoka Jesus xema xane ahoti aho. ");
INSERT INTO pabNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hatyaoseta Jesus haxaotyakiraharenai kakoa xane kaokehenaha Jerusalém nali. Hoka xane Oliveiras tyairiya nali kaokaha, wenakalatinai Betefagé, Betânia xoaha haliyaseta. Hoka axikatya hinamahare haxaotyakiraharenai ");
INSERT INTO pabNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hoka nehena: — Xiyanehena wenakalati xaheta maniya tyaonitere nali. Xiyane ite nali xikaokehena hoka xiyaiyaite boriko mokose exolatyakahare tyaonita, maokatyakaharetata eheno. Hoka maika xamaxolatene hoka xisoa ekakoa ali. ");
INSERT INTO pabNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Maika xala xamani axehena xiso: “Xoare maheta nikare xaolihenene?” nehena hoka maika, “Xekohaseti aokitene haomana hoka awisaite isehetene”, xexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hatyaoseta xaneha hoka waiyaha boriko mokose hati kanase jiyakalati haliyita, ekatilikakahare tyaonita. Hatyaoseta aolihenaha hatyo boriko mokose hoka ");
INSERT INTO pabNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","haiyaharenai axehenahene: — Xoana xamohenene? Xoare maheta boriko mokose xaolihena? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hatyaoseta Jesus iraehenere ihiyeha akereta iraeha hoka hatyo halitinai halakisene hoka xaneha boriko mokose kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hatyaoseta nolokaha boriko mokose Jesus ana. Hoka haimanaeha mokaha eheno. Hatyaoseta Jesus tyoka eheno. ");
INSERT INTO pabNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hatyaoseta haiyaharenai kanahotyaha ahoti haimanaeha kakoa, exahe haiyaharenai hoka irikotyaha atya xawali hatyo nalita hoka hatyohare kakoa kanahotyahitaha ahoti aho. ");
INSERT INTO pabNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Enaheta xaneterenai, enajikinita tyoiterenai xoaha kawiyahenaha: — Wihalahareta hikakoa, Enore! Xekohaseti Enore, waiyira hamohena hexare kakoa tyoitere! ");
INSERT INTO pabNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Waiye kaiserehare atyo Davi najikinitare kaokehena womana xekohaseti tyaona maheta Davi akereta! Wihalahareta hikakoa, Enore! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Hatyaoseta Jesus kaoka Jerusalém nali hoka isoa Iraexatyakalati Hanako hoka tyotya hakakoare wahakoakotya. Xakore hoka koxaka makehena hoka xane wenakalati Betânia nali, 12-hare haxaotyakiraharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kamaetali Betânia nalita haikoahenahititaha hoka Jesus naka. ");
INSERT INTO pabNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hoka sekota waiya halohalo kate. Kahanahiye kahare hoka xane iri xahita waiyakatetene. Xane hikoa ehaliya hoka ehana taita waiya, maisa iri xowakehetehenere hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hatyaoseta nexa halohalo kate hiye: — Exe hekotaiya maisa xala hare hirínai hiyohitita — nexa. Nexa hoka hatyo harenai exaotyakiraharenai sema. ");
INSERT INTO pabNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hatyaoseta Jesus haxaotyakiraharenai kakoa kaokaha Jerusalém hoka isoa Iraexatyakalati Hanako. Hatyaoseta hatyo nali iyakaiterenai exahe betetitere harenai aihikoaheta. Herawatya exoakisa olo ehaikoakihititere harenai mexane, watyaha betetitere harenai nokahakala hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hoka maisa xala hare xoalini hare kolatya Iraexatyakalati Hanako xeta aokare. ");
INSERT INTO pabNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hoka aotyakisahene exakere: — Iraeti Waiyexe nanekoa atyo exakere Enore niraene kaxairatyaka: Nohani atyoite Iraexatyakalati Hana kakaixaretyaka tyotya halitinai anere. Xakore hoka xiso atyo kaiwarexenai xateroakisakala niyahare xamokene! nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hatyaoseta sacerdotenai xekohaseharenai, xaotyakiyaho kakoa waiyoretereharenai harenai, semaha iniraene hoka aisaha aokowihenaha Jesus. Xakore hoka mairahitene, halitinai awaiyetita exaotyakira hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hatyaoseta makehena hoka Jesus haxaotyakiraharenai kakoa xanehenahitaha wenakalati Jerusalém nalita. ");
INSERT INTO pabNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kamaetali weta Jesus haxaotyakiraharenai kakoa jiyehenaha hatyo halohalo kate tyaonitere haliya hoka waiyehenaha atyo, nira atyo ityahare kakoita. ");
INSERT INTO pabNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Hatyaoseta Pedro oteheta Jesus niraene hoka nexa ihiye: — Hiyaiyehena, Xaotyakisatiye, etake halohalo kate himaxawaiyerehenerore nira — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hoka Jesus nexa: — Exe harira xotya: xityakekoiya Enore hoka ");
INSERT INTO pabNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","xexaiya exe tyairi hiye: “Hakikisoahena hatyaoseta hoka hiyane onexa hexoahena”, xexaiya hoka maisaiya xamatyakekotita xiraene hoka xityakekoiya xiraene hoka hatyo xiraetere akeretaiya kaomaka. ");
INSERT INTO pabNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hatyo hiyeta nomita xihiye: xiraexahenaira hoka xoalini hare xaxehena hoka xityakekoira, motyaira koxaka kaxekakita ene hatyo harenai xomana. Nikare ite hoka hatyo harenai kaxekaka xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","— Maika xiraexahena hoka ximaotyaneheta hatya iniyalahare tyomehenere hare xikakoa. Nikareya xisaona hoka Xexe enokoa tyaonitereya atyo maotyaneheta iniyalahare xománe. ");
INSERT INTO pabNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Hoka maisaiya ximaotyanehitita hatya iniyalahare tyomehenere hare xikakoa hoka maisaiya Xexe enokoa nali tyaonitere maotyanehitita iniyalahare xománe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hatyaoseta haikoahenahitaha Jerusalém nali. Hoka Jesus tonakoita ene Iraexatyakalati Hanako hoka sacerdotenai xekohaseharenai, xaotyakiyaho kakoa waiyoretereharenai, judeunai nityohalitiranai harenai xane kaokaha ehaliya ");
INSERT INTO pabNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","hoka axahene: — Xala niraene kakoare hiso hoka nikare hisaonita? Xala xaokala xema nikare hisaonita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hoka Jesus nexa: — Natyo tehitiyaite naxa xiso. Hoka xekoaxatyaite nomani hoka noxakaite xihiye xala niraene xema exe harenai notyomita hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","— Xiyakaihenaira: xala niraene xema João Batista batixatya halitinai? Xoana Enore niraene xema, halitinai niraene xema kore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nexa ihiyeha hoka hatyokakoaha irae kakoahenaha: —“Enore niraene xema”, wexaiya hoka nexaiya axa wiso: “Hoka xoaneretya hoka maisa xityakekota João?” nexaiya wihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Halitinai niraene xema”, wexaiya hoka halitinaiya ehareha wihiye — nexaha, mairahitaha halitinai, tyotyaha João Batista iraeti xakaisasehare terota aokahitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hatyo hiyeta nexaha: — Maisa wawaiyorexe hatyo akiti kakoa — nexaha. Hatyaoseta Jesus nehena: — Natyo tehitiyaite maisa noxakaita xala niraene xema exeharenai notyomita hoka — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hatyaoseta Jesus haxaimenekola kakoa xakaihakahena ihiyeha. Hoka nexa: — Hatya haliti fitya uva katenai hamasenekoa hoka talahokotya hamasenekoa. Tyoma uva kakatyakala vinhoxa tyoma maheta, exahe enoakiya kahainatya hakakoare waiyakoatya hamasene maheta. Hatyaoseta haiyanai halitinai ana halakisene hoka xonehena hoka irakakakoahenahitene aoka ihiyeha hoka xane hakiti seko akiya xeta. ");
INSERT INTO pabNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","— Enexona xowakehena hoka exekohase hatya hawakanehare axikatya, holini isehenahitaha enomana maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Xakore hoka hatyo masene kaxaikotyaseharenai otokene hoka mokonasetene hoka axikahenahitene. Maisa xoare isahitaha enomana. ");
INSERT INTO pabNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hatyaoseta hatisa hawakanehare axikahitiya enomanaha hoka nikareta tehitiya maisa aiminisahitene hoka mokotyahene eseri hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hatyaoseta hatisa axikahitiya hatyo nali xeta hoka masene kaxaikotyaseharenai aisene. Nikare haiyaharenai kahare axikahenere mokaha. Haiyaharenai mokohekoatyaha, haiyaharenai aisaha xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hatyaoseta ityani ixiyakawalahare takitehena hoka axikatya haisani enomanaha. Exakere ahekotya hoka axikatene: “Nityanite naxikatya enomanaha hoka aiminisahene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Xakore hoka masene kaxaikotyaseharenai nexa irae kakoaha: “Exe atyo masene waikatehare ityani. Nikahena hoka waisene hoka hananehaliti waikohe harenai kakoa wisaona”, nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hatyaoseta otokaha ityani hoka aisahene hoka xane xawatyahene seko masene nonitata. ");
INSERT INTO pabNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Hatyaoseta Jesus axahene: — Xoanaite masene waikatehare tyaohena? Tyoaite aisehena hatyo halitinai hoka hahananehare isehena hahotyalihare masene kaxaikotyaseharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","— Xoana maisa xótyare Iraiti Waiyexe kaxairatyakehenere: Sehali hati nomaseharenai maxaokarehenere atyo kaxomokaka hati nekesako. ");
INSERT INTO pabNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hatyo atyo Xekohaseti xekane. Kaxíyani, waiye kaiserehare atyo! ");
INSERT INTO pabNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hoka judeunai nityohalitiranai ana waiyekehalaka. Hatyo haxaimenekola kakoa iraetere atyo etahiha hoka otokaha aokowihenaha Jesus. Xakore hoka mairahitaha halitinai. Hatyo hiyeta Jesus halakisaha hoka xanehenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hatyaoseta axikatyaha haiyahare fariseunai, Herodes konitarenai harenai Jesus ana hasakaharetyahene maheta, kasani Jesus komaniyatyoa hairaene kakoa aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Xane kaokaha enomana hoka nexaha: — Xaotyakisatiye, waiyekehalakita atyo womana hawaiyexeharene. Maisa atyo haiyanai niraene xema hisaonare. Hiyaiya, maisa atyo halitinai henekoa maniya xini hiyaita, exahe hoka aliterexe atyo haotyakijita Enore xaotyakiraho. Hoka hiyakaihena wihiye: xoana wiyaotyakisakaho hiyeta ehekoretaiya olo kalorexe Roma yere aokiterehare wabakatya? Wabakahenaite, maisa kore ite wabakaita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hoka Jesus otya emaoseralaha hoka nexa ihiyeha: — Xoana hoka xahasakaharetya xaokowita natyo? Xama olo hokose nomani hoka nowaiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hoka isaha olo hokose enomana hoka axehenahene: — Xala nexare, niyakotini tiho exe olo hokose hiye? nexa. Hoka nexaha: — Kalorexe Roma yere — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hoka Jesus nexa: — Xoare xamani atyo kalorexe Roma yere anere hoka kalorexe ana xisene. Hoka Enore anere atyo hoka xisene Enore ana — nexa ihiyeha. Nexa ihiyeha hoka hakaharetyoaha exekoaxala kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hatyaoseta haiyaharenai saduceunai tyoaha Jesus ana. Enomanaha haliti wainihena hoka maisa kasehetere. Tyoaha Jesus haliya hoka nexaha: ");
INSERT INTO pabNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","— Xaotyakisatiye, Moisés exakere xairatya wawenane niyahare. “Hatya halitiya waini hoka haiyanityo maisanihalota halakisa hoka iximareniya tyaohitiya ekakoa hoka kaisanihaiya hoka exanene wainihenere ityaniya kaxaokaka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","— Hasemehena, 7-hare haximarene kakoarenai tyaonahitaha. Hoka enaxenaneha hetatiyehare kaiyanityo hoka waini maisanihareta. ");
INSERT INTO pabNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hatyaoseta iximarene ihiyetare tyaohitiya hatyo ohiro kakoa hoka maisanihareta wainihitiya. Hatyaoseta nikareta ihiyetare tyaohitiya, maisanihareta wainihitiya. ");
INSERT INTO pabNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nikare makere hatyo 7-hare haximarene kakoarenai tyaonaha hatyo ohiro kakoa hoka maisaniharetaha wainiha. Hatyaoseta ekamaneha najikinita, hatyo ohiro tehitiya waini. ");
INSERT INTO pabNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nikarite hoka xala exanityo kaisere ite hatyo ohiro tyaohetehena, kamatinai kasehetehenere xowakiya? Hiyaiya, tyotyaha atyo tyaonaha ekakoa! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hoka Jesus nexa: — Xiso atyo ehaikoare xahekotita. Maisa atyo iraiti xairatyoare tyaonitere waiyekehalakere xomana, exahe Enore niyatere hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","— Hiyaiya, kamatinai atyoite kasehetehena hoka anjonai enokoa nali tyaonitere akereta atyoite tyaonaha, maisaiya atyo tyaonakakoahenahititaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","— Xoana maisa xakaixaretita kasehetehenerenai tahi xairatyoare tyaonitere Moisés xairala nanekoa? Etake hananehaliti keritere tahi iraetere exakere atyo xairatyoare tyaonita, Enore iraehenere Moisés hiye: Natyo atyo Abraão, Isaque, Jacó xoaha Nenorexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hatyoharenai hiyeta Enore atyo kasexenai Nenorexa hoka maisa atyo kamatinai Nenorexa xini. Xiso atyo ehaikoare xahekotita — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hatyaoseta hatya xaotyakiyaho kakoa waiyoretere, nali tyaonita hoka sema iniraekakoaneha. Sema Jesus xekoaxala waiye hoka hatyaoseta xane axa Jesus: — Xoare hare masakare waiyexe xaotyakiyahonai konitare? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Hoka Jesus nexa: — Exe waiye kaiserehare: “Xasemehena, Israel yerenai! Wiyekohase Enore atyo haterore! ");
INSERT INTO pabNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Hawaiyehena kaiserehare hiyekohase Enore, hisaonehena exema maniya takita, hahekohena ekoamaniya takita, haiyateretyoahena hawenane kakoa exema maniya”, nexa. — Hatyo atyo waiye kaisere. ");
INSERT INTO pabNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Exe ihiyetare tehitiya atyo masakare waiyexe: “Hawaiyehena haiyaharenae hawaiyetyoawitere akereta”, nexa. Maisa atyo hatehitiya xaotyakiye waiyexe aka exe hinamanai akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hatyaoseta xaotyakiyaho kakoa waiyoretere nehena Jesus hiye: — Ehekore, Xaotyakisatiye! Aliterexe atyo hiraeta. Enore atyo haterore, maisa atyo hatehitiya aka. ");
INSERT INTO pabNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hoka ehekoretaiya wawaiyehena kaiserehare Enore, wisaonehena exema maniya takita, wahekohena exema maniya takita, exahe waiyateretyoa wawenane ekoamaniya kakoa. Ehekoreta tehitiyaiya wawaiyehena haiyanae wawaiyetyoawitere akereta. Hiyaiya, waiye tyakekotyaka atyo exe hinama xaotyakiyahonai. Kirakahare kaxaisaka hoka kafetatyakitere exahe xoalini hare kafetatyakitere hare Enore ana xahehare nawaiye atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus ana waiyekehalaka xaotyakiyaho kakoa waiyoretere xekoaxala hawaiyore kakoa hoka nexa ihiye: — Hiso atyo maisa sekohetere hawenane Enore koamaniya nawenatyakaho nonitata — nexa. Hatyo najikinita maisa xala hare kinatyatyako axehititene. ");
INSERT INTO pabNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hatyaoseta Jesus aotyakijita Iraexatyakalati Hanako hoka axehena: — Aliyakereya xaotyakiyaho kakoa waiyoreterenai Enore Kalorexe Aohenere atyo Davi jikolahare aohenaha? ");
INSERT INTO pabNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hiyaiya, Isekohaliti Waiyexe atyo Davi kaxaehakoretya hoka exakere xairatya: “Nexa Xekohaseti Noxekohase hiye: Hisokehena nofihini maniya hahalakoaharenai hikiji katyahe namohenere kijiya”. (Enahalakoaharenai mehotyaka xaokaka nikareta iraeta.) ");
INSERT INTO pabNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hiyaiya, Davi atyo Haxekohase tehitiya aokene. Hoka aliyakereya Cristo atyo Davi jikolahare kaxaokakehena? nexa. Nikare Jesus iraeta hoka halitinai awaiyetya iniraene. ");
INSERT INTO pabNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hoka aotyakihena halitinai hoka nehena: — Xiriharira Xaotyakiyaho kakoa waiyoreterenai kakoa. Hatyonai atyo awaiyetyahitaha haetonaneha imiti waiyeharexe ako, exahe wetekokoa hoka kasani halitinai haxaiminiraha kakoa katyawaxaha ihiyeha aokahitaha. Xanehenaha xahohisakoatyakalati hanako hoka waiyexe okahakalati koa tyokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Exahe nakairati hekohena hoka hatyoha hotohare waiyexe okahakalatikoa tyokaha aokowiyahitaha hoka kanakairahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xakore hoka mehotyahitaha, kaiwahitaha wainiyaneneronai xiyehalo. Hoka teraharetyoaha aokowihenaha hoka waha tahi Iraexatyahitaha. Hatyo hiyeta iniyalahare kaxomokakehenahere atyoite exahehare niyalahare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Haxowaka Jesus Iraexatyakalati Hanako tyaonita hoka olo xomokakala haliya tyokita hoka wahakoita, aliyakere xamani halitinai mokita olo hatyoako hoka. Kahare haiyaharenai kaoloxerenai kalore olo mokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Hatyaoseta hatya ohiro wainiyanenero maoloxahalo hikoa hoka hinama olo hokose kirane xaimanexe moka olo xomokakalako. ");
INSERT INTO pabNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hatyaoseta Jesus kawisa haxaotyakiraharenai hoka nexa: — Aliterexe nomita xihiye, exe ohiro wainiyanenero maoloxahalo atyo exahehareha isa. ");
INSERT INTO pabNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hiyaiya, haiyanai atyo kamawanetere hiyeta isahitaha. Hoka exe atyo maoloxahalo xakore hoka tyotya haoloxa haxiyehalo niyahare atyo isa — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hatyaoseta Jesus hikoahetehena Iraexatyakalati Hanakota hoka hatya exaotyakirahare nehena ihiye: — Xaotyakisatiye, hiyaiyehena, kaxiyani waiyehare exe sehalinai exahe exe hatinasenai hoka! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hoka Jesus nexa: — Xoana, hiyaita exe hatinasenai? Haxowaka ferakenite tyotya exe hiyaiyitereharenai kamawenekoaretyakeheta. Hoka maisaiya hatya sehali hatya sehali heno tyaohitita — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hatyaoseta Jesus xane Oliveiras tyairiya heno tyoka hoka wahakoita ene Iraexatyakalati Hana ana hoka Pedro, Tiago, João, André xoaha hawawaharenaiha heko axehenahene: ");
INSERT INTO pabNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","— Xoana xowakaite hatyoharenai kaotyakehena? Xoare hotohare ite kaotyakehena hoka hotikihena hatyoharenai ferakene? ");
INSERT INTO pabNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hatyaoseta Jesus aotyakihenahene: — Xirihalira hoka maisa xala hare maoseraita xiso. ");
INSERT INTO pabNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kahare tyaite kaotyakehenaha néxare kakoa hoka nehenaha: “Natyo atyo Enore Kalorexe Aohenere”, nehenahaite. Hoka kahare halitinai maoserahenaha. ");
INSERT INTO pabNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","— Awatyo ximairehena, xasemehena xaisakakoati nemahare, exahe xaisakakoati tahi hoka. Tyotya hatyoharenaite kaotyaka, xakore hoka maisa atyoite imiyanaosehenere. ");
INSERT INTO pabNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hahotyalihare ite xane hahotyalihare kakoa aisakakoahena, exahe hakoatare ite xane hakoatare kakoa aisakakoahena. Haiyanai koaite waikohe tatakoahena, exahe nakitite tyaohena. Hatyoharenai atyoite hetati xoima kawetere akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","— Maika xirihare xisaona. Hiyaiya, xikaberexotyakaite hoka xikakolatyakaite xekohasetinai ana, exahe xikamokonasetyakaite militihi kakoa xahohisakoatyakalatinai hanako. Nohiyitite xikakolatyaka kalorexenai, xekohasetinai nahalakoa hoka xiyakaite ihiyeha Iraeti Waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Imiyaniki ferakene nahitita atyoite Iraeti Waiyexe kaxakaisaka tyotya halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Maika berexohenaha, kolahenaha xiso kalorexenai ana hoka awa atyo ximawaiyehare xiraehenerehare tahi kakoa nahitita. Hoka maika xiyane xahikoahena hoka xirae Enore aokiterehare. Hiyaiya, xiraehenere hare atyoite maisa xiraene xini, xakore hoka Isekohaliti Waiyexe nalitare atyoite. ");
INSERT INTO pabNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","— Kahare haiyaharenaite haximarenenai kaiserehare isehena kaxaisakaha maheta, exahe nikaretaite enexenaiha haisaninai mohenaha. Hoka ityaninaite kahalakoahare hanexenaiha kakoa hoka axaisakihenenite. ");
INSERT INTO pabNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tyotyahaite kirawaneha xiso nohiyiti, xakore hoka xala xamani atyoite heko kinatere tyaona nokoamaniye imiyanaose kijiya hoka hatyo atyoite kaiyakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hoka Jesus nehitiya: — Maika xiyaiyehena “kaheneharexe, exahe wenati xaiyalaharetyasehare” emawenanehare akiti nali hoka maika xala xamani Judéia nali tyaonita hoka tekoahenaira tyairinai koni xeta. (Maika hatyo “kaheneharexe, exahe wenati xaiyalaharetyasehare” aokitere ekaixarityasehare ana waiyekehalaka). ");
INSERT INTO pabNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Maika xala xamani hahana heno tyaonita hoka tekoahena rotitaira hoka awa atyo isoahetehena hoka xoalini hare iyehetehena. ");
INSERT INTO pabNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Maika xala xamani mase tyaonita hoka awa atyo haikoahetehena hahana xeta haima kolaheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kaxíyani, hatyo xowakiya atyoite howitihare tyaohena tifalonai exahe xoimaisanironai ana hoka! ");
INSERT INTO pabNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Maika xiraexatya Enore hiye hoka maisa hatyoharenai tihere xowaka kaotyakita. ");
INSERT INTO pabNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Hiyaiya, hatyo xowakehena atyoite hoka wenati atyo ite howitihare tyaohena. Maisa xoana xowaka nikare tyaonare Enore tyomehenere waikohekoa xowakiyata, hoka maisaiya atyo nikare tyaohitita haxowakiya. ");
INSERT INTO pabNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Xakore hoka Xekohaseti atyo aikiranitya hatyo wenati howitiharexe ferakenenai. Maisaiya nikarexe hoka maisaiya xala hare makamanehare tyaonita. Xakore hoka Enore iyeheta aokowihenerenai hiyeta atyo hatyo ferakenenai kaxaikiranityakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","— Maika hatya nehena xihiye: “Xiyaiyehena, Kalorexe Enore Aohenere ali tyaonita”, nehena xamani, “Owene tyaonita”, nehena hoka awa atyo xityakekone. ");
INSERT INTO pabNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Hiyaiya, kaotyakaite iraeti xakaisaseharenai exahe Enore Kalorexe Aohenere metalaharenai hoka tyomahaite kahare xoalini hare maomakahare katyakekotyaka maheta, hoka maoserahenaha haliti. Exahe aiyateretyoahaite maoseratyaha maheta Enore haomanerehare aohenerenai. ");
INSERT INTO pabNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","— Waiyira xasema: exe harenaitya noxakaita xihiye kaotyakehenere nahitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Hatyaoseta Jesus nexa: — Hatyo howitihare tyaohenere ferakenenai najikinitaite kamaite makaliro tyaona, exahe kaimare ite hoka maisa aokanahitita. ");
INSERT INTO pabNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Xoresenaite exoa enokoata, exahe enokoa kinatere tyaoniterenaenite maiyaterehare tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","— Hatyaosetaite Haliti Ityani kaotyakehetehena kaiminiti koni hoka exoahetehena kalore haiyatere kakoa, hawerokene kakoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hoka axikatyaite anjonai hamaniya xakini hoka ahohisakoatyahaite Enore haomana aohenerenai waikohekoa tarenai — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Hoka Jesus nehitiya: — Waiyexira xasemehena halohalo kate tahi. Hiyaiya, ekanonai atyo tihorehetehena exahe ehanahinai atyo hikoahetehena hoka waiyekehalakita atyo xomana enonenehetehena. ");
INSERT INTO pabNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nikareta tehitiyaite exeharenai kaotyakehena hoka waiyekehalakaira xomana Haliti Ityani okoi haikoahetehenerehare. ");
INSERT INTO pabNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","— Exehalira xotya: exeharenai tyaite kaotyaka exe kasetatereharenai makamaneharene nahitita. ");
INSERT INTO pabNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Enokoa, waikohe harenai tyaite maiyareheta, xakore hoka niraeni tyatyoite tyaota mene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hoka Jesus halakihena hairaene hoka nehena: — Eferakene, exowakehena harenai tahi atyo maisa xala hare ana waiyekehalakere. Maisa atyo anjonai enokoa tyaoniterenai ana waiyekehalakere, maisa atyo Enore Ityani ana hekoti waiyekehalakere. Xakore hoka enexe Enore ana taita atyo waiyekehalakita. ");
INSERT INTO pabNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Maika xikaxaikoawi exahe xirihare. Hiyaiya, maisa atyo waiyekehalakere xomana hatyo hare ferakene kaotyakene. ");
INSERT INTO pabNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","— Hatya haliti hahana halakisa hoka seko akiya xanetere akeretaite. Hoka haxanene nahitita irae hawakaneharenai hiye hoka ehateneha inihatyakaha halakijitere enomanaha hoka xisoakalati kaxaikotyasehare wakatya hoka kaxaikotere akereta atyoite. ");
INSERT INTO pabNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hatyo hiyeta xikaxaikoawihena. Hiyaiya, maisa atyo hati xekohasehare kaokeneheta waiyekehalakere xomana. Xoana makakoahena xamani, xoana wahaxati xamani, xoana ferakoa maniyehena xamani, xoana weta xamani. ");
INSERT INTO pabNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Hoka eharehena rotita kaokehetehena hoka maisa xisemakitata waiyita xiso maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","— Niraetere xihiye atyoite niraehena tyotya enomanaha: maika xikaxaikoawihena — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hinamaki ferakene taitehena hisehaliti Páscoa naheta, nakairati makaorehetyakahare xoaha naheta hoka sacerdotenai xekohaseharenai, xaotyakiyaho kakoa waiyoreterehare harenai hametenetaha otokaha Jesus hoka aisahene aokowiyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hoka nexahitaha: — Maisaiya nikare wisaonita hisehaliti xowaka, halitinai maisa eharahitaha wihiye maheta — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hoka Jesus wenakalati Betânia nali, Simão jijikoahiti tawanehare hanako tyaonita hoka kanakairita ene hoka hatya ohiro tyoa tinihaliti waikohe iyomehero nomakere akore kaisero airaxero waiyexe exahe károre kakoa. Hoka ehoka hatyo tinihaliti hoka owika airaxero Jesus seri heno. ");
INSERT INTO pabNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hoka haiyaharenai nali tyaoniterenai ehareha hoka nexa kakoaha: — Xoare maheta exakere kalore ametakijitene? ");
INSERT INTO pabNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hiyaiya, airaxero atyo waiye betetyaka 300 olo hokose xaimanexe hoka kaxekakaiya maoloxaharenai ana — nexaha. Hoka kirawaneha ohiro ");
INSERT INTO pabNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","xakore hoka Jesus nexa: — Xahalakihena exe ohiro! Xoanere hoka xexamaikohalonikihenene? Hiyaiya, waiyexe atyo tyoma nomani. ");
INSERT INTO pabNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hiyaiya, maoloxaharenai atyoite tyaota mene xikakoa hoka xoana xowaka xamani atyoite xakahinaetyahene xaokowihena hoka xakahinaetyahene. Hoka natyo atyoite maisa notyaota minita xikakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Háomane heko atyo tyoma: hiyaiya, nokamani nahitita atyo tyoa airaxeharetya noháre, noxafityaki niyahare. ");
INSERT INTO pabNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aliterexe nomita xihiye: hakakoare waikohekoa atyoite, aliye xamani Iraeti Waiyexe kaxakaihakatyaka hoka kaxakaisakaite exe tyomehenere hoka kaxotyakehetaite exe ohiro — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hatyaoseta Judas Iscariotes, 12-hare exaotyakiraharenai konitare irae sacerdotenai xekohaseharenai kakoa, Jesus hamatawala enomanaha tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hatyohare tahi semaha hoka ihalahareha hoka olo isaha enomana aokowiha. Hatyo najikinita Judas ahekohena Jesus hamatawala tahi akiti kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hatyaoseta hetati ferakene, nakairati makaorehetyakahare xowaka, judeunai kalanero aisaha hoka Páscoa ferakene otehenahititere ferakene xane hikoa hoka exaotyakiraharenai axaha Jesus: — Aliye nali wisoma nakairati Páscoa niyahare haokita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hoka Jesus axikatya hinamahare haxaotyakiraharenai, nexa ihiyeha hoka: — Xiyanehena wenakalati nali. Hoka nalite hatya haliti one kolaita hoka ahalakoatya xiso. Hoka hatyo haliti xemaite xiyane. ");
INSERT INTO pabNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hoka maika xexa hati xekohasehare hiye, aliyeri ako xamani isoa hoka. “Xekohaseti exakere waxa aokita: ‘Aliyako tyaonita hatyo hatyako hoka natyo, noxaotyakiriharenai xoaha kakoa nokanakairi hoka wotyaxemaheta Páscoa ferakene?’ ” ");
INSERT INTO pabNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hatyaosetaite hotikisa xomana kaloakore hatyako ehaore ako, exomokakotyakahare exahe memere. Hoka nalite tyotya xisoma womana — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nexa hoka hatyo hinamahare exaotyakiraharenai xaneha wenakalati xeta. Hoka Jesus aokitere akereta waiyaha. Hoka tyomaha nakairati Páscoa niyahare. ");
INSERT INTO pabNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Makehena hoka Jesus kaoka 12-hare haxaotyakiraharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kanakairahitaha mexakoa hoka nehena: — Hatya xinekonitare kanakairitere nokakoite matawahena natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nexa hoka amaikohareha hoka hatya xakini axehenahene: — Xoana maisa natyo xini haokita? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hoka Jesus nexa: — Hatya xinekonitare. Hatya nohakakoani balatoahekoa maikitere nakairatite matawahena natyo. ");
INSERT INTO pabNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hiyaiya, Haliti Ityani atyoite wainihena, Iraeti Waiyexe iraetere akereta. Xakore hoka kaxiyani, kirakoane ite tyaohena Haliti Ityani matawahenere! Kaxiyani, waiye kaiserehareya atyo mawenanehareta tyaonare hoka! nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hatyaoseta kanakairahitaha hoka Jesus iya nakairati hoka iraexatya Enore hiye. Hatyo najikinita taikasetene hoka isene haxaotyakiraharenai ana hoka nehena: — Xotohena, xikanakairahenene, exe atyo nohare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hatyaoseta iyehitiya erakakalati hoka iraexahitiya Enore hiye. Hoka isehitiyene haxaotyakiraharenai ana hoka tyotyaha terahene. ");
INSERT INTO pabNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hatyaoseta Jesus nehena: — Exe atyo notimalaxi, kaxiratyaka kahare haliti hawaonita. Exe timalati hiyeta atyo waitare wenati tyaona halitinai ana Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Aliterexe niraeta xihiye, exaoseta atyoite maisa noterehitita exehare vinhoxa. Exaoseta atyoite Enore nali taita noterehitiya waitare vinhoxa — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hatyaoseta xeraha haxaka xerati hoka xaneha Oliveiras tyairiya nali. ");
INSERT INTO pabNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Xane kaokaha hatyo nali hoka Jesus nexa haxaotyakiraharenai hiye: — Exe xatinite xahalakihena natyo. Hiyaiya, iraiti waiyexe kaxairatyakehenere atyo nexa: “Naisaite kaxaikotyatiye hoka tyotyaite ekaxaikoneharenai xaore”. ");
INSERT INTO pabNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","— Hoka hatyo najikinitaite, nokaseheta hoka noxani xaheta maniya Galiléia xeta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nexa ihiyeha hoka Pedro nehena: — Maisaiya atyo nahalakijita hiso, exahe tyotya haiyanai halakisa hiso hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hatyaoseta Jesus nexa Pedro hiye: — Exehalira hotya: awisa xatinite, takoira makawiraharene hinamaki nahititaite, hanamaki hateraharetyoa. Himawaiyanenehare ite haoka natyo — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Xakore hoka Pedro kahaliki nikareta aiyateretyoa irae: — Maisaiya xoana hekota nomawaiyaninihare naokita hiso, exahite kotare nowaini hihakakoane — nexa. Tyotya exaotyakiraharenai nikare makere iraeha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hatyaoseta Jesus xane Getsêmani aokahitere nali haxaotyakiraharenai kakoa. Xane kaokaha hatyo nali hoka Jesus nehena ihiyeha: — Xisokehena ali niraexahenere nase — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hatyaoseta noloka Pedro, Tiago, João xoaha. Hatyaoseta Jesus kehexa kalore haxamaikoharene, hamawaiyeharene, ");
INSERT INTO pabNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","hoka nehena: — Kalore noxamaikohalini nokihixita nohiye, motya aijita ene natyo. Alitehena xiso hoka xikaose hoka xiyaiyahokotyoa nohakakoani — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hatyaoseta xanehitiya sekose aka hoka totahi waikoa hoka axa Enore, kasani emaisaheta enonita nikare kaxomokakehenere nonitata aokita hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hoka exakere iraexatya: — Abá! Hisoiya atyo tyotya xoalini hare hisoma. Hoka maika hemaisahetehena exe erakakalati noxemakawatikisase noniti. Xakore hoka maisaiya atyo naokitere akereta xini kaomaka hoka maika atyo haokitere akereta kaomaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hatyaoseta haikoaheta hoka waiyehena atyo hanamahare exaotyakiraharenai atyo nemakita hoka nehena Pedro hiye: — Xoana hisemakita, Simão? Xoana maisaiya ini hekoti hikaose hoka hiyaiyahokotyoita? ");
INSERT INTO pabNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Maika xikaose xiyaiyahokotyoa exahe xiraexatya maisa xikahasakaharetyakita maheta. Hiyaiya, maisa xakore iniyalahare maniya xisaona xaokowiye hoka xiháre atyo maisa kinaterexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hatyaoseta xanehitiya hoka iraexahitiya, hetati iraetere akereta. ");
INSERT INTO pabNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hatyaoseta haikoaheta haxaotyakiraharenai ana hoka nemakahitaha waiyehenahitiyene. Enemakaha kalore kaweta hoka maisa kaosexeha. Hoka maisa aliyakere Jesus ana ekoaxatyareha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hatyaoseta Jesus haikoaheta ehanamakinihena hiye hoka nexa: — Xoana xisemakitata, xikawinitata? Nikahena, enaosetya xane hikoa. Xiyaiya, Haliti Ityani atyo kamatawatyakehena iniyalahare nomaseharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Xatityoahetehena hoka wiyaneheta. Xiyaiya, owehena haliti nomatawatyasehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus iraetata ene hoka Judas kaoka, 12-hare exaotyakirahare konitare. Kahare haliti tyoa exema, kesekase, atyalihose harenai kakoare. Sacerdotenai xekohaseharenai, judeunai nawenatyakaho kakoa waiyoreterenai, exahe judeunai nityohalitiranai harenai xaxikala xema tyoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ematawatyasehare Judas koxaka irae ekakoaha hoka aimenekohena enomanaha hoka nexa: — Nasohitanakolihenerira xotoka hoka xakolatya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hatyaoseta kaoka hoka xane rota Jesus haliya hoka nehena ihiye: — Xoana waiye hisaonita, Xaotyakisatiye? nexa hoka sohitanakolisene. ");
INSERT INTO pabNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hatyaoseta otokaha Jesus hoka olatyahene. ");
INSERT INTO pabNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Hatyaoseta hatya nali tyaonitere iya kesekase hoka mokotya sacerdotenai xekohasehare wakanehare hoka aikotya itinihe. ");
INSERT INTO pabNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hatyaoseta Jesus nexa ihiyeha: — Xoana hoka xisoa xotohena, xolahena natyo maheta hoka kesekase kakoa, atyalihose harenai kakoa xisoa nomani? Hoka xalijiniharexe akereta xamoka natyo. ");
INSERT INTO pabNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wáhakiya notyaonita xinekoni hoka naotyakijita haliti Iraexatyakalati Hanako hoka maisa xotokare natyo. Xakore hoka Iraiti Waiyexe xakaihenere akereta atyo kawenatyaka maheta exakere xamoka natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hatyaoseta tyotya exaotyakiraharenai halakisaha Jesus hoka tekoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hoka hatya xoimahaliti, imiti taose kakoa olalisoare taita, xaneta Jesus xema hoka haiyanai otokahene aokowi. ");
INSERT INTO pabNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Xakore hoka halakisa imiti taose ekahekoaha hoka tekoa, maimahiro. ");
INSERT INTO pabNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hatyaoseta xaneha Jesus kakoa sacerdotenai xekohasehare hana nali. Koxaka hatyo nali exekohasenaiha hohisakoahitaha, judeunai nityohalitiranai exahe enawenatyakaho kakoa waiyoreterenai harenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro xane Jesus xema sekoseta, xane isoa sacerdotenai xekohasehare hana talalahoko ako. Hoka xane tyoka irikatyaose wakaharenai haliya jijikoa maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hatyaoseta sacerdotenai xekohaseharenai, tyotya kalorexenai xakore sema aokowiha xoalini hare Jesus tahi akiti hoka aisahene aokowiha hoka maisa xoare hare semahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kahare iraeha etahi hamaoseralaha. Xakore hoka hawarehare xakini xakaiha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hatyaoseta haiyaharenai tityoaha hoka Jesus iraeharehenaha hamaoseralaha hoka nehenaha: ");
INSERT INTO pabNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","— Wasema iniraene exakere: “Namawenekoarehetaite exe Iraexatyakalati Hana halitinai tyomehenere hoka hanamaki ferakene kakoa taitaite notyomehetene. Hatyo atyoite maisa halitinai nómane xini”, nita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nexaha xakore hoka hawarehare xakini xakaiha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hatyaoseta sacerdotenai xekohasehare tityoa enekonitaha hoka axehena Jesus: — Xoana maisaite xoare hiraeta exe hiraeharetyaka nahalakoa? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Xakore hoka Jesus mema tyaona, maisa xoare nexa iraeta. Hatyaoseta sacerdotenai xekohasehare axehitiyene: — Xoana, Enore Waiyexe Ityani hiso, Enore Kalorexe Aohenere hiso? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Hoka Jesus nehena: — Há, natyo. Xityotyaite xiyaiyehena Haliti Ityani nokane Enore kinaterexe haliya, ifihini maniya, exahe exexoaneheta kaiminiti konita enokoata hoka — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hatyaoseta hatyo sacerdotenai xekohasehare haima halalaka (hotikisa maheta haxamaikoharene) hoka nehena: — Maisaiya atyo xoare maheta etahi akiti hatya xakai wihiye waohitita. ");
INSERT INTO pabNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Xiyaiya, xasema atyo iniraene iniyalahare Enore akiti. Xoanaite wamohenene? nexa. Tyotyaha kahalakoaharahitaha Jesus kakoa hoka exaisaka aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hatyaoseta haiyaharenai xataholisene, talatihotyahene hoka mokotyahene hoka nehenaha: — Hotehena, xalatya mokotya hiso? nexaha. Exahe sorarenai tehitiya otokene hoka mokotene. ");
INSERT INTO pabNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ekatyahexe talarehoko ako tyaonita ene hoka hatya sacerdotenai xekohasehare wakanehalo hikoa enomana. ");
INSERT INTO pabNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hoka waiya Pedro jijikoane irikati haliya, hoka waiye wahakotya enomana hoka nehena: — Hiso tehitiya ene Jesus Nazaré yere haliya hisaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Xakore hoka teraharetyoa hoka nehena: — Maisa atyo nowaiyanihare xini, exahe maisa waiyekehalakere nomani hatyo hiraetere akiti — nexa. Nexa hoka hikoaheta hatyo nalita. Hoka xane talarehoko xisoakala maniya. Hatyo xowaka takoira kawihena. ");
INSERT INTO pabNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hatyaoseta hatyo wakahalo waiyehitiya Pedro hoka nehena nali tyaoniterenai hiye: — Exe haliti atyo enekonitareha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Xakore hoka Pedro teraharetyoahitiya. Hatyaoseta mawaheneta hoka nehenahitiya ihiye nali tyaoniterenai: — Aliterexe atyo enekonitareha hiso. Hiyaiya, Galiléia koa tare atyo hiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hoka Pedro nehena: — Maisa atyo nowaiyanihare xini hatyo haliti xiyakaitere. Alitere naokita. Ikoiya namaoseraita hoka ehekoretaiya Enore hatyohare hiyeta iniyalahare moka natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hatyo xowaka takoira kawihitiya, hatyo kakoa hinamakihena kawijita. Hoka Pedro oteheta Jesus niraene: “Takoira hinamaki makawiraharenetaite hanamaki hateraharetyoa, himawaiyanenehare ite haoka natyo”, nehenere. Hatyaoseta Pedro kehexaharetyoaheta hoka tiyahena. ");
INSERT INTO pabNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kamaetali witita sacerdotenai xekohaseharenai, ahohisakoatyakakoaha judeunai nityohalitiranaiha, judeunai nawenatyakaho kakoa waiyoreterenai harenai kakoa hoka iraekakoaha. Hatyaoseta Jesus kolatyaha hoka xaneha ekakoa kalorexe Pilatos nali. Hoka isahene enomana. ");
INSERT INTO pabNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hoka Pilatos axene: — Xoana, judeunai xekohase kalorexe hiso? nexa. — Hiso atyo nikare hiraeta — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hatyaoseta sacerdotenai xekohasenai kahare iraeharetene hoka mema tyaona. ");
INSERT INTO pabNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hatyaoseta Pilatos axehitiyene: — Xoana maisaite xoare hita? Hiyaiya, kahare iraeharetyahitaha hiso — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Xakore hoka Jesus mema tyaonehitiya. Hoka Pilatos hakaharetyoa moka. ");
INSERT INTO pabNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hisehaliti Páscoa xowakehena nihatyaka Pilatos aihikoahitita hatya berexo ako tyaoniterenai konitare halitinai xaxane xema. ");
INSERT INTO pabNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hatyo xowaka Barrabás nexarexe berexo ako tyaonita, haiyaharenai katawane akahenerenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hatyaoseta halitinai tyoaha hoka hawenanahoha akereta axehenaha Pilatos. Kasani aihikoaheta hatya berexoako tyaonitere enomanaha aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hoka Pilatos axahene: — Xoana, judeunai xekohasehare kalorexe naihikoaheta xomana xaokita? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Waiyekehalakita atyo enomana sacerdotenai xekohaseharenai nokoawaharene Jesus hiye. Hatyohare hiyeta tyoaha ekakoa enali hoka isahene enomana. ");
INSERT INTO pabNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hatyaoseta sacerdotenai xekohaseharenai aiyateretyoaha halitinai xahita. Kasani axaha Pilatos hoka Jesus wenekoare aihikoaheta Barrabás enomanaha aokaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hoka Pilatos axehenahitiyene: — Hoka xoanaite namohena exe haliti, judeunai xekohasehare kalorexe xaokitere? nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","— Haberekohenene atyalihose xaimaholatyaka hiye — nexa kawiyatya halitinai. ");
INSERT INTO pabNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","— Hoka xoaretya tyoma iniyalahare? nexa Pilatos. Hoka tyotyaha exahehare kinatyaxa kawiyatyaha: — Haberekohenene atyalihose xaimaholatyaka hiye! Haberekohenene atyalihose xaimaholatyaka hiye! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hatyaoseta Pilatos kasani halitinai emaxalokisa aokowita hoka Barrabás aihikoaheta enomanaha. Hatyo najikinita Jesus mokonasetyaka militihi kakoa aoka sorarenai hiye. Hatyaoseta halakisene enomanaha berekotyahene maheta atyalihose xaimaholatyaka hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hatyaoseta sorarenai xane Jesus kakoa kalorexe hakatyakala hanako nali hoka tyotya sorarenai ahohisakoatyaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hatyaoseta aisoakisaha Jesus imiti xotere nase ako. Tyomaha xolatyaolisoakalati katohere kakoare hoka mokahene eseri hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hatyaoseta koexahaxahenaha ekakoa hoka nehenaha: — Hawaiyeta womana, judeunai xekohase! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hatyaoseta mokotyahene eseri hiye atyakase kakoa, xataholisahene. Tyokaha hakaoliseha kakoa enahalakoa hoka motya ekoamaniya nawenatyaseharenai aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hatyaoseta halakisaha hahiralahene hoka aitoakihenahitaha imiti xotere nase ihiyeta hoka inimako aisoakihenahitene. Hatyaoseta xaneha ekakoa berekotyahene atyalihose xaimaholatyaka hiye maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Xanahitaha ene hoka ahotyaho ahalakoatyaha hatya haliti, Simão nexarexe, wenakalati Cirene yere, Alexandre Rufo xoaha nexe atyo. Maseta ene tyohitita hoka otokaha Simão hoka Jesus berekotyakala niyahare atyalihose xaimaholatyaka kolatyaka aokaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hatyaoseta xaneha Jesus kakoa Gólgota aokahitere nali. Gólgota atyo “Seriti Akerehare Aose” nita. ");
INSERT INTO pabNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Isaha xakore enomana aokowiha vinho xa kaketaxatyaka makehexaharetyoaniti niyahare mirra kakoare hoka maisa teritene. ");
INSERT INTO pabNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hatyaoseta berekotyahene atyalihose xaimaholatyaka hiye. Hatyaoseta iraka kakoaha aokowihenaha inima nase hoka hasakaharetyakakoaha, xala xamani tyaona ekakoa maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eno kamaihena hoka berekotyaha Jesus. ");
INSERT INTO pabNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Eseri haomaniya mokaha exawaiyekehalakalaha niyahare taba taose xairatise kakoare, exakerexe: ");
INSERT INTO pabNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Berekotyaha tehitiya atyalihose xaimaholatyakanai hiye hinamahare kaiwarexenai ehaliya, hatya ifihini maniya, hatya ewatone maniya xoaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nikare tyaona Iraeti Waiyexe iraehenere akereta: Haliti xalijiniharexe akereta kaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hatyo nali jiyiterenai koexahaxatyahitaha ekakoa, xalawalisaha haseriha enomana hoka nexahitaha ihiye: — Hisoiya atyo hamawenekoaretya Iraexatyakalati Hana hoka hanamaki ferakene kakoitaiya hisomehetene haoka. ");
INSERT INTO pabNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hoka hexoahetehena hiberekotyaka aoseta hoka hisota hiyoawihetehena! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sacerdotenai xekohasenai, judeunai nawenatyakaho kakoa waiyoreterenai harenai koexahaxatyahitaha ekakoa hoka nexahitaha: — Haiyanai xakoane atyo iyehitita iniyalahare nonitata hoka xoana hoka maisa hatyota iyoawihetere. ");
INSERT INTO pabNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nikahena Enore Kalorexe Aohenere, Israel yerenai xekohasehare. Hexoahetehena hiberekotyaka aoseta hoka wityakeko hiso — nexahitaha. Kaiwarexenai kaberekotyakehenerenai Jesus haliya tehitiya kirawanahene hoka aiyalatyaha enomana. ");
INSERT INTO pabNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hatyaoseta totahikoahena hoka makalirohena hakakoare waikohekoa. Heko makaliro tyaona makakoa kijiya. ");
INSERT INTO pabNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Makakoahena hoka Jesus kinatyaxa kawiyatya: — Eloí, eloí, lemá sabactani — nexa. Exe iraeti atyo exakere nita: “Nenorexi, nenorexi, xoana hoka hahalakisa natyo?” nita. ");
INSERT INTO pabNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Haiyaharenai nali tyaoniterenai semaha hatyo iniraene hoka nehenaha: — Xasemehena, kawijitaore Elias — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hatyaoseta hatya tema xane vinho xaiya mitoloka tihaharetyoakalati hoka mokene atyakase keteho hoka aimatene Jesus ana terene maheta hoka nehena: — Awijira hoka wiyaiya, xoana Elias xamanite tyoa iyehetene atya hiyeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hatyaoseta Jesus kinatyaxa kawiyatya hoka waini. ");
INSERT INTO pabNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hatyo xowaka imiti kalotaosero, Iraexatyakalati Hanako sololoitere halalakoa nekese hoka hinama taose tyaona, eno maniyata halalakoa, waikoa maniya exoaheta. ");
INSERT INTO pabNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sorare xekohasehare tityoita Jesus kaberekotyakehenere naheta maniya hoka sema ekawira, exahe waiya ekamane hoka nexa: — Aliterexe ene exe haliti Enore Ityani — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Haiyahalonai ohironai tehitiya, hatyo nali tyaonahitaha hoka sekota wahakotyahitaha. Enekoniha Maria Madalena, Salomé, Maria, Tiago xoimere exahe José xoaha nityo. ");
INSERT INTO pabNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hatyo ohironai atyo tyoaha exahe kahinaetyaha Jesus Galiléia nali tyaonitatere xowakiya. Kahare tehitiya nali haiyahalonai xanehenolonai exema Jerusalém xeta. ");
INSERT INTO pabNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Makehena hoka José kaoka. Wenakalati Arimatéia nalitare atyo. José atyo xekohasetinai konitare. Hatyo tehitiya atyahita Xekohaseti kalorexe tyoanene xahita Enore nalita. ");
INSERT INTO pabNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hatyo xowaka memere judeunai moka akatyahitaha, okoi sábado ferakenehena hoka. Hatyo hiyeta José hamamairanenehare kakoita xane axeheta Pilatos Jesus háre. ");
INSERT INTO pabNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatos hakaharetyoa, Jesus kamane sema hoka. Hatyaoseta kawisa sorare xekohasehare axene maheta, otene xamani Jesus waini hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hatyaoseta sorare xekohasehare xakai etahi hoka Pilatos halakisa José ana Jesus háre. ");
INSERT INTO pabNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hatyaoseta José imiti kese taosero iya hoka xane iyeheta Jesus háre atyalihose xaimaholatyaka hiyeta. Hoka olahisetene hatyo imiti taose kakoa. Hatyaoseta xane mokene xawatyakalati ako, sehali kalorexe kakoakotyaka ako. Hatyaoseta talirika sehali kalotaosero jihotya maheta hatyo xawatyakalati. ");
INSERT INTO pabNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Madalena, José nityo Maria xoaha wahakotyahitaha hoka waiyaha Jesus háre xomokaka. ");
INSERT INTO pabNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado ferakene najikinita, Maria Madalena, Salomé, Tiago nityo Maria xoaha, iyaha airaxeronai Jesus háre hiye mokahene maheta. ");
INSERT INTO pabNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo xowaka, witita, kamai hikoahena hoka xaneha xawatyakalati nali. ");
INSERT INTO pabNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ahoti xanahitaha hoka nexakakoahitaha: — Xalaite kikihena womana séhali xawatyakalati jihola? ");
INSERT INTO pabNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nikare irae kakoahitaha, hatyo séhali kaloli hoka. Hoka xane kaokaha hoka waiyehenaha atyo koxaka atyo séhali kakikisakeheta. ");
INSERT INTO pabNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hatyaoseta isoaha xawatyakalati ako hoka waiyaha xoimahaliti, iyomere imiti akore, tyokita ifihini maniya hoka mairaha. ");
INSERT INTO pabNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hatyaoseta hatyo xoimahaliti nehena: — Awa atyo ximaira! Waiyekehalakita nomani, Jesus Nazaré yere xatawita, etake kaberekotyakehenere atyalihose xaimaholatyaka hiye. Maisa atyo ali akeheta, koxaka atyo kaseheta. Xiyaiyaore mohenaherene aose — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","— Hoka xiyanehetehena hoka xiyakaihena Pedro hiye, haiyaharenai exaotyakiraharenai xoaha hiye. “Xanehenaite xaheta maniya Galiléia koa xeta. Nalite xiyaiyehetene iraetere xikakoa akereta”, xehena ihiyeha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hatyaoseta hikoahenahitaha hoka tekoahenahitaha xawatyakalati nalita. Mairahitaha, tatakoahitaha hoka maisa xoare xakaitaha haiyanai hiye. Kalore mairaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus atyo weta kaseheta, domingo xowaka hoka Maria Madalena ana hotohare kaotyakeheta. Hatyo nonitata atyo 7-hare isekohaliti iniyalahare axanikiheta, toahiya. ");
INSERT INTO pabNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kaotyakeheta enomana hoka xane xakaini Jesus hinaeharenai hiye, tiyahitaha exahe amaikohare ahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Semaha ekaseneheta, ekaotyakeneheta enomana hoka maisa tyakekoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hatyaoseta Jesus hawareharexe kaotyakehetehitiya hinamahare haxaotyakiraharenai ana ahotyaho, hakoa wenakalati xeta xanahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hatyaoseta haikoahenahitaha hoka hatyo akiti xakaiha haiyaharenai exaotyakiraharenai hiye. Xakore hoka maisa tyakekoahitaha hatyo hinamaharenai xakaini. ");
INSERT INTO pabNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hatyaoseta Jesus kaotyakeheta 11-hare haxaotyakiraharenai ana, kanakairahitaha hoka. Hatyaoseta ahenexatya enomanaha matyakekohenahere exahe masemaxemarehenahere haiyanai ekaseneheta tahi xakaihenahere hoka matyakekohenahere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hatyaoseta nexa ihiyeha: — Xiyanehena hakakoarekoa waikohekoa hoka xiyakaihena Iraiti Waiyexe tahi tyotya haliti hotyalinai hiye. ");
INSERT INTO pabNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xala xamani atyoite tyakeko hoka kabatixatyaka hoka hatyo atyoite kaiyakeheta. Hoka xala xamani atyoite maisa tyakekota hoka hatyo atyoite kaxawatyaka. ");
INSERT INTO pabNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hoka tyakekohenerenai ana atyoite iyateliti kaxekaka hoka exe harenaite waiyexe tyomaha: axanikihenahitahaite isekohaliti iniyalahare nexare kakoa, exahe masemakahare xako ite iraeha. ");
INSERT INTO pabNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Exahiya owi otokaha xamani, teraha xamaniya howexere hoka maisaiya xoana tyaonahitaha. Hakahenaiha ite ekaokakihenaha hokakiterenai hiye hoka kinaterehenahitaha ite — nexa. ");
INSERT INTO pabNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iraehenere ekakoaha najikinita Xekohaseti Jesus kakolatyaka enokoa xeta hoka tyoka Enore fihini maniya. ");
INSERT INTO pabNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hatyaoseta exaotyakiraharenai xane tyotya wenakalatinai hakakoarekoa Iraeti Waiyexe xakaiha maheta. Hoka Xekohaseti kahinaetyahene, xoalini hare waiyexe tyomehenaha hoka hatyohare hiyeta halitinai tyakekoha exakainiha maheta.");
INSERT INTO pabNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Xekohaseti Teófilo: Kahare haiyaharenai atyo aiyateretyoaha xairatyaha maheta xoalini hare kaotyakehenereharenai winekoni tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Xairatyaha atyo xakaihenaherehare wihiye, hatyoharenai waiyehenereharenai hetati xowakiyata, exahe xakaihenahere iraiti tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hatyo hiyeta, xekohaseti, tyotya nawaiyore, aliyakereta xamani hatyoharenai kaotyakehenerehare hetati xowakiya kakoa, hoka nahekotya hoka kasani tyotya hatyoharenai waiyekehalaka naxairaheta homana naokowi, ");
INSERT INTO pabNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","waiyekehalaka homana maheta, iraiti aliterexe tahi kakoa hikaxaotyakisakehenerehare. ");
INSERT INTO pabNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes kalorexe tyaonitere judeunai waikoherakoa xowaka Zacarias nexarexe sacerdote tyaonita. Hatyo atyo sacerdotenai Abias hotyalinai konitare. Exanityo atyo Isabel nexalolo, hatyo tehitiya atyo sacerdotenai ityaninai konitalo. ");
INSERT INTO pabNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hatyo haiyanityo kakoarenai waiye maniya taita tyaonahitaha Enore haotita, exahe tyakekoahitaha aliterexe Xekohaseti xaotyakiraho exahe niraene. ");
INSERT INTO pabNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Xakore hoka maisa kaisaniyeha, Isabel maisanityakohalo hoka. Exahe hatyo hinamanai koxaka ohiyeha hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Haxowakiya Zacarias tyomita hahatene sacerdote hatene harero Enore haotita, enómane xowakehena hatyo hateniti ferakiti nihatyaka tyomahitere hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sacerdotenai nawenanaho akereta axikatyahene keratya maheta incenso ekeratyakalaose. Hatyo hiyeta isoa Xekohaseti anere Iraexatyakalati Hanako. ");
INSERT INTO pabNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hoka incenso keritere nase halitinai menanakita iraexatyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hatyaoseta hatya anjo Xekohaseti nalitare kaotyaka Zacarias nahalakoa, tityoare keratyakalati aose fihini maniya, incenso keritere nali. ");
INSERT INTO pabNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hatyaoseta Zacarias waiyene hoka maira, exahe maisa aliyakere tyaona xaka mokene. ");
INSERT INTO pabNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Xakore hoka anjo nexa ihiye: — Awa atyo himaira, Zacarias! Enore sema hiraexala. Hexanityoite hamokose kaisani hoka João nexarexe ite hakaexaretene. ");
INSERT INTO pabNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tyaonaite hoka himaxaloite ekakoa, exahe haiyanaite hoka maxalo ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hatyo atyoite kalorexe tyaona Enore ana. Maisaiya atyo vinhoxa terita, kawexere harenai. Isekohaliti Waiyexe kakoare atyoite tyaona tyaohenere ferakenitita. ");
INSERT INTO pabNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hoka kahare ite Israel hotyalinai Xekohaseti koamaniya axomoka nikisa, Israel yerenai Nenorexa koamaniya. ");
INSERT INTO pabNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Enore niraene xakaisasehare akeretaite tyaona, exahe kinatere ite iraiti xakaisasehare Elias akereta. Hatyoite aotyakisa nexekatinai, ityaninai hoka mehexaikohare tyaonaha, exahe masemaxemalaharenaite axomokanikiheta wenati waiyexe maniya. Hoka memere ite moka Israel hotyalinai Xekohaseti kaokene niyahare. ");
INSERT INTO pabNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Hatyaoseta Zacarias axa anjo: — Aliyakeriya hatyoharenai notyakekohena? Nonityohaliti kaiserehare, nexanityo tehitiya hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hoka anjo nexa: — Natyo atyo Gabriel, Enore wakanehare. Hatyo atyo axikatya natyo noxakai hihiye maheta exe iraiti waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Maisa atyo hityakekota niraeni, xakore hoka hatyoharenai atyoite enaose xowakehena hoka kaotyaka. Hoka maisa tyare atyo hityakekota hoka himairaenehare ite hisaona, exahe maisaite hiraehitita hityani tyaohenere ferakene kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hatyo nase halitinai atyahitaha Zacarias, exahe tyotyaha hakaharetyoahitaha ehowitiharene Iraexatyakalati Hanako kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hikoaheta hoka Zacarias maisa iraehitita. Hatyaoseta waiyekehalaka enomanaha xoalinihare ewaiyane Iraexatyakalati Hanako. Maisa iraexe hoka aimenekokoatya hakahenai kakoa halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hatyaoseta Zacarías miyatya hahatene Iraexatyakalati Hanako hoka xaneheta hawenakala xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hatyo najikinita, maisa wahita hoka, exanityo Isabel tifalo hoka 5-mijini maisa hikoare hekoti hahanakota. Hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","— Kalikini tyare atyo Xekohaseti kahinaetya natyo hoka maisaiya atyo xalahare kirawanehitita natyo nomaisanihaloni hiyeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Hatyaoseta 6-mijinihena Isabel tifalo tyaonita hoka Enore axikatya anjo Gabriel hatya wenakalati Galiléia koa, Nazaré aokahitere nali. ");
INSERT INTO pabNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hoka hatyo anjo atyo kolaita iraiti hatya mawatyalisakahalotatere okoi kaiyanenehenolo hatya haliti José nexarexe kakoa ana. José atyo xekohaseti Davi jikolaharenae konitare. Hatyo mawatyalisakahalotatere atyo Maria nexalolo. ");
INSERT INTO pabNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hatyaoseta anjo tyoa hoka nexa: — Hihalalohena, Maria! Hiso atyo waiye hikaxomokakita. Xekohaseti atyo kaxaikota hiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hoka Maria sema anjo niraene hoka maisa aliyakere tyaona xaka mokene. Hoka hahakahalotyoane kakoita ahekohena, xoare nexa xamani ala iraeta hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hatyaoseta anjo nehitiya: — Awa atyo himaira, Maria. Enore atyo ihalahareta hikakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hitifaloite. Hawenakisaite hityani hoka hakaexaretene ite Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hatyo atyoite kalorexe haliti tyaona hoka Enore Maxaixahityakahare Ityanite kaxaokaka. Xekohaseti Enore atyoite kalorexe mokene, enahetahare Davi akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hatyo atyoite Jacó jikolaharenai xekohase tyaota mene. Kalorexe enawenane atyoite maisa xoana hekota tyotita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hatyaoseta Maria nexa anjo hiye: — Hatyoharenaiya maisa aliyakere. Hiyaiya, nomawatyalisakihalotata atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hoka anjo nexa ihiye: — Isekohaliti Waiyexe ite tyoa homana hoka Enore niyatere ite tyaona hikakoa. Hatyo hiyetaite xoimaite waiyexe, exahe Enore Ityani kaxaokaka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hotehena hihinaehalo Isabel. Maisaiya atyo kaisanita aokahitaha. Xakore hoka kalikini atyo 6-mijinihena tifalo tyaonita, inityohaloti xakore hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hiyaiya, Enore ana atyo maisa xoare hare maomakahare aka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hoka Maria nexa: — Natyo atyo Enore wakanehalo, maika haokitere akereta nokaxomokaki — nexa. Hatyaoseta anjo xaneheta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hatyaoseta haiyakinai ferakene najikinita, Maria tyakaihalotyoa hoka ihalahalo xane wenakalati tyairinai koni tyaonitere, Judéia koa nali. ");
INSERT INTO pabNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Xane kaoka hoka Zacarías hanako isoa hoka Isabel hiye katyawaxa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria katyawaxehena Isabel hiye hoka ityani moxomoxo ityakota. Hatyaoseta Isekohaliti Waiyexe tyaonita ekakoa hoka ");
INSERT INTO pabNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Isabel nexa kinatyaxa: — Hiso atyo waiye hikaxomokakita tyotya ohironai koniyata, exahe xoima hikaisanihenere tehitiya atyoite waiye kaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hoka xala ala natyo hoka Noxekohase nityo tyoa waiyita natyo? ");
INSERT INTO pabNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hikatyawaxehena nohiye hoka xoima ihalahare hoka moxomoxo nohiye notyakota. ");
INSERT INTO pabNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Hiso atyo hawaiye. Hiyaiya, hityakekota atyo kaotyakehenerehare, Xekohaseti iraehenerehare hihiye — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hatyaoseta Maria nexa: — Nihalahalota Xekohaseti kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nihalahalota Enore hiyeta, nisekohalo Niyaseheta hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Hiyaiya, oteheta atyo natyo hawakanehalo, wakahalo taita xakore atyo natyo hoka. Kalikinita atyoite tyotyaha ohiro waiye xomokakolo aohenaha natyo. ");
INSERT INTO pabNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hiyaiya, Enore kinaterexe atyo kalore waiyexe tyoma nomani. Enexare atyo waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hotikijita atyo hawaiyexehare tyotya aiminijitereneharenai ana, tyotya ehotyaliharenai konitare tyaonitereharenai kakoita ana. ");
INSERT INTO pabNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aimatya atyo hakahe kinaterexe hoka jiyahaotita aokowiharetyoitereharenai exahekolanaiha kakoita. ");
INSERT INTO pabNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kikihitita atyo enokahakalanai henota kalorexenai kinaterexenai, hoka mokita atyo waiyexeharexenae kalorexe tyaonaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kalore atyo ijita nakairati nakitereharenai ana hoka axikahitita atyo kaxiyeharexenai eháreha firereta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Iraehenere wahetakomaniyereharenai hiye akereta atyo tyoma hoka kahinaetya hawakaneharenai Israel hotyalinai. ");
INSERT INTO pabNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Oteheta hahotikira hawaiyexehare Abraão ana, tyotya ijikolaharenai xoaha ana hoka heko awaiyetyahene aokowihenerehare. ");
INSERT INTO pabNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ala xoana xamani hoka hanama mijini hare tyaona Isabel haliya. Hatyo najikinita xaneheta hahana xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hatyaoseta Isabel ityani nawenanaosehena hoka tyaona enamokose. ");
INSERT INTO pabNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ehaliya tyaoniterenai, exahe ehotyaliharenai xoahanai semaha kalore Xekohaseti awaiyehenerene hoka ihalahareha Isabel kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hoka 8-ki ferakenehena xoima tyaonitere najikinita xane aikonomanere milihehenahene hoka kaixaretyahene aokowihenaha enexe nexareta, Zacarias nexarexe. ");
INSERT INTO pabNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Xakore hoka inityo nexa: — Mahaiya. Enexare atyoite João — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hatyaoseta nexaha: — Xakore hoka maisa atyo hatyanai hekoti xinekonitarenai hatyo nexarexe aka — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hatyaoseta aimenekokoatyaha enexe ana, axahitene xoare nexare xamaniya kaixaretya xoima aokowita hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hoka Zacarias axa xairatyakalati taba taose hoka xairatya: “Enexare atyo João”, nexa. Hoka tyotyaha hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hatyaosehena hoka Zacarias iraexehetehitiya hoka ihalaharehena Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hoka ehaliya tyaoniterenai kalore mairaha. Hoka hatyoharenai tahi exaoretyoa hakákoare tyairinai koni tyaoniterenai nali, Judéia koa nali. ");
INSERT INTO pabNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tyotya semitereneharenai ahekotyahitaha hoka hatyohare tahi axahitaha: — Xoanahalanite exe xoima tyaohenaki? nexahitaha. Hoka aliterexe atyo Xekohaseti niyatere tyaonita ekakoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hoka Zacarias, Isekohaliti Waiyexe kaxaihakoretya hoka xakaihakahena hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— Nika wihalahare Xekohaseti kakoa, Israel Nenorexa kakoa. Hiyaiya, tyoa atyo kahinaetya haomanerenae exahe isa maheta wenati waiyexe enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Axikatya atyo womana hatya kinaterexe Wiyasehareheta maheta, etake hawakanehare Davi jikolahare. ");
INSERT INTO pabNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Toahiyita atyo Enore exeharenai irae, waiyexe iraiti xakaisaseharenai koamaniyata. ");
INSERT INTO pabNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iyeheta atyo wiso aokowi wahalakoaharenai nonitata, tyotya kirawaneterenai wiso nonitata. ");
INSERT INTO pabNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hotikisa atyo aokowi hawaiyexehare wahetakomaniyereharenai ana, exahe oteheta aokowi waiyexe iraehenerehare. ");
INSERT INTO pabNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Alitere atyo irae wahetahare Abraão hiye, ");
INSERT INTO pabNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","iyeheta atyo wiso aokowi wahalakoaharenai nonita, hoka wisaona exema maniya wimamairanehareta maheta aoka. ");
INSERT INTO pabNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nikare tyoma, kasani tyotyaki ferakenenai wikasetatere xowaka enomanere taita wisaona maheta, hoka wisoma maheta aokitereharenai taita. ");
INSERT INTO pabNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Hoka hiso, haré, hiso atyoite Enore Kalorexe niraene xakaisasehare hikaxaokaka. Hiso atyoite hiyanehena Xekohaseti nahitita, memere hamoka ahoti enomanere maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Hiyakaihenaite hihotyaliharenai hiye iniyakehenahitaha kaotyakehenerehare, kamaotyanetyakehetehenere iniyalahare enómaneha hiyeta tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hiyaiya, wEnorexa atyo airakoaneharetyare, waiyexehare. Hoka aokanalisaite wiso haxaokanatyakala kakoa, ");
INSERT INTO pabNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hoka enokoataite aokanalisa tyotya makaliroti maxakatyahene katawanexe katyahe tyaoniterenai ana, moheta wawenane waiyexe wenati maniya maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hatyaoseta João kekoare hoka kinatere tyaona eháre, inisekohare xoaha. Hoka maharexakiti tyaona hotikisoawihenere Israel hotyalinai ana kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hatyo xowakiya xekohaseti Augusto axikatya hairaene tyotya halitinai ekaxaikonekoa tyaoniterenai ana, haexarenaiha isaha maheta hoka kaxihatyaka halitinai maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hatyo hetati kaxihatyakehenahere xowaka Cirênio kalorexe tyaonita Síria nali. ");
INSERT INTO pabNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hatyaoseta tyotyaha xaneha haexarenaiha isaha hawenakalanaiha nihatyaka. ");
INSERT INTO pabNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hatyo hiyeta José xane Nazaréta, Galiléia nalita, Judéia koa xeta, hatya wenakalati Belém nexarexe nali, kalorexe Davi tyaohenere nali. José nali xane, Davi jikolahare hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Xane haexare isa maheta Maria kakoa. Hatyo kakoa atyo tyaona aokowita exowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hoka tifalo exowaka, hoka Belém nali tyaonahitere nase, xoima nawenanaose xane hikoa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hoka Maria awenakisa hetatiye mokose haisani. Hoka aihonolisa xoima imiti taosenai kakoa hoka ehokokisene kirakahare nakaira xomokakala aose, maisa xoare aoseheta aka enomanaha nemakatyakalati hanako hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hatyo nali kaxaikotyatiyenai tyaonahitaha makiya mase, kaxaikoahitaha hakalaneroxanai. ");
INSERT INTO pabNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hatyaoseta hatya anjo Xekohaseti nalitare kaotyaka hoka Xekohaseti xaokanala werokere aokanalisa kaxaikotyatiyenai. Hoka kalore mairaha ");
INSERT INTO pabNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","xakore hoka anjo nexa: — Awa atyo ximaira! Ali atyo notyoa Iraiti Waiyexe tahi noxakai xihiye maheta. Hatyo atyo kaihalaharetyakere tahi, exahe tyotya halitinai ana tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kalikini Davi nawenakala nali tyaona Xiyasehareheta, Enore Kalorexe Aohenere, Xekohaseti! ");
INSERT INTO pabNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Exakerite hoka xityakeko: xiyaiyaite hatya xoimaira exaihonolisakahare imiti taosenai kakoa, exetolikisakahare kirakahare nakaira xomokakala aose. ");
INSERT INTO pabNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hatyaoseta kaotyaka kahare haiyaharenai anjonai hatyo anjo kakoa, motya sorarenai enokoatarenai. Hoka xerahitaha xerati, ihalahare ahitaha Enore kakoa hoka nexahitaha: ");
INSERT INTO pabNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Maika kaihalaharetyaka Enore kakoa, enokoa xáhehare nenone! Hoka maika waikohekoa mehexaikohaliti tyaona halitinai waiye moka aokowitereharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hatyaoseta anjonai xanehenahitaha enokoa xeta hoka kaxaikotyatiyenai nexakakoahenaha: — Wiyá Belém xeta hoka wiyaiya, xoana xamani nali tyaona hoka, exahe wiyaiya Xekohaseti xakaitere wihiye — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hoka kaholawakaha xaneha hoka waiyaha Maria, José xoaha hoka waiyaha xoima exetolikisakahare kirakahare nakaira xomokakala aose. ");
INSERT INTO pabNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hatyaoseta xakaiha anjonai iraehenere etahi ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tyotya semiterenai kaxaikotyatiyenai xakaitereharenai hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Hoka Maria oteheta tyotya hatyoharenai, kalore ahekotya etahiha hoka tyotya hatyoharenai hamahiyasakota moka. ");
INSERT INTO pabNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hatyaoseta kaxaikotyatiyenai haikoahenahitaha mase xeta hoka xerahaxahotyaha xerati ihalahalitiya Enore anere, semehenahere, waiyehenahere xoaha hiyeta. Anjo xakaitere akereta terota hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hasemanane najikinita xoima nomanere milihe xaikotyaka ferakene xane hikoa hoka kaixaretyahene Jesus nexarexe. Hatyo nexare terota atyo anjo kaexaretene, enawenane nahitita. ");
INSERT INTO pabNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hatyaoseta xane hikoa Maria, José xoaha nómane Moisés Xaotyakiraho aokitere akereta ferakene. Hatyo hiyeta kolatyaha xoima Jerusalém xeta, hotikisahene maheta Xekohaseti ana. ");
INSERT INTO pabNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hiyaiya, exakere atyo xairatyoare tyaonita Xekohaseti Xaotyakiraho: “Tyotya hetatiye xoima atyoite kakikisaka, kaxaokaka Xekohaseti anere”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hoka xaneha tehitiya fetatyaha maheta hinamalise watyaha xamani, xoana hinamali kalotese xamani, Xaotyakiyaho akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hatyo xowaka Jerusalém nali hatya haliti tyaonita, Simeão nexarexe. Waiyexehare, airakoaneharetyare, exahe atyahita Israel hotyalinai niyakeheta. Isekohaliti Waiyexe tyaonita ekakoa, ");
INSERT INTO pabNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","hoka hatyo Isekohalitita, wainihenere nahititaite waiya Enore Kalorexe Aohenere, Xekohaseti xaxikalahare, aoka ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Isekohaliti kaxaihakoretya Simeão hoka xane Iraexatyakalati Hanako. Hoka enexe inityo kolatyahitaha xoima Jesus Iraexatyakalati Hanako xeta, tyomaha maheta Xaotyakiyaho aokitere akereta, ");
INSERT INTO pabNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","hoka Simeão iya xoima, hakanotalako mokene hoka ihalahare Enore kakoa. Hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Xekohaseti, kalikini atyo hiraetere akereta hisoma, hoka kalikini atyoite waiye nowainihena. ");
INSERT INTO pabNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hiyaiya, koxaka atyo nowaiya noxosenai kakoita halitinae hiyáneheta, exahe ");
INSERT INTO pabNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","memere hamohenere tyotya haliti hotyalinai nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Xaokanatyakalati hotikisa maheta hahotira tyotya majudeuneharenai ana, exahe isa maheta wenati waiyexe hihotyaliharenai Israel yerenai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Xoima nexe, nityo xoaha hakaharetyoaha Simeão iraehenere etahi kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeão wenati waiyexe aoka enomana hoka nexa Maria, Jesus nityo hiye: — Exe xoima atyo Enore xaxikalahare mawenekoaretya exahe iyeheta maheta kahare Israel yerenai. Exe xoima atyoite Enore xaimenekola hoka kahare ite haiyanai iraeharetene. ");
INSERT INTO pabNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nikare ite hoka exahekolanaiha metaharexenai kasemaka. Hoka xamaikohalitite kesekase ekawetyakahare akereta aikotya himahiyase — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hoka nali hatya iraiti xakaisasehalo inityohaloti tyaonita. Wainiyanenero, enexalo atyo Ana. Fanuel ene ityani, Aser hotyalinai konitalo. 7-wanone tyaonakakoahenahere najikinita exanene waini. ");
INSERT INTO pabNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Hoka hatyo xowaka 84-wanonehena tyaonita. Hoka maisa kikisoahetolo hekoti Iraexatyakalati Hanakota hoka ferakoa, makiya xoaha Enore koamaniya tyaonita. Kahaliki manakairita, iraexaita harenai. ");
INSERT INTO pabNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hatyaosehena hoka kaoka hoka ihalahalohena Enore kakoa, exahe iraehena xoima tahi tyotyaha Jerusalém niyakeheta xahita atyahiterenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hoka miyakatyaha háomaneha tyotya Xekohaseti Xaotyakiraho aokitere akereta hoka José, Maria xoaha haikoahenahitaha Galiléia xeta, hahanaha xeta, wenakalati Nazaré nali. ");
INSERT INTO pabNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hoka xoima kekoareta hoka kinatere tyaonita. Kalore waiyoliti kakoare, exahe Enore waiye mokitene. ");
INSERT INTO pabNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tyotya wanone Jesus nexe, nityo xanahitaha Jerusalém xeta hisehaliti Páscoa ana. ");
INSERT INTO pabNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hoka Jesus 12-wanonehena hoka xaneha hisehaliti ana, hawenaneha akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hoka hisehaliti tyotehenere najikinita haikoahenahitaha hahanaha xeta. Xakore hoka Jesus hekota Jerusalém nali, hoka maisa atyo enexe, inityo semitaha hatyohare tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Exahekolaha hiye hoka motya haikoahititerenai koni tyaonita aokahitaha hoka hatyo hiyeta haki ferakene tonahitaha taita. Hatyaoseta tawehenahene hahinaeharenai, hawaiyaneharenai xoaha koni. ");
INSERT INTO pabNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hoka maisa kaokehenahititene hoka haikoahenahitaha Jerusalém xeta, tawehenahitene maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hanamaki ferakene najikinita kaokehenahitene Iraexatyakalati Hanako, tyokita Xaotyakiyaho kakoa waiyoreterenai kakoa. Semita iniraeneha, exahe axahitene xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tyotya iniraene semiterenai hakaharetyoahitaha iniraene kakoa, enawaiyore xekoaxala kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Enexe, inityo waiyene hoka hakaharetyoaha tehitiya. Hoka inityo nexa ihiye: — Haré, xoana hoka exakere hisaona? Hexe, natyo xoaha kalore wimawaiyehare watawita hiso hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hoka Jesus nexa: — Xoana hoka xatawita natyo? Xoana maisa waiyekehalakere xomana Baba hanako notyaonehenere akiti? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Xakore hoka maisa waiyekehalakita enomanaha iniraene. ");
INSERT INTO pabNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hatyaoseta haikoaheta hanityo, hanexe kakoa Nazaré xeta. Hanexe, hanityo xoaha niraene semaxemaita. Hoka tyotya hatyoharenai inityo otyaxemaita. ");
INSERT INTO pabNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hatyaoseta Jesus kekoareta haháre exahe hawaiyore xoaha kakoa. Enore, halitinai xoaha awaiyetitene. ");
INSERT INTO pabNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Koxaka Tibério kalorexe tyaonita Roma nali hoka exowaka Pôncio Pilatos kalorexe tyaonita Judéia koa nali. Herodes exowaka kalorexe tyaonita Galiléia nali, hoka iximarene Filipe exowaka Ituréia, Traconites xoahanai koa kalorexe tyaonita. Lisânias exowaka kalorexe tyaonita Abilene nali. ");
INSERT INTO pabNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás, Caifás xoaha exowaka sacerdotenai xekohasenae tyaonahitaha. Hatyo xowakiya Enore isa maharexakiti nali iraiti João ana, Zacarias ityani ana. ");
INSERT INTO pabNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hoka João tonakoatya tyotya wenakalatinai tyaoniterenai one Jordão xa nali hoka xakaita exe iraiti: — Xahalakihena iniyalahare xománenai hoka xikabatixatyaka hoka xománe iniyalahare Enore maotyaneheta — nita. ");
INSERT INTO pabNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nikare tyaona iraiti xakaisasehare Isaías hababeranexakoa xairahenere akereta: Hatya haliti kawijita maharexakiti nali: Memere ahoti xamohena Xekohaseti naheta, maika totaho xamohena enaheta maniya. ");
INSERT INTO pabNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tyotya tyairi hekoakonaite kahexotyakeheta hoka tyairinai atyoite kaxehakakoatyakeheta. Ahoti katyokoahoterenai atyoite kaxaototahotyakeheta, exahe ahotinai kenekoehero, mitikoehero harenai kakoare atyoite kaxehakakoahotyakeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hoka tyotya halitinaite waiyehenaha haiyaseharehenahita Enore nalitare. ");
INSERT INTO pabNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hoka kahare halitinai xanahitaha João nali kabatixatyakaha maheta. Hoka nita tyotya ihiyeha: — Owi xalijiniharexe hotyalinai! Xala irae xihiye hoka motyaite maisa iniyalahare xikaxomokakita xaokita, Enore kaheneharexe iniyalahare axikahenere xowaka? ");
INSERT INTO pabNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Maika xoalini hare waiyexe xisomehena hoka xahotikisa iniyalahare xawenane xihalakira maheta. Hoka awa atyo xexakakoahena: “Abraão atyo wahetahare hoka maisaiya Enore ehareta wihiye”, xehena. Hiyaiya, aliterexe nomita xihiye, exe sehalinai hiyeta kakoitaiya Enore tyoma Abraão jikolahare! ");
INSERT INTO pabNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hiyaiya, xawatise atyo memere tyaonita, irikotya maheta atyakatenai ityahare kakoita. Tyotya atyakatenai mawaiyerihare kalitereharenai atyoite kaxityokaka hoka kaxawatyaka irikatyaose — nita. ");
INSERT INTO pabNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hoka halitinai axitene: — Hoka xoare ite wisomehena? nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hoka nita ihiyeha: — Xala xamani atyo hinamanase kaimanasexe hoka maika isehena hanase maimanasehare ana, exahe maika xala xamani kanakairere hoka maika irákakoahene manakairahare kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Haiyaharenai kalorexe noloxa resebetyaseharenai tehitiya kaokaha hoka axaha João: — Xaotyakisatiye, xoare ite wisomehena? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","— Awa atyo kalorexe aokitere xahexe xaxa halitinai — nexa João ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Haiyaharenai sorarenai tehitiya axitene: — Hoka wiso, xoare ite wisomehena? nexaha. Hoka João nita ihiyeha: — Awa atyo haiyaharenai noloxa xiya iniyalahare xiyomokarene kakoa, exahe maoserare xiyakaini etahi xoaha kakoa. Hoka maika xihalaharehena xoloxa xaresebetitereharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Halitinai xatyahane hatyo xowaka aeroretyoa. Exahekolaha hiye hoka João motya Enore Kalorexe Aohenere aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Xakore hoka João nexa tyotya ihiyeha: — Natyo atyo nabatixaita xiso one kakoa. Xakore hoka hatya atyo kaokehena noxahehare, hoka maisaiya natyonae aliyakere namaxolaita ikijitini nanohi, hatyo atyo noxahehare hoka. Hatyo atyoite batixahena xiso Isekohaliti Waiyexe exahe irikati xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Abali koxaka ekahekoa. Hatyo kakoaite haware moka trigo ekate nonitata hoka trigo ite moka exomokakala ako, hoka keratyaite ekate irikati mawakenehare tyaonitere koni. ");
INSERT INTO pabNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Xakaihena Iraiti Waiyexe hoka João aotyakijita halitinai kahare maniyata. ");
INSERT INTO pabNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hatyaoseta João watyali xekohaseti Herodes tyaohenere Herodias haximarene kaiserehare exanityo kakoa hiyeta. Exahe xoalinihare iniyalahare tyomehenere xoaha hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hatyaoseta Herodes ehare hoka exahehare niyalahare tyoma: João xomokaka berexoako aoka. ");
INSERT INTO pabNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tyotya halitinai kabatixatyakehenere najikinita, Jesus tehitiya kabatixatyaka. Hoka iraexaita ene hoka enokoa majiholatyoa ");
INSERT INTO pabNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","hoka Isekohaliti Waiyexe exoa enomana watyaha akerehare. Hoka enokoata tyoa iraiti hoka nexa: — Hiso atyo Nityani nawaiyetitere, kalore haihalahalinikijita natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hoka Jesus hetati hahenere xowaka, kala xoana xamani hoka 30-wanonehena. Hoka ahekotyahitere akereta atyo, José ityani atyo, hatyo atyo Eli ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli atyo Matate ityani, Matate atyo Levi ityani, Levi atyo Malqui ityani, Malqui atyo Janai ityani, Janai atyo José ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José atyo Matatias ityani, Matatias atyo Amós ityani, Amós atyo Naum ityani, Naum atyo Esli ityani, Esli atyo Nagai ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai atyo Maate ityani, Maate atyo Matatias ityani, Matatias atyo Semei ityani, Semei atyo José ityani, José atyo Joda ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda atyo Joanã ityani, Joanã atyo Resa ityani, Resa atyo Zorobabel ityani, Zorobabel atyo Salatiel ityani, Salatiel atyo Neri ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri atyo Melqui ityani, Melqui atyo Adi ityani, Adi atyo Cosã ityani, Cosã atyo Elmadão ityani, Elmadão atyo Er ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er atyo Josué ityani, Josué atyo Eliézer ityani, Eliézer atyo Jorim ityani, Jorim atyo Matate ityani, Matate atyo Levi ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi atyo Simeão ityani, Simeão atyo Judá ityani, Judá atyo José ityani, José atyo Jonã ityani, Jonã atyo Eliaquim ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim atyo Meleá ityani, Meleá atyo Mena ityani, Mena atyo Matata ityani, Matata atyo Natã ityani, Natã atyo Davi ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi atyo Jessé ityani, Jessé atyo Obede ityani, Obede atyo Boaz ityani, Boaz atyo Sala ityani, Sala atyo Nassom ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nassom atyo Aminadabe ityani, Aminadabe atyo Admim ityani, Admim atyo Arni ityani, Arni atyo Esrom ityani, Esrom atyo Peres ityani, Peres atyo Judá ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá atyo Jacó ityani, Jacó atyo Isaque ityani, Isaque atyo Abraão ityani, Abraão atyo Tera ityani, Tera atyo Nacor ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor atyo Seruque ityani, Seruque atyo Ragau ityani, Ragau atyo Faleque ityani, Faleque atyo Éber ityani, Éber atyo Sala ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala atyo Cainã ityani, Cainã atyo Arfaxade ityani, Arfaxade atyo Sem ityani, Sem atyo Noé ityani, Noé atyo Lameque ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque atyo Metusalém ityani, Metusalém atyo Enoque ityani, Enoque atyo Jarete ityani, Jarete atyo Maleleel ityani, Maleleel atyo Cainã ityani, ");
INSERT INTO pabNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã atyo Enos ityani, Enos atyo Sete ityani, Sete atyo Adão ityani, Adão atyo Enore nomanehare. ");
INSERT INTO pabNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus kakoa Isekohaliti Waiyexe tyaonita hoka haikoaheta one Jordão xa nalita hoka hatyo Isekohalitita axanikisene maharexakiti. ");
INSERT INTO pabNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hoka nali Tihanare hasakaharetene 40-ki ferakene. Hatyokinai maisa kanakairare hekoti hoka nakehena. ");
INSERT INTO pabNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hatyaoseta Tihanare nexa ihiye: — Enore Ityaniya atyo hiso hoka exe sehalinai haikawatya nakairati hoka hikanakaira — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nexa hoka Jesus nexa: — Exakere Iraiti Waiyexe xairatyoare tyaonita: Haliti atyo maisa nakairati xema taita xini tyaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hatyaoseta Tihanare kolatya Jesus enoakiya hoka haxerore hotikisa enomana tyotya waikohekoa tyaonitereharenai ixiyeharenae kakoita ");
INSERT INTO pabNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","hoka nexa: — Nisaite homana tyotya exe iyateliti, exahe exe xiyehaliti. Hiyaiya, tyotya exeharenai atyo kaxekaka nomani, hoka xala ana xamaniya atyo nisene naokowi hoka nisene. ");
INSERT INTO pabNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tyotya exeharenai atyoite homanere, hameholokoa nahalakoi hoka hawaiyetya natyo hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hoka Jesus nexa: — Exakere Iraiti Waiyexe xairatyoare tyaonita: Hawaiyehena hiyekohase Enore, exahe ekoamaniya taita hisaohena, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hatyaoseta Tihanare kolatene Jerusalém nali hoka mokene Iraexatyakalati Hana maiyeho enoakiyere akiti hoka nexa: — Enore Ityaniya atyo hiso hoka hahalaisoahetehena exaoseta waikoa xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Hiyaiya, exakere Iraiti Waiyexe xairatyoare tyaonita: Enore ite axikatya hanjoxanai kaxaiko hiso maheta, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","— Exakere tehitiya xairatyoare tyaonita: Otokaite hiso hoka maisa hikijinai hekoti kawe hamokita sehalinai hiye, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Hoka Jesus nexa: — Exakere Iraiti Waiyexe xairatyoare tyaonita: Awa atyo hahasakaharetya Hiyekohase Enore, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hatyaoseta Tihanare miyatya hahasakaharera Jesus kahare maniyata hoka xaneheta haxowaka niyahare. ");
INSERT INTO pabNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus haikoaheta Galiléia xeta hoka Isekohaliti Waiyexe niyatere tyaonita ekakoa. Etahiyakahare exaoretyoa hakákoare hatyokoa nali. ");
INSERT INTO pabNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hoka aotyakijita xahohisakoatyakalati hanakonai, exahe tyotya aexakeretyahitene. ");
INSERT INTO pabNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus xane wenakalati Nazaré xeta, enaihenere nali. Hoka sábado xowaka háwenane akereta, xane xahohisakoatyakalati hanako. Nali tityoa kaexaretya maheta Iraiti Waiyexe kaxairatyakehenere, ");
INSERT INTO pabNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","hoka isaha enomana iraiti xakaisasehare Isaías xairala nane. Hoka omereka babera hoka kaoka exakerexe kaxairatyakehenere aose: ");
INSERT INTO pabNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Xekohaseti nalitare Isekohaliti atyo tyaonita nokakoi. Hatyo atyo aoka natyo haomana, noxakai maheta Iraiti Waiyexe maoloxaharenae ana, exahe axikatya natyo noxakai maheta mehexaikohaliti eberexotyakaharenai ana, nakaxoseheta maheta maxoseharenai, niyeheta maheta iniyalahare kaxomokakiterenai, ");
INSERT INTO pabNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","noxakai maheta Xekohaseti iyehetehenere haomanerenai ferakene kaotyakenehenere maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hatyaoseta Jesus ityahaheta babera hoka isehetene xahohisakoatyakalati hana kaxaikotyasehare ana hoka tyokeheta. Tyotya halitinai nali tyaoniterenai wahakotyaha Jesus ana mamahirirahareha. ");
INSERT INTO pabNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hatyaoseta iraehena hoka nexa: — Kalikini atyo kaotyaka Iraiti Waiyexe kaxairatyakehenere, kalikini xasemehenere tahi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hoka tyotyaha aexakeretyaha Jesus, hakaharetyoahitaha iraiti aihalahalinikisare iraetere kakoa hoka nexahitaha: — Xoana maisa José ityani xini? nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hoka Jesus nexa: — Maisa hoka exakerexe ite xiraehitiya nomani exe iraiti: “Wairatyare, hisota hawairatyoawihena”. Exahe xexa tehitiyaite: “Hisomehena ali hawenakala kaiserehare nali, xakaitahere hománe tahi wihiye Cafarnaum naliye akereta”, xexaite — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hoka nehitiya: — Aliterexe niraeta xihiye, maisa atyo hatya hekoti iraiti xakaisasehare waiye kaxomokakere ewaikoherakoa kaiserehare nali. ");
INSERT INTO pabNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Xasemehena: kahare wainiyaneneronai tyaonahitaha Israel waikoherakoa nali iraiti xakaisasehare Elias xowaka, hoka maisa onehitita hanama wanone mokotexe hoka nakiti kalorexe tyaona hakákoare hatyo waikohekoa nali. ");
INSERT INTO pabNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Xakore hoka Enore maisa axikaita Elias hahalonai wainiyaneneronai tyaonitolonai Israel waikohera nali ana. Hoka hahalo wainiyanenero tyaonitolo wenakalati Sarepta nali Sidom waikohekoa nali ana taita. ");
INSERT INTO pabNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nikare tehitiya kahare jijikoahiyenai tyaonita Israel waikohera nali iraiti xakaisasehare Eliseu xowaka. Xakore hoka maisa hatyanai hekoti enekonitareha kaxaiyatelikisakihitita. Naamã taita, Síria nalitare, hatyo taita atyo kaxaiyatelikisakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hoka hatyoharenai semaha hoka tyotya xahohisakoatyakalati hanako tyaoniterenai kalore ehareha. ");
INSERT INTO pabNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hoka tityoahenahitaha, nolokasekoatyaha Jesus haware wenakalati nonitata. Xaneha ekakoa tyairi wáhaharexe nali xawatyahene maheta hatyo henota waikoa maniya. Hatyo heno atyo wenakalati kaomaka. ");
INSERT INTO pabNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Xakore hoka jiyeheta halitinai konita hoka xaneheta. ");
INSERT INTO pabNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hatyaoseta Jesus xane Cafarnaum xeta, hatya wenakalati Galiléia koa nali. Hoka hatyo nali aotyakijita halitinai sábado xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hoka hakaharetyoahitaha exaotyakira kakoa, iraeta atyo iyateliti kakoare hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hoka hatya haliti tyaonita xahohisakoatyakalati hanako hoka isekohaliti iniyalahare tyaonita ekakoa. Hoka kawiyatya: ");
INSERT INTO pabNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Kaxiyani! Xoare haoka wihiye, Jesus Nazaré yere? Xoana ali hisoa hamawenekoaretya maheta wiso? Waiye atyo hawaiyekehalakahareta nomani: hiso atyo Enore Xaxikalahare Waiyexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hatyaoseta Jesus irae isekohaliti iniyalahare hiye: — Nikareta hirae hoka hahikoahetehena hatyo haliti nonitata! nexa. Tyotya enahalakoahitaha isekohaliti iniyalahare exoakisa haliti waikoa hoka hikoaheta enonita makawexomokalahareneta. ");
INSERT INTO pabNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hoka tyotyaha hakaharetyoaha hoka irae kakoaha hatyo tahi: — Xoarehare iraiti ala exe? Exe haliti iyateliti kakoare hoka axikaheta isekohaliti iniyalaharenai hoka xanehenahititaha! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hoka Jesus tahi exaoretyoa hakákoare hatyokoa nali. ");
INSERT INTO pabNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hoka Jesus hikoaheta xahohisakoatyakalati hanakota hoka xane Simão hana xeta. Hoka Simão nakero hokakita, kalore wátyahiseta, hoka xakaiha hatyoharenai Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hatyaoseta xane tityoa exehokotyoakala haliya hoka irae watere hiye. Hoka wátere tyoteheta enonitata, hoka tityoaheta rotita hoka enakairaha tyoma. ");
INSERT INTO pabNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hatyaoseta kamai isoahena hoka tyotya kahinaeharexenai hokakiterenai, kahare hawareharexe kahehaliti kakoarenai, kolatyaha Jesus ana. Hoka hakahe ekaokakisa ihiyeha hoka aiyatelikihenahitene. ");
INSERT INTO pabNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hoka tihanarenai kahare halitinai nonitata xanehenahitaha hakawiyalaha kakoa: — Hiso atyo Enore Ityani! nexahitaha. Waiyekehalakahareta atyo Jesus enomanaha. Enore Kalorexe Aohenere atyo, hoka hatyo hiyeta watyalyahitene, mairaenityahitene. ");
INSERT INTO pabNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hatyaoseta ferakoa hoka Jesus xaneheta wenakalatita hoka xane maharexakiti. Hoka halitinai tawehenene hoka kaokehenahitene hoka maisa xaneheta enonyahitaha aokareha. ");
INSERT INTO pabNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Xakore hoka Jesus nexa: — Noxakaini tehitiya atyo haiyanaikoa wenakalati koanai Iraiti Waiyexe Enore koamaniya nawenatyaka tahi. Hiyaiya, hatyo maheta atyo Enore axikatya natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hatyo hiyeta xakaita Iraiti xahohisakoatyakalati hanakonai tyotya wenakalatikoanai. ");
INSERT INTO pabNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Haxowakiya Jesus tyaonita Galiléia hokoxala kaiholonekoa kilihi, hoka halitinai ehotyasekoaitene semaha maheta Enore niraene. ");
INSERT INTO pabNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hoka waiya hinama kanowanai hokoxa xaiya, kaiholokoa haliya. Mairatyatiyenai exoahenahitaha taita enakotaha hoka tihehenahititaha kohase hiyakakala. ");
INSERT INTO pabNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hoka Jesus kakoha Simão kanowane ako, hoka Jesus irae ihiye kikiyatene maheta inira kaiholokoa nonitata. Hatyaoseta Jesus tyoka hoka aotyakihena halitinai. ");
INSERT INTO pabNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hatyaoseta halakisa hairaene hoka nexa Simão hiye: — Hiyanehena kanowa kakoa hakiti hokoxa hatekoxa tyaohenere akiti. Hiso, hihinaeharenai xoaha hoka xaxawatya maka xahiyaxatya maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Hoka Simão nexa: — Xekohaseti, makiya wáhaka wahiyaxatya hoka maisa xoare wahiyita. Xakore hoka maka xawatyaka tyare atyo haokita hoka notyakekoite — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hatyaoseta xawatyaha makanai onexaiya hoka hiyaha kahare kohase hoka komitehena makanai irikotyoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hatyaoseta kowaisaha hahinaeharenai kanowa halyako tyaoniterenai ana tyoaha kahinaetyahene maheta. Xaneha hoka ekaisetyaha hinama kanowanai kahare kohase kakoa hoka komitaene tabobokoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hatyaoseta Simão Pedro waiya hatyoharenai hoka hakaolise kakoa meholokoa Jesus nahalakoa hoka nexa: — Xekohaseti, hakikisoahetehena nonitita. Hiyaiya, iniyalahare nomasehare atyo natyo! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simão, haiyaharenai ehaliya tyaoniterenai tehitiya hakaharetyoaha kahare kohasenai hiyehenahere kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeu ityaninai Tiago João tehitiya kalore hakaharetyoaha. Hatyonae atyo Simão hinaenai. Hatyaoseta Jesus nexa Simão hiye: — Awa atyo himawaiyehare. Kalikinita atyoite halitinai híyasehare hisaohena — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hoka nolokehehenahitaha kanowanai kaiholokoa nali hoka tyotya halaki akatyaha hoka xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Haxowaka Jesus tyaonita hatya wenakalatikoa hoka hatyo nali hatya haliti jijikoare kahehare iraharetita. Hoka waiya Jesus hoka halaisoa exoa waikoa enahalakoa, ekaokakisa hatiho waikoa, hoka axene: — Xekohaseti, hawaiyehihetaiya natyo haokowi hoka hawaiyehihetaiya natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hoka Jesus hakahe ekaokakisa ihiye hoka nexa: — Há, naokaite. Hawaiyehiheta atyo — nexa. Hatyaosehena hoka jijikoare kahehare maiyareheta. ");
INSERT INTO pabNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hoka Jesus exakere aotyakisene: — Awaira atyo exeharenai hatya hiye hiyakaihena, xakore hoka hiyane hiraehena sacerdote hiye hoka waiyahareheta hiso. Hatyo najikinitaite hiyane hafetatya kirakahare Moisés aotyakihenere akereta. Hoka tyotyaha waiyoreha hikinaterehenere kakoa — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Xakore hoka Jesus tahi kahare exaoretyoa hakákoare, hoka kahare halitinai tyoahitaha semaha maheta iniraene, exahe kaxaiyatelikisakehenahitaha maheta ekáhehareha nonitata. ");
INSERT INTO pabNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Xakore hoka Jesus xaneta maharexakahare nali hoka iraexaita. ");
INSERT INTO pabNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Haxowaka Jesus aotyakijita hoka haiyaharenai fariseunai, exahe haiyaharenai Xaotyakiyaho kakoa waiyoreterenai xoaha tyokahitaha ehaliya. Tyoaha atyo tyotya wenakalatikoanai tyaoniterenai Galiléia nalita, Judéia nalita, Jerusalém nalitare harenai tehitiya. Hoka Xekohaseti niyatere tyaonita Jesus kakoa aiyatelikiheta maheta hokakiterenai. ");
INSERT INTO pabNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hoka haiyaharenai halitinai kolatyaha hatya maetonanehare etolisoare haxetolisoakala hoka kasani isoaha hatyako hoka mokahene aokowiyahitaha Jesus nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Xakore hoka kahare halitinai hiyeta maisa aliyakere isoahitaha maetonanehare kakoa. Hatyaoseta kolatyahene hatiri heno. Hoka hati taose aitoakisaha hoka hatyoahota exoakisahene exetolisoakala kakoita halitinai nali tyaoniterenai nenekesene hoka mokahene Jesus nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hoka Jesus waiya ityakekoneha hoka nexa maetonanehare hiye: — Nohinaehare, iniyalahare hománenai atyo kaxemaisatyakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hoka Xaotyakiyaho kakoa waiyoreterenai, fariseunai xoaha hatyo tahi iraekakoahenaha: — Xala exe haliti hoka exakere maisa aiminisare Enore? Mahaiya atyo xalahare iniyalahare emaisahitita. Enore taita atyo hatyo iyateliti kakoare — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Xakore hoka Jesus otita exahekolaha hoka nexa ihiyeha: — Xoanere hoka nikare xahekoita? ");
INSERT INTO pabNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Xoarehare ala haxerore niraetyaka: “Iniyalahare hománenai atyo kaxemaisatyakeheta”, nerekatihenaite, xoana, “Hatityoahetehena hoka hatohetehena”, nerekatihena koríte? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","— Nahotikisaite xomana. Natyo Haliti Ityani iyateliti kakoare atyo notyaonita ali waikohekoa nemaisaheta maheta iniyalahare — nexa. Hatyaoseta nexa maetonanehare hiye: — Hatityoahetehena, hiyehetehena hiyetolisoakala hoka hiyanehetehena hihana xeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hatyaoseta hatyo haliti tityoaheta tyotyaha enahalakoaha, iyeheta haxetolisoakala hoka xaneheta hahana xeta, ihalahare Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tyotyaha hakaharetyoaha. Exahe hoka kalore hamairaneha kakoita ihalahareha Enore kakoa hoka nexaha: — Kaxiyani! Waiyexe kalikini xowaka wiyaiya! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hatyo najikinita Jesus xanehitiya hoka waiya hatya kalorexe noloxa resebetyasehare, Levi nexarexe, owene tyokita olo resebetyakalaose. Hoka Jesus nexa ihiye: — Hisohena noximi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi tityoa, halaki akatya tyotya hoka xane exema. ");
INSERT INTO pabNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hatyaoseta Levi tyoma kalorexe hisehaliti Jesus ana hahanako. Hoka nali kahare kalorexe noloxa resebetyaseharenai tyaonahitaha, exahe haiyaharenai iniyalahare nomaseharenai hoka tyokahitaha ehaliyaha hoka kanakairahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseunai, Xaotyakiyaho kakoa waiyoreterenai xoaha enekonitareha hoka ehareha Jesus xaotyakiraharenai hiye hoka axahene: — Xoana hoka xikanakairita xiserita kalorexe noloxa resebetyaseharenai, haiyaharenai iniyalahare nomaseharenai xoaha kakoa? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hoka Jesus nexa ihiyeha: — Mahokakeneharenai atyo maisa wairatyare aokare haomana, hoka hokakiterenai atyo wairatyare aokita haomana. ");
INSERT INTO pabNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Notyoa atyo naotyakisa maheta iniyalahare nomaseharenai waiye maniya tyaohenahitaha maheta, maisa atyo waiyexeharexenai naotyakisa maheta xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Haiyaharenai nexaha Jesus hiye: — João Batista xema tyaoniterenai manakairahitaha kahaliki, exahe iraexatyahitaha. Exahe fariseunai xema maniya tyaoniterenai tehitiya nikareta tyaonahitaha. Hoka hiyaotyakiraharenai atyo kanakairahitaha, terahitaha xoaha — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Hoka Jesus nexa ihiyeha: — Xoana xiyahekola hiye kakaexakatyakehenerenai wenakakoati hisehare ana manakairatyakahare tyaonita kaiyanityohenere ehaliyaha tyaonitata hoka? ");
INSERT INTO pabNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hoka haxowakaite kaiyanityohenere kaiyakeheta enekonitaha, hoka hatyo xowaka atyoite manakairehenaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus tehitiya xakai exe xaimenekore: — Maisa atyo xala hare aikotyare ini taose imiti waitarete hiyeta hoka tinolaharetyare imiti xololo. Nikareya tyoma hoka aiyalaharetyaiya imiti waitarete, exahe hatyo waitare taoseya maisa waiye kaotyakeneta hatyo imiti xololo kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","— Maisa atyo vinho waitarexa kaxomokakere toahiyere militirise nomaka ako. Nikareya kaxomokaka hoka halalakoaiya militirise hoka vinhoxaiya iratyoa tyotya, exaheya militirise hoka mawenekoare. ");
INSERT INTO pabNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hatyo hiyeta vinho waitarexa militirise waitare ako taita kaxomokakita. ");
INSERT INTO pabNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","— Exahe maisa atyo xalahare aokare vinhoxa waitarexa terehenahere vinhoxa toahiyerexa najikinita. Hiyaiya, nexa atyo: “Vinhoxa toahiyerexa atyo waiye”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sábado xowaka Jesus jiyehena trigo xafityaka koni. Hoka exaotyakiraharenai taikaxawatyaha hoka matyatyasetyahene hoka kanakairahitaha trigosenai. ");
INSERT INTO pabNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hatyaoseta haiyaharenai fariseunai axahene: — Xoana hoka xisomita Wiyaotyakisakaho sábado xowaka maomakene aokiterehare? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hoka Jesus nexa: — Xoana maisa xasemare Davi tyomehenerehare, hatyo ihinaenai xoaha nakehenahere xowakere? ");
INSERT INTO pabNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Isoa atyo Enore hanako, iya nakairati Enore ana kafetatyakehenerenai hoka kanakairene, exahe isa tehitiya hahinaenai ana. Wiyaotyakisakaho hiyeta maisaiya atyo hatya kanakairita hatyo nakairatinai hiyeta. Sacerdotenai taitaiya atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hoka Jesus halakihena hairaene hoka nexa: — Haliti Ityani atyo sábado ferakene xekohase — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hoka hatyotare sábado xowaka Jesus isoa xahohisakoatyakalati hanako hoka aotyakihena. Hoka nali tyaonita hatya haliti fihini maniya nira kahexe. ");
INSERT INTO pabNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hoka haiyanai Xaotyakiyaho kakoa waiyoreterenai, haiyaharenai fariseunai xoaha waiye Jesus ana wahakotyahitaha, waiyaha maheta exaiyatelikireheta sábado xowaka. Kasani iraeharetyahene hoka emaxaiminirene Xaotyakiyaho aokaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Xakore hoka Jesus otita exahekolaha hoka hatyo hiyeta nexa haliti nira kahexe hiye: — Hainakoahena hoka hatityoa ita nekese — nexa. Nexa hoka haliti ainakoa hoka tityoa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hatyaoseta Jesus nexa: — Naxehenaite xiso: xoare nexa Wiyaotyakisakaho sábado xaokaka? Xoare hare kaomakere exe ferakene: waiyexe, xoana iniyalahare kore? Haliti hokakita hoka kaxaiyatelikisakehena, xoana kahalakisaka korite hoka wainihena? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hatyaoseta Jesus wahakotya tyotya hahoko haliya tyaoniterenai ana hoka nexa mawaiyekahehare hiye: — Haimahena hikahe — nexa. Hoka hatyo haliti aimatya hakahe, hoka waiyehiheta ekahe. ");
INSERT INTO pabNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hatyaoseta Xaotyakiyaho kakoa waiyoreterenai, fariseunai xoaha ehareha hoka iraekakoahenaha xoalini hare háomaneha Jesus kakoa tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hoka hatyo xowaka Jesus kakoha tyairi heno iraexatya maheta hoka hatyo xatini heko iraexatya Enore hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ferakoa hoka kawisa haxaotyakiraharenai hoka 12-harenai enekonitareha aoka haomana. Hoka iraiti kakoarenae kaixaretyahene hoka 12-harenai atyo exenai: ");
INSERT INTO pabNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simão, hatyo atyo Pedro nexarexe kaexareheta, exahe iximarene André. Tiago, João, Filipe exahe Bartolomeu. ");
INSERT INTO pabNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus, Tomé, Alfeu ityani Tiago, exahe Simão Zelote nexarexe. ");
INSERT INTO pabNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Tiago ityani Judas, Judas Iscariotes eko xoaha. Judas atyo matawatyatiye tyaohena. ");
INSERT INTO pabNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hatyaoseta Jesus exoaheta tyairi henota ekakoaha hoka amematyoa kahare haxaotyakiraharenai kakoa hakakoehekoare. Hoka kahare halitinai nali tyaonahitaha. Judéia koa nalitarenai, Jerusalém nalitarenai, wenakalatikoanai Tiro, Sidom xoaha, one kaloxere haliya tyaonitere nalitarenai harenai. ");
INSERT INTO pabNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tyoaha semaha maheta Jesus niraene, exahe kaxaiyatelikisakehenahitaha maheta ekahehareha nonitata. Haiyanai isekohaliti iniyalahare hasakaharetiterenai tehitiya tyoaha hoka waiye maniya kaxomokakehenahititaha. ");
INSERT INTO pabNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tyotyaha kasani ekaokakisa hakahe ihiye aokowiyahitaha. Ihiyeta iyateliti hikoita hoka aiyatelikihitita tyotya halitinai hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hatyaoseta Jesus wahakotya haxaotyakiraharenai ana hoka nexa: — Waiye kaiserehare atyo xiso maoloxaharenai. Hiyaiya, Enore Nawenakala atyo xomanere. ");
INSERT INTO pabNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","— Waiye kaiserehare atyo xiso kalikini nakitereharenai. Hiyaiya, xikanakairahare ite xisaona. — Waiye kaiserehare atyo xiso kalikini tiyitereharenai. Hiyaiya, xikoexehetaite. ");
INSERT INTO pabNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","— Waiye kaiserehare atyo xisaonita xikairawaiyakehena, xikaxaxikaharetyakehena, iniyalahare xikaxomokakehena, exahe xiso atyo maisa xawaiyexe xikaxaokakehena, xisaonitere Haliti Ityani xema maniya hiyeta hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Maika xihalaharehena, ximaxalohena, nikare xikaxomokakehena hoka. Hiyaiya, kalorexe xibakatyakala atyo ityakaisakahare tyaonita xomana enokoa nali. Hiyaiya, enahetakomaniyereharenai atyo hatyo akereta mokaha iraiti xakaisaseharenai. ");
INSERT INTO pabNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","— Xakore hoka kirakoane ite xisaohena, xiso kalikini kaoloxere tyaoniterenai. Hiyaiya, koxaka atyo waiye xisaona! ");
INSERT INTO pabNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","— Kirakoane ite xisaona, xiso kalikini tyotya xaokitereharenai kakoare xisaonitereharenai. Hiyaiya, xinakehenaite! — Kirakoane ite xisaona, xiso kalikini koexitereharenai. Hiyaiya, xitiyahenaite! ");
INSERT INTO pabNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","— Kirakoane ite xisaona, tyotyaha aexakeretyaha xiso hoka. Hiyaiya, enahetakomaniyereharenai tehitiya atyo aexakeretyaha iraiti xakaisaseharenai metalaharenai — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","— Xakore hoka nomita atyo xiso xasemiterenai niraini hiye: Xawaiyehena xahalakoaharenai, exahe waiye xamohena kirawanetereharenai xiso. ");
INSERT INTO pabNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xaohena waiyexe iraeharetiterenai xiso ana, exahe xiraexahena iniyalahare mokiterenai xiso ana. ");
INSERT INTO pabNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Maika hatya mokohena hiso hitanakoli hiye hoka hehaika enomana hamaniya mokotya tehitiya maheta. Maika hatya kolahena himanase hoka maika kotare kolatya ekatyahexete tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hatyatere ana hisehena, xoalinihare axehena hiso hoka. Exahe maika hatya kolahena hixiyehare hoka awa atyo haxehetene. ");
INSERT INTO pabNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Maika haiyanai waiye xamoka kasani haiyanae moka xiso xaokitere akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","— Hoka xawaiyetitaiya etakehare awaiyetitereharenai xiso taita hoka xoanere hoka xatyahita xoalinihare waiyexe xekaka xomana xahita? Halitinai iniyalahare nomaseharenai kakoita atyo awaiyetita etakehare haxawaiyetyaseharenai. ");
INSERT INTO pabNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Exahe waiyeya xamokita etakehare waiye mokitereharenai xiso taita hoka xoanere hoka xatyahita xoalinihare waiyexe xekaka xomana xahita? Halitinai iniyalahare nomaseharenai kakoita atyo nikare tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Exahe xijitaiya etakehare bakahititereharenai xiso ana taita hoka xoanere hoka xatyahita xoalinihare waiyexe xekaka xomana xahita? Halitinai iniyalahare nomaseharenai kakoita atyo haiyaharenai iniyalahare nomaseharenai ana isahitaha, isehenahitaha enomanaha maheta isehenerehareta. ");
INSERT INTO pabNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","— Maika xawaiyehena xahalakoaharenai, waiye xamohenahene. Xisehena hoka awa atyo xatyaha xisehenerehare xekakeheta xomana xahita. Nikare ite hoka kaxekakaite waiyexe xomana, exahe Enore Kalorexe ityaninaite xisaona. Nikare xisaona. Hiyaiya, hatyo tehitiya atyo waiyexeharexe waiyexenai ana, exahe xalijiniharexenai ana xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Maika xawaiyexehare xisaona, Xexe nawaiyexehare akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","— Awa atyo haiyaharenai xiraeharetya hoka maisaite xikairaeharetyakita. Awa atyo haiyaharenai xairawaiyakisa, hoka maisaite xikairawaiyakita. Maika ximaotyaneheta haiyanai xomokala xiso iniyalahare hoka kamaotyanetyakehetaite iniyalahare xománe. ");
INSERT INTO pabNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xisehena haiyanai ana hoka Enore ite isa tehitiya xomana. Nikare ite hoka kaxékaka xomana kalore, kalore kaiserehare. Xikolala hekorexe ite isa xomana. Hoka xisehenere haiyanai ana hákakoanetaite Enore iseheta xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hatyaoseta Jesus xakai exe xaimenekorenai: — Mahaiya hatya maxosehare aliyakere otokahijita hatya maxosehare. Nikareya tyaona hoka hatyo hinamanaiya exoaha tolokoako. ");
INSERT INTO pabNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maiha atyo hatya kaxaotyakisakiterehare haxaotyakisase xahehare xini. Xakore hoka kaxaotyakisakitereya atyo miyahena haxaotyakisaka hoka haxaotyakisase hákakoanehare atyoite tyaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","— Xoana hoka hawahakoita holoxoti hihinaehare xosako tyaonitere ana hoka maisa atyo hiyaiyare atya taose hiyosako tyaonitere? ");
INSERT INTO pabNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hoka aliyakereya hehena hihinaehare hiye: “Nohinaehare, haiya hoka niyeheta holoxoti hiyosakota haoka”, hehena, hisota maisa hiyaiyare atya taose hiyosako tyaonitere hoka? Maoseratyaliye! Hiyehetehena hotohare atya taose hiyosako tyaonitere hoka hatyaosetaite waiye hiyaiyakaheta hoka hiyeheta holoxoti hihinaehare xosako tyaonitere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","— Atya kate waiyexe atyo maisa ewaxirali kaliye, exahe atya kate ewaxirahare atyo maisa waiyeri kaliye. ");
INSERT INTO pabNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hiyaiya, tyotya atyanai atyo irinai hiyeta waiyekehalakaharetaha. Mahaiya atyo aliyakere kaximexakita halohalose katohilihinai hiyeta, exahe uva hoka katohere kateta kaximexakita. ");
INSERT INTO pabNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nikare haliti waiyexeharexe iyita waiyexe haxomokala waiyexenai akota, hatyo atyo emahiyasakotare. Hoka haliti mawaiyexeharexe atyo iyita iniyalahare haxomokala iniyalaharenai akota. Hiyaiya, ekanase atyo iraeta emahiyasako kaise tyaoniterehareta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","— Xoana hoka, “Xekohaseti, Xekohaseti”, xita noxaokaki hoka maisa niraetere xihiye akereta xisaonare? ");
INSERT INTO pabNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nahotikisaite xomana, xoare hare kakoa xamani ala hakákoa, etakehare nokoamaniye tyaoniterehare, semiterehare noxaotyakiri hoka tyakekoterenehare. ");
INSERT INTO pabNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hatyohare atyo motya etakehare hatya haliti tyoma hati hoka seka hateko hoka ehokoli niyahare sehali heno ajika. Hoka one kahekoaxa tyaona hoka one xane kaoka hatyo hati hiye, xakore hoka maisa exoita, waiye nomakere hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Xakore hoka xala xamani atyo sema niraeni hoka maisa tyakekorene hoka motya atyo etakehare mairiharenehare tyomehenerehare hati waikohekoa, mahokoli kasehare akereta. One tyoa hatyo hati ana hoka exoakisene rotita hoka mawenekoaretene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hatyaoseta Jesus halakisa hatyoharenai haxakaini halitinai hiye hoka xane wenakalati Cafarnaum xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hoka hatyo nali hatya sorarenai xekohasehare tyaonita. Kawakaneharexe hoka awaiyetita hawakanehare hoka ewakanehare hokakita, komitehena wainita. ");
INSERT INTO pabNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hatyaoseta sorarenai xekohasehare sema Jesus tahi hoka axikatya judeunai nityohalitiranai axahene hoka tyoa aiyatelikiheta maheta ewakanehare. ");
INSERT INTO pabNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hoka xane ahalakoatyaha maheta Jesus hoka tihityoaha ihiye hoka nexaha: — Aliterexe atyo hatyo haliti hihiyeta waiye kahinaetyaka. ");
INSERT INTO pabNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hiyaiya, awaiyetita atyo wihinaeharenai, exahe xahohisakoatyakalati hana kakoita tyoma womana — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hatyaoseta Jesus xane exemaha. Xakore hoka hati haliyehena hoka sorarenai xekohasehare axikatya haiyaharenai hahinaeharenai nexaha maheta Jesus hiye: — Xekohaseti, maisa nahakakisa naokowita hiso. Maisa atyo noxoare waikatehare hoka maisaiya hijoita nohanyako. ");
INSERT INTO pabNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Maisa tehitiya noxoare waikatehare hoka maisaiya natyonaira niraeta hiháre hiyeta. Hiraehena taita, hoka nowakanihare ite waiyeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Natyo tehitiya atyo haiyanai xekohasetinai katyahakohareta notyaonita hoka wakatyahitaha natyo. Exahe nosorarexinai atyo nowakani xema tyaonahitaha. Niraihena hatya hiye: “Hiyane”, nomihena ihiye hoka xaneta. Hatya hiye, “Hisohena”, nomihena hoka tyoita. Nowakanihare hiye, “Hisoma nikare”, nomihena hoka tyomita — nexa sorare xekohasehare Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus kalore hakaharetyoa sema hatyoharenai hoka ehaikoahareheta hoka nexa kahare halitinai xaneterenai exema hiye: — Aliterexe nomita xihiye: maisa xoana xowaka exakere kalore tyakekotyati nowaiyare Israel hotyalinai koni — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hatyaoseta sorarenai xekohasehare hinaeharenai haikoahenahitaha hahanaha xeta hoka waiyehenahitaha wakahare niyatereheta. ");
INSERT INTO pabNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hatyo najikinita, mawahaneta, Jesus xane wenakalati Naim nali. Exaotyakiraharenae, kahare halitinai xoaha xane exema. ");
INSERT INTO pabNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hatyaoseta xane kaokehena wenakalati talalahoko jihola haliya hoka naliyerenae xane fehenaha kamati. Hatyo wainihenere atyo hamokoserore wainiyanenero ityani, hoka kahare halitinai wenakalatitarenai xanahitaha exema. ");
INSERT INTO pabNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hatyaoseta Xekohaseti waiya inityo, kalore airakoanehalotene hoka nexa: — Awa atyo hitiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hatyaoseta xane ehaliyase kaiserehare hoka ekaokakisa hakahe kamati nitini hiye. Hoka kolaiterenenai tityoaha. Hatyaoseta Jesus nexa: — Xoimahaliti, niraehena hikakoa: hatityoahetehena! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nexa hoka xoimahaliti tyokeheta hoka iraehetehena, hoka Jesus isehetene inityo ana. ");
INSERT INTO pabNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tyotyaha kalore mairaha hoka ihalahareha Enore kakoa hoka nexaha: — Kaxiyani, kalorexe iraiti xakaisasehare kaotyaka winekoni! Enore atyo tyoa iyehitita hahotyaliharenai! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hatyoharenai Jesus tahi kahare exaoretyoa hakakoare wenakalati kalokoarenai exahe ehaliyakoita tyaoniterenai xoaha nali. ");
INSERT INTO pabNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Hatyaoseta João Batista xema tyaoniterenai xakaiha tyotya hatyoharenai haxaotyakisase hiye. Hoka João kawisa hinamahare enekonitareha ");
INSERT INTO pabNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","hoka axikatene axaha maheta Xekohaseti Jesus: “Xoana hiso etake kaokehenere, xoana hatya korite watyahahitiya?” nexaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hatyaoseta xaneha Jesus tyaonitere nali hoka nexaha: — João Batista axikatya wiso waxa maheta exakere: Xoana hiso terota etake kaokehenere, xoana hatya koríte watyahahitiya? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hatyaosehena hoka Jesus aiyatelikiheta kahare halitinai hokakiterenai, isekohaliti iniyalahare kaxaihakoretiterenai, exahe kahare maxoseharenai tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hatyo najikinita Jesus nexa João xema tyaoniterenai hiye: — Xiyaneheta hoka xiyakaihena João hiye exe xiyaiyehenereharenai, exahe xasemehenereharenai atyo: maxoseharenai atyo waiyakahititaha, maetonaneharenai atyo tohenahititaha, jijikoahiti tawaneharenai waiyehihititaha, matanakoakoharenai atyo semakahititaha, kamatinai atyo kasehitita, Iraiti Waiyexe atyo kaxakaisakita maoloxaharenae hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Waiye kaiserehare atyo tyakekoterenai natyo hoka maisa amaikoharexe nokakoi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hatyaoseta João xema tyaoniterenai xaneheta hoka Jesus iraehena halitinai kakoa João tahi: — Xiyanehenere maharexakahare xahalakoahenere João xowaka, xoare hare xatyahita xiyaiyane maheta? Xoana kána kase hoholati hoholaitere? ");
INSERT INTO pabNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Xoare hare xiyane xiyaiya? Xoana hatya haliti waiye nimere? Xasemehena, waiye nimerenai, exahe waiye tyaoniterenai atyo hati wahaharexenai ako tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Xiyakaihena terota, xoare xatyahita xiyaiya maheta? Xoana hatya iraiti xakaisasehare? Aliterexe atyo nomita xihiye: xiyaiyehenere atyo iraiti xakaisasehare xahehare. ");
INSERT INTO pabNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hiyaiya, exakere xairatyoare tyaonita, Iraiti Waiyexe nanekoa João tahi: Hasemehena, naxikatyaite haliti haheta maniya niraini kakoare hoka memere moka ahoti haheta maniya. ");
INSERT INTO pabNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Hoka Jesus nehitiya: — Nomita atyo xihiye: João atyo tyotya halitinai xahehare. Xakore hoka xala xamani atyo ekatyahakohareta tyaonita enokoa nali hoka hatyo atyo João xahehare tyaona. ");
INSERT INTO pabNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kalorexe noloxa resebetyaseharenai exahe tyotya halitinai xoaha semaha hatyoharenai. Hatyonai atyo etake tyakekohenerenai Enore niraine aliterexe hoka João batixahenerenai. ");
INSERT INTO pabNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Xakore hoka fariseunai, Xaotyakiyaho kakoa waiyoreterenai xoaha atyo maisa habatixatyaka aokahitaha João hiyeta, nikare hoka maxaokalaha atyo Enore ahekohenere etahiha. ");
INSERT INTO pabNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","— Hatyo hiyeta xoare kakoaite naimenekohena kalikiniyerenai haliti? nehitiya Jesus. — Xoarehare kakoala exehare halitinai hakakoa? ");
INSERT INTO pabNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Motya atyo xoimanai wetekokoa tyokiterenai. Háhotyali kawiyaita háhotyali ana: “emahalikijita atyo wenakakoati anere xerati, xakore hoka maisa xaholikoare! Wiyerita atyo xafityati anere xerati, xakore hoka maisa xitiyare!” nitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","João Batista atyo manakairita, maeraneta vinhoxa hoka xita: “Tihanare atyo tyaonita ekakoa!” xita. ");
INSERT INTO pabNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hoka Haliti Ityani atyo kanakairehena, terehena hoka xita: “Xiyaiyehena, exe haliti atyo kanakairatetyoita, teratetyoita. Etake kalorexe noloxa resebetyaseharenai exahe iniyalahare nomaseharenai xoaha hinaehare!” xita atyo. ");
INSERT INTO pabNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Xakore atyoite hoka ekakoitaite Enore nawaiyorene katyakekotyakehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hatyaoseta hatya fariseu noloka Jesus kanakaira maheta. Hoka Jesus xane isoa ehanako hoka tyoka kanakaira maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hatyo wenakalati nali tyaonita hatya ohiro iniyalahare nomasehalo. Hoka sema Jesus nakaira fariseu hanako. Hatyaoseta iya halise kanotese airaxero kakoare ");
INSERT INTO pabNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","hoka Jesus hiniri maniya amematyoa, ehaliyaseta, tiyita hoka aolowaita ikijinai haosexa xatali kakoa. Hatyaoseta tirehetene hasekase kakoita. Hoka sohikijijita Jesus kijinai, exahe owikita airaxero ikijinai heno. ");
INSERT INTO pabNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hoka fariseu waiya hatyoharenai hoka exakere ahekotya: — Aliterexeya atyo exe haliti iraiti xakaisasehare hoka waiyekehalakitaiya atyo enomana exe ohiro otoiterene, exahe enawenane iniyalahare maniya xoaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hatyaoseta Jesus nexa fariseu hiye: — Simão, hatahi noxakai hihiye naokowita — nexa. — Hiraehena, Xaotyakisatiye — nexa Simão. ");
INSERT INTO pabNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hoka Jesus nexa: — Hinamahare halitinai kakotanetaha, hatya haliti kakotanetya minitere. Hatya 500-hokose olo prata nomaka, háhare hoka 50-hokose xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Xakore hoka maisaiya háhare hekoti hatyo hinamahare konitare xoare kakoa bakahitita hakotane. Hatyaoseta emaiyareheta hatyo hinamanai kotane. Xala hare kaisere ite masakare awaiyehenene? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","— Noxahekoli hiye hoka kalore masakare kakotaneterene — nexa Simão. — Ehekore hekoaxatya — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hatyaoseta ehaikoahareheta ohiro ana hoka nexa Simão hiye: — Xoana hiyaiyita exe ohiro? Nisoahenere xowaka maisa hijita one nomani natiha maheta nokiji, xakore hoka tihene atyo haosexa xatali kakoa hoka tirihititene atyo hasekasenai kakoita. ");
INSERT INTO pabNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Maisa atyo hasohitanakolijita natyo nokaokihenere xowaka, xakore hoka hatyo atyo maisa halakisare hekoti hasohikijira nokiji nisoaheneritita. ");
INSERT INTO pabNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Maisa atyo airaxeroxa nosekase niyahare hijita, xakore hoka hatyo atyo owika airaxero nokijinai heno. ");
INSERT INTO pabNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aliterexe nomita hihiye: kalore haxawaiyera hiyeta tyomehenere atyo hotikijita koxaka kalore iniyalahare tyomehenere kamaotyanetyakehetehenere. Xakore hoka etakehare inira hiyeta kaxawaiyetyakihititerehare atyo inirita tehitiya awaiyehitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hatyaoseta Jesus nexa ohiro hiye: — Iniyalahare hómanenai atyo kaxemaisatyakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hatyaoseta mexa haliya tyokiterenai axakakoahenaha: — Xala exe hoka iniyalahare kakoita emaisahitita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Xakore hoka Jesus nexa ohiro hiye: — Hityakekone atyo waiye maniya moheta hiso. Hiyanehetehena himehexaikohalone kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hatyo najikinita Jesus xane wenakalatikoanai exahe wenakalatikoasenai xeta, hoka xakaita Iraiti Waiyexe Enore koamaniya nawenatyaka tahi. Hoka 12-harenai exaotyakiraharenai xaneha exema, ");
INSERT INTO pabNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","exahe haiyahalonai ohironai kaxaiyatolokisakehetehenolonai isekohaliti iniyalahare nonitata, ehokakeneha nonitata xoaha. Hatyonai atyo: Maria Madalena nexalolo, hatyo nonitata atyo 7-harenai isekohaliti iniyalaharenai kaxaxanikisakeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, Cuza exanityo: exanene atyo kalorexehare tyaonita xekohaseti Herodes wakanehare. Susana, haiyahalonai ohironai kahinaetitolonai Jesus, exahe exaotyakiraharenai xoaha haxiyehalonaiha kakoita, xoahanai. ");
INSERT INTO pabNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kahare halitinai tyoaha haiyanaikoa wenakalatita waiyaha maheta Jesus. Tyotyaha hohisakoaha hoka xakaihena ihiyeha exe xaimenekore: ");
INSERT INTO pabNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— Hatya haliti xane fitya maheta hahananeharese. Hoka fitita hanakatisenai hoka haiyasenai ahoti kilihi exoa, hoka halitinai tyahakene, exahe kotehalasenai hoka kanakairene. ");
INSERT INTO pabNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Haiyasenai hanakatisenai exoa kaharexe sehali tyaonitere akitiya. Hikoaha hoka niraha, maisa olowehiti aka hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Haiyasenai hoka xane exoa katoherehinai koni, hoka hahotyalita kekoareha hananehaliti kakoa hoka katohere jiyahaotyahene. ");
INSERT INTO pabNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xakore hoka haiyasenai atyo exoa waikohe waiyexekoa. Hoka hananehalitinai kekoareha, kaxawaha. Hasese hiyeta 100-se kasé. Hoka Jesus nehitiya — Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hoka Jesus xaotyakiraharenai axahene, xoare nexa xamani ala aokowita hatyo xaimenekore kakoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hoka Jesus nexa: — Xomana atyo Enore hotikijita metaharexe hakoamaniya nawenatyaka. Hoka haiyanai ana atyo xaimenekotyati maniyata kaxaotyakisakita, wahakotya hoka maisa waiyahitaha maheta, semehenaha hoka maisa waiyekehalakita enomanaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","— Exe xaimenekore iraitere atyo exakerexe: hanakatise atyo Enore niraene. ");
INSERT INTO pabNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hanakatisenai exoahenerenai ahoti kilihi atyo etakehare semitereharenai iraiti xakore hoka Tihanare kaoka hoka iyehititerehare iraiti emahiyasakota, maisa tyakekoahitaha kaiyakehenahititaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Hanakatisenai exoahenerenai kaharexe sehali akiti atyo etakehare semitereharenai iraiti hoka aokitereharene haomana haihalaharene kakoita. Xakore hoka maisa atyo kinaterexeha hoka hatyo hiyeta maisa waha xini tyakekoahitaha. Hoka kahasakaharetyakehenaha hoka tyotya halakisahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hanakatisenai exoahenerenai katoherehinai koni atyo etakehare halitinai semitereharenai iraiti xakore hoka emawaiyeharene, ixiyehare, ekehalaharene aeroretyoitata hoka jiyahaotita hatyoharenai halitinai. Hatyo hiyeta kasetereharenai maisa xonere hekoti, maisa miyatita hahatene Enore koamaniya. ");
INSERT INTO pabNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hoka hanakatisenai exoahenerenai waikohe waiyexekoa atyo etakehare halitinai semaxematya hoka tyakaijitereharenai iraiti hamahiyase waiyexe ako, exahe tyakekohatiye hoka kahare tyomaha Enore ana, tyakekohatiha atyo hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","— Maisa atyo xalahare aotakahena xaokanatyakalati hoka hatyo najikinita mokarene koho exahe xoana kama katyahe xamani. Xakore hoka xaokanatyakalati atyo exomokakalaose terota kaxomokakita, hoka tyotya ijoiterenai waiyaha maheta exaokanala. ");
INSERT INTO pabNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hiyaiya, tyotya kaxateroakisakiterenai atyoite kawaiyakehetaite, exahe tyotya metaharetereharenai atyoite kawaiyakeheta, kahotikisakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","— Hatyo hiyeta maika xirihare exahe xiyaiyehena, aliyakere xamani exeharenai xasemita hoka. Hiyaiya, xala xamani atyoite xoalinihare kakoare hoka kaxekakihitiyaite exahexe enomana. Xakore hoka xala xamani atyoite maisa xoare kakoare hoka haxoaliniya aokitere atyoite kaiyakeheta enonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hatyaoseta Jesus nityo, iximarenenai xoaha tyoaha tyaonitere nali xakore hoka maisa aliyakere kaokahitaha ehaliya, kahare halitinai hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hatyo hiyeta hatya xakaini Jesus hiye: — Hityo, hiximarenenai xoaha menanaka tyaonahitaha hoka iraeha hikakoa aokowiyahitaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Xakore hoka Jesus nexa tyotya ihiyeha: — Mama, noximalininai xoaha atyo etakehare semitereharenai exahe tyaonitereharenai Enore niraene xema — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Haxowaka ferakene Jesus kakoha haxaotyakiraharenai kakoa kanowa ako hoka nexa: — Wiya hokoxa halakoiya maniya — nexa. Hatyaoseta xaneha. ");
INSERT INTO pabNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hoka imahotyoahitataha hokoxa hoka Jesus nemaka. Hoka hoholati kinatyaxa hoholahena hokoxa hao, hoka kanowako one kaisehena, kaheneharehena tyotya enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hatyaoseta exaotyakiraharenai kaokaha Jesus haliya hoka kaosetyahene hoka nexaha: — Xekohaseti, Xekohaseti! Wiwainihenaore! nexaha. Hoka Jesus kaose hoka tityoaheta hoka irae hoholati, one xoaha hiye hoka mahohoreheta, memaxeheta one, mema akeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hatyaoseta nexa haxaotyakiraharenai hiye: — Aliyo xityakekone tyaonita? nexa. Xakore hoka hakaharetyoahitaha, exahe mairahitaha xoaha hoka nexahitaha: — Xoare halitini ala exe hoka one, hoholati xoaha hiye irae hoka aokitere akereta tyaonaha? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hatyaoseta kaokaha Gerasakoa, Galiléia hokoxala halakoiya maniya. ");
INSERT INTO pabNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Hoka Jesus exoahena kanowakota hoka hatya haliti, hatyo wenakalatitare xane ahalakoatene. Hatyo haliti kakoa isekohalitinai iniyalaharenai tyaonita. Wahakiyehena maisa isoare imityako, maisa hatyako hekoti tyaonare, xawatyakalatinai koni atyo tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hatyaoseta waiya Jesus hoka hatyo haliti kawiyatya, exoa hakaoliri kakoa waikoa enahalakoa hoka nexa kinatyaxa: — Jesus, Enore Kalorexe Ityani! Xoare haoka nohiye? Naxita hiso hoka awa atyo iniyalahare hamohena natyo! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nikare irae, Jesus koxaka irae isekohaliti iniyalahare hiye hikoaheta maheta haliti nonitata hoka. Kahaliki isekohaliti otokitene. Haxowaka halitinai olatyahene ikijinai, ewaotyalinai xoaha hiye kamatiherahi kakoa, xakore hoka irikotitene, hoka isekohaliti axanikijitene maharexakahare xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hatyaoseta Jesus axene: — Xoare nexare hiso? nexa. — Nexare atyo Hisoakere — nexa. Nikare irae kahare isekohalitinai iniyalaharenai tyaonita ekakoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hoka isekohalitinai axahitaha Jesus hoka maisa hatyo toloko hatekoakore axikatyahene aokareha. ");
INSERT INTO pabNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Exowaka kahare bolokonai nisakoaita hatyo haliyaseta tyairi heno. Hoka isekohalitinai axa Jesus, kasani halakisahene hoka bolokonai milako tyaonaha maheta hoka halakisahene. ");
INSERT INTO pabNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hatyaoseta isekohalitinai hikoahetaha haliti nonitata hoka bolokonai milako tyaonaha, hoka exoahenahitaha tyairi henoseta hokoxa xaiya xeta hoka monaha hoka tyotyaha wainiha. ");
INSERT INTO pabNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hatyaoseta boloko kaxaikotyasenae waiyaha hatyoharenai hoka tekoahenahitaha hoka xakaiha etahiha wenakalatikoanai, exahe hatyo wenakalati haliyita tyaoniterenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hatyaoseta kahare halitinai xaneha waiyaha maheta nikare tyaohenerehare. Kaokaha Jesus tyaonitere nali hoka waiyaha haliti. Hatyo nonitata atyo isekohalitinai iniyalaharenai xanehitita hoka Jesus kiji haliya tyokita, kaimere, waiye xahekoreheta xoaha. Waiyahene hoka mairaha. ");
INSERT INTO pabNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hatyohare waiyehenereharenai xakaihakatyaha hatyo haliti waiye maniya xomokakeheta tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hatyaoseta tyotya Gerasa nalikoa tyaoniterenai kalore mairaha hoka Jesus hiye iraeha, xaneheta maheta ewaikoheraha koata. Hatyaoseta Jesus kakohaheta kanowako hoka xaneheta. ");
INSERT INTO pabNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hoka hatyo haliti tihanare ehatyahalinikihenere hoka xanehetehenere enonitata awaiyehetehenere tihityoa Jesus hiye: — Haokareya hoka notyoa hiyema, Xekohaseti — nexa. Xakore hoka Jesus axikahetehenene hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Hiyanehetehena hawenakala xeta hoka hiyakaihena Enore tyomehenerehare homana — nexa. Hatyaoseta hatyo haliti xane tyotya wenakalatikoanai hoka xakaihakatya Jesus tyomehenerehare enomana tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hatyaoseta Jesus haikoaheta hokoxa halakoiya maniya hoka kahare halitinai haihalahareneha kakoa katyawaxehenahitaha ihiye, tyotyaha atyo nali terota atyahahitene hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hatyaoseta kaoka hatya haliti Jairo nexarexe, hatyo atyo xahohisakoatyakalati hana kaxaikotyasehare tyaonita hawenakala nali. Hoka meholokoa Jesus kiji haliya hoka axene, xane maheta ehana nali, ");
INSERT INTO pabNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ityani hamokoserore 12-wanonehenolo wainihena hoka. Hoka Jesus xanetata hoka kahare halitinai ehotyasekoaitene tyotya maniyata. ");
INSERT INTO pabNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hatyaoseta hatya ohiro kaoka halitinai koni. Koxaka 12-terehokoanehena timalati hikoata minita ihiyeta. Koxaka tyotya haxiyehalonai miyatya wairatyarenai hiye, xakore hoka maisa xala hare aiyatolokihititene. ");
INSERT INTO pabNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hoka xane Jesus hiniri maniyata hoka ekaokakisa hakahe inima kilihi hiye hoka irikotyoahalohetehena rotita hoka waiyeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hatyaoseta Jesus axehena: — Xala ekaokakisa hakahe nohiye? nexa. Nexa hoka tyotya teraharetyoaha. Hatyaoseta Pedro nexa: — Xaotyakisatiye, tyotya halitinai atyo hihoko haliya tyaonahitaha, ehotyasekoatyahitaha hiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Xakore hoka Jesus nexa: — Hatya ekaokakisa hakahe nohiye. Hiyaiya, nokehexa nohiyeti iyateliti hikoane — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hatyaoseta ohiro maisa aliyakere teroahetolo hoka tyoa hatatakoane kakoita hoka meholokoa Jesus kiji haliya. Hoka tyotya enahalakoahitaha xakai Jesus hiye xoare hiyeta ekaokakisa hakahe ihiye, exahe kinatolohetehenolo rotita xoaha tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hatyaoseta Jesus nexa: — Hikinatoloheta atyo hityakekone hiyeta. Hiyanehetehena himehexaikohalone kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus iraetata hoka kaoka hatya wakahare Jairo hanakotare hoka nexa: — Xekohaseti Jairo, hityani koxaka waini. Kotare Xaotyakisatiye matyoanenehare hihana nali, waiya aliya hoka kirahare haetonane hiyeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus sema hatyoharenai hoka nexa Jairo hiye: — Awa atyo himawaiyehare, maika hityakekohena hoka kinatolohetaite — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hatyaoseta Jesus kaoka Jairo hana nali hoka Pedro, João, Tiago xoaha taita isoaha exema aoka, xoimahaloti nexe, nityo xoaha taita, maisa hatehitiya isoa aokita. ");
INSERT INTO pabNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tyotyaha nali tiyahitaha, exahe kirakoane tyaonahitaha xoimahaloti hiyeta. Hoka Jesus nexa: — Awa atyo xitiya, xoimahaloti maisa waini xini. Nemakahalota atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hatyaoseta tyotyaha koexahalihenahene, waiyekehalakita atyo enomanaha koxaka ekamane hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Xakore hoka Jesus xane isoa, otokene ekahe hiye hoka nexa kinatyaxa: — Xoimahaloti, hatityoahetehena! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hoka kasehetehitiya hoka tityoahetehena rotita. Hatyaoseta Jesus nakairati xekaka aoka xoimahaloti ana. ");
INSERT INTO pabNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hoka enexe, inityo hakaharetyoaha, xakore hoka Jesus irae ihiyeha hoka hatyoharenai maxakaisakene hatya hiye aoka. ");
INSERT INTO pabNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus kawisa 12-harenai haxaotyakiraharenai hoka isa enomanaha iyáteliti, waiyoliniti xoaha, axanikihenahitaha maheta isekohalitinai iniyalaharenai, exahe aiyatelikihenahitaha maheta hokakiterenai. ");
INSERT INTO pabNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hatyaoseta axikatyahene xakaiha maheta Enore koamaniya nawenatyaka tahi exahe aiyatelikihenahitaha maheta hokakiterenai hoka ");
INSERT INTO pabNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","nehena: — Awaira atyo xoalinihare xakolahena xiyanene niyahare: mahaiya tonohisoakalati hekoti xatonohisoa maheta, mahaiya sako, mahaiya nakairati, mahaiya olo exahe mahaiya hate hekoti kajiyanexe imitinase xakolaita. ");
INSERT INTO pabNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maika xikaokehena hakoa wenakalati hoka maika waiye mohenerenai xiso hanako xisaona hatyo wenakalatita xiyanehitiyere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Xakore hoka maika maisa waiye mokahitaha xiso hoka xijiyehitiya rotitaira hatyo wenakalatita. Hoka maika xijiyehitiya hoka xamokotyahatya xiberekatanenai waikohese xahita, xahotikisa maheta hatyo halitinai ana emawaiye xomokareneha xiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hoka exaotyakiraharenai xaneha hoka jiyaha tyotya wenakalatikoanai hoka xakaitaha Iraiti Waiyexe, exahe aiyatelikihenahititaha hokakiterenai hakakoare. ");
INSERT INTO pabNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes, xekohaseti tyaonitere Galiléia nali, sema tyotya hatyoharenai tahi hoka maisa aliyakere ahekotya xaka mokene, haiyaharenai atyo nita hoka: — João Batista kaseheta! nexahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Haiyaharenai atyo Elias kaotyakeheta aokahitaha, exahe haiyaharenai atyo hoka motya toahiyerehare iraiti xakaisasehare kaseheta aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Xakore hoka Herodes nexa: — Natyota terota atyo João seri xirikotyaka naoka. Hoka xala halitini tahi niraetyakala exeharenai nasemita? nexa. Hoka Herodes waiya aokowihena Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hoka iniraene kakoarenai kaokehenahitaha hoka Jesus hiye xakaihakatyaha tyotya háomaneha tahi. Hatyoseta nolokahene hoka xaneha hawawaha wenakalati Betsaida nali. ");
INSERT INTO pabNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Xakore hoka kahare halitinai semaha hatyoharenai tahi hoka xaneha exema. Hoka Jesus awaiyetyahene hoka xakai ihiyeha Enore koamaniya nawenatyaka tahi, exahe aiyatelikiheta hawairatyaka aokiterenai. ");
INSERT INTO pabNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hatyaoseta waikoa kamaetehena. Hatyo hiyeta 12-harenai exaotyakiraharenai tyoaha hoka nexaha Jesus hiye: — Haxikahetehena exe halitinai hoka xanehenahitaha. Hoka xaneha wenakalatikoanai, wenakalatikoasenai xoaha nali, alita owitene tyaohenere nali, hoka kaokaha nakairati, haemakahaose xoaha. Hiyaiya, ali atyo maisa xoare aka — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Xakore hoka Jesus nexa ihiyeha: — Xisehena xisota enomanaha nakairati — nexa. Hoka nexaha: — Tyotya tyaoniterenai winali atyo 5-tohase nakairati, hinama kohasenai xoaha taita. Xoana haxikaita wiso wiya maheta nakairati tyotya exe halitinai ana? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nali tyaonita kala xoana xamani hoka 5.000-harenai halitinai. Hoka Jesus irae haxaotyakiraharenai hiye: — Xiraehena halitinai hiye hoka tyokaha 50-harenai xakini haware — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hoka exaotyakiraharenai sema iniraene hoka iraeha ihiyeha tyotya tyokaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hatyaoseta Jesus iya 5-tohase nakairati, hinama kohase xoaha hoka wahakotya enokoa xeta hoka iraexatya Enore hiye: — Ehekore nakairati hisa womana, Abá — nexa. Hatyaoseta taikasetya nakairati, kohasenai xoaha hoka isene haxaotyakiraharenai ana irakahene halitinai ana maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tyotyaha kanakairaha hoka fakatehareha, hoka exaotyakiraharenai kaisehenahitaha 12-te koho kamawanehenere holoxo kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Haxowaka Jesus hawawaharenai tyaonita, iraexaita, hoka exaotyakiraharenai kaokaha ehaliya. Hatyaoseta Jesus axahene: — Xala aokita natyo halitinai? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hoka nexaha: — Haiyanai atyo João Batista aokahitaha hiso. Haiyaharenai atyo Elias aokahitaha hiso. Haiyaharenai atyo koxakerehare iraiti xakaisasehare kaseheta aokahitaha hiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","— Hoka xiso atyo xala xaokita natyo? nexa Jesus. — Hiso atyo Enore Kalorexe Aohenere, Enore xaxikalahare waokita hiso — nexa Pedro. ");
INSERT INTO pabNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hatyaoseta Jesus irae ihiyeha hoka hatyoharenai maisa hatya hiye xakaisaka aokita. ");
INSERT INTO pabNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hoka nehitiya: — Haliti Ityani ite kaxemakawatikisakehena kalore. Judeunai nityohalitiranaiha, sacerdotenai xekohasenai, Xaotyakiyaho kakoa waiyoreterenai harenaite maisa aokahitene haomanaha. Kaxaisakaite, hoka hanamaki ferakene najikinitaite kasehetehitiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hatyaoseta nexa tyotya ihiyeha: — Xala xamani atyo tyaona nokoamaniye aokowihena hoka maika hatyota maotyanoawi hoka maika kolatya tyotyaki ferakene haberekotyaka niyahare atyalihose xaimaholatyaka hoka tyaona noximi. ");
INSERT INTO pabNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hiyaiya, xala xamani atyoite waiyexe maniya moka aokowita hawenane hoka metaite enonita. Xakore hoka xala xamani atyoite kaxaisaka nohiyeti hoka wenati waiyexe atyoite kaoka. ");
INSERT INTO pabNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Xoare mahetaiya hatya jiyahaotya hakakoare waikohekoarenai, hatyota xamani ametakisoawihena, xoana kamawenekoaretyakehena xamani hoka? ");
INSERT INTO pabNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hiyaiya, xala xamani atyoite haihareta natyo exahe noxaotyakiri xoaha hoka Haliti Ityani tehitiyaite haihare ekakoa, tyohetehenere hawerokene, Hanexe werokene, anjonai waiyexeharexenai xoaha kakoa xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","— Exeharenaira xotyaxematya: aliterexetya nomita xihiye: haiyaharenai ali tyaonitereharenai tyaite maisa wainahitaha Enore nalitare Kalorexe hamawaiyanenehareha nahitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kala xoana xamani hoka hasemanane najikinita, Jesus noloka Pedro, João, Tiago xoaha hoka kakoha tyairi heno iraexatya maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iraexaita ene hoka itiho hawareharexe tyaona, exahe inima hoka iyomate, werokate tyaona. ");
INSERT INTO pabNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hatyaosehena hoka hinamahare haliti nali kaotyaka hoka iraehena ekakoa. Hatyonai atyo Moisés, Elias xoaha ");
INSERT INTO pabNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","exahiyatyoareha werokiti enokoatare kakoa. Iraetaha Jesus kakoa ekamane exahe exemakawatikasaka Jerusalém nali Enore aohenere akereta tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, ihinaeharenai xoaha waiye nemakahitaha, xakore hoka kaosehenahitaha hoka waiyaha Jesus, hinamahare halitinai ehaliya tyaoniterenai xoaha werokahalini. ");
INSERT INTO pabNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hoka hatyo halitinai xanehenahitehenaha Jesus nonitata hoka Pedro nexa: — Xaotyakisatiye, waiye nawenatyaka ali. Nika wisoma hanamalise hatirisenai: halise homanere, halise Moisés anere, halise tehitiyaite Elias anere — nexa. Aliterexe Pedro ana maisa waiyekehalakere hekoti iniraeneta enomana. ");
INSERT INTO pabNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iraetata ene hoka kaotyaka kaiminiti hoka exahiyahokotyahene. Hoka hatyo koni tyaonaha hoka mairaha. ");
INSERT INTO pabNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hoka kaiminiti konita tyoa iraiti hoka nexa: — Exe atyo Nityani, noxiyakawali. Xasemaxematyaira iniraine — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hatyaoseta iraiti tyoteheta hoka Jesus waiyehenahitaha hawawita. Hoka exaotyakiraharenai mema tyaonaha hoka hatyo xowaka maisa xala hare hiye xakaitaha hawaiyaneha tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hatyaoseta kamaetali exoahenahitaha tyairi henota, hoka kahare halitinai tyoa ahalakoatya Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hatyaoseta hatya haliti tyaonitere halitinai nenekesene kawiyahena: — Xekohaseti, naxehena hiso nityani hiyeta, hamokoserore nityani hoka! ");
INSERT INTO pabNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hatya isekohaliti iniyalahare tyaonita ekakoa, hoka ehárehena rotita xoimahaliti kawijita, exahe atatakoakijitene exahe kakatoloxaholijitene ekanasakota. Hoka isekohaliti kawe mokitene, maisa halakisarene hekoti. ");
INSERT INTO pabNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Koxaka naxa hiyaotyakiraharenai axanikihenahitaha maheta isekohaliti iniyalahare, xakore hoka maisa xoana mokahitene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hoka Jesus nexa: — Haliti matyakekoneharenai, mawaiyexehareharenai! Otene kijiyaite notyaohena xikakoa? Otene kijiyaite naiyasetyoa xikakoa? nexa. Hatyaoseta nexa haliti hiye: — Hisohena ali hityani kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hatyaoseta xoimahaliti kaokehena hoka kafahare hoka isekohaliti iniyalahare exoakisene waikoa. Hatyaoseta Jesus watyali isekohaliti hoka awaiyeheta xoimahaliti hoka isehetene enexe ana. ");
INSERT INTO pabNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hoka tyotyaha hakaharetyoaha Enore niyatere nerore kakoa. Tyotyaha hakaharetyoahitataha ene Jesus tyomiterehare kakoa hoka nexa haxaotyakiraharenai hiye: ");
INSERT INTO pabNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Awaira atyo ximaotyanehena niraehenerehare xihiye tahi: Haliti Ityani tyaite kaxekakehena halitinai ana hoka aisahene ite — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Xakore hoka maisa waiyekehalakita enomanaha hatyoharenai. Hatyo iraehenerehare tahi akiti metahare tyaona enomanaha hoka maisa waiyekehalakita terota enomanaha maheta. Hoka mairahitaha haxaxaneha hatyoharenai tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hatyaoseta exaotyakiraharenai iraekakoahenaha: xalahare kaisere xamani ala enekonitareha masakare kalorexe hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hoka Jesus ana waiyekehalakita exahekolaha. Hatyaoseta iya hatya xoima hoka mokene hahaliya ");
INSERT INTO pabNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","hoka nexa: — Xala xamaniya atyo nohiyeti hatya xoima waiye mokita hoka waiye atyo mokita natyo. Hoka xala xamani atyo waiye mokita natyo hoka waiye atyo mokita noxaxikatyasehare. Hiyaiya, xala xamani atyoite maisa haiyanae xahehare tyaona aokowita xinekoni hoka hatyo atyoite haiyaharenae xahehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hoka João nexa: — Xaotyakisatiye, wiyaiya hatya haliti axanikihitita isekohalitinai hexare kakoa, xakore hoka wamahokoanetya nikare enómane, maisa winekonitare xini hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hatyaoseta Jesus nexa João, haiyaharenai haxaotyakiraharenai xoaha hiye: — Awa atyo xamahokoanetya. Hiyaiya, xala xamani atyo maisa ahowitikisare xiso hoka kahinaetita atyo xiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hoka hikoahena Jesus xanene aosehena enokoa xeta hoka xane Jerusalém xeta aokowi. ");
INSERT INTO pabNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hoka haiyaharenai axikatya haheta maniya. Hoka xaneha hoka kaokaha hatya wenakalatikoase Samaria koa nali, kaokaha hakiti hoka nemakaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Xakore hoka nali tyaoniterenai maisa Jesus kaokene awaiyetyahitaha, semaha exanenehena Jerusalém xeta hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hoka exaotyakiraharenai Tiago, João xoaha semaha hatyoharenai hoka nexaha: — Xoana waxa irikati enokoatare hoka exe halitinai mehotya haokita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Xakore hoka Jesus ehaikoahareheta hoka watyaliyahene. ");
INSERT INTO pabNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","— Maisa Haliti Ityani tyoa mehotya maheta xini halitinai. Tyoa iyehenahitene iniyalahare nonitata maheta — nexa. Hatyaoseta xanehenahitiyaha hakoa wenakalatikoase xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hoka Jesus, exaotyakiraharenai xoaha xanahitaha ahotyaho hoka hatya haliti nexa Jesus hiye: — Notyoaite hiyema, aliyo xamani hiyanehena hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hatyaoseta Jesus nexa: — Wakarenai atyo kahanere waikoako, kotehalanai atyo kaihexe. Xakore hoka Haliti Ityani atyo maisa xoare ako kawiniye — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hatyaoseta hahare hiye nexa: — Hisohena noximi — nexa. Xakore hoka nexa: — Xekohaseti, nahaikoaheta hoka baba waini hoka nafetene hotohare hoka hatyaosetaite notyoa hiyema — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","— Hahalakisene hoka kotare kamatinai fityaha hakamane hatyanai — nexa Jesus. — Xakore hoka hiso hiyane hiyakaihena Enore koamaniya nawenatyaka tahi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Háhare nexa: — Notyoaite hiyema, xakore hoka nahaikoaheta hoka nojinaheta hotohare nohinaeharenai — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hoka Jesus nexa: — Xala xamaniya atyo aijohehena waikohe hoka maisaiya hajikini maniya wahakoita. Nikarexe xala xamaniya Enore xema maniya tyaona aokowi hoka maisaiya hawenane toahiyere xema tyaohitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hatyo najikinita Xekohaseti aoka haiyaharenai exema xaneterenai konitare 70-harenai hoka axikatyahene hinamahare xakini, xaneha maheta enaheta maniya wenakalatinai exahe xaneheneraosenai nali nihatyaka. ");
INSERT INTO pabNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Axikahenaherene nahitita, nexa: — Kahare ximexati niyahare, xakore hoka hatenitiyenai atyo maisa kaharexe. Hatyo hiyeta xaxehena hanakatihaliti xekohasehare hoka axikatya hatenitiyenai hoka imexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xiyanehena! Naxikaita atyo xiso ahoxanai koni kalaneronai xanetere akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Awaira atyo xakolahena xibonane, xoloxa nitini, exahe xiberekatane. Exahe awa atyo xatityoahena ahotyaho hoka xikatyawaxehena hatya hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Maika xisoahena hali hatyako hoka xexa hotohare: “Kasani mehexaikohaliti tyaona exe hatyako waoka”, xexaira. ");
INSERT INTO pabNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Maika hatya haliti mehexaikoharexe nali tyaonita hoka xahalakisaira xityawaxa ekakoa. Xakore hoka maika haliti mamehexaikoharenehare hoka xityawaxaira xemaisaheta enonita. ");
INSERT INTO pabNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Maika hatyoli hatyakota xisaona hoka xikanakairehena, xiserehena, xoarenai xamani isehenaha xomana hoka. Hiyaiya, hatenitiye atyoite kabakatyaka ehatene nahalakoa. Awa atyo halyakota xiyane halyako xeta menehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","— Maika xikaokehena hakoa wenakalati hoka waiye mokaha xiso hoka maika xikanakaira isehenerehareha xomana. ");
INSERT INTO pabNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xaiyatelikihetaira hokakiterenai hatyo wenakalatikoarenai hoka xexaira halitinai naliyerenai hiye: “Enore koamaniya nawenatyaka tahi akiti atyo kaoka xomana”, xexaira. ");
INSERT INTO pabNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Xakore hoka maika xikaokehena hakoa wenakalati hoka maisa waiye mokahitaha xiso hoka xiyanira ahotyahonai hoka xexa: ");
INSERT INTO pabNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Waikohese kakoita alalatyoahenere wikijinai hiye exe wenakalatita wamokotyahaheta xiyahita! Xakore hoka xotyaxematyaira exehare: Enore koamaniya nawenatyaka tahi akiti atyo kaoka xomana”, xexaira. ");
INSERT INTO pabNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hoka Jesus nehitiya: — Xaxalisati Ferakene ite Enore ite airakoaneharetya Sodoma hatyo wenakalati nonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hoka Jesus nehitiya: — Kirakoane ite hisaohena, wenakalati Corazim! Kirakoane ite hisaohena, wenakalati Betsaida! Hiyaiya, waiyexenai mawaiyakaharenai kaomakehenere hatyo hinaliyeya atyo kaomakere wenakalatikoanai Tiro, Sidom xoaha nali hoka hatyo naliyerenaiya atyo halakihenahitaha háomaneha iniyalahare. Exahe hotikisahaiya atyo aokowiha iniyalahare hahalakiraha hoka tyokahaiya atyo tataolate nimere, hoka mokahaiya irikati niyehe haseriha heno. ");
INSERT INTO pabNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Xaxalisati Ferakene ite Enore ite airakoaneharetya Tiro, Sidom xoahanai xiso, Corazim, Betsaida xoahanai nonitata! ");
INSERT INTO pabNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Exahe hiso, wenakalati Cafarnaum, xoana hiyahekola hiye hoka motyaite hakakoha enokoa nali haokita? Hasemehena, hikaxawatyaka atyoite kamatinai tyaonitere nali. ");
INSERT INTO pabNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hatyaoseta nexa haxaotyakiraharenai hiye: — Xala xamaniya atyo sema xiraene hoka semita atyo niraeni. Hoka xala xamaniya atyo maisa awaiyetyare xiso hoka natyo atyo maisa awaiyetyare. Hoka xala xamani atyo maisa awaiyetyare natyo hoka maisa atyo awaiyetyare noxaxikatyasehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hoka 70-harenai kaokehenahitaha kalore haihalahareneha kakoa hoka nexaha Jesus hiye: — Tihanarenai kakoita semaxematya wiraene, hexare kakoa wiraehena hikoahenahitaha maheta halitinai nonitata hoka! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hoka Jesus nexa: — Aliterexe. Hiyaiya, nowaiya Ahalakoahaliti xexoaneheta enokoata, motya kahihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xasemehena: nisá atyo xomana iyateliti xatyahaka maheta owinai xakolokoanai harenae, exahe xijiyahaotya maheta xahalakoaharenai niyatere hoka maisa ininai hekoti iniyalahare xikaxomokakita maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Xakore hoka awa atyo xihalahare tihanarenai semehenahere xiraene kakoa taita. Xakore hoka maika xexarenai enokoa nali kaxairatyakehenere kakoa kaisere xihalaharehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hatyaosehena hoka Isekohaliti Waiyexe niyatere hiyeta Jesus kalore ihalahare hoka nexa: — Abá, hiso atyo enokoa, waikoa xoaha Xekohasehare. Nihalahare hikakoa, hawaiyekehalakahenere hitahi akiti xoimanai exahe mawaiyoreharenai ana hiyeta. Hoka waiyorexe, semarexe tyaohenerenai ana atyo metahare hamoka hitahi akiti. Aliterexe, Abá, hatyoharenai atyo kaomaka hiyaokala exahe haokitere akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","— Baba atyo halakisa nomani tyotya xoalini hare. Maisa atyo xala hare waiyorexe Ityani kakoa. Enexe taita atyo waiyoreta ekakoa. Exahe maisa atyo xala hare waiyorexe Enexe kakoa. Ityani taita atyo waiyoreta ekakoa, exahe haiyaharenai ana awaiyekehalakatene hoka hatyonai tehitiya atyo waiyoreta ekakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hatyaoseta Jesus ehaikoahareheta haxaotyakiraharenai ana hoka nexa ihiyeha, hawawahareha heko: — Waiye kaiserehare atyo waiyitereharenai exehare xiyaiyitereharenai! ");
INSERT INTO pabNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Natyo atyo nomita: kahare iraiti xakaisaseharenai, kalorexenai xoaha waiyaha aokowiha exehare xiyaiyiterehare, xakore hoka maisa waiyahitene. Exahe semaha ene aokowiha exe xasemiterehare xakore hoka maisa semahitene hekoti — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hatya Xaotyakiyaho kakoa waiyoretere tityoa, hoka kasani hasakaharetya Jesus aokowita hoka axene: — Xaotyakisatiye, xoareya notyoma hoka kaxekaka nomani wenati matyotenehare? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hoka Jesus nexa: — Xoare nexa atyo Iraiti Waiyexe kaxairatyakehenere hatyoharenai tahi? Hoka aliyakerexe hatyo akiti hasemita? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hoka hatyo haliti nexa: — Hawaiyehena kaiserehare Hiyekohase Enore, hisaonehena exema maniya takita, hahekohena ekoamaniya takita, haiyateretyoahena hawenane kakoa exema maniya. Exahe hawaiyehena haiyanae hawaiyetyoawitere akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","— Hekoaxahenere atyo ehekorexeta — nexa Jesus. — Nikare hisaonehena hoka hisaona mene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Xakore hoka Xaotyakiye kakoa waiyoretere kasani waiyexehare aokowita hoka axene: — Hoka xala atyo haiyanae haokitere? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hoka Jesus nexa: — Hatya haliti xanehitita Jerusalém nalita Jericó xeta. Hoka ahotyaho haiyaharenai kaiwarexe otokene, aitoakisaha inima, mokotyahene hoka komita ene aisahene hoka halakisahene. ");
INSERT INTO pabNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hoka hatya sacerdote xanehitiya hatyoahota. Hoka waiya hatyo haliti hoka exahiyatene hoka jiya. ");
INSERT INTO pabNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hatya levita tehitiya hatyo nali jiya. Wahakotya enomana hoka exahiyatene tehitiya hoka jiyehitiya. ");
INSERT INTO pabNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hoka hatya Samaria yere jiyehena hatyo ahotyaho hoka hikoa hatyo nali. Hoka waiya hatyo haliti hoka airakoaneharetene. ");
INSERT INTO pabNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kaoka ehaliya hoka wairatene kolotenitiya, vinhoxa harenai kakoa ekawe xomokakaose. Hatyo najikinita moka hatyo haliti hakirakaharexa kaiserehare heno hoka kolatene hatya nemakatyakalati xeta hoka nali kaxaikone. ");
INSERT INTO pabNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","— Kamaetali xanehetehena hoka isa hinama hokose olo nemakatyakalati xekohasehare ana hoka nehena: “Maika hikaxaiko exe haliti. Nahaikoahetaite hoka nojiyehetehena ali hoka nabakaheta hiso, xoare xamani exe xahexe holoxa kakoa hiya enomana hoka” — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hatyaoseta Jesus axa Xaotyakiyaho kakoa waiyoretere: — Hiyahekola hiye hoka hatyo hanamaharenai konitare, xala hare hatyo haliti kamokohekoatyakehenere hinaehare tyaona? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","— Etake kahinaehenerene — nexa Xaotyakiye kakoa waiyoretere. — Hoka hiyanehena hoka nikareta hisomehena — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Hatyaoseta Jesus, exaotyakiraharenai xoaha xanehenahitiyaha hoka kaokaha hakoa wenakalatikoase. Hatyo nali hatya ohiro Marta nexalolo hahanako nolokene. ");
INSERT INTO pabNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Hoka iximalone, Maria nexalolo, tyoka Xekohaseti haliyaseta hoka semaxemaita exaotyakira. ");
INSERT INTO pabNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hoka Marta kahatenehalo tyaonita tyotya hatyakore hatenitinai kakoa. Hatyaoseta xane Jesus haliya hoka nexa: — Xoana maisa xoare hahekotyare hoka exe noximaloni halakijita natyo tyotya exe hatenitinai kakoa? Haxikahenene hoka tyoa kahinaetya natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hatyaoseta Xekohaseti nexa: — Marta, Marta, hikahateneta, himawaiyehalota xoaha kahare xoalini hare kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xakore hoka haterore atyo ehekorexeta. Maria atyo aoka waiyexe, hoka hatyo atyoite maisa xala hare iyehitita enonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Haxowakiya Jesus iraexaita hakiti. Hoka halakisa hairaexala hoka hatya exaotyakirahare axene: — Xekohaseti, haotyakihena wiso iraexatyati kakoa, João aotyakihenere haxaotyakiraharenai akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hoka Jesus nexa: — Exakere xiraexatya: Wexe Enore, Hiso enokoa tyaonitere, kasani tyotyaha aiminisaha Hiso waokita. Hisohena ali Xekohaseti hisaona maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kasani nakairati hisa womana tyotyaki ferakene waokita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Himaotyanehetehena iniyalahare wisomitereharenai, haiyaharenai iniyalahare mohenere wiso wimaotyanehititere akereta. Hoka awa atyo hahalakihena wiso hoka wikahasakaharetyakehena, xexa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hatyaoseta Jesus nexa haxaotyakiraharenai hiye: — Xasemehena, hatyaiya xinekonitare xane hatya hahinaehare hana nali wahaxati hoka nexaiya: “Nohinaehare, xama hisa nomani hanamalise nakairati. ");
INSERT INTO pabNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Hatya nohinaehare kalikini kaoka nomani haetonane hekota, hoka maisaiya xoare kakoa natyaijitene”, nexaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","— Hoka xiyahekola hiye tyaite hoka xihinaehare ekoaxahena enomana hahanakota: “Awa atyo hamawaiyenemakatya natyo! Jihore atyo koxaka jihotyoare, hoka natyo, nityaninai xoaha koxaka wehokotyoita. Maisaiya nainakoita hoka nijita homana nakairati”, nexaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","— Natyo atyo nomita xihiye: maisaiya ainakoita ihinaehare. Xakore hoka ainakoaite ekaoserene hiyeta hoka isaite hahinaehare ana tyotya aokitereharenai. ");
INSERT INTO pabNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hatyo hiyeta nomita: xaxehena hoka xikaoxekaka. Xataweniya hoka xikaokene. Xamokotyaiya hati jihola hiye hoka majiholateniya xomana. ");
INSERT INTO pabNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hiyaiya, tyotya axitereharenai ana atyo kaxekakita. Exahe tawiterenai atyo kaokitene. Exahe jihore atyo majiholatyoita mokotitereharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","— Xoana, hatya xinekonitare ityaniya axehena hanexe kohase hoka isaiya owi enomana? ");
INSERT INTO pabNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Xoana, axehena xamaniya eseti hoka isaiya xakolokoa enomana? ");
INSERT INTO pabNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Xisonai atyo maisa xakore xawaiyexe hoka xawaiyore atyo xijita xoaliniharenai waiyexenai xityaninai ana. Hoka exahexe atyoite Wexe enokoa tyaonitere isehena Isekohaliti Waiyexe xalanai xamani axehenene hoka! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus axanikihitita hatya haliti nonitata isekohaliti iniyalahare mairainititerene. Hoka isekohaliti hikoaheta hoka haliti iraexeheta. Hoka halitinai hakaharetyoaha ");
INSERT INTO pabNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","xakore hoka haiyaharenai nexaha: — Belzebu, isekohalitinai xekohasehare atyo ijita iyateliti exe haliti ana axanikiheta maheta isekohalitinai — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Haiyaharenai kasani hasakaharetyahene aokowiyahitaha hoka axahitene tyoma maheta xoalini hare hotikisa maheta haiyatere Enore nalitare. ");
INSERT INTO pabNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Xakore hoka Jesus waiyoreta exahekolaha kakoa hoka nexa: — Hakoa waikohekoa tyaoniterenaiya kirawanekakoaha hoka maisaiya kinatere tyaonehenahititaha, exaoretyakakoahaiya. Nikareya halyako tyaoniterenai kirawanekakoaha hoka xaorehaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hoka Ahalakoahaliti hotyalinaiya kahotyaliye hoka hatyokakoaha kirawane kakoahitaha hoka aliyakereya kinatere tyaohenahitiyaha? Hiyaiya, xisonai atyo Belzebu ijita iyateliti nomani naxikaheta maheta isekohalitinai xaokita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Belzebu isa haiyatere nomani hoka hatyo kakoa naxanikihitita tihanarenai xaokita. Nikareya hoka xala isa iyateliti xiyaotyakiraharenai ana hoka axanikihitita tihanarenai halitinai nonitata? Nikare xaokita hoka maisaiya tyakekota xiso xiyaotyakiraharenai. ");
INSERT INTO pabNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","— Aliterexe atyo Enore niyatere hiyeta naxanikihitita isekohalitinai hoka hatyoharenai atyo hotikijita Enore koamaniya nawenatyaka koxaka kaokehenerehare xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","— Hoka hatya haliti kinaterexe exahe kaxaisakarere atyo kaxaikohena hahanita hoka tyotya ixiyeharenai atyo katalatyakere tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Xakore hoka hatya haliti exahehare niyatereya jiya enomana hoka jiyahaotene hoka kolatyaiya exaisakalanai, hatyo hatya tyakekotere hoka, irakaiya hahinaeharenai ana tyotya kolahenere enonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","— Xala xamani atyo maisa kahinaetyare natyo hoka kahalakoahareta atyo nokakoi. Exahe xala xamani atyo maisa ahohisakoatyare nohakakoani hoka exaoretita atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Hoka Jesus nehitiya: — Xasemehena, isekohaliti iniyalahare hikoahetehena haliti milakota hoka xane tonakoaita maonexakoahare akiti, tawita hakawininaose. Hoka maisaiya atyo kaokita hakiti hoka nita atyo: “Nahaikoahetaite nohani xeta notyohenere nali xeta”, nita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hatyaoseta haikoaheta hoka kaokehitita hati ihisakotyakahare, waiye xomokakotyakere ana. ");
INSERT INTO pabNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hatyaoseta haikoaheta hoka xane nolokita hahotyali 7-harenai isekohalitinai exahehare niyalaharenai, hoka tyotyaha xane tyaonahitaha nali. Hatyo hiyeta hatyohare haliti nawenane hetatiye xahehare howitiharene tyaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hatyoharenai Jesus iraehenere najikinita hatya ohiro tyaonitolo halitinai nenekesene kawiyatya enomana: — Waiye kaiserehare atyo ohiro awenakihenolo exahe aokokihenolo hiso! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Xakore hoka Jesus nexa: — Exahehare nawaiye atyo etakeharenai semitereharenai Enore niraene hoka tyakekotereneharenai — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hatyaoseta kahare halitinai hohisakoaha Jesus haliya hoka iraehena hoka exakere nexa: — Kaxiyani, kalikiniyerenai maisa waiyexe! Axahitaha xoalini hare nomaka tyakekoha maheta, xoana aliterexe xamani Enore nalitare niyátere tyoita hoka. Xakore hoka maisaiya hatya hekoti kahotikisakita enomanaha, hoka Jonas tahi akereta taitaite. ");
INSERT INTO pabNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hiyaiya, iraiti xakaisasehare Jonas tahi tyare atyo aimenekoita wenakalati Nínive nali tyaoniterenai ana hoka Haliti Ityani tehitiya atyoite aimenekohena kalikiniyerenai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Xaxalisati ferakenite xekohasetiro Sabá yolo ite tityoa hoka iraeharehena xiso. Hiyaiya, sekota atyo tyoa sema maheta Salomão nawaiyore xaotyakiranai. Hoka natyo atyo nomita: kalikini ali tyaonitere atyo Salomão xahehare. ");
INSERT INTO pabNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Xaxalisati ferakenite Nínive nali tyaoniterenai tityoaha hoka iraeharehena xiso. Hiyaiya, halakisaha atyo iniyalahare háomaneha, semaha Jonas niraene hoka. Hoka natyo atyo nomita: kalikini ali tyaonitere atyo Jonas xahehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hoka Jesus nehitiya: — Maisa atyo xalahare aotakahena hatya xaokanatyakalati hoka mokarene metaharexe akiti, exahe xoana koho katyahe xamani. Xakore hoka mokita atyo xaokanatyakalati exomokakalaose terota, hoka hatya isoahena hoka waiye waiya maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Xosetinai atyo xaokanatyakalati akereta wiháre ana. Hoka hiyosenaiya waiyexenai hoka tyotya hiháre atyo xaokanatyakalati kakoare tyaonita. Xakore hoka hiyosenaiya maisa waiyexenai xini hoka tyotya hiháre atyoite makaliroti koni tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hatyo hiyeta maika hirihare hoka xaokanatyakalati tyaonitere hihiye maisa makaliroti tyaohitita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hiyaiya, tyotya hiháreya atyo xaokanatyakalati kakoare tyaonita hoka maisa atyo hakiti hekoti makaliroti koni tyaonare, hoka werokaite tyaona, motyaite exaokanatyakahare ene hatya xaokanatyakalati kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hatyaoseta Jesus halakisa hairaene hoka hatya fariseu nolokene kanakaira maheta ehanako. Hoka Jesus xane isoa hoka tyoka mexa haliya. ");
INSERT INTO pabNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hoka fariseu hakaharetyoa waiya Jesus matihahisoaneharene hanakaira nahitita hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hatyaoseta Xekohaseti Jesus nexa: — Xiso fariseunai atyo xatihita kobo, balatoahe xoaha henekoa maniya, hoka xityako atyo tyaonita xiyalijiniharene, exahe ximawaiyenawenanene taita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Maotikonexenai! Xala xamani atyo tyomita henekoa maniya hoka maisa enakoako maniya tyomitereta xini? ");
INSERT INTO pabNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Hatyo hiyeta xisehena maoloxaharenai ana tyaonitereharenai xikobonenai, xibalatoahenekoarenai. Nikare ite hoka tyotyaite iyomeheta xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","— Kirakoane ite xiso fariseunai xikaxomokaka! Hiyaiya, xijita atyo Enore ana holini hortelã, arruda, tyotya atya hana kanakoairoarenae xoaha hiyeta. Xakore hoka xahalakijita atyo Enore nawaiyexehare exahe xawaiyera. Nikare ene atyo hatyoharenai xisomehena exeharenai ximahalakirahareneta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","— Kirakoane ite xiso fariseunai xikaxomokaka! Hiyaiya, xawaiyetita kaiserehare atyo kaxaiminisakitereharenai aosenai xahohisakoatyakalati hanakonai, exahe kakatyawaxatyakiterehare xihiye xaiminisati kakoa halitinai wetekonekoanai — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","— Kirakoane ite xisaona! Hiyaiya, motya atyo xawatyakalatinai mawaiyakaharenai akereta atyo xisaonita, xawatyakalatinai halitinai tyahakitere hamawaiyanenahitaha akereta atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hatyaoseta hatya Xaotyakiyaho kakoa waiyoretere nexa Jesus hiye: — Xaotyakisatiye, nikare hiraeta hoka hexamaikohalinikijita tehitiya wiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Hoka Jesus nexa: — Kirakoane tehitiyaite xikaxomokaka, xiso Xaotyakiyaho kakoa waiyoreterenai! Hiyaiya, xamokita atyo kolare timenere haiyanai hiniri, hoka komitaene maisa kolatyarahene. Xakore hoka xisonai maisa xikahihikase kakoa hekoti xakahinaetya xakolatyare hatyo kolarenai. ");
INSERT INTO pabNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","— Kirakoane ite xisaona! Hiyaiya, xisomita xawatyakalatinai waiyehare iraiti xakaisaseharenai ana, xahetakomaniyereharenai aisehenerenai anita. ");
INSERT INTO pabNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hoka hatyo hiyeta xahotikijita atyo xiyafihira xahetakomaniyereharenai tyomehenerehare. Hiyaiya, aisaha atyo iraiti xakaisaseharenai, hoka xiso atyo xisomihitita exawatyakalanaiha. ");
INSERT INTO pabNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","— Hatyo hiyeta Enore hawaiyore hiyeta nexa: “Naxikatyaite enomanaha iraiti xakaisaseharenai, exahe iraiti kakoarenai. Hoka aisahaite haiyaharenai, kahalakoaharehaite haiyaharenai kakoa”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hatyohare hiyetaite kalikiniyerenaite iniyalahare kaxomokakaha tyotya iraiti xakaisaseharenai kaxaisakehenereharenai hiyeta, hetati kaomakehenere waikohekoa xowakiyata, ");
INSERT INTO pabNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","hetati Abel kaxaisakehenereta Zacarias kaxaisakehenere kijiya. Hatyo atyo kaxaisaka jihatyakalati, Waiyexe Aose xoaha nenekesene. Aliterexe atyo nomita: kalikiniyerenaite iniyalahare kaxomokakaha tyotya hatyoharenai xaisati hiyeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","— Kirakoane ite xiso Xaotyakiyaho kakoa waiyoreterenai xikaxomokaka! Hiyaiya, xatyakaijita atyo waiyoliti hana jihola jafini. Nikare hoka maisa xisonai hekoti xisoare, exahe maisa haiyaharenai hekoti xahalakisa hoka isoareha — nexa. (“Xatyakaijita atyo waiyoliti hana jihola jafini”, nitere atyo: fariseunae mahokoanititere haiyaharenae semaxemala Iraiti Waiyexe xaokaka nikareta.) ");
INSERT INTO pabNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hatyaoseta Jesus hikoaheta nalita hoka Xaotyakiyaho kakoa waiyoreterenai, fariseunai xoaha iraeharehenene haxehareneha kakoa, exahe axahenene kahare xoalini hare. ");
INSERT INTO pabNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kasani Jesus irae xoalinihare ehaikoare hoka komaniyatyoa aokahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kahare halitinai hohisakoaha hoka tyahakehetyakakoahitaha. Hatyaoseta Jesus nexa haxaotyakiraharenai hiye hotohare: — Xiriharira fariseunai kaorehityakala kakoa. Emaoseralaha xaokaka niraeta. ");
INSERT INTO pabNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tyotya kaxaihonolisakiterehare atyoite maxaihonolisakeheta, exahe kaxateroakisakiterehare atyoite maxateroakisakeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nikare ite hoka tyotya xiraetereharenai makaliroti koni ite kasemakeheta ferakoa xowaka. Exahe tyotya xiraetereharenai ximeteneta hati jihotyoarako atyoite kaxakaisakeheta hatirinai henota — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesus nehitiya: — Natyo atyo nomita xihiye: awa atyo ximaira etakehare aijitereharenai xiháre taita, hoka hatyo najikinita maisa xoare hare tyomihititerehare. ");
INSERT INTO pabNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Noxakaite xihiye xala xamaniya atyo ximairehena: maika ximairehena Enore. Hiyaiya, aisehenere najikinitaiya atyo iyateliti kakoare hoka xawatyaiya atyo haliti irikati koni. Aliterexe niraehitiya: maika ximaira Enore! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","— Xoana maisa kabetetyakere 5-lise kotehalasenai haiyahokosenai olo hokosenai xaimanexe? Xakore hoka Enore atyo maisa maotyanexe halisenai hekoti enekonitareha. ");
INSERT INTO pabNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xisekasenai kakoita atyo tyotya ixihatyakahare. Awa atyo ximaira. Hiyaiya, xawenane atyo kaharexe kotehalasenai xahexe! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesus nehitiya: — Natyo atyo nomita xihiye: hatyaiya atyo irae halitinai haotita hoka nomaniye aokowi, hoka Haliti Ityani tehitiyaite irae Enore anerenai anjonai nahalakoa hoka hatyo haliti atyoite haomanere aoka. ");
INSERT INTO pabNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Xakore hoka xala xamani atyoite halitinai haotita maisa nomaniye xini aokowi, hoka Haliti Ityani tehitiya atyoite Enore anerenai anjonai nahalakoa maisa haomanere xini aokene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","— Xala xamaniya atyo irae iniyalahare Haliti Ityani tahi hoka kamaotyanetyakeheta atyoite. Xakore hoka xala xamaniya atyo irae iniyalahare Isekohaliti Waiyexe tahi hoka maisaiya atyo kamaotyanetyakehitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","— Maika kolahenaha xiso semaha maheta xitahi xahohisakoatyakalati hanakonai, exahe xoana kalorexenai, waiyorexenai xoaha nahalakoa xamani hoka, awa atyo ximawaiyehare, exahe xahekotya xiyekoaxala, xiraene xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hiyaiya, hatyo xowaka atyoite Isekohaliti Waiyexe aotyakihena xiso xiraehenerehare kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hoka hatya haliti tyaonitere halitinai nenekesene nexa Jesus hiye: — Xaotyakisatiye, hiraehena axexe hiye hoka waiye wirakakakoa xiyehaliti wexe halakihenerehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","— Xoana, natyoiyatya hoka? Maisa atyo xala hare wakaita natyo niraka maheta xiyehaliti halitinae ana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hoka nehitiya tyotya ihiyeha: — Waiyira xasemehena: maika xirihare tyotya xoalinihare kaxaokakitereharenai kakoa. Hiyaiya, hatya nawenane aliterexe atyo maisa ixiyehare hiyeta xini tyaonita, exahiya kahare hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hatyaoseta Jesus nexa xakai exe xaimenekotyati: — Hatya haliti kaoloxere tyaonita hoka emasenekoarenai exaferanai ihatihena kalore. ");
INSERT INTO pabNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hatyaoseta ahekohena: “Maisaiya atyo xoarako natyakaijita tyotya exe inihatihenerenai. Xoare ite notyomehena? ");
INSERT INTO pabNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kala exakere ite notyoma: nexoakihetaite noximexaninai nitininai hoka notyomeheta exaheharerinai. Hoka hatyoako ite namoka tyotya noximexaninai hahotyalita tyotya haiyanai noxiyeharenai kakoita. ");
INSERT INTO pabNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hatyaosetaite nomihena nomanita: ‘Haliti ihalaharexe! Tyotya waiyexe haokitereharenai kakoare atyo hiso waha terehokoane niyahare. Kalikini hikawinihena, hikanakairehena, hiserehena, hihalaharehena!’ nomite”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","— Xakore hoka Enore nexa ihiye: “Maotikoniti! Exe xatinite hiwainihena, hoka xalaite tyaohena tyotya exe hamohenereharenai kakoa?” nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Hoka Jesus kamiyanetene: — Hatyo akereta atyo tyaonita etakeharenai ahohisakoaitereharenai haxiyeharenai haomanahitaha, xakore hoka maisa atyo kaxiyeharexeha Enore nahalakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hatyaoseta Jesus nexa haxaotyakiraharenai hiye: — Hatyo hiyeta nomita xihiye: awa atyo ximawaiyehare nakairati xaokitereharenai xawenane niyahare kakoa, exahe imiti xaokitereharenai xiyisoane niyahare kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hiyaiya, wenati atyo nakairati xahexe, exahe wiháre atyo imitinai xahexe. ");
INSERT INTO pabNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xiyaiyehenaore kololokarenai: maisa fityareha, maisa imexareha, maisa awaiyetolisareha hanakaira, maisa nakairati xomokakala kakoareha hekoti xini, xakore hoka Enore atyo tyaisahitene! Hoka xoana maisala kotehalanai xahexe xini xiso? ");
INSERT INTO pabNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Xala hareya xinekonitare mawaiyehareta hoka hatyo hiyeta tyaohitiya haiya terehokoanenai jiyare? ");
INSERT INTO pabNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hatyo hiyeta maisaiya xikaokare nikarehare kiranexe hoka xoanere hoka ximawaiyehareta haiyanai kakoa? ");
INSERT INTO pabNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","— Xiyaiyehenaore iyitinai masekoa tyaoniterenai kekoarene: maisa atyo hakareha, maisa haimaha tyomareha haomanaha. Xakore hoka natyo atyo nomita: maisa Salomão hekoti, kaoloxere xakore hoka maisa imiti exe iyitinae nawaiyehare akere ako isoare. ");
INSERT INTO pabNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Enore xaokalita atyo atyamokose ime harenae waiyehare tyaonita. Kalini waiyehare tyaonitaha hoka makani wainihenahitaha hoka kakeratyakahitaha irikatyaose. Hatyo hiyeta aliterexe ite kaimatya tehitiya xiso. Hoka xityakekone atyo kirane. ");
INSERT INTO pabNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hatyo hiyeta awa atyo ximawaiyehare hoka xataweta mene xinakaira, exahe xoana xeráne niyahare xamani. ");
INSERT INTO pabNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hiyaiya, hahotyaliharenai atyo nikare taweta menahitaha tyotya hatyoharenai. Hoka Xexe enokoa tyaonitere atyo waiyoreta tyotya xaokitereharenai kakoa hoka hatyoharenai atyoite isa xomana. ");
INSERT INTO pabNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Enore koamaniya nawenatyaka maniya hotohare xamohena xawenane, hoka Enore ite isa xomana tyotya hatyoharenai — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Hoka Jesus nehitiya: — Nokaxaikoneharenai, maisa xikaharexe xakore atyo hoka awa atyo ximaira! Hiyaiya, Xexe atyo hamaxalone kakoa isehena xomana wenakalati waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xabetehena tyotya xixiyeharenai hoka xisehena olo maoloxaharenai ana. Xisomehena xiyehaliti nitini maxololoneharenai hoka xaxakaihena xixiyeharenai enokoa nali. Nalite maisa tyotyahitaha. Hiyaiya, nali atyoite maisa kaiwarexenai kaiwitene, exahe maisaiya atyo mololotinai mawenekoaretitene. ");
INSERT INTO pabNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hiyaiya, aliyo xamani atyoite xixiyeharenai tyaonita hoka hatyo nali atyoite xiyahekola tyaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Hoka Jesus nehitiya: — Memerira xisaohena tyotya kaotyakehenereharenai niyahare: xima ira kinatya xakirolohena jitero kakoa, exahe xaokanatyakalati takoare xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xisaohenaira wakaharenai atyahiterenai haxekohaseha kaokeneheta xahita wenakakoati hisehare hekota akereta. Mokohetehena jihore hiye hoka ewakaneharenai majiholahititere haxerore enomana akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Waiye kaiserehare atyo wakaharenai kaokehetehena exekohaseha hoka kaosetaha exahe memere tyaoniterenai! Hoka aliterexe atyo nomita: exekohaseha ite tyoma tyaisahene maheta, wakatyahenite tyokaha maheta mexa haliya, hoka hatyotaite moka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Waiye kaiserehareya atyo exekohaseha kaokehetehena hoka memere tyaonahitaha, exahe kaokehetehena wahaxati, xoana ferakoa maniyehena xamani hoka! ");
INSERT INTO pabNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","— Xotyaxematyaira exeharenai: hati waikatehareya atyo waiyoreta kaiwarexe kaokene kakoa hoka atyahiteniya hoka maisaiya ehanakota kaiwaharetitene. ");
INSERT INTO pabNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hatyo hiyeta xiso tehitiya ximemere xisaohena. Hiyaiya, Haliti Ityani ite kaokeheta xomana ximaxatyahaneterene xowaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hatyaoseta Pedro axene: — Xekohaseti, hatyo xaimenekore womanere taita, xoana tyotyahanai anere kore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Hoka Jesus nexa: — Xoanere haretya wakahare tyakekohatiye exahe iriharexe? Hatyohare atyo etakehare exekohase hawenekoare halakisene hoka kaxaikoterehare ehana exahe ijiterehare nakairati wakaharenai ana enaose kamaehena hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Waiye kaiserehare atyoite hatyohare wakahare, nikare tyomita hatyoharenai hoka exekohase kaokehetehena hoka! ");
INSERT INTO pabNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aliterexe nomita xihiye: exekohase ite hatyo wakahare ana tyotya haxiyeharenai halakisa kaxaikone maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","— Hoka xahekohenaore: xoana halanite kaxomokakehena hatyo wakahareya exakere ahekotya hoka: “Noxekohase atyo howitihareta hatyoaneneheta kakoa”, nexaiya, hoka hatyaosetaiya mokonasehenaiya haiyaharenai wakaharenai, wakahalonai. Hoka kanakairehenaiya, terehenaiya, hekehenaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hatyaosetaiya exekohase tyoheta haferakene ewakanehare maxatya haneterene, mawaiyoreterehare ekaokeneheta ferakene kakoa xowaka. Hoka exekohase ite aikotene hataose xakini, exahe iniyalahare ite mokene masemaxemalaharenai xomokakaho akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","— Hoka wakahare waiyoreterehare haxekohase aokiterehare hoka maisa memere tyaonare, exahe maisa tyomiterehare aokiterehare atyoite kamokonasetyaka kalore. ");
INSERT INTO pabNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hoka wakahare mawaiyorehare haxekohase aokiterehare kakoa hoka tyomiterehare xoalinihare hoka akomaniyatyakijoiterehare atyoite kamokonasetyaka ininaita. Nikare ite hoka xala xamani kalore resebitita hoka kalore ite kaxaxaka xala nonitata xamani kalore karesebetita hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Hoka Jesus nehitiya: — Notyoa atyo naotakatya irikati waikohekoa maheta hoka kasani koxaka ekeratyakahare nowaiyene naokowita! ");
INSERT INTO pabNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nokabatixatyakihenaite hoka kaxiyani, kalore namaikohareta hatyoharenai kaotyakehenerehare kijiya! ");
INSERT INTO pabNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Xoana motya xiyahekola hiye hoka notyoa namehexaikohalikiheta halitinai maheta xaokita? Hoka natyo atyo nomita: hoka maisa atyo notyoa namehexaikohalikiheta maheta xini, xakore hoka nexaoretya maheta atyo. ");
INSERT INTO pabNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hiyaiya, exaoseta atyoite hahotyalita 5-harenai tyaoniterenai exaoretyoahena: hanamaite kahalakoaharehena hinamerore kakoa, exahe hinamerore ite kahalakoaharehena hanama kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Enexenahaite kahalakoaharehenaha haisaninaiha kakoa, exahe ityaninaihaite hoka kahalakoaharehenaha hanexenaiha kakoa. Inityonahaite kahalakoahalohenaha haisaninaiha kakoa, ityaninaihaite hoka kahalakoahalohenaha hanityonaiha kakoa. Enakeronaihaite kahalakoahalohenaha hatamisonenaiha kakoa, etamisonenaihaite hoka kahalakoahalohenaha hakeronaiha kakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hoka Jesus nexa tehitiya halitinai hiye: — Xiyaiyehena atyo kaiminiti makiti maniyata hoka xita rotita atyo: “Onehenaite wihiye”, xita. Hoka aliterexe oneta. ");
INSERT INTO pabNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Exahe xikehexehena atyo hoholati hoholala watere maniyata hoka xita: “Watehenaite”, xita. Hoka watita. ");
INSERT INTO pabNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Maotikonitinae! Xawaiyore atyo xawaiyekehalakaita waikohekoa, enokoa xoaha tyaonitereharenai. Hoka xoanere hoka maisa xawaiyore xawaiyekehalakatyare kalikini kaotyakitereharenai? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hoka Jesus halakihena hairaene hoka nexa: — Xoana hoka maisa xisota xahekotyare, xoarehare maniya xamani waiye nawenatyaka hoka? ");
INSERT INTO pabNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maika hatya iraeharehena hiso hoka kolahena hiso kalorexe ana hoka maika hatihityoa ihiye hoka hamiyatya hatyoharenai tahi ahotita. Nikare ite hoka maisa kolaita hiso kalorexe nahalakoa, hoka kalorexe ijita hiso sorare ana, hoka sorare berexoako mokita hiso. ");
INSERT INTO pabNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Natyo atyo nomita: maisaiya hahikoahitita hatyoakota, maisa habakaita tyotya aokiterehare hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hatyaoseta haiyaharenai kaokaha hoka xakaihenaha Jesus hiye, Pilatos wakane xema Galiléia koa yerenai fetatyahitere Enore ana heko aisehenahere tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hatyaoseta Jesus nehena: — Xoanala hoka hatyo Galiléia koa yerenai nikare kaxaisakaha, xoana xiyahekola hiye hoka motya masakare iniyalahare tyomahitaha, haiyaharenai Galiléia koa yerenai xahexe xaokita? ");
INSERT INTO pabNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Maisa nikarexe xini. Aliterexe nomita xihiye: maisaiya xahalakijita iniyalahare xománenai hoka nikare ite xikaxaisaka. ");
INSERT INTO pabNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hoka etake Siloé nali, 18-harenai heno hati wahaharexe hatakoa hoka aisehenerenai? Xoana xiyahekola hiye hoka motya masakare iniyalahare tyomahitaha haiyaharenai Jerusalém nali tyaoniterenai nonitata xaokita? ");
INSERT INTO pabNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Maisa nikarexe xini. Alitere nomita xihiye: maisaiya xahalakijita iniyalahare xománenai hoka nikare ite xikaxaisaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hatyaoseta Jesus exakere aimenekotya enomanaha: — Hatya haliti masenekoa uva katenai koni hakate halohalo tyaonita. Hoka xane iri xahita waiyakatetya hoka maisa kaliye. ");
INSERT INTO pabNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hatyo hekota nexa masene kaxaikotyasehare hiye: “Hasemehena, hanama wanonehena notyoa iri nimexa naokowita hoka maisa terota kaliye. Maika hityoka exe halohalo kate! Xoare maheta hahalakijitene masenekoa, maisa xakore kaliye hoka?” nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hoka ewakanehare nexa: “Xekohaseti, kala kotare hahalakihitiyene exe wanone niyahare. Naijohokotene ite hoka imexati kakoa namokahokotene. ");
INSERT INTO pabNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ite etare wanone kali hoka ehekore. Ite maisa kalita hoka ixityokaka haoka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sábado xowaka Jesus aotyakijita ene xahohisakoatyakalati hanako. ");
INSERT INTO pabNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hoka nali kaoka hatya ohiro koxaka 18-wanonehena hokakitolo. Isekohaliti iniyalahare nikare axomokanikijitene. Katyokohexe tonita, maisa aliyakere aototahalotyoare. ");
INSERT INTO pabNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hatyaoseta Jesus waiyene hoka kawisene hoka nexa ihiye: — Hasemehena, koxaka atyo hikinatolohetehena — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hatyaoseta hakahenai ekaokakisa ihiye hoka totahalohetehena rotita. Hatyaoseta ihalahalo Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Xakore hoka hatyo xahohisakoatyakalati hana kaxaikotyasehare ehare, sábado xowaka aiyatolokihetene hoka. Hatyo hiyeta nexa halitinai hiye: — 6-ki ferakene atyo hateniti niyahare. Maika hatyonai ferakenenai xisoa hoka xikaxaiyatelikisakeheta hoka awa atyo sábado xowaka nikare xisaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hoka Jesus nexa: — Maoseratyaliyenai! Xoana maisa sábado xowaka xamaxolatyare xibowiya, xikawalone hoka xiyanexe ekakoaha one ana teraha maheta? ");
INSERT INTO pabNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hoka kalikini atyo owene tyaonita Abraão jikolahalo, Ahalakoahaliti olahenolo 18-wanone. Hoka xoanereya hoka maisa sábado xowaka kaxaiyatolokisakihitita ehokakene nonitata? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hatyaoseta Jesus niraene sema enahalakoaharenai hoka haihareha. Xakore hoka halitinai atyo ihalahare Jesus nómanenai waiyexe kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus nexa: — Xoare hare kakoala hakakoa Enore koamaniya nawenatyaka? Xoarehare kakoaite naimenekohena? ");
INSERT INTO pabNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Motya atyo mostardase hatya haliti iya hoka fititere hamasenekoa akereta. Hoka hananehaliti kekoare hoka kalokate tyaona hoka kotehalanai kaihititere ekanohinai koni akereta atyoala — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus nehitiya: — Xoare kakoaite naimenekohena Enore koamaniya nawenatyaka? ");
INSERT INTO pabNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Motya atyo hatya ohiro xetamomotyakalati iya hoka kaorehititere trigohe hoka hatyaoseta trigohe tamomotere akereta atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hatyaoseta Jesus jiyehena wenakalati, wenakalatikoasenai hoka aotyakijita, exahe xaneta Jerusalém xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hatyaoseta hatya axene: — Xekohaseti, xoana haiyanai taitaite kaiyakehetehena? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Hoka Jesus nexa ihiyeha: — Maika xaiyateretyoa xisoa maheta xisoakalati kiranahore. Aliterexe nomita xihiye: kahare ite isoa aokowiha xakore hoka maisa atyoite isoahitaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","— Hati waikatehare ite xane jihotya hahana jihola. Hatyaosetaite menanakita xisaona hoka xamokotya ite jihore hiye hoka xehena: “Xekohaseti, hamajiholatya womana hoka wisoa”. Xexaite ihiye xakore hoka nexaite: “Maisa atyo nowaiyanihare xini xiso, kala alyakotare xamani xiso”, nexaite. ");
INSERT INTO pabNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hoka xehenaite: “Wikanakaira, wisera hikakoa, Xekohaseti. Haotyakisa tehitiya wiso wawenakala nali”, xexaite. ");
INSERT INTO pabNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Xakore hoka nehitiyaite: “Maisa nowaiyanihare xini xiso. Kala alyakotare xamani xiso. Xiyanehetehena noniti, xiso iniyalahare taita tyomiterenai”, nexaite. ");
INSERT INTO pabNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hatyaosetaite xiyaiyehena Abraão, Isaque, Jacó, tyotya iraiti xakaisaseharenai xoahanai, Enore nawenakala nali hoka xiso atyoite menanakita hoka hatyaosetaite xitiyahena, exahe xaikolinaite karai, karai, nexa xamohena. ");
INSERT INTO pabNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kahare halitinai ite tyoaha kamae hikoane maniyata, kamae xisoane maniyata, one hohola maniyata, tihalo hohola maniyata hoka tyokahaite mexa haliya Enore nawenakala nali. ");
INSERT INTO pabNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hoka haiyaharenai kalikini wakahare tyaoniterenaite kalorexe tyaoheta. Hoka haiyaharenai kalorexe tyaoniterenaite wakahare tyaoheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hatyaoseta haiyaharenai fariseunai xaneha Jesus haliya hoka nexaha ihiye: — Maika hiyanehetehena alita. Hiyaiya, Herodes aisa aokowita hiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hoka Jesus nexa ihiyeha: — Xiyaneheta hoka exakere niraini xiyakai hatyo wakare hiye: “Naxanikihitita tihanare, exahe naiyatelikihitita halitinai kalikini, makani xoaha hoka ehanamakini ferakenite namematya nohateni”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Xakore hoka noxanihitiya atyo kalikini, makani, kamaetali. Hiyaiya, iraiti xakaisasehare atyo maisa aliyakere kaxaisakita Jerusalém nonitata haware — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","— Jerusalém, Jerusalém! Hiso atyo haijita iraiti xakaisaseharenai, exahe sehali kakoa hamokotita Enore xaxikalaharenai! Kahaliki xakore naxakoloharetya naokowita hihotyaliharenai takoira haisani mokosenai hatane katyahe mokitere akereta, xakore hoka maisa atyo haoka. ");
INSERT INTO pabNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hoka kalikini atyoite hihana kahalakisakehena kaiserehare. Aliterexe nomita: Maisa atyoite hiyaiyehitita natyo exakere hiraehenere kijiya: “Xekohaseti Enore, waiye kaiserehare atyo hatyo hexare kakoa tyoiterehare”, hehenere kijiya — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sábado xowaka Jesus xane isoa hatya xekohaseti fariseu hanako kanakaira maheta. Hoka wahakotyahitaha Jesus ana. ");
INSERT INTO pabNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hoka hatya haliti kasahenai, kanonai xoaha fakitere tyoa ehaliya. ");
INSERT INTO pabNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hatyaoseta Jesus axehena Xaotyakiyaho kakoa waiyoreterenai, fariseunai xoaha: — Xoana wiyaotyakisakaho hiyetaiya waiyehena wawairatya sábado xowaka, maiha koré? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hoka maisa xoare nexahitaha. Hatyaoseta Jesus otoka hatyo haliti hoka aiyatelikihetene. Hatyo najikinita axikahetene. ");
INSERT INTO pabNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hatyaoseta nehitiya ihiyeha: — Hoka xisonaiya, hamokose xikaisaniye exahe hali xikabowiyere hoka exoa tolokoako hoka maisaiya xiyehititene rotita, exahe sábado xowaka hoka? nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hoka maisa waiyore ekoaxatyahitaha enomana. ");
INSERT INTO pabNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hatyaoseta Jesus wahakoita kakaixakatyakehenerenai kaokene hoka waiyexe mexa haliya enokaneha. Hoka exakere aotyakisa: ");
INSERT INTO pabNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Hatya kaixakahena hiso wenakakoati ana hoka awa atyo okahakalatikoa waiyexe koa hisoka. Waiya aliya hoka hatya hiyahehare kakaexakatyaka hoka ");
INSERT INTO pabNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","hatyaosetaiya kaexakahenere hiso, hatya xoahaiya, nexa hihiye: “Hainakoaheta hoka exe hatyaose tyoka”, nexaiya. Hoka hatyaosetaiya hihaihare, exahe ewaxirahare okahakalatikoaiya hiyane hisokeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hoka maika hikakaixakatyakehena hoka ewaxirahare okahakalatikoa hiyane hisoka. Nikare ite hoka kaexakahenere hiso ite nexa: “Nohinaehare, hisohena hoka exe okahakalati waiyexe koa hisoka”, nexaiya. Nikare ite kalore hikaxaiminisakita tyotya kakaexakatyakehenerenai nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hiyaiya, xala xamani atyo ite kalorexe aokowita hoka wakahare atyoite kaxomokakeheta. Hoka xala xamani atyo ite maisa haiyanae xahehare aokowita hoka kalorexe atyoite kaxomokakeheta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hatyohekota Jesus nexa hakaixakatyasehare hiye: — Maika nakairati kalore hisomehena halitinae ana totahikoa niyahare, exahe makehena niyahare hoka awa hakaixakatya hihinaeharenai, hiximarenenai, hiyaiyaneharenai, hihinaeharenai kaoloxerenai taita hoka. Hiyaiya, hatyoisahaiya kaixakatyaha hiso hoka hatyo kakoaiya bakahenahitaha hiso waiye hamohenaherene. ");
INSERT INTO pabNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Xakore hoka maika hisehaliti hisomehena hoka hakaexakatya maoloxaharenai, maetonaneharenai, mawaiye netonaneharenai, maxoseharenai harenai, ");
INSERT INTO pabNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","hoka waiye atyoite hikaxomokaka. Hiyaiya, maisaiya atyo aliyakere bakahenahititaha hiso, xakore hoka Enore atyoite bakatya hiso, waiyexe nomaseharenai ekasekihetehenere xowaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hatya tyokitere ekakoaha mexa haliya sema iniraene hoka nexa Jesus hiye: — Waiye kaiserehare atyoite xane mexa haliya tyokehenerenai Enore nawenakala nali — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hatyaoseta Jesus nehena: — Hatya haliti kaexakatya kahare haliti, kaolonehena hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Memakatya hoka axikatya hawakanehare kakaexakatyakehenerenai hiye: “Xisohena, koxaka tyotya memaka”, nexa maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","— Xakore hoka hatya xakini awaiyekehalakahena. Hetatiye nexa wakahare hiye: “Niya hakoa waikohe hoka noxanite nowaiyehenene hoka maisaiya aliyakere notyoita. Kasani himaotyanehetene naoka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hatya atyo nexa: “Niya 10-ri bowi hoka noxanite nowaiyehenene, xoana waiyore xamani ala hakahitaha. Hatyo hiyeta maisaiya aliyakere notyoita. Kasani himaotyanehetene naoka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Exahe hatya hoka nexa: “Kalikini nokaiyanityo. Hatyo hiyeta maisaiya aliyakere notyoita”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","— Hatyaoseta haikoaheta hoka xakaini haxekohase hiye. Hatyaoseta exekohase ehare hoka nexa: “Hihalahare hiyanehena ahotyahonai exahe ahotyahoseranai wenakalati nali hoka hanoloka maoloxaharenai, maetonaneharenai, maxoseharenai, mawaiye netonaneharenai xoaha”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","— Hatyaoseta wahehena hoka ewakanehare nexa: “Xekohaseti, koxaka haokitere akereta notyoma, xakore hoka hekotata maisa hihana kaisexe”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","— Hoka exekohase nexa: “Nikare atyo hoka hiyanehena ahotyaho kaloahore, ahotisenai aho hoka hahalakoahenerenai hiye hirae, tyoaha maheta ali hoka nohani ekaisetyaha. ");
INSERT INTO pabNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aliterexe nomita hihiye: hetati kakaixakatyakehenerenai atyoite maisa kanakairahitaha nakairati notyomehenere”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hatyaoseta kahare halitinai xanetaha Jesus xema. Terehokoa hoka nehena ihiyeha: ");
INSERT INTO pabNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Xala xamaniya atyo tyaona nokoamaniye aokowita hoka maisaiya atyo noxaotyakirihare tyaonita, maisa awaiyetyare natyo hanexe, hanityo, haiyanityo, haisaninai, haximarenenai, haximalonenai, exahe hatyota awaiyetyoawitere xahexe hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Xala xamaniya atyo maisa kolaita haberekotyaka niyahare atyalihose xaimaholatyaka, exahe maisa tyaonita nokoamaniye hoka hatyoiya atyo maisa noxaotyakirihare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","— Hiyaiya, hatya xinekonitare ahekoita háomane hati wahaharexe tahi hoka tyoka hotohare exahe aimenekotene hoka exaimane waiya, xoana ehekorexe xamani olo. ");
INSERT INTO pabNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Maisaiya nikare tyomita hoka tyomehenene rotitaiya hoka maisaiya aliyakere mematitene, hoka tyotyahaiya waiyaha emamemarene hati hoka koexahaxahenahaiya ekakoa hoka nexahaiya: ");
INSERT INTO pabNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Exe haliti tyoma hati hoka maisa mematitene!” nexahaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","— Nikareya hatya xekohaseti, 10.000 sorarenai kakoa xane aisakakoahena hatya hahalakoahare kakoa hoka tyoka hotohare ite hoka ahekohena, xoana kinatere xamaniya aisakakoa hahalakoahare kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Maisaiya kinaterexe hoka axikatyaiya hairaene kakoa hatya xekohaseti ana sekotata hoka axene maheta, xoare xamani aokita hoka halakisaha haxaisakakoaneha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hatyaoseta Jesus halakihena hairaene hoka nexa: — Nikare ite maisaiya hatya hekoti xinekonitare noxaotyakirihare tyaonita, maisa halakijita tyotya haxiyeharenai harenai hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","— Xasemehena, salo atyo waiye, xakore hoka makexeniya hoka maisa atyo saloheta xini. ");
INSERT INTO pabNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Maisa atyo waikohe niyahare, exahe exawaiyetolisaka niyahare ana hekoti waiyihitita. Hoka kaxawatyakita atyo kolaliti koni. — Xala xamani atyo katanakoakore semakatya maheta hoka maika semehena niraini — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Haxowaka kahare kalorexe noloxa resebetyaseharenai, exahe haiyaharenai iniyalahare nomaseharenai xoaha kaokaha Jesus ana, semaha maheta iniraine. ");
INSERT INTO pabNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hoka fariseunai, xaotyakiyaho kakoa waiyoreterenai xoaha iraehenaha etahi hoka nexaha: — Exe haliti atyo iniyalahare nomaseharenai koni tyaonita exahe kanakairita ekakoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hatyaoseta Jesus exakere aemenekotya: ");
INSERT INTO pabNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Hatya xinekonitareya 100-ri kakalaneroxere hoka haliya meta hoka xane ite tawehetehenene, maiha kore ite? Hatyo hiyeta halakisaite 99-ri maseta hoka xane ite tawehetene kaokehetehenerene kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kaokeheteniya hoka ihalaharetaiya ekakoa hoka hatyoakolyahoiya kolahetene hoka haikoaheta ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kaokehetaiya ekakoa hahana nali hoka kawisaiya hahinaeharenai, hawaiyaneharenai hoka nexaiya: “Xihalaharehena nokakoi. Nokaokiheta nokalaneroxi mititere”, nexaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","— Hatyo hiyeta nomita: hatyo akeretaite kalore ite kaihalaharetyaka enokoa nali, hatya haliti iniyalahare nomasehare halakihenere iniyalahare háomane kakoa, 99-harenai iniyalahare maomaneharenai, koxaka waiyexe wenati xema tyaohetehenerenai xahexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Hatyaoseta Jesus iraehitiya: — Hatya ohiroiya kaoloxolo 10-hokose hoka hahokoseya meta enonita hoka taweheteneya, maisaiya kore? Kaokeheta mahetaiya olo hokose hoka aotakatyaiya xaokanatyakalati, hisakotyaiya hati ako hoka waiyeya taweheta exahita kaokehetehenerene kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kaokeheteniya hoka kaixakatyaiya hahinaehalonai, hawaiyanehalonai hoka nexaiya: “Xihalahalohena nokakoi. Nokaokiheta atyo noloxi mititere”, nexaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","— Hatyo hiyeta nomita: nikareta tehitiyaite Enore wakaneharenae anjonai ihalahareha, hatya iniyalahare nomasehare halakihena iniyalahare háomane hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hoka Jesus nehitiya: — Hatya haliti hinamahare kaisaniye. ");
INSERT INTO pabNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hoka haxowaka ityani xoimere nexa hanexe hiye: “Abá, xama kalikini hisehena nomani holini hixiyehare, noxiyehare maheta”, nexa. Hoka enexeha iraka haxiyeharenai haisaninai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","— Hatyaoseta mawaheneta hoka ityani xoimere xakaiharetyoa hoka xane hakoa wenakalati xeta. Hatyo nali wenati iniyalahare xema taita tyaona, exahe miyatya tyotya haxiyeharenai kaxekakehenere enomana. ");
INSERT INTO pabNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","— Miyahenere tyotya haxiyehare najikinita nakiti tyaona hatyo tyaonitere nali hoka xoimahaliti nakehena. ");
INSERT INTO pabNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hatyaoseta tawa hatya nali tyaoniterenai konitare hoka hakahinaetyaka aoka. Hoka hatya axikatya xoimahaliti hawenakala xeta, ebolokoxanai kaxaiko maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hoka hatyo nali nakita hoka kasani bolokonai kanakairiterehare kanakaira aokowita, xakore maisa hatyoharenai hekoti isaha enomana aokowiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","— Hatyaoseta kehexaharetyoaheta hoka ahekohena: “Xoanamahare baba wakaneharenai nakaira ala kalikini kamawaneta hoka natyo atyo ali nowainihena nonaki! ");
INSERT INTO pabNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nahaikoahetaite baba hana xeta hoka nomite ihiye: ‘Abá, iniyalahare notyoma Enore ana, exahe hikakoa ");
INSERT INTO pabNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","hoka maisaiya atyo hityani haohitita natyo. Maika hiwakaneharenai akereta hamoka natyo’, nomite”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hatyaoseta kikisoaheta hatyo nalita hoka haikoaheta hanexe hana xeta. — Xanehititata hoka enexe sekota waiyehetene. Hoka airakoaneharetya haisani hoka tema xane ahalakoatene, xakoloharetene, sohitanakolisene xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hoka xoimahaliti nehena: “Abá, iniyalahare notyoma Enore ana, exahe hikakoa hoka maisaiya atyo xoare maheta hityani haohitita natyo”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","— Xakore hoka enexe wakatya hawakaneharenai: “Xihalahare! Xisohena imiti waiyexe kakoa hoka xaisoakihetene. Kahititini xamoheta ihiye, kijititini harenai. ");
INSERT INTO pabNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Exahe xiyane xaisehena bowi mokose kolotere hoka wimaxalohare. ");
INSERT INTO pabNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Xiyaiya, exe nityani atyo waini ene hoka kalikini atyo kaseheta. Meta xakore hoka kakaokakeheta”, nexa enexe. Hatyaoseta aokitere akereta tyomaha hoka maxalohareha. ");
INSERT INTO pabNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","— Hatyo xowaka ityani inityohaliti xaneta mase. Hoka kaokehetehena, owitehetehena mohitita hati hoka sema xerati, xoholikoati nemahare. ");
INSERT INTO pabNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hoka kawisa hatya wakahare hoka axene: “Xoana hoka nikare tyaonaha?” nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hoka wakahare nexa ihiye: “Hiximarene kinaseta, exahe kinatereta kaokeheta. Hatyo hiyeta hexe bowi mokose kolotere xaisaka aoka”, nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","— Hatyaoseta ityani inityohaliti ehare, maisa isoaheta aokowita hatyako. Hoka enexe hikoa menanaka hoka tihityoa ihiye isoaheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Xakore hoka nexa hanexe hiye: “Hiyaiya, waha terehokoanehena wakahare akereta nahakita homana, exahe maisa namasemakiyatyare hiraine. Xakore hoka maisa hali hekoti kabala hisare nomani hoka nomaxaloharexe nohinaeharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hoka exe hityani hixiyeharenai tyotya miyahenere enatyalolonai hiye kalikini haikoaheta hoka bowi mokose kolotere xaisaka haoka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","— Hatyaoseta enexe nexa ihiye: “Haré, nohaliyi atyo hisaota minita hoka tyotya noxiyeharenai atyo homanere tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hoka exe hisehaliti terota notyoma naokowi, wihalaharene wahotikisa maheta. Hiyaiya, exe hiximarene atyo waini ene hoka kaseheta, meta hoka kakaokakeheta”, nexa haisani hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus nexa haxaotyakiraharenai hiye: — Hatya haliti kaoloxere tyaonita hoka hatya kaxaikotene enomana. Hoka haiyanai xakaiha ihiye, ekaxaikoharetyasehare ametakijita enoloxa aokaha. ");
INSERT INTO pabNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hatyo hiyeta kawisene hoka nexa ihiye: “Xoana, aliterexe exakerexe hisaonita aokaha nohiye? Hahotikihena nomani hikaxaiko akahenere xowakiyere. Hiyaiya, maisaiya atyo nokaxaikoharetyase hisaohitita”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","— Hatyaoseta ewakanehare ahekotya: “Noxekohase axikahetehena natyo. Hoka xoare ite notyomehena? Maisaiya atyo nokinatere nasekehitita waikohe, exahe nohaihareta atyo olo noxaxani kakoa”. ");
INSERT INTO pabNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hatyohekota nexa, “Exakerite notyaona. Nikarite notyaona hoka nokaxaxikatyakehetehenere najikinita nokahinaeharexe notyaona hoka waiye mokaha natyo hahanakonaeha nali”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","— Hatyaoseta kawisa tyotya kakotaneterenai exekohase hoka hetatiyehare hiye nexa: “Xoanere hikakotaneta noxekohase?” nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nokakotanitene 100-litrone kolotenitiya”, nexa ihiye. “Owene hikotane. Hisokehena exaose hoka haxairatya 50-litrone”, nexa hatyo kaxaikoakatyatiye. ");
INSERT INTO pabNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","— Háhare hiye nehitiya: “Hiso atyo, xoanere hikakotaneta?” nexa. “Nokakotanita 1.000 kilone trigohe”, nexa. “Hisokehena hoka haxairatya exaose 800-kilone”, nexa ihiye kaxaikoakatyatiye. ");
INSERT INTO pabNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","— Hatyaoseta exekohase tyakeko hatyo kaxaikoakatyatiye mahakaiserexe iniriharene hiyeta. Hoka Jesus nehitiya: — Halitinai exe waikohekoa tyaoniterenai atyo masakare irihareha xoalinihare háomaneha kakoa, halitinai Enore xaokanala xema tyaoniterenai xahe nirihareneha atyo. ");
INSERT INTO pabNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Hatyo hiyeta nomita xihiye: maika xakahinaeharetyoahena exe waikohekoa tyaoniterenai kaoloxerenai kakoa hoka ximaoloxaharehena hoka kahinaetyaha xiso, wenati matyotenehare nali xiyanehenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","— Xala xamaniya atyo enaosexeta tyomita xoalinihare inirere hoka enaosexeta tehitiya atyoite tyoma xoalinihare kalorexe, exahe xala xamaniya atyo maisa waiyexe xoalinihare inirere háomane hiye hoka maisa tehitiya atyoite waiyexe xoalinihare kalorexe háomane hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Xiyaiya, xikaiwitaiya exe halitinai waikohekoa tyaoniterenai noloxa hoka xalaiya isehena xomana xiyehaliti aliterexe? ");
INSERT INTO pabNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Exahe xikaiwitaiya haiyaharenai xiyehare hoka xalaiya isehena xomana xixiyehare kaiserehare? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","— Maisaiya atyo xala hare hinamahare xekohaseti wakanehare tyaonita haxowakita. Nikareya hoka hatya awaiyetita, hatya maisa awaiyetyare xoahaiya. Tyakekota hatya, hatya maisa tyakekore xoahaiya. Nikare tehitiyaiya maisa aliyakere Enore maniya hahekoita, olo xiyehaliti harenai maniya hahekoita xoaha haxowakita. ");
INSERT INTO pabNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hoka fariseunai sema hatyoharenai hoka Jesus koexahalisaha, olo xiyehaliti harenai awaiyetyahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hoka Jesus nexa: — Xiso atyo motya waiyexeharexenai ene xisaonita halitinai nahalakoa hoka Enore atyo waiyita xiyahekolanai. Hiyaiya, halitinai ana masakare waiyeterehare atyo Enore ana maisa waiyexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","— Moisés Xaotyakiraho, iraiti xakaisaseharenai xaotyakira xoaha xema halitinai tyaona João Batista kaotyakehenere kijiya. Hatyo najikinita Iraiti Waiyexe Xekohaseti enokoatare tyoanene Enore nalitare tahi kaxakaisaka hoka halitinai aiyateretyoahitaha exema maniya tyaonaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","— Maisaiya atyo hase xairatise hatyatare iraiti Xaotyakiyaho hiyetare mitita. Enokoa, waikohekoa harenai maiyareheta hotohariya. ");
INSERT INTO pabNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","— Hatya halitiya haiyanityo halakiheta hoka hatya ohiro kakoa tyaoheta hoka iniyalahare atyo tyoma. Exahe xala xamaniya ohiro ehalakisakahalo kakoa tyaoheta hoka iniyalahare atyo tyomita tehitiya — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus nehitiya ihiyeha: — Hatya haliti kaoloxere tyaonita hoka imiti karore ako taita ijoita, exahe fera hisehaliti tyomita. ");
INSERT INTO pabNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nali tehitiya hatya haliti maoloxahare tyaonita, exahe kahonotirahiye, Lázaro nexarexe. Kahalakisakita minitaha kaoloxere hana haliya. ");
INSERT INTO pabNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Hoka Lázaro atyahita kanakaira maheta nakairati holoxo exoiterehare kaoloxere mexanekoata. Kajolonai kakoita tyoa takaxosetita ehonotiraosenai. ");
INSERT INTO pabNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","— Hatyaoseta hatyo maoloxahare waini hoka anjonai kolatene Abraão tyaonitere nali, wenati waiyexe nali. Hatyaoseta hatyo kaoloxere tehitiya waini hoka kaxafityaka. ");
INSERT INTO pabNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hoka kirakoane tyaonita kamatinai tyaonitere nali. — Hatyaoseta waiyakahena ene hoka Abraão waiya seko akiya, exahe Lázaro Abraão haliya. ");
INSERT INTO pabNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hoka kawiyatya: “Abá Abraão, hairakoaneharehena natyo! Haxikahena Lázaro hoka hakahehi aolowatya one xaiya hoka tyoa noninise awehetya. Hiyaiya, kirakoane notyaonita exe irikati koni!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hoka Abraão nexa ihiye: “Xoana hotita hikasetare xowaka tyotya xoalinihare waiyexe tyaonitere homana? Hoka Lázaro atyo iniyalahare taita kaxomokaka. Hoka kalikini atyo ali waiye tyaonita, hiso kirakoane hisaonitere nase. ");
INSERT INTO pabNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Exahe toloko kalorexe winenekesene tyaonita. Hatyo hiyeta alita xinali tyoa aokowiterenaiya maisa aliyakere tyoahitaha, exahe hatyo nalitarenai tehitiyaiya maisa aliyakere ali tyoahitaha”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—“Hatyo hiyeta maika Lázaro haxikaheta baba hana xeta naoka, abá Abraão. ");
INSERT INTO pabNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Hiyaiya, nali 5-harenai nokaximaliniye. Hahalakisene hoka xaneheta hoka xakai ihiyeha. Nikarite hoka maisa tyoahitaha exe kirakoane kawenatyakitere xeta”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Xakore hoka Abraão nehitiya: “Moisés, iraiti xakaisaseharenai xoaha baberane kakoare hiximarenenai tyaonita. Maika semaxemahenaha hatyonai xairala”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—“Maisaiya atyo nikare hoka xoare tyomita, abá Abraão!” nexa kaoloxere ene. “Alitareya atyo hatya kaseheta hoka xane irai ekakoaha hoka halakisahaiya atyo háomaneha iniyalahare”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Hoka Abraão nexa ihiye: “Maisaiya semaxematyahitaha Moisés, iraiti xakaisaseharenai niraene hoka maisaiya tyakekoahitaha, exahe alitare kaseheta hoka xane irae ekakoaha”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Hatyaoseta Jesus nexa haxaotyakiraharenai hiye: — Exakerexe ite kawenatyaketa mene: Haiyanaite iniyalahare aomanekisa hahinaeharenae xakore atyoite hoka kirakoane atyoite kaxomokaka nikare axomokanikiyakahenere. ");
INSERT INTO pabNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ehekoreya atyo kaxawatyaka one kaloxere xaiya sehali kaloliro mehetyakalati kaxolatyaka ihino hiye hoka maisa ahowitikisa exe xoimairanai nawenane. ");
INSERT INTO pabNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","— Maika xirihare! Maika hihinaehare iniyalahare tyomehena hoka hiwatyalini. Hoka háomane iniyalahare halakisa hoka himaotyanehetene. ");
INSERT INTO pabNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maika exahe 7-ki iniyalahare moka hiso haferakoaneta hoka hatyokinai nihatyaka tyoa hoka nehena: “Himaotyanihetene naoka”, nehena hoka himaotyanehetene. ");
INSERT INTO pabNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hatyaoseta iniraine kakoarenai axaha Jesus: — Xekohaseti, haeroretya wityakekone — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hoka Jesus nexa ihiyeha: — Ikoiya xityakekone mostardase akerehare hekoti hoka xexaiya exe halohalo kate hiye: “Hamalakoawihena hityahare kakoita hoka hiyane onexaiya hisaohena!” xexaiya ihiye hoka tyakekoiya xiraene hoka xaokitere akereya tyaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesus nexa: — Maika xiyahekola hiye hoka motya xikawakaneharexe ene xisaonita hoka xane hakita masenekoa xamani, xoana kaxaikota xamani kalaneronai. Hoka kaokehetehenaiya maseta hoka xoana hexaiya: “Hisohena rotita, hisokehena mexa haliya”? hexaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mahaiya atyo nikare hiraeta! Xakore hoka hexaiya: “Hisomehena nakairati nomani hoka hakanekoatya hoka hamohena nakairati hoka nokanakairi, notera. Hatyo najikinitaite hikanakaira, hisera”, hexaiya. ");
INSERT INTO pabNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Xoana wakahare kakoaiya hihalahare, hiwakane xema taita tyomita hoka? ");
INSERT INTO pabNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","— Maika nikarexeta xisaona. Maika xisoma xamemahenere tyotya xisoma kaxaokakehenereharenai najikinita xexa: “Wiso atyo wakaharenai maxoarewaikateharenai. Hiyaiya, wisomita atyo wikawakatyakitereharenai taita”, xexa — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hatyaoseta Jesus xaneta Jerusalém xeta hoka jiya Samaria, Galiléia xoaha koa nenekesene. ");
INSERT INTO pabNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Xane kaokehena hakoa wenakalati hoka 10-hare jijikoahitinai tyoa ahalakoatene. Sekota amematyoaha ");
INSERT INTO pabNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","hoka kawiyatyaha enomana: — Xaotyakisatiye Jesus! Hairakoaneharehena wiso! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus waiyahene hoka nexa ihiyeha — Xiyanehetehena sacerdotenai nali hoka waiyahareheta xiso — nexa. Hatyaoseta xanahitataha ene ahoti hoka waiyeharehenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hatyaoseta hatya enekonitareha Samaria yere, kehexa haiyatereheta hoka haikoaheta aexakeritya maheta Enore. ");
INSERT INTO pabNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hatyaoseta Jesus kiji haliya meholokoa hoka ihalahare ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Hatyaoseta Jesus nexa: — Halitinai kaxaiyatelikisakehetehenerenai atyo 10-harenai. Hoka aliyo 9-harenai? ");
INSERT INTO pabNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Xoana hoka exe hahotyalihare taita haikoaheta aexakeritya maheta Enore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hatyaoseta Jesus nexa ihiye: — Hatityoahetehena hoka hiyaneheta. Hikinatereheta atyo hityakekone hiyeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hatyaoseta haiyaharenai fariseunai axaha Jesus, xoana xowakiya xamaniya kaotyakehena Xekohaseti Enore nalitare tahi akiti. Hoka nexa ihiyeha: — Hatyo Xekohaseti tyoanene Enore nalitare atyo maisa kawaiyakere xini. ");
INSERT INTO pabNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Maisaiya atyo xala harenai nita: “Xiyaiyehena, owene tyaonita”, exahe, “Exe nali tyaonita”, nita. Hiyaiya, Xekohaseti Enore nalitare atyo tyaonita xinekoni — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hatyaoseta nexa haxaotyakiraharenai hiye: — Haxowakaite kasanite xiyaiya xaokowi Haliti Ityani, xakore hoka maisaiya atyo xiyaiyitene. ");
INSERT INTO pabNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Hoka haiyaharenaite nehena xihiye: “Witya ali xiyaiya”, exahe “Nali xiyane xiyaiya”, nexahaite. Xakore hoka awa atyo xiyane xatawene. ");
INSERT INTO pabNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hiyaiya, kahihiye hoka enokoa nali hamaniyata xane hamaniya werokakoa mokita. Nikareta atyoite tyaona Haliti Ityani tyoaneneheta xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Xakore hoka ite kaxemakawatikisaka hotohare, exahe maisa ite kalikiniyerenai aokahitene haomanaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","— Noé xowakiya tyaonahitere akereta atyoite Haliti Ityani tyoaneneheta xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Hatyo xowakiya tyotyaha kanakairahitaha, terahitaha, tyaonakakoahitaha harenai, Noé isoahenere kanowa kalorexe ako kijiya. Hatyaoseta one more exahitaha hoka tyotya aisahene. Nikare ite tyaona Haliti Ityani kaokehetehenere xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","— Nikareta tehitiya tyaona Ló xowakiya. Tyotyaha kanakairahitaha, terahitaha, iyahitaha, betetyahitaha, fityahitaha, hati tyomahitaha xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hoka Ló kikisoahetehenere Sodoma nalita ferakeneta enokoata exoa irikati enxofre xoaha hoka aisahene tyotya. ");
INSERT INTO pabNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","— Nikare ite tyaona Haliti Ityani kaokehetehenere xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Hoka maika xala xamani hatiri tyaonita hoka exoaheta hoka tekoahena rotita, awa atyo ahowitiharetyoa xane haxiyeharenai iyehetehena. Exahe xala xamani mase xaneta hoka awa atyo haikoahetehena hahana xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xotyaxematyaira Ló exanityo tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xala xamani atyoite wenati waiyexe tawita hoka meta atyoite enonita. Hoka xala xamani atyoite nokoamaniye tyaonita hoka nohiyiti waini hoka hatyo atyoite kaoka wenati waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","— Hatyo xatinite hinamanaite nemakita haxawalita kamakoa hoka hatitaiya kakolatyaka hoka hatyaite enaoseta kahalakisaka. ");
INSERT INTO pabNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hinamahalo ohiroite haxawalita mehititaha trigohe, hoka hahaloite kakolatyaka hoka hahaloite enaoseta kahalakisaka. ");
INSERT INTO pabNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nikare tehitiyaite hinamahare haliti ite hakita masenekoa hoka hahare ite kakolatyaka hoka hahare ite kahalakisaka enaoseta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hatyaoseta exaotyakiraharenai axene: — Xekohaseti, alyako xeta kakolatyakahitaha? nexaha. — Aliyako xamani atyoite kamati tyaonita hoka nalite olohonai hohisakoahena — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus exakere aimenekohitiya, hotikisa enomanaha hoka iraexatyaha mene hoka maxamaikoharenehare tyaonaha maheta: ");
INSERT INTO pabNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Hatya wenakalati koa tyaonita hatya haliti watyalisatiye. Hoka maisa mairare Enore, exahe maisa xala hare aiminisare. ");
INSERT INTO pabNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hatyokoa tehitiya tyaonita ohiro wainiyanenero. Hatya iniyalahare mokitene hoka tyoa fera kaokita watyalisatiye ana hoka nita: “Hakahinaehena natyo nahalakoihare nonitata!” nita ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xakore hoka waha maisa kahinaetene aokowita. Xakore hoka wahehena hoka exakere ahekotya: “Aliterexe maisa Enore nomairare, exahe maisa xalahare naiminisare. ");
INSERT INTO pabNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Xakore hoka exe ohiro nomaxaharehena mokita hoka nakahinaetene ite. Maisaiya nakahinaetitene hoka ekakoitaiya emaxahalikisa kaiserehare natyo”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hatyaoseta Jesus nehitiya: — Hoka waiyira xasemehena exe watyalisatiye mahakaiserexe niraine. ");
INSERT INTO pabNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xoana Enore maisaiya kahinaetita hakoamaniya tyaoniterenai, kawijiterenai ferakoa, makiya harenai, hakahinaetyaka aohenaha hoka? Xoana howitihareya hakahinaerahene kakoa? ");
INSERT INTO pabNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Natyo atyo nomita xihiye: kahinaetyaite hatyo halitinai, haxerore ite hatyoharenai tyoma! Xakore hoka Haliti Ityani tyohetehenere xowakaite, xoana waikohekoa tyaoniterenai kaite tyakekohenene? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Haiyahare waiyexeharexenai aokowiha hoka haiyaharenai mawaiyexehareharexe aokaha hoka Jesus exakere aimenekotya enomanaha: ");
INSERT INTO pabNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Hinamahare halitinai xaneha Iraexatyakalati Hanako iraexatyaha maheta. Hatya Fariseu, hatya kalorexe noloxa resebityasehare xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseu tityoa hawawahare hoka exakere iraexahena: “Enore, nihalahare hikakoa. Hiyaiya, maisa atyo xiyehaliti xawaiyetyasehare xini natyo, maisa nokaiwarexe, exahe ohiro nowatyaliye haiyaharenai akereta. Nihalahare tehitiya hikakoa. Hiyaiya, maisa atyo exe kalorexe noloxa resebetyasehare akereta xini natyo. ");
INSERT INTO pabNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hasemanane nihatyaka atyo hinamaki ferakene nomanakairita notyaxematya hiso maheta, exahe nokainotyoani hiyeta atyo holini nijita homana”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","— Hoka olo resebityasehare atyo sekota iraexahena, maisa kenekakoatyare hekoti eno xeta, hatikolalikoa mokotya (haxamaikoharene hiyeta) hoka nehena: “Enore, hairakoaneharehena natyo. Hiyaiya, iniyalahare nomasehare atyo natyo”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","— Hoka natyo nomita xihiye: hatyo haliti atyo, maisa atyo etake hahare xini, xaneheta hahana xeta hamehexaikoharene Enore kakoa. Hiyaiya, xala xamani atyoite kalorexe aokowita hoka wakahare atyoite kaxomokaka, hoka xala xamani atyoite maisa haiyanae xahehare aokowita hoka kalorexe atyoite kaxomokaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hatyo najikinita haiyaharenai kolatyaha xoimamokosenai Jesus ana, ekaokakisa hakahe ihiyeha hoka wenati waiyexe aoka enomanaha maheta. Xakore hoka exaotyakiraharenai waiyahene hoka mahokoanetyahene. ");
INSERT INTO pabNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hoka Jesus kawisa xoimanai hahaliya hoka nexa: — Kotare xoimanai tyoa nomani, awa atyo xamahokoanetyahene. Hiyaiya, Enore waikoherakoa atyo exe xoimanai akereharenai anere. ");
INSERT INTO pabNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aliterexe nomita xihiye: xala xamani atyoite maisa exe xoimanai akereta Enore niraene tyakekota hoka maisaiya aliyakere tyaonahitaha exema — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hatya xekohaseti judeu axa Jesus: — Waiyexe Xaotyakisatiye, xoareya notyoma hoka kaxekaka nomani wenati waiyexe matyotenehare? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Hoka Jesus nexa ihiye: — Xoana hoka waiyexe haoka natyo? Enore taita atyo waiyexe, maisa atyo hatehitiya aka. ");
INSERT INTO pabNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Maisa hoka koxaka hasemita Xaotyakiyahonai: “Awa atyo iniyalahare hisoma ohiro kakoa, awa atyo haisa, awa atyo hikaiwa, awa atyo hamaoseratya, haiminisa hexe, hityo xoaha”, nitere — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","— Noxoiminita atyo tyotya hatyo xaotyakiyahonai xema notyaonita — nexa hatyo haliti. ");
INSERT INTO pabNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesus sema nikare iniraine hoka nexa: — Hátitehena himaomanehare. Habetehena tyotya hixiyeharenai hoka hisehena olo maxiyehareharenai ana. Nikare ite hisaona hoka hikaxiyeharexe ite hisaona enokoa nali. Hatyaosetaite hisoheta hoka hisoa noximi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hatyohare sema hatyo haliti hoka kalore amaikohare, kahare kaxiyeharexe hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus waiya examaikoharene hoka nexa: — Howitihare atyo kaxiyeharexenai nawenane Enore koa maniya. ");
INSERT INTO pabNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Howitihare atyo kaxiyeharexenai nawenane Enore koa maniya, kamelo howitihare kaxajiyakisakitere awiyahi nakoako xahehare howitini atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hoka iniraene semehenerenai axene: — Hoka xala ite nikare hoka kaiyakehetehena? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","— Halitinai ana howitihareterehare atyo Enore ana maisa howitiharexe — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hatyaoseta Pedro nexa: — Hasemahena, wiso atyo wahalakisa tyotya hoka wisoa hiyema — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","— Aliterexe nomita xihiye: Xala xamani atyo ite halakisa hahana, haiyanityo, haximarenenai, hahinaeharenai, haisaninai harenai, Enore xema maniya hawenane hiyeta hoka ");
INSERT INTO pabNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kalikini ali tyaonitatere xowakaite exahehare kaxekakeheta enomana. Hoka haxowakiyaite wenati waiyexe matyotenehare kaxekakihitiya enomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hatyaoseta Jesus xane haware haxaotyakiraharenai kakoa hoka nehena ihiyeha: — Xasemahena, wiyanetatya Jerusalém xeta. Nalityaite iraiti xakaisaseharenai xairahenahere Haliti Ityani tahi akereta kawenatyakehena. ");
INSERT INTO pabNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kahalakisakaite majudeuneharenai ana hoka hatyonaite koexahalisene, kirawanahenite, xataholisahenite, ");
INSERT INTO pabNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","mokotyahenite hoka hatyo najikinitaite aisahene. Xakore hoka hanamaki ferakene najikinitaite kaseheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Exaotyakiraharenai ana maisa terota waiyekehalakita Jesus niraene. Exe iraehenere tahi metahare tyaona enomanaha hoka maisa Jesus iraitere waiyekehalakita enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hatyaoseta Jesus okoi xane kaokehena wenakalati Jericó nali. Hoka hatya haliti maxosehare tyokita ahoti kilihi, axita olo. ");
INSERT INTO pabNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hoka sema kahare halitinai jiyehenerenai kasako hoka axahene: — Xoare nemahare nasemita? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hoka nexaha ihiye: — Jesus Nazaré yere jiyehena — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hatyaoseta maxosehare kawiyahena: — Jesus, Davi jikolahare, hairakoaneharehena natyo! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hoka enaheta xaneterenai mahokoanetyaha ekawira, kasani mema tyaona aokahitaha. Xakore hoka exahehare kinatyaxa kawiyatya: — Davi jikolahare, hairakoaneharehena natyo! nehitiya. ");
INSERT INTO pabNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hatyaoseta Jesus tityoa hoka enolokaka aoka. Tyoa kaoka ehaliya hoka Jesus axene: ");
INSERT INTO pabNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— Xoare notyoma homana haokita? nexa. — Xekohaseti, nowaiyakatyareheta naokowita! nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hoka Jesus nexa ihiye: — Hiyaiyakahetehena. Kalikini atyo hawaiyeheta hityakekone hiyeta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hatyaoseta waiyakatyarehetehena rotita hoka xane Jesus xema, ihalahare Enore kakoa. Tyotya halitinai waiyaha hatyoharenai hoka ihalahareha Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hatyaoseta Jesus xane kaoka Jericó hoka jiyehena wenakalati. ");
INSERT INTO pabNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hoka nali hatya haliti kaoloxere tyaonita, Zaqueu nexarexe. Kalorexe noloxa resebetyaseharenai xekohase tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hoka kasani waiya aokowita Jesus xakore hoka maisa aliyakere. Kahare halitinai, exahe maisa wahaharexe xoaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hatyaoseta tema xane halitinai naheta hoka kakoha halohalo howero kate, waiya maheta Jesus, hatyoaho ijiyanehena hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hoka Jesus hatyo akitihena hoka kenekakoatya waiya hoka nexa Zaqueu hiye: — Zaqueu, hihalahare hexoahetehena. Awisa hihanako nali notyoa notemaka naokowi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hatyaoseta Zaqueu ihalahare exoaheta, xane ekakoa hahanako xeta haihalaharene kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tyotya waiyahene hoka iraehenaha etahi: — Kaxiyani, exe halitite xane nemahena iniyalahare nomasehare hanako! nexaha amaikohareha Jesus kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hatyo najikinita Zaqueu tityoa hoka nexa Xekohaseti hiye: — Hasemehena, holinite noloxi hiyeta nisa maoloxaharenai ana. Exahe xala xamanite koxaka nokaiwita hoka 4-kite exahexe niseheta enomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hoka Jesus nexa: — Kalikini atyo exe haliti kaiyakeheta iniyalahare maniyata, exahe exe haliti tehitiya atyo Abraão jikolahare. ");
INSERT INTO pabNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hiyaiya, Haliti Ityani atyo tyoa taweheta, iyeheta maheta mititereharenae — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hatyaoseta Jesus xakaihitiya ihiyeha haxaimenekola kakoa iniraene semehenerenai ana. Jerusalém owitehena mokahita hoka exahekolaha hiye hoka motyala okoi Xekohaseti Enore nalitare kalorexe kaotyakehena aokahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hatyo hiyeta Jesus nexa: — Hatya haliti kalorexe ityani konitare xane hakoa wenakalati seko akiya, kalorexe tyaona hoka hatyo najikinita haikoaheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Haxanene nahitita kawisa 10-harenai hawakaneharenai hoka isa enomanaha inihatyakahokoseha olohokosenai ouro nomaka, hoka nehena ihiyeha: “Xasemehena, xoare xamanite xisoma exe olo kakoa, exahe xoanere xamanite xakajiyanetene nahaikoahetehenere kijiya”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","— Hoka ihinaeharenai enawenakala yerenai kirawanetene. Hatyo hiyeta axikatya haiyaharenai enajikinita, nexa ihiye maheta: “Kasani exe haliti maisa wiyekohase tyaona waokare”, nexaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","— Hatyaoseta hatyo haliti kalorexe tyaona hoka haikoaheta hawenakala xeta. Hoka hawakaneharenai kawisa, etake olo isehenere enomanaha akiti sema aokowita, xoanere xamani ala kajiyanetyahene hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","— Hetatiyehare kaoka hoka nexa ihiye: “Xekohaseti, etake olo hokose ouro nomaka hisehenere nomani kakoa 10-hokose olo nakajiyanetene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Waiye kaiserehare!” nexa. “Hiso atyo wakahare waiyexe! Hiyaiya, hawaiyore atyo hikaxaikota inirere. Hatyo hiyetaite 10-koa wenakalatinai xekohasehare namoka hiso”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","— Hatyaoseta hatisa wakahare kaoka enomana hoka nexa ihiye: “Xekohaseti, etake olo hokose ouro nomakere hisehenere nomani kakoa 5-hokose olo nakajiyanetene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Hiso atyoite 5-koa wenakalatinai xekohasehare hisaona”, nexa exekohase ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","— Hatyaoseta hatya wakahare kaokehitiya enomana hoka nexa: “Xekohaseti, owene holoxa hokose. Nityahalisene imiti taose kakoa hoka nateroakisene. ");
INSERT INTO pabNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nomaira hiso. Exahe waiyekehalakita atyo nomani hiyalijiniharene, exahe hiyitatere haiyanai xiyehare, maisa xakore hixiyehare xini hoka. Exahe himixitatere, maisa xakore hiyafera xini hoka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Hoka nexa ihiye: “Hiso atyo wakahare maisa waiyexe! Hiraene kakoitaite iniyalahare namoka hiso. Waiyekehalakita atyo homana noxalijinihalini, exahe niyitere haiyanai xiyehare, maisa xakore noxiyehare xini hoka. Exahe nimixiterehare nomaxafirinihare. ");
INSERT INTO pabNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Xoana hoka maisa noloxi olo xomokakala hanako hekoti hamokita? Nikareya hamokarene hoka noxanini hekotaiya, nahaikoaheta hoka kajiyanexeya naresebehetene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","— Hoka nexa nali tyaoniterenai hiye: “Xiyeheta olohokose enonita hoka xisene 10-hokose olo kakoare ana”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Xekohaseti, koxaka atyo 10-hokose olo kakoare!” nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","— Hoka xekohaseti nexa: “Aliterexe nomita xihiye: xala xamani atyoite kalore kakoare hoka exaheharexe ite kaxekakihitiya enomana. Xakore hoka xala xamani atyoite maisa xoare kakoare hoka exahe inirere kakoare ene hoka iyehenahitene atyoite enonita. ");
INSERT INTO pabNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hoka kalikini xanolohena ali nahalakoiharenai, kasani emaxekohasehareneha notyaona aokiterenai hoka xaisehenahene nahalakoita!” nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hatyo iraehenere najikinita Jesus xanehitiya enahetaha Jerusalém xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hatyaoseta xane kaokehena wenakalatinai Betfagé, Betânia xoaha haliya, hoka Oliveiras tyairiya nalita axikatya hinamahare haxaotyakirahare haheta maniya, ");
INSERT INTO pabNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","hoka nexa ihiyeha: — Xiyanehena exe wenakalati waheta maniya tyaonitere nali. Xikaokehenaite hoka owene ite borikose exolatyakahare tyaonita, maokatyakaharetata eheno. Hoka maika xamaxolatene hoka xisoa ekakoa ali. ");
INSERT INTO pabNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Maika xala xamani axehena xiso, exahe xoare maheta xamani xaolihenene hoka xexa ihiye, “Xaotyakisatiye aokitene haomana”, xexa ihiye — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xaneha hoka Jesus iraetere akereta taita waiyaha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Aolihenaha borikose hoka ekaxaikotyaseharenai axahene: — Xoana hoka borikose xaolihena? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","— Xaotyakisatiye aokitene haomana hoka — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hatyaoseta nolokaha borikose Jesus ana. Hoka mokaha eheno haimanasenaiha hoka kahinaetyaha Jesus tyoka eheno maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hatyoseta Jesus jiyehena hoka halitinai haimanasenaiha mokahitaha ahotyaho. ");
INSERT INTO pabNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hatyaoseta kaokehena Jerusalém haliya, Oliveiras tyairiya xexoakala nalihena hoka kahare halitinai ekoamaniya tyaoniterenai xanetaha exema. Awaiyetiterenenai ihalaharehenaha Enore kakoa hoka kinatyaxa kawiyahenaha, tyotya xoalini hare enómane waiyehenaherehare hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hoka nexahitaha: — Kasani Xekohaseti Enore waiye moka kalorexe enexare kakoa tyoiterehare waokita! Wenati waiyexe enokoa nali, exahe Enore kakoa kaihalaharetyaka waokita! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hatyaoseta haiyaharenai fariseunai tyaoniterenai kaharexe halitinai koni nexaha Jesus hiye: — Xaotyakisatiye, hiwatyalihena hikoamaniya tyaoniterenai hoka mema tyaonaha! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","— Aliterexe nomita xihiye — nexa Jesus: — Memaiya tyaohenahitaha hoka sehalinaiya kawiyatya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hoka Jesus xane kaokehena Jerusalém haliya hoka waiya wenakalati hoka tiya ekawa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hoka nexa: — Kaxiyani, Jerusalém! Kalikinitaiya atyo waiyekehalaka homana, xoare xamaniya hisoma hoka wenati waiyexe koamaniya hawenaneheta hoka ehekoreya! Xakore hoka kalikiniya atyo maisa hatyoharenai waiyekehalakita homana. ");
INSERT INTO pabNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hiyaiya, haxowaka ferakenehenaite hoka hahalakoaharenaite talahokotya hiso tolokoiyohi kakoa, exahiyatyahaite hiso, exahe ehotyasekoatyahaite hiso tyotya maniyata. ");
INSERT INTO pabNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","— Mawenekoaretyahaite hiso, tyotya hikoa tyaoniterenai xoaha. Maisaite sehali hali heno tyaohitita. Hiyaiya, maisa atyo waiyekehalakita homana Enore tyoa iyeheta hiso aokowihenere xowakere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hatyaoseta Jesus xane isoa Iraexatyakalati Hanako hoka aehikoaheta betetiterenai. ");
INSERT INTO pabNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nexa ihiyeha: — Iraiti Waiyexe kaxairatyakehenere nali exakere xairatyoare tyaonita Enore niraene: Nohani atyoite Iraexatyakalati Hana kakaexaretyaka, nexa. Xakore hoka xiso atyo kaiwarexenai xateroakisakala niyahare xamokene — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesus aotyakijita halitinai ferakiti nihatyaka Iraexatyakalati Hanako. Hatyaoseta sacerdotenai xekohasenai, Xaotyakiyaho kakoa waiyoreterenai, judeunai nityohalitiranae xoaha aisahene aokowihenaha. ");
INSERT INTO pabNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Xakore hoka maisa aliyakere nikare mokarahene, tyotya halitinai awaiyetyahitaha exaotyakira hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Haxowaka Jesus Iraexatyakalati Hanako tyaonita hoka aotyakijita halitinai, exahe xakaita ihiyeha Iraiti Waiyexe tahi. Hoka sacerdotenai xekohasenai, Xaotyakiyaho kakoa waiyoreterenai, judeunae nityohalitiranai xoaha kaokaha enomana ");
INSERT INTO pabNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","hoka axehenahene: — Hiyakaihena wihiye, xala niraene kakoare hiso hoka exeharenai hisomita? Xala axikatya hiso hoka nikare hisaonita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Hoka Jesus nexa ihiyeha: — Natyo tehitiyaite naxa xiso. Hoka xekoaxahena: ");
INSERT INTO pabNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Xala niraine xema João batixatya haliti? Xoana Enore niraene xema, xoana halitinai niraene xema kore? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hatyaoseta hekota hatyo kakoaha axakakoahenaha: — Xoare wehenaite? “Enore niraene xema”, wexaiya hoka nexaiya axa wiso: “Xoana hoka maisa xityakekota João?” ");
INSERT INTO pabNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Exahiya, “Halitinai niraene xema”, wexa hoka exe halitinaiya mokotyaha wiso sehali kakoa. Hiyaiya, João atyo iraiti xakaisasehare terota aokahitaha — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hatyo hiyeta nexaha: — Maisa wawaiyorexe. Kala xala niraene xema xamani João batixatya — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","— Hoka natyo tehitiya atyoite maisa noxakaita xala niraene xema exeharenai notyomita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hatyaoseta Jesus exakere aimenekotya halitinai ana: — Hatya haliti fitya uva katenai hamasenekoa hoka halakisene haiyanai halitinai ana kaxaikone maheta hoka xonehena hoka irakakakoahenahitene maheta. Hatyaoseta xane seko akiya hoka waha tyaona. ");
INSERT INTO pabNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Iximexaka xowakehena hoka axikatya hatya hawakanehare, isehenahitaha maheta enomana holini. Xakore hoka masene kaxaikotyaseharenai mokonasetene hoka axikahenahitene eháre firereta. ");
INSERT INTO pabNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hatyaoseta axikahitiya hatya hawakanehare, xakore hoka mokonasehenahitiyene. Haihare xakere mokahene hoka axikahenahitene eháre firereta. ");
INSERT INTO pabNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hatyaoseta axikahitiya hatisa hawakanehare, xakore hoka masene kaxaikotyaseharenai mokotyahene tehitiya hoka axikahenahitene. ");
INSERT INTO pabNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","— Hatyaoseta masene xekohasehare ahekotya: “Xoanaite notyaohena? Naxikatyaite nityani noxiyakawali. Hatyo atyoite hoka aiminisahene”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Xakore hoka masene kaxaikotyaseharenai waiyaha ityani hoka nexaha: “Exe atyo masene xekohasehare ityani. Nikahena hoka waisene hoka masene ite womanere tyaona”, nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hatyaoseta otokaha ityani hoka xaneha haware ekakoa masene nonitata hoka aisahene. Hatyaoseta Jesus axahene: — Xoanaite masene xekohasehare mohena hatyo masene kaxaikotyaseharenai xaoka? ");
INSERT INTO pabNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tyoaite hoka aisehena hatyo halitinai, exahe isehitiyaite hahananehare hahotyalinai masene kaxaikotyaseharenai ana — nexa. Semaha hatyoharenai hoka nexaha: — Kasani maisa nikare kawenatyaka waokare! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Xakore hoka Jesus waiye wahakotya enomanaha hoka nexa: — Iraiti waiyexe kaxairatyakehenere atyo nexa: “hali hati nomaseharenai maxaokarehenere atyo hati nekesako kaxomokaka”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Xala xamaniya atyo exoa hatyo sehali heno hoka taikoehekoa atyoite. Hoka hatyo sehaliya atyo hatya heno exoa hoka miyoheteniya atyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hatyaoseta Xaotyakiyaho kakoa waiyoreterenai, sacerdotenai xekohaseharenai xoaha ana waiyekehalakita. Jesus xaimenekola atyo etahiha iraeta, hoka otokahene aokowi hatyo xowaka. Xakore hoka mairahitaha halitinai hoka maisa xoana mokahitene. ");
INSERT INTO pabNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hatyaoseta kaxaikohenaha Jesus. Bakatyaha haiyaharenai halitinai hoka axikatyahene axaha maheta Jesus. Hoka waiyexeharexenai aokowiha hoka Jesus nawenane waiyaha hoka kasani hairaine kakoita komaniyatyoa aokahitaha hoka iraeharetyahene maheta. Nikare tyaona hoka hatyohare hiyeta otokahene hoka isahene aokowiyahitaha kalorexe ana. ");
INSERT INTO pabNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hoka hatyo halitinai axahene: — Xaotyakisatiye, waiyekehalakita atyo womana. Hiraeterehare, haotyakijiterehare atyo aliterexe. Waiyekehalakita tehitiya womana. Hakakoa atyo hiyaiyita halitinai, hoka aliterexe kakoa haotyakijita halitinai Enore aokitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hoka hiyakaihena wihiye: Xoana wiyaotyakisakaho ala axakoanetita, xoana mahokoanetita kore ala wiyekane olo kalorexe Roma yere ana? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hoka Jesus otya iniyalahare exahekolaha hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Xama ali nomani hatya olo hokose. Hoka xala nexare exahe tiho niyakotini exe olo hokose hiye? nexa. — Kalorexe — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hoka Jesus nexa ihiyeha: — Xoare xamani atyo kalorexe Roma yere anere hoka kalorexe ana xisene. Xoare xamani Enore anere hoka Enore ana xisene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hoka maisa Jesus aliyakere xoare tahi kakoa iraeharetyahitaha halitinai nahalakoa. Hatyo hiyeta mema tyaonaha, hakaharetyoaha exekoaxala kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hatyaoseta haiyaharenai saduceunai tyoaha Jesus ana. Enomanaha haliti wainihena hoka maisa kasehetere. Tyoaha Jesus haliya hoka nexaha: ");
INSERT INTO pabNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","— Xaotyakisatiye, Moisés atyo exakerexe aotyakisa wiso: Hatya halitiya waini hoka haiyanityo maisanihalota halakisa hoka iximarene atyoite tyaoheta hatyo wainiyanenehenolo kakoa. Hoka kaisaniha hoka enaxenane wainihenere ene ityaninai kaxaokaka maheta aoka. ");
INSERT INTO pabNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","— Hoka 7-harenai haximarene kakoarenai tyaonahitaha hoka enahetahareha kaiyanityo hoka maisanihareta waini. ");
INSERT INTO pabNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hoka ihiyetare iximarene tyaoheta hatyo wainiyanenero kakoa, xakore hoka wainihitiya maisanihareta. ");
INSERT INTO pabNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nikare ihiyetare iximarene tyaohitiya ekakoa hoka wainihitiya. Nikare makere tyaonaha hatyo haximarene kakoarenai: tyotyaha wainiha maisaniharahitaha ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hatyo najikinita ohiro tehitiya waini. ");
INSERT INTO pabNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nikarite hoka xala exanityo kaisere ite hatyo ohiro tyaohetehena, kamatinai kasehetehenere xowakiya? Hiyaiya, tyotyaha atyo tyaonaha ekakoa — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hoka Jesus nexa ihiyeha: — Ali waikohekoa atyo halitinai kaiyanityota, exahe ohironai hoka kaiyanenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hoka kasehetehenerenai, exahe wenati haxowaka niyahare anerenai terota atyoite maisa tyaonakakoahenahititaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Hiyaiya, anjonai akeretaha atyoite, exahe maisaiya atyo wainihenahititaha. Enore ityaninai atyo, hiyaiya, kasehenahitaha atyo. ");
INSERT INTO pabNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","— Hiyaiya, waiyekehalaka atyo Moisés xakai kamatinai kaseneheta tahi. Hananehaliti kiritere tahi iraehenere xowaka. Enore tahi xairatya hoka Enore atyo Abraão, Isaque, Jacó xoaha Nenorexa aoka. ");
INSERT INTO pabNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hatyoharenai atyo hotikijita hoka Enore atyo kasexenai Nenorexa, maisa kamatinai Nenorexa xini. Hiyaiya, enomana atyo tyotyaha atyo kasetaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hatyaoseta haiyaharenai Xaotyakiyaho kakoa waiyoreterenai nexaha: — Ehekore hekoaxatya, Xaotyakisatiye — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hatyaoseta maisa kinatyatyako axehenahititene. ");
INSERT INTO pabNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hatyaoseta Jesus axahene: — Aliyakerexe hoka Enore Kalorexe Aohenere atyo Davi jikolahare aokahitaha? ");
INSERT INTO pabNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hiyaiya, hatyo Davi atyo exakere nexa, Salmos nanekoa nali: Nexa Xekohaseti Noxekohase hiye: “Hisokehena nofihini maniya ");
INSERT INTO pabNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hahalakoaharenai hikiji katyahe namohenere kijiya”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hiyaiya, Davi atyo Haxekohase aokene, hoka aliyakereya Enore Kalorexe Aohenere atyo Davi jikolahare xaohena? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Halitinai semaxematyahitaha Jesus niraine hoka nexa haxaotyakiraharenai hiye: ");
INSERT INTO pabNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Xiriharira Xaotyakiyaho kakoa waiyoreterenai kakoa. Hatyonai atyo awaiyetyahitaha haetonaneha imiti waiyeharexe ako, exahe wetekokoa hoka kasani halitinai haxaiminiraha kakoa katyawaxaha ihiyeha aokahitaha. Xanehenaha xahohisakoatyakalati hanako hoka waiyexe okahakalati koa tyokahitaha, exahe nakairati xowakehena hoka kasani okahakalati waiyexe koa tyokaha aokowihitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Exahe kaiwahitaha, mehotyahitaha wainiyaneneronai xiyehalo. Hoka teraharetyoaha aokowihenaha hoka waha tahi iraexatyahitaha. Hatyo hiyeta iniyalahare kaxomokakehenahere atyoite exahehare niyalahare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus tityoita Iraexatyakalati Hanako hoka wahakoita halitinai ana hoka waiya kaoloxerenai xomokala kajali olo nitini ako. ");
INSERT INTO pabNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Waiya tehitiya hatya wainiyanenero maoloxahalo xomokala hinama hokose olo, inira xaimanexe. ");
INSERT INTO pabNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hatyo hiyeta nexa: — Aliterexe nomita xihiye: exe wainiyanenero maoloxahalo atyo isa tyotya haiyaharenae xahexe. ");
INSERT INTO pabNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hiyaiya, haiyaharenai atyo isa kamawanetere hiyeta. Hoka exe atyo, maoloxahalo kaiserehare xakore hoka hanakaira haxiyehalo niyahare tyotya isa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Haiyaharenai iraetaha Iraexatyakalati Hana tahi, enawaiyehare ihiye tyaoniterenai sehalinai exahe xoalinihare kaxekakiterehare tahi. Hoka Jesus nexa: ");
INSERT INTO pabNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Haxowaka ferakenite tyotya exe xiyaiyitereharenai kamawenekoaretyakeheta. Hoka maisaiya hatya sehali hatya sehali heno tyaohitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hatyaoseta axahene: — Xaotyakisatiye, xoana xowakaite hatyoharenai kaotyakehena? Xoare hare hotohare ite kaotyakehena hoka hatyoharenai kaotyakene hotikihena? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","— Maika xirihare hoka maisa xala hare maoseraita xiso. Hiyaiya, kahare tyaite nexare kakoa kaotyakehenaha hoka nehenaha: “Natyo atyo Enore Kalorexe Aohenere”, exahe, “Koxaka atyo enaose xane hikoa”, nehenahatyaite. Xakore hoka awa atyo hatyoharenai niraene xema xisaona. ");
INSERT INTO pabNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","— Awa atyo ximairehena xasemehena xaisakakoati, xalijinihare tyaoniterenai tahi hoka. Hatyoharenai hotohare atyoite kaotyakehena. Xakore hoka maisa tyaite hatyo xowaka imiyanaose xane hikoahenere — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","— Hahotyalihare ite xane hahotyalihare kakoa aisakakoahena, exahe hakoatare ite xane hakoatare kakoa aisakakoahena. ");
INSERT INTO pabNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Haiyanai koaite kaotyaka waikohe tatakoane, exahe nakiti, kawe akiti kaheneharexe xoaha. Kahare ite xoalini hare amairakisare kaotyaka, exahe xoalini hare ite enokoa nali kawaiyaka. ");
INSERT INTO pabNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","— Xakore hoka tyotya hatyoharenai kaotyakehenere nahititaite xikaxotokaka, xikairaeharetyaka. Xikakolatyakaite axaha maheta xiso xahohisakoatyakalati hanako hoka hatyo najikinitaite berexoako xikaxomokaka. Nohiyetite xikakolatyaka kalorexenai, xekohasetinai nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nikare ite xikaxomokaka hoka hatyo xowakaite Iraiti Waiyexe xiyakaihena ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hoka xasemehena: maisaiya hatyo nahitita xahekohena xikahawaonitaretyoane xiraene tahi kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Hiyaiya, natyota atyoite nisa xomana iraiti, exahe waiyoliniti hoka xahalakoaharenaite maisa jiyahaotyahitaha xiso, exahe matyakekotyahitaha xiraene. ");
INSERT INTO pabNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Exahe xexenai, xiximarenenai, xihinaeharenai kaisereharenai taite aberexotyakisaha xiso. Hoka aisahaite haiyaharenai xinekonitare. ");
INSERT INTO pabNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tyotyahaite kirawaneha xiso nohiyiti. ");
INSERT INTO pabNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Xakore hoka maisaite hakase hekoti xisekase mitita. ");
INSERT INTO pabNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Maika heko xisaona nokoamaniye. Hiyaiya, nikare atyoite xisaona hoka xikaiyakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesus nehitiya: — Maika xiyaiyehena Jerusalém exahiyatyoare sorarenai kakoare hoka waiyekehalaka xomana: Mawaheneta atyoite hoka kamawenekoaretyakehena. ");
INSERT INTO pabNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hatyo hiyeta maika xala xamani Judéia koa tyaonita hoka tekoahenaira tyairi koni xeta. Maika xala xamani wenakalati tyaonita hoka kikisoahetehena rotitaira enakoata. Maika xala xamani mase tyaonita hoka awa atyo haikoahetehena wenakalati. ");
INSERT INTO pabNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Hiyaiya, hatyo xowaka atyoite judeunai nómane iniyalahare hiyeta kahenehare kaisere tyaona, hoka hatyo xowakaite tyotya Iraiti Waiyexe kaxairatyakehenere iraehenereharenai kaotyakehena. ");
INSERT INTO pabNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kaxiyani, hatyo xowakiya atyoite howitihare tyaohena tifalonai, xoimaisanironai xoaha ana! Hiyaiya, howitiharexe wenati atyoite kaotyaka waikohekoa, exahe Enore xomokala iniyalahare atyoite kaotyaka judeunai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kahare ite kaxaisakaha kesekase kakoa, exahe haiyaharenaite kakolatyaka alita eberexotyakaharenai akereta tyotya wenakalati kalokoarenai xeta. Exahe majudeuneharenaite tyaonaha Jerusalém nali, nalita kakikisakehetehenahere kijiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","— Xoalini hare ite kaotyaka kamai, kaimare, xoresenai xoaha hiye. Hoka waikohekoaite tyotya haliti hotyalinaite mawaiyeharehenaha kalore, hamairaneha one kaloxere, exahe one ainakoiyatyoitere nemahare hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hakakoare waikohekoaite kahare halitinaite mawaiyehareha kalore, hamairaneha, haxahekolaha xoalinihare kaotyakene tahi xoaha hiyeta. Hiyaiya, enokoa nali kinatere tyaoniterenaite maiyaterehare tyaohitita. ");
INSERT INTO pabNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hatyaosetaite Haliti Ityanite kaotyakehetehena hoka exoahetehena kaiminiti konita, iyateliti, kalorexe xaokanatyakalati xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","— Hoka maika exeharenai kaotyakehena hoka maika heko xikinatere xisaona exahe maika xakenekakoahena. Xiyaiya, mawaheneta atyoite hoka xikaiyakehetehena — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hatyaoseta Jesus exakere aimenekotya enomanaha: — Xasemehena, halohalo exahe hatyatere atya kate tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Xiyaiyehena atyo ehanahinai hikoaneheta hoka waiyekehalakita atyo xomana, okoi enonenehetehena. ");
INSERT INTO pabNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Maika nikareta tehitiya exeharenai kaotyakene xiyaiyehena hoka waiyekehalakaira xomana Enore nalitare Kalorexe okoi haikoahetehenerehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","— Xotyaxematyaira exeharenai: exeharenaityaite kaotyaka kalikini kasetaterenai tyaonitereharenai makamaneharene nahitita. ");
INSERT INTO pabNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hoka enokoa, waikohe xoahanai tyaite maiyareheta, xakore hoka niraini tyatyoite tyaoneta mene — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hoka Jesus halakihena hairaene hoka nehena: — Maika xikaxaikoawihena! Awa atyo hisehaliti, oloniti ahekakisare, exahe xawenane ali waikohekoare tahi taita xema xisaona. Hoka maisa hatyo ferakene ximaxatyahanehareta kaotyakihitita xomana. ");
INSERT INTO pabNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hatyo ferakene ite kaotyakeheta tanolatyati akereta tyotyaha ana, hakakoare waikohekoa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hatyo hiyeta maika xikaxaikoawita, exahe xiraexata mene hoka xikaxaihare xisaona tyotya kaotyakehenerehare nonitata. Exahe heko xikinatere xisaona maheta Haliti Ityani nahalakoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesus aotyakijita halitinai Iraexatyakalati Hanako ferakiti nihatyaka. Hoka makiya xanehitita Oliveiras tyairiya nali nemaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hoka tyotya halitinai xanahitaha makiyaseta Iraexatyakalati Hanako semaha maheta iniraene. ");
INSERT INTO pabNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Maisa wahehetere Hisehaliti Nakairati Makaorehetyakahare nomaka xowaka Páscoa nexarexe naheta ");
INSERT INTO pabNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","hoka sacerdotenai xekohasenai, xaotyakiyaho kakoa waiyoreterenai xoaha ahekohenaha hametenetaha haxaisaneha Jesus tahi, halitinai amairakisahitene hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hatyaoseta Ahalakoahaliti kamilakoretya Judas Iscariotes nexarexe. Hatyo atyo 12-harenai exaotyakiraharenai konitare. ");
INSERT INTO pabNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hoka Judas xane irai sacerdotenai xekohasenai, Iraexatyakalati Hana kaxaikotyaseharenai kakoa, hamatawala Jesus enomanaha tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hoka kalore ihalahareha hoka olo isaha enomana aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hoka Judas tyakeko hoka kaxaikohena Jesus matawatya maheta halitinai masemakareneta. ");
INSERT INTO pabNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hatyaoseta xane hikoa Hisehaliti Nakairati Makaorehetyakahare nomaka ferakene. Hatyo xowaka judeunai aisahitaha kalanero mokosenai hoka otyaxemahenahititaha Páscoa ferakene. ");
INSERT INTO pabNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hatyo hiyeta Jesus axikatya Pedro, João xoaha hoka nexa ihiyeha: — Xiyane nakairati xisoma womana Páscoa niyahare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hoka axahene: — Alyako wiyane wisoma hatyoharenai haokita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hoka Jesus nexa ihiyeha: — Xasemehena: xikaokehenatyaite wenakalati hoka hatya haliti kolaitere tinihalitiri ako haonexa tyaite ahalakoatya xiso. Hoka xiyanira hatyo haliti xema, hatyako isoahetehenere ako kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hoka maika xexa hati xekohase hiye: “Xaotyakisatiye exakere waxa aokita, aliyeri akoite hatyo, exaotyakiraharenai xoaha kanakairehenaha Páscoa ferakene nahitita?” xexaite ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hoka hotikisaite xomana halyako kaloakore exomokakotyakahare, ehaore ako. Hoka hatyoakoite xisoma nakairati — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hoka xaneha wenakalati xeta hoka Jesus niraine akereta tyotya waiyaha. Hoka hatyo nali nakairati tyomaha Páscoa niyahare. ");
INSERT INTO pabNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Enaose xane hikoa hoka Jesus tyoka mexa haliya haxaotyakiraharenai kakoa ");
INSERT INTO pabNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","hoka nehena ihiyeha: — Nokanakairi terota naokowi xikakoa exe nakairati kalikini Páscoa xowaka, nomakawatihalini nahitita. ");
INSERT INTO pabNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hatyo hiyeta nomita: maisaiya xoana hekota nokanakairihitita exehare nakairati, nokanakairihenere aliterexe nakairati kaomakehenere Enore Nawenakala kijiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hatyaoseta Jesus iya erakakalati hoka iraexatya Enore hiye — Ehekore hamokita wiso, Abá — nexa. Hatyaoseta nexa haxaotyakiraharenai hiye: — Xotehena exe hoka xiserehenene ini xakini. ");
INSERT INTO pabNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aliterexe nomita xihiye: maisaiya atyo xoana hekota exehare vinhoxa noterehitita, Enore nalitare Kalorexe kaokehetehenere kijiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hatyo najikinita iya nakairati hoka iraexatya Enore hiye. Hatyo najikinita taikasetene hoka irakene haxaotyakiraharenai ana hoka nehena: — Exe atyo noháre hoka kaxekakehenaite kahawaonitaretya xiso maheta. Exakerira xisoma xotyaxemaheta natyo maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kanakairehenahere najikinita nikareta iyihitiya erakakalati hoka isehitiyene enomanaha teraha maheta hoka nexa: — Hiyaiya, exe atyo notimalaxi, kaxiratyakehenere kahare haliti wanahiya, kaxemaisatyakeheta maheta iniyalahare enómaneha. Exe timalati hiyeta atyo waitare wenati tyaoheta halitinai ana Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","— Hoka xasemehena! Matawatyatiye atyo ali tyokita nohakakoani ali mexa haliya. ");
INSERT INTO pabNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hiyaiya, Haliti Ityani atyoite wainihena, Enore aokitere akereta. Xakore hoka kirakoanite kaxomokaka Haliti Ityani matawatyasehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hatyaoseta exaotyakiraharenai hatyokakoaha makere axakakoahenaha, xala xamaniya nikare matawahenene. ");
INSERT INTO pabNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hatyaoseta exaotyakiraharenai kinatyaxa iraikakoaha, semaha maheta xala xamani enekonitareha kalorexe kaiserehare hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Hoka Jesus nexa ihiyeha: — Kalorexenai ali waikohekoare atyo wakatita halitinai, exahe xekohasetinai atyo “Halitinai hinaeharenai” kaxaokakita. ");
INSERT INTO pabNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hoka xisoiya atyo maisa nikare xisaonita. Xakore hoka xinekoni kalorexe kaiserehare tyaonitere atyoite wakahare akereta tyaohena, exahe wakatiterehare atyoite kawakatyakitere akereta tyaohena. ");
INSERT INTO pabNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Xala masakare kalorexe? Tyokitere mexa haliya kanakaira maheta, xoana etyaisasehare kore? Aliterexe atyo mexa haliya tyokitere kalorexe. Hoka xinekoni atyo natyo atyo tyaijitere akereta notyaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","— Hoka xiso atyo eko nohaliye xisaona nomakawatihalininai xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hatyo hiyeta Baba kalorexe mohenere natyo akeretaite natyo tehitiyaite nikareta namoka xiso. ");
INSERT INTO pabNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Xisonaite xikanakaira, xisera nawenakali nali, exahe xisokaite okahakalatikoa hoka 12-hotyalinai Israel hotyalinai xekohasenai xisaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesus nehitiya: — Simão, Simão, hasemehena waiye: Ahalakoahaliti atyo koxaka kahalakisaka hasakaharetya xiso maheta. Xoisaite xiso, masene nomasehare trigose haware mokitere ekase nonitata akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Xakore hoka niraexaita atyo hitahi, Simão, maisa hityakekone hahalakijita maheta. Hoka hisaohetehitiyere nokoamaniye xowaka haihalahalinikisa maheta hihinaeharenai — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hoka Pedro nexa ihiye: — Nomimiye atyo notyaonita nokaberexotyaki, exahe nowaini maheta hihakakoane! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hoka Jesus nexa: — Natyo atyo nomita hihiye: awisaite, takoira makawiraharene nahititaite hanamakite himawaiyanenehare haoka natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hatyo najikinita Jesus axahena: — Xoana maisa xoare hare xaokita naxikahenere xiso ximabosanehare, ximasakolanehare, ximakijitinihare xowaka? nexa. — Maisa xoare waokita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hatyaoseta Jesus nexa: — Hoka kalikini xala xamani atyo kabosanexe, kasakolanexe hoka maika iyehetehenene. Exahe xala xamani maisa kakeserakasexe hoka maika betehena haimanase hoka iya haeho. ");
INSERT INTO pabNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hiyaiya, Iraiti Waiyexe kaxairatyakehenere atyo nexa: “Xalijiniharexe akereta kaxomokaka”, nexa. Hoka natyo atyo nomita xihiye: nikare terotaite nokaxomokaki. Hiyaiya, xoare xamani atyoite xairatyoare tyaonita notahi hoka nikare ite nokaxomokaki — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hatyaoseta exaotyakiraharenaisa nexaha: — Xekohaseti, owene hinamaeho kesekase — nexaha. Hoka: — Ehekore — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hatyaoseta Jesus xane, hawenane akereta, Oliveiras tyairiya xeta hoka exaotyakiraharenai xaneha exema. ");
INSERT INTO pabNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Xane kaoka aokiteraose hoka Jesus nexa: — Xiraexahena maisa xikamaoseratyakita maheta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hatyaoseta kikisoa sekose aka enonyahitaha, kala xoana xamani hoka 30-metrone hare. Meholokoa hakaolise kakoa hoka iraexahena, ");
INSERT INTO pabNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","hoka nexa: — Abá! haokaiya hoka hemaisaheta noniti exe erakakalati emakawatikisare. Xakore hoka maisaiya atyo naokiterehare kaomakita hoka maika haokiterehare kaomaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hatyaoseta anjo enokoatare exoa enomana, aihalahalinikisene maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kalore amaikohareta hoka Jesus masakare aiyateretyoa iraexaita. Hoka ewatehirini xata motya timalati tohira ixoita waikoa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Iraexahenere najikinita tityoaheta, haikoaheta haxaotyakiraharenai tyaonitere nali hoka nemakitaha waiyehenahitene, kalore amaikoharahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hoka nexa: — Xoanere hoka xisemakita? Xatityoahetehena exahe xiraexahena maisa xikamaoseratyakita maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus iraetata hoka kaokehena kahare halitinai. Judas, 12-hare exaotyakiraharenai konitare, tyoita hatyo halitinai kakoa, hoka xane kaoka Jesus haliya sohitanakolisene maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Xakore hoka Jesus nexa ihiye: — Judas, xoana hisohitanakolira kakoaite hamatawahena Haliti Ityani? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hatyaoseta exaotyakiharenai Jesus haliya tyaoniterenai ana waiyekehalaka hoka nexaha: — Xekohaseti, wiyehenaite wikeserakasenai hoka wijiyehena enomanaha? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hoka hatya enekonihatareha mokotya kesekase kakoa sacerdotenai xekohasehare wakanehare hoka itinihe aikotya, ifihini maniya. ");
INSERT INTO pabNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hoka Jesus watyalini: — Hahalakihenene! nexa. Hatyaoseta itinihe hiye ekaokakisa hakahe hoka awaiyehetene. ");
INSERT INTO pabNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hatyaoseta Jesus nehena sacerdotenai xekohasenai hiye, Iraexatyakalati Hana kaxaikotyaseharenai, judeunai nityohalitiranai xoaha tyohenerenai exotokase maheta hiye. — Xoana hoka xisoa nomani kesekase atyalihose harenai kakoa xotoka maheta natyo xalijiniharexe akereta? ");
INSERT INTO pabNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ferakiti nihatyaka notyaonita xikakoa Iraexatyakalati Hanako, xakore hoka maisa atyo xotokare natyo. Hoka kalikini terota atyo nikare xiyomokala natyo, exahe makaliroti niyatere xoaha hiyeta tehitiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hatyaoseta Jesus otokaha hoka xaneha ekakoa sacerdotenai xekohase hana xeta. Hoka Pedro sekoseta xaneta exema. ");
INSERT INTO pabNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hatyaoseta xane kaokaha hoka airihityaha wetekokoa hoka Pedro xane tyoka, hatyo tyokalyaosetiterenai haliya. ");
INSERT INTO pabNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hoka hatya wakahalo waiyene tyokita nali irikati haliya hoka waiye wahakotya enomana hoka nexa: — Exe haliti tehitiya ene Jesus haliya tyaonita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hoka Pedro teraharetyoahena hoka nexa: — Ohiro, maisa atyo nowaiyanihare xini! nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hatyohekota mawahaneta, hatya haliti waiyehitiyene nalita hoka nehitiya ihiye: — Hiso tehitiya atyo enekonitareha — nexa. Hoka Pedro nehitiya: — Maisa atyo enekonihatareha xini natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hatyaoseta kala wahasehena hoka hatya aiyateretyoa exahita: — Aliterexe atyo hisaonita ene ehaliya. Hiyaiya, Galiléia koa yere tehitiya atyo hiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Xakore hoka Pedro nexa: — Maisa atyo waiyekehalakere nomani hatyo hiraitere! nexa. Hatyo xowaka, iraetata ene hoka takoira kawisa. ");
INSERT INTO pabNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hatyaoseta Xekohaseti ehaikoahare hoka kinatya wahakotya Pedro ana. Hoka oteheta Xekohaseti iraitere ekakoa: “Awisaite, takoira makawiraharene nahititaite hanamakite himawaiyanenehare haoka natyo”, nehenere. ");
INSERT INTO pabNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hatyaoseta Pedro hikoaheta nalita hoka tiya, kalore amaikohare hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hatyaoseta halitinai Jesus kaxaikoterenai koexahalihenahene, mokohenahene xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Talatyaha exosenaiha hoka nexahitaha ihiye: — Hotehena, xalatya mokotya hiso! nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hoka kahare xoalini hare iraihitaha ekakoa, kahare watoxaharetyahene. ");
INSERT INTO pabNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ferakoa ihiyeha hoka judeunai nityohalitiranai, sacerdotenai xekohasenai, Xaotyakiyaho kakoa waiyoreterenai xoaha ahohisakoatyakakoaha. Hatyo najikinita Jesus nolokaka aokaha xekohasetinai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hatyaoseta axehenahene: — Hiyakaihena wihiye: xoana, Enore Kalorexe Aohenere hiso? nexaha. Hoka nehena ihiyeha: — Exahiya atyo, “Há, natyo”, nomi xihiye hoka maisaiya atyo xityakekota natyo. ");
INSERT INTO pabNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Exahiya naxa xiso hoka maisaiya xekoaxaita nomani. ");
INSERT INTO pabNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hoka kalikinita atyoite Haliti Ityani xane tyokehena Enore maxaexahityakahare niyaterexe fihini maniya — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hatyaoseta tyotyaha axahene: — Hoka xoana, Enore Ityani hiso? nexaha. — Xiso atyo nikare xiraeta — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hoka tyotyaha nexaha: — Maisaiya xoare maheta waxehitita etahi! Hiyaiya, wisota atyo wasema iniraene! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hatyaoseta tyotyaha tityoahenahitaha hoka xaneha Jesus kakoa Pilatos nali. ");
INSERT INTO pabNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nali iraeharehenahene hoka nexaha: — Wotoka exe haliti, mawaiye nawenanetita wihinaeharenai hoka. Exahe olo maxekakene aokita Kalorexe Roma yere ana. Exahe Enore Kalorexe Aohenere tehitiya aokowita, xekohaseti atyo — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hatyaoseta Pilatos axa Jesus: — Xoana, judeunai xekohase hiso? nexa. — Hiso atyo nikare hiraeta — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hatyaoseta Pilatos nehena sacerdotenai xekohaseharenai, exahe tyotya halitinae xoaha hiye: — Maisaiya xoare xemere exe haliti kaxaisaka naokita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Xakore hoka exahehare aiyateretyoaha exahita: — Exe atyo mawaiye nawenanetita Judéia koa tyaoniterenai. Galiléia koa hotohare nikare tyaona hoka kalikini ali kaoka — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hatyoharenai sema Pilatos hoka axahene: — Xoana exe haliti Galiléia koa tare? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sema, Jesus atyo Herodes kaxaikotere nalitare hoka Pilatos axikatene enomana, Herodes hatyo xowaka tehitiya nali Jerusalém tyaonita hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes waiya Jesus hoka ihalahare, semita etahi hoka toahiyita waiyene aokowita. Kasani waiya aokowita xoalini hare metaharexe maomakahare waiyexe enómane. ");
INSERT INTO pabNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hatyo hiyeta axehekoatya Jesus, xakore hoka maisa ekoaxaita enomana. ");
INSERT INTO pabNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hatyaoseta sacerdotenai xekohasenai, Xaotyakiyaho kakoa waiyoreterenai xoaha tityoaha hoka iraeharetyaha kahare Jesus. ");
INSERT INTO pabNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes tehitiya hasorarexanai kakoa koexahalisa Jesus, maisa aiminisahitene. Hatyaoseta mokaha ihiye imiti nase waiyeharexe hoka axikahenahitene Pilatos ana. ");
INSERT INTO pabNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodes, Pilatos xoaha, hatyo nahitita hamahinaeharene aokakakoahitere, hatyo ferakene hahinaehare aokakakoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hatyaoseta Pilatos ahohisakoatya sacerdotenai xekohaseharenai, judeunai nityohalitiranai, halitinai xoaha ");
INSERT INTO pabNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","hoka nexa ihiyeha: — Xiso atyo xakolatya exe haliti nomani, xihinaeharenai mawaiye nawenanitita xaoka hoka. Xakore hoka xityotya xihaotita naxehekoatene hoka maisa xoare harenai nasemita etahi hatyo xiraeharetiterenenai akiti. ");
INSERT INTO pabNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Exahe Herodes tehitiya maisa xoare hare iniyalahare semita. Hatyo hiyeta axikahetehitiyene womana. Nikare hoka aliterexe atyo exe haliti maisa xoare hare tyomita hoka mahaiya aliyakere kaxaisakita. ");
INSERT INTO pabNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kala emokonasetyaka naoka. Hatyo najikinitaite nahalakisene hoka xaneheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Páscoa xowakehena hoka Pilatos aihikoahitita hatya berexoakota halitinai xaxane ximita hoka nikare irae. ");
INSERT INTO pabNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hatyaoseta tyotya halitinai kawiyahenaha: — Barrabás haihikoahetehena womana hoka hatyo haliti xaisaka haohena — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás hatyo xowaka kaberexotyaka mawaiye nawenanititere wenakalatikoarenai exahe katawanetere xoaha hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hatyaoseta Pilatos, kasani halakiheta aokowita Jesus hoka iraihitiya halitinai kakoa, ");
INSERT INTO pabNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","xakore hoka exahehare kawiyatyaha: — Haberekohenene atyalihose xaimaholatyaka hiye! Haberekohenene atyalihose xaimaholatyaka hiye! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hoka Pilatos nehitiya ehanamakinihena hiye: — Hoka xoare iniyalahare tyoma? Maisa xoare enómane iniyalahare nowaiyita hoka mahaiya exaisaka naokita! Emokonasetyakaite naoka hoka hatyo najikinitaite nahalakihetene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Xakore hoka heko kinatyaxa kawiyatyaha, kasani Jesus kaberekotyaka atyalihose xaimaholatyaka hiye aokahitaha. Hoka ekawiyalaha jiyahaotene. ");
INSERT INTO pabNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hatyaoseta Jesus kamane aoka Pilatos axahitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Exahe aihikoaheta enomanaha haliti aokahitere, etake kaberexotyakehenere mawaiye nawenanititere exahe katawanakaitere xoaha hiyeta. Hoka halakisa Jesus enomanaha hoka aokahitere akereta mokahene maheta. ");
INSERT INTO pabNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hatyaoseta sorarenai xaneha Jesus kakoa. Hoka ahotyaho ahalakoatyaha hatya haliti, Simão nexarexe, wenakalati Cirene yere, maseta ene tyohitita. Hoka otokaha Simão hoka atyalihose xaimaholotyaka kolatyaka aokaha ihiye hoka Jesus xema xane aokaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kahare halitinai xanetaha exema. Enekoniha haiyahalonai ohironai tiyahitaha, amaikohaloahitaha ekawa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hoka Jesus ehaikoahare enomanaha hoka nexa: — Ohironai, Jerusalém yolonai! Awa atyo xitiya nokawi, xakore hoka maika xikawa exahe xityaninai kawa xitiyahena! ");
INSERT INTO pabNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hiyaiya, haxowaka ferakenehenaite hoka tyotyahaite nexaha: “Waiye kaiserehare atyo ohironai maisanihalonai ana, exahe xoima maxawenakirahalonai ana, exahe xoimanai maxaokokirahalonai ana!” ");
INSERT INTO pabNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Haxowakaite tyotyahaite nexaha tyairinasenai hiye: “xoahena wiheno hoka xateroakisa wiso!” Exahe nexaha tehitiyaite tyairinai hiye: “xoahena wiheno hoka xaxaihonotya wiso!” nexahaite. ");
INSERT INTO pabNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hiyaiya, nikareya kaxomokakita mowisati eholitata hoka xoanaite kaxomokakehena nirehena hoka? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xaneha tehitiya hinamahare xalijiniharexenai kakoa, kaxaisakaha maheta Jesus hakakoane. ");
INSERT INTO pabNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Xane kaokaha ekakoaha “Seriti Nahe” aokahitere nali hoka berekotyaha Jesus atyalihose xaimaholatyaka hiye, exahe ehaliya hoka hinamahare xalijiniharexenai berekotyaha atyalihose xaimaholatyakanai hiye. Hahare ifihini maniya, hahare ewatone maniya xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hatyaoseta Jesus nehena: — Abá, maika exe halitinai nómane iniyalahare hemaotyaneheta, maisa atyo waiyorexe háomaneha kakoa — nexa. Hatyo najikinita sorarenai hasakaharetyakakoaha hoka Jesus nima irakakakoaha hatyokakoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hoka halitinai nali tyaonahitaha hoka wahakotyahitaha. Hatyo nase judeunai nityohalitiranai koexahaxatyahitaha Jesus kakoa hoka nexahitaha: — Haiyanai atyo iyehitita. Hoka maika hatyota iyoawiheta, aliterexe atyo Enore Kalorexe Aohenere hoka! nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sorarenai tehitiya koexahaxatyaha ekakoa. Kaokaha Jesus haliya hoka isehenaha vinhoxa ewaxirahare enomana ");
INSERT INTO pabNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","hoka nexahitaha: — Aliterexe atyo judeunai xekohase hiso hoka hisota hiyoawihetehena! nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Taba taose hiye, ehao maniya, xairatyoare tyaonita exakerexe: ");
INSERT INTO pabNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hatya nali xalijiniharexe kaberekotyakehenere aiyalatya enomana hoka nehena: — Xoana, maisa hiso xini Enore Kalorexe Aohenere? Hoka hiyoawihetehena hisota hoka hiyeheta tehitiya wiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hoka hatya watyalihenene hoka nexa: — Xoana, maisa himairare Enore? Wityotya atyo hakakoa wikaxomokakita. ");
INSERT INTO pabNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iniyalahare wiyomokaka atyo kaxemerexe, hiyaiya, iniyalahare atyo wikaxomokakita wománenai hiyeta. Hoka hatyo atyo maisa xoare iniyalahare tyomare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hatyaoseta nexa Jesus hiye: — Jesus, hotehetaira natyo, hisohetehenere Kalorexe hisaona maheta xowaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hoka Jesus nexa ihiye: — Aliterexe atyo nomita hihiye, awijita atyoite hisaona nohaliye wenakalati waiyexe nali — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hatyaoseta kala totahikoahena hare hoka kamai maxaokanala hoka tyotya waikohekoa makaliro tyaona makakoahena kijiya. ");
INSERT INTO pabNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Hoka Iraexatyakalati Hanako imiti taose tyaonitere nekese taose halalakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hatyaoseta Jesus kawiyatya kinatyaxa: — Abá, hikahekoa nahalakisa nisekohare — nexa. Nikare iraehenere najikinita waini. ");
INSERT INTO pabNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hatyaoseta Roma yerenai sorare xekohasehare waiya hatyoharenai hoka tyakeko Enore hoka nexa: — Aliterexe atyo exe haliti maisa iniyalahare nomasehare xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tyotya nali hohisakoahenerenai waiyaha maheta nikare kaxomokakehenere waiyaha hatyoharenai hoka haikoahenahitaha hahanaha xeta haxamaikohareneha, exahe hatikolalinaiha hiye hamokolaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tyotya Jesus hinaeharenai, exahe ohironai Galiléia ta tyohenolonai exema xoahanai, sekota tyaonahitaha hoka wahakotyahitaha tyotya hatyoharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hoka nali tyaonita hatya haliti, José nexarexe, wenakalati Arimatéia yere, Judéia koa nali. Hatyo atyo waiyexeharexe, aiminisare, exahe atyahita Enore nalitare Kalorexe xahita. ");
INSERT INTO pabNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Xekohasetinai konitare xakore hoka maisa haiyanae kalorexenai niraekakoane, exahe tyomehenahere ehekoreta enomana. ");
INSERT INTO pabNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hoka José xane Pilatos ana axa maheta Jesus háre. ");
INSERT INTO pabNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hatyaoseta iyeheta eháre atyalihose xaimaholatyaka hiyeta hoka olahisetene imiti kese taosero kakoa. Hatyaoseta mokene xawatyakalati kasekakotyakehenere tyairi hiye ako. Maisa xala hare hatyoako kaxomokakehenere. ");
INSERT INTO pabNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Exowaka sextafeira, okoi sábadohena. ");
INSERT INTO pabNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ohironai Galiléia ta xanehenolonai Jesus xema xaneha José xema hoka waiyaha xawatyakalati, exahe Jesus xomokaka xoaha. ");
INSERT INTO pabNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hatyaoseta haikoahenahitaha hahanaha nali xeta hoka tyomaha airaxeronai eháre niyahare maheta. Hoka sábado xowaka kawiniha Xaotyakiyaho aokitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo xowaka witita, ohironai xane xawatyakalati xeta hoka tyomehenahere airaxeronai kolatyaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hoka waiyehenaha atyo, xawatyakalati xisoakalahore sehali taose atyo koxaka kaiyakeheta. ");
INSERT INTO pabNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hoka isoaha xakore, hoka maisa waiyehenahititaha Xekohaseti Jesus háre ");
INSERT INTO pabNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","hoka maisa aliyakere ahekotya xaka mokahene. Hoka eharehena rotita enahalakoaha kaotyaka hinamahare halitinai imiti werokatexe akorenai. ");
INSERT INTO pabNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hoka kalore mairaha hoka meholokoaha hoka talatihotyoaha. Hatyaoseta nexaha: — Xoana hoka kamatinai tyaonitere aose xatawita kasetatere? ");
INSERT INTO pabNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maisa atyo aliyakeheta, koxaka kaseheta hoka. Xotyaxemahenaore iniraine xikakoa, Galiléia nalitatere xowaka. ");
INSERT INTO pabNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Haliti Ityani atyoite kahalakisakehena terota iniyalahare nomaseharenai ana. Kaberekotyakehena terota atyoite atyalihose xaimaholatyaka hiye hoka kasehetaite hanamaki ferakene najikinita”, nehenere — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hatyaoseta ohironai otehetaha iniraine ");
INSERT INTO pabNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","hoka haikoahenahitaha xawatyakalatita hoka hatyoharenai xakaiha 11-hare exaotyakiraharenai hiye, exahe tyotya haiyaharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Exehalonai nikareta: Maria Madalena, Joana, Tiago nityo Maria xoaha. Hatyonai, haiyahalonai ohironai xanehenolonai xoaha xakaiha tyotya hatyoharenai exaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Xakore hoka motya ohironae maoseraita aokahitaha hoka maisa tyakekoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hoka Pedro tityoaheta tema xane xawatyakalati xeta. Meholokoa waiyakotya maheta, xakore hoka maisa xoare waiyita, imiti kese taosero mohenahere taita, maisa xoare hitiya aka. Hatyaoseta haikoaheta hahana xeta hoka hakaharetyoa hatyoharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hatyo ferakeneta hinamahare enekonihatareha xanetaha wenakalati Emaús xeta. Jerusalém nalita kala 10-kilometro hatyo wenakalati. ");
INSERT INTO pabNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iraisahotyahitaha tyotya hatyoharenai kawenatyakehenere tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iraisahotyahitaha, axakakoahitaha harenai ene hoka Jesus terota kaoka ehaliyaha hoka tonehena exemaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Exaotyakiraharenai waiyene, xakore hoka exosenaiha motya jihotyoare tyaonita hoka maisa waiyekehalakaharehitita enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hoka Jesus axahene: — Xoare xexa xiraisahotita ahotyaho? nexa. Hatyaoseta tityoaha haxamaikohareneha kakoa, ");
INSERT INTO pabNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","hoka hatya, Cleopas nexarexe, nexa: — Xoana, hiwawala hiso Jerusalém nali tyaonitere maisa hasemita kafaka kaotyakehenere tahi? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","— Xoare tahi? nexa axa. — Jesus Nazaré yere tahi — nexaha. — Hatyo haliti ene iraiti xakaisasehare, exahe Enore hoka tyakekotene, exahe tyotya halitinai hoka. Exahe haliti kinaterexe aokahitene enawenane, iniraene hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hoka sacerdotenai xekohasenai, winityohalitiranai xoaha isahene Roma yerenai ana kaxaisaka maheta hoka sorarenae berekotyahene atyalihose xaimaholatyaka hiye. ");
INSERT INTO pabNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Motya atyoite wiyahekola hiye hoka hatyo iyehetehena Israel hotyalinai waokita. Hoka kalikini kakoita hanamakihena wisaonita hatyoharenai najikinita. ");
INSERT INTO pabNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","— Hoka haiyahalonai ohironai winekonitarenai ahakaharetyoakisaha wiso. Xaneha makiyaseta xawatyakalati nali ");
INSERT INTO pabNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","hoka maisa waiyehenahititaha eháre. Haikoahenahitaha hoka xakaiha wihiye. Waiyaha anjonai hoka Jesus atyo kaseta aokaha ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hatyaoseta haiyaharenai winekonitarenai xaneha xawatyakalati xeta hoka waiyaha ohironai xakaitere akereta hoka maisa atyo Jesus waiyehenahititaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hatyaoseta Jesus nehetehena ihiyeha: — Xoana hoka howitihare waiyekehalakita xomana? Xoana hoka maisa xityakekota tyotya iraiti xakaisaseharenai iraehenerehare? ");
INSERT INTO pabNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Xiyaiya, nikare terota atyo Enore Kalorexe Aohenere xomokaka iniyalahare hoka hatyo hiyeta Enore isa maheta enomana kalorexe iyateliti — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hatyaoseta awaiyekehalakatya enomanaha tyotya Iraiti Waiyexe nanekoa iraetere etahi akiti. Moisés xairala tahi hotohare, exahe tyotya iraiti xakaisaseharenai xairala harenai. ");
INSERT INTO pabNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Xane kaokehenaha wenakalati xanahitere haliya hoka Jesus motya exaihakoha xeta xanetere akereta tyaona. ");
INSERT INTO pabNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hoka tihityoaha ihiye, hekota maheta ekakoaha hoka nexaha: — Alita hiso wihaliya. Hiyaiya, makakoahena, makehena — nexaha. Hatyaoseta Jesus isoa exemaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tyoka ekakoaha mexa haliya hoka iya nakairati hoka iraexatya Enore hiye. Hatyaoseta taikasetya nakairati hoka irakene enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hatyaoseta exosenaiha motya majiholatyoahetehena ene hoka waiyekehalakahareheta Jesus enomanaha, xakore hoka maiyareheta enonyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hatyaoseta hatya nexa hahinaehare hiye: — Motya wimahiyasenai kirita ene wimawinini ako ahotyaho iraetere, exahe awaiyekehalakaitere womana Iraiti Waiyexe nanekoa tahi xowaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hatyaoseta tityoahenahitaha hoka haikoahenahitaha Jerusalém xeta. Nali waiyehenahitaha 11-harenai exaotyakiraharenai, hohisakoahitaha haiyaharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hoka hatyonai nexaha: — Aliterexe nika Xekohaseti kaseheta! Simão waiyeheta Xekohaseti! nexaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hatyaoseta hatyo hinamaharenai xakaiha waiyehenahere ahotyahore, exahe waiyekehalakaharehetehenere Xekohaseti enomanaha, nakairati irahetehenere enomanaha xowakere xoaha tahi. ");
INSERT INTO pabNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hekotata xakaihakatyahitaha ene hatyoharenai tahi hoka Jesus ehárehena rotita kaotyakeheta enenekeseneha hoka nehena: — Kasani ximehexaikohare xisaona naokita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hoka mawaiyehareha, kalore mairaha, motya isekohalititere aokahitene hoka. ");
INSERT INTO pabNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hoka nexa: — Xoana hoka ximawaiyehareta? Xoana hoka kahare xoalini hare xahekoita? ");
INSERT INTO pabNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xiyaiyehena nokahenai exahe nokijinai ana hoka natyo terotaite xiyaiyehetehena. Xotokoahena nohiye hoka xityakekohena. Hiyaiya, isekohaliti atyo maisa káhexe, káetexe xini natyo akereta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nexa hoka hotikisa hakahenai, hakijinai enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Xakore hoka maisa terota tyakekoreha, kalore ihalaharahitaha exahe hakaretyoahitaha xoaha hoka. Hatyaoseta Jesus axahene: — Xoana ali xoalini hare kanakairatyakere? nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hoka isaha enomana kohase jihatyaka halakoase, maha nolone xoaha ");
INSERT INTO pabNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","hoka otokene, exahe kanakairene ehaotyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hatyaoseta nexa: — Notyaonitatere xikakoa xowakaira noxakaitaira tyotya kaotyakehenerehare notahi kaxairatyakehenere Moisés Xaotyakiraho nanekoare, iraiti xakaisaseharenai xairala nanekoare, salmos nanekoare xoaha tahika — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hatyaoseta awaiyolikisahene waiyoreha maheta Iraiti Waiyexe xairatyoare tyaonitere kakoa ");
INSERT INTO pabNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","hoka nexa ihiyeha: — Exakere atyo nita kaxairatyakehenere: Enore Kalorexe Aohenere atyoite kaxemakawatikisaka hoka hanamaki ferakene najikinita atyo ekaseneheta terota. ");
INSERT INTO pabNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hoka enexare hiyeta kaxakaisaka iraiti maheta tyotya haliti hotyalinai hiye, kahalakisaka exahe kamaotyanetyakeheta maheta iniyalahare enómanenai. Hatyoharenaite Jerusalém nali hotohare kaxakaisaka. ");
INSERT INTO pabNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","— Xiso atyo xiyaiya tyotya nikare nokaxomokakihenerenai. ");
INSERT INTO pabNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hoka natyota atyoite naxikahena xomana Baba isa aokowiterehare. Xakore hoka maika xatyaha ali wenakalatita, iyateliti enokoata kaokehenere xomana kijiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hatyaoseta Jesus nolokahene haware wenakalati nonitata hoka xane ekakoaha wenakalati Betânia nali. Hatyo nali hakahenai ehaoha moka hoka waiyexe wenati aoka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Waiyexe wenati aokitata enomanaha hoka Jesus kikisoahena enonyahitaha hoka kakolatyaka eno xeta. ");
INSERT INTO pabNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hatyohekota awaiyityahene. Hatyaoseta haikoahenahitaha Jerusalém xeta haihalahareneha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hatyota Iraexatyakalati Hanako tyaonahitaha mene, ihalaharahitaha Enore kakoa xoaha.");
INSERT INTO pabNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hetati waikohe maomakahare xowakiya, koxaka terota Iraiti tyaonita. (“Iraiti”, nita, Jesus xaokaka nikare iraeta.) Enore nali atyo Iraiti tyaonita, Enore atyo hatyo Iraiti. ");
INSERT INTO pabNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hetati xowakiya atyo Enore nali terota atyo Iraiti tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hatyo Iraiti hiyeta Enore tyoma enokoa waikohekoa, exahe tyotya xoaliniharenai hoka. Ekoiya awa hatyo Iraiti hoka maisaiya xoare harenai kaomakita. ");
INSERT INTO pabNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hatyo Iraiti atyo waiyexe wenati kakoare hoka xaokanatyakalati akereta tyaona halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Xaokanatyakalati aokanaita makaliroti koni hoka makalirotiya maisa aliyakere ewakaitene. (“Xaokanatyakalati”, nita tehitiya Jesus xaokaka. “Makaliroti”, nita xoalini hare iniyalahare xaokaka.) ");
INSERT INTO pabNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Enore axikatya João nexarexe ");
INSERT INTO pabNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","xakai maheta hatyo xaokanatyakalati tahi akiti halitinai hiye. João xakai halitinai hiye hoka tyotyaha sema xaokanatyakalati tahi akiti, exahe tyakekoha maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","João atyo maisa hatyo xaokanatyakalati xini xakore atyo hoka tyoa irae halitinae kakoa, xakai hatyo xaokanatyakalati akiti ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hatyo xaokanatyakalati atyo aliterexe, aokanaita tyotya halitinai ana. Hikoa halitinai koni hoka aokanaita enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hatyo Iraiti hiyeta Enore tyoma enokoa waikoa tyotya xoalini harenai. Hatyaoseta Iraiti tyaona halitinai koni xakore hoka maisa waiyekehalakita halitinai ana. ");
INSERT INTO pabNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tyaona hahinaeharenai judeunai koni xakore hoka maisa judeunai aokitene haomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Hoka haiyanai atyo tyakekone hoka haomanaha aokene. Tyakekone hoka hatyo hiyeta Enore haisaninai aokahene. ");
INSERT INTO pabNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tyakekoha hoka Enore ityaninai tyaonaha. Xakore hoka maisa atyo xoima kakaisanisakitere akerexe xini Enore ityaninai tyaonaha, exahe maisa haliti xaokalaoseta xini nikare tyaonaha. Enore xaokalita ityaninai tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hatyo Iraiti atyo haliti kyawa hoka tyaona winekoni. Waiye wiyaiyene, kalorexe terota. Haliti awaitita kaisere, iraiti aliterexe taita iraeta. Enore Ityani haterore atyo hoka nikare kalorexe tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João atyo irae etahi akiti naliyerenai hiye: — Koxaka niraeta xikakoa hatyo akiti. “Maikaite najikinita tyohena noxahehare. Koxaka xakore atyo tyaonita terota nahitita nomawenaniharetatere xowakiya”, nomi xihiye. Hoka hatyo atyo kalini kaoka — nexa João irai. ");
INSERT INTO pabNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kalore awaiyetya wiso hoka kahare xoalini hare waiyexe axikatya womana, fera hatyoharenai ijita womana. Hatyo hiyeta wawenane waiye tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés atyo wawenanaho halakisa womana: — Exakerexe xisaona — nexa aotyakisa wahetakomaniyerenai. Hoka Jesus Cristo atyo waiye mokita haliti, awaiyetita haliti, exahe iraiti aliterexe taita iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maisa xala harenai Enore waiyare hoka Ityani Jesus awaiyekehalakatene halitinai ana. Hiyaiya, Enore Ityani haterore, hanexe haliya tyaonita, hanexe Enore akerexe terota atyo. ");
INSERT INTO pabNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hatyaoseta judeunai nityohalitiranai axikatyaha sacerdotenai, Levi hotyalinai xoaha João nali xeta, João axaha maheta. Jerusalém nalita axikatyahitene. Tyoa kaokehenahitaha João ana hoka: — Xala atyo hiso? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hoka João nehena ihiyeha: — Maisa atyo Enore Kalorexe Aohenere xini natyo — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hoka nehenaha ihiye: — Hoka xalatya hiso? Xoana, Elias kore hiso? nexa axehenahitiyaha João. — Maisa Elias xini natyo — nihitiya ihiyeha. — Xoana hiso iraiti xakaisasehare watyahitere? nexaha axahenahitiyahene. Hoka: — Maisa — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hatyaoseta nehenaha João hiye: — Hoka xala kaisere hiso? Hiyakai wihiye hoka wasema hitahi akiti hoka wiyaneheta Jerusalém nali hoka wiyakai hitahi akiti wiyaxikatyasenai hiye — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hoka João nehena: — Exakerexe babera Isaías niraine kakoare: Hatya haliti maharexakiti kawiyaita: “Waiye xamohena ahoti hoka hatyoaho Xekohaseti jiya”, nita. Hatyo kawiyaitere atyo natyo — nexa João ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hatyo kaokiterenai João ana atyo fariseunai. ");
INSERT INTO pabNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hatyaoseta axehitiyahene: — Xoana maisa xakore Enore Kalorexe Aohenere xini hiso hoka habatixaita? Maisa Elias xini hiso, maisa iraiti xakaisasehare watyahitere xini hiso xakore hoka habatixaita? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Hoka João nehena ihiyeha: — Natyo atyo nabatixaita one kakoa hoka hatya xinekoni ximawaiyanenehare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hatyo atyoite najikini maniyata iraihena xikakoa. Hatyo atyo noxahehare hoka maisaiya natyonae aliyakere ikijitini nanohi hekoti naolikita — nexa João irai. ");
INSERT INTO pabNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wenakalati Betânia nali iraehitaha João kakoa one Jordão halakoiyaxa maniya, João tyaonitere batixaitere nali iraehitaha ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kamaetali waiyehena atyo João, Jesus atyo tyoita hoka João nehena: — Xiyaiyehena, owene Enore xaxikalahare. Maikaite kalanero mokose wainitere akere waini halitinai ana emaisatya maheta iniyalahare enómaneha maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","— Ali koxaka notyaonita hoka etahi akiti niraeta xihiye: “Maikaite najikinita tyohena noxahehare. Koxaka atyo tyaonita terota nahitita nomawenaniniharetatere xowakiya”, nomi xihiye — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","— Enore Ityani xakore atyo hoka maisa tehitiya waiyekehalakita nomani. Hoka nabatixatita haliti one kakoa Israel yerenai waiya maheta hatyo kalorexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","João nihitiya: — Nowaiya Isekohaliti Waiyexe watyahase akerehare exoahena enokoata hoka tyoa tyoka esiri heno. ");
INSERT INTO pabNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Maisa atyo waiyekehalakahareta tehitiya nomani hatyo Enore Kalorexe Aohenere. Xakore atyo hoka Enore axikatya natyo one kakoa nabatixatya maheta. Hoka noxaxikatyasehare Enore nexa nohiye: “Maikaite hatya ana exoahena Isekohaliti Waiyexe hoka: ‘Ahai, exe kore aokita. Exe atyoite Isekohaliti Waiyexe kakoa batixahena’, hehena”, nexa nohiye. ");
INSERT INTO pabNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aliterexe atyo nowaiya nikare. Hatyo hiyeta, “Ahai, exe kore Enore Ityani”, nomi exaokaka — nexa João ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kamaetali hoka João hatyo akitita hinamahare haxaotyakiraharenai kakoa xane tyaohenahitiyaha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hoka waiyehena atyo João, Jesus atyo jiyita hoka João nehena: — Owene Enore xaxikalahare. Maikaite kalanero mokose wainitere akereta waini halitinai ana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hatyaoseta hatyo hinamahare João xaotyakiraharenai semaha João niraine hoka xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus xaneta ene hoka terehokoa waiya hajikini maniya, waiyehena atyo, tyoahitaha exema hoka axehenahene: — Xoare xatawita? — Rabi — nexaha ihiye. Wiyako maniya atyo, “Xaotyakisatiye”, nita. — Rabi, aliyako hisaonita? nexaha axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","— Xisohena hoka xiyaiya — nexa Jesus ihiyeha. Hatyo xowaka makakoasehena. — Xisohena hoka xiyaiya — nexa Jesus ihiyeha hoka xaneha Jesus xema, waiyaha tyaonitere nali hoka tyaohenaha ehaliya heko maka ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Hatyo hinamahare xanetere Jesus xema atyo Simão Pedro ximarene André, exahe hatya tehitiya. João iraeta Jesus tahi hoka semene hoka xaneha Jesus xema. ");
INSERT INTO pabNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hatyo najikinita André xane háxenane nali. Xane hikoa enomana hoka nexa ihiye: — Wikaoka Cristo — nexa. Cristo atyo wiyako maniya, “Enore Kalorexe Aohenere”, nita. ");
INSERT INTO pabNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hatyaoseta André noloka háxenane Jesus tyaonitere nali. Xane kaokaha enomana hoka Jesus wahakotya Simão ana hoka nehena, — Hexare Simão, João ityani atyo hiso. Hoka kalikini atyo Cefas tehitiya hexare — nexa Jesus ihiye. Cefas atyo wiyako maniya, “Sehali”, nita. ");
INSERT INTO pabNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kamaetali hoka Jesus xane aokowi Galiléia koa xeta. Haxánene nahitita xane tawa Filipe xahita. Xane kaokene hoka nexa ihiye: — Hisohena noximi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe atyo Betsaida nalitare, André, Pedro xoaha tyaonitere nalitare. ");
INSERT INTO pabNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Hatyaoseta Filipe tawa Natanael xahita hoka irai ekakoa. — Moisés, iraiti xakaisaseharenai xoaha xairatyaha Enore Kalorexe Aohenere tahi. Kalikini atyo wikaokene. Hatyo wenakalati Nazaré tare José ityani Jesus terota atyo — nexa Filipe Natanael hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Hatyaoseta Natanael axehenene: — Xoana Nazaré nalitaiya kaotyaka xoalini hare waiyexe? nexa, komita maisa tyakekota. — Hisohena hoka hiyaiya — nexa Filipe ihiye hoka xaneha Jesus tyaonitere nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hatyaoseta waiyehena atyo Jesus, Natanael atyo kaokehena hoka Jesus nexa: — Xiyaiya, owehena Israel yere kaiserehare, exe atyo maisa maoseratyaliye xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hatyaoseta Natanael axehena Jesus: — Alyako hiyaiya natyo? nexa. — Filipe mairaineharetatere hikakoa xowaka nowaiya hiso, hisokita halohalo katyahe hoka — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","— Xaotyakisatiye, Enore Ityani atyo hiso! Israel hotyalinai Xekohase Kalorexe atyo hiso — nexa Natanael ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Hoka Jesus nehena: — Xoana, “Halohalo katyahe hisokita hoka nowaiya hiso”, nomihenere hiyeta hityakeko natyo? nexa. — Maikaite exe xahehare hiyaiya. ");
INSERT INTO pabNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hasemehena niraini: enokoaite totakore tyaona hoka anjonai Enore nalitarenaite kakohahitita, exoahitita xoaha Haliti Ityani ana. Exeharenaite xiyaiya — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hinama ferakene najikinita hoka sema wenakakoati hisehare wenakalati Caná nali Galiléia koa hoka Jesus nityo xane waiya hatyo hisehaliti. ");
INSERT INTO pabNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus haxaotyakiraharenai kakoa tehitiya kakaixakatyakaha hatyo wenakakoati ana hoka xaneha. ");
INSERT INTO pabNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hatyaoseta nali tyaoniterenai terahitaha oloniti hoka ekakoita enoloneha vinhoxa tyotya hoka Jesus nityo nexa haisani hiye: — Enoloneha tyotya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nexa ihiye hoka Jesus nehena: — Xoana hoka hiraeta nokakoi? Xoana natyoiyatya hoka? Maisa terota xane hikoahenere nokahinairaose — nexa hanityo hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hatyaoseta inityo nexa nali waikatehare wakaneharenai hiye: — Aokitere akereta xisoma, iraihena xihiye hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hatyo nali 6-ri tinihaliti kanote, kaloli, 80, 100 litrone niyahare. Judeunai nawenanaho hoka hatyohare akotarexa kakoa tihahitaha haitinihareha haháre xoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hatyaoseta Jesus nexa wakaharenai hiye: — Xakaisexatya one tinihalitinai ako — nexa. Nexa hoka tinihalitinai kaisexatyaha one kakoa, kaise mokahene. ");
INSERT INTO pabNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hatyaoseta Jesus nehitiya ihiyeha: — Xiyehena enakota hoka xiyane xisehena harekahare ana — nexa Jesus ihiyeha hoka kolatyaha exaokalaoseta harekahare ana. ");
INSERT INTO pabNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hatyaoseta harekahare hotohare hasaka hatyo one. Hasahena hatyo one hoka koxaka vinhoxa kyawa. Maisa atyo harekahare semare hatyo vinhoxa nomaka akiti hoka wakaharenai atyo waiyoreta. Hatyaoseta harekahare iraehena kaiyanityohenere hiye ");
INSERT INTO pabNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","hoka nexa ihiye: — Haliti hisehaliti tyomehena hoka vinhoxa waiyexere hotohare ijita oloniti faharenai ana. Hatyaoseta teraha miyahenaha waiyexere hoka enajikini maniya atyo isihitita ewaxiraharexa enomanaha. Hoka hiso atyo enajikini maniya waiyexere hisehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wenakalati Caná Galiléia koa nali hetati Jesus nikare maomakahare tyoma, awaiyekehalakaharetyoa kalorexe hawenane akiti enomanaha hoka exaotyakiraharenai atyo tyakekone. ");
INSERT INTO pabNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hatyo najikinita Jesus xane wenakalati Cafarnaum nali xeta hanityo, haximarenenai, haxaotyakiraharenai hare kakoa hoka akaiki ferakene hatyo nali tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hatyaoseta okoi xane hikoahena hisehaliti Páscoa ferakene hoka Jesus xane Jerusalém xeta. Páscoa xowakehena hoka judeunai hisehare tyaohena. ");
INSERT INTO pabNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jesus xane kaoka Jerusalém nali hoka xane isoa Iraexatyakalati Hanako. Waiyehena atyo, owene bowi, kalanero, watyaha harenai betetyasenai tyaonita, owene olo ehaikoakihititere harenai tyokita hamexaneha haliyita. ");
INSERT INTO pabNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hatyohekota Jesus tyoma hamokotyakalahi olawahi hoka aihikoaheta tyotya hatyoakorenai, kalanero, bowi harenai kakoita. Ehaikakoatya tyotya olo ehaikoakihititereharenai mexanenai enoloxaha kakoita ");
INSERT INTO pabNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","hoka nehena hatyo watyáha betetiterenai hiye: — Xiyakahetehena alita! Awa atyo Baba hanako exakere xisaona. Xoana wisekoliti nitini xaokitene? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hatyo najikinita exaotyakiraharenai otyaha Iraiti Waiyexe xakaisaseharenai xairala. Exakerexe exairalaha: Nawaiyetita hihana hoka nikare tyaonaha enako hoka maisa waiyeta nohiye, Abá. Nikare tyaonaha hoka ewatyatya natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hatyaoseta judeunai nityohalitiranai axehenene: — Xala niraene kakoare atyo hiso hoka nikare hisaona? Xoare ite hisomehena hoka wityakeko hiso? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","— Xexoakiheta exe Iraexatyakalati Hana hoka hanamaki ferakene taitaite hoka notyoma namemahetene — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hoka nexaha ihiye: — 46-terehokoane hakahitaha exe Iraexatyakalati Hana hiye hoka mematyahene. Hoka hiso atyo, “Hanamaki ferakeneta takitaiya hoka notyomehitiyene”, hexa — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Hatyo Iraexatyakalati Hana tahi Jesus iraitere atyo haháre xaokaka nikare iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Waini hoka kasehetehena najikini hoka exaotyakiraharenai hatyo xowaka iraitere otehenahitaha. Otehenahitaha hatyo xowakere iniraine hoka tyakekoha iraiti xakaisaseharenai xairala, Jesus niraine harenai. ");
INSERT INTO pabNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesus tyaonita hisehaliti Páscoa xowaka Jerusalém nali hoka kahare haliti tyakekotene, xoalini hare enómane waiyaha hoka hatyo hiyeta tyakekoahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hoka Jesus atyo maisa tyakekorahene, waiye otita exahekolaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Maisaiya atyo xoare maheta haiyaharenai tahi akiti exahekolaha hare xakaita ihiye, koxaka atyo otita makere tyotya hakakoare xahekola. ");
INSERT INTO pabNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Haxowakiya Nicodemos nexarexe kaoka Jesus ana. Nicodemos atyo judeunai nityohalitira, fariseu tehitiya atyo. ");
INSERT INTO pabNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Makiya tyoa waiya maheta Jesus hoka nexa ihiye: — Wiso atyo wotita hiso, xaotyakisatiye. Enore xaxikalahare terota waokita hiso, wiyaotyakisase maheta. Maisaiya xala harenai tyomita hisomitereharenai Enore mawenaneharene ekakoa hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Hoka Jesus nehena ihiye: — Hasemehena niraini: Maisaiya haliti kaxawenakisakihitiya hotohare hoka maisaiya aliyakere Enore xema maniya tyaonita — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","— Hoka aliyakereya koxaka inityohaliti haliti hoka tyaonihitiya? Xoana isoahitiyaiya hanityo tyako hoka tyaonihitiya? nexa Nicodemos axa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus nihitiya ihiye: — Aliterexe nomita hihiye: maisaiya onexaiya Isekohaliti Waiyexe xoaha kakoa kaxawenakisakihitita hotohare hoka maisaiya aliyakere haliti Enore xema maniya tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wityo, wexe kaisanihena wiso hoka hatyoaha akereta wisaonita. Nikare Isekohaliti Waiyexe kaisanihena wiso hoka hatyo akereta tehitiya wisaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hiyeta hoka niraini hasemehena: “Maisaiya haliti kaxawenakisakihitiya hotohare hoka maisaiya aliyakere Enore xema maniya tyaonita”, nomi niraihena hoka awa, “Aliyakere ala aokita?” hexa. ");
INSERT INTO pabNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","— Hoholati atyo aliye maniya xamani hoholatya aokowita hoka hatyo maniya atyo hoholaita. Wasemita atyo ehoholala nemahare xakore atyo hoka maisa atyo wawaiyorexe ityoanene, exanene xoaha kakoa. Nikare tyaonita Isekohaliti Waiyexeta kaisanihenerenai tyaonehena hoka. Maisa wawaiyorexe exawenakisakaha kakoa — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","— Hoka aliyakerexe hatyo? nexa Nicodemos axene. ");
INSERT INTO pabNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hoka Jesus nehena: — Xoana Israel yerenai xaotyakisase xakore hiso hoka maisa exe akiti kakoa hawaiyorexe? nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","— Hasemehena niraini: aliterexe nomita hihiye, xoalini tahi nasema nawaiyore ekakoa xoaha hoka noxakaitene xihiye, xakore atyo hoka maisa atyo xityakekore niraini. ");
INSERT INTO pabNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Noxakaita xihiye kalikiniyere wenati tahi, exahe halitinai nawenane tahi akiti harenai xihiye hoka maisa xityakekore niraini. Nikare hoka aliyakereya noxakaihena enokoa tahi xihiye hoka xityakekohena? ");
INSERT INTO pabNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maisa xala hare enokoa xeta xanexe. Hoka Haliti Ityani atyo enokoa terota tyaonita hoka exoaheta waikoa xeta — nexa Jesus. Haxaokakita “Haliti Ityani”, nita. ");
INSERT INTO pabNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","— Toahiya Moisés berekotya owi xaimenekotyaka akerehare atyalihose hiye hoka atityoakisene ekakoare maharexakiti nali. Nikare ite berekotyaha Haliti Ityani atyalihose xaimaholatyaka hiye hoka atityoakisahene ekakoare. ");
INSERT INTO pabNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nikare ite mokahene hoka exema maniya tyaoniterenai maisa wainahitaha hoka tyaonaha mene matyotenehare maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Enore atyo tyotya halitinai awaiyetita hoka haisani haterore axikatya halitinai koni waini enomanaha maheta hoka tyakekohenerenenai maisa wainita maheta hoka tyaonaha mene matyotenehare maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Enore axikatya Haisani halitinai koni iyehenahitene iniyalahare enómaneha nonitata maheta, maisa halitinai xawatya maheta xini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","— Xala xamaniya atyo tyakeko Ityani hoka hatyoiya atyo maisa kaxawatyakita. Hoka xala xamaniya atyo maisa tyakekota hoka hatyoiya atyo waiye xawatyaka, maisa tyakekore haterore Enore Ityani hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Xaokanatyakalati kaoka halitinai ana xakore hoka makaliroti waiyeta enomanaha, iniyalahare nomaseharenai hoka. Hatyo hiyeta waiye xawatyaka aokita Enore. ");
INSERT INTO pabNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iniyalahare tyomiterenai atyo maisa awaiyetyahitaha xaokanatyakalati hoka tekoahitaha enonita, haiyaharenai maisa waiyaha enómaneha iniyalahare aokareha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hoka waiye maniya tyaoniterenai, exahe iraiti aliterexe xema tyaoniterenai atyo awaiyetita xaokanatyakalati, kaokahitaha ehaliya, waiye tyaonahitaha hoka. Enore aokitere akereta tyomahitaha hoka kasani halitinai waiyaha enómaneha aokahitaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hatyo najikinita Jesus xane haxaotyakiraharenai kakoa Judéia koa xeta. Hatyo nali akaiki ferakene tyaona ekakoaha hoka batixatita halitinai. ");
INSERT INTO pabNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João tehitiya batixatita halitinai wenakalati Enom nali, wenakalati Salim haliyita. Hatyo nali kaloxa one hoka. Kahare haliti kaokita enomana hoka batixatyahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","João hatyo xowaka maisa kaberexotyakehenere. ");
INSERT INTO pabNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hatyaoseta haiyaharenai João xaotyakiraharenai iraeha kinatyaxa hatya judeu kakoa: — Enore maniya wisaonita hoka exakere watihita tinihalitinai, exahe halitinai hare — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hatyo najikinita xane iraeha haxekohase João kakoa. — Xaotyakisatiye, xoana hotita etake haliti one Jordãoxa halakoiya nali tyaonitere hikakoa, hirai etahi akiti xoaha. Xoana hotitene? Kalikini batixaita haliti hoka kahare haliti ekoamaniya tyaonita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Hoka João nexa ihiyeha: — Kala Enore kahinaetitene nali. Ekoiya awa Enore kahinaetita wiso hoka maisaiya xoare wisomita. ");
INSERT INTO pabNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Koxaka xasema niraini. “Maisa atyo Enore Kalorexe Aohenere xini natyo. Enaheta maniya atyo Enore axikatya natyo”, nomi xihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xasemehena, wenakakoati xowakehetehena hoka hatyo kaiyanityohenere atyo tyaonita hatyaonero kakoa. Hoka ihinaehare, exako semehena hoka ihalahareta hahinaehare kakoa. Nikarexe natyo notyaonita. Nasemehena Jesus tahi hoka nihalahareta. ");
INSERT INTO pabNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hatyo atyoite ekakoita kalorexe tyaona. Hoka natyo atyoite ekatyahakoreta hoka ekakoita atyoite kiranexe notyaona — nexa João ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","— Enore Ityani atyo enokoata tyoa hoka tyotya halitinai xahehare atyo. Hoka halitinai atyo waikoatarenai hoka waiyakitiya maniya tahi akiti kakoa taita waiyoreta hoka hatyohare tahi takita iraeta. Hoka hatyo enokoatare atyo tyotya halitinai xahehare. ");
INSERT INTO pabNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hatyo atyo xakaita hasemane, hawaiyane xoaha enokoa naliye xakore hoka maisa xala harenai tyakekore exakaini. ");
INSERT INTO pabNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Xala xamani atyo tyakeko Enore Ityani niraine hoka tyakekota tehitiya atyo Enexe Enore niraine. Enomana atyo Enore aliterexe taita iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Enore axikahenere atyo xakai iniraine halitinai hiye. Enore atyo axikatya Isekohaliti Waiyexe enomana maxaimenekotyakahareta hoka masakare kahinaetitene. ");
INSERT INTO pabNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Enexe Enore awaiyetita Haisani hoka maxaixahityakahare mokene, tyotya xoalini hare xekohasehare. ");
INSERT INTO pabNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Xala xamani atyo tyakekota Enore Ityani hoka makamanehareya atyo tyaona. Hoka xala xamaniya atyo maisa tyakekota Ityani hoka maisaiya atyo tyaota menita, Enore ite iniyalahare motene mene. ");
INSERT INTO pabNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Semehena atyo fariseunai, Jesus atyo kahare batixaita haliti, João xahe batixaita haliti. ");
INSERT INTO pabNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Maisa atyo Jesus xini batixaita haliti, exaotyakiraharenai atyo batixatyahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesus ana waiyekehalaka hatyo tahi akiti hoka xaneheta Judéia koa nalita hoka haikoaheta Galiléia koa xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ahoti atyo Samaria koaho jiyita. Hiyeta hoka Jesus hatyoaho jiyeheta. ");
INSERT INTO pabNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jiyehena hoka xane kaoka wenakalati Sicar haliya. Ikinohareha Jacó haisani José ana waikohe isehenere haliyaseta hatyo wenakalati. ");
INSERT INTO pabNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hatyo nali tehitiya Jacó sehenere poço. Kala totahikoa harehena hoka Jesus xane tyoka hatyo poço haliya, kiraharehena haitonane wenekoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hatyaoseta hatya Samaria yolo tyoa hikoa one iya maheta hoka Jesus nexa ihiye: — Xama hisa nomani one hoka notera — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Exowaka Jesus hawawa tyaonita, exaotyakiraharenai koxaka xane wenakalati xeta nakairati iyaha maheta hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","— Hiso atyo judeu hoka natyo atyo Samaria yolo. Nikare hoka xoana hoka haxa natyo one? nexa ohiro Jesus hiye. Maisa judeunai kakoa Samaria yerenai awaiyetyakakoareha hoka nikare irae Jesus kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","— Hawaiyolotaiya Enore xekane kakoa, exahe hawaiyolota tehitiyaiya axitere one hiso kakoa hoka haxene tehitiyaiya one hoka isaiya one homana hoka hatyo oneya hisera hoka menanehaloti hisaona — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hatyaoseta hatyo ohiro nehena Jesus hiye: — Hiyaiya, maisa atyo hikaitiniharexe hoka one hiya haokowita. Poço atyo hateko. Aliyakereya hatyo one menanehalitiya hiyehena? nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","— Wikinohare Jacó atyo seka exe poço. Hatyaoseta hatyo, ityaninai, ijiyetenai, ikirakaharexanai hare terahitaha exe poço akotarexa. Xoana Jacó xahehare hiso haokita? nexa ohiro Jesus niraene nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Hatyaoseta Jesus nehena ihiye: — Xala xamaniya atyo exe akota one tera hoka oinihitiyaiya atyo. ");
INSERT INTO pabNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Hoka one naokitereya atyo tera hoka maisaiya atyo oinihitita. Hatyo one nijitereya atyo maisa tyotehitita enonita. Tyaona meneya atyo ihiye hoka ekakoitaiya atyo menanehaliti tyaona — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","— Xama hisa nomani hatyo one hoka maisa noinihitita, exahe one nomakolalihalo notyaona alita — nexa ohiro ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","— Hiyane hakawiheta hexanene hoka hisoheta ekakoa ali — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","— Maisa nokaiyaniniro — nexa ihiye. — Aliterexe hiraeta, “Maisa nokaiyaniniro”, hita. ");
INSERT INTO pabNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Koxaka 5-hare kakoa hisaona hoka maisa tyaonareha hikakoa. Kalikini hatya tyaonita hikakoa hoka alitere atyo maisa hexanene xini. Aliterexe atyo hiraeta — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","— Kalikini atyo hawaiyekehalakahare nomani. Kala iraiti xakaisasehare hiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","— Wahetakomaniyereharenai kakoha exe tyairi heno hoka iraexatyahitaha Enore ana hoka awaiyetyahitene. Hoka xiso judeunai atyo xita: “Jerusalém nali taita atyo waiye niraexatyaka Enore hiye”, xita — nexa ohiro ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","— Waiye hasemehena niraini: Ekakoitaite maisa exe tyairi henose, exahe Jerusalém nali taita xini kairaexatyaka Enore hiye. (Aliyo xamani wisaonita hoka hatyo nali tehitiya waiye niraexatyaka Enore hiye.) ");
INSERT INTO pabNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Xiso Samaria yerenai atyo maisa xawaiyorexe Enore akiti kakoa hoka wiso judeunai atyo wawaiyore wisaonita Enore akiti kakoa. Hiyaiya, halitinai niyasehareheta atyoite judeunai konita kaotyaka. ");
INSERT INTO pabNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","— Okoi enaose xane hikoahena, xakore hoka koxaka xane hikoa enaose hoka Baba xema maniya tyaoniterenaite awaiyetene haisekohareha kakoita hoka tyaonaha kaiserehare ite exema maniya. Hatyohare hotyalinai Baba aokita haomana. ");
INSERT INTO pabNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Enore atyo Isekohaliti hoka hatyo hiyeta kasani haliti awaiyetene haisekohareha kakoita, exahe tyaona kaiserehare exema maniya aokita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","— Enore Kalorexe Aohenere ite kaotyaka womana. Nasema hatyo akiti, notyakeko xoaha. Kaotyakaite womana hoka tyotya awaiyekehalakahena womana — nexa ohiro Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","— Natyo atyo Enore Kalorexe Aohenere atyo niraeta hikakoa — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hatyaoseta exaotyakiraharenai kaokehetehena enomana hoka waiyaha iniraene ohiro kakoa hoka hakaharetyoaha. Xakore hoka maisa ohiro hekoti axahitaha, xoare xamani aokita ihiye hoka. Exahe tehitiya maisa axahitaha Jesus, xoare hiyeta xamani iraeta ekakoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hatyaoseta hatyo ohiro halakisa haonexa nitini, haikoaheta hawenakala xeta hoka nexa nali tyaoniterenai hiye: ");
INSERT INTO pabNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","— Hatya haliti kaoka nomani poço nali hoka irae nokakoi. Tyotya notyomiterenai kakoa waiyoreta. Xoana Enore Kalorexe Aohenere ala? Wiyala wiyane hatyo nali hoka xiyaiya — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nexa xakai ihiyeha hoka kahare haliti xane hatyo Jesus tyaonitere nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hatyo ohiro xanehenere nase exaotyakiraharenai nexa ihiye: — Xaotyakisatiye, ali nakairati. Witya hikanakairahena — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Xakore atyo hoka nexa: — Ali nonakairi ximawaiyanenehare — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nexa ihiyeha hoka axakakoahenaha hatyo kakoaha: — Xoana koxakala hatya kaoka enomana hoka nakairati isa enomana? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","— Noxaxikatyasehare aokitere akereta notyaohena, exahe nohateni isehenere nomani namiyahena hoka hatyo atyo nakairati akereta nomani. ");
INSERT INTO pabNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Exe tehitiya: xiso atyo exakere xita: “4-li kaimarehena hoka nakairati ihatihena”, xita. Hoka waiyira xiyaiya! Nakairati koxaka ihati, waiye niyakehena. ");
INSERT INTO pabNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Xala xamani atyo xirikotyati hiye hahena hoka kabakatyaka atyoite. Hawenane matyotenehare naheta maniya mokita. Nikare ite exafityasehare ixirikotyasehare xoaha haxawalita ihalahareha. ");
INSERT INTO pabNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hiyaiya, exakere babera iraiti kakoare: Hatya fetene hoka ihatihena hoka hatisa irikohititene. Hatyohare aliterexe. ");
INSERT INTO pabNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","— Xiso atyo maisa xafityare hoka naxikatya xiso xirikotya maheta nakairati xonehenere. Xahetakomaniyereharenai hakaha ali xahitita, hoka xiso atyo xamiyahena ehateneha — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hatyaoseta Samaria yerenai kaokaha enomana. Kahare Samaria yerenai tyakekoha Jesus ohiro xakaini hiyeta. “Tyotya nawenani tahi waiyore hoka xakai nohiye”, nitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hatyaoseta Samaria yerenai xane hikoa Jesus ana hoka irae ekakoa hoka kasani Jesus tyaona enawenakalaha aokahita hoka hatyo hiyeta hinamaki ferakene tyaona ekakoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hatyaoseta Jesus irae ekakoaha hoka tyakekoha Jesus iniraene hiyeta hoka ");
INSERT INTO pabNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","nexaha ohiro hiye: — Kalikini atyo wityakeko. Wisota atyo wasema iniraine, maisa atyo hiyakaini hiyeta taita xini wityakekone. Aliterexe atyo Enore Kalorexe Aohenere, halitinai niyaseheta kaiserehare — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hatyo nali hinamaki ferakene Jesus tyaona hoka hatyaoseta jiyehitiya Samaria koa nalita hoka xane Galiléia koa. ");
INSERT INTO pabNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Hatyota atyo nexa: — Sekorenai semaxemaita iraiti xakaisasehare hoka ewaikohera tyaoniterenai atyo maisa tyakekorene. ");
INSERT INTO pabNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hatyaoseta xane kaoka Galiléia nali hoka nali waikatenai waiye mokahene. Galiléia koa yerenai xane hisehaliti Páscoa xowaka Jerusalém nali hoka exowaka waiyaha Jesus nómanenai hatyo nali hoka hatyo hiyeta waiye mokaha Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hatyaoseta Jesus kaoka Caná nali, one aikawahenere vinhoxa nali xeta haikoaheta. Hatyaoseta hatya xekohaseti tyoa irai Jesus kakoa, ityani hokakita ehanako wenakalati Cafarnaum nali hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Koxaka sema Jesus tahi: — Koxaka tyoheta Judéia koata hoka kaokeheta Galiléia koa — nitere sema hoka xane irae ekakoa, kasani tyoa Cafarnaum nali hoka ityani aiyatelikiheta enomana aokita, ityani hawinitehena hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Hoka Jesus nexa hatyo xekohaseti hiye: — Xiso atyo maomakahare ximawaiyanenehareta maisa xityakekore natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","— Xekohaseti, hisohena rotita waiya aliya hoka nityani waini wimakaokenehareta enomana — nexa ihiye, kaholawaka exánene kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hoka Jesus nexa ihiye: — Hiyanehetehena hihana xeta. Hityanite waiyeheta — nexa ihiye. Nexa ihiye hoka tyakeko Jesus niraene hoka haikoaheta hahana xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Xaneheta Jesus nonita hoka ahotita ahalakoatya hawakaneharenai hoka ewakaneharenai nexaha ihiye: — Hityani waiyeheta. ");
INSERT INTO pabNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hatyaoseta hawakaneharenai axa: — Otene kamai nityani waiyeheta? Hoka ewakaneharenai nexa ihiye: — Kafaka makakoalihena hoka ewatyahisene tyoteheta enonita. ");
INSERT INTO pabNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hatyaoseta enexe Jesus niraine, hatyaose kamaihena hoka iraetere: “Hityanite waiyeheta”, nitere ihiye oteheta hoka tyakeko Jesus haiyanityo haisaninai harenai kakoita. ");
INSERT INTO pabNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus tyoheta Judéia koata hoka Galiléia nali kaokeheta hoka hatyo xoima aiyatelekihetehenere kakoita hinamakihena maomakahare tyomita. ");
INSERT INTO pabNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hatyo najikinita judeunai hisehare tyaohena Jerusalém nali hoka Jesus xane waiya. ");
INSERT INTO pabNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Hatyo nali one nitini kalorexe, 5-hati taose kakoare wahaharexe tehitiya hatyo one haliya. Wenakalati Kalanero Xisoakala aokahitere nali maniya hatyo one nitini kalorexe. Judeunai xako atyo, “Betesda”, nexahitaha hatyo one nitini xaokaka. ");
INSERT INTO pabNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kahare hokakitinai hatyo hati taosenae ako etolijoita one haliya, maxoseharenai, mawaiyehalitinai, maetonaneharenai hare. Tyaonahitaha atyahahitaha one watyalisaka xahita. ");
INSERT INTO pabNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Haiya xowaka anjo exoita hoka one watyalita. Hatyo najikinita xala hotohare xamani exoa exaiya hoka kinatereheta. ");
INSERT INTO pabNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Exowakita hatya haliti hatyo nali etolijoita, 38-terehokoanehena hokakita. ");
INSERT INTO pabNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Owene etolijoita hoka Jesus waiyene hoka otita wahehena ehokakene hoka nexa ihiye: — Xoana hikinatereheta haokowita? nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hoka nehena Jesus hiye: — Xekohaseti, maisa xala hare mokare natyo onexa, one kawatyalisakehena hoka. Nexoa xakore naokowita exaiya hoka nahitita hatya hokakiti exoita exaiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hatyaoseta Jesus nexa ihiye: — Hatityoahetehena hoka hiyetolisoakala hiyehetehena hoka hatohetehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nexa taita ihiye hoka exowakita hatyo haliti kinatereheta rotita, iyeheta haxetolisoakala, xaneheta. Sábado xowaka aetonakihetene. ");
INSERT INTO pabNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hiyeta hoka judeunai nityohalitiranai nexaha ihiye: — Kalikini sábado, mahateniti ferakene. Mahateniti ferakene hoka awa atyo hakolatya hiyetolisoakala. Wiyaotyakisakaho hiyeta hoka maisa waiyeta — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hoka nehena ihiyeha: — Xasemehena, noxajiyakisase atyo nexa nohiye: “Hiyehetehena hiyetolisoakala hoka hatohetehena”, nexa nohiye. ");
INSERT INTO pabNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","— Xala nikare irae hikakoa hoka nikare hisaona? nexa axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hoka maisa atyo Jesus nexare semita. Jesus atyo koxaka xaneheta hatyo nalita, kahare haliti tyaonita hatyo akiti hoka. — Maisa nasemita noxajiyakisase nexare — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wahasehena hoka Jesus tyoa isoahitiya Iraexatyakalati Hanako hoka ahalakoatya hatyo haxajiyakirahare hoka nehena ihiye: — Hasemehena, kalikini atyo hawaiyeheta. Awa atyo iniyalahare hisomehitiya, waiya aliya hoka exahehena hisaonita — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nexa Jesus ihiye hoka hatyaoseta hikoaheta hoka xakaini judeunai nityohalitiranai hiye: — Jesus nika aiyatelikiheta natyo — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hatyaoseta Jesus hiye ehareha, sábado xowaka haliti aiyatelikiheta hoka hatyo hiyeta ehareha ihiye, aisahene aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ehareha hoka Jesus nehena ihiyeha: — Baba atyo hakita kalikini kijiya hoka natyo tehitiya nahakita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hatyo iraetere hiyeta judeunai nityohalitiranai aisahene aokowiha. Maisa exaotyakisakahoha xema tyaonita sábado ferakenehena, exahe Enore Ityani aokowita. Exahe Enore hákakoanehare aokowita nikare iraeta hoka maisa waiyeta enomanaha. Hatyo xemere aisahene aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hatyaoseta Jesus nehena: — Xasemehena niraini. Enore Ityani taitaiya atyo hoka maisaiya atyo xoare hare tyomita. Hanexe Enore nómane waiyehena hoka hatyo akereta Ityani tyomita. Enexe tyomehena hotohare hoka enajikini maniya Ityani tehitiya tyomihitita Hanexe tyomitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Enexe atyo awaitita Haisani hoka tyotya háomanenai hotikijita enomana. Hotikisaite exaheharexe Haisani ana hoka hatyoharenai ite Ityani tyomehena hoka xahakaharetyoaite. ");
INSERT INTO pabNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","— Hiyaiya, Enexe ekasekihetehena kamatinai hoka kasehenahititaha. Nikare tehitiya Ityani ekasekiheta aokowihenere kamati ekasekihitita. ");
INSERT INTO pabNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Enexe maisa sema aokowita halitinai nómane tahi. Kasani Ityani sema halitinai nómane tahi hoka tyaonahiterene akereta mokahene aoka Enexe. ");
INSERT INTO pabNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kasani halitinai aiminisaha Ityani aokita Enexe kaxaiminisakitere akereta. Xala xamani atyo maisa aiminijita Ityani hoka maisa tehitiya atyo Enexe aiminisare. Hiyaiya, hatyo atyo axikatya Haisani. ");
INSERT INTO pabNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","— Aliterexe nomita xihiye, xala xamani atyo semaxemaita niraini hoka tyakekota tehitiya atyo noxaxikatyasehare hoka makamanehare atyo tyaona hoka maisaiya atyo kamawenekoaretyakita. Koxaka atyo hakamaneta kaseheta hoka menanehaliti tyaona. ");
INSERT INTO pabNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aliterexe nomita xihiye, enaose xane hikoahena, koxaka enaose xane hikoa. Maika ite kamatinai semehenaha Ityani xako. Semehenahaite hoka kasehetehenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Enexe atyo tyaota menita hoka ihiyeta halitinae kaseta tyaonita. Haisani nikare tehitiya moka hoka Ityani hiyeta halitinai kaseta tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Enexe iyateliti isa Haisani ana axalisa maheta halitinai hoka tyomahitere tahi sema hoka nikareta mokahene maheta. Hiyaiya, Haliti Ityani tehitiya atyo hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","— Awa atyo exeharenai hiyeta xahakaharetyoahena: ekakoitaite enaose xane hikoahena hoka tyotya kamatinai semehena Enore Ityani xako ");
INSERT INTO pabNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hoka kamatinae kasehenahitehenaha haxawatyakalaha akota. Hatyaosetaite waiye tyomehenerenai atyoite menanehaliti tyaonaha hoka iniyalahare tyomehenerenai atyoite kaxawatyakehena — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","— Maisaiya atyo nowawiharenai hoka xoare hare notyomita. Baba niraine nasemita hoka nasemitere akereta namokita haliti. Tota maniya taita nahekoita halitinai kakoa hoka tyaonahitere akereta namokahitene. Baba Enore xaokalita nikare notyaonita, maisa noxaokalita xini. ");
INSERT INTO pabNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","— Nowawiya niraeta notahi hoka maisaiya xoare maheta xityakekota niraeni. ");
INSERT INTO pabNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Xakore hoka hatya tehitiya atyo xakai notahi akiti. Hatyo iraihena hoka maisa atyo maoseraita xini. ");
INSERT INTO pabNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hiyaiya, xaxikatya haliti João ana axene maheta. Axahene hoka João xakai notahi akiti ihiyeha hoka maisa maoseratyahitene xini. ");
INSERT INTO pabNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Maisaiya xoare maheta halitinai iraeha notahi nokatyakekotyaki maheta xakore hoka noxakaita exe iraiti waiyexe xihiye xikaiyakeheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","João atyo xaokanatyakalati. Takoa hoka aokanaitere akereta tyaonita halitinai koni, aotyakisahitene hoka. Maisa waha tyaonare xinekoni hoka exowaka xihalahare exaotyakira kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","— João xakai notahi akiti halitinai hiye tyakekoha maheta natyo. Hoka exe tehitiya João xahehare nawaiye: maika notyomitere hiyeta xityakeko natyo. Baba axikatya natyo ehatene notyoma maheta. Maika xityakekohena natyo nománinai hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","— Noxaxikatyasehare Baba tehitiya irae notahi akiti, tyakeko natyo hoka. Hoka xiso atyo maisa xasemare exako, exahe xiyaiyarene. ");
INSERT INTO pabNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Maisa iniraine tyaonita xikakoa. Xiyaiya, maisa natyo exaxikalahare xityakekota hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","— Babera Iraiti Waiyexe kakoare xakaixarita minita. Exema maniya xisaona hoka ximakamanehare xisaona xaokita hoka. Xakore hoka notahi atyo hatyo Iraiti Waiyexe nanekoa xairatyoare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Xakore atyo hoka maisa xisaona xaokowiye nokoamaniyi. Xisaonaiya nokoamaniyi hoka ximakamanehariya xisaona — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","— Maisa atyo halitinai aeroretyaha natyo naokare. ");
INSERT INTO pabNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Hiyaiya, notita atyo xiso, maisa atyo Enore xawaityare kaisere, maisa exema maniya xisaonare. ");
INSERT INTO pabNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Baba niraine kakoare atyo natyo xakore hoka maisa xaokita natyo xomana. Hatyaiya kaoka xomana haxaokalita hoka xawaiyeteniya. ");
INSERT INTO pabNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Komitainiya maisa aliyakere Enore xema maniya xisaonita. Kasani halitinai ihalahareha xikakoa xaokita, komita maisa Enore ihalahareta xikakoa xaokare. ");
INSERT INTO pabNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","— Xasemehena, maisaiya niraeharitita xiso Baba hiye. Xawaiyetita hatyo Moisés xaotyakira xakore hoka Moisés atyoite iraeharetya xiso. ");
INSERT INTO pabNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Hiyaiya, Moisés xairatya notahi akiti. Xityakekoreya Moisés xaotyakira hoka xityakeko tehitiyaiya natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Maisaiya xityakekota Moisés xairala hoka aliyakereya xityakekohena niraini? nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hatyo najikinita Jesus imahotyoa Galiléia xa. Tiberíades xa tehitiya enexare. ");
INSERT INTO pabNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kahare haliti xane exema, koxaka waiyaha enómane maomakahare hokakiterenai xaiyatelikisakeheta hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Xane imahotyoa halakoiya hoka Jesus kakoha tyairi henose, xane tyoka haxaotyakiraharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hatyo xowaka okoi judeunai hisehare Páscoa tyaohena. ");
INSERT INTO pabNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus atyo waiyehena, hisoaka atyo haliti tyoaha exema hoka nehena Filipe hiye: — Aliyakotaite wiyehena nakairati tyotya exe halitinai ana? nexa axene. ");
INSERT INTO pabNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Koxaka atyo Jesus waiyoreta ityaisakaha kakoa hoka Filipe hasakaharetya aokowita hoka nikare iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hoka Filipe nehena ihiye: — Owane, aliyakere xamani. Kala 200-olohokose kakoa nakairati wiya hoka wisa enomanaha hoka maisaiya kehexahitene — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hatyaoseta exaotyakirahare André, Simão Pedro ximarene iraehena: ");
INSERT INTO pabNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","— Owene hatya xoima 5-tohase kolatita nakairati cevadahe nomakere, hinama kohase xoaha kakoare. Hoka wiseneya halitinai ana hoka maisaiya kehexahitene, hisoakaha hoka — nexa André. ");
INSERT INTO pabNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","— Xiraihena halitinai hiye hoka tyokaha waikoa — nexa Jesus haxaotyakiraharenai hiye. Hatyo nali kalokoare ime koa. Hatyaoseta exaotyakiraharenai irae ekakoaha hoka tyotya tyokaha. Kala komita 5.000-hare haliti. ");
INSERT INTO pabNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Hatyaoseta isaha xoima nakaira Jesus ana hoka iraexatya: — Ehekore nakairati hisa womana, Abá — nexa iraexatya Enore hiye hoka irakene haxaotyakiraharenai ana hoka exaotyakiraharenai irakene tyokiterenai ana. Nikareta kohase irahitiya enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tyotya kanakaira, fakatehareha, kamawaneha. Kanakaira, fakatehareha hoka Jesus nehena haxaotyakiraharenai hiye: — Ximexeheta enakairaha mawane hoka waiye xamoheta hoka maisa mitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nexa hoka imexehenahitene hoka 12-te koho ako kaise mokaha. 5-tohase nakairati xakore hoka 12-te kaise mokaha emawaneha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hatyo Jesus nakairati aerorititere halitinai waiyaha hoka nexaha: — Iraiti xakaisasehare kalorexe kaotyakehenaite haliti koni aoka koxakereharenai. Kala maisa hoka exe Jesus terota hatyo kalorexe — nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hatyaoseta Jesus exekohaseha kalorexe tyaohena aokahitaha hoka aiyateretyoaha exahita, kalorexe tyaohena maheta. Xakore hoka Jesus sema hatyo tahi hoka xanehitiya hawawaharenai enonitaha tyairi henose xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Maka hoka Jesus xaotyakiraharenai aihetehena onexa haliya, ");
INSERT INTO pabNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","isoahenahitaha kanowako hoka imahotyoahenahitaha hoka Cafarnaum maniya xanehenahitaha. Koxaka makaliro xakore hoka Jesus atyo makaokeneta enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xanehenahititaha onexa hoka kinatyawiniti kaoka enomanaha, hoholasekoatyahene, one ainakiyatya. ");
INSERT INTO pabNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kala exaotyakiraharenai sekohetehena, nekesexehetehena hoka, waiyehenaha atyo, owehena Jesus tyohitita, oneheno atyo tonita. Tyoa kaokehetehena kanowa ana hoka mairaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","— Awa atyo ximaira, natyo taore — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hatyaoseta ihalahareha, ekakohakihenahitene kanowako. Hatyaoseta jiyehenahitiyaha hoka haxerore xane kaokaha xane aokowitere nali. ");
INSERT INTO pabNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kamaetali hoka hatyo haliti jikotiterenai tawehena Jesus xahita. Nali haterore kanowa hoka koxaka hatyoako exaotyakiraharenai xanehenahitaha maxekohasehareta hoka motya hatyo nali aokahitaha hoka tawehenaha exahita. ");
INSERT INTO pabNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hatyaoseta wenakalati Tiberíades nalitare tyoa kaokehena kanowanai kakoa, tyoa takoaha hatyo halitinai kanakairihenere nali, Jesus iraexahenere Enore hiye najikinita kanakairihenahere nali. ");
INSERT INTO pabNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Maisa waiyehenahititaha Jesus, exahe exaotyakiraharenai hoka hatyaoseta kanowanai ako tyokaha hoka xanehenahitiya Cafarnaum nali xeta tawehenahitene maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Imahotyoaha hoka xane kaokehenahitaha Jesus halakoiya maniya. — Xaotyakisatiye, xoana xowaka ali hikaoka? nexaha ihiye kaokehenahitene hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Hoka Jesus nehena ihiyeha: — Xasemehena, kafaka xikanakaira xifakatehare hoka hatyo hiyeta kalikini xatawa natyo. Maisa atyo waiyekehalakitere maomakahare notyomehenere hiyeta xini xatawihitita natyo — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","— Awa atyo nakairati kaiyalaharetatere xema xahaka. Exahe kalore xikanakaira xakore hoka haxowaka atyoite xiwaini. Maika menanehaliti nakaira xema xahaka. Halitiya kanakairene hoka makamanehareya tyaona. Haliti Ityani ijita hatyo nakairati xomana. Enore isa iyateliti enomana nikare tyaona maheta — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","— Hoka xoare wisoma aokita Enore? nexa axaha Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","— Xityakeko exaxikalahare aokita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hoka nexaha ihiye: — Hoka hiso atyo xoareya hisoma hoka wiyaiya hoka wityakeko hiso? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","— Wahetakomaniyerenai atyo kanakaira nakairati maná aokahitere maharexakiti nali. Hatyo tahi akiti kaxairatyaka Iraiti Waiyexe nanekoa exakere: Enore isa enomanaha nakairati enokoata hoka kanakairaha. — Hoka hisoiya atyo xoare hisoma hoka wityakeko hiso? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hoka Jesus nehena ihiyeha: — Xasemehena, Moisés isa nakairati enokoatare xomana xakore atyo hoka maisa atyo menanehaliti nakaira xini. Nakairati enokoatare ekaiserehare atyo Baba ijita. ");
INSERT INTO pabNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Enore xaxikalahare atyo enalita exoa xomana hoka hatyo atyo nakairati. Halitinaiya tyaona exema maniya hoka menanehalitiya tyaonaha — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","— Xekohaseti, hiseta menira womana hatyo nakairati hiyeta — nexaha axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hoka Jesus nehena ihiyeha: — Natyo atyo nakairati enokoatare. Xala xamaniya atyo tyaona noximi hoka maisaiya atyo nakihitita, maisaiya oinihitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","— Koxaka nomi xihiye: Xiyaita xakore natyo hoka maisa xityakekore natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Baba Enore ijita halitinai nomani hoka tyaonahaite noximi maniya. Tyaonahaiya noximi maniya hoka maisaiya naxanekihenahititene haware. ");
INSERT INTO pabNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hiyaiya, Baba atyo axikatya natyo hoka notyoa enokoata notyoma maheta aokitereharenai. Exaokalita nikare notyaonita, maisa noxaokalita xini. ");
INSERT INTO pabNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","— Baba noxaxikatyasehare atyo kasani nokoamaniye mohenerenai nokaxaiko waiye hoka maisa hatya hekoti meta nonitita aoka. Wainihenaha hoka miyanitiye xowakehenaite nekasekihenahitene aoka. ");
INSERT INTO pabNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kasani tyotya noximi maniya tyaohenerenai makamanehare tyaohenaha aoka noxaxikatyasehare. Exahe wainihenaha hoka nekasekihenahitenite miyanitiye xowakehena — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nexa Jesus irae hoka judeunai sema hatyo iniraine hoka maisa waiyeta ihiyeha. — Xoana hoka exakere iraeta: “Natyo atyo nakairati enokoatare”, nita? nexaha weraweratyakakoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","— Xoana, exe atyo José ityani Jesus, aliterexe? Enexe inityo xoaha atyo wiyaiyanehare. Xoana hoka, “Enokoata nexoa” nita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hoka Jesus nehena ihiyeha: — Xahalakihena xiwerawerala notahi. ");
INSERT INTO pabNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Baba axikatya natyo hoka tyaona noximi aohenerenai taita atyoite tyaona noximi maniya. Maisaiya aokahitene nomani hoka maisaiya aliyakere tyaonahitaha noximi maniya. Hoka miyanitiye ferakenehenaite hoka nekasekihenahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Iraiti xakaisaseharenai xairala nanekoa exakerexe xairatyoare tyaonita: Enore ite tyotya aotyakisahene. — Hoka xalanai xamani atyo semaxemaita Baba niraine hoka ihiyeta atyo waiyorahitaha hoka tyaonahitaha noximi maniya. ");
INSERT INTO pabNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Maisa atyo xala hare waiyare Baba, enalita tyohenere taita atyo waiyitene. ");
INSERT INTO pabNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aliterexe nomita xihiye, xala xamaniya atyo tyakeko natyo hoka tyaona mene matyotenehare. ");
INSERT INTO pabNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Natyo atyo nakairati enokoatare. Halitiya kanakairene hoka tyaona meneya matyotenehare. ");
INSERT INTO pabNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xahetakomaniyerenai ene atyo kanakairaha nakairati maná maharexakiti nali xakore hoka wainiha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hoka xala xamaniya atyo kanakaira nakairati kaiserehare exoahenere enokoata hoka maisaiya atyo wainita. ");
INSERT INTO pabNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Natyo atyo nakairati enokoatare. Xala xamaniya exe nakairati hiyeta kanakaira hoka tyaona meneya atyo. Noháre atyo tyotya halitinai anere enakairaha maheta. Halitiya kanakairene hoka tyaona meneya, maisaiya wainita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nexa Jesus irae hoka judeunai hatyaoseta kinatyaxa iraekakoaha: — Aliyakereya hoka exe haliti tyaisa halitinai haháre kakoa aokita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hatyaoseta Jesus nihitiya ihiyeha: — Aliterexe nomita xihiye, maisaiya xanijita Haliti Ityani nete, exahe xiserita itimalaxa hoka maisaiya xisaota menita matyotenehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","— Hoka xala xamani atyo nete nisa, notimalaxi tera hoka tyaona mene matyotenehare. Eháre wainihena hoka miyanitiye xowakehenaite hoka nekasekihetene. ");
INSERT INTO pabNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Noháre atyo nakairati kaiserehare, exahe notimalaxi atyo erati kaiserehare. ");
INSERT INTO pabNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xala xamani atyo nete nijita, notimalaxi terita xoaha hoka tyaonita atyo nokakoi, exahe natyo tehitiya atyo notyaonita tehitiya ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","— Baba tyaota menitere hiyeta atyo maisa nowainiye. Hatyo atyo axikatya natyo. Nikareta tehitiya xala xamani nisa nete hoka maisaiya wainita, tyaona meneya. ");
INSERT INTO pabNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Exe nakairati atyo exoa enokoata. Maisa atyo xahetakomaniyerenai ene kanakairehenere maharexakiti akerexe xini. Hatyonai atyo kanakairaha hoka enajikinita atyo wainiha. Hoka xala xamani atyo exe nakairati naokitere kanakaira hoka tyaona meneya atyo matyotenehare — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus hatahi iraeta ihiyeha Cafarnaum nali, xahohisakoatyakalati hanako aotyakisahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hoka kahare Jesus xema tyaonitereharenai sema hatyo iniraine hoka maisa waiyeta ihiyeha. — Exaotyakiraho atyo howitihare! Xalaiya tyaohena hatyoharaho? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hoka Jesus atyo otita eweraweralaha hoka nehena: — Xoana xahalakihena xawenane nokoamaniye niraini hiyeta? ");
INSERT INTO pabNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hoka Haliti Ityani haikoahetehena xihaotita hetati tyaonitere nali enokoa xeta hoka xoanaiya xisaohena? ");
INSERT INTO pabNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Isekohaliti Waiyexe aiyatelikijita halitinai, tyaona mene matyotenehare maheta. Hawawaiya haliti hoka maisaiya aliyakere tyaota menita. Xasemaxematya niraini xikakoa hoka ekakoitaite menanehaliti xisaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","— Haiyaharenai atyo xinekonitare niraini tyakeko xakore hoka haiyaharenai atyo maisa tyakekore — nexa Jesus ihiyeha. Jesus atyo enaheta komaniyita otita matyakekotiterenai, exahe otita hamatawatyasehare xoaha hoka: — Haiyaharenai atyo maisa tyakekore niraini — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","— Hatyo hiyeta nomita xihiye: Baba axikatya natyo hoka tyaona noximi aohenerenai taita atyoite tyaona noximi maniya. Maisaiya aokahitene nomani hoka maisaiya aliyakere tyaonahitaha noximi maniya — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hatyo najikinita kahare exema tyaoniterenai haikoaheta enonita, xanehenahitaha hawenakalaha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hatyaoseta 12-hare haxaotyakiraharenai axa: — Xoana xiso tehitiya xiyanehetehena xaokowita? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","— Maisaiya — nexa Simão Pedro. — Wahalakisaiya hiso hoka xala xemaiya wisaonehena? Hiraine xemaiya wisaona hoka ekakoitaiya wimakamanehare wisaona. ");
INSERT INTO pabNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wiso atyo wityakekota exahe waiyekehalakita atyo womana. Enore xaxikalahare waiyexe atyo waokita hiso — nexa Pedro Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hoka Jesus nihitiya ihiyeha: — Xiso 12-hare nomaniye naoka xiso hoka hatya xinekonitare atyo tihanare — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas xaokaka, Simão Iscariotes ityani xaokaka nikareta Jesus. Judas exaotyakiraharenai konitare xakore hoka hatyo najikinitaiya matawahena Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hatyo najikinita Jesus xane Galiléia koa tonakonisahitene. Maisa Judéia koa xane aokowihitita, naliyerenai judeunai nityohalitiranai aisene aokowiyahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Exowaka okoi judeunai hisehare aose xane hikoahena. Hatyo hisehaliti xowakehena hoka judeunai hatirisako tyaonahitaha hoka “Hatirisako tyaoniterenai hisehare”, nexaha exaokaka. ");
INSERT INTO pabNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hatyaoseta Jesus ximarenenai nehenaha ihiye: — Hiyanehena Judéia koa maniya hoka hisomitereharenai hisomehena, hiyema tyaoniterenai hománe waiyaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Hiyaiya, hatya haliti tahi waiyekehalaka kasemaka aohena hoka maisa hameteneta tyomare. Aliterexe atyo hisomita hoka hiyane ehaotiha hisomehena hoka tyotyaha waiyaha — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iximarenenai kakoita matyakekotitene hoka nikare iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hoka Jesus nexa ihiyeha: — Maisa atyo xane hikoahenere noxanini aose. Hoka xiso xomana atyo haxowaketere. ");
INSERT INTO pabNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Maisaiya atyo matyakekoneharenai ehareta xihiye. Hoka nohiye atyo eharahitaha niraini xemere. “Xoana hoka iniyalahare xisomita?” nomihena ihiyeha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","— Xiyane atyo xiyaiye hena hisehaliti. Hoka maisaiya atyo kalikini natyo noxanita, maisa terota atyo xane hikoahenere noxanini aose — nexa Jesus haximarenenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nexa ihiyeha hoka hekota Jesus Galiléia koa nali. ");
INSERT INTO pabNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hatyaoseta iximarenenai xaneha waiyaha maheta hisehaliti. Xaneha hoka hatyo najikinita Jesus tehitiya xane. Xane xakore atyo hoka hameteneta atyo xane, maisa atyo halitinai semahitaha exánene. ");
INSERT INTO pabNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hatyaoseta judeunai nityohalitiranai tawehenene hatyo hisehaliti koa nali. — Xoana koxaka kaoka ali? nexa axaha hatyo nali tyaoniterenai. ");
INSERT INTO pabNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hisehaliti koa nali tyaoniterenai kahare iraehenaha etahi akiti. Haiyanai atyo nexa exaokaka: — Hatyo atyo waiye — nexahitaha. Hoka haiyanai atyo nexa: — Hatyo atyo maoseratita wiso — nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kahare iraeha etahi akiti hoka maisa atyo tyotya haliti haoti xini, mairahitaha judeunai nityohalitiranai hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hatyaoseta koxaka 4-ki ferakenehena ihisehareha tyaonita hoka Jesus xane isoa Iraexatyakalati Hanako hoka aotyakihenahene. ");
INSERT INTO pabNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aotyakisahitene hoka judeunai semahitaha exaotyakira hoka nexahitaha: — Aliyakerala hoka waiyore iraeta, maisa xakore waha kaxaotyakisakita hoka? nexa hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hoka Jesus nehena ihiyeha: — Maisa atyo noxaotyakiri xini, noxaxikatyasehare Enore xaotyakira atyo hoka nikareta naotyakijita. ");
INSERT INTO pabNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xala xamani atyo Enore aokitere akereta tyoma aokowita hoka ekakoita ite waiyore noxaotyakiri kakoa hoka nehenaite: “Hatyo exaotyakira atyo Enore xaotyakira terota, maisa haxaotyakira kakoa xini aotyakijita wiso”. ");
INSERT INTO pabNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hatya halitiya atyo iraeta hatahita hoka hatyota atyo haxaexakerityaka aokita. Hoka haxaxikatyasehare xaexakerityakaiya aokita hoka hatyoiya atyo tota maniya tyaonita, maisaiya atyo maoseraita xini. ");
INSERT INTO pabNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","— Moisés halakisa haxaotyakira xomana xisaona maheta exema maniya xakore hoka maisa atyo xisaonare exema. Xisaonitaiya exema maniya hoka maisaiya xaisa xaokowiye natyo. Xoana hoka nikareta xiso? nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","— Xala aisa aokowita hiso? Kala tihanare tyaonita hikakoa hoka nikare hiraeta — nexa halitinai iniraene nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hatyaoseta Jesus nehena: — Kafaka hatya haliti hokakita hoka naiyatelikihetene hoka xityotya xahakaharetyoa. ");
INSERT INTO pabNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","— Xiso atyo enamokose tyaohena hoka enomanere milihe xaikotita Moisés xaotyakira akereta, sábado ferakenehena hoka. Maisa hatyo akiti Moisés xowaka rotita xini nikare kaomaka. Enahetakomaniyerenai hotohare nikare tyaonita hoka Moisés xairahetene babera koa. ");
INSERT INTO pabNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mahateniti ferakene xakore atyo hoka Moisés niraene xema sábado ferakenehena hoka enamokose nomanere milihe xaikotita hoka waiyeta xihiye. Hoka xoanere hoka xehareta nohiye sábado xowaka naiyatelikihetehena haliti hoka? ");
INSERT INTO pabNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Waiyehena nikare xahekotya. Waiye maniya xamohena xiyahekola — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hatyaoseta haiyanai Jerusalém yerenai nehena: — Xoana aliterexe exe haliti aisaha aokowiyahitaha? ");
INSERT INTO pabNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hiyaiya, wityotya wihaoti iraeta hoka maisa winityohalitiranai xoare nexareha ihiye, maisa mahokoanityareha iniraine. Xoana Enore Kalorexe Aohenere tehitiyala aokahitene? nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","— Enore Kalorexe Aohenere ite tyohena hoka maisaite waiyekehalakita womana hetati kaotyakehenere aose kakoa. Xakore hoka exe haliti nawenane aose atyo waiyekehalakita womana — nexa iraekakoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hatyaoseta Jesus aotyakijita Iraexatyakalati Hanako hoka nexa: — Xoana aliterexe xiyaiyanehare natyo, exahe nawenani aose hoka waiyekehalakita xomana? Hatya axikatya natyo haliti koni, maisa noxaokalita xini nokaotyaki haliti koni. Noxaxikatyasehare atyo maisa maoseratyaliye, xakore hoka maisa atyo xiyaiyanehare xini. ");
INSERT INTO pabNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hoka natyo atyo nowaiyitene, ehaliyata atyo notyoa, exaxikalahare atyo natyo hoka — nexa Jesus kinatyaxa iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hatyaoseta otokaha xakore Jesus aokowiha hoka maisa xala harenai otokarene, maisa exotokakaose xane hikoahenere hoka maisa otokahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kahare haiyaharenai nali tyaoniterenai tyakekoha Jesus hoka nexaha: — Exe haliti kahare tyomita maomakahare wityakekone maheta. Xoana Enore Kalorexe Aohenere kaite tyohena hoka exe xahehare kaite tyomehena maomakahare? nexa axakakoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseunai sema halitinai niraene Jesus tahi akiti hoka hatyo hiyeta axikatyaha sorarenai otokahene maheta. Sacerdotenai xekohasenai tehitiya kahinaetyahene hoka sorarenai axikatyaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hoka Jesus nehena: — Iniraite notyaohitiya xikakoa hoka hatyohekotaite noxaniheta noxaxikatyasehare nali. ");
INSERT INTO pabNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Noxanihetaite hoka xatawaite natyo hoka maisaiya xikaokehitita natyo. Hoka xisoiya atyo maisa aliyakere xiyaneta noxanihenere nali — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hatyaoseta judeunai nexa iraekakoahenaha: — Aliyakoiyala xane hoka maisa wikaokehititene? Xoana sekoala xanehena Grécia koa nali hoka judeunai tyaonahitere nali ala tyaohena? Xoana Grécia yerenai tehitiyalaite aotyakihena? ");
INSERT INTO pabNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Xoana ala hoka nikare iraeta: “Noxanihetaite hoka xatawaite natyo hoka maisaiya xikaokehitita natyo. Hoka xisoiya atyo maisa aliyakere xiyaneta noxanihenere nali”, nita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Miyanitiye hisehaliti ferakene xowakehena kahare haliti hohisakoita hoka Jesus tityoa enekonyaha hoka kinatyaxa iraihena: — Xala xamani oinita hoka tyoa nomani hoka nisa enomana one hoka tera — nexa. “One”, nitere atyo Isekohaliti Waiyexe xaokaka nikare iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","— Xala xamani tyakeko natyo hoka one ite kahare hikoa ihiyeta hoka tyaona mene matyotenehare Iraiti Waiyexe nanekoa iraetere akereta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus atyo Isekohaliti Waiyexe xaokaka iraeta. Exowakita maisa Isekohaliti Waiyexe kaokare tyakekohenerenai ana. Hoka Jesus waini hoka kaseheta hoka kalorexe tyaona hotohare hoka hatyaosetaiya Isekohaliti Waiyexe kaoka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nexa hoka kahare naliyerenai semaha iniraine hoka nehenaha: — Aliterexe exe haliti atyo iraiti xakaisasehare Moisés aokitere — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Haiyanai atyo nexaha: — Exe atyo Enore Kalorexe Aohenere. Hoka haiyanai atyo nexaha: — Xoana Enore Kalorexe Aohenere alaite Galiléia koata tyoa? ");
INSERT INTO pabNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Exakere Iraiti Waiyexe nanekoa xairatyoare tyaonita: Enore Kalorexe Aohenere atyoite Davi jikolahare. Belém nali atyoite tyaona Davi tyaonitere nali — nexaha hahinaeharenai niraene nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hatyaoseta hahekore xakini ahekotya Jesus tahi. ");
INSERT INTO pabNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Haiyanai atyo otokaha Jesus aokowiha xakore hoka maisa otokahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hatyaoseta sorarenai haikoaheta fariseunai, sacerdote xekohasenai tyaonahitere nali. Haikoaheta hoka exekohasenai axahene: — Xoana hoka maisa xotokitene hoka ali xanolokitene? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hoka sorarenai nexaha haxekohaseha hiye: — Maisa xala harenai hatyo haliti iraehenere akere iraexe — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","— Xoana xiso tehitiya emaoserala xema xisaona? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","— Xoana haiyaharenai kalorexenai, fariseunai xoaha tyakeko iniraine? Xiyaiya, maisa hatya hekoti tyakekore. ");
INSERT INTO pabNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Alitere exe haliti hisoakere tyakekotene. Xakore atyo hoka exe halitinai maisa waiyorexeha wiyaotyakisakaho kakoa hoka maisa waiyexeha Enore ana — nexaha sorarenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hatyaoseta Nicodemos nexarexe, makiya xane iraehenere Jesus kakoa, nehena ihiyeha: ");
INSERT INTO pabNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","— Wiyaotyakisakaho hiyeta atyo maisa haliti waberexotyare rota. Wasema hotohare atyo iniraene, exahe etahi akiti hoka waberexowita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","— Xoana hiso tehitiya Galiléia koatare? Hiyane hiyaiya babera iraiti xakaisaseharenai niraine kakoare. Maisa iraiti xakaisasehare kaotyakita Galiléia koata — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nexa hoka hatyaoseta iniraikakoaneha tyotya hoka xanehenahitaha hahanaha nihatyaka. ");
INSERT INTO pabNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hatyo najikinita Jesus xane Oliveiras tyairiya heno. ");
INSERT INTO pabNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kamaetali makiyita haikoaheta Iraexatyakalati Hana nali hoka kahare haliti hohisakoa ehaliya exaotyakira semaha maheta. Jesus tyoka hoka aotyakisahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hatyaoseta judeunai xaotyakiraho kakoa waiyoreterenai fariseunai xoaha nolokaha hatya ohiro enomana. Hatya ena watyalitene hoka waiyahene hoka otokahene hoka tyoaha ekakoa Jesus ana. Tyoa kaokaha ekakoa hoka mokahene halitinai nenekesene ");
INSERT INTO pabNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","hoka nehenaha Jesus hiye: — Xaotyakisatiye, exe ohiro wotoka, hatya ena watyalitene hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Exakerexe atyo Moisés xaotyakiraho aotyakisa wiso: “Maikaite nikare tyaoniterehalonai sehali kakoa kamokotyaka”. Nikare Moisés xairatya hoka hiso atyoite xoare hehena etahi? nexa axaha Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nexa iraeha ihiye hasakaharetyahene maheta, kasani haware irae Moisés niraine nonita aokowiyahitaha hoka eheno maniya xawatyahene aokowiyahitaha hoka. Nexaha ihiye hoka Jesus meholokoa hoka xairatya hakahihi kakoa waikoa. ");
INSERT INTO pabNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hekota axahitene hoka Jesus aototaharetyoa hoka nehena ihiyeha: — Maika hatya maomanehare iniyalahare hotohare mokotya sehali kakoa exe ohiro — nexa hoka ");
INSERT INTO pabNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","meholokoahitiya waikoa hoka xairahitiya. ");
INSERT INTO pabNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hatyo iniraine semaha hoka hikoahenahitaha hatya xakini, maisa xala hare iniyalahare maomanehare aka hoka. Inityohalitiranaiha hotohare hikoaheta, jikiniti maniya tyotya hikoahenahita. Ekakoita Jesus hawawitehena. Hatyo ohiro tehitiya hekota tityoita hatyo nali. ");
INSERT INTO pabNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hatyaoseta Jesus aototaharetyoaheta hoka waiyehena atyo, maisa xala hare akeheta hoka nehena hatyo ohiro hiye: — Aliyo hiraeharetyasenai? Xoana maisa hatya hekoti hiyaisaka aokare? nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hoka nexa Jesus hiye: — Maisa xala hare aka, Xekohaseti. Jesus nihitiya ihiye: — Natyo tehitiya atyo maisa hiyaisaka naokita. Kotare hiyanehetehena. Hoka waiyehena atyo nikare iniyalahare hisomehitiya — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Haxowaka Jesus iraihitiya halitinai kakoa: — Natyo atyo xaokanatyakalati akereta halitinai ana. Xala xamaniya atyo tyaona noximi hoka waiyeya atyo tyaona. Hoka maisaiya makaliroti koni tyaohitita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nexa hoka fariseunai nehena Jesus hiye: — Kalikini atyo hitahi akiti taitehena hiraeta hikaxaexakeretyaka maheta. Hamaoseraita atyo wiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hoka Jesus nehena ihiyeha: — Aliterexe xakore atyo notahi niraeta hoka maisa atyo namaoseraita xini. Aliterexe atyo niraeta hoka nawaiyoreta atyo notyoanini exahe noxaniniheta kakoa. Hoka xiso atyo maisa xawaiyorexe notyoanini exahe noxaniniheta kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Xiso atyo haliti xiyaiyehena, inira xawaiyorehena ekakoa hoka, “Exakerexe waiye xomokaka”, xita. Hoka natyo atyo maisa nikare niraexe halitinai xaokaka. ");
INSERT INTO pabNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Haiya xowakiya nomihena, “Exe haliti atyo exakere tyaonita”, nomihenaiya hoka aliterexe atyo niraeta. Hiyaiya, maisa atyo nowawi xini notyaonita. Baba noxaxikatyasehare atyo tyaonita nokakoi hoka nikare niraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","— Exakere iraiti xiyaotyakisakaho nanekoa xairatyoare tyaonita tehitiya: Hinamahareya haliti xakai hawaiyane tahi hoka hakakoa iraeha hatyo tahi taita hoka xityakeko iniraeneha. Iniraeneha atyo aliterexe. ");
INSERT INTO pabNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","— Hiyaiya, natyo atyo noxakaita notahi akiti xihiye, Baba noxaxikatyasehare tehitiya xakaita notahi. ");
INSERT INTO pabNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nexa ihiyeha hoka nehenaha ihiye: — Aliyo atyo hexe? Hoka Jesus nehena ihiyeha: — Maisa xiyaiyanehare kaisere xini natyo, exahe Baba hoka maisa xiyaiyanehare xini. Xiyaiyanehare kaisereya natyo hoka Baba tehitiyaiya xiyaiyanehare — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Exowaka Jesus aotyakijita Iraexatyakalati Hanako. Halyako olo nitini tyaonitere ako Jesus iraeta ekakoaha. Irae ekakoaha hoka maisa otokahitene, maisa exotokakaosehenere hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Hatyaoseta Jesus nihitiya ihiyeha: — Noxanihetehenaite xonita. Xatawa xakore ite natyo hoka maisaiya xiyaiyehitita natyo hoka iniyalahare xománe kakoitaite xiwaini hoka maisaiya atyo noxanihenere nali xijoita — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nexa irae hoka judeunai nexakakoahenaha: —“Maisaiya noxanihenere nali xijoita”, nita. Xoana tyaohena? Xoana hatyotala aisoawihena? nexakakoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hatyaoseta Jesus nihitiya: — Xiso atyo ali waikoatare hoka natyo atyo enokoatare. Xiso atyo ali waikohekoare hoka natyo atyo maisa ali waikohekoare xini. ");
INSERT INTO pabNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hiyeta hoka nomita xihiye. “Iniyalahare xománe kakoitaite xiwaini”. Maisa tyare xityakekota natyo hoka — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hatyaoseta axehenahitiyene: — Xala atyo hiso? nexaha. Hoka Jesus nehena ihiyeha: — Hetati xowakiyita nowaiya xiso hoka noxakai notahi xihiye. Kalikini noxakaihitiya xihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kahare xitahi nirai naokowita exahe nowatyali xiso naokowita. Hatyo noxaxikatyasehare atyo maisa maoseratyare xini hoka iniraine koxaka nasema hoka noxakaita halitinai hiye — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesus xakore xakaita hanexe Enore tahi akiti ihiyeha hoka maisa waiyekehalakere enomanaha, motya hatya tahi iraeta aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hatyo hiyeta Jesus nihitiya ihiyeha: — Natyo atyo maisa atyo xoare noxaokali ximita notyomare. Baba aotyakihenere natyo taita atyo niraeta. Xainakihenaite Haliti Ityani hoka hatyaosetaite waiyekehalakehena xomana “Natyo atyo Natyota terota” nomitere. ");
INSERT INTO pabNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Noxaxikatyasehare atyo tyaonita nokakoi. Exaokalaoseta notyaona minita hoka maisa atyo nowawi halakisare — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nikare Jesus hatyo tahi irae hoka kahare haliti tyakekoahene. ");
INSERT INTO pabNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hatyaoseta kahare judeunai tyakekoahene hoka Jesus nehena tyakekohenerenai hiye: — Niraini xemaiya xisaona hoka noximi nawenatyasehareya naoka xiso ");
INSERT INTO pabNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","hoka waiyekehalakaiya xomana aliterexe hoka xikaiyakehetaiya xiwakaharene nonitata — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hatyaoseta nehenaha Jesus hiye: — Wiso atyo Abraão jikolaharenai, maisa atyo xoana xowakiya wakahare wisaonare, exahe wahetakomaniyereharenai hoka wakahare tyaonareha. Xoanere hoka wikaiyakeheta wiwakaharene nonitata haoka? ");
INSERT INTO pabNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hoka Jesus nihitiya ihiyeha: — Xasemehena niraini: wakahareya atyo maisa aliyakere halakijita haxekohase. Nikareta iniyalahare nomaseharenaiya maisa aliyakere halakijita iniyalahare háomane. ");
INSERT INTO pabNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wakahare atyo maisa tyaoneta menexe haxekohase hanako hoka exekohase ityani atyo tyaoneta minita hanexe hanako. ");
INSERT INTO pabNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hoka Enore Ityaniya iyeheta xiso aokowi hoka iyehetaiya atyo xiso hoka maisaiya atyo hatyohekota wakahare xisaohitita. ");
INSERT INTO pabNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","— Aliterexe atyo Abraão jikolaharenai xiso. Xakore atyo hoka xaisa xaokowita natyo, maisa noxaotyakiri xaokare xomana hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Baba nali nowaiyehenere atyo noxakaita xihiye. Nikare xiso tehitiya xexe nali xawaiyorehenere akereta xisaonita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hoka nehenaha: — Abraão atyo wexe — nexaha. Hoka Jesus nehena ihiyeha: — Maisa Abraão jikolaharenai kaisere xini xiso. Abraão jikolaharenaiya atyo xiso hoka hatyo akeretaiya atyo xisaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nasema iraiti aliterexe Enore nali. Xakore hoka noxakaihenene xihiye hoka hatyo hiyeta xaisa xaokowita natyo. Abraão atyo maisa nikare tyaonare. ");
INSERT INTO pabNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Xiso atyo xexe tyomehenere akereta xisomita — nexa Jesus. Hoka nehenahitiyaha ihiye: — Hatita atyo Wexe, Enore taita atyo Wexe. Maisa hatya ityani xini wiso. ");
INSERT INTO pabNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Hoka Jesus nihitiya ihiyeha: — Maisa noxaokali ximita xini notyoa ali, Enore axikatya natyo. Enore nalita atyo notyoa hoka kalikini ali notyaonita. Enoreya atyo xexe hoka xawaiyetitaiya atyo natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Xoana hoka maisa waiyekehalaka xasemare niraini? Maisa xasema xaokowiye niraini hoka hatyo hiyeta maisa waiyekehalakere xomana. ");
INSERT INTO pabNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tihanare xekohase ityaninai atyo xiso. Tihanare xekohase ityaninai atyo xiso hoka tyaonitere akereta xisaonita. Hetati xowakiya atyo aisarexe tyaona, maisa atyo iraiti aliterexe awaiyitita. Maoseratyaliye terota atyo, exahe maoseratyaliye kinohare. ");
INSERT INTO pabNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hatyo jikolaharenai atyo xiso hoka iraiti aliterexe niraihena xikakoa hoka maisa xityakekore natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Xalaiya hotikisa nomani iniyalahare nománi? Xoana hoka iraiti aliterexe niraihena xikakoa hoka maisa xityakekore natyo? ");
INSERT INTO pabNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xala xamani atyo Enore xema maniya tyaonita hoka semaxemaita atyo Enore niraine. Hoka xiso atyo maisa xasemaxematyare iniraine, maisa atyo enomanerenai xini xiso hoka — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hatyaoseta judeunai nehena Jesus hiye: — Kala ehekoreta wiraeta hitahi akiti. “Samaria yere atyo hiso, tihanare kakoare atyo hiso”, wita. Kala ehekoreta wiraeta — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hatyaoseta Jesus nehena ihiyeha: — Maisa atyo tihanare kakoare xini natyo. Naiminijita atyo Baba hoka xiso atyo maisa xaiminisare natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Maisa atyo naeroretyoa naokowiye. Hatya atyo aeroretya aokowita natyo. Maika hatyo ahekotya nokakoi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","— Xasemehena niraini, aliterexe niraeta: Xala xamaniya atyo tyaona niraini xema hoka maisaiya atyo wainita — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hatyaoseta judeunai nihitiya Jesus hiye: — Kalikini atyo waiyekehalaka womana. Tihanare terota tyaonita hikakoa. Abraão, iraiti xakaisaseharenai atyo toahiya waini. Hoka hita atyo: “Xala xamaniya atyo tyaona niraini xema hoka maisaiya atyo wainita”, hita. ");
INSERT INTO pabNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Hiyaiya, wikinohare Abraão atyo waini. Xoana Abraão xahehare haokowita? Hatyo, iraiti xakaisaseharenai atyo waini tyotya. Xala haokowita? nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hoka Jesus nihitiya: — Natyotaiya atyo naeroretyoawi hoka maisaiya atyo waiyeta. Hoka maisa naerorityoawita, Baba atyo aeroritita natyo. Xenorexa xaokitere aeroritita natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Xiso atyo maisa Enore xiyaiyare, exahe exema maniya xisaonare. Hoka natyo atyo nowaitene, exema maniya atyo notyaonita. “Maisa nowaiyarene”, nomiya atyo hoka xiso akeretaiya atyo namaoseratita. Hoka nowaiyitene atyo, notyaonita atyo iniraine xema. ");
INSERT INTO pabNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xikinohare Abraão atyo waiya notyoaniniheta ali xeta hoka ihalahare. Hatyo xowaka Abraão waiya natyo hoka ihalahare — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hoka judeunai nehena ihiye: — Maisa xakore 50 terehokoanehenere hekoti hisaonare hoka, “Nowaiya Abraão”, hita. Xoana hoka nikareta hiso? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hoka Jesus nihitiya ihiyeha: — Aliterexe nomita xihiye: Abraão mawenanehareneta atyo koxaka terota Natyo Notyaonita — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nexa hoka hatyaoseta judeunai eharehenaha ihiye hoka xane iyaha sehali hoka mokotyaha Jesus aokowi. Xakore atyo hoka Jesus teroa enonyahitaha. Hatyaoseta hikoaheta Iraexatyakalati Hanakota hoka xaneheta enonyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hatyaoseta Jesus jiyehena hoka waiya hatya haliti maxosehare. Nikarexe terota tyaona hanityo tyakota. ");
INSERT INTO pabNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Hoka exaotyakiraharenai axehenene: — Xaotyakisatiye, xoana hoka exe haliti tyaona maxosehare? Xoana iniyalahare ala tyoma, enexe inityo xoaha kore iniyalahare tyoma hoka hatyo nahalakoa maxosehare tyaona? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Hoka Jesus nehena ihiyeha: — Maisa enómane iniyalahare, exahe enexe, inityo xoaha nómane iniyalahare hiyeta maxosehare tyaona. Maxosehare tyaona Enore niyatere kawaiyaka maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","— Xasemehena, waiye hakaka atyo ferakoa. Nikare kasani namiyatya naokowita noxaxikatyasehare hatene. Hiyaiya, makehena atyo. Maka atyoite hoka maisa xala hare hahitita. (“Makehena”, nitere atyo hakamane xaokaka nikareta). ");
INSERT INTO pabNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Haliti koni notyaonitere xowaka atyo exaokanatyakalaha notyaonita enomanaha — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nexa hoka hatyaoseta xata hotya waikoa hoka inira aolowihitya waikohe haxataho kakoa hoka mokene maxosehare xose hiye hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","— Hiyane hatihehetehena one nitini Siloé xaiya — nexa. Hatyo Siloé nitere atyo wiyako maniya, “Exaxikatyakahare”, nita. Nexa ihiye hoka hatyaoseta maxosehare xane tiheheta hatiho hoka waiyakatyare haikoaheta tyaonitere nali. ");
INSERT INTO pabNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hatyaoseta ewaiyaneharenai nexaha: — Exe haliti ferakiti nihatyaka tyoka ali hoka axita olo haomana. Hatyo terota, xoana alitere? nexa axakakoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","— Há, hatyo terota — nexa haiyanai. — Maisa hatyo xini, hatyo akerehare — nexa atyo haiyanai. — Há, natyo terota — nexa hatyo haliti. ");
INSERT INTO pabNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hatyaoseta axahene: — Aliyakere hisaona hoka kalikini hiyaiyakatyareheta? nexa axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hoka nehena: — Hatya haliti Jesus nexarexe aolowihitya waikohe hoka mokene noxosenai hiye hoka nexa nohiye: “Hiyane one nitini Siloé nali hatihehetehena hitiho”. Nexa hoka hatyaoseta noxani natiheheta notiho hoka kalikini nowaiyakatyareheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","— Aliyo hatyo haliti? nexaha axahene. — Owane — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Hatyaoseta hatyo haliti waiyakatyareheta hoka xaneha ekakoa fariseunai nali. ");
INSERT INTO pabNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hatyo Jesus aolowihitya waikohe hoka kaxosehetehenere haliti xowaka atyo sábado ferakene. ");
INSERT INTO pabNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Xane kaokaha ekakoa enomanaha hoka fariseunai axene hatyo ekaxosetyakeheta akiti hoka nexa ihiyeha: — Moka haxaolowehera noxosenai hiye hoka noxani natiheheta notiho hoka kalini atyo nowaiyakatyareheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","— Hoka hatyo haliti maisa Enore xaxikalahare xini. Hiyaiya, sábado atyo mahateniti ferakene xakore hoka hakita. Maisa winaho xema tyaonita — nexaha fariseunai iraeta. Hoka haiyaharenai nexaha: — Aliyakereya iniyalahare nomasehare kalore tyoma maomakahare? nexaha. Hatyaoseta iraikakoaha hoka hahekore, hahekore xikini ahekotyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hatyaoseta fariseunai axehitiyene: — Hoka hiso atyo xoare haoka hatyo hikaxosetyaseheta? nexaha. — Iraiti xakaisasehare atyo naokene — nexa hatyo kaxosehetehenere ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hoka judeunai atyo maisa tyakekota iniraine hoka kawisaha enexe inityo xoaha hoka axahene: ");
INSERT INTO pabNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","— Xoana, exe haliti atyo xityani? Xoana alitere maxosehare terota tyaona? Nikare hoka aliyakere kalikini waiyakatyareheta? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hoka enexe, inityo xoaha nehenaha: — Exe wityani terota, aliterexe maxosehare tyaona. ");
INSERT INTO pabNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Hoka kalikini kaxosehetehenere akiti kakoa atyo maisa wawaiyorexe, exahe ekaxosetyasehare kakoa tehitiya maisa wawaiyorexe. Xala xamani ala kaxosehetene — nexaha. — Xaxehenene: inityohaliti tyare hoka hatyota xakai hatahi akiti xihiye — nexa enexe, inityo xoaha ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Enexe, inityo xoaha mairahitaha judeunai nityohalitiranai hoka nikare iraeha. Judeunai nityohalitiranai koxaka iraikakoaha: — Hatya halitiya: “Jesus atyo Enore Kalorexe Aohenere”, nexa irai hoka maxisoaniteneya xahohisakoatyakalati hanako — nexaha koxaka. ");
INSERT INTO pabNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hatyo hiyeta enexe, inityo xoaha nexa: — Xaxenore, koxaka inityohaliti — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hatyo hekota kawihenahitiyaha hatyo maxosehare tyaohenere hoka nexaha ihiye: — Hasemehena, haiminisaira Enore. Exe hikaxosetyasehare atyo iniyalahare nomasehare, wawaiyore enawenane kakoa — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hatyaoseta nehena ihiyeha: — Kala xoana iniyalahare nomasehare xamani, maisa xamani ala, maisa nawaiyorexe ekakoa. Hoka exe taita kakoa atyo nawaiyore. Nomaxosehare ene hoka kalikini atyo nowaiyakatyareheta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","— Xoana moka hiso? Aliyakere kaxoseheta hiso? nexa axehenahitiyene. ");
INSERT INTO pabNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","— Koxaka noxakaini xihiye hoka maisa xityakekota. Xoare maheta noxakaihitiya xihiye xaowita? Xoana xisaona xaokowita tehitiya exaotyakira xema? nexa ekoaxatya enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nexa hoka hatyaoseta aiyalatyaha enomana: — Hiso atyo exaotyakira xema maniya nawenatyasehare. Hoka wiso atyo Moisés xaotyakira xema maniya wisaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Enore irae Moisés kakoa, hatyo kakoa wawaiyore. Hoka exe hikaxosetyasehare atyoala alyakota xamani kaotyaka — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hoka nihitiya ihiyeha: — Kaxiyani, xoana hoka winaho kakoa xawaiyore xaokowita xakore hoka exe haliti kaotyakene akiti kakoa maisa xawaiyorexe? Kaxoseheta xakore natyo hoka maisa xawaiyorexe ekaotyakene akiti kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hiyaiya, Enore atyo maisa iniyalahare nomaseharenai niraexala semaxematyare. Hoka awaiyetitaiya Enore hoka aokitere akeretaiya tyaonita hoka Enoreya semaxematya iniraexala. Hatyohare kakoa atyo wawaiyoreta. ");
INSERT INTO pabNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kalikini rotita maxosehare tyaohenere kakaxosetyakeheta. Toahiya xowaka, exahe waikohe kaomakehenere najikinita maisa kasemakere exehare tahi, kalini rotita kasemaka. ");
INSERT INTO pabNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ekoiya awa Enore axikaitene hoka maisaiya xoana mokita natyo — nexa ekoaxatya enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","— Hisaohenere xowakita iniyalahare hisoma. Xoana hoka haotyakisa wiso haokowita? nexaha ihiye. Hatyaoseta maxisoanetene xahohisakoatyakalati hanako. ");
INSERT INTO pabNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus sema emaxisoanene xahohisakoatyakalati hanako hoka hatyaoseta ahalakoatene hoka axene: — Xoana Haliti Ityani hityakekota? nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","— Xekohaseti, xala atyo Haliti Ityani hoka notyakekone? nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","— Kalini hiyaitene, natyo niraetere hikakoa — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","— Xekohaseti, notyakeko — nexa meholokoa Jesus nahalakoa awaiyetene. ");
INSERT INTO pabNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Hatyaoseta Jesus nihitiya: — Notyoa nowatyali halitinai maheta. Nikare ite hoka maxoseharenaite waiyakatyareheta hoka kaxosexenaite maxosehare tyaoheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Haiyanai fariseunai nali tyaonita hoka semaha Jesus niraine hoka nexaha: — Xoana wiso tehitiya wimaxosehare haokita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","— Ximaxosehariya hoka maisaiya xoare kaxawatyakita xiheno. Hoka, “Waiye wiyaita”, xita hoka kaxawatyakita xiheno — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus nihitiya: — Xasemehena niraini: Kaiwarexe isoa aokowihena kalaneronai talalahokoako hoka maisa ixisoakala ahota isoare. Halaisoa jiyita talarehoko hoka xane hikoita kalaneronai ana. ");
INSERT INTO pabNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hoka ekaxaikotyasehare isoahena hoka ixisoakala nahota ijoita. ");
INSERT INTO pabNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Xisoakalati kaxaikotyasehare majiholatita enomana hoka ijoita. Hatyaoseta iraihena hakaxaikoneharenai hiye hoka ekaxaikoneharenai kalaneronai otyahita exako. ");
INSERT INTO pabNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hatyaoseta ahikoatyahitene talarehokoakota hoka enahetaha tonita hoka kalaneronai xaneta exema, exako waiyekehalakita enomanaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mawaiyakahareya atyo hoka maisaiya atyo xanahitaha exema, tekoahaiya atyo enonita, maisa otyareha mawaiyakahare xako hoka — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Hatyo tahi Jesus xakai ihiyeha aotyakisahitene maheta xakore hoka maisa waiyekehalakita enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hatyaoseta Jesus nihitiya: — Aliterexe nomita xihiye, natyo atyo xisoakalati kalaneronai xisoakalaho akereta. ");
INSERT INTO pabNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Haiyanai nahítita kaokaha kalaneronai ana hoka maisa atyo kalaneronai semaxematyare iniraineha, kaiwarexe, xalijiniharexenai akereta taita hoka. (“Kalaneronai” nita Jesus, hakaxaikoneharenai haliti xaokaka nikare iraeta.) ");
INSERT INTO pabNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","— Natyo atyo xisoakalati akereta. Xala xamaniya isoa nonaho hoka kaiyakehetaiya iniyalahare nonitata exahe isoaheta, hikoaheta, kanakairita harenai hoka waiyeya tyaona. ");
INSERT INTO pabNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hoka kaiwarexe atyo kaokehena enomanaha hoka kaiwita, aijita, mawenekoaretita kalaneronai. Hoka natyo atyo notyoa kalaneronai waiye tyaonaha maheta, exahe waiye kaiserehare tyaonaha maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","— Natyo atyo kalanero kaxaikotyasehare waiyexe. Kalanero kaxaikotyasehare waiyexe atyo wainita hakaxaikoneharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wakahare atyo maisa kalanero kaxaikotyasehare kaisere xini, kaoloxa maheta taita atyo hakita. Kalaneronai maisa ehalanai xini. Hiyeta hoka ahoxa kaokehena enomana hoka tekoita hoka ahoxa aijita, aekoakijita kalaneronai. ");
INSERT INTO pabNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kaoloxa maheta taita hakita. Maisa iyakawatyare kalaneronai hoka nikare tekoita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","— Hoka natyo atyo kalanero kaxaikotyasehare waiyexe. Nokaxaikoniharenai atyo nowaiyaniharenai makere. Natyo tehitiya atyo ewaiyanehareha. ");
INSERT INTO pabNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nikare Baba Enore atyo nowaiyanihare, hoka natyo atyo ewaiyanehare. Maikaite nowainihena nokaxaikoniharenai ana — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","— Maisa aliyerenai taita xini nokaxaikonihare. Hahotyaliharenai tehitiya nokaxaikonihare hoka kasani nahohisakoatyahene hoka hahotyalita namoka nokaxaikoniharenai naokowita. Hatyaosetaite niraini xema maniya tyaonaha. Nikare ite hoka hahotyalita tyaonaha hoka haterore ite ekaxaikotyasehareha tyaona. ");
INSERT INTO pabNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nowainite nokaxaikoniharenai ana hoka hatyaosetaite nokaseheta. Hatyo hiyeta Baba Enore awaiyetita natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maisa halitinai xaokala xini nowainihena, noxaokalita atyoite nowainihena. Baba aiyatelikisa natyo hoka noxaokalita nowainihena. Hatyaosetaite noxaokalita nokaseheta. Baba irai nokakoi hatyo akiti hoka exaokalita nikareta natyo — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hatyaoseta judeunai semaha Jesus niraine hoka hahekore makere ahekotyahita, hoka haiyaharenai nexa: ");
INSERT INTO pabNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","— Tihanare tyaonita ekakoa hoka hatyahareta. Xoana hoka xasemaxemaita iniraene? nexaha haiyanai iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Hoka haiyanai atyo nexaha: — Tihanare kamilakorerahareya atyo hoka maisaiya exakere iraexe. Xoana, tihanareya kaxoseheta maxosehare? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Exowakiya judeunai Jerusalém nali otyaxematyahitaha hahetakomaniyerenai nómane xahohisakoatyakalati hana hisehare. Exowaka wehe akiti. ");
INSERT INTO pabNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hatyaoseta Jesus isoa Iraexatyakalati Hanako hoka tonakoita Iraexatyakalati Hanako Salomão xisoakalaho aokahitere nali. ");
INSERT INTO pabNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hatyaoseta judeunai hohisakoaha ehaliya hoka axehenahene: — Kahare wahekoita hitahi hoka wamaikohareta. Xoana Enore Kalorexe Aohenere hiso, maisa kore? Hiyakaihena waiyekehalaka wihiye — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Hoka Jesus nehena: — Koxaka Enore nalitare atyo natyo nomi xihiye hoka maisa xityakekota niraini. Xiyaiya, kahare maomakahare notyoma Baba xaokalita. Baba nalitare terota atyo natyo hoka nikare notyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Xakore hoka maisa xityakekota natyo. Maisa atyo nokaxaikoniharenai xini xiso hoka hatyo hiyeta maisa xityakekore natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nokaxaikoniharenai semita noxako hoka naokitere akereta tyomahitaha. Ewaiyanehareha atyo natyo hoka tyaonahitaha niraini xema. ");
INSERT INTO pabNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nokaxaikoahinite hoka tyaonaha mene matyotenehare hoka maisaiya atyo wainahitaha. Maisaiya atyo xala hare iyehenahititene noniti. ");
INSERT INTO pabNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baba atyo maxaexahityakahare hoka maisaiya atyo xala harenai iyehitita nokaxaikoniharenai enonitata — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","— Baba natyo xoaha atyo haterore, hakakoa wisaonita — nexa Jesus judeunai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hatyaoseta judeunai eharehenaha hoka xane kolatya sehalinai mokotyaha maheta Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ehareha ihiye hoka Jesus nehena ihiyeha: — Kahare notyoma xihaoti, waiyexe makere nománinae. Baba aokiterehare taita notyoma. Xoana, hatyo nománi xemere xamokotya xaokowita natyo? nexa axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hoka judeunai nehena ihiye: — Maisa atyo hománe waiyexe xemere xini wamokotya waokowita hiso. Hoka hiraine atyo maisa waiyexe womana, maisa haiminisare Enore hoka. Haliti xakore hiso hoka Enore haokowita hoka hatyo xemere wehareta hihiye — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Hoka Jesus nehena ihiyeha: — Exakerexe xairatyoare tyaonita babera xiyaotyakisakaho nanekoa: Enorenai makere xiso, nomita. ");
INSERT INTO pabNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","—“Enorenai makere xiso”, nita Enore halitinai hiye, iniraine kaoka enomanaha hoka. Hatyo babera Enore niraine kakoare atyo aliterexe taita iraeta hoka maisaiya kahalakisakita. ");
INSERT INTO pabNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hiyaiya, Baba axikatya natyo halitinai koni haxaokalita. Nikare hoka xoanere hoka “Natyo atyo Enore Ityani”, nomihena hoka Enore maisa naiminisare xaokita? ");
INSERT INTO pabNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Maisaiya Baba xaokalaoseta notyomare hoka ehekoretaiya atyo maisa xityakekota natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Maisa xityakekota natyo hoka maika notyomiterenai hekoti xityakekohena. Nománinai hiyeta xawaiyorehena nokakoi. Baba atyo tyaonita nokakoi, exahe natyo hoka notyaonita ekakoa — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nexa Jesus ihiyeha hoka eharehitiyaha ihiye hoka hatyaoseta tohenahitiyene aokowiha xakore hoka iyoawiheta enonyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesus iyoawiheta enonyahitaha hoka haikoaheta one Jordão halakoiya maniya hoka João Batista hetati batixaitere aose xane tyaona. ");
INSERT INTO pabNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nali xane tyaona hoka kahare haliti kaoka enomana. — João Batista atyo maisa xoare hare tyomita maomakahare. Xakore hoka tyotya iraehenere Jesus tahi atyo aliterexe, maisa maoseraita xini wiso João — nexa iraeha. ");
INSERT INTO pabNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kahare haliti tyakeko Jesus hatyo nali. ");
INSERT INTO pabNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Haxowakiya Lázaro nexarexe hokakita. Wenakalati Betânia nali tyaonita, hahahalonai Marta, Maria xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hatyo Maria atyo Jesus kiji tiha hoka owika airaxero ikiji hiye, exahe hasekase kakoa tirihetene. ");
INSERT INTO pabNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Enahahareha Lázaro hokakita hoka enahahalonai axikaxatyaha Jesus ana: — Hihinaehare Lázaro hawaiyetitere hokakita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus sema ehokakene tahi hoka nexa: — Maisaiya hatyo kahehaliti kakoa Lázaro wainita. Hokakita hoka ite kaxaeyatelekisaka hoka hatyo hiyetaite Enore kaxaexakerityaka, exahe Enore Ityani hoka kaxaexakerityaka — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus awaiyetita Marta, iximalone Maria, enahahareha Lázaro xoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jesus sema Lázaro hokakene xakore hoka hatyo tyaonitere nalita heko hinamaki tyaohitiya. ");
INSERT INTO pabNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hinamaki ferakene najikinita hoka Jesus nehena haxaotyakiraharenai hiye: — Wiyala wiyane Judéia koa xeta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","— Xaotyakisatiye, xoana hoka hiyanehitiya hatyo nali haokowita? Hiyaiya, kafaka maniya judeunai nali tyaoniterenai mokotyaha hiso aokowiha sehali kakoa — nexaha exaotyakiraharenai iniraine nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","— Maisa ferakiti tyokakere xini, wahakiya atyo. Watonita ferakoa hoka waiye wiyaiyita waheta maniya hoka maisa wahisehityoare. ");
INSERT INTO pabNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hoka makiya atyo watohena hoka haiya xowaka wahisehityoita, maisa waiye waiyakere makiya hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","— Xasemehena, wihinaehare Lázaro nemakita xakore hoka noxanite nekaosekihetene — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","— Nemakitaiya hoka waiyeya atyo kehexoawiheta — nexaha haxekohaseha hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus iraetere Lázaro kamane xaokaka. Hoka exaotyakiraharenai motya enemaka xaokaka nikareta aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hatyaoseta Jesus nexa: — Lázaro atyore waini — nexa, awaiyekehalakatene enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","— Waini atyo Lázaro. Hoka ehekoreta ali notyaonita, wainihena xakore hoka. Enawenakala nali wisaonita hoka maisaiya xityakekota — nexa. — Wiyala kalikini hoka wiyaiya — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hatyaoseta Tomé Dídimo nexarexe nehena hahinaeharenai hiye: — Wiyala wiyane exema hoka wiwaini ehakakoane — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Hatyaoseta xaneha. Jesus xane kaokehena Betânia nali hoka Lázaro koxaka 4-kihena tyaonita xawatyakalatyako. ");
INSERT INTO pabNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Wenakalati Betânia maisa sekore Jerusalém nalita, hanama kilometrone taita. ");
INSERT INTO pabNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Maisa sekore hoka judeunai kahare xane waiyaha Marta, Maria xoaha emaxalotyahene maheta enahahareha kamane hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hoka Marta sema Jesus kaokene. Owitehena hoka xane atihotene. Hoka Maria atyo hekota hahanakota. ");
INSERT INTO pabNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta xane atihotya Jesus hoka nehena ihiye: — Aliya hiso hoka maisaiya naháhare wainita, Xekohaseti — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","— Waini xakore atyo hoka xoalini hareya haxa Enore hoka tyomeniya homana. Waiyekehalakita atyo hatyo akiti nomani nexa Marta Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","— Haháhare ite kaseheta — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","— Miyanitiye xowakehena atyoite hoka naháhare kaseheta. Nasemita hatyohare akiti hoka notyakekota — nexa Marta ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","— Natyo atyo kamatinai xekasekisasehareheta. Halitiya tyaona noximi maniya hoka waini xakoreya hoka kasehetaiya. ");
INSERT INTO pabNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Exahe kasetere noximi maniya tyaonitereya maisa wainita. Xoana hityakeko niraini? nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","— Há, notyakekota atyo, Xekohaseti — nexa. — Hiso atyo Enore Ityani, Enore Kalorexe Aohenere atyo hiso. Wahetakomaniyerenai nexaha exaokaka: “Maika xatyaha exahita. Ekakoitaite kaotyaka xomana”, nexaha — nexa Marta Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nexa ihiye hoka haikoaheta hahana xeta hoka xane haximalone Maria kakoa irai hameteneta: — Xaotyakisatiye kaoka hoka kawijita hiso — nexa haximalone hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria semene hoka ihalahalo xane Jesus tyaonitere nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Hatyo xowaka Jesus maisa kaokehenere wenakalati, hekotata Marta ahalakoahenere aose. ");
INSERT INTO pabNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ehanakoha haiyanae judeunai tyaonita, Maria emaxalotyahitaha. Hoka waiyehenaha atyo, Maria atyo ihalahalo hikoa xane hoka hatyo exemaxalotyasenai xaneha exema, motya atyo xane xawatyakalati nali hoka tiyahena maheta aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria xane kaoka Jesus ana hoka exoa hakaoli kakoa ehaliya hoka nehena: — Aliya hiso hoka maisaiya naháhare wainita, Xekohaseti — nexa tiya. ");
INSERT INTO pabNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Waiyehena atyo Jesus, Maria atyo tiyita, judeunai tehitiya tiyita ehakakoane. Tiyahitaha makere hoka Jesus hiye kirakoane hoka amaikohare. ");
INSERT INTO pabNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","— Aliyo exawatyakala? nexa axahene. — Witya hoka hiyaiya, Xekohaseti — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hatyaoseta Jesus tiya. ");
INSERT INTO pabNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jesus tiyita hoka judeunai nexaha: — Xiyaiyehena, tiyita. Kala awaiyetita tehitiya Lázaro — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","— Aliya Lázaro hokakitere xowakiya hoka xoanaiya mokene? Kafaka maniya maxosehare kaxoseheta. Aliya Lázaro hokakitere xowaka hoka xoana xamaniya hoka aiyatelikeheteniya hoka maisa wainita — nexa haiyaharenai. ");
INSERT INTO pabNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus hekotata kalore amaikohareta hoka xane xawatyakalati nali. Hatyo xawatyakalati atyo sehali kakoakotyaka, ijihola atyo sehali taose. ");
INSERT INTO pabNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus xane kaoka xawatyakalati nali hoka nexa ihiyeha: — Xiyehetehena sehali taose — nexa ihiyeha. Nexa hoka kamati nahahalo Marta nehena: — Maisaiya, Xekohaseti — nexa. — Hiyaiya, koxaka 4-kihena tyaonita xawatyakalatyako. Kala koxaka xetehena. Kotare mawatyalisakahare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","— Maika xityakekohena hoka xiyaiya Enore nómane, nomira xihiye ka. Xoana himaotyaneheta niraini? nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nexa ihiye hoka iyehenahitaha sehali xawatyakalati jihola. Iyehenahitene hoka Jesus wahakotya enoxeta hoka nehena: — Maisa xoana xowaka himaxekoaxalere niraini hoka nihalahareta hikakoa, Abá. ");
INSERT INTO pabNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Hiyaxikalahare atyo natyo hoka hasemaxematya minita niraini hikakoa. Kalikini niraexaita homana exe halitinai haoti tyakekoha maheta hiso — nexa iraexatya Enore hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Halakisa hairaexala hoka kinatyaxa kawiyatya: — Lázaro, hahikoahetehena hatyoakota — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nexa hoka Lázaro hikoaheta hakiji, hakahe, hatiho olalisoare kakoa haxawatyakalakota. Eháre olalisoare imiti taose kakoa hoka Jesus nehena: — Xamaxolalihetehenene hoka waiye toneheta — nexa ihiyeha hoka maxolalihetene. ");
INSERT INTO pabNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hatyaoseta kahare judeunai Maria xema tyohenerenai tyakekoha Jesus, waiyaha enómane hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Hoka haiyanai atyo xane hoka xakaihahene fariseunai hiye Lázaro ekasekihetehenere tahi. ");
INSERT INTO pabNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hiyeta hoka sacerdotenai, fariseunai xoaha nityohalitiranai ahohisakoatyakakoaha iraekakoaha maheta. — Xoanaite wamohenene? Exe haliti kahare tyomita maomakahare. ");
INSERT INTO pabNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wahalakiseniya hoka ekakoitaiya tyotyahaiya tyakekoahene hoka hatyaosetaiya maisa waiyeta Roma yerenai hiye hoka tyoahaiya iyaha wawenakala wiwaikohera xoaha wonita, exahe mawenekoaretyahaiya Iraexatyakalati Hana — nexa iraikakoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hatyo terehokoane xowakiya Caifás sacerdote xekohase tyaonita hoka nexa ihiyeha: — Xiso atyo maisa xawaiyorexe. ");
INSERT INTO pabNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hatyaiya waini womana wityotya anere maheta hoka waiyeya, maisaiya Israel yerenai kamehotyakita. Kala maisa hatyohare akiti xahekotyare — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás iraihena hoka maisa hatyota haxahekola xini iraeta. Sacerdotenai xekohase tyaonita hoka waiya Jesus kamane naheta maniyita Israel yerenai ana, ");
INSERT INTO pabNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","exahe seko tyaoniterenai xaoreterenai xoaha ana hoka hatyo najikinitaiya Enore kaxaikoneharenai hahotyalita tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nexa Caifás irai ekakoaha hoka hatyo najikinita judeunai nityohalitiranai iraekakoaha Jesus haxaisane tahi. ");
INSERT INTO pabNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hatyo hiyeta Jesus maisa hotikijoita judeunai ana Jerusalém nali hoka xane enonyahitaha, xane kaoka wenakalati Efraim nali hoka hatyo nali tyaona haxaotyakiraharenai kakoa maharexakiti maniya. ");
INSERT INTO pabNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hatyaoseta okoi Páscoahena, okoi judeunai hisehare aose xane hikoahena. Kahare judeunai xane Jerusalém xeta hisehaliti nahitita, waiye maniya mokaha hawenaneha maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hatyaoseta Jerusalém nali tawaha Jesus xahita. Xane isoaha Iraexatyakalati Hanako hoka iraikakoaha: — Xoana tyoa waiya xamanite hisehaliti, maisa xamanite? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sacerdotenai, fariseunai xoaha nityohalitiranai otoka aokowiyahitaha Jesus. Hiyeta hoka nexa iraeha: — Maika kaokehena hoka aliyo xamani xiyaiyehenene hoka waiyekehalakehena xomana hoka xiyakaini wihiye — nexaha otoka aokowitaha Jesus hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Hatyaoseta Jesus xanehitiya wenakalati Betânia nali. Lázaro Jesus ekasekihetehenere nali tyaonita. Exowaka 6-ki ferakenetehena hisehaliti Páscoa naheta. ");
INSERT INTO pabNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Xane kaoka hatyo nali hoka nakairati tyomaha Jesus ana hoka kaexakatyaha tehitiya haiyaharenai. Kanakairehenaha hoka Lázaro kanakaira ekakoaha. Haiyanae ihinaeharenai tehitiya kanakairaha Jesus kakoa. Hoka Marta atyo nakairati mokita kanakairiterenai ana. ");
INSERT INTO pabNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kanakairahitaha hoka Maria xane kaoka Jesus haliya tinihalitise airaxero kahekoalo. Hatyo airaxero kaloxaimane, maisa makarohare xini. Kaoka ehaliya hoka owikene Jesus kijinai hiye, exowakerota hasekase kakoita tirihetene. Airaxako moka hatyako. ");
INSERT INTO pabNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hoka Jesus xaotyakirahare Judas Iscariotes hiye maisa waiyeta. Hatyo najikinita Judas matawatya Jesus. Maisa waiyeta ihiye hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","— Exe airaxero maisa makarohare xini, exaimane atyo 300 hokose olo. Xoana hoka maisa betetitene hoka maxiyehareharenai ana ijita exaimane? nexa Judas. ");
INSERT INTO pabNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Maisa xakore maxiyehareharenai kahinaetya aokowiye hoka nikare iraeta, kaiwarexe xakore hoka. Kaxaikota Jesus noloxa exaotyakiraharenai xoaha noloxa hoka kaiwita. ");
INSERT INTO pabNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nexa hoka Jesus ekoaxatya enomana: — Awa xiwatyalini. Kotare airaxero moka nohiye. Noxafityaki nahitata nikare mokita natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maxiyehareharenai atyoite tyaoneta mene xinekoni. Hoka natyo atyoite maisa notyaoneta menita xinekoni — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judeunai sema Jesus kaokene Betânia nali hoka kahare tyoa kaokaha hatyo nali, waiyaha aokowitaha Jesus hoka, exahe ekasekihetehenere Lázaro tehitiya waiyaha aokowitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kahare haliti xane waiyaha Jesus, Lázaro xoaha hoka hatyo hiyeta sacerdote nityohalitiranai okoawaharehena hoka Lázaro xaisaka tehitiya aokaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ekasekihetehenerene hiyeta kahare judeunai Jesus xema maniya tyaonita. Awaiyetyahitene hoka hanityohalitiranaiha maotyaneha hoka maisa waiyeta inityohalitiranaiha hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kamaetali hoka hisoaka haliti kaokehena Jerusalém nali waiyaha maheta hisehaliti Páscoa hoka semaha Jesus tyoanene Jerusalém xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Semahene hoka tyoaha ahalakoatyahene. Iyaliti kolatyaha hoka ahalakoatyahene, ihalahareha ekakoa. — Wihalahareta hikakoa, Enore! Xekohaseti Enore, waiyíra hamohena héxare kakoa tyoitere! Xekohaseti Enore xaxikalahare tyoita Israel hotyalinai ana hoka waiyeta womana, Enore xoaha waiyeta womana — nexaha masakare ihalaharahitaha Jesus kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus ahalakoatya boriko mokose hoka tyoka eheno, babera Iraiti Waiyexe nanekoa xairatyoare tyaonitere akereta: ");
INSERT INTO pabNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Awaira atyo ximawaiyeharehena, wenakalati Sião tyaoniterenae! Ite Xiyekohase Kalorexe tyoa kaoka xomana boriko mokose heno. ");
INSERT INTO pabNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hatyo xowakiya maisa exaotyakiraharenai ana waiyekehalakere. Hoka Jesus waini hoka kaseheta najikini maniyata rota otehenahitaha iraiti xakaisasehare xairala, exahe mohenerene boriko mokose heno hoka waiyekehalaka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Halitinai ihalahare Jesus kakoa. Haiyaharenai haotita Jesus kawiheta Lázaro kamane exawatyakalakota hoka hatyo waiyehenerenae xakaikoatyaha hatyo tahi. ");
INSERT INTO pabNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jesus ekasekihetehenere Lázaro tahi semahitaha hoka hisoaka haliti tyoa ahalakoatya Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hatyo hiyeta fariseunai amaikohareha: — Xiyaiyaore, halitinai maisa semaxematyare wiraine. Tyotyaha awaiyetyahitene hoka tyaonahitaha exema — nexakakoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hatyaoseta haiyanai Grécia koatarenai kaokaha Jerusalém nali waiyaha maheta hisehaliti, Enore xoaha awaiyetyaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hatyaoseta ahalakoatyaha Filipe. Filipe atyo Galiléia yere, wenakalati Betsaida nalitare. Tyoa kaokaha Filipe ana hoka nexaha ihiye: — Wiyaiya waokowita Jesus — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nexaha ihiye hoka Filipe xane André hiye irai hoka hatyo hinamanai xane iraeha Jesus kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hoka Jesus nexa ihiyeha: — Hikoa Haliti Ityani kamanaosehena hoka kasehetaite hoka kalorexe tyaona — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","— Xasemehena, maisa namaoseraita xini: trigose kaxafityakehena waikoa hoka hikoita hoka esé atyo walolota, wainita. Hoka maxafityakahareya hoka haseroreya tyaota mene. Wainiya hoka hikoa hoka ekakoitaiya kahare kasé. ");
INSERT INTO pabNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","— Xala xamani atyoite awaiyetita hawenane ali waikohekoa maniya hoka meta atyoite tyotya enonita. Hoka xala xamani atyoite maisa awaiyetyare hawenane ali waikohekoa maniya hoka hatyo atyoite tyaota mene matyotenehare. ");
INSERT INTO pabNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xala xamani tyaona noximi maniya aokowi hoka maika tyakekohena niraini. Aliye xamanite notyaonita hoka hatyo tehitiyaite nali tyaonita. Tyaonaiya noximi maniya hoka Baba ite awaiyetene — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","— Kalikini kalore namaikohareta. Okoi aisehenaha natyo hoka nomawaiyehareta. Xakore hoka maisaiya naxa Baba hoka kikiheta natyo nomakawatihalini nonitata naokita. Nowaini terota maheta notyoa — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Hatyaoseta iraexahena: — Abá, hikaxaexakeretyakehena naoka — nexa Jesus. Hoka hatyaoseta enokoata iraiti kasemaka: — Koxaka nokaxaexakerityaki hoka haxowakaite nokaxaexakerityakihitiya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Halitinai semahene hoka nexaha: — Kala onetalolo nemahare — nexa haiyanae. — Maisa onetalolo xini, kala anjo iraeta ekakoa — nexa haiyanai iraeha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Hoka Jesus nehena: — Maisa nohiyiti xini exe iraiti tyoa. Xihiyeta tyoa xasemene maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","— Okoi Enore iraihena iniyalahare nomaseharenai tahi. “Exakere kaxomokakaha naoka”, nehenaite hoka exekohaseha Tihanare tehitiyaite kaxawatyakeheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","— Ainakisahaite natyo hoka hatyaosetaite kahare haliti ite tyakekohenaha natyo — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hakamane, haberekotyaka atyalihose xaimaholatyaka hiye xaokaka nikareta, “Ainakisahaite natyo”, nita. ");
INSERT INTO pabNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nexa hoka halitinai nexa ihiye: — Maisaite Enore Kalorexe Aohenere wainita, maikaite tyaoneta mene aokaha. Hatyo tahi kaxairatyaka babera Moisés niraine kakoare. Hoka hiso atyo hita, “Maika Haliti Ityani kaxainakisaka”, hita. Xala xaokaka nikare hiraeta? nexa axaha Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","— Xaokanatyakalati tyaonita kalini xikakoa hoka ininai ite tyaohitiya. Xaokanatyakalati tyaonitata xikakoa hoka memere xamohena xawenane, waiya aliya hoka maisa ximemehenere hekoti hoka makaliroti kaoka xomana. Howitihare netonatyaka atyo makaliroti koni. ");
INSERT INTO pabNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Maika xaokanatyakalati aokanaitatere xomana xowaka xityakekohenene hoka hatyo xema maniya xisaohena — nexa Jesus ihiyeha. (Kasani halitinae exema maniya tyaona aokita hoka nikare iraeta.) Nexa Jesus ihiyeha hoka hatyaoseta xaneheta hatyo nalita hoka xane teroa judeunai nonita. ");
INSERT INTO pabNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kahare Jesus nómane maomakahare waiyexe waiyaha xakore hoka maisa tyakekorahene, ");
INSERT INTO pabNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isaías niraene akereta kawenatyakeheta maheta. Exakerexe Isaías xairatya: Maisa xala hare tyakekore wiraine, Xekohaseti, exahe hiyatere hoka maisa waiyekehalakere enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Exakerexe tehitiya Isaías xairala hoka maisaiya aliyakere tyakekoahitaha: ");
INSERT INTO pabNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Enore maxosehare mokahene, exahe maxahekolahare mokahene, hoka maisa waiyakatyareha, maisa waiyekehalakere enomana, exahe maisa haikoahenahitaha enomana hoka waiye mohenahitene hoka kaxaiyatelikisakehenahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nikare Isaías irae Jesus nawenane kalorexe waiya hoka nikare irae etahi. ");
INSERT INTO pabNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nikare Isaías xairatya xakore hoka kahare judeunai nityohalitiranai tyakekoha Jesus. Tyakekoahene xakore atyo hoka mema atyo tyaonahitaha, maisa atyo xoare nexareha. Motyaiya fariseunai ehareha ihiyeha hoka mahokoanityaha ixisoaneha xahohisakoatyakalati hanako aokahitaha hoka mema tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kasani Enore ihalahare ekakoaha aokahitaha xakore hoka halitinai hotohare ihalahareta ekakoaha aokahitaha hoka hatyo hiyeta mema tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Hatyaoseta Jesus kinatyaxa irai: — Xala xamani atyo tyakekota natyo hoka maisa atyo natyo taita xini tyakekota. Noxaxikatyasehare tehitiya atyo tyakekota. ");
INSERT INTO pabNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Xala xamani atyo waiyita natyo hoka noxaxikatyasehare tehitiya waiyita. ");
INSERT INTO pabNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Notyoa notyaona halitinai koni xaokanatyakalati akere enomanaha hoka tyakekohenere natyo maisa makaliroti koni tyaona maheta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","— Xala xamani atyo sema niraini hoka maisa tyaona exema maniya aokowita hoka maisaiya niraeharetyahitene. Notyoa atyo niyeheta maheta halitinai iniyalahare nonitata maheta. Maisa atyo niraeharetyahitene maheta xini. ");
INSERT INTO pabNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xala xamaniya maisa aokita natyo, maisa semaxematya aokowita niraini hoka hatyohare hiyetaite kairaeharetyaka miyanitiye xowaka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","— Maisa niraini xini niraeta. Baba noxaxikatyasehare irai nokakoi hoka noxakaitene xihiye aoka. ");
INSERT INTO pabNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iniraene atyo ijita wenati menanehaliti hoka wisaoneta meniya. Hatyohare akiti atyo waiyekehalakita nomani. Wisaona mene aokita. Hatyo hiyeta Baba iraetereharenae nohiye taita niraeta xihiye — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hatyaoseta haki ferakenetehena hoka hisehaliti Páscoa ferakene tyaohena hoka Jesus kamanaose xane hikoa. Hoka Jesus atyo waiyoreta hakamanaose ferakene hikoane kakoa, exahe hahalakira halitinai hoka haxáneneheta hanexe nali kakoa. Awaiyetya haxaotyakiraharenai hakamane kijiya. ");
INSERT INTO pabNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Makehena hoka Jesus kanakairita haxaotyakiraharenai kakoa. Exowaka Tihanare koxaka haxahekola moka Simão ityani Judas Iscariotes mahiyasako mátawatya maheta Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus ana atyo waiyekehalakita Enexe tyotya xoalini hare xekohasehare mohenerene kakoa. Exahe waiyoreta tehitiya atyo tyohenere Enore nalita kakoa, exahe haxaneneheta Enore nali xeta kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hatyaoseta Jesus tityoaheta hanakaira aoseta hoka aitoakisa haima ehaorete hoka iya tirihisoakalati taose hoka olatya hakitako hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hatyaoseta tinihaliti koa one moka hoka tihehena haxaotyakiraharenae kiji hoka tirityahaheta ikijiha tirihisoakalati kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Xane kaoka Simão Pedro haliya hoka Simão Pedro nehena ihiye: — Xoana, hatiha nokiji haokowi, Xekohaseti? nexa axa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","— Há, natihaite hikiji — nexa Jesus. — Kalikini natihehena hikiji hoka maisa waiyekehalakere homana. Hoka haxowakaite waiyekehalaka homana — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","— Maisaiya hatihita nokiji, xoana hiyekohaseyatya natyo hoka? nexa Pedro ihiye. — Maisaiya natihita hikiji hoka maisaiya noxaotyakirihare naokita hiso — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nexa Jesus hoka Pedro nexa ihiye: — Nikare atyo hoka hatihehena nokiji, nokahe, noseri hare, Xekohaseti — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","— Xala xamani atyo koxaka koaha hoka iyoma tyaona hoka ikiji taita katihakehitiya hoka ehekore. Koxaka xityotya xikatihakere xisaonita, hatita taita atyo hekota maiyomenehare akereta tyaonita — nexa Jesus Pedro hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus atyo waiyoreta hamatawatyasehare kakoa hoka: — Hatita taita atyo hekota maiyomenehare akereta tyaonita — nexa iraeta. ");
INSERT INTO pabNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hatyaoseta Jesus tiha ikijinaiha, miyatya hoka xane isoaheta haima ehaorete ako hoka tyokehetehitiya enekoniha hoka nehena ihiyeha: — Xoana waiyekehalaka xomana natihehenere xikiji? nexa axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","— Xasemehena: xiso atyo, “Xaotyakisatiye, Xekohaseti”, xita nohiye xiraihena nokakoi hoka. Ehekoreta nikare xita, hatyo terota atyo natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Xiyaiya, natyo xakore Xiyaotyakisase, Xiyekohase hoka natiha xikiji xomana. Maika nikare tehitiya xatiha kakoa xikijinai. ");
INSERT INTO pabNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Xiyaiya, naimenekoita xomana hoka namokitere akereta xamoka maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Waiye xasemehena: maisa wakahare haxekohase xahehare xini, exahe exaxikatyakahare hoka haxaxikatyasehare xahehare xini. ");
INSERT INTO pabNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Exe akiti waiyekehalaka xomana hoka xisaonaiya exema hoka waiyeya xihalahareya xisaona — nexa Jesus irae haxaotyakiraharenai kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","— Maisa atyo xityotya xiyaokaka xini niraeta. Haiyaharenai naohenere nomani kakoa atyo nawaiyoreta. Xakore hoka hatya atyoite nahalakoihare tyaona. Exe Iraiti Waiyexe nanekoa kaxairatyakehenere akeretaite kawenatyaka: Hatya kanakairitere nokakoite nahalakoihare tyaoheta. ");
INSERT INTO pabNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","— Kalikinita exehare niraeta nikare kawenatyakehenere nahitita hoka nikare kawenatyakehena hoka xityakekohena maheta natyo. Hiyaiya, natyo atyo natyota terota — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","— Xasemehena niraini: Xala xamani waiye mokita noxaxikaliharenai hoka waiye mokita natyo. Nikare waiye mokita natyo hoka noxaxikatyasehare tehitiya waiye mokita — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus hatyo tahi irai hoka enajikinita amaikoharehena hoka nehena ihiyeha waiyekehalaka: — Aliterexe niraeta: hatyaite xinekonitare mátawahena natyo — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nexa ihiyeha hoka exaotyakiraharenai wahakotyakakoaha. — Xala xaokaka nikare iraeta? nexa ahekotyaha. ");
INSERT INTO pabNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Exowaka hatya tyokita Jesus haliya Jesus awaiyetititere. ");
INSERT INTO pabNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tyokita Jesus haliya hoka Simão Pedro aimenekokoatya enomana axa maheta Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aimenekokoatya enomana hoka axehena Jesus: — Xalaite mátawahena hiso, Xekohaseti? nexa axa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Axa Jesus hoka Jesus nexa: — Nakairatite namaika hoka nisa enomana. Hatyo atyoite nomatawatyasehare tyaohena — nexa hoka nakairati maika hoka isa Judas Iscariotes ana. Judas atyo Simão Iscariotes nexarexe ityani. ");
INSERT INTO pabNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Isa enomana hoka Judas kanakaira hatyo nakairati hoka Ahalakoahaliti kamilakoretene. Hatyaoseta Jesus nexa ihiye: — Hiyanehena atyo hoka hisoma haokowitere hisomehena rotita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nexa Jesus irai ekakoa hoka nali tyokiterenai semene hoka maisa hatya ana hekoti waiyekehalakita. ");
INSERT INTO pabNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas atyo enoloxaha kaxaikotyasehare tyaonita enomanaha hoka motya Jesus axikatene nakairati iya maheta hisehaliti niyahare aokahitaha. Haiyanai motya Jesus axikatene hoka isa maheta olo maxiyehareharenai ana aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hoka Judas kanakaira hatyo nakairati isehenere enomana hoka xane rotita. Exowaka koxaka maka. ");
INSERT INTO pabNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas xaneheta enonyahitaha hoka Jesus nehena: — Kalikini Haliti Ityani kaxaexakerityaka, exahe Enore tehitiya hoka kaxaexakerityaka ihiyeta. ");
INSERT INTO pabNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Enore kaxaexakerityaka ihiyeta hoka Enore hiyeta atyoite Haliti Ityani kaxaexakerityaka. Kalinite Enore nikare mohena — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","— Exeta atyoite maisa waha notyaohitita xikakoa, nokaxaikoniharenai. Noxanihetaite xonita hoka xatawaite natyo hoka maisaite xikaokita natyo. Noxanihetehena hoka maisaiya xijoita noxanihenere nali. Koxaka noxakai hatyo akiti judeunai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Hoka kalikini exe iraiti waitare kakoa naotyakihitiya xiso. Maika xawaiyetyakakoa nawaiyetitere xiso akere xawaiyetyakakoa tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Xawaiyetyakakoaiya hoka tyotya halitinai anaiya waiyekehalaka hoka, “Hatyonai atyo Jesus xema nawenatyaseharenai”, nexahaiya xiyaokaka — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Hatyaoseta Simão Pedro axehena Jesus: — Alyakoite hiyanehena, Xekohaseti? nexa axene. — Awisa noxanihena hoka maisaiya atyo kalikinita hiyaneta noxanihenere nali. Hoka haxowaka atyoite hisoa noximi — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","— Xoana hoka maisa kalikinita notyoa hiyema haokita? Koxaka nomimiye notyaonita nokamani niyahare hikakoa — nexa Pedro irai. ");
INSERT INTO pabNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","— Xoana, alitere haokita? nexa Jesus. — Hasemehena niraini: Awisa takoira makawiraharenetaite hehena: “Exe haliti atyo maisa nowaiyanihare xini”, hexaite noxaokaki. Exakere ite hanamaki hirae — nexa Jesus Pedro niraine nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","— Awa atyo ximawaiyehare — nexa Jesus haxaotyakiraharenai hiye. — Koxaka Enore xityakeko. Maika xityakeko tehitiya natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","— Baba nawenakala nali kahare hati wenati niyahare. Memere ite namoka hati xomanere. Maisaiya nikarexe hoka koxakaiya noxakaini xihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Noxanite hoka memere namoka hoka nahaikoahetaite hoka nanoloka xiso hoka xisaona nohaliye — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","— Koxaka xawaiyore hatyo noxanihenere nali akiti kakoa, exahe ahotyaho noxanihenere aho kakoa hoka xawaiyoreta — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","— Maisa wawaiyoreta hatyo hiyanehenere nali akiti kakoa. Aliyakereya hoka wawaiyore hatyo ahotyaho hiyanehenere aho kakoa? nexa Tomé axene. ");
INSERT INTO pabNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","— Natyo atyo ahoti. Iraiti aliterexe atyo natyo. Nohiyitita haliti tyaona mene matyotenehare. Nohiyitita taita atyo kakáokatyakita Baba Enore nali. ");
INSERT INTO pabNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kalikini atyo xiyaita natyo hoka xiyaiya tehitiyaite Baba. Hoka kalikinitata xiyaitene. Xiyaiyanehare terota atyo — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","— Xekohaseti, hahotikisa Hexe womana hoka ehekore womana — nexa Filipe. ");
INSERT INTO pabNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","— Wahehena notyaonita xinekoni, Filipe. Xoana, maisa hiyaiyanehare xini natyo, exahe nawenani hoka waiyekehalakere homana? Xala xamani atyo waiyita natyo hoka waiyita tehitiya atyo Baba. Xoana hoka, “Hahotikihena Hexe womana”, hita? Koxaka xiyaiyene. ");
INSERT INTO pabNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Xoana motya maisa Baba tyaonare nokakoi haokita? exahe natyo hoka motya maisa notyaonare ekakoa haokita? Niraihena xikakoa hoka maisa natyota xini niraeta. Baba tyaonita nokakoi hoka tyomita hahatene noxaihako maniyita. ");
INSERT INTO pabNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Baba tyaonita nokakoi, exahe natyo hoka notyaonita ekakoa. Maika hatyo akiti xityakeko, maisa namaoseraita xini. Maisa xityakekota niraini hoka maika xityakeko natyo maomakahare notyomitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Hatyaiya tyakeko natyo hoka tyomaiya notyomitere akereta. Ekakoitaiya hatyonai xahehare tyomehena. Maikoisa Baba Enore nali noxanihena hoka hatyaosetaite notyomitere xahehare tyomehena. Alitere naokita, maisa namaoseraita xini — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","— Nexare kakoaiya xaxehena hoka tyotyaiya notyoma xaokitereharenai xomana. Notyomeniya xomana Baba kaxaexakeretyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xoare xamaniya xaxa nexare kakoa hoka tyotya notyoma xomana. ");
INSERT INTO pabNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","— Aliterexe xawaiyetita natyo hoka maika xasemaxematya niraini, xoalini hare naohena xihiye hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Xasemaxemaitaiya niraini hoka naxaiya Baba hoka axikatya xomana xikahinaetyase maheta Isekohaliti Waiyexe hoka tyaoneta mene xikakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hatyo Isekohaliti Waiyexe atyo maisa maoseratyaliye xini. Maisa atyo matyakekoneharenae ana kaotyakita. Maisa waiyarahene, exahe waiyekehalakere enomanaha. Hoka hatyo Isekohaliti Waiyexe atyo xiyaiyanehare. Maika tyaona mene xikakoa — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","— Noxanihetehenaite xonita hoka maisaiya ximakaxaikotyakahare nahalakijita. Nahaikoahetaite xomana. ");
INSERT INTO pabNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Iniraite notyaohitiya hoka hatyohekotaite maisa nokawaiyakihitita, maisaiya matyakekoneharenai waiyihitita natyo. Hoka xiso atyoite xiyaiyeheta natyo. Nowainite hoka nokaseheta hoka xiyaiyeheta natyo. Nokasehetaite hoka hatyota atyoite maisa nowainihitita hoka xiso tehitiyaite xiwaini hoka xikaseheta hoka hatyota maisa xiwainihitita. ");
INSERT INTO pabNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Exowakehenaite hoka waiyekehalaka xomana notyaonitere Baba kakoa, exahe xiso xisaonitere nokakoi notyaonitere xikakoa akereta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","— Hatyaiya tyaonita niraini xema hoka hatyoiya atyo awaiyetita natyo. Hatyo awaiyetitere natyo atyoite Baba awaiyetya, exahiya natyo hoka nawaiyetene hoka nahotikisoawiya enomana — nexa Jesus aotyakisa haxaotyakiraharenai. ");
INSERT INTO pabNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hatyaoseta Judas iraihena. Maisa Judas Iscariotes xini, hatya Judas nexarexe iraihena Jesus kakoa: — Aliyakeriya hahotikisoahena womana hoka maisa matyakekoneharenai ana hahotikijoita? nexa axa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","— Xala xamaniya awaiyetita natyo hoka tyaonita niraini xema hoka Babaiya awaiyetene. Hoka Baba natyo xoahaiya wisoa wisaona ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Xala xamaniya maisa awaiyetita natyo hoka maisaiya tyaonita niraini xema. Hoka exe iraiti xasemitere atyo noxaxikatyasehare Baba niraine, maisa atyo niraini xini. ");
INSERT INTO pabNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Hekotata notyaonita xihaliya hoka hatyo akiti niraeta xihiye — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","— Baba ite axikatya xomana xikahinaetyase Isekohaliti Waiyexe noxaokalita. Kaokaite xomana hoka aotyakihena xiso kahare hoka xotyaxemaheta tyotya niraihenere xikakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nahalakisaite nomehexaikohalini xikakoa. Nisaite nomehexaikohalini xomana. Nowawi nikare namokita haliti, maisa waikohekoarenai namokitere akereta mokare. Awaira atyo ximawaiyeharehena, exahe ximairehena — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","— Koxaka xasema niraini: “Noxanihetaite hoka nahaikoahetaite xomana”, nomi xihiye. Xawaiyetitaiya natyo hoka xasema noxaniniheta Baba nali hoka xihalahareya, Baba atyo noxahehare hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kalikinita exeharenai tahi noxakaita xihiye enaheta maniyita hoka nikare tyaohena hoka xityakeko maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","— Exeta atyoite maisa waha niraihitita xikakoa. Owene matyakekoneharenai xekohase kaokehena womana, maisa xakore atyo noxahehare niyatere xini hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kasani tyotya waikohekoarenai ana waiyekehalaka Baba nawaiyetitere naokita. Hiyeta hoka aokitere akereta notyomita — nexa. — Xatityoahetehena hoka wiyanehitiya — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","— Natyo atyo uva kate akere hoka Baba Enore atyo uva kate kaxaikotyasehare akerexe. ");
INSERT INTO pabNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Xiso noximi maniya xisaoniterenai atyo ekanohinae akerexe. Hoka uva kaxaikotyasehare irikoita tyotya malihare kanohinae, exahe afiraharetita kalitere kanohinae masakare kali tyaonaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hoka xiso atyo ekanohinae exafiraharetyakahare akere xisaonita, koxaka naotyakisa xiso hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Maika xisaoneta mene nohiye, exahe natyo hoka notyaoneta mene xihiye. Hiyaiya, uva kate kanohi taikoahena hakate hiyeta hoka maisa kalihetere. Hoka hekota tyaonita hakate hiye hoka kalita. Nikareya maisa xisaonita nohiye hoka maisaiya aliyakere xoalini hare waiyexe xisomita — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","— Natyo atyo uva kate akerexe, xiso atyo ekanohinae akerexe. Ekanohi hakate hiye tyaonita hoka kahare kalita. Nikarexe xisaona nohiye hoka kahare xoalini hare waiyexe xisoma. Hoka maisaiya xisaonita nohiye hoka maisaiya xoare hare xisomita. ");
INSERT INTO pabNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","— Uva kate kanohi taikoahena hakate hiyeta hoka haxerore inira tyaonita hoka ekaxaikotyasehare awaiyetolisene hoka keraitene. Maisaiya xisaonita nohiye hoka nikareya xikaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Xisaona nohiye exahe niraini xema xisaona hoka xoalini hareya xaxehena Baba hoka tyomeniya xomana. ");
INSERT INTO pabNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Uva kate kanohi kahare kali hoka waiye. Nikare xisaona noximi maniya hoka kahare xoalini hare waiyexe xisoma hoka Baba kaxaexakerityaka, exahe xiso hoka noximi nawenatyaseharenai naoka — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","— Baba awaiyetita natyo. Hatyo awaiyetitere natyo akereta nawaiyetita xiso. Nawaiyetita xiso. Maika hatyo xema xisaona. ");
INSERT INTO pabNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Waiye xasemaxematya niraini hoka nawaiyetyaiya xiso. Xiyaiya, natyo tehitiya Baba niraine waiye nasemaxemaita hoka awaiyetita natyo. ");
INSERT INTO pabNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","— Exe akiti noxakaita xihiye waiye xawenane tyaona maheta xomana hoka xihalahare kaiserehare xisaona maheta — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","— Exe tehitiya naoka xihiye: Maika xawaiyetyakakoa nawaiyetitere xiso akereta. ");
INSERT INTO pabNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hatyaiya awaiyetita kaiserehare hahinaeharenai hoka memereya tyaona hoka wainiya hahinaeharenai wenekoare. ");
INSERT INTO pabNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","— Naokitere akeretaiya xisaona hoka nohinaeharenaiya naoka xiso. ");
INSERT INTO pabNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Maisaiya wakahare naokita xiso. Wakahare atyo maisa waiyorexe haxekohase xahekola kakoa. Hoka natyo atyo nohinaeharenai naokita xiso. Kahare Baba nalita nasema iraiti hoka tyotya noxakaini xihiye, nohinaeharenai naokita xiso hoka — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","— Maisa xiso xini xaoka natyo xomana. Natyo atyo naoka xiso nomani. Naoka xiso nomani. Uva kate kanohi kahare kalitere akere xisaona naokita, hoka kahare waiyexe xisoma naokita. Nikareya xisaona hoka maisaiya xománenai waiyexe kamaotyanetyakita, exahe xoalini hare xaohena Baba hiye hoka niraini kakoarenaiya xiso hoka tyomeniya xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","— Hiyeta hoka maika xawaiyetyakakoa. Xawaiyetyakakoa naokita hoka nikare niraeta xikakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","— Maika matyakekoneharenai kirawanehena xiso hoka xotya natyo. Natyo hotohare kirawanehenahere. ");
INSERT INTO pabNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hatyonai akeretaiya xiso hoka awaiyetyahaiya xiso, ihinaeharenai xisaohenere hiyeta. Kalini atyo xiso maisa matyakekoneharenai akereta xini. Koxaka atyo enekonitaha nomániye naoka xiso hoka hatyo hiyeta kirawanahitaha xiso. ");
INSERT INTO pabNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xotyaira niraini: “Maisa wakahare haxekohase xahehare xini”, nomi xihiye. Nikare hoka iniyalahariya mokaha natyo hoka iniyalahare tehitiyaiya mokaha xiso. Tyaonahaiya noxaotyakiri xema hoka xiyaotyakira xema tehitiyaiya tyaonaha — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","— Maika iniyalahare mokaha xiso nohiyiti. Hiyaiya, maisa atyo noxaxikatyasehare Enore ewaiyanehareha xini. ");
INSERT INTO pabNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Awaiya natyo notyoa niraeta ekakoaha hoka maisaiya háomaneha ewaxirahare kehexahitaha, waiyekehalakita enomanaha. Hoka notyoa nirai ekakoaha hoka maisaiya atyo aliyakere teraharetyoahenahititaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","— Xala xamani atyo kirawaneta natyo hoka Baba tehitiya atyo kirawaneta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","— Kahare maomakahare waiyexe notyoma enekoniha. Maisa xala harenae notyomitere akere tyomare. Ekoiya awa notyomita enekoniha maomakahare hoka maisaiya kehexareha iniyalahare háomaneha. Enekoniha notyoma hoka waiyaha hatyo hoka ihiyeta kirawanetaha natyo, exahe Baba tehitiya kirawanetaha — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","— Exakerexe xairatyoare tyaonita exaotyakisakahoha: Maxemerehareta kirawaneha natyo. — Nikare xairatyoare tyaonita hoka hatyo hiyeta kirawaneha natyo xairatyoare tyaonitere akereta kawenatyaka maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","— Ite Isekohaliti Waiyexe kaoka xomana xikahinaetyase maheta. Aliterexe taita atyo iraeta. Baba nalita atyo tyoita, naxikatenite xomana hoka xakaihenaite notahi akiti xihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Xiso tehitiyaite xiyakaihena notahi akiti halitinai hiye. Hetati xowakiyata xisaonita nokakoi hoka kahare nománi xiyaiya hoka hatyo akiti ite xiyakai ihiyeha — nexa Jesus aotyakisa haxaotyakiraharenai. ");
INSERT INTO pabNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","— Nikare nirai xikakoa hoka maisa xamaikohare, ximawaiyehare maheta xini — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","— Maxisoanityahaite xiso xahohisakoatyakalati hanako. Ekakoitaite aisaha xiso hoka motyaite Enore wini hekoreta aisahitaha xiso aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nikarite mohenaha xiso, maisa Baba akiti waiyekehalakere enomanaha hoka, exahe natyo hoka maisa nawaiyekehalakere enomanaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hatyohare akiti noxakaita xihiye hoka nikare tyaohenaha hoka xotyaxematya niraini maheta hoka, “Hatyo akiti xakai wihiye”, xexa maheta — nexa Jesus. — Maisa toahiyita noxakaita exe akiti xihiye, hekotata notyaonita xinekoni hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Hoka kalikini atyoite noxanihetehena noxaxikatyasehare nali. Xakore hoka maisa xala harenai axita natyo: “Alyakoite hiyanehetehena, Xekohaseti?” maisa nita nohiye. ");
INSERT INTO pabNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","“Awisa noxanihetehena xonita”, nomi noxakai xihiye hoka kalore xamaikohareheta. ");
INSERT INTO pabNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Maika waiye xasema niraini: ehekore atyo noxaniheta xonita. Nomaxaninihareya atyo xonita hoka maisaiya atyo haliti kahinaetyase Isekohaliti Waiyexe tyoita xomana. Hoka noxanihetaiya atyo hoka naxikatene xomana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","— Isekohaliti Waiyexe atyoite tyohena hoka matyakekotiterenai hiye iraihena: “Xoana hoka iniyalahare xisomita? Waiye maniyaira xisaona! Enorite iniyalahare nomaseharenai mawenekoaretyaka aohena”, nehenaite ihiyeha hoka semehenaha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Maisa tyakekoahitaha natyo hoka hatyo atyo maisa ehekoreta. ");
INSERT INTO pabNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Noxanihetaite Baba nali hoka maisaite xiyaiyehitita natyo. Hatyohare akiti kakoa maisa ehekore ahekotyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Exahe matyakekoneharenae xekohase Tihanare mawenekoaretyaka aoka Enore — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","— Kaharetata niraini xikakoa, hoka maisaiya atyo kalikini noxakaitene xihiye, waiye aliya hoka kaxiyehare xiyahekola tyaona xomana. ");
INSERT INTO pabNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hoka Isekohaliti Waiyexe atyoite kaokehena hoka awaiyekehalakatya tyotya iraiti aliterexe xomana. Maisaiya atyo haxahekolita iraeta, hasémane atyoite xakaihena xihiye, exahe xakaihena atyoite kahare xoalini hare tahi emakaotyakenehareta. ");
INSERT INTO pabNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iraihenaite xikakoa hoka awaiyekehalakahena niraini, notahi akiti xomana hoka ihiyetaite nokaxaexakeretyaki. ");
INSERT INTO pabNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tyotya Baba anerenai atyo nomaniye tehitiya hoka Isekohaliti Waiyexe ite tyoa hoka awaiyekehalakatene xomana hoka waiye xasema — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","— Ininaitehena hoka ximawaiyanenehena natyo hoka hatyaosetaite mawahaneta hoka xiyaiyehitiya natyo. Hiyaiya, noxanihenaite Baba nali — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Hatyaoseta exaotyakiraharenai iraikakoahenaha: — Xoare nexala aokowita hoka nikare iraeta wikakoa? Exakere nita: “Ininaitehena hoka ximawaiyanenehena natyo hoka hatyaoseta mawahanetaite hoka xiyaiyehitiya natyo”, nita. Exahe, “Hiyaiya, noxanihenaite Baba nali”, nita xoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Xoare nexala aokowita hoka nikare iraeta? “Mawahanetaite”, nita. Maisa waiyekehalakita iniraine womana — nexakakoa exaotyakiraharenai. ");
INSERT INTO pabNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Axahene aokowitaha hoka Jesus otene hoka nehena ihiyeha: — Nomikira xihiye: “Ininaitehena hoka ximawaiyanenehena natyo hoka hatyaosetaite mawahaneta hoka xiyaiyehitiya natyo”, nomi xihiye. Xoana, hatyo akiti xaxakakoita? nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","— Noxanihetehenaite hoka xitiya xamaikohare kalore hoka matyakekoneharenaite ihalahareha. Alitere atyoite xamaikoharehena hoka hatyaosetaite xiyamaikoharene atyoite tyoteheta xonita hoka xihalahareheta. ");
INSERT INTO pabNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ohiro hiye xoima kawehena hoka amaikohalota, ekahe aosehena ihiye hoka. Hoka tyaona ityani ihiye hoka hatyo najikinita ihalahalohitita, maotyanehitita hawaolitini, tyaona ityani ihiye hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Hatyo akereta tehitiya xiso. Kalikini atyo xamaikohareta hoka haxowakiyaite nowaiyehetehitiya xiso hoka xihalaharehetaite hoka maisaiya atyo xala harenai examaikoharenekihitita xiso — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","— Hatyo ferakene ite xane hikoahena hoka maisaiya xoalini hare xaxita natyo. Hoka nexare kakoaiya xaxa xoalini hare Baba hoka isiniya xomana. ");
INSERT INTO pabNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kalikini kijiya maisa xoare hare xaxehenere nexare kakoa. Xaxeniya hoka isiniya xomana masakare xihalahare xisaona maheta — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","— Iraiti metaharexe niraini namokita xomana hoka enaose xane hikoahena hoka maisaiya atyo nikare niraihitita. Hoka waiyekehalaka taita atyoite niraihena xikakoa Baba tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hatyo xowakaite xaxene xoalini hare nexare kakoa. Natyoiya atyo maisa xoare maheta niraeta xitahi ekakoa, Baba koxaka awaiyetita xiso hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Baba awaiyetita xiso hoka xaokitere akeretaite mohena xiso nomairainihareta ekakoa. Xiso atyo xawaiyetita natyo, xityakekota notyoanini Baba nalita hoka hatyo hiyeta Baba awaiyetita xiso — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","— Notyoa Baba nalita hoka notyaona ali halitinai koni hoka kalikini nahalakisa halitinai hoka noxanihetehena Baba nali xeta — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nexa ihiyeha hoka exaotyakiraharenai nehenaha ihiye: — Kalikini atyo hiraine waiyekehalakita womana, maisa atyo metahare hiraine hamohitita womana. ");
INSERT INTO pabNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hiso atyo tyotya hakakoare kakoa hawaiyoreta, maisa atyo xoare hare kakoa himawaiyorenexe, hoka maisaiya waxehitita hiso, hiraine waiyekehalakita womana hoka. Hiyeta hoka Enore nalitare terota waoka hiso — nexaha Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Hatyaoseta Jesus nehena: — Xoana kalikini xityakeko? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","— Kalikini atyo xiyexaoretyakaose xane hikoa hoka xiyaorehenaite xihananae nihatyaka hoka nowawite xahalakisa. Xakore atyoite hoka maisa atyoite nowawi xini xahalakisa. Baba atyo tyaonita nokakoi — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","— Exeharenai niraeta xihiye xisaona noximi maniya hoka waiye ximehexaiko xisaona maheta. Matyakekoneharenaite maisa waiye mokahitaha xiso xakore hoka maika xihalahare xisaona. Nojiyahaotya atyo matyakekoneharenai exekohaseha kakoita — nexa Jesus haxaotyakiraharenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Hatyo irai najikinita hoka Jesus wahakotya enokoa xeta hoka nexa iraexahena: — Nokamani aose xane hikoa, Abá. Maika haerorehena natyo Hityani hoka natyo tehitiya naeroritya Hiso. ");
INSERT INTO pabNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tyotya halitinai xahehare hamoka natyo, tyotya noximi maniya hamohenerenai menanehaliti namoka haokita hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hiso taita atyo Enore, natyo atyo hiyaxikalahare Jesus Cristo. Hatyohareya waiyekehalaka halitinai ana hoka hiyema maniyaiya, noximi maniya xoahaiya tyaonaha hoka menanehalitiya tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","— Nohateni haokitere notyoma namiyatya. Namiyatene hoka ihiyeta halitinai aexakerityahitaha hiso — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","— Hetati waikohe maomakaharetatere xowakiya Kalorexe notyaonita hinali, Abá. Kasani kalikini haerorehena natyo naoka hoka hetati xowakiya akereta Kalorexe notyaoheta. ");
INSERT INTO pabNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","— Haiyanai haliti hiyeheta matyakekoneharenai konita hoka hamokahene nokoamaniye, tyaonaha maheta niraini xema. Hoka natyo atyo nawaiyekehalakatya hiso enomanaha. Homanerenai terota hoka noximi maniya hamokahene hoka hiraine xema tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hiso atyo kahare xoalini hare koxaka hisa nomani. Tyotya hatyohare hinalitarenai akiti waiyekehalakita noxaotyakiriharenai ana — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","— Koxaka hiraine hiyakai nohiye hoka noxakai ihiyeha hoka tyaonaha hiraine xema. Natyo atyo notyoa hinalita, hiso atyo haxikatya natyo. Hatyo akiti tehitiya noxaotyakiriharenai tyakekoha. ");
INSERT INTO pabNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","— Kasani hikaxaikoahene naoka hoka hatyo hiyeta niraexatya etahiha hihiye. Maisa atyo tyotya haliti tahi xini niraexatita hihiye, maisa matyakekoneharenai tahi xini niraexaita. Exe nokoamaniye hamohenerenai tahi taita atyo niraexatita, homanerenai hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tyotya nokoamaniye tyaohenerenai atyo homanerenae tehitiya hoka homanerenai tehitiya atyo nomaniyenai. Nokoamaniye tyaonahitaha hoka ihiyetaha nokaxaexakerityakita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","— Kalikini atyoite notyohetehena hinali xeta, maisa atyoite halitinai koni notyaohitita. Hoka noxaotyakiriharenai atyoite alitehena halitinai koni. Maika hikaxaikohena noximi maniya hamohenerenai, Abá, hoka hiyema maniya tyaonaha waiye, exahe exahekolaha hoka hakakoa tyaohena enomanaha hoka wiyahekola hakakoa tyaonitere akereta ahekohenaha. ");
INSERT INTO pabNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Matyakekoneharenai koni notyaonita ekakoaha hoka nokaxaikoahene hijitere kakoa. Hiso atyo nokoamaniye hamokahene hoka waiye nokaxaikoahene hoka maisa hatya hekoti halakijita hawenane hiyaotyakira xema maniya. Hatita taita atyo halakisa hatyakekone, hamawenekoaretyaka xetare terota hoka. Etahi akiti atyo kaxairatyaka Iraiti Waiyexe nanekoa hoka aokitere akereta kawenatyaka maheta hoka halakisa hatyakekone. ");
INSERT INTO pabNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","— Kalikini notyohetehena hinali xeta. Hekota halitinai koni notyaonita hoka exe akiti noxakai noxaotyakiriharenai hiye, kasani ihalahare tyaonaha naokita hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Noxakai hiraine ihiyeha hoka matyakekoneharenai kirawanahene, maisa hatyoha akerexeha xini hoka. Noxaotyakiriharenai atyo maisa matyakekoneharenai akereta xini, exahe natyo hoka maisa matyakekoneharenai akerexe xini — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","— Maisa hiyehenahitene halitinai konita naokare. Kasani hikaxaikoahene Tihanare xoalini hare iniyalahare nonitata naokita. ");
INSERT INTO pabNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Natyo atyo maisa matyakekoneharenai akereta xini, exahe noxaotyakiriharenai hoka maisa hatyonai akereta xini. ");
INSERT INTO pabNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hiyaotyakira atyo waiyexe, aliterexe. Maika haotyakisa noxaotyakiriharenai hoka waiye tyaonaha hikoamaniya. ");
INSERT INTO pabNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","— Hiso atyo haxikatya natyo halitinai koni. Nikareta natyo tehitiya naxikatya noxaotyakiriharenai halitinai koni awaiyekehalakatya maheta hiraine. ");
INSERT INTO pabNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Noxaotyakiriharenai hiyeta hikoamaniya terota notyaona naokowi. Hikoamaniya terota notyaona naokowi hatyonai sema Iraiti Waiyexe hoka hikoamaniya tehitiya waiye tyaonaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","— Maisa noxaotyakiriharenai tahi taita xini naxita hiso, Abá. Maikaite haiyanai iniraineha semaha hoka noximi maniya tyaohenerenae tahi tehitiya naxita hiso. ");
INSERT INTO pabNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kasani exahekolaha hakakoa tyaona enomanaha naokita. Hiyaiya, noxahekoli, hiyahekola xoaha atyo hakakoa, Abá. Kasani wikoamaniya tyaonaha naokita, Abá. Hiso atyo haxikatya natyo halitinai koni. Kasani noxaotyakiriharenai hakakoa ahekotyaha naokita hoka matyakekoneharenai hiyaxikalahare terota aokaha natyo maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","— Hihiyeta nokaxaiminisakita hoka hatyo hiyeta tehitiya noxaotyakiriharenai kaxaiminisakita hamaniya taita exahekolaha tyaona maheta wiyahekola hamaniyita tyaonitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Natyo atyo notyaonita noxaotyakiriharenai kakoa hoka hiso hoka hisaonita nokakoi noxaotyakiriharenai waiye tyaona maheta, exahe hamaniya taita ahekohenaha maheta. Hiso atyo haxikatya natyo halitinai koni, exahe hawaiyetya natyo, exahe hawaiyetya tehitiya noxaotyakiriharenai. Kasani halitinai ana hatyohare akiti waiyekehalaka naokita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","— Abá, kasani nokoamaniyi hamohenerenai nohaliye tyaonaha naokita hoka nawenani kalorexe waiyaha maheta. Hiyaiya waikohe maomakaharene xowakita atyo hawaiyetita natyo — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","— Hiso atyo hawaiye, Abá. Xakore hoka matyakekoneharenai maisa waiyare hiso, exahe hitahi akiti hoka maisa waiyekehalakere enomanaha. Hoka natyo atyo nowaiyita hiso. Hiso atyo haxikatya natyo ali xeta. Hatyo akiti waiyekehalakita noxaotyakiriharenai ana. ");
INSERT INTO pabNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Koxaka naotyakisahitene hitahi akiti kakoa. Naotyakisahenite hoka hatyo akiti waiyekehalaka enomanaha hoka tyaonahitaha hikoamaniya. Hiso atyo hawaiyetita natyo hoka hatyo akereta awaiyetyakakoaha naoka, exahe natyo hoka waiye notyaona ekakoaha naokita — nexa Jesus iraexatya Enore hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus halakisa hairaexala hoka hikoa xane haxaotyakiraharenai kakoa one hiyase Cedrom nexarexe halakoiya. Hanakati tyaonitere atya ime kakoare nali Jesus xane ekakoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesus kahaliki nali xane haxaotyakiraharenai kakoa hoka ematawatyasehare Judas tehitiya waiyita hatyo nali. ");
INSERT INTO pabNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jesus xane kaoka hatyo atya, ime iyiti kakoare akiti hoka wahasehena tyaonita hoka Judas tyoa kaokehena hatyo nali sorarenai kakoa, Iraexatyakalati Hana kaxaikotyasenai hare kakoa tyoa kaoka hatyo nali. Sacerdotenai, fariseunai xoaha xekohasenai axikatyahene Judas xema. Kesekase, xaokanatyakalati hare kolatyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Koxaka atyo Jesus hatyo nikare mohenaherene akiti otita haheta maniya. Atyahita exahitaha hoka kaokehenaha enomana hoka xane ahalakoatyahene hoka nexa ihiyeha: — Xala xatawita? nexa axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","— Jesus Nazaré tare watawita — nexaha. — Natyo — nexa Jesus ihiyeha. Exowaka ematawatyasehare Judas enekoniha tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","— Natyo — nexa taita Jesus ihiyeha hoka haikoahaxahenahitaha hoka exoaha waikoa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","— Xala xatawita? nihitiya Jesus ihiyeha. — Jesus Nazaré tare watawita — nehenahitiyaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—“Natyo”, nomita xihiye. Aliterexe atyo natyo xatawita hoka maika exenai xahalakisa hoka xanehenahitaha — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesus iraexaitere Enore hiye xowakiya nexa: “Hiso atyo nokoamaniye hamoka noxaotyakiriharenai hoka nokaxaikoahene hoka maisa hatya hekoti halakijita hawenane hiyaotyakira xema maniya”, nexa hatyo xowakiya. Hoka sorarenai tyoa hikoaha enomana hoka, — Maika exenai xahalakisa hoka xanehenahitaha — nexa Jesus sorarenai hiye, iraexahenere akereta kawenatyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hatyaoseta Pedro iya hakeserakase initini akota hoka Malco nexarexe tinihe aikotya, ifihini maniya. Malco atyo sacerdote kalorexe wakanehare. ");
INSERT INTO pabNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Hatyaoseta Jesus nexa iraehena Pedro hiye: — Hamohetehena hikeserakase initinako. Baba Enore isa nomani erati notera maheta. Xoana, motyaite maisa noteritene haokita? nexa Jesus Pedro hiye, makawati kaxomokakehenere xaokaka nikare iraeta hatahi. ");
INSERT INTO pabNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hatyaoseta sorarenai exekohaseha kakoita, Iraexatyakalati Hana kaxaikotyasenai hare otokaha Jesus hoka olatyahene. ");
INSERT INTO pabNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Otokahene, olatyahene hoka xaneha Caifás nimatyokoe Anás hana xeta ekakoa. Hatyo xowaka terehokoane Caifás sacerdotenai xekohase tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Koxaka Caifás nexa irai judeunai xekohasenai hiye: “Maika hatya haliti waini tyotya halitinae ana hoka ehekore”, nexa irae. ");
INSERT INTO pabNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Xaneha Jesus kakoa hoka Simão Pedro hatya Jesus xaotyakirahare xoaha xaneha exema. Hatyo Jesus xaotyakirahare atyo sacerdotenai xekohase waiyanehare hoka hatyo tehitiya atyo isoa Jesus kakoa Anás hana talahokolako. ");
INSERT INTO pabNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Hoka Pedro atyo hekota hati talahokola kanase nali. Hatyaoseta ihinaehare sacerdote kalorexe waiyanehare hikoaheta hoka irae hati jihola kaxaikotyasero hiye hoka noloka Pedro aisoakisa hati talahokotyakako. ");
INSERT INTO pabNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hatyaoseta jihore kaxaikotolo nehena Pedro hiye: — Xoana hiso tehitiya exe haliti xaotyakirahare? nexa axene. Hoka Pedro nexa: — Maisa atyo exaotyakirahare xini natyo — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kala tihita wakaharenai, sorarenai hiye hoka airatyaha hoka tyoa hatyo haliya tityoa hoka jijikoaha. Hatyaoseta Pedro isoa enekonyaha jijikoa maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Hatyaoseta sacerdotenai xekohase axa Jesus exaotyakira, exaotyakiraharenai tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Axene hoka Jesus nexa ihiye: — Tyotyaha ehaotya hitaha niraeta. Nikare naotyakisahitene Iraexatyakalati Hanako, xahohisakoatyakalati hanako hare. Hoka maisa atyo xoana xowaka xoare metereta niraexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","— Xoana hoka haxita natyo? Kahare halitinai sema niraini. Maika hatyonai haxa hoka xakaihaha hihiye — nexa Jesus sacerdotenai xekohase niraine nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nikare Jesus iraeta ene hoka hatya sorare mokotene itihokoa. — Xoana hoka nikare hiraeta sacerdotenai xekohase kakoa? nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","— Xoare nomi namaoseratya hoka hamokotya natyo? Aliterexe niraeta hoka xoana hoka hamokotya natyo? nexa Jesus iniraine nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hatyo najikinita Anás axikatya Jesus olatyoaretata haxaise Caifás hana nali xeta. Exowaka Caifás sacerdotenai xekohase tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Hoka Pedro atyo hekota irikati haliya jijikoita hoka axehenahitiyene: — Kala maisa hoka hiso tehitiya exe haliti xaotyakirahare — nexaha. — Maisa natyo xini — nexa Pedro teraharetyoa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Hatyaoseta sacerdotenai xekohase wakanehare axehitiyene: — Motya akere hiso hare nowaiya ekakoa etake atya, ime hare kakoare tyaonitere nali. Xoana alitere? nexa ihiye. Pedro aikotinihenere hinaehare nikare iraeta ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Hoka Pedro nexa: — Maisa natyo xini — nexa teraharetyoahitiya. — Maisa natyo xini — nexa taita hoka takoira kawisa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hatyaoseta xaneha Jesus kakoa Caifás hana nalita kalorexe Pilatos hana nali xeta. Exowaka weta. Xaneha ekakoa hoka maisa isoareha ekakoa kalorexe hanako, hisehaliti Páscoa nakaira kanakairaha aokowihenaha hoka. Isoahaiya majudeuneharenai hanako hoka aiyalaharetyahaiya hawenaneha hoka maisaiya aliyakere kanakairahitaha Páscoa nakaira. Nikare atyo exaotyakisakahoha hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Maisa isoahitaha Pilatos hanako hoka hikoa enomanaha sema maheta enomanaha. — Xoare xemere nikare xamokene? nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","— Ekoiya waiyexe haliti hoka maisaiya wotokene hoka wijoita homana ekakoa — nexaha Pilatos hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","— Kala xiyane ekakoa hoka waiye xasema etahi hoka xinaho maniya akereta xamokene — nexa Pilatos ihiyeha. — Maisaiya aliyakere waijita haliti. Waiseniya hoka maisaiya waiyeta Roma yerenai hiye — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Koxaka Jesus irai haxaisaka tahi akiti hoka hatyo hakamane aohenere akereta efaharenai mokene, Jesus niraine akereta kawenatyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hatyaoseta Pilatos isoahetehitiya hahakatyakala ako hoka kawisa Jesus hoka axehenene: — Xoana alitere judeunai xekohase hiso? nexa axehenene. ");
INSERT INTO pabNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","— Xoana hisota nikare hahekotya hoka nikare haxita natyo? Hatya kore nikare irae notahi akiti hoka haxita natyo? nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","— Xoana judeu yatya natyo hoka? Sacerdotenai xekohasenai, haiyaharenai hare, hisoharero makere atyo nolokaha hiso nomani hoka hiyaisaka aokaha nohiye. Xoare hisoma hoka nikarahitaha? nexa Pilatos Jesus hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","— Kalorexe xakore atyo natyo hoka maisa atyo aliyere kalorexene xini natyo. Aliyere kalorexeya natyo hoka nowakaniharenaiya xalijinihareha hoka maisaiya judeunai otokahitaha natyo. Hoka maisa atyo aliyere kalorexe xini natyo — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","— Nikare hoka kalorexe atyo hiso? nexa axehitiyene. — Hiso atyo kalorexe haokita natyo — nexa Jesus. — Hatyo niyahare terota notyaona halitinai koni noxakai maheta iraiti aliterexe ihiyeha. Tyotya iraiti waiyexe awaititerenai atyo semaxemaita niraini — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","— Xoare iraiti aliterexe haokita? nexa Pilatos Jesus hiye hoka hikoahitiya hoka xane iraihitiya judeunai hiye. Hikoahitiya enomanaha hoka nehena ihiyeha: — Maisa xoare iniyalahare nasemita etahi akiti. Maisaiya xoare xemere kaxaisakita — nexa. ");
INSERT INTO pabNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","— Hoka xinaho maniya atyo terehokoakiti nihatyaka hisehaliti Páscoa xowakehena hoka hatya berexo ako tyaonitere nahalakihitita xomana. Hoka xoana judeunai xekohase nahalakiheta xomana xaokita? nexa Pilatos axahene. ");
INSERT INTO pabNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","— Maisa exe kahalakisakeheta waokare. Maika hahalakiheta Barrabás womana — nexaha kinatyaxa kawiyatyaha enomana. Hatyo Barrabás atyo haliti fahare. ");
INSERT INTO pabNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Exowakerota Pilatos Jesus mokonasetyaka aoka. ");
INSERT INTO pabNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Hatyaoseta sorarenai tyomaha xolatyaolisoakalati katohere kakoare hoka mokahene eseri hiye, exahe imitinase xotere ako aisoakisahene. ");
INSERT INTO pabNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","— Hawaiyeta womana, judeunai xekohase — nexa koexahaxatyaha ekakoa, itihokoa hare mokotyahene hakahe kakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hatyaoseta Pilatos hikoahitiya hoka iraihitiya judeunai kakoa: — Naihikoatenite xomana hoka xiyaiya! Hoka xasemehena: Natyo nomani atyo maisa xoare hare iniyalahare tyomare — nexa Pilatos ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nexa hoka aihikoatya Jesus enomanaha. Katohere seriyeta, imiti xotere nasakoreta hikoa enomanaha. — Xiyaiyehenenira! nexa Pilatos ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdotenai, Iraexatyakalati Hana kaxaikotyasenai harenai waiyaha Jesus hoka kinatyaxa kawiyatyaha: — Haberekotene atyalihose xaimaholatyaka hiye! Haberekotene atyalihose xaimaholatyaka hiye! nexaha kinatyaxa kawiyatyaha, Jesus xaisaka aokahitaha. — Maika atyo xiso xiyanehena ekakoa hoka atyalihose xaimaholatyaka hiye xaberekotene. Natyo nomani atyo maisa xoare iniyalahare tyomare — nexa Pilatos ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","— Xaotyakisatyaho kakoare wiso. Wiyaotyakisakaho xema wisaonita hoka exe haliti xaisaka waoka, Enore Ityani aokowita hoka — nexa judeunai Pilatos hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hatyo akiti sema Pilatos hoka maira kalore. ");
INSERT INTO pabNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xane isoahitiya hatyako hoka axehitiya Jesus: — Aliyotare kaisere hiso? Nexa xakore hoka maisa ekoaxaita enomana. ");
INSERT INTO pabNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","— Xoana hoka maisa hekoaxaita nomani? Hiyaiya, kalorexe atyo natyo. Hikahalakisakehetaiya naoka hoka hikahalakisakeheta. Hikaxaisakaiya atyalihose xaimaholatyaka hiye naoka hoka hikaxaisakaiya. Xoana eko waiyekehalakita homana? nexa axa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","— Ekoiya awa Enore kalorexe mokita hiso hoka maisaiya xoana hamokita natyo. Hatyo hiyeta nomatawatyasehare kalore iniyalahare tyoma — nexa Jesus kalorexe hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatos sema iniraine hoka halakiheta Jesus aokowihena. Xakore hoka judeunai kawiyatya kinatyaxa enomana: — Awaira atyo hahalakihetehenene. Hahalakiheteniya atyo hoka maisaiya atyo waiyeta Roma yerenai xekohase César ana. Hiyaiya, hatya haliti kalorexe tyaona aokowita hoka César nahalakoahare terota tyaonita — nexaha Pilatos ana kawiyatyaha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hatyo iniraineha sema Pilatos hoka aihikoaheta Jesus menanaka tyaonahitereha nali. Hatyaoseta Pilatos kalorexe nokahakalaose tyokeheta, “Sehalikoa” aokahitere nali. Hebreunai xako maniya atyo: “Gabatá”, nexahitaha hatyo xaokaka. ");
INSERT INTO pabNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Exowaka okoi totahikoahena. Kamaetali hoka Páscoa ferakene tyaohena. Pilatos tyokeheta hoka nexa judeunai hiye: — Xiyaiyehena, owene xiyekohase kalorexe — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","— Maisa! Waiye xaisaka atyo! Waiye berekotyaka atyalihose xaimaholatyaka hiye! nexaha kinatyaxa kawiyatyaha enomana. — Xoana xiyekohase kaberekotyaka atyalihose xaimaholatyaka hiye xaokita? nexa. — Maisa exe xini wiyekohase. Roma yerenai xekohase taita atyo wiyekohase — nexaha sacerdotenai nityohalitiranai Pilatos hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nexaha hoka Pilatos halakisa Jesus sorarenai ana berekotyahene maheta atyalihose xaimaholatyaka hiye hoka exowakerota xaneha ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Hatyaoseta xaneha Jesus kakoa Calvário, Seriti nahe aokahitere nali. Hebraico xako atyo, “Gólgota”, nexahita exaokaka. Xanehenaha ekakoa hoka Jesus kolatya atyalihose xaimaholatyaka haberekotyaka niyahare. ");
INSERT INTO pabNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Xane kaokaha ekakoa hatyo nali hoka berekotyaha Jesus atyalihose xaimaholatyaka hiye. Hinamahare tehitiya berekotyaha atyalihose xaimaholatyakanai hiye, hamaniya hahare, hamaniya hahare xoaha atityoakisahene hoka Jesus enenekeseneha tyaona. ");
INSERT INTO pabNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatos xairatya taba taose hiye hoka hatyo taba taose berekotyaha Jesus seri hao. Exakerexe xairatyoare, hebraico, grego, latim xoaha xako: ");
INSERT INTO pabNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wenakalati haliyita berekotyahene hoka kahare judeunai jiyehenaha hatyo nali hoka waiyehenaha hatyo xairatise hoka kaixaretyahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hatyaoseta sacerdotenai xekohasenai xane hoka nexaha Pilatos hiye: — Awaiya atyore, “Judeunai xekohase”, hexa haxairatyare. “Natyo atyo judeunai xekohase”, hexaiya atyore haxairatya — nexaha Pilatos hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","— Nikare naxairatya hoka kotare nikareta — nexa Pilatos ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sorarenai berekotya Jesus atyalihose xaimaholatyaka hiye hoka hatyaoseta inima ekatyahexete aikosekoatyaha 4-taose hoka haihatyaka tyaonaha ekakoa. Hoka inimanase atyo maisa itinolatyakahare xini hoka maisa aikosekoatyahitene. ");
INSERT INTO pabNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","— Kotare maxaikotyakahare wahalakisa inimanase hoka wahasakaharetyakakoa ihiye hoka xala xamani tyaona ekakoa — nexakakoaha. Nexakakoaha hoka hatyaoseta hasakaharetyakakoaha hoka hahare tyaona inimanase kakoa. Hatyo nikare tyaohenahere akiti kaxairatyaka iraeti waiyexe nanekoa hoka nikare tyaona: Nimi atyoite irakakakoaha hoka niminase hiye atyoite hasakaharetyakakoaha. Hatyo akereta sorarenai tyaona. ");
INSERT INTO pabNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Atyalihose xaimaholatyaka haliya Jesus nityo haximalone kakoa, exahe Maria Madalena, Clopas exanityo Maria harenai tityoahitaha hoka ");
INSERT INTO pabNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","hatyaoseta Jesus waiya hanityo. Inityo haliya tyaonita exaotyakirahare awaiyetiterene hoka Jesus waiyene hoka nexa hanityo hiye: — Hiyaiya, exe atyo hityani — nexa hanityo hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hatyaoseta haxaotyakirahare hiye nihitiya: — Hiyaiya, exe atyo hityo — nexa ihiye. Nexa ihiye hoka exaotyakirahare noloka Jesus nityo hahanako xeta hoka tyaona ehaliya maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hatyo najikinita atyo waiyekehalakehena Jesus ana, koxaka atyo tyotya kawenatyakeheta. Hoka nexa: — Noinita — nexa, kasani Iraiti Waiyexe nanekoa xairatyoare tyaonitere akereta kawenatyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hatyo nali tinihaliti vinhoxa katyalaxere kakoare tyaonita hoka xane tihaharetyoakalati mitoloka hatyoxa hoka atyakase hiye mokene hoka xane Jesus kanase hiye ekaokakisene. ");
INSERT INTO pabNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tera hatyo vinhoxa hoka nexa: — Koxaka tyotya memaka hoka imiyane nahikoa — neheta takita hoka xawinoka haseri hoka waini. ");
INSERT INTO pabNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Hatyaoseta judeunai xane axa Pilatos, atyalihose xaimaholatyaka hiye tyaoniterenai kasahe taikaha aohenaha hoka wainiha haxerore hoka atyalihose xaimaholatyaka hiyeta iyehenahitene maheta, memere mokakatyaha sábado ferakene niyahare aokowiyahitaha hoka. Kamaetali sábado xowaka atyo Páscoa ferakene hoka kasani maisa heko atyalihose xaimaholatyaka hiye tyaonaha sábado xowaka aokareha judeunai hoka nikare iraeha Pilatos hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Xane iraeha Pilatos kakoa hoka axikatya sorarenai hoka xane atyalihose xaimaholatyaka hiye tyaoniterenae kasahe taikaha maheta. Jesus hakakoane berekohenahere hahare hotohare kasahe taikaha, hatyaoseta hahare taikehehenahitiyaha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hoka Jesus ana xane xakore hikoahenaha, koxaka atyo waini hoka maisa ekasahe taikahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Xakore atyo hoka hahare sorare atyo hatonotyakala kakoa Jesus koihako tonotya. Tonotene hoka hatyo etonolaoseta iratyoa timalati, one xoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ewaiyasehare waiya hatyo nikare mohenahere Jesus hoka xakaini. Maisa maoseraita xini, aliterexe nikare mokaha Jesus. Waiyene hoka xakaini xityakeko maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Exakerexe xairatyoare tyaonita Iraiti Waiyexe nanekoa: Maisaiya hanahe hekoti enahe taikoita. Nikare etahi kaxairatyaka hoka nikare mokaha Jesus iraiti akereta kawenatyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hakiti tehitiya exakerexe xairatyoare tyaonita: Wahakotyahaite hatyo hatonolahareha ana. ");
INSERT INTO pabNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hatyo najikinita José nexarexe xane irae Pilatos kakoa, iyeheta maheta Jesus háre atyalihose xaimaholatyaka hiyeta hoka fetene maheta. José atyo Arimatéia nalitare, Jesus xema nawenatyasehare. Exema nawenatyasehare xakore hoka mema tyaonita, judeunai amairakijitene hoka. Xane axa Pilatos hoka: — Ahá, hiyane hiyehetene — nexa Pilatos ihiye hoka xane atyalihose xaimaholatyaka hiyeta iyeheta Jesus háre. ");
INSERT INTO pabNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemos nexarexe tehitiya xane José xema. Hatyo Nicodemos atyo etake makiya xane iraehenere Jesus kakoa. Nicodemos xane José xema, kolatya airaxero ekaketatyakahare aloés, mirra xoaha kakoare. Timena hatyo airaxero kolatya. ");
INSERT INTO pabNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Xaneha hoka xane iyehenahitaha Jesus háre atyalihose xaimaholatyaka hiyeta hoka olahisityahene imiti kese taosero kakoa hoka airaxero kaolaxahenahere kakoa airaxehisahene. Judeunai atyo nikare hakamaneha moka hoka fityahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hatyo Jesus berekohenahere nali akiti hanakatihaliti kakoare, hoka hatyo nali sehali kakoakotyaka. Waitare kaomakere hoka maisa xala hare hatyoako kaxafityakehenere. ");
INSERT INTO pabNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Maisa sekore hatyo sehali kakoakotyaka hoka hatyoako xane Jesus háre mokaha. Exowaka okoi sábado ferakenehena judeunai hiye hoka nikare tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo xowaka weta makiyaseta Maria Madalena xane Jesus xawatyakala nali xeta. Xane kaoka, waiyehena atyo, xawatyakalati atyo majiholatyoare. Ijihola sehali taose atyo koxaka kaiyaka hoka majiholatyoare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nikare waiya hoka tema xane Simão Pedro, háhare Jesus awaiyetitere xoaha ana hoka nexa ihiyeha: — Iyehenahita Xekohaseti Jesus háre exawatyakala akota hoka kala aliyo xamani ala xane mokahene — nexa Maria xakai ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nexa ihiyeha hoka Pedro hatya exaotyakirahare xoaha xane xawatyakalati nali. ");
INSERT INTO pabNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tema xaneha, háhare atyo Pedro xahe winihare hoka tema xane hoka hatyo hotohare xane hikoa xawatyakalati nali. ");
INSERT INTO pabNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xane hikoa hoka tanatyoakotya hoka imiti kese taosero waiyeheta hoka maisa atyo ijoita xawatyakalati ako. ");
INSERT INTO pabNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Enajikinita atyo Pedro xane hikoa hoka isoa xawatyakalati ako hoka waiyeheta imiti taose, nali tyaonita hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesus seri hiye olalihenahere taose haware tyaonita imiti linho taose eháre hiye olalihenahere nonitata. ");
INSERT INTO pabNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Hatyaoseta exaotyakirahare hetati xane hikoahenere tehitiya isoa hoka waiya. Waiya hoka tyakeko. ");
INSERT INTO pabNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Exowakiya maisa waiyekehalakere enomanaha Iraeti Waiyexe nanekoa xairatyoare tyaonitere, Jesus ite kasehetehenere nitere. ");
INSERT INTO pabNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hatyaoseta hatyo hinamanai haikoahetaha hahanaha xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hoka Maria Madalena atyo hekota tyaonita xawatyakalati haliya, tiyita. Haosexa naseta meholokoa tanatyoa waiyakotya xawatyakalati. ");
INSERT INTO pabNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Waiyehena atyo, owene hinama anjo tyaonita iyomere nimere makere. Tyokahita Jesus xomokakaose nali, hatya eseri maniya, hatya ikiji maniya xoaha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","— Xoana hoka hitiyita? nexaha axaha Maria. — Iyehenahitaha noxekohase háre hoka aliyo xamani xane mokahene — nexa Maria ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nexa hoka ehaikoahaloheta, waiyehena atyo, Jesus atyo owene tityoita hoka motya maisa hatyota xini aokitene. ");
INSERT INTO pabNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Hatyaoseta Jesus axene: — Xoana hoka hitiyita? Xala xahita hatawita? nexa. Motya hatyo naliye hanakati kaxaikotyasehare aokene Maria hoka nexa ihiye: — Xoana, hiso hiyeheta noxekohase háre? Aliyo hamokene? Alitere atyo hakolatene hoka hiyakai nohiye hoka noxani nakolahetene hahalakihenerene nalita hoka hakiti noxani nafehetehitiyene — nexa Maria ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Hatyaoseta: — Maria! nexa Jesus. Nexa hoka ehaikoa enomana hoka nexa: — Raboni — nexa ihiye, hebreunai xako irai. Wiyako maniya atyo, “Xaotyakisatiye”, nita. ");
INSERT INTO pabNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","— Awa atyo hotohena natyo noxanini nahitita Baba nali. Hiyane kaisere nohinaeharenai hiye hiyakaihetehena natyo. Maika hexa ihiyeha: “Eno tyaite xanehena Hanexe Enore nali, exahe Xexe Enore nali”, hexa ihiyeha — nexa Jesus Maria Madalena hiye. ");
INSERT INTO pabNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nexa ihiye hoka Maria Madalena xane xakaiheta Jesus xaotyakiraharenai hiye: — Nowaiyehetaore Xekohaseti — nexa Maria Madalena ihiyeha, Jesus niraene harenai xakai ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hatyo domingone makehena hoka exaotyakiraharenai hohisakoaha hati waiye jihotyakere ako, judeunai nityohalitiranaiha amairakisahitene hoka. Hohisakoaha hoka Jesus kaotyaka enomanaha hoka tityoa enenekeseneha. — Maika waiye ximehexaikohare xisaona naoka — nexa ihiyeha, ");
INSERT INTO pabNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","hotikisa hakahekoa berekotyakaose, hakoihakore tonotyakaose hare hotikisa enomanaha. Waiyehenahita haxekohaseha hoka ihalaharehenahita. ");
INSERT INTO pabNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","— Maika waiye ximehexaikohare xisaona naoka. Baba Enore axikahenere natyo akereta atyoite naxikatya xiso — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nexa ihiyeha hoka aomomaharehenahitene. — Isekohaliti Waiyexe tyaona xikakoa naoka — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","— Haiyanai nómanenai iniyalahare xemaisatita hoka kamaotyanetyakaiya. Hoka maisaiya xemaisatita hoka maisaiya kamaotyanetyakita — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesus kaotyakehetehenere enomanaha xowaka atyo maisa nali enekoniha aka háhare exaotyakirahare Tomé, Dídimo aokahitere. ");
INSERT INTO pabNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomé kaokeheta enomanaha hoka exaotyakiraharene haiyanai nehenaha ihiye: — Wiyaiyeheta Xekohaseti — nexaha. — Kala xamaoseraita. Maisaiya atyo nowaiyita eberekotyakaose ekahekoa, exahe namokita nokahihi eberekotyakaose, exahe namokita nokahe etonotyakaose ekoihako akiti hoka maisaiya atyo notyakekota xiraini — nexa Tomé. ");
INSERT INTO pabNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tyaohenaha, hasemanane najikinita kala Jesus xaotyakiraharenai hohisakoahenahitiyaha, Tomé kakoareha atyo. Hati waiye jihotyakahare ako tyaonahitaha. Hatyaoseta Jesus kaotyakihitiya enomanaha. Tityoa enenekeseneha hoka nexa ihiyeha: — Maika waiye ximehexaikohare xisaona naoka — nexa ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hatyaoseta Tomé hiye nexa: — Wityaira hiyaiya hoka hikahihi hamohena nokahikoi, exahe hikahe hoka nokoihako. Awaira hamatyakekohena. Maika hityakeko — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hoka nexa ihiye Tomé: — Noxekohase, Nenorixi! nexa taita iniraine nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","— Hityakekoheta atyo, hiyaiyeheta tyare natyo hoka. Hoka waiye kaiserehare atyo mawaiyanehareta tyakekotere natyo — nexa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus atyo kahare xoalini hare tyoma haxaotyakiraharenai haoti tyakekoha maheta, hoka maisa atyo tyotya etahi kaxairatyakita exe baberanekoa. ");
INSERT INTO pabNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Haiyanai enómanenai taita kaxairatyaka xityakeko maheta Jesus. Hatyo atyo Enore Ityani. Jesus atyo Enore Kalorexe Aohenere. Xityakekone hiyetaite menanehaliti xisaona. ");
INSERT INTO pabNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hatyo najikinita Jesus kaotyakehitiya haxaotyakiraharenai ana hokoxa Tiberíades aokahitere nali. Exakere kaotyaka enomanaha: ");
INSERT INTO pabNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Haiyaharenai exaotyakiraharenai nali tyaonita, Simão Pedro, Tomé Dídimo, Natanael, Zebedeu ityaninai, hinamahare tehitiya harenai nali tyaonita. Natanael atyo Caná nalitare, Galiléia koa yere. ");
INSERT INTO pabNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nali tyaonahita hoka Simão Pedro nexa hahinaeharenai hiye: — Noxani namairatya — nexa. Nexa hoka: — Wisoa tehitiyaite hiyema hoka wamairatya — nexa ihinaeharenai ihiye. Nexaha ihiye hoka mánene kanowako isoaha hoka xaneha. Hatyo makene mairatyaha heko ferakoa hamairalaha kakoita xakore hoka maisa xoare hare nolokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ferakoahena, waiye waiyakehena hoka, waiyehenaha atyo, owene atyo Jesus one kilihi kaiholokoa tyaonita. Xakore hoka motya atyo maisa Jesus xini aokahene. ");
INSERT INTO pabNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","— Xoana xanoloka kohase? nexa kawiyatya Jesus enomanaha. — Maisa xoare — nexaha ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","— Xaxawahena maka kohase hiyakakala kanowa halatako fihi maniya hoka kohase nalita xahiya — nexa ihiyeha. Exowakerota xawatyaha onexa maka kohase hiyakakala hoka kahare isoa enako. Kahare kohase isoa enako hoka maisa aliyakere noloka aihikoahenahitita kanowako hahiyakakalaha, timena hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hatyaoseta exaotyakirahare Jesus awaiyetitere nexa Pedro hiye: — Xekohaseti Jesus nikaore — nexa Pedro hiye. Pedro sema Xekohaseti nali tyaonitere hoka isoaheta haimanasako, maimahiro ene tyaonita hoka. Isoaheta haimanasako, exoa onexa hoka maxakoa xane Jesus tyaonitere nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Haiyaharenai exaotyakiraharenai atyo kanowakota nolokehexatya tyoahita kohase kakoare hahiyakakalaha. Maisa sekore kaiholokoa nonita. ");
INSERT INTO pabNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tyoa hikoahenahitaha kaiholokoa nali hoka exoahenahitaha kanowakota. Waiyehenaha atyo, kohase jihatyaka tyaonita nakairati kakoare irikatyaose. ");
INSERT INTO pabNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","— Xamehena nomani kohase xinolokala hiyeta — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Exowakerota Pedro nolokihitya kohase hiyakakala kohase kakoare, aihikoatya iyoherotikoa. Kahare kohase, kaise ihiyakakalako. Ihatyahene hoka 153-kohase, kalorexe taita. Kahare, kalorexe taita xakore hoka aihikoatene hoka maisa irikoita ihiyakakalaha. ");
INSERT INTO pabNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Hatyaoseta Jesus iraihena: — Witya xikanakairahena — nexa ihiyeha. Maisa xala hare axarene. Xekohaseti Jesus terota aokahitene hoka waiyekehalakita enomanaha hoka maisa xala hare axarene, haiharahitene hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Hatyaoseta Jesus kaoka ehaliyaha hoka nakairati isa enomanaha. Nikare tehitiya kohase isa enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Koxaka hinamaki Jesus kaotyakeheta haxaotyakiraharenai ana hakamane najikinita, kaseheta hoka. Exe kakoita hanamaki kaotyaka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kanakairaha najikinita Jesus axa Simão Pedro: — Simão, João ityani, xoana hawaiyetita natyo exe haiyanai xahexe? nexa. — Há, nawaiyetita hiso, Xekohaseti. Hatyo akiti waiyekehalakita homana — nexa iniraine nahalakoa. — Maikaite hikaxaikohena nokalaneroxi mokosenai nomani — nexa Jesus ihiye, (exema maniya tyaoniterenai xaokaka nikareta iraeta). ");
INSERT INTO pabNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hatyaoseta Jesus axehitiyene: — Simão, João ityani, xoana hawaiyetita natyo? — Há, nawaiyetita hiso, Xekohaseti. Hatyo akiti waiyekehalakita homana — nehitiya Pedro ihiye. — Maikaite hikaxaiko nokalaneroxinai nomani — nehitiya Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hatyaoseta mawaheneta hoka axehitiyene: — Pedro, João ityani, xoana, aliterexe hawaiyetita natyo? nexa axehitiyene. Hatyaoseta Pedro hanamakihena axita hoka amaikoharehena: “Xoana, hawaiyetita natyo?” nita ihiye hoka. Amaikoharehena mokitene hoka nehena: — Xekohaseti, tyotya hakakoare atyo waiyekehalakita homana. Nawaiyetita kaiserehare hiso. Hatyo akiti waiyekehalakita homana — nexa Pedro ihiye. — Maikaite nokalaneroxinai hikaxaiko nomani — nehitiya Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","— Hiyoimaharene xowakiya ene atyo aliyo xamani hiyane haokowihena hoka himako hisoa hoka hiyaneta ene. Hoka maikaite hinityohalitihena hoka haimatya hikahe haiyanai ana hoka olatyaha hiso hoka kolatyaha hiso, maisa xakorite hiyane ekakoaha haokowiye hoka hiyanite — nexa Jesus ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pedro kamane xaokaka nikare iraeta Jesus. Pedro kamane hiyetaite Enore kaxaerorityaka. Hatyaoseta Jesus nehitiya Pedro hiye: — Hisaohena noximi maniya — nexa ihiye. ");
INSERT INTO pabNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Hatyaoseta Pedro terehokoa waiya Jesus xaotyakirahare masakare awaiyetiterene ana. Hatyo exaotyakirahare atyo hisehaliti Páscoa xowakiya kanakairahitaha hoka tyokita Jesus haliya hoka nita Jesus hiye: “Xala himatawatyasehare?” nita axita Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro waiya hatyo Jesus xaotyakirahare hoka nexa Jesus hiye: — Hoka exe ite xoana tyaohena? nexa axa Jesus. ");
INSERT INTO pabNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","— Hekotaiya makamanehare tyaona naoka hoka hekotaiya tyaona nahaikoahetehenere kijiya. Xoaneretya haoka? hatyo nali, maisa hiso xini. “Hisaohena noximi”, nomita hihiye — nexa Jesus Pedro niraene nahalakoa. ");
INSERT INTO pabNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hatyaoseta xakaikoatyaha hakakoare hatyo exaotyakirahare makamanene akiti, maisa xakore atyo nikare Jesus nexare hoka nexa taita xakore atyo hoka, “Hekotaiya makamanehare tyaona naoka hoka hekotaiya tyaona nahaikoahetehenere kijiya. Xoaneretya haoka? hatyo nali, maisa hiso xini”, nexa taita xakore atyo Jesus Pedro hiye hoka. ");
INSERT INTO pabNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hatyo exaotyakirahare atyo xakaini hatyo Jesus iraitere tyomehenere harenae tahi akiti, exahe xairahetene baberanekoa. Maisa maoseraita xini, aliterexe iraeta. Hatyo akiti waiyekehalakita womana. ");
INSERT INTO pabNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hekota Jesus tyomitere akiti maxakaihakatyakahare kahare. Hatyoiya kala tyotya kaxairatyakere hoka kalaiya exahe waikohe hakakoare hoka maisaiyala hatyo babera hakakoaneta naoka, nexa hatyo exaotyakirahare.");
INSERT INTO pabNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Koxaka naxairatya babera homana, Xekohaseti Teófilo, hetatita tyotya Jesus aotyakihenere, tyomehenerenae tahi enokoa kakolatyakehenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Enokoa kakolatyakehenere nahitita halaisa hairaene haomanerenae haxaotyakiraharenae aohenerenae ana, Isekohaliti Waiyexe niyatere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hakamane najikinita Jesus kaotyakeheta kahare maniyata haxaotyakiraharenae ana, 40-ki ferakene. Maisa maoserare xini, kaseheta kaiserehare. Exaotyakiraharenae waiyehetene. Jesus irae ekakoaha Enore maniya nawenatyaka tahi. ");
INSERT INTO pabNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hatyo xowaka Jesus tyaonita haxaotyakiraharenae kakoa hoka iraeta ekakoaha: — Hekoira Jerusalém nali xisaona. Xatyaha Enore isa aokowitere xahita, noxakaitere xihiye xahita. ");
INSERT INTO pabNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","João atyo aliterexe one kakoa batixatya. Hoka xiso atyo ite Isekohaliti Waiyexe kakoa xikabatixatyaka ininaetehena hoka, maisa wahahetere. ");
INSERT INTO pabNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesus niraine kakoarenai, ehaliya hohisakoiterenae xoaha axene: — Xekohaseti, xoana kalikini xowakaite Israel hotyalinae ana ewaikoheraha hisehetehena? ");
INSERT INTO pabNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","— Maisaiya atyo kaxawaiyekehalatyakita hatyohare akiti xomana. Wexe Enore ana taita atyo waiyekehalakita hatyo haxaokala ximita aemenekohenere ferakene kakoa — nexa Jesus ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","— Hoka xikaxaiyatelikisaka ite. Isekohaliti Waiyexe exoahena xomana hoka xiyane notahi ite xiyakaihena Jerusalém tyaoniterenae hiye, tyotyaha Judéia koa, Samaria koa tyaoniterenae hiye, exahe sekorenae hiye hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nexa Jesus irae taita hoka kanolokaka enoxeta tyotyaha ehaotyahitaha. Hatyaoseta kaiminiti talatene enonyahita hoka maisa waiyehenahititene. ");
INSERT INTO pabNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hekota wahakotyahitaha enoxeta Jesus xanetere xahita hoka eharehena rotita hinamahare haliti kaotyaka enomanaha iyomere akoreha ");
INSERT INTO pabNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","hoka nehenaha: — Galiléia yerenae, xoana hoka enokoa xeta xawahakotita? Exe Jesus enokoa xinekonita xanehenere eno xeta akereta ite tyoheta — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hatyaoseta haikoahenahitaha Jerusalém nali xeta, Oliveira tyairiya nalita. Sábado ferakene watohenere akere xikako, maisa sekore xini. ");
INSERT INTO pabNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kaokehenahitaha hoka isoahenahitaha hatyako, xaneha enoako. Hatyoako tyaonahitaha Pedro, João, Tiago, André, Filipe, Tomé, Bartolomeu, Mateus harenai, Alfeu ityani Tiago, Simão Zelote, Tiago ityani Judas xoahanae hatyoako tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tyotyaha haxawalita iraexataha minita Enore hiye, ohironae hare kakoa, Jesus nityo Maria harenae kakoa, iximarenenae harenae xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hatyo najikinita 120-hare Jesus xema maniya tyaoniterenae hohisakoahitaha hoka Pedro tityoa hoka nehena: ");
INSERT INTO pabNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","— Xasemehena, nohinaeharenae. Isekohaliti Waiyexe Davi kanasakota aehikoaxatya etake Judas Jesus matawatyasehare tahi akiti, hoka nikare terota kawenatyaka. Hiyaiya, Judas atyo Jesus xotokaseharenae ana matawatene. ");
INSERT INTO pabNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Winekoni ene tyaonita, Jesus aokene hairaine kakoare maheta haka haxawalita wikakoa maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas xane iya waikohe Jesus matawahenere xaimane kakoa. Hatyo waikohe háiyane nali exoa hoka enajihi irikotyoasekoa hoka tyotya hikoa enajihi — nexa Pedro ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","— Hatyo tahi tyotya Jerusalém tyaoniterenae semaha hoka “Aceldama” nexaha kaixaretyaha hatyokoa waikohe — nexa Pedro ihiyeha. Exakoha atyo “Aceldama”. Wiyako maniya atyo “Timalati koa”, nita. ");
INSERT INTO pabNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","— Salmo nanekoa exakere hatyo tahi kaxairatyaka: Maika ehana firakiti tyaoheta hoka maisa xala hare tyaonehitita nali. Nexa tehitiya: Hatya atyo ite tyaona ewenekoare hoka ehatene tyoma. ");
INSERT INTO pabNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","— Hiyeta ite hoka hatya haliti wamoka Judas wenekoare Jesus kaseneheta tahi xakaisasehare maheta. Haiyaharenae waiyehenahere Jesus tyaonitatere winekoni xowaka ");
INSERT INTO pabNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tyaonaha wikakoa João batixahenereneta enokoa kakolatyakehenere kijiya. Maika hatya hatyoharenai konitare wamoka Judas wenekoare. ");
INSERT INTO pabNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hatyo hekota hotikisaha hinamahare, José Barsabás Justo kaexareharehenahere, Matias xoaha enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hatyohekota iraexahenaha: — Hiyaiyita atyo wityotya wiyahekola, Xekohaseti. Hahotikihena kalikini womana xala xamani ite haoka ");
INSERT INTO pabNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","haka wikakoa maheta hoka Jesus niraine kakoare tyaona tehitiya. Hiyaiya, Judas atyo halakisa hahatene hoka xane hakiti haomanere nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","— José xamani, Matias xamani — nexaha hoka hasakaha xala xamani tyaona maheta. Hatyaoseta Matias nexare kaotyaka hoka hatyo tyaona Jesus niraine kakoare 11-harenae koni. ");
INSERT INTO pabNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostes ferakene xowakehena hoka tyotyaha Jesus xema maniya tyaoniterenae hatyo nalita hohisakoahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tyaonahitaha ene hatyoako hoka semehenaha atyo, kaemaharehena enokoata, motya kinatyawiniti hoholala. Hatyako tyaonahitere tyokahitere ako tyoa ekaisitya hoka tyotyaha semahene. ");
INSERT INTO pabNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hatyaoseta waiyehenaha atyo, motya atyo irikati birobirola kaotyaka. Hatyo irikati birobirola akerehare xaorekoa, inihatyakaha xane kaoka enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hoka tyotyaha Isekohaliti Waiyexe kaxaihakoretyahene. Hatyaoseta iraihenaha haiyanai xako. Isekohaliti Waiyexe inihatyakaha iniyatereha isa enomanaha hoka nikare tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Exowakiya Jerusalém nali tyaonahita judeunae Enore maniya ahekotiterenae. Koxaka tyoa kaokaha waikohe nihatyaka maniyata. ");
INSERT INTO pabNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hatyo sekotarenae semaha emahaliti hohisakoahitereha nali hoka tema xaneha waiyaha maheta, hisoaka haliti xaneha. Jesus xema maniya tyaoniterenae atyo iraetaha haiyaharenae xako hoka semahenaha atyo, hatyo iraeterenae atyo exakoha iraetaha hoka waiyekehalaka semahene hoka hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hatyo haliti hisoakerenae hakaharetyoahenaha mairihenaha hoka nehenaha: — Exe halitinae iraiterenae atyo Galiléia yerenae. ");
INSERT INTO pabNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hoka aliyakereyala hoka wasemita iniraineha wiyako maniya? ");
INSERT INTO pabNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Hiyaiya, seko akiyata atyo wisoa: Pártia nalita, Média nalita, Elão nalita, Mesopotâmia nalita, Judéia nalita, Capadócia nalita, Ponto nalita, Ásia nalita, ");
INSERT INTO pabNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frígia nalita, Panfília nalita, Egito nalita, Líbia koa maniyata, Cirene haliyata wisoa. Exahe haiyaharenae Romatare xoaha tyoa. ");
INSERT INTO pabNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Haiyaharenae atyo judeu, haiyanae majudeunehare xakore atyo hoka judeu akereta atyo tyaonita. Haiyanae atyo Creta nalitare, Arábia nalitare xoaha. Xoanere ala hoka nikare wasema iraiti? Aliyerenae iraihenaha hoka wiyakonae iraiyahitaha? Enore nómane kalore xoalini hare waiyexe tahi — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","— Xoanere kala? nexaha axakakoaha. Hakaharetyoaha, maisa aliyakere tyaona xaka. ");
INSERT INTO pabNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Hoka haiyaharenae atyo koexahalisahene: — Hekahitahata exe halitinaeka — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hatyaoseta Pedro tityoa 11-harenae kakoa iraihena tyotya halitinae hiye: — Xasemehena niraini, xiso nohinaehare judeunae, exahe xiso xityotya Jerusalém nali tyaoniterenae. Waiye xasema niraihenere. ");
INSERT INTO pabNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Xoana motya exenae hekahitaha xaokita? Maisa nikare xini. Xiyaiya, kalikini rota enokamaehena. ");
INSERT INTO pabNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Maisa nikarexe xini kalikini kawenatyakitere. Iraiti semasehare Joel xairatya exe kalikini kawenatyakitere tahi akiti: ");
INSERT INTO pabNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Exakere ite notyoma miyanitiye xowakehena hoka”, nexa Enore. “Maika ite Nisekohare nexaorekoatya tyotya halitinae ana. Hoka ityaninae ite xakaihena niraini tahi akiti. Maika ite xoimahalitinae ite kaxawaiyanikisaka, inityohalitinae ite kaxekaijihinikisaka. ");
INSERT INTO pabNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hatyo xowakiya ite nexaorekoatya Nisekohare nowakaniharenae, nowakanihalonae ana hoka xakaihenaha niraini. ");
INSERT INTO pabNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Enokoa maniya ite xoalini hare nahotikisa. Nikareta tehitiya ite ali waikoa namoka hoka hakaharetyoaha. Maika ite timalati irikati hare kaotyaka, irikati niyite kalore tyaona. ");
INSERT INTO pabNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kamae ite makehekoa tyaona, kaimarite xotere tyaona timalati akere Xekohaseti xaimenekola ferakene kaheneharexe nahitita. ");
INSERT INTO pabNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hoka tyotya haiyanae Enore hiye hakahinaetyaka aohenerenae atyo ite iniyalahare nonitata waiyexe maniya kaxomokaka”. ");
INSERT INTO pabNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","— Israel hotyalinae, xasemahenaira niraini. Enore atyo Jesus Nazaré yere kaxaehakoritita hoka xityotya xihaoti kahare xoalini hare maomakahare tyomita, exahe hokakitinai hoka aiyatelikijita. Hatyohare waiyekehalakita xomana. ");
INSERT INTO pabNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Xakore hoka xiso atyo exaisaseharenae xisaona hoka xisene iniyalahare tyaoniterenai ana hoka berekotene atyalihose xaimaholatyaka hiye hoka aisene xomana. Xakore hoka koxaka Enore waiyoreta ekakoa enahetakota, exaokala ximita nikare kaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hoka hatyo najikinita Enore ekasekiheta Jesus. Ekamane kaiserehareta iyehetene, maisaiya waha aliyakere ekamane tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","— Exakere Davi Jesus tahi akiti nexa: Nowaiyeta minita Xekohaseti, nohaliye tyaonita hoka maisa xoare harenae nomairare. ");
INSERT INTO pabNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hatyo hiyeta nihalahareta noxahekoli kakoa, nihalahareta niraini kakoa. Exahe ite nowaini hoka nokaseheta. Nikare ite hoka nomehexaiko notyaoneheta. ");
INSERT INTO pabNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Maisa ite hahalakijita nisekohare kamati tyaonitere akitiya, Xekohaseti. Exahe ite Haohenere Waiyexe wainihena hoka maisaiya eháre tokomita. ");
INSERT INTO pabNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Koxaka hahotikisa nomani menanehaliti nahotiraho hoka menanehalitite notyaona. Hihaliyehena ite natyo hoka nihalahare kaiserehena. ");
INSERT INTO pabNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","— Nohinaeharenae, awisa hoka waiyekehalaka noxakai xihiye wahetakomaniyere Davi tahi. Waini hoka kaxafityaka, hekotata exawatyakala tyaonita ali winekoni. ");
INSERT INTO pabNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davi atyo Enore niraine semasehare. “Nikarexe ite namoka hiso. Maika ite hatya hijikolahare hiwenekoare tyaona kalorexe”, nitere ihiye waiyekehalakita enomana. ");
INSERT INTO pabNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","— Davi koxaka enahetako maniyita otita hatyohare hoka, “Ahai, nikarexite Enore tyoma. Kalorexe Aohenere kasehetehenere xaokaka: ‘Maika ite maisa kahalakisakita kamatinae tyaonitere akitiya, exahe eháre hoka maisa ite tokomita’ ”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","— Enore exe Jesus ekasekiheta hoka tyotya hatyo harenae wiyaiya. ");
INSERT INTO pabNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hatyaoseta kakolatyaka Enore fihini maniya tyoka maheta. Enexe aokitere Isekohaliti Waiyexe isa enomana hoka hatyo kalikini xasemita, xiyaiyita. Inisekohare xaorekoita winekoni. ");
INSERT INTO pabNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Hiyaiya, maisa atyo Davi ene xini enokoa xaneta. Xakore hoka nexa atyo irae: Xekohaseti nexa Noxekohase hiye: Hisokehena nohaliye nofihini maniya, ");
INSERT INTO pabNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hahalakoaharenae hikiji katyahe namohenere kijiya (enahalakoaharenai mehotyaka xaokaka nikare iraeta). ");
INSERT INTO pabNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","— Waiye xasemehena, xityotya xiso Israel hotyalinae. Exe Jesus xaisehenere atyalihose xaimaholatyaka hiye Enore ekasekiheta hoka Kalorexe Xekohaseti aokene hoka mokene Xekohaseti — nexa Pedro. ");
INSERT INTO pabNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pedro niraine semaha hoka tyotyaha kalore amaikohareha hoka axaha Pedro exahe tehitiya ihinaenae hoka. — Wihinaeharenae, xoana ite wisaohena? ");
INSERT INTO pabNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hoka Pedro nexa ihiyeha: — Xahalakihena iniyalahare xománe hoka xikabatixatyaka Jesus Cristo nexare kakoa hoka iniyalahare xománe kaxemaisatyakeheta, kamaotyanetyakeheta. Hoka Isekohaliti Waiyexe kaoka xomana Enexe nalita. ");
INSERT INTO pabNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Exe iraiti atyo xomanere, xityaninae anere xoaha, exahe seko akiya tyaoniterenai anere tehitiya hoka. Exahe xala xamani Enore aohena haomana hoka hatyo iraiti enomanere tehitiya. ");
INSERT INTO pabNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro aiyateretyoita hairaine kakoa, kahare irae: — Enore maniya xisaohena, awa atyo iniyalahare tyaoniterenae xema xisaona. ");
INSERT INTO pabNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Hatyohekota Pedro niraine kahare tyakekoha. Semaxematyaha iniraine hoka kabatixatyakaha. Hatyo xowakiya komita ene 3.000-hare haliti tyaona Jesus xema maniya. ");
INSERT INTO pabNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hatyota kinatere tyaonaha Jesus niraine kakoarenai xaotyakira xema, exahe awaiyetyakakoahita. Kanakairehenaha hoka haxawalita tyaonahitaha, exahe iraexahenaha hoka haxawalita tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesus niraine kakoarenai tyomita kahare xoalini hare maomakahare waiyexe, hokakitinae aiyatelikihenahititaha harenai. Hiyeta hoka tyotya halitinae hakaharetyoahitaha, waiye aiminisahitaha xoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tyotyaha tyakekoterenae haxawalita tyaonahitaha, exahe haxiyeharenae hoka isakakoahita, ");
INSERT INTO pabNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","betityaha hawaikoheranaeha haxiyeharenae harenae xoalini harenae haomanereha hoka irakahita exaimane maimahiroterenae nakiterenae ana. ");
INSERT INTO pabNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ferakiti nihatyaka haxawalita hohisakoahita Iraexatyakalati Hanako, hamaniyita haxahekola mokahitaha. Hahanahanae ako haxawalita kanakairahitaha, ihalahare tyaonahitaha, maisa xalijiniharexeha. ");
INSERT INTO pabNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Aexakeretyahitaha Enore, exahe tyotya halitinai ana hoka waiyahitaha makere. Ferakiti nihatyaka Enore aihisoakatyahitene ferakiti nihatyaka, hoka kahare haliti waiyexe maniya tyaonahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Haxowaka makakoahena iraexatyati kamae aosehena hoka Pedro, João xoaha xane Iraexatyakalati Hana xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ferakiti nihatyaka hatya haliti Iraexatyakalati Hana kanase nali tyaonita. Maetonanehare terota tyaona. Xisoakalati waiyeharexe nexahitere nali mokahitene axa maheta olo Iraexatyakalati Hanako ijoiterenae nonitata maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hatyaoseta Pedro, João xoaha isoahena hoka waiyahene hoka axahene olo. ");
INSERT INTO pabNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hatyaoseta Pedro waiye wahakotyaha enomana hoka nexa: — Hawahakohena womana. ");
INSERT INTO pabNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hatyo haliti wahakotya enomanaha, atyahaharetyoa xoalini hare exekaneha enomana xahita. ");
INSERT INTO pabNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hatyaoseta Pedro nexa ihiye: — Maisa nokaoloxiye hekoti xakore atyo ite hoka nisa homana, maisaiya nomaxekanita homana. Jesus Nazaré yere nexare hiyeta hainakoa hatohetehena. ");
INSERT INTO pabNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hatyaoseta Pedro otoka ifihini maniya kahe, kahinaetene hoka ainakihetene. Exowakita kinatere tyaoheta ikinoli ikijinae. ");
INSERT INTO pabNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hatyaoseta halaisoa tityoaheta hoka toheta. Hatyo hekota isoa Iraexatyakalati Hanako exemaha. Tonita, halaijoita, ihalahareta Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tyotyaha hatyoako tyaoniterenae waiyaha ehalaisoakola inihalaharene Enore kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hatyaoseta waiyekehalaka enomanaha: — Ahai, etake olo axitere xisoakalati waiyeharexe aokahitere nali tyokitere kore — nexaha. Hakaharetyoaha mairaha, nikare tyaoheta hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hatyo haliti kaxaiyatelikisakehetehenere Pedro, João xoaha haliya tyaona hoka tyotyaha hohisakoaha ehaliyaha Iraexatyakalati Hana tyaisera kilihi Salomão nómane aokahitere nali hoka hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hatyohekota waiyahene Pedro hoka nehena ihiyeha: — Israel hotyalinae, xoana hoka nikare xahakaharetyoita? Xoana hoka xawahakotita womana? Xoana exe haliti tohetehenere motya wiyaokala wiyatere hiyeta toheta xaokita, exahe hoka motya waiye maniya wawenane hiyeta xaokita? ");
INSERT INTO pabNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Xasemehena, wahetakomaniyereharenae Abraão, Isaque, Jacó xoaha nEnorexa kalorexe moka hawakanehare Jesus. Xiso atyo xisene xekohaseti Pilatos ana aisene maheta. Pilatos xakore ehalakisakeheta aoka hoka xiso atyo maisa xaoka. ");
INSERT INTO pabNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Hatyo xakore atyo waiyexe kaiserehare hoka xiso atyo maisa xaokitene. Exahe ehalakisakeheta xakore aoka hoka haliti fahare halakisaka xetatere xaoka Pilatos hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nikare xiso xaisa wenati waikatehare. Xakore atyo hoka Enore atyo ekasekihetene. Wisonae atyo ewaiyasehare wisaona. ");
INSERT INTO pabNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesus nexare, niyatere atyo exe haliti aiyatelikiheta, exe xiyaiyitere. Enexare tyakekotyaka, Jesus tyakekotyaka atyo aiyatelikihetene xityotya xihaoti. ");
INSERT INTO pabNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","— Maisa Jesus waiyekehalakere xomana hoka nikare xamokene, nohinaeharenae, xiso xinityohalitiranae xoaha. Hatyohare waiyekehalakita nomani. ");
INSERT INTO pabNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kalorexe Aohenere makawatini tahi Enore xakai. Koxakereharenae iraiti xakaisaseharenae kanasakota aehikoaxatene. Hoka xakaihenahere akereta kalini kaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","— Hoka xahalakihena nikare xawenane hoka Enore maniya xisaohetehena hoka iniyalahare xománe kamaotyanetyakeheta. ");
INSERT INTO pabNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hoka ekakoita exahe waitare iyateliti kaoka xomana Enore nalitare. Exahe axikatya Kalorexe Aohenere xomana. Hiyaiya, Jesus atyo Enore Kalorexe Aohenere. ");
INSERT INTO pabNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Enokoa tyaonita kalikini. Heko atyo ite kotare enokoa tyaonisa. Tyotya xoalini hare hotohare tyomihitiya hoka hatyo xowaka rota atyoite Jesus axikaheta. Hatyo akiti koxakereharenae iraiti xakaisaseharenae kanasakota Enore aehikoaxatya. ");
INSERT INTO pabNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hiyaiya, exakere Moisés nexa: Enore ite maika hatya xinekonita kaoyakatya iraiti xakaisasehare xomana natyo akere. Hoka maika xasemaxematya iniraine, xoare nehena xamani xihiye hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Hoka xala xamaniya atyo maisa semaxemaita iniraine hoka Enore kaxaikone hotyali konita kakikisakeheta hoka kamawenekoaretyaka. ");
INSERT INTO pabNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","— Tyotyaha iraiti xakaisaseharenae hatyo xaka xakaihahitaha. Samuel hotohare iraine, hatyo hekota enajikini maniyatarenai tyotyaha xakaihaha kalikini wisaonitere akiti. ");
INSERT INTO pabNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Xiso atyo iraiti xakaisaseharenae jikolaharenae. Xahetakomaniyerenae anere aokitere Enore tehitiya xomanere. Hiyaiya, nexa atyo Abraão hiye: Hijikolaharenae hiyetaite tyotya waikoa tyaoniterenae waiye maniya kaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","— Nikare Enore hawakanehare axikatya xomana hotohare, waiye maniya moka xiso maheta, xahalakisa iniyalahare xománe maheta — nexa Pedro ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro, João xoaha iraetata ekakoaha hoka tyoa kaoka sacerdotenae, Iraexatyakalati Hana kaxaikotyasenae xekohase, saduceunae hare kaokaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ehareha hatyo hinama Jesus niraene kakoarenae hiye exaotyakiraha hiyeta. Saduceunae atyo kamati makasenehare aokiterenae. Hoka, “Koxaka Jesus kaseheta. Nikare ite kamatinae kaseheta”, nexahitere hiyeta ehareha Jesus niraene kakoarenae hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hatyaoseta otokahene hoka berexotyahene, mokahene berexo ako kamaetali niyahare. Hatyo xowaka koxaka makehena. ");
INSERT INTO pabNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Xakore hoka koxaka atyo kahare haliti semehenerenae iraiti tyakeko, kala 5.000 hare. ");
INSERT INTO pabNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kamaetali hoka ahohisakoatyakakoaha Jerusalém nali judeunae nityohalitiranaeha, judeu xaotyakiraho kakoa waiyoreterenae, exahe wenakalati waikateharenae hare. ");
INSERT INTO pabNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hatyo hohisakoahenahere koni tehitiya sacerdotenae xekohasehare Anás, Caifás, João, Alexandre harenae. Haiyanae tehitiya hatyo sacerdotenae xekohase hotyali harenae hohisakoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hatyaoseta xane nolohenahitene berexo akota hoka mokahene enahalakoaha hoka axalihenahene: — Xoana hoka nikare xisaonita? Xala niyatere kakoa, xala xaokala xema nikare xamokita? ");
INSERT INTO pabNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hatyaoseta Pedro, Isekohaliti Waiyexe kaxaihakoretene hoka nehena ekoaxahena enomanaha: — Xasemehena, xekohasetinae, judeunai nityohalitiranae xoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kalikini xaxita wiso exe haliti ana waiyexe kaomakehenere tahi, exaiyatelikisakeheta tahi. ");
INSERT INTO pabNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Xasemehena xityotya, exahe tyotya Israel hotyalinae hoka: Exe haliti kaxajiyakisaka Jesus Nazaré yere niyatere xema, etake xaisehenere atyalihose xaimaholatyaka hiye hoka Enore ekasekihetehenere niyatere xema. ");
INSERT INTO pabNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Xiso hati nomaseharenai maisa hatya sehali xaokare hati nomaka niyahare hoka hatyo najikinita kaxomokaka hati hiye hoka kinatere tyaona. Jesus Nazaré yere xaokaka nikareta. ");
INSERT INTO pabNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ekoamaniyata takita Enore maniya wikaxomokakita. Hatyo taita iniyalahare wenati nonitata iyehitita haliti. Maisa hatya aka hoka nikare iniyalahare emaisatyare. Enore atyo exe exaliti moka hoka hatyo hiyeta tyotya waiyexe maniya tyaohenahitaha maheta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hoka kalorexenae waiya Pedro, João xoaha mamairaneharene hoka hakaharetyoaha, maisa Pedro, João xoaha masakare waiyorexeha hoka. Hatyo hiyeta tehitiya otehenahitaha Jesus xema tyaonahitere. ");
INSERT INTO pabNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Waiyaha exaiyatelikirahareha tityoita ehaliyaha hoka maisa aliyakere iniyalahare iraetaha ekakoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hatyaoseta hatyo hinamahare Jesus niraene kakoarenae aihikoahetaha tyaonahitereha akota, hoka kalorexenae makere hatyokakoaha iraikakoahenaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","— Xoana ite wamohenahene? Koxaka tyotyaha Jerusalém tyaoniterenae semaha exaiyatelikirehenahitaha haliti. Maisaiya aliyakere emaoseralaha waokita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","— Xakore hoka kala waiyateretyoa ite exahitaha hoka maisa hatyo tahi halitinae koni xaoreta hoka maisa xala harenae hiye Jesus tahi iraihititaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hatyaoseta kawihenahitene, iraeha ekakoaha maisa xakaihenahititaha, maisa aotyakihenahititaha hekoti maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hoka nihitiya Pedro, João xoaha, — Enore nahalakoita nikareta wiso wityotya. Xoana xiyema kore wisaona, Enore xema kore? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","— Maisaiya atyo aliyakere wahalakijita wiraine koxaka wasemehenere, wiyaiyehenere tahi. ");
INSERT INTO pabNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hatyaoseta judeunae nityohalitiranae kinatyaxa iraeha ekakoaha amairakisahene maheta. Hatyaoseta axikahenahitahene hoka xanehenahitaha. Maisaiya aliyakere xekohasetinai iniyalahare mokahitahene, tyotya halitinai Enore kakoa ihalaharahitere hiyeta, waiyexe kaotyakitere hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hatyo kaxaiyatelikisakehetehenere 40-terehokoane jiyarehena tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Halakisaha Pedro, João xoaha hoka xanehenahitaha. Kaokehenahitaha hahinaeharenae ana hoka xakaihakatyaha ihiyeha sacerdotenae xekohasenae, judeunae nityohalitiranae xoaha iraihenahere ekakoaha tahi. ");
INSERT INTO pabNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Semaha exakaihakalaha nikarexe hoka tyotyaha haxawalita iraexahenaha Enore hiye, nehenaha: — Xekohaseti, Hiso atyo tyotya hisoma enokoa, waikoa, one kaloxere. Exahe tyotya xoalini harenae tyaonitere harenae enakoa hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Hiso atyo Isekohaliti Waiyexe koamaniyata hirae hiwakanehare Davi wahetakomaniyere hiye hoka exakere irae: Xoana hoka majudeuneharenae judeu hare hotyalinae eharahitaha? Xoana hoka nikare hatyaharahitaha? ");
INSERT INTO pabNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Xekohasetinae tyotyaha xalijinihare, kahinaetyakakoaha hoka kahalakoahareha Enore, Kalorexe Aohenere xoaha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","— Aliterexe ahohisakoatyakakoaha Herodes, Pôncio Pilatos harenae, exahe majudeuneharenae, Israel hotyalinae xoahanae ahohisakoatyakakoaha hoka kahalakoahareha Kalorexe Haohenere Jesus kakoa maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ahohisakoatyakakoaha tyomaha maheta toahiya haokitere akereta kawenatyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","— Xekohaseti, xalijiniharehenahere wihiye hiyaiya kalikini. Wimamairanehare hamohena hoka wiyakai hiraine halitinae hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Hokakitinae hare haiyatelekihetehena, exahe xoalini harenae maomakahare hoka hisomehena Hiwakanehare waiyexe Jesus nexare hiyeta hoka waiyaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Halakisaha taita hairaexalaha hoka hohisakoahitereha akiti tatakoa ekakoareha hoka tyotyaha Isekohaliti Waiyexe kaxaihakoretyahene. Hatyohekota iraiti xakaihenahitiyaha hamamairaneneha kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Hatyo xowaka tyotya tyakekohenerenae hakakoa exahekolanaeha tyaona enomanaha hoka nikare makere ahekotyahitaha. Haxiyeharenaeha maisa aokareha haomana hoka hahinaeharenaiha ana irakahitene maxiyehareharenae ana. ");
INSERT INTO pabNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kalore iyateliti kakoa Jesus niraine kakoarenae xakaihaha Xekohaseti Jesus kasehetehenere tahi akiti. Enore kalore waiye mokahene. ");
INSERT INTO pabNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Maisa atyo xala harenae enekoniha nakere, maimahiro tyaonare. Kawaikohererenae hawaikoheraha betetita, kahanerenae hoka betetyahitaha hahanaha hoka exaimane olo ");
INSERT INTO pabNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","isahita Jesus niraine kakoarenae ana. Exowakerota xala xamani nakita maimahirota hare hoka hatyo olo ijita enomanaha aokahitere akereta. ");
INSERT INTO pabNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nikare tehitiya José nexarexe betetya hakoa hawaikohera hoka xane exaimane isa Jesus niraine kakoarenae ana. José atyo Levi hotyali, Chipre nalitare. ");
INSERT INTO pabNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hoka Jesus niraine kakoarenae “Barnabé”, nita exaokaka. Nere atyo: “Wiyaxaihalahalinikisase”. ");
INSERT INTO pabNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hatya haliti Ananias nexarexe Safira nexalolo kakoa tyaonita. Kawaikoherere hoka hawaikohera betetya. ");
INSERT INTO pabNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Xakore hoka holini taita isa Jesus niraene kakoarenae ana, holini exaimane kakoa tyaona. Koxaka Safira ana hatyo tahi waiyekehalaka. ");
INSERT INTO pabNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hatyaoseta Pedro nexa Ananias hiye: — Xoana hoka Tihanare koamaniya hisaona? Xoana hoka Isekohaliti Waiyexe hamaoseratya? Xoana hoka holini kakoa hisaona, waikohe habetehenere xaimane kakoa? ");
INSERT INTO pabNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Himabeteraharenetatere waikohe xowaka hiwaikohera terota, exahe habetetene hoka exaimane holoxa terota. Xoana hoka nikare hisaona? Maisa haliti xini hamaoseratya, Enore atyo hamaoseratya. ");
INSERT INTO pabNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias nikare iraiti sema taita hoka exoa, waini. Tyotyaha semehenerenae hatyo akiti mairaha. ");
INSERT INTO pabNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Hatyaoseta tyoa haiyanae xoimahalitinae hoka olahisetyahene, kolatyahene hoka xane fityahene. ");
INSERT INTO pabNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ekamane najikinita wahasehena hoka exanityo tyoa hikoa, maisa haiyanene kamane semare hekoti. ");
INSERT INTO pabNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Exowakerota Pedro axene: — Hiyakaihena nohiye xiwaikohera hexanene betehenere xaimane: Xoana nikarexe xaresebetya exaimane? — Há, nikarexe — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro nihitiya ihiye: — Xoana hoka hexanene kakoa nikare xahasakaharetya Enore Nisekohare? Hiyaiya, owehetehena xoimahalitinae hexanene haxaferaha hekota hoka kolahenaha tehitiyaite hiso. ");
INSERT INTO pabNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nexa takita hoka exoa waikoa waini Pedro kinoli haliya. Hatyaoseta xoimahalitinae hikoahenahitehenaha xakore, waiyehenaha atyo, owene ekamane tyaonita hoka kolahenahitiyahene exanene xawatyakala nahalakoita fehenahitiyahene. ");
INSERT INTO pabNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tyotyaha iraiti tyakekoterenae, exahe haiyanae hoka semaha etahi akiti hoka kalore mairaha. ");
INSERT INTO pabNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hatyo najikinita Jesus niraine kakoarenai kahare xoalini hare maomakahare tyomaha halitinae koni, hokakitinae hare aiyatelekihenahitaha. Tyotyaha hohisakoahitaha Iraexatyakalati Hana tyaisera kilihi Salomão nómane aokahitere nali. ");
INSERT INTO pabNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Haiyanae atyo maisa enekoniha tyaonaha aokowiyeha, mairahitaha hoka. Xakore atyo hoka waiye atyo iraetaha etahiha akiti. ");
INSERT INTO pabNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ekakoita hisoakaha tyakekoahitaha iraiti, enanae ohironae harenae hoka kahareha tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hatyo hokakitinae aiyatelekihenahititere hiyeta nali tyaoniterenae hahokakitiranaeha kolatyaha ahotiaho kilihi mokahitaha exetolisoakalaha kakoita Pedro naheta, jiyehena hoka iniyakotini hekoti kaokaha ihiyeha hoka waiyehenahitaha aokahitaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hisoaka haliti tyoita Jerusalém haliyatarenae, hahokakitiranaeha kolatyahitaha xoaha enomanaha. Exahe isekohaliti iniyalahare kamilakoreranae hare nolokahitaha enomanaha hoka tyotya aiyatelekihenahititene. ");
INSERT INTO pabNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hatyaoseta sacerdotenae xekohase, tyotya ihinaeharenae xoaha haokoawahareneha, ehareha saduceunae kakoita Jesus niraine kakoarenai hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ehareha Jesus niraine kakoarenai hiye hoka otokahene hoka mokahene berexoako. ");
INSERT INTO pabNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Berexoako xakore mokahene hoka hatyo xatinita anjo enokoatare exoa hoka majiholaheta berexo hana ekakoareha, aehikoahenahitene menane aka hoka nexa ihiyeha: ");
INSERT INTO pabNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","— Xiyane Iraexatyakalati Hana nali hoka halitinae hiye xiraihitiya Jesus maniya nawenatyaka akiti — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tyakekoha hoka kamaetali weta xane isoaha Iraexatyakalati Hanako hoka aotyakihenahitiya. Hatyaoseta sacerdotenae xekohase hahinaeharenae kakoa hohisakoaha, kalorexenae makere. Israel hotyalinae nityohalitiranae tehitiya kaexakatyaha hoka tyoa kaokaha enomanaha. Ahohisakoatyakakoaha hoka axikatyaha sorarenae Pedro, João xoaha nolokaha maheta berexoakota. ");
INSERT INTO pabNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Xane kaokaha berexo hana nali hoka xane xakore waiyaha enako, maisa waiyehenahitita Jesus niraine kakoarenai. Hatyaoseta maisa nali aka hoka haikoahenahitaha hoka nexaha kalorexenae hiye: ");
INSERT INTO pabNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","— Wiyane wahikoa berexotyakalati nitini ana. Waiye jihotyakere, owene ekaxaikotyasenae tyaonita, kaxaikota hati. Wamajiholatene hoka wisoa xakore enako hoka maisa xala hare enako wiyaiyita. ");
INSERT INTO pabNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Semahene sacerdotenae xekohasenae, Iraexatyakalati Hana kaxaikotyaseharenae xekohase harenae hoka maisa xoare nexa kakanasahitaha. Ahekotyahitaha, Jesus niraine kakoarenai nikare tyaonaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hatyaoseta hatya tyoa kaoka enomanaha hoka nehena ihiyeha: — Xasemehena, etake hinamahare haliti xaberexohenere Iraexatyakalati Hana nali tyaonita, aotyakijita halitinae. ");
INSERT INTO pabNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hatyaoseta Iraexatyakalati Hana kaxaikotyaseharenae xekohase xane sorarenae kakoa Iraexatyakalati Hana xeta hoka noloka Jesus niraine kakoarenai. Maisa atyo iniyalahare mokahitene, waiya aliya hoka halitinae sehali kakoa mokotyahene aokaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nolohenahitene, xane kaokehenahitaha ekakoaha kalorexenae nali. Hatyaoseta sacerdotenae xekohase nexa: ");
INSERT INTO pabNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","— Maisa xiyaotyakira waxakoanehetita etake haliti nexare kakoa. Hiyaoreka xiyaotyakira xaore tyotya Jerusalém koa. Exahe hoka wiso waisene xaokita. ");
INSERT INTO pabNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hatyaoseta Pedro, haiyanae Jesus niraine kakoarenai hare nehenaha: — Enore niraine xema atyoite wisaona, maisaiya atyo halitinae niraine xema wisaonita. ");
INSERT INTO pabNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wahetakomaniyerenae nEnorexa ekasekiheta Jesus, etake xaisehenerene najikinita. ");
INSERT INTO pabNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ekasekihetene hoka hafihini maniya mokene Kalorexe maheta. Israel hotyalinae iniyalahare háomaneha halakisaha hoka kaxemaisatyakeheta iniyalahare enómaneha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wiso atyo ewaiyasehare terotere, Isekohaliti Waiyexe tehitiya ewaiyasehare. Xala xamani atyo tyaonita Enore xema maniya hoka ijita atyo Haisekohare enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hatyaoseta inityohalitiranai semaha iniraineha hoka masakare ehareha ihiyeha, kasani aisahene aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Xakore hoka hatya enekonitareha tityoa, Gamaliel nexarexe. Fariseu, waiyore Moisés xaotyakira kakoa. Tyotyaha tyakekoahitere hoka nehena ihiyeha: — Xaehikoatyahene ininae menane aka. ");
INSERT INTO pabNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aehikoatyahene hoka hatyaoseta nehena: — Xasemehena, Israel hotyalinae. Xiyaira, waiya aliya hoka exe hinamanae xoanani xamoka. ");
INSERT INTO pabNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","— Toahiyaseta hatya haliti kaotyaka Teudas nexarexe, kalorexe aokowita. Waiyore iraeta hoka 400-hare haliti tyaona exema maniya. Hatyohekota kaxaisaka hoka exema tyaoniterenae xaorehenahitaha tyotyaha hoka kamiyane. ");
INSERT INTO pabNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hatyo najikinita nikare hatya kaotyakihitiya Judas nexarexe, Galiléia yere, halitinae kaxihatyakitere xowakiya. Nikare kahare haliti tehitiya tyaona exema. Waini enonyahitaha hoka xaore exema tyaoniterenae. ");
INSERT INTO pabNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","— Hiyeta hoka awa atyo xoalini hare xisoma exe halitinae kakoa. Xahalaisahene hoka xanehenahitaha. Xiyaiya, exe hateniti atyo ite haliti xahekolita, haliti hateneta hoka maiyareheta. ");
INSERT INTO pabNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Hoka Enore xaokalaiya atyo hoka maisa aliyakere xemaisahititene, waiya aliya hoka Enore kakoa xikahalakoahare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nexa ihiyeha hoka tyakekoha iniraene. Xakore hoka kawihenahitaha Jesus niraine kakoarenai hoka isoahenahitaha. Hatyaoseta mokonasetyahene hoka nehenaha: — Waiyehenaira xiyakai Jesus tahi akiti — nexaha ihiyeha hoka hatyo najikinita halakihenahitene. ");
INSERT INTO pabNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Halakisahene hoka Jesus niraine kakoarenai hikoahenahita enonyahita, xanehenahitaha. Mokohekoatyahene xakore hoka ihalahare hikoahenahitaha. — Waiye kaisere. Hiyaiya, Jesus hinaenai terota wiso hoka nikare mokahitaha wiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hatyohekota ferakiti nihatyaka Iraexatyakalati Hanako heko aotyakisahitaha halitinae, exahe ehananaihako nihatyaka aotyakisahene minita Jesus Enore Kalorexe Aohenere tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hatyohekota wahehena hoka ekakoita haliti kaharehena tyaonita Jesus xema maniya. Hatyohekota nehenaha hebreunae xako iraiterenae hiye Grego xako iraiterenae: — Maisa waiyeta womana winekonitalonae maiyanenehalonae nakairati maxekakene. ");
INSERT INTO pabNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hatyohekota 12-hare Jesus niraine kakoarenai ahohisakoatyaha iraiti tyakekoterenae hoka nehenaha: — Maisaiya ehekoreta xini wahalakisa Enore niraine xakaisaka hoka nakairati hiye wisaona hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kala xinekonitare 7-hare xamoka waiyexeharexe, waiyorexe, Isekohaliti Waiyexe kaxaikonehare hoka exe hateniti wahalakisa enomanaha, wihinaeharenae. ");
INSERT INTO pabNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Hoka wiso atyoite wiraexatita, Enore niraine kakoa waotyakijita takita — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tyotyaha Jesus niraine kakoarenai niraene tyakekoha. Hatyaoseta mokaha Estêvão, Filipe, Prócoro, Nicanor, Timon, Pármenas, Nicolau harenae. Nicolau atyo Antioquia tare. Majudeunehare xakore hoka koxaka judeunae xaotyakira xema tyaonita. Estêvão atyo iraiti tyakekota kaiserehare, Isekohaliti Waiyexe kaxaihakoretitene. ");
INSERT INTO pabNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Hatyaoseta xane hotikisahene Jesus niraine kakoarenai ana hoka hakaheha mokaha eseriha heno hoka iraexatyaha etahi akiti waiye hakaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Hekota Enore niraine xaoreta, hakakoare semaha. Ekakoita Jesus maniya tyaoniterenae Jerusalém nali hisoaka kaisereharehena tyaonahitaha. Kahare sacerdotenai tehitiya tyakekoahitaha hoka tyaonahitaha Jesus xema maniya. ");
INSERT INTO pabNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Enore kahinaetita Estêvão, hoka waiyore iraeta. Kahare xoalini hare maomakahare tyomita halitinae koni, hokakitinae hare aiyatelikihitita enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Xakore hoka haiyanae ana maisa waiyeta hoka ehareha Estêvão hiye. Xahohisakoatyakalati “Mawakahareneharenae xahohisakoatyakala hana” aokahitere nalitarenai. Hatyo judeunae Cirene, Alexandria nalita tyohenerenae. Hatyonai, exahe haiyanae judeunai Cilícia koatarenai, Ásia nali koatarenae xoaha kahalakoahare Estêvão kakoa hoka kinatyaxa iraeha ekakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Xakore hoka maisa jiyahaotyahita Estêvão. Isekohaliti Waiyexe kaxaehakoretitene hoka jiyahaotyahene tyotya. ");
INSERT INTO pabNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hatyaoseta haiyaharenae bakatyaha hoka nexaha maheta: — Wasema exe haliti niraene iniyalahare Enore, Moisés xoaha xaokaka. ");
INSERT INTO pabNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hatyaoseta xane iraeharetyahene hoka halitinae, judeu xaotyakiraho kakoa waiyoreterenae, inityohalitiranae harenae ehareha makere Estêvão hiye hoka otokahene, kalorexenae nahalakoa kolatyahene. ");
INSERT INTO pabNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Haiyanae iniraeharetyase maheta mokaha hoka exakere maoserahenaha: — Exe haliti maisa iniyalahare hairaine halakisare wiraexatyakala hana tahi akiti, exahe Moisés xaotyakiraho akiti hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Exakere iniraine wasemita: “Jesus Nazaré yere ite mawenekoaretya hati wiraexatyakala hana, exahe Moisés iraitiya halakihenere womana hoka hahekore moka” — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Hatyaoseta tyotya hatyoako kalorexe tyokiterenae wahakotyaha waiye Estêvão ana, waiyehenaha atyo itiho ana. Motya atyo anjo tiho. ");
INSERT INTO pabNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Hatyaoseta sacerdotenae xekohasehare axehena Estêvão: — Xoana aliterexe iraetaha hitahi? ");
INSERT INTO pabNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Hoka nehena Estêvão: — Xasemehena, abá xoimanae, nohinaeharenae. Enore werokakoa tyaonitere tyoa kaotyaka wahetakomaniyere Abraão ana tyaonitatere Mesopotâmia nali xowakiya, Harã nali mawenaneharetatere xowaka. ");
INSERT INTO pabNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Enore nexa ihiye: “Hakikisoahena ali hiwaikoherata hihinaeharenae nonitata. Hiyanehena waikohe nahotikihenere koa homana xeta”. ");
INSERT INTO pabNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","— Hoka Caldeunae waikohera nalita xane, xane tyaona wenakalati Harã nali. Hatyaoseta enexe kamane najikini maniya Enore noloka Abraão kalikini ali xisaonitere nali. ");
INSERT INTO pabNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Xakore hoka maisa Abraão ana ini hekoti waikohe ijita. Hoka nexa atyo Enore ihiye: “Ekakoita ite exe waikohe homanere tyaona, exahe hijikolaharenae anere hoka waikohe tyaona”, nexa ihiye. Enore iraitere Abraão kakoa xowaka maisa kaisaniye. ");
INSERT INTO pabNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","— Exakere Abraão hiye irai: “Hijikolaharenae ite xane tyaonaha hakitiya. Mawaiyakahare hotyali, wakahare akere ite tyaonaha. Iniyalahare ite kaxomokakaha waha aka 400-terehokoane”. ");
INSERT INTO pabNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Enore nehitiya: “Hatyo najikinita iniyalahare ite namoka hijikolaharenae iniyalahare mohenere, wakahare mohenere. Hatyaoseta ite haikoahenahitaha hoka ali tyaohenaha nokoa maniye”. ");
INSERT INTO pabNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","— Hatyaoseta nehena Abraão hiye: “Maika nomaniye hisaona hoka homanere milihe haikotya hihanako tyaoniterenae kakoa”, nexa ihiye. Hatyaoseta Isaque kaisani hoka 8-ferakenehena hoka enomanere milihe aikotya. Nikare Isaque Jacó kaisani hoka enomanere milihe aikotya. Nikare tehitiya Jacó 12-hare kaisani hoka enomanere milihe aikotya. ");
INSERT INTO pabNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Estêvão heko iraeta: — José hiye okoawahare enaxenanenae wahetakomaniyereharenai hoka betetyahene Egito nali wakahare tyaona maheta. Xakore hoka Enore atyo kaxaikotene ");
INSERT INTO pabNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hoka emaisatya enonita examaikoharene, exahe enawenane howitiharexe. Faraó, kalorexe Egito naliyere, José waiyehenere xowaka Enore waiyexe waiyoliniti isa enomana hoka Faraó awaiyetene hoka kalorexe mokene hahanako. ");
INSERT INTO pabNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","— Hatyaoseta Egito nali Canaã nali nakiti tyaona hoka maisa xoare kanakairihenahitere wahetakomaniyerenae. ");
INSERT INTO pabNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nakahitaha hoka ekakoita semehena atyo Jacó, Egito nali nakairati hoka hetatiye axikahena haisaninae wahetakomaniyerenae Egito nali xeta nakairati iyaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hatyota xanehenahitiyaha hoka José awaiyekehalakaharetyoa haxenanenae ana. Hatyaoseta xekohaseti Faraó ana waiyekehalaka ihinaeharenae tahi. ");
INSERT INTO pabNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Hatyaoseta José kawisa hanexe Jacó, tyotyaha ihinaeharenae Egito nali xeta. Hatyo xowakiya Jacó hotyali 75-hare ehohisakoaneha. ");
INSERT INTO pabNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jacó xane tyaona Egito nali hoka hatyo nali waini, wahetakomaniyereharenae harenai. ");
INSERT INTO pabNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Wainiha najikini kolahenahitene Siquém nali xawatyakalati nitinako mohenahititaha, enatyokoeha Abraão niyane Emor jikolaharenae nonitata ako. ");
INSERT INTO pabNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","— Hatyo hekota Abraão ana Enore afetalatitere terehokoane okoi hikoahena: “Egito nalite nanoloheta xiso”, nitere aose xane hikoahena hoka hisoakehena Jacó hotyali tyaonita Egito nali. ");
INSERT INTO pabNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Hatyaoseta hatya tyaohitiya xekohaseti Egito nali, maisa José waiyasehare xini. ");
INSERT INTO pabNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hatyo xekohaseti waiyore wahetakomaniyerenae kakoa hoka xalijiniharehena exahitaha, exahe ityani mokosenaiha xawatyaka aokita ihiyeha wainiha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Hatyo xowakiya Moisés tyaona, waiye mokose. Hanamali kaimare inityo, enexe hatyako taita kaxaikotahene. ");
INSERT INTO pabNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Hatyaoseta halakisahene kanowalise akota, maisa aliyakere xoana mokahene xaka hoka. Hoka Faraó ityani waiyene hoka anaetene haisani kaiserehare akere. ");
INSERT INTO pabNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Hiyeta hoka Moisés waiyore xoalini hare kakoa Egito yerenae xaotyakira akiti kakoa. Exahe xoalini hare tyoma aokowihena hoka waiyore tyomita, iraeta xoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","— Kala Moisés ekakoita 40-wanonehena hoka xane hahinaeharenae Israel hotyalinae waiya aokowita. ");
INSERT INTO pabNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Xane hoka waiyehena, owene atyo ihinaehare Egito yere maisa waiye xini mokita. Hatyaoseta kaxemeretya hahinaehare hoka aisa Egito yere. ");
INSERT INTO pabNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Motya atyoala Moisés xahekola hiye semahitaha exaihako maniyata Enore niyaneheta Israel yerenae aokita Egito nalita. Xakore hoka maisa atyo waiyekehalakere enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","— Hatyota kamaetali hoka Moisés waiyehena atyo, hinamahare ihinaehare Israel yerenae makere atyo owene mokotyakakoita. Hatyaoseta xane kaoka enomanaha hoka watyalihenahene. “Xoana hoka nikareta xiso, Israel yerenae makere xiso hoka?” nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Hoka masakare xalijiniharetere hahinaehare xahita herawaseharetene hoka ekoaxatya enomana: “Xoana hoka hiwatyali wiso? wiyekohase kore hiso? ");
INSERT INTO pabNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Xoana haisakore natyo haokowita kafaka haijitere Egito yere akere?” nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sema Moisés hatyo haxaisane tahi hoka tekoaheta, xane tyaona Midiã koa nali. Nali hinama mokose ityani tyaona. ");
INSERT INTO pabNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","— Hatyo nali 40-terehokoanehena Moisés tyaonita hoka anjo kaotyaka enomana atya mokose kiritere koni maharexakiti Sinai tyairiya nali. ");
INSERT INTO pabNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés wahakotya enomana xakore, maisa kera tyotere hoka: “Xoanere kaisere?” nexa, xane ehaliya kaoka enomana waiye waiya maheta. — Hatyaoseta Enore niraine semehena: ");
INSERT INTO pabNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Natyo atyo hahetakomaniyerenae Abraão, Isaque, Jacó xoaha nEnorexa”. Nexa hoka Moisés tatakoa maira, maisa aliyakere wahakotya xaka enomana. ");
INSERT INTO pabNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","— Hatyaoseta Enore nexa ihiye: “Haitoakihena hikijitini. Ali hatyahakitere koa atyo notyaonita hoka nikareta natyo. ");
INSERT INTO pabNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nowaiyita nokaxaikoni hotyalinae makawatini Egito nali, ewaolitiniha. Hiyeta notyoa niyehenahitene maheta hatyo nalita. Naxikatya ite hiso kalikini Egito xeta”. ");
INSERT INTO pabNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","— Hatyo Moisés Israel hotyalinae maxawaiyerehenereta: “Xoana hoka hiwatyali wiso? wiyekohase kore hiso?” Xakore hoka Enore atyo mokene xekohaseti mokene iyehenahitene maheta, anjo atya takoitere koni kaotyakehenere enomana kahinaetene hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hatyo Moisés atyo Israel yerenae iyeheta Egito nalita. Kahare xoalini harenae waiyexe maomakahare tyoma, hatyo waikohe nali, maharexakahare nali, one xotyaxere hare nali, 40-terehokoane. ");
INSERT INTO pabNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","— Hatyo Moisés ta nexa Israel yerenai hiye: “Enore ite hatya iraiti xakaisasehare xinekonita moka natyo akereta. Maikaite xinekonita kaotyaka xomana”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hatyo Moisés tyaonita hahotyalita Israel yerenae kakoa maharexakiti, nali tyaonita wahetakomaniyerenae kakoa. Exahe anjo iraitere ekakoa tyairi Sinai nali kakoa hoka. Hatyo ana atyo kaxekaka iraiti xairatyaka Enore niraine waiyexe womana. ");
INSERT INTO pabNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","— Xakore hoka wahetakomaniyerenae maisa Moisés xaotyakira xema tyaona aokowiye, kasani haikoahenahita aokowiyahita Egito nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hoka nexaha Arão hiye: “Hisoma womana wenorexanae hoka hatyo enorenae xaneha waheta maniya. Kala xoana xamani tyaona Moisés iyehetehenere wiso Egito nalita. Maisa waiyekehalakere womana”. ");
INSERT INTO pabNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","— Hatyaoseta tyomaha haenorexaha maheta bowi mokose akerehare hoka xoalini hare aisaha hoka fetatya enomana. Hatyo najikinita tyomaha hisehaliti hatyo haenorexaha tyomehenahere kakoa ihalahareha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hatyo hiyeta Enore kikisoa enonyahitaha, halakisahene. Halakisahene, enokoa xorese tyaoniterenae aokaha haenorexaha maheta. Hiyaiya, owene kaxairatyaka: Xasemehena, Israel hotyalinae: maisa nomani xini xaisa kirakahare hoka xafetatya 40-terehokoane xisaohenere nase maharexakiti nali. ");
INSERT INTO pabNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Xakolatya xenorexa Moloque hanalise. Exahe Renfã xoresera xisoma hoka xakolatya xenorexa maheta, hatyohare xenorexa xaokita. Hatyoharenae xisoma xisaona exemaha maheta. Hatyohare hiyeta ite naxanikisa xiso Babilônia xaihako maniya. ");
INSERT INTO pabNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","— Hatirise kakoare wahetakomaniyerenae tyaonita maharexakiti nali. “Nikarexe hisoma”, nexa Enore Moisés hiye aotyakijitene, hoka hatyo hotikijitere akere tyomene. ");
INSERT INTO pabNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hatirise kakoarehena wahetakomaniyerenae ityaninai hoka Josué kakoa xane Canaã koa isoahenaha hoka kolatyahene. Kaokaha hoka tyaonaha hatyo Canaã waikoherakoa, hawaikohera aokahene. Nali tyaoniterenae Enore kikisa enonyahitaha. — Davi tyaohenere xowakiya hekotata hatyo hatirise tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Enore awaitita Davi hoka Davi hati tyoma enomana aokowi, Jacó hotyali nEnorexa ana. ");
INSERT INTO pabNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Xakore hoka Salomão atyo tyoma hatyo hati Iraexatyakalati Hana Enore anere maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","— Hoka Enore atyo masakare kalorexe kaiserehare hoka maisaiya aliyakere haliti nómane ako tyaonita, iraiti xakaisasehare iraehenere akereta: ");
INSERT INTO pabNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Enokoa atyo nokahakali, nexa Enore. Hoka waikoa atyo nokiji namokita. Aliyakereya xisoma hati nomani? Aliyakereya xisoma nomani hoka hatyo nali notyaohena? ");
INSERT INTO pabNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Xoana maisa natyo xini tyotya xoalini hare notyoma? ");
INSERT INTO pabNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Hatyaoseta nexa Estêvão miyatya haxakaini: — Kaxiyani ximahakaisere, xikinatere xaokowita. Ximatanakoakohare hoka maisa Enore niraine xasemare xaokowiye. Xahetakomaniyerenae akereta xisaonita, Isekohaliti Waiyexe kakoa xikahalakoahareta. ");
INSERT INTO pabNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hiyaiya, xahetakomaniyereharenae iraiti xakaisaseharenae xahita xalijinihareta, exahe hoka aisahitaha Enore niraine xakaisaseharenae, Waiyexe Wakahare tyoanene tahi xakaiterenae. Exahe xiso atyo kalini xamatawatya hoka xaisa hatyo Iniyalahare Maomanehare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","— Anjo hiyeta xakore kaotyaka xomana xaotyakisati hoka maisa xisaonare exema — nexa Estêvão miyatya. ");
INSERT INTO pabNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Hatyaoseta hatyo inityohalitiranae semaha Estêvão niraine hoka masakare ehareha ihiye, haxehareneha haikoliha hiye, “Karai, karai, karai”, nexaha mokaha exahita. ");
INSERT INTO pabNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Hoka Isekohaliti Waiyexe kaxaihakoretya Estêvão hoka eno maniya wahakotya. Waiyehena atyo, owene Enore tyaoniterekoa werokita. Waiya tehitiya Jesus, owene tityoita Enore fihini maniya ehaliyita. ");
INSERT INTO pabNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Hatyaoseta nehena: — Xiyaiyehena! Owene enokoa totakore tyaona hoka nowaiya Haliti Ityani. Tityoita Enore fihini maniya. ");
INSERT INTO pabNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nexa hoka talatya, jihotyaha hatanakoako. Hatyaoseta kawiyatyaha toli kinatyaxa hoka tyotyaha jiyaha Estêvão ana. ");
INSERT INTO pabNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Hatyohekota nolokasekoatyahene, hikoaha menane aka ekakoa, xaneha wenakalati nonitata haware ekakoa hoka sehali kakoa mokotyahene. Iniraeharetyasenae Saulo nexarexe xoimahaliti ana isaha haimanasenaiha enomana kaxaikone maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mokotyahiterene nase Estêvão kawihena: — XekohasetiJesus, hiyeheta nisekohare. ");
INSERT INTO pabNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hatyo najikinita hakaoli kakoa tyoka hoka kawiyatya kinatyaxa: — Xekohaseti, awaira atyo iniyalahare hamohenahene exe iniyalahare mohenahere natyo xemere. Nexa taita hoka waini. Hoka Saulo hiye waiye kaokene exaisaka. ");
INSERT INTO pabNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kahenehare tyaonahenaha hatyo xowakita Jesus xema maniya tyaoniterenae xahita Jerusalém nali. Tyotya tyakekoterenai xahita xalijinihareha, aekoakisahene hoka xaoreha. Judéia koa Samaria koa xoaha xaneha, xaoreha. Jesus niraine kakoarenai taita heko tyaonita Jerusalém nali. ");
INSERT INTO pabNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Hoka haiyanae haliti waiyexeharexenae fitya Estêvão, kahare tiyaha ekamane hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Xakore hoka Saulo Jesus maniya tyaoniterenae mawenekoaretya aokowi. Xane ijoita hatinae nihatyaka, nolokehekoaita enanae, ohironae hare, xane xawatyahitene berexo ako. ");
INSERT INTO pabNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Hoka hatyo xaoreterenae xane xakaihakatyahitaha iraiti tyotya wenakalatinae nihatyaka koa. ");
INSERT INTO pabNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Hatyaoseta Filipe xane wenakalati Samaria, xakaihakatya Enore Kalorexe Aohenere tahi akiti nali tyaoniterenae hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Xakaihakatya ihiyeha hoka waiye semaxematyahitaha Filipe niraine. Tyotyaha semahitaha, waiyahitaha xoalini harenae maomakaharenae enómane. ");
INSERT INTO pabNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Isekohaliti iniyalahare kamilakoriterenae nonita aihikoahitita. Hikoahetehena enonyahitaha hoka awerahalikikoatyahitene. Kahare mawaiyenetonaneharenae, maitonaneharenae hare aiyatelikiheta. ");
INSERT INTO pabNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nikare hoka tyotyaha ihalaharetaha hatyo wenakalati nali. ");
INSERT INTO pabNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nali tyaonita hatya haliti Simão nexarexe. Haholitaharexe atyo hoka xoalini hare tyomita. Wahakiyehena nikare tyaonita hoka hakaharetyoa Samaria yerenae mokita. Kalorexe aokowita ");
INSERT INTO pabNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","hoka tyotya nali tyaoniterenae waiye semaxematyahita iniraine, iraihena hoka waiye tyakekoahitene. — Exe haliti Enore niyatere kakoare kaiserehare. Kalorexe iyateliti aokahitere kakoare — nexahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wahehena nikare tyaonita, haholitahareta hoka tyakekoahitene, hakaharetyoa mokahitene, xoalini hare tyomehena hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Xakore hoka Filipe xakaini Iraiti Waiyexe Enore koamaniya nawenatyaka tahi tyakekoha hoka kabatixatyakaha Jesus nexare kakoa, enanae exahe ohironae tehitiya hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hatyaoseta hatyo Simão nikare tehitiya tyakeko hoka kabatixatyaka. Hoka Filipe kaxaikota hoka kahare xoalini hare maomakahare, hokakitinae hare kaxaiyatelikisakihititere waiya hoka hakaharetyoa. ");
INSERT INTO pabNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Hatyaoseta Jerusalém nali Jesus niraine kakoarenai tyaoniterenae semaha wenakalati Samaria tyaoniterenae nawenane Enore koamaniya hoka hatyo hiyeta Pedro, João xoaha axikatyaha nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hatyo hinamanae xane kaokaha hoka iraexatyaha Samaria yerenae tahi, Isekohaliti Waiyexe kaoka tyakekoterenae ana maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Hatyo xowaka maisa xala harenae ana exoahenere Isekohaliti Waiyexe. Koxaka taita atyo kabatixatyakaha Jesus nexare kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hatyaoseta Pedro, João xoaha eseriha heno mokaha hakaheha hoka Isekohaliti Waiyexe exoa enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simão waiya Jesus niraine kakoarenai xekaokakira hakaheha ihiyeha hoka Isekohaliti Waiyexe kaokene hatyo halitinae ana. Hoka hatyo hiyeta aimatya olo Pedro, João xoaha ana ");
INSERT INTO pabNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","hoka nehena: — Owene olo hoka xisa nomani hatyo iyateliti hoka nikare nekaokakihena nokahe hatya hiye hoka Isekohaliti Waiyexe kaoka enomana. ");
INSERT INTO pabNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hatyaoseta Pedro nehena ihiye: — Maika Enore axikatya hiso, holoxa xoaha irikati koni! ");
INSERT INTO pabNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maisaiya aliyakere wihatene koni hahakita. Hiyaiya, hiyahekola maisa waiyexe Enore haoti. ");
INSERT INTO pabNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hahalakihena exe hiyahekola iniyalahare hoka Enore hiye hiraexatya hoka maotyaoneheta iniyalahare hiyahekola. ");
INSERT INTO pabNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nowaiyita hiso, masakare hokoawahareta. Hokoawaharene atyo motya nikanati tihene, exahe iniyalahare hománe atyo tokita hiso. ");
INSERT INTO pabNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hatyaoseta Simão nehena Pedro João xoaha hiye: — Xiraexatya Enore hiye notahi akiti hoka maisa nikare notyaonita exe xiraitere akere. ");
INSERT INTO pabNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hatyaoseta Pedro, João xoaha haikoahenahitaha Jerusalém nali xeta haxakainiha Enore niraine najikinita. Xanehenahitaha ahotyaho hoka xakaihakahohenahititaha Iraiti Waiyexe Samaria koa tyaoniterenae hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Hatyaoseta anjo Enore nalitare nexa Filipe hiye: — Haxakaiharetyoahena hoka hiyane Jerusalém naho Gaza xeta — nexa. Hatyo naho komita maisa kahare haliti jiyare. ");
INSERT INTO pabNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nexa hoka Filipe xakaiharetyoa hoka xane hatyo maniya. Ahotyaho xaneta ene hoka ahalakoatya hatya haliti kaxaiko akatyatiye, Etiópiatare. Haikoahitita hawaikohera xeta. Hatyo haliti komita ene kalorexe tyaonita. Etiópia yerenae xekohasero Candace wakanehare tyaonita. Tyotya ixiyehare enoloxa hare kaxaikotyasehare tyaonita. ");
INSERT INTO pabNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Koxaka Jerusalém nali xane Enore awaiyetya maheta hoka hatyo nalita haikoahitita, xanehitita hakarosanako hawaikoherakoa xeta. Tyokita hakarosanako hoka ihatita iraiti xakaisasehare Isaías xairala. ");
INSERT INTO pabNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Hatyaoseta Isekohaliti Waiyexe nexa Filipe hiye: — Hiyane hikaoka enomana hoka exe karosakore xema hiyane. ");
INSERT INTO pabNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipe xanehena, xane okoi kaokehena ekarosane ana hoka semehena atyo, kaixaretita atyo iraiti xakaisasehare Isaías baberanexa. Hoka axehenene: — Xoana waiyekehalakita homana hatyo hakaixaretitere? ");
INSERT INTO pabNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","— Maisaiya aliyakere waiyekehalakita nomani exe nakaexaretitere nomaxawaiyekehalakatyakinihareta — nexa. Hatyaoseta nehitiya: — Hisohena, hisoka nohaliyi — nexa hoka Filipe kakoha ekarosanako, tyoka ehaliya. ");
INSERT INTO pabNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Exakerexe tahi kaexaritita Iraiti Waiyexe nanekoa, hatyo kaxaiko akatyatiye: Kalanero exaisakaose kanolokakitere akereta mokahene, exahe kalanero mokose kaxaikolisakehena hoka haxaikolisasenae ana mema tyaonitere akereta maisa kakanaseta enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Maisa kaxaiminisakita. Maisa aiminisahitene, maisa waiye mokahitene. Xalaiya ijikolahare tahi xakaihena? Hiyaiya, kamiyane atyo enawenane ali waikohekoa. ");
INSERT INTO pabNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Hatyaoseta hatyo kaxaiko akatyatiye axehena Filipe: — Hawaiyekehalakatya nomani: Xala tahi nikare iraeta? Xoana haxaokakita? Hatya xaokaka kore? ");
INSERT INTO pabNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hatyaoseta Filipe awaiyekehalakatya hatyo akiti enomana, xakaihena Waiyexe Iraiti Jesus xaka ihiye. ");
INSERT INTO pabNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Xanahitaha hoka xane hikoaha one ana hoka hatyo kaxaiko akatyatiye nehena ihiye: — Hiyaiyehena, owene one. Maisaiya xoare hare mahokoanetita nobatixatyaki, alitereka? ");
INSERT INTO pabNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","— Waiyeya hityakekota kaiserehare hoka ehekoriya nali — nexa Filipe ihiye. Hoka nexa: — Há, notyakekota kaiserehare. Jesus Cristo atyo Enore Ityani naokita. ");
INSERT INTO pabNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hatyaoseta hatyo kaxaiko akatyatiye amemakisa hakarosane hoka exoaha hatyo onexa hoka Filipe batixatene. ");
INSERT INTO pabNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hatyaoseta kenekoahenahitaha onexata hoka Enore Nisekohare kolatya Filipe. Hatyo kaxaiko akatyatiye maisa waiyehititene hekoti, xakore hoka jiya xanehitiya haihalaharene kakoa. Ihalahare kaiserehare atyo. ");
INSERT INTO pabNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hatyaoseta Filipe xane eharehenerota kaoka wenakalati Azoto nali. Hatyaoseta xakaita Waiyexe Iraiti tyotya naliyerenae hiye, nikare wenakalati koarenae hiye Cesaréia nali xane hikoahenere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Hatyo xowaka Saulo masakare xalijinihare tyaonita Jesus xema maniya tyaoniterenae xahita. Hatyaoseta xane irai sacerdotenae xekohase kakoa, ");
INSERT INTO pabNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","axita baberane iniraine kakoare judeunae xahohisakoatyakala hanakonae niyahare wenakalati Damasco nali hotikisa maheta. Hatyo iraiti hiyeta Saulo otoka aokowita Jesus koamaniya tyaoniterenae ena, ohiro harenae hoka kolahenahitene olatyoare Jerusalém nali xeta maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hoka Damasco naho xaneta Saulo, okoi kaokehena wenakalati nali hoka enokoata xaokanatyakalati ehoko haliya werokakoa moka. ");
INSERT INTO pabNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Hatyaoseta exoa waikoa hoka semehena atyo iraitihena ekakoa: — Saulo, Saulo, xoana hoka hiyalijinihare noxahiti? nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","— Xala hiso, Xekohaseti? nexa Saulo axene. — Natyo atyo Jesus hikirawanetere. ");
INSERT INTO pabNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Hainakoahetehena hoka hiyane hisoahena wenakalatikoa xeta. Nalite iraeha hihiye hawenane tahi akiti. ");
INSERT INTO pabNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Halitinae Saulo xema xaneterenae tyotya amematyoaha, maisa xoare nexa iraetaha. Semaha xakore atyo iraiti hoka maisa atyo xala hare waiyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Hatyaoseta Saulo tityoaheta, waiyakahetehena xakore, maisa waiyakahitita. Hatyaoseta otokahisahene ekahe hiyeta hoka xaneha ekakoa Damasco nali. ");
INSERT INTO pabNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Hanamaki ferakene mawaiyahakalahare tyaona. Hatyo ferakenenae maisa kanakairare, maisa terare hekoti. ");
INSERT INTO pabNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco nali tyaonita hatya Jesus xema maniya tyaonitere, Ananias nexarexe. Kaxawaiyanikisaka hoka Xekohaseti kaotyaka enomana hoka kawisa: — Ananias! nexa. — Xoare haoka, Xekohaseti? nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Hatyaoseta Xekohaseti aotyakisene: — Hiyanehena Judas hana nali xeta hoka ahoti Totahore aokahitere hatawa haliti Tarso tare Saulo nexarexe xahita. Nali iraexatita. ");
INSERT INTO pabNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Koxaka kaxawaiyanikisaka: kaotyaka enomana Ananias nexarexe. Isoa hatyako enomana, moka hakahe ihiye hoka waiyakaheta waiyitere akereta maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nexa xakore hoka Ananias nehena: — Xekohaseti, kahare halitinae xakaita hatyo haliti tahi akiti. Jerusalém nali iniyalahare mokita kahare hiyema maniya tyaoniterenae. ");
INSERT INTO pabNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kalikini ali Damasco tyoa sacerdote xekohasenae baberanexa kakoa olatya hoka berexotya maheta hiyema maniya tyaoniterenae — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Hatyaoseta Xekohaseti nehitiya Ananias hiye: — Hiyanehena enomana. Naoka hatyo haliti nowakanihare maheta hoka xakai maheta notahi akiti tyotya haliti hotyalinae hiye, exahe xekohasetinae hiye, exahe Israel hotyalinae hiye hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Natyotaite Saulo ana nahotikihena exemawatikisaka nohiyeti — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hatyaoseta Ananias xane isoa Judas hanako hoka ekaokakisa hakahenae Saulo hiye hoka nehena: — Nohinaehare Saulo, Xekohaseti axikatya natyo ali. Etake hiyaiyehenere Jesus Damasco naho nali axikatya natyo homana hiyaiyakahitiya maheta, Isekohaliti Waiyexe kaxaehakoretya hiso maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nexa taita ihiye hoka exoahetehena kohase tyatyase akerehare Saulo xose akota hoka waiye waiyeheta. Hatyo najikinita ainakoaheta hoka xane kabatixatyaka. ");
INSERT INTO pabNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kanakairihenere najikinita kinatere tyaoheta hetatiye akereta. Hatyaoseta Saulo tyaona akaiki ferakene Jesus koamaniya tyaoniterenae kakoa Damasco nali. ");
INSERT INTO pabNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Xakaihena rotita Jesus tahi akiti ihiyeha judeunae xahohisakoatyakala hananae ako. Nehena: — Jesus atyo Enore Ityani. ");
INSERT INTO pabNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tyotyaha semahitaha Saulo niraine hoka hakaharetyoaha, axakakoahitaha: — Xoana, maisa exe haliti xini aijita tyotya Jesus koamaniya tyaoniterenae Jerusalém nali? Xoana, maisa exe xini ali tyoa hoka olatya Jesus koamaniya tyaoniterenae hoka kolatyahene maheta sacerdotenae xekohasenae ana aokowitere xini? ");
INSERT INTO pabNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Xakore hoka Saulo hairaine kakoa aiyateretyoa iraiti kakoa, ekakoita waiyore kaiserehare irai. — Jesus atyo Enore Kalorexe Aohenere terota — nita xakaita ihiyeha. Waiyore xakaita hoka judeunae Damasco nali tyaoniterenae maisa aliyakere xoare nexareha. ");
INSERT INTO pabNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tyaona waha ferakenehena hoka judeunae ahohisakoatyakakoaha hoka aisahene aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Xakore hoka Saulo atyo sema exahekolaha tahi akiti. Wahatyahene wenakalati xisoakala nali. Ferakoa, makiya xoaha wahatyahitaha aisahene maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Hoka haxowaka makene Saulo hinaeharenae xane ekakoa hoka exoakisahene talare hoko motokoare xowata. Mokahene koho ako hoka exoakisahene. ");
INSERT INTO pabNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hatyaoseta Saulo xane Jerusalém xeta hoka kasani Jesus koamaniya tyaoniterenae kakoa haxawalita tyaona aokowita. Xakore hoka tyotyaha mairahitaha, maisa tyakekoreha Jesus xema maniya enawenane hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hatyaoseta Barnabé xane exema kahinaetene hoka hotikisene Jesus niraine kakoarenae ana maheta. Xakai ihiyeha Saulo waiyehenere Jesus ahotyaho, Jesus iraihenere ekakoa tahi hare. Barnabé xakai ihiyeha tehitiya Saulo xakaihakala Iraiti Waiyexe tahi akiti, maisa haxakaini kakoa mairita Jesus tahi akiti wenakalati Damasco nali. ");
INSERT INTO pabNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hatyo hekota Saulo tyaona enekoniha. Xaneta etalokoaita tyotya wenakalati Jerusalém koa, aiyateretyoita haxakaini iraiti Xekohaseti tahi akiti kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hatyo Jerusalém nali haiyanae judeunae hoka grego xako iraiterenae kakoa Saulo iraeta hoka komita kinatyaxa iraikakoahitaha. Hatyaoseta kasani aliyakere xamani mokahene hoka aisahene aokowiyahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hatyaoseta ihinaeharenae semahene hoka Saulo nolokaha wenakalati Cesaréia nali hoka hatyo nalita axikatyahene wenakalati Tarso nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Hatyaoseta Jesus koamaniya tyaoniterenae mehexaiko tyaonahitaha, Judéia koa, Galiléia koa, Samaria koa tyaoniterenai. Ekakoita tyakekoaha kaiserehare. Isekohaliti Waiyexe kahinaera hiyeta hisoakehena, waiye aiminisahitaha Xekohaseti. ");
INSERT INTO pabNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Hatyo xowakiya Pedro xaneta tyotya wenakalatinae koa xeta. Ekakoita xane kaoka wenakalati Lida nali waiya maheta Enore kaxaikoneharenae. ");
INSERT INTO pabNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nali Enéias nexarexe ana hikoa. Maitonanehare, 8-terehokoanehena maisa moxomoxore hekoti haxehokotyoakalata. ");
INSERT INTO pabNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Hatyaoseta Pedro nehena: — Enéias, Jesus Cristo aiyatelikiheta hiso. Hatityoahetehena hoka hiyehokotyoakala haxakaihetehena — nexa. Nexa ihiye hoka Enéias tityoaheta rotita. ");
INSERT INTO pabNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Hatyaoseta tyotya tyaoniterenae wenakalati Lida, Sarona nali xoaha semaha hatyo tahi hoka Xekohaseti xema maniya tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Exowaka wenakalati Jope nali hatya ohiro tyaonita Jesus koamaniya, Tabita nexalolo. Hatyo enexalo atyo Dorcas Grego xako. Tyaonitere xowakiya waiyexe tyomita, kahare kahinaetita maoloxaharenae. ");
INSERT INTO pabNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Hatyo xowakiya Dorcas hokaka hoka waini. Tihaha ehálo. Hatyaoseta kolatyahene xane mokahene hatyako enoako. ");
INSERT INTO pabNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Hatyaoseta Jesus koamaniya tyaoniterenae semehenaha atyo, Pedro tyaonita wenakalati Lida nali, Jope haliyita. Hoka axikatyaha hinamahare haliti enomana kaexakatyahene maheta. — Hisohena rotita Jope xeta, hihalahare — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nexaha ihiye hoka Pedro xane exemaha. Xane kaokaha hoka nolokahene enoako xeta. Tyotya maiyanenehalonae exahiyatene hoka tiyahitaha, hotikisahitaha haimaha itinolala kasetatere xowakere enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Hatyaoseta Pedro aihikoahenahitene tyotyaha hatyoakota. Hatyaoseta tyoka hakaoli kakoa hoka iraexatya. Hatyo najikinita ehaikoaheta kamati maniya hoka nehena: — Tabita, hainakoahetehena — nexa. Hatyaoseta Tabita waiyaliheta. Waiya Pedro hoka tyokeheta. ");
INSERT INTO pabNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro otokene ekahe hiyeta, kahinaetene hoka atityoakihetene. Hatyaoseta kawisa tyotya Jesus koamaniya tyaoniterenae maiyanenehalonae kakoita hoka isehenahitene enomanaha kasexe. ");
INSERT INTO pabNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Hatyo nexaka hakakoare xakaikoatyaha wenakalati Jope nali hoka kahare haliti Xekohaseti Jesus koamaniya tyaonaha, tyakekoaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Hatyaoseta Pedro nali waha ferakene tyaona militi xaxotyatyasehare Simão nexarexe hanako. ");
INSERT INTO pabNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Hatyo xowaka wenakalati Cesaréia nali tyaonita Cornélio nexarexe, sorarenae xekohasehare. “Itália tarenae”, nexahitaha hatyo sorarenae xaokaka. ");
INSERT INTO pabNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Waiyexehare tyaonita, waiye aiminijita Enore, tyotya haisaninae haiyanityo kakoita Enore koamaniya tyaonita. Kahinaetita kahare judeunae maoloxaharenae, Enore hiye iraexata minita. ");
INSERT INTO pabNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Haxowaka makakoahena hoka Cornélio kaxawaiyanikisaka. Hatya anjo Enore nalitare tyoa kaoka enomana. Waiye waiyene. Kaoka ehaliya hoka: — Cornélio! nexa ihiye ");
INSERT INTO pabNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hamairane kakoa waiye wahakotya anjo ana hoka axehenene: — Xoare haoka, xekohaseti? Hoka anjo nehena: — Enore awaitita hiraexaitere, exahe maoloxahare waiye hiyomokala hoka otya hiso. ");
INSERT INTO pabNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kalikini haxikahena haiyanae haliti wenakalati Jope xeta hoka nolokaha maheta Simão Pedro nexarexe. ");
INSERT INTO pabNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tyaonita Simão hanako, militi xaxotyatyasehare hanako one kaloxere kilihi maniya — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hatyaoseta anjo xaneheta hoka Cornélio kawisa rotita hinama hawakanehare hatya sorare xoaha. Hatyo sorare Enore koamaniya tehitiya tyaonita, Cornélio ana hakita. ");
INSERT INTO pabNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hatyaoseta Cornélio xakai ihiyeha hawaiyane xaka hoka axikatyahene Jope nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kamaetali hoka totahikoahena hoka Pedro kakoha, xane hati maiyeho iraexatya maheta. Hatyo nase Cornélio wakaneharenae xanehitaha ahoti, owitehena Jope mokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hatyaoseta Pedro nakehena, kasani kanakaira aokowita. Hoka tyomahitere nakairati nase kaxawaiyanikisaka. ");
INSERT INTO pabNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Waiyehena atyo Pedro, enokoa totako tyaona hoka imititaose kalohero olatyoare xalakakoa maniya tonone akerehare exoa waikoa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hatyo nakoako tyotya hotyalihare kirakaharenae tyaonita, xalakakoa kijiye hotyalinae, waikoa nolokoitereharenae, kotehalanae hare. ");
INSERT INTO pabNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hatyaoseta Pedro semehena atyo, iraitihena atyo: — Pedro, nikahena hoka haisa hoka hanisa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","— Maisaiya, Xekohaseti. Maisa xoana xowaka nanihenere xoalini hare kaiyalaharexe manikakahare — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xakore hoka nehitiya iraiti: — Awa atyo kaiyalahare manikakahare haoka Enore koxaka waiyexe kanikakere mohenere. ");
INSERT INTO pabNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hanamaki nikare tyaona hoka hatyaoseta hatyo imititaose akerehare kakolatyakeheta enokoa xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro amaikohare hatyo waiyehenere akiti kakoa: — Xoare akiti kala nikareta aotyakisa aokowita natyo? nexa. Pedro nikare ahekotitere nase Cornélio xaxikalanae tyoa kaokaha. Koxaka axaha hatyo nali tyaoniterenae hoka aotyakisahene hoka tyoa amematyoaha Simão hana kanase. ");
INSERT INTO pabNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kawisaha hatya hatyakota hoka axaha: — Xoana ali Simão Pedro nexarexe tyaonita? nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro heko otyaxematitata hawaiyane tahi akiti hoka Isekohaliti Waiyexe nexa ihiye: — Hasemehena, owene hanama hare haliti tawita hiso. ");
INSERT INTO pabNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hexoaheta hoka haxakaiharetyoahena hoka hiyane exemaha. Hiyane exemaha, awa atyo himawaiyehare hiyanene kakoa. Natyo atyo natyoanikisahene ali. ");
INSERT INTO pabNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hatyaoseta Pedro exoaheta hoka nexa ihiyeha: — Natyo atyo xatawitere. Xoana hoka ali xisoa? nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hoka nexaha ihiye: — Xekohaseti Cornélio axikatya wiso. Waiyexehare hatyo haliti. Awaitita Enore, exahe judeunae hoka tyotyaha tyakekoahitene. Hatya Enore nalitare anjo irai ekakoa, aoka hikakawisaka ehana nali xeta, sema maheta hiraine — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hatyaoseta Pedro aisoakisahene hatyako, hatyo xatini nemakaha Simão hanako. Kamaetali hoka Pedro xakaiharetyoa, xane exemaha. Haiyanae iraiti tyakekoterenae ihinaeharenae Jope nali tyaoniterenae tehitiya xaneha exemaha. ");
INSERT INTO pabNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kamaetali hoka xane kaokaha wenakalati Cesaréia nali. Cornélio koxaka kaexakatya hahinaeharenae kaiserehare hoka atyahahitaha Pedro xahita. ");
INSERT INTO pabNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Xane kaokehena Pedro hoka Cornélio tyoa ahalakoatene, enahalakoa meholokoa hakaoliri kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Xakore hoka Pedro atyo ainakihetene hoka nexa ihiye: — Hatityoahetehena, hiso akerexeta tehitiya haliti natyo — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iraikakoaha Cornélio kakoa hoka hatyaoseta xane isoa hatyako. Owene atyo kahare haliti koxaka hohisakoita nali. ");
INSERT INTO pabNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Hatyaoseta Pedro nexa tyotyaha ihiyeha: — Waiyekehalakita atyo xomana judeunae nawenanaho mahokoanititere majudeuneharenae waiyaka exahe xahohisakoatyaka ekakoaha. Xakore hoka Enore atyo hotikisa nomani hoka maisaiya atyo xala hare mahekorenehare naokita. ");
INSERT INTO pabNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hiyeta hoka xakawisa natyo hoka nihalahalini kakoa notyoa ali xeta. Xiyakaihena nohiye: xoana hoka xakawisa natyo? ");
INSERT INTO pabNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Hoka Cornélio nehena: — Ali hanamaki ferakene nahitita niraexaita makakoasehena nohanyako. Hoka eharehena rotita hatya haliti iyomere nimere kaotyaka nomani ");
INSERT INTO pabNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","hoka nexa nohiye: “Cornélio, Enore semita hiraexala. Otita hiso hakahinaetitere maoloxaharenae hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Haxikatya hatya Jope nali xeta hoka hatya haliti Simão Pedro nexarexe noloka maheta. Militi xaxotyatyasehare Simão hanako tyaonita, one kaloxere kilihi maniya”, nexa nohiye. ");
INSERT INTO pabNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hoka nakawisa rotita hiso. Ehekoreta hisoa. Kalikini wisaonita ali, wihohisakoita Enore haoti, wasema waokowi hiraene, xoare nexa xamani Enore airaekihena hiso hoka — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Hatyaoseta Pedro nehena: — Kalikini atyo waiyekehalakehena nomani. Enore ana atyo tyotya haliti hakakoita. ");
INSERT INTO pabNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Awaiyetita exema maniya tyaoniterenae, waiye tyaoniterenae, exahe hahotyalihare hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xiso atyo koxaka xasema Enore niraine Israel hotyalinae anere Iraiti Waiyexe, wenati waiyexe Jesus Cristo hiyeta. Hatyo atyo tyotya halitinae Xekohase. ");
INSERT INTO pabNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Koxaka xasemita kawenatyakehenere tahi akiti, Judéia koa hakakoare kasemaka. Galiléia koa hotohare nikare tyaona, João xakaihenere batixahenere najikinita. ");
INSERT INTO pabNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","— Xasemita tehitiya Jesus Nazaré yere tahi akiti. Enore isa Isekohahaliti Waiyexe enomana hoka aiyatelikisa halitinai. Tonakoatya, hakakoare xane, waiyexe tyomita, aiyatelikihitita tyotya tihanare xahokakalanae, Enore atyo kaxaikotene hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wiso atyo tyotya xoalini harenae enómane wiyaiya judeunae waikoherakoa nali, exahe Jerusalém nali. Xakore hoka atyalihose xaimaholatyaka hiye berekotyahene hoka aisahene. ");
INSERT INTO pabNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Xakore hoka Enore ekasekihetene hanamaki ferakene najikinita hoka hotikihetene tehitiya womana. ");
INSERT INTO pabNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Maisa atyo hakakoare haliti waiyehititene hoka wiso atyo wiyaiyehetene. Wiso atyo ewaiyasehare Enore xaokalita. Wiyaiyehetene hoka wikanakairiheta, wisereheta ekakoa ekaseneheta najikinita. ");
INSERT INTO pabNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Enore atyo axikatya wiso wiyakai maheta halitinai hiye Iraiti Waiyexe. Enore mokene kalorexe, kasexenae ekamanenae xekohase, sema enawenaneha tahi akiti hoka enómanenai akereta mokahene maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tyotya iraiti xakaisaseharenae Jesus tahi akiti xakai hoka nexaha: Xalanae xamani atyo tyakekone hoka iniyalahare enómaneha kamaotyanetyakeheta ihiyeta — nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro iraetata hoka Isekohahaliti Waiyexe exoa hoka kaxaihakoretya tyotya semaxemaiterenae iraiti. ");
INSERT INTO pabNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Judeunae Jesus koamaniya tyaoniterenae Jope nalita tyoiterenae Pedro xema hakaharetyoaha. Enore exaoretya Isekohaliti Waiyexe majudeuneharenae ana hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Semehenaha atyo, iraihenaha atyo xakotinae masemakahare. Ihalahare tyaonaha Enore kakoa. Hatyaoseta Pedro nehena: ");
INSERT INTO pabNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","— Exe halitinae ana Isekohahaliti Waiyexe kaoka tehitiya kaokitere womana akereta. Nikare hoka xalaiya mahokoanehena ebatixatyakaha one kakoa? ");
INSERT INTO pabNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hatyaoseta aoka ebatixatyakaha Xekohaseti Jesus nexare kakoa. Hatyo najikinita akaiki ferakene Pedro nawenane aokaha nali hahaliyaha. ");
INSERT INTO pabNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Hatyaoseta Jesus niraine kakoarenai, exahe haiyanae Jesus xema maniya tyaoniterenae semaha Judéia koa nali majudeuneharenae nawenane Enore niraine xema maniya. ");
INSERT INTO pabNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro haikoaheta Jerusalém nali hoka haiyanae kinatyaxa irae ekakoa, kasani haomanere milihi aikotiterenae taita tyaona Enore koamaniya aokahitaha ");
INSERT INTO pabNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","hoka nexaha: — Hisemaka maxaikolahare haomanere milihinae hanako, hikanakaira harenae ekakoaha. Xoana hoka? ");
INSERT INTO pabNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hatyaoseta Pedro xakaihakatya tyotya hawaiyane tahi akiti, hetatiye aoseta, waiye awaiyekehalakatene enomanaha. ");
INSERT INTO pabNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","— Notyaonita wenakalati Jope nali hoka nokaxawaiyanikisaki. Nowaiyehena atyo, motya imiti taose kalohero enokoata tyoa ewaikoatyoa. Olatyoare etonone xalakakoa maniya tyoa amematyoa nohaliye. ");
INSERT INTO pabNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Waiye atyo nowaiyehena, owene atyo kirakaharenae tyaonita enako, xalakakoa kijiye, xalijiniharexenae, waikoa nolokoiterehare, kotehalanae hare. ");
INSERT INTO pabNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hatyota nasemehena atyo, iraiti nexa: “Pedro, haisehena hoka hanisa”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Hoka nomi: “Maisaiya, Xekohaseti, maisa xoana xowaka nanisare kaiyalaharexe manikakahare”. ");
INSERT INTO pabNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Hatyaoseta enokoata iraiti nehitiya: “Awa atyo kaiyalahare manikakahare hexa Enore koxaka waiyexe kanikakere mohenere xaokaka”. ");
INSERT INTO pabNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nikare hanamaki tyaona hoka hatyaoseta tyotya haikoaheta enokoa xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","— Hatyonase hanamahare haliti kaxaxikatyakitere nomani Cesaréia nalitarenae tyoa kaokaha hati notyaonitere nali. ");
INSERT INTO pabNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Isekohaliti Waiyexe noxanini exemaha aoka nohiye. “Awa atyo himawaiyehare exemaha hiyanene kakoa”, nexa nohiye. Exe 6-harenae wihinaeharenae Jope nalitarenae tehitiya tyoaha noximi. Wityotya wiyane wisoa Cornélio hanako. ");
INSERT INTO pabNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Hatyaoseta Cornélio xakai wihiye hahanako waiyehenere anjo. Tityoa enahalakoa hoka nexa ihiye: “Haxikatya hatya Jope xeta hoka xane noloka Simão Pedro nexarexe. ");
INSERT INTO pabNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hatyo atyoite iraihena hoka Enore koamaniya kaiserehare xikaxomokakehena hexanityo, hityaninai harenai kakoa”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","— Hatyaoseta niraehena hoka Isekohaliti Waiyexe tyoa exoa enomanaha, hetatiye exoitere womana akereta. ");
INSERT INTO pabNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hatyaoseta noteheta Xekohaseti Jesus niraine: “Aliterexe atyo João batixaita one kakoa hoka xiso atyoite Isekohaliti Waiyexe kakoa xikabatixatyaka”. ");
INSERT INTO pabNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","— Hiyaiya, wityakeko Xekohaseti Jesus Cristo hoka hatyo hiyeta Enore isa Isekohaliti Waiyexe womana. Majudeuneharenae ana tehitiya kaxekaka kaxekakehenere womana akereta. Enore xaokalita hoka xalaiya natyo hoka Enore kakoa nokahalakoiharehena? nexa Pedro ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Semaha iniraine hoka halakisaha hairaehekoalaha. Ihalahare Enore kakoa hoka nexaha: — Ehekoreta Enore nikare moka majudeuneharenae hoka halakisaha tehitiya háomaneha iniyalahare hoka waiyexe matyotenehare tyaonaha maheta — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Jesus koamaniya tyaoniterenae xaoreha hairawaiyakaha hiyeta, Estêvão kaxaisakehenere najikinita. Haiyanae xane Fenícia, Chipre, Antioquia xoaha nali xeta. Xane kaokaha hoka xakaihaha Iraiti Waiyexe judeunae hiye taita. ");
INSERT INTO pabNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Xakore hoka haiyanae Chipre tarenae, Cirene nali tarenae xoaha xaneha Antioquia nali xeta hoka xakaihaha Iraiti Waiyexe Jesus tahi akiti majudeuneharenae hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Enore niyatere kakoareha hoka kahare haliti tyakeko iraiti hoka tyaonaha Xekohaseti xema maniya. ");
INSERT INTO pabNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Hatyo tahi akiti enexakaha semaha Jerusalém nali tyaoniterenae tyakekohatiyenae hoka axikatyaha Barnabé Antioquia xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Xane kaokehena, waiyehena atyo, koxaka atyo Enore waiye mokahitene hoka ihalahare tyaona ekakoaha, hoka aotyakisahene Xekohaseti koamaniya takita heko kinatere, haihalahareneha kakoa tyaonaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabé atyo haliti waiyexe, Isekohaliti Waiyexe tyaonita ekakoa, tyakekohatiye harenae. Kahare haliti semaha iniraine hoka tyakekoha hoka Enore koamaniya tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hatyo najikinita Barnabé xane wenakalati Tarso nali noloheta maheta Saulo. ");
INSERT INTO pabNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Xane kaoka enomana hoka nolohetene Antioquia xeta. Nali tyaonaha hoka hohisakoaha tyakekoterenae kakoa. Haterehokoane tyaonaha ekakoaha hoka aotyakisahene. Kahare haliti aotyakisaha, heko miyatyaha hatyo terehokoane. Antioquia nali hotohare Cristo koa maniya tyaoniterenae kakaixaretyaka. ");
INSERT INTO pabNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Hatyo xowakiya haiyanae iraiti xakaisaseharenae Jerusalém nalita Antioquia nali xeta xaneha. ");
INSERT INTO pabNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hatya enekonihatareha Ágabo nexarexe. Tityoa hoka Isekohaliti Waiyexe niyatere hiyeta nehena: — Maikaite kalore nakiti tyaona tyotya hakakoare waikohekoa — nexa. Cláudio kalorexe tyaonitere xowakiya nikare nakiti tyaona. ");
INSERT INTO pabNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hatyaoseta Xekohaseti koamaniya tyaoniterenae kahinaetyaha aokowiha hahinaeharenaiha Judéia koa tyaoniterenae hoka haihatyakaha isaha olo. Haiyanae kaoloxerenae hoka kalore isaha, haiyanae maoloxaharenae hoka inira isaha. ");
INSERT INTO pabNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hoka axikatyaha olo haxekaneha Barnabé, Saulo xoaha xema, tyakekoterenae nityohalitiranae ana Jerusalém nali kaxekaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hatyo xowaka terehokoane kalorexe Herodes xalijinihare tyaona haiyanae Iraiti tyakekoterenae xahita. ");
INSERT INTO pabNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wakatya sorarenae hoka xane aisaha João naxenane Tiago kesekase kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Waiye kaokene judeunae nityohalitiranae ana hoka Herodes wakahitiya sorare hoka olahitiya Pedro. Hisehaliti nakairati makaolatyakahare nomakere xowaka nikare tyaona. ");
INSERT INTO pabNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Olatyahene hoka berexoako mokene Herodes xaokalita. Xalakakoa hotyali sorare ekaxaikotyasenai tyaona aoka, xalakakoahare makereha. Hisehaliti najikinita Herodes aihikoatene aokowita judeunae ana. ");
INSERT INTO pabNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nikare Pedro berexoako tyaonita hoka sorarenae waiye kaxaikoitene. Xakore atyo hoka iraiti tyakekoterenae kahare iraexatyahitaha enomana. ");
INSERT INTO pabNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Makiya, Herodes xaihikoarene hoka hotikisene halitinae ana aokowitere nahitita Pedro nemakita hinamahare sorarenae xikako, hinama maniya olatyoare kamatiherahi kakoa berexo ako tyaonita. Berexotyakalati hana jihola kanase sorarenae tehitiya kaxaikota. ");
INSERT INTO pabNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Hatyaoseta ehárehena rota anjo kaotyaka Enore nalitare, werokehekoa moka hatyo akiti. Totoka Pedro kanoli hiye, kaosetene hoka nexa: — Hihalahare hainakoahetehena — nexa. Hatyaoseta exola kamatiherahi itoaheta ewaotyalinai hiyeta. ");
INSERT INTO pabNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","— Haiyatyahetehena hijiterone hihiye, hikijitini holahetehena — nexa ihiye anjo hoka Pedro anjo iraitere akereta tyaona. — Himanase ako hisoahetehena hoka hisohena noximi — nexa anjo Pedro hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Hatyaoseta Pedro hikoaheta berexo akota, xane anjo xema. Xakore hoka komita ene maisa waiyekehalakita enomana anjo niyanehetene, motya kaijihinita aokita. ");
INSERT INTO pabNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hetatiye jiyehenahitaha, hatyotare sorare kaxaikotere aose jiyehenahitiyaha hoka xane hikoahenahitaha kamatihera jihorere wenakalati xisoakala nali. Jihore kalorexe kamatihera xakore hoka majiholatyoata hawawa hoka hikoahenahitaha. Hatyaoseta jiyaha ahotyaho. Hatyaoseta anjo xaneheta, nali halakiheta Pedro. ");
INSERT INTO pabNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hatyaoseta Pedro otyakaheta hoka nehena hawawaharenae: — Kaxiyani, aliterexe Enore axikatya anjo iyeheta maheta natyo Herodes nonitata, exahe judeunae nonitata hoka. Ikoiya awa hoka xoana xamaniya mokaha natyo. ");
INSERT INTO pabNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pedro ana waiyekehalakehenere najikinita xane Maria hanako, João Marcos nityo hanako. Kahare haliti nali tyaonita. Hohisakoahitaha hoka iraexaitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro xane hikoa hati ana hoka mokotya hati jihola hiye hoka wakahalo Rode nexalolo xane waiya exahita, xala xamani hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Semehena atyo, Pedro xako sema hoka ihalahalo. Maisa majiholatita hekoti hoka tema haikoaheta, “Pedro owene menanaka”, nexa maheta ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hatyaoseta nexaha ihiye: — Awa hihatyahalo! Xakore hoka aiyatolotyoa: — Aliterexe naokita. — Kala ekaxaikotyase anjo — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hatyo nase Pedro mokoita hati jihola hiye. Ekakoita xane majiholatyaha hati jihola, waiyehenaha atyo, Pedro terota atyo hoka hakaharetyoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Hatyaoseta Pedro aimenekotya enomanaha hakahe kakoa, mema tyaonaha maheta. Mema tyaonaha hoka xakai ihiyeha Enore niyanehetene berexo akota. — Maika xiyakai hatyo tahi Tiago hiye, exahe haiyanae iraiti tyakekoterenae hiye — nexa. Hatyohekota xanehitiya hakoa xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ferakoa hoka sorarenae waiyaosetya Pedro hoka maira, tatakoaha, maisa waiyekehalakita nikare Pedro tyaohenere akiti enomanaha hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hatyaoseta Herodes axikatya haliti hoka tawehetahene. Xakore hoka maisa kaokehenahititene. Hatyaoseta Herodes, axalihenere ekaxaikotyasenae sorarenae najikinita, haiyanae wakatya aisaha maheta hatyo sorarenae. Hatyo najikinita Herodes xaneheta Judéia koa nalita, xane tyaona wenakalati Cesaréia nali. ");
INSERT INTO pabNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hatyaoseta xekohaseti Herodes ehare wenakalati Tiro, Sidom tyaoniterenae hiye. Hoka kahare xaneha waiyahene maheta. Xane iraeha hotohare Herodes hana kaxaikotyasehare Blasto nexare kakoa, kasani kahinaetyahene aokahita. Hatyaoseta xane iraeha Herodes kakoa maisa iniyalahare mokahitene maheta, Herodes waikoherakoata taita nakairati ewaikoheraha nali kaokita hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hatyaoseta Herodes aimenekotya enomanaha hoka hatyo ferakenehena isoa haimako xekohaseti nimako, tyoka haokahakala koa hoka waha irae ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Hoka hatyo halitinae kawiyatyaha: — Maisa atyo haliti xini iraeta, enore atyo iraeta — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hatyo xowakita Enore nalitare anjo ahokakatya Herodes, maisa aiminijita Enore hoka. Ahokakatene hoka xoxohi tyaona ihiye, nisene hoka waini. ");
INSERT INTO pabNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hatyo najikinita Enore niraine tahi xaorekoa, exahe kaxakaisaka hakakoare. ");
INSERT INTO pabNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabé, Saulo xoaha miyatyaha hahateneha Jerusalém nali hoka haikoahenahitaha Antioquia nali. Nolokaha João Marcos. ");
INSERT INTO pabNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquia nali iraiti tyakekoterenae koni iraiti xakaisaseharenae, xaotyakisatiyenae tyaonita: Barnabé, Simão Negro nexarexe, Lúcio, Manaém, Saulo xoaha. Lúcio atyo Cirene nalitare. Manaém atyo xekohaseti Herodes kakoa haxawalita kaxanaityakaha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Haxowaka iraexatyahitaha Enore hiye manakairahareta hoka hatyaoseta Isekohaliti Waiyexe nexa ihiyeha: — Haware xamoka nomani Barnabé, Saulo xoaha hoka hakaha hateniti. Hatyo niyahare naokahene nomani. ");
INSERT INTO pabNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hatyaoseta manakairahareta iraexahenahitiyaha, mokaha hakaheha Barnabé, Saulo xoaha seri heno Enore hatene waiye hakaha maheta hoka jinakahene hoka xaneha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hatyaoseta, Isekohaliti Waiyexe axikatya Barnabé, Saulo xoaha hoka xaneha wenakalati Selêucia nali. Hatyo nalita kanowa kalorexe ako xaneha iyolirotikoa Chipre nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Xane kaokaha wenakalati Salamina nali hoka xakaihenaha Enore niraine naliyerenae hiye judeunae xahohisakoatyakala hanako. João Marcos kahinaetyahitene iraiti exakainiha hiye. ");
INSERT INTO pabNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hatyaoseta jiyaha katalatyaha hatyo iyolirotikoa hoka xane kaokaha wenakalati Pafos nali. Hatyo wenakalati nali ahalakoatyaha hatya judeu Barjesus nexarexe. Haholitaharexe atyo, iraiti xakaisasehare aokowita xakore hoka maoseraita. ");
INSERT INTO pabNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesus atyo kalorexe Sérgio Paulo hinaehare. Hatyo Sérgio Paulo atyo Chipre nali xekohaseti tyaonita. Waiyore, irihare ahekotita. Hatyaoseta hatyo xekohaseti kawisa Barnabé, Saulo xoaha, sema aokowita Enore niraine hoka. ");
INSERT INTO pabNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hoka hatyo haholitaharexe Elimas kahalakoahare Jesus niraine kakoarenai kakoa. Elimas atyo enexare grego xako. Maisa xekohaseti tyakeko Jesus tahi akiti aokare hoka kahalakoahare ekakoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Hatyaoseta Saulo iraihena. Paulo tehitiya atyo masakare kaexaretyahitene. Isekohaliti Waiyexe masakare kaxaehakoretene hoka kinatya wahakotya Elimas ana hoka nexa: ");
INSERT INTO pabNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","— Tihanare ityani, tyotya waiyexe nahalakoahare, haliti ewaxirahare, maoseratyaliye! Xoana hoka maisa hahalakisare iniyalahare hománe hoka Enore xaotyakiraho waiyexe kakoa kaxaotyakisaka haokare? ");
INSERT INTO pabNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kalinite iniyalahare mohena hiso hoka himaxosehare hisaohena wahakiya, maisaiya hiyaiyehitita kamai xaokanala — nexa. Nexa taita hoka Elimas haoti makehekoa tyaona, hoka hakakoahena hatya xahita, ekahe hiye otokene hoka otokahisene maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Xekohaseti Sérgio waiya hatyo nikare hoka tyakeko, hakaharetyoa exaotyakira Enore tahi akiti kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Hatyaoseta Paulo hahinaeharenae kakoa xane isoaha kanowa kalorexe ako, xanehenahitaha Pafos nalita. Xane wenakalati Perge nali xeta Panfília koa. Xane kaokaha hoka hatyo nalita João Marcos halakisahene hoka haikoaheta Jerusalém xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Hatyaoseta xanehenahitiyaha Perge nalita hoka xane kaokaha wenakalati Antioquia nali Pisídia koa. Sábado xowaka xane judeunae xahohisakoatyakala hanako isoaha hoka tyokaha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hatyoako tyaoniterenae Moisés xairala, iraiti xakaisaseharenae baberaxa xoaha kaixaretyaha hotohare hoka hatyo najikinita hatyo xahohisakoatyakala hana xekohaseharenae kawisahene: — Nohinaeharenai, xoare xamani xirai xaokowita hoka witya xiraihena kalikini hoka xaihalahalinikisa wiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hatyaoseta Paulo tityoa hoka hakahe kakoa aimenekotya enomanaha hoka mema tyaonaha maheta. Hoka nehena: — Israel hotyalinae, exahe xiso haiyanae majudeuneharenae ali Enore awaititerenae hoka xasemehena. ");
INSERT INTO pabNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Toahiya Israel nEnorexa wahetakomaniyerenae haomanere aoka. Egito nali tyaonahitere xowaka hisoaka mokahene. Nalita iyehenahitene haiyatere kakoa. ");
INSERT INTO pabNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hatyo halitinae tyaonaha maharexakiti 40-terehokoane. Maisa Enore xakore aokitere akereta tyaonareha hoka maisa emaxahalikisahitene. ");
INSERT INTO pabNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Hatyaoseta xane kaokaha Canaã waikohera. Enore mawenekoaretya 7-hotyali haliti hatyo nali hoka Israel hotyalinae waikohe waikatehare tyaonaha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Hatyaoseta 450-terehokoane tyaonaha hatyo waikohekoa. — Hatyo nase ekaxaikotyasenaiha, ewatyalisasenaeha aotyakisahitene, heko Samuel tyaonitere kijiya. ");
INSERT INTO pabNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hatyaoseta axaha xekohaseti haomana hoka Enore moka Saul enomanaha exekohaseha maheta. Saul atyo Quis ityani, Benjamim hotyalihare. 40 terehokoane exekohaseha tyaona. ");
INSERT INTO pabNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Hatyaoseta Saul emaisaheta hoka Davi moka exekohaseha maheta. Nexa Davi xaokaka: “Jessé ityani Davi atyo waiyeta nomani, nawaiyeta xoaha enomana. Naokitere akeretaite tyomehena”, nexa. ");
INSERT INTO pabNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","— Hatyaoseta wahehena hoka hatya Davi jikolahare tyaona, Jesus. Enore mokene Israel hotyalinae niyaseheta maheta, ekoamaniya tyaonaha maheta iraihenere akereta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesus tyoanene nahetakota João Batista xakaita iraiti Israel hotyalinai hiye halakisaha iniyalahare háomaneha, exahe hoka kabatixatyaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","João haxakaini okoi halakihena hoka nexa halitinae hiye: “Xala xaokita natyo? Maisa atyo xatyahitere xini natyo. Najikinita atyoite tyohena. Hatyo atyo noxahehare hoka maisaiya natyonae aliyakere ikijitini nanohi hekoti naolikita”. ");
INSERT INTO pabNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","— Xasemehena, nohinaeharenae Abraão mokoseharenae, exahe xiso majudeuneharenae awaititerenae Enore. Xasemehena, exe iraiti wityotya womanere maheta kaxaxikatyaka waiyexe maniya moka maheta wiso. ");
INSERT INTO pabNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Aliterexe Jerusalém nali tyaoniterenae, exahe exekohasenaiha hoka maisa waiyekehalakita Jesus enomanaha, motya maisa haliti niyasehareheta xini aokahita. Exahe tehitiya hoka maisa iraiti xakaisaseharenae niraine waiyekehalakita enomanaha, sábado nihatyaka xakore kakaixaretyakita enomanaha hoka. Maisa waiyekehalakere enomanaha hoka Jesus xaisaka aokaha. Koxakereharenai xaokalaoseta mokahene. ");
INSERT INTO pabNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maisa xakore xoare xemere hoka aisahene aokowiyahita hoka Pilatos hiye exaisaka aokaha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Hatyaoseta Iraiti Waiyexe nanekoa kaxairatyakehenere etahi akereta mokahene. Hatyo najikinita atyalihose xaimaholatyaka hiyeta iyehenahitene hoka kolatyahene, xane mokahene xawatyakalati nitini ako. ");
INSERT INTO pabNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Xakore hoka Enore ekasekihetene. ");
INSERT INTO pabNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kahaliki kaotyakeheta hahinaenae ana, Galiléia ta xanehena Jerusalém xeta hoka exema xanehenerenae ana. Kalikini atyo hatyonae Jesus waiyasehare tyaona Israel hotyalinae koni hoka Jesus tahi iraetaha ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","— Kalikini wisoa ali Iraiti Waiyexe wiyakai xihiye maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Enore tyoma womana wahetakomaniyerenae kakoa iraitere akereta. Hatyo atyo ekasekiheta Jesus. Hiyaiya, exakerexe kaxairatyaka Salmo nanekoa 2 hiye: Nityani hiso hoka Hexe notyaona kalikini. ");
INSERT INTO pabNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","— Exakere Enore Jesus ekasekihetehenere tahi akiti irae, exahe eháre matokomenene akiti hoka: Davi kakoa niraihenere akeretaite waiyexe maniya hikaxomokaka. ");
INSERT INTO pabNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","— Nexa tehitiya, hakiti Iraiti Waiyexe nanekoa wakaexaretya: Maisaite hiwakanehare waiyexe háre hahalakisa hoka tokomita. ");
INSERT INTO pabNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Paulo nehitiya: — Aliterexe atyo Davi Enore aokitere akereta tyoma kasetatere xowaka. Hatyo najikinita waini hoka kaxafityaka hahetakomaniyerenai xawatyakala hijiyita hoka tokoma atyo eháre. ");
INSERT INTO pabNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Hoka Enore ekasekihetehenere atyo maisa tokomita hakamane xowaka. ");
INSERT INTO pabNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","— Nohinaeharenae, waiyira xasema iraiti aliterexe Jesus hiyeta kaxakaisaka, iniyalahare kahalakisaka hoka kamaotyanetyakeheta maheta. Hatyo akiti kaxakaisaka xihiye. ");
INSERT INTO pabNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Xasema tehitiya: xala xamani tyakeko hoka enómane iniyalahare kamaotyanetyakeheta. Hoka Moisés xaotyakira atyo maisa emaisahetere iniyalahare wenati. ");
INSERT INTO pabNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","— Hiyeta hoka xirihare waiya aliya hoka koxakereharenae niraine aosetaiyatya xisaona: ");
INSERT INTO pabNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Xiyaiyehena, xiso koexahalijiterenae. Ximairaite, exahe ximaiyare. Hiyaiya, kalikinite notyomehena hatya xoalini hare xakoreya hoka hatyaiya xakaini xihiye hoka maisa xityakekota. ");
INSERT INTO pabNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo, Barnabé xoaha hikoahetehena hohisakoahitere hekota hoka hatyo halitinae hatyotare sábadone tyohenahitiyaha hoka hatyo xakita xakaihitiyaha ihiyeha aokaha. ");
INSERT INTO pabNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hohisakoahitere najikinita kahare judeunae, exahe judeu xaotyakiraho xema tyaohenerenae tyakekoha Paulo, Barnabé xoaha xaotyakira. Hatyo Jesus niraine kakoarenai iraeha ekakoaha aihalahalinikisahene hoka Enore xawaiyera xema heko tyaonaha maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Haxowaka sábadone hitiya hoka komita ene wenakalati tyaoniterenae tyotya hohisakoaha semaha maheta Enore niraine. ");
INSERT INTO pabNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Hoka judeunae waiyaha hatyo hisoakere halitinae hoka okoawahareha. Ehareha hoka hatyaoseta Paulo niraene kakoa kahalakoahareha hoka kirawanahene. ");
INSERT INTO pabNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Xakore hoka Paulo, Barnabé xoaha aiyateretyoaha hairaineha kakoa: — Xiso judeunae ana hotohare atyo kaxakaisaka Enore niraine maheta. Hoka maisa xasemaxematya, maisa xaokarene xomana, maisa wenati matyotenehare xaokare xomana hoka wahalakisaite xiso hoka wiyane majudeuneharenae hiye wiyakai Iraiti Waiyexe. ");
INSERT INTO pabNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Exakerexe Enore aoka wihiye iraiti xakaisasehare xaihako maniyata: Xaokanatyakalati akere namoka hiso halitinae ana hoka hihiyeta hakakoare haliti waiyexe maniya kaxomokakeheta maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Majudeuneharenae semaha hatyo iraiti hoka ihalahareha, waiye enomanaha Xekohaseti tahi akiti. Waiye enomanaha hoka tyakekoha Enore niraine menanehaliti aohenerenai Enore. ");
INSERT INTO pabNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Enore niraine xaorekoa hakakoare hatyo nali. ");
INSERT INTO pabNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Xakore hoka judeunae matyakekotiterenai ehareha hoka xane iraeha wenakalati waikateharenai hiye, exahe majudeunehalonae xekohasetironae Enore tyakekoterenae hiye. Hatyohekota xalijinihare tyaonaha Paulo, Barnabé xoaha xahita hoka hatyo nalita axikahenahitene. ");
INSERT INTO pabNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hoka Jesus niraine kakoarenai mokotyahatyaha hakijitininaiha waikohe exoakihenahitaha, maisa waiyetere iniraeneha aimenekotyaha maheta. Hatyaoseta Paulo, Barnabé xoaha xaneha wenakalati Icônio nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Xakore hoka Jesus xema maniya tyaoniterenae atyo ihalahare tyaonahitaha, Isekohaliti Waiyexe kaxaihakoretyahitene xoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Icônio nali hoka nikareta tyaohenahitiyaha. Paulo, Barnabé xoaha xane isoaha judeunae xahohisakoatyakala hanako iraehenahitiyaha irae ahitere akereta, hoka kahare judeunae, majudeuneharenae hare tyakekoha iniraineha hoka tyaonaha Jesus xema maniya. ");
INSERT INTO pabNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Xakore hoka judeunae matyakekoneharenae aisatanakotya majudeuneharenae hoka Jesus xema maniya tyaoniterenae kirawaneha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jesus niraine kakoarenai waha tyaonaha Icônio nali, aiyateretyoahitaha haxakainiha Xekohaseti tahi akiti kakoa. Enore hotikijita hawaiyexehare aliterexe tahi exakaihakalaha hiyeta. Iyateliti ijita Jesus niraine kakoarenai ana hoka waiyexe maomakahare tyomahitaha iniraine katyakekotyaka maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Hoka halitinae wenakalati tyaoniterenae hahekore xakini ahekotyaha. Haiyanae judeunae xema tyaonita, haiyanae Jesus niraine kakoarenai koamaniya tyaonita xoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Hatyaoseta majudeuneharenae, judeunae xoaha ahekotyaha hanityohalitiranae kakoa hoka xalijiniharehenahitaha Jesus niraine kakoarenai hiye. Maisa waiye mohenahititahene, sehali kakoa mokotyahene aokowiha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hoka Paulo, Barnabé xoaha semaha hatahiha akiti hoka tekoahenahitaha Listra, Derbe xoaha nali xeta Licaônia koa, exahe hatyonai haliyita wenakalati tyaoniterenae nali. ");
INSERT INTO pabNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hatyo nali xane kaokaha hoka xakaihenahitiyaha Iraiti Waiyexe tahi. ");
INSERT INTO pabNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Hatyo Listra nali hatya haliti tyaonita, maisa waiyehaliti xini. Tyokita takita, maetonanehare hoka. Nikarexe terota tyaona tyaohenere hekota, maisa tonareta hekoti. ");
INSERT INTO pabNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hatyo maitonanehare Paulo niraine semita hoka tyakekota. Paulo waiyene hoka kaxaiyatelikisakehetere hoka hatyaoseta wahakotya enomana hoka nexa kinatyaxa: ");
INSERT INTO pabNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","— Hainakoa! Hatityoahetehena! Nexa hoka hatyo haliti halaisoa, tityoaheta hoka toheta. ");
INSERT INTO pabNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Waiya halitinae, Paulo nikare tyomehenere hoka kawisaha haxakoha: — Enorenae kaoka womana halitinae akerehare! ");
INSERT INTO pabNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","“Júpiter”, nexaha kaixaretyaha Barnabé, “Mercúrio”, nexaha kaixaretyaha tehitiya Paulo. Paulo atyo iraiti xakaita ihiyeha hoka nikare kaexaretyahene. ");
INSERT INTO pabNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Júpiter anere iraexatyakalati hana wenakalati nahalakoita tyaonita. Hiyeta hoka sacerdote Júpiter anere xane kolatita bowi, exahe seriti hoko iyiti kakoare hoka mokita wenakalati xisoakala nali. Hatyo halitinae aisa kirakahare aokowiyahitaha fetatyaha Paulo, Barnabé ana xoaha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hatyo hinama Jesus niraine kakoarenae semaha hatyo tahi hoka halalakaha haimaha haxamaikohareneha hoka tema xaneha halitinae koni hoka kawiyatyaha enomanaha: ");
INSERT INTO pabNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","— Xoana hoka nikare xisaona? Xiso akerexeta haliti tehitiya wiso — nexaha. — Ali wisaonita wiyakaihakatya Waiyexe Iraiti maheta xihiye hoka xahalakisa maheta exehare nikareterenae hoka Enore menanehaliti koamaniya xisaona maheta. Enokoa, waikoa, one, tyotya xoalini harenae nomasehare koamaniya xisaona maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Toahiya Enore maisa watyaliye halitinae. Aliyakere xamani hawenane kakoa tyaona aokowita hoka nikare tyaona hawenane heko maheta. ");
INSERT INTO pabNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Xakore hoka maisa haliti ana mahotikirere waiyexe háomanenae. One enokoata axikatya hoka hanakatihaliti aihatikijita enaose akehena hoka. Nakairati harenae tehitiya ijita, exahe hoka kalore aihalahalinikijita xiso — nexaha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hatyo iniraineha najikinita hekota aisaha kirakahare hoka fetatyaha enomanaha aokowiyahitaha. Hoka aiyaterityoa exahitaha, kotare maxaisakahare enomanaha aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Hatyaoseta haiyanae judeunae tyoaha Antioquia nalita, Icônio nalita. Aisatanakotyahitaha halitinai hoka kahinaetyahene hoka mokotyaha Paulo sehali kakoa. Hatyaoseta nolokehekoatyahene haware wenakalati nonitata hoka halakisahene, motya atyo waini aokahitaha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hatyaoseta Jesus koamaniya tyaoniterenae ahohisakoatyakakoaha hoka ehokohaliya tityoaha hoka kaseheta enomanaha. Tityoaheta hoka xanehitiya wenakalati xeta. Kamaetali hoka Paulo, Barnabé xoaha xanehitiyaha wenakalati Derbe nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo, Barnabé xoaha Derbe nali xakaihenahitiya Iraiti Waiyexe tahi akiti hoka hatyo nali tyaoniterenae semaha iraiti hoka haiyanae Jesus koamaniya kahare tyaonaha. Hatyaoseta haikoahenahitaha Listra, Icônio, Antioquia Pisídia koa nali xeta. ");
INSERT INTO pabNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Aihalahalinikisa, aotyakisaha harenae Jesus koamaniya tyaoniterenae masakare tyakekoha maheta. — Maikaite iniyalahare hotohare wikaxomokaka hoka hatyo najikinitaite wiyane wikaoka Enore nawenakala nali — nexaha ihiyeha. ");
INSERT INTO pabNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hahotyali konita, hahotyali konita xakini iraiti tyakekoterenae nityohalitiranae moka enomanaha. Manakairaharahitaha iraexatyahitaha hatyo inityohalitiranaiha tyaohenere ana. Xekohaseti maniya tyaonahitaha hoka iraexatyahitaha Xekohaseti kaxaiko maheta tyakekoterenae nityohalitiranae. ");
INSERT INTO pabNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Hatyaoseta Paulo, Barna