﻿USE sofia;
DROP TABLE IF EXISTS sofia.oyde_vpl;
CREATE TABLE oyde_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES oyde_vpl WRITE;
INSERT INTO oyde_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ꮉንፓ ካሊ ጻፍንትደ ዳዉተ ናአ አብራሃማ ናአ ማቅደ የሱስ ክርስቶሳ የልንቶ። ");
INSERT INTO oyde_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","አብራሃማ ይሳቃ የልዳ፤ ይሳቃ ያይቆባ የልዳ፤ ያይቆባ ይሁዳን ኤ እሹንꬃና የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ይሁዳ ትእማርፓ ፋረሰነን ዛራን የልዳ፤ ፋረሳ አስሮመ የልዳ፤ አስሮመ ራመ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ራመ አምናዳበ የልዳ፤ አምናዳበ ናአሶና የልዳ፤ ናአሶና ሳልሞነ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሳልሞነ ረአብፓ ቦኤዛ የልዳ፤ ቦኤዛ ኡሩትፓ እዮቤደ የልዳ፤ እዮቤደ እሰይ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","እሰየን ካት ዳዉተ የልዳ፤ ዳዉተ ኦርዮ ማችትፓ ሶሎሞነ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሶሎሞነ ሮብአማ የልዳ፤ ሮብአማ አብያ የልዳ፤ አብያ አሳፋ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","አሳፋ እዮሳፍጠ የልዳ፤ እዮሳፍጠ እዮራመ የልዳ፤ እዮራመ ኦዝያነ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ኦዝያነ እዮአታማ የልዳ፤ እዮአታማ አካዛ የልዳ፤ አካዛ ሕዝቅያሳ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ሕዝቅያሳ ምናሰ የልዳ፤ ምናሰ አሞና የልዳ፤ አሞና እዮስያሳ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","እስራኤለ አሱንꬅ ድእንት ባብሎነ ጋዘ ሳአ Ꮉንግደ ዎደ እዮስያሳ እኮንያናን ኤ እሹንꬃና የልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ባብሎነ ሳአ እስራኤለ አሱንꬅ ድእንቲ Ꮉንግደፓ ማቂ እኮንያና ሳላትያለ የልዳ። ሳላትያለ ዘሩባቤላ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዘሩባቤላ አብድዩ የልዳ፤ አብድዩ ኤልያቀመ የልዳ፤ ኤልያቀመ አዛራ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","አዛራ ሳዶቀ የልዳ፤ ሳዶቀ አክመ የልዳ፤ አክመ ኤልዩዳ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ኤልዩዳ አላዛረ የልዳ፤ አላዛረ ማታነ የልዳ፤ ማታነ ያይቆባ የልዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያይቆባ ዮሰፋ የልዳ፤ ዮሰፋ ክርስቶሳ ጋዘ የሱሳ የልደ ማይራም አዝኒ። ");
INSERT INTO oyde_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ይኬ፥ የልንታ አብራሃመፓ ዳዉተ የሎደስ ታጶ ኦይዲ። ዳዉተፓ Ꮉንግ ባብሎነ ድኤ የሎደስ ታጶ ኦይዲ። ባብሎነ ድኤፓ Ꮉንግ ክርስቶሳ የሎደስ ታጶ ኦይዲ የልንተ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","የሱስ ክርስቶሳ የልንታ ታሪከ Ꮉንፓ ካልዛኖ። ኤ እንታ ማይራማ ዮሰፋስ ኦጭንት የዝተ ዮሰፋ ኤክካይዝን ጌሽ አያናፓ ዎዳጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ዮሰፋ ጽሎ አስ ማቅደ ግሾ እዞ አስ ግዳ ኬሶደስ ኮይካያ። ይኒ ግሾ አቺ እዞ አሾደስ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ኤ ይና ቆፍተ የዝን ጾዘ ኪታንቾ አቡኮራ ቆንጪ፥ «ዳዉተ ናአይ፥ ዮሰፋ፥ ነ ኦጭደ ማይራማ ዎዳጽደ ጌሽ አያናፓ ማቅደ ግሾ እዞ ኤኮደስ ዣሽትፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","እዛ ꬊራꬅ ናአ የሎዳ፥ ኤ ፋ ዎርዥቶ ኡን ናጋርትፓ አሽዘ ግሾ ኤ ሱንꬅቶ ነ የሱሳ ጋእ ጼጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ላꬄ ናበ ኢሳያሳ ዶና። ");
INSERT INTO oyde_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ይኬ ዉዱርታ ዎዳጾዳ፤ ꬊራꬅ ናአን የሎዳ፤ ኤ ሱንꬅታ አማኑኤላ ጋእንቶዳ» ጋእንትዳና ፎልንቶደ ፋና Ꮉና ኡባና Ꮉንዳ። አማኑኤላ ጋዛንስ ብልꬅታ «ጾዚ ኑራ የነ» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ዮሰፋ ገንቶፓ ባርክ ላꬄ ኪታንቹንꬅ ኪትዳን ፋና ማይራሞ ፋ ካራ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","የዝን ፋ አንግስ ናአያ የሎደ ዎንꬅስ እዞ ግርምካያ፤ የልንትደ ናአያ የሱሳ ጋእ ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ካት ሄሮድሳ ዎደ የሱሳ ይሁዳ ሳአ ቤተለመ ካታማ የልንትዳንፓ ሱባ ጾልንቶ ብእ አሱንꬅ አዋ ከሳፓ የሩሳላመ ይእ፥ ");
INSERT INTO oyde_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«የልንትደ አይሁደ ካትዘ አባ የነ? ኑኒ አዋ ኬስ ዛላራ ኬዚ ኤ ጾልንትዛ ብእ ኤስ ጎይኖደስ ይእዳ» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ካት ሄሮድሳ ይኖ ስእደ ዎደ ታንዳ። የሩሳላመ የዘ አሱንꬅ ኡባና ታንዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ሄሮድሳ ካህኑንꬅ Ꮉላቁንꬃናን ህገ አስታማሩንꬃና ፋጎ ጼጊ፥ «ክርስቶሳ አባ የልንተሳ?» ያጋእ ኡንታና ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ኡንትን፥ ይሁዳ ቤተለመ፤ ናብዘ፥ ");
INSERT INTO oyde_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","« ‹ይሁዳ የዘ ቤተለመ፥ ይሁዳ የዘ ዳማ ካታሙንꬃፓ፥ ኔኒ አኮን ኤሮስ። ታ ዎርዥቶ እስራኤለ አሆዳይ፥ ኔፓ ከዞዳ› ጋእ ጻፍዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ይንፓ ሱባ፥ ሄሮድሳ አዋ ከሳፓ ይእደ አሱንꬃና አቺ ጼጊ፥ ጾልንትዛ ኡን ብእደ ዎደ ኡንታፓ ሎይꬂ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ኤ ኡንታና ቤተለመ ዳክተራ፥ «Ꮉንግ የልንትደ ናአያ ምንꬂ ኮዮተ፤ ኤዛ ይን ደንግደ ዎደ ታንን Ꮉንግ ኤስ ጎይኖደ ጋር ማቂ ይእተራ ታስ ኦሆተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ኡንትን ካት ሄሮድሳ ጋይዳኖ ስእ Ꮉንግዳ። ኡን አዋ ኬስ ዛላራ Ꮉንግ ጾልንትዘ ኡንታና ካልꬅተራ ናአይ የዘ በስቶ የሎደስ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ኡን የ ጾልንትዛ ብእደ ዎደ ዳማ ኡፋይስ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ኬꬃ ገሊ ናአይ ፋ እንቲ ማይራምራ የዛያ ብእዳ። ኤስ ቡንቁንቲ ጎይንዳ። ፋ ሳጥንቶ ቡጊ ዎርቃን፥ እጻነን ካርበ ኤስ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ኡን ሄሮድሳጎ ሱብ ማቃመ ፋና ጾዚ አቡኮራ ኡንትስ ኦህን፥ መለ ኦገራ ፋ ጋደ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","አዋ ኬስ ዛላራ ይእደ አሱንꬅ ቅትዳንፓ ሱባ፥ ላꬄ ኪታንችዘ ዮሰፋስ አቡኮራ ቆንጪ፥ «ሄሮድሳ ናአያ ዎꬎደስ ኮይዘ ግሾ ደንዲ፤ ኤልሲ ናአያን ናአይ እንቶን ኤኪ ግብጸ ጋደ ቅቶ። ነ ማቃደ ዎደ ታ ኔስ ኦሆደ ዎንꬅስ የይጋ ጋምኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ይኒ ግሾ፥ ዮሰፋ ይና ቃምተ ደንዲ፥ ናአያን ናአ እንቶ ኤኪ ግብጸ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ናበ ዶንተ ጾዚ፥ «ታኒ፥ ታ ናአያ፥ ግብጸ ጋደፓ ጼግዳ» ጋእንትደ ቃልታ ፎልንቶደ ጋር ሄሮድሳ Ꮉይቆደ ዎንꬅስ ኤ የይጋ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ይንፓ ሱባ፥ አዋ ኬስ ዛላራ ይእደ አሱንꬅ ኤዛ ጭምዳኖ ኤርደ ዎደ ጋማ ዥልꬍዳ። ኤ ቲኖ ኡንታፓ ስእዳን ፋና ቤተለመን ይና ጉቱተ የዘ ላምእ በረ ኩምዱንꬃናን ላምእ በረፓ ዬካራ የዘ ꬊራꬅ ናኡንꬃና ኡባ ፋ ዎታዳሩንꬃና ዳኪ ዎꬍዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","ናበ ኤርምያሳ ዶንተ፥ «ዬፎን ዬፎ ደንꬄ፥ ራማ ካታማ ስንትዳ። ራሄላ ፋ ናኡንꬅስ ዬካነ፤ ኡን Ꮉይቂደ ግሾ ምንጎደስ ዳንዳእካያ» ጋእ ኦህንትዳና ፎልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ሄሮድሳ Ꮉይቂዳንፓ ሱባ ግብጸ ላꬄ ኪታንቾ ዮሰፋስ አቡኮራ ቆንጪ፥ ");
INSERT INTO oyde_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«ናአያ ዎꬎደስ ኮይዘ አሱንꬅ Ꮉይቂደ ግሾ ደንዲ ናአያን ናአይ እንቶ ኤኪ እስራኤለ ጋደ ማቆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ዮሰፋ ደንዲ ናአያን ናአይ እንቶ ኤኪ እስራኤለ ጋደ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","የዝን አርከልዮሳ ይሁዳ ፋ አደ ሄሮድሳ በስተ ካእትዳኖ ስእደ ዎደ የይጋ Ꮉንጎደስ ዣሽትዳ። ጾዚ አቡኮራ ኤስ ቆንጭዝን ጋልላ ጋደ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ናቡንꬅ ዶንተ፥ «ናዝረተ አስ ጋእንቶዳ» ያጋእ ኦህንትዳና ፎልንቶደ ፋና ናዝረተ ካታማ Ꮉንግ የይጋ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","የ ዎደ ጻማቅዘ ዋሐንሳ፥ «ጾዘ ካእቱሞ ኡክደ ግሾ ይን ናጋራፓ ማቆተ» ያጋእ ሳባክተራ ይሁዳ አኮ ባይዘ ጋናሳ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ናበ ኢሳያሳ ዋሐንሳ ባዝ ኦህዳን ፋና፥ «አኮ ባይዘ ጋናሳ፥ ፈታይ ፋ ቃልቶ ꬎቅ ዪዚ፥ ‹ላꬄ ኦግቶ ጊግዞተ። ኤ ዎሮግቶ ሉልዞተ› ጋይዳ» ያጋእንትዳና ኤስ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ዋሐንሳ ግማለ እስንፓ ኦችንትደ አፉላ ማአነ። ፋ ቃዝንተን ዳፈ ሳቀ ዳንጫነ። ኤ ሙእዘ ካꬅታን ቦለን ደከራ ሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","አሱንꬅ የ ዎደ የሩሳላመ ካታማፓ፥ ይሁዳ ሳአ ኡባፓ ዮርዳኖሳ ቦርካ ካለፓ ኤጎ የእነ። ");
INSERT INTO oyde_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ፋ ናጋርቶ ቡጽ ዮርዳኖሳ ቦርካ ዋሐንሳ ኩሸ ጻማቅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ዋሐንሳ፥ ጋማ ፋርሳዉንꬅን ሳዱቃዉንꬅ ጻማቅንቶደስ ፋጎ ይእዙንꬃና ብእ፥ ኡንታጎ፥ «Ꮉንꬅ ኢታ ሾሹንꬆ፥ ዮኦደ ጾዘ ካቻፓ አቶደ ፋና ይንታና ኦደ ዞርደ? ");
INSERT INTO oyde_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ይኬ፥ ይን፥ ይን ናጋርትፓ ማቅዳኖ ቤዘ ኦቻ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ይን፥ ይን ዎዝንተ፥ ‹አብራሃማ፥ ኑ አዳይ የነ› ያጋእ ቆፕፐተ። ሎይꬂ ስኦተ! ጾዚ Ꮉና ሹችትፓ አብራሃማስ ናአ ኬሶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ጋንደ ምንጽት ጻጵተ ጊጊ የነ፤ ሎኦ ኣፈ ኣፎሰ ምንጻ ኡባ ጋቺ ታማ ኦልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«ይን፥ ይን ናጋርትፓ ማቅዳኖ ኤርሶደስ ታ ይንታና Ꮉꬃ ጻማቃነ። የዝን ታፓ ሱባራ የእዘ ይንታና ጌሽ አያናራን ታማራ ጻማቆዳ። ኤ ታፓ ጋማ ዎልቃራ የነ፤ ታ መለ አቶ የዝን ኤ ጫምቶ ቱኮደስን ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ካꬃ ጌሽዘ ፍꬅታ ኤ ኩሽተ የነ። ካꬅቶ ሎይꬂ ጌሻነ፤ ዛርግቶ ፋ ፋችተ ጉሶዳ፥ የዝን ፉግቶ ꬋቦሰ ታማ ምቾዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","የ ዎደ የሱሳ ዋሐንሳ ኩሸ ጻማቅንቶደስ ጋልላፓ ዮርዳኖሳ ቦርካ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","የዝን ዋሐንሳ ኤዛ ካዮደስ ኮይ «ታኒ ኔራ ጻማቅንቶደስ ቤዝን ነ ታጎ የእነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","የዝን የሱሳ ማህ፥ «ጾዚ ኑፓ ኮይዘ ባዝ ኡባ ኑ ፎሎደስ ቤዘ ግሾ Ꮉተ ታስ ኤሮ ጋኦ» ያጋይዳ። ዋሐንሳ ኤስ ዬኤ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","የሱሳ ጻማቅንትደ ፋና Ꮉꬅትፓ ከዝዳ። ኢራ ሳሎ ቡጉንትን ጾዘ አያና ዎለ ፋና የኦደራን ማህ ፋላ አፋ ዎꬎደራ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","የ ዎደ «Ꮉይቼ ታ ካዽዘ፥ ኤ ታና ኡፋይስዘ ታ ናአይ Ꮉያ» ያጋዘ ቃላ ሳሎፓ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ይንፓ ሱባ፥ ጻላሄ የሱሳ ፋታኖደ ጋር ጌሽ አያና የሱሳ አኮ ባይዘ ጋናሳ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ኦይታም ቃማን ኦይታም አዋራ ጾምዳንፓ ሱባ ናይꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ጻላሄ የሱሳጎ ይእ «ነ ጾዝ ናአ ማቅኮ፥ አነ Ꮉይ ሹችዛ ሶሎ ማቃደ ፋና ኪቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","የሱሳ ማህ፥ « ‹አስ ጾዘ ዶናፓ ከዘ ቃላ ኡባነ የሳደፕ አትን ሶሎ ጻላላራ የዞስ› ጋእንት ጾዘ ቃልተ ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ማህን፥ ጻላሄ የሱሳ ጌሽ ካታማ ካንግ፥ ጾዘ ኬꬅትስ ኦምተ ኬሲ፥ ");
INSERT INTO oyde_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«ነ ጾዝ ናአ ማቅኮ፥ አነ ሱለ ሳአ ጎልኦ። አኮስ ጋይኮ፥ « ‹ነ ቶህታ ሹቻላ ꬉቡንታመ ፋና፥ ፋ ኩሽትራ ነና ደንꬆደ ፋና፥ ጾዚ ፋ ኪታንቹንꬃና ነ ግሾ ኪቶዳ› ጋእንት ጾዘ ቃልተ ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","የሱሳ ኤጎ፥ «ማህ፥ ‹ጾዘ ቃልተ ነ ላꬃ፥ ነ ጾዛ ፋታንፐ› ያጋእ ጻፍንትዳ» ጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ዉርሱꬅተ ጻላሄ የሱሳ ፈቲ ዳማ ደረ ኦማ ኬሲ አላመ ካእቱሞ ኡን ቦንችትራ ፈትላ ቤዚ፥ ");
INSERT INTO oyde_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«ነ ታስ ጎልእ ጎይንኮ ታ ኔስ Ꮉኖ ኡባ እንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","የሱሳ ማህ፥ «Ꮉይ ጻላህዛዮ፥ ታፓ Ꮉኮ! ‹ነ ላꬃ፥ ነ ጾዛ ጎይኖ፥ ኤ ጻላላስ ኪትንቶ› ጋይንት ጾዘ ቃልተ ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ይንፓ ሱባ፥ ጻላሄ አሺ ቅትዳ፤ ኪታንቹንꬅ ይእ ኤዛ ማድዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","የሱሳ፥ ዋሐንሳ አጭንትዳኖ ስእደ ዎደ ጋልላ ጋደ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ናዝረተ ካታማ አሺ ዛብሎነን ንፍታለመ ጉታ፥ አባ ካለ የዘ ቅፍርናሆመ ካታማ Ꮉንግ የይጋ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ይና Ꮉንዳና ናበ ኢሳያሳ ዶንተ፥ ");
INSERT INTO oyde_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«ዛብሎነ ጋደን፥ ንፍታለመ ጋደ፥ ዮርዳኖሳ ቦርካፓ ሰኮ ፍንꬃ፥ አባ ኦገ፥ አይሁደ ማቆሰ ዎርዡንꬅስ የዘ ጋልላ፥ ");
INSERT INTO oyde_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ꬉማ የዘ ዎርዣ፥ ዳማ ፎኦ ብእዳ። Ꮉይቆ ዳሾ ጋደ፥ የዙንꬅስ ፎኦ ከዝዳ» ያጋእ ኦህንትደ ቃልታ ፎልንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","የ ዎደፓ ደንꬂ የሱሳ፥ «ጾዝ ካእቱሞ ኡክደ ግሾ ይን ናጋርትፓ ማቆተ» ያጋእ ቃላ ሳባክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","የሱሳ ጋልላ አባ ካለራ አꬍተራ ላምእ እሹንꬃና፥ ጴጥሮሳ ጋእንትዘ ስሞናን ኤ እሻ እንድራሰ ብእዳ። ኡን ሞሎ አይክዙንꬃና ማቅደ ግሾ ፋ ግትቶ አባላ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","የሱሳ ኡንታና፥ «Ꮉንካ ዮኦተ፤ ታና ካሎተ! ሞሎ አይክዛኖ አሺ፥ ታ ይንታና አስ አይፎ ታማርሶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ኡን፥ ኤልሲ ፋ ግትቶ ኦሊ አሺ የሱሳ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","የሱሳ የይጋፓ Ꮉጋ ጎደ ቲኖ ኣꬍተራ መለ ላምእ እሹንꬃና፥ ዛብድዮሳ ናኡንꬃና፥ ያይቆባን ዋሐንሳን ብእዳ። ፋ አዳይ ዛብድዮሳራ ዎላ ጎንገ ግዳ ፋ ግትቶ ሎይꬅዙንꬃና ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ኡን፥ ኤልሲ ፋ ጎንግቶን ፋ አዳያን አሺ የሱሳ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","የሱሳ አይሁደ ዎሳ ኬꬃ ታማርስተራ፥ ሳሎ ካእቱሞ ዎንገለ ኦህተራ ዱማ ዱማ Ꮉርገፓ አሱንꬃና ፋꬅተራ ጋልላ ሳአ ኡባነ ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ይንፓ ደንዲ ኤ ሱንꬅታ ሶርያ ጋደ ኡባ ኤርንትዳ። ዱማ ዱማ Ꮉርገራ አይክንትዱንꬃናን ዋይንትዙንꬃና፥ ቱና አያናራ አይክንትዱንꬃና፥ ቢጮራ የዙንꬃና፥ ዎቡንꬃና ኤጎ ክእዳ፤ ኤዝን ኡንታና ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","አሱንꬅ ጋልላፓ፥ ታጵ ካታሙንꬃፓ፥ የሩሳላመፓ፥ ይሁዳፓን ዮርዳኖሳ ቦርካ ሰኮ ፍንꬃ የዘ ጋደፓ ይእደ ጋማ አሱንꬅ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ጋማ ዎርዣ ሺቅዳኖ የሱሳ ብእ ደረላ አፋ ኬዚ በትዳ። ኤ ታማሩንꬅ ኤጎ ሺቅን፥ ");
INSERT INTO oyde_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ꮉኒ ጋር ያጋእ ታማርስዳ፦ ");
INSERT INTO oyde_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«ፋ አያንተ ዳሃ ማቅዱንꬅ አንጅንትዱንꬃና፥ ሳሎ ካእቱሞ ኡንትስ። ");
INSERT INTO oyde_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ዬክዙንꬅ አንጅንትዱንꬃና፥ ኡን ምንꬅ ደንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ዎዝና አዱንꬅ አንጅንትዱንꬃና፥ ኡን ሳአ ላቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ጽሎትꬅ ኦቾደስ ናይꬍዙንꬅን ባርꬍዙንꬅ አንጅንትዱንꬃና፥ ኡን ምሻዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ማርዙንꬅ አንጅንትዱንꬃና፥ ኡን ማሮትꬅ ደንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ዎዝና ጌሹንꬅ አንጅንትዱንꬃና፥ ኡን ጾዚ በአዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ጊግዙንꬅ አንጅንትዱንꬃና፥ ኡን ጾዝ ናአ ጋእንት ጼግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ጽሎትꬅ ኦችዘ ግሾ ጋእ፥ ባይእንትዙንꬅ አንጅንትዱንꬃና፥ ሳሎ ካእቱሞ ኡንትስ። ");
INSERT INTO oyde_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«አሱንꬅ ይንታና ታ ግሾ ጋእ ጫዥዘ ዎደ ባይእዘ ዎደን ይንታላ አፋ ኢታ ባዝ ኡባ ዎርዶራ ኦህዘ ዎደ ይን አንጅንትዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ይን አንጅታ ሳሎ ዳማ ማቅደ ግሾ ኡፋይቶተ፥ ሎይꬂ ኡፋይቶተ። ይንታፓ ቲኖ የዝደ ናቡንꬃና ይኒ ጋር ባይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«ይን ሳአስ ሶገ፤ ሶገ ፋ ማልእቱምቶ አሽኮ፥ ዋይዝ ማህ ደንጎደ? ባለ ꬎግኮ አሳራ የꬍንታነፕ አትን አኮስን ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«ይን ሳአስ ፎኦ፤ ደረላ አፋ የዘ ካታምታ አችንቶደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ጾምፐ አይꬂ ኬꬃ የዘ አሱንꬅ ኡቡንꬅስ ፎኦደ ጋር ꬎቃ በሳ ጋዳነፕ አትን ጋባተ ግዳ ጋድዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ይኒ ጋር አሱንꬅ ይን ሎኦ ኦችቶ ብእ፥ ሳሎ የዘ ይን አዳያ ቦንቾደ ጋር ይን ፎእታ አስ ቲኖ ፎኦ። ");
INSERT INTO oyde_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«ታኒ ሙሴ ህግቶን ናቡንꬅ ቃላ ሻሮደስ ይእዳ ይንትስ አዝፐ። ታኒ፥ ኡን ኦህዳና ቱሮ ማቅዳኖ ቆንጭሳደስ ይእዳፕ አትን ሻሮደስ ይእካያ። ");
INSERT INTO oyde_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ታ ይንትስ ቱሮ ኦህነ፤ ሳሎን ሳአ አꬎደ ዎንꬅስ ህገ ኡባ ፎልንቶደፕ አትን ህግትፋ ፈቲ ቃላ ዎይ ፍዳለ አꬎስ። ");
INSERT INTO oyde_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ይኒ ግሾ፥ Ꮉና ኪትትፓ ኤርዘ ፈቲ ኪታን መንꬅዘ ኦደን ማህ መሉንꬃና ይኒ ጋር ኦቾደ ጋር ታማርስዘ ኦደን ሳሎ ካእቱሞ ኡቡንꬃፓ ኤራꬅ ማቃዳ። የዝን Ꮉና ኪቶ ፎልዘን መሉንꬃናን ፎሎደ ጋር ታማርስዘ ሳሎ ካእቱሞ ዳማ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ታ ይንትስ ኦህነ፤ ይን ጽሎትꬅታ ፋርሳዉንꬅ ጽሎትꬃፓን ህገ አስታማሩንꬅ ጽሎትꬃፓ አꬋንጽኮ፥ ሳሎ ካእቱሞ ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«ይን ማይዙንꬅስ፥ ‹ዎꬍፐተ፤ ሸምፖ ዎꬍደ ኦደን ፍርድንቶዳ› ጋእንትዳኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","የዝን ታ ይንትስ ኦህነ፤ ፋ እሻያ ጫዥዘ ኦደን ፍርድንቶዳ። ፋ እሻያ ጫዥዘ ኦደን ዳይና ቲኖ ፍርዳስ ሺቆዳ። ፋ እሸጎ፥ ‹ኤያይ› ጋዘ ኦደን ማህ ጋናመ ታምተ ፍርድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«ይኒ ግሾ፥ ነ ነ ዣርሾ ዣርሽዘ ዎደ ነ እሻያ ቆህደ ባዝ ኔስ ቲርንትኮ፥ ");
INSERT INTO oyde_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ነ ዣርሽቶ እዛ በስተ አሺ አሺ ቅቶ፤ ቲኖ Ꮉንግ ነ እሻይራ ጊጎ፤ የይዝ ማቂ፥ ነ ዣርሽቶ ጾዝስ ዣርሾ። ");
INSERT INTO oyde_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«ነና ሞትዘራ ፍርዳ ኬꬃ Ꮉንግተራ ኦገላ ኤራ ጊጎ። ይና አቶ ጋይኮ ኤ ነና ዳይና ቲኖ ካንጎዳ። ዳይንዘ ነና አጭዘስ አꬂ እንጎዳ፤ ኤ ነና ዎይነ ኦሎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ታ ቱሮ ኦህነ፤ ኔላ አፋ ፍርድንትደ አጭቶ ፈቲ ሳንትመ አትካይዝን ጭጊ Ꮉሶደ ዎንꬅስ አች ኬꬃፓ ሙሎን ኬዛማ። ");
INSERT INTO oyde_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ꮉንፓ ዛጋ፥ ‹ኦላለ Ꮉንትፐተ› ጋእንትዳኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","የዝን ታ ይንትስ ኦህነ፥ ማቾ ብእ፥ አሙꬍደ ኡባ ፋ ዎዝንተ ኢራ ኦላልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ነ ምዛቅ ኣፍዘ ኔስ ናጋራስ ምክናተ ማቅኮ፥ ኬሲ ኦሎ። ነ ጋልታ ኩሙꬅ ጋናመ ታማ ዎꬎዳንፓ ነ ጋልትፓ ፈታይ ꬋብኮ ኔስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ነ ምዛቅ ኩሽዘ ኔስ ናጋራስ ምክናተ ማቅኮ፥ ኤዛ ጋቺ ኦሎ። ነ ጋልታ ኩሙꬅታ ጋናመ ታማ ዎꬎዳንፓ ነ ጋልትፓ ፈታይ ꬋብኮ፥ ኔስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«‹ፋ ማችቶ ዳክዘ ኦደን ዳፎ ዋርቃተ እንጎ› ጋእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","የዝን ታ ይንትስ ኦህነ፤ ፋ ማችቶ ኦላልካይዝን ብልዘ ኦደን እዛ ኦላሎደ ጋር ኦቻነ። ይኒ ጋራን፥ ዳክንትደ ማችቶ ኤክዘ ኡባ ኦላልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«ይን ማይዙንꬃጎ፥ ‹ዎርዶ ጫቂፐተ፤ ይን ጾዘ ቲኖ ጫቂዳኖ ፎሎተ› ጋእንትዳኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","የዝን ታ ይንትስ ኦህነ፤ ሙሎን ጫቂፐተ። ጾዚ በትዘ ኦይዳ ማቅደ ግሾ ሳሎራ ጫቂፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ኤ ቶህታ የꬍዘ በሲ ማቅደ ግሾ ሳአራ ጫቂፐተ። ዳማ ካት ካታማ ማቅደ ግሾ የሩሳላመራን ጫቅፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ይን ኦምትፓ ፈታያ ቦꬅ ዎይ ካርꬅ ማሆደስ ዳንዳኦሰ ግሾ ይን ይን ኦምተ ጫቂፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ይኒ ግሾ፥ ይን ቃልታ፥ ‹ዬ› ዎይ ‹አደ› ማቆ። ይንፓ ባለ ከዝዘ ጻላሄፓ የእነ። ");
INSERT INTO oyde_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹ኣፈ ግሾ ኣፈ፤ አች ግሾ አች› ጋእንትዳኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","የዝን ታ ይንትስ ኦህነ፤ ይንታላ አፋ ኢታ ባዝ ኦችዘ አꬃ እጽፐተ። ኦደን ነ ምዛቅ ꬎኦክዛ ባቂኮ ነ ዎርክታ ꬎክዛን ቤዞ። ");
INSERT INTO oyde_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ፈቲ አሲ ነ ሻምዛ ዎልቃራ ኤኮደስ ነና ሞትኮ፥ ነ ኮትዛን ጉጂ እንጎ። ");
INSERT INTO oyde_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ፈቲ አሲ ነና ዎልቃራ ፋ ባዝ ቶሲ ፈቲ ሳተ ኦገ ፋራ Ꮉንጎደ ጋር ነና ኡንእꬅኮ፥ ኤራ ላምእ ሳተ ኦገ Ꮉንጎ። ");
INSERT INTO oyde_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ዎስዘ ኦደስን እንጎ፤ ኔፓ ታልኦደስ ኮይኮ ኦናን ካይፐ። ");
INSERT INTO oyde_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«‹ነና ካꬍዛ ካꬎ፤ ነና እጽዛያ እጾ› ጋእንትዳኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","የዝን ታ ይንትስ ኦህነ፤ ይን ሞርኩንꬃና ካꬎተ፤ ይንታና ቆህዙንꬅስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ይኒ ጋር ይን ኦችኮ፥ ሳሎ የዘ ይን አዳይስ ይን ናኡንꬃና ማቃዳ። ኤ ኢቱንꬅስን ሎኡንꬅስ አዋ ካሳነ፤ ጽሉንꬅስን ናጋራንቹንꬅስን ፋ እራ ቡክዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ይንታና ካዽዘ አሱንꬃና ጻላላ ይን ካꬍኮ፥ ይንትስ አኮ ትርፈ የዘ? መለ አቶ የዝን፥ ጋበ ቃራጠ ጋችዙንꬅን ይኖ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ይን፥ ይን እሹንꬃና ጻላላ ሳርꬅኮ፥ መሉንꬃፓ አኮ አꬍዘባዝ ኦችዶተ? መለ አቶ የዝን፥ ጾዝ አማኖሰ አሱንꬅ ይኖ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ይኬ፥ ሳሎ የዘ ይን አዳይ ፎሎ ማቅዳን ፋና ይንትን ፎሎ ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«አስ ቦኦ ጋእ ይን ሎኦ ኦችቶ አስ ቲኖ ኦቻመ ፋና ናግንቶተ። ይኒ ጋር ይአንጽኮ ሳሎ የዘ ይን አዳይፓ አንጆ ደንጋማ። ");
INSERT INTO oyde_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«ይን ዳሁንꬅስ እንግዘ ዎደ አስ ቲኖ ቦንችንቶደስ ጋእ ጩቡንꬅ ኦገ ጋጻን አይሁደ ዎሳ ኬꬃን ኦችዛን ፋና አስ ቦኦ ጋእ ኦችፐተ። ታ ይንትስ ቱሮ ኦህነ ኡን ፋ ኩሙꬅ አንጅቶ ኤክዳ ");
INSERT INTO oyde_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","የዝን ይን ዳሁንꬅስ እንግዘ ዎደ ይን ምዛቅ ኩሸ ኦችዛኖ ይን ዎርክታ ኩሸ ኤርፐ፤ ");
INSERT INTO oyde_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ይን እሞታ ጌማ ማቀ። ጌማ በሳ ኦችዛኖ በእዘ ይን አዳይ ይንትስ አንጅቶ ቆንጨ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«ዎሳ ዎስተራ ጩቡንꬅ ጋር ዪፐተ። ኡን፥ ፋና አስ ቦኦ ጋእ አይሁደ ዎሳ ኬꬃ ኦገ ዶና ኤቂ ዎስዛኖ ካꬋነ። ታ ይንትስ ቱሮ ኦህነ፤ ኡን ፋ ኩሙꬅ አንጅቶ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","የዝን ነ ዎስዘ ዎደ ነ ቆልአ ገሎ፥ ፉርꬅቶ ጎርዲ ጌማ የዘ ነ አዳያ ዎሶ፤ ጌማ ኦችንትዳኖ በእዘ ነ አዳይ ኔስ አንጆ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ይን ዎስዘ ዎደ አማኖሰ አሱንꬅ ጋራ ጨር ቃላ ጋንꬅ ዎስፐተ። ኡን ቃልቶ ማህ ማህ ዎስን ጾዚ ስእነ ጋእ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ይኒ ግሾ፥ ኡንትን ጋር ዪፐተ። አኮስ ጋይኮ፥ ይን አዳይ ይንትስ አኮ ኮሽዛኮ ይን ዎሶዳንፓ ቲኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«ይኬ፥ ይን ያጋእ ዎሶተ፦ «ሳሎ የዘ ኑ አዳዮ፥ ነ ጌሽ ሱንꬅታ አንጅንቶ። ");
INSERT INTO oyde_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ነ ካእቱምታ ዮኦ፥ ነ ቆፍታ ሳሎ Ꮉንዳን ፋና ሳአን Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ꮉይኖ ቁምቶ ኑስ እንጎ። ");
INSERT INTO oyde_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ኑ ኑና ቆህዱንꬅስ፥ አቶ ጋዛን ፋና፥ ኑስን ኑ ቆህቶ አቶ ጋኦ። ");
INSERT INTO oyde_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ኑና ኢታፓ አሾፕ አትን ፋታና ገልꬅፐ። ካእቱሞን፥ ዎልቃን ቦንቾን መዽና ኔስ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«ይን ይንታና ቆህዙንꬃና አቶ ጋይኮ፥ ሳሎ የዘ ይን አዳይ ይን ቆህቶ አቶ ጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","የዝን ይን መለ አስ ናጋራ አቶ ጋአንጽኮ ይን አዳይ ይን ናጋርቶ አቶ ጋኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«ይን ጾምዘ ዎደ ጩቡንꬅ ፋና ዪፐተ። አኮስ ጋይኮ፥ ኡን ጾምዛኖ አሲ ኤሮደ ፋና ፋ ስንቶ ቦꬃነ። ታ ቱሮ ኦህነ፤ ኡን ፋ ሽልማቶ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","«የዝን ነ ጾምዘ ዎደ ነ ስንቶ ሜጮ፥ ነ ኦምቶ ትዦ። ");
INSERT INTO oyde_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ይኒ ጋር ነ ዪዝኮ ነ ጾምዘ ጾምታ አሳፓ ገንግዳ፥ የዝን ጌማ የዘ ነ አዳይ ኤርዘ ጾማ ማቃዳ። ጌማ ኦችንትዳኖ በእዘ ነ አዳይ ኔስ ሽልማተ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«ብላ ሙእዘ በሳ፥ መቆ ብርዘ ሳአ፥ ካይዞ ቦኪ ኤክዘ ሳአ፥ Ꮉና ሳእተ፥ ይንትስ ቆሎ ሺሽፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","የዝን ብላ ሞኦሰ በሳ፥ መቆ ብሮሰ በሳ፥ ካይዞ ቦኪ ኤኮሰ በሳ ሳሎ ይንትስ ቆሎ ሺሾተ። ");
INSERT INTO oyde_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ነ ቆልታ የዘ በስተ ነ ዎዝንታ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«ኣፈ አሳትꬅስ ጾምፐ። ይኒ ግሾ፥ ነ ኣፍታ ፋጻ ማቅኮ ነ ኩሙꬅ አሳትꬅታ ፎኦ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ነ ኣፍታ Ꮉርግንትዛ ማቅኮ ነ ኩሙꬅ አሳትꬅታ ꬉማ ማቃነ። ይኬ፥ ነ ግዳ የዘ ፎእዘ ꬉማ ማቅኮ፥ ꬉማ አኮ ጋር ኣꬊ ꬉማ ማቃደ! ");
INSERT INTO oyde_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«ፈቲ አስ ላምእ ላꬅስ አቆደስ ዳንዳኦስ። ፈታያ ካꬍኮ Ꮉንካያ እጻነ፤ ዎይ ፈታያ ቦንችኮ Ꮉንካያ ለቃነ። ጾዝስን ሚሸስን ዎላል አቆደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«ይኬ፥ ስኦተ! ይን ደኦ የሳደስ፥ ‹አኮ ማአደ? አኮ ኡሻደ? አኮ ማኦደ?› ጋእ ኡንእንትፐተ፤ ሸምፖ ካꬃፓ ዎይ ጋላ ማኦፓ አꬎሶ? ");
INSERT INTO oyde_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","አፋ ላንዱንꬃና ቦኦተ፤ ኡን ቡዶስ፥ ማጾስ፥ ፋቻ ገልꬆስ፥ የዝን ይን ሳሎ አዳይ ኡንታና ሙዛነ። ይን ኡንታፓ ጋማ አꬎሶ? ");
INSERT INTO oyde_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ይን ግዳፓ ጋማ ኡንእንት ፋ ላይꬅትላ አፋ ፈቲ ቃማ ጉጆደስ ዳንዳእዘ የነ? ");
INSERT INTO oyde_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«ማህ ይን ማእዘ ባዝስ አኮስ ኡንእንተ? አነ ፉꬉንꬃና ቦኦተ፥ ኦቺ ላቦስ ዎይ ሱቆስ። ");
INSERT INTO oyde_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ስኦተ! መለ አቶ የዝን፥ ካት ሶሎሞነ ፋ ቦንቾ ኡባነ Ꮉና ፉꬍትፓ ፈታይ ጋር ማእካያ። ");
INSERT INTO oyde_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ይን፥ አማኖ ፋጨዙንꬆ፥ ጾዚ Ꮉይኖ በንቲ ዎንታ ታማ ዎꬎደስ የዘ ማታ የይዝ ማእስዘባዝ ማቅኮ፥ ይንታና ኡንታፓ አꬂ ዋይዝ ማእሶሶ? ");
INSERT INTO oyde_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ይኒ ግሾ፥ ‹አኮ ሞኦደ? አኮ ኡሻደ? አኮ ማአደ?› ጋእ ኡንእንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ይኖ ኡባኖ ጾዝ አማኖሰ አሱንꬅ ጋንꬅ ደንጎደስ ኡንእንታነ። ይን ሳሎ አዳይ ይና ኡባና ይንትስ ኮሽዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","የዝን ኡባፓ ቲኖ ጾዘ ካእቱምቶን ኤ ጽሎትꬅቶ ኮዮተ፤ ይና ኡባና ይንትስ ጉጁንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ይኒ ግሾ፥ ዎንታስ ቆፕተራ ኡንእንትፐተ። ዎንታና ዎንታስ አቆ፤ ፈቲ ፈቲ ቃምዘ ፋስ ማቃደ ማꬋራ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«ይንታላ አፋ ፍርድንታመ ፋና መሉንꬃላ አፋ ፍርድፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","አኮስ ጋይኮ፥ መሉንꬃላ አፋ ይን ፍርድዛን ፋና ይንታላ አፋ ፍርድንቶዳ፤ ይን መሉንꬅስ ማክደ ባዝተ ይንትስ ማህ ማክንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ነ ኣፍተ የዘ ቱስ ፋና የዛያ ብእካይዛራ ነ እሻይ ኣፍተ የዘ ቡርዛ አኮስ በኤ? ");
INSERT INTO oyde_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ነ ኣፍተ ቱስ የሳደራ ነ እሻይ ኣፍተ የዘ ቡርዛ ኬሶ ጋዉደስ ዋይዝ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ናተ ጩቡዛዮ፥ ቲኒ ነ ኣፍተ የዘ ቱስ ፋና የዛያ ኬሶ። ይንፓ ሱባ፥ ነ እሻይ ኣፍተ የዘ ቡርዛ ኬሶደስ ነ ጌሽ በአዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«ሱባ ማቂ ይንታና ꬋኣመ ፋና ጌሽ ባዝ ካኑንꬅስ ኦልፐተ። ፋ ቶህተ የꬊ ኢሳመ ፋና ይን አልኦ ባዝ ጉዳይሉንꬅ ቲኖ ኦልፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«ዎሶተ ይንትስ እንግንቶዳ፥ ኮዮተ ይን ደንጎዳ፥ ፉርꬅቶ ቁንኮተ ይንትስ ቡግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ዎስዘ ኦደስን እንግንቶዳ፥ ኮይዘ ኦደስን በንቶዳ፥ ፉርꬅቶ ቁንክዘስን ቡግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«ይን ግዳፓ ናአይ ቦራ ዎስኮ ሹች እንግዘ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ዎይ ሞሎ ዎስኮ ሾሽ እንግዘ የነ? ");
INSERT INTO oyde_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ዬዝን ይን ኢታ ማቅተራ ይን ናኡንꬅስ ሎኦ ባዝ እንገ ኤርኮ፥ ይን ሳሎ አዳይ ፋና ዎስዙንꬅስ ሎኦ ባዝ ዋይዝ ጋንꬅ እንጋሞ? ");
INSERT INTO oyde_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","መሉንꬅ ይንትስ ኦቾደ ፋና ይን ኮይዘ ባዝ ኡባ ይንትን መሉንꬅስ ኦቾተ። አኮስ ጋይኮ፥ ሙሴ ህግተን ናቡንꬅ ታማርስዛናን Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«ጹንꬅ ፉርꬃራ ገሎተ፤ አኮስ ጋይኮ፥ ꬋብሰስ ካንግዘ ኦግዘ ዳማ፥ ፉርꬅታን ዳልጋ። ኢራ ገልዘ አሱንꬅ ጋማ። ");
INSERT INTO oyde_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","የዝን ደኦጎ ካንግዘ ኦግታን ፉርꬅታን ጹንꬅ፤ የይጋ ገልዘ አሱንꬅን ኤራꬅ። ");
INSERT INTO oyde_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«አፋራ ዱሮ አዚ ፋ ጋꬅተ ሱዹመ ማቂ ይን ግዳ ገልዘ ዎርዶ ናቡንꬃፓ ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ይን ኡንታና፥ ኡን ኣፍትፓ ኤሮዳ፤ አንጋꬃፓ ዎይነ ኣፈ፥ ከንችከሎፓ Ꮉልሞ ማጽንቶስ። ");
INSERT INTO oyde_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ይኒ ፋና ሎኦ ምንጻ ኡባ ሎኦ ኣፈ አፋነ፤ ኢታ ምንጻ ኢታ ኣፈ አፋነ። ");
INSERT INTO oyde_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ሎኦ ምንጻ ኢታ ኣፈ አፎስ፥ ማህ ኢታ ምንጻ ሎኦ ኣፈ አፎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ሎኦ ኣፈ አፎሰ ምንጻ ኡባ ጋችንቲ ታማ ኦልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ይኒ ግሾ፥ ይን ኡንታና፥ ኡን ኣፍተ ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«ሳሎ የዘ ታ አዳይ ቆፍቶ ኦችዘ አስ ሳሎ ካእቱሞ ገሎደፕ አትን ጨር ታና ‹ላꬆ፥ ላꬆ› ጋዘ ኡባ ሳሎ ካእቱሞ ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ፍርዳ ቃማ ጋሙንꬅ፥ ‹ላꬆ፥ ላꬆ፥ ነ ሱንꬅተ ትንቢተ ኦህካ? ነ ሱንꬅተ ቱና አያና ከስካ? ነ ሱንꬅተ ክለ ባዝ ኦችካ?› ያጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","የ ዎደ ታኒ፥ ‹ታ ይንታና ሙሎን ኤሮስ፥ ይን ኢታ ኦችዙንꬆ ታፓ Ꮉኮተ› ጋውዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«ይኬ፥ Ꮉና ታ ቃልቶ ስእ ኦችዘ ኦደን ፋ ኬꬅቶ ላላላ አፋ ኬጽደ ዎዝናራ የዘ አስ ፋና። ");
INSERT INTO oyde_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","እራ ቡክዳ፥ Ꮉሮ ጎግዳ፥ ባቆ ባቂ የ ኬꬅዛ ኡርቂዳ። የዝን ኬꬅታ ላላላ ኬጽንትደ ግሾ ጎልእካያ። ");
INSERT INTO oyde_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ꮉና ታ ቃልቶ ስእ ኦቾሰ ኦደን ፋ ኬꬅቶ ሻፈላ አፋ ኬጽደ ቦዛ አꬃ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","እራ ቡክዳ፥ Ꮉሮ ጎግዳ፥ ባቆ ባቂ፥ የ ኬꬅዛ ኡርቂን፥ የ ኬꬅዘ ጎልእዳ፤ ኤ ጎልእታን ዳማ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","የሱሳ ፋ ኦህቶ Ꮉስደ ዎደ ኤ ትምርትታ ህገ አስታማሩንꬅ ፋና ማቃንጽ አደትꬅ ዎልቃር ማቅደ ግሾ አሱንꬅ ኤ ትምርትተ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","የሱሳ ደርዘፓ ዎꬍዘ ዎደ ጋማ አሱንꬅ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ይኬ ፈቲ ቁርሱማ Ꮉርግንትዘ ኤጎ ሺቂ፥ ኤ ቲንተ ቡንቁንቲ፥ «ላꬆ፥ ነ ቆፋ ማቅኮ ታና ጌሽ ፋꬆደስ ዳንዳአነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","የሱሳ ፋ ኩሽቶ ዳኪ ኤዛ ቦቺ፥ «ዬ፥ ታ ቆፋ፥ ፋጾ» ያጋይዳ። አꬄ ኢራ ጌዥ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","የሱሳ ኤጎ፥ «ነ ፋጽቶ ኦደስን ኦህፐ። የዝን Ꮉንግ ነ ጌዥ ፋጽዳኖ ካህኑንꬃና ቤዞ። ነ ፋጽዳንስ ማርካ ማቃደ ፋና Ꮉንግ ሙሴ ኪትደ ዣርሽቶ ዣርሾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","የሱሳ ቅፍርናሆመ ካታማ የልደ ዎደ ፈቲ ማቶ Ꮉላቅዘ ኤጎ ሺቂ፥ ");
INSERT INTO oyde_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«ላꬆ፥ ታ አርዘ ዎቢ ጋማ ዋይንት፥ ካራ ዎይእ የነ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","የሱሳ ማህ፥ «ታኒ Ꮉንግ ኤዛ ፋꬆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","የዝን ማቶ Ꮉላቅዘ ማህ፥ «ላꬆ፥ ነ ታ ካራ ገሎደስ ታ ቤዘ አስ ባያ፥ የዝን ነ Ꮉይጋ በቲ ቃላ ጻላላ ኦሆ፥ ታ አርዘ ፋጾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","አኮስ ጋይኮ፥ ታፓ ካታራ ታ ኪትንትዘ አሱንꬅ የነ፥ ማህ ታፓ ጋꬃራ ታስ ኪትንትዙንꬅ የነ። ኡንታፓ ፈታያ፥ ‹ቅቶ› ጋይኮ ቅታነ፤ Ꮉንካያ ማህ ‹Ꮉንካ ዮኦ!› ጋይኮ የእነ። ታ አርዛ፥ ‹Ꮉኖ ዪዞ› ጋይኮ ዪዛነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","የሱሳ ይኖ ስእደ ዎደ ጋማ ቆፒ፥ ፋና ካልዘ አሱንꬃጎ፥ «ታ ይንትስ ቱሮ ኦህነ፤ ታኒ Ꮉኒ ጋርዘ አማኖ እስራኤለ አስ ግዳን ብእካያ። ");
INSERT INTO oyde_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ታ ይንትስ ኦህነ፤ ጋሙንꬅ አዋ ኬሳፓን አዋ ገሎፓ ይእ፥ ሳሎ ካእቱሞ አብራሃማራ፥ ይሳቃራን ያይቆባራ ፈትላ በቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","የዝን ሳሎ ካእቱሞ ላቶደስ ቤዝን አትዱንꬃና ባለ ꬉማ ኦሎዳ። እዘ ኡንትስ ዬፎን አች ጋርጭንገ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","የሱሳ ማቶ Ꮉላቅዘጎ፥ «ነ ካራ Ꮉንጎ፥ ነ አማንቲ ፋና ኔስ Ꮉኖ» ያጋይዳ። ኤ አርዘ ኢራ ፋጺ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","የሱሳ ጴጥሮሳ ካራ ገልዘ ዎደ ጴጥሮሳ ማችት እንታ ኦማ ኦꬂ ምሻ Ꮉርገራ Ꮉርግንቲ ዎይእ የዛኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","የሱሳ እ ኩሽቶ ቦችደ ዎደ ኦꬅታን ምችታ አሺ አሽዳ። ፋጺ ደንዲ ኤዛ ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","የ ዎደ ኡጉረ ቱና አያናራ አይክንትደ ጋማ አሱንꬃና፥ አሱንꬅ የሱሳጎ ክእዳ። ኤዝን ቱና አያኑንꬃና ፋ ቃልተ ከስዳ፥ Ꮉርግንትዙንꬃና ኡባ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ይነን ናበ ኢሳያሳ፥ «ኤ ኑ ኢታ Ꮉርግቶ ፋስ ኤክዳ፥ ኤ ኑ Ꮉርግቶ ቶክዳ» ጋይደ ቃልታ ፎልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","የሱሳ ጋማ አሱንꬅ ኤ ካለ ኤቅዳኖ ብእ፥ አባፓ ሰኮ ፍንꬃ ፊንጎደ ፋና ፋ ታማሩንꬃና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ህገ አስታማሩንꬃፓ ፈታይ፥ «አስታማርዛዮ፥ ነ Ꮉንግዘ በሳ ኡባነ ታ ካሎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","የሱሳ ኤጎ «ዎርካኑንꬅስ ኦላ የነ፥ ሳሎ ላንዱንꬅስ ኬꬂ የነ። የዝን አስ ናአይስ ፋ ኦምቶ ሸምፕዘ በሲ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","የሱሳ ካልዘ አሱንꬃፓ ፈታይ፥ «ላꬆ፥ ታኒ ቲኖ Ꮉንግ ታ አዳያ ሞጊ ዮኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","የዝን የሱሳ፥ «Ꮉይቂዱንꬅ ፋ Ꮉይቁንꬃና ሞጎ፤ ነ ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","የሱሳ የꬋደስ ጎንገ ገልደ ዎደ ኤ ታማሩንꬅን ኤራ ቅቶደስ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ኡን ቆፕካይዛራ የዝን፥ ዳማ ዙሉንተ Ꮉꬅትላ አፋ ደንድን ጎንግቶ ቆꬎደስ የልዳ። የዝን የሱሳ ገንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ኤ ታማሩንꬅ ኤጎ ሺቂ ኤዛ ባርክꬂ፥ «ላꬆ፥ ኑ ꬋባነ ኑና አሾያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","የሱሳ ኡንታጎ፥ «ይን፥ አማኖ ፋጨዙንꬆ፥ አኮስ ዣሽተተ?» ያጋይዳ። ደንዲ፥ ዙሉንቶን ዡብቶ ስእ ይዝዳ። ኤልስ ኡባ ባዝ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ኤ ታማሩንꬅ ጋማ ቆፒ፥ «Ꮉይ፥ መለ አቶ የዝን፥ ዙሉንተን ዡባን ኪትንትዘ ዋይደ አሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","የሱሳ አባፓ ሰኮ ፍንꬃ የዘ ገርገሶነ ጋዘ ሳአ የልደ ዎደ ቱና አያና አይክደ ላምእ አሱንꬅ ቦዛፓ ኬዚ ኤራ የልንትዳ። ኡን ጋማ ኢታን ዣሽዘ አስ ማቅደ ግሾ አስ ይና በስትራ አꬎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ኡንትን፥ «ጾዘ ናአዮ፥ ኔራ ኑና አኮ የልꬅዘ? ዎደ የልካያ የዝን ኑና ፍርዶደስ ይእዳ?» ጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ኡንታፓ ጋማ Ꮉክካይዛር ጉዳይለ ዉደ የንግንታነ። ");
INSERT INTO oyde_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ቱና አያኑንꬅ የሱሳ፥ «ነ ኑና ከሶደ ባዝ ማቅኮ፥ ሰኮ ጉዳይሉንꬅ ዉደ ግዳ ዳኮያ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","የሱሳ፥ «ቅቶተ» ያጋይዳ። ቱና አያና አሱንꬃፓ ኬዚ ጉዳይሉንꬃጎ ገልዳ። ጉዳይሉንꬅን ኡባ ጋጋ ዶናራ ዎጺ Ꮉንግ አባ ቆꬍንት Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ጉዳይለ ዉደ የንግዙንꬅን ዎጺ ካታማ Ꮉንግ፥ Ꮉንደ ባዝን ቱና አያና አይክደ አሱንꬃላ አፋ ኦችዳኖ ኡባ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ዬዝን፥ ካታማ የዘ አሱንꬅ ኡቡንꬅ የሱሳ ቦኦደስ ከዝዳ። ኡን የሱሳ ብእደ ዎደ ፋ ጋድትፓ ኬዚ ቅቶደ ፋና ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ይንፓ ሱባ፥ የሱሳ ጎንግተ ገሊ፥ አባ ፊንግ ፋ ካታማ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","እዘ ኤራꬅ አሱንꬅ ፈቲ ዎቦ አꬃ አልጋራ ቶኪ የሱሳጎ ክእዳ። የሱሳ ኡን አማንቶ ብእ፥ ዎቦ አꬃ፥ «ታ ናአዮ፥ ዣሽትፐ! ነ ናጋርታ አቶ ጋእንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ይና ሳተ፥ አይሁደ ህገ አስታማሩንꬃፓ ፈተ ፈተ፥ «Ꮉና ጾዝ ጫዠ ባነ» ያጋእ ፋ ዎዝንተ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","የሱሳ ኡን ቆፍቶ ኤሪ፥ «ኢታ ባዝ ይን ዎዝንተ አኮስ ቆፐተ? ");
INSERT INTO oyde_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","የዝን፥ ‹ነ ናጋርታ አቶ ጋእንትዳ› ጋዛንፓን ‹ደንዲ ኤቂ ቅቶ› ጋዛንፓ አየ ፎለ? ");
INSERT INTO oyde_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","የዝን ሳአላ አፋ ናጋራ አቶ ጋዉደስ አስ ናአስ አደትታ ዎልቃ የዛኖ ታ ይንታና ኤርሶዳ» ያጋእ፥ ዎቦ አꬄጎ፥ «ደንዲ፥ ነ አልግዛ ቶኪ፥ ካራ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ዎቦ አꬄ ደንዲ ፋ ካራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ዎርዥታ ይኖ ብእ ጋማ ቆፕዳ። ይኒ ፋና አደትꬅ ዎልቃ አስስ እንግደ ጾዛ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","የሱሳ የይጋፓ ደንዲ Ꮉንግተራ ማቶሳ ጋዘ ቃራጠ ጋችዘ በሳ በቲ የዝን ብእ፥ «ታና ካሎ» ያጋይዳ። ኤዝን ደንዲ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","የሱሳ ማቶሳ ካራ ለማተላ በቲ የዝን፥ ቃራጠ ጋችዘ ጋማ አሱንꬅን ናጋራንቹንꬅ ይእ ኤራን ኤ ታማሩንꬃራ ዎላ ሞኦደስ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ፈቲ ፈቲ ፋርሳዉንꬅ ይኖ ብእ፥ የሱሳ ታማሩንꬃራ፥ «ይን አስታማርዘ ቃራጠ ጋችዙንꬃራን ናጋራንቹንꬃራ አኮስ መኤ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","የሱሳ ይኖ ስእ፥ «ጋላ ኮሽዘ Ꮉርግንትዙንꬅስ ፋትን ፋጹንꬅስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","የዝን ይን Ꮉንግ፥ ‹ታኒ ይን ዣርሽቶ ባይዝን ይን መሉንꬃና ማሮደ ፋና ኮያነ› ጋእንት ጻፍንትዳና ዋግዛኮ ኤሮተ። አኮስ ጋይኮ፥ ታኒ ናጋራንቹንꬃና ጼጎደስ ይእዳፕ አትን ጽሉንꬃና ጼጎደስ ይእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","የ ዎደ ዋሐንሳ ታማሩንꬅ የሱሳጎ ሺቅን፥ «ኑንን ፋርሳዉንꬅን ጾማነ፥ የዝን ነ ታማሩንꬅ አኮስ ጾሞሶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","የሱሳ ማህ ኡንታጎ፥ «ሙሹራ ኡንታራ የዝን ጼግንት ይእደ አሱንꬅ አዛኖደስ ዳንዳአነ? ሙሹራ ኡን ካለፓ ኤክንቶደ ዎደ ዮኦዳ፥ ኡን የ ዎደ ጾሞዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«ክሌ ማኦፓ ፌꬍ ጋልአ ማኦላ ስክዘ ኦደን ባያ። ይኒ ፋና የይዝኮ ክልዘ ጋልእዛ ፌꬋነ። ፌዽꬅታን ዎዚ ዳልጋነ። ");
INSERT INTO oyde_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ክሌ ዎይነ ጋልአ ስልጰ ጉጅዘ ኦደን ባያ። ይኒ ፋና የይዝኮ ክሌ ዎይንዘ ጋልአ ስልጵዛ ꬉሳነ ዎይንዘን ላንታነ፤ ስልጵዘን ላምእንꬃ ማዶሰ ባዝ ማቃነ። የዝን ክለ ዎይነ ክሌ ስልጰ ጉጆደስ ቤዛነ። ይኒ ፋና የይዝኮ ላምኡንꬅን ኢትካይዛራ ናግንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","የሱሳ ይና ኦህትላ አፋ የዝን፥ አይሁደ Ꮉላቁንꬃፓ ፈታይ ኤጎ ይእ፥ ኤ ቲኖ ቡንቁንቲ፥ «ታ ናእታ Ꮉተ Ꮉይቂዳ፥ የዝን እዛ ፋጾደ ፋና ነ ይእ ነ ኩሽቶ ኢላ አፋ ጋዶዮ» ጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","የሱሳ ደንዲ ኤራ Ꮉንግዳ፤ ኤ ታማሩንꬅን ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ኤ Ꮉንግዝን ታጶ ላምእ በረ ኩሙꬅ ሱꬅ ጎጊ ዋይꬅዘ ፈቲ ማችታ ሱባራ ሺቂ የሱሳ ማእት ማጫርቶ ቦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","እዛ ፋ ዎዝንተ፥ «ታ ኤ ማእት ማጫርቶ ጻላላ ቦችዛኮ ፋጾዳ» ያጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","የሱሳ ሱብ ማቂ እዞ ብእ፥ «ታ ናእተ፥ ዣሽትፐ! ነና ነ አማንታ ፋꬅዳ» ያጋይዳ። አስታን ኢራ ፋጺ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","የሱሳ አይሁደ Ꮉላቅዘ ካራ የልደ ዎደ ዛየ ፉግዙንꬃናን ዬክዙንꬃና ብእ፥ ");
INSERT INTO oyde_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«አነ Ꮉልኦተ፤ ኤራꬅ ናእታ ገንትዳፕ አትን Ꮉይቂካያ» ያጋይዳ። የዝን አሱንꬅ ኤላ አፋ ሚጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","አሱንꬃና ባለ ከስዳንፓ ሱባ ኬꬃ ገሊ፥ ናእት ኩሽቶ አይክዳ፥ ናእታን ደንዲ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ይና ኦህታ ይና ሳእቶ ኡባ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","የሱሳ የይጋፓ ደንዲ ጎደ ቲኖ Ꮉንጎደራ ላምእ ቆቁንꬅ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ዳዉተ ናአዮ፥ ኑና ማሮያ» ያጋይትራ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","የሱሳ ኬꬃ ገልዘ ዎደ ቆቁንꬅ ኤዛ ካሊ የልዳ። የሱሳ ኡንታጎ፥ «ታኒ ይኖ ኦቾደስ ዳንዳእዛኖ ይን አማናነተ?» ያጋይዳ። ኡንትን፥ «ዬ፥ ላꬆ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ይንፓ ሱባ፥ የሱሳ ኡን ኣፍቶ ቦቺ ኡንታጎ፥ «ይንትስ፥ ይን አማንቲ ፋና Ꮉኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ኡን አፍታን ቡጉንትዳ። የሱሳ ኡንታጎ፥ «Ꮉኖ ኦደስን ኦህፐተ» ያጋእ ምንꬂ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","የዝን አሱንꬅ Ꮉንግ የሱሳ ባዝ ይና ሳእተ ኡባ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ኡን የይጋፓ ከዘ ዎደ አሱንꬅ ቱና አያና አይኪ ሙሙዝደ ፈቲ አስ የሱሳጎ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ቱና አያና ኬዝደፓ ሱባ ሙመ አꬄ ኦህንትዳ። አሱንꬅን ጋማ ቆፕዳ፥ «ይኒ ፋና ክለ ባዝ እስራኤለ ሳአ Ꮉንካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","የዝን ፋርሳዉንꬅ፥ «ቱና አያኑንꬅ Ꮉላቃራ ቱና አያኑንꬃና ከሳነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","የሱሳ አይሁደ ዎሳ ኬꬃ ታማርስተራ፥ ሳሎ ካእቱሞ ዎንገለ ሳባክተራ፥ አሱንꬃና Ꮉርገ ኡባፓ ፋꬅተራ ካታማን ካራ ጋንጨ ኡባነ ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ጋማ ዎርዥታ፥ የንግዘ አስ ባይዘ ዱሮ ፋና ኡንታና በእዘ አስ ꬋብን ኡን የዛኖ ብእ ኡንትስ ይቅስንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ፋ ታማሩንꬃጎ፥ «ሺቆደ ካꬅታ ጋማ፥ የዝን ካꬅቶ ሺሽዘ አሱንꬅ ኤራꬅ። ");
INSERT INTO oyde_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ይኒ ግሾ፥ ላꬂ ካꬃ ሺሾደ ኦቻንቹንꬃና ዳኮደ ፋና ዎሶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","የሱሳ ታጶ ላምእ ታማሩንꬃና ፋጎ ጼጊ፥ ቱና አያና ከሶደ ፋናን Ꮉርገ ኡባፓ ፋꬆደ ፋና ኡንትስ አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","የሱሳ ኪትደ ታጶ ላምእ ሐዋሩንꬅ ሱንꬅታ፤ ቲንዘ ጴጥሮሳ ጋዘ ስሞና ኤ እሸ እንድርያሰ፥ ዛብድዮሳ ናአ ያይቆባን ኤ እሸ ዋሐንሳን፥ ");
INSERT INTO oyde_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፍልጶሳን ባርቶሎምዮሳ፥ ቶማሳን ቃራጠ ጋችዘ ማቶሳ፥ እልፍዮሳ ናአ ያይቆባ፥ ታድዮሳ፥ ");
INSERT INTO oyde_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ፋ ጋድትስ ይቅስንትዘ ስሞናን የሱሳ አꬂ እንግደ የስቆሮቱ ይሁዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ይና ታጶ ላምኡንꬅ የሱሳ ኪቲ ዳክተራ፥ «አይሁደ ማቆሰ ዎርዣጎ Ꮉንግፐተ፥ ማህ ሳማራ አሱንꬅ ካታማን ገልፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","የዝን እስራኤለ ኬꬃፓ ማቅደ ሰካ ꬋብደ ዱሩንꬃጎ Ꮉንጎተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","እዘ Ꮉንግ፥ ‹ሳሎ ካእቱሞ ኡክዳ› ጋእ ኦሆተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ꮉርግንትዙንꬃና ፋꬆተ፥ Ꮉይቂዱንꬃና Ꮉይቆፓ ደንꬆተ፥ ቁርሱማ Ꮉርግንትዙንꬃና ጌሽ ፋꬆተ፥ ቱና አያና ከሶተ። ይን Ꮉሪ ኤክዳኖ Ꮉሪ እንጎተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ይን ኪስተ ዎርቃ፥ ዎይ ብራ ሳንትመ አይክፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ይን ኦገስ ካርጥተ፥ ላምእ ማኦ፥ ዎይ ጫማ ዎይ ጉፈ አይክፐተ፤ ኦችዙንꬅስ Ꮉይኖ ቁማ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«ይን ፈቲ ካታማ ዎይ ካራ ጋንጨ ገልዘ ዎደ ይንታና ሞኪ ኤኮደስ ኡፋይትዘ አስ ኮይ ኤ ካራ ገሎተ፤ ይን ቅቶደ ዎንꬅስ እዘ ጋምኦተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ማህ ኦደ ካራን ገልተራ ሳርꬆተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ይና ኬꬅታ ይንታና ሞክኮ ይን ሳርꬅደ ሳርታ ኡንታና የሎ፥ የዝን ኡን ሞካንጽኮ ይን ሳርꬅደ ሳርታ ይንትስ ሱብ ማቆ። ");
INSERT INTO oyde_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ኦደን ይንታና ሞካንጽኮ ይን ኦህዘ ባዝ ስአንጽኮ ይና ኬꬅትፋ ዎይ ይና ካታምትፓ ከዝተራ ይን ቶህተ የዘ ጹርቶ ፍጺ ከዞተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ታ ይንትስ ቱሮ ኦህነ፤ ጾዘ ፍርዳ ቃማ ይና ካታምትፓ ሶዶማስን ጋሞራ ካታምትስ ፍርዳ ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«ታ ይንታና ዱሮ ፋና ሱዹሙንꬅ ግዳ ዳኮዳ። ይኒ ግሾ፥ ሾሽ ፋና ጭንጫ፥ ዎለ ፋና አዳ ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","አሱንꬅ ይንታና ፍርድዘ ዳይኑንꬅስ አꬂ እንጎዳ፥ ማህ አይሁደ ዎሳ ኬꬃ ይንታና ጋራፎዳ። ይኒ ግሾ፥ ኡንታፓ ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ታ ግሾ ጋእ ይንታና ዎርዥቶ አህዙንꬅ ቲኖ ካቱንꬅ ቲኖ ካንጎዳ። ኡን ቲንተ አይሁደ ማቆሰ ዎርዡንꬅ ቲኖ ኤቂ ይን ታ ባዝ ማርክꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","የዝን ይንታና ፍርዳስ አꬂ እንግዘ ዎደ ዋጋእ ማሆደ ጋእ ኡንእንትፐተ፤ ይና ሳተ ይን ጋዉደ ባዝ ጾዚ ይንትስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","አኮስ ጋይኮ፥ ይንታና ኦህዘ ይን አዳይ ጌሽ አያናፓ አትን ይንታና ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«እሻይ ፋ እሻያ፥ አዳይ ፋ ናአያ፥ Ꮉይቆስ አꬂ እንጎዳ፥ ናኡንꬅ ፋና የልዱንꬃላ አፋ ደንዲ ኡንታና ዎꬍሳዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ታ ግሾ ጋእ አስ ኡቡንꬅ ይንታና እጾዳ፥ የዝን ዉርሱꬅ የሎደስ ሚንግደ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ፈቲ ካራ ጋንጨፓ ይንታና ኡን ባይእኮ መለ ካታማ በቶተ። ታኒ ይንትስ ቱሮ ኦህነ፤ አስ ናአይ ዮኦደ ዎንꬅስ፥ ይን እስራኤለ ካታማ ኡባ ካንꬃማ። ");
INSERT INTO oyde_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«ታማሩንꬅ ፋ አስታማርዘፓ፥ አርዘን ፋ ላꬄፓ አꬎስ። ");
INSERT INTO oyde_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ታማርዘ ፋ አስታማርዘ፥ አርዘ ፋ ላꬅዘ ፋና ዪኮ ኤስ ማቃዳ። ካርቲ አዳይ ብኤልዘቡላ ጋይኮ ኤ ካራ አሱንꬃና ዋይዝ ዎዚ ኢሲ ጼጎሶ? ");
INSERT INTO oyde_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«ይኬ፥ አስስ ዣሽትፐተ። ጌንግደ ባዝ ቆንጮዳ፥ አችንትደ ባዝ ጌሻ ከዝካይዛራ አቶስ። ");
INSERT INTO oyde_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ታኒ ይንትስ ꬉማ ኦህዘ ባዝ ይን ፎኦ ኦሆተ፤ ታ ይንትስ Ꮉየ ካልካሽደ ባዝ ዞዘላ አዋጆተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","አሾፕ አትን ሸምፖ ዎꬎደስ ዳንዳኦሱንꬅስ ዣሽትፐተ። የዝን ሸምፕቶን አሽቶን ጋናመ ꬋብሶደስ ዳንዳእዘ ጾዘስ ዣሽቶተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ላምእ ቡበ ላንዱንꬅ ፈቲ ሳንትመ ባይዝንቶሳነ? ይኦፕ አትን፥ ኡንታፓ ፈታይን ይን ጾዘ ጋይካይዝን ሳአ ዎꬎስ። ");
INSERT INTO oyde_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","መለ አቶ የዝን፥ ይን ኦማ እስንꬅታን ፋይድንቲ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ይኬ፥ ጋማ ቡበ ላንዱንꬃፓ ይን ኣꬍዘ ግሾ ዣሽትፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«አስ ቲኖ ታስ ማርክꬍዘ ኡቡንꬅስ ታንን ሳሎ የዘ ታ አዳይ ቲኖ ማርክꬋዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","የዝን አስ ቲኖ ታና ካድዛያ ታንን ሳሎ የዘ ታ አዳይ ቲኖ ካዶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«ታኒ ሳአላ ሎኦ ኮኦደስ ይእዳ ይንትስ አዝፐ። ታኒ ኦላፓ አትን ሳሮትꬅ ኮኦደስ ይእካያ። ");
INSERT INTO oyde_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ታኒ ይእዳና፥ «ናአያ አደፓ ማች ናእቶ እንትፓ ናአይ ማችቶ አዝንዘ እንትፓ ሻኮደስ። ");
INSERT INTO oyde_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","አስስ ሞርኩንꬅ ኤ ካራ አሱንꬃና ማቆዳ።» ");
INSERT INTO oyde_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«ታፓ አꬂ ፋ አዳያ ዎይ ፋ እንቶ ካዽዘ፥ ታ ባዝ ማቆደስ ቤዞስ። ፋ ꬊራꬅ ናአያ ዎይ ፋ ማች ናእቶ ታፓ አꬂ ካዽዘ፥ ታ ባዝ ማቆደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ፋ ማስቃላ ቶኪ ታና ካሎሰ ኦደን ታ ባዝ ማቆደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ፋ ሸምፕቶ አሾደስ ኮይዘ ꬋብሶዳ፥ የዝን ፋ ሸምፕቶ ታ ግሾ አꬂ እንግዘ አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«ይንታና ሞክዘ ታና ሞካነ፥ ታና ሞክዘ ማህ ታና ኪትዳያ ሞካነ። ");
INSERT INTO oyde_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ናበ ናበ ሱንꬅተ ሞክዘ፥ ናበ ፋና ዋጋ ኤኮዳ፤ ማህ ጽልዛ ጽሎ ሱንꬅተ ሞክዘ፥ ጽልዘ ፋና ዋጋ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ታ ይንትስ ቱሮ ኦህነ፤ Ꮉንꬅ ታ ታማሩንꬃፓ ኤርዘ ፈታይ ታና ካልዘ ግሾ መለ አቶ የዝን ኤራꬅ ቶያ Ꮉꬅ እንግኮ ኤ ዋግታ ꬋቦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","የሱሳ ታጶ ላምእ ታማሩንꬃና ኪቲ Ꮉስዳንፓ ሱባ እዝፓ ደንዲ ታማርሶደስን ሳባኮደስ ጋልላ ካታማ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ዋሐንሳ አች ኬꬃ የዛራ ክርስቶሳ ኦችቶ ስእ፥ ፋ ታማሩንꬃፓ ኤጎ ኪቲ፥ ");
INSERT INTO oyde_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«ዮኦዳ ጋእንትደ ነናነ? ዎይ ኑ መለ ካፎደ?» ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","የሱሳ ኡንታጎ ማህ፥ «Ꮉንግ ይን ስእደ ባዝን ይን ብእደባዝ ዋሐንሳስ ኦሆተ። ");
INSERT INTO oyde_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ቆቁንꬅ በእነ፥ ዎቡንꬅ የꬋነ፥ ቁርሱማ Ꮉርግንትዙንꬅ ጌዣነ፥ ቱሉንꬅ ስእነ፥ Ꮉይቂዱንꬅ Ꮉይቆፓ ደንዳነ፤ ዳሁንꬅስ ዎንገለ ሳባክንታነ። ");
INSERT INTO oyde_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ታራ ꬉቡንቶሰ አንጅንትዳያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ዋሐንሳ ታማሩንꬅ ሱብ ማቂ Ꮉንግን፥ የሱሳ ዎርዡንꬅስ ዋሐንሳ ባዝ ኦህተራ፥ «Ꮉና አኮ ባይዘ ጋናሳ አኮ በአደስ ይእዳተ? ባቆ ኤንእዘ ሾምቦቆ በአደስ ይእዳተ? ");
INSERT INTO oyde_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ዬዝን፥ አኮ በአደስ ይእዳተ? ቦንቾ ማኦ ማእደ አሱንꬃና በአደስነ? ቦንቾ ማኦ ማእዱንꬅ ካት ካራ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ዬዝን፥ አኮ በአደስ ኬዝዶተ? ናበ በአደስነ? ዬ፥ ይን ናበፓን አꬍዛያ በእነ። ");
INSERT INTO oyde_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","«ነ ኦግቶ ነ ቲንተ ጊግዘ ታ ኪታንችዛ ኔፓ ቲኖ ኪቶዳ» ጋእንት ጻፍንትዳና ኤስ። ");
INSERT INTO oyde_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ታ ይንትስ ቱሮ ኦህነ፤ ማችፓ የልንትዱንꬅ ግዳፓ ጻማቅዘ ዋሐንሳፓ ኣꬍዛ ኦንን ደንድካያ፤ የዝን ሳሎ ካእቱሞ ኡቡንꬃፓ ኤርዘ ኤ፥ ኤፓ አꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ጻማቅዘ ዋሐንሳ ዎደፓ ደንꬂ Ꮉይኖ የሎደስ ሳሎ ካእቱሞ ጋማ ኡርቂንታነ፥ ሚንግ ቡቱንትዙንꬅ ደንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ናቡንꬅ ኡቡንꬅ ህገን ዋሐንሳ ባዝ ትንቢተ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ይኬ፥ ይን ኡን ኪቶ አማኖደባዝ ማቅኮ፥ ዮኦዳ ጋእንትደ ኤልያሳ፥ ኤ ዋሐንሳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ይኬ፥ ስእዘ Ꮉየ የዘ ስኦ። ");
INSERT INTO oyde_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«ይኬ፥ ታኒ Ꮉና ዎደ የለቶ አኮራ አዝሳደ? ጋበ ግዳ በቲ ዎል ጼጊ፥ ");
INSERT INTO oyde_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","« ‹ኑ ይንትስ ሱሉንቀ ፉግን፤ ይን የጽካያ። ኑ ናሺ ጋይርን፤ ይን ዬክካያ› ያጋዘ ናኡንꬃና አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ጻማቅዘ ዋሐንሳ ሙእካይዛራን ኡዥካይዛራ ይእን፥ ‹ቱና አያና የነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","አስ ናአይ ሙእተራን ኡዥተራ ይእን፥ ‹ዥምባራን ኡሽ አስ፥ ቃራጠ ጋችዙንꬅስን ናጋራንቹንꬅ እግና› ያጋይዳ። ይኬ፥ ጭንጫትꬅን ቱረትꬅ ኤ ኦችተ ቆንጫነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ይንፓ ሱባ፥ የሱሳ ጋማ ክሌ ባዝ ኦችደ ካታሙንꬅ ግዳ የዘ አሱንꬅ ፋ ናጋርትፓ ማቂ ማሮትꬅ ገላንጽ እጽደ ግሾ ኡንታና፥ ");
INSERT INTO oyde_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«ባደ ክኦራዚነ ካታምተ፥ ባደ ቤተሳይዳ ካታምተ፥ አኮስ ጋይኮ፥ ይን ግዳ ኦችንትደ ክሌ ባዝ ጢሮሳ ግዳን ስዶና ግዳ ኦችንትደባዝ ማቅዛኮ፥ ኡን ዛጋ ቡዶ ትዥንት፥ ካዮ አፉላ ማእ ፋ ናጋርትፓ ማቂ አቶድ የሻ። ");
INSERT INTO oyde_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","የዝን ታ ይንትስ ኦህነ፤ ፍርዳ ቃማ ይንታፓ አꬂ ጢሮሳስን ስዶናስ ፍርድታ ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ማህ፥ ቅፍርናሆመ፥ ኔኒ ኡደ ሳሎ ከዞደስ ኮያነ? Ꮉኖስ! ነ ስኦለ ኦልንቶዳ። አኮስ ጋይኮ፥ ነ ግዳ ኦችንትደ ክሌ ባዝ ሶዶማ ኦችንትደባዝ ማቅዛኮ፥ ሶዶማ Ꮉይኖ የሎደስ የሳድ የሻ። ");
INSERT INTO oyde_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","የዝን ታ ኔስ ኦህነ፤ ፍርዳ ቃማ ኔፓ አꬂ ሶዶማስ ፍርዳ ኤሮዳ»። ");
INSERT INTO oyde_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","የ ዎደ የሱሳ፥ «አዳዮ፥ ሳሎ ሳአ ላꬆ፥ ነ Ꮉኖ ኤሩንꬃፓን ጭንጩንꬃፓ አቺ ናኡንꬅስ ቆንጭዝደ ግሾ ነና ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ዬ፥ ታ አዳዮ፥ Ꮉና ነ ሎኦ ቆፍት ፋና Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«ኡባና ታስ ታ አደፓ እንግንትዳ። አዳይፓ መለ ናአያ ኤርዘ ባያ፥ ናአይፓን ኤ ቆንጮደስ ኮየዙንꬃፓ መለ አዳያ ኤሮደስ ዳንዳእዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«ይን፥ ላቢዱንꬆ፥ ቶፎ ዴጽደ ኡቡንꬅ ታጎ Ꮉንካ ዮኦተ፤ ታ ይንታና ሸምፕሳዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ታኒ ታ ዎዝንተ ዳልጋን አዳ ማቅደ ግሾ ታ ቃምባርቶ ቶኮተ፥ ታፓ ታማሮተ፤ ይን፥ ይን ሸምፕትስ ሸምፖ ደንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ታ ቃምባርታ ስላ፥ ማህ ታ ቶፍታን ፎሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","የ ዎደ፥ ሳምባታ ቃማ፥ የሱሳ ጋደ ግዳራ ኣꬍዳ። የሱሳ ታማሩንꬅ ናይꬍደ ግሾ ትዣ ባንጋ ሽጭ ꬋአነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","የዝን ፋርሳዉንꬅ ይኖ ብእ የሱሳጎ፥ «Ꮉይቼ፥ ነ ታማሩንꬅ ሳምባታ ቃማ ኦቾደስ ቤዞሰ ባዝ ኦቻነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","የሱሳ ኡንታጎ ማህ፥ «ዳዉተ ናይꬍደ ዎደ ኤራ የዙንꬃራ አኮ ኦቼዛኮ ናባብካተ? ");
INSERT INTO oyde_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ዳዉተ ጾዘ ኬꬃ ገሊ ካህኑንꬅ ጻላላፕ አትን ኤስን ኤራ የዙንꬅስ ቤዞሰ ጌሽ ዳቦ ሙእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ዎይ ካህኑንꬅ ሳምባታ ዎጋ ሻሪ ጾዘ ኬꬃ ሳምባታ ቃማ ኦቻ ኦችኮ ኡንትስ ባላ ባይዛኖ ሙሴ ህገፓ ናባብካተ? ");
INSERT INTO oyde_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","የዝን ታ ኦህነ! ጾዘ ኬꬃፓ ኣꬍዘ Ꮉነ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹ታኒ ይን ዣርሽቶ ባይዝን ይን መሉንꬃና ማሮደ ፋና ኮይዳ› ጋዘ ቃልታ ዋግዛኮ ይን ኤረዛኮ ጌሽ አሱንꬃላ አፋ ፍርዳማ የሻ። ");
INSERT INTO oyde_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","አስ ናአይ ሳምባታ ላꬂ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","የሱሳ የይጋፓ ኬዚ አይሁደ ዎሳ ኬꬃ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","እዘ ኩሸ ዎቦ ፈቲ አስ የነ። የሱሳ ሞቶደስ ምክናተ ኮይዘ አሱንꬅ፥ «ሳምባታ ቃማ ፋꬆደስ ቤዛነነ ቤዞሶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ኤ ኡንታጎ፥ «ይን ግዳፓ ፈታይስ ዱሮ ሳምባታ ቃማ ጋጋ ቅትኮ፥ ጎቺ ከሶሰ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ዬዝን አስ ዱሮፓ ዋይዝ ጋማ አꬎሶ? ይኒ ግሾ፥ ሳምባታ ቃማ ኡባ ሎኦ ባዝ ኦቸ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ይንፓ ሱባ፥ የሱሳ አꬄጎ፥ «ነ ኩሽቶ ሉልዞ ያጋእን፥» አꬄ ሉልዝዳ። ኤ ኩሽዘ ፋጺ Ꮉንካይ ኩሸ ፋና ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","የዝን ፋርሳዉንꬅ የይጋፓ ባለ ኬዚ፥ የሱሳ ዋይዝ ዎꬎድ የዛኮ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","የሱሳ ኡን ቆፍቶ ኤሪ ይና በስቶ አሺ መለ በሳ ቅትዳ። ጋማ አሱንꬅ ኤዛ ካሊ ቅትዳ፥ Ꮉርጋንቹንꬃና ኡባ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","የሱሳ፥ «ታ ባዝ መለ ኦደስን ኦህፐተ» ያጋእ ምንꬂ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ይናን ናብዘ ኢሳያሳ፥ ");
INSERT INTO oyde_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ꮉይቼ ታ ዶርደ አርዘ፥ ታ ካዽዘ፥ ታና ኡፋይስዘ፥ ታኒ ታ አያና፥ ኤላ አፋ ጋዶዳ፤ ኤ፥ አይሁደ ማቆሰ ዎርዥትስ ፍርዳ አዋጆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ኤ ላሎስ ዎይ ኡኮስ፤ ኤ ቃልቶን ኦገ ጨር ስእዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ፍርዳ ጋሚ ደንዶደ ዎንꬅስ፥ ዶንጭንትደ ሾምቦቆ መንꬆስ፥ ጩግዘ ሾምቦቆ ፋና ꬋብሶስ። ");
INSERT INTO oyde_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ዎርዣ ኡባ ኤላ ኡፋይስ ጋዶዳ» ያጋእ ጻፍንትዳና ፎልንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ይንፓ ሱባ፥ ቱና አያናራ አይክንትደ ቆቀን ዶና ሙመ አስ የዛያ ኤጎ ክእዳ። የሱሳ አꬃ ፋꬅን፥ አꬄ በእነን ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","አሱንꬅ ኡቡንꬅ ጋማ ቆፒ፥ «Ꮉይ ዳዉተ ናአ ማቃዳ የሳነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","የዝን ፋርሳዉንꬅ ይኖ ስእ፥ «Ꮉይ አꬄ ቱና አያኑንꬃና ኬስዘ ቱና አያኑንꬅ Ꮉላቃ ብኤልዘቡላ ዎልቃራ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","የሱሳ ኡን ቆፍቶ ኤሪ፥ «ዎል ግዳ ሻክንትዘ ካእቱሞ ኡባ ጎልኦዳ፤ ማህ ዎል ግዳ ሻክንትዘ ካታምታ ዎይ ኬꬅታ ሚንግ ኤቆስ። ");
INSERT INTO oyde_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ጻላሄ ጻላሄ ኬስዘባዝ ማቅኮ ፋ ግዳ ሻክንታነ ጋእንተ። ይኒ ፋና Ꮉንዘባዝ ማቅኮ ኤ ካእቱምታ ዋይዝ ሚንግ ኤቆደስ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ታኒ ቱና አያና ኬስዘ ብኤልዘቡላ ዎልቃራ ማቅኮ ይንታና ካልዘ አሱንꬅ ኦደ ዎልቃራ ከሶደ? ይኒ ግሾ፥ ይንታና ካልዘ አሱንꬅ ይንታና ፍርዶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","የዝን ታኒ ቱና አያና ኬስዘ ጾዝ አያናራ ማቅኮ፥ ጾዘ ካእቱሞ ይንታጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«ዎይ ፈቲ አስ ዎልቃራ የዘ አꬄ ካራ ገሊ ኤ ቆልቶ ቦንቆደስ ኮይኮ ቲኒ የ አꬃ አጫንጽኮ ዋይዝ ቦንቆደስ ዳንዳኦደ? የይዝኮ ኤ ቆልቶ ቦንቆደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«ታራ ማቆሰ ኦደን ታና እጻነ፤ ማህ ታራ ፈትላ ሺሾሰ ኡባ ላላነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ይኒ ግሾ፥ ኦህነ፤ አሱንꬅ ኦችዘ አኮ ናጋራን ጫሽ ቃላ ኡባ አቶ ጋእንቶዳ፥ የዝን ጌሽ አያና ጫዥዘ ኦደስን ኤ ናጋርታ አቶ ጋእንታማ። ");
INSERT INTO oyde_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ኦደን አስ ናአላ አፋ ኢታ ባዝ ኦህኮ ኤስ አቶ ጋእንቶዳ፥ የዝን ጌሽ አያናላ አፋ ኢታ ባዝ ኦህዘ ኦደስን Ꮉነ ሳእተ ማቅኮን ዮኦደ አላምተ ኤ ናጋርታ አቶ ጋእንታማ። ");
INSERT INTO oyde_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«ሎኦ ምንጻ ሎኦ ኣፈ አፋነ፤ ማህ ኢታ ምንጻ ኢታ አፋነ። ይኬ፥ ምንጻ ኤርንትዘ ፋ ኣፍተ። ");
INSERT INTO oyde_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ይን፥ ሾሽ ናኡንꬆ፥ ይን ኢታ ማቅተራ ዋይዝ ሎኦ ባዝ ኦቾደስ ዳንዳኤ? አስ ፋ ዎዝና ኩምዳኖ ዶናራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ሎኦ አስ ፋ ዎዝንትፓ፥ ሎኦ ባዝ ከሳነ፤ ኢታ አስ ፋ ዎዝናፓ፥ ኢታ ባዝ ከሳነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","የዝን ስኦተ፥ አሱንꬅ ኦህንትዘ ጨር ኦሄ ኡባስ ፍርዳ ቃማ ማሄ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","አኮስ ጋይኮ፥ ነ ኦህዘ ነ ቃልተ ጽሎዳ፤ ነ ኦህዘ ነ ቃልተ ኔላ አፋ ፍርዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ይንፓ ሱባ፥ ፈቲ ፈቲ ፋርሳዉንꬅን ህገ አስታማሩንꬅ የሱሳጎ፥ «አስታማርዛዮ፥ ኔፓ ክሌ ባዝ በአደስ ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","የዝን የሱሳ ማህ፥ «አማንንቶሰን ኢታ የለቱንꬅ ክሌ ባዝ ኮያነ። የዝን ናበ ዮናሳ ክለ ባዛፓ መለ ክሌ ባዝ ኡንትስ እንግንቶስ። ");
INSERT INTO oyde_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዮናሳ ሞሎ ሳዛ Ꮉይꬕ አዋራን Ꮉይꬕ ቃማ ጋምእዳን ፋና አስ ናአ Ꮉይꬕ አዋራን Ꮉይꬕ ቃማ ሳአ ጋꬃ ጋምኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ነነዌ አሱንꬅ ፍርዳ ቃማ ደንዲ Ꮉና የለቱንꬃራ ዎላ ኡንታላ አፋ ፍርዶዳ፤ አኮስ ጋይኮ፥ ኡን ዮናሳ ስብከቶ ስእ ፋ ናጋርትፓ ማቅዳ። ይኬ፥ ዮናሳፓ ኣꬍዘ Ꮉነ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ፍርዳ ቃማ ዬካ ካትታ ደንዲ Ꮉና የለቱንꬃራ ዎላ ኡንታላ አፋ ፍርዶዳ፤ አኮስ ጋይኮ፥ እዛ ሶሎሞነ ጭንጫትꬅቶ ስኦደስ ሳአ ጋጻፓ ይእዳ። Ꮉይቼ፥ ሶሎሞናፓ ኣꬍዘ Ꮉነ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«ቱና አያና አꬄፓ ኬዝደፓ ሱባ ፋስ ሸምፕዘ በሲ ኮይ Ꮉꬅ ባይዘ በሳ Ꮉንታነ፥ የዝን ፋ ኮይዘ ሸምፖ ደንጎስ። ");
INSERT INTO oyde_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","የዝን፥ ‹ታ አሺ ከዝደ ኬꬅተ ማቂ Ꮉንጎዳ› ያጋነ። ኤ ማቅዘ ዎደ ኬꬅታ ካይስ ማቅዳኖን ፍጽንቲ ሎእ በትዳኖ ደንጋነ። ");
INSERT INTO oyde_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ይኬ፥ ማቂ Ꮉንግ፥ ፋፓ ኢታ መለ ላፑን ኢታ አያኑንꬃና ኤኪ የእነ፤ ኡንትን እዘ ገሊ የዛነ። የ አꬄስ ቲኖስትፓ ሱባና ጋማ ኢታነ። የ ኢታ የለቱንꬃላ አፋ ይኒ ፋና ይአዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","የሱሳ ዎርዥትስ ኦሄላ አፋ የዝን ኤ እንታን ኤ እሹንꬅ ኤዛ ኦህሳደስ ኮይ ባለ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ፈቲ አስ ኤጎ፥ «ነ እንታን ነ እሹንꬅን ነና ኦህሳደስ ኮይ ባለ ኤቅዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","የሱሳ ማህ፥ «ታ እንታ ኦደ? ታ እሹንꬅን ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ፋ ኩሽትራ ታማሩንꬃና ማልተራ፥ «ቦኦተ፥ ታ እንታን ታ እሹንꬅን Ꮉንሳና። ");
INSERT INTO oyde_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ሳሎ የዘ ታ አዳይ ቆፍቶ ኦችዘ ኡቡንꬅ ታስ እሸ፥ ታስ ምሾን ታስ እንዶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","የ ዎደ የሱሳ ካራፓ ኬዚ አባ ጋጻ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ጋማ አሱንꬅ ኤ ካለ ሺቅን አሱንꬃና አባ ጋጻ አሺ አሺ ጎንገ ገሊ በትዳ አሱንꬅን ኡባ አባ ጋጻ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","አሱንꬅስ ጋማ ባዝ አዝዘራ ያጋእ ኦህዳ: «ፈቲ ቡዱꬅ ቡድዘ ቡዱꬅ ቡዶደስ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ኤ ቡድዘ ዎደ ፈቲ ፈቲ ቡዱꬅታ ኦገ ጋጻላ ዎꬍዳ፤ ኡንታና ላንዱንꬅ ይእ ማጺ ሙይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ፈቲ ፈቲ ቡዱꬅታ ኦሞራ ላላ የዘ ሳአ ዎꬍዳ። ጋማ ሳአ ባይዘ ግሾ ኤልሲ ዶልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","የዝን አዋ ከዝን ሹልዳ፤ ጻጶ ባይዘ ግሾ መልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ፈቲ ፈቲ ቡዱꬅታ አንጋꬅ ግዳ ዎꬍዳ፤ አንጋꬅታ ድጪ ይና ዶልቶ ጩልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","መሉንꬅ ማህ አራዳ ሳአላ ዎꬍዳ፤ ዶሊ ኣፈ ኣፍዳ። ፈታይ ጼት፥ ፈታይ እዝፑንታም፥ ፈታይ ማህ Ꮉስታም ኣፍዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ስእዘ Ꮉየ የዘ ስኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","የሱሳ ታማሩንꬅ ኤጎ ሺቂ፥ «አኮስ ነ ዎርዥትስ አዝዘራ ኦሄ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ኤ ማህ፥ ይንትስ ሳሎ ካእቱሞ ጋꬅ ቆፋ ኤራ እንግንትዳ፥ የዝን ኡንትስ እንግንትካያ። ");
INSERT INTO oyde_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","የዘ ኡቡንꬅስ ጉጁንቶዳ፥ ኤስ ጋማዳ፥ የዝን ባይዘፓ መለ አቶ የዝን ኤስ የዛይን ኤክንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ይኒ ግሾ፥ ታኒ ኡን፥ ብእተራ ደንጋመ ፋና፥ ስእተራ ስአመ ፋና ዎይ ቆፓመ ፋና ኡንትስ አዝዘራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ኢሳያሳ ፋ ማጻፍተ ኦህዳና ኡንታላ አፋ ፎልንትዳ። ኤ ኦህተራ፥ «ይን ስስ ስእነ፥ የዝን ቆፖስ፤ ይን በእነ፥ የዝን ቦኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","አኮስ ጋይኮ፥ Ꮉንꬅ አሱንꬅ ዎዝንታ ሙምዳ፤ ፋ Ꮉይቶ ዶዥዝዳ፥ ፋ ኣፍቶ ጎዝዳ። ይንፓ ደንዲ ፋ ኣፍትራ ቦኦስ፥ ፋ Ꮉይትራን ስኦስ፥ ፋ ዎዝንተን ቲሮስ፥ ታጎ ማቃደስ ዳንዳኦስ፥ ታንን ኡንታና ፋꬆስ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«የዝን ይን ኣፍታ በእዘ ግሾን ይን Ꮉይታ ስእዘ ግሾ አንጅንትዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ታ ይንትስ ቱሮ ኦህነ፤ ጋማ ናቡንꬅን ጽሎ አሱንꬅ ይን በእዛኖ በአደስ ይን ስእዛኖ ስኦደስ አሙꬍዳ፥ የዝን ኡንትስ Ꮉንካያ። ");
INSERT INTO oyde_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«ይኬ፥ Ꮉይ ቡዱꬅቶ ቡድዘ አꬄ አዝዝቶ ስኦተ። ");
INSERT INTO oyde_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ኦገ ጋጻ ዎꬍደ ቡዱꬅት አዝዝታ Ꮉኖ፤ ሳሎ ካእቱሞ ቃላ ስእ ቲሮሰ አꬄ ዎዝንትፓ ጻላሄ ይእ ኤ ዎዝንተ የዘ ቡዱꬅቶ ማጺ Ꮉሳነ። ");
INSERT INTO oyde_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ላላ ኦሞ የዘ ሳአላ ቡድንትደ ቃላ ስእ ኤልሲ ኡፋይት ኤክዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","የዝን ጻጶ ዳኮደስ ዳንዳኦሰ ግሾ ጋምኦስ። ቃላ ግሾ ማꬋ ዎይ ባይꬅ የእዘ ዎደ ኤልሲ ꬉብንታነ። ");
INSERT INTO oyde_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","አንጋꬅ ግዳ ቡድንትደ ቃላ ስእነ፥ የዝን Ꮉና አላመ የስ ይርጋፓን ዱርቱሞ ቆፋፓ ቃልቶ ጩልደ ግሾ ኣፈ አፋንጺ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","የዝን አራዳ ሳአ ቡዱንንትደ ቡዱ ቆፋራ ቃልቶ ስእዘ አስ። ኤ ኣፈ አፋነ፤ ፈታይ ጼት፥ ፈታይ እዝፑንታም ፈታይ ማህ Ꮉስታም አፋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","የሱሳ ኡንትስ መለ አዝዘ ኦህዳ፥ «ጾዘ ካእቱሞ ፋ ጋድተ ሎኦ ቡዱꬅ ቡድደ አꬃ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","የዝን አስ ኡባ ገንትን ኤ ሞርክዘ ይእ ዛርግት ግዳ ዛርዶ ቡድ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ዛርግታ ድጪ አፎደራ ዛርድዘን የ ዎደ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«ጋድቲ አዳይ አሩንꬂ አደጎ Ꮉንግ፥ ‹ላꬆ፥ ነ ጋድተ ነ ሎኦ ቡዱꬅ ቡድካ? ዬዝን፥ ዛርዶ አናፓ ይእዶ? ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«ኤ ኡንታጎ፥ ‹ይኖ ሞርከ ኦችዳ› ያጋይዳ። «አሩንꬂ ላꬄጎ፥ ‹ኑ Ꮉንግ ዛርድቶ ሾዶደ ጋር ኮያነ?› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«የዝን ኤ፥ ‹አቶ ቦችፐ፤ ይን ዛርድቶ ሾዳነ ጋዉደራ ዛርግታ ሾድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ቦችፐተ፤ ማጽዘ ዎደ የሎደስ ዎላ ድጮ። የ ዎደ ማጽዙንꬅ ዛርድቶ ቲኒ ሾዲ ታማር ኤꬆደስ ምርቀራ ምርቀራ ጋዶተ። የዝን ዛርግቶ ሺሺ ታ ፋችተ ገልꬆተ› ጋውዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ማህ መለ አዝዘ ያጋእ ኦህዳ፤ «ሳሎ ካእቱሞ ፈቲ አስ ፋ ጋድተ ቡድደ ኤራꬅ ምንጻ ኣፈ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ይና ኣፍታ መለ ምንጻ ኣፈ ኡባፓ ኤራꬅ፥ የዝን ዶልታ ድጪ መለ ምንጻ ኡባፓ አꬊ ዳማነ። እ ዣንግትላ ላንዱንꬅ ኬጺ በቶደ ዎንꬅስ ዳማ ምንጻ ማቃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ማህን፥ የሱሳ መለ አዝዘ ኦህዳ፤ «ሳሎ ካእቱሞ ፈቲ ማችታ Ꮉይꬕ ጋባተ ꬊላ ኤኪ ሙኑቅደ፥ ሙኑቅታ ደንዶደ ፋና እዘ ጉጅደ እርሾ አዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","የሱሳ ዎርዥትስ ይና አዝዝቶ ኡባ ኦህዳ። አዝዘ ባይዝን ፈቲ ባዝን ኦህካያ። ");
INSERT INTO oyde_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ናብዘ ፋ ማጻፍተ፥ «ታኒ ታ ዶና፥ አዝዘራ ቡጋነ፤ ሳሎን ሳአን መꬍንትዳንፓ፥ አችንትዳኖ ኦህነ» ያጋእ ኦህዳና Ꮉነ ፎልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","የሱሳ ዎርዥቶ ሞይዚ ኬꬃ ገልዳ። ኤ ታማሩንꬅ ኤጎ ሺቂ፥ «ጋደ የዘ ዛርዶ ብልꬅቶ ኑስ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ኤ ማህ፥ «ሎኦ ቡዱꬅቶ ቡድደ አስ ናአ። ");
INSERT INTO oyde_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ጋድታ Ꮉና አላምቶ። ሎኦ ቡዱꬅታ ሳሎ ካእቱሞ ናኡንꬃና። ዛርድዘ ጻላሄ ናኡንꬃና። ");
INSERT INTO oyde_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ዛርድዛ ቡድደ ሞርከ ጻላሄ። ማጽዘ ዎድታ፥ ዎደ ዉርሱꬅተ። ማጽዙንꬅ ኪታንቹንꬃና። ");
INSERT INTO oyde_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«ዛርዶ ማጺ ታማ ኤꬅዛን ጋር ዎደ ዉርሱꬅተ ይኒ ጋር ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","አስ ናአይ ፋ ኪታንቹንꬃና ኪቶዳ። ኡን ናጋራስ ምክናተ ማቅዱንꬃና ኢታ ኦችዘ ኡባ ማጺ ኤ ካእቱምትፓ ከሶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ዬፎን አች ጋርጭንገ ኣꬊ ኤጽዘ ታማ ኦሎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","የ ዎደ ጌሹንꬅ ፋ አዳይ ካእቱምተ አዋ ጋር ፎኦዳ። ስእዘ Ꮉየ የዘ ስኦ! ");
INSERT INTO oyde_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«ሳሎ ካእቱሞ ጋደ ሞጉንትደ ሚሸ ፋና። ፈቲ አስ ይና ሚሽቶ ደንግ ማህ ሞግዳ። ጋማ ኡፋይት Ꮉንግ ፋስ የዘ ባዝ ኡባ ባይዝ ይና ኦቻ ጋድቶ ዎንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«ይኒ ጋራ፥ ማህ ሳሎ ካእቱሞ እንቆ ጋዘ አልኦ ሹች ኮይዘ ዛልአንቾ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ጋማ አልኦ እንቅዛ ደንግ Ꮉንግ ፋስ የዘ ባዝ ኡባ ባይዝ ኤዛ ዎንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«ማህ ሳሎ ካእቱሞ አባ ኦልንትደ ዱማ ዱማ ሞሎ አይክዘ ግተ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ሞሎ አይክዘ አሱንꬅ ሞሎ ግትተ ኩምን አባፓ ጋጻ ከስዳ። እዘ በቲ ሎእቶ ቁሪ ቁሪ ዳቾ ኦልዳ፥ የዝን ኢቶ አላ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ዎደ ዉርሱꬅተ ይኒ ፋና Ꮉኖዳ። ኪታንቹንꬅ ይእ ናጋራንቹንꬃና ጽሉንሳፓ ሻኪ፥ ");
INSERT INTO oyde_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ዬፎ አች ጋርጭንገን አꬊ ኤጽዘ ታማ ኦሎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«Ꮉና ኡባና ይንትስ ገልዳ?» ያጋእ ኡንታና ኦጭዳ። ኡን ማህ፥ «ዬ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","የሱሳ፥ «ይኬ፥ ሳሎ ካእቱሞ ካልዘን ህገ ታማረ ኡባ፥ ፋ ምንጅደ ቆሎፓ ክለን ጋልአ ኬስዘ አስ አዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","የሱሳ ይና አዝዝቶ ኦህ Ꮉስዳንፓ ሱባ የይጋፓ ደንዲ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ፋ የልንትደ ሳአ Ꮉንግ አይሁደ ዎሳ ኬꬃ ዎርዥቶ ታማርስዳ። ኡን ጋማ ቆፒ፥ «Ꮉይ አꬄ Ꮉና ጭንጫትꬅቶን ዎልቃ ኩምደ ክለ ባዝቶ አናፓ ኤክዶ? ");
INSERT INTO oyde_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ꮉይ አናጽዘ ናአ ባነ? ኤ እንቲ ሱንꬅታ ማይራሞ ባነ? ኤ እሹንꬅ ያይቆባ፥ ዮሰፋ፥ ስሞናን ይሁዳ ባነ? ");
INSERT INTO oyde_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ኤ ምሹንꬅ ኑራ የዙንꬃና ባነ? ዬዝን፥ Ꮉይ አꬄ Ꮉኖ ኡባኖ አናፓ ኤክዶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ይኒ ግሾ፥ ኤ ጋዘ ባዝቶ ኤካንጽ እጽዳ። የዝን የሱሳ፥ «ናበ ፋ የልንትደ ሳአን ፋ ካራ አሱንꬅ ካለ ቦንችንቶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ኡን አማናንጽደ ግሾ ጋማ ክሌ ባዝ ይና በስተ ኦችካያ። ");
INSERT INTO oyde_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","የ ዎደ አህዘ ሄሮድሳ የሱሳ ባዝ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ፋ አሩንꬃጎ፥ «ይኬ ጻማቅዘ ዋሐንሳ፤ ኤ Ꮉይቆፓ ደንድዳ። ይኒ ግሾ Ꮉኖ ኡባ ክለ ባዝቶ ኤ ኦቻነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ኤ ይኖ ጋይዳና ሄሮድሳ ፋ እሸ ፍልጶሳ ማችት ሄሮድያዳ ምክናተራ ዋሐንሳ አች ኬꬃ ገልꬅደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ዋሐንሳ ሄሮድሳጎ፥ «ነ እዞ ኤኮደስ ቤዞስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ሄሮድሳ ዋሐንሳ ዎꬎደስ ኮይዳ፥ የዝን ዎርዥታ ዋሐንሳ ናበ ማህ በእዘ ግሾ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ሄሮድሳ ፋ የልንትደ ቃምቶ ቦንችዘ ዎደ ሄሮድያዳ ናእታ አሱንꬅ ቲኖ የጽተራ ዶሊ ኤዛ ኡፋይስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ዬዝን፥ ኤ፥ «እዛ ኮይዘ ባዝ ኡባ እንጎዳ ጋእ» ጫቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ናእታ ፋ እንቲ ዞረ ስእ ሄሮድሳጎ፥ «ጻማቅዘ ዋሐንሳ ኦምቶ ጋባተ ጋዲ ታስ እንጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","እዛ ያጋእን ካትዘ ቆፒ አዛንዳ፥ የዝን ፋ ጫቅት ግሾን ፋራ የዘ ዛቁንꬅ ግሾ ጋእ እዛ ኦጭዳኖ ፎሎደ ፋና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ካትዘ አስ ኪቲ ዋሐንሳ አች ኬꬃ የዝን ኤ አፉርቶ ጋችዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ኦምቶ ጋባተ ጋዲ ክእ ናእትስ እንግዳ፤ ናእታን ኤኪ ፋ እንትስ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ዋሐንሳ ታማሩንꬅ ይእ ኤ አህቶ ካንግ ሞግዳ። ይንፓ ሱባ Ꮉንደ ባዝ ኡባ Ꮉንግ የሱሳስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","የሱሳ Ꮉንደ ባዝቶ ስእደ ዎደ ጎንገ ገሊ ይና በስትፓ ፈቲ ጌማ በሳ ፋስ ቅትዳ። አሱንꬅ ይኖ ስእ ካታማፓ ደንዲ ቶሄራ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","የሱሳ ጎንገፓ ዎꬊ ጋማ አሱንꬃና ብእ ኡንትስ ይቅስንትዳ። ኡን ግዳ የዘ Ꮉርግንትዙንꬃና ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ሳእታ ኡጉሮደራ የሱሳ ታማሩንꬅ ኤጎ ሺቂ፥ «Ꮉና በስታ አኮ ባይዘ ጋናስ በሲ፥ ሳእታን ቃምዳ። ይኒ ግሾ፥ ካለ የዘ ካራ ጋንጨ Ꮉንግ ፋስ ካꬃ ዎንጎደ ፋና አሱንꬃና ዳኮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","የዝን የሱሳ ኡንታጎ፥ «አሱንꬅ ቅቶደስ ቤዞስ፤ ኡን ሞኦደባዝ ይን እንጎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ኡን ማህ፥ «ኑራ Ꮉነ እችን ቦራፓን ላምእ ሞሎፓ መለ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ኤዝን፥ «አነ የዛኖ Ꮉንካ ኮኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ማህ፥ ዎርዥቶ ማታላ በቶደ ፋና ኦህዳ። እችን ቦርቶን ላምእ ሞልቶ ኤኪ፥ ሳሎ ብእ ጋላቲ ማቂ፥ ቦርትፓ ባጽ ፋ ታማሩንꬅስ እንግዳ፤ ኡን ማህ አሱንꬅስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ኡቡንꬅ ሙእ ምዥዳ። ኡንትን ሙእን አትደ ታጶ ላምእ ሌማተ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ካꬅቶ ሙይደ አሱንꬅ ማቹንꬅን ናኡንꬅን አትን እችን ሙኩል ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ኤልሲ የሱሳ ታማሩንꬅ ጎንገ ገሊ ፋፓ ቲኒ አባፓ ሰኮ ፍንꬅ ፊንጎደ ፋና ኪቲ ፋስ አሱንꬃና ሞይዞደስ ሱብ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","አሱንꬃና ሞይዚ ማቂ ፋስ ዎሶደስ ፈቲ ደረላ አፋ ከዝዳ። ሳእታ ቃምን ኤ ፋስ የይጋ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","የ ዎደ ጎንግዘ አባላ ሳአፓ ኤራꬅ ክሎ ምትረ Ꮉንግዝን ቲኖ ዛላራ ጎተ ደንዲ ዙሉንታ ጎንግዛ ኡንእꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ዎንትማላ የሱሳ አባላ የꬍተራ ፋ ታማሩንꬃጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ኤ ታማሩንꬅ፥ ኤ አባላ የꬍተራ ኡንታጎ ይእዛኖ ብእ ዣሽትዳ። ኡንትን፥ «Ꮉይ ሜሸ» ጋእ ዣሽቲ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","የዝን የሱሳ ኤልሲ፥ «አኮን ባያ! ዣሽትፐተ! ታና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ጴጥሮሳ ኤጎ፥ «ላꬆ፥ ነና ማቅኮ፥ ታኒ Ꮉꬅትላ አፋ የꬊ ኔጎ Ꮉንጎደ ፋና ታና ኪቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","የሱሳ ጴጥሮሳጎ፥ «Ꮉንካ ዮኦ» ያጋይዳ። ጴጥሮሳን ጎንግዘፓ ዎꬊ Ꮉꬅትላ አፋ የꬍተራ የሱሳጎ Ꮉንገ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","የዝን ዎልቃማ ጎተ ብእ ዣሽትዳ። Ꮉꬅታን ቆ አይክደ ዎደ «ላꬆ፥ ታና አሾያ» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","የሱሳ ኤልሲ ፋ ኩሽቶ ዳኪ ኤዛ አይኪ፥ «ናተ፥ አማኖ ፋጭዳዮ አኮስ ሶኤ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","የሱሳራን ጴጥሮሳራ ጎንገ ገልደ ዎደ ጎቱታ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ጎንግተ የዘ ኤ ታማሩንꬅ፥ «ነ ቱሪ ጾዝ ናአ» ጋእ ጎይንዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ኡን አባ ፊንግ ጌንሳሬጠ ጋደ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ይና ጋድተ የዘ አሱንꬅ የሱሳ ኤርደ ዎደ ፋ ካራ ጋንጨ የዘ ጉቱተ ኡባነ ኪታ ዳክዳ። አሱንꬅ Ꮉርግንትዙንꬃና ኡባ ኤጎ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ꮉርግንትዙንꬅ ኤ አፉላ ጋጽቶ ጻላላ ቦቾደ ፋና ዎስዳ። ቦችደ ኡቡንꬅ ፋጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ይንፓ ሱባ፥ ፈቲ ፈቲ ፋርሳዉንꬅን ህገ አስታማሩንꬅ የሩሳላመፓ የሱሳጎ ይእ፥ ");
INSERT INTO oyde_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ነ ታማሩንꬅ አኮስ ኑ አዱንꬅ ዎግቶ መን? ኡን ካꬃ ማአደፓ ቲኖ ፋ ኩሽቶ ሜጭንቶስ» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","የሱሳ ማህ፥ «ይን፥ ይን ዎጋ ግሾ ጾዘ ኪታ ፎልዛኖ አኮስ እጸ? ");
INSERT INTO oyde_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","አኮስ ጋይኮ፥ ጾዚ፥ ‹ነ አዳያን ነ እንቶ ቦንቾ። ኤ ፋ አዳያ ዎይ ፋ እንቶ ጫዥዘ Ꮉይቆ ጋይካ?› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","የዝን ይን፥ ፈቲ አስ ፋ አዳያ ዎይ ፋ እንቶ ማዶደባዝ የዝን፥ ‹ይን ታፓ ደንግዘ ማድቶ ጾዘስ ዣርሽዳ ጋይኮ፥ ");
INSERT INTO oyde_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ፋ አዳያ ዎይ እንቶ ቦንቾደስ ቤዞስ› ያጋነ። የዝን ይን፥ ይን ዎጋ ፎሎደስ ጾዘ ቃላ መንꬃነ። ");
INSERT INTO oyde_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ይን፥ ጩቡንꬆ፥ ኢሳያሳ ይን ባዝ ልከ ኦህዳ፥ ");
INSERT INTO oyde_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«‹Ꮉንꬅ አሱንꬅ ታና ፋ ዶንተ ቦንቻነ፥ የዝን ኡን ዎዙንታ ታፓ Ꮉኮ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","አሱንꬅ ታና ጨር ጎይናነ፤ ኡን አስ መꬍደ ዎጋ ጾዘ ህገ አዝዝ ታማርሳነ› ጋይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","የሱሳ ጋማ አሱንꬃና ፋጎ ጼጊ፥ «ስኦተ! ቆፖተ! ");
INSERT INTO oyde_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","አስ ቱንዘ ባዝ ዶናራ ገልዘባዝ ባይዝን ዶናፓ ከዘ ባዝ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ይንፓ ሱባ፥ የሱሳ ታማሩንꬅ ኤጎ ይእ፥ «ፋርሳዉንꬅ ነ ጋይዳኖ ስእ ꬉቡንትዳኖ ኤራነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","የዝን የሱሳ ኡንትስ ማህ፥ «ሳሎ የዘ ታ አዳይ ቱክካይዘ ምንጻ ኡባ ሾድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ኡንባዝ አሺ አሾተ፤ ኡን ቆቀ ካልስዘ ቆቁንꬃና። ቆቀ ቆቀ ካልꬅኮ፥ ላምኡንꬅን ጋጋ ቅታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጴጥሮሳ ማህ፥ «ይና አዝዘ ብልꬅቶ ኑስ ኦሆያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","የሱሳ ኡንታጎ፥ «ይንትስን Ꮉኖ የሎደስ ገልካነ? ");
INSERT INTO oyde_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ዶናራ ገልደባዝ ኡባ ሳዛ ገሊ ባለ ኬዝዛኖ ኤሮስተ? ");
INSERT INTO oyde_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","የዝን ዶናራ ከዘ ባዝ ዎዝናፓ ከዛነ። አስ ቱንዘ ባዝ የንሳና። ");
INSERT INTO oyde_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ኡንትን አስ ዎዝና ግዳፓ ከዝዘ ኢታ ቆፋ፥ ዎ፥ ኦላለ፥ ጎመ ዎይኤ፥ ካይዞ፥ ዎርዶ ማርክ፥ ጫሽ። ");
INSERT INTO oyde_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","የንሳና አዝዘ ባዝታ አስ ቱንዛነፕ አትን ሜጭንትካይዘ ኩሸራ ሙዛና ቱንዞስ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ይንፓ ሱባ፥ የሱሳ የይጋፓ ኬዚ ጢሮሳን ስዶና ካታማ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ፈቲ ካናነ ሳአ ማችታ የሱሳጎ ይእ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ላꬆ፥ ዳዉተ ናአዮ፥ ታስ ይቅስንቶያ፤ ታ ናቶ ቱና አያና አይኪ ኢታ ዋይꬃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","የዝን የሱሳ ፈቲ ቃላ ማህካያ ስእ ጋይዳ። የሱሳ ታማሩንꬅ ኤጎ ይእ፥ «Ꮉና ማችታ ኑ ሱብቶ ካሊ ዉይሳነ። ይኒ ግሾ፥ ነ እዞ ሞይዞያ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","የሱሳ ማህ፥ «ታኒ ዉደፓ ꬋብደ ዱሩንꬃና እስራኤለ ኬꬃፓ ꬋብደ አሱንꬅ ጻላላስ ኪትንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","የዝን እዛ፥ ኤ ቲንተ ቡንቁንቲ፥ «ላꬆ፥ ታና ማዶያ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ኤ ማህ፥ «ናኡንꬅ ካꬃ ኤኪ ካኑንꬅስ ኦልዛና ሎኦ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ማችታን፥ «ላꬆ፥ ይና ቱሮ፥ የዝን መለ አቶ የዝን ካኑንꬅ ፋ ላꬁንꬅ ሙዝን፥ ሌማትፓ ዎꬍዘ ጉፋ ሙነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","የሱሳ ማህ፥ «Ꮉና ማችተ፥ ነ አማንታ ዳማ፤ ነ ኮይዳን ፋና ኔስ Ꮉኖ» ያጋይዳ። እ ናታ ኢራ ፋጺ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","የሱሳ ይንፓ ደንዲ ጋልላ አባ ካለ Ꮉንግዳ። ፈቲ ደረላ አፋ ኬዚ፥ እዘ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ጋማ አሱንꬅ፥ ዎቡንꬃና፥ ቆቁንꬃና፥ ኩንዱንꬃና፥ ዶና ሙሙንꬃና፥ መለ ጋማ Ꮉርጋንቹንꬃና ኤኪ፥ ኤጎ ክእ ኤ ቲንተ ጋድዳ። የሱሳ ኡንታና ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ይኒ ግሾ፥ ሙሙንꬅ ኦህንትዝን፥ ጉንዱንꬅ ሉለዝን፥ ዎቡንꬅ የꬍዝን፥ ቆቁንꬅ በእዝን አሱንꬅ ብእ ጋማ ቆፕዳ፥ እስራኤለ ጾዛ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","የሱሳ ፋ ታማሩንꬃና ፋጎ ጼጊ፥ «Ꮉንꬅ ጋማ አሱንꬅ ታራ Ꮉይꬕ ቃማ ጋምእደ ግሾን ኡንትስ Ꮉተ ሙእዘ ባዝ ባይዘ ግሾ ታኒ ኡንትስ ይቅስንታነ። ኡን ኦገ ላቢ ጎልአመ ፋና አኮ ሙዝካይዛራ ኡንታና Ꮉሪ ዳኮደስ ኮዮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ኤ ታማሩንꬅ ማህ፥ «ኑኒ Ꮉና አኮ ባይዘ ሳአ Ꮉኒ ፋና የዘ አሱንꬅስ ማቃደ ካꬃ አናፓ ደንጎደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","የሱሳ ኡንታጎ፥ «ይንትስ ዋንꬅ ቦራ የዘ?» ያጋእ ኦጭዳ። ኡን ማህ፥ «ላፑን ቦራን ይሻ ኤራꬅ ሞሎ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","የሱሳ አሱንꬃና ሳአላ በቶደ ፋና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ይንፓ ሱባ፥ ይና ላፑን ቦርቶን ሞሉንꬃና ኤኪ ጾዝ ጋላትዳ። ባጽ ፋ ታማሩንꬅስ እንግዳ። ኤ ታማሩንꬅ አሱንꬅስ ግሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","አሱንꬅን ኡባ ሙእ ምዥዳ። ኡንትን፥ ሙእን አትደ ጉፋ ላፑን ሌማተ ኩሙꬅ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ሙይደ አሱንꬅ ማቹንꬅን ናኡንꬅን ፋይድንትካይዝን ꬊራꬅ ጻላላ ኦይዲ ሙኩል። ");
INSERT INTO oyde_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","የሱሳ አሱንꬃና ዳክደፓ ሱባ ጎንገ ገሊ ማገዶና ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፋርሳዉንꬅን ሳዱቃዉንꬅ የሱሳጎ ይእዳ። ኤዛ ፋታኖደስ ኮይ፥ ፋና ሳሎፓ ማላ ቤዞ ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","የዝን ኤ ኡንታጎ፥ «ሳአ ኡጉርዘ ዎደ ‹ሳሎ ዞቂደ ግሾ ዎንታ አዎዳ› ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ዎንትዘ ዎደ፥ ‹ሳሎ ዞቂ ꬎንꬍደ ግሾ እራ ቡኮዳ› ያጋነ። ዬዝን ይን ሳሎ ማላ ብእ ኤራነ፥ የዝን ዎደ ማላ ኤሮደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ኢታን አማንንቶሰ የለቱንꬅ ማላ ኮያነ። የዝን ኡንትስ ዮናሳ ማላፓ መለ ማላ እንግንቶስ» ያጋይዳ። ይንፓ ሱባ፥ ኡንታና እዘ አሺ መለ በሳ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ኡን አባፕ ጎደ ፍንꬃ ፊንግደ ዎደ ዳቦ ኤኪ ዮኦዳኖ ቦትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","የሱሳ ኡንታጎ፥ «ፋርሳዉንꬃፓን ሳዱቃዉንꬅ እርሾፓ ናግንቶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ኡንትን ፋ ግዳ፥ «ኤ ይኖ ጋይዳና ኑ ዳቦ ኤኪ ይእካይዘ ግሾ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","የሱሳ ኡን ቆፍቶ ኤሪ፥ «ይን፥ አማኖ ፋጨዙንꬆ! ዳቦ ኤካንጽ ይእደ ግሾ ዎል ግዳ አኮስ ኦህንተ? ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ꮉተን ይን ቲሮስተ? እችን ሙኩል አሱንꬅ እችን በሸ ቦራ ግሽዳኖን ኡን ሙእ ምዥን ይን ዋንꬅ ሌማተ ኩሙꬅ ደንዛኮ ቦትዳተ? ");
INSERT INTO oyde_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ይኒ ጋራን፥ ላፑን ቦራ ኦይዲ ሙኩል አሱንꬅስ ግሽዳኖ ኡን ሙእ ምዥን፥ ይን ዋንꬅ ሌማተ ኩሙꬅ ደንዛኮ ቲሮስተ? ");
INSERT INTO oyde_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ይኬ፥ ታኒ ፋርሳዉንꬅን ሳዱቃዉንꬅ እርሾፓ ናግንቶተ ጋእ ኦህዛና ዳቦ ባዝ ማቆሳኖ ቲሮስተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ዬዝን፥ ኤ ታማሩንꬅ የሱሳ ኦህዘ ቡካ ደንꬆደስ ኦልንትዘ እርሾባዝ ማቅካይዝን ፋርሳዉንꬅን ሳዱቃዉንꬅ ትምርተፓ ናግንቶደ ፋና ማቅዳኖ ቲርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","የሱሳ ቂሳርያ ፍልጶሳ ሳአ የልደ ዎደ ፋ ታማሩንꬃጎ፥ «አሱንꬅ፥ አስ ናአያ ኦና ጋኤ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ኡን፥ «ፈተ ፈተ ጻማቅዘ ዋሐንሳ፥ መሉንꬅ ኤልያሳ ማህ Ꮉንኩንꬅ ኤርምያሳ ዎይ ናቡንꬃፓ ፈታ ጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","የሱሳ ማህ፥ «ዬዝን፥ ይን ታና ኦና ጋኤተ?» ጋእ ኡንታና ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ስሞን ጴጥሮሳ ማህ፥ «ኔኒ ክርስቶሳ፥ ደኦ ጾዘ ናአ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","የሱሳ ጴጥሮሳጎ፥ «ዮና ናአ ስሞና፥ ነ አንጅንትዳያ! Ꮉኖ ኔስ ቆንጭዝደ ሳሎ የዘ ታ አዳያፕ አትን አስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ታ ኔስ ኦህነ ጴጥሮሳ፥ ነ ላላ! ታኒ Ꮉይ ላልዘላ አፋ ታ ዎሳ ኬꬂ ኬጾዳ። ጋናመ ዎልቃን እዞ ጋሞስ። ");
INSERT INTO oyde_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ሳሎ ካእቱሞ ቁልፈ ታ ኔስ እንጎዳ። ሳአ ነ አጭደባዝ ኡባ ሳሎ ጾዘ ካለ አጭንትደባዝ ማቃዳ። ሳአ ነ ብልደ ባዝ ኡባ ሳሎ ጾዘ ካለ ብልንትደባዝ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ይንፓ ሱባ፥ ኤ፥ ክርስቶሳ ማቅዳኖ ኦደስን ኦሃመ ፋና ፋ ታማሩንꬅስ ምንꬂ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ይና ዎድትፓ ደንꬂ የሱሳ ፋ ታማሩንꬅስ፥ «ታኒ የሩሳላመ Ꮉንጎደስ ቤዛነ። የይጋ ዎርዣ ጭሙንꬅ፥ ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬅ ኩሸ ማꬋ ኤኮደስ ቤዛነ። ኡን ታና ዎꬎዳ፥ የዝን ታኒ Ꮉይꬒንꬃ ቃማ Ꮉይቆፓ ደንዶዳ» ያጋእ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ጴጥሮሳ የሱሳ ጋጻ ኬሲ፥ «ላꬆ፥ ይኒ ፋና የዘ ባዝ ነና ሙሎን የልፐ!» ያጋእ ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","የሱሳ ጴጥሮሳጎ ሱብ ማቂ፥ «Ꮉይ ጻላህዛዮ፥ ታፓ Ꮉኮ! ኔኒ አስ ቆፋ ቆፓነፕ አትን ጾዘ ቆፋ ቆፖሰ ግሾ ታስ ꬉበ ማቃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ይንፓ ሱባ፥ የሱሳ ፋ ታማሩንꬃጎ፥ «ኦደን ታና ካሎደስ ኮይዘ ባዝ ማቅኮ ፋና ካዶ፥ ፋ ማስቃልቶ ቶኪ ታና ካሎ። ");
INSERT INTO oyde_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ፋ ሸምፕቶ አሾደስ ኮይዘ ኡቡንꬅ ꬋብሶዳ። የዝን ፋ ሸምፕቶ ታ ግሾ ጋእ አꬂ እንግዘ አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","አሲ አላመ ኩሙꬅ ፋ ባዝ ማህ፥ ፋ ሸምፕቶ ꬋብስኮ ኤዛ አኮ ማደ? ዎይ አሲ ፋ ሸምፕቶ ዎዞደስ አክ እንጎደስ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","አስ ናአ ፋ አዳይ ቦንቾራ ፋ ኪታንቹንꬃራ ዮኦዳ። የ ዎደ ፈቲ ፈቲ አꬄስ ኤ ኦችት ፋና እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ታ ቱሮ ኦህነ፤ አስ ናአ ፋ ካእቱሞ ቦንቾራ ማቂ ዮኦደራ በአደ ዎንꬅስ Ꮉነ ኤቅደ አሱንꬃፓ Ꮉይቃሙንꬅ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","እዝፑን ቃማፓ ሱባ የሱሳ፥ ጴጥሮሳ፥ ያይቆባን ኤ እሻ ዋሐንሳ ፋራ ኤኪ ኡንታራ ጻላላ ደረላ አፋ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","እዘ ኡን ቲንተ የሱሳ ብሽታ ላምንትዳ፤ ኤ ስንታን አዋ ፋና ፎጭዳ። ኤ አፉልታን ሎይꬂ ቦጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ይኬ፥ ሙሴን ኤልያሳን ኤራ ኦህንትዝን ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ጴጥሮሳ የሱሳጎ፥ «ላꬆ ኑኒ Ꮉነ ꬉጋ ይእዳ። ነ ኮይኮ ፈታ ኔስ፥ ፈታ ሙሴስ፥ ፈታ ኤልያሳስ Ꮉነ Ꮉይꬕ ጋባ ጋቦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ጴጥሮሳ ይኖ Ꮉጋ ኦህዝን ቦꬅ ፎጭደ ꬎነ ኡንታና ጎዝዳ። ꬎንቲ ግዳራ፥ «ታና ኡፋይስዘ፥ ታ ካዽዘ ናአይ Ꮉያ፥ ኤዛ ስኦተ!» ያጋዘ ቃላ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ኤ ታማሩንꬅ ይኖ ስእደ ዎደ ታኒ ፋ ስንትራ ሳአላ ጎልእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","የዝን የሱሳ ኡንታጎ ሺቂ ኡንታና ቦቺ፥ «ደንዶተ፥ ዣሽትፐተ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ኡን ꬎቅ ጋእ በእዘ ዎደ የሱሳፓ መለ ኦናን ቢካያ። ");
INSERT INTO oyde_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ኡን ደርዘፓ ዎꬍዝን የሱሳ ኡንታጎ፥ «አስ ናአ Ꮉይቆፓ ደንዶደ ዎንꬅስ Ꮉኖ ይን ብእዳኖ ኦደስን ኦህፐተ» ጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","የሱሳ ታማሩንꬅ፥ «ዬዝን፥ ህገ አስታማሩንꬅ ኤልያሳ ክርስቶሳፓ ቲኖ ዮኦዳ ጋይዳና አኮሶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","የሱሳ ማህ፥ «ዬ! ኤልያሳ ቲኖ ይእ ኡባ ባዝ ጊግዞዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","የዝን ታ ይንትስ ቱሮ ኦህነ፤ ኤልያሳ ቲኖ ይእዳ። ኡንትን ኤላ አፋ ኮይደባዝ ኦችዳፕ አትን ኤዛ ሻኪ ኤርካያ። ይኒ ጋር አስ ናአ ኡን ኩሸ ማꬋ ኤኮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","የ ዎደ የሱሳ ጋይዳና ጻማቅዘ ዋሐንሳ ባዝ ማቅዳኖ ቲርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ኡን ደርዘፓ አሱንꬃጎ ማቅዘ ዎደ ፈቲ አስ የሱሳ ቲንተ ቡንቁንቲ፥ ");
INSERT INTO oyde_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«ላꬆ፥ አደ ታ ናአያ ማሮያ፤ ኤዛ ጉዲ ኦልዘ Ꮉርገ ጋማ ዎደ ኡንእꬅ ታማን Ꮉꬃን ኦላነ። ");
INSERT INTO oyde_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ነ ታማሩንꬃጎ ክእዳ፥ የዝን ኡን ፋꬆደስ ዳንዳእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","የሱሳ ማህ፥ «ይን፥ አማኖሰ ዎቦ የለቱንꬆ አይደ የሎደስ ታ ይንታራ የሳደ? አይደ የሎደስ ታ ይንታና ዳንዳኦደ? አነ ናአያ Ꮉንካ ኤኪ ዮኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","የሱሳ ቱና አያንዛ ቆድን፥ ቱና አያንዘ ናአይፓ ከዝዳ፤ ይና ሳተ ናአይ ፋጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ይንፓ ሱባ፥ የሱሳ ታማሩንꬅ ፋ ፋስ ኤጎ ሺቂ፥ «ኑ ቱና አያንዛ ኬሶደስ ዳንዳእካይዛና አኮሶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ኤ ኡንታጎ፥ «ይንትስ አማኖ ኤርደ ግሾስ። ታ ይንትስ ቱሮ ኦህነ፤ ጋሸ ኣፈ ፋና አማኖ ይንትስ የዝኮ ‹Ꮉይ ደርዛ Ꮉንፓ ደንዲ ጎደ አꬎ› ጋይኮ ይንትስ ኪትንቶዳ። ይንትስ ዳንዳእንቶሰ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","የዝን ይኒ ጋርዘ ዎሳራን ጾማራፕ አትን Ꮉሪ ኬዞስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","የሱሳ ታማሩንꬅ ጋልላ ሺቂ የዝን የሱሳ ኡንታጎ Ꮉና ፎልንቶደስ ቤዛነ፥ «አስ ናአይ አስ ኩሸ አꬊ እንግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ኡን ኤዛ ዎꬎዳ፥ የዝን ኤ Ꮉይꬕንꬃ ቃማ Ꮉይቆፓ ደንዶዳ» ያጋይዳ። ኤ ታማሩንꬅ ጋማ አዛንዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","የሱሳራን ኤ ታማሩንꬃራ ቅፍርናሆመ ካታማ የልደ ዎደ ጾዘ ኬꬃ ጊራ ጋችዙንꬅ ጴጥሮሳጎ ይእ፥ «ይን አስታማርዘ ጾዘ ኬꬂ ጊራ ላምእ ድናረ ጊሮሶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ጴጥሮሳ ማህ፥ «ጊራነ» ያጋይዳ። ጴጥሮሳ ኬꬃ ገልዘ ዎደ የሱሳ ቲንꬊ፥ «ጴጥሮሳ፥ ኔስ አኮ አዘ? Ꮉና ሳአ ካእቱሞ ቃራጸን ጊራ ኦፓ ኤከ? ጋደ አሳፓ ዎይ አስ ጋደ አሳፓ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጴጥሮሳ «አስ ጋደ አሳፓ» ጋእ ማህዳ። የሱሳ ማህ፥ «ዬዛኮ ጋደ አሱንꬅ ጊራ ግሮስ ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","የዝን ኡን ꬉቡንታመ ፋና አባ Ꮉንግ ሞሎ አይክዘ ማንጻኮ ኦሎ። ቲኖ ነ አይክዘ ሞልዘ ዶና ቡጊ ጊራስ ማቅዘ ኦይዲ ድናረ ነ ግሾን ታ ግሾን ኤኪ ካንግ ጊሮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","የ ዎደ የሱሳ ታማሩንꬅ ይእ፥ «ሳሎ ካእቱሞ ኡባፓ አꬍዘ ኦደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","የሱሳ ፈቲ ኤራꬅ ናአ ጼጊ ኡን ግዳ ኤስ Ꮉኒ ፋና ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«ታኒ ይንትስ ቱሮ ኦህነ፤ ይን ላምንታንጽኮ ኤራꬅ ናኡንꬅ ፋና ይአንጽኮ ሳሎ ካእቱሞ ሙሎን ገሎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ይኬ፥ Ꮉና ኤራꬅ ናኡንꬅ ጋር ፋና ካዉሽዘ ኦደን ሳሎ ካእቱሞ ኡባፓ አꬍዛ ማቆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ꮉይ ፋና የዘ ናአ ታ ሱንꬅተ ሞክዘ ኦደን ታና ሞካነ። ");
INSERT INTO oyde_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«የዝን ታና አማንዘ Ꮉና ኤራꬁንꬃፓ ፈታ ናጋራ ኦቾደ ፋና ꬉበ ማቅዘ ኦደን ዳማ ጋች ዎጻ ፋ አፉርተ አጪ ጪሞ አባ ኦልንትዛኮ ኤስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","አላመ ግዳ አስ ናጋራ ኦቾደ ፋና ኦችዙንꬅ የዘ ግሾ አላምቶ ባደ። ይኒ ፋና የዘ ባዝ ይእካይዛራ አቶስ፥ የዝን ꬉበ ኤ ባጋራ የእዘ አꬃ ባደ። ");
INSERT INTO oyde_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«ነ ኩሽዘ ዎይ ነ ቶህዘ ነና ባልꬅኮ ኔፓ ጋቺ ኦሎ። ነ ላምእ ኩሸራ ዎይ ላምእ ቶሄራ መዽና ታማ ኦልንቶደፓ ኩሸ ዎይ ቶሄ ዱጻ ማቂ ደኦ የዝኮ ኔስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ማህ ነ ኣፍዘ ነና ባልꬅኮ ዎጪ ኬሲ አላ ኦሎ። ነ ላምእ ኣፈራ ጋናመ ታማ ኦልንቶደፓ ፈቲ ኣፈራ ደኦ የዝኮ ኔስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«ታ ይንትስ ኦህነ፤ ሳሎ የዘ ኡንታና ናግዘ ኪታንቹንꬅ ኡባ ዎደ ሳሎ የዘ ታ አዳይ ቲኖ የዘ ግሾ ይን Ꮉና ኤራꬁንꬃፓ ፈታያ ለቃመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","አስ ናአ ꬋብዱንꬃና አሾደስ ይእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ማህ የሱሳ፥ «ይንትስ አኮ አዘ? ፈቲ አꬄስ ጼት ዱሮ የዙንꬃፓ ፈታይ ꬋብኮ ኡዱፉን ታም ኡዱፉኑንꬃና ደረላ ኦሊ አሺ የ ꬋብዳያ ኮዮደስ ቅቶሳነ? ");
INSERT INTO oyde_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ታ ቱሮ ኦህነ፤ ኤ ደንግደ ዎደ ኡዱፉን ታም ኡዱፉኑንꬃፓ አꬂ ꬋቢ በንትደ ፈቲ ዱርዘራ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ይኒ ፋና፥ ሳሎ የዘ ይን አዳይ Ꮉና ኤራꬁንꬃፓ ፈታይ ꬋቦደ ፋና ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«ነ እሻይ ነና ቆህኮ ነ ጻላላ ኤጎ Ꮉንግ ኤ ባልቶ ኤስ ኦሆ። ኤ ነና ስእኮ ነ እሻያ ኔስ እሸ ማሆ። ");
INSERT INTO oyde_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","የዝን ኤ ነና ስአንጽ እጽኮ፥ ላምእ ዎይ Ꮉይꬕ አስ ማርካራ ኦህታ ላꬅንትዘ ግሾ ፈቲ ዎይ ላምእ አስ ኤኪ ኤጎ Ꮉንጎ። ");
INSERT INTO oyde_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ኤ ኡንታና ስአንጽኮ፥ ዎሳ ኬꬃ ኦሆ። ዎሳ ኬꬂ ጋዘባዝ ስአንጽኮ አማኖሰ አስ ፋና ዎይ ቃራጠ ጋችዘ አስ ፋና ኤዛ ፋይዶ። ");
INSERT INTO oyde_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«ታ ይንትስ ቱሮ ኦህነ፤ ሳአላ ይን አጭደባዝ ኡባ ሳሎ አጭንትደባዝ ማቃዳ። ሳአላ ይን ብልደ ባዝ ኡባ ሳሎ ብልንትደባዝ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«ማህ ታ ይንትስ ኦህነ፤ ሳአላ ይንታፓ ላምኡንꬅ ፋ ዎስዘ ባዝ ፈቲ ዎዝና ማቂ ጾዝ ዎስዘ ባዝ ማቅኮ ሳሎ የዘ ታ አዳይ ይንትስ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ታና ካልዙንꬃፓ ላምእ ዎይ Ꮉይꬕ ማቂ ሺቅዘ በሳ ታኒ ኡን ግዳ በንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","የ ዎደ ጴጥሮሳ የሱሳጎ ይእ፥ «ላꬆ፥ ታ እሻይ ታና ቆህኮ ዋንꬅ ቶሄ ታኒ አቶ ጋኦደስ ቤዘ? ላፑን ቶሄ የሎደስነ?» ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","የሱሳ ማህ፥ «አደ፥ ላፑን ታም ቶሄ ላፑናፕ አትን ላፑን ቶሄ ጻላላ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«ይኒ ግሾ፥ ሳሎ ካእቱሞ ፋስ ኦችዙንꬃራ ፋ ሚሽታ ፋጨዛኮን ጉጁንተዛኮ በአደስ ቆፕደ ካትዛ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","የ ካትዘ ሚሽታ ፋጨዛኮን ጉጁንተዛኮ በእዘ ዎደ ጋማ ጋለ የዘ ፈቲ አꬃ ኤጎ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","የዝን የ አርዘ ጋልቶ ጭጎደስ ጋምን ኤራን፥ ኤ ማችትራ፥ ኤ ናኡንꬃራ ኤስ የዘ ባዝ ኡባ ባይዝንት ጋልታ ጭግንቶደ ፋና ላꬄ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ዬዝን አርዘ ፋ ላꬄ ቶህትላ ጎልእ፥ ‹አደ ኤራꬅ ዎደ ጋምኦ፥ ታ ጋልቶ ኡባ ታ ጭጎዳ› ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ኤ ላꬅዘ ኤስ ይቅስንት፥ ዳኪ አሽዳ፤ ኤ አጭቶን ማርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«የዝን የ አርዘ ኬዚ Ꮉንግ ፋ ላገ ኦችዙንꬃፓ ፈታያ ፋፓ ኤራꬅ ሚሸ ታልእዳያ፥ ‹ኔላ አፋ የዘ ታ ሚሽቶ ታስ ጭጎ› ጋእ አፉርቶ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«ኤ ላግዘ አርዘ ኤ ቲንተ ቡንቁንት፥ ‹አደ ኤራꬅ ዎደ ጋምኦ ታኒ ታ አጭቶ ኡባ ጭጎዳ› ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«የዝን እጺ ኤኪ ካንግ ፋ ላግዘ አጭቶ ጭጎደ ዎንꬅስ አች ኬꬃ ገልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ይኒ ግሾ፥ መለ ላግዘስ ኦችዙንꬅ ይኖ ብእደ ዎደ ጋማ ዥልꬍዳ፥ Ꮉንግ ፋ ላꬄስ ኤ ኦችደ ባዝቶ ኡባ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«ዬዝን ላꬄ የ አርዛ ጼግዝ፥ ‹Ꮉይ ኢታ አርዛዮ፥ ነ ታና ዎስደ ግሾ ታ ነ አጭቶ ኡባ ኔስ ማርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ዬዝን፥ ታ ነ አጭቶ ማርዳን ፋና ነ ነ ላገ ማቅደ አርዘ አጭቶ ማሮደስ ነና ቤዞሶ?› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ይኒ ግሾ፥ ላꬄ ጋማ ዥልꬊ፥ ኤ ፋ አጭቶ ኡባ ጭጎደ ዎንꬅስ ኡንእንቶደ ፋና አች ኬꬃ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«ይኒ ፋና፥ ይን ፈተ ፈተ ይን እሻ ዎዝናፓ ማራንጽኮ ሳሎ የዘ ታ አዳይ ይንታና ይኒ ፋና ኦቾዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","የሱሳ ይኖ ኦህ Ꮉስዳንፓ ሱባ ጋልላፓ ደንዲ ዮርዳኖሳ ቦርካፓ ሰኮ ዛላ የዘ ይሁዳ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ጋማ አሱንꬅ ኤዛ ካሊ Ꮉንግን ኤ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ፋርሳዉንꬅ ኤዛ ፋታኖደስ ኮይ ኤጎ ይእ፥ «ፈቲ አስ አኮ ባጋራን ፋ ማችቶ ዳኮደስ ቤዘ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","የሱሳ ማህ፥ «ጾዚ ቲኖ ꬊራꬅን ማቾን ማህ መꬍዳኖ ይን ናባብካተ? ");
INSERT INTO oyde_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‹ይኒ ግሾ፥ ፈቲ አስ ፋ አዳያን ፋ እንቶ አሺ ፋ ማችትራ ፈቶ ማቃነ፥ ላምኡንꬅን ፈቲ አሾ ማቃነ።› ");
INSERT INTO oyde_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ይኒ ግሾ፥ ኡን ፈቲ አሾ ማቃነፕ አትን ላምእ ማቆስ። ይኬ፥ ጾዚ አጭዳኖ አስ ሻክፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ፋርሳዉንꬅ፥ «ዬዝን፥ ሙሴ ፈቲ አስ ዳፎ ዋርቃተ እንግ ዳኮደ ፋና አኮስ ኪትዶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","የሱሳ ማህ፥ «ይን፥ ይን ማቹንꬃና ዳኮደ ፋና ሙሴ ይንትስ ጋይዳና፥ ይን ዎዝና ምንꬅት ግሾፕ አትን ቲኖፓ ይኒ ጋር ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ታ ይንትስ ኦህነ፤ ፋ ማችቶ ጎመ ዋይንትካይዝን ዳኪ መለ ኤክዘ ኦደን ኦላልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ኤ ታማሩንꬅ ኤጎ፥ «አዝኒ ባዝን ማች ባዝ ይኒ ጋር ማቅኮ ኤከን ገለን አትኮ ሎኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","የሱሳ ማህ፥ «ይኒ ጋርዘ ትምርተ ጾዚ ዳንዳአ እንግዱንꬅስ ፋትን አስ ኡቡንꬅስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ይኬ፥ የልንትተራ አሽትመ ማቂ የልንትዱንꬅ የነ፥ ማህ አስ ቃራትዱንꬅ የነ፥ ማህ ሳሎ ካእቱሞ ግሾ ጋእ ፋና አሽትመ ማህዱንꬅ የነ። ይኒ ግሾ፥ Ꮉኖ ኤኮደስ ዳንዳእዘ ኦደን ኤኮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","የሱሳ ፋ ኩሽቶ ኤራꬅ ናኡንꬃላ ጋዲ ኡንትስ ዎሶደ ፋና ፈቲ ፈቲ አሱንꬅ ናኡንꬃና ኤጎ ክእዳ። የዝን ኤ ታማሩንꬅ አሱንꬃና ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","የዝን የሱሳ፥ «ሳሎ ካእቱሞ Ꮉንስ ፋና የዙንꬅስ ማቅደ ግሾ ኤራꬅ ናኡንꬅ ታጎ የእዛኖ ካይፐተ፤ ዮኦ ጋኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ፋ ኩሽቶ ኡንታላ ጋድዳንፓ ሱባ ይና በስትፓ አሺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ፈቲ ቃማ ፈቲ አꬄ የሱሳጎ ይእ፥ «አስታማርዛዮ፥ ታኒ መዽና ደኦ ደንጎደስ አኮ ሎኦ ባዝ ኦቾ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","የሱሳ ኤጎ፥ «ሎኦ ባዝስ ነ ታና አኮስ ኦጨ? ፈቲ ጾዛፕ አትን መለ ሎኦ ባያ። የዝን ነ መዽና ደኦ ኤኮደስ ኮይኮ ኪቶ ናጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","አꬄ ማህ፥ «አኖ ኪታ» ያጋእ ኦጭዳ። የሱሳ ማህ፥ «ዎꬍፐ፥ ኦላልፐ፥ ካይስትፐ፥ ዎርዶ ማርክꬍፐ፥ ");
INSERT INTO oyde_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ነ አዳያን ነ እንቶ ቦንቾ፥ አስ ኡባ ነ ፋና ካꬎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","የ ሻካንዘ፥ «ታኒ Ꮉኖ ኡባ ናአትꬃፓ ደንꬅ ናግዳ። ዬዝን፥ መለ ታስ ፋጭደባዝ አኮ ባዞ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","የሱሳ ማህ፥ «ነ ፎሎ ማቆደስ ኮይኮ Ꮉንግ ኔስ የዘ ባዝ ባይዝ ዳሁንꬅስ እንጎ፤ ነ ሳሎ ዱረትꬅ ደንጎዳ። የይዝ ማቂ ይእ ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","የዝን የ ሻካንዘ ጋማ ዱረ ማቅደ ግሾ ይኖ ስእደ ዎደ አዛንተራ አሺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ይንፓ ሱባ፥ የሱሳ ፋ ታማሩንꬃና፥ «ታ ይንትስ ቱሮ ኦህነ፤ ዱረ ሳሎ ካእቱሞ ገሎዳና ጋማ ማꬋ። ");
INSERT INTO oyde_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ዱረ አስ ጾዘ ካእቱሞ ገሎዳንፓ ግማለ ማርፐ ኡሩንꬃራ ኣꬍዛና ላፋ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","የሱሳ ታማሩንꬅ ይኖ ስእ ጋማ ቆፒ፥ «ዬዝን፥ ኦደ አቶደስ ዳንዳኦደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","የሱሳ ኡንታና ዳኪ ብእ፥ «Ꮉና አስስ ዳንዳእንቶስ፥ የዝን ጾዝስ ኡባና ዳንዳእንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ጴጥሮሳ ማህ፥ «ኑኒ ኡባ ባዝ አሺ ነና ካልዳ። ዬዝን፥ ኑ አኮ ደንጎደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","የሱሳ ኡንታጎ Ꮉኒ ጋር ያጋይዳ፦ «ታኒ ይንትስ ቱሮ ኦህነ፤ አስ ናአይ ዮኦደ ክለ አላምተ ፋ ቦንቾ አራታላ በትዘ ዎደ ይን ታጶ ላምኡንꬅ፥ ታና ካልዱንꬅ፥ ታጶ ላምእ አራታላ በቲ ታጶ ላምእ እስራኤለ ባጉንꬃላ አፋ ፍርዶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ታ ሱንꬅት ግሾ ኬꬅቶ ዎይ እሹንꬃና ዎይ ምሹንꬃና ዎይ አዳያ ዎይ እንቶ ዎይ ናኡንꬃና ዎይ ጋድቶ አሽደ ኦደን ጼት ኩሸ ኤኮዳ። ማህ መዽና ደኦ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","የዝን ጋሙንꬅ Ꮉተ የስተ ቲኖ ማቅዱንꬅ ሱባ ማቆዳ፥ ማህ ሱባ ማቅዱንꬅ ቲኖ ማቆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«ሳሎ ካእቱሞ ፋ ዎይነ ግዳ ኦችዙንꬅስ ክራ እንጎደስ ዎንታ ጎዳ ከዝደ ካርቲ አዳያ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ኤ ኦችዙንꬅስ Ꮉይኖ Ꮉይኖ ፈቲ ድናረ እንጎደስ ኡንታራ ጊጊ፥ ኡንታና ፋ ዎይነ ግዳ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«ማህ ዎንታፓ Ꮉይꬕ ሳተ ማቅዝን ኬዚ ኦቻ ꬋብን ጋበ በሳ ኤቅደ መለ አሱንꬃና ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ኤ ኡንታጎ፥ ‹ይንትን ታ ዎይነ ግዳ Ꮉንግ ኦቾተ፥ ታኒ ይንትስ ታና ሎእደ ሚሸ እንጎዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ኡንትን Ꮉንግዳ። ማህ ኤ እዝፑን ሳተራን ኡዱፉን ሳተራ ኬዚ ይኒ ፋና ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ታጶ ፈቲ ሳተ ማቅዝን ኤ ከዝዘ ዎደ መሉንꬃና የይጋ ኤቅዱንꬃና ደንግ፥ ‹ይን ኦቻ ብሊ አዋራ ፌሾ Ꮉነ አኮስ ኤቂ ፌዥዶተ? ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«ኡን ማህ፥ ‹ኑና ክራ ኦጭዘ አስ ꬋብደ ግሾ› ያጋይዳ። «ኤዝን፥ ‹ይንትን ታ ዎይነ ግዳ Ꮉንግ ኦቾተ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«ሳታ ኡጉርን፥ ዎይነ አዳይ ኦችዙንꬅ Ꮉላቅዘጎ፥ ‹ኦችዙንꬃና ጼጊ ላሳ ኦቻ ገልዱንꬃፓ ደንꬂ ቲኖ ገልዱንꬃና የሎደስ ኡን ሚሽቶ እንጎ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ታጶ ፈቲ ሳተር ኦቻ አይክዱንꬅን ይእ፥ ኦማ ኦማ ፈቲ ፈቲ ድናረ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ቲኖ ኦቻ አይክዱንꬅ ይእ፥ ፋስ ጋማ እንግንቶዳ ጋእ ቆፕዳ። የዝን ኡንትን ኦማ ኦማ ፈቲ ፈቲ ድናረ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ፋ ሚሽቶ ኤኪ ማቂ ካርቲ አዳይላ አፋ ዙዝንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Ꮉንስ ሱባፓ ይእ ፈቲ ሳተ ጻላላ ኦችዳ። የዝን አዋራ ፌሾ ላቢ ፌዥደ ኑራ ኡን ዋይዝ ፈቶ ማቀ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«ዎይነ አታክልተ አዳይ ኦችዙንꬃፓ ፈታይጎ፥ ‹ታ እሻዮ፥ ታ ነና ቆህካያ፤ ነ ታራ ዉልꬍዳና ፈቲ ድናረስ ባነ? ");
INSERT INTO oyde_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ነ ሚሽቶ ኤኪ ነ ካራ ቅቶ። ታ ኡጉረ ይእደስን ኔኒ ፋና እንጎደስ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ታኒ ታ ሚሽትራ ኮይደባዝ ኦቾደስ ታስ አደትꬅ ዎልቃ ባነ? ዎይ ታ ዳልጋ ማቅደ ግሾ ነ ቅናታነ?› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«ይኒ ጋራን Ꮉተ ደእተ ሱብ ማቅዱንꬅ ቲኖዳ፥ ቲንዱንꬅ ማህ ሱቦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","የሱሳ የሩሳላመ Ꮉንግተራ፥ ታጶ ላምእ ታማሩንꬃና ዱማ ጋጻ ኬሲ ኡንታጎ ያጋይዳ፦ ");
INSERT INTO oyde_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ይኬ፥ ኑኒ Ꮉተ የሩሳላመ Ꮉንገላ አፋ የነ። እዘ አስ ናአ ካህኑንꬅ Ꮉላቁንꬅስን ህገ አስታማሩንꬅስ አꬂ እንግንቶዳ። ኡንትን ኤላ አፋ Ꮉይቆ ፍርዳ ፍርዶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ኤዛ አይሁደ ማቆሰ ዎርዣስ አꬂ እንጎዳ። ኡን ኤዛ ካዉሾዳ፥ ጋራፎዳ፥ የይዝ ኤዛ ማስቅላላ አፋ ሱጾዳ። የዝን ኤ Ꮉይꬒንꬃ ቃማ Ꮉይቆፓ ደንዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","የ ዎደ ዛብዶሳ ማችታ ፋ ላምእ ꬊራꬅ ናኡንꬃራ የሱሳጎ ይእ፥ ኤ ቲኖ ቡንቁንቲ ፈቲ ባዝ ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","የሱሳ ኢጎ፥ «ነ አኮ ኮየ?» ጋይዳ። እዛ ማህ፥ «ነ ካእቱምተ Ꮉንꬅ ታ ላምእ ናኡንꬅ ፈታያ ኔስ ምዛቅ ዛላ ፈታያ ኔስ ዎርክታ ዛላ በቶ ጋኦያ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","የዝን የሱሳ ኡንታጎ ማህ፥ «ይን አኮ ዎስዛኮ ኤሮስ፤ ታኒ ኡሻደስ የዘ ማꬋ ጹኡቶ ኡሻደስ ዳንዳኦደ?» ያጋይዳ። ኡንትን፥ «ዬ ዳንዳኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","የሱሳ፥ «ቱሮ ታኒ ኡሻደስ የዘ ጹኡቶ ይን ኡሻዳ። የዝን ታ ምዛቅተን ዎርክተ በቶዱንꬃና ዶርዘ ታና ባያ። ይና በስታ እንግንትዘ፥ ታ አዳይ እንጎደስ ጊግዝደ አሱንꬅስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","አትደ ታጵ ኤ ታማሩንꬅ ይኖ ስእደ ዎደ ላምእ እሹንꬃና ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","የዝን የሱሳ ኡንታና ኡባ ጼጊ Ꮉኒ ጋር ያጋይዳ። «አይሁደ ማቆሰ አሱንꬃና አህዙንꬂ ፋ አሱንꬃላ ላꬅꬍዛኖን ኡንታና ካልꬅዙንꬅ ማህ ኡንታና አደትꬅ ዎልቃራ አህዛኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","የዝን ይን ግዳ ይኒ ጋር ማቅፐ። ይንታፓ ꬎቆደስ ኮይዘ ኦደን ይንትስ አሮ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ይን ግዳ ኡባፓ ꬎቃ ማቆደስ ኮይዘ ኦደን ይንትስ አሮ ማቆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ይኒ ፋናን፥ አስ ናአ አስ ማዶደስን ጋማ አሱንꬃና ዎዞደስ ፋ ሸምፕቶ እንጎደስ ይእዳፕ አትን አሳራ ማድንቶደስ ይእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ይንፓ ሱባ፥ የሱሳ ፋ ታማሩንꬃራ እያርኮፓ ኬዚ Ꮉንግዝን፥ ጋማ አሱንꬅ ኡንታና ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ኦገ ጋጻ በትደ ላምእ ቆቁንꬅ የሱሳ የይጋራ አዽዛኖ ስእ፥ «ላꬆ፥ ዳዉተ ናአዮ፥ ኑና ማሮያ» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ጋማ አሱንꬅ ኡንታና፥ «Ꮉይዞተ» ያጋእ ካጭዳ። የዝን ኡን፥ «ላꬆ፥ ዳዉተ ናአዮ፥ ኑና ማሮያ» ጋእ ጉጂ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","የሱሳ ኤቂ፥ ኡንታና ጼጊ፥ «ታ ይንትስ አክ ይሳደ ፋና ኮየተ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ኡንትን፥ «ላꬆ፥ ኑ ኣፍታ በአደ ጋር ኮየተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","የሱሳ ኡንትስ ይቅስንቲ፥ ኡን ኣፍቶ ቦችዳ። ኤልሲ ኡን ኣፍታ ብእዳ፤ ኡንትን ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","የሱሳራን ኤ ታማሩንꬃራ የሩሳላመ ኡክ፥ ሻማሄ ደርዘላ የዘ ቤተፋገ ጋዘ ጉቱተ የሊተራ፥ የሱሳ ፋ ታማሩንꬃፓ ላምኡንꬃና ፋፓ ቲኖ Ꮉንጎተ ጋእ ኪትዳ፦ ");
INSERT INTO oyde_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«ይንታፓ ቲኖ የዘ ጉቱተ Ꮉንጎተ። የይጋ ፈቲ Ꮉረ አቻ የዛኖ እ ናእትራ ይን ደንጎዳ። ኡንታና ብሊ ታጎ ኤኪ ዮኦተ። ");
INSERT INTO oyde_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ኦደን ይንታና ኦጭኮ፥ ‹ላꬂ ኡንታና ኮያነ› ያጋኦተ። ኤ ኡንታና ኤለ ማሆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ይናን ናብዘ፥ ");
INSERT INTO oyde_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ጽዮነ ካታማስ፥ ‹ይኬ፥ ነ ካትዘ አዳ ማቂ፥ Ꮉርትላን Ꮉርት ናእትላ በቲ፥ ኔጎ የእነ› ያጋኦተ» ጋእ ጻፍንትዳና ፎልንቶደ ጋር ይና Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ኤ ታማሩንꬅ Ꮉንግ የሱሳ ኡንታና ኪትዳን ፋና ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ꮉርቶን Ꮉርቲ ናእቶን ክእ ካታራ ፋ ማእቶ ኡን ባንተ ጋድዳ። የሱሳ ማእትላ አፋ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ጋማ አሱንꬅ ፋ ማእቶ ኦግተ ዪጽዳ። መሉንꬅ ታሸ ታርሺ ኦግተ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","የሱሳፓ ቲኖራ Ꮉንግዙንꬅን ኤፓ ሱባራ ካልዙንꬅ ጋማ አሱንꬅ፥ «ሆሳና! ዳዉተ ናአይ ጋላትንቶ! ላꬄ ሱንꬅተ ይእዘ አንጅንትዳያ! ቦንቾ ኡባፓ ꬎቃ ሳሎ ጾዝስ ማቀ!» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","የሱሳ የሩሳላመ ካታማ ገልደ ዎደ ይና ካታምተ የዘ አሱንꬅ ኡቡንꬅ፥ «Ꮉይ ኦደ?» ያጋእ ቱርቱርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","አሱንꬅ፥ «Ꮉይ ጋልላ የዘ ናዝረተ ካታማፓ ይእደ ናበ የሱሳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","የሱሳ ጾዘ ኬꬃ ገሊ፥ የይጋ ባይዙንꬃናን ዎንግዙንꬃና ኡባ ባለ ባይእዳ። ሚሸ ላምዙንꬃና ጠርጴዝቶን ዎለ ባይዝዘ ኦይድቶ ሽሪ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ኤዝን ኡንታጎ፥ «ጾዘ ቃልተ፥ ‹ታ ኬꬅታ ጾዝ ዎስዘ ኬꬂ ጋእንታነ› ጋእንት ጻፍንትዳ። የዝን ይን ፋኖ አችንትዘ ዎምኦ ማህዳተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","የሱሳ ጾዘ ኬꬃ የሳደራ ቆቁንꬅን ዎቡንꬅ ኤጎ ይእን ኡንታና ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","የዝን ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬅ የሱሳ ኦችደ ጋማ ቆፍዘ ባዝቶ ብእዳነን ዦጋ ናኡንꬅ ጾዘ ኬꬃ፥ «ዳዉተ ናአይ፥ ጋላትንቶ» ያጋእ ኡክዛኖ ስእ ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ኡን የሱሳጎ፥ «Ꮉንስ ጋዛኖ ነ ስእነ?» ያጋይዳ። የሱሳ፥ «ዬ ስእነ፥ ጾዘ ቃልተ፥ ‹ዦጋ ናኡንꬅ ዶንተን ꬋንግዘ ናኡንꬅ ዶንተ ጋላታ ጊግዛነ› ጋእንት ጻፍንትዳኖ ይን ናባብካተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ኡንታና የይጋ አሺ ብታንያ ካታማ Ꮉንግ አቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","የሱሳ ዎንታ ጎዳ ካታማ ማቂ ይእተራ ናይꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ኦገ ጋጻ ፈቲ በለሰ ምንጻ ብእ ኢጎ Ꮉንግዳ። የዝን Ꮉየፕ አትን መለ አኮን ደንግካያ። ይኒ ግሾ፥ እዞ፥ «ይኬፓ ላምእንꬃ ኣፈ አፍፐ!» ያጋይዳ። ይና በለሰ ምንጽታ ኤልሲ መሊ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ኤ ታማሩንꬅ ይኖ ብእ፥ «Ꮉና በለስታ ዋይዝ ኤልሲ መልዶ?» ያጋእ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","የሱሳ ማህ፥ «ታኒ ይንትስ ቱሮ ኦህነ፤ ይንትስ አማኖ የዝኮ፥ ማህ ይን ስꬋንጽኮ በለስትላ ታኒ ኦችዳን ፋና ጻላላ ኦቾስ፥ የዝን ‹Ꮉይ ደርዛ ሾድንት አባ ዎꬎ› ያጋይኮ Ꮉኖዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","አማኒ ይን ዎስዘ ባዝ አኮን ማቅኮ ይን ኤኮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","የሱሳ ጾዘ ኬꬃ ገሊ ታማርሶደራ፥ ካህኑንꬅ Ꮉላቁንꬅን አይሁደ ጭሙንꬅ ኤጎ ይእ፥ «ነ Ꮉኖ ኦቾደ ፋና ኔስ አኮ አደትꬅ ዎልቃ የዘ? ኔስ Ꮉኖ አደትꬅ ዎልቅቶ እንግደ ኦደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","የሱሳ ኡንታጎ፥ «ታኒ ይንታና ፈቲ ባዝ ኦጫነ፤ ይን ታስ ይኖ ማህኮ፥ ታንን አኮ አደትꬅ ዎልቃራ ኦችዛኮ ይንትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ዋሐንሳ ጽንቃተ አናፓ? ጾዛፓነ አሳፓ?» ያጋይዳ። ኡን ፋ ግዳ ዞርንት፥ «ኑ፥ ‹ጾዛፓ› ጋይኮ፥ ኤ ኑና፥ ‹ዬዝን አኮስ አማናንጽዶ?› ያጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ኑ፥ ‹አሳፓ› ጋይኮ፥ አስ ኡቡንꬅ ዋሐንሳ ናበ ማህ በእዘ ግሾ ኑ አሱንꬃና ዣሽታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ይኒ ግሾ፥ «ኑ ኤሮስ» ያጋእ ማህዳ። ኤዝን፥ «ይኬ፥ ታንን Ꮉኖ አኮ አደትꬅ ዎልቃራ ኦችዛኮ ይንትስ ኦሆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«የሱሳ ማህ Ꮉኒ ጋር ያጋይዳ፦ ላምእ ꬊራꬅ ናኡንꬅ የዘ ፈቲ አꬄ የነ። የ አꬄ ፈቲ ናአይጎ Ꮉንግ፥ ‹ታ ናአዮ፥ Ꮉይኖ ዎይነ ግዳ Ꮉንግ ኦቾ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ናአይ ማህ፥ ‹አቶ Ꮉንጎስ› ያጋይዳ። የዝን ሱባፓ ፋ ዎዝንተ ቆፒ ኦቾደስ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","አዳይ ፋ Ꮉንካይ ናአይጎ Ꮉንግ፥ ፋ ቲኖ ናአይጎ ጋይዳን ፋና ኪትዳ። ኤዝን፥ ‹የኤ፥ ታ አዳዮ› ያጋይዳ። የዝን Ꮉንግካያ። ");
INSERT INTO oyde_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ꮉንꬅ ላምእ ናኡንꬃፓ ፋ አዳይስ ኪትንትደ አዮ?» ያጋይዳ። ኡንትን፥ «ቲኖያ» ያጋይዳ። የሱሳ ኡንታጎ፥ «ታ ይንትስ ቱሮ ኦህነ፤ ቃራጠ ጋችዙንꬅን ኦላልዙንꬅ ይንታፓ ቲኒ ጾዘ ካእቱምቶ ገሎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ጻማቅዘ ዋሐንሳ ሉለ ኦገ ታማርስተራ ይእን ኤ ጋዛኖ አማንካያ። የዝን ቃራጠ ጋችዙንꬅን ኦላልዙንꬅ አማንዳ። ይን መለ አቶ የዝን፥ ኡንታና ብእ ይን ናጋርትፓ ማቂ አማንካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ማህ የሱሳ Ꮉኒ ጋር ያጋይዳ፤ «መለ አዝዘ ስኦተ፥ ዎይነ ቱክደ ፈቲ አꬄ የነ። የ ዎይንዘ ካንቶ ዉቱꬂ ጋስዳ። ዎይነ ጭጭዘ ኦላን ቦክዳ። ዎይንዛ ናጎደስ ሻኮን ሻክዳ። ይንፓ ሱባ፥ ጋድቶ ኮꬄ እንግ መለ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ዎይነ ኣፍቶ ማጽዘ አግና የልን ፋና የልዘ ባግቶ ኤኪ ኮኦደ ጋር ፋ አሩንꬃና ኡንታጎ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ኮꬄ እንግደ አዳይ ኤ አሩንꬃና አይኪ ፈታያ Ꮉꬍዳ፥ Ꮉንካያ ዎꬍዳ ማህ አትዱንꬃና ሹቻራ ꬎግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ዎይነ አታክልት አዳይ ቲኑንꬃፓ ኣꬍዘ መለ አሩንꬃና ኪትዳ። ኮꬄ ኤክዱንꬅ ኡንታና Ꮉንኩንꬃላ አፋ ኦችዳን ጋር ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ዉርሱꬅተ ኤ፥ ‹ታ ናአያ ኡን ቦንቾዳ!› ያጋእ ፋ ናአያ ኡንታጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«የዝን ጋድቲ አዳይ ናአያ ብእ ዎል ግዳ ‹ጋድቶ ላቶደ Ꮉያ፥ ኤዛ ዎꬊ ጋድቶ ኑ ኤኮዳ!› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ናአያ አይኪ ዎይነ ግድትፓ ጋጻ ኬሲ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«ይኬ፥ ዎይነ አታክልት ላꬄ የእዘ ዎደ የ ኮꬄ ኤክደ አዱንꬃና ዋይሳደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ኡን ማህ፥ «ኤ የ ኢታ አሱንꬃና ኢታ ዎ ዎꬊ፥ ዎይንዘ ኣፍዘ ዎደ ኤዛ የልዘ ባግቶ ዎደራ ዎደራ እንግዘ መለ አስስ ኮꬄ እንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","የሱሳ ማህ ኡንታጎ፥ ጾዘ ቃልተ፥ ኬጽዙንꬅ ለቂ እጽደ ሹችዘ፥ ማይዘነስ ኦማ ማቃነ፥ ኡባፓ ኣꬍዘ ሹች ማቃነ። ይኖ ላꬂ ኦችደባዝ፤ ኑ አፍትስ ጋማ ቆፍዘ ባዝ ጋእንት ጻፍንትዳኖ ናባብካተ? ");
INSERT INTO oyde_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«ይኒ ግሾ፥ ታኒ ይንትስ ኦህነ፤ ጾዘ ካእቱሞ ይንታፓ ኤክንቲ ሎኦ ኣፈ ኣፍዘ አሱንꬅስ እንግንቶዳ።  ");
INSERT INTO oyde_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ꮉይ ሹችዘላ አፋ ጎልእዘ ኡባ መቆዳ። ማህ Ꮉይ ሹችዘ ኤላ አፋ ዎꬍዘ አꬄን ጋጭንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ካህኑንꬅ Ꮉላቁንꬅን ፋርሳዉንꬅ የሱሳ ኦህደ አዝዝቶ ስእደ ዎደ ፋና ኦህዳኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ኡን የሱሳ አይኮደስ ኮይዳ፥ የዝን አሱንꬅ የሱሳ ናበ ማህ በእዘ ግሾ አሱንꬅስ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","የሱሳ አሱንꬅስ ማህ Ꮉኒ ጋር ያጋእ አዝዘ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«ጾዘ ካእቱሞ ፋ ናአይስ ዣጋና ጊግዝደ ካት አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","የ ካትዘ ዣጋና ዮኦደ ፋና ኦህ ጋድደ አሱንꬃና ጼጎደስ ፋ አሩንꬃና ኪትዳ። የዝን አሱንꬅ ዮኦደስ ኮይካያ። ");
INSERT INTO oyde_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ማህ መለ አሩንꬃና ጼጊ፥ ጼግንትደ አሱንꬃጎ Ꮉንግ፥ ‹ታኒ ታ ሳንጉንꬃናን ሞꬉንꬃና ሹክዳ፤ ኡባና ጊግዳ። ታ ዣጋና ድግሳጎ Ꮉንካ ዮኦተ ያጋኦተ› ያጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","የዝን ጼግንትዱንꬅ ጼግቶ እጺ፥ ፋ ኦቻ ኦቻ ቅትዳ። ፈታይ ፋ ዎታስ፥ Ꮉንካይ ፋ ዛልኤ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","መሉንꬅ ማህ ካት አሩንꬃና አይኪ፥ ኢሲ Ꮉꬊ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«ካትዘ ጋማ ዥልꬊ፥ ፋ ዎታዳሩንꬃና ዳኪ ሸምፖ ዎꬍዱንꬃና ዎꬍዝዳ፥ ኡን ካታምቶ ኤꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ይንፓ ሱባ፥ ፋ አሩንꬃጎ፥ ‹ዣጋንታ ጊግዳ፥ የዝን ጼግንትዱንꬅ ዣጋናስ ቤዘ አስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ይኒ ግሾ፥ ዳልጋ ኦገ Ꮉንግ፥ ደንግደ አስ ኡባ ዣጋና ዮኦደ ፋና ጼጎተ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","አሩንꬅን ኦገላ Ꮉንግ ፋስ ደንግደ አስ ኡባ ሎኡንꬃናን ኢቱንꬃና ክእ ዣጋና ዳሰ ገልꬂ ኩንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«የዝን ካትዘ ካꬃ ማአደስ በትደ አሱንꬃና በአደስ ገልደ ዎደ ዣጋና አፉላ ማእካይዘ ፈቲ አስ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ኤጎ፥ ‹ናተ፥ ነ ዣጋና አፉላ ማእካይዛራ ዋይዝ Ꮉነ ገልዶ?› ያጋይዳ። የዝን አꬄ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«ካትዘ ፋ አሩንꬃጎ፥ ‹Ꮉይ አꬄ ኩሽቶን ቶህቶ አጪ፥ ባለ ꬉማ ኬሲ ኦሎተ። እዘ ዬፎን አች ጋርጭንገ ማቆዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«ይኒ ፋናን፥ ጾዘ ካእቱሞስ ጼግንትዱንꬅ ጋማ የዝን ዶርንትዱንꬅ ኤራꬅ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ይንፓ ሱባ፥ ፋርሳዉንꬅ Ꮉንግ፥ የሱሳ ዋይዝ ኦሄራ አይኮድ የዛኮ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ፋ ታማሩንꬃናን ካት ሄሮድሳ ባጉንꬃፓ ፈታ ፈታ ኪትዳ። ኡንትን፥ «አስታማርዛዮ፥ ነ ቱሮ ኦህዛኖ ኑ ኤራነ። ነ አሳፓ አስ ሻጎስ፥ አስ ዎይጋንደስ ጋእ አኮን ኦቾስ፥ ጾዘ ኦግቶ ቱረትꬃራ ታማርሳነ። ");
INSERT INTO oyde_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","አነ ኑስ ኦሆ፥ ኑኒ ሮመ ካትስ ጊራ ጊሮደስ ቤዛነን ቤዞሳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","የዝን የሱሳ ኡን ኢታ ቆፍቶ ኤሪ፥ «Ꮉንꬅ ጩቡንꬆ፥ ታና አኮስ ፋታነተ? ");
INSERT INTO oyde_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ጊራ ጊርዘ ሚሸ ታና ቤዞተ» ያጋይዳ። ኡንትን ኤስ ድናረ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ኤ፥ «Ꮉይስ ሱንꬅታን ብሽታ ኦደሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ኡንትን፥ «ሮመ ካታይስ» ያጋይዳ። ዬዛኮ የሱሳ ኡንታጎ፥ «ይኬ፥ ካትስ ቤዛኖ ካትስ፥ ጾዝስ ቤዛኖ ጾዝስ እንጎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ኡንትን ይኖ ስእደ ዎደ ጋማ ቆፒ ኤ ካለፓ አሺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ይና ቃምተ Ꮉይቆፓ ደንዶ ባያ ያጋዘ ሳዱቃዉንꬅ የሱሳጎ ይእ፥ ያጋእ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«አስታማርዛዮ፥ ‹ሙሴ፥ ፈቲ አስ ናአ የልካይዛራ Ꮉይቅኮ፥ የ Ꮉይቅደ እሻይ ኤ ማችቶ ኤኪ፥ ፋ እሻይስ ናአ የሎ› ያጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ኑ ኤርዘ ላፑን እሹንꬅ የነ። አንግሰ ማቾ ኤኪ ናአ የልካይዛራ Ꮉይቂዳ። ኤ ማችቶ ኤ ጌዘ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ይኒ ፋና፥ የ ላምአንን፥ Ꮉይꬓንን፥ Ꮉንግ ላፑኑንꬆ የሎደስ። ");
INSERT INTO oyde_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ኡባፓ ሱባ ይና ማችታ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ዬዝን፥ ላፑኑንꬅ ኡቡንꬅ እዞ ማህደ ግሾ Ꮉይቆፓ ደንድዘ ቃማ፥ ይና ማችታ ላፑኑንꬃፓ አየ ማቾ ማቃደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","የሱሳ ማህ፥ «ይን ጾዘ ቃላን ኤ ዎልቅቶ ኤሮሰ ግሾ ባልንታነ። ");
INSERT INTO oyde_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","አሱንꬅ Ꮉይቆፓ ደንድዘ ዎደ ሳሎ የዘ ኪታንቹንꬅ ፋና ማቃነፕ አትን ኤኮስን ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ማህ Ꮉይቂደ አሱንꬅ Ꮉይቆፓ ደንዶደ ባዝ ጾዚ ይንትስ ኦህዳኖ ናባብካተ? ");
INSERT INTO oyde_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ጾዚ፥ ‹ታኒ አብራሃማ ጾዝ፥ ይሳቃ ጾዝ፥ ያይቆባ ጾዝ› ያጋይዳ። ይኒ ግሾ፥ ጾዚ ፋጻ የዙንꬅ ጾዛፕ አትን Ꮉይቂዱንꬅ ጾዝ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ጋማ አሱንꬅ ይኖ ስእ፥ ኤ ትምርትተ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","የሱሳ ሳዱቃዉንꬅስ ጋዉደ ባዝ ꬋብስዳኖ ፋራሳዉንꬅ ስእደ ዎደ ፈትላ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ኡን ግዳፓ ፈቲ ህገ አስታማርዘ የሱሳ ፋታና ኦጨ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«አስታማርዛዮ፥ ህገ ኡባፓ ኣꬍዘ አያ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","የሱሳ ማህ፥ ነ ላꬃ፥ ነ ጾዛ፥ ነ ኩሙꬅ ዎዝናፓ፥ ነ ኩሙꬅ ሸምፖፓ፥ ነ ኩሙꬅ ቆፋፓ ካꬎ። ");
INSERT INTO oyde_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ኡባፓ ኣꬍዘን ቲኖ ኪታ Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ላምእንꬃ ኡባፓ ኣꬍዘ ኪታ፥ አስ ኡባ ነ ኦምቶ ነ ካꬍዛን ፋና ካꬎ ያጋዛኖ። ");
INSERT INTO oyde_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ሙሴ ህገን ናቡንꬅ ትምርተ ኡባ Ꮉና ኪትላ አፋ ካታነ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ፋርሳዉንꬅ ፈትላ ሺቂ የዝን፥ የሱሳ ኡንታና፥ ");
INSERT INTO oyde_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«ክርስቶሳ ባዝ ይን ዋጋኤተ? ኤ ኦደ ናአ?» ያጋእ ኦጭዳ። ኡን፥ «ኤ ዳዉተ ናአ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","የሱሳ ኡንታጎ፥ «ዬዝን፥ ዳዉተ ጌሽ አያናራ ማቂ ዋይዝ ክርስቶሳ፥ ‹ላꬆ› ጋእ ጼገ? ዳዉተ ጋእተራ፥ ");
INSERT INTO oyde_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«ላꬂ ጾዚ፥ ታ ላꬄጎ፥ ነ ሞርኩንꬃና ነ ቶህታ የꬍዘ በሲ ማሆደ ዎንꬅስ፥ Ꮉነ ታፓ ምዛቅ ባጋራ በቶ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ይኬ፥ ዳዉተ ክርስቶሳ ላꬆ ጋእ ጼግኮ፥ ዋይዝ ክርስቶሳ ዳዉተ ናአ ማቀ? ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","የሱሳስ ፈቲ ቃላ ማሆደስ ዳንዳእደ አስ ኦደን ባያ። ማህ ይና ቃምትፓ ደንꬂ መለ ኦጨ ኦጮደስ ኦደን ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ይንፓ ሱባ፥ የሱሳ ሺቅደ አሱንꬅስን ፋ ታማሩንꬅስ Ꮉኒ ጋር ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«ህገ አስታማሩንꬅን ፋርሳዉንꬅ ሙሴ ህገ ታማርሶደስ አደትꬅ ዎልቃራ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ይኒ ግሾ፥ ኡን ይንታና ኪትደ ኡባ ኦችቶ ናጎተ። የዝን ኡን ኦችዛን ፋና ኦችፈተ። አኮስ ጋይኮ፥ ኡን ኦህዛንፋና ኦቾስ። ");
INSERT INTO oyde_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ኡን ቶኮደስ ዳንዳእንቶሰ ቶፎ አጪ አስ ቶሳነ። የዝን ፋስ መለ አቶ የዝን፥ የ ቶፍዛ አሱንꬅ ቶክዘ ዎደ ግልአ በርꬃራ ቦቾደስ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«የዝን ኡን ፋ ኦችቶ ኡባ አስ በአደ ፋና ኦቻነ። ፋ ስንተን ኩሽተ አጭዘ ማጻፈ ጽቅሰ የዘ ኪታፈ ዳልግዛነ፥ ፋ አፉልቲ ማጫርቶን ጳርግዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ሞክንትዘ በሳ ቦንቾ በስን አይሁደ ዎሳ ኬꬃ ጋማ ሎኦ ኦይዳ ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","አሱንꬅ ጋበ ኡንታና ቦንቾራ ሳርꬆዳኖን ‹አስታማርዛዮ› ጋእ ጼግዛኖ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«የዝን ይን አስታማርዘ ፈቶ ጻላላ ማቅደ ግሾን ይን ኡባ እሹንꬃና ማቅደ ግሾ ‹አስታማረ› ጋእንቲ ጼግንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ይንትስ ሳሎ ፈቲ አዳይ ጻላላ የዘ ግሾ Ꮉነ ሳአላ ኦደን ‹አዳዮ› ጋእ ጼግንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ይንትስ ፈቲ ላꬂ ክርስቶሳ ጻላላ የዘ ግሾ ‹ላꬆ› ጋእንት ጼግንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ይን ግዳ አንግስትዘ ይንትስ አሮ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ፋና ꬎቅ ዪዘ ኦደን ቶቾዳ፤ ፋና ቶችዘ ኦደን ꬎቅ ጋውዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«ይን፥ ጩቡንꬆ፥ ህገ አስታማሩንꬆ ፋርሳዉንꬆ፥ አሱንꬅ ቲኖ ሳሎ ካእቱሞ ጎርድዙንꬆ ይንታና ባደ። ይን፥ ይን ኦምተ ገሎስ ማህ መሉንꬃናን ገልꬆስ። ");
INSERT INTO oyde_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«ይን ጩቡንꬆ፥ ህገ አስታማሩንꬆን፥ ፋርሳዉንꬆ ቡዳኑንꬅ ኬꬅቶ ይን ቦንቅተ፥ አስ ቦኦ ጋእ ዎሳ ጳርግዛነ። ይኒ ግሾ ይንታና ባደ። ኡባፓ ኣꬍዘ ፍርዳ ይንታና ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«ይን፥ ጩቡንꬆ፥ ህገ አስታማሩንꬆ ፋርሳዉንꬆ፥ ይን ፈቲ አስ አማንꬆደስ አባራን ሳአራን ዉታነ። የዝን ይን ኤዛ አማንꬅደ ዎደ የ አꬃ ይንታፓ አꬂ ጋናመስ ጊግዘ ግሾ ይንታና ባደ። ");
INSERT INTO oyde_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«ኦደን ጾዘ ኬꬃራ ጫቂኮ አኮን ባያ። የዝን ጾዘ ኬꬃ የዘ ዎርቃራ ጫቂኮ፥ ይና ጫቅታ ኤዛ ጎሞዳ ጋዘ ቆቁንꬆ፥ ይንትስ ቆቂ መሉንꬃና ካልꬅዙንꬆ፥ ይንታና ባደ። ");
INSERT INTO oyde_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ይን፥ ኤዩንꬆ፥ ቆቁንꬆ፥ ዎርቃ አꬋነነ? ዎርቂዛ ጌሽዘ ጾዘ ኬꬅታ አ? ");
INSERT INTO oyde_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ማህ ‹ኦደን ዣርሾ ዣርሽዘ በስተ ጫቂኮ፥ አኮን ባያ። የዝን ኦደን ኤ ካታራ የዘ ዣርሽተ ጫቂኮ፥ ይና ጫቅታ ኤዛ ጎሞዳ› ያጋእ ታማርሳነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ይን፥ ቆቁንꬆ፥ ዣርሽታ አꬋነነ? ዣርሽቶ ጌሽዘ በስታ አ? ");
INSERT INTO oyde_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ይኒ ግሾ፥ ዣርሾ በስተ ጫቂዘ አꬄ፥ ይና ዣርሾ በስተን ኤላ አፋ የዘ ኡባነ ጫቃነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ጾዘ ኬꬃ ጫቂዘ አꬄ፥ ይና ጾዘ ኬꬅተን እዘ የዘ ጾዘላ ጫቃነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ሳሎ ጫቂዘ አꬄ ጾዘ አራትተን የ አራትዘላ በትደ ጾዘላ ጫቃነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«ይን፥ ጩቡንꬆ፥ ህገ አስታማሩንꬆን ፋርሳዉንꬆ፥ ይንታና ባደ። ይን ካርꬅ ጋላፓ፥ ናትራፓን ጻሎተፓ አስራታ ከሳነ። የዝን ህግተ የዘ ኣꬊ ኮሽዙንꬃና አሽዳ። ይናን ሉለ ፍርዳ፥ ማሮትꬅን ኡባ ባዛ አማንንተ። መሉንꬃናን አሽካይዛራ Ꮉንሳና ይን ኦቾደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ይንትስ ቆቂ መለ አስ ካልꬅዙንꬆ፥ ይን ኡሽትፓ ዉኑኖ ኬሲ ግማለ ቆꬋነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«ይን፥ ጩቡንꬆ፥ ህገ አስታማሩንꬆ ፋርሳዉንꬆ፥ ይንታና ባደ። ይን ቡርጩቆስን ሳነስ ካታ ዛልቶ ጌሻነ። የዝን ኡን ጋንጭተ ቦንቃን ቂራትꬅ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ናተ ቆቀ ፋርሳዉዛዮ፥ ቡርጩቆስን ሳነስ ጋንጭቶ ቲኒ ጌሾ። ይንፓ ሱባ፥ ካታ ዛልታን ጌሽ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«ይን፥ ጩብንꬆ፥ ህገ አስታማሩንꬆን ፋርሳዉንꬆ፥ ይንታና ባደ። ባለ ዛላራ ቦꬅ ቃላመ ትዥንቲ ሎእ፥ ጋንጭተ መቃꬅን ዎቅደባዝ ኩምደ ቦዛ ይን አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ይኒ ፋና፥ ካታ ዛላራ አስስ ሎኦ አዛነ። የዝን ይን ጋንጭተ ጩቦን ኢታትꬅ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«ይን፥ ጩቡንꬆ፥ ህገ አስታማሩንꬆን ፋርሳዉንꬆ፥ ይንታና ባደ። ይን ናቡንꬅስ ቦዛ ኬጻነ፥ ማህ ጽሉንꬅ ቦዛን ሎይꬃነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ማህ ይን፥ ‹ኑኒ ዛጋ ኑ አዱንꬅ ዎደ የዘ ባዝ ማቅዛኮ፥ ኡንታራ ዎላ ናቡንꬅ ሱꬅቶ ጉሳማ የሻ› ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ይኒ ግሾ፥ ይን ናቡንꬃና ዎꬍደ አስ ናኡንꬃና ማቅዳኖ ይን ይን ኦምተ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ይኬ፥ ይን አዱንꬅ አይክዳኖ ይን ፎሎተ። ");
INSERT INTO oyde_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Ꮉንꬅ ሾሹንꬆ፥ ጎፕ ናኡንꬆ፥ ይን ጋናመ ፍርዳፓ ዋይዝ አቶደ? ");
INSERT INTO oyde_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ይኒ ግሾ፥ ታ ኦህዛኖ ስኦተ፤ ታኒ ናቡንꬃና፥ ጭንጫ አሱንꬃናን አስታማሩንꬃና ይንታጎ ኪቶዳ። ኡንታፓ ፈታ ፈታ ይን ዎꬎዳን ማስቃላላ አፋ ሱጾዳ። ባጉንꬃና አይሁደ ዎሳ ኬꬃ አላንጋራ ጋራፎዳን ካታማፓ ካታማ ባይኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ይኒ ግሾ፥ ጽሎ አቤላ ሱꬃፓ ደንꬂ፥ ጾዘ ኬꬃፓን ዣርሾ በሳፓ ግድተ ይን ዎꬍደ ባራክያ ናአ ዛካርያሳ ዎደ የሎደስ Ꮉይቂደ ጽሎ አስ ኡባ ግሾ ይንታና የሎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ታኒ ይንትስ ቱሮ ኦህነ፤ ይንትን ይን አዱንꬅ ኦችደ ባልትስ Ꮉና ፍርድታ ኡባ Ꮉንꬅ የለቱንꬃላ የሎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«የሩሳላመ፥ የሩሳላመ፥ ናቡንꬃና ዎꬍዛነ! ጾዚ ኔጎ ኪትዱንꬃና ሹቻራ ꬎግዛነ! ሉኩለ ፋ ናኡንꬃላ አፋ ቀፈራ Ꮉጵዛን ፋና ታኒ ነ አሱንꬃና ታ ሹጵተ ሺሾደስ ዋንꬅ ቶሄ ኮይዶ! የዝን ታና ነ እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ይኬ፥ ይን ጾዘ ኬꬅታ ካይስ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ታኒ ይንትስ ኦህነ፤ ‹ላꬄ ሱንꬅተ የእዘ አንጅንትዳያ› ይን ጋኦደ ዎንꬅስ ላምእንꬃ ታና ቦኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","የሱሳ ጾዘ ኬꬃፓ ኬዚ ቅትዝን፥ ኤ ታማሩንꬅ ኤጎ ይእ፥ ጾዘ ኬꬅ ግምብቶ ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","የሱሳ ኡንታጎ ማህ፥ «ዬ! Ꮉኖ ኡባኖ በእነተ? ታኒ ይንትስ ቱሮ ኦህነ፤ ሹች ሹቻላ አፋ ኬልንትደ ፋና ፈትን ዉልእንትካይዛራ አቶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","የሱሳ ሻማሄ ደረላ አፋ በቴዝን፥ ኤ ታማሩንꬅ ፋ ጻላላ ኤጎ ይእ፥ «ይና አይደ Ꮉኖድ የዛኮ ኑስ ኦሆ። ማህ ነ የእትስን ዎደ ዉርሱꬅትስ ማላ አኮ? ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","«የሱሳ ማህ፥ ይንታና ኦደን ባልꬃመ ፋና ናግንቶተ! ");
INSERT INTO oyde_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","አኮስ ጋይኮ፥ ጋማ አሱንꬅ ታ ሱንꬅተ፥ ‹ታኒ ክርስቶሳ፥ ጾዚ አስ አሾደስ ኪትዳያ› ያጋይትራ ይእ ጋማ አስ ባልꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ይን ኦላን ኦላ ዎረ ስኦደስ የነ። ይኒ ጋርዘ ባዝ Ꮉኖደስ ቤዝዘ ግሾ ይርግፐተ። የዝን ዉርሱꬅታ Ꮉጋ። ");
INSERT INTO oyde_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ዎርዣ ዎርዣራ፥ ፈቲ ካእቱሞ መለ ካእቱሞራ ኦልንቶዳ። ናየን ሳአ ኤንኤ ዱማ ዱማ በሳ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ይና ኡባና የሎ ꬋኤስ ዞቀ ፋና። ");
INSERT INTO oyde_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«የ ዎደ አሱንꬅ ይንታና ዋየስ አꬂ እንጎዳ፥ አጮዳን ዎꬎዳ። ታ ሱንꬅት ግሾ አስ ኡባ ይንታና እጾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","የ ዎደ ጋሙንꬅ አማኖ አሾዳ። ፋ ግዳ ፈተ ፈታያ አꬂ እንጎዳ፥ ፈተ ፈታያ እጾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ማህ ጋማ ዎርዶ ናቡንꬅ ደንዲ ጋሙንꬃና ባልꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ኢታትꬅ ጋንግዘ ግሾ ጋማ አሱንꬅ ሲቅታ ቶዮዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","የዝን ዉርሱꬅ የሎደስ ገንጭደ አꬄ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","አስ ኡባስ ማርካ ማቃደ ፋና ጾዘ ካእቱሞ ዎንገለ ሳአ ኡባ ኦህንቶዳ። ይንፓ ሱባ፥ ዉርሱꬅታ ዮኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«ይኒ ግሾ፥ ናብዘ ዳነላ ኦህደ ꬋብሰ ቱናትꬅ ጌሽ በሳ ኤቅዳያ ይን ቦኦዳ። ቆፕዘ ይና ዋግዛኮ ናባብዘ ቆፖ! ");
INSERT INTO oyde_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ይኒ ዎደ ይሁዳ ሳአ የዙንꬅ ደረጎ ዎጾ። ");
INSERT INTO oyde_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ፎቀላ አፋ የዘ አꬄ ፋ ኬꬅተ የዘ ባዝ ኤኮደስ ኬꬃ ገላንጽ ዎጾ። ");
INSERT INTO oyde_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ጋደ የዘ ፋ ማኦ ኤኮደስ ሱብ ማቅፐ። ");
INSERT INTO oyde_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","የ ዎደ ዎዳꬅ ማቹንꬅን ꬋንꬅዘ ማቹንꬅስ ጋማ ኡንእንተ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ባርጎ ዎይ ሳምባታ ይን ዎጺ ꬋብዛና ማቃመ ፋና ጾዝ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","አኮስ ጋይኮ፥ ሳአ መꬍንትዳንፓ Ꮉይኖ የሎደስ Ꮉንካይዘ ባዝ፥ ማህ ቲኖስን ሙሎ Ꮉኖሰ ማꬋ Ꮉኖዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ይና ቃምት ፋይድቶ Ꮉትꬅካይዛኮ አስ ማቅደ ኦደን አቶስ። የዝን ኤ ፋ ዶርደ አሱንꬅ ግሾ ይና ቃምት ፋይድቶ Ꮉትꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«የ ዎደ ኦደን ይንታና፥ ‹ይኬ፥ ክርስቶሳ Ꮉነ› ዎይ ‹ሰካ የነ› ያጋይኮ አማንፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","አኮስ ጋይኮ፥ ዎርዶ ክርስቶሱንꬅን ዎርዶ ናቡንꬅ ደንዶዳ። ኡንትስ ዳንዳእንትኮ፥ መለ አቶ የዝን ጾዝስ ዶርንትዱንꬃና ባልꬆደስ ዳማ ማላን ጋማ ቆፍዘ ባዝ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ቆፖተ፥ ታ ይንትስ Ꮉኖ ቲኒ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«ይኒ ግሾ፥ አሱንꬅ ይንታጎ፥ ‹ይኬ፥ ክርስቶሳ አኮ ባይዘ ጋናስ ሳአ የነ› ጋይኮ፥ እዘ Ꮉንግፐተ። ዎይ ይንታጎ፥ ‹ይኬ፥ ቆልአ የነ› ጋይኮ፥ ኡንባዝ አማንፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","አኮስ ጋይኮ፥ ዜልንꬅ ሳሎ ዜልንጊ፥ አዋ ከሳፓ ገሎ የሎደስ በንትዛን ጋር፥ አስ ናአ የእታ ይኒ ጋር ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","«ባዉታ የዘ በሳ አንኩንꬂ ሺቆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«የ ዎደ ይና ዋየ ቃምትፓ ሱባ፥ «ኢራ አዋ ꬉሞዳ፥ አግናን ፋ ፎእቶ ካዮዳ። ጾልንቶን ሳሎፓ ዎꬎዳ፥ ማህ ሳሎ የዘ ዎልቃ ቡቁንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","የ ዎደ አስ ናአ የኤ ማላ ሳሎላ አፋ በንቶዳ። ሳአ የዘ አስ ኡባ ዬኮዳ። ማህ አስ ናአይ፥ ዎልቃራን ዳማ ቦንቾራ ሳሎ ꬎነ ግዳራ ዬዝን ይን ቦኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ኤ ፋ ኪታንቹንꬃና ዳማ ፉግዘ ሞይዘራ ኪቶዳ። ኡን ሳአ ኦይዲ ዛላ ቅቲ፥ Ꮉይጋ ጋጻፓ ሰኮ ጋጻ የሎደስ የዘ ኤስ ዶርንትዱንꬃና ሺሾዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«በለሰ ምንጻፓ ታማሮተ። እዛ ኣጪ Ꮉየ ኬስዘ ዎደ ቶርቼ ኡክዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ይኒ ጋራን፥ ይን Ꮉኖ ኡባ በእዘ ዎደ ፉርꬃ ኡክዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ታኒ ይንትስ ቱሮ ኦህነ፤ Ꮉና ኡባና ፎልንቶደ ዎንꬅስ፥ Ꮉና የለቱንꬅ አꬋማ። ");
INSERT INTO oyde_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ሳሎን ሳአን አꬎዳ፥ የዝን ታ ቃልታ አꬎኦስ። ");
INSERT INTO oyde_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«ይና ቃምቶን ይና ሳቶ ሳሎ የዘ ታ አዳይፕ አትን መለ ሳሎ ኪታንቹንꬃና ማቅን ዎይ ናአያ ማቅን ኦደን ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","አስ ናአ የእታ፥ ኖሄ ዎደ Ꮉንዳን ጋር ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","የ ዎደ ꬋብሰ Ꮉꬅ ዮኦደፓ ቲኖ ኖሄ ማርካበ ገልደ ቃማ የሎደስ፥ አሱንꬅ ሙእተን ኡዥተ፥ ኤክተራ ገልተራ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ꬋብሰ Ꮉꬅ ይእ፥ ኡንታና ኡባ ꬋብሶደ ዎንꬅስ ቆፕካያ። አስ ናአ የእታን ይኒ ፋና ይአዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«የ ዎደ ላምእ አሱንꬅ ጋደ ኦቾዳ። ኡንታፓ ፈታይ ኤክንቶዳ፥ Ꮉንካይ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ላምእ ማቹንꬅ ዎላ ጋጮዳ። ኡንታፓ ፈታ ኤክንቶዳ Ꮉንካና አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«ይኬ፥ ይን ላꬄ አኮ ቃማ ዮኦድ የዛኮ ይን ኤሮሰ ግሾ ሚንግ ናጎተ። ");
INSERT INTO oyde_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","የዝን ካይዞ ቃማፓ አኮ ሳተ ዮኦደ የዛኮ ካርቲ አዳይ ኤርዛኮ፥ ፋ ኬꬅታ ቦክንታመ ፋና ባርክ ናጎዳ የሻ። ");
INSERT INTO oyde_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ይኒ ጋራን፥ አስ ናአይ ይን ቆፕካይዘ ሳተ ዮኦደ ግሾ ይን ጊጊ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«ዬዝን፥ ፋ ካራ አሱንꬅስ ካꬃ ኮሽዘ ዎደ እንጎደ ፋና ኤ ላꬅዘ ዶርደ አማንንትዘን ዎዝናራ የዘ አሮ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ኤ ፋ ላꬄ ኪትዳኖ ኦችዝን ኤ ላꬄ ይእ ደንግደ አርዘ አንጅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ታኒ ይንትስ ቱሮ ኦህነ፤ ላꬂ የ አርዛ ፋ ባዝትላ ኡባ ሹሞዳ። ");
INSERT INTO oyde_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","የዝን የ አርዘ ኢታ ማቅኮ፥ ‹ታ ላꬄ ጋምእ ዮኦዳ› ያጋእ ፋ ዎዝንተ ቆፒ፥ ");
INSERT INTO oyde_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ፋ ላገ ኦችዙንꬃና Ꮉ አይክኮ፥ ማꬅንትዙንꬃራ ሙይኮ ኡዥኮ፥ ");
INSERT INTO oyde_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","የ አርዘ ላꬄ ኤ ቆፕካይዘ ቃማን ኤ ኤሮሰ ሳተ፥ ");
INSERT INTO oyde_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ይእ ኤዛ ጋቾዳ። ኤ እጽቶን ጩቡንꬃራ ማሆዳ። ይና በስተ ኤስ ዬፎን አች ጋርጭንገ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«የ ዎደ ሳሎ ካእቱሞ ፋ ኩራዝቶ አይኪ፥ ማቾ ኮኦደስ ቅትደ ꬊራꬃያ ሞኮደስ ከዝደ ታጵ ዉዱሩንꬃና አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ኡንታፓ እችኑንꬅ ቦዛ፥ ማህ እችኑንꬅ ጭንጫ። ");
INSERT INTO oyde_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ቦዙንꬅ ኩራዘ አይክዳ፥ የዝን መለ ላምባ አይክካያ። ");
INSERT INTO oyde_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","የዝን ጭንጩንꬅ ፋ ኩራዝተ መለ ጉጃ ላምባ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ማችቶ ኤክዘ ጋምእን፥ የንꬅ ዉዱሩንꬅ ገንቶ አይክን ገንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«ግዲ ብላሄ ማቅዘ ዎደ ‹ይኬ፥ ማችቶ ኤክዛይ የልዳ፥ ኤዛ ሞኮደስ ከዞተ› ያጋዘ ዳማ ደንꬅꬅዘ ኪታ ስንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«የ ዎደ የንꬅ ዉዱሩንꬅ ኡቡንꬅ ባርክ፥ ፋ ኩራዝቶ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ቦዙንꬅ ጭንጩንꬃጎ፥ ‹ኑ ጾምፕታ Ꮉይቆደስ ዪዘ ግሾ ሻጊ ይን ላምቢትፓ ኑስ እንጎያተ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«የዝን ጭንጩንꬅ ኡንታጎ ማህ፥ ‹አደ፥ ኑስን ይንትስን ማቅዘ ላምባ ባያ። ይኒ ግሾ፥ ይንትስ Ꮉንግ ዎንግ ኤኮተ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ቦዛ ዉዱሩንꬅ ላምባ ዎንጎደስ ቅትን፥ ማችቶ ኤክዘ ይእዳ። ጊግንቲ በትደ እችን ዉዱሩንꬅ ኤራ ዎላ ዣጋና ኬꬃ ሙስስ ገልዳ፤ ፉርꬅቶን ጎርዲ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«ሱባፓ Ꮉንኮ ዉዱሩንꬅ ይእ፥ ‹ላꬆ፥ ላꬆ፥ ኑስ ቡጎያ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«የዝን ኤ ኡንታጎ ማህ፥ ‹ታኒ ይንትስ ቱሮ ኦህነ፤ ታ ይንታና ኤሮስ!› ");
INSERT INTO oyde_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«ይኬ፥ አስ ናአ ዮኦደ ቃምቶ ዎይ ሳቶ ይን ኤሮሰ ግሾ ባርክ ናጎተ። ");
INSERT INTO oyde_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«ሳሎ ካእቱሞ ፋ ኦችዙንꬃና ጼጊ ፋስ የዘ ባዝ ኡንትስ እንግ ኦገ ቅቶደስ ከዝደ አꬃ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ኡንትስ ኦማራ ኦማራ ኡን ዎልቅት ጋር ፈታይስ እችን መክሊተ፥ ፈታይስ ላምእ መክሊተ ማህ ፈታይስ ፈቲ መክሊተ እንግ ፋ ኦገ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","እችን መክሊተ ኤክደ አርዘ ኢራ Ꮉንግ ዛልእ፥ መለ እችን መክሊተ ትርፍዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ይኒ ጋር፥ ማህ ላምእ መክሊተ ኤክደ አርዘ መለ ላምእ ትርፍዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","የዝን ፈቲ መክሊተ ኤክዳይ Ꮉንግ፥ ኦላ ቦኪ፥ ፋ ላꬅዘ ብርዛ ሞግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«ጋማ ዎደፓ ሱባ የንꬅ አሩንꬅ ላꬄ ይእ፥ ፋ ሚሽቶ ኡንታራ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","እችን መክሊተ ኤክደ አርዘ ይእ፥ መለ እችን መክሊተ ክእ፥ ‹ታ ላꬆ፥ ነ ታስ እችን መክሊተ እንግዳ። የዝን ታኒ መለ እችን መክሊተ ትርፍዝዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ኤ ላꬄ፥ ‹ዛምባይ! ነ ሎኦን አማንꬅዘ አሮ፤ ነ ኤራꬅ ባዛ አማንንትዳ። ታኒ ነና ጋማ ባዛላ አፋ ሹሞዳ፤ Ꮉነ ገሊ ነ ላꬄራ ኡፋይቶ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«ማህ ላምእ መክሊተ ኤክዳይ ይእ፥ ‹ታ ላꬆ፥ ነ ታስ ላምእ መክሊተ እንግዳ። የዝን ታኒ መለ ላምእ መክሊተ ትርፍዝዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ኤ ላꬄ፥ ‹ዛምባይ! ነ ሎኦን አማንꬅዘ አሮ፤ ነ ኤራꬅ ባዛ አማንንትዳ። ታኒ ነና ጋማ ባዛላ አፋ ሹሞዳ፤ Ꮉነ ገሊ ነ ላꬄራ ኡፋይቶ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«ማህ ፈቲ መክሊተ ኤክዳይ ይእ፥ ‹ታ ላꬆ፥ ነ ቡድካይዛራ ማጽዛን ቡርግካይዛራ ሺሽዘ ኢታ አስ ማቅዳኖ ታ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ይኒ ግሾ፥ ዣሽቲ ነ መክሊትዛ ሳአ ሞግዳ። ነ መክሊትዘ Ꮉይንሸ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«ኤ ላꬄ ማህ፥ ‹Ꮉይ ኢታ አዛልአ አርዛዮ፥ ታኒ ቡድካይዛራ ማጽዛኖን ቡርግካይዛራ ሺሽዘ አስ ማቅዳኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ዬዝን፥ ነ ታ መክሊትዛ ባንከ ጋደዛኮ፥ ታኒ ማቅዘ ዎደ ታ መክሊትዛ ትርፈራ ኤኮዳኖ ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ይኒ ግሾ፥ መክሊትዛ ኤፓ ኤኪ፥ ታጵ መክሊተ የዘስ እንጎተ። ");
INSERT INTO oyde_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","አኮስ ጋይኮ፥ የዘ ኡቡንꬅስ ጉጅንቶዳን ጋንጎዳ። የዝን ባይዘፓ መለ አቶ የዝን፥ የ ኤስ የዛይን ኤክንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ꮉይ ማዶሰ አርዛ ባለ ꬉማ ኬሲ ኦሎተ። እዘ ኤስ ዬፎነ አች ጋርጭንገ ማቃዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«አስ ናአ፥ ኪታንቾ ኡቡንꬃራ፥ ፋ ቦንቾራ የእዘ ዎደ ኤ ፋ ቦንቾ ካእቱሞ አራታላ በቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ሳአ የዘ አስ ኡባ ኤ ቲኖ ሺቆዳ። ዉደ አዳይ ዱሩንꬃና ዴሹንꬃፓ ሻክዛን ፋና ኤ የ አሱንꬃና ላምእ በሳ ሻጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ማህ ዱሩንꬃና ምዛቅ ዛላራ ዴሹንꬃና ዎርክታ ዛላራ ኤሶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«ይንፓ ሱባ፥ ካትዘ ምዛቅ ዛላራ የዙንꬃጎ Ꮉኒ ፋና ያጋዉዳ፦ ‹ታ አዳይ አንጅዱንꬆ፥ Ꮉንካ ይእ ሳአ መꬍንትዘ ዎደ ይንትስ ጊግደ ካእቱምቶ ላቶተ። ");
INSERT INTO oyde_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","አኮስ ጋይኮ፥ ታኒ ናይꬍን ሙዝዳ፥ ባርꬍን ኡሽዳ፥ ዛቆ አስ ማቂ ይእን ሞክዳ፥ ");
INSERT INTO oyde_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ካልꬍን ማእስዳ፥ Ꮉርግንትን ኦጭዳ፥ አጭንትን ታና ኦጭዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«ይንፓ ሱባ፥ ጽሉንꬅ ማህ፥ ‹ላꬆ፥ ነ ናይꬍን አይደ ብእ ሙዝዶ? ዎይ ነ ባርꬍን አይደ ብእ ኡሽዶ? ");
INSERT INTO oyde_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ነ ዛቆ ማቂ ይእን አይደ ብእ ሞክዶ? ዎይ ነ ካልꬍን አይደ ማይዝዶ? ");
INSERT INTO oyde_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ነ Ꮉርግንትን ዎይ አጭንትን ኔጎ Ꮉንግ ነና አይደ ኦጭዶ?› ያጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ካትዘ ማህ፥ ‹ታኒ ይንትስ ቱሮ ኦህነ፤ ይን ታና ካልዘ Ꮉንꬅ እሹንꬃፓ ኤርዘስ ኦችዳና ታስ ኦችዳ› ያጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«የ ዎደ ዎርክታ ዛላራ የዙንꬃጎ፥ ‹Ꮉንꬅ ባድንትዱንꬆ፥ ታ ካለፓ Ꮉኮተ። ጻላሄስን ኤ ኪታንቹንꬅስ ጊግደ መዽና ታማ ቅቶተ። ");
INSERT INTO oyde_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","አኮስ ጋይኮ፥ ናይꬍን ታና ሙዝካያ፤ ባርꬍን ኡሽካያ። ");
INSERT INTO oyde_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ታኒ ዛቆ ማቂ ይእን ታና ሞክካያ፥ ካልꬍን ማይዝካያ፥ Ꮉርግን አጭንትን ታና ኦጭካያ ያጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«የ ዎደ ኡን፥ ‹ላꬆ፥ ነ ናይꬍን ዎይ ባርꬍን ዎይ ዛቆ ማቂ Ꮉንግን ዎይ ካልꬍን ዎይ Ꮉርግን ዎይ አጭንትን ብእ ነና አይደ ማዳንጽ እጽዶ?› ያጋእ ማሆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«የ ዎደ ካትዘ ማህ ኡንታጎ፥ ‹ታኒ ይንትስ ቱሮ ኦህነ፤ ይን ታና ካልዘ Ꮉንꬅ ኡቡንꬃፓ ኤርዛያ ማዳንጽ እጽኮ፥ ታና ማዳንጽ እጽዳያ› ያጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ይኒ ግሾ፥ የንꬅ አሱንꬅ መዽና ፍርዳስ ማህ ጽሉንꬅ መዽና ደኦስ ቅቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","የሱሳ ይና ትምርትቶ ኡባ Ꮉስደ ዎደ ፋ ታማሩንꬃጎ፥ ");
INSERT INTO oyde_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ላምእ ቃማፓ ሱባ፥ ፋስካ ባአለ ቦንችዘ ቃማ ማቅዛኖ ይን ኤራነ። ይና ቃምተ አስ ናአይ ማስቃላላ አፋ ሱጹንቶደስ አስ ኩሸ ኣꬊ እንግንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","የ ዎደ ካህኑንꬅ Ꮉላቁንꬅን ጭሙንꬅ፥ ቃያፋ ጋዘ ካህኑንꬅ Ꮉላቅዘ ኬꬃ ሺቂ፥ ");
INSERT INTO oyde_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","አስ ኤርካይዝን የሱሳ አይኪ፥ ዎꬎደስ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","የዝን ኡን፥ «አሱንꬅ ግዳ ካች ደንዳመ ፋና ጋእ፥ ፋስካ ቦንችዘ ቃማ ማቅፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","የሱሳ ብታንያ ካታማ ቁርሱማ Ꮉርግደ ስሞና ካራ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","የሱሳ ሌማተላ የዝን ፈቲ ማችታ አልባስጥሮሰ ብልቃጠ ኩሙꬅ ጋማ አልኦ ሽቶ ኤኪ ይእ የሱሳ ኦምተ ጉስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","የዝን የሱሳ ታማሩንꬅ ይኖ ብእ ዥልꬊ፥ «Ꮉና ሽትታ Ꮉሪ ኢትዛና አኮሶ? ");
INSERT INTO oyde_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ꮉና ሽትታ አልኦ ዋጋስ ባይዝንቲ፥ ብርታ ዳሁንꬅስ እንግንቶደስ ዳንዳእንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","የሱሳ ኡን ጋዛኖ ኤሪ፥ ኡንታጎ፥ «Ꮉና ማችቶ አኮስ ዋይተ? እዛ ታስ ሎኦ ባዝ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ዳሁንꬅ ኡባ ዎደ ይንታራ የሳዳ። የዝን ታኒ ይንታራ ኡባ ዎደ የዞስ። ");
INSERT INTO oyde_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","እዛ Ꮉና ሽትቶ ታላ አፋ ጉስዳና ታና ሞጎደስ ጊግሳደስ። ");
INSERT INTO oyde_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ታኒ ይንትስ ቱሮ ኦህነ፤ ሳአ ኡባ Ꮉይ ዎንገልዘ ሳባክንትዘ በሳ አባን፥ አሱንꬅ እዞ ኦሆደ ጋር እዛ ኦችዳና ኦህንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","የ ዎደ ታጶ ላምእ የሱሳ ታማሩንꬃፓ ፈታይ፥ የስቆሮቱ ሳአ ይሁዳ ጋእንትዘ ካህኑንꬅ Ꮉላቁንꬃጎ፥ ");
INSERT INTO oyde_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ꮉንግ፥ «ታኒ ይንትስ የሱሳ አꬂ እንግኮ፥ ይን ታስ አኮ እንጎደ?» ያጋእ ኡንታና ኦጭዳ። ኡን ዞርንት Ꮉስታም ሹች ብራ ሳንትመ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ይንፓ ሱባ፥ ይሁዳ የሱሳ አꬂ እንጎደስ ዎትዘ ዎደ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ቦራ ባአለ ቦንችዘ ቲኖ ቃማ፥ የሱሳ ታማሩንꬅ ኤጎ ይእ፥ «ፋስካ ቦንችዘ ቃማ ነ ማአደ ካꬃ ኑ አባ ጊግሳደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","የሱሳ ኡንታጎ፥ «ካታማ የዘ አꬄጎ Ꮉንግ፥ ‹አስታማርዘ፥ ታስ ዎደ የልደ ግሾ ታ ታማሩንꬃራ ፋስካ ቦንችዘ ቃማ ነ ካራ ኣꬆዳ ጋይዳ› ያጋኦተ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ኤ ታማሩንꬅ የሱሳ ፋና ኪትዳን ፋና ኦቺ፥ ፋስካ ባአለ ቃማ ማአደ ካꬃ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ሳእታ ኡጉርዘ ዎደ የሱሳ ታጶ ላምእ ሐዋሩንꬃራ ካꬃ ማአደስ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ኡን ሙዝን፥ የሱሳ ኡንታጎ፥ «ታኒ ይንትስ ቱሮ ኦህነ፤ ይንታፓ ፈቲ አꬄ ታና አꬂ እንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ኡን ጋማ ታኒ፥ ፈተ ፈተ፥ «ላꬆ፥ ቱሮ ታና የሳነ?» ጋእ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","የሱሳ ማህ፥ «ፋ ኩሽቶ ታራ ዎላ ጋባተ ዳክዛይ ኤ ታና አꬂ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","አስ ናአ፥ ጾዘ ቃልተ ኤስ ጻፍንትዳን ጋር Ꮉይቆዳ። የዝን አስ ናአ አꬂ እንግዘ አꬃ ባደ፤ የ አꬄ የልንትካይዛራ አተዛኮ ኤስ ሎኦ የሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ኤዛ አꬂ እንጎደስ የዘ ይሁዳ ማህ፥ «አስታማርዛዮ፥ ነ ጋዘ ታናነ?» ያጋይዳ። የሱሳ ማህ፥ «ነ ጋይደ ፋና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ኡን ሙዝን፥ የሱሳ ዳቦ ቦራ ኤኪ ጾዝ ጋላትዳ። የ ቦርዛ ባጺ ፋ ታማሩንꬅስ እንግ፥ «Ꮉተ፥ ሞኦተ፥ Ꮉና ታ አሽቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ኡሽቶን ኤኪ፥ ጾዝ ጋላትዳ። ኡንትስ እንግ፥ «ኡቡንꬅ Ꮉንፓ ኡዦተ። ");
INSERT INTO oyde_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ꮉና ጋማ አሱንꬅ ናጋርታ አቶ ጋእንቶደ ፋና ላንትዘ ታ ሱꬅቶ። Ꮉና ሱꬅታ ጾዚ ይንታራ ገልዘ ክለ ጫቅቶ። ");
INSERT INTO oyde_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","የዝን ታኒ ይንትስ ኦህነ፤ ታኒ ታ አዳይ ካእቱሞ ክለ ዎይነ ኡሽ ይንታራ ኡሻደ ቃማ የሎደስ ማህ Ꮉኖ ዎይነ ኡሽቶ ኡዦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ጋላታ ማዝሙረ የጽደፓ ሱባ ሻማሄ ደረ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","የ ዎደ የሱሳ ኡንታጎ፥ «‹ጾዚ የንግዛያ ጉዶዳ ዱርንꬅን ላልንቶዳ› ጋእንት ጾዘ ቃልተ ጻፍንትዳን ጋር Ꮉይኖ ቃማ ይን ኡቡንꬅ ታና አሺ ላልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","የዝን ታኒ Ꮉይቆፓ ደንድዳንፓ ሱባ ይንታፓ ቲኒ ጋልላ ቅቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ጴጥሮሳ ማህ፥ «ኡን ኡባና ነና አሺ ካድኮን፥ ታኒ ነና ካዶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","የሱሳ ጴጥሮሳጎ፥ «ታኒ ኔስ ቱሮ ኦህነ፤ Ꮉይኖ ቃማ ሉኩለ ኦሎዳንፓ ቲኖ ነ ታና Ꮉይꬕ ቶሄ ካዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ጴጥሮሳ ማህ፥ «ታኒ ኔራ ዎላ Ꮉይቀፕ አትን ነና ሙሎን ካዶስ» ያጋይዳ። Ꮉንኮ ኤ ታማሩንꬅ ኡባ ይኒ ፋና ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","የ ዎደ፥ የሱሳ ፋ ታማሩንꬃራ ጌተሰማነ ጋዘ በስተ Ꮉንግ፥ ኡንታጎ፥ «ታኒ ጎደ Ꮉንግ ጾዝ ዎሶዳ፥ ይን Ꮉነ በቶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ጴጥሮሳን ዛብድዮሳ ናኡንꬃና ላምኡንꬃና ፋራ ኤኪ Ꮉንግ ጋማ አዛኖራ ኡንእንተ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ማህ ኡንታጎ፥ «ታኒ Ꮉይቆስ የልꬅዘ ኡንአ ኡንእንትዳ። Ꮉነ ጋምኦተ ታራ ሚንግ ናጎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ኤራꬅ ቲኖ Ꮉንግ ሳአ ቡንቁንቲ፥ «ታ አዳዮ፥ ዳንዳእንትዘ ባዝ ማቅኮ Ꮉና ዋየ ጹኡቶ ታፓ Ꮉሶ። የዝን ነ ቆፍታ Ꮉኖፕ አትን ታ ቆፍታ Ꮉንፐ» ያጋእ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","የሱሳ ፋ ታማሩንꬃጎ ማቂ ይእ ኡን ገንተዝን ደንግዳ። ጴጥሮሳጎ፥ «ይን ፈቲ ሳተ የዛኮን ታራ ሚንግ ናጎደስ ዳንዳኦሳ? ");
INSERT INTO oyde_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ፋታና ይን ገላመ ጋር ባርክ ናጎተን ጾዝ ዎሶተ። አያና ጊግንትዳ፥ የዝን አሾ ላቢꬅ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","የሱሳ ማህ ላምእንꬃ Ꮉንግ፥ «ታ አዳዮ፥ ታኒ Ꮉና ዋየ ጹኡዘፓ ኡዥካይዛራ አꬎደስ ዳንዳእንቶሳ ማቅኮ ነ ቆፍታ Ꮉኖ» ያጋእ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ማህን ማቂ ይእዘ ዎደ ኤ ታማሩንꬅ ኣፍቶ ገንቶ ጎዝን፥ ዎይኤዝን ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ማህ ኡንታና አሺ Ꮉንግ፥ ቲኖ ቃልቶ ማህ Ꮉይꬕንꬃ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ይንፓ ሱባ፥ ፋ ታማሩንꬃጎ ይእ፥ «Ꮉኖ የሎደስ ገንቲ ሸምፒ የነ? ይኬ፥ አስ ናአ፥ ናጋራንቹንꬅ ኩሸ ኣꬊ እንግንትዘ ሳተ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ደንዲ የꬎተ፥ ታና አꬂ እንግዘ Ꮉይንሸ የልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","የሱሳ Ꮉጋ ኦህዝን፥ ታጶ ላምእ ታማሩንꬃፓ ፈታይ፥ ይሁዳ የልዳ። ካህኑንꬅ Ꮉላቁንꬅን ጋደ ጭሙንꬅ ኪትደ ጋማ አሱንꬅ ማሻን ጉፈ አይኪ ኤራ ዎላ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","የሱሳ አꬂ እንግደ ይሁዳ የ ጋማ አሱንꬃጎ፥ «ታኒ ዬርዛይ ይን ኮይዘ ኤዛ፥ ኤዛ አይኮተ» ያጋእ ማላ እንግ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ኢራ የሱሳጎ ሺቂ፥ «አስታማርዛዮ፥ ሳሮ ኔስ ማቀ» ያጋእ ኤዛ ዬሪዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","የሱሳ ኤጎ፥ «ታ ላግዛዮ፥ ነ Ꮉነ አኮስ ይእዶ?» ያጋይዳ። ይንፓ ሱባ፥ ሺቂ፥ የሱሳ ኩሸራ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","የሱሳራ የዙንꬃፓ ፈታይ ፋ ማሽቶ ሾዲ ካህኑንꬅ Ꮉላቅዘ አርዛ ጉዲ፥ ኤ Ꮉይቶ ጋቺ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","የዝን የሱሳ፥ «ነ ማሽቶ ሱባ ሾክተ ማሆ። አኮስ ጋይኮ፥ ማሻ ሾድዘ ኡባ ማሻራ Ꮉይቆዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ታ፥ ታ አዳያ ዎስዛኮ ታጶ ላምእ ሙኩላፓ ኣꬍዘ ኪታንቹንꬃና ዳኮደስ ዳንዳኦሳ ኔስ አዛነ? ");
INSERT INTO oyde_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ዬዝን፥ ጾዘ ቃልተ ይኒ ጋር Ꮉኖደስ ቤዛነ ጋይንትዳና ዋይዝ ፎልንቶደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ይና ሳተ፥ የሱሳ የንꬅ ሺቅደ ጋማ አሱንꬃጎ፥ «ታና ፋኖ ማህ አይኮደስ ማሻን ጉፈ አይኪ ይእዳተ? ታኒ ጾዘ ኬꬃ ቃማን አዋራ ታማርስተራ ይንታራ የዘ ዎደ ታና አይክካያ። ");
INSERT INTO oyde_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","የዝን Ꮉና ኡባ Ꮉንዳና ናቡንꬅ ጾዘ ቃልተ ጻፍዳና ፎልንቶደ ፋና» ያጋይዳ። የ ዎደ ኤ ታማሩንꬅ ኡባ ኤዛ አሺ ላልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","የሱሳ አይክዱንꬅ ካህኑንꬅ Ꮉላቃ ቃያፋጎ ኤዛ ካንግዳ። እዘ ህገ አስታማሩንꬅን ጋደ ጭሙንꬅ ሺቂ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","የዝን ጴጥሮሳ ካህኑንꬅ Ꮉላቅዘ ዎፋ የሎደስ Ꮉኮራ ኤዛ ካላነ። ኤ ፎልቶ በአደ ዎንꬅስ ግዳ ገሊ ናግዙንꬃራ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ካህኑንꬅ Ꮉላቁንꬅን ሺቅደ አሱንꬅ ኡባ የሱሳ ዎꬎደስ ኤላ አፋ ዎርዶ ማርካ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ጋሙንꬅ ይእ ኤላ አፋ ዎርዶ ማርካ ማርክꬍዳ፥ የዝን አኮን ደንግካያ። ሱባፓ ላምእ አሱንꬅ ይእ፥ ");
INSERT INTO oyde_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ꮉይ አꬄ፥ ‹ታኒ ጾዘ ኬꬅቶ ላሊ Ꮉይꬕ ቃማራ ማህ ኬጾደስ ታ ዳንዳአነ› ጋይዳ» ያጋእ ኡን ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ካህኑንꬅ Ꮉላቅዘ ደንዲ ኤቂ የሱሳጎ፥ «Ꮉንስ ነና ሞትዘ ሞትስ ነ ማህዘባዝ ባ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","የዝን የሱሳ ስእ ጋይዳ። ማህ ካህኑንꬅ Ꮉላቅዘ፥ «ታኒ ነና ደኦ ጾዘ ሱንꬅተ አይካነ፤ ኔኒ ጾዘ ናአ ክርስቶሳ ማቅኮ ኑስ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","የሱሳ ማህ፥ «ኔኒ ነ ኦምተ ጋይዳ። የዝን ታኒ ይንትስ ኦህነ፤ ይኬፓ ሱባ፥ አስ ናአ ዎልቃማ ጾዘ ምዛቅ ባጋራ በቴዝን፥ ማህ ሳሎ ꬎነራ የእዝን ይን በአዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","የ ዎደ ካህኑንꬅ Ꮉላቅዘ ፋ አፉልቶ ፌꬊ፥ «Ꮉያ ቦኦተ ጾዝ ጫዥዳ! ኑና መለ ማርካ አኮስ ኮሸ? ኤ Ꮉተ ጫዥዳኖ ይን ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ይን ቆፍታ አኮ?» ያጋይዳ። ኡንትን፥ «ኤስ Ꮉይቆ ቤዛነ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ዬዝን፥ ኡን ኤ ስንተ ጩቲ ጉድዳ። ማሉንꬅ ኤዛ ባቂ፥ ");
INSERT INTO oyde_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«ክርስቶሳ! ነና ጉድደ ኦደ? አነ ኑስ ትንቢተ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ጴጥሮሳ ባለ በቴዝን፥ ፈቲ አርታ ኤጎ ይእ፥ «ኔንን ጋልላ የሱሳራ ዎላ የዛያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","የዝን ኤ ኡን ኡቡንꬅ ቲኖ ይና አርትጎ፥ «ነ ጋዛና አኮ የዛኮን ታ ኤሮስ» ያጋእ ካድዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ማህ Ꮉንግ ጋሰ ፉርꬃ የሎደራ መለ አርታ ኤዛ ብእ፥ እዘ የዘ አሱንꬃጎ፥ «Ꮉይ አꬄ ናዝረተ የሱሳራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ጴጥሮሳ ላምእንꬃ ጫቂ፥ «ታኒ የ አꬃ ኤሮስ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ኤራꬅ ጋምኦደራ፥ የይጋ ኤቅደ አሱንꬅ ጴጥሮሳጎ ይእ፥ «ኔኒ ቱሮ ኡንታራ ዎላ የዛያ፤ ነ ነ ኦህተ ኤርንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ይንፓ ሱባ፥ ጴጥሮሳ፥ «ታኒ የ አꬃ ኤሮስ!» ያጋእ፥ ፋና ባደን ጫቆ አይክዳ። የ ዎደ ኢራ ሉኩለ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","የሱሳ ኤጎ፥ «ነ ሉኩለ ኦሎደፓ ቲኖ ታና Ꮉይꬕ ቶሄ ካዶዳ» ጋይዳኖ ጴጥሮሳ ቲሪ፥ ባለ ኬዚ ኢታ ዬፎ ዬክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ዎንታ ጎዳ ካህኑንꬅ Ꮉላቁንꬅን ጋደ ጭሙንꬅ ኡቡንꬅ የሱሳ ዎዽሳደስ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ኡን የሱሳ አጪ ካንግ ዎርዣ አህዘ ጵላጦሳስ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","የ ዎደ የሱሳ አይꬂደ ይሁዳ፥ ጵላጦሳ የሱሳላ አፋ ፍርድዳኖ ብእ፥ አዛኒ፥ የ Ꮉስታም ብርዛ ካህኑንꬅ Ꮉላቁንꬅስን ጋደ ጭሙንꬅስ ሱብ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«ታኒ ጽሎ አስ Ꮉይቆስ አꬂ እንግ ናጋራ ኦችዳ» ያጋይዳ። የዝን ኡን፥ «ይና ኑ ማꬋ ባያ ነ ማꬋ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ይሁዳ ብርቶ ጾዘ ኬꬃ ኦሊ አሺ ኡን ካለፓ Ꮉንግ፥ ሱጹንት Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ካህኑንꬅ Ꮉላቁንꬅ ብርቶ ኤኪ፥ «Ꮉና ብርታ ሱꬅ ብራ ማቅደ ግሾ ኑ ጾዘ ኬꬃ ብራራ የልꬅዛና ዎጋ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ይንፓ ሱባ፥ ዎላ ዞርንት፥ በተ አስ ሞጎደስ ማን ጋደ ዎንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ይኒ ግሾ፥ ይና ጋድታ Ꮉይኖ የሎደስ ሱꬅ ጋደ ጋእንት ጼግንታነ። ");
INSERT INTO oyde_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ናበ ኤርምያሳ፥ «እስራኤለ አሱንꬅ ኤስ ጭጎደስ ጋማትደ Ꮉስታም ብራ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ላꬄ ታና ኪትዳን ፋና ማን ጋደ ዎንጎደስ እንግዳ» ጋይዳና የ ዎደ ፎልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","የሱሳ ጋደ አህዘ ጵላጦሳ ቲኖ ሺቅን፥ ጵላጦሳ ኤጎ፥ «ነ አይሁደ ካቶ?» ያጋእ ኦጭዳ። የሱሳ ማህ፥ «ነ ጋይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ካህኑንꬅ Ꮉላቁንꬅን ጋደ ጭሙንꬅ ኤዛ ሞትዘ ዎደ ኡንትስ አኮ ማሄን እንግካያ። ");
INSERT INTO oyde_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","የ ዎደ ጵላጦሳ የሱሳጎ፥ «Ꮉንስ ነና ሞትዘ ሞቶ ኡባ ስኦሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","የሱሳ መለ አቶይዝን፥ ፈቲ ቃላን ማሀንጽን፥ ጋደ አህዛይ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ጋደ አህዘ በርተ በርተ ፋስካ ባአለ ቦንችዘ ቃማ፥ አሱንꬅ ኮይዘ ፈቲ አስ አቻፓ ብልዘ ዎጋ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","የ ዎደ ፈቲ ባርባና ጋዘ ኢታትꬃራ ጋማ ኤርንትደ አች ኬꬃ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ይኒ ግሾ፥ ጋማ አሱንꬅ ሺቂ የዝን ጵላጦሳ፥ «ታኒ ይንትስ ባርባና ብሎነነ፥ ዎይ የሱሳ ጋዘ ክርስቶሳ ብሎነ?» ያጋእ አሱንꬃና ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ኤ ይኖ ጋይዳና ኡን ቃናቲ የሱሳ አꬂ እንግዳኖ ኤርዘ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ጵላጦሳ ፍርዳ ኬꬃ በቴዝን፥ ኤ ማችታ፥ «ታኒ Ꮉይኖ ቃማ አቡኮራ ኤ ባዝ ጋማ ዋይንትተራ አቅደ ግሾ የ ጽሎ አꬄላ አኮ ባዝን ኦችፐ» ያጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","የዝን ካህኑንꬅ Ꮉላቁንꬅን ጋደ ጭሙንꬅ ጵላጦሳ ባርባና ብሊ፥ የሱሳ ዎꬎደ ፋና፥ አሱንꬅ ኤዛ ዎሶደ ፋና፥ አሱንꬃና ዞሪ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ጵላጦሳ ማህ ኡንታጎ፥ «ታኒ ኡን ላምኡንꬃፓ ይንትስ ኦና ብሎደ ፋና ኮየተ?» ያጋእ ኦጭዳ። ኡን፥ «ባርባና ብሎደ ፋና ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ጵላጦሳ፥ «ዬዝን፥ የሱሳ ጋዘ ክርስቶሳ ዋይሳ?» ያጋእ ኡንታና ኦጭዳ። ኡቡንꬅን፥ «ማስቃላላ ኤዛ ሱጾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ጵላጦሳ አሱንꬃጎ፥ «አኮስ? ኤ አኮ ኢታ ባዝ ኦችዶ?» ያጋእ ኦጭዳ። የዝን አሱንꬅ ቲኖስትፓ አꬂ፥ «ማስቃላላ ሱጾ» ጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ካች ደንꬅፓ መለ አኮ ባዝን ኦቾደስ ዳንዳኦሳኖ ጵላጦሳ ብእ፥ Ꮉꬅ ኤኪ፥ «Ꮉይ ጽሎ አꬄ ሱꬅተ ታ ባያ። Ꮉኖ ኦችዘ ይንታና» ያጋእ አሱንꬅ ቲኖ ፋ ኩሽቶ ማትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","አሱንꬅ ኡቡንꬅ ማህ፥ «ኤ ሱꬅት ጎምታ ኑናን ኑ ናኡንꬃና የሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","የዝን፥ ጵላጦሳ ባርባና ኡንትስ ብሊ፥ የሱሳ አላንጋራ ጋራፊ፥ ማስቃላላ ሱጹንት Ꮉይቆደ ፋና ኡንትስ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ይንፓ ሱባ፥ ጵላጦሳ ዎታዳሩንꬅ የሱሳ ዎርዥቶ አህዘ ካራ ኤኪ ካንግን፥ ጋማ ዎታዳሩንꬅ ኡባ ኤ ካለ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ኤ አፉልቶ ጋሪ ኤኪ ዞቆ አፉላ ማእስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ማህ አንጋꬅ ባርኔጻ ጊግዚ፥ ኤ ኦምተ ጋድዳ። ኤ ምዛቅ ኩሽተ ሾምቦቆ ጉፈ አይꬂ፥ ኤ ቲንተ ቡንቁንቲ፥ «አይሁደ ካታዮ፥ ሳሮ ኔስ ማቀ!» ያጋእ፥ ኤላ አፋ ሚጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ኤላ አፋ ጩትዳ። የ ሾምቦቆ ጉፍዛ ኤኪ፥ ኤ ኦምተ ጉድዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ኡን ኤላ አፋ ሚጭዳንፓ ሱባ ዞቆ አፉልዛ ኤፓ ጋሪ ኤኪ፥ ኤ አፉልቶ ኤዛ ማእስዳ። ማስቃላላ ኤዛ ሱጾደስ ኤኪ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ኡን ባለ ኬዚ፥ ፈቲ ስሞና ጋዘ ቀሬና ጋደ አስ ደንግ፥ የሱሳ ማስቃላ ዎልቃራ ቶስዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ጎልጎታ ጋዘ በሲ የልዳ። «ጎልጎታ» ጋዛና «ኦማ ኦታ» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","እዘ ኡን ጭዠራ ዎርቂንትደ ዎይነ ኡሽ ኡዦ ጋእ ኤስ እንግዳ። የዝን ኤ ይኖ ቃማስ ኤኪ፥ ኡዣንጽ እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ኡን ማስቃላላ ኤዛ ሱጽዳንፓ ሱባ ኤ አፉልቶ ሻኪ፥ እጻ ኦሊ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ይንፓ ሱባ፥ የይጋ በቲ ኤዛ ናግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ማህ፥ «Ꮉይ አይሁደ ካት የሱሳ» ያጋዘ ሞቶ ጹፈ ኤ ኦማ ጉሮ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","የሱሳራ የ ዎደ ላምእ ፋኑንꬃና ፈታያ ኤፓ ምዛቅ ዛላራ፥ Ꮉንካያ ኤፓ ዎርክታ ዛላራ፥ ማስቃላላ አፋ ሱጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ኦገራ አꬍዘ አሱንꬅ የሱሳ ፋ ኦምቶ ኤንእዝተራ ጫዣነ፥ ");
INSERT INTO oyde_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«ጾዘ ኬꬃ ላሊ Ꮉይꬕ ቃማ ግዳ ኬጽዛዮ፥ ነና አሾ። ነ ጾዘ ናአ ማቅኮ፥ አነ ማስቃላፓ ዎꬎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ይኒ ፋና፥ ካህኑንꬅ Ꮉላቁንꬅ፥ ህገ አስታማሩንꬅን ጋደ ጭሙንꬅ ዎላ የሱሳላ አፋ ሚጭዳ። Ꮉኒ ፋና ያጋይዳ: ");
INSERT INTO oyde_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«መሉንꬃና አሽዳ፥ የዝን ፋና አሾደስ ዳንዳእካያ። ኤ እስራኤለ ካት ማቅኮ፥ አነ ማስቃላፓ Ꮉተ ዎꬎ፥ ኑንን ኤዛ አማኖዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ጾዛላ ኤ አማንንታነ፥ ጾዚ ኤዛ አሾደስ ኮይኮ አነ አሾ። አኮስ ጋይኮ፥ ኤ ፋና፥ ‹ታኒ ጾዝ ናአ› ጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ማህ መለ አቶይዝን፥ ኤራ ማስቃላላ አፋ ሱጹንትደ ፋኑንꬅን ይኒ ጋር ጋእ ኤላ አፋ ሚጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","እዝፑን ሳተፓ Ꮉንግ፥ ኡዱፉን ሳተ የሎደስ ሳእታ ኡባ ꬉምዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ኡዱፉን ሳተ ማቅዘ ዎደ የሱሳ፥ «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቅታን?» ጋእ ዳማ ኡፎ ኡክዳ። «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቅታን?» ጋዛን ብልꬅታ «ታ ጾዛዮ፥ ታ ጾዛዮ፥ ታና አኮስ አሽዶ?» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","እዘ ኤቅደ አሱንꬃፓ ፈተ ፈተ ይኖ ስእ፥ «Ꮉይ አꬄ ኤልያሳ ጼጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ኢራ ኡንታፓ ፈታይ ዎጺ Ꮉንግ፥ እስፖንጀ ኤኪ፥ ጫላ ዎይነ ኡሽ ኩንꬅዳ። የ ሾምቦቆ ጉፍዘ በርꬅተ ጋዲ ኡሾደስ ኤ ዶንትጎ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","የዝን Ꮉንኩንꬅ፥ «ናጎ፥ ኤልያሳ ኤዛ አሾደስ የኦድየዛኮ አነ በአዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","የሱሳ ላምእንꬃ ዳማ ኡፎ ኡክ፥ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ይና ሳተ ጾዘ ኬꬃ ሱጹንትደ ማጋራጅታ ዎካፓ ዬካ የሎደስ ላምእ ኬዚ፥ ፌꬍንትዳ። ሳእታ ኤንእዳ፥ ላላን ዛእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ቦዛ ቡጉንትን ጌሽ አሱንꬃፓ ጋሙንꬅ Ꮉይቆፓ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ኡን ቦዛፓ ኬዚ፥ የሱሳ Ꮉይቆፓ ደንድዳንፓ ሱባ ጌሽ ካታማ ቅትዳ፤ እዘ ኡን ጋማ አሱንꬅስ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ማቶ Ꮉላቅዘን ኤራ የሱሳ ናግዘ ዎታዳሩንꬅ ሳአ ኤንእዳኖ እዘ Ꮉንዳኖ ብእደ ዎደ ጋማ ዣሽቲ «ቱሮ Ꮉይ ጾዘ ናአ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","እዘ ጋማ ማቹንꬅ፥ ጋልላፓ ደንꬂ የሱሳ ማድተራ ካልዱንꬅ Ꮉኮራ ኤቂ በእነ። ");
INSERT INTO oyde_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ኡን ግዳ ማግደላ ማይራማ፥ ያይቆባን ዮሰፋ እንታ ማይራማን ዛብድዮሳ ናኡንꬅ እንታ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ሳአ ኡጉርዘ ዎደ ዮሴፋ ጋዘ ፈቲ ዱረ አꬄ፥ አርማትያሳ ካታማፓ ይእዳ። ኤ ፋ ኦምተ የሱሳ ካልዘ አስ። ");
INSERT INTO oyde_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ዮሰፋ ጵላጦሳጎ Ꮉንግ፥ የሱሳ አህቶ ኤኮደስ ዎስዳ። ጵላጦሳ አህቶ ዮሰፋስ እንግንቶደ ፋና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","የሱሳ አህቶ ኤኪ፥ ክለ አፉላራ ጻጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ፋስ ሞግንቶደስ ሹቻፓ ዎጭደ ክለ ቦዛ ኤ አህቶ ሞግዳ። ማህ ይና ቦዝት ዶንተ ዳማ ሹች ሽሪ ጋዲ አሺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ማግደላ ማይራምራን Ꮉንኮ ማይራምራ ይና ቦዝት ቲንተ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ዎንታ ሳምባታ ቃማ፥ ካህኑንꬅ Ꮉላቁንꬅን ፋራሳዉንꬅ ጵላጦሳጎ ይእ፥ Ꮉኒ ጋር ያጋይዳ፦ ");
INSERT INTO oyde_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«ላꬆ፥ Ꮉይ ዎርዶ ኦህዘ ፋጻ የዛራ፥ ‹ታኒ Ꮉይꬕ ቃማፓ ሱባ Ꮉይቆፓ ደንዶዳ› ያጋይዳና ኑስ ቲርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ይኒ ግሾ፥ ኤ ሞጉንትደ ቦዝቶ Ꮉይꬕ ቃማ የሎደስ፥ ምንꬂ ናጎደ ፋና ኪቶ። ይና ይአንጽኮ፥ ኤ ታማሩንꬅ Ꮉንግ ኤ አህቶ ካይስት ꬋብስ፥ ‹Ꮉይቆፓ ደንድዳ› ያጋእ አሱንꬅስ ኦህኮ ላምእንꬃ ዎርድታ ቲኖስትፓ ኡባ Ꮉንካ ኢቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ጵላጦሳ ኡንታጎ፥ «ይንትስ ናግዙንꬅ የነ፤ Ꮉንግ ይንትስ ዳንዳእንትደ ፋና ናግዞተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ይኒ ግሾ፥ ኡን Ꮉንግ ቦዝታ ቦችንታመ ፋና ሹችዘላ ማታመ ጋዲ ዎታዳሩንꬃራ ናግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ሳምባታ ኣꬍን ዎጋ ዎደ ዎንታ ጎዳ፥ ማግደላ ማይራምራን Ꮉንኮ ማይራማ የሱሳ ሞጉንትደ ቦዝቶ በአደስ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ቆፕካይዝን ዎልቃማ ሳአ ኤንኤ ማቅዳ። ላꬄ ኪታንቾ ሳሎፓ ዎꬊ ቦዛ ዶንተ የዘ ሹችቶ ጎልእዝ ካታራ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ኤ ብሽታ ዜልንꬅ አዛነ። ኤ አፉልታን ሻች ፋና ቦꬅ። ");
INSERT INTO oyde_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ናግዙንꬅ ኪታንችዛ ብእ፥ ዣሽቲ ጎቂ፥ Ꮉይቂደ አስ ፋና ዪእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ኪታንችዘ ማቹንꬃጎ፥ «ይን ማስቃላላ አፋ ሱጹንትደ የሱሳ ኮይዛኖ ታኒ ኤርዘ ግሾ ዣሽትፐተ። ");
INSERT INTO oyde_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ኤ ካሰ ኦህዳን ፋና Ꮉይቆፓ ደንድዳ፤ Ꮉነ ባያ። Ꮉይጋ ይእ ኤዛ ሞግደ በስቶ ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ይን Ꮉተ ኤልሲ Ꮉንግ፥ ኤ ታማሩንꬅስ፥ ‹የሱሳ Ꮉይቆፓ ደንድዳ። ማህ ኤ ይንታፓ ቲንꬊ ጋልላ ቅቶዳ፤ ይን ኤዛ የይጋ በአዳ› ያጋእ ኦሆተ። ታኒ ይንትስ Ꮉኖ ኦሆደስ ይእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ኡን ዣሽትተራን ጋማ ኡፋይትተራ፥ ቦዝት ካለፓ ኤልሲ Ꮉንግ፥ ኤ ታማሩንꬅስ ኦሆደስ ዎጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ቆፕካይዝን የሱሳ ኡንታራ የልንት ኡንታጎ፥ «ሳሮ ይንትስ ማቀ» ያጋይዳ። ኡን ኤጎ ሺቂ፥ ኤ ቶህቶ አይኪ ኤስ ጎይንዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","የ ዎደ የሱሳ ኡንታጎ፥ «ዣሽትፐተ፤ Ꮉንግ ታ ታማሩንꬅ ጋልላ Ꮉንጎደ ጋር ኡንትስ ኦሆተ። ኡን እዘ ታና በአዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","የንꬅ ማቹንꬅ Ꮉንጎደራ፥ ቦዝቶ ናግዘ ዎታዳሩንꬃፓ ባጉንꬅ ካታማ Ꮉንግ፥ Ꮉንደ ባዝቶ ኡባ ካህኑንꬅ Ꮉላቁንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ካህኑንꬅ Ꮉላቁንꬅን ጭሙንꬅ ሺቂ ዞርንት፥ ዎታዳሩንꬅስ ጋማ ብራ እንግ፥ ");
INSERT INTO oyde_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«‹ኑ ገንተዝን ኤ ታማሩንꬅ ቃማ ይእ፥ ኤ አህቶ ካይስትዳ› ያጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ꮉና ኦህቶ ጋደ አህዛይ ስእኮ፥ ይና ይን ባላ ባይዛኖ ኑ ኤስ ኦህ አማንꬆዳ። ይንታና አኮን ይርግዝፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ዎታዳሩንꬅ ብርቶ ኤኪ፥ ኦህዳን ጋር ኦችዳ። Ꮉና ኦህታ አይሁዱንꬅ ካለ Ꮉይኖ የሎደስ ኦህንትተራ የነ። ");
INSERT INTO oyde_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ታጶ ፈቲ ታማሩንꬅ የሱሳ ኪትደ ጋልላ የዘ ደረጎ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","እዘ ኡን ኤዛ ብእደ ዎደ ኤስ ጎይንዳ፥ የዝን ኡንታፓ ፈተ ፈተ ሶእዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","የሱሳ ኡንታጎ ሺቂ፥ «ሳሎን ሳአን አደትꬅ ዎልቃ ኡባ ታስ እንግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ይኬ፥ ይን ኡባ በሳ ቅቶተ፥ አዳይ፥ ናአይ፥ ጌሽ አያና ሱንꬅተ አስ ኡባ ታማርስ፥ ጻማቅ ታ ኪትዳኖ ኡባ ናጎደ ፋና ታማርስተራ ታና ካልዙንꬃና ማሆተ። ");
INSERT INTO oyde_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ታኒ ይንታና ኪትደባዝ ኡባ ኡን ናጎደ ፋና ኡንታና ታማርሶተ። ታኒ ዎደ ዉርሱꬅ የሎደስ ኡባ ዎደ ይንታራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ꮉይ ጾዘ ናአ የሱስ ክርስቶሳ ዎንገለ ደንꬄ። ");
INSERT INTO oyde_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ናበ ኢሳያሳ ጻፍደ ማጻፍተ ጾዚ፥ «ይኬ፥ ታኒ ታ ኪታንቾ ኔፓ ቲኖ ዳኮዳ። ኤ ነ ኦግቶ ጊግሳዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ፈታይ አኮ ባይዘ ጋናሳ ፋ ቃልቶ ꬎቅ ዪዚ፥ ‹ላꬄ ኦግቶ ጊግዞተ፤ ኤ የꬋደ ዉስቶ ኤስ ጊግዞተ ጋይዳ› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ጻማቅዘ ዋሐንሳ አሱንꬃና ጻማቅተራ፥ «ይን ናጋርትፓ ማቂ ጻማቅንቶተ፤ ጾዚ ይን ናጋርቶ አቶ ጋኦዳ» ያጋእ ቃላ ኦህተራ አኮ ባይዘ ጋናሳራ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ይሁዳ ሳአ የዘ አሱንꬅ ኡባን የሩሳላመ ካታማ አሱንꬅ ኡባ ዋሐንሳጎ የእነ። ፋ ናጋርቶ ፋጽን፥ ዋሐንሳ ኡንታና ዮርዳኖሳ ቦርካ ጻማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ዋሐንሳ ግማለ እስንፓ ዳድንትደ አፉላ ማእዳ። ፋ ቃዝንተ ሳቀ ዳንጭዳ፤ ማህ ቦለን ደከራ ሽዳ ሙእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ዋሐንሳ ቃላ ኦህተራ፥ «ታፓ ሱባራ ዳማ ሚንግዘ የእነ። መለ አቶ የዝን፥ ታኒ ኤ ጫማ ጋድዛ ዙጊ ብሎደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ታኒ ይንታና Ꮉꬃራ ጻማቃነ፥ የዝን ኤ ይንታና ጌሽ አያናራ ጻማቆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","የሱሳ የ ዎደ ጋልላ አዉራጃ የዘ ናዝረተ ካታማፓ ይእን፥ ዋሐንሳ ዮርዳኖሳ ቦርካ ጻማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","የሱሳ Ꮉꬅትፓ ከዘ ዎደ ሳሎ ቡጉንትን፥ ጌሽ አያና ኤላ አፋ ዎለ ጋራ ዎꬎደራ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ማህ ሳሎፓ፥ «ታኒ ካዽዘ ታ ናአይ ነና፤ ታ ኔላ ኡፋይታነ» ያጋዘ ቃላ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ኢራ ጌሽ አያና የሱሳ አኮ ባይዘ ጋናሳ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","የሱሳ አኮ ባይዘ ጋናሳ ጻላሄራ ፋታንንትተራ ኦይታም ቃማ ጋምእዳ። ጾꬃራ የዝዳ፥ የዝን ኪታንቹንꬅ ይእ ኤዛ ማድዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ዋሐንሳ አጭንትዳንፓ ሱባ የሱሳ ጾዘ ካእቱሞ ዎንገለ ኦህተራ ጋልላ አዉራጃ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","እዘ፥ «ዎደ የልዳ፤ ጾዘ ካእቱሞ ኡክዳ። ይን ናጋርትፓ ማቂ፥ ዎንገለ አማኖተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","የሱሳ ጋልላ አባ ካለራ አꬍተራ፥ ሞሎ አይክዘ፥ ስሞናራን ኤ እሸ እንድራሰራ፥ ፋ ግትቶ አባ ኦልዙንꬃና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ኡንታጎ፥ «ታና ካሎተ፤ ታ ይንታና አስ አይፎ ታማርሶዳ» ያጋይዳ ");
INSERT INTO oyde_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ኡንቲ ኢራ ፋ ግትቶ ኦሊ አሺ የሱሳ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","የሱሳ ኤራꬅ ቲኖ Ꮉንግ፥ ላምእ እሹንꬃና ዛብዶሳ ናኡንꬃና፥ ያይቆባራን ዋሐንሳራ ጎንገ ግዳ ፋ ግትቶ ጊግዙንꬃና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ኤ ኡንታና ብእደ ጋር ጼግዳ። ኡን ፋ አዳያ ዛብዶሳን፥ ኤስ ኦችዙንꬃራ ጎንገ ግዳ ኦሊ አሺ የሱሳ ካሊ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ኡንቲ ቅፍርናሆመ ካታማ የልዳ። ሳምባታ ገልደ ጋር የሱሳ ኤልሲ አይሁደ ዎሳ ኬꬃ ገሊ ታማርሰ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","አደትꬅ ዎልቃራ የዘ አስ ፋና ታማርሳነፕ አትን ህገ አስታማሩንꬅ ፋና ታማርሶሰ ግሾ አሱንꬅ ኤ ትምርትተ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","የ ዎደ ቱና አያና አይክደ ፈቲ አꬄ አይሁደ ዎሳ ኬꬃ ገሊ ፋ ቃልቶ ꬎቅ የይዝ፥ ");
INSERT INTO oyde_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«ናዝረተ የሱሳ፥ ኔኒ ኑፓ አኮ ኮየ? ኑና ꬋብሶደስ ነ ይእዳ? ነ ኦና የዛኮ ታ ኤራነ፤ ነ ጾዘ ጌሽ።» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","የሱሳ የ ቱና አያንዛ፥ «Ꮉይዞ፥ Ꮉይ አꬄፓ ከዞ» ጋእ ሴርዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ቱና አያና አꬃ ላቢዚ፥ ዉይስዚ ኤዛፓ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","አሱንꬅ ኡባ ጋማ ቆፒ፥ «Ꮉና አኮ? Ꮉይ አꬄ ፋ አደትꬅ ዎልቃራ መለ አቶ የዝን ቱና አያናን ኪታነ። ኡንቲ ኤስ ኪትንታነ፤ Ꮉና አኮ ክለ ትምርተ?» ያጋእ፥ ፋ ግዳ ፈተ ፈታ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","የሱሳ ማርካትꬅታ ኤልሲ ጋልላ ሳአ የዘ ጉታ ኡባ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","የሱሳ አይሁደ ዎሳ ኬꬃፓ ኬዚ፥ ያይቆባራን ዋሐንሳራን ስሞና ካራን እንድራሰ ካራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ስሞና ማችት እንታ ዳማ ኦꬂ ምቻራ Ꮉርግንቲ ዎይእዳኖ የሱሳ እዘ የልን ኤስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ኤ ኢጎ ሺቂ፥ እ ኩሽቶ አይኪ፥ እዞ ደንꬂ ኤስዳ። ኦꬂ ምችታ አሽን እዛ ኡንታና ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ꮉርግንትደ አሱንꬃናን ቱና አያና አይክደ አሱንꬃና ኡባ ኡጉረ አዋ ገልን ኤጎ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ካታምተ የዘ አሱንꬅ ኡቡንꬅ ይና ኬꬅት ባለ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","የሱሳ ዱማ ዱማ Ꮉርገራ አይክንትደ ጋማ አሱንꬃና ፋꬂ፥ ጋማ ቱና አያኑንꬃና ከስዳ። ኤ ኦደ የዛኮ ቱና አያኑንꬅ ኤርደ ግሾ ኡንታና ኦሃመ ፋና ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","የሱሳ ዎንት ማ ደንዲ፥ አስ ባይዘ በሳ Ꮉንግ፥ እዘ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ስሞናራን ኤራ የዙንꬅ ኤዛ ኮይተራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ኡንቲ ኤዛ ደንግ፥ «አስ ኡባ ነና ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","የሱሳ ማህ ኡንታና፥ «ይና ጉቱተ የዘ ሰኮ ካታምተ የꬎተ። ታኒ ይእዳና ዎንገለ ኦሆደስ ማቅደ ግሾ እዘ የዘ ጉታ ኦሆደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","አይሁደ ዎሳ ኬꬃ ቃላ ኦህተራን ቱና አያኑንꬃና ከስተራ፥ ጋልላ ሳአ ኡባ ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ቁርሱማ Ꮉርገ አይክደ ፈቲ አꬄ የሱሳጎ ይእ፥ ኤ ቲንተ ቡንቁንቲ፥ «ኔኒ ኮይኮ ታና ጌሾደስ ዳንዳአነ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","የሱሳ ኤስ ይቅስንቲ፥ ፋ ኩሽቶ ዳኪ ኤዛ ቦቺ፥ «ታኒ ካꬋነ፥ ጌዦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ኢራ ቁርሱምታ አꬃ ዳክን አꬄ ጌዥዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","የሱሳ አꬃ ምንꬂ ናግንቶ ጋእ ኬሲ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","የሱሳ ኤዛ፥ «ነና ኤሮ፥ Ꮉኖ ኦደስን ኦህፐ። የዝን Ꮉንግ ነ ጋልቶ ካህነ ቤዞ። ኔኒ Ꮉተ ጌሽ ማቅዳኖ አሱንꬃና ኤርሶደስ፥ ሙሴ ኪትደ ዣርሽቶ ዣርሾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","የዝን አꬃይ Ꮉንግ፥ ካራ ጋንጨ አስ ኡቡንꬅስ ኦህዳ። ይኒ ግሾ፥ የሱሳ በንቲ ኬዚ፥ ካታማ ገሎደስ ዳንዳእካያ። የዝን አስ ባይዘ በሳ ጋጻ የዝዳ፤ ማህ አሱንꬅ ኡባ ፋ የዘ በሳፓ ኤጎ የእነ። ");
INSERT INTO oyde_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ኤራꬅ ቃማፓ ሱባ የሱሳ ቅፍርናሆመ ማቂ፥ ኬꬃ የነ ጋዘ ዎረ ስንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","አሱንꬃና ኬꬅታ ኤካንጽ እጽን፥ መለ አቶ የዝን ባልታን ኡንኦደ ዎንꬅስ ጋማ አሱንꬅ ሺቅን፥ የሱሳ ቃላ ታማርሳነ። ");
INSERT INTO oyde_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ኦይዲ አሱንꬅ ፈቲ ዎቦ አꬃ ቶኪ ኤጎ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","አሱንꬅ ጋንግደ ግሾ አꬃ የሱሳጎ ሺሾደስ ኡንትስ ዳንዳእንታንጽ እጽን፥ የሱሳ የዘ ዛላራ ኬꬂ ኣፍቶ ቶኪ አꬃ ኤ ዎይእደ አልግዘራ ሱለ ኬꬂ የሱሳ ቲንተ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","የሱሳ ኡን አማንቶ ብእ፥ የ ዎቦ አꬃ፥ «ታ ናአዮ፥ ነ ናጋርታ አቶ ጋእንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ህገ አስታማሩንꬃፓ ይና በስተ በትደ ፈተ ፈተ ፋ ዎዝንተ፥ ");
INSERT INTO oyde_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«ናተ Ꮉይ አꬄ Ꮉኒ ጋር ኢታ ባዝ ጾዛላ አኮስ ኦሄ? ጾዛ ጻላላፕ አትን መለ ኦደ ናጋራ አቶ ጋኦደስ ዳንዳእዘ?» ጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ኡንቲ ፋ ዎዝንተ ይኒ ጋራ ቆፕዳኖ የሱሳ ኢራ ፋ አያንተ ኤሪ፥ ኡንታጎ፥ «ይንቲ ይን ዎዝንተ አኮስ Ꮉንጋራ ቆፐተ? ");
INSERT INTO oyde_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ዎቦ አꬃ፥ ‹ነ ናጋርታ አቶ ጋእንትዳ› ጋዛና ኡኬነ? ዎይ፥ ‹ደንዲ ኤቂ ነ አልግዛ ቶኪ ቅቶ› ጋዛና ኡከ? ");
INSERT INTO oyde_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","የዝን ታስ፥ አስ ናአይስ፥ ሳአላ አፋ ናጋራ አቶ ጋኦደስ አደትꬅ ዎልቃ የዛኖ ይን ኤሮደ ጋር» ጋእ የ ዎቦ አꬃ፥ ");
INSERT INTO oyde_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«ነና ጋነ፥ ደንዲ ኤቂ ነ አልግዛ ቶኪ ነ ካራ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","አꬄ ኤልሲ ደንዲ ኤቂ፥ ፋ አልግዛ ቶኪ አስ ኡባ በእዝን ቅትዳ። አሱንꬅ ኡባ ጋማ ቆፒ፥ «ኑኒ Ꮉኒ ጋር ጋማ ቆፍዘ ባዝ ብእ ኤሮስ» ያጋእ ጾዝ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","የሱሳ ማህ ጋልላ አባ ጋጻ Ꮉንግ፥ ፋጎ ይእደ አሱንꬃና ኡባ ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ኢራ አꬍተራ፥ እልፍዮሳ ናአይ ሌወ ጋእንትዘ ቃራጠ ጋችዘ በስተ በትዳያ ብእ፥ «ታና ካሎ» ያጋይዳ። ሌዊዘ ደንዲ ኤቂ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","የሱሳ ካꬃ ማደስ ሌዊ ኬꬃ በትዳ። ኤዛ ካልዘ አሱንꬅ ጋማ ማቅደ ግሾ ቃራጠ ጋችዘ ጋማ አሱንꬅን ናጋራንቹንꬅ ኤራን ኤ ታማሩንꬃራ ዎላ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ህገ አስታማረ ማቅደ ፈቲ ፈቲ ፋርሳዉንꬅ የሱሳ ናጋራንቹንꬃራን ቃራጠ ጋችዙንꬃራ ካꬃ ማአደራ ብእ፥ «ኤ አኮስ ናጋራንቹንꬃራን ቃራጠ ጋችዙንꬃራ ካꬃ መኤ?» ያጋእ፥ ኤ ታማሩንꬃና ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","የሱሳ ኡን ጋዛኖ ስእ፥ «Ꮉርግንትዘስ ፋትን ፋጻስ አክመ ኮሾስ። ታኒ ናጋራንቹንꬃና ጼጎደስ ዪዳፕ አትን ጽሉንꬃና ጼጎደስ ይእካያ» ያጋእ ኡንትስ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ጻማቅዘ ዋሐንሳ ታማሩንꬅን ፋርሳዉንꬅ ጾማነ። ፈቲ ፈቲ አሱንꬅ የሱሳጎ ይእ፥ «ዋሐንሳ ታማሩንꬅን ፋርሳዉንꬅ ታማሩንꬅ ጾማነ፥ የዝን ነ ታማሩንꬅ አኮስ ጾሞሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","የሱሳ ኡንታጎ፥ «ሳርገ ይእደ አሱንꬅ ማቾ ኤክዘ ኡንታራ የዝን፥ ጾሞደስ ዳንዳአነ? ማቾ ኤክዘ ኡንታራ የዝን፥ ጾሞደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","የዝን ማቾ ኤክዘ ኡን ካለፓ ኤክንቶደስ ዎደ የኦዳ፥ ኡን የ ዎደ ጾሞዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«ጋልአ ማኦላ ክለ ጫርቀ ጋዲ ስክዘ አስ ባያ። ጋዲ ስክኮን፥ ክልዘ ጋልአ ማእዛ ፌꬋነ፤ ፌዽꬅታን ካሰንፓ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ማህ ማልአንቶ ዎይነ ጋልአ ስልጰ ጉጅዘ አስ ባያ። ማህ ጉጅኮን፥ የ ዎይንዘ ስልጵዛ ፌꬋነ፥ ፋስን ላንታነ፥ ስልጵዘን ኢታነ። የዝን ማልአንቶ ዎይነ ክለ ስልጰ ጉጅንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","የሱሳ ፈቲ ሳምባታ ቃማ ባንጋ ጋደ ግዳራ አꬎደራ፥ ኤ ታማሩንꬅ ኤራ Ꮉንግተራ ባንጋ ትዣ ሽጪ ꬋአነ። ");
INSERT INTO oyde_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ፋርሳዉንꬅ የሱሳጎ፥ «ይኬ፥ ነ ታማሩንꬅ ሳምባታ ቃማ ዎጋ ባይዘ ባዝ አኮስ ኦቼ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","የሱሳ ኡንታጎ፥ «ዳዉተ ናይꬊ፥ ሙእዘ ባዝ ኮይደ ዎደ ፋራ የዙንꬃራ ኦችዳኖ ነ ናባብካ? ");
INSERT INTO oyde_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","አብያታር ካህኑንꬅ Ꮉላቃ ማቂ የዘ ዎደ ዳዉተ ጾዘ ኬꬃ ገሊ፥ ካህኑንꬅ ጻላላ ማአደፕ አትን ኦደን ማአደስ ዎጋ ባይዛኖ ላꬄ ቲኖ ጋድደ ዳቡቶ ሙእዳ፥ ፋራ የዙንꬅስን እንግዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ማህን የሱሳ ኡንታጎ፥ «ሳምባታ አስ ናአ ማደስ ጋእ መꬍንትዳፕ አትን አስ ሳምባታስ መꬍንትካያ። ");
INSERT INTO oyde_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ይኒ ግሾ፥ አስ ናአይ፥ መለ አቶ የዝን ሳምባታስን ላꬂ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","የሱሳ አይሁደ ዎሳ ኬꬃ ማቂ ገልዳ። እዘ ኩሸ ጉንድደ ፈቲ አስ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ፈቲ ፈቲ አሱንꬅ የሱሳ ሞቶደስ ኬዚ፥ ኩሸ ጉንድደ አꬃ ሳምባታ ዎደ ኤ ፋꬅኮን አሽኮ ጋእ በአደስ ኮይ ምንꬂ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","የሱሳ ኩሸ ጉንድደ አꬃ፥ «ደንዲ ኤቂ Ꮉንካ ግዳ ዮኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ይንፓ ሱባ፥ አሱንꬃጎ፥ «ሳምባታ ዎደ ሎኦ ባዝ ኦችዛና ዎጋነ ኢታ ባዝ ኦችዛና ዎጋ? አስ ሸምፖ አሽዛኖነ ዎይ ዎꬍዛኖ?» ያጋእ ኦጭዳ። የዝን አሱንꬅ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","የሱሳ አንꬅንቲ፥ ኡንታና ዉቱꬂ ዳኪ ብእ፥ ኡን ኦህን ስኦሱንꬃና ማቅደ ግሾ ኡንታላ አፋ ጋማ ዥልꬍዳ። የ አꬄጎ፥ «ነ ኩጭዛ ፍዲ ዪዞ» ያጋይዳ። ኤዚ ፍዲ ዪዝን ኤ ኩጭዘን ፋጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ኤልሲ ፋርሳዉንꬅ አይሁደ ዎሳ ኬꬃፓ ባለ ኬዚ፥ የሱሳ ዋይዝ ዎꬎድ የዛኮ ዞርንቶደስ ሄሮድሳ ባጉንꬃራ ፈቲ በሳ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","የሱሳ ፋ ታማሩንꬃራ ጋልላ አባጎ Ꮉንግዳ። ጋልላፓን ይሁዳፓ ይእደ ጋማ አሱንꬅ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ማህን የሩሳላመፓ፥ ኤዱምያሳፓ፥ ዮርዳኖሳ ቦርካ ፍንꬃፓ፥ ጢሮሳ ካታማፓን ስዶና ካታማፓ የሱሳ ኦችዳኖ ስእ፥ ጋማ አሱንꬅ ኤጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","አስ ጋንግዳንፓ ደንዲ ኤዛ ኡንእꬃመ ፋና ኤ ታማሩንꬅ ጎንገ ኤስ ጊግሳደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ጋማ አሱንꬃና ኤ ፋꬅደ ግሾ Ꮉርግንትዘ አሱንꬅ ኡባ ኤዛ ቦቾደስ ኡርቂንታነ። ");
INSERT INTO oyde_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ቱና አያና አይክደ አሱንꬅ ኤዛ ብእደ ዎደ ኤ ቲንተ ቡንቅቲ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ኔኒ ጾዘ ናአ ባነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","የሱሳ ጋማ ዎደ ቱና አያኑንꬅ ፋ ኦናትꬅቶ ቆንጭዛመ ፋና ኡንታና ምንꬂ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","የሱሳ ደረላ አፋ ኬዚ፥ ፋ ኮይዘ አሱንꬃና ፋጎ ጼግዳ፤ ኡንትን ኤጎ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ኡን ፋራ የሳደ ጋራን ቃላ ታማርሶደ ጋር ታጶ ላምኡንꬃና ዶሪ፥ ኡንታና፥ «ሐዋረ» ጋእ ሱንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ቱና አያና ከሶደ ጋር ኡንትስ አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ኤ ዶርደ ታጶ ላምኡንꬅ Ꮉንሳና፦ ጴጥሮሳ ጋእ ሱንꬅደ ስሞና፥ ");
INSERT INTO oyde_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ቦአነርገስ (ዳዳ አዝዘ አሱንꬃና) ያጋእ ሱንꬅዱንꬃና፥ ዛብዶሳ ናኡንꬅ ያይቆባራን ያይቆባ እሸ ዋሐንሳ፥ ");
INSERT INTO oyde_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","እንድራሰ፥ ፍልጶሳ፥ ባርቶሎምዮሳ፥ ማቶሳ፥ ቶማሳ፥ እልፍዮሳ ናአ ያይቆባ፥ ታድዮሳ፥ ካናነፓ ይእደ ስሞናራ፥ ");
INSERT INTO oyde_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","የሱሳ አꬂ እንግደ አስቆሮቱ ይሁዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ይንፓ ሱባ፥ የሱሳ ካራ Ꮉንግዳ። ማህ ጋማ አሱንꬅ ሺቅን፥ ኤዝን ኤ ታማሩንꬅ መለ አቶ የዝን ካꬃ ማአደስን ኡን ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","አሱንꬅ ኤዛ፥ «ዣሽታነ» ጋዘ ግሾ ኤ እግኑንꬅ ይኖ ስእ ኤዛ ኤኮደስ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ህገ አስታማሩንꬃፓ ፈተ ፈተ የሩሳላመፓ ይእ፥ «ኤላ አፋ ብኤልዘቡላ የነ»፥ ኤ፥ «ጻላሄ ዎልቃራ ቱና አያና ከሳነ» ያጋእ ዎላ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","የሱሳ አሱንꬃና ፋጎ ጼጊ አዝዘር ኦህዳ። «ጻላሄ ጻላሄ ዋይዝ ኬሶደስ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ፈቲ ካእቱሞ ፋ ግዳ ሻክንትኮ ይና ካእቱምታ ኤቆደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ይኒ ጋራ፥ ፈቲ ኬꬃ አሱንꬅ ፋ ግዳ ሻክንትኮ ꬋቦዳፕ አትን የሳደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ይኬ፥ ጻላሄ ፋራ ካጭንቲ ሻክንትኮ ꬋቦዳፕ አትን የሳደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«ይኒ ጋራ ቲኖ ዎልቃር የዘ አꬃ አጭካይዛራ ኤ ኬꬃ ገሊ፥ ኤ ቆልቶ ቦንቆደስ ዳንዳእዘ አስ ባያ። አጪ ማቂ ኤ ኬꬅቶ ቦንቆደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«ታኒ ይንትስ ቱሮ ኦህነ፤ ጾዚ አስ ናኡንꬅስ ናጋራ ኡባኖን ኡን ጫዥዘ ጫሽቶ ኡባ አቶ ጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","የዝን ጌሽ አያናላ ኢታ ባዝ ኦህዘ መꬍናስ ናጋራ ጋለ ማቃደፕ አትን ጾዚ ሙሎን ኤዛ ማሮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","የሱሳ ይኖ ጋእዳና፥ ፈቲ ፈቲ አሱንꬅ፥ «ኤላ አፋ ቱና አያና የነ» ያጋይደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ኤ እንታን ኤ እሹንꬅን ይእ ባለ ኤቂ፥ ኤጎ አስ ኪቲ ኤዛ ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ኤ ካለ በትደ ጋማ አሱንꬅ፥ «ይኬ፥ ነ እንታን ነ እሹንꬅን ባለ ኤቂ ነና ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","የሱሳ ማህ፥ «ታ እንታ ኦደ? ማህ ታ እሹንꬅን አኑንꬃና?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ፋ ካልተ በትደ አሱንꬃና ዉቱꬂ ዳኪ ብእ፥ «ይኬ፥ ታ እንታን ታ እሹንꬅን Ꮉንሳና። ");
INSERT INTO oyde_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ጾዘ ቆፋ ኦችዘ ኡቡንꬅ ታስ እሸን፥ ታስ ምሾን ታስ እንዶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","የሱሳ ማህ ጋልላ አባ ካለ ታማርሳነ። ጋማ አሱንꬅ ኤ ካንተ ዉቲ ሺቅን፥ አባላ የዘ ጎንግተ ገሊ በትዳ፥ አሱንꬅ ኡባ አባ ካለ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ኤ ኡንታና ጋማ ባዝ አዝዘራ ታማርስዳ። ታማርስተራ Ꮉንጋራ ያጋይዳ፦ ");
INSERT INTO oyde_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ይኬ! ፈቲ አꬄ ቡዱꬂ ቡዶደስ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ኤ ቡዶደራ፥ ፈቲ ፈቲ ቡዱꬅታ ኦገ ጋጻ ዎꬍዳ፤ ላንዳ ይእ ሙእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ፈቲ ፈቲ ቡዱꬅታ ፎርቾ ሳአላ ዎꬍዳ። ጋማ ሳአ ባይዘ ግሾ ይና ቡዱꬅታ ኤልሲ ዶልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","የዝን አዋ ከዘ ዎደ ሹልዳ። ሎይꬂ ጻጶ ዳክካይዘ ግሾ ኤልሲ መልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ፈቲ ፈቲ ቡዱꬅታ አንጋꬅ ግዳ ዎꬍዳ። ዶልዳኖ አንጋꬅታ ድጪ ጩልደ ግሾ ኣፈ አፍካይዛራ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ፈቲ ፈቲ ቡዱꬅታ አራዳ ሳአ ዎꬊ ዶልዳ። ድጪ ፈተ Ꮉስታም፥ ፈተ እዝፑን ታም ፈተ ጼት ኣፍዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","«ስእዘ Ꮉየ የዘ ኦደን ስኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","የሱሳ ኦህዳኖ ስእደ ፈቲ ፈቲ አሱንꬅ ታጶ ላምእ ታማሩንꬃራ የዙንꬅ የሱሳ ፋ ጻላላ የሳደራ፥ ኤጎ ሺቂ ይና አዝዝትስ ብልꬅቶ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","የሱሳ ኡንታጎ Ꮉኒ ጋር ያጋይዳ፦ «ይንትስ ጾዘ ካእቱሞ ጋꬅ ቆፋ ኤሮደስ እንግንትዳ። የዝን መሉንꬅስ ካእቱሞፓ ባለራ የዙንꬅስ ኡባ ባዝ አዝዘራ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ꮉና Ꮉንዳና፥ «ኡንቲ በእነ፥ የዝን ደንጎስ። ስእነ፥ የዝን ቲሮስ። ኡንቲ ደንግዛኮን ቲርዛኮ፥ ጾዛጎ ማቃዳ ኤዝን ኡንታና ማሮዳ የሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","የሱሳ ኡንታጎ፥ «Ꮉና አዝዝታ ይንትስ ገሎሶ? ዬዝን፥ አዝዘ ኡባ ይን ዋይዝ ቲሮደ? ");
INSERT INTO oyde_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ቡድዛይ ጾዘ ቃላ ቡዳነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ቃላ ቡድንትዘ ዎደ ኦገ ጋጻ ዎꬍዱንꬅ ቃላ ስእዙንꬃና። የዝን ጻላሄ ኢራ ይእ፥ ኡን ዎዝንተ ቡድንትደ ቃልቶ ማጺ Ꮉሳነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ይኒ ጋራ፥ ፎርቾ ሳአ ቡድንትደ ቃላ ስእ፥ ኤልሲ ኡፋይት ኤክዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","የዝን ኡንትስ ምንꬂ ጻጶ ባይዘ ግሾ Ꮉተስ ፋትን ጋምኦስ። ኤራꬅ ዎደፓ ሱባ ቃላ ግሾ ማꬋን ዎይ ባይꬂ የልደ ዎደ ኤልሲ ꬉቡንታነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","አንጋꬅ ግዳ ቡድንትደ ቃላ ስእዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","የዝን Ꮉና ሳአ የሲስ ይርጋን፥ ዱርቱሞ ካን ዱማ ዱማ አሞትꬅ ኡን ዎዝንተ ገሊ ቃልቶ ጩልዘ ግሾ ኣፈ አፍካይዛራ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","የዝን አራዳ ሳአ ቡዱንተዙንꬅ ቃላ ስእ ኤክዙንꬃና። ኡንቲ ፈተ Ꮉስታም፥ ፈተ እዝፑንታም ፈተ ጼት ኣፍዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","የሱሳ ጉጂ፥ «ጾምፐ ኤኪ፥ ጋባተ ግዳ ዎይ አልጋ ኦሞ ጋድዘ አስ የነ? ꬎቃ በሳ ጋዶሳነ? ");
INSERT INTO oyde_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ይኬ፥ አችንትደ ባዝ ኡባ ቆንጨ ኬሳዳ፤ አችንትደ ባዝ ኡባ ኤርንትካይዛራ አታማ። ");
INSERT INTO oyde_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ስእዘ Ꮉየ የዘ ኦደን ስኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ማህ ኡንታጎ፥ «ይን ስእዘ ባዝ ቆፋር ስኦተ! ጾዘ ቃላ ይን ስእዛን ፋና ኤ ይንትስ ቆፋ እንጎዳ። ይንትስ ማክዛነ ጋንꬅ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","የዘ አꬄስ ጋንꬅ እንግንቶዳ፥ ባይዘ አꬄፓ መለ አቶ የዝን፥ ኤስ የዘ ይና ኤራꬅታን ኤክንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","የሱሳ ማህ፥ «ጾዘ ካእቱሞ ፋ ጋድተ ቡዱꬂ ቡድዘ አꬄ ፋና። ");
INSERT INTO oyde_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","የ አꬄ ቃማ ገንታነ ዎንታ ደንዳነ። ኤ ፋ ኦምተ ዋይዛኮን ኤርካይዛራ የሳደራ ይና ቡዱꬅታ ዶሊ ድጫነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ጋድታን ካꬃ ፋ ፋስ እንጋነ። ቲኖ ዶሊ ድጫነ፥ ሱብተ አፎደስ ጋምቡጻነ፥ ዉርሱꬅተ ኩሙꬅ ኣፈ አፋነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","የዝን ካꬅታ የልደ ዎደ አꬄ ማጻነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","የሱሳ፥ «ኑኒ ጾዘ ካእቱሞ አኮ ፋና ጋኦደ? ዎይ አኮራ አዝሳደ? ");
INSERT INTO oyde_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ጾዘ ካእቱሞ ኣፈ ኤራꬅ ምንጻ አዛነ። የ ምንጻ ኣፍዘ ቡድዘ ዎደ ሳአላ የዘ ምንጻ ኣፈ ኡባፓ ላፋነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ቡድን ዶሊ ምንጻ ኡባፓ ዳማነ፤ ዳማ ዳሽ ዳዣነ። ላንዱንꬅ ኤ ትርሽትላ አፋ ኬጺ በቶደ ዎንꬅስ ዳዣነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","የሱሳ Ꮉኒ ጋር ጋማ አዝዘራ አሱንꬅ ቲሮደስ ዳንዳኦደ ጋር ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","አሱንꬅስ አዝዘ ባይꬅ ኦሆስ። የዝን የሱሳ ፋ ታማሩንꬃራ ጻላላ የዘ ዎደ ኡንትስ ኡባባዝቶ ብሊ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","የ ዎደ ሳእታ ኡጉርን፥ የሱሳ ፋ ታማሩንꬃጎ፥ «አባፓ ሰኮ ጋጻ ፊንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ኤ ታማሩንꬅ ጋማ አሱንꬃና ኦሊ አሺ አሺ፥ የሱሳ ቲኖ ገሊ በትደ ጎንግዘ ግዳ ገሊ የሱሳ ፋራ ኤኪ ቅትዳ። መለ ጎንጉንꬅን እዘ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ዳማ ጎተ ደንዲ፥ ዙሉንታ ጎንግዛ ጉድን፥ Ꮉꬅታ ኩሞደ ዎንꬅስ ጎንግዘ ግዳ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","የ ዎደ የሱሳ ጎንግዘስ ሱባ ዛላራ ቦርኮꬅ ጋዲ ገንትዳ። ኤ ታማሩንꬅ ኤዛ ባርክዚ፥ «አስታማዛዮ፥ ኑ ꬋብዘ ዎደ ነና ይቅሶሳነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","የዝን፥ ኤ ባርክ ዙሉንቶ፥ «ሴሪ»፥ አብዛን፥ «ስእ ጋኦ» ያጋይዳ። ዙሉንታን ስእ ጋእን ኡባ ባዝ ዎፑ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","የሱሳ ፋ ታማሩንꬃጎ፥ «አኮስ Ꮉንጋራ ዣሽተተ? ይንትስ አማኖ ዋይዝ ꬋብዶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ኡንቲ ጋማ ዣሽቲ ፋ ግዳ፥ «Ꮉይ መለ አቶ የዝን፥ ጎተን አባን ኪትንትዘ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","የሱሳን ኤ ታማሩንꬅ አባ ፊንግ፥ ገርገሶነ ጋዘ ሳአ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","የሱሳ ጎንግዘፓ ዎꬍዘ ዎደ ቱና አያና አይክደ ፈቲ አꬄ ቦዛፓ ኬዚ ኤራ የልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","የ አꬄ ቦዛ ግዳ አቂ ፌዢ የነ። ኤዛ ኦደን ጋደራ አጮደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ኤ ጋማ ቶሄ ዱላራን ሳንꬃላታራ አጭንቲ የነ። የዝን ሳንꬃላቶን ዱꬃነ፥ ዱልዛን መንꬅꬃነ። ኤዛ ማሆደስ ዳንዳእዘ ኦደን ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ኤ ቃማን አዋራ ይና ቦዝተን ደረላን ዉይሳነ፥ ፋ ጋልቶን ሹቻራ ቃዉጻነ። ");
INSERT INTO oyde_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","የሱሳ Ꮉኮራ ብእደ ዎደ ዎጺ Ꮉንግ ኤ ቲንተ ቡንቁንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","የ አꬄ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ኡባፓ ካታራ የዘ ጾዘ ናአ የሱሳ፥ ኔራ ታና አኮ የልꬅዘ? ታና ꬋብሳመ ጋር ታኒ ነና ጾዘ ሱንꬅተ ዎሳነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ኤ ይኖ ጋይዳና የሱሳ ኤዛ፥ «ናተ Ꮉይ ቱና አያንዛዮ፥ Ꮉይ አꬄፓ ከዞ» ያጋይደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","የሱሳ ኤጎ፥ «ነ ሱንꬅታ ኦደ?» ያጋእ ኦጭዳ። ኤ፥ «ኑኒ ጋማ ማቅደ ግሾ ታ ሱንꬅታ ሌግዮና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ቱና አያኑንꬅ ፋና ይና ጋድትፓ ኬሲ ዳካመ ጋር የሱሳ ምንꬂ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","የ ደርዘላ ጋማ ጉዳይለ ዉደ የንግንታነ። ");
INSERT INTO oyde_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ቱና አያኑንꬅ የሱሳጎ፥ «ኑና ሰካ ጉዳይለ ዉዱተ ዳኮያ፥ ኡን ግዳ Ꮉንግ ገሎዳ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","የሱሳ ኡንታጎ፥ «ቅቶተ» ያጋይዳ። ዬዝን ቱና አያኑንꬅ አꬄፓ ኬዚ ጉዳይሉንꬅ ግዳ ገልዳ። ላምእ ሙኩል ማቃደ ጉዳይለ ዉደ ጋጋ ዶናራ ዎጺ Ꮉንግ አባ ገሊ ቆꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ጉዳይለ ዉደ የንግዙንꬅ ዎጺ Ꮉንግ Ꮉንዳኖ ካታማራን ጋጻረራ ኦህዳ። የዝን አሱንꬅ Ꮉንዳኖ በአደስ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","አሱንꬅ የሱሳጎ የእዘ ዎደ ቱና አያናራ አይክንትደ አꬃ ብእዳ። ኤ ፋ ዎዝንተ ማቂ፥ ማኦ ማእ፥ እዘ በትዳኖ በእዘ ዎደ ኡቡንꬅ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ይኖ ብእደ ጋር አሱንꬅ ቱና አያኑንꬅ አይክደ አꬄላ አፋን ጉዳይሉንꬃላ አፋ Ꮉንዳኖ ኡባ አሱንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ይኒ ግሾ፥ አሱንꬅ ፋ ሳእትፓ የሱሳ ከዞደ ጋር ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","የሱሳ ጎንግተ ገልዘ ዎደ ቲኖ ቱና አያና አይኪ ዳክደ አꬄ፥ የሱሳራ Ꮉንጎደስ ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","የዝን የሱሳ እጺ ኤጎ፥ «ነ ካራ ማቂ፥ ላꬂ ኔስ አኮ ጋር ዳማ ባዝ ኦቼዛኮን አኮ ጋር ማረዛኮ ነ ካራ አሱንꬅስ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","አꬃይ Ꮉንግ ታጵ ካታማ ጋእንትዘ ሳአ ዉቲ፥ የሱሳ ፋስ አኮ ጋር ዳማ ባዝ ኦቼዛኮ ኦህዳ። ኤ ኦህዳኖ ስእደ አሱንꬅ ኡቡንꬅ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","የሱሳ ማቂ፥ ጎንገ ገሊ፥ አባ ፊንግዳንፓ ሱባ ጋማ አሱንꬅ አባ ጋጻ ኤ ካለ ዉቲ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","እያሮሳ ጋዘ አይሁደ ዎሳ ኬꬃ Ꮉላቁንꬃፓ ፈተ፥ የሱሳ ብእደ ዎደ ኤጎ ይእ ኤ ቶህትላ አፋ ");
INSERT INTO oyde_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ጎልእ፥ «ታ ናታ Ꮉርግንቲ Ꮉይቆደስ ይእነ። እዛ ፋጺ የሳደ ጋር ይእ ነ ኩሽቶ ኢላ አፋ ጋዶያ» ያጋእ የሱሳ ምንꬂ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","የሱሳ እያሮሳራ ቅትዳ። ኤ Ꮉማደራ ጋማ አሱንꬅ ኤዛ ካሊ ኡንእꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ታጶ ላምእ በረ እ ጋልትፓ ሱꬅ ጎግዘ ፈቲ ማችታ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ጋማ አክሙንꬅ እዞ አክምዳ፥ የዝን እዛ ፋጻ ካእንትዳ። እዛ ፋ ቆልቶ ኡባ Ꮉስንን ኢስ Ꮉንካ ኢትዳፕ አትን አኮን ማድካያ። ");
INSERT INTO oyde_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ይና ማችታ የሱሳ ባዝ ስእ፥ አሱንꬃና አꬊ የሱሳ ሱባራ ይእ ኤ ማእቶ ቦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","እዛ፥ «ታኒ መለ አቶ የዝን ኤ ማእቶ ቦችዛኮ ፋጾዳ» ጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ኢፓ ጎግዘ ሱꬅታ ኢራ ኤቂ አትዳ። እዛ ፋ ዋይትፓ ፋጽዳኖ ፋ ጋልተ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","የሱሳ ኢራ ፋፓ ዎልቃ ኬዝዳኖ ፋ ኦምተ ኤሪ፥ ጋማ አስ ግዳ ሱብ ማቂ፥ «ታ ማእቶ ቦችደ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ኤ ታማሩንꬅ፥ «አሱንꬅ ነና ኡርቂዛኖ ብእተራ፥ ‹ዋይዝ ታና ኦደ ቦችደ ጋኤ?› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","የሱሳ ይኖ ኦኒ ኦቼዛኮ በአደስ ዉቱꬂ ዳኪ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","የዝን ማችታ ፋስ Ꮉንዳኖ ኤሪ፥ ዣሽሞራ ጎቅተራ ይእ የሱሳ ቲንተ ጎልእዳ፤ ማህ Ꮉንዳኖ ኡባ ቱርቶ ኤስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","የይን፥ የሱሳ ኢጎ፥ «ናእተ፥ ነና ነ አማንታ ፋꬅዳ፥ ሳሮራ ቅቶ፥ ነ ዋይትፓ ፋጾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","የሱሳ Ꮉጋ ይኖ ኦሆደራ፥ አይሁደ ዎሳ ኬꬃ Ꮉላቃ ካራፓ ኪትንትደ አሱንꬅ ይእ፥ «ነ ናታ Ꮉይቂዳ፥ አስታማርዛ አኮስ ላቢዘ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","የዝን የሱሳ ኡን ጋዛኖ ስእ፥ አይሁደ ዎሳ ኬꬃ Ꮉላቅዘጎ፥ «አማኖ ጻላላ አማኖፕ አትን ዣሽትፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","የሱሳ ጴጥሮሳፓ፥ ያይቆባፓን ያይቆባ እሸ ዋሐንሳፓ መለ ኦደን ፋና ካላመ ጋር ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ኡንቲ አይሁደ ዎሳ ኬꬃ Ꮉላቅዘ ካራ የልደ ዎደ የሱሳ አሱንꬅ ዎዝና ꬋቢ ዬክዙንꬃናን ዘለሉንꬃና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ገሊ አሱንꬃጎ፥ «አኮስ ሙዢ ዬከተ? ናታ ገንትዳፕ አትን Ꮉይቂካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","አሱንꬅ ኤላ አፋ ሚጭዳ። የዝን አሱንꬃና ኡባ ባለ ኬሲ፥ ናቲ አዳያን፥ እንቶን Ꮉይꬕ ታማሩንꬃና ፋራ ኤኪ ናታ የዘ በስተ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","የሱሳ ናቲ ኩሽቶ አይኪ፥ «ጻልታ፥ ቁሚ» (ኤራꬅ ናእተ፥ ነና ጋነ ደንዶ) ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ናታ ኢራ ደንዲ ኤቂ የꬍዳ። እዛ ታጶ ላምእ በረ ናአ። ይነ አሱንꬅ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","የሱሳ ይኖ ኡን ኦደስን ኦሃመ ጋር ኡንታና ምንꬂ ኪትዳ። ኡንቲ ኢስ ሙእዘ ባዝ እማደ ጋር ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","የሱሳ እዝፓ ኬዚ፥ ፋ ታማሩንꬃና ካልꬅ፥ ፋ ካታማ ናዝረተ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ሳምባታ ዎደ አይሁደ ዎሳ ኬꬃ ታማርሰ አይክዳ። ኤ ታማርስዛኖ ስእደ ጋማ አሱንꬅ ጋማ ቆፒ፥ «Ꮉይ Ꮉኖ ኡባ አባፓ ደንግዶ? Ꮉና ጭንጫትꬅታ ኤስ አናፕ እንግንትዶ? Ꮉና ኤ ኩሽተ ኦችንትዘ ክለ ባዝቶ ኦችዘ ዎልቃ ኤስ ኦኒ እንግዶ? ");
INSERT INTO oyde_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ꮉይ አናጸ ናአ ባነ? ማይራም ናአ፥ ያይቆባ፥ ዮሳ፥ ይሁዳን ስሞና እሸ ባነ? ኤ ምሹንꬅ ኑራ Ꮉነ የዙንꬃና ባነ?» ያጋእ፥ ኤ ጋዛኖ ስአንጽ እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","የሱሳ የንꬅ አሱንꬃጎ፥ «ናበ ፋ ጋደ፥ ፋ እግኑንꬅ ግዳን ፋ ካራ አሱንꬅ ግዳ ቦንችንቶስ ፋትን መሉንꬅ ካለ ቦንችንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ኤ ይና በስተ ፋ ኩሽቶ ኤራꬅ አሱንꬃላ አፋ ጋዲ ፋꬅዳንፕ መለ ጋማ ቆፍዘ ባዝ ኦቾደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","አሱንꬅ አማንካይዘ ግሾ ጋማ ቆፕዳ። ይንፓ ሱባ የሱሳ ይና ጉቱተ የዘ አሱንꬃና ታማርሳነ። ");
INSERT INTO oyde_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","የሱሳ ታጶ ላምእ ታማሩንꬃና ፋጎ ጼጊ፥ ላምእ ላምእ ማህ ኪትዳ። ኡንትስ ቱና አያናላ አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ኡንታና፥ «ኦገስ ጉፈፕ አትን ካꬃ፥ ካርጥተ፥ ይን ኪስተ ብራ አኮ ባዝን አይክፐተ። ");
INSERT INTO oyde_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ይን ቶህተ ጫማ ኣꬆተ፥ ፋትን ላምእ አፉላ አይክፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ማህን፥ «ይንታና አስ ሞክዘ ኬꬃ አባ ማቅኮን ይና በስትፓ ኬዚ ቅቶደ ዎንꬅስ ይና ኬꬅተ ጋምኦተ። ");
INSERT INTO oyde_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ይንታና አስ ሞኮሰ በሳ ዎይ ይን ኦህዛኖ ስኦሰ በሳ አባን ማቅኮ፥ ይና ሳእተ የዘ አሱንꬅስ ይን ማርካ ማቃደ ጋር ይና በስትፓ ከዝተራ፥ ይን ቶህተ የዘ ጹርቶ ፍጾተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ታጶ ላምእ ታማሩንꬅ Ꮉንግ፥ አሱንꬅ ፋ ናጋርትፓ ማቃደ ጋር ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ኡንቲ አሳፓ ጋማ ቱና አያና ከስዳ። ጋማ Ꮉርግንትዙንꬃና ዛይተ ትዢ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","የሱሳ ሱንꬅታ ኡባ በሳ ከዝደ ግሾ ካት ሄሮድሳ ኤ ባዝ ስእዳ። ፈቲ ፈቲ አሱንꬅ፥ «ጻማቅዘ ዋሐንሳ Ꮉይቆፓ ደንድዳ፥ ይኒ ግሾ Ꮉና ክለ ባዝቶ ኦችዘ ኤዛ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ባጉንꬅ፥ «Ꮉይ ኤልያሳ» ያጋይዳ። መሉንꬅ ማህ፥ «Ꮉይ ዛጋ ዎደ ናቡንꬃፓ ፈታያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","የዝን ሄሮድሳ ይኖ ስእደ ዎደ «Ꮉይ ታኒ አፉርቶ ጋችዝደ ጻማቅዘ ዋሐንሳ። ኤ Ꮉይቆፓ ደንድዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ሄሮድሳ ፋ እሸ ፍልጶሳ ማችቶ ሄሮድያዳ ኤክደ ግሾ እ ምክናትስ ዋሐንሳ አይꬂ አጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ዋሐንሳ ሄሮድሳጎ፥ «ኔኒ ነ እሸ ማችቶ ኤኮደስ ቤዞስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ሄሮድያዳ ዋሐንሳ ፋ ዎዝንተ እጺ ኤዛ ዎዽሳደስ ኮይዳ፥ የዝን ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ዋሐንሳ ጽሎን ጌሽ አስ ማቅዳኖ ሄሮድሳ ኤርደ ግሾ ኤስ ዣሽቲ ሎይꬂ ናግዛነ። ሄሮድሳ ዋሐንሳ ጋዘ ባዝ ስእዘ ዎደ ታናነ። የዝን ኡፋይት ስእነ። ");
INSERT INTO oyde_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ሄሮድሳ ፋ የልንትደ ቃምቶ ቦንቾደስ ጋደ አህዙንꬃና፥ ሻላቁንꬅስን ጋልላ የዘ ዳማ አሱንꬅስ ድግሳ ጊግዝዳ። ይና ሄሮድያዳስ ዎትዘ ዎደ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ሄሮድያዳ ናእታ ዛቁንꬅ ሞኩንትዘ ኬꬃ ገሊ ዱሪ፥ ሄሮድሳን ኤ ዛቁንꬃና ኡፋይስዳ። ካትዘ ናትጎ፥ «ነ ኮይዘ አኮ ማቅኮን ታና ኦጮ፥ ታ ኔስ እንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ማህ ኢስ ጫቂ፥ «ኔኒ ኦጭዘ አኮ ማቅኮን፥ ታኒ ኔስ እንጎዳ። መለ አቶ የዝን፥ ታ ካእቱምት ባግቶ ማቅኮን ታ ኔስ እንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ናታ ባለ ኬዚ ፋ እንትጎ፥ «አኮ እንጎ ጋዉነ?» ጋእ ኦጭዳ። እ እንታ፥ «ጻማቅዘ ዋሐንሳ ኦምቶ እንጎ ጋኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ናታ ኤልሲ ካትዘጎ Ꮉንግ፥ «ጻማቅዘ ዋሐንሳ ኦምቶ ሳነ ግዳ ጋዲ Ꮉተ ታስ እማደ ጋር ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ያጋእን ካትዘ ጋማ ዥልꬍዳ፥ የዝን ፋ ዛቁንꬅ ግሾ ኢስ ጫቂደ ፋ ጫቅቶ አሾደስ ኮይካያ። ");
INSERT INTO oyde_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ይኒ ግሾ፥ ኤልሲ ናግዘጎ ዋሐንሳ ኦምቶ ኮኦደ ጋር ኪትዳ። ናግዘን አች ኬꬃ Ꮉንግ ዋሐንሳ አፉርቶ ጋችዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","የ ጋችንትደ ኦምዛ ሳነ ግዳ ጋዲ ክእ ናትስ እንግዳ። ናታ ማህ ፋ እንትስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ዋሐንሳ ታማሩንꬅ ይኖ ስእደ ዎደ Ꮉንግ ኤ አህቶ ኤኪ ካንግ ሞግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ታጶ ላምእ ሐዋሩንꬅ ማቂ ይእ ኡን ኦችዳኖን ታማርስዳኖ ኡባ የሱሳስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ኡንታጎ ይእዘ አሱንꬅን ቅትዘ አሱንꬅ ጋንግደ ግሾ የሱሳራን ኤ ታማሩንꬃራ፥ መለ አቶ የዝን ካꬃ ማደስን ኡንታና የልꬃንጽ እጽዳ። የይን፥ የሱሳ ኡንታጎ፥ «የኦተ ዎላ ኤራꬅ ሸምፖደስ አስ ባይዘ በሳ የꬎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ይኒ ግሾ፥ ኡንቲ ፋ ፋስ ጎንገ ገሊ አስ ባይዘ በሳ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ኡንቲ Ꮉማደራ ጋማ አሱንꬅ ኡንታና ብእ ኤርዳ። የዝን፥ ካታማ ኡባፓ አሱንꬅ ቶሄራ ዎጺ Ꮉንግ ኡን ቅትዘ በስቶ ኡንታፓ ቲኒ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","የሱሳ ጎንግዘፓ ዎꬊ ጋማ አሱንꬃና ብእዳ። አሱንꬅ የንግዘ አስ ባይዘ ዱሮ ፋና ማቅዳኖ ብእ ኡንትስ ይቅስንቲ ኡንታና ጋማ ባዝ ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ሳእታ ኡጉርዘ ዎደ የሱሳ ታማሩንꬅ ኤጎ ይእ፥ «Ꮉና በስታ አስ ባይዘ በሲ፤ Ꮉተ ሳእታን ቃምዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","አሱንꬅ ካራ ጋንጨን ካታማ Ꮉንግ ፋስ ሙእዘ ባዝ ዎንጎደ ጋር አሱንꬃና ዳኮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","የዝን የሱሳ ማህ ኡንታጎ፥ «አሱንꬅስ ሙእዘ ባዝ ይን እንጎተ» ያጋይዳ። ኡን፥ «ኑኒ Ꮉንግ ላምእ ጼት ድናረር ቦራ ዎንግ አሱንꬃና ሙዞደ ጋር ኮያነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","የሱሳ ኡንታጎ፥ «ይንትስ ዋንꬅ ቦራ የዘ? አነ Ꮉንግ ቦኦተ» ያጋይዳ። ኡንቲ ብእ፥ «እችን ቦራን ላምእ ሞሎን» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","የሱሳ ፋ ታማሩንꬃጎ አሱንꬃና ኡባ ጋቾ ጋቾ ታጊ በትꬆደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","አሱንꬅ ባግታ ጼት፥ ባግታ እችንታም ማቂ ልከራ ልከራ ታግንት በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","የሱሳ እችን ቦርቶን ላምእ ሞሉንꬃና ኤኪ፥ ኡደ ሳሎ ብእ ጾዝ ጋላትዳ። ቦርቶ ባጽ አሱንꬅስ የልꬆደ ጋር ታማሩንꬅስ እንግዳ። ማህ ላምእ ሞሉንꬃና ኡን ኡቡንꬅስ ግሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","አሱንꬅ ኡባ ሙእ ምዥዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","አትደ ቦራ ጉፋን ሞሎ ጉፋን፥ ኤ ታማሩንꬅ ታጶ ላምእ ሌማተ ኩሙꬅ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ቦርቶ ሙእደ ꬊራꬅ አሱንꬅ ጻላላ እችን ሙኩል ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ኤልሲ የሱሳ ፋ ታማሩንꬅ ጎንገ ገሊ፥ አባፓ ሰኮ ፍንꬃ የዘ ቤተሳይዳ ፋፓ ቲኒ ቅቶደ ጋር ኪትዳ። የዝን ፋስ አሱንꬃና ሞይዞደስ ሱብ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","አሱንꬃና ሞይዝዳንፓ ሱባ ጾዝ ዎሶደስ ደረላ አፋ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ሳእታ ቃምዘ ዎደ ጎንግዘ አባ ግዳ የነ፥ የዝን የሱሳ አባፓ ጋጻ ፋስ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ባቆ ኤ ታማሩንꬃጎ ባቅዘ ግሾ አባ ፍዽዛና ዋይስዛኖ የሱሳ ብእዳ። ዎንት ማ ሉኩለ ኦሎደስ ይእዘ ዎደ ኤ አባላ አፋ የꬍተራ ኡንታጎ ይእ፥ ኡንታና ኦሊ አꬋደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","የዝን ኤ አባላ አፋ የꬋደራ፥ ኡን ብእ፥ ኡንትስ ሜሸ አዝን ዉይስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ኡን ኡቡንꬅ ኤዛ ብእ፥ ዣሽሞራ ታንዳ። የዝን የሱሳ ኤልሲ ኡንታጎ፥ «ታና፥ አኮን ባያ፤ ዣሽትፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ኤ ጎንገ ገሊ ኡንታራ ዎላ በትን ባቅታ ዎፑ ጋይዳ። ኡንቲ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ኡን ዎዝንታ ዶጭደ ግሾ ኡን ቦርቲ ባዝ ቲሪካያ። ");
INSERT INTO oyde_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ኡንቲ አባ ፊንግ፥ ጌንሳሬጠ ሳአ የሊ፥ ጎንግዛ ጋጻላ ሺሺ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ኡንቲ ጎንግዘፓ ዎꬍዘ ዎደ አሱንꬅ ኤልሲ የሱሳ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ኡንቲ ካራ ጋንጨ የዘ ሳአ ኡባ ዎጺ የሊ Ꮉርግንትዙንꬃና ሻንቻፋራ ቶኪ፥ «የሱሳ የነ» ጋእን ስእደ በስተ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","አሱንꬅ ኤ Ꮉንግደ ኬꬃ ኡባ፥ ጋጻረ ማቅኮን፥ ካታማ፥ የዘ Ꮉርግንትዙንꬃና አስ ሺቅዘ በሳ ካንጋነ። Ꮉርጋንቹንꬂ ኤ አፉላ ማጫርቶ ማቅኮን ቦቾደ ጋር አሱንꬅ ኤዛ ዎስዳ። ቦችደ ኡቡንꬅ ፋጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","የሩሳላመፓ ይእደ ፈቲ ፈቲ ፋርሳዉንꬅን ህገ አስታማሩንꬅን የሱሳ ካለ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","የሱሳ ታማሩንꬃፓ ፈተ ፈተ ጌዥካይዘ ኩሸራ፥ ይናን ኩሸ ሜጭካይዛራ ካꬃ ሙዙንꬃና ኡን ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፋርሳዉንꬅን አይሁደ አሱንꬅ ኡባ ፋ አዱንꬅ ዎግት ጋር ፋ ኩሽቶ ሜጭካይዛራ ሞኦስ። ");
INSERT INTO oyde_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ይኒ ጋራ፥ ኡን ጋበፓ ዎንግ ማቂ ሜጭንትካይዛር ሞኦስ። ማህ ኡን ፋ አዱንꬃፓ ኤክደ መለ ጋማ ዎጋ የነ፦ ይናን ስነ፥ ጻሮ፥ መቆ ሚሸ ዳꬃን ጌሽዘ ዎጋ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ፋርሳዉንꬅን ህገ አስታማሩንꬅን የሱሳ፥ «ነ ታማሩንꬅ አኮስ አዱንꬅ ዎጋ መንꬂ ፋ ኩሽቶ ሜጭካይዛራ ካꬃ መኤ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","የሱሳ ኡንታጎ፥ «ኢሳያሳ ይን ጩቡንꬆ፥ «Ꮉንꬅ አሱንꬅ ታና ፋ ዶናራ ጻላላ ቦንቻነፕ፥ አትን ኡን ዎዝንታ ታፓ Ꮉኮ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","አስ መꬍደ ዎጋ ጾዘ ህገ አዝዝ ታማርስዘ ግሾ ኡን ታና Ꮉፖ ጎይናነ» ጋእ ጻፍደ ትንቢታ ቱሮ። ");
INSERT INTO oyde_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«ይንቲ ጾዘ ኪታ አሺ አስ ዎጋ ናጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ማህን የሱሳ፥ «ይን ይን ዎጋ ናጊ ጾዘ ኪቶ ኦሊ አሾደስ ሎኦ ኦገ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙሴ፥ ‹ነ አዳያን ነ እንቶን ቦንቾ›፥ ማህ ‹ፋ አዳያን ዎይ ፋ እንቶ ጫዥደ Ꮉይቆደስ ቤዛነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","የዝን ፈቲ አስ ፋ አዳያን ዎይ ፋ እንቶን ማዶዳኖ አሺ፥ ‹ይና ጾዘ ዣርሾ› ጋእኮ፥ ");
INSERT INTO oyde_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ኤ ፋ አዳያን ዎይ ፋ እንቶን ማዳመ ጋር ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ይኒ ጋራ፥ ይን መሉንꬃና ታማርስደ ይን ዎግትራ ጾዘ ቃላ ለቂዳ። ይኒ ፋና መለ ጋማ ባዝ ኦቻነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","የሱሳ ጋማ አሱንꬃና ማህ ፋጎ ጼጊ፥ «ኡቡንꬅ ታ ኦህዛኖ ስኦተ ቲሮተ። ");
INSERT INTO oyde_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","አስ ዎዝናፓ ከዘ ባዝ አስ ቱንዛነፕ አትን ባለፓ አስ ሳዛ ገሊ አስ ቱንዘ አኮን ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ስእዘ Ꮉየ የዘ ኦደን ስኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","የሱሳ ጋማ አሱንꬃና አሺ አሺ ኬꬃ ገልን ኤ ታማሩንꬅ ይና አዝዝቲ ባዝ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ኤ ኡንታጎ፥ «ይንትስን ማህ ገልካነ? ባለፓ አስ ዎዝና ገልዘ አኮ ባዝን አስ ቱንሳደስ ዳንዳኦሳና ገሎሳነ? ");
INSERT INTO oyde_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","አኮስ ጋይኮ፥ ካꬃ አስ ሳዛ ግዳ ገሊ ፋ ኦግትራ አꬋነፕ አትን አስ ዎዝና ግዳ ገሎስ» ያጋይዳ። ይነ የሱሳ ካꬃ ኡባ ጌሽ ማቅዛኖ ኤርስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ካሊ፥ የሱሳ፥ «አስ ቱንዘ ባዝ አስ ዎዝና ግዳፓ ከዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","አስ ዎዝና ግዳፓ ከዘ ባዝ ኢታ ቆፋ፥ ጎመ ዎይኤ፥ ካይዞ፥ አስ ዎ፥ ");
INSERT INTO oyde_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ኦላለ፥ ዥንባርትሞ፥ ኢታትꬅ፥ ገነ፥ ቃይጸ፥ ጭሞ፥ ቃናኤ፥ ጫሽ፥ ኡቱራን ቦዛትꬅ። ");
INSERT INTO oyde_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ꮉና ኢታባዝታ ኡባ አስ ዎዝና ግዳፓ ኬዚ አስ ቱንዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","የሱሳ ይንፓ ኬዚ፥ ጢሮሳ ካታማ ካለ የዘ ሳአ ቅትዳ። ኤ ፈቲ ኬꬃ ገሊ እዘ የዛኖ ኦደን ኤሮደ ጋር ኮይካያ። ይኖ ማቅኮን አችንት ጋምኦደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","የዝን እ ኤራꬅ ናእቶ ቱና አያና አይክደ ፈቲ ማችታ የሱሳ ባዝ ስእ ኤልሲ ኤጎ ይእ ኤ ቶህትላ አፋ ጎልእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","እዛ የልንትዳና ሶርያ ግዳ ፍንቀ ጋዘ ሳአ የልንትደ ግርኬ ማቾ። እዛ፥ ፋ ናትፓ ቱና አያንዛ ከሶደ ጋር የሱሳ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","የዝን የሱሳ ማህ፥ «ናኡንꬅ ቲንꬊ ካꬃ ሙእ ምዦ፤ ናኡንꬅ ካꬅቶ ኤኪ ካኑንꬅስ ኦልዛና ሎኦ ማቆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ማችታ ማህ፥ «ታ ላꬃዮ ይና ቱሮ፥ የዝን ሌማተ ካለ የዘ ካኑንꬅ ናኡንꬃፓ ዎꬍደ ጉፍቶ ሙነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","የሱሳ ማህ ኢጎ፥ «Ꮉኖ ነ ኦህደ ግሾ ነ ካራ ቅቶ፤ ቱና አያንዘ ነ ናትፓ ከዝዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ማችታ ፋ ካራ Ꮉንግዘ ዎደ ቱና አያንዘ ናትፓ ከዝን ይꬃ ዎይእዳኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","የሱሳ ጢሮሳ ካታማፓ ኬዚ፥ ስዶናራን ታጵ ካታማ ጋዘ ሳአራ አꬊ ጋልላ አባጎ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","አሱንꬅ ቱለን ዶና ሙመ አስ የሱሳጎ ክእ፥ ፋ ኩሽቶ ኤላ ጋዶደ ጋር ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","የሱሳ ፋስ የ አꬃ ጋማ አሳፓ ጋጻ ኬሲ፥ ፋ ግልእዛ ኤ Ꮉይተ ዳክዳ። ማህ ጩች ጩቲ ኤ እልአንꬅቶ ቦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ሳሎ ኡደ ብእ፥ ጋዲ ሸምፒ፥ «ኤፍታህ» ጋይዳ። ብልꬅታን «ቡጉንቶ» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","አꬄ Ꮉይታ ኤልሲ ቡጉንትዳ፥ አጭንትደ እልአንꬅታን ብልንትዳ፥ አꬄ ጌሽ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","የሱሳ አሱንꬃጎ፥ «Ꮉኖ ኦደስን ኦህፐተ» ያጋይዳ። የዝን ኤ ጋማ ምንꬂ ኦህፐተ ጋእን፥ አሱንꬅ ኦህቶ ጎደ ጋንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ይኖ ስእደ አሱንꬅ ኡባ ጋማ ቆፒ፥ «ኡባባዝቶ ኤ ሎይꬂ ኦቻነ። መለ አቶ የዝን፥ ቱልዛ ስሳነ፥ ሙምዛ ኦህዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ኤራꬅ ዎደፓ ሱባ፥ ጋማ አሱንꬅ የሱሳጎ ሺቅዳ። አሱንꬅስ ሙእዘባዝ ꬋብን የሱሳ ፋ ታማሩንꬃና ፋጎ ጼጊ፥ ");
INSERT INTO oyde_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ꮉንꬅ አሱንꬅ ታራ Ꮉይꬕ ቃማ የሎደስ ጋምእ፥ አኮን ሙእዘ ባዝ ደንግካይዘ ግሾ ታና አሱንꬅ ባዝታ ይቅሳነ። ");
INSERT INTO oyde_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ታኒ አሱንꬃና ናየራ ካራ ዳክኮ አሱንꬅ Ꮉንግተራ ኦገ ላቢ ጎልኦዳ፥ ባገ አሱንꬅ Ꮉኮ በሳፓ ይእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","የሱሳ ታማሩንꬅ ማህ፥ «Ꮉና አኮ ባይዘ ጋናሳ Ꮉንꬅ አሱንꬃና ኡባ ሙሳደስ ማቃደ ካꬃ ደንጎደስ ዳንዳኦደ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","የሱሳ ኡንታጎ፥ «ይን ካለ ዋንꬅ ቦራ የዘ?» ጋእ ኦጭዳ። ኡን ማህ፥ «ላፑን ቦራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","የሱሳ አሱንꬅ ሳአላ በቶደ ጋር ኪትዳ። የይዝ፥ ላፑን ቦርቶ ኤኪ ጾዝ ጋላቲ ማቂ ቦርቶ ባጽ፥ አሱንꬃና የልꬆደ ጋር ፋ ታማሩንꬅስ እንግዳ። ኤ ታማሩንꬅ አሱንꬅስ ግዥዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ኡንትስ ማህ ኤራꬅን ይሻ ሞሉንꬅ የነ። የሱሳ ይና ሞሉንꬅ ግሾ ጾዝ ጋላቲ፥ አሱንꬅስ የልꬆደ ጋር ፋ ታማሩንꬃና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","አሱንꬅ ኡቡንꬅ ሙእ ምዥዳ። ኤ ታማሩንꬅ ሙእን አትደ ጉፋ ላፑን ሌማተ ኩሙꬅ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ካꬃ ሙእደ አሱንꬅ ፋይድታ ኦይዲ ሙኩል ማቃዳ። ይንፓ ሱባ፥ የሱሳ አሱንꬃና ሞይዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ኤ ማህ ፋ ታማሩንꬃራ ኤልሲ ጎንገ ገሊ ዳልማኑታ ጋዘ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፋርሳዉንꬅ ይእ የሱሳ ኦጮደስ ኮይ፥ ሳሎፓ ፋና ማላ ቤሳደ ጋር የሱሳራ ላለ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","የሱሳ ጋዲ ሸምፒ፥ «Ꮉና ዎደ አሱንꬅ አኮስ ማላ ኮየ? ታኒ ይንትስ ቱሮ ኦህነ፤ Ꮉና ዎደ አሱንꬅስ አኮ ማላን እንግንቶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ኤ ኡንታና እዘ ኦሊ አሺ ማህ ጎንገ ገሊ አባፓ ሰኮ ፍንꬃ ፊንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ኤ ታማሩንꬅ ካꬃ አይኮዳኖ ቦትዳ፤ ኡንትስ ጎንገ ግዳ ፈቲ ቦራፓ መለ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","የሱሳ ኡንታጎ፥ «ይንታና ኤሮተ። ፋርሳዉንꬅ እርሽትፓን ሄሮድሳ እርሽትፓ ናግንቶተ» ያጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ኡን ዎል ግዳ፥ «ኤ Ꮉኖ ጋዛና ኑስ ቦራ ባይዘ ግሾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","የሱሳ ኡን ጋዛኖ ኤሪ ኡንታጎ፥ «ይንትስ ቦራ ባይዘ ግሾ አኮስ ኦህንተ? Ꮉተን ኤሮስተ? ዎይ ቲሮስተ? ይን ዎዝንታ ዶጭዳ? ");
INSERT INTO oyde_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ይንትስ ኣፈ የዝን ቦኦስተ? Ꮉየ የዝን ስኦስተ? ይን ቲራነ? ");
INSERT INTO oyde_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ታኒ እችን ቦራ እችን ሙኩል አሱንꬅስ የልꬅዘ ዎደ ዋንꬅ ሌማተ ኩሙꬅ ጉፋ ደንꬅዶ?» ያጋይዳ። ኡንትን፥ «ታጶ ላምእ ሌማተ ኩሙꬅ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«ይኒ ጋራ፥ ታኒ ላፑን ቦራ ኦይዲ ሙኩል አሱንꬅስ የልꬅደ ዎደ ዋንꬅ ሌማተ ኩሙꬅ ጉፋ ደንꬅዶ?» ያጋይዳ። ኡን፥ «ላፑን ሌማተ ኩሙꬅ ደንꬅዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ዬዝን፥ «Ꮉተን ቲሪካነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ኡንቲ ቤተሳይዳ ካታማ ቅትዳ። ኤራꬅ አሱንꬅ ቆቀ አꬃ የሱሳጎ ክእ የ አꬃ ግርሞደ ጋር ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","የሱሳ ቆቀ አꬄ ኩሽቶ አይኪ ካታማፓ ጋጻ ከስዳ። ኤ ኣፍተ ጩቲ ፋ ኩሽቶ ኣፍትላ አፋ ጋዲ፥ «ኔስ አኮ በንታነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","አꬃይ ꬎቅ ጋእ ብእ፥ «ታስ አሱንꬅ በንታነ፥ የዝን አሱንꬅ ምንጻ ጋር ኤንአነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ይንፓ ሱባ፥ የሱሳ ማህ፥ አꬄ ኣፍተ ፋ ኩሽቶ ጋድዳ። አꬃይን ሎይꬂ ብእዳ፥ ፋጽን ኡባ ባዝ ሻኪ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","የሱሳ አꬄጎ፥ «ነ ካራ ቅቶ፥ የዝን ካታማ ገልፐ» ያጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","የሱሳ ፋ ታማሩንꬃራ ቂሳርያ ፍልጶሳ ካለ የዘ ካራ ጋንጨ ቅትዳ። ኡንቲ Ꮉማደራ ኦገላ የዝን የሱሳ፥ «ታና አሱንꬅ ኦና ጋኤ?» ያጋእ ፋ ታማሩንꬃና ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ኤ ታማሩንꬅ፥ «ፈቲ ፈቲ አሱንꬅ ነና፥ ‹ጻማቅዘ ዋሐንሳ› ጋነ፤ መሉንꬅ፥ ‹ኤልያሳ ጋነ› ማህ መሉንꬅ፥ ‹ናቡንꬃፓ ፈታ› ጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","የሱሳ ኡንታጎ፥ «ዬዝን ይን ታና ኦና ጋኤ?» ያጋእ ኦጭዳ። ጴጥሮሳ፥ «ኔኒ ክርስቶሳ » ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","የሱሳ፥ «ታ ባዝ ኦደስን ኦህፐተ» ያጋእ ኡንታና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","የሱሳ ፋ ታማሩንꬃጎ፥ «አስ ናአይ፥ ጋማ ማꬋ ኤኮደስ ቤዛነ፤ ጭሙንꬅ፥ ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬅ ኤዛ እጾደስ ቤዛነ። ኡንቲ ኤዛ ዎꬎደስን Ꮉይꬕ ቃማፓ ሱባ፥ ኤ Ꮉይቆፓ ደንዶደስ ቤዛነ» ያጋእ ኡንታና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ኤ ይኖ ኡንትስ ሎይꬂ ኦህዳ። ጴጥሮሳ ኤዛ ፈቲ ዛላ ማህ ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","የዝን የሱሳ ሱባ ማቂ፥ ፋ ታማሩንꬃና ብእ፥ ጴጥሮሳ ካጪ፥ «Ꮉይ ጻላህዛይ፥ ታፓ Ꮉኮ። ኔኒ አስ ካꬍዘባዝ ቆፓነፕ አትን ጾዚ ካꬍዘባዝ ቆፖስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ማህካ የሱሳ ጋማ አስን ፋ ታማሩንꬃና ፋጎ ጼጊ፥ «ታና ካሎደስ ኮይዘ ኦደን ፋና ካዶ፤ ፋ ማስቃልቶ ቶኪ ታና ካሎ። ");
INSERT INTO oyde_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ፋ ሸምፕቶ አሾደስ ኮይዘ አꬄ ꬋብሶዳ። የዝን ታ ግሾን ዎንገለ ግሾን ፋ ሸምፕቶ ꬋብስዘ አꬄ አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","አስ ሳአላ የዘ አላምቶ ትርፍዛኮ፥ ፋ ሸምፕቶ ꬋብስኮ ኤዛ አኮ ማዶደ? ");
INSERT INTO oyde_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","አስ ፋ ሸምፕቶ ዎዞደስ አኮ እማደስ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ጾዝ አማኖሰ Ꮉና ኢታ የለቱንꬃፓ፥ ፈቲ አስ ታ ግዳን ታ ቃልተን ዬልꬍኮ፥ አስ ናአይ፥ ማህ ፋ አዳይ ቦንቾራ ጌሽ ኪታንቹንꬃራ የእዘ ዎደ የይጋ ዬልꬎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","የሱሳ ኡንታጎ፥ «ታኒ ይንትስ ቱሮ ኦህነ፤ ጾዘ ካእቱሞ ዎልቃራ ይእዛኖ ብእካይዛራ Ꮉይቃመ ፈቲ ፈቲ አሱንꬅ Ꮉነ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","የሱሳ እዝፑን ቃማፓ ሱባ፥ ፋራ ጴጥሮሳ፥ ያይቆባን ዋሐንሳ ኤኪ፥ ኡንታና ጻላላ ዳማ ደረላ አፋ ኬሲ ኡን ቲኖ ላምንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ኤ ማእታን ፎጭዳ፤ ሳአላ ማኦ ሜጭዘ ኦደን ጌሾደስ ዳንዳኦሰ ፋና ጋማ ቦጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ኤልያሳን ሙሴን የሱሳራ ኦህንቶደራ ኡን ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጴጥሮሳ የሱሳ፥ «አስታማርዛዮ፥ ኑኒ Ꮉነ የዛና ኑስ ሎኦ፤ ኑ Ꮉይꬕ ጋባ ፈታ ኔስ፥ ፈታ ሙሴስ፥ ማህ ፈታ ኤልያሳስ ጋቦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ꮉንኩንꬅ ጋማ ታንደ ግሾ ኤ አኮ ጋዛኮን ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ይንፓ ሱባ፥ ꬎነ ይእ ኡንታና ጎዝን ꬎነ ጋርሳፓ፥ «Ꮉይኒ ታ ካዽዘ፥ ታ ናአያ፥ ኤ ጋዛኖ ስኦተ» ጋዘ ቃላ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ኤልሲ ኡንቲ ዉቱꬂ ዳኪ በእዘ ዎደ የሱሳፕ አትን መለ ኦደን ፋ ካለ ብእካያ። ");
INSERT INTO oyde_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ኡንቲ ደርዘፓ ዎꬎደራ፥ የሱሳ ኡንታጎ፥ «አስ ናአይ፥ Ꮉይቆፓ ደንዶደ ዎንꬅስ፥ ይን ብእዳኖ ኦደስን ኦህፐተ» ያጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ኤ ኪትዳኖ ኡን፥ «የኤ» ጋእ፥ «Ꮉና Ꮉይቆፓ ደንደ ጋዛና አኮ ጋኤ» ጋእ፥ ዎል ግዳ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ኡን ማህ፥ «ህገ አስታማሩንꬅ፥ ‹ኤልያሳ ቲንꬊ ዮኦደስ ቤዛነ› አኮስ ጋኤ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","የሱሳ ማህ «ኤልያሳ ቲንꬊ ይእ፥ ኡባባዝቶ ሎይꬆዳ፤ ዬዝን፥ አኮስ ጌሽ ማጻፍተ፥ ‹አስ ናአይ ጋማ ዋይንቶዳ እጽንቶዳ› ያጋነ ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","የዝን ታኒ ይንትስ ኦህነ፤ ኤልያሳ ይእዳ፤ ማህ ኤ ባዝ ጌሽ ማጻፍተ ጻፍንትዳንጋራ፥ አሱንꬅ ኤላ አፋ ፋ ኮይዳኖ ኦችዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","የሱሳን፥ Ꮉይꬑንꬅ ታማሩንꬃጎ ማቂ የእዘ ዎደ ጋማ አሱንꬅ ኡን ካለ ኤቅዱንꬃናን ህገ አስታማረ ማቅደ ኤራꬅ አሱንꬅ ኡንታራ ላልዛኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ይና ጋማ አሱንꬅ የሱሳ ብእደ ዎደ ጋማ ቆፒ፥ ኤልሲ ኤጎ ዎጺ ይእ፥ ኤዛ ሳሮꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","የሱሳ፥ ጻፉንꬃጎ «ኡንታራ አኮ ላለ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","የንꬅ ጋማ አሱንꬅ ግዳፓ ፈቲ አꬄ ማህ፥ «አስታማርዛዮ፥ ታ ናአይላ አፋ ኦህንቶዳኖ ካይዘ ቱና አያና የዘ ግሾ ኤዛ ኔጎ ኤኪ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ꮉይ ቱና አያንዘ ኤዛ አይክደ ዎደ ኡባ፥ ኤዛ ጉዲ ኦላነ፤ ኤ ዶንትራ ዱባ የእነ፤ ማህ አች ጋርጭዛነ፤ ጋልታን ምንጋነ። ኤፓ Ꮉይ ቱና አያንዛ ከሶደ ጋር፥ ነ ታማሩንꬅስ ኦህዳ፥ የዝን ከሶደስ ኡን ዳንዳእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","የሱሳ ማህ ኡንታጎ፥ «አማኖሰ Ꮉና ዎደ አሱንꬆ! ታኒ ይንታራ አይደ የሎደስ የሳደ? ማህ ይንታና አይደ የሎደስ ዳንዳኦደ? ናአያ ታስ Ꮉንካ ኤኪ ዮኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ኡንቲ ናአያ ኤጎ ክእዳ፤ የ ቱና አያንዘ የሱሳ ብእደ ፋና ናአያ ጎቅዝዳ፤ ናአይ ሳአ ጎልእ፥ ዶናራ ጎፑንቶ ጩትተራ ጎልእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","የሱሳ የ ናአይ አዳይጎ፥ «Ꮉይ ነ ናአያ አይክዳንፓ ዋንꬅ ዎደ ማቃደ?» ያጋእ ኦጭዳ። ናአይ አዳይ፥ «ኤ ኤራꬅ የዝን አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ኤዛ ዎꬎደስ ጋማ ዎደ ታማን Ꮉꬃን ኦላነ፥ የዝን ኔስ ዳንዳእንትኮ፥ ኑስ ይቅስንቶያ፥ ኑና ማዶያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","የሱሳ ኤጎ፥ « ‹ነ ዳንዳእኮ ጋነ?› አማንዘ ኦደስን ኡባ ባዝ ዳንዳእንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ኤልሲ ናአይ አዳይ ፋ ቃልቶ ꬎቅ ዪዝ፥ «ታኒ አማናነ፥ የዝን ጉጂ አማኖደ ጋር ታና ማዶያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","የሱሳ አሱንꬅ ጋንግ ጋንግ Ꮉንግዛኖ ብእ፥ ቱና አያንዛ፥ «Ꮉይ ቱለን ሙመ አያንዛዮ፥ Ꮉይ ናአይፓ ከዞ ጋእ ነና ታ ኪታነ፤ ማህ ላምእንꬃ ኤ ግዳ ገልፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","የ ቱና አያንዘ ኡክ፥ ናአያ ጋማ ጎቅዚ፥ ኤፓ ከዝዳ። ናአይ Ꮉይቂደ ጋራ ይእን፥ ጋማ አሱንꬅ፥ «ናአይ Ꮉይቂዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","የዝን የሱሳ ናአይ ኩሽቶ አይኪ ደንꬅን፥ ናአይ ደንዲ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","የሱሳ ኬꬃ ገልዳንፓ ሱባ ኤ ታማሩንꬅ፥ «ኑኒ የ ቱና አያንዛ ኬሶደስ አኮስ ዳንዳእካያ?» ያጋእ የሱሳ ሻኪ ዱማ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","የሱሳ ማህ፥ «ይኒ ጋርዘ ዎሳራን ጾማራን ፋትን መለ ባዛራ ኬሳደስ ዳንዳኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ኡንቲ ይና በስትፓ ደንዲ፥ ጋልላራ አꬊ ቅትዳ፤ የሱሳ ፋ የዘ በስቶ ኦደን ኤሮደ ጋር ኮይካያ። ");
INSERT INTO oyde_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ኤ ፋ ታማሩንꬃጎ፥ «አስ ናአያ፥ አስ አስስ አꬂ እንጎዳ ዎꬎዳ፤ ኤ Ꮉይꬕ ቃማፓ ሱባ፥ Ꮉይቆፓ ደንዶዳ» ያጋእ ታማርስተራ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","የዝን ኡንትስ ኤ ጋዛና ገልካያ፤ ማህ ኤዛ ኦጮደስን ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ኡንቲ ቅፍርናሆመ ካታማ Ꮉንግ ኬꬃ ገልዳንፓ ሱባ የሱሳ ኡንታጎ፥ «ኦገ አኮስ ላለ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","የዝን ኡን፥ «ኑ ግዳ ኡባፓ አꬎደ ኦደ?» ያጋእ ላልደ ግሾ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","የሱሳ በቲ፥ ታጶ ላምእ ታማሩንꬃና ጼጊ፥ «ኦደን ቲኖ አꬎደስ ኮይኮ፥ ኡባፓ ሱባ አꬊ፥ ኡቡንꬅስ አሮ ማቃደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ፈቲ ኤራꬅ ናአ ኤኪ፥ ኡን ግዳ ኤስዳ፤ የ ኤራꬅ ናአያ እርንግ ኡንታጎ፥ ");
INSERT INTO oyde_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ꮉንስ ጋር ኤራꬅ ናኡንꬃፓ ፈታ ታ ሱንꬅተ ሞክዘ ኦደን ታና ሞካነ፤ ማህ ታና ሞክዘ ኦደን ታና ኪተዛያን ሞካነፕ አትን ታና ጻላላ ሞኮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ዋሐንሳ፥ «አስታማርዛዮ፥ ፈቲ አስ ነ ሱንꬅተ ቱና አያና ከሶደራ ኑኒ ብእ፥ ኑ ባጋ ማቆሰ ግሾ ኤዛ ካይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","የዝን የሱሳ፥ «ኦደን ታ ሱንꬅተ ጾዚ ኦችዘ ጋማ ቆፍዘ ባዝ ኦቺ፥ ኤልሲ ታላ አፋ ኢታ ባዝ ኦህንቶደስ ዳንዳእዘ ባይዘ ግሾ ካይፐተ። ");
INSERT INTO oyde_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ኑ ባዝ እጾሰ አꬄ ኑ ባጋ። ");
INSERT INTO oyde_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ታኒ ይንትስ ቱሮ ኦህነ፤ ይን ታሱንꬃና ማቅደ ግሾ ኦደን ይንትስ ታ ሱንꬅተ Ꮉለ Ꮉꬅ ኡሻደስ እንግኮን፥ ፋ አንጅቶ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«ታና አማንዘ Ꮉንꬅ ኤራꬁንꬃፓ ፈታ ባልꬅዘ ኦደን፥ ጋጭዘ ዳማ ዎጻ ፋ አፉርተ አጪ፥ አባ ግዳ ገልዛኮ ኤስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ነ ኩሽታ ነና ባልꬅዛኮ፥ ጋቺ ኦሎ። ኔኒ ላምእ ኩሸራ ꬋቦሰ ጋናመ ታማ ኦልንቶዳንፓ፥ ዱጹꬅ ኩሸራ ደኦ ገልዛኮ ኔስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ጋናመ ዛቅልታ Ꮉይቆሰ ታማን ꬋቦሰ በሲ። ");
INSERT INTO oyde_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ነ ቶህታ ነና ባልꬅዛኮ፥ ጋቺ ኦሎ። ኔኒ ላምእ ቶሄራ ጋናመ ታማ ኦልንቶዳንፓ፥ ዱጻ ማቂ ደኦ ገልዛና ኔስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ጋናመ ዛቅልታ Ꮉይቆሰ ታማን ꬋቦሰ በሲ። ");
INSERT INTO oyde_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ነ ኣፍታ ነና ባልꬅዛኮ፥ ዎጪ ኬሲ ኦሎ። ኔኒ ላምእ ኣፈራ ጋናመ ታማ ኦልንቶዳንፓ፥ ፈቲ ኣፈራ ጾዘ ካእቱሞ ገልዛና ኔስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","እዘ ዛቅልታን Ꮉይቆስ፥ ታምታን ꬋቦስ። ");
INSERT INTO oyde_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«ዣርሾ ሶገራ ጌዣን ፋና አስ ኡባ ታማራ ጌሻዳ። ");
INSERT INTO oyde_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ሶገ ሎኦ፥ ዪኮን ኤ ማልአንጽ እጽኮ፥ ማህ ዋይዝ ማልእሳደ? ይን ግዳ ሶገ የሰ። ይእ ፈታይ ፈታይራ ሳሮራ የዞተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","የሱሳ ይንፓ ደንዲ፥ ይሁዳ ሳአ Ꮉንግ ዮርዳኖሳ ቦርካ ፊንግዳ። ጋማ አሱንꬅ ማህ ኤጎ ሺቅን፥ ቲኖስትፋና የንꬅ አሱንꬃና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ፈቲ ፈቲ ፋርሳዉንꬅ ፋታኖደስ ኮይ የሱሳ፥ «ፈቲ አስ ፋ ማችቶ ዳኮደ ጋር ሙሴ ህግታ ኪታነ?» ያጋእ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ኤ ማህ፥ «ሙሴ ይንታና ዋጋእ ኪትዶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ኡንቲ፥ «ሙሴ፥ ‹ፈቲ አስ ፋ ማችትስ ዳፎ ዋርቃተ እንግ ዳኮ› ጋይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","የሱሳ ማህ፥ ኡንታና «ይን ኦህን ስኦሱንꬃና ማቅደ ግሾ ሙሴ Ꮉና ኪቶ ይንትስ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","የዝን ጾዚ ቲኖ መꬍዘ ዎደ ꬊራꬅን ማቾን ማህ መꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ይኒ ግሾ፥ ፈቲ አስ ፋ አዳያን ፋ እንቶን አሺ፥ ፋ ማችትራ ዎላ የዛነ። ");
INSERT INTO oyde_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ኡን ላምኡንꬅ ፈቲ አሾ ማቃነ፤ ይኬፓ፥ ኡን ፈቲ አሾ ማቃነፕ አትን ላምእ አስ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ይኒ ግሾ፥ ጾዚ አጭዳኖ አስ ሻግፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ኡን ካራ ማቅደ ዎደ ኤ ታማሩንꬅ Ꮉና ኦህት ባዝ የሱሳ ላምእንꬃ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","የሱሳ ኡንታጎ፥ «ፋ ማችቶ ዳኪ መለ ኤክዘ ኦደን ኦላላነ። ");
INSERT INTO oyde_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ማህ ማችታን ፋ አዝንዘፓ ኬዚ መለ አዝኒ ገልኮ ኦላልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","የሱሳ ኤራꬅ ናኡንꬃና ቦቾደ ፋና፥ ፈቲ ፈቲ አሱንꬅ ናኡንꬃና ኤጎ ክእዳ፥ የዝን ኤ ታማሩንꬅ የንꬅ አሱንꬃና ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","የሱሳ ይኖ ብእ፥ ፋ ታማሩንꬃና ካጪ፤ ኡንታጎ፥ «ኤራꬅ ናኡንꬅ ታጎ ይእዛኖ ካይፐተ፤ ጾዘ ካእቱሞ የንስ ጋርዙንꬅስ። ");
INSERT INTO oyde_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ታኒ ይንትስ ቱሮ ኦህነ፤ ጾዘ ካእቱሞ ኤራꬅ ናአ ፋና ኤኮሰ አꬄ ኦደን ይና ካእቱምቶ ሙሎን ገሎስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ኤራꬅ ናኡንꬃና እርንግ፥ ፋ ኩሽቶ ፈተላ ፈተላ አፋ ጋዲ አንጅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","የሱሳ ቅቶደስ ከዝደ ዎደ ፈቲ አꬄ ዎጺ ይእ፥ ኤ ቲንተ ቡንቁንቲ፥ «ኬሃ አስታማርዛዮ፥ መዽና ደኦ ላቶደስ ታኒ አኮ ኦቾ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","የሱሳ፥ «አኮስ ታና ኬህዛዮ ጋእ ጼገ? ጾዘ ጻላላፕ አትን መለ ኬሃ ኦደን ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ጾዘ ኪቶ፥ ዎꬍፐ፤ ኦላልፐ፤ ካይስትፐ፤ ዎርዶ ማርክꬍፐ፤ እልአንꬅተ ላምፐ፤ ነ አዳያን ነ እንቶ ቦንቾ ያጋዛኖ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","አꬄ፥ «አስታማርዛዮ፥ ታኒ ይኖ ኡባ ናአትꬃፓ አይኪ Ꮉይኖ የሎደስ ናጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","የሱሳ አꬃ ዳኪ ብእ ካꬍዳ፤ «ኔስ ፈቲ ባዝ ፋጫነ፤ Ꮉንግ ኔስ የዘ ባዝ ሙሎ ባይዝ፥ ይና ብርቶ ዳሁንꬅስ እንጎ፤ ኔኒ ሳሎ ዱርꬋዳ። የይዝ ማቂ ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","የዝን አꬄ ይኖ ስእ፥ ኤ ጋማ ዱረ ማቅደ ግሾ ፋ ስንቶ ካርꬂ፥ ኡፋይትካይዛራ አሺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","የሱሳ ፋ ታማሩንꬃና ዉቱꬂ ዳኪ ብእ፥ «ዱረ አስ ጾዘ ካእቱሞ ገሎዳና ዋይዝ ማꬎድየሳ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ኤ ታማሩንꬅ ኤ ትምርትተ ጋማ ቆፕዳ። የዝን የሱሳ ማህ ኡንታጎ፥ «ናኡንꬆ፥ ጾዘ ካእቱሞ ገሎዳና ዋይዝ ማꬎድየሳ! ");
INSERT INTO oyde_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ዱረ አስ ጾዘ ካእቱሞ ገሎዳንፓ፥ ግማለ ማርፐ ኡሩንꬃራ አꬍዛና ላፋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ኤ ታማሩንꬅ ጋማ ቆፒ፥ «ዬዝን፥ ኦደ አቶደ?» ያጋእ፥ ፈተ ፈታ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","የሱሳ ኡንታና ዳኪ ብእ፥ «Ꮉና ጾዘስ ዳንዳእንታነፕ አትን አስስ ዳንዳእንቶስ፤ ጾዘስ ኡባ ባዝ ዳንዳእንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጴጥሮሳ የሱሳጎ፥ «ኤሮ፤ ኑኒ ኑ ባዝ ኡባ አሺ፥ ነና ካላነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","የሱሳ «ታኒ ይንትስ ቱሮ ኦህነ፤ ታ ግሾን ዎንገለ ግሾን ኬꬅቶ ዎይ እሹንꬃና ዎይ ምሹንꬃና ዎይ አዳያ ዎይ እንቶ ዎይ ማችቶ ዎይ ናኡንꬃና ዎይ ኦችዘ ጋድቶ አሽዘ ኦደን፥ ");
INSERT INTO oyde_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ꮉተ Ꮉና ዎድተ ጼት ኩሸ ኬꬅቶ፥ እሹንꬃና፥ ምሽቶ፥ እንቶ፥ ናኡንꬃና፥ ኦችዘ ጋድቶ፥ ባይꬃራ ዎላ ኤኮዳ። ቲኖፓ የኦደ ዎደን መዽና ደኦ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","የዝን ጋሙንꬅ ቲኖ ማቅዱንꬅ ሱብ ማቃዳ፥ ማህ ጋሙንꬅ Ꮉተ ሱብ ማቅዱንꬅ ቲኖ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","የሱሳራን ኤ ታማሩንꬃራ የሩሳላመ Ꮉማደራ፥ የሱሳ ፋ ታማሩንꬅ ቲንተ የꬋነ። ኡን ጋማ ቆፕዳ። ኤዛ ካልዙንꬅን ዣሽትዳ። ላምእንꬃ፥ ታጶ ላምእ ታማሩንꬃና ጋጻ ኬሲ፥ ፋና የሎደ ባዝ ሻጊ ኡንታጎ Ꮉንጋራ ያጋእ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Ꮉይቼ፥ ኑኒ የሩሳላመ Ꮉተ ከዛነ። እዘ አስ ናአይ፥ ካህኑንꬅ Ꮉላቁንꬅስን ህገ አስታማሩንꬅስ አꬂ እንግንቶዳ። ኡንቲ ኤላ አፋ Ꮉይቆ ፍርዳ ፍርዶዳ፤ ማህ አይሁደ ማቆሰ አሱንꬅስ ኤዛ አꬂ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","የ አይሁደ ማቆሰ አሱንꬅ ኤዛ ለቆዳ፥ ኤላ አፋ ጩቶዳ፥ አላንጋራ ጋራፎዳ ዎꬎዳ። ኤ Ꮉይꬕ ቃማፓ ሱባ፥ Ꮉይቆፓ ደንዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ዛብዶሳ ናኡንꬅ ያይቆባን ዋሐንሳን የሱሳጎ ይእ፥ «አስታማርዛዮ፥ ኑኒ ነና ዎስዘ ፈትባዝ ኑስ ኦቾያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","የሱሳ ኡንታጎ፥ «ታኒ ይንትስ አኮ ኦቾ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ኡንቲ፥ «ኔኒ ነ ቦንቾ ካእቱምተ በትዘ ዎደ ኑፓ ፈታ ምዛቅ ዛላራ ማህ ፈታ ዎርክታ ዛላራ በትꬆያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","የዝን የሱሳ ኡንታጎ፥ «ይንቲ አኮ ዎስዛኮ ኤሮስ፥ ታ ኡሻደስ የዘ ጹአ ኡሻደስ ዳንዳኦዳተ? ማህ ታኒ ጻማቅንቶደስ የዘ ጽንቃቶ ጻማቅንቶደስ ዳንዳኦዳተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ኡን ማህ፥ «የ ዳንዳኦዳ» ያጋይዳ። የሱሳ ማህ፥ «ቱሮ ታ ኡሻደስ የዘ ጹአ ይን ኡሻዳ፥ ታኒ ጻማቅንቶደስ የዘ ጽንቃቶ ይን ጻማቅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","የዝን ታፓ ምዛቅ ዛላራን ዎርክታ ዛላራ በቶዱንꬃና ዶሮደስ ታስ አደትꬅ ዎልቃ ባያ፥ የዝን ይና በስታ ጾዚ እማደስ ጊግዚ ጋድዱንꬅስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","አትዱንꬅ ታጵ ታማሩንꬅ ይኖ ስእደ ዎደ ያይቆባላን ዋሐንሳላ ሸንꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","የሱሳ ኡንታና ኡባ ፋጎ ጼጊ፥ «አይሁደ ማቅን አይሁደ ማቆሰ አሱንꬅ Ꮉላቁንꬅ ዎርዣ አህዙንꬃና ጋእንት ጼግንትዙንꬃናን አህዙንꬅስ ዎርዡንꬃላ አፋ አደትꬅ ዎልቃ የዛኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","የዝን ይን ግዳ ይኒ ፋና ማቃደስ ቤዞስ፤ ይን ግዳ ዳማ ማቃደስ ኮይዘ ኦደን ይንትስ አሮ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ማህ ይን ግዳ ኡባፓ አꬂ ማቃደስ ኮይዘ ኦደን ይን ኡቡንꬅስ አሮ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","መለ አቶ የዝን፥ አስ ናአይን፥ አስ ማዶደስን ጋሙንꬃና አሾደስ ፋ ሸምፕቶ አꬂ እማደስ ይእዳፕ አትን አስ ኤስ ኦቾደ ጋር ይእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ኡንቲ እያርኮ ካታማ Ꮉንግዳ። የሱሳ ፋ ታማሩንꬃራን ጋማ አሳራ እያርኮፓ ከሳደራ፥ ጽሞሳ ናአ፥ ቆቅዘ፥ ባርጽሞሳ ጋእንትዘ፥ ኦገ ጋጻ ዎስተራ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ባርጽሞሳ፥ የይጋራ አꬍዘ ናዝረተ የሱሳ ማቅዳኖ ስእደ ዎደ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ዳዉተ ናአ የሱሳ፥ ታና ማሮያ!» ያጋኤ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ጋማ አሱንꬅ ኤዛ፥ «ስእ ጋኦ!» ጋእ ካጭዳ። የዝን፥ ኤ ፋ ቃልቶ ካሰንፓ ጋማ ꬎቅ ዪዚ፥ «ዳዉተ ናአዮ፥ ታና ማሮያ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","የሱሳ ኤቂ፥ «ኤዛ Ꮉንካ ጼጎተ» ያጋይዳ። ኡንቲ ቆቅዘጎ፥ «አኮ ባያ፥ ደንዲ ኤቆ፥ ነና ጼጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ቆቅዘ ፋ ማእቶ ኦሊ አሺ፥ ዶሊ ደንዲ ኤቂ፥ የሱሳጎ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","የሱሳ፥ «ታኒ ኔስ አኮ ኦቾደ ጋር ኮየ?» ያጋይዳ። ቆቅዘ፥ «አስታማርዛዮ፥ ታ በአደስ ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","የሱሳ ኤጎ፥ «ቅቶ፥ ነ አማንታ ነና ፋꬅዳ» ያጋይዳ። ኢራ ኤ ኣፍታ ብእን፥ የሱሳ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ኡን የሩሳላመ ኡክተራ፥ ሻማሄ ደርዘ ካለ የዘ ቤተፋገን ብታንያ ካታምቶ የሊዳ። የሱሳ ፋ ታማሩንꬃፓ ላምኡንꬃና ቲኖ ዳኪ፥ ");
INSERT INTO oyde_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«ይንታፓ ቲኖ የዘ ካራ ጋንጨ ቅቶተ፤ እዘ ገልደ ጋር ኦደን ቶጊ ብእካይዘ አጭንቲ የዘ Ꮉረ ናአ ይን ደንጎዳ፥ ኤዛ ብሊ፥ Ꮉይጋ ኤኪ ዮኦተ። ");
INSERT INTO oyde_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ኦደን ይንታና፥ ‹Ꮉኖ አኮስ ኦቼ?› ያጋእ ኦጭኮ፥ ‹ላꬂ ኤዛ ኮያነ፥ ኤልሲ ኤዛ Ꮉንካ ዳኮዳ› ጋኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ኡን Ꮉንግ፥ Ꮉረ ናአያ ባለ ኦገ ካለ አጭንቲ የዛያ ደንግ ብልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ይና በስተ ኤቅደ ፈቲ ፈቲ አሱንꬅ ኡንታጎ፥ «Ꮉረ ናአያ ዋይሳደስ ብለ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ኤ ታማሩንꬅ የሱሳ ፋና ኪተዛኖ ኦህን፥ አሱንꬅ አሺ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ኡንቲ Ꮉረ ናአያ የሱሳጎ ክእ፥ ፋ ማእቶ ኤ ባንተ ዪጽን የሱሳ የ Ꮉረ ናአያ ቶግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ጋማ አሱንꬅ ፋ ማእቶ ኦግተ ዪጽዳ፤ ማህ መሉንꬅ ምንጻ ታሸ ሻቂ፥ ኦግተ ዪጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","የሱሳፓ ቲኖ የꬍዘ አሱንꬅን ኤዛ ካልዘ አሱንꬅ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ሆሳና! ላꬄ ሱንꬅተ የእዘ አንጅንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","የእዘ ኑ አዳይ ዳዉተ ካእቱምታ አንጅንትዳኖ። ሆሳና! ሳሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","የሱሳ የሩሳላመ Ꮉንግ፥ ጾዘ ኬꬃ ገልዳ። ማህ ኡባባዝቶ ዉቲ ብእዳንፓ ሱባ፥ ሳእታ ቃምዘ ግሾ ታጶ ላምእ ታማሩንꬃራ ብታንያ ካታማ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ዎንትስት ዎደ ኡን ብታንያፓ ኬዚ Ꮉማደራ፥ የሱሳ ናይዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ꮉኮራ ፈቲ በለሰ ምንጽትስ ዥልኦ Ꮉየ የዛኖ ብእ፥ ኢላ አፋ ኣፈ በንትኮ ጋእ፥ በአደስ እዝጎ Ꮉንግዳ፥ የዝን እዝጎ ኤ Ꮉንግዘ ዎደ Ꮉየ ጻላላፕ አትን ፈቲ ኣፈን ደንግካያ፤ አኮስ ጋይኮ፥ በለሰ ኣፍዘ ዎደ የልካይዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","የሱሳ ይና በለስቶ፥ «ይኬ፥ ኔፓ አስ ኣፈ ሚፐ» ያጋይዳ። ኤ ታማሩንꬅ ኤ ጋዛኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ኡን የሩሳላመ ቅትዳ፤ የሱሳ ጾዘ ኬꬃ ገሊ፥ እዘ ባይዝዙንꬃናን ዎንግዙንꬃና ባለ ባይኤ አይክዳ፤ ማህ ብራ ላምዙንꬃና ጠርጴዛን ዎለ ባይዝዙንꬃና ኦይዳ ዳኪ ኦሊ፥ ");
INSERT INTO oyde_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","አስ አኮ ባዝን ቶኪ፥ ጾዘ ኬꬃ ግዳራ አꬋመ ፋና ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","የሱሳ አሱንꬃና Ꮉንጋራ ያጋእ ታማርስዳ፦ «ጌሽ ማጻፍተ፥ ‹ታ ኬꬅታ አስ ኡባ ጾዝ ዎስዘ ኬꬂ ማቃዳ› ጋእንት ጻፍንትዳ። የዝን ይንቲ እዞ ፋኖ አችንትዘ ዎምኦ ማህዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬅ ይኖ ስእ፥ ኤዛ ዎꬎደስ ኦገ ኮየ አይክዳ። የዝን ጋማ አሱንꬅ ኤ ትምርትተ ጋማ ቆፕዘ ግሾ ኤስ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ሳእታ ኡጉርዘ ዎደ የሱሳን ኤ ታማሩንꬅን ካታማፓ ጋጻ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ኡን ዎንትስት ዎደ ይና ኦግትራ ኣꬍተራ፥ ይና በለስታ ጻጶራ መልዳኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጴጥሮሳ ቲሪ፥ «አስታማርዛዮ፥ ይኬ፥ ኔኒ ባድደ በለስታ መልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","የሱሳ ማህ፥ «ጾዛ አማኖተ። ");
INSERT INTO oyde_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ታኒ ይንትስ ቱሮ ኦህነ፤ ኦደን ፋ ዎዝንተ ሶእካይዛራ ጋይደባዝ Ꮉኖዳኖ አማኒ፥ Ꮉይ ደርዛ፥ ‹ደንዲ አባ ዎꬎ› ያጋይኮ ኤስ Ꮉኖዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ይኒ ግሾ፥ ታኒ ይንትስ ኦህነ፤ ጾዛ ይን ዎስዘ ባዝን ኦጭዘባዝ አኮ ማቅኮን ኤክደ ጋር አማኖተ፥ ይን ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ጾዝ ዎሶደስ ይን ኤቅዘ ዎደ ሳሎ የዘ ይን አዳይ ይን ናጋርቶ አቶ ጋዉደ ፋና፥ ኦደን ይንታና ናቂደባዝ የዝኮ፥ ኤስ አቶ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","የዝን አስ ናጋራ ይን አቶ ጋአንጽ እጽኮ፥ ሳሎ የዘ ይን አዳይን ይን ናጋርቶ ይንትስ አቶ ጋኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ኡን ማህ የሩሳላመ Ꮉንግዳ። የሱሳ ጾዘ ኬꬃ Ꮉንቶደራ፥ ካህኑንꬅ Ꮉላቁንꬅ፥ ህገ አስታማሩንꬅን ጭሙንꬅ ኤጎ ይእ፥ ");
INSERT INTO oyde_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«ኔኒ Ꮉኖ ኦቾደስ ኔስ አኮ አደትꬅ ዎልቃ የዘ? ዎይ ኔስ Ꮉና አደትꬅ ዎልቅቶ እንግደ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","የሱሳ ማህ ኡንታጎ፥ «ታ ይንታና ፈትባዝ ኦጮዳ፥ ታስ ኦሆተ። ታ ማህ Ꮉኖ አኮ አደትꬅ ዎልቃራ ኦችዛኮ፥ ይንትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ዋሐንሳ ጽንቃታ ጾዛፓነ ዎይ አሳፓ? ታስ ኦሆተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ኡንቲ ፋ ግዳ ላለ አይኪ፥ «ኑኒ፥ ‹ጾዛፓ› ጋይኮ፥ ኤ ኑጎ፥ ‹ዬዝን፥ ዋሐንሳ ኦህዛኖ አኮስ አማናንጽዶ?› ያጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹አሳፓ ጋይኮ› አስ ኡባ ዋሐንሳ ናበ ማቅዛኖ ኤራነ።» ማቅደ ግሾ አሱንꬅስ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ይኒ ግሾ፥ ኡንቲ የሱሳጎ፥ «ኑኒ ኤሮስ» ያጋእ ማህዳ፤ የሱሳ፥ «ታንን Ꮉኖ አኮ አደትꬅ ዎልቃራ ኦችዛኮ፥ ይንትስ ኦሆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","የሱሳ ኡንትስ አዝዘራ ያጋእ ኦህዳ፤ «ፈቲ አꬄ ዎይነ አታክልተ ቱኪ፥ ጋጽቶ ዉቱꬂ ጋሰ ጋስዳ። ማህ የ ዎይንዛ ጭጭዘ ኦላን ቦክዳ። ኤዛ ካፎደስ ጳርጎ ሻኮ ሻክዳ። ይንፓ ሱባ፥ ኮꬄ ኦችዘ አሱንꬅስ እንግ፥ መለ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ዎይነ ኣፍታ ዲሊ ማጽዘ ዎደ የልን፥ ፋና የልዛኖ ኤኪ የኦደ ጋር፥ ፈቲ ፋ አርዛ ኮꬄ አዱንꬃጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ኮꬄ ኤክደ አሱንꬅ ኤ አርዛ አይኪ Ꮉꬊ፥ Ꮉሪ ኩሸ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ላምእንꬃ መለ አሮ ኡንታጎ ኪትን፥ ኡን የ አርዘስ ኦምቶ ሹቻራ ቃዉጺ ካዉሽዚ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ዎይነ አታክልተ ላꬃይ ማህን መለ አሮ ኪትዳ። የ አርዛ ዎꬍዳ፥ ማህ መለ ጋሙንꬃና ይኒ ጋራ የይዝዳ፥ ፈታ ፈታ Ꮉꬊ፥ መሉንꬃና ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«ዎይነ አታክልተ ላꬄስ ኪቶደስ ኡባፓ ላስተ ኤ ጋማ ካዽዘ ፋ ናአያ ዳኮዳና ጻላላ አትዳ። ኤ፥ ‹ኡን ታ ናአያ ቦንችካይዛራ አሻማ› ጋእ፥ ፋ ናአያ ኡንታጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«የዝን ኮꬄ አዱንꬅ ፋ ግዳ፥ ‹ላቶዳይ Ꮉያ፤ የꬎተ ኤዛ ዎላ ዎꬎዳ፤ ኤ ላትታ ኑስ ማቃዳ!› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ናአያ አይኪ ዎꬊ፥ ኤ አህቶ ዎይነ አታክልተ ግዳፓ ጋጻ ኬሲ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«ይኬ፥ ዎይነ አታክልተ ላꬃይ ዋይሳደ? ይእ የንꬅ ኮꬄ አዱንꬃና ዎꬊ Ꮉሲ፥ ዎይነ ኮꬄ ኦችዘ መለ አስስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","« ‹ኬጽዙንꬅ ለቂ እጽደ ሹችዘ ኬꬅት ማይዘንቶ ጻልዘ፥ ኡባፓ አꬍዘ ምንꬅ ሹች ማቅዳ። Ꮉኖ ላꬂ ኦችደባዝ፤ ማህ ኑ አፍትስን ጋማ ቆፍዘ ባዝ ያጋዛኖ ጌሽ ማጻፈፓ ናባብካ?› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ካህኑንꬅ Ꮉላቁንꬅ፥ ህገ አስታማሩንꬅን ጭሙንꬅ የሱሳ ይና አዝዝቶ ኡንታላ አፋ ኦህዳኖ ኤርደ ግሾ ኤዛ አይኮደስ ኮይዳ፥ የዝን አሱንꬅስ ዣሽቲ፥ አሺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ማህ ይና ኦህትፓ ባላ ደንግ፥ ኤዛ አይኮደ ጋር፥ ፋርሳዉንꬃፓ ሄሮድሳ ባጉንꬃፓ ኤራꬅ አሱንꬃና ኤጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ኡንቲ ኤጎ ይእ፥ «አስታማርዛዮ፥ ኔኒ ቱርባዝ ኦህንትዛኖ አሳፓ አስ ሻኮሳኖ ኑኒ ኤራነ። ኔኒ አስ ሻኮስ፤ ማህ ጾዘ ኦግቶ ቱረትꬃራ ታማርሳነ። ኑኒ ሮመ ጋደ ካት ቄሳረስ ጊራ ጊርዛና ልከን ልከ ባ? ጊራ ጊሮነነ አሾነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","የዝን ኡን ጩቦትꬅቶ የሱሳ ኤሪ፥ «ታና አኮስ ፋታነ? አነ ፈቲ ሳንትመ ታና ቤዞተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ኡንቲ ኤስ ክእዳ፥ «Ꮉና ብሽታን ሱንꬅታ ኦደሶ?» ያጋእ ኡንታና ኦጭዳ። ኡንቲ፥ «ቄሳረስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","የሱሳ ማህ፥ «ዬዛኮ፥ ቄሳረስቶ ቄሳረስ፥ ጾዘስቶ ጾዝስ እንጎተ» ያጋእን ኡን ኤ ባዝ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ꮉይቂደ አስ ደንዶስ ጋዘ ሳዱቃዉንꬃፓ ፈቲ ፈቲ አሱንꬅ የሱሳጎ ይእ፥ Ꮉንጋራ ያጋእ፥ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«አስታማርዛዮ፥ ሙሴ ኑስ ህገ ጻፍተራ፥ ‹ማቾ ኤክደ አስ ናአ የልካይዛራ Ꮉይቂኮ፥ የ Ꮉይቂደ እሸ ኤ ማችቶ ኤኪ፥ ፋ እሸስ ናአ የሎደስ ቤዛነ› ያጋዛኖ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ዛጋ ዎደ ላፑን እሹንꬅ የዙንꬃፓ አንግሰ ማቾ ኤኪ፥ ናአ የልካይዛራ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ላምአንꬅዘ እዞ ኤክዳ፥ ኤዝን ናአ የልካይዛራ Ꮉይቂዳ። Ꮉይꬓንꬅዘ ይኒ ጋር ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ላፑኑንꬅን ይኒ ጋራ እዞ ኤኪ፥ ናአ የልካይዛራ Ꮉይቂዳ። ኡባፓ ሱባ፥ ማህ ይና ማችታ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ዬዝን፥ ላፑኑንꬅ ሙሎ እዞ ኤክደ ግሾ Ꮉይቂደ አሱንꬅ Ꮉይቆፓ ደንድደ ዎደ፥ እዛ ኡንታፓ አየስ ማቾ ማቃደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","የሱሳ ማህ፥ «ይንቲ ባልንትዛና፥ ጌሽ ማጻፍቶ ዎይ ጾዘ ዎልቃ ኤርካይዘ ግሾ! ");
INSERT INTO oyde_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ꮉይቂደ አሱንꬅ Ꮉይቆፓ ደንድደ ዎደ፥ ሳሎ የዘ ኪታንቾ ማቃነፕ አትን ꬊራꬅን ኤኮስ፤ ማቻን ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","የዝን Ꮉይቂዱንꬅ ደንደባዝ ማቅኮ፥ ሙሴ ማጻፍተ ጻፍንትደ ኤጽዘ Ꮉቡርቱትባዝ ኦህዘ በስተ፥ ጾዚ ሙሴጎ፥ ‹ታኒ፥ አብራሃማ ጾዚ፥ ይሳቃ ጾዚ፥ ያይቆባ ጾዚ› ጋይዳኖ ናባብካተ? ");
INSERT INTO oyde_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ይኒ ግሾ፥ ኤ፥ ሸምፖራ የዙንꬅ ጾዛፕ አትን Ꮉይቂዱንꬅ ጾዚ ባያ። ይን ጋማ ባልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ህገ አስታማሩንꬃፓ ፈተ ኡን ላልዛኖ ሺቂ ስእዳ። ማህ የሱሳ ኡንትስ ሎይꬂ ማህዳኖ ስእ፥ «ኪታ ኡባፓ አꬍዘ ኪታ አኖ?» ያጋእ የሱሳ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","የሱሳ ማህ፥ ኤጎ Ꮉንጋራ ያጋይዳ፦ «ኪታ ኡባፓ አꬍዘ ኪታ ስኦተ፤ ‹እስራኤለ አሱንꬆ፥ ላꬄ ኑ ጾዘ ፈቲ ላꬂ። ");
INSERT INTO oyde_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ነ ላꬃ ነ ጾዛ ነ ኩሙꬅ ዎዝናፓ፥ ነ ኩሙꬅ ሸምፖፓ፥ ነ ኩሙꬅ ቆፋፓ፥ ነ ኩሙꬅ ዎልቃፓ ካꬎ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ማህ ኪታ ኡባፓ አꬍዘ ላምእንꬃ ኪትዘ፤ ‹አስ ኡባ ነ ኦምት ጋር ካꬎ› ያጋዛኖ፤ Ꮉንሳፓ አꬍዘ መለ ኪታ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ህገ አስታማርዘ የሱሳጎ፥ «አስታማርዛዮ፥ ቱሮ ጋይዳ፤ ኔኒ ‹ጾዚ ፈቲ ጾዚ ጻላላ። ኤፓ መለ ባያ› ጋይዳና ቱሮ። ");
INSERT INTO oyde_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ጾዛ ኩሙꬅ ዎዝናፓ፥ ኩሙꬅ ቆፋፓ ኩሙꬅ ዎልቃፓ ካꬍዛኖን ማህ አስ ኡባ ፋ ኦምት ጋር ካꬍዛና፥ ምችዘ ዣርሾፓን መለ ዣርሾ ኡባፓ አꬋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","የሱሳ ህገ አስታማርዘ ማህዳና አꬍዘ ኤራ አስ ማሄ ማቅዳኖ ብእ፥ «ኔኒ ጾዘ ካእቱሞፓ Ꮉክካያ» ያጋይዳ፤ ይንፓ ሱባ፥ የሱሳ መለባዝ ኦጮደስ ኦደን ሚንግካያ። ");
INSERT INTO oyde_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","የሱሳ ጾዘ ኬꬃ ታማርስተ፥ Ꮉንጋራ ያጋይዳ፦ «ህገ አስታማሩንꬅ ክርስቶሳ ‹ዋይዝ ዳዉተ ናአ ጋኤ?› ");
INSERT INTO oyde_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳዉተ ጌሽ አያናራ ካሊ፥ « ‹ላꬂ፥ ታ ላꬃያ፥ «ታኒ ነ ሞርኩንꬃና ነ ቶህታ የꬍዘ በሲ ማሆደ ዎንꬅስ፥ Ꮉነ ታፓ ምዛቅ ዛላ በቶ» ጋይዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ዳዉተ ፋ ኦምተ ክርስቶሳ፥ ‹ላꬆ› ጋእ ጼግኮ፥ ዬዝን፥ ክርስቶሳ ዋይዝ፥ ዳዉተ ናአ ማቀ» ያጋይዳ። ጋማ አሱንꬅ የሱሳ ጋዛኖ ኡፋይት ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","የሱሳ ታማርስተራ፥ Ꮉንጋራ ያጋይዳ፦ «ህገ አስታማሩንꬃፓ ናግንቶተ፤ ኡን ጳርጎ ማኦ ማእ ዉትዛኖን ጋበን አስ ኡንታና ቦንቺ ሳሮꬅዛኖ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ኡንቲ አይሁደ ዎሳ ኬꬃ ጋማ ሎኦ ኦይዳ ኮያነ፤ ማህ አስ ፋና ሞክዘ በሳ ቦንቾ በሲ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ኡን ቡዳን ኬꬂ ቦንቂ፥ ፋና ቤሳደስ ጳርግዚ ዎሳነ፤ ኡን ኡባፓ አꬍዘ ፍርዳ ኤኮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","የሱሳ ጾዘ ኬꬃ ሙጻተ ኦልዘ ሳጥነ ካለ በቲ፥ አሱንꬅ ፋ ብርቶ ይና ሳጥንተ ኦልዛኖ ብእዳ፤ ጋማ ዱረ አሱንꬅ ጋማ ብራ ይና ሳጥንተ ኦላነ። ");
INSERT INTO oyde_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ፈቲ ዳሃ ቡዳንታ ይእ፥ ላምእ ስክና ይና ሳጥንተ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","የሱሳ ፋ ታማሩንꬃና ጼጊ፥ «ታኒ ይንትስ ቱሮ ኦህነ፤ ሙጻተ ሳጥንተ ኦልደ አሱንꬅ ኡባፓ Ꮉና ዳሃ ቡዳንታ ጋንꬅ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","አኮስ ጋይኮ፥ መሉንꬅ ኡባ ፋስ ኩሚ አትደ ብራፓ ኦላነ። የዝን እዛ ፋ ፋጭትፓ፥ ፋስ የዘ ቆልቶ ኡባ እንግዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","የሱሳ ጾዘ ኬꬃፓ ከሳደራ፥ ኤ ታማሩንꬃፓ ፈተ፥ «አስታማርዛዮ፥ Ꮉና ሎኦ ሹችቶን Ꮉና ሎኦ ሹች ኬꬅቶ በእነ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","የሱሳ ማህ፥ «Ꮉና ዳማ ሹች ኬꬅቶ በእነ? Ꮉና ኬꬅታ ሹች ሹቻላ አፋ ግምቢንትደ ፋና ዉልእንትካይዛራ አቶስ፤ ፈቲ ሹችን አትካይዛራ ኡባ ዉልእንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","የሱሳ ጾዘ ኬꬃፓ ሰኮ ዛላራ ሻማሄ ደርዘላ አፋ በቴዝን፥ ጴጥሮሳ፥ ያይቆባ፥ ዋሐንሳን እንድርያሰ ኤጎ ይእ፥ ");
INSERT INTO oyde_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Ꮉና አይደ ይአድየዛኮ፥ ኑስ ኦሆ፤ Ꮉና ኡባ ፎልንቶደስ ዎድቶ ኤርስዘ ማልታ አኮ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","የሱሳ ማህ ኡንታጎ Ꮉንጋራ ያጋእ ኦህዳ፦ «ይንታና ኦደን ባልꬃመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ጋማ አሱንꬅ ታ ሱንꬅተ፥ ‹ታኒ ክርስቶሳ› ጋእ ጋማ አሱንꬃና ባልꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ኦላን ኦላ ዎረ ስእዘ ዎደ ይርግፐተ። ይኒ ጋርዘ Ꮉኖደስ ቤዛነ፥ የዝን ዉርሱꬅታ Ꮉጋ። ");
INSERT INTO oyde_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ፈቲ ጋደ አሱንꬅ መለ ጋደ አሱንꬃራ ኦልንቶዳ፤ ማህ ፈቲ ካእቱሞ መለ ካእቱሞራ ኦልንቶዳ፤ ሳአ ኤንኤ ኡባ በሳ Ꮉኖዳ፤ ናየ የሳዳ፥ የዝን ይና ኡባና የሎ ዞቀ ፋና። ");
INSERT INTO oyde_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«የዝን ይንቲ፥ ይን ኦምተ ናግንቶተ። አኮስ ጋይኮ፥ አስ ይንታና አይኪ፥ ፍርዳ ኬꬅስ አꬂ እንጎዳ፤ ማህ አይሁደ ዎሳ ኬꬅተን ይንታና አላንጋራ ጋራፎዳ፤ ጋደ አህዙንꬅ ቲኖን ካቱንꬅ ቲኖ ታ ግሾ ይን ማርክꬋደስ ኤቆዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ዉርሱꬅታ የሎዳንፓ ቲኖ ዎንገለ አስ ኡባስ ኦህንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ኡንቲ ይንታና ፍርዳ ኬꬃ ክእዘ ዎደን አꬂ እንግዘ ዎደ ዋጊ ኦሆድየዛኮ ቲኖ ይርግፐተ፤ ይና ሳተ ጾዚ ይንትስ እንግደባዝ ኦሆተ። ይን ግዳ ጌሽ አያና ኦህነፕ አትን ይንታና ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«እሸ ፋ እሻ፥ አዳይ ፋ ናአያ ዎꬍሳዳ። ናኡንꬅ ፋና የልዱንꬃላ ደንዲ፥ ኡንታና ዎꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","አስ ኡባ ይንታና ታ ሱንꬅት ግሾ እጾዳ፥ የዝን ዉርሱꬅ የሎደስ ሚንግደ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«የዝን ꬋብስዘ ቱንዘ ኤቆደስ ቤዞሰ በሳ ኤቀዝን ይን በአዳ።» ይና አኮ ጋእንትዛኮ ናባብዘ አካኮ! «ይሁዳ ሳአ የ ዎደ የዙንꬅ ደረጎ ዎጺ አችንቶ። ");
INSERT INTO oyde_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ባለ የዘ ኬꬃ ገሊ ኬꬃፓ ፈትባዝ ኤኮደስ ጎደ፥ ፋ ኬꬃ ገልፐ። ");
INSERT INTO oyde_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ጋደ የዘ ፋ ማእቶ ኤኮደስ ሱባ ማቅፐ። ");
INSERT INTO oyde_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","የ ዎደ ዎዳꬅ ማቹንꬅስን ꬋንꬅዘ ማቹንꬅስ ጋማ ማꬋ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","የዝን Ꮉና ኡባ Ꮉንዘ ዎድታ ሴተ ማቃመ ጋር፥ ጾዝ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","አኮስ ጋይኮ፥ ጾዚ አላምቶ መꬍደ ዎድትፓ አይኪ፥ Ꮉይኖ የሎደስ Ꮉንካይዘ ማꬋን ቲኖስን Ꮉኖሰ ክለ ማꬋ አሳላ አፋ የ ዎደ Ꮉኖዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ላꬂ ይና ቃምት ፋይድቶ ኤርꬅካይዛኮ፥ አስ ማቅደ ኦደን አቶስ። የዝን ኤ ፋ ዶርደ አሱንꬅ ግሾ ይና ፋይድቶ ኤርꬃነ። ");
INSERT INTO oyde_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«የ ዎደ ኦደን ይንታና፥ ‹ይኬ፥ ክርስቶሳ Ꮉነ የነ ዎይ ክርስቶሳ ሰካ የነ› ያጋይኮ፥ ይኖ አማንፐተ። ");
INSERT INTO oyde_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ዎርዶ ክርስቶሳን ዎርዶ ናቡንꬅ ደንዲ ፋስ ዳንዳእንትኮ፥ መለ አቶ የዝን ጾዚ ዶርዱንꬃፓ ባልꬆደ ዎንꬅስ ክለ ባዝን ጋማ ቆፍዘ ባዝ ቤሳዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","የዝን ይንቲ ናግንቶተ፥ ታኒ ይንትስ ኡባ ባዝ ቲንꬍ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«የዝን የ ዎደ ይና ማꬍትፓ ሱባ፥ «አዋ ꬉሞዳ፤ አግና ፎእቶ አሾዳ፤ ");
INSERT INTO oyde_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ጾልንቱንꬅ ሳሎፓ ጎልኦዳ፤ ማህ ሳሎ የዘ ዎልቅታን ኤንኦዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","የ ዎደ አስ ናአይ፥ ዳማ ዎልቃራን ቦንቾራ ꬎነ ግዳራ የኦደራ ኡን በአዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","የ ዎደ ኤ ኪታንቹንꬃና ኪቶዳ። ኦይዲ ዛላ ሳአ ጋጻፓ ሳሎ ጋጻ የሎደስ፥ ጾዘ ዶርደ አሱንꬃና ሺሾዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«አዝዝቶ በለሰ ምንጻፓ ቲሮተ፤ በለስታ አጭዘ ዎደ እ Ꮉይታ ጭልኤ አይክደ ዎደ ቶርቼ የልዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ይኒ ጋር፥ ይንቲ ይና ኡባ ባዝታ Ꮉንዛኖ በእዘ ዎደ ኡክ ፉርꬃ የልዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ታኒ ይንትስ ቱሮ ኦህነ፤ Ꮉና ኡባ ባዝታ Ꮉኖደ ዎንꬅስ Ꮉነ የዘ አሱንꬅ ኡባ Ꮉይቆስ። ");
INSERT INTO oyde_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ሳሎን ሳአን አꬎዳ፥ የዝን ታ ቃልታ ሙሎን አꬎስ። ");
INSERT INTO oyde_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«የዝን ይና ቃምቶን ይና ሳቶ አዳይ ጻላላፕ አትን መለ አቶ የዝን ሳሎ የዘ ኪታንቹንꬃና ማቅኮን ዎይ ናአያ ማቅኮን ኦደን ኤርዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ይና ዎድታ አይደ ማቅዛኮ፥ ይን ኤሮሰ ግሾ ናግንቶተን ምንጎተ። ");
INSERT INTO oyde_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ታ የእታ ፋ ኬꬅቶ አሺ፥ ኦገ ቅትደ አꬄ ጋራ። አꬃይ ፋ አሩንꬅስ ኦማር ኦማር ኦቻ እንግ ኡንታና ኦችትስ አደ ማህዳ፤ ማህ ናግዘን ምንꬂ ናጎደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«ይኒ ግሾ፥ ምንጎተ። አኮስ ጋይኮ፥ ካርቲ አዳይ ኡጉረ ማቅኮ ዎይ ቃማ ብላሄ ማቅን ዎይ ሉኩለ ኦልዘ ዎደ ማቅን ዎይ ዎንታ ጎዳ ማቅን አይደ የኦደ የዛኮ፥ ይን ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ይን ቲርካይዝን ኤ ይእ ይንታና ገንቶ የዝን ደንጋመ ጋር ምንጎተ። ");
INSERT INTO oyde_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ታኒ ይንትስ ኦህዛኖ አስ ኡቡንꬅስ ኦህነ፤ ምንጎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ፋስጋ ባአለ ቦንችዘ ቃማን ቦራ ባአለ ቦንችዘ ቃማ የሎደስ ላምእ ቃማ አትዳ። ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬅ አስ ኤርካይዝን የሱሳ ገኒ አይኪ ዎꬎደስ ኦገ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","«አሱንꬅ ካች ከሳመ ፋና ፋስጋ ቦንችዘ ቃምተ ይኖ ኦቾስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","የሱሳ ብታንያ ካታምተ ቁርሱማራ Ꮉርግንትደ ስሞና ኬꬃ ሙንታላ አፋ በቴዝን፥ ፈቲ ማችታ አልባስጥሮሰ ብልቃጠ ኩሙꬅ ናርዶሳ ጋዘ ጋማ አልኦ ሽቶ ኤኪ ይእዳ። የ ብልቃጽዛ መንꬂ ሽቶ የሱሳ ኦምተ ጉስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ይና በስተ የዘ አሱንꬃፓ ፈተ ፈተ ዥልꬊ፥ «Ꮉይ ሽትዛ ጨር Ꮉሪ ላልዛና አኮሶ? ");
INSERT INTO oyde_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ꮉይ ሽትዛ Ꮉይꬕ ጼት ድናረስ ባይዝ፥ ብርቶ ዳሁንꬅስ እማደስ ዳንዳእንታነ» ያጋእ ፋ ግዳ ኦህንትዳ። የይዝ፥ ይና ማችቶ ጋማ ለቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","የዝን የሱሳ «Ꮉና ማችቶ አኮን ጋእፐተ፤ እዞ አኮስ ዋይተ? እዛ ታስ ሎኦ ባዝ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ዳሁንꬅ ኡባ ዎደ ይንታራ የነ። ይን ኮየዘ ዎደ አይደን ይን ኡንታና ማዶደስ ዳንዳአነ፥ የዝን ታኒ ኡባ ዎደ ይንታራ የዞስ። ");
INSERT INTO oyde_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","እዛ ፋ ዳንዳእዳኖ ኦችዳ፤ ማህ ታና ሞገስ ጊግሳደስ ቲንꬊ ሽቶ ትዥዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ታኒ ይንትስ ቱሮ ኦህነ፤ ሳአ ኡባነ ዎንገለ ኦህንትዘ አባን፥ አሱንꬅ እዞ ቲሮደ ፋና Ꮉና እዛ ኦችዳና ኦህንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ታጶ ላምእ ታማሩንꬃፓ ፈተ አስቆሮቱ ይሁዳ ጋእንትዘ የሱሳ ካህኑንꬅ Ꮉላቁንꬅስ አꬂ እማደስ ኡንታጎ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ኡንቲ ይኖ ስኤዘ ዎደ ኡፋይት፥ «ኑኒ ኔስ ብራ እንጎዳ» ያጋይዳ፤ ይሁዳ የሱሳ አꬂ እማደስ ዎትዘ ዎደ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ቦራ ባአለ ቦንችንትዘ ቲኖ ቃማ፥ ፋስጋ ካꬃ ማአደስ ማራ ሹክዘ ዎደ የሱሳ ታማሩንꬅ ኤጎ፥ «ፋስጋ ቦንችዘ ቃማ ነ ማአደ ካꬃ ኑ አባ Ꮉንግ ጊግሳደ?» ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","የሱሳ ፋ ታማሩንꬃፓ ላምኡንꬃና Ꮉኒ ጋራ ያጋእ ኪትዳ፦ «ካታማ ቅቶተ፤ ይን Ꮉማደራ፥ ጹጋራ Ꮉꬅ ቶኪ ፈቲ አꬄ ይንታራ የልንቶዳ፤ ኤዛ ካሎተ። ");
INSERT INTO oyde_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ኤ Ꮉንግ ገልዘ ካርቲ አደጎ፥ ‹አስታማርዘ ኔጎ፥ «ታኒ ታ ታማሩንꬃራ ፋስጋ ማአደስ ዛቆ ኬꬅታ አባ የነ?» ጋይዳ› ያጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ካርቲ አዳይ ይንታና ፎቀላ የዘ ጊጊ በትደ ዳልጋ ክፍለ ቤሳዳ፤ የይጋ ጊግዞተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","የ ታማሩንꬅ ኬዚ፥ ካታማ Ꮉንግዳ፤ የሱሳ ኡንታጎ ኦህዳን ጋራ ደንግ፥ ፋስጋ ካꬃ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ሳታ ኡጉርዘ ዎደ የሱሳ ታጶ ላምእ ታማሩንꬃራ የይጋ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ኡንቲ በቲ ካꬃ ማአደራ፥ የሱሳ ኡንታጎ፥ «ታኒ ይንትስ ቱሮ ኦህነ፤ ይንታፓ ፈተ ታራ ሙእዘ፥ ታና አꬂ እንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ኤ ታማሩንꬅ አዛኒ፥ ፋ ኦምተ ኦምተ፥ «ቱሮ ታና የሳነ?» ያጋእ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","የሱሳ ማህ፥ «የ አꬄ ይን ታጶ ላምኡንꬃፓ ፈታ፤ ኤ ታራ ፈትላ ፋ ኩሽቶ ጋባተ ዳክዛያ። ");
INSERT INTO oyde_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","አስ ናአይ፥ ጌሽ ማጻፍተ Ꮉይቆዳ ጋእዳን ጋራ Ꮉይቆዳ፥ የዝን አስ ናአያ፥ አꬂ እንግዘ አꬃ ባደ። የ አꬄ የልንትካይዛር አተዛኮ ኤስ ሎኦ የሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ኡንቲ ማአደራ፥ የሱሳ ቦራ ኤኪ፥ ጾዝ ጋላትዳ፤ የ ቦርዛ ባጽ፥ ፋ ታማሩንꬅስ እንግተራ፥ «Ꮉተ፥ Ꮉና ታ አሽቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ጹአ ኤኪ፥ ጾዝ ጋላቲ፥ ኡንትስ እንግን ኡቡንꬅን የ ጹእዘፓ ኡዥዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","የሱሳ፥ «Ꮉና ጋማ አሱንꬅ ግሾ ጎግዘ ጫቆ ሱꬅ። ");
INSERT INTO oyde_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ታኒ ይንትስ ቱሮ ኦህነ፤ ታ ጾዘ ካእቱምተ ክለ ዎይነ ኡሻደ ቃምታ የሎደስ ማህ Ꮉይ ዎይንዘፓ ኡዦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ማዝሙረ የጽዳንፓ ሱባ ሻማሄ ደርዘላ አፋ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","የሱሳ ኡንታጎ፥ «ይን ኡባ ታና አሺ አሺ ላልንቶዳ፤» ጻፍንትዳን ፋና፥ « ‹ጾዘ ዱሮ የንግዛያ ዎꬎዳ፥ ዱሩንꬅ ኡባና ላልንቶዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","የዝን ታኒ Ꮉይቆፓ ደንድዳንፓ ሱባ ይንታፓ ቲንꬊ ጋልላ አꬎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ጴጥሮሳ ማህ፥ «ኡንቲ ኡቡንꬅ ነና አሺ አሺ ꬋብኮን፥ ታ ነና አሾስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","የሱሳ ጴጥሮሳጎ፥ «ታኒ ኔስ ቱሮ ኦህነ፤ Ꮉይኖ ቃማ ሉኩለ ላምእ ቶሄ ኦሎዳንፓ ቲኖ ነ ታና Ꮉይꬕ ቶሄ ካዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","የዝን ጴጥሮሳ ካሰንፓ ምንꬂ፥ «ታኒ መለ አቶ የዝን፥ ኔራ ዎላ Ꮉይቅዛኮን፥ ነና ካዶስ» ያጋይዳ። ማህ መሉንꬅ ኡቡንꬅ ይኒ ፋና ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ጌተሰማነ ጋዘ በሳ Ꮉንግዳ፤ የሱሳ ፋ ታማሩንꬃጎ፥ «ታኒ ጾዝ ዎሲ ማቃደ ዎንꬅስ ይን Ꮉነ በቶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","የሱሳ ጴጥሮሳ፥ ያይቆባራን ዋሐንሳ ፋራ ኤኪ ቅትዳ፤ ጋማ ዋይንት ኡንእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ማህ ኡንታጎ፥ «ታኒ Ꮉይቆስ ዎንꬅስ አዛንዳ፥ Ꮉነ ጋምኦተ፤ ገንትፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ኤራꬅ ቲኖ ሺቂ፥ ሳአላ ቡንቁንቲ፥ ዳንዳእንትዘ ባዝ ማቅኮ፥ Ꮉና ዋየ ሳታ ፋፓ አꬎደ ጋር፥ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ማህ፥ «አባ፥ ታ አዳዮ፥ ኡባ ባዝታ ኔስ ዳንዳእንታነ፥ Ꮉና ዋየ ጹኡቶ ታፓ Ꮉሶ። የዝን ነ ቆፍታ Ꮉኖፕ አትን ታ ቆፍታ Ꮉንፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","የሱሳ ማቂ ይእ፥ ኡን ገንተዝን ደንግ፥ ጴጥሮሳጎ፥ «ስሞና፥ ገንትዳ? ኔኒ ፈቲ ሳተን ባርክ ናጎደስ ዳንዳኦሳ? ");
INSERT INTO oyde_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ማꬋ ይን ገላመ ጋር ባርክ ናጊ ጾዝ ዎሶተ። አያና ጊግዳ፥ የዝን ይን አሽታ ላቢꬅ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ማህካ Ꮉንግ ቲኖስትፋና ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ፋ ታማሩንꬃጎ ሱብ ማቂ ይእዘ ዎደ ገንተዝን ደንግዳ። ኡን ኣፍቶ ገንቶ ጎዚ አይክደ ግሾ ኤ አኮ ኦህዛኮን ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ꮉይꬕንꬃ ኡንታጎ ይእ፥ «Ꮉኖ የሎደስ ገንቲ ሸምፖላ? ይኬ፥ ማቃዳ፤ ሳታ የልዳ፤ ቦኦተ! አስ ናአይ፥ ናጋራንቾ አሱንꬅስ አꬊ እንግንቶደ ዎድታ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ደንዲ የꬎተ፤ ቦኦተ፥ ታና አꬂ እንጎዳይ የልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","የሱሳ ይኖ Ꮉጋ ኦሆደራ፥ ታጶ ላምእ ኤ ታማሩንꬃፓ ፈተ፥ ይሁዳ፥ ኤልሲ የሊ አሽዳ። ማህ ካህኑንꬅ Ꮉላቁንꬅ፥ ህገ አስታማሩንꬅን ጭሙንꬅ ኪትን፥ ማሻን ጉፈን አይኪ ጋማ አሱንꬅ ኤራ ዎላ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","የሱሳ አꬂ እንግዳይ የንꬅ ጋማ አሱንꬅስ፥ «ታኒ ዬርዛይ ኤዛ፤ ኤዛ አይኪ፥ ምንꬂ ናጊ፥ ኤኪ ካንጎተ» ያጋእ ማላ ኦህ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ይሁዳ የሊ ዎꬍደ ጋር የሱሳጎ ሺቂ፥ «አስታማርዛዮ» ያጋእ የሱሳ ዬሪ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","የንꬅ ጋማ አሱንꬅ የሱሳ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","የዝን ካለ ኤቅዱንꬃፓ ፈተ ፋ ማሽዛ ሾዲ ካህኑንꬅ Ꮉላቅዘ አርዛ ጉዲ፥ ኤ Ꮉይዛ ጋቺ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","የሱሳ ማህ፥ የንꬅ አሱንꬃጎ፥ «ታና ፋኖ ማህ፥ ፋኖ አይክዘፋና አይኮደስ ማሻን ጉፈን አይኪ ይእዳተ? ");
INSERT INTO oyde_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ታኒ ጾዘ ኬꬃ ታማርስተራ፥ ኡባ ዎደ ይንታራ የዘ ዎደ ታና አይክካይዛራ፥ የዝን ጌሽ ማጻፍተ ጋእዳና ፎልንቶደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ኤ ታማሩንꬅ ኡቡንꬅ ኤዛ አሺ አሺ ላልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ላጻና ጻላላ ማእደ ፈቲ ናአትꬅ አꬃ የሱሳ ካልዛያ አሱንꬅ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","የዝን የ አꬄ ላጽንዛ አሺ አሺ፥ ጽራ ካሎ ዎጺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","አሱንꬅ የሱሳ ካህኑንꬅ Ꮉላቅዘ ኬꬃ ካንግዳ። እዘ ካህኑንꬅ Ꮉላቁንꬅ፥ ጭሙንꬅን ህገ አስታማሩንꬅ ሺቂ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጴጥሮሳ ካህኑንꬅ Ꮉላቅዘ ዎፋ የሎደስ Ꮉኮራ ኤዛ ካሊ Ꮉንግ እዘ ኪትንትዙንꬃራ በቲ ታማ ካዣነ። ");
INSERT INTO oyde_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ካህኑንꬅ Ꮉላቁንꬅን ፍርዳ ሻንጉንꬅ ኡባ የሱሳ ዎꬎደስ ኤላ አፋ ማርካ ኮይዳ፥ የዝን አኮን ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ጋማ አሱንꬅ ኤላ አፋ ዎርዶ ማርክꬍዳ፥ የዝን ኡን ማርካትꬅታ ፈቶ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","ፈቲ ፈቲ አሱንꬅ ደንዲ ኤቂ የሱሳላ፥ «ኤ፥ ‹ታኒ አስ ኬጽደ Ꮉና ጾዘ ኬꬅቶ ላሊ፥ አስ ኩሸራ ኬጽንትካይዘ መለ ጾዘ ኬꬂ Ꮉይꬕ ቃማ ግዳ ኬጾዳ› ጋኦደራ ኑኒ ስእዳ» ያጋእ ዎርዶ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ማቆ የዝን፥ ኡን ማርካትꬅታ ይናን ፈቶ ባያ። ");
INSERT INTO oyde_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ካህኑንꬅ Ꮉላቅዘ አስ ኡቡንꬅ ቲንተ ደንዲ ኤቂ፥ «Ꮉንስ ነና ሞትዘ ሞትስ ነ ማህዘባዝ ባ?» ያጋእ የሱሳ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","የዝን የሱሳ ስእ ጋይዳ፤ አኮን ማህካያ። ካህኑንꬅ Ꮉላቅዘ፥ «አንጅንትደ ጾዘ ናአይ፥ ክርስቶሳ ነናነ?» ያጋእ ማህ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","የሱሳ ማህ፥ «ዬ ታና፥ ይን አስ ናአይ፥ ዎልቃማ ጾዘፓ ምዛቅ ዛላራ በቴዝን ማህ ሳሎ ꬎነራ የኦደራ በአዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ካህኑንꬅ Ꮉላቅዘ ፋ ማእቶ ፌꬊ፥ «ኑስ መለ ማርካ አኮ ኮሸ? ");
INSERT INTO oyde_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ይን ኤ ጫሽቶ ስእዳ፤ ይን ቆፍታ አኮ?» ያጋይዳ። ኡን ኡቡንꬅ፥ «ኤ Ꮉይቆደስ ቤዛነ» ያጋእ ኤላ አፋ ፍርድዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ኡንታፓ ፈተ ፈተ ኤላ አፋ ጩተ አይክዳ። ኤ ኣፍቶ ጎዚ ባቂተራ፥ «ነና ቆጽደ ኦደ? አነ ኑስ ኦሆ!» ያጋይዳ። ናግዙንꬅ ኤዛ ጉድተራ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጴጥሮሳ ካህኑንꬅ Ꮉላቅዘ ዎፋ ዬካ ዛላራ የዝን፥ ካህኑንꬅ Ꮉላቅዘ ማች አሩንꬃፓ ፈታ እዘ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ጴጥሮሳ ታማ ካዣኖ ብእ፥ ዳኪ ሎይꬂ ብእ፥ «ኔንን ናዝረተ የሱሳራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","የዝን ጴጥሮሳ፥ «ነ ጋዛና አኮ የዛኮን ታ ኤሮስን፥ ታስ ቲርንቶስ» ያጋእ ካድዳ። ያጋእ ማቂ ዎፋ ከዝዳ ኢራ ሉኩለ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ይና አርታ ጴጥሮሳ ብእ፥ ኤ ካለ ኤቅደ አሱንꬃጎ፥ «Ꮉይ አꬄን ኡንታራ የነ» ጋእ ማህ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","የዝን ጴጥሮሳ ማህን ካድዳ። ኤራꬅ ጋምኦደራ፥ ካለ ኤቅደ አሱንꬅ ማህ ጴጥሮሳጎ፥ «ኔኒ ጋልላ ሳአ አስ ማቅደ ግሾ ቱሮ ኡንታራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","የዝን ጴጥሮሳ፥ «ታኒ ይን ጋዘ አꬃ ኤሮስ!» ያጋእ ፋና ባድተራ ጫቆ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ኢራ ሉኩለ ላምእንꬃ ኦሊ አሽዳ። ጴጥሮሳ የሱሳ ኤጎ፥ «ኔኒ ሉኩለ ላምእ ቶሄ ኦሎዳንፓ ቲኖ Ꮉይꬕ ቶሄ ታና ካዶዳ» ኤጎ ጋይዳኖ ቲሪ ዬክዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ዎንታ ጎዳ ኤልሲ ካህኑንꬅ Ꮉላቁንꬅ፥ ጭሙንꬅ፥ ህገ አስታማሩንꬅን ፍርዳ ሻንጉንꬅ ኡባ ሺቂ ዞርንትዳ። ኡንቲ የሱሳ አጪ ካንግ ጵላጦሳስ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጵላጦሳ ኤጎ፥ «ኔኒ አይሁዱንꬅ ካት?» ያጋእ ኦጭዳ። የሱሳ ማህ፥ «ነ ጋይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ካህኑንꬅ Ꮉላቁንꬅ የሱሳ ጋማ ባዛራ ሞትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","የዝን ጵላጦሳ ማህ የሱሳጎ፥ «ኔስ ማህዘባዝ ባ? ኡንቲ ኔላ አኮ ሞቶ ኬእዛኮ ቦኦሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","የዝን የሱሳ መለባዝ ማሀንጽ እጽን፥ ጵላጦሳ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ጵላጦሳስ ፋስጋ ባአለ ቦንችዘ ቃምተ አሱንꬅ ኮይዘ ፈቲ አስ አቻፓ ብልዘ ዎጋ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","የ ዎደ ፈቲ ባርባና ጋዘ አꬄ ካች ደንꬂ ሸምፖ ዎꬍደ አሱንꬃራ ዎላ አች ኬꬃ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ጋማ አሱንꬅ ጵላጦሳጎ ይእ ቲኖፓ ዪዝተራ ጋምእደ ፋና ኦቾደ ጋር ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ጵላጦሳ አሱንꬃና ማህ፥ «ታኒ ይንትስ አይሁዱንꬅ ካትዛ ብሎደ ጋር ኮያነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ይኖ ኤ ጋእዳና፥ ካህኑንꬅ Ꮉላቁንꬅ የሱሳ ቃናቲ አꬂ እንግዳኖ ኤርዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","የዝን ካህኑንꬅ Ꮉላቁንꬅ ኤ ግሾ ባርባና ብሎደ ጋር፥ የንꬅ ሺቅደ አሱንꬅ ጵላጦሳ ዎሶደ ጋር አሱንꬃና ዞርዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጵላጦሳ ማህ፥ «ዬዝን፥ ይን አይሁደ ካት ጋዛያ ዋይሳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","አሱንꬅ ጵላጦሳላ አፋ ኡክ፥ «ማስቃላላ አፋ ኤዛ ሱጾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጵላጦሳ አሱንꬃጎ፥ «አኮሶ? ኤ አኮ ኢታ ባዝ ኦችዶ?» ያጋይዳ። የዝን አሱንꬅ ቲኖስትፓ ጉጂ ኡክ፥ «ማስቃላላ ኤዛ ሱጾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጵላጦሳ አሱንꬃና ኡፋይሶደስ ኮይ፥ ባርባና አሱንꬅስ ብልዳ፤ የይዝ አላንጋራ የሱሳ ጋራፊ፥ ማስቃላላ አፋ ሱጾደ ጋር አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ይንፓ ማቂ፥ ዎታዳሩንꬅ የሱሳ ኤኪ ፕራቶርያ ጋዘ ፖሊስ ጻባ ካንግ፥ መለ ዎታዳሩንꬃና ኡባ ፈትላ ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ማህ ዞቆ አፉላ ኤዛ ማይዝዳ፤ አንጋꬅ ዛዉደ ጊግዚ፥ ኤ ኦምተ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ይንፓ ማቂ፥ ኤጎ፥ «አይሁዱንꬅ ካትዛዮ ሳሮ» ያጋእ፥ ኩሸ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ኤ ኦምተ ጉፈራ ጉድዳ፤ ማህ ኤላ ጩትዳ፤ ቡንቁንቲ ኤስ ጎይንዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ኤዛ ቶችዳንፓ ማቂ ዞቆ አፉላ ኤፓ ቃሪ ኤኪ፥ ኤ አፉልቶ ኤዛ ማእሲ ማስቃላላ አፋ ኤዛ ሱጾደስ ኤኪ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ኡን Ꮉንግተራ፥ እስክንድረነን ሩፎሳ አዳይ፥ ስሞና ጋዘ ቀሬና ሳአ አስ፥ ጋጻረፓ ካታማ የእዘራ የልንት፥ የሱሳ ማስቃላ ዎልቃራ ቶስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","የይዝ ጎልጎታ ጋዘ በሳ የሱሳ ካንግዳ። «ጎልጎታ» ጋዛና «ኦማ ኦታ» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ꮉርጋመ ፋና ካርበ ጋዘ ጋላ ዎርቂንትደ ዎይነ ኡዦ ጋእ ኤስ እንግዳ። የዝን ኤ ኡዣንጽ እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ኡንቲ ማስቃላላ አፋ ኤዛ ሱጽዳ። ኦና አኮ የሎድየዛኮን ጋእ ኤ አፉልቶ ሻጊ እጻ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ኡን ማስቃላላ አፋ ኤዛ ሱጽዘ ዎደ ዎንታፓ Ꮉይꬕ ሳተ። ");
INSERT INTO oyde_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ኡን፥ «አይሁዱንꬅ ካት» ያጋእ ኤዛ ሞትዘ ጹፈ ጻፊ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","የሱሳራ ላምእ ፋኑንꬃና ፈታ ኤፓ ምዛቅ ዛላራ Ꮉንካያ ኤፓ ዎርክታ ዛላራ ማስቃላላ አፋ ሱጽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ጌሽ ማጻፍተ፥ «ኢታ ባዝ ኦችደ አሱንꬃራ ኤ ፋይድንትዳ» ጋእንትዳና ፎልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ኦገራ አꬍዘ አሱንꬅ የሱሳ ለቂ፥ ፋ ኦምቶ ኤንእዝ ጫዥዳ፤ «ዛንባይ! ጾዘ ኬꬅቶ ላሊ Ꮉይꬕ ቃማ ግዳ ኬጽዛዮ፥ ነ ኦምቶ አሾ፤ ");
INSERT INTO oyde_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","አነ ማስቃልዘፓ ዎꬊ ነና አሾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ይኒ ጋራ፥ ካህኑንꬅ Ꮉላቁንꬅ ህገ ታማርስዙንꬃራ ፈትላ የሱሳ ለቂ፥ «መሉንꬃና አሽዳ፥ የዝን ፋና አሾደስ ዳንዳኦስ፤ ");
INSERT INTO oyde_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ኑኒ ብእ አማኖደ ጋር ክርስቶሳ፥ እስራኤለ ካት፥ አነ ማስቃላፓ Ꮉተ ዎꬎ» ያጋይዳ። ማህ መለ አቶ የዝን፥ ኤራ ማስቃላላ አፋ ሱጹንትዱንꬃፓ ኤዛ ለቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","እዝፑን ሳተፓ ደንꬂ፥ ኡዱፉን ሳተ የሎደስ ሳእታ ኡባ ꬉምዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ኡዱፉን ሳተ የሱሳ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቅታን?» ያጋይዳ። ይኒ ብልꬅታ፥ «ታ ጾዛዮ፥ ታ ጾዛዮ፥ ታና አኮስ አሽዶ?» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","እዘ ኤቅደ አሳፓ ፈተ ፈተ ይኖ ስእ፥ «ይኬ፥ ኤልያሳ ጼጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","የንꬅ አሱንꬃፓ ፈተ ዎጺ፥ ጉርባ ፉዛራ ጫላ ዎይነ ባዢ፤ ጉፈ በርꬃላ ጋዲ፥ «ናጎተ፤ ኤልያሳ ማስቃላፓ ኤዛ ኬꬆደስ የኦድየዛኮ አነ ቦኦዳ» ያጋእ የሱሳ ዶናጎ ኡሾደስ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","የሱሳ ፋ ቃልቶ ꬎቅ ዪዚ ዉይሲ፥ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ጾዘ ኬꬃ ሱጹንትደ ማጋራጅታ ዎካፓ ሱለ ጋጻ የሎደስ፥ ላምእ ኬዚ ፌꬍንቲ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ማስቃልዘፓ ቲኖ ዛላራ እዘ ኤቅደ ፈቲ ማቶ Ꮉላቅዘ፥ የሱሳ ዋይዝ Ꮉይቀዛኮ ብእደ ዎደ «Ꮉይ አꬄ ቱሮ ጾዘ ናአ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ይኖ Ꮉኮራ ኤቂ በእዘ ኤራꬅ ማቹንꬅ የነ። ኡን ግዳ ማግደላ ማይራማ፥ ጌዘ ያይቆባን ዮሳ እንታ ማይራምራን ሳሎማ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","የንꬅ ማቹንꬅ የሱሳ ጋልላ የዘ ዎደ ኤዛ ካልዱንꬃናን ኤዛ ሞክዱንꬃና ማህ የሱሳራ ዎላ የሩሳላመ Ꮉንግደ መለ ጋማ ማቹንꬅ እዘ የነ። ");
INSERT INTO oyde_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ሳእታ ኡጉርደ ዎደ ሺቅደ አሱንꬅ ግዳ ቦንችንትደ አይሁደ ሻንጉንꬃፓ ፈተ፥ ዮሰፋ ጋዘ አꬄ፥ ጾዘ ካእቱሞ ዮኦዳኖ ናግተራ የዘ፥ አርማትያሳ ካታማ አስ የዛይ ይእዳ። ዎንትስተ ሳምባታስ ጊግንትዘ ቃማ ማቅደ ግሾ ዮሰፋ ሚንግ ጵላጦሳጎ Ꮉንግ፥ የሱሳ አህቶ ኤኮደስ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ጵላጦሳ የሱሳ Ꮉይቂዳኖ ስእደ ዎደ ጋማ ቆፕዳ፤ ማቶ Ꮉላቅዛ ጼጊ፥ «ኤ Ꮉይቂ ጋምእዳ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ጵላጦሳ የሱሳ Ꮉይቂዳኖ ማቶ Ꮉላቅዘፓ ስእ ኤ አህቶ ዮሰፋስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ዮሰፋ ሞጎ አፉላ ዎንግ፤ የሱሳ አህቶ ማስቃላፓ ኬꬂ፥ አፉላራ ጻጺ፥ ሹቻፓ ዎጭንትደ ቦዛ ግዳ ኤ አህቶ ሞግዳ። ማህ ይና ቦዝት ዶንተ ዳማ ሹች ጎልእዝ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ማግደላ ማይራምራን ዮሳ እንታ ማይራማ የሱሳ አህቶ ኡን አባ ጋድዛኮ በእነ። ");
INSERT INTO oyde_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ሳምባታ አꬍዳንፓ ሱባ ማግደላ ማይራሞ፥ ያይቆባ እንታ ማይራምራን ሳሎማ Ꮉንግ፥ የሱሳ አህቶ ትሻደስ ሽቶ ዎንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ዎጋ ዎደ ዎንታ ጎዳ ጻልቀ ከሳደራ፥ ቦዛ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ኡን ፋ ግዳ ፈታይ ፈታይራ፥ «ቦዝት ዶንትፓ ኑስ ሹችቶ ኦደ ጎልእዝ Ꮉሶደ?» ያጋእ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ኡን በእዘ ዎደ የ አንድር ዳማ ሹችዘ ቡንቡሉንቲ Ꮉልእዳኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","የሱሳ ሞግንትደ ቦዝት ግዳ ገልዘ ዎደ ፈቲ ይꬎ ꬊራꬃይ ቦꬅ ማኦ ማእ፥ ምዛቅ ዛላራ በትዳይ ብእ ታንዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","የዝን ኤ ኡንታጎ፥ «ታንፐተ፤ ማስቃላላ አፋ ሱጹንትደ፥ ናዝረተ የሱሳ ይን ኮይዛኖ ታኒ ኤራነ። ኤ Ꮉነ ባያ፥ Ꮉይቆፓ ደንድዳ። ኡን ኤዛ ሞግደ በስቶ Ꮉኖ ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ꮉተ Ꮉንግ የሱሳ ታማሩንꬅስን ጴጥሮሳስ፥ ‹የሱሳ ይንታፓ ቲንꬊ ጋልላ አꬍዳ። ኤ ይንትስ ኦህዳን ፋና ይን ኤዛ የይጋ በአዳ› ጋእ ኦሆተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ማቹንꬅ ዣሽሞራ ጎቂ ቦዝትፓ ኬዚ አችንትዳ። ማህ ኡን ዣሽትዘ ግሾ ይኖ ኦደስን አኮን ኦህካያ። ");
INSERT INTO oyde_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","የሱሳ Ꮉይቆፓ ደንድዳንፓ ማቂ ዎጋ ዎደ ዎንታ፥ ላፑን ቱና አያኑንꬃና ኬስደ ማግደላ ማይራምስ ቲንꬊ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","እዛ Ꮉንግ ኤራ ቲኖ የዙንꬅስ፥ ኡን አዛንተራን ዬክተራ የዝን ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","የዝን የሱሳ ፋጻ የዛኖን ኢስ በንትዳኖ ኡን ስእደ ዎደ እዛ ጋዛኖ አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ይንፓ ሱባ፥ ኡንታፓ ላምኡንꬅ ካታማፓ ኬዚ Ꮉማደራ፥ ኦገላ አፋ የሱሳ ቲኖፓ ዱሙꬊ ኡንትስ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ኡን ሱብ ማቂ፥ መሉንꬅስ ኦህዳፕ፥ አትን መሉንꬅን ኡን ኦህቶ ቱሮ ጋይካያ። ");
INSERT INTO oyde_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ሱባፓ ታጶ ፈቲ ኤ ታማሩንꬅ ካꬃ ማአደራ፥ የሱሳ ኡንትስ በንትዳ። ኡንትስ አማኖ ባይዘ ግሾን Ꮉይቆፓ ኤ ደንድዳኖ ብእደ አሱንꬅ ኦህን ኡን አማናንጺ እጽደ ግሾ ኤ ኡንታና ቦርዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ኤ ኡንታጎ፥ «ሳአ ኡባ ቅቲ አስ ኡቡንꬅስ ዎንገለ ኦሆተ። ");
INSERT INTO oyde_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","አማንዳይን ጻማቅንትዳይ አቶዳ፥ የዝን አማኖሰ ፍርድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","አማንዙንꬅስ Ꮉና ማልታ እንግንቶዳ። ኡን ታ ሱንꬅተ ቱና አያና ከሶዳ፥ ክለ ዶናራ ኦህንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ኡን ሾሽ አይክኮን ዎይ ዎꬍዘባዝ ኡዥኮን ኡንታና ቆሀማ። ማህ ኡን ፋ ኩሽቶ Ꮉርግንትዙንꬃላ አፋ ጋዲ ኡንታና ፋꬆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ላꬂ የሱሳ ታማሩንꬃራ ኦህንትዳንፓ ሱባ ኡደ ሳሎ ከዝዳ፤ ጾዘፓ ምዛቅ ዛላራ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ኤ ታማሩንꬅ ቅትደ በሳ ኡባ ቃላ ኦህዳ። ላꬅን ኡንታራ ዎላ ኦቻነ። ኡንቲ ኦህዘ ቃልታ ቱሮ ማቅዳኖ ጾዚ ኡንትስ እንግደ ማልተ ሚንꬃነ።");
INSERT INTO oyde_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ቦንቾ ተዎፍሎሳ፥ ኑ ግዳ ፎልንትደ ባዝስ ጋሙንꬅ፥ ፋስ ዳንዳእንትደ ጋር ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ይና ታሪክቶ ኡን ጻፍዳና ቲኖፓ አይኪ ኣፈ ማርኩንꬅን ቃላ ጻፊ ኑስ ኦህዳኖ። ");
INSERT INTO oyde_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ታንን ታ ባጋራ ቲኖፓ ቆፒ ብእዳንፓ ሱባ ይና ታሪክታ Ꮉንዳኖ ሉልዚ ኔስ ተዎፍሎሳስ ጻፍዛና ታስ ሎኦ ማቂ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ይናን፥ ነ ታማርዳና ቱሮ ማቅዳኖ ኤርሶደስ። ");
INSERT INTO oyde_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ይሁዳ ካት ሄሮድሳ ዎደ አብያ ባጋፓ ማቅደ ዛካርያሳ ጋዘ አይሁደ ካህነ የነ። ኤ ማችታን አሮና ኮቻፓ። እ ሱንꬅታን ኤልሳቤጦ። ");
INSERT INTO oyde_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ላምኡንꬅን ላꬄ ዎጋን ኪቶ ኡባ ናጊ ቦረ ባይዝን ጾዘ ቲንተ ጽሎትꬃራ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ይኦፕ አትን ኤልሳቤጣ ꬎኦንꬅ ማቅደ ግሾ ኡንትስ ናአ ባያ። ላምኡንꬅን ጭንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ፈቲ ዎደ ዛካርያሳ ፋ ታርቲ ወደ ጾዘ ቲኖ ካህነትꬃራ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ካህነትꬅ ዎጋራ ጾዘ ኬꬃ ገሊ እጻነ ጩግሳደስ ኤዛ እጻ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","እጻነ ጩግዘ ዎደ አሱንꬅ ኡባ ባለ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ላꬄ ኪታንችዘ ዣርሾ ዣርሽዘ በስትፓ ምዛቅ ዛላራ ኤቂ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዛካርያሳ ኤዛ ብእ ታኒ ጋማ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","የዝን ኪታንችዘ ኤጎ፥ «ዛካርያሳ ዣሽትፐ፤ ነ ዎስታ ስንትዳ። ነ ማችታ ኤልሳቤጣ ꬊራꬅ ናአ የሎዳ፥ ኤዛ ዋሐንሳ ጋእ ነ ሱንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ኤ ኔስ ዋሎን ኡፋይስ ማቃዳ፤ ጋሙንꬅ ኤ የልንተ ኡፋይቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ላꬄ ቲኖ ኤ ዳማ ማቃዳ፤ ዎይነ ኡሺ ማቅን መለ ማꬅዘ ኡሺ ኡዣማ። ፋ እንቲ ሳዝተ የዛራ ጌሽ አያናራ ኩሞዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","እስራኤለ አሱንꬃፓ ጋሙንꬃና ፋ ላꬄ፥ ጾዘጎ ማሆዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","አዱንꬅ ዎዝንቶ ናኡንꬃጎ ማሆዳ፥ ኪትንቶሱንꬃና ጽሎትꬅ ጭንጫትꬃጎ ማሆደ ጋር፥ ላꬅስ ኮሽዘ ዎርዣ ጊግሳደስ ኤልያሳ አያናራን ዎልቃራ ላꬄ ቲንተ Ꮉማዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ዛካርያሳ ኪታንችዘጎ፥ «ታ ይኖ አኮራ ኤሮደ? ታራን ታ ማችትራ ጭንግዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ኪታንችዘ ማህ፥ «ታኒ ጾዘ ቲንተ ኤቅዘ ጋብርኤለ። Ꮉና ምስራችቶ ኔስ ኦሆደስ ጾዛፓ ኪትንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ይኬ፥ ዎድቶ ናጊ ፎልንቶደ ታ ቃልቶ ነ አማናንጽ እጽደ ግሾ Ꮉና ፎልንቶደ ዎንꬅስ ነ ዶንታ ሙመ ማቃዳ፥ ኦህንቶደስን ነ ዳንዳአማ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","የ ዎደ ዛካርያሳ ጾዘ ኬꬅተ ገሊ ጋምእደ ግሾ አኮ ይእዶ ጋእ አሱንꬅ ባለ ናግተራ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ኤ ባለ ኬዚ ኡንታና ኦህሳደስ ዳንዳእካያ። ማላ ኩሸራ ቤዛንፕ አትን ኦህንቶደስ ዳንዳኦሳኖ ብእደ ዎደ ቆንጭꬅ ብእዳኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ዛካርያሳ ኦቻ ዎድቶ ፎሊ ፋ ካራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ይንፓ ሱባ፥ ኤ ማችታ ኤልሳቤጣ ዎዳጽዳ። እችን አግና ኩሙꬅ ፋና ጌንꬅ አስስ በንትካይዛራ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","እዛ፥ «ላꬂ ፋ ማሮትꬅተ ታ ቶችቶ አስ ግዳፓ Ꮉሶደስ ብእ Ꮉና ዎድተ Ꮉኖ ታስ ኦችዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ኤልሳቤጣ ዎዳጽዳንፓ እዝፑንꬃ አግንተ፥ ጾዚ ኪታንቾ ጋብርኤለ ጋልላ ጋደ የዘ ናዝረተ ካታማ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ኤዝን ዮሰፋ ጋዘ ካት ዳዉተ ኮቻፓ ማቅደ አꬄስ ኦጭንትደ ዉዱርትጎ ኪትንትዳ። ይና ዉዱርታ ማይራሞ ጋእንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ኪታንቾ ኢጎ Ꮉንግ፥ «ጋማ ካꬍንትዳነ፥ ሳሮ ኔስ ማቀ፥ ጾዚ ኔራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ማይራማ ኤ ኦህተ ጋማ ታኒ፥ «Ꮉና አኮ ሳር» ጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ኪታንችዘ ማህ፥ «ማይራመ፥ ዣሽትፐ፤ ነ ጾዘ ቲንተ ናሾ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ይኬ ነ ዎዳጾዳ ꬊራꬅ ናአ የሎዳ፥ ኤ ሱንꬅቶን የሱሳ ጋእ ሱንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ኤ ዳማ ማቃዳ፥ ኡባፓ ካታራ ጾዘ ናአ ጋእንት ጼግንቶዳ። ላꬄ ጾዘ ኤ አዳይ ዳዉተ አራታ ኤስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ኤ ያይቆባ ኮቻላ አፋ መዽና ካእቶዳ፤ ኤ ካእቱምትስ Ꮉልኤ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ማይራማ ኪታንችዘጎ፥ «ይና ዋይዝ Ꮉኖደ? ታ ꬊራꬃራ የልንትካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ኪታንችዘ ማህ፥ «ጌሽ አያና ኔላ አፋ ዎꬎዳ፥ ኡባፓ ካታራ ጾዘ ዎልቅታ ኔላ አፋ ሸምፖዳ። ይኒ ግሾ፥ የልንትደ ጌሽ ናአይ ጾዘ ናአ ጋእንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ይኬ፥ ነ እግንታ ኤልሳቤጣ ፋ ጭማትꬅ ላይꬅተ ꬊራꬅ ናአ ዎዳጽዳ። እዛ ꬎንꬅ ጋእንትዳኖ፥ የዝን Ꮉተ እዝፑንꬃ አግና አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ጾዛ ጋምዘባዝ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ማይራማ፥ «ዬዛኮ፥ ታኒ ላꬄ አርትስ፥ ነ ቃልት ጋር ታስ ይኦ» ያጋይዳ። ይንፓ ሱባ፥ ኪታንችዘ ኢፓ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ማይራማ ይና ሳምንተ ደንዲ ይሁዳ ሳአ የዘ ፈቲ አለ ካታማ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ዛካርያሳ ካራ ገሊ ኤልሳቤጦ ሳሮꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ኤልሳቤጣ ማይራማ ሳሮꬅዛኖ ስእዘ ዎደ እ ሳዝተ የዘ ናአይ ኡፋይሳራ ዶልዳ። ኤልሳቤጣ ጌሽ አያናራ ኩሚ፥ ");
INSERT INTO oyde_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ፋ ቃልቶ ꬎቅ ዪዚ፥ «ኔኒ ማቹንꬃፓ አንጅንትዳኖ፥ ነ ዎዳጽደ ናአይን አንጅንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ይኦ የዝን፥ ታ ላꬄ እንተ፥ ኔኒ ታጎ የኦደ ጋር ታ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ይኬ ነ ሳሮትꬅቶ ታ ስእዘ ዎደ ታ ሳዝተ የዘ ናአይ ኡፋይሳፓ ዶልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ላꬂ ፎሎዳ ጋእ እንግደ ቃልቶ አማንዳና፥ እዛ አንጅንትዳኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ማይራማ Ꮉኒ ጋራ ያጋይዳ፦ «ታ ሸምፕታ ላꬃ ቦንቻነ፥ ");
INSERT INTO oyde_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ታ አያንዘ ጋላ ጾዘላ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ኤ ፋ አርቲ ቶችቶ ብእዳ። Ꮉይኖፓ አይኪ የለትꬅ ኡባ ታና አንጅንትዳኖ ጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ዎልቃማ ማቅደ ኤ፥ ታስ ዳማ ባዝ ኦችዳ። ኤ ሱንꬅታ ጌሽ። ");
INSERT INTO oyde_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ኤዛ ቦንችዙንꬃላ አፋ፥ ኤ ማሮትꬅታ መꬍናፓ መዽና የሎደስ። ");
INSERT INTO oyde_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ፋ ቀስተ ምንꬅ ባዝ ኦችዳ፥ ፋ ዎዝንተ ኡቱርትዙንꬃና ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ዳማ ካቱንꬃና አራትዘፓ ዎꬍዝዳ፤ ፋ ኦምቶ ቶችዙንꬃና ቦንችዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ናይꬍዱንꬃና ሎኦ ባዛራ ምሽዳ፥ የዝን ዱሩንꬃና ካሎ ኩሸ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ፋ ማሮትꬅቶ ቆፒ፥ ፋ አርዛ እስራኤለ ማድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ይናን ኑ አዱንꬅስ ኦህደ ቃላ፥ አብራሃማስን ኤ ዛርትስ ጋእዳኖ መꬍናስ ፎሎደስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ማይራማ ኤልሳቤጥ ካለ Ꮉይꬕ አግና ጋር ጋምእ ፋ ካራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ኤልሳቤጥስ የሎ ቃማ የልን ꬊራꬅ ናአ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","እ ዶꬁንꬅን እ እግኑንꬅ ላꬂ ዳማ ማሮትꬅ ኦችዳኖ ስእ፥ ኢራ ዎላ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ኦስፉንꬆ ቃምተ ዦጋ ናአያ ጋራዞደስ ይእዳ። ኤ አዳይ ሱንꬅተ ዛካርያሳ ጋእ ሱንꬆደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","የዝን እንታ፥ «አደ፥ ዋሐንሳ ጋእንቶደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ኡንትን፥ «ነ እግኑꬃፓ Ꮉይ ሱንራ ጼግንትደ ኦደን ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ኤ አዳይ ኦና ጋእ ሱንꬆድ የዛኮ ኤሮደስ ኮይ ኤዛ ማላ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ኤ ጻፍዘባዝ ኦጪ ኤኪ፥ «ኤ ሱንꬅታ ዋሐንሳ» ጋእ ጻፍዳ። ኡቡንꬅ ኤ ጻፍዳኖ ብእ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ኢራ ዛካርያሳ እልአንꬅታ ብልንትዳ፥ ጾዝ ጋላትተራ ኦህንተ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ዶꬁንꬅ ኡባ ዣሽሞራ ኩምዳ። Ꮉና Ꮉንዳና አለ ይሁዳ ሳአ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ይኖ ስኤዘ ኡቡንꬅ፥ «Ꮉይ ናአይ አኮ ይአድ የሳ?» ጋእ ፋ ግዳ ኦህንትዳ። ላꬄ ኩሽታ ኤራ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ዋሐንሳ አዳይ ዛካርያሳ ጌሽ አያናራ ኩሚ Ꮉኒ ጋራ ያጋእ ትንቢተ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«እስራኤለ ላꬄ ጾዘ ጋላትንቶ፥ ይእ ፋ አሱንꬃና ዎዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ፋ አርዘ ዳዉተ ኬꬃ አቶትꬅ ዎልቃ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ይናን ዛጋ ዎደ ጌሽ ናቡንꬅ ዶንተ ኦህንትዳን ፋና፥ ");
INSERT INTO oyde_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ኤ አሽታ ኑ ሞርኩንꬃፓን ኑራ ኦልንትዘ ኡቡንꬅ ኩሽትፓ። ");
INSERT INTO oyde_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ይኖ ኤ ኦችዳና ኑ አዱንꬅስ ፋ ማሮትꬅቶ ቤሳደስን፥ ፋ ጌሽ ጫቅቶ ናጎደስ። ");
INSERT INTO oyde_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ኑ አዳይ አብራሃማስ ጫቂደ ጫቅቶ ቆፖደስን ");
INSERT INTO oyde_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ኑ ሞርኩንꬅ ኩሽትፓ ኬሲ ዣሽሞ ባይꬅ ኤዛ ኪትንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ኑ በርተ ኡባነ ጌሻትꬃራን ጽሎትꬃራ ፋ ቲንተ ኑና ኤሶደስ። ");
INSERT INTO oyde_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ታ ናአዮ፥ ኔኒ ኡባፓ ካታራ ጾዘ ናበ ጋእንቶዳ። ላꬄ ኦግቶ ሎይꬆደስ ነ ኤ ቲንተ Ꮉንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ኡን ናጋርታ ኡጭንትን፥ ኡን አቶትꬅ ኤራ ደንጎዳኖ ነ ላꬄ ዎርዥትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ኑ ጾዘ ሎኦ ማሮትꬅትፓ ደንዲ ዎንታ ጻልቀ ኑስ ሳሎፓ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ይናን ꬉማ ግዳን፥ Ꮉይቆ ዳሾ ኦሞ የዙንꬅስ ፎእሳደስ፥ ኑ ቶህቶን ሳሮ ኦገጎ ማሆደስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ናአይ ድጭዳ፥ አያናራ ምንግዳ፥ እስራኤለ አሱንꬅስ በንቶደ ዎንꬅስ አኮ ባይዘ ጋናሳ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","የ ዎደ ሮመ ጋደ የዘ አስ ኡቡንꬅ ፋይድንቶደ ፋናን ሱንꬅታ ጻፍንቶደ ፋና ካት አዉግስጾሳ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ይናን ቀረኖሳ ሶርያ ጋደ አህዘ ዎደ ኦችንትደ ቲኖ ፋይዶ። ");
INSERT INTO oyde_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ይኒ ግሾ፥ ፈቲ ፈቲ አስ ፋ ሱንꬅቶ ጻፍንቶደስ ፋ የልንትደ ጋደ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ዮሴፋን ዳዉተ ኬꬃፓን ኮቻፓ ማቅደ ግሾ ጋልላ ናዝረተ ካታማፓ ደንዲ ዳዉተ ካታማ ማቅደ ይሁዳ ቤተለመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ꮉንጎደራ፥ የሎደስ ዎደ Ꮉልእደ ኤ ኦጪ ጋድደ፥ ማይራምራ ዎላ ጻፍንቶደስ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ኡን እዘ የዝን ኢስ የሎ ዎደ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ፋ አንግስ ናአያ የልዳ። ጩርቃራ ጻጺ ዛቆ አቅዘ ኬꬅ በሲ ꬋብደ ግሾ ጎንጋ ግዳ ዎይꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ይና ጋድተ ቃማ ዱሮ ዉደ የንግተ ዞዘ አቅዘ ዉደ የንግዙንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ላꬄ ኪታንቾ ይእ ኡን ካለ ኤቅዳ። ላꬄ ቦንቾ ኡን ካንቶ ዉቲ ፎእዳ፤ ኡንትን ዳማ ዣሽሞ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ኪታንችዘ ኡንትስ፥ «ዣሽትፐተ! ይኬ፥ አስ ኡባንስ ማቅደ ዳማ ኡፋይስ ምስራቾ ኤኪ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ይናን፥ ዳዉተ ካታምተ አሽዛይ ይንትስ Ꮉይኖ የልንትዳ። ኤዝን ላꬄ ክርስቶሳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ይናን ይንትስ ማላ ማቀ፤ ዦጋ ናአይ ጩርቃራ ጻጽንት ጎንጋ ግዳ ዎይእዳያ ይን ደማዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ቆፕካይዝን ጋማ ሳሎ ኪታንቹንꬅ ኪታንችዘራ ፈትላ በንቲ፥ ያጋእ ጋላትዳ፥ ");
INSERT INTO oyde_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ቦንቾ ጾዘስ አፋ ሳሎ፥ ሳሮትꬅ ሳአላ አፋ ጾዚ ካዽዘ አስስ ማቀ።» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ኪታንቹንꬅ ኡንታፓ ሻክንት ሳሎ ከዝዳንፓ ሱባ ዉደ የንግዙንꬅ፥ «አነ ላꬂ ኑስ ቆንጭዝደ ባዝን Ꮉንዳኖ በአደስ ቤተለመ የꬎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ኡንትን ኤልሲ Ꮉንግዳ። ማይራሞ፥ ዮሴፋን ዦጋ ናአይ ጎንጋ ግዳ ዎይእዳያ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ብእ ማቂ ናእባዝ ኡንትስ ኦህዳኖ፥ ጌሽ ይና በስተ የዘ አሱንꬅስ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ይኖ ስእደ ኡባ ዉደ የንግዙንꬅ ኦህዳኖ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ማይራማ Ꮉንደ ባዝ ኡባ ፋ ዎዝንተ ቆፕተራ የነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","የንግዙንꬅ ኡንትስ ኦህዳን ጋራ ይእን ብእዳ። ይኒ ግሾ፥ ፋ ስእደባዝስን ብእደባዝ ኡባንስ ጾዘ ቦንችተን ጋላትተ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ኦስፉንꬃ ቃምተ፥ ጋራዘ ዎደ የልን፥ ኢስ አግና አቶዳንፓ ቲኖ ኪታንቾ ጋድደ ሱንꬅተ የሱሳ ጋእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ሙሴ ህገ ፋና ኡን ጌዥዘ ዎደ ፎልንትዳንፓ ሱባ ዮሰፋራን ማይራምራ ዦጋ ናአ ፋ ላꬄስ እማደስ የሩሳላመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ይናን፥ ላꬄ ህገራ፥ «ꬊራꬅ ማቅደ አንግስ ናአ ኡቡንꬅ ላꬅስ ዱሙꬍዳያ ማቀ» ጋእንት ጻፍንትዳኖ ፎሎደስ። ");
INSERT INTO oyde_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ማህ ላꬄ ህገ፥ ላምእ ኮካ ዎይ ዎለ ዣርሾደስ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","የ ዎደ ጌሽን አማኖራ ምንꬂ ማቅደ ስሞና ጋእንትዘ አꬄ የሩሳላመ የነ። ኤ እስራኤሉንꬃና አሽዛ ናግተራ የነ። ጌሽ አያናን ኤላ አፋ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ማህ ክርስቶሳ ብእካይዛራ Ꮉይቃማኖ ጌሽ አያና ኤስ ቤዝን ኤሪ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ኤ የ ዎደ አያና ካልꬅን ጾዘ ኬꬃ ቅትዳ። ናአይ እንትራን አደራ ዎጋ ፎሎደስ ዦጋ ናአያ የሱሳ ኤኪ ገልደ ዎደ። ");
INSERT INTO oyde_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ስሞና ሞኪ ኤኪ ናአያ እርንግ፥ ያጋእ ጾዝ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ላꬆ ነ ታስ ገልደ ቃልት ፋና፥ Ꮉተ ነ አርዛ ሳሮራ ሞይዞ። ");
INSERT INTO oyde_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ታ ኣፍታ አስ ኡቡንꬅ ቲኖ ነ ጊግዝደ፥ ");
INSERT INTO oyde_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ነ አቶትꬅቶ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ይናን አይሁደ ማቆሰ ኡቡንꬅስ፥ ጾዘ ኦግቶ ጌሽዘ ፎኦ፥ ነ አሱንꬅ እስራኤሉንꬅስ ቦንቾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ዮሰፋራን ማይራምራ ኤ ባዝ ኦህንትዳነ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ስሞና ኡንታና አንጅዳ። እንታ ማይራምጎ፥ «ይኬ Ꮉይ ናአይ ጾዛፓ ዶርንትደ ጋማ እስራኤሉንꬅስ ኡን ጎልእትስን ኡን ደንድትስ ማላ ማቃዳ። ይኖን ጋሙንꬅ እጻነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ነ ሸምፕታን ማህ ማሻራ ጫድንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ማህ አሴረ ኮቻፓ ማቅደ ፋኑኤላ ናእታ ሐና ጋእንትዘ ናብታ የነ። እዛ ጋማ ጭንግዳ፤ እዛ አዝንዘራ ላፑን በረ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","እ አዝንዘ Ꮉይቂን ኦስፉን ታም ኦይዲ በረ ማቃደ ዎንꬅስ ቃማን አዋራ ፋጨ ባይꬅ ዎሳራን ጾማራ ጾዘ ኬꬃ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","እዛ ይና ሳተ Ꮉንግ ጾዝ ጋላትዳ፤ የሩሳላመ አቶትꬅ ዎደ ናግዘ ኡቡንꬅስ ዦጋ ናአይ ባዝ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ዮሰፋራን ማይራምራ ላꬄ ህግተ ኪትንትደ ዎግቶ ኡባኖ ፎልዳንፓ ሱባ ጋልላ ሳአ የዘ ፋ ካታማ ናዝረተ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ናአይ ድጭተራን ምንግተራ Ꮉንግዳ። ጭንጫትꬃራ ኩምዳ፤ ጾዘ አꬎ ከሃትꬅታ ኤላ አፋ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ዮሰፋራን ማይራምራ ፋስካ ባአለ ቦንቾደስ ኡባ በረ የሩሳላመ ቅታነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","የሱሳስ ታጶ ላምእ በረ ማቅደ ዎደ ቲኖፓ Ꮉንግዛኒ ፋና ባልቶ ቦንቾደስ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ባአለ ቦንችዳንፓ ሱባ ካራ ማቅዘ ዎደ ናአይ የሱሳ የሩሳላመ አትዳ። የዝን ዮሰፋራን ማይራምራ ኤ የሩሳላመ አትዳኖ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ኤ ካራ ማቅደ አሳራ የዘ ጋራ ይእን ኡን ፈቲ ቃማ ኦገ የꬍዳ። ኤ ባይዛኖ ኤርዳንፓ ሱባ ፋ እግኑንꬅ ካለን ላጉንꬅ ካለ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ኤ እዘ ꬋብን ኮይተራ ሱባ የሩሳላመ የሎደስ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ꮉይꬕ ቃማፓ ሱባ ጾዘ ኬꬃ አስታማሩንꬅ ግዳ በቲ ኡንባዝ ስእተን ኡንታና ኦጭተራ የዝን ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ኤዛ ስእዘ ኡቡንꬅ ኤ ቆፍተን ማህተ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ካራ አሱንꬅ ኤዛ ደንግደ ዎደ ጋማ ቆፕዳ። ኤ እንታን፥ «ታ ናአዮ፥ አኮስ ኑና Ꮉንጋራ ኦችዶ? ነ አደራን ታራን ነና ኮይተራ ዋይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","የሱሳ ኡንታጎ፥ «ታና አኮስ ኮየ? ታኒ፥ ታ አዳይ ኬꬃ የሳደስ ቤዛኖ ኤሮሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","የዝን ኤ ኡንታጎ ጋይዳኖ ኡን ቲሪካያ። ");
INSERT INTO oyde_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ይንፓ ሱባ፥ ኡንታራ ዎላ ናዝረተ ካታማ ይእዳ። ኡንትስ ኪትንቲ የዝዳ። ኤ እንታ ይና ኡባባዝቶ ዎዝንተ ጋዲ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","የሱሳ፥ ጭንጫትራ፥ ኡደ ድቻራን ሳባራ ጾዝ ቲኖን አስ ቲኖ ድጫነ። ");
INSERT INTO oyde_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ካት ጢባርዮሳ ሮመ ጋደ ካእትን፥ ታጶ እቻንꬆ በረ፥ ጰንጤ ጵላጦሳ ይሁዳ አህዘ ዎደ ሄሮድሳ ጋልላ አህዘ ዎደ ኤ እሸ ፍልጶሳ እጡርያሳን ጥራኮንዶሳ አህዘ ዎደ ልሳንዮሳ አብላንሳ አህዘ ዎደ ");
INSERT INTO oyde_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ሃናራን ቃያፋራ ካህኑንꬅ Ꮉላቃ ማቂ የዝን፥ ጾዘ ቃላ ዛካርያሳ ናአ ዋሐንሳጎ አኮ ባይዘ ጋናሳ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ዋሐንሳ፥ «ይን ናጋርትፓ ማቂ ጻማቅንቶተ። ጾዚ ይን ናጋርቶ አቶ ጋኦዳ» ያጋእ ታማርስተ ዮርዳኖሳ ቦርካ ጋጻራ የዘ ሳአ ኡባ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ይናን ናበ ኢሳያሳ ፋ ማጻፍተ፥ «አኮ ባይዘ ጋናሳ ግዳ ፋ ቃልቶ ꬎቅ ዪዝ፥ ኡክዘ አꬄ ቃልታ፥ ‹ላꬄ ኦግቶ ጊግዞተ፥ ዎሮግቶን ሉልዞተ። ");
INSERT INTO oyde_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ዶቺ ኡባ ኩሞዳ፥ ደረን ꬎቃ በስን ዝቅ ጋዉዳ። ዎቦ ኦግታ ሉሎዳ፥ ጊጎሰ ሆሮግታ ጊጎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","አስ ኮች ኡባ፥ ጾዘ አቶትꬅቶ በአዳ› » ጋእ ጻፍዳንፋና Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ዋሐንሳ፥ ፋ ኩሽተ ጻማቅንቶደስ ይእደ ጋማ አሱንꬃጎ፥ «Ꮉንꬅ፥ ሾሽ ናኡንꬆ ዮኦደስ የዘ Ꮉንቆፓ አቶደ ጋር ይንታና ዞርደ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ይኬ፥ ይን ማርንተስ ቤዘ ሎኦ ኦቻ ኦቾተ፥ ይን ዎዝንተ፥ ‹ኑስ፥ ኑ አዳይ አብራሃማ የነ ጋእ ጬቅንትፐተ።› Ꮉንካ ስኦተ፥ Ꮉንꬅ ሹቹንꬃፓ ጾዚ አብራሃማስ ናአ ኬሶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ꮉተ፥ ጋንደ ምንጻ ጻጶ የነ። ይኬ፥ ሎኦ ኣፈ አፎሰ ምንጻ ኡባ ጋችንቲ ታማ ኦልንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","አሱንꬅ፥ «ዬዝን ኑኒ አኮ ኦቾደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ዋሐንሳ ማህ፥ «ላምእ አፉላ የዘ አስ ባይዘስ ሻጎ። ካꬃ የዘ ባይዘስ ሻጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ቃራጠ ጋችዙንꬂ ጻማቅንቶደስ ይእ፥ «አስታማርዛዮ፥ ኑኒ አኮ ኦቾደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ኤ ማህ፥ «ይን ጋችሳደስ ቤዛንፓ አꬂ ኤክፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ማህ ዎታዳሩንꬅ ይእ፥ «ኑኒ አኮ ኦቾደ» ያጋእ ኦጭዳ። ዋሐንሳ፥ «ኦባዝን ዎልቃራ ዳፊ ኤክፐተ፥ ኦደን ዎርዶራ ሞትፐተ፥ ይን ዳሞዝታ ይንትስ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","አሱንꬅ ክርስቶሳ ኡፋይሳራ ናጊ የዘ ግሾ ዋሐንሳ፥ «ኤ ክርስቶሳ ማቃነ?» ያጋእ ፋ ዎዝንተ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ዋሐንሳ ኡቡንꬅስ ማህ፥ «ታኒ ይንታና Ꮉꬃራ ጻማቃነ፥ የዝን ታፓ አꬊ ሚንግዘ የኦዳ። ታኒ ኤ ጫማ ጋድቶ ብሎደስ ቤዞሰ አስ። ኤ ይንታና ጌሽ አያናራን ታማራ ጻማቆዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ኡዱማ የዘ ካꬃ ጌሾደስ ፍꬄ ኤ ኩሽተ የነ። ጌሽ ካꬃ ፋ ፋችተ ጉሶዳ፤ ቡርቶ ꬋቦሰ ታማር ምቾዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ማህ ዋሐንሳ አሱንꬃና ጋማ ዞሪ ዎንገለ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","የዝን ዋሐንሳ ሄሮድሳ ፋ እሸ ማችቶ፥ ሄሮድያዳ፥ ኤክደ ግሾን መለ ኢታ ኦችት ግሾ ካጭደ ዎደ ");
INSERT INTO oyde_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ሄሮድሳ ካሰንላ አፋ መለ ኢታ ባዝ ኡባ ጉጂ ዋሐንሳ ዎይነ ገልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ዋሐንሳ አጭንቶዳንፓ ቲኖ አስ ኡባ ጻማቂ ማቅን፥ የሱሳን ማህ ጻማቅንትዳ። ኤ ዎሶደራ ሳሎ ቡጉንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ጌሽ አያና ዎለ ፋና በንትተራ ኤላ አፋ በትዳ። ሳሎፓ «ታ ካዽዘ ናአይ ነና፤ ነ ታና ኡፋይሳነ ያጋእዘ» ቃላ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","የሱሳ ታማርሰ አይክዘ ዎደ ኤስ Ꮉስታም በረ ማቃደራ፥ አሱንꬅ ኤዛ ዮሰፋ ናአ ጋእ ቆፕዳ። ዮሰፋ ኤለ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ኤለ ማተ ናአ፥ ማተ ሌወ ናአ፥ ሌወ ማልካ ናአ፥ ማልካ ዮና ናአ፥ ዮና ዮሰፋ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ዮሰፋ ማታተ ናአ፥ ማታተ አሞጸ ናአ፥ አሞጸ ናሆመ ናአ፥ ናሆመ አስሊመ ናአ፥ አስሊመ ናገ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ናገ ማአተ ናአ፥ ማአተ ማታትየ ናአ፥ ማታትየ ሳማየ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ሳማየ ዮሰፋ ናአ ዮሰፋ ይሁዳ ናአ፥ ይሁዳ ዮናነ ናአ፥ ዮናነ ራሰ ናአ፥ ራሰ ዘሩባበላ ናአ፥ ዘሩባበላ ሳላትያለ ናአ፥ ሳላትያለ ኔረ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ኔረ ሚልኪ ናአ፥ ሚልኪ ሃደ ናአ፥ ሃደ ቆሳመ ናአ፥ ቆሳመ ኤልሞዳነ ናአ፥ ኤልሞዳነ ኤራ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ኤራ ዮሰኤ ናአ፥ ዮሰኤ አላዛረ ናአ፥ አላዛረ ዮራመ ናአ፥ ዮራመ ማተ ናአ፥ ማተ ሌወ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ሌወ ስሞና ናአ፥ ስሞና ይሁዳ ናአ፥ ይሁዳ ዮሰፋ ናአ፥ ዮሰፋ ዮናነ ናአ፥ ዮናነ ኤልያቀመ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ኤልያቀመ ማልየ ናአ፥ ማልየ ማይናነ ናአ፥ ማይናነ ማተ ናአ፥ ማተ ናታነ ናአ፥ ናታነ ዳዉተ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ዳዉተ እሰይ ናአ፥ እሰይ እዮቤደ ናአ፥ እዮቤደ ቦኤዛ ናአ፥ ቦኤዛ ሳልሞና ናአ፥ ሳልሞና ናአሶና ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ናአሶና አምናዳበ ናአ፥ አምናዳበ ራመ ናአ፥ ራመ አርነ ናአ፥ አርነ አስሮመ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","አስሮመ ፋረሰ ናአ፥ ፋረሰ ይሁዳ ናአ፥ ይሁዳ ያይቆባ ናአ፥ ያይቆባ ይሳቃ ናአ፥ ይሳቃ አብራሃማ ናአ፥ አብራሃማ ታራ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ታራ ናኮረ ናአ፥ ናኮረ ሳሩገ ናአ፥ ሳሩገ ረሁ ናአ፥ ረሁ ፋለቀ ናአ፥ ፋለቀ ኤቤራ ናአ፥ ኤቤራ ሴላ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ሴላ ቃይናነ ናአ፥ ቃይናነ አርፋክሳዳ ናአ፥ አርፋክሳዳ ሴመ ናአ፥ ሴመ ኖሄ ናአ፥ ኖሄ ላመሄ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ላመሄ ማቱሳላ ናአ፥ ማቱሳላ ሄኖኬ ናአ፥ ሄኖኬ ያረደ ናአ፥ ያረደ ማላልኤላ ናአ፥ ማላልኤላ ቃይናነ ናአ፥ ");
INSERT INTO oyde_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ቃይናነ ሄኖሳ ናአ፥ ሄኖሳ ሴታ ናአ፥ ሴተ አዳማ ናአ፥ አዳማ ጾዝ ናአ። ");
INSERT INTO oyde_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","የሱሳ ጌሽ አያናራ ኩሚ ዮርዳኖሳ ቦርካፓ ማቅደ ፋና አያና ኤዛ አኮ ባይዘ ጋናሳ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","እዘ ኦይታም አዋራን ቃማ ጻላሄራ ፋታንንትዳ። የ ዎድተ አኮን ሙእካይዛራ ጋምእደ ግሾ ዉርሱꬅተ ናይꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ጻላሄ ኤጎ፥ «ኔኒ ጾዘ ናአ ማቅኮ አነ Ꮉይ ሹችዛ ዳቦ ማቆ ጋእ ኪቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","የሱሳ ማህ፥ «አስ ዳቦ ጻላላራ የዞስ ጋእንት ጾዘ ቃልተ ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ይንፓ ሱባ፥ ጻላሄ የሱሳ ጳርጎ ደረላ አፋ ኬሲ Ꮉና አላምት ካእቱምቶ ኣፈ ቅጲ ማቃደስ ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ጻላሄ፥ «Ꮉና ኡባንስ አደትꬅ ዎልቃ ቦንቾን ታስ እንግንትዳ። ታኒ ካዽዘ ኦደስን እንግዘ ግሾ ኔስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ይኒ ግሾ፥ ነ ታስ ጎይንዛኮ ኡባ ኔስ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","የሱሳ ማህ፥ «ነ ላꬃ፥ ነ ጾዛ፥ ኤዛ ጻላላ ጎይኖን ኤስ ኦቾ ጋእንት ጾዘ ቃልተ ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ዉርሱꬅተ ጻላሄ የሱሳ የሩሳላመ ካንግ ጾዘ ኬꬅትስ ኩስተላ አፋ ኤስ፥ ኔኒ ጾዘ ናአ ማቅኮ አነ ሱለ ሳአ ነና ኦሎ። ");
INSERT INTO oyde_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","አኮስ ጋይኮ፥ « ‹ነና ናግዘ ፋ ኪታንቾ ነ ግሾ ኪቶዳ ጋእንት ጾዘ ቃልተ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ኡን ነ ቶህታ ሹቻላ ꬉቡንታመ ጋር፥ ፋ ኩሽተ ꬎቅ ዪዚ ነና ደንꬆዳ› ጋእንት ጾዘ ቃልተ ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","የሱሳ ማህ፥ «ነ ላꬃ ጾዛ ፋታንፐ ጋእንት ጾዘ ቃልተ ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ጻላሄ የሱሳ ፋታንቶ ኡባ Ꮉስዳንፓ ሱባ መለ ዎትዘ ዎደ ደንጎደ ዎንꬅስ ኤፓ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","የሱሳ ጌሽ አያና ዎልቃራ ኩሚ ጋልላ ማቅዳ። ኤ ሱንꬅታ ካለ የዘ ሳአ ኡባ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ኤ አይሁደ ዎሳ ኬꬃ ገሊ ታማርስዳ፤ አሱንꬅ ኡቡንꬅ ኤዛ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","እዝፓ ኤ ድጭደ ካታማ ናዝረተ ይእዳ። ቲኖ ኦችዛን ፋና ሳምባታ ዎደ አይሁደ ዎሳ ኬꬃ ገልዳ። ናባቦደስን ደንዲ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ናበ ኢሳያሳ ማጻፍዘ ጻጽንትዳያ ኤስ እንግን፥ ቡጊ፥ Ꮉንጋራ ያጋእ ጻፍንትዳኖ ደንግዳ፦ ");
INSERT INTO oyde_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ላꬄ አያና ታላ አፋ የነ፥ ዳሁንꬅስ ዎንገለ ኦሆደ ፋና ጾዚ ታና ዶርዳ። አጭንትዱንꬅስ ብልንተ፥ ቆቅዱንꬅስ በኤ ኡንእንትዱንꬃና ዋሎ ኬሶደስ፥ ");
INSERT INTO oyde_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ጾዚ አሾደስ ቆፕደ በርቶ ኦሆደ ፋና ታና ኪትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ይንፓ ሱባ፥ ማጻፍዛ ጻጺ አይሁደ ዎሳ ኬꬃ እንግዳ። አይሁደ ዎሳ ኬꬃ የዘ አሱንꬅ ኡባ ዳኪ በእነ። ");
INSERT INTO oyde_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ኤ፥ «Ꮉይቼ ይን Ꮉይትራ ይን ስእዘ Ꮉና ማጻፈ ቃልታ Ꮉይኖ ፎልንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ኡቡንꬅ ኤ ባዝ ሎኦ ባዝ ኦህንታነ። ማህ ኤ ዶንትፓ ከዘ አꬎ ኬሃትꬅ ኩምደ ቃላትፓ ደንድ ጋማ ቆፒ፥ «Ꮉይ ዮሰፋ ናአ ባነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ኤ፥ « ‹አክምዛዮ አነ ነና አሾ፥ ቅፍርናሆመ ግዳ ነ ኦችዳኖ ኑ ስእዳኖ ማህ Ꮉነ ነ ካታምተ ኦቾ› ያጋእዘ አዝዘራ ይን ታና ጋውዳንስ ሶኤ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ማህ፥ «ቱሮ ኦህነ፤ ናበ ፋ የልንትደ ጋድተ ቦንችንቶስ። ");
INSERT INTO oyde_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«ታ ይንትስ ቱሮ ኦህነ፤ ሳሎ Ꮉይꬕ በረን ባገ ጎርድንትን ምንꬅ ናየ ሳአላ ኡባ የዘ ኤልያሳ ዎደ ጋማ ቡዳኑንꬅ እስራኤለ ግዳ የነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ኤልያሳ ኡንታፓ ፈትጎን ኪትንትካያ። የዝን ሳራፕታ ግዳ የዘ ፈቲ ቡዳንትጎ ኪትንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ናበ ኤልሳኤ ዎደ እስራኤለ ግዳ ጋማ ቁርሱማራ Ꮉርግንትዙንꬅ የነ የሻ። የዝን ሶርያ አꬄ ንእማነፕ አትን ኦደን ፋጽካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","አይሁደ ዎሳ ኬꬃ የዘ አስ ኡቡንꬅ ይኖ ስኤዘ ዎደ ጋማ ዥልꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ፋ በትደ በስትፓ ደንዲ ደረላ አፋ ኬጽንትደ ካታምትፓ ጋጻ ኬሲ ኡርቂ ዳኮደስ ጋጋ ዶና ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","የዝን ኤ ኡን ግዳራ ካንꬂ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","እዝፓ ጋልላ ሳአ የዘ ቅፍርናሆመ ካታማ ቅትዳ። እዘ ሳምባታ ዎደ አሱንꬃና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ኤ ታማርስዛና አደትꬅ ዎልቃራ ማቅደ ግሾ ኡቡንꬅ ኤ ትምርትተ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","አይሁደ ዎሳ ኬꬃ ቱና አያና አይክደ አꬄ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ኤ፥ «ናዝረተ የሱሳ ኑና አኮስ ዋይ ኑፓ Ꮉኮ፤ ነ ይእዳና ኑና ꬋብሶደስነ? ነ ኦና የዛኮ ታ ኤራነ። ኔኒ ጾዘፓ ይእደ ጌሽ» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","የሱሳ ቱና አያንዘጎ፥ «ስእ ጋእ Ꮉይ አꬄፓ ከዞ» ያጋእ ካጭዳ። ቱና አያንዘ አꬃ አስ ኡቡንꬅ ቲኖ ኦሊ አሺ አኮን ቆህካይዛራ ዳኪ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","አሱንꬅ ኡባ ጋማ ቆፕዳ። ዎልጎ፥ «ዬዝን፥ Ꮉና አኮ ትምርተ? ቱና አያኑንꬃና አደትꬅ ዎልቃራ ኪታነ፤ ኡንትን ከዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ኤ ሱንꬅታ ካራ ጋንጨ ኡባ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ይንፓ ሱባ፥ የሱሳ አይሁደ ዎሳ ኬꬃፓ ኬዚ ስሞና ኬꬃ ገልዳ። ስሞና ማችት እንታ ምንꬂ ኦማ ኦꬅን ምቻ Ꮉርግንትዳ። እዞ ፋꬆደ ጋር የሱሳ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","እ ይꬅትጎ ሺቂ ዙጊ እ Ꮉርግዛ ሴርዳ። ምችታ አሽን ኤልሲ ደንዲ ኡንታና ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","አዋ ገሎደስ ይአደራ ዱማ ዱማ Ꮉርገራ አይክንትደ አሱንꬃና ኤጎ ክእዳ። ኤ ፈተላ ፈተላ አፋ ፋ ኩሽቶ ጋዲ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ቱና አያኑንꬅ ማህ፥ «ኔኒ፥ ጾዘ ናአ» ጋእ ዉይስተራ ጋማ አሳፓ ከዝዳ። የዝን ኤ ኡንታና ካጭዳ። ኤ ክርስቶሳ ማቅዳኖ ኡን ኤርዘ ግሾ ፈቲ ባዝን ኦሃመ ፋና ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ꮉጋ ዎንትዘ ዎደ የሱሳ ፈቲ አስ ባይዘ በሳ ቅትዳ። አሱንꬅ ኮይተራ ኤ የዘ በስተ ይእዳ። ኡንታፓ ኤ ሻክንት ቅታመ ጋር ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","የዝን ኤ፥ «ታኒ መለ ካታማ Ꮉንግ ጾዘ ካእቱሞ ዎንገለ ማርክꬋደስ ቤዛነ። ታ ኪትንትዳና ይንስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ይሁዳ ሳአ የዘ አይሁደ ዎሳ ኬꬃ ሳባክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ፈቲ ዎደ የሱሳ ጌንሳሬጠ አባ ካለ ኤቀዝን ጋማ አሱንꬅ ኤ ካንቶ ዉቲ ኤዛ ኡንእꬅ፥ ኤ ታማርስዘ ጾዘ ቃልቶ ስእነ። ");
INSERT INTO oyde_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","እዘ Ꮉꬅ ጋጻ የዘ ላምእ ጎንጉንꬃና ብእዳ። ሞሎ አይክዘ አሱንꬅ ጎንጉንꬃፓ ዎꬊ ፋ ሞሎ አይክዘ ግትቶ ሜጫነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","የንꬅ ጎንጉንꬃፓ ስሞናሰ ግዳ ገሊ ሳአፓ ኤራꬅ ግዳ ሺሾደ ፋና ኦጭዳ። የይዝ፥ የ ጎንግዘላ አፋ በቲ አሱንꬃና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ፋ ታማርስዛኖ Ꮉስዳንፓ ሱባ ስሞናጎ፥ «ጎደ ጌንትጎ ሺሺ ሞሎ አይኮደስ ይን ግትዛ ኦሎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ስሞና ማህ፥ «አስታማርዛዮ፥ ቃማ ኩሙꬅ ላቢ አቂ አኮን አይክካያ፥ የዝን ነ ጋይኮ ግትዛ ኦሎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ኡን ግትዛ ኦልደ ዎደ ግትዘ ፈꬍንቶደ ዎንꬅስ ጋማ ሞሎ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","መለ ጎንገ የዘ ፋ ላጉንꬅ ይእ፥ ፋና ማዶደ ጋር ዉቲ ጼግዳ። ኡን ይእ ላምእ ጎንግታ፥ Ꮉꬅተ ቆꬍንቶደ ዎንꬅስ ሞሎራ ኩንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ስሞን ጴጥሮሳ ይኖ በኤዘ ዎደ የሱሳ ቲንተ ቡንቁንቲ፥ «ላꬆ፥ ታኒ ናጋራር የዘ አስ ማቅደ ግሾ ታፓ Ꮉኮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ይኖ ኤ ጋእዳና ኤዝን ኤራ የዙንꬅ አይክደ ሞሎ ጋማትꬅተ ጋማ ቆፕደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ማህ ስሞና ዣመ ማቅደ ዛብዶሳ ናኡንꬅ ያይቆባራን ዋሐንሳራን ጋማ ቆፕዳ። የሱሳ ስሞናጎ፥ «ዣሽትፐ! ይኬፓ ኔኒ አስ አይክዘ አስ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ኡን ጎንግቶ ጋጻ ሺሽዳንፓ ሱባ ኡባኖ አሺ የሱሳ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","የሱሳ ካታሙንꬃፓ ፈተ ግዳ የዝን ፈቲ ቁርሱማ Ꮉርገራ አይክንትደ አስ ይና ካታምተ የነ። የ አꬃይ የሱሳ ብእ ኤ ቲንተ ቡንቁንቲ፥ «ላꬆ፥ ነ ቆፋ ማቅኮ ታና ጌሾደስ ዳንዳአነ» ጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","የሱሳ ፋ ኩሽቶ ዳኪ ቦቺ፥ «ዬ፥ ታ ቆፋ፤ ጌዦ» ያጋይዳ። እዝራ ቁርሱማ Ꮉርግዘ አꬃ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","የሱሳ፥ «Ꮉኖ ኦደስን ኦህፐ፥ የዝን Ꮉንግ ነ ጋልቶ ካህንዘ ቤዞ። ነ ጌዥዳንስ ማርካ ማቃደ ፋና ሙሴ ኪትደ ዣርሽቶ ዣርሾ» ጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ማቆ የዝን፥ የሱሳ ሱንꬅታ ካሰንፓ አꬊ ዳልግተራ Ꮉንግዳ። ጋማ አሱንꬅ ኤ ኦህዛኖ ስኦደስን ፋ Ꮉርግትፓ ፋጾደስ የእነ። ");
INSERT INTO oyde_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","የዝን ኤ ጋማ ዎደ ጌማ በሳ ቅቲ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ፈቲ ዎደ የሱሳ ታማርሶደራ ጋልላፓን ይሁዳ ካራ ጋንጨ ኡባፓ ማህ የሩሳላመፓን የኤዘ ፋርሳዉንꬅን ህገ አስታማሩንꬅ እዘ በትዳ። አስ ፋꬅዘ ላꬄ ዎልቅታን ኤራ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","የ ዎደ አሱንꬅ ፈቲ ዎቦ አꬃ አልጋራ ቶኪ ክእዳ። ኬꬃ ገልꬂ ኤ ቲንተ ጋዶደስ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","የዝን አስ ጋማፓ ደንዲ ኬꬃ ገልꬆደስ ጋምን ኬꬃላ አፋ ኬዚ፥ ኬꬂ ኣፍቶ ቶኪ፥ Ꮉርግንትዛ አልግዘራ የሱሳ ቲኖ ኬꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","የሱሳ ኡን አማንቶ ብእ፥ «ናተ አꬃዮ፥ ነ ናጋርታ ኡጭንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ህገ አስታማሩንꬅን ፋርሳዉንꬅ፥ «Ꮉይ ጾዘላ አፋ ያጋእ ኦህዘ ኦደ? ፈቲ ጾዘፕ አትን መለ ናጋራ ኡጮደስ ዳንዳእዘ ኦደ?» ያጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","የሱሳ ኡን ቆፍቶ ኤርደ ግሾ ኡንታጎ፥ «ይን ዎዝንተ Ꮉኒ ጋር አኮስ ቆፐተ? ");
INSERT INTO oyde_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹ነ ናጋርታ ኡጭንትዳ ጋእዛንፓን ደንዲ ቅቶ ጋእዛንፓ አየ ፎለ?› ");
INSERT INTO oyde_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","የዝን ታ ይኖ ጋይዳና አስ ናአይ ሳአላ አፋ ናጋራ ኡጮደስ አደትꬅ ዎልቃ የዛኖ ይን ኤሮደ ጋራ።» ይንፓ ካሊ፥ ዎቦ አꬃ፥ «ደንዶ፤ ነ አልግዛ ቶኪ ነ ካራ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ኤ ኢራ ደንዲ ኡን ቲንተ ኤቅዳ፤ ኤ ቶክንት ይእደ አልግዛ ቶኪ ጾዝ ጋላትተራ ፋ ካራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","የ ዎደ ኡቡንꬅ ጋማ ቆፕዳ። ጾዝ ጋላትተራ፥ «Ꮉይኖ ዳማ ክለ ባዝ ብእዳ» ያጋእ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ይንፓ ሱባ፥ የሱሳ የይጋፓ ኬዚ ቅትዳ። ሌወ ጋእንትዘ ፈቲ ቃራጠ ጋችዛይ ቃራጠ ጋችዘ በስተ በትዳያ ብእ፥ «ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ኤ ኡባ ባዝ አሺ ደንዲ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","የ ሌዊዘ ፋ ካራ ዳማ ድግሳ ጊግዝዳ። ጋማ ጊራ ጋችዙንꬅን መለ አሱንꬅ ካꬃ ማአደስ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፋርሳዉንꬅን ህገ አስታማሩንꬅ፥ «ጊራ ጋችዙንꬃራን ናጋራንቹንꬃራ አኮስ መኤ ኡዠ?» ያጋእ የሱሳ ታማሩንꬃላ አፋ ዙዝንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","የሱሳ ኡንታጎ፥ «Ꮉርግንትዙንꬅስ ፋትን ፋጻስ አክመ ኮሾስ። ");
INSERT INTO oyde_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ታኒ ናጋራንቹንꬃና ማሮትꬃጎ ማሆደስ ፋትን ጌሹንꬃና ጼጎደስ ይእካያ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ኡን የሱሳጎ፥ «ዋሐንሳ ታማሩንꬅ ጋማ ዎደ ጾማነ፥ ዎሳነ፤ ማህ ፋርሳዉንꬅ ታማሩንꬅን ይኒ ጋራ ዪዛነ። የዝን ኔሱንꬅ ኡባ ዎደ ሙነ ኡዣነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","የሱሳ ኡንታጎ፥ «ሙሹራ ኡንታራ የዝን ጼግንትደ አሱንꬅ ጾሞደ ጋር ይሳደስ ዳንዳአነተ? ");
INSERT INTO oyde_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","የዝን ሙሹርዘ ኡንታፓ ሻክንቶደ ዎደ የኦዳ፥ የ ዎደ ኡን ጾሞዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ማህ ያጋእ አዝዘ ኦህዳ፤ «ክለ ማኦፓ ፌꬊ ጋልአ ማኦላ አፋ ስክዘ ኦደን ባያ። ይኒ ፋና የይዝኮ ክለ ማእዛ ፌꬋነ፥ ክልዘ ጋልእዘስ ጊጎስ። ");
INSERT INTO oyde_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ማልአንቶ ዎይነ ጭማ ስልጰ ጉጅዘ ኦደን ባያ። ይኖ የይዝኮ፥ ማልአንቶ ዎይንዘ ጭማ ስልጵዛ ꬉሳነ፤ ዎይንታን ላንታነ ስልጵዘን ማዶሰ ባዝ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ይኒ ግሾ፥ ማልአንቶ ዎይነ ክለ ስልጰ ጉጁንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ይኬ፥ ጫልዘ ሎኦ ጋዘ ግሾ ጫላ ዎይነ ኡዢ ማቂ ጫልካይዛ ማልአንቶ ኮይዘ ኦደን ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ፈቲ ሳምባታ ዎደ የሱሳ ዛርጋ ጋደ ግዳራ አꬋነ። የሱሳ ታማሩንꬅ ትዣ ዛርጋ ዱꬂ ፋ ኩሽተ ሽጪ ꬋአነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","የዝን ፋርሳዉንꬅ ግዳፓ ፈተ ፈተ፥ «ሳምባታ ዎደ ህገስ ቤዞሰ ባዝ አኮስ ኦቼ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","የሱሳ ኡንታጎ ማህ፥ «ዳዉተ ናይꬍደ ዎደ ፋራ የዙንꬃራ ዎላ ኦችዳኖ ናባብካ? ");
INSERT INTO oyde_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ጾዘ ኬꬃ ገሊ አይሁደ ካህኑንꬅ ጻላላስን ጾዝስ ቤዝዘ ዳቡቶ ሙእዳ፤ ፋራ የዙንꬅስን እንግዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ማህ የሱሳ፥ «አስ ናአይ ሳምባታ ላꬂ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","መለ ሳምባታ ቃማ የሱሳ አይሁደ ዎሳ ኬꬃ ገሊ ታማርስዳ። ይና በስተ ምዛቅ ኩሸ ጉንድደ ፈቲ አስ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ህገ አስታማሩንꬅን ፋርሳዉንꬅን ኤዛ ሞቶደስ ኦገ ኮይ ሳምባታ ዎደ ፋꬅኮ በአዳ ጋእ ካፋነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","የዝን የሱሳ ኡን ቆፍቶ ኤሪ ኩሸ ጉንድደ አꬄጎ፥ «ደንዲ አሱንꬅ ግዳ ኤቆ» ያጋይዳ። አꬃይን ደንዲ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","የሱሳ፥ «አነ ታ ይንታና ፈትባዝ ኦጫነ፤ ሳምባታ ቃማ ህግተ ኦቾደስ ቤዝዛና ሎኦ ባዞነ ኢታ ባዞ? ሸምፖ አሸነ ዎይ ꬋብሰ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ማህ የሱሳ ኤ ካለ ዉቲ የዘ አሱንꬃና ኡባ ዉቱꬂ ብእ አꬄጎ፥ «ነ ኩሽቶ ፍዲ ዪዞ» ያጋይዳ። አꬃይን ኤ ጋእዳን ጋራ የይዝን ኩሽዘ ፋጽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","የዝን ህገ አስታማሩንꬅን ፋርሳዉንꬅን ጋማ ዥልꬍዳ። የሱሳላ አፋ አኮ ኦቾ ጋእ ፋ ግዳ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","የ ዎደ ይና ቃምትፓ ፈተ ግዳ የሱሳ ዎሶደስ ደረላ አፋ ከዝዳ። ቃማ ኩሙꬅ ጾዝ ዎስተራ አቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ዎንትስቶ ፋ ታማሩንꬃና ጼጊ ኡን ግዳፓ ታጶ ላምኡንꬃና ዶሪ፥ ኡንታና፥ «ሐዋሩንꬃና» ጋእ ሱንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ኡንትን፥ ጴጥሮሳ ጋእ ሱንꬅደ ስሞና፥ ኤ እሸ እንድራሰ፥ ያይቆባ፥ ዋሐንሳ፥ ፍልጶሳ፥ ባርቶሎምዮሳ፥ ");
INSERT INTO oyde_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማቶሳ፥ ቶማሳ፥ እልፍዮሳ ናአ ያይቆባ፥ ፋ ጋድትስ ቃናእዘ ስሞና፥ ");
INSERT INTO oyde_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ያይቆባ ናአ ይሁዳን የሱሳ አꬂ እንግደ አስቆሮቱ ይሁዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","የሱሳ ሐዋሩንꬃራ ዎላ ደርዘፓ ዎꬊ ጋናስ በሳ ኤቅዳ። ኤ ታማሩንꬃፓ ጋሙንꬅ ይና በስተ የነ ይሁዳ ሳአ ኡባፓ የሩሳላመፓ፥ ጢሮሳፓን ስዶና አባ ጋጻፓ ይእደ ጋማ አሱንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ኡን ይእዳና ኤ ታማርስዘባዝ ስኦደስን ፋ Ꮉርግትፓ ፋጾደስ። ቱና አያናራ ዋይንትዘ አሱንꬅን ፋጽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ዎልቃ ኤፓ ኬዚ አሱንꬃና ኡባ ፋꬅዘ ግሾ አሱንꬅ ኤዛ ቦቾደስ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ፋ ታማሩንꬃጎ ብእ Ꮉንጋራ ያጋይዳ፦ «Ꮉንሶ፥ ዳሁንꬆ፥ ይን አንጅንትዱንꬃና፤ ጾዘ ካእቱሞ ይንትስ። ");
INSERT INTO oyde_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ይን Ꮉተ ናይꬍዙንꬅ አንጅንትዱንꬃና፥ ይን ምሻዳ። ይን Ꮉተ ዬክዙንꬅ አንጅንትዱንꬃና ይን ሚጮዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","አስ ይንታና ታ ግሾ እጽዘ ዎደ ይንታና ሻክዘ ዎደ ይንታና ኡን ቶችዘ ዎደ፥ ኢታ ሱንꬅ ኡን ይንትስ እንግዘ ዎደ ይን አንጅንትዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«ይኬ፥ ይን አንጅታ ሳሎ ዳማ ማቅደ ግሾ የ ዎደ ኡፋይሳራ ዶሎተ። አኮስ ጋይኮ፥ ዛጋ ኡን አዱንꬅ ናቡንꬃላ አፋ ይኒ ጋር ኦችዳ» ");
INSERT INTO oyde_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«የዝን ዱረ አሱንꬆ ይንታና ባደ፤ ይን Ꮉተ ሎኦ የስቶ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ꮉተ ምዥዱንꬆ ይንታና ባደ፤ ይን ናይꬎዳ። Ꮉተ ሚጭዙንꬆ ይንታና ባደ ይን አዛኖዳ ዬኮዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","አስ ኡቡንꬅ ይን ሎኦትꬅቶ ጻላላ ኦህዘ ዎደ ይንታና ባደ። ኡን አዱንꬅ ዛጋ ዎርዶ ናቡንꬃላ አፋ ይኒ ጋር ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«የዝን ታና ስእዘ ይንትስ ታ ኦህነ፤ ይን ሞርኩንꬃና ካꬎተ፤ ይንታና እጽዙንꬅስ ሎኦ ባዝ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ይንታና ባድዙንꬃና አንጆተ፥ ይንታና ቆህዙንꬅስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ፈቲ ዛላ ꬎኦክዛ ባቂኮ Ꮉንኮ ዛልዛ ቤዞ። ነ ኮትዛ ኤኮዳ ጋዘስ ነ ሻምዛያን ጉጂ እንጎ። ");
INSERT INTO oyde_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ነና ዎስዘ ኡቡንꬅስ እንጎ፤ ኔፓ ኤክዛ ኦደን ማሆ ጋእ ኦጭፐ። ");
INSERT INTO oyde_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","አሱንꬅ ይንትስ ኦቾደ ጋር ይን ኮይዛን ፋና ይንትን አሱንꬅስ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«ይን ይንታና ካዽዘ አሱንꬃና ጻላላ ካꬍኮ፥ አኮ ጋላታ ይንትስ የዘ? መለ አቶ የዝን፥ ናጋራንቹንꬅን ፋና ካዽዙንꬃና ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ይንትስ ሎኦ ባዝ ኦችዙንꬅስ ጻላላ ሎኦ ባዝ ኦችኮ ይንትስ አኮ ጋላታ የዘ? ናጋራንቹንꬅን ይኒ ጋራ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ታልኤ ማሆደ አሱንꬅስ ጻላላ ይን ታልእኮ አኮ ዱማ ጋላታ የዘ? ናጋራንቹንꬅን ሱብ ማሆደ አስ ብእ ታልአነ።» ");
INSERT INTO oyde_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«የዝን ይን ሞርኩንꬃና ካꬎተ፤ ኡንትስ ሎኦ ባዝ ኦቾተ። ሱባ ኤኮደስ ቆፕካይዛራ ታልኦተ። ይነ ይን ኤኮደ አንጅታ ዳማ ማቃዳ። ይን ኡባፓ ካታራ የዘ ጾዘ ናኡንꬃና ማቃዳ። ኤ ፋና ጋላቶሱንꬅስን ኢቱንꬅስን ዳልጋ። ");
INSERT INTO oyde_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ይን ሳሎ አዳይ ማርዛ ማቅዳን ጋራ ይንትን ማርዙንꬃና ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«አሳላ ፍርድፐተ፤ ይንታላ አፋ ፍርድንቶስ። ይን ቦርንታመ ፋና ኦናን ቦርፐተ። አቶ ጋኦተ፤ ጾዚ ይንትስ አቶ ጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","እንጎተ፤ ይንትስ እንግንቶዳ። ይን ማክዳነ ይንትስ ማህ ማክንቶዳ፥ ሎኦ ማክዘ ባዝተ ባቂ፥ ኩሙꬅ፥ ላንቶደ ዎንꬅስ ይንትስ ማክንቲ እንግንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ማህን የሱሳ ያጋእ ኡንትስ አዝዘ ኦህዳ፤ «ቆቅዘ ቆቀ ካልꬆደስ ዳንዳአነ? ካልꬅኮ ላምኡንꬅ ዎል ኤኪ ጋጋ ቅቶሳነ? ");
INSERT INTO oyde_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ታማረ አስታማረፓ አꬎኦስ። ዪኮን ሎይꬂ ታማርደ አꬄ ፋ አስታማርዘ ፋና ይአነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«ነ እሸ ኣፍተ የዘ ቡርዛ አኮስ በኤ? ነ ኣፍተ የዘ ቱስ ፋና የዛ አኮስ ቦኦሳ? ");
INSERT INTO oyde_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ነ ኣፍተ የዘ ቱስ ፋና የዛ ብእካይዛራ ነ እሸጎ፥ ‹ታ እሻዮ ነ ኣፍተ የዘ ቡርዛ ኬሶ› ጋኦደስ ዋይዝ ዳንዳኤ? Ꮉይ ጩቡዛዮ፥ ቲንꬊ ነ ኣፍተ የዘ ቱስ ፋና የዛ ኬሶ። ይንፓ ሱባ፥ ነ እሸ ኣፍተ የዘ ቡርዛ ኬሶደስ ጌሽ በአዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«ሎኦ ምንጻ ኢታ ኣፈ አፎስ፤ ይኒ ጋራ ኢታ ምንጻ ሎኦ ኣፈ አፎስ። ");
INSERT INTO oyde_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ኣፈ ኣፍዘ ምንጻ ኡባና ፋ ኣፍተ ኤርንታነ። አንጋꬃፓ በለሰ ምንጻ ኣፈ ማጽንቶስ ማህ Ꮉልሞፓ ዎይነ ኣፈ ማጽንቶስ። ");
INSERT INTO oyde_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ሎኦ አስ ፋ ዎዝንተ ኩምደ ሎኦ ባዝትፓ ሎኦ ባዝ ከሳነ። ኢታ አስ ፋ ዎዝንተ ኩምደ ኢታ ባዝትፓ ኢታ ባዝ ከሳነ። አስ ፋ ዎዝንተ ኩሚ ትርፍደ ባዛፓ ፋ ዶናራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«ታ ጋዛኖ ይን ኦቾስ፥ የዛራ ዬዝን አኮስ ታና፥ ‹ላꬆ፥ ላꬆ፥ ጋኤተ?› ");
INSERT INTO oyde_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ታጎ የእዘን ታ ቃልቶ ስእ ፎልዘ ኡቡንꬅ ኦና አዝዛኮ ታ ይንታና ቤሳዳ። ");
INSERT INTO oyde_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ኤ ኬꬂ ኬጾደስ ዝቂ ዪዚ፥ ኦላ ቦክደ፥ ኦሞራ የዘ ላላላ አፋ ኬꬂ ኤስደ ጭንጫ አꬃ አዛነ። Ꮉሮ ጎጊ የ ኬꬃ ኡርቂዳ፥ የዝን ምንꬂ ኬጽደ ግሾ ኤንእሳደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","የዝን ታ ቃልቶ ስእ ኦቾሰ ፋ ኬꬅቶ ሻፈላ አፋ ባስካይዛራ ኬጽደ አꬃ አዛነ። Ꮉሮ ጎጊ የ ኬꬃ ኡርቂደ ዎደ ኤልሲ ጎልእዳ። የ ኬꬅዘ ዳማ ጎልኤ ጎልእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","የሱሳ ይኖ ኡባ አሱንꬅ ቲኖ ታማርስ Ꮉስዳንፓ ሱባ፥ ቅፍርናሆመ ካታማ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ይና በስተ ፈቲ ሮመ ማቶ Ꮉላቃ የነ። ኤ ጋማ ካዽዘ አርዘ Ꮉርግንቲ Ꮉይቆስ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ኤ የሱሳ ባዝ ስእደ ዎደ ፋ አርዛ ፋꬆደ ፋና ኤዛ ዎሶ ጋእ ፈቲ ፈቲ አይሁደ ጭሙንꬃና የሱሳጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ኪትንትዱንꬅ፥ የሱሳጎ Ꮉንግ፥ «ነ ኤስ Ꮉኖ ኦቾደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","አኮስ ጋይኮ፥ Ꮉይ አꬃይ ኑ አሱንꬃና ካꬋነ፥ አይሁደ ዎሳ ኬꬅን ኬጽዳ» ያጋእ ምንꬂ ዎስዳ ");
INSERT INTO oyde_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","የሱሳን ኡንታራ Ꮉንግዳ። ማቶ Ꮉላቅዘ ካራጎ ኡክደ ዎደ ፋ ላጉንꬃና ኤጎ ኪቲ፥ «ላꬆ፥ ታ ኬꬃ ነ ገሎደስ ቤዞሰ ግሾ ላቢፐ። ");
INSERT INTO oyde_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ታንን ታና ነ ቲንተ ሺቆደስ ቤዘ አስ ጋእ ቆፖስ። የዝን ነ ፈቲ ቃላ ኦሆ፤ ታ አርዘ ፋጾዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ታስ ታፓ ካታራ Ꮉላቃ የነ፥ ታፓ ዬካራ ታ ኪትዘ ዎታዳሩንꬅ የነ። ፈታ፥ ‹ቅቶ› ጋይኮ ቅታነ፥ Ꮉንካያ፥ ‹ዮኦ› ጋይኮ የእነ። ታ አርዘጎ፥ ‹Ꮉኖ ዪዞ› ጋይኮ ዪዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","የሱሳ ይኖ ስእደ ዎደ ጋማ ቆፕዳ። ሱብ ማቂ ፋና ካልዘ አሱንꬃጎ፥ «ታ ይንትስ ቱሮ ኦህነ፤ መለ አቶ የዝን እስራኤሉንꬃፓን Ꮉኒ ጋር ዳማ አማኖ ደንግካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ኪትንትዱንꬅ ካራ ማቅደ ዎደ አርዘ ፋጽን ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ኤራꬅ ዎደፓ ሱባ የሱሳ ናይነ ካታማ ቅትዳ። ኤ ታማሩንꬃራን መለ ጋማ አሱንꬅ ኤራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ኤ ካታማ ገሎደስ ይእዘ ዎደ አሀ ቶኪ ጋማ አስ ካታማፓ ከዛነ። Ꮉይቂደ ናአይ ፋ እንትስ ፈቶ፥ እዛን ቡዳኖ ማቂ የነ። ካታማ አሱንꬃፓ ጋሙንꬅ ኢራ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ላꬂ እዞ ብእ ይቅስንቲ፥ «ዬክፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ሺቂ ሻንቻፍዛ ቦችን ቶክደ አሱንꬅ ኤቅዳ። የሱሳ፥ «ናተ፥ ናአትꬃዮ ደንዶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ꮉይቂዳይ ደንዲ በቲ ኦሄ አይክዳ። የሱሳ ናአያ ደንꬂ እንትስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","አሱንꬅ ኡቡንꬅ ዣሽቲ፥ «ዳማ ናበ ኑ ግዳ ደንድዳ፤ ጾዚ ፋ አሱንꬃና ብእዳ» ያጋእ ጾዝ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ኤ ሱንꬅታ ይሁዳን ይና ካራ ጋንጨ የዘ ሳእተ ኡባነ ስንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ጻማቅዘ ዋሐንሳ ታማሩንꬅ ይኖ ኡባኖ ዋሐንሳስ ኦህዳ። ኤ ኡን ግዳፓ ላምኡንꬃና ጼጊ፥ ");
INSERT INTO oyde_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«ዮኦዳ ጋእንትደ ነናነ? ዎይ መለ ናጎደ?» ያጋእ ኦጮተ ጋእ ላꬃጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","አሱንꬅ የሱሳጎ Ꮉንግ፥ ጻማቅዘ ዋሐንሳ፥ «ዮኦዳ ጋእንትደ ነናነ? ዎይ መለ ናጎደ?» ጋኦተ ጋእ ኑና ኔጎ ኪትዳ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ይና ሳተ የሱሳ ጋማ አሱንꬃና Ꮉርገፓ ፋꬅዳ። ጋማ ቱና አያኑንꬃና ከስዳ፥ ቆቅደ ኣፈን ብእዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ዋሐንሳ ካለፓ ኪትንቲ የኤዙንꬃጎ፥ «Ꮉንግ ይን ብእዳኖን ስእዳኖን ዋሐንሳስ ኦሆተ። ኣፈ ቆቁንꬅ በአዳ፥ ቶሄ ጉንዱንꬅ ብልንቲ የꬎዳ፥ ቁርሱማራ Ꮉርግንትዙንꬂ ፋጾዳ፥ ቱሉንꬅ ስኦዳ፥ Ꮉይቂዱንꬅ Ꮉይቆፓ ደንዶዳ፥ ዳሁንꬅስ ዎንገለ ሳባክንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ታ ግዳ ꬉቡንቶሰ ኦደን አንጅንትዳያ።» ");
INSERT INTO oyde_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ዋሐንሳ ኪትዱንꬅ ቅትዳንፓ ሱባ የሱሳ አሱንꬅስ ዋሐንሳ ባዝ ያጋእ ኦህዳ፦ «ይን አኮ በአደስ አኮ ባይዘ ጋናሳ ከዝዶ? ባቆ ኤንእስዘ ሾምቦቆ በአደስነ? ");
INSERT INTO oyde_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ዬዝን፥ አኮ በአደስ ከዝዶ? ቦንቾ ማኦ ማእደ አሱንꬃና በአደስነ? ቦንቾ ማኦ ማእዱንꬅን ሳአ ሎእደ አሱንꬅ ካት ኬꬃ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ዬዝን፥ አኮ በአደስ ከዝዶ? ናበ በአደስነ? ዬ፥ ታ ያጋነ፦ ይን በአደስ ኬዝዳና ናበፓ ኣꬍዛያ። ");
INSERT INTO oyde_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","« ‹ነ ኦግቶ ነ ቲንተ ጊግዘ ታ ኪታንችዛ ኔፓ ቲኖ ታ ኪቶዳ› ጋእንት ጻፍንትዳና ይንስ። ");
INSERT INTO oyde_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ታ ይንትስ ኦህነ፤ ማችፓ የልንትዱንꬅ ግዳፓ ዋሐንሳፓ አꬍዘ ባያ። ጾዘ ካእቱምተ ኡባፓ ኤርዛይ፥ ኤ ኡባፓ ዳማ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","መለ አቶ የዝን፥ ጊራ ጋችዙንꬂ ኡቡንꬅ ዋሐንሳ ኩሽተ ጻማቅንትዱንꬅ የሱሳ ቃልቶ ስእ ጾዚ ጽሎ ማቅዳኖ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","የዝን ፋርሳዉንꬅን ህገ አስታማሩንꬅ ዋሐንሳ ኩሽተ ጻምቅንታንጽ ጾዘ ዞርቶ ለቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","የሱሳ ካሊ Ꮉንጋራ ያጋይዳ፦ «ይኬ፥ Ꮉና ዎደ የለቱንꬃና አኮራ አዝዞ? ኡንትን ኦና አዛነ የሳ? ");
INSERT INTO oyde_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ጋበ ግዳ በቲ ዎል ጼጊ፥ ‹ኑ ይንትስ ሱሉንቀ ፉግን፥ ይን የጾስ። ኑ ናሺ ጋይርን፥ ይን ዬኮስ› ያጋዘ ናኡንꬃና አዛነ። ");
INSERT INTO oyde_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ጻማቅዘ ዋሐንሳ ሙእካይዛራን ኡዥካይዛራ ይእን፥ ‹ኢታ አያናራ የነ ጋይዳ።› ");
INSERT INTO oyde_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","አስ ናአይ ሙእተራን ዎይነ ኡዥተራ ይእን፥ Ꮉይ አꬄ ‹ሙስ ዥምባራን ኡሽ አስ፥ ጊራ ጋቹዙንꬅስን ናጋራንቹንꬅ ዣመ› ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ይኬ፥ ጾዘ ጭንጫትꬅ ኦቻራ ቆንጭዳ»። ");
INSERT INTO oyde_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ፈቲ ፋርሳውዘ የሱሳ ካꬃ ሙሳደስ ፋ ካራ ጼግዳ። ኤ ፋርሳውዘ ካራ Ꮉንግ ሌማተ ካለ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ይና ካታምተ ፈቲ ናጋራንቾ ማቻ የዛና የሱሳ ፋርሳውዘ ካራ ሙሳላ አፋ የዛኖ ስእደ ዎደ ጋማ አልኦ አልባስጥሮሰ ብልቃጠ ሽቶ ኤኪ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","የሱሳስ ሱባ ዛላራ፥ እዛ ቶህት ካለ ኤቂ ዬክተራ እዛ ቶህቶ ፋ አፉꬅትራ ላክꬃነ። ፋ ኦምትራ እዛ ቶህቶ ኡጭተራን ዬሪቴ ሽቶ ትዥዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ሙእዘ ባዝቶ ጊግዝደ ፋርሳውዘ ይኖ በኤዘ ዎደ ፋ ዎዝንተ፥ «Ꮉይን ናበ የዛኮ Ꮉና ማችታ ኤዛ ቦችዛና ኦና የዛኮ ማህ እዛ ናጋራ ደኦር ማቅዳኖ ኤ ኤሮድ የሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","የሱሳ፥ «ስሞና፥ ታ ኔስ ኦህዘ ባዝ የነ» ያጋይዳ። ኤዝን፥ «አስታማርዛዮ፥ ታስ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","የሱሳ ኤጎ፥ «ላምእ አሱንꬅ ፈቲ አꬄፓ ብራ ታልእዳ። ፈተ እችን ጼት ብራ Ꮉንካይ ማህ እሽንታም ብራ ታልእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ላምኡንꬅን ታልእቶ ጭጎደስ ጋምን፥ ላምኡንꬅስን ታልእቶ ማርዳ። ይኬ፥ Ꮉንꬅ ላምኡንꬃፓ የ አꬃ ጋማ ካꬎደ ኔስ አያ አዘ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ስሞና፥ «ጋማ ጋለ አቶ ጋእንትደ አꬄ ጋማ ካꬎዳ አዛነ» ያጋይዳ። የሱሳ፥ «ነ ቱሮ ፍርድዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ይንፓ ሱባ፥ የሱሳ ማችትጎ ማቂ ብእ፥ ስሞናጎ፥ «Ꮉኖ ማችቶ በእነ? ታኒ ነ ካራ ገልን መለ አትን ነ ታስ ቶሄ Ꮉꬅ እንግካያ፥ የዝን እዛ ታ ቶህቶ ፋ አፉꬅትራ ላክꬂ ፋ ኦምትራ ኡጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ነ ታና ዬሪ ቢካያ፥ የዝን እዛ ታ ነ ካራ ገልዳንፓ አይኪ ታ ቶህቶ ዬረ አሽካያ። ");
INSERT INTO oyde_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ነ ታ ኦምተ ዛይተ ትዥካያ፥ የዝን እዛ ታ ቶህቶ ሽቶ ትዣነ። ");
INSERT INTO oyde_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","እዛ ታና ጋማ ካꬍደ ግሾ እ ጋማ ናጋርታ አቶ ጋእንትዳ። ኤ ኤራꬅ ናጋርታ አቶ ጋእንትደ ኤራꬅ ካꬋነ።» ");
INSERT INTO oyde_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","የሱሳ ማችትጎ፥ «ነ ናጋርታ አቶ ጋእንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ኤዛራ ዎላ ሌማተ በቲ ሙእዘ ዛቁንꬅ፥ «ናጋራ አቶ ጋይደ፥ ኤ Ꮉይኒ ኦደ?» ያጋእ ፋ ዎዝንተ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","የሱሳ ማችትጎ፥ «ነ አማንታ ነና አሽዳ፤ ሳሮ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ይንፓ ሱባ፥ የሱሳ ጾዘ ካእቱሞ ዎንገለ ሳባክተራ ካታማራን ካራ ጋንጨራ አꬍዳ። የ ዎደ ታጶ ላምኡንꬅን ኤራ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ማቂ ቱና አያናፓን ዱማ ዱማ Ꮉርገፓ ፋጽደ ፈቲ ፈቲ ማቹንꬅ ኤራ የነ። ኡንትን፥ ላፑን ቱና አያኑንꬅ ከዝደ ማግደላ ማይራሞ፥ ");
INSERT INTO oyde_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ሄሮድሳ ሹምደ ኩዛ ማችቶ ዮሐና፥ ሶስናራን ማህ መለ ጋሙንꬅ ኡንታና ብራራ ማድዙንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ጋማ አሱንꬅ ዱማ ዱማ ካታማፓ ኤጎ ሺቅን አዝዘራ ኡንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«ፈቲ ዎት አቅዛይ ቡዱꬅ ቡዶደስ ከዝዳ። ኤ ቡዶደራ ፈቲ ፈቲ ቡዱꬅታ ኦገላ ዎꬊ የꬍንትዳ፥ ላንዳ ማጽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","መሉንꬅ ላላ ኦሞራ የዘ ሳአላ አፋ ዎꬍዳ። Ꮉጋ ዶሎደራ ሳእተ ላኮ ባይዘ ግሾ ምጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","መለ ቡዱꬅታ ማህ አንጋꬅ ግዳ ዎꬍዳ። አንጋꬅትራ ዎላ ድጭደ ግሾ አንጋꬅታ ጩሊ በስተ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","መሉንꬅ ሎኦ ሳአላ አፋ ዎꬍዳ። ዶልደ ዎደ ጼት ኩሸ ኣፍዳ።» ይኖ ኦህ Ꮉሲ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ስእዘ Ꮉየ የዘ ኡቡንꬅ ስኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ኤ ታማሩንꬅ፥ «Ꮉና አዝዝትስ ብልꬅታ አኮ?» ያጋእ ኦጭዳ ");
INSERT INTO oyde_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ኤ፥ «ጾዘ ካእቱሞ ጋꬅ ቆፋ ኤሮደ ፋና ይንትስ እንግንትዳ። የዝን መሉንꬅ ብእተ ደንጋመ ጋር፥ ስእተ ቲራመ ጋር አዝዘራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«ይኬ፥ Ꮉና አዝዝትስ ብልꬅታ Ꮉኖ፦ ቡዱꬅ ጋእንትደ ጾዘ ቃላ። ");
INSERT INTO oyde_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ኦገላ ዎꬍደ ቡዱꬅታ ቃላ ስእዙንꬃና። ማቆ የዝን፥ ኡን አማኒ አታመ ፋና ጻላሄ ቃልቶ ኡን ዎዝንትፓ ማጺ Ꮉሳነ። ");
INSERT INTO oyde_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ላላ ኦሞ የዘ ሳአላ አፋ ዎꬍደ ቡዱꬅታ ቃላ ስእ ኡፋይሳራ ኤክዙንꬃና። ኡን Ꮉተስ አማናነፕ አትን ጻጶ ባይዘ ግሾ ፋታና የልደ ዎደ ኤልሲ ካዳነ። ");
INSERT INTO oyde_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","አንጋꬅ ግዳ ቡዱንተዙንꬅ ቃላ ስእዙንꬃና። ኡንትን አላመ ቆፋራ፥ ዱረትꬃራ ሳአ የስ ጊጋራ ጩሉንቲ ኮሽዘ ፋና አፍካይ። ");
INSERT INTO oyde_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ሎኦ ሳአላ ዎꬍደ ቡዱꬅታ ሎኦ ዎዝናራ ቃላ ስእ ናግዙንꬃናን ዳንዳአራ ሚንግ ኣፈ አፍዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«ጾምፐ ጾምፒ፥ ኩርኩሮ ጉጲ ዎይ ዳꬃፓ ኦሞራ ጋድዘ ባያ። ገልዘ አስ በአደ ጋር ꬎቃ በሳ ጋዳነ። ");
INSERT INTO oyde_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«ይኒ ግሾ፥ አችንትደ ቆንጨ ከዝካይዛራ ጌንግደ ጌሻ ከዝካይዛራ አቶደ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«ይኬ፥ ይን ቃላ ዋይዝ ስእዛኮ ቲሮተ። የዘ ኡቡንꬅስ ጉጅንት እንግንቶዳ፥ ባይዘስ መለ አቶ የዝን ኤስ የዘ ኤራꬅታን ኤፓ ኤክንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","የሱሳ እንትራን እሹንꬃራ ኤጎ ይእዳ። የዝን አስ ጋማትꬃፓ ደንዲ ኤዛ ደንጎደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ፈቲ አስ የሱሳጎ፥ «ነ እንትራን ነ እሹንꬃራ ነና ኮይ ባለ ካፋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","የሱሳ ማህ፥ «ጾዘ ቃላ ስእ ኦቻላ ፌሽዙንꬅ ኡባ ታስ እንዶን ታስ እሸን» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ፈቲ ዎደ የሱሳራን ኤ ታማሩንꬃራ ዎላ ጎንገ ገሊ፥ አባ ፊንጎዳ ያጋይዳ። ኡንትን ቅቶደስ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","አባላ አፋ ኡን ፊንጎደስ Ꮉማደራ የሱሳ ገንትዳ። ቲርካይዝን ምንꬂ ባቆ አባላ ደንድዳ። Ꮉꬅታ ጎንግተ ገልን ጎንግዘ ቆꬍንተ አይክደ ዎደ ኡቡንꬅ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ኤ ታማሩንꬅ ኤጎ ሺቂ፥ «ኑ ላꬃዮ፥ ኑ ላꬃዮ፥ ኑ ꬋባነ ያጋእ» የሱሳ ደንꬅዳ። የሱሳ ደንዲ ባቅቶን ዙሉንቶን ካጭዳ። ኤልሲ ባቅታን ዙሉንታን ዎፑ ጋይዳ። ሳሮትꬅን ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","የሱሳ ፋ ታማሩንꬃጎ፥ «ይን አማንታ አነ» ያጋይዳ። ኡንትን፥ ዣሽትተራን ጋማ ቆፕተራ ፈተ ፈተጎ፥ «ባቆን Ꮉꬅን ኪትንትዘ፥ ኤ Ꮉይ ኦደ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","አባ ፊንግ ጋልላ ዛላራ የዘ ገርገሶነ ሳአ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","የሱሳ ጎንገፓ ኬዚ ሳአ ዎꬎደራ ቱና አያናራ አይክንትደ አꬄ ካታማፓ ኬዚ ኤራ የልንትዳ። ጋማ በረ አፉላ ማአንጽ ካሎ ቦዛ የነፕ አትን ካራ ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","የሱሳ በኤዘ ዎደ ኤ ቲንተ ቡንቁንቲ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ኡባፓ ካታራ የዘ ጾዘ ናአዮ የሱሳ ኔራ ታስ አኮ ፈተትꬅ የዘ? አደ ታና Ꮉተ ኡንእꬅፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ይኖ ኤ ጋይዳና፥ ቱና አያንዘ አꬄፓ ኬሳደ ጋር የሱሳ ካጭደ ግሾ። ጋማ ዎደ ቱና አያና ኤዛ አይኪ ጋምእደ ግሾ ሳንꬃላታራን ቶሄ አጭዘ መቆራ አጭንቲ ናግንታነ። የዝን አችቶ ዱꬂ ቱና አያናራ እዥንት አኮ ባይዘ ጋናሳ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","የሱሳ፥ «ነ ሱንꬅታ ኦደ» ያጋእ ኦጭዳ። ኤ፥ ጋማ ቱና አያኑንꬅ ኤዛ አይክደ ግሾ ፋና፥ «ሌግዮና» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ቱና አያኑንꬅ ፋና ስኦለ ኪታመ ፋና ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ይና በስተ ዞዘላ አፋ ሙእዘ ጉዳይለ ዉደ Ꮉንታነ። ሰኮ ጉዳይሉንꬅ ግዳ ገሎነ ጋእ ዎስዳ፥ ኤዝን «ገሎተ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ቱና አያኑንꬅ አꬄፓ ኬዚ ጉዳይሉንꬅ ግዳ ገልዳ። ዉድታ ደርትፓ ሱለ ጉርጉጺ አባ ጌና ግዳ ቆꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","የንግዙንꬅ Ꮉንዳኖ በኤዘ ዎደ ዎጺ Ꮉንግ፥ ካታማራን ካራ ጋንጨ ኡባ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","አሱንꬅ Ꮉንዳኖ በአደስ ኬዚ የሱሳጎ ይእዳ። ቱና አያና ከዝደ አꬄ ማኦ ማእ፥ ኤ ዎዝንታ ማቅን፥ የሱሳ ቶሄ ካለ በተዝን ደንግ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ኤዛ በኤዘ አሱንꬅ ቱና አያናራ አይክንትደ አꬄ ዋይዝ ፋጸዛኮ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ገርገሶነ ካንቶ ዉቲ የዘ አሱንꬅ ዳማ ዣሽሞ ዣሽቲ የሱሳ ፋ ካለፓ ቅቶደ ጋር ዎስዳ። ኤ ጎንግዘ ግዳ ገሊ ሱብ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ቱና አያና ከዝደ አꬄ የሱሳራ የሳደስ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","የዝን የሱሳ ኤጎ፥ «ነ ካራ ማቆ፥ ጾዚ አኮ ጋር ዳማ ባዝ ኔስ ኦቼዛኮ ኦሆ» ያጋእ ሞይዝዳ። አꬃይን የሱሳ አኮ ጋር ዳማ ባዝ ኤስ ኦቼዛኮ ካታማ ኡባ ማርክꬍተ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","አሱንꬅ ናጊ ጋምእደ ግሾ የሱሳ ማቅደ ዎደ ሞኪ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","አይሁደ ዎሳ ኬꬃ Ꮉላቃ ማቅደ እያሮሳ ጋዘ አꬄ ፋ ካራ የኦደ ፋና የሱሳ ቶህትላ አፋ ዎꬊ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ኤስ ታጶ ላምእ በረ ማቅደ ፈቲ ማች ናአ የዛና Ꮉርግንቲ Ꮉይቆስ የሊ የነ። የሱሳ Ꮉንግዘ ዎደ አሱንꬅ ኤዛ ኡንእꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ታጶ ላምእ በረ ሱꬂ ኤቃንጽ ጎግተራ ጋምእደ ማቻ የነ። እዛ ፋስ የዘ ሚሽቶ አክመስ እንግ Ꮉስዳ። የዝን ፋጾደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","እዛ የሱሳስ ሱብ ዛላራ ሺቂ፥ ኤ አፉላ ማጫርቶ ቦችዳ፥ ኢራ ጎግዘ ሱꬅታ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","የሱሳ፥ «ታና ቦችደ ኦደ?» ያጋይዳ። ኡቡንꬅ «ኑ ቦችካያ» ያጋእን፥ ጴጥሮሳ፥ «አስታማርዛዮ፥ ጋማ አሱንꬅ ካልዛኖን ኡንእꬅዛኖ ብእተራ ዋይዝ፥ ‹ታና ቦቼዘ ኦደ?› ጋኤ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","የዝን የሱሳ፥ «ፈቲ አስ ታና ቦችዳ፤ አኮስ ጋይኮ፥ ዎልቃ ታፓ ኬዝዳና ታስ ኤርንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ማችታ፥ እ ባዝ ቆንጭዳኖ ኤርደ ዎደ ጎቅተራ ይእ የሱሳ ቶህትላ አፋ ጎልእዳ። አኮስ ቦቼዛኮን ዋይዝ ኤልሲ ፋጸዛኮ አስ ኡባ ቲኖ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ኤ፥ «ታ ናእተ፥ ነ አማንታ ነና ፋꬅዳ፤ ሳሮራ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","የሱሳ Ꮉጋ ኦህ Ꮉስካይዝን፥ አይሁደ ዎሳ ኬꬃ Ꮉላቃ፥ እያሮሳ ካራፓ ፈቲ አስ ይእ፥ «እያሮሳ፥ ነ ናእታ Ꮉይቂዳ፤ አስታማርዛ Ꮉሪ ላቢዝፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","የዝን የሱሳ ይኖ ስእ እያሮሳጎ፥ «ዣሽትፐ! አማኖ፥ ነ ናእታ ፋጾዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","የሱሳ እያሮሳ ካራ የልደ ዎደ ጴጥሮሳፓ፥ ዋሐንሳፓ፥ ያይቆባፓ፥ ናቲ አደፓን እንትፓ አትን መለ ገሎደ ጋር ኮይካያ። ");
INSERT INTO oyde_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ይና በስተ የዘ አሱንꬅ ኡቡንꬅ ናትስ ይቅስንቲ ዬኮደር፥ የሱሳ፥ «ዬክፐተ! ናታ ገንትዳፕ አትን Ꮉይቂካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","አሱንꬅ ናታ Ꮉይቂዳኖ ኤርደ ግሾ ኤ ኦህቶ ለቂ ሚጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","የዝን የሱሳ ናቲ ኩሽቶ አይኪ፥ «ናእተ ደንዶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ናእትስ ሸምፕታ ይእን ደንዲ ኤቅዳ። የሱሳ ኡንታጎ፥ «ኢስ ሙእዘ ባዝ እንጎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ናቲ አደራን እንትራ ጋማ ቆፕዳ። የዝን የሱሳ Ꮉኖ፥ «ኦደስን ኦህፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","የሱሳ ታጶ ላምእ ሐዋሩንꬃና ፋጎ ጼጊ፥ ቱና አያና ከሶደ ጋራን Ꮉርገ ኡባ ፋꬆደ ጋር ዎልቃን አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ጾዘ ካእቱሞ ባዝ ማርክꬋደ ፋና Ꮉርግንትዙንꬃና ፋꬆደ ፋና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ኤ ኡንታጎ፥ «ጉፈ ማቅን ስልጰ ማቅን ካꬃ ማቅን ብራ ማቅን ላምእ ማእዘ አፉላ ማቅን ኦገስ ጋእ አኮን አይክፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ይና ካታምትፓ ይን ኬሳደ ዎንꬅስ ዛቆትꬅ ይን ገልደ በሳ ጋምኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ኦደን ይንታና ሞካንጽ እጽኮ ይና ካታምትፓ ከዝተራ ኡንትስ ኤርስዘ ማርካ ማቃደ ፋና ይን ቶህተ የዘ ጹርቶ ፍጺ ከዞተ።» ");
INSERT INTO oyde_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ኡንትን ኪትንትዳን ፋና ኬዚ ዎንገለ ኦህተራ ዱማ ዱማ ካራ ጋንጨ Ꮉርጋንቹንꬃና ፋꬅተራ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ጋልላ ሳአ አህዘ ሄሮድሳ የሱሳራ ኦችንትደባዝቶ ሙሎ ስኤዘ ዎደ ይርግዳ። አኮስ ጋይኮ፥ ፈቲ ፈቲ አሱንꬅ ዋሐንሳ Ꮉይቆፓ ደንድካይዛራ አታማ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ባጉንꬅ፥ «ኤልያሳ በንትዳ» ጋነ፤ መሉንꬅ ማህ፥ «ዛጋ ናቡንꬃፓ ፈተ Ꮉይቆፓ ደንድዳ» ያጋእ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","የዝን ሄሮድሳ፥ «ዋሐንሳ አፉርቶ ታ ጋችዚ ዎꬍዳ። ዬዝን፥ Ꮉንጋራ ያጋእንት ኤ ባዝ ኦህንትዘ፥ ኤ ኦደ?» ያጋእ የሱሳ ፋ ኣፍተ በአደስ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ታጶ ላምእ ሐዋሩንꬅ ሱባ ማቂ ይእ፥ ኡን ኦችዳኖ ሙሎ የሱሳስ ኦህዳ። ኤ ኡንታና ኤኪ ቤተሳይዳ ካታማፓ ጋጻ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","የዝን ጋማ አሱንꬅ የሱሳ ማቅዛኖ ኤሪ ኤዛ ካልዳ። ኤ ኡንታና ሞኪ ኤኪ ጾዘ ካእቱሞ ባዝ ታማርስዳ፤ ፋጾደስ ኮይዙንꬃና ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ሳአ ኡጉርደ ዎደ ታጶ ላምእ ሐዋሩንꬅ ኤጎ ሺቂ፥ «ኑ የዘ አኮ ባይዘ ሳአ ማቅደ ግሾ አሱንꬅ ዱማ ዱማ ካራ ጋንጨን ካታማን ቅቲ፥ ካꬃን አቅዘ በሲ ኮዮደ ፋና አሱንꬃና ሞይዞ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","የዝን ኤ፥ «ኡንትስ ሙእዘ ባዝ ይን እንጎተ» ያጋይዳ። ኡን፥ «ኑስ የዘ እችን ቦራን ላምእ ሞሎን ማቅደ ግሾ Ꮉንꬅ አሱንꬅስ ማቅዘ ካꬃ ኑኒ Ꮉንግ ዎንጋንጽኮ ማቆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ይና በስተ እችን ሙኩል ማቃደ ꬊራꬁንꬂ የነ። የሱሳ ፋ ታማሩንꬃጎ፥ «እችንታም እችንታም ሻኪ ሻኪ አሱንꬃና በትꬆተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ኤ ታማሩንꬅ፥ ኤ ኪትዳን ፋና አሱንꬃና በትꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ኤ እችን ቦርቶን ላምእ ሞልቶ ኤኪ፥ ሳሎ ብእ፥ ጾዝ ጋላቲ፥ ባጽ አሱንꬃና ሙሎ የልꬆደ ፋና ፋ ታማሩንꬅስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ኡቡንꬅ ሙእ ምዥዳ። ኡንታፓ አትደ ታጶ ላምእ ሌማተ ኩሙꬅ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ፈቲ ዎደ የሱሳ ፋ ጻላላ ዎሶደራ፥ ኤ ታማሩንꬅ ኤጎ ይእዳ። ኤ፥ «አሱንꬅ ታና ኦና ጋኤ?» ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ኡን ማህ «ፈተ ፈተ፥ ‹ጻማቅዘ ዋሐንሳ፥ ባጉንꬅ ኤልያሳ፥ መሉንꬅ ማህ፥ ዛጋ ናቡንꬃፓ ፈተ Ꮉይቆፓ ደንድዳ› ያጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ኤ ማህ፥ «ዬዝን ይን ታና ኦና ጋኤ» ያጋይዳ። ጴጥሮሳ፥ «ኔኒ ጾዛፓ ዶርንትደ ክርስቶሳ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","የሱሳ Ꮉኖ ኦደስን ኦህፐተ ጋእ ምንꬂ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ማህን የሱሳ፥ «አስ ናአይ ጋማ ማꬋ ኤኮዳ። ጋደ ጭሙንꬅስ፥ ካህኑንꬅ Ꮉላቁንꬅስን፥ ህገ አስታማሩንꬅ ካለ እጽንቶዳ። ኡን ኤዛ ዎꬎዳ፥ የዝን ኤ Ꮉይꬓንꬆ ቃማ Ꮉይቆፓ ደንዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","የሱሳ አሱንꬅ ኡቡንꬃጎ፥ «ታና ካሎደስ ኮይዘ ኦደን የዝኮ ፋና ካዶ፥ ፋ ማስቃልቶ ኡባ ቃማ ቶኪ ታና ካሎ። ");
INSERT INTO oyde_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ፋ ሸምፕቶ አሾደስ ኮይዘ ኡቡንꬅ እዞ ꬋብሳነ፥ ፋ ሸምፕቶ ታ ግሾ ጋእ ꬋብስዘ ኦደን እዞ አሻነ። ");
INSERT INTO oyde_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","አስ አላመ ሙሎባዝ ደንግዛ፥ ማቅኮን ፋ ሸምፕቶ ꬋብስዘባዝ ዎይ ቆህዘ ባዝ ማቅኮ ኤዛ አኮ ማደ? ");
INSERT INTO oyde_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ኦደን ታ ግዳን ታ ቃልተን ዬልꬍኮ አስ ናአይ ፋ ቦንቾራ ይኒ ጋራ አዳይ ቦንቾራን ጌሽ ኪታንቹንꬅ ቦንቾራ የእዘ ዎደ እዘ ዬልꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ታ ይንትስ ቱሮ ኦህነ፤ Ꮉነ ኤቅዱንꬅ ግዳፓ ጾዘ ካእቱሞ ብእካይዛራ Ꮉይቆሰ አሱንꬅ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","የሱሳ ይና ኦህቶ ኦህን፥ ኦስፉን ቃማፓ ሱባ ጴጥሮሳ፥ ያይቆባን ዋሐንሳን ፋራ ኤኪ ዎሶደስ ደረላ አፋ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ኤ ዎሳላ አፋ የዝን ኤ ስንታ ላምንትዳ፤ አፉልታን አዋ ፋና ፎእ ቦጽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ላምእ አሱንꬅ፥ ኡንትን ሙሴራን ኤልያሳራ ቦንቾራ በንቲ፥ ");
INSERT INTO oyde_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","የሩሳላመ ፎልንቶደስ የዘ ባዝ፥ ይናን፥ ኤ Ꮉና አላምትፓ ሻክንቶደ ባዝ ኤራ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ጴጥሮሳን ኤራ የዙንꬅ ገንቲ አትን፥ ኡን ገንቶፓ ደንድዘ ዎደ ኤ ቦንችቶን ኤራ ኤቅደ ላምእ አሱንꬃና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","አሱንꬅ የሱሳፓ ሻክንት ቅቶደስ ይአደራ፥ ጴጥሮሳ የሱሳጎ፥ «ላꬆ፥ Ꮉነ የዛና ኑስ አኮ ጋር ሎኦ! ፈታ ኔስ፥ ፈታ ሙሴስ፥ ፈታ ኤልያሳስ ማህ Ꮉይꬕ ጋባ ጋቦዳ» ጋይዳ። የዝን ኤ ፋስ አኮ ጋኤዛኮን ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ኤ ያጋእ ኦህንቶደራ ꬎነ ይእ ኡንታና ጎዝዳ። ታማሩንꬅ ꬎንቲ ግዳ ገልተራ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ꬎነ ግዳፓ፥ «ታ ዶርደ ናአይ Ꮉያ ኤዛ ስኦተ» ያጋዘ ኦꬂ ስንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","የ ኦꬅዘ ስንትዳንፓ ሱባ የሱሳ ፋስ የዝተ በንትዳ። የ ዎደ ኡን ብእዳኖ ኦደስን ኦህካይዛራ፥ ፋ ዎዝንተ አይኪ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ዎንትስቶ ኡን ደርዘፓ ዎꬍዘ ዎደ ጋማ አሱንꬅ ይእ ኤራ የልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","የ ዎደ አሱንꬅ ግዳፓ ፈቲ አስ፥ «አስታማርዛዮ፥ ታ ፈቲ ናአያ ይእ ቦኦያ። ");
INSERT INTO oyde_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ቱና አያና ቆፕካይዝን አይኪ ዉይስዛነ፤ ጎፑንቶ ጮሽ ጉዱꬃነ፥ አሽቶ ቆህ ኡንእꬅ ኬሳደስ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ነ ታማሩንꬅ ከሶደ ጋር ዎስዳ፥ የዝን ኡን ዳንዳእካያ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","የሱሳ፥ «አማኖ ባይዘ ዎቦ የለቱንꬆ፥ አይደ የሎደስ ታ ይንታራ የሳደ፥ ይንታና ዳንዳኦደ? ነ ናአያ Ꮉንግ Ꮉንካ ኤኪ ዮኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ናአያ ኤኪ የእዘ ዎደ ቱና አያንዘ ሳአ ኦሊ ጉዲ ጎቅዝዳ። የዝን የሱሳ ቱና አያንዛ ካጪ ናአይፓ ኬስን ፋꬅዳ። ናአያን ናአይ አደስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","አሱንꬅ ኡቡንꬅ ጾዘ ዳማ ዎልቅቶ ብእ ጋማ ቆፕዳ። ኡን ኤ ኦችደ ባዝተ ጋማ ቆፖደራ፥ የሱሳ ፋ ታማሩንꬃጎ፥ ");
INSERT INTO oyde_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Ꮉኖ ታ ይንትስ ኦህዛኖ ሎይꬂ ስኦተ፤ አስ ናአይ አይሁዱንꬅ ኩሽተ አꬊ እንግንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","የዝን ኤ ጋይዳና ኡንትስ ገልካይዘ ግሾ ኡን ቲሪካያ። ይኒ ግሾ፥ ማህ ኦጮደስ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","የሱሳ ታማሩንꬅ፥ «ኑ ግዳ ዳማ ማቃደ ኦደ?» ጋእ ላለ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","የሱሳ ኡን ዎዝና ቆፍቶ ኤሪ ዦጋ ናአ ፋ ካለ ኤስ፥ ");
INSERT INTO oyde_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«Ꮉይ ዦጋ ናአያ ታ ሱንꬅተ ኤክዘ ኦደን ታና ኤካነ፥ ታና ኤክዘ ታና ኪተዛያ ኤካነ፥ ይን ኡቡንꬃፓ ኤርዛይ፥ ኤ ዳማ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ዋሐንሳ፥ «ላꬆ፥ ፈቲ አስ ነ ሱንꬅተ ቱና አያና ኬሶደራ ብእ ኤ ኑራ ማቆሰ ግሾ ካይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","የሱሳ ማህ፥ «ይንታና እጾሰ፥ ኤ ይን ባጋ። ይኒ ግሾ፥ ኤዛ ካይፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","የሱሳ ሳሎ ቅትዘ ዎደ ኡክደ ግሾ የሩሳላመ ቅቶደስ ቆፍቶ ምንꬂ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ሳማራ ሳአ የዘ ፈቲ ካራ ጋንጨ Ꮉንግተራ፥ ኡባ ባዝ ኤስ ጊግሳደ ፋና አስ የይጋ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","የዝን ኤ Ꮉንግዛና የሩሳላመ ማቅዳኖ ኡን ኤርዘ ግሾ ኡን ኤዛ ሞኪ ኤክካያ። ");
INSERT INTO oyde_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","የሱሳ ታማሩንꬅ ያይቆባራን ዋሐንሳራን ይኖ ብእ፥ «ላꬆ፥ ሳሎፓ ታማ ዎꬊ ኡንታና ሞኦ ጋዉደ ፋና ነ ኮያነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","የዝን የሱሳ ሱባ ማቂ ኡንታና ካጪ፥ ይን ግዳ አኮ አያና የዛኮ ይን ኤሮስ። አስ ናአይ አስ አሾደስ ይእዳፕ አትን ꬋብሶደስ ባያ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","የይጋፓ ደንዲ መለ ካራ ጋንጨ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ኡን ኦገራ Ꮉማደራ፥ ፈቲ አስ፥ «ነ ቅትዘ በሳ ኡባ ታ ካሎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","የሱሳ ማህ፥ «ዎርካናስ ዶቺ፥ ላንዳስ ኬꬂ የነ፥ የዝን አስ ናአይ ፋ ኦምቶ ሸምፕዘ በሲ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ꮉንካያን፥ «ነ ታና ካሎ» ያጋይዳ። የዝን አꬄ፥ «ላꬆ፥ ቲኒ ታ አዳያ ሞጊ የኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","የዝን የሱሳ፥ «Ꮉይቆ የዙንꬅ Ꮉይቂዱንꬃና ሞጎደ ፋና ኡንትስ አሺ አሾ፤ ነ Ꮉንግ ጾዘ ካእቱሞ ሳባኮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ማህ መለ አስ፥ «ላꬆ፥ ታ ነና ካሎዳ፥ የዝን ቲኒ ታ ካራ አሱንꬃና ሳሮꬅ የኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","የሱሳ ማህ፥ «ኮፀ አይኪ ሱብ በእዘ ኦደን ጾዘ ካእቱሞስ ቤዞስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ይንፓ ሱባ፥ ላꬂ መለ ላፑን ታም ላምእ አሱንꬃና ዶርዳ። ኤ Ꮉማደስ ቆፕደ ካታምተን ካራ ጋንጨ ኡባ ቲኒ Ꮉማደ ጋራ ላምእ ላምእ ማህ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","የሱሳ ኡንታጎ፥ «ይኬ ሺቆደ ካꬃ ጋማ የዝን ኦችዙንꬅ ኤራꬅ። ማቅደ ግሾ፥ ካꬃ ላꬃይ ኦችዙንꬃና ኪቶደ ፋና ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ይኬ፥ ቅቶተ፥ ዱሩንꬅ ፋና ሱꬉሙንꬅ ግዳ ይንታና ታ ዳኮዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ይን ቅትዘ ኦግትስ፥ ብራ ማቅኮን ካርጥተ ጫማ አይክፐተ። ኦገላ አፋ ኦደን ሳሮꬅፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ይን ገልዘ ኬꬃ ኡባ ቲኒ፥ ‹ሳሮ Ꮉና ኬꬅትስ ማቀ› ያጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ሳሮ ካዽዘ አስ ይና በስተ የዝኮ፥ ይን ሳርታ እዘ ሸምፖዳ፤ ኮዮስ ጋይኮ ይን ሳርታ ይንትስ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ኦችዘስ ዳሞዘ ቤዘ ግሾ ይን ገልደ ኬꬅተ ይንትስ ሺሽደባዝ ኡባ ሙእተራን ኡዥተራ እዘ ጋምኦተ። ፈተ ካራፓ ፈተ ካራ ዉትፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","አኮ ካታማን ይን ገልዘ ዎደ አሱንꬅ ይንታና ሞኪ፥ ይንትስ ሺሽደባዝ ኡባ ሞኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ይና ካታምተ የዘ Ꮉርግንትዙንꬃና ፋꬅተራ፥ ‹ጾዘ ካእቱሞ ይንታጎ ኡክዳ› ያጋእ ኦሆተ። ");
INSERT INTO oyde_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","የዝን ፈቲ ካታማ ገልዘ ዎደ አሱንꬅ ይንታና ሞካንጽ እጽኮ ቡጫላ ኬዚ Ꮉንጋራ ጋኦተ: ");
INSERT INTO oyde_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹ኑ ቶህትላ የዘ ይን ካታምት ጹርቶ ፍጻነ፥ የዝን ጾዘ ካእቱሞ ይንታጎ ኡክዳኖ ኤሮተ› ");
INSERT INTO oyde_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ጾዘ ፍርዳ ቃማ Ꮉና ካታምትፓ ሶዶመ ካታማስ ፍርዳ ኤራꬅ ማቃዳኖ ታ ይንትስ ኦህነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ካሊ፥ የሱሳ፥ «ባደ ክኦራዚነ፥ ባደ ቤተሳይዳ፥ ባደ፥ ይን ግዳ ኦችንትደ ክለ ባዝታ ጢሮሳ ግዳን ስዶናን ኦችንተዛኮ እዘ የዘ አሱንꬅ አዛኖ አፉላ ማእ፥ ቡዶላ አፋ በቲ ዛጋ ማሮትꬅ ገሊ አቶድ የሻ። ");
INSERT INTO oyde_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ይኒ ግሾ፥ ይንታፓ አꬊ ጢሮሳስን ስዶናስ ጾዘ ፍርድታ ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ባደ ቅፍርናሆመ፥ ሳሎ የሎደስ ነና ꬎቅ ኦቾደስ ኮያነ? ነ ሱለ ስኦለ ኦልንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ማህን የሱሳ ፋ ታማሩንꬃጎ፥ «ይንታና ስእዘ ታና ስእነ፥ ይንታና ኤኮሳይ ታና ኤኮስ፥ ታና ኤኮሳይ ታና ኪተዛያ ኤኮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ላፑን ታም ላምእ ታማሩንꬅ ኪትንትደ በስትፓ ጋማ ኡፋይትተራ ማቅዳ። የሱሳጎ ሺቂ፥ «ላꬆ፥ ነ ሱንꬅተ ቱና አያኑንꬅን ኑስ ኪትንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","የሱሳ ኡንታጎ፥ «ጻላሄ ሳሎፓ ዳዳ ፋና ዎꬎደራ ታ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ይኬ፥ ሾሽን ማስማሶ የꬎደ ፋናን ሞርከ ዎልቃ ተቆደ ፋና ዎልቃ ይንትስ እንግዳ። ይንታና ቆሆደባዝ አኮን ባያ። ");
INSERT INTO oyde_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ማቅኮን፥ ይን ሱንꬅታ ሳሎ ማዝጋበ ጻፍንትደ ግሾ ኡፋይቶተፕ አትን ቱና አያኑንꬅ ኪትንትደ ግሾ ኡፋይትፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","የ ዎደ የሱሳ ጌሽ አያናራ ኡፋይት፥ «ሳሎ ሳአ ላꬆ፥ Ꮉኖ ጭንጩንꬃፓን ኤሩንꬃፓ አቺ ታማርካይዙንꬅስ ቆንጭዝደ ግሾ ጋላትንቶ። ዬ ታ አዳዮ፥ ይኖ ነ ኦቾደስ ሎኦ ቆፋ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«ኡባ ባዝታ ታ አደፓ ታስ እንግንትዳ። ናአይ ኦደ የዛኮ ሎይꬂ አደፓ አትን መለ ዎይ ናአይ ቆንጭሳደስ ኮይዘፓ መለ ኦደን አዳያ ኤርዘ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ካሊ፥ የሱሳ ዱማ ፋ ታማሩንꬃጎ፥ «ይን በእዛኖ በእዙንꬅ አንጅንትዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ቱሮ ጋማ ናቡንꬅን ካቱንꬅ ይን በእዛኖን ስእዛኖ በአደስን ስኦደስ አሙꬍዳ፥ የዝን ብእካያ፥ ስእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ይኬ፥ ፈቲ ዎደ ሙሴ ዎጋ ኤርዘ ፈቲ አꬄ ደንዲ የሱሳ ያጋእ ፋታና ኦቺ ኦጭዳ። «አስታማርዛዮ፥ መዽና ደኦ ላቶደስ ታኒ አኮ ኦቾ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","የሱሳ፥ «ሙሴ ማጻፍተ ጻፍንትዳና ዋገ? ነ ዋይዝ ናባበ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","አꬃይ ማህ፥ « ‹ነ ላꬃ ነ ጾዛ፥ ነ ኩሙꬅ ዎዝናፓ፥ ነ ኩሙꬅ ሸምፖፓ፥ ነ ኩሙꬅ ዎልቃፓን ነ ኩሙꬅ ቆፋፓ ካꬎ። ማህ አስ ነ ዶꬅዛ ነ ኦምት ጋር ካꬎ› ያጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","የሱሳ ኤጎ፥ «ነ ልከ ማህዳ፥ ኔንን ይኒ ጋራ ኦቾ። ነ መዽና ደኦ የሳዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","የዝን አꬄ ፋና ጽሎ ማሆደስ ኮይ፥ «ኤ ታ ዶꬅዘ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ኤ ኦጭዳንስ የሱሳ ያጋእ ማሄ እንግዳ፥ «ፈቲ አስ የዛይ የሩሳላመ ካታማፓ ሱለ እያርኮ ካታማ ዎꬎደራ ኦገላ አፋ ፋኑንꬅ ኬዚ ጉድዳ። ኤ ማእቶ ጋሪ ኤኪ Ꮉይቆፓን ፋጻፓን ግዳ አሺ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ሱባፓ፥ አይሁደ ካህነ ፈተ ይና ኦግትራ ፋ አ ጋእ አꬍተራ አꬃ ብእ ደሽ ጋእ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ማህ ፈቲ ሌወ የዛይ ይና በስቶ የሊተራ አꬃ ብእ መለ በሳራ አꬊ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","የዝን፥ ፈቲ ሳማራ ጋደ አስ የዛይ ይና ኦግትራ ይእተራ አꬃ ብእ ኤስ ይቅስንቲ ");
INSERT INTO oyde_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ኤጎ ሺቂ፥ ኤ Ꮉርግዘ በስትላ ዛይተን ዎይነን ጉጂ አጭዳ። ፋ Ꮉርዘላ በትꬂ ዛቆ አቅዘ ኬꬃ ካንግዳ። ይና በስተ ኤስ ኮሽዘ ባዝ ሙሎ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ዎንትስቶ ላምእ ድናረ ኬሲ ዛቆ ሞክዘ ካርቲ አደስ እንግ፥ ‹ወይአ Ꮉይ አꬃ ሎይꬂ ቦኦ። ታ ኔስ እንግዳንፓ ካታራ ነ ኬስደ ባዝ ሙሎ ታ ኔስ ጭጎዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«ይኬ፥ Ꮉንꬅ Ꮉይꬕ አሱንꬃፓ ፋኑንꬅ ጉድደ አꬄስ ዶꬅꬋደ ኔስ ኦና አዘ?» ");
INSERT INTO oyde_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","አꬃይ ማህ፥ «ኤስ ይቅስንትዳያ» ጋይዳ። የሱሳ፥ «ኔንን Ꮉንግ ይኒ ጋራ ኦቾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","የሱሳ ፋ ታማሩንꬃራ ኦገ Ꮉንግተራ ፈቲ ካራ ጋንጨ የልዳ። የይጋ ማርታ ጋእንትዘ ፈቲ ማችታ እዛ ፋ ካራ ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ኢስን ማይራሞ ጋዘ ምሻ የነ፥ ማይራማ ቃላ ስእተ ላꬄ ቶሄ ካለ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","የዝን ማርታ ጋማ ኦቻራ ኡንእንት የሱሳጎ ሺቂ፥ «ላꬆ፥ ታ ምሽታ ኦችቶ ታ ጻላላስ አሺ በቲ አትን ታ ላቢዘ ዎደ ነ ብእተራ ስእ ጋነ? እዛ ታና ማዶደ ፋና ኦሆሶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","የዝን ላꬂ Ꮉንጋራ ጋእ ማህዳ፥ «ማርታ፥ ማርታ፥ ኔኒ ጋማባዛር ኡንእንት ማꬍꬋነ። ");
INSERT INTO oyde_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ማቅኮን፥ ኮሽዘ ፈትባዝ ጻላላ። ማይራማ ሎኦ ባዝ ዶርዳ፥ ይናን ኢፓ ኤክንቶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ፈቲ ዎደ የሱሳ ፈቲ በሳ ዎሳነ። ዎሳ Ꮉስደ ዎደ ኤ ታማሩንꬃፓ ፈተ፥ «ላꬆ፥ ዋሐንሳ ፋ ታማሩንꬃና ዎሳ ታማርስደ ፋና ኔንን ኑና ዎሳ ታማርሶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","የሱሳ፥ «Ꮉንጋራ ያጋእ ዎሶተ፦ « ‹ሳሎ የዘ ኑ አዳዮ ነ ጌሽ ሱንꬅታ አንጅንቶ፤ ነ ካእቱምታ ዮኦ። ");
INSERT INTO oyde_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ኑ Ꮉይኖ ቁምቶ ኑስ እንጎ። ");
INSERT INTO oyde_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ኑና ቆህዱንꬃꬃ ኑኒ አቶ ጋዛን ፋና፥ ኑ ናጋርቶ አቶ ጋኦ፤ ፋታና ግዳ ኑና ገልꬅፐ› » ያጋዉተ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ካሊ፥ የሱሳ ፋ ታማሩንꬃጎ ያጋይዳ፦ «አዝዘስ ይንታፓ ፈተስ ላገ የነ። ኤ ግዲ ብላሄ ፋ ዶꬅዘ ካራ Ꮉንግ፥ ‹ዶꬆ፥ Ꮉይꬕ ሶሎ ታስ እንጎያ። ");
INSERT INTO oyde_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ታስ ላገ ማቅደ ፈቲ አስ ኦገፓ ይእን፥ ኤስ ኣꬆደባዝ ꬋብዳ› ያጋዛኮ፥ ");
INSERT INTO oyde_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«ኤ ላግዘ ኬꬃ ግዳ የዛራ፥ ‹አደ ታና ዋይꬅፐ፥ ፉርꬅታ ጎርድንትዳ። ታ ናኡንꬅን ታራ ዳꬃላ አፋ ዎይእዳ። ይኒ ግሾ፥ ደንዲ ነ ኮይዘባዝ እማደስ ዳንዳኦስ› ያጋነነ? ");
INSERT INTO oyde_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ታ ይንትስ ኦህነ፤ ላገትꬅት ግሾ ደንዲ እማደስ ኮያንጽ እጽኮን ዎሳራ ዋይꬅደ ግሾ ደንዲ ኮሽዘ ባዝ ሙሎ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«ይኒ ግሾ፥ ታኒ ይንትስ ኦህነ፤ ዎሶተ ይንትስ እንግንቶዳ፤ ኮዮተ ይን ደማዳ፤ ፉርꬃ ይእ ጼጎተ ይንትስ ቡጉንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","አኮስ ጋይኮ ዎስዘ ኡቡንꬅ ኤካነ፤ ኮይዘ ደንጋነ፤ ፉርꬃ ይእ ጼግዘስ ቡጉንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«አዱንꬆ ይን ግዳፓ ናአ ሞሎ ዎስን ሾሽ እንግዘ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ዎይ ጱጱለ ዎስን ማስማሶ እንጋነ? ");
INSERT INTO oyde_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ይን ኢቱንꬃና ማቂ ይን ናኡንꬅስ ሎኦ ባዝ እንገ ኤርኮ፥ ሳሎ የዘ ይን አዳይ ዎስዙንꬅስ ጌሽ አያና ዋይዝ አꬂ እንጎሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ፈቲ ዎደ የሱሳ ዶና ሙምዝደ ቱና አያና ፈቲ አꬄፓ ከስዳ። ቱና አያንዘ ከዝደ ፋና ዶና ሙመ አꬄ ኦህንትዳ። አሱንꬅን ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","የዝን ፈተ ፈተ፥ «ቱና አያና Ꮉላቃ፥ ብኤልዘቡላ ዎልቃራ ቱና አያኑንꬃና ከሳነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","መሉንꬅ ማህ ፋታኖደስ ሳሎፓ ማላ ቤዞደ ፋና ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","የዝን የሱሳ ኡን ቆፍቶ ኤሪ ኡንታጎ፥ «ዎል ግዳ ሻክንትዘ ካእቱሞ ኡባና ꬋባነ፤ ዎል ግዳ ሻክንትዘ ኬꬂ ጎልአነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ጻላሄ ካእቱሞ ዎል ግዳ ሻክንትኮ ዋይዝ ሚንግ ኤቆደ? ይን ታና፥ ‹ኤ ቱና አያኑንꬃና ብኤልዘቡላ ዎልቃራ ከሳነ› ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ይኬ፥ ታኒ ቱና አያና ብኤልዘቡላ ዎልቃራ ኬስዘባዝ ማቅኮ ካልዙንꬅ ኦደ ዎልቃራ ኬሶድ የሻ? ይኒ ግሾ፥ ኡን ይንታላ አፋ ፍርድዙንꬅና ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","የዝን ታኒ ቱና አያኑንꬃና ጾዘ ግልአራ ኬስዘባዝ ማቅኮ ይኬ ጾዘ ካእቱምታ ይንታጎ ኡክዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«ምንꬂ አስ ዳንጭንቲ ፋ ኬꬅቶ ናግዘባዝ ማቅኮ፥ ኤ ቆልታ ቦችንቶስ። ");
INSERT INTO oyde_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ዪኮን፥ ኤፓ አꬊ ምንꬂ ማቅደ አስ ይእ፥ ኤዛ ዎልቂꬊ ጋምኮ አማንንቲ ዳንጭደ ዳንጭቶ ብልዚ፥ ኤ ቆልቶ ቦንቂ መሌ አስስ ሻካነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«ታራ ማቅካይዛይ ታና እጻነ፤ ታራ ሺሾሳይ ላላነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«ቱና አያና አሳፓ ከዝደ ዎደ ሸምፕዘ በሲ ኮይ Ꮉꬅ ባይዘ በሳራ ዉታነ። ሸምፕዘ በሲ ꬋብደ ዎደ ‹ታ ከዝደ በስተ ማቃዳ› ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ኤ ማቅዘ ዎደ ኬꬅታ ፍጽንቲ ሎእ የዝን ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ይንፓ ሱባ፥ Ꮉንግ ኤፓ አꬊ ኢትደ መለ ላፑን ቱና አያኑንꬃና ኤኪ የእነ። ኤ ግዳ ገሊ የስ አይካነ። የ አꬄስ ቲኖስትፓ ሱባና አꬊ ኢታ ማቃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","የሱሳ ይና ኦህትላ አፋ የሳደራ ፈቲ ማችታ አስ ግዳፓ ደንዲ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ነና ቶክደ ሳዝታን ነ ꬋንግደ ꬋንꬅታ አንጅንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","የዝን ኤ፥ «አንጅንትዱንꬅ ጾዘ ቃልቶ ስእ ኪትንትዙንꬃና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ጋማ አሱንꬅ ሺቅደ ዎደ የሱሳ፥ «Ꮉና የለቱንꬅ ኢታ፤ ክለ ማላ ኮያነ። የዝን ዮናሳ ማላትፕ መለ ኡንትስ እንግንቶስ። ");
INSERT INTO oyde_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ዮናሳ ነነዌ አሱንꬅስ ማላ ማቅደ ፋና አስ ናአይን Ꮉና የለቱንꬅስ ማላ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ሳባ ካትታ ፍርዳ ዎደ Ꮉንꬅ የለቱንꬃራ ደንዲ ፍርዶዳ። አኮስ ጋይኮ፥ እዛ ሶሎሞና ጭንጫትꬅቶ ስኦደስ ሳአ ጋጻፓ ደንዲ ይእዳ። ይኬ ሶሎሞናፓ ኣꬍዛይ Ꮉነ የነ ");
INSERT INTO oyde_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ነነዌ አሱንꬅ ፍርዳ ዎደ Ꮉንꬅ የለቱንꬃራ ደንዲ ኡንታላ አፋ ፍርዶዳ። አኮስ ጋይኮ ዮናሳ ስብከተር ማሮትꬅ ገልዳ። ይኬ፥ ዮናሳፓ አꬍዘ Ꮉነ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«ጾምፐ ጾምፒ አችቻ በሳ ዎይ ኦታ ግዳ ጋድዘ አስ ባያ። አስ ፎእቶ በአደ ፋና ꬎቃ በሳ ጋዳነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ነ ጋልትስ ፎኦ ነ ኣፍቶ። ነ ኣፍታ ሎኦ ማቅኮ፥ ነ ኩሙꬅ ጋልታ ፎአነ። ነና ኣፈ Ꮉርግኮ ነ ጋልታ ኡባና ꬉማነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ይኒ ግሾ፥ ነ ግዳ የዘ ፎእዘ ꬉማመ ጋር ናግንቶ። ");
INSERT INTO oyde_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ይኬ፥ ነ ኩንꬅ ጋልታ ፎኦ ማቅኮ፥ ነ ጋልተን መለ ꬉማ በሲ ꬋብኮ፥ ነ ጋልታ ኩሙꬅታ ፎኦ ፋና ማቃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","የሱሳ ፋ ኦህቶ Ꮉስደ ፋና ፈቲ ፋርሳዉዘ ፋራ ካꬃ ማአደ ፋና ጼግዳ። ኤ ኤራ ፈትላ ገሊ ሙንታላ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ፋርሳዉዘ የሱሳ ካꬃ ማአደፓ ቲኒ ኩሸ ሜጮሳኖ ብእ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ላꬂ ኤጎ፥ «ይን ፋርሳዉንꬅ ቡርጩቆስን ሻተስን ካታ ዛልቶ ሜጫነ። የዝን ይን ጋንጭታ ኡዛትꬃራን ኢታባዛራን ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ይን፥ ኤዩንꬆ፥ ካታ ዛልቶ መꬍደ ጋንጭቶ መꬍዳይ ኤዛ ባነ? ");
INSERT INTO oyde_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","የዝን ቡርጩቆን ሻተን የዛኖ ዳሁንꬅስ እንጎተ። የ ዎደ ይንትስ ኡባ ባዝታ ጌሽ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«ፋርሳዉንꬆ ይንታና ባደ፥ ካርꬅ ጋላፓ፥ ጻሎተፓ፥ ይኒ ፋና የዘ ባዛፓ አስራታ ከሳነ። የዝን ጽሎትꬅን ጾዝ ካꬎ ይን ግዳ ባያ። መሉንꬃና አሽካይዛራ Ꮉንሳና ኦቾደስ ቤዛነ፥ የዝን አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«ፋርሳዉንꬆ ይንታና ባደ፥ አይሁደ ዎሳ ኬꬅተ ቦንቾ ኦይዳ፥ ጋበ ግዳ ቦንቾ ሳሮ ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«በስታ ꬋብን አሱንꬅ ኤርካይዛራ ካታራ የꬍዘ ቦዛ አዙንꬆ ይንታና ባደ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ህገ አስታማርዘ ማህ፥ «አስታማርዛዮ፥ ነ ይኖ ጋእተ ኑና ጫዣነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","የሱሳ፥ «ይን፥ ህገ አስታማሩንꬆ፥ ይንታና ባደ፥ አሱንꬅ ቶኮደስ ዳንዳኦሰ ዴጾ ቶፎ ቶሳነ፥ የዝን ይን ይን ኦምትስ መለ አቶ የዝን ግልአ በርꬃራን ግርሞስ። ");
INSERT INTO oyde_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«ይን አዱንꬅ ዎꬍደ ናቡንꬅ ቦዝቶ ይን ጊግዘ ግሾ ይንታና ባደ። ");
INSERT INTO oyde_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ይኬ፥ ይን አዱንꬅ ኦችቶ ምንꬆደስ ኡን ዎꬍደ ናቡንꬅ ቦዝቶ ይን ሎይꬅዘ ግሾ ኡን ኢታ ኦችትስ ይን ማርካ። ");
INSERT INTO oyde_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ይኒ ግሾ፥ ጾዚ ፋ ጭንጫትꬅተ፥ ‹ናቡንꬃናን ሐዋሩንꬃና ታ ይንትስ ኪቶዳ፥ የዝን ይን ባጉንꬃና ዎꬎዳ፤ መሉንꬃና ባይኦዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ይኒ ግሾ፥ Ꮉና የለቱንꬅ አላመ መꬍንትዳንፓ Ꮉኖ የሎደስ ጎግደ ናቡንꬅ ኡቡንꬅ ሱꬅትስ ኦጭንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","አቤላፓ ደንꬂ ዣርሾ በስትስን ጾዘ ኬꬃፓ ግዳ ጎግደ ዛካርያሳ ሱꬅት ግሾ Ꮉንꬅ የለቱንꬅ ኦጭንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«ህገ አስታማሩንꬆ፥ ይንታና ባደ፥ ኤራትꬅ ቁልፈ ይን ኩሸ አይክዳ፥ የዝን ይንትስን ገሎስ መሉንꬃናን ገልꬆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","የሱሳ የይጋፓ ቅቶደስ ከዘ ዎደ ህገ አስታማሩንꬅን ፋርሳዉንꬅ ኤራ እጽንት ኦጨራ ዋይꬃነ። ");
INSERT INTO oyde_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ኤ ዶንትፓ ከዘ ቃልተ ኤዛ አይኮደስ ኮይ ይኖ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","የ ዎደ ጋማ ሙኩላር ፋይድንትዘ አሱንꬅ ዎላል አፋ የꬍንቶደ ዎንꬅስ አስ አሳላ አፋ ሺቂ የሳደራ፥ የሱሳ ፋ ታማሩንꬃጎ፥ «ፋርሳዉንꬅ እርሽትፓ ናግንቶተ። ይናን ኡን ጩቦትꬅቶ። ");
INSERT INTO oyde_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ቆንጭካይዛር አችንት፥ ኤርንቶሰ ገንጊ አትዘባዝ አኮን ባያ። ");
INSERT INTO oyde_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ይኬ፥ ይን ꬉማ ኦህደባዝ ኡባ ፎኦ ስንቶዳ፥ ቆልአ ግዳ ካልካሽደ ባዝ ቆንጨ በሳ ኦህንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«ታ ባጉንꬆ፥ ታ ኦህዛኖ ስኦተ፤ አሾ ዎꬋነ ፋትን መለ አኮን ኦቾደስ ዳንዳኦሱንꬃና ዣሽትፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ዪኮን፥ ይን ዣሽቶደስ ቤዝዛ ታ ይንትስ ቆንጭሳዳ። ይናን ዎꬍዳንፓ ሱባ ጋናመ ኦሎደስ ዎልቃ የዘስ ኤስ ዣሽቶተ። ዬ፥ ቱሮ ጋነ፤ ኤስ ዣሽቶተ። ");
INSERT INTO oyde_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","እችን ቡቡንꬅ ፈቲ ሳንትመስ ባይዝንቶሳነ? ይኦፕ አትን ኡንታፓ ፈተን ጾዘ ቲንተ ቦትንቶስ። ");
INSERT INTO oyde_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","መለ አቶ የዝን፥ ይን ኦማ እስንꬅታን ፋይድንቲ የነ። ይኬ፥ ዣሽትፐተ፤ ጋማ ቡቡንꬃፓ ይን አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«ታ ኦህዛኖ ስኦተ፤ አስ ቲኖ ታስ ማርክꬍዘ ኡቡንꬅስ አስ ናአይ ጾዘ ኪታንቹንꬅ ቲንተ ማርክꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","አስ ቲኖ ታና ካድዘስ ጾዘ ኪታንቹንꬅ ቲንተ ታ ኤዛ ካዶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","አስ ናአላ አፋ ለቆ ቃላ ኦህዘ ኡቡንꬅ ማሮትꬅ ደማዳ፥ የዝን ጌሽ አያናላ አፋ ለቆ ቃላ ኦህዘስ ማርንቶስ። ");
INSERT INTO oyde_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«አስ ይንታና አይኪ አይሁደ ዎሳ ኬꬃ፥ ዳይኑንꬅ ቲንተን ካቱንꬅ ቲንተን ጎሽችዘ ዎደ አኮ ኦሆድየዛኮን ዋጊ ማሆድ የዛኮ ይርግፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","የ ዎደ ይን ኦሆደባዝ ጌሽ አያና ይንታና ታማርሶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","አስ ግዳፓ ፈቲ አስ የሱሳጎ ይእ፥ «ታ እሸ ታስ ኑ አዳይ ላታፓ ሻጎደ ፋና ኤስ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","የሱሳ ማህ፥ «ናተ አꬃዮ፥ ይንታላ አፋ ታና ዳይናን ላታ ሻክዘ ጭማ ማህደ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ማህካ የሱሳ፥ «አስ የስ ቆሎ ጋማትꬃራ ማቆሰ ግሾ ኢራ አሺ ምንꬂ ይንታና ናግንቶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ካሊ አዝዘራ፥ «ጋደ ጋማ ካꬃ እንግዘ ፈቲ ዱረ አꬄ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","የ አꬄ፥ ‹ታ ካꬅቶ ታ ሺሾደስ በሲ ኤርደ ግሾ አኮ ኦቾ?› ያጋእ ፋ ዎዝንተ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ይኬፓ የይሳዳ፤ ቲኖ የዘ ፋችቶ ላሊ መለ ዳልጊ ፋቻ ኬጾዳ። ካꬅቶን ታስ የዘ ባዝ ሙሎ እዘ ሺሾዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ፋ ሸምፕትጎ፥ ‹ታ ሸምፕተ፥ ጋማ በረስ ኔስ ማቃደ ቆሎ ሺሽዳ። ይኬ፥ ሸምፒ ሞኦ፥ ኡዦ፥ ኡፋይቶ› ያጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«የዝን ጾዚ፥ ‹ናተ፥ ኤያ Ꮉይ አꬃዮ፥ Ꮉይኖ ቃማ ነ ሸምፕታ ኔፓ ኤክንታነ። ይኬ፥ ነ ሺሽደ ባዝታ ኦደስ ማቃደ?› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«ይኒ ግሾ፥ ፋስ ዱረትꬅ ሳአ ሺሽዘ አስስ፥ ጾዘ ካለ ዱረ ማቆሰ አስስ ፎልታ Ꮉይ አꬄስቲ ፋና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ይንፓ ሱባ፥ የሱሳ ፋ ታማሩንꬃጎ፥ «ይኬ፥ ታ ኦህዛኖ ስኦተ፥ ይን ሸምፕትስ አኮ ሞኦ ይን ጋልትስ አኮ ማኦ ያጋእ ኡንእንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ሸምፖ ካꬃፓ ጋላ አፉላፓ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ላንዱንꬃና ቦኦተ ቡዶስ፥ ማጾስ፥ ኤለን ፋቻን ባያ። የዝን ጾዚ ኡንታና ሙዛነ። ይን ላንዱንꬃፓ ጋማ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ዬዝን፥ ይንታፓ ኡንእንት ፋ በርትላ አፋ ፈቲ ቃማ ጉጆደስ ዳንዳእዘ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ይኬ፥ Ꮉና ኤራꬅ ባዝቶ ኦቾደስ ዳንዳኦሰ ይን መለባዝስ አኮስ ኡንእንተ? ");
INSERT INTO oyde_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","አነ ፉ ዋይዝ ድጭዛኮ ቦኦተ። ዋዮስ ሱቆስ። መለ አቶ የዝን፥ ሶሎሞናን ፋ የዘ ቦንችተ ኡባነ ኡንታፓ ፈተ ጋርዛን ማእካያ። ");
INSERT INTO oyde_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ይን፥ አማኖ ፋጨዙንꬆ፥ ይኬ፥ ጾዚ Ꮉይኖ በንቲ ዎንታ ታማ ኦልንቶደ ፉዽቶ Ꮉንጋራ ማእስኮ፥ ይንታና ዋይዝ አꬂ ማእሶሶ? ");
INSERT INTO oyde_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ይኒ ግሾ፥ አኮ ሞኦ ዎይ አኮ ኡዦ ጋእ ኡን ዎዝንቶ እዝላ አፋ ማህፐ። ");
INSERT INTO oyde_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ይኖ ኡባ ጾዝ አማኖሰ አሱንꬅ ፋ ዎዝንቶ እዝላ ማሀነ። የዝን ይን አዳይ ጾዛይ ይና ኡባና ይንትስ ኮሽዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ኡባንፓ አꬂ ጾዘ ካእቱሞ ኮዮተ ይና ኡባና ይንትስ ጉጂ እንግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«ይን፥ ኤራꬅ ዎርዡንꬆ፥ ዣሽትፐተ፤ ይን አዳይ ጾዘ ካእቱምቶ ይንትስ እማደስ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ይንትስ የዘ ባዝ ባይዝ ዳሁንꬅስ እንጎተ። ካይዞ ኤኮሳነ፥ ብላ ሞኦሳነ፥ ጭንጎሰ ካርጥተ፥ Ꮉልኦሰ ቆልቶ ሳሎ ሺሾተ። ");
INSERT INTO oyde_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ይን ዎዝንታ ይን ቆልታ የዘ በስተ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«ዳንጭንቲ ጊግንቶተ፤ ይን ጾምፕታ ፎእዛኖ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ፋ ላꬄ ዣጋናፓ ማቃደ ዎንꬅስ ባርክ ናግዙንꬅ ፋና፥ ላꬂ ይእ ጼግዘ ዎደ ኤልሲ ቡጎደስ ጊግደ አሱንꬅ ፋና ይኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ፋ ላꬄ ማቅዘ ዎደ ገንትካይዛራ ናግዙንꬅ አንጅንትዱንꬃና። ቱሮ ጋነ፤ ላꬂ ዳንጪ ሌማተ ካለ በትꬂ ሞካነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ላꬂ ግዲ ብላሄ ማቅን ዎይ ዎንት ማ ማቅን ይእ፥ ይኒ ፋና ገንትካይዛራ ናግዝን ደንግደ የንꬅ አሩንꬅ አንጅንትዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","የዝን Ꮉኖ ኤሮተ፤ ካይዞ አይደ የኦድ የዛኮ ካርቲ አዳይ ኤርዛኮ ኬꬅቶ ቦክንትዘ ዎደ ስእ ጋእ ቦኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ይንትን ጊጊ ናጎተ፤ አስ ናአይ ይን ቆፕካይዘ ዎደ የኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ጴጥሮሳን፥ «ላꬆ Ꮉና አዝዝቶ ኑ ጻላላስ ኦህነነ ዎይ አስ ኡቡንꬅስ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ላꬂ ማህ፥ «ይኬ፥ ካꬃ ሙሳደስ ቤዘ ዎድተ እንጎደ ፋና ላꬄ ፋ አሩንꬃላ አፋ ሹምደ አማንꬅዛይን ዎዝናማ Ꮉላቅዘ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ላꬂ ማቅዘ ዎደ ይኒ ፋና ኦችተራ በንትዘ አርዘ ኤ አንጅንትዳያ ");
INSERT INTO oyde_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ታ ይንትስ ቱሮ ኦህነ፤ ፋ ላꬄስ የዘ ቆሎ ኡባንላ አፋ ኤ ሹምንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","የዝን የ አርዘ፥ ‹ታ ላꬃይ ኤለ የኦስ› ያጋእ ፋ ዎዝንተ ቆፒ፥ ማች አሩንꬃናን ꬊራꬅ አሩንꬃና Ꮉꬍኮ፥ ማህ ፋስ ኮይደ ፋና ሙእተራን ኡዥተራ ማꬅኮ፥ ");
INSERT INTO oyde_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","የ አርዘ ላꬄ ኤ ቆፕካይዘ ቃማን ይርጎሰ ዎደ የኦዳ። ይእ ኤዛ ጋቺ፥ ኤ እድልቶ አማኖሰ አሱንꬃራ ማሆዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«ላꬄ ቆፋ ጋራ ጊጎሰን ኤ ላꬄ አኮ ካꬍዛኮ ኤሪተ ኦቾሰ አርዘ ጋማ ጋራፍንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","የዝን ፋ ላꬄ ቆፍቶ ኤራንጺ አቲ ጋራፍንቶደስ ቤዛኖ ኦቼዘ ኤራꬅ ጋራፍንቶዳ። አኮስ ጋይኮ ጋማ እንግንትደፓ ጋማ ኮይንታነ፥ ጋማ Ꮉዳራ ኤክዱንꬃፓ ጋማ እንጎዳ ጋእ ናግንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«ታኒ ይእዳና ሳአላ አፋ ታማ አይꬆደስ። Ꮉተ ታማ አይክዛኮ ታና ዋይዝ ኡፋይሶድ የሻ! ");
INSERT INTO oyde_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ማቆ የዝን፥ ታ Ꮉተ ጻማቅንቶደ ጽንቃተ የነ። ኤ ፎልንቶደ ዎንꬅስ ታ ሸምፕታ ሸምፖስ። ");
INSERT INTO oyde_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ሳአላ አፋ ሳሮትꬅ ኮኦደስ ይእዳ ይንትስ አዛነ? ባያ፥ ታ ይእዳና ሻጎደስ። ");
INSERT INTO oyde_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ꮉተፓ አይኪ ዎል ግዳ ሻክንትደ እችን ኬꬅ አሱንꬅ ፈትላ የነ። ላምኡንꬅ Ꮉይꬑንꬃላ አፋ፥ Ꮉይꬑንꬅን ላምኡንꬃላ አፋ፥ ደንዲ ሻክንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","አዳይ ናእላ አፋ፥ ናእን አደላ አፋ፥ እንታ ናትላ አፋ፥ ናታ እንትላ አፋ፥ አዝንዘ እንታ ናዘ ማችትላ አፋ፥ ናአይ ማችታ አዝንዘ እንትላ አፋ፥ ደንዲ ሻክንቶዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ማንን አሱንꬃጎ፥ «አዋ ገሎ ዛላራ ሳሎ ꬎንꬍዘ ዎደ ብእ፥ ኤልሲ፥ ‹እራ የኦዳ› ያጋነ፥ ጋይደ ፋና Ꮉናነ። ");
INSERT INTO oyde_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ዬካ ዛላ ባቆ ባቂዘ ዎደ ‹ሳታ አዎዳ› ያጋነ፥ ጋይደ ፋና Ꮉናነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ይን፥ ጩቡንꬆ፥ ሳሎባዝን ሳአባዝ ሻኪ ኤራነ የዝን Ꮉና ዎድቶ ሻኪ ኤረ ይንታና ዋይዝ ጋምዶ? ");
INSERT INTO oyde_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«ዬዝን፥ ይን ኦምትስ አኮስ ቱርቶ ኤሪ ፍርዶሶ? ");
INSERT INTO oyde_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ነ ሞርክዘራ ዎላ ዳይና ቲኖ ኤቆደስ Ꮉንግተራ ኦገላ አፋ ጊጎደስ ኮዮ። ነ ጊጋንጽ እጽኮ ጎሽቺ ዳይና ቲኖ ነና ካንጎዳ። ዳይንዘ ነና ፖሊሰስ አꬂ እንጎዳ። ኤ ነና ዎይነ ኦሎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ስኦተ፥ ፈቲ ባካና አሽካይዛራ ጭጊ Ꮉሶደ ዎንꬅስ ነ እዝፓ ከዛማኖ ኤሮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","የ ዎደ የሱሳጎ አሱንꬅ ይእ ጵላጦሳ ዎꬊ ኡን ሱꬅትራ ኡን ዣርሽቶ ዎርቂደ ጋልላ አሱንꬅባዝ ኦህደ አሱንꬅ ይና በስተ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ኤ Ꮉንጋራ ያጋእ ማህዳ፤ «ዬዝን የንꬅ ጋልላ አሱንꬅ ይና ኢታ Ꮉይቅቶ Ꮉይቂደ ግሾ ጋልላ ግዳ የዘ አስ ኡባንፓ አꬍደ ናጋራንቾ አዛነ? ");
INSERT INTO oyde_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ባያ! ማቆ የዝን፥ ይንትን ማሮትꬃር ማቃንጽ እጽኮ፥ ኡባና ይኒ ጋራ ꬋቦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ዎይ ማህ ሳልሆመ ጋዘ በስተ ግምበ ዎዲ ዎꬍደ ታጶ ኦስፉን አሱንꬅ የሩሳላመ የዘ አስ ኡባንፓ አꬍዘ ናጋራንቾ አዛነየሻ? ");
INSERT INTO oyde_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ባያ! የዝን ይንትን ማሮትꬃር ማቃንጽ እጽኮ ኡባና ይኒ ጋራ ꬋቦዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ማህን የሱሳ Ꮉንጋራ ጋእ አዝዘ ኦህዳ፦ «ፈቲ አꬄስ ዎይነ ጋደ ቱክንትደ በለሰ ምንጻ የነ። ኤ ኢፓ ኣፈ ኮይ ይእ አኮን ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ጋድቲ አዳይ ዎይነ ኦችዘጎ፥ ‹ኣፈ ደንጎደስ ኮይ Ꮉይꬕ በረ ይእ ብእን አኮን ደንግካያ። ይኒ ግሾ፥ ጋቺ Ꮉሶ፤ አኮስ ሳእቶ መልዘ?› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«የዝን ኦችዛይ፥ ‹ላꬆ፥ እ ካንቶ ኦቺ ኦዣ ኦሎደ ዎንꬅስ Ꮉይ በርዘስ አሾያ። ");
INSERT INTO oyde_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ዎንꬅ በረ ኣፍኮ ሎኦ፥ እጽኮ ጋቺ አሾ› » ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","የሱሳ ሳምባታ ቃማ አይሁደ ዎሳ ኬꬃ ታማርሳነ። ");
INSERT INTO oyde_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ይና በስተ ታጶ ኦስፉን በረ ቱና አያና ባንቶ ኩንዝደ ፈቲ ማችታ የነ። እዛ ኩንዳንፓ ደንዲ ሉለ ኤቆደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","የሱሳ እዞ ብእደ ዎደ ጼጊ፥ «Ꮉና ማችተ፥ ነ Ꮉርግትፓ ፋጽዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ፋ ኩሽቶ ኢላ አፋ ጋድን፥ እዛ ኢራ ሉለ ኤቅዳ። ጾዝ ማና ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","የዝን አይሁደ ዎሳ ኬꬃ Ꮉላቅዘ ዥልꬊ አስትጎ፥ «ኦቻ ኦችዘ እዝፑን ቃምታ የነ። ይኒ ግሾ፥ ይና ቃምተ ይእ ፋጾተ ፋትን ሳምባታ ቃማ ኮሾስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ላꬂ፥ «ጩቡንꬆ፥ ይን ግዳፓ ቦራ ዎይ Ꮉሪ ሳምባታ ቃማ ዛዳሎፓ ብሊ Ꮉꬅ ኡሾደስ ካንጎሰ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ዬዝን፥ Ꮉና ማችታ አብራሃማ ናአ ማቅተራ ጻላሄራ አጭንቲ ታጶ ኦስፉን በረ ኩሙꬅ የዝዳንስ ሳምባታ ቃማ ብልንቶደስ ቤዞሳነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ኤ ይኖ ኦህደ ዎደ እጽዙንꬅ ኡባ ዬሊꬍዳ። የዝን አሱንꬅ ኡባ ኤ ኦችደ ጋማ ቆፍዘ ኦቻ ኡባነ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ይንፓ ሱባ፥ የሱሳ Ꮉንጋራ ያጋይዳ፥ «ጾዘ ካእቱምቶ አኮ አዘ? እዞ አኮራ አዝሳደ? ");
INSERT INTO oyde_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ጾዘ ካእቱሞ ፈቲ አስ ፋ ጋድተ ቱክደ ዋላ ኣፈ ፋና። ኤ ድጪ ምንጻ ማቅዳ። ላንዳ ኤ ኮሽትላ አፋ ሸምፕዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ማህ፥ «ጾዘ ካእቱምቶ አኮራ አዝሳደ? ");
INSERT INTO oyde_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ፈቲ ማችታ ጋማ ꬊላራ ዎርቂ ሙኑቅደ ኤራꬅ እርሾ አዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ይንፓ ሱባ፥ የሱሳ የሩሳላመ ቅትተራ ኤ አꬍዘ ኦግተ የዘ ካታምተን ካራ ጋንጨን ታማርስተ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ፈቲ አስ የሱሳጎ፥ «ላꬆ፥ አቶዱንꬅ ኤራꬅ አስ ጻላላነ?» ጋእ ኦጭዳ። የሱሳ ኡንታጎ፥ ");
INSERT INTO oyde_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«ስኦተ፥ ጹንꬅ ፉርꬃራ ገሎደስ ምንጎተ። ጋሙንꬅ ገሎደስ ኮያነ የዝን ኡንትስ Ꮉኖስ። ");
INSERT INTO oyde_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ካርቲ አዳይ ደንዲ ፉርꬅቶ ጎርድዳንፓ ሱባ ‹ኑስ ቡጎያ› ጋእ ባለ ኤቂ ጼገ አይኮዳ። የዝን ኤ፥ ‹ይን ኦና የዛኮን አባፓ የኤዛኮን ታ ኤሮስ› ጋእ ማሆዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","የ ዎደ ይን፥ ‹ኔራ ዎላ ሙእዳ፥ ኡዥዳ፥ ኑ ቡጫላ ታማርስዳ› ያጋውዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«ኤ ማህ፥ ‹ይን ኦና የዛኮን አባፓ የኤዛኮን ኤሮስ። ይን፥ ዎቡንꬆ ታፓ Ꮉኮተ› ያጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","አብራሃማ፥ ይሳቃ፥ ያይቆባን ናቡንꬅ ኡቡንꬅ ጾዘ ካእቱምተ ቦኦዳ፥ የዝን ይን ባለ ዎꬊ አትዘ ዎደ ይንትስ ዬፎን አች ጋርጭንጌ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","አሱንꬅ አዋ ከሳፓ፥ አዋ ገሎፓ፥ ዎካ ዛላፓን ዬካ ዛላፓ ይእ ጾዘ ካእቱምተ ሙሳላ አፋ በቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ይኒ ግሾ፥ Ꮉተ የስተ ሱብ ማቅዱንꬃፓ ቲኖ ማቃዱንꬅ፥ ቲኖ ማቅዱንꬃፓ ሱብ ማቃዱንꬅ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","የ ዎደ ፋርሳዉꬃፓ ፈተ ፈተ ይእ፥ «ሄሮድሳ ነና ዎꬎደስ ኮይዘ ግሾ Ꮉና በስትፓ ደንዲ ቅቶ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ኤ ማህ፥ «Ꮉንግ፥ የ ዎርካንዘስ ይኬ፥ ‹Ꮉይኖን ዎንታ ቱና አያኑንꬃና ከሶዳ፥ Ꮉርግንትዙንꬃና ፋꬆዳ፥ Ꮉይꬓንꬆ ቃማ ፎሎላ አፋ የሎዳ› ያጋይዳ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ይኦፕ አትን፥ ናበ የሩሳላመፓ መለ በሳ Ꮉይቆደስ ቤዞስ። ይኒ ግሾ፥ Ꮉይኖን፥ ዎንታን ይንቶን ፌዢ ይና በስቶ ቅቶደስ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«የሩሳላመ፥ የሩሳላመ፥ ናቡንꬃና ዎꬍዛነ፥ ኔጎ ኪትንትዱንꬃና ሹቻራ ዎꬍዛነ፥ ሉኩለ ፋ ናኡንꬃና ፋ ቀፍት ጋንጨ ሺሽዛንፋና ነ ናኡንꬃና ታ ኩሽትፓ ኦሞራ ዋንꬅ ቶሄ ሺሾደስ ኮይዶ፥ የዝን ይን ኮዮስ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ታ ይንትስ ኦህነ፤ ይን ኬꬅታ ካይዞዳ። ላꬄ ሱንꬅተ የእዘ አንጅንትዳያ ይን ጋዉደ ዎንꬅስ ታና ደንጎስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ፈቲ ሳምባታ ቃማ የሱሳ ፈቲ ፋርሳዉንꬅ Ꮉላቅዘ ካራ ካꬃ ማአደስ ገልዘ ዎደ አሱንꬅ ዳኪ በእነ። ");
INSERT INTO oyde_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ይና በስተ ሻፈ ዎዳꬅ Ꮉርግንትዘ ፈቲ አስ ኤስ ቲኖ ዛላራ ዎይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","የሱሳ ፋርሳዉንꬃጎን ህገ አስታማሩንꬃጎ «ሳምባታ ቃማ Ꮉርግንትዛ ፋꬅዛና ዎጋነ ዎጋ ባ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ኡን ስእ ጋይዳ። የሱሳ Ꮉርግንትዘ አꬃ ቦቺ ፋꬂ ሞይዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ማህን ይንታፓ ፈተስ ናአ ዎይ ቦራ ሳምባታ ቃማ ጋጋ ቅትኮ ኤልሲ ከሶሰ ኦደ? ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ኡን ፈትባዝን ማሆደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","የሱሳ ሳርገስ ጼግንትዱንꬅ ቦንቾ በሲ ዶርዛኖ ብእ፥ Ꮉና አዝዝቶ ኦህዳ፦ ");
INSERT INTO oyde_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«ፈቲ አስ ነና ሳርገ ጼግኮ ቦንቾ በሳ በትፐ። ኔፓ አꬊ ቦንችንትዘ አስ ጼግንቶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ይንታና ላምኡንꬃና ጼግደ ይእ፥ ‹ነ በስቶ Ꮉይ ዛቂዘስ ዳኮ› ያጋዘ ዎደ ነ ዬልꬍተራ ዝቃ በሳ ዎꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","የዝን፥ ነ ጼግንትደ ዎደ ቲንꬊ ዝቃ በሳ ብእ በቶ። ጼግዘ ይእ፥ ‹ታ ላግዛዮ፥ Ꮉና ቦንቾ በስተ በቶ› ያጋኦዳ። የ ዎደ ኔራ ፈትላ ጼግንትደ አስ ኡቡንꬅ ቲንተ ነ ቦንችንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ፋና ꬎቅ ꬎቅ ዪዘ ኡባና ዬልꬋዳ፤ ፋና ዝቂ ዝቂ ዪዘ ኡባና ꬎቅ ꬎቅ ጋኦዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ማህ የሱሳ ኤዛ ሞክደ ኬꬅት አደጎ፥ «ቁማ ዎይ ካዎ ሳርገ ጼግዘ ዎደ ኔኒ ኩሸ ማህዛ ጼጋመ ፋና ነ ላጉንꬃና ዎይ ነ እሹንꬃና ዎይ ነ እግኑꬃና ዎይ ነ ዱረ ዶꬁንꬃና ሳርገ ጼግፐ። ");
INSERT INTO oyde_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","የዝን፥ ነ ሳርገ ጊግዘዘ ዎደ ዳሁንꬃና፥ ዎቡንꬃና፥ ጉንድዱንꬃና ቆቁንꬃና ጼጎ፤ ነ አንጅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ꮉንስ ኩሸ ማሆደስ ዳንዳኦሰ ግሾ ኩሸ ማህታ ጌሹንꬅ ደንድዘ ቃማ ኔስ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","የሱሳራ ዎላ ድግሳላ አፋ በትዙንꬅ ግዳፓ ፈተ ይኖ ስእ፥ «ጾዘ ካእቱምተ ድግሳላ አፋ በትደ አንጅንትዳያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","የሱሳ፥ «ፈቲ አስ ዳማ ድግሳ ጊግዚ ጋማ አሱንꬃና ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ድግሳ ሞኩንትዘ ሳታ የልደ ዎደ ጼግንትደ ዛቁንꬃና፥ ‹ይኬ ኡባ ባዝታ ጊግዳ፥ Ꮉይጋ ዮኦተ› ያጋእ ጼጎደ ጋር ፋ አርዛ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«የዝን ኡቡንꬅ ፋስ ማꬋ ማꬋ መꬍዳ። ፈተ፥ ‹Ꮉተ Ꮉጋ ጋደ ዎንግደ ግሾ Ꮉንግ በአደስ ቤዛነ አደ ታና አሾያ ያጋኦ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ꮉንካይ፥ ‹እችን ዋጻ ቦራ ዎንግዳ ኡንታና ዋጺ በአደ ግሾ አደ ታና ላንጭፐ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ማህ Ꮉንካይ፥ ‹ታኒ Ꮉጋ መዳ የዘ ግሾ የኦደስ ዳንዳኦስ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«አርዘ ማቂ ይእ ይና ኡባኖ ፋ ላꬄስ ኦህዳ። የ ዎደ ድግሳ አዳይ ዥልꬊ አርዘጎ፥ ‹ኤልሲ ካታማ የዘ ዳልጋ ኦገን ኦገ ጋጻ Ꮉንግ፥ ዳሁንꬃና፥ ዎቡንꬃና፥ ቆቁንꬃናን ጉንዱንꬃና Ꮉንካ ኮኦ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«አርዘ፥ ‹ታ ላꬃዮ፥ ነ ኪትደ ኡባና ፎልንትዳ፥ የዝን Ꮉተን በሲ የነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«ላꬂ አርዘጎ፥ ‹ኦገ ዎራላ አፋን፥ ካታማፋ ጋጻ ከስዘ ኦገ ከዞ፥ ታ ኬꬅታ ኩሞደ ዎንꬅስ ደንግደ ኡቡንꬅ የኦደ ፋና ኦቾ። ");
INSERT INTO oyde_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ታ ይንትስ ኦህነ፤ ጼግንት እጽዱንꬃፓ ኦደን ታ ድግስትፓ ሞኦሳኖ ኤሮተ› ጋይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ጋማ አሱንꬅ ኤራ ዎላ Ꮉማደራ የሱሳ ኡንታጎ ሱብ ማቂ፥ ");
INSERT INTO oyde_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ታጎ ይእደ ኡቡንꬅ ፋ አዳያን ፋ እንቶን፥ ፋ ማችቶን ፋ ናኡንꬃና፥ ፋ እሹንꬃና ፋ ምሹንꬃና፥ መለ አቶ የዝን ፋ ደእቶ እጾሰ ታ ታማረ ማቃደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ፋ ማስቃልቶ ቶኪ ታና ካሎሰ ታ ታማረ ማቃደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«ይንታፓ ፈቲ አስ ሹች ኬꬂ ኬጾደስ ኮይኮ፥ ኬꬅቶ ኬጺ Ꮉሶደስ አኮ ጋር ሚሸ ኮሽዛኮ ቲንꬊ ኤሮደስ ቆፒ ቦኦሰ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ይኖ ማቃንጽኮ፥ የ አꬄ ባሳ ዪꬅ ሹችቶ ዪጽን ፎለ ጋምኮ፥ ");
INSERT INTO oyde_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","በእዘ ኡባና፥ ‹Ꮉይ አꬄ ኬꬅ አይክን ፎሎደስ ኤዛ ጋምዳ› ያጋእ ለቃነ። ");
INSERT INTO oyde_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«ዎይ ፈቲ ካት መለ ካታራ ኦልንቶደስ ደንድተራ ላምእታም ሙኩል ዎታዳሩንꬃና ኤኪ የእዘ ካትዘራ ታጵ ሙኩል ዎታዳሩንꬃራ ኦልንት ዳንዳኦዳኖን ዳንዳኦሳኖ በቲ ዞርንቶሰ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ኦልንቶደስ ዳንዳእንቶሰባዝ ማቅኮ፥ የ የእዘ ካትዘራ Ꮉኮራ የዝን ጊጎደስ ቲንꬊ ጭማ ዳኪ ኦጫነ። ");
INSERT INTO oyde_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ይኒ ጋራ፥ ይንታፓ ኦደን ፋስ የዘ ባዝ ሙሎ አሻንጺ እጽኮ ታ ታማረ ማቃደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«ሶገ ሎኦ፥ የዝን ሶገ ፋ ማልእቶ አሽኮ፥ ዋይዝ ሶገ ጋእንቶደስ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ጋደ አራድዘስን ማዶሰ ባዝ ማቅዘ ግሾ አላ ኦልንታነ። ይኬ፥ ስእዘ Ꮉየ የዘ አስ ስኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ፈቲ ዎደ ቃራጠ ጋችዙንꬅን ናጋራንቹንꬅ የሱሳ ትምርትቶ ስኦደስ ኤ ካለ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","የዝን ፋርሳዉንꬅን ህገ አስታማሩንꬅ፥ «Ꮉይ አꬄ ናጋራንቹንꬃና ሺሺ ኤካነ፥ ኡንታራ ፈትላ ሙነ» ያጋእ ዙዝንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","የሱሳ ያጋእ Ꮉና አዝዝቶ ኡንትስ ኦህዳ፦ ");
INSERT INTO oyde_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ይን ግዳፓ ፈተስ ጼት ዱሩንꬅ የዘ ባዝ ማቅኮ ኡንታፓ ፈታይ ꬋብኮ ኡዱፉን ታም ኡዱፉኑንꬃና የንግዘ በሳ አሺ ꬋብዳያ ደማደ ዎንꬅስ ኮዮሰ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ደንግደ ዎደ ኡፋይት ፋ ጋንተ ቶኪ፥ ");
INSERT INTO oyde_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ፋ ካራ ማቃነ። ፋ ላጉንꬃናን ዶꬁንꬃና ፈትላ ጼጊ፥ ‹ꬋብደ ታ ዱርዛ ደንግዳ፥ ታራ ፈትላ ኡፋይቶተ› ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ይኒ ጋራ፥ ማሮትꬅ ኮሾሰ ኡዱፉን ታም ኡዱፉን ጽሉንꬃፓ አꬂ ማሮትꬅ ገልዘ ፈቲ ናጋራንችዘ ግሾ ሳሎ ዳማ ኡፋይስ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«ዎይ ታጵ ሹች ብራ የዘ ፈቲ ማችታ ታጵትፓ ፈቲ ሹች ብርዘ ꬋብኮ ደንጎደ ዎንꬅስ ጾምፐ አይꬂ ኬꬂ ፍጺ ምንꬂ ኮዮሳና ኦደ? ");
INSERT INTO oyde_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ደንግደ ዎደ ፋ ላጉንꬃናን ፋ ዶꬁንꬃና ጼጊ ‹ꬋብደ ታ ፈቲ ብርዛ ደንግደ ግሾ ታራ ኡፋይቶተ› ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ስኦተ፥ ይኒ ፋና ፈቲ ማሮትꬅ ገልዘ ናጋራንችዘ ግሾ ጾዘ ኪታንቹንꬅ ቲኖ ኡፋይስ ማቃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ማህ የሱሳ፥ «ፈቲ አꬄስ ላምእ ናኡንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ኡንታፓ ጌዝ ናአይ ፋ አደጎ፥ ‹ታ አዳዮ፥ ነ ቆልትፓ ታ ግሽቶ ታስ እንጎ› ያጋይዳ። አዳይ ፋ ቆልቶ ፋ ናኡንꬅስ ግሽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ኤራꬅ ቃማፓ ሱባ ጌዝ ናአይ ፋ ግሽቶ ሙሎ አጪ ኤኪ Ꮉኮ ሳአ ቅትዳ። የይጋ ካሳራ ቆልቶ ላሊ Ꮉስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ኤ ፋስ የዘባዝቶ ሙሎ Ꮉስዳንፓ ሱባ ይና ሳእተ ኡባነ ምንꬂ ናየ ከዝን ማꬍꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ይኒ ግሾ፥ ይና ሳእተ አሱንꬃፓ ፈተ ካራ የሳደስ ገልዳ። አꬃይ ኤዛ ጉዳይለ የማደ ጋር የንግዘ በሳ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ጉዳይሉንꬅ ሙእዘ Ꮉርቆፓ ማአደስ አሙꬍዳ፥ የዝን እዞን ኤስ እንግዘ አስ በንትካያ። ");
INSERT INTO oyde_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ዎዝና ማቅን፥ ‹ዋንꬅ ታ አዳይ አሩንꬅስ ካꬃ አላ አትን ታ Ꮉነ ናየራ Ꮉይቆደስ የልዶ?› ");
INSERT INTO oyde_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ደንዲ ታ አደጎ Ꮉንግ፥ ‹ታ አዳዮ፥ ጾዝን፥ ነናን ቆህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ይኬፓ ነ ናአ ጋእንት ጼግንቶደስ ታስ ቤዞሰ ግሾ ነ ካራ የዘ አሩንꬃፓ ፈታይ ፋና ታና ፋይዶ› ያጋኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ይኒ ግሾ፥ ደንዲ ፋ አደጎ ቅትዳ። «ዪኮን፥ ኤ Ꮉጋ Ꮉኮራ የዝን አዳይ ይቅስንቲ፥ ኤጎ ዎጺ Ꮉንግ እርንግ ዬሪዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ናዘን፥ ‹ታ አዳዮ ጾዝን፥ ነናን ታ ቆህዳ። ይኬፓ ነ ናአ ጋእንት ጼግንቶደስ ቤዞስ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«ኤ አዳይ አሩንꬃና ጼጊ፥ ‹ኤልሲ ኡቡንꬃፓ ሎኦ ማቅደ ማኦ ክእ ኤዛ ማይዞተ፤ ኤ ግልእተ ምግዶ፥ ኤ ቶህተ ጫማ ኣꬆተ። ");
INSERT INTO oyde_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ሞꬎ ዎፋኖ ክእ ሹኮተ፥ ማአዳ፥ ኡፋይቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ታ ናአይ Ꮉይኒ Ꮉይቂዳ፥ የዝን Ꮉተ ፋጽዳ፤ ꬋብዳ፥ የዝን በንትዳ› ያጋይዳ። ይንፓ ሱባ፥ ኡፋይተ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«የ ዎደ አንግስ ናአይ ኦቻ ጋደ የነ። የይጋፓ ይእተራ ካራ ኡኮደራ የꬂን ዶለ ኦꬅ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ኤ፥ አሩንꬃፓ ፈታ ጼጊ Ꮉንደ ባዝታ አኮ የዛኮን ኤሮደስ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","አርዘን፥ ‹ነ እሸ ሳሮ ይእደ ግሾ ነ አዳይ ሞꬎ ዎፋኖ ኤስ ሹክዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«አንግስ እሸ ዥልꬊ ኬꬃ ገሎደስን ኮይካያ። አዳይ ባለ ኬዚ ኬꬃ ገሎደ ፋና ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","የዝን ኤ ፋ አደጎ፥ ‹ይኬ፥ Ꮉኒ ጋር በረ ታ ኔስ አርꬊ ነ ኪትፓ ፈቶን ፋጭዝካይዛራ ኔስ ኪትንትን ታ ታ ላጉንꬃራ ኡፋይቶደ ፋና መለ አቶ የዝን ፈቲ ጋሸ ዴሽ እንግካያ። ");
INSERT INTO oyde_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","የዝን፥ Ꮉይኒ ነ ናአይ ነ ቆልቶ ኦላሉንꬃራ ላሊ ይእን ሞꬎ ዎፋኖ ሹክዳ› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«አደን፥ ‹ታ ናአዮ፥ ኔኒ ኡባ ዎደ ታራ የነ፥ ታ ባዝ ኡባና ኔስ። ");
INSERT INTO oyde_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ꮉይኒ ነ እሸ Ꮉይቂዳ፥ የዝን ፋጽዳ፤ ꬋብዳ፥ የዝን በንትዳ። ይኒ ግሾ፥ ጋማ ኡፋይቶደስ ቤዛነ› ያጋኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","የሱሳ ፋ ታማሩንꬃጎ፥ «ፈቲ ዱረ አꬄስ ኤፓ ዬካራ ፈቲ ሹማ የነ። የ ሹምዘ ፋ ላꬄ ቆልቶ ላላነ ያጋዘ ዎረ ካርቲ አዳያ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ካርቲ አዳይ ሹምዛ ጼግዝ፥ ‹ታ ዋግዘባዝ ስእዶ? ይኬፓ ኔኒ ታ ኬꬅትስ ሹማ ማቂ ኦቾደስ ዳንዳኦሰ ግሾ ታ ቆልቶ ታና የልꬆ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«የ ሹምዘን ፋ ዎዝንተ Ꮉንጋራ ያጋእ ቆፕዳ። ‹ታ ላꬃይ ታና ሹማትꬅትፓ Ꮉሶደስ ይእነ፥ ዎት አቆደስ ዎልቃ ባያ፥ ዎሲ ማአደስ ዬልዛነ፤ ዬዝን ታ ዋያ? ");
INSERT INTO oyde_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ሹማትꬅትፓ ታ ዎꬍዘ ዎደ አሱንꬅ ታና ሞኮደ ፋና ኦቾደ ባዝ ታ ኤራነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«ይኒ ግሾ፥ ኤ ላꬄ ጋለ የዘ አሱንꬃና ፈታ ፈታ ጼጊ ክእ ቲኖ አꬄጎ፥ ‹ኔላ አፋ ታ ላꬄ ጋለ ዋንꬅ የዘ?› ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«ኤ፥ ‹ላምእታም ባርሜለ ዛይተ ጋለ የነ› ያጋይዳ። «ሹምዘ፥ ‹ዉለ ዋርቃተ Ꮉተ፥ ኤልሲ፥ ታጵ ባርሜለ ዛይተ ጋለ የነ ጋእ ጻፎ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«ይንፓ ካሊ ላምአንꬅዘጎ፥ ‹ኔስ ዋንꬅ የዘ?› ያጋይዳ። «ኤ፥ ‹370 ኩንታለ ዛርጋ ጋለ የነ› ያጋይዳ። «ሹምዘ፥ ‹ነ ዉለ ዋርቃተ Ꮉተ፥ ኤልሲ፥ 296 ኩንታለ ያጋእ ጻፎ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ካርቲ አዳይ አማንንትካይዘ ሹምዛ ኤ ጭንጫትꬅትስ ናሽዳ። Ꮉና አላምት ናኡንꬅ አስ አይፎራ ፎኦ ናኡንꬃፓ አꬍደ ዎዝናማ። ");
INSERT INTO oyde_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«ይኒ ግሾ፥ ታ ይንትስ ኦህነ፤ Ꮉና አላምት ብራ Ꮉልእዘ ዎደ መዽና ኬꬅተ ሞክንቶደ ፋና Ꮉና ሚሽትራ ይንትስ ላገ ዎንጎተ። ");
INSERT INTO oyde_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ኡባፓ ኤራꬅ ባዛ አማንንትደ ጋማ ባዛ አማንንትዳያ ማቃነ። ማህ ኡባፓ ኤራꬅ ባዛ አማንንቶሰ ጋማ ባዛ አማንንቶስ። ");
INSERT INTO oyde_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ይኬ፥ Ꮉና አላምት ብራራ ይን አማንንታንጺ እጽኮ ቱሪ ብራ ይንትስ ኦደ Ꮉዳራ እማደ? ");
INSERT INTO oyde_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ይን መለ አስ ብርተ አማንንታንጽኮ፥ ይን ቡዞ ብራ ይንትስ ኦደ እማደ? ");
INSERT INTO oyde_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«ፈቲ አርዘ ላምእ ላꬁንꬅስ አቆደስ ዳንዳኦስ። ፈታ እጽኮ Ꮉንካያ ካꬋነ ዎይ ፈተጎ ሺቅኮ Ꮉንካያ ለቃነ። ይኒ ጋራ፥ ይን ጾዝስን ብራስን አቆደስ ዳንዳኦስ።» ");
INSERT INTO oyde_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ብራ ካዽዘ ፋርሳዉንꬅ ይኖ ስእ የሱሳ ለቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ኤ፥ «ይን ይንታና አስ ቲኖ ቤዛነ፥ የዝን ጾዚ ይን ዎዝንቶ ኤራነ። አስ ቲኖ ቦንችንትዳይ ጾዘ ቲኖ ቦሩንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«ሙሴ ህግታን ናቡንꬅ ኪታ ዋሐንሳ የሎደስ ይንትስ ኦችተራ ጋምእዳ። ይንፓ ሱባ፥ ጾዘ ካእቱሞ ዎንገልታ ሳባክንትተ ጋምእዳ። አስ ኡባ የይጋ ገሎደስ ዳፍንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","የዝን፥ ህግትፓ ፈቲ ይሻ ፍዳለ አቶዳንፓ ሳሎን ሳአን አꬍዛና ላፋነ። ");
INSERT INTO oyde_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«ፋ ማችቶ ዳኪ መለ ኤክዘ ኡባ ኦላላነ። ፋ አዝንዘፓ አንጅንትዳኖ ኤክዛይን ኦላላነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«አልኦን ሎኦ ቦንቾ አፉላ ማእዘ፥ ሳአ ጊግን ኡባ ዎደ ኡፋይሳራ የዘ ፈቲ ዱረ አስ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","መለ ማህ ጋልታ ኩሙꬅ Ꮉርግꬅ ማቅደ ፈቲ አላዛረ ጋእንትዘ ዳህዘ የ ዱረ አꬄ ባለ ኦልንት አትዳይ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ናየፓ ደንዲ ዱረ አꬄ ሌማትፓ ዎꬍዘ ጉፋ ማአደስ አሙꬊ የነ። መለ አቶ የዝን፥ ካኑንꬅ ይእ ኤ Ꮉርግꬅ በስቶ ላአነ። ");
INSERT INTO oyde_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«የ ዳህዘ Ꮉይቂዳ፤ ኪታንቹንꬅ ኤዛ አብራሃማ ሹጵተ ኤክዳ። ማህ ዱረ አꬄን Ꮉይቂ ሞግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ስኦለ ኡንእንት የዝተራ ꬎቅ ጋእ Ꮉኮራ አብራሃማን ኤ ሹጵተ የዛ አላዛረ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ኤ፥ ‹አቦ አብራሃማ፥ ታስ ይቅስንቶያ፤ Ꮉና ሎጽዘ ታምተ ኡንእንት የዘ ግሾ አላዛረ ፋ ግልእዛ Ꮉꬃ ዳኪ ታ እልአንꬅቶ ላክꬆደ ፋና አደ ኤዛ ዳኮያ› ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«የዝን አብራሃማ ኤጎ፥ ‹ታ ናአዮ፥ ነ ሳአ የዘ ዎደ ሎኦ ባዝቶ ኤክዳኖ፥ ማህ አላዛረ ኢታ ባዝ ኤክዳኖ ቆፖ። የዝን Ꮉተ ኤ Ꮉነ ኡፋይታነ፥ ማህ ነ ዋይንት የነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ꮉና ኡባንፓ አꬊ፥ ‹Ꮉይጋፓ ይንታጎ፥ ሰካፓ Ꮉንካ ኑጎ አꬎደስ ኮይዙንꬅ ፍንጋመ ፋና ኑስን ይንትስ ግዳ ዳማ ጋጋ የነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«ዱረ አꬄ፥ ‹ታ አዳዮ፥ ዬዛኮ አላዛረ ታ አዳይ ካራ ኪቶደ ፋና ታ ነና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ታስ እችን እሹንꬅ የነ፥ ኡንትን Ꮉና ማꬋ በስተ የአመ ፋና ኡንትስ ዎꬊ ማርክꬎ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«የዝን አብራሃማ፥ ‹ኡንትስ ሙሴን ናቡንꬅን የነ፤ ኡን ኦህዛኖ ስኦ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«ዱረ አꬄ፥ ‹አቦ አብራሃማ፥ ይኒ ፋና ባያ፤ ፈቲ አስ Ꮉይቆፓ ደንዲ ዎꬍኮ ኡን ማሮትꬅ ገሎዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«አብራሃማ፥ ‹ሙሴን ናቡንꬅና ስአንጽኮ፥ መለ አቶ የዝን Ꮉይቆፓ ፈቲ አስ ደንዲ ኦህኮን አማኖስ› ያጋይዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","የሱሳ ፋ ታማሩንꬃጎ፥ «አስ ꬉቡꬅ ናጋራ ገልꬅዘባዝ ይእካይዛራ አታማ። ማቅኮን፥ ናጋራ ግዳ ገሎደ ፋና ኦችዘ አꬃ ባደ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","የ አꬄ ኤራꬁንꬃፓ ፈታ ባልꬆዳንፓ ዎጻ ፋ አፉርተ አጪ አባ ገልኮ ኤስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ይኒ ግሾ ናግንቶተ። «ነ እሸ ናጋራ ኦችኮ ካጮ፤ አዛኒ ማሮትꬃር ማቅኮ፥ ኤስ አቶ ያጋኦ። ");
INSERT INTO oyde_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ፈቲ ቃምተ ላፑን ቶሄ ቆሂ፥ ላፑን ቶሄ፥ ‹ታኒ ታ እስዳኖ ኤርዳ ታና ማሮ› ያጋእ ኔጎ ዪኮ ኤስ አቶ ጋኦ።» ");
INSERT INTO oyde_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ሐዋሩንꬅ ላꬃጎ፥ «አማኖ ኑስ ጉጆያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ላꬂ፥ «ጋሸ ኣፈ ፋና አማኖ ይንትስ የዝኮ ‹Ꮉይ ዋልዛ ሾድንት አባ ግዳ ቱክንቶ› ያጋይኮ ይንትስ ኪትንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ጉጂ የሱሳ፥ «ይን ግዳፓ ፈተስ ኦችዘ ዎይ ዱሮ የንግዘ አሮ የዝኮ ኦቻ ጋደፓ ዎይ ዉደፓ ካራ ይእደ ዎደ ‹ኤለ Ꮉይጋ ይእ ካꬃ ማአደስ በቶ› ጋዘ የነ? ");
INSERT INTO oyde_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ባያ፥ ‹ታስ ካዎ ጊግዞ፤ ታ ሙእ፥ ኡዢ አሾደ ዎንꬅስ ኤቂ ሙዞ። ይንፓ ሱባ፥ ነ ሙእ ኡሻዳ› ያጋኦሳነ? ");
INSERT INTO oyde_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ይኬ፥ ላꬄ፥ አርዘ ኪቶ ፎልደ ግሾ አንጃነነ? ");
INSERT INTO oyde_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ይኒ ግሾ፥ ይንትን ኪትንትዳኖ ሙሎ ፎልደ ዎደ ‹ኑ ፋꬆሰ አሩንꬃና፤ ኦቾደስ ቤዘ ኦችቶ ፎልዳ› ያጋኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","የሱሳ የሩሳላመ Ꮉንግተራ ሳማራስን ጋልላ ሳአስን ግዳራ ካንꬂ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ፈቲ ካራ ጋንጨ ገልዘ ዎደ ቁርሱማ Ꮉርገራ አይክንትደ ታጵ አሱንꬅ ኤዛ ደንግዳ። ኡንትን Ꮉኮራ ኤቂ፥ ");
INSERT INTO oyde_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«ላꬅ የሱሳ፥ ኑስ ይቅስንቶያ» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ኤ ኡንታና ብእደ ዎደ «Ꮉንግ ይን ጋልቶ አይሁደ ካህኑንꬅስ ቤዞተ» ያጋይዳ። ኡን ኦገላ Ꮉንግተራ ጌዥዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ኡንታፓ ፈታይ ፋ ጌዥዳኖ በኤዘ ዎደ ꬎቅ ጋይደ ቃላራ ጾዝ ቦንችተራ የሱሳጎ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ኤ ሳማራ ሳአ አስ፥ የዝን የሱሳ ቶህትላ አፋ ጎልእ ኤዛ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","የሱሳ፥ «ጌዥዱንꬅ ታጵ አስ ማቆሳነ? ዬዝን፥ ኡዱፉኑንꬅ አባ ቅትዶ? ");
INSERT INTO oyde_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ꮉይ አላጋ አꬄፓ አትን መለ ማቂ ጾዝ ጋላትደ ባያ ጋኤነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","አꬄጎ፥ «ነ አማንታ ነና ጌሽዳ፤ ደንዲ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፋርሳዉንꬅ፥ «ጾዘ ካእቱሞ አይደ የኦደ?» ጋእ የሱሳ ኦጭዳ። ኤ፥ «ጾዘ ካእቱምታ በንትዘ ማላራ የኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ማህን እዞ፥ ‹Ꮉነ ዎይ ሰካ ያጋኦደስ ዳንዳኦስ። አኮስ ጋይኮ፥ ጾዘ ካእቱምታ ይን ግዳ የነ› » ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","የሱሳ ፋ ታማሩንꬃጎ፥ «አስ ናአ ቃምትፓ ፈታ ቦኦደስ ይን አሙꬎደ ዎደ የኦዳ፥ የዝን ይን በአማ። ");
INSERT INTO oyde_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","አሱንꬅ፥ ‹ኤ የይጋ የነ› ዎይ፥ ‹Ꮉነ የነ› ያጋኦዳ፥ የዝን ኡንታና ካሊ ቅትፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ዜልንꬅ ዜልንጊ ሳሎ ጋጻፓ ጋጻ ፎእዘ ፋና አስ ናአ የእት ቃምታ ይኒ ፋና ይአዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","የዝን ይና Ꮉኖዳንፓ ቲኖ አስ ናአይ ጋማ ማꬍꬋደስን Ꮉና የለተ እጽንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ኖሄ ዎደ ይእደ ፋና አስ ናአይ ዎድተን ይኒ ፋና ይአዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ኖሄ ማርካበ ገልደ ቃምቶ የሎደስ አሱንꬅ ሙእተራን ኡዥተራ፥ ኤክተራን ገልተራ የሳደራ ꬋብሰ Ꮉꬅታ ይእ ኡባ ꬋብስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ሎጠ በረን ይኒ ፋና ይእዳ። አሱንꬅ ሙእተራን ኡዥተራ፥ ዎንግተራን ባይዝተራ፥ ቱክተራን ኬጽተራ፥ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ሎጠ ሶዶመፓ ከዝደ ቃማ ዲነ ጋእንትዘ ምችዘባዝ ሳሎፓ ቡኪ ኡቡንꬃና ꬋብስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","አስ ናአይ ቆንጭዘ ዎድተን ይኒ ጋራ ይኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«የ ዎደ ኦደን ባለ የዘ ኬꬃ ግዳ የዘ ባዝ ኤኮደስ ኬꬃ ገልፐ። ይኒ ፋና፥ ጋደ የዘ አስ አኮ ባዝስን ካራ ማቅፐ። ");
INSERT INTO oyde_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ሎጠ ማችቶ ቲሮተ፤ ");
INSERT INTO oyde_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ፋ ሸምፕቶ አሾደስ ኮይዘ አስ ኦደን ꬋብሶዳ፤ ፋ ሸምፕቶ አꬂ እንግዘ ኦደን ኤ አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ታ ይንትስ ኦህነ፤ የ ዎደ ላምእ አሱንꬅ ፈቲ ዳꬃላ ዎይኦዳ። ፈተ ኤክንቶዳ፥ Ꮉንካይ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ላምእ ማቹንꬅ ዎላ ጋጮደራ ፈታ ኤክንቶዳ፥ Ꮉንካና አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ላምእ አሱንꬅ ዎላ ጋደ ኦችዙንꬃፓ ፈታይ ኤክንቶዳ፥ Ꮉንካይ አቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ኡን፥ «ላꬆ አባ ኤክንቶደ?» ያጋእ ኦጭዳ። ኤ፥ «ጋዉጻ የዘ በሳ አንኮ ሺቃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","የሱሳ ፋ ታማሩንꬃና አዛልእካይዛር ኡባ ዎደ ዎሶደ ፋና ታማርሶደስ ኮይ ያጋእ አዝዘ ኦህዳ፦ ");
INSERT INTO oyde_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«ፈቲ ካታማ ጾዝስ ዣሽቶሰ አስን ዬልꬎሴ ፈቲ ዳኛ የነ ");
INSERT INTO oyde_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ይና ካታምተ ፈቲ ቡዳንታ የነ። እዛን፥ ‹ታስን ታ ሞርክዘስ ግዳ የዘ ሞቶ ፍርዶ› ያጋእ ኡባ ዎደ የ ዳይንዘጎ ማህ ማህ ይእነ። ");
INSERT INTO oyde_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ዳይንዘ ኤራꬅ ዎደስ እ ኦህቶ ስአንጽ እጽዳ፥ የዝን ሱባፓ ፋ ዎዝንተ፥ ‹ታኒ ጾዝስ ዣሽቶሳ፥ አስስ ዬልꬋንጽ እጽኮን፥ ");
INSERT INTO oyde_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ꮉና ቡዳንታ ታና ዋየꬅዘ ግሾ ኢስ ፍርዶዳ፤ የይዛንጽኮ ኡባ ዎደ ይእ ታና ላቢሳዳ› ያጋእ ቆፕዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ላꬅን፥ «ኢታ ዳይንዘ ጋእዳኖ ስእዳ፤ ");
INSERT INTO oyde_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ጾዚ ቃማን አዋራ ኤጎ ኡክዘ ፋ ዶርዱንꬅስ ፍርዶሳነ? ኡንታና ማዶደስ ጋምኦዳነ? ");
INSERT INTO oyde_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ታ ይንትስ ኦህዛኖ ስኦተ፥ ኤልሲ ፍርዶዳ። ማቅኮን፥ አስ ናአይ የእዘ ዎደ ሳአላ አፋ አማኖ ደማድየሳነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ማህ፥ የሱሳ፥ ፋና ጽሎ አስ ፋና ማህ ጬቅንትዙንꬅስን መሉንꬃና ለቂዙንꬅስ Ꮉንጋራ ያጋእ አዝዘ ኦህዳ፦ ");
INSERT INTO oyde_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«ላምእ አሱንꬅ ዎሶደስ ጾዘ ኬꬃ Ꮉንግዳ። ፈተ ፋርሳወ Ꮉንካይ ማህ ቃራጠ ጋችዝዘ አስ። ");
INSERT INTO oyde_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ፋርሳዉዘ ኤቂ ፋስ ዎስተራ፥ ‹ጾዛዮ ታኒ መሉንꬅ ፋና ቦንቅዘ አስ፥ ኢታን ኦላለ አስ፥ አꬊ ማህ Ꮉይ ቃራጠ ጋችዝዘ አꬄ ፋና ማቅካይዘ ግሾ ነና ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ሳምንታፓ ላምእ ቶሄ ጾማነ፥ ታ ደንግዘባዝ ኡባንፓ አስራታ ከሳነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«የዝን ቃራጠ ጋችዝዘ ማህ Ꮉኮራ ኤቂ መለ አቶ የዝን ሳሎ ꬎቅ ጋእ በአደስን ዣሽቲ ፋ ዳዳብቶ ቆጽተራ ‹ጾዛዮ፥ ታና ናጋራንችዛ ማሮያ› ጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ታ ይንትስ ኦህዛኖ ስኦተ፤ ፋርሳውዘፓ Ꮉይኒ ቃራጠ ጋችዝዘ ጾዘ ቲኖ ጽሎ ማቂ ፋ ካራ ማቅዳ። አኮስ ጋይኮ፥ ፋና ꬎቅ ꬎቅ ዪዘ አስ ቶችንቶዳ፥ ፋና ቶችዘ አስ ꬎቅ ꬎቅ ጋኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","የሱሳ ዦጋ ናኡንꬃላ አፋ ፋ ኩሽቶ ጋዲ አንጆደ ፋና አሱንꬅ ኤጎ ከእነ። የሱሳ ታማሩንꬅ ይኖ ብእ አኮስ የሱሳጎ ኬኤ ያጋእ ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","የዝን የሱሳ ናኡንꬃና ፋጎ ጼጊ፥ «ናኡንꬅ ታጎ ዮኦዳኖ ካይፐተ፤ ዮኦ ጋኦተ። አኮስ ጋይኮ፥ ጾዘ ካእቱሞ ኡን ፋና ይእዱንꬅስ። ");
INSERT INTO oyde_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ታኒ ይንትስ ቱሮ ኦህነ፤ ጾዘ ካእቱሞ ዦጋ ናኡንꬅ ፋና ኤኮሰ ኦደን የይጋ ገሎስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","አይሁደ Ꮉላቁንꬃፓ ፈተ፥ «ኬሃ አስታማርዛዮ፥ መዽና ደኦ ደንጎደስ አኮ ኦቾ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","የሱሳ ኤጎ፥ «አኮስ ታና ኬህዛዮ ያጋእ ጼገ? ፈቲ ጾዘፓ አትን መለ ኬሃ ባያ። ");
INSERT INTO oyde_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ኦላልፐ፥ ዎꬍፐ፥ ካይስትፐ፥ ዎርዶ ማርክꬍፐ፥ ነ አዳያን ነ እንቶን ቦንቾ ያጋዘ ኪቶ ኤራነ» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","አꬃይን፥ «የንሳና ኡባ ታኒ ናአትꬃፓ አይኪ ናግተራ ጋምእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","የሱሳ ይኖ ስኤዘ ዎደ «ይኬ፥ ኔስ ፈትባዝ ፋጫነ፤ ኔስ የዘ ባዝ ሙሎ ባይዝ ዳሁንꬅስ እንጎ፤ ሳሎ ነና ቆልታ ናጋነ። የይዝ ማቂ ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","የዝን አꬄ ይኖ ስእደ ዎደ ኤስ ጋማ ቆሎ የዘ ግሾ ጋማ ዥልꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","የሱሳ አꬃ ብእ፥ «ዱረ አስስ ጾዘ ካእቱሞ ገልዛና ዋይዝ ኡንኦደ! ");
INSERT INTO oyde_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ዱረ ጾዘ ካእቱሞ ገሎዳንፓ ግማለ ማርፐ ኡሩንꬃራ አꬍዛና ላፋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ይኖ ስእደ አሱንꬅ፥ «የዛኮ ኦደ አቶደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","የሱሳ፥ «አስስ ዳንዳእንቶሰ ጾዝስ ዳንዳእንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጴጥሮሳ፥ «ይኬ ኑኒ ኑ ባዝ ሙሎ አሺ ነና ካላነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","«የሱሳ ቱሮ ታ ይንትስ ኦህነ፤ ጾዘ ካእቱሞስ ጋእ ፋ ኬꬅቶ ዎይ ፋ ማችቶ ዎይ ፋ እሹንꬃና ዎይ ፋ አዳያን ፋ እንቶን ዎይ ፋ ናኡንꬃና አሽደ፤ ");
INSERT INTO oyde_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ꮉና ዎድተ ጋማ ዳኮ፥ የኦደ አላምተ መዽና ደኦ ኤኮሰ ኦደን ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","የሱሳ ታጶ ላምኡንꬃና ፋጎ ጼጊ፥ «አነ የሩሳላመ የꬎተ፥ ናቡንꬅ አስ ናአይ ባዝ ጻፍዳና ኡባና የይጋ ፎልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ኤ አይሁደ ማቆሰ አስስ አꬊ እንግንቶዳ። ኡን ኤዛ ለቆዳ፥ ጫዦዳ ኤላ አፋ ጩቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ኤዛ ጋራፍዳንፓ ሱባ ዎꬎዳ፥ የዝን Ꮉይꬓንꬆ ቃማ ኤ Ꮉይቆፓ ደንዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","የዝን ኤ ታማሩንꬅ ይና ኡባንፓ ፈትባዝን ቲሪካያ። ኤ ቆፍታ ኡንትስ አችንትደ ግሾ ኤ ዋጋኤዛኮ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","የሱሳ እያርኮ ኡክዘ ዎደ ፈቲ ቆቀ አꬄ ኦገ ጋጻ በቲ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ቆቀ አꬄ አሱንꬅ ይና በስትራ አꬎደራ ስእ፥ «ይና አኮ?» ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ኡን፥ «ናዝረተ የሱሳ Ꮉንራ አꬋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ኤ፥ «ዳዉተ ናአይ፥ የሱሳ፥ ታና ማሮያ» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ቲኖ ቲኖ Ꮉንግዘ አሱንꬅ፥ «ስእ ጋኦ» ጋእ ካጭዳ። የዝን ኤ፥ «ዳዉተ ናአዮ፥ ታና ማሮ» ያጋእ ጋንꬅ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","የሱሳ ኤቂ አꬃ ፋጎ ኮኦደ ፋና ኪትዳ። አꬃይን፥ ኤጎ ሺቅን፥ ");
INSERT INTO oyde_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«ታ ኔስ አኮ ኦቾደ ፋና ኮየ?» ያጋእ ኦጭዳ። ቆቅዘ፥ «ላꬆ ታ ቦኦደስ ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","የሱሳ፥ «ቦኦ፥ ነ አማንታ ነና ፋꬅዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","አꬃይ ኢራ ብእ አሽዳ። ጾዝ ቦንችተራ የሱሳ ካልዳ። አስ ኡቡንꬅ ይኖ ብእ ጾዝ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","የሱሳ እያርኮ ካታማ ገሊ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","የይጋ ዛክዮሳ ጋእንትዘ ቃራጠ ጋችዙንꬅ Ꮉላቅዘ የነ። ኤ ጋማ ዱረ። ");
INSERT INTO oyde_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ኤ የሱሳ ኦደ የዛኮ በአደስ ኮይዳ። ኤ Ꮉታ ማቅደ ግሾ አስ ጋማፓ ደንዲ የሱሳ በአደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","የሱሳ በአደስ ኮይ ኤ Ꮉንግዘ ኦግትስ ቲኖ ዎጺ Ꮉንግ ፈቲ ቦባ ምንጻላ አፋ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","የሱሳ ይና በስተ የሊተራ ꬎቅ ጋእ ብእ፥ «ዛክዮሳ፥ Ꮉይኖ ታ ነ ካራ ፌሻደስ ቤዘ ግሾ ኤለ ዎꬎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ኤ ኤልሲ ዎꬊ ኡፋይሳራ የሱሳ ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ይና በስተ የዘ አሱንꬅ ኡባና ይኖ ብእ፥ «ናጋራንችዘ ኬꬃ ገሊ ሞክንቶደስ ይአነ» ያጋእ ዙዝንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ማቆ የዝን፥ ዛክዮሳ ኤቂ ላꬃጎ፥ «ላꬆ፥ ይኬ ታስ የዘ ቆሎ ኡባንፓ ባግቶ ዳሁንꬅስ እንጎዳ። አሳፓ አኮ ባዝን ዎርዶራ ባልꬂ ኤክደባዝ ማቅኮ ኦይዲ ኩሸ ማሆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","የሱሳ ማህ፥ «Ꮉይ አꬄ አብራሃማ ኮች ማቅደ ግሾ Ꮉይኖ አቶትꬅ Ꮉና ካርተ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","አስ ናአይ ይእዳና ꬋብዱንꬃና ኮዮደስን አሾደስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","አሱንꬅ ይኖ ስእዘ ዎደ የሱሳ የሩሳላመ ኡክደ ግሾን ጾዘ ካእቱሞ Ꮉተ ኡከራ ቆንጮደ ፋና ይእዘ ግሾ ኡንትስ አዝዘ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ይኒ ግሾ፥ የሱሳ፥ «ፈቲ ኤርንትደ አስ የዘ ፋስ ካተትꬅ ኤኪ ዮኦደስ መለ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ኤስ ኦችዘ አሩንꬃፓ ታጱንꬃና ጼጊ ፈተስ ፈተስ ፈቲ ምናነ እንግ ‹ታ ማቂ የኦደ ዎንꬅስ Ꮉና ሚሽትራ ዛልኦተ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«ይና ሳእተ የዘ አሱንꬅ ኤዛ እጽዘ ግሾ Ꮉይ አꬄ ኑላ አፋ ካእቶደ ፋና ኑ ኮዮስ ያጋእ አስ ኤ ሱባራ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«ማቅኮን፥ የ አꬄ ካት ማቂ ፋ ሳአ ማቅዳ። የንꬅ ታጵ አሩንꬂ ኤ እንግደ ሚሽቶ አኮ ጋር ዛልእ ትርፍዘዛኮ ኤሮደስ ኮይ ኡንታና ጼግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«ቲኖሰ ይእ፥ ‹ላꬆ፥ ነ ታስ እንግደ ምናንዘ መለ ታጶ ትርፍዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«ኤዛ ላꬄ፥ ‹ናተ አማንንትደ አርዛዮ ሎኦ ኦችዳ። ነ ኤራꬅ ባዛ አማንንትደ ግሾ ኔስ ታጵ ካታማላ አፋ አደትꬅ ዎልቃ እንግዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«ላምአንꬅዛይ ይእ፥ ‹ላꬆ፥ ነ ታስ እንግደ ምናንዘ መለ እችን ትርፍዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«ላꬂ ኤጎ፥ ‹ኔስን ማህ እችን ካታማላ አፋ አደትꬅ ዎልቃ እንግዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«ይኬ Ꮉይꬓንꬅዘ ይእ፥ ‹ላꬆ፥ ታ ጩርቃራ ጻጺ ናግደ ነ ሚሽታ Ꮉናሸ። ");
INSERT INTO oyde_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","አኮስ ጋይኮ፥ ኔኒ ነባዝ ማቆሰ ባዝ ኤክዛኖን ነ ቡድካይዘባዝ ማጽዘ ኢታ ዎዝና ምንꬂ አስ ማቅደ ግሾ ኔስ ዣሽትዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«ኤዛ ላꬄ ማህ፥ ‹ናተ ኢታ አርዛዮ ነ ዶንቲ ጋር ታ ነና ፍርዶዳ። ታ ጋድካይዘባዝ ኤክዛኖን ቡድካይዘባዝ ማጽዘ አስ ማቅዛኖ ነ ኤርዛኮ፥ ");
INSERT INTO oyde_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ታ ይእ ታ ምናንዛ ትርፈራ ኤኮደ ፋና ዛልእዘ አስስ አኮስ እንግካ?› ");
INSERT INTO oyde_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«ኤዛ ላꬄ ይና በስተ ኤቅዱንꬃጎ፥ ‹ኤራ የዘ ምናንዛ ኤኪ ታጶ ትርፍዝዳይስ እንጎተ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«ኡን፥ ‹ላꬆ፥ ኤስ ቲኖን ታጵ ምናነ የነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«ላꬂ፥ ታ ይንትስ ኦህነ፤ ‹የዘ ኡቡንꬅስ መለ ጉጁንቶዳ፥ የዝን ባዘፓ መለ አቶ ኤስ የዛናን ኤክንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ማቆ የዝን፥ ታ ኡንታላ አፋ ካእታመ ፋና ኮይዱንꬅ የንꬅ ታ ሞርኩንꬃና Ꮉንካ ታ ቲንተ ክእ ዎꬎተ› ጋይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","የሱሳ ይኖ ኦህዳንፓ ሱባ ኡንታፓ ቲኖ አꬊ የꬊ የሩሳላመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ሻማሄ ደርዘላ አፋ የዘ ቤተፋገን ብታንያ ኡክደ ዎደ ፋ ታማሩንꬃፓ ላምኡንꬃና ያጋእ ኪትዳ፦ ");
INSERT INTO oyde_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«ይን ቲኖ የዘ ካራ ጋንጨ ቅቶተ፥ ይን የይጋ የልዘ ዎደ ኦደን ቶግካይዘ አጭንቲ የዘ Ꮉረ ናአ ደማዳ። ኤዛ ብሊ Ꮉይጋ ኤኪ ዮኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ኦደን፥ ‹አኮስ ብለ?› ጋእ ኦጭኮ፥ ‹ላꬂ ኤዛ ኮያነ› ያጋኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ኪትንትዱንꬅ Ꮉንግ ኤ ጋይዳን ፋና ይእን ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ኡን Ꮉረ ናአያ ብሎደራ ላꬁንꬅ ብእ፥ «Ꮉረ ናአያ አኮስ ብለ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ኡን ማህ፥ «ላꬂ ኤዛ ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","የይጋፓ Ꮉረ ናአያ የሱሳጎ ክእዳ። ፋ ማእቶ Ꮉረ ናአይ ባንተ ጋዲ የሱሳ Ꮉረ ናአይላ በትꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","አሱንꬅን ኤ የꬍዘ ኦግትላ ፋ ማእቶ ዪጽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ሻማሄ ደረ ሱለ ዎꬍዘ ኦግዘጎ ኡክዘ ዎደ ፋይዶራ ሎይꬂ ጋማ አሱንꬃና ኡን ብእ ክለ ባዝተ ኡፋይት ፋ ቃልቶ ꬎቅ ዪዚ፥ ");
INSERT INTO oyde_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«ላꬄ ሱንꬅተ የእዘ ካትዘ አንጅንትዳያ ሳሎ ግዳ ሳሮ ኡባፓ ꬎቃ ሳሎ ቦንቾ ጾዝስ ማቀ።» ያጋእ ጾዝ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","አሱንꬅ ግዳፓ ፈቲ ፈቲ ፋርሳዉንꬅ የሱሳጎ፥ «አስታማርዛዮ፥ ነ ታማሩንꬃና Ꮉይዞተ ጋእ ካጮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ኤ ኡንታጎ፥ «ኡን ስእ ጋይኮ ሹቹንꬅ ኡኮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","የሱሳ የሩሳላመ ኡክተ ካታምቶ ብእ ኢስ ዬክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«ኔስ ሳሮ ማቃዳኖ Ꮉይኖ ነ ኤርዘባዝ ማቅዛኮ የዝን፥ Ꮉተ ነ ኣፍትፓ ገንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ነ ሞርኩንꬅ ነ ካንቶ ጋሲ ዱማ ዱማ ኦገራ ነና ተቂ ኡንእꬅዘ ዎደ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ነናን ነ ጋስት ግዳ የዘ ነ ናኡንꬃና ꬋብሶዳ። ፈቲ ፈቲ ሹች ደንꬂ ዉልኦዳ፥ አኮስ ጋይኮ ጾዚ ነና አሾደስ የእዘ ዎድቶ ኤርካያ» ያጋእ ኢስ ዬክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ይንፓ ሱባ፥ የሱሳ ጾዘ ኬꬃ ገሊ ዛልእዙንꬃና የይጋፓ ባይእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ማህ፥ «‹ታ ኬꬅታ ጾዝ ዎስዘ ኬꬂ ማቃዳ› ጋእ ጻፍንትዳ፥ የዝን ይን ታ ኬꬅቶ ፋኑንꬅ ዎምኦ ማህዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","አዋራ አዋራ ጾዘ ኬꬅተ ታማርሳነ። ካህኑንꬅ Ꮉላቁንꬅ፥ ህገ አስታማሩንꬅን ጋደ ጭሙንꬅ ኤዛ ዎꬎደስ ኦገ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ማቆ የዝን፥ አሱንꬅ ኡባና ኤ ትምርትቶ ፋ ዎዝንቶ ኦሊ ስእዘ ግሾ ኡንትስ ኦቾደ ባዝ ꬋብዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ፈቲ ቃማ የሱሳ ጾዘ ኬꬃ አሱንꬃና ታማርስተራን ዎንገለ ማርክꬍተ፥ ካህኑንꬅ Ꮉላቁንꬅ፥ ህገ አስታማሩንꬅን ጋደ ጭሙንꬅ ፈትላ ኤጎ ይእ፥ ");
INSERT INTO oyde_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«ነ Ꮉንሳና አኮ አደትꬅ ወልቃራ ኦችዛኮ ኑስ ኦሆ። Ꮉና አደትꬅ ዎልቅቶ ኔስ እንግደ ኦደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ኤ ኡንታጎ፥ «ታንን ይንታና ፈትባዝ ኦጮዳ፥ አነ ታስ ማሆተ። ");
INSERT INTO oyde_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ጻማቅዘ ዋሐንሳ ጽንቃታ ጾዛፓነ አሳፓ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ኡን ዎል ግዳ ያጋእ ዞርንትዳ፦ «ጾዛፓ ጋይኮ ዬዝን፥ አኮስ አማናንጽዶ?» ያጋኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","«አሳፓ ጋይኮ፥ አሱንꬅ ኡባና ዋሐንሳ ናበ ማቅዛኖ አማንዘ ግሾ ኑና ሹቻራ ꬎጎዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ይኒ ግሾ፥ «አባፕ የዛኮ ኑ ኤሮስ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","የሱሳ ማህ፥ «ይኬ፥ ታንን አኮ አደትꬅ ወልቃራ Ꮉንሳና ኦችዛኮ ይንትስ ኦሆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ይንፓ ሱባ፥ የሱሳ ያጋእ Ꮉና አዝዝቶ አሱንꬅስ ኦህዳ፦ «ፈቲ አስ ዎይነ ቱክዳ። ኦችዙንꬅስ ኮꬄ እንግ ጋማ ዎደ ጋምእ ዮኦደስ መለ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ዎይነ ኣፍቶ ማጽዘ ዎደ የልን ዎይነ ኣፍትፓ ኤስ ዳኮደ ፋና ኦችዙንꬃጎ ፋ አርዛ ኪትዳ። የዝን ኦችዙንꬅ የ አርዛ አይኪ Ꮉꬊ Ꮉሪ ኩሸ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ማህን መለ አርዛ ኪትዳ። ማህ ኦችዙንꬅ ኤዛ Ꮉꬊ፥ ካዉሽዚ Ꮉሪ ኩሸ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ꮉተን ማህ Ꮉይꬕንꬃ አርዛ ኪትዳ። ዎትዙንꬅ ኤዛን Ꮉꬊ Ꮉርግዚ ዎይነ ግዳፓ ጋጻ ኬሲ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«ዎይነ ላꬄ፥ ‹ዬዝን ታ አኮ ኦቾ? አነ ማህ ታ ካዽዘ ታ ናአያ ዳኮዳ፤ ኦደ ኤሮደ ኡን ኤዛ ቦንችካይዛራ አታማ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«የዝን ኦችዙንꬅ አꬄ ናአያ ብእደ ዎደ ‹Ꮉይኒ ኤዛ ላቶዳያ፥ Ꮉይጋ ዮኦተ ኤዛ ዎꬎዳ፥ የይዝኮ ላትታ ኑስ ማቃዳ› ያጋእ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ዎይነ ግዳፓ ጋጻ ኬሲ ዎꬍዳ። «ዬዝን፥ ዎይነ ላꬄ የንꬅ አሱንꬃና ዋይሳደ? ");
INSERT INTO oyde_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ይእ የንꬅ ኦችዙንꬃና ꬋብሶዳ፥ ዎይነ በስቶ መለ አሱንꬅስ እንጎዳ። አሱንꬅ ይኖ ስኤዘ ዎደ ‹ሽንቻለ ይኒ ጋርዘባዝ ክእፐ› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","የሱሳ ኡንታና ዳኪ ብእ፥ ዬዝን «ግምበ ኬጽዘ አሱንꬅ ቦርደ ሹችዘ፥ ኬꬅስ ምንꬅን ጻላትꬅ እንግዘ ኡባንፓ አꬍዘ ሹች ማቅዳ» «ጋእንት ጻፍንትዳን ብልꬅታ አኮ? ");
INSERT INTO oyde_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","የ ሹችዘላ አፋ ጎልእዘ ኡባና መቆዳ፥ ሹችዘ ኤላ አፋ ዎꬍዘ ኡባና ጋጭንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ህገ አስታማሩንꬅን ካህኑንꬅ Ꮉላቁንꬅ ይና አዝዝታ ኦህንትዳና ኡንታላ አፋ ማቅዳኖ ኤሪ የ ዎደ ኤዛ አይኮደስ ኮይዳ፥ የዝን አሱንꬅስ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ይኒ ግሾ፥ የሱሳ ዎርዥቶ አህዘ ሮመ ካትዘስ አꬂ እማደስ ኮይ ኤ ዶንትፓ ባላ ቃላ ናጋነ። ይኖ ፎልሳደስ ጽሎ ጋራ ይእ ጭምዘ አሱንꬃና ኤጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ኪትንቲ Ꮉንግደ አሱንꬅ፥ «አስታማርዛዮ፥ ኔኒ ኦህዛናን ታማርስዛና ልከ ማቅዛኖ፥ ማህ ጾዘ ኦግቶ ቱርራ ታማርስዛኖን ኦናን ሻጎሳኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ይኦ የዝን፥ ሮመ ካትስ ጊራ ጊሮደስ ቤዛነነ ቤዞሳ?» ያጋእ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","የዝን ኤ ኡን ዎዝና ኢታትꬅቶ ኤርደ ግሾ ");
INSERT INTO oyde_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«አነ ታና ፈቲ ሳንትመ ቤዞተ፥ ኤላ የዘ ምስልታን ሱንꬅታ ኦደባዞ?» ያጋይዳ። ኡን ማህ፥ «ሮመ ካት» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ኤ ማህ፥ «ዬዛኮ፥ ቄሳረስቶ ቄሳረስ፥ ጾዘስቶ ጾዝስ እንጎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ይኒ ግሾ፥ ኤ ማህደ ማህተ አሱንꬅ ቲንተ ባላ ደንጎደስ ዳንዳእካያ። ኤ ማህተ ጋማ ቆፒ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ꮉይቆፓ ደንዶ ባያ ያጋዘ ሳዱቃዉንꬃፓ ፈተ ፈተ የሱሳጎ ይእ፥ ");
INSERT INTO oyde_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«አስታማርዛዮ፥ ፈቲ አስ ማቾ ኤኪ ናአ የልካይዛራ Ꮉይቂኮ፥ ኤ እሸ ይና ማችቶ ኤኪ ናአ የሊ ፋ እሸስ ኮች አሾደ ፋና ሙሴ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ይኬ ላፑን እሹንꬅ የነ። አንግሰ ማቾ ኤኪ ናአ የልካይዛራ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ላምአንꬅዘ እዞ ኤኪ ናአ የልካይዛራ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ꮉይꬓንꬅዘ ይኒ ፋና ይእዳ። ላፑኑንꬅ ኡባና ይኒ ጋራ ይእ እዞ ኤክዳ፥ የዝን ናአ የልካይዛራ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ኡባፓ ሱባ ማችታ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ይኬ፥ ላፑን ꬊራꬅ እዞ ኤክደ ግሾ Ꮉይቆፓ ደንድዘ ዎደ እዛ ኦደ ማቾ ማቃደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","የሱሳ ማህ፥ «አስ Ꮉና ዎድተ ኤካነ ገላነ። ");
INSERT INTO oyde_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","የዝን Ꮉይቆፓ ደንዲ የኦደ አላምተ የሳደስ ቤዙንꬂ ኤኮስ ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ኡን ኪታንቾ ፋና ማቅዘ ግሾ ቲኖፓ Ꮉይቆስ። Ꮉይቆፓ ደንድደ ግሾ ኡን ጾዘ ናአ። ");
INSERT INTO oyde_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ሙሴ ላꬂ፥ ‹አብራሃማ ላꬂ፥ ይሳቃ ላꬂ፥ ያይቆባ ላꬂ› ጋእ ጭልኦ ግዳ ኤጽዘ ታማ ታሪክቶ ጻፍዳነ Ꮉይቂደ አሱንꬅ ደንድዛኖ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ኡቡንꬅ ኤስ ፋጻ የዙንꬃና ማቃደ ግሾ ኤ ፋጻ የዙንꬅ ላꬃፕ አትን Ꮉይቂዱንꬅ ላꬂ ባያ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ህገ አስታማሩንꬃፓ ፈተ ፈተ፥ «አስታማርዛዮ፥ ሎኦ ባዝ ኦህዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ይንፓ ሱባ፥ መለ ኦጨ ኦጮደስ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ይንፓ ካሊ የሱሳ ኡንታጎ፥ «አሱንꬅ ክርስቶሳ ዋይዝ ዳዉተ ናአ ጋኤ? ");
INSERT INTO oyde_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","አኮስ ጋይኮ፥ ዳዉተ ፋ ኦምተ ማዝሙረ ማጻፍተ፥ « ‹ጾዚ ታ ላꬄጎ «ታ ነ ሞርኩንꬃና ነ ቶህታ የꬍዘ በሲ ማሆደ ዎንꬅስ ታፓ ምዛቅ ዛላራ በቶ» ጋይዳ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«ይኬ፥ ዳዉተ ክርስቶሳ፥ ‹ላꬆ ጋእ ጼግተራ ኤስ ናአ ዋይዝ ማቀ?› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","አስ ኡባ ስአደራ ፋ ታማሩንꬃጎ፥ ");
INSERT INTO oyde_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«ጳርጎ ማኦ ማእ ዉታ ካꬍዙንꬃፓ፥ ጋበ ቦንቾ ሳሮ፥ አይሁደ ዎሳ ኬꬅተ ቦንቾ ኦይዳ፥ ሞኩንትዘ ኬꬃን ቦንቾ በሲ ኮይዘ ህገ አስታማሩንꬃፓ ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ኡን ቡዳን ኬꬂ ካሎ አሽዙንꬃና፥ ጽሎ አስ ጋር ይእ ዎሳ ጳርግዛነ። ኡን ኢታ ፍርዳ ኤኮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ዱረ አስ ጾዘ ኬꬃ ሙጻተ ሳጥንተ ኦሎደራ የሱሳ ꬎቅ ጋእ አሱንꬃና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ማህ ፈቲ ዳሃ ቡዳንታ ላምእ ስክና ኦሎደራ ብእ፥ ");
INSERT INTO oyde_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","«ታ ይንትስ ቱሮ ኦህነ፤ Ꮉና ዳሃ ቡዳንታ ኡባንፓ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","አኮስ ጋይኮ፥ Ꮉንꬅ አሱንꬅ ኡባና ፋስ የዘ ባዛፓ እንግዳ፥ የዝን እዛ ፋ ፋጭትፓ፥ ፋስ የዘ የስቶ ሙሎ እንግዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","የሱሳ ታማሩንꬃፓ ፈተ ፈተ ጾዘ ኬꬅታ ጋማ ሎእዘ ሹቻራን አስ ጾዝስ እንግደ እሞራ ሎእዳኖ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","የዝን የሱሳ፥ «Ꮉና ይን በእዘ ባዝታ ኡባና ላንትካይዛራ፥ ሹች ሹቻላ አፋ ግምቢንትደ ፋና Ꮉንራ አቶሰ ዎደ የኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ኡንትን፥ «አስታማርዛዮ፥ Ꮉና ኡባና Ꮉኖዳና አይደ? ማህ Ꮉና Ꮉኖዳንስ ማልታ አኮ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","የሱሳ ያጋእ ኡንትስ ማሄ እንግዳ፦ «ባልንታመ ጋር ናግንቶተ። ጋሙንꬅ ፋና፥ ‹ታ ክርስቶሳ፥ ዎድታ ኡክዳ› ያጋእተ ታ ሱንꬅተ የኦዳ፥ የዝን ይን ኡንታና ካልፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ይን ኦላባዝን አስ ኢታትꬅ ስእዘ ዎደ ታንፐተ። ይና ቲንꬊ ይኦዳና አታመባዝ ማቃደ ግሾ ዎደ ዉርሱꬅታ ኤልሲ የኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ካልን፥ «ዎርዣ ዎርዣላ አፋ፥ ካእቱሞ ካእቱሞላ አፋ ደንዶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ዳማ ሳአ ኤንኤ Ꮉኖዳ፥ ጋዶ Ꮉርገ ናየ ባይኤን ዱማ ዱማ በሳ ጋማዳ፥ ዣሽዘባዝን ዳማ ማላ ሳሎፓ በንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","የዝን Ꮉና ኡባና Ꮉኖዳንፓ ቲኖ ታ ሱንꬅት ግሾ ጋእ አስ ይንታና ባይꬆዳ አይኮዳ። አይሁደ ዎሳ ኬꬃ ፍርድ አች ኬꬃ ይንታና ኦሎዳ። ካት ቲኖን ዎርዣ አህዙንꬂ ቲኖ ይንታና ካንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ይናን ታ ባዝ ይን ኡንትስ ማርክꬋደስ ሎኦ ኦገ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ይኒ ግሾ፥ ይን ኦጭንትዘ ዎደ ዋጋእ ማሄ እማደ ጋእ ይን ዎዝንተ ኡንእንታመ ፋና ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","አኮስ ጋይኮ፥ ይን ሞርኩንꬅ ይንታራ ኤቅንቶደስን ላሎደስ ዳንዳኦሰ ዶናን ጭንጫትꬅ ታ ይንትስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","መለ አቶ የዝን፥ ይንታና የልዱንꬅ፥ ይን እሹንꬅ፥ ይን እግኑንꬅ ላጉንꬅ ይንታና አꬂ እንጎዳ። ይን ግዳፓ ፈታ ፈታ ዎꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ታ ሱንꬅት ግሾ አስ ኡባ ቲንተ ይን እጽንትዱንꬃና ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","የዝን መለ አቶ የዝን፥ ይን ኦማ እስንꬅትፓ ፈተን ꬋቦስ። ");
INSERT INTO oyde_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ምንꬂ ዳንዳአራ ይን፥ ይን ሸምፕቶ አሾዳ።» ");
INSERT INTO oyde_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«የሩሳላመ ካታምታ አላጋ ዎታዳረራ ጋስንት በቴዝን ይን ብእኮ ኢስ ꬋበ ኡክዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","የ ዎደ ይሁዳ የዘ ኡባና ደረጎ ዎጺ ꬋቦ፥ ካታምተ የዙንꬅ የይጋፓ ከዞ፥ ጋጻረ የዙንꬅ ካታማ ገልፐ። ");
INSERT INTO oyde_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","አኮስ ጋይኮ፥ Ꮉና ጻፍንትዳና ፎልንቶደ ጋር ይና ጾዘ ኩሸ ማህዘ ዎደ። ");
INSERT INTO oyde_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ሳአላ አፋ ዳማ ማꬋ የኦዳ፥ Ꮉነን አሳላ አፋ ጾዘ ባድꬅ የኦዳ። ይኒ ግሾ፥ ዎዳꬅ ማቹንꬃናን ꬋንꬅዙንꬃና ባደ። ");
INSERT INTO oyde_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ኡን ማሻራ Ꮉይቆዳ፥ አስ ኡባና አላጋ ሳአ የሳዳ። አይሁደ ማቆሰ አሱንꬅ ዎድታ ፎልንቶደ ዎንꬅስ የሩሳላመ ኡንታራ የዽንትዳኖ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«አዋን፥ አግናን፥ ጾልንቶላ አፋ ማላ በንቶዳ። አባፓን ዙሉንተ ኤንኤ ደንድዳንፓ ሳአ የዘ አስ ኡንእንቶዳ ይርጎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ሳሎ ዎልቅታ ቡቁንቶደ ግሾ አስ ዣሽሞራን ሳአላ አፋ አኮ ይአድየሳ ጋእ ናጎራ ታኖዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","የ ዎደ አስ ናአይ ዎልቃራን ዳማ ቦንቾራን ꬎነራ የኦደራ ኡን በአዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ይንታና አሽዘ ኡክደ ግሾ Ꮉና Ꮉንዛና ፎልንቶደስ አይክዘ ዎደ ጊግንቲ ኤቆተ፥ ይን ኦምቶ ꬎቅ ዪዚ ቦኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ካልን፥ Ꮉንጋራ ጋእ አዝዘ ኦህዳ፦ «በለሰ ምንጻን መለ ምንጻ ኡባ ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ኡን አጭዘ ዎደ ቶርቼ ኡክዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ይኒ ጋራ Ꮉና Ꮉንዛና ፎልንቶደራ ይን ብእኮ ጾዘ ካእቱሞ ኡክዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«ታ ይንትስ ቱሮ ኦህነ፤ Ꮉና ኡባና ፎልንቶደ ዎንꬅስ Ꮉና የለትꬅታ አꬎኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ሳሎን ሳአን አꬎዳ፥ የዝን ታ ቃልታ አꬎኦስ። ");
INSERT INTO oyde_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«ይኬ፥ ቦረ ባይዘ የሳራ፥ ኡሽ ጋንራ የስ ባዝስ ኡንእንተራ ይን ዎዝንታ አይክንታመ ጋራን ይና ቃምታ ቲርካይዝን ጽኬ ፋና ይንታና አይካመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ይና ቃምታ ሳአ ኩሙꬅተ የዘ ኡቡንꬃላ አፋ የሎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ይኒ ግሾ፥ የእዘ ባዝ ኡባፓ አቶደስን አስ ናአ ቲንተ ኤቆደስ ዳንዳእንቶደ ፋና ኡባ ዎደ ሚንግ ዎሶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","አዋራ አዋራ የሱሳ ጾዘ ኬꬅተ ታማርስተ፥ ቃማ ቃማ ሻማሄ ደርዘላ አፋ ኬዚ አቃነ። ");
INSERT INTO oyde_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","አስ ኡባ ኤዛ ስኦደስ ዎንታ ጎዳ ኤጎ ጾዘ ኬꬃ የእነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","የ ዎደ ፋስካ ያጋዘ ቦራ ባአለ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬅ አሱንꬅስ ዣሽትደ ግሾ ዋይዝ የሱሳ ፋ ግዳፓ ꬋብሶድየዛኮ ኦገ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ጻላሄ ታጶ ላምኡንꬃፓ ፈታ ማቅደ አስቆሮቱ ይሁዳ ጋእንትዘ ግዳ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ይሁዳ ካህኑንꬅ Ꮉላቁንꬅስን ጾዘ ኬꬃ ናግዙንꬅ Ꮉላቁንꬃጎ Ꮉንግ የሱሳ ዋይዝ አꬂ እማድየዛኮ ኡንታራ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ኡንትን ይነ ኡፋይት ብራ እማደስ ኤራ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ኤዝን ዞርንትዳነ ጊግዳ። አꬂ ኡንትስ እማደስ አስ ባይዘ ዎትዘ ዎደ ናግተራ የነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ይንፓ ሱባ፥ ፋስካ ዱሮ ሹክንትዘ ቦራ ባአለ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","የሱሳ፥ «ፋስካ ካዎ ማአደ ጋር Ꮉንግ ኑስ ጊግዞተ» ያጋእ ጴጥሮሳን ዋሐንሳን ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ኡን፥ «ኑ አባ ጊግሳደ ጋር ነ ኮየ» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ኤ ኡንታጎ፥ «ይኬ ይን ካታማ ገሎደራ Ꮉꬅ ኦታራ ቶክደ አꬄ ይንታራ የልንቶዳ። ኤ Ꮉንግ ገልዘ ኬꬅተ ኤዛ ካሊ ገሎተ። ");
INSERT INTO oyde_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ካርትአደጎ አስታማርዘ፥ ‹ታ ታ ታማሩንꬃራ ዎላ ፋስካ ካዎ ማአደስ ዛቆ ኬꬅታ አባ የነ? ያጋይዳ› ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ኤ ፎቀላ አፋ ዪጽንት ጊጊ የዘ ዳልጋ ክፍለ ይንታና ቤሳዳ፥ የይጋ ጊግዞተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ኡን Ꮉንግ የሱሳ ጋእዳን ጋራ Ꮉንን ደንግዳ። ፋስካ ባአለ ካዎ የይጋ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ሳታን የልደ ዎደ የሱሳ ሐዋሩንꬃራ ዎላ ካዎላ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ኤ ኡንታጎ፥ «ታ ማꬋ ኤኮዳንፓ ቲኒ Ꮉና ፋስካ ካዉቶ ይንታራ ማአደስ ጋማ አሙꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ይኬ፥ ስኦተ! ጾዘ ካእቱምተ Ꮉንስ ብልꬅታ ፎልንቶደ ዎንꬅስ Ꮉና ካዉቶ ማህ ሞኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ኡሽቶ ኤኪ ጋላቲ ማቂ፥ «Ꮉተ Ꮉኖ ይን ግዳ ግሽንቶተ። ");
INSERT INTO oyde_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ስኦተ! ጾዘ ካእቱሞ የኦደ ዎንꬅስ Ꮉይኖፓ አይኪ Ꮉና ዎይነ ኡሽትፓ ማህ ኡዦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ቦርዛ ኤኪ፥ ጋላቲ ማቂ፥ «Ꮉና ይንትስ እንግንትዳና ታ አሽቶ። Ꮉኖ ኦችታራ ታና ቲሮተ» ያጋእ ባጽ ኡንትስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ይኒ ፋና፥ ካዉትፓ ሱባ ኡሽቶ ኤኪ፥ «Ꮉና ኡሽታ ይንትስ ጎግደ ታ ሱꬅተ ፎልንትዘ ክለ ጫቆ። ");
INSERT INTO oyde_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ማቅኮን፥ ታና አꬂ እንጎደ አꬄ ኩሽታ ታራ ፈትላ ጋባተ። ");
INSERT INTO oyde_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","አስ ናአይ ኤስ ጾዚ ጋይደ ፋና Ꮉይቆደስ የነ፥ የዝን ኤዛ አꬂ እንግዘ አꬃ ባደ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ኡን ፋ ግዳ፥ «Ꮉኖ ኦኒ ኦቾደ» ጋእ ዎል ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ማህ ኡን ግዳ ዳማ ማቃደ ኦደ ጋዘ ላለ መꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","የሱሳ ኡንታጎ፥ «አላመ ካቱንꬅ ፋ አሱንꬃና ዎልቃራ አሃነ፤ ፋ ደርትላ አፋ ላꬅꬍዙንꬃናን ፋና፥ ‹ሎኦ ኦችዙንꬃና› ያጋእ ጼጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","የዝን ይን ግዳ ይኒ ፋና ማቅፐ። ይን ግዳ አንግስዘ ጌዘ ፋና ይኦ፤ ካልꬅዘ ካልዘፋና ይኦ። ");
INSERT INTO oyde_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ዬዝን፥ ሞክዘፓን ሞክንትዘፓ አየ አ? ሞክንትዛ ባነ? የዝን ታኒ ይን ግዳ ሞክዘ ፋና። ");
INSERT INTO oyde_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«ይንትን ታ ማꬍተ ታፓ ሻክንትካይዛር ታራ ሚንግ ኤቅዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","ይን ታ ሌማትፓ ማአደ ፋና፥ ኡሻደ ፋናን አራታላ አፋ በቲ ታጶ ላምእ እስራኤለ ሼሹንꬃላ አፋ ፍርዶደ ጋር ታ አዳይ ታና ሹምደ ፋና ታንን ይንታና ታ ካእቱምተ ሹሞዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ካሊ የሱሳ፥ «ስሞና፥ ስሞና፥ ጻላሄ ይንታና ዛርጋ ፋና Ꮉርቆደስ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","የዝን ታ ነ አማንታ ꬋባመ ፋና ኔስ ጭምꬋነ። ኔንን ማቅደ ዎደ ነ እሹንꬃና ሚንꬆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ስሞና፥ «ላꬆ፥ ታ ኔራ አጭንቶደስን Ꮉይቆደስ ጊግንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","የሱሳ ጴጥሮሳጎ፥ «ታ ኔስ ኦህነ፤ Ꮉይኖ ሉኩለ ኦሎዳንፓ ቲኖ ነ ታና Ꮉይꬕ ቶሄ ካዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ካሊ፥ የሱሳ ኡንታጎ፥ «ታኒ ይንታና ኮሮጆ፥ ካርጽተን ጫማ ባይዝን ኪተዘ ዎደ ይንትስ ፋጭደባዝ የነ?» ያጋእ ኦጭዳ። ኡን ማህ፥ «አኮን ፋጭካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ኤ ኡንታጎ፥ «Ꮉተ ኮሮጆን ካርጥተ የዘ አይኮ፤ ማሻ ባይዘ ፋ አፉልቶ ባይዝ ማሻ ዎንጎ። ");
INSERT INTO oyde_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ꮉኖ ስኦተ! ‹ገኑንꬃራ ፋይድንትዳ› ጋእንት ጻፍንትዳና ታ ግዳ ፎልንቶደስ ቤዛነ። ዬ፥ ታ ግሾ ጻፍንትዳና ፎልንትዛና ቱርꬍዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ኤ ታማሩንꬅ፥ «ላꬆ Ꮉነ ላምእ ማሻ የነ» ያጋይዳ። ኤ፥ «ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","የሱሳ ትኖፓ ከዝዛን ጋራ ደንዲ ሻማሄ ደርዘላ ከዝዳ። ኤ ታማሩንꬅ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ይና በስተ የልደ ዎደ «ማꬋ ገላመ ፋና ዎሶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ኡንታፓ ሹች ꬎግን የሎደ በሲ ጋር Ꮉኪ ቡንቁንቲ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«ታ አዳዮ፥ ነ ቆፋ ማቅኮ Ꮉና ማꬋ ጹኡቶ ታፓ ኣꬆ። የዝን ታ ቆፋ ማቅፐ ነ ቆፋ Ꮉኖ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ኪታንቾ ሳሎፓ በንቲ ምንꬅꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ጋማ ኡንእንት ምንꬂ ዎሳነ። ኤ ጫዉታን ሱꬅ ጾክዘ ጋር ሳእተ ጾካነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","የሱሳ ዎሳ ፖሊ ፋ ታማሩንꬃጎ ይእዳ። ኡን፥ አዛኖፓ ደንዲ ላቢ ገንተዝን ደንግ፥ ");
INSERT INTO oyde_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«አኮስ ገንተ? ፋታና ገላመ ፋና ደንዲ ዎሶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ኤ Ꮉጋ ኦሄላ አፋ የዝን ጋማ አሱንꬅ ይእዳ። ታጶ ላምኡንꬃፓ ፈተ ይሁዳ ጋእንትዘ ኡንታና ካልꬃነ። ኤ የሱሳ ዬሮደስ ካለ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","የዝን የሱሳ፥ «ይሁዳ፥ አስ ናአያ ዬሪ አꬂ እንጎዳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","የሱሳ ታማሩንꬅ ይና Ꮉንዛኖ ብእ፥ «ላꬆ ማሻራ ጋቾ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ኡን ግዳፓ ፈተ ካህኑንꬅ Ꮉላቅዛ ጉዲ ምዛቅ Ꮉይዛ ጋቺ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","የዝን የሱሳ፥ «አሾ! ካይፐተ» ያጋይዳ። አꬄ Ꮉይዛ ቦቺ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ይንፓ ሱባ፥ የሱሳ ፋና አይኮደስ ይእደ ካህኑንꬅ Ꮉላቁንꬃጎ፥ ጾዘ ኬꬃ ናግዙንꬅ ሹሙንꬃጎን ጭሙንꬃጎ፥ «ፋኖ አይክዘ አስ ፋና ማሻን ጉፈ አይኪ ይእዳተ? ");
INSERT INTO oyde_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ኡባ ዎደ ጾዘ ኬꬅተ ታ ይንታራ የዘ ዎደ ታላ አፋ ኩሸ ጋድካያ። የዝን Ꮉና ꬉማ ካእቱሞ አህዘ ዎደን ይን ዎደን» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ይንፓ ሱባ፥ የሱሳ አይኪ ካህኑንꬅ Ꮉላቅዘ ዎፋ ካንግዳ። ጴጥሮሳ Ꮉኮራ የሱሳ ካላነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","አሱንꬅ ካህኑንꬅ Ꮉላቅዘ ዎፋ ታማ ኤꬂ ዎላ በቴዝን ጴጥሮሳ ኡንታራ ፈትላ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ፈቲ አርታ ጴጥሮሳ ታማ ካለ በትዳኖ ዳኪ ብእ፥ «Ꮉይ አꬄ ኤራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","የዝን ጴጥሮሳ፥ «Ꮉና ማችተ ታ የ አꬃ ኤሮስ» ያጋእ ካድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ኤራꬅ ዎደፓ ሱባ ፈቲ መለ አስ ኤዛ ብእ፥ «ኔንን ኡንታፓ ፈታ» ያጋይዳ። የዝን ጴጥሮሳ፥ «Ꮉይ አꬃዮ ታና ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ፈቲ ሳተ ጋር ጋምእዳንፓ ሱባ ፈቲ መለ አꬄ ሎይꬂ፥ «Ꮉይ አꬃይ ጋልላፓ ማቃደ ግሾ ሶኤ ባይዝን ኤራ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","የዝን ጴጥሮሳ፥ «Ꮉይ አꬃዮ፥ ነ ጋዛያ ታ ኤሮስ» ያጋይዳ። ኤ ይና ኦህቶ Ꮉስካይዝን ሉኩለ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ላꬂ ሱባ ማቂ ጴጥሮሳ ብእዳ። ጴጥሮሳ፥ «Ꮉይኖ ሉኩለ ኦሎዳንፓ ቲኖ ነ ታና Ꮉይꬕ ቶሄ ካዶዳ» ያጋእ፥ ላꬂ ኦህደ ቃልቶ ቲርዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ጴጥሮሳ ባለ ኬዚ ጋማ ጎቂ ዬክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","የሱሳ ናግዘ አሱንꬅ ኤዛ ለቀን Ꮉ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ኤ ኣፍቶ ጎዚ «አነ ትንቢተ ኦሆ፤ ነና Ꮉꬍደ ኦደ?» ያጋእ ኦጫነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","መለ ጋማ ለቂ ጫዣነ። ");
INSERT INTO oyde_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ሳአ ዎንትዘ ዎደ አይሁደ ሳአ ጭሙንꬅ፥ ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬃጎን ሻንጉንꬃጎ ሺቂ፥ የሱሳ ፋ ቲኖ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ኡን፥ «ነ ክርስቶሳ? አነ ኑስ ኦሆ?» ያጋእ ኦጭዳ። የሱሳ፥ «ታ ኦህዛኮ አማኖስ። ");
INSERT INTO oyde_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ታ ኦጭዛኮ ማሆስ። ");
INSERT INTO oyde_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","የዝን አስ ናአይ Ꮉንፓ ጎደ ባጋ ዎልቃማ ጾዘ ምዛቅ ባጋ በቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","የ ዎደ ኡባና፥ «ዬዝን፥ ነ ጾዝ ናአ?» ያጋይዳ። ኤ፥ «ታ ጾዘ ናአ ይን ጋይዳን ፋና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ኡን፥ «ይኬ፥ መለ ማርካ አኮ ኮሸ? ኤ ፋ እልአንꬅተ ኦሆደራ ኑ ስእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ይና በስተ ሺቅደ ሻንጉንꬅ ኡባና ደንዲ የሱሳ ጵላጦሳጎ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","«Ꮉይ አꬄ ኑ አሱንꬃና ባልꬆደራ፥ ሮመ ካትስ ጊራ ጊራመ ፋና ካዮደራን ማህ፥ ‹ታኒ ክርስቶሳ ይን ካት› ያጋዝን ደንግዳ» ያጋእ ሞትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ጵላጦሳ የሱሳ፥ «ኔኒ አይሁዱንꬅ ካትነ?» ያጋእ ኦጭዳ። የሱሳ፥ «የ፥ ነ ጋእዳን ጋር» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ጵላጦሳ ካህኑንꬅ Ꮉላቁንꬃጎን አሱንꬃጎ፥ «Ꮉይ አꬄላ አፋ ታ ፈቲ ባላ ባዝ ደንግካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","የዝን ኡን፥ «Ꮉይ አꬄ ጋልላፓ አይኪ Ꮉኖ የሎደስ ይሁዳ ኩሙꬅ ኢታባዝስ ደንꬅꬃነ» ያጋእ ምንꬂ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ጵላጦሳ ይኖ ስኤዘ ዎደ የሱሳ ጋልላ አስ የዛኮ ኤሮደስ ኮይ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","የሱሳ ሄሮድሳ ሳአፓ ይእደ አስ ማቅዛኖ ጵላጦሳ ኤርደ ዎደ ሄሮድሳ የ ዎደ የሩሳላመ የዘ ግሾ ኤጎ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮድሳ የሱሳ በአደስ ጋማ ዎደፓ ኮይተራ የዘ ግሾ ኤዛ በኤዘ ዎደ ጋማ ኡፋይትዳ። አኮስ ጋይኮ፥ ኤ ባዝ ስእደ ግሾ ጋማ ቆፍዘ ባዝ ኦችን በአደስ አሙꬍተር የነ። ");
INSERT INTO oyde_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ሄሮድሳ የሱሳ ጋማ ኦች ኦጭዳ፥ የዝን ኤ አኮን ማህካያ። ");
INSERT INTO oyde_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ካህኑንꬅ Ꮉላቁንꬅን ህገ አስታማሩንꬅ እዘ ኤቂ ምንꬂ ኤዛ ሞታነ። ");
INSERT INTO oyde_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ሄሮድሳራን ኤ ዎታዳሩንꬃራ የሱሳ ቶቺ ለቂዳ። ቦንቾ አፉላ ማእሲ ጵላጦሳጎ ማህ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ሄሮድሳራን ጵላጦሳራ ቲኖ ሞርከየዝን የ ዎደ ዎላ ጊግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ጵላጦሳ ካህኑንꬅ Ꮉላቁንꬃና፥ አስ አህዙንꬃናን ፈትላ ጼጊ፥ ");
INSERT INTO oyde_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","« ‹Ꮉይ አꬄ አስ ዎቦ ባዝስ ደንꬅꬃነ› ጋእ ታጎ ክእዳ። ታንን ይን ቲንተ ቁርችን ይን ሺሽደ ሞትስ አኮ ባላ ባዝ ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ሄሮድሳ፥ ይኒ ጋር አኮ ባላ ባዝ ኤላ አፋ ደንግካይዘ ግሾ ኑጎ ዳክዳ። ቱሮን Ꮉይ አꬄ Ꮉይቆስ የልꬅዘ አኮ ባላ ባዝ ኦችካያ። ");
INSERT INTO oyde_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ይኒ ግሾ፥ ኤዛ ጋራፊ ብሊ ዳኮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ይኖ ኤ ጋእዳና ፋስካ ባአለ ዎደ ፈቲ አስ ኡንትስ ብሎዳና ኤስ አታመባዝ ማቅደ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ዎርዡንꬅ ኡባ ፈትላ፥ «Ꮉይ አꬃ ዎꬎ፥ ኑስ ባርባነ ብሎ» ያጋእ ኡህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ባርባነ ካታማ ግዳ አሱንꬃና ኢታባዝስ ደንꬅꬂ አስ ዎꬊ አጭንትደ አስ። ");
INSERT INTO oyde_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ጵላጦሳ የሱሳ ብሎደስ ኮይ አሱንꬅስ ማህ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ማቅኮን፥ አሱንꬅ፥ «ሱጾ! ሱጾ!» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ጵላጦሳ Ꮉይꬓንꬆ፥ «Ꮉይ አꬄ ቆህደ ባዝ አኮ? ዎስ የልꬅዘ ባላ ታ ደንግካያ። ይኒ ግሾ፥ ጋራፊ ዳኪ አሾዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ኡን ፋ ቃልቶ ꬎቅ ዪዚ፥ «ሱጹንቶደስ ቤዛነ» ጋእ ምንꬂ ኡክዳ። ኡን ኡክ ጋምዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ኡን ኦጭት ግሾ ጋእ ጵላጦሳ ኤላ ፍርድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","አስ ኢታባዝስ ደንꬅꬅዛያን አስ ዎꬊ አጭንትዳያ ብሎደ ፋና ዎስዳ፥ የ አꬃ ኡንትስ ብልዳ። የዝን የሱሳ ኡን ኮይደባዝ ኦቾደ ጋር ኡንትስ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","የሱሳ አይኪ ካንጎደራ ስሞና ጋዘ ቀሬና ሳአ አꬄ ጋጻረፓ የኦደራ፥ ደንግ ማስቃላ ቶሲ የሱሳ ካሊ Ꮉማደ ፋና ኡንእꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ጋማ አሱንꬅን ፋ ዳዳብቶ ቆጽተራ ዬክዘ ማቹንꬅ ኤ ሱባራ ካላነ። ");
INSERT INTO oyde_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","የዝን የሱሳ ኡንታጎ ሱባ ማቂ፥ «ይን፥ የሩሳላመ ማቹንꬆ፥ ይን ኦምትስን ይን ናኡንꬅስ ዬኮተፕ አትን ታስ ዬክፐተ። ");
INSERT INTO oyde_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‹ይኬ ꬎኦንꬁንꬅን፥ የልካይዘ ሳዝታን ꬋንꬅካይዘ አምታ አንጅንትዳ› ይን ያጋዉደ ቃማ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","የ ዎደ ደርቶ፥ ‹ኑላ አፋ ጎልኦ›፥ ዞዝቶን፥ ‹ኑና አቾ› ጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ይኬ፥ ቃየ ምንጻላ Ꮉኒ ጋር ዪዝኮ መላ ምንጻላ ዋይሳድ የሳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ኤዛራ ዎꬎደስ መለ ላምእ ኢታ ባዝ ኦችዱንꬃና ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ቄራንዮ ጋእንትዘ በስቶ የልꬅ ሱጽዳ። ኢታ ባዝ ኦችዱንꬃፓ ፈታ ምዛቅ ዛላራ Ꮉንካያ ዎርክታ ዛላራ ሱጽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","የሱሳ፥ «ታ አዳዮ፥ ኡን አኮ ኦችዛኮ ኤሮሰ ግሾ ነ ኡንትስ አቶ ጋኦ» ያጋይዳ። ኡን ኤ አፉልትላ አፋ እጻ ኦሊ ሻክንት ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","አሱንꬅ ኤቂ በእነ፥ የዝን ጋደ አህዙንꬂ፥ «መሉንꬃና አሽዳ፤ ጾዚ ዶርደ ክርስቶሳ ኤ ማቅዛኮ አነ ፋና አሾ» ያጋእ ለቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ዎታዳሩንꬅ ኤ ካለ ሺቂ፥ ጫላ ዎይነ ኡሽ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","የይዝ፥ «ኔኒ አይሁዱንꬅ ካት ማቅኮ ነ ኦምቶ አሾ» ያጋእ ለቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ኤስ ኦማ ዛላራ፥ «Ꮉይ አይሁዱንꬅ ካት» ያጋዘ ጹፈ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ሱጹንትደ ኢታ ባዝ ኦችዱንꬃፓ ፈተ ጫሽ ሳአራ ጎችተራ፥ «አነ ኔኒ ክርስቶሳ ማቅኮ፥ ነናን ኑናን አሾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","የዝን Ꮉንካይ፥ «ነ Ꮉኒ ጋር ፍርዳ የዝተ መለ አቶ የዝን፥ ጾዝስ ዣሽቶሳ? ");
INSERT INTO oyde_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ኑኒ ኑ ባልትስ ቤዝዘ ፍርዳ ኤካነ፥ የዝን Ꮉይ አꬄ ፈቲ ኢታባዝን ኦችካያ» ያጋእ ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ማህን፥ «የሱሳ፥ ነ ነ ካእቱሞራ የእዘ ዎደ ታና ቆፖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","የሱሳ፥ «ታ ኔስ ቱሮ ኦህነ፤ Ꮉይኖ ነ ታራ ጋናተ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","የ ዎደ እዝፑን ሳተፓ Ꮉንግ ኡዱፉን ሳተ የሎደስ አዋ ፎእቶ ካይደ ግሾ ሳአ ኡባነ ꬉማ ማቅዳ። ጾዘ ኬꬃ ማጋራጅታ ፌꬍንቲ ላምእ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","የሱሳ፥ ቃልቶ ꬎቅ ዪዚ፥ «ታ አዳዮ፥ ታ ታ ሸምፕቶ ነ ኩሽተ እንጋነ» ያጋእ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ማቶ Ꮉላቅዘ፥ Ꮉንዳኖ ብእ፥ «Ꮉይ አꬄ ቱሮ ጽሎ» ያጋእ ጾዝ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ይና Ꮉንደ ባዝቶ ቦኦደስ ይና በስተ ሺቅደ አስ ኡባና Ꮉንዳኖ በኤዘ ዎደ ፋ ዳዳብቶ ቆጽተራ ፋ ካራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ማቅኮን፥ የሱሳ ካለራ ኤርዘ አሱንꬅ ኡባና፥ ይኒ ጋራ ጋልላፓ ካሊ ይእደ ማቹንꬅ ይኖ ብእተ Ꮉኮራ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","አይሁደ ሻንጉንꬃፓ ፈታይ፥ ዮሰፋ ጋእንትዘ አꬄ የነ። ኤ አርማትያሳ ጋእንትዘ ይሁዳ ካታማፓ ይእዳ። ኤ ሎኦን ጽሎ አስ ማቅደ ግሾ ጾዘ ካእቱሞ የእቶ ናጋነ። ሻንጉንꬃፓ ፈታ ማቂ ኡን ዞርንተን ኦችተ ባያ። ");
INSERT INTO oyde_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","የ አꬄ ጵላጦሳጎ Ꮉንግ፥ የሱሳ አህቶ ሞጎደስ ታስ እንጎ ጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","የሱሳ አህቶ ኬꬂ አፉላራ ጻጽዳ። ላላፓ ዎጭንትደ ዎምኦ መለ አስ ሞግንትካይዘ ቦዝተ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ሳምባታ ገሎደስ ዪዘ ግሾ ይና ዎድታ ጊግንተ ቃማ። ");
INSERT INTO oyde_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ጋልላፓ ደንዲ የሱሳ ካሊ ይእደ ማቹንꬅ ዮሴፋራ Ꮉንግ ኤ አህቶ ዋይዝ ሞግዛኮ ቦዝቶ አካኪ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","እዝፓ ማቂ ሽቶን ቅባተ ጊግዝዳ። ህገ ኪትዛን ጋር ሳምባታ አዋርቶ ሸምፒ ፔዥዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ሳምንታፓ ቲኖ ቃማ፥ ዎጋ ዎደ ዎንታ ጎዳ፥ ማቹንꬅ ፋ ጊግዝደ ሽቶ ኤኪ ቦዛ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ኡን እዘ የልዘ ዎደ ቦዛ ዶንተ የዘ ሹችታ ጎልእ Ꮉልእዳኖ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ኡን ቦዛ ጋꬅ ገልዳ፥ የዝን ላꬄ የሱሳ አህቶ ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ኡን እዘ ኤቂ አኮ Ꮉንዶ ጋእ ቆፖደራ አካክካይዝን ጋማ ፎእዘ አፉላ ማእደ ላምእ አሱንꬅ ኡን ካለ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ማቹንꬅ ዣሽቲ ፋ ኦምቶ ሳአ ዝቂ ዪዚ የሳደራ፥ አሱንꬅ ኡንታጎ፥ «ፋጻ የዛያ Ꮉይቁንꬅ ግዳ አኮስ ኮየተ? ");
INSERT INTO oyde_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","ኤ Ꮉነ ባያ፤ Ꮉይቆፓ ደንድዳ፥ ‹አስ ናአይ ናጋራንቹንꬅ ኩሽተ አꬊ እንግንቶዳ፤ ኡንትን ኤዛ ሱጾዳ። ኤ Ꮉይꬓንꬆ ቃምተ Ꮉይቆፓ ደንዶዳ› ያጋእ፥ ኤ ይንታራ ጋልላ የዝተ ይንትስ ኦህደ ቃልቶ ቆፖተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ማቹንꬅ የ ዎደ ኤ ቃልቶ ቲርዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ማቹንꬅ ቦዛፓ ማቂ Ꮉንደ ባዝቶ ኡባ ታጶ ፈቱንꬅስን መሉንꬅስን ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","የንꬅ ሐዋሩንꬅስ ኦህደ ማግደላ ማይራሞ፥ ዮሐና፥ ያይቆባ እንታ ማይራሞን ኡንታራ የዘ መለ ማቹንꬃና። ");
INSERT INTO oyde_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","የዝን ኡንትስ ማቹንꬅ ኦህዳና አቡኮ ጋራ ይእን አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","የዝን ጴጥሮሳ ደንዲ ዎጺ ቦዛ ቅትዳ። የ በስቶ የሊ ዙጊ ግዳ በእዘ ዎደ ሞግደ አፉላ ጻላላ ብእዳ። Ꮉንዳነ ጋማ ቆፒ ፋ ካራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","የ ዎደ ካልዘ ታማሩንꬃፓ ላምኡንꬅ የሩሳላመፓ ታጶ ፈቲ ክሎ ምትረ Ꮉክዘ ኤማሁሰ ካራ ጋንጨ Ꮉንጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ኡን ዎላ Ꮉንደ ባዝቶ ኡባ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ኡን ይና Ꮉንዳን ባዝ ቲርተራን ኦህንትተራ የꬍዘ ዎደ የሱሳ ፋ ኦምትስ ሺቂ ኡንታራ Ꮉንጋነ። ");
INSERT INTO oyde_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","የዝን፥ ኡን ኤዛ ኤራመ ፋና ኡን ኣፍታ አይክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ኤ፥ «ይን ዎላ ኦገላ የዝተ ኦህንትዛና አኮ?» ያጋይዳ። ኡን አዛኒ ስእ ጋእ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ኡንታፓ ፈተ ቀልዮጳ ጋእንትዘ፥ «Ꮉና ቃምት ግዳ የሩሳላመ Ꮉንዳኖ ኤሮሰ፥ ነ ሳእትስ ዛቆነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ኤ ማህ፥ «እዘ Ꮉንዳና አኮ?» ጋእ ኦጭዳ። ኡን፥ «ጾዘ ቲኖን አስ ቲኖን ኦቻራን ኦሄራ ምንꬂ ናበ ማቅደ ናዝረተ የሱሳ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ኤዛ ካህኑንꬅ Ꮉላቁንꬅን ኑና ካልꬅዙንꬅ Ꮉይቆ ፍርዳስ አꬂ እንግ፥ ሱጽዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ኑኒ እስራኤለ አሱንꬃና አሾዳ ጋእ ኡፋይት ናገዝን Ꮉና Ꮉንን Ꮉይኖ Ꮉይꬓንꬆ ቃማ። ");
INSERT INTO oyde_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ማህ ኑ ግዳፓ ፈቲ ፈቲ ማቹንꬅ ኑና ጋማ ቆፍዝዳ። ኡን Ꮉይኖ ዎንታ ጎዳ ቦዛ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ኤ አህታ ꬋብደ ዎደ ማቂ ይእ፥ ‹ኤ ፋጻ የነ› ያጋዘ ኪታንቹንꬅ ቆንጭን ብእዳ ያጋእ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ኑ ግዳፓን ፈተ ፈተ ቦዛ Ꮉንግ ማቹንꬅ ኦህዳን ፋና Ꮉንን ብእዳ፥ የዝን ኤዛ ብእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ኤ ኡንታጎ፥ «ይን፥ ቲሮሰ አሱንꬆ፥ ይን ዎዝንታ ናቡንꬅ ኦህዳኖ ኡባ አማኖደስ ጋምእዙንꬆ፥ ");
INSERT INTO oyde_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ክርስቶሳ ይና ማꬍቶ ኤኮደስን ፋ ቦንቾራ ገሎደስ ቤዞሳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ሙሴፓን ናቡንꬅ ኡባንፓ ደንዲ ጌሽ ማጻፍተ ኤ ባዝ ጻፍንትዳኖ ኡባ ኡንትስ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ኡን Ꮉንግዘ ካራ ጋንጨ ኡክደ ዎደ የሱሳ አꬊ Ꮉኮ በሳ ቅትዘ ጋራ ይእን፥ ");
INSERT INTO oyde_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ኡን፥ «ሳእታ ቃምደ ግሾ ኑራ አቆ» ያጋእ ምንꬂ ዎስዳ። ይኒ ግሾ፥ ኡንታራ አቆደስ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ኡንታራ ዎላ ሌማተላ በቲ፥ ሶሎ ደንꬂ፥ ፌꬊ አንጂ ኡንትስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","የ ዎደ ኡን ኤሮደ ጋር ኡን ኣፍታ ቡጉንትዳ። ኡንትን ኤርዳ። የዝን ኤ ኡንታፓ ገንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ኡን፥ «ኑ ኦገላ አፋ የዝን ኤ ኑስ ጌሽ ማጻፈ ብልተራን ኑና ኦህዝተራ ኑ ዎዝንታ ኤጽካ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","የ ዎደ ደንዲ ሱባ የሩሳላመ ይእዳ። ታጶ ፈቱንꬅን መሉንꬅ ፈትላ ሺቂ የሳደራ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ኡን፥ «ላꬂ ቱሮ ደንድዳ፤ ስሞናስ በንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","የንꬅ ላምእ ታማሩንꬅ ኤማሁሰ ኦገላ የዝን Ꮉንዳኖን ሶሎ ፌꬍደ ዎደ ዋይዝ ኤዛ ኤረዛኮ ኡንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ላምእ ታማሩንꬅ ይና ኦህትላ የዝን፥ የሱሳ ኡን ግዳ ኤቂ፥ «ሳሮ ይንትስ ማቀ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ማቅኮን፥ ኡን ታኒ፥ ሜሸ ብእደ ጋራ ይእን ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ኤ ኡንታጎ፥ «አኮስ ዣሽትዶ? አኮስ ሶኤ ይን ዎዝንተ ገልዶ? ");
INSERT INTO oyde_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ታ ኩሽቶን ታ ቶህቶ ቦኦተ፤ ታ ታና። ማህ አይኪ ቦኦተ፤ ታና ይን በእዛንጋራ፥ ሜሸስ አሾን መቃꬂ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ያጋእ፥ ፋ ቶህቶን ፋ ኩሽቶን ኡንታና ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ኡን ኡፋይሳፓ ደንድዳንፓ አማናንጺ ጋማ ቆፒ የዝን፥ የሱሳ ኡንታጎ፥ «Ꮉነ ይንትስ ሙእዘባዝ የነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ኡን ፈቲ ምችንትደ ሞሎ ኤስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ኤ ኤኪ ኡን ቲንተ ሙእዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ኤ፥ «ታ ይንታራ ጋምእደ ዎደ ኡባነ ሙሴ ህገ ማጻፍተ፥ ናቡንꬅ ማጻፍተን ማዝሙረ ማጻፍተ፥ ታ ግሾ ጻፍንትዳና ኡባና ፎልንቶደስ ቤዛነ ያጋእ ታ ይንትስ ኦህደ ቃልታ Ꮉኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","የ ዎደ ጌሽ ማጻፍቶ ቲሮደ ጋር ዎዝንቶ ኡንትስ ቡግዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ይኒ ፋና፥ «ክርስቶሳ ማꬋ ኤኮዳ፥ Ꮉይꬓንꬆ ቃምተ Ꮉይቆፓ ደንዶዳ ያጋእ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","የሩሳላመፓ ደንዲ አስ ኡባና ናጋራፓ ማሮትꬅን አቶተꬅ ኤ ሱንꬅተ ማርክꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ይን ይንስ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ይኬ፥ ታንን ታ አዳይ እንግደ ኡፋይስቶ ይንትስ ዳኮዳ። ይን ሳሎፓ ዎልቃ ኤኮደ ዎንꬅስ የሩሳላመ ካታማ ጋምኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ይንፓ ሱባ፥ ብታንያ ካታማ ኡንታና ኤኪ Ꮉንግዳ። ፋ ኩሽቶ ደንꬂ አንጅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ኡንታና አንጅተ ኡንታፓ ሻክንት ኡደ ሳሎ ኤክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ኡን ዙጊ ጎይኒ ጋማ ኡፋይሳራ የሩሳላመ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ጾዛ ኡባ ዎደ ጋላትተራ ጾዘ ኬꬃ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ቃላ ቲኖ የነ። ቃልዘን ጾዛራ የነ፤ የ ቃልዘ ጾዚ። ");
INSERT INTO oyde_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ኤዝን ቲኖፓን ጾዛራ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ጾዘ ኡባባዝቶ ቃላ ባጋራ መꬍዳ። መꬍንትደ ባዛፓ ፈትባዝን ኤ ባይꬅ መꬍንትደ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ኤ ግዳ ደኦ የነ፤ ይና ደእታን አስስ ፎኦ። ");
INSERT INTO oyde_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ፎእዘ ꬉማ ግዳ ፎአነ፤ ꬉምታ ፎእዛ ጋምካያ። ");
INSERT INTO oyde_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ጾዛፕ ኪትንትደ፥ ዋሐንሳ ጋእንትዘ ፈቲ አስ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","አስ ኡባ ፎእዛ አማኖደ ፋና ኤ ፎእዘስ ማርካ ማቂ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ኤ ፎእዘ ባዝ ማርክꬎደስ ይእዳፕ አትን ፋ ኦምተ ፎኦ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","አስ ኡባስ ፎእዘ ቱሪ ፎኦ አላመ የእነ። ");
INSERT INTO oyde_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ቃልዘ አላመ የነ። ጾዘ ቃላራ አላምቶ መꬍዳ፥ የዝን አላምታ ኤዛ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ኤ ፋ ባጉንꬃጎ ይእዳ፥ የዝን ኤ ባጉንꬅን ኤዛ ኤክካያ። ");
INSERT INTO oyde_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","የዝን ኤ ፋና ኤክዱንꬅስን ኤ ሱንꬅተ አማንዱንꬅስ ኡንትስ ጾዘ ናአ ማቃደ ጋር አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ኡን ጾዛፓ የልንትዳፕ አትን አስ የልንትዘ ዎጋራ ዎይ ꬊራꬅ ቆፋፓ ዎይ አስ ቆፋፓ የልንትካያ። ጾዘ ኤ ኡንትስ አደ። ");
INSERT INTO oyde_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ቃላ አሾ ማቅዳ፤ አꬎ ኬሃትꬃራን ቱረትꬃራ ኩሚ ኑ ግዳ አቅዳ። ፈቲ ናአይስ ኤ አዳይ ካለ የዘ ቦንችት ፋና የዘ ቦንቾ ኑ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ዋሐንሳ ኤ ባዝ ማርክꬍዳ። ፋ ቃልቶ ꬎቅ ዪዚ፥ «ታኒ፥ ‹ታፓ ሱባራ የእዘ ታፓ ቲኖ የዘ ግሾ ታፓ አꬋነ› ጋእ ማርክꬍዳና Ꮉኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ኑ ኡቡንꬅ ኤ አꬎ ኬሃትꬅተ ኩሙꬅትፓ አንጆላ አፋ አንጆ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ጾዘ ህገ ሙሴ ባጋራ እንግዳ፥ የዝን አꬎ ኬሃትꬅን ቱረትꬅ የሱስ ክርስቶሳ ባጋራ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ጾዛ ብእደ አስ ኦደን ባያ፤ ፋ አዳይ ካለ የዘ ፈቲ ናአይ ጾዝ ማቅደ ኤ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","የሩሳላመ የዘ Ꮉላቁንꬅ፥ ካህኑንꬅን ሌዉንꬅን፥ «ነ ኦደ?» ጋእ፥ ዋሐንሳ ኦጮደ ጋር ኤጎ ኪትን፥ ዋሐንሳ ኡንትስ ማርክꬍደ ማርካትꬅታ Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ዋሐንሳ፥ «ታ ክርስቶሳ ባያ» ያጋእ፥ ሎይꬂ ማርክꬍዳፕ አትን ካድካያ። ");
INSERT INTO oyde_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ኡን፥ «ዬዝን፥ ነ ኦደ? ኔኒ ኤልያሳነ?» ጋእ ኦጭዳ። ዋሐንሳ፥ «አደ ታና ባያ» ያጋይዳ። ማህ ኡን፥ «ኔኒ የኦደስ ጋእንተዘ ናበነ?» ጋእ ኦጭዳ። ዋሐንሳ፥ «አደ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ዬዝን፥ «ነ ኦደ? ኑ ኑና ኪተዙንꬅስ ኦሆደ ፋና ኔኒ ነና ኦና ጋኤ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ዋሐንሳ ማህ፥ ናበ ኢሳያሳ ጋእዳን ጋራ፥ « ‹ላꬄ ኦግቶ ሉልዞተ!› ጋእ አኮ ባይዘ ጋናሳ ኡክዘ አꬄ ቃልዘ ታና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","የዝን ፋርሳዉንꬅ ኪትደ አሱንꬅ ");
INSERT INTO oyde_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ዋሐንሳጎ፥ «ኔኒ ክርስቶሳ ዎይ ኤልያሳ ዎይ ናበ ማቃንጽ እጽኮ፥ ዬዝን አኮስ ጻማቀ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ዋሐንሳ ማህ፥ «ታኒ Ꮉꬃራ ጻማቃነ፥ የዝን ይን ኤሮሰ አስ ይን ግዳ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ኤ ታፓ ሱብተ የእነ። ታ መለ አቶ የዝን ኤስ ጫማ ጋድዛ ብሎደስ ቤዞስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ይና ኡባ ዮርዳኖሳ ቦርካፓ ሰኮ ፍንꬃ፥ ብታንያ ካታምተ፥ ዋሐንሳ ጻማቅዘ በስተ Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ዋሐንሳ ዎንትስት ዎደ የሱሳ ፋጎ የኦደራ ብእ፥ «አላመ ናጋራ ኡጭዘ ጾዘ ዱርዛይ Ꮉይቼ! ");
INSERT INTO oyde_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ታኒ፥ ‹ታፓ ሱባራ ፈቲ አስ የኦዳ። ኤ ታፓ ቲኖ የዘ ግሾ ታፓ አꬋነ› ጋእ ኦህደ Ꮉያ። ");
INSERT INTO oyde_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ኤ ኦደ የዛኮ ታ ኤሮስ። የዝን እስራኤለ አሱንꬅስ ኤዛ ቆንጭሳደስ Ꮉꬃራ ጻማቅተራ ይእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ዋሐንሳ Ꮉንጋራ ጋእ ማርክꬍዳ፦ «ጌሽ አያና ሳሎፓ ዎለ ጋር ዎꬍዝን ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ይና Ꮉኖዳንፓ ቲኖ ታኒ ኤዛ ኤሮስ። የዝን Ꮉꬃራ ጻማቆደስ ታና ኪትደ ጾዘ፥ ‹ጌሽ አያና ዎꬊ ኤራ የሳደራ ኔኒ በእዘ ጌሽ አያናራ ጻማቆዳይ ኤዛ› ያጋእ ታስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ታኒ ይና Ꮉኖደራ ብእ፥ ኤ ጾዘ ናአ ማቅዳኖ ማርክꬋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ማህ ዎንትስት ዎደ ዋሐንሳ ፋ ታማሩንꬃፓ ላምኡንꬃራ ዎላ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","የሱሳ አꬎደራ ዋሐንሳ ብእ፥ «ጾዘ ዱርዘ Ꮉይንሸ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ላምእ ዋሐንሳ ታማሩንꬅ ዋሐንሳ ጋዛኖ ስእ የሱሳ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","የሱሳ ፋና ካልዙንꬃና ሱብ ማቂ ብእ፥ «አኮ ኮየ?» ያጋእ ኦጭዳ። ኡን ማህ፥ «ረቢ፥ ነ አባ የነ?» ያጋይዳ። (ብልꬅታ አስታማርዛዮ ጋኤ።) ");
INSERT INTO oyde_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","የሱሳ ኡንታጎ፥ «Ꮉንካ ይእ ቦኦተ» ያጋይዳ። ኡን Ꮉንግ ኤ የዘበዝቶ ብእዳ። የ ዎደ ሳእታ ታጵ ሳተ ጋር ማቅደ ግሾ ኤ ካለ ፌዥዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ዋሐንሳ ጋይዳኖ ስእ፥ የሱሳ ካልደ ላምእ ታማሩንꬃፓ ፈተ፥ ስሞን ጴጥሮሳ እሸ እንድርያሰ። ");
INSERT INTO oyde_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","እንድርያሰ ቲኖ ፋ እሸ ስሞናራ የልንት፥ «ኑኒ መሲህ ደንግዳ» ያጋይዳ። (ብልꬅታን ክርስቶሳ ጋኤ።) ");
INSERT INTO oyde_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","እንድርያሰ ስሞና የሱሳጎ ክእዳ። የሱሳ ስሞና ብእ፥ «ነ ዮና ናአ ስሞና፤ ነ ሱንꬅታ ኬፋ ጋእ ጼግንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ዎንትስት ዎደ የሱሳ ጋልላ ቅቶደስ ቆፋ አጭዳ። ኤ ፍልጶሳ ደንግ፥ «ታና ካሎ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ፍልጶሳ፥ እንድራሰራን ጴጥሮሳራን የዘ ቤተሳይዳ ካታማ አስ። ");
INSERT INTO oyde_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፍልጶሳ ናትናኤላ የሊ፥ «ሙሴ ህገ ማጻፍተ፥ ማህ ናቡንꬅን ኤ ባዝ ጻፍደ ዮሰፋ ናአ ናዝረተ የሱሳ ኑ ደንግዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ናትናኤላ ማህ፥ «ናዝረተ ካታማፓ ሎኦ ባዝ ኬሳደስ ዳንዳአነ?» ያጋይዳ። ፍልጶሳ፥ «ይእ ቦኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ናትናኤላ ፋጎ የእዛያ የሱሳ ብእ፥ «ገነ ባይዘ ቱሪ እስራኤለ አስ Ꮉይንሸ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ናትናኤላ የሱሳጎ፥ «ነ ታና አባ ኤረ?» ያጋይዳ። የሱሳ ማህ፥ «ፍልጶሳ ነና ጼጎዳንፓ ቲኖ፥ ነ በለሰ ምንጻ ኦሞ የዝን ታ ነና ብእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ናትናኤላ ማህ፥ «አስታማርዛዮ፥ ነ ጾዘ ናአ! ነ እስራኤለ ካት!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","የሱሳ ኤጎ፥ «ታ ነና በለሰ ምንጻ ኦሞ ብእዳ ጋይደ ግሾ አማናነ? ነ Ꮉንፓ አꬍዘባዝ በአዳ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ማህ የሱሳ፥ «ታኒ ይንትስ ቱርባዝ ኦህነ፤ ሳሎ ቡጉንትን፥ ጾዘ ኪታንቹንꬅ አስ ናአላ አፋ ኬሳደራን ኬዶደራን ይን በአዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ꮉይꬓንꬆ ዎደ ጋልላ ቃና ካታማ ዣጋና የነ። የሱሳ እንታ ይና ዣጋንተ የሻ። ");
INSERT INTO oyde_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","የሱሳን ኤ ታማሩንꬅን ዎላ ይና ዣጋንተ ጼግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ዎይነ ኡሽታ Ꮉልእን፥ የሱሳ እንታ የሱሳጎ፥ «ኡንትስ ዎይነ ኡሽታ Ꮉልእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","የሱሳ ማህ፥ «እሞ፥ ነ Ꮉነ ገልፐ? ታ ዎድታ Ꮉጋ የልካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","የሱሳ እንታ ኦችዙንꬃጎ፥ «ኤ ይንትስ ኦህዛኖ ኡባ ኦቾተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","አይሁዱንꬅ ፋ ጌሸ ዎጋስ ማድንትዘ እዝፑን ሹች ጋኑንꬅ ይና በስተ የነ። ፈተ ፈተ ላምእ ዎይ Ꮉይꬕ ጹጋ አይካነ። ");
INSERT INTO oyde_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","የሱሳ ኪትንትዙንꬃጎ፥ «ጋንተ Ꮉꬅ ኩንꬆተ» ያጋይዳ። ኡን ጋኑንꬅስ ዶንቶ የሎደስ Ꮉꬅ ኩንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","የሱሳ ኡንታጎ፥ «Ꮉተ ዱቂ ዣጋንቶ አድꬊ ፎልዘስ እንጎተ» ያጋይዳ። ኡን ኤስ ካንግ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ዣጋንቶ አድꬊ ፎልዛይ ዎይነ ኡሽታ ላምንትደ Ꮉꬅቶ ቃማስ ብእ አናፓ የኤዛኮን ኤርካያ፥ የዝን Ꮉꬅቶ ኩንꬅደ ኪትንትዙንꬅ ኤራነ። ዣጋንቶ አድꬊ ፎልዛይ ማቾ ኤክዛያ ጼጊ፥ ");
INSERT INTO oyde_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«ኦደን ሎኦ ዎይነ ኡሽቶ አስ ቲንꬊ ኡሻነ። የይዝ አሱንꬅ ኡዢ ምዥዳንፓ ሱባ ዣግንትዳ እንጋነ። የዝን ኔኒ ሎኦ ዎይነ ኡሽቶ Ꮉኖ የሎደስ ጋዲ ጋምእዝዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","የሱሳ Ꮉይ ቲኖ ክለ ኦችዛ ጋልላ ቃና ካታማ ኦችዳ፤ እዘ ፋ ቦንችቶ ቤዝዳ። ኤ ታማሩንꬅን ኤዛ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ይንፓ ማቂ፥ የሱሳ ፋ እንትራ፥ ፋ እሹንꬃራን ፋ ታማሩንꬃራ ዎላ ቅፍርናሆመ ካታማ Ꮉንግ ኤራꬅ ቃማ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","አይሁዱንꬅ ቦንችዘ ፋስጋ ባአለ ቃምታ ኡክን የሱሳ የሩሳላመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ꮉንግ ጾዘ ኬꬃ ቦራ፥ Ꮉር፥ ዱሮን ዎለን ባይዙንꬃናን ፋ ኦይድትላ በቲ ብራ ላምዙንꬃና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ኤ ጹርቃፋ ጊግዚ አሱንꬃና ኡባ ኡንታና ኡን Ꮉሩንꬃራ ጾዘ ኬꬃፓ ባይእ ባለ ከስዳ። ብራ ላምዙንꬃና ጠርጴዝቶን ሽሪ ኦሊ ኡን ብርቶ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ዎለ ባይዝዙንꬃና፥ «Ꮉንꬅ ዎሉንꬃና Ꮉንፓ ከሶተ፤ ታ አዳይ ኬꬅቶ ጋበ ማህፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ኤ ታማሩንꬅ ጌሽ ማጻፍተ፥ «ታ ነ ኬꬅትስ ይቅስንትዘ ይቅስንታ ታና ታማ ጋራ ምቻነ» ጋእንት ጻፍንትዳኖ ቲርዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ይንፓ ሱባ፥ አይሁዱንꬅ ማህ፥ «ነ Ꮉኖ ኦቾደስ ኔስ ዎልቃ የዛንስ ኑና አኮ ማላ ኦቺ ቤሳደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","የሱሳ፥ «Ꮉና ጾዘ ኬꬅቶ ዉልኦተ ታ Ꮉይꬕ ቃማራ ማህ ኬጾዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ይኒ ግሾ አይሁዱንꬅ፥ «Ꮉና ጾዘ ኬꬅቶ ኬጾደስ ኦይታም እዝፑን በረ ኤክዳ፥ የዝን ኔኒ Ꮉይꬕ ቃማራ ኬጾዳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","የዝን የሱሳ ኦህዘ ጾዘ ኬꬅታ ፋ አሽትባዝ። ");
INSERT INTO oyde_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ይኒ ግሾ፥ የሱሳ Ꮉይቆፓ ደንድዳንፓ ሱባ ኤ ታማሩንꬅ ኤ ይኖ ጋይዳኖ ቲርዳ። ማህ ኡን ጌሽ ማጻፍተ ጻፍንትዳኖን የሱሳ ኦህዳኖ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","የሱሳ ፋስጋ ቦንችዘ በሳ የሩሳላመ የሳደራ፥ ኤ ኦችደ ክለ ባዝቶ ብእ ጋማ አሱንꬅ ኤዛ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","የዝን የሱሳ አሱንꬃና ኡባ ኤርዘ ግሾ ኡንታና አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","አስ ዎዝንተ የዘ ባዝ ኤ ፋ ኦምተ ኤርዘ ግሾ አስ ባዝ ኦደን ኤስ ኦሆደ ጋር ኮሽካያ። ");
INSERT INTO oyde_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ፋርሳዉንꬅ ባጋፓ ማቅደ፥ አይሁዱንꬅ Ꮉላቃ፥ ንቆድሞሳ ጋእንትዘ ፈቲ አስ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ኤዝን ቃማ የሱሳጎ ይእ፥ «ቦንቾ አስታማርዛዮ፥ ኔኒ ጾዚ ኪትደ አስታማረ ማቅዛኖ ኑኒ ኤራነ። አኮስ ጋይኮ፥ ጾዚ ኤራ የዛንጽኮ Ꮉኖ ኔኒ ኦችዘ ክለ ባዝቶ ኦቾደስ ዳንዳእዘ አስ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","የሱሳ ማህ፥ «ታኒ ኔስ ቱሮ ቱሮ ጋነ፤ ኦደን ላምእንꬃ የልንታንጽኮ ጾዘ ካእቱሞ በአደስ ዳንዳኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ንቆድሞሳ፥ «ጭንጊ አሲ ዋይዝ ላምእንꬃ የልንቶደስ ዳንዳኤ? ፋ እንቲ ሳዛ ማቂ ገሊ ማህ የልንቶደስ ዳንዳአነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","የሱሳ ማህ፥ «ታኒ ኔስ ቱሮ ቱሮ ጋነ፤ አስ Ꮉꬃፓን ጌሽ አያናፓ የልንታንጽኮ፥ ጾዘ ካእቱሞ ገሎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","አሾ ናአትꬅ አደፓን እንድፓን የልንታነ፤ ጾዘ ናአትꬅ ጌሽ አያናፓ የልንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ታኒ፥ ‹ይን ላምእንꬃ የልንቶደስ ቤዛነ› ጋእ ይንትስ ኦህደ ግሾ ኔኒ ጋማ ቆእፕፐ። ");
INSERT INTO oyde_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ባቆ ፋ ኮይዘ ዛላ ባቃነ። ነ ኤ ኦꬅቶ ስእዛኖ ፋትን ኤ አባፓ የእዛኮ ዎይ አባ ቅትዛኮ ነ ኤሮስ። አያናፓ የልንትደ ኡባ ይኒ ፋና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ዬዝን ንቆድሞሳ፥ «ይና ዋይዝ Ꮉኖደስ ዳንዳኤ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","የሱሳ ማህ፥ «ኔኒ እስራኤሉንꬅ አስታማረ ማቅተራ Ꮉኖ ኤሮሳ? ");
INSERT INTO oyde_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ታኒ ኔስ ቱሮ ቱሮ ጋነ፤ ኑ ኤርዘባዝ ኦህነን ብእደባዝ ማርክꬋነ፥ የዝን ኑ ማርካትꬅቶ ይን ኤኮስ። ");
INSERT INTO oyde_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ታኒ ይንትስ ሳአባዝ ኦህን ይን አማኖሱንꬅ ሳሎባዝ ኦህን ዋይዝ አማኖደ? ");
INSERT INTO oyde_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ሳሎፓ ዎꬍደ አስ ናአይፕ አትን ሳሎ ከዝደ ኦደን ባያ፤ ሳሎ የዘ አስ ናአይ ታና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","ሙሴ አኮ ባይዘ ጋናስ ሳአ ሾሽ ሱጽዳንፋና ታና አማንዘ ኡቡንꬅ መዽና ደኦ ኤኮደ ፋናን ꬋባመ ፋና አስ ናአይ ሱጹንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ኤዛ አማንዘ ኡቡንꬅ መዽና ደኦ ላቶደፕ አትን ꬋባመ ጋር ጾዚ Ꮉና አላምቶ ሎይꬂ ካꬍደ ግሾ ፋ ፈቲ ናአያ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ጾዚ ፋ ናአያ Ꮉና አላምተ ኪትዳና አላምቶ ፍርዶደስ ማቅካይዝን አላምቶ ኤ ባጋራ አሾደስ። ");
INSERT INTO oyde_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ናአያ አማንዘ ኦደን ፍርድንቶስ፥ የዝን ናአያ አማኖሰ ኦደን ፈቲ ጾዘ ናአያ አማንካይዘ ግሾ Ꮉተ ፍርድንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ፍርድታን Ꮉኖ፦ ፎኦ አላመ ይእዳ፥ የዝን አሱንꬅ ኦችታ ኢታ ማቅደ ግሾ አሱንꬅ ፎእትፓ አꬂ ꬉማ ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ኢታ ባዝ ኦችዘ ኦደን ፎኦ እጻነ። አኮስ ጋይኮ፥ ፋ ኦችታ ቆንጫመ ፋና ፎኦጎ የኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","የዝን ቱርቶ ኦችዘ ኦደን ጾዘ ኪትዳን ፋና ኤ ኦችዳኖ ፎኦ ቆንጭሳደ ፋና ፎኦጎ የእነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ይንፓ ሱባ፥ የሱሳን ኤ ታማሩንꬅን ይሁዳ ሳአ ቅትዳ። የሱሳ የይጋ ጻማቅተራ ኡንታራ ኤራꬅ ዎደ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ማህ ዋሐንሳ ሳሌመ ካለ የዘ ሄኖና ጋዘ በሳ ጋማ Ꮉꬅ የዘ ግሾ አሱንꬃና የይጋ ጻማቃነ። አሱንꬅን የይጋ Ꮉንግ ጻማቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","የ ዎደ ዋሐንሳ Ꮉጋ አጭንትካያ። ");
INSERT INTO oyde_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ይንፓ ሱባ፥ ዋሐንሳ ታማሩንꬅን ፈቲ አይሁደ አꬃይ ጌሸ ዎጋባዝ ዎላ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ኡን ዋሐንሳጎ Ꮉንግ፥ «አስታማርዛዮ፥ ዮርዳኖሳ ቦርካፓ ሰኮ ፍንꬃ ኔራ የዘ፥ ኔኒ ኤ ባዝ ማርክꬍዳይ፥ Ꮉይቼ ጻማቃነ። አሱንꬅ ኡባ ኤጎ Ꮉንጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ዋሐንሳ ማህ፥ «ጾዚ እንግካይዘ አስ አኮ ባዝን ኤኮደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹ታኒ ክርስቶሳ ባያ፥ የዝን ኤፓ ቲኖ ኪትንትዳ› ጋይዳንስ ይን፥ ይን ኦምተ ታስ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ገሎደስ ጊግንትዳና ኤኮደስ ጊገዘስ። ኤክዘስ ላጉንꬅ ኤ ካለ ኤቂ ኤ ጋዛኖ ስእዘ ዎደ ጋማ ኡፋይታነ። ይኒ ግሾ፥ Ꮉና ታ ኡፋይስታ ፎልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ኤ ዳሞደስ ታ ኤሮደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","አፋፓ ይእዘ ኡባፓ ꬎቃ። ሳአፓ በንትደ ሳአ አስ፤ ኤ ሳአባዝ ኦህነ። ሳሎፓ ይእደ ኡባፓ አꬂ። ");
INSERT INTO oyde_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ኤ ፋ ብእደባዝን ስእደባዝ እዞ ማርክꬋነ፥ ዪኮን ኤ ማርካትꬅቶ ስእዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ኤ ማርካትꬅቶ ኤክዘ ኦደን ጾዘ ቱሮ ማቅዳኖ ትልዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ጾዚ ፋ ጌሽ አያና ኤስ ኩንꬅ እንግዘ ግሾ ጾዚ ኪትደ ጾዘ ቃላ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","አዳይ ፋ ናአያ ካꬊ ኡባባዝቶ ኤ ኩሽተ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ናአያ አማንዘስ መዽና ደኦ የነ። የዝን ናአያ አማኖሰላ ጾዘ ፍርዳ የነፕ አትን ኤ ደኦ ደንጎስ። ");
INSERT INTO oyde_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","የሱሳ ዋሐንሳፓ አꬂ ካልዙንꬃና ፋጎ ሺሺ ጻማቅዛኖ ፋርሳዉንꬅ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ማቅኮን የሱሳ ታማሩንꬅ ጻማቅዳፕ አትን የሱሳ ኦናን ጻማቅካያ። ");
INSERT INTO oyde_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","የሱሳ አሱንꬅ ኤ ባዝ ጋዛኖ ስእደ ዎደ ይሁዳፓ ደንዲ ማቂ ጋልላ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ጋልላ ቅትተራ ሳማረራ አꬎዳና ኤስ አታመባዝ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ይኒ ግሾ፥ ያይቆባ ፋ ናአይ ዮሰፋስ እንግደ ጋድቲ ካለ የዘ ስካረ ጋዘ ሳማራ ካታማ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ይና በስተ ያይቆባስ Ꮉꬅ ዶቺ የነ። የሱሳ Ꮉንግተራ ላቢ ይና Ꮉꬅ ዶችት ካለ በትዳ። የ ዎደ ሳእታ አዋራፓ እዝፑን ሳተ ጋር። ");
INSERT INTO oyde_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ፈቲ ሳማራ ካታማ ማችታ ይና ዶችትፓ Ꮉꬅ ክጾደስ ይእዳ። የሱሳ ይና ማችትጎ፥ «ታና Ꮉꬅ ኡሾያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ይና ዎድተ የሱሳ ታማሩንꬅ ካꬃ ዎንጎደስ ካታማ ቅተንየሻ። ");
INSERT INTO oyde_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ይና ማችታ ማህ፥ «ነ አይሁደ አስ ማቅተራ፥ ሳማራ ማቾ ማቅደ ታና ዋይዝ Ꮉꬅ ኡሾ ጋኤ?» ያጋይዳ። ይኖ እዛ ጋይዳና አይሁዱንꬅ ሳማሩንꬃራ የልንቶሰ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","የሱሳ ማህ፥ «ነ ጾዘ እሞትꬅን Ꮉꬅ ታና ኡሾ ጋዘ ኦደ የዛኮ ኤርዘባዝ ማቅዛኮ ኤዛ ነ ዎሶዳ፤ የዝን ኔስ ደኦ እንግዘ Ꮉꬅ እንጎድየሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ማችታ ማህ፥ «ላꬃዮ፥ ኔስ ዱቂዘ Ꮉለ ባያ፤ ዶችታን Ꮉኮ። ዬዝን፥ ደኦ እንግዘ Ꮉꬅ ነ አባፓ ኤኮደ? ");
INSERT INTO oyde_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ኑስ Ꮉና Ꮉꬅ ዶችቶ እንግደ ኑ አዳይ ያይቆባፓ ነ አꬎደ? ኤን፥ ኤ ናኡንꬅን ኤ Ꮉሩንꬂ Ꮉና Ꮉꬅ ዶችትፓ ኡዥዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","የሱሳ፥ «Ꮉና Ꮉꬅትፓ ኡዥዘ ኦደን ማህ ባርꬋዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","የዝን ታ እንጎደ Ꮉꬅቶ ኡዥዘ ኦደን መꬍናስ ባርꬋማ። ታ እንግዘ Ꮉꬅታ ኤ ግዳ መዽና ደኦ እንግዘ ጎግዘ Ꮉꬅ ኣፈ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ማችታ ማህ፥ «ላꬆ፥ ታኒ ባርꬋመ ጋራን Ꮉꬅ ዱቆደስ Ꮉና በስተ የአመ ፋና ታስ ይና Ꮉꬅቶ እንጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","የሱሳ ኢጎ፥ «Ꮉንግ ነ አዝንዛ ጼጊ ዮኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ማችታ ማህ፥ «ታስ አዝኒ ባያ» ያጋይዳ። የሱሳ ኢጎ፥ «ታስ አዝኒ ባያ ጋእ ቱሮ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ኔስ ቲኖ እችን አዝኑꬅ የነ። Ꮉተ ኔራ የዘ አꬃይ ኔስ አዝኒ ባያ። ነ Ꮉተ ቱሮ ኦህዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ማችታ ማህ፥ «ላꬆ፥ ነ ናበ ማቅዳኖ ታ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ኑ አዱንꬅ Ꮉይ ደርዘላ ጾዚ ጎይንዳ። የዝን ይን አይሁዱንꬅ አስ ጾዝ ጎይኖደስ ቤዝዘ በስታ የሩሳላመ የነ ጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","የሱሳ፥ «Ꮉና ማችተ ታና አማኖ፤ Ꮉይ ደርዘላ ዎይ የሩሳላመ አዳያ ይን ጎይናመ ዎደ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ይን ሳማሩንꬅ ኤርንቶሰስ ጎይናነ። የዝን ኑኒ አሽዘ አይሁደፓ የእዘ ግሾ ኑ ኤርዛያ ጎይናነ። ");
INSERT INTO oyde_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","የዝን አዳያ ቱርፓ ጎይንዙንꬅ አያናራን ቱሮትꬃራ ጎይንዘ ዎድታ ኡክዳ፤ Ꮉተን የልዳ። ይኬ፥ አዳይ ኮይዘ Ꮉኒ ጋር ኦገራ ጎይንዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ጾዘ አያና፤ ኤስ ጎይንዙንꬅ አያናራን ቱሮትꬃራ ጎይኖደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ማችታ ማህ፥ «ክርስቶሳ ጋዘ ትዥንትደ ዮኦዳኖ ታ ኤራነ። ኤ የእዘ ዎደ ኑስ ኡባ ባዝ ኦሆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","የሱሳ፥ «Ꮉይ ኔራ ኦህንትዘ ታኒ ኤዛ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ኡን ኦህንቶደራ፥ የሱሳ ታማሩንꬅ Ꮉንግደ በስትፓ ማቅዳ። የሱሳ ማችትራ ኦህንቶደራ ኡን ብእ ጋማ ቆፕዳ። የዝን ማችትጎ፥ «አኮ ኮየ?» ዎይ የሱሳጎ፥ «እዝራ አኮስ ኦህንተ?» ጋይደ ኦደን ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ይንፓ ማቂ፥ ማችታ ፋ Ꮉꬅ ኦቶ አሺ ሱባ ካታማ Ꮉንግ አሱንꬃጎ፥ ");
INSERT INTO oyde_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ታኒ ኦችዳኖ ኡባ ታስ ኦህደ አꬃ ቦኦደስ የꬎተ። ኤ ክርስቶሳ ማቃነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","አሱንꬅ ካታማፓ ኬዚ የሱሳጎ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ይና ይአደራ፥ ኤ ታማሩንꬅ የሱሳጎ፥ «ሞኦዮ» ጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","የዝን ኤ፥ «ታስ ይን ኤሮሰ ካꬃ ታ ሙእዘ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ይኒ ግሾ፥ ኤ ታማሩንꬅ ፋ ግዳ፥ «ኤስ ሙእዘ ባዝ አስ ክእካይዛራ አታማ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","የሱሳ ኡንታጎ፥ «ታ ካꬅታ ታና ኪተዘ ቆፍቶ ኦቾዳኖን ኤ ኦችቶ ፋዳዳኖ። ");
INSERT INTO oyde_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ይን፥ ‹ኦይዲ አግናፓ ሱባ ካꬃ ማጽንቶዳ› ጋነ ባ? የዝን ታኒ ይንትስ ኦህነ፤ ካꬅታ ካጽን ሺሸስ የልዳኖ ሎይꬂ ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ቡድዘን ማጽዘን ዎላ ኡፋይቶደ ጋር ማጽዛይ ዳሞዘ ኤካነ ማህ ካꬃ መዽና ደኦስ ኣፈ ሺሻነ። ");
INSERT INTO oyde_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ይኬ፥ ‹ፈተ ቡዳነ፤ Ꮉንካይ ማህ ማጻነ› ጋዘ ኦህታ ቱሮ። ");
INSERT INTO oyde_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ይን ላቢካይዛኖ ሺሾደ ጋር ታ ይንታና ኪትዳ። መሉንꬅ ኦቺ ላቢዳነ ገሊ ይን ኡን ላቢደ ኣፍቶ ኤክዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ማችታ፥ «ኤ፥ ታ ኦችደ ኡባባዝቶ ኦህዳ» ጋእ ማርክꬍደ ግሾ ይና ካታምተ የዘ ሳማራ አሱንꬃፓ ጋሙንꬅ የሱሳ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ሳማራ አሱንꬅን የሱሳጎ ይእ፥ ኡን ካለ ጋምኦደ ጋር የሱሳ ዎስን ኤ እዘ ላምእ ቃማ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ኤ ኦህደ ቃልት ግሾ ካሰንፓ ጋማ አሱንꬅ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ማህ ኡን ማችትጎ፥ «Ꮉተ ኑ አማንዳና ኑ ኦምተ ኤ ጋዛኖ ስእደ ግሾፕ አትን ነ ማርክꬍደ ግሾ ባያ። ማህን ኤ ቱሮ Ꮉና አላምቶ አሽዛ ማቅዛኖ ኑ ኤርዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ላምእ ቃማፓ ሱባ፥ የሱሳ ይንፓ ኬዚ ጋልላ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","የሱሳ ፋ ኦምተ፥ «ናበ ፋ ጋድተ ቦንችንቶስ» ያጋእ ቲንꬊ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","የሱሳ ጋልላ የልደ ዎደ ጋልላ አሱንꬅ ኤዛ ሞክዳ። አኮስ ጋይኮ፥ ፋስጋ ባአለ ቦንችዘ ዎደ ኡን የሩሳላመ የዘ ግሾ ኤ ኦችዳኖ ኡባ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","የሱሳ Ꮉꬅቶ ዎይነ ኡሽ ላምደ በስተ፥ ጋልላ የዘ ቃና ካታማ Ꮉንግዳ። ቅፍርናሆመ ካት ኬꬃ ኦችዘ ሹምዘስ ናእ Ꮉርግንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","የሱሳ ይሁዳፓ ጋልላ ዪዳኖ የ ሹምዘ ስእ ኤጎ ይእዳ። Ꮉይቆደስ የልደ ፋ ናአያ Ꮉንግ ፋꬆደ ጋር የሱሳ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","የሱሳ ሹምዘጎ፥ «ጾዚ ኦችዘ ጋማ ቆፍዘን ክሌ ባዝ ብእካይዛራ ይን ሙሎን አማኖስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ሹምዘን ማህ፥ «ላꬃዮ፥ ታ ናአይ Ꮉይቂካይዝን ታራ የꬎያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","የሱሳ፥ «ነ ካራ ቅቶ፤ ነ ናአይ ፋጾዳ» ያጋይዳ። የ ሹምዘ የሱሳ ኦህደ ቃላ ማቅዳኖ አማኒ ፋ ካራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ኤ ፋ ካራ Ꮉንጎደራ ኤዛ አሩንꬅ ኤጎ ይእተራ ኤዛር ኦገ የልንት፥ «ነ ናአይ ፋጽዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ኤ ፋ አሩንꬃና ፋ ናአይስ አኮ ሳተ ሎኤዛኮ ኦጭዳ። ኡን ማህ፥ «ኦማ ላፑን ሳተ ምችታ አሽዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ናአይ አዳይ የሱሳ ፋጎ፥ «ነ ናአይ ፋጾዳ» ጋይዳና ይና ሳተ ማቅዳኖ ቲርዳ። ይኒ ግሾ፥ ኤዝን ኤ ካራ አሱንꬅ ኡቡንꬃራ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ይና የሱሳ ይሁዳፓ ጋልላ ይእ ኦችደ ላምእንꬃ ክሌ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ይንፓ ማቂ፥ የሱሳ አይሁዱንꬅ ቦንችዘ ባለስ የሩሳላመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","የሩሳላመ ዱሮ ፉርꬅ ካለ እብራይስጠ ዶናራ ቤተሳይዳ ጋዘ ተቅንትደ ጌና የነ። የ ተቅንት የዘ Ꮉꬅቲ ካለ ካንግዘን ኬእዘን እችን ኦገ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ይነ Ꮉꬅታ ኤንእንትዛኖ ናግዘ ጋማ Ꮉርግንትዙንꬅ፥ ቆቁንꬅ፥ ዎቡንꬅን ጋላ ስልዱንꬅ ዎይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","አኮስ ጋይኮ፥ ፈቲ ፈቲ ቶሄ ላꬄ ኪታንቾ ጌንተ ዎꬊ Ꮉꬅቶ ኤንእዛነ። Ꮉꬅታ ኤንእዘ ዎደ ቲኒ ገልደ አꬄ ፋና አይክደ አኮ Ꮉርገፓ ፋጻነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ይና በስተ Ꮉስታም ኦስፉን በረ Ꮉርግንትደ ፈቲ አስ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","የሱሳ እዘ ዎይእደ አꬃ ብእ፥ ማህ ጋማ ዎደ Ꮉርግንትዳኖ ኤሪ አꬄጎ፥ «ፋጾደስ ኮያነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ꮉርጋንችዘ ማህ፥ «ላꬆ፥ Ꮉꬅታ ኤንእንትዘ ዎደ ታና Ꮉꬅተ ኦልዘ አስ ባያ። ታ ገሎደስ ይዮደር መሉንꬅ ታፓ ቲኒ ገላነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","የሱሳ ኤጎ፥ «ደንዲ ኤቆ፤ ነ አልግዛ ቶኪ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","አꬃይ ኢራ ፋጽዳ፤ ፋ አልግዛ ቶኪ ቅትዳ። ይና ሳምባታ ዎደ Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ይኒ ግሾ፥ አይሁዱንꬅ ፋጽደ አꬄጎ፥ «Ꮉይኖ ሳእታ ሳምባታ፤ ኔኒ ነ አልግዛ ቶክዛና ዎጋ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","የዝን አꬃይ፥ «ታና ፋꬄዘ፥ ‹ነ አልግዛ ቶኪ ቅቶ› ጋይዳ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ኡን ኤጎ፥ «ነና፥ ነ አልግዛ ቶኪ ቅቶ ጋይደ ኤ ኦደ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","የዝን የሱሳ ይና በስተ ጋማ አስ ግዳፓ ደሽ ጋይደ ግሾ አꬃይ ፋና ፋꬅደ ኦደ የዛኮ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","የሱሳ ሱባፓ የ አꬃ ጾዘ ኬꬃ ደንግ፥ «Ꮉይቼ፥ ነ ፋጽዳ፤ Ꮉንፓ አꬍዘ ኢታ ባዝ ነና የላመ ጋር ማህ ናጋራ ኦችፐ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ይንፓ ማቂ፥ አꬃይ Ꮉንግ ፋና ፋꬅደ የሱሳ ማቅዛኖ አይሁዱንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","የሱሳ ይኖ ሳምባታ ኦደ ኦችደ ግሾ አይሁዱንꬅ የሱሳ ባይꬄ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","የሱሳ ማህ፥ «ታ አዳይ ኡባ ዎደ ኦቻነ፤ ታንን ኦቾደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","የሱሳ ሳምባታ ቦንችካይዘ ግሾ ጻላላስ ማቅካይዝን ጾዛ ፋ አደ ጋእ ፋና ጾዛራ ዎልክዝደ ግሾ አይሁዱንꬅ ኤዛ ዎꬎደስ ቲኖንፓ ምንꬂ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","የሱሳ ማህ፥ «ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ናአይ ፋስ አኮን ኦቾደስ ዳንዳኦስ። ኤ ፋ አዳይ ኦቾደራ ብእዳኖ ጻላላ ኦቻነ። አዳይ ኦችዛኖ ናአይን ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","አዳይ ፋ ናአያ ካዽዘ ግሾ ኦችዘ ኦቻ ኡባ ፋ ናአያ ቤዛነ። ይን ጋማ ቆፖደ ጋር ኤ Ꮉንፓ አꬍዘ ኦቻ ፋ ናአያ ቤዞዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","አዳይ Ꮉይቂዱንꬃና Ꮉይቆፓ ደንꬂ ኡንትስ ደኦ እንግዛንጋራ ናአይን ፋ ኮየዙንꬅስ ደኦ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","አዳይ ናአይስ ፍርዶደ ጋር አደትꬅ ዎልቃ እንግዳፕ አትን ኤ ኦናን ፍርዶስ። ");
INSERT INTO oyde_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ይኖ ኤ ኦችዳና አስ ኡባ አዳያ ቦንችዛን ጋር ናአያን ቦንቾደ ፋና። ናአያ ቦንቾሰ ኦደን ናአያ ኪትደ አዳያን ቦንቾስ። ");
INSERT INTO oyde_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ታ ቃልቶ ስእዘስ ታና ኪተዛ አማንዘስ መዽና ደኦ የነ። ኤ Ꮉይቆፓ ደኦ ፊንግደ ግሾ ፍርድንቶስ። ");
INSERT INTO oyde_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ታ ይንትስ ቱሮ ቱሮ ጋነ፤ Ꮉይቂደ አሱንꬅ ጾዘ ናአይ ቃልቶ ስእዘ ዎደ የኦዳ፤ ይናን Ꮉተ። ኤ ቃልቶ ስእዘ ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","አዳይ ፋስ ደኦ የዛን ፋና ናአይስን ደኦ የሳደ ፋና እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ናአይ አስ ናአ ማቅደ ግሾ አዳይ ናአይስ ፍርዶደ ጋር አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«ቦዛ የዙንꬅ ኤ ቃልቶ ስእ ደንድዘ ዎደ የኦደ ግሾ Ꮉነ ጋማ ቆፕፐተ። ");
INSERT INTO oyde_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ሎኦ ኦችዱንꬅ ደኦ ደንድደስ ማህ ኢታ ኦችዱንꬅ ፍርዳ ኤኮደስ ቦዛፓ ደንዶዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«ታኒ ታ አደትꬅ ዎልቃራ አኮ ባዝን ኦቾደስ ዳንዳኦስ። ጾዘ ታስ ኦህዳን ጋር ፍርዳነ። ታኒ ታና ኪትደ ኮይዘ ባዝ ኦቻነፕ አትን ታ ኮይዘ ባዝ ኦቾሰ ግሾ ታ ፍርድታ ቱሮ። ");
INSERT INTO oyde_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«ታኒ ታ ባዝ ማርክꬍኮ ታ ማርካትꬅታ ቱሮ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ታ ባዝ ማርክꬍዘ መለ የነ፤ ኤ ታ ባዝ ማርክꬍዛና ቱሮ ማቅዛኖ ታ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«ይን ዋሐንሳጎ አስ ኪትን ኤ ቱርስ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ታ ይኖ ይንትስ ኦህዛና፥ ይን አቶደ ጋር ጋይዳፕ አትን አስ ማርካትꬅ ታስ ኮሽን ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ዋሐንሳ ጎጋ ጋር ኤጽዘ ፎኦ። ይን ኤራꬅ ዎደ ኤ ፎእተ ኡፋይቶደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«የዝን ታስ ዋሐንሳፓ አꬍዘ ማርካ የነ። ታ ኦቾደ ጋር ታ አዳይ ታስ እንግደ ኦችታ ታ ባዝ ማርክꬋነ፤ አዳይ ታና ኪተዛኖ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«ማህን ታና ኪትደ አደን ፋ ኦምተ ታ ባዝ ማርክꬋነ። ይን ኤ ቃልቶ ሙሎ ስእካያ ዎይ ኤ ብሽቶ ብእካያ። ");
INSERT INTO oyde_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ኤ ኪተዛኖ ይን አማኖሰ ግሾ ኤ ቃልታ ይን ዎዝንተ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«ጌሽ ማጻፉንꬃፓ መዽና ደኦ ደንጎደባዝ ይንትስ አዝን ኡን ቁርቻነ፤ ቃልታን ታ ባዝ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","የዝን ይን ደኦ ደንጎደስ ታጎ ዮኦደስ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«አሳፓ ታኒ ቦንቾ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","የዝን ታኒ ይን ዎዝንተ ጾዘ ሲቆ ባይዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ታኒ ታ አዳይ ሱንꬅተ ይእዳ፥ የዝን ታና ሞክካያ። Ꮉንካይ ፋ ሱንꬅተ የእዛ ሞካነ። ");
INSERT INTO oyde_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ይን ፈተ ፈተፓ ቦንቾ ኮይዙንꬅ፥ ፈቲ ጾዘፓ የእዘ ቦንቾ ኤኮደስ ኮዮሱንꬅ፥ ዋይዝ ታና አማኖደስ ዳንዳኦደ? ");
INSERT INTO oyde_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«ታኒ ታ አዳይ ቲኖ ይንታና ሞትዘባዝ ይንትስ አዝፐ። ይንታና ሞቶደ ይን ኡፋይት ካፍዘ ሙሴ። ");
INSERT INTO oyde_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ይን ሙሴ አማነዛኮ ኤ ታ ባዝ ጻፍደ ግሾ ታናን አማኖድየሻ። ");
INSERT INTO oyde_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","የዝኮን ይን ኤ ጻፍዳኖ አማናንጽኮ ታ ቃልቶ ዋይዝ አማኖደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ይንፓ ማቂ፥ የሱሳ ጽባርዮሳ ጋዘ ጋልላ አባፕ ሰኮ ጋጻ ፊንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ኤ Ꮉርጋንቹንꬃና ፋꬂ ክሌ ባዝ ኦችዳኖ ብእደ ግሾ ጋማ አሱንꬅ ኤዛ ካልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","የሱሳ ደረላ ኬዚ፥ የይጋ ፋ ታማሩንꬃራ ዎላ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","አይሁዱንꬅ ቦንችዘ ፋስጋ ባአለ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","የሱሳ ጋማ አሱንꬅ ፋጎ የእዛኖ ብእ ፍልጶሳጎ፥ «Ꮉንꬅ አሱንꬃና ኡባ ሙሳደስ ማቃደ ካꬃ አባፓ ዎንጎደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ኤ ይኖ ፍልጶሳ ፋታኖደስ ጋይዳፕ አትን ኤ ፋ ኦምተ አኮ ኦቾድየዛኮ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፍልጶሳ ማህ የሱሳጎ፥ «መለ አቶ የዝን፥ ኦማ ኦማ፥ ፈቲ ፈቲ ባርꬅ የልꬆደስ፥ ላምእ ጼት ድናረራ ቦራ ዎንግኮን ማቆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ማህ የሱሳ ታማሩንꬃፓ ፈተ፥ ስሞን ጴጥሮሳ እሸ እንድርያሰ፥ ");
INSERT INTO oyde_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«እችን በሸ ባንጋ ቦራን ላምእ ሞሎ አይክደ ፈቲ ናአ Ꮉነ የነ፥ የዝን Ꮉንꬅ አሱንꬅ ኡባስ ይና አኮ ማዶደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","የሱሳ ፋ ታማሩንꬃጎ፥ «አሱንꬃና በትꬆተ» ያጋይዳ። ይና በስተ ጋማ ቡጫ የነ፤ አሱንꬅ ኡባ በትዳ። ꬊራꬅ አሱንꬅ ፋይድታ እችን ሙኩል ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","የሱሳ ቦርዛ ኤኪ ጾዝ ጋላቲ ማቂ ፋ ታማሩንꬅስ እንግዳ። ኡንትን በትደ አሱንꬅስ የልꬅዳ። ሞልቶን ኤኪ ይኒ ፋና ዪዚ እንግን፥ አሱንꬅ ፋ ኮይዳን ጋር ሙይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ኡን ኡቡንꬅ ምዥዳንፓ ሱባ የሱሳ ፋ ታማሩንꬃጎ፥ «ፈትባዝን ኢታመ ጋር አትደ ጉፍቶ ሺሾተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ይኒ ግሾ፥ ኡን ኡባ ሺሽዳ። አሱንꬅ ሙእን አትደ ባንጋ ቦራ ጉፋ ሺሽን ታጶ ላምእ ሌማተ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","አሱንꬅ የሱሳ ኦችደ ክሌ ባዝ በኤዘ ዎደ «Ꮉይ ቱሮ Ꮉና አላምተ የኦዳ ጋእንትደ ናብዛ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","የሱሳ ኡን ኤዛ አይኪ ዎልቃራ ካት ማሆደስ Ꮉንዛኖ ኤሪ፥ ፋስ ደረላ ማህ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ሳእታ ኡጉርን የሱሳ ታማሩንꬅ አባጎ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ሳእታ ቃምደ ግሾን የሱሳ Ꮉጋ ኡንታጎ ይእካይዘ ግሾ ኤ ታማሩንꬅ ጎንግተ ገሊ አባ ፊንግ ቅፍርናሆመ ቅቶደስ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ዳማ ባቆ ባቂደ ግሾ አባ Ꮉꬅታ ኤንእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","እችን ዎይ እዝፑን ክሎ ምትረ ማቃደ ጋር ኡን አባላ Ꮉንግዳንፓ ሱባ የሱሳ አባላ የꬍተራ የእዛኖ ብእ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","የዝን ኤ፥ «ዣሽትፐተ፥ ታና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ኡን ኡፋይት ኤዛ ጎንግተ ገልꬅዳ፤ ኢራ ጎንግዘ ኡን Ꮉንግዘ አባ ጋጻ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ዎንትስት ዎደ አባፓ ሰኮ ጋጻ አትደ ጋማ አሱንꬅ ፈቲ ጎንገ ጻላላ የዛኖ ብእዳ። የሱሳ ፋ ታማሩንꬃራ ጎንግተ ገሊ፥ ኡንታራ Ꮉንጎሳኖን ኡን ፋ ፋስ Ꮉንግዳኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","የዝን ጽባራዶሳፓ መለ ጎንጉንꬅ የሱሳ ጾዝ ጋላትን፥ አሱንꬅ ቦራ ሙይደ በስቶ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","አሱንꬅ የሱሳ ዎይ ኤ ታማሩንꬅ እዘ ባይዛኖ ብእ፥ የሱሳ ኮዮደስ ጎንግተ ገሊ ቅፍርናሆመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","አሱንꬅ የሱሳ አባፓ ሰኮ ፍንꬃ ደንግደ ዎደ «አስታማርዛዮ፥ Ꮉነ አይደ ነ ዪዶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","የሱሳ ማህ፥ «ታኒ ይንትስ ቱሮ ቱሮ ጋነ፤ ይን ታና ኮይዛና ቦራ ሙእ ምዥደ ግሾ ፋትን ክሌ ባዝ ብእደ ግሾ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ꬋብዘ ካꬃስ ኦችፐተ፥ የዝን መዽና ደኦ የዘ ካꬃ እንግዘ አስ ናአይስ ኦቾተ። ኤዛን ጾዘ አዳይ አታሚ ትልዝዳ።» ");
INSERT INTO oyde_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ዬዝን ኡን፥ «ኑኒ ጾዘ ኦቻ ኦቾደስ አኮ ኦቾደ?» ያጋእ የሱሳ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","የሱሳ ማህ፥ «ይን ኦቾደ ጋር ጾዘ ኮይዘ ኦችታ Ꮉኖ፦ ኤ ኪትዳያ አማኖደ ፋና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ኡን ማህ፥ «ኑኒ ብእ፥ ነና አማኖደ ጋር አኮ ክሌ ባዝ ነ ቤሳደ? ነ አኮ ኦቾደ? ");
INSERT INTO oyde_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ጌሽ ማጻፍተ፥ ‹ኡን ማአደ ጋር ቦራ ሳሎፓ እንግዳ› ጋእንት ጻፍንትዳንጋራ ኑ አዱንꬅ አኮ ባይዘ ጋናሳ ማና ሙይዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","የሱሳ፥ «ታ ይንትስ ቱሮ ኦህነ፤ ይንትስ ሳሎፓ ቱሪ ቦራ እንግደ ታ አዳይፕ አትን ሙሴ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ይኬ፥ ጾዚ እንግዘ ቦራ ሳሎፓ ዎꬍደ አላመስ ደኦ እንግዛያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ኡን ማህ፥ «ላꬆ፥ ኑስ የ ቦርዛ ኡባ ዎደ እንጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","የሱሳ፥ «ታኒ ደኦ ቦራ፤ ታጎ የእዘ ኦደን ሙሎ ናይꬎስ። ማህ ታና አማንዘ አꬄን ባርꬎስ። ");
INSERT INTO oyde_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","የዝን ታ ይንትስ ኦህዳ፤ ይን ታና ብእዳ፥ የዝን አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ታ አዳይ ታስ እንግደ ኡቡንꬅ ታጎ ዮኦዳ፤ ማህ ታጎ የእዛ ኦናን ባለ ዳኮስ። ");
INSERT INTO oyde_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ታኒ ታ ኮይዘ ባዝ ኦቾደስ ማቅካይዝን ታና ኪትደ ኮይዘ ባዝ ኦቾደስ ሳሎፓ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ታና ኪትደ ኮይዛና Ꮉኖ፦ ታኒ ኤ ታስ እንግደ ኡቡንꬃና ዉርሱꬅ ዎደ Ꮉይቆፓ ደንꬆደ ጋራፕ አትን ፈተን ꬋቦደ ጋር ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ይኬ፥ ታ አዳይ ኮይዛና ይኖ፦ ናአያ ብእ አማንዘ ኡባ መዽና ደኦ ኤኮዳ፤ ታኒ የንꬃና ኡባ ዉርሱꬅ ዎደ መዽና ደኦስ Ꮉይቆፓ ደንꬆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","የሱሳ፥ «ታኒ ሳሎፓ ዎꬍደ ቦራ» ጋይደ ግሾ አይሁዱንꬅ ኤላ ዙዝንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ኡን፥ «Ꮉይኒ ኑ ኤ አዳያን ኤ እንቶ ኤርዘ ዮሰፋ ናአ የሱሳ ባነ? ዬዝን፥ ኤ ዋይዝ፥ ‹ታ ሳሎፓ ዎꬍዳ› ጋዉደስ ዳንዳኤ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","የሱሳ ማህ፥ «ፈተ ፈተራ ዙዝንግዛኖ አሾተ። ");
INSERT INTO oyde_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ታና ኪትደ ታ አዳይ ታጎ ክእዘ አሳፓ አትን ታጎ ዮኦደስ ዳንዳእዘ ኦደን ባያ። ታ ዉርሱꬅ ዎደ ኤዛ መዽና ደኦስ Ꮉይቆፓ ደንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ናቡንꬅ፥ ‹አስ ኡባ ጾዛፓ ታማርዱንꬃና ማቃዳ› ጋእ ጻፍዳ። አዳያ ስእዘን ኤፓ ታማርደ ኦደን ታጎ የእነ። ");
INSERT INTO oyde_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ጾዘ ካለፓ ይእዳይፕ አትን አዳያ በኤዘ ኦደን ባያ፤ ኤ ጻላላ አዳያ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ታና አማንዘ መዽና ደኦ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ታኒ ደኦ ቦራ። ");
INSERT INTO oyde_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ይን አዱንꬅ አኮ ባይዘ ጋናስ ሳአ ማና ሙእዳ፥ የዝን Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ሳሎፓ ይእደ ቦራ Ꮉያ፤ Ꮉይ ቦርዛ ሙእደ ኦደን Ꮉይቆስ። ");
INSERT INTO oyde_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ሳሎፓ ይእደ ደኦ ቦርዘ ታና። ኦደን Ꮉይ ቦርዛ ሙእኮ መꬍናስ የሳዳ። ማህ Ꮉና አላምታ ደኦ የሳደ ጋር ታኒ ይንትስ እንጎደ ቦርዘ ታ አሽቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","አይሁዱንꬅ፥ «Ꮉይ አꬃይ ፋ አሽቶ ኑ ማአደ ጋር ኑስ ዋይዝ እንጎደስ ዳንዳኤ?» ያጋእ ፋ ግዳ ዎላ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ይኒ ግሾ፥ የሱሳ ኡንታጎ፥ «ታኒ ይንትስ ቱሮ ቱሮ ጋነ፤ አስ ናአይ አሽቶ፥ ይን ማአንጽኮ፥ ማህ ኤ ሱꬅቶ ይን ኡዣንጽኮ፥ ይንትስ ደኦ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ታ አሽቶ ሙእዘን ታ ሱꬅቶ ኡዥዘ አꬄስ መዽና ደኦ የነ። ታኒ ዉርሱꬅ ዎደ ኤዛ Ꮉይቆፓ ደንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ታ አሽታ ቱሪ ካꬃ፤ ታ ሱꬅታን ቱሪ ኡሽ። ");
INSERT INTO oyde_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ታ አሽቶ ሙእዘን ታ ሱꬅቶ ኡዥዘ አꬄ ታ ግዳ የነ፤ ታንን ኤ ግዳ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ደኦ አዳይ ታና ኪትን፥ ታ ኤ ባጋራ ደኦ የዛንጋራ፥ ታና ሙእዘ አꬄን ታ ባጋራ ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ሳሎፓ ዎꬍደ ቦርዘ Ꮉያ፦ ይን አዱንꬅ ሙእ Ꮉይቂደ ማና ፋና ባያ፤ Ꮉይ ቦርዛ ሙእዘ አꬄ መዽና የሳዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","የሱሳ ቅፍርናሆመ ካታማ አይሁደ ዎሳ ኬꬃ Ꮉኖ ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","የሱሳ ታማሩንꬃፓ ጋማ ባግታ ይኖ ስኤዘ ዎደ «Ꮉና ገሎሰ ትምርተ፤ ኦደስ ገለ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","የሱሳ ፋ ታማሩንꬅ ይንስ ዙዝንግዳኖ ኤሪ፥ «Ꮉና ይንታና ባልꬃነ? ");
INSERT INTO oyde_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ዬዝን፥ አስ ናአይ ቲኖ ፋ የዘ በሳ ኡደ ከሳደራ ይን ብእዛኮ ዋያደ? ");
INSERT INTO oyde_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ጌሽ አያና ደኦ እንጋነ፤ አስ ዎልቃ አኮን ማዶስ። ታ ይንትስ ኦህዘ ቃልታ ደኦ እንግዘ ጌሽ አያናፓ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","የዝን ይን ግዳ አማኖሱንꬅ የነ» ያጋይዳ። አማኖሱንꬅ ኦድ የዛኮ የሱሳ ቲኖፓን ኤራነ። ማህ ፋና አꬂ እንጎደ ኦና የዛኮ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ማህን የሱሳ፥ «አዳይ ዮኦ ጋይካይዘ ኦደን ታጎ ዮኦደስ ዳንዳኦስ ጋእ ታ ኦህዛና ይኒ ግሾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ይኒ ባጋራ፥ የሱሳ ካልዙንꬃፓ ጋሙንꬅ ኤዛ አሺ ሱብ ማቅዳ፤ ማህን ኤራ Ꮉንግካያ። ");
INSERT INTO oyde_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","የሱሳ ታጶ ላምእ ፋ ታማሩንꬃና፥ «ይንትን አሺ ቅቶደስ ኮያነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ስሞን ጴጥሮሳ ማህ፥ «ላꬆ፥ ኑኒ ኦደጎ ቅቶደ? ኔስ መዽና ደኦ ቃላ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ነ ጾዘ ጌሽ ማቅዳኖ ኑኒ አማናነን ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","የሱሳ ኡንታጎ፥ «ታ ይንታና ታጶ ላምኡንꬃና ዶርካነ? የዝን ይንታፓ ፈተ ጻላሄ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","የሱሳ ይኖ ጋይዳና ስሞና ናአይ አስቆሮቱ ይሁዳ ግሾ። ይሁዳ የሱሳ አꬂ እንጎደስ የዘ ታጶ ላምእ ታማሩንꬃፓ ፈታ። ");
INSERT INTO oyde_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ይንፓ ማቂ፥ አይሁዱንꬅ የሱሳ ዎꬎደስ ኮይደ ግሾ ኤ ይሁዳ አሺ ጋልላራ ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","አይሁዱንꬅ ቦንችዘ ዳሰ ባአለ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ይኒ ግሾ፥ የሱሳ እሹንꬅ፥ «ነ ታማሩንꬅ ነ ኦችዘ ክለ ባዝቶ በአደ ጋር Ꮉንፋ ደንዲ ይሁዳ ሳአ ቅቶ። ");
INSERT INTO oyde_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ፋስ ቆንጪ ኤርንቶደስ ኮይዘ አስ ኦደን ፋ ኦችቶ አቾስ። ነ Ꮉንሳና ኦቺ ነባዝ አላመስ ቆንጭዞ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ኤ እሹንꬅ ይኖ ጋይዳና አማንካይዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","የሱሳ ኡንታጎ፥ «ታስ ዎደ Ꮉጋ የልካያ፥ የዝን ይንትስ ኡባ ዎደ ዎታነ። ");
INSERT INTO oyde_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","አላመ ይንታና እጾደስ ዳንዳኦስ፥ የዝን ታኒ አላመ ኦችታ ኢታ ማቅዛኖ ማርክꬍዘ ግሾ ታና እጻነ። ");
INSERT INTO oyde_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ይን ባአልቶ ቅቶተ፤ ታስ ዎደ የልካይዘ ግሾ ታኒ ባአልቶ Ꮉንጎስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ኤ ይኖ ጋእ ጋልላ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ኤ እሹንꬅ ባአለ ቦንቾደስ ቅትዳንፓ ማቂ የሱሳ ኦደን ኤርካይዝን በንትካይዛራ ይና በስተ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","አይሁዱንꬅ ባአለ ቦንችዘ በስተ፥ «ኤ አባ የነ?» ያጋእ ኤዛ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","አሱንꬅ ዙዝንጊ ኤ ባዝ ኦህንታነ። ባጉንꬅ፥ «ኤ ሎኦ አስ» ጋዘ ዎደ መሉንꬅ ማህ፥ «አደ፥ ኤ አስ ባልꬃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","የዝን አይሁደ Ꮉላቁንꬅስ ዣሽትደ ግሾ ኦደን ኤ ባዝ ቆንጨ ኦህንቶስ። ");
INSERT INTO oyde_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ባአለ ቦንቺ ግዳ የሎደራ የሱሳ ጾዘ ኬꬃ Ꮉንግ ታማርሰ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","አይሁዱንꬅ፥ «Ꮉይ አꬄ ትምርተ ታማርካይዛራ ማጻፈ ዋይዝ ኤርዶ?» ጋእ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","የሱሳ ማህ፥ «ታ ታማርስዘ ትምርትታ ታና ኪተዘ ጾዘ ካለፓ የእዘ ትምርተፕ አትን ታ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ጾዘ ቆፋ ኦቾደስ ኮይዘ ኦደን Ꮉና ትምርትታ ጾዘ ካለፓ የእዛኮን ዎይ ታኒ ታፓ ኦህዛኮ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ፋ ባዝ ኦህዘ ኦደን ፋ ቦንቾ ኮያነ። የዝን ፋና ኪተዘ ቦንቾ ኮይዘ ኦደን ኤ ቱሪ አስ፤ ኤ ግዳ ዎርዶ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙሴ ይንትስ ህገ እንግዳ፥ የዝን ይንታፓ ኦደን ህገ ናግካያ። ዬዝን አኮስ ታና ዎꬎደስ ኮየ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","አሱንꬅ ማህ፥ «ኔራ ጻላሄ የነ፤ ነና ዎꬎደስ ኦደ ኮይዘ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","የሱሳ፥ «ታ ፈቲ ክሌ ባዝ ኦችን ይን ኡቡንꬅ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ይን፥ ይን ናኡንꬃና ጋራዞደ ጋር ሙሴስ ዎጋ እንግዳ። የዝን ይን ማይዙንꬃፓ አይኪ የዘ ዎጋፕ አትን ሙሴ ባያ። ይኒ ግሾ፥ ይን ሳምባታ ዎደ ꬊራꬅ ናኡንꬃና ጋራዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ሙሴ ህገ ሻርንታመ ፋና ይን ሳምባታ ዎደ ጋራዘባዝ ማቅኮ፥ ታ ፈቲ አꬄ ኩሙꬅ ጋልቶ ሳምባታር ፋꬅደ ግሾ ታራ አኮስ ካጭንተ? ");
INSERT INTO oyde_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ቱሪ ፍርዳ ፍርዶተፕ አትን አስ ስኖ ብእ ፍርድፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","የሩሳላመ አሱንꬃፓ ፈተ ፈተ፥ «ኡን ዎꬎደስ ኮይዘ አꬄ Ꮉያ ባነ? ");
INSERT INTO oyde_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ይኬ፥ ኤ ቆንጨ ኦህነ፤ ኡን ኤዛ አኮን ጋኦስ። ኤ ክርስቶሳ ማቅዳኖ አይሁደ Ꮉላቁንꬅ ቱሮ ኤረሶነ? ");
INSERT INTO oyde_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ክርስቶሳ የእዘ ዎደ ኤ አባፓ የዛኮ ኦደን ኤሮስ፥ የዝን Ꮉይ አꬄ አናፓ የኤዛኮ ኑ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","የሱሳ ጾዘ ኬꬃ ታማርስተራ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ቱሮ ይን ታ ኦና የዛኮን ታ አባፕ የኤዛኮ ኤራነ? ታኒ ታ ዎልቃራ ይእካያ፥ የዝን ታና ኪተዘ ቱሪ አደ፤ ይን ኤዛ ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","የዝን ታኒ ኤ ኪትን ኤ ካለፓ ይእደ ግሾ ኤዛ ኤራነ» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ይኒ ግሾ፥ ኡን ኤዛ አይኮደስ ኮይዳ። የዝን ኤስ ዎደ Ꮉጋ የልካይዘ ግሾ ኦደን ኤላ ኩሸ ጋድካያ። ");
INSERT INTO oyde_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","የዝን ጋማ አሱንꬅ የሱሳ አማኒ፥ «ክርስቶሳ የእዘ ዎደ Ꮉይ አꬄ ኦችዘ ክለ ባዛፓ አꬂ ኦቾዳነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ፋርሳዉኑꬅ ጋማ አሱንꬅ የሱሳ ባዝ ካልካሽዛኖ ስእዳ። ካህኑንꬅ Ꮉላቁንꬅን ፋርሳዉኑꬅ ኤዛ አይꬂ አጭሳደስ ጾዘ ኬꬃ ናግዙንꬃና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","የሱሳ፥ «ታ ይንታራ ኤራꬅ ዎደ ጋምኦዳ፤ ይንፓ ሱባ ታና ኪተዘጎ ቅቶዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ይን ታና ኮዮዳ፥ የዝን ደንጋማ። ታ የዘ በስቶ ይን ዮኦደስ ዳንዳኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","አይሁዱንꬅ ፈተ ፈተራ፥ «Ꮉይ ኑ ደንጋመ በሳ አባ ቅቶደስ ይየ? ግርኬ ካታማ በቲ የዘ አይሁዱንꬃና Ꮉንግ ታማርሶደስ ቅቶዳነ? ");
INSERT INTO oyde_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹ይን ታና ኮዮዳ፥ የዝን ደንጋማ› ማህ፥ ‹ታኒ የዘ በሳ ይን ዮኦደስ ዳንዳአማ› ጋዛና አክ ጋእንተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ባአለ ቦንችዘ Ꮉልኤ ቃምተ የሱሳ ደንዲ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ባርꬍደ ኦደን ታጎ ይእ ኡዦ። ");
INSERT INTO oyde_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ታና አማንዘ ኦደን ጌሽ ማጻፍታ ጋይዳንጋራ ደኦ እንግዘ Ꮉꬅ ኣፈ ኤ ግዳፓ ጎጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ኤ ይኖ ጋይዳና ኤዛ አማነዙንꬅ ኤኮደስ የዘ ጌሽ አያናባዝ ኦህዳ። የሱሳ Ꮉጋ ቦንችንትካይዘ ግሾ የ ዎደ ጌሽ አያና እንግንትካያ። ");
INSERT INTO oyde_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","የንꬅ አሱንꬃፓ ጋሙንꬅ ኤ ጋዛኖ ስእ፥ «Ꮉይ ቱሮ ዮኦዳ ጋእንትደ ናብዛያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","መሉንꬅ ማህ፥ «Ꮉይ ክርስቶሳ» ያጋይዳ። ማህን መሉንꬅ፥ «ክርስቶሳ ጋልላፓ የእነነ? ");
INSERT INTO oyde_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ጌሽ ማጻፍተ፥ ‹ክርስቶሳ ዳዉተ ኮቻፓ ዳዉተ የዝደ ቤተለመ ካታማፓ የኦዳ› ጋይካነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ይኒ ግሾ፥ የሱሳ ባጋራ አሱንꬅ ዎል ግዳ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","የንꬅ አሱንꬃፓ ፈተ ፈተ ኤዛ አይኮደስ ኮይዳ፥ የዝን ኦደን ኤላ ኩሸ ጋድካያ። ");
INSERT INTO oyde_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ጾዘ ኬꬂ ናግዙንꬅ ካህኑንꬅ Ꮉላቁንꬃጎን ፋርሳዉኑꬃጎ ሱብ ማቂ ይእን ኡን፥ «አኮስ ኤዛ ከአንጽዶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ጾዘ ኬꬂ ናግዙንꬅ ኡንታጎ፥ «Ꮉይ አꬄ ኦህዛን ጋራ ኦደን ኦሆስ» ጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ፋርሳዉኑንꬅ ማህ፥ «ኤ ይንታናን ባልꬅዳ? ");
INSERT INTO oyde_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","አይሁደ Ꮉላቁንꬃፓ ዎይ ፋርሳዉንꬃፓ ኤዛ አማንደ አስ የነ? ");
INSERT INTO oyde_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ሙሴ ህገ ኤሮሰ Ꮉንꬅ አሱንꬅ ቱኔዙንꬃና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ፋርሳዉንꬃፓ ፈተ ቃማ የሱሳጎ Ꮉንግደ ንቆድሞሳ ኡንታጎ፥ ");
INSERT INTO oyde_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«ፈቲ አስ ጋዛኖ ስእካይዛራ ዎይ ኤ አኮ ኦቼዛኮ ኤርካይዛራ ቲኖ ኤላ ፍርድዛና ኑ ህግተ የነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ኡን ማህ፥ «ኔንን ጋልላ አስ? ጋልላ ሳአፓ ናበ ከዛማኖ ጌሽ ማጻፈፓ ቁርች ኤሮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ይንፓ ሱባ ፈተ ፈተ ፋ ካራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ፈተ ፈተ አሺ ፋ ካራ ፋ ካራ ቅትዳ፥ የዝን የሱሳ ሻማሄ ደረ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ማህ ዎንትስት ዎደ ጎዳ ጾዘ ኬꬃ ይእዳ። ጋማ አሱንꬅ ኤጎ ይእን በቲ ኡንታና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ህገ አስታማሩንꬅን ፋርሳዉኑꬅ ኦላሎደራ አይክደ ፈቲ ማችቶ ኤጎ ክእዳ። ኡን አስ ኡባ ቲኖ እዞ ኤስ፥ ");
INSERT INTO oyde_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","«አስታማርዛዮ፥ Ꮉና ማችታ ኦላሎደራ ኑ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ሙሴ ህገ Ꮉኒ ጋርዘ ማችቶ ሹቻራ ꬎጊ ዎꬎደ ጋር ኪታነ። ዬዝን፥ ነ እባዝ ዋገ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ኡን ይኖ ጋይዳና የሱሳ ፋታኒ ኤዛ ሞቶደባዝ ደንጎደስ። የዝን የሱሳ ዙጊ ፋ ግልእዘራ ሳአላ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ኡን ኤዛ ማህ ማህ ኦጪ አሻንጽን፥ ኡደ ꬎቅ ጋእ፥ «ይን ግዳ ናጋራ ኦችካይዘ አስ ቲኒ እዞ ሹቻራ ꬎጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ማህን ዙጊ ሳአላ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ኡን ይኖ ስእደ ዎደ ኡን ቆፍታ ኡንእን ጭሙንꬃፓ አይኪ ፈተ ፈተ ከዝተራ Ꮉልእዳ። የሱሳ ጻላላ ይና በስተ ኤቅደ ማችትራ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ኤ ኡደ ꬎቅ ጋእ ማችትፓ መለ አስ ብእካይዘ ዎደ፥ «ማችተ፥ ሞትዙንꬅ አባ ቅትዶ? ኔላ ፍርድዙንꬃፓ ኦደን ባ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ማችታ፥ «ላꬆ፥ ኦደን ባያ» ያጋይዳ። የሱሳ ማህ፥ «ታንን ኔላ ፍርዶስ። ቅቶ፤ ማህ ናጋራ ኦችፈ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ማንን የሱሳ አሱንꬃጎ፥ «ታኒ አላመስ ፎኦ። ታና ካልዘ ኦደን ደኦ እንግዘ ፎኦ ኤኮዳፕ አትን ꬉማ Ꮉንቶስ» ያጋእ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፋርሳዉንꬅ፥ «ነ ነባዝ ማርክꬋነ፥ የዝን ነ ማርካትꬅታ ቱሮ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","የሱሳ ማህ፥ «ታኒ ታ ባዝ ማርክꬍዛኮን ታ ማርካትꬅታ ቱሮ። አኮስ ጋይኮ፥ ታኒ አባፓ የኤዛኮ ማህ አባ ቅትዛኮ ኤራነ፥ የዝን ይን ታ አባፓ የእዛኮን ማህ አባ ቅትዛኮ ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ይን አስ ቆፋ ጋር ፍርዳነ፤ ታኒ ፈቲ አሳላን ፍርዶስ። ");
INSERT INTO oyde_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ታኒ ፍርድዘባዝ ማቅኮን ታ ፍርድታ ቱሮ። አኮስ ጋይኮ፥ ታና ኪተዘ ታ አዳይ ታራ የነፕ አትን ታኒ ታ ጻላላ የዞስ። ");
INSERT INTO oyde_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ላምእ አስ ማርካትꬅ ቱሮ ማቅዛና ይን ህግተ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ታኒ ታ ባዝ ታ ኦምተ ማርክꬋነ፤ ማህ ታና ኪተዘ ታ አደን ታ ባዝ ማርክꬋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ኡን፥ «ነ አዳይ አባ የነ?» ያጋይዳ። የሱሳ ማህ፥ «ይን ታና ዎይ ታ አዳያ ኤሮስ። ታና ኤርዘባዝ ማቅዛኮ፥ ይን ታ አዳያን ኤሮዳ የሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","የሱሳ ጾዘ ኬꬃ ሙጻተ ብራ ኦልዘ ሳጥነ የዘ በስተ ይኖ ታማርስዳ። ኤ ቃምታ Ꮉጋ የልካይዘ ግሾ ኦደን ኤዛ አይክካያ። ");
INSERT INTO oyde_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ማህን የሱሳ ኡንታጎ፥ «ታ ቅቶዳ፤ ይን ታና ኮዮዳ፥ የዝን ይን ይን ናጋርትራ Ꮉይቆዳ። ታ ቅትዘ በስቶ ቅቶደስ ይን ዳንዳኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","አይሁደ Ꮉላቁንꬅ፥ «ኤ፥ ‹ታ ቅትዘ በስቶ ይን ዮኦደስ ዳንዳኦስ› ያጋይዳ። ኤ ፋና ፋስ ዎꬎዳ የሳነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","የሱሳ ማህ፥ «ይን ኦሞፓ፤ ታ አፋፓ። ይን Ꮉና አላምትፓ፥ ታ Ꮉና አላምትፓ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ይን ይን ናጋርትራ Ꮉይቆዳ ጋእ ታ ይንትስ ኦህዳና ይንስ። ታኒ ታና ማቅዛኖ ይን አማናንጽኮ ይን ይን ናጋርትራ Ꮉይቆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ኡን፥ «ነ ኦደ?» ያጋእ ኦጭዳ። የሱሳ ማህ፥ «ታኒ፥ ቲኖፓ ይንትስ ኦህደ ኤዚ ታና። ");
INSERT INTO oyde_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ታኒ ይን ባዝ ኦህ ፍርድዘ ጋማ ባዝ የነ። የዝን ታና ኪተዘ ቱሮ፤ ማህ ታኒ ኤፓ ስኤዛኖ ጻላላ አላመስ ኦህነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","የሱሳ ፋ አደባዝ ኦህዛኖ ኡን ቲሪካያ። ");
INSERT INTO oyde_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ይኒ ግሾ፥ የሱሳ ኡንታጎ፥ «ይን አስ ናአያ ኡደ ꬎቅ ዪዘ ዎደ ታኒ ታና ማቅዛኖ ይን ኤሮዳ። ማህን ታኒ ታ አደትꬅ ዎልቃራ አኮን ኦቾሳኖን ታ አዳይ ታና ታማርስዳኖ ኦህዛኖ ይን ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ታና ኪተዘ ታራ የነ። ታ ኡባ ዎደ ኤዛ ኡፋይስዘ ባዝ ኦችዘ ግሾ ኤ ታና ታ ጻላላ አሽካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","የሱሳ ይኖ ኦሆደራ ስኤዘ ጋማ አሱንꬅ ኤዛ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","የሱሳን ፋና አማንደ አይሁዱንꬃጎ፥ «ይን ታ ቃልተ የዝኮ ቱሪ ታ ታማሩንꬃና። ");
INSERT INTO oyde_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ይን ቱሮ ኤሮዳ፤ ቱርታን ይንታና አሮትꬃፓ ከሶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ኡን ማህ፥ «ኑ አብራሃማ ኮች፤ ኑ ኦደስን አርꬍካያ። ነ ዋይዝ፥ ‹ይን አሮትꬃፓ ኬሳዳ› ጋኤ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","የሱሳ ማህ፥ «ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ናጋራ ኦችዘ ኦደን ናጋራስ አሮ። ");
INSERT INTO oyde_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","አሮ መꬍናስ ካራ አሳራ የዞስ፥ የዝን ናአ መꬍናስ ካራ አሳራ የዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ናአይ ይንታና አሮትꬃፓ ኬስኮ ይን አሮትꬃፓ ቱሮ ኬሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ይን አብራሃማ ኮች ማቅዛኖ ታ ኤራነ። የዝን ታ ቃልታ ይን ግዳ ባይዘ ግሾ ታና ዎꬎደስ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ታኒ ታ አዳይ ታና ቤዝዳኖ ኦህነ፥ የዝን ይንትን ይን አደፓ በኤዛኖ ኦቻነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ኡን ማህ፥ «ኑ አዳይ አብራሃማ» ያጋይዳ። የሱሳ ኡንታጎ፥ «ይን አብራሃማ ናኡንꬃና ማቅዛኮ ኤ ኦችዳኖ ኦቾድየሻ። ");
INSERT INTO oyde_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","የዝን ጾዛፓ ስኤዘ ቱርቶ ኦህደ ታና ይን ዎꬎደስ ኮያነ። አብራሃማ ይኒ ጋራ ዪዝካያ። ");
INSERT INTO oyde_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ይን፥ ይን አዳይ ኦችዳኖ ኦቻነ» ያጋይዳ። ኡን ማህ፥ «ኑኒ ኦላለ ናአ ባያ ቱሪ ጾዘ ናኡንꬃና፤ ኑስ ፈቲ አዳይ ጾዘ ጻላላ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","የሱሳ ኡንታጎ፥ «ጾዚ ቱሪ ይንትስ አደ ማቅዛኮ ይን ታና ካꬎድየሻ፤ አኮስ ጋይኮ፥ ታኒ ጾዘ ካለፓ ይእዳ። ታና ኤ ኪታነፕ አትን ታኒ ታ አደትꬅ ዎልቃራ ይእካያ። ");
INSERT INTO oyde_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ታ ኦህዛኖ ይን ስኦሳና ቲሮሶ? ታ ቃልቶ ይን ስአንጽደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ይን፥ ይን አዳይ ጻላሄ ናአ። ማህን ይን፥ ይን አዳይ አሙꬍዘባዝ ኦቾደስ ኮያነ። ኤ ቲኖፓ አይኪ ሸምፖ ዎꬍዛያ። ቱሪ ኤ ግዳ ባይዘ ግሾ ኤ ቱሮ እጻነ። ዎርዶ ኤስ የዘ ባዝ ማቅደ ግሾን ኤ ዎርዶስ አደ ማቅደ ግሾ ዎርዶ ኦህተራ ፋፓ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ታ ቱሮ ኦህነ፥ የዝን ይን ታና አማኖስ። ");
INSERT INTO oyde_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ይንታፓ፥ ‹ነ ናጋራ ኦቾደራ ታ ብእዳ› ጋዉደስ ዳንዳእዘ ኦደ? ታ ቱርቶ ኦህዘ ባዝ ማቅኮ ታና አኮስ አማኖስተ? ");
INSERT INTO oyde_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ጾዘ አስ ማቅደ ጾዚ ጋዛኖ ስእነ። ይን ጾዘ አስ ማቅካይዘ ግሾ ጾዚ ጋዛኖ ስኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","አይሁዱንꬅ ማህ፥ « ‹ነ ሳማራ አስ፤ ኔላ ቱና አያና የነ› ጋእተራ ቱሮ ኑ ባነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","የሱሳን ኡንታጎ «ታላ ቱና አያና ባያ። ታኒ ታ አዳያ ቦንቻነ፥ የዝን ይን ታና ለቃነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ታኒ ታ ቦንቾ ኮዮስ፤ ታ ቦንችንቶደ ጋር ኮይዘን ታስ ፍርድዘ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ታ ቃልቶ ናግዘ ኦደን Ꮉይቆስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","አይሁዱንꬅ ማህ፥ «ኔላ ቱና አያና የዛኖ ኑኒ Ꮉተ ኤርዳ። አብራሃማ Ꮉይቂዳ፤ ናቡንꬅን Ꮉይቂዳ። የዝን ነ፥ ‹ታ ቃልቶ ናግዘ ኦደን Ꮉይቆስ› ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ነ Ꮉይቂደ ኑ አዳይ አብራሃመፓ አꬋነ? ናቡንꬅን Ꮉይቂዳ። ነ ነና ኦና ጋእ ቆፐ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","የሱሳ፥ «ታኒ ታና ቦንችኮ ታ ቦንችታ Ꮉሪ። ይን፥ ‹ኑ ጾዛ› ጋዘ ታ አዳይ ኤ ታና ቦንቻነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ይን ኤዛ ኤራንጽኮን ታ ኤዛ ኤራነ። ታ ኤዛ ኤሮስ ጋይኮ ይን ፋና ታንን ዎርድꬋነ። የዝን ታ ኤዛ ኤራነ፤ ማህ ኤ ቃልቶን ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ይን አዳይ አብራሃማ ታ የእዘ ቃምቶ ብእ ኡፋይቶደስ አሙꬋነ፤ ብእን ኡፋይትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","አይሁዱንꬅ ማህ፥ «መለ አቶ የዝን፥ ኔስ እችንታም በረ ኩምካይዘ ዋይዝ አብራሃማ ብእዳ ጋኤ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","የሱሳን ኡንታጎ፥ «ታ ይንትስ ቱሮ ቱሮ ጋነ፤ አብራሃማ የልንቶዳንፓ ቲኖ ታኒ ታና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ይኒ ግሾ፥ ኡን የሱሳ ꬎጎደስ ሹች ኤክዳ። የዝን የሱሳ ኡንታፓ ገንጊ ጾዘ ኬꬃፓ ኬዚ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","የሱሳ Ꮉንግተራ የልንትዳንፓ ኣፈ ቆቀ ማቂ የዘ ፈቲ አꬃ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ኤ ታማሩንꬅ፥ «አስታማርዛዮ፥ Ꮉይ አꬄ ኣፈ ቆቀ ማቂ የልንቶደ ጋር ናጋራ ኦችደ ኦደ? ኤዛነ ዎይ ኤዛ የልዱንꬅ ኦችዶ?» ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","የሱሳ፥ «ጾዘ ኦችታ ኤላ ቆንጮደ ጋራፕ አትን ኤዚ ዎይ ኤዛ የልዱንꬅ ናጋራ ኦችደ ግሾ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ሳአ አዋራ የዝን ታና ኪትደ ኦችቶ ኦቾደስ ቤዛነ። ኦደን ኦቾደስ ዳንዳኦሰ ቃማ ዮኦዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ታ አላምተ የዝተራ አላምትስ ፎኦ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","የሱሳ ይኖ ጋእ ሳአላ ጩትዳ። ፋ ጩችትራ ኤራꬅ ሳአ ላክꬂ ይና ሎቅትራ ኣፈ ቆቀ አꬄ ኣፍቶ ትዥዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","የይዝ፥ «Ꮉንግ ሳልሆመ (ሳልሆመ ጋእንትዛና ኪትንትዳያ ጋኤ) ጋዘ ተቅንትደ Ꮉꬅተ ነ ኣፍቶ ማቶ» ያጋይዳ። ይኒ ግሾ፥ አꬄ Ꮉንግ ፋ ኣፍቶ ማቲ ብእተራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ዶꬁንꬅን አꬄ ቲኖ ዎሶደራ ብእደ አሱንꬅ፥ «Ꮉይ በቲ ዎስዘ አꬃ ባነ?» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ፈቲ ፈቲ አሱንꬅ፥ «Ꮉይ ኤዛ» ያጋይዳ። መሉንꬅ ማህ፥ «አደ፥ Ꮉይኒ ኤዛ አዛነፕ አትን ኤዛ ባያ» ያጋይዳ። የዝን ኤዝን፥ «ዬ፥ ታና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ኡን ኤጎ፥ «ዬዝን ነ ኣፍታ ዋይዝ ብእዶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ኤ ማህ፥ «የሱሳ ጋዘ አꬄ ሎቃ ላክꬂ ታ ኣፍቶ ትዢ፥ ‹ሳልሆመ Ꮉንግ ነ ኣፍቶ ማቶ› ያጋእን፥ ታ Ꮉንግ ማቲ ብእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ኡን ኤጎ፥ «ኤ አባ የነ?» ያጋእ ኦጭዳ። አꬃይ፥ «ታ ኤሮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ኡን ኣፈ ቆቀ የዛራ፥ ብእደ አꬃ ፋርሳዉንꬃጎ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","የሱሳ ሎቃ ላክꬂ አꬄ ኣፍቶ ፋꬅደ ቃምታ ሳምባታ። ");
INSERT INTO oyde_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ይኒ ግሾ፥ አꬄ ዋይዝ በኤዛኮ ፋርሳዉንꬅ ኤዛ ማህ ኦጭዳ። አꬃይ ኡንታጎ፥ «ኤ ታ ኣፍተ ሎቃ ትዥዳ፥ ማቲ Ꮉተ በእነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ፋርሳዉንꬃፓ ፈተ ፈተ፥ «Ꮉኖ ኦችደ አꬄ ሳምባታ ህገ ናጎሰ ግሾ ጾዘ ካለፓ ይእካያ» ያጋይዳ። የዝን መሉንꬅ፥ «ናጋራንቾ አስ Ꮉኒ ጋር ክሌ ባዝ ዋይዝ ኦቾደስ ዳንዳኤ?» ጋእ ዎል ግዳ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ይኒ ግሾ፥ ፋርሳዉንꬅ አꬄጎ፥ «ኤ ነ ኣፍቶ ቡግደ ግሾ ነ ኤባዝቶ ዋገ?» ያጋይዳ። አꬃይ፥ «ኤ ናበ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","አይሁደ Ꮉላቁንꬅ፥ ኤ እንቶን አዳያን ጼጊ ኦጮደ ዎንꬅስ፥ አꬄ ቲኖ ኣፈ ቆቀ ማቅዛኖን Ꮉተ ኤ በእዛኖ አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ኡን ኤ እንትጎን ኤ አደጎ፥ «ይን ‹ኣፈ ቆቀ ማቂ የልንትዳ› ጋዘ ይን ናአይ Ꮉያ? ዬዝን፥ Ꮉተ ዋይዝ ብእዶ?» ጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ኤዛ የልዱንꬅ፥ «Ꮉይ ኑ ናአ ማቅዳኖን ኣፈ ቆቀ ማቂ ኤ የልንትዳኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","የዝን Ꮉተ ኤ ዋይዝ በኤዛኮ ማህ ኤ ኣፍቶ ኦ ፋꬄዛኮ ኑ ኤሮስ። ኤዛ ኦጮተ። ኤ ፋና ሻክደ አስ ማቅደ ግሾ ፋ ባዝ ኦሆደስ ዳንዳአነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ኤዛ የልዱንꬅ ይኖ ጋይዳና አይሁዱንꬅስ ዣሽትዘ ግሾ። አኮስ ጋይኮ፥ አይሁዱንꬅ፥ የሱሳ ኤ ክርስቶሳ ያጋእ ማርክꬍዘ አስ የዝኮ የ አꬃ አይሁደ ዎሳ ኬꬃፓ ባይኦደስ ቲኒ ዞረ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ኤዛ የልዱንꬅ፥ «ኤ ፋና ሻክደ አስ፤ ኤዛ ኦጮተ» ያጋይዳና ይንስ። ");
INSERT INTO oyde_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ይኒ ግሾ፥ ቆቀ ማቂ የልንትደ አꬃ ኡን ላምእንꬃ ጼጊ፥ «ጾዛ ቦንቾ፤ Ꮉይ አꬃይ ናጋራንቾ ማቅዳኖ ኑ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","አꬃይ ማህ፥ «ኤ ናጋራንቾ ማቅዛኖ ታ ኤሮስ። ታ ቆቀ ማቅዳኖን Ꮉተ ብእዳኖ ይኖ ፈቲ ባዝ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ኡን ማህ፥ «ኤ ኔስ አኮ ባዝ ኦችዶ? ኤ ነ ኣፍቶ ዋይዝ ፋꬅዶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ኤ ኡንታጎ፥ «ታ ይንትስ ቲኖ ኦህዳ፥ የዝን ይን ስኦደስ ኮይካያ። አኮስ ማህ ስኦደስ ኮየ? ይንትን ኤ ታማረ ማቃደስ ኮያነነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ኡን ኤዛ ጫዥተር ያጋይዳ፥ «ነ የ አꬄ ታማረ፤ ኑኒ ሙሴ ታማረ። ");
INSERT INTO oyde_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ጾዚ ሙሴራ ኦህንትዳኖ ኑ ኤራነ፥ የዝን Ꮉይ አꬄ ኤ አናፓ የኤዛኮን ኑ ኤሮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","አꬃይ ኡንታጎ፥ «ኤ አናፓ የኤዛኮ ይን ኤሮሳና ጋማ ቆፍዘ ባዝ፥ ማቅኮን ኤ ታ ኣፍቶ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ጾዘስ ዣሽትዛን ኤ ኮይዘ ባዝ ኦችዘ አꬃ ጾዚ ስእነፕ አትን ናጋራንቹንꬃና ስኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ሳሎን ሳአ መꬍንትዳንፓ ኣፈ ቆቀ ማቂ የልንትደ አስ ኣፈ ፋꬅደ ኦደን ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ꮉይ አꬄ ጾዛፓ ማቅካይዛኮ ፈትባዝን ኦቾደስ ዳንዳኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ኡን ማህ፥ «ነ ኩሙꬅ መꬍንተ ናጋራር የልንት ድጭዘ ኑና ታማርሶደስ ኮያነ?» ያጋይዳ። ኤዛ አይሁደ ዎሳ ኬꬃፓ ባይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","የሱሳ ኡን አꬃ ባለ ከስዳኖ ስእደ ዎደ ኤዛ ደንግ፥ «አስ ናአያ አማናነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","አꬃይ የሱሳጎ፥ «ላꬆ፥ ታ ኤዛ አማኖደ ጋር ኤ ኦደ? ታስ ኦሆያ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","የሱሳ አꬄጎ፥ «ነ ኤዛ ብእዳ፤ Ꮉይ ኔራ ኦህንትዘ ኤዛ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","አꬃይ ማህ፥ «ላꬆ፥ ታ አማናነ» ያጋእ የሱሳስ ጎይንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","የሱሳ፥ «ቆቁንꬅ በአደ ጋራን በእዙንꬅ ቆቆደ ጋር ታኒ ፍርዶደስ Ꮉና አላምተ ይእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ኤዛራ የዘ ኤራꬅ ፋርሳዉንꬅ ይኖ ስእ፥ «ኑ ቆቀነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","የሱሳ፥ «ይን ቆቀ ማቅዛኮ ይንትስ ናጋራ ማቆስ የሻ። የዝን Ꮉተ ይን በእነ ጋዘ ግሾ ይን፥ ይን ናጋርተ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","የሱሳ፥ «ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ዱሮ ካለስ ፉርꬃራ ማቅካይዝን መለ በሳራ ገልዘ ኦደን ካይዞን ፋኖን። ");
INSERT INTO oyde_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","የዝን ፉርꬃራ ገልዘ ኤዚ ዱሩንꬃና የንግዛያ። ");
INSERT INTO oyde_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ፉርꬅቶ ናግዘ ኤስ ፉርꬅቶ ቡጋነ፤ ዱሩንꬅን ኤ ቃልቶ ስእነ። ኤ ፋ ዱሩንꬃና ኡን ሱንꬅትራ ሱንꬅትራ ጼጋነ፤ ኡንታና ካልꬅ ባለ ከሳነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ኤ ፋ ዱሩንꬃና ኡባ ባለ ከስዳንፓ ማቂ ኡንታፕ ቲኖር የꬋነ። ኡን ኤ ቃልቶ ኤርዘ ግሾ ኤዛ ካላነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","መለ ቃላ ኡን ኤሮሰ ግሾ ኤፓ Ꮉካነፕ አትን ኤዛ ካሎስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","የሱሳ ኡንትስ Ꮉና አዝዝቶ ኦህዳ፥ የዝን ኤ አኮ ጋኤዛኮን ኡን ቲሪካያ። ");
INSERT INTO oyde_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ማህ የሱሳ ኡንታጎ፥ «ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ታኒ ዱሩንꬅስ ፉርꬅ። ");
INSERT INTO oyde_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ታፓ ቲኖ የኤዘ ኡባ ካይዞን ፋኖፕ፥ አትን ዱሩንꬅ ኡንታና ስእካያ። ");
INSERT INTO oyde_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ፉርꬅዘ ታና፤ ታ ባጋራ ገልዘ ኦደን አቶዳ። ኤ ታ ባጋራ ገሎዳን ኬሳዳ፤ ሎኦ የንግንትዘ በሲ ደማዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ካይዞ ካይስቶደስ፥ ሹኮደስን ꬋብሶደስ የእነፕ አትን መለባዝስ የኦስ። ታ ኡንትስ ደኦ የሳደ ጋራን ጋንጎደ ጋር ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«ታ ሎኦ ዉደ አደ፤ ሎኦ ዉደ አዳይ ፋ ዱሩንꬅ ግሾ ፋ ሸምፕቶ አꬂ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ክራ የንግዘ አꬄ ዱሩንꬅስ አደ ማቅካይዘ ግሾ ሱዹመ የእዘ ዎደ ብእ ዱሩንꬃና አሺ ዎጻነ። ይኒ ግሾ፥ ሱዹመ ዱሩንꬃና ቦንቃነ ዱሩንꬅን ላንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ክራ የንግዛይ ሚሸስ የንግዘ ግሾን ዱሩንꬅባዝ ኤስ ስንቶሰ ግሾ ዱሩንꬃና አሺ ዎጻነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«ታ ሎኦ ዉደ አደ። ታ አዳይ ታና ኤርዛን ፋና ታንን ታ አዳያ ኤራነ። ይኒ ፋና፥ ታኒ ታ ዱሩንꬃና ኤራነ፤ ታ ዱሩንꬅን ታና ኤራነ። ታኒ ታ ዱሩንꬅ ግሾ ታ ሸምፕቶ አꬂ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ꮉና ካልተ ባይዘ መለ ዱሩንꬅ ታስ የነ። ታ ኡንታና ኮኦደስ ቤዛነ። ኡን ታ ቃልቶ ስኦዳ፤ ኡን ፈቲ ዉደ ማቃዳ፤ የንግዛይን ፈቶ። ");
INSERT INTO oyde_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«ታኒ ታ ሸምፕቶ አꬂ እንግ ማህ ኤክዘ ግሾ ታ አዳይ ታና ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ታ ቆፋር ታ ሸምፕቶ አꬂ እንጋነፕ አትን ታፓ ኦደን ኤኮስ። ታ ታ ሸምፕቶ አꬂ እንጎደስን ማህ ኤኮደስ አደትꬅ ዎልቃ ታስ የነ። ታ ኦቾደ ጋር ታ አዳይ ታና ኪተዛና Ꮉኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ይና ኤ ጋይደ ቃልት ግሾ አይሁዱንꬅ ግዳ ማህ ዱማትꬅ መꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ኡንታፓ ጋሙንꬅ፥ «ኤ ግዳ ቱና አያና የነ! ኤ ዣሽታነ! ኤ ጋዛኖ አኮስ ስኤ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","መሉንꬅ ማህ፥ «ጻላሄ አይክደ አስ ኦህንትዘ ፋና ባያ። ጻላሄ ቆቀ ኣፈ ቡጎደስ ዳንዳአነነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","የሩሳላመ ጾዘ ኬꬅቶ ጌሽደ ቃምቶ ቦንችዘ ባአለ የልዳ፤ ሳእታ ባርጎ። ");
INSERT INTO oyde_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","የሱሳ ጾዘ ኬꬃ ሶሎሞነ ፉርꬃራ ጎደን Ꮉንካ Ꮉንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","አይሁዱንꬅ የሱሳ ካለ ኤቂ፥ «ነ ኑና አይደ የሎደስ ሶኤራ ጋምእሳደ? ነ ክርስቶሳ ማቅኮ አነ ኑስ ጌሽ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","የሱሳ ማህ ኡንታጎ፥ «ታ ይንትስ ኦህዳ፤ የዝን ታና አማናንጽዳ። ታኒ ታ አዳይ ሱንꬅተ ኦችዘ ኦችታ ታ ባዝ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","የዝን ታ ይንትስ ኦህዳን ጋራ ይን ታ ዱሮ ማቅካይዘ ግሾ አማናንጽዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ታ ዱሩንꬅ ታ ቃልቶ ስእነ። ታ ኡንታና ኤራነ፤ ኡንትን ታና ካላነ። ");
INSERT INTO oyde_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ታ ኡንትስ መዽና ደኦ እንጋነ፤ ኡን ሙሎን ꬋቦስ። ኦደን ታ ኩሽትፓ ኡንታና ቦንቆስ። ");
INSERT INTO oyde_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ኡንታና ታስ እንግደ ታ አዳይ ኡባፓ አꬋነ ኦደን ታ አዳይ ኩሽትፓ ኡንታና ቦንቂ ኤኮደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ታንን ታ አዳይን ፈቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","አይሁዱንꬅ የሱሳ ꬎጎደስ ማህ ሹች ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","የሱሳ ኡንታጎ፥ «ታኒ ኦቾደ ጋር ታ አዳይ ታስ እንግደ ጋማ ሎኦ ኦችቶ ይንታና ኦቺ ቤዝዳ። የንሳፓ አየ ግሾ ታና ሹቻራ ꬎጎደስ ኮየ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","አይሁዱንꬅ ማህ፥ «ኑ ነና ነ ሎኦ ኦችት ግሾ ሹቻር ꬎጎደስ ኮዮስ። የዝን ነ ጾዛ ጫዥዘ ግሾን አስ ማቅተራ ነ ነና ጾዝ ማህዘ ግሾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","የሱሳ ማህ፥ «ይን ህግተ፥ ‹ታ፥ ይን ጾዙንꬃና ጋይዳ› ጋእ ጻፍንትካ? ");
INSERT INTO oyde_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ጌሽ ማጻፈ መꬍናስ ላምንቶስ። ጾዚ ፋ ቃልቶ እንግደ አሱንꬃና፥ ‹ጾዙንꬃና› ጋእ ጼግኮ፥ ");
INSERT INTO oyde_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","አዳይ ዶሪ አንጂ Ꮉና አላምተ ኪትደ ታና ‹ጾዘ ናአ› ጋይደ ግሾ ዋይዝ ‹ጾዝ ጫዣነ› ያጋኤ? ");
INSERT INTO oyde_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ታኒ ታ አዳይ ኦችዛኖ ኦቻንጽኮ ታና አማንፐተ። ");
INSERT INTO oyde_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","የዝን ታኒ ኦችዛ ማቅኮ ይን ታና አማናንጽኮን፥ ታ አዳይ ታ ግዳ የዛኖን ታንን ታ አዳይ ግዳ የዛኖ ይን ኤሮደ ጋር ቆፖደ ጋር ታ ኦችቶ አማኖተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ይኬ ማህ ኡን ኤዛ አይኮደስ ኮይዳ፥ የዝን ኤ ኡን ኩሽትፓ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ዋሐንሳ ቲኖ ጻማቅዘ በስተ፥ ዮርዳኖሳ ቦርካፓ ሰኮ ፍንꬃ የሱሳ ፊንግ የይጋ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ጋማ አሱንꬅ የሱሳጎ ይእ፥ «ዋሐንሳ መለ አቶ የዝን ፈቲ ክለ ባዝን ኦችካያ፥ የዝን ኤ Ꮉይ አꬄባዝ ኦህዳና ኡባ ቱሮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","እዘ ጋማ አሱንꬅ የሱሳ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ብታንያ ጉታ አላዛረ ጋዘ ፈቲ አስ Ꮉርግንትዳ። ብታንያ ማይራምራን እ ምሽታ ማርታ የዘ ሳአ። ");
INSERT INTO oyde_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ማይራማ ላꬄ ቶህትላ ሽቶ ትዢ ፋ ኦምትራ ኤ ቶህቶ ኡጭዳኖ። Ꮉርግንትዘ እ እሸ አላዛረ። ");
INSERT INTO oyde_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ይኒ ግሾ፥ ምሹንꬅ፥ «ላꬆ፥ ነ ካዽዘ ኑ እሸ Ꮉርግንትዳ» ጋእ የሱሳጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","የሱሳ ይኖ ስእደ ዎደ «Ꮉና Ꮉርግታ፥ ጾዘ ናአይ ቦንችቶደ ጋራን ጾዘ ቦንቾስፕ አትን Ꮉይቆስ የልꬅዘ Ꮉርገ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","የሱሳ ማርታን፥ እ ምሽቶ ማይራሞን አላዛረን ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","የዝን አላዛረ Ꮉርግንትዳኖ የሱሳ ስእ ፋ የዘ በስተ ላምእ ቃማ አቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ይንፓ ማቂ፥ የሱሳ ፋ ታማሩንꬃጎ፥ «ማቂ ይሁዳ ሳአ የꬎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ኤ ታማሩንꬅ ማህ፥ «አስታማርዛዮ፥ ኤራꬅ ዎደፓ ቲኖ አይሁዱንꬅ ነና ሹቻር ꬎጊ ዎꬎደስ ኮይዳ፤ Ꮉተን እዘ Ꮉንጎዳነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","የሱሳ፥ «ፈቲ አዋ ታጶ ላምእ ሳተ ባነ? አዋራራ የꬍዘ አስ Ꮉና አላመ ፎእቶ በእዘ ግሾ ꬉብንቶስ። ");
INSERT INTO oyde_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","የዝን ቃማ የꬍዘ ኦደን ፎኦ ባይዘ ግሾ ꬉብንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","የሱሳ ይኖ ጋይዳንፓ ማቂ ኡንታጎ፥ «ኑ ካዽዘ አላዛረ ገንትዳ፥ የዝን ኤዛ ደንꬆደስ ታ Ꮉማዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ኤ ታማሩንꬅ ማህ፥ «ላꬆ፥ ኤ ገንተዘባዝ ማቅኮ ደንዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","የሱሳ አላዛረ Ꮉይቂዳኖ ኦህዳ፥ የዝን ኡንትስ ጨር ገንቶ አዝዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ይኒ ግሾ፥ የሱሳ ጌሽ ኡንታጎ፥ «አላዛረ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ይን አማኖደ ፋና ታ ይና በስተ ባይዛና ይን ግሾ ኡፋይሳነ። አነ የꬎተ፤ ኤጎ Ꮉማዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ይንፓ ማቂ፥ ዲዲሞሳ ጋእንትዘ ቶማሳ ፋ ላገ ታማሩንꬃጎ፥ «ኤራ Ꮉይቆደስ ኑስን የꬎተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","የሱሳ የልዘ ዎደ አላዛረ ሞግንትን ኦይዲ ቃማ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ብታነይ የሩሳላመፓ Ꮉይꬕ ክሎ ምትረ ጋር Ꮉካነ። ");
INSERT INTO oyde_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ጋማ አይሁዱንꬅ ማርታን ማይራሞን ኡን እሸ Ꮉይቂዳንስ ምንꬅꬆደስ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርታ የሱሳ ይእዳኖ ስእ ኤዛ ሞኮደስ ከዝዳ፥ የዝን ማይራማ ኬꬃ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርታ የሱሳጎ፥ «ላꬆ፥ ነ Ꮉነ የዘ ባዝ ማቅዛኮ ታ እሸ Ꮉይቃምየሻ። ");
INSERT INTO oyde_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","የዝን Ꮉተ ማቅኮን ነ ዎስዘ ባዝ ጾዚ ኔስ እንጎዳኖ ታ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","የሱሳ፥ «ነ እሸ Ꮉይቆፓ ደንዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርታ ኤጎ፥ «ዉርሱꬅ ቃማ ኤ Ꮉይቆፓ ደንዶዳኖ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","የሱሳ ኢጎ፥ «ታኒ ደንዶን ደኦን፤ ታና አማንዘ ኦደን Ꮉይቅኮን ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ማህ ደኦ ማቅደን ታና አማንዘ ኦደን መꬍናስ Ꮉይቆስ። ይኖ ነ አማናነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ማርታ ማህ፥ «ላꬆ፥ ዬ ታ አማናነ! ነ ጾዘ ናአ፥ አላመ ዮኦደስ የዘ ክርስቶሳ ማቅዳኖ ታ አማናነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ማርታ ይኖ ጋይዳንፓ ማቂ፥ Ꮉንግ ፋ ምሽቶ አችንት ጼጊ፥ «አስታማርዘ ይእ ነና ጼጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ማይራማ ይኖ ስእደ ዎደ ኤልሲ ደንዲ ኤቂ የሱሳጎ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","የ ዎደ የሱሳ ማርታራ የልንትደ በስተ የነ፤ Ꮉጋ ካራ ጋንጨ የልካያ። ");
INSERT INTO oyde_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ማይራሞ ምንꬅꬅተር ኢራ ኬꬃ የዘ አይሁዱንꬅ፥ እዛ ደንዲ ኤቂ ኤልሲ ባለ ኬዝዳኖ ብእ፥ ቦዛ Ꮉንግ ዬኮደስ ይእዛ አዝን እዞ ካሊ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ማይራማ የሱሳ የዘ በስቶ Ꮉንግ ኤዛ ብእደ ዎደ ኤ ቶህትላ ጎልእ፥ «ላꬆ፥ ነ Ꮉነ የዘ ባዝ ማቀዛኮ ታ እሸ Ꮉይቃም የሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","የሱሳ ማይራምራን ኢራ የዘ፥ አይሁዱንꬅ ዬክዛኖ ብእ፥ ፋ ዎዝንተ ጋማ ይቅስንቲ፥ ");
INSERT INTO oyde_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«አባ ሞግዶ?» ጋእ ኦጭን፥ «ላꬆ፥ ይእ ቦኦ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","የሱሳ አፉጽዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ይኒ ግሾ፥ አይሁዱንꬅ፥ «ኤ አላዛረ አኮ ጋር ካዛኮ ቦኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","የዝን ኡንታፓ ፈተ ፈተ፥ «Ꮉይ ቆቅዘ ኣፍቶ ቡግደ Ꮉይ አꬄ Ꮉይቃመ ጋር ይሳደስ ዳንዳኦሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ማህ የሱሳ ይቅስንቲ፥ አላዛረ ሞግንትደ ቦዝትጎ Ꮉንግዳ። ቦዝታን ሹቻራ ጎርድንትደ ዎምኦ። ");
INSERT INTO oyde_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","የሱሳ፥ «ሹችቶ ደንꬆተ» ያጋይዳ። ማርታ፥ «ላꬆ፥ ኤ Ꮉይቂዳንፓ Ꮉይኖ ኦይዲ ቃማ ማቅደ ግሾ Ꮉተ ዜቆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","የሱሳ ማርታጎ፥ «ነ አማንዘባዝ ማቅኮ ጾዘ ቦንቾ ቦኦዳኖ ታ ኔስ ኦህካ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ኡን ቦዝትላ የዘ ሹችቶ ደንꬅን የሱሳ ሳሎ ኡደ ብእ፥ «አዳዮ፥ ታና ነ ስኤዘ ግሾ ነና ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ነ ኡባ ዎደ ታና ስእዛኖ ታ ኤራነ። የዝን Ꮉነ ኤቅደ አሱንꬅ ነ ታና ኪተዛኖ አማኖደ ጋር ታ ኡን ግሾ Ꮉኖ ጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","የሱሳ ይኖ ጋይዳንፓ ማቂ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «አላዛረ፥ ኡደ ከዞ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ꮉይቂደ አꬄ ዚꬍንትዳንራ ኩሽታን ቶህቶ ሻሎራ አጭንቲ የዝን ኤ ኣፍታ ጎዝንትዳንራ ቦዝትፓ ከዝዳ። የሱሳ ኡንታና፥ «ብሎተ! የꬎ ጋኦ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ይኒ ግሾ፥ ማይራምጎ ይእደ አይሁዱንꬃፓ ጋሙንꬅ የሱሳ ኦችዳኖ ብእ ኤዛ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","የዝን ኡንታፓ ፈተ ፈተ ፋርሳዉንꬃጎ Ꮉንግ የሱሳ ኦችዳኖ ኡንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ይንፓ ማቂ፥ ካህኑንꬅ Ꮉላቁንꬅን ፋርሳዉንꬅ ሻንጎስ ሺሺ፥ «Ꮉይ አꬄ ጋማ ክሌ ባዝ ኦችዘ ግሾ ኑ አኮ ኦቾ? ");
INSERT INTO oyde_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ኑ ኤዛ ጨር አሽኮ አስ ኡባ ኤዛ አማኖዳ። ማህ ሮመ ሳአ አሱንꬅ ይእ ኑ ጾዘ ኬꬅቶን ኑ ባጉንꬃና ꬋብሶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ኡንታፓ ፈተ ቃያፋ ጋዘ፥ ይና በርተ ካህኑንꬅ Ꮉላቃ ማቅደ፥ «ይን አኮን ኤሮስ! ");
INSERT INTO oyde_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ዎርዣ ኡባ ꬋቦዳንፓ ፈቲ አስ ዎርዥት ግሾ Ꮉይቆዳና ሎኦ ማቅዛኖ ኤሮሳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ኤ ይኖ ፋፓ ጋይካያ። የዝን ይና በርተ ካህኑንꬅ Ꮉላቃ ማቅደ ግሾ የሱሳ አይሁደ አሱንꬅ ግሾ Ꮉይቆደስ ቤዛኖ ትንቢተ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ማህ የሱሳ አይሁደ አሱንꬅ ጻላላስ ማቅካይዝን ላልንቲ የዘ ጾዘ አስ ኡባ ፈትላ ሺሾደስን ፈቲ አስ ማሆደስ Ꮉይቆዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ይና ቃምትፓ አይኪ ኡን ኤዛ ዎꬎደስ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ይኒ ግሾ፥ የሱሳ አይሁዱንꬅ ግዳ ቆንጨ በሳ Ꮉንትካያ። የዝን አኮ ባይዘ ሳአ ካለ የዘ ኤፍሬመ ጉታ ቅትዳ። ፋ ታማሩንꬃራ ይና በስተ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","አይሁዱንꬅ ቦንችዘ ፋስጋ ቃማ ኡክዳ። ማህ ጋማ አሱንꬅ ፋና ጌሾደስ ፋስጋ ቦንችዘ ቃማ የሎዳንፓ ቲኖ ይና ሳእትፓ የሩሳላመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ኡን ጾዘ ኬꬃ ኤቂ የሱሳ የእቶ ናግዘ ግሾ «አኮ ቆፐ? የሱሳ ባአለ ቦንቾደስ የአም የሳነ?» ያጋእ ፈተ ፈታ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ካህነ Ꮉላቁንꬅን ፋርሳዉንꬅ የሱሳ አይኮደስ፥ ኤ የዘ በስቶ ኤርዘ ኦደን ፋስ ማሎደ ፋና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ፋስጋ ቦንችዘ እዝፑን ቃማፓ ቲኖ፥ የሱሳ Ꮉይቆፓ ደንꬅደ አላዛረ የዘ ጉታ፥ ብታንያ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ይና በስተ ኡን ኤስ ካዎ ጊግዝዳ። አላዛረ የሱሳራ ዎላ ሌማተላ በቴዝን ማርታ ኡንትስ ኪትንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ማይራማ ናርዶሳ ጋዘ ጋማ አልኦ ጌሽ ሽቶ ክእ የሱሳ ቶህትላ ጉስዳ። ፋ ኦምትራ ኤ ቶህቶ ኡጭዳ፤ ኬꬅተ ኡባ ሽቶ ሳዎራ ቶንኩ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","የዝን የሱሳ ታማሩንꬃፓ ፈተ፥ የሱሳ አꬂ እንጎደስ የዘ፥ አስቆሮቱ ይሁዳ፥ ");
INSERT INTO oyde_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ꮉና ሽትታ Ꮉይꬕ ጼት ድናረስ ባይዝንቲ፥ ሚሽታ ዳሁንꬅስ እንግንቶሳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ኤ ካይዞ ማቅደ ግሾ ይኖ ጋይዳፕ አትን ዳሃስ ይቅስንቲ ጋይካያ። ኤ ብራ አይክዛ ማቅደ ግሾ ኡባ ዎደ ኢፓ ፋስ ኤካነ። ");
INSERT INTO oyde_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","የሱሳ፥ «እዛ ፋስ የዘ ባዝ ታ ሞግንትዘ ቃማስ ምንጅደ ግሾ እዞ አሺ አሾተ። ");
INSERT INTO oyde_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ዳሁንꬅ ኡባ ዎደ ይንታራ የሳዳ፥ የዝን ታ ኡባ ዎደ ይንታራ የዞስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","የ ዎደ ጋማ አሱንꬅ የሱሳ ብታንያ የዛኖ ስእ እዘ ይእዳ። ኡን የሱሳ ጻላላ ማቅካይዝን ኤ Ꮉይቆፓ ደንꬅደ አላዛረን በአደስ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ይኒ ግሾ፥ ካህኑንꬅ Ꮉላቁንꬅ አላዛረን ጉጂ ዎꬎደስ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","አኮስ ጋይኮ፥ አላዛረ ባጋራ ጋማ አይሁዱንꬅ ኡንታና እጺ የሱሳ አማንዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ዎንትስት ዎደ ፋስጋ ቦንችዘ በስተ የእዘ ጋማ አሱንꬅ የሱሳ የሩሳላመ ይእዛኖ ስእ፥ ");
INSERT INTO oyde_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ቂለ Ꮉየ ኤኪ ኤዛ ሞኮደስ ከዝዳ። ኡን ፋ ቃልቶ ꬎቅ ዪዚ፥ «ሆሳና! ላꬄ ሱንꬅተ የእዘ! እስራኤለ ካት አንጅንቶ!» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","ጌሽ ማጻፍተ፥ «ጽዮነ ካታምተ፥ ዣሽትፐ! ይኬ፥ ነ ካትዘ Ꮉረ ናአላ በቲ ይእዳ» ጋይንትዳን ፋና የሱሳ Ꮉረ ናአ ደንግ ኤዛ ቶግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","የሱሳ ታማሩንꬅ ይኖ ቲኖ ቲሪካያ። የዝን የሱሳ ቦንችንትዳንፓ ሱባ ኡን ይኖ ኡባ ቲርዳ። ይና ኡባ ጌሽ ማጻፍታ ጋይዳንጋራ Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","የሱሳ አላዛረ ቦዛፓ ጼጊ፥ Ꮉይቆፓ ደንꬅደ ዎደ ኤራ የዘ ጋማ አሱንꬅ የሱሳ ባዝ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ጋማ አሱንꬅ ኤዛ ሞኮደስ ከዝደ፥ ኤ ይና ክለ ባዝቶ ኦቼዛኖ ስእደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ይኒ ግሾ፥ ፋርሳዉንꬅ ፈተ ፈተጎ፥ «ኑ አኮን ኦቾደስ ዳንዳኦሳኖ ቦኦተ፤ ዎርዥታ ኡባ ኤዛ ካልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ፋስጋ ቦንችዘ ዎደ ጎይኖደስ የሩሳላመ Ꮉንገዙንꬅ ግዳ ፈቲ ፈቲ ግርኬ አሱንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ኡንትን ጋልላ ሳአ ቤተሳይዳ ካታማፓ ይእደ ፍልጶሳጎ ይእ፥ «ላꬆ፥ ኑኒ የሱሳ በአደስ ኮያነ» ያጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፍልጶሳ Ꮉንግ እንድርያሰስ ኦህን ላምኡንꬅ Ꮉንግ፥ የሱሳስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","የሱሳ ኡንታጎ፥ «አስ ናአይ፥ ቦንችንትዘ ዎደ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ፈቲ ዛርጋ ኣፈ ሳአ ዎꬊ ዶላንጽኮ ፋስ አታነ። የዝን የ ዛርጋ ኣፍዘ ዶልኮ ጋማ ኣፈ አፋነ። ");
INSERT INTO oyde_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ፋ ሸምፕቶ ካዽዘ ኦደን ꬋብሳነ፤ ፋ ሸምፕቶ Ꮉና አላምተ እጽዘ ኦደን መዽና ደኦስ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ታ የዘ በስተ ታራ የሳደ ጋር ታስ ኦቾደስ ኮየዘ ኦደን ታና ካሎደስ ቤዛነ። ታስ ኦችዛ ኦናን ታ አዳይ ቦንቾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Ꮉተ ታ ሸምፕታ ጋማ ኡንእንትዳ፤ ዬዝን ዋጎ? ‹ታ አዳዮ፥ ታና Ꮉና ሳትፓ አሾ› ያጋዉነ? አደ፥ ታ ይእዳና Ꮉና ማꬋ ሳትስ። ");
INSERT INTO oyde_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ታ አዳዮ፥ ነ ሱንꬅቶ ቦንቾ» ያጋይዳ። የ ዎደ ሳሎፓ፥ «ታኒ ታ ሱንꬅቶ ቦንችዳ፤ ማህን ቦንቾዳ» ያጋዘ ቃላ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ይና በስተ ኤቅደ ጋማ አሱንꬅ ይና ቃልቶ ስእ፥ «ይና ዳዳ ꬎገ» ያጋይዳ። መሉንꬅ ማህ፥ «ኪታንቾ ኤስ ኦህዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","የሱሳ ማህ ኡንታጎ፥ «Ꮉይ ኦꬅዘ ይን ግሾ ይእዳፕ አትን ታ ግሾ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ꮉና አላምታ ፍርድንትዘ ዎድታ Ꮉተ፤ Ꮉና አላምቶ አህዘ ካትዘ Ꮉተ ባለ ኦልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ማህ ታ ሳአፓ ꬎቅ ꬎቅ ጋይደ ዎደ አስ ኡባ ታጎ ኮኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ኤ ይኖ ጋይዳና አኮ ጋር Ꮉይቆ Ꮉይቆድየዛኮ ኡንትስ ቆንጭሳደስ። ");
INSERT INTO oyde_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ጋማ አሱንꬅ ማህ፥ «ኑ ህግታ ክርስቶሳ መዽና የዛኖ ኦህነ። ዬዝን፥ ነ ዋጋእ፥ ‹አስ ናአይ ꬎቅ ꬎቅ ጋዉደስ ቤዛነ› ጋኤ? ‹ኤ፥ አስ ናአይ ኦደ?› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","የሱሳ፥ «ፎኦ ይንታራ ኤራꬅ ዎደ ጋምኦዳ። ይንትስ ꬉማመ ጋር ፎኦ የዝን፥ ፎእተ Ꮉንቶተ። ꬉማ የꬍዘ አስ አና ቅትዛኮ ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ፎኦ ናኡንꬃና ማቃደ ጋር ፎኦ የዝን ፎእዛ አማኖተ» ያጋይዳ። የሱሳ ይኖ ኦህዳንፓ ማቂ Ꮉንግ ኡንታፓ ገንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ኤ ይኒ ፋና ክለ ባዝ ኡን ቲኖ ኦችንን አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ናበ ኢሳያሳ፥ «ላꬆ፥ ኑ ማርካትꬅቶ ኦኒ አማንደ? ላꬄ ፋ ዎልቅቶ ኦስ ቆንጭዝዶ?» ጋይዳና ቱሮ ማቃደ ፋና ኡን ኤዛ አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","ማህን ኢሳያሳ፥ «ኡን ኣፍታ በአመ ጋር፥ ኡን ዎዝንታ ቲራመ ጋር፥ ኡን ጾዛጎ ማቅን፥ ኤ ኡንታና ፋꬃመ ጋር፥ ጾዚ ኡን ኣፍቶ ቆቅዝዳ። ኡን ዎዝንታ ምንግዳ» ጋይደ ግሾ ኡን አማኖደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ኢሳያሳ ይኖ ጋይዳና፥ የሱሳ ቦንችቶ ብእደ ግሾነ ኤባዝን ኦህደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ማቅኮን፥ አይሁደ Ꮉላቁንꬃፓ ጋሙንꬅ የሱሳ አማንዳ። የዝን ፋርሳዉንꬅ ፋና አይሁዱንꬅ ዎሳ ኬꬃፓ ከሶዳ ጋእ ዣሽትደ ግሾ አማንዳ ጋእ ቆንጨ ማርክꬍካያ። ");
INSERT INTO oyde_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ይኖ ኡን ኦችደ፥ ጾዘ ቦንቾፓ አꬊ አስ ቦንቾ ካꬍደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","የሱሳ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ታና አማንዘ ኦደን ታና ኪተዛን አማናነፕ አትን ታና ጻላላ አማኖስ። ");
INSERT INTO oyde_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ታና በእዘ ኦደን ታና ኪተዛን በእነ። ");
INSERT INTO oyde_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ታና አማንዘ ኡባ ꬉማ የዛመ ፋና ታ ፎኦ ማቂ አላመ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ታ ቃልቶ ስእ ኪትንቶሳ ኦናን ታ ፍርዶስ። አኮስ ጋይኮ፥ ታ አላምቶ አሾደስ ይእዳፕ አትን ፍርዶደስ ይእካያ። ");
INSERT INTO oyde_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ታና እጽዛያን ታ ቃልቶ ኤኮሳ ኦናን ፍርድዘ የነ። ታ ኦህደ ቃልታ ዉርሱꬅ ቃማ የ አꬃ ፍርዶዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","አኮስ ጋይኮ፥ ታ ይኖ ታፓ ኦሆስ፥ የዝን ታና ኪተዘ ታ አዳይ ታ ጋዉዳኖን ኦሆዳኖ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ማህ ኤ ኪታን መዽና ደኦ ማቅዳኖ ታ ኤራነ። ይኒ ግሾ፥ ታ ኦህዛና ታ አዳይ ታስ ኦህዳኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ፋስጋ ቦንችዘ ቃምታ የሎዳንፓ ቲኖ Ꮉና አላምቶ አሺ አደጎ ቅትዘ ዎደ የልዳኖ የሱሳ ኤራነ። Ꮉና አላምተ የዘ ፋ አሱንꬃና ኡባ ዎደ ካꬋነ፤ ዉርሱꬅ የሎደስ ኡንታና ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","የሱሳራን ኤ ታማሩንꬃራ ዎላ ካዎ ሙነ። ይንፓ ቲኖ ጻላሄ ስሞና ናአ አስቆሮቱ ይሁዳ የሱሳ አꬂ እንጎደጋራ ኤ ዎዝንተ ኢታ ቆፋ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","የሱሳ አዳይ ኡባባዝቶ ኤ ኩሽተ ጋድዳኖ፥ ኤ ጾዘ ካለፓ ይእዳኖን ማቂ ኤጎ ኡዶዳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","የሱሳ ካዎፓ ደንዲ ካታራ የዘ ማእቶ ቃሪ ጋዲ፥ አፉላ ሎዶ ኤኪ ፋ ቃዝንተ ዳንጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ይንፓ ማቂ፥ Ꮉꬅ ጋባተ ፋቅ፥ ፋ ታማሩንꬅ ቶህቶ ሜጭዳ፤ ማህ ፋ ቃዝንተ ዳንጭደ አፉላ ሎዶራ ኡጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","የሱሳ ስሞን ጴጥሮሳጎ የልደ ዎደ ጴጥሮሳ፥ «ላꬆ፥ ነ ታ ቶህቶ ሜጮዳነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","የሱሳ ማህ ኤጎ፥ «ታ ኦችዛኖ ነ Ꮉተ ኤሮስ፥ የዝን ሱባፓ ቲሮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ዬዝን፥ ጴጥሮሳ፥ «ነ ታ ቶህቶ መꬍናስ ሜጫማ» ያጋይዳ። የሱሳ ኤጎ፥ «ታ ነ ቶህቶ ሜጫንጽኮ ኔስን ታስ ፈተትꬅ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ጴጥሮሳ የሱሳጎ፥ «ላꬆ፥ ዬዛኮ፥ ታ ቶህቶ ጻላላ ማቅካይዝን ታ ኩሽቶን ታ ኦምቶን ኡባ ሜጮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","የሱሳ ማህ፥ «ጋላ ማትንትደ ኦደን ቶሄፓ መለባዝ ማትንቶደስ ቤዞስ፤ ኤስ ኡባ ጋልታ ጌሽ። ይን ጌሽ፥ የዝን ኡቡንꬅ ጌሽ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","የሱሳ ፋና አꬂ እማደ አꬄ ኦና የዛኮ ኤርዘ ግሾ «ይን ኡቡንꬅ ጌሽ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ኡን ቶህቶ ሜጭዳንፓ ማቂ የሱሳ ፋ ማእቶ ማህ ማእዳ። ማቂ ኡን ግዳ በቲ ኡንታጎ፥ «ታኒ ይንትስ ኦችዳኖ ቲራነ? ");
INSERT INTO oyde_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ይን ታና አስታማረን ላꬅን ጋነ፤ ታኒ ይን ጋዛን ፋና ማቅደ ግሾ ሎኦ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ታ ይንትስ ላꬅን አስታማረ ማቅተራ ይን ቶህቶ ሜጭኮ ይንትን ፈተ ፈተስ ይኒ ጋራ ኦቾደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ይኬ፥ ታ ይንትስ ኦችዳን ጋር ይንትን ኦቾደ ጋር ታ ይንትስ አዝዘ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ታ ይንትስ ቱሮ ቱሮ ጋነ፤ አሮ ፋ ላꬄፓ፥ ኪትንትዘን ኪትደፓ አꬎኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ይን ይኖ ኤሪ ኦችዛ ማቅኮ አንጅንትዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«ታ ይን ኡቡንꬃና ጋኦስ፤ ታ ዶርዱንꬃና ታ ኤራነ። የዝን ጌሽ ማጻፍተ፥ ‹ታ ቦርዛ ሙይደ ታላ ደንድዳ› ጋእንትዳና ቱሮ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ታኒ ታና ማቅዛኖ ይን አማኖደ ጋር ይና Ꮉኖዳንፓ ቲኖ ይንትስ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ታ ኪትደ አꬃ ሞክዘ ታና ሞካነ። ታና ሞክዘ ኦደን ታና ኪተዛ ሞካነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","የሱሳ ይኖ ኦህዳንፓ ማቂ ፋ ዎዝንተ ጋማ ኡንእንት፥ «ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ታና ይንታፓ ፈተ አꬂ እንጎዳ» ጋእ ቆንጭዝ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ኤ ኦህዳና ታማሩንꬅስ ኤርንታንጽን ዎል ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ኤ ታማሩንꬃፓ ፈተ፥ የሱሳ ካዽዘ፥ የሱሳ ካለ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ይኒ ግሾ፥ ስሞን ጴጥሮሳ ኤዛ ማሊ፥ «ኤ ኦና ጋዛኮ አነ ኦጮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ይኒ ግሾ፥ የ ታማርዘ የሱሳጎ ሺቂ፥ «ላꬆ፥ ኤ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","የሱሳ ማህ፥ «ታ ቦራ ባጽ ቱሺ ባርስዛያ» ያጋይዳ። ማህን ቦራ ባጽ ኤኪ፥ ቱሺ፥ ስሞና ናአይ አስቆሮቱ ይሁዳስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ይሁዳ ቦርዛ ባርዳንፓ ማቂ ጻላሄ ኢራ ይሁዳ ግዳ ገልዳ። የሱሳ ኤጎ፥ «ነ ኦቾደስ ቆፐዛኖ ኤልሲ ኦቾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","የዝን በቴዙንꬃፓ ኦደን የሱሳ ይኖ አኮስ ኤጎ ጋኤዛኮ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ይሁዳ ብራ አይክዘ ግሾ ኤዛ ታማሩንꬃፓ ፈተ ፈተ የሱሳ ኤዛ፥ «ፋስጋ ቦንችዘ ቃማስ ፋስ ቤዝዘ ባዝ ዎንጎ ዎይ ዳሁንꬅ ሙጻተ እንጎ ጋይዳ» ያጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ይሁዳ ቦርዛ ኤክደ ፋና ኢራ ባለ ከዝዳ። የ ዎደ ሳእታ ቃማ። ");
INSERT INTO oyde_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ይሁዳ ባለ ከዝዳንፓ ማቂ፥ የሱሳ፥ «Ꮉተ አስ ናአይ ቦንችንትዳ፤ ጾዝን ኤ ባጋራ ቦንችንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ጾዚ ኤ ባጋራ ቦንችንትን ኤ ፋ ኦምተ አስ ናአያ ቦንቾዳ፤ ማህ ኤ ይኖ ኤልሲ ዪሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ታ ናኡንꬆ፥ ታ ይንታራ ጋማ ዎደ ጋምኦስ። ይን ታና ኮዮዳ፥ የዝን ታ አይሁዱንꬅስ ኦህዛን ጋር፥ ‹ይን ታኒ ቅትደ በስቶ ዮኦደስ ዳንዳኦስ።› ");
INSERT INTO oyde_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ታ ይንትስ እንግዘ ክለ ኪታ Ꮉኖ፤ ፈተ ፈታ ካꬎተ። ታ ይንታና ካꬍዳንፋና ይን ፈተ ፈታ ካꬎደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ይን ፈተ ፈተራ ካꬍንትኮ ይን ታ ታማሩንꬃና ማቅዛኖ አስ ኡባ ይነ ኤሮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ስሞን ጴጥሮሳ የሱሳጎ፥ «ላꬆ፥ ነ አባ ቅተ?» ያጋይዳ። የሱሳ ማህ፥ «ታ ቅትዘ በሳ ነ Ꮉተ ካሎደስ ዳንዳኦስ፥ የዝን ሱባፓ ታና ካሎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጴጥሮሳ፥ «ላꬆ፥ ታ ነና Ꮉተ ካሎደስ አኮስ ዳንዳኦሳ? ታ ነ ግሾ Ꮉይቆደስን ጊጊ በትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","የሱሳ ማህ፥ «ታ ግሾ Ꮉይቆደስ ቱሮ ጊጊ በትዳ? ታ ኔስ ቱሮ ቱሮ ጋነ፤ ሉኩለ ኡኮዳንፓ ቲኖ ነ ታና Ꮉይꬕ ቶሄ ካዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","የሱሳ ፋ ታማሩንꬃጎ፥ «ይን ዎዝንታ ይርግፐ፥ ጾዛ አማኖተ፥ ታናን አማኖተ። ");
INSERT INTO oyde_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ታ አዳይ ኬꬃ ጋማ በሲ የነ። ታ ይንትስ በሲ ጊግሳደስ ቅታነ። ይና ባይዛኮ ታ ይንትስ ኦሆድ የሻ። ");
INSERT INTO oyde_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ታ ኡዲ በሲ ጊግዝዳንፓ ሱባ ታ የዘ በስተ ይን የሳደ ጋር ላምእንꬃ ይእ ይንታና ታጎ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ይን ታ ቅትዘ በስቶን ኦግቶ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ዬዝን፥ ቶማሳ፥ «ላꬆ፥ ነ ቅትዘ በስቶ ኑ ኤሮስ፤ ኦግቶ ዋይዝ ኤሮደስ ዳንዳኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","የሱሳ ማህ፥ «ኦገ፥ ቱሮን ደኦን ታና። ታ ባጋራ ማቃንጽኮ ኦደን ታ አደጎ ዮኦደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ይን ታና ኤርዛኮ፥ ታ አዳያን ኤሮዳ። የዝን ይኬፓ አይኪ ይን ኤዛ ኤራነን ኤዛ ብእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፍልጶሳን የሱሳጎ፥ «ላꬆ፥ አዳያ ኑና ቤዛኮ፤ ኑስ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","የሱሳን ማህ፥ «ታ Ꮉኒ ጋርዘ ዎደ ይንታራ የዝን ታና ኤሮስተ? ታና በኤዘ አꬄ አዳያን ብእዳ። ዬዝን፥ ነ ዋይዝ፥ ‹አዳያ ኑና ቤዞ› ጋኤ? ");
INSERT INTO oyde_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ታኒ አደራ ፈቶ ማቅዳኖን አደን ታራ ፈቶ ማቅዳኖ ነ አማኖሳነ? ታ ይንትስ ኦህዘ ቃልቶ ታ ታፓ ኦሆስ፥ የዝን ታ ግዳ የዘ አዳይ ኤ ፋ ኦችቶ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ታኒ አዳይ ግዳ የዛኖን አደን ታ ግዳ የዛኖ አማኖተ። ይኖ አማናንጽኮ ታ ኦችተ ታና አማኖተ። ");
INSERT INTO oyde_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ታና አማንዘ አꬄ ታ ኦችዘ ኦቻ ኤ ኦቾዳ። ታ አደጎ ቅትዘ ግሾ ታና አማንዘ ኦደን Ꮉንፓ አꬍዘ ኦቻ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","አዳይ ናአይ ባጋራ ቦንችንቶደ ፋና ታ ሱንꬅተ ይን ዎስዘ ባዝ ኡባ ታ ይንትስ ዪሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ታ ሱንꬅተ አኮ ባዝን ይን ኦጭኮ ታ ይንትስ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«ይን ታና ካꬍኮ ታ ኪቶ ናጎተ። ");
INSERT INTO oyde_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ታኒ ታ አዳያ ዎሶዳ፤ ይንታራ መዽና የሳደ ጋር ምንꬅꬅዛ ይንትስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","የ አያንዘ ጾዘ ቱሮ ቤዛነ። Ꮉና አላምተ አሱንꬅ ኤዛ ብእካይዘ ግሾን ኤሮሰ ግሾ ኤዛ ኤኮደስ ዳንዳኦስ። የዝን ኤ ይንታራ የዘ ግሾን ይን ግዳ የሳደ ግሾ ይን ኤዛ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«ታ ይንታና እንዳን አደን ባይዘ ናአ ጋር ይን ጻላላ አሾስ፤ ማቂ ይንታጎ ዮኦዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ኤራꬅ ዎደፓ ሱባ አላመ ታና ማህ ቦኦስ፥ የዝን ይን ቦኦዳ። ታ ደኦ ማቅደ ግሾ ይንትን ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ታ ታ አዳይ ግዳ፥ ይን ታ ግዳ፥ ማህ ታ ይንታራ የዛኖ ይን የ ዎደ ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«ታ ኪቶ ኤኪ ናግዘ ታና ካꬋነ። ታና ካꬍዛያ ታ አደን ካꬋነ፤ ታንን ኤዛ ካꬋነ፤ ታንን ታናትꬅቶ ይንትስ ጌሾዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","አስቆሮቱ ይሁዳ ማቅካይዘ ይሁዳ የሱሳጎ፥ «ላꬆ፥ ነ ዋይዝ አላመስ ማቅካይዝን ኑስ ነና ቆንጭሳደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","የሱሳ ማህ፥ «ታና ካዽዘ ኦደን ታ ቃልቶ ናጎዳ። ታ አዳይ ኤዛ ካꬎዳ። ኤጎ ኑ ዮኦዳ። ኤራ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ታና ካꬎኦሰ ኦደን ታ ቃልቶ ናጎስ። ይን ስእዘ ቃልታ ታና ኪትደ አደ ባዛፕ አትን ታ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«ታ ይንታራ Ꮉተ የዘ ግሾ ይኖ ይንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","የዝን አዳይ ታ ሱንꬅተ ኪትዘ ምንꬅꬅዘ ጌሽ አያና፥ ይንታና ኡባባዝቶ ታማርሶዳ። ታ ይንትስ ኦህዳኖ ኡባ ኤ ይንታና ቆፍሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«ሳሮ ይንትስ አሾዳ። ታኒ ታ ሳርቶ ይንትስ እንጎዳ። ታ እንግዘ ሳሮትꬅታ አላመ እንግዘ ሳሮትꬅት ፋና ባያ። ይኒ ግሾ፥ ይን ዎዝንታ ይርግፐን፥ ዣሽትፐ። ");
INSERT INTO oyde_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‹ታ ቅቶዳ፥ የዝን ማቂ ይንታጎ ዮኦዳ› ጋይዳኖ ይን ስእዳ። ይን ታና ቱሮ ካꬍዘባዝ ማቅኮ ታ አዳይ ታፓ አꬍዘ ግሾ ታ ኤጎ ቅትዛነ ይን ኡፋይቶዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ይና ዪዘ ዎደ ይን አማኖደ ጋር ይና Ꮉንካይዝን ቲኖ ታ ይንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","«Ꮉና አላምቶ አህዘ የእዘ ግሾ ይኬፓ ሱባ ይንታራ ጋማ ኦህንቶስ። ታና ኤ አኮን ኦቾደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","የዝን ታ አዳያ ካꬍዛኖ አላመ ኤሮደ ጋር ታ አዳይ ታና ኪተዛኖ ኡባ ዪሳዳ። ደንዶተ፤ Ꮉንፓ የꬎተ። ");
INSERT INTO oyde_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«ታ ዎይነስ ቱሪ ኡዙማ፥ ዎትዘን ታ አዳያ። ");
INSERT INTO oyde_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ታ ግዳ የዘ ኣፈ አፎሰ ታሽቶ ኡባ ኤ ጋቺ Ꮉሶዳ። ኣፍዘ ታሽቶ ካሰንፓ ጋንꬅ አፎደ ፋና ይና ታሽቶ ኤ ኮሺ ጊግሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ታ ይንትስ ኦህደ ቃልት ግሾ ይን ጌሽ። ");
INSERT INTO oyde_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ታ ግዳ የዞተ፤ ታንን ይን ግዳ የሳዳ። ዎይነስ ታሸ ኡዙምዘላ የዛንጽኮ የ ታሽዘ ፋ ፋስ ኣፈ አፎደስ ዳንዳኦስ። ይኒ ፋና፥ ይንትን ታ ግዳ የዛንጽኮ ኣፈ አፎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«ታኒ ዎይነስ ኡዙማ፤ ይን ታሸ። ታላ የዘን ታንን ኤ ግዳ የዘ፥ ኤ ጋማ ኣፈ አፎዳ። ታ ባይዝን ይን ጻላላ አኮን ኦቾደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ታላ የዞሰ ታሸ ፋና አላ ኦልንት መሎዳ። ይኒ ፋና ታሹንꬃን ሺሺ ታማ ኦሎዳ፥ ምቾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ይን ታር የዝኮ፥ ታ ቃልታን ይንግዳ የዝኮ፥ ይን ኮይዘ ባዝ አኮ ማቅኮን ዎሶተ፤ ይን ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ይን ጋማ ኣፈ ኣፍዘ ታ ታማሩንꬃና ማቅኮ፥ ይነ ታ አዳይ ቦንችንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","አዳይ ታና ካꬍዛን ጋራ ታንን ይንታና ካꬋነ፤ ታ ሲቅተ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ታኒ ታ አዳይ ኪቶ ናጊ ኤ ሲቅተ የዝዳንጋራ ይንትን ታ ኪቶ ናግኮ ታ ሲቅተ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«ታ ኡፋይስታ ይንግዳ ፎልንቶደ ፋናን ይን ኡፋይስታ ፎሎ ማቃደ ፋና ታ ይንትስ ይኖ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ታ ኪታ Ꮉኖ፤ ታ ይንታና ካꬍዛን ፋና ይንትን ፈተ ፈታ ካꬎተ። ");
INSERT INTO oyde_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ፋ ሸምፕቶ ፋ ላጉንꬅስ እንግዛንፓ አꬍዘ ዳማ ሲቆ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ታ ይንታና ኪትዳኖ ኡባ ኦችኮ ይን ታ ላጉንꬃና። ");
INSERT INTO oyde_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","«አሮ ፋ ላꬃይ ኦችዘባዝ ኤሮሰ ግሾ ታ ይንታና ይኬፓ ማቂ አሩንꬃና ጋኦስ። የዝን ታ አዳያ ስእዘ ኡባ ታ ይንትስ ኦህደ ግሾ ይንታና ታ ላጉንꬃና ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ታ ይንታና ዶርዳፕ አትን ይን ታና ዶርካያ። ይን Ꮉንግ ኣፈ አፎደ ፋናን ኣፈራ ይን የሳደ ፋና ሹምዳ። ይኖ ማቅኮ ታ አዳይ ይን ታ ሱንꬅትራ ዎስደባዝ ኡባ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ታ ኪታ Ꮉኖ፦ ፈተ ፈታ ካꬎተ። ");
INSERT INTO oyde_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«አላመ ይንታና እጽኮ ቲኖ ታና እጽዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ይን አላመባዝ ማቅዛኮ አላመ ፋ ባዝ ፋና ይንታና ካꬎድየሻ። የዝን ታ ይንታና አላመፓ ዶርደ ግሾን ይን አላመባዝ ማቅካይዘ ግሾ አላመ ይንታና እጻነ። ");
INSERT INTO oyde_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‹አሮ ፋ ላꬄፓ አꬎኦስ› ጋእ ታ ይንትስ ኦህዳኖ ቆፖተ። ኡን ታና ባይእዘባዝ ማቅኮ ይንታናን ባይኦዳ። ኡን ታ ቃልቶ ናገዘባዝ ማቅኮ ይን ቃልቶን ናጎዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","የዝን ኡን ታና ኪተዛያ ኤሮሰ ግሾ Ꮉኖ ኡባ ታ ግሾ ይንታላ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ታ ይእ ኦህካይዛኮ ኡንትስ ናጋራ ማቃምየሻ። የዝን Ꮉተ ኡን ኦችደ ናጋርትስ ምክናተ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ታና እጽዘ ታ አዳያን እጻነ። ");
INSERT INTO oyde_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ኦደን ኦችካይዘ ኦቻ ታ ኡን ግዳ ኦቺ ብእካይዘ ባዝ ማቅዛኮ ኡንትስ ናጋራ ማቃምየሻ። የዝን Ꮉተ ኡን ታ ኦችደ ኦችቶ ብእ ታናን ታ አዳያን እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","የዝን ኡን ህግተ፥ ‹ታና Ꮉሪ እጽዳ› ጋእንት ጻፍንትዳና ፎልንቶደ ፋና ይና ዪእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«አደፓ የእዘ ቱሪ አያና ታ ይንትስ ኪቶዳ። ኤ ይንታና ምንꬅꬆዳ፥ ታ ባዝ ማርክꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ይንትን ቲኖፓ አይኪ ታራ የዘ ግሾ ታ ባዝ ማርክꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«ታ ይኖ ይን አማንትፓ ꬉብንታመ ፋና ይንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ኡን ይንታና አይሁደ ዎሳ ኬꬃፓ ከሶዳ። ይንፓን አꬊ፥ ይንታና ዎꬍዘ ኦደን ጾዚ ኮይዘ ባዝ ኦችዛ አዝዘ ዎደ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ኡን ይኖ ይንታላ ኦችዘ ታና ዎይ አዳያ ኤርካይዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","የዝን ኡን ይኖ ይንታላ ኦችዘ ዎድታ የልደ ዎደ ታ ይንትስ ኦህዳኖ ይን ቆፖደ ጋር ታ ይንትስ Ꮉኖ ኦህዳ። «ቲኖ ታ Ꮉኖ ይንትስ ኦህካይዛራ ጋምእዳና ታ ይንታራ የዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","የዝን Ꮉተ ታኒ ታና ኪተዘጎ ቅታነ፤ ይንታፓ ኦደን፥ ‹አባ ቅተ?› ጋእ ታና ኦጭዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","የዝን ታ ይኖ ኦህደ ግሾ ይን ዎዝንተ ጋማ ካዮ ቆፋራ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","የዝን ታ ይንትስ ቱሮ ኦህነ፤ ታ ቅትዛኮ ይንትስ ሎኦ። አኮስ ጋይኮ፥ ታ ቅታንጽኮ ምንꬅꬅዘ ይንታጎ የአማ። የዝን ታ ቅትኮ ኤዛ ይንታጎ ዳኮዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ምንꬅꬅዘ ይእ፥ ናጋራስ፥ ጽሎትꬅስን ፍርዳስ Ꮉና አላመ አሱንꬃና ኦጮዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ናጋራስ፥ አሱንꬅ ታና አማኖሰ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ጽሎትꬅስ፥ ታ አደጎ ቅትዘ ግሾን ይን ታና ማህ በአመ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ፍርዳስ፥ ማህ አላምቶ አህዘ ፍርድንትደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«ታ ይንትስ ኦሆደ ጋማ ባዝ የነ፥ የዝን Ꮉተ ይንታና ዴጾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ቱሪ አያና ይእደ ዎደ ይንታና ቱረትꬅ ኡባጎ ካልꬆዳ። ኤ ስእደባዝ ኦሆዳፕ አትን ፋፓ አኮ ባዝን ኦሆስ። ማህ ቲኖፓ የኦደባዝ ይንትስ ኤ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ኤ ታስ የዛንፓ ኤኪ ይንትስ ኦህዘ ግሾ ኤ ታና ቦንቾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","አደስ የዘ ባዝ ኡባና ታ ባዝ፤ ‹ምንꬅꬅዘ ታስ የዛንፓ ኤኪ ይንትስ ኦሆዳ› ታ ጋይዳና ይንስ። ");
INSERT INTO oyde_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«ኤራꬅ ዎደፓ ሱባ ታና ይን በአማ፤ ማህ ኤራꬅ ዎደፓ ሱባ ይን ታና ቦኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ኤ ታማሩንꬃፓ ፈተ ፈተ ዎል ግዳ፥ «‹ኤራꬅ ዎደፓ ሱባ ይን ታና በአማ፤ ማህ ኤራꬅ ዎደፓ ሱባ ይን ታና ቦኦዳ›፤ ማህን ታ አደጎ ቅቶዳ ጋዛና አኮ ጋእንተ?» ጋእ ዎላ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ይኬ «ኤራꬅ ዎደፓ ሱባ ጋዛና አኮ ጋኤ? ኤ አኮ ኦህዛኮ ኑስ ኤርንቶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ኡን ኤዛ ኦጮደስ ኮይዛኖ የሱሳ ኤሪ፥ «ታኒ፥ ‹ኤራꬅ ዎደፓ ሱባ ታና በአማ፤ ማህ ኤራꬅ ዎደፓ ሱባ ይን ታና ቦኦዳ› ጋይዳንስ ይን ፈተ ፈታ ኦጫነ? ");
INSERT INTO oyde_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ታኒ ይንትስ ቱሮ ቱሮ ጋነ፤ ይን ዬኮዳን ዘለሎዳ፥ የዝን Ꮉና አላምታ ኡፋይቶዳ። Ꮉተ ይን አዛኖዳ፥ የዝን ይን አዛንታ ኡፋይሳ ላምንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ፈቲ ማችታ ናአ የሎደስ ዪእዘ ዎደ ፋ የልዘ ዎድታ የልደ ግሾ ይርጋነ። የዝን ናአ የልዳንፓ ሱባ ናአ Ꮉና አላምተ የልንትደ ኡፋይስት ግሾ ፋ ኡንእቶ ቦታነ። ");
INSERT INTO oyde_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ይኒ ጋር፥ ይንትን ይን ዎዝንተ አዛናነ፥ የዝን ታኒ ይንታና ማህ ቦኦዳ። ይን ዎዝንታ ጋማ ኡፋይቶዳ፤ ይና ኡፋይስቶ ኦደን ይንታፓ ኤኮስ። ");
INSERT INTO oyde_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«የ ዎደ ይን ታና አኮ ባዝን ዎሳማ። ታ ይንትስ ቱሮ ቱሮ ጋነ፤ ይን ታ ሱንꬅተ ዎስዘ ባዝ ኡባ አዳይ ይንትስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ꮉኖ የሎደስ ታ ሱንꬅተ አኮ ባዝን ዎስካያ። ይን ኡፋይስታ ፎሎ ማቃደ ጋር ዎሶተ፤ ይን ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«ታኒ Ꮉኖ የሎደስ ይንትስ አዝዘራ ኦህዳ፥ ይኬፓ ታኒ አዝዘራ ኦሆሰ ዎደ የኦዳ። የዝን አደባዝ ታ ይንትስ ቆንጭዝ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","የ ዎደ ይን ታ ሱንꬅተ አዳያ ዎሶዳ፤ ይን ግሾ ታኒ ታ አዳያ ዎሶዳ ጋኤ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","አኮስ ጋይኮ፥ አዳይ ፋ ኦምተ ይንታና ካꬋነ። ይን ታና ካዽዘ ግሾን ታ አዳይ ካለፓ ዪዳኖ አማንዘ ግሾ ኤ ይንታና ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ታ አዳይ ካለፓ Ꮉና አላምተ ዪዳ፤ ማህ አላምቶ አሺ አደጎ ቅቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ኤ ታማሩንꬅ ማህ፥ «ይኬ፥ Ꮉተ ኔኒ ቆንጭዝ ኦህነፕ አትን፤ አዝዘራ አኮን ኦሆስ። ");
INSERT INTO oyde_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ነ ኡባ ባዝ ኤርዛኖ ኦናን ኦጮደስ ኮዮሳኖ ኑ Ꮉተ ኤራነ። ይኒ ግሾ ነ ጾዛፓ ኪትንትዳና አማንꬃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ዬዝን፥ የሱሳ ማህ ኡንታጎ፥ «Ꮉተ ይን አማናነ? ");
INSERT INTO oyde_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ይኬ፥ ይን፥ ይን ካራ ይን ካራ ላልንቲ ታና ታ ጻላላ አሺ አሺ ኣችንቶደ ዎደ የኦዳ፤ Ꮉተን የልዳ። የዝን አዳይ ታራ የዘ ግሾ ታ ታ ጻላላ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ይን ታራ የዝን ሳሮ ይንትስ የሳደ ፋና ታ ይኖ ኦህዳ። አላመ ግዳ የዝተር ይን ዋይንቶዳ። የዝን ምንጎተ፤ ታኒ አላምቶ ጋምዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","የሱሳ ይኖ ኦህዳንፓ ሱባ ኡደ ሳሎ ብእ፥ Ꮉንጋራ ያጋይዳ፦ «ታ አዳዮ፥ ቃምታ የልዳ፤ ነ ናአይ ነና ቦንቾደ ጋር ኔኒ ነ ናአያ ቦንቾ። ");
INSERT INTO oyde_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ነ ኤስ እንግደ ኡቡንꬅስ ኤ መዽና ደኦ እንጎደ ፋና አስ ኡባላ ኤስ አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","መዽና ደኦ፥ ነና፥ ፈቲ ቱሪ ጾዛን ነ ኪትደ የሱስ ክርስቶሳ ኤረ። ");
INSERT INTO oyde_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ነ ታ ኦቾደ ፋና እንግደ ኦችቶ ፋዲ ነና ሳአላ ቦንችዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ꮉተን፥ አዳዮ፥ አላመ መꬍንቶዳንፓ ቲኖ ነ ካለ ታስ የዘ ቦንችተ ታና ቦንቾ። ");
INSERT INTO oyde_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«አላመ አሳፓ ነ ታስ እንግዱንꬃና ነና ኤርስዳ። ኡን ነባዝ፤ ነ ኡንታና ታስ እንግዳ። ኡን ነ ቃልትስን ኪትንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ነ ታስ እንግደ ኡባ ባዝታ ኔፓ ዪዳኖ ኡን Ꮉተ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ነ ታስ እንግደ ቃልቶ ታ ኡንትስ እንግዳ፤ ኡንትን ይና ቃልቶ ኤክዳ። ታ ነ ካለፓ ይእዳና ቱሮ ማቅዳኖ ኤሪ ነ ታና ኪትዳኖ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«ታ ኡንትስ ዎሳነ። ኡን ነባዝ ማቅደ ግሾ ነ ታስ እንግደ አሱንꬅስ ዎሳነፕ አትን አላመስ ዎሶስ። ");
INSERT INTO oyde_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ታስ የዛና ኡባ ነባዝ፤ ኔስ የዛና ኡባ ታስ። ታ ኡን ባጋራ ቦንችንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ታ ይኬፓ ሱባ አላምተ ጋምኦስ፤ ኡን አላምተ የነ። ታ Ꮉተ ኔጎ ቅታነ። ጌሽ አዳዮ፥ Ꮉንስ ነ ታስ እንግዱንꬅ ኔራን ታራን ፈቶ ማቅዳን ጋራ ኡን ፈቶ ማቃደ ጋር ኡንታና ነ ታስ እንግደ ነ ሱንꬅተ ናጎ። ");
INSERT INTO oyde_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ታ ኡንታራ ሳአ የዝተራ፥ ነ ታስ እንግደ ነ ሱንꬅተ ኡንታና ናግዳ። ጌሽ ማጻፍታ ጋይዳና ፎልንቶደ ጋር ꬋበ ቤዘ አꬄፕ አትን ኡንታፓ መለ ኦደን ꬋብካያ። ");
INSERT INTO oyde_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Ꮉተ ታ ኔጎ የኦዳ። ታ ኡፋይስታ ኡን ዎዝንተ ፎሎ ማቃደ ጋር Ꮉኖ ታ አላምተ የዛራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ታ ኡንትስ ነ ቃልቶ እንግዳ። ታ አላመፓ ማቅካይዛን ፋና፥ ኡንትን አላመፓ ማቅካይዘ ግሾ አላመ ኡንታና እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ነ ኢታፓ ኡንታና ናጎደ ጋራፕ አትን አላመፓ ከሶዳ ጋር ዎሶስ። ");
INSERT INTO oyde_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ታኒ አላመፓ ባይዛን ፋና ኡንትን አላመፓ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ኔኒ ነ ቱርተ ኡንታና ጌሾ፤ ነ ቃልታን ቱሮ። ");
INSERT INTO oyde_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ነ ታና አላመ ኪትዳን ፋና ታንን ኡንታና አላመ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ማህ ኡን ቱሮ ጌሽ ማቃደ ጋር ኡን ግሾ ታ ታ ኦምቶ ጌሾዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«ታኒ ኡን ጻላላስ ማቅካይዝን ኡን ቃልትፓ ደንዲ፥ ታና አማኖዱንꬅስን ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ኡን ኡቡንꬅ ፈቶ ማቃደ ጋር ታ ዎሳነ። አዳዮ፥ ነ ታ ግዳ የዛንጋራ፥ ማህ ታ ነ ግዳ የዛንጋራ ኡን ነ ግዳ የሳደ ጋር ዎሳነ። የ ዎደ ነ ታና ኪተዛኖ አላመ አማኖዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ኔንን ታንን ፈቶ ማቅዳን ጋራ፥ ኡንትን ፈቶ ማቃደ ጋር፥ ነ ታና ቦንችዳን ጋራ፥ ታንን ኡንታና ቦንችዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ታ ኡን ግዳ፥ ኔኒ ታ ግዳ የዛንጋራ ኡን ፎሎ ፈቶ ማቃደ ጋር ነና ዎሳነ። ይናን፥ ነ ታና ኪተዛኖ ነ ታና ካꬍደ ካꬍተ ኡን ካꬍዳኖ አላመ ኤሮደ ጋር። ");
INSERT INTO oyde_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«አዳዮ፥ ነ ታስ እንግዱንꬅ ታ የዘ በስተ ታራ የሳደ ጋር ኮያነ። አላመ መꬍንቶዳንፓ ቲኖ ነ ታና ካꬍደ ግሾ ታስ እንግደ ታ ቦንችቶ ኡን ቦኦዳ። ");
INSERT INTO oyde_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«ጌሽ ታ አዳዮ፥ አላመ ነና ኤሮስ፥ የዝን ነና ታ ኤራነ። ማህ ነ ታና ኪተዛኖ Ꮉንስ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ነ ታና ሲቅደ ሲቅታ ኡን ግዳ የሳደ ጋር፥ ማህ ታኒ ኡን ግዳ የሳደ ጋር፥ ታ ነ ሱንꬅቶ ኡንታና ኤርስዳ፤ ቲኖስን ኤርሶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","የሱሳ ዎሳ Ꮉስዳንፓ ማቂ ፋ ታማሩንꬃራ ቀድሮነ ቦርካ ፊንግ፥ ይና በስተ የዘ አታክልተ ግዳ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","የሱሳ ኡባ ዎደ ፋ ታማሩንꬃራ እዘ ሺቅዘ ግሾ የሱሳ አꬂ እንግደ ይሁዳ ይና በስቶ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ይኒ ግሾ፥ ይሁዳ ፋኖሰ፥ ጾምፐ፥ ኦላ ሚሸ አይክደ ጋማ ዎታዳሩንꬃና፥ ካህኑንꬅ Ꮉላቁንꬅን ፋርሳዉንꬅ ኪትደ ጾዘ ኬꬅቶ ናግዘ ፖሊሱንꬃና ካልꬅ ኤኪ፥ ይና በስቶ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","የሱሳ ፋና የሎደ ባዝ ኡባ ኤሪ፥ ጋጻ ኬዚ፥ «ኦና ኮየተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ኡን ማህ፥ «ናዝረተ የሱሳ ኮያነ» ያጋይዳ። ኤ ማህ፥ «ታኒ የሱሳ» ያጋይዳ። የሱሳ አꬂ እንግደ ይሁዳ እዘ ኡንታራ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ኤ፥ «ታኒ የሱሳ» ጋይደ ዎደ ኡን ሱብ ሺቂ፥ ሳአ ጎልእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","የሱሳ ማህ፥ «ኦና ኮየተ?» ያጋእ ኦጭዳ። ኡንትን፥ «ናዝረተ የሱሳ ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ኤ ማህ፥ «ታኒ የሱሳ ማቅዛኖ ይንትስ ኦህዳ። ይኬ፥ ይን ታና ኮይዘ ባዝ ማቅኮ Ꮉንስ ቅቶ ጋኦ አሾተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ኤ ይኖ ጋይደ፥ «አዳዮ፥ ነ ታስ እንግዱንꬃፓ መለ አቶ የዝን ፈታን ꬋብስካያ» ጋይደ ቃልታ ፎልንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ስሞን ጴጥሮሳስ ማሻ የነ። ኤ የ ማሽዛ ሾዲ ካህኑንꬅ Ꮉላቃ አርዘስ ምዛቅ Ꮉይዛ ጋቺ ኦልዳ። የ አርዘ ሱንꬅታ ማልኮሳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","የሱሳ ጴጥሮሳጎ፥ «ነ ማሽዛ ሾክተ ገልꬆ። ታ አዳይ ታስ እንግደ ጹእትፓ ታ ኡዣማነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ሮመ ዎታዳሩንꬅን ኡን Ꮉላቅዘ ጾዘ ኬꬅቶ ናግዘ ፖሊሱንꬃራ ዎላ የሱሳ አይኪ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ቲኖ የሱሳ ሃናጎ ካንግዳ። ሐና ይና በርተ ካህኑንꬅ Ꮉላቃ ማቅደ ቃያፋ ቦሌ። ");
INSERT INTO oyde_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ቃያፋ፥ «ዎርዣ ግሾ ፈቲ አስ Ꮉይቂኮ ሎኦ» ጋእ ቲኖ አይሁዱንꬃና ዞሪዳያ። ");
INSERT INTO oyde_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ስሞን ጴጥሮሳን መለ ፈቲ ታማርዘ የሱሳ ካሊ Ꮉንግዳ። ካህነ Ꮉላቅዘ የ መለ ታማርዛ ሎይꬂ ኤራነ። ይኒ ግሾ፥ ኤ የሱሳራ ካህኑንꬅ Ꮉላቅዘ ግበ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","የዝን ጴጥሮሳ ጋሰፓ ባለራ ኤቅዳ። ካህኑንꬅ Ꮉላቅዘ ኤርዘ መለ ታማርዘ ባለ ኬዚ፥ ፉርꬅቶ ናግዘ ናትስ ኦህ፥ ጴጥሮሳ ገልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ፉርꬅቶ ናግዘ ናታ ጴጥሮሳጎ፥ «ነ፥ የ አꬄ ታማሩንꬃፓ ፈታ ባነ?» ያጋይዳ። ጴጥሮሳ ማህ፥ «አደ፥ ታና ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ሳእታ ጪሽዘ ግሾ አሩንꬅን ናግዙንꬅን ኬንቼሎ ቃቃ ታማ ኤꬂ፥ አꬊ ኤቂ ካዣነ። ጴጥሮሳን ኡንታራ ኤቂ ታማ ካዣነ። ");
INSERT INTO oyde_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","የ ዎደ ካህኑንꬅ Ꮉላቅዘ የሱሳ፥ ኤ ታማሩንꬅ ባዝን ኤ ትምርትትባዝ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","የሱሳ ማህ፥ «ታ አስ ኡባስ ቆንጭዝ ኦህዳ። ታ አይሁደ ኡቡንꬅስ ሺቅዘ አይሁደ ዎሳ ኬꬃን ጾዘ ኬꬃ ኡባ ዎደ ታማርስዳ። አቺ አኮን ኦህካያ። ");
INSERT INTO oyde_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ዬዝን፥ ነ ታና አኮስ ኦጨ? ታ ኦሆደራ ስእደ አሱንꬃና ኦጮ። የንꬅ አሱንꬅ ታ ኦህዳኖ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","የሱሳ ይኖ ኦህዘ ዎደ ይና በስተ ኤቅደ ዛበ ናግዙንꬃፓ ፈተ የሱሳ ባቂ፥ «ካህኑንꬅ Ꮉላቃጎ ያጋእ ማህነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","የሱሳ ማህ፥ «ታ ኢታ ባዝ ኦህደባዝ ማቅኮ Ꮉነ የዘ አስ ኡባ ቲኖ ማርክꬎ። የዝን ታ ቱሮ ኦህደባዝ ማቅኮ ታና አኮስ ባቀ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ይኒ ግሾ፥ ሐና፥ የሱሳ አጭንቲ የዝን ካህኑንꬅ Ꮉላቅዘ ቃያፋጎ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ጴጥሮሳ እዘ ኤቂ፥ ታማ ካሻደራ፥ Ꮉንኩንꬅ ኤጎ፥ «ነ Ꮉይ አꬄ ታማሩንꬃፓ ፈታ ባነ?» ያጋይዳ። ጴጥሮሳ ማህ፥ «አደ፥ ታና ባያ» ያጋእ ካድዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ካህኑንꬅ Ꮉላቅዘ አሩንꬃፓ ፈተ፥ ጴጥሮሳ Ꮉየ ጋችደ አꬄስ እግንዘ፥ ጴጥሮሳጎ፥ «ታ ነና ኤራ አታክልተ ግዳ ብእካ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጴጥሮሳ ማህን ካድዳ። ኢራ ሉኩለ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ዎንታ ጎዳ፥ ኡን የሱሳ ቃያፋ ካራፓ ሮመ ጋደ አህዘ ኦቻ ኬꬃ ካንግዳ። አይሁዱንꬅ ፋስጋ ባአለ ካꬃ ማአደስ ፋና ቱንዛመ ጋር ካትዘ ኦቻ ኬꬃ ገልካያ። ");
INSERT INTO oyde_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ይኒ ግሾ፥ ጵላጦሳ ኡንታጎ ባለ ኬዚ፥ «Ꮉይ አꬃ አኮስ ሞተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ኡን፥ «ኤ ኢታ ኦቾሳኮ ኑኒ ኤዛ ኔጎ ኬአማ የሻ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ጵላጦሳ ማህ፥ «ይን ኤዛ ኤኪ ካንግ፥ ይን ህግታ ጋዛን ጋራ ኤላ ፍርዶተ» ያጋይዳ። አይሁዱንꬅ፥ «ኦደላን Ꮉይቆ ፍርዳ ፍርድዘ አደትꬅ ዎልቃ ኑስ ባያ» ያጋይዳ፤ ");
INSERT INTO oyde_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ይና ይእዳና የሱሳ አኮ ጋር Ꮉይቆ Ꮉይቆድ የዛኮ ኤርሶደስ ኦህዳና ፎልንቶደስ። ");
INSERT INTO oyde_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ጵላጦሳ ፋ ኦቻ ኬꬃ ማህ ገሊ፥ የሱሳ ጼጊ፥ «ነ አይሁደ ካቶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","የሱሳ ጵላጦሳጎ፥ «Ꮉና ኦጭቶ ነ ኔፓ ኦጫነነ ዎይ መለ አስ ኔስ ታ ባዝ ኦህዳ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ጵላጦሳ ማህ፥ «ታ አይሁደ አሶ? ነ አሱንꬅን ካህኑንꬅ Ꮉላቁንꬅ ነና ታስ አꬂ እንግዳ። ነ አኮ ኦችዶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","የሱሳ፥ «ታ ካእቱምታ Ꮉና አላምትፓ ባያ። Ꮉንፓ ማቅዛኮ ታ አይሁዱንꬅ Ꮉላቁንꬅስ አꬊ እንግንታመ ፋና ታስ ኦችዙንꬅ ኦልንቶድየሻ። የዝን ታ ካእቱምታ Ꮉና አላምትፕ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ይኒ ግሾ፥ ጵላጦሳ የሱሳጎ፥ «ዬዝን፥ ነ ካት ባ?» ያጋእ ኦጭዳ። የሱሳ ማህ፥ «ታ ካት ማቅዳኖ ነ ጋይዳ። ታኒ የልንትዳናን Ꮉና አላምተ ይእዳና ቱረትꬅስ ማርክꬋደስ። ቱርፓ ማቅደ ኦደን ታ ጋዛኖ ስእነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ጵላጦሳ፥ «ቱሪ አኮ?» ያጋይዳ። ጵላጦሳ ይኖ ጋይዳንፓ ማቂ አይሁዱንꬃጎ ባለ ኬዚ፥ «ታኒ ኤዛ ሞትዘ ባላ ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","የዝን ፋስጋ ባአለ ኦደ፥ ፈቲ አስ ይንትስ አቻፓ ብልዘ ዎጋ የነ። ታ ይንትስ አይሁዱንꬅ ካትዛ ብሎደ ጋር ኮያነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ኡን ማህ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ባርባና ብሎፕ አትን ኤዛ ብልፐ» ያጋይዳ። የዝን ባርባነ ፋኖ። ");
INSERT INTO oyde_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ይንፓ ሱባ፥ ጵላጦሳ የሱሳ ካንግ ጋራፍስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ዎታዳሩንꬅ አንጋꬅ ባርኔጻ መꬊ ኤ ኦምተ ጋድዳ። ማህ ዞቆ ማኦ ኤዛ ማእስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ኤጎ ይእተራ፥ «አይሁደ ካትዛዮ፥ ሳሮ ኔስ ማቀ» ያጋእ ኤዛ ባቂዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ጵላጦሳ ማህ ባለ ኬዚ፥ አይሁዱንꬃጎ፥ «ይኬ፥ ታኒ ኤፓ አኮ ኢታባዝን ደንግካይዛኖ ይን ኤሮደ ጋር ኤዛ ይንታጎ ባለ ከሶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ይንፓ ማቂ፥ የሱሳ አንጋꬅ ባርኔጻ ፋ ኦምተ ጋዲ፥ ዞቆ ማኦ ማእ፥ ባለ ከዝዳ። ጵላጦሳ አይሁዱንꬃጎ፥ «አꬃ Ꮉያ ቦኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ካህኑንꬅ Ꮉላቁንꬅን ጾዘ ኬꬅቶ ናግዙንꬅ ኤዛ ብእደ ዎደ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ማስቃላላ ሱጾ! ሱጾ!» ያጋይዳ። ጵላጦሳ ኡንታጎ፥ «ይን ኤዛ ካንግ፥ ማስቃላላ ሱጾ። ታ ኤፓ አኮ ኢታባዝን ደንግካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","አይሁዱንꬅ ማህ፥ «ኑስ ህገ የነ። ኤ ፋና ጾዘ ናአ ማህደ ግሾ ኑ ህግትጋራ ኤ Ꮉይቆደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ጵላጦሳ ይኖ ስእደ ዎደ ቲኖንፓ ጋማ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ማህን ጵላጦሳ ፋ ኦቻ ኬꬅተ ማቂ ገሊ የሱሳጎ፥ «ነ አባፓ ይእዶ?» ያጋእ ኦጭዳ። የዝን የሱሳ ኤስ አኮን ማህካያ። ");
INSERT INTO oyde_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ይኒ ግሾ፥ ጵላጦሳ፥ «ታስ ኦሆሶ? ነና ብሎደስ ዎይ ማስቃላላ ሱጾደስ ታስ አደትꬅ ዎልቃ የዛኖ ኤሮሶ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","የሱሳ፥ «ጾዚ ኔስ አደትꬅ ዎልቃ እንግካይዛኮ ታላ አደትꬅ ዎልቃ ኔስ የዛማየሻ። ይኒ ግሾ፥ ታና ኔስ አꬂ እንግደ አꬍዘ ናጋራ ኦችዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ጵላጦሳ ይኖ ስኤዘ ዎደ የሱሳ ብሎደስ ኦገ ኮይዳ። የዝን አይሁዱንꬅ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ነ ኤዛ ብልዘባዝ ማቅኮ ካት ቄሳረ ነ ባጋ ባያ። ፋና ካት ጋዘ ኦደን ቄሳረ እጽዛያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ጵላጦሳ ይኖ ስእ የሱሳ ባለ ከስዳ። የይዝ፥ «ሎቼ ሹች» ጋዘ በሳ ፍርዳ ኦይዳላ በትዳ። እብራይስጠ ቃላራ ይና በስታ «ገበታ» ጋእንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ይና ቃምታ ፋስጋ ባአለ ቦንቾደስ ጊግዘ ዎደ። የ ዎደ ሳእታን አዋራፓ እዝፑን ሳተ ጋር። ጵላጦሳ አይሁዱንꬃጎ፥ «ይን ካት Ꮉያ ቦኦተ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","አይሁዱንꬅ ፋ ቃልቶ ꬎቅ ዪዚ፥ «Ꮉሶ! Ꮉሶ! ማስቃላላ ሱጾ» ያጋይዳ። ጵላጦሳ ማህ፥ «ይን ካትዛ ታ ማስቃላላ ሱጾዳኖ ኮያነ?» ያጋእ ኦጭዳ። ካህኑንꬅ Ꮉላቁንꬅ፥ «ቄሳረፓ መለ ካት ኑስ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ይንፓ ማቂ፥ ኡን የሱሳ ማስቃላላ ሱጾደ ፋና ጵላጦሳ ኡንትስ አꬂ እንግዳ። ኡን የሱሳ አይኪ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","የሱሳ ፋ ማስቃልዛ ቶኪ፥ «የራስ ቅል» ጋዘ በሳ ከዝዳ። «የራስ ቅል» ጋእንትዛና እብራይስጠ ቃላራ «ጎልጎታ» ጋእንታነ። ");
INSERT INTO oyde_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ኡን ይና በስተ ማስቃላላ የሱሳ ሱጽዳ። ማህን ኤራ መለ ላምእ አሱንꬃና፥ ፈታ ሰኮ ዛላራ Ꮉንካያ Ꮉንካ ዛላራ ማስቃላላ ሱጽዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ጵላጦሳ፥ «አይሁዱንꬅ ካት፥ ናዝረተ የሱሳ» ያጋዘ ጹፈ ጻፊ ማስቃላላ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","የሱሳ ማስቃላላ ሱጹንትደ በስታ ካታማስ ካለ የዘ ግሾ ጋማ አይሁዱንꬅ ይና ጹፍቶ ናባብዳ። ጹፍዘ ጻፍንትዳና እብራይስጠ ዶናራ፥ ላትነ ዶናራን ግርኬ ዶናራ። ");
INSERT INTO oyde_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ይኒ ግሾ፥ ካህኑንꬅ Ꮉላቁንꬅ ጵላጦሳጎ፥ « ‹Ꮉይ አꬄ ፋና አይሁደ ካት ጋይዳን ጋር› ጋእ ጻፎፕ አትን ኤዛ ኤ ኦምተ ‹አይሁደ ካት› ጋእ ጻፍፐ ያጋይዳ።» ");
INSERT INTO oyde_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ዬዝን፥ ጵላጦሳ፥ «ታኒ ጻፍዳኖ ጻፍዳ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ዎታዳሩንꬅ ማስቃላላ ኤዛ ሱጽዳንፓ ሱባ ኤ ማእቶ ኤኪ፥ ኦይዲ በሳ ሻኪ፥ ፈቶ ፈቶ ኤክዳ። ዳክꬅ ማእንትዘ ጳርጎ ማኦ የሻ። ");
INSERT INTO oyde_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ዎታዳሩንꬅ፥ «ኦና የሎድየዛኮ፥ እጻ ኦልዳፕ አትን ማእዛ ፈርኦስ» ያጋይዳ። ይና Ꮉንዳና ጌሽ ማጻፍተ፥ «ታ ማእቶ ግዥንት ኤክዳ፤ ታ ጳርጎ ማእዘላን እጻ ኦልዳ» ጋይንትዳና ፎልንቶደ ጋር። ይኒ ግሾ፥ ዎታዳሩንꬅ ይኖ ዪዝዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","የዝን የሱሳ ማስቃላ ካለ ኤ እንታን፥ ኤ እንቲ ምሽታ፥ ቀልዮጳ ማችታ ማይራምራን ማግደላ ማይራማ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","የሱሳ ፋ እንቶን ኤ ካዽዘ ታማርዘ እዘ ኤቅዱንꬃና ብእ፥ ፋ እንትጎ፥ «ታ እንተ፥ ነ ናአያ Ꮉያ ቦኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ይንፓ ሱባ፥ የ ታማርዘጎ፥ «ነ እንቶ Ꮉኖ ቦኦ» ያጋይዳ። የ ታማርዘ እዞ ይና ዎድትፓ አይኪ ፋራ የሳደ ጋር ካራ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ይንፓ ሱባ፥ የሱሳ ኡባና Ꮉተ ፎልንትዳኖ ኤሪ፥ ጌሽ ማጻፍተ ጻፍንትዳና ፎልንቶደ ጋር «ታና ባርዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ይና በስተ ፈቲ ጎንቦ ኩሙꬅ ጫላ ዎይነ የነ። ኡን ፉዛ ይና ዎይንተ ዳኪ፥ ህሶጰ ምንጻ በርꬃ ጋዲ፥ የሱሳ ዶናጎ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","የሱሳ ዎይንዛ ቃማስ ብእ፥ «ፍኦልንትዳ» ያጋይዳ። ይንፓ ሱባ፥ ፋ ኦምቶ ሶጾር ዪዚ ፋ ሸምፕቶ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ይና ቃምታ ጊግንትዘ ቃማ ማቅደ ግሾን ዎንትዘ ቃምዘ ቦንቾ ሳምባታ ማቅደ ግሾ አሱንꬃና አህታ ማስቃላላ ሳምባታ ዎደ ፌዣመ ጋር ኡን ቡንቅቶ መንꬂ፥ ማስቃላፓ ኬꬆደ ጋር አይሁዱንꬅ ጵላጦሳ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ይኒ ግሾ፥ ዎታዳሩንꬅ Ꮉንግ፥ የሱሳራ ሱጹንትደ ላምእ አሱንꬅስ ቡንቅቶ መንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","የዝን የሱሳጎ ይእደ ዎደ ኤ Ꮉይቂዳኖ ብእ፥ ኤ ቡንቅቶ መንꬅካያ። ");
INSERT INTO oyde_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","የዝን ዎታዳሩንꬃፓ ፈተ ኤ ምልተ ቶራራ ጫድን ኢራ ሱꬅን Ꮉꬅን ጎግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ይኖ አማኖደ ፋና ይኖ ብእደ ማርክꬍዳ። ኤ ማርካትꬅታን ቱሮ። ማህ ኤ Ꮉንዳና ቱሮ ማቅዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ይና Ꮉንዳና ጌሽ ማጻፍተ፥ «ኤ መቃꬅትፓ ፈትን መቆስ» ጋይዳና ፎልንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ማህን ጌሽ ማጻፍተ መለ በሳ፥ «ኡን ፋ ጫድዳኖ ቦኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ይንፓ ሱባ፥ አርማትያሳ ካታማፓ ይእደ ዮሰፋ የሱሳ አህቶ ኤኮደስ ጵላጦሳ ዎስዳ። ዮሰፋ አይሁዱንꬅስ ዣሽትደ ግሾ አችንት የሱሳ ካልዛያ። ጵላጦሳ፥ «ኤኮ» ያጋይዳ። ይኒ ግሾ፥ ዮሰፋ Ꮉንግ የሱሳ አህቶ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ማህ ንቆድሞሳ፥ Ꮉንፓ ቲኖ የሱሳጎ ቃማ ይእዳይ፥ ካርበራን አርክንተራን ዎርቂንትደ Ꮉስታም ፈቲ ክሎ ጊራመ ማቃደ ሽቶ ኤኪ ዮሰፋራ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","የንꬅ ላምእ አሱንꬅ የሱሳ አህቶ ኤኪ፥ አይሁዱንꬅ አሀ ዚꬍዘ ዎጋራ፥ ሽቶራ፥ ሞግዘ አፉላራ ጻጽዳ። ");
INSERT INTO oyde_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","የሱሳ ማስቃላላ ሱጹንትደ በስተ ጋማ አታክልተ የነ። ይና አታክልትት ግዳ ሹቻፓ ዎጪ ጊግዝደ Ꮉጋ ኦደን ሞግንትካይዘ ክለ ቦዛ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","የ ዎምእዘ ካለ የዘ ግሾን አይሁዱንꬅ ሳምባታስ ጊግንትዘ ዎደ ማቅደ ግሾ የሱሳ አህቶ እዘ ሞግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ዎጋ ኦደ ዎንታ Ꮉጋ ሳአ ጌዥካይዝን፥ ማግደላ ማይራማ፥ የሱሳ ሞግንትደ ቦዛ Ꮉንግ ሹችታ ቦዛ ዶንትፓ ደንድዳኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ስሞን ጴጥሮሳጎን የሱሳ ካዽዘ Ꮉንካይ ታማርዘጎ ዎጺ Ꮉንግ፥ «ቦዝትፓ ላꬃ ኤክዳ፤ ኤዛ አባ ጋደዛኮ ኑ ኤሮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ይኒ ግሾ፥ ጴጥሮሳን Ꮉንካይ ታማርዘ ኬዚ ዎጽተራ ቦዛ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ላምኡንꬅን ፈትላ ዎጽዳ፥ የዝን Ꮉንካይ ታማርዘ ጴጥሮሳፓ አꬊ ቲኖ ቦዝተ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","የ ታማርዘ ዙጊ፥ ኤዛ ጻጽደ አፉልቶ ብእዳ፥ የዝን ቦዝት ግዳ ዎꬍካያ። ");
INSERT INTO oyde_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ስሞን ጴጥሮሳ ኤዛ ካሊ ይእ፥ ቦዝት ግዳ ዎꬊ ኤዛ ጻጽደ አፉልታ እዘ የዛኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ማህ የሱሳ ኦምቶ ጻጽደ አፉላ ጻጽንት ቦዝተ ኦማ ጉሮ የዝን ብእዳ። የ አፉልዘ ዱማ በሳ የነፕ አትን ቦዛ አፉላራ ዎላ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","የ ዎደ ቲኒ ቦዝተ የልደ Ꮉንካይ ታማርዘ ገሊ ብእ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","የሱሳ Ꮉይቆፓ ደንዶደስ ቤዛኖ ኦህዘ ጌሽ ማጻፈ የዘ ቃልቶ ኡን Ꮉጋ ቲርካያ። ");
INSERT INTO oyde_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ይንፓ ሱባ፥ ኤ ታማሩንꬅ ፋ ካራ ማቂ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","የዝን ማይራማ ይና ቦዝት ዶንተ ኤቂ ዬክተራ ዙጊ ቦዝቶ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ቦꬅ ማኦ ማእደ ላምእ ኪታንቹንꬅ የሱሳ አህታ ዎይእደ በስተ ፈተ ኦማ ጉሮራ ፈተ ቶሄ ጉሮ በቴዝን ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ኡን ኢጎ፥ «ማችተ፥ አኮስ ዬከ?» ያጋእ ኦጭዳ። እዛ፥ «ኡን ታ ላꬃ ኤክዳ፤ ኡን አባ ጋደዛኮ ታ ኤሮስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ይኖ ጋይዳንፓ ሱባ፥ እዛ ሱብ ማቂ በእዘ ዎደ የሱሳ እዘ ኤቀዝን ብእዳ። የዝን ኤ የሱሳ ማቅዳኖ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","የሱሳ ኢጎ፥ «ማችተ፥ አኮስ ዬከ? ኦና ኮየ?» ያጋእ ኦጭዳ። ማይራማ አታክልተ ኦችዘ አስ አዝን፥ «ላꬆ፥ ነ ኤከዛኮ፥ ኤዛ አባ ጋደዛኮ ታስ ኦሆያ። ታ ኤዛ ኤኮዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","የሱሳ ኢጎ፥ «ማይራመ» ያጋይዳ። እዛ ኤጎ ማቅን፥ እብራይስጠ ዶናራ «ረቡኒ» ያጋይዳ። ብልꬅታን «አስታማርዛዮ» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","የሱሳ ኢጎ፥ «ታ Ꮉጋ ታ አደጎ ከዝካይዘ ግሾ ታና አይክፐ። የዝን ታ እሹንꬃናን Ꮉንግ፥ ‹ታኒ ታ አደጎን ይን አደጎ፥ ታ ጾዘጎን ይን ጾዘጎ፥ ኬሳዳ ጋይዳ› ጋእ ኡንትስ ኦሆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ማግደላ ማይራማ ላꬃ ብእዳኖን ኢስ ኤ ኦህዳኖ Ꮉንግ ኤ ታማሩንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ዎጋ ኦደ ኡጉረ፥ ኤ ታማሩንꬅ አይሁዱንꬅስ ዣሽቲ ፉርꬅቶ ጎርዲ ሺቂ በቴዝን፥ የሱሳ ይእ፥ ኡን ግዳ ኤቂ፥ «ሳሮ ይንትስ ማቀ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ይኖ ጋእ ማቂ ፋ ኩሽቶን ፋ ምልቶ ኡንታና ቤዝዳ። ኤ ታማሩንꬅ ላꬃ ብእደ ዎደ ጋማ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","የሱሳ ማህ ኡንታጎ፥ «ሳሮ ይንትስ ማቀ፤ ታ አዳይ ታና ኪትዳንጋራ ታንን ይንታና ኪቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ይኖ ጋእዳንፓ ሱባ፥ ኡንታላ ኡፍ ጋእ ፉግዳ። ማህ፥ «ጌሽ አያና ኤኮተ። ");
INSERT INTO oyde_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ይን አቶ ጋይደ አስ ናጋርታ አቶ ጋእንቶዳ። ይን አቶ ጋይካይዘ ናጋርታ አቶ ጋይንቶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","የዝን ታጶ ላምእ ታማሩንꬃፓ ፈተ፥ ዲዲሞሳ ጋእንትዘ ቶማሳ፥ የሱሳ የእዘ ዎደ ኡንታራ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ይኒ ግሾ፥ Ꮉንኮ ኤ ታማሩንꬅ ቶማሳጎ፥ «ኑኒ ላꬃ ብእዳ» ያጋይዳ። የዝን ቶማሳ ኡንታጎ፥ «ምስማረራ ኤ ጫድንትደ ኤ ኩሽተ የዘ ቤቶ ብእካይዛራ ይና ቤቶ ታ ግልአራ ቦችካይዛራ፥ ማህ ታ ኩሽቶ ኤ ምልተ ዳኪ ብእካይዛራ አማኖስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ኦስፉን ቃማፓ ሱባ፥ የሱሳ ታማሩንꬅ ማህ ኬꬃ ሺቂ በትዳ፤ ቶማሳን ኡንታራ የሻ። ፉርꬅታ ጎርድንቲ የዝን የሱሳ ይእ፥ ኡን ግዳ ኤቂ፥ «ሳሮ ይንትስ ማቀ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ይንፓ ሱባ፥ የሱሳ ቶማሳጎ፥ «ታ ኩሽቶ ነ ግልእትራ ቦቺ ቦኦ። ማህ ነ ኩሽቶ ታ ምልተ ዳኪ ቦኦ፤ ሶእፐ፥ አማኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶማሳ ማህ፥ «ታ ላꬃዮ፥ ታ ጾዛዮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ዬዝን የሱሳ፥ «ነ ታና ብእደ ግሾ አማንዳ፥ የዝን ብእካይዛራ አማንዱንꬂ አንጅንትዱንꬃና» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","የሱሳ ማጻፍተ ጻፍንትካይዘ መለ ጋማ ክሌ ባዝ ፋ ታማሩንꬅ ቲንተ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","የዝን የሱሳ ኤ ክርስቶሳ፥ ጾዘ ናአ ማቅዛኖ ይን አማኖደ ጋራን አማኒ ኤ ሱንꬅተ ደኦ ደንጎደ ጋር Ꮉና ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ይንፓ ሱባ፥ የሱሳ ጽባርዮሳ አባ ካለ ፋ ታማሩንꬅስ ማህ ቆንጭዳ። ኤ ኡንትስ Ꮉንፓ ካሊ የዘ Ꮉኖትꬃር ቆንጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ስሞን ጴጥሮሳ፥ ዲዲሞሳ ጋእንትዘ ቶማሳ፥ ቃና ጋልላፓ ይእደ ናትናኤላ፥ ዛብዶሳ ናኡንꬅን የሱሳ ታማሩንꬃፓ መለ ላምኡንꬅ ዎላ የነ። ");
INSERT INTO oyde_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ስሞን ጴጥሮሳ ኡንታጎ፥ «ታ ሞሎ አይኮደስ ቅታነ» ያጋይዳ። ኡን፥ «ኑንን ኔራ Ꮉማዳ» ያጋእ፥ ጎንገ ግዳ ገልዳ። የዝን ኡን ይና ቃምተ አኮ ሞሎን አይክካያ። ");
INSERT INTO oyde_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ዎንታ ጎዳ ጻልቀ ኬሳዳንፓ ቲኖ፥ የሱሳ አባ ጋጻ ኤቅዳ፥ የዝን ኤ ታማሩንꬅ የሱሳ ማቅዳኖ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","የሱሳ ኡንታጎ፥ «ናኡንꬆ፥ አኮ ሙእዘ ባዝ የነ?» ጋይዳ። ኡን ማህ፥ «አኮን ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ኤ ማህ፥ «ይን ሞሎ አይክዘ ግተ ጎንግዘፓ ምዛቅ ዛላራ ኦሎተ፤ ሞሎ ይን አይኮዳ» ያጋይዳ። ይኒ ግሾ፥ ሞሎ አይክዘ ግቶ ምዛቅ ዛላራ ኦልዳ። ሞሎ ገሊ ኩምደ ግሾ ጎቺ ኬሶደስ ጋምዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","የሱሳ ካዽዘ ታማርዘ ጴጥሮሳጎ፥ «Ꮉይኒ ላꬂ!» ያጋይዳ። ስሞን ጴጥሮሳ ኤ ላꬂ ማቅዳኖ ስእደ ዎደ ጋሪ ጋድደ ፋ ማእቶ ማእ አባ ግዳ ዶሊ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","የዝን ጎንግተ አትደ Ꮉንኮ ታማሩንꬅ ሞሎ ኩምደ ግቶ ጎቺ፥ አባፓ ጋጻ ከዝዳ። ኡን አባፓ ላምእ ጼት Ꮉꬋ ፋና Ꮉክዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ኡን አባፓ ጋጻ ከዝደ ዎደ ኬንቼሎ ታማ ቃቃ፥ ሞሎን ቦራን ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","የሱሳ ኡንታጎ፥ «Ꮉተ ይን አይክደ ሞልትፓ አነ ታስ ኮኦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ስሞን ጴጥሮሳ ጎንግተ ገሊ፥ ጼት እችንታም Ꮉይꬕ ዳማ ሞሎ አይክደ ግቶ ጎቺ አባፓ ጋጻ ከስዳ። ሞልታ ይኒ ጋር ጋማ ማቅኮን ሞሎ አይክደ ግቶ ፈርእካያ። ");
INSERT INTO oyde_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","የሱሳ ኡንታጎ፥ «Ꮉንካ ይእ ዳይጸ ሞኦተ» ያጋይዳ። ኤ ላꬂ ማቅዳኖ ኡን ኤርደ ግሾ ኤ ታማሩንꬃፓ ፈትን፥ «ነ ኦደ?» ጋእ ኤዛ ኦጮደስ ሚንግደ ባያ። ");
INSERT INTO oyde_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","የሱሳ ይእ፥ ቦራ ኤኪ ኡንትስ እንግዳ፤ ሞሎፓን ይኒ ጋራ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","የሱሳ Ꮉይቆፓ ደንዲ ፋ ታማሩንꬅስ በንትደ Ꮉንራ Ꮉይꬓንꬆ። ");
INSERT INTO oyde_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ኡን ዳይጽቶ ሙእዳንፓ ሱባ፥ የሱሳ ስሞን ጴጥሮሳጎ፥ «ዮና ናአ ስሞና፥ ታና Ꮉንሳፓ አꬂ ካꬋነ?» ያጋይዳ። ስሞን ጴጥሮሳ፥ «ዬ ላꬆ፥ ታ ነና ካꬍዛኖ ነ ኤራነ» ያጋይዳ። የሱሳ ኤጎ፥ «ታ ꬋንግዘ ዱሮ ናኡንꬃና ዬንጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","የሱሳ ላምእንꬃ፥ «ዮና ናአ ስሞና፥ ታና ካꬋነ?» ያጋይዳ። ስሞን ጴጥሮሳ፥ «ዬ ላꬆ፥ ታ ነና ካꬍዛኖ ነ ኤራነ» ያጋይዳ። የሱሳ፥ «ታ ዱሩንꬃና ዬንጎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","የሱሳ Ꮉይꬓንꬆ፥ «ዮና ናአ ስሞና፥ ታና ካꬋነ?» ያጋይዳ። የሱሳ Ꮉይꬓንꬆ ስሞን ጴጥሮሳጎ፥ «ታና ካꬋነ?» ያጋእ ኦጭደ ግሾ ጴጥሮሳ አዛኒ፥ «ላꬆ፥ ነ ኡባባዝቶ ኤራነ፤ ታ ነና ካꬍዛኖ ነ ኤራነ» ያጋይዳ። የሱሳ፥ «ታ ዱሩንꬃና ዬንጎ። ");
INSERT INTO oyde_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ታ ኔስ ቱሮ ቱሮ ጋነ፤ ነ ናአትꬃ የዘ ዎደ ነነስ ማእ፥ ነ ኮይዘ በሳ ቅታነ። የዝን ነ ጭንግደ ዎደ ነ ኩሽቶ ምጪ ቤሳዳ። መለ አስ ዳንጭሳዳ፤ ነ ካꬎኦሰ በሳ ካንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","የሱሳ ይኖ ጴጥሮሳ አኮ ጋር Ꮉይቆ Ꮉይቂ፥ ጾዛ ቦንችሳድ የዛኮ ቤሳደስ ጋይዳ። ይኖ ጋይዳንፓ ሱባ፥ የሱሳ ጴጥሮሳጎ፥ «ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጴጥሮሳ ሱባ ማቂ፥ የሱሳ ካዽዘ ታማርዘ ፋፓ ሱባራ የእዛኖ ብእዳ። የ ታማርዘ፥ ካዎ ሙእዘ በሳ የሱሳጎ ሺቂ፥ «ላꬆ፥ ነና አꬂ እማደ ኦደ?» ጋይዳያ። ");
INSERT INTO oyde_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጴጥሮሳ የ ታማርዛ ብእ፥ «ላꬆ፥ Ꮉይ አꬄ ዋያደ?» ያጋእ የሱሳ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","የሱሳ ኤጎ፥ «ታ የኦደ ዎንꬅስ ኤ ሸምፖራ የሳደ ጋር ታ ኮይኮ፥ ነና አኮ ማ? ነ ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ይኒ ግሾ፥ የ ታማርዘ Ꮉይቆስ ጋዘ ኦሄ እሹንꬃና ኡባ የልዳ። የዝን የሱሳ፥ «ታ የኦደ ዎንꬅስ፥ ኤ ሸምፖራ የሳደ ጋር ታ ኮይኮ ነና አኮ ማ?» ጋይዳፕ አትን «Ꮉይቆስ» ጋይካያ። ");
INSERT INTO oyde_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ꮉና ኦህት ባዝ ማርክꬍዳይን Ꮉኖ ጻፍደ የ ታማርዘ ኤዛ። ኤ ማርካትꬅታን ቱሮ ማቅዳኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","የሱሳ ኦችደ መለ ጋማ ባዝ የነ። ታ ቆፕን፥ ኡባ ባዝ ፈተ ፈተ ኦማራ ጻፍንትዛኮ፥ ጻፍንትዘ ማጻፍትስ አላመ ጋዶደስ በሲ ማቃዳ አዞስ። ");
INSERT INTO oyde_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","ተዎፍሎሳ፥ የሱሳ ፋ ኦችቶ አይክደ ዎደፓ ሳሎ ቅቶደ ዎደ የሎደስ፥ ኦችዳኖን ታማርስዳኖን ኡባ ታኒ ታ ቲኖ ማጻፍተ ጻፍዳ። ሳሎ ኬሳዳንፓ ቲኖ ኤ ፋ ዶርደ ሐዋሩንꬃና ጌሽ አያናራ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ኤ ፋ ማꬍትፕ ሱባ Ꮉይቆፓ ደንድዳኖ ደኦ ማቂ ኡንትስ ፋና ቤዝዳ። ኦይታም ቃማ ኡንትስ በንቲ ጾዘ ካእቱሞ ኡንታና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ፈቲ ኦደ ኡንታራ ዎላ ሙእተራ ኡንታና Ꮉንጋር ጋእ ኪትዳ፦ «ታ ይንትስ ኦህደ፥ ታ አዳይ እንጎዳ ጋይደ ኡፋይስ ቃልቶ ናጎተፕ አትን የሩሳላመፓ ኬዝፐተ። ");
INSERT INTO oyde_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","አኮስ ጋይኮ፥ ዋሐንሳ Ꮉꬃራ ጻማቅዳ፥ የዝን ኤራꬅ ዎደፓ ሱባ ጌሽ አያናራ ይን ጻማቅንቶዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ኡንትን ዎላ ሺቅደ ዎደ፥ «ላꬆ፥ እስራኤሉንꬅስ ካእቱምቶ ነ ማሆደ ዎድታ Ꮉኖ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","የሱሳ ኡንታጎ፥ «ታ አዳይ ፋ አደትꬅ ዎልቂተ ኦችዘ ዎድቶን በርቶን ይን ኤሮደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","የዝን ጌሽ አያና ይንታላ ዎꬍደ ዎደ ይን ዎልቃ ኤኮዳ። የይዝ ማቂ፥ የሩሳላመ፥ ይሁዳ ሳአ ኡባ፥ ሳማራን ሳአ ጋጻ የሎደስ ይን ታስ ማርካ ማቃዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ይኖ ጋይዳንፕ ማቂ ኡን በእዝን፥ ꬎቅ ꬎቅ ጋእ፥ ሳሎ ከዝን ꬎነ ኤዛ ኡን ኣፍትፓ ጌንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","የሱሳ ቅቶደራ ኡን ሳሎ ማህ በአደራ፥ ቦꬅ ማኦ ማእደ ላምእ አሱንꬅ ቲርካይዝን ኡን ካለ ኤቂ፥ ");
INSERT INTO oyde_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«ጋልላ አሱንꬆ፥ ሳሎ ብእተራ፥ ይን አኮስ ኤቅዶተ? Ꮉይ ይን በእዝን ሳሎ ቅትደ የሱሳ ይኒ ፋና ማቂ የኦዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ይንፓ ማቂ፥ ሐዋሩንꬅ ሻማሄ ደርዘፓ የሩሳላመ ማቅዳ። ሻማሄ ደርዘ የሩሳላመስ ፈቲ ክሎ መትረ ፋና የነ። ");
INSERT INTO oyde_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ኡን የሩሳላመ ገሊ፥ ፋ የዘ ፎቀ ኬꬅትላ ከዝዳ። ኡንትን፦ ጴጥሮሳ፥ ዋሐንሳ፥ ያይቆባ፥ እንድራሰ፥ ፍልጶሳ፥ ቶማሳ፥ ባርቶሎምዮሳ፥ ማቶሳ፥ እልፍዮሳ ናአ ያይቆባ፥ ፋ ሳእትስ ይቅስንትዘ ስሞናራ ያይቆባ ናአ ይሁዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ꮉንስ ኡቡንꬅ ማቹንꬃራ፥ የሱሳ እንታ ማይራምራን የሱሳ እሹንꬃራን ኡባ ፈቲ ዎዝና ማቂ ምንꬂ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","የ ዎደ ጴጥሮሳ ጼት ላምእታም ማቃደ አማንዘ አሱንꬅ ሺቅደ በስተ ደንዲ ኤቂ፥ Ꮉንጋር ጋይዳ፦ ");
INSERT INTO oyde_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«አሱንꬆ፥ የሱሳ አይክዱንꬃና ካልꬅደ ይሁዳባዝ ጌሽ አያና ቲኖ ዳዉተ ዶንተ ኦህደ ጾዘ ቃልታ ፎልንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ይሁዳ ኑራ ዎላ Ꮉና ኦችቶ ኦቾደስ ዶርንትደ አስ።» ");
INSERT INTO oyde_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","የዝን ይሁዳ ፋ ገነ ኦችትራ ደንግደ ሚሸራ ጋደ ዎንግዳ። ኤ ቲኖር ጉጱንቲ ጎልእን፥ ኤ ሳዝታ ፌꬍንትዳ፤ ኤ መርቅታ ዉልእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ይሁዳላ አፋ Ꮉንዳኖ የሩሳላመ የዘ አስ ኡቡንꬅ ስእዳ። ይኒ ግሾ፥ ይና ሳእቶ ፋ ዶናራ አኬልዳማ (ሱꬅ ጋደ) ጋእ ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«ይናን ማዝሙረ ማጻፍተ፥ «ኤ ኬꬅታ Ꮉሪ አቶ፤ ኦደን እዘ የዝፐ። ማህ ‹ኤ ሹማትꬅቶ መለ ኤኮ› ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«ይኒ ግሾ፥ ላꬄ የሱሳ ኑ ግዳ ዉቲ Ꮉንትደ ዎደ ኡባ ኑራ የዙንꬃፓ፥ ");
INSERT INTO oyde_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ማህ ጻማቅዘ ዋሐንሳ ዎድትፓ አይኪ ላꬄ የሱሳ ሳሎ ከዝደ ዎደ የሎደስ ኑራ የዙንꬃፓ ፈቲ አስ ኤ ደንድትስ ኑራ ማርካ ማቃደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ይኒ ግሾ፥ አሱንꬅ ዶርትስ ኢዮስጦሳ ጋዘ ባርሳባሳ ጋእንትዘ ዮሴፋን ማትያሳ ላምኡንꬃና ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ይንፓ ሱባ፥ ጾዝ ዎስተራ፥ «አስ ኡባ ዎዝና ኤርዘ ላꬆ፥ Ꮉንꬅ ላምኡንꬃፓ ነ ኦና ዶረዛኮ ኑና ቤዞ። ");
INSERT INTO oyde_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ይሁዳ ፋ በሳ ቅቲ፥ አሽደ ኦችተ ሐዋረትꬅ ኦቻ ኤኮደ ጋር Ꮉንሳፓ ኑስ ሻጎ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ኡንትስ እጻ ኦልዳ። እጽታን ማትያሳስ ዎꬍን ማትያሳ ታጶ ፈቲ ሐዋሩንꬃላ ጉጅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ጰንጠቆስጠ ጋዘ ቃማ የልደ ዎደ አማንዙንꬅ ኡባ ዎላ ፈቲ በሳ ሺቂ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ቆፕካይዝን ዳማ ቶኪ ኤኪ ቅቶደ ፋና የዘ ባቆ ጉሚ ሳሎፓ ይእ ኡን የዘ ኬꬅተ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ማህ ታማ ሎጸ ፋና አዝዘ ልሳኑንꬅ ኡንትስ በንትዳ፥ ሻክንት ሻክንት ኡን ኡቡንꬃላ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ኡን ኡቡንꬅ ጌሽ አያናራ ኩሚ ዱማ ዱማ ዶናራ ኦህንቶደ ፋና ጌሽ አያና ኡንትስ ኦሆደ ፋና እንግዳንጋር ኦሄ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","የ ዎደ ሳሎፓ ኦሞራ የዘ ሳአ ኡባፓ ይእደ ጾዝ ዣሽትዘ አይሁዱንꬅ የሩሳላመ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ይና ኦꬅቶ ስእደ ዎደ ጋማ አስ ሺቅዳ። አማንዘ አሱንꬅ ኡን ፋ ዶናራ ኦህንቶደራ ስእደ ግሾ ");
INSERT INTO oyde_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ጋዉደ ባዝ ꬋብን ጋማ ቆፒ፥ «Ꮉንꬅ ኦህንትዘ አሱንꬅ ኡባ ጋልላ አስ ባነ? ");
INSERT INTO oyde_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ዬዝን፥ ኑኒ፥ ኑ የልንትደ ጋደ ዶናር ኡን ኦህንቶደራ ዋይዝ ስኦደስ ዳንዳእዶ? ");
INSERT INTO oyde_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ኑኒ ጳርተ፥ ሜዶና፥ ኤላመን፥ መስጴጦምያ፥ ይሁዳ ግዳ፥ ቃጳዶቅያ፥ ጳንጾሳ፥ እስያ፥ ");
INSERT INTO oyde_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ጵርገ፥ ጵንፍለ፥ ግብጸ፥ ቃረና ካለ የዘ ሊብያ ዎራዳ የዙንꬃና። ኑፓ ባጉንꬅ ሮመፓ ይእደ አስ። ");
INSERT INTO oyde_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","አይሁዱንꬅን አይሁዱንꬅ አማኖ ገልደ አሱንꬅ፥ ቃርጼሳን አራበ አሱንꬅ፥ ጾዚ ኦችደ ዳማ ኦችቶ ኑ ዶናር ኦህንቶደራ ኑ ስእነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ኡቡንꬅ ጋማ ቆፒ፥ ጋኦደባዝ ꬋብን ዎልጎ፥ «ዪእ Ꮉኖ አኮ ጋዉደ?» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","የዝን መሉንꬅ፥ «Ꮉንስ ካጽካይዘ ዎይነ ኡዢ ማꬅንትዳ» ያጋእ ለቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","የዝን ጴጥሮሳ፥ ታጶ ፈቲ ሐዋሩንꬃራ ደንዲ ኤቂ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ ኡንታጎ Ꮉንጋራ ያጋእ ኦህዳ፦ አይሁዱንꬆ፥ የሩሳላመ የዘ ኡቡንꬆ፥ ታ ኦህዛኖ ስኦተ። ");
INSERT INTO oyde_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ዎንታፓ Ꮉይꬕ ሳተ ማቅደ ግሾ ይን ቆፕዛንጋራ Ꮉንꬅ አሱንꬅ ማꬅንትካያ፤ ይና ይን አቻ ኤርንትደባዝ ማቆ። ");
INSERT INTO oyde_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","የዝን Ꮉና Ꮉንዳና ናበ እዩኤላ ኦህዳና ፎልንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","« ‹ጾዚ፥ ዎደ ዉርሱꬅተ Ꮉንጋራ Ꮉኖዳ ያጋነ፦ ታኒ አስ ኡባላ ታ አያና ጉሶዳ። ይን ꬊራꬅ ናኡንꬅን ማች ናኡንꬅ፥ ትንቢተ ኦሆዳ። ይን ይꬉንꬅ ቆንጭꬅ በአዳ፤ ይን ጭሙንꬅ አቡኮ አቡኮዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ይና ዎድተ ታና አማንዘ ꬊራꬅ አሩንꬃላን ማች አሩንꬃላ ታ ታ አያንቶ ጉሶዳ፤ ኡን ትንቢተ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ማህ ታኒ አፋ ሳሎ ክሌ ባዝ፥ ዬካ ሳአ ማላ ቤሳዳ። ሱꬅ፥ ታማን ዳማ ጩጋ ቃይቃዮ በንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ዳማን ቦንቾ ማቅደ ላꬄ ዎደ፥ የሎዳንፓ ቲኖ አዋ ꬉሞዳ፤ አግናን ሱꬅ ፋና ይኦዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ይና ዎድተ Ꮉንጋራ ይኦዳ፤ ላꬄ ሱንꬅቶ ጼግዘ ኦደን አቶዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«እስራኤለ አሱንꬆ፥ Ꮉና ቃልቶ ስኦተ። ናዝረተ የሱሳ ኦና የዛኮ፥ ጾዚ ይን ግዳ ኦችደ ክለ ባዝን ማላን ይንትስ ቆንጭዳኖ ይን፥ ይን ኦምተ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ጾዘ ቲኖ ቆፍተን ኤ ኤርቲ ባጋራ የሱሳ አꬊ እንግንትዳ። ይንትን ኤዛ ህገ ባይዙንꬅ ኩሸ ማስቃላላ ሱጺ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","የዝን Ꮉይቆ ኤዛ አይኮደስ ዳንዳኦሰ ግሾ ጾዚ Ꮉይቆ ዎልቃ ꬋብሲ ኤዛ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ዳዉተ ኤ ባዝ ኦህተራ፥ « ‹ታኒ ታናመ ፋና፥ ላꬂ ታ ምዛቅተ የነ። ላꬃ ኡባ ዎደ ታ ቲኖ በእነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ይኒ ግሾ፥ ታ ዎዝንታ ኡፋይትዳ፤ ታ እልአንꬅተ ኡፋይስ ኩምዳ፤ Ꮉይቅዘ ታ አሽታ ኡፋይሳራ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","አኮስ ጋይኮ፥ ታ ሸምፕቶ ስኦለ ግዳ አሾስ። ማህ ነ ጌሻ ዎቃስ አሾስ። ");
INSERT INTO oyde_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ነ ታና ደኦ ኦገ ኤርስዳ፤ ነ ታራ የዛንፓ ታ ኡፋይስታ ኩሙꬅ ማቃነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«እሹንꬆ፥ ኑ አዳይ ዳዉተባዝ ታ ይንትስ ጌሽ ኦሆዳ። ዳዉተ Ꮉይቂ ሞግንትዳ፤ ኤ ቦዝታ Ꮉይኖ የሎደስ ኑ ካለ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ዳዉተ ናበ ማቅደ ግሾ ጾዚ ኤ ናኡንꬃፓ ፈታ ኤ ካእቱሞ አራታላ በትꬆደስ ኤስ ጫቂደ ጫቅቶ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ይኒ ግሾ፥ ክርስቶሳ ደንድቶ ቲኖ ብእ፥ ‹ኤ ሸምፕታ ስኦለ በንታማኖን፤ ኤ አሽታ ዎቃማኖ› ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«ጾዚ፥ Ꮉያ የሱሳ Ꮉይቆፓ ደንꬅዳንስ ኑኒ ኡቡንꬅ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ይኒ ግሾ፥ ጾዘ ምዛቅ ዛላራ ኤዛ ꬎቅ ꬎቅ ዪዚ፥ ኤስ እንጎዳ ጋእንትደ ጌሽ አያን አደፓ ኤኪ፥ Ꮉኖ ይን Ꮉተ በእዛኖን ስእዛኖ ኑላ አፋ ጉስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","አኮስ ጋይኮ፥ ዳዉተ ፋ ኦምተ ሳሎ ከዝካያ የዝን፦ «ላꬂ፥ ታ ላꬃ፥ ‹ታ ነ ሞርኩንꬃና ነ ቶህታ የꬍዘ በሲ ማሆደ ዎንꬅስ Ꮉነ ታፓ ምዛቅ ዛላ በቶ ጋይዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«ይኒ ግሾ፥ Ꮉይ ይን ማስቃላላ ሱጽደ የሱሳ፥ ጾዚ ላꬅን ክርስቶሳ ማህዳኖ እስራኤለ አስ ኡቡንꬅ ቱርፕ ኤሮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","አሱንꬅ ጴጥሮሳ ጋእዳኖ ስኤዘ ዎደ ፋ ዎዝንተ አዛኒ ቦችንቲ ጴጥሮሳን Ꮉንኩንꬅ ሐዋሩንꬃጎ፥ «እሹንꬆ፥ ዬዝን ኑኒ አኮ ኦቾ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጴጥሮሳ ኡንታጎ፥ «ይን ናጋርታ አቶ ጋእንቶደ ጋር ናጋርትፓ ማቂ፥ ይን ፈተ ፈተ የሱስ ክርስቶሳ ሱንꬅተ ጻማቅንቶተ። ጾዚ እንግዘ ጌሽ አያና እሞ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ጾዚ እንጎዳ ጋይደ ኡፋይስ ቃላ ይንትስ፥ ይን ናኡንꬅስን ላꬂ ኑ ጾዛይ ፋጎ ጼግዘ Ꮉኮ የዘ ኡቡንꬅስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ጴጥሮሳ ኡንትስ መለ ቃላን ጉጂ ማርክꬊ፥ «Ꮉንꬅ ዎቦ አሱንꬃላ ዮኦደስ የዘ ፍርዳፓ ይን ኦምቶ አሾተ» ያጋእ ዞርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ጴጥሮሳ ኦህዳኖ ኤክዱንꬅ ጻማቅንትዳ። የ ዎደ Ꮉይꬕ ሙኩል ማቃደ አሱንꬅ አማኒ ጉጁንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ኡን ሐዋሩንꬅ ትምርተራ፥ ፈተትꬃራ፥ ዎላ ካꬃ መኤራን ጾዝ ዎሳራ ሚንግ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ሐዋሩንꬅ ኩሸ ጋማ ክለ ባዝን ማላ ኦችንትዘ ግሾ አሱንꬅ ኡባ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","አማንዘ ኡቡንꬅ ፈትላ የነ፤ ፋስ የዘባዝቶን ኡባ ፈትላ ግሽንታነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ኡን ፋስ የዘባዝቶ ባይዝ ብርቶ ፈተስ ፈተስ ኮሽደ ፋና ግሻነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ኡባ ዎደ ፈቲ ዎዝናራ ማቂ ጾዘ ኬꬃ ሺቃነ። ፋ ኬꬃን ፈተ ፈታ ጼጊ ኡፋይሳራን ሎኦ ዎዝናራ ካꬃ ሙነ። ");
INSERT INTO oyde_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ጾዛ ጋላትተራ አስ ኡባ ግዳ ናሽንትዳ። ላꬂ አትዘ ሸምፖ ቃምተ ቃምተ ኡንታላ ጉጃነ። ");
INSERT INTO oyde_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ፈቲ ኦደ ጴጥሮሳን ዋሐንሳን ጾዝ ዎሶደስ ኡዱፉን ሳተ ጾዘ ኬꬃ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","የልንትዳንፓ ደንዲ ቶሄ ዎቦ ማቅደ ፈቲ አስ ጾዘ ኬꬃ ገልዘ አሳፓ ሙጻታ ዎሶደ ፋና ኡባ ዎደ ሎኦ ጋዘ ጾዘ ኬꬅትስ ፉርꬅተ ቶኪ ክእ ጋዳነ። ");
INSERT INTO oyde_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","የ አꬄ ጴጥሮሳን ዋሐንሳን ጾዘ ኬꬅተ ገሎደስ የኦደራ ብእ ኡንታና ሙጻታ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ኡንትን ኤዛ ዳኪ ብእ፥ ጴጥሮሳ «ኑና Ꮉንካ ቦኦ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ቶሄ ዎቦ አꬄ ኡን አኮ ባዝ እማዳ አዝን ኡንታና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","የዝን ጴጥሮሳ ኤጎ፥ «ታስ ብራን ዎርቃን ባያ፥ የዝን ታስ የዛኖ ታ ኔስ እንጎዳ። ናዝረተ የሱስ ክርስቶሳ ሱንꬅተ ደንዲ ጎደን Ꮉንካን የꬎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ይንፓ ማቂ፥ ኤ ምዛቅ ኩሽቶ አይኪ ደንꬅዳ። ኤልሲ ኤ ቶህታን ቅልችታን ምንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","አꬃይ ዶሊ ደንዲ ኤቅዳ። ጎደን Ꮉንካን የ አይክዳ። ይንፓ ማቂ፥ የꬍተራ፥ ዶልተራን ጾዝ ጋላትተራ ኡንታራ ዎላ ጾዘ ኬꬃ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ኤ የꬎደራ ጾዝ ጋላቶደራን አሱንꬅ ኡባ ኤዛ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ብእደ ኡባ ሙጻታ ዎሶደስ ሎኦ ጋዘ ጾዘ ኬꬃ ፉርꬅተ በትደ ኤዛ ማቅዳኖ ኤርዳ፤ ኤ Ꮉንዳኖ ብእ ጋማ ቆፋራ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","አꬃይ ጴጥሮሳፓን ዋሐንሳፓን ዱጾስ ጋእ አይኪ የዝን አሱንꬅ ኡባ ጋማ ቆፒ፥ ሶሎሞና ፉርꬅ ጋዘ በሳ ዎላ ኡንታጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጴጥሮሳ አሱንꬃና ብእደ ዎደ አሱንꬃጎ፥ «እስራኤለ አሱንꬆ፥ አኮስ Ꮉነ ጋማ ቆፐተ? ዎይ አኮስ ኑና ዳኪ በኤተ? ኑኒ ኑ ዎልቃራ ዎይ ኑ ጾዝ ዣሽትደ ግሾ Ꮉይ አꬃ ፋ ቶሄር የꬎደ ጋር ዪሳዳ ይንትስ አዛነ? ");
INSERT INTO oyde_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","አብራሃማ፥ ይሳቃ፥ ያይቆባ ጾዘ፥ ኑ አዱንꬅ ጾዘ፥ ፋ ናአያ የሱሳ ቦንችዳ። የዝን ይን Ꮉይቆስ አꬂ እንግዳያ ጵላጦሳ ብሎደስ ኮይን ይን ኤ ቲኖ፥ ‹ኑ ኤዛ ኮዮስ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ይን ጌሽዛን ጽልዛን፥ ‹ኑ ኤዛ ኮዮስ› ጋእ፥ ሸምፖ ዎꬍዳያ ይንትስ ብሎደ ጋር ጵላጦሳ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ደኦ እንግዛያ ይን ዎꬍዳ፥ የዝን ጾዚ Ꮉይቆፓ ኤዛ ደንꬅዳ። ይንስ ኑ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ꮉይ ይን በእዘን ኤርዘ አꬄ ፋጺ ሚንግዳና የሱሳ ሱንꬅተ አማንዳነ። Ꮉይ ይን ኡቡንꬅ ቲንተ ኤዛ Ꮉንጋር ፋꬅደ ኤ የሱሳ አማንደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Ꮉተን ታ እሹንꬆ፥ ይንትን ይንታና ካልꬅዙንꬅ ጋር፥ ኤርካይዛራ ኦችዳኖ ታ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","የዝን ጾዚ ዛጋ ናቡንꬅ ኡቡንꬅ ዶንተ፥ ‹ክርስቶሳ ማꬋ ኤኮደስ ቤዛነ› ያጋይዳኖ ይእ ፎልንቶደ ፋና ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ይኬ፥ ጾዚ ይን ናጋርቶ አቶ ጋዉደ ጋር ማሮትꬅ ገሎተን ላꬃጎ ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ላꬄ ካለፓ ምንꬅꬅዘ ዎደ ይንትስ የኦደ ፋና ጾዚ ኤዛ ቲንꬊ ዶርደ ክርስቶስ የሱሳ ይንትስ ዳኮዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ጾዚ ፋ ጌሽ ናቡንꬅ ዶንተ ዛጋ ኦህዳን ጋር ኡባ ባዝ ክልꬎደ ዎደ የሎደስ የሱሳ ሳሎ ጋምኦደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ሙሴ፥ ‹ላꬂ ጾዚ ታና ደንꬅዳን ጋር ይን ግዳ ፋ ይንትስ ናበ ደንꬆዳ። ይን ኤ ጋዛኖ ኡባ ስኦተ። ");
INSERT INTO oyde_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","የ ናብዘ ኦህዛኖ ስኦሰ አꬄ ኦደን አስ ግዳፓ ሻክንት ꬋቦዳ› ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«ማህ ሳሙኤላፓ አይኪ የዘ ናቡንꬅ ኡባ ይና ቃምትባዝ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ይን ናቡንꬅ ናኡንꬃና፤ ማህ ጾዚ አብራሃማስ፥ ‹ሳአ የዘ አስ ኡባ ታ ነ ኮችት ባጋር አንጆዳ› ጋእ ኑ አዱንꬅስ ጫቆ ቃላ ላቶደ ናኡንꬃና። ");
INSERT INTO oyde_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ጾዚ ይንታና ኡባ ይን ኢታ ኦግትፓ ማህ አንጆደ ፋና ፋ ናአያ ደንꬂ ይንትስ ቲኒ ዳክዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ጴጥሮሳን ዋሐንሳን አሱንꬅስ ኦሆደራ ካህኑንꬅ Ꮉላቁንꬅ፥ ጾዘ ኬꬅቶ ናግዙንꬅ Ꮉላቅዘን ሳዱቃዉንꬅ ኡንታጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ኡን የሱሳ Ꮉይቆፓ ደንድዳኖን ኤ ባጋራ Ꮉይቆፓ ደንዶ የዛኖ አሱንꬃና ታማርስደ ግሾ ካጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ይኒ ግሾ፥ ኡንታና አይኪ ሳእታ ኡጉርደ ግሾ ዎንቶደ ዎንꬅስ አች ኬꬃ ገልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","የዝን ቃላ ስእዱንꬃፓ ጋሙንꬅ አማንዳ። አማንደ ꬊራꬅ አሱንꬅ ፋይድታ እችን ሙኩል የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ዎንትꬅት ኦደ ጋደ አህዙንꬅ፥ ጭሙንꬅን፥ ህገ አስታማሩንꬅ የሩሳላመ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","የንꬅ አሱንꬅ ግዳ ካህኑንꬅ Ꮉላቅዘ ሃናን፥ ቃያፋ፥ ዋሐንሳ፥ እስክንድሮሳን ካህኑንꬅ Ꮉላቃ እግኑንꬅ ኡባ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ጴጥሮሳን ዋሐንሳን ፋ ቲንተ ኤስ፥ «አኮ ዎልቃራ ዎይ ኦደ ሱንꬅተ Ꮉኖ ይን ኦችዶ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","የ ዎደ ጴጥሮሳ ጌሽ አያናር ኩሚ፥ «አህዙንꬆን፥ ጭሙንꬆ፥ ");
INSERT INTO oyde_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ꮉይኖ Ꮉይ ቶሄ ዎቦ አꬄስ ኦችንትደ ሎኦ ኦችትስን ኤ ዋይዝ ፋጸዛኮ ይን ኑና ቁርችኮ፥ ");
INSERT INTO oyde_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ማስቃላላ ይን ሱጽን፥ ጾዚ Ꮉይቆፓ ደንꬅደ ናዝረተ የሱስ ክርስቶሳ ሱንꬅተ Ꮉይ አꬄ ፋጺ ይን ቲንተ ኤቅዳይ ይንትስን እስራኤለ አስ ኡቡንꬅስ ኤርንትደባዝ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","«ይን ‹ኬጽዙንꬅ ለቂ እጽደ ሹችዘ፥ ኬꬅ ማይዘነስ ኦማን፥ ኡባፓ አꬍዘ ሹች ማቅዳ፤ የ ሹችዘ የሱሳ።› ");
INSERT INTO oyde_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ይኒ ግሾ፥ አቶትꬅ ኤ ባጋራፕ አትን መለ ኦደ ባጋራን ይእካያ። ኑ ኤ ሱንꬅተ አቶደ ጋር አስ ኡባስ ጾዚ ሳሎፓ ኦሞራ እንግደ መለ ሱንꬅ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ሺቅደ አሱንꬅ ጴጥሮሳን ዋሐንሳን ቆንጭዝ ኦህዳኖ ብእደ ዎደ ኡን ታማርካይዘ ጨር አስ ማቅዳኖ ቆፒ ጋማ ናሽዳ፤ ኡን የሱሳራ የዛኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ማህ ፋጽደ አꬄ ጴጥሮሳራን ዋሐንሳራ ኤቅዳኖ አሱንꬅ ብእን ጋዉደ ባዝ ꬋብዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","የዝን ጴጥሮሳን ዋሐንሳን ባለ ኬሳደ ጋር ዪዚ ፋ ግዳ፥ ");
INSERT INTO oyde_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Ꮉንꬅ አሱንꬃላ ኑ አኮ ኦቾ? ኡን ኩሽተ ኦችንትደ ዳማ ክለ ባዝ የሩሳላመ የዘ ኡቡንꬅስ ቆንጭዳ። ኑ ይኖ አቾደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","የዝን Ꮉና ኦህታ አስ ግዳ ዳልጋመ ጋር ይኬፓ Ꮉንꬅ አሱንꬅ የሱሳ ሱንꬅተ ሙሎን ኦሃመ ፋናን ታማርሳመ ፋና ካዮዳ» ጋእ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ኡንታና ጼጊ፥ የሱሳ ሱንꬅተ ይኬፓ ኦሃመ ጋር ዎይ ታማርሳመ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","የዝን ጴጥሮሳን ዋሐንሳን ኡንታጎ ማህ፥ «ጾዘስ ኪትንቶዳንፓን ይንትስ ኪትንቶዳንፓ ጾዘ ቲኖ አና ሎኦ የዛኮ አነ ይን ፍርዶተ። ");
INSERT INTO oyde_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ኑ ብእዳኖን ስእዳኖን ኦህካይዛራ ስእ ጋዉደስ ዳንዳኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ጭሙንꬅን ዎርዣ አህዙንꬅ ቲኖስትፓ ምንꬂ ካጪ ኡንታና ዳኪ አሽዳ። አሱንꬅ Ꮉንዳንስ ጾዝ ጋላቲ ቦንችደ ግሾ ኡንታና ፍርዶደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ይና ክለ ኦችተ Ꮉርግትፓ ፋጽደ አꬄስ ላይꬅታ ኦይታማፓ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ጴጥሮሳን ዋሐንሳ ብልንቲ አማንዘ ባጉንꬃጎ Ꮉንግ፥ ካህኑንꬅ Ꮉላቁንꬅን ጭሙንꬅ ፋጎ ጋይደባዝ ኡባ ኡንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ኡን ይኖ ስእደ ዎደ ፈቲ ዎዝና ማቂ ጾዛ Ꮉንጋራ ያጋእ ዎስዳ፦ «ኡባ አህዘ ላꬃዮ፥ ሳሎ፥ ሳአ፥ አባን ኡን ግዳ የዛኖ ኡባ መꬍዳዮ፥ ");
INSERT INTO oyde_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ኔኒ ነ አርዘ፥ ኑ አዳይ ዳዉተ ዶንተ ጌሽ አያናራ፥ «አይሁደ ማቆሱንꬅ አኮስ ዙዝንግዶ? ዎርዡንꬅ አኮስ ጨር ዞርንትዶ? ");
INSERT INTO oyde_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ሳአ ካቱንꬅን ዎርዣ አህዙንꬅ ዎላ ላꬄላን ትዥንትደላን ደንድዳ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«ቱሮን፥ ሄሮድሳን ጰንጠ ጵላጦሳ አይሁደ ማቆሰ አሱንꬃራን እስራኤለ አሱንꬃራ ነ ትዥደ ነ ጌሽ ናአይ የሱሳላ ደንዶደስ Ꮉና ካታምተ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ማህ ኔኒ ነ ዎልቃራን ነ ቆፋር ኦቾዳ ጋእ ቆፒ በትደ ባዝ ኡባ ኡን ፎልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ꮉተን ላꬆ፥ ኡን ማንድዛኖ ቦኦ፤ ኑኒ ነ አሩንꬂ ነ ቃልቶ ኩሙꬅ ዎዝናር ኦሆደ ጋር ኑስ ዎልቃ እንጎ። ");
INSERT INTO oyde_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ነ ጌሽ ኦቻንችዘ የሱሳ ሱንꬅተ Ꮉርግንትዙንꬃና ፋꬆደስ፥ ክለ ባዝን ጋማ ቆፍዘ ባዝ ኦችንቶደ ጋር ነ ኩሽቶ ምጮ» ጋእ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ኡን ጾዝ ዎስዳንፓ ሱባ ኡን ሺቅደ በስታ ኤንእዳ። ኡን ኡቡንꬅ ግዳ ጌሽ አያና ኩምን ጾዘ ቃልቶ ቆንጭዝ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","አማንዙንꬅ ኡቡንꬅ ቆፋራን ዎዝናራን ፈቶ ማቅዳ። ኡን ፋስ የዘ ባዝ ኡባ ታ ባዝ ጋእ ኦሆስ። የዝን ፋስ የዛኖ ኡባ ዎላ ማድንታነ። ");
INSERT INTO oyde_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ሐዋሩንꬅ ላꬄ የሱሳ Ꮉይቆፓ ደንድዳኖ ዳማ ዎልቃራ ማርክꬋነ። ጾዚ ኡን ኡቡንꬅስ ዳማ አꬎ ኬሃትꬅ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ጋደ ማቅን ኬꬂ የዘ ኡባ ባይዝ ብርቶ ዎላላ ጋዳነ። ይኒ ግሾ አማንዙንꬅ ግዳ ማꬍꬍዘ ፈትን ባያ። ");
INSERT INTO oyde_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ብርቶ ክእ ሐዋሩንꬅስ እንጋነ፤ ይና ብርቶ ፈተስ ፈተስ ኮሽደ ፋና ሻኪ ሻኪ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ቆጵሮሳ ጋዘ በስተ የልንትደ ዮሰፋ ጋዘ ሌወ ኮቻፓ ማቅደ ፈተ የነ። ኤ ሱንꬅቶ ሐዋሩንꬅ ባርናባሳ (ምንꬅꬅዘ ናአ) ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ባርናባሳ ፋስ የዘ ጋድቶ ባይዝ ብርቶ ክእ ሐዋሩንꬅስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ፈቲ ሀናንያ ጋዘ አꬄ ፋ ማችታ ሳጲርራ ጋደ ባይዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ይና ባይዝደ ብርትፓ ፋ ማችታ ኤርዝን አሺ፥ አትዳኖ ክእ ሐዋሩንꬅስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","የዝን ጴጥሮሳ ሀናንያጎ፥ «ነ ጌሽ አያና ጭሞደ ጋራን ጋድቶ ባይዝደ ብርትፓ ሻኪ አሾደ ጋር ጻላሄ ነ ዎዝንተ አኮስ ገልዶ? ");
INSERT INTO oyde_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ኔኒ ባይዞዳንፓ ቲኖ ጋድዘ ነባዝ ባነ? ማህ ነ ባይዝ ማቅንን ሚሽታ ነባዝ ባነ? ዬዝን፥ ይኒ ጋርዘ ባዝ ኦቾደስ አኮስ ነ ዎዝንተ ቆፕዶ? ነ ጾዝ ቲኖ ዎርድꬍዳፕ አትን አስ ቲኖ ዎርድꬍካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ሀናንያ ይና ቃልቶ ስእደ ጋር ጎልእ Ꮉይቂዳ፤ ይኖ ስእደ ኡቡንꬅ ዳማ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ናአትꬁንꬅ ደንዲ ኤ አህቶ ዚꬊ ጻጺ ካንግ ሞግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ꮉይꬕ ሳተፓ ሱባ ሀናንያ ማችታ ይኖ ኤርካይዛራ ጴጥሮሳ የዘ በስተ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጴጥሮሳ ኢጎ፥ «ይን ጋድቶ ይና ብርትስ ጋማቲ ባይዝዳተ? አነ ታስ ኦሆ» ያጋይዳ። እዛን፥ «ዬ፥ ይና ብርትስ ጋማቲ ባይዝዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ጴጥሮሳ ማችቶ፥ «ኔራን ነ አዝንዘራ ላꬄ አያና ፋታኖደስ አኮስ ዞርንትዶተ? ይኬ፥ ነ አዝንዛ ሞግደ አሱንꬅ ባለ የነ፤ ነናን ኡን ባለ ከሶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ማችታ ኢራ ጴጥሮሳ ቶህት ካለ ጎልእ Ꮉይቂዳ፤ ሻካኑንꬅ ገልዘ ዎደ Ꮉይቂዳኖ ደንግ ባለ ኬሲ፥ እ አዝንዘ ካለ ካንግ ሞግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ኩሙꬅ ዎሳ ኬꬅታን ይኖ ስእደ መለ አሱንꬅ ኡባ ዳማ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ሐዋሩንꬅ ጋማ ቆፍዘ ባዝን ክሌ ባዝ አሱንꬅ ግዳ ኦችተር የነ። ኡቡንꬅ ፈቲ ዎዝናር ሶሎሞነ ፉርꬃ ሺቃነ። ");
INSERT INTO oyde_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","መለ አሳፓ ፈቲ አስን ኡንታር ማድንቶደስ ሚንግካያ፥ የዝን አሱንꬅ ኡንታና ቦንችዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","አማንዘ ꬊራꬁንꬅን ማቹንꬅ ፋይድታ ቲኖስትፓ ጋንግተ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ይኒ ግሾ፥ አሱንꬅ Ꮉርጋንቹንꬃና ሻንቻፋራን አልጋራ ቶኪ ጴጥሮሳ አꬍዘ ዎደ ኤ ዳሽታ ኡንታፓ ፈተላ ፈተላ ዳሾደ ጋር ኦገ ዶና ኬሲ ጋዳነ። ");
INSERT INTO oyde_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ማህ ጋማ አሱንꬅ የሩሳላመ ካለ የዘ ካታማፓ Ꮉርግንትዙንꬃና ቱና አያና ዋይꬅዘ አሱንꬃና ኤኪ የእነ፤ ኡቡንꬅን ፋጻነ። ");
INSERT INTO oyde_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ካህኑንꬅ Ꮉላቅዘን ኤራ የዘ ሳዱቃዉንꬅ ኡባ እጸራ ኩሚ ሐዋሩንꬃላ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ሐዋሩንꬃና አይኪ ዎርዣ አች ኬꬃ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","የዝን ላꬂ ኪታንቾ ቃማ አች ኬꬃ ፉርꬅቶ ቡጊ ሐዋሩንꬃና ባለ ኬሲ፥ ");
INSERT INTO oyde_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ꮉንግ፥ ጾዘ ኬꬃ ኤቂ Ꮉና ክለ ደኦ ቃልቶ አሱንꬅስ ኡባ ኦሆተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ሐዋሩንꬅ ይኖ ስእደ ዎደ ዎንታ ጎዳ ጾዘ ኬꬃ ገሊ ታማርሰ አይክዳ። ካህኑንꬅ Ꮉላቅዘን ኤራ የዙንꬅ ይእ፥ እስራኤለ ጭሙንꬃና ኡባ ጼጊ ሺሺ ሐዋሩንꬃና ፋ ቲኖ ኮኦደ ጋር ዎታዳሩንꬃና አች ኬꬃ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","የዝን ዎታዳሩንꬅ አች ኬꬅተ Ꮉንግ ሐዋሩንꬃና ደንግካያ። ሱብ ማቂ ይእ አሱንꬃጎ፥ ");
INSERT INTO oyde_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«ኑ Ꮉንግዘ ዎደ አች ኬꬅት ፉርꬅታ ምንꬂ ጎርድንትን፥ ናግዙንꬅ ፉርꬅተ ኤቅዱንꬃና ደንግዳ። የዝን ኑ ፉርꬅቶ ቡግዘ ዎደ ግዳ መለ አቶ የዝን ፈቲ አስን ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ይኒ ግሾ፥ ጾዘ ኬꬅተ ዎታዳሩንꬃና ኪትዘ ካህኑንꬅ Ꮉላቁንꬅ ይኖ ስኤዘ ዎደ «ሐዋሩንꬃላ አኮ Ꮉንዶ?» ጋእ ታውዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","የ ዎደ ፈቲ አስ ኡንታጎ ይእ፥ «ይኬ፥ ይን አጭደ አሱንꬅ ጾዘ ኬꬅተ ኤቂ አሱንꬃና ታማርሳነ» ያጋእ ኡንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ጾዘ ኬꬅተ ዎታዳሩንꬃና ኪትዘ ፋ ዎታዳሩንꬃራ Ꮉንግ ሐዋሩንꬃና ክእዳ። የዝን ኡን ፋና አሱንꬅ ሹቻራ ꬎጎዳ ጋእ ዣሽትደ ግሾ ኡንታና አዳሽ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ኡን ሐዋሩንꬃና ክእ፥ ሺቅደ ሻንጉንꬅ ቲንተ ኤስን ካህኑንꬅ Ꮉላቅዘ ኡንታጎ፥ ");
INSERT INTO oyde_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«ይንታና ኑኒ የ አꬄ ሱንꬅተ ታማርሳመ ጋር ምንꬂ ኪትካነ? ይኬ፥ ይን ትምርትቶ የሩሳላመ ካታማ ኡባ የልꬅዳ። የ አꬄ ሸምፕትስ ኑና ጋልሳደስ ኮያነነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጴጥሮሳራን Ꮉንኮ ሐዋሩንꬃራ ኡንትስ ማህተ፥ «ኑኒ አስስ ኪትንቶዳንፓ ጾዝስ ኪትንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ማስቃላላ ይን ሱጺ ዎꬍደ የሱሳ ኑ አዱንꬅ ጾዘ Ꮉይቆፓ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","እስራኤሉንꬅ ናጋራፓ ማቃደ ጋራን ኡን ናጋርታ አቶ ጋእንቶደ ጋር ጾዚ የሱሳ አህዛያን አሽዛያ ማህ ቦንቾራ ፋፓ ምዛቅ ዛላር በትꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ይንስ ኑ ማርካ፤ ማህ ጾዘ ፋና ኪትንትዙንꬅስ እንግደ ጌሽ አያናን ማርካ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ሺቅደ አሱንꬅ ይኖ ስኤዘ ዎደ ዳማ ዥልꬊ፥ ሐዋሩንꬃና ዎꬎደስ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","የዝን አስ ኡባ ግዳ ዳማ ቦንችንትደ፥ ህገ አስታማረ ማቅደ፥ ጋማልያለ ጋዘ ፈቲ ፋርሳዉዘ ደንዲ ኤቂ ሐዋሩንꬃና ኤራꬅ ጎደ ባለ ከሶደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ይንፓ ሱባ፥ ሺቅደ አሱንꬃጎ፥ «እስራኤለ አሱንꬆ፥ Ꮉንꬅ አሱንꬃላ ይን ኦቾደስ ቆፕደ ባዝትፓ ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","አኮስ ጋይኮ፥ Ꮉንፓ ቲኖ ተዎዳሳ ፋና፥ ‹ታ ዳማ› ጋእ ደንድን፥ ኦይዲ ጼት ማቃደ አሱንꬅ ኤራ ዎላ ማቅዳ። የዝን ኤዛ ዎꬍን ኤዛ ካልዘ ኡቡንꬅ ላንትን ፋꬆሰ አስ ማቂ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ይንፓ ሱባ፥ አሱንꬅ ፋይድንትደ ዎደ ጋልላፓ የዘ ይሁዳ ደንዲ ጋማ አሱንꬅ ፋና ካሎደ ጋር ዪዝዳ፥ የዝን ኤዛ ዎꬍን ኤዛ ካልዘ አሱንꬅ ኡባ ላንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ꮉተን ታ ይንትስ ኦህነ፤ Ꮉንꬅ አሱንꬃፓ ሻግንቶተ፤ ኡንታና ቦችፐተ። አኮስ ጋይኮ፥ Ꮉና ቆፍቶን Ꮉና ኦችቶ አስ ኦችዘባዝ ማቅኮ ꬋቦዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","የዝን Ꮉና ቆፍታን Ꮉና ኦችታ ጾዛፓ ይእደባዝ ማቅኮ፥ ይን ኡንታና ꬋብሶደስ ዳንዳኦስ። ቱርፓ ይን ጾዛራ ካጭንትተራ በንታመ ፋና» ያጋእ ኦህዳ። ይኒ ግሾ፥ ሺቅደ አሱንꬅ ጋማልያለ ዞርዳኖ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ሐዋሩንꬃና Ꮉንካ ፋጎ ጼጊ አላንጋራ ጋራፍዝዳ። ይንፓ ሱባ፥ ኡንታጎ፥ «የሱሳ ሱንꬅቶ ላምእንꬃ ኦህፐተ» ጋእ ብሊ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","የሱሳ ሱንꬅት ግሾ ኡን ቦርንቴ ቤዘባዝ ማቅዳኖ ኤርዘ ግሾ ሻንጉንꬅ ቲኖፓ ኡፋይትተራ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ኡን ኡባ ዎደ ጾዘ ኬꬃን አስ ኬꬃን የሱሳ ኤ ክርስቶሳ ማቅዳኖ ታማርሰን ሳባኬን አሽካያ። ");
INSERT INTO oyde_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","የ ዎደ ካልዙንꬅ ፋይድታ ጋንግ ጋንግ Ꮉንጎደራ፥ ግርኬ ዶና ኦህንትዘ አይሁዱንꬅ ይሁዳ ግዳ የልንት የዘ አይሁዱንꬃላ ዙዝንግዳ። አኮስ ጋይኮ፥ ግርኬ ዶናራ ኦህንትዘ አይሁዱንꬅ፥ «አዋራስ እንግንትዘ ካꬅተ ኑ አዝኒ ባይዘ ማቹንꬅ ቆህንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ታጶ ላምእ ሐዋሩንꬅ ዎሳ ኬꬃ አስ ኡባ ጼጊ፥ «ኑ ጾዘ ቃላ ኦህዛኖ አሺ ካꬃ ሙዛና ኑስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ይኬ፥ እሹንꬆ፥ ሎኦ ኦቻራ፥ ጌሽ አያናራን ጭንጫትꬃራ ኩምደ ላፑን አሱንꬃና ይን ግዳፓ ዶሮተ፤ ኑኒ ኡንታና Ꮉና ኦችትስ ሹሞዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","የዝን ኑኒ፥ ኡባ ዎደ ጾዝ ዎሳራን ቃላ ታማርሰራ ምንጎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ሐዋሩንꬅ ኦህደ ኦህታ አሱንꬃና ኡባ ኡፋይስዳ። ይኒ ግሾ፥ አማኖን ጌሽ አያና ኩምደ እስጢፋኖሳ፥ ፍልጶሳ፥ ጵሮኮሮሳ፥ ንቃሮና፥ ጽሞና፥ ጳርሜናን አይሁደ አማኖ ገሊ ማቅደ አንጾክያ ንቆላዎሳ ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ኡንታና ሐዋሩንꬅ ቲኖ ኤስን፥ ሐዋሩንꬅ ኡንታላ ኩሸ ጋዲ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ጾዘ ቃላ ዳልግተር Ꮉንግዳ። የሩሳላመ የዘ አማንዙንꬅ ፋይድታ ሎይꬂ ጋንግተር Ꮉንግዳ፤ ጋማ ካህኑንꬅን አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","እስጢፋኖሳ አꬎ ኬሃትꬃራን ዎልቃራ ኩሚ አሱንꬅ ግዳ ጋማ ቆፍዘ ባዝን ክለ ባዝ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","አሮትꬃፓ ከዝደ አይሁደ ዎሳ ኬꬃ አሱንꬅ ቀሬናፓን እስክንድርያፓ ክልቅያፓን እስያፓን ይእደ ፈቲ ፈቲ አሱንꬅ ደንዲ እስጢፋኖሳራ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","የዝን እስጢፋኖሳ ኦህተ የዘ ጭንጫትꬅቶን አያንዛ ኡን እጾደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ይና ዎድተ ኡን፥ «ሙሴን ጾዝን ኤ ጫሻደራ ስእዳ» ጋዘ ዎርዶ አሱንꬃና ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ይኒ ጋር ዪዚ አሱንꬃና፥ ጭሙንꬃናን ህገ አስታማሩንꬃና ኤላ አፋ ደንꬅꬅዳ። እስጢፋኖሳ አይኪ ሻንጎ ቲኖ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ኤላ አፋ ፋይድደ ዎርዶ ማርኩንꬅ፥ «Ꮉይ አꬄ Ꮉና ጌሽ ኬꬅቶን ሙሴ ህግቶን ማህ ማህ ጫዣነ። ");
INSERT INTO oyde_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ኤ፥ ‹Ꮉይ ናዝረተ የሱሳ፥ Ꮉና ጾዘ ኬꬅቶ ላሎዳ፤ ማህ ሙሴ ኑስ እንግደ ህግቶ ላሞዳ› ያጋዘ ዎርዶ ማርካ ኤስዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ሻንጎ ሺቅተ በትደ አሱንꬅ ኡባና እስጢፋኖሳ ሎይꬂ በእዘ ዎደ ኤ ስንታ ኪታንቾ ስኖ ማቂ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ካህኑንꬅ Ꮉላቅዘ እስጢፋኖሳጎ፥ «Ꮉና ቱሮ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","እስጢፋኖሳ፥ «ታ እሹንꬆን፥ ታ አዱንꬆ፥ ስኦተ! ኑ አዳይ አብራሃማ ካራነ የሳደስ Ꮉማዳንፓ ቲኖ ማሰጰጦምያ የሳደራ፥ ቦንቾ ጾዘ ኤስ ቆንጪ፥ ");
INSERT INTO oyde_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹ነ ጋድትፓን ነ እግኑንꬃፓ ሻክንት ታ ነና ቤዘ ሳአ ቅቶ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","የ ዎደ አብራሃማ ካልዳዉያነ ጋደፓ ኬዚ ካራነ ሳአ የዝዳ። ኤ አዳይ Ꮉይቂዳንፓ ሱባ ጾዚ ኤዛ Ꮉና ሳእተ Ꮉተ ይን የዛነ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ኤ Ꮉና ጋድትፓ መለ አቶ የዝን ቶሄር የꬍዘ በስን አብራሃማስ እንግካያ። የዝን ናአ ኤስ ባይዘ ዎደ ጾዚ Ꮉና ሳእተ ኤስን ኤ ኮችትስ ላቶደ በሲ ማህ እንጎዳኖ ቃላ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ጾዚ አብራሃማጎ፥ ‹ነ ኮችታ መለ ሳአ ዛቆትꬃ የሳዳ፤ እዘ ኦይዲ ጼት በረ ኡን አሮ ማቂ አቆደ ፋናን ኡንእንቶደ ፋና ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","የዝን ታ ነ ኮችቶ አህዘ ዎርዡንꬃላ ፍርዶዳ። ይንፓ ማቂ፥ ኡን ይና ጋድትፓ ከዚ Ꮉነ ታስ ጎይኖዳ› ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ጾዚ አብራሃማ ኮችታ ጋራዝንቶደ ጋር ኤራ ጫቅን፥ ይሳቃ የልንትደ ኦስፉንꬆ ቃምተ ጋራዝንትዳ። ይሳቃ ያይቆባ የልዳ፤ ማህ ያይቆባ ታጶ ላምእ ፋ ናኡንꬃና፥ ዛርቲ አደ ማቅዱንꬃና ጋራዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«ያይቆባ ናኡንꬅ ዮሰፋ እጺ ግብጸ ጋደ አሮተꬅስ ባይዝዳ፥ የዝን ጾዘ ኤራ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ኤዛ፥ ኤ ማꬍት ኡባፓ ከስዳ። ግብጸ ካት ፋሮና ቲኖ ሳባን ጭንጫትꬅን ኤስ እንግዳ። ግብጸ ካት ዮሰፋስ ግብጸ ሳአን ፋ ኬꬅቶ ኡባ አሆደ ፋና አደትꬅ ዎልቃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«ግብጸን ካናነ ሳአ ኡባ ናየ ገሊ ጋማ አስ ዋይꬅዳ። የ ዎደ ኑ አዳይ ያይቆባ ናኡንꬅ ካꬃ ደንጎደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ያይቆባ ግብጸ ሳአ ካꬃ የዛኖ ስእ ኑ አዱንꬃና ቲኖ የይጋ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ላምእንꬃ Ꮉንግተ ዮሰፋ ፋ እሹንꬅስ ፋና ኤርስዳ። ግብጸ ካትዘን ዮሰፋ ኮችቶ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ዮሰፋ ፋ አዳይ ያይቆባራን ፋ ካራ አሱንꬃና፥ ላፑን ታም እችን አሱንꬃና ፋጎ የኦደ ጋር ዳኪ ክእዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ያይቆባ ግብጸ ሳአ ዎꬍዳ፤ ኤዝን ኤ ናኡንꬅ እዘ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ኡን አህታ ይና በስትፓ ሴኬመ ቶክንት Ꮉንግ፥ እዘ አብራሃማ ኤሞረ ናኡንꬃፓ ጋማ ብራራ ዎንግደ ቦዝተ ሞግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«የዝን ጾዚ አብራሃማስ እማዳ ጋይዳኖ ፎልዘ ዎድታ የሎደስ ኡክደ ዎደ ግብጸ ሳአ የዘ ኑ አሱንꬅ ጋንግ ጋንግ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ይንፓ ሱባ፥ ዮሰፋ ኤሮሰ መለ ካት ግብጸ ሳአ ካእትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","የ ካትዘ ኑ ኮችቶ ገኒ ኤራꬅ ናኡንꬅ Ꮉይቆደ ፋናን ኡንታና ባለ ኬሲ ኦሎደ ፋና ኑ አዱንꬃና ኡንእꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«ይና ዎድተ ሙሴ የልንትዳ፤ ኤ ጾዘ ቲኖ ጋማ ሎኦ ብሻር የዘ ናአ። ፋ አዳይ ኬꬃ Ꮉይꬕ አግና የሎደስ ድጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ሙሴ ካንግ Ꮉꬅ ጋጻ ጋድደ ዎደ ግብጸ ካት ናታ ደንግ ኤኪ ፋስ ናአ ማህ ኤዛ ድችዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ሙሴ ግብጹንꬅ ኤራትꬅ ኡባ ታማሪ ኦሄራን ኦቻራን ምንꬂ አስ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«ሙሴስ ላይꬅታ ኦይታም ኩምደ ዎደ ፋ እሹንꬃና፥ እስራኤሉንꬃና በአደስ ፋ ዎዝንተ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","እስራኤሉንꬃፓ ፈታ ግብጸ አꬄ ቆሆደራ ብእ የ እስራኤለ አꬃ ማዲ፥ የ ቆህዛ ግብጸ አꬃ ዎꬊ ኩሸ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ሙሴ ፋ እሹንꬃና ፋ ባጋራ ጾዚ አሾደስ ዪዛኖ ኡን ቲሮዳ ጋይዳ፥ የዝን ኡን ቲሪካያ። ");
INSERT INTO oyde_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«ዎንትስት ዎደ ላምእ እስራኤለ አሱንꬅ ፈተ ፈተራ Ꮉꬍንቶደራ ደንግ ኡንታና ጊግሳደስ ኮይ፥ ‹አሱንꬆ፥ ይን ዎልስ እሸ፤ አኮስ ፈተ ፈታ ቆሄ?› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«የዝን ፋ ላግዛ ቆህዘ ሙሴጎ፥ ‹ነና ኑላ አህዘ አስን ዳይና ማህደ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ነ ኦማ ግብጸ አꬃ ዎꬍዳንጋራ ታና ዎꬎደስ ኮያነ?› ያጋእ ሙሴ ኡርቂ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙሴ ይኖ ስእደ ዎደ ግብጸፓ በቲ ሚድያመ ሳአ በተ አስ ማቂ የዝተራ ላምእ ꬊራꬅ ናኡንꬃና የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«ላꬄ ኪታንቾ ኦይታም በረፓ ሱባ ሲና ደረ ካለ የዘ አኮ ባይዘ ጋናሳ ዥልኦ ኩበ ግዳ ኤጽዘ ታማ ሎጸ ግዳ ሙሴስ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ሙሴ ፋ ብእዳነ ጋማ ቆፒ፥ ሎይꬂ በአደስ ዥልኦ ኩበ ካለ ሺቂ የዝን፥ ላꬄ ቃላ፥ ");
INSERT INTO oyde_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹ታኒ ነ አዱንꬅ፥ አብራሃማ ጾዝ፥ ይሳቃ ጾዝ፥ ያይቆባ ጾዝ› ያጋእተራ ሙሴጎ ይእዳ። ሙሴ ዣሽሞራ ጎቂ በአደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«ላꬂ ሙሴጎ፥ ‹ኔኒ ኤቅደ ሳእታ ጌሽ ማቅደ ግሾ ነ ቶህተ የዘ ጫምቶ ኬሶ። ");
INSERT INTO oyde_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ታኒ ግብጸ የዘ ታ አሱንꬅ ማꬋራን ፍርዳራ ኡንእንትዛኖ ብእዳ። ኡን ኡፍቶ ስእ ኡንታና አሾደስ ዎꬍዳ። Ꮉተ Ꮉይጋ! ታ ነና ግብጸ ኪቶዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«እስራኤሉንꬅ Ꮉያ ሙሴ፥ ‹ነና ኑላ Ꮉላቃን ዳይና ማህደ ኦደ?› ያጋእ እጽዳኖ Ꮉይ አꬃ ዥልኦ ኩበ ግዳ ኤስ በንትደ ኪታንቹንꬅ ባጋራ Ꮉላቃን አሽዛ ማህ ጾዚ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ꮉይ አꬄ ሙሴ እስራኤሉንꬃና ግብጸፓ ኬሲ ጋማ ቆፍዘ ባዝን ክለ ባዝ ኦቺ ኡንታና ግብጸ ሳአ፥ ኤርተራ አባን፥ አኮ ባይዘ ጋናሳ ኦይታም በረ ካልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Ꮉይ አꬄ እስራኤለ አሱንꬃጎ፥ ‹ጾዚ ታና ደንꬅዳን ፋና ይን ኮችቲ ግዳፓ ታ ጋር ናበ ይንትስ ደንꬆዳ› ጋይዳይ ኤዛ ሙሴ። ");
INSERT INTO oyde_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","አኮ ባይዘ ጋናሳ ሺቅደ እስራኤለ አሱንꬃራ የዝዳይ፥ ኑ አዱንꬃራ የዝዳይ ሲና ደርዘላ ኤስ ኦህደ ኪታንቹንꬃራ የዝደ ሙሴ ኤዛ። የይዝ፥ ጾዘ ደኦ ቃላ ኑስ እንጎደስ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«የዝን ኑ ማይዙንꬅ ሙሴስ ኪትንቶደስ ካꬍካያ፤ ኤዛ እጺ ሱብ ግብጸ ማቃደስ አሙꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ማህ አሮናን፥ ‹ኑና ካልꬅዘ ኤቁንꬃና ኑስ መꬎ። አኮስ ጋይኮ፥ Ꮉይኒ ኑና ግብጸፓ ክእደ ሙሴ፥ ዋየዛኮ ኑኒ ኤሮስ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","የ ዎደ Ꮉርና አዝዝ ኤቁንꬃና መꬍዳ። የንꬅ ኤቁንꬅስ ዣርሾ ዣርሺ ፋ ኩሽተ ኦችደ ኦችታ ኡን ቆፍት ፋና Ꮉንደ ግሾ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","የዝን ጾዚ ኡንትስ ባንተ ማህዳ። ኡን ሳሎ ጾልንቶ ጎይኖደ ጋር ኡንታና ኦሊ አሽዳ። ናቡንꬅ ማጻፍተ፥ « ‹እስራኤለ አሱንꬆ፥ ኦይታም በረ ኡባ አኮ ባይዘ ጋናስ ሳአ ሹክደ Ꮉርስን ዣርሽደ ዣርሽቶ ታስ ሺሽዳነ? ");
INSERT INTO oyde_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ይን፥ ይንትስ ጎይኖደስ ኬስደ ሞሎኬ ዱንካነ ረፋነ ጋእንትዘ ይን ኤቅዘ ጾልንቶ ምስለ ቱክዳ። ታ ይንታና ባብሎነፓ ጎደ ዳኮዳ› ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«ኑ አዱንꬅስ አኮ ባይዘ ጋናሳ ማርካ ዱንካነ የነ። ኤዛን ጾዚ ሙሴ ኪትዳንጋራን ኤዛ ቤዝዳንጋራን መꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ማህ ኑ አዱንꬅ ይና ዱንካንቶ ፋ አዱንꬃፓ ኤኪ ጾዚ ቲኖ ባይእደ አይሁደ ማቆሰ አሱንꬅ ጋድቶ አይክደ ዎደ እያሱራ የይጋ ኤኪ ገልዳ። የ ዱንካንዛ ዳዉተ ዎደ የሎደስ ይና በስተ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ዳዉተ ጾዛፓ ናሽንትዳ። ማህ ያይቆባ ጾዘስ የሳደ ኬꬂ ኬጻደስ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","የዝን ኤስ ኬꬂ ኬጽደ ሶሎሞና። ");
INSERT INTO oyde_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«ማቅኮን፥ ኡባፓ ካታራ የዘ ጾዘ አስ ኬጽደ ኬꬃ የዞስ። ናብዘ ጋይዳን ጋር፥ ");
INSERT INTO oyde_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","« ‹ሳሎ ታስ አራታ፥ ሳአን ታ ቶህታ የꬍዘ በሲ። ዬዝን፥ ታስ ይን አኮ ጋርዘ ኬꬂ ኬጾደ? ዎይ ታ ሸምፕዘ በስታ አባ? ");
INSERT INTO oyde_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ꮉኖ ኡባ ታ ኩሽተ መꬍካ?› ያጋይዳ ላꬂ። ");
INSERT INTO oyde_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«ይን ዋይደ ስኦሰ አሶ? ይን ዎዝንታ ጾዘ ቃላ ኤኮደስ አኮስ እጽዶ? ይን Ꮉይታ አኮስ ቱልዶ? ይን፥ ይን አዱንꬅ ጋር ኡባ ዎደ ጌሽ አያና እጻነ። ");
INSERT INTO oyde_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ናቡንꬅ ግዳፓ ይን አዱንꬅ ባይእካይዘ ኦደ? ጽልዛይ ዮኦዳኖ ቲንꬊ ኦህዱንꬃና ዎꬍዳ። Ꮉተ ይን ኤዛ አꬂ እንግ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ይን ኪታንቾ ኩሸፓ ጾዘ ህግቶ ኤክዳ፥ የዝን ኪትንትካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ኡን ይኖ ስእደ ዎደ ፋ ዎዝንተ እስጢፋኖሳላ ጋማ ዥልꬊ፥ ፋ ዶንቶ ꬋእ ማንድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","የዝን እስጢፋኖሳ ጌሽ አያናራ ኩሚ፥ ሳሎ ኡደ ብእ፥ ጾዘ ቦንችቶን የሱሳ ጾዘ ምዛቅ ዛላራ ኤቅዳኖ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«ይኬ፥ ታኒ ሳሎ ቡጉንትን፥ አስ ናአይ፥ ጾዘ ምዛቅ ዛላራ ኤቅዳያ ብእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ፋ ቃልቶ ꬎቅ ዪዚ ዉይስተራ፥ ፋ Ꮉይቶ አይኪ ፈትላ ኤጎ ዎጽዳ ");
INSERT INTO oyde_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ኤዛ ካታማፓ ጋጻ ኬሲ፥ ሹቻራ ꬎግዳ። ማርኩንꬅ ፋ ማእቶ ፈቲ ሳዉላ ጋዘ ናአትꬅ አꬄ ካለ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","እስጢፋኖሳ፥ «ታ ላꬆ የሱሳ፥ ታ ሸምፕቶ ኤኮ» ያጋእ ጼጎደራ ኡን ኤዛ ሹቻራ ꬎጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ቡንቁንቲ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ታ ላꬃዮ፥ Ꮉና ናጋርቶ ኡንትስ አቶ ጋኦ» ያጋይዳ። ይኖ ያጋእ ማቂ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ሳዉላ እስጢፋኖሳ ዎ ቆፍተ ገልዳ። የ ዎደ የሩሳላመ የዘ ዎሳ ኬꬅተ ዳማ ባይኤ ደንድዳ። ሐዋሩንꬃፕ አትን አማንዘ ኡቡንꬅ ይሁዳ ሳአን ሳማራ ሳአ ላልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ፈቲ ፈቲ ጾዝ አሱንꬅ እስጢፋኖሳ ሞግዳ፤ ማህ ኤስ ዳማ ዬክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","የዝን ሳዉላ ዎሳ ኬꬅቶ ላሎደስ ኮያነ። ኡቡንꬅ ካራ ዉቲ ገሊ፥ አማንዘ ꬊራꬁንꬃናን ማቹንꬃና ጎቺ ኬሲ አች ኬꬃ ገልꬃነ። ");
INSERT INTO oyde_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ላልንትደ አማንዙንꬅ ቅትደ በሳ ኡባ ቃላ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፍልጶሳ ሳማራ ካታማ ገሊ ክርስቶሳ ባዝ አሱንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ጋማ አሱንꬅ ፍልጶሳ ጋይዳኖ ስእደ ዎደን ኤ ኦችደ ክለ ባዝቶ ብእደ ዎደን ኤዛ አካኪ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ቱና አያና ኡክ ጋማ አሱንꬃፓ ከዝዳ፤ ማህ ጋማ ቶሄ ጉንዱንꬅን ዎቡንꬅን ብልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ይና ካታምተ የዘ አሱንꬅ ዳማ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","የዝን ስሞና ጋዘ ፈቲ አꬄ ይና ካታምተ የነ። ኤ፥ ታኒ ዳማ ጋእ ሳማራ አሱንꬃና ማርꬍተራ ጋማ ቆፍዝተራ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ኤራꬃፓ ዳማ የሎደስ የዘ አሱንꬃና ኡባ፥ «ዳማ ጾዘ ዎልቅታ Ꮉኖ» ጋእ ኤዛ ስእነ። ");
INSERT INTO oyde_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ጋማ ዎደፓ አይኪ ማርꬍተራ ሳማራ አሱንꬃና ጋማ ቆፍዘ ግሾ አሱንꬅ ኤዛ ስእነ። ");
INSERT INTO oyde_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","የዝን ፍልጶሳ ጾዘ ካእቱሞን የሱስ ክርስቶሳ ሱንꬅትባዝ ꬊራꬁንꬅስን ማቹንꬅስ ኦህን፥ ኡን ኤ ባዝ አማኒ ጻማቅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ማህ ስሞናን ፋ ኦምተ አማኒ ጻማቅንትዳ። ፍልጶሳር ዎላ Ꮉንግደ በሳ ኡባ ኦችንትዘ ዳማ ክለ ባዝ ብእ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","የሩሳላመ የዘ ሐዋሩንꬅ ሳማራ አሱንꬅ ጾዘ ቃላ ኤክዳኖ ስእደ ዎደ ጴጥሮሳን ዋሐንሳን ኡንታጎ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ጴጥሮሳን ዋሐንሳን Ꮉንግ፥ አማንዙንꬅ ጌሽ አያና ኤኮደ ጋር ኡንትስ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","አኮስ ጋይኮ፥ ሳማራ አሱንꬅ ላꬄ የሱሳ ሱንꬅተ ጻላላ ጻማቅንትዳፕ አትን ኡንታፓ ፈተላን ጌሽ አያና Ꮉጋ ዎꬍካያ። ");
INSERT INTO oyde_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","የ ዎደ ጴጥሮሳን ዋሐንሳን ፋ ኩሽቶ ኡንታላ ጋድን፥ ኡን ጌሽ አያና ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ሐዋሩንꬅ ፋ ኩሽቶ ኡንታላ ጋድን፥ ኡንትስ ጌሽ አያና እንግንትዳኖ ስሞና ብእደ ዎደ ጴጥሮሳስን ዋሐንሳስ ሚሸ ክእ፥ ");
INSERT INTO oyde_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«ታንን ታ ኩሽቶ ጋድዘ ኡቡንꬅ ጌሽ አያና ኤኮደ ፋና Ꮉና አደትꬅ ዎልቅቶ ታስን እንጎያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","የዝን ጴጥሮሳ ኤጎ፥ «ነ ጾዘ እሞትꬅ ሚሸራ ኤኮደስ ቆፕደ ግሾ ነ ሚሽታ ኔራ ꬋቦ። ");
INSERT INTO oyde_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ነ ዎዝንታ ጾዘ ቲኖ ልከ ማቅካይዘ ግሾ ኔስ Ꮉነ ግሾ ዎይ እጻ ባያ። ");
INSERT INTO oyde_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ይኬ፥ Ꮉና ነ ዎዝና ኢታትꬅት ግሾ ናጋርትፓ ማቆ። ነ ዎዝንተ የዘ ኢታ ቆፍቶ ጾዚ አቶ ጋዉደ ጋር ላꬃ ዎሶ። ");
INSERT INTO oyde_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","አኮስ ጋይኮ፥ ኔኒ ኢታ እጸራን ናጋራ አቻራ የዛኖ ታ በእነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ስሞና ማህ፥ «ይን ጋእዳንፓ ፈትን ታና የላመ ጋር ታስ ላꬃ ዎሶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ጴጥሮሳን ዋሐንሳን ማርክꬍዳንፓን ላꬄ ቃላ ኦህዳንፓ ሱባ የሩሳላመ ማቅዳ። ሳማራ የዘ ጋማ ጉታ ዎንገለ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ላꬄ ኪታንቾ ፍልጶሳጎ፥ «ደንዲ የሩሳላመፓ ጋዛ ካንግዘ አኮ ባይዘ ጋናሳ ኦግዘራ Ꮉንጎ። ይና ኦግታ ዬካ ዛላራ የነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ፍልጶሳ ደንዲ ቅትዳ። ህንደኮ ጋዘ ቶጰ ካትስ እ ሚሽቶ ኡባ ናግዘ ቶጰ አስ የነ። ኤዝን ጎይኖደስ የሩሳላመ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ፋራ ጋረላ በቲ፥ የሩሳላመፓ ፋ ሳአ ማቅተራ ናበ ኢሳያሳ ማጻፈ ናባባነ። ");
INSERT INTO oyde_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ጌሽ አያና ፍልጶሳጎ፥ «የ ጋርዘጎ Ꮉንግ ኤ ካለ ሺቆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ዬዝን ፍልጶሳ ዎጺ Ꮉንግ የልዘ ዎደ ሞርንዘ ናበ ኢሳያሳ ማጻፈፓ ናባቦደራ ስእ፥ «ነ ናባብዛና ኔስ ገላነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ሞርንዘ «ታስ ኦህ ገልꬅዘ አስ ባይዝን ዋይዝ ገሎደ?» ያጋይዳ። ፋራ ጋርዘላ ኬዚ በቶደ ፋና ፍልጶሳ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ሞርንዘ ናባብዘ ማጻፈ ክፍልዘ፥ «ኤ ዱሮ ፋና ሹክንቶደስ እዥንትዳ፤ ዱሮ ናአ ፋ እስንꬅቶ ሜድዙንꬅ ቲኖ ስእ ጋዛን ፋና፥ ኤዝን ፋ ዶንቶ ቡግካያ። ");
INSERT INTO oyde_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ኤ ቶችንትዳ፤ ኤስ ጽሎ ፍርዳ ꬋብዳ። ኤ ደእታ Ꮉና ሳእትፓ Ꮉልእደ ግሾ ኤ የለቱንꬃፓ ኦኒ ኦሆደ?» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ሞርንዘ ማህ ፍልጶሳጎ፥ «ናብዘ ኦባዝ ኦሄ? ፋ ባዝ ኦህነን ዎይ መለ አስ ባዝ ኦህነ? ታስ ኦሆያ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፍልጶሳ ማህ፥ ጾዘ ቃላ ይና በስትፓ አይኪ፥ የሱሳ ባዝ ኦህዘ ዎንገለ ኤስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ኡን Ꮉንግተር Ꮉꬅ የዘ በሳ የልዳ። ሞርንዘ፥ «Ꮉꬅ Ꮉኖ ቦኦ፤ ታ ጻማቅንታመ ፋና አኮ ካይዘ?» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ፍልጶሳ ኤጎ፥ «ኔኒ ነ ኩሙꬅ ዎዝናፓ አማንኮ ዳንዳአነ» ጋይዳ። ኤ ማህ፥ «የሱስ ክርስቶሳ ጾዘ ናአ ማቅዳኖ ታ አማናነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ጋርዘ ኤቆደ ፋና ሞርንዘ ኪትን፥ ላምኡንꬅ ዎꬊ Ꮉꬃ ገልዳ፤ ፍልጶሳን ኤዛ ጻማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ኡን Ꮉꬅትፓ ጋጻ ከዝደ ዎደ ላꬄ አያና ፍልጶሳ ቆፕካይዝን ኤክዳ። ላምእንꬃ ሞርንዘ ፍልጶሳ ብእካያ፥ የዝን ፋ ኦግቶ ኡፋይትተር ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ፍልጶሳ አዛጦነ በንትዳ። ማህ ቂሳርያ የኦደ ዎንꬅስ ካታማር ዉቲ ዎንገለ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","የ ዎደ ሳዉላ ላꬅ ታማሩንꬃና ዎꬎደስ ማንዲ ካህኑንꬅ Ꮉላቅዘጎ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ላꬂ ኦግቶ ካልዘ ꬊራꬁንꬃናን ማቹንꬃና ደንግኮ፥ አጭተራ የሩሳላመ ኮኦደስ፥ ደማስቆ የዘ አይሁደ ዎሳ ኬꬅስ ዳብዳበ ጻፍንቶደ ጋር ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ኤ Ꮉንግ፥ ደማስቆ ካታማ የሎደስ ኡኮደራ፥ ቆፕካይዝን ሳሎፓ ዳማ ፎኦ ኤ ካንተ ፎእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ኤ ሳእተ ጎልእን፥ «ሳዉላ፥ ሳዉላ፥ አኮስ ታና ባይኤ?» ጋዘ ቃላ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ሳዉላ፥ «ላꬆ፥ ነ ኦደ?» ያጋእ ኦጭዳ። «ታኒ፥ ነ ባይእዘ የሱሳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ላꬂ ኤጎ፥ «ደንዲ ካታማ ገሎ፤ ነ ኦቾደስ ኮሽዘ ባዝ እዘ ኔስ ኦሆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ሳዉላራ ኦግቶ Ꮉንዘ አሱንꬅ አኮን ኦህካይዛራ ኤቂ አትዳ። ኦꬅቶ ስእነ፥ የዝን ኦና የዛኮን ብእካያ። ");
INSERT INTO oyde_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳዉላ ጎልእደ በስትፓ ደንዲ በእዘ ዎደ ኤ ኣፍታ ደንጋንጽዳ። ይኒ ግሾ፥ ኡን ኤ ኩሽቶ አይኪ ካልꬅ ዳማስቆ ገልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ꮉይꬕ ቃማ የሎደስ ኤ በአደስ ዳንዳእካያ፤ አኮን ሙእካያ፤ ኡዥካያ። ");
INSERT INTO oyde_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ዳማስቆ ግዳ ፈቲ ሀናንያ ጋዘ የሱሳ ታማርዘ የነ። ላꬂ ቆንጭꬃራ፥ «ሀናንያ» ያጋእ ጼግዳ። ሀናንያ ማህ፥ «ታ ላꬆ፥ ዮ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ላꬂ ኤጎ፥ «ደንዲ ሞሎ ጋእንትዘ ኦግቶ Ꮉንግ፥ ይሁዳ ኬꬃ ሳዉላ ጋዘ ተርሰሰፓ የኤዘ አꬃ ኮዮ፤ ሳዉላ Ꮉተ ዎሳላ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ማህ ሀናንያ ጋዘ አꬄ ገሊ፥ ሳዉላ ላምእንꬃ በአደ ጋር ፋ ኩሽቶ ኤላ ጋዶደራ ቆንጭꬃራ ብእዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ሀናንያ ማህ፥ «ላꬆ፥ የሩሳላመ ነ ጌሽ አሱንꬃላ የ አꬄ አኮ ጋር ኢታ ባዝ ኦቼዛኮ ታ ጋማ አሳፓ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ማህ ዳማስቆ ግዳ ነ ሱንꬅቶ ጼግዙንꬃና ኡባ አጮደስ፥ ካህኑንꬅ Ꮉላቁንꬅ ኤስ አደትꬅ ዎልቃ እንግዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","የዝን ላꬂ ኤጎ፥ «ሳዉላ አይሁደ ማቆሰ አሱንꬅ ቲኖ፥ ካቱንꬅ ቲኖን እስራኤለ አሱንꬅ ቲኖን፥ ታ ሱንꬅቶ ቶኮደስን ታስ ኦቾደስ ዶርንትደ ሚሸ ማቅደ ግሾ ነ ኤጎ ቅቶ። ");
INSERT INTO oyde_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","አኮስ ጋይኮ፥ ታ ሱንꬅት ግሾ ኤ ዋንꬅ ማꬋ ኤኮደስ ኮሽዛኮ ታ ኤዛ ቤሳዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ሀናንያ Ꮉንግ፥ ኬꬃ ገሊ፥ ፋ ኩሽቶ ሳዉላላ ጋዲ፥ «ታ እሸ ሳዉላ፥ ነ ይእዘ ኦግተ ኔስ በንትደ ኤ ላꬄ የሱሳ፥ ነ በአደ ጋራን ጌሽ አያናራ ኩሞደ ጋር ታና ኪትዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ኤልሲ፥ ሳዉላ ኣፍትፓ ፈቲ ቁሮ ፋና የዘ ባዝ ዎꬍን፥ ሳዉላ ላምእንꬃ ብእዳ። ማህ ደንዲ ጻማቅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ካꬃ ሙእ ምንግዳ። ዳማስቆ ግዳ የዘ ታማሩꬃራ ኤራꬅ ቃማ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ኤሊሲ ሳዉላ፥ «የሱሳ ጾዘ ናአ» ያጋእ ዳማስቆ ግዳ የዘ አይሁደ ዎሳ ኬꬃ ቃላ ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ይኖ ስእዘ ኡቡንꬅ ቆፒ፥ «Ꮉይ የሩሳላመ የሱሳ ሱንꬅቶ ጼግዙንꬃና ባይእዛያ ባነ? ማህ Ꮉይጋ ይእዳና ኡንታና አጪ፥ ካህኑንꬅ Ꮉላቁንꬅ ቲኖ ካንጎደስ ባነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","የዝን ሳዉላ ቃላ ኦሄራ ሚንግተር Ꮉንግዳ። የሱሳ፥ ኤ ክርስቶሳ ማቅዳኖ ቆንጭዝ ኦህደ ግሾ ዳማስቆ ግዳ የዘ አይሁዱንꬅ ኤስ ማሆደባዝ ꬋብዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ጋማ ቃማፓ ማቂ አይሁዱንꬅ ሺቂ፥ ሳዉላ ዎꬎደስ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","የዝን አይሁዱንꬅ ፋና ዎꬎደስ ቆፕዳኖ ሳዉላ ኤርዳ። ኡን ኤዛ ዎꬎደስ ቃማን አዋራን ካታማ ፉርꬅተ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ማህ ኤ ታማሩንꬅ ኤዛ ቃማ ካንግ፥ ግምበ ጋሰ ዉሉንቀራ ኬሲ ዳቾራ ኬꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳዉላ የሩሳላመ የልደ ዎደ አማንዙንꬃራ የልንቶደስ ቆፕዳ። የዝን ኤ ክርስቶሳ አማንዳና ኡንትስ ቱሮ አዛንጽ እጽን ኤስ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","የዝን ባርናባሳ ሳዉላ ሐዋሩንꬃጎ ካንግዳ። ኦገ ላꬂ ዋይዝ ቆንጨዛኮን ኦህዘዛኮ፥ ማህ ሳዉላ ዳማስቆ ግዳ የሱሳ ሱንꬅተ ዣሽትካይዛራ ዋይዝ ቃላ ኦሄዛኮ ኡንትስ ጌሽ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ሳዉላ የሩሳላመ ዉቲ ላꬄ ሱንꬅተ ዣሽትካይዛራ ቃላ ኦህተራ፥ ሐዋሩንꬃራ ዎላ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ማህ ሳዉላ ግርኬ ዶና ኦህዘ አይሁዱንꬃራ ኦህንት ላልዳ። የዝን ኡን ኤዛ ዎꬎደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","አማንዘ አሱንꬅ ይኖ ስእ፥ ሳዉላ ቂሳርያ ካንግ ተርሴሰ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ይሁዳ፥ ጋልላን ሳማራን ኡባ ግዳ የዘ ዎሳ ኬꬅታ ሳሮራ የዝዳ። ማህ ምንግዳ፤ ላꬅስ ዣሽትተር ጌሽ አያና ሚንꬅꬆደራ ጋንግተር Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጴጥሮሳ ሳአ ኡባ ዉቲ ሊዳ የዘ አማንዘ አሱንꬃጎ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","እዘ ኦስፉን በረ ኩሙꬅ ዎቢ ዪꬃ ዎይእ የዘ ኤንያ ጋዘ አꬃ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጴጥሮሳ፥ «ኤንያ፥ የሱስ ክርስቶሳ ነና ፋꬆዳ፤ ደንዲ ነ ይꬅቶ ደንꬆ» ያጋይዳ። ኤዝን ኤልሲ ደንዲ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ሊዳን ሳሮናን የዘ አሱንꬅ ኡባ ኤንያ ብእ፥ ላꬃጎ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","እዮጰ ካታማ ፈቲ ጻብቶ ጋዘ አማንዛና የነ። (ጻብቶ ጋእንትዛና ገንኤ ጋእንተ) እዛ ፋ የዝደ ዎድተ ኡባ ሎኦ ባዝ ኦችተራን ዳሁንꬃና ማድተ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","የ ዎደ እዛ Ꮉርግንቲ Ꮉይቂን፥ አሱንꬅ እ አህቶ ሜጪ፥ ፎቀላ ኬሲ ዎይꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ሊዳ እዮጰስ ካለ። አማንዙንꬅ ጴጥሮሳ ሊዳ የዛኖ ስእ፥ «ዎይአ ኑጎ ኤልሲ ዮኦ» ያጋዘ ኪታ ላምእ አሳራ ኤጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ይኒ ግሾ፥ ጴጥሮሳ ደንዲ፥ ኡንታራ ቅትዳ። የይጋ የልን፥ ፎቀላ የዘ ክፍልተ ኤዛ ገልꬅዳ። አዝን ባይዘ ማቹንꬅ ጴጥሮሳ ካንተ ኤቂ ዬክተራ ዶርቃ ኡንታራ ፋጻ የዝተራ ማእደ ቃምስቶን አፉልቶ ኡባ ጴጥሮሳ ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ጴጥሮሳ ኡንታና ኡባ ባለ ኬሲ፥ ቡንቁንቲ ጾዝ ዎስዳ። ማህ አህትጎ ማቂ፥ «ጣብተ፥ ደንዶ» ያጋይዳ። ጣብታ ፋ ኣፍቶ ቡጊ ጴጥሮሳ ብእ፥ ደንዲ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ጴጥሮሳ እዞ ፋ ኩሽተ ካትዚ ደንꬂ ኤስዳ። ይንፓ ማቂ፥ አማንዙንꬃናን አዝኒ ባይዙንꬃና ጼጊ፥ ኡን ቲኖ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ꮉና ኦህታ እዮጰ ካታማ ኡባ የልዳ። ጋማ አሱንꬅ ላꬃ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ጴጥሮሳ እዮጰ ስሞና ጋዘ ቆለ Ꮉሽዘ ካራ ጋማ ዎደ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ቂሳርያ፥ «ጣልያ ኦላ አሱንꬃና» ጋእንትዘ ኦልንትዙንꬅ ግዳ ፈቲ ቆርነልዮሳ ጋእንትዘ ማቶ Ꮉላቃ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ቆርነልዮሳ ፋ ካራ አሱንꬃራ ጾዝ ጎይንዛን ዣሽትዘ አስን፥ ዳሁንꬃና ማዳነ፥ ማህ ኡባ ዎደ ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ፈቲ ዎደ ኡዱፉን ሳተ ኩምዝን ጾዝ ኪታንቾ ኤጎ ይእ፥ «ቆርነልዮሳ» ጋእ ጼጎደራ ኤ ቆንጭꬃራ ጌሽ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ቆርነልዮሳ ዣሽቲ ኪታንችዛ ዳኪ ሎይꬂ ብእ፥ «ላꬆ፥ ይና አኮ?» ያጋይዳ። ኪታንችዘ ማህ፥ «ነ ዎስታን ዳሁንꬃና ነ ማድዳና ጾዘ ቲኖ ቆፍንተስ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ꮉተ አሱንꬃና እዮጰ ዳኪ፥ ጴጥሮሳ ጋዘ ስሞና ክእዞ። ");
INSERT INTO oyde_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ጴጥሮሳ አባ ጋጻ ቆለ Ꮉሽዘ ስሞና ካራ ዛቆተꬅ በትዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ቆርነልዮሳ ፋስ ኦህደ ኪታንችዘ ቅትን፥ ፋ አሩንꬃፓ ላምኡንꬃና ጾዝ ጎይንዘ ፋ ካለ የዘ ዎታዳሩንꬃፓ ፈታ ጼጊ፥ ");
INSERT INTO oyde_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ኡንትስ ኦህ እዮጰ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ዎንትስት ዎደ ኡን Ꮉንግ፥ እዮጰ ካታማ ኡኮደራ እዝፑን ሳተ ጋር የዝን ጾዝ ዎሶደስ ጴጥሮሳ ፎቀላ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ኤ ናይꬊ ካꬃ ማደስ ኮይዳ፥ የዝን ካꬃ ካጾደራ ኤ አያናራ ማቂ ቆንጭꬅ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ሳሎ ቡጉንትን፥ ዳማ አፉላ አዝዘ ባዝ ኦይዲ ዛላራ አይክንቲ ዎꬎደራ ኤ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","እዛ በስተ ኦይዲ ቶሄራ የዘ ጉርደ ጾꬅ፥ ሳዛራ ጎችንትዘ መትꬅን ሳሎ ላንዳ ኡባ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","የ ዎደ «ጴጥሮሳ፥ ደንዲ ኤቂ ሹኪ ሞኦ» ጋዘ ቃላ ኤጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","የዝን ጴጥሮሳ፥ «ላꬆ፥ አደ! ታ ቱና ባዝ ሙሎን ሙእ ኤሮስ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ማህ፥ «ጾዚ ጌሽዳኖ ነ ቱና ጋእፐ» ጋዘ ቃላ ላምእንꬃ ኤጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ይናን፥ Ꮉይꬕ ቶሄ ይእዳንፓ ማቂ የ ዳማ አፉላ አዝዘ ኤልሲ ኡደ ሳሎ ኤክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጴጥሮሳ ፋ በኤዘ ቆንጭꬅት ብልꬅታ፥ «አኮ ማቃድ የሳ?» ጋእ ፋ ዎዝንተ ቆፖደራ፥ ቆርነልዮሳ ኪተዘ አሱንꬅ ስሞና ካራ ኦጪ ደንግ ባለ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ፋ ቃልቶ ኡን ꬎቅ ዪዚ፥ «ጴጥሮሳ ጋዘ ስሞና ዛቆትꬅ የዘ Ꮉነ የነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጴጥሮሳ ቆንጭꬃራ ብእዳኖ ታዎደራ፥ ጌሽ አያና ኤጎ፥ «Ꮉይቼ፥ Ꮉይꬕ አሱንꬅ ነና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ደንዲ ዎꬎ፥ ታ ኡንታና ኪተዘ ግሾ ሶእካይዛራ ኡንታራ ቅቶ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጴጥሮሳ አሱንꬃጎ ዎꬊ፥ «ይን ኮይዘ ታና፤ አኮስ ይእዶተ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ኡን ማህ፥ «ኑና ማቶ Ꮉላቅዘ ቆርነልዮሳ ኪትዳ። ኤ ጽሎ፥ ጾዝ ጎይንዘ አስን አይሁደ አሱንꬅ ግዳ ኡባ ጋማ ቦንችንትደ አስ። ቆርነልዮሳ፥ ነና ፋ ካራ ክእዚ ቃላ ኔፓ ስኦደ ፋና ጌሽ ኪታንቾ ኤስ ኦህዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ጴጥሮሳ አሱንꬃና ኬꬃ ገልꬂ ሞክዳ። ዎንትስት ዎደ፥ ደንዲ ኡንታራ ቅትዳ። እዮጴ ካታማ የዘ አማንዙንꬃፓ ፈቲ ፈቲ አሱንꬅ ኤራ ዎላ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ዎንትስት ዎደ፥ ቂሳርያ የልዳ። ቆርነልዮሳ ፋ እግኑንꬃናን ፋ ካለ ላጉንꬃና ፈትላ ጼጊ ሺሺ፥ ጴጥሮሳ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጴጥሮሳ ኬꬃ ገሎደስ ይአደራ፥ ቆርነልዮሳ ኤራ የልንት ኤ ቲኖ ጎልእ ኤስ ጎይኖደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","የዝን ጴጥሮሳ፥ «ደንዶ፥ ታንን ታ ኦምተ ነ ጋር አስ» ያጋእ ኤዛ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ጴጥሮሳ ቆርነልዮሳራ ኦህተራ ኬꬃ ገልዘ ዎደ ጋማ አሱንꬅ ሺቅዳኖ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ኤ አሱንꬃጎ፥ «አይሁደ አስ መለ ዎርዣራ ዎላ ማቃደስ ዎይ የልንቶደስ ዎጋ ባይዛኖ ይን ኤራነ። የዝን ታኒ ኦደን ቱና ዎይ ጌሽ ጋአመ ጋር ጾዚ ታና ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ይኒ ግሾ፥ ይን ታጎ ኪትን እጽካይዛራ ይእዳ። Ꮉተ ታና አኮስ ጼግዘዛኮ ታስ ኦሆተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ቆርነልዮሳ፥ «ታኒ Ꮉይኖ ኦይዲ ቃማፓ ቲኖ Ꮉኒ ዎደ ኡዱፉን ሳተ ዎሳ ዎሶደራ፥ ፎእዘ ማኦ ማእደ አስ ታ ቲኖ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ኤ ታጎ፥ ‹ቆርነልዮሳ፥ ጾዚ ነ ዎስቶ ስእዳ፥ ኔኒ ዳሁንꬃና ማድዳኖ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ይኬ፥ አስ እዮጰ ኪቲ፥ ስሞን ጴጥሮሳ ጋዛያ ጼግዞ። ኤ፥ ስሞና ጋዘ ቆለ Ꮉሽዘ አꬄ ካራ አባ ጋጻ በትዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ይኒ ግሾ፥ ታ ኔጎ ኤልሲ ኪትዳ፤ ነ ይእዳና ሎኦ። ይኬ፥ ጾዚ ነና ኪትደባዝ ኡባ ስኦደስ Ꮉተ ኑ ኡቡንꬅ Ꮉነ ላꬄ ቲኖ የነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ካሊ፥ ጴጥሮሳ፥ «ጾዚ አስስ ስኖ ብእ አስ አሳፓ ሻጎስ። ");
INSERT INTO oyde_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","የዝን አስ ኡባ ኦና ማቅኮን ፋስ ዣሽትዛያን ጽሎ ኦቻ ኦችዘላ ጾዚ ኡፋይትዛኖ ታ ቱሮ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ጾዚ፥ ኡቡንꬅ ላꬂ ማቅደ የሱስ ክርስቶሳ ባጋራ ሳሮትꬅ ኦህተራ Ꮉና ዎንገልቶ እስራኤለ አሱንꬅስ ኪተዛኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ዋሐንሳ ጽንቃተ ባዝ ሳባክደ ዎደፓ አይኪ ጋልላን ይሁዳ ሳአ ኡባ የሎደስ Ꮉንዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ጾዚ ናዝረተ የሱሳ ጌሽ አያናራ ትዢ ዎልቃ እንግዳ። ጾዚ ኤራ የዘ ግሾ ሎኦ ባዝ ኤ ኦችተራ ጻላሄ ኩሸ አቅዱንꬃና ኡባ ፋꬅተራ ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«አይሁደ ሳአን የሩሳላመ ኤ ኦችደ ኡባባዝትስ ኑ ማርካ። ኡን ማስቃላላ ሱጺ ኤዛ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","የዝን ጾዚ Ꮉይꬓንꬃ ዎደ Ꮉይቆፓ ኤዛ ደንꬂ አሱንꬅስ ቆንጮደ ጋር ዪዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ይና ቆንጭꬅታ ጾዚ ቲኖ ዶርደ ማርኩንꬅስ ፋትን አስ ኡባስ ማቆስ። ኤ Ꮉይቆፓ ደንድዳንፓ ማቂ ኤራ ሙእ ኡዥዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ኑ ዎንገለ አሱንꬅስ ኦሆደ ጋራን ፋጻ የዙንꬃላን Ꮉይቂዱንꬃላ ፍርዶደስ ጾዚ ሹምደ የሱሳ ማቅዛኖ ማርክꬋደ ጋር ኑና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ጾዚ ኤዛ አማንዘ ኡባ ናጋርታ፥ ኤ ሱንꬅተ አቶ ጋእንትዛኖ ናቡንꬅ ማርክꬋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጴጥሮሳ Ꮉጋ ይና ኦህቶ Ꮉስካይዝን ቃላ ስእዘ ኡቡንꬃላ ጌሽ አያና ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ጴጥሮሳራ እዮጴፓ ይእደ አማንዘ ጋራዝንትደ አይሁደ ኡቡንꬃላን፥ አይሁደ ማቆሱንꬃላን ጌሽ አያና ዎꬍዳኖ ብእ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","አኮስ ጋይኮ፥ ኡን መለ መለ ዶናራ ኦህተራን ጾዘ ዳማትꬅቶ ሳቦደራ ስእዳ። የ ዎደ ጴጥሮሳ ማህ፥ ");
INSERT INTO oyde_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ꮉንስ ማህ ኑ ጋር ጌሽ አያና ኤክዱንꬅ ጻማቅንታመ ጋር Ꮉꬅ ካዮደ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ኡን የሱስ ክርስቶሳ ሱንꬅተ ጻማቅንቶደ ጋር ኡንታና ኪትዳ። ይንፓ ማቂ፥ ኡን ፋራ ኤራꬅ ዎደ በቶደ ጋር ጴጥሮሳ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ሐዋሩንꬅን ይሁዳ የዘ አማንዙንꬅ፥ አይሁደ ማቆሱንꬅን ጾዘ ቃላ ኤክዳኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ጴጥሮሳ የሩሳላመ ቅትደ ዎደ ጋራዝንትደ አማንዙንꬅ፥ ");
INSERT INTO oyde_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ኤጎ፥ «ነ ጋራዝንትካይዙንꬃጎ ገሊ ኡንታራ ካꬃ አኮስ ሙእዶ?» ጋእ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","የዝን ጴጥሮሳ Ꮉንዳኖ ቲኖፓ አይኪ ታራራ ታራራ ኦህዳ፦ ");
INSERT INTO oyde_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«ታኒ እዮጴ ካታማ ጾዝ ዎስተራ ቆንጭꬅ ብእዳ። ዳማ አፉላ አዝዘ ባዝ ኦይዲ ዛላራ አይክንቲ ሳሎፓ ዎꬍተራ ታጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ታኒ ዳኪ ሎይꬂ ኤ ግድቶ በእዘ ዎደ ኦይዲ ቶሄራ የዘ ጉርደ ጾꬁንꬅ፥ ሳዛራ ጎችንትዘ መꬎን ሳሎ ላንዱንꬃና ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹ጴጥሮሳ፥ ደንዲ፥ ሹኪ ሞኦ› ጋዘ ቃላ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«የዝን ታኒ፥ ‹ላꬆ፥ አደ፥ ቱና ባዝ ዎይ ጌዥካይዘባዝ ሙሎን ዶናጎ ሺሺ ኤሮስ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","« ‹ጾዚ ጌሽዳኖ ኔኒ ቱና ጋእፐ› ያጋዘ ቃላ ላምእንꬃ ሳሎፓ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","«ይና Ꮉይꬕ ቶሄ Ꮉንዳንፓ ሱባ፥ ማቂ ኡባ ባዝታ ሳሎ ኡደ ኤክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ይና ሳተ Ꮉይꬕ አሱንꬅ ቂሳርያፓ ታጎ ኪትንቲ ታ የዘ ኬꬅተ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ሶእካይዛራ ኡንታራ ቅቶደ ጋር አያና ታስ ኦህዳ። ማህ Ꮉና እዝፑን እሹንꬅ እዮጴፓ ታራ ቂሳርያ Ꮉንግዱንꬃራ ቆርነልዮሳ ካራ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ኪታንቾ ኤ ካራ ኤቂ፥ ‹እዮጴ ኪቲ ጴጥሮሳ ጋእንትዘ ስሞና ጼግዞ። ");
INSERT INTO oyde_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ነናን ነ ካራ አስ ኡባ አሽዘ ቃላ ኤ ኔስ ኦሆዳ› ጋይዳኖ ቆርነልዮሳ ኑስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«ታኒ ኦሄ አይክዘ ዎደ ጌሽ አያና ቲኖ ኑላ ዎꬍዳንጋራ ኡንታላን ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","የ ዎደ ‹ዋሐንሳ Ꮉꬃራ ጻማቅዳ፥ የዝን ይን ጌሽ አያናራ ጻማቅንቶዳ› ያጋይደ ላꬄ ቃልታ ታስ ቲርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ጾዚ ኑስ ላꬄ የሱስ ክርስቶሳ አማንዙንꬅስ እንግደ እሞትꬅቶ ማህ እዞ አይሁደ ማቆሱንꬅስን እንግኮ፥ ዬዝን ጾዝ ካዮደስ ታ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ኡን ይኖ ስእደ ዎደ ፋ ላልዛኖ አሺ፥ «ይኖ ማቅኮ፥ ጾዚ አይሁደ ማቆሱንꬅን ናጋራፓ ማቂ ደኦ የሳደ ጋር እጻ እንግዳ» ያጋእ ጾዝ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","እስጢፋኖሳ Ꮉይቆስ የልꬅደ ባይኤ ግሾ ላልንትደ አማንዙንꬅ ቃላ አይሁዱንꬅ ጻላላስ ኦህተራ ስሮፍንቀ፥ ቆጵሮሳን አንጾክያ የሎደስ ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","የዝን ቆጵሮሳፓን ቀሬናፓን ይእደ ፈቲ ፈቲ አማንዘ አሱንꬅ አንጾክያ Ꮉንግ፥ ላꬂ የሱሳ ዎንገለ ግርኬ አሱንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ላꬄ ዎልቃ ኡንታራ የነ፤ ማህ ጋማ አሱንꬅ አማኒ ላꬃጎ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ይና ኦህቶ የሩሳላመ የዘ ዎሳ ኬꬅታ ስእደ ግሾ ባርናባሳ አንጾክያ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ባርናባሳ አንጾክያ ቅትደ ዎደ ጾዘ አꬎ ኬሃትꬅ ኦቻ ብእ ኡፋይትዳ። ኡን ኡቡንꬅ ፋ ኩሙꬅ ዎዝንተ ላꬄ ግዳ ሚንግ የሳደ ጋር ኡንታና ዞርዳ፤ ");
INSERT INTO oyde_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ይኒ ግሾ ባርናባሳ ጌሽ አያናራን አማኖራ ኩምደ ሎኦ አስ። ጋማ አሱንꬅ ላꬃ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ይንፓ ማቂ፥ ባርናባሳ ሳዉላ ኮዮደስ ተርሴሰ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","እዘ ሳዉላ ደንግደ ዎደ አንጾክያ ኤኪ ይእዳ። ባርናባሳን ሳዉላ ዎሳ ኬꬂ አሱንꬃራ ፈቲ በረ ሙሎ በቲ ጋማ አሱንꬃና ታማርስዳ። ታማሩንꬅ አንጾክያ ዎሳ ኬꬃ «ክርስታነ» ጋእንት ቲኒ ጼግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","የ ዎደ ፈቲ ፈቲ ናቡንꬅ የሩሳላመፓ አንጾክያ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ኡን ግዳፓ አጋቦሳ ጋእንትዘ ደንዲ ሳአ ኡባ ዳማ ናየ ኬሳዳኖ አያና ዎልቃራ ትንቢተ ኦህዳ። ይና Ꮉንዳና ሮመ ካት ቃላዉድዮሳ ዎደ። ");
INSERT INTO oyde_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","አማንዙንꬅ ፈተ ፈተ ፋ ዎልቂት ጋር ሚሸ ኬሲ ይሁዳ የዘ አማንዙꬅስ ማደ ዳኮደስ ቆፋ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ኡን Ꮉንጋራ የይዝ፥ ሚሽቶ ባርናባሳራን ሳዉላራን ዎሳ ኬꬃ ጭሙንꬅስ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","የ ዎደ ካት ሄሮድሳ ዎሳ ኬꬂ አሱንꬃፓ ባጉንꬃና ባይኤ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ዋሐንሳ እሸ ያይቆባ ማሻራ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ይና አይሁዱንꬃና ኡፋይስዳኖ ብእ፥ ጉጂ ጴጥሮሳን አይꬅዳ። ይና Ꮉንዳና ቦራ ባአለ ቦንችዘ ቃምተ። ");
INSERT INTO oyde_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ጴጥሮሳ አይኪ አጭዳ። ፋስጋ ቦንችዘ ዎድትፓ ማቂ ዎርዡንꬅ ቲኖ ኣꬆደስ ቆፒ፥ ኦይዲ ኦይዲ ዎታዳሩንꬅ ኤዛ ናጎደ ጋር ታጶ እዝፑን ዎታዳሩንꬅስ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ይኒ ግሾ፥ ጴጥሮሳ አች ኬꬃ ናግንታነ። የዝን ዎሳ ኬꬃ አሱንꬅ ኤስ ምንꬂ ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ሄሮድሳ ጴጥሮሳ አሱንꬅ ቲኖ ሺሾዳንፓ ቲኖ ቃማ ጴጥሮሳ ላምእ ዛላራ ላምእ ዎታዳሩንꬃራን ላምእ ሳንꬃላታራ አጭንቲ ኡን ግዳ ገንትዳ። ናግዙንꬅ አች ኬꬃ ፉርꬅተ ኤቂ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ቲርካይዝን ላꬄ ኪታንቾ በንትዳ። አች ኬꬃ ፎኦ ፎእዳ። ኪታንችዘ ጴጥሮሳ ምልቶ ቦቺ ባርክዚ፥ «ኤለ ደንዶ» ያጋይዳ። ኢራ ሳንꬃላታን ኤ ኩሽትፓ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ኪታንችዘ ኤጎ፥ «ነ ማእቶ ማኦ፥ ነ ጫምቶን ኣꬆ» ያጋይዳ። ጴጥሮሳ Ꮉንጋራ ኦችዳ፤ ኪታንችዘ፥ «ነ ላጽንዛ ማእ ታና ካሎ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ጴጥሮሳ አች ኬꬃፓ ኬዚ ኪታንችዛ ካልዳ። ኤስ ቆንጭꬅ በእዘጋራ ይእዳፕ አትን ኪታንችዘ ኦችዘ ባዝታ ቱሮ አዝካያ። ");
INSERT INTO oyde_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ኪታንችዘን ጴጥሮሳን ቲኖን ላምእንꬃ ናግዘ ዛብዛ አꬊ ካታማ ካንግዘ ብርታ ፉርꬅትጎ የልዳ። ፉርꬅታ ኡንትስ ፋ ፋስ ኤሪ ቡጉንትዳ። ኡን ኬዚ ፈቲ ኦገራ Ꮉንጎደራ ኪታንችዘ ቲርካይዝን ጴጥሮሳፓ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ጴጥሮሳስ ዎዝንታ ማቅን፥ «ታና ላꬂ ፋ ኪታንችዛ ዳኪ፥ ሄሮድሳ ኩሽትፓን ናጊ በትደ አይሁደ አሱንꬅ ኡባፓ አሽዳኖ Ꮉተ ቱሮ ኤርዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ኤ ይኖ አካክደ ዎደ ጋማ አሱንꬅ ዎላ ሺቂ ጾዝ ዎስዘ በስተ፥ ማርቆሳ ጋዘ ዋሐንሳ እንታ ማይራም ካራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","እዘ ባለ ኤቂ ጼግዳ። ፈቲ ሮዳ ጋእንትዘ አርታ ፉርꬅቶ ቡጎደስ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ሮዳ ጴጥሮሳ ቃላ ማቅዳኖ ኤርደ ዎደ ኡፋይሳር ኩሚ ፉርꬅቶ ቡግካይዝን ሱብ ዎጺ Ꮉንግ፥ «ጴጥሮሳ ባለ ኤቅዳ» ያጋእ አሱንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","አሱንꬅ ኢጎ፥ «ነ ዣሽታነ!» ያጋይዳ። ሮዳ ጴጥሮሳ ማቅዳኖ ጌሽ ኦህዳ። ኡን፥ «የ ኤ ኪታንቾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","የዝን ጴጥሮሳ ባለ ኤቂ ጼጊ አሻንጽን አሱንꬅ ፉርꬅቶ ቡጊ ኤዛ ብእ ጋማ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","የዝን ኡን ስእ ጋዉደ ጋር ጴጥሮሳ ፋ ኩሽተ ማሊ ላꬂ አች ኬꬃፓ ኤዛ ዋይዝ ኬሰዛኮ ኡንትስ ቆንጭዝ ኦህ፥ «Ꮉኖ ያይቆባስን አማንዘ አሱንꬅስ ኦሆተ» ጋእ እዝፕ ኬዚ መለ በሳ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ሳአ ዎንትዘ ዎደ «ጴጥሮሳ አባ ቅትዶ?» ጋእ ዎታዳሩንꬅ ዎል ግዳ ጋማ ካጭንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮድሳ ጴጥሮሳ ኮይዝን፥ ኤ ꬋብደ ዎደ ናግዙንꬃና ቁሪ፥ ኡንታና ዎꬎደ ጋር ኪትዳ። ይንፓ ሱባ፥ ሄሮድሳ ይሁዳፓ ቂሳርያ ዎꬊ እዘ ኤራꬅ ዎደ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ሄሮድሳ ጢሮሳ አሱንꬃላን ስዶና አሱንꬃላ ጋማ ካጭዳ። ኡን ዎላ ፈትላ ይእ ካት ሞርና ብላስጦሳ ማድንቶደ ጋራ ዎሲ ዬኤ ጋእዚ ፋስ ጭማ ማህ ጊጎደስ ሄሮድሳጎ Ꮉንግዳ። ኡን ጋድታ ካꬃ ካትዘ ጋደፓ ደንጋነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ሄሮድሳ ሹምንትደ ዎደ ፋ ካእቱሞ አፉልቶ ማእ፥ አራታላ በቲ አሱንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","አሱንꬅ፥ «ይና ጾዘ ቃላ፥ አስ ቃላ ባያ» ያጋእ ዉይስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ሄሮድሳ ጾዝ ቦንችካይዘ ግሾ ኢራ ላꬄ ኪታንቾ ኤዛ ጉድን ዛቅላራ ሙእንት Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","የዝን ጾዘ ቃላ ድጭተራን ዳልግተራ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ባርናባሳን ሳዉላን ፋ ኦችቶ ፋዲ ማርቆሳ ጋዘ ዋሐንሳ ፋራ ኤኪ የሩሳላመፕ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","አንጾክያ የዘ ዎሳ ኬꬃ ናቡንꬅን አስታማሩንꬅን የነ። ኡን ባርናባሳ፥ ካርꬅ ጋእንትዘ ስሞና፥ ቀሬናፓ ይእደ ሉክዮሳ፥ ካት ሄሮድሳራ ድጭደ ምናሄነን ሳዉላን። ");
INSERT INTO oyde_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ኡን ላꬂ ጎይኖደራን ጾሞደራ ጌሽꬅ አያና፥ «ታኒ ጼግደ ኦችትስ ባርናባሳን ሳዉላን ታስ ሻኮተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ይኒ ግሾ፥ ኡን ጾምዳንፓን ዎስዳንፓ ማቂ ፋ ኩሽቶ ኡንታላ ጋዲ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ይኒ ግሾ፥ ጌሽ አያና ኡንታና ኪትዳ። ሰለዉቀ Ꮉንግዳ፤ ኢፓ ማርካበ ግዳ ገሊ ቆጵሮሳ Ꮉꬃራ ተቅንትደ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ኡን ስልማና የሊ አይሁደ ዎሳ ኬꬃ ጾዘ ቃላ ኦህዳ። ዋሐንሳ ማድተራ ኡንታራ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ኡን ቆጵሮሳ Ꮉꬃራ ተቅንትደ ሳአ አꬊ ጳፉ የልዘ ዎደ ፈቲ ዎርዶ ናበ ባር-የሱሳ ጋዘ አይሁደ ማሮ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","የ ማርዘ ዎርዣ አህዘ ሳርግዮሳ ጳዉሎሳ ጋዘ ቆፋራ የዘ አꬄራ የነ። ሳርግዮሳ ጳዉሎሳ ባርናባሳን ሳዉላን ፋጎ ጼጊ ጾዘ ቃላ ስኦደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","የዝን ግርኬ ዶናራ ማርዛይ ሱንꬅታን «ኤልማሳ» ጋእንታነ። ኤ ጋደ አህዘ አማናመ ጋር ካዮደስ ኮይ ባርናባሳን ጳዉሎሳን እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","የዝን ጳዉሎሳ ጋዘ ሳዉላ ጌሽ አያናራ ኩሚ ማርዛያ ዳኪ ብእ፥ ");
INSERT INTO oyde_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«ናተ፥ ጻላሄ ናአዮ፥ ኢታትꬅ ኡባ ኩምዳዮ፥ ጽሎትꬅ ኡባስ ሞርክዛዮ፥ ሉለ ላꬄ ኦግቶ ምርቅዛኖ አሾሶ? ");
INSERT INTO oyde_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ይኬ፥ Ꮉተ ላꬄ ኩሸ ኔላ የነ። ነ ቆቀ ማቃዳ፤ ኤራꬅ ዎደስ አዋ ፎኦ በአማ» ያጋይዳ። ኢራ ቃይቃዮን ꬉማን ኤ ኣፍቶ ጎዝን፥ ፋ ኩሽቶ አይኪ ካልꬅዘ አስ ኮይተራ ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ጋደ አህዘ ይኖ ብእደ ዎደ ላꬄ ባዝ ታማርስዛነ ጋማ ቆፒ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ጳዉሎሳን ኤራ የዙንꬅ ጳፉፓ ደንዲ፥ ጵንፍልያ የዘ ጰርገ ማርካበራ ቅትዳ። ዋሐንሳ ኡንታፓ ሻክንት የሩሳላመ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","የዝን ኡን ጰርገፓ አꬊ ጵስድያ የዘ አንጾክያ የልዳ። ሳምባታ ዎደ አይሁደ ዎሳ ኬꬃ ገሊ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ሙሴ ህግቶን ናቡንꬅ ማጻፍታን ናባብንትዳንፓ ማቂ አይሁደ ዎሳ ኬꬂ Ꮉላቁንꬅ፥ «ኑ እሹንꬆ፥ አስ ምንꬅꬅዘ ቃላ ይንትስ የዛኮ አሱንꬅስ ኦሆያተ» ጋእ ኡንታጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ጳዉሎሳ ደንዲ ኤቂ ፋ ኩሽትራ ማልተራ፥ «እስራኤለ አሱንꬅስ፥ ማህ ጾዝ ጎይንዘ አይሁደ ማቆሰ አሱንꬆ፥ ስኦተ። ");
INSERT INTO oyde_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ꮉንꬅ እስራኤለ አሱንꬅ ጾዘ፥ ኑ ማይዙንꬃና ዶርዳ። ግብጸ ሳአ ዛቆትꬃ ኡን የሳደራ፥ ኡንታና ጋንꬅ ፋ ዳማ ዎልቃራ ግብጸ ሳአፓ ኡንታና ከስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","አኮ ባይዘ ሳአ ኦይታም በረ ጋር ኡንታና ዳንዳእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ካናነ ሳአ አይሁደ ማቆሰ ላፑን ካእቱሞ ካይ ኡን ጋድቶ ፋ አሱንꬃና ላትዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ይና ኡባ Ꮉንዳንፓ ኦይዲ ጼት እችንታም በረ ማቅዳ። ይንፓ ማቂ ሳሙኤላ ዎደ የሎደስ አህዘ ዳይና ኡንትስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ይንፓ ማቂ፥ ኡን ፋስ ካት እንጎደ ጋር ዎስን፥ ጾዚ ብንያመ ኮቻፓ ቂሰ ናአ፥ ሳኦላ ኦይታም በረ ካእቶደ ጋር ኡንትስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ጾዚ ሳኦላ ሻርዳንፓ ማቂ ኡንታላ ዳዉተ ካእꬅዳ። ጾዚ ዳዉተባዝ ማርክꬍተ፥ ‹ታ ዎዝንት ጋር ማቅዳያ ታ ቆፍቶ ኡባ ኦችዛ እሰይ ናአ ዳዉተ ደንግዳ› ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«ጾዚ፥ ታኒ ዳዉተ ኮቻፓ እስራኤለ አሱንꬃና ኡፋይስዛ ኮኦዳ ጋይዳን ጋር የሱሳ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","የሱሳ ዮኦዳንፓ ቲኖ እስራኤለ አሱንꬅ ኡባ ፋ ናጋርትፓ ማቂ ጻማቅንቶደ ጋር ዋሐንሳ ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ማህ ዋሐንሳ ፋ ኦችቶ ፎሎደስ ይእተ አሱንꬃጎ፥ ‹ታና ኦና ጋእ ቆፐተ? ታኒ ይን ናግዘ ክርስቶሳ ባያ፥ የዝን ታ ኤ ጫማ ብሎደስ ታስ ቤዞሰ ታፓ ሱብተ የእነ› ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«እሹንꬆ፥ አብራሃማ ኮቹንꬆ፥ ማህ Ꮉነ አይሁደ ማቅካይዛራ ጾዝስ ዣሽትዙንꬆ፥ Ꮉና አሽዘ ቃልታ ኑስ ኪትንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","አኮስ ጋይኮ፥ የሩሳላመ የዘ አሱንꬅን ኡን Ꮉላቁንꬅ የሱሳ ኤርካያ። ሳምባታ ኡባነ ናባብንትዘ ናቡንꬅ ቃልቶ ቲሪካይዘ ግሾ ኤዛላ ፍርድ ናቡንꬅ ኦህደ ቃልቶ ፎልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","የሱሳ ዎዽሳደስ ፈቲ ምክናተን በንታንጽን ጵላጦሳ ኤዛ ዎꬎደስ እንጎደ ጋር ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ኡን የሱሳ ባዝ ጌሽ ማጻፍተ ጻፍንትዳኖ ኡባ ፎልደ ዎደ ማስቃላፓ ኤዛ ኬꬂ ሞግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","የዝን ጾዚ Ꮉይቆፓ የሱሳ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ይንፓ ማቂ፥ ኤ ፋራ ጋልላፓ የሩሳላመ ይእዱንꬅስ ጋማ ቃማ በንትዳ። ኡን Ꮉተ ኤ ባዝ አሱንꬅስ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«ጾዚ ኑ አዱንꬅስ እንጎዳ ጋይደ ዎንገለ ኑኒ ይንትስ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ዳዉተ ፋ ማዝሙረ ማጻፍተ ላምእንꬃ ዞፋንተ፥ « ‹ኔኒ፥ ታ ናአያ፥ ታ Ꮉይኖ ነና የልዳ› ጋእንት ጻፍንትደ የሱሳ፥ ጾዚ Ꮉይቆፓ ደንꬂ ኑ ማይዙንꬅስ እንጎዳ ጋይዳኖ ኑስ ኡን ናኡንꬅስ ፎልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ኤ ዎቃመ ጋር ጾዚ Ꮉይቆፓ ኤዛ ደንꬅተ ኤርሶደስ፥ « ‹ታኒ ዳዉተስ እንጎዳ ጋይደ አማንንትደ ጌሽ አንጆ ይንትስ እንጎዳ› ያጋእ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«ይኒ ግሾ፥ ማዝሙረ ማጻፍተ መለ በሳ ማህ፥ « ‹ነ ጌሽዘ አህቶ ዎቂዞስ› ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«ዳዉተ ፋ ዎደ ጾዘ ቆፍቶ ፎልዳንፓ ማቂ Ꮉይቂ ፋ አዱንꬃራ ሞግንቲ ዎቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","የዝን ጾዚ Ꮉይቆፓ ደንꬅዳይ ዎቂካያ። ");
INSERT INTO oyde_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«ይኒ ግሾ፥ ታ እሹንꬆ፥ ናጋራ አሽዘ የሱሳ ባጋር ቲንꬊ ይንትስ ኦህንትዳኖ ኤሮተ። ሙሴ ህግታ ናጋራፓ ጽልሳደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","የዝን የሱሳ አማንዘ ኡቡንꬅ ናጋራፓ ጽላነ። ");
INSERT INTO oyde_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ይኒ ግሾ፥ ናቡንꬅ ጋይዳና ይንታና የላመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","« ‹ጾዚ ጋይደባዝ ለቂዙንꬆ! ቦኦተ! ጋማ ቆፖተ! ꬋቦተ! ኦደን ኦህን፥ ይን አማኖሰ ኦቻ ታ ይን ዎድተ ኦቾዳ› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ጳዉሎሳን ባርናባሳን አይሁደ ዎሳ ኬꬃፓ ከሳደራ፥ ካልዘ ሳምባታ ይኖ ጉጂ ኦሆደ ጋር አሱንꬅ ኡንታና ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ሺቅታ ላንትዳንፓ ማቂ ጋማ አይሁዱንꬅን አይሁዱንꬅ አማንተ ገሊ ጾዝ ጎይንዘ ጋሙንꬅ ጳዉሎሳን ባርናባሳን ካልዳ። አማንዱንꬂ ጾዘ አꬎ ኬሃትꬅተ ምንꬂ የሳደ ጋር ኡንታና ዞርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ላምእንꬃ ሳምባታ ካታማ የዘ አሱንꬃፓ አትደ ባያ ያጋዉደ ዎንꬅስ ጾዘ ቃላ ስኦደስ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","የዝን አይሁዱንꬅ ጋማ አሱንꬃና በኤዘ ዎደ ጳዉሎሳ አንꬅንቲ ኤ ኦህቶ እጺ ኤዛ ጫዥዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ጳዉሎሳን ባርናባሳን ዣሽትካይዛራ፥ «ጾዘ ቃልታ ቲንꬊ ይንትስ ኦህንቶደስ ቤዛነ። የዝን ይን ቃላ እጺ መዽና ደኦ ኤኮደስ ኑስ ቤዞስ ጋእ ይን፥ ይን ኦምተ ፍርድደ ግሾ ይኬ ኑኒ አይሁደ ማቆሱንꬃጎ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","አኮስ ጋይኮ ላꬂ፥ « ‹አላመ ኩሙꬅታ ነ ባጋራ አቶደ ጋር፥ ታ ነና አይሁደ ማቆሰ አሱንꬅስ ፎኦ ማህዳ› ጋእ ኑና ኪትዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","አይሁደ ማቆሱንꬅ ይኖ ስእደ ዎደ ኡፋይት ጾዘ ቃላ ቦንችዳ። ማህ መዽና ደኦስ ዶርንትደ ኡባ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ላꬄ ቃልታ ይና ሳእቶ ኡባ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","የዝን አይሁዱንꬅ፥ አይሁደ ማቆሰ ጾዝ ጎይንዘ ቦንችንትደ ማቹንꬃናን ካታማ የዘ ዳማ አሱንꬃና ጳዉሎሳላን ባርናባሳላን ደንꬅꬅዳ። የንꬅ አሱንꬅ ኡንታና ባይኤ አይኪ ፋ ሳእትፓ ከስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","የዝን ጳዉሎሳራን ባርናባሳራን እጽዙንꬅስ ማላ ማቃደ ጋር ፋ ቶህትፓ ጹራ ፍጺ እቆንዮነ ካታማ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ማህ አንጾክያ የዘ አማንዙንꬅ ጌሽ አያናራን ኡፋይሳራ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ካሰንጋራ፥ ጳዉሎሳን ባርናባሳን እቆንዮነን አይሁዱንꬅ ዎሳ ኬꬃ ገሊ ጋማ አይሁዱንꬅን አይሁደ ማቆሱንꬅ አማኖደ ዎደስ ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","የዝን አማንካይዘ አይሁዱንꬅ፥ አይሁደ ማቆሱንꬅ ዎዝንቶ ላሚ እሹንꬃላ ደንꬅꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ሐዋሩንꬅ እዘ ጋማ ዎደ ጋምእዳ። ኡን ዣሽትካይዛራ ላꬄ ባዝ ኦህዳ። ላꬂ ማላን ክሌ ባዝ ኡን ኦቾደ ጋር ኡንትስ አደትꬅ ዎልቃ እንግ ፋ አꬎ ኬሃትꬅ ቃልታ ቱሮ ማቅዛኖ ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","የዝን የንꬅ ካታማ አሱንꬅ ሻክንት፥ ባግታ አይሁዱንꬃራ ባግታ ማህ ሐዋሩንꬃራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","አይሁደ ማቆሱንꬅን አይሁዱንꬅን ፋ Ꮉላቁንꬃራ ዎላ ማቂ ሐዋሩንꬃና ቆሆደስን ሹቻራ ꬎጎደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ሐዋሩንꬅ ይኖ ኤሪ፥ ልስጥራን ደርበ ጋእንትዘ ልቃኦንያ ካታሙንꬅ ግዳን ኡን ጉታ የዘ ሳአ አችንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","እዘ ዎንገለ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","የልንትዳንፓ አይኪ ላምእ ቶህታ ዎቢን የꬊ ኤሮሰ ፈቲ አስ ልስጥራ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","የ አꬃይ ጳዉሎሳ ኦሆደራ በቲ ስእነ። ጳዉሎሳ ኤዛ ዳኪ በእዘ ዎደ ፋጾደስ ኤስ አማኖ የዛኖ ብእ፥ ");
INSERT INTO oyde_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ፋ ቃልቶ ꬎቅ ዪዚ፥ «ሞሊ ነ ቶህትራ ኤቆ» ያጋይዳ። ዬዝን፥ ዶሊ ደንዲ ኤቂ የ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ጳዉሎሳ ኦችዳኖ አሱንꬅ ብእ ፋ ቃልቶ ꬎቅ ዪዚ ልቃኦንያ ዶናራ፥ «ኤቁንꬅ አስ አዚ ኑጎ ዎꬍዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ባርናባሳ፥ «ድያ» ጋእ፥ ጳዉሎሳ ኦህዘ ዋንዘ ግሾ ኤዛ፥ «ሄርሜነ» ጋእ ሱንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ካታማፓ ጋጻ የዘ ድያ ጎይኖ ኬꬃ ካህንዘን አሱንꬅ ኮርማን ቦንቾ ፉ ሐዋሩንꬅስ ዣርሾደስ ኮይ ካታማ ፉርꬃ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","የዝን ባርናባሳን ጳዉሎሳን ይኖ ስኤዘ ዎደ ኡን ኦቾደስ ቆፕዳኖ እጺ ፋ ማእቶ ፌꬍዳ። አሱንꬅ ግዳ ዎጺ ገሊ፥ ");
INSERT INTO oyde_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ፋ ቃልቶ ꬎቅ ዪዚ፥ «አሱንꬆ፥ Ꮉኖ አኮስ ኦቼተ? ኑንን ይን ፋና አስ። Ꮉና ፋꬆሰ ባዝትፓ ሳሎን ሳአን፥ አባ ኡን ግዳ የዘ ኡባባዝቶ መꬍደ ደኦ ጾዘጎ ይን ማቃደ ጋር ይንትስ ኑኒ ዎንገለ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ኤ ዛጋ አሱንꬃና ፋ ኦግቶ የꬋደ ጋር ዳኪ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","የዝን እራ ሳሎፓ ቡክዝዳ፥ ካꬃን ዎደር ዎደር እንግዳ፥ ካꬃ እንግ ይንታና ጋማ ኡፋይስዳ፥ የይዝ ይንትስ ሎኦ ባዝ ኦቺ ፋስ ማርካ ꬋብስካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ሐዋሩንꬅ ይኖ ጋእ ፋስ አሱንꬅ ዣርሻመ ጋር ዋይ ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","አንጾክያፓን እቆንዮነፓን ይእደ አይሁዱንꬅ፥ አሱንꬃና ፋ ዛላ ማህ ሹቻራ ጳዉሎሳ ꬎግዳ። ኡንትስ ኤ Ꮉይቂደ ጋር አዝን ካታማፓ ጋጻ ጎቺ ካንግ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","የዝን አማንዙንꬅ ይእ፥ ኤ ካለ ዉቲ ኤቀዝን ኤ ደንዲ ካታማ ገልዳ። ዎንትስት ዎደ ባርናባሳራ ዎላ ዳርበ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ኡን ዳርበ ካታማ ዎንገለ ኦህ ጋሙንꬃና አማንዙንꬃና ማህዳንፕ ሱባ ልስጥራ፥ እቆንዮነን ጵስድያ አንጾክያ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","እዘ አማንዙንꬅ አማኖራ ሚንግ የሳደ ጋር ዞሪ፥ «ጾዘ ካእቱሞ ገሎደስ ኑኒ ጋማ ማꬋ ኤኮደስ ቤዛነ» ያጋእ ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ማህ ዎሳ ኬꬅስ ኦምተ ኦምተ ጭሙንꬃና ዶርዳ። ጾምዳንፓን ዎስዳንፓ ማቂ ኡን አማንዘ ላꬄስ ኡን Ꮉዳርቶ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ጵስድያ ሳአ ካንꬂ አꬊ ጵንፍልያ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ጰርገን ቃላ ኦህዳንፓ ማቂ አጣልያ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ኢፓ ኡን ፋ ፎልደ ኦችትስ ጾዘ አꬎ ኬሃትꬅትስ ኡንትስ Ꮉዳራ እንግደ አንጾክያ ማርካበራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","አንጾክያ የልደ ዎደ ዎሳ ኬꬃ አሱንꬃና ሺሺ ጾዚ ኡንታራ ኦችደ ኦችቶ ኡባ አይሁደ ማቆሰ አሱንꬅ አማኖደ ጋር ኡንትስ ዋይዝ ፉርꬅ ቡገዛኮ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ኤዝን አማንዙንꬃራ ጋማ ዎደ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ፈቲ ፈቲ አሱንꬅ ይሁዳፓ አንጾክያ Ꮉንግ፥ «ሙሴ ዎግት ጋር ይን ጋራዝንታንጽኮ አቶደስ ዳንዳኦስ» ጋእ አማንዙንꬃና ታማርሰ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ይና ጳዉሎሳን ባርናባሳን ኡንታራ ጋማ ላሎደ ጋራን ካጭንቶደ ጋር ዪዝዳ። ይኒ ግሾ፥ አንጾክያ የዘ ፈቲ ፈቲ አሱንꬅ ጳዉሎሳራን ባርናባሳራ የሩሳላመ Ꮉንግ ሐዋሩንꬃራ ጭሙንꬃራ የልንት ይና ኦህቶ ብሎደ ጋር ቆፋ አጭንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ዎሳ ኬꬅታ ኡንታና ኪትን ቅትዳ። ኡን ፍንቀራን ሳማራራ አꬍተራ አይሁደ ማቆሱንꬅ ጾዛጎ ዋይዝ ማቀዛኮ ኦህዳ። ይና አማንዙንꬃና ኡባ ጋማ ኡፋይስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ኡን የሩሳላመ የልደ ዎደ ዎሳ ኬꬅታ፥ ሐዋሩንꬅን ጭሙንꬅ ኡንታና ሞክዳ። ጾዚ ኡንታራ ኦችዳኖ ኡባ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","የዝን ፋርሳዉንꬅ ባጋፓ አማንደ ፈቲ ፈቲ አሱንꬅ ደንዲ ኤቂ፥ «አይሁደ ማቆሰ አማንዘ አሱንꬅ ጋራዝንቶደስን ሙሴ ህግቶ ናጎደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ሐዋሩንꬅን ጭሙንꬅ ይኖ ዞርንቶደስ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ጋማ ኦህንትዳንፓ ማቂ፥ ጴጥሮሳ ደንዲ ኤቂ፥ «ታ እሹንꬆ፥ አይሁደ ማቆሱንꬅ ዎንገለ ቃላ ታ ዶናፓ ስእ አማኖደ ጋር ቲንꬊ ታና ጾዚ ይን ግዳፓ ዶርዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","አስ ዎዝና ኤርዘ ጾዘ ጌሽ አያና ኑስ እንግዳንጋር ኡንትስን እንግ ቱርዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","አማኖራ ኡን ዎዝንቶ ጌሽደ ግሾ ኑ ግዳን ኡን ግዳ ሻኮ ጋድካያ። ");
INSERT INTO oyde_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ይኒ ግሾ፥ ኑ አዱንꬅን ኑኒ ቶኮደስ ዳንዳኦስ ቃምባራ አማንዙንꬅ ጌታላ ጋዲ Ꮉተ አኮስ ጾዝ ፋታነተ? ");
INSERT INTO oyde_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ላꬄ የሱስ አꬎ ኬሃትꬅተ ኡን አትዳን ጋራ ኑንን አትዳኖ አማናነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","አሱንꬅ ስእ ጋእ፥ ባርናባሳን ጳዉሎሳ አይሁደ ማቆሰ አሱንꬅ ግዳ ኡን ባጋራ ጾዚ ኦችደ ማላን ክሌ ባዝ ኡባ ኦሆደራ ስእነ። ");
INSERT INTO oyde_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ኡን ኦህ Ꮉስዳንፓ ማቂ ያይቆባ፥ «እሹንꬆ፥ ታ ጋዛኖ ስኦተ። ");
INSERT INTO oyde_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ጾዚ አይሁደ ማቆሱንꬅ ግዳ ፋ ፋ ሱንꬅቶ ጼግዘ ዎርዣ ዶሮደስ ኮይ ኡንታና ቲኖ ዋይዝ ቆፐዛኮ ስሞና ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ናቡንꬅ ቃልታ Ꮉንራ ጊጋነ። ጌሽ ማጻፍተ፥ ");
INSERT INTO oyde_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","« ‹Ꮉንፓ ሱባ፥ ታ ማቃዳ፥ ዎድደ ዳዉተ ኬꬅቶ ኬጾዳ። ዉልእንትደ ኬꬅቶን ማህ ኤሶዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","አትደ አሱንꬅ ኡባ ታጎ የኦዳ፥ ታ ጼግደ አይሁደ ማቆሰ አሱንꬅ ኡባ ታና ኮዮዳ። ዛጋፓ አይኪ ይና ኤርንቶደ ፋና ዪዝደ ላꬄ፥ ታ ኦህነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«ይኒ ግሾ፥ ታ ቆፍታ ጾዛጎ ማቅዘ አይሁደ ማቆሱንꬃና ኑኒ ዋይꬆሳኮ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","የዝን ኡን ኤቃስ ዣርሽንቲ ቱንደባዝ ማአመ ጋር፥ ኦላላመ ጋር፥ ባዉታ ማአመ ጋራን ሱꬅ ኡዣመ ጋራን ማአመ ጋር ኡንትስ ኑኒ ዳብዳበ ጻፎደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ሙሴ ህገ ዛጋፓ አይኪ ሳምባታ ሳምባታ አይሁደ ዎሳ ኬꬃ ናባብንቲ ካታማ ኡባ ሳባክንታነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ይንፓ ማቂ፥ ሐዋሩንꬅን ጭሙንꬅ ዎሳ ኬꬃ አስ ኡቡንꬃራ ፈትላ ፋ ግዳ ፋ ኤራꬅ አሱንꬃና ዶሪ ጳዉሎሳራን ባርናባሳራ አንጾክያ ዳኮደስ ቆፋ አጭዳ። ጋማ ኤርንትደ ካልꬅዙንꬃና ባርሳባሳ ጋእንትዘ ይሁዳን ስላሰን ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ꮉንጋራ ጋእንት ዳብዳበ ኡንታላ ዳክዳ፦ «ኑ ሐዋሩንꬅን ጭሙንꬅ ይን እሹንꬅ፥ አንጾክያ፥ ሶርያ ክልቅያ የዘ አይሁደ ማቆሰ እሹንꬅስ ኑ ሳሮትꬅ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«ኑኒ ኪትካይዘ አሱንꬅ ኑ ግዳፓ Ꮉንግ፥ ‹ይን ጋራዝንቶደስን ህግቶ ናጎደስ ቤዛነ› ጋእ፥ ይንታና ዋይꬅዳኖን ዥልዝዳኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ኑኒ ካዽዘ ባርናባሳን ጳዉሎሳ ዶርንትደ አሱንꬃራ ዎላ ይንታጎ ዳኮደስ ፈቲ ዎዝናራ ኑ ቆፍቶ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ኡን ኑ ላꬄ የሱስ ክርስቶሳ ግሾ ፋ ደእቶ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ይኒ ግሾ፥ ኑ ጻፍዳኖ ኡን ፋ ዶናራ ጉጂ ይንትስ ኦሆደ ፋና ይሁዳን ስላሰን ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","«Ꮉና ኮሽዙንꬃፕ አትን መለ ቶፎ ይንታና ቶሳመ ጋር ኑንን ጌሽ አያና ኦህቶ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ኤቃስ ዣርሽንቲ ቱንደባዝ ሙእፐተ፥ ሱꬅ ኡዥፐተ፥ ባዉታ ሙእፐተ፥ ኦላልፐተ። Ꮉንꬅ ኡባፓ ይን፥ ይን ኦምቶ ናግኮ ሎኦ ባዝ ኦቻነ። ሎኦ የዞተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ይኒ ግሾ፥ ኪትንትዱንꬅ ሞይዝንቲ አንጾክያ ቅቲ አማንዘ አሱንꬃና ሺሺ፥ ዳብዳቢዛ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ኡን የ ምንꬅꬅዘ ዳብዳቢዛ ናባብደ ዎደ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ማህ ይሁዳን ስላሰን ፋ ኦምተ ናቡንꬃና ማቅደ ግሾ አማንዙንꬃና ሎይꬂ ዞሪ ምንꬅꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ኡን አንጾክያ ኤራꬅ ዎደ በትዳንፓ ሱባ አማንዘ እሹንꬅ ሎይꬅ ሞይዝን ፋና ኪተዙንꬃጎ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","የዝን ስላሰን እዘ አቶደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ማህ ጳዉሎሳን ባርናባሳን መለ ጋማ አሱንꬃራ ዎላ ላꬄ ቃላ ታማርስተራ ዎንገለ ኦህተራ አንጾክያ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ኤራꬅ ቃማፓ ሱባ ጳዉሎሳ ባርናባሳጎ፥ «ኑ ላꬄ ቃላ ኦህደ ካታምተ ኡባ አማንዙንꬅ ዋይዝ የዛኮ ሱባ ማቅተራ በአዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ባርናባሳ ማርቆሳ ጋእንትዘ ዋሐንሳ ፋራ Ꮉማደ ፋና ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","የዝን ጳዉሎሳ ማርቆሳ ፋራ Ꮉማደ ፋና ኮይካያ። አኮስ ጋይኮ፥ ኤ ጵንፍልያ ሻክንት ኡንታራ ኦቾደስ Ꮉንግካያ። ");
INSERT INTO oyde_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ኡን ግዳ ኢታ ካች ከዝን ፈታይ ፈታይፓ ሻክንትዳ። ባርናባሳ ማርቆሳ ኤኪ ማርካበራ ቆጵሮሳ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","የዝን ጳዉሎሳ ስላሰ ዶርዳ፤ አማንዙንꬅ ጳዉሎሳ ጾዘ አꬎ ኬሃትꬅ Ꮉዳርቶ እንግዳንፓ ማቂ ኤ ኬዚ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","የይዝ፥ ዎሳ ኬꬂ ምንꬅꬅተራ ሶርያራን ክልቅያራን ዉትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ጳዉሎሳ ዳርበን ልስጥራን ቅትዳ። እዘ ጢሞትዮሳ ጋዘ አማንዘ አስ የነ። ኤ እንታ አማንዘ አይሁደ ማቾ፥ ኤ አዳይ ግርኬ አስ። ");
INSERT INTO oyde_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ልስጥራን እቆንዮነ የዘ አማንዙንꬅ ጢሞትዮሳ ባዝ ሎይꬂ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳዉሎሳ ጢሞትዮሳ ፋራ ኤኮደስ ኮይ፥ ኤ አዳይ ግርኬ አስ ማቅዳኖ ይና በስተ የዘ አይሁደ ኡቡንꬅ ኤርዘ ግሾ ኤዛ ጋራዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ኡን ካታማራ አꬍተር የሩሳላመ የዘ ሐዋሩንꬅን ጭሙንꬅን አጭደ ቆፍቶ አማንዙንꬅ ናጎደ ጋር ኡንትስ ኦህተራ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ይኒ ግሾ፥ ዎሳ ኬꬅታ አማኖራ ሚንግተ፥ ፋይዶራን ቃምተ ቃምተ ጋንግተር Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","እስያ ግዳ ቃላ ኦሃመ ጋር ጌሽ አያና ኡንታና ካይደ ግሾ ጵርገራን ጋላትያ ሳአራ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ኡን ሚስያ ጋጻ የልደ ዎደ ብቲንያ ቅቶደስ ቆፕዳ የሻ። የዝን የሱሳ አያና ኡንታና ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ይኒ ግሾ፥ ኡን ሚስያ ካለራ አꬍተራ ጢሮአዳ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ጳዉሎሳ ቃማ ቆንጭꬃራ ፈቲ መቀዶንያ አስ ፋጎ፥ «መቀዶንያ ፊንግ ኑና ማዶያ» ጋእ ኤቂ ዎሶደራ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ቆንጭꬅ ኤ ብእዳንፓ ማቂ ኑ መቀዶንያ ቅቶደስ ኮይዳ። ይናን፥ ዎንገለ እዘ የዘ አሱንꬅስ ኦሆደስ ጾዚ ኑና ጼግዳ አዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ጢሮአዳፓ ደንዲ ማርካበ ግዳ ገሊ ሳሞትራቀ Ꮉንግደ፥ ዎንትስት ዎደ ናጱለ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","እዝፓ ደንዲ መቀዶንያ ሳአ የዘ ፍልጵስዩሳ ጋእንትዘ ዎራዳ ካታማ Ꮉንግዳ። ማህ ፍልጵስዩሳ ሮሙንꬅ አህዘ ካታማ። ኑ ይና ካታምተ ኤራꬅ ዎደ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ሳምባታ ዎደ ካታማፓ ጋጻ ቦርካ ዶና አይሁዱንꬅ ጾዘ ዎስዘ በሲ የዛኖ ቆፒ እዘ Ꮉንግዳ። ይና በስተ ሺቅደ ማቹንꬅስ ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ኑና ስእዘ አሱንꬃፓ ፈቲ ሊድያ ጋእንትዘ ትያጥሮነ ካታማፓ ይእደ፥ ጾዝ አማንዘ ዞቆ ማኦ ዛልእዘ፥ ማችታ የነ። ጳዉሎሳ ኦህዛኖ እዛ ስኦደ ጋር ላꬂ እ ዎዝንቶ ቡግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ሊድያ ፋ ካራ አሱንꬃራ ዎላ ጻማቅንትዳንፓ ማቂ ኑጎ፥ «ይን ታና ላꬃ ቱሮ አማንዳ ጋይኮ ታ ካራ ይእ ሸምፖተ» ጋእ ምንꬂ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ኑ ጾዝ ዎስዘ በስተ Ꮉንጎደራ ኢታ አያና ኢላ አፋ የዚ ማርꬍዘ ፈቲ ዉዱር አርታ ኑራ የልንትዳ። እዛ ማርꬊ ጋማ ብራ ፋ ላꬁንꬅስ ከእነ። ");
INSERT INTO oyde_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ጳዉሎሳን ኑናን ካሊ፥ «Ꮉንስ ኡባፓ ካታራ ጾዘ አሩንꬃና! ኡን ይን አቶደ ኦግቶ ኦህዙንꬃና» ጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ኡባ ዎደ ይኒ ጋር ጋነ። የዝን ጳዉሎሳ ዥልꬊ ሱብ ማቂ፥ የ አያንዛ፥ «የሱስ ክርስቶሳ ሱንꬅተ ኢፓ ከዞ» ጋእ ኪትዳ። ኢራ ኢታ አያንዘ ኢፓ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","የዝን እ ላꬁንꬅ ፋስ ብራ ደንግዘ ኦግታ ꬋብዳኖ ብእ፥ ጳዉሎሳን ስላሰን አይኪ፥ ፍርዳ ኬꬃ ዳይኑንꬅ ቲኖ ጎቺ ካንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ዳይኑንꬅ ቲኖ ኡንታና ካንግ፥ «Ꮉንስ አይሁደ አስ ማቂ ኑ ካታማ አሱንꬃና ጋማ ዋይꬃነ። ");
INSERT INTO oyde_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ኑ ሮመ ጋደ አሱንꬅ ኤኮደስን ኦቾደስ ዎጋ ማቆሰ ባዝ ታማርሳነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","አሱንꬅ ፈቲ ዛላ ማቂ፥ ጳዉሎሳላን ስላሰላን ደንድዳ። ዳይኑንꬅ ኡን ማእቶ ጋሪ ጉፈር ኡንታና ጉዳደ ፋና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ኡንታና ጋማ Ꮉꬍዳንፓ ሱባ አች ኬꬃ ገልꬅዳ። አች ኬꬅቶ ካፍዛይ ኡንታና ምንꬂ ካፎደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","አች ኬꬅቶ ካፍዘ ይና ኪቶ ኤኪ፥ ጳዉሎሳን ስላሰን አች ኬꬅትስ ቆልአ ገልꬅዳ። ኡን ቶህቶ ዱꬃራ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","የዝን ቃማ ብላሄ ማቅዘ ዎደ ጳዉሎሳራን ስላሰራን ዎስተራን ማዝሙረ የጽተራን ጾዝ ጋላታነ። አች ኬꬅተ የዘ መለ አሱንꬅን ኡን ጋዛኖ ስእነ። ");
INSERT INTO oyde_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ቆፕካይዝን አች ኬꬅት ሳእታ ኤንእንቶደ ዎንꬅስ ሳአ ኤንእዳ። ይና ሳተ ፉርꬅታ ኡባ ቡጉንቲ አትዳ፤ አጭንትደ አሱንꬅ ኡቡንꬅ ሳንꬃላታ ብልንቲ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","አች ኬꬅቶ ካፍዘ ገንቶፓ ባርክደ ዎደ አች ኬꬅት ፉርꬅታ ኡባ ቡጉንትዳኖ ብእ አጭንትደ አሱንꬅ ኬሲ ኤኪ ቅትደ ጋር ኣዝን ፋና ዎꬎደስ ማሻ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","የዝን ጳዉሎሳ ፋ ቃልቶ ꬎቅ ዪዚ «ኑ ኡባና Ꮉነ የዘ ግሾ ነ ነና ቆህፐ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","አች ኬꬅቶ ካፍዘ ጾምፐ ዎሲ ኤኪ ኤልሲ ግዳ ዎጽዳ። ጎቅተራ ጳዉሎሳ ቲኖን ስላሰ ቲኖ ዙግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ኡንታና ባለ ኬሲ፥ «ታ ላꬁንꬆ፥ ታ አቶደስ አኮ ኦቾደስ ቤዘ?» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ጳዉሎሳራን ስላሰራ ኤጎ፥ «ላꬅ የሱስ ክርስቶሳ አማኖ፤ ኔራን ነ ካራ አሱንꬃራን አቶዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ኡን ኤስን ኤ ካራ የዘ ኡቡንꬅስ ላꬄ ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ቃማ ይና ሳተ አች ኬꬅቶ ካፍዘ ኡንታና ካንግ ኡን Ꮉርግዘ በስቶ ሜጭዳ። ኤልሲ ፋ ካራ አስ ኡቡንꬃራ ጻማቅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ጳዉሎሳን ስላሰን ፋ ካራ ካንግ ኡንትስ ካꬃ አꬅዳ። ኤ ፋ ካራ አስ ኡቡንꬃራ ጾዝ አማንደ ግሾ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ሳእታ ዎንትን ዳይኑንꬅ፥ «የንꬅ አሱንꬃና ብሎ» ያጋእ ፖሊሱንꬃና ኤጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","አች ኬꬅቶ ካፍዘ፥ «ይን ብልንቶደ ጋር ዳይኑንꬅ ኪትዳ። ይኬ፥ ኬዚ ሳሮ ቅቶተ» ያጋእ ይና ኪቶ ጳዉሎሳስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","የዝን ጳዉሎሳ የንꬅ ፖሊሱንꬃጎ፥ «ኑ ሮመ አስ ማቃደራ ኡን ኑና ፍርዳ ባይꬅ አስ ቲኖ Ꮉꬊ፥ አች ኬꬃ ኦልዳ። Ꮉተ ኑና አችንት ኬዚ ቅቶ ጋነ? Ꮉኖስ፥ ኡን ፋ ኦምትስ ይእ ኑና ኬሶ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ፖሊሱንꬅ ዳይኑንꬅስ ይኖ ኦህን፥ ጳዉሎሳራን ስላሰራን ሮመ ሳአ አስ ማቅዳኖ ስእደ ዎደ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ይኒ ግሾ፥ ዳይኑንꬅ ይእ ኡንታጎ፥ ኑ ይንታና ቆህዳ ያጋእ ማሮትꬅ ኦጭዳ። አች ኬꬅትፓ ባለ ኡንታና ኬሲ፥ ካታማፓ ኬዚ ቅቶደ ጋር ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ጳዉሎሳራን ስላሰራን አች ኬꬅትፓ ኬዚ ሊድያ ካራ Ꮉንግዳ። እዘ አማንዙንꬃራ የልንት ኡንታና ምንꬅꬂ ኬዚ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ጳዉሎሳራ ስላሰራን አምፍጶልሳራን አጶሎንያራ አꬊ ተሰሎንቄ ቅትዳ። እዘ አይሁደ ዎሳ ኬꬂ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳዉሎሳ ዛጋን ጋራ እዘ ገልዳ። እዘ Ꮉይꬕ ሳምባታ ጾዘ ቃላፓ አሱንꬅስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ክርስቶሳ ማꬋ ኤኮደስን Ꮉይቆፓ ደንዶደስን ቤዛኖ ኡንትስ ጌሽ ኦህተራ፥ «የሱሳ Ꮉይ ታ ይንትስ ኦህዛይ ክርስቶሳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ኡንታፓ ፈተ ፈተ ኦህዳና ቱሮ ማቅዳኖ ኤኪ ጳዉሎሳራን ስላሰራ ዎላ ፈቶ ማቅዳ። ይኒ ፋና፥ ጾዝ ጎይንዘ ጋማ ግርኬ አሱንꬅን ጋማ ቦንችንትደ ማቹንꬅን ኡንታራ ዎላ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","የዝን አይሁዱንꬅ እጺ ፈቲ ፈቲ ኦቻ ባይዘ ኢታ አሱንꬃና ኦገፓ ሺሽዳ። ካታምቶ ቡቀ አይክዳ፤ ጳዉሎሳን ስላሰን አሱንꬅስ አꬂ እንጎደስ ኮይ ኢያሶነ ኬꬅቶ ተቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ጳዉሎሳን ስላሰን ኡንትስ በንታንጽን፥ ኢያሶነን ፈቲ ፈቲ አማንዙንꬃና ካታማ Ꮉላቁንꬃጎ ጎቺ ካንግ፥ «Ꮉንስ ሳእቶ ኡባ ቡቅዙንꬅ Ꮉተ ኑጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ኢያሶነ ኡንታና ፋ ካራ ጋድዳ። Ꮉንስ፥ ‹የሱሳ ጋዘ መለ ካት የነ› ጋእ ቄሳረ ኪቶ እጻነ» ጋእ ꬎቅ ጋይደ ቃላራ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ሺቅደ አሱንꬅን ካታማ Ꮉላቁንꬅ ይኖ ስእ Ꮉኖደባዝ ꬋብዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ꮉላቁንꬅ ኢያሶነን መሉንꬃና ዋሰር ብልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","አማንዙንꬅ ጳዉሎሳን ስላሰን ቃማራ ቤርያ ዳክዳ። ቤርያ የሊ፥ አይሁደ ዎሳ ኬꬃ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ቤርያ አሱንꬅ ተሰሎንቄ አሱንꬃፓ አꬊ ዎዝና ዳልጋ። ኡን ቃልቶ ኩሙꬅ ዎዝናፓ ኤክዳ፤ ጳዉሎሳ ጋይዳና ቱሮ ማቅዳኖ ሻኪ ኤሮደስ ኡባ ዎደ ጌሽ ማጻፈ ናባባነ። ");
INSERT INTO oyde_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ይኒ ግሾ፥ ኡንታፓ ጋሙንꬅ፥ ግርኩንꬃፓ ቦንችንትደ ጋማ ማቹንꬅን ጋማ ꬊራꬁንꬂ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","የዝን ተሰሎንቄ የዘ አይሁዱንꬅ ጳዉሎሳ ጾዘ ቃላ ቤርያ ግዳን ኦህዳኖ ስእደ ዎደ ቤርያ ይእ አሱንꬃና ቡቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ይንፓ ማቂ፥ አማንዙንꬅ ኤልሲ ጳዉሎሳ አባ ካለ ዳክዳ። የዝን ስላሰን ጢሞትዮሳን ቤርያ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳዉሎሳ ሞይዝደ አሱንꬅ አቴና የልꬅዳ። የንꬅ አሱንꬅ ስላሰን ጢሞትዮሳን ፋስ ዳንዳእንትደ ጋር ኤልሲ ፋጎ የኦደ ጋር ጳዉሎሳ ኪተዘ ኪቶ ኤኪ ቤርያ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳዉሎሳ አቴና ስላሰን ጢሞትዮሳን ካፍተራ፥ ካታማ ኤቃ ኩምዳኖ ብእ ዥልꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ይኒ ግሾ፥ አይሁደ ዎሳ ኬꬅተ አይሁዱንꬃራን ጾዝ ጎይንዘ አይሁደ ማቆሰ አሱንꬃራ ማህ ፋራ የልንትዘ አሱንꬃራ ኡባ ዎደ ጋበ ላላነ። ");
INSERT INTO oyde_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ኤጵቆሮሳን እስቶይኬ ጋእንትዘ ባጉንꬃፓ ፈቲ ፈቲ ኤሩንꬅ ጳዉሎሳራ ዎላ ላልዳ። ኡንታፓ ፈተ ፈተ፥ «Ꮉይ ጫንጭዘ አኮ ኦሆደስ ኮየ?» ያጋይዳ። መሉንꬅ ጳዉሎሳ የሱሳን Ꮉይቆፓ ደንዶ ባዝ ፋስ ኦህደ ግሾ «መለ ኤቁንꬅ ባዝ ኦህዛ አዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ጳዉሎሳ አይኪ አርዮስፓጎሳ ጋዘ ሺቆ በስተ ካንግ፥ «Ꮉና ነ ታማርስዘ ክለ ባዝታ አኮ የዛኮን ኑና ኤርሶ? ");
INSERT INTO oyde_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","አኮስ ጋይኮ፥ ነ ኑስ ክሌ ባዝ ኦህነ፤ ይኬ ይና አኮ የዛኮን ኑ ኤሮደስ ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","አቴና አሱንꬅ ኡቡንꬅን እዘ የዘ ዛቁንꬅ ክሌ ባዝ ኦህካይዛራን ስእካይዛራን ፌዦስ። ");
INSERT INTO oyde_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ጳዉሎሳ አርዮስፓጎሳ ግዳ ሺቅደ አሱንꬅ ቲኖ ኤቂ፥ «አቴና አሱንꬆ፥ ይን ኤቁንꬅስ ኡባ ባዛ ጋማ ዣሽትዛኖ ታ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ታኒ ይን ካታማራ ዉትተራ ይን ጎይንዘ በስተ በእዘ ዎደ ‹ኤርንቶሰ ጾዘስ› ጋእንት ጻፍንትደ ዣርሾ በስቶ ደንግዳ። Ꮉና ይን ኤርካይዛራ ጎይንዛያ ታ ይንትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ሳአን ሳአላ የዘ ኡባባዝቶ መꬍደ ጾዘ፥ ሳሎን ሳአ ላꬄ፥ አስ ኬጽደ ኬꬃ የዞስ። ");
INSERT INTO oyde_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ኤ ደኦ፥ ሸምፖን ኡባ ባዝ አስ ኡባስ እንግደ ግሾ ፋጨ የዘ አስ ፋና አስ ማደ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ጾዚ ኡን የሳደ ዎደስን በስስ ዉዙላ እንግዳ። ይንፓ አስ ኮች ኡባ ፈቲ አሳፓ መꬊ ሳአ ኡባ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ኤ ይኖ ኦችዳና አስ ኤዛ ኮዮደ ፋናን ቁርች ደንጎደ ፋና። ማቅኮን ኤ ኑፓ Ꮉኮ ባያ። ");
INSERT INTO oyde_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ይንታፓ ፈቲ ፈቲ የጽዙንꬅ፥ ‹ኑ ኤ ናኡንꬃና› ማቅዳን ፋና፥ ኑ ኤ ግዳ ፋጻ የነ፥ ኤንእንታነ። ");
INSERT INTO oyde_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ይኬ፥ ኑ ጾዘ ናኡንꬃና ማቅደ ግሾ ‹ጾዚ አስ ዪላትꬃራን ቆፋራ ዎርቃፓ ዎይ ብራፓ ዎይ ሹቻፓ ኦችንትደባዝ አዛነ› ጋእ ቆፖደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ይኒ ግሾ፥ ጾዚ ቲኖ ዎደ አስ ኤርካይዛራ ኦችዳኖ አሺ አꬍዳ፥ የዝን Ꮉተ ኡባ በሳ የዘ አስ ኡባ ናጋራፓ ማቃደ ጋር ኪታነ። ");
INSERT INTO oyde_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","አኮስ ጋይኮ፥ ጾዚ ፋ ዶርደ አꬄራ ሳአላ የዘ አስ ኡባላ ጽሎ ፍርዳ ፍርዶደስ ቃማ ጊግዚ ጋድዳ። ኤዛ Ꮉይቆፓ ደንꬂ ይኖ አስ ኡባስ ጌሽዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ኡንታፓ ፈቲ ፈቲ አሱንꬅ Ꮉይቆፓ ደንደባዝ ጳዉሎሳፓ ስእ፥ ኤዛ ለቂዳ። የዝን መሉንꬅ፥ «ኑኒ ይኖ ኔፓ ጉጂ ስኦደስ ኮያነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ይኒ ግሾ፥ ጳዉሎሳ ኡን ግዳፓ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","የዝን ፈቲ ፈቲ ꬊራꬁንꬂ ጳዉሎሳራ የሊ አማንዳ። ኡን ግዳፓ አርዮስፓጎሳን ሺቅተ የዘ ድዮናስዮሳ ጋዘ አꬄ፥ ዳማሪሶ ጋዘ ፈቲ ማችታን መሉንꬅን ኡንታራ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ይንፓ ሱባ፥ ጳዉሎሳ አቴናፓ ኬዚ፥ ቆሮንቶሳ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","እዘ አቂላ ጋዘ ጳንጦሳ የልንትደ ፈቲ አይሁደ አስ ደንግዳ። አይሁደ አሱንꬃና ኡባ ሮመፓ ኬሳደ ጋር ካት ቃላዉድዮሳ ኪትደ ግሾ ኤራꬅ ዎደፓ ቲኖ ኤ ፋ ማችት ጵርስቅላራ ጣለፓ ይእዳ። ጳዉሎሳ ኡንታራ የልንቶደስ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ኤ ኦችታ ኡንትንጋራ ዱንካነ ስከ ማቅደ ግሾ ኡንታራ በቲ ዎላ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ጳዉሎሳ ሳምባታ ኡባ አይሁዱንꬃናን ግርኩንꬃና አማንꬆደስ አይሁደ ዎሳ ኬꬃ ሚንግ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ስላሰን ጢሞትዮሳን መቀዶንያፓ ይእደ ዎደ ጳዉሎሳ ፋ ኩሙꬅ ዎድቶ እንግ አይሁዱንꬅስ የሱሳ ኤ፥ ክርስቶሳ ጋእ ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","የዝን ኡን ጳዉሎሳ እጺ ኤዛ ጫዥን ጳዉሎሳ ፋ ማእትፓ ጹራ ትቅዝ፥ «ይን ጎምታ ይንታና የሎ፤ ታ ይነ የዞስ። ይኬፓ ሱባ፥ ታ አይሁደ ማቆሰ አሱንꬃጎ ቅታነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","እዝፕ ኬዚ ጾዝ ጎይንዘ ትቶስ ኢዮስጦሳ ጋዘ አꬄ ካራ ቅትዳ። ኢዮስጦሳ ኬꬅታ አይሁደ ዎሳ ኬꬂ ካለ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","አይሁደ ዎሳ ኬꬅት Ꮉላቅዘ ቃርስጶሳ ፋ ካራ አሱንꬅ ኡቡንꬃራ ላꬅ አማንዳ። ቆሮንቶሳ አሱንꬃፓ ጋሙንꬅ ጾዝ ቃላ ስእደ ዎደ አማኒ ጻማቅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ላꬂ ፈቲ ቃማ ጳዉሎሳስ በንቲ፥ «ዣሽትፐ፤ ኦሆ፥ ስእ ጋይፐ። ");
INSERT INTO oyde_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ታኒ ኔራ የነ። ታስ Ꮉና ካታምተ፥ ጋማ አስ የዘ ግሾ ነና ቆሂ ኢታበሳ ኦሎደ አስ ኦደን ባያ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ይኒ ግሾ፥ ጳዉሎሳ ጾዘ ቃላ አሱንꬃና ታማርስተራ ፈቲ በረን እዝፑን አግና ኡንታራ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጋልዮሳ አካያ ሳአ አህዘ ዎደ አይሁዱንꬅ ፈትላ ጳዉሎሳላ ደንዲ ፍርዳ ኬꬃ ኤዛ ካንግ፥ ");
INSERT INTO oyde_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Ꮉይ አꬃይ ህገ እጺ፥ አሱንꬅ ጾዝ ጎይኖደ ጋር ዪዛነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ጳዉሎሳ ኦሆደስ ይአደራ፥ ጋልዮሳ አይሁዱንꬃጎ፥ «አይሁዱንꬆ፥ ይና ኢታ ኦቻ ዎይ ቆሄ ማቅኮ ታ ይን ባዝ ዳንዳእ ስኦደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","የዝን ቃላስን፥ ሱንꬅስን ይን ህግትስን ይን ላልዘባዝ ማቅኮ ይን፥ ይንትስ ብሎተ፤ ይኖ ታ ፍርዶስ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","የይዝ፥ ኡንታና ፍርዳ ኬꬃፓ ባለ ከስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ይንፓ ሱባ፥ አሱንꬅ ኡባ አይሁደ ዎሳ ኬꬃ Ꮉላቅዛ ሶስተንሳ አይኪ ፍርዳ ኬꬂ ቲኖ Ꮉꬍዳ። የዝን ጋልዮሳስ ይና አኮን አዝካያ። ");
INSERT INTO oyde_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ጳዉሎሳ ጋማ ዎደ ቆሮንቶሳ ግዳ በትዳንፓ ሱባ አማንዘ አሱንꬃና ሳሮꬅ፥ ጵርስቅልራን አቂላራ ማርካበራ ሶርያ ቅትዳ። የዝን ኤ ቅቶዳንፓ ቲኖ ፋስ ቃይንግደባዝ የዘ ግሾ ክንክርያ ካታማ ፋ ኦምቶ መድንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ኡን ኤፈሶነ የልደ ዎደ ጳዉሎሳ ጵርስቅላን አቂላን እዘ አሽዳ። የዝን ፋስ አይሁደ ዎሳ ኬꬃ ገሊ አይሁዱንꬃራ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ኡን ፋራ ጋማ ዎደ በቶደ ጋር ጳዉሎሳ ዎስዳ የዝን ኤ እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ኡንታፓ ሻክንትተር፤ «ጾዚ ጋይኮ ይንታጎ ማቂ ዮኦዳ» ያጋእ ኤፈሶነፓ ማርካበራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ቂሳርያ የልደ ዎደ የሩሳላመ Ꮉንግ ዎሳ ኬꬃ አሱንꬃና ሳርꬅዳንፓ ሱባ አንጾክያ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","እዘ ኤራꬅ ዎደ ጋምእዳንፓ ሱባ አማንዘ አሱንꬃና ኡባ ምንꬅꬅተራ ጋላትያራን ጵርገራን አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","እስክንድርያ የልንትደ ፈቲ አጵሎሳ ጋዘ አይሁደ አስ ኤፈሶነ ቅትዳ። ኤ ኦሄ ኤርዘ አስን ጾዘ ቃላ ጋማ ኤርዘ አስ። ");
INSERT INTO oyde_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ኤ ላꬂ ኦግቶ ታማሪ፥ አያናራ ኤጺ የሱሳ ባዝ ሉለ ታማርሳነ። ማቆ የዝን፥ ዋሐንሳ ጽንቃተ ጻላላ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ኤ አይሁደ ዎሳ ኬꬅተ ዣሽትካይዛራ ታማርሳነ። ጵርስቅላን አቂላን ኤ ኦህዛኖ ስእደ ዎደ ኤዛ ፋራ ካራ ካንግ ጾዘ ኦግቶ ቲኖስትፓ ጌሽ ኤስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","አጵሎሳ አካያ ቅቶደስ ኮይን ኤፈሶነ የዘ አማንዘ አሱንꬅ ኤ ቆፍቶ ኤኪ አካያ የዘ አማንዙንꬅ ኤዛ ሞኮደ ጋር ኡንትስ ዳብዳበ ጻፍዳ። ኤ እዘ የልደ ዎደ ጾዘ አꬎ ኬሃትꬅት ባጋራ የሱስ ክርስቶሳ አማንዱንꬃና ጋማ ማድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","አኮስ ጋይኮ፥ የሱሳ ኤ ክርስቶሳ ማቅዛኖ አይሁዱንꬅስ ጾዘ ቃላፓ ቆንጭዝ አሱንꬅ ቲኖ ምንꬂ ኦህ ኡንታና ላꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","አጵሎሳ ቆሮንቶሳ የዘ ዎደ፥ ጳዉሎሳ ዎካ ዛላራ አꬊ ኤፈሶነ ቅትዳ። እዘን ፈቲ ፈቲ አማንዘ አሱንꬃና ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ኡንታጎ፥ «ይን አማንደ ዎደ ጌሽ አያና ኤክዳተ?» ጋእ ኦጭዳ። ኡን፥ «አደ፥ ኤክካያ፤ መለ አቶ የዝን፥ ጌሽ አያና የዛኖን ስእካያ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ጳዉሎሳ ኡንታጎ፥ «ዬዝን፥ አኮር ጻማቅንትዶተ?» ጋይዳ። ኡን፥ «ኑኒ ዋሐንሳ ጽንቃተ ጻማቅንትዳ» ጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳዉሎሳ፥ «ዋሐንሳ ፋፓ ሱባራ የእዘ የሱሳ አማኖደ ጋር አሱንꬅስ ኦህተር፥ ናጋራፓ ማቀስ ኮሽዘ ጽንቃተ ጻማቅዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ኡን ይኖ ስእደ ዎደ ላꬄ የሱሳ ታማረ ማቃደስ ጻማቅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ጳዉሎሳ ፋ ኩሽቶ ኡንታላ ጋድዘ ዎደ ጌሽ አያና ኡንታላ ዎꬍን፥ መለ መለ ዶናራ ዎላ ኦህንትዳ፤ ማህ ትንቢተ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ይና በስተ ታጶ ላምእ ማቅዘ አሱንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ጳዉሎሳ አይሁደ ዎሳ ኬꬃ ገሊ፥ ጾዘ ካእቱሞ ባዝ ዣሽትካይዛራ ማርክꬍተር ሎይꬂ ቆንጭዝተር ኡንታራ Ꮉይꬕ አግና የሎደስ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","የዝን ኡንታፓ ፈተ ፈተ ꬉበ ማቂ ጋማ አሱንꬅ ቲኖ ላꬄ ኦግቶ ጫዥ አማናንጺ እጽዳ። ጳዉሎሳ አማንዙንꬃና ኡንታፓ ሻጊ ኤኪ ጥራኖሳ ጋዘ ትምርተ ኬꬃ ኡባ ዎደ ኡንታና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ጳዉሎሳ ላምእ በረ የሎደስ ቃላ ኦህዳ። ይኒ ግሾ፥ እስያ የዘ አሱንꬅ ኡባ፥ አይሁዱንꬅን አይሁደ ማቆሱንꬅ ላꬄ ቃላ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ጾዚ ጳዉሎሳ ኩሽተ ዳማ ክለ ባዝ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ይኒ ግሾ፥ አሱንꬅ ኤ ጋልቶ ቦችደ ማራብቶ ዎይ ማእቶ Ꮉርጋንቹንꬅስ ካንጋነ። ኡንትን ፋጻነ፤ ቱና አያኑንꬅን ኡንታፓ ከዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ቱና አያና ከስተራ ዉትዘ አይሁዱንꬃፓ ፈተ ፈተ፥ «ጳዉሎሳ ሳባክዘ የሱሳ ሱንꬅተ ከዞተ ጋእ ይንታና ኪታነ» ጋእ፥ ቱና አያና አይክደ አሱንꬃላ ላꬄ የሱሳ ሱንꬅቶ ጼግዳ ");
INSERT INTO oyde_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","አይሁደ ማቅደ ካህኑንꬅ Ꮉላቃፓ ፈቲ አስቄወ ጋዘ አꬄስ ይኖ ኦችዘ ላፑን ꬊራꬅ ናኡንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","የዝን ቱና አያንዘ ኡንታጎ፥ «ታኒ የሱሳን ኤራነ ጳዉሎሳ ባዝን ኤራነ፥ የዝን ይን ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ቱና አያንዘ አይክደ አꬄ ኡንታላ ዶሊ ዎꬊ፥ ኡንታና Ꮉርግዝ፥ ይና ኬꬅትፋ ካሎ ዎጽ ꬋቦደ ዎንꬅስ ዎልቂꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ኤፈሶነ የዘ አይሁዱንꬅን አይሁደ ማቆሱንꬅ ኡባ ይኖ ስእ ጋማ ዣሽትዳ። ላꬂ የሱሳ ሱንꬅታ ጋማ ቦንችንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","አማንዙንꬃፓ ጋሙንꬅ ፋ ኦችደ ኢታ ኦችቶ ቡጽተራ ቆንጨ ኦህተር የነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ብትዙንꬃፓ ጋሙንꬅ ፋ ማጻፍቶ ሺሺ አስ ኡባ ቲኖ ምችዳ። ይና ማጻፍት ዋግታ እችንታም ሙኩል ሹች ብራ ሳንትመ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ይኒ ጋር ይእ ጾዘ ቃላ ዎልቃር ድጭተራን ዳልግተር ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ይና ፎልንትዳንፓ ሱባ ጳዉሎሳ፥ «ታኒ የሩሳላመ ቅቲ ማቂ ሮመን Ꮉንጎደስ ቤዛነ» ጋእ መቀዶንያራን አካያራን አꬊ የሩሳላመ Ꮉንጎደስ ቆፋ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ማህ ፋና ማድዙንꬃፓ ላምኡንꬃና ጢሞትዮሳን ኤራስጦሳ መቀዶንያ ኪቲ፥ ፋስ እስያ ግዳ ኤራꬅ ዎደ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","የ ዎደ ላꬄ ኦግት ግሾ ኤፈሶነ ግዳ ዳማ ካች ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ፈቲ ብራ ቆጽዘ ድሜጥሮሳ ጋዘ አꬄ አርጤሚሳ ኤቃ ኬꬃ ምስለ ብራፓ መꬊ ጋማ ትርፈ ድንግዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ይኒ ግሾ፥ ይኒ ፋና ኦቻ ኦችዙንꬃና ፈትላ ሺሺ፥ «አሱንꬆ፥ ኑ ዱረትꬅታ Ꮉና ኦችተ ማቅዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ꮉይ ጳዉሎሳ፥ ‹አስ ኩሸ መꬍንትደ ኤቁንꬃና ባነ› ጋእ፥ ኤፈሶነን ኤራꬅ ሳአፕ አትን ኩሙꬅ እስያ ኡባ የዘ ጋማ አሱንꬃና ኦህ አማንꬅዳኖን ባልꬅዳኖን ይን ብእዳ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ማꬋ ማቅዳና፥ ኑ ኦችታ ለቂንትዛኖ ጻላላ ማቅካይዝን እስያ ሳአ ኡባ የዘ አስ ጎይንዘ ዳማ ኤቃ አርጤሚሰ ኬꬅታ ቦንችንትካይዛር አቶዳና እ ዳማትꬅታ ጎልኦዳኖ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","አሱንꬅ ይኖ ስኤዘ ዎደ ዥልꬊ፥ «ኤፈሶነ አርጤሚሳ ዳማ» ጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ይና ኡፍታ ካታማ ኡባ የልዳ። ጳዉሎሳራ የꬍዘ መቀዶንያ አሱንꬃና፥ ጋዮሳን አርስጥሮኮሳን አይኪ ጎችተር ካእዘ በሳ ዎጽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳዉሎሳን አሱንꬅ ሺቅደ በስተ ገሎደስ ኮይዳ፥ የዝን አማንዙንꬅ ኤዛ ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","እስያ ሳአ Ꮉላቁንꬃፓ ጳዉሎሳ ላገ ማቅደ ፈተ ፈተ ጳዉሎሳጎ ኪቲ፥ «ካስ በስተ ቆንጨ ኬዚ በንትፐ» ጋእ ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ሺቅደ አሱንꬅ Ꮉኖደባዝ ꬋብዳ፤ ጋንግዘ ባጋ አሱንꬅ መለ አቶ የዝን አኮስ ሺቀዛኮ ኤሮሰ ግሾ ፈተ ፈትባዝስ ኡክዘ ዎደ Ꮉንካይ መለባዝስ ኡካነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","አይሁዱንꬅ እስክንድረ ጋዘ አꬃ አꬂ ቤዝን፥ ፈቲ ፈቲ አሱንꬅ ኤ ጋዉደ ባዝ ኦህ ኤዛ ቲኖ አꬅዳ። ኤ አሱንꬅ ስእ ጋዉደ ጋር ፋ ኩሽተ ማሊ ቤዚ፥ አሱንꬅስ ሞትንቶደስ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","የዝን እስክንድረ አይሁደ አስ ማቅዳኖ አሱንꬅ ኤርደ ዎደ ላምእ ሳተ ማቃደ ጋር ኡቡንꬅ ፈቲ ቃላራ፥ «ኤፈሶነ አርጤሚሰ ዳማ» ጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ዉርሱꬅተ ካታማ ጻፍዘ አሱንꬃና ስእ ዪዚ፥ «ኤፈሶነ አሱንꬆ! ኤፈሶነ ካታማ ዳማ አርጤሚሰ ኤቃ ኬꬅን ሳሎፓ ዎꬍደ ዳማ ሹችዛ ናግዛኖ ኤሮሰ አስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ꮉኖ ካድዘ አስ ባይዘ ግሾ ይን ስእ ጋኦደስን ኤልሲ አኮ ባዝ ዪዛንጽ አሾደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ይን Ꮉንꬅ አሱንꬃና፥ ኤቃ ኬꬃ ብራ ካይስትካይዙንꬃናን ኑ ጾዛ ጫዝካይዙንꬃና ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ይኒ ግሾ፥ ድሜጥሮሳን ኤራ የዘ ኦችዘ አሱንꬅ ሞቶደስ ኦና ኮይዛኮ፥ ፍርዳ ኬꬅታ ቡጉꬅ የነ፤ ዳይኑንꬅን የነ፤ ኡን ሞቶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","የዝን ይን መለ ኦሄ ኮይኮ፥ ሻንጎ ሺቅተ ኦህታ ብእንቶ። ");
INSERT INTO oyde_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ይኖ ማቃንጽኮ Ꮉይኖ Ꮉንደ ባዝስ ሮመ ካእቱምታ ኑና ኦጮዳ። Ꮉና ቡቁꬅትስ ምክናተ ባይዘ ግሾ ኑ ምክናቶ ኦሆደስ ዳንዳኦስ» ");
INSERT INTO oyde_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ያጋእ ሺቅቶ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ኡክታ ስእ ጋይዳንፓ ሱባ ጳዉሎሳ አማንዘ አሱንꬃና ጼግዝ ኡንታና ዞሪ ምንꬅꬅዳንፓ ሱባ ሳርꬂ መቀዶና ቅቶደስ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ኤ አꬍዘ ሳአ የዘ አማንዘ አሱንꬅስ ቃላ ኦህ ምንꬅꬅዳንፓ ሱባ ግርከ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ኤ እዘ Ꮉይꬕ አግና በቲ፥ ማርካበራ ሶርያ ቅቶደስ ቆፒ የዝን፥ አይሁዱንꬅ ፋና ዎꬎደስ ኮይዛኖ ኤሪ መቀዶንያራ ሱብ ማቃደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ጳዉሎሳ ሞይዝዱንꬅ ቤርያፓ ጳርሁሳ ናአያ ሶጳጥሮሳ፥ ተሰሎንቀፓ አርስጥሮኮሳን ስኮንዱሳ፥ ደርበፓ ጋዮሳ፥ እስያፓ ትክቆሳ፥ ጥሮፍሞሳን ጢሞትዮሳን። ");
INSERT INTO oyde_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ꮉንስ ቲኖ Ꮉንግ ኑና ጢሮአዳላ ካፋነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ኑ ቦራ ባአለ ቦንችዳንፓ ሱባ ፍልጵስዩሳፓ ማርካበራ ደንዲ፥ እችንꬃ ቃማራ ኡንታና ጢሮአዳ የሊ እዘ ላፑን ቃማ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ሳምንታፓ ቲኖ ቃማ ኑ ቦራ ባጾደስ ሺቂ የዝን፥ ጳዉሎሳ ዎንትስቶ ቅቶደስ ቆፕደ ግሾ ኡንትስ ቃላ ኦህተራ ግዲ ብላሄ የሎደስ ኦህቶ ጋምእዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ኑ ሺቂ በትደ ፎቅተ ጋማ ፎኦ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ኤዉጥኮሳ ጋዘ ፈቲ ይꬍዘ ማስኮተላ በቲ፥ ፋና ቦቲ ገንትዳ። ጳዉሎሳ ኦህቶ ጳርግዝደ ዎደ ኤዉጥኮሳ ገንት Ꮉይꬕንꬃ ፎቅዘፓ ጎልእ Ꮉይቀዝን አሱንꬅ ደንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","የዝን ጳዉሎሳ ዎꬊ፥ ኤላ ዙግዳ። ኤዛ እርንግ፥ «ኤ Ꮉይቂካያ፥ ታንፐተ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ይንፓ ሱባ፥ ኡደ ፎቀላ ኬዚ ቦራ ባጽ ሙእዳ። ሳአ ዎንቶደ ዎንꬅስ አሱንꬅስ ኦህዳንፓ ሱባ ደንዲ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","የ ፋጽደ ይꬍዛ ካራ ካንግ ጋማ ኡፋይትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","የዝን ጳዉሎሳ ፋና እዝፓ ሞኮደ ጋር ኑስ ኦህደ ግሾ ቲንꬊ ማርካበጎ Ꮉንግ፥ አሶሳ ቅቶደስ ደንድዳ። አኮስ ጋይኮ፥ ኤ ቶሄራ ቅቶደስ ቆፕደ ግሾ ኑና Ꮉኒ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ኤ ኑራ አሶሳ የልንትን ማርካበራ ኤዛ ኤኪ ምጢሊነ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ዎንትስት ዎደ እዝፓ ደንዲ ማርካበራ ክዮሳ ቲኖ የዘ በስተ የልዳ፤ ማህ ዎንትስት ዎደ ሳሞሳ ፊንግ ካልዘ ዎድተ ምሊጠ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳዉሎሳ እስያ ግዳ ጋማ ጋምእካይዛራ ኤፈሶነ ካለራ አꬎደስ ቆፕዳ። ፋስ ዳንዳእንትኮ ጰንጠቆስጠ ባአለ ዎደ የሩሳላመ የሎደስ ኤልሳነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ጳዉሎሳ ምሊጠፓ ኤፈሶነ ኪቲ ዎሳ ኬꬃ ጭሙንꬃና ጼግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ዎሳ ኬꬃ ጭሙንꬅ ኤጎ ይእን፥ ኡንታጎ Ꮉንጋራ ያጋይዳ፦ «ታኒ እስያ ገልደ ቲኖ ቃምትፓ አይኪ ይንታራ የዝደ ዎደ ኡባ ዋይዝ የዘዛኮ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","አይሁዱንꬅ ሺቂ ታላ ማꬋ የልꬅኮን ታ አሽከትꬃራን ጋማ አፉꬃራ ላꬅስ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ቡጫን ይን ኬꬅተ ኬꬅተ ይንታና ታማርስተራ ይንታና ማድዘ ባዛፓ ፈትባዝን ፋጭዝካያ። ");
INSERT INTO oyde_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ታኒ አይሁዱንꬅስን አይሁደ ማቆሱንꬅስ ናጋራፓ ጾዛጎ ማቃደ ጋራን ኑ ላꬄ የሱሳ አማኖደ ጋር ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«እዘ ታና አኮ የሎደ የዛኮ ኤሮስ፥ የዝን Ꮉተ ታኒ ጌሽ አያናስ ኪትንቲ የሩሳላመ ቅታነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ይኖ ማቅኮን ጌሽ አያና ካታማ ኡባ አችን ማꬋን ታና ናግዛኖ ታስ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","የዝን ታ ዎꬅቶ ፎሎደስ ላꬄ የሱሳፕ ኤክደ ኦችቶ፥ ጾዘ አꬎ ኬሃትꬅ ዎንገለ ማርክꬍዛኖ ፎሎደስ ታ ሸምፕቶ ፋꬆሰ ባዝ ፋና ፋይዳነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«ታኒ Ꮉተን ጾዘ ካእቱሞ ማርክꬍተራ ይን ግዳ ዉትዳ። ይኬፓ ሱባ ይንታፓ ኦደን ታና በአማኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ይኒ ግሾ፥ ይንታፓ ፈቲ አስ ꬋብኮን ታ ኦጭንታማኖ Ꮉይኖ ቃማ ይንትስ ጌሽ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","አኮስ ጋይኮ፥ ጾዘ ቆፋ ኡባ ይንትስ አኮ ባዝን አሽካይዛራ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«ፋ ናአይ ሱꬅተ ዎንግደ ጾዘ ዎሳ ኬꬅቶ ናጎተ። ጌሽ አያና ይንታና የንግዙንꬃና ማህ ዶርደ ዉድትስን ይን ኦምትስን ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ታኒ Ꮉንግዳንፓ ሱባ፥ ዉድትስ ይቅስንቶሰ ኢታ ሱዹሙንꬅ ይን ግዳ ገሎዳኖ ታ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ታማሩንꬃና ፋ ሱብ ካልꬆደስ ዎርዶ ታማርስዘ አሱንꬅ ይን ግዳፓ ደንዶዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ይኒ ግሾ፥ ታ Ꮉይꬕ በረ ቃማን አዋራን አፉꬃራ ይንታና ኦምተ ኦምተ ካጭዳኖ ቆፕተር ምንጎተ። ");
INSERT INTO oyde_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Ꮉተን ይንታና ምንꬆደስን ጌሽ አሱንꬃራ ላታ እማደስ ዳንዳእዘ ጾዘስን ኤ አꬎ ኬሃትꬅ ቃላስ ይንታና Ꮉዳራ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«ታኒ ኦደፓን ብራ ዎይ ዎርቃ ዎይ አፉላ ኤክካያ። ");
INSERT INTO oyde_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ታኒ ታ ኩሽተ ኦቺ ታስን ታራ የዙንꬃና ቤዘባዝ ማድዳኖ ይን፥ ይን ኦምተ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ይን Ꮉንፋና ላቢ ኦችተራ ላቢዱንꬃና ማዶዳኖን ላꬂ የሱሳ፥ ‹ኤክዘፓ አꬊ እንግዛይ አንጅንትዳያ› ጋይደ ቃልቶ ይን ቆፖደስ ቤዛኖ ታ ይንታና ኡባባዝተ ቤዝዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ጳዉሎሳ ይኖ ኦህ Ꮉሲ ኡን ኡቡንꬃራ ቡንቁንቲ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ኡን ኡቡንꬅ ጳዉሎሳ እርንግ ዬኪ ዬሪዳ። ");
INSERT INTO oyde_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ኤ ማህ፥ «ታና በአማ» ያጋይደ ቃልታ ኡንታና ጋማ አዛንꬅዳ። ኡን ማርካበ የሎደስ ኤዛ ሞይዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ኑ ኤፈሶነ ጭሙንꬃፓ ሻግንትደፓ ሱባ ማርካበራ ቆሰ ቅትዳ። ዎንትስት ዎደ ሮዳ የሊ እዝፓ ጳጥራ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ፈንቀ ፊንግዘ ማርካበ ደንግ ኤ ግዳ ገሊ ቅቶደስ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ኑ ቆጵሮሳ ብእደ ዎደ፥ ቆጵሮሳ ዎርክታ ባጋ አሺ ሶርያ የꬍዳ። ማርካብዘ ፋ ጫንቶ እዘ ኬꬆደስ ኮይደ ግሾ ጢሮሳ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","እዘ አማንዘ አሱንꬃና ደንግ ኡንታራ ላፑን ቃማ በትዳ። ጳዉሎሳ የሩሳላመ ቅታመ ጋር ኡን ኤስ አያናራ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ኑኒ ኡን ካለ ጋምእዘ ዎድታ Ꮉልእን ኬዚ ቅትዳ። ኡን ኡባ ፋ ማቹንꬃራን ፋ ናኡንꬃራ ዎላ ካታማፓ ጋጻ ኬሲ ኑና ሞይዝዳ። ኑ አባ ካለ ቡንቁንቲ ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ይንፓ ሱባ፥ ዎል ሳሮꬅን ኑ ማርካብተ ገልዳ፤ ኡን ፋ ካራ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ኑ አባ ኦግቶ Ꮉሲ፥ ጢሮሳፓ ጰጠለማይሳ የልዳ። እዘ አማንዘ አሱንꬃና ሳርꬂ፥ ኡን ካለ ፈቲ ቃማ ፌዥዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ዎንትስት ዎደ ኬዚ፥ ቂሳርያ ቅትዳ። ሳባኬ ፍልጶሳ ካራ የሊ ኤ ካለ በትዳ። ኤ የሩሳላመ ቲኖ ዶርንትደ ላፑንꬃፋ ፈታ። ");
INSERT INTO oyde_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ፍልጶሳስ ናበ ማቅደ ኦይዲ ዉዱር ናኡንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ኑኒ ኡንደና ቃማ እዘ በቴዝን አጋቦሳ ጋዘ ናበ ይሁዳፓ ቂሳርያ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ኑጎ ይእ ጳዉሎሳ ሳቀ ኤኪ ናብዘ ፋ ኩሽቶን ፋ ቶህቶ አጪ፥ «ጌሽ አያና Ꮉይ ሳቂዘ አዳያ፥ የሩሳላመ አይሁዱንꬅ Ꮉንጋራ አጪ፥ አይሁደ ማቆሰ አሱንꬅስ አꬂ እንጎዳ ጋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ኑኒ ይኖ ስእደ ዎደ ኑንን የዘ አሱንꬅ ጳዉሎሳ የሩሳላመ ቅታመ ጋር ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","የዝን ጳዉሎሳ ማህ፥ «ይን Ꮉንጋራ ዬክተራ አኮስ ታ ዎዝንቶ ታንዘ? ታኒ፥ ላꬄ የሱሳ ሱንꬅት ግሾ አጭንተ ጻላላ ማቅካይዝን የሩሳላመ Ꮉይቆደስን ጊግንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ኑ ዞሪዳኖ ኤ ኤካንጽ እጽን፥ «ላꬄ ቆፍታ Ꮉኖ» ጋእ ስእ ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","እዘ ኤራꬅ ዎደ ጋምእዳንፓ ሱባ ጊግንቲ የሩሳላመ ቅቶደስ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ቂሳርያ የዘ አማንዘ አሱንꬃፓ ኤራꬁንꬅ ኑራ Ꮉንግዳ። ኡን ኑኒ ሸምፖደ በሲ ምናሶነ ጋዘ ቆጵሮሳ አꬄ ካራ ካልꬅዳ። ምናሶነ ቲኖ አማንደ አሱንꬃፓ ፈታ። ");
INSERT INTO oyde_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ኑኒ የሩሳላመ የልደ ዎደ አማንዘ አሱንꬅ ኑና ኡፋይት ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ዎንትስት ዎደ ጳዉሎሳን ኑኒ ያይቆባራ የልንቶደስ ቅትዳ። ዎሳ ኬꬃ ጭሙንꬅ ኡቡንꬅ እዘ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ጳዉሎሳ ኡንታና ሳርꬅዳንፓ ሱባ አይሁደ ማቆሰ አሱንꬅ ግዳ ፋ ባጋራ ጾዚ ኦችዳኖ ኡባ ኡንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ኡን ይኖ ስእደ ዎደ ጾዝ ጋላቲ ጳዉሎሳጎ Ꮉንጋራ ያጋይዳ፦ «ኑ እሻዮ፥ አይሁዱንꬅ ግዳ ዋንꬅ ሙኩሉንꬅ ጾዝ አማነዛኮ ነ በእነ፤ ኡን ኡቡንꬅን ህገ ምንꬂ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ኔኒ አይሁደ ማቆሱንꬃና ሳአ የዘ አይሁደ ኡባ ፋ ናኡንꬅ ጋራዝንታመ ጋር፥ አይሁዱንꬅ ዎጋ ካላመ ጋራን ሙሴ ህገ እጾደ ጋር ኔኒ ታማርስዛኖ የሩሳላመ የዘ አይሁዱንꬅ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ዬዝን አኮ ሎኦ? ነ ይእዳኖ ቱሮ ስኦዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«ይኒ ግሾ፥ ኑኒ ኔስ ኦህዛኖ ስኦ፤ ገፋ የዘ ኦይዲ አሱንꬅ ኑ ካለ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ኡንታና ኤኪ ኡንታራ ጌዦ፤ ማህ ኡን ፋ ኦምቶ ሜድንቶደ ጋር ኡንትስ ሚሸ እንጎ። ኡን ዛጋ ነባዝ ስእዳና ቱሮ ማቅካይዛኖን ኔኒ ነ ኦምተን ህገ ናግዘ አስ ማቅዳኖ ኡቡንꬅ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«የዝን አማንዘ አይሁደ ማቆሰ አሱንꬃና ማቅዛኮ፥ ኡን ኤቃስ ዣርሽንትደባዝ ማአመ ጋር፥ ሱꬅ ኡዣመ ጋር፥ ባዉታ ማአመ ጋራን ኦላላመ ጋር፥ ኑኒ ኦህቶ አጪ፥ ፍርድ ኡንትስ ኪታ ጻፍዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ይንፓ ሱባ፥ ጳዉሎሳ ዎንትስት ዎደ አሱንꬃና ኤኪ፥ ኡንታራ ጌዥዳ። ኤ ፋ ጌዠ ዎድታ አይደ ፎልንቶደ የዛኮ ኤርሶደስን ፋ ዣርሽቶ አይደ ዣርሾደ የዛኮ ኤርሶደስ ጾዘ ኬꬃ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ላፑን ቃማ ፎልንቶደስ ኡኮደራ፥ እስያፓ ይእደ አይሁዱንꬅ ጾዘ ኬꬃ ጳዉሎሳ ብእ፥ አስ ኡባ ደንꬅꬂ ጳዉሎሳ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«እስራኤለ አሱንꬆ፥ ኑና ማዶተ፤ Ꮉይ አꬄ፥ ኑ ዎርዥቶ፥ ኑ ህግቶን Ꮉና ጾዘ ኬꬅቶ እጾደ ጋር አስ ኡቡንꬃና ኡባ በሳ ታማርሳነ። ይናን ማቃንጽ እጽን አይሁደ ማቆሱንꬃና ጾዘ ኬꬃ ገልꬂ፥ Ꮉና ጌሽ በስቶ ቱንዝዳ» ያጋእ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ኡን ይኖ ጋይዳና ዛጋ ኤፈሶነ ጥሮፍሞሳ ጳዉሎሳራ ካታማ ብእደ ግሾ Ꮉተ ጳዉሎሳ ጾዘ ኬꬃ ኤዛ ኤኪ ገልደባዝ ኡንትስ አዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ካታምታ ኡባ ቡቅንትዳ፤ አሱንꬅ ኡባ ሺቂ ጳዉሎሳ አይኪ ጾዘ ኬꬃፓ ባለ ጎችዳ። ጾዘ ኬꬃ ፉርꬅታ ኤልሲ ጎርድንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","አሱንꬅ ጳዉሎሳ ዎꬎደስ ይአደራ፥ «የሩሳላመ ካታማ ኩሙꬅ ቡቅንትዳ» ጋዘ ዎርታ ሮመ ሻላቃጎ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ሻላቅዘ ዎታዳሩንꬃናን ማቶ Ꮉላቁንꬃና ኤኪ ዎጽተራ ይእዳ። አሱንꬅ ሻላቅዛን ዎታዳሩንꬃና ብእደ ዎደ ጳዉሎሳ ጉድዛኖ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","የ ዎደ ሻላቅዘ ሺቂ፥ ጳዉሎሳ አይኪ፥ ላምእ ሳንꬃላታራ አጭንቶደ ጋር ኪትዳ። የይዝ፥ ኤ ኦና የዛኮን አኮ ኦቼዛኮ አሱንꬃና ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","አሱንꬃፓ ባግታ ፈትባዝ ጋእ ኡክዘ ዎደ Ꮉንኩንꬅ መለባዝ ጋእ ኡካነ። ኡክታ ጋንግደ ግሾ ሻላቅዘ ቱርቶ ሻጎደስ ዳንዳእንታንጽን፥ ዎታዳሩንꬅ ጳዉሎሳ ፋ የዘ በሳ ካንጎደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ጳዉሎሳ የꬊ ከዝዘ ዳራጅቶ የልዘ ዎደ አሱንꬅ ኡርቂዛን ግሾ ዎታዳሩንꬅ ኤዛ ቶክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ጋማ አሱንꬅ፥ «ኤ Ꮉይቆ!» ጋእ ኡክተራ ካላነ። ");
INSERT INTO oyde_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ዎታዳሩንꬅ ጳዉሎሳ ፋ የዘ በስቶ ገልꬆደስ ይአደራ፥ ጳዉሎሳ ሻላቅዘጎ፥ «ታኒ ኔስ ፈትባዝ ኦህኮ ስኦዳተ?» ጋይዳ። ኤ ጳዉሎሳጎ፥ «ነ ግርኬ ዶና ኤራነ? ");
INSERT INTO oyde_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ኔኒ Ꮉንፓ ቲኖ ቡቁꬅ መꬊ ሸምፖ ዎꬍደ ኦይዲ ሙኩል አሱንꬃና ኤኪ አኮ ባይዘ ጋናስ ገልደ ግብጸ አꬃ ባነ?» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","የዝን ጳዉሎሳ፥ «ታኒ፥ ክልቅያ የዘ ኤርንትደ ተርሴሰ ካታማ አስ ማቅደ አይሁደ አስ። ታና አሱንꬅስ ኦህዞያ?» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ሻላቅዘ ኤጎ፥ «ኦሆ» ጋእን ጳዉሎሳ ዳራጃላ ኤቂ፥ አሱንꬅ ስእ ጋዉደ ጋር ፋ ኩሽትራ ማሊዳ። አሱንꬅ ስእ ጋእን እብራይስጠ ዶናራ Ꮉንጋራ ጋይዳ፦ ");
INSERT INTO oyde_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«ታ እሹንꬆን፥ ታ አዱንꬆ፥ ታኒ Ꮉተ ይንትስ እንግዘ ማህቶ ስኦተ።» ");
INSERT INTO oyde_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ጳዉሎሳ ኡንትስ እብራይስጠ ዶናራ ኦህዛና ስእ ካሰንፓ አꬂ ስእ ጋይዳ። ኤ ካሊ፥ ");
INSERT INTO oyde_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«ታኒ ክልቅያ የዘ ተርሴሰ የልንት Ꮉና ካታምተ ድጭዳ። ታ አስታማርዘን ጋማልያለ፤ ታኒ ኑ አዱንꬅ ህግቶ ምንꬂ ታማርዳ፥ Ꮉይኖ ይን ኡባ Ꮉንዛንጋራ ጾዝስ ምሽንትዘ አይሁደ አስ። ");
INSERT INTO oyde_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ታ Ꮉና ኦግቶ ካልዘ ማቹንꬃናን ꬊራꬁንሳና አይኪ አች ኬꬃ ኦልተራን ኡንታና ዎዽሳደ ዎንꬅስ ማꬋ ቤዘ አስ። ");
INSERT INTO oyde_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ይኒ ጋራ፥ ካህኑንꬅ Ꮉላቅዘን ሻንጎ ኡባ ታ ባዝ ማርክꬋደስ ዳንዳአነ። ታኒ ዳማስቆ የዘ ኡን እሹንꬅስ ኡንታፓ ዳብዳበ ኤኪ እዘ የዘ አሱንꬅ አጭንቲ ሴርንቶደ ጋር የሩሳላመ ኡንታና ኮኦደስ እዘ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«ታ Ꮉንግ ዳማስቆ ኡክደ ዎደ አዋራ ሳተ ቆፕካይዝን ሳሎፓ ዳማ ፎኦ ታ ካንቶ ዉቲ ፎእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ታ ሳእተ ጎልእ የሳደራ፥ ‹ሳዉላ፥ ሳዉላ፥ ታና አኮስ ባይꬄ?› ጋዘ ቃላ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ታኒ ማህ፥ ‹ላꬆ፥ ኔኒ ኦደ?› ያጋይዳ። «ኤ ማህ፥ ታኒ፥ ነ ባይꬅዘ ናዝረተ የሱሳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ታራ የዙንꬅ ፎእቶ ብእዳፕ አትን ታስ ኦህዘ ቃልቶ ስእካያ። ");
INSERT INTO oyde_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«ታኒ፥ ‹ላꬆ፥ ታ አኮ ኦቾ?› ያጋይዳ። «ላꬂ ታጎ፥ ‹ደንዲ ዳማስቆ ቅቶ። ነ ኦቾደ ጋር ጾዚ ቆፕደባዝ ኡባ እዘ ኔስ ኦህንቶዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ይና ዳማ ፎእትፓ ደንዲ ታ ኣፍታ ꬉምን፥ ታራ የዘ አሱንꬅ ታ ኩሽቶ አይኪ፥ ታና ጎቺ ዳማስቆ የልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«ዳማስቆ የዘ አይሁዱንꬅ ኡባ ማርክዘን ጋማ ቦንችዘ ፈቲ ሀናንያ ጋዘ አꬄ፥ ኑ ህግቶ ቦንችዘን ጾዝ ምንꬂ ዎስዘ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ኤ ታጎ ይእ፥ ታ ካለ ኤቂ፥ ‹ታ እሸ ሳዉላ፥ ቦኦ› ጋይዳ። ኤልሲ ታ ኤዛ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«ኤ ታጎ፥ ‹ኑ አዱንꬅ ጾዘ ኔኒ ኤ ቆፍቶ ኤሮደ ጋር፥ ጽልዛ በአደ ጋራን ኤ ዶንትፓ ቃላ ስአደ ጋር ቲኒ ነና ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ኔኒ ብእደባዝስን ስእደባዝ አስ ኡባ ቲኖ ኤስ ማርካ ማቃደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ꮉተ አኮስ ጋምኤ? ጻማቅንቶ፤ ኤ ሱንꬅቶ ጼጊ ነ ናጋርትፓ ሜጭንቶ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«ታኒ ሱባ የሩሳላመ ማቂ ጾዘ ኬꬃ ዎሶደራ፥ ታስ ቆንጭꬅ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ቆንጭስተ ላꬂ ታጎ፥ ‹ነ ታስ ማርክꬍዘ ማርካትꬅቶ አሱንꬅ ኤኮሰ ግሾ ኤልሲ የሩሳላመፓ ከዞ› ያጋኦደራ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«ታኒ፥ ‹ላꬆ፥ አይሁደ ዎሳ ኬꬃ ኡባ ነና አማንዙንꬃና አይኪ Ꮉꬍዳያን አች ኬꬃ ኦልዳያ ማቅዛኖ ኡን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ኡን ነ ማርካ እስጢፋኖሳ ዎꬍዘ ዎደ ታ ይና ኦችተ ዎላ የነ። ማህ ኡን ካለ ኤቂ ኤዛ ዎꬍዙንꬅ ማእቶ ናጋነ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«ላꬂ ታጎ፥ ‹ታኒ ነና አይሁደ ማቆሰ አሱንꬃጎ Ꮉኮ ሳአ ኪቶደ ግሾ ደንዲ ቅቶ› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ጳዉሎሳ ይና ቃልቶ ኦህ Ꮉሶደ ዎንꬅስ አሱንꬅ ኤ ጋዛኖ ስእነ። ይንፓ ሱባ፥ ፋ ቃልቶ ꬎቅ ዪዚ፥ «Ꮉና ሳእትፓ ꬋብሶ! ኤ የሳደስ ቤዞስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ኡን ካጭንቲ፥ ፋ ማእቶ ኤላ አፋ ꬎጊ ጹራ ኡደ ላሎደራ፤ ");
INSERT INTO oyde_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ሻላቅዘ ብእ ዎታዳሩንꬅ ጳዉሎሳ ኡን ፋ የዘ በሳ ካንጎደ ጋራ ኪትዳ። ማህ አሱንꬅ አኮስ Ꮉንጋራ ካጭንተዛኮ ኤሮደስ ኮይ ጳዉሎሳ ዳፈራ ጋራፊ ሎይꬂ ኦጮደ ጋር ኡንታና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","የዝን ዎታዳሩንꬅ ጳዉሎሳ ዳፈራ ምንꬂ አጪ ጋራፎደስ ዪዘ ዎደ ጳዉሎሳ ፋ ካንተ ኤቅደ ማቶ Ꮉላቅዘጎ፥ «ሮመ አስ ፍርዳ ባይዝን ጋራፍዛና ይንትስ ዎጋ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ማቶ Ꮉላቅዘ ይኖ ስእደ ዎደ ሻላቅዘጎ Ꮉንግ፥ «Ꮉይ አꬄ ሮመ አስ። ኔኒ አኮ ኦቾደስ ቆፐ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ሻላቅዘ ጳዉሎሳጎ ሺቂ፥ «ነ ሮመ አሶ? አነ ታስ ኦሆ» ያጋይዳ። ጳዉሎሳ፥ «ዬ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ሻላቅዘ ማህ፥ «ታኒ Ꮉኖ ጋደትꬅቶ ጋማ ሚሸራ ኤክዳ» ያጋይዳ። የዝን ጳዉሎሳ፥ «ታ Ꮉና ጋደትꬅቶ የልንት ኤክዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ይኒ ግሾ፥ ጳዉሎሳ ሎይꬂ ኦጮደስ ቆፕዱንꬅ ኢራ ኤፓ ሻክንትዳ። ሻላቅዘ ሮመ አስ ሳንꬃላታራ አጭዳኖ ኤርደ ዎደ ዣሽትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ዎንትስት ዎደ ሻላቅዘ፥ አይሁዱንꬅ ጳዉሎሳ አኮስ ሞተዛኮ ሻኪ ኤሮደስ ኮይ ብልዳ። ካህኑንꬅ Ꮉላቁንꬅን ሻንጎ ኡቡንꬅ ሺቆደ ጋር ኪትዳ፤ ማህ ጳዉሎሳ ክእ ኡን ቲኖ ኤስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ጳዉሎሳ ፍርድዘ አሱንꬃና ዳኪ ብእ፥ «ታ እሹንꬆ፥ ታ Ꮉይኖ የሎደስ ጾዘ ቲኖ ታ የስተ ኡባ ሎኦ ዎዝናራ የዝዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ካህኑንꬅ Ꮉላቅዘ ሀናንያ፥ ጳዉሎሳ ዶንቶ ባቆደ ጋር ኤ ካለ ኤቅዱንꬃና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","የ ዎደ ጳዉሎሳ ኤጎ፥ «ናተ ቦꬅ ፎርቾ ትዥንትደ ዶቸይ፥ ጾዚ ነና ባቆዳ። ኔኒ ታላ ህገራ ፍርዶደስ በቲ የዝተ ህገ አሺ ታና ባቃደ ጋር ኪታነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ጳዉሎሳ ካለ ኤቅዱንꬅ ኤጎ፥ «ነ ጾዘ ካህኑንꬅ Ꮉላቃ ጫዣነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ጳዉሎሳ፥ «ታ እሹንꬆ፥ ኤ ካህኑንꬅ Ꮉላቃ ማቅዳኖ ታ ኤርካያ፤ አኮስ ጋይኮ ጾዘ ቃልተ፥ ‹ነ ዎርዣ አህዘላ ኢታ ቃላ ኦህፐ› ያጋእንት ጻፍንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","የዝን ጳዉሎሳ ይና በስተ የዘ አሱንꬃፓ ባጉንꬅ ሳዱቃዉያነ፥ ባጉንꬅ ፋርሳዉያነ ማቅዛኖ ኤሪ፥ «ታ እሹንꬆ፥ ታ ፋርሳዉያነ ፋርሳዉያነ ናአ፤ ‹Ꮉይቂዱንꬅ Ꮉይቆፓ ደንዶዳ› ጋእ ታኒ ኡፋይሳራ ናግዘ ግሾ ኡን ታላ ፍርዳነ» ያጋእ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ጳዉሎሳ ይኖ ጋይደ ዎደ ፋርሳዉንꬅ ግዳን ሳዱቃዉንꬅ ግዳ ካች ከዝን ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","አኮስ ጋይኮ፥ ሳዱቃዉንꬅ፥ «Ꮉይቂደ አስ ደንዶስ፤ ኪታንቾን፥ አያናን ባያ» ያጋዙንꬃና። የዝን ፋርሳዉንꬅ ኡባ የዛኖ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ዳማ ካች ከዝዳ፤ ፋርሳዉንꬅ ዛላ ማቅደ ህገ አስታማሩንꬅ ደንዲ ኤቂ፥ «Ꮉይ አꬄላ አኮ ባላ ባዝ ደንግካያ፤ ኤስ አያና ዎይ ኪታንቾ ኦህካይዛራ አሾስ» ያጋእ ዎላ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ካችታ ጋንግን አሱንꬅ ጳዉሎሳ ሻቅꬅ ኤካመ ጋር ጋእ፥ ሻላቅዘ ፋ ዎታዳሩንꬅ ዎꬊ ኡን ግዳ ፋ ኤዛ ኤልሲ ኬሲ ፋ የዘ በሳ ካንጎደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ይኒ ቃማ ላꬂ ጳዉሎሳ ካለ ኤቂ፥ «ጳዉሎሳ፥ ነ ታስ የሩሳላመ ማርክꬍዳን ፋና ሮመን ማርክꬋደስ ቤዛነ፤ ምንጎ፤ አኮ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ዎንትስት ዎደ አይሁዱንꬅ፥ «ጳዉሎሳ ዎꬍካይዛራ ሞኦስ ኡዦስ» ጋእ ጫቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ጳዉሎሳላ ይኖ ዞርንት ጫቂደ አሱንꬅ ኦይታማፓ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ኡን ካህኑንꬅ Ꮉላቁንꬅ ጋደ ጭሙንꬃጎ Ꮉንግ፥ «ኑኒ ጳዉሎሳ ዎꬍካይዛራ ካꬃ ጋዘባዝ ሞኦስ ጋእ ጫቂዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ይኬ፥ ይንትን ሻንጉንꬅን ኤ ባዝ ሎይꬂ ቁርችዘባዝ የዘ ባዝ ማህ፥ ጳዉሎሳ ይንታጎ ኮኦደ ጋር ሻላቅዛ ኦጮተ። ኑኒ ኤ Ꮉና ሺቅታ የሎዳንፓ ቲኖ ኤዛ ዎꬎደስ ጊጊ በትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","የዝን ጳዉሎሳ ምሽት ናአይ ይና ዞርንትዳኖ ስእ Ꮉንግ ዎታዳሩንꬅ የዘ በስቶ ገሊ፥ ጳዉሎሳስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ጳዉሎሳ ማቶ Ꮉላቁንꬃፓ ፈታ ጼጊ፥ «Ꮉይ ናአያ ሻላቅዘስ ኦህዘ ባዝ የዘ ግሾ ኤዛ ሻላቅዘጎ ካንጎ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ማቶ Ꮉላቅዘ ናአያ ሻላቅዘጎ ካንግ፥ «አች ኬꬃ የዘ ጳዉሎሳ ታና ፋጎ ጼጊ፥ Ꮉይ ናአይ ኔስ ኦህዘ ባዝ የዘ ግሾ ኤዛ ኔጎ ኮኦደ ጋር ታና ዎስዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ሻላቅዘ ናአይ ኩሽቶ አይኪ፥ ባለ ኬሲ፥ «ነ ታስ ኦሆደ ቆፍታ አኮ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ናአይ ሻላቅዘጎ፥ «አይሁዱንꬅ ጳዉሎሳባዝ ቲኖፓን ሚንꬂ ቁርቾደስ ኮይዘ ጋር አዝን ኔኒ ዎንታ ኤዛ ሺቅተ ኮኦደ ጋር ነና ዎሶደስ ዞረ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","የዝን ኔኒ ኡን ጋዛኖ ስእፐ። አኮስ ጋይኮ፥ ኦይታማፓ አꬍዘ አሱንꬅ ጳዉሎሳ ዎꬍካይዛራ ‹ካꬃ ሞኦስ፥ Ꮉꬅ ኡዦስ› ጋእ ጫቂ፥ አችንት ኤዛ ካፋነ። Ꮉተ ነ ጋዘባዝ ጻላላ ስኦደስ ካፋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ሻላቅዘ ማህ፥ «Ꮉና ኦህቶ ነ ታስ ኦህዳኖ መለ ኦደስን ኦህፐ» ያጋእ ናአያ ሱብ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ሻላቅዘ ማቶ Ꮉላቁንꬃፓ ላምኡንꬃና ጼጊ፥ «ቃማፓ Ꮉይꬕ ሳተ ቂሳርያ ቅቶደስ፥ ላምእ ጼት ዎታዳሩንꬃና፥ ላፑን ታም ፋራ አሱንꬃናን ላምእ ጼት ቶራ ዎርንግዙንꬃና ጊግዞተ። ");
INSERT INTO oyde_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ጋድቶ አህዘ ፍልክሳጎ ጳዉሎሳ ሳሮ የልꬆደስ ቶግዘ ፋራ ጊግዞተ» ያጋእ ኡንታና ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ሻላቅዘ ፍልክሳስ Ꮉንጋራ ጋዘ ዳብዳበ ጻፍዳ፦ ");
INSERT INTO oyde_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«ቃላዉድዮሳ ሉስዮሳፓ ጋደ አህዘ ቦንቾ ፍልክሳሳ፥ ሳሮ ኔስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","አይሁዱንꬅ Ꮉይ አꬃ አይኪ ዎꬎደስ ይአደራ፥ ኤ ሮመ ሳአ አስ ማቅዳኖ ኤሪ ዎታዳሩንꬃራ የሊ ኤዛ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ኡን ኤዛ አኮስ ሞትዛኮ ኤሮደስ ኮይ ኡን ሺቅተ ኤዛ ታ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ኡን ፋ ህግትስ ኤዛ ሞትዳፕ አትን ኤዛ ዎꬍዘባዝ ዎይ አጭዘባዝ ባይዛኖ ታ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ኡን Ꮉይ አꬄላ ዞርንትደ ዝግርስታ ታና የልን፥ ታ ኤልሲ ኤዛ ኔጎ ዳክዳ። ኤዛ ሞትዙንꬅ ነ ቲኖ Ꮉንግ ሞቶደ ጋር ኪትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ይኒ ግሾ፥ ዎታዳሩንꬅ ኪትንትዳን ፋና ጳዉሎሳ ኤኪ፥ ቃማ አንትጳጥርሳ የልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ዎንትስት ዎደ ፋራ አሱንꬅ ኤራ Ꮉንጎደ ጋር የይዝ አሱንꬅ ሱብ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ቶግዱንꬅ ቂሳርያ የሊ ዳብዳቢዛ ጋደ አህዘስ እንግ፥ ጳዉሎሳ ኤ ቲኖ አꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ጋደ አህዛይ ዳብዳቢዛ ናባብዳንፓ ማቂ «ጳዉሎሳ፥ ነ አባ ጋደ አሶ?» ጋእ ኤዛ ኦጭዳ። ኤ ክልቅያ አስ ማቅዳኖ ኤርደ ዎደ ");
INSERT INTO oyde_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«ታኒ ነባዝ ነና ሞትዙንꬅ ይእደ ዎደ ስኦዳ» ያጋይዳ። ዎታዳሩንꬅ ጳዉሎሳ ሄሮድሳ ግበ ናጎደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","እችን ቃማፓ ሱባ ካህኑንꬅ Ꮉላቅዘ ሀናንያ፥ ጭሙንꬃራን ጠርጠሉሳ ጋዘ ፈቲ ጻባቅዘራ ቂሳርያ ቅትዳ። ኡን ጋደ አህዙንꬃላ ጳዉሎሳ ሞትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ጳዉሎሳ ጼግንት ገልደ ዎደ ጸርጸሉሳ ኤዛ Ꮉንጋራ ያጋእ ሞትዳ፦ «ቦንቾ ፍልክሳ፥ ኑኒ ነ ባጋራ ጋማ ሳሮ ደንግዳ፥ ነ ሎኦ አህዛነ ኑ ጋድታ ጋማ ላምንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ቦንቾ ፍልክሳ፥ ኑኒ አባን አይደ ማቅን ፎሎ ጋላታራ ይኖ ኤካነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ታኒ ነና ጋምእዝካይዛራ ኔኒ ነ ኬሃትꬅተ ኑ ባዝ Ꮉታራ ስኦደ ጋር ነና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ꮉይ አꬄ ꬉበ ማቂ ሳአ ኡባ የዘ አይሁዱንꬅ ግዳ ቡቁꬅ መꬊ ናዝራዉንꬅ ባጋ አሱንꬃና ካልꬅዛያ ማቅዳኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","መለ አቶ የዝን፥ ጾዘ ኬꬅቶ ቱንሳደስ ይአደራ ኑኒ ኤዛ አይክዳ፤ ኑ ህግትጋራ ኤዛላ ፍርዶደስ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","የዝን ሻላቅዘ ሉስዮሳ ይእ፥ ዎልቃራ ኑ ኩሽትፓ ኤዛ ኬሲ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ኤዛ ሞትዙንꬅን ኔጎ የኦደ ጋር ኪትዳ። ኔኒ ነ ኦምተ Ꮉይ አꬃ ቁርች ኑኒ ኤዛ ሞትዘ ሞቶ ኡባ ኤሮደስ ዳንዳአነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","አይሁዱንꬅን፥ «Ꮉና ኦህታ ቱሮ» ጋእ ኤ ቆፍቶ ማእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ጋደ አህዛይ ጳዉሎሳ ኦሆ ጋእ ማሊዳ። ጳዉሎሳ Ꮉንጋራ ጋእ ማህዳ፦ «ኔኒ ጋማ ዎደፓ አይኪ፥ Ꮉንꬅ አሱንꬅስ ፍርድተራ የዛኖ ኤሪ ታ ኦህትስ ኡፋይስ ዎꬍን ማሄ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ታኒ ጎይኖደስ የሩሳላመ ከዝን ታጶ ላምእ ቃማፓ አꬎሳኖ ኔኒ ነ ኦምተ ኤሮደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","አይሁዱንꬅ ታና ጾዘ ኬꬃ ማቅን አይሁዱንꬅ ዎሳ ኬꬃ ማቅን ካታማ ማቅን ኦደራን ላሎደራ ዎይ አስ ሺሺ ቡቁስ ደንꬅꬆደራ ፈቲ አስን ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ꮉተን ኡን ታና ሞትዘ ባዝትስ ማርካ ደንጎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«የዝን ታኒ ፈትባዝ አማናነ፤ ታኒ ህገ ግዳ የዘባዝን ናቡንꬅ ጻፍደ ኡባባዝቶ አማኒ፥ ኑ አዱንꬅ ጾዛ፥ ኡን ዎርዶ ትምርትተ ኦግተ ጎይናነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ኡን ፋ ኦምተ አማንዛን ጋር ጽሉንꬅን ናጋራንቹንꬅን Ꮉይቆፓ ደንዶዳኖ ታንን አማናነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ይኒ ግሾ፥ ታኒ ጾዘ ቲኖን አስ ቲኖ ኡባ ዎደ ሎኦ ቆፋ ታስ የሳደ ጋር ምንጋነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«ታኒ የሩሳላመፓ ከዝዳንፓ ጋማ በረፓ ሱባ ታ ባጋ ዳሁንꬅስ ማደ እማደስን ዣርሾ ዣርሾደስ የሩሳላመ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ታኒ ጾዘ ኬꬅተ ይኖ ኦቺ ጌዠ ዎጋ ፎሊ ማቃደራ ታና ደንግዳ። የ ዎደ ታራ ጋማ አስ ባያ፥ ካችን ከዝካያ። ");
INSERT INTO oyde_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","የዝን እስያፓ ይእደ ፈቲ ፈቲ አይሁዱንꬅ እዘ የነ፤ ኡን ታላ ኦሆደስ ኮይኮ ይእ ታና ኔላ ሞቶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ዎይ ታኒ ሻንጎ ቲኖ ሺቅደ ዎደ ኦችደ ባላ የዝኮ Ꮉንስ ነ ቲኖ የዙንꬅ ኦሆ። ");
INSERT INTO oyde_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ቱሮ ታኒ ኡን ግዳ ኤቂ ‹Ꮉይቂዱንꬅ ደንዶ የነ ጋእ Ꮉይኖ ፍርዳስ ይን ቲኖ ሺቅዳ› ጋእ ኡክ ኦህዳ፤ ይንፓ መለ ዪዝደ ባዝ ባያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","የዝን ፍልክሳ ላꬄ ኦገ ባዝ ሻኪ ኤርደ ግሾ «ታኒ ይን ኦህቶ ሻላቃ ሉስዮሳ ይእደ ዎደ ፍርዶዳ» ጋእ ቃጻሮ እንግ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ፍልክሳ ማህ ጳዉሎሳ አጭካየዛራ ናጎደ ጋራን ኤ እግኑንꬃፓ ኦደን ኤዛ ኦጮደስ የኦደራ ካያመ ፋና ማቶ Ꮉላቅዘስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ኤራꬅ ቃማፓ ሱባ፥ ፍልክሳ አይሁደ ማቅደ ፋ ማችት ድሩሲላራ ይእ ጳዉሎሳ ኪቲ ክእዚ ክርስቶስ የሱሳ አማኖ ባዝ ኤፓ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ጳዉሎሳ ጽሎትꬅባዝ፥ ፋ ኦማ አህዘባዝን ዮኦደስ የዘ ፍርዳባዝ ኦሆደራ፥ ፍልክሳ ዣሽቲ፥ «ነ Ꮉተስ ቅቶ፤ ታስ ዎትደ ዎደ ነና ጼግሳዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","የ ዎደ ጳዉሎሳፓ ጉቦ ኤኮደስ ቆፒ ኤዛ ማህ ማህ ጼግዝ ኤራ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ላምእ በረፓ ሱባ፥ ፍልክሳ በስተ ጶርቅዮስ ፍስጦሳ ሹሙንትዳ። ፍልክሳ አይሁዱንꬃና ኡፋይሶደስ ኮይ ጳዉሎሳ ብልካይዛራ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፍስጦሳ ፋ አዉራጃ ገሊ Ꮉይꬕ ቃማፓ ሱባ ቂሳርያፓ የሩሳላመ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","እዘ ካህኑንꬅ Ꮉላቁንꬅን አይሁዱንꬃና ካልꬅዙንꬅ ጳዉሎሳ ሞትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","«ጳዉሎሳ የሩሳላመ ክእዚ ኑስ ሎኦ ባዝ ኦቾያ» ጋእ ዎስዳ፤ ይኖ ኡን ጋይዳና ጳዉሎሳ ኦገ ናጊ ኤዛ ዎꬎደስ ኮይደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ፍስጦሳ ኡንታጎ፥ «ጳዉሎሳ፥ ቂሳርያ አች ኬꬃ የነ፤ ታኒ ታ ኦምተን ኤልሲ ሱባ ማቃደስ ይእነ። ");
INSERT INTO oyde_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ኤ ባልደባዝ የዝኮ ይን ሹሙንꬅ ታራ ቂሳርያ ዎꬊ ኤዛ ሞቶ» ያጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ፍስጦሳ ኡን ካለ ኦስፉን ዎይ ታጵ ቃማ ጋር ጋምእዳንፓ ሱባ ቂሳርያ ዎꬍዳ። ዎንትስት ዎደ ፍርዳ ኦይዳላ በቲ ጳዉሎሳ ኮኦደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ኤ ይእን የሩሳላመፓ ይእደ አይሁዱንꬅ ኤ ካለ ኤቂ ኡን ማርካ ሺሾደስ ዳንዳኦሰ ዳማ ምንꬅ ሞቶ ኤላ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳዉሎሳ ማህ፥ «ታኒ አይሁዱንꬅ ህገ ማቅን ጾዘ ኬꬃ ማቅን ዎይ ሮመ ካት ማቅን ቄሳረ ቆህካያ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","የዝን ፍስጦሳ አይሁዱንꬃና ኡፋይሶደስ ኮይ ጳዉሎሳጎ፥ «የሩሳላመ Ꮉንግ Ꮉና ሞትስ እዘ ታ ቲንተ ፍርድንቶደስ ኮያነ?» ያጋእ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","የዝን ጳዉሎሳ፥ «ታኒ ፍርድንቶደስ ቤዝዘ ቄሳረ ፍርዳ ኬꬃ ቲኖ ኤቅዳ። ኔኒ ሎይꬂ ኤርዛን ጋር ታ አይሁዱንꬃና አኮራን ቆህካያ። ");
INSERT INTO oyde_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ይኬ፥ ታኒ ቆህደባዝን Ꮉይቆስ የልꬅደባዝ ኦችደባዝ ማቅዛኮ Ꮉይቆፓ ታና አሾ ጋኦስ። የዝን ኡን ታና ሞትዘ ሞታ ጨር ማቅኮ ኦደን ታና ኡንትስ አꬂ እንጎደስ ዳንዳኦስ። ቄሳረ ታ ባዝ ፍርዶ ጋእ ኦጫነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","የ ዎደ ፍስጦሳ ፋ ዞርንትዙንꬃራ ዞርንት፥ «ኔኒ ቄሳረ ታ ባዝ ፍርዶ ጋእ ኦጭዳ፤ ቄሳረጎ ቅቶዳ» ጋእ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ኤራꬅ ቃማፓ ሱባ ካት አግርጳን ባርኒቀን ፍስጦሳ ሳርꬆደስ ቂሳርያ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","እዘ ኡን ጋማ ዎደ ጋምእን፥ ፍስጦሳ ካትዘስ ጳዉሎሳባዝ Ꮉንጋራ ያጋእ ቆንጭዝዳ፤ «ፍልክሳ ብልካይዛራ አሺ ቅትደ ፈቲ አꬄ Ꮉነ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ታኒ የሩሳላመ Ꮉንግደ ዎደ ካህኑንꬅ Ꮉላቁንꬅን አይሁደ ጭሙንꬅ ኤላ አፋ ፍርዶደ ጋር ታና ዎሲ ኤ ባዝ ታላ ሞትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ታኒ፥ ‹ሞትንትደ አꬄ ፋና ሞትዙንꬅ ቲኖ ኤቂ ፋ ሞትዳንስ ማሄ እንግካይዝን፥ ኦና ማቅኮን አꬊ እንግንትዛና ሮመ ዎጋ ባያ› ጋእ ኡንትስ ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","«ይኒ ግሾ፥ ኡን Ꮉነ ሺቅደ ዎደ ታኒ ጋምእካይዛራ ዎንትስት ዎደ ፍርዳ ኬꬃ ገሊ ጳዉሎሳ ኮኦደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ኤዛ ሞትዙንꬅ ኤ ካለ ዉቲ ኤቂ፥ ኢታባዛራ ኤዛ ሞትካይዛር አሻማ ጋእ ታኒ ቆፕዳን ጋር ኤዛ ሞትካያ። ");
INSERT INTO oyde_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","የዝን ኡን ፋ አማኖባዝን ጳዉሎሳ፥ ‹ፋጻ የነ› ጋዘ ፈቲ Ꮉይቂደ የሱሳ ጋእንትዘ አꬄባዝ ኤራ ላላነ። ");
INSERT INTO oyde_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ꮉና ኦህታ ታና ሻኮደስ ዴጽደ ግሾ ጳዉሎሳ የሩሳላመ Ꮉንግ፥ እዘ ፍርድንቶደስ ኮይዛኮ ጋእ ኤዛ ኦጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","የዝን ጳዉሎሳ ፋ ኦህቶ ቄሳረ በአደ ዎንꬅስ አች ኬꬃ ጋምኦደስ ኦጭዳ። ታኒ ኤዛ ቄሳረጎ ዳኮደ ዎንꬅስ ኤ አጭንቶደ ጋር ኪትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ይኒ ግሾ፥ አግርጳ ፍስጦሳጎ፥ «ታኒ ታ ኦምተን Ꮉይ አꬄ ጋዛኖ ስኦደስ ኮያነ» ጋይዳ። ፍስጦሳ ኤጎ፥ «ኔኒ ዎንታ ኤ ጋዛኖ ስኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ዎንትስት ዎደ አግርጳን ባርኒቀን ዳማ ቦንቾራ ሻላቁንꬃራ ካታማ የዘ አህዘ አሱንꬃራ ይእ ፍርዳ ኬꬃ ገልዳ። ፍስጦሳ ጳዉሎሳ ጼግዝ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ፍስጦሳ፥ «ካት አግርጳ፥ Ꮉነ ኑራ የዘ አሱንꬆ፥ አይሁዱንꬅ የሩሳላመን Ꮉነን ዉይሲ፥ ‹ኤ ይኬፓ ሱባ ፋጻ የሳደስ ቤዞስ› ያጋእ፥ ታና ዎስደ አꬃ Ꮉያ ይን በእነ። ");
INSERT INTO oyde_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","የዝን ኤዛ Ꮉይቆስ የልꬅዘባዝ አኮ ባዝን ታኒ ደንግካያ። ኤ ፋ ኦምተ፥ ‹ቄሳረ ታ ባዝ ፍርዶ ጋእ ኦጫነ› ጋይደ ግሾ ቄሳረጎ ኤዛ ዳኮደስ ቆፋ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ታኒ ኤ ባዝ ታ ላꬄ ቄሳረስ ጻፎደስ ማቅዘ ኤርንትደባዝ አኮን ባያ። ይኒ ግሾ፥ ኤ ባዝ ይን ብእኮ ታ ጻፎደባዝ በንቶድ የዛኮ ጋእ ይን ቲኖ አꬂ ካት፥ አግርጳ፥ ነ ቲኖ ኤዛ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","አኮስ ጋይኮ፥ አጭንትደ አꬃ አꬅዘ ዎደ ኤ አኮስ ሞትንተዛኮ ምክናቶ ኤርስዝካይዛራ አሽዛና ታስ ኤያትꬅ አዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","አግርጳ ጳዉሎሳጎ፥ «ኔኒ ነባዝ ኦሆደስ ዳንዳአነ» ጋይዳ። የ ዎደ ጳዉሎሳ ፋ ኩሽቶ ደንꬂ Ꮉንጋራ ጋይዳ፦ ");
INSERT INTO oyde_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«ካት፥ አግርጳ፥ አይሁዱንꬅ ታና ሞትደ ባዝስ ኡባ ማሄ እንጎደስ Ꮉይኖ ነ ቲኖ ኤቅተራ ታስ እጻ ሎኦ ጋእ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ይናን ኔኒ አይሁደ ዎጋን ላለን ሎይꬂ ኤራነ፤ ይኒ ግሾ ታና አዛልእካይዛራ ስአደ ጋር ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«ታኒ ናአትꬃፓ አይኪ ታ አሱንꬅ ግዳን የሩሳላመ የዝደ ታ የስቶ አይሁዱንꬅ ኡባ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ታኒ ቲኖፓ አይኪ፥ ኑ አማኖ ህግቶ ምንꬂ ናግዘ ፋርሳዉንꬅ ኮቻፓ ማቅዳኖ ኡን ማርክꬋደስ ኮይኮ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ꮉተን ታኒ ጾዚ ኑ አዱንꬅስ እንጎዳ ጋይደ ኡፋይስቶ ናግዘ ግሾ ሞትንቲ Ꮉነ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ማህ ታጶ ላምእ ኑ አዱንꬅ ኮችታ ጾዛ ቃማን አዋራን ምንꬂ ጎይንተር ጾዚ እንጎዳ ጋእዳኖ ኤኮደስ ኡፋይሳራ ናጊ የነ። ካት አግርጳ፥ አይሁዱንꬅ ታና ሞትዛና ታኒ ኡፋይሳራ ይኖ ናግዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ጾዚ Ꮉይቂዱንꬃና ደንꬅዛና አኮስ ይን ግዳ አማንንቶሰ ባዝ ማቅዶ? ");
INSERT INTO oyde_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«ዛጋ ታኒ ታ ኦምተን ናዝረተ የሱሳ ሱንꬅቶ እጾደስ ዳንዳእንትደ ባዝ ኡባ ኦቾደስ ቤዛነ ጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ታኒ የሩሳላመ ኦችዳና Ꮉኖ። ካህኑንꬅ Ꮉላቁንꬃፓ አደትꬅ ዎልቃ ኤኪ ጾዝ አሱንꬃፓ ጋሙንꬃና አጭዝዳ። ኡንታና ዎꬍዘ ዎደን ዎꬍዘ ቆፍተ ጊግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ጋማ ዎደ አይሁደ ዎሳ ኬꬃ ኡባ ኡን ሴርንቶደ ጋራን የሱሳ ጫዦደ ፋና ዎልቂስ ቆፕዳ። ታኒ ዎጋባዝ ኡንታና ካጪ መለ አቶ የዝን፥ ባለ ሳአ ካታማ የሎደስ ኡንታና ባይአነ። ");
INSERT INTO oyde_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«ታኒ Ꮉና ኦህትስ ካህኑንꬅ Ꮉላቁንꬃፓ አደትꬅ ዎልቃን ኪታ ኤኪ ዳማስቆ ቅታነ። ");
INSERT INTO oyde_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ካታዮ፥ ታኒ አዋራ ሳተ ኦገ የሳደራ አዋ ፎኦፓ ጋማ አꬍዘ ፎኦ ብእዳ፤ ይናን ታ ካንቶን ታራ የꬍዙንꬅ ካንቶ ዉቲ ሳሎፓ ፎእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ኑኒ ኡቡንꬅ ሳእተ ጎልኤዘ ዎደ እብራይስጠ ዶናራ፥ ‹ሳዉላ፥ ሳዉላ፥ ታና አኮስ ባይኤ? ኔኒ ነና ጫድዘ ብራትዛ እጽኮ ኔስ ዎዝ ኢቶዳ› ጋእ ታስ ኦሆደራ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«ታኒ፥ ‹ላꬆ፥ ነ ኦደ?› ጋይዳ። «ላꬂ፥ ‹ታኒ፥ ነ ባይእዘ የሱሳ፤ ");
INSERT INTO oyde_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","የዝን ደንዲ ኤቆ። Ꮉይኖ ኔኒ ታና ብእዳኖን ቲኖፓ ታ ነና ቤሳዳኖ መሉንꬅስ ማርክꬋደ ጋር ታ ታስ ኦችዛ ማህ ነና ሹሞደስ ኔስ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","እስራኤለ አሱንꬃፓን ታኒ ነና ኡንታጎ ኪትዘ አይሁደ ማቆሱንꬃፓ ነና አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ኔኒ ኡን ኣፍቶ ቡጎዳ፥ ꬉማፓ ፎኦጎ፥ ጻላሄ ኩሸፓ ጾዛጎ ኡንታና ማሆዳ። ኡን ታና አማኒ ናጋራ አቶትꬅ ኤኮዳ። ጾዚ አማኒ ጌዥደ አሱንꬅ ግዳ ፋ ላቶ ደማዳ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«ካት አግርጳ፥ ይኒ ግሾ፥ ታስ ሳሎፓ በንትደ ቆንጭꬅትስ ኪትንቶዳኖ እጽካያ። ");
INSERT INTO oyde_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","የዝን ታኒ ቲንꬊ ዳማስቆ ግዳ ይንፓ ሱባ የሩሳላመ ግዳ ይሁዳ ሳአ ኡባ የዙንꬅን አይሁደ ማቆሱንꬅ ፋ ናጋራፓ ጾዛጎ ማቃደ ጋራን ናጋራፓ ማቅዳኖ ቤዝዘ ኦቻ ኦቾደ ጋር ቃላ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ይኒ ግሾ፥ አይሁዱንꬅ ታና ጾዘ ኬꬃ አይኪ ዎꬎደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ꮉይኖ የሎደስ ጾዘ ማደ ታፓ ሻክንትካያ፤ ይኒ ግሾ፥ ኤራꬅስን ዳማስ ማርክꬍተራ Ꮉነ ኤቅዳ። ናቡንꬅን ሙሴን Ꮉኖዳ ጋእ ኦህዳንፓ መለ ፈትባዝን ታኒ ኦህደባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ይናን፥ ‹ክርስቶሳ ማꬋ ኤኮደስ ቤዛነ፤ ማህ Ꮉይቆፓ ቲኖ ደንድ አይሁዱንꬅስን አይሁደ ማቆሱንꬅስ ፎኦ አዋጃነ› ጋእ።» ");
INSERT INTO oyde_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ጳዉሎሳ ይኖ ጋእ ማሆደራ፥ ፍስጦሳ ፋ ቃልቶ ꬎቅ ዪዚ፥ «ጳዉሎሳ፥ ነ ዣሽትዳ፤ ነ ጋማ ታማርዳና ነና ዣሻስ የልꬅዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","የዝን ጳዉሎሳ፥ «ቦንቾ ፍስጦሳ፥ ታኒ ቱርባዝን ኮሽዘ ባዝን ኦህነፕ አትን ዣሽትካያ። ");
INSERT INTO oyde_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ታኒ ቆንጨ ኦህዘ ኦህቶ ካት ኤራነ። Ꮉና ኦህታ አችቻ ኦችንትካይዘ ግሾ ፈትን ኤፓ ገንጎሳኖ ታኒ ጌሽ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","«ካት አግርጳ፥ ኔኒ ናቡንꬅና አማናነ ባነ? ነ አማንዛኖ ታኒ ኤራነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ካት አግርጳ፥ ጳዉሎሳጎ፥ «Ꮉና ኤራꬅ ሳተ ታና ክርስታነ ማሆደስ ኮያነ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ጳዉሎሳ፥ «ጋማ ዎደ ማቅን ኤራꬅ ዎደ ነ ጻላላ ማቅካይዝን Ꮉይኖ ታና ስእዘ ኡቡንꬅ Ꮉና አችትፕ አትን ታ ፋና ማቃደ ፋና ጾዝ ዎሳነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ይንፓ ሱባ፥ ካት አግርጳ ጋደ አህዘ ፍስጦሳ፥ ባርኒቀን ኡንታራ በትደ ኡቡንꬅ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","እዝፓ ኬዚ ቅትተራ ፈተ ፈተራ፥ «Ꮉይ አꬄ Ꮉይቆስ ዎይ አችስ የልꬅዘባዝ አኮን ኦችካያ» ጋእ ዎላ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","አግርጳ ፍስጦሳጎ፥ «Ꮉይ አꬄ ‹ቄሳረ ታ ባዝ ፍርዶ› ጋይካይዛኮ ብልንቶደስ ዳንዳአነ፥ የዝን አትዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ኑኒ ማርካበራ ጣልያ ቅቶደ ፋና ኡን አጭደ ዎደ ካቱንꬅ ዋና ማቅደስ ዎታዳሩንꬃና ኦላስ ኪትዘ ፈተ ዩልዮሳ ጋዘ ማቶ Ꮉላቅዘስ ጳዉሎሳን መለ ኤራꬅ አቻ የዘ አሱንꬃና እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","እስያ ጋጻ የዘ ጉታ ቅትዘ አድራምጥዮነ ማርካበ ግዳ ገሊ ደንድዳ። መቀዶንያ አስ ማቅደ ተሰሎንቄ አርስጥሮኮሳ ኑራ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ዎንትስት ዎደ ኑኒ ስዶና የሎደራ፥ ዩልዮሳ ጳዉሎሳስ ሎይꬂ ፋ ላጉንꬃጎ Ꮉንግ ኮሽዘ ባዝ ማድንቶደ ጋር ኡንታጎ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","እዝፓ ደንዲ ቲኖራ ኑላ ባቂዘ ግሾ Ꮉꬃራ ተቅንትደ ሳአ፥ ቆጵሮሳራ ካተ ማህ ዬካ ዛላራ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ክልቅያን ጵንፍልያ ካለ የዘ አባ ፊንግ ሊቅያን የዘ ሙራ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","እዘ ማቶ Ꮉላቅዘ ጣልያ ቅትዘ እስክንድርያ ማርካበ ደንግ፥ እዘ ኑና ገልꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ኑኒ ጋማ ዎደ ለሚ የዺ፥ ጋማ ማꬋራ ቃንዶሳ ካታማ ካለ የልዳ። የይጋራ ቅቶደስ ኑና ጎተ ካይን ሳልሞናራ አꬊ Ꮉꬃራ ተቅንትደ ሳአ፥ ቃርጠሳራ ካቲ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ጋማ ማꬋራ ጋጻ ጋጻ አይኪ ላስያ ካታማ ካለ የዘ አባ ጋጽተ «ሎኦ ማርካበ ሸምፕዘ በሲ» ጋእንትዘ በስተ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ኑኒ እዘ ጋማ ዎደ ጋምእዳንፓ ሱባ ጾማ ብልንትን፥ ማርካበራ የꬍዛና ዋይꬅዘ ግሾ ጳዉሎሳ ኡንታና ዞርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«አሱንꬆ፥ ኑ Ꮉንግዘ ኦግተ ዳማ ቆሄን ዳማ ꬋበ የዛና ታስ በንታነ፤ ቆህታ ጫናላን ማርካበላ ጻላላ ማቅካይዝን ኑ ኦምትላን የሎዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","የዝን ማቶ Ꮉላቅዘ ጳዉሎሳ ጋይዳንፓ አꬊ ማርካበ እዥዛይን ማርካብት አዳይን ጋዛኖ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ይና አባ ጋጻ የዘ ካታማ ባልጎ አግና ኣꬆደስ ኡንትስ ጊጎሰ ግሾ ጋማ አሱንꬅ ፋስ ዳንዳእንትኮ ፍንቀ ካታማ የሊ ስላ አግና የይጋ ኣꬆደስ ዞርንትዳ። ፍንቀ ዎካ አዋ ገሎፓን ዬካ አዋ ገሎፓን ግዳ አባ ጋጻ የዘ ማርካበ ጫና ኬꬅዘ በሲ ስላ አግና እዘ ኣꬆደስ ቆፋ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ኤራꬅ ዬካ ባቆ ባቂደ ዎደ ኡን ቆፕዳንጋራ Ꮉንደ ፋና ይእን ደንዲ፥ ማርካብዘ ኤንአመ ጋር አይክዘ መቅዛ ኡደ ኤኪ ቃርጠሰ ካለራ አꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","የዝን ጋማ ጋምእካይዝን «አዉራቂስ» ጋዘ ዳማ ጎተ Ꮉꬃራ ተቅንትደ ሳእትፓ ሱለ ኡንታላ አፋ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","የ ጎትዘ ማርካብዛ ኡርቂ Ꮉንጋመ ፋና ካይደ ግሾ ባቅዘ ማርካብዛ ፋ ኮይደ በሳ ካንጎደ ፋና ዳኪ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ኑኒ ቄዳ ጋዘ Ꮉꬃራ ተቅንትደ ሳአ ካቲ Ꮉንግተራ ጋማ ዋየራ ማርካብዘ ጎንግዛ አሾደስ ዳንዳእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ኡን ጎንግዛ ኡደ ከስዳንፓ ሱባ ጋደራ ማርካብዘላ ጻጺ፥ ምንꬂ አጭዳ። ሱርቲሳ ጋዘ ሻፍተ ፋና ጎልእዛመ ጋር ይርጊ፥ ማርካብዘ ሻርቶ ኬꬂ ማርካብዛ Ꮉሪ እዥዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ጎትዘ ሚንግ Ꮉንጎደራ ዎንትስት ዎደ ጫንትፓ ባግቶ አባ ኦለ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ꮉይꬓንꬆ ቃማ ማርካብዘ ሚሽቶ ኤኪ ፋ ኩሽትራ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ኑኒ ጋማ ዎደ አዋ ኣፈን ጾልንቶን ብእካይዘ ግሾን ዳማ ጎተ ኑላ ባቂደ ግሾ ቲኖፓ ሸምፖራ አቶዳ ጋእ ቆፕካያ። ");
INSERT INTO oyde_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","የ ዎደ ኡን ጋማ ዎደ ካꬃ ሚካይዛራ ጋምእደ ግሾ ጳዉሎሳ ኡን ግዳ ደንዲ ኤቂ፥ «አሱንꬆ፥ ይን ታ ዞርቶ ኤኪ ቃርጠሳፓ ደንድካይዛራ አተዛኮ Ꮉና ቆህታን ꬋብታን ኑና የላማ የሻ። ");
INSERT INTO oyde_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","የዝን ታኒ ይንታና ዣሽትፐተ ጋእ ዞራነ፤ አኮስ ጋይኮ፥ Ꮉይ ማርካብዘ ꬋቦዳፕ አትን ይንታፓ ፈቲ አስ ሸምፖን ꬋቦስ። ");
INSERT INTO oyde_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ꮉይኖ ቃማ ታ ኤ ባዝ ማቅዳይን ታ ጎይንዘ ጾዘ ኪትደ ኪታንቾ ታ ካለ ኤቂ፥ ");
INSERT INTO oyde_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹ጳዉሎሳ፥ ዣሽትፐ፤ ኔኒ ሮመ ካት ቄሳረ ቲኖ ኤቆደስ ቤዛነ። ይኬ ጾዚ ነ ግሾ ኔራ Ꮉንግዘ አሱንꬅ ኡቡንꬅ ሸምፕቶ አሽዳ› ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ይኒ ግሾ፥ አሱንꬆ፥ ዣሽትፐተ። የ ኪታንችዘ ታስ ኦህዳና Ꮉኖዳኖ ታ ጾዛ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","የዝን ባቅዘ ኑና ካንግ ፈቲ Ꮉꬃራ ተቅንትደ ሳአ ጋጻ ኦሎዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ታጶ ኦይድንꬃ ቃማ አድርያ አባ ግዳ ኑና ባቅታ ጎደን Ꮉንካን ኡርቆደራ፥ ቃማ ግዲ ብላሄ ማቅዘ ዎደ ማርካብተ ኦችዙንꬅስ ሳአጎ ኡክደ ጋር አዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ኡን ጌናትꬅቶ ኤሮደስ ኮይ ጋደ በርꬃ ዴጾባዝ አጪ አባ ኦልን፥ አባ ገንታ ኦስፉን ታም Ꮉꬋ ማቅዳ። ኤራꬅ ጋምእ፥ ማህ ኦልን እዝፑን ታም Ꮉꬋ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ኡን አባ ጋጻ የዘ ሹቻላ ዶምእንታመ ጋር ዣሽቲ፥ ማርካብዘ ቅታመ ጋር አይክዘ ኦይዲ መቆ ማርካብዘፓ ሱባራ አባ ዳኪ፥ ሳእታ ዎንቶደ ጋር ጾዝ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ማርካብተ ኦችዙንꬅ ማርካብዘፓ ꬋቦደስ ኮይ፥ ማርካብዘ ቅታመ ጋር አይክዘ መቅቶ ማርካብዘፓ ቲኖ ዛላራ አባ ኦልዘ ጋር አዝዝ ጎንግዛ አባ ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ጳዉሎሳ ማቶ Ꮉላቅዘጎን ዎታዳሩንꬃጎ፥ «Ꮉንስ ማርካብተ ሸምፒ በታንጽኮ ይን አቶደስ ዳንዳኦስ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ይኒ ግሾ፥ ዎታዳሩንꬅ ጎንግዘ አጭንትደ ጋድዛ ጋቺ ዳኪ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ሳአ ዎንቶደስ ይአደራ ኡቡንꬅ ካꬃ ማአደ ጋር ጳዉሎሳ አሱንꬃጎ፥ «ይን ካꬃ ሙእካይዛራ ጋምእደ Ꮉይኖራ ታጶ ኦይዲ ቃማ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ይኒ ግሾ፥ ኤራꬅ ካꬃ ይን ማአደ ጋር ታኒ ይንታና ዎሳነ። ይን ምንጎደ ጋራን ሸምፖራ የሳደ ጋር ኤራꬅ ካꬃ ማአደስ ኮሻነ፤ መለ አቶ የዝን ይን ኦማ እስንꬅትፕ ፈትን ꬋቦስ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ጳዉሎሳ ይኖ ጋእ ቦራ ኤኪ ኡቡንꬅ ቲኖ ጾዝ ጋላትዳ፤ ቦርዛ ባጽ መኤ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ኡቡንꬅ ሚንግ ፋ ፋስ ካꬃ ኤኪ ሙእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ኑኒ ማርካብተ የዙንꬅ ላምእ ጼት ላፑን ታም እዝፑን። ");
INSERT INTO oyde_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ኡን ሙእ ምዥደ ዎደ ጫና ዛርግቶ አባ ኦልን ማርካብዘ ዴጽቶ ፎልዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ሳአ ዎንትደ ዎደ ማርካበ ኦችዙንꬅ አባ ሳአ የለዛኮ ኤርካይዛራ፥ አባ ጋጻ የዘ ሻፈ ስልሞ ብእዳ። ፋስ ዳንዳእንትኮ ማርካብዛ ይና ሻፍትጎ ሺሾደስ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","የይዝ፥ ማርካብዘ ቅታመ ጋር አይክዘ መቅቶ ብሊ አባ ኦልዳ። የ ዎደ እዥዘ ምንጻ አጭዘ ጋድዛ ብልዳ። ይንፓ ሱባ፥ ባቅታ ማርካብዛ ቲኖ ኡርቆደ ጋር ማርካብዛ ካንግዘ ሻራ ቲኖ ዛላራ ꬎቅ ዪዚ የ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","የዝን ማርካብዘ ሻፈ ናድንትደላ ዶምእንቲ ቆꬍንትዳ። ማርካብዘስ ቲኖ ዛልታ ጾስንቲ ሻፍቶ ጫዲ አይኪ ኤንአንጽ እጽን፥ ሱባ ዛልቶ ጎተ ኡርቅዛንፓ ደንዲ መቀ አይክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ዎታዳሩንꬅ አች አሱንꬃፓ ፈትን Ꮉꬅተ Ꮉꬊ ኬዚ ꬋባመ ጋር ኡንታና ዎꬎደስ ዞርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","የዝን ማቶ Ꮉላቅዘ ጳዉሎሳ አሾደስ ኮይ ዎታዳሩንꬃራ ዞርንቶ እጽዳ። Ꮉꬅ Ꮉꬊ ኤርዘ ኡባ ማርካብዘፓ Ꮉꬅተ ዶሊ ዶሊ ዎꬊ ቲንꬊ ጋጻ ኬሳደ ጋር ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","አትዱንꬅ ሳንቂትላን፥ ማርካብዘ መቅꬅትላ አፋ ኬሳደ ጋር ኪትዳ። ይኒ ጋራ ይእ ኡቡንꬅ ጋጻ ሳሮራ ከዝዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ኑኒ ጋጻ ሳሮራ ከዝደ ዎደ የልዳና Ꮉꬃራ ተቅንትደ ሳእታ ማልታ ጋእንትዛኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ማልታ አሱንꬅ ኑስ ጋማ ሎእዳ። እራ ቡክደ ግሾን ጪሽዘ ግሾ ታማ ኤꬂ ኑና ኡባ ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ጳዉሎሳ ጋማ Ꮉይጸ ሺሺ ታማ ጋዶደራ፥ ጎፕ ሾሽ ምችት ግሾ ኬዚ ኤ ኩሽትላ ጻጽንት ኤዛ ꬋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ማልታ አሱንꬅ ሾሽ ጳዉሎሳ ኩሽትላ ጻጽንትዳኖ ብእደ ዎደ ፈታይ ፈተጎ፥ «ቱሮ Ꮉይ አꬄ ሸምፖ ዎꬍደ አስ፤ መለ አቶ የዝን አባፓ ኤ አትንን ጾዘ ፍርዳፓ አቲ ፋጻ የሳደስ ዳንዳእካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","የዝን ጳዉሎሳ ፋ ኩሽትፓ ሾስዛ ዉጹርክ፥ ታማ ኦልዳ፤ ኤዛ አኮን ቆህካያ። ");
INSERT INTO oyde_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ኡን፥ «ኤ ጋልታ ክጻነ፥ ዎይ ቲርካይዝን ጎልእ Ꮉይቃነ» ጋእ ናጋነ። የዝን ጋማ ዎደ ናጊ ኤ ጋልተ አኮን ዱሙዽደ ባዝ ꬋብን፥ «Ꮉይ ኤቃ» ጋእ ፋ ቆፍቶ ላምዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ይና ካራ ጋንጭተ Ꮉꬃራ ተቅንትደ ሳአ Ꮉላቅዘ፥ ፑፕልዮሳ ጋዘስ ጋደ የነ፤ Ꮉይꬕ ቃማ የሎደስ ኤ ኑና ሲቆራ ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ፑፕልዮሳ አዳይ ኦማ ኦꬂ፥ ምቻራን ጋንጨ Ꮉርገራ ዎይእ የነ። ጳዉሎሳ ኤ ካራ ገሊ ኤስ ጾዝ ዎስዳ፤ ፋ ኩሽቶ ኤላ ጋዲ ፋꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ይንፓ ሱባ፥ ማልታን የዘ Ꮉርግንትዘ መለ አሱንꬅን ይእ ፋጽዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ኡን ኑና ጋማ ቦንችዳ፤ ኑኒ ማርካበራ ቅቶደስ ደንድደ ዎደ ኦገስ ኮሽዘ ባዝ ኑስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ꮉይꬕ አግናፓ ሱባ፥ ማልታ ግዳ ሴተ አꬂ እስክንድርያ ማርካበራ Ꮉማደስ ደንድዳ። የ ማርካብዘላ ድዮስቆሮሳ ጋዘ መንተ ኤቁንꬅ ምስለ የነ። ");
INSERT INTO oyde_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ስራኩሰ ካታማ ገሊ እዘ Ꮉይꬕ ቃማ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","እዝፓ ደንዲ ረግዩመ ካታማ የልዳ። ፈቲ ቃማፓ ሱባ፥ ዬካ ዛላራ ባቆ ባቂን፥ ዎንትስት ዎደ ፉትዩሎሳ ካታማ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","እዘ ኑ ፈቲ ፈቲ አማንዘ አሱንꬃና ደንግን፥ ፋራ ሳምንታ ጋምኦደ ጋር ኑና ዎስዳ። ይንፓ ሱባ፥ ሮመ ኑ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ሮመ የዘ አማንዘ አሱንꬅ ኑ ባዝ ስእ፥ አፍዮሳ ጋበ፥ Ꮉይꬕ አቅዘ በሲ ጋእንትዘ በስቶ የሎደስ ኑና ሞኮደስ ይእዳ። ጳዉሎሳ ኡንታና ብእደ ዎደ ጾዝ ጋላቲ ምንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ኑ ሮመ ገልደ ዎደ ጳዉሎሳ ናግዘ ዎታዳረ እንግንትን ፋስ የዞ ጋእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ꮉይꬕ ቃማፓ ሱባ፥ ጳዉሎሳ አይሁዱንꬅ Ꮉላቁንꬃና ፋጎ ጼግዝዳ። ኡን ሺቅደ ዎደ ኡንታጎ፥ «ታ እሹንꬆ፥ ታኒ ኑ አሱንꬃና ዎይ ኑ አዱንꬅ ዎጋላ አኮ ቆህዘ ባዝን ኦችካያ፥ የዝን ታና የሩሳላመ አጪ ሮመ አሱንꬅስ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ኡን ታ ሞቶ ብእ Ꮉይቆስ የልꬅዘባዝ ታላ አኮ ባዝን ደንግካይዘ ግሾ ታና ብሎደስ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","የዝን አይሁዱንꬅ ይኖ እጽደ ዎደ ኡንእንት ‹ታ ባዝ ቄሳረ ፍርዶ› ጋይዳፕ አትን ታኒ ታ ዎርዥቶ ሞትዘባዝ የዝን ባያ። ");
INSERT INTO oyde_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ታ ይንታና ጼግዝዳና ይንታና በአደስን ይንትስ Ꮉኖ ኦሆደስ። ታ Ꮉና ሳንꬃላታር አጭንትዳና እስራኤለ አሱንꬅ ናግዘ ኡፋይስት ግሾ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","አይሁደ Ꮉላቁንꬅ ጳዉሎሳጎ፥ «ኑስ ይሁዳፓ ነባዝ ዳብዳበ የልካያ። እዝፓ የኤዘ አሱንꬃፓ ፈትን ነባዝ ኢታ ኦህዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","የዝን Ꮉና ነ ካልዘ አማንቶ መለ መለ በስተ አሱንꬅ እጽዛኖ ኑኒ ኤርዘ ግሾ ነ ቆፍቶ ስኦደስ ኮያነ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ኡን ፋ የኦደ ቃምቶ ጳዉሎሳስ ቃጻሪ፥ ይና ቃምተ ጋንግ ኤ የዘ በስተ ይእዳ። ኤ ዎንታፓ ኡጉረ የሎደስ ጾዘ ካእቱሞ ባዝ ኡንትስ ማርክꬍዳ። ማህ ኡን የሱሳ ባዝ አማኖደ ጋር ሙሴ ህገፋን ናቡንꬅ ማጻፈፓ ጌሽ ኡንታና ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ፈተ ፈተ ጳዉሎሳ ጋይዳኖ አማንዳ፥ የዝን መሉንꬅ አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ኡን ዎል ግዳ ኦህቶ ኤካንጽደ ዎደ ጳዉሎሳ ፈትባዝ ጋይዳንፓ ሱባ ቅትዳ። ኤ Ꮉንጋራ ጋይዳ፦ «ጌሽ አያና ይን አዱንꬅስ ናበ ኢሳያሳ ዶንተ ኦህዳና ቱሮ። ");
INSERT INTO oyde_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«ኔኒ የንꬅ አሱንꬃጎ Ꮉንግ፥ ይን ስስ ስእነ፥ የዝን ይን ቆፖስ፤ ይን በኤ በእነ፥ የዝን ደንጎስ። ");
INSERT INTO oyde_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ꮉንꬅ አሱንꬅ ዎዝንታ ሙምዳ፤ ኡን Ꮉይታ ቱልዳ፤ ኡን አፍታን ጎዝንትዳ። ይና ባይዛኮ፥ ኡን ፋ ኣፍተ ብእ፥ ፋ Ꮉይተ ስእ፥ ፋ ዎዝንተ ቲሪ፥ ኡን ታጎ ማቅኮ፤ ታንን ኡንታና ፋꬆድ የሻ ጋኦ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«ይኬ፥ Ꮉና ጾዘ አሽዘ ኪታ አይሁደ ማቆሱንꬅስ ማቅዳኖ ኤራነ። ኡንትን ስኦዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ጳዉሎሳ ይኖ ጋእዳንፓ ሱባ አይሁዱንꬅ ፋ ግዳ ጋማ ላልተ ኬዚ ቅትዳ ። ");
INSERT INTO oyde_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳዉሎሳ ክራ ኬꬃ ላምእ በረ ኩሙꬅ የዝዳ፤ እዘ የዝተራ ፋጎ ይእዛ ኡባ ሞካነ። ");
INSERT INTO oyde_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ዣሽሞ ባይꬅ ኦደን ካይካይዝን ጾዘ ካእቱሞ ሳባክዳ፤ ላꬄ የሱስ ክርስቶሳ ባዝ ቆንጭዝ ታማርስዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","የሱስ ክርስቶሳ አሮ ማቅደ፥ ሐዋረ ማቃደ ጋራ ጼግንትደፓን ጾዘ ዎንገለ ሳባኮደ ጋራ ዶርንትደ ጳዉሎሳ ኪትደ ኪታ። ");
INSERT INTO oyde_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ጾዚ ጋማ ዎደፓ ቲኖ ፋ ናቡንꬅ ባጋራ እንጎዳ ያጋይደ ጾዘ ጌሽ ማጻፍተ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ꮉይ ዎንገልዘ አሾራ ዳዉተ ኮቻፓ የልንትደ፥ ጾዘ ናአ፥ ኑ ላꬄ የሱስ ክርስቶሳስ። ");
INSERT INTO oyde_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ማህ ኤ ፋ ጌሽ አያናራ Ꮉይቆፓ ደንዲ፥ ጾዘ ናአ ማቅዳኖ ዳማ ዎልቃራ ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ኤ ባጋራ አይሁደ ማቆሰ አሱንꬅ ኡባ፥ አማኒ ኪትንቶደ ጋር ክርስቶሳ ሱንꬅት ግሾ ጾዘ አꬎ ኬሃትꬅን ሐዋረትꬅ አደትꬅ ዎልቃ ኑ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","የሱሳ ክርስቶሳስ ማቃደ ፋና ጼግንትደ አሱንꬃፓ ባጉንꬅ ይንታና። ");
INSERT INTO oyde_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ሮመ የዘ፥ ጾዚ ይቅስንትዙንꬃና ኤስ ጌሽ ዎርዣ ማቃደ ፋና ዶርዱንꬅስ። ጾዘ ኑ አደፓን ላꬄ የሱስ ክርስቶሳፓ አꬎ ኬሃትꬅን ሳሮትꬅ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ኡባፓ ቲኒ፥ ይን አማንታ ሳአ ኡባ ስንትደ ግሾ የሱስ ክርስቶሳ ባጋራ ይን ግሾ ታ ጾዛ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ታኒ ኤ ናአይ ዎንገለባዝ ኩሙꬅ ዎዝንተ ኦህዘ ጾዘ፥ ታኒ ታ ዎስተ ኡባ ዎደ ይንታና ቆፕዛንስ ኤ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ዉርሱꬅተ፥ ጾዘ ቆፋ ማቅኮ፥ ታኒ ይንታጎ Ꮉንጎደስ ኦገ ታስ ጊጎደ ፋና ኡባ ዎደ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ታኒ ይንትስ አያና አንጆ ሻኮደስን ይንታና በአደስ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ይናን፥ ታኒ ይን አማንተን፥ ማህ ይን ታ አማንተ ምንጎደ ፋናስ። ");
INSERT INTO oyde_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ታ እሹንꬆ፥ ታኒ አይሁደ ማቆሰ አሱንꬃፓ ኣፈ ደንግዳን ፋና፥ ይንታፓን ኣፈ ደንጎደስ ይንታጎ Ꮉንጎደስ ቆፕዳ፥ የዝን ካይንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ግርኬ አሱንꬅስን ግርኬ ማቆሰ አሱንꬅስ ማህ ጭንጩንስስን ቦዙንꬅስ ታስ ጋለ የነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ይኒ ግሾ፥ ሮመ የዘ ይንትስን ዎንገለ ኦሆደስ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ቲንꬊ አይሁዱንꬃና፥ ማህ አይሁደ ማቆሱንꬃናን አማንዘ ኡቡꬃና አሾደስ ዎንገለ ጾዘ ዎልቃ ማቅደ ግሾ ታ ዎንገለራ ዬልꬎኦስ። ");
INSERT INTO oyde_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ጽሎ አማኖራ ደኦ የሳዳ ጋእንት ጌሽ ማጻፍተ ጻፍንትዳ። ዎንገለ ጾዘ ጽሎትꬅቶ ቆንጭዝዳ፤ ቲኖፓ ዉርሱꬅ የሎደስ አስ ጽልꬍዘ አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ቱርታ ኤርንታመ ፋና ፋ ኢታ ኦቻራ ካምዘ አሱንꬃላ አፋ ናጋራ ኡባላ አፋ፥ ጾዘ Ꮉንቆ ሳሎፓ ዎꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ጾዚ ኡንትስ ቆንጭሳደስ ቤዘባዝ ቆንጭዝደ ግሾ ኡን ጾዘ ባዝ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","አላመ መꬍንትደፓ ደንꬂ፥ አስስ በንቶሰ ጾዘ Ꮉኖ፥ ይናን ኤ መዽና ዎልቃን ጾዘትꬅ ኤ መትꬅተ ቆንጪ የዘ ግሾ አሱንꬅ ፋ ኢታትꬅትስ ምክናተ ማቅዘ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ኡን ጾዛ ኤርተራ፥ ኤዛ ቦንችካያን ጋላትካያ። ኡን ቆፍታ ማዶሰ ባዝ ማቅዳ፤ ኡን ቆፖሰ ዎዝንታ ꬉምዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ኡን ፋና ጭንጩንꬃና ጋነ፥ የዝን ቦዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ኡን Ꮉይቆሰ ጾዛ ጎይኖዳኖ አሺ፥ Ꮉይቅዘ አስ መꬎን፥ ላንዳን፥ ጾꬅን ሳዛራ ጎቹንትዘ ባዝ አዝዝ መꬍደ ምስለ ጎይናነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ይኒ ግሾ፥ ኡን ፈታይ ፈታይራ ኢታ ባዝ ኦቺ፥ ፋ ጋልቶ ካዉሾደ ጋር ጾዚ ኡን ዎዝንቶ አሙꬍዘ ቱና ኦቻስ ኡንታና ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ይና Ꮉንዳና ኡን ጾዘ ቱርቶ ዎርዶ ላምደ ግሾን መꬍደ ጾዛ አሺ፥ መꬍንትደ ባዝ ጎይንደ ግሾ። ጾዚ መዽናስ ጋላትንትዳ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ይኒ ግሾ፥ ጾዚ ኡንታና ቱና አሞትꬅስ አꬂ እንግዳ። ኡን ማቹንꬅ ፋስ ቤዝዘ ꬊራꬃራ የልንትዛኖ አሺ፥ ቤዞሰ ባዝ Ꮉኒ ማቻ ማችራ የልንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ይኒ ጋር፥ ꬊራꬅ ፋስ ቤዝዘ ማችራ የልንትዛኖ አሺ፥ ꬊራꬅ ꬊራꬃራ የልንታነ። ꬊራꬁንꬂ ፈታይ ፈታይራ አሞትꬃራ ኤጽንቲ፥ ዬልዘ ባዝ ኦችዳ። ፋ ኦችደ ባላ ኦችትስ ቤዝዘ ፍርዳ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ኡን ጾዛ ኤርተራ፥ መለ አቶ የዝን ኤ ባዝ ቆፖደስ ኮያንጽ እጽደ ግሾ ቤዞሰ ባዝ ኦቾደ ጋር ጾዚ ኡንታና ማዶሰ ቆፋስ አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ኡን ቆሄራ፥ ኢታትꬃራ፥ ዥምባራራ፥ ገነራ፥ ቅናተራ፥ ሸምፖ ዎራ፥ ላለራ፥ ጭሞራን ኢታ አሞራ ኩምዳ። ኡን ዝግርዙንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","አስ ሱንꬅ ኢስዙንꬃና፥ ጾዝ እጽዙንꬃና፥ ጫዥዙንꬃና፥ ኡትርዙንꬃና፥ ጬቅዙንꬃና፥ ኢታ ባዝ ኦቾደስ ኮይዙንꬃና ፋ አዳይስን እንትስን ኪትንቶሱንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ቲሮሱንꬃና፥ ቃላ ላምዙንꬃና፥ ሲቆ ባይዙንꬃና፥ ይቅስሞ ባይዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ꮉንስ ፋና ኦችዙንꬅስ Ꮉይቆ ቤዛነ ጋዘ ጾዘ ህገ ኤርተራ፥ Ꮉኖ ኦቻነ። ኡን ፋ ፋስ ኦችዛኖ ጻላላ ማቅካይዝን ኦችዘ መሉንꬃናን ልከ ጋእ ናሻነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ይኒ ግሾ፥ ናተ መሉንꬃላ አፋ ፍርድዛዮ፥ ነ ምክናተ ማህዘ ባያ። ነ መሉንꬃላ አፋ ፍርድተራ፥ የ ነ ፍርድዘ አꬄ ጋር ኦችኮ፥ ነ፥ ኔላ አፋ ፍርዳነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ይኒ ፋና ኦቻ ኦችዙንꬃላ አፋ ጾዘ ጽሎ ፍርዳ ፍርድዛኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ናተ፥ ይኒ ጋር ኦቻ ኦችዙንꬃላ አፋ ፍርድዛዮ፥ ኡን ኦችዛን ጋር ኦችዛዮ፥ ነ ጾዝ ፍርዳፓ አቶደ ጋር አዛነ? ");
INSERT INTO oyde_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ዎይ ጾዘ ኬሃትꬅ፥ ገንጮን ዳንዳአ ዱረትꬅቶ ለቃነ? ጾዘ ኔስ ዳልጋ ማቅዳና ነና ናጋራፓ ማሆደስ ማቅዳኖ ኤሮሳነ? ");
INSERT INTO oyde_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","የዝን ይንትስ ሹች ዎዝናን ስኦሰ Ꮉየ የነ። ይኒ ግሾ፥ ጾዘ Ꮉንቆን ጽሎ ፍርዳ ቆንጭዘ ቃማ፥ ኔላ አፋ ፍርዳ ሺሻነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ጾዘ ፈታይስ ፈታይስ ኤ ኦችት ጋር እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ሎኦ ኦቻራ ሚንግ፥ ጋላታ፥ ቦንቾን ꬋቦሰ ደኦ ኮይዙንꬅስ ጾዘ መዽና ደኦ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","የዝን ፋና ሲቅዙንꬃና፥ ቱርቶ እጽዙንꬃና ኢታ ባዝ ኦቾደስ ኮይዙንꬃላ አፋ ጾዘ ካችን ቦሻ ዮኦዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ኢታ ባዝ ኦችዘ አሱንꬅ ኡባ፥ ቲኒ አይሁዱንꬃና፥ ካሊ ግርኩንꬃና ማꬋን ዋየን የሎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","የዝን ጾዘ ሎኦ ኦቻ ኦችዘ ኡቡንꬅስ፥ ቲኒ አይሁዱንꬅ፥ ካሊ ግርኩንꬅስ ጋላታ፥ ቦንቾን ሳሮትꬅ እንግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ጾዚ ስኖ ብእ አስ ሻኮስ። ");
INSERT INTO oyde_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ህገ ባይዝን ናጋራ ኦችደ ኡቡንꬅ ህገ ባይꬅ ꬋቦዳ። ህገ የዝን፥ ናጋራ ኦችደ ኡቡንꬅ ህገራ ፍርድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ጾዘ ቲንተ ጽልዙንꬅ ህገ ናግዙንꬃፕ አትን ህገ ስኤ ጻላላ ስእዙንꬃና ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ህገ ባይዘ አይሁደ ማቆሰ አሱንꬅ መꬎ ህገ ኪትዛኖ ኦቻነ። ኡንትስ ጻፍንትደ ህገ ባይዝንን ኡን ፋ ዎዝንተ ህገ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ኡን Ꮉኖትꬅታ፥ ህገ ኪታ ኡን ዎዝንተ ጻፍንትዳኖ ቤዛነ። ማህ ኡን ዎዝንታ ኡንታላ አፋ ማርክꬋነ። ኡን ዎዝንታ ፈቲ ፈቲ ቶሄ ኡንታና ባልዳ ጋነ፤ ፈቲ ፈቲ ቶሄ ኡንታና ቱሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ታ ታማርስደ ዎንገለ ፋና ጾዘ የሱስ ክርስቶሳ ባጋራ አስ ዎዝንተ አችንትደ ቆፍታ ፍርድዘ ዎደ ኤርንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","የዝን ነ ነና አይሁደ ጋነ፤ ህገላ ካታነ፤ ጾዛላ ጬቃነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ነ ኦቾደ ጋር ጾዚ ኮይዘ ባዝ አኮ የዛኮ ኤራነ። ህገ ታማርደ ግሾ ቱሮ ማቅዘ ባዝ ሻኪ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ነ ቆቁንꬃና ካልዛኖ፥ ማህ ꬉማ የዙንꬅስ ፎኦ ማቅዛኖ ሻኪ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ነ ህገፋ ደንግደ ኤራትꬅን ቱረትꬃራ ቦዙንꬃና ኤርስዛያን ዦጉንꬃና ታማርስዛያ ማቅዳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ዬዝን፥ ነ መሉንꬃና ታማርስዛይ ነ ነና አኮስ ታማርሶሶ? ነ፥ «ካይስትፐ» ጋእተራ፥ ነ ነ ኦምተ ካይስታነን? ");
INSERT INTO oyde_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ነ፥ «ኦላለ Ꮉንትፐተ» ጋእተራ፥ ነ ነ ኦምተ ኦላለ Ꮉንታነ? ነ ኤቃ እጽተራ፥ ኤቃ የዘ ኬꬅቶ ቦንቃነ? ");
INSERT INTO oyde_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ነ ጾዘ ዎግተ ጬቅንታነ፥ የዝን ህግትስ ኪትንታንጽ እጺ ጾዛ ዬልዛነ? ");
INSERT INTO oyde_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ጌሽ ማጻፍተ፥ «ይን ምክናተር ጾዘ ሱንꬅታ አይሁደ ማቆሰ አሱንꬃራ ጫዥንታነ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ነ ህገስ ኪትንትኮ፥ ነ ጋራዝንትስ ማደ የነ፥ የዝን ነ ህግትስ ኪትንታንጽ እጽኮ ነ ጋራዝንትዳና ጋራዝንትካይዘ ፋና ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","አይሁደ ማቆሰ አሱንꬅ ጋራዝንትካይዛራ፥ ህግትስ ኪትንትኮ፥ ጾዚ ኤዛ ጋራዝንትደ ፋና ፋይዶሶነ? ");
INSERT INTO oyde_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ይን፥ አይሁደ አሱንꬅ፥ ይንትስ ጻፍንትደ ህግቶን ጋራዝንቲ ዬዝተራ፥ ይን ህገስ ኪትንታንጽ እጽኮ፥ አይሁደ ማቆሰ አሱንꬅ ጋራዝንታንጽ እጽኮን ህገስ ኪትንቲ፥ ይንታላ አፋ ፍርዶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ይኬ፥ ሱንꬃራ አይሁደ ማቅደ ኡቡንꬅ ቱሪ አይሁደ ባያ። ማህ ባለ ጋላ ጋራዝዛና ቱሪ ጋራዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","የዝን ቱሪ አይሁደትꬅ ጋꬃ አይሁደ ማቅዛኖ። ቱሪ ጋራዝንተ ጾዘ አያናራ ኦጭንትዘ ዎዝና ጋራዝንተፕ አትን ጻፍንትደ ዎግተ ኦችንትዘ ጋላ ጋራዘ ባያ። የ አꬄ ጋላታ ጾዛፓ ኤካነፕ አትን አሳፓ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ዬዝን፥ አይሁደ ማቅዛና አኮ ማደ? ዎይ ጋራዝንተስ አኮ ማድዘ ባዝ የዘ? ");
INSERT INTO oyde_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ኡባፓ ቲኖ ጾዚ ፋ ቃላ Ꮉዳርቶ አይሁዱንꬅስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ዬዝን፥ ኡንታፓ ፈታይ ፈታያ ቃላ አማናንጺ እጽኮ፥ ኡን እጽዛና ጾዚ አማንንትደ ጾዝ ማቅዛኖ ካያነነ? ");
INSERT INTO oyde_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ካዮስ! አስ ኡባ ዎርዶ ማቅኮን ጾዚ ቱሮ ማቀ። ጌሽ ማጻፍተ፥ «ነ ቃልተ ነ ጽላነ፤ ነና ሞትዛያ ፍርዳራ ላꬃነ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ዬዝን፥ ኑ ናጋርታ ጾዘ ጽሎ ማቅዛኖ ቤዝዘ ባዝ ማቅኮን፥ ኑ ዋጋዉደ? ጾዚ ኑ ናጋርት ግሾ ኑላ አፋ ፍርድኮ፥ ልከ ባነ? ይኖ ታኒ አስ ቆፋ ፋና ጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ይኒ ፋና Ꮉንፐተ። ይኒ ጋር Ꮉንኮ፥ ጾዚ Ꮉና አላምትላ አፋ ዋይዝ ፍርዶደ? ");
INSERT INTO oyde_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","የዝን ታ ዎርዶትꬅታ ጾዘ ቱርቶ ቆንጭዝ፥ ኤ ቦንችቶ ጋንꬅ ቤዘባዝ ማቅኮ፥ ዬዝን፥ አኮስ ታላ ፋና ናጋራንቾ ፋና ፍርደ? ");
INSERT INTO oyde_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ፈቲ ፈቲ አሱንꬅ፥ «ሎኦ ዮኦደ ፋና ኢታ ኦቾዳ?» ያጋእ ታማርስዘ አስ ፋና ማህ ታና ሞታነ። ይኒ ግሾ ያጋዘ አሳላ አፋ የእዘ ጾዘ ፍርድታ ልከ። ");
INSERT INTO oyde_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ዬዝን፥ ኑ ዋጋዉደ? ኑ አይሁዱንꬅ፥ ግርኬፓ አꬋነነ? አደ! አይሁደ ማቅን፥ አይሁደ ማቃንጽን ኡቡንꬅ ናጋራንቾ ማቅዛኖ ታኒ ቲኒ ይንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ጌሽ ማጻፍተ፥ «ጽሎ አስ ፈቶን ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","አካክዘ አስ ባያ፥ ጾዛ ኮይዘ ኦንን ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","አስ ኡባ ባልንትዳ፤ ኡቡንꬅ ፈትፓ ማዶሰ ባዝ ማቅዳ። ሎኦ ኦችዘ ኦንን ባያ፤ ፈቲ አስን ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ኡን ዶንታ፥ ቡጉንትደ ቦዛ ፋና፤ ፋ እልአንꬅተ ዎርድꬋነ። ኡን ዶንትፓ አስ ዎꬍዘ፥ ሾሽ ማርዘ ከዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ኡን ዶንተ ጫሞን ባድꬅ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ኡን ቶህታ ሱꬅ ላሎደስ ኤልሳነ። ");
INSERT INTO oyde_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ኡን ኦግተ ꬋበን ቆሄ የነ። ");
INSERT INTO oyde_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ኡን ሳሮ ኦገ ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ፋ ደእተ ጾዝስ ዣሽቶስ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","አስ ኡባ ዶና ጎርድንቶደ ፋና ኩሙꬅ አላምቶ ጾዘ ፍርዳፓ ኦሞራ ሺሾደስ፥ ህገ እንግንትደ ህገፓ ኦሞራ የዙንꬅስ ማቅዳኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ይኒ ግሾ፥ ኦደን ህገስ ኪትንቲ ጾዘ ቲኖ ጽሎደስ ዳንዳኦስ። ህገ አስ ኡባ ናጋራንቾ ማቅዛኖ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","የዝን Ꮉተ ጾዚ አስ ጽልዘ ኦገ ህገ ባይꬅ ቆንጭዝዳ። ይና ኦግቶ ሙሴ ህገን ናቡንꬅን ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ይና አማንዘ ኡባስ Ꮉንዳ፥ ጾዚ የሱስ ክርስቶሳ ባጋራ አስ ኡባስ ሻኮ ባይꬅ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","አስ ኡባ ናጋራ ኦችዳ፤ ጾዘ ቦንቾ ፋጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","የዝን ኡን ጾዘ አꬎ ኬሃትꬃራ፥ አሽዘ ክርስቶሳ የሱሳ ባጋራ ጨር ጽልዳ። ");
INSERT INTO oyde_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ጾዚ የሱስ ክርስቶሳ ዣርሾ ማህ እንግዳ፥ ኤዛ አማንዘ ኡባ ኤ ሱꬅተ ናጋራ አቶትꬅ ደንጎደ ፋና። ጾዚ ይኖ ኦችደ ፋ ዳንዳአራ ዛጋ ናጋርቶ ፋይድካይዛራ አሺ፥ ፋ ጽሎትꬅቶ ቤሳደስ። ");
INSERT INTO oyde_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","የሱሳ አማንዘ ኡባ ጽሎደ ፋና Ꮉተ ዎደ ጾዘ ፋ ኦምተ ጽሎ ማቅዛኖ ቤሳደስ። ");
INSERT INTO oyde_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ዬዝን፥ ኑ ጬቅንትዘ ባዝ አኮ የዘ? አኮን ባያ። ኑኒ ጬቅንትዛና ህገስ ኪትንትዘ ግሾነ? አደ! አማኖ ህገራ። ");
INSERT INTO oyde_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ጾዚ አስ ጽልዘ አማኖራፕ አትን ህገስ ኪትንተራ ባይዛኖ ኑ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ዎይ ጾዚ አይሁዱንꬅ ጻላላ ጾዞነ? አይሁደ ማቆሱንꬅስን ጾዚ ባነ? ቱሮ፥ አይሁደ ማቆሱንꬅስን ኤ ጾዚ። ");
INSERT INTO oyde_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ጾዚ ፈቶ፤ አይሁዱንꬃናን አይሁደ ማቆሱንꬃና አማኖራ ጽልዘ ኤዛ። ");
INSERT INTO oyde_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ዬዝን፥ ኑኒ ህገ አማኖ ግሾ ꬋብሶዳነ? አደ! ህግቶ ምንꬃነፕ አትን። ");
INSERT INTO oyde_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ዬዝን፥ ኑ አዳይ አብራሃማ አኮ ደንግዶ? ");
INSERT INTO oyde_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","አብራሃማ ኦቻራ ጽልደባዝ ማቅኮ፥ ኤ ጬቅንትዘ ባዝ የነ፥ የዝን፥ ጾዘ ቲኖ ጬቅንቶደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ጌሽ ማጻፍተ፥ «አብራሃማ ጾዝ አማንዳ፤ ጾዚ ይኖ ኤስ ጽሎትꬅ ማህ ፋይድዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ኦችዘ አꬄስ ኤክዘ ዳሞዝታ፥ ኤ ኦቻ ዎልቂትስ ጭግንትዘ ጋለፕ አትን ኤስ እሞ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","የዝን ኦቻ ኦቾሰ ኦንን ናጋራንቾ ጽልዘ ጾዛ አማንኮ፥ ኤ አማንታ ኤስ ጽሎትꬅ ማቂ ፋይድንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ጌሽ ማጻፍተ ዳዉተ፥ ኦቻ ባይꬅ ጾዚ ጽልዘ አሱንꬅ አኮ ጋር አንጅንተዛኮ Ꮉኒ ጋር ያጋእ ቆንጭዝዳ፦ ");
INSERT INTO oyde_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«ኡን ባልታ አቶ ጋእንትዱንꬅ ኡን ናጋርታ ካምንትዱንꬅ አንጅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ላꬂ ኤ ናጋርቶ ፋይዶሰ አꬄ አንጅንትዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ዬዝን፥ ዳዉተ ኦህደ አንጅታ ጋራዝንትደ አሱንꬅስ ጻላላሶነ? ዎይ ጋራዝንትካይዘ አሱንꬅሶ? ኑኒ፥ «ጌሽ ማጻፍታ፥ ‹አብራሃማ ጾዝ አማንዳ፤ ጾዚ ይኖ ኤስ ጽሎትꬅ ማህ ፋይድዳ› ጋነ» ኑ ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ዬዝን፥ ይና አይደ Ꮉንዶ? አብራሃማ ጋራዝንትንነ? ዎይ ጋራዝንትካይዝን? ጋራዝንተፓ ቲኖ Ꮉንዳፕ አትን ሱባ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","አብራሃማ ጋራዝንቶዳንፓ ቲኖ ኤ አማንታ ኤስ ጽሎተꬅ ማቂ ፋይድንትዳኖ ኤርሶደስ፥ ኤ ጋራዝንታ ማላ ማቅዳ። ይኒ ግሾ፥ አብራሃማ ጋራዝንትካይዛራ አማንዙንꬅስን አማኖራ ጽልዙንꬅስ ኡባ አደ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ኤ ጋራዝንተዙንꬅስን አደ። አብራሃማ ኡንትስ አደ ማቅደ ኡን ጋራዝንትደ ግሾ ጻላላ ባይዝን ኤ ጋራዝንቶዳንፓ ቲኖ አማንደ አማንተ ኡን ካልደ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","አብራሃማስን ኤ ዛርትስ፥ «አላምቶ ታ ይንትስ እንጎዳ» ያጋይደ ኡፋይስታ፥ አብራሃማ አማኖራ ጽልደ ግሾስ ፋትን ህገ ናጊ ፎልደ ግሾ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ህገስ ኪትንትዱንꬅ ጾዘ ኡፋይስቶ ላትዙንꬃና ማቅኮ፥ አማኖ ማዶስ፤ ጾዘ ኡፋይስታን ጨር ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ህገ ጾዘ ካች ከእነ፥ የዝን ህገ ባይዘ በሳ ህገ አን አሸን ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ይኒ ግሾ፥ ጾዚ እንግደ ኡፋይስታ አማኖራ ኤክንታነ። Ꮉና ኡፋይስታ አብራሃማ ኮች ኡባስ ጾዘ አꬎ ኬሃትꬅ ባጋራ እንግንትዳኖ ቆንጭዛነ። ይናን ህገ ናግዙንꬅስ ጻላላስ ባይዝን አብራሃማ ፋና አማንደ ኡቡንꬅስ። አብራሃማ ኑ ኡቡንꬅስ አደ። ");
INSERT INTO oyde_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ጌሽ ማጻፍተ፥ «ታ ነና ጋማ ዎርዣስ አደ ማህዳ» ጋእንት አብራሃማ ግሾ ጻፍንትዳ። ይና ኡፋይስታ አብራሃማስ እንግንትደ Ꮉይቂዱንꬅስ ደኦ እንግዘን ባይዘ ባዝ የዝዘ ጾዘ ኤዛ ማቅዳኖ ኤ አማንደ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ጾዚ አብራሃማስ ነ ኮችታ ጋንጎዳ ጋይዳና፥ ኡፋይስ ጋዶደስ አኮን ዳንዳእንቶሰ ዎደ አብራሃማ ጾዝ አማንደ ግሾን ኡፋይስ ጋድደ ግሾ ጋማ ዎርዣስ አደ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","አብራሃማስ ጼት በረ ኩምደ ባዝ ማቅኮን፥ ፋ ጭንግደ አሽተን ሳራ ናአ የሎደስ ዳንዳኦሳኖ ኤርተራ ፋ አማንተ ላቢካያ። ");
INSERT INTO oyde_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ኤ ፋ አማንተ ሚንግ ጾዝስ ቦንቾ እንግዳፕ አትን ጾዚ እንግደ ኡፋይስቶ አማናንጺ፥ ሶእካያ። ");
INSERT INTO oyde_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","አብራሃማ፥ ጾዚ እንግደ ኡፋይስቶ ፎሎዳኖ ፋ ኩሙꬅ ዎዝንተ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ይኒ ግሾ፥ ጾዚ ኤ አማንቶ ጽሎትꬅ ማህ ፋይድዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","የዝን፥ «ፋይድንትዳ» ጋዘ ቃልዘ አብራሃማስ ጻላላ ጻፍንትካያ። ");
INSERT INTO oyde_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","የ ቃልዘ ኑ ላꬄ የሱሳ Ꮉይቆፓ ደንꬅደ ጾዛ አማንዘ ኑስን ኑ አማንታ ጽሎትꬅ ማቂ ፋይድንቶደ ጋር ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ጾዚ ኤዛ ኑ ናጋርት ግሾ Ꮉይቆስ አꬂ እንግዳ፤ ኤ ኑና ጽልሳደስ Ꮉይቆፓ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ይኬ፥ ኑ አማኖራ ጽልደ ግሾ ኑ ላꬄ የሱስ ክርስቶሳ ባጋራ ጾዛራ ኑስ ሳሮትꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ኑ ኤ ባጋራ Ꮉተ ኑ ኤቅደ አꬎ ኬሃትꬅተ አማኖራ ገልዳ። ይኒ ግሾ፥ ኑ ጾዘ ቦንቾ ኡፋይስተ ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ይኖ ጻላላ ባይዝን ማꬋ ዳንዳአ ክእዛኖ ኑ ኤርዘ ግሾ ኑ ማꬍተን ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ማህ ዳንዳአ ፋታና፥ ፋታናን ኡፋይስ እንግዛኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ኑስ እንግደ ጌሽ አያና ባጋራ ጾዚ ፋ ሲቅቶ ኑ ዎዝንተ ጉስደ ግሾ ይና ኡፋይስታ ኑና ዬልዞስ። ");
INSERT INTO oyde_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ኑ Ꮉጋ ላቢዱንꬃና ማቂ የዝን፥ ጾዘ ዎደ የልን፥ ክርስቶሳ ናጋራንቹንꬅ ግሾ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ጽሎ አስ ግሾ Ꮉይቆደ አስ ደንጎዳና ዳማ ማꬋ፥ የዝን ሎኦ አስ ግሾ Ꮉይቆደ አስ ኦደ ኤርዘ በንትካይዛራ አቶስ። ");
INSERT INTO oyde_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","የዝን ኑኒ Ꮉጋ ናጋራንቾ ማቂ የዝን፥ ክርስቶሳ ኑ ግሾ Ꮉይቂዳ። ይና ጾዚ ኑና አኮ ጋር ሲቅዛኮ ኤ ሲቅቶ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ይኬ፥ ኑኒ ክርስቶሳ ሱꬅተ ጽልደባዝ ማቅኮ፥ ኡባፓ አꬂ ኤ ባጋራ ጾዘ Ꮉንቆፓ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ኑኒ ጾዛራ ሞርከ፥ የዝን ኤ ናአይ Ꮉይቅተ ኤራ ጊግዳ። ይንፓ አꬂ፥ Ꮉተ ኑኒ ጾዛራ ጊግደፓ ሱባ ኤ ናአይ ደኦ ምክናተራ ኑኒ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ይኖ ጻላላ ባይዝን Ꮉተ ኑና ጾዛራ ጊግዝደ ኑ ላꬄ የሱስ ክርስቶሳ ባጋራ ኑ ጾዛላ ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","አዳማ ባጋራ ናጋራ Ꮉና አላምተ ገልዳ። ይና ናጋርት ባጋራ Ꮉይቆ ይእዳ። አስ ኡባ ናጋራ ኦችደ ግሾ Ꮉይቆ አስ ኮች ኡባ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ህገ እንግንቶዳንፓ ቲኖ አላመ ናጋራ የነ፥ የዝን ህገ ባይዘ ዎደ ናጋራ ናጋራ ማቂ ፋይድንቶስ። ");
INSERT INTO oyde_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","የዝን አዳማፓ ሙሴ የሎደስ Ꮉይቆ አስ ኡባ አህዳ። መለ አቶ የዝን፥ አዳማ ህገስ ኪትንታንጽደ ግሾ፥ አዳማ ፋና ናጋራ ኦችካይዙንꬃላ አፋ Ꮉይቆ ካእትዳ። አዳማ ዮኦደስ የዘ የሱሳስ አዝዘ። ");
INSERT INTO oyde_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","የዝን ጾዘ አꬎ ኬሃትꬅ አስ ናጋርት ፋና ባያ። ፈቲ አስ ናጋራ ባጋራ ጋማ አሱንꬅ Ꮉይቂዳ። የዝን የሱስ ክርስቶሳ ባጋራ ጾዘ አꬎ ኬሃትꬅ አስ ኡባስ ጋንꬅ እንግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","አዳማ ናጋራ ግዳን ጾዘ እሞ ግዳ ጋማ ዱማትꬅ የነ። ፈቲ አስ ናጋራ ባጋራ ጾዚ ኤላ አፋ ፍርድዳ። የዝን አስ ጋማ ናጋራ ኦችንን ጾዘ አꬎ ከሃትꬅታ ጽሎትꬅ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ፈቲ አስ ናጋራ ባጋራ Ꮉይቆ ካእትዳ። የዝን የሱስ ክርስቶሳ ባጋራ ጾዘ አꬎ ኬሃትꬅን ጽሎትꬅ እሞ ኤክዘ ኡቡንꬅ፥ ጋምዘ ደኦር የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ይኬ፥ ፈቲ አስ ናጋራ ኦችደ ባጋራ አስ ኡባላ ፍርዳ ይእዳን ፋና ፈቲ አስ ጽሎ ኦችደ ባጋራ፥ ጾዚ አስ ኡባ ጽልዚ ኡንትስ ደኦ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ፈቲ አስ ኪትንታንጽ እጽደ ባጋራ፥ ጋማ አሱንꬅ ናጋራንቾ ማቅዳን ፋና ፈቲ አስ ኪትንተር ጋማ አስ ጽሎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","አሱንꬅ ናጋራ ዎልቃ ኤሮደ ፋና ህገ ይእዳ፥ የዝን ናጋራ ዎልቃ ጋንግደ ዎደ ጾዘ አꬎ ኬሃትꬅ አꬊ ጋንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ናጋራ Ꮉይቆ ዎልቃራ ካእትዳን ፋና ጾዘ አꬎ ኬሃትꬅ ጽሎትꬅ ዎልቃራ ካእት፥ ኑ ላꬄ የሱስ ክርስቶሳ ባጋራ ኑና መዽና ደኦጎ ካልꬃነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ዬዝን፥ ኑ ዋጋዉደ? ጾዘ አꬎ ከሃትꬅታ ጋንጎደ ፋና ናጋራራ ሚንግ የሳነ? ");
INSERT INTO oyde_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","አቶ Ꮉኖስ፥ ኑኒ ናጋራስ Ꮉይቅደባዝ ማቅኮ፥ ዬዝን፥ ኑኒ ይኬፓ ዋይዝ ናጋራራ የሳደ? ");
INSERT INTO oyde_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ኑ ኡቡንꬅ ክርስቶሳ የሱሳራ ፈቶ ማቃደስ ጻማቅንትደ ዎደ ኤ Ꮉይቅተ ኤራ ዎላ ሞግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ኑ ጻማቅንትደ ዎደ ክርስቶሳራ Ꮉይቅዳነ ሞጉንትዳ። ክርስቶሳ ጾዘ አዳይ ቦንቾ ዎልቃራ Ꮉይቆፓ ደንድዳን ፋና ኑንን ክለ ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ኑ ኤ Ꮉይቅተ ኤራ ፈቶ ማቅኮ፥ ይኒ ጋራን፥ ኤ ደንድተ ኤራ ፈቶ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ኑ ይኬፓ ናጋራስ አሮ ማቃመ ፋናን ኑ ናጋራንቾ አሳትꬅት ዎልቅታ ꬋቦደ ፋና ኑ ጋልአ አሳትꬅቶ ክርስቶሳራ ሱጽዳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ፈቲ አስ Ꮉይቅደባዝ ማቅኮ፥ ኤ ናጋራ ዎልቃፓ ዋሎ ከዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ኑኒ ክርስቶሳራ Ꮉይቅኮ፥ ኤራ ደኦ የሳዳኖ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ክርስቶሳ Ꮉይቆፓ ደንድደ ግሾ ማህ ኤ Ꮉይቆሳኖን Ꮉይቆ ቲኖስን ኤዛ አሆሳኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ኤ Ꮉይቂደ ዎደ ናጋራስ ፈቲ ቶሄ ዉርሱꬅ የሎደስ Ꮉይቂዳ፥ የዝን Ꮉተ ደኦ ጾዝስ የነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ይኒ ፋናን፥ ይን ናጋራስ Ꮉይቂ፥ ላꬄ ክርስቶስ የሱሳ ባጋራ ጾዝስ ደኦ የዛኖ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ይኒ ግሾ፥ ይን፥ ይን አሳተꬅታ አሞስ ኪትንታመ ፋና Ꮉይቅዘ ይን አሳተꬅቶ ናጋራ አህፐ። ");
INSERT INTO oyde_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ማህ ይን አሳትꬅ ክፍልቶ ናጋራ ኦቾደስ ገነ ኦላ ሚሸ ማህ እንግፐተ። የዝን ይን Ꮉይቆፓ ደንዲ፥ ደኦ የዘ አስ ፋና ይን አሳተꬅቶ ጾዝስ እንጎተ። ማህ ይን ኩሙꬅ አሳተꬅቶ ጽሎ ኦላ ሚሸ ማህ ጾዝስ አꬂ እንጎተ። ");
INSERT INTO oyde_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ይን ጾዘ አꬎ ኬሃትꬅስ ኦሞራ የነፕ አትን ህገፓ ኦሞራ የዞሰ ግሾ ናጋራ ይንታና አሆደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ዬዝን፥ ኑ ዋጋዉደ? ህገፓ ኦሞራ ማቅካይዝን ጾዘ አꬎ ኬሃትꬃፓ ኦሞራ የዘ ግሾ ናጋራ ኦቾዳነ? ሙሎን Ꮉኖስ! ");
INSERT INTO oyde_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ይን ፈቲ አስስ ኪትንቶደስ ይንታና አሮ ማህ እንግኮ ይና ይን ኪትንትዘስ አሮ ማቅዛኖ ኤሮተ። ይኒ ጋራ፥ ይን ናጋራስ ኪትንትኮ፥ ይንትስ Ꮉይቆ ክእዘ ናጋራስ አሮ ማቃነ። ዎይ ይን ጾዝስ ኪትንትኮ ጽሎትꬅ ክእዘ ጾዝስ አሮ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ዛጋ ይን ናጋራስ አሮ፥ የዝን Ꮉተ ይን ኤክደ ቱሪ ትምርተስ ኩሙꬅ ዎዝናፓ ኪትንትደ ግሾ ጾዝስ ጋላታ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ይን ናጋራ አሮትꬅ አቻፓ ብልንቲ ጽሎትꬅ አሮ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ይን ይን ቆፍተ ላበዙንꬃና ማቅደ ግሾ ታኒ ኦደስን ገልዘ ኦገራ ኦህነ። ዛጋ ይን፥ ይን አሳተꬅቶ ቱናን ኢታ ባዝ ኦቾደስ አሮ ማህ እንግዳን ፋና Ꮉተ ይን አሳተꬅ ክፍልቶ ጌሽ ማቃደ ፋና ጽሎተꬅ አሮ ማህ እንጎተ። ");
INSERT INTO oyde_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ይን ናጋራስ አሮ የዘ ዎደ ጽሎትꬅስ አቆስ። ");
INSERT INTO oyde_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ይንታና Ꮉተ ዬልዘ ዛጋ ይን ኢታ ኦችትፓ አኮ ማደ ደንግዶተ? ይና ኦችትስ ዉርሱꬅታ Ꮉይቆ። ");
INSERT INTO oyde_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","የዝን ይን ናጋራ አሮትꬃፓ ብልንቲ፥ ጾዘ አሮ ማቅዳ። ይና ይንታና ጌሽ ማህ መዽና ደኦ ካልꬃነ። ");
INSERT INTO oyde_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ናጋራ ዳሞዘ Ꮉይቆ። የዝን ጾዘ፥ ኑ ላꬄ ክርስቶስ የሱሳ ባጋራ እንግዘ እሞትꬅታ መዽና ደኦ። ");
INSERT INTO oyde_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ታ እሹንꬆ፥ ታኒ ህገ ኤርዘ አሱንꬅስ ኦህነ። ህገ ፈቲ አስ ፋጻ የዘ ዎደ ኤዛ አህዛኖ ኤሮሶ? ");
INSERT INTO oyde_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","አዝዘስ፥ አዝኒ ገልደ ማችታ እ አዝንዘ ፋጻ የዘ ዎደ ህገራ ኤዛራ አጭንትዳ። የዝን እ አዝንዘ Ꮉይቅኮ ኤዛራ እዛ አጭንትደ ጫቅታ እዞ አሆስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ይኒ ግሾ፥ እዛ ፋ አዝንዘ ፋጻ የዝን፥ መለ ꬊራꬅ ገልኮ፥ እዛ ላምዳ ጋእንታነ። የዝን እ አዝንዘ Ꮉይቅኮ፥ ጫቆ እዞ አሆሰ ግሾ እዛ መለ አዝኒ ገልኮ፥ እዛ ኦላልዳኖ ጋእንቶስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ይኒ ግሾ፥ ታ እሹንꬆ፥ ይን ክርስቶሳ አሾ ባጋራ ህገ ዎልቃስ Ꮉይቂ፥ ጾዝስ ኣፈ አፎደስ Ꮉይቆፓ ደንድደ ክርስቶሳስ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ኑ አሾ አሞ ኑና አህን፥ ኑ የዘ ዎደ ህገ ጉጂ ናጋራ ኦቾደ ጋር ኑና ደንꬅꬃነ። ኑ አሽቲ ግዳ ኢታ አሞትꬅ የዘ ግሾ ኑኒ Ꮉይቆ ኣፈ አፎደ ፋና ኦቻነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","የዝን Ꮉተ ኑኒ ኑና አጭደ ህግትስ Ꮉይቅደ ግሾ ኑኒ ህገ አቻፓ ብልንትዳ። ይኒ ግሾ፥ ክለ አያናር ጾዝስ ኪትንታነፕ አትን ጻፍንትደ ጋልአ ህግትስ ኪትንቶስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ዬዝን፥ ኑኒ ዋጋዉደ? ህገ ናጋራነ? አደ! የዝን ህገ ናጋራ አኮ የዛኮ ታና ኤርስዳ። ህገ፥ «አሙꬍፐ» ጋይካይዛኮ፥ አሙ አኮ የዛኮ ታ ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","የዝን ታ ኡባ ባዝ አሙꬎደ ፋና ናጋራ ህገ ባጋራ ታ ግዳ ኦገ ደንግዳ። ህገ ባይዛኮ ናጋራ Ꮉይቂደ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ዛጋ ህገ ባይዘ ዎደ ታ ፋጻ፥ የዝን ህገ እንግንትደ ዎደ ናጋራ ፋጽን ታ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ታኒ ደኦ የሳደ ፋና ጾዚ እንግደ ህገ ታስ Ꮉይቆ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ናጋራ ህገ ባጋራ ታና ጭምዘ ኦገ ደንግ፥ ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ይኒ ግሾ፥ ህገ ጌሽ፤ እዘ ጻፍንትደ ኪታን ጌሽ፥ ጽሎን ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ዬዝን፥ ሎኦ ማቅደ ባዝ ታላ አፋ Ꮉይቆ ክእዳነ? አደ! የዝን ናጋራ ናጋራ ማቅዛና ቆንጮደ ፋና ሎኦ ባዛራ ማድንቲ ታስ Ꮉይቆ ክእዳ። ይኒ ግሾ፥ ናጋራ ናጋራ ማቅዳና ህገ ባጋራ አꬊ ኤርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ኑኒ ህገ አያናባዝ ማቅዛኖ ኤራነ። የዝን ታኒ ናጋራስ ባይዝንትደ አሾ አስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ታኒ ታ ኦችዛኖ ቲሮስ፤ ታኒ ካꬍዘባዝ ኦቾዳኖ አሺ ታ እጽዘባዝ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ታኒ እጽዘባዝ ኦችዘባዝ ማቅኮ፥ ህገ ሎኦ ማቅዛኖ ታ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ይኖ ማቅኮ፥ ይና ኦችቶ ታ ግዳ የዘ ናጋርታ ኦቻነፕ አትን ታ ኦቾስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ታ ግዳ፥ ይናን ታ አሽተ ሎኦ ባዝ ባዛኖ ኤራነ። ሎኦ ባዝ ኦችዘ አሞትꬅ ታ ግዳ የነ፥ የዝን ሎኦ ባዝ ኦቾደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ታኒ እጽዘ ኢታ ባዝ ኦቻነፕ አትን ታ ካዽዘ ሎኦ ባዝ ኦቾስ። ");
INSERT INTO oyde_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ታኒ እጽዘባዝ ኦችዘባዝ ማቅኮ፥ ይና ታ ግዳ የዘ ናጋርታ ኦቻነፕ አትን ኦችዘ ታና ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ይኬ፥ ታ ሎኦ ባዝ ኦቾደስ ካꬍዝን፥ ኢታ ባዝ ኦችዛኖ ቤዝዘ ህገ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ታኒ ታ ዎዝንተ ጾዘ ዎግተ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","የዝን ታ አሳትꬅተ የዛይ ታ ጉግተ የዘ ህገራ ኦልንትዘ ዱማ ህገ በእነ። የ ህግዘ ታ አሳትꬅተ ኦችዘ ናጋራ ህገስ ታና አሮ ማህ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ታኒ ዋይዝ አላ ዎꬍደ አሶ? Ꮉይቆስ ካንግዘ Ꮉና አሳትꬅትፓ ታና አሾደ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ኑ ላꬄ የሱስ ክርስቶሳ ባጋራ ታና አሽዘ ጾዘስ ጋላታ ማቀ። ይኬ፥ ታኒ ታ ቆፍተ ጾዘ ህገስ አቃነ፤ የዝን ታ አሳትꬅተ ናጋራ ህገስ አቃነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ይኒ ግሾ፥ ክርስቶስ የሱሳራ የዙንꬅ Ꮉተ ፍርዳ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ክርስቶስ የሱሳ ባጋራ ኑስ ደኦ እንግዘ ጌሽ አያና ህገ፥ ታና ናጋራን Ꮉይቆ ህገ አሮትꬃፓ ከስዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ኑ ናጋራ አሳትꬅት ባጋራ፥ ህገ ለፕደ ግሾ ኑና አሾደስ ዳንዳእካያ። ጾዚ ፋ ናአያ ናጋራንቾ አሱንꬅስ አዝዝ ናጋራስ ዣርሾ ማቆደ ፋና ኪቲ ይኖ ኦችዳ። የይዝ፥ ጾዚ ክርስቶሳ አቶትꬅት ባጋራ፥ ናጋራ ፍርድ Ꮉስዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ጾዚ ይኖ ኦችዳና፥ ኑ አሾ አሞ ኮይዛን ፋና ባይዝን ጌሽ አያና ኮይዛን ፋና የዘ ኑላ አፋ ህገ ጽሎ ኪታ ፎልንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","አሾ ቆፋር የዙንꬅ አሾባዝ ቆፓነ። የዝን ጌሽ አያና ቆፋር የዙንꬅ ጌሽ አያናባዝ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ኑ ቆፍታ አሾ አሞስ አቅኮ Ꮉይቆ ከእነ፥ የዝን አያናስ አቅኮ ደኦን ሳሮትꬅ ከእነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","አሾ አሞስ አቅዘ አስ ጾዘ ህገስ ኪትንቶደስ ኮዮሰ ግሾን ኪትንቶደስ ዳንዳኦሰ ግሾ ጾዛራ ሞርከ። ");
INSERT INTO oyde_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","አሾ አሞስ አቅዙንꬅ ጾዝ ኡፋይሶደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","የዝን ጾዘ አያና ይንታራ የዝኮ ይንታላ አቅኮ፥ ይን አያና ቆፋ የነፕ አትን ይን አሾ አሞስ አቆስ። ክርስቶስ አያና ባይዝን ኦንን ክርስቶሳስ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","የዝን ክርስቶሳ ይን ግዳ የዝኮ፥ ይን አሳትꬅታ ናጋራ ባጋራ Ꮉይቂዳኖ። የዝን ይን አያንዘ ጽሎትꬅ ባጋራ ደኦ የነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","የዝን የሱሳ Ꮉይቆፓ ደንꬅደ ጾዘ አያና ይን ግዳ የዝኮ፥ ክርስቶሳ Ꮉይቆፓ ደንꬅደ ጾዚ፥ ይንታራ የዘ ፋ ጌሽ አያናራ Ꮉይቂደ ይን አሳትꬅትስ ደኦ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ይኬ፥ ታ እሹንꬆ ጋለ የነ፥ ኑኒ ኑ አሾ አሞ ካሊ የሳደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ይን፥ ይን አሾ አሞስ የዝኮ Ꮉይቆዳ፥ የዝን ጌሽ አያና ዎልቃራ ናጋራ ኦችቶ ዎꬍኮ ይን ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ጾዘ አያና ካልዘ ኡቡንꬅ ጾዘ ናኡንꬃና። ");
INSERT INTO oyde_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ኑኒ፥ «አቦ፥ ታ አዳዮ» ያጋእ ጼግዘ፥ ጾዘ ናኡንꬃና ማህዘ ጌሽ አያና ኤክዳፕ አትን ማህ ዣሽሞራ የሳደስ አሮ ማህዘ አያና ኤክካያ። ");
INSERT INTO oyde_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ጾዘ አያና ኑ አያናራ ማቂ ኑኒ ጾዘ ናአ ማቅዛኖ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ኑኒ ኤ ናአ ማቅኮ ጾዛ ላቶዳ፤ ክርስቶሳራ ዎላ ይኖ ላቶዳ። ማህ ኑኒ ክርስቶሳራ ዋየ ኤክኮ ኤራ ዎላ ኤ ቦንችቶ ሻክንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ኑኒ Ꮉተ ዋይዘ ዋይቶ፥ ቲኖፓ ኑስ ቆንጮደ ቦንቾራ የልꬅ ብእኮ፥ ዎልክሳደስ ዳንዳእንቶስ ጋእ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","መትꬅ ኡባ ጾዘ ናአ ቆንጭꬅቶ ጋማ አሙꬊ ካፋነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","መትꬅ ኡባ Ꮉሪ ማቅዳ፤ ይናን፥ መትꬅታ ዶሮር ባይዝን ኡፋይሳራ ናጎደ ፋና ኦችደ ጾዘ ቆፋ Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","መትꬅ ፋ ኦምተ ꬋበ አሮትꬃፓ ኬዚ፥ ጾዘ ናኡንꬃራ ዋሎ ቦንቾ ግሽንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","መትꬅ ዎላ Ꮉይኖ የሎደስ የሎ ꬋኤ አይክደ ማችት ፋና እንጽጸራን ኡንአራ የዛኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ማህ ይኖ መትꬅት ጻላላ ባይዝን ጌሽ አያና እሞ ኤክደ ኑኒ፥ ኑ ኦምተ ኑ አሳትꬅትስ ዎዞ ማቅደ ጾዘ ናአ ማቅዘ ኡፋይስቶ ናግተራ ኑ አሳትꬅተ እንጽጻነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ይና ኡፋይስተ ኑኒ አትዳ። የዝን ኑኒ ኡፋይስ ኦችዘባዝ በንትዘ ባዝ ማቅኮ ይኖ ኦደ ኡፋይስ ኦችዘ? ");
INSERT INTO oyde_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","የዝን ኑ ብእካይዘ ባዝ ደንጎደስ ጋእ ኡፋይሳራ ናግኮ ይኖ ዳንዳአራ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ይኒ ጋር ጌሽ አያና ኑ ላብꬅተ ማዳነ። ኑኒ ጾዝ ዋይዝ ዎሶደስ ቤዝዛኮ ኤሮስ፥ የዝን ጌሽ አያና ፋ ኦምተ፥ አስ ኦሆደስ ዳንዳኦሰ ቃላር ኑስ ሾባነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ማህ አስ ዎዝና ኤርዘ ጾዘ ጌሽ አያና ቆፍታ አኮ የዛኮ ኤራነ። ጌሽ አያና ጾዘ ቆፍት ጋር ጌሹንꬅስ ሾባነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ጾዛ ሲቅዙንꬅስን ኤ ቆፍት ጋር ጼግንተዙንꬅስ ጾዚ ኡባ ባዝ ሎኦስ ኦችዛኖ ኑ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ጾዛ ኤርዱንꬅ ፋ ናአያ አዞደ ፋናን ናአይን አማንዙንꬅ ግዳ አንግስ ማቃደ ፋና ኡንታና ዶሪ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ጾዚ ቲኖ ዶርዱንꬃና ጼግዳ፤ ጼግዱንꬃና ጽልዝዳ፤ ጽልዝዱንꬃና ማህ ቦንችዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ዬዝን፥ ኑ Ꮉና ኡባንስ ዋጋዉደ? ጾዚ ኑ ባጋ ማቅኮ ኑና ኦደ እጾደ? ");
INSERT INTO oyde_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ኤ መለ አቶ የዝን፥ ፋ ናአይስ ይቅስንትካይዛራ፥ ኑ ግሾ አꬂ እንግዳ። ዬዝን፥ ፋ ናአያ ኑስ አꬂ እንግደ ዋይዝ ኤ ኡባ ባዝ ጨር እንጎሶ? ");
INSERT INTO oyde_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ጾዚ ዶርዱንꬃና ኦደ ሞቶደ? ጽልዘ ጾዚ ፍርድዘ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ዬዝን፥ ኡንታላ አፋ ፍርዶደስ ዳንዳእዘ ኦደ? ኦንን ባያ። Ꮉይቆፓ ደንዲ ጾዘ ምዛቅተ በትደ፥ ክርስቶስ የሱሳ፥ ኤ ኑስ ሾባነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ይኬ፥ ኑና ክርስቶሳ ሲቆፓ ሻጎደ ኦደ? ዋየነ ዎይ ማꬋነ ዎይ ባይኤነ ዎይ ናየ ዎይ ካሎትꬆነ ዎይ ዣሽሞነ ዎይ ኦላነ? ");
INSERT INTO oyde_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ጌሽ ማጻፍተ፥ «ኑኒ ነ ግሾ አዋራ ኩሙꬅ Ꮉይቃነ፤ ሹፎስ ካንግዘ ዱሮ ፋና ፋይድንትዳ» ጋእንት ጻፍንትደ ፋና ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","የዝን ኑኒ Ꮉነ ኡባ፥ ኑና ሲቅዘ ክርስቶሳራ ጋምዙንꬃፓ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ይኒ ግሾ፥ Ꮉይቆ ማቅን ደኦ ማቅን ኪታንቹንꬃና ማቅን አህዙንꬃና ማቅን Ꮉተ የዛያ ማቅን ቲኖፓ ዮኦዳያ ማቅን ዎልቃሙንꬃና ማቅን፥ ");
INSERT INTO oyde_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ꬎቃ ማቅን ዝቃ ማቅን አኮ መትꬅ ማቅን ኑ ላꬄ፥ ክርስቶስ የሱሳራ የዘ ጾዘ ሲቆፓ ኑና ሻኮደስ ዳንዳኦሳኖ ታኒ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ታኒ ክርስቶሳር ቱሮ ኦህነ፥ ዎርድꬎስ። ጌሽ አያና ካልꬅዘ ታ ዎዝንታ ታኒ ዎርድꬎኦሳኖ ታስ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ታ ዎዝንተ እስራኤሉንꬅስ ጋማ አዛኖን አሾሰ ዋየ ታ ግዳ የነ። ");
INSERT INTO oyde_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ታኒ፥ ታ እሹንꬅን ታ እግኑንꬅ ግሾ ክርስቶሳፓ ሻክንት ጾዘ ባድꬃፓ ኦሞራ የዘዛኮ ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ኡንትን እስራኤሉንꬃና፥ ጾዚ ኡንታና ፋ ናኡንꬃና ማህዳ፥ ፋ ቦንችቶ ኡንትስ ቆንጭዝዳ። ኡንታራ ጫቂዳ፤ ህገ ኡንትስ እንግዳ። ኡን ጾዝ ጎይኖደ ቱሪ ኦገ ቤዝዳ፤ ጾዚ ኡፋይስ ቃላ ኡንትስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ኡን የልንተራ ማይዙንꬅ ኮች፤ ማህ ክርስቶሳ አሾራ ኡን ኮች ማቂ ይእዳ። ኡባፓ ካታራ ማቅደ ጾዘ መꬍናስ አንጅንትዳ። አምንኤ! ");
INSERT INTO oyde_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","የዝን፥ ጾዘ ቃልታ ሻርንትዳ ጋኤ ባያ። እስራኤለፓ ይእደ ኡባ ቱሪ እስራኤለ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ማህ አብራሃማ ኮች ኡባ አብራሃማ ናአ ማቆስ። ጾዚ አብራሃማስ፥ «ነ ዛርታ ይሳቃ ባጋራ ጼግንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ይኖ ጋዛና አሾራ የልንትደ ናአ ኡቡንꬅ ጾዝ ናአ ማቆስ። የዝን ቱሪ እስራኤለ ናአ ጾዚ አብራሃማስ ገልደ ቃልት ጋር የልንትደ ናአ። ");
INSERT INTO oyde_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ያጋዛኖ። ጾዚ እንጎዳ ጋእ ገልደ ቃልታ፥ «ታኒ ዎንꬅ በረ Ꮉኒ ዎደ ዮኦዳ፤ ሳራን ꬊራꬅ ናአ የሎዳ» ");
INSERT INTO oyde_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ይኖ ጻላላ ባይዝን እርቢቃ ፈቲ ኑ አዳይ ይሳቃፓ መንተ ናኡንꬃና ዎዳጽደ ዎደ፥ ");
INSERT INTO oyde_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ኡን የልንቶደፓ ኢታ ዎይ ሎኦ ኦቾደፓ ቲኖ ኦቻራ ባይዝን ዶረር ማቅዘ ጾዘ ቆፍታ ምንጎደ ፋና፥ ");
INSERT INTO oyde_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","«አንግሰ ጌዘስ ኪትንቶዳ» ያጋእ ላꬂ እርቢቃስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ጋእንት ጻፍንትዳ። ይናን ጌሽ ማጻፍተ፥ «ያይቆባ ካꬍዳ፥ ኤሳዎ እጽዳ» ");
INSERT INTO oyde_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ዬዝን፥ ኑ ዋጋዉደ? ጾዚ ፍርዳ ደሽዛነ? አደ። ");
INSERT INTO oyde_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ላꬂ ሙሴጎ፥ «ታ ማሮደስ ኮይዱንꬃና ማሮዳ፤ ታ ይቅስንቶደስ ኮይዱንꬅስ ይቅስንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ይኬ፥ ጾዘ ዶረ አስ ቆፋ ዎይ ኦቻራ ባይዝን ኤ ማሮትꬅተ። ");
INSERT INTO oyde_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ጌሽ ማጻፍተ፥ ግብጸ ካትዘጎ፥ «ታኒ፥ ታ ዎልቅቶ ኔላ ቤዞደስን ታ ሱንꬅታ አላመ ኡባ ግዳ ኤርንቶደ ፋና ይንስ ነና ካእትዝዳ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ይኬ፥ ጾዚ ማሮደስ ኮይዛያ ማራነ፤ ዎዝንቶ ሙምሳደስ ኮይዛይ ዎዝንቶ ሙምዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ይንታፓ ፈታይ፥ «ዬዝን፥ ጾዝ አስ ኢታ ኦቻ ግሾ አኮስ ቦረ? ጾዘ ቆፍቶ አቶ ጋዉደ ኦደ?» ጋእ ኦጮደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","የዝን ታ እሻዮ፥ ጾዛራ ላሎደስ ነ ኦደ? ሎቃፓ መꬍንትደ ሚሸ ፋና መꬍደጎ፥ «ታና Ꮉኒ ጋር ኦቺ አኮስ መꬍዶ?» ጋእ ኦጮደስ ዳንዳአነ? ");
INSERT INTO oyde_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ዎይ ሎቃ መꬍዳይ ፈቲ ሎቃፓ ፈታያ ቦንቾ ሚሸ፥ Ꮉንካያ ማህ ቦረ ሚሸ ማህ መꬎደስ አደትꬅ ዎልቃ ባያ? ");
INSERT INTO oyde_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ጾዚ ፋ ካችቶ ቤዞደስ ፋ ዎልቅቶ ኤርሶደስ ኮይ፥ ፍርዳስ ጊግደ Ꮉንቆ ናኡንꬃና ጋማ ገንጨራ ዳንዳኤዛኮ ነ አኮ ኤረ? ");
INSERT INTO oyde_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ይኖ ኤ ኦችዳና ቲኒ ቦንቾስ ጊግዝደ፥ ፋ ዶርደ ናኡንꬅስ ፋ ቦንችቶ ቆንጭሳደስ። ");
INSERT INTO oyde_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","አይሁዱንꬃና ጻላላ ማቅካይዝን፥ አይሁደ ማቆሰ ኑንን ጾዛራ ዶርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ናበ ሆሴዕ ማጻፍተ፥ «ታ አስ ማቅካይዙንꬃና፥ ታ አስ ጋእ ጼጎዳ። ታ ሲቅካይዘ ዎርዥቶ፥ ‹ሲቅንትዱንꬃና› ጋእ ጼጎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ኡን፥ ‹ታ ዎርዣ ባያ› ጋእንት ጼግንትደ በስተ፥ ‹ደኦ ጾዘ ናአ› ጋእንት ጼግንቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ናበ ኢሳያሳ እስራኤለ አሱንꬅባዝ፥ «እስራኤለ አሱንꬅ አባ ጋጻ የዘ ሻፈ ፋና ጋንግኮን፥ ኡንታፓ ኤራꬅ አሱንꬅ ጻላላ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ይና ሳአላ አፋ ኤልሲ ፎልንቶዳ።» ");
INSERT INTO oyde_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ማህ ኢሳያሳ፥ «ኡባፓ ዎልቃማ ላꬄ ኑስ ኤራꬅ ኮች አሽካይዛኮ፥ ኑኒ ሶዶማን ጋሞራ ካታማ ፋና ꬋቦድ የሻ» ያጋእ ቲኒ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ዬዝን፥ ኑ ዋጋዉደ? ጽሎትꬅ ካሎሰ አይሁደ ማቆሰ አሱንꬅ አማኖራ ጽሎትꬅ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","የዝን ጽሎትꬃጎ የልꬅዘ ህገ የዘ እስራኤለ አሱንꬅ ጽሎትꬅ ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","አኮስ ደንጋንጽዶ? ኡን ጽሎትꬅታ አማኖራ ባይዝን ኦቻራ ኤኮደስ ኮይደ ግሾስ። የይዘ ግሾ፥ ኡን፥ «ꬉቢዘ ሹቻራ» ꬉብንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ጌሽ ማጻፍተ፥ ቦኦተ «ታኒ ጽዮነ ꬉቢዘ ሹችን ላላን ጋዶዳ። ኤዛ አማንዘ ኦንን ዬልꬎኦስ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ታ እሹንꬆ፥ ታ ኩሙꬅ ዎዝንተ ታ አሙꬍዛናን ጾዝ ዎስዛና እስራኤለ አቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ኡን ጾዝስ ምሽንታነ የዝን፥ ቱሪ ኤራትꬃፓ ምሽንቶሳኖ ታ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ኡን ጾዘ ጽሎትꬅ ኦግቶ ኤራንጺ እጺ፥ ፋ ኦማ ጽሎትꬅ ካልዳፕ አትን ጾዘ ጽሎትꬅ ኮይካያ። ");
INSERT INTO oyde_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","አስ ኡባ አማኖራ ጽሎደ ፋና ክርስቶሳ ህገ ፎልዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","አስ ህገ ናጊ ኤክዘ ጽሎትꬅባዝ ሙሴ ጻፍተራ፥ «ህገ ናግዘ ኦንን ይና ህግቶ ናጊ ደኦ የዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","የዝን አማኖራ ኤክዘ ጽሎትꬅባዝ ጋእንትዳና Ꮉኖ፦ «ነ ዎዝንተ፥ ‹ኦኒ ሳሎ ኬሳደ?› ያጋእፐ፤ ይና ክርስቶሳ ዎዺሳደስ። ");
INSERT INTO oyde_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ዎይ፥ ‹ሱለ ሳአ ኦሞ ዎꬎደ ኦደ?› ጋእፐ፤ ይና ክርስቶሳ ቦዛፓ ኬሶደስ። ");
INSERT INTO oyde_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","የዝን ያጋእ ጻፍንትዳ፦ ‹ቃላ ነ ካለ፤ ነ ዶንተ ነ ዎዝንተ የነ› ኑኒ ይንትስ ኦህዘ አማኖ ቃልታ Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","«የሱሳ ላꬂ» ጋእ ነ ዶንተ ማርክꬍኮ ጾዚ ኤዛ Ꮉይቆፓ ደንꬅዳኖ ነ ዎዝንተ አማንኮ፥ ነ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","አስ ፋ ዎዝንተ አማኒ ጽላነ፤ ፋ ዶንተ ማርክꬊ አታነ። ");
INSERT INTO oyde_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ጌሽ ማጻፍተ፥ «ኤዛ አማንዘ ኦንን ዬልꬎኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ፈቲ ጾዘ ኡቡንꬅ ላꬂ ማቅደ ግሾ አይሁዱንꬃና ማቅን አይሁደ ማቆሰ አሱንꬅ ግዳ ዱማትꬅ ባያ። ኤ ፋና ጼግዘ ኡቡንꬅስ ፋ አንጅቶ ጋንꬂ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","«ላꬄ ሱንꬅቶ ጼግዘ ኦንን አቶዳ።» ");
INSERT INTO oyde_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ዬዝን፥ ኡን አማኖሳራ ዋይዝ ኤዛ ጼጎደስ ዳንዳኤ? ኡን ኤ ባዝ ስእካይዛራ ዋይዝ ኤዛ አማኖደስ ዳንዳኤ? ማህ ኡንትስ ቃላ ኦህዘ አስ ባይዝን፥ ዋይዝ ኤዛ ስኦደስ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ኪትንትደ አስ ባይዝን፥ ቃላ ዋይዝ ኦህንቶደስ ዳንዳኤ? ጌሽ ማጻፍተ፥ «ኡፋይስ ዎንገለ ኦህዘ አሱንꬅ ቶህታ ዋይዝ ሎኦ የሳ!» ያጋእ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","የዝን ኢሳያሳ፥ «ላꬆ፥ ኑ ማርካትꬅቶ ኦደ አማንዶ?» ያጋእዳን ፋና፥ ኡቡንꬅ ዎንገለ አማንካያ። ");
INSERT INTO oyde_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ይኒ ግሾ፥ አማኖ ስሳፓ የእነ፤ ስእዛናን ክርስቶሳ ቃላፓ የእነ። ");
INSERT INTO oyde_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ማቆ የዝን፥ እስራኤለ አሱንꬅ ቃላ ስእካያ ጋኤነ? አደ ስእዳ። ጌሽ ማጻፍተ፥ «ኡን ኦꬅታ ሳአ ኡባ ስንትዳ፥ ኡን ቃልታ ሳአ ጋጻ የልዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","የዝን እስራኤለ አሱንꬅ ኤርካያ ጋኤነ? ሙሴ ዛጋ፥ «ታኒ ይንታና ለቅንትደ አሱንꬃራ ቂሪሳዳ፤ ማህ ኤያ አሱንꬃራ ይንታና ዥልሳዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ማህ ኢሳያሳ፥ «ታና ኮይካይዘ አሱንꬅስ በንትዳ፤ ታና ኦጭካይዘ አሱንꬅስ ቆንጭዳ» ያጋእ ዣሽትካይዛራ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","የዝን እስራኤለ ባዝ ኦህተራ፥ «ኡባ ቃማ ኪትንቶሰ አሱንꬅስን ታና እጽዘ አሱንꬅስ ታ ኩሽቶ ምጭዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","አነ ታ ኦጮ፦ ዬዝን፥ ጾዚ ፋ አሱንꬃና ኦልዳነ? ኦልካያ! ታኒ ታ ኦምተ እስራኤለ፤ አብራሃማ ኮች፤ ብንያመ ኮች። ");
INSERT INTO oyde_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ጾዚ ቲኖ ዶርደ ፋ አሱንꬃና ኦልካያ። ጌሽ ማጻፍተ፥ ኤልያሳ እስራኤሉንꬃና ጾዘ ቲኖ ዋይዝ ሞተዛኮ፥ ይን ኤሮሶ? ");
INSERT INTO oyde_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ኤልያሳ፥ «ላꬆ፥ ኡን ነ ናቡንꬃና ዎꬍዳ፥ ነ ዣርሾ በስቶን ላልዳ። ታ ታ ጻላላ አትዳ፤ ኡን ታናን ዎꬎደስ ኮያነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ጾዚ ኤስ ዋጋእ ማህዶ? «ባኣለ ኤቃስ ጎይንካይዘ ላፑን ሙኩል አሱንꬃና ታስ አሽዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ይኒ ጋራን፥ Ꮉና ዎድተ ጾዚ ፋ አꬎ ኬሃትꬅተ ዶርዱንꬃፓ አትደ (እስራኤሉንꬅ) የነ። ");
INSERT INTO oyde_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ኤ ኡንታና ዶርደ ፋ አꬎ ኬሃትꬅተፕ አትን ኡን ኦቻራ ባያ። ዶረ ኦቻራ ማቅኮ፥ ኤ አꬎ ከሃትꬅታ አꬎ ኬሃትꬅ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ዬዝን፥ ዋይዶ? እስራኤለ ፋ ኮይዛኖ ደንግካያ፥ የዝን ጾዚ ዶርዱንꬂ ደንግዳ። አትዱንꬅ ፋ ዎዝንቶ ሙምዝዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","የዝን፥ ጌሽ ማጻፍተ፥ «ኡን ፋ ኣፍተ በአመ ፋና ፋ Ꮉይተ ስአመ ፋና፥ Ꮉኖ የሎደስ ኡንትስ ጾዚ ዶጭዘ አያና እንግዳ» ጋእንት ጻፍንትደ ጋር Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ማህ ዳዉተ፥ «ኡን ሙእዘ ጋብታ ኡንታና ጽኬ ፋና አይኮ፤ ኡንታና ጎልእዘ ጋጋ ማቆ፤ ኡን ኢታትꬅታ ኡንታና የሎ። ");
INSERT INTO oyde_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ኡን በአመ ፋና ኡን ኣፍታ ጎዝንቶ፤ ኡባ ዎደ ዋየፓ ደንድ ይን ባንታ ኩኒ የዞ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ዬዝን፥ አይሁዱንꬅ ማህ ደንዳመ ፋና ጎልእዳነ? ባያ! ኡን ጎልእታ አይሁደ ማቆሰ አሱንꬅ አቶደ ፋና ምክናተ ማቅዳ። ይናን አይሁዱንꬅ ኡንታላ አፋ ቃናኦደ ፋና ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","አይሁዱꬅ ናጋርታ አላምትስ ጋማ አንጆ ክእዳ፤ ማህ ኡን ጎልእታ አይሁደ ማቆሰ አሱንꬅስ ጋማ አንጆ ማቅዳ። ዬዝን፥ ዶርንትደ አይሁዱንꬅ ኩሙꬅ አትዘ ዎደ አንጆ አኮ ፋና ጋንጎድ የሻ! ");
INSERT INTO oyde_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ታኒ፥ Ꮉተ ይንትስ አይሁደ ማቆሰ አሱንꬅስ ኦህነ። አይሁደ ማቆሰ አሱንꬅ ሐዋረ ማቂ ኦችዛነ ታኒ ጋማ ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ታ ይኖ ኦችዳና ታስ አሾ ኮች ማቅዘ እስራኤሉንꬃና ቂርዝዳና ኡንታፓ ኤራꬅቶ አሾደስ። ");
INSERT INTO oyde_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ጾዚ ኡንታና ኦሊ አሽደ ዎደ Ꮉና አላምታ ጾዛራ ጊግዳ። ጾዚ ኡንታና ሺሺ ኤክዘ ዎደ Ꮉይቅደ አስ Ꮉይቆፓ ደንድዘ ፋና ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ቲኖ ምንጻ ኣፍዘ ጾዝስ ዣርሽንትደ ጌሽ ማቅኮ፥ ሙሎ ምንጻ አፍታን ጌሽ። ምንጻዘስ ጻጵታ ጌሽ ማቅኮ፥ ዣንግታን ጌሽ። ");
INSERT INTO oyde_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ጋደ ቱክደ ሻማሄ ዣንገ ማቅደ አይሁዱንꬅ መቂኮ፥ ይን ጉርደ ዶልደ ሻማሄ ዣንገ ማቅዘ አይሁደ ማቆሱንꬅን ኡን በሳ ꬋንꬅንቲ ኡን ኣፈ አንጅቶን ዱረትꬅቶ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ይኬ፥ ይን ዣንገ ፋና ሳርፍንቲ ዎꬍደ አይሁዱንꬃላ አፋ ኡቱርትፐተ። ይን ኡቱርትዘ ባዝ ማቅኮ፥ ጻጶ ይንታና ቶክዳፕ አትን ይን ጻጶ ቶኮሳኖ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ኔኒ፥ «ይኬ ታ ኡን በስተ ገሎደ ፋና» ጋእ ቆፖዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ይና ቱሮ። ኡን አማንካይዘ ግሾ ሳርፍንትዳ። ነ አማንደ ግሾ ይና በስተ ኤቅዳ። ነ ዣሽቶደስ ቤዛነፕ አትን ኡቱርቶደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ጾዚ መꬎ ዣንገ ማቅዘ አይሁዱንꬅስ ይቅስንታንጽኮ ይንትስን ይቅስንቶስ። ");
INSERT INTO oyde_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ይኬ፥ ጾዚ አኮ ጋር ዳልጋን አኮ ጋር ዣሽዛኮ ቦኦ። ኤ ዣሽዛና ኪትንቶሱንꬃላ፥ ማህ ኤ ዳልጋትꬅታ ይን አማኒ ሚንግ ኤቅኮ ይንትስ። ሚንግ ኤቃንጽኮ ይንትን ሳርፍንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","አይሁዱንꬅ አማንኮ፥ ዛጋ የዘ በስተ ማቃዳ። ጾዚ ኡንታና ማህ፥ ገልꬆደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ይንታና ጉርደ የዘ ሻማሄ ማቅደ አይሁደ ማቅካይዙንꬃና ጋቺ፥ ጋደ ቱክደ ሻማሄላ አፋ ይንታና ꬋንꬅኮ፥ መꬎ ጋደ ሻማሄ ማቅደ አይሁዱንꬃና ፋ ቲኖ በሳ ማህ ቱኮደስ ዋይዝ ዳንዳእንቶሳ? ");
INSERT INTO oyde_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ታ እሹንꬆ፥ ይን ይንታና ኤራንቻ ጋእ ጬቅንትፐተ። ታ ይንትስ ኦህዘ ፈቲ ሳዛ ቆፋ የነ። ይናን እስራኤሉንꬅ ስአንጽ እጽዳና ዉርሱꬅ የሎደስ ማቅካይዝን አቶደስ የዘ አይሁደ ማቆሰ አሱንꬅ ኩሙꬅ ጾዛጎ የኦደ ዎንꬅስ። ");
INSERT INTO oyde_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ይኒ ጋር፥ እስራኤለ አሱንꬅ ኡባና አቶዳ። ጌሽ ማጻፍተ፥ «ኑና አሽዛይ ጽዮነፓ ዮኦዳ፤ ያይቆባ ኮቻፓ ኢታ ኡባ Ꮉሶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ታኒ ኡን ናጋርቶ አቶ ጋዘ ዎደ ኡንታራ ገልዘ ጫቅታ Ꮉኖ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","አይሁዱንꬅ ዎንገለ ኤካንጽደ ግሾ ይንታራ ሞርከ። ማቆየዝን፥ Ꮉተን ኡን ዶርንትደ ግሾን፥ ጾዚ ኡን አዱንꬅ ግሾ ኡንታና ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ጾዚ ፋ እሞተን ፋ ጼግተን ቂርꬎስ። ");
INSERT INTO oyde_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ይን አይሁደ ማቆሱንꬅ ዛጋ ጾዝስ ኪትንትካያ። የዝን Ꮉተ አይሁዱንꬅ ኪትንታንጽ እጽን፥ ይን ጾዘ ማሮትꬅቶ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ይኒ ጋር፥ ይን ኤክደ ማሮትꬅቶ አይሁዱንꬅ ኤኮደ ፋና Ꮉተ ጾዝስ ኪትንታንጽ እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ጾዚ አስ ኡቡንꬅስ ፋ ማሮትꬅቶ ቤዞደስ ኮይ፥ አስ ኡባ ኪትንቶሱንꬃና ጋእ ፋይድዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ጾዘ ዱረትꬅ፥ ጭንጫትꬅን ኤራትꬅ ቆፒ ኦሆደ ኦደ? ኤ ፍርድታ ቁርችንቶስ፥ ኤ ኦግታ ኤርንቶስ። ");
INSERT INTO oyde_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ጌሽ ማጻፍተ፥ «ላꬄ ቆፋ ኤርዘ ኦደ? ኤዛ ዞሮደስ ዳንዳእዘ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ጾዝስ ታልእዘን ታልእዳኖ ማህ ኤክዘ ኦደ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ኡባና ኤፓ፤ ኤራን ኤስ። ኤስ መꬍናስ ቦንቾ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ይኬ፥ ታ እሹንꬆ፥ ጾዛ ኡፋይስዘ፥ ደኦን ጌሽ ዣርሾ ማህ፥ ይን ጋልቶ ሺሾደ ፋና ታኒ ይንታና ጾዘ ማሮትꬅተ ዎሳነ። ይናን ጾዛ ይን ጎይኖደስ ቤዝዘ ቱሪ ኦገ። ");
INSERT INTO oyde_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ሎኦ፥ ኡፋይስዘን ፎሎ ማቅደ ጾዘ ቆፋ ሻኪ ኤሮደስ ይን ዎዝንተ ላምንቶተፕ አትን Ꮉና አላምቶ አዝፐተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ጾዚ ይን ፈታይስ ፈታይስ እንግደ አማንቲ ፋና ዎዝናማ አስ ፋና ቆፖተ። ቆፖደስ ቤዝዛንፓ አꬂ ይንታና ዱሙዚ፥ ኡቱራራ ቆፕፐተ ጋእ ታስ እንግንትደ አꬎ ኬሃትꬅተ ይንትስ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ኑ ፈቲ ጋልቲ ግዳ ዱማ ዱማ ብልቱንꬅ የነ፤ ይና ዱማ ዱማ ብልቱንꬅስ ዱማ ዱማ ኦቻ የነ። ");
INSERT INTO oyde_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ይኒ ጋር፥ ኑኒ ጋማ አስ ማቅኮን ክርስቶሳራ ፈቲ ጋላ ማቅዳ። ኑኒ ፈቲ ጋላ ማቂ ዱማ ዱማ ብልተ ፈታይ ፈታይራ አይክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ኑስ እንግንትደ አꬎ ኬሃትꬅተ ዱማ ዱማ እሞ የነ። ኑ እሞታ ትንቢተ ኦሄ ማቅኮ፥ ኑስ የዘ አማንቲ ጋር ኦሆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ኑ እሞታ መሉንꬃና ማደ ማቅኮ፥ ይና ኦችተ ምንጎደስ ቤዛነ፤ ታማርሰ ማቅኮ፥ ይና ታማርስተ ምንጎደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ኑ እሞታ መሉንꬃና ምንꬅ ማቅኮ፥ ሚንግ ምንꬅꬆደስ ቤዛነ። ኑ እሞታ ኑስ የዘ ባዛፓ መሉንꬅስ እንገ ማቅኮ፥ ዎዝናፓ እንጎደስ ቤዛነ። ኑ እሞታ አሄ ማቅኮ፥ ሚንግ አሆደስ ቤዛነ። ኑ እሞታ መሉንꬅስ ኬሄ ማቅኮ፥ ኡፋይሳራ ኬሆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ይን ሲቅታ አፉራፓ ካታራ ማቆደስ ቤዞስ። ኢታ ባዝ እጾተ፤ ሎኦ ባዝ ምንꬂ አይኮተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ፈታይ ፋታይራ እሸ ፋና ሲቅንቶተ፤ ፈታይ ፈታያ ቦንቾተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","አዛልእፐተ፤ ይን አያናር ሚንግ ላꬅስ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ጾዚ እንግደ ኡፋይሳራ ኡፋይቶተ፤ ማꬋ ዳንዳኦተ፤ ኡባ ዎደ ጾዝ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","አማንዘ ጌሹንꬃና ኮሽዘ ባዛራ ማዶተ፤ ዛቆ ሞኮተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ይንታና ባይእዙንꬃና አንጆተ፤ አንጆተፕ አትን ባድፐተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ኡፋይትዙንꬃራ ኡፋይቶተ፤ ዬክዙንꬃራ ዬኮተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ፈታይ ፈታይራ ፈቲ ቆፍተ የዞተ። ኡቱራ ቆፋ አሺ፥ ይንታና ዝቂ ዪዚ፥ አዳ አሱንꬃራ ዎላ የዞተ። ይን ይንታና ኤራ ጋእ ቆፕፐተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ኦደን ይንትስ ኢታ ባዝ ኦችኮ፥ የ አꬄስ ኢታ ማህፐተ። አስ ኡባ ቲኖ ናሽዘ ሎኦ ኦቻ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ዳንዳእንትኮ አስ ኡባራ ሳሮ የሳደስ ይንትስ ዳንዳእንትዛኖ ኡባ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ታ እሹንꬆ፥ ይን፥ ይን ኦምተ አስስ ቅመ ማህፐተ። ጾዚ ቅመ ማሆደ ፋና ኤስ አሾተ። ጌሽ ማጻፍተ፥ «ታኒ ቅመ ማሆዳ፤ ታኒ ኩሽቶ ማሆዳ» ያጋነ ላꬂ፥ ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","የዝን ጌሽ ማጻፍተ፥ «ነ ሞርክዛያ ናይꬍኮ ሙዞ፤ ኤ ባርꬍኮ ኡሾ። ነ ይኖ ኦችኮ ኤ ኦምተ ታማ ቃቃ ጉሳነ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ኢታ ሎኦር ጋሞተፕ አትን ኢታራ ጋምንትፐ። ");
INSERT INTO oyde_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ጾዘ ቆፋ ባይዝን አደትꬅ ዎልቃ እንግንቶሰ ግሾን Ꮉተ የዘ ሹሙንꬅን ጾዘ ቆፋራ ሹሙንትደ ግሾ አስ ኡባ ዎርዣ አህዙንꬅስ ኪትንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ይኒ ግሾ፥ አደትꬅ ዎልቃራ የዙንꬅስ ኪትንታንጽ እጽዘ ኦንን ጾዘ ኪታ እጻነ። ኪትንታንጽ እጽዘ ኦንን ፋላ አፋ ፍርዳ ከእነ። ");
INSERT INTO oyde_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","አህዙንꬂ ኢታ ኦችዙንꬃና ፋትን ሎኦ ኦችዙንꬃና ዣሾስ። አህዙንꬅስ ዣሽታንጾደስ ኮያነ? ዬዛኮ ሎኦ ኦቾ፤ ኡን ነና ጋላቶዳ። ");
INSERT INTO oyde_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ኡን ሎኦ ባዝ ኦቾደስ ሹሙንትደ ጾዘ አሮ። የዝን ነ ኢታ ባዝ ኦችኮ፥ ኡን ኢታ ባዝ ኦችዛ ሴርዘ ማሻ አይክደ ግሾ ኡንትስ ዣሽቶ። ኡን ኢታ ኦችዙንꬃና ሴሪ፥ ጾዘ Ꮉንቆ ቆንጭዘ ጾዘ አሮ። ");
INSERT INTO oyde_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ይኒ ግሾ፥ ጾዘ ካች ጻላላስ ባይዝን ይን ቆፍታ ማርክꬍዘ ግሾ ዎርዣ አህዙንꬅስ ኪትንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ይን ጊራ ጊርዛናን ይንስ። ዎርዣ አህዙንꬂ ይና ኦችቶ ኦችዛና፥ ኡን ጾዘ አሮ ማቅደ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ፈተስ ፈተስ ቤዛኖ እንጎተ። ጊራ ጊሮደስ ቤዛይስ ጊሮተ፤ ቃራጠ ጋቾደስ ቤዛይስ ቃራጠ ጋቾተ፤ ዣሽቶደስ ቤዛይስ ዣሽቶተ፤ ቦንቾ ቤዛያ ቦንቾተ። ");
INSERT INTO oyde_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ፈታይ ፈተራ ሲቅንቶተ። ሲቆ ጋለፕ አትን ይንታላ አፋ መለ ጋለ የዝፐ። አስ ሲቅዘ ኦንን ህገ ጋዛኖ ፎልዳ። ");
INSERT INTO oyde_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«ላምፐ፤ ዎꬍፐ፤ ካይስትፐ፤ አሙꬍፐ» ጋዘ ኪታን መሉንꬅን ኡባ፥ «አስ ነ ኦምት ፋና ካꬎ» ጋዘ ኪተ አጭንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","አስ ሲቅዘ ኦንን ኤዛላ አፋ ኢታ ባዝ ኦቾስ። ይኒ ግሾ፥ አስ ሲቅዘ ህገ ኪታ ፎልዳ። ");
INSERT INTO oyde_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ገንቶፓ ይን ባርክዘ ዎደ Ꮉተ የልዳኖ ኤሮተ። ኑ አማንደ ዎድትፓ አꬊ አቶትꬅ Ꮉተ ኑጎ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ቃማ አꬍዳ፤ ዎንታ ኡክዳ። ይኬ፥ ኑኒ ꬉማ ኦቻ አሺ ፎኦ ኦላ ሚሸ አይኮዳ። ");
INSERT INTO oyde_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","አነ አዋራ ፎኦ የዘ አስ ፋና ዎጋራ የዞተ። ቤዞሰ የꬃራን ማꬄራ ማቅፐ ኦላለ Ꮉንተራን ቃይጸር አይክንትደ ዱማ ዱማ ቱና ኦቻ፥ ላለራን ቅናተራ ማቅፐ። ");
INSERT INTO oyde_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ላꬄ የሱስ ክርስቶሳ ማኦተ፤ ይን ናጋራ አሾ ፋ አሙቶ ፎሎደ ፋና ቆፕፐተ። ");
INSERT INTO oyde_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","አማኖራ ላቢደ ኦናን ሺሺ ኤኮተፕ አትን ኤ ቆፍትላ አፋ ፍርድፐተ። ");
INSERT INTO oyde_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","አዝዘስ፥ አማኖራ ሚንግደ ፈቲ አስ አኮ ካꬃን ማአደስ ዳንዳአነ። የዝን አማኖራ ላቢደ አስ አታክልተ ጻላላ ሙነ። ");
INSERT INTO oyde_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ሙእዘ አስ ሞኦሰ አꬃ ቦርፐ። ሞኦሰ አꬄ ሙእዘ አꬄላ አፋ ፍርድፐ። ጾዚ ኡቡንꬃና ኤካነ። ");
INSERT INTO oyde_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","መለ አስ አሮላ ፍርድዘ ነ ኦደ? ኤ ላቢን ዎይ ሚንግን ኤ ላꬄ ኤራነ። ላꬂ ኤዛ ኤሶደስ ዳንዳእዘ ግሾ ኤ ሚንግ ኤቆዳ። ");
INSERT INTO oyde_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ማህ «ፈቲ አዋራ መለ አዋራፓ አꬋነ» ያጋእ ቆፕዘ አስ የነ። መለ ማህ፥ «አዋራ ኡባ ፈቲ ፋና» ጋእ ቆፓነ። የዝን ፈተ ፈተ ፋ ቆፍቶ ቆፒ ኦቾ። ");
INSERT INTO oyde_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ፈቲ ቃምዛ መለ ቃምትፓ አꬂ ቦንችዘ ኦንን ላꬄ ቦንቾስ ጋእ ኦቻነ። ካꬃ ሙእዘ አስ ላꬄ ቦንቾስ ጋእ ሙነ። ኤ ሙእዘ ይና ካꬅቲ ግሾ ጾዝ ጋላታነ። ካꬃ ሞኦሰ አስ ላꬄ ቦንቾስ መአንጽ አሻነ፤ ማህ መአንጽ አሸራን ጾዝ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ኑፓ ኦንን ፋስ የዞስ፤ ማህ ኑ ግዳፓ ኦንን ፋስ Ꮉይቆስ። ");
INSERT INTO oyde_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ኑ ደኦር የዝኮ ላꬅስ የሳዳ፤ ማህ Ꮉይቂኮን ላꬅስ Ꮉይቆዳ። ይኬ፥ ኑ ደኦር የዝን ዎይ Ꮉይቂኮን ላꬅስ። ");
INSERT INTO oyde_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ክርስቶሳ Ꮉይቂ Ꮉይቆፓ ደንድደ፥ ደኦር የዙንꬅስን Ꮉይቂዱንꬅስ ላꬄ ማቃደስ። ");
INSERT INTO oyde_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ዬዝን፥ ነ ነ እሸላ አፋ አኮስ ፍርደ? ዎይ ነ ነ እሻ አኮስ ለቀ? ኑኒ ኡባና ጾዘ ፍርዳ ኦይዳ ቲኖ ኤቆዳ። ");
INSERT INTO oyde_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ጌሽ ማጻፍተ ላꬂ፥ «ታኒ ደኦ፤ አስ ኡባ ታ ቲኖ ቡንቂንቶዳ፤ ታኒ ጾዝ ማቅዛኖ ማርክꬎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ይኬ፥ ኑ ኦችደ ባዝትስ ኑ ኦምተ ኦምተ ጾዝ ቲኖ ሺቂ ማሄ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ይኒ ግሾ፥ ኑኒ ፈታይ ፈታይላ አፋ ፍርድዛኖ አሾተ። የዝን ይን እሻያ ꬉቡꬃመ ፋና ዎይ ቃጻመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ላꬄ የሱሳ አማንዘ አስ ማቂ፥ ፋ ኦምተ ቱና ማቅደ ባዝ ባይዛኖ ታኒ ጌሽ ኤራነ። የዝን ፈቲ አስ ፈቲ ባዝ ቱና ማህ ቆፕኮ ይና ኤስ ቱና ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ነ ሙእዘ ካꬃ ግሾ ነ እሻያ ꬉቢዘ ባዝ ማቅኮ፥ ክርስቶሳ የዘ ነ እሻያ ሲቆስ። ክርስቶሳ ኤ ግሾ Ꮉይቂደ አꬃ ነ ሙእዘ ካꬅት ግሾ ꬋብስፐ። ");
INSERT INTO oyde_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ይኬ፥ ይንትስ የዘ ሎኦ ባዝቶ ጫዥዝፐተ። ");
INSERT INTO oyde_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ጾዘ ካእቱሞ ጌሽ አያናራ በንትዘ ጽሎተꬅ፥ ሳሮትꬅን ቱሪ ኡፋይሳፕ አትን ሙእዘ ባዝን ኡዥዘ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ይኒ ጋር ክርስቶሳስ ኦችዘ አስ ጾዝ ኡፋይሳነ፤ አስ ግዳን አንጅንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ይኒ ግሾ፥ አነ ኑኒ ሳሮትꬅ በንትዘ ኦገን ፈተ ፈታያ አማኖራ ምንꬅዘ ኦገ ኮዮተ። ");
INSERT INTO oyde_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ካꬃ ግሾ ጋእ ጾዘ ኦችቶ ላልፐ። ካꬃ ኡባ ጌሽ፥ የዝን መለ አስ ናጋራራ ꬉቢዘ ካꬃ ሙእዛና ኢታ። ");
INSERT INTO oyde_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ነ እሻይ ꬉቡንታመ ፋና አሾ ሞኦሳና ዎይ ኡሽ ኡዦሳና ዎይ ነ እሻይ ꬉቢዘ አኮ ባዝን ኦቾሳና ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ይኬ፥ ነ አማንቶ ነ ግዳን ነ ጾዘ ግዳ ናጎ። ልከ ጋእ ቆፕደባዝ ኦችዘ ዎደ ኤ ዎዝንታ ሞቶሰ አꬄ አንጅንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","የዝን ሶእተር ሙእዘ አꬄስ ኤ ሙእዘ አማኖራ ማቅካይዘ ግሾ ፍርድንታነ። አማኖ ባይዝን ኦችንትደ ኦቻ ኡባ ናጋራ። ");
INSERT INTO oyde_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ኑኒ ምንግዱንꬅ ላቢዱንꬅ ቶፍቶ ቶኮደስ ቤዛነ። ኑኒ ኑና ኡፋይሶደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ኑኒ ኑ ዶꬅዛ ምንꬅꬆደስ ማዶደስን ኡፋይሶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ክርስቶሳ ፋና ኡፋይስካያ። የዝን ጌሽ ማጻፍተ፥ «ነና ቦርደ ቦርታ ኑና የልዳ» ጋእንት ጻፍንትዳን ጋር Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ጌሽ ማጻፍተ እንግዘ ገንጮን ምንꬅራ ኑ ኡፋይስቶ ኤኮደ ፋና ጌሽ ማጻፍተ ጻፍንትደ ኡባና ኑና ታማርሶደስ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ገንጮን ምንꬅትሞ እንግዘ ላꬄ ይን ክርስቶስ የሱሳ ካልዘ ዎደ ፈተትꬅ ይንትስ እመ። ");
INSERT INTO oyde_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ይናን፥ ኑ ላꬄ የሱስ ክርስቶሳ አዳያ፥ ጾዛ፥ ፈተትꬃራን ፈቲ ቃላራ ይን ቦንቾደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ክርስቶሳ ይንታና ኤክዳን ፋና ጾዘ ቦንቾስ ፈታይ ፈታያ ኤኮተ። ");
INSERT INTO oyde_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ጾዚ ዛጋ አዱንꬅስ እንግደ ኡፋይስታ ፎልንቶደ ፋናን ኤ ቱረትꬅታ ኤርንቶደ ፋና ክርስቶሳ አይሁዱንꬅ ጋራዘ ዎጋ ፎለራ አሮ ማቂ ይእዳኖ ታ ይንትስ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ክርስቶሳ አይሁዱንꬅ ጋራዘ ዎጋ አሮ ማቅደ መለ ምክናታ ማህ አይሁደ ማቆሰ አሱንꬅ ጾዘ ማሮትꬅት ግሾ ጋላቶደ ፋና። ጌሽ ማጻፍተ፥ «ታ ነና አይሁደ ማቆሰ አሱንꬅ ግዳ ጋላቶዳ፤ ነ ሱንꬅቶ ማዝሙረር ሳቦዳ» ጋእንት ጻፍንትደ ጋር Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ማህ፥ «አይሁደ ማቆሰ አሱንꬆ፥ ጾዘ አሱንꬃራ ኡፋይቶተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ꮉተን ማህ፥ «አይሁደ ማቆሰ አሱንꬆ፥ ላꬃ ጋላቶተ፤ ዎርዣ ኡባ ኤዛ ሳቦተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ይኒ ጋር ኢሳያሳ፥ «እሰይ ኮቻፓ የልንትደ ፈታይ የኦዳ፤ ኤ ካእቱሞ ኡባ አሆዳ። ኡን ፋ ኡፋይስቶ ኤላ አፋ ጋዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ጌሽ አያና ዎልቃራ ይን ድጮደ ፋና ኡፋይስ እንግደ ጾዘ፥ ይን አማንቲ ባጋራ ይንትስ ኡፋይስን ሳሮትꬅ ኩሙꬅ እመ። ");
INSERT INTO oyde_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ታ እሹንꬆ፥ ይንታራ ሎኦትꬅን ኤራትꬅ ኩምዱንꬃና ማህ ፈታይ ፈታያ ዞሮደስ ዳንዳእዛኖ ታ ሎይꬂ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ታኒ ይንታና ፈቲ ፈትባዝ ቆፍሳደስ ኮይ ዣሽትካይዛራ ጾዘ አꬎ ኬሃትꬃራ ይንትስ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ታኒ ክርስቶስ የሱሳ አሮ ማቂ፥ አይሁደ ማቆሱንꬅስ ካህነ ፋና ማቂ፥ ዎንገለ ኦሆደ ፋና ጾዚ ታስ አꬎ ኬሃትꬅ እንግዳ። አይሁደ ማቆሰ አሱንꬅ ጌሽ አያናራ ጌዥ፥ ጾዝ ኡፋይስዘ ዣርሾ ማቆደ ፋና ጾዚ ይኖ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ታኒ ክርስቶስ የሱሳር ማቂ ታ ጾዘስ ኦችዘ ኦችተ ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","አይሁደ ማቆሰ አሱንꬅ ጾዝስ ኪትንቶደ ፋና፥ ክርስቶሳ ታ ቃልተን ታ ኦችት ባጋራ ኦችደ ኦችትፓ መለ ታ ጬቅንትዘ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ጾዚ ይኖ ክሌ ባዝ ኦቻራን ጌሽ አያና ዎልቃራ ዋይዝ ኦቼዛኮ ታ ይንትስ ኦሆዳ። ታኒ የሩሳላመፓ ደንꬂ፥ እልዋርቆነ የሎደስ ክርስቶሳ ዎንገለ ሳባክዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ታኒ መለ አስ ባስደ ባሳላ ኬጾደስ ኮዮስ። ክርስቶሳ ሱንꬅታ ጼግንትካይዘ በሳ ዎንገለ ኦሆደስ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ጌሽ ማጻፍተ፥ «ኤ ባዝ ኦህንትካይዘ አሱንꬅ ኤዛ በአዳ፤ ኤ ባዝ ስእካይዘ አሱንꬅ ቆፖዳ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ይኒ ምክናተራ፥ ታኒ ይንታጎ ዮኦደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","የዝን ታኒ Ꮉተ Ꮉና ጉቱቶ ኡባ ታ የሊ Ꮉስደ ግሾን ጋማ በረፓ ደንꬂ ይንታና በአደስ አሙꬍደ ግሾ ");
INSERT INTO oyde_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ታኒ እስፔነ Ꮉንግተራ ይንታና በአደስ ቆፕዳ። ማህ ኤራꬅ ዎደ ይንታራ ኡፋይትደፓ ሱባ እስፔነ Ꮉንግዘ ዎደ ይን ኦገስ ታና ማዶደ ፋና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","የዝን Ꮉተ ታኒ ጾዘ አሱንꬃና ማዶደስ የሩሳላመ Ꮉንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","መቀዶንያን አካያ ግዳ የዘ ጾዘ አሱንꬅ፥ የሩሳላመ የዘ ዳሁንꬃና ሚሸራ ማዶደስ ኮይደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ኡን ዳሁንꬃና ማድዛና ኡንትስ አቶሰባዝ ማቅደ ግሾ ፋ ኦምተ ይኖ ኦቾደስ ቆፋ አጭዳ። አይሁዱንꬃራ አይሁደ ማቅካይዙንꬅን አያና አንጆ ሻግንትኮ፥ ኡን ማህ ኡንትስ የዘ ባዛራ አይሁዱንꬃና ማዶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ይኒ ግሾ፥ ታኒ ይና ሺቅደ ሚሽቶ ኡንትስ እንግ ኡን ኤክዳኖ ኤርደፓ ሱባ እስፔነ Ꮉንግተራ ይን ካለራ አꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ታኒ ይንታጎ Ꮉንግዘ ዎደ ክርስቶሳ አንጆ ኩሙꬅ ኤኪ Ꮉንጎዳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ታ እሹንꬆ፥ ታስ ጾዝ ዎስተራ ታ ቡቱንተ ታራ ኤቆደ ፋና ላꬄ የሱስ ክርስቶሳራን ጌሽ አያና ሲቅተ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ጾዚ ታና ይሁዳ የዘ አማኖሰ አሱንꬃፓ አሾደ ፋና የሩሳላመ ታ ኦቾደ ኦችታ ጾዝ አሱንꬅ ካለ ኤክንቶደ ፋና ታስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ማህ ጾዚ ጋይኮ፥ ታኒ ይንታጎ Ꮉንግ ኡፋይሳራ ይንታራ ሸምፖደ ፋና ታስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ሳሮትꬅ ጾዘ ይን ኡቡንꬃራ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ክንክርያ ካታማ የዘ ዎሳ ኬꬅተ ኦችዘ ኑ ምሽታ ፌበኖ ሎኦ ማቾ ማቅዳኖ ይን ኤሮደ ፋና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ይን እዞ አማንዘ አሱንꬅ ላꬄ ሱንꬅተ ሞኮደስ ቤዝዘ አማንዘ አሱንꬃፓ ፈተ ፋና ሞኮተ። እዛ ይንታፓ ኮይዘ ባዝ ኡባ እዞ ማዶተ። እዛ ፋ ኦምተ ጋማ አስ ማድዳ፤ ማህ ታና ታ ኦምተ ጋማ ማድዳ። ");
INSERT INTO oyde_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ክርስቶስ የሱሳ ኦቻ ታራ ዎላ ኦችዘ ጵርስቅላን አቂላ ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ኡን ታ ግሾ ፋ ሸምፕቶ አꬂ እንግዳ። ታ ጻላላስ ባይዝን አይሁደ ማቆሰ አሱንꬅ ዎሳ ኬꬁንꬅን ኡባ ኡንታና ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ኡን ካራ ሺቅዘ አማንዙንꬅ ሳሮ ጋኦተ። እስያ ሳአ ክርስቶሳ ቲኖ አማንደ፥ ታ ካዽዘ ኤጳነጦሳስ ታ ሳርꬅቶ የልꬆተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ይኒ ግሾ ኦቻራ ጋማ ላቢደ ማይራሞ ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ታራ አች ኬꬃ የዝደ ታ አይሁደ ላጉንꬃና አንድሮንቆሳን ዩንያሳ ሳሮ ጋኦተ። ኡን የሱሳ ሐዋሩንꬅ ግዳ ኤርንትዱንꬃና። ማህ ኡን ክርስቶሳ ታፓ ቲኖ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ላꬄ አማንዘ ታ ሲቆ ላግዛ፥ አምጵልያጦሳ ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ክርስቶሳ ኦቻ ኑራ ዎላ ኦችዘ ኡርባኖሳን ታ ካዽዘ እስታኩሳ ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ክርስቶሳስ የዛና ፋታንንት አማንꬅዘ አጰሊሳ ሳሮ ጋኦተ። አርስጦቡሎሳ ካራ አሱንꬃና ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ታ አይሁደ ላግዛ ሄሮድዮና ሳሮ ጋኦተ። ናርስሳነን ኤ ካራ አሱንꬃፓ ክርስቶሳ አማንዱንꬃና ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ላꬄ ኦቻ ላቢዘ ትሩፋይናን ትሩፎሳ ሳሮ ጋኦተ። ማህ ላꬅስ ጋማ ላቢ ኦችዘ፥ ታ ካዽዘ ጰርሲሶ ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ላꬄ ኦቻራ ጋማ ኤርንትደ ሩፎሳስን ታና ፋ ናአ ፋና በእዘ ኤ እንቶ ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","አስንክርቶሳስ፥ ፍለጎናስ፥ ሄርሜሳስ፥ ፓትሮባሳስን ኡንታራ የዘ አማንዘ እሹንꬅ ኡቡንꬅስ ታ ሳርꬅቶ ኦሆተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ፍሎሎጉሳ፥ ዩልያ፥ ኔርያ፥ ኤ ምሽቶ፥ ኦሉምፖሳን ኡንታራ የዘ አማንዘ አሱንꬃና ኡባ ሳሮ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ጌሽ ዬርንተ ዬርንትተራ፥ ፈታይ ፈታያ ሳርꬆተ። ክርስቶሳ ዎሳ ኬꬂ ኡባ ይንታና ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ታ እሹንꬆ፥ ይን ታማርደ ትምርትቶ እጺ፥ ይን ግዳ ሻክንተን ማꬋ መꬍዘ አሱንꬃፓ ናግንቶተ። ኡንታፓ Ꮉኮተ። ");
INSERT INTO oyde_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ይኒ ፋና የዘ አሱንꬅ ፋ ሳዛስፕ አትን ኑ ላꬄ ክርስቶሳስ ኦቾስ። ፋ ማልእዘ ዶናራን ይቅስዘ ቃላራ አኮ ኤሮሰ አሱንꬅ ዎዝንቶ ባልꬃነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ዎንገለስ ይን ኪትንትዳኖ አስ ኡባ ስእደ ግሾ ታና ኡፋይሳነ። የዝን ይን ሎኦ ባዝ ኤሮደ ፋና ኢታ ባዛፓ Ꮉኮደ ፋና ታ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ሳሮትꬅ ጾዘ ጻላሄ ይን ቶህትፓ ኦሞራ ጋጪ ኦሎዳ። ኑ ላꬄ የሱስ ክርስቶሳ አꬎ ከሃትꬅታ ይንታራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ታራ ኦችዘ ጢሞትዮሳ ይንታና ሎኦ ያጋይዳ። ይኒ ጋራን፥ ታ እግኑንꬅ ሉቅዮሳ፥ ኢያሶነን ሶስጳጥሮሳ ይንታና ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ꮉይ ዳብዳቢዛ ጳዉሎሳስ ጻፍደ ታኒ፥ ጻርጽዮሳ፥ ይንታና ላꬄ ሱንꬅተ ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ታና ሞክዘ ዎሳ ኬꬅቶ ኡባ ኤ ካራ ሺቅዘ ጋዮሳ፥ ይንታና ሳሮ ጋይዳ። ካታማ ሚሸ አይክዘ ኤራስጾሳን ኑ እሸ ቃርጾሳ ይንታና ሳሮ ጋነ።  ");
INSERT INTO oyde_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ኑ ላꬄ የሱስ ክርስቶሳ አꬎ ኬሃትꬅ ይን ኡባራ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ጾዝስ ጋላታ ማቀ። ታኒ፥ የሱስ ክርስቶሳ ባዝ ኦህዘ ዎንገለ ቃልተ ጋማ ዎደፓ አችንት ጋምእደ ቱረትꬃራ፥ ጾዚ ይንታና አማኖራ ምንꬂ ኤሶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","የዝን Ꮉተ ይና ቱርታ ቆንጭዳ። ካእቱሞ ኡባ አማኒ ኪትንቶደ ፋና መዽና ጾዘ ኪተ ናቡንꬅ ይና ቱርትባዝ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","የሱስ ክርስቶሳ ባጋራ ጭንጫትꬅ ኤ ጻላላስ የዘ፥ ፈቲ ጾዘስ መꬍናስ ቦንቾ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ጾዘ ቆፋራ የሱስ ክርስቶሳ ሐዋረ ማቃደስ ጼግንትደ ጳዉሎሳን፥ ኑ እሸ ሶስተንሳ፥ ");
INSERT INTO oyde_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ቆሮንቶሳ የዘ ጾዘ ዎሳ ኬꬅትስ፥ የሱስ ክርስቶሳራ ጌዥዱንꬅስ ኡንትስን ኑስ ላꬂ ማቅደ ኑ ላꬄ የሱስ ክርስቶሳ ሱንꬅቶ ኡባ በሳ ጼግዘ ኡቡንꬅስ፤ ");
INSERT INTO oyde_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ጾዘ፥ ኑ አደፓን ላꬄ የሱስ ክርስቶሳፓ ይንትስ አꬎ ኬሃትꬅን ሳሮትꬅ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ጾዚ ክርስቶስ የሱሳ ባጋራ ይንትስ እንግደ አꬎ ኬሃትꬅት ግሾ ታኒ ኡባ ዎደ ጾዛ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ኡባ ባዛራ ኦሄራን ማቅን ኤራትꬃራ ክርስቶሳራ ዱርꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ኑ ክርስቶሳ ባዝ ኦህደ ማርካትꬅታ ይን ግዳ ምንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ይኒ ግሾ፥ ይን ኑ ላꬄ የሱስ ክርስቶሳ ቆንጭꬅቶ ናግተራ የዝኮ አኮ አያና እሞን ይንትስ ፋጮስ። ");
INSERT INTO oyde_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ኤዝን ማህ ኑ ላꬄ የሱስ ክርስቶሳ ላምእንꬃ የእተ ቦረ ባይዙንꬃና ማቂ ዉርሱꬅ የሎደ ጋር ይንታና ሚንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ፋ ናአይጎ፥ ኑ ላꬄ የሱስ ክርስቶሳ ፈተትꬃጎ ጼግደ ጾዘ አማንንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ታ እሹንꬆ፥ ይን ግዳ ሻክንተ የዝፐ፤ ኡቡንꬅ ጊጊ ፈቲ ዎዝናራን ፈቲ ቆፋራ ማቂ የዞተ፥ ያጋእ ኑ ላꬄ የሱስ ክርስቶሳ ሱንꬅተ ታ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ታ እሹንꬆ፥ ቀሎኤ ካራ አሱንꬅ ይን ግዳ ላሌ የዛኖ ታስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ይንታፓ ፈተ ፈተ፥ «ታኒ ጳዉሎሳስ፤ ታኒ አጵሎሳስ፤ ታኒ ጴጥሮሳስ፤ ታኒ ክርስቶሳስ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ዬዝን ክርስቶሳ ሻክንትዳነ? ይን ግሾ ማስቃላላ አፋ ሱጹንትደ ጳዉሎሳነ? ዎይ ይን ጳዉሎሳ ሱንꬅተ ጻማቅንትዳነ? ");
INSERT INTO oyde_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ታኒ ቃርስጶሳፓን ጋዮሳፓን መለ ይንታፓ ኦናን ጻማቅካይዘ ግሾ ጾዝ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ይኒ ግሾ፥ ኦደን ይንታና ታ ሱንꬅተ ጻማቅንትዳ ጋእ ኦሆደስ ዳንዳእዘ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ማህ እስጢፋኖሳ ካራ አሱንꬃና ታ ጻማቅዳ፥ ጉጂ መለ ኦና ጻማቀዛኮን ቲርንቶስ። ");
INSERT INTO oyde_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ክርስቶሳ ታና ኪትዳና ዎንገለ ኦሆደ ጋራፕ አትን ጻማቆደ ጋር ባያ። ክርስቶሳ ማስቃላ ጨር ማቃመ ጋር ዎንገለ ቃላ ታ ታማርስዛና አስ ጭንጫትꬅ ቃላራ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ማስቃላ ቃልታ ꬋብዙንꬅስ ኤያትꬅ፥ የዝን ኑስ አትዱንꬅስ ጾዘ ዎልቃ። ");
INSERT INTO oyde_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ጌሽ ማጻፍተ፥ «ታኒ ጭንጩንꬅ ጭንጫትꬅቶ ꬋብሶዳ፤ ኤሩንꬅ ኤራትꬅቶ ꬋብሶዳ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ዬዝን፥ ጭንጫ አባ የነ? ህገ አስታማርዘ አባ የነ? ዎይ Ꮉና አላመ ኤሩንꬅ አባ የነ? ጾዚ Ꮉና አላመ ጭንጫትꬅቶ ኤያትꬅ ማህካነ? ");
INSERT INTO oyde_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ꮉና አላመ አሱንꬅ ፋ ጭንጫትꬃራ ጾዛ ኤራመ ፋና ጾዚ ፋ ጭንጫትꬃራ ጎርድዳ፤ የዝን ኤያትꬃራ ፋይድንትዘ፥ ኑ ኦህዘ ዎንገለ ቃላ አማንዱንꬂ አቶደ ጋር ጾዘ ሎኦ ቆፋ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","አይሁዱንꬅ ክሌ ባዝ በአደስ ኮያነ፤ ማህ ግርኩንꬅ ጭንጫትꬅ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","የዝን ኑኒ ማስቃላላ አፋ ሱጹንትደ ክርስቶሳ ሳባካነ። ይና አይሁዱንꬅስ ꬉበ፤ ማህ ግርኩንꬅስ ኤያትꬅ። ");
INSERT INTO oyde_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","የዝን ጾዚ ጼግንትዱንꬅስ፥ አይሁደ ማቅን፥ ግርኬ ማቅን ክርስቶሳ ጾዘ ዎልቃን ጾዘ ጭንጫትꬅ። ");
INSERT INTO oyde_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ጾዘ ኤያትꬅታ አስ ጭንጫትꬃፓ አꬋነ፤ ማህ ጾዘ ቦዛትꬅታ አስ ጻላትꬃፓ አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ይኬ፥ ታ እሹንꬆ፥ ይን ጼግꬅቶ ቦኦተ፤ አስ ፋና ጭንጫ ማቅደ ጋሙንꬅ፥ ዎልቃራ የዘ ጋሙንꬅ፥ ሹማ ማቅደ ጋሙንꬅ ጼግንትካያ። ");
INSERT INTO oyde_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","የዝን ጾዚ ጭንጩንꬃና ዬልሳደስ አላመ የዘ ኤዩንꬃና ዶርዳ፤ ማህ ሚንꬁንꬃና ዬልሳደስ አላመ የዘ ቦዙንꬃና ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ጾዚ Ꮉና አላምተ ዳማ ጋእንትደባዝ ꬋብሶደስ፥ Ꮉና አላምተ ቦዙንꬃና፥ ለቂንትዱንꬃና አኮ Ꮉኖሱንꬃና ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ኦደን ጾዘ ቲኖ ጬቂንትፐ። የዝን ጬቅንትዘ ኦደን ጾዘላ ጨቅንቶ። ");
INSERT INTO oyde_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","የዝን ጾዚ ይንትስ ክርስቶስ የሱሳራ ፈተትꬃ የሳደ ጋር ዪዝዳ። ኤ ኑስ ጾዛፓ ጭንጫትꬅ፥ ጽሎትꬅ፥ ጌሻትꬅን ዎዞን ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ይኒ ግሾ፥ ጌሽ ማጻፍተ፥ «ጬቅንትዘ ኦደን ላꬃላ ጬቆ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ታ እሹንꬆ፥ ታኒ ይንታጎ ጾዘ ቃላ ይንትስ ኦህተራ ይእዘ ዎደ ቃላራን ጭንጫትꬃራ አꬊ ይእካያ። ");
INSERT INTO oyde_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ታኒ ይንታራ የዘ ዎደ የሱስ ክርስቶሳ ኤዝን ማስቃላላ አፋ ሱጹንትደፓ መለ ኤሮደስ ኮዮስ ጋእ ታ ቆፋ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ታ ይንታራ የዘ ዎደ ላብꬅሞራ፥ ዣሽሞራን ጋማ ጎቀራ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ታ ኦህታን ታ ሳባክታ ሳአ ኤራራን ዶና ጭንጫትꬃራ ማቅካይዝን ጾዘ ጌሽ አያና ዎልቃ ቆንጭꬅተ። ");
INSERT INTO oyde_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ይናን፥ ይን አማንታ ጾዘ ዎልቃራ ፋትን አስ ጭንጫትꬃላ ካታመ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","አያና ደኦ ድጭዱንꬅስ ኑኒ ጭንጫትꬅ ቃላራ ኦህነ። የዝን ይና ጭንጫትꬅታ፥ Ꮉና አላመ ጭንጫትꬅቶ ዎይ ꬋቦደስ የዘ Ꮉና አላምቶ አህዙንꬅ ጭንጫትꬅቶ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","የዝን ኑኒ ኦህዘ ጭንጫትꬅታ፥ ጋማ ዎደፓ ቲኖ ጾዚ ኑ ቦንቾስ ጊግዝዳኖን አችንት የዘ ጾዘ ጭንጫትꬅቶ። ");
INSERT INTO oyde_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ꮉና አላምቶ አህዙንꬃፓ ኦደን Ꮉና ጭንጫትꬅቶ ኤርካያ። ኡን ኤርዘባዝ ማቀዛኮ፥ ቦንቾ ላꬃ ማስቃላላ አፋ ሱጻማ የሻ። ");
INSERT INTO oyde_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","የዝን ጌሽ ማጻፍተ፥ «ኣፈ ብእካይዘ ባዝ፥ Ꮉየ ስእካይዘባዝ፥ ዎዝና ቆፕካይዘባዝ፥ ጾዚ ፋና ሲቅዙንꬅስ ጊግዝዳ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ኑስ ጾዚ ጌሽ አያና ባጋራ ቆንጭዝዳ። ጌሽ አያና መለ አቶ የዝን ጾዘ ጋꬅ ቆፋ ኡባ ቁርቻነ። ");
INSERT INTO oyde_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","አስ ግዳ የዘ ባዝ አꬄ ግዳ የዘ አያንዛ ፋትን አስ ባዝ ኦደን ኤሮስ። ይኒ ጋር፥ ጾዘ ባዝ ጾዘ አያና ፋትን ኦደን ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ጾዚ ኑስ Ꮉሪ እንግዳኖ ኑ ኤሮደ ጋር ጾዘ አያና ኤክዳ ፋትን Ꮉና አላምት አያና ኤክካያ። ");
INSERT INTO oyde_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ይኒ ግሾ ኑኒ አያና ቆፋ፥ አያና አሱንꬃና ታማርስዛና አስ ጭንጫትꬃራ ማቅካይዝን ጾዘ አያና እንግዘ ጭንጫትꬃራ። ");
INSERT INTO oyde_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","የዝን ጌሽ አያና ባይዘ አስ ጾዘ አያናፓ እንግንትዘ እሞ ኤኮደስ ዳንዳኦስ። ይና ኤስ ኤያትꬅ፤ ኡባና ጌሽ አያናራ ቁርችንትዛን ግሾ ኤ ኤሮደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","የዝን ጌሽ አያና የዘ አስ ኡባ ባዝ ቁርቻነ፥ የዝን ኤዛ ኦደን ቁርቾስ። ");
INSERT INTO oyde_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ጌሽ ማጻፍተ፥ «ላꬄ ዎዝንቶ ኤርዘ ኦደ? ኤዛ ዞሮደስ ዳንዳእዘ ኦደ?» ጋእንት ጻፍንትዳን ፋና። የዝን ኑስ ክርስቶሳ ዎዝና የነ። ");
INSERT INTO oyde_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ታ እሹንꬆ፥ ይን ክርስቶሳ ግዳ Ꮉጋ ዦጋን አማኖሰ አሱንꬅ ፋና የዘ ግሾ ታኒ አያናባዝ ይንትስ ኦሆደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ይን ምንꬅ ካꬃ ማደስ ዳንዳእካይዘ ግሾ ታኒ ይንታና ማꬅ ሽችዳ፤ Ꮉተን ማቅኮ ይን ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Ꮉተን Ꮉጋ ይን አሾ ቆፋራ የነ። ይን ግዳ የዘ ቃናተን ላለን ይን አማኖሰ አስ ፋና የዛኖ ኤርሶሳነ? ይን ኦችዛና አሾ ቆፋራ የዘ አስ ፋና ባነ? ");
INSERT INTO oyde_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ይንታፓ ፈተ፥ «ታኒ ጳዉሎሳስ» መሉንꬅ ማህ፥ «ታኒ አጵሎሳስ» ጋይኮ፥ ጾዝ አያና ባይዘ አስ ፋና ባነ? ");
INSERT INTO oyde_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ዬዝን፥ አጵሎሳ ኦደ? ጳዉሎሳ ኦደ? ኡን ይን አማኖደ ፋና ኦችደ ጾዘ ኦቻንቾ። ጾዚ ፈተስ ፈተስ እንግደ ኦችት ጋር ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ታ ቱክዳ፤ አጵሎሳ Ꮉꬅ ኡሽዳ፥ የዝን ድችደ ጾዚ። ");
INSERT INTO oyde_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ይኒ ግሾ፥ ድችደ ጾዛ ፋትን ቱክዘን Ꮉꬅ ኡሽዘን አኮን ባያ። ");
INSERT INTO oyde_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ቱክዘን Ꮉꬅ ኡሽዘን ዎላ ፈቶ፥ የዝን ፈተ ፈተ ፋ ኦቺ ላብዳን ጋር አንጆ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ኑኒ ጾዝስ ኦችዘ ጋደ፤ ጾዘ ኬꬃ ኤራ ዎላ ኦችዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ጾዚ ታስ እንግደ አꬎ ኬሃትꬅት ጋር ይላር የዘ አናጸ ፋና ባሳ ኦልዳ። መለ አስ ኤላ አፋ ኬጻነ። የዝን ኤላ አፋ ኬጽዘ ኦደን ዋይዝ ኬጽዛኮ፥ ፋስ ናግንቶ። ");
INSERT INTO oyde_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ፈቲ ቶሄ ኦልንትደ ባሳፓ መለ ኦደን ባሳ ኦሎደስ ዳንዳኦስ። ኤዝን የሱስ ክርስቶሳ። ");
INSERT INTO oyde_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","የዝን Ꮉይ ባስዘላ አፋ ኦደን ዎርቃራ ዎይ ብራራ ማቅን፥ አልኦ ሹቻራ ዎይ ምንጻራ ማቅን፥ ማታራ ዎይ Ꮉዉለራ ኬጽኮ፥ ");
INSERT INTO oyde_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ፈተ ፈተ የ ባስዘላ አፋ አኮራ ኬጽዛኮ ፍርዳ ዎደ ታማር ቆንጮዳ። ");
INSERT INTO oyde_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ኦደን የ ባስዘላ አፋ ኬጽደ ኬꬅታ ታማር ሙእንታንጽኮ፥ ፋ አንጅቶ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","የዝን ኦደ ኦችታን ታማር ሙእንትኮ፥ ቆህንቶዳ፤ የዝን፥ ኤ ፋ ኦምተ አቶዳን ታማፓ አትዛያ ማቆዳ። ");
INSERT INTO oyde_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ይን ጾዘ ኬꬅ ማቅዳኖን ጾዘ አያና ይንታራ የዛኖ ኤሮሳነ? ");
INSERT INTO oyde_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ኦደን ጾዘ ኬꬅቶ ላልኮ፥ ጾዝን ኤዛ ላሎዳ። ጾዘ ኬꬅታ ጌሽ፤ ይናን ይንታና። ");
INSERT INTO oyde_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ኦደን ፋና ጭምፐ። Ꮉና አላምተ ጭንጫ ፋና አዝዝደ የዝኮ ጾዘ ቱሪ ጭንጭቶ ደንጎደ ፋና ኦደን ጭንጫትꬅቶ ኤያትꬅ ማህ ፋይዶ። ");
INSERT INTO oyde_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Ꮉና አላምት ጭንጫትꬅታ ጾዘ ቲኖ ኤያትꬅ። ጌሽ ማጻፍተ፥ «ጾዚ ጭንጩንꬃና ኡን ገነ ኦችትራ አይክዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ማህ፥ «ጭንጩንꬅ ቆፍታ ማዶሰ ባዝ ማቅዳኖ ላꬂ ኤራነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ይኒ ግሾ፥ ኡባ ባዝ ይንትስ ማቃደ ግሾ ኦደን አሳላ ጬቅንትፐ። ");
INSERT INTO oyde_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ጳዉሎሳ ማቅን፥ አጵሎሳ ማቅን ጴጥሮሳ ማቅን፥ Ꮉና አላምቶ ማቅን፥ ደኦ ማቅን፥ Ꮉይቆ ማቅን፥ የዛያ ማቅን፥ ቲኖፓ የኦዳያ ማቅን፥ ኡባና ይንትስ። ");
INSERT INTO oyde_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ይንትን ክርስቶሳስ፤ ክርስቶሳን ጾዝስ። ");
INSERT INTO oyde_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ይኒ ፋና አስ ኑና ክርስቶሳ አሮ ፋና ጾዘ ጋꬅ ቆፋ ቆንጭዝ ታማርስዘ Ꮉዳራ እንግንትደ አስ ፋና ማህ ፋይዶ። ");
INSERT INTO oyde_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ታማርስዙንꬅ ላꬄስ አማንንትዱንꬃና ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","የዝን ይን ዎይ መሉንꬅ ታላ ፍርድኮ፥ ታስ አኮን ባያ። መለ አቶ፥ ታንን ታላ አፋ ፍርዶደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ታ ኤርዛን ጋር ማቅኮ ታ ዎዝንታ ታላ ፍርዶስ፥ የዝን ይናን ታ ጽሎትꬅቶ ቤዞስ። ታላ አፋ ፍርዶዳይ ላꬃ ጻላላ። ");
INSERT INTO oyde_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ይኒ ግሾ፥ ዎደ የልካይዝን፥ ላꬂ ይእካይዝን ኦደላን ፍርድፈተ። ኤ ꬉማ አችንትደ ባዝ ፎኦ ከሶዳ፤ አስ ዎዝና አችንትደ ቆፋ ቆንጭሳዳ። የ ዎደ ፈተ ፈተ ጾዘፓ ቤዝዘ ጋላታ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ታ እሹንꬆ፥ ይንታና ማዶ ጋእ ታናን አጵሎሳን አዝዘ ማህ ታ ኦህዳ። ይኖ ታ ዪዝዳና፥ «ጻፍንትዳንፓ ኣꬍፈተ» ያጋዘ ዞርቶ ይን ኑፓ ታማሮደ ፋና። ይኒ ግሾ፥ ኦደን ፈታ ናሺ Ꮉንካያ ለቆደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ኔኒ መሉንꬃፓ አኮራ አ? ኔኒ ኤክካይዘባዝ አኮ የዘ? ዬዝን፥ ኔኒ ኡባ ባዝ መለ አሳፓ ኤክደባዝ ማቅኮ፥ ኤክካይዘ አስ ፋና አኮስ ጬቅንተ? ");
INSERT INTO oyde_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ꮉተ ይን ምዥዳ። Ꮉተ ይን ዱርꬍዳ። ኑ ሻክንት ይን ጻላላ ካእትዳ። ይን ቱሮ ካእተዛኮ፥ ኑንን ይንታራ ካእቶድ የሻ። ");
INSERT INTO oyde_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ጾዚ ኑና ሐዋሩንꬃና፥ Ꮉይቆ ፍርድንትደ አስ ፋና አስ ኡባፓ ኑና ሱብ አꬅዳ ታስ አዛነ። ኑኒ Ꮉና አላምትስ፥ ኪታንቾስን አስስን ካስ ባዝ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ኑኒ ክርስቶሳ ግሾ ኤያ ማቅዳ፥ የዝን ይን ክርስቶሳ ግዳ ጭንጩንꬃና ማቅዳ። ኑኒ ቦዛ፥ የዝን ይን ምንꬅ ማቅዳ። ይን ቦንችንትዳ፥ የዝን ኑኒ ቶችንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Ꮉይኖ የሎደስ ኑ ናይꬋነ፥ ባርꬋነ፥ ካልꬋነ፥ Ꮉꬊንታነ፤ የሳደ ኬꬅ ꬋብን ማꬋ በእነ። ");
INSERT INTO oyde_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ኑኒ ኑ ኩሽተ ኦቺ አቃነ። ኑና አስ ጫዦደራ አንጃነ፤ ኑና ባይእዘ ዎደ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ኡን ኑና ጫዥዘ ዎደን ኑ ሱንꬅቶ ኢስዘ ዎደ አዳትꬃራ ማሀነ። ኑ Ꮉኖ የሎደስ አላመ ቡረን አላ ኦልንትደ ፍጾ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ታኒ ይኖ ጻፍዳና፥ ታ ካዽዘ ናኡንꬅ ፋና፥ ይንታና ዞሮደስ ጻፍዳ ፋትን ዬልሳደስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ክርስቶሳ ግዳ ይንታና ድችዘ ጋማ ካልꬅዙንꬅ የዝኮን፥ ይንትስ ጋማ አዱንꬅ ባያ። ታ ይንታና ክርስቶስ የሱሳ ዎንገለራ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ይኬ፥ ይን ታና አዞተ ጋእ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ይኒ ግሾ፥ አማንꬅዘን፥ ታ ካዽዘ፥ ላꬄ ባጋራ ታ ናአ ማቅደ፥ ጢሞትዮሳ ይንታጎ ኪትዳ። ኤ ዱማ ዱማ በሳ የዘ ዎሳ ኬꬃ ታ ታማርስደ፥ ክርስቶሳ የሱሳ ግዳ የዘ ታ ኦግቶ ይንታና ቆፍሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ታኒ ይንታጎ የአመ ፋና አዝን፥ ኡቱራራ ኩምደ ፈቲ ፈቲ አሱንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","የዝን ላꬂ ጋይኮ፥ ኡከራ ታኒ ይንታጎ ዮኦዳ። የ ዎደ ታኒ ኡቱራንቹንꬅ ኦህቶ ጻላላ ባይዝን ኡን ዎልቂቶን ኤሮደስ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ጾዘ ካእቱሞ ዎልቃራ ፋትን ኦሄራ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ታኒ ይንታጎ ጉፈራ ዮኦነነ ዎይ ሲቆራን አዳትꬅ አያናራ ዮኦነ? ይን አያ ዶረተ? ");
INSERT INTO oyde_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ይን ግዳ ኦላለ Ꮉንታ የዛና ዝግርንታነ። ይኒ ፋና የዘ ኦላለ Ꮉንታ መለ አቶ የዝን፥ አማኖሰ አሱንꬅን ኦቾስ። ይን ግዳ ፋ አዳይ ማችትራ ቱንደ አስ የነ። ");
INSERT INTO oyde_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ይነ ይን አዛኖደስን ዬልꬎደስ ቤዛነ፥ የዝን ይን ኡትርዳ። ይኒ ጋር ቦርስዘባዝ ኦችደ አꬃ ይን ግዳፓ ኬሶደስ ቤዞሶ? ");
INSERT INTO oyde_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ታኒ አሾራ ይንታራ የዛንጽኮን አያናራ ታ ይንታራ የነ። ታኒ ይንታራ የዘ አስ ፋና ዪእ ይኒ ጋርዘ ኦቻ ኦችደ አꬄላ ፍርድዳ። ");
INSERT INTO oyde_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ኑ ላꬄ የሱስ ክርስቶሳ ሱንꬅተ ይን ሺቅዘ ዎደ ታኒ አያናራ ይንታራ የሳዳ። ይነ ላꬄ የሱስ ክርስቶሳ ዎልቃ ይንታራ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","የ አꬄ ናጋራ አሽታ ꬋቢ፥ ኤ አያንዘ ላꬄ የሱሳ ፍርዳ ዎደ አቶደ ፋና ኤ ጻላሄስ አꬊ እንግንቶ። ");
INSERT INTO oyde_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ይን ጬቅታ ሎኦ ባያ። ኤራꬅ እርሾ ቡካ ኡባ ደንꬅዛኖ ኤሮሳነ? ");
INSERT INTO oyde_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ይን Ꮉተ እርሾ ባይዘ ቡካ ማቃደ ጋር፥ ናጋራ እርሾ ይንታፓ ከሶተ። ኑ ፋስጋ ዱሮ ማቅደ ክርስቶሳ ዣርሽንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ይኒ ግሾ፥ ገነን ኢታትꬅ የዘ እርሾራ ማቅካይዝን ቱረትꬅን ጌሻትꬅ የዘ ቦራራ ኑ ባልቶ ቦንቾዳ። ");
INSERT INTO oyde_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ታ ቲኖ ጻፍደ ኪትተ ይን ኦላለ አሱንꬃራ የልንታመ ጋር ይንትስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ይኖ ጋዛና Ꮉና አላምተ የዘ ኦላለ Ꮉንትዙንꬃና ዎይ ዣርꬍዙንꬃራ ዎይ ካይስትዙንꬃራ ዎይ ኤቃ ጎይንዙንꬃራ ሙሎ የልንትፐተ ጋኤ ባያ። ይኖ ማቅኮ፥ Ꮉና አላምትፓ ይን ኬሳደስ ቤዛነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","የዝን አማናነ ጋእተ ኦላለ Ꮉንትዙንꬃራ ዎይ ዣርꬍዙንꬃራ ዎይ ኤቃ ጎይንዙንꬃራ ዎይ ጫዥዙንꬃራ ዎይ ማꬅንትዙንꬃራ ዎይ ካይስትዙንꬃራ የልንትፐተ ጋእ ይንትስ ኦህነ። የንስ ጋርዘ አሳራ መለ አቶ የዝን፥ ካꬃን ሙእፐተ። ");
INSERT INTO oyde_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ዎሳ ኬꬃፓ ባለራ የዙንꬃላ አፋ ፍርዶደስ ታና አኮ ማ? ዎሳ ኬꬅተ የዙንꬃላ አፋ ይን ፍርዶሳነ? ");
INSERT INTO oyde_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","የዝን ባለራ የዙንꬃላ አፋ ጾዚ ፍርዶዳ። ይና ኢታ ባዝቶ ኦችዘ አꬃ ይን ግዳፓ ከሶተ። ");
INSERT INTO oyde_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ይን ግዳፓ ፈተ ፈተራ ሞቶ የዝኮ፥ ይኖ አማንዘ አስ ቲኖ ፍርድንቶዳኖ አሺ አማኖሰ አስ ቲኖ ፍርድንቶደስ ዋይዝ ቅተ? ");
INSERT INTO oyde_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ጌሹንꬅ አላመላ ፍርዶዳኖ ይን ኤሮሶ? ዬዝን፥ ይን አላመላ ፍርድዘባዝ ማቅኮ፥ Ꮉኒ ፋና ኤራꬅባዝ ፍርዶደስ ዋይዝ ዳንዳኦሶ? ");
INSERT INTO oyde_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ኑኒ ኪታንቾላ ፍርዶዳኖ ኤሮሳነ? ዬዝን፥ Ꮉና ሳአ የስ ባዛላ አፋ ፍርዶዳና ይንታና ዋይዝ ጋመ? ");
INSERT INTO oyde_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ዬዝን፥ ይኒ ፋና ሞቶ ይን ግዳ መꬍንትኮ፥ ዎሳ ኬꬃ ለቅንትደ አሱንꬅ ቲኖ ፍርድንቶደስ ዋይዝ ካንገተ? ");
INSERT INTO oyde_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ታኒ ይንታና ዬልሳደስ ይኖ ጋነ። ይን ግዳ ካጭንትደ አሱንꬃና ጊግሳደስ ዳንዳእዘ አካክዘ አስ ባ? ");
INSERT INTO oyde_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ዬዝን፥ ፈቲ አማንዛይ Ꮉንካይ አማንዛያ ፍርዳ ኬꬃ አማኖሰ አስ ቲኖ ሞቶደስ ቤዛነ? ");
INSERT INTO oyde_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ይኬ፥ ይን ፈተ ፈታ ካሳሲ ሞትዛና ይና ይንትስ ሎኦ ባያ። ይንፓ አꬊ ይን ቆህንትዛኮን ጭምንትዛኮ ሎኦሶ? ");
INSERT INTO oyde_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","የዝን ይንቲ ዎል ግዳ አማንዙንꬅ ፈተ ፈታ ቆሃነን ጭማነ። ");
INSERT INTO oyde_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ገኑንꬅ ጾዘ ካእቱሞ ገላማኖ ይን ኤሮሳነ? ይንታና ጭምፐተ፤ ኦላለ Ꮉንትዙንꬅ ዎይ ኤቃ ጎይንዙንꬅ ዎይ ቃይጽዙንꬅ ዎይ ꬊራꬅ ꬊራꬃራ ዎይእንትዙንꬅ፥ ");
INSERT INTO oyde_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ዎይ ካይስትዙንꬅ ዎይ ዣርꬍዙንꬅ ዎይ ማꬅንትዙንꬅ ዎይ ጫዥዙንꬅ ዎይ ቦንቅዙንꬅ ጾዘ ካእቱሞ ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ይንታፓ ፈቲ ፈቲ አሱንꬅ ቲኖ ይኒ ጋር። የዝን ይን Ꮉተ ላꬄ የሱስ ክርስቶሳ ሱንꬅተን ጾዝ አያናራ ሜጭንትዳ፤ ጌዥዳ፤ ጽልዳ። ");
INSERT INTO oyde_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ይን፥ «ኑ ኮይደባዝ ኦቾደስ ዳንዳአነ» ያጋነ። የዝን ኡባና ይንታና ማዶስ። ታኒ ኮይደባዝ ኡባ ኦቾደስ ዳንዳአነ፥ የዝን አኮን ታና አሆስ። ");
INSERT INTO oyde_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ይን፥ «ካꬃ ሳዛስ፤ ሳዛን ካꬃስ» ጋነ። የዝን ጾዚ ሳዝቶን ካꬅቶ ꬋብሶዳኖ ታ ይንትስ ኦህነ። ኑ ጋልታ ላꬅስ ፋትን ኦላለ Ꮉንታስ ባያ። ላꬅን ኑ ጋልትስ። ");
INSERT INTO oyde_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ጾዚ ላꬃ Ꮉይቆፓ ደንꬅዳን ፋና፥ ኑናን Ꮉይቆፓ ፋ ዎልቂትራ ደንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ይን ጋልታ ክርስቶሳ ጋላ ብልተ ማቅዳኖ ኤሮሳነ? ዬዝን፥ ታኒ ክርስቶሳ ጋላ ብልተ ማቅዳኖ ካንግ ኦላለ Ꮉንትዘ ጋላ ማቃደ ፋና ዪሳነ? ሙሎን ኮሾስ! ");
INSERT INTO oyde_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ኦላለ Ꮉንትዘ አꬄ ኤ የልንትዘ ማችትራ ፈቲ አሾ ማቅዛኖ ኤሮሳነ? ጌሽ ማጻፍተ፥ «ኡን ላምኡንꬅ ፈቲ አሾ ማቃዳ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","የዝን ላꬃራ ፈቶ ማቅዘ አꬄ ኤ አያንዘራ ፈቶ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ኦላለፓ Ꮉኮተ። ፈቲ አꬄ ኦችዘ መለ ናጋራ ኡባ ኤ ጋልትፓ ባለራ ኦችንታነ፥ የዝን ኦላልዘ አስ ፋ ጋልትላ አፋ ናጋራ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ይን ጋልታ ጾዚ ይንትስ እንግዳና ይንግዳ የዘ ጌሽ አያና ኬꬅ ማቅዳኖ ኤሮሳነ? ይን ይን ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ጾዚ ይንታና ሚሸራ ዎንግዳ። ይኒ ግሾ፥ ይን ጋልተ ጾዝ ቦንቾተ። ");
INSERT INTO oyde_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ይን ታስ ጻፍደ ኪትስ ማህታ Ꮉኖ። ፈቲ አስ ማቾ ቦችካይዛር የዝኮ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","የዝን ኦላለፓ አቶደስ ፈተስ ፈተስ ማቻ የሰ፤ ማህ ፈትስ ፈትስ አዝኒ የሰ። ");
INSERT INTO oyde_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","አዝንዘ ፋ ማችትስ፥ ማችታን ፋ አዝንዘስ ኮሽዘ ባዝ ኩንꬆ። ");
INSERT INTO oyde_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ማችትስ ፋ አሽትላ አፋ ኢስ አደትꬅ ዎልቃ ባያ፥ የዝን አደትꬅ ዎልቃ እ አዝንዘስ። ይኒ ፋና፥ አዝንዘስ ኤ አሽትላ አፋ አደትꬅ ዎልቃ ባያ፥ የዝን አደትꬅ ዎልቃ ማችትስ። ");
INSERT INTO oyde_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ይን ዎሳራ ኤራꬅ ዎደ ጋምኦደስ ዞረራ ማቃንጽኮ፥ ፈተ ፈታ ካይፐተ። ይኒ ግሾ ይን ይንታና አሆደስ ጋምን፥ ጻላሄ ይንታና ፋታናመ ጋር ዎላ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","የዝን ታኒ ይንታና ዞሮደስ Ꮉኖ ጋነ ፋትን ኪታ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","አስ ኡባ ታ ጋር ማቾ ኤክካይዛራ የዛኮ ካꬋነ፥ የዝን ጾዚ ፈተስ ፈተስ እንግደ ዱማ እሞ የነ። ፈተስ Ꮉኒ ፋና እሞ Ꮉንካይስ ይኒ ፋና እሞ የነ። ");
INSERT INTO oyde_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ማቾ ኤክካይዙንꬅስን አዝኒ ገልካይዙንꬅስን ማህ አዝኒ Ꮉይቂዱንꬅስ ታኒ ጋዛና፥ ታ ጋር ኤክካይዛራ ዎይ ገልካይዛራ የዞተ ጋእ ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","የዝን አሞራ ኤጽንትዛንፓ ኤክዛናን ገልዛና ሎኦ ማቅደ ግሾ ኡን ፋና አሆደስ ዳንዳአንጽኮ፥ ኤኮን ገሎ። ");
INSERT INTO oyde_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ታኒ ኤክዱንꬃናን ገልዱንꬃና Ꮉንጋራ ጋእ ዞራነ፤ ታና ባይዝን ላꬂ ኪታነ፤ ማችታ ፋ አዝንዘፓ ሻክንትፐ። ");
INSERT INTO oyde_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","የዝን ሻክንትኮ መለ አዝኒ ገልካይዛራ ፋስ የዞ ዎይ ፋ አዝንዘራ ጊጎ። አዝንዘ ፋ ማችቶ ብልፐ። ");
INSERT INTO oyde_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","የዝን መሉንꬅስ ላꬂ ባይዝን ታኒ Ꮉንጋራ ጋነ። አማኖሰ ማቻ የዘ አማንዘ አዝኒ የዝኮ፥ ኤ ማችታ ኤራ ፈትላ የሳደስ ኮይኮ እዞ ዳክፐ። ");
INSERT INTO oyde_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ማህ አማኖሰ አዝኒ የዘ አማንዘ ማቻ የዝኮ፥ እ አዝንዘ ኢራ ፈትላ የሳደስ ኮይኮ ኤፓ ዳክንትፐ። ");
INSERT INTO oyde_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","አማኖሰ አዝንዘ ፋ አማንዘ ማችት ባጋራ ጌዣነ፤ ማህ አማኖሰ ማችታ ፋ አማንዘ አዝንዘ ባጋራ ጌዣነ። ይና ባይዛኮ፥ ኡን ናኡንꬅ ቱና ማቃነ፥ የዝን Ꮉተ ኡን ጌሽ። ");
INSERT INTO oyde_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","የዝን አማኖሰ አዝንዘ ዎይ ማችታ ብሎደስ ኮይኮ ብሎ። አማንዘ ማቻ ዎይ አዝኒ ይኒ ጋርዘ ባዛራ አጭንቶስ። ጾዚ ኑና ሳሮራ የሳደ ጋር ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","አማንዘ ማችተ፥ ኔኒ አማኖሰ ነ አዝንዛ አሾድ የዛኮ አኮ ኤረ? ዎይ አማንዘ አዝንዛዮ፥ ኔኒ አማኖሰ ነ ማችቶ አሾድ የዛኮ አኮ ኤረ? ");
INSERT INTO oyde_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ፈቲ ፈቲ አስ ላꬂ ኤስ እንግደ እሞትꬅተ ጾዚ ኤዛ ጼግዳን ጋር የዞ። ዎሳ ኬꬃ ኡባ ታኒ ታማርስደ ዎግታ Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ኦደን ጋራዝንቲ አማንዳ ማቅኮ፥ ጋራዝንትካይዘ ፋና ይእፐ። ጋራዝንቲ አማንደ ኦደን የዝኮ፥ ጋራዝንቶደስ ኮይፐ። ");
INSERT INTO oyde_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ጾዘ ኪቶ ፎሎደስ ቤዛነ ፋትን ጋራዝንትን ጋራዝንታንጽ አሽን አኮን ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ፈቲ ፈቲ አስ ጾዚ ኤዛ ጼግዘ ዎድተ የዛን ፋና የዞ። ");
INSERT INTO oyde_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ጾዚ ነና ጼግደ ዎድተ ኔኒ አሮ? አኮ ባያ ይንስ ኡንእንትፐ። የዝን ኔኒ አሮትꬃፓ ዋሎ ኬሳደስ ዳንዳእኮ ኔፓ አትፐ ከዞ። ");
INSERT INTO oyde_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","አሮ ማቂ የዝተራ ላꬄ ግዳ ጼግንትደ አስ ላꬄ ግዳ አሮትꬃፓ ዋሎ ከዝዳ። ይኒ ጋር፥ አሮ ማቅካይዛራ የዝተራ፥ ላꬄ ግዳ ጼግንትደ አስ ክርስቶሳ አሮ። ");
INSERT INTO oyde_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ጾዚ ይንታና ሚሸራ ዎንግደ ግሾ አስ አሮ ማቅፐተ። ");
INSERT INTO oyde_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ታ እሹንꬆ፥ ይን ፈተ ፈተ ጼግንትደ ዎደ የዘ የስተ ጾዛራ ዎላ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ዉዱሩንꬅባዝ ላꬂ ታና ኪትደባዝ ባያ። የዝን ላꬂ ታስ እንግደ ማሮትꬅተ አማንንትዳያ ማቂ ታ ይንታና ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ይኬ፥ Ꮉተ ማꬍት ግሾ ኤክካይዛራ ዎይ ገልካይዛራ የሲ ታስ ሎኦ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ነ ማቾ ኤከዘባዝ ማቅኮ፥ ብሎደስ ኮይፐ። ነ ማቾ ኤክካይዘባዝ ማቅኮ፥ ኤኮደስ ኮይፐ። ");
INSERT INTO oyde_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","የዝን ነ ማቾ ኤክኮ ናጋራ ባያ። ይኒ ጋር ዉዱርታን አዝኒ ገልኮ ናጋራ ባያ። የዝን ኤክዘን ገልዘ አሱንꬅስ Ꮉና ሳእተ ጋማ ማꬋ የዘ ግሾ ይንቲ ይንፓ አቶደ ጋር ታ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ታ እሹንꬆ፥ ታ ጋዛና Ꮉኖ፤ ዎደ Ꮉልእዳ። ይኬፓ ቲኖ ማቻ የዘ ማቾ ኤክካይዘ ጋር የዞ። ");
INSERT INTO oyde_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ዬክዙንꬅ ዬኮሰ ጋር፥ ኡፋይትዙንꬅ ኡፋይቶሰ ጋር፥ ዎንግዙንꬅ አኮን ባይዙንꬅ ጋር ፋና ፋይዶ። ");
INSERT INTO oyde_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Ꮉና ሳአ ቆልተ ማድንትዙንꬅ ማድንቶሰ ፋና ዪእ የዞ። Ꮉና አላምት ብሽታ አꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ይን ይርጋ ባይꬅ የሳደ ጋር ታ ካꬋነ። ማቾ ኤክካይዘ ላꬃ ኡፋይሶደስ ኮይዘ ግሾ ላꬄ ባዝ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","የዝን ማቾ ኤክዳይ ፋ ማችቶ ኡፋይሶደስ ኮይዘ ግሾ Ꮉና ሳእትባዝ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ኤ ቆፍታ ላምእ በሳ ሻክንታነ። አዝኒ ገልካይዘ ዉዱርታ ፋ አሽተን ፋ ሸምፕተ ጌዥ ላꬃ ኡፋይሶደስ ኮይዘ ግሾ ላꬂ ባዝ ቆፓነ። የዝን አዝኒ ገልዳና ፋ አዝንዛ ኡፋይሶደስ ኮይዘ ግሾ ሳአባዝ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ታኒ ይኖ ይንትስ ኦህዛና፥ ይን ማድንቶደ ጋር ጋእ ፋትን ይንታና ኡንእꬆደስ ባያ። የዝን ይን ቆፍታ ሻክንትካይዝን ዎጋራ የዚ ላꬃ ኡፋይስዘ ባዝ ይን ኦቾደ ጋር ታኒ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ኦደን ፋ ኦጭደ ዉዱርትስ ገልዘ ዎደ አꬍዳ ጋእ እዞ አሾደስ ቆፕኮ፥ ይና ማህ ኢስ ሎኦ ማቆሳና ኤስ ስንትኮ፥ ፋ ኮይዳኖ ኦቾ፤ ኡን ኤኮን፥ ገሎን፤ ይነ ናጋራ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","የዝን ፈቲ አስ ኡንእꬅዘባዝ ꬋብን፥ ፋ ዎዝንተ ሚንግ፥ ፋና ናጊ፥ ፋ ኦጭደ ዉዱርቶ ኤካንጽ አሾደስ ኮይኮ ሎይꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ይኒ ግሾ፥ ዉዱርቶ ኤክዘ አꬄ ሎይꬅዳ፤ ማህ ኤኮሰ አꬄ ጋማ ሎይꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ማችታ ፋ አዝንዘ ፋጻ የዘ ዎደ ኡባ ኤራ አጭንትዳ። የዝን እ አዝንዘ Ꮉይቂኮ፥ ፋ ኮይደ አዝኒ ገሎደስ ዳንዳአነ። ማቆየዝን፥ እዛ ገልዘ ꬊራ አማንዘ አስ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ታ ቆፋ ማቅኮ፥ እዛ ገልካይዛራ የዝኮ ኡፋይሳራ የሳዳ። ማህ ታስን፥ ታራ ጾዘ አያና የዛ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ኤቃስ ዣርሽንትደ ካꬃባዝ ማቅኮ ኑ ኡቡንꬅስ ኤራ የነ። ኤራትꬅ ኡቱርሳነ፥ የዝን ሲቆ ድቻነ። ");
INSERT INTO oyde_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ኦደን ፋና ኤራነ ጋእ ቆፕኮ፥ ኤ Ꮉጋ ኤሮደስ ቤዛኖ ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","የዝን ኦደን ጾዝ ካꬍኮ ኤ ጾዘ ካለ ኤርንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ይኒ ግሾ፥ ኤቃስ ዣርሽንትደ ካꬃ ሙእዘ ባዝ ማቅኮ Ꮉና አላምተ ላꬂ ፈቲ ጾዘፓ ፋትን መለ ባይዘ ግሾ ኤቃ ፋꬆሰ ባዝ ማቅዳኖ ኑኒ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ጾዝ ማቅካይዝን ሳሎን ሳአን ጾዚ ጋእንት ጼግንትደ ጋማ ጾዙንꬅን ላꬁንꬅ የዝኮን፥ ");
INSERT INTO oyde_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ኡባ ባዝ መꬍደ፥ ኑ ኤ ባዝ ማቅደ፥ ፈቲ ጾዚ፥ አደ፥ ኑስ የነ። ኡቡንꬅ ኤ ባጋራ መꬍንትዳ፥ ኑንን ኤ ባጋራ ደኦ ደንግዳ ፈቲ ላꬂ፥ የሱስ ክርስቶሳ ኑስ የነ። ");
INSERT INTO oyde_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","የዝን Ꮉኖ ኤርዘ ኡባ ባያ። ፈቲ ፈቲ አሱንꬅ ኤቃ ጎይኖራ ኤርንትደ ግሾ ካꬃ ሙእዘ ዎደ ኤቃ ዣርሽንትደባዝ ማህ ኤካነ። የ ዎደ ኡን ዎዝንታ ቦዛ ማቅደ ግሾ ቱናነ። ");
INSERT INTO oyde_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","የዝን ካꬃ ኑና ጾዛራ እግንꬆስ። ኑ ሙእካይዛራ አሽን አኮን ቆህንቶስ፤ ማህ ሙእ ዱማ ማድንቶስ። ");
INSERT INTO oyde_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","የዝን ይን ኮይደባዝ ሞኦደስ ዋሎትꬅ ይንትስ የዝኮን ይና አማኖራ ሚንግካይዙንꬃና ꬉባመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ኔኒ ነና ኤራ ጋእ ኤቃ ዣርሽንትደ ካꬃ ሞኦደስ ኤቃ ኬꬃ በቴዝን፥ አማኖራ ሚንግካይዘ ነና ብእኮ ይና ኤዛ ኤቃስ ዣርሽንትደ ካꬃ ሞኦደ ጋር ደንꬅꬆሳ? ");
INSERT INTO oyde_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ይኬ፥ ነ ኤራትꬅት ባጋራ ክርስቶሳ ኤ ግሾ Ꮉይቂዳ፥ አማኖራ ሚንግካይዘ ነ እሸ፥ ꬋብዳ። ");
INSERT INTO oyde_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ይኒ ጋር ዪዚ፥ አማኖራ ሚንግካይዘ ይን እሹንꬃና ቆህተ ኡን ዎዝንቶ Ꮉርግዚ ክርስቶሳ ቆሃነ። ");
INSERT INTO oyde_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ይኒ ግሾ፥ ካꬃ ታ እሻ ꬉቢዘ ባዝ ማቅኮ፥ ኤ ꬉብንታመ ፋና አሾ ሙሎን ሞኦስ። ");
INSERT INTO oyde_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ታኒ ዋሎትꬃ የዘ አስ ባነ? ታ ሐዋረ ባነ? ታኒ ኑ ላꬃ የሱስ ክርስቶሳ ብእካ? ይን ላꬃራ ታ ዋየ ኣፈ ባነ? ");
INSERT INTO oyde_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ይን ላꬄ ባዝ ማቅደ ግሾ ታ መሉንꬅስ ሐዋረ ማቃንጽኮን፥ ይንትስ ሐዋረ ማቅዳንስ ይን ማርካ። ");
INSERT INTO oyde_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ታና ሐዋረ ባያ ጋዙንꬅስ ታ እንግዘ ማህታ Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ኑ ይንታፓ ሞኦደስን ኡሻደስን ቱሮ ኑስ አደትꬅ ዎልቃ ባ? ");
INSERT INTO oyde_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Ꮉንዛኮ ሐዋሩንꬅ ፋና፥ ላꬄ እሹንꬅ ፋናን ጴጥሮሳ ፋና፥ አማንዘ ኑ ማቹንꬃና ኤኪ የꬋደስ ኑስ አደትꬅ ዎልቃ ባ? ");
INSERT INTO oyde_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ዎይ ኦቺ ሞኦደስ ቤዝዘ ታናን ባርናባሳን ጻላላ? ");
INSERT INTO oyde_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ፋ ሚሸራ ዎታዳረትꬅ ኦችዘ ኦደ? ዎይ ዎይነ ቱኪ፥ እዝፓ ኣፈ ሞኦሰ ኦደ? ዎይ ዉደ የንግተራ፥ ይና ዉድትፓ ማꬅ ኡዦሰ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ታኒ ይኖ አስ ቆፋ ጋር ጋነነ? ህገ ይኖ ጋኦሳነ? ");
INSERT INTO oyde_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ሙሴ ህግተ፥ «ኡዱማ ካꬃ የꬍዘ ቦርዘ ዶንቶ አጭፐ» ጋእንት ጻፍንትዳ። ዬዝን ጾዚ ይኖ ቦራስ ቆፒ ጋይዳነ? ");
INSERT INTO oyde_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ጾዚ ይኖ ጋይዳና ኑስ ቆፒ ባነ? ዬ ኑ ግሾስ። ዎትዘን፥ ካꬃ ጌሽዘን ፋና የልዛኖ ኤኮዳ ጋእ ኡፋይሳራ ኦቾደስ ቤዛነ ጋእንት ቱሮ ኑ ግሾ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ኑኒ ይን ግዳ አያና ቡዱꬅ ቡደዘባዝ ማቅኮ አሾስ ቤዘባዝ ኑ ይንታፓ ኤክኮ፥ ይና ዳማ ባዞነ? ");
INSERT INTO oyde_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","መሉንꬅ ይኖ ይንታፓ ኤኮደስ ኡንትስ አደትꬅ ዎልቃ የዝኮ፥ ኑስ ኡንታፓ አꬍዘ አደትꬅ ዎልቃ የነ። የዝን ኑኒ ክርስቶሳ ዎንገለስ ꬉበ ማቃመ ጋር፥ ኡባነ ገንጫነ ፋትን ይና አደትꬅ ዎልቂትራ ማድንትካያ። ");
INSERT INTO oyde_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ጾዘ ኬꬃ ኦችዘ አሱንꬅ ፋ ካꬅቶ ጾዘ ኬꬃፓ ኤክዛኖ ኤሮሳነ? ማህ ዣርሾ በስተ ኦችዙንꬅ ዣርሽትፓ ኤክዛኖ ኤሮሳነ? ");
INSERT INTO oyde_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ይኒ ፋና፥ ዎንገለ ማርክꬍዙንꬅ የሲስ ኮሽዘ ባዝ ዎንገለፓ ኤኮደ ፋና ላꬂ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","የዝን ታኒ Ꮉና አደትꬅ ዎልቅቶ ኡባ አኮን ማድንትካያ። ታኒ Ꮉኖ ጻፍዳና ታ አደተꬅ ዎልቅቶ ቦንችሳደስ ኮይ ባያ። ኦደን ታ ጬቅቶ Ꮉሪ አሾዳንፓ Ꮉይቆ ታስ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ታኒ ዎንገለ ኦህዛና ታና ኪትደ ግሾ ፋትን ታና ጬቅዘባዝ ባያ። ዎንገለ ኦሃንጽኮ፥ ታና ባደ። ");
INSERT INTO oyde_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ታኒ ዎንገለ ካꬊ ሳባክኮ ታስ ዳሞዘ የነ። የዝን ታኒ ዎንገለ ካꬍካይዛራ ኪትን ሳባክዘባዝ ማቅኮ ይኖ ጾዚ ታስ Ꮉዳራ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ዬዝን፥ ታ ዳሞዝታ አኮ? ታኒ ዎንገለ ሳባክዘ ዎደ ታ አደትꬅ ዎልቃ ማድንትካይዛራ ዎንገለ Ꮉሪ ሳባክዛና ታስ ዳሞዘ። ");
INSERT INTO oyde_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ታኒ ኦደስን አሮ ማቆስ፥ የዝን ጋሙንꬃና ኮኦደስ ኡቡንꬅስ አሮ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ታኒ አይሁዱንꬅ አቶደ ፋና ኡንታራ ኡንታና ማቅዳ። ታ ኦምተ ህገፓ ኦሞራ የዞስ፥ የዝን ህገፓ ኦሞራ የዙንꬅ አቶደ ፋና ህገፓ ኦሞራ የዘ አስ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ጾዘ ህገፓ ባለራ ከዝካይዛራ፥ ክርስቶሳ ህግትስ ኪትንትተ፥ ህገ ባይዙንꬅ አቶደ ፋና ህገ ባይዘ አስ ፋና ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ታኒ አማኖራ ቦዙዱንꬅ አቶደ ፋና ቦዛ ማቅዳ። ታኒ ኤራꬁንꬅ አቶደ ፋና ኡንታር ኡንታና ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ታኒ ዎንገለ ማባራ አስ ማቃደስን አንጅቶ ሻክንቶደስ፥ Ꮉኖ ኡባ ዎንገለ ግሾ ዪዝዳ። ");
INSERT INTO oyde_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ጋልጋደ ዎꬂ ኡቡንꬅ ዎጻነ፥ የዝን ፈተ ጻላላ ሽልማተ ኤክዛኖ ኤሮሳነ? ይኒ ፋና ይንትን ሽልማቶ ኤኮደስ ዎጾተ። ");
INSERT INTO oyde_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ጋልጋደ አስ ኡቡንꬅ ኡባባዝተ ፋና አሃነ። ኡን ይኖ ላቢዛና ꬋብዘ ዎርቃ ዛዉደ ኤኮደስ። የዝን ኑኒ ላቢዛና መዽና ꬋቦሰ ዎርቃ ዛዉደ ኤኮደስ። ");
INSERT INTO oyde_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ይኒ ግሾ፥ ታኒ ቆፋ ባይዘ አስ ፋና ዎጾስ። ባቆ ዡልትዘ አስ ፋና Ꮉሪ ኩሸ ደንꬆስ። ");
INSERT INTO oyde_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ይኒ ግሾ ታኒ መሉንꬅስ ዎንገለ ሳባክዳንፓ ሱባ ታ ኦምተ ኦልንትደ አስ ማቃመ ፋና ታ አሽቶ ዎልቃራ አህ ታስ ኪትንቶደ ፋና ዪዛነ። ");
INSERT INTO oyde_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ታ እሹንꬆ፥ ታኒ ይን Ꮉኖ ቲሮደ ፋና ኮያነ። ኑ አዱንꬅ ኡቡንꬅ ꬎነፓ ዬካራ የꬍዳ፤ ኡቡንꬅ አባ ፊንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ኡን ሙሴራ ዎላ ማቃደስ ꬎነ ግዳን አባ ግዳ ጻማቅንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ኡን ኡቡንꬅ ፈቲ አያና ካꬃ ሙእዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ማህ ኡቡንꬅ ፈቲ አያና ኡሽ ኡዥዳ። ኡን ኡዥደን ኡንታና ካልተር የዘ የ አያና ላልዘፓ ኬዛያ፤ የ ላልዘን ክርስቶሳ። ");
INSERT INTO oyde_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","የዝን ጾዚ ኡንታፓ ጋምተ ኡፋይትካይዘ ግሾ ኡን አህታ አኮ ባይዘ ሳአ ዎꬊ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ኡን ኢታ ባዝ አሙꬍዳን ጋር፥ ኑንን ኢታ ባዝ አሙꬋአመ ጋር ይና ኡባና ኑስ አዝዘ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ጌሽ ማጻፍተ፥ «አሱንꬅ ሞኦደስን ኡሻደስን በትዳ፤ ማህ የጾደስ ደንድዳ» ጋእንትዳን ጋር ኡንታፓ ፈተ ፈተ ኤቃ ጎይንዳን ጋር ይን ኤቃ ጎይንፐተ። ");
INSERT INTO oyde_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ኡንታፓ ፈተ ፈተ ኦላልዳን ጋር ኑ ኦላሎደስ ቤዞስ። ይኒ ግሾ ኡንታፓ ፈቲ ዎደ ላምእታም Ꮉይꬕ ሙኩል አስ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ኡንታፓ ፈተ ፈተ ላꬃ ፋታን ሾሻራ ꬋእንት Ꮉይቂዳን ጋር ኑ ላꬃ ፋታኖደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ኡንታፓ ፈተ ፈተ ዙዝንጊ Ꮉይቆ ክእዘ ኪታንቾራ ꬋብዳን ጋራ ይንትን ዙዝንግፐተ። ");
INSERT INTO oyde_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Ꮉና ኡንታላ አፋ የልዳና ሙሎ ኑ ናግንቶደ ጋር ኑስ አዝዘ ማቅዳ። ማህ ዎደ ዉርሱꬃላ አፋ የዘ ኑስ ትምርተ ማቃደ ጋር Ꮉና ኡባ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ይኒ ግሾ፥ ታ ኤቅዳ ጋዘ ኦደን ጎልአመ ጋር ፋና ናጎ። ");
INSERT INTO oyde_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","አስ ኡባ የልዘ ፋታና ፋትን ዱማ ፋታና ይንታና የልካያ። ይን ዎልቅታ ዳንዳእዛንፓ አꬍዘ ፋታና ይን ፋታንንታመ ጋር አꬂ እንጎሰ ጾዘ አማንንትዳያ። ይንታና ፋታና የልዘ ዎደ ይና ፋታንቶ ኤ ይንታና ዳንዳእሳዳ። ማህ ይና ፋታንትፓ ይን ኬሳደ ኦግቶ ኤ ጊግሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ይኬ፥ ታ አልኦ እሹንꬆ፥ ኤቃ ጎይንዛንፓ Ꮉኮተ። ");
INSERT INTO oyde_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ይን ዎዝናማ አስ ማቅደ ግሾ ታ Ꮉኖ ኦህነ። ታኒ ጋዛና ቱሮ ማቅዳኖ ይን ይን ኦምተ ፍርዶተ። ");
INSERT INTO oyde_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ኑኒ ጾዝ ጋላቲ ግሽንትዘ አንጆ ጹእታ ክርስቶሳ ሱꬃራ ፈተትꬅ የዛኖ ባነ? ማህ ኑኒ ባጽዘ ዳብዘ ክርስቶሳ አሽትራ ፈተትꬅ የዛኖ ባነ? ");
INSERT INTO oyde_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ኑኒ ጋማ ማቅኮን ዳብዘ ፈቶ፥ ኑ የ ፈቲ ዳቦ ግሽንትዘ ግሾ ፈቲ አሾ። ");
INSERT INTO oyde_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","አነ እስራኤለ አሱንꬅ ኦችዳኖ ቆፖተ። ዣርሽንትደ ዣርሽታ ሙዙንꬅስ ዣርሾ በሳራ ፈተትꬅ ባነ? ");
INSERT INTO oyde_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ታኒ አኮ ጋኦደስ ኮይ ጋኤ? ኤቃስ ዣርሽንትደ ካꬅታ ዎይ ኤቃ ማድዘ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ኡን ዣርሽዛና ጾዝስ ማቅካይዝን ቱና አያናስ። ይኒ ግሾ፥ ይንትስ ቱና አያናራ ፈተትꬅ የሳደ ጋር ታ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ይን ላꬄ ጹእትፓ ኡዥተራ፥ ማህ ቱና አያና ጹእትፓ ኡሻደስ ዳንዳኦስ። ላꬄ ሌማትፓ ሙእተራ ማህ ቱና አያና ሌማትፓ ሞኦደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ኑ ይኖ ዪዚ ላꬃ ዥልሳነ? ኑ ኤፓ አꬍዘ ሚንꬆነ? ");
INSERT INTO oyde_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ይን፥ «ኡባ ባዝ ኦቻመ ጋር ካይዘባዝ ባያ» ጋነ፥ የዝኮን ኡባና ማዶስ። ይን፥ «ኡባ ባዝ ኦቻመ ጋር ካይዘባዝ ባያ» ጋነ፥ የዝን ኡባና ጻልዞስ። ");
INSERT INTO oyde_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ፈቲ ፈቲ አስ፥ መለ አስ ማድዘ ባዝ ቆፖደስ ቤዛነ ፋትን ፋና ማድዘ ባዝ ጻላላ ቆፕፐ። ");
INSERT INTO oyde_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ይን ዎዝንተ መꬍንትዘ ሶእቶ Ꮉሲ ጋበ ባይዝንትዘ አሾ ጨር ሞኦተ። ");
INSERT INTO oyde_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","አኮስ ጋይኮ፥ «ሳአን ሳአላ የዘ ኡባ ላꬅስ።» ");
INSERT INTO oyde_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ፈቲ አማኖሰ አስ ይንታና ሞኮደስ ኮይ ጼግኮ Ꮉማደስ ኮይኮ Ꮉንጎተ። ይን ዎዝንተ ሶእካይዛራ ይን ቲኖ አꬅዳኖ ኡባ ሞኦተ። ");
INSERT INTO oyde_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","የዝን ፈቲ አስ፥ «Ꮉና ኤቃስ ዣርሽንትደባዝ» ጋይኮ፥ የ ይንትስ ኦህደ አꬄ ግሾን ይን ዎዝንት ግሾ ይና ካꬅቶ ሙእፐተ። ");
INSERT INTO oyde_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ታኒ፥ ዎዝና ግሾ ጋዛና ይኖ ይንትስ ኦህደ አꬄ ዎዝንት ግሾ ፋትን ይን ዎዝንት ግሾ ባያ። መለ አስ ዎዝና ግሾ ጋእ ታኒ ታ ዋሎትꬃላ አኮስ ፍርዶደ? ");
INSERT INTO oyde_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ታኒ ሙእዘ ካꬅትስ ጾዝ ጋላቲ ሙእኮ አኮስ Ꮉልደ ፋና ጾዝ ጋላትዘ ባዛ ኦጭንተ? ");
INSERT INTO oyde_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ይኬ፥ ይን አኮ ሙእዛኮ አኮ ኡዥዛኮን፥ ዎይ አኮ ኦችዛኮ ኡባኖ ጾዘ ቦንቾስ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","አይሁዱንꬃና ማቅን ግርኩንꬃናን ማቅን ዎይ ጾዘ ዎሳ ኬꬅተ ማቅን ኦደስን ꬉበ ማቅፈተ። ");
INSERT INTO oyde_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ታኒ ኡባ ዎደ ጋሙንꬅ አቶደ ፋና ኡን ማድንቶደ ኦገ ኮያነ ፋትን ታና ማዶደ ኦገ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ታኒ ክርስቶሳ አዚ ካልዛንፋና፥ ይንትን ታና ካሎተ። ");
INSERT INTO oyde_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ይን ኡባ ባዛ ታና ቆፕዘ ግሾን ታ ታማርስደ ትምርትቶ ምንꬂ አይክደ ግሾ ታ ይንታና ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","የዝን ክርስቶሳ ꬊራꬅ ኡባስ ኦማ፥ ꬊራꬅ ማችስ ኦማ፥ ማህ ጾዚ ክርስቶሳስ ኦማ ማቅዳኖ ይን ኤሮደ ፋና ታ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ፋ ኦምቶ ጉሉንቲ ጾዝ ዎስዘ ዎይ ትንቢተ ኦህዘ ꬊራꬅ ኡባ ኦማ ማቅደ ክርስቶሳ ቶቻነ። ");
INSERT INTO oyde_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ፋ ኦምቶ ጉሉንትካይዛራ ጾዝ ዎስዘ ዎይ ትንቢተ ኦህዘ ማችታ ኦማ ማቅደ ፋ አዝንዛ ቶቻነ። ፋ ኦምቶ ጉሉንትካይዘ ማችታ ፋ ኦምቶ ሜድንትደ ማችት ፋና። ");
INSERT INTO oyde_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ማቻ ፋ ኦምቶ ጉሉንታንጽኮ፥ ፋ ኦምቶ ጩቅንቶ። የዝን ኢስ ኦምቶ ጩቂዛና ዎይ ሜድዛና ቦርስኮ ፋ ኦምቶ ጉልንቶ። ");
INSERT INTO oyde_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ꬊራꬅ ጾዝ አዚ ጾዘ ቦንቾ ማቅደ ግሾ ፋ ኦምቶ ጉልንቶደስ ቤዞስ፥ የዝን ማቻ ꬊራꬅ ቦንቾስ። ");
INSERT INTO oyde_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ማቻ ꬊራꬃፓ መꬍንትዳ ፋትን ꬊራꬅ ማችፓ መꬍንትካያ። ");
INSERT INTO oyde_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ማቻ ꬊራꬅስ መꬍንትዳ ፋትን ꬊራꬅ ማችስ መꬍንትካያ። ");
INSERT INTO oyde_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ꮉኒ ግሾን ኪታንቹንꬅ ግሾ ማቻ ፋስ አደትꬅ ዎልቃ የዛኖ ቤዝዘ ማላ ፋ ኦምቶ ጉሉንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","የዝን ላꬄ ቆፋራ ማቻ ꬊራꬅ ባይዝን የዞስ፤ ꬊራꬅን ማቻ ባይዝን የዞስ። ");
INSERT INTO oyde_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ማቻ ꬊራꬃፓ መꬍንትዳን ፋና ꬊራꬅን ማችፓ የልንትዳ። የዝን ኡቡንꬅን ጾዛፓ መꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","አነ ይን ፍርዶተ። ማቻ ፋ ኦምቶ ጉልንትካይዛራ ጾዝ ዎሶደስ ቤዛነ? ");
INSERT INTO oyde_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ꬊራꬅ ፋ ኦምቶ ድችኮ ኤስ ቦርሶ ማቅዳኖ መለ አቶ የዝን መትꬅ ይንታና ታማርሶሶ? ");
INSERT INTO oyde_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","የዝን ማቻ ፋ ኦምቶ ድችኮ ኢስ ቦንቾ ባነ? ማችስ ኦማ እንግንትዳና እዛ ፋና ካሞደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ይኒ ግሾ Ꮉንላ ላሎደስ ኮይዘ አስ የዝኮ፥ ኑስ ማቅን ዎይ ጾዘ ዎሳ ኬꬅስ ማቅን Ꮉንፋ መለ ዎጋ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ይን ፈትላ ሺቅዛና ሎኦስ ማቅካይዝን ቆሄስ ማቅደ ግሾ Ꮉተ ታ እንግዘ ኪተ ይንታና ናሾስ። ");
INSERT INTO oyde_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ታ ቲኖ ስእዳንና፥ ይን ዎሳ ኬꬅተ ሺቅዘ ዎደ ይን ግዳ ሻኮ የዛኖ። ይኖ ታ ስእዳንፓ ባግታ ቱሮ ማቅዳኖ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ይን ግዳ ፋ ኦችተ ቱሪ የዙንꬅ ኦና የዛኮ ኤርንቶደ ጋር ይን ግዳ ሻኮ የሳዳና አቶስ። ");
INSERT INTO oyde_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ይን ዎላ ሺቅዘ ዎደ ይን ሺቅዛና ላꬄ ካዎ ማደስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ይን ካꬃ ሙእዘ ዎደ ፈተ ፈታ ናግካይዛራ ፋስቶ ፋስቶ ሙእዘ ግሾ ፈታ ናያነ Ꮉንካይ ማህ ማꬅንታነ። ");
INSERT INTO oyde_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ቱሮ ይን ሞኦደስን ኡሻደስ ይንትስ ኬꬅ ባነ? ዎይ ጾዘ ዎሳ ኬꬅቶ ለቃነ? ዳሁንꬃና ዬልዛነ? ታ ይንታና ዋጎ? Ꮉንስ ታ ይንታና ናሾ? ሙሎን ናሾስ። ");
INSERT INTO oyde_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ታኒ ይንትስ እንግደ ትምርትቶ ላꬃፓ ኤክዳ። ላꬄ የሱሳ አꬊ እንግንትዘ ቃምተ ቦራ ኤኪ፥ ");
INSERT INTO oyde_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ጾዝ ጋላትዳ። ቦርቶ ባጽ «Ꮉተ፤ ሞኦተ። Ꮉና ይንትስ እንግንትደ ታ አሽቶ። Ꮉኖ ሙእተራ ታና ቆፖተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ይኒ ጋራ፥ ካዎ ሙእ ማቅን፥ ኡሽ ኤኪ፥ «Ꮉና ኡሽታ ታ ሱꬅተ ኤቅደ ክለ ጫቆ። ይን ኢፓ ኡዥደ ዎደ ኡባ ታና ቆፖተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ይን Ꮉይ ቦርዛ ሙእዘ ዎደን Ꮉና ኡሽቶ ኡዥዘ ዎደፓ ደንꬅ ላꬂ የኦደ ዎንꬅስ ኤ Ꮉይቅቶ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ይኒ ግሾ፥ ቤዞሰ ኦገራ ላꬄ ቦርቶ ሙእዘ ዎይ ላꬄ ኡሽቶ ኡዥዘ ኦደን ኤ አሽቶን ሱꬅቶን ቶችደ ግሾ ፋ ናጋርተ ኦጭንታነ። ");
INSERT INTO oyde_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ይኒ ግሾ አስ ፋና ፋታኖ። የይዝ ቦርቶ ሞኦ፤ ኡሽትፓን ኡዦ። ");
INSERT INTO oyde_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ላꬄ አሽትባዝ ሻኪ ኤሮሰ፥ ቦርትፓ ሙእዘን ኡሽትፓ ኡዥዘ፥ ፋላ አፋ ፍርዳ ሙነን ኡዣነ። ");
INSERT INTO oyde_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ይኒ ግሾ፥ ይን ግዳ ፋ ጋሙንꬅ ላቢዳ፤ Ꮉርግንትዳ፤ ማህ ኡንደና አሱንꬅ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","የዝን ኑ ኑና ፋታኒ በኤዛኮ፥ ኑላ አፋ ፍርድንታማ የሻ። ");
INSERT INTO oyde_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","አላመ ፍርድንትዘ ዎደ ኑ አላምትራ ፍርድንታመ ጋር Ꮉተ ላꬂ ኑና ካጫነ። ");
INSERT INTO oyde_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ይኒ ግሾ፥ ታ እሹንꬆ፥ ላꬄ ካዎ ማደስ ይን ሺቅዘ ዎደ ዎል የልꬅ ኤኮተ። ");
INSERT INTO oyde_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ይን ሺቅታ ፍርዳስ ማቃመ ጋር ናይꬍደ ኦደን የዝኮ፥ ፋ ካራ ሞኦ። አትደ ባዝቶ ታ እዘ Ꮉንግ ይንትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ታ እሹንꬆ፥ ጌሽ አያና እሞትꬅባዝ ይን ኤሮደ ፋና ታ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ይን ጾዝ አማኖሰ ዎደ ዶና ባይዘ ኤቁንꬃጎ ጎችንቲ፥ ይን ኤሮሰ ኦገ Ꮉንግዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ጾዘ አያና ካልꬅዘ አስ ኦደን፥ «የሱሳ ባድንቶ» ያጋኦስ። ማህ ጌሽ አያና ካልꬅካይዝን፥ ኦደን፥ «የሱሳ ላꬂ» ጋኦደስ ዳንዳኦሳኖ ይን ኤሮደ ፋና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ዱማ ዱማ አያና እሞትꬅ የነ፥ የዝን እሞትꬅቶ እንግዘ አያንዘ ፈቶ። ");
INSERT INTO oyde_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ኑ ላꬄስ ዱማ ዱማ ኦቻ የነ፥ የዝን ላꬄ ፈቶ። ");
INSERT INTO oyde_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ኑ ላꬄስ ኦችዘ ዱማ ዱማ ኦገ የነ፥ የዝን ይና ኦግተ አስ ኡባራ ኦችዘ ጾዘ ፈቶ። ");
INSERT INTO oyde_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","የዝን ፈተስ ፈተስ እንግንትደ እሞትꬅቶ መሉንꬃና ማዶደ ፋና ጌሽ አያና ቆንጫነ። ");
INSERT INTO oyde_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ጌሽ አያና ፈተስ ጭንጫትꬅ ኩምደ ቃላ እንጋነ፤ ማህ ፈተስ ኤራትꬅ ኩምደ ቃላ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","የ ጌሽ አያንዘ ፈተስ አማኖ፥ Ꮉንካይስ ማህ ፋꬅዘ እሞ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ጌሽ አያና ፈተስ ክለ ባዝ ኦችዘ እሞ፥ ፈተስ ትንቢተ ኦህዘ እሞ እንጋነ። ፈተስ አያናፓ አያና ሻኪ ኤርዘ ዎልቃ፥ ፈተስ ዱማ ዱማ ዶናራ ኦህዘ እሞ፥ ማህ ፈተስ ዱማ ዱማ ዶናራ ኦህንትዳኖ ብልዘ እሞ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ይኒ ግሾ Ꮉኖ ኡባ ኦችዘ የ ፈቲ ጌሽ አያንዛ። ኤ ኮይደ ፋና ፈተስ ፈተስ ዱማ ዱማ እሞ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ፈቲ ጋልተ ጋማ ብልተ የነ፥ የዝን ይና ዱማ ዱማ ብልቱንꬅ ፈቲ ጋላ። ይኒ ፋና፥ ክርስቶሳ ዱማ ዱማ ብልቱንꬅ የዘ ፈቲ ጋላ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ኑኒ አይሁደ ማቅን ግርኬ ማቅን አሮ ማቅን ዋሎ አስ ማቅን፥ ኡቡንꬅ ፈቲ ጋላ ማቃደስ ጌሽ አያናራ ጻማቅንትዳ። ማህ ኑ ኡቡንꬅ ፈቲ ጌሽ አያና ኡዥዳ። ");
INSERT INTO oyde_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ኑ ጋልተ ዱማ ዱማ ብልተ የነ ፋትን ፈቲ ጋላ ብልተ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ቶሄ፥ «ታኒ ኩሸ ማቆሰ ግሾ ብልተ ባያ» ጋይኮ፥ ኤ ይኖ ጋይደ ግሾ ብልተ ማቅዛና አቶዳነ? ");
INSERT INTO oyde_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Ꮉየ፥ «ታኒ ኣፈ ማቆሰ ግሾ ጋላ ብልተ ባያ» ጋይኮ፥ ኤ ይኖ ጋይደ ግሾ ጋላፓ ፈቲ ብልተ ማቅዛና አቶዳነ? ");
INSERT INTO oyde_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ጋላ ኡባ ኣፈ ጻላላ ማቅዛኮ፥ ኑ አኮራ ስኦደ? ማህ ጋላ ኡባ Ꮉየ ጻላላ ማቅዛኮ ኑ አኮራ ስንጎደ? ");
INSERT INTO oyde_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","የዝን ጾዚ ፋ ኮይዳን ጋራ፥ ጋላ ግዳ ዱማ ዱማ ብልቱንꬃና ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ኡቡንꬅ ፈቲ ብልተ ማቅዛኮ ጋላ ዋይዝ የሳደ? ");
INSERT INTO oyde_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","የዝን ብልቱንꬅ ጋማ ማቅኮን፥ ጋላ ፈቶ። ");
INSERT INTO oyde_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ኣፈ ኩሸጎ፥ «ነ ታስ ኮሾስ» ጋኦደስ ዳንዳኦስ። ዎይ ኦማ ቶሄጎ፥ «ነ ታስ ኮሾስ» ጋኦደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","የዝን ቦዛ አዝዘ ጋላ ብልቱንꬅ ኑስ አꬊ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ቦንቾ ኮሾስ ጋእ ኑ ቆፕዘ ብልቱንꬃፓ ባጉንꬃና ጋማ ቦንቻነ። ማህ ኑ ቦርስዘ ኑ ጋላ ብልቱንꬃና አꬂ ቦንቺ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","በአደራ ቦርሶሰ ጋላ ብልቱንꬅስ ቦንቾ ኮሾስ። የዝን ጾዚ ኑ ጋላ ብልቱንꬃና ዎል የልꬅ ቦርስዘ ብልቱንꬅስ አꬍዘ ቦንቾ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ጋላ ብልቱንꬅ ፈተ ፈተራ ሻኮ መꬍካይዛራ ዎልስ ቆፖደ ጋር ማህ መꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ጋላ ብልቱንꬃፓ ፈተ Ꮉርግንትኮ ብልቱንꬅ ኡባ ኤራ Ꮉርግንታነ። ጋላ ብልቱንꬃፓ ፈተ ቦንችንትኮ ብልቱንꬅ ኡባ ኤራ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ይን ኡቡንꬅ ክርስቶሳ ጋላ፤ ማህ ይን ፈተ ፈተ ኤ ብልተ። ");
INSERT INTO oyde_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ዎሳ ኬꬅተ ጾዚ፥ ቲኖ ሐዋሩንꬃና፥ ላምእንꬃ ናቡንꬃና፥ Ꮉይꬓንꬆ አስታማሩንꬃና፥ ማህ ክለ ባዝ ኦችዙንꬃና፥ ፋꬅዙንꬃና፥ መሉንꬃና ማድዙንꬃና፥ ዎሳ ኬꬃ አህዙንꬃና፥ ዱማ ዱማ ዶናራ ኦህዙንꬃና ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ኡቡንꬅ ሐዋረ? ኡቡንꬅ ናበ? ኡቡንꬅ አስታማረ? ኡቡንꬅ ክለ ባዝ ኦቻነ? ");
INSERT INTO oyde_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ኡቡንꬅስ ፋꬅዘ እሞ የነ? ኡቡንꬅ ዱማ ዱማ ዶናራ ኦህንታነ? ኡቡንꬅ ዱማ ዱማ ዶናራ ኦህዛኖ ብላነ? ");
INSERT INTO oyde_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ይኒ ግሾ ኡባፓ አꬍዘ እሞትꬅ ምንꬂ ኮዮተ። ማህ ኡባፓ አꬍዘ ኦግቶ ታ ይንታና ቤሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ታኒ አስ ቃላራን ኪታንቾ ቃላ ኦህንቶደስ ዳንዳእኮን፥ ታስ ሲቆ ꬋብኮ፥ ጨር ግርዘ ሉለ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ትንቢተ ኦህዘ እሞትꬅ ታስ የዝኮን፥ ጋꬅ ቆፋ ኡባ ኤርኮን፥ ኤራትꬅ ኡባ የዝኮን፥ ማህ ደረ ደንꬂ መለ በሳ ካንግዘ አማኖ ታስ የዝኮን፥ ሲቆ ꬋብኮ፥ ታና አኮን ማዶስ Ꮉር። ");
INSERT INTO oyde_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ታስ የዘ ባዝ ኡባ ዳሁንꬅስ እንግኮን፥ መለ አቶ የዝን፥ ታና ታማስ አꬂ እንግኮን፥ ሲቆ ꬋብኮ ታና አኮን ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ሲቆ ዳንዳአ። ሲቆ ኬሃ። ሲቆ ቃናቶስ። ሲቆ ጬቅንቶስ። ሲቆ ኡቱርቶስ። ");
INSERT INTO oyde_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ሲቆ ቤዞሰ ባዝ ኦቾስ። ሲቆ ቂርꬎስ። ሲቆ ዥልꬎስ። ሲቆ ፋ ቆህቶ ፋይዶስ። ");
INSERT INTO oyde_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ሲቆ ቱርራ ኡፋይታነ ፋትን ዎርዶራ ኡፋይቶስ። ");
INSERT INTO oyde_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ሲቆ ኡባ ዳንዳአነ፤ ኡባ አማናነ፤ ሎኦ ባዝ Ꮉኖዳ ጋእ፥ ኡፋይሳራ ናጋነ፤ ኡባ ገንጫነ። ");
INSERT INTO oyde_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ሲቆ ዉርሱꬅ የሎደስ ꬋቦስ። የዝን ትንቢተ አቶዳ፤ ዱማ ዱማ ዶናራ ኦህንትዛና አቶዳ፤ ኤራትꬅን አꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ኑ ኤራትꬃፓን ኤራꬅቶ ኤራነ፤ ትንቢተፓ ባግቶ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","የዝን ፎሎ ማቅደ የእዘ ዎደ ፎሎ ማቅካይዘ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ታኒ ናአ የዘ ዎደ ናአ ጋር ኦህነ፤ ናአ ጋር ቆፓነ፤ ናአ ጋር ቁርቻነ። ታ ዎዛንትደ ዎደ ናአትꬅ Ꮉንቶ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Ꮉተ ፎኦ ባይዘ በሳ ማስቶተራ በእዛንጋራ በእነ፥ የዝን የ ዎደ ኑ ጌሽ በአዳ። Ꮉተ ታ ኤራትꬃፓ ኤራꬅ ኤራነ፥ የዝን የ ዎደ ጾዚ ታና ኤርዛን ጋር ፎሊ ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ይኬ፥ አማኖ፥ ኡፋይስን ሲቆ፥ Ꮉንꬅ Ꮉይꬑንꬅ ሚንግ የሳዳ። የዝን Ꮉንሳፓ አꬍዘ ሲቆ። ");
INSERT INTO oyde_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ሲቆ ኮዮተ። አያና እሞትꬅ ምንꬂ ኮዮተ፤ ኡባፓ አꬂ፥ ትንቢተ እሞ ምንꬂ ኮዮተ። ");
INSERT INTO oyde_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ዱማ ዱማ ዶናራ ኦህንትዘ አስ ጾዝስ ኦህነ ፋትን አስስ ኦሆስ። የዝን አስስ በንትካይዘ ጋንጨ ቆፋ አያና ዎልቃራ ኦህዘ ግሾ ኦደን ኤ ኦህዛኖ ቲሮስ። ");
INSERT INTO oyde_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","የዝን ትንቢተ ኦህዙንꬅ አስ አያናር ድቾደስ፥ ምንꬅꬆደስን ምንꬆደስ አስስ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ዱማ ዱማ ዶናራ ኦህዘ አስ ፋና አያናር ድቻነ። የዝን ትንቢተ ኦህዘ አስ ዎሳ ኬꬅቶ አያናር ድቻነ። ");
INSERT INTO oyde_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ይን ኡቡንꬅ ዱማ ዱማ ዶናራ ኦህንትዛኮ ታ ካꬋነ፥ የዝን ትንቢተ ኦህዛኖ አꬂ ካꬋነ። ዱማ ዱማ ዶናራ ኦህንትዛኖ ዎሳ ኬꬂ ድቾደስ ብልዘ አስ ꬋብኮ፥ ዱማ ዱማ ዶናራ ኦህንትዛንፋ ትንቢተ ኦህዛና አꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ይኬ ታ እሹንꬆ፥ ታኒ ይንታጎ Ꮉንግ ቆንጭꬃራ ዎይ ኤራትꬃራ ዎይ ትንቢተ ኦሄራ ዎይ ትምርተራ ማቃንጽ ዱማ ዱማ ዶናራ ኦህንትኮ ይንታና አኮ ማዶደ? ");
INSERT INTO oyde_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ዱማ ዱማ የꬅስ ፈቲ ኮች ኦꬅ የዝኮ፥ ሱሉንቀ ኦꬅን ዲꬅ ኦꬅ ዋይዝ ሻጊ ኤሮደ? ");
INSERT INTO oyde_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ማህ ሞይዘ ኦለ ሎይꬂ ኤርንታንጽኮ ኦላስ ጊግንቶደ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ይኒ ጋር፥ ዱማ ዱማ ዶናራ ይን ኦህዛና ጌሽ ማቃንጽኮ ይን ኦህዛኖ ኦደ ኤሮደ? ይና ባቆስ ኦህዘ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","አላመላ ጋማ ዶና የነ፤ ብልꬂ ባይዘ ዶና ባያ። ");
INSERT INTO oyde_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ይኬ ፈቲ አስ ኦህንትዘ ዶና ታኒ ኤራንጽኮ ኤ ታስ ዛቆ ማቃነ፤ ታንን ኤስ ዛቆ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ይኒ ጋር፥ ጌሽ አያና እሞ ይን ኤኮደስ ምንꬂ ኮይዛኮ፥ ዎሳ ኬꬂ ድቾደስ ኡባፓ አꬍዘ እሞትꬅ ኮዮተ። ");
INSERT INTO oyde_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ዱማ ዱማ ዶናራ ኦህዘ አሱንꬅ ኦህቶ ብሎደስ ብልዘ እሞትꬅ እንግንቶደ ጋር ጾዝ ዎሶ። ");
INSERT INTO oyde_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ታኒ ዱማ ዱማ ዶናራ ጾዝ ዎስኮ፥ ታ አያንዘ ዎሳነ፥ የዝን ታ ቆፍትፓ አኮን ሻኪ ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ዬዝን፥ ታ አኮ ኦቾደስ ቤዘ? ታኒ ታ አያንተ ዎሳነ፤ ታ ዎዝንተን ዎሳነ። ታኒ ታ አያንተ የጻነ፤ ታ ዎዝንተን የጻነ። ");
INSERT INTO oyde_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ይኖ ማቃንጽኮ ኔኒ ነ አያንተ ጾዝ ጋላትዘ ዎደ ይና በስተ ኔኒ ጋዛኖ ኤሮሰ አስ ነ ጋላትዛኖ ዋጊ፥ «አምንኤ» ጋዉደ? ");
INSERT INTO oyde_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ኔኒ ጾዝ ጋላትዛና ሎኦ፥ የዝን መለ አስ ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ታ ይን ኡባፓ አꬂ ዱማ ዱማ ዶናራ ኦህዛን ግሾ ጾዝ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","የዝን ታኒ ዎሳ ኬꬃ መሉንꬃና ታማርሶደስ ዱማ ዱማ ዶናራ ታጵ ሙኩል ቃላ ኦሆዳንፓ ኤርንትዘ ዶናራ እችን ቃላ ኦህዛኖ ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ታ እሹንꬆ፥ ይን ቆፋራ ናአ ፋና ማቅፐተ። ይን ኢታባዝስ ናአ ፋና ማቆተ ፋትን ይን ቆፋራ ዎዝናሙንꬃና ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ላꬂ፥ ጌሽ ማጻፍተ፥ «ታኒ Ꮉንꬅ አሱንꬅስ፥ ዱማ ዱማ ዶናራ ኦህዘ አስን ዛቆ እልአንꬃራ ኦህዘ አሳራ ኦሆዳ። የዝን ይኖ ማቅኮን ታና ስኦስ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ይኬ፥ ዱማ ዱማ ዶናራ ኦህዛና፥ አማኖሰ አሱንꬅስ ማላ ማቃነ ፋትን አማንዘ አስስ ባያ። ትንቢተ አማንዘ አስስ ማላ ማቃነ ፋትን አማኖሰ አሱንꬅስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ዎሳ ኬꬃ አሱንꬅ ፈትላ ሺቅዘ ዎደ ኡቡንꬅ ዱማ ዱማ ዶናራ ኦህንትኮ ኤሮሰ ዎይ አማኖሰ አሱንꬅ ይን ሺቅተ ይእ፥ «Ꮉንስ ዣሽታነ» ጋኦሳነ? ");
INSERT INTO oyde_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","የዝን ኤሮሰ ዎይ አማኖሰ አሱንꬅ ዎሳ ኬꬃ የእዘ ዎደ አሱንꬅ ትንቢተ ኦሆደራ፥ ስእኮ ፋ ናጋርቶ ቲሮዳ፤ ማህ ኤ ስእደ ቃልተ ፍርድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ኡን ኤ ዎዝንተ ጌንግደ ቆፍቶ ቆንጭሳዳ። ይኒ ጋር፥ «ቱሪ ጾዚ ይን ግዳ የነ» ያጋእ ማርክꬊ፥ ዙጊ ጾዝስ ጎይኖዳ። ");
INSERT INTO oyde_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ታ እሹንꬆ፥ ኑ አኮ ጋኦ? ይን ዎላ ሺቅዘ ዎደ ፈተስ ማዝሙረ የነ፤ ፈተስ ታማርሰ እሞትꬅ የነ፤ ፈተስ ቆንጭꬅ የነ፤ ፈተስ ዱማ ዱማ ዶናራ ኦህዘ እሞትꬅ የነ፤ ፈተስ ብልዘ እሞትꬅ የነ። ይና ኡባ ዎሳ ኬꬂ ድችዘባዝ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ዱማ ዱማ ዶናራ ኦህዘ አሱንꬅ የዝኮ፥ ላምእ ዎይ ጋንግኮ Ꮉይꬕ ማቂ ታራር ታራር ኦሆደስ ቤዛነ። ኡን ኦህዛኖ መለ አስ ብሎ። ");
INSERT INTO oyde_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","የዝን ብልዘ አስ ꬋብኮ፥ ዱማ ዱማ ዶናራ ኦህዘ ዎሳ ኬꬅተ ስእ ጋኦ። ፋስን ፋ ጾዘስን ኦሆ። ");
INSERT INTO oyde_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ትንቢተ ኦህዙንꬅ ላምእ ዎይ Ꮉይꬕ ማቂ ኦሆ። ማህ መሉንꬅ ኡን ጋዛኖ ሻጎ። ");
INSERT INTO oyde_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ይና ሺቅተ የዘ መለ አስስ ፈትባዝ ቆንጭኮ ቲኖ ኦህዘ ስእ ጋኦ። ");
INSERT INTO oyde_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ኡቡንꬅ ታማሮደ ጋራን ኡቡንꬅ ምንጎደ ጋር ታራር ታራር ትንቢተ ኦሆደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ናቡንꬅ አያና ናቡንꬅስ ኪትንታነ። ");
INSERT INTO oyde_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ጌሹንꬅ ዎሳ ኬꬃ ኡባ ላማድንትዳን ጋር ጾዚ ሳሮትꬅ ጾዝ ፋትን ዋጫምዘ ጾዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ማቻ ዎሳ ኬꬃ ስእ ጋኦ። ሙሴ ህገ ጋዛን ፋና ኡን አቆ ፋትን ዎሳ ኬꬃ ኦሆደስ ኡንትስ አደትꬅ ዎልቃ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ማቹንꬅ ዎሳ ኬꬃ ኦህዛና ቦርስዘባዝ ማቅደ ግሾ ፈትባዝ ኤሮደስ ኮይኮ ካራ ፋ አዝኑንꬃና ኦጮ። ");
INSERT INTO oyde_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ጾዘ ቃላ ቲኖ ይን ክእዳነ? ዎይ ጾዘ ቃላ ይን ጻላላጎ ይእዳነ? ");
INSERT INTO oyde_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ኦደን ፋና ናበ ዎይ ፋና ጾዘ አስ ጋእ ቆፕኮ፥ ታኒ ይንትስ ጻፍዛና ላꬄ ኪታ ማቅዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ይኒ ግሾ ኦደን ኤካንጽኮ ኑንን ኤዛ ኤኮስ። ");
INSERT INTO oyde_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ይኒ ግሾ፥ ታ እሹንꬆ፥ ትንቢተ ኦሆደስ ምንꬂ አሙꬎተ፤ ማህ ዱማ ዱማ ዶናራ ኦህዛኖ ካይፐተ። ");
INSERT INTO oyde_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","የዝን ኡባናን ዎጋራን ታራር ማቀ። ");
INSERT INTO oyde_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ታ እሹንꬆ፥ ታ ይንትስ ማርክꬍደ ዎንገለ ይን ኤክዳነ ይን አማንተ ኤ ግዳ ኤቅዳኖ ይን ቆፖደ ጋር ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ታ ታማርስደ ዎንገለ ምንꬂ አይክኮ ይን ኤ ግዳ አቶዳ። ይኖ ይአንጽኮ ይን አማንታ Ꮉሪ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ታኒ ኤክደ ኡባፓ አꬍዘ ኪታ ቲንꬊ ይንትስ እንግዳ። ይናን፥ ጌሽ ማጻፍተ ጋዛን ጋራ፥ ክርስቶሳ ኑ ናጋርት ግሾ Ꮉይቂዳ፤ ");
INSERT INTO oyde_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ሞግንትዳ፤ ጌሽ ማጻፍተ ጋዛን ጋራ፥ Ꮉይꬕንꬃ ቃማ Ꮉይቆፓ ደንድዳ፤ ");
INSERT INTO oyde_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ጴጥሮሳስ በንትዳ፤ ይንፓ ሱባ፥ ታጶ ላምእ ሐዋሩንꬅስ በንትዳ፤ ");
INSERT INTO oyde_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ይንፓ ሱባ፥ እችን ጼታፓ ጋንግዘ አሱንꬅስ ፈቲ ቶሄ በንትዳ፤ ኡንታፓ አꬍዘ ባግታ Ꮉተ የሎደስ ፋጻ የነ፥ የዝን ኤራꬁንꬅ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ይንፓ ሱባ፥ ያይቆባስ በንትዳ፤ ሱባፓ ፋ ሐዋሩንꬅስ ኡቡንꬅስ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ማህ ዉርሱꬅተ ቦችንትደ ጋር የዘ ታስ ቆንጭዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ታኒ የሱሳ ሐዋሩንꬅ ኡባፓ ላፋ። ታኒ ጾዘ ዎሳ ኬꬃ ባይእደ ግሾ የሱሳ ሐዋረ ጋእንት ጼግንቶደስ ቤዞሳያ። ");
INSERT INTO oyde_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","የዝን ጾዘ አꬎ ኬሃትꬅተ ታ Ꮉተ የዛን ጋር ማቅዳ፤ ኤ ታስ እንግደ አꬎ ኬሃትꬅት Ꮉሪ አትካያ። ታኒ መሉንꬅ ሐዋሩንꬃፓ አꬊ ላቢዳ። የዝን ታራ የዘ ጾዘ አꬎ ኬሃትꬅትራ ፋትን ታና ባያ። ");
INSERT INTO oyde_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ይኬ፥ ታና ማቅን ኡንትን፥ ኑ ኡባይ ታማርስዛና ይኖ፤ ይንትን ይና ኪቶ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ክርስቶሳ Ꮉይቆፓ ደንድዳኖ ኑ ሳባክዘ ዎደ ይንታፓ ፈተ ፈተ ዬዝን፥ ዋይዝ፥ «Ꮉይቆፓ ደንዶ ባያ» ያጋኤ? ");
INSERT INTO oyde_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Ꮉይቆፓ ደንዶ ባይዘ ባዝ ማቅኮ ክርስቶሳ Ꮉይቆፓ ደንድካያ ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ክርስቶሳ Ꮉይቆፓ ደንድካይዘ ባዝ ማቅኮ ኑ ትምርትታን ማቅን ይን አማንታን Ꮉሪ። ");
INSERT INTO oyde_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Ꮉይቆፓ ደንዶ ባይዝን፥ ኑኒ ጾዚ፥ «ክርስቶሳ Ꮉይቆፓ ደንꬅዝዳ» ያጋእ ሳባክተራ ጾዘ ዎርዳንቾ ማርካ ማቅዳ ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Ꮉይቂደ አሱንꬅ Ꮉይቆፓ ደንድካይዘ ባዝ ማቅኮ ይኬ፥ ክርስቶሳ Ꮉይቆፓ ደንድካያ። ");
INSERT INTO oyde_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ክርስቶሳ Ꮉይቆፓ ደንዶሰ ባዝ ማቅኮ፥ ይን አማንታ Ꮉሪ፤ ማህ ይን Ꮉይኖ የሎደስ ይን ናጋራራ የነ። ");
INSERT INTO oyde_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ይኬ፥ ክርስቶሳ አማኒ Ꮉይቂዱንꬅን ꬋብዳ ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ኑኒ Ꮉና አላምተ ደኦ ጻላላስ ክርስቶሳ ግዳ ኡፋይስ ኦችደባዝ ማቅኮ፥ Ꮉና አላምተ የዘ አስ ኡባፓ ኑ ባዝታ አꬍደ ኢታ። ");
INSERT INTO oyde_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","የዝን ክርስቶሳ Ꮉይቂዱንꬅስ Ꮉይቆፓ ደንደራ አንግስ ማቂ ቱሮ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Ꮉይቆ ፈቲ አስ ባጋራ Ꮉና አላምተ ይእዳን ጋር Ꮉይቆፓ ደንዶን ፈቲ አስ ባጋራ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","አዳማ ባጋራ አስ ኡባ Ꮉይቂዳን ጋራ ክርስቶሳ ባጋራ አስ ኡባ ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","የዝን ፈተ ፈተ ፋ ታራር ደንዶዳ። ክርስቶሳ ኡባፓ ቲኒ ደንድዳ፤ ይንፓ ሱባ፥ ክርስቶሳ የእዘ ዎደ ኤሱንꬅ ደንዶዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ይንፓ ሱባ፥ ክርስቶሳ ካእቱሞ፥ አደትꬅን ዎልቃ ኡባ ꬋብሲ፥ ካእቱሞ ጾዘ አደስ እንጎደራ ዎደ ዉርሱꬅ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ጾዚ ኤ ሞርኩንꬃና ኡባ ኤ ቶህትፓ ኦሞራ የꬍሳደ ዎንꬅስ ክርስቶሳ አሆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ዉርሱꬅተ ኤ ꬋብሶደስ የዘ ሞርክዘስ Ꮉይቆ። ");
INSERT INTO oyde_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ጌሽ ማጻፍተ፥ «ጾዚ ኡባ ባዝ ኤ አደትꬅ ዎልቃፓ ኦሞራ አህዛነ» ጋእንት ጻፍንትዳ። የዝን ኡባ ኤ አደትꬅ ዎልቃፓ ኦሞራ አሃነ ጋዛና፥ ኡባባዝቶ ኤ አደትꬅ ዎልቃፓ ኦሞራ አህደ ጾዛ አዳያ ጉጆስ። ");
INSERT INTO oyde_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ኡባ ባዝታ ክርስቶሳ አደትꬅ ዎልቃፓ ኦሞራ አቅዳንፓ ሱባ ጾዘ አደስ ኡባና ማቃደ ፋና ክርስቶሳ ማህ ፋ ኦምተ ኡባ ባዝ ጾዝስ አቅዝዳ። የ ዎደ ጾዚ ፋ ጻላላ ኡባ አሆዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Ꮉይቂዱንꬅ ደንዶሰ ባዝ ማቅኮ ኡን ግሾ ጻማቅንትዘ አሱንꬅስ አኮ ትርፈ የዘ? Ꮉይቂዱንꬅ ደንዶሰ ባዝ ማቅኮ ዬዝን፥ አኮስ፥ አሱንꬅ Ꮉይቂዱንꬅ ግሾ ጻማቅንተ? ");
INSERT INTO oyde_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ዬዝን፥ ኑኒ አኮስ ኡባ ዎደ ኑና ማꬋስ አꬂ እንገ? ");
INSERT INTO oyde_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ታ እሹንꬆ፥ ታ ቃምተ ቃምተ Ꮉይቆስ አꬊ እንግንታነ። ይናን፥ ላꬄ ክርስቶስ የሱሳ ባጋራ ይንታላ የዘ ጬቅታ ቱሮ ማቅደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","አስ ቆፋ ጋር ማቅኮ፥ ታኒ ኤፈሶነ ግዳ ጾꬃራ ቡቱንትዳና ታና አኮ ማዶደ? Ꮉይቂዱንꬅ Ꮉይቆፓ ደንዶሰ ባዝ ማቅኮ፥ «ዎንታ ኑ Ꮉይቅዘ ግሾ Ꮉይኖ ማዳ ኡሻዳ» ያጋዘ አስ ፋና ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ጭምንትፐተ! ኢታ ላገትꬅ ሎኦ ዱሰ ኢሳነ። ");
INSERT INTO oyde_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ይን ዎዝንትጎ ማቆተ። ናጋራ ኦችፐተ። ይንታፓ ፈቲ ፈቲ አሱንꬅ ጾዝ ኤሮስ። ታ ይንታና ዬልሳደስ ይኖ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ፈቲ አስ፥ «Ꮉይቂደ አስ ዋይዝ ደንዶደ? ኡን አኮ ፋና የዘ ጋላራ የኦደ?» ያጋእ ኦጭዘ የዝካይዛራ አቶስ። ");
INSERT INTO oyde_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Ꮉይ ኤይዛዮ፥ ኔኒ ሳአላ ቡድዘ ቡዱꬅታ Ꮉይቂካይዛራ ዶሎስ። ");
INSERT INTO oyde_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ኔኒ ቡድዘ ዛርጋ ማቅን ዎይ መለ ካꬃ ኮች ኣፈ ፋትን ሱባፓ ዶልዘ ዶልቶ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","የዝን ጾዚ ቡዱꬅስ ፋ ካꬍደ ጋር ጋላ እንጋነ። ዱማ ዱማ ቡዱꬅስ ዱማ ዱማ ጋላ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","መꬎ ኡባስ አሾ ፈቶ ባያ። አስ አሾ ፈቶ፤ Ꮉርስ አሾ ዱማ፤ ላንዳ አሾ ዱማ፤ ማቂ ሞሎ አሾ ዱማ። ");
INSERT INTO oyde_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ሳሎ ጋላ የነ፤ ማህ ሳአ ጋላን የነ። የዝን ሳሎ ጋላስ ቦንችታ ፈቶ፤ ማቂ ሳአ ጋላስ ቦንችታን ዱማ። ");
INSERT INTO oyde_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","አዋ ቦንቾ ፈቶ፤ አግና ቦንቾ ዱማ፤ ጾልንቶ ቦንቾ ዱማ፤ ፈቲ ጾልንትዘ Ꮉንካይ ጾልንትዘፓ ቦንቾራ ዱሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Ꮉይቂዱንꬅ Ꮉይቆፓ ደንድዘ ዎደ ይኒ ጋራ ይአዳ። Ꮉይቅዘ ጋላ ቡዱንታነ፤ Ꮉይቆሰ ጋላ ማቂ ደንዶዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ቶቸራ ቡዱንቲ፥ ቦንቾራ ደንዶዳ፤ ላብꬅሞር ቡዱንቲ፥ ዎልቃራ ደንዶዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","መትꬅ ጋላ ቡዱንቲ፥ አያና ጋላ ማቂ ደንዶዳ። መꬎ ጋላ የዝኮ፥ አያና ጋላ የነ። ");
INSERT INTO oyde_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ይኒ ጋር፥ ጌሽ ማጻፍተ፥ «ቲኖ አꬄ፥ አዳማ፥ ፋጻ የዘ መꬎ ማቅዳ» ያጋይዳ። የዝን ዉርሱꬅ አዳማ፥ ክርስቶሳ፥ ደኦ እንግዘ አያና ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","የዝን መትꬅ አስ ቲኖ ይእን፥ ሱባፓ አያና አስ ይእዳ ፋትን አያና አስ ቲኖ ይእካያ። ");
INSERT INTO oyde_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ቲኖ አዳማ ሳአፓ መꬍንትደ ሳአ አስ፤ ላምእንꬃ አዳማ ሳሎፓ ይእደ ሳሎ አስ። ");
INSERT INTO oyde_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ሳአፓ መꬍንትዱንꬅ ሳአፓ መꬍንትዳያ አዛነ። ሳሎፓ ማቅዱንꬅ ሳሎፓ ይእዳያ አዛነ። ");
INSERT INTO oyde_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ኑኒ ሳአፓ መꬍንትደ አꬃ አዛን ፋና ሳሎፓ ይእደ አꬃን አዞዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ታ እሹንꬆ፥ ታ ጋዛና Ꮉኖ፤ Ꮉተ ኑ ማእደ ጋልታ ጾዘ ካእቱሞ ገሎደስ ዳንዳኦስ። ዎቅዘ ጋልታ ዎቆሰ ጋላ ላቶስ። ");
INSERT INTO oyde_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ታ ይንትስ ፈቲ ጋንጨ ቆፋ ኦሆዳ። ኑ ኡቡንꬅ Ꮉይቆስ፥ የዝን ዉርሱꬅተ ኡቡንꬅ ላምንቶዳ፤ ");
INSERT INTO oyde_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ሞይዘ ኦልንትዘ ዎደ ኣፈ ቅጵ በአደስ ቆፕካይዝን ላምንቶዳ። Ꮉይቂደ አሱንꬅ ዎቆሰ አስ ማቂ ደንዶዳ፤ ኑንን ላምንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Ꮉይ ዎቂዛይ ዎቆሳያ፥ Ꮉይ Ꮉይቅዘ Ꮉይቆሳያ ማኦደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Ꮉይ ዎቂዛይ ዎቆሳያ፥ ማቂ Ꮉይ Ꮉይቅዘ Ꮉይቆሳያ ማእዘ ዎደ ጌሽ ማጻፍተ፥ «Ꮉይቆ ጋምንቲ ቆꬍንትዳ። ጋዘ ቃልታ ፎልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ይኒ ጋር፥ «Ꮉይቆ፥ ነ ጋምዛና አባ የነ? Ꮉይቆ፥ ነ ጫድዘ ዎልቅታ አባ የነ?» ጋይደ ቃልታ ፎልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Ꮉይቆ ጫድዘ ዎልቃ ናጋራ፤ ማህ ናጋራ ዎልቃ ህገ። ");
INSERT INTO oyde_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","የዝን ኑ ላꬄ የሱስ ክርስቶሳ ባጋራ ኑስ ጋመ እንግዘ ጾዘስ ጋላታ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ይኒ ግሾ፥ ታ ሲቆ እሹንꬆ፥ ኤንእንታንጽ ሚንግ ኤቆተ። ላꬄ ኦችተ ይን ላቢዛና ጨር ባይዛኖ ኤሪ ኡባ ዎደ ላꬄ ኦችቶ አዛልእካይዛራ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","አማንዘ አሱንꬅስ ሚሸ ሺሸባዝ ጋላትያ ዎሳ ኬꬅስ ታኒ ኪትዳን ፋና ይንትን ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ሚሸ ሺሽታ ታ ይንታጎ Ꮉንግዘ ዎደ ማቃመ ፋና ፈቲ ፈቲ ሳምንታፓ ቲኖ ቃማ፥ ዎጋ ዎደ ዎጋ ዎደ ፋ ደንግዛንፓ ኬሲ ፋ ካራ ሺሾ። ");
INSERT INTO oyde_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ታኒ እዘ Ꮉንግደ ዎደ ሚሽቶ የሩሳላመ የልꬆደ ፋና ይን ዶርደ አሱንꬅስ ዳብዳበ እንግ ኡንታና የሩሳላመ ኪቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ኡንታራ ታ Ꮉንግዛና ኮሽዘ ባዝ ማቅኮ ኡን ታራ Ꮉማደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ታኒ መቀዶንያራ አꬎደስ ቆፕደ ግሾ እዘ Ꮉንግ ይንታጎ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ታ Ꮉንግዛና አባ ማቅኮን፥ ታ ቅትዛነ ይን ታና ሞይዞደ ጋር ይን ካለ ኤራꬅ ዎደ ጋምእካይዛራ አሾስ። ሴተ አግኑንꬃና ይን ካለ አꬅካይዛራ ዋይ አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ታኒ ኦገራ አꬍተራ ይንታና በአደስ ኮዮስ። ላꬂ ጋይኮ፥ ይን ካለ ኤራꬅ ዎደ ጋምኦደስ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","የዝን ታኒ ጰንጠቆስጠ ባአለ የሎደስ ኤፈሶነ ጋምኦዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ታስ ኦቻ ኩምደ ዳልጋ ፉርꬅ ቡጉንትዳ፥ የዝን ጋማ ኦልንትዘ ሞርኩንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ኤ ታ ጋር ላꬄ ኦቻ ኦችዘ አስ ማቅደ ግሾ ጢሞትዮሳ ይንታጎ Ꮉንግኮ፥ ይን ካለ ኤ ይርግካይዛራ የሳደ ጋር ዪዞተ። ");
INSERT INTO oyde_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ኦደን ኤዛ ለቂፐ። ኤ ታጎ ሳሮራ ማቃደ ጋር ኤዛ ማዲ ሞይዞተ። ታኒ ኤ Ꮉንኩꬅ አማንዙንꬃራ ማቃዳኖ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ኑ እሸ አጵሎሳ Ꮉንኩንꬅ አማንዙንꬃራ ይንታጎ Ꮉማደ ጋር ታ ኤዛ ምንꬂ ዎሳነ። Ꮉተ ይንታጎ Ꮉማደስ ኮይካያ፥ የዝን ኤስ ዎትደ ዎደ ይንታጎ Ꮉማዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ባርኮተ፤ አማኖራ ኤቆተ፤ ጻሎተ፤ ምንጎተ። ");
INSERT INTO oyde_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ኦችቶ ኡባ ሲቆራ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ታ እሹንꬆ፥ እስጢፋኖሳን ኤ ካራ አሱንꬅ አካያ ግዳ ኡን ቲኖ አማንዱንꬃና ማቅዳኖ አማንዙንꬃና ማዶደስ ፋና አꬂ እንግዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ይንትን ኡን ጋር አሱንꬅስን፥ ኡንታራ ኦቻራ ላቢዘ ኡቡንꬅስ ኪትንቶደ ጋር ታ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","እስጢፋኖሳ፥ ፈርዶናጽሳን አካይቆሳ ታጎ ይእዳና ታና ኡፋይስዳ። ይን ባይዘ በስተ ኡን ይንታና ማቂ ታ ፋጭቶ ኩንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ኡን ይንታና ኡፋይስዳን ፋና ታናን ኡፋይስዳ። ይኒ ፋና አሱንꬃና ቦትፈተ። ");
INSERT INTO oyde_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","እስያ ዎሳ ኬꬃ አሱንꬅ ይንታና ሳሮ ጋነ። አቂላን ጵርስቅላን ፋ ካራ ሺቅዘ ዎሳ ኬꬃ አሱንꬃራ ዎላ ይንታና ላꬄ ሱንꬅተ ዎዝናፓ ሳሮꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","አማንዘ እሹንꬅ ኡቡንꬅ ይንታና ሳሮ ያጋይዳ። ጌሽ ዬርንተ ዬርንትተራ ፈተ ፈታ ሳሮꬆተ። ");
INSERT INTO oyde_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ታኒ፥ ጳዉሎሳ፥ Ꮉና ሳሮትꬅቶ ታ ኩሽትራ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ላꬃ ካꬎኦሰ አስ የዝኮ፥ ባድንትዳያ ማቀ። ኑ ላꬃዮ፥ ዮኦ! ");
INSERT INTO oyde_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ላꬄ የሱስ ክርስቶሳ አꬎ ከሃትꬅታ ይንታራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ታ ሲቅታ ክርስቶስ የሱሳ ግዳ የዘ ይን ኡቡንꬃራ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ጾዘ ቆፋራ የሱስ ክርስቶሳ ሐዋረ ማቅደ ጳዉሎሳን፥ ኑ እሸ ጢሞትዮሳ፥ ቆሮንቶሳ ግዳ የዘ ጾዘ ዎሳ ኬꬅትስን አካያ ጋደ የዘ ጾዘ አስ ኡቡንꬅስ ጻፍደ ኪታ። ");
INSERT INTO oyde_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ጾዘ ኑ አደፓን ላꬄ የሱስ ክርስቶሳፓ፥ አꬎ ኬሃትꬅን ሳሮትꬅ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ማሮትꬅ አደስ፥ ኡባ ዎደ ኑና ምንꬅꬅዘ ጾዘስ፥ ኑ ላꬄ የሱስ ክርስቶሳ አደስ ጋላታ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ጾዚ ኑስ እንግደ ምንꬅꬅተ፥ ማꬋ የዙንꬃና ኑ ምንꬅꬆደ ፋና ጾዚ ኑና ኑ ማꬍተ ኡባ ምንꬅꬃነ። ");
INSERT INTO oyde_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ኑኒ ክርስቶሳራ ጋማ ማꬍተ ሻክንትዳን ጋራ ማህ ኑኒ ኤ ጋማ ምንꬅꬅተ ምንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ኑኒ ማꬋ ኤክኮ ይና ይንታና ምንꬅꬆደስን ይንታና አሾደስ። ማህ ኑኒ ሚንግኮ ኑኒ ገንጭደ ማꬍት ፋና ይንትን ገንጭ፥ ጾዚ ይንትስ እንግዘ ምንꬅꬅተ ምንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ይን ኑ ኤክደ ማꬍት ጋር ኤኪ፥ ኑ ምንꬅꬅተ ሻክንቶዳኖ ኑ ኤርዘ ግሾ ኑ ኡፋይስታ ይን ግዳ ምንꬅ። ");
INSERT INTO oyde_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ኑ እሹንꬆ፥ እስያ ጋደ ኑና የልደ ማꬍቶ ይን ኤሮደ ጋር ኮያነ። ይና ኑና የልደ ማꬍታ ኑ ዎልቂትፓ ዴጽን፥ Ꮉይቂካይዛራ አቶስ ጋእ ኡፋይስ ጋችዳ የሻ። ");
INSERT INTO oyde_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ኑኒ ኑላ Ꮉይቆ ፍርዳ ፍርድንትደ ፋና ቆፕዳ። የዝን ኑኒ ኑ ኦምተ ማቅካይዝን፥ Ꮉይቂዱንꬃና ደንꬅዘ ጾዘላ አማንንቶደ ጋር ይና ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ጾዚ ይኒ ጋር ኢታ Ꮉይቆፓ ኑና አሽዳ፤ Ꮉተን አሾዳ፤ ቲኖስን ኤ ኑና አሾዳ ጋእ ኤ ግዳ ኡፋይስ ጋዳነ። ");
INSERT INTO oyde_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ዎሳራ ኑና ማዶተ። ጋማ ዎሳ ባጋራ ጾዘ ማደ ኑ ደንግዘ ዎደ ጋማ አሱንꬅ ኑ ግሾ ጾዝ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ኑኒ ኑ ጌሽ ዎዝንተ ጬቅንታነ። ኑኒ Ꮉና አላምተ የዝደ የስተ አꬂ ኑ የዝደ የስተ ቱረትꬃራን ሱረትꬃራ ይንታራ የዝዳ። ይናን፥ Ꮉና አላመ ጭንጫትꬅተ ማቅካይዝን ጾዘ አꬎ ኬሃትꬅተ። ");
INSERT INTO oyde_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ኑ ይንትስ ጻፍደ ዳብዳብዛ ይን ናባቦደስን ቆፖደስ ዳንዳእዘባዝ ፋትን መለ ባያ። ይን ኤዛ ቆፖደስ ዳንዳእዛኖ ታ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Ꮉተ ይን ኑ ባዝ ኤራꬃር ኤራነ፥ የዝን ቲኖስ ሎይꬂ ኤሮዳኖ ታ አማንንታነ። ኑ ላꬄ የሱሳ ማቅዘ ዎደ ኑኒ ይን ግዳ ጬቅንትዳን ፋና ይንትን ኑ ግዳ ጬቅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ይኖ ታኒ ሎይꬂ ኤርደ ግሾ ይን ላምእንꬃ ማድንቶደ ጋር ቲንꬊ ይንታጎ Ꮉማደስ ቆፋ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ታኒ መቀዶንያ Ꮉንግ የይጋፓ ማቂ ይንታና በአዳ። ታኒ የይጋፓ ይሁዳ Ꮉንግዘ ዎደ ይን ታና ሞይዞዳ ጋእ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ታኒ ይኖ ጋእተ አኮ ኦቾደስ ቤዛኮ ኤሮሰ አስ አዛነ? ዎይ ታኒ ታ ቆፍቶ አጭዘ ዎደ አስ ቆፋ ጋር፥ ፈቲ ቶሄ «ዬ» ማህ ፈቲ ቶሄ «አደ» ጋዘ አስ አዛነነ? ");
INSERT INTO oyde_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","የዝን ጾዚ አማንንትዛያ ማቅደ ግሾ ኑ ይንትስ ኦህዘ ቃልታ «ዬ» ዎይ «አደ» ጋዛኖ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ታንን፥ ስላሰን ጢሞትዮሳን ይንትስ ማርክꬍደ ጾዘ ናእ፥ የሱስ ክርስቶሳ ኡባ ዎደ «ዬ» ፋትን «ዬ» ራን «አደራ» ባያ። ");
INSERT INTO oyde_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ጾዚ እንጎዳ ጋይደ ኡባ ክርስቶሳ ባጋራ «ዬ» ማቃነ። ኑኒ ክርስቶሳ ባጋራ ጾዛ ቦንቾዳ፥ «አምንኤ» ጋዛና ይኒ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ኑንን ይን ክርስቶሳ ግዳ ሚንግ ኤቆደ ጋር ፋ ኦችትስ ዶርደ ጾዚ። ");
INSERT INTO oyde_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ኑኒ ኤ ባዝ ማቅዳኖ ኤርሶደስ ፋ ማህታምቶ ኑላ ጋድዳ፤ ማህ ፋ ጌሽ አያና ቃብደ ማህ ኑ ዎዝንተ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ታኒ ቆሮንቶሳ Ꮉንግካይዛራ አትዳና ይን አዛንካይዛራ አታመ ግሾስ፤ ይና ዎርዶ ማቅኮ ጾዚ ታ ሸምፕቶ ታፓ ኤኮ። ");
INSERT INTO oyde_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ይን፥ ይን አማንተ ሚንግ የዘ ግሾ ኑ ይንታና ኡፋይሶደስ ይንታራ ዎላ ኦችዙንꬃና ፋትን ይንታና ዎልቃራ አማንꬅዙንꬃና ባያ። ");
INSERT INTO oyde_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ታኒ ላምእንꬃ ይንታጎ Ꮉንጎስ ጋእ ቆፋ አጭዳና ይንታና አዛንꬅካይዛራ አታማ። ");
INSERT INTO oyde_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ታኒ ይንታና አዛንꬅኮን ታ አዛንꬅዱንꬅ ይንታፓ መለ ታና ኡፋይሶደስ የዘ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ታኒ ይንትስ የ ዳብዳብዛ ጻፍዳና፥ ታ ይንታና በአደስ Ꮉንግዘ ዎደ ታና ኡፋይሶደስ ቤዝዘ አሱንꬃላ ታ አዛኖደስ ኮዮሰ ግሾ። ታ ኡፋይትዘ ዎደ ይን ኡቡንꬅን ኡፋይቶዳኖ ታ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ታኒ ጋማ ዋየን ኡንአን ማህ ጋማ አፉꬃራ ጻፍዳና፥ ይንታና አዛንꬆደስ ማቅካይዝን ታኒ ይንታና ኡባ አኮ ጋር ካꬍዛኮ ይንታና ኤርሶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","አስ አዛንꬅደ ኦደን የዝኮ ታ ኤላ አፋ ጋንꬆደስ ኮዮስ ፋትን ታና ማቅካይዝን ይንታፓ ጋሙንꬃና አዛንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ይንታፓ ጋማ አሱንꬅ የ አꬃ ሴርደ ሴረꬅታ ኤስ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ይኒ ግሾ፥ የ አꬄ ጋማ አዛኒ፥ ኡፋይስ ጋቻመ ፋና ጨር ይን ኤዛ ማሮደስን ምንꬅꬆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ይን ኤዛ ሲቅዛኖ ማህ ኤስ ቆንጭሳደ ፋና ታ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ታ የ ዳብዳብዛ ይንትስ ጻፍዳና፥ ይን ፋታንንት፥ ኡባ ባዛ ታስ ኪትንትዛኖ ኤሮደስ ኮይደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ይን ማርዘ አꬃ ታንን ማሮዳ። ታኒ ማሮደባዝ አኮ የዝኮን፥ ክርስቶሳ ቲኖ ይን ግሾ ጋእ ማርዳ። ");
INSERT INTO oyde_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ታ ይኖ ኦችዳና ጻላሄ ገነ ኦቻ ኑ ኤርዘ ግሾ ጻላሄ ጭማመ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ታኒ ክርስቶሳ ዎንገለ ሳባኮደስ ጢሮአዳ Ꮉንግደ ዎደ ላꬂ እዘ ታስ ኦቻ ኦገ ጊግዚ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","የዝን ታኒ ታ እሸ ትቶ እዘ ደንግካይዘ ግሾ ታ ዎዝንታ ሸምፕካያ። ይኒ ግሾ፥ እዘ የዘ አሱንꬃና ሳሮꬅ ኤዛ ኮዮደስ መቀዶንያ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","የዝን ክርስቶሳ ባጋራ ኡባ ዎደ ኑና ጋመራ ካልꬅዛያን ሽቶ ፋና ሳውዘ ክርስቶሳ ባዝ ኑ ኤርዘ ትምርትቶ ኡባ በሳ የልꬆደ ጋር ኦችዘ ጾዛ ጋላታ የሎ። ");
INSERT INTO oyde_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ኑኒ አትዘ አሱንꬅ ግዳን ꬋብዘ አሱንꬅ ግዳ ክርስቶሳ ባጋራ ጾዝስ እንግንትደ ሳውዘ ሽቶ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ꬋብዘ አሱንꬅስ Ꮉይቆስ ካንግዘ Ꮉይቆ ዜቆ፤ ማህ አትዘ አሱንꬅስ ደኦጎ ካንግዘ ደኦ ሳዎ፤ ዬዝን፥ ይኒ ጋርዘ ኦቻስ ቤዝዘ አስ ማቃደ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ኑኒ ጾዘ ቃላ ትርፈ ደንጎደስ ኮይ ቡቁꬅ ዛልእዘ ጋማ አሱንꬅ ጋር ባያ። የዝን ጾዚ ኪትደ ሉለ አሱንꬅ ፋና ክርስቶሳ ግዳ የዚ ጾዘ ቲንተ ቃላ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ኑኒ ማህ ኑና ናሾነነ? ዎይ መለ አስ ጋር፥ ጋላታ ዳብዳብዛ ይንትስ ዳኮደስ ዎይ ይንታፓ ኤኮደስ ኑና ኮሻነነ? ");
INSERT INTO oyde_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","አስ ኡባ ይንታና ኤሮደ ፋናን ናባቦደ ፋና ይን ኑ ዎዝንተ የዘ ዳብዳበ። ");
INSERT INTO oyde_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ይን ቃላመራ ማቅካይዝን ደኦ ጾዘ አያናራ፥ ሹቻላ አፋ ማቅካይዝን አስ ዎዝና ጻፍንትዱንꬃናን ኑራ ማድንትደ ክርስቶሳ ዳብዳበ ማቅዛኖ ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ኑ ይኖ ጋይዳና፥ ክርስቶሳ ባጋራ ጾዘ ግዳ አማኖ ኑስ የዘ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ኑ ይኖ ኦቾደስ ዳንዳእዳና ጾዘ ዎልቃራ ፋትን ኑኒ ኑ ዎልቃራ አኮን ኦቾደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ኑ ክለ ጫቆስ ኪትንትዙንꬄና ማቃደ ፋና ኑና ዪዝዳ። ይና ክለ ጫቅታ ጌሽ አያናራ በንትዳ ፋትን ጻፍንትደ ህገ ግዳ ባያ። ህገ ዎꬋነ፥ የዝን ጌሽ አያና ደኦ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ሹቻላ አፋ ጻፍንትደ ህግታ እንግንትደ ዎደ ጾዘ ቦንችታ ቆንጭዳ። ሙሴ ስንተ የዘ ቦንችታ ꬋብተር Ꮉንግዘባዝ ማቅኮን፥ እስራኤለ አሱንꬅ ኤ ስንቶ ዳኪ በአደስ ኡን ዳንዳእካያ። ይኬ፥ Ꮉይቆ ክእዘ ህገ ይኒ ጋር ቦንቾራ ቆንጭኮ፥ ");
INSERT INTO oyde_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ዬዝን፥ ጌሽ አያናራ ኦችንትዘ ኦቻ ቦንችታ ዋይዝ አꬎሶ? ");
INSERT INTO oyde_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","አሳላ አፋ ፍርዳ ክእዘ ህገ ቦንቾ ማቅኮ ዬዝን፥ አስ ጽልዘ ክለ ኦገ ዋይዝ አꬊ ቦንችንቶሳ? ");
INSERT INTO oyde_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ዛጋ ቦንቾ ማቅዳኖ Ꮉተ አꬍዘ ቦንቾራ የልꬅ በእዘ ዎደ ዛጋና ቦንቾ ባይዘ ባዝ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ኤራꬅ ዎደስ በንቲ ሱባፓ ꬋብዳና Ꮉኒ ፋና ቦንችንትኮ፥ መዽና የዛና ዋይዝ አꬊ ቦንችንቶሶ? ");
INSERT INTO oyde_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ኑስ Ꮉኒ ጋር ኡፋይስ የዘ ግሾ ዬልꬍካይዛራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ኑኒ፥ እስራኤለ አሱንꬅ ꬋብተር Ꮉንግዘ ቦንችት ፎልቶ ባአመ ጋር ፋ ስንቶ ጎዝደ ሙሴ ፋና ባያ። ");
INSERT INTO oyde_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","የዝን ኡን ዎዝንታ ዶጭዳ። Ꮉይኖ የሎደስ ኡን ጋልአ ጫቆ ናባብዘ ዎደ ኡን ዎዝንታ ይና ጎዝꬅተ ጎዝንቲ የነ። ይና ጎዝꬅታ ክርስቶሳር ጻላላ ጋርንታነ። ");
INSERT INTO oyde_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","የዝን Ꮉይኖ የሎደስ ኡን ሙሴ ማጻፈ ናባብዘ ዎደ ኡባ ይና ጎዝታ ኡን ዎዝንቶ ጎዛነ። ");
INSERT INTO oyde_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","የዝን ኦደን ላꬃጎ ማቅዘ ዎደ አይደን ይና ጎዝታ ጋርንታነ። ");
INSERT INTO oyde_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ላꬂ አያና፤ ላꬄ አያና የዘ በስተ ዋሎትꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ኑኒ ኡቡንꬅ ጎዝንትካይዘ ስኖራ ላꬄ ቦንችቶ በአዳ። ኑኒ አያና ማቅደ ላꬄ ብሽቶ አዞደስ ቦንቾፓ ቦንቾ ላምንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ይኬ፥ ጾዚ ፋ ማሮትꬅተ Ꮉና ኦችቶ ኑስ እንግደ ግሾ ኑኒ ኡፋይስ ጋቾስ። ");
INSERT INTO oyde_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ኑኒ ኣችቻን ዬልዘ ኦቻ ኡባ አሽዳ፤ ዉጨ ኦቻ ኦቾስ፤ ጾዘ ቃላ ዎርዶራ ዎርቆስ። ቱርቶ ቆንጨ ኦህተ፥ አስ ኡባ ዎዝና ኑና ኤኮደ ፋና ጾዘ ቲኖ ኑና ሺሾዳ። ");
INSERT INTO oyde_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ኑ ኦህዘ ዎንገልዘ ጌንግደ ባዝ ማቅኮን፥ ገንግዳና ꬋበ ኦገ የዘ አሱንꬅስ። ");
INSERT INTO oyde_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Ꮉና አላምቶ አህዘ ጾዘ አማኖሰ አሱንꬅ ዎዝንቶ ጎዝዳ። ኡን ጾዘ ብሻራ ቆንጭደ ክርስቶሳ ቦንቾ ዎንገለ ፎእቶ በአመ ጋር ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ኑኒ፥ የሱስ ክርስቶሳ ላꬂ ማቅዳኖን ኑ ኤ ግሾ ይን ኦቻንቾ ማቅዛኖ ኦህነ ፋትን ኑ ባዝ ኦሆስ። ");
INSERT INTO oyde_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","«ፎኦ ꬉማ ግዳ ፎኦ» ጋይደ ጾዘ፥ ክርስቶሳ ስንቶ ፎእዘ ጾዘ ቦንችቶ ኤርዘ ፎእቶ እንጎደስ ፋ ፎእቶ ኑ ዎዝንተ ፎእዝዳ። ");
INSERT INTO oyde_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","የዝን ኡባፓ አꬍዘ ዎልቃ ኑ ባዝ ማቅካይዝን ጾዘ ባዝ ማቅዛኖ ቤሳደስ Ꮉና ቦንቾ ቆልታ መቂዘ ሚሸ ፋና ኑ ግዳ የነ። ");
INSERT INTO oyde_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ኑ ኡባ ባጋራ ዋይንትዳ፥ የዝን መቂካያ። ኑስ ዎርክታ ማቅዳ፥ የዝኮን ኡፋይስ ጋችካያ። ");
INSERT INTO oyde_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ኑ፥ ሞርኩንꬃራ ባይእንትዳ፥ የዝን ላገ ꬋብካያ። ኑ ሞርኩንꬃራ ጉዱንቲ ጎልእዳ፥ የዝን ꬋብካያ። ");
INSERT INTO oyde_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","የሱሳ የእታ ኑ ጋልተ ቆንጮደ ፋና ኤ Ꮉይቅቶ ኡባ ዎደ ኑ ጋልተ ቶኪ ዉታነ። ");
INSERT INTO oyde_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","የሱሳ ደእታ Ꮉይቅዘ ኑ ጋልተ ቆንጮደ ጋር ፋጻ የዘ ኑኒ ኤ ግሾ ኡባ ዎደ Ꮉይቆስ አꬊ እንግንታነ። ");
INSERT INTO oyde_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ይኬ፥ Ꮉይቆ ኑ ግዳ ኦችዘ ዎደ ደኦ ይንግዳ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ጌሽ ማጻፍተ፥ «ታ አማንዳ፤ ይኒ ግሾ ኦህዳ» ያጋእንትዳ። ይኒ ፋና አማኖ ኑስ የዘ ግሾ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ላꬄ የሱሳ Ꮉይቆፓ ደንꬅደ ጾዘ፥ ኑናን የሱሳራ Ꮉይቆፓ ደንꬆዳኖን ይንታራ ዎላ ፋ ቲኖ ሺሾዳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ይና ኡባ Ꮉንዳና ይን ግሾ። ጾዘ አꬎ ከሃትꬅታ ጋማ አሱንꬃና የልዘ ዎደ አሱንꬅ ጾዘ ቦንቾስ ጋላታ ጋንጎደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ይኒ ግሾ፥ ኑኒ ኡፋይስ ጋቾስ። ኑ በንትዘ ጋልታ ላቢተራ Ꮉንግዘባዝ ማቅኮን፥ ኑ አያና ጋልታ ቃምተ ቃምተ ክልꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Ꮉተስ ኑ ማꬍንትዘ Ꮉና ላፋ ማꬍታ፥ ኡባፓ አꬊ ዳምዘ መዽና ቦንቾ ኑስ እንግሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ኑኒ በንትዘ ባዝ ማቅካይዝን በንቶሰ ባዝ በእነ። በንትዘ ባዝ Ꮉተስ፥ የዝን በንቶሰ ባዝ መꬍናስ። ");
INSERT INTO oyde_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Ꮉተ ኑ የዘ ዱንካነ አዝዘ Ꮉና ሳአ አሽታ ዉልእንትኮን፥ አስ ኬጽካይዘ፥ ጾዚ ኬጽደ መዽና ኬꬂ ኑስ ሳሎ የዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ሳሎ ጋላ ማኦደስ አሙꬍተራ Ꮉተ Ꮉና ሳእተ የዝተራ ሼንꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ኑኒ ይኖ ማእደ ዎደ ካልꬎኦስ። ");
INSERT INTO oyde_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ዱንካነ አዝዘ Ꮉና ሳአ አሽተ ኑ የዝተራ ዴጽን ሼንꬋነ። Ꮉይቅዘ ኑ አሽታ ደኦር ላምንቶደ ፋና ሳሎ ጋላ ማኦደስ ኮያነ ፋትን አሾፓ ሻክንቶደስ ኮይ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ኑና Ꮉንስ ጊግዝደ ጾዚ። ማህ ቲኖፓ ዮኦደ ባዝስ ቃብደ ማህ ፋ አያንቶ ኑስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ይኒ ግሾ፥ ኑኒ Ꮉና ሳአ አሽትራ የዘ ዎደ ኡባ ላꬃፓ Ꮉኪ የዛኖ ኤርኮን ኡባ ዎደ አማንንቲ የነ። ");
INSERT INTO oyde_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ኑኒ የዘ አማኖራ ፋትን በእዘ ባዛራ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ኑ Ꮉና ሳአ አሽትፓ ሻክንት፥ ላꬃራ ዎላ የሳደስ አሙꬍዘ ግሾ አማንንቲ የነ። ");
INSERT INTO oyde_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ይኒ ግሾ፥ ኑ Ꮉና አሽትራ የዝን ዎይ Ꮉና አሽትፓ ሻክንትን፥ ኑ አሞትꬅታ ኤዛ ኡፋይሶደስ። ");
INSERT INTO oyde_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ኑኒ ፈተ ፈተ Ꮉና ሳእተ የዝተራ ሎኦ ማቅኮን ዎይ ኢታ ማቅኮን፥ ኦችደ ኦችትስ ቤዝዘ ፍርዳ ኤኮደስ ክርስቶሳ ፍርዳ ኦይዳ ቲኖ ሺቆዳ። ");
INSERT INTO oyde_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ይኬ፥ ኑኒ ላꬄስ ዣሽትዛና አኮስ የዛኮ ኤርዘ ግሾ አሱንꬅ ኑ ኦህዛኖ ኤኮደ ፋና ዞራነ። ጾዚ፥ ኑኒ ኦድ የዛኮ ኑና ኤራነ፤ ማህ ይንትን ይን ዎዝንተ ኑ ኦድ የዛኮ ኤራነ ያጋእ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ዎዝና ግዳ ማቅካይዝን ጨር Ꮉሪ ጬቅንትዘ አሱንꬅስ ማሄ ይን እማደስ ዳንዳኦደ ጋር ይን ኑ ግዳ ጬቅንቶደ ጋር ይንትስ ምክናተ ማቃደስ ኮያነ ፋትን ኑ ኑና ማህ ናሾደስ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ኑ ዣሽትዛ ማቅኮ ጾዘ ቦንቾስ፤ ዎዝናማ ማቅኮ ይንትስ። ");
INSERT INTO oyde_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ፈተ ኡቡንꬅስ Ꮉይቂዳያን ኡቡንꬅ ማህ ኤራ Ꮉይቂዳኖ ኑ ኤርዘ ግሾ ክርስቶሳ ሲቅታ ኑና አሃነ። ");
INSERT INTO oyde_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ደኦ የዙንꬅ ይኬፓ ሱባ ፋስ ማቅካይዝን ኡንትስ Ꮉይቅደስን Ꮉይቆፓ ደንድደስ የሳደ ፋና ክርስቶሳ አስ ኡባ ግሾ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ይኬፓ ሱባ፥ ኑኒ ኦናን አስ ቆፋራ ፍርዶስ። Ꮉንፓ ዛጋ ኑኒ ክርስቶሳን አስ ቆፋ ጋር ፍርድደ ባዝ ማቅኮን፥ ይኬፓ ይኒ ጋራ ፍርዶስ። ");
INSERT INTO oyde_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ይኒ ግሾ፥ ኦንን ክርስቶሳ ግዳ የዝኮ ክለ መꬎ፤ ጋልአ መትꬅታ አꬍዳ፤ ኡባ ክለ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ይኖ ኡባ ጾዚ ኦችዳ። ኤ ክርስቶሳ ባጋራ ኑና ፋራ ጊግዝዳ። ማህ መሉንꬃና ፋራ ጊግሳደ ጋር ኑስ ጊግዛ ኦቻ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ጾዚ ክርስቶሳ ባጋራ አስ ኡባ ፋራ ጊግዛነ። ኡን ናጋርቶ ፋይድካያ፤ ማህ አስ ፋራ ጊግዘ ቃላ ኑስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ጾዚ አስማና ኑ ባጋራ ጼግዘ ግሾ ኑ ክርስቶሳስ ኪትንትደ አስ ጋር ጾዛራ ጊጎተ ጋእ ክርስቶሳ ግሾ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ኑኒ ጾዘ ጽሎትꬅ ክርስቶሳ ባጋራ ኤኮደ ጋር፥ ናጋራ ኤሮሳ ክርስቶሳ ኑ ግሾ ናጋራንቾ አስ ፋና ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ኑኒ ጾዛራ ዎላ ኦችዘ አስ ማቅዳን ጋር፥ ይን ኤክደ አꬎ ኬሃትꬅቶ ጨር ማሀመ ፋና ኑ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ጾዚ፥ «ዎትደ ሳተ ታ ነና ስእዳ፤ አቶትꬅ ቃምተ ነና ማድዳ» ያጋነ። ይኬ፥ ስእዘ ዎድታ Ꮉተ፤ አቶትꬅ ቃምታ Ꮉይኖ። ");
INSERT INTO oyde_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ኦደን ኑ ኦችቶ ቦሮደ ጋራን ኑ ግዳ ꬉቡንቶደ ጋር ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","የዝን፥ ኑ ቱሪ ጾዘ ኦቻንቾ ማቅዳኖ ኑ ኦችዘ ኡባ ባዝተ ቤሳዳ፤ ጋማ ማꬋራ፥ ዋየራን፥ ኡንአራ፥ ");
INSERT INTO oyde_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ጋራፍንተራ፥ አጭንተራ፥ እጽንተር ኩምደ ካቻራ፥ ኦች ላበራ፥ ገንቶ ꬋበራ፥ ናየራ፥ ");
INSERT INTO oyde_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ጌሻትꬃራ፥ ኤራትꬃራ፥ ዳንዳአራ፥ ኬሃትꬃራ፥ ጌሽ አያናራ፥ ቱሪ ሲቆራ፥ ");
INSERT INTO oyde_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ቱሪ ቃላራ ጾዘ ዎልቃራ ኑኒ ኤ ኦቻንቾ ማቅዳኖ ቤዝዳ። ማህ ጽሎትꬅ ኑስ ቶራን ጎንዳለ። ");
INSERT INTO oyde_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ኑኒ ቦንችንትዳን ቦርንትዳ፤ ጫዥንትዳን ጋላትንትዳ። ቱሮ ኦህነ፥ የዝን አሱንꬅ ኑና ባልꬅዙንꬃና ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ኑ አስ ግዳ ኤርንትደ አስ፥ የዝን ኤርንቶሰ አስ ጋር ማቅዳ። Ꮉይቂዳ ጋእንትዳ፥ የዝን ፋጻ የነ፤ ጉድንትዳ፥ የዝን Ꮉይቂካያ። ");
INSERT INTO oyde_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ኑኒ አዛንኮን ኡባ ዎደ ኡፋይታነ። ኑ ዳሃ የሻ፥ የዝን ጋማ አሱንꬃና ዱርዛነ። ማህ አኮ ባይዘ አስ የሻ፥ የዝን ኡባና ኑ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ቆሮንቶሳ አሱንꬆ፥ ኑ ይንትስ ጌሽ ኦህዳ፤ ኑ ዎዝንቶ ይንታና ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ይን ኑና ይን ሲቅቶ ቤዛንጽ ካይዳፕ አትን ኑ ኑ ሲቅቶ ይንታና ካይካያ። ");
INSERT INTO oyde_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","አደ ፋ ናኡንꬅስ ኦህዛንፋና ታ ይንትስ ኦህነ፤ ኑ ይንታና ኑ ዎዝንቶ ቤዝዳን ፋና፥ ይንትን ይን ዎዝንቶ ኑና ቤዞተ። ");
INSERT INTO oyde_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","አማኖሰ አሱንꬃራ ቤዞሰ ኦገራ ዋጽንትፐተ። ጽሎትꬅስን ናጋራስን አኮ የልንተ የዘ? ፎኦስን ꬉማስን አኮ ፈተትꬅ የዘ? ");
INSERT INTO oyde_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ክርስቶሳን ጻላሄን የልꬅዘባዝ አኮ? ማህ አማንዛይን አማኖሳይን ዎላ ኮጽዘባዝ አኮ? ");
INSERT INTO oyde_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ጾዘ ኬꬅስን ኤቁንꬃራ አኮ ፈተትꬅ የዘ? ጾዚ፥ «ታ ኡን ግዳ የሳዳ፥ ታ ኡን ግዳ በንቶዳ። ታ ኡንትስ ጾዝ ማቃዳ፤ ኡንትን ታ ዎርዣ ማቃዳ» ጋይዳንጋራ፥ ኑኒ ደኦ ጾዘ ኬꬂ። ");
INSERT INTO oyde_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ይኒ ግሾ፥ ላꬂ፥ «ኡን ግዳፓ ሻክንት ከዞተ፤ ቱና ማቅደ ባዝ ቦችፐተ፤ ታ ይንታና ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ታ ይንትስ አደ ማቃዳ፤ ይን ታስ ꬊራꬅ ናኡንꬃናን ማች ናኡንꬃናን ማቃዳ፤ ያጋነ ኡባፓ ዎልቃማ ላꬃይ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ይኬ፥ ታ ሲቁንꬆ፥ Ꮉና ኡፋይስታ ኑስ ማቅደ ግሾ ኑ አሽቶን ኑ ሸምፕቶ ቱንዘ ባዝ ኡባፓ ኑና ጌሾዳ። ጾዝስ ዣሽቲ ኑ ጌሻትꬅቶ ፎሎ ማሆዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ይን ዎዝንቶ ኑና ቤዞተ። ኑኒ ኦናን ቆህካያ፤ ኦደስን ኢስካያ፤ ኦናን ጭምካያ። ");
INSERT INTO oyde_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ታኒ ይኖ ይንታላ አፋ ፍርዶደስ ጋኦስ። Ꮉንፋ ቲኖ ታ ይንትስ ኦህዳን ጋራ፥ ይን ኑ ዎዝንተ የነ፤ ኑ ፋጻ የዝኮን Ꮉይቂኮን ይንታፓ ሻክንቶስ። ");
INSERT INTO oyde_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ይንታላ ታስ የዘ አማንታ ዳማ፤ ታ ይንታራ ምንጋነ፤ ኑ ማꬍተ ኡባ ዎደ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ኑኒ መቀዶንያ የልደ ዎደ ኡባ ባጋራ ዋይንትዳ ፋትን ሸምፕካያ። ባለራ ሞርኩንꬃራ፥ ኑ ግዳር ዣሽሞራ ኡንእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","የዝን አዛንዱንꬃና ምንꬅꬅዘ ጾዘ፥ ትቶ የእተ ኑና ምንꬅꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ኑና ምንꬅꬅዘ ትቶ የእቶ ጻላላ ማቅካይዝን ይንትን ኤዛ ምንꬅꬅዳኖ ስእዳነ ጉጂ። ይን ታና አሙꬍዛኖ፥ ታስ አዛንዛኖ ታስ ቆፕዛኖ ታ ስእደ ዎደ ታና ጋማ ኡፋይስዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ታ ዳብዳብዘ ይንታና አዛንꬅኮን አኮስ ታ ጻፍነ ጋእ ቂርꬎስ። ታ ቂርꬍዳና ታ ዳብዳብዘ ይንታና ኤራꬅ ዎደስ አዛንꬅደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Ꮉተ ታኒ ኡፋይትዳና፥ ታ ይንታና አዛንꬅደ ግሾ ማቅካይዝን ይን አዛንታ ይንታና ይን ናጋርትፓ ማህደ ግሾ። ጾዚ ፋ ቆፍት ጋር ይንታና አዛንꬅዳ ፋትን ኑ ይንታና አኮ ባዛራን ቆህካያ። ");
INSERT INTO oyde_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ጾዚ ኮይዘ አዛኖ፥ አቶትꬃጎ የልꬅዘ ናጋራፓ ማቀ ከእነ፤ ኤ ግዳ ቂርዘባዝ ባያ። የዝን Ꮉና ሳአ አዛንታ Ꮉይቆ ከእነ። ");
INSERT INTO oyde_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ይን አዛንታ ይን ግዳ አፍዝደ ኣፍቶ ቦኦተ። ይና አዛንታ ይንታና አኮ ጋር ደንꬅዛኮ አኮ ጋር ማሄ እንገዛኮ፥ አኮ ጋር ኤልሲ ካጭዛኮ፥ አኮ ጋር ዣሽዘዛኮ፥ አኮ ጋር ሱክዘዛኮ፥ አኮ ጋር ታስ ቃናትዘዛኮ፥ አኮ ጋር ሴርꬅ ካልꬅዛኮ ቦኦተ። Ꮉና ኡባነ ይን ጌሽ ማቅዛኖ ማርክꬍዝዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ይኒ ግሾ፥ ታኒ Ꮉይ ዳብዳቢዛ ይንትስ ጻፍዳና፥ ቆህዘ አꬃ ዎይ ናቂንትደ አꬄ ግሾ ባያ። የዝን ይን ኑስ አኮ ጋር ቆፕዛኮ ጾዘ ቲኖ ይን፥ ይንታና በአደ ጋር ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ኑኒ ሚንግዳንፓ አꬊ ትቶ ደንግዳነ ኡፋይትዳ። ኑ ኡፋይትዳና አꬊ፥ ይን ትቶ ኡፋይስዳነን ኤ ዎዝንቶ ሸምፕዝዳነ። ");
INSERT INTO oyde_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ታኒ ይንታና ናሺ ኤስ ኦህን ይን ታና ዬልዝካያ። ይኒ ግሾ ኑኒ ኡባ ዎደ ይንትስ ቱሮ ኦህነ፤ ይኒ ጋራ ኑኒ ትቶ ቲኖ ይንታና ናሽዳና ቱሮ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ይን ኤስ ዣሽሞራ ጎቂ፥ ኤዛ ሞክዳኖ ማህ ኤስ አኮ ጋር ኪትንተዛኮ ኤ ቆፕዘ ዎደ ይንትስ የዘ ሲቅታ ሚንግተ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","ታኒ ኡባ ባዛ ይን ግዳ አማንንትዘ ግሾ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ኑ እሹንꬆ፥ ጾዚ መቀዶንያ የዘ ዎሳ ኬꬁንꬅስ እንግደ አꬎ ኬሃትꬅቶ ይን ኤሮደ ጋር ኑ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ኡን ዳማ ማꬋራ ፋታንንትዳ፥ የዝን ኡን ኡፋይስታ ዎልቃማ። ኡን ዳሃትꬅትስ ዉዙላ ባያ፥ የዝን አꬂ እንገራ ጋማ ዳልግዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ኡን ፋ ዎልቂት ጋራን ፋ ዎልቂትፓ ኣꬍዛኖ ካꬊ እንግዳንስ ታ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ኡን ጾዝ አስ ማድዘ ሎኦ ኦቻ ኑራ ኦቾደስ ኮይ ኑና ጋማ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ኡን ኑኒ ቆፕዳንፓ አꬂ ኦችዳ። ቲንꬊ ፋና ላꬅስ እንግዳ፤ ካሊ፥ ጾዘ ቆፋ ጋር ኡን ፋና ኑስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Ꮉና ዳልጋ ኦችቶ አይክደ ትቶ ጉጂ ኦቾደ ጋራን ይንታና ማዲ፥ ይና ኦችቶ ፎልሳደ ጋር ኤዛ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","የዝን ይን ኡባባዝተ፥ አማኖራ፥ ኦሄራ፥ ኤራትꬃራ፥ ዳማ አሞራ፥ ኑና ሲቆራን ኡባባዝተ ዱርꬍዳን ፋና Ꮉና ሎኦ ኦችተን ይን ዳልጋ ማቃደ ጋር ኑ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ታኒ ይኖ ኪቶደስ ጋኦስ። የዝን መሉንꬅ ዳማ አሙቶ ይን ሲቆራ የልꬅ ብእ ይን አኮ ፋና ቱሮ የዛኮ ኤሮደስ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","ይን ኑ ላꬄ የሱስ ክርስቶሳ አꬎ ኬሃትꬅቶ ኤራነ። ክርስቶሳ ዱረ ማቂ በቲ፥ ይን ኤ ዳሃትꬅተ ዱርꬋደ ጋር ይን ግሾ ዳህꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ታኒ Ꮉና ኦህተ ይንታና ማድዘ ዞረ ዞሮደስ ኮያነ። ይን ኦማ በረ እማደስ ጻላላ ማቅካይዝን ይኖ ኦቾደስ አሞትꬃራን ይን ቲናነ። ");
INSERT INTO oyde_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ይን ኦቾደስ አይክደ ኦችቶ Ꮉተ ፎሎተ። ይን ይንትስ የዛን ጋር እንግኮ፥ ይና ይን እንጎደስ ቆፕዳኖ ቱሮ ማህነ። ");
INSERT INTO oyde_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","ፈቲ አስ እንጎደስ አሙꬍኮ፥ ኤ እሞታ ጾዘ ቲኖ ኤክንትዛና፥ ኤ ፋስ የዛን ፋና እንግኮ ፋትን ባይዘ ባዛፓ እንጎደስ ኡንእንትን ባያ። ");
INSERT INTO oyde_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ታኒ ይኖ ጋዛና፥ ይን ኡባና ፈቲ ልከ ማቃደ ጋር ጋእ ፋትን መሉንꬅ ማꬍትፓ ሸምፕን ይን ማꬍꬋደ ጋር ባያ። ");
INSERT INTO oyde_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ይን ማꬍꬍዘ ዎደ ኡንትስ ጋንግዳንፓ ይን ማꬍትስ ማቃደ ፋና Ꮉተ ይንትስ ጋንግዳና ኡን ማꬍትስ ፌዣነ። ይኒ ፋና ይን ግዳ ዎልከ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ጌሽ ማጻፍተ፥ «ጋማ ሺሽደስ ትርፍካያ፤ ኤራꬅ ሺሽደስ ፋጭካያ» ጋእንት ጻፍንትዳን ጋር። ");
INSERT INTO oyde_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ኑ ይንትስ ቆፕዛንጋራ ትቶን ይንትስ ቆፖደ ጋር ኦችደ ጾዘ ጋላትንቶ። ");
INSERT INTO oyde_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ትቶ ይንታጎ Ꮉንግዳና፥ ኑ ኤዛ ደንꬅꬅደ ግሾ ጻላላ ማቅካይዝን ኤ ፋ ቆፍተ Ꮉማደስ አሙꬍደ ግሾ። ");
INSERT INTO oyde_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ዎንገለ ማርክራ ዎሳ ኬꬃ ኡባነ ጋማ ኤርንትደ እሻ፥ ኑኒ ትቶራ ዳካነ። ");
INSERT INTO oyde_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ይንላ ኑኒ Ꮉና ዳልጋ እሞትꬅቶ ካንግዘ ዎደ ኑራ Ꮉማደ ጋር Ꮉና ዳልጋ ኦችትራ ላꬃ ቦንቾደስን መሉንꬃና ማዶደስ የዘ አሙቶ ቤሳደስ ኤ ዎሳ ኬꬅተ ዶርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Ꮉና እንግንትደ ዳልጋ እሞትꬅቶ፥ ኑ ኦቻላ ፌሽዘ ዎደ ኑና ቦራመ ፋና ናግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","ኑኒ ላꬄ ቲኖ ጻላላ ማቅካይዝን አስ ቲኖን ሎኦ ማቅደ ባዝ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ማህ ጋማ ዎደ ፋታና ግዳ ሚንግ አꬍደ ኑ እሻ፥ ኡንታራ ይንታጎ ክትዳ። ኤ ይንግዳ ሎይꬂ አማንንትዘ ግሾ Ꮉተ ይንታና ማዶደስ ጋማ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ትቶባዝ ኤሮደስ ኮይዛኮ፥ ኤ ይንታና ማዶደስ ታራ ኦችዘ ታ ኦቻ ላገ። መለ እሹንꬅባዝ ማቅኮ ዎሳ ኬꬁንꬅ ኪትዱንꬃና፤ ማህ አሱንꬅ ኡን የስቶ ብእ ክርስቶሳ ቦንቻነ። ");
INSERT INTO oyde_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ይኒ ግሾ፥ ዎሳ ኬꬅታ ይን ሲቅቶን ኑ ይንታና አማንንትዛና ቱሮ ማቅዳኖ ቤሳደስ ይን ሲቅቶ Ꮉንꬅ አሱንꬃና ቤዞተ። ");
INSERT INTO oyde_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","አማንዘ አሱንꬅስ ኬስዘ ሚሸባዝ ታ ይንትስ ጻፎደስ ኮሾስ። ");
INSERT INTO oyde_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","ይን ማዶደስ ሎይꬂ አሙꬍዛኖ ታ ኤራነ። ይን አካያ አሱንꬅ፥ ኦማ በረፓ አይኪ ማዶደስ ጊግንትዳኖ ታኒ መቀዶንያ አሱንꬅስ ዶና ኩንꬅ ኦህዳ። ይን ዳማ አሞትꬅታ ኡንታፓ ጋሙንꬃና ደንꬅꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Ꮉና ኦችተ ይን ግዳ ኑ ጬቅንትዘ ጬቅታ Ꮉሪ ማቃመ ጋር ቲኖ ይን ባዝ ታ ኦህዳን ጋራ ይን ጊግንቲ ናጎደ ጋር Ꮉንꬅ እሹንꬃና ይንታጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","መቀዶንያ አሱንꬅ ታራ Ꮉንግ፥ ይን ጊግንትካይዛር የሳደር፥ ደንግኮ፥ ኑ ይን ግዳ ዬልꬋዳ፤ ማህ ይን ኑፓ አꬊ ዬልꬋዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ይኒ ግሾ፥ Ꮉንꬅ እሹንꬅ ታፓ ቲንꬊ ይንታጎ Ꮉንግ፥ ይን እንጎዳ ጋይደ እሞትꬅቶ ቲንꬊ ጊግሳደ ጋር ታ ኡንታና ኪትዳ። ታ የእዘ ዎደ ይና እሞታ ጊጊ በቶ። የ ዎደ ይና ኬሃትꬅ እሞታ ዎልቃራ ማቅካይዝን ካራ ማቅዛኖ ኤርሳነ። ");
INSERT INTO oyde_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Ꮉኖ ቲሮተ፤ ኤራꬅ ቡድዘ ኤራꬅ ማጾዳ፤ ጋማ ቡድዘ ጋማ ማጾዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ጾዚ ኡፋይሳራ እንግዘ አꬃ ካዽዘ ግሾ ዎልቃራ ዎይ ካꬎ ባይዝን ማቅካይዝን ፈቲ ፈቲ አስ ፋ ዎዝንተ ቆፕዳንጋራ ካራ እንጎደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ኡባ ዎደ ኡባ ባዛ ኮሽዘ ባዝ ኡባ ደንግ ሎኦ ኦቻ ኡባ ኦቾደስ ዳንዳኦደ ፋና ጾዚ ይንትስ ፋ አንጅቶ ጋንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ጌሽ ማጻፍተ፥ «ኤ ፋ ቆልቶ ዳሁንꬅስ ላልዳ፤ ኤ ጽሎትꬅታ መꬍናስ የሳዳ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ቡድዘስ ቡዱꬅ፥ ማደስ ካꬃ እንግዘ ላꬄ፥ ይን ቡድዘ ቡዱꬅቶ ጋንꬅ እንጎዳ። ይን ጽሎትꬅ አፍቶን ጋንꬆዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","ጋማ አሱንꬅ ይን እንግዘ እሞትꬅቶ ኑፓ ኤኪ፥ ጾዝ ጋላቶደ ጋራ፥ ይን ኡባ ዎደ ጋንꬅ እንግዙንꬃና ማቃደ ጋር ጾዚ ይንታና ኡባ ባዛራ ዱርሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Ꮉና ይን እንግዘ እሞታ አማንዘ አስ ፋጭቶ ኩን ጻላላ ማቅካይዝን አሱንꬅ ጾዝ ጋላቶደስ ምክናተ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Ꮉና ይን ኦችታ ይን አማንቶ ኤርስዝ ክርስቶሳ ዎንገለ ይን አማኒ ኤስ ኪትንቲ ይንትስ የዘ ባዝ ኡንታራን መሉንꬃራ ሻክንትደ ግሾ ኡቡንꬅ ጾዝ ቦንቾዳ። ");
INSERT INTO oyde_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ጾዚ ይንትስ እንግደ አꬎ ኬሃትꬅት ግሾ ኡን ይንትስ ጾዝ ዎስተራ ይንታና በአደስ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ዉዙላ ባይዘ ጾዘ እሞትꬅትስ ጾዚ ጋላትንቶ። ");
INSERT INTO oyde_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","ታ ይንታራ የዘ ዎደ አዳ፥ ማህ ይንታፓ Ꮉክዘ ዎደ ኑላ አፋ ምንጋነ ያጋእንትዳ፥ ጳዉሎሳ፥ ኬሃን አሽከ ማቅደ ክርስቶሳ ሱንꬅተ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ታኒ ይንታጎ Ꮉንግዘ ዎደ ኑና አሾ ቆፋራ Ꮉንትዘ አስ ማህ ቆፕዘ አሱንꬃላ አፋ ምንꬂ ቃላራ ኦህንቶደስ ቆፋ አጭዳ። ይንታላ አፋ ይኒ ጋራ ኦህንቶደ ጋር ይን ታና ቆፓመ ፋና ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","ኑኒ Ꮉና ሳእተ የዝኮን ሳአ አስ ፋና ኦልንቶስ። ");
INSERT INTO oyde_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ኑ ኦላ ሚሽታ Ꮉና ሳአስቶ ባያ። የዝን ሹች ግንብቶ ላሎደስ ዎልቃር የዘ ጾዘ ቶራ። ቱሮራ ኦልንትዘ ላለን፥ ");
INSERT INTO oyde_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ጾዝ ኤራመ ጋር ደንድዙንꬃናን ቱርራ ኦልንትዘ ኡቱራ ቆፋ ኡባ ኑ ላሎዳ። አስ ቆፋ ኡባ ድእ ክርስቶሳስ ኪትንቶደ ጋር ኑ ዪሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ይን ኪትንትዛና ፎሎ ማቅዘ ዎደ ኑኒ ኪትንቶሱንꬃና ኡባ ሴሮደስ ጊግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","ይን በእዛና ባለራ በንትዘ ባዝ ጻላላ። ኦደን ፋና ክርስቶሳ ባዝ ጋእ ቆፕዘባዝ ማቅኮ፥ ኑንን ክርስቶሳ ባዝ ማቅዛኖ ኤሮ። ");
INSERT INTO oyde_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ላꬂ ታስ እንግደ አደትꬅ ዎልቂተ ጬቅንትኮን ይነ ዬልꬎኦስ። ይና አደትꬅ ዎልቅታ ታስ እንግንትዳና ይንታና ድቾደስ ፋትን ላሎደስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ታኒ ታ ዳብዳብተ ይንታና ይርግሳደስ ኮይ ጻፍደባዝ አዝፐ። ");
INSERT INTO oyde_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","ፈቲ ፈቲ አሱንꬅ፥ «ጳዉሎሳ ዳብዳቢታ ዴጾን ዎልቃማ፥ የዝን ኤ ፋ ኦምትስ ኑራ የዘ ዎደ ቦዛ፤ ኤ ኦህታን ፋꬆስ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","የንꬅ አሱንꬅ ኑ Ꮉኮ የዛራ ጻፍደ ዳብዳብዘ ካለ ይንታራ የዛራ ኦችዘ ኦችት ግዳ ዱማትꬅ ባይዛኖ ቆፖ። ");
INSERT INTO oyde_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ኑኒ ፋና ናሽዘ አሱንꬃራ ኑና ልክሳደስ ዎይ ዎልክሳደስ ኮዮስ። የዝን ኡን ፋና ፋራ ልክዚ ዎይ ዎልክዚ ብእተራ ኤያ። ");
INSERT INTO oyde_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","የዝን ኑኒ ጾዚ ኑስ እንግደ ዉዝልተ ጬቅንቶዳ ፋትን ዉዙላ ፊንግ ጬቅንቶስ፤ ይና ዉዙልታ ይንታጎን የላነ። ");
INSERT INTO oyde_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ኑኒ ኮሽዛንፓ አꬂ ጬቅንቶስ፥ የዝን ክርስቶሳ ዎንገለ ቲኒ ይንታጎ የልꬅዳነ ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ኑኒ ጾዚ ኤስደ ዉዙላፓ ፊንግ፥ መሉንꬅ ኦችደ ኦችተ ጬቅንቶስ። ማቆየዝን፥ ይን አማንታ ድጮደ ፋና ጾዚ እንግደ ዉዙልተ ይን ግዳ ኑ ኦችዘ ኦችታ ዳልጎዳ ጋእ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ኑኒ መለ አስ ፋ ዉዙልተ ኦችደ ኦችተ ገሊ ጬቅንቶስ፥ የዝን ይንታፓ ፊንግ መሉንꬅስ ዎንገለ ማርክꬋደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","የዝን፥ ጌሽ ማጻፍተ፥ «ጬቂዘ ኡባ ላꬃላ ጬቆ» ጋእ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ላꬂ ናሽዘ አꬃ ፋትን ፋና ፋስ ናሽዘ አꬄ ናሽንቶስ። ");
INSERT INTO oyde_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ታ ኤራꬅ ኤያትꬅቶ ይን Ꮉተን ዳንዳኦዳ ጋእ ቆፓነ፤ አደ ዳንዳኦተ። ");
INSERT INTO oyde_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","ጾዚ ይንታና ቡዞ ማሆደስ ቆፕዳንጋራ፥ ታንን ይንትስ ቆፓነ። ታኒ ይንታና ጌሽ ዉዱርትጋራ ፈቲ ꬊራ፥ ክርስቶሳስ እንጎደስ ኦጪ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","የዝን ሾሽ ፋ ገነራ ሄዋኖ ባልꬅዳንፋና ኦደ ኤርዘ ይን ዎዝንታ ኢቲ ክርስቶሳስ የዘ ይን ሱረትꬅቶን ጌሻትꬅቶ ላሞድ የሳነ ጋእ ይርጋነ። ");
INSERT INTO oyde_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","ፈቲ አስ ይእ፥ ኑኒ ይንትስ ማርክꬍደ የሱሳፓ መለ የሱሳ ይንትስ ማርክꬍኮ፥ ዎይ ይን ኤክደ አያንዘፓን ዎንገልዘፓን መለ አያናን ዎንገለን ይንትስ ኦህኮ፥ ስእ ጋእ አꬃነ። ");
INSERT INTO oyde_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","የዝን ታኒ የሱሳ «ዳማ ሐዋሩንꬃፓ» ላፋነ ጋእ ቆፖስ። ");
INSERT INTO oyde_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ታኒ ኦሄ ኤሮሰ አስ ማቅኮን፥ ኤራትꬅ ታስ የነ። ይኖ ታ ይንትስ ጋማ ኦገራን ጋማ ባዛራ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ታኒ ሚሸ ኦጭካይዛራ ጾዘ ዎንገለ ይንትስ Ꮉሪ ኦህዳናን ይንታና ꬎቅ ዪዚ ታና ቶችዳና ታስ ናጋራ ማቃነ? ");
INSERT INTO oyde_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ታኒ ይንትስ ኦቾደስ መለ ዎሳ ኬꬃፓ ሚሸ ቦንቂ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ታ ይንታራ የዘ ዎደ ታና ማꬍኮን ይንታፓ ፈቲ አስን ዋይስካያ። መቀዶንያፓ ይእደ አማንዙንꬅ ታና ኮሽዘ ባዝ ኡባ ማድዳ። Ꮉይኖ የሎደስ ታ ይንትስ ቶፎ ማቅካያ ቲኖስን ቶፎ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ክርስቶሳ ቱረትꬅታ ታ ግዳ የዝን፥ ታ ጬቅቶ አካያ ጋደ ታና ኦደን ካዮስ። ");
INSERT INTO oyde_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ታ Ꮉኖ አኮስ ጋኤ? ይንታና ካꬎኦሰ ግሾስነ? ታኒ ይንታና ካꬍዛኖ ጾዚ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","«ኑንን ይን ፋና ኦቻነ» ጋእ ጬቂዘ Ꮉንኮ ሐዋሩንꬅ ጬቆ ምክናቶ ꬋብሶደስ Ꮉተ ታ ኦችዛኖ ቲኖስን ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Ꮉኒ ጋርዘ አሱንꬅ ክርስቶሳ ሐዋረ አዞደስ ፋና ላምዘ ዎርዳንቾ ሐዋሩንꬃናን ጭምዘ ኦቻንቾ። ");
INSERT INTO oyde_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ይና ዳማ ቆፍዘ ባዝ ባያ፤ አኮስ ጋይኮ፥ ጻላሄ ፎኦ ኪታንቾ ፋና ይአደስ ፋና ላማነ። ");
INSERT INTO oyde_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ይኒ ግሾ፥ ጻላሄ ኦቻንቹንꬅ ጽሎትꬅ ኦቻንቾ ፋና ይአደስ ፋና ላምኮ ይና ዳማ ባዝ ባያ። ኡን ዉርሱꬅተ ፋ ኦችትጋራ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","ኦደን ታና ኤያ ጋእ ቆፓመ ፋና ማህ ኦህነ። ታ ይንትስ ኤያ አዝኮን ታ ኤራꬅ ጬቅንቶደ ፋና ታና ኤያ ማህ ኤኮተ። ");
INSERT INTO oyde_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ታኒ Ꮉንጋራ ጬቅንቲ ኦህዘ፥ ላꬄ ኮይዛንጋራ ማቅካይዝን ኤያትꬃራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ጋማ አሱንꬅ Ꮉና ሳአ ባዝተ ጬቅንትዘ ግሾ ታንን ጬቅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ይን ዎዝናማ ማቅደ ግሾ ኤያ አስ ባዝ ኡፋይሳራ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ኦደን ይንታና አርዝኮ ዎይ ይንታና ቦንቅኮ ዎይ ፋስ ማድንቶደስ ይንታጎ ሺቅኮ ዎይ ይንታላ አፋ ኡቱርትኮ ዎይ ይንታና ባቂኮ ይን ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","ኑኒ ይኖ ኦቾደስ ጋማ ቦዛ ማቅዛኖ ዬልꬍተራ ታ ኦህነ። የዝን ኦደን ሚንግ ጬቂንትኮ፥ ታንን ጬቂንቶደስ ምንጋነ። ታኒ ይኖ ኤያ አስ ፋና ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ኡን ዕብራዌ? ታንን ዕብራዌ። ኡን እስራኤለ? ታንን እስራኤለ። ኡን አብራሃማ ኮቾ? ታንን አብራሃማ ኮች። ");
INSERT INTO oyde_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ኡን ክርስቶሳ ኦቻንቾ? ታኒ ዣሽትዘ አስ ጋር ኦህነ፥ ኡንታፓ አꬍዘ ክርስቶሳ ኦቻንቾ። ታኒ ኦቻራ ጋማ ላቢዳ፤ ጋማ ዎደ አጭንትዳ፤ ጋራፍንትዳ፤ ጋማ ዎደ Ꮉይቆፓ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","አይሁዱንꬅ ታና Ꮉስታም ኡዱፉን እችን ቶሄ ጋራፍዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Ꮉይꬕ ቶሄ ጉፈራ ጉድንትዳ፤ ፈቲ ቶሄ ሹቻራ ꬎግንትዳ፤ ማርካበ Ꮉይꬕ ቶሄ መቂዳ፤ አባ ግዳ ፈቲ ቃማ ኩሙꬅ አቂ ፌዥዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ታኒ ጋማ ኦገ ላቢ የꬍዳ። ክጻ Ꮉꬃፓን ፋኖፓ አትዳ። አይሁዱንꬅን አይሁደ ማቆሰ አሱንꬅ ታላ አፋ ማꬋ የልꬅዳ። ካታማ፥ አኮ ባይዘ ጋናሳ፥ አባ፥ ታና ዣሽዳ፤ አማንዘ ፋና አዝዘ አሱንꬅ ታና ዋይꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ታኒ ኦቻራ ላቢዳ ጫውዳ፥ ጋማ ቶሄ ገንቶ ꬋብዳ፥ ናይꬍዳ፥ ባርꬍዳ፥ ጭሽትዳ፥ ካልꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","መለባዝ ኡባ ፋይድካይዛራ ኡባ ዎደ ታና ቆፍዛና ዎሳ ኬꬅ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","ፈቲ አስ ላቢዘ ዎደ ኤራ ታ ላቢካ? ፈቲ አስ ናጋራራ ꬉቡንትዘ ዎደ ታ አይደ ሸንꬍካይዛራ አሽዶ? ");
INSERT INTO oyde_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ታ ጬቅንቶደስ ኮሽዘ ባዝ ማቅዛኮ ታኒ ላቢዳ ማቅዛኖ ኤርስዘ ባዛራ ጬቅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","መꬍናስ ቦንችንትደ ጾዘ፥ ኑ ላꬄ የሱስ ክርስቶሳ አዳይ፥ ታ ዎርድꬎኦሳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ዳማስቆ ካታማ አረታሳ ጋዘ ካትዘፓ ኦሞር አህዘ ታና አይꬆደስ ኮይ ዳማስቆ ካታማ ፉርꬅቶ ናግዛነ። ");
INSERT INTO oyde_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","የዝን አሱንꬅ ታና ዳቾ ግዳ ኦሊ፥ ካታማ ሹች ግንብትስ ማስኮተራ ኬꬅን ታኒ ኤ ኩሽትፓ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ጬቅንተ ፋꬆሳኖ ታ ኤራነ። የዝን ጬቅንቶደስ ኮሽኮ፥ ላꬃፓ ኤክደ ቆንጭꬅተ ጬቆዳ። ");
INSERT INTO oyde_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ታጶ ኦይዲ በረፓ ቲኖ፥ ክርስቶሳ አማንዘ ፈቲ አꬄ Ꮉይꬓንꬆ ሳሎ ኤክንትዳኖ ታ ኤራነ። የ አꬄ አሾራ ዎይ አሾ ባይꬅ ቅተዛኮ ታ ኤሮስ፤ ጾዚ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","የ አꬄ ኤክንትዳኖ ኤራነ። የዝን ኤ አሾራ ዎይ አሾ ባይꬅ ኤክንተዛኮ ታ ኤሮስ፤ ጾዚ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","የ አꬄ ጋናተ ኤክንቲ አስ ቆንጭሳደስን አስ ኦሆደስ ዳንዳኦሰ ባዝ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","ታኒ የ አꬄራ ጬቅንቶዳ፥ ፋትን ታኒ ታ ላብꬅቶ ፋትን ታ ግዳ ጬቅንትዘ ባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ታኒ ቱርቶ ኦህንትዛን ግሾ ጬቅንቶደስ ኮይኮን ኤያ ባያ። የዝን አስ ታ ኦችዛኖ በእዛንፓን ስእዛንፓ አꬂ ቆፓመ ጋር ጋእ ጬቅንተ አሻነ። ");
INSERT INTO oyde_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ታስ ቆንጭደ ዳማ ቆንጭꬅተ ታ ኡቱርታመ ጋር ታና ዋይሶደስ ታ አሽቶ ዡልትዘ ጻላሄ ኪታንቾ ታስ እንግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Ꮉይ ዋይꬅዛያ ታፓ Ꮉሶደ ጋር ታኒ ላꬃ Ꮉይꬕ ቶሄ ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","የዝን ላꬂ፥ «ታ ዎልቅታ ነ ላብꬅትራ ቆንጭዘ ግሾ ታ አꬎ ከሃትꬅታ ኔስ ማቃዳ» ጋይዳ። ክርስቶሳ ዎልቅታ ታ ግዳ ቆንጮደ ጋር ታ ላብꬅተ ኡፋይትተራ ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ታኒ ክርስቶሳ ግሾ ላቢዘ ዎደ፥ ጫዥንትዘ ዎደ፥ ዋይንትዘ ዎደ፥ ባይእንትዘ ዎደ፥ ማꬍንትዘ ዎደ ታ ላብꬅተ ኡፋይታነ። አኮስ ጋይኮ፥ ታ ላቢዘ ዎደ የ ዎደ ምንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","ታኒ ኤያ አስ ፋና ጬቅንትዳ። ይኒ ጋራ ታ ጬቅንቶደ ፋና ኦችደ ይንታና። ታ፥ ታ ኦምተ ኤርንቶሰ አስ ማቅኮን፥ «ዳማ ሐዋሩንꬃና» ጋእንትዙንꬃፓ ኤሮስ። ይኖ ታስ ማርክꬋደስ ቤዘ ይንታና የሻ። ");
INSERT INTO oyde_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","ታ ይን ግዳ የዝተራ ዳንዳአራ ኦችደ ማላ ባዝታን ክለ ባዝታ ታ ቱሪ ሐዋረ ማቅዳኖ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","ታ ይንትስ ቶፎ ማቅካይዛራ አትዳንፓ መለ ዎሳ ኬꬃፓ ይን አኮራ ኤርዶ? ይና ባላ ማቅኮ ታና ማሮተ። ");
INSERT INTO oyde_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","ታኒ ይንታጎ Ꮉማደስ ጊግንቶደራ Ꮉና ታስ Ꮉይꬓንꬃ። ታ ይንታና ፋትን ይንትስ የዘ ባዝ ኮዮሰ ግሾ ይንታና ዋይꬆደስ ኮዮስ። የልዱንꬅ ፋ ናኡንꬅስ ቆሎ ምንጃነ ፋትን ናኡንꬅ ፋና የልዱንꬅስ ቆሎ ምንጆስ። ");
INSERT INTO oyde_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","ታ ይን ግሾ ታስ የዘባዝቶን ታናን አꬂ እንግኮን ታና ኡፋይሳነ። ዬዝን፥ ታኒ ይንታና ይኒ ጋራ አꬂ ሲቅዘ ዎደ ይን ታና ኤራꬅ ሲቃነ? ");
INSERT INTO oyde_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ማቅኮን፥ ታ ይንትስ ቶፎ ማቅካያ፤ ዋይꬅካያ፤ የዝን ይንታና ጭመራን ገነራን አይክደባዝ ይንትስ አዝካይዛራ አታማ። ");
INSERT INTO oyde_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","መለ አቶ የዝን፥ ታ ይንታጎ ኪትደ አሱንꬃፓ ይንታና ጭምደ አስ የነ? ");
INSERT INTO oyde_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ትቶ ይንታጎ ቅቶደ ጋር ታኒ ዎስዳ፤ ማህ አማንዘ እሻ ኤራ ዳክዳ። ዬዝን፥ ትቶ ይንታና ጭምዳ? ኑኒ ኑ ኦችቶ ፈቲ አያናራ ኦችካነ? ማህ ኑ Ꮉንታን ፈቶ ባነ? ");
INSERT INTO oyde_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","ኑ ኡባ ዎደ ይን ቲኖ ኑና ጽልሳደስ ሞትንቶደባዝ ይንትስ አዛነ? ኑ ክርስቶሳ ግዳ የዚ ጾዘ ቲኖ Ꮉኖ የሎደስ ኦህነ። ኑ ሲቆ እሹንꬆ፥ ኑ Ꮉኖ ኡባ ኦችዛና ይንታና ድቾደስ። ");
INSERT INTO oyde_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","ታ ይንታጎ Ꮉንግዘ ዎደ ኦደ ኤርደ ይን ታ ኮይዛንጋራ ይአንጽኮ፥ ማህ ታንን ይን ኮይዛንጋራ ይእ የልንታንጽኮ ጋእ ዣሽታነ። ማህ ኦደ ኤርደ ይን ግዳ ላለ፥ ቃናተ፥ ዥሎ፥ ፋና ካ፥ ዝግርስ፥ አስ ሱንꬅ ኢሰ፥ ኡቱራን ካችን የዛንጽ አታማ ጋእ ዣሽታነ። ");
INSERT INTO oyde_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ታኒ ላምእንꬃ ይንታጎ Ꮉንግዘ ዎደ ጾዚ ይን ቲኖ ታና ዬልሳዳ ጋእ ዣሽታነ። ዛጋ ናጋርቶ ኦቺ ይና ፋ ኦችደ ቱናትꬃፓ፥ ኦላለ Ꮉንታፋን ዬልዘ ኦቻፓ ማቅካይዘ አሱንꬃና ብእ አዛንካይዛራ አሾስ ጋእ ዣሽታነ። ");
INSERT INTO oyde_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ታ ይንታጎ Ꮉንጎደራ Ꮉና Ꮉይꬓንꬆ። አኮ ሞቶን ላምእ ዎይ Ꮉይꬕ ማርካራ ምንጋነ። ");
INSERT INTO oyde_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ታኒ ላምእንꬃ ይንታራ የልንትዘ ዎደ ይን ግዳ ቲኖ ናጋራ ኦችደ አꬃን መሉንꬃና ኡባ ሴርካይዛራ አሾስ ጋእ ኦህ ጋድዳ። Ꮉተ ታ Ꮉኪ የዝኮን ማቂ ይንታጎ Ꮉንግዘ ዎደ ኦደስን ይቅስንቶስ። ");
INSERT INTO oyde_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ታ ግዳ የዚ ኦህዘ ክርስቶሳ ማቅዛኖ ይን ኤሮደስ ኮያነ። ኤ ይንታራ ኦህንትዘ ዎደ ዎልቃማ ፋትን ይን ግዳ ቦዛ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","ክርስቶሳ ማስቃላላ አፋ ዋየራ ሱጽንትዳ፥ የዝን ጾዘ ዎልቂተ ደኦ የነ። ኤ ቦዛ ማቅዛንጋራ፥ ኑንን ቦዛ። የዝን ይንታና ማዳደስ ጾዘ ዎልቂተ ኤዛራ ደኦ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","አማኖራ ሚንግ የዛኮ ይንታና ይንትስ ፋታኒ ቦኦተ። ፋታንተ ይን ጎልአንጽ አትኮ፥ ክርስቶሳ ይን ግዳ የዛኖ ይን ኤራነ። የዝን ክርስቶሳ ይንታራ የዛንጽኮ ይን ጎልኦዳ። ");
INSERT INTO oyde_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","ኑኒ ፋታናራ ጎልአማኖ ይን ኤራነ ጋእ ኑ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ይን ኢታ ባዝ ኦቻመ ፋና ኑኒ ጾዝ ዎሳነ። ኑኒ ምንꬂ ማቅዛኖ አስ በአደ ፋና ማቅካይዝን ኑኒ ምንꬂ ማቃንጽን፥ ይን ሎኦ ኦቾደ ጋር ኑኒ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","ኑኒ ቱርስ ኦቻነ ፋትን ቱርራ እጽንትዘባዝ አኮ ባዝን ኦቾደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ኑ ላቢዘ ዎደ ይን ማህ ሚንጎደራ ኑና ኡፋይሳነ። ይን ቦረ ባይዙንꬃና ማቃደ ጋር ኑ ይንትስ ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ታኒ ይንታፓ Ꮉኪ የዝተራ ጻፍዳና ይኒ ግሾስ። ታኒ ይንታጎ Ꮉንግዘ ዎደ ላꬂ ታስ እንግደ አደትꬅ ዎልቂተ አማንንቲ ይንታላ አፋ ላꬅꬋደስ ኮዮስ። ላꬂ ታስ ዎልቃ እንግዳና፥ ይንታና ማዶደስ ፋትን ቆሆደስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","ዉርሱꬅተ ታ እሹንꬆ፥ ሳሮ የዞተ። ቦረ ባይꬅ የዞተ፤ ታ ዞርቶ ስኦተ። ፈቲ ዎዝናራ ማቂ የዞተ፤ ሳሮራ የዞተ። ሲቆን ሳሮ እንግዘ ጾዘ ይንታራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","ጌሽ ዬርንተ ዬርንትተራ፥ ፈተ ፈታ ሳርꬆተ። ");
INSERT INTO oyde_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","ጾዘ አሱንꬅ ኡባ ይንታና ሳሮ ሳሮ ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ላꬄ የሱስ ክርስቶሳ አꬎ ኬሃትꬅ፥ ጾዘ ሲቆ፥ ጌሽ አያና ፈተትꬅ ይን ኡቡንꬃራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","አሳፓ ዎይ አስ ባጋራ ማቅካይዝን የሱስ ክርስቶሳፓን ኤዛ Ꮉይቆፓ ደንꬅደ ጾዘ አደፓ ሐዋረ ማቃደ ጋር ኪትንትደ ታ ጳዉሎሳ፥ ");
INSERT INTO oyde_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ታራ የዘ አማንዘ እሹንꬅ ኡባ፥ ጋላትያ የዘ ዎሳ ኬꬁንꬅስ። ");
INSERT INTO oyde_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","ጾዘ ኑ አዳይን ኑ ላꬄ የሱስ ክርስቶሳፓ ይንትስ አꬎ ኬሃትꬅን ሳሮትꬅ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Ꮉና ኢታ ዎድትፓ ኑና አሾደስ፥ ኑ ላꬄን፥ ኑ አዳይ ቆፋ ፋና ክርስቶሳ ኑ ናጋርት ግሾ ፋና አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ጾዝስ መꬍናፓ መዽና የሎደስ ቦንቾ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ክርስቶሳ አꬎ ኬሃትꬅተ ይንታና ጼግደ ጾዛ አሺ፥ መለ ዎንገለጎ፥ ይን ኤልሲ፥ ዋይዝ ማቀዛኮ ታና ጋማ ቆፍዛነ። ");
INSERT INTO oyde_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ኤ ፋ ኦምተ መለ ዎንገለ ባያ። ይንታና ባልꬆደስን ክርስቶሳ ዎንገለ ዎቢሳደስ ኮይዘ ኤራꬅ አሱንꬅ የነ ፋትን ቱሪ ዎንገለ ፈቶ። ");
INSERT INTO oyde_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","የዝን ኑና ማቅን ዎይ ሳሎ ኪታንቾ ማቅን ኑ ይንትስ ቲኖ ኦህደ ዎንገለፓ ዱሙዽዘ ዎንገለ ይንትስ ኦህዘ ባዝ ማቅኮ፥ ኤ ባድንትዳ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Ꮉንፓ ዛጋ ኑ ጋይዳንጋራ Ꮉተን ማህ ጋነ፤ ይን ኤክደ ዎንገለፓ ዱሙዽዘ ዎንገለ ኦደን ይንትስ ኦህኮ የ አꬄ ባድንትዳያ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ዬዝን፥ ታና አስ ዎይ ጾዚ ናሾደ ፋና ኮያነነ? ዎይ ታ አስ ኡፋይሶደስ ኮያነ? ታ አስ ኡፋይሶደስ ኮይዘ ባዝ ማቅኮ፥ ክርስቶሳ አሮ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","ታ እሹንꬆ፥ ታ ይንትስ ኦህዘ ዎንገልታ አሳፓ ማቆሳኖ ይን ኤሮደ ፋና ታ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ታስ Ꮉይ ዎንገልዛ የሱስ ክርስቶሳ ቆንጭዝዳ ፋትን አሳፓ ኤክካያ ዎይ አስ ታና ታማርስካያ። ");
INSERT INTO oyde_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ታ ዛጋ አይሁደ አማኖ የዘ ዎደ ዋይዝ የዘዛኮ፥ ታኒ አማንዙንꬃና ይቅስሞ ባይꬅ ባይአደስን ꬋብሶደስ ቡቱንትዳኖ ይን ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","አይሁደ አማኖ ናጎራ፥ ታ ዎደ የዘ አይሁደ እሹንሳፓ አꬋነ። ኑ አዱንꬅ ዎግትስን አꬊ ይቅስንታነ። ");
INSERT INTO oyde_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","የዝን ታ Ꮉጋ ታ እንቲ ሳዝተ የዝን ጾዚ ታና ዶርዳ፤ ፋ አꬎ ኬሃትꬅተ ታና ጼግዳ። ");
INSERT INTO oyde_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","አይሁደ ማቆሰ አሱንꬅስ ዎንገለ ኦሆደ ጋር ጾዚ ፋ ናአያ ታስ ቆንጭዝደ ዎደ ታ ኦደራን ዞርንትካያ። ");
INSERT INTO oyde_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","ዎይ ታፓ ቲኖ ሐዋረ ማቅዱንꬃራ የልንቶደስ የሩሳላመ Ꮉንግካያ። የዝን ታ ቲንꬊ አራበ ጋደ ቅትዳ፤ ይንፓ ማቂ ዳማስቆ ካታማ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Ꮉይꬕ በረፓ ሱባ፥ ጴጥሮሳራ የልንቶደስ የሩሳላመ Ꮉንግ ኤራ ታጶ እችን ቃማ ጋምእዳ። ");
INSERT INTO oyde_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","የዝን ላꬄ እሸ ያይቆባ ፋትን Ꮉንኮ ሐዋሩንꬃፓ ኦናን ታ ብእካያ። ");
INSERT INTO oyde_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ታ ይንትስ ጻፍዳና ዎርዶ ማቆሳኖ ጾዘ ቲኖ ይንትስ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ይንፓ ሱባ፥ ታኒ ሶርያን ክልቅያ ጋደ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ይሁዳ የዘ ዎሳ ኬꬅ አሱንꬅ ታና ኤርካያ። ");
INSERT INTO oyde_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","የዝን ኡን፥ «ዛጋ ኑና ባይእዘ አꬄ፥ Ꮉተ ይና ኤ ꬋብሶደስ ኮይዘ አማንቶ ሳባካነ» ያጋዛኖ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ስእዱንꬅ ኡባ ታ ግሾ ጾዛ ጋላትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ታጶ ኦይዲ በረፓ ሱባ፥ ማህ ባርናባሳን ትቶ ኤኪ የሩሳላመ Ꮉንግዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ታ Ꮉንግዳናን ጾዚ ታስ ቆንጭዝደ ኦገራ። Ꮉንፓ ቲኖ ዛጋ ታ ኦችዳናን Ꮉተ ታ ኦችዛና ጨር ማቃመ ፋና አይሁደ ማቆሰ አሱንꬅስ ሳባክዳ። ዎሳ ኬꬅ ካልꬅዙንꬃና ጋእ ጼግንትዙንꬃና ዱማ ሺሺ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","መለ አቶ የዝን፥ ታራ የዘ ትቶ ግርኬ አስ ማቅኮን፥ ጋራዝንቶደ ጋር ጋእ ኡንእꬅካያ። ");
INSERT INTO oyde_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","የዝን፥ አሮ ኑና ማሆደስን ክርስቶስ የሱሳ ግዳ የዘ ኑ ዋሎትꬅቶ ጌድተራ ኑ ግዳ አችንት ገልደ ዎርዶ እሹንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","የዝን ቱሪ ዎንገለ ይን ግዳ ሚንግ ጻጲ የሳደ ጋር ኑኒ መለ አቶ የዝን፥ ፈቲ ሳተን ኡንትስ ኩሸ እንግካያ። ");
INSERT INTO oyde_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","የዝን Ꮉላቃ አዝዘ አሱንꬅ ኦደትꬅታ ታስ አኮን ባያ። ጾዚ አስ ስኖ ብእ ፍርዶስ። Ꮉንꬅ አሱንꬅ ታ ማርክꬍዘ ዎንገለላ አፋ ፈቲ ባዝን ጉጅካያ። ");
INSERT INTO oyde_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","የዝን ጴጥሮሳ፥ አይሁዱንꬅስ ዎንገለ ኦሆደ ፋና ጾዚ ኤስ Ꮉዳራ እንግዳንጋር ታስን አይሁደ ማቆሰ አሱንꬅስ ዎንገለ ኦሆደ Ꮉዳራ እንግዳኖ ኡን ሱባፓ ቲርዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ይኬ፥ ጴጥሮሳ አይሁዱንꬅ ሐዋረ ማቃደ ፋና ኦችደ ጾዘ፥ ታናን አይሁደ ማቆሰ አሱንꬅስ ሐዋረ ማቃደ ፋና ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ማህ ታስ እንግንትደ አꬎ ኬሃትꬅቶ ቆፕደ ቱስ ማቂ በንትዘ ያይቆባ፥ ጴጥሮሳን ዋሐንሳ፥ ኑና አይሁደ ማቆሰ አሱንꬃጎ፥ ኡን አይሁደ አሱንꬃጎ ቅቶደስ ታናን ባርናባሳን ማዶደስ ምዛቅ ኩሸ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ኡን ኑና ምንꬂ Ꮉዳራ ጋይዳና፥ ኑኒ ዳሁንꬅስ ቆፖደ ፋና። ቲኖን ታ ይኖ ኦቾደስ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ጴጥሮሳ አንጾክያ ካታማ ይእደ ዎደ ኤ ባልደ ግሾ ታኒ ኤ ቲንተ ኤቂ «ኔኒ ባልዳ» ጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ያይቆባ ኪትደ ፈቲ ፈቲ አሱንስ አንጾክያ ዮኦደፓ ቲኖ ኤ አይሁደ ማቆሰ አማንዙንꬃራ ሙእነ፥ የዝን ኡን ይእዳንፓ ሱባ፥ «አይሁደ ማቆሰ አሱንꬃፓ አማንዱንꬂ ጋራዝንቶደስ ቤዛነ» ጋዘ አሱንꬅስ ዣሽቲ ኡንታፓ ሻክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","ፈቲ ፈቲ አማንደ አይሁዱንꬅ ጴጥሮሳ ኦችተ ካልዳ። መለ አቶ የዝን፥ ባርናባሳን ይና ቆፍተ ጊግዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","የዝን ኡን ዎንገለ ቱርራ ሉለ የꬎሳኖ ብእ፥ ጴጥሮሳ አስ ኡባ ቲኖ፥ «ኔኒ አይሁደ ማቅተራ፥ አይሁደ ዎጋ ፋና ማቅካይዝን አይሁደ ማቆሰ አሱንꬅ ፋና የነ፤ ዬዝን፥ ዋይዝ አይሁደ ማቆሱንꬃና፥ ‹አይሁደ ዎጋራ የዞተ› ጋእ ዎልቂ?» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ኑኒ የልንተራ አይሁደ፥ የዝን ናጋራንቾ ማቅደ አይሁደ ማቆሰ አሱንꬅ ፋና ባያ። ");
INSERT INTO oyde_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","የዝን አስ የሱስ ክርስቶሳ አማኒ ጽላነ ፋትን ህገ ናጊ ጽሎሳኖ ኤራነ። ኦደን አሾ ማእደ ኡባ ህገ ናጊ ጽሎሰ ግሾ ኑንን ህገ ናጊ ማቅካይዝን ክርስቶሳ ግዳ አማኒ ጽሎደስ ክርስቶስ የሱሳ አማንዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ኑ አይሁዱንꬅን ክርስቶሳ ባጋራ ጽሎደስ ኮሻነ። ይኖ ማቅኮ ኑንን መለ አሱንꬅ ፋና ናጋራንቾ ማቅዛኖ በእነ። ዬዝን፥ ኑ ናጋራ ኦቾደ ፋና ደንꬅꬅዘ ክርስቶሳ ጋእንታነነ? ሙሎን ባያ! ");
INSERT INTO oyde_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","ይኬ፥ ታ ዉልእዳኖ ማህ ኬጽዘባዝ ማቅኮ ታኒ ታ ኦምተ ህገ መንꬅዛያ ማቅዛኖ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ታኒ ጾዝስ ደኦ ማቂ የሳደ ፋና ህገ ባጋራ ህገስ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ታኒ ክርስቶሳራ ማስቃላላ አፋ ሱጹንትዳ። ታኒ ይኬፓ ታስ የዞስ፥ የዝን ክርስቶሳ ታ ግዳ የነ። ታ Ꮉተ አሾራ የዘ የስቶ፥ ታና ካꬊ ታ ግሾ ፋና አꬂ እንግደ ጾዘ ናአ አማኒ የነ። ");
INSERT INTO oyde_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ታኒ ጾዘ አꬎ ኬሃትꬅቶ ጨር አሾስ። ጽሎትꬅ አስስ ህገ ባጋራ በንትዘ ባዝ ማቅዛኮ፥ ክርስቶሳ Ꮉሪ Ꮉይቂዳ ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Ꮉንꬅ፥ ቆፖሰ ጋላትያ አሱንꬆ፥ ይን ኣፍት ቲንተ ክርስቶሳ ማስቃላላ ሱጹንትደ ስእለ ፋና ቆንጪ በንታነ። ዬዝን፥ ቱርስ ይን ኪትንታመ ፋና ይንታና ዶጭዝደ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ታ ፈትባዝ ኤሮደስ ኮያነ፤ ይን ጌሽ አያና ኤክዳና ህገ ናግነ ዎይ ዎንገለ ቃላ አማኒ ኤክዳተ? ");
INSERT INTO oyde_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","ይን ይኒ ፋና ቆፖሱንꬃና? ይን ጾዘ አያናራ አይኪ፥ Ꮉተ አሾራ ፎሎደስ ኮያነ? ");
INSERT INTO oyde_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ይን ዎንገለ ባጋራ ጋማ ዋይዳና Ꮉሪ? ይና ዋይታ ኡባ ጨር ማቅዳ? ");
INSERT INTO oyde_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ጾዚ ይንትስ ጌሽ አያና እንግዳናን ይን ግዳ ክሌ ባዝ ኦችዛና፥ ይን ህገ ናግደ ግሾነ ዎይ ዎንገለ ስእ አማንደ ግሾ? ");
INSERT INTO oyde_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","አነ አብራሃማ ቦኦተ፥ «ኤ ጾዝ አማንዳ፤ ጾዚ ኤስ ይኖ ጽሎትꬅ ማህ ፋይድዳ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ይኬ፥ አማንዙንꬅ አብራሃማ ናኡንꬃና ማቅዛኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","ጾዚ አይሁደ ማቆሰ አሱንꬃና አማኖራ ጽልሳዳኖ ቲኖ ጌሽ ማጻፈ ብእ፥ «ዎርዣ ኡባ ኔራ አንጅንቶዳ» ያጋእ፥ ዎንገለ አብራሃማስ ቲንꬊ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ይኒ ግሾ፥ አማንዘ ኡባ አማንደ አብራሃመራ ዎላ አንጅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","ህገ ናጊ ጽሎዳ ጋዘ ኦደን ባድꬅ ግዳ የነ። አኮስ ጋይኮ፥ ጌሽ ማጻፍተ፥ «ህገ ማጻፍተ ጻፍንትዳነ ኡባ ሚንግ የዞሰን ኦቾሰ ኦደን ባድንትዳያ ማቆ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","«ጽሎ አማኖራ የሳዳ» ጋእንት ጻፍንትደ ግሾ ኦደን ጾዘ ቲኖ ህገ ናጊ ጽሎሳና ኤርንትደባዝ። ");
INSERT INTO oyde_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ህገ አማኖፓ ባያ። የዝን፥ «ህግቶ ናግዘ ኦደን እዞ ካሎዳ» ያጋእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","«ምንጻላ አፋ ሱጹንት Ꮉይቂደ ኦደን ባድንትዳያ» ጋእንት ጻፍንትዳ። ክርስቶሳ ኑ ግሾ ባድንተዛያ ማቂ፥ ኑና ህገ ባድꬃፓ ዎዝዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ጾዚ አብራሃማስ እንግደ አንጅታ፥ የሱስ ክርስቶሳ ባጋራ አይሁደ ማቆሰ አሱንꬃና የሎደ ፋናን ጾዚ እንጎዳ ጋይደ ጌሽ አያና ኡፋይስ አማኖራ ኤኮደ ፋና ይኖ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","ታ እሹንꬆ፥ ታ ይንትስ አስ ደኦ ዱሰ ማቂ የዘ ባዝ አዝዘ ማህ ኦህነ። አስ ጫቂደ ጫቅታ ሚንግዳንፓ ሱባ፥ ኦደን ይና ጫቅቶ ሻሮደስ ዎይ መለ ጉጆደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ጾዚ ይና ኡፋይስ ቃልቶ አብራሃማስን ኤ ዛሩንꬅስ እንግዳ። ጌሽ ማጻፍተ፥ ጋማ አስስ ኦህዘ ፋና፥ «ነ ኮቹንꬅስ» ጋኦስ። የዝን ፈቲ አስስ ኦህዘ ፋና፥ «ነ ኮችትስ» ያጋይዳ፤ ኤዝን ክርስቶሳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ታኒ ጋዛና Ꮉኖ፤ ኦይዲ ጼት Ꮉስታም በረፓ ሱባ እንግንትደ ህግታ፥ ቲኖ ጾዚ ምንꬅደ ጫቅቶ ሻሪ ኡፋይስ ቃልቶ ꬋብሶደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ጾዚ እንግዘ ላትታ ህገራ ኤክንትዘባዝ ማቅዛኮ ጾዚ እንግደ ኡፋይስ ቃላ ባጋራ ማቅዛና አታነ። የዝን ጾዚ ፋ አꬎ ኬሃትꬅተ ላታ አብራሃማስ ኡፋይስ ቃላ ባጋራ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","ዬዝን፥ ህገ አኮስ እንግንትዶ? ህገ እንግንትዳና፥ አብራሃማስ ኡፋይስ ቃላ እንግንትደ ኮችታ የኦደ ዎንꬅስ ኢታ ኦቻ አኮ የዛኮ ቤሳደስ። ህገ ኪታንቾ ባጋራ እንግንቲ፥ ግዳ ማቂ ጊግዘ ፈቲ አስ ባጋራ ኦቻላ አፋ ፌዥዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","ግዳ ማቂ ጊግዘ አꬄ ላምእ ዛላስ ኦቻነ ፋትን ፈተስ ባያ፥ የዝን ጾዚ ፈቶ። ");
INSERT INTO oyde_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","ዬዝን፥ ህገ ጾዘ ኡፋይስ ቃላ እጻነነ? አደ! ህገ እንግንትዳና አስስ ደኦ እንጎደስ ማቅዛኮ፥ ቱሪ ጽሎትꬅ ህገ ባጋራ ማቃድየሻ። ");
INSERT INTO oyde_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","የዝን የሱስ ክርስቶሳ አማንን በንትዘ ኡፋይስ ቃልቶ አማንዙንꬅስ እንግንቶደ ፋና ኩሙꬅ አላምታ ናጋራስ ኦሞራ የዛኖ ጌሽ ማጻፍተ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","የዝን አማኖ የኦዳንፓ ቲኖ ህገራ አጭንቲ የነ የሻ። ይና አማንታ ቆንጮደ ዎንꬅስ ህገራ ናግንቲ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ይኒ ግሾ፥ ኑኒ አማኖራ ጽሎደ ፋና ክርስቶሳ የኦደ ዎንꬅስ ህገ መለ አስ ናአ ናግዘ አስ ፋና ኑና ናግዛያ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","የዝን Ꮉተ አማኖ ይእደ ግሾ ህገ ይኬፓ ሱባ መለ አስ ናአ ናግዘ አስ ፋና ኑና ናግዛና አትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","ይን ኡቡንꬅ የሱስ ክርስቶሳ አማኒ ጾዝስ ናኡንꬃና ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ክርስቶሳራ ፈቶ ማቃደስ ጻማቅንትደ ኡቡንꬅ ክርስቶሳ ማእዳ። ");
INSERT INTO oyde_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ይን ኡቡንꬅ ክርስቶሳ ግዳ ፈቶ ማቅዘ ግሾ አይሁደ አሱንꬅ ግዳን ግርኬ አሱንꬅ ግዳ፥ አሮ ግዳን ቦንቾ አስ ግዳ፥ ꬊራꬅ ግዳን ማች ግዳ ዱማትꬅ ባያ። ");
INSERT INTO oyde_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","ይኬ፥ ይን ክርስቶሳስ ማቅኮ ይን አብራሃማ ኮች። ጾዘ ኡፋይስ ቃልት ፋና ይን ላትዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ታ ጋዛና Ꮉኖ። ላትዛይ ናአ ማቂ የዘ ዎደ፥ ኡባ ባዝስ ላꬂ ማቅኮን፥ አሮፓ አኮን ዱሙꬎስ። ");
INSERT INTO oyde_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","የዝን ኤ አዳይ ጋይደ ዎደ የሎደ ዎንꬅስ ኤ Ꮉዳርቶ ኤክዱንꬅ ኩሸን ናግዙንꬅ ኩሸ የነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","ይኒ ጋራ፥ ኑኒ ናአትꬃ የዘ ዎደ አላመ ቲኖ ዎጋስ Ꮉርንቲ አርꬊ የነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","የዝን ዎድታ የልደ ዎደ ጾዝ ህገፓ ኦሞራ፥ ማችፓ የልንትደ ፋ ናአያ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ኤ ይኖ ኦችዳና፥ ህገስ Ꮉርንቲ የዙንꬃና ዎዞደስን ኑና ፋ ናአ ማሆደስ። ");
INSERT INTO oyde_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ኑ ጾዘ ናአ ማቅዘ ግሾ «አቦ፥ አባባ» ጋእ ጼግዘ ፋ ናአይ አያና ኑ ዎዝንት ግዳ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ይኒ ግሾ፥ ይኬፓ ኔኒ ጾዘ ናአ ፋትን አሮ ባያ። ኔኒ ኤ ናአ ማቅኮ፥ ክርስቶሳ ባጋራ ጾዝ ላትዛ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ይን ዛጋ ጾዛ ኤሮሰ ዎደ ፋ Ꮉኖትꬅተ ጾዝ ማቆሱንꬅስ አሮ ማቂ አቅዳ። ");
INSERT INTO oyde_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","የዝን Ꮉተ ይን ጾዛ ኤርዳ፤ አꬂ ጾዛራ ኤርንትዳ። ዬዝን ማህ ፋꬆሰን ማዶሰ አላመ ዎጋጎ ሱባ ዋይዝ ማቅዳተ? ዎꬊ ኤቂ፥ ዋይዝ ኡንትስ ማህ አሮ ማቃደስ ኮየተ? ");
INSERT INTO oyde_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","ዱሙዽደ ቃማስ፥ አግናስ፥ ዎደስን በረስ ይን ዱሙዝ ሎይꬂ ቦንቾ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ኦደ ኤርዘ Ꮉሪ ታ ይንትስ ላቢድ የሳነ ጋእ ዣሽታነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","ታ እሹንꬆ፥ ታ ይን ፋና ማቅደ ግሾ ይንትን ታ ፋና ማቆተ ጋእ ይንታና ዎሳነ። ይን ታና ፈቲ ባዛራን ቆህካያ። ");
INSERT INTO oyde_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ታኒ ቲኖ Ꮉርግንትተራ ይንትስ ዎንገለ ኦህዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","ታ Ꮉርግታ ይንትስ ፋታና ማቅኮን፥ ታና ቦርካያ፤ አንꬅንትካያ። የዝን ታና ጾዘ ኪታንቾ ዎይ ክርስቶስ የሱሳ ሞክዛንፋና ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","ይኬ፥ ይን ታና ኡፋይስዳና አነ? ይንትስ ዳንዳእንትዛኮ፥ ይን ታስ፥ ይን ኣፍቶ ኬሲ እንግዛኮ እጾሳኖ ታ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","ዬዝን፥ ታ ይንትስ ቱርቶ ኦህደ ግሾ ይንትስ ሞርከ ማቅድ የሳነ? ");
INSERT INTO oyde_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","የንꬅ አሱንꬅ ይንታና ምንꬂ ኮያነ፥ የዝን ሎኦስ ባያ። ምንꬂ ኮይዛና ይንታና ሻኮደስን ፋስ ቆፖደ ፋና ይሳደስ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ሎኦ ባዝ ኦቾደስ ቤዝዱንꬃና ማቅኮ ሎኦ፥ የዝን ይና ታ ይንታራ የዘ ዎደ ጻላላ ማቅካይዝን ኡባ ዎደ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ታ ሲቆ ናኡንꬆ፥ ክርስቶሳ ይንግዳ ስእለ ፋና ይአደ ዎንꬅስ የሎስ ማቻ ꬋእንትዛን ጋራ ታ ይን ግሾ ꬋእንታነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ይን ባዝ ታስ ዎርክታ ማቅን ኡንእንታነ፤ Ꮉተ ይን ግዳ ታ በንቲ ዥልꬊ ኦህዛኮ አኮ ጋር ካꬋነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","ህገስ Ꮉርንቲ የሳደስ ኮይዙንꬆ፥ አነ ታስ ኦሆተ፤ ህገ አኮ ጋዛኮ ስኦስተ? ");
INSERT INTO oyde_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","ጌሽ ማጻፍተ፥ «አብራሃማስ አርትፓን ካራ እንትፓ የልንትደ ላምእ ናኡንꬅ የነ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","አርቲ ናአይ አስ ናአ የልንትዘ ዎጋራ የልንትዳ፥ የዝን ካራ እንቲ ናአይ ጾዘ ኡፋይስ ቃላራ የልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Ꮉንꬅ ማቹንꬅ ላምእ ጫቁንꬅስ አዝዘ ማቂ ኤክንታነ። ኡንታፓ ፈታ፥ ሲና ደርዘፓ ይእዳና፥ ፋ ናኡንꬃና አሮትꬅስ የልዳ፤ እዛን አጋሮ። ");
INSERT INTO oyde_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","አጋራ አራበ ሳአ የዘ ሲና ደረፓ። Ꮉተ የዘ የሩሳላመ አዛነ። እዛ ፋ ናኡንꬃራ አሮትꬃ የነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","የዝን ሳሎ የሩሳላመ ዋሎትꬃ የዛኖ፤ እዛን ኑ ኡቡንꬅስ እንዶ። ");
INSERT INTO oyde_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","ጌሽ ማጻፍተ፥ «ናእተ፥ የሎሰ ꬎንꬅተ ኡፋይቶ፤ ናእተ የሎ ꬋእ ኤሮሳነ እልሎ። አዝናራ የዘ ማችትፓ፥ አዝን ባይዘ ማችትስ ናኡንꬅ ጋማ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","ታ እሹንꬆ፥ ኑኒ ይሳቃ ፋና ጾዘ ኡፋይስ ቃላራ የልንትደ ናአ። ");
INSERT INTO oyde_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","የዝን የ ዎደ አስ ዎጋራ የልንትደ፥ አያና ዎልቃራ የልንትዳያ ባይꬅዳ። Ꮉይኖን ይኒ ፋና። ");
INSERT INTO oyde_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","የዝን ጌሽ ማጻፍታ ዋገ? «አርቲ ናአይ ካራ እንቲ ናአይራ ፈትላ ላቶሰ ግሾ አርቶን እ ናአይራ ኬሲ ዳኮ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ይኒ ግሾ፥ ታ እሹንꬆ፥ ኑኒ ካራ እንቲ ናኡንꬃና ፋትን አርቲ ናኡንꬃና ባያ። ");
INSERT INTO oyde_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","ኑኒ ዋሎትꬃ የሳደ ፋና ክርስቶሳ ኑና አሮትꬃፓ ከስዳ። ይኬ፥ ሚንግ ኤቆተ፤ ማህ አሮትꬅ ቃምባራ ዋጽንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","ታኒ፥ ጳዉሎሳ፥ ጋዛኖ ስኦተ። ይን ጋራዝንትኮ፥ ክርስቶሳ ይንታና አኮን ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","ጋራዝንትዘ ኦደን ህገ ኪትዛኖ ኡባ ፎሎደስ ቤዝዛኖ ፈተስ ፈተስ ማህ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","ህገ ናጊ ጽሎደስ ኮይዙንꬆ፥ ክርስቶሳፓ ሻክንት፤ ጾዘ አꬎ ኬሃትꬃፓ ጎልእዳ። ");
INSERT INTO oyde_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","የዝን ኑኒ ጾዘ አያና ባጋራ አማኖራ ጽሎዳኖ ኡፋይሳራ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ይኬ፥ ክርስቶስ የሱሳ ግዳ የዝኮ፥ ሲቆ ኦቻ ቆንጭዘ አማኖ ፋትን ጋራዝንትን፥ ጋራዝንታንጽን ኑና አኮን ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","ሎኦ ዎጻነ የሻ፥ የዝን Ꮉተ ቱርስ ኪትንታመ ፋና ይንታና ካይደ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Ꮉኒ ፋና ኢታ ዞረ ይንታና ጼግደ ጾዘፓ ባያ። ");
INSERT INTO oyde_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ይናን፥ «ኤራꬅ እርሾ ቡካ ኡባ ደንꬅꬃነ» ጋእንትደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ይንትስ መለ ቆፋ ባይዛኖ ፎሎ ላꬄላ አማንንታነ። የዝን ይንታና ቡቅዘ ኦደን ጾዛፓ ፋ ፍርድቶ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","ታ እሹንꬆ፥ ታ Ꮉይኖ የሎደስ ጋራዝንተ ሳባክዘባዝ ማቅኮ፥ ዬዝን ታና አኮስ ባይኤ? ይኖ ሳባክዘ ባዝ ማቅኮ ክርስቶሳ ማስቃላባዝ አሱንꬅስ ꬉበ ማቅዛና አታነ የሻ። ");
INSERT INTO oyde_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","ይንታና ቡቅዙንꬅ ጋራዝንተ ጻላላ ማቅካይዝን ፋ አጋስቶ ጋችዛኮን ታ ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","ታ እሹንꬆ፥ ይን ዋሎ የሳደስ ጼግንትዳ። ማቆየዝን፥ ይን ዋሎትꬅታ አሾ አሞትꬅ ፎሎደስ ይንትስ ኦገ ማቅፐ፤ ይንፓ አꬂ ፈታይ ፈታይስ ሲቆራ አሮ ፋና ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ህገ ኡባ፥ ፈቲ ቃላራ አጭንትዳ። ይናን «ነ ላግዛ ነ ኦምት ፋና ካꬎ» ጋዛኖ። ");
INSERT INTO oyde_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","የዝን ይን ፈታይ ፈታይራ ሳጽንትዘባዝን ሙእንትዘባዝ ማቅኮ፥ ይን ዎል Ꮉሳመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ይኬ፥ ታ ይንትስ ኦህነ፤ አያናራ የዞተ፤ ይን አሾ አሙቶ ሙሎን ፎልፐተ። ");
INSERT INTO oyde_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","አሾ አያናላ አያና አሾላ አሙꬋነ፤ ኡንትን ፈተ ፈተራ እጽንታነ። ይኒ ግሾ ይን ካꬍዘባዝ ኦቾደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","አያናራ ካልዘባዝ ማቅኮ ህገ ይንታና አሆስ። ");
INSERT INTO oyde_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","አሾ ኦቹንꬅ ኤርንትዱንꬃና፤ ኡንትን፥ ኦላለ፥ ቱናትꬅ፥ ቃይጸ፥ ");
INSERT INTO oyde_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ኤቃስ ጎይነ፥ ብታ፥ ሞርከትꬅ፥ ካች፥ ቃናተ፥ ዥሎ፥ ዛዛእንተ፥ ፋና ካ፥ ሻክንተ፥ ኢታ ዞረ ");
INSERT INTO oyde_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ገነ፥ ማꬄ፥ የꬂን ይኖ አዝዙንꬃና፤ ቲኖ ታ ይንትስ ኦህዳን ፋና Ꮉተን ታ ይንትስ ኦህነ። Ꮉኒ ፋና አዝዘባዝቶ ኦችዙንꬅ ጾዘ ካእቱሞ ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","የዝን አያና ኣፈ፥ ሲቆ፥ ኡፋይስ፥ ሳሮትꬅ፥ ዳንዳአ፥ ኬሃትꬅ፥ ሎኦትꬅ፥ አማኖ፥ ");
INSERT INTO oyde_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","አዳትꬅ፥ ፋና አሄ። Ꮉኒ ፋና አዝዘባዝቶ እጽዘ ህገ ባያ። ");
INSERT INTO oyde_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","ክርስቶስ የሱሳ ባዝ ማቅዱንꬅ ፋ አሽቶ ኢስ የዘ ኢታ ቆፍትራን እ አሞትꬅትራ ዎላ ማስቃላላ አፋ ሱጽዳ። ");
INSERT INTO oyde_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","አያናራ የዘ ባዝ ማቅኮ፥ ኑኒ አያናር ካሎዳ። ");
INSERT INTO oyde_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","አነ ፈተ ፈተላ ዥልꬍተራ ደንድተራን ቃናትተራን Ꮉፖ ጬቅንትዛኖ አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","ታ እሹንꬆ፥ አስ አኮ ቆሄ ግዳ ጎልእኮ፥ አያናራ የዘ ይን የ አꬃ አሽከትꬃራ ሉልዞተ። የዝን ኔኒ ይኒ ጋርዘ ባዛራ ፋታንንታመ ጋር ነና ናጎ። ");
INSERT INTO oyde_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ይንታፓ ፈታይ ፈተ ቶፍቶ ቶኮ። የይዝተራ ክርስቶሳ ህገ ፎሎተ። ");
INSERT INTO oyde_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","ፈተ አስ አኮን Ꮉንካይዝን፥ አኮን Ꮉንደ ፋና መሉንꬃፓ ሎኦ ጋእ ቆፕኮ፥ ኤ ፋና ጭማነ። ");
INSERT INTO oyde_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","የዝን ፈተ ፈተ ፋ ኦማ ኦችቶ ፋታኖ። ይንፓ ሱባ፥ መሉንꬅስ Ꮉንካይዘ ባዝ ፋ ጻላላስ ጬቅንትዘ ባዝ ደማዳ። ");
INSERT INTO oyde_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ፈተ ፈተ ፋ ቶፍቶ ቶኮደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","የዝን ጾዘ ቃላ ታማርዘ ታማርስዘራ ሎኦ ባዝ ኡባ ግሽንታነ። ");
INSERT INTO oyde_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ባልንትፐተ፥ ጾዚ ጭምንቶስ አስ ፋ ቡድዛኖ ማህ ማጾዳ። ");
INSERT INTO oyde_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","ፋ አሾ አሞራ ቡድዘ ኦደን፥ ፋ አሾ አሞትꬅትፓ ዎቃ ማጾዳ። የዝን አያናራ ቡድዘ ኦደን አያናፓ መዽና ደኦ ማጾዳ። ");
INSERT INTO oyde_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","አዛልአንጽኮ ኑ ዎደር ማጾዳ። ሎኦ ኦቻ ኦቾደስ አዛልኦስ። ");
INSERT INTO oyde_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ይኬ ዎትዘ ዎደ ደንግኮ፥ አስ ኡባስ፥ አꬂ አማንዘ አስስ ሎኦ ባዝ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","ታኒ ታ ኩሸራ፥ አኮ ጋር ዳማ ፍዳለራ ይንትስ ጻፈዛኮ ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","አስ ቲኖ ሎኦ ማቂ በንቶደስ ኮይዘ አሱንꬅ ይን ጋራዝንቶደ ፋና ኮያነ። የዝን ይኖ ኡን ኦችዛና፥ ክርስቶሳ ማስቃላ ግሾ ኡንታና ባይꬅ የላመ ፋና። ");
INSERT INTO oyde_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ኡን ይን ጋራዝንትዳነ ጬቅንቶደስ ኮይ «ይንታና ጋራዝንቶተ!» ጋነ ፋትን ጋራዝንትዱንꬅን ፋ ኦምተ ህገ ናጎስ። ");
INSERT INTO oyde_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","የዝን አላመ ታስ ሱጽንትዳይፓን ታንን አላመስ ሱጹንትደ፥ ላꬄ የሱስ ክርስቶሳ ማስቃላፓ መለ ጬቅንተ ታፓ Ꮉኮ። ");
INSERT INTO oyde_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ይኬ፥ ጋራዝንትን ጋራዝንታንጽን አኮን ማዶስ። ክርስቶስ የሱሳራ ክለ መꬎ ማቀ ማዳነ። ");
INSERT INTO oyde_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Ꮉና ዎግቶ ካልዘ ኡቡንꬅስን ጾዘ ዎርዣ ማቅደ እስራኤሉንꬅስ ሳሮትꬅን ማሮትꬅን ማቀ። ");
INSERT INTO oyde_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","ታኒ የሱሳ Ꮉርግደ ቤቶ ታ አሽተ ቶክዳ፥ ይኬፓ ታና አኮን ላቢዞስ። ");
INSERT INTO oyde_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","ታ እሹንꬆ፥ ኑ ላꬄ የሱስ ክርስቶሳ አꬎ ኬሃትꬅ አያና ይንታራ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","ጾዘ ቆፋራ ክርስቶስ የሱሳ ሐዋረ ማቅደ ጳዉሎሳ፥ ኤፈሶነ የዘ ጌሹንꬅስን ክርስቶሳ የሱሳ አማንዙንꬅስ ጻፍንትደ ኪታ። ");
INSERT INTO oyde_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","ጾዘ ኑ አደፓን ላꬄ የሱስ ክርስቶሳፓ አꬎ ኬሃትꬅን ሳሮትꬅ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ሳሎ የዘ አያና አንጆ ኡባ ክርስቶሳ ባጋራ ኑና አንጅዳ፥ ኑ ላꬄ የሱስ ክርስቶሳ አዳይ፥ ጋላትንቶ። ");
INSERT INTO oyde_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ኑኒ ኤ ቲኖ ጌሹንꬃናን ቦረ ባይዙንꬃና ማቆደ ፋና ጾዚ አላመ መꬍንቶዳንፓ ቲኖ ክርስቶሳ ባጋራ ፋ ሲቅተ ኑና ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ጾዘ ፋ ሎኦ ቆፍተ ፋ ካꬍደ ጋር የሱስ ክርስቶሳ ባጋራ ኑና ፋ ናኡንꬃና ማሆደስ ቲኖ ቆፒ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ጾዘ ፋ ሲቅዘ ናአይ ባጋራ ኑስ Ꮉሪ እንግደ አꬎ ከሃትꬅታ ቦንችንቶደ ፋና ይኖ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","አልኦ ናአይ ኤ አꬎ ኬሃትꬅትን ዳማትꬅት ፋና ኤ ሱꬅተ ዎዝንተ ደንግዳ፥ እዛን ኑ ናጋርት አቶትꬅ። ");
INSERT INTO oyde_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ፋ አꬎ ከሃትꬅታ ጭንጫትꬅን ቆፋ ኑስ ጋንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ክርስቶሳ ባጋራ ኦቾደስ ካꬍደ ኤ ግዳ የዘ ሳዛ ቆፋ ኑና ኤርስዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ዎደ ዉርሱꬅተ ጾዚ ፎሎደስ ቆፕደ ቆፍታ፥ ሳሎን ሳአ የዘ መትꬅ ኡባ ክርስቶሳራ ጻጾደስ። ");
INSERT INTO oyde_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ፋ ቆፋራ ኡባ ኦችዘ፥ ፋ ቆፍት ጋር ቲኒ ፋስ ቆፒ ጋድደ ክርስቶሳራ ማህ እርስተ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ይናን ክርስቶሳላ ቲኒ ኡፋይስ ጋድደ ኑኒ ኤ ቦንችቶ ጋላቶደ ፋናስ። ");
INSERT INTO oyde_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","ይን ማህ ቱሪ ቃላ ይናን አቶትꬅ ዎንገለ፥ ስእደ ማህ ክርስቶሳ አማኒ ጌሽ አያናራ አታምንትዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","ኤ ቦንችትስ ጋላታ ማቃደ ፋና ጾዚ ፋስ ማቅዱንꬃና ዎዞደ ዎንꬅስ ኤዚ ኑስ ቃብደ ማህ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ይኒ ግሾ፥ ላꬂ የሱሳ ይን አማንዛኖን ጌሹንꬅስ ኡባ የዘ ሲቅቶ ታ ስእ ");
INSERT INTO oyde_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ታ ዎስተ ይንታና ቆፕተራ ይን ግሾ ጾዛ ጋላትዛኖ አሽካያ። ");
INSERT INTO oyde_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ቦንቾ አዳይ ላꬄ የሱስ ክርስቶሳ፥ ኤዛ ኤርዘ ጭንጫትꬅን ቆንጭꬅ አያና ይንትስ እንጎደ ጋር ታኒ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","19","ይናን ይን ዎዝና ኣፍታ ፎእዘ ዎደ ይን ጼግስት ኡፋይስታ አኮ ፋና የዛኮን ጌሹንꬅ ካለ የዘ እርስተ ቦንቾ ዱረትꬅታ አኮ የዛኮ አማንዙንꬅስ ኡባ አꬍደ ኤ ዎልቃ ዳማትꬅታ አኮ ጋር የዛኮ ይን ኤሮደ ፋናስ። ");
INSERT INTO oyde_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","21","ክርስቶሳ Ꮉይቆፓ ደንꬅደ፥ Ꮉላቃትꬅ፥ አደትꬅ ዎልቃ፥ ዎልቃ፥ ላꬄትꬅ ኡባፓ ꬎቃ፥ Ꮉና አላምተ ጻላላ ባይዝን የኦደ አላምተ ማህ ጼግንቶደ ሱንꬃፓ ꬎቃ፥ ሳሎ ጾዛፓ ምዛቅ ዛላራ በትꬅደ ክርስቶሳ ኦችደ ኤ ምንꬂ ዎልቅቶ ቆንጭዛነ። ");
INSERT INTO oyde_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ጾዚ ኡባኖ ክርስቶሳ ቶህትፓ ኦሞራ Ꮉርዝዳ፤ ማህ ዎሳ ኬꬅስ ኡባ ኦማ ማቃደ ፋና ኤዛ ሹምዳ። ");
INSERT INTO oyde_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ዎሳ ኬꬅታ ክርስቶሳ ኩሙꬅ ኦችዘ ኤ ጋላ። ዎሳ ኬꬅታ ኤ ጋላ፥ ኡባ ባዝ ሙሎ ኩምደ ኤ ኩሙꬅ። ");
INSERT INTO oyde_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Ꮉንፓ ዛጋ ይን፥ ይን ናጋርትፓን ይን ቆህትፓ ደንዲ አያና ደእተ Ꮉይቂዱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ይንፓ ደንዲ ይን Ꮉና አላመ ኢታ ኦግቶ ካልዳ። ባቆላ አፋ የዘ አያኑንꬅ ዎልቃራ አህዘስ ኪትንታነ፥ ኤዝን ኪትንቶሰ አሱንꬃላ ኦችዘ ቱና አያና። ");
INSERT INTO oyde_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ኑ ኡቡንꬅ ዛጋ የሱንꬅ አሱንꬅ ግዳ ኑ አሾ አሞራ ኑ ዎዝና ቆፍቶ ካሊ የነ። መሉንꬅ ፋና ኑ መꬍተ ጾዘ Ꮉንቆ ኤኮደስ የዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","የዝን ጾዚ ፋ ማሮትꬅተ ዱረ ማቅደ ግሾ ");
INSERT INTO oyde_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ኑና ካꬍደ ዳማ ሲቅትፓ ድንድዳነ ኑ ቆህትራ Ꮉይቂዱንꬃና ማቅደ ዎደ ክርስቶሳራ ደኦ እንግዳ። ኤ አꬎ ኬሃትꬅተ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","ጾዚ ኑና ክርስቶሳራ ባጋራ Ꮉይቆፓ ደንꬂ ሳሎ በሳ ኤራ ዎላ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ኤ ይኖ ኦችዳና፥ ክርስቶሳ የሱሳ ባጋራ ኑስ ቆንጭደ ፋ ኬሃትꬅቶን ልከ ባይዘ ፋ አꬎ ኬሃትꬅ ዱረትꬅቶ ዮኦደ በረ ኑና ቤዞደስ። ");
INSERT INTO oyde_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","አꬎ ከሃትꬅታ አማኖራ አሽዳ። ይናን፥ ጾዘ እሞ ፋትን ይንታፓ ባያ። ");
INSERT INTO oyde_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","ኦንን ጬቅንታመ ፋና ኦቻራ ባያ። ");
INSERT INTO oyde_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","ኑኒ ጾዘ መꬎ፤ ኤ ኑስ ቲኒ ጊግዚ ጋድደ ሎኦ ኦቻ ኦቾደ ፋና ክርስቶስ የሱሳ ባጋራ ክለ መꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ይኒ ግሾ፥ ይን የልንተራ አይሁደ ማቆሱንꬆ፥ አሾራ ኩሸራ ጋራዝንትዱንꬅ ካለ፥ ጋራዝንትካያ ጋእንተዙንꬆ፥ ይኖ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","የ ዎደ ይን ክርስቶሳፓ ሻክንት የዝዳ፥ እስራኤለ አሱንꬅስ አላጋ ማቂ የዝዳ፥ ጾዘ ኡፋይስ ቃላፓ Ꮉኪ የዝዳኖን Ꮉና አላምት ኡፋይስን ጾዚ ባይዝን የዙንꬃና ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","የዝን ይን ዛጋ Ꮉኪ የዙንꬃና፥ Ꮉተ ክርስቶስ የሱሳ የዘ ክርስቶሳ ሱꬅተ ካለ ሺቅዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","ክርስቶሳ ኑስ ሳሮ፤ ኤ አይሁደን አይሁደ ማቆሰ አሱንꬃና ፈቶ ማህ፥ ላምእ ሻኪ ጋድደ ሞርከትꬅ ዶቸ ላልዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ላምእ ዎርዡንꬃፓ ኤ ፋራ የሳደ ፋና ፈቲ ክለ አስ መꬎደስ፥ ህገ ኪቶን ዎግቶ ፋ አሽተ ꬋብሲ ሳሮ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","ክርስቶሳ ማስቃላላ Ꮉይቂ ሞርከትꬅቶ ꬋብስዳ፤ ማህ ላምእ ዛሩንꬃና ፈቲ አስ ማህ ጾዛራ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","ክርስቶሳ ይእ፥ ጾዛፓ Ꮉኪ የዘ ይንትስን፥ ማህ ኡከ የዘ አይሁዱንꬅስ ሳሮትꬅ ዎንገለ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","ኑ ኡባ ኤ ባጋራ ፈቲ አያናራ አዳይ ቲኖ ሺቆዳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ይኬፓ ይን ዛቆን በተ አስ ባያ፥ የዝን ይን Ꮉተ ጌሹንꬃራ ጋደ አስን ጾዘ ካራ አስ። ");
INSERT INTO oyde_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ይን ሐዋሩንꬅን ናቡንꬅ ባስደ ባሳላ ኬጽንትዳ። ዶቸ ጻጶ ምንꬅዘ ሹችዘ ክርስቶስ የሱሳ። ");
INSERT INTO oyde_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ኤላ ኬꬅታ ኡባ አይክንቲ ላꬄ ግዳ ጌሽ ጾዘ ኬꬂ ማቃደ ዎንꬅስ ዳማነ። ");
INSERT INTO oyde_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","ኤራ ይን ማህ ጾዘስ አቅዘ ኬꬂ ማቂ አያናራ ዎላላ ኬጽንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ይኒ ግሾ፥ ታኒ፥ ጳዉሎሳ፥ አይሁደ ማቆሰ ይን ግሾ ክርስቶስ የሱሳ አች አስ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ይንትስ ታና እንግደ ጾዘ አꬎ ኬሃትꬅ አስታማረ ታ ማቀዛኖ ይን ሎይꬂ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","ታ ይንትስ ዛጋ Ꮉታራ ጻፍዳን ፋና ጾዚ ፋ ሳዛ ቆፋ ታስ ቆንጭꬃራ ኤርስዳ። ");
INSERT INTO oyde_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ታ ጻፍዳኖ ይን ናባብዘ ዎደ ክርስቶሳ ሳዛ ቆፋ ታ አኮ ጋር አካኬዛኮ ይን በአደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ይና ሳዛ ቆፍታ ጾዘ አያናራ ጌሽ ሐዋሩንꬅስን ናቡንꬅስ Ꮉተ ቆንጭዳን ፋና ዛጋ ዎደ አሱንꬅስ ይኒ ጋር ቆንጭዝካያ። ");
INSERT INTO oyde_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","ይናን ቤዛና አይሁደ ማቆሱንꬅ እስራኤሉንꬃራ ፈትላ ጾዘ አንጆ ላቶደስ ፈቲ አሳትꬅ ብልተ ማቂ፤ ጾዚ እንግዘ ኡፋይስ ዎንገለ ባጋራ የሱስ ክርስቶሳራ ሻክንትዙንꬃና ማቃደስ። ");
INSERT INTO oyde_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","ጾዘ ፋ ዎልቃ ኦቻራ ፋ እንግደ አꬎ ኬሃትꬅት እሞ ባጋራ ዎንገለ ኦችዛያ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","ታኒ ጌሹንꬅ ኡባፓ ላፋ ማቅኮን አይሁደ ማቆሰ አሱንꬅስ ዉዙላ ባይዘ ክርስቶሳ ዱረትꬅ ዎንገለ ኦሆደ ጋር አꬎ ኬሃትꬅ ታስ እንግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ማህ ዛጋ ዎደ ኡባ መꬍደ ጾዛራ አችንት የዘ ሳዛ ቆፋ፥ ጾዘ ቆፍታ አኮ የዛኮ ቆንጭሳደስ አꬎ ኬሃትꬅ ታስ እንግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ጾዚ ይኖ ኦችደ Ꮉተ ዎደ ዎሳ ኬꬂ አሱንꬅ ባጋራ ሳሎ የዘ Ꮉላቁንꬅስን አህዙንꬅስ ፋ ዱማ ዱማ ቆንጭꬅቶ ኤርሶደስ። ");
INSERT INTO oyde_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ይናን ክርስቶስ የሱሳ ባጋራ ኑ ላꬄ ፎልደ መዽና ቆፋ። ");
INSERT INTO oyde_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","ኑ ክርስቶሳስ ማቅዳንራን ኤዛ አማንዳን ጋራ ጾዘ ቲኖ ሚንግ አማንንቲ ሺቆደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ታኒ ይን ግሾ ማꬋ ኤክዛና ኑስ ቦንቾ ይኒ ግሾ ታ የልዘ ማꬍቶ ብእ ኡፋይስ ጋችፈተ ጋእ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ታኒ አዳይ ቲኖ ቡንቁንቲ ዎስዘ Ꮉኒ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ሳሎ ሳአ የዘ ፈቲ ፈቲ ካራ አሱንꬅ ቱሪ ሱንꬅ ደንግዘ ጾዛፓ። ");
INSERT INTO oyde_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ጾዚ ፋ ቦንቾ ዱረትꬃፓ ይን ጋꬃ ቆፍቶ ምንꬅዘ ዎልቃ ፋ አያና ባጋራ እንጎደ ጋር ይንትስ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ማህ አማኖራ ክርስቶሳ ይን ዎዝንተ የሳደ ጋራን ይን ሲቆራ ጻጶ ዳኪ ሚንግ የሳደ ጋር ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","ይኒ ፋና፥ ክርስቶሳ ሲቆ አኮ ጋር ዳልጋ፥ ጳርጎ፥ ꬎቂን ጪሞ የዛኮ ጌሹንꬅ ኡቡንꬃራ አካኪ ኤሮደ ጋር ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","ይና አስ ኤራትꬃፓ ꬎቃ ማቅደ ክርስቶሳ ሲቆ ይን ኤሮደ ጋራን ጾዘ ፎሎ ኩሙꬅ ይን ኩሞደ ፋና ታ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ይኬ፥ ኑ ግዳ ኦችዘ ዎልቂት ባጋራ ኑኒ ዎስዛንፓ ዎይ ቆፕዛንፓ ኡባ አꬂ ኦቾደስ ዳንዳእዘስ፥ ");
INSERT INTO oyde_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ኤስን ዎሳ ኬꬃ አሱንꬅስ ኡባ ክርስቶስ የሱሳ ዎደ ኡባ መꬍፓ መዽና የሎደስ ቦንቾ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ይኬ፥ ላꬄስ አጭንትደ ታኒ፥ ይን ጼግንትደ ጼግስተ ቤዝዘ ደኦር የሳደ ፋና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ሲቆራ ፈታይ ፈታያ ዳንዳእተራ ኡባ ዎደ አዳትꬃራን ዳልጋትꬃራ ዎል ዳንዳእ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ሳሮትꬃራ አጭንትደ አያና ፈተትꬅ ናጎደስ ምንጎተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","ይን ጼግንትዳና ፈቲ ኡፋይስ ጼግꬅ ማቅደ ግሾ ፈቲ አሳተꬅን ፈቲ አያና የነ። ");
INSERT INTO oyde_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ፈቲ ላꬂ፥ ፈቲ አማኖን ፈቲ ጽንቃተ የነ። ");
INSERT INTO oyde_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ኡባንፓ ꬎቃ ማቅደ፥ ኡባላ ኦችዘ ኡባ በሳ የዘ ፈቲ ጾዚ፥ ኡቡንꬅ አደ የነ። ");
INSERT INTO oyde_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","የዝን ክርስቶሳ እንጎደስ ኮይዳን ፋና ኑስ ፈተስ ፈተስ ዱማ ዱማ እሞትꬅ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ይኒ ግሾ፥ ጾዘ ቃልተ፥ «ኤ ኡደ ከዝደ ዎደ ድእንቶደስ የዙንꬃና ድእዳ፥ አሱንꬅስን እሞትꬅ እንግዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ሱለ ሳአ ኦሞ ዎꬍዳ ጋኤ ማቃንጽኮ ይና «ኡደ ከዝዳ» ጋዛና አኮ ጋኤ? ");
INSERT INTO oyde_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","የ ሱለ ዎꬍዳይ፥ ማህ ኡባነ በንቶደ ዎንꬅስ ሳሎ ኡባስ ካታር ኬዝዳይ ኤዛ። ");
INSERT INTO oyde_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","ኤ ፈታ ፈታ ሐዋሩንꬃና፥ ፈታ ፈታ ናበ፥ ዎንገለ ሳባኩንꬃና፥ ዎሳ ኬꬅ የንግዙንꬃናን፥ አስታማሩንꬃና ማህ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ኤ ይኖ ኦችዳና ክርስቶሳ ጋላ ማቅደ ዎሳ ኬꬅታ ጌሻደ ፋናን አማንዘ አሱንꬃና ጾዘ ኦቻስ ጊግሳደስ። ");
INSERT INTO oyde_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ይኒ ፋና፥ ኑ ኡባ ጾዘ ናአ ኤሪ አማኖራ በንትዘ ፈተትꬃጎ የሊ፥ ክርስቶሳ ፎሎን ኩሙꬅ ማቅደ ፋና ኑንን ኩሙꬅ አስ ማቃደ ፋናስ። ");
INSERT INTO oyde_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ይኬፓ ሱባ፥ አሱንꬅ ገነ ጭሞራ ጊግደ ባልꬅዘ ዎርዶ ትምርተ ባቆራን ዙሉንተራ ጎደን Ꮉንካ ሾላለ ካእዘ ናኡንꬅ ፋና ማቆደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","የዝን ኑኒ ቱሮ ሲቆራ አይꬅꬂ ኡባ ባዛራ ኤጎ ኦማ ማቅደ ክርስቶሳጎ ድቾዳ። ");
INSERT INTO oyde_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ኤፓ ደንዲ ጋላ ኡባ ብልተ ዎጋራ ኦቾደ ፋና አጭንትደ ጋላ ጻጶ ሻዣራ አይክንቲ ፋና ሲቆራ ኬጽተራ ፋ ጋልቶ ድቻነ። ");
INSERT INTO oyde_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","ይኬፓ ቆፋ ባይዘ አይሁደ ማቆሰ አሱንꬅ ፋና የዝፐተ ጋእ ላꬄ ቲኖ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ኡን ቆፍታ ꬉምዳ፤ ፋ ዎዝንተ ꬉምዳ። ጾዚ እንግዘ ደኦፓን Ꮉክዳ። ");
INSERT INTO oyde_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ኡን ዬላ ጋዘባዝ ኤሮስ፤ ኡን ቱና ባዝ ኦቾደስን አሾ አሞትꬅስ ፋና አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","ይን ክርስቶሳ ባዝ ይኒ ጋር ታማርካያ። ");
INSERT INTO oyde_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ቱርፓ ይን ስእዳ። ማህ የሱሳ ግዳ ቱሪ የዛኖ ታማርዳ። ");
INSERT INTO oyde_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ይን ቲኖ የዝደ ዎግቶ አሾተ። ማህ ጭምዘ አሞራ ꬋብዘ ይን ጋልአ ቆፍቶ Ꮉሶተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ይን ዎዝና አያናራ ክልꬎተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ቱሪ ጽሎትꬃራን ጌሻትꬃራ ጾዚ አዚ መꬍንትደ ክለ አሳትꬅቶ ማኦተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ይኬ፥ ዎርዶ ኦህንትፐተ። ኑኒ ኡቡንꬅ ክርስቶሳ ጋላ ብልተ ማቅደ ግሾ አስ ኡባራ ቱሮ ኦህንቶተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","ካጮተ፥ የዝን ይን ናጋራ ኦችፈተ። ይን ካቻራ የዝን አዋ ገልፐ። ");
INSERT INTO oyde_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ጻላሄስ በሲ እንግፈተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ካይስትዘ ይኬፓ ካይስትፐ። የዝን ዳሁንꬃና ማድዘ ባዝ የሳደ ፋና ፋ ኩሸራ ሎኦ ባዝ ኦቾ። ");
INSERT INTO oyde_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ይን ዶንትፓ ሙሎን ኢታ ቃላ ኬዝፐ። የዝን ስእዙንꬃና ኡፋይሶደስን ምንꬆደስ ቤዝዘ ሎኦ ቃላ ይን ዶንትፓ ከዞ። ");
INSERT INTO oyde_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ዎዞ ቃማስ አታሚ ጋድደ ጌሽ ጾዘ አያና አዛንꬅፈተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ሞርከትꬅ፥ ዥሎ፥ ካች፥ ኡፎ፥ ጫሽን ኢታ ኡባ ይንታፓ Ꮉሶተ። ");
INSERT INTO oyde_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","አꬂ ፈታይ ፈታይስ ኬሃን ይቅስንትዙንꬃና ማቆተ። ጾዚ ክርስቶሳ ባጋራ ይንትስ አቶ ጋይዳን ፋና ይንትን ዎልስ አቶ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ይኬ፥ ጾዚ ካꬍንትደ ናኡንꬅ ፋና ጾዛ ካልዙንꬃና ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ክርስቶሳ ኑና ካꬊ ጾዛ ኡፋይስዘ ሎኦ ሳውዘ እሞን ዣርሾ ማህ ፋ ሸምፕቶ ኑስ አꬂ እንግዳን ፋና ይንትን ሲቆራ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","አኮን ኦላለ Ꮉንታ፥ ዎይ ቱናትꬅ፥ ዎይ አሞትꬅ ጋርዘ ባዝ ሙሎን ይን ካለ ስንትፐ። ይና ጌሽ ማቅደ ጾዝ አስስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ዬልዘ ባዝን ቦዛ ኦሄ ዎይ ቅ ይንትስ ቤዞሰ ግሾ የዝፐተ፤ አꬊ ጾዝ ጋላቶተ ፋትን። ");
INSERT INTO oyde_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Ꮉኖ ኤሮተ፤ ኦንን ኦላለ Ꮉንትዘ ዎይ ቱና ባዝ ኦችዘ ዎይ አሞꬍዘን ኤቃ ጎይንዘን ዣርꬍዘ ክርስቶሳራ ጾዘ ካእቱሞ ገሎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ይንፓ ደንድዳነ ጾዘ Ꮉንቆ ኪትንቶሰ አሱንꬃላ አፋ የኦደ ግሾ ኦንን ይንታና ፋꬆሰ ኦሄራ ጭምፐ። ");
INSERT INTO oyde_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ይኬ የንሳራ ዎላ ኢታ ባዝ ኦችዙንꬃና ማቅፈተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ዛጋ ይን ꬉማ የዝዳ፥ የዝን Ꮉተ ላꬄ ባጋራ ፎኦ የነ። ይኬ፥ ፎኦ የዘ አስ ፋና Ꮉንቶተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ሎኦትꬅ ኡባ፥ ጽሎትꬅን ቱሪ ኣፈ በንትዘ ፎኦ ግዳ። ");
INSERT INTO oyde_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ይኒ ግሾ ላꬃ ኡፋይስዘ ባዝ ኦቾደስ ኮዮተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","ኣፈ ባይዘ ꬉማ ኦቻራ ፈቶ ማቅፈተ፥ አꬂ ቆንጭዞተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ኡን አችቻ ኦችዘ ግሾ መለ አቶ የዝን ኦሆደስን ዬልዛነ። ");
INSERT INTO oyde_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","የዝን ኡባ ባዝ ፎኦ ከዝዘ ዎደ ቆንጪ በንታነ። ");
INSERT INTO oyde_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","ቆንጪ በንትዘ ኡባ ፎኦ። ይኒ ግሾ፥ «ናተ ገንትዛዮ ባርኮ፤ Ꮉይቆፓ ደንዶ፤ ክርስቶሳ ኔስ ፎኦዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ይኬ፥ ይን ጭንጩንꬅ ፋና ማቆተ ፋትን ጭንጫትꬅ ባይዙንꬅ ፋና ማቂ የዛመ ፋና ሎይꬂ ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ቃምታ ኢታ ማቅደ ግሾ ዎድቶ ዎዞተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ይኒ ግሾ፥ ላꬄ ቆፍታ አኮ የዛኮ ቆፖተ ፋትን ኤዩንꬃና ማቅፈተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ጌሽ አያናራ ኩሞተ ፋትን ዎይነ ኡሻራ ማꬅንትፈተ፥ ይና ꬋብሰጎ ካንጋነ። ");
INSERT INTO oyde_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","ማዝሙረራን፥ ሳባራ አያና የꬃራ፥ ፈታይ ፈታይራ ኦህንቶተ። ማህ ይን ዎዝንተ ዛማርተራን ሳቢተራ ላꬃ ጋላቶተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ኑ ላꬄ የሱስ ክርስቶሳ ሱንꬅተ ኡባ ባዝስ ጾዛ አዳያ ኡባ ዎደ ጋላቶተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ክርስቶሳ ቦንቾስ ጋእ ይንታፓ ፈታይ ፈታይስ አቆተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ማቹንꬆ፥ ላꬅስ Ꮉርንትዛን ፋና ይን አዝኑንꬅስ አቆተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ክርስቶሳ ዎሳ ኬꬅትስ ኦማ ማቅዳን ጋር አዝንን ፋ ማችትስ ኦማ። ማህ ክርስቶሳ ፋ ጋላ ማቅደ ዎሳ ኬꬅቶ አሽዛ። ");
INSERT INTO oyde_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","የዝን ዎሳ ኬꬂ አሱንꬅ ክርስቶሳስ Ꮉርንትዛን ፋና ማቹንꬅ ፋ አዝኑንꬅስ ኡባ ባዛራ አቆተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","አዝኑንꬆ፥ ክርስቶሳ ዎሳ ኬꬅቶ ካꬊ ፋና ኢስ እንግዳን ፋና ይንትን ይን ማቹንꬃና ካꬎተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","ኤ ዎሳ ኬꬅቶ ፋ ቃልት ባጋራ Ꮉꬃራ ሜጭዘ ፋና ጌሻነ። ");
INSERT INTO oyde_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ꬎሃ ዎይ ስኖ ቱከ ዎይ ይኒ ጋርዘ ባዝ ባይዘ ጌሽን ቦረ ባይዛኖ ማህ ቦንችንትደ ዎሳ ኬꬅቶ ፋስ ሺሾደስ ኮይ ይኖ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","ይኒ ፋና፥ አዝኑንꬂ ፋና ካꬍዛን ጋራ ፋ ማቹንꬃና ካꬎደስ ቤዛነ። ፋ ማችቶ ካዽዘ ፋና ካꬋነ። ");
INSERT INTO oyde_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ፋና እጽዘ አስ ኦንን ባያ፥ የዝን ክርስቶሳ ዎሳ ኬꬅስ ኦችዛንን ናግዛን ፋና ፋ ጋልቶ ሙዛነን ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ኑኒ ክርስቶሳ አሳትꬅት ብልተ። ");
INSERT INTO oyde_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","«ይኒ ግሾ፥ አስ ፋ አዳያን ፋ እንቶ አሺ፥ ፋ ማችትራ ፈቶ ማቃነ፤ ኡን ላምኡንꬅ ፈቲ አሾ ማቃነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ይና ዳማ ሳዛ ቆፍታ፥ የዝን ታኒ ይኖ ክርስቶሳስን ዎሳ ኬꬅስ አዝዘ ማህ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","የዝን፥ ይን ፈታይ ፈታይ ይን ማቹንꬃና ይኒ ፋና ካꬎተ። ማችታን ፋ አዝንዛ ቦንቾ። ");
INSERT INTO oyde_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ናኡንꬆ፥ ይንታና የልዱንꬅስ ላꬄ ግሾ ጋእ ኪትንቶተ፥ ይና ቤዝዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","«ነ አዳያን ነ እንቶ ቦንቾ።» ይና ኡፋይስ ቃላ የዘ ቲኖ ኪታ። ");
INSERT INTO oyde_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","«ነ ይኖ ኦችኮ ኡባ ባዝ ኔስ ጊጎዳ፤ ነ በርታ ሳአላ ጳርጎዳ»። ");
INSERT INTO oyde_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","አዱንꬆ፥ ይን ናኡንꬃና ላꬄ ዞረራን ሴረራ ድቾተ ፋትን ኡንታና ዥልዝፐተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","አሩንꬆ፥ ይን ክርስቶሳስ ኪትንትዛን ፋና ዣሽሞራን ጎቀራ፥ ይን ዎዝንተ ሱርተራ አሾስ ላꬂ ማቅዱንꬅስ ኪትንቶተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","አስ ቲኖ ሳባ ደንጎደስ ኡን በእዘ ዎደ ጻላላ ኦችፍተ። የዝን ጾዘ ቆፋ ኦችዘ ክርስቶሳ አሩንꬃና ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","አስስ ማቅካይዝን ላꬅስ ጋእ ይን ኩምꬅ ዎዝንትፓ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","አሮ ማቅን ዎይ ላꬂ ማቅን ፈታይ ፈታይ ፋ ኦችደ ሎኦ ኦችትስ ላꬃፓ አንጆ ኩሸ ኤኮዳኖ ኤሮተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","ይን ላꬁንꬆ፥ ማንድዛኖ አሺ ሎኦ ባዝ ኦቾተ፥ ይንታናን ኡንታናን አህዘ ላꬃይ፥ ሳሎ የዛይ አስ ስኖ ብእ ፍርዳ ደሽ ይዞሳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","አትዳነ፥ ላꬃራን ኤ ዳማ ዎልቂተ ሚንግዱንꬃና ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ጻላሄ ጭሞ እጺ ዳንዳኦደ ጋር ጾዘ ይንትስ እንግደ ኦላ ሚሸ ኡባ ማኦተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","ኑ ኦልንትዛና ሱꬃራን አሾራ ባያ፤ ሳሎ የዘ ቱና አያና ኦላንቹንꬃራ፤ አደትꬅ ዎልቃ አዱንꬃራ፥ Ꮉላቁንꬃራን Ꮉና ꬉማ አላምቶ አህዙንꬃራ። ");
INSERT INTO oyde_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ይኒ ግሾ፥ ኢታ ቃማ እጾደስ ኡባኖ ፎሊ፥ ሚንግ ኤቆደስ ይን ዳንዳኦደ ጋር ጾዘ ኦላ ሚሸ ኡባ ማኦተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","15","ይኬ ይን ቃዝንተ ቱሮትꬅ ዳንጪ፥ ጽሎትꬅ ጹሩረ ማእ፤ ሳሮትꬅ ዎንገለራ ጊግንቲ ይን ቶህተ ጫማ ፋና አꬂ ሚንግ ኤቆተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","ኡባንላ ጉጂ፥ ጻላሄ ዳክዘ ኢታ ሎብዘ ታማ ዶንገ ኡባ ꬋብሶደስ ዳንዳእዘ አማኖ ጎንዳለ ደንꬆተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","አቶትꬅ ብራታ ባርኔጻ ጋር ይን ኦምተ ጋዶተ፤ አያና ማሻ አይኮተ፤ ኤዝን ጾዘ ቃላ። ");
INSERT INTO oyde_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ዎሳራን መሉንꬅስ ዎሳራ ኡባ ዎደ አያናራ ዎሶተ። ይና ቆፍትራ ጌሹንꬅስ ዎስተራ ኡባ ዎደ ምንጎተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ታኒ ዎንገለ ጋꬅ ቆፋ ቆንጭዝ ኦሆደ ፋና ጾዚ ታስ ቃላ እንጎደ ፋና ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ዎንገለ ኪታስ ሳንꬃላታራ አጭንትዳይ ኤ ግሾ ኦሆደስ ቤዝዘ ፋና ቆንጭዝ ኦሆደ ፋና ታስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ታኒ ዋይዘ የዛኮን አኮ ኦችዛኮ ይን ኤሮደ ጋር ኑ ሲቆ እሻይ፥ ላꬄ ኦችተ አምንንትደ ኦቻንችዛይ፥ ትክቆሳ፥ ታ ባዝ ኡባ ይንትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ኑ ባዝ ይን ኤሮደ ፋናን ይን ዎዝንቶ ምንꬅꬆደ ጋር ይንታጎ ኪትዳና ይኒ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ጾዘ አደፓ፥ ላꬄ የሱስ ክርስቶሳፓ ሳሮትꬅን ሲቆ አማኖራ ዎላ አማንዘ ኡቡንꬅስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ቶዮሰ ሲቆን ኑ ላꬄ የሱስ ክርስቶሳ ካዽዘ ኡቡንꬅስ አꬎ ኬሃትꬅ ማቀ፤ አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","ክርስቶስ የሱሳራ ፈቶ ማቅደ ግሾ ጾዘ ባዝ ማቅደ፥ ፍልጵስዩሳ ካታማ የዘ ዎሳ ኬꬂ አህዙንꬅስን ዳቆናተስን ክርስቶሳ የሱሳራ የዘ ጌሹንꬅስ ኡቡንꬅስ። የሱስ ክርስቶሳ አሮ ማቅደ፥ ጳዉሎሳፓን ጢሞትዮሳፓ ዳክንትደ ኪታ። ");
INSERT INTO oyde_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","ኑ አዳይ ጾዘፓን ላꬄ የሱስ ክርስቶሳፓ አꬎ ኬሃትꬅን ሳሮትꬅ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","ታኒ ይንታና ቲርዘ ዎደ ኡባ፥ ታ ጾዝ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","ታኒ ይን ኡቡንꬅስ ጾዝ ዎስዘ ዎደ ኡፋይሳራ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","ይን ቲኖ ቃማፓ Ꮉይኖ የሎደስ፥ ዎንገለ ማርክꬍዛነ ታራ ዎላ ማቅደ ግሾ ጾዝ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ይን ግዳ ሎኦ ኦቻ አይክደ ጾዘ፥ ክርስቶስ የሱሳ ላምእንꬃ ማቂ የእዘ ቃምቶ የሎደስ፥ ፎሎዳኖ ሎይꬂ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ይን ኡባ ዎደ ታ ዎዝንተ የነ። ታኒ ኡባ ዎደ ይን ግሾ ቆፖደስ ቤዛነ። Ꮉተ ታኒ አቻ የዝተራን አጭንቶዳንፓ ቲኖ ዎንገለ ናጎራን ዎንገለ ምንꬂ ኦሄ ጾዚ ታስ እንግደ አꬎ ኬሃትꬅቶ ታራ ግዥንትዳ። ");
INSERT INTO oyde_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","ታኒ ይንታና ኡባ ክርስቶስ የሱሳ ሲቅተ አኮ ፋና ይቅስንትዛኮ ጾዚ ታስ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","ይን ሲቅታ ቱሪ ኤራትꬃራን አካኬራ ዎላ ጉጂ ጉጂ ድጮደ ፋና ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","ይነ ይን ሎኦ ባዝ ሻጊ፥ ኤሮደ ፋናን፥ ክርስቶሳ ማቂ የእዘ ቃምተ ጌሹንꬃናን ቦረ ባይዙንꬃና ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ይን ደእታ ጾዝስ ቦንቾን ጋላታ የሱስ ክርስቶሳ ባጋራ በንትዘ ጽሎትꬅ ኣፈ ኩሚ አፎደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","ታ እሹንꬆ፥ ታና የልደ ዎንገለ ዳልጎደ ፋና ቱሮ ማድዳኖ ይን ኤሮደ ፋና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ታኒ ክርስቶሳ ኦችዘ ግሾ አጭንትዳኖ፥ ካት ኬꬂ ናግዙንꬅን መሉንꬅ ኡባ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","ታ አጭንቲ ምክናተር ኑ እሹንꬃፓ ጋሙንꬅ ላꬃ ሎይꬂ አማንንትዳ። ይኒ ግሾ፥ ጾዘ ቃላ ዣሽሞ ባይዝን ካሰንፓ አꬊ ሚንግ ኦሆደ ፋና ምንꬅትሞ ኡን ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ማቆ የዝን፥ ፈታይ ፈታይ ቃናተራን ላለራን ክርስቶሳ ባዝ ኦህነ፥ የዝን መሉንꬅ ሉለ ዎዝናፓ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ሉለ ዎዝናፓ ኦህዙንꬅ፥ ጾዚ ታስ ዎንገለ ናጎ ኦቻ እንጎዳኖ ኤርዘ ግሾ ሲቆራ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","የዝን Ꮉንኩንꬅ ታ አችትላ አፋ መለ ማꬋ ኮኦደባዝ ኡንትስ አዝን ፋና ካፓ ደንዲ ክርስቶአባዝ ኦህነፕ አትን ቱሪ ዎዝናፓ ኦሆስ። ");
INSERT INTO oyde_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","ይና አኮን ይኦስ። ቱሪ ዎዝናፓ ማቅን ዎይ ቱሪ ባይዘ ዎዝናፓ ማቅን ይና ኡባነ ክርስቶሳ ሳባክንታነ። ታና ይና ኡፋይሳነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ማህ መለ ታና ኡፋይስዘ ባዝ፥ ታኒ ይን ዎስተን የሱስ ክርስቶሳ አያና ማደራ ዋሎ ኬዝዳኖ ኤርዘ ግሾ ታና ኡፋይሳነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ታኒ ፎሎ ታ ኦችተ ዬልꬋማኖ ኡፋይሳራ ናጋነ። የዝን ኡባ ዎደ ኦችዛን ፋና፥ Ꮉተ ታኒ ፋጻ የዝን ዎይ Ꮉይቂን ዣሽትካይዛራ ታ ኩሙꬅ ጋልተ ክርስቶሳ ቦንችንቶዳ ጋእ ምንꬂ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ታስ ደኦ ጋዛና ክርስቶሳስ የዘ፤ ማህ ታ Ꮉይቂኮን ታስ አꬍደ ትርፈ። ");
INSERT INTO oyde_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","የዝን ታ ፋጻ የዝኮ ኣፈ የዘ ኦቻ ኦቾዳ። የዝን ፋጻ የዛንፓን Ꮉይቆፓ አያ ዶሮድ የዛኮ ታስ ኤርንቶስ። ");
INSERT INTO oyde_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ታኒ Ꮉንꬅ ላምኡንꬃፓ አያ ዶሮድ የዛኮ ኡንእንትዳ። Ꮉና ደእትፓ ሻግንት ክርስቶሳራ ዎላ የሳደስ አሙꬋነ፤ ክርስቶሳራ ዎላ የዛና ኡባፓ አꬊ ሎኦ። ");
INSERT INTO oyde_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","የዝን ታኒ ፋጻ የዛና ይንትስ ጋማ ኮሽዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","ይኖ ታኒ ጌሽ ኤራነ፤ ታኒ፥ ይን አማኖራ ድጮደ ፋናን ኡፋይቶደ ፋና ይንታራ ፋጻ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","ይኒ ግሾ፥ ታኒ ይንታጎ ማቂ የእዘ ዎደ ታ ባጋራ ክርስቶስ የሱሳላ የዘ ጬቅንታ ይንትስ ጋንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ኡባፓ አꬂ፥ ይን ክርስቶሳ ዎንገለስ ቤዝዘ ደኦ የዞተ። ታ ይንታና ብእን ዎይ በአንጽን ይን ፈቲ ቆፋራ ሚንግ ኤቂ፥ መሉንꬅ ዎንገለራ አማኖደ ፋና ፈቲ ዎዝናራ ማቂ ፈትላ ቡቱንትዛኖ ታ ስኦዳ። ");
INSERT INTO oyde_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ይን ሞርኩንꬅስ ዣሽትፐተ። ኡን ይንታራ ኤቅንትዛና ይና ኡንትስ ꬋበ ማላ ማቂ፥ ይንትስ ጾዛፓ ማቅደ አቶትꬅ ማላ። ");
INSERT INTO oyde_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ክርስቶሳስ ኦችዘ እሞትꬅ ይንትስ እንግንትዳና፥ ይን ኤዛ አማኖደ ፋና ጻላላስ ባይዝን ይን ኤ ግሾ ማꬋ ኤኮደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ይኒ ግሾ፥ Ꮉተ ይን ታራ ዋየ ግሽንትዙንꬃና ማቅዳ፤ ይና ዋይታ Ꮉንፓ ቲኖ ታና የልን ብእዳኖን Ꮉተን ታና የሊተራ የዛኖ ይን ስእተ የነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ክርስቶሳራ ይን የዘ የስታ ይንታና ሚንꬃነ፤ ማህ ኤ ሲቅታን ይንታና ምንꬅꬃነ። ጌሽ አያናራ ይንትስ ፈተትꬅ የነ፤ ይን መሉንꬅስ ዳልጋነን ይቅስንታነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ይኬ፥ ይን ፈቲ ቆፋራ፥ ፈቲ ሲቆራ፥ ፈቲ ዎዝናራን ፈቲ አያናራ ማቂ ታና ፎሎ ኡፋይሶተ። ");
INSERT INTO oyde_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ይንታና ካራ ዎይ ጬቅንትዘ ፋꬆሰ አሞራ ፈቲ ባዝን ኦችፐተ። የዝን ይን ፈታይ ፈታይፓ ዳማነ ያጋእ ቆፕካይዛራ ይንታና ካዉሾተ። ");
INSERT INTO oyde_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ይን ፈታይ ፈታያ፥ መሉንꬃና ማድዘ ባዝ ኮዮተ ፋትን ይንታና ማድዘ ባዝ ጻላላ ኮይፐተ። ");
INSERT INTO oyde_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ክርስቶስ የሱሳ የዘ ቆፍታ ይን ግዳ የሳደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","ኤስ ኡባ ዎደ ጾዘ Ꮉኖትꬅ የነ። ይኖ ማቅኮን፥ ኤዛ ጾዛራ ፈቶ ማህዘ Ꮉኖትꬅቶ፥ ዎልቃራ ኤኮደስ ኮይካያ። ");
INSERT INTO oyde_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","የዝን፥ ኤ ፋስ የዘ ቦንችቶ ኡባ አሺ፥ አሮ ማቅዳ፤ አስ ፋና የልንትዳ፤ አስ ማቂ ቆንጭዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ኤ ፋና ካዉሽዳ፤ Ꮉይቆስ የሎደስ፥ መለ አቶ የዝን ማስቃላላ አፋ Ꮉይቆደስ ኪትንትዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","ይኒ ግሾ፥ ጾዚ ኤዛ ጋማ ꬎቅ ꬎቅ ዪዝዳ፤ ማህ ሱንꬅ ኡባፓ አꬍዘ ዳማ ሱንꬅ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ይኒ ግሾ ሳሎን ሳአ፥ ሳአፓ ኦሞራ የዘ ኡባና፥ የሱሳ ሱንꬅት ቦንቾስ ቡንቅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","አስ ኡባ ፋ እልአንꬅተ፥ የሱስ ክርስቶሳ ላꬂ ጋእ፥ ጾዘ አዳይ ቦንቾስ ማርክꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ታ እሹንꬆ፥ ታኒ ይንታራ የዘ ዎደ ኡባ ይን ኪትንትደ ፋና፥ Ꮉተ ታ ይን ካለፓ Ꮉክኮን፥ ቲኖንፓ አꬂ፥ ኪትንቶደስ ቤዛነ። ጾዝስ ዣሽሞራን ጎቀራን ይን አቶትꬅቶ ቤዝዘ ኦቻ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ኤ ኮይዘ ቆፍቶ ኦቾደ ፋናን ኮዮደ ፋና ይን ግዳ ኦችዘ ጾዚ። ");
INSERT INTO oyde_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","አኮ ኦቻን ኦችተራ ዙዝንግካይዛራ ዎይ ላልካይዛራ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ዎቦን ናጋራንቾ አሱንꬅ ግዳ ቦረ ባይꬅ፥ ጌሹንꬃናን ቦርሶ ባይዘ ጾዘ ናአ ማቆተ። ይን ኡን ግዳ ሳሎ ጾልንቶ ፋና ፎእተራ፥ ");
INSERT INTO oyde_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ደኦ በንትዘ ቃላ አሽካይዛራ ምንꬂ አይኪ፤ ይኒ ፋና ታ ዎꬅታን ታ ኦችታ Ꮉሪ አቶሰ ግሾ ክርስቶሳ የእዘ ዎደ ታስ ጬቆ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","የዝን ይን አማንተን ኦችተ ዣርሾ ጉጂ ታ ሸምፕታ ላንትዛኮን ታና ኡፋይሳነ። ይንትን ታራ ኡፋይቶዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","ይኒ ፋና ይንትን ኡፋይት ታናን ኡፋይሶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ታኒ ይን የስት ባዝ ስእ ታ ኡፋይቶደ ፋና ጢሞትዮሳ ይንታጎ ኤልሲ ዳኮደ ፋና ላꬂ የሱሳ ታና ማዶዳኖ አማንንታነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","ይን የስትስ ዎዝናፓ ቆፕዘ ኤ ጋርዘ አስ መለ ኦንን ባያ። ");
INSERT INTO oyde_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","መሉንꬅ ፋና ማድዘ ባዝ ኮያነፕ አትን የሱስ ክርስቶሳ ኮይዘ ባዝ ኦቾስ። ");
INSERT INTO oyde_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ኤ ታራ ፈትላ ማቂ ናአ ፋ አዳይስ ኦችዛን ፋና ዎንገለ ኦቻ ኦችዳይን አማንንትደ አስ ማቅዛኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ይኒ ግሾ፥ ታ ባዝ ዋያድየዛኮ ብእ ኤልሲ ኤዛ ይንታጎ ዳኮዳ ጋእ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ታኒ፥ ታ ኦምተ ኡከ ዎደ ይንታጎ Ꮉንጎዳኖ ላꬃላ አማንንታነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ይን ጋራን፥ ታኒ፥ ታ እሻ ኤጳፍሮድቱሳ፥ ታራ ዎላ ታ ባጋ ማቂ ኦችዳያ፥ ኦልንትዳያን፥ ታና ማዶደስ ይንትስ ኪትንትድያ፥ ይንታጎ ኪቶደስ ቆፕዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ኤ ይንታና ኡባ በአደስ ጋማ አሙꬋነ። ማህ ኤ Ꮉርግንትዳኖ ይን ስእደ ግሾ ፋ ዎዝንተ ጋማ ኡንእንታነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ኤ ቱሮ Ꮉርግንቲ Ꮉይቆስ ዪእ አትዳ። የዝን ጾዚ ኤዛ ማርዳ። ኤ ጻላላስ ባይዝን አዛኖ አዛኖላ አፋ ጉጁንታመ ፋና፥ ታስን ይቅስንትዳ። ");
INSERT INTO oyde_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ይኬ፥ ይን ኤዛ ማህ ብእ ኡፋይቶደ ፋና ታስን ታ ዎዝንተ ምችቶ ቶይሳደ ፋና ታ ኤዛ ኤልሲ ይንታጎ ዳኮደስ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ላꬃ አማንዘ ግሾ ኡፋይሳራ ሞኮተ። ማህ ኤ ፋና የዘ አስ ኡባ ቦንቾተ። ");
INSERT INTO oyde_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ይን ታ ካለ ማቂ ኦቾደስ ዳንዳኦሰ ማደ ማዲ ክርስቶሳ ኦቻ ግሾ ፋ ሸምፕትስ ይቅስንታንጽ Ꮉይቆስ ዪእ አትዳ። ");
INSERT INTO oyde_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ይኬ፥ ታ እሹንꬆ፥ ይን ላꬄ ባዝ ማቅደ ግሾ ኡፋይቶተ። ታኒ ቲኖ ጻፍዳን ፋና ማህ ጻፎዳና ታና ዋይꬆስ፥ የዝን ይንታና ባልንተፓ ናጎደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ኢታ ባዝ ኦችዘ ካኑንꬃፓን፥ ማህ ጋራዝንቶደስ ቤዛነ ጋዘ ኢታ አሱንꬃፓ ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","ኑኒ ጾዘ ጌሽ አያናራ ጎይንዘ ግሾን ኑ የስተ ክርስቶስ የሱሳራ ጬቅንትዘ ግሾ ቱሪ ጋራዝንተ ጋራዝንትዱንꬃና። ኑኒ አሳትꬃላ አፋ ኦችንትዘ ባዛላ ጬቅንቶስ። ");
INSERT INTO oyde_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ታ በንትዘ አሳትꬃላ ጬቅንቶደስ ቤዝኮ ታ ጋማ ባዛራ ጬቅንቶደስ ዳንዳአነ። አኮ አስን ፋ በንትዘ አሳትꬃላ ጬቅንትዘ ባዝ ፋስ የነ ጋእ ቆፕኮ፥ ታኒ ኤፓ ጋማ አꬊ ጬቅንትዘ ባዝ የነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","ታኒ የልንትደ ኦስፉን ቃማራ ጋራዝንትዳ። ታኒ የልንተራ እስራኤለ፤ ብንያመ ኮች፤ ታኒ ዎርቂንተ ባይዘ አይሁደ አስ። አይሁደ ህገ ናገራ ማቅኮ ታኒ ፋርሳወ። ");
INSERT INTO oyde_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","አይሁደ አማኖ ቅናተራ ማቅኮ ታ ዎሳ ኬꬃ አማንዙንꬃና ባይአነ። ፈቲ አስ ህገ ናጊ ጽልዘባዝ ማቅኮ፥ ታላ ቦረ በንትካያ። ");
INSERT INTO oyde_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","የዝን ዛጋ ታና ማዳነ ጋእ ቆፕደባዝ ኡባ፥ ክርስቶሳ ግሾ ጋእ ማዶሰ ባዝ ማህ ፋይድዳ። ");
INSERT INTO oyde_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","ይኖ ጻላላ ባይዝን ታኒ ታ ላꬄ ክርስቶስ የሱሳ ኤርዛና መለባዝ ኡባፓ ጋማ አꬍዘ ግሾ ይና ኡባኖ ትርፈ ባይዘ ፋና ፋይድዳ። ታኒ ኤ ግሾ ኡባነ ቆህንትዳ። ክርስቶሳ ደንጎደስ ኡባ ባዝ አላ ኦልንትደ ቡረ ፋና ፋይድዳ። ታኒ የሱሳራ ፈቶ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ይኖ ዪዛና ህገላ ማቅደ ታ ኦማ ጽሎትꬅ አሺ አማኖላ ማቅደ ጾዘ ጽሎትꬅ ክርስቶሳ አማኒ ደንጎደስን ኤራ ዎላ ማቃደስ። ");
INSERT INTO oyde_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","ታኒ ክርስቶሳን ኤ ደንዶ ዎልቅቶ ኤሮደስ ኮያነ። ታኒ ኤ ዋይቶ ኤራ ግሽንቶደስ ኤ Ꮉይቅተ ኤ ደንድቶ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ይኒ ጋር፥ Ꮉይቆፓ ደንዲ መዽና ደኦ የሳደስ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ታኒ Ꮉተ ቆፕደ በስቶ የልዳ ዎይ ታ ግዳ ባላ ባያ ጋኦስ። የዝን ክርስቶስ የሱሳ ታና አይክደ ግሾ ታኒ ታ ቲኖ የዘ ዎይቶ አይኮደስ ዎጻነን ቡቱንታነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","ታ እሹንꬆ፥ ታኒ ይኖ ደንግዳ ጋእ ቆፖስ፥ የዝን ታኒ ፈቲ ባዝ ኦቾዳ። ታፓ ሱባራ የዛኖ ቦቲ ቲኖ የዛኖ አይኮደስ ሼልንቃነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","ይኒ ግሾ፥ ታኒ ቆፕደ በስቶ የሎደስ ዎጻነ። ጾዘ ክርስቶስ የሱሳ ባጋራ ሳሎ የዘ መዽና ደኦስ ጼግደ ዎይቶ ኤኮደስ ኤልሳነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ይኬ፥ ኑኒ አያናራ ሚንግደ ኡቡንꬅ Ꮉኖ ቆፖደስ ቤዛነ። ይንታፓ ባጉንꬅስ ዱሙዽዘ ቆፋ የዝኮ፥ ይኖን ጾዚ ይንትስ ቆንጭሳዳ። ");
INSERT INTO oyde_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ማቅኮን፥ ጾዚ ኑስ ቆንጭዝደ ቱርተ፥ ቲኖ Ꮉማዳ። ");
INSERT INTO oyde_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","ታ እሹንꬆ፥ ታና አዞተ፤ ይኒ ፋናን፥ ኑና አዚ ካልዘ መለ አሱንꬃና ቆፒ ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ታኒ ይኖ ይንትስ ቲኖ ጋማ ቶሄ ኦህዳ፥ የዝን Ꮉተን ማህ አፉꬃራ ኦህነ። ፋ የስተ ክርስቶሳ ማስቃላስ ፋና ሞርከ ማህደ ጋማ አሱንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","ኡን ፎልታ ꬋበ፤ ኡን ሳዝታ ኡንትስ ላꬂ። ዬልꬎደስ ቤዝዘ ባዛ ኡን ጬቅንታነ፤ ማህ Ꮉና ሳእትባዝ ጻላላ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ኑ ጋድታ ሳሎ። ሳሎፓ ይእ ኑና አሾደስ የዘ ላꬂ የሱስ ክርስቶሳ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","ክርስቶሳ ኡባባዝቶ ፋ አደትꬅ ዎልቃፓ ኦሞራ ማሆደስ ዳንዳእዘ ፋ ዎልቃራ ኑ ላቢꬅ አሳትꬅቶ ላሚ ፋ ቦንቾ አሳትꬅቶ አዞደ ፋና ዪሳዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","ታ እሹንꬆ፥ ታ ካꬍዙንꬆ፥ ታ አሙꬍዙንꬆ፥ ታና ኡፋይስዙንꬆን፥ ታና ጬቅዙንꬆ ይኬ ላꬃራ ሚንግ ኤቆተ። ");
INSERT INTO oyde_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ኤዎድን ስንጺካን፥ ይን ላምኡንꬅ፥ ፈቲ ቆፋራ ላꬃራ የሳደ ፋና ታ ይንታና ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","ታራ ኦችዘ አማንꬅዛዮ፥ ኔኒ Ꮉንꬅ ማቹንꬃና ማዶደ ፋና ታ ነና ዎሳነ። Ꮉንꬅ ማቹንꬅ ታራ፥ ቀለምንጾሳራን ኡን ሱንꬅታ ጾዘ ደኦ ማጻፍተ ጻፍንትደ መሉንꬃራ ዎላ ዎንገለ ኡባ በሳ የልꬆደስ ላቢዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ላꬃራ የዛነ ኡባ ዎደ ኡፋይቶተ። ታኒ ይኖ ጉጂ ኦህነ፤ ኡፋይቶተ። ");
INSERT INTO oyde_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","አስ ኡባ ይን ሎኦትꬅቶ ኤሮ፤ ላꬂ ኡከራ ዮኦዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ጾዝ ይን ዎስዘ ዎደ ኡባ ባዛራ ኤዛ ጋላትተራ፥ ይንታና ቤዝዘ ባዝ ኡባ ዎሶተፕ አትን አኮ ባዝስን ይርግፐተ። ");
INSERT INTO oyde_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","አስ ኤራትꬅ ኡባፓ አꬍዘ ጾዘ ሳሮትꬅ፥ ይን ዎዝንቶን ይን ቆፍቶ ላꬂ የሱስ ክርስቶሳስ ማቅዳነ ናጎዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ዉርሱꬅተ፥ ታ እሹንꬆ፥ ይን ዎዝንተ ሎኦ ባዝን ጋላትዘ ባዝ ቆፖተ። ቱሮ ማቅደ ባዝ ኡባ፥ ቦንቾ ባዝ ኡባ፥ ቆሄ ማቆሰ ባዝ ኡባ፥ ጌሽ ባዝ ኡባ፥ ሲቆባዝ ኡባ ኡፋይስዘ ባዝ ኡባ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ይን ታፓ ታማርዳኖ፥ ኤክዳኖ፥ ስእዳኖን ብእዳኖን ኡባ ኦቾተ። ሳሮትꬅ እንግዘ ጾዘ ይንታራ ዎላ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ጋማ ዎደፓ ሱባ፥ ይን ታ ባዝ ማህ ቆፋ አይክደ ግሾ ታኒ ላꬄ ግዳ ጋማ ኡፋይታነ። ይኖ ጋዛና፥ ታስ ቆፖደስ ይንትስ ዎታንጽደ ግሾፕ አትን ታስ ቆፍቶ አሽካያ። ");
INSERT INTO oyde_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ታኒ ይኖ ታና ማꬍደ ግሾ ጋኦስ፤ ታስ የዛና ማቃዳ ጋዛኖ ታማርዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ታኒ ማꬍꬊ የዘ የሲን ኤራነ፤ ማህ ዱርꬊ የዘ የሲን ኤራነ። አባን ማቅን ማህ አኮ ዎደን ታኒ ምሽን ናየ፥ ፋጨን ኩመን ኡባነ ታስ የዛና ማቃዳ ጋዛኖ ታማርዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ዎልቃ እንግዘ ክርስቶሳራ ኡባ ባዝ ኦቾደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ማቅኮን፥ ይን ታ ማꬍተ ማድዳነ ሎኦ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ፍልጵስዩሳ አሱንꬅ፥ ዎንገለ ቲኖ ኦሆደስ ታኒ መቀዶንያፓ ከዝዘ ዎደ እንግዘ ባዛን ኤክዘ ባዛ ይን ዎሳ ኬꬅትፋ መለ ዎሳ ኬꬂ ታና ማድካይዛኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ተሰሎንቄ የዘ ዎደን ታና ኮሽዘባዛ ማህ ማህ ማድዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","ታኒ፥ ይንታፓ እሞ ኤኮደስ ኮይ ባይዝን እሞፓ የእዘ አንጆ ይን ኤኮደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ታስ ኮሽዛኖን ኮሽዛንፓ አꬂ ይን ታስ ዳክደ እሞቶ ኤጳፍራድቱሳፓ ኤክዳ፤ ይናን ይን እሞታ ጾዚ ኤክዘ ሳዎ ቶንኩ ጋዘ፥ ኤ ካዽዘ፥ ኤ ኡፋይትዘ ዣርሾ ፋና። ");
INSERT INTO oyde_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ታ ጾዘ ፋ ዱረትꬅትፓ፥ ቦንቾ ክርስቶስ የሱሳ ባጋራ ይንትስ ኮሽዘ ባዝ ኡባ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","ኑ አዳይ ጾዘስ መꬍናፓ መዽና የሎደስ ቦንቾ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","ክርስቶስ የሱሳ ባጋራ ጾዘ ባዝ ማቅደ ኡቡንꬃና ሳሮ ጋኦተ። ታራ የዘ እሹንꬅ ይንታና ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ጾዝስ ማቅደ አሱንꬅ ኡባ፥ ኡባፓ አꬂ ካት ቄሳረ ኬꬃ የዙንꬅ ይንታና ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ላꬄ የሱስ ክርስቶሳ አꬎ ከሃትꬅታ ይንታራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","ጾዘ ቆፋ ክርስቶሳ የሱሳ ሐዋረ ማቅደ ጳዉሎሳን ኑ እሸ ጢሞትዮሳ፥ ");
INSERT INTO oyde_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ቆላስያሳ ካታማ የዘ ክርስቶሳ ግዳ አማንንትደ አሱንꬅስ ጻፍደ ኪታ። ጾዘ ኑ አደፓ አꬎ ኬሃትꬅን ሳሮትꬅ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","ኑኒ ይንትስ ዎስዘ ዎደ ጾዘ ኑ ላꬃ፥ የሱስ ክርስቶሳ አዳያ ኡባ ዎደ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","ኑ ክርስቶስ የሱሳ ግዳ የዘ ይን አማንቶን ጾዘ አሱንꬅስ ኡባ የዘ ይን ሲቅቶ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ይኖ ይን ኦችዳና ይን ኡፋይስታ ሳሎ ይንትስ ናግንትደ ግሾ። ይን ቱሪ ኪታ ማቅደ ዎንገለ ቲኖ አማንደ ዎደ ይና ኡፋይስቶ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","ይን ዎንገለ ስእደ ዎደ ጾዘ አꬎ ኬሃትꬅ ቱርቶ ሻኪ ኤርደ ዎደፓ አይኪ ይን ግዳ Ꮉንዳን ፋና ሳአ ኡባ ድጭተራን ኣፍትራን የነ። ");
INSERT INTO oyde_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ይን ይኖ ኑራ ዎላ ክርስቶሳስ ኦችዘ አማንንትደን፥ ካꬍንትደ ኤጳፍራፓ ታማርዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ኤ ይንላ አፋ ጉጂ ጌሽ አያና ይንትስ እንግደ ሲቆባዝ ኑስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ይኒ ግሾ፥ ኑ ይን ባዝ ስእደ ዎደፓ አይኪ፥ ጾዚ ፋ ቆፍቶ ይንታና ቤሳደ ፋናን፥ ጌሽ አያና እንግዘ ኤራትꬅን ጭንጫትꬅ ኡባ ይንታና ኩንꬆደ ጋር ኡባ ዎደ ይንትስ ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","ይኒ ፋና፥ ላꬂ ኮይዛን ጋራ ይን የሳደ ጋር፥ ኡባ ዎደ ኤዛ ኡፋይሶደ ጋር፥ ሎኦ ኦቻ ኡባ ይን ኣፈ አፎደ ፋናን ጾዛ አꬊ ኤርተራ ድጮደ ጋር ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","ጾዘ ቦንቾ ዎልቃ ይን ኡባ ባዛ ገንጮደ ፋናን ዳንዳኦደ ፋና ፋ ምንꬅትሞ እንግ ይንታና ኡፋይሶ። ");
INSERT INTO oyde_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","ማህ ጾዘ አሱንꬅ ፎኦ ካእቱሞ ላቶደ ጋር ይንታና ማህደ አዳያ ጋላቶተ። ");
INSERT INTO oyde_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","ኤ ኑና ꬉማ ዎልቃፓ አሺ ፋ ካዽዘ ናአይ ካእቱሞጎ ክእዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","ኤ ባጋራ ዎዝንት ኤ ሱꬅተ ናጋራ ማሮትꬅ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ክርስቶሳ በንቶሰ ጾዝስ ቱሪ አዝዘ። ኤ መꬍንትደ ባዝ ኡባፓ ቲኖን አንግስ። ");
INSERT INTO oyde_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","ኡባ ባዝ ኤ ባጋራ መꬍንትዳ። በንትዘባዝን በንቶሰ ባዝ፥ ዎልቃሙንꬅን ላꬁንꬅ፥ አህዙንꬅን አደትꬅ ዎልቃ አዱንꬅ፥ ሳሎን ሳአ የዘ ኡባና ኤስን ኤ ባጋራ መꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","ክርስቶሳ ኡባባዛፓ ቲኖ የነ። ኡባ ባዝ ኤ ባጋራ ፋ በስተ አይክንቲ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","ኤ ፋ ጋላ ማቅደ ዎሳ ኬꬅትስ ኦማ። ኤ ኡባፓ ካታራ ማቃደስ Ꮉይቆፓ ደንዶራ ቲኖን አንግስ። ");
INSERT INTO oyde_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","ጾዘ ኩሙꬅ ዎልቅታ ናአይ ግዳ የሳደ ፋና ጾዘ አዳይ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","ማህ ማስቃላላ አፋ ላልደ ፋ ናአይ ሱꬅተ ሳሮትꬅ መꬊ ሳሎን ሳአ የዘ ኡባ ኤ ባጋራ ፋራ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Ꮉንፓ ቲኖ ይን ቆፋ ኢታትꬅታ ይንታና ጾዛፓ ሻጊ ኤራ ሞርከ ማህዳ፤ ይን ኦችታን ኢታ። ");
INSERT INTO oyde_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","የዝን Ꮉተ ክርስቶሳ አሾራ Ꮉይቂደ Ꮉይቅት ባጋራ ጾዚ ይንታና ፋራ ጊግዝዳ፥ ጌሹንꬃና፥ ቦረ ባይዙንꬃናን ጽሉንꬃና ማህዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ይን፥ ይን አማንተ ኤንአንጽ ሚንግ የሳደስ ቤዛነ። ይን ዎንገለ ቃላ ስእደ ዎደ ኤክደ ኡፋይስቶ ምንꬂ አይኮተ። የ ዎንገልዘ ይን ስእዳያን ሳአ ኡባ ሳባክንትዳያ። ታ፥ ጳዉሎሳን Ꮉይ ዎንገልዘስ ኦቻንቾ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ታ ይን ግሾ Ꮉተ ኤክዘ ዋይተ ኡፋይታነ። ክርስቶሳ ፋስ ጋላ ማቅደ ዎሳ ኬꬅትስ ኤክደ ዋይተ አትዳኖ ታኒ ታ አሽተ ፎላነ። ");
INSERT INTO oyde_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ጾዘ ቃላ ይንትስ ፋዲ ኦሆደ ጋር ታስ እንግንትደ አደትꬅ ዎልቂተ ዎሳ ኬꬅስ ኦቻንቾ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Ꮉይ ቃልዘ ዛጋ አꬍደ ዎደ የለቱንꬅ ኡባፓ አችንት የዝዳ። የዝን Ꮉተ ጾዚ Ꮉና ሳዛ ቆፍቶ አማንዘ ኡቡንꬅስ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ጾዚ አይሁደ ማቆሰ አሱንꬅ ግዳ Ꮉና ሳዛ ቆፍቶ ቦንቾ ዱረትꬅታ አኮ ፋና ዳማ የዛኮ ቆንጭሳደስ። ኤዝን ቦንቾ ኡፋይስ ማቅደ ይን ግዳ የዘ ክርስቶሳ። ");
INSERT INTO oyde_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","ይኒ ግሾ፥ ፈቲ ፈቲ አስ ክርስቶሳ ግዳ ኩሙꬅ አስ ማህ ሺሾደስ ጭንጫትꬅ ኡባ አስ ታማርሰራን ዞረራ ክርስቶሳ ኡን ሳባካነ። ");
INSERT INTO oyde_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ጾዚ ፋ ዳማ ዎልቂተ ታ ግዳ ኦችዘ ግሾ Ꮉኖ የሎደስ ኤ ዎልቂተ ዋይተራ ላባነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ታ ይንትስን ሎዶቅያ ካታማ የዘ አሱንꬅስ፥ ይኒ ጋር ታና ኣፈራ ብእካይዘ አሱንꬅ ኡቡንꬅስ አኮ ጋር ኦልንትዛኮ ይን ኤሮደ ፋና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","ታ ኦልንትዘ ምክናታን ኡን ፋ ዎዝንተ ሚንግ፥ ሲቆራ አጭንቲ፥ ፎሎ ማቅደ ኩሙꬅ ቆፋ ዱረትꬅ ደንግ ጾዘ ሳዛ ቆፍቶ ክርስቶሳ ኤሮደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ኤ ግዳ አችደ ኤራን ጭንጫትꬅ ኡባ የነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ታ ይኖ ኦደን ይንታና ጭሞ ቃላራ ባልꬃመ ጋር ኮይ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","ታ ይንታፓ Ꮉኪ የዝኮን አያናራ ይንታራ የነ። ይን የስ ዎግቶን ክርስቶሳ ይን ሚንግ አማንዳኖ ብእ ኡፋይታነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ይን ላꬄ ክርስቶስ የሱሳ ኤክዳን ፋና ኤራ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ኤ ግዳ ጻጶ ዳኮተ፤ ኤ ግዳ ኬጽንቶተ። ይን ታማርዳንፋና አማኖራ ምንጎተ፤ ጾዝስ ኩሚ ላንትዘ ጋላታ እንጎተ። ");
INSERT INTO oyde_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","ክርስቶሳፓ ማቅካይዝን አስ ዎጋራን Ꮉና አላመ ጨር ዎጋራ ኤቂ ትምርተራን አሳፓ ይእደ ኤራትꬃራ ኦደን ይንታና ጭሚ ባልꬂ ኤካመ ፋና ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","ጾዘ ጾዘትꬅታ ክርስቶሳ ጋልተ ኩሙꬅ ቆንጪ የነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ይንትን አደትꬅ ዎልቃ ኡባስ ኦማ ማቅደ ክርስቶሳ ግዳ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","ይን ክርስቶሳ አማኒ ጋራዝንትዳ። ይናን አስ ኩሸ ማቅካይዝን ይንታና ኢታ ናጋራ Ꮉኖትꬃፓ ካይዘ ክርስቶሳራ ኦችንትደ ጋራዝንተ። ");
INSERT INTO oyde_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","ይን ጻማቅንትደ ዎደ ክርስቶሳራ ሞግንቲ፥ ክርስቶሳ Ꮉይቆፓ ደንꬅደ ጾዘ ዎልቃ አማኒ፥ ክርስቶሳራ ደንድዳ። ");
INSERT INTO oyde_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ይን፥ ይን ናጋራ ግሾን ይን ናጋራ አሳትꬅታ ጋራዝንትካይዘ ግሾ Ꮉይቂዳ የሻ፥ ጾዚ ይን ናጋርቶ አቶ ጋይዳ። ክርስቶሳራ ይንትስ ደኦ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","ኤ ኑና ሞቲ ኑራ ኦልንትዘ ህግቶ Ꮉሲ፥ ኑላ አፋ ጻፍንትደ ጋልቶ ፈርእ ማስቃላላ አፋ ሱጺ ኦገፓ Ꮉስዳ። ");
INSERT INTO oyde_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ክርስቶሳ ዎልቂቶን አደትꬅቶ ማስቃላላ ጋሚ፥ ኡን ኦላ ማሣርቶ ብልዚ፥ የዝደ አስ ፋና ኦቺ ኡንታና ቆንጭዝ ቤዝዳ። ");
INSERT INTO oyde_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ይኒ ግሾ፥ ሙእዘ ባዛራ ዎይ ኡዥዘ ባዛራ፥ ባአለ ዎደ ዎይ አግና ጼርዘ ቃማ ቦንቾራ ሳምባታ ቦንቾራ ኦደን ይንታላ አፋ ፍርድፐ። ");
INSERT INTO oyde_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Ꮉንስ ቲኖፓ ዮኦደስ የዘ ባዝስ ዳሾ፥ የዝን ቱርዘ ክርስቶሳ። ");
INSERT INTO oyde_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ዎዝናፓ ባይዝን አሽከትꬃራን ኪታንቾ ጎይኖራ ጨር ጬቅንተራ ኦደን ይንታና ፍርድፐ። ይኒ ፋና አስ ፋ ብእደ ቆንጭꬅተ ናሽንትተራ ፋ አሾ ቆፋራ Ꮉሪ ኡቱርታነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","የንꬅ ጋርዘ አስስ ኦማ ማቅደ ክርስቶሳራ የልንተ ባያ። ኤ ኡባ ጋልቶን ጋላ ጻጶራን ዎል የልꬅ ሙዚ ድቻነ። ጾዚ ይኒ ጋርዘ ኦገራ ጋላ ኡባስ ድች እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","ይን ክርስቶሳራ Ꮉይቂ Ꮉና አላምቶ አህዘ አያና ዎልቃፓ ዋሎ ከዝዳ። ዬዝን፥ አኮስ ሻክንትካይዘ አስ ፋና ማቂ Ꮉና ዎግትስ አቀተ? ");
INSERT INTO oyde_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","Ꮉና ዎግታ፥ «አይክፐ፤ ላእፐ፤ ቦችፐ» ጋእንትዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Ꮉና ኡባ አስ ዎጋን ትምርተ ማቅደ ግሾ ኦቻላ አፋ ፌዥደፓ ሱባ ꬋቦዳ። ");
INSERT INTO oyde_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Ꮉንꬅ ኪቱንꬅ ፋ ቆፋፓ ደንድደ ጎይኖን ጋማ አዳ፥ አሳትꬅ ዋይꬅዛን ግሾ ጭንጫ የዘ ባዝ አዛነ፥ የዝን ኑ ኢታ አሞትꬅትላ አፋ ዎልቃ ኡንትስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ይኬ፥ ይን ክርስቶሳራ Ꮉይቆፓ ደንድዳን ፋና፥ ጾዛፓ ምዛቅ ዛላራ በትደ ክርስቶሳ የዘ በስተ፥ ሳሎ የዘ ባዝ ኮዮተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","ሳሎ የዙንꬃላ አፋ ይን ቆፍቶ ጋዶተ ፋትን ሳአ የዘባዛላ አፋ ጋድፐተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","ይን Ꮉይቆራ ሻክንትደ ፋና Ꮉና አላመ ናጋራ ኦቻፓ ሻክንትዳ። ይን ደእታ ክርስቶሳር ዎላ ጾዘ ግዳ አችንትዳ። ");
INSERT INTO oyde_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","ይንትስ ደኦ ማቅደ ክርስቶሳ ቆንጭዘ ዎደ የ ዎደ ይንትን ኤራ ቦንቾር ቆንጮዳ። ");
INSERT INTO oyde_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ይኒ ግሾ፥ ይን ግዳ የዘ አላመ አሞትꬅቶ ዎꬎተ። የንስን ኦላለ፥ ቱናትꬅ፥ ኦላሎደስ አሙ፥ ኤቃ ጎይኖ ፋና ማቅደ ቂር። ");
INSERT INTO oyde_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Ꮉንስ ባጋራ ጾዘ ባድꬅ ኪትንቶሰ አሳላ አፋ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","ይንትን ዛጋ ይና ኢታ ኦግተ Ꮉንትተራ Ꮉንሳና ኦችተራ የሻ። ");
INSERT INTO oyde_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Ꮉተ ይን Ꮉንሳና ባድꬅ፥ እጻ፥ ካች፥ ዝግርስ፥ ቦርስዘ ኦሄ ይንታፓ Ꮉሶተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","ጋልአ አሞትꬅቶ እ ኦችትራ ይንታፓ ጋርደ ግሾ ፈተ ፈተስ ዎርድꬍፐተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","ጾዘ መꬎ አዝዘ፥ ኤራትꬃራ ላምንትደ ክለ Ꮉኖትꬅ ማኦተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Ꮉና ክለ መትꬅተ፥ ግርኬ አስ ዎይ አይሁደ አስ፥ ጋራዝንትደ ዎይ ጋራዝንትካይዘ፥ ባርባረ አስ ዎይ እስኩተ አስ አሮ ዎይ ቦንቾ አስ ባያ። ክርስቶሳ ኡባ፤ ኤ ኡባነ የነ። ");
INSERT INTO oyde_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","ይኒ ግሾ፥ ጾዛራ ዶርንትደ አስ ፋና ጌሹንꬃናን ካꬍንትዱንꬃና ማቂ፥ ማሮትꬅ፥ ኬሃትꬅ፥ አሽከትꬅን ዳንዳአ ማኦተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","ፈታይ ፈታ ዳንዳኦተ። ኦደን ላገ ቆህደ የዝኮ ኤስ አቶ ጋኦ። ላꬂ ይንትስ አቶ ጋእዳን ጋራ ይንትን ዎልስ አቶ ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","ይና ኡባንላ አፋ ኡባኖ ፈትላ ሺሺ አጭዘ ሲቆ ማኦተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","ጾዚ ይንታና ፈቲ አስ ማህ ጼግዳና፥ ሳሮትꬅስ ማቅደ ግሾ ክርስቶሳ ሳሮትꬅታ ይን ዎዝንቶ አሆ፤ ጋላትዙንꬃናን ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","ክርስቶሳ ቃላ ይን ዎዝንተ ኩሚ የዞ። ጭንጫትꬅ ኡባ ፈተ ፈታያ ታማርሶተን ዞሮተ። ማዝሙረራ፥ ናሸራ አያና የꬃራ ጾዛ ዎዝናፓ ጋላትተራ የጾተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","ጾዘ አዳይ የሱሳ ባጋራ ጋላትተራ ይን ኦህንትዘባዝ ዎይ ኦችዘባዝ ኡባ ላꬄ የሱሳ ሱንꬅተ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","ማቹንꬆ፥ አማንዘ አስስ በዝዘ ባዝ ማቅደ ግሾ ይን አዝኑንꬅስ አቆተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","አዝኑንꬆ፥ ይን ማቹንꬃና ካꬎተ፤ ኡንትስ ኢትፐተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","ናኡንꬆ፥ ይንታና የልዱንꬅስ ኡባ ባዛ ኪትንቶተ፤ ይና ላꬂ ኡፋይስዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","አዱንꬆ፥ ይን ናኡንꬅ ኡፋይስ ጋቻመ ጋር ኡንታና ዥልዝፐተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","አሩንꬆ፥ ሳአ ይንትስ ላꬂ ማቅዱንꬅስ ኡባ ባዛ ኪትንቶተ። ላꬂ ቦንችተራ ሉለ ዎዝናፓ ኪትንቲ ኡንታና ኡፋይሶተ ፋትን አስ ቦኦ ጋእ ኦችፐተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","ይን ኦችዘ ኦችቶ ኡባ አስስ ማቅካይዝን ላꬅስ ኦችዘ ፋና ዎዝናፓ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ላꬃፓ ላታ ዎይቶ ይን ኤኮዳኖ ኤሮተ፤ ይን ላꬄ ክርስቶሳስ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","ጾዚ አስ ስኖ ብእ ፍርዶሰ ግሾ ኦደን ኢታ ኦቻ ኦችኮ ፋ ኢታ ኦችት ግሾ ኩሸ ማሄ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","ላꬁንꬆ፥ ይንትስን ማህ ሳሎ ላꬂ የዛኖ ኤሪ፥ ይን አሩንꬅስ ጽሎትꬃራ ፈታ ፈተፓ ሻክካይዛራ ኮሽዘ ባዝ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ጾዛ ባርክ ጋላትተራ ጋችካይዛራ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","ጾዚ ፋ ቃልትስ ፉርꬅቶ ቡጎደ ፋናን ታኒ ይኒ ምክንያተር አቻ የዘ ክርስቶሳ ሳዛ ቆፍቶ አዋጆደ ፋና ኑስን ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","ማህ ታንን ቤዛን ፋና ቃላ ቆንጭዝ ኦሆደ ፋና ታስ ጾዝ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","ዎትዘ ዎደ ኡባ ማድንቲ አማኖሰ አስ ካለ ጭንጫትꬃራ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","ይን አስ ኡባስ ኮሽዘ ማሄ እንገ ኤሮደ ፋና ይን ኦህታ ኡባ ዎደ አꬎ ኬሃትꬃራ ኩምዳን ሶገር ማልእዛ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ኑ ሲቆ እሸ ትክቆሳ፥ ታራ ዎላ ላꬄ ኦችተ አሮ ማቅደ፥ አማንꬅዘ ኦቻንቾ፥ ታ የስት ባዝ ይንትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","ታኒ ኤዛ ይንታጎ ኪትዳና፥ ኑ ዋይዝ የዛኮ ይንትስ ኦህ ይንታና ምንꬅꬆደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","አናስሞሳ፥ አማንꬅዘ ሲቆ እሸ፥ ይን ባጋ፥ ኤራ ይንታጎ Ꮉንጋነ። ኡን Ꮉነ Ꮉንዘባዝ ኡባ ይንትስ ኦሆዳ። ");
INSERT INTO oyde_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","ታራ አጭንተዘ አርስጥሮኮሳን ባርናባሳ እሸ ናአይ ማርቆሳ፥ ይንታና ሳሮ ጋነ። ታ ይንትስ ዛጋ ኦህዳን ፋና ማርቆሳ ይንታጎ Ꮉንግኮ ኤዛ ሞኮተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","ኢያሱ ጋዘ ኢዮስጦሳ ይንታና ሳሮ ሳሮ ጋነ። ጾዘ ካእቱሞ ግሾ ታራ ኦችዘ አሱንꬅ ግዳፓ አይሁደ ማቅዱንꬅ፤ ታና ጋማ ምንꬅꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","ይን ባግዘ፥ ክርስቶስ የሱሳ አርዘ፥ ኤጳፍራ ይንታና ሳሮ ሳሮ ጋነ። ኤ ይን ጾዘ ቲኖ ሚንግ ኤቆደ ፋናን ጾዘ ቆፋ ኤሪ ፎሎደ ፋና ኡባ ዎደ ጾዚ ይን ግሾ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","ኤ ይን ግሾን ሎዶቅያን ህራፖሊሰ ካታማ የዘ አሱንꬅ ግሾ ጋማ ላቢዳኖ ታ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ኑ ሲቆ እሸ አክምዘ ሉቃሳን ዴማሳ፥ ይንታና ሳሮ ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","ሎዶቅያ የዘ ኑ እሹንꬅስ፥ ንምፋሳን እ ኬꬅተ ሺቅዘ አሱንꬅስ ኑ ሳሮትꬅቶ ኦሆተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Ꮉይ ዳብዳቢዛ ይን ናባብዳንፓ ሱባ፥ ሎዶቅያ ዎሳ ኬꬃ ናባብዞተ። ይንትን ሎዶቅያ ዎሳ ኬꬅታ ይንትስ ዳክዘ ዳብዳብቶ ናባቦተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","ማህ አርክጳሳ፥ «ላꬂ ኔስ እንግደ ኦችቶ ፎሎዳኖ ቦትፐ» ጋእ ቆፍዞተ። ");
INSERT INTO oyde_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","ታኒ፥ ጳዉሎሳ፥ Ꮉና ሳሮትꬅቶ ታ ኩሽትራ ጻፍዳ። ታ አችቶ ቆፖተ። ጾዘ አꬎ ከሃትꬅታ ይንታራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","ጳዉሎሳ ስላሰን ጢሞትዮሳ ተሰሎንቄ ዎሳ ኬꬃ የዘ አሱንꬅስ፥ ጾዘ አደስን ላꬄ የሱስ ክርስቶሳስ ማቅደ አሱንꬅስ ጻፍደ ኪታ። አꬎ ኬሃትꬅን ሳሮ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","ኑኒ ጾዝ ዎስዘ ዎደ ኡባ ይንታና ቆፕተራ ይን ግሾ ኡባ ዎደ ጾዛ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","ጾዘ ኑ አዳይ ቲኖ አማኖራ ይን ኦችደ ኦቻ፥ ሲቆራ ይን ላብደ ላብꬅቶ የሱስ ክርስቶሳራ የዘ ኡፋይስቶ ኤኮደስ ይን ሚንግ ኤቅደ ኤቅቶ ኡባ ዎደ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","ኑ እሹንꬆ፥ ጾዚ ይንታና ካꬍዛኖን ፋ ባዝ ማህ ይንታና ዶርዳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","አኮስ ጋይኮ፥ ኑኒ ዎንገለ ዶናራ ጻላላ ባይዝን ዎልቃራ፥ ጌሽ አያናራን ዎንገለ ምንꬂ አማኖራ ይንትስ ክእዳ። ኑኒ ይንታራ ጋምእደ ዎደ ኡባ ይን ግሾ ዋይዝ የዘዛኮ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","ይን ጋማ ማꬋ ኤክኮን ጌሽ አያና እንግዘ ኡፋይሳራ ኪቶ ኤክዳ፤ ኑናን ኑ ላꬃ አዝዙንꬃና ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ይኒ ግሾ፥ መቀዶንያን አካያ አዉራጃ የዘ አማንዘ ኡቡንꬅስ አዝዘ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","ላꬄ ቃላ ይንታፓ ኬዚ፥ መቀዶንያን አካያ ጻላላስ ባይዝን ጾዛ ይን አማንዛና ኡባ በሳ ስንትዳ። ይኬ፥ ኑ ጋዉደ ባዝ አኮን ባያ። ");
INSERT INTO oyde_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","ኑኒ ይንታጎ Ꮉንግደ ዎደ ይን ኑና ሞክደ ሞክተ ይን፥ ይን ኤቅቶ አሺ ቱሮን ደኦ ጾዛ ማዶደስ ይን ማቅዳኖ ኡን ፋ ኦምተ ኦህነ። ");
INSERT INTO oyde_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","ማህ ጾዘ ናአያ፥ የሱሳ፥ ጾዚ Ꮉይቆፓ ደንꬅዳኖ፥ ቲኖፓ ዮኦደስ የዘ ጾዘ Ꮉንቆፓ ኑና አሾዳያ፥ ሳሎፓ ዮኦዳያ ይን ናግዛኖ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","ታ እሹንꬆ፥ ኑኒ ይንታጎ Ꮉንግዳና Ꮉሪ ባይዛኖ ይን፥ ይን ኦምተ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","የዝን ኑኒ ይንታጎ ተሰሎንቄ ዮኦደፓ ቲኖ ፍልጵስዩሳ ካታማ ዋይንተዛኖን ጫዥንትዳኖ ይን ኤራነ። ጋማ ኑና እጽዘ የዝኮን ይንትስ ኤ ዎንገለ ኦሆደ ፋና ጾዚ ኑስ ምንꬅትሞ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","ኑኒ ይንታና ዞርደ ባልራ ዎይ ጭሞራ ዎይ ገነራ ባያ። ");
INSERT INTO oyde_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","የዝን ጾዚ ኑና ቤዙንꬃና ጋእ ፋይድደ ግሾ ዎንገለ ኦሆደ ፋና ኑስ Ꮉዳራ እንግደ ግሾ ኦህነ። ኑ ይኖ ኦችዘ ኑ ዎዝንቶ በእዘ ጾዛ ኡፋይሶደስ ፋትን አስ ኡፋይሶደስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","ኑ ሚሸ ዥምባሪ ዎርዶ ይንታና ሳብተራ ይንታጎ ይእካይዛኖ ሎይꬂ ኤራነ፤ ጾዚ ኑስ ማርካ። ");
INSERT INTO oyde_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","ኑኒ ይንታፓ ማቅን ዎይ መለ አስ ኦደፋን ቦንቾ ኮይካያ። ");
INSERT INTO oyde_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","ኑኒ ክርስቶሳ ሐዋረ ማቅዳን ፋና ኑስ ኮሽዘ ባዝ እንጎተ ጋእ ኤኮደስ ዳንዳአነ፥ የዝን እንታ ፋ ናኡንꬃና ድችዛን ፋና ይን ግዳ አሽከ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","ኑ ይንታና ካꬍደ ግሾ ጾዘ ዎንገለ ይንትስ ሻከ ጻላላ ባይዝን ኑ ሸምፕቶ ይንትስ እንጎደስ ጊግዳ። ይን ኑስ ጋማ አልኦ። ");
INSERT INTO oyde_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","ኑ እሹንꬆ፥ ኑ ኦችቶን ኑ ላብꬅቶ ኤራነ። ይንትስ ጾዘ ዎንገለ ኦህተራ፥ ይንታና ዋይꬃመ ፋና ቃማን አዋራ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","ኑ የስታ ይን አማንዙንꬅ ካለን ጾዘ ቲኖ ጌሽ፥ ጽሎን ቦርንቶሱንꬃና ማቅዛንስ ይንትን ጾዝን ማርካ። ");
INSERT INTO oyde_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","ኑኒ ይንትስ ኦምተ ኦምተ የልዱንꬅ ፋ ናኡንꬅስ ኦችዛን ፋና ኦቾዳኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ኑ ይንታና ዞርዳ፥ ምንꬅꬅዳ። ማህ ፋ ካእቱምቶን ፋ ቦንችቶ ግሽንቶደስ ይንታና ጼግደ ጾዛ ኡፋይስዘ ደኦ ይን የሳደ ፋና ይንትስ ምንꬅ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","ይንትስን ኑኒ ጾዘ ቃላ ኦህደ ዎደ አስ ቃላ ፋና ባይዝን ጾዘ ቃላ ፋና ስእ ኤክደ ግሾ ኑኒ ኡባ ዎደ ጾዛ ጋላታነ። ኤ ቱሪ ጾዘ ቃላ፤ ጾዘ ቃላ አማንዘ ይን ግዳ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","ታ እሹንꬆ፥ ይን ይሁዳ ሳአ የዘ ዎሳ ኬꬅተን የይጋ ክርስቶሳ የሱሳ ካልዘ አሱንꬅ ፋና Ꮉንዳ። ኡን አይሁዱንꬅ ዋይꬅዛንፋና ይንታናን ይን ሳአ የዘ አሱንꬅ ዋይꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","የንꬅ አይሁዱንꬅ ላꬄ የሱሳን ናቡንꬃና ዎꬍዳ፤ ማህ ኑና ባይእዳ። ኡን ጾዛ ኡፋይሶሱንꬃናን አስ ኡባ እጽዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","ኡን መለ አቶ የዝን፥ አይሁደ ማቆሰ አሱንꬅን አቶደ ፋና ኑኒ ኡንትስ ቃላ ኦህዛኖ ካያነ። ይኒ ጋር ዪዚ ኡን ናጋርት ጹእታ ኩሞደ የሎደስ ኡባ ዎደ ናጋራ ኦቻነ። ዉርሱꬅተ፥ ጾዘ ካች ኡንታላ አፋ ዎꬋነ። ");
INSERT INTO oyde_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","የዝን ኑ እሹንꬆ፥ ኑኒ ኑ አያናራ ባይዝን አሾራ ይንታፓ ሻክንት ኤራꬅ ዎደ ጋምእዳነ ይንታና ጋማ አሙꬊ በአደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","ኑ ማቂ ይንታጎ Ꮉንጎደስ ኮይዳ። ታኒ ታ ኦምተ ይንታጎ Ꮉንጎደስ ኮይዳ፥ የዝን ጻላሄ ኑና ካይዳ። ");
INSERT INTO oyde_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","ይኬ፥ ኑ ላꬄ የሱስ ክርስቶሳ የእዘ ዎደ ኑ ኡፋይስታ ዎይ ኑ ጬቅንትዘ ኑ ዎይቱንꬅ ኦደ? ይንታና ባነ? ");
INSERT INTO oyde_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","ቱሮ ይን ኑስ ቦንቾን ኑስ ኡፋይስ። ");
INSERT INTO oyde_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","ይኒ ግሾ፥ ኑ ይንታና በአንጽዳነ ኑስ ገንጮደስ ዳንዳእንታንጽን፥ አቴና ካታማ ኑ ጻላላ አቶደስ ቆፋ አጭዳ። ");
INSERT INTO oyde_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","ይንታና ዞሮደ ፋና አማኖራ ይንታና ምንꬅꬆደ ፋና ኑራ ዎላ ጾዝስ ኦችዛን ክርስቶሳ ዎንገለ ኦህዘ ኑ እሻይ ጢሞትዮሳ ይንታጎ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","ይናን ይንታና የልደ ዋይተ ይንታፓ ኦደን ሱብ ማቅፈ። ይና ዋይታ ኑስ ጾዘ ቆፋ ማቅዳኖ ይን፥ ይን ኦምተ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","ኑ ይንታራ የዘ ዎደ ዋየ ኑና የሎዳኖ ይንትስ ቲንꬊ ኦህዳ። ይን ኤርዛን ፋና Ꮉንዳ። ");
INSERT INTO oyde_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","ይኒ ግሾ፥ ታስ ገንጮደስ ዳንዳእንታንጽን፥ «ኦደ ኤርዘ ጻላሄ ኡንታና ፋታኒ ኑ ላቢꬅቶ ጨር አሽካይዛራ አታማ» ጋእ ይን አማንትባዝ ኤሮደስ ጢሞትዮሳ ይንታጎ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Ꮉተ ጢሞትዮሳ ይን ካለፓ ይእ፥ ይን አማንትባዝ ይን ሲቅትባዝ ሎኦ ዎረ ኦህዳ። ማህ ይን ኡባ ዎደ ኑስ ሎኦ ቆፕዛኖን ኑኒ ይንታና በአደስ አሙꬍዛኖ ይን ኑና በአደስ አሙꬍዛኖ ኤ ኑስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","ታ እሹንꬆ፥ ኑና የልዘ ዋይተን ማꬍተ ማቅኮን ይን አማንቲ ግሾ ምንግዳ። ");
INSERT INTO oyde_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","ይን ላꬃራ ሚንግ የዝኮ ኑስን ደኦ። ");
INSERT INTO oyde_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","ይኬ፥ ኑኒ ይን ባጋራ ደንግደ ኡፋይስትስ ጾዛ ዋይዝ ጋላቶደ? ");
INSERT INTO oyde_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","ኑኒ ይንታና በአደስን ይን አማንተ ፋጭደባዝ ኩንꬆደስ ቃማን አዋራ ኑ ኩሙꬅ ዎዝንተ ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","ጾዘ ኑ አዳይ ፋ ኦምተ ኑ ላꬄ የሱስ ኑ ይንታጎ Ꮉንጎደ ኦግቶ ጊግዞ። ");
INSERT INTO oyde_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","ኑ ይንታና ጋማ ካꬍዛን ፋና ላꬂ ይንታና ፈታያ ፈታያ ሲቅዘ ሲቅተ አስ ኡባ ሲቆ ይንትስ ጋንꬅ ጉጆ። ");
INSERT INTO oyde_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","ኑ ላꬄ የሱስ ክርስቶሳ ፋ ጌሹንꬃራ ይእዘ ዎደ ጾዘ፥ ኑ አዳይ ቲኖ ይን ዎዝንታ ጌሽን ቦረ ባይዛ ማህ ኤ ይንታና ምንꬅꬆ። ");
INSERT INTO oyde_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","ዉርሱꬅተ፥ ታ እሹንꬆ፥ ጾዛ ኡፋይሶደስ ይን ዋይዝ የሳደስ ቤዝዛኮ ኑፓ ታማርዳ። ይኖ ይን ቲኖፓ የዝደ የስ፥ የዝን Ꮉተ ይን ቲኖስትፓ አꬂ ኦቾደ ፋና ላꬄ የሱሳ ቲኖ ይንታና ዎሳነን ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","ኑ ላꬄ የሱሳ ሱንꬅተ አኮ ኪታ እንገዛኮ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","ጾዚ፥ ይን ጌሽ ማቃደ ፋናን ኦላለ Ꮉንታመ ፋና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","ይን ፈታይ ፈታይ፥ ይን ማቹንꬃራ ጌሻትꬃራን ቦንቾራ የሳደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","ጾዛ ኤሮሰን አማኖሰ አስ ፋና ኦላለ Ꮉንተራ አሞራ ኤጽንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","ኑ ዛጋ ይንትስ ኦህዳን ፋና ምንꬂ ዞሪዳንፋና ላꬂ ይኒ ፋና ኦችዛ ኡባ ፍርድዘ ግሾ ኦንን Ꮉንሳራ ፋ አማንዘ እሻያ ቆሆደስን ጭሞደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","ጾዚ ኑኒ ጌሻትꬃራ የሳደ ፋና ፋትን ቱኒ የሳደ ፋና ጼግካያ። ");
INSERT INTO oyde_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","ይኒ ግሾ፥ Ꮉና ትምርትት ቆፍቶ እጽዘ ኦደን ይንትስ ጌሽ አያና እንግደ ጾዘ ቆፋ እጻነ ፋትን አስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","ይን ፈታይ ፈታይ ዋይዝ ሲቆድየዛኮ ጾዚ ይንታና ታማርስደ ግሾ Ꮉተ ሲቆባዝ ኑ ይንትስ ጻፎደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","ማህ መቀዶንያ የዘ አማንዙንꬃና ኡባ ቱሮ ይን ካꬋነ። የዝን ኑ እሹንꬆ፥ Ꮉተን ይን ኡንታና አꬂ ካꬎደ ፋና ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","ኑኒ ቲኖ ይንትስ ኦህዳን ፋና ዎፑ ጋይደ የስ የዞተ። ይን፥ ቤዝዘ ኦቻ ኦቺ ይንትስ የሳደስ ኮሽዘ ባዝ ደንጎተ። ");
INSERT INTO oyde_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","ይኒ ፋና Ꮉንኮ፥ አማኖሰ አሱንꬅ ካለ ይን ቦንችንቶዳ፤ ማህ ይንታና ኮሽዘ ባዝስ ኦደስን አዳሻማ። ");
INSERT INTO oyde_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","ኑ እሹንꬆ፥ አማኒ Ꮉይቅደ አሱንꬅ Ꮉኖደባዝ ይን ኤሮደ ፋና ኮያነ። ይን ኡን ግሾ ኡፋይስ ባይዘ አስ ፋና አዛንፈተ። ");
INSERT INTO oyde_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","ኑኒ፥ የሱሳ Ꮉይቅዳኖን ማህ Ꮉይቆፓ ደንድዳኖ አማናነ። ይኒ ጋር፥ ጾዚ የሱሳ አማኒ Ꮉይቅዱንꬃና ኤራ ዎላ ኮኦዳኖ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","ላꬂ ኑስ ኦህዳን ፋና ላꬂ የእዘ ቃማ ኤራ የልንቶደስ ኑኒ ፋጻ የዙንꬅ፥ Ꮉይቅዱንꬃፓ ቲኖስ። ");
INSERT INTO oyde_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","ላꬂ ዳማ ኪታ ኦꬃራ፥ ኪታንቹንꬅ Ꮉላቃ ኦꬃራ፥ ጾዘ ሞይዘ ኦለራ፥ ሳሎፓ ዎꬎዳ። ክርስቶሳ አማኒ Ꮉይቅዱንꬅ ቲኒ Ꮉይቆፓ ደንዶዳ። ");
INSERT INTO oyde_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","ይንፓ ሱባ፥ የ ዎደ ኑኒ ፋጻ የዙንꬅ፥ ላꬃራ ꬎነላ የልንቶደስ ኡንታራ ዎላ ሳሎ ኤክንቶዳ። ይንፓ ሱባ፥ ኑኒ ላꬃራ ዎላ መꬍናስ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","ይኒ ግሾ፥ Ꮉና ቃልተ ፈታይ ፈታያ ምንꬅꬆተ። ");
INSERT INTO oyde_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","ታ እሹንꬆ፥ Ꮉና Ꮉኖደ ዎደን አግና ይንትስ ጻፎደስ ኮሾስ። ");
INSERT INTO oyde_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","ላꬄ ቃምታ ካይዞ ቃማ የእዛን ፋና ዮኦዳኖ ይን ሎይꬂ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","አሱንꬅ፥ «ሳአ ሳሮ፥ አኮን Ꮉኖስ» ያጋዝን፥ ማቾ የሎ ꬋኤ አይክዛን ፋና ꬋበ ኡን ቆፕካይዝን ኡንታላ አፋ ዮኦዳ። ኡን አኮ ኦገራን ከስ ኤካማ። ");
INSERT INTO oyde_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","የዝን ኑ እሹንꬆ፥ ይና ቃምታ ይንትስ ካይዞ የእዛን ፋና ዮኦደስ ይን ꬉማ ባያ። ");
INSERT INTO oyde_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","ይን ኡባ ፎኦ አስን አዋራ የዘ አስ፤ ኑኒ ቃማ አስ ዎይ ꬉማ አስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","ይኒ ግሾ፥ ኑኒ መሉንꬅ ገንትዛን ፋና ገንቶደስ ቤዞስ፤ ኑኒ ባርኮደስን ጊጊ የሳደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","ገንትዙንꬅ ቃማ ገንታነ፤ ማꬅንትዙንꬅ ቃማ ማꬅንታነ። ");
INSERT INTO oyde_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","የዝን ኑኒ አዋራ አስ ማቅደ ግሾ ጊጊ የሳደስ ቤዛነ። አማኖን ሲቆ ጹሩረ ፋና ማእ፥ አቶትꬅ ኡፋይስ ኦማ ጋድዘ ኦላ መቆ ባርኔጻ ጋዲ የሳደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","ጾዚ ኑና ኑ ላꬄ የሱስ ክርስቶሳ ባጋራ ኩሙꬅ አቶትꬅ ኤኮደ ፋና ዶርዳ ፋትን ካችስ ዶርካያ። ");
INSERT INTO oyde_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","ኑኒ ፋጻ የዝኮ ዎይ Ꮉይቂኮ፥ ክርስቶሳ የእዘ ዎደ ኤራ ዎላ የሳደ ፋና ክርስቶሳ ኑ ግሾ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","ይኒ ግሾ፥ ይን ቲኖ ኦችዛን ፋና፥ ፈታይ ፈታይራ ዞርንቶተን ምንꬅꬆተ። ");
INSERT INTO oyde_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","ኑ እሹንꬆ፥ ይን ግዳ ኦቺ ላብዙንꬃና፥ ላꬄ ሱንꬅተ ይንታና ካልꬆደ ፋናን ዞሮደ ፋና ዶርዱንꬃና ቦንቾደ ፋና ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","ኡን ኦችዘ ኦችት ግሾ ኡንታና ጋማ ቦንቾተን ሲቆተ። ፈታይ ፈተራ ሳሮራ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","ኑ እሹንꬆ፥ ኑኒ ይንታና ዞራነ። ቦዙንꬃና ካጮተ፤ ዣሽትዙንꬃና ምንꬅꬆተ፤ ላብዱንꬃና ማዶተ፤ አስ ኡባ ዳንዳኦተ። ");
INSERT INTO oyde_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","ኦደን ኢታ ግሾ ኢታ ማሀመ ፋና ናግንቶተ። ይን ዎልስን አስ ኡባስ ሎኦ ባዝ ኦቾደስ ምንጎተ። ");
INSERT INTO oyde_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","ኡባ ዎደ ኡፋይቶተ። ");
INSERT INTO oyde_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","ኡባ ዎደ ጾዝ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","ኡባ ባዛ ጋላቶተ። ክርስቶስ የሱሳ ባጋራ ጾዚ ይንታፓ ኮይዛና ይኖ። ");
INSERT INTO oyde_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","ጌሽ አያና ታማ ꬋብስፐተ። ");
INSERT INTO oyde_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","ትንቢተ ቃላ ለቅፐተ። ");
INSERT INTO oyde_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","ኡባ ባዝ ፋታኖተ፤ ሎኦ ባዝ ኤኮተ። ");
INSERT INTO oyde_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","ኢታ ባዝ ኡባፓ Ꮉኮተ። ");
INSERT INTO oyde_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","ሳሮ እንግዘ ጾዘ ፋ ኦምተ ይንታና ጌሾ። ኑ ላꬄ የሱስ ክርስቶሳ ዮኦደ ቃማስ፥ ጾዚ ይን አያና፥ ይን ሸምፕቶን ይን ኩሙꬅ ጋልቶ ቦረ ባይꬅ ናጎ። ");
INSERT INTO oyde_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","ይንታና ጼግዘ አማንንትዳያ ማቅደ ግሾ ይኖ ኤ ፎሎዳ። ");
INSERT INTO oyde_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","ኑ እሹንꬆ፥ ኑስ ጾዝ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","አማንዘ አሱንꬃና ኡባ ጌሽ ዬርንተራ ሳርꬆተ። ");
INSERT INTO oyde_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","ይን Ꮉና ኪቶ አማንዘ አስ ኡቡንꬅስ ናባቦደ ፋና ላꬄ ሱንꬅተ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","ኑ ላꬄ የሱስ ክርስቶሳ አꬎ ኬሃትꬅ ይንታራ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","ጳዉሎሳ፥ ስላሰን ጢሞትዮሳ ተሰሎንቄ ዎሳ ኬꬃ የዘ፥ ጾዘ አዳይ ባዝን ላꬄ የሱስ ክርስቶሳ ባዝ ማቅደ አሱንꬅስ ጻፍደ ኪታ። ");
INSERT INTO oyde_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","ጾዘ ኑ አዳይፓን ላꬄ የሱስ ክርስቶሳፓ አꬎ ኬሃትꬅን ሳሮትꬅ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","ኑ እሹንꬆ፥ ይን አማኖራ ይን ፈታይ ፈታያን መሉንꬃና ሲቅዘ ሲቅታ ጋማ ድጭዘ ግሾ ኑኒ ይንስ ጾዛ ኡባ ዎደ ጋላቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","ይንታና የልደ ባይእተን ማꬋ ኡባነ ገንጨራን አማኖራ ሚንግ ኤቅደ ግሾ ኑኒ ኑ ኦምተ ጾዘ ዎሳ ኬꬃ ይን ባዝ ማርክꬍተራ ይንታላ ጬቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","ይን ኤ ግሾ ጋእ ማꬋ ኤክዘ ጾዘ ካእቱሞስ ቤዝዙንꬃና ማቂ ፋይድንቶደ ፋና ጾዘ ጽሎ ፍርዳስ Ꮉና ማላ። ");
INSERT INTO oyde_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","ጾዚ ቱሪ ፍርዳ ፍርዶዳ። ጾዚ ይንታና ዋይꬄዙንꬃላ አፋ ዋየ ኮኦዳ። ");
INSERT INTO oyde_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","ላꬄ የሱሳ ፋ ዎልቃማ ኪታንቹንꬃራ፥ ሳሎፓ የእዘ ዎደ ዋይንትዘ ይንታናን ኑና ሸምፕሳዳ። ");
INSERT INTO oyde_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","ማህ ጾዚ ፋና ኤሮሱንꬃናን ኑ ላꬄ የሱስ ክርስቶሳ ዎንገለስ ኪትንቶሱንꬃና ታማ ሎጸራ ፍርዶዳ። ");
INSERT INTO oyde_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","ኡን ላꬄ ቲኖፓን ኤ ቦንቾ ዎልቃፓ ሻክንት መዽና ꬋበ ፍርድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","ይና ቃምተ፥ ይን ኑ ማርካትꬅቶ ኤኪ አማንዙንꬅ ኤ ቦንችንቶደስን ሳብንቶደስ የእዘ ዎደ ኑ ይንትስ ኦህደ ኪቶ ይን አማንደ ግሾ ይን ኤዛ ቦንችዙንꬅ ግዳን ሳብዙንꬅ ግዳ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","ኑኒ ይንትስ ኡባ ዎደ ጾዝ ዎስዛና ይንስ። ኑ ጾዘ ይንታና ጼግደ ደኦስ ቤዝዙንꬃና ማቂ ፋይድንቶደ ፋና ኑኒ ዎሳነ። ይን ሎኦ ባዝ ኦቾደስ አሙꬍዘ አምቶን ይን አማኖ ኦችቶ ኤ ፋ ዎልቃራ ፎሎ። ");
INSERT INTO oyde_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","ይነ ኑ ጾዛን ኑ ላꬄ የሱስ ክርስቶሳ አꬎ ኬሃትꬅተ፥ ላꬄ የሱሳ ሱንꬅቶ ይን ቦንቾዳ፤ ይንታናን ኤ ቦንቾዳ። ");
INSERT INTO oyde_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","ኑ እሹንꬆ፥ ኑ ላꬄ የሱስ ክርስቶሳ ላምእንꬃ የእትባዝ ኑ ኤራ የልንቶደ ባዝስን ሺቆደ ባዝስ ኑ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","ትንቢተራ ዎይ መለ አሳፓ ስእደ ቃላራ ዎይ ኑፓ ኤክደ ኪታ ፋና ማህ፥ «ላꬂ ማቂ ይእዳ» ጋእ ይን ዎዝንታ ይርግፐን ሶእፐ። ");
INSERT INTO oyde_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","ይንታና ኦደን አኮ ኦገራን ባልꬅፈ። ቲኒ ባልꬅዘ ቆንጭካይዝን ገነ አꬄ ኤዝን ꬋበ ናአይ ይእካይዝን፥ ላꬄ ላምእንꬃ የኤ ቃማ የሎስ። ");
INSERT INTO oyde_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","አስ ጎይንዘ ባዝን ጾዝ ማህዘባዝ ኡባ እጺ ፋና ꬎቅ ዪሳዳ። መለ አቶ የዝን፥ ጾዘ ኬꬃ ገሊ በቲ፥ «ታኒ ጾዝ» ያጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","ታኒ ይንታራ የዝተራ ይንትስ ኦህዳኖ ቆፖስ የሳነ? ");
INSERT INTO oyde_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","የ ገነ አꬄ ኤ ፋ ቃማ ዮኦዳ ፋትን Ꮉተ የአመ ፋና አኮ ኤዛ ተቅዛኮ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","አሱንꬅስ ቆንጭካይዘ ገነትꬅ ሳዛ ቆፋ Ꮉተን ኦቻነ፥ የዝን Ꮉተ ኤዛ ተቂዘ የነ። ኤዛ ተቅዘ ኦገፓ Ꮉልእደ ዎደ ኤ ቆንጮዳ። ");
INSERT INTO oyde_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","ይንፓ ሱባ፥ ገነ አꬄ ቆንጮዳ፥ የዝን ላꬄ የሱሳ ፋ ዶንትፓ ከዝዘ ካሶራ ፋ ቦንቾ የእተ ኤዛ ዎꬎዳ። ");
INSERT INTO oyde_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","ገነ አꬄ ጻላሄ ዎልቃራ ይእ ዎርዶ ክለ ባዝን ጋማ ቆፍዘ ማላ ባዝ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","ይኒ ፋናን፥ ꬋበስ የዘ አሱንꬃና ዱማ ዱማ ጭምዘ ኢታ ኦቻራ ባልꬆዳ። ኡን ꬋብዳና አሽዘ ቱርዛ ካꬊ ኤካንጽደ ግሾስ። ");
INSERT INTO oyde_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","ይኒ ግሾ፥ ኡን ዎርዶ ማቅዘ ባዝ አማኖደ ፋና ጾዚ ዎልቃማ ባል ኡንታላ ዳኮዳ። ");
INSERT INTO oyde_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","ይናን፥ ቱሮ አማኖሰ አሱንꬅ፥ ናጋራ ኦቻ ኡፋይትዙንꬅ ኡባ ፍርድንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","ላꬃ ካዽዘ ኑ እሹንꬆ፥ ኑኒ ጾዛ ይን ግሾ ኡባ ዎደ ጋላቶደስ ቤዛነ። ይን አቶደ ፋና ጾዚ ጌሽ አያና ዎልቃራ ይንታና ጌሽዳነን ይንትን ቱሮ አማንዳነ ኤ ይንታና አንግስ ፋና ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","ጾዚ፥ ኑ ይንትስ ኦህዘ ዎንገለ ባጋራ ይንታና ጼግደ፥ ይን ኑ ላꬄ የሱስ ክርስቶሳራ ዎላ ቦንችቶ ሻክንቶደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","ይኬ፥ ኑ እሹንꬆ፥ ሚንግ ኤቆተ። ኑኒ ይንታና ኑ ዶናራ ማቅን ዎይ ዳብዳበራ ማቅን ታማርስደ ትምርትቶ አይኮተ። ");
INSERT INTO oyde_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","ኑ ላꬄ የሱስ ክርስቶሳን ኑና ካꬍደ ፋ አꬎ ኬሃትꬅተ መዽና ምንꬅራ ሎኦ ኡፋይስ እንግደ ጾዘ ኑ አዳይ ኑ ዎዝንቶ ምንꬅꬆ፤ ሎኦ ኦቻራን ቃላራ ኡባ ምንꬅꬆ። ");
INSERT INTO oyde_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","ዉርሱꬅተ ኑ እሹንꬆ፥ ላꬄ ቃላ ይን ግዳ ኤልስ ዳልጎደ ፋናን ቦንችንቶደ ፋና ኑስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","ይኒ ፋናን፥ ቃላ ስእደ ኡባ አማኖሰ ግሾ ጾዚ ገኑንꬃፓን ኢታ አሱንꬃፓ ኑና አሾደ ፋና ኑስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","የዝን ላꬂ አማንንትዳያ፤ ኤ ይንታና ምንꬅꬆዳን ጻላሄፓ ናጎዳ። ");
INSERT INTO oyde_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","ኑኒ ይንታና ኪትዛኖ Ꮉተን ቲኖፓን ይን ኦቾደ ፋና ላꬃላ ኑኒ አማንንታነ። ");
INSERT INTO oyde_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","ላꬂ ይን ዎዝንቶ ጾዘ ሲቆጎን ክርስቶሳ ዳንዳአጎ ካልꬆ። ");
INSERT INTO oyde_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","ኑ እሹንꬆ፥ ይን ኑፓ ኤክደ ኪቶ ካሎሱንꬃፓን ኦቻ አሺ አዛልአ አማንዘ አሱንꬃፓ ይን ሻክንቶደ ፋና ላꬄ የሱስ ክርስቶሳ ቲኖ ይንታና ኪታነ። ");
INSERT INTO oyde_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","ኑ ፋና Ꮉኒ የሳደስ ቤዝዛኖ ይን፥ ይን ኦምተ ኤራነ። ኑኒ ይንታራ የዘ ዎደ ኦቻ አሽካያ። ");
INSERT INTO oyde_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","ኑኒ ኦደፓን ካꬃ Ꮉሪ ሙእካያ። ኑስ ዳንዳእንትደ ፋና ቃማን አዋራ ኦቺ ላቢ የዝዳ ፋትን ኦደስን ቶፎ ማቅካያ። ");
INSERT INTO oyde_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","ኑኒ ይኖ ኦችዳና፥ ይንትስ አዝዘ ማቃደስ ፋትን ይንታፓ ማደ ኦጮደስ ኑስ አደትꬅ ዎልቃ ꬋብን ባያ። ");
INSERT INTO oyde_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","ኑ ይንታራ የዘ ዎደን፥ «ኦቾደስ ኮዮሰ አስ ኦደን ሙእፐ» ያጋእ ኪትዳ። ");
INSERT INTO oyde_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","ኑኒ ይኖ ጋይደ፥ ይን ግዳ ፈቲ ፈቲ አዛልኡንꬅ የዛኖ ስእደ ግሾስ። የንꬅ አሱንꬅ ገልꬆሰ ባዛ ገሊ መሉንꬃና ኦቻ ብልዛነ ፋትን አኮን ኦቾስ። ");
INSERT INTO oyde_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","ኑኒ የንስ ፋና አሱንꬅ ዎጋ የስ የሳደ ፋናን ኮሽዘ ባዝ ኦቺ ደንጎደ ፋና ላꬄ የሱስ ክርስቶሳ ቲኖ ኡንታና ኪታነን ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","የዝን ኑ እሹንꬆ፥ ሎኦ ኦቻ ኦቾደስ አዛልእፐተ። ");
INSERT INTO oyde_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ꮉተ ኑኒ Ꮉይ ጻፍንትደ ዳብዳብዘስ ኪትንቶሰ አስ ኦደን የዝኮ የ አꬃ ኤሮተ። ኤ ዬልꬋደ ፋና ኤፓ ሻክንቶተ። ");
INSERT INTO oyde_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","የዝን ኤዛ እሸ ፋና ሴሮተ ፋትን ሞርከ ፋና ብእፐተ። ");
INSERT INTO oyde_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","ሳሮ እንግዘ ላꬄ፥ ፋ ኦምተ ይንትስ ኡባ ዎደን ኡባ ባጋራ ሳሮ እንጎ። ላꬄ ይን ኡቡንꬃራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","ታኒ ጳዉሎሳ፥ Ꮉይ ሳርꬅዛ ታ ኩሸራ ጻፍዳ። ታ ኪታ ኡባንስ ማልታ Ꮉኖ፤ ታ ጻፍዛናን Ꮉኒ ፋና። ");
INSERT INTO oyde_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","ኑ ላꬄ የሱስ ክርስቶሳ አꬎ ኬሃትꬅ ይን ኡቡንꬃራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","ኑና አሽዘ ጾዘ ኑ ኡፋይት ናግዘ ክርስቶሳ የሱስ ኪታ፥ የሱስ ክርስቶሳ ሐዋረ ማቅደ፥ ጳዉሎሳፓ፥ ");
INSERT INTO oyde_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","አማኖራ ታስ ቱሪ ናአ ማቅደ ጢሞትዮሳስ። ጾዘፓ ኑ አዳይፓን፥ ኑ ላꬄ የሱስ ክርስቶሳፓ አꬎ ኬሃትꬅ፥ ማሮትꬅን ሳሮትꬅ ኔስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","ታኒ መቀዶንያ Ꮉንግተራ ነና Ꮉዳርዳን ፋና፥ ፈቲ ፈቲ አሱንꬅ ዎርዶ ትምርተ ታማርስዛኖ ካዮደስ ነ ኤፈሶነ ጋምኦደ ጋር ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","ኡን ማደ ባይዘ ቶሴ ኦሄን ፋ ኮች ፋይደ አሾደ ፋና ኦሆ። ይኒ ፋና የዘ ባዝ ላለ መꬋነ ፋትን አማኖራ ኦችንትዘ ጾዘ ኦቻ ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Ꮉይ ኪትዘስ ኣፈ ቆፍታ ጌሽ ዎዝናፓን፥ ሎኦ ቆፋፓ ቱሪ አማኖፓ በንትዘ ሲቆ። ");
INSERT INTO oyde_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","ፈቲ ፈቲ አሱንꬅ Ꮉኖ አሺ፥ ፋꬆሰ ላለጎ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","ኡን ጾዘ ህገ አስታማረ ማቆደስ ኮያነ። የዝን ኡን አኮ ኦህዛኮ ዎይ ቱርታ አኮ የዛኮን ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","አስ ቤዝዘ ፋና ህግተ ማድንትኮ ህገ ሎኦ ማቅዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","ፈቲ ባዝ ቆፖደስ ቤዛና ህገ ሎኦ አሱንꬅስ መꬍንትካያ። የዝን ህገ፥ ህገ መንꬅዙንꬃና፥ ጾዛ ጎይኖሱንꬅስ፥ ሸምፖ ዎꬍዙንꬃና፥ ናጋራንቹንꬃና፥ ጌሻትꬅ ባይዙንꬃና፥ ቱኑንꬃና፥ መለ አቶ የዝን ፋ እንቶ ዎይ አዳያ ዎꬍዙንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","ኦላለ Ꮉንትዙንꬃና፥ ꬊራꬅ ꬊራꬃራ ኦላለ Ꮉንትዙንꬃና፥ አስ ባይዝዙንꬃና፥ ዎርዶ ኦህዙንꬃና፥ ዎርዶራ ጫቂዙንꬃና፥ ዎይ ቱሪ ትምርተራ የልንቶሰ አኮ ኦቻን ኦችዙንꬅስ። ");
INSERT INTO oyde_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","ቱሪ ትምርተ በንትዘ ቦንቾን አንጅንትደ ጾዛ ታኒ አዋጆደ ጋር ታስ Ꮉዳራ እንግደ ዎንገለ ግዳ የነ። ");
INSERT INTO oyde_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","ታኒ ኦችዘ ኦችተ ታስ ዎልቃ እንግደ ኑ ላꬄ ክርስቶሳ የሱሳ ጋላታነ። ታና ፋ ኦችትስ ሹሚ ይና ኦችትስ ቤዛነ ጋእ ፋይድደ ግሾ ኤዛ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","ታኒ Ꮉንፓ ቲኖ ኤዛ ጫዥዛ፥ ኤዛ ካልዙንꬃና ባይእዛያን ዋይꬅዛ ማቅኮን ታኒ ይኖ ኤርካይዛራን አማንካይዛራ ኦችደ ግሾ ጾዚ ታና ማርዳ። ");
INSERT INTO oyde_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","ኑ ላꬄ ፋ አꬎ ኬሃትꬅቶ ታላ አፋ ጉሲ፥ ይና አꬎ ኬሃትꬅቶ አማኖራን ሲቆራ ክርስቶሳ የሱሳ ባጋራ ታስ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","«ክርስቶሳ የሱሳ ናጋራንቹንꬃና አሾደስ Ꮉና አላምተ ይእዳ» ጋዘ ቃልታ አማንንታነ አስ ኡባ ኤኮደስ ቤዛነ። ኡባፓ አꬍደ ናጋራንችዘ ታና። ");
INSERT INTO oyde_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","የዝን መዽና ደኦ ኤኮደስ ኤዛ አማንዘ አሱንꬅስ ታኒ አዝዘ ማቃደ ጋር የሱስ ክርስቶሳ ጋማ ዳንዳእዳ። ታኒ ኡባፓ አꬍደ ናጋራንችዘስ ጾዚ ፋ ማሮትꬅቶ ጋንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","ኣፈር በንቶሰስ፥ ፈቲ ጾዘስ፥ Ꮉይቆሰስ፥ መዽና ካትዘስ፥ መꬍናፓ መዽና የሎደስ ጋላታን ቦንቾን ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","ጢሞትዮሳ፥ ታ ናአዮ፥ ዛጋ ነባዝ ናቡንꬅ ኦህደ ቃልትላ አፋ ኤቅደ Ꮉና ኪታ Ꮉዳርቶ ኔስ እንጋነ። ነ ይና ቃልቶ ካልኮ ሎኦ ኦላ ኦልንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","አማኖን ሎኦ ቆፋ ኔስ የዞ። ፈቱንꬅ ፈቱንꬅ ፋ ዎዝንቶ ꬋብሲ ማርካበ እዥዘ ባይꬅ ꬋብዛን ፋና አማኖፓ ꬋብዳ። ");
INSERT INTO oyde_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","ይኖ Ꮉንዱንꬅ ግዳ ሄመነዮሳን እስክንድረ የነ። ኡን ታማሪ ጾዛ ጫዥዛኖ አሾደ ፋና ታኒ ጻላሄስ ኡንታና አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","ኡባፓ ቲኒ፥ ጾዝ ጎይኖራ ቦንቾ ኩምደ ደኦር ዎሶደስ፥ መሉንꬅስ ዎሶደስን ጋላቶደስ ቤዛኖ ታኒ ነና ቆፍዛነ። ");
INSERT INTO oyde_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","ኑ ቱሪ አያና ደኦ ጌሻትꬃራ ጾዛ ጎይንተራ ሳሮትꬃራ ዎፑ ጋእ የሳደ ጋር ካቱንꬅስን ሹሙንꬅ ኡቡንꬅስ ዎሶተ። ");
INSERT INTO oyde_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","ይኒ ጋር ዎስዘ ኑና አሽዘ ጾዘ ቲኖ ሎኦን ኡፋይስዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","ጾዚ አስ ኡባ አቶደ ፋናን ቱርቶ ኤሮደ ፋናን ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","ፈቲ ጾዚ የነ። ጾዛፓን አሳፓ ግዳ ማቂ ጭምꬍዘ ፈተ የነ፤ ኤዝን አስ ማቅደ ክርስቶስ የሱሳ። ");
INSERT INTO oyde_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","ኤዚ አስ ኡባ ዎዞደስ ፋና አꬂ እንግዳ። ጾዚ ፋ ዎድተ አሱንꬃና ኡባ ዎዞደስ ኮይዛኖ ቤዝዘ ማርካትꬅታ Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","ጾዚ ታና ዎንገለስ አስታማረን ሐዋረ ማህ ዶርዳና ይንስ። ታኒ ቱሮ ኦህነ፤ ዎርድꬎስ፤ አማኖን ቱሪ ቃላ አይሁደ ማቆሰ አሱንꬃና ታማርሶደ ፋና ጾዚ ታና ሹምዳ። ");
INSERT INTO oyde_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","ይኒ ግሾ፥ ኡባ በሳ የዘ ꬊራꬁንꬂ፥ ፋና ጾዝስ ዱሙዚ፥ ካችን ላለን አሺ፥ ፋ ኩሽቶ ኡደ ደንꬂ ጾዛ ዎሶደ ጋር ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","ይኒ ፋናን ማቹንꬅ ፋና አህዛኖ ቆንጭዘ፥ ቦንቾራን ዎጋራ የዘ አፉላ ማአደስ ቤዛነ። ኡን ዎጋ ባይዘ ኦማ ዳꬂን፥ ዎርቃራ ዎይ እንቆራ፥ ዎይ አልኦ አፉላራ መሉንꬃፓ ፋና ዱሙዝፐ። ");
INSERT INTO oyde_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","የዝን ጾዝስ ጎይናነ ጋዘ ማቹንꬅ ፋስ ቤዝዛን ፋና ሎኦ ባዝ ኦቾ። ");
INSERT INTO oyde_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","ማቻ ኪትንተራ ስእ ጋእ ታማሮ። ");
INSERT INTO oyde_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ታኒ ማቻ ታማርሶደ ፋና ዎይ ꬊራꬃላ አድꬎደ ፋና ባይዝን ስእ ጋእ የሳደ ፋና ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","አዳማ ቲኖ መꬍንትዳ፤ ሱባፓ ሄዋና መꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","ማህ ጭምንት ጾዘ ህገ መንꬅደ ማችቶ ፋትን አዳማ ባያ። ");
INSERT INTO oyde_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","የዝን ማቻ አማኖራ፥ ሲቆራን ጌሻትꬃራ ፋና ናጊ የዝኮ ናአ የለራ አቶዳ። ");
INSERT INTO oyde_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","ኦንን፥ «ዎሳ ኬꬂ ካልꬅዘ አስ ማቃደስ ኮይኮ ሎኦ ባዝ አሙꬋነ» ጋዘ ኦህታ ቱሮ። ");
INSERT INTO oyde_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","ዎሳ ኬꬂ ካልꬅዘ አስ ቦርንቶሳያ፥ ፈቲ ማቻ ጻላላ የዛያ፥ ዎጋራ የዛያ፥ ፋና ናግዛያ፥ ቤዛን ፋና ኦችዛያ፥ ዛቆ ሞክዛያ፥ ታማርሶደስ ዳንዳእዛያ፥ ");
INSERT INTO oyde_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","ማꬅንቶሳያ፥ ካጭንቶሳያ፥ ላሎሳያ፥ ብራ ይቅስንቶሳያ፥ ");
INSERT INTO oyde_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","ኤ ናኡንꬅ ኤስ ኪትንትዙንꬃናን ቦንችዙንꬃና፥ ፋ ኬꬅቶ አሆደስ ዳንዳእዛያ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","ፈቲ አስ ፋ ኬꬅቶ አሆደስ ዳንዳአንጽኮ፥ ጾዘ ዎሳ ኬꬅቶ ዋይዝ አሆደስ ዳንዳኤ? ");
INSERT INTO oyde_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","ኡቱራራ ኩሚ፥ ጻላሄ ጾዘ ፍርዳራ ጎልእደ ፋና ጎልአመ ፋና፥ አማኖር ሚንግካይዘ አስ ማቆደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","ቦረራን ጻላሄ ጽኬ ገላመ ጋር የ አꬄ አማኖሰ አስ ካለ ሎኦ ማርካትꬅ የሳደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","ይኒ ፋና ማህ ዎሳ ኬꬂ ዳቆናቱንꬅ ቦንችንትዱንꬃና፥ ላምእ ዶና ኦህንቶሱንꬃና፥ ጋማ ማꬅዘ ኡሽ ኡዦሱንꬃና፥ ብራ ይቅስንቶሱንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","አማኖ ሳዛ ቆፋ ጌሽ ዎዝናራ ናግዙንꬃና ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","ኡን ቲኖ ፋታንንቶደስ ቤዛነ፤ ኡንታላ አፋ ቦረ ባይዛ ማቅኮ፥ ዎሳ ኬꬃ ዳቆነ ማቂ ኦቾ። ");
INSERT INTO oyde_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","ይኒ ፋናን፥ ኡን ማቹንꬅ ቦንችንትዱንꬃና፥ ዝግሮሱንꬃና፥ ዎጋራ የዙንꬃና፥ ኡባ ባዛ አምንንትዱንꬃና ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","ዎሳ ኬꬃ ዳቆናቱንꬅ ፈቲ ማቻ ጻላላ የዙንꬃና ማቆ። ፋ ናኡንꬃናን ፋ ኬꬅቶ ሎይꬂ አህዙንꬃና ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","ዎሳ ኬꬃ ዳቆነ ማቂ፥ ሎኦ ኦቻ ኦችዙንꬅ፥ ኡንትስ ዳማ ቦንቾን ክርስቶሳ የሱሳ ግዳ የዘ አማኖ ባዝ ኦሆደስ ምንꬅትሞ ደንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","ታኒ Ꮉና ኪቶ ኔስ ጻፍተራ፥ ኤልሲ ኔጎ Ꮉንጎዳ ጋእ ኡፋይስ ጋዳነ። ");
INSERT INTO oyde_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","የዝን ታኒ Ꮉንጋንጽ ጋምእኮ፥ ጾዘ ኬꬃ አሱንꬅ ዋይዝ የሳደስ ቤዝዛኮ ኤሮደ ፋና Ꮉኖ ኔስ ጻፍዳ። ደኦ ጾዘ ኬꬅታ ቱረትꬅስ ቱስን ባሳን። ");
INSERT INTO oyde_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","ኑ አማንትስ ሳዛ ቆፍታ ሶኤ ባይꬅ ዳማ። ክርስቶሳ አሾር ቆንጭዳ፤ ኤ ቱረትꬅቶ ጌሽ አያና ማርክꬍዳ። ኪታንቹንꬅስ በንትዳ፤ ኤ ካእቱምታ ዎርዣ ኡባስ ሳባክንትዳ። አላመ የዘ አሱንꬅ አማንዳ፤ ቦንቾር ሳሎ ኤክንትዳ። ");
INSERT INTO oyde_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","ዉርሱꬅ ዎደ ባልꬅዘ አያናን ቱና አያና ትምርትቶ ካሊ፥ ፈቲ ፈቲ አሱንꬅ አማኖ ካዶዳኖ ጌሽ አያና ቆንጭዝ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","ይኒ ፋና ትምርተ ኡን ዎዙንታ ዶጭን፥ አሱንꬃና ባልꬅዘ ዎርዶ አስታማሩንꬃፓ የእነ። ");
INSERT INTO oyde_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","የንꬅ ፋና የዘ አሱንꬅ ኤከን ገለ ካያነ፤ ማህ ፈቲ ፈቲ ካꬃ ማአመ ፋና ጋእ ካያነ። የዝን አማንዙንꬅን ቱሮ ኤርዙንꬅ ጾዛ ጋላቲ ዎሲ ማአደ ፋና ጾዚ ካꬃ መꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","ጾዘ መꬍደ ኡባ ባዝ ሎኦ። ጾዝ ጋላት ኤክኮ አላ ዎꬍዘ አኮን ባያ። ");
INSERT INTO oyde_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","ኡባ ባዝ ጾዘ ቃላራን ዎሳራ ጌሽ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","ይኒ ግሾ፥ ነ Ꮉና ትምርትቶ አማንዙንꬃና ታማርስኮ፥ ክርስቶሳ የሱሳ ሎኦ አሮ ማቃዳ። ነ ካልዘ ሎኦ ትምርትተ ቃላ ታማርኮ ድጮዳ። ");
INSERT INTO oyde_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","የዝን ማደን ቱሪ ባይዘ ኦሄፓን ጭማ ማቹንꬅ ቶሰፓ Ꮉኮ። ጾዛ አዞደስ ነና ዱስዞ። ");
INSERT INTO oyde_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","አስ ፋ ጋልቶ ምንꬆደስ ኦችዘ ኦቻ ኤራꬅ ዎደ ማዳነ። የዝን ጾዝ አዘ ዱስዛና Ꮉተን መዽና ደኦ እንግዘ ኡፋይስ የዘ ግሾ ኡባ ባዝስ ማዳነ። ");
INSERT INTO oyde_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Ꮉይ ቃልዘ አስ ኡባ ኤኮደስ ቤዝዘ ቱሪ ቃላ። ");
INSERT INTO oyde_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","ኑኒ አስ ኡባ፥ ኡባፓ አꬂ አማንዙንꬃና አሽዘ ደኦ ጾዛ ኡፋይሳራ ናግዘ ግሾ፥ ይንስ ኑኒ ኦቻራ ላባነን ቡቱንታነ። ");
INSERT INTO oyde_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Ꮉና ኪትቶ ታማርሶ። ");
INSERT INTO oyde_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","ነ ይꬎ ማቅደ ግሾ ነና ኦንን ቦርፐ። የዝን አማንዙንꬅስ ኔኒ ኦሄራ፥ ኦቻራ፥ ሲቆራ፥ አማኖራን ጌሻትꬃራን አዝዘ ማቆ። ");
INSERT INTO oyde_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","ታኒ ዮኦደ ዎንꬅስ አሱንꬅስ ጌሽ ማጻፍቶ ናባበራ፥ ሳባኬራን ታማርሰራ ምንጎ። ");
INSERT INTO oyde_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","ትንቢተ ኔስ ኦህንትን፥ ጭሙንꬅ ፋ ኩሽቶ ኔላ አፋ ጋድደ ዎደ ነ ኤክደ፥ ነ ግዳ የዘ ጌሽ አያና እሞትꬅ ቦርፐ። ");
INSERT INTO oyde_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","ነ ድችታ አሱንꬅ ኡቡንꬅስ ቆንጮደ ፋና ይኖ ምንꬂ ቆፖ፤ Ꮉኖ ኡባ ዎደ ኦቾ። ");
INSERT INTO oyde_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","ነ ኦምትስን ነ ትምርትስ ናግንቶ። ነ ይኖ ኡባ ዎደ ኦችኮ ነናን ነና ስእዙንꬃና አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","ጭማ ነ አዳይ ፋና ቦንቾፕ አትን ካጭፐ። ይꬉንꬃና ነ እሸ ፋና ማህ ቦኦ። ");
INSERT INTO oyde_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","ማች ጭሙንꬃና ነ እንቲ ፋና፥ ዉዱሩንꬃና ነ ምሹንꬅ ፋና፥ ፎሎ ጌሻትꬃራ አይኮ። ");
INSERT INTO oyde_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","አዝኒ Ꮉይቂደ ቱሪ ቡዳኑንꬃና ማዲ ቦንቾ። ");
INSERT INTO oyde_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","የዝን ቡዳንትስ ናኡንꬅ ዎይ ናኡንꬅ ናአ የዝኮ፥ የንꬅ ናኡንꬅ ቱሪ አያና የስ የዛኖ ቤሳደ ፋና የልዱንꬃናን፥ ፋ አፍቶን ማይዛያን ማዲ ኩሸ ማሄ ታማሮ። ይና ጾዝ ኡፋይስዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ፋ ፋስ የዘ ቱሪ ቡዳንታ ጾዘፓ ማደ ደንጎደስ ኡፋይሳራ ናጋነ። አዋራን ቃማ ጾዚ ፋና ማዶደ ፋና ዎሳራ ምንጋነ። ");
INSERT INTO oyde_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","የዝን Ꮉና አላምተ ሎኦ የስ ጻላላ ኮይዘ ቡዳንታ ፋጻ የዛራ Ꮉይቂዳኖ። ");
INSERT INTO oyde_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","ኦንን ኡንታና ቦራመ ፋና Ꮉና ትምርትቶ ኡንትስ እንጎ። ");
INSERT INTO oyde_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","የዝን ፋ እግኑንꬅስ፥ ኡባፓ አꬂ ፋ ካራ አሱንꬅስ ቆፖሰ ኦንን ፋ አማንቶ ካድዳያ፤ አማኖሰ አሳፓን ወዝ ኢታ። ");
INSERT INTO oyde_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","በረ እዝፑንታም ኩምካይዘ ቡዳንትስ ሱንꬅቶ ማዝጋበ ጻፍፐ። ማህ ይንላ አፋ እዛ ፋ አዝንዘስ አማንንትዳኖ ማቆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ናኡንꬃና ድቼራ፥ ዛቆ ሞከራ፥ ጌሹንꬅስ ቶሄ ሜጨራ፥ ማꬍꬍደ አስ ማደራ፥ ሎኦ ኦቻ ኡባስ ፋና አꬂ እንግዳኖን ሎኦ ኦቻራ ኤርንትዳኖ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","የዝን ናአትꬅ ማቅደ አዝኒ ባይዙንꬅ ሱንꬅቶ ማዝጋበ ጻፍፐ። ኡንታና አዝኒ ገለ ገሎ ጋዘ አሾ አሞ አይክዘ ዎደ ክርስቶሳ አሾዳ። ");
INSERT INTO oyde_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","ኡን ቲኖ ገልደ ቃልቶ መንꬅደ ግሾ ፍርድንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","ይንላ አፋ ኡን ኦቻ ꬋብን ኬꬃፓ ኬꬂ ዉቶዳ። ዉተ ጻላላ ባይዝን ዝግርስን ፋና ገልꬆሰ ባዛ ገሊ ቤዞሰ ባዝ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","ይኒ ግሾ፥ ኑ ሞርኩንꬅ ኑላ አፋ ኦህንትዘ ኢታ ባዝ ደንጋመ ፋና ናአትꬅ ማቅደ አዝኒ ባይዙንꬅ አዝኒ ገሊ፥ ናአ የሊ፥ ፋ ኬꬅቶ አሆደ ፋና ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Ꮉንፓ ዛጋ ኤርꬅ አዝኒ ባይዙንꬅ ጻላሄ ካሎደስ ሱብ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","ፈቲ አማንዘ ማችታ ካራ አሱንꬅ ግዳ አዝኒ ባይዛና የዝኮ እዛ ኡንታና ማዶደስ ቤዛነ። ይኒ ጋር ኦችኮ፥ ዎሳ ኬꬅስ ቶፎ ፎላነ። የ ዎደ ዎሳ ኬꬅታ ማደ ቤዝዘ ቱሪ አዝኒ ባይዙንꬃና ማዶደስ ዳንዳእነ። ");
INSERT INTO oyde_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","ዎሳ ኬꬂ ሎይꬂ የንግዘ ጭሙንꬅ፥ ኡባፓ አꬂ፥ ቃላ ሳባኬራ ታማርሰራ ላቢዙንꬅ ዳኮ ቦንቾ ኤኮደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","ጌሽ ማጻፈ፥ «ቆይዳ ባሃ የꬍዘ ቦራ ዶና አጭፈ» ይኒ ፋና፥ «ኦችዘ ፋ ዳሞዘ ኤኮደስ ቤዛነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","ላምእ ዎይ Ꮉይꬕ ማርካ ባይዝን፥ ዎሳ ኬꬂ ጭማ ሞትዘባዝ ስእፐ። ");
INSERT INTO oyde_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","መሉንꬅ ዣሽቶደ ፋና ናጋራ ኦችዘ ኦናን አስ ኡባ ቲኖ ሴሮ። ");
INSERT INTO oyde_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","ኔኒ አስ ስኖ ብእካይዛራ፥ ፈታያ ፈታይፓ ዱሙዝካይዛራ Ꮉና ኪቶ ናጎደ ፋና ጾዘ፥ ላꬄ የሱሳ ክርስቶሳን ዶርንትደ ኪታንቹንꬅ ቲኖ ታ ነና ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","ኦደላን አፋ ነ ኩሽቶ ጋዲ ሹሞደስ ኤልስፐ። መሉንꬅ ናጋራ ገልፐ፤ ነና ጌሻትꬃራ ናጎ። ");
INSERT INTO oyde_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","ኔኒ ኡባ ዎደ Ꮉርግንትዘ ግሾን ነ ሳዛ Ꮉርግት ግሾ Ꮉꬅ ጻላላ ኡዥፐ፤ ኤራꬅ ዎይነ ኡዦ። ");
INSERT INTO oyde_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","ፈቲ ፈቲ አሱንꬅ ናጋርታ ቆንጨ፤ ባጉንꬅ ናጋርታ ኡንታና ፍርዶደስ ኡንታፓ ቲኒ ኤርንታነ፥ የዝን መሉንꬅ ናጋርታ ሱባፓ ጋምእ ቆንጫነ። ");
INSERT INTO oyde_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","ይኒ ጋር፥ ሎኦ ኦቻን ቆንጨ፤ ቆንጫንጽ እጽኮን ገንጎደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","ጾዘ ሱንꬅታን ኑ ትምርትታ ጫዥንታመ ፋና አሮትꬃ የዙንꬅ ፋና አህዘ ላꬁንꬃና ቦንቾ። ");
INSERT INTO oyde_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","አማንዘ ላꬁንꬅ የዘ አሩንꬂ፥ ኡን ላꬁንꬅ ኡንትስ እሸ ማቅዘ ግሾ ኡንታና ቦርፐ። ኡን ኦችተ ማድንትዘ ላꬁንꬅ፥ አማንዙንꬃናን ካꬍንትዱንꬃና ማቅደ ግሾ ኡን ቲኖስትፓ አꬂ ኦቾደስ ቤዛነ። ኔኒ Ꮉኖ ታማርሶደስን ኡን ኦቾደ ጋር ዞሮደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","ኦንን ዱማ ትምርተ ታማርስኮ፥ ኑ ላꬄ የሱስ ክርስቶሳ ቱሪ ቃላራን ኑ አማኖ ትምርተራ ጊጎስ። ");
INSERT INTO oyde_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","የ አꬄ ኡቱራራ ኡርቂንታነ ፋትን አኮን ኤሮስ። ኡንትስ ፈቲ ቆፋላ አፋ ላሎደስን ካጭንቶደስ ኢታ አሞትꬅ የነ። ይናን ቅናተ፥ ካች፥ ጫሽ፥ ኢታ ሶኤ፥ ");
INSERT INTO oyde_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","የንስ ጊጎሰ ላለ ካልꬃነ። ማህ ኡንትስ ኢታ ዎዝና የነ፤ ቱርን ꬋብዳ፤ ኡን ጾዝ አማንዛና ዱረትꬅስ ኦገ ጋእ ቆፓነ። ");
INSERT INTO oyde_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","የዝን ታስ የዛና ማቃዳ ጋዘ አስስ ጾዝ ጎይንዛና ዳማ ትርፈ። ");
INSERT INTO oyde_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","ኑኒ Ꮉና አላምተ አኮን ክእካያ፤ ማህ ኢፓ አኮን ኤኪ ቅቶስ። ");
INSERT INTO oyde_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","ኑስ ካꬃን ማኦ የዝኮ ይና ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","የዝን ዱርቱሞ ኮይዙንꬅ ፋታና ግዳን ጽኬን ገላነ። ማህ ኡንታና ሱለ ዳፍዘን ꬋብስዘ ኤያትꬃን ቆህዘ አሞትꬃ ጎልአነ። ");
INSERT INTO oyde_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","ሚሸ ሲቆ ኢታትꬅ ኡባስ ጻጶ። ፈታይ ፈታያ ሚሸ አሙꬍተራ አማኖፓ ባልንቲ ጋማ አዛኖን ማꬋ ግዳ ፋና ኦልዳ። ");
INSERT INTO oyde_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","የዝን ናተ፥ ጾዘ አꬃዮ፥ ይንፓ Ꮉኮ። ጽሎትꬅ፥ ጾዝ አዘ፥ አማኖ፥ ሲቆ፥ ዳንዳአን ዳልጋትꬅ ካሎ። ");
INSERT INTO oyde_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","አማኖ ኦላ ሎይꬂ ኦልንቶ። ጋማ አሱንꬅ ቲኖ ኔስ ማርክꬍደ ነ አማንትባዝ፥ ጾዘ ነና ይንስ ጼግደ መዽና ደኦ አይኮ። ");
INSERT INTO oyde_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","ኡባ ባዝስ ደኦ እንግዘ ጾዘ ቲኖን፥ ጰንጠ ጵላጦሳ ቲኖ ሎኦ ማርካ ማርክꬍደ ክርስቶሳ የሱሳ ቲኖ ታ ነና ኪታነ። ");
INSERT INTO oyde_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ኑ ላꬄ የሱስ ክርስቶሳ ቆንጮደ ዎንꬅስ Ꮉኖ ኪቶ ባልንትካይዛራ ቦረ ባይዝን ናጎ። ");
INSERT INTO oyde_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","ፋ ጻላላ ኡባ አህዘ ቦንቾ ጾዘ፥ ካቱንꬅ ካታይ፥ ላꬁንꬅ ላꬄ፥ ፋ ቆፕደ ቃምተ የሱስ ክርስቶሳ ማህ ኪቶዳ። ");
INSERT INTO oyde_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","ፈተ ኤ ጻላላ Ꮉይቆስ። ኦደን ሺቆደስ ዳንዳኦሰ ፎኦ የነ። ኦደን ኤዛ ብእካያ፤ ማህ ቦኦደስን ዳንዳኦስ። ቦንቾን መዽና ዎልቃ ኤስ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Ꮉና አላመ ዱሩንꬅ ጨር ꬋብዘ ቆሎራ ኡቱራመ፥ ጬቃመን ኡፋይስ ጋዳመ ፋና ኦሆ። ኑስ ኮሽዘ ባዝ ጋንꬅ እንግዘ ኑና አንጅዘ፥ ዱረ ጾዘ ግዳ አማንንቶደ ፋና ኡንታና ኪቶ። ");
INSERT INTO oyde_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","ኑኒ ሎኦ ኦቻ ኦቾደ ፋና ሎኦ ኦቻራ ዱርꬎደ ፋና፥ ዳልጋን መሉንꬅስ ግሽዙንꬃና ማቃደ ፋና ኪቶ። ");
INSERT INTO oyde_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","ይና ኡንትስ ቲኖስ ምንꬂ ባሳ ማቃደ ግሾ የ ዎደ ኡን ቱሪ ደኦ አኮ አዝዛኮ ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","ጢሞትዮሳ፥ ነኒ ፈቲ ፈቲ አሱንꬅ፥ «ኤራትꬅ» ባይዘ ቦዛ ላለፓን ማዶሰ ኦሄፓ Ꮉኮ፤ ኔስ እንግንትደ Ꮉዳርቶ ናጎ። ");
INSERT INTO oyde_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","ፈተ ፈተ ኑስ ኤራትꬅ የነ ያጋእተራ አማኖ አሽዳ። ጾዘ አꬎ ኬሃትꬅ ይን ኡቡንꬃራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","ጾዘ ቆፋ፥ የሱስ ክርስቶሳራ የዘ ኡፋይስ እንግደ ባጋራ የሱሳ ክርስቶሳ ሐዋረ ማቅደ ጳዉሎሳፓ ኪትንትደ፥ ");
INSERT INTO oyde_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ታ ካዽዘ ናአይ ጢሞትዮሳስ። ጾዘ አዳይፓን ኑ ላꬂ ክርስቶሳ የሱሳፓ አꬎ ኬሃትꬅ፥ ማሮትꬅን ሳሮትꬅ ኔስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ታኒ፥ ታ ዎስተ ቃማን አዋራ ነና ቆፓነ። ታኒ ዎስዘ ዎደ ታ አዱንꬅ ጾዛን ታኒ ሎኦ ዎዝናራ ማድዘ ጾዛ ነ ግሾ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","ታኒ ነ አፉꬅቶ ቆፓነ፤ ነና ብእ ኡፋይቶደስ ጋማ አሙꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","ማህ ኔስ የዘ ቱሪ አማኖ ኤራነ። ይኒ ፋና አማንታ ዛጋ ነ ኣፍቲ ሎይድራን ነ እንት ኤዉንቀራ የዘ አማንት ፋና። ");
INSERT INTO oyde_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","ይኒ ግሾ፥ ታኒ ታ ኩሽቶ ኔላ አፋ ጋድደ ዎደ ጾዚ ኔስ እንግደ እሞ ኔኒ ማህ ኤꬆደ ዎይ ደንꬅꬆደ ፋና ቆፍዛነ። ");
INSERT INTO oyde_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","አኮስ ጋይኮ፥ ጾዚ ኑስ ዎልቃ፥ ሲቆን ኑ ኦምቶ አህዘ አያና እንጋነ ፋትን ዣሽትዘ አያና እንግካያ። ");
INSERT INTO oyde_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","ይኬ፥ ኑ ላꬄስ ማርክꬋደስ ዬልꬍፐ፤ ማህ ኤ ግሾ አጭንትደ ታ ግዳን ዣሽትፐ። የዝን ጾዚ ኔስ እንግዘ ዎልቂተ ዎንገለ ግሾ ታራ ማꬋ ኤኮ። ");
INSERT INTO oyde_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","ጾዘ ፋ ቆፍቶን ፋ አꬎ ኬሃትꬃራ ኑና አሺ፥ ፋ ጌሽ ዎርዣ ማሆደስ ኑና ዶርዳ ፋትን ኑኒ ኦችደ ኦቻ ግሾ ባያ። ይና አꬎ ከሃትꬅታ ክርስቶሳ የሱሳ ባጋራ አላመ መꬍንቶዳንፓ ቲኖ ኑስ እንግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Ꮉተ Ꮉይ አꬎ ኬሃትꬅዘ ኑና አሽዘ ክርስቶሳ የሱሳ የእተ ቆንጭዳ። ኤ Ꮉይቆ ዎልቃ ꬋብሲ፥ ዎንገለ ባጋራ ꬋቦሰ ደኦ ኑስ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","ታኒ ዎንገለ ሳባክዘ፥ ሐዋረን አስታማረ ማቆደ ጋር ጾዚ ታና ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","ታኒ ይኒ ግሾ Ꮉና ማꬍቶ ኤካነ፤ የዝን ታ አማንዘ ኦና የዛኮ ኤርዘ ግሾ ዬልꬎኦስ። ታስ እንግንትደ Ꮉዳርቶ ይና ክርስቶሳ የኤ ቃማ የሎደስ ኤ ናጎደስ ዳንዳእዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","ታኒ ነና ታማርስደ ቱሪ ቃላ አዝዘ ማህ አይኪ ክርስቶሳ የሱሳ ባጋራ የዘ አማንተን ሲቅተ የዞ። ");
INSERT INTO oyde_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","ኑ ግዳ የዘ ጌሽ አያና ዎልቃራ ኔስ እንግንትደ ሎኦ Ꮉዳርቶ ናጎ። ");
INSERT INTO oyde_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","እስያ አዉራጃ የዘ ኡቡንꬅ ታፓ Ꮉክዳኖ ኤራነ፤ ኡን ግዳ ፍገሉሳን ሄርሞገኔሳ የነ። ");
INSERT INTO oyde_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","አነስፎራ ታና ጋማ ዎደ ምንꬅꬅደ ግሾ ላꬂ ኤ ካራ አሱንꬅስ ይቅስንቶ። ታ አጭንትንን ኤ ዬልꬍካያ። ");
INSERT INTO oyde_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","ይንላ አፋ ኤ ሮመ ካታማ ይእደ ጋር ታና ምንꬂ ኮይ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","ዉርሱꬅ ቃምተ ላꬂ ይቅስንቶደ ፋና ታኒ ላꬃ ዎሳነ። ኤፈሶነ ካታማ ኤ ታና አኮ ጋር ማደዛኮ ነ ሎይꬂ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","ይኬ፥ ታ ናአዮ፥ ክርስቶሳ የሱሳ ግዳ የዘ አꬎ ኬሃትꬅተ ምንጎ። ");
INSERT INTO oyde_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","ጋማ ማርኩንꬅ ቲኖ ታኒ ነና ታማርስደ ትምርትቶ፥ መሉንꬃና ታማርሶደስ ዳንዳእዘ አማንንትደ አሱንꬅስ Ꮉዳራ እንጎ። ");
INSERT INTO oyde_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","የሱስ ክርስቶሳ ሎኦ ዎታዳረ ማቂ ታራ ማꬋ ኤኮ። ");
INSERT INTO oyde_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","ኦላ ዎታዳረ ፋ Ꮉላቅዛ ኡፋይሶደስ ጊግንታነ ፋትን መለ ኦቻላ ፋና ፌሾስ። ");
INSERT INTO oyde_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","ይኒ ጋራ፥ ጋልጋደ ዎጽዘ ኦንን ቤዝዘ ኦገራ ዎጻንጽኮ ዎይቶ ኤኮስ። ");
INSERT INTO oyde_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","ዎታራ ላቢዘ ጋደ አዳይ ፋ ላቢዳን ኣፍትፓ ሙእዘ ቲኖ አስ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","ላꬂ ኔስ ኡባ ባዛ አካኬ እንግዘ ግሾ ታ ኔስ ኦህዛኖ ነ ዎዝንተ ናጎ። ");
INSERT INTO oyde_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","ታኒ ማርክꬍዘ ዎንገለ ፋና Ꮉይቆፓ ደንድደ፥ ዳዉተ ኮች ማቅደ የሱስ ክርስቶሳ ቆፖ። ");
INSERT INTO oyde_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","ታኒ ዎንገለ ኦህዘ ግሾ ኢታ ባዝ ኦችደ አስ ፋና፥ አጭንቲ ማꬋ ኤክዳ። የዝን ጾዘ ቃላ አጭንቶስ። ");
INSERT INTO oyde_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","ይኒ ግሾ፥ ጾዘ ዶርደ አሱንꬅ ክርስቶስ የሱሳ ግዳ የዘ አቶትꬅ ባጋራ መዽና ቦንቾ ኤኮደ ፋና ኡን ግሾ ኡባ ባዛ ምንጋነ። ");
INSERT INTO oyde_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Ꮉንፋና ያጋዘ ቱሪ ቃላ የነ፤ «ኑ ኤራ Ꮉይቅኮ፥ ኤራ ዎላ የሳዳ። ");
INSERT INTO oyde_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","ኑ ገንጭኮ፥ ኤራ ዎላ ካእቶዳ። ኑ ኤዛ ካድኮ፥ ኤ ኑና ካዶዳ። ");
INSERT INTO oyde_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","ኑ አማንንታንጽኮን፥ ኤ አማንንትዳያ ማቂ የሳዳ። አኮስ ጋይኮ፥ ኤ ፋና ካዶደስ ዳንዳኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","ኔኒ ኡንታና Ꮉኖ ቲርዞ፤ ኡን ቃላ ግሾ ላላመ ፋና፥ ጾዘ ቲኖ ኡንታና ዞሮ። ይና ስእዙንꬃና ꬋብሳነ ፋትን አኮን ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","ኔኒ ቱሪ ቃላ ሉለራ ታማርስዛን ዬሊዞሰ ኦቻንቾ ማቂ፥ ጾዘ ቲኒ ኡፋይስዘ አስ ፋና፥ ነናትꬅቶ ኤስ ሺሾደስ ምንጎ። ");
INSERT INTO oyde_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","የዝን Ꮉና አላምትስ ጊግዘ ማዶሰ ኦሄፓ Ꮉኮ። ይኒ ፋና ኦህዘ አስ ጾዛፓ Ꮉክዛነ። ");
INSERT INTO oyde_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","ይኒ ፋና ትምርተ ጋላ ሙእ Ꮉስዘ ፋጾሰ ጭቶ Ꮉርገ ፋና። ይኒ ፋና ኦሄ ኦህንትዙንꬅ ግዳ ፋ ሄመነዮሳን ፍልጾሳ የነ። ");
INSERT INTO oyde_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Ꮉንꬅ አሱንꬅ ቱሪ ኦገ አሺ፥ «Ꮉይቂደ አሱንꬅ Ꮉይቆፓ ዛጋ ደንድዳ» ያጋእ ኤራꬅ አሱንꬅ አማንቶ ꬋብስዳ። ");
INSERT INTO oyde_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","ማቆ የዝን፥ ጾዚ ምንꬂ ባሳ ዪጺ ማታመ የዘ ኤንእንቶደስ ዳንዳኦስ። እዝላን አፋ፥ «ላꬂ ፋ አሱንꬃና ኤራነ። ላꬄ ሱንꬅቶ ጼግዘ ኦንን ኢታ ኦቻፓ Ꮉኮ» ያጋዘ ቃላ ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","ፈቲ ዳማ ኬꬃ ዎርቃፓ ዎይ ብራፓ ኦችንትደ ሚሸ ጻላላ ባይዝን ምንጻፓ ዎይ ሎቃፓ ኦችንትደ ሚሸ የነ። የንሳፓ ባጉንꬅ ቦንቾስ፥ ማህ ባጉንꬅ ቦርንትደ ኦቻስ ፌዣነ። ");
INSERT INTO oyde_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","ይኒ ግሾ፥ ኦንን ኢታ ኡባ አሺ ፋና ጌሽኮ፥ ቦንቾ ኦቻስ ማቅዘ ሚሸ ማቃዳ። ኡን ደእተ ጌሽን ላꬃ ኡፋይስዘ ኦቻ ኡባ ኦቾደስ ዳንዳእዙንꬃና ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","ናእቱሞ ኢታ አሞፓ Ꮉኮ። ጌሽ ዎዝናራ ላꬃ ጼግዘ አሱንꬃራ ዎላ፥ ጽሎትꬅ፥ አማኖ፥ ሲቆን ሳሮትꬅ ካሎ። ");
INSERT INTO oyde_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","የዝን ካች መꬍዛ ኤሪ ቦዛትꬅን ማደ ባይዘ ላለፓ Ꮉኮ። ");
INSERT INTO oyde_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","ላꬄ ኦቻንቾ አስ ኡባስ ኬሃ፥ ሎኦ ታማርስዛን ዳንዳአንቾ ማቃደስ ቤዛነ ፋትን ካጭንቶደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","ኤ ፋራ ኤቅንትዙንꬃና ኬሃትꬃራ ሴርዛ ማቃደስ ቤዛነ። ኡን ፋ ናጋርትፓ ማቂ ቱሮ ኤሮደ ፋና ጾዚ ኦቾድየዛኮ ኦደ ኤርዘ። ");
INSERT INTO oyde_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","ኡን ፋ ዎዝናጎ ማቂ ፋ ቆፋ ኦቾደ ፋና ኡንታና አይክደ ጻላሄ ጽኬፓ ኬሲ ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","ዉርሱꬅ ቃማ ኡንእꬅዘ ዎደ ዮኦዳኖ ኤሮ። ");
INSERT INTO oyde_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","አሱንꬅ ፋና ካꬍዙንꬃና፥ ሚሸ ሲቅዙንꬃና፥ ጬቅንትዙንꬃና፥ ኡቱርዙንꬃና፥ ጫዥዙንꬃና፥ ፋና የልዱንꬅስ ኪትንቶሱንꬃና፥ ጋላቶሱንꬃና፥ ጌሻትꬅ ባይዙንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","ሲቆ ባይዙንꬃና፥ ማሮትꬅ ኦቾሱንꬃና፥ ዝግርዙንꬃና፥ ፋና አሆሱንꬃና፥ ይቅስንትሞ ባይዙንꬃና፥ ሎኦ ካꬎኦሱንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","ሞርከስ አꬂ እንግዙንꬃና፥ ቆፋ ባይዙንꬃና፥ ኡቱራራ ኩምዱንꬃና፥ ጾዛፓ አꬂ አሾ ኡፋይሶደስ ካꬍዙንꬃና ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","ኡን አማንዘ አስ አዛነ ፋትን ጾዘ ዎልቃ ካድዳ፤ ነ የንꬅ ፋና የዘ አሱንꬃፓ Ꮉኮ። ");
INSERT INTO oyde_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","ኡንታፓ ፈተ ፈተ አስ ኬꬃ ገሊ ናጋራራ አይክንትዱንꬃና ዱማ ዱማ አሞራ አይክንትደ አማኖ ላፋ ማቹንꬃና አይካነ። ");
INSERT INTO oyde_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","የንꬅ ማቹንꬅ ኡባ ዎደ ታማራነ፥ የዝን ቱሮ ኤሮደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","ያነሳን ያምባሬሳ ሙሴራ ኤቅንትዳን ፋና Ꮉንꬅ አሱንꬅ ዎዝና ኦቾሱንꬃናን አማኖራ ጎልእደ አሱንꬃና ማቅደ ግሾ ቱርራ ኤቅንታነ። ");
INSERT INTO oyde_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","የዝን ያነሳን ያምባሬሳ ኤያትꬅታ ቆንጭዳን ጋር ኡን ኤያትꬅታ አስ ኡባ ቲኖ ቆንጮደ ግሾ ኡንትስ Ꮉኖስ። ");
INSERT INTO oyde_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","የዝን ነ ታ ትምርትቶ፥ ታ የስቶ፥ ታ ቆፍቶ፥ ታ አማንቶ፥ ታ ዳንዳእቶ፥ ታ ሲቅቶ፥ ታ ገንጭቶ፥ ");
INSERT INTO oyde_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","ታ ባይእንቶ ታ ዋይቶ ኤራነ። አንጾክያ፥ እቆንዮነ፥ ልስጥራ ካታማ ታና የልደ ባዝን ታ ዳንዳእደ ዋይቶ ኤራነ፤ ላꬂ ታና ይና ኡባንፓ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","ክርስቶስ የሱሳ ግዳ ጾዛ ኡፋይስዘ የስ የሳደስ ኮይዘ ኡቡንꬅ ባይእንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ኢታ አሱንꬅን ባልꬅዙንꬅ ፋስ ባልንትተራ መሉንꬃና ባልꬅተራ ቲኖስትፓ ኢቲ ኢቲ Ꮉንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","የዝን ነ ታማርዳነን ነ አማንደ ቱርተ ኤቆ። ነ ኦደፓ ታማረዛኮ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","ኔኒ ነ ናአትꬃፓ ዳንꬂ ክርስቶስ የሱሳ አማኒ አቶትꬅ በንትዘ ጭንጫትꬅ እንጎደስ ዳንዳእዘ ጌሽ ማጻፈ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","ጌሽ ማጻፈ ኡባ ጾዘ አያና ካልꬅን ጻፍንትደ ቃላ። የ ማጻፍዘ ቱሮ ታማርሶደስ፥ ባልዱንꬃና ሴሮደስ፥ ሉልሳደስን ጽሎትꬅ የስ ኮሽዘ ዞረ እንጎደስ ማዳነ። ");
INSERT INTO oyde_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","ጾዘ አስ ፎሎን ሎኦ ኦቻ ኡባስ ጊግዳያ ማቃደ ፋና ማዳነ። ");
INSERT INTO oyde_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","ታኒ ነና ጾዘ ቲኖን፥ ካት ማቂ አሆደስ ቆንጭዘ ዎደ ፋጹንꬃናን Ꮉይቂዱንꬃና ፍርዶደስ የዘ ክርስቶስ የሱሳ ቲኖ ዞራነ። ");
INSERT INTO oyde_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ቃላ ኦሆ፤ ዎደ ጊግን ጊጋንጽን ምንꬂ ኦሆ። ጋማ ዳንዳአራን ታማርሰራ አሱንꬃና ዞሮ፥ ሴርተራ ምንꬅꬆ። ");
INSERT INTO oyde_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","አሱንꬅ ቱሪ ትምርተ ስአንጾደ ዎደ ዮኦዳ። ኡን ፋ አሞትꬅ ካሊ፥ ፋስ ስኦደስ ኡፋይስዘ ባዝ ኦህዘ አስታማሩንꬃና ሺሻነ። ");
INSERT INTO oyde_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","ኡን ቱርባዝ ኦህዘ ትምርተ አሺ፥ ቱሮ ማቆሰ ቶሴ ስኦደስ ፋ Ꮉይቶ ማሀነ። ");
INSERT INTO oyde_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","የዝን ኔኒ ኡባ ባዛራ ነና አሆ። ማꬋ ዳንዳኦ። ዎንገለ ማርካትꬅ ኦችቶ ኦቾ። ኔስ እንግንትደ ጾዘ ኦችቶ ኡባ ፎሎ። ");
INSERT INTO oyde_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","ታኒ ዣርሾ ፋና ዣርሽንቶደ ዎደ የልዳ፤ Ꮉና አላምቶ አሺ ቅትዘ ዎደ ኡክዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","ታኒ ሎኦ ኦላ ኦልንትዳ፤ ዎꬅቶ Ꮉስዳ፤ አማኖ ናግዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","ቲኖፓ ጽሎትꬅ ዎርቃ ዛዉደ ታና ናጋነ። ይኖ ጽሎ ፍርዳ ፍርድዘ ላꬄ ይኖ ላምእንꬃ የኤ ቃምተ ታስ እንጎዳ። ይኖ ታ ጻላላስ ባይዝን ኤ ቆንጭꬅቶ አሙꬍዘ ኡቡንꬅስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","ኤልሲ ይእ ታና ቦኦ። ");
INSERT INTO oyde_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","ዴማሳ Ꮉና አላምተ የዘ ባዝ ካꬊ፥ ታና አሺ፥ ተሰሎንቄ ካታማ ቅትዳ። ቀርቅሳ ጋላትያ ሳአ፥ ማህ ትቶ ድልማጠ ሳአ ቅትዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ሉቃሳ ጻላላ ታራ የነ። ማርቆሳ ጾዘ ኦቻ ታና ማዶደስ ዳንዳእዘ ግሾ ኔራ ኤኪ ዮኦ። ");
INSERT INTO oyde_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","ታኒ ትክቆሳ ኤፈሶነ ካታማ ዳክዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","ኔኒ ይእተር፥ ጢሮአዳ ካታማ ካርፖሳ ካለ አሺ ይእደ ታ ኮትዛን ማጻፍቶ ታስ ኤኪ ዮኦ። ኡባፓ አꬂ ቆለራ ጻፍንትደ ማጻፍቶ ኤክካይዛራ ይእፐ። ");
INSERT INTO oyde_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","መቆ ቆጽዘ እስክንድረ ታና ጋማ ቆህዳ፤ ላꬂ ኤ ኦችት ፋና ኤስ ማሆዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","ኤ ኑ ትምርትቶ ጋማ እጽዘ ግሾ ኤፓ ነና ናጎ። ");
INSERT INTO oyde_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","ቲኖ ታ ሞትንትዘ ዎደ ኡባና አሺ ቅትዳ ፋትን ኦንን ታና ማድካያ። ጾዚ ይና ባልቶ ኡንትስ ፋይድፐ። ");
INSERT INTO oyde_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","የዝን ታኒ ሙሎ ኪታ አይሁደ ማቆሰ አሱንꬅ ኡቡንꬅስ ማርክꬍን፥ ኡን ስኦደ ፋና ላꬂ ታ ካለ ኤቂ ታስ ዎልቃ እንግዳ። ማህ ጋሞ ፋና ዶና ሻቅንግደ Ꮉይቆፓ ታና አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","ላꬂ ታና ኢታ ኡባፓ አሺ ፋ ሳሎ ካእቱሞ ሳሮራ የልꬆዳ። ኤስ መꬍናፓ መዽና የሎደስ ቦንቾ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","ጵርስቅላስ፥ አቂላስን አነስፎራ ካራ አሱንꬅስ ታ ሳሮትꬅቶ ኦሆ። ");
INSERT INTO oyde_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ኤራስጾሳ ቆሮንቶሳ ካታማ አትዳ። ጥሮፍሞሳ Ꮉርግንትደ ግሾ ምሊጠ ካታማ አሽዳ። ");
INSERT INTO oyde_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","ባርጎ ገሎደፓ ቲኒ ኤልሲ ዮኦ። ኤዉቡሉሳ፥ ጱዴሳ፥ ልኑሳ፥ ቅላደያን መለ አማንዘ አሱንꬅ ኡቡንꬅ ነና ሳሮ ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","ላꬄ የሱስ ክርስቶሳ ኔራ ማቀ። ጾዘ ማሮትꬅታ ይን ኡቡንꬃራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","የሱስ ክርስቶሳ ሐዋረን ጾዘ አሮ፥ ጳዉሎሳ፥ ጻፍደ ኪታ። ጾዚ ዶርደ አሱንꬅ አማኖ ድቾደ ጋራን ቱሪ አያና ደኦ ዋይዝ የሳደ የዛኮ ቱሪ ኤራጎ ኡንታና ካልꬆደስ ታ ኪትንትዳ። ");
INSERT INTO oyde_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","ይና አማንታን ኤራትꬅታ መዽና ደኦ ኡፋይሳላ አፋ ካትዳ። ይኖ ጋማ ዎደፓ ቲኖ ዎርዶ ኦሆሰ ጾዘ ኑስ እንጎዳ ጋእ ቃላ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","ኑና አሽዘ ጾዘ ፋ ዎድተ Ꮉኖ ኪቶ ኦሆደ ፋና ታስ Ꮉዳራ እንግ ፋ ቃልቶ ቆንጭዝዳ። ");
INSERT INTO oyde_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","ኑ ኮꬄ አማኖ ታ ቱሪ ናአ ማቅደ ትቶ፥ ጾዚ አዳይፓ ኑና አሽዘ የሱስ ክርስቶሳፓ አꬎ ኬሃትꬅ፥ ማሮትꬅን ሳሮትꬅ ኔስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","ታኒ ነና ቃርጼሰ አሺ ይእዳና፥ ነ አትደባዝ ጊግሳደ ፋናን ታኒ ኪትዳን ፋና ካታማ ኡባነ ዎሳ ኬꬃ ጭሙንꬃና ዶሮደ ፋና። ");
INSERT INTO oyde_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","ዎሳ ኬꬅ ጭማ ቦርንቶሳ፥ ፈቲ ማች አዝን፥ ዎጋ ባለራ ዎይ ኪትንታንጸራ አስ ቦሮሰ አማንዘ ናኡንꬅ የዘ አስ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","ዎሳ ኬꬂ ጭማ ጾዘ ኦቻ Ꮉዳራ ኤክደ ግሾ ቦርንቶሳ፥ ኡቱርቶሳ፥ ኤልስ ዥልꬎሳ፥ ማꬅንቶሳ፥ ኦሄ መꬎሳ፥ ቤዞሰ ባዝስ ዳፍንቶሳ ማቆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","የዝን ዛቆ ሞክዛ፥ ሎኦ ባዝ ኡባ ካꬍዛ፥ ቆፋራ የዛያ፥ ጽሎ፥ ጌሽን ፋና አህዛያ ማቃደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","መሉንꬃና ቱሪ ትምርተራ ምንꬅꬆደስን ይና ትምርትቶ እጽዙንꬃና ማሆደስ ፋ ታማርደ አማንꬅዘ ቃልተ ሚንግ ኤቆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","ኪትንቶሱንꬅ፥ ፋꬆሰ ኦሄ ኦህንትዙንꬅ፥ ጭምዙንꬅ አꬂ ጋራዝንተ ዎጋ ናግዘ ጋማ አሱንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","ኡን ቤዞሰ ኦገራ ሚሸ ደንጎደስ ኮይ፥ ታማርሶደስ ቤዞሰ ባዝ ታማርስተራ ካራ አሱንꬃና ኡባ ኢስዘ ግሾ ኡን ትምርትቶ ተቆደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","ኡን ናቡንꬃፓ ፈታይ፥ «ቃርጼሰ አሱንꬅ ኡባ ዎደ ዎርዶ ኦህንታነ፤ ኢታ ጾꬁንꬃና፥ አዛልአ ዥምባራ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Ꮉና ማርካትꬅታ ቱሪ ማርካትꬅ። ይኒ ግሾ፥ ኡንትስ ቱሪ አማኖ የሳደ ፋና ኡንታና ሴሮ። ");
INSERT INTO oyde_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","ቱሮ እጽዘ አሱንꬅ ትምርትቶን አይሁዱንꬅ ፋꬆሰ ቶሴ ስአመ ፋና ኡንታና ሴሮ። ");
INSERT INTO oyde_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","ጌሹንꬅስ ኡባና ጌሽ፥ የዝን ቱኑንꬅስን አማኖሱንꬅስ ኡን ቆፍታን ዎዝንታ ቱንደ ግሾ ኡንትስ አኮን ጌሽ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","ኡን ኑ ጾዝ ኤራነ ጋእነ፥ የዝን ፋ ኦችተ ኤዛ ካዳነ። ኡን እጽንትዱንꬃና፥ ኪትንቶሱንꬃናን ሎኦ ኦቻ ኡባስ ማቆሱንꬃና። ");
INSERT INTO oyde_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","የዝን ኔኒ ሉለ ትምርተ ታማርሶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","ጭማ ꬊራꬁንꬂ ፋና አህዙንꬃና፥ ዎፑ ጋይዱንꬃና፥ ቦንችንትዱንꬃና፥ አማኖራ፥ ሲቆራን ዳንዳአራ፥ ምንꬂ ማቃደ ፋና ዞሮ። ");
INSERT INTO oyde_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","ይኒ ጋራን፥ ጭማ ማቹንꬅ ፋ የስተ ጌሹንꬃና፥ ዙዝንጎሱንꬃና፥ ኡሽ አሞትꬅ ባይዙንꬃና ሎኦ ባዝ ታማርስዙንꬃና ማቃደ ፋና ታማርሶ። ");
INSERT INTO oyde_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","ኡን ይኒ ፋና Ꮉንኮ ናአትꬅ ማቹንꬅ ፋ አዝኑንꬃናን ፋ ናኡንꬃና ሲቆደ ፋና ታማርሶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ጾዘ ቃላ ቦሩንታመ ጋር ፋና አህዙንꬃና፥ ጌሹንꬃና፥ ፋ ካራ ኦችዙንꬃና፥ ካራ ፋ አዝኑንꬅስ ኪትንትዙንꬃና ማቃደ ፋና ናአትꬅ ማቹንꬃና ታማርሶ ዞሮ። ");
INSERT INTO oyde_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","ይኒ ጋር፥ ይꬎ ꬊራꬁንꬂ ፋ ኦምቶ አሆደ ፋና ዞሮ። ");
INSERT INTO oyde_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","ኔኒ ነ ኦምተ ሎኦ ኦቻ ኡባነ ኡንትስ አዝዘ ማቆ። ኔኒ ነ ትምርትተ ቱሮን አማንንትዳያ ማቆ። ");
INSERT INTO oyde_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","ኑ ሞርኩንꬅ ኑና ዝግሮደስ ምክናተ ማቅዘ ባዝ ኡንትስ ꬋብን ኡን ዬልꬎደ ፋና ነ ቦሩንቶሰ ሎኦ ኦሄ ኦህንቶ። ");
INSERT INTO oyde_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","አሩንꬂ ኡባ ባዛ ፋ ላꬁንꬅስ ኪትንቶደ ፋና፥ ኡንታና ኡፋይሶደ ፋናን ኡንታራ ላላመ ፋና ዞሮ። ");
INSERT INTO oyde_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","ኡን ፋ ላꬁንꬃፓ ሚሸ ካይስትፐ። ይናን፥ ኑና አሽዘ ጾዘ ትምርተ፥ ኡባ ኦገራ ካꬍንትዳያ ማቃደ ፋና ፋ ኦችዘ ኦችተ አምንንትዱንꬃና ማቅዛኖ ቤዞደ ፋና ኡንታና ዞሮ። ");
INSERT INTO oyde_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","አስ ኡባ አሽዘ ጾዘ አꬎ ኬሃትꬅ ቆንጭዳ። ");
INSERT INTO oyde_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","የ አꬎ ኬሃትꬅዘ፥ ኑ ናጋርቶን Ꮉና አላመ አሙቶ አሺ፥ Ꮉና ዎድተ ኑ ኦምቶ ናጊ፥ ቱሪ አያና የሳራን ጽሎትꬃራ የሳደ ፋና ኑና ታማርሳነ። ");
INSERT INTO oyde_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ይኒ ፋና ኑኒ አንጅንትደ ኡፋይስ ማቅደ ዳማ ጾዛን ኑና አሽዘ የሱስ ክርስቶሳ ቦንቾ ቆንጭꬅቶ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","ኢታ ኦቻ ኡባፓ ኑና ዎዞደስን ሎኦ ባዝ ኦቾደስ አሙꬍዘ ፋ ጌሽ አስ ኬሶደስ ኑ ግሾ ፋና አꬂ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","ኔኒ Ꮉኖ ታማርሶ፤ ኩሙꬅ አደትꬅ ወልቃራ ዞሮ፥ ሴሮ፤ ኦደን ነና ለቂፐ። ");
INSERT INTO oyde_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","አሱንꬅ ዎርዣ አህዙንꬅስ፥ አደትꬅ ዎልቃ የዙንꬅስ አዳትꬃራ ኪትንቶደ ፋና፥ ሎኦ ኦቻ ኡባ ኦቾደስ ጊግንትዱንꬃና ማቃደ ፋና ቆፕዞ። ");
INSERT INTO oyde_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","ማህን ኡን ኦደላን ኢታ ኦህንታመ ፋና፥ ሳሮ አስ ማቃደ ፋና፥ ዳልጋን አስ ኡባስ አዳ ማቃደ ፋና ዞሮ። ");
INSERT INTO oyde_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","ኑ ዛጋ ኤዩንꬃና፥ ኪትንቶሱንꬃና፥ ባልንትዙንꬃና፥ ዱማ ዱማ አሾ ኡፋይስስን አሞስ አሮ ፋና ማቅዱንꬃና። ኑ ኢታትꬃራን ቅናተራ ኩምዱንꬃና፤ ኑኒ አስ እጽዙንꬃና፥ አስን ኑና እጽዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","የዝን አሽዘ ጾዘ ኬሃትꬅን ሲቆ ቆንጭደ ዎደ ");
INSERT INTO oyde_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","ኑ ኦችደ ጽሎ ኦቻ ግሾ ባይዝን ፋ ማሮትꬅት ግሾ ኑና አሽዳ። ኑና ኤ አሽዳና፥ ላምእንꬃ የልንተ ሜጭንተራን ጌሽ አያና ባጋራ እንግደ ክለ ደኦር። ");
INSERT INTO oyde_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","የ አያንዛ፥ ጾዚ ኑና አሽዘ የሱስ ክርስቶሳ ባጋራ ኑላ አፋ ጋንꬅ ጉስዳ። ");
INSERT INTO oyde_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","ፋ አꬎ ኬሃትꬅት ባጋራ ኑና ጽልዚ መዽና ደኦ ላታ ኡፋይስ አይኮደ ፋና ይኖ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Ꮉይ ቃልዘ አምንንትደ ቃላ። ጾዛ አማንዙንꬅ ሎኦ ኦቻ ኦቾደስ ጊግዱንꬃና ማቃደ ፋና ነ Ꮉና ቃልቶ ምንꬂ ኦሆደ ፋና ታ ኮያነ። Ꮉንስ አስ ኡባስ ሎኦን ማድዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","የዝን ኤያትꬅ ላለፓን፥ ኮች ፋይደፓ፥ ካቻፋን ህገ ምክናተራ ደንድዘ ላለፓ ናግንቶ። ይና ማደን ትርፈ ባይዘ ባዝ። ");
INSERT INTO oyde_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","ሻክንተ መꬍዘ አꬃ ቲኖ ዞሮ፤ ላምእንꬃ ካጮ ይንፓ ሱባ ኤፓ Ꮉኮ። ");
INSERT INTO oyde_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","ይኒ ጋርዘ አስ ዎቦን ናጋራንቾ፤ ኤ ፋላ አፋ ፍርድዛኖ ኤሮ። ");
INSERT INTO oyde_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","ታኒ ስላ የይጋ ኣꬆደስ ቆፕደ ግሾ አርጤማሳ ዎይ ትክቆሳ ኔጎ ኪትዘ ዎደ ነ ታጎ ንቆጵልዮና ካታማ ዮኦደስ ኤልሶ። ");
INSERT INTO oyde_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","ህገ ኤራንቻ ዜናሳን አጵሎሳ ኦገ Ꮉንግዘ ዎደ ኡንትስ ኮሽዘ ባዝ ፋጫመ ፋና ኡንታና ማዶ። ");
INSERT INTO oyde_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","ኑ አሱንꬅን ፋꬆሰ አስ ማቂ አታመ ፋና ፋስ ኮሽዘ ባዝ ደንጎደ ፋና ሎኦ ኦቻ ኦቾደስ ሚንግ ታማሮ። ");
INSERT INTO oyde_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","ታራ የዘ ኡቡንꬅ ነና ሳሮ ጋነ፤ አማኖራ ኑና ሲቅዘ አሱንꬃና ሳሮ ጋኦ። ጾዘ አꬎ ከሃትꬅታ ይን ኡቡንꬃራ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","ታኒ ጳዉሎሳ፥ የሱስ ክርስቶሳ ግሾ አቻ የዛይን ኑ እሸ ጢሞትዮሳ፥ ኑራ ኦችዘ ኑኒ ካዽዘ ፍልሞናስ፥ ");
INSERT INTO oyde_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ይኒ ፋና ነ ካራ ሺቅዘ አማንዙንꬅስ፥ ኑ ምሽታ አፍብያሳስን ኑራ ዎላ የዘ ዎታዳረ አርክጳሳስ ጻፍደ ኪታ። ");
INSERT INTO oyde_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","ጾዘ ኑ አደፓን ኑ ላꬄ የሱስ ክርስቶሳፓ አꬎ ኬሃትꬅን ሳሮትꬅ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","5","ኔኒ ጌሹንꬃና ካꬍዛኖን ላꬄ የሱሳ አማንዛኖ ታኒ ስእደ ግሾ ጾዛ ዎስተራ ነና ቆፕዘ ዎደ ኡባ ታ ጾዝ ጋላታነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","ኔኒ ነ አማንቶ መሉንꬅስ ሻክዛና ኑስ ክርስቶስ የሱሳ ባጋራ የእዘ ሎኦ ባዝ ኡባ ኤሮደ ፋና ታኒ ጾዝ ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","አማንዙንꬅ ዎዝንታ ነ ኦችተ ሸምፕደ ግሾ ታ እሻዮ፥ ታኒ ነ ሲቅተ ጋማ ኡፋይስን ምንꬅትሞ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","ይኒ ግሾ፥ ኔኒ ኦቾደስ ቤዘባዝ ኦቾደ ፋና ነና ኪቶደስ ክርስቶሳ ባጋራ ታስ ምንꬂ ቆፋ የነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ታኒ፥ ጭምዘ ጳዉሎሳ፥ ክርስቶስ የሱሳስ Ꮉተን አች ኬꬃ የዛይ፥ ሲቆራ ነና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","ታኒ አች ኬꬃ የዝተራ ክርስቶሳራ ታስ ናአ ማቅደ አናስሞሳ ግሾ ነና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","ኤ ዛጋ ነና ማዶስ፥ የዝን Ꮉተ ነናን ታናን ቱርፓ ማዶደ አስ። ");
INSERT INTO oyde_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","13","ታኒ ዎዝናፓ ካዽዘ አናስሞሳ ኔጎ ዳክዳ። ታኒ ዎንገለ ግሾ አጭንቲ የዝን፥ ነ ግሾ ማህ ታና ማዶደ ፋና ታ ካለ ኤዛ አሾደስ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","የዝን ነ ቆፋ ጋር ኦቾደስ ኮይዳፕ አትን ኔራ ዞርንትካይዛራ ዎልቃራ አኮን ኦቾደስ ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","አናስሞሳ ኤራꬅ ዎደ ኔፓ ሻክንትደ፥ ኦደ ኤሮደ ማቂ ኡባ ዎደ ኔራ የዝካይዛራ አታማ። ");
INSERT INTO oyde_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","ይኬ፥ Ꮉንፓ ሱባ አናስሞሳ አሮ ባይዝን አሮፓ ኤ ጋማ አꬋነ። ኤ ታስ አኮ ጋር ሲቆ እሸ! ማህ ኤ ኔስ አሾ ባጋራን ላꬄ ባጋራ አꬍደ እሸ። ");
INSERT INTO oyde_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","ይኬ፥ ኔኒ ታና ኔስ ላገ ጋዘባዝ ማቅኮ ታና ሞክዛንፋና ኤዛ ሞኮ። ");
INSERT INTO oyde_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","ኤ ነና ቆህደ ባዝ ዎይ ኤስ ጋለ የዝኮ ታፓ ኤኮ። ");
INSERT INTO oyde_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","ይና አጭቶ ታ ጭጋዳ ጋእ ታኒ፥ ጳዉሎሳ፥ ታ ኩሽተ ጻፋነ። ኔኒ ታስ ነ ሸምፕቶ ጋልꬊ በትዳያ ታኒ ነና ቲርሳደስ ኮሾስ። ");
INSERT INTO oyde_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","ታ እሻዮ፥ ላꬄ ባጋራ ኔፓ ማደ ደንጎደስ ኮይዳ። ክርስቶሳ ባጋራ ታና ምንꬅꬆ። ");
INSERT INTO oyde_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","ታኒ ጋይዳንፋ ጋማ ነ ኦቾዳኖ ኤሪ ማህ ነ ታስ ኪትንቶዳኖ አማኒ Ꮉኖ ጻፋነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","ጾዚ ይን ዎስቶ ስእ ታና ይንታጎ ሱብ ማሆዳ ጋእ ቆፕዘ ግሾ ታስ አቅዘ ኬꬅ ጊግዞ። ");
INSERT INTO oyde_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","ክርስቶስ የሱሳ ግሾ ታራ አቻ የዘ ኤጳፍራ ነና ሳሮ ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","ማህ ታራ ዎላ ኦችዘ ማርቆሳ፥ አርስጥሮኮሳ፥ ዴማሳን ሉቃሳ ነና ሳሮ ሳሮ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","ላꬄ የሱስ ክርስቶሳ አꬎ ከሃትꬅታ ይንታራ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","ዛጋ ጾዚ፥ ኑ አዱንꬅስ ናቡንꬅ ባጋራ ዱማ ዱማ ኦገራ ጋማ ዎደ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","የዝን Ꮉና ዉርሱꬅ ዎድተ ኡባኖ ኤዛ ላትዝደ ማህ አላምቶ ኤ ባጋራ መꬍደ ፋ ናአይ ባጋራ ኑስ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","ናአይ ጾዘ ቦንቾ ፎእዘን ኩሙꬅ ጾዘ ጾዘትꬅቶ ኤኪ፥ ፋ ዎልቃ ቃላራ Ꮉና አላምቶ ካቲ አይክዳ። አሱንꬃና ኡን ናጋራፓ ጌሽዳንፓ ሱባ ኡባፓ ካታራ ጾዘ ምዛቅ ዛላራ ሳሎ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","ኤስ እንግንትደ ሱንꬅታ ኪታንቹንꬅ ሱንꬃፓ ካታራ ማቅዳን ፋና ኤ ኡንታፓ ካታራ። ");
INSERT INTO oyde_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","ይኬ፥ ጾዚ ኪታንቹንꬃፓ ኦደጎ፥ «ኔኒ ታ ናአ፤ ታ Ꮉይኖ ኔስ አደ ማቅዳ» ጋይዶ? ዎይ ማህ ኦደጎ፥ «ታኒ ኤስ አደ ማቃዳ፤ ኤዝን ታስ ናአ ማቃዳ» ጋይዶ? ");
INSERT INTO oyde_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","ማህ ጾዚ ፋ አንግስ ናአያ Ꮉና አላምተ ኪትተራ፥ «ጾዘ ኪታንቹንꬅ ኡባ ኤስ ጎይኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","ጾዚ ኪታንቹንꬅ ባዝ ኦህተራ፥ «ጾዚ ፋ ኪታንቹንꬃና አያና፥ ፋ አሩንꬃና ታማ ሎጸ ማህነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","የዝን ፋ ናአይ ባዝ ኦህተራ፥ «ጾዛዮ፥ ነ ካእቱምታ መꬍናስ የነ። ነ ካእቱምቶ ነ ጽሎትꬃራ አሆ። ");
INSERT INTO oyde_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","ኔኒ ጽሎትꬅ ካꬍዳ፤ ኢታ እጽዳ። ጾዚ፥ ነ ላꬄ፥ ነና ነ ላጉንꬃፓ አꬂ ዶርዳ፥ ኡፋይስ ዛይተ ነና ትዥዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","ጾዚ ማህ፥ «ላꬃዮ፥ ቲኖ ኔኒ ሳአ መꬍዳ፤ ሳሉንꬅ ነ ኩሸ ኦቻ። ");
INSERT INTO oyde_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","የንስ ኡባ ꬋቦዳ፤ የዝን ነ የሳዳ። ኡን ኡባ አፉላ ፋና Ꮉልኦዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","ነ ማጋራጃ ፋና ጻጾዳ፤ ማህ ኡን አፉላ ፋና ጭንጎዳ። የዝን ኔኒ ኡባ ዎደ ነና፤ ነ በርታን Ꮉልኦስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","የዝን ጾዚ ኪታንቹንꬃፓ ኦደጎ፥ «ታኒ ነ ሞርኩንꬃና ነ ቶህታ የꬍዘ በሲ ማሆደ ዎንꬅስ፥ Ꮉነ ታፓ ምዛቅ ዛላራ በቶ» ጋይዶ? ");
INSERT INTO oyde_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","ኪታንቹንꬅ ኡባ አቶትꬅ ደንጎደስ የዘ አሱንꬃና ማዶደስ ጾዚ ኪትደ አያኑንꬃና ባነ? ");
INSERT INTO oyde_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","ይኒ ግሾ፥ ኑኒ ስእደ ቱርፓ መለ በሳ ኤክንታመ ጋር ይና ስእዳኖ ምንꬂ ናጎደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","ይኬ፥ ኪታንቹንꬅ ባጋራ ኦህንትደ ቃልታ ቱሮ ማቅኮ፥ ኤዛ ቆሄን ኪትንታንጽ እጸ ፍርዳ ክእዘባዝ ማቅኮ፥ ");
INSERT INTO oyde_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","ዬዝን፥ ኑኒ Ꮉኒ ጋር ዳማ አቶትꬅ ኮዮስ ጋይኮ፥ ዋይዝ አቶደ? ቲኖ ላꬂ ፋ ኦምተ ይና አቶትꬅቶ ኦህዳ፤ ማህ ኤፓ ስእዱንꬅ ኑስ ጌሽ ማርክꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","ማህ ጾዚ ማላራን፥ ክለባዛራ፥ ዱማ ዱማ ክሌ ባዝ ፋ ቆፍት ጋር እንግደ ጌሽ አያና እሞትꬃራ ማርካትꬅቶ ምንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","ጾዚ Ꮉና ኑኒ ኦህዘ ቲኖፓ የኦደ አላምቶ፥ ኪታንቹንꬅስ አህዝካያ። ");
INSERT INTO oyde_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","ጌሽ ማጻፍተ ፈቲ በሳ Ꮉንጋራ ያጋይዳ፦ «ኔኒ አስስ ቆፖደስ አስ አኮ? ዎይ ኔኒ ኤዛ ናጎደስ አስ ናአይ አኮ? ");
INSERT INTO oyde_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","ነ ኤ ኪታንቹንꬃፓ ጽቅና ኤራꬅዳ፤ ኤ ኦምተ ቦንቾን ናሾ ባርኔጻ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","ማህ ኡባባዝቶ ኤ ቶህትፓ ኦሞራ ጋድዳ» ያጋይዳ። ጾዚ ኡባባዝቶ ኤስ አህዘ ዎደ ኤስ አቅካይዘ ባዝ አኮን ባያ። የዝን Ꮉተ ኡባ ባዝ ኤስ አቆደራ ኑኒ Ꮉጋ ብእካያ። ");
INSERT INTO oyde_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","የዝን ኑኒ ኪታንቹንꬃፓ ጽቅና ኤርደ የሱሳ በእነ። ጾዘ አꬎ ኬሃትꬅት ባጋራ የሱሳ አስ ኡባስ Ꮉይቂዳ። ኤ ዋየ Ꮉይቆ Ꮉይቂደ ግሾ ቦንቾን ናሾ ባርኔጻ ኤ ኦምተ ጋድዳ። ");
INSERT INTO oyde_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","ኡባ ባዝ ኤስን ኤ ባጋራ መꬍንትደ ጾዚ፥ ጋማ ናኡንꬃና ፋራ ቦንችሳደስ ኡን አቶትꬅትስ ኦማ፥ የሱሳ ዋይቶ ፎሎ ማሆደስ ኤስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","የሱሳን የንꬅ ኤ ጌሽደ አሱንꬅ ኡባ ፈቲ አደ ናኡንꬃና። የሱሳ ኡንታና፥ «ታ እሹንꬃና» ጋእ ጼጎደስ ዬልꬎሳና ይንስ። ");
INSERT INTO oyde_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","የሱሳ፥ «ታኒ ነ ሱንꬅቶ ታ እሹንꬅስ አዋጆዳ፤ ዎርዣ ሺቅተ ነና ጋላቶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","ማህ ኤ፥ «ታኒ ታ አማንቶ ኤላ አፋ ጋዶዳ» ማህን፥ «ጾዚ ታስ እንግደ ናኡንꬃራ ታ Ꮉነ የነ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","ናኡንꬅ አሾን ሱꬅ የዙንꬃና ማቅደ ግሾ የሱሳን ኡን ፋና አስ ማቅዳ። ኤ ይኖ ኦችዳና፥ Ꮉይቆላ አፋ ዎልቃ የዘ ጻላህዛ ፋ Ꮉይቅተ ꬋብሶደስ። ");
INSERT INTO oyde_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","ማህ ፋ የዘ በርተ ኡባ Ꮉይቆ ዣሽሞራ አርꬊ የዙንꬃና አሮትꬃፓ ኬሶደስ። ");
INSERT INTO oyde_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","ቱሮ የሱሳ ይእዳና አብራሃማ ኮች ማዶደስ ፋትን ኪታንቹንꬃና ማዶደስ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","አስ ናጋራ አቶ ጋእንቶደ ፋና ጾዘ ቲኖ ዱርዘ አማንንትደ ካህኑንꬅ Ꮉላቃ ማቅዳ። ይኒ ግሾ፥ ኤ ኡባባዝተ ፋ እሹንꬃና አዞደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","ኤ ፋ ኦምተ ፋታናራ ዋይንትደ ግሾ ፋታንንትዙንꬃና ማዶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","ይኒ ግሾ፥ ጾዚ ጼግደ ጌሽ እሹንꬆ፥ ኑ አማኖራ ላꬆ ጋእ ጼግዘ ሐዋረን ካህኑንꬅ Ꮉላቃ የሱሳ ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","ሙሴ ጾዘ ኬꬃ ኡባ አማንንትዳን ፋና የሱሳን ፋና ዶርደ ጾዘስ አማንንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","ኬꬂ ኬጽዛይ ኬꬅትፋ አꬊ ቦንችንትዛን ፋና የሱሳ ሙሴፓ አꬍዘ ቦንቾ ኤኮደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","ፈታ ፈታ ኬꬅዛ ኬጽደ አስ የነ፥ የዝን ኡባኖ ጊግዝደ ጾዚ። ");
INSERT INTO oyde_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","ሙሴ ጾዘ ኬꬃ ኡባነ አማንንትደ አሮ ማቂ፥ ጾዚ ቲኖፓ ጋዉደባዝስ ማርካ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","የዝን ክርስቶሳ ጾዘ ኬꬅተ ናአ ፋና አማንንትዳያ። ኑኒ ኤኮዳ ጋእ ናግዘ ኡፋይስቶ ምንꬂ ናግኮ ጾዘ ኬꬂ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","ይኒ ግሾ፥ ጌሽ አያና ጋዛንፋና፥ «Ꮉይኖ ይን ጾዚ ጋዛኖ ስእዘ ዎደ ");
INSERT INTO oyde_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","አኮ ባይዘ ሳአ ፋታንዘ ቃማ፥ ይን አዱንꬅ ገነ Ꮉንትዳን ፋና፥ ይን ዎዝንቶ ምንꬅፐተ። ");
INSERT INTO oyde_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","ይን አዱንꬅ ታና ፋታንዳ፤ ኦይታም በረ ታ ኦችቶ ብእዳ። ");
INSERT INTO oyde_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","ይኒ ግሾ፥ ታ ይና የለቱንꬃና ካጭ፥ ‹ኡን ኡባ ዎደ ፋ ዎዝንተ ባላነ፤ ታ ኦግቶ ኤርካያ› ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","ይኒ ግሾ፥ ታኒ ዥሎራ ጫቂ፥ ‹ታ ሸምፖ በስቶ ሙሎን ገሎስ› ያጋይዳ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","ታ እሹንꬆ፥ ይንታፓ ኦደን፥ ደኦ ጾዘፓ ይንታና ሻክዘ ኢታን አማኖሰ ዎዝና የዛመ ጋር ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","ይንታፓ ኦደን ናጋራ ባልꬅን፥ ፋ ዎዝንቶ ምንꬃመ ጋር «Ꮉይኖ» ጋእንት ጼግንቶደራ ቃምተ ቃምተ ፈተ ፈተራ ዞርንቶተ። ");
INSERT INTO oyde_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","ኑ ቲኖ አማንቶ ኑኒ ዉርሱꬅ የሎደስ ምንꬂ ናግኮ፥ ክርስቶሳራ ዎላ ሻክንትዙንꬃና። ");
INSERT INTO oyde_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","ጌሽ ማጻፍተ፥ «Ꮉይኖ ጾዚ ጋዛኖ ይን ስእዘ ዎደ የ ዎደ ኡን ጩቦራ Ꮉንዳን ፋና፥ ይን ዎዝንቶ ምንꬅፐተ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","ጾዚ ጋዘባዝ ስእ ጩቡꬍዱንꬅ ኦደ? ሙሴ ግብጸፓ ካልꬅ ኬስደ ኡቡንꬃና። ");
INSERT INTO oyde_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","ጾዚ ኦይታም በረ ኦና ካጭዶ? ናጋራ ኦችዱንꬃናን ኡን አህታ አኮ ባይዘ ሳአ ዎꬊ አትደ አሱንꬃና ባነ? ");
INSERT INTO oyde_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","ማህ ጾዚ፥ «ታ ሸምፖ በስቶ ገሎስ» ያጋእ ጫቂዳና፥ ኤስ ኪትንታንጽደ አሱንꬃና ባነ? ");
INSERT INTO oyde_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","ይኬ፥ ኡን ይና ሸምፖ በስቶ ገላንጽዳና አማንካይዘ ግሾ ማቅዳኖ ኑ በእነ። ");
INSERT INTO oyde_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","ይኬ፥ ጾዚ ኑና ፋ ሸምፖ በስቶ ገልꬆዳ ጋይደ ቃልታ Ꮉጋ ቲኖ የዘ ግሾ ይንታፓ ኦደን ይና ሸምፖ በስቶ ገላንጽ አታመ ፋና ናግንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","ኡንትስ ምስራቾ ቃላ ሳባክንትዳንፋና፥ ኑስን ሳባክንትዳ። የዝን ኡን ስእደ ቃልቶ አማኒ ኤክካይዘ ግሾ ኡንታና ማድካያ። ");
INSERT INTO oyde_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","ማቅኮን፥ አላመ መꬍንትዳንፓ አይኪ ጾዘ ኦችታ ፎልንትዳ ማቅኮን፥ ጾዚ፥ «ታኒ ታ ዥሎራ ጫቅ፥ ታ ሸምፖ በስቶ ሙሎን ገሎስ» ጋይዳንጋራ፥ ኑኒ አማንዱንꬅ ኤ ሸምፖ በስቶ ገሎዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","ላፑንꬆ ቃማባዝ ፈቲ በስተ፥ «ጾዚ ላፑንꬆ ቃምተ ፋ ኦቻ ኡባንፓ ሸምፕዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","ማህን ይና በስተ፥ «ኡን ታ ሸምፖ በስተ ሙሎን ገሎስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","ቲኖ ምስራቾ ቃላ ስእ ኪትንታንጽ ሸምፖ በስቶ ገልካያ። የይኮን፥ Ꮉተ ይና ሸምፖ በስቶ ገሎደ ፈቲ ፈቲ አሱንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","ይኒ ግሾ፥ ጾዚ፥ «Ꮉይኖ» ጋእ ጼግተራ ፈቲ ቃማ ኑስ ቃጣሮ እንግ ኤርስዳ። ጋማ ዎደፓ ሱባ ጾዚ ዳዉተ ባጋራ፥ «ጾዚ ጋዘባዝ Ꮉይኖ ይን ስእዘ ዎደ ይን ዎዝንቶ ምንꬅፐተ» ያጋእ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","እያሱ ኡንትስ ሸምፖ እንግደባዝ ማቅዛኮ፥ ጾዚ መለ ቃማባዝ ሱባፓ ኦሆስ የሻ። ");
INSERT INTO oyde_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","ይኬ፥ ጾዝ አስስ ሳምባታ ሸምፖ Ꮉጋ ናግንቲ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","ጾዘ ሸምፖ በስቶ ገልዘ ኦደን፥ ጾዚ ፋ ኦችትፓ ሸምፕዳንፋና ኤዝን ፋ ኦችትፓ ሸምፖዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","ይኒ ግሾ፥ ኦደን የንꬅ አሱንꬅ ኪትንታንጽ እጽዳኖ ካሊ፥ ጎልአመ ፋና ጾዘ ሸምፖ በስቶ ገሎደስ ምንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","ጾዘ ቃላ ደኦን ኦችዛያ። ላምእ ዛላራ ሌፍንትደ ማሻፓ አꬊ ኦጮ። ኤ ሸምፖ፥ አያና፥ ሻዣን ኮልዘን የሎደስ ገሊ ጫዳነ። ማህ አስ ዎዝንተ የዘ አችንትደ ቆፋን አሙቶ ሻኪ ፍርዳነ። ");
INSERT INTO oyde_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","ጾዘ ቲኖ አችንትደ አኮ መትꬅን ባያ። ኤ ኣፍት ቲኖ ኡባ ባዝ ቆንጨን ካሎ የነ። ኑኒ ማሄ እንጎደስ ቤዘ ኤ ቲኖ። ");
INSERT INTO oyde_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","ይኬ፥ ሳሎ ከዝደ ዳማ ካህኑንꬅ Ꮉላቅዘ፥ ጾዘ ናአይ የሱሳ፥ ኑስ የዘ ግሾ ኑ አማንቶ ምንꬂ ናጎዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","ኑ ካህኑንꬅ Ꮉላቅዘ ኑ ላብዘ ዎደ ኑስ ይቅስንቶደስ ዳንዳእዛያ። ኤ ናጋራ ኦችካያ፥ የዝን ኑ ፋና ኡባ ባዛ ፋታንንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","ይኬ፥ ማሮትꬅ ኤኮደስን ማደ ኮሽዘ ዎደ አꬎ ኬሃትꬅ ደንጎደስ አꬎ ከሃትꬅታ የዘ በሳ ጾዘ ካእቱሞ አራታጎ ዣሽሞ ባይꬅ ሺቆዳ። ");
INSERT INTO oyde_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","ፈቲ ፈቲ ካህኑንꬅ Ꮉላቃ አሱንꬅ ግዳፓ ዶርንት፥ ጾዛራ የልꬅዘ ባዛ አስ ግሾ እሞን ናጋራ ዣርሾ ዣርሾደስ ሹሙንታነ። ");
INSERT INTO oyde_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","ኤ ፋ ኦምተ ላብꬅ ማቅደ ግሾ ኤሮሱንꬅስን ባልንትዱንꬅስ ይቅስንቶደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","ኤ ፋ ናጋራ ግሾን አስ ኡባ ናጋራ ግሾ ዣርሾ ዣርሾደስ ቤዛና ይንስ። ");
INSERT INTO oyde_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","ኦደን Ꮉና ቦንችቶ ፋስ ኤኮደስ ዳንዳኦስ፥ የዝን አሮና ካህኑንꬅ Ꮉላቃ ማቃደስ ጼግንትዳን ፋና ጾዛራ ጼግንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","ይኒ ፋና፥ ክርስቶሳ ካህኑንꬅ Ꮉላቃ ማቅዘ ቦንችቶ ፋስ ኤክካያ። የዝን ጾዚ ኤዛ፥ «ኔኒ ታ ናአ። Ꮉይኖ ታ ኔስ አደ ማቅዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","ማህ መለ በሳ፥ «መልከጻድቀ ካህነ ሹማ ማቅዳን ጋራ፥ ኔኒ መꬍናስ ካህነ ማቃዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","የሱሳ አስ ማቂ Ꮉና አላምተ የዘ ዎደ ፋና Ꮉይቆፓ አሾደስ ዳንዳእዘ ጾዛ ጋማ ዬፎራን አፉꬃራ ዎስዳ። ኤ፥ ጾዝ ቦንቺ ኪትንትደ ግሾ ጾዚ ኤ ዎስቶ ስእዳ። ");
INSERT INTO oyde_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","የሱሳ ጾዘ ናአ ማቅኮን ኤክደ ማꬍተ ኪትንተ ታማርዳ። ");
INSERT INTO oyde_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","ይነን፥ የሱሳ ፋ ኦችቶ ፎልዳንፓ ሱባ ፋስ ኪትንትዘ ኡባ መዽና አቶትꬅ ደማደ ፋና ኦገ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","ይናን ጾዚ መልከጻድቀ ሹማ ፋና ካህኑንꬅ Ꮉላቃ ማህ ኤዛ ሹምዳ። ");
INSERT INTO oyde_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","Ꮉና ኑ ኦህትላ አፋ ጉጂ ኦሆደባዝ ጋማ ባዝ የነ፥ የዝን ይን ቆፍታ ኤራꬅ ማቅደ ግሾ ይንትስ ኦህ ገልꬆደስ ዋይꬃነ። ");
INSERT INTO oyde_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","ይን Ꮉኒ ዎደ አስታማረ ማቃደስ ቤዛነ፥ የዝን ጾዘ ቃላ ቲኖ ትምርተ ይንታና ማህ ታማርስዘ መለ አስ ኮሻነ። ይን ምንꬂ ካꬃ ማደስ ዳንዳኦሰ ግሾ ማꬅ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","ማꬅ ሽችንትዘ ኦደን ዦጋ ናአ ማቅደ ግሾ ሎኦን ኢታ ሻኪ ኤሮስ። ");
INSERT INTO oyde_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","የዝን ምንꬂ ካꬃ ኮሽዘ ሎኦን ኢታ ሻክዘ ኤራ የዘ ዎዝናማ አስስ። ");
INSERT INTO oyde_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","ይኬ፥ ክርስቶሳ ባዝ ታማርስዘ ቲኖ ትምርትቶ አሺ ክርስቶሳ ግዳ ዎዝናሙንꬅ ትምርተጎ የꬎተ። Ꮉይቆ ካልꬅዘ ኦቻፓ ማቅዘ ባዝን ጾዝ አማነባዝ ቲኖ ትምርተጎ ሱባ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","ይኒ ፋና፥ ጽንቃተ ባዝ፥ ኩሸ ጋደባዝ፥ Ꮉይቆፓ ደንዶ ባዝን መዽና ፍርዳባዝ ማህ ታማሮስ። ");
INSERT INTO oyde_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","ጾዚ ጋይኮ ኑ ይኖ ኦቾዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","ፈቲ ቶሄ ፎኦ ፎእዱንꬃና፥ ሳሎ እሞ ኤክዱንꬃና፥ ጌሽ አያናፓ ግሽንትዱንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","ሎኦ ጾዘ ቃላን ቲኖፓ የኦደ አላምት ዎልቃ ብእዱንꬃና፥ ");
INSERT INTO oyde_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ሱባፓ ካድዱንꬃና ናጋራፓ ላምእንꬃ ማሆደስ ዳንዳእንቶስ። አኮስ ጋይኮ፥ ኡን ፋ ꬋበስ ጾዘ ናአያ ማህ ሱጽዘ ፋና ማስቃላላ አፋ ኤዛ ሱጻነን አስ ቲኖ ካዉሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","ኡባ ዎደ ኤላ አፋ ቡክዘ እራ ኡዢ፥ ዎትዘ አꬃ ማድዘ ካꬃ እንግዘ ሳእታ ጾዛራ አንጅንትዳኖ። ");
INSERT INTO oyde_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","የዝን አንጋꬅን ክንችከሎ ዶልዘ ሳእታ አኮ ባዝን ማዶስ፤ ኢስ ባድꬅ ኡክዳ፤ ዉርሱꬅተ ምችንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","ኑ ሲቆ እሹንꬆ፥ ኑኒ Ꮉኒ ጋር ኦህዘ ባዝ ማቅኮን፥ ይንታና አቶትꬃጎ ካልꬅዘ ሎኦ ባዝ ይንትስ የዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","ጾዚ ሉለ ፍርድዛያ። ጾዚ፥ ይን ኦችደ ኦችቶን ዛጋ ማቅን Ꮉተ አማንዙንꬃና ማዲ፥ ኤስ የዘ ሲቅቶ ቤዝዳኖ ቦቶስ። ");
INSERT INTO oyde_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","ይን ኡባ ኡፋይሳራ ናግዛኖ ደንጎደ ዎንꬅስ Ꮉና ምንꬅቱምቶ ፎሎ የሎደስ ቤዞደ ጋር ኑ አሙꬋነ። ");
INSERT INTO oyde_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","ይን አማኖራን ዳንዳአራ ናግዘ ኡፋይስቶ ላትዘ አስ ማቃደ ጋር ፋትን አዛልአ ማቃደ ጋር ኮዮስ። ");
INSERT INTO oyde_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","ጾዚ አብራሃማስ እንጎዳ ጋእ ጫቂደ ዎደ ፋፓ አꬍዘ መለ ዳማ ባይዘ ግሾ ፋ ኦምተ ጫቂዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","ኤጎ፥ «ታኒ ነና አንጆዳ፤ ነ ዛርቶ ጋንꬆዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","አብራሃማ ዳንዳአራ ናጊ ጾዚ እንጎዳ ጋይደ ኡፋይስቶ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","አስ ጫቂተራ ፋፓ ዳምዘ አሳራ ጫቃነ፤ ይና ጫቅታ ጋእንትደባዝ ምንꬂ፥ ላለ ኡባ Ꮉሳነ። ");
INSERT INTO oyde_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","ይኒ ግሾ፥ ጾዚ ፋ ላምንቶሰ ቆፋ ኡፋይስ ቃላ ላትዙንꬅስ ቆንጭሳደስ ኮይደ ግሾ ጫቆራ ምንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","ጾዚ ዎርድꬎስ። ኤ ኡፋይስ ቃልታን ጫቅታ፥ ላምኡንꬅን ላምንቶስ። Ꮉና ላምእ ባዝተ ኑ ቲኖ የዘ ኡፋይስቶ አይኮደስ ዳንዳኦደ ፋና ካተ ደንጎደስ ኤጎ አችንትደ ኑኒ፥ ዳማ ምንꬅትሞ ደንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","Ꮉና ኡፋይስታ ኑ ሸምፕትስ፥ ማርካበ ኤንእንታመ ፋና ምንꬂ አይክዘ መቆ ፋና። ይና ኡፋይስታ ማጋራጃፋ ሱባ ዛላራ የዘ ጌሽ በሳ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","የሱሳ መልከጻድቀ ሹማትꬅት ፋና መꬍናስ ካህኑንꬅ Ꮉላቃ ማቂ፥ ኑ ግሾ ኑፓ ቲኒ ይና በስቶ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","መልከጻድቀ፥ ሳለመ ካት፥ ኡባፓ ካታራ ጾዘ ካህነ። የ መልከጻድቀ አብራሃማ ካቱንꬃና ኦሊ ጋሚ ማቃደራ ኤራ የልንት ኤዛ አንጅዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","አብራሃማ ፋ ድእደባዝ ኡባፓ ኤስ አስራታ ኬሲ እንግዳ። መልከጻድቀ ሱንꬅታ ቲኖ «ጽሎትꬅ ካት»፥ ላምእንꬃ፥ «ሳለመ ካት» ብልꬅታ፥ «ሳሮትꬅ ካት» ጋኤ። ");
INSERT INTO oyde_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","መልከጻድቀስ እንዳ ዎይ አደ ዎይ ኮች ፋይዶ ባያ። ኤ የለትꬅትስ ደንዶ ዎይ ኤ የስትስ ፋድꬅ ባያ፥ የዝን ጾዘ ናአ አዝዘ ማቂ መꬍናስ ካህነ ማቃነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","መልከጻድቀ አኮ ጋር ዳማ የዛኮ ቦኦተ። ኑ አዱንꬅ ማይዘ፥ አብራሃማ፥ ፋ ድእደባዛፓ ኤስ አስራታ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","ካህነ ማቅደ ሌወ ኮች እስራኤለ አሳፓ፥ የንስን አብራሃማ ኮች ማቅደ ፋ እሹንꬃፓ አስራታ ኤኮደ ጋር ህግታ ኪታነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","መልከጻድቀ ሌወ ኮች ማቃንጽኮን አብራሃመፓ አስራታ ኤክዳ፤ ኡፋይስ ቃላ የዘ አብራሃማ አንጅዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","ጌዛይ አንግሰፓ አንጅንትዛና ላልዞስ። ");
INSERT INTO oyde_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","ፈቲ ባጋራ፥ አስራታ ኤክዙንꬅ Ꮉይቅዘ አሱንꬃና፥ የዝን መለ ባጋራ አስራታ ኤክዙንꬅ ደኦ የነ ያጋእ ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","ይኬ፥ አስራታ ኤክዘ ሌወ፥ አብራሃማ ባጋራ አስራታ እንግዳ ጋዉደስ ዳንዳእንታነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","አኮስ ጋይኮ፥ መልከጻድቀ አብራሃማራ የልንትዘ ዎደ ሌወ የልንትካይዘባዝ ማቅኮን፥ ፋ ማይዘ አብራሃማ ቡንቅተ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","እስራኤለ አሱንꬅስ ህገ ሌወ ካህነትꬅ ባጋራ እንግንትዳ። Ꮉና ሌወ ካህነትꬅታ ፎሎ ማቅደ ባዝ የዛኮ አሮናን ፋና ማቅካይዝን፥ መልከጻድቀ ፋና መለ ካህነ ሹሞደስ አኮስ ኮሽዶ? ");
INSERT INTO oyde_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","ይኬ፥ ካህኑንꬅ ላምንትዘ ዎደ ህግታን ማህ ላምንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","Ꮉይ ኑ ኤ ባዝ ኦህዘ አꬄ መለ ኮች፤ ኤ ኮችትፓ ኦደን ዣርሾ በሳ ካህነትꬃ ኦችካያ። ");
INSERT INTO oyde_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","ኑ ላꬄ ይሁዳ ኮቻፓ ይእዳና ኤርንትዛኖ። ማቆ የዝን፥ ሙሴ ካህኑንꬅባዝ ኦህተራ ይሁዳ ኮች ባዝ አኮን ኦህካያ። ");
INSERT INTO oyde_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","መልከጻድቀ ፋና መለ ካህኑንꬅ ይእደባዝ ማቅዛኮ Ꮉና ኑ ኦህዛና አꬊ ቆንጮዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","ኤ ካህነ ማቅዳና ꬋቦሰ ደኦ ዎልቂተ ፋትን ኤ ማይዘ ህግተን ዎግተ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","ጌሽ ማጻፍዘ፥ «መልከጻድቀ ካህነትꬅ ፋና፥ ኔኒ መꬍናስ ካህነ» ያጋእ ማርክꬋነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","ቲኖ ህግታ ላብደ ባዝን ማዶሰ ባዝ ማቅደ ግሾ ሻርንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","ሙሴ ህገ አኮራን ፎሎ ኦቾደስ ዳንዳእካያ። የዝን ኑኒ ኤ ባጋራ ጾዛጎ ሺቅዘ ኡባፓ አꬍዘ ኡፋይስ ቃላ ኑስ እንግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","ክርስቶሳ ካህነ ማቅዘ ዎደ ጾዚ ጫቂዳ፥ የዝን መሉንꬅ ካህነ ማቅዘ ዎደ ይኒ ፋና ጫቆ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","የዝን የሱሳ ጫቆራ ካህነ ማቅዳ። ጾዝ ጋእ ጫቂዳ፤ «ላꬂ ጫቂዳ፤ ኤ ፋ ቆፍቶ ላሞስ፤ ‹ኔኒ መዽና ካህነ› » ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","Ꮉና ጫቅቲ ባጋራ የሱሳ ኑስ ኡባፓ አꬍዘ ቃላ ጫቅትስ ዋሰ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","ካህነትꬅ መꬍናስ ኦቻመ ፋና Ꮉይቆ ኡንታና ካይደ ግሾ ቲኖ ካህኑንꬅ ፋይድታ ጋማ። ");
INSERT INTO oyde_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","የዝን የሱሳ መꬍናስ የዘ ግሾ ኤ ካህነትꬅቶ መለ ላቶስ። ");
INSERT INTO oyde_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","ይኒ ግሾ፥ ኤ ኡባ ዎደ ኡን ግሾ ዎሶደስ መዽና የዘ ግሾ ጾዛጎ ኤ ባጋራ የእዙንꬃና ፎሎ አሾደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","ይኬ፥ ኑስ ኮሽዘ ባዝ እንግዘ፥ ጌሽ፥ ቦረን ቱና ባይዙንꬅ፥ ናጋራንቹንꬃፓ ሻክንትዳይን ሳሎፓ አꬊ ꬎቃ የዘ ካህኑንꬅ Ꮉላቃ ኑስ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","ኤ Ꮉንኮ ካህኑንꬅ Ꮉላቁንꬅ ጋር ቲኖ ፋ ናጋርት ግሾ ካሊ አስ ናጋርት ግሾ ቃምተ ቃምተ ዣርሾ ዣርሾደስ ኮሾስ። ኤ ፋና ዣርሽደ ዎደ ላምእንꬆሰ ኦገራ ፈቲ ቶሄ ፋና ዣርሽዳ። ");
INSERT INTO oyde_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","ሙሴ ህግታ ላቢꬅ አስ ካህኑንꬅ Ꮉላቃ ማህ ሹማነ። የዝን ህገፋ ሱባ ይእደ ጫቆ ቃልታ መዽና ፎሎ ማቅደ ጾዘ ናአያ ሹምዳ። ");
INSERT INTO oyde_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","ኑኒ ኦህዘ ዳማ ባዝታ Ꮉኖ። ሳሎ ኡባፓ ካታራ ጾዘ አራታፓ ምዛቅ ባጋራ በትደ Ꮉይ ፋና የዘ ካህኑንꬅ Ꮉላቃ ኑስ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","ኤ አሳራ ማቅካይዝን ላꬃራ ኤቅደ ቱሪ ዱንካንተ ጾዘ ኬꬃ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","ካህኑንꬅ Ꮉላቃ ኡባና እሞን ዣርሾ ዣርሾደስ ሹሙንታነ። ይኒ ግሾ ማህ፥ የ ካህንዘ ዣርሾደስ ፈትባዝ የሳደስ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","ህገ ኪትዛንፋና ዣርሽዘ ካህኑንꬅ የዘ ግሾ ክርስቶሳ ሳአ የዘ ባዝ ማቅዛኮ ካህነ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","ኡን ካህነትꬃ ኦችዘ ዱንካንታ ሳሎ የዘስ አዝዘን ዳሾ። ሙሴ ዱንካነ ኤስዘ ዎደ ጾዚ ኤጎ፥ «ታኒ ነና ደረላ አፋ ቤዝደ አዝዘ ካሊ ኦቾ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","የዝን የሱሳ እግንꬅዘ ግዳ ማቅደ ጫቆ፥ ቲኖ ጫቆፓ አꬍዛንፋና ኤ ኤክደ ኦችታ ኡንትስትፓ አꬋነ። ይና ኤቅዳና አꬍዘ ጫቆ ቃላራ። ");
INSERT INTO oyde_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","ቲኖ ጫቅተ ባላ ባይዘ ባዝ ማቅዛኮ ላምእንꬃ ጫቆ ኮሾስ። ");
INSERT INTO oyde_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","የዝን ላꬂ ኡንታና ቦሪ፥ Ꮉንጋራ ያጋይዳ፦ «ታኒ እስራኤለ አሱንꬃራን ይሁዳ አሱንꬃራ ክለ ጫቆ ጫቂዘ ዎደ የኦዳ። ");
INSERT INTO oyde_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","ይና ጫቅታ ታ ኡን አዱንꬃና ግብጸ ሳአፓ ኩሽቶ አይክ፥ ጎች ኬስደ ዎደ ኡንታራ ጫቂደ ጫቅት ጋር ባያ። ኡን ታ ጫቅተ አማንንትካይዘ ግሾ ታኒ ኡንታና ኦሊ አሽዳ ያጋይዳ ላꬂ። ");
INSERT INTO oyde_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","የዝን ይኬፓ ሱባ እስራኤለ አሱንꬃራ ታ ጫቆደ ጫቅታ Ꮉኖ ያጋይዳ ላꬂ። ታኒ ታ ህግቶ ኡን ጉግተ ጋዶዳ፤ ኡን ዎዝንተ ጻፎዳ። ታኒ ኡን ጾዚ ማቃዳ፤ ኡንትን ታ አስ ማቃዳ። ");
INSERT INTO oyde_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","ኡንታፓ ኦደን ፋ ዶꬅዛ ዎይ ፋ እሻ፥ ‹ላꬂ ኤሮ› ያጋእ ታማርሶስ። ኡን ኤራꬃፓ ዳማ የሎደስ ኡቡንꬅ ታና ኤሮዳ። ");
INSERT INTO oyde_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","ታኒ ኡን ቆህዳኖ አቶ ጋዉዳ፤ ኡን ናጋርቶ ማህ ቆፖስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","ጾዚ Ꮉይ ጫቅዛ «ክለ» ጋእ ጼግተራ ቲኖሳያ ጋልእዝዳ። ይኬ፥ ጋልእዘን ጭንግደ ꬋብዘ ዎደ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","ቲኖ ጫቅትስ ጾዝ ጎይንዘ ዎጋን ሳአ ጾዘ ኬꬂ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","ዱንካነ ኤቅዳ። እዘ ጾምፐ ጋድዘ በሲ፥ ጣርጰዛን ላꬄ ቲኖ ጋድዘ ቦራ የነ፤ ይና በስታ ጌሽ በሲ ጋእንታነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","ላምእንꬃ ማጋራጃፋ ሱባ ዛላራ የዘ በስታ ኡባፓ ጌሽ በሲ ጋእንታነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","እ ግዳ እጻነ ጩግዘ ዎርቃ ሳጥነን ዎርቃራ ጎዝንትደ ጫቆ ታቦተ የነ። የ ጫቆ ታቦትዘ ግዳ ማና የዘ ዎርቃ ጻሮ፥ አጭደ አሮና ጉፈን ሙሴ ህገ ጻፍንትደ ላምእ ሎቼ ሹቹንꬅ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","የ ታቦትዘፓ ካታ ዛላራ ማሮትꬅ ጎዝꬅ ፋ ቀፍተ አችዘ ቦንቾ ክሩበለ የነ። የዝን Ꮉተ Ꮉና ኡባኖ ቆንጭዝ ኦሆደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","Ꮉና ኡባና Ꮉንጋራ ጊግዳንፓ ሱባ፥ ካህኑንꬅ ኡባ ዎደ ፋ ኦችቶ ኦቾደስ ዱንካንትስ ቲኖ ክፍልተ ገላነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","የዝን ካህኑንꬅ Ꮉላቃ ጻላላ ዱንካንትስ ላምእንꬃ ክፍልተ በረፓ ፈቲ ቶሄ ገላነ። ኤ የይጋ ገልተራ ፋ ናጋርት ግሾን አሱንꬅ ኤርካይዛራ ኦችደ ናጋርት ግሾ ሱꬅ ዣርሾ ኤክካይዛራ ገሎስ። ");
INSERT INTO oyde_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","ቲኖ ዱንካነ ኤቂ የዝን፥ ኡባፓ ጌሽ በሲ ካንግዘ ኦግታ Ꮉጋ ቡጉንትካይዛኖ ጌሽ አያና ይነ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","ይና Ꮉና ዎድትስ አዝዘ፤ ጾዘስ እንግንትዘ እሞታን ዣርሽታ ጎይንዘ አꬄ ዎዝንቶ ጌሾደስ ዳንዳኦሳኖ Ꮉና ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","የንስ ሙንታ ባዝ፥ ኡሽባዝ ዱማ ዱማ ሜች ዎግቶ ኦህዙንꬃና። ኡን ክለ ዎጋ የኦደ ዎንꬅስ ኦችንትዘ ባለ ዎጋ። ");
INSERT INTO oyde_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","የዝን ክርስቶሳ Ꮉተ ኑ ደንግደ ሎኦ ባዝስ ካህኑንꬅ Ꮉላቃ ማቂ ይእዳ። ኤ ገልደ ዱንካንታ ዳማን ፎሎ። ይና ዱንካንታ አስ ኩሸራ ኦችንትካያ ማህ Ꮉና አላምትባዝ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","ክርስቶሳ ኡባፓ ጌሽ በሲ ገልዘ ዎደ ዴሽ ሱꬅን ዱሮ ሱꬅ ኤኪ ገልካያ። የዝን መዽና አቶትꬅ እንጎደስ ፋ ሱꬅቶ ኤኪ ላምእንꬆሰ ኦገራ ፈቲ ቶሄ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","ዴሽ ሱꬅን ኮርማ ሱꬅ፥ ምችንትደ ኦካ ቡዶ፥ ቱንደ አሱንꬃላ አፋ ዉጹርክን ኡንታና ጌሽዘባዝ ማቅኮ፥ ");
INSERT INTO oyde_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","መዽና ጌሽ አያና ባጋራ ቦረ ባይዝን ዣርሾ ኦቺ፥ ጾዝስ ፋና እንግደ ክርስቶሳ ሱꬅታ፥ ደኦ ጾዝ ጎይኖደ ፋና Ꮉይቆ ካልꬅዘ ኦቻፓ ኑ ዎዝንቶ ዋይዝ አꬂ ጌሾሳ? ");
INSERT INTO oyde_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","ይኒ ግሾ፥ ጼግንትዱንꬅ ጾዚ እንግደ መዽና ላታ ኤኮደ ጋር ክርስቶሳ ክለ ጫቆስ ግዳ ማቂ እግንꬅዛያ ማቅዳ። ይና Ꮉንዳና አሱንꬅ ቲኖ ጫቆፓ ኦሞራ የዘ ዎደ ኦችደ ናጋራፓ ኡንታና አሾደስ ኤ Ꮉይቂዳ። ");
INSERT INTO oyde_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","ይኬ፥ ኬከ የዝኮ፥ የ ኬክደ አꬄ Ꮉይቅታ ኤርንቶደስ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","ኬክደ አꬄ Ꮉይቂኮ ኤ ኬክታ ምንጋነ። ኬክደ አꬄ Ꮉይቃንጽ አትኮ ኤ ኬክታ ኦቾስ። ");
INSERT INTO oyde_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","መለ አቶ የዝን፥ ቲኖ ጫቅታን ሱꬅ ባይዝን ሚንግካያ። ");
INSERT INTO oyde_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","ሙሴ ህገ ኪታ ኡባ አስስ ኦህዳንፓ ሱባ ዱሮ ሱꬅን ዴሽ ሱꬅ Ꮉꬃራ ዎርቂ፥ ዞቆ ዱሮ እስንን ህሶጰ ታሸ ኤኪ፥ ማጻፍዘ ጋልቶን አሱንꬅ ጋልቶ ዉጹርካነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","ሙሴ አሱንꬃጎ፥ «ይን ናጎደ ጋር ጾዚ ኪትደ ሱꬅ ጫቅታ Ꮉኖ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","ይኒ ጋራ፥ ዱንካንዘ ጋልቶን ኦችዘ ሚሸ ኡባን ጋልቶ ሱꬅ ዉጹርካነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","ቱሮን ህግታ ጋዛን ፋና ኤራꬅባዝ ፋትን ኡባ ባዝ ሱꬃራ ጌዣነ። ሱꬅ ላንትካይዝን ማሮትꬅ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","ሳሎ ባዝስ አዝዘ ማቅዱንꬅ ኡባ Ꮉርስ ዣርሾራ ጌሻደስ ኮሻነ። የዝን ሳሎ ባዝታ ፋ ኦምተ ይንፓ አꬍዘ ዣርሾራ ጌሻደስ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","ክርስቶሳ ቱሪ ጾዘ ኬꬅስ አዝዘ ማቅደ፥ አስ ኩሸራ ኦችንትደ ኡባፓ ጌሽ በሳ ገልካያ። የዝን ኤ Ꮉተ ኑ ግሾ ጾዘ ቲኖ በንቶደስ ሳሎ ገልዳ። ");
INSERT INTO oyde_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","ካህኑንꬅ Ꮉላቅዘ በርተ በርተ ፋ ሱꬅ ማቅካይዛኖ ኤኪ፥ ኡባፓ ጌሽ በሳ ገላነ። የዝን ክርስቶሳ ጋማ ቶሄ ፋና ዣርሾደስ ሳሎ ገልካያ። ");
INSERT INTO oyde_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","ይኒ ጋራ Ꮉንደ ባዝ ማቅዛኮ፥ ክርስቶሳ አላመ መꬍንትዳንፓ አይኪ ጋማ ቶሄ ዋይንቶደስ ኮሻነ የሻ። የዝን Ꮉተ ዎደ ዉርሱꬅተ ናጋራ Ꮉሶደስ ፋና ዣርሺ ላምእንꬆሰ ኦገራ ፈቲ ቶሄ በንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","አስ ኡባ ፈቲ ቶሄ Ꮉይቆደስ ይንፓ ሱባ ፍርድንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","ይኒ ፋና፥ ክርስቶሳ ጋማ አሱንꬅ ናጋራ Ꮉሶደስ ፈቲ ቶሄ ዣርሽንትዳ። የዝን ኤ ናጋራ ቶኮደስ ማቅካይዝን ፋና ናግዙንꬃና አሾደስ ላምእንꬃ በንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","ሙሴ ህገ ዮኦደስ የዘ ሎኦ ባዝስ ዳሾ ፋትን ፋ ኦምተ ዋና ባያ። ይኒ ግሾ፥ በርተ በርተ ፋጨ ባይዝን ዣርሽንትዘ ዣርሽታ ጎይኖደስ ሺቅዘ አሱንꬃና ፎሎ ማሆደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","ህገ ኡንታና ፎሎ ማሆደስ ዳንዳእደባዝ ማቅዛኮ ኡን ዣርሾ ዣርሽዛኖ አሾዳ የሻ። ማህ ጎይኖደስ ሺቅዘ አሱንꬅ ፋ ናጋርትፓ ጌሻዳ፤ ኡን ዎዝንታን ኡንታና ባላ ጋእ ሞቶስ። ");
INSERT INTO oyde_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","የዝን ይና ዣርሹንꬅ በርተ በርተ ናጋራ ቆፍዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","አኮስ ጋይኮ ኮርማ ሱꬅን ዴሽ ሱꬅ ናጋራ ꬋብሶደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","ይኒ ግሾ፥ ክርስቶሳ Ꮉና አላምተ ይእደ ዎደ Ꮉንጋራ ያጋይዳ: «ኔኒ ዣርሾን እሞ ኮይካያ፤ የዝን ታስ አሾ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","ኔኒ ኤጽዘ ዣርሾን ናጋራ ዣርሽተ ኡፋይትካያ። ");
INSERT INTO oyde_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","የ ዎደ ‹ታ ግሾ ማጻፍተ ጻፍንትዳንጋራ፥ ላꬆ፥ ታኒ ነ ቆፍቶ ኦቾደስ ይእዳ› ጋይዳ» ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","ዣርሽታ ዣርሽንቶደ ጋር ህገ ኪትዘባዝ ማቅዛኮ፥ ክርስቶሳ ቲኖ፥ «ኔኒ ዣርሾን እሞ፥ ኤጽዘ ዣርሾን ናጋራ ዣርሾ ኮይካያ፤ ኡንታራ ኡፋይትካያ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","ካልን ኤ፥ «ላꬆ፥ Ꮉይቼ ታኒ ነ ቆፍቶ ኦቾደስ ይእዳ» ያጋይዳ። ይኒ ግሾ፥ ክርስቶሳ ላምእንꬃ ኤሶደስ ቲኖሳያ ሻርዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","የሱስ ክርስቶሳ ጾዘ ቆፋ ኦቺ፥ ላምእንꬆሰ ኦገራ ፈቲ ቶሄ ፋ አሽቶ ዣርሽደ ግሾ ኑኒ ጌዥዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","ካህኑንꬅ ኡባ፥ ናጋራ Ꮉሶደስ ዳንዳኦስ ይና ዣርሽቶ ቃምተ ቃምተ ዣርሽተራ ኤቂ ፋ ኦችቶ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","የዝን ክርስቶሳ ኡባ ዎደስ ማቅዘ ፈቲ ናጋራ ዣርሾ ዣርሺ፥ ጾዛፓ ምዛቅ ዛላራ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","የ ዎደፓ አይኪ ኤ ሞርኩንꬅ ኤ ቶህታ የꬍዘ በሲ ማሆደ ዎንꬅስ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","ኤ ላምእንꬆሰ ኦገራ ፈቲ ቶሄ ፋና ዣርሽደ ዣርሽተ ጌሹንꬃና መꬍናስ ፎሎ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","ማህ ጌሽ አያና ኑስ Ꮉኖ ማርክꬋነ። ቲኖ Ꮉንጋራ ያጋይዳ፦ ");
INSERT INTO oyde_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","«ይና ቃምትፓ ሱባ፥ ታኒ ኡንታራ ጫቂዘ ጫቅታ Ꮉኖ፦ ላꬂ ታ ህግቶ ኡን ዎዝንተ ጋዶዳ፤ ኡን ጉግተ ጻፎዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","ካሊ፥ «ታኒ ኡን ናጋርቶን ኡን ኢታ ኦችቶ ማህ ቆፖስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","ይኬ፥ ናጋራ አቶ ጋእንትዳንፓ ሱባ ናጋራስ ዣርሽንትዘ ዣርሾ ኮሾስ። ");
INSERT INTO oyde_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","ይኬ፥ ታ እሹንꬆ፥ ኑኒ የሱሳ ሱꬅት ባጋራ ኡባፓ ጌሽ በሲ ገሎደስ ኑስ አማንꬅዘ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","ኑ ገሎዳና ክርስቶሳ ፋ ማጋራጅቶ፥ ይናን ፋ አሽቲ ባጋራ ኑስ ቡግደ ክለን ደኦ ማቅደ ኦገ። ");
INSERT INTO oyde_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","ኑስ ጾዘ ኬꬃ ካታራ ሹሙንትደ ዳማ ካህኑንꬅ Ꮉላቃ የነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","ይኒ ግሾ ኑኒ ኢታ ቆፋፓ ጌሻደስ ኑ ዎዝንተ ዉጹርክንት፥ ኑ ጋልቶ ጽሎ Ꮉꬃራ ሜጪ፥ ሉለ ዎዝናራን ፎሎ አማኖራ ጾዛጎ ሺቆዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","ኑስ ኡፋይስ ቃላ እንግደ ጾዘ አማንንትዳያ ማቅደ ግሾ ኑ ማርክꬍዘ ኡፋይስቶ ምዛቅ ዎርክታ ጋይካይዛራ ምንꬂ አይኮዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","ፈታይ ፈታ ሲቆስን ሎኦ ኦቻስ ዋይዝ ደንꬅꬆድ የዛኮ አነ ቆፖዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","ፈተ ፈተ ልምደ ማህ ሺቅዛኖ አሽዳን ፋና ኑኒ ዎላ ሺቅዛኖ አሾስ። የዝን ላꬄ ቃምታ ኡክዳኖ ይን በእዘ ግሾ ይኖ ዛጋንፓ አꬂ ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","ኑኒ ቱሪ ኤራትꬅ ኤክዳንፓ ሱባ ኤሪተ ናጋራ ኦቾስ፥ ይኬፓ ኑ ናጋራ ግሾ ዣርሽንቶደ ዣርሾ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","የዝን ይኬ አትዳና ዣሽዘ ፍርዳን ጾዘ ሞርኩንꬃና ምቾደስ ጊግደ ዳማ ታማ። ");
INSERT INTO oyde_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","ሙሴ ህግቶ ኪትንታንጽደ ኦደን ላምእ ዎይ Ꮉይꬕ አስ ኤላ አፋ ማርክꬍኮ ይቅስሞ ባይꬅ Ꮉይቃነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","ዬዝን፥ ጾዘ ናአያ ቶችዳይ፥ ፋና ጌሽደ ጾዘ ጫቆ ሱꬅቶ ቱንዝደ፥ ማህ አꬎ ኬሃትꬅ አያና ጫዥዳይ፥ አኮ ጋር ኢታ ፍርዳ ኤኮደስ ቤዝዛኮ አነ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","ይኬ፥ «ኩሸ ማሄ ታ ባዝ፥ ታ ኩሸ ማሆዳ» ጋይዳኖ ኑ ኤራነ። ማህን፥ «ላꬂ ፋ አሱንꬃና ፍርዶዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","ደኦ ጾዘ ኩሽተ ጎልኤ ጋማ ዣሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","ይንትስ ጾዘ ፎኦ ፎእዳንፓ ሱባ ይን ጋማ ዋየራ፥ ዳማ ኦላራ ገንጭደ ዛጋ ዎድቶ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","ፈቲ ፈቲ ቶሄ ይን አስ ቲኖ ጫዥንትዳ፤ ባይእንትዳ፤ ፈቲ ፈቲ ቶሄ ይኒ ፋና ዋየ የልደ አሱንꬃራ ዎላ ዋይንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","አቻ የዘ አሱንꬅስን ይቅስንትዳ። ይንትስ ሎኦን ꬋቦሰ ቆሎ ሳሎ የዛኖ ይን ኤርደ ግሾ ይን ቆልታ ቦንቅንትዘ ዎደ ኡፋይሳራ ዳንዳእዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","ይኒ ግሾ፥ ዳማ አንጆ የዘ ይን አማንንትዳያ ኦልፐተ። ");
INSERT INTO oyde_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","ጾዘ ቆፋ ፎሊ፥ ኤ ይንትስ እንጎዳ ጋይደ ኡፋይስቶ ኤኮደ ዎንꬅስ ገንጮደስ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","ይኬ፥ ጌሽ ማጻፍተ፥ «ኤ፥ የኦዳ ጋይዳይ ኤራꬅ ዎደፓ ሱባ የኦዳ፤ ጋምኦስ። ");
INSERT INTO oyde_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","የዝን ጽልዘ፥ አማኖራ የሳዳ፤ ኦደን ሱብ ማቅኮ ታና ኡፋይሶስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","ኑኒ አማኒ አትዘ አሱንꬅ ባጋ ፋትን ሱባ ማቂ ꬋብዘ አሱንꬅ ባጋ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","አማኖ ጋዛና፥ ደንጎዳ ጋእ ኡፋይሳራ አማንንቲ ናግዘ ባዝን ኑ ብእካይዘ ባዝ ብእደ ፋና ማህ ኤክዘባዝ። ");
INSERT INTO oyde_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","ዛጋ አዱንꬅ አማኖራ ጾዛፓ ማርካትꬅ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","አላመ ጾዘ ቃላራ መꬍንትዳኖ ኑ አማኖራ ኤራነ። ማህ በንትዘ ባዝ በንቶሰ ባዛፓ መꬍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","አቤላ ቃኤላፓ አꬍዘ ዣርሾ ጾዝስ ዣርሽዳና አማኖራ። ጾዚ አቤላ እሞትꬅቶ ኡፋይት ኤክደ ዎደ ኤ ጽሎ ማቅዳኖ ማርክꬍዳ። አቤላ መለ አቶ የዝን፥ Ꮉይቂን ኤ አማንታ Ꮉይኖ የሎደስ ኦህንታነ። ");
INSERT INTO oyde_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","ሄኖካ Ꮉይቂካይዛራ ሳሎ ኤክንትዳና አማኖራ። ጾዚ ኤዛ ኤክደ ግሾ ኦደን ኤዛ በአደስ ዳንዳእካያ። ሄኖካ ሳሎ ኤክንቶዳንፓ ቲኖ ኤ ጾዘ ኡፋይስደ አስ ማቅዛና ኦህንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","አማኖ ባይዝን ኦደን ጾዝ ኡፋይሶደስ ዳንዳኦስ። ጾዛጎ የእዘ ኦደን ጾዚ የዛኖን ፋና ኮየዙንꬅስ አንጆ እንግዛኖ አማኖደስ ኮሻነ። ");
INSERT INTO oyde_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","ኖሄ Ꮉጋ በንቶሰ ባዝስ ጾዚ ኤስ ኦህደ ዎደ ጾዝስ ዣሽቲ፥ ፋናን ፋ ካራ አሱንꬃና አሾደስ አማኖራ ማርካበ ኬጽዳ። የይዝ ፋ አማንትራ አላምቶ ፍርድ፥ አማኖራ በንትዘ ጽሎትꬅ ጾዛፓ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","አብራሃማ ላታ ማህ ኤኮደ ሳአ ቅቶደ ጋር ጾዚ ኤዛ ጼግደ ዎደ መለ አቶ የዝን፥ ኤ አባ ቅትዛኮ ኤራንጽኮን ኪትንትዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","አብራሃማ ጾዚ ኤስ እንጎዳ ጋይደ ሳእተ በተ አስ ፋና የዝዳና አማኖራ። ጾዚ የ እንጎዳ ጋይዳኖ ኤራ ዎላ ላቶደስ የዘ ይሳቃራን ያይቆባራ ዱማ ዱማ ዱንካነ ግዳ የዝዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","ኤ፥ ጾዚ ቆፒ ኬጽደ ጻላ ባሳ የዘ ካታማ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","ሳራ ፋ ኦምተ ጭንግዳኖ ማቅኮን ኡፋይስ እንግደ ጾዘ አማንንትዳያ ማቅዳኖ ኤርደ ግሾ ዎዳጾደስ ዎልቃ ደንግዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","ይኒ ግሾ፥ Ꮉይቂደ አስ አዝዘ ፈቲ ꬊራፓ ሳሎ ጾልንቶ ጋራን አባ ጋጻ የዘ ፋይዶ ባይዘ ሻፈ ፋና ኮች የልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","የንꬅ አሱንꬅ ኡባ ፋስ ጋእንትደ ኡፋይስ ቃላ ኤክካይዛራ አማኖራ Ꮉይቂዳ። የዝን Ꮉኮራ ይኖ ብእ፥ ደንግደ ፋና ማህ፥ ኡፋይሳራ ኤክዳ። ማህ ኡን ሳአላ ዛቆን በተ አስ ማቅዛኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","ይኒ ፋና ጋዘ አሱንꬅ ፋ ሳእቶ ናግዛኖ ቆንጨ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","ኡን አሺ ከዝደ ሳእቶ ሱባ ቆፕደባዝ ማቅዛኮ ሱባ ማቃደስ ዳንዳአነ። ");
INSERT INTO oyde_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","የዝን Ꮉተ አꬍዘ ሳሎ ጋደ አሙꬋነ። ይኒ ግሾ፥ ጾዚ ኡንትስ ካታማ ጊግዝደ ግሾ «ኡን ጾዝ» ጋእንት ጼግንቶደስ ዬልꬎኦስ። ");
INSERT INTO oyde_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","አብራሃማ ፋታንንትደ ዎደ ይሳቃ ዣርሽዳና አማኖራ። ያና ኡፋይስ ቃልቶ ኤክደ አብራሃማ ፋ ፈቲ ናአ ዣርሾደስ ጊግዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","ጾዚ አብራሃማጎ፥ «ነ ዛርታ ይሳቃ ባጋራ ጼግንቶዳ» ያጋእ ኦህዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","ጾዚ Ꮉይቆፓ ደንꬆደስ ዳንዳእዛኖ አብራሃማ አማንደ ግሾ ይሳቃ Ꮉይቆፓ ፋጺ ደንድደ ፋና ማህ ኤክዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","ይሳቃ ዎደፓ Ꮉኖደባዝ ኤሪ ያይቆባን ኤሳዎ አንጅዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","ያይቆባ Ꮉይቆደስ ይእተ፥ ፈታ ፈታ ዮሰፋ ናኡንꬃና አንጅዳናን ጉፈላ ካቲ ጎይንዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","ዮሰፋ Ꮉይቆደስ ኡክደ ዎደ እስራኤለ አሱንꬅ ግብጸፓ ኬዞዳኖ ኦህዳና ፋ መቃꬅቶ ይሳደባዝ ኡንታና ኪትዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","ሙሴ የልንትዳንፓ ሱባ ኤ እንታን ኤ አዳይ ብሽታ ሎኦ ናአ ማቅዳኖ ብእ Ꮉይꬕ አግና አችዳና አማኖራ፤ ኡን ካት አዋጀስ ዣሽትካያ። ");
INSERT INTO oyde_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","ሙሴ ድጭዳንፓ ሱባ ግብጸ ካት ኡርት ናአ ጋእንቶዳኖ እጽዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","ሙሴ ናጋራራ ኤራꬅ ዎደስ ኡፋይቶዳንፓ፥ ጾዘ አሳራ ማꬋ ኤኮዳኖ ዶርዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","ኤ ቲኖፓ ደንጎደ አንጅቶ ጵርጭ ዪዚ ብእደ ግሾ ግብጸ ቆሎፓ አꬂ ክርስቶሳ ግሾ ቦርንቶዳኖ ጋማ አꬍዘ ዱረትꬅ ማቅዳኖ ኤርዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","ሙሴ ካት ካች ዣሽትካይዛራ፥ ግብጸፓ ኬዝዳና አማኖራ። በንቶሰ ጾዛ ብእደ አስፋና ዪእ ፋ ቆፍተ ገንጭዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","Ꮉይቆ ክእዘ ኪታንቹንꬅ እስራኤለ አሱንꬅ አንግስ ናኡንꬃና ዎꬋመ ጋር ሙሴ ፋስካን ሱꬅ ዉጹርኬ ዎጋ ኦችዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","እስራኤለ አሱንꬅ መላ ሳአራ የꬍዘ ፋና የꬊ፥ ዞቆ አባ ፊንግዳና አማኖራ። የዝን ግብጸ አሱንꬅ ገሎደስ ፋታኒ በአደራ Ꮉꬅታ ኡንታና ቆꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","እስራኤለ አሱንꬅ እያርኮ ካታማ ሹች ጋሰ ላፑን ዎደ ዉቲ፥ ጎልእዝዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","ኦላለራ ኤርንትዳና ረአባ ጋደ ጌድዙንꬃና ሞክደ ግሾ ኪትንቶሰ አሱንꬃራ Ꮉይቃንጽ አትዳና አማኖራ። ");
INSERT INTO oyde_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","ይኬ፥ መለ ታ አኮ ጋኦ? ጌድዮና ባዝ፥ ባራቀ ባዝ፥ ሳምሶና ባዝ፥ ዮፍታሄ ባዝ፥ ዳዉተ ባዝ፥ ሳሙኤላ ባዝ፥ ማህ ናቡንꬅ ባዝ ኦሆደስ ታስ ዎደ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","ኡን አማኖራ ካእቱምቶ ጋምዳ፤ ጽሎትꬃራ አህዳ፤ ጾዚ እንጎዳ ጋይደ ኡፋይስቶ ኤክዳ፤ ጋሙንꬅ ዶና ጎርድዳ፤ ");
INSERT INTO oyde_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","ታማ ዎልቃ ዎꬍዳ፤ ሞርኩንꬅ ማሻፓ አትዳ፤ ፋ ላቢስተ ምንግዳ፤ ኦላራ ዎልቃማ ማቅዳ፤ አላጋ ቶራንቹንꬃና ባይእዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","ማቹንꬅ ኡን እግኑንꬅ Ꮉይቂዱንꬅ Ꮉይቆፓ ፋጽን ኤክዳ። ማህ መሉንꬅ አꬍዘ Ꮉይቆፓ ደንዶ ኤኮደስ ኮይ ዱማ ዱማ ዋየ ኤክዳ፤ አቻፓ ብልንቶዳኖ እጽዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","መሉንꬅ አሳራ ቦርንቲ አላንጋራ ጋራፍንትዳ፤ መሉንꬅ ሳንꬃላታራ አጭንቲ አች ኬꬃ ኦልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","ኡን ሹቻራ ꬎግንትዳ፤ ማጋዘራ ላምእ ኬዚ ጳልቂንትዳ፤ ፋታንንትዳ፤ ማሻራ Ꮉይቂዳ፤ ኡንትስ ኡባ ባዝ ꬋብን ማꬍꬍዳ። ዱሮ ሞኦን ዴሽ ሞኦ ማእ Ꮉንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","ኡንትስ Ꮉና አላምታ ጊጋንጽ እጽን አኮ ባይዘ ሳአን፥ ደረላ አፋ፥ ዎምኦን ኦላ ግዳን ውትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","ጾዚ ኡን አማንትባዝ ማርክꬍኮን፥ ይና ኡባ ጋእንትደ ኡፋይስ ቃልቶ ኤክካያ። ");
INSERT INTO oyde_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","ጾዚ ኑስ ሎኦ ባዝ ቆፕዳ፤ ይኒ ግሾ ኡን ኑ ባይꬅ ፎሎ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","ይኬ፥ ꬎነ ፋና ኑ ካንቶ ዉቲ ጋንግ Ꮉኒ ፋና ማርኩንꬅ ኑ ካለ የዘ ግሾ ኑና ꬉቢዘ ኡባኖን አይክንቲ የዘ ናጋራ Ꮉሲ፥ ኑ ቲኖ የዘ ጋልጋደ ዎꬅቶ ገንጭ ዎጾዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","ኑ አማንትስ ኦገ ቡግዳያን ኑና ፎሎ የልꬅዘ የሱሳላ አፋ ኑ ኣፍቶ ጋዶዳ። የሱሳ ቲኖፓ የዘ ኡፋይስት ግሾ ማስቃላላ ዋየ ዳንዳእ፥ ዬላ Ꮉይቆ ለቂ፥ ጾዛፓ ምዛቅ ዛላራ በትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","ይኬ፥ ይን ዶጪ ኡፋይስ ጋቻመ ፋና ናጋራንቹንꬅ እጻ ዳንዳእደ የሱሳ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","ናጋራራ የዘ ቡተ Ꮉጋ ሱꬅ ላሎደ ዎንꬅስ ኤቅንትካያ። ");
INSERT INTO oyde_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","ጾዚ ፋ ቃልተ፥ ፋ ናኡንꬅ ፋና ይንታና ዞሪዳኖ ቦትዳ። «ታ ናአዮ፥ ጾዘ ሴረ ለቂፐ፤ ኤ ነና ሴርዘ ዎደ ኡፋይስ ጋችፐ። ");
INSERT INTO oyde_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","ላꬂ ፋ ካዽዘ አꬃ ሴራነ፤ ማህ ፋ ናአ ፋና ኤክዛ ኡባ ጋራፋነ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","ጾዚ ይንታና ፋ ናኡንꬅ ፋና ሴርዘ ዎደ ገንጮተ፤ አዳይ ሴሮሰ ናአይ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","ጾዚ ፋ ናኡንꬃና ኡባ ሴራነ፤ ይን ሴርንታንጽኮ ቱሪ ኤ ናአ ባይዝን ባላኮ ናአ። ");
INSERT INTO oyde_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","ማህ ኑና የልደ ኑ አዱንꬅ ኑና ሴራነ፤ ኑንን ኡንታና ቦንቻነ። ዬዝን፥ ኑኒ ደኦ የሳደስ ኑ አያና አደስ ዋይዝ አꬊ አቆሶ? ");
INSERT INTO oyde_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","ይኬ፥ ኑ አዱንꬅ ፋስ ሎኦ የሳደ ፋና ኤራꬅ ዎደስ ኑና ሴርዳ። የዝን ጾዚ ኑ ማደስ፥ ኑ ኤ ጌሻትꬅቶ ግሽንቶደ ፋና ሴራነ። ");
INSERT INTO oyde_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","ኑ ሴርንትዘ ዎደ ዥልዛነ ፋትን ኡፋይሶስ። የዝን ሱባፓ ሴረꬅቶ ኤክደ አስስ ሴርꬅታ፥ ሳሮ ኩምደ ጽሎትꬅ ኣፈ አፍዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","ይኬ፥ ይን አርጋጭደ ኩሽቶን ይን ላቢደ ቡንቅቶ ምንꬆተ። ");
INSERT INTO oyde_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","ዎቢደ ፋጾደ ጋር ፋትን አꬊ መቃመ ጋር ይን ቶህትስ ሉለ ኦገ ጊግዞተ። ");
INSERT INTO oyde_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","አስ ኡባራ ሳሮ የሳደስን ጌሻትꬃራ የሳደስ ምንጎተ፤ ጌሻትꬅ ባይዝን ኦደን ላꬂ በአደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","ይንታፓ ኦደስን ጾዘ አꬎ ከሃትꬅታ ፋጫመ ፋና፥ ማህ ጫሞ ኣፈ ኣፍዘ ጻጶ ዶሊ ጋማ አስ ቱንዘን ꬋብስዘ ቡዱꬅ ፋና ማቃመ ጋር ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","ይን ግዳ ኦላልዘ አስ ዎይ ፈቲ ቶሄ ሙእዘ ካꬃስ ፋ አንግስትሞ ለቂ ባይዝደ ኤሳዎ ፋና አስ የዛመ ጋር ናግንቶተ። ");
INSERT INTO oyde_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","ሱባፓ ኤሳዎ ይና አንጅቶ ኤኮደስ ኮይዘ ዎደ ካይዳኖ ኤራነ። ኤ ይና አንጅቶ አፉꬃራ ሚንግ ኮይኮን፥ ደንጎደስ ዳንዳእካያ፤ ኤ ናጋራፓ ማቃደስ እጻ ደንግካያ። ");
INSERT INTO oyde_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","ይን ኩሽተ ቦችንትዘ ሲና ደረጎ፥ ኤጽዘ ታማጎ፥ ꬉማጎ፥ ቃይቃዮጎን፥ ጎተጎ፥ ");
INSERT INTO oyde_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","ሞይዘ ኦለ ዎይ ቃላ ስንትዘ በሳጎ ይእካያ። ይና ቃልቶ ስእደ አሱንꬅ መለ ጉጃ ቃላ ስአመ ፋና ዎስዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","አኮስ ጋይኮ፥ «መለ አቶ የዝን፥ ጾꬂ የ ደርዛ ቦችኮ፥ ሹቻራ ꬎግንቲ Ꮉይቆ» ያጋእ ኪታ ኡን ቶኮደስ ዳንዳእካያ። ");
INSERT INTO oyde_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","ይና Ꮉንዘ ባዝታ ጋማ ዳጋንꬅዘ ባዝ ማቅደ ግሾ ሙሴ፥ «ታኒ ዣሽሞራ ጎቅዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","የዝን ይን ጽዮነ ደርዘጎ፥ ደኦ ጾዚ የዘ የሩሳላመ ካታማ፥ ፈትላ ሺቂ ኡፋይትዘ ጋማ ሙኩል ኪታንቹንꬃጎ ሳሎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","ኡን ሱንꬅታ ሳሎ ጻፍንትደ ዎሳ ኬꬅስ አንግስ ናኡንꬃጎ፥ አስ ኡባ ፍርድዘ ጾዛጎ፥ ፎሎ ማቅደ ጽሎ አሱንꬅ አያናጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","ክለ ጫቅትስ ግዳ ማቂ እግንꬅዘ የሱሳጎ፥ አቤላ ሱꬃፓ አꬍዘባዝ ኦህዘ ዉጹርክንትደ ሱꬃጎ ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","ይንትስ ኦህዘ አꬄ ቃልቶ ስኦስ ጋአመ ጋር ናግንቶተ። ዛጉንꬅ ሳአፓ ኦህደ ኪቶ ስአንጽ እጺ አትካይዘባዝ ማቅኮ ዬዝን፥ ሳሎፓ ኦህዘ ቃልቶ ኑኒ ኮዮስ ጋይኮ ዋይዝ አቶደ? ");
INSERT INTO oyde_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","የ ዎደ ኤ ቃልታ ሳአ ኤንእዝዳ። የዝን Ꮉተ ታኒ፥ «ሳአ ጻላላ ማቅካይዝን ፈቲ ቶሄ ማህ ሳሎ ኤንእሳዳ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","«ፈቲ ቶሄ ማህ» ጋዘ ቃልታ ኤንእንቶሰባዝ ሚንግ የሳደ ጋር ኤንእንትዘ መꬍንትደ ባዝታ ꬋቦዳኖ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","ኑኒ ኤንኦደስ ዳንዳኦሰ ካእቱሞ ኤክዘ ግሾ ጾዛ ጋላታነ፤ ጾዛ ኡፋይስዘ ኦገራ ቦንቾራን ዣሽሞራን ኤዛ ጎይኖዳ። ");
INSERT INTO oyde_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","ይኬ፥ ኑ ጾዘ ቱርፕ ምችዘ ታማ። ");
INSERT INTO oyde_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","አማንዘ አስ ፋና ፈታይ ፈተራ ፎሎ ሲቅንቶተ። ");
INSERT INTO oyde_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","ዛቆ ሞክዛኖ ቦትፈተ። ፈቲ ፈቲ አሱንꬅ ይኒ ጋራ ኦችተራ ኤርካይዛራ ኪታንቹንꬃና ሞክዳ። ");
INSERT INTO oyde_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","አቻ የዙንꬃና ይንትን ኡንታራ ዎላ አቻ የዘፋና ማህ ኡንታና ቆፖተ። ማꬋ ኤክዘ አሱንꬃራ ዎላ ይንትን ማꬋ ኤክዘፋና ማህ ኡንታና ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","ማቾ ኤከን ገለን አስ ኡባ ካለ ቦንችንትደባዝ ማቀ። ማህ ጾዚ ኦላለ Ꮉንትዙንꬃናን ላምዙንꬃና ፍርዶደስ የዘ ግሾ አዝንዘን ማችታ ፈታይ ፈተስ አማንንቶደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","ብራ ሲቆፓ ይንታና ናጎተ፤ ይንትስ የዛና ማቃዳ። ጾዚ፥ «ታኒ ነና ሙሎራን ኦሎስ ዎይ አሾስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","ይኒ ግሾ፥ ኑኒ አማንንቲ፥ «ላꬂ ታና ማድዛያ፤ ዣሽቶስ፤ አስ ታና አኮ ይሳደ?» ጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","ጾዘ ቃላ ቲኖ ይንትስ ኦህደ ይንታና ካልꬅዙንꬃና ቆፖተ። ኡን ዋይዝ የዘዛኮ ኡን የስቶ ብእ ኡን አማንቶ ካሎተ። ");
INSERT INTO oyde_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","የሱስ ክርስቶሳ ኦማን Ꮉይኖን መꬍናስ ላምንቶስ። ");
INSERT INTO oyde_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","ዱማ ዱማ ክለ ትምርተራ መለ በሳ ቅቲ ꬋብፐተ፤ ቅትፐተ። ኑ ዎዙንታ ጾዘ አꬎ ኬሃትꬅተ ምንጎደስ ቤዛነ ፋትን ሙእን ማዶሰ ካꬃራን ዎጋ ፎለራ ማቅፈ። ");
INSERT INTO oyde_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","ኑስ ዣርሾ በሲ የነ። የዝን ዱንካነ ግዳ ኦችዘ ካህኑንꬅ ይና ዣርሾ ካꬅትፋ ማአደስ ኡንትስ አደትꬅ ዎልቃ ባያ። ");
INSERT INTO oyde_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","ካህኑንꬅ Ꮉላቅዘ ናጋራ ዣርሾስ Ꮉርስ ሱꬅ ኤኪ ዣርሾደስ ኡባፓ ጌሽ በሳ ገላነ። የዝን የ Ꮉርስዘ አሽቶ ጋሰፓ ባለ ምቻነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","ይኒ ፋና፥ የሱሳ አሱንꬃና ናጋራፓ ፋ ሱꬅተ ጌሾደስ ካታማ ፉርꬃፋ ባለራ ዋይንትዳ። ");
INSERT INTO oyde_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","ይኬ፥ ኑኒ ኤ ቦርቶ ቶኪ ጋሰፓ ባለ ኤጎ የꬎተ። ");
INSERT INTO oyde_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","ይኬ፥ ኑስ Ꮉነ መꬍናስ የዘ ካታማ ባያ፥ የዝን ኑኒ የኦደ ካታምቶ ናጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","ይኬ፥ የሱሳ ባጋራ ኡባ ዎደ ኤ ሱንꬅትስ ማርክꬍዘ ዶና ጋላታ ዣርሾ ጾዝስ እንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","ሎኦ ባዝ ኦቼን ይንትስ የዘ ባዛፓ መለ አስስ እንገ ቦትፈተ። ይኬ፥ ይኒ ፋና የዘ ዣርሾ ጾዝ ኡፋይሳነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","ይንታና ካልꬅዙንꬅስ ኪትንቶተ፤ ኡን ጋዘባዝ ኦቾተ። ኡን ፋ ኦችዘ ባዝትስ ጾዘ ቲኖ ኦጭንቶደስ የዘ ግሾ ይንታና የንጋነ። ይን ኡንትስ ኪትንትኮ፥ ፋ ኦችቶ ኡፋይት ኦቾዳ፤ ይና Ꮉናንጽኮ፥ ኡን አዛኖራ ኦቾዳ፤ ይና ይንታና አኮ ባዝን ማዶስ። ");
INSERT INTO oyde_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","ኑስ ጾዝ ዎሶተ። ኑ ዎዝንታ ጌሽ፤ ኑ ኡባ ዎደ ሎኦ ባዝ ኦቾደስ ኮያነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","ታኒ ይንታጎ ኤልሲ የኦደ ፋና ይን ታስ ምንꬂ ጾዝ ዎሶደ ፋና ታ ይንታና Ꮉዳራ ጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","ሳሮትꬅ ጾዘ፥ ዱሮ የንግዘ ኑ ላꬄ የሱሳ፥ ፋ መዽና ጫቆ ሱꬅተ Ꮉይቆፓ ደንꬅዳይ፥ ");
INSERT INTO oyde_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","ኤ ቆፍቶ ኦቾደ ፋና ሎኦ ባዝ ኡባነ ኤ ይንታና ዳንጭዞ። ኤዛ ኡፋይስዘ ባዝ የሱስ ክርስቶሳ ባጋራ ኑ ግዳ ጾዚ ኦቾ። የሱስ ክርስቶሳ ባጋራ ጾዝስ መꬍናፓ መዽና የሎደስ ቦንቾ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","ታ እሹንꬆ፥ ታ Ꮉይ ጻፍደ ኪትዛ ይንትስ Ꮉታራ ጻፍደ ግሾ ይን ታ ዞርቶ አዛልእካይዛራ ኤኮደ ፋና ታ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","ኑ እሸ፥ ጢሞትዮሳ አቻፓ ብልንትዳኖ ኤሮተ። ኤ ኤልሲ ታጎ ይእኮ ታ ኤራ ይንታና Ꮉንግ በአዳ። ");
INSERT INTO oyde_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","ይንታና ካልꬅዙንꬃናን አማንዙንꬃና ኡባ ሳሮ ጋኦተ። ጻለፓ ይእደ አማንዘ አሱንꬅ ይንታና ሳሮ ያጋነ። ");
INSERT INTO oyde_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","ጾዘ አꬎ ከሃትꬅታ ይን ኡቡንꬃራ ማቀ። አምንኤ። ");
INSERT INTO oyde_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","ጾዘን ላꬄ የሱስ ክርስቶሳ አሮ፥ ያይቆባ፥ ሳአ ኡባ ላልንትደ ታጶ ላምእ ኮቹንꬅስ ኪትደ ኪታ። ሳሮ ይንትስ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","ታ እሹንꬆ፥ ይንታና ዱማ ዱማ ፋታና የልዘ ዎደ ይን ሎኦ ባዝ ደንግደ ፋና ኩሙꬅ ኡፋይሳራ ኤኮተ። ");
INSERT INTO oyde_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","ይን አማንቶ ፋታንዛና ዳንዳአ ይንትስ እንግዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","ይን ዉርሱꬅ የሎደስ ዳንዳእኮ አኮ ፋጨ ባይዝን ፎሎን ኩሙꬅ ማቃደ ፋና ኦችዛ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","ይንታፓ ኦደስን ጭንጫትꬅ ꬋብኮ ጾዝ ዎሶ። ኤስ እንግንቶዳ። ጾዚ ኦደን ቦርካይዛራ ኡቡንꬅስ ኬሃትꬃራ እንግዘ ጾዚ። ");
INSERT INTO oyde_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","የዝን ኤ ዎስዘ ዎደ ሶእካይዛራ አማኖራ ጾዝ ዎሶ። ሶእዘ ኦደን ባቆ ኡርቂን ኤንእዘ አባ ጋር። ");
INSERT INTO oyde_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","8","ላምእ ቆፋ የዘን ፋ ኦግተ ኤቆሰ ኦደን ላꬃፓ አኮን ደንጎዳ ጋእ ቆፕፐ። ");
INSERT INTO oyde_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","አማንዘ ዳሁንꬅ፥ ጾዚ ኡንታና ꬎቅ ኦችዘ ዎደ ኡፋይቶ። ");
INSERT INTO oyde_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","ማህ አማንዘ ዱሩንꬅ ጾዚ ኡንታና ዝቂ ኦችዘ ዎደ ኡፋይቶ። ዱረ አሱንꬅ ፉ ፋና ꬋቦዳ። ");
INSERT INTO oyde_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","አዋ ፋ ምሻራ ከዛነ ማቶ መልዛነ፥ ፉꬍታን ጉፋነ፤ ኤ ሎኦትꬅታን ꬋባነ። ይኒ ፋና፥ ዱረ አሱንꬅ ፋ ኦችተ ጨር ላልተራ ꬋቦዳ። ");
INSERT INTO oyde_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","ማꬋ ጋሚ ኣꬍዳንፕ ሱባ፥ ጾዚ ፋና ሲቅዙንꬅስ እንጎዳ ጋእ ቃላ ገልደ ደኦ ዎርቃ ዛዉደ ኤኮደ ግሾ ማꬍተ ገንጭዘ አስ አንጅንትዳያ። ");
INSERT INTO oyde_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","ኦደን ፋታንንትዘ ዎደ «ታና ጾዚ ፋታናነ» ጋይፐ። ጾዚ ኢታራ ፋታኖስ፤ ማህ ኤ ኦደን ፋታኖስ። ");
INSERT INTO oyde_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","የዝን ፈቲ ፈቲ አስ ፋ ኢታ አሞራ ጎችንትዘ ዎደን ጭምንትዘ ዎደ ፋታንንታነ። ");
INSERT INTO oyde_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","ይንፓ ሱባ፥ አሞትꬅ ዎዳጺ ናጋራ የላነ፤ ማህ ናጋራ ድጪ Ꮉይቆ የላነ። ");
INSERT INTO oyde_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","ታ ሲቆ እሹንꬆ፥ ጭምንትፐተ። ");
INSERT INTO oyde_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","ሎኦ እሞን ኩሙꬅ አንጆ ኡባ ሳሎፓን ሳሎ ፎእቶ መꬍደ ጾዘ አደፓ የእነ። ጾዚ ዳሾ ፋና ኡባ ዎደ ላምንቶስ። ");
INSERT INTO oyde_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","ኑኒ፥ ኤ መꬍደ ባዝስ አንግስ ማቃደ ፋና ኑና ቱሪ ቃላራ ቆፒ የልዳ። ");
INSERT INTO oyde_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","ታ ሲቆ እሹንꬆ፥ Ꮉኖ ቆፖተ። አስ ኡባ ስኦደስ ኤልሶ፥ የዝን ኦሆደስን Ꮉንቆደስ ኤልስፐ። ");
INSERT INTO oyde_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","አስ Ꮉንቆ ጾዘ ኮይዘ ጽሎትꬅ ኮኦስ። ");
INSERT INTO oyde_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","ይኒ ግሾ፥ ቱና ኦቻን ኢታ ባዝ ኡባ Ꮉሲ፥ ጾዚ ይን ዎዝንተ ቱክደ ይን ሸምፕቶ አሾደስ ዳንዳእዘ ቃላ አዳትꬃራ ኤኮተ። ");
INSERT INTO oyde_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","የዝን ጾዘ ቃላ ኦቻላ ፌሾተፕ አትን ይን ኦምተ ባልንትተራ ስእዙንꬃና ጻላላ ማቅፈተ። ");
INSERT INTO oyde_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","ቃላ ስእ ኦቾሰ አስ፥ ኤ ፋ ስንቶ ማስቶተራ በእዘ አꬄ ፋና። ");
INSERT INTO oyde_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","ኤ ፋ ስንቶ ብእ ቅታነ፥ የዝን ኤ አኮ አዝዛኮ ኤልሲ ቦታነ። ");
INSERT INTO oyde_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","የዝን ኦደን ናጋራ አሮትꬃፓ ኬስዘ ፎሎ ህገ ቆፒ ብእ፥ ሚንግ ኤቅዘ፥ ስእዳኖ ቦትካይዛራ ኦቻላ ፌሽዘ አꬃይ፥ ፋ ኦቻ ኡባነ አንጅንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","ፋ እልአንꬅቶ ናግካይዛራ ጎይናነ ጋዘ አꬃይ ፋና ጭማነ፤ ኤ ጎይንታ Ꮉሪ። ");
INSERT INTO oyde_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","ጾዘ አዳይ ቲኖ ቦረ ባይዘ ጌሽ ጎይኖ Ꮉኖ፦ እንዳን አደን ባይዘ ናኡንꬃናን አዝኒ ባይዙꬃና ኡን ማꬍተ ማደን አላመ ቱናፓ ፋና ናገ። ");
INSERT INTO oyde_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","ታ እሹንꬆ፥ ይን ኑ ቦንቾ ላꬄ የሱስ ክርስቶሳ አማንዘባዝ ማቅኮ፥ አስ ስኖ ብእ አስ ቦንችፐተ። ");
INSERT INTO oyde_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","አዝዘስ፥ ዎርቃ ምግዶ አꬂ፥ ሎኦ ማኦ ማእደ ዱረ አስ ይን ሺቅተ ይእዳ። ማህ ጩርቃ ማኦ ማእደ ዳሃ አስን ይእዳ። ");
INSERT INTO oyde_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","ሎኦ ማኦ ማእደ አꬃ ይን አꬂ ቦንቺ፥ «ነ Ꮉነ ሎእዘ ኦይዳላ በቶ» ጋእ፥ ማህ ዳሃ አꬃ፥ «ነ የይጋ ኤቆ ዎይ Ꮉነ ታ ቶህት ካለ ሳእተ በቶ» ጋነ። ");
INSERT INTO oyde_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","ዬዝን፥ ይን፥ ይን ግዳ ሻኮ መꬍዙንꬃና ኢታ ቆፋራ የዘ ዳይኑንꬅ ፋና ባነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","ታ ሲቆ እሹንꬆ፥ ስኦተ። አማኖራ ዱረ ማቃደ ፋናን ፋና ሲቅዙንꬅስ እንጎዳ ጋይደ ሳሎ ካእቱሞ ላቶደ ጋር Ꮉና ሳእተ የዘ ዳሁንꬃና ጾዚ ዶርካነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","የዝን ይን ዳሁንꬃና ቶቻነ። ይንታና ኡንእꬅዙንꬅን ፍርዳ ኬꬃ ጎችዙንꬅ ዱሩንꬃና ባነ? ይንታና ዳይና ቲኖ ጎችዙንꬅ ኡንታና ባነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","ይን ጼግንትዘ ይና ሎኦ ሱንꬅቶ ጫዥዙንꬅ ኡንታና ባነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","የዝን ጌሽ ማጻፍተ፥ «አስ ኡባ ነና ነ ካꬍዛን ጋራ ካꬎ» ጋእንት ጻፍንትደ ጾዘ ካእቱሞ ህግቶ ይን ፎልኮ ሎኦ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","የዝን ይን አስ ስኖ ብእ ቦንችኮ፥ ናጋራ ኦቻነ፤ ማህ ህገን ይንታና ህገ መንꬅደ አስ ፋና ፍርዶዳ። ");
INSERT INTO oyde_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","ኦደን ጾዘ ህገ ኡባፓ ፈታ መንꬂ፥ አትዳኖ ኡባ ናግኮ ኡባኖ መንꬅደ ፋና ፋይድንታነ። ");
INSERT INTO oyde_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","«ላምፐ» ጋይደ ላꬄ፥ ማህ «ዎꬍፐ» ጋይዳ። የዝን ነ ላማንጽ አሺ ዎꬍደ ባዝ ማቅኮ፥ ህገ መንꬅዳ። ");
INSERT INTO oyde_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","አሮትꬃፓ ኬስዘ ህገ ቲኖ ፍርዳ ኤኮደስ የዘ አስ ፋና ኦህንቶተን ኦቾተ። ");
INSERT INTO oyde_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","አስ ማሮሳ ኦናን ጾዚ ማርካይዛራ ፍርዶዳ። የዝን ማሮትꬅ ፍርዳ ጋማነ። ");
INSERT INTO oyde_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","ታ እሹንꬆ፥ ይንታፓ ፈቲ አስ ታስ አማኖ የነ ጋእ፥ ፋ አማንቶ ኦቻራ ቤዛንጽኮ ኤዛ አኮ ማዶደ? ኤ አማንታ ኤዛ አሾደስ ዳንዳአነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","አዝዘስ ፈቲ እሻይ ዎይ ፈቲ ምሽታ ካልꬍኮን ኡንትስ ሙእዘባዝ ꬋብኮ፥ ");
INSERT INTO oyde_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","ይንታፓ ፈቲ አስ ኡንታጎ፥ «ሳሮ ቅቶተ! ይንታና ታማ ካዦተ! ምዦተ!» ጋእ፥ ኮሽዘ ባዝ ኡንትስ እንጋንጽኮ ኡንታና አኮ ማደ? ");
INSERT INTO oyde_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","ይኒ ግሾ፥ ኦቻ ባይዘ አማኖ ፋ ኦምተ Ꮉይቂዳያ። ");
INSERT INTO oyde_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","የዝን ፈቲ አስ፥ «ኔስ አማኖ የነ፤ ማህ ታስ ኦቻ የነ። ኔኒ ነ አማንቶ ነ ኦችትፓ ሻጊ ታና ቤዞ፤ ታንን ታ አማንቶ ታ ኦችተ ነና ቤሳዳ» ጋዉዳ። ");
INSERT INTO oyde_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","ኔኒ፥ ፈቲ ጾዚ የዛኖ አማናነ፤ ይና ሎኦ። ቱና አያኑንꬅን አማናነ፤ ዣሽሞራ ጎቃነ። ");
INSERT INTO oyde_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","ናተ ቦዛዮ! አማኖ ኦቻፓ ሻክንት ማዶሳኖ ኤሮደስ ኮያነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","ኑ አዳይ አብራሃማ፥ ፋ ናአ ይሳቃ ዣርሾ በሳላ ጋድደ ዎደ ፋ ኦችትራ ጽልካነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","ኤ አማንታን ኤ ኦችታ ዎላ ትምንትዳኖ ቦኦሳ? ኤ አማንታ ኤ ኦችተ ፎልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","ጌሽ ማጻፍታ፥ «አብራሃማ ጾዝ አማንዳ። ጾዚ ይኖ ኤስ ጽሎትꬅ ማህ ፋይድዳ» ጋይዳና ፎልንትዳ። ማህ ኤ ጾዘ እግና ጋእንት ጼግንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","አስ አማኖ ጻላላራ ማቅካይዝን ኦቻራ ጽልዛኖ በእነ። ");
INSERT INTO oyde_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","ይኒ ፋና፥ ኦላለ Ꮉንትዘ ረአባ እስራኤለፓ ኪትንትዱንꬃና ሞኪ መለ ኦገራ ኡንታና ሞይዝደ ዎደ ፋ ኦችተ ጽልካነ? ");
INSERT INTO oyde_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","ሸምፖ ሻክንትደ አሾ Ꮉይቆ ማቅዛንፋና፥ ኦቻ ሻክንትደ አማኖን Ꮉይቆ። ");
INSERT INTO oyde_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","ታ እሹንꬆ፥ ይንታፓ ጋሙንꬅ አስታማረ ማቅፈ። ኑ፥ አስታማሩንꬅ መሉንꬃፓ አꬍዘ ፍርዳ ኤኮዳኖ ይን ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","ኑ ኡባና ጋማ ባዛራ ባልንታነ። ፋ ኦህተ ባልንቶሰ ኦደን ፋናትꬅቶ ናጎደስ ዳንዳእዘ ፎሎ አስ። ");
INSERT INTO oyde_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","ፋራዚ ኑስ ኪትንቶደ ፋና ሉጋመ ባርሲ ኑ ኮይዘ በሳ ኡባ ካንታነ። ");
INSERT INTO oyde_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","ማርካበ አኮ ፋና ዳማ ማቂ ዳማ ባቆራ ኡርቂንትኮን፥ ኤዛ እዥዘ አꬄ ፋ ኮይዘ ዛላ ማህ ኤራꬅ እዥዘ ባዛራ እዢ ቅታነ። ");
INSERT INTO oyde_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","ይኒ ፋና እልአንꬂ ጋላ ግዳፓ ኤራꬅ ማቅኮን ጋማ ዳማ ባዛ ጬቅንታነ። ኤራꬅ ታማ ዳማ ጉርደ ምቻነ። ");
INSERT INTO oyde_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","እልአንꬂ ታማ ፋና። እልአንꬂ ኑ አሽቲ ግዳ ኢታራ ኩምደ አላመ፤ ጋላ ኡባ ቱንዛነ። ጋናመፓ ከዝዘ ታማ ጋር ኑ ደኦ የስቶ ኡባ ምቻነ። ፋ ኦምትስን ጋናመ ምችንቶዳ። ");
INSERT INTO oyde_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","ጾꬅን ላንዳን፥ ሳዛር ጎቹንትዙንꬅን አባ የዘ መꬍንትደ ባዝ ኡባ አስ Ꮉራነ፤ ኡንትን Ꮉርንታነ። ");
INSERT INTO oyde_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","የዝን ኦደን እልአንꬅ Ꮉሮደስ ዳንዳእካያ። እልአንꬂ ዎꬍዘ ማርዘ ኩምደ አቆሰ ኢታ መꬎ። ");
INSERT INTO oyde_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","ኑ እልአንꬅተ፥ ኑ፥ ላꬅን አደ ማቅደ ኑ ጾዛ ጋላታነ። ማህ እራ ጾዝ አዚ መꬍንትደ አስ ባዳነ። ");
INSERT INTO oyde_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","ፈቲ ዶናፓ ጋላታን ባድꬅን ከዛነ። ታ እሹንꬆ፥ ይኒ ጋራ ይአደስ ቤዞስ። ");
INSERT INTO oyde_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Ꮉꬅ ኣፈ ፈቲ ዶቻፓ ማልእዘ Ꮉꬅን ጫንግዘ Ꮉꬂ ከሳደስ ዳንዳአነ? ");
INSERT INTO oyde_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","ታ እሹንꬆ፥ በለሰ ምንጻፓ ሻማሄ አፎደስ ዳንዳአነ? ዎይ ዎይነ ምንጻ በለሰ ምንጻ ኣፈ አፎደስ ዳንዳአነ? ጫሞ Ꮉꬅ ኣፈፓ ማልኦ Ꮉꬅ ኬሳደስ ዳንዳኦስ። ");
INSERT INTO oyde_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","ይን ግዳ ጭንጫን አካክዘ ኦደ? ፋ ሎኦ የስቶ፥ አሽከትꬃራን ጭንጫትꬃራን የዚ ቤዞ። ");
INSERT INTO oyde_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","የዝን ይን ዎዝንተ ጫሞ ቃናተን ፋና ካꬍዘባዝ የዝኮ ይና ጭንጫትꬅተ ጬቅንትፐተ፤ ቱርላ አፋ ዎርድꬍፐተ። ");
INSERT INTO oyde_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","ይኒ ጋርዘ ጭንጫትꬅ ሳሎፓ ይእደባዝ ማቅካይዝን ይና አሳፓ፥ አላመፓ፥ ጻላሄፓ። ");
INSERT INTO oyde_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","ቃናተን ፋና ካꬍዘባዝ የዘ በሳ ካችን ኢታ ኦቻ ኡባ የነ። ");
INSERT INTO oyde_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","የዝን ሳሎፓ የእዘ ጭንጫትꬅ ኡባፓ ቲኖ ጌሽ። ማህ ሳሮትꬅ፥ ሎኦትꬅ፥ ኪትንተ፥ አስ ማረ፥ ሎኦ ኣፈ ኩምዳያ፥ አስ ሻጎሳን ጩቦትꬅ ባይዛያ። ");
INSERT INTO oyde_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","ሳሮትꬅ ካꬍዙንꬅ ሳሮትꬅ ቡድ ጽሎትꬅ ኣፈ ማጻነ። ");
INSERT INTO oyde_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","ኦላን ካች ይን ግዳ አባፓ የኤ? ኡን የእዛና ይን አሽቶ Ꮉሮደስ ኦልንትዘ ይን አሾ አሞፓ ባነ? ");
INSERT INTO oyde_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","ይን አሙꬋነ፥ የዝን ደንጎስ፤ ይኒ ግሾ፥ አስ ዎꬋነ። ምንꬂ ኮያነ፥ የዝን ደንጎደስ ዳንዳኦስ፤ ይኒ ግሾ፥ ካጭንታነን ኦልንታነ። ይን ጾዝ ዎሶሰ ግሾ ኮይዘ ባዝ ደንጎስ። ");
INSERT INTO oyde_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","ይን ዎሳነ፥ የዝን ደንጎስ። ይን አሾ አሙቶ ፎሎደስ ዎቦ ኦገ ዎስዘ ግሾ ደንጎስ። ");
INSERT INTO oyde_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","ይን፥ አማንንቶሱንꬆ! Ꮉና አላምቶ ካዽዘ ጾዛራ ሞርከ ማቅዛኖ ኤሮሳ? Ꮉና አላምትራ እግንꬆደስ ኮይዘ ኦደን ጾዛራ ሞርከ። ");
INSERT INTO oyde_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","ጌሽ ማጻፍተ፥ «ጾዚ ኑ ግዳ የሳደ ፋና ጋድደ አያንዘ፥ ኑ ኤስ ቡዞ ማቃደ ፋና ዳማ አሙꬋነ» ጋይዳና ጨር ጋይደባዝ አዛነ? ");
INSERT INTO oyde_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","የዝን ጌሽ ማጻፍተ፥ «ጾዚ ኡቱርትዙንꬃና እጻነ፥ የዝን ፋና ቶችዙንꬅስ አꬎ ኬሃትꬅ እንጋነ» ያጋዘ ግሾ ጾዚ አꬎ ኬሃትꬅ ጋንꬂ እንጋነ። ");
INSERT INTO oyde_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","ይኒ ግሾ፥ ጾዝስ አቆተ፤ ጻላሄራ እጽንቶተ፤ ኤ ይንታፓ Ꮉኮዳ። ");
INSERT INTO oyde_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","ጾዛጎ ሺቆተ፤ ኤ ይንታጎ ሺቆዳ። ይን፥ ናጋራንቹንꬆ፥ ይን ኩሽቶ ሜጮተ፤ ላምእ ቆፋ የዙንꬆ፥ ይን ዎዝንቶ ጌሾተ። ");
INSERT INTO oyde_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","አዛኖተ፥ ዬኮተን አፉጾተ። ይን ሚችታ ዬፎራ፥ ይን ኡፋይስታ አዛኖራ ላምንቶ። ");
INSERT INTO oyde_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","ላꬄ ቲኖ ይንታናትꬅቶ ዝቂ ዪዞተ፤ ኤ ይንታና ꬎቅ ꬎቅ ዪሳዳ። ");
INSERT INTO oyde_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","ታ እሹንꬆ፥ ፈታይ ፈታያ ጫዥፐን ዝግርፐተ። ፋ እሻ ዝግርዛይ ኤላ አፋ ፍርድዘ ህገ ዝግራነን ህገላ አፋ ፍርዳነ። ነ ህገላ አፋ ፍርድኮ ህገላ አፋ ፍርድዛያ ማቃነፕ አትን ህገ ፎልዛያ ማቆስ። ");
INSERT INTO oyde_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","ህገ እንግዘን ፍርድዘ ጾዛ ጻላላ። አሾደስን ꬋብሶደስ ዳንዳእዘ ኤዛ። ዬዝን፥ አሳላ አፋ ፍርድዛይ ነ ኦደ? ");
INSERT INTO oyde_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","ይን፥ «ኑ Ꮉይኖ ዎይ ዎንታ ሰኮ ካታማ ዎይ Ꮉንኮ ካታማ ቅቶዳ፤ እዘ ፈቲ በረ ጋምኦዳ፤ ዛልእ ትርፍሳዳ» ያጋእዙንꬆ፥ ስኦተ። ");
INSERT INTO oyde_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","ዎንታ አኮ Ꮉኖድ የዛኮ ይን ኤሮስ። ይን ደእታ ዋያድ የዛኮ ኤርዘ ኦደ? ይን ኤራꬅ ዎደ በንቲ ꬋብዘ ቃይቃዮ ፋና። ");
INSERT INTO oyde_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","ይኖ አሺ፥ «ላꬂ ጋይኮ ኑኒ የሳዳ፤ Ꮉኖ ዎይ ይኖ ኦቾዳ» ጋዉደስ ቤዛነ። ");
INSERT INTO oyde_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","የዝን ይን Ꮉተ ኡቱራነን ጬቅንታነ። ይኒ ጋርዘ ጬቆ ኡባ ኢታ። ");
INSERT INTO oyde_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","ይኒ ግሾ፥ ሎኦ ባዝ ኦቾደስ ኤሪተ ኦቾሰ አꬄስ ይና ናጋራ። ");
INSERT INTO oyde_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","ይን፥ ዱሩንꬆ፥ ይንታላ አፋ ኢታ ማꬋ የእዘ ግሾ ኡኮተን ዬኮተን። ");
INSERT INTO oyde_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","ይን ቆልታ ቡቂዳ፤ ይን አፉልታን ብላራ ሙእንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","ይን ዎርቅታን ይን ብርታ ብርዳ። ይና ብርዳና ይንታላ አፋ ማርካ ማቃዳ። ኤ ይን አሽቶ ታማ ጋር ምቾዳ። ይን Ꮉና Ꮉልእደ ቃምተ ይንትስ ቆሎ ሺሽዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","ይን ጋድተ ኦቺ ፌዥደ አሱንꬅ ክራ ብርቶ ጭግካያ። ይና ይንታላ አፋ ኡካነ። የንꬅ ካꬃ ማጽዘ አሱንꬅ ኡክትታ ዎልቃራ የዘ ላꬄ Ꮉይተ ስንትዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Ꮉና ሳእተ ይን ሳዛ ጻላላስ ቆፒ፥ ጊግን የዝዳ። ሹፎስ ጊግንትደ Ꮉርስፋና ይንታና ꬊክዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","ይንታራ ኤቅንቶደስ ዳንዳኦሰ ጽሎ አሳላ አፋ ፍርዳነ፤ ኤዛን ዎꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","ታ እሹንꬆ፥ ላꬂ ዮኦደ ዎንꬅስ ገንጮተ። ሳአ ኦችዘ ቶርቼ እራን ሴተ እራ ዮኦደ ዎንꬅስ ገንጭ አልኦ ካꬃ ናጊ ዋይዝ የልꬅ ኤክዛኮ ቆፖተ። ");
INSERT INTO oyde_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","የ ሳአ ኦችዛይ ፋና ይንትን ገንጮተ። ላꬄ የእታ ኡክደ ግሾ ኡፋይሳራ ናጎተ። ");
INSERT INTO oyde_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","ታ እሹንꬆ፥ ጾዚ ይንታላ አፋ ፍርዳመ ጋር ፈታይ ፈተላ አፋ ዙዝንግፐተ። ፍርድዛይ ፉርꬃ ኤቅዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","ታ እሹንꬆ፥ ላꬄ ሱንꬅተ ኦህደ ናቡንꬅ ማꬋ ዳንዳአራ ኤኪ አዝዘ ማቅዱንꬃና ቦኦተ። ");
INSERT INTO oyde_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","ዳንዳአራ ገንጭዱንꬃና ኑኒ አንጅንትዱንꬃና ጋነ። እዮባ ዋይዝ ገንጨዛኮ ይን ስእዳ። ላꬂ ዉርሱꬅተ ኤዛ ዋይዝ ማደዛኮን ብእዳ። ኤ ማሮትꬅን ይቅስሞ ኩምደ ላꬂ ማቅደ ግሾ ይኖ ኦችዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","የዝን ኡባፓ ቲኖ፥ ታ እሹንꬆ፥ ሳሎራን ማቅን ዎይ ሳአራን ማቅን ዎይ መለ አኮ ባዛራን ጫቂፐተ። ጾዘ ፍርዳ ይን ገላመ ፋና ይን ኦህታ ዬ ማቅኮ፥ «ዬ» ጋኦተ፤ አደ ማቅኮ፥ «አደ» ጋኦተ። ");
INSERT INTO oyde_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","ይን ግዳ ማꬋ ኤክዘ ኦደን የዝኮ ጾዝ ዎሶ። ኡፋይትዘ ኦደን የዝኮ ጋላታራ የጾ። ");
INSERT INTO oyde_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","ይንታፓ Ꮉርግንትዘ ኦደን የዝኮ ዎሳ ኬꬂ ጭሙንꬃና ጼጎ። ኡን ላꬄ ሱንꬅተ ዛይተ ትዢ ኤስ ጾዝ ዎሶ። ");
INSERT INTO oyde_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","አማኖራ ዎስደ ዎስታ Ꮉርግንትዛ ፋꬆዳ። ላꬂ ኤዛ፥ Ꮉርግትፓ ደንꬆዳ፤ ኤ ናጋራ ኦችደባዝ ማቅኮን ላꬂ ኤዛ ማሮዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","ይኒ ግሾ፥ ይን ፋጾደ ጋር ይን ናጋርቶ ፈታይ ፈተስ ፋጾተን ፈተ ፈተስ ዎሶተ። ጽሎ አስ ዎስታ ዳማን ዎልቃማ ኦቻ ኦቻነ። ");
INSERT INTO oyde_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","ኤልያሳ ኑ ፋና አስ። እራ ሳአላ ቡካመ ጋር ምንꬂ ጾዝ ዎስን Ꮉይꬕ በረን እዝፑን አግና ሳአላ እራ ቡክካያ። ");
INSERT INTO oyde_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","ማህ ኤ ጾዝ ዎስን ሳሎፓ እራ ቡክዳ፤ ሳእታን ካꬃ እንግዳ። ");
INSERT INTO oyde_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","ታ እሹንꬆ፥ ይንታፓ ኦደን ቱሪ ኦገፓ ባልንትኮ፥ መለ አስ ኤዛ ቱርጎ ማህኮ፥ ");
INSERT INTO oyde_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","ናጋራንችዛ ኤ ኢታ ኦግትፓ ማህዘ ኦደን፥ ኤ ሸምፕቶ Ꮉይቆፓ አሽዛያን ኤ ጋማ ናጋርትስ ማሮትꬅ እንግዛኖ ኤሮ። ");
INSERT INTO oyde_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","ታኒ፥ የሱስ ክርስቶሳ ሐዋረ ጴጥሮሳ፤ ጳንጦሰ፥ ጋላትያ፥ ቃጳዶቅያ፥ እስያን ብቲንያ ጋደ ላልንቲ በተ የዘ ጾዚ ዶርደ፥ አሱንꬅስ Ꮉይ ዳብዳቢዛ ጻፍዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","ጾዚ አደ ቲኒ ቆፕደ ባጋራ ዶርንትዱንꬅስ የሱስ ክርስቶሳስ ኪትንቶደስን ኤ ሱꬅተ ዉጹርክንትዱንꬃና ጌሽ አያናራ ጌዥዱንꬅስ፥ አꬎ ኬሃትꬅን ሳሮትꬅ ማቀ። ");
INSERT INTO oyde_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","የሱስ ክርስቶሳ Ꮉይቆፓ ደንꬅደ ባጋራ ፋ ዳማ ማሮትꬅ ክለ የልንተራ ꬋቦሰ ኡፋይስ እንግደ ኑ ላꬄ የሱስ ክርስቶሳ አዳይ፥ ጾዘ ጋላትንቶ። ");
INSERT INTO oyde_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","ማህ ጾዚ ይንትስ ꬋቦሰ፥ ኢቶሰን ቡቆሰ አንጆ ሳሎ ጊግዝዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","ይና አንጅታ ዎደ ዉርሱꬅተ ቆንጮደስ የዘ አቶትꬅትስ ጾዘ ዎልቃራ አማኖራ ይንትስ ናግንቲ የነ። ");
INSERT INTO oyde_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","Ꮉተ ኤራꬅ ዎደ ይን ዱማ ዱማ ፋታና ኡንእንትኮን ይነ ኡፋይቶተ። ");
INSERT INTO oyde_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","ይና ፋታንታ ይንታና የልዳና፥ ታማ ኦልን ꬋብዘ ዎርቃፓ ይን አማንታ አꬎን ቱሮ ማቅዛኖ ቤሳደስ። ይና ፋታንትደ አማንተ የሱስ ክርስቶሳ ላምእንꬃ ቆንጭዘ ዎደ ጋላታ፥ ቦንቾን ናሾ ይን ኤኮዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","ይን የሱሳ ብእካያ፥ የዝን ኤዛ ካꬋነ። ይን Ꮉተ ኤዛ ብእካይዘ ባዝ ማቅኮን፥ ኤዛ አማናነ። ማህ ኦሄራ ቆንጭሳደስ ዳንዳእንቶሰ ኡፋይሳራን ቦንቾራ ኩምዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","ይን አማኖራ ናግዘ ይን ሸምፕት አቶትꬅ ደንጎዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","ጾዛፓ ማቅደ አꬎ ኬሃትꬅ ባጋራ ይንትስ ማቅደ Ꮉና አቶትꬅትባዝ ናቡንꬅ ኤሮደስ ጋማ ቁርቸራ ምንꬂ ኮይዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","ኡን ግዳ የዘ ክርስቶሳ አያና ኤ ዋይት ባዝን ይንፓ ሱባ ዮኦደ ቦንችትባዝ ቲኒ ማርክꬍተራ፥ አይደ ዎይ ዋይዝ Ꮉኖደ የዛኮ ቆፒ ቁርችዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","ናቡንꬅ ኦህደ ትንቢታ ፋ ኦማስ ባይዝን ይንትስ ማቅዳኖ ጾዚ ይንትስ ቆንጭዝዳ። Ꮉተ አሱንꬅ ይንትስ ኦህደ ዎንገለ ሳሎፓ ኪትንትደ ጌሽ አያና ዎልቃራ ይንትስ ኦህዳ። ኪታንቹንꬅን ይኖ በአደስ አሙꬍዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","ይኒ ግሾ፥ ኦቻስ ይንታና ጊግዞተ፤ ይንታና አሆተ። የሱስ ክርስቶሳ ማህ ቆንጭዘ ዎደ ይን ኤኮደ ዳማ አቶትꬅ አꬎ ኬሃትꬅ አንጆ ኡፋይሳራ ካፎተ። ");
INSERT INTO oyde_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","ጾዘ ናኡንꬅ ፋና ኤስ ኪትንቶተ፤ ይን ቲኖ ኤርካይዛራ ኦችደ ኢታ አሞ ካልፐተ። ");
INSERT INTO oyde_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","የዝን ይንታና ጼግደ ጾዘ ጌሽ ማቅዳን ፋና ይንትን ይን የስተ ኡባ ጌሽ ማቆተ። ");
INSERT INTO oyde_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","ጌሽ ማጻፍተ፥ «ታኒ ጌሽ ማቅደ ግሾ ይንትን ጌሽ ማቆተ» ጋእንት ጻፍንትዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","አስስ ስኖ ብእካይዛራ ኤ ኦችት ፋና ፍርድዘ ጾዛ፥ «ኑ አዳዮ» ጋእ ጼግዘባዝ ማቅኮ፥ Ꮉነ ሳአ ዛቆትꬅ የስተ ዣሽሞራ የዞተ። ");
INSERT INTO oyde_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","ይን፥ ይን አዱንꬃፓ ላትደ ፋꬆሰ የሳፓ ዎዝንትደ፥ ꬋብዘ ብራራ ዎይ ዎርቃራ ባይዛኖ ኤራነ። ");
INSERT INTO oyde_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","የዝን ይን ዎዝንትዳና ቦረ ዎይ ሳንከ ባይዘ ጌሽ ዱሮ ሱꬅ ፋና አልኦ ማቅደ ክርስቶሳ ሱꬅተ። ");
INSERT INTO oyde_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","ጾዚ አላመ መꬍንቶዳንፓ ቲኖ ክርስቶሳ ዶርዳ፥ የዝን ይና ዉርሱꬅ ዎድተ ክርስቶሳ ይን ግሾ ቆንጭዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","ይን አማንታን ይን ኡፋይስታ ጾዛራ ማቃደ ፋና ኤዛ Ꮉይቆፓ ደንꬂ፥ ቦንችደ ክርስቶሳ ባጋራ ጾዘ ግዳ አማናነ። ");
INSERT INTO oyde_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","ይን ቱርስ ኪትንትተራ ጩቦ ባይዘ እሽቱሞ ካ ይን ሸምፕተ ምንꬂ ፈታይ ፈታያ ዎዝናፓ ዎል ካꬎተ። ");
INSERT INTO oyde_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","ይን ላምእንꬃ የልንትዳና ꬋብዘ ኮቻፓ ባይዝን መዽና የዘ ጾዘ ቃላ ꬋቦሰ ኮቻፓ የልንትዳ። ");
INSERT INTO oyde_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","ጾዘ ቃላ፥ «አስ ኡባ ማታ ፋና፤ ኤ ቦንችታ ኡባ ፉ ፋና። ማታ መላነ፥ ፉꬍታን ጉፋነ። ");
INSERT INTO oyde_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","የዝን ላꬄ ቃላ መዽና የነ» ያጋይዳ። ይንትስ ኦህንትደ ዎንገለ ቃልታ Ꮉኖ። ");
INSERT INTO oyde_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","ይኬ፥ ኢታትꬅ ኡባ፥ ጭሞ ኡባ፥ ጩቦትꬅ ቅናተን ዝግርስ ኡባ ይንታፓ Ꮉሶተ። ");
INSERT INTO oyde_vpl VALUES ("P12_2","090_2_2","1PE","2","2","3","ላꬂ ዳልጋ ማቅዳኖ ይን ኤርዛን ፋና Ꮉተ የልንትደ ዦጋ ናኡንꬅ ፋና ይን አቶትꬅተ ኤ ግዳ ድጭተራ Ꮉንጎደስ ጾዘ ጌሽ ቃላ ማꬅቶ ኡባ ዎደ አሙꬎተ። ");
INSERT INTO oyde_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","አሳራ ቦርንቲ ጾዛራ ዶርንትደ ቦንቾ ማቅደ ደኦ ሹች፥ ላꬄ የሱሳጎ ሺቆተ። ");
INSERT INTO oyde_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","ይን አያና ኬꬅ ኬጽንትዘ ደኦ ሹቹንꬃና። ይን የሱስ ክርስቶሳ ባጋራ ጾዚ ኡፋይስዘ አያና ዣርሾ ዣርሽዘ ጌሽ ካህኑንꬃና። ");
INSERT INTO oyde_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","ጌሽ ማጻፍተ፥ «Ꮉይቼ፥ ታኒ ጽዮነ ካታማ፥ ዶርንትደ፥ ቦንቾ ማይዘነ ሹች ጋድዳ፤ ኤዛ አማንዘ ሞሎን ዬልꬎስ» ያጋይዳ። ");
INSERT INTO oyde_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","Ꮉይ ሹችዘ ይንትስ አማንዙንꬅስ ቦንቾ፥ የዝን አማኖሱንꬅስ፥ «ኬጽዙንꬅ ቦሪ አሽደ ሹችዘ ኡባፓ አꬍዘ ማይዘነስ ኦማ ሹች ማቅዳ።» ");
INSERT INTO oyde_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","ማህን፥ ጌሽ ማጻፍተ፥ «Ꮉይ ሹችዘ አስ ꬉቢዘ ሹችን አስ ጎልእዘ ላላ» ያጋይዳ። ኡን ይንስ ጋእንትደ ግሾ ጾዘ ቃላስ ኪትንታንጽ ꬉቡንታነ። ");
INSERT INTO oyde_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","የዝን ጾዚ ꬉማፓ ጋማ ቆፍዘ ፋ ፎኦጎ ይንታና ጼግደ፥ ይን ኤ ሎኦትꬅቶ መሉንꬅስ ኦሆደስ ዶርንትደ ኮች፥ ካት ካህነን፥ ጌሽ ዎርዣን ጾዝስ ዱማ ዎርዣ። ");
INSERT INTO oyde_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","ይን ዛጋ ጾዘ ዎርዣ ባያ፥ የዝን Ꮉተ ይን ኤ ዎርዣ። ይን ዛጋ ማሮትꬅ ደንግካያ፥ የዝን Ꮉተ ማሮትꬅ ደንግዳ። ");
INSERT INTO oyde_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","ታ እሹንꬆ፥ ይን Ꮉነ ሳእተ ዛቆን በተ ማቅዳን ፋና ይን አያና ደእቶ ኦልዘ አሾ አሞፓ Ꮉኮደ ፋና ታኒ ይንታና ዎሳነ። ");
INSERT INTO oyde_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","አማኖሰ አሱንꬅ ይንታና ኢታ ኦችዘ አስ ፋና ዝግርዘ ዎደ ጾዚ ኑና በአደስ የእዘ ቃማ፥ ኡን ይን ሎኦ ኦችቶ ብእ ጾዝ ጋላቶደ ፋና ይንትስ ሎኦ የስ የዞ። ");
INSERT INTO oyde_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","ላꬄ ግሾ ጋእ አህዘ አሱንꬅስ አቆተ፤ ኡባፓ ካታራ ማቅደ ግሾ ካትስን አቆተ። ");
INSERT INTO oyde_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","ኡን ኢታ ኦችዙንꬃና ሴሮደስን ሎኦ ኦችዙንꬃና ናሾደስ ካትዘፓ ኪትንትደ ግሾ ዎርዥቶ አህዙንꬅስ አቆተ። ");
INSERT INTO oyde_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","ይን ሎኦ ኦችተራ ኤሮሰ ቦዛ አሱንꬅ ኦህቶ ስእ ዪዝዘ ጾዘ ቆፋ። ");
INSERT INTO oyde_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","ጾዘ አሮ ፋና ማቂ ዋሎትꬃ የዞተፕ አትን ይን ዋሎትꬅታ ኢታ ኦቻስ ኣችቸ ማህፐተ። ");
INSERT INTO oyde_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","አስ ኡባ ቦንቾተ፤ አማንዘ አሱንꬃና ካꬎተ፤ ጾዝስ ዣሽቶተ፤ ካት ቦንቾተ። ");
INSERT INTO oyde_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","አሩንꬆ፥ ሎኦ ላꬁንስስን ዳልጋ ላꬁንꬅስ ጻላላ ባይዝን ኢቱንꬅስን ቦንቾራ አቆተ። ");
INSERT INTO oyde_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","አስ ጾዝ ግሾ ጋእ ገነር ማꬋ ኤኪ ዳንዳእኮ ጾዚ ኤዛ አንጆዳ። ");
INSERT INTO oyde_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","የዝን ይን ናጋራ ኦችን ይንታና ሴርዘ ዎደ ይን ዳንዳእኮ ይንትስ አኮ ጋላታ የዘ? የዝን ሎኦ ባዝ ኦቺ ማꬋ ዳንዳእኮ ጾዚ ይንታና ይንስ አንጆዳ። ");
INSERT INTO oyde_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","ጾዚ ይንታና ጼግደ ይኒ ግሾስ፤ ክርስቶሳ ይንትስ ዋይንትዳ፤ ይን ኤዛ ካሎደ ፋና፥ ይንትስ አዝዘ ማቅዳ። ");
INSERT INTO oyde_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","ኤ ናጋራ ኦችካያ፤ ኤ ዶንተ ጭሞ በንትካያ። ");
INSERT INTO oyde_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","ኡን ኤዛ ጫዣደር ማህ ጫዥካያ። የዝን ማꬋ ኤክተራ ጽሎ ፍርድዘ ጾዘስ ፍርዳ አሽዳ ፋትን ማንድካያ። ");
INSERT INTO oyde_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","ኑኒ ናጋራስ Ꮉይቂ ጽሎትꬅስ የሳደ ፋና ክርስቶሳ ፋ አሽተ ኑ ናጋርቶ ማስቃላላ አፋ ቶክዳ፤ ይን ኤዛ ጋራፍን Ꮉርግደ በስትራ ፋጽዳ