﻿USE sofia;
DROP TABLE IF EXISTS sofia.otsNT_vpl;
CREATE TABLE otsNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES otsNT_vpl WRITE;
INSERT INTO otsNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","I ju̱xcua hnar lista quí tju̱ju̱ cʉ cja̱hni cʉ mí pariente car Jesucristo. Bbɛto bi hmʉj yʉ cja̱hni‑yʉ, cja̱ gá nga̱x ya, bi hmʉh car Jesucristo. Guegue bú e̱je̱ digue jár cji car Abraham cja̱ co jár cji car rey David. ");
INSERT INTO otsNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Cja̱ digue quí pariente car Jesucristo ya, car Isaac múr ta car Abraham, cja̱ ya car Jacob múr ta car Isaac, cja̱ ya car Judá co cʉ once quí cjua̱da̱, múr tajʉ car Jacob. ");
INSERT INTO otsNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Cja̱ car Fares co car Zara, múr tahui car Judá. Cja̱ cár mehui múr Tamar. Cja̱ car Esrom múr ta car Fares, cja̱ car Aram ya, múr ta car Esrom. ");
INSERT INTO otsNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Cja̱ car Aminadab múr ta car Aram, cja̱ car Naasón múr ta car Aminadab, cja̱ car Salmón múr ta car Naasón. ");
INSERT INTO otsNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Cja̱ car Booz múr ta car Salmón. Cja̱ cár bbɛjña̱ car Salmón múr Rahab. Cja̱ car Obed ya múr ta car Booz. Cár bbɛjña̱ car Booz ya, múr Rut. Guegue‑ca̱ bi ømbi car Obed. Cja̱ car Isaí ya, múr ta car Obed. ");
INSERT INTO otsNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Car David mí mandado gá rey. Guegue‑ca̱ múr ta car Isaí. Cja̱ car Salomón múr ta car rey David. Cár me car Salomón múr bbɛjña̱ jma̱ja̱ ca ndor Urías. ");
INSERT INTO otsNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Cja̱ car Roboam múr ta car Salomón, cja̱ car Abías múr ta car Roboam, cja̱ car Asa múr ta car Abías. ");
INSERT INTO otsNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Cja̱ car Josafat múr ta car Asa, cja̱ car Joram múr ta car Josafat, cja̱ car Uzías múr ta car Joram. ");
INSERT INTO otsNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Cja̱ car Jotam múr ta car Uzías, cja̱ car Acaz múr ta car Jotam, cja̱ car Ezequías múr ta car Acaz. ");
INSERT INTO otsNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Cja̱ car Manasés múr ta car Ezequías. Digue car Amón ya, múr ta car Manasés, cja̱ digue car Josías, múr ta car Amón. ");
INSERT INTO otsNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Cja̱ digue car Jeconías hne̱h quí cjua̱da̱, múr tajʉ car Josías. Mí bbʉh car Jeconías, múr rey pʉ jar jöy Israel bbʉ mí ttzix cʉ cja̱hni judio gá preso gá möjmʉ pʉ jar jöy Babilonia. ");
INSERT INTO otsNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cja̱ bbʉ ya xquí ttzix cʉ cja̱hni pʉ Babilonia, bi hmʉh cár ttʉ car Jeconías pʉ jar jöy‑cá̱, múr Salatiel. Cja̱ car Zorobabel múr ta car Salatiel. ");
INSERT INTO otsNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Cja̱ digue car Abiud, múr ta car Zorobabel, cja̱ digue car Eliaquim, múr ta car Abiud, cja̱ digue car Azor, múr ta car Eliaquim. ");
INSERT INTO otsNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Cja̱ digue car Sadoc, múr ta car Azor, cja̱ digue car Aquim, múr ta car Sadoc, cja̱ digue car Eliud, múr ta car Aquim. ");
INSERT INTO otsNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Cja̱ digue car Eleazar, múr ta car Eliud, cja̱ digue car Matán, múr ta car Eleazar, cja̱ digue car Jacob, múr ta car Matán. ");
INSERT INTO otsNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Cja̱ digue car José, múr ta car Jacob. Car José, múr bbɛjña̱ car María, cja̱ car Jesús, múr me car María. Nu car Jesús, guegue i tsjifi ʉr Cristo, cja̱ nʉr tju̱ju̱‑nʉ́ i ne da ma̱, car hñøjø ca xí hñi̱x ca Ocja̱ pa da mandado. ");
INSERT INTO otsNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Desde bbʉ mí bbʉh car Abraham hasta gue bbʉ mí bbʉh car rey David, mbá ntɛnihui catorce quí mboxitita car Jesús. Cja̱ desde bbʉ mí bbʉh car rey David hasta bbʉ mí ttzix cʉ cja̱hni judio, bi ttɛni gá preso, gá ma pʉ jar jöy Babilonia, pé mí bbʉ pé dda catorce quí mboxitita car Jesús, quí ntɛnihui car David. Cja̱ desde bbʉ mí ttzix cʉ cja̱hni judio gá ma Babilonia hasta bbʉ mí hmʉh car Jesús ca i tsjifi ʉr Cristo, pé mbá ntɛnihui pé catorce quí mboxitita car Jesús. Tzʉdi, desde bbʉ mí bbʉh car Abraham hasta bbʉ mí hmʉh car Jesús, bi zøti cuarenta y dos quí mboxitita car Jesús, quí ntɛnihui car Abraham. ");
INSERT INTO otsNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ya xpa e̱h car bbede ja ncja gá hmʉh car Jesucristo. Car José, ya xquí dyöh car María pa di ntja̱jtihui. Bbʉ mí bbɛjtjo pa di ntja̱jtihui, jí̱ bbe mí bbʉbi, bi hna hñʉdi car María por rá ngue car Espíritu Santo. ");
INSERT INTO otsNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Car José, múr jogui cja̱hni. Bbʉ mí cca̱hti, ya xi mí hñʉ car María, ya jí̱ mí ne di ntja̱jtihui, pe guejtjo, jí̱ mí ne di bbɛtibi ʉ́r tzö. Eso, mí mbe̱ni guegue, ya jin di cuajti car María, pe guejtjo jin di xih cʉ cja̱hni te rá nguehcá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cja̱ bbʉ mí ntzohmi te di ncja, bi a̱ja̱, bi wi̱ hnár anxe ca Ocja̱, xcuí hñe̱ jar ji̱tzi. Nucá̱ bi nzoh car José, bi xifi: ―Nuquɛ José, ʉ́r cjiqui car rey David. Dyo te gui mbe̱ni digue car María. Nde̱jma̱ gui ntja̱jtihui cja̱ gui cuajti hua jer ngu̱. Cierto, i hñʉ‑cá̱, pe car tzi ba̱jtzi ca i tu̱, xí dyøti car Espíritu Santo. ");
INSERT INTO otsNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Da øngui hnár tzi ttʉ car María, cja̱ gui jñu̱htibi cár tju̱ju̱ dur Jesús. Guegue‑ca̱ da möx quí cja̱hni cʉ da hñe̱me̱, da gʉhtzibi ca rá nttzo ca xí dyøtijʉ.― Guehca̱ bi ma̱n car ángele‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bbʉ mí hñʉ car María, jim be mí yojmi cár da̱me. Ncjapʉ gá nzʉh ca hnar palabra ca xquí ma̱n ca Ocja̱, ya má yabbʉ. I ju̱x pʉ jar libro ca bi dyøti car profeta, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Dyøjma̱ja̱, da hna hñʉdi hnar ba̱jtzi bbɛjña̱tjo ca jí̱ bbe xtrú yojmi hnar hñøjø, cja̱ da øngui hnár tzi ttʉ. Nucá̱ da jñu̱ cár tju̱ju̱ dur Emanuel. Nʉr tju̱ju̱‑nʉ i ne da ma̱: “Dí bbʉpjʉ ca Ocja̱, dí cja̱hnijʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Már a̱h car José bbʉ mí ni̱gui car anxe, bi nzofo. Diguebbʉ ya bi zöntta̱ja̱, bi nantzi, cja̱ bi dyøte como ngu̱ gá bbɛjpi car anxe. Bi ma bú tzí car María pa di hmʉh pʉ́r ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Car José jin gá dyobi car María cʉ pa‑cʉ́, hasta gue bbʉ mí jñi̱n car María, cja̱ bi hmʉh ca primero ʉ́r ba̱jtzi. Cja̱ car José bi jñu̱htibi cár tju̱ju̱ ʉr Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bbʉ mí hmʉh car tzi Jesús pʉ jar jñi̱ni Belén pʉ jar jöy Judea, car rey Herodes már mandado pʉ. Bú e̱h cʉ dda mago, güí hñe̱j nʉ jabʉ rí bøx car jiadi, bi zøh pʉ jar jñi̱ni Jerusalén, pʉ jar jöy Judea. ");
INSERT INTO otsNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mí zøh pʉ cʉ mago, bi hñönijʉ: ―¿Jabʉ i bbʉh car ba̱jtzi ca, i̱na̱, xí hmʉy pa da cja ʉ́r rey yʉ judio? Pʉ jabʉ rí bøx nʉr jiadi, dú jantije hnar ndo tzø, eso dár e̱jme gu nda̱neje car tzi ba̱jtzi‑cá̱.― Bi ma̱ ncjapʉ cʉ mago. ");
INSERT INTO otsNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Car rey, bbʉ mí dyøh car palabra‑cá̱, bi ntzøte, como mí ntzu̱ di tjá̱mbi cár jmandado. Guejti cʉ mi̱ngu̱ pʉ Jerusalén, bi ntzøtijʉ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Diguebbʉ ya car Herodes bi nzojni göhtjo cʉ möcja̱ cʉ mí mandadobi cʉ cja̱hni israelita, co ni cʉ dda hñøjø cʉ mí u̱jti car ley, cja̱ bi dyön‑cʉ́: ―¿Jabʉ guehpʉ da hmʉh ca hnáa ca guí xijmʉ car Cristo ca da mandado?― ");
INSERT INTO otsNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Guegue cʉ möcja̱ cʉ mí mandado bi da̱h bbʉ́: ―Pʉ jar tzi jñini Belén, jar jöy Judea, porque i ju̱x pʉ jar libro ca bi dyøti car profeta. I ma̱n ncjahua, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nʉr tzi jñinitjo Belén nʉ jar jöy Judea, Más i ndo mu̱hui ni ndra ngue yʉ jñini rá nojo, Porque guejnʉ du hmʉjnʉ́ ca to da mandadoguijʉ, Guegue da mandadobi yí cja̱hni ca Ocja̱, da nu̱guijʉ rá zö, dí cja̱hni israelitajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bbʉ mí dyøj nʉr palabra‑nʉ́ car Herodes, bi nzoh cʉ mago gá ntta̱guitjojo. Bi dyönga nttzɛdi ¿ncjahmʉ mero xquí ni̱gui car tzø? Cja̱ cʉ mago bi xifi. ");
INSERT INTO otsNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Diguebbʉ ya car Herodes bi gu̱jmʉ pʉ jar jñi̱ni Belén, bi xijmʉ: ―Gui möjmʉ ya, bú jonijʉ rá zö jabʉ i bbʉh car tzi ba̱jtzi‑cá̱, cja̱ bbʉ ya xcú tötijʉ, pé gu cojmʉ hua, hne̱ gui xijquijʉ, pa sa̱nta̱ gu magö pʉ, gu ma nda̱ne hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cʉ mago ya, bi dyøjti car rey, bi möjmʉ Belén. Jiantijma̱ja̱ mbí dyo jar ji̱tzi ca hnar ndo tzø ca xcuí jiantijʉ pʉ jabʉ rí bøx car jiadi. Cʉ mago ya, bi dɛnijʉ bbʉ. Cja̱ bi zøti car tzø pʉ jabʉ már bbʉh car tzi ba̱jtzi, bi hmöjti pʉ xøtze car ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cʉ mago ya, bbʉ mí jiantijʉ, ya xquí tzöya car tzø, bi ndo mpöjmʉ göhtjo mbo í tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bi zøtijʉ, bi ñʉtijʉ pʉ jar ngu̱ ya, bi cca̱htijʉ car tzi ba̱jtzi co cár me. Múr María cár me. Bi nda̱ndiña̱jmu̱jʉ, bi nda̱nejʉ car tzi ba̱jtzi. Bi xohtijʉ cʉ regalo cʉ mbá tu̱jʉ, bi ña̱htibijʉ car tzi ba̱jtzi. Nu cʉ regalo‑cʉ́, ca hnáa múr oro, ca pé hnáa ya mí jñɛjmi car guitjoni, cja̱ ca pé hnáa ya mí tsjifi múr mirra, mí yʉni rá ncʉji. ");
INSERT INTO otsNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Diguebbʉ ya, ca Ocja̱ bi nzoh cʉ mago bbʉ már a̱ja̱. Bi wi̱jʉ bi tsjijmʉ ya jin di tjojmʉ pʉ jár ngu̱ car rey Herodes. Cʉ mago ya bi nantzi, bi ma gá ngojmʉ jár jöy gueguejʉ. Hnahño car hñu̱ bi dɛnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nu bbʉ ya xquí ma cʉ mago, pé bi wi̱ car José. Bi ni̱gui hnár anxe car Tzi Ta ji̱tzi, bi nzofo, i̱na̱: ―Nantzi ya, gui tzix car tzi ba̱jtzi co cár me, grí möjmʉ pʉ jar jöy Egipto. Cja̱ gui hmʉjti pʉ hasta gue bbʉ xtá xihqui, nubbʉ́, cja xcuí coji. Porque car Herodes i jon car tzi ba̱jtzi pa da möhti.― ");
INSERT INTO otsNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bi nantzi ya car José, bi zix car tzi ba̱jtzi co cár me, mí nxu̱ytjo, gá möjmʉ pʉ jar jöy Egipto. ");
INSERT INTO otsNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Cja̱ bú dejʉ pʉ hasta gue bbʉ mí du̱ car rey Herodes. Nubbʉ́, pé bú cojmʉ. Bbʉ mbú ttzi car tzi ba̱jtzi pʉ jar jöy Egipto, bi zʉh ca hnar palabra ca xquí ma̱n ca Ocja̱, ya má yabbʉ. I ju̱x pʉ jar libro ca bi dyøti car profeta, i̱na̱: “Nugö, dú nzojni cam tzi ttʉ, dú xifi drí hñe̱h pʉ jar jöy Egipto.” ");
INSERT INTO otsNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nu car Herodes, bbʉ mí dyøde xquí jiöti cʉ mago, bi ndo ungui ʉr cuɛ, bbʉ́. Bi gu̱h cʉ sundado, bbʉ́, gá möjmʉ jar jñi̱ni Belén, co cʉ pé dda tzi jñi̱ni cʉ mí nzøtitjohui. Bú pöhtijʉ göhtjo cʉ tzi ba̱jtzi cʉ mí tzi hñøjø, cʉ mí pɛhtzi yo cjeya pa jöy, como xquí ma̱n cʉ mago, ya xquí zʉ yo cjeya xquí ni̱gui ca hnar ndo tzø. Guehcá̱ bi xijmʉ car Herodes. ");
INSERT INTO otsNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cja̱ bbʉ mí bböhti göhtjo cʉ tzi ba̱jtzi‑cʉ́, bi zʉh car palabra ca xquí ma̱n car profeta Jeremías, ya má yabbʉ, bbʉ jí̱ bbe mí ncja. I ju̱x pʉ jar libro ca bi dyøti guegue, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bi ndo cja ʉr ttzoni pʉ jar jñi̱ni Ramá, Bi ndo nzon cʉ cja̱hni, mí ndo jí̱ quí tzi anxe, Cʉ bbɛjña̱ israelita mí zontibi quí tzi ba̱jtzi, mí ndo jonijʉ, Cja̱ jí̱ mí nejʉ pa to di jñu̱htibi í mʉyjʉ, como tje xquí du̱ quí tzi ba̱jtzijʉ. Ncjapʉ gá ma̱n car profeta‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nu car José bú dé pʉ jar jöy Egipto hasta bbʉ mí du̱ car rey Herodes. Diguebbʉ ya, pé bi wi̱ car José, bi hna ni̱gui hnár anxe ca Ocja̱, bi nzofo, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Nantzi ya, gui tzix car tzi ba̱jtzi co cár me, pé grí coh pʉ jar jöy Israel. Ya xí ndu̱ cʉ cja̱hni cʉ mí ne di möhti nʉr tzi ba̱jtzi.― ");
INSERT INTO otsNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Diguebbʉ ya bi nantzi car José, bi zix car tzi ba̱jtzi co cár me, pé gá möjmʉ jar jöy Israel. ");
INSERT INTO otsNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bbʉ mí zøtijʉ pʉ jar jöy Judea ya, bi dyøh car José, ya xi már mandado pʉ cár ttʉ car Herodes. Guegue mí ju̱ cár tju̱ju̱ múr Arquelao. Xquí gojti ʉ́r lugar ca ndo ʉ́r ta. Bbʉ mí dyøh car palabra‑ca̱ car José, bi zu̱. Jí̱ mí ne di ma pʉ jabʉ már mandado car Arquelao. Cja̱ ca Ocja̱ pé bi nzoh car José bbʉ már a̱ja̱, bi xifi jin di ma pʉ jar jöy Judea. Eso, bi tjojti pʉ, gá ma hnanguadi, gá nzøti pʉ Galilea. ");
INSERT INTO otsNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bi zøti pʉ jar tzi jñi̱ni, mí ju̱ cár tju̱ju̱ Nazaret, cja̱ bú hmʉh pʉ. Ncjapʉ gá nzʉh car palabra ca xquí ma̱n quí jmandadero ca Ocja̱, ya má yabbʉ. Nucʉ́, bi ma̱ ncjahua digue ca hnar hñøjø ca di mɛjni ca Ocja̱, i̱na̱jʉ: “Car hñøjø‑ca̱, da tsjifi ʉr nazareno.” ");
INSERT INTO otsNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nu cʉ pa‑cʉ́, car Juan ca mí xix cʉ cja̱hni bi ma pʉ hnar lugar pʉ jabʉ jin te mí bbʉ ngu̱, pʉ jar estado Judea. Cja̱ bi dɛn cʉ cja̱hni. Guegue car Juan bi mʉdi bi nzofo. ");
INSERT INTO otsNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mí xih cʉ cja̱hni ncjahua: ―Gui jiɛjmʉ ca rá nttzo, porque ya xta zʉh cʉ pá bbʉ xta ni̱gui hua jar jöy ja i ncja ga mandado ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Car profeta Isaías mi ma̱n ya palabra‑ya, bi jñu̱x pʉ jár libro ya má yabbʉ, i̱na̱: Dyøjma̱jʉ, i dyo hnar cja̱hni pʉ jabʉ jin to i hña̱ni, i ndo ña̱ nzajqui, I xih cʉ pé dda cja̱hni da jojqui quí vidajʉ, como ya xpa e̱h cam Tzi Jmu̱jʉ. I nzojmʉ ncjahua, i̱na̱: “Gui jojquijʉ ya car hñu̱ pʉ jabʉ xtu e̱h ca Ocja̱, Gui cjajpijʉ drá ncjua̱ni.” Bbʉ mí ma̱ nʉr palabra‑nʉ car profeta, mí ma̱ ja di ncja car Juan ca mí xix cʉ cja̱hni, bbʉ xti hñe̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Cʉ da̱jtu̱ cʉ mí je car Juan, xquí ttøte co quí xi cʉ camello. Mí ngʉti hnar ngʉti gá xifani, cja̱ mí tza tta̱xi cja̱ co quí ttafi cʉ colimena mí ca̱ ja ttøø. ");
INSERT INTO otsNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mbá e̱h cʉ cja̱hni pʉ jar jñi̱ni Jerusalén, guejti cʉ cja̱hni göhtjo pʉ jar estado Judea, co ni cʉ cja̱hni xcuí hñe̱jmʉ göhtjo jar jöy ca mí nzøtitjohui car da̱tje Jordán. ");
INSERT INTO otsNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Göhtjo mbá e̱h cʉ cja̱hni, mbá cuatijʉ car Juan, cja̱ mí ødejʉ ca mí ma̱ guegue. Nubbʉ́, mí ncjua̱mbijʉ ca xquí dyøtijʉ ca már nttzo. Nu car Juan ya, bi xix cʉ cja̱hni jar da̱tje Jordán. ");
INSERT INTO otsNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bi cca̱hti car Juan cʉ cja̱hni rá ngu̱ cʉ mí tsjifi fariseo, co hne̱h cʉ mí tsjifi saduceo, mbá cuatijʉ. Guejtjo mbá e̱h‑cʉ pa di tsjix‑cʉ́. Nu car Juan bi xijmʉ: ―Nuquiguɛjʉ, guí ncjajʉ ncja nʉr cci̱ña̱. Rá nttzo quir mʉyjʉ. ¿Toca̱ xí xihquijʉ gui xixtjejʉ pa jin da zʉhquijʉ car castigo ca du pɛnquijʉ ca Ocja̱? Ya xpa e̱h car castigo‑ca̱, cja̱ drá ndo ʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dí xihquijʉ, i nesta gui pöti quir vidajʉ, gui jiɛjmʉ ca rá nttzo, cja̱ gui dyøtijʉ ca rá zö, pa da ni̱gui, cierto guí jonijʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nuquɛjʉ, guí hñi̱xtsjɛjʉ por rá nguehca̱ xquí hñe̱jmʉ jár cji ca ndom titajʉ car Abraham. Jí̱ rí ntzöhui gui hñi̱xtsjɛjʉ. Nugö, dí xihquijʉ, bbʉ da mandado ca Ocja̱, guejti yʉ me̱do i bbongua da jogui da cjajpi í ba̱jtzi car Abraham. ");
INSERT INTO otsNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Guí jñɛjmʉ hnar za ca jin te i ungui ixi. Rí ntzöhui da ttzɛjqui‑cá̱ cja̱ da ddʉti. Gui repentijʉ, bbʉ́, cja̱ gui pöti quir vidajʉ, porque car hacha, ya xna bbɛndi pʉ jár hua car za. Ya xta zɛjqui. ");
INSERT INTO otsNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nugö, dí xix yʉ cja̱hni cor dejetjojo, pa da fa̱di, ya xí jiɛjmʉ ca rá nttzo. Nu ca hnáa ca ba e̱je̱, más i ndo ja̱ cár cargo ni ndra nguejquigö. Nugö, jin drá ntzögöbbe gu cjajpigö quí jmandado. Guegue du pɛnquijʉ car Espíritu Santo pa gui yojmʉ‑cá̱, cja̱ car Espíritu Santo i jñɛjmi ncja hnar tzibi. ");
INSERT INTO otsNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ca hnar hñøjø ca dí xihquijʉ, ya xqui ne da mijqui quí ttɛy. Cja̱ bbʉ ya xi ʉr limpio cʉ ttɛy, nubbʉ, xta mɛhtzi pʉ jár ngu̱. Nu cʉ baxa, da wejqui hnanguadi, da jiøh pʉ jar tzibi ca jin gui jui̱ti, da dʉti pʉ.― Ncjapʉ gá ma̱n car Juan bbʉ már predica. ");
INSERT INTO otsNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Diguebbʉ ya car Jesús bi bøm pʉ Galilea, gá ma pʉ jar da̱tje Jordán, pʉ jabʉ már bbʉh car Juan. Guegue bi guati car Juan, bi dyöjpi di xitzi. ");
INSERT INTO otsNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Car Juan ya, mí ne di ccax car Jesús, bi xifi: ―¿Cja guír hñe̱je̱ gu xixquigö? Nugö jin drá ntzögöbbe gu xixquigö. I nesta guehquɛ gui xixqui.― ");
INSERT INTO otsNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nu car Jesús pé bi da̱di: ―Nugö, nde̱jma̱ dí ne gui xixquigö, pa gu øtihui göhtjo ca i ne ca Ocja̱.― Cja̱ diguebbʉ ya, car Juan bi dyøjti ca bi ma̱n car Jesús, bi xitzi. ");
INSERT INTO otsNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cja̱ bbʉ ya xquí xixtje, bi bøx car Jesús pʉ jar deje. Cja̱ bi hna jianti, bi xoj nʉr ji̱tzi, cja̱ guegue bi jianti cár Espíritu ca Ocja̱ bú ca̱y ncja hnar paloma, bi guati pʉ jabʉ már bböh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cja̱ mbí ña̱ hnar cja̱hni pʉ jar ji̱tzi, mbí ma̱: ―Guejnʉ́ ʉm tzi Ttʉ‑nʉ́, dí ma̱di. Guejnʉ́ i pöjpigui nʉm tzi mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Diguebbʉ ya, cár tzi Espíritu ca Ocja̱ bi zix car Jesús gá mɛhui pé hnar lugar pʉ jabʉ jin to mí hña̱ni. Bi zix car Jesús pʉ jar lugar‑ca̱ pa di ttøhtibi prueba. ");
INSERT INTO otsNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Car Jesús jin te mí tzi, cuarenta mpa hne̱ cuarenta nxu̱y. Diguebbʉ, bi ndo du̱ntju̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nubbʉ, bú e̱h ca Jin Gui Jo, bi guati car Jesús. Mí jon car manera ja drí jiöti pa di dyøte tema cosa ca jin di tzö. Bi xij ya bbʉ: ―Nuquiguɛ, bbʉ ʉ́r Ttʉqui ca Ocja̱, gui mandado ya, gui cjajpi yʉ me̱do ra bbongua da cja tju̱jme̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nu car Jesús bi da̱di: ―Ji̱na̱, porque i ma̱m pʉ jar Escritura, i̱na̱: “Jin gui jøña̱ ca i tzi yʉ cja̱hni da ungui nzajqui. Bbʉ ga mandadotsjɛ ca Ocja̱ pa da ncja ʉm nzajquije, nubbʉ, da hmʉy.”― Ncjapʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Diguebbʉ ya, ca Jin Gui Jo bi zix car Jesús, gá mɛhui pʉ jar jñi̱ni Jerusalén, pʉ jabʉ i bbʉh cár tzi templo ca Ocja̱. Bi hñi̱x pʉ jar ntorre ca más már nte. Car Jesús mbí tøh pʉ ña̱ jar templo. ");
INSERT INTO otsNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nubbʉ́, ca Jin Gui Jo pé bi xih car Jesús, bi hñi̱na̱: ―Nuquiguɛ, bbʉ ʉ́r Ttʉqui ca Ocja̱, gui hñɛy grí tö jar jöy. ¿Cja jin da möxqui ca Ocja̱? Porque i ma̱m pʉ jar Escritura, i̱na̱: Car Tzi Ta ji̱tzi da bbɛjpi quí ángele da möhqui, Guegue‑cʉ́ da zɛti quir dyɛ pa jin te gui cja, Nim pa jabʉ gui fehtzi hnar me̱do.― Ncjapʉ gá ma̱n ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Car Jesús bi da̱di, bi hñi̱na̱: ―Ji̱na̱, jin gu øti‑ca̱, porque guejtjo i ma̱n ca Ocja̱ pʉ jar Escritura: “Ir Tzi Jmu̱ ca Ocja̱. Jin gui ma gui dyøti hnar cosa drá nttzo pa gui cca̱hti, ¿cja da dyøti hnar milagro ca Ocja̱ pa da möxqui?”― ");
INSERT INTO otsNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ma ya, ca Jin Gui Jo pé bi zix car Jesús gá mɛhui ca hnar ndo ttøø, már ndo nte. Nupʉ, bú u̱jti göhtjo cʉ nación hua jar mundo, quí jöy co ni quí jñi̱ni, cja̱ co göhtjo cʉ mí pɛhtzi cʉ cja̱hni. Már tzi zö mír ni̱gui‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Cja̱ ca Jin Gui Jo bi xih car Jesús, i̱na̱: ―Bbʉ gui nda̱ndiña̱jmu̱, gui nda̱negui dúr cjá̱a̱‑gö, nugö, gu ddahqui göhtjo‑yʉ, gui cjajpi ir mɛjti.― ");
INSERT INTO otsNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nu car Jesús bi da̱di: ―Wembigui nttzɛdi, Satanás, porque i ma̱n ca Ocja̱ pʉ jar Escritura: “Ir Tzi Jmu̱ ca Ocja̱. Ddatsjɛ guegue gui nda̱ne cja̱ gui dyøjte.”― ");
INSERT INTO otsNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Diguebbʉ ya, ca Jin Gui Jo bi wembi, bbʉ, cja̱ bú e̱h cʉ dda ángele, bi guatijʉ car Jesús, bi unijʉ te bi zi. ");
INSERT INTO otsNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Diguebbʉ ya car Jesús bi dyøde, már bbʉ födi car Juan ca mí xix cʉ cja̱hni. Nubbʉ́, bi wem pʉ jabʉ mí dyo quí contra car Juan, gá ma hnanguadi jar estado Galilea, cja̱ bi zøti pʉ jar jñi̱ni Nazaret. ");
INSERT INTO otsNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pe jin gá hmʉh pʉ. Pé bi bøni gá ma jar jñi̱ni Capernaum, cja̱ bú hmʉh pʉ. Car jñi̱ni Capernaum már bbʉh pʉ jár nttza̱ni car mar ca mí tsjifi ʉr Galilea, cja̱ mí nzøtitjohui car estado Zabulón co car estado Neftalí. ");
INSERT INTO otsNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Car Jesús bú hmʉh pʉ jar jöy‑cá̱ pa di zʉh car palabra ca bi jñu̱x car Isaías pʉ jár libro. Mí ma̱n ncjahua: ");
INSERT INTO otsNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Pʉ jár jöy Zabulón, hne̱h pʉ jár jöy Neftalí da yoti cár jiahtzi ca Ocja̱, Da ni̱gui pʉ jar hñu̱ rí bböti pʉ jár nttza̱ni car mar, hne̱h pʉ jar jöy nʉ rí ncjanʉ car da̱tje Jordán, nʉ jabʉ rí bøx car jiadi, da ni̱gui pʉ hne̱je̱. Guehpʉ Galilea, pʉ jabʉ i bbʉh cʉ cja̱hni cʉ jin gui meya ca Ocja̱, da yoti pʉ cár jiahtzi. ");
INSERT INTO otsNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Cʉ cja̱hni cʉ i bbʉh pʉ jabʉ már hmɛxu̱y, ya xí jiantijʉ car jiahtzi, Cʉ cja̱hni cʉ ya xi mír ma di du̱, ya xí ni̱gui pʉ hnar jiahtzi rá tzi zö. Gue yʉ palabra‑yʉ bi ma̱n car Isaías. ");
INSERT INTO otsNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Diguebbʉ́, bi mʉh car Jesús, bi nzoh cʉ cja̱hni, mí i̱mbijʉ: ―Nuquiguɛjʉ, gui jiɛjmʉ ca rá nttzo, cja̱ gui jionijʉ ca Ocja̱. Ya xta zʉh car pa ca guí tøhmijʉ. Ya xta ni̱gui hua jar jöy ja i ncja ga mandado ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Má dyo car Jesús pʉ jár nttza̱ni car mar ca mí tsjifi ʉr Galilea. Bi jianti yojo hñøjø cʉ mí ncjua̱da̱. Ca hnáa múr Simón, cja̱ guejtjo mí tsjifi múr Pedro, cja̱ cár cjua̱da̱ múr Andrés. Már pøti cár hmamöyhui jar deje, como mí mamöyhui. ");
INSERT INTO otsNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Cja̱ bi nzojmi car Jesús, bi hñi̱mbihui: ―Bú e̱jmi gui tɛnguihui. Nuquɛhui, guí mamöyhui. Nuguigö gu ddahquihui hnahño ir bbɛfihui. Gu u̱jtiquihui ja grí nzojmi yʉ cja̱hni pa da dɛnguigö.― ");
INSERT INTO otsNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nubbʉ́, nguetica̱ car Simón co car Andrés bi jiɛh cár hmamöyhui cja̱ bi dɛnihui car Jesús, bi hñojʉ‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nu car Jesús pe gá tjoj nʉ rí ncjanʉ jár nttza̱ni car deje, cja̱ pé bi jianti pé yojo hñøjø. Guejti‑cʉ́ mí ncjua̱da̱‑cʉ́. Nucʉ́ mí ju̱ quí tju̱ju̱hui ca hnáa múr Jacobo cja̱ nu ca pé hnáa múr Juan. Cár tahui múr Zebedeo. Bbʉ má tjoh pʉ car Jesús, cʉ yo ncjua̱da̱‑cʉ́ co cár tahui, már tøjmʉ cár tzi barcojʉ. Már jojqui quí hmamöyjʉ. Cja̱ car Jesús bi nzoh car Juan co car Jacobo, bi xifi di dɛnihui. ");
INSERT INTO otsNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nguetica̱ bbʉ́, car Juan co car Jacobo bi bøm pʉ jar barco, bi zoti pʉ cár tahui, cja̱ bi dɛnihui car Jesús, bi möjmʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Diguebbʉ ya car Jesús bi tjoh pʉ göhtjo cʉ tzi jñi̱ni pʉ jar estado Galilea. Mí cʉti jáy templo cʉ judio, mí xih cʉ cja̱hni, ya xti zʉh car pa ca mí ddøhmi. Ya xti ni̱gui hua jar jöy ja i ncja ga mandado ca Ocja̱. Mí jojqui göhtjo cʉ cja̱hni cʉ mí jñi̱ni, co cʉ mí tzöhui te mar ʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Cja̱ bi ndo ngöxtejʉ digue ca mí øti car Jesús. Hasta guehpʉ jar jöy Siria bi dyøh cʉ cja̱hni ja ncja mír jojqui döhtji car Jesús, eso, bú mpɛguijʉ, bú tzijmpi göhtjo quí döhtjijʉ. Bú tzijʉ cʉ cja̱hni cʉ mí tzöhui göhtjo tema jñi̱ni, co cʉ mí tzöhui ca rá ʉ́, cja̱ co cja̱hni cʉ xquí zʉh cár nda̱ji̱ ca Jin Gui Jo, co hne̱h cʉ xquí bbɛh quí mfe̱ni, co ni cʉ jí̱ mí tzö di hña̱ni. Car Jesús bi jojqui göhtjo‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nubbʉ́, bi dɛn cʉ cja̱hni már ngu̱ cʉ güí hñe̱j nʉ jar estado Galilea, cja̱ hne̱h cʉ güí hñe̱j nʉ jar lugar pʉ jabʉ rá bbʉh cʉ ddɛtta jñi̱ni, co ni cʉ güí hñe̱j nʉ jar cuidad Jerusalén. Guejti cʉ pé dda mi̱ngu̱ pʉ Judea bú e̱jmʉ hne̱je̱, cja̱ co cʉ cja̱hni cʉ mí mi̱ngu̱ nʉ rí ncjanʉ jar da̱tje Jordán, nʉ jabʉ rí bøx car jiadi. Göhtjo cʉ cja̱hni‑cʉ́, bi guatijʉ car Jesús, bi dɛnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Diguebbʉ ya, bbʉ mí cca̱hti car Jesús, ya xquí jmuntzi cja̱hni rá ngu̱ pʉ jabʉ már bbʉy, bi bøx pʉ jar ttøø, bú mi̱h pʉ. Bú e̱h quí möxte, bi guatijʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nubbʉ, car Jesús bi mʉdi bi u̱jti quí möxte, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i pa̱tsjɛjʉ, jin gui gue ca i cjajʉ da möxjʉ, eso, i ndo jonijʉ guegue. Nucʉ́, da hmʉbi car Tzi Ta ca bí mandado pʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i du̱mʉy. Guegue da jñu̱htibi ʉ́r mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i pɛhtzibi ʉr tti̱jqui quí mi̱nga̱‑cja̱hnihui. Nucʉ́ da ttuni ca hnar herencia rá zö ca xí ma̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i ndo joni ja drí dyøtijʉ ca rá zö. Guegue da möx cʉ cja̱hni‑cʉ́ pa da döti ca i jonijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i jui̱jqui quí hñohui. Guejti guegue i jui̱jqui‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i joni göhtjo mbo í tzi mʉyjʉ. Nucʉ́, da cca̱htijʉ ca Ocja̱, cja̱ da hmʉpjʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i jonijʉ ja drí hmʉbi rá zö quí mi̱nga̱‑cja̱hnijʉ, pa jin da ntu̱jnijʉ. Guegue‑cʉ́ da tsjifi í ttʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ca Ocja̱ da uni bendición cʉ cja̱hni cʉ i øti ca rá zö, masque da ttøhtibi tu̱jni por rá ngue guegue. Nucʉ́, da hmʉbi car Tzi Ta ca bí mandado pʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nuquiguɛjʉ, bbʉ da zanquijʉ yʉ cja̱hni, cja̱ bbʉ da dyøjtiquijʉ tu̱jni cja̱ da ña̱quijʉ göhtjo tema bbɛtjri por rá nguehca̱ guír tɛnguigöjʉ, gui ndo mpöjmʉ bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dyo guí du̱mʉyjʉ, da ndo mpöj yir tzi mʉyjʉ, porque drá tzi zö ca da ttahquijʉ pʉ jar ji̱tzi. Guejti quí mɛfi ca Ocja̱ cʉ mí bbʉ má̱hmɛto, mí ttʉjʉ hne̱je̱ por rá ngue ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nuquɛjʉ, guí jñɛjmʉ car u̱. I ndo sirve car u̱. Pe bbʉ jin gui nxøgue ʉr u̱, nubbʉ, jin tza i u̱xi. ¿Te gui cjajpi pa drá u̱xi? u̱jtjo. ¿Te da mɛj ya bbʉ? Da bbom pʉ tji̱, da di̱ni yʉ cja̱hni. Hne̱hquitjoguɛjʉ, bbʉ guí ncjajʉ ncja car u̱ ca jin gui u̱xi, jin te guí sirveguijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nuquiguɛjʉ, guí jñɛjmʉ cʉ tzibi, i zø bbʉ nxu̱y, como guí yotijʉ yʉ cja̱hni hua jar jöy. Nu yʉ pé dda cja̱hni, i cca̱jtiquijʉ, ja i ncja quir vidajʉ. Guejtjo guí jñɛjmʉ hnar jñi̱ni bí cuati jar ttøø. Como jin te i cju̱jti, göhtjo cʉ cja̱hni i janti. ");
INSERT INTO otsNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bbʉ to i tzøqui hnar tzibi, jin gui cohmi co hnar cajón. I i̱x pʉ ña̱, pʉ jabʉ da yoti göhtjo cʉ cja̱hni pʉ mbo car ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nuquɛjʉ, como guí ncjajʉ ncja hnar tzibi, i nesta gui hmʉpjʉ rá zö pa gui jñɛjmʉ ncja hnar lámpara i yoti rá zö. Nubbʉ, yʉ pé dda cja̱hni da cca̱jtiquijʉ, rá zö guir hmʉpjʉ, cja̱ da hñi̱htzibijʉ quer Tzi Tajʉ ca bí bbʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Dyo guí mbenijʉ, má̱s dá e̱cö pa gu xij yʉ cja̱hni, ya jin da dɛnijʉ car ley ca bi dyøti car Moisés, co cʉ libro cʉ bi dyøti cʉ profeta. Nugö, xtú e̱je̱ pa gu u̱jtiquijʉ göhtjo te mí ne di ma̱n car ley cja̱ co cʉ libro cʉ bi dyøti cʉ profeta. ");
INSERT INTO otsNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Dí xihquijʉ ca ncjua̱ni, menta i bbʉjti nʉr ji̱tzi co nʉr jöy, jin da bbɛj nʉr ley. Jin da mpuni ni di hnar jota, ni di hnar tzi punto. Da zʉdi göhtjo cʉ palabra cʉ i ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","I bbʉh cʉ dda cja̱hni, i tɛni tengu̱ cʉ mandamiento, pe nde̱jma̱ i jɛjti hnáa o yojo, cja̱ hne̱je̱ pé i xihquijʉ jin guí nesta gui dyøtijʉ cʉ mandamiento‑cʉ́. Nugö, dí xihquijʉ, cʉ cja̱hni‑cʉ́, jin da tti̱htzibi pʉ jabʉ i mandado ca Ocja̱. Cja̱ pé i bbʉh cʉ pé dda cja̱hni cʉ i øte göhtjo cʉ mandamiento, cja̱ pé i xihquijʉ gui dyøtijʉ göhtjo, hne̱je̱. Gue cʉ cja̱hni‑cʉ́ da tti̱htzibi pʉ jabʉ i mandado ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nugö, dí xihquijʉ, jin gui hmʉpjʉ ncja ngu̱ cʉ cja̱hni cʉ i tsjifi fariseo, cja̱ co cʉ pé dda cja̱hni cʉ i u̱jtiquijʉ car ley. Bbʉ gui hmʉpjʉ ncjapʉ, jin da jogui gui cʉtijʉ pʉ jabʉ i mandado ca Ocja̱. I nesta ntju̱mʉy drá zö quir tzi mʉyjʉ pa gui cʉtijʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ya xcú dyødejʉ nʉr palabra nʉ bi ma̱n car Moisés, bi xih cʉ ndom titajʉ, i̱na̱: “Dyo guí pöhtite. Ca to da pöhtite, da ttzix pʉ jabʉ i bbʉh cʉ nzöya, da ttun cár castigo.” ");
INSERT INTO otsNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pe nugö dí xihquijʉ, car cja̱hni ca i tsjeyabitjo cár hñohui, guejti‑cá̱ da ttzix pʉ jar jujticia. Nu ca to da zán cár hñohui, da xifi ʉr dondo ca jin te i mu̱hui, guegue da ttɛm pʉ jabʉ i bbʉh cʉ autoridad pa da ttuni hnár castigo drá ngu̱. Cja̱ nu ca to da zán cár hñohui, da xifi nttzɛdi ʉr zu̱we̱, guejtsjɛ guegue rí ntzöhuí da cju̱h pʉ jar tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","I ne ca Ocja̱ gui johui quer hñohui. Eso, bbʉ ya xcuá ja̱ quer ofrenda, hne̱ gui dö, cja̱ gui hna mbe̱ndi pʉ quer hñohui, te xcú dyøhtibi, ");
INSERT INTO otsNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dí cöxta hnanguadi quer ofrenda, gui ma gui dyöjpi perdón quer hñohui, bbʉ. Diguebbʉ ya, da jogui gu coji cja̱ gui cöti quer ofrenda, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Bbʉ to xí dyøjtiqui tu̱jni, cja̱ bí ttzojnqui jar jujticia, gui reglahui nttzɛdi, menta gá pɛhui jar hñu̱, ante que gui tzønihui pʉ jar jujticia. Bbʉ ji̱na̱, da döqui jar nzöya, cja̱ car nzöya ya, da döqui jar nzʉttabi pa da gohqui pʉ jar födi. ");
INSERT INTO otsNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cierto dí xihquijʉ, jin gui pøx pʉ hasta gue bbʉ xcrú cju̱ti göhtjo car multa ca da ttɛmbiqui. ");
INSERT INTO otsNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ya xcú dyødejʉ nʉr palabra nʉ bi ma̱n car Moisés má̱hmɛto. Guegue mí ma̱: “Dyo guí yojmi hnar bbɛjña̱ ca jí̱ xquí ntja̱jtihui. Cja̱ dyo guí jöhtibi cár bbɛjña̱ pé hnar hñøjø.” ");
INSERT INTO otsNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pe nugö, dí xihquijʉ, bbʉ to da cca̱hti hnar bbɛjña̱ cja̱ da ma̱ntsjɛ mbo ʉ́r mʉy: “Dí ne gu yobbe‑nʉ,” rá nttzo ga mbe̱ni. Ca Ocja̱ bí janti car hñøjø‑ca̱ ncjahmʉ ya xtrú jiöti car bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Eso, dí xihquijʉ, bbʉ i ne da jiöhqui que hner dö ca más i sirvequi, pa gui dyøti ca rá nttzo, nde̱jma̱ jin gui dyøte. Más di jogui güi jña̱hmi quer dö, güi dyɛy, ni ndra ngue bbʉ güi dyøti ca rá nttzo. Más bí jogui da bbɛh hner dö cja̱ gui cʉti pʉ jabʉ i bbʉh ca Ocja̱ ni ndra ngue bbʉ di zøti quer cuerpo cja̱ di ttɛntiqui pʉ jar tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ncjadi pʉ, quer jogui dyɛ, bbʉ i ne da jiöhqui pa gui dyøti ca rá nttzo, nde̱jma̱ jin gui dyøte. Más di joh bbʉ güi dyojqui, güi dyɛy, ni ndra ngue bbʉ güi dyøti ca rá nttzo. Más bí joh bbʉ da bbɛh hner dyɛ cja̱ gui cʉti pʉ jabʉ i bbʉh ca Ocja̱ ni ndra ngue bbʉ di zøti quer cuerpo cja̱ di ttɛntiqui pʉ jar tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Guejtjo bi ma̱n car Moisés má̱hmɛto, bi xihquijʉ: “Hnar hñøjø, bbʉ i ne da mpoguihui cár bbɛjña̱, da ttøti hnar jɛhmi gá ntsjʉjqui‑ntja̱jti, da ttun car bbɛjña̱ pa da dɛtzi. Nubbʉ́, da mpoguihui, bbʉ.” Ncjapʉ gá ma̱n car Moisés. ");
INSERT INTO otsNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pe nugö, dí xihquijʉ, car hñøjø ca da mpoguihui cár bbɛjña̱, i øti ca rá nttzo, cja̱ pé i cjajpi cár bbɛjña̱ da dyøti ca rá nttzo. Como bbʉ pé xta ntja̱jtihui pé hnar hñøjø car bbɛjña̱, xta yohti da̱me. Nubbʉ́, dúr nttzojqui ca bbɛto ʉ́r da̱me, como guegue‑ca̱ xí mɛgui. Solo bbʉ pé xtrú mɛhui pé hnar hñøjø cár bbɛjña̱, nubbʉ́, i pɛhtzi derecho da mɛgui. Guejti car hñøjø ca da ntja̱jtihui hnar bbɛjña̱ ca xí bbɛgui, i øti ca rá nttzo hne̱je̱, como i bbʉbi cár bbɛjña̱ pé hnar hñøjø. ");
INSERT INTO otsNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Guejtjo hne̱je̱ xcú dyødejʉ na̱r palabra na̱ bi ma̱n car Moisés má̱hmɛto. Guegue bi xih cʉ ndo ʉm titajʉ: “Bbʉ te xcú prometebi quer mi̱nga̱‑cja̱hnihui, xcú hñi̱h ca Ocja̱ gá testigo, gui uni ca xcú promete.” ");
INSERT INTO otsNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pe nugö, dí xihquijʉ, bbʉ te guí ma̱jmʉ, jin gui hñi̱jmʉ ca Ocja̱ gá testigo. Guejtjo jin gui hñi̱jmʉ nʉr ji̱tzi, como ʉ́r nttzöya pʉ ca Ocja̱, guehpʉ bí bbʉh pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hne̱j nʉr jöy, jin gui hñi̱jmʉ gá testigo, porque guejtjo ʉ́r mɛjti ca Ocja̱. Guejti nʉr jñi̱ni Jerusalén, jin gui hñi̱jmʉ gá testigo hne̱je̱, porque guejnʉ́ rá bbʉjnʉ cár templo ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jin gui hñi̱jmʉ nir ña̱ gá testigo, porque jin tema cargo guí pɛhtzi pa gui cjajpi hner xta̱a̱ da ttaxqui, o bbʉ ya xná nttaxi, pa gui cjajpi pé da pojqui. ");
INSERT INTO otsNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gui ntzohmi ter bɛh ca̱ guí ne gui ma̱, cja̱ gui ma̱ntjo. Gue ca Jin Gui Tzö i cjahquijʉ gui nømbijʉ cár tju̱ju̱ ca Ocja̱ o pé hnar cosa rá nttzu̱jpi pa da tte̱me̱ ca guí ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ya xcú dyødejʉ na̱r palabra na̱ bi ma̱n car Moisés má̱hmɛto, i̱na̱: “Car cja̱hni ca da ccɛhtibi ʉ́r dö cár hñohui, guejtjo da nccɛhtibi hnár dö guegue. Car cja̱hni ca da tsjöjquibi hnár ttzafi cár hñohui, guejtjo da ntsjöjquibi hnár ttzafi guegue.” ");
INSERT INTO otsNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pe nugö, dí xihquijʉ: Bbʉ to te da cjahquijʉ, gui jiɛguijʉ. Bbʉ to da ddahqui hnar mpɛhti jer jmi, nuquiguɛ, pé dí bbötitjo ca pé hnanguadi, pa pé da mɛjtiqui pʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Cja̱ bbʉ to da zixqui pʉ jar jujticia cja̱ nupʉ́ da ttöhqui quer chamarra, bbʉ pé i ne da ga̱nqui quer manga, gui jiɛjtjo da ga̱nqui. ");
INSERT INTO otsNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nu cʉ cja̱hni cʉ i pɛhtzi cargo, bbʉ da bbɛjpiqui gá fuerza gui mɛhui yo quilómetro, gui tu̱htzibi ʉ́r bbötzi, gui mɛhui hasta go quilómetro. ");
INSERT INTO otsNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bbʉ to da dyöhqui ca te i nesta, gui fötzi, cja̱ hne̱h bbʉ to te i nesta da jmi̱hqui, gui jmi̱pi hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ya xcú dyødejʉ ca bi jma̱ má̱hmɛto: “Gui ma̱j yir hñojʉ, cja̱ gui fötzi. Nu quir contra, jin gui föx‑cʉ́.” ");
INSERT INTO otsNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pe nugö dí xihquijʉ: Gui föx cʉ cja̱hni cʉ i ʉquijʉ, cja̱ gui ña̱hui cor tti̱jqui cʉ cja̱hni cʉ i tzanquijʉ. Gui dyøhtibijʉ ca rá zö cʉ cja̱hni cʉ jin gui nequijʉ. Gui dyöjpijʉ car Tzi Ta ji̱tzi da bendeci cʉ cja̱hni cʉ i øjtiquijʉ tu̱jni, co ni cʉ i nu̱quijʉ rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bbʉ gui dyøtijʉ‑cá̱, xquí jñɛjmʉ quer Tzi Tajʉ ca bí bbʉ ji̱tzi. Guegue bi dyøti nʉr jiadi, cja̱ göhtjo ʉr pa i cjajpi da bøx nʉr jiadi pa da yoti nʉr jöy. I yoti nʉr cja̱hni nʉ i øti ca rá nttzo, cja̱ co hne̱j nʉ i øti ca rá zö. Guejtjo ba pɛjni car dye pa da bendeci yʉ jogui cja̱hni, cja̱ co hne̱j yʉ i ndu̱jpite. ");
INSERT INTO otsNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hne̱hquitjoguɛjʉ, i nesta gui nu̱jʉ rá zö göhtjo yʉ cja̱hni. Porque bbʉ guí nejʉ jøña̱ yʉ cja̱hni yʉ i nequijʉ, ¿tema cosa rá zö da cozquijʉ ca Ocja̱, bbʉ́? Guejti cʉ jiöjte cja̱hni cʉ jin gui meya ca Ocja̱ i ne quí amigojʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nuquɛjʉ, bbʉ guí zɛnguajʉ jøña̱ quir parientejʉ, ¿ter bɛh ca̱ guí øtijʉ ca rá zö? Guejti cʉ cja̱hni cʉ jin gui meya ca Ocja̱ i zɛngua quí parientejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Eso, dí xihquijʉ, gui nu̱jʉ rá zö göhtjo yʉ cja̱hni, pa gui ncjajʉ ncja ngu̱ quer Tzi Tajʉ ca bí bbʉ ji̱tzi. Guegue‑cá̱ i nu̱ rá zö göhtjo yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Car Jesús pé bi xih quí möxte: ―Cʉ cosa rá zö cʉ guí ne gui dyøtijʉ, gui mbe̱nijʉ ja grí dyøtijʉ pa da tzøh ca Ocja̱. Gui mfödijʉ pa jin gui mbe̱nijʉ jøntsjɛ ja grí cjajpijʉ pa da hñi̱zquijʉ yʉ cja̱hni. Bbʉ gui dyøtijʉ tema cosa jøntsjɛ pa da hñi̱zquijʉ yʉ cja̱hni, jin te da ddahquijʉ quer Tzi Tajʉ ca bí bbʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Eso, bbʉ guí uni ca te i nesta cʉ cja̱hni cʉ jin te i ja̱, jin gui xijmʉ yʉ pé dda cja̱hni te xcú u̱ni. Cʉ jiöjte cja̱hni cʉ i tɛn ca Ocja̱ xøtzetjo, bbʉ ya xta dö cár ofrendajʉ, i mandadojʉ da tsjih cʉ cja̱hni cʉ i bbʉh pʉ jar templo cja̱ co cʉ cja̱hni cʉ i dyo ja calle, como gueguejʉ i ne pa da tti̱htzibijʉ. Cierto, dí xihquijʉ, cʉ cja̱hni cʉ i øti ca rá zö jøntsjɛ pa da tti̱htzibi, ya xí cja ca mí nejʉ. Ya jin te pé da ttunijʉ pʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pe nuquiguɛ, bbʉ guí föx cʉ tzi probe, jin da ba̱h quer hñohui ca más guí ntzixihui te xcú uni. ");
INSERT INTO otsNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jøña̱ ca Ocja̱ da ba̱di. Guegue i cca̱hti ca jin gui cca̱hti yʉ cja̱hni, cja̱ xta cozqui hnar cosa más drá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Guejtjo bbʉ guí orajʉ, dyo guí ncjajʉ ncja ngu̱ cʉ jiöjte cja̱hni. Nucʉ́, i gustabi da hmöjti pʉ mbo car templo, o guejnʉ jáy nttza̱ni yʉ calle, da orajʉ pʉ jabʉ da ncca̱htijʉ. Dí xihquigöjʉ, ya xí cja ca mí nejʉ. Ya jin te pé da ttunijʉ pʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pe nuquiguɛ, bbʉ guí ora, gui cʉti mbo quer ngu̱ pʉ más ya mbo, cja̱ gui coti car goxtji, gui ña̱hui quer Tzi Ta ca bí bbʉ ji̱tzi. Guegue i cca̱hti ca jin gui cca̱hti yʉ cja̱hni, cja̱ da ddahqui hnar cosa drá ndo zö. ");
INSERT INTO otsNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nuquɛjʉ, bbʉ guí orajʉ, dyo guí ncjajʉ ncja ngu̱ cʉ cja̱hni cʉ jin gui meya ca Ocja̱. Guegue‑cʉ́ i hna ma̱ndi cʉ tsjödi, cja̱ jin gui mbe̱ni te i ne da ma̱n cʉ palabra. I mbe̱nijʉ, jøntsjɛ bbʉ da dedijʉ ʉr tsjödi, nubbʉ́, da dyøh ca Ocja̱, bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nuquiguɛjʉ, jin gui yojpijʉ rá ngu̱ vez ca gui dyöjpijʉ ca Ocja̱. Co guehca̱ ya xcú xifi, guegue da dyøjtiqui. Porque i pa̱h quer Tzi Tajʉ ter bɛh ca̱ guí nestajʉ, ante que gui dyöjpijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nuquiguɛjʉ, bbʉ guí nzojmʉ ca Ocja̱, cʉ palabra cʉ gui xijmʉ da ncjá ncja ngu̱ ya gu xihquijʉ ya. Gui hñi̱na̱jʉ: Nuquiguɛ, ʉm Tzi Taquije, guí bbʉh pʉ jar ji̱tzi, Dí i̱zquije gú Ocja̱‑guɛ, ");
INSERT INTO otsNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tzin drí hñe̱h car pa bbʉ xtí mandado hua jar jöy, Gui föxquije gu øtije hua jar jöy ca guí neguɛ, como ngu̱ ga ttøti pʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gui ddajquije tzʉ ca gu tzije rá pa ya. ");
INSERT INTO otsNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cja̱ gui perdonaguije ca rá nttzo ca xtú øtije, como ngu̱göje, dí perdonabije cʉm mi̱nga̱‑cja̱hnije ca te xí dyøjtiguije. ");
INSERT INTO otsNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gui nú̱guije tzʉ, pa jin da ttøjtiguije prueba rá pa ya, Cja̱ jin gui jiɛh ca Jin Gui Jo da da̱guije. Porque nuquiguɛ, guí mandado, rá nzɛhqui, cja̱ rí ntzöhui da tti̱zqui göhtjo ʉr tiempo. Ni jabʉ gu tzöyaje ca dár xöjtiquije. Da ncjapʉ, amén. Da ncjanʉ grí nzojmʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Porque bbʉ guí perdonabijʉ yʉ cja̱hni ca te xtrú dyøjtiquijʉ, guejtjo da perdonaquijʉ hne̱je quer Tzi Tajʉ ca bí bbʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cja̱ bbʉ jin guí perdonabijʉ yʉ cja̱hni ca xí dyøjtiquijʉ, guejtjo hne̱je̱ quer Tzi Tajʉ jin da perdonaquijʉ ca xcú dyøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Guejtjo hne̱je̱, bbʉ guí ayunajʉ, jin gui ncjajʉ ncja ngu̱ cʉ cja̱hni cʉ i tɛn ca Ocja̱ jøntsjɛ xøtzetjo. Gueguejʉ i ndo jmi̱du̱, hasta i coxi bbojtzibi jáy ña̱jʉ co jáy carajʉ pa drí ba̱h cʉ pé dda cja̱hni, i ayunajʉ, cja̱ da hñe̱me̱‑cʉ́, más i ndo jonijʉ ca Ocja̱ göhtjo mbo ʉ́r mʉyjʉ. Cierto, dí xihquijʉ, ya xí ncja ca mí ne cʉ cja̱hni‑cʉ. Ya jin te pé da ttuni pʉ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pe nuquiguɛ, bbʉ guí be̱je̱, gui jojqui quer ña̱, cja̱ gui xʉdö, pa da ni̱gui drá zöqui, ");
INSERT INTO otsNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pa jin da ba̱j yʉ cja̱hni ¿cja guí be̱jquɛ? jøntsjɛtjo quer Tzi Ta da ba̱di. Guegue i cca̱hti ca jin gui cca̱hti yʉ cja̱hni, cja̱ da ddahqui ca rí ntzöhui. ");
INSERT INTO otsNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Guejtjo dí xihquijʉ, jin gui jmu̱ntzijʉ rá ngu̱ quir mɛjtijʉ hua jar jöy, porque jin da me̱h cʉ riqueza‑cʉ́. Cʉ ddáa, da nga̱ cʉ ta̱ni zu̱we̱, da zoni, cja̱ cʉ ddáa, da mboxcjuay. Cja̱ cʉ pé ddaa, da jña̱nquijʉ cʉ be̱, da ñʉti ir ngu̱jʉ, tje da gʉjqui. ");
INSERT INTO otsNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pe nuquɛjʉ, gui cjajpijʉ ca rá zö co quir mɛjtijʉ hua jar jöy, pa drí ngu̱jqui car bendición ca bí ttahquijʉ pʉ jar ji̱tzi. Ntju̱mʉy rá zö cʉ riqueza cʉ bí bbʉh pʉ, cja̱ nucʉ́, jin da mpuni. Jin da za cʉ ta̱ni zu̱we̱, jin da mboxcjuay, cja̱ jin da fe̱. ");
INSERT INTO otsNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nu pʉ jabʉ guí pɛhtzi quir mɛjtijʉ cʉ guí ndo nejʉ, guehpʉ rí me ir mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yʉm döjʉ i zø pa drá janijʉ. Bbʉ jin te i cja yir dö, i zø rá zö. Rá zö gri jani pa gui hño göhtjo pʉ jabʉ gui ne, cja̱ car jiahtzi i bbʉ jer mʉy, bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pe bbʉ ya xí ttzoni yir dö, göhtjo ʉr bbɛxu̱y gri hmʉy. Bbʉ ya xí ni̱gui car jiahtzi, pe mbo ir tzi mʉy, i bbʉjti car bbɛxu̱y, nubbʉ́, mero guí ndo bbʉy yapʉ mbo car bbɛxu̱y. ");
INSERT INTO otsNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jin gui tzö bbʉ i ntoja hnar cja̱hni da dɛni yojo jmu̱. Bbʉ di bbʉ yojo quí jmu̱, da ʉhui ca hnáa, nu ca hnáa da johui. I nesta da jiɛh ca hnáa, cja̱ ca pé hnáa, da dɛni. Guehquitjoguɛjʉ, jin gui tzö gui uni ir mʉyjʉ gui pɛjpijʉ ca Ocja̱ bbʉ guí ndo ne gui jña̱jʉ car domi. ");
INSERT INTO otsNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nugö, dí xihquijʉ, dyo guí ntzøtijʉ digue quer nzajquijʉ. Dyo guí i̱na̱jʉ: ¿Ter bɛh ca̱ gu tzijʉ? Guejtjo dyo guí yomfe̱nijʉ, ¿ter bɛh ca̱ grí jñejʉ? Ca Ocja̱ i ddahquijʉ quir cuerpojʉ, cja̱ co quer nzajquijʉ. ¿Cja guí i̱na̱jʉ da zö drá ntji̱ pa pé da ddahquijʉ ca te gui tzijʉ cja̱ co ca te grí jñejʉ? ");
INSERT INTO otsNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gui mbe̱nijʉ ja ncja ga hmʉj yʉ tzi ttzʉntzʉ yʉ i dyo jar ji̱tzi. Nuyʉ́, jin gui tu̱jmʉ semilla, cja̱ jin gui xojmʉ, cja̱ jin gui pɛhtzijʉ ttu̱ pa da mɛhtzi ca da zijʉ. Nu quer Tzi Tajʉ ca bí bbʉ ji̱tzi i wi̱n‑cʉ́. Nuquiguɛjʉ, más guí ndo mu̱huijʉ ni ndra ngue cʉ tzi ttzʉntzʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Tema cja̱hni di pa̱di da jñu̱htzitsjɛ quí cjeya, pa pé da tzi hmʉjtjo? Masque da ndo mbe̱ni ja drí cjajpi, pe jin da jogui. ");
INSERT INTO otsNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Guejtjo hne̱je̱, ¿dyoca̱ guí yomfe̱nijʉ digue quir da̱jtu̱jʉ? Gui mbe̱nijʉ ja i ncja yʉ tzi lirio i jø pʉ jar bbatja. Rá tzi zö ga te, pe jin gui pɛfi pa da dön ca da jie, cja̱ jin gui ji̱ti pa da dyøti quí da̱jtu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nugö, dí xihquijʉ, más rá ndo zö ga ni̱gui hnar tzi lirio ni digue car rey Salomón. Guegue‑cá̱ bbʉ mí je cár da̱jtu̱ ca más már njuɛhtzi, jí̱ mí jñɛjmi ca rá zö ga ni̱gui hna yʉ tzi døni. ");
INSERT INTO otsNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ca Ocja̱ i cjajpi da ndøni cʉ paxi i jø pʉ jar bbatja, i ncjahmʉ i jejti hnár da̱jtu̱ rá tzi zö. Nu cʉ tzi paxi‑cʉ́, rá pa ya i jø, pe ʉr xu̱di, ya xtrú tjøti jar tzibi. Hni̱xquiguɛjʉ guí cja̱hnijʉ, ¿cja jin da jejtiquijʉ ca Ocja̱ hne̱je̱, masque jin tza guí e̱me̱jʉ? ");
INSERT INTO otsNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eso, dyo guí ntzøtijʉ, dyo guí ma̱jmʉ: “¿Jabʉ drí hñe̱h cam jñu̱nijʉ? ¿Tema deje gu tzijʉ? ¿Te grá jñegöjʉ?” ");
INSERT INTO otsNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porque cʉ cja̱hni cʉ jin gui meya ca Ocja̱ i mpɛgui i joni göhtjo yʉ cosa‑yʉ́. Nuquiguɛjʉ, i bbʉh quer Tzi Tajʉ pʉ jar ji̱tzi, cja̱ guegue bí pa̱di göhtjo ca guí nestajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Eso, bbɛto gui jionijʉ ja grí dyøtijʉ ca rá zö ca i ne ca Ocja̱, cja̱ gui mbe̱nijʉ ja gui ncjajʉ pa da tte̱me̱bi cár palabra. Diguebbʉ ya, da ttahquijʉ hne̱je̱ göhtjo cʉ pe dda cosa guí jonijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nugö, dí xihquijʉ, dyo guí ntzøtijʉ te da ncja ʉr xu̱di. Hasta ʉr xu̱di xtí cca̱htijʉ te da ncja. Gui mbe̱nijʉ ja gui cjajpijʉ cʉ i ncja rá pa ya, cja̱ ya jøña̱‑cʉ́.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Bi ma̱n car Jesús: ―Dyo guí tzohmitejʉ, pa jin da dyɛmpiqui quer castigojʉ car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porque bbʉ guí tzohmi yir hñohui, ca Ocja̱ jin da nu̱qui cor ntti̱jqui. Car medida ca grí dyɛmbi quer hñohui, mismo‑ca̱, pé drí dyɛmbiqui car Tzi Ta ji̱tzi, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Dyoca̱ cjuá guí ju̱dö quer hñohui, i o hnar tzi ngʉnza cár dö? ¿Sá jin guí tzöguɛ car za rá nojo i o quer döguɛ? ");
INSERT INTO otsNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Dyoca̱ guí xih quer hñohui: “Cjajma̱, gu ja̱piqui car ngʉnza i o nir dö”? Hni̱xquiguɛ, i o hnar ndo viga quer dö. ");
INSERT INTO otsNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¿Cja guí ma̱nguɛ jin te guí tu̱? ¡Gúr mɛtjri tjojo! Bbɛto gui cjʉhtzi car ndo zatsjɛ i o quer dö, nubbʉ, cja da jogui gui cca̱htibi cár dö quer hñohui, gui cjʉhtzibi car ngʉnza. ");
INSERT INTO otsNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dí xihquijʉ hne̱je̱, gui ntzohmi ter bɛh ca̱ gui uni quer mi̱nga̱‑cja̱hnihui, cja̱ gui mbe̱ni ja ncja grí nzofo. Jí̱ rí ntzöhui gui dyɛmbi cʉ dyo cʉ cosa rá nttzu̱jpi, porque i bbʉy peligro da cja ʉ́r cuɛ, da zaquitjo. Guejtjo, jí̱ rí ntzöhui gui pombijʉ tjebe cʉ zacjua, porque jin da ne‑cʉ, xta di̱ntjo, xta ccɛhtitjo. I bbʉh cʉ dda cja̱hni cʉ jin gui ne da recibi nʉr palabra rá nttzu̱jpi rí hñe̱h ca Ocja̱. Bbʉ ya xcú nzojmʉ cʉ cja̱hni cʉ́, cja̱ i segue i tzanijʉ cár palabra ca Ocja̱, gui jiɛjmʉ bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Gui dyöjpijʉ ca Ocja̱ ca guí nestajʉ, cja̱ xta ddahquijʉ. Gui jionijʉ ca guí nejʉ, cja̱ xquí tötijʉ. Gui nzojmʉ ca Ocja̱, cja̱ xta xoquiquijʉ car goxtji. ");
INSERT INTO otsNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Car cja̱hni ca te i nesta, bbʉ da dyöjpi ca Ocja̱, da ttuni. Car cja̱hni ca te i joni, xta döti. Car cja̱hni ca i nzoh ca Ocja̱, da tsjojquibi car goxtji. ");
INSERT INTO otsNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nuquiguɛ, ¿bbʉ di dyöhqui hnar tju̱jme̱ quer ba̱jtzi, cja̱ güi uni hnar me̱do? Ji̱na̱. ");
INSERT INTO otsNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Cja̱ huá bbʉ di dyöhqui hnar tzi möy, cja güi ungui hnar cci̱ña̱? Ji̱na̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nuquiguɛjʉ, guí cja̱hnitjojʉ, rá nttzo quir mʉyjʉ, pe nde̱jma̱ guí pa̱dijʉ gui un quir ba̱jtzijʉ cʉ cosa rá zö cʉ i nejʉ. Hni̱xjma̱ja̱ quer Tzi Tajʉ ca bí bbʉ jar ji̱tzi, ¿cja jin da un ca rá zö ca to da dyöjpi guegue? ");
INSERT INTO otsNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Rá zö ca i øjtiquijʉ ca Ocja̱. Eso, i nesta gui dyøhtibijʉ ca rá zö quer mi̱nga̱‑cja̱hnijʉ hne̱je̱, ncja ngu̱ gri mbe̱nijʉ da tzøjø. Guejnʉ i ma̱n car ley ca bi zoguijʉ car Moisés, cja̱ guejti cʉ profeta bi ma̱ ncjanʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Car goxtji rá zö pa gui cʉtijʉ, gue ca rá nttzʉhti. Nu car goxtji co car hñu̱ cʉ rá nxi̱di, rí zøti pʉ jar tzibi ca jin gui jui̱ti, cja̱ rá ndo ngu̱ cja̱hni rí ma pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pe i bbʉh pé hnar goxtji cja̱ ba ca̱h pʉ ca hnar hñu̱ rí zøm pʉ jabʉ gui tötijʉ car nzajqui ca jin da tjegue. Rá nttzʉhti car hñu̱‑cá̱, cja̱ te tzi ngu̱di cʉ cja̱hni i pa pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gui mfödijʉ, jin da ma da jiöhquijʉ cʉ dda cja̱hni cʉ da xihquijʉ, gueguejʉ ba ja̱jʉ hnar palabra rí hñe̱h ca Ocja̱. Cʉ jiöjte‑cʉ́, i ni̱gui ncjahmʉ tzi jogui cja̱hnitjojo, pe mbo ʉ́r mʉyjʉ, i ncjajʉ ngu̱ nʉr mi̱hño, rá ndo nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Da jogui gui meyajʉ cʉ jiöjte cja̱hni cʉ ba ja̱ quí palabratsjɛjʉ ncja ngu̱ gri meyajʉ cʉ za. ¿Cja i ddʉjqui uva hnar za gá pɛni? ¿Cja huá i ddʉjqui higo hnar xa̱tta̱? ");
INSERT INTO otsNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Cʉ za rá zö, göhtjo i tu̱ quí ixi rá zö, nu cʉ ttzoza, i tu̱ quí ixi jin gui ttza. ");
INSERT INTO otsNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hnar za drá zö, jin gui tzö da du̱ quí ixi jin di tzö, ni di hnar ttzoza, jin gui tzö da du̱ quí ixi drá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Göhtjo tema za ca jin gui tu̱ quí fruta rá zö, da ttzɛjqui cja̱ da cjöti jar tzibi pa da nzø. ");
INSERT INTO otsNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eso, dí xihquijʉ, por rá ngue quí fruta cʉ i tu̱, grí meyajʉ cʉ za. Guejtjo por rá ngue ca i øti cʉ cja̱hni cʉ ba ja̱nquijʉ hnar palabra, grí meyajʉ ¿cja jogui cja̱hni‑cʉ́ o jiöjtetjo? ");
INSERT INTO otsNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Drá ngu̱ cja̱hni da nzojquigö gá jmu̱, pe jin gui göhtjo‑cʉ́ da ñʉti pʉ jabʉ i mandado ca Ocja̱, jøntsjɛ cʉ to xtrú dyøti ca i ne cam Tzi Tagö ca bí bbʉ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bbʉ xtu e̱h car pa bbʉ xtá ja̱mpi ʉr huɛnda yʉ cja̱hni, drá ngu̱ cja̱hni da xijqui: “Nuquɛ, Tzi Jmu̱, ndí tɛnquigöje hne̱je̱. ¿Cja jin dú xijme cʉ cja̱hni te i ma̱n quer palabra? ¿Cja jin dú nzojtiquije quer tzi tju̱ju̱ bbʉ ndí fonguije cár nda̱ji̱ ca Jin Gui Jo? Guejtjo hne̱je̱ ndí nønije quer tzi tju̱ju̱ cja̱ ndí øtije rá ngu̱ milagro.” Ncjapʉ da xijqui‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nugö, jin gu cuajti cʉ cja̱hni‑cʉ́. Xtá xijmʉ ncjahua: “Nuquɛjʉ, jí̱ ʉm cja̱hniquigöjʉ. Wenijʉ ya, porque guí ndu̱jpitejʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nu ca to da dyøj yʉm palabragö cja̱ da dyøte ncja ngu̱ ga ma̱, i jñɛjmi hnar hñøjø ca i pɛhtzi mfe̱ni rá zö. Bi jiøh cár ngu̱ xøtze hnar ndo me̱do. ");
INSERT INTO otsNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Cja̱ bi ndo wa̱y, bú e̱h cʉ nzøjtje, cja̱ bi hño nda̱ji̱ rá ngu̱. Mí tɛjni car ngu̱ hasta mí ndo jua̱ni. Pe jin gá yøhte, porque xquí tjøh pʉ xøtze hnar me̱do rá nojo. ");
INSERT INTO otsNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nu car cja̱hni ca to da dyøj yʉm palabra dí ma̱, cja̱ jin da dyøjte, guegue i jñɛjmi hnar dondo hñøjø ca bi jiøh cár ngu̱ xøtze cʉ bbomu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bú e̱h car dye co cʉ nzøjtje, cja̱ bi hño nda̱ji̱ rá ngu̱. Bi dɛjni, bi du̱jqui cár ngu̱ hasta bi ndo ngönitsjɛ. Tje bi yøte, como xquí tjøh pʉ xøtze car bbomu̱.― Ncjapʉ gá xih cʉ cja̱hni car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cja̱ bbʉ mí guadi mí ma̱n car Jesús yʉ palabra‑yʉ́, bi ndo hño í mʉy cʉ cja̱hni, como már ndo zö ca mí u̱jti guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Car Jesús mí u̱jti rá zö cár palabra ca Ocja̱, como gue ca Ocja̱ xquí un cár cargo. Jí̱ mí u̱jti ncja ngu̱ cʉ maestro cʉ mí u̱jti cʉ cja̱hni cʉ Escritura. Nucʉ́, jin tza mí ntjumʉy ca mí ma̱jmʉ, como jí̱ mí pa̱dijʉ te i ne da ma̱n cʉ Escritura. ");
INSERT INTO otsNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cja̱ bbʉ mbú ca̱ jar ttøø car Jesús, bú hñɛ cja̱hni rá ngu̱, bi dɛnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nuya bú e̱h hnar döhtji ca mí tzöhui car jnini lepra, ddahtzʉ mír jiøh cár ngø. Bi nda̱ndiña̱jmu̱ pʉ jabʉ már bbʉh car Jesús, bi xifi: ―Nuquɛ, Tzi Jmu̱, bbʉ guí ne gui cjagui car favor, gui cjʉzqui tzʉ na̱r jnini dí tzöbbe.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Diguebbʉ ya, car Jesús bi cjua̱n cár dyɛ, bi dön car döhtji, bi xifi: ―Dyo ya cá̱, dí ne gu föxqui pa gui zö.― Cja̱ nguetica̱ bi joh car döhtji bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cja̱ pé bi ma̱n car Jesús, bbʉ: ―Gui ma ya, pe jin gui ma guír xih cʉ cja̱hni ter bɛh ca̱ xí ncja. Gui ma bú u̱jti car möcja̱, ya xcú jogui, cja̱ gui ña̱htibi ca Ocja̱ pʉ jar altar cʉ zu̱we̱ cʉ bi mandado car Moisés pʉ jar ley. Da ncjapʉ da ba̱j yʉ cja̱hni, ntjumʉy xí joquiqui ca Ocja̱.― Bi xifi ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Diguebbʉ ya car Jesús bi ñʉti jar jñini Capernaum. Cja̱ bú e̱h hnar hñøjø, múr capitán, mí mandadobi hnar partido cʉ sundado. Car capitán bi guati car Jesús, bi dyöjpi hnar favor. ");
INSERT INTO otsNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Bi xifi: ―Nuquiguɛ, Tzi Jmu̱, i jñin car ba̱jtzi hñøjø ca i pɛjpigui. Rá bbɛndi pʉ jam ngu̱. Jin gui tzö da hña̱ni, cja̱ rá ndo ʉ́ cár ndodyo.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Cja̱ bi ma̱n ya car Jesús, bi xifi: ―Mɛ pʉ ya, bbʉ. Gu má cca̱htigö, pa da jogui.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nu car capitán bi da̱di: ―Nuquɛ, Tzi Jmu̱, jí̱ rí ntzöhui gui cʉti jam ngu̱gö, porque jin te dí mu̱göbbe. Jøntsjɛtjo gui ma̱n quer palabra, cja̱ xta joh cam möxte. ");
INSERT INTO otsNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Dí pa̱cö da jogui, como guehquɛ guí ja̱ quer cargo pa gui mandado, cja̱ i ttøjtiqui ca guí ma̱. Ncjagö hne̱je̱, dí pɛhtzi cam cargo, cja̱ i ttøjtigui ca dí ma̱. Cʉ sundado cʉ dí mandado, i øti ca dí bbɛjpi. Ca to dí nzofo, ba e̱je̱, cja̱ ca to dí cu̱y, i pa‑cá̱. Guejtjo hne̱je̱ i bbʉh cʉ ddáa cʉ i mandadoguigö, cja̱ dí øjti ca i ma̱n‑cʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nu car Jesús, bbʉ mí dyøj nʉr palabra xquí ma̱n car capitán, bi ndo mbe̱ni bbʉ, bi ndo tzøjø. Nubbʉ́, bi xih cʉ cja̱hni cʉ mí tɛni: ");
INSERT INTO otsNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","―Cierto, dí xihquijʉ, nʉr hñøjø‑nʉ́ i ndo e̱me̱gui göhtjo mbo ʉ́r mʉy, masque jin gur israelita. Nu cʉ pé dda cja̱hni cʉ xí nguajqui, masque israelita‑cʉ́, pe jin gui e̱me̱gui rá zö como ngu̱‑nʉ́. Nugö, dí xihquijʉ, xtu e̱je̱ rá ngu̱ cja̱hni cʉ jin gui judio, drí hñe̱j nʉ jabʉ rí bøxi jiadi, drí hñe̱j nʉ jabʉ rí ñʉy, cja̱ nucʉ́, da guajqui. Cam Tzi Ta pʉ ji̱tzi da cuajti cʉ cja̱hni‑cʉ́, drí ñʉti pʉ jabʉ i bbʉ guegue. Masque jin gui judio‑cʉ́, da hmʉpjʉ pʉ ji̱tzi co car Abraham, cja̱ co car Isaac, cja̱ co car Jacob. Da mpöjmʉ cja̱ da dyøtijʉ mbaxcjua. ");
INSERT INTO otsNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nu yʉ cja̱hni judio yʉ i ma̱jmʉ ʉ́r tajʉ car Abraham, pe jin gui ne da hñemegui, jin da ñʉtijʉ pʉ jabʉ i mandado ca Ocja̱. Gueguejʉ da cju̱pjʉ, drí möjmʉ tji pʉ jabʉ rá hmɛxu̱y, da hmʉjti pʉ göhtjo ʉr tiempo. Nupʉ da nzonijʉ cja̱ da ndo sufrijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Diguebbʉ ya, car Jesús pé bi nzoh car capitán, bi hñi̱mbi: ―Gui ma ir ngu̱ ya, xta ncja ca xcú dyöjqui, como xcú hñemegui.― Cja̱ car möxte ca mí jñi̱ni, exque bi joh car hora‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Diguebbʉ ya, car Jesús bi ma pʉ jár ngu̱ car Pedro, bi cca̱hti cár too‑cá̱, már oxti pʉ jar gama, mí ca̱x car pa. ");
INSERT INTO otsNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Car Jesús ya, bi dömbi cár dyɛ, cja̱ bi wen car pa, bbʉ. Nguetica̱ bi joh car bbɛjña̱. Bi nantzi, bi hño, bi dyøti te bi zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bbʉ ya xi már cʉh car jiadi, bú ttzi pʉ jabʉ már bbʉh car Jesús rá ndo ngu̱ cja̱hni cʉ mbá yojmi cár nda̱ji̱ ca Jin Gui Jo. Cja̱ car Jesús bi huɛnti cʉ ttzonda̱ji̱, bi fongui, cja̱ bi wen‑cʉ, bbʉ. Guegue bi jojqui göhtjo cʉ cja̱hni cʉ mí jñini. ");
INSERT INTO otsNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ca mír jojqui döhtji car Jesús, bi zʉh car palabra ca xquí ma̱n ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Isaías. Guegue‑ca̱, ya má yabbʉ bi ma̱ ja di ncja ca hnar hñøjø ca di mɛjni ca Ocja̱ hua jar jöy. Bi ma̱ ncjahua: “Guejtsjɛ guegue bi gʉzquijʉ cʉm jñinijʉ cja̱ co göhtjo cʉ te ndí tzöjʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bbʉ mí cca̱hti car Jesús, ya xquí ndo jmu̱ntzi cja̱hni rá ngu̱, hasta ya xi mí i̱tijʉ madé, bi xih quí amigo cʉ mí ntzixihui di mɛhui hnanguadi. Bi hñi̱mbijʉ: ―Möjö, grá ddaxjʉ nʉ pé hnanguadi nʉr deje.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ante que di ñʉtijʉ car barco, bi zøm pʉ jabʉ már bbʉh car Jesús hnar hñøjø múr maestro, mí u̱jti cʉ cja̱hni cʉ Escritura. Guegue‑cá̱ bi guati car Jesús, bi xifi: ―Nuquɛ, Maestro, gu tɛnquigö göhtjo pʉ jabʉ grí ma.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Bi da̱j ya car Jesús, bi xifi di mbe̱ni rá zö, ¿cja ntjumʉy mí ne di dɛni? Bi hñi̱mbi: ―Cʉ mi̱hño i pɛhtzi quí ngu̱ mbo nʉr jöy, cja̱ cʉ ttzʉntzʉ i pɛhtzi quí tzi ngu̱, hne̱je̱. Nuguigö, dúr cja̱hni xpá bbɛnqui hua jar jöy, pe jin tema ngu̱ dí pɛhtzigö.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Diguebbʉ ya, bi guati car Jesús pé hnar hñøjø. Mí yojmi quí amigo car Jesús. Bi ma̱n car hñøjø‑cá̱: ―Nuquɛ, Tzi Jmu̱, ddajqui tzʉ ʉr tsjɛjqui gu ma grí hmʉh pʉm ngu̱ hasta bbʉ xta du̱ cam ta. Nubbʉ, cja xcuá e̱cö xtá tɛnqui, bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nu car Jesús bi xifi, i̱na̱: ―Ji̱na̱. Gui jiɛh cʉ cja̱hni cʉ jin gui ne da dɛngui pa da dyöh quí ánimajʉ. Pe nuquɛ, como ngu̱ xquí töti ca rá zö, gui tij ya, gui tɛngui gu mɛ.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Diguebbʉ ya, car Jesús bi dex car barco, bi möjmʉ quí möxte pa di ddaxjʉ car deje. ");
INSERT INTO otsNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cja̱ bi zɛh car nda̱ji, bi ndo hño, mí ndo föhtzi car deje. Mí tjojta xøtze jar barco car deje, mí cʉti pʉ mbo. Nu car Jesús, ya xi már a̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Cja̱ quí amigo car Jesús bi dyö, bi xijmʉ, i̱mbijʉ: ―Nuquiguɛ, Tzi Jmu̱, gui na̱ntza̱ nttzɛdi, gui cjʉxquije, porque ya xtá cjá̱tije deje, exque ya xtá tu̱je hua.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bi da̱j ya bbʉ car Jesús, i̱na̱: ―¿Casʉ guí ntzu̱jʉ ya? Nuquɛjʉ, jin tza guí e̱me̱jʉ ca Ocja̱.― Diguebbʉ, bi bböh car Jesús, bi huɛhti car nda̱ji̱ co car deje. Cja̱ bi hna tzöya‑cʉ́, bi jui̱gui rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cja̱ mí ndo dyo í mʉyjʉ quí amigo bbʉ mí cca̱htijʉ te xquí ncja. Bi hñöntsjɛjʉ: ―¿Xí ya‑nʉ, ja i ncja‑nʉ bbʉ? Xí dyøjti nʉr deje co car nda̱ji̱ ca xcá nzofo, xí hmöy.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Diguebbʉ ya, car Jesús co quí möxte bi zøtijʉ ca hnanguadi car deje. Bú ca̱jmʉ jar barco, gá möjmʉ pʉ jar jöy ca mí tsjifi Gadara. Cja̱ bú e̱ yojo hñøjø cʉ mí yojmi cár nda̱ji̱ ca Jin Gui Jo, bi zʉdihui car Jesús. Gueguehui xcuí hñe̱jmi pʉ jabʉ mí cjöti cʉ ánima. Már ndo nttzo cʉ hñøjø‑cʉ, mí tøjna̱ ddiji cʉ cja̱hni cʉ mí cuati pʉ, hasta jin to mí ne di tjoh pʉ jabʉ mí dyo‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Guegue‑cʉ́ bi mahtihui nzajqui car Jesús, bi xijmi: ―¿Te dí cjahquibbe, nuquɛ, Jesús, ʉ́r Ttʉqui ca Ocja̱? ¿Cja huá ya xcú e̱je̱ pa gui fonguiguije, masque jim be i tzʉh car hora pa da ttajquije cam castigoje?― Ncjapʉ gá ma̱n cʉ yojo hñøjø‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nuhua rá cjahua, mbá e̱h cʉ yojo hñøjø cʉ mí yojmi cár nda̱ji̱ ca Jin Gui Jo, cja̱ nʉ rá cjanʉ, már ca̱ hnar ndo pártida cʉ zacjua, már ñu̱ni. ");
INSERT INTO otsNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nu cár nda̱ji̱ ca Jin Gui Jo, mí bbʉh pʉ mbo í mʉyhui cʉ hñøjø, cja̱ nucá̱ bi dyöjpi hnar favor car Jesús, bi xifi: ―Bbʉ ya xcú e̱je̱ pa gui fonguigöje, ddajquije ʉr tsjɛjqui gu möjme nʉ jabʉ rá ca̱ yʉ zacjua rá ngu̱, gu cʉtije nʉ jáy mʉy‑yʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Cja̱ car Jesús ya bi da̱di: ―Möjmʉ, bbʉ.― Cja̱ bi hna wem pʉ jáy mʉyhui cʉ yojo hñøjø, gá ma pʉ jabʉ már dyo cʉ zacjua, bi ñʉti mbo í mʉy‑cʉ́. Göhtjo car partida cʉ zacjua xí ngʉ ʉr ddiji, xí hna jiøjmʉ desde nʉ jabʉ már ndo nte, xcá jiǿjʉ jar deje, xí cjá̱tijʉ, xí ndu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Diguebbʉ ya, cʉ mödi cʉ mí ɛ cʉ zacjua bi ddagui gá nzøti pʉ jar jñi̱ni pʉ jabʉ güí hñe̱jmʉ. Bú xih cʉ cja̱hni, ddahtzʉ gá xijmʉ göhtjo te xquí ncja, cja̱ co ja gá ncja xquí zö cʉ hñøjø cʉ mí yojma̱hui cár nda̱ji̱ ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Cja̱ diguebbʉ ya, göhtjo cʉ mi̱ngu̱ pʉ jar jñini, bú pøjmʉ bi ntjɛjʉ car Jesús. Cja̱ bbʉ mí ntjɛjʉ ya, bi dyöjpijʉ favor car Jesús di wem pʉ jár jöy gueguejʉ. Eso, bi bøm pʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Diguebbʉ ya, car Jesús pé bi ñʉti car barco, bi ddatzi gá ma hnanguadi car deje, pé bi zøti pʉ jar jñini pʉ jabʉ mír hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Cja̱ nupʉ, bú ttzimpi hnar döhtji, jí̱ mí tzö di hña̱ni, mbá oxti pʉ jár mfi̱di. Car Jesús bi cca̱hti cʉ cja̱hni cʉ mbá ncjʉnijʉ car döhtji, cja̱ bi ba̱di, mí e̱me̱jʉ guegue. Nubbʉ́, bi nzoh car döhtji, bi hñi̱mbi: ―Gui mpöjquɛ ya, ʉm ba̱jtziqui. Ya xí mperdonaqui cʉ rá nttzo cʉ nguí tu̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Már bbʉh pʉ cʉ dda maestro cʉ mí u̱jti cʉ cja̱hni cár palabra ca Ocja̱, már cca̱htijʉ car Jesús. Guegue‑cʉ́ bi ma̱jmʉ mbo í mʉyjʉ: “Jin gui tzö nʉr palabra xí ma̱ nʉr hñøjø‑nʉ́. I ne da cjatsjɛ ca Ocja̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nu car Jesús, bi ba̱di ter bɛh ca̱ már mbenijʉ, cja̱ bi xijmʉ: ―¿Dyoca̱ guí ma̱jmʉ mbo ir mʉyjʉ, rá nttzo nʉr palabra nʉ xtú ma̱? ");
INSERT INTO otsNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nugö, rá nzɛjqui pa gu xij nʉr döhtji: “Ya xí mperdonaqui cʉ rá nttzo cʉ nguí tu̱.” Guejtjo rá nzɛjqui pa gu xifi: “Bböj ya, cja̱ gui hño.” ");
INSERT INTO otsNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pe xtú xij nʉr döhtji nʉr palabra nʉ xtú ma̱ pa güi pa̱quɛjʉ, guejcö dí pɛhtzi cam cargo hua jar jöy pa gu cjʉhtzibi yʉ cja̱hni cʉ rá nttzo cʉ xí dyøte. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy.― Ma ya, car Jesús pé bi nzoh car döhtji, bi hñi̱mbi: ―Nuya, gui bböj ya, gui pantzi quer mfi̱di, gui ma ir ngu̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cja̱ car döhtji bi bböy, bi ma gá ma ʉ́r ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cja̱ bbʉ mí cca̱hti ya cʉ cja̱hni, bi ndo hño í mʉyjʉ, bi mbe̱nijʉ: “¿Ja xcá ncja ya nʉ́?” Guejtjo bi ma̱jmʉ: “Te tza rá ndo nzɛh car Tzi Ta ji̱tzi. Xí un cár cargo nʉr hñøjø‑nʉ́, xí jojqui nʉr döhtji, xí ngʉhtzibi ca rá nttzo ca mí tu̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Diguebbʉ ya, bi wem pʉ car Jesús, bi ma pé hnar lugar, cja̱ bbʉ má tjoh pʉ, bi cca̱hti ca hnar hñøjø, már ju̱ pʉ jar tju̱jni pʉ jabʉ mí ncobra cʉ contribución. Car hñøjø‑cá̱ múr tesorero, mí ju̱ cár tju̱ju̱ múr Mateo. Car Jesús bi nzofo, bi xifi: ―Gui tɛngui.― Car hñøjø ya bi bböy bi mɛhui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hna vez, car Jesús már ju̱ pʉ jar mexa pʉ jár ngu̱ car Mateo, már tzi. Bú e̱je̱ rá ngu̱ cʉ jiöjte hñøjø cʉ mí jmuntzi cʉ impuesto hne̱h cʉ contribución, co pé dda cja̱hni cʉ mí ndu̱jpite. Gueguejʉ bi guatijʉ jar mexa pʉ jabʉ már bbʉh car Jesús co ni quí möxte, bi mi̱pjʉ cja̱ bi zihui‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nu cʉ fariseo, bbʉ mí cca̱htijʉ car Jesús, már tzihui cʉ cja̱hni cʉ mí øti ca rá nttzo, gueguejʉ bi dyön quí möxte car Jesús, bi hñi̱na̱jʉ: ―Nir maestrojʉ, ¿dyoca̱ i tzihui yʉ jiöjte cja̱hni yʉ i cobra cʉ impuesto cja̱ hne̱j yʉ pé dda cja̱hni yʉ i ndu̱jpite?― ");
INSERT INTO otsNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nu car Jesús, bbʉ mí dyøj ya nʉr palabra‑nʉ́, bi da̱di: ―¿Te cja ya? Cʉ cja̱hni cʉ i bbʉy rá zö, jin gui nesta médico. Gue yʉ i jñini i nesta. Guehca̱ dár e̱jcö‑cá̱, pa gu föx‑yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nuquiguɛjʉ, i nesta gui nxödijʉ te i ne da ma̱ nʉr palabra nʉ i ju̱x pʉ jar Escritura. I ma̱n ca Ocja̱: “Dí negö gui jui̱jqui quer hñohui, cja̱ jin tza dí negö gui pöhtijʉ zu̱we̱, gui ña̱jtiguijʉ pʉ jar altar.” Ncjapʉ ga ma̱ guegue. Eso, jin dá e̱jcö pa gua nzoj yʉ cja̱hni yʉ i ma̱ jin te i tu̱. Nugö xtú e̱je̱ pa gu nzoj yʉ i ndu̱jpite pa da jiɛh ca rá nttzo cja̱ da jionijʉ ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Diguebbʉ ya, bú e̱h cʉ dda quí möxte car Juan ca mí xix cʉ cja̱hni, bi guatijʉ car Jesús, cja̱ bi hñönijʉ, i̱na̱jʉ: ―Nugöje co yʉ fariseo, cjaatjo dí ayunaje. Hni̱xjma̱ja̱ yir amigo yʉ i tɛnqui, ¿dyoca̱ jin gui ayuna‑yʉ́?― ");
INSERT INTO otsNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Cja̱ car Jesús bi da̱di, i̱na̱: ―Cʉ cja̱hni cʉ xí ttzix pʉ jar mbaxcjua jabʉ rá cja ntja̱jti, ¿ja drí du̱mʉy‑cʉ́ menta i ttøti car mbaxcjua cja̱ i bbʉjti pʉ car novio? Dí ncjagö pʉ co ni yʉm amigo, como dí yojtije‑yʉ́. Bbʉ xta zøh car pá bbʉ xta ttzix nʉr novio, cja̱ ya jin da hmʉbi yí amigo, nubbʉ́, ja̱a̱, da ayunajʉ bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hnar zɛda̱tu̱, jin gui tzö gui pøhtibi hnar ddadyo da̱tu̱. Bbʉ gui pøhte ncjapʉ, pé xtrí xɛh hnanguadi, cja̱ más da ngu̱jqui ca xí xɛgui. ");
INSERT INTO otsNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Guejti cʉ xifani cʉ ya jin gui na̱xi, jin to da xiti cár jugo cʉ uva. Bbʉ gui dyøte ncjapʉ, da xɛh car xifani, tje da mfön car vino. Gue cʉ xifani rá zö gui xiti car jugo, pa jin da bbɛh car xifani ni digue car vino. Ncjapʉ hne̱je̱ rá nzɛj yʉm mfe̱ni dí xij yʉm amigo yʉ i tɛngui. Bbʉ to da hñeme‑yʉ́, jin gui tzö da dɛn cʉ costumbre cʉ mí tɛni má̱hmɛto.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Car Jesús már xih cʉ cja̱hni yʉ palabra‑yʉ́, cja̱ bi hna zøti pʉ hnar hñøjø, mí pɛhtzi cár cargo pʉ jár ni̱cja̱ cʉ judio. Bi ani jöy pʉ jabʉ már bbʉh car Jesús, cja̱ bi xifi: ―Cja nguehca̱ xí ndu̱ cam tzi tti̱xu̱, pe gui maguɛ tzʉ, gui cöx quer dyɛ, cja̱ pé da mɛhtzi ʉ́r nzajqui.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Diguebbʉ ya, bi bböh car Jesús, bi mɛhui car hñøjø, cja̱ bi dɛni quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bbʉ má pa pʉ, bú hna e̱ hnar bbɛjña̱, bi guati jár xʉtja car Jesús. Guegue, mí jñini, mí xoti cji, ya xquí tzöhui‑cá̱ ngu̱ doce año. Bi zɛtibi cár nttza̱ni cár da̱jtu̱ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Porque mí ma̱ntsjɛ car bbɛjña̱, i̱na̱: ―Bbʉ gu tjömbitjojo nʉ́r da̱jtu̱ guegue‑nʉ́, gu zö.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nu car Jesús bi bböti, bi cca̱hti, cja̱ bi xifi: ―Nuya, gui mpöj ya, ʉm tti̱xu̱qui. Guehca̱ xquí hñemegui, xcú zö.― Cja̱ exque bi zö car bbɛjña̱ car hora‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cja̱ bbʉ mí zøti car Jesús pʉ jár ngu̱ car hñøjø ca mí ja̱ ʉ́r cargo pʉ jár templo cʉ judio, bi cca̱hti cʉ cja̱hni rá ngu cʉ xquí jmuntzi pʉ, már ndo ngue̱nijʉ, cja̱ co cʉ músico, már jʉxti quí tjʉxijʉ, como ya xti ncja car nttögui. ");
INSERT INTO otsNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Car Jesús bi xij ya‑cʉ, i̱na̱: ―Gui möjmʉ ya, jin gui tu̱ nʉr tzi ba̱jtzi bbɛjña̱. Jøntjo ra a̱tjo.― Nu cʉ cja̱hni ya, bi denijʉ car Jesús, como mí pa̱dijʉ, ya xquí du̱ car ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Diguebbʉ ya, car Jesús bi cjajpi bi bøm pʉ cʉ cja̱hni rá ngu̱, cja̱ guegue bi ñʉti pʉ jabʉ már bbɛn car tzi bbɛjña̱, bi pɛntibi cár dyɛ. Nubbʉ, car tzi bbɛjña̱ nguetica̱ bi zö, xní nantzi. ");
INSERT INTO otsNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Cja̱ göhtjo cʉ cja̱hni cʉ mí bbʉ jar lugar‑cá̱ bi dyødejʉ ja ncja xquí nantzi car tzi bbɛjña̱ ca xquí du̱, cja̱ bi xox car Jesús. Cja̱ bi ndo ngöxtejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cja̱ car Jesús ya, bi bøm pʉ jar lugar‑cá̱, má dyo pʉ jar hñu̱, cja̱ pé bi dɛni yojo hñøjø cʉ mí godö. Mí mafi nzajqui, mí i̱na̱hui: ―Nuquiguɛ, xquí hñe̱h pʉ jár cji car rey David pa gui mandadoguije, gui jui̱guigöbbe tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nu car Jesús jin gá nda̱di. Bi zøti pʉ jár ngu̱ guegue, bi ñʉti. Nu cʉ yojo godö bi dɛnihui, pé bi zøti pʉ hne̱je̱, cja̱ bi guatihui car Jesús. Diguebbʉ ya, car Jesús bi dyönihui: ―¿Cja guí e̱me̱hui rá nzɛjqui pa gu xojqui quir döhui?― Cja̱ gueguehui bi da̱dihui: ―Ja̱a̱, Tzi Jmu̱, dí e̱me̱quibbe.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Diguebbʉ ya, car Jesús bi dömbi quí döhui cja̱ bi xijmi: ―Nuya, da xoj yir döhui, como xcú hñemeguihui, rá nzɛjqui pa gu föxquihui.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Cja̱ bi xoh quí döhui bbʉ. Diguebbʉ ya, car Jesús bi ndo ccahtzi cʉ yojo hñøjø, bi xijmi: ―Jin gui ma gui ngöxtehui, guejquigö xtú jojqui quir döhui.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pe guegue bi bønihui, bi ndo ngöxtehui göhtjo pʉ jabʉ mí dyohui. ");
INSERT INTO otsNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Xní bøn cʉ godö, xní zøh cʉ dda cja̱hni, mbá tzí hnar hñøjø, jí̱ mí tzö di ña̱, xquí ntjɛhui cár nda̱ji̱ ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cja̱ car Jesús bi fongui car nda̱ji̱‑cá̱. Diguebbʉ ya, bi ña̱ car hñøjø ca múr ngone jma̱ja̱. Ya xquí jogui. Nu cʉ cja̱hni cʉ már cca̱htijʉ bi ntzu̱jʉ cja̱ bi ndo hño í mʉyjʉ. Bi ma̱jmʉ: ―Nugöjʉ, dí cja̱hni israelitajʉ, í cja̱hniguigöjʉ ca Ocja̱. Ni jabʉ xtú nú̱jʉ hnar milagro ca di jñɛjmi‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nu cʉ fariseo bi ma̱jmʉ: ―Gue ca Jin Gui Jo xí un nʉr Jesús cár ttzɛdi. Guehca̱ i pɛhtzi‑cá̱, eso rí fongui cʉ nda̱ji̱ cʉ jin gui tzö.― ");
INSERT INTO otsNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Diguebbʉ ya, mí dyo car Jesús, mí tjoh pʉ göhtjo cʉ jñini co ni cʉ tzi jñini chi tchʉ. Mí cʉti pʉ mbo cʉ templo, mí u̱jti cʉ cja̱hni cár palabra ca Ocja̱. Mí xijmʉ: ―Ya xí ni̱gui car pá nguí tøhmijʉ. Ya xqui mandado ca Ocja̱ hua jar jöy.― Car Jesús mí cjʉhtzibi göhtjo cʉ jnini cʉ mí tzöhui cʉ cja̱hni, co göhtjo te mar ʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Guegue mí cca̱hti cʉ cja̱hni, mí yomfe̱nijʉ cja̱ mí ntzøtijʉ, como jí̱ mí pa̱di toca̱ di dɛnijʉ. Car Jesús ya, bi jui̱jqui cʉ cja̱hni, como mí ncjajʉ ncja yʉ dɛjti yʉ jin te i bbʉ ʉ́r mödi. ");
INSERT INTO otsNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Diguebbʉ ya car Jesús bi xih quí möxte, i̱na̱: ―Rá ndo ngu yʉ cja̱hni, pe nuquɛjʉ, guí tzi yotjojʉ pa gu mföxjʉ gu xijmʉ toca̱ da hñe̱me̱jʉ. Ncjahmʉ i bbʉ rá ngu car tsjofo, pe tzi yotjo yʉ mɛfi pa da cuajti nʉr semilla. Gui nzojmʉ car Tzi Ta ji̱tzi, gui dyöjpijʉ du pɛjni pé dda mɛfi pa da möx car bbɛfi, como ʉ́r mɛjti guegue car tsjofo.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Diguebbʉ ya, car Jesús bi nzoh cʉ doce quí möxte cʉ xquí juajni cja̱ bi un cár ttzɛdi pa di jojqui göhtjo tema clase cʉ döhtji. Bi bbɛjpi di möx cʉ döhtji, göhtjo pʉ jabʉ di ma, cja̱ di xih cʉ cja̱hni car tzi ddadyo jña̱. Bi xijmʉ di möx cʉ cja̱hni cʉ xquí zʉh cár nda̱ji̱ ca Jin Gui Jo, di fonguibijʉ‑cá̱. Bi xijmʉ guejtjo di gʉhtzibi göhtjo tema jñi̱ni cja̱ co göhtjo te már ʉ́ cʉ di tzöhui cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","I ju̱xcua yí tju̱ju̱ cʉ doce quí möxte cʉ bi hñi̱x car Jesús. Gue cʉ doce cʉ mí tsjifi apóstole: Bbɛto gue car Simón ca i tsjifi ʉr Pedro. Ma ya, gue car Andrés, cár cjua̱da̱ car Pedro. Diguebbʉ ya car Jacobo, cár ttʉ car Zebedeo, co hne̱h car Juan, cár cjua̱da̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Hne̱h car Felipe, hne̱h car Bartolomé, car Tomás, car Mateo ca mí cobra cʉ impuesto. Guejti car Jacobo, cár ttʉ car Alfeo, hne̱h car Lebeo, ca guejtjo mí tsjifi ʉr Tadeo. ");
INSERT INTO otsNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Guejti car Simón ca mí tsjifi múr cananita, cja̱ co car Judas Iscariote. Guegue‑ca̱ bi dö car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Gue yʉ doce hñøjø‑yʉ́ bi mandado car Jesús pa di bønijʉ di nzojmʉ cʉ cja̱hni, di xijmʉ car tzi ddadyo jña̱. Guegue bi bbɛjpi jabʉ di möjmʉ cja̱ co ter bɛh ca̱ di mɛjmʉ. Bi hñi̱mbijʉ: ―Dyo grí möjmʉ pʉ jabʉ i bbʉh cʉ cja̱hni cʉ jin gui meya ca Ocja̱, cja̱ dyo grí cʉtijʉ tema jñini pʉ jar estado Samaria. ");
INSERT INTO otsNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pe gui möjmʉ jabʉ i bbʉh cʉ cja̱hni israelita, gui nzojmʉ‑cʉ́. Nucʉ́, í cja̱hni ca Ocja̱, pe xí wenijʉ, ncja ngu̱ cʉ dɛjti cʉ xí bbɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Göhtjo pʉ jabʉ gui möjmʉ, gui xijmʉ cʉ cja̱hni, “Ya xta ni̱gui ja i ncja ga mandado ca Ocja̱ hua jar jöy.” ");
INSERT INTO otsNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gui cjʉhtzibijʉ cʉ jnini i tzöhui cʉ döhtji, cja̱ gui jojquijʉ cʉ cja̱hni cʉ i tzöhui car jnini lepra, cja̱ gui xoxjʉ cʉ ánima. Rá ndo ngu̱ xí ddahquijʉ ca Ocja̱ co cár tzi pöjö. Hne̱hquiguɛjʉ, gui föxjʉ cʉ cja̱hni ncjadipʉ, göhtjo co quer tzi pöjöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jin te gui ma gui jña̱xjʉ domi pa grí cju̱ti quir gastojʉ jar hñu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Guejtjo, jin gui ma gui ca̱xjʉ hnar ddøza̱ pa gui dyöjpijʉ cʉ cja̱hni te da ddahquijʉ, gui dyʉtijʉ pʉ. Jin gui ca̱xjʉ yojo manga pa gui jiejʉ, cja̱ jin gui cʉxjʉ pé hna pare cʉ zɛxtji, guejtjo jin gui jña̱xjʉ hnar tøjø. Hnar patrón i wi̱n quí mɛfi cʉ i pɛjpi. Ncjadipʉ hne̱je̱, ca Ocja̱ i nú̱ cʉ to i pɛjpi guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Göhtjo pʉ jabʉ gui cʉtijʉ, cʉ jñini rá nojo co cʉ tzi jñini chí tchʉ, gui hñönijʉ ¿jabʉ i bbʉ jogui cja̱hni cʉ di ddahquijʉ ʉr tsjɛjqui gui dyojmʉ pʉ jáy ngu̱‑cʉ́? Nubbʉ, gui cuatijʉ jar ngu̱‑ca̱ hasta gue bbʉ xquí pønijʉ pʉ jar jñini‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bbʉ grí cʉtijʉ hnar ngu̱, gui zɛnguajʉ cʉ mi̱ngu̱, cja̱ gui dyöjpijʉ ca Ocja̱ da mötzi cja̱ da un cár bendición. ");
INSERT INTO otsNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bbʉ xta nu̱quijʉ rá zö cʉ mi̱ngu̱, gui tzoguijʉ hnar bendición, gui xijmʉ, ca Ocja̱ xta möxjʉ. Pe nu bbʉ jin da nú̱quijʉ rá zö cʉ mi̱ngu̱, gui xijmʉ, ca Ocja̱ ya jin da möxjʉ bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Cja̱ bbʉ jin da nequijʉ cʉ mi̱ngu̱ tema lugar, cja̱ jin da nejʉ car palabra ca xquí xijmʉ, nubbʉ, gui pønijʉ pʉ jar ngu̱‑cá̱ o jar jñini‑cá̱. Cja̱ bbʉ xquí pønijʉ, gui tju̱jquijʉ cʉ jöy quir huajʉ pa da fa̱di, ya jim pé grí cojmʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cierto dí xihquigöjʉ, bbʉ xtu e̱h ca Ocja̱, cja̱ da dyʉhtibi ʉr huɛnda yʉ cja̱hni hua jar jöy, drá ndo ngu̱ car castigo ca da ttun car jñi̱ni‑cá̱. Cʉ mi̱ngu̱ pʉ jar jñini Sodoma hne̱h pʉ jar jñini Gomorra da ttuni cár castigo hne̱je̱, pe jin da jñɛjmi car castigo ca da ttun cʉ cja̱hni cʉ jí̱ xcá nequijʉ. Más drá ndo ngu̱ da sufri‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nuya, dí cu̱hquijʉ gui möjmʉ grí nzojmʉ cʉ cja̱hni. Nuquiguɛjʉ, guí jñɛjmʉ dɛjti cʉ da tjoh pʉ jabʉ i bbʉh cʉ lobo. Eso, gui hmʉpjʉ listo pa jin to te da cjahquijʉ, pe guejtjo jin to te gui ma gui dyøhtibijʉ. Gui ncjajʉ ncja ngu̱ cʉ tzi paloma. Gui cjajʉ jogui cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dí xihquijʉ ante que da ncja, gui mfödijʉ, porque nde̱jma̱ da döquijʉ cʉ cja̱hni, da zixquijʉ pʉ jabʉ i bbʉh cʉ autoridad. Da ʉ́nquijʉ, da ma du jʉpiquijʉ co chirio jáy templo cʉ judio. ");
INSERT INTO otsNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Guejtjo por rá nguehca̱ guír tɛnguigöjʉ, da ttzixquijʉ pʉ jabʉ i bbʉh cʉ gobernador cja̱ co cʉ rey pa du ttönquijʉ, ¿toca̱ guí e̱me̱jʉ? Gui ncjua̱nijʉ, bbʉ, pa da dyøh cʉ autoridad cʉ i mandado cja̱ co cʉ pé dda cja̱hni cʉ jin gui meya ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cja̱ bbʉ ya xtrú ndöquijʉ, dyo guí ntzohmijʉ ter bɛh ca̱ gui xijmʉ, porque mero car hora ca xta ttönquijʉ cʉ nttöni, ca Ocja̱ xta xihquijʉ ter bɛh ca̱ gui ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porque jin gui guehquiguɛjʉ gui ña̱jʉ pʉ. Gue cár Espíritu quer Tzi Tajʉ pʉ ji̱tzi da xihquijʉ ter bɛh ca̱ gui tja̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bbʉ xta zøh cʉ pa‑cʉ́, hnar hñøjø da dö cár cjua̱da̱ pa da bböhti por rá nguehca̱ drí hñe̱me̱guigö, cja̱ pé hnar hñøjø ya, da dö cár ttʉ ca i e̱me̱gui hne̱je̱. Cʉ dda ba̱jtzi ya, da cja í dyɛjʉ, da ntu̱jnihui quí tajʉ, cja̱ da mandado pa da bböhti‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Cja̱ da ʉquijʉ göhtjo cʉ cja̱hni por rá nguejquigö. Nu ca to da dɛngui göhtjo ʉ́r vida, cja̱ jin da jiɛguigui, guegue da mɛhtzi car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cja̱ bbʉ da dyøjtiquijʉ tu̱jni cʉ mi̱ngu̱ hnar jñini, gui wenijʉ pʉ, pé grí ddaxjʉ pé hnanguadi. Dí xihquijʉ ncjua̱ni, jin da ntzöhui car tiempo pa gui hñojʉ göhtjo cʉ jñini pʉ jabʉ i bbʉh cʉ cja̱hni israelita, ante que xcuá cojcö pa gu ja̱ cam cargo cja̱ gu mandado. Guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ya xcú dyødejʉ nʉr jña̱‑nʉ́: Jin da tti̱htzibi nʉr möxte más ni ndra ngue nʉ́r maestro. Guejti nʉr muzo, jin da tti̱htzibi más ni ndra ngue nʉ́r jmu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bbʉ da ttøhtibi nʉr möxte ncja ngu̱ xcá ttøhtibi nʉ́r maestro, da jojtjo. Guejti yʉ muzo co nʉ́r jmu̱jʉ, bbʉ da jnu̱ parejo, da jojtjo. Nugö, ya xí tsjijqui dúr jefe cʉ nda̱ji̱ cʉ jin gui tzö. Nuquiguɛjʉ, como guí ncjajʉ ncja ʉm ba̱jtziquijʉ, hne̱hquitjoguɛjʉ, da tsjihquijʉ ttzonda̱ji̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Eso, dí xihquijʉ, jin gui tzu̱jʉ ca te da dyøjtiquijʉ yʉ cja̱hni, porque göhtjo ca i øtijʉ gá ntta̱gui tjojo, hnajpa da ni̱gui. Guejti cʉ cosa cʉ i øti yʉ cja̱hni pe jin gui fa̱j yʉ pa ya, hnajpa da ncca̱hti hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Guejti yʉm palabra yʉ dí xihquijʉ, hua jabʉ jin gui øh cʉ pé dda cja̱hni, bbʉ xta zʉh car tiempo, nuquɛjʉ, xquí ma̱jmʉ pʉ jabʉ göhtjo da dyøde. Cja̱ nʉr palabra nʉ dí xihquijʉ, jønquitsjɛjʉ dí xihquijʉ, xtu e̱h car pa bbʉ xtí majmʉ nzajqui nupʉ jabʉ da dyøde göhtjo cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dyo guí tzu̱jʉ yʉ cja̱hni yʉ da möjtiquijʉ, como nucʉ́, jin gui tzö te da cjajpi quir tzi mʉyjʉ. Nu ca guí nesta gui tzu̱jʉ, gue ca hnáa ca i pɛhtzi ʉ́r ttzɛdi pa da dyɛntiquijʉ pʉ jar tzibi ca jin gui jui̱ti, pʉ jabʉ da bbɛh quer cuerpojʉ co hne̱h quir tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gui mbe̱nijʉ, quer Tzi Tajʉ pʉ ji̱tzi i föh cʉ tzi ttzʉntzʉ cʉ i bbö yojo por hnar veintetjo. Masque jin tza te i mu̱hui, jin gui tu̱ hnáa‑cʉ́ hasta bbʉ xta ma̱n ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Guehquitjoguɛjʉ, bí föhquijʉ quer Tzi Tajʉ, hne̱je̱, hasta i pa̱di tengu̱ quir xta̱jʉ, cada hnáaquiguɛjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dyo guí ntzu̱jʉ bbʉ, más guí mu̱guɛjʉ ni ndra ngue cʉ tzi ttzʉntzʉ rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Car cja̱hni ca da xih cʉ pé ddáa, i e̱me̱gui, guejtigö xtá xih cam Tzi Ta ca bí bbʉ ji̱tzi, ʉm mɛjtigö car cja̱hni‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nu car cja̱hni ca da mɛhtzi ʉ́r tzö, da xih cʉ pé ddáa, jin gui e̱me̱gui guegue, hne̱quigö, xtá xih cam Tzi Ta ca bí bbʉ ji̱tzi, jin gʉm mɛjtigö‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Dyo guí mbe̱nijʉ, nugö xtá e̱jcö pa ya jin da ncja tu̱jni hua jar jöy. Jin gui guehca̱ xtá e̱jcö‑cá̱. Más bien, por rá nguejquigö da ʉjʉ yʉ dda cja̱hni, da ntu̱jnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Xtá e̱jcö pa gu juejqui yʉ cja̱hni. Yʉ ddáa, da dɛngui, cja̱ yʉ pé ddáa ya, da ʉgui. Hnar hñøjø da ntu̱jnihui cár ta, cja̱ hnar bbɛjña̱ da ntujnihui cár me, nu ca pé hnar bbɛjña̱ ya, da ntujnihui cár cö. ");
INSERT INTO otsNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Por rá nguejquigö, jin da jnu̱ rá zö hnar hñøjø ca i ne da dɛnguigö. Gue quí familia cʉ i bbʉh pʉ jár ngu̱ da ncontrahui, da ʉjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Car cja̱hni ca más i ndo ne cár ta o cár me ni ndra nguejquigö, jí̱ rí ntzöhui da dɛnguigö. Guejti car cja̱hni ca más i ndo ne cár ttʉ o cár tti̱xu̱ ni ndra nguejquigö, jí̱ rí ntzöhui da dɛnguigö. ");
INSERT INTO otsNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ca to i ne da dɛngui pe jin gui ne da sufri por rá nguejquigö, jí̱ rí ntzöhui da dɛngui. Car cja̱hni ca i ne da dɛnguigö, da ncjajpi ncja ngu da ncjaguigö, cja̱ nugö gu sufri pʉ jar ponti. ");
INSERT INTO otsNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Car cja̱hni ca jin gui ne da dɛngui, como i ne da möjtsjɛ cár vida, guegue da bbɛh cár vida. Nu ca to da dɛngui göhtjo mbo ʉ́r tzi mʉy, masque xín da bböhti por rá nguejquigö, guegue da döti car nzajqui ca ntju̱mʉy. ");
INSERT INTO otsNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ca to da nu̱quijʉ rá zö por rá nguehca̱ grí tɛnguijʉ, ncjahmʉ guejquigö i nu̱guigö rá zö hne̱je̱, cja̱ co hne̱h car Tzi Ta ji̱tzi ca xpá mɛnquigö. ");
INSERT INTO otsNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Car cja̱hni ca i föx cár mi̱nga̱‑cja̱hnihui porque ʉ́r jmandadero ca Ocja̱ guegue‑cá̱, ca Ocja̱ da nu̱ car cja̱hni ca i mföxte ncjahmʉ dúr jmandadero guegue hne̱je̱. Guejti car cja̱hni ca i tzu̱ ca Ocja̱ cja̱ i föx cár mi̱nga̱‑cja̱hnihui por rá nguehca̱ rí dyøhtibi cár voluntad ca Ocja̱, guejti guegue da jnu̱ ncjahmʉ xtrú dyøti ca rá zö ca xí dyøti ca hnaa. Car Tzi Ta ji̱tzi da cohtzibi ca rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cja̱ bbʉ to da möxi hnáa digue yʉm amigo yʉ i e̱me̱gui, masque jin tza di ntjumʉy‑cá̱, bbʉ da uni ma̱di hna vaso ʉr tsɛtje por rá nguehca̱ rí dɛnguigö, dí xihquijʉ cierto, ca Ocja̱ da cohtzibi car cja̱hni‑cá̱ ca rá zö ca xtrú dyøte.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bbʉ mí guaj ya car Jesús, mí xih quí möxte ter bɛh ca̱ di dyøtijʉ, nubbʉ, bi bøn car lugar‑cá̱, gá ma cʉ tzi jñi̱ni cʉ mí bbʉ cerca pʉ. Hna‑hnáa gá tjojmʉ cʉ tzi jñini‑cʉ́, má predica, má xih cʉ cja̱hni car tzi ddadyo jña̱. Mí xijmʉ, ya xi mí mandado ca Ocja hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Car Juan ca mí xix cʉ cja̱hni, már cjoti pʉ jar födi, pe bi dyøde ter bɛh ca̱ már pɛh car Jesús. Diguebbʉ ya, car Juan bú pɛjni yo quí möxte, bi mɛhui pʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Gueguehui bi dyönihui car Jesús, i̱na̱: ―Nuquiguɛ, ¿cja guehquɛ gúr cja̱hni ndí tøpiquije, cja huá hnahño dí tøhmije? ¿Cja guehquɛ gúr Cristo, xí hñi̱xqui ca Ocja̱, cja huá ji̱na̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Cja̱ bi da̱h car Jesús, bi xijmi: ―Mɛguehui ya, bú xijmi car Juan te xcú dyøjmi cja̱ te xcú cca̱htihui. ");
INSERT INTO otsNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gui xijmi, xcú cca̱htihui cʉ cja̱hni cʉ mí godö, cja̱ ya xqui janti‑cʉ́, guejti cʉ mí dohua, xcú cca̱htihui ya xqui dyo‑cʉ́. Xcú cca̱htihui cʉ döhtji cʉ mí tzöhui car jnini lepra, cja̱ ya xí jogui. Guejti cʉ mí gogu̱, ya xqui øde. Hasta cʉ dda ánima, ya xí nantzi. Guejtjo xcú dyødehui, ya xqui tsjij yʉ tzi probe ja ncja drí döti car nzajqui ca jin da tjegue. Ya xí ncja cʉ bi ma̱n cʉ profeta ya má yabbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Cja̱ pé gui xijmi car Juan, da ndo ttuni bendición yʉ cja̱hni yʉ da hñe̱me̱ göhtjo mbo ʉ́r tzi mʉyjʉ, guejquigö xpá mɛnqui car Tzi Ta ji̱tzi, cja̱ jin da jiɛh ca drí hñe̱me̱gui.― Ncjapʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bbʉ ya xquí ma quí möxte car Juan, bi mʉh car Jesús bi xih cʉ cja̱hni cʉ xquí jmu̱ntzi, ja mí ncja car Juan, cja̱ co cár cargo ca mí pɛhtzi. Bi ma̱: ―Nuquɛjʉ, gú möjmʉ pʉ jabʉ jin to i hña̱ni, gú cca̱htijʉ car Juan. ¿Ja mí ncja guegue? ¿Cja jí̱ mí pa̱di te di xihquijʉ? ¡Ngué! Mí pa̱h‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Cja huá nguí ma̱jmʉ di jie da̱jtu̱ drá tzi zö car Juan, eso gú möjmʉ gú cca̱htijʉ tzʉ́? Pe jin te ntjumʉy quí da̱jtu̱ i je guegue. Nu cʉ cja̱hni cʉ i je da̱jtu̱ gá lujo, i bbʉh pʉ jáy ngu̱ cʉ rey. ");
INSERT INTO otsNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Nuquɛjʉ, cja jin gú möjmʉ pʉ jabʉ jin to i hña̱ni pa güi cca̱htijʉ hnár jmandadero ca Ocja̱? ¡Guehcá̱! Dí xihquijʉ cierto, ʉ́r jmandadero ca Ocja̱ car Juan, cja̱ i ndo ja̱ cár cargo rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gue car Juan ca i ma̱n car Escritura nu pʉ jabʉ i ña̱ digue ca hnár jmandadero ca Ocja̱ ca di hñe̱je̱, bbʉ ya xti mʉdi xti mandado ca Ocja̱ hua jar jöy. I ma̱ ncjahua: Cca̱htijma̱, gu pɛjni nʉm jmandadero. Guegue‑nʉ́ da hmɛto, cja̱ nuquiguɛ, xquí hmɛfa. Guegue‑nʉ́ da nzoh cʉ cja̱hni, da xijmʉ, ya xcuá e̱quɛ. Ncjapʉ ga ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cierto dí xihquijʉ, jin tema jmandadero ca Ocja̱ xí ni̱gui hua jar jöy ca di ja̱ cár cargo drá ngu̱ ncja ngu̱ ca i pɛhtzi car Juan. Guejtjo dí xihquijʉ, más drá ndo zö ca da döti cʉ cja̱hnitjo cʉ da nú̱ cár jmandado ca Ocja̱ hua jar jöy, bbʉ ya xtrú cumpli ca Ocja̱ ca xí ma̱. Nucʉ́, masque di cja̱hnitjo cʉ jin te di bbʉh quí cargo, más drá ndo zö ca da dötijʉ ni ndra ngue ca bi döti car Juan. ");
INSERT INTO otsNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bbʉ mí mʉdi mí predica car Juan ca mí xix cʉ cja̱hni, nubbʉ́ bi mʉdi bi ni̱gui cár jmandado ca Ocja̱ hua jar jöy cja̱ co cár ttzɛdi‑cá̱. Hasta rá paya, i ni̱guitjo cár ttzɛdi, cja̱ cʉ cja̱hni rá nzɛdi i chalajʉ, i mpɛguijʉ pa da guajquigö, cja̱ da hmʉpjʉ jabʉ da jña̱jʉ cʉ bendición cʉ rí hñe̱ jár jmandado ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Quí jmandadero ca Ocja̱ cʉ mí bbʉ má yabbʉ, cja̱ hne̱h car ley ca bi dyøti car Moisés, göhtjo‑cʉ́ mí ma̱ te di ncja bbʉ di ni̱gui hua jar jöy cár jmandado ca Ocja̱. Gá nga̱x ya, bú e̱h car Juan, Nubbʉ́, bi mʉdi bi ncja cʉ xquí ma̱n cʉ pé dda quí jmandadero ca Ocja̱ má̱hmɛto. ");
INSERT INTO otsNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Guegue‑cʉ́ xquí ma̱, bbʉ di tzi bbɛjtjo pa di hñe̱h car Cristo ca di bbɛjni pa di mandado, primero di hñe̱h ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Elías. Nu cʉ to mí ma̱jmʉ ncjapʉ, mí ña̱jʉ digue car Juan ca i xix yʉ cja̱hni. Nuquiguɛjʉ, jin guí ne gui hñe̱me̱jʉ ¿cja ya xí nzʉh ca mí ma̱n cʉ profeta? ");
INSERT INTO otsNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yʉ to i bbʉj yí gu̱, da dyøde te i ne da ma̱n yʉ palabra‑yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Ter bɛh ca̱ gár jɛquigö yʉ cja̱hni yʉ i bbʉj yʉ pa ya? I jñɛjmʉ cʉ ba̱jtzi cʉ i ju̱h pʉ jar töy, i huɛhti quí hñohui, i xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Xtú jʉxtiquijʉ yʉm tjʉxije pa güi ni̱pjʉ, cja̱ nuquɛjʉ, jí̱ xquí ni̱pjʉ. Xtú nzonije gá hñögui, cja̱ nuquɛjʉ, jí̱ xquí zontibijʉ car ánima.” I ncjapʉ yʉ cja̱hni yʉ i bbʉj yʉ pa ya. ");
INSERT INTO otsNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Porque bú e̱h car Juan ca i xix yʉ cja̱hni. Jin gui ñu̱ni rá ngu̱, cja̱ jin te i tzi bebida yʉ rí nti̱ yʉ cja̱hni. Nubbʉ, bi ma̱n yʉ cja̱hni: “Nunʉ́, i hñohui cár nda̱ji̱ ca Jin Gui Jo.” ");
INSERT INTO otsNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Diguebbʉ ya, pé dú e̱cö, nugö dúr cja̱hni xpá bbɛnqui hua jar jöy. Dí ñu̱ni rá zö, cja̱ dí tzí tzʉ ʉr vino. Cja̱ nuya i ma̱n yʉ cja̱hni: “Ndíguɛ ya, nunʉ́, ʉr ttzodyo‑nʉ́, cja̱ i ndo tzi vino rá ngu̱. I ntzixihui cʉ jiöjte hñøjø cʉ i jmu̱ntzi cʉ contribución, cja̱ co pé dda cja̱hni cʉ i ndu̱jpite.” I ncjapʉ gri ma̱jmʉ, nuquɛjʉ, jin guí ne gui hñe̱me̱jʉ yʉ to xpá mɛjni ca Ocja̱. Yí jmandadero guegue‑ca̱, xí ttungui jogui mfe̱ni. Masque di ayuna‑yʉ o di pa mbaxcjua, i fa̱di, göhtjo guá hñe̱h ca Ocja̱. Yʉ cja̱hni yʉ i øjti car palabra ca ba ja̱ yí jmandadero ca Ocja̱, i bbʉpjʉ hnar vida rá zö. Ncjapʉ ga ni̱gui, cierto guá hñe̱h ca Ocja̱ cʉ mfe̱ni cja̱ co car palabra ca xí tsjijmʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Diguebbʉ ya, car Jesús bi mʉdi bi huɛnti cʉ cja̱hni, mi̱ngu̱ pʉ jabʉ xquí dyøti milagro rá ndo ngu̱. Cʉ cja̱hni‑cʉ́, jí̱ xquí jiɛjmʉ ca mír dyøtijʉ ca rá nttzo, cja̱ jí̱ xquí jionijʉ ca Ocja̱. Bi nzoh cʉ cja̱hni‑cʉ́, bi xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Nuquiguɛjʉ, guí mi̱ngu̱jʉ car jñi̱ni Corazín co car jñi̱ni Betsaida, gui ma gui sufrijʉ rá ngu̱. Porque xcú cca̱htijʉ rá ndo ngu̱ milagro, cja̱ jí̱ xquí jionijʉ ca Ocja̱. Bbʉ di ttøti pʉ jar jñi̱ni Tiro co pʉ jar jñi̱ni Sidón cʉ milagro xtú øtigö pʉ jabʉ guí bbʉpjʉ, cʉ mi̱ngu̱ pʉ Tiro cja̱ co pʉ Sidón, ya má yabbʉ xtrú jiɛjmʉ ca rá nttzo, xtrú hñe̱me̱jʉ ca Ocja̱. Guegue‑cʉ, xtrú jie quí da̱jtu̱ rá hñøxque cja̱ xtrú dyʉxi bojtzibi jáy ña̱jʉ pa di ni̱gui, xí repentijʉ cja̱ xí jionijʉ ca Ocja̱, göhtjo mbo ʉ́r mʉyjʉ. Nuquiguɛjʉ, jí̱ xquí repentijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eso, dí xihquijʉ, car pa bbʉ xtu e̱h ca Ocja̱ pa da cja ʉr nzöya, más drá ndo ʉ́ car castigo ca da ttahquijʉ ni digue car castigo ca da ttun cʉ mi̱ngu̱ car jñi̱ni Tiro co car jñi̱ni Sidón. ");
INSERT INTO otsNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Guehquitjoguɛjʉ, guí mi̱ngu̱jʉ Capernaum, xcú hñi̱xtsjɛjʉ hasta guejnʉ jar ji̱tzi, pe dí xihquijʉ, da tjøhti nir jñi̱nijʉ, da mpum pʉ jar jöy, como jí̱ xquí hñe̱me̱guijʉ. Porque bbʉ xtrú ttøti milagro pʉ jar jñi̱ni Sodoma ncja ngu̱ cʉ xtú øtigö hua Capernaum, cʉ mi̱ngu̱ pʉ, ya má yabbʉ xtrú repentijʉ cja̱ xtrú jionijʉ ca Ocja̱. Nubbʉ, jin di mpun car jñi̱ni‑cá̱. Di bbʉjti ya, hasta rá pa ya. ");
INSERT INTO otsNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eso, dí xihquijʉ, guí mi̱ngu̱jʉ Capernaum, car pa bbʉ xta ncja car juicio, xta ttahqui quer castigojʉ más drá ndo ʉ́ ni digue car castigo ca da ttun cʉ mi̱ngu̱ Sodoma cja̱ co cʉ jñi̱ni cʉ mí nzøtitjohui.― ");
INSERT INTO otsNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Cʉ pa‑cʉ́, ca hnar vez, car Jesús bi nzoh cár Tzi Ta ji̱tzi, bi ma̱: ―Nuquɛ, ʉm Tzi Taqui, rá ndo zö quer mfe̱ni. Guí mandado pʉ jar ji̱tzi co hne̱cua jar jöy. Jin gui gue cʉ cja̱hni cʉ i pɛhtzi mfe̱ni rá ngu̱ co ni cʉ xí nxödi rá ngu̱ i pa̱di toquiguɛ. Jin gui pa̱h‑cʉ́, como nuquiguɛ, jí̱ xquí ne güi u̱jti ja guí ncjaguɛ. Nu cʉ cja̱hni cʉ jin tza te i pa̱di, cʉ i jñɛjtihui cʉ tzi ba̱jtzi, guehcʉ́ xcú u̱jti ja guí ncjaguɛ. ");
INSERT INTO otsNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Rá zö ca guí øte, ʉm Tzi Taqui. Dí öhqui mpöjcje xcú mbe̱ni xcú dyøte ncjapʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cja̱ pé bi ma̱n car Jesús: ―Cam Tzi Ta bi ddajqui cam cargo cja̱ xpá mɛnquigö hua jar jöy, eso dí pa̱di rá zö göhtjo ja i ncja guegue. Jin to i cca̱jtigui mbo nʉm tzi mʉy, nugö ʉ́r Ttʉgui ca Ocja̱, jøña̱ cam Tzi Ta ca bí bbʉ jar ji̱tzi. Guejtjo, jin to i pa̱di göhtjo ja i ncja cam Tzi Ta ji̱tzi, jønguitsjɛgö, dí pa̱cö como ʉ́r Ttʉguigö‑cá̱, cja̱ guejti cʉ cja̱hni cʉ xtú xijmʉ ja i ncja guegue, guejti‑cʉ i pa̱h‑cʉ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Diguebbʉ ya, car Jesús bi nzoh cʉ cja̱hni, bi hñi̱na̱: ―Nuquiguɛjʉ, dí nzohquijʉ, göhtjoquiguɛjʉ, guí ndo pɛjmʉ nttzɛdi cja̱ guí tu̱jʉ ca rá jñʉ. Bú e̱jmʉ hua. Nugö, gu cjʉzqui quir bbötzijʉ, pa gui tzöyajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gui jñɛguijʉ pa gu wɛjtiquijʉ nʉm yugogö, cja̱ gui nxödijʉ ca xtá u̱jtiquijʉ. Nugö, dí pɛhtzi ntti̱jqui. Ddahtzʉ xcrá ɛquijʉ, cja̱ jin gu pojpiqui ir cuɛjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jin da zahquijʉ nʉm yugogö, cja̱ jin tza i jñʉ ca gu ɛquijʉ gui cjʉtijʉ.― Ncjapʉ gá ma̱n car Jesús, bbʉ már nzoh cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ca hnajpa, múr pa ca mí tzöya cʉ judio. Nu car Jesús má tjoh pʉ já jua̱ttɛy, má yojmi quí möxte. Guegue‑cʉ́ mí tu̱ntju̱, cja̱ bi mʉdi bi dʉjqui cʉ ña̱ttɛy, mí ta̱jmi co quí dyɛ mí tzadijʉ cʉ tzi ttɛy. ");
INSERT INTO otsNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mí bbʉh pʉ hne̱je̱ cʉ dda fariseo, cja̱ nucʉ́, bi xijmʉ car Jesús, bi hñi̱na̱jʉ: ―Cca̱htijma̱ yir amigo yʉ i tɛnqui. Ya xqui pɛj‑yʉ́, ya xqui ta̱jmi ttɛy nʉr pa ya. Jin gui tzö da ttøti‑nʉ́ nʉr pa nʉ dí tzöyajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bi da̱j ya car Jesús, i̱na̱: ―¿Cja jin guí cca̱htijʉ car Escritura pʉ jabʉ i ma̱ ter bɛh ca̱ bi dyøti ca ndor David? Guegue mí tu̱ntju̱ co hne̱h cʉ hñøjø cʉ mí yojmi. ");
INSERT INTO otsNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Cja̱ car David bi ñʉti jár ngu̱ ca Ocja̱, bi zi cʉ tju̱jme̱ cʉ xquí jña̱htibi ca Ocja̱. Mí nttzu̱jpi cʉ tju̱jme̱‑cʉ́. Jí̱ mí tjɛgui to di zi, jøña̱ cʉ möcja̱. Pe nde̱jma̱ bi zi guegue co cʉ hñøjø cʉ mí yojmi. ");
INSERT INTO otsNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Guejtjo, ¿jin guí cca̱htijʉ jár ley car Moisés, jabʉ i ma̱, da tjɛh cʉ möcja̱ da jojquijʉ car templo nʉr pa nʉ dí tzöyajʉ? Como rá nttzu̱jpi hne̱je̱ car templo, jin tema nttzojqui i tu̱ cʉ möcja̱ bbʉ i pɛjmʉ pʉ, nʉr pa gá nttzöya. ");
INSERT INTO otsNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nugö dí xihquijʉ, ya xí ni̱gui ca hnar cosa ca más i mu̱hui ni digue car templo. ");
INSERT INTO otsNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nuquiguëjʉ, jin guí pa̱dijʉ te i ne da ma̱ nʉr palabra nʉ bi ma̱n ca Ocja̱ pʉ jar Escritura: “Nugö, dí ne gui jui̱jqui quir hñohuijʉ, cja̱ jin tza dí negö cʉ zu̱we̱ cʉ guí ña̱jtiguijʉ pʉ jar altar.” Ncjapʉ ga ma̱n car Tzi Ta ji̱tzi. Nugö, pé dí xihquijʉ, bbʉ gri jui̱jqui yir mi̱nga̱‑cja̱hnijʉ, nubbʉ, jin güi jiøxjʉ ca rá nttzo yʉ cja̱hni yʉ jin te i tu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy, cja̱ dí pɛhtzi derecho gu mandado ter bɛh ca̱ da ttøti nʉr pa nʉ dí tzöyajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Diguebbʉ ya, car Jesús bi ma gá ñʉti jár templo cʉ judio. ");
INSERT INTO otsNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Már bbʉh pʉ jar templo hnar hñøjø, xquí dyoti ca hnár dyɛ. Cja̱ cʉ cja̱hni cʉ mí fariseo bi dyön car Jesús, bi hñi̱mbijʉ: ―¿Cja rá zö bbʉ to da dyøtje döhtji nʉr pa nʉ gá nttzöya?― Guegue‑cʉ́ bi dyönijʉ ncjapʉ, como mí jonijʉ te di jiøxjʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nu car Jesús bi da̱di, i̱na̱: ―Bbʉ to di hñi̱h hnar dɛjti, cja̱ nuca̱ di tzo hnar ohtzi rá je̱ nʉr pa gá nttzöya, ¿cja jin di ga̱ti pʉ cár jmu̱ di gʉtzi? Dí i̱ngö, di gʉtzi. ");
INSERT INTO otsNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Más i ndo mu̱hui hnar hñøjø ni digue hnar dɛjti. Eso, dí ma̱ngö, nde̱jma̱ bí jogui pa gu föxjʉ yʉm hñohuijʉ nʉr pa nʉ dí tzöyajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Diguebbʉ ya, car Jesús bi xih car hñøjø ca xquí dyoti cár dyɛ: ―Majqui quer dyɛ ya.― Guegue bi majqui, bbʉ, cja̱ bi joh cár dyɛ, bi goji ncja ngu̱ ca hnaa. ");
INSERT INTO otsNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Diguebbʉ ya bi bøn cʉ fariseo, bi ña̱tsjɛjʉ ja di ncja pa di möhtijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nu car Jesús mí pa̱di te mí mbe̱n quí contra, eso, bi wen car lugar‑cá̱. Cja̱ bi dɛnijʉ rá ngu̱ cja̱hni, cja̱ guegue mí dyøtje göhtjo cʉ döhtji. ");
INSERT INTO otsNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Cʉ cja̱hni cʉ mí dyøtje car Jesús, guegue mí ccahtzi pa jin to di göxjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bbʉ mí ccahtzi cʉ cja̱hni pa jin di ngöxtejʉ, bi zʉh ca hnar palabra ca bi ma̱n car profeta Isaías, ya má yabbʉ. Bi ma̱ ncjahua: ");
INSERT INTO otsNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jiantijma̱, nʉm jmandadero nʉ xtú i̱tzi pa da cja ʉr nzöya. Dí ma̱di, cja̱ i tzøj nʉm mʉy. Gu uni nʉm tzi Espíritu pa da yojmi, Da cja ʉr nzöya nʉm jmandadero, da dyøhtibi jujticia cʉ cja̱hni cʉ jin gui meya ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Guegue jin da hñɛxihui cár hñohui, cja̱ jin da huɛnihui, Jin da jion car manera ja drí jmeya o ja drí tti̱htzibi. ");
INSERT INTO otsNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Guegue da jui̱jqui cʉ cja̱hni cʉ jin gui nzɛdi, cja̱ da möx cʉ jin te ntjumʉy, Jin da dé pa da dyøti jujticia, cja̱ jin da jiɛh cʉ cja̱hni rá nttzo da da̱pi cʉ jin gui nzɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Göhtjo cʉ hnahño cja̱hni cʉ jin gui pa̱di ja i ncja ca Ocja̱, da døhmi pa da dyødejʉ ter bɛh ca̱ da ma̱n cam jmandadero. Ncjapʉ gá ma̱n car profeta. ");
INSERT INTO otsNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Diguebbʉ ya, bú ttzih pʉ jabʉ már bbʉh car Jesús hnar döhtji ca xquí ntjɛhui cár nda̱ji̱ ca Jin Gui Jo. Múr godö cja̱ múr ngone. Nu car Jesús bi jojqui, cja̱ nubbʉ́, bi zö, bi cca̱hti cja̱ bi ña̱. ");
INSERT INTO otsNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nu cʉ cja̱hni cʉ bi cca̱hti, göhtjo bi ndo hño í mʉyjʉ, cja̱ mí hñöntsjɛjʉ to car Jesús, mí i̱na̱jʉ: ―¿Cja gue nʉr hñøjø‑nʉ́ di hñi̱x car Tzi Ta ji̱tzi pa di mandadoguijʉ ncja ngu̱ nguá mandado car rey David?― ");
INSERT INTO otsNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nu cʉ fariseo, bbʉ mí dyødejʉ ja xquí fongui car ttzonda̱ji̱ car Jesús, bi ma̱jmʉ: ―Nʉr hñøjø‑nʉ́, i föx cár jefe cʉ ttzonda̱ji̱, tzʉdi, ca hnáa ca i tsjifi ʉr Beelzebú, eso, i pɛhtzi poder guegue‑nʉ́ pa da fongui cʉ nda̱ji̱‑cʉ́. Pe bbʉ jin di föx car Beelzebú, jin di jogui di fongui‑cʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nu car Jesús bi ba̱tibi quí mfe̱nijʉ cja̱ bi da̱di: ―Hnar gobierno, bbʉ da juejmi cʉ to i fötzi, nubbʉ, da mpun car gobierno, bbʉ. Guejti cʉ cja̱hni cʉ mi̱ngu̱ hnar jñi̱ni, o cʉ familia cʉ i bbʉh hnar ngu̱, bbʉ jin da mföxjʉ, bbʉ da ntu̱jnijʉ, da mfontijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Guejtji car Satanás, bbʉ di jueguehui quí möxte cʉ i mandadobi cja̱ di fongui‑cʉ́, ¿tocʉ pé di bbɛjpi jmandado, bbʉ? ¿Cja jin di mpun cár cargo? ");
INSERT INTO otsNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nugö, dí fongui cʉ nda̱ji̱ cʉ jin gui tzö, pe nuquɛjʉ guí jøxquijʉ dí yobbe cár jefe ca i mandadobi cʉ nda̱ji̱‑cʉ́. Guí ma̱jmʉ, guehcá̱ i föxquigö‑cá̱. Xí cʉ cja̱hni cʉ i tɛnquijʉ cja̱ i fongui cʉ nda̱ji̱ cʉ jin gui tzö, ¿cja güi ma̱jmʉ, guejti‑cʉ́ i yojmi car Beelzebú, hne̱je̱? ¡Ji̱na̱! Güi ma̱jmʉ, gue ca Ocja̱ i föx‑cʉ́. Eso, i fa̱di to ʉ́r ttzɛdi i yojmi nʉr cja̱hni nʉ i fongui ttzonda̱ji̱. ");
INSERT INTO otsNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nugö, dí fongui ttzonda̱ji̱ porque i föxqui cár Tzi Espíritu ca Ocja̱. Eso, da jogui gui pa̱dijʉ, ya xqui mandado ca Ocja̱ hua jar jöy co cár ttzɛdi, como ya xqui hna̱jpi cʉ nda̱ji̱ cʉ jin gui tzö. ");
INSERT INTO otsNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Toca̱ da ñʉti pʉ mbo ʉ́r ngu̱ hnar hñøjø rá nzɛdi pa da gʉjquibi quí mɛjti? ¿Cja jin da nesta bbɛto da du̱hti car mi̱ngu̱, cja̱ diguebbʉ da gʉjquibi cʉ i pɛhtzi pʉ mbo ʉ́r ngu̱? ");
INSERT INTO otsNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Car cja̱hni ca jin gui ne da dɛngui, i ʉgui, cja̱ car cja̱hni ca jin gui föxqui pa gu jmuntzibbe cʉm mɛjti, ncjahmʉ i fontigui cʉm mɛjti. ");
INSERT INTO otsNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eso, dí xihquijʉ, göhtjo tema cosa rá nttzo ca da dyøti yʉ cja̱hni, co göhtjo tema palabra rá nttzo ca da ña̱guigö yʉ cja̱hni, car Tzi Ta ji̱tzi da perdonabi‑cʉ́. Pe bbʉ to da xifi rá nttzo ca i øti car Tzi Espíritu Santo, nucá̱, jin da mperdonabi‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy. Bbʉ to da zanguigö, car Tzi Ta ji̱tzi da perdonabi ca xí ma̱. Pe bbʉ to da xih car Tzi Espíritu Santo guegue Jin Gui Tzö, cja̱ co jin gui tzö ca i øte, jin da mperdonabi, ni digue yʉ pa ya, ni digue bbʉ xta guaj nʉr mundo cja̱ xta ncja car juicio. ");
INSERT INTO otsNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ya xqui fa̱di, bbʉ rá zö hnar za, nubbʉ́, rá zö hne̱je̱ quí ixi cʉ i tu̱. O bbʉ ji̱na̱, bbʉ jin gui tzö car za, nubbʉ́, jin gui tzö hne̱je̱ quí ixi cʉ i tu̱. Por rá ngue ca i tu̱, i fa̱di ja i ncja hnar za. Ncjapʉ hne̱je̱ i fa̱di ja i ncja quí mfe̱ni hnar cja̱hni por rá ngue yʉ i øte. ");
INSERT INTO otsNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nuquëjʉ, guí jiöjtejʉ, guí ncjajʉ ncja ngu̱ nʉr cci̱ña̱. Como rá nttzo quir mʉyjʉ, jin guí pa̱di gui ma̱jmʉ consejo cʉ rá zö. Quí mfe̱ni cʉ i mbe̱n hnar cja̱hni mbo ʉ́r mʉy, guehcʉ́ da ma̱n‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hnar jogui cja̱hni i ma̱ngui palabra rá zö, porque rá zö ca i mbe̱ni mbo ʉ́r mʉy. Nu car cja̱hni ca jin gur jogui cja̱hni i ma̱ palabra jin gui tzö, porque i mbe̱ngui ttzomfe̱ni mbo ʉ́r mʉy. ");
INSERT INTO otsNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Dí xihquijʉ, göhtjo tema palabra ca gui ma̱jmʉ, da nesta gui döjʉ ʉr huɛnda, ¿te rá nguehca̱ gú ma̱jmʉ ncjapʉ? masque xcrú hna ma̱ntjo. Car pa bbʉ xta cja ʉr nzöya ca Ocja̱, da jña̱nquijʉ ʉr huɛnda digue göhtjo cʉ palabra xcrú ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Por rá ngue cʉ palabra cʉ xtrú ma̱ hnar cja̱hni, da njuzga. Da tsjifi, jin te i tu̱, o bbʉ ji̱na̱, nubbʉ, da tsjifi i ndu̱jpite cja̱ da ttɛmbi cár castigo.― ");
INSERT INTO otsNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Diguebbʉ ya, cʉ dda cja̱hni cʉ mí fariseo co ni cʉ dda hñøjø cʉ mí u̱jti cʉ cja̱hni car ley, bi xijmʉ car Jesús, bi hñi̱mbijʉ: ―Nuquɛ, Maestro, dí neje gui u̱jtiguije hnar seña pa gu pa̱dije: ¿Cja cierto xquí hñe̱jquɛ ca Ocja̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bi da̱j ya car Jesús, i̱na̱: ―Yʉ cja̱hni yʉ i öjqui hnar seña, gue yʉ xí jiɛjmʉ ca Ocja̱. Ya jin gui e̱me̱‑yʉ́. Pe nugö, ya jin gu ddahquijʉ pé dda seña, hasta bbʉ xtá ncjagö ncja ngu̱ ca hnár jmandadero ca Ocja̱ ca mí tsjifi car Jonás. ");
INSERT INTO otsNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Guegue‑ca̱ bú dé jñu̱jpa co jñu̱xu̱y pʉ mbo ʉ́r mʉy car ndo möy, cja̱ nugö, xtá u̱jtjogö ncjapʉ hne̱je̱. Gu hmʉh pʉ mbo nʉr jöy jñu̱jpa cja̱ jñu̱xu̱y. Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Car Tzi Ta ji̱tzi bú pɛjni car profeta Jonás pa di ma du nzoh cʉ cja̱hni cʉ mí bbʉ jar jñini Nínive, cja̱ guegue‑cʉ́ bi jiɛjmʉ ca rá nttzo bbʉ mí dyødejʉ te mí ma̱n car Jonás. Cja̱ nuya, xpá bbɛnquigö hua jar jöy pa gu nzohquijʉ. Más rá ji̱tzi cam cargogö ni ndra ngue ca mí pɛhtzi car profeta Jonás. Eso, bbʉ xta ncja car juicio, cja̱ xta nantzi cʉ ánima, cʉ mi̱ngu̱ Nínive da xij yʉ cja̱hni yʉ i bbʉj yʉ pa ya, rí ntzöhui da bbɛdijʉ, porque jí̱ xcá hñemeguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Guejti car reina ca mí mandado ca hnar jöy ca i bbʉh pʉ jar Sur, ndo yapʉ, bú e̱je̱ desde pʉ jabʉ rá cca nʉr jöy, bi guati ca ndor rey Salomón, bi dyøh cʉ tzi jogui mfe̱ni cʉ mí ma̱ guegue, cja̱ bi hñemebi‑cʉ́. Cja̱ nuya, xpá bbɛnquigö hua jar jöy. Más ntjumʉy nʉ dí xihquijʉ ni ndra ngue ca mí ma̱n car Salomón, pe nuquɛjʉ, jin guí ne gui hñemeguijʉ. Eso, bbʉ xta ncja car juicio, car pa bbʉ xta nantzi cʉ ánima, car reina‑cá̱ da xij yʉ cja̱hni yʉ i bbʉ rá pa ya, rí ntzöhui da bbɛdijʉ, porque jí̱ xcá hñemeguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yʉ cja̱hni yʉ i bbʉ rá pa ya, i jñɛjmi hnar cja̱hni ca mí hñojma̱hui cár nda̱ji̱ ca Jin Gui Jo, pe bi mfongui‑cá̱, eso gá mbøni. Nu car ttzonda̱ji̱ ya, rí hñe̱ rí ma, i dyo pʉ jabʉ jin to i hña̱ni, pʉ jabʉ nxøgue rá hñoni, i joni jabʉ pé da hmʉy, cja̱ jin gui töti. ");
INSERT INTO otsNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Diguebbʉ ya i ma̱ntsjɛ: “Pé gu ma grá co jam ngu̱, nu pʉ jabʉ xtú pøjø.” Eso, ba coji, i töti car cja̱hni ca mí yojmi má̱hmɛto. Ya jin te i yojmi ttzonda̱ji̱. Ya xí jñojqui rá zö, como jin te i cja ya. ");
INSERT INTO otsNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nu car ttzonda̱ji̱, xní cca̱hti‑ca̱, xní ma pé du tzí pé yojto quí hñohu i ca Jin Gui Tzö, nucʉ, más drá nttzo ni ndra ngue guegue. Ba e̱h‑cʉ́, i cʉti mbo ʉ́r mʉy car cja̱hni, cja̱ más da ndo ttzombi cár vida car cja̱hni‑cá̱ ni ndra ngue bbʉ mí jøntsjɛ ca hnáa ca mí yojmi má̱hmɛto. Da ncjapʉ hne̱je̱ cár vida yʉ ttzocja̱hni yʉ i bbʉj yʉ pa ya, como nuyʉ́, jin gui ne da hñemegui, cja̱ ya xí jiɛjmʉ ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Car Jesús már u̱jtitjo cʉ cja̱hni, már xijmʉ ncjahua. Cja̱ bi hna zøti pʉ cár me co quí cjua̱da̱, mbí bböjtijʉ pʉ tji. Mí nejʉ di ña̱hui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cja̱ bi hna xih hnar cja̱hni: ―Tji quer me bí bböh pʉ tji, co quir cjua̱da̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Car Jesús ya bi da̱jti car cja̱hni, bi xifi: ―¿Cja guí ne gui pa̱jmʉ to cam me co cʉm cjua̱da̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Diguebbʉ ya, bi majqui cár dyɛ, bi u̱h quí amigo cʉ mí tɛnijʉ, i̱na̱: ―Tji ya yʉ dí cca̱htigö ncja cam me, ncja cʉm cjua̱da̱. ");
INSERT INTO otsNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dí xijmʉ ncjahua yʉ cja̱hni‑yʉ́, porque ca to i øti ca i ne cam Tzi Ta ca bí bbʉ ji̱tzi, gue cam cjua̱da̱gö‑cá̱ o gue cam ncju̱, o gue cam megö hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mismo car pa‑cá̱, car Jesús bi bøm pʉ́r ngu̱, bi ma gá ma pʉ jár nttza̱ni car mar, bú mi̱h pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Cja̱ bi jmu̱ntzi cja̱hni rá ngu̱, már ndo dʉjʉ. Nu car Jesús bi dex car tzi barco, bi mi̱h pʉ, cja̱ göhtjo cʉ dda cja̱hni már bböjti pʉ jár nttza̱ni car deje, már øjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Diguebbʉ ya, car Jesús bi u̱jti cʉ cja̱hni, mí peh cʉ bbede gá ejemplo. Bi ma̱: ―Dyøjma̱jʉ nʉr bbede nʉ dí xihquijʉ. Xí mbøni hnar hñøjø du ponttɛy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bbʉ má pongui ttɛy, cʉ dda ttɛy bi mfonti pʉ hnanguadi car hñu̱. Bú e̱ cʉ ttzʉntzʉ, bi go cʉ ttɛy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Cja̱ pé dda ttɛy ya, bi jiøh pʉ já doo, pʉ jabʉ mí tchʉtjo car jöy. Nucʉ́, bi føxi nttzɛdi, porque jí̱ mí je̱ car jöy pʉ jabʉ mí bboni. ");
INSERT INTO otsNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pe bbʉ mí bøx car jiadi cja̱ bi pati, bi za̱ti cʉ tzi ttɛy, como jin te mí pøh quí dyʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nu cʉ pé dda ttɛy ya, bi jiøh pʉ jabʉ mí ndo cja quí ndö cʉ hmi̱ni̱. Bi te cʉ ttɛy, pe más bi ndo te cʉ hmini, hasta bi gohmi cʉ ttɛy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Guejtjo bi bboni pé dda ttɛy, cja̱ nucʉ́, bi jiøh pʉ jabʉ már zö car jöy. Bi te cʉ ttɛy‑cʉ́, bi ndøn cʉ ña̱ttɛy. Cʉ dda ña̱ttɛy bi ñʉ cien tzi ttɛy, xquí bøxi hnaatjo ʉr semilla. Pé ddáa bi ñʉ sesenta tzi ttɛy, xquí bøxi hnaatjo ʉr semilla. Cja̱ cʉ pé ddáa ya, bi ñʉ treinta tzi ttɛy, xquí bøxi hnaatjo ʉr semilla. ");
INSERT INTO otsNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yʉ to i bbʉj yí gu̱, da dyøde te i ne da ma̱ nʉr bbede‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Diguebbʉ ya, quí möxte car Jesús bi guatijʉ cja̱ bi dyönijʉ: ―¿Dyoca̱ guí xij yʉ cja̱hni yʉ bbede gá ejemplo? ¿Dyoca̱ jin gui nzojti‑yʉ pa da ntiendejʉ rá zö?― ");
INSERT INTO otsNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bi da̱j ya car Jesús, bi xijmʉ: ―Nuquiguɛjʉ, car Tzi Ta ji̱tzi xí möxquijʉ, eso, guí pa̱dijʉ ja ncja ga mandado guegue. Nu yʉ pé dda cja̱hni jin gui pa̱dijʉ ja i ncja cár jmandado, porque jí̱ xcá möx‑yʉ́ car Tzi Ta ji̱tzi. Xtú nzoj yʉ ddáa gá bbedetjo ca xtá xijmʉ ja ncja ga mandado ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nʉr cja̱hni nʉ ya xí tzi mba̱di, más pé da möx car Tzi Ta ji̱tzi, pa más drá ngu̱ da dyøde cja̱ da ba̱di. Nu car cja̱hni ca jí̱ xcá ne xcá mba̱di, ni di gue ca tchʉtjo ca xí dyøde, ya jin da ba̱di ja i ncja‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eso, bbʉ dí u̱jti yʉ cja̱hni yʉ rá ngu̱, dí xijmʉ bbede gá ejemplo. Guegue‑yʉ́, masque i cca̱hti te dí øtigö cja̱ i øde te dí ma̱ngö, nde̱jma̱ jin gui pa̱dijʉ ja ncja ga mandado ca Ocja̱, cja̱ jin gui ntiendejʉ te i ne da ma̱n yʉ bbede dí xijmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Eso, xí nzʉj nʉr palabra nʉ bi jma̱ ya má yabbʉ, bi ma̱n ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Isaías. Bi ma̱ ncjahua, i̱na̱: Xta dyøj yʉ cja̱hni, pe jin da ntiendejʉ; Xta cca̱htijʉ, pe jin da ba̱dijʉ ja i ncja, ");
INSERT INTO otsNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porque ya xí ndo cja me̱mʉy yʉ cja̱hni; Bbʉ jí̱ xtrú cjajʉ me̱mʉy, pe ntoja di cca̱htijʉ cja̱ di ba̱dijʉ ja i ncja, Pé ntoja di dyødejʉ cja̱ guejtjo di ntiendejʉ, Nubbʉ́, di pöti quí mfe̱nijʉ cja̱ di jionijʉ ca Ocja̱, Cja̱ guegue di gʉhtzibi yʉ cja̱hni ca rá nttzo ca i tu̱jʉ. Ncjapʉ gá ma̱n car Isaías. ");
INSERT INTO otsNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pe nuquiguɛjʉ, como ngu̱ guír tɛnguijʉ, xí ndo möxquijʉ ca Ocja̱. Xí xoquijʉ yir döjʉ cja̱ co yir gu̱jʉ pa gui pa̱dijʉ, te i ne da ma̱n yʉ dí øtigö, cja̱ pa gui dyødejʉ te i ne da ma̱n yʉ palabra dí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cierto nʉr palabra dí xihquijʉ, cʉ cjeya cʉ xí tjogui, már ngu̱ cʉ profeta co cʉ pé dda cja̱hni cʉ mí e̱me̱jʉ ca Ocja̱. Guegue‑cʉ́ mí ne di cca̱htijʉ ca hnáa ca di mɛjni car Tzi Ta ji̱tzi, pe jin gá nzʉdi di nú̱jʉ. Mí ne di dyødejʉ te di ma̱ guegue, pe jin gá nzʉdi di dyødejʉ. Nuquɛjʉ, xcú cca̱jtiguijʉ, cja̱ xcú dyødejʉ yʉ palabra yʉ dí ma̱. Xí ttahquijʉ ca hnar bendición rá tzi zö ca mí tøhmi cʉ pé ddáa. ");
INSERT INTO otsNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nuya, gui dyødejʉ te i ne da ma̱n car bbede digue car monttɛy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bbʉ to da dyøj nʉr palabra ja ncja ga mandado ca Ocja̱ hua jar jöy, cja̱ bbʉ jin gui ntiende, nubbʉ́, ba e̱h ca Jin Gui Jo, i ja̱mbitjo car semilla ca xquí bbom pʉ mbo cár mʉy car cja̱hni. Car palabra ca xí dyøde i jñɛjmi cʉ ttɛy cʉ bi mfonti pʉ hnanguadi car hñu̱, gue cʉ bi gʉx cʉ ttzʉntzʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nu cʉ dda ttɛy cʉ bi jiøx pʉ já doo, i jñɛjmi car cja̱hni ca bi mpöh bbʉ mí dyøh cár palabra ca Ocja̱. Nguetica̱ bi hñeme. ");
INSERT INTO otsNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Como jin te i pøh quí dyʉ car semilla‑cá̱, jøndi bbʉ rá zö car tiempo, da te. Cʉ cja̱hni‑cʉ́, bbʉ to da ʉni o da göhmi por rá ngue cár palabra ca Ocja̱, nubbʉ, pé xní pöti cár mfe̱ni. Ya jin gui ne da dɛn cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Cʉ ttɛy cʉ bi jiøh pʉ madé cʉ ndöhmi̱ni, i jñɛjmi car cja̱hni ca i øh car palabra, pe rí ma ʉ́r mʉy yʉ cosa hua jar mundo. Xí jiöhtibi ʉ́r mʉy car domi co cʉ pé dda cosa cʉ i ne da mɛhtzi. Cʉ cosa‑cʉ́, i jñɛjmi cʉ hmi̱ni̱, i cohmijʉ cár palabra ca Ocja̱, i ccahtzi pa jin da joh car semilla. ");
INSERT INTO otsNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nu cʉ ttɛy cʉ bi jiøh pʉ jabʉ már zö car jöy, i jñɛjmi cʉ cja̱hni cʉ i øh car palabra, i ntiende rá zö, cja̱ i e̱me̱ göhtjo mbo ʉ́r mʉy. Nucʉ́, i jñɛjmi cʉ semilla cʉ bi jogui. Cʉ ddáa bi uni cien tzi ttɛy cada hnáa. Cʉ pé ddáa ya, bi uni sesenta tzi ttɛy cada hnáa, cja̱ cʉ pé ddáa ya, bi uni treinta tzi ttɛy cada hnáa. ");
INSERT INTO otsNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Diguebbʉ ya car Jesús pé bi xih cʉ cja̱hni pé hnar bbede gá ejemplo. Nʉr bbede‑nʉ́ i xijquijʉ te da ncja bbʉ xta ntʉngui nʉr tzi ddadyo jña̱ digue cár jmandado ca Ocja̱. øde, pʉ jabʉ xí ntʉngui cár palabra ca Ocja̱, i jñɛjmi hnar jua̱ttɛy. Car hñøjø ca to múr mɛjti car jua̱ttɛy bi mongui semilla rá zö pʉ jár jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bbʉ mí nxu̱y, bbʉ már a̱h cʉ cja̱hni, bú e̱h cár contra car mi̱ngu̱, bi mombi ngʉdi pʉ jabʉ xquí mon cʉ ttɛy, cja̱ pé bi ma. ");
INSERT INTO otsNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bi bøxi ya cʉ ttɛy, cja̱ bbʉ ya xi mí pøx í nga̱, bi ni̱gui pʉ cʉ ngʉdi hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nubbʉ́, bú e̱h cʉ mɛfi, bi dyön cár jmu̱jʉ, i̱na̱jʉ: “Nuquɛ, lamo, ¿cja jí̱ xquí pongui jogui semilla, nxøgue ttɛy? ¿Sá i hua̱nihui ngʉdi ya bbʉ?” ");
INSERT INTO otsNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Cja̱ guegue bi da̱di: “Hnar hñøjø ʉm contra xí ma xpá mon cʉ ngʉdi pʉ jam ttɛy.” Diguebbʉ ya, pé bi dyön cʉ mɛfi: “¿Cja jin guí ne gui cu̱jquije gu ma ccʉhtzije cʉ́?” ");
INSERT INTO otsNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Bi da̱j ya car jmu̱, i̱na̱: “Ji̱na̱, porque bbʉ gui ccʉhtzijʉ‑cʉ́, nde̱jma̱ i bbʉh pʉ jabʉ xtí ccʉhtzijʉ dda ttɛy, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gui jiɛguijʉ göhtjo da te parejo hasta xtrí ntsjattɛy. Nubbʉ́, xtá xijcö cʉ mɛfi cʉ da xattɛy: Bbɛto gui xajʉ cʉ ngʉdi cja̱ gui tu̱htijʉ gá manajo pa gui tjʉtijʉ. Nu car trigo ya, gui tu̱xjʉ drí ma jam ngu̱.”― I ttzɛdi hua nʉr bbede‑nʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Diguebbʉ ya car Jesús pé bi xih cʉ cja̱hni hnar bbede, pa di ba̱dijʉ ja ncja di ngu̱jqui cʉ cja̱hni cʉ di hñeme nʉ́r palabra ca Ocja̱. Bi xijmʉ ncjahua: ―Nʉr palabra nʉ i xijquijʉ ja ncja ga mandado ca Ocja̱ hua jar jöy i jñɛjmi hnár ndö ʉr murtaza. Hnar cja̱hni da gʉ cʉ ndö‑cʉ́, da moni jár jua̱ji̱. Diguebbʉ ya, xta føtze cja̱ xta te. ");
INSERT INTO otsNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cʉ tzi ndö‑murtaza más chi tchʉ ni digue göhtjo cʉ pé dda semilla, pe bbʉ ya xí te car planta, i ta̱pi göhtjo cʉ ccani, rá nte ncja ngu̱ hnar tzi za. Ba e̱h cʉ tzi ttzʉntzʉ, i tex pʉ jáy dyɛ.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Guejtjo, pé bi ma̱n car Jesús nʉ pé hnar bbede gá ejemplo, bi xih cʉ cja̱hni ncjahua: ―Pa gui pa̱dijʉ ja ncja da ngu̱jqui cʉ to da hñe̱me̱bi cár jmandado ca Ocja̱ hua jar jöy, i jñɛjmi ca bi dyøti hnar bbɛjña̱ bbʉ már øti tju̱jme̱. Bi jña̱ car levadura, bi hua̱ntzihui ngu̱ jñu̱ ttɛni car harina. Car levadura bi ngu̱jqui cja̱ bi ntʉngui hasta bi mføntzi göhtjo car cjʉni tju̱jme̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Car Jesús bi xih cʉ cja̱hni göhtjo yʉ palabra‑yʉ́ digue ja ncja ga mandado ca Ocja̱. Göhtjo bbʉ nguá u̱jti cʉ cja̱hni, mí xijmʉ tema bbede gá ejemplo. Jí̱ mí nzojtjo. ");
INSERT INTO otsNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bi ncjapʉ gá cumpli car palabra ca xquí ma̱n car profeta, ya má yabbʉ, i̱na̱: Gu ma̱ngö bbede gá ejemplo bbʉ gár nzoh cʉ cja̱hni, Gu xijmʉ hnar razón ca jí̱ bbe i pa̱dijʉ, Masque ya xquí mbe̱n ca Ocja̱ car mfe̱ni‑cá̱ desde bbʉ mí dyøti nʉr jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Diguebbʉ ya, car Jesús bi gu̱h cʉ cja̱hni di möjmʉ í ngu̱jʉ, cja̱ guegue bi ñʉti pʉ́r ngu̱. Cja̱ bi dɛn quí möxte, bi ñʉtijʉ hne̱je̱, bi dyönijʉ car Jesús: ―Xijquije tzʉ ¿te i ne da ma̱n car bbede digue cʉ ngʉdi cʉ mí hua̱nihui cʉ ttɛy?― ");
INSERT INTO otsNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bi da̱j ya car Jesús, i̱na̱: ―Car hñøjø ca bi mon car semilla ca rá zö, dí jñɛjcöbbe guegue. Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Cja̱ car jua̱ttɛy, i jñɛjmi nʉr mundo. Nu car semilla rá zö ya, gue quí ba̱jtzi ca Ocja̱ cʉ i e̱me̱bi cár jmandado. Cʉ ngʉdi ya, gue quí ba̱jtzi ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Car contra ca bi mon cʉ ngʉdi, gue ca Jin Gui Jo. Car pá bbʉ xta ncja tsjattɛy i jñɛjmi car pa bbʉ xta guaj nʉr mundo cja̱ xta ncja juicio. Cʉ mɛfi cʉ da xa cʉ ttɛy, gue cʉ ángele. ");
INSERT INTO otsNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ncja ngu̱ gá tjejqui yʉ ngʉdi cja̱ bi ddʉti pʉ jar tzibi, da ncjapʉ hne̱je̱ bbʉ xta guaj nʉr mundo. ");
INSERT INTO otsNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nugö, xcuá cu̱h cʉm ángele pa da gʉhtzijʉ göhtjo cʉ cja̱hni cʉ i ʉjʉ ca rá zö, cja̱ co göhtjo cʉ i øti ca rá nttzo. Nugö, xpá bbɛnqui hua jar jöy pa gu mandado. Cʉm ángele da fongui cʉ cja̱hni‑cʉ́ pa jin da hmʉh pʉ jabʉ gu mandado. ");
INSERT INTO otsNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Xta tjøti pʉ jar horno pʉ jabʉ ra zø car tzibi ca jin gui jui̱ti. Nupʉ, xta nzonijʉ cja̱ xta ndo sufrijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nu cʉ cja̱hni cʉ jin te i tu̱, da hmʉh pʉ jabʉ i mandado cár Tzi Tajʉ, da ni̱gui rá tzi zö ncja nʉr jiadi bbʉ i ndo yoti. Bbʉ xcú dyødejʉ nʉr bbede‑nʉ́, gui mbe̱nijʉ te i ne da ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Car Jesús pé bi ma̱ hnar bbede pa di dyøh cʉ cja̱hni, rá ndo zö ca dí tötijʉ bbʉ dí cuatijʉ jár dyɛ ca Ocja̱ pa da mandadoguijʉ. Bi hñi̱na̱: ―Cár jmandado ca Ocja̱ i jñɛjmi domi rá ngu̱ xpá nttöh pʉ madé hnar jua̱ji̱. Már pɛh pʉ hnar hñøjø, bi döti, cja̱ pé bi dyöjtjo, como jí̱ múr mɛjti guegue car jua̱ji̱. Bi ndo mpöjö gá ndöti. Bi gʉ ʉr ddiji, bi ma bú pö göhtjo ca mí pɛhtzi. Diguebbʉ ya bú coji cja̱ bi dön car jua̱ji̱, bi jña̱hmi car domi ca már o pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Guejtjo hne̱je̱ car cja̱hni ca xí nguati jár dyɛ ca Ocja̱ pa da mandadobi, i jñɛjmi hnar döy ca mí töngui perla. Mí jon cʉ perla cʉ más rá njuɛtzi cja̱ más rá nojo, como guehcʉ́, más i ndo mu̱hui. ");
INSERT INTO otsNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bbʉ ya xquí döti ca hnar perla rá ndo zö, mí ndo ne, masque már ndo ma̱di. Eso, bi ma bú pö göhtjo ca mí pɛhtzi, cja̱ pé bú cojya, bi dön car perla‑cá̱. Nubbʉ, bi ndo mpöh bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Guejtjo hne̱je̱ bbʉ xta ntʉngui nʉr palabra nʉ i ma̱, ja ncja ga mandado ca Ocja̱, da jñɛjmi hnar hmamöy, xí bbøti jar mar, xpá tzo pʉ göhtjo tema möy. ");
INSERT INTO otsNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cʉ mamöy, bbʉ ya xqui tzö rá jñʉ car hmamöy, xta gʉxjʉ bbʉ, xtrí ma jár nttza̱ni car mar, xtu mi̱pjʉ pʉ. Xta juajnijʉ cʉ möy rá zö, cja̱ cʉ jin gui tzö ya, pé xta monijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Da ncjapʉ hne̱je̱ bbʉ xtrí guaj nʉr mundo. Ca Ocja̱ du cu̱h quí ángele pa da wejqui quí ba̱jtzi guegue cʉ jin te i tu̱ co cʉ cja̱hni cʉ i ndu̱jpite. ");
INSERT INTO otsNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nu cʉ i ndu̱jpite da tjøti pʉ jar tzibi ca jin gui jui̱ti, pʉ jabʉ da nzonijʉ cja̱ da ndo sufrijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Diguebbʉ ya, bi dyön car Jesús quí möxte: ―¿Cja xcú ntiendejʉ te i ne da ma̱ göhtjo yʉ bbede‑yʉ́?― Cja̱ bi da̱h quí möxte, i̱na̱jʉ: ―Ja̱a̱, xtú ntiendeje.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Cja̱ guegue pé bi xijmʉ: ―Bbʉ xcú ntiendejʉ göhtjo yʉ bbede‑yʉ́, rá ndo zödi bbʉ. Ncjahmʉ xcú cjajʉ rico. Porque hnar hñøjø ca xí nxöh cʉ Escritura cja̱ diguebbʉ ya pé xí mba̱j nʉr tzi ddadyo jña̱ digue ja ga mandado ca Ocja̱, guegue i jñɛjmi hnar rico, rá ndo zö ca i pɛhtzi. Xí nzoquibi quí mɛjti quí ndo í tita, cja̱ jønca̱ pé xí ndöti guegue cár mɛjti tsjɛjɛ. Ca te da ne, ya xtar bbʉh pʉ́r ngu̱. Car hora ca da nesta, jøntjo da ma du ja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cja̱ bbʉ mí guaj ya mí ma̱n yʉ bbede gá ejemplo, car Jesús bi bøm pʉ jar jñi̱ni‑cá̱, ");
INSERT INTO otsNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bi ma gá ma pʉ jar jñini Nazaret, pʉ jabʉ xquí te, cja̱ pé bi u̱jti cʉ cja̱hni pʉ jár templojʉ. Cja̱ bi ndo hño í mʉyjʉ, bi hñöntsjɛjʉ: ―¿Ja xcá mba̱j ya‑nʉ́ göhtjo ca te i ma̱n cár palabra ca Ocja̱? ¿Jabʉ xí nxöj nʉr cja̱hni‑nʉ́ ca rí dyøti milagro? ");
INSERT INTO otsNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Cja jin gui gue nʉ́r ttʉ car yaxi‑nʉ́? ¿Cja jí̱ ʉ́r ttʉ‑nʉ́ car bbɛjña̱ ca i ju̱ cár tju̱ju̱ ʉr María? ¿Cja jí̱ ʉ́r cjua̱da̱‑nʉ́ car Santiago, hne̱h car José, co car Simón, cja̱ co car Judas? ");
INSERT INTO otsNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Cja jin gui bbʉjcua hne̱je̱ göhtjo quí ncju̱? Xi ya, ¿ja i ncja xcá mba̱j nʉr hñøjø‑nʉ́ yʉ i ma̱, cja̱ co yʉ i øte?― Mí ma̱ ncjapʉ quí mi̱ngu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cʉ mi̱ngu̱ Nazaret jí̱ mí ne di hñemejʉ, ¿cja xcuí hñe̱h ca Ocja̱ car Jesús? Nu car Jesús bi ma̱: ―I tti̱htzibi nʉ́r jmandadero ca Ocja̱ göhtjo pʉ jabʉ i pa. Jøntsjɛ pʉ jár jöy guegue cja̱ co pʉ jár ngu̱, nupʉ́, jin gui tti̱htzibi pʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eso, jin gá dyøti rá ngu milagro pʉ. Mí tzi yotjo cʉ milagro bi dyøti pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Cʉ pa‑cʉ́, car Herodes mí mandado jar jöy‑ca̱, cja̱ bi dyøde, mí ndo oti milagro car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nu car Herodes bi mbe̱ni, mí gue car Juan ca mí øti milagro, cja̱ bi xih quí muzo cʉ mí tɛni: ―Ngu̱, ya pé xqui dyo car Juan ca mí xix cʉ cja̱hni. Cierto bi bböhti, cja̱ pé xí nantzi, eso ya xqui ndo ja̱ ʉ́r ttzɛdi, i ndo øti milagro.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Guejtsjɛ car Herodes xquí mandado xquí bböhti car Juan, como guegue mí hñi̱h hnár cjua̱da̱, mí ju̱ cár tju̱ju̱ múr Felipe. Nu cár bbɛjña̱ car Felipe mí ju̱ cár tju̱ju̱ múr Herodías. Car Herodes xquí cuajti cár bbɛjpo, gue car Herodías. Nu car bbɛjña̱‑cá̱ bi bbɛjpi car Herodes di zʉh car Juan. Car Herodes bi cjajpi bbʉ, bi goti födi cja̱ bi da̱ti cadena. Car Herodías mí ʉhui car Juan, ");
INSERT INTO otsNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","porque car Juan mí huɛnti car Herodes, segue mí xifi: ―Jin gui tzö ca gri hmʉbi nir bbɛjpo.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Car Herodes mí ne di möhti car Juan, pero mí tzu̱ cʉ cja̱hni, como nucʉ́ mí i̱htzibi car Juan, mí ma̱jmʉ xcuí mɛjni ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Diguebbʉ ya, bi tzo cár cumpleaño car Herodes, cja̱ bi ttøhtibi hnár mbaxcjua. Cár tti̱xu̱ car Herodías bi ñʉti pʉ jabʉ már ju̱ cʉ cja̱hni, bi ni̱h pʉ, cja̱ bi ndo tzøh car Herodes. ");
INSERT INTO otsNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Guegue ya‑cá̱, bi nzoh car ba̱jtzi bbɛjña̱, bi xifi di dyöjpi ca mí ne, cja̱ bi hñi̱h ca Ocja̱ gá testigo, ntjumʉy di uni ca te di dyöjpi. ");
INSERT INTO otsNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nubbʉ́, car ba̱jtzi bbɛjña̱ bi ma bú ña̱hui cár me, cja̱ guegue‑cá̱ bú consejabi te di dyöjpi. Pé bú coh car ba̱jtzi bbɛjña̱ bbʉ, bi xih car Herodes: ―Dí ne hna moji ca di o cár ña̱ car Juan ca mí xix yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bbʉ mí dyøj ya nʉ́, bi ndo du̱mʉy car Herodes, pe nde̱jma̱ bi mandado di ttøti ca xquí dyöh car ba̱jtzi bbɛjña̱. Como guegue xquí hñi̱h ca Ocja̱, di uni ca te di ttöjpi, cja̱ como már cca̱htijʉ cʉ cja̱hni cʉ már ju̱ pʉ jar mexa, már tøhmijʉ, te di dyøte, ");
INSERT INTO otsNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nde̱jma̱ bi mandado du ttzɛjquibi cár dyʉga car Juan, pʉ jar födi. ");
INSERT INTO otsNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nubbʉ́, bú ttzɛjquibi cár ña̱, bú cjöti hnar moji, cja̱ bú tja̱mpi car ba̱jtzi bbɛjña̱, bi ttuni, cja̱ guegue ya, pé bi un cár me. ");
INSERT INTO otsNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Diguebbʉ ya, bi ma quí möxte car Juan, bi du̱htzibijʉ cár cuerpo, bi ma bú öguijʉ, cja̱ pé bi möjmʉ bú xijmʉ car Jesús te xquí ncjajpi car Juan. ");
INSERT INTO otsNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bbʉ mí dyøj ya car Jesús, bi wentsjɛ pʉ jabʉ már bbʉy, bi dexi hnar tzi barco, gá ma hnanguadi, pʉ jabʉ jin to mí hña̱ni. Cja̱ bbʉ mí dyøh cʉ mi̱ngu̱ cʉ tzi jñi̱ni̱ cʉ már bbʉ cerca pʉ, bi hñɛ cʉ cja̱hni, gá möjmʉ pʉ jabʉ di ga̱h car Jesús bbʉ xti zøti car barco. Má dyodijʉ pʉ jáy nttza̱ni car deje pa di ntjɛjʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bbʉ mí ga̱h car Jesús pʉ jar barco, bi jianti cʉ cja̱hni már ngu̱, ya xquí jmu̱ntzi pʉ, cja̱ bi jui̱jqui, bi jojqui quí döhtjijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bbʉ ya xquí nde, quí möxte car Jesús bi guati, cja̱ bi xijmʉ: ―Nʉr lugar hua jabʉ dí bbʉpjʉ, jin te i bbʉ ngu̱, cja̱ ya xí ndo nde. Gui cu̱j ya yʉ cja̱hni pa da möjmʉ já tzi jñi̱ni yʉ i bbʉ cerca, du töjmʉ te da zijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nu car Jesús bi xijmʉ: ―Jin gui nesta da ma‑yʉ́. Nuquiguɛjʉ, gui unijʉ ca da zi‑yʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Guegue quí möxte bi da̱dijʉ: ―Jin te dá ja̱göje, jøndi cʉtta tzi tju̱jme̱ co yojo tzi möy xtú tötije.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Cja̱ car Jesús bi xijmʉ: ―Bú cʉ́jʉ huá.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Diguebbʉ ya, car Jesús bi bbɛjpi cʉ cja̱hni di mi̱pjʉ já paxi, cja̱ guegue bi gʉ cʉ cʉtta tzi tju̱jme̱, bi nøhtza ji̱tzi, cja̱ bi dyöjpi ca Ocja̱ di bendeci cʉ tju̱jme̱. Ma ya bi jejque, cja̱ bi un quí möxte, cja̱ guegue ya‑cʉ́, bi un cʉ cja̱hni rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Cja̱ göhtjo cʉ cja̱hni bi zijʉ, bi ñi̱ña̱jʉ. Cja̱ quí möxte bi jmuntzijʉ cʉ tzi pedazo cʉ xquí sobra, bi ñu̱htzijʉ doce bbøtze. ");
INSERT INTO otsNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mí zøti cʉtta mil cʉ hñøjø cʉ bi zijʉ. Nu cʉ bbɛjña̱ co cʉ ba̱jtzi, jí̱ mí ttʉti ʉr huɛnda‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Diguebbʉ ya, car Jesús bi xih quí möxte di dex car barco pa di hmɛtojʉ, di ddaxjʉ jar deje cja̱ guegue di gojti pʉ menta di ma cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nubbʉ́, car Jesús bi gu̱h cʉ cja̱hni di möjmʉ í ngu̱jʉ, cja̱ guegue bi bøx jar ttøø, má ddatsjɛ. Bú nzoh ca Ocja̱, bú de pʉ, bú ora, cja̱ bbʉ ya xquí hmɛxu̱y, car Jesús mbí bbʉjti pʉ jar ttøø. ");
INSERT INTO otsNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Car tzi barco ya, ca xquí dex quí möxte car Jesús, má pa madé car mar. Mí jua̱ni, porque mbá e̱h car nda̱ji̱ nʉ jabʉ mír ma car barco, mbá tɛjni cár ña̱. Guejtjo mí ndo mföhtzi car deje. ");
INSERT INTO otsNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bbʉ mí bbɛh tzʉ pa di ni̱gui, car Jesús bú ca̱ jar ttøø. Bi hñodi xøtze car mar, má padi jár xʉtja car barco, bi ma guí zøti pʉ jabʉ má pa car barco. ");
INSERT INTO otsNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nu quí möxte car Jesús ya, bbʉ mí jiantijʉ guegue, xøtze car deje má dyo, bi mbidijʉ, bi majmʉ nzajqui, i̱na̱jʉ: ―¡Tji nʉ́r nda̱ji̱ hnar ánima ba e̱j nʉ!― ");
INSERT INTO otsNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nu car Jesús bi nzojmʉ, bi xijmʉ: ―Da jñu̱ ir mʉyjʉ. Guejquigö. Dyo guí ntzu̱jʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Diguebbʉ ya car Pedro bi da̱di, i̱na̱: ―Nuquɛ, Tzi Jmu̱, bbʉ ntju̱mʉy guehquiguɛ, gui ddajqui ʉr tsjɛjqui gu hñogö xøtze nʉr deje hne̱je̱, gu má ntjɛhui.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Cja̱ car Jesús bi xifi: ―Bú e̱j ya bbʉ́.― Diguebbʉ ya bi ga̱ jar barco car Pedro, bi hño xøtze car deje, mír ma du ntjɛhui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bbʉ mí zö car Pedro már nzɛh car nda̱ji̱, bi ndo zu̱ bbʉ́, xní ñʉ jar deje. Bi mafi, bi mahti car Jesús, i̱na̱: ―Nuquɛ, Tzi Jmu̱, cjʉxqui tzʉ ya, porque xtá cʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nu car Jesús bi wa̱na̱ nttzɛdi cár dyɛ, bi zɛti car Pedro, bi xifi: ―Nuquɛ, Pedro, jin tza guí e̱me̱gui. ¿Dyoca̱ xcú yomfe̱nitjo?― ");
INSERT INTO otsNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cja̱ bbʉ mí bøxihui jar barco, exque bi tzöya car nda̱ji̱. ");
INSERT INTO otsNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Cja̱ cʉ pé dda hñøjø cʉ mí tøjti pʉ jar barco bi ndo hño í mʉyjʉ, bi hñi̱htzibijʉ car Jesús, bi ma̱jmʉ: ―Ntjumʉy, ʉ́r Ttʉqui ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Diguebbʉ ya bi zøti car barco pʉ jár nttza̱ni car deje, tzʉdi, pʉ jar jöy Genesaret, cja̱ bi ga̱h car Jesús co ni quí möxte pʉ jar barco. ");
INSERT INTO otsNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Cʉ mi̱ngu̱ pʉ jar lugar‑cá̱ bi meyajʉ car Jesús cja̱ bi tʉnguijʉ car jña̱, bi göxjʉ göhtjo cʉ cja̱hni cʉ már bbʉh cʉ pé dda jñi̱ni pʉ jar jöy‑cá̱. Cja̱ bú ttzijmpi car Jesús göhtjo cʉ to mí jnini. ");
INSERT INTO otsNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Cʉ döhtji mí öjpijʉ favor car Jesús di jiɛgui di zɛtibitjojʉ cár nttza̱ni cár da̱jtu̱ ca mí pöti. Cja̱ cʉ cja̱hni cʉ bí zɛtijʉ, göhtjo bi joguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Diguebbʉ ya, bú e̱jmʉ pʉ jabʉ már bbʉh car Jesús cʉ dda hñøjø cʉ mí u̱jti cʉ cja̱hni car ley, co cʉ dda fariseo. Gueguejʉ xcuí hñe̱jmʉ pʉ Jerusalén, cja̱ bi dyönijʉ car Jesús, bi hñi̱na̱jʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Yir möxte yʉ i tɛnqui jin gui tɛn quí costumbre cʉ ndom titajʉ, como jin gui xʉdyɛjʉ rá zö ga nzijʉ. ¿Dyoca̱ jin gui tɛn cʉ costumbre‑cʉ́?― ");
INSERT INTO otsNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Cja̱ car Jesús bi da̱di, bi hñi̱mbijʉ: ―Nuquiguɛjʉ, ¿dyoca̱ guí ndo uni ir mʉyjʉ gui tɛnijʉ cʉ dda costumbre, cja̱ por rá ngue cʉ costumbre‑cʉ, jin guí cjajpijʉ ngüɛnda cʉ jmandado cʉ xí ddajquijʉ ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque bi mandado ca Ocja̱ ncjahua: “Gui hñi̱htzibi quer ta cja̱ co quer me.” Guejtjo bi ma̱n ca Ocja̱: “Car cja̱hni ca da zan cár ta o cár me, rí ntzöhui da bböhti.” ");
INSERT INTO otsNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nuquiguɛjʉ, jin guí tɛnijʉ yʉ jmandado‑yʉ. Guí ɛtijʉ yʉ cja̱hni da dö göhtjo cár diezmo pʉ jar templo, masque jin te da sobra pa da möx quí tajʉ o quí mejʉ. Guí xijmʉ, da jojtjo bbʉ da xijmʉ cár ta co cár me: “Nuquɛ ta, nuquɛ me, ya jin te dí ja̱ pa gu föxquihui. Nu ca ndí ja̱ pa gua föxquihui, ya xtú un ca Ocja̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Eso, guí xijmʉ cʉ cja̱hni, jin guí nesta da möx quí tajʉ cja̱ co quí mejʉ. Ncjahmʉ guí ja̱jquijʉ car palabra ca xí mandado ca Ocja̱, pe guí ndo tɛnijʉ ca xí ma̱n quir mi̱nga̱‑cja̱hnitjojʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Guí jiöjtejʉ! Car profeta Isaías, bbʉ mí dyøti cár libro, ya má yabbʉ, bi jñu̱x yʉ dda palabra yʉ i ma̱ ja guí ncjajʉ. Mí ma̱ ncjahua, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yʉ cja̱hni‑yʉ, xøtzetjo ga hñizquigö‑yʉ́, Pe mbo ʉ́r mʉyjʉ, jin gui cuajqui‑yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jin te ntju̱mʉy ga xöjtiguijʉ, Como jin gui gue cam palabragö i u̱jti quí mi̱nga̱‑cja̱hnijʉ pa da dɛn‑cʉ́, Gue quí mfe̱ni yʉ cja̱hnitjo i u̱jtijʉ. Ncjapʉ gá ma̱n car profeta‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Diguebbʉ ya car Jesús bi nzoh cʉ cja̱hni cʉ xquí jmuntzi pʉ, bi xijmʉ du cuati pʉ jabʉ már bbʉ guegue, bi hñi̱na̱: ―Gui dyødejʉ, cja̱ gui mbe̱nijʉ rá zö te i ne da ma̱ nʉ gu xihquijʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Digue yʉ cosa yʉ dí tzijʉ, jin te i bbʉh ca i ccaxquijʉ ca Ocja̱ pa jin gu tzijʉ, como guegue jin gui nu̱guijʉ rá nttzo por rá ngue cʉ dí tzijʉ. Bbʉ da ma̱ngui palabra rá nttzo hnar cja̱hni, nucá̱ cierto, jin gui tzøh ca Ocja̱‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Diguebbʉ ya, quí möxte car Jesús bi guati cja̱ bi dyönijʉ: ―Nuquiguɛ, ¿cja guí pa̱di, xí unijʉ ʉr cuɛ cʉ fariseo ca xcá dyødejʉ nʉr palabra nʉ xcú ma̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Cja̱ bi da̱ guegue, i̱na̱: ―Da nccʉ́htzi göhtjo tema planta ca jí̱ xcá mon cam Tzi Ta ca bí bbʉ jar ji̱tzi. Cʉ cja̱hni‑cʉ́, jí̱ í cja̱hni cam Tzi Tagö. ");
INSERT INTO otsNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dyo guí cjadi mʉyjʉ‑cʉ́. Godö‑cʉ́, cja̱ pé i cjʉti pé dda godö. Nu bbʉ ʉr godö ca to i cjʉti, cja̱ pé ʉr godö ca to i tɛni, nubbʉ́, da tzohui göhtjo yojmi jar hñu̱tje.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Diguebbʉ ya car Pedro bi xih car Jesús: ―Xijquije tzʉ, ¿te i ne da ma̱n car palabra cja xcú ma̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Cja̱ bi ma̱n car Jesús: ―Hne̱hquitjoguɛjʉ, ¿cja guí jñɛjmʉ cʉ pé dda cja̱hni cʉ jin gui ntiende? ¿Cja jí̱ bbe guí ntiendejʉ hne̱je̱? ");
INSERT INTO otsNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Cja jin guí ntiendejʉ, göhtjo ca dí cöti ʉm nejʉ rí má jam nttza̱mfojʉ, cja̱ diguebbʉ ya, rí madi tji? ");
INSERT INTO otsNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pe nu ca i pøxi ir nejʉ, guehca̱ rí hñe̱h pʉ jer tzi mʉyjʉ. Cja̱ bbʉ rá nttzo ca guí ma̱, nubbʉ́, cierto ca Ocja̱ i cca̱jtiqui guí tu̱ ca rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porque rí hñe̱h pʉ jer tzi mʉyjʉ cʉ nttzomfe̱ni. Car mfe̱ni ca grí pöhti quer hñohui, car mfe̱ni ca grí jiöhtibi cár bbɛjña̱ pé hnar hñøjø o cár da̱me̱ pé hnar bbɛjña̱, car mfe̱ni ca grí jiöti hnar bbɛjña̱ o hnar hñøjø ca jin guí ntja̱jtihui, car mfe̱ni ca grí mpe̱, car mfe̱ni ca grí ña̱jqui bbɛtjri, car mfe̱ni ca grí jiøx quer mi̱nga̱‑cja̱hnihui tema cosa rá nttzo, göhtjo yʉ nttzomfe̱ni‑yʉ́ rí hñe̱h pʉ jer tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Guejyʉ i ttzombiquijʉ yir tzi mʉyjʉ cja̱ guejyʉ jin gui tzøh ca Ocja̱‑yʉ́. Pe bbʉ jin gui xʉdyɛjʉ ncja ngu̱ ga xʉdyɛ cʉ fariseo, jin gui nttzo‑cá̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Diguebbʉ ya, bi bøm pʉ car Jesús, gá ma jar jöy pʉ jabʉ mí bbʉh car jñini Tiro co hne̱h car jñini Sidón. ");
INSERT INTO otsNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hnar bbɛjña̱ múr mi̱ngu̱ car jöy‑cá̱, jí̱ múr judio, mí pertene car raza ca mí tsjifi cananea, guegue bú e̱je̱ bi ntjɛhui car Jesús. Bi nzofo, bi mahti nzajqui, bi hñi̱na̱: ―Nuquiguɛ, Tada, xquí hñe̱je̱ digue cár cji car rey David, gui jui̱guigö tzʉ. I ndo jnin cam tti̱xu̱, xí nzʉh cár nda̱ji̱ ca Jin Gui Jo.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nu car Jesús jin te gá nda̱di. Diguebbʉ bi guatijʉ quí möxte bi nzojmʉ car Jesús, bi hñi̱mbijʉ: ―Xih tzʉ nʉr bbɛjña̱ da ma, porque ba tɛnguijʉ, dé i mafi.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Cja̱ bi da̱j ya car Jesús, bi xih car bbɛjña̱: ―Xpá mɛnquigö cam Tzi Ta ji̱tzi pa gu jon quí tzi dɛti cʉ xí bbɛdi. Gue yʉ cja̱hni israelita, jøntsjɛ‑yʉ́. Yʉ pé dda cja̱hni, jí̱ í dɛjti cam Tzi Ta ji̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nu car bbɛjña̱ nde̱jma̱ bi guati car Jesús, bi nda̱ndiña̱jmu̱ pʉ jáy hua, bi ndo dyöjpi favor, bi hñi̱na̱: ―Nuquɛ, Tzi Jmu̱, gui föxqui tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bi da̱j ya car Jesús, bi xifi: ―Jin gui tzö gu ja̱mbi cár tju̱jme̱ quí ba̱jtzi ca Ocja̱ pa gu ɛmbi yʉ tzi dyo.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bi ma̱n car bbɛjña̱, bbʉ, i̱na̱: ―Cierto, Tzi Tada, pe nde̱jma̱ da jogui gui föxqui hne̱je̱. Porque guejti yʉ tzi dyo i tzí cʉ ngʉnti tju̱jme̱ cʉ i jøh pʉ jár mexa cár jmu̱jʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Diguebbʉ, bi da̱h car Jesús, bi hñi̱na̱: ―Nuquɛ, na̱na̱, rá zö guir hñe̱me̱gui. Da ncja como ngu̱ guí neguɛ.― Cja̱ bi zö cár tti̱xu̱ desde car hora‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bbʉ mí bøm pʉ jár lugar‑cá̱, car Jesús bi dɛn car hñu̱ rí ma jár nttza̱ni car mar Galilea. Cja̱ bi bøxi hnar ttøø, bú mi̱h pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Cja̱ bi guatijʉ car Jesús rá ndo ngu̱ cja̱hni, mbá tzijmpi rá ngu̱ clase cʉ döhtji, cʉ dohua, hne̱h cʉ godö, cʉ ngone co cʉ dodyɛ, cja̱ pé ddáa rá ngu̱ cʉ mí jñinijʉ. Bú tzijʉ pʉ jabʉ már bbʉh car Jesús, cja̱ guegue bi jojqui göhtjo. ");
INSERT INTO otsNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mí ndo dyo í mʉy cʉ cja̱hni bbʉ mí cca̱htijʉ ja gá zö cʉ döhtji. Bi ña̱ cʉ ngone, bi joh cʉ dodyɛ, bi hño cʉ dohua, bi cca̱hti cʉ godö. Cʉ cja̱hni cʉ mí cca̱hti cʉ döhtji ngá zö, bi ndo xöjtibijʉ car Tzi Ta ji̱tzi, bi ma̱jmʉ: ―Ya xí ndo möxquigöjʉ ca Ocja̱, dí israelitajʉ, yí cja̱hniguijʉ guegue.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Diguebbʉ ya, car Jesús bi nzoh quí möxte, bi xijmʉ: ―Dí ndo jui̱jqui yʉ cja̱hni. Ya xí nzʉ jñu̱jpa dí bbʉpjʉ hua, cja̱ jin te i tzijʉ. Jin dí ne gu cu̱y da möjmʉ í ngu̱jʉ, porque xtrí ngüentijʉ jar hñu̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Cja̱ bi da̱h quí möxte, bi ma̱jmʉ: ―Nuhua jabʉ dí bbʉpjʉ, jin to i hña̱ni, ¿jabʉ gu tötijʉ drá ngu̱ cʉ tju̱jme̱ pa da ñi̱ña̱ göhtjo yʉ cja̱hni yʉ́?― ");
INSERT INTO otsNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nu car Jesús bi dyönijʉ: ―¿Tengu̱ tju̱jme̱ guí pɛhtzijʉ?― Cja̱ guegue bi da̱dijʉ: ―Yojto, cja̱ tengu̱di cʉ tzi möy.― ");
INSERT INTO otsNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nubbʉ́, car Jesús bi bbɛjpi cʉ cja̱hni di mi̱pjʉ jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Cja̱ guegue ya bi gʉ cʉ yojto tju̱jme̱ cja̱ co cʉ tzi möy, cja̱ bi dyöjpi mpöcje car Tzi Ta ji̱tzi. Bi jejqui cʉ tju̱jme̱ co cʉ möy cja̱ bi un quí möxte. Cja̱ quí möxte ya, pé bi un cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Cja̱ göhtjo cʉ cja̱hni bi zijʉ, bi ñi̱ña̱jʉ. Cja̱ bi jmu̱ntzijʉ cʉ pedazo cʉ xquí sobra. Bi zö yojto bbøtze, bi ñu̱tzi rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cja̱ cʉ cja̱hni cʉ bi zi, mí zøti go mil cʉ hñøjø, aparte cʉ bbɛjña̱ co cʉ tzi ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Diguebbʉ ya, car Jesús bi xih cʉ cja̱hni di möjmʉ í ngu̱jʉ ya, cja̱ guegue bi ma guí tøh car barco, bi ddax jar deje, gá nzøti pʉ jar jöy ca mí nzøtihui car jñi̱ni Magdala. ");
INSERT INTO otsNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Diguebbʉ ya, bi guati car Jesús cʉ fariseo hne̱h cʉ saduceo. Mí jon‑cʉ́ ja drí dyøhtibi car Jesús hnar trampa. Bi dyöjpi di u̱jti hnar seña ca di hna ni̱guitjo nʉ jar ji̱tzi pa di hñe̱me̱jʉ, guegue xcuí mɛjni car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Cja̱ guegue bi da̱di, bi xijmʉ: ―Nuquiguɛjʉ, bbʉ guí jantijʉ nʉr ji̱tzi, guí pa̱di gui ma̱jmʉ ja da ncja car tiempo. Bbʉ i tjɛngui nʉr ji̱tzi bbʉ xca nde, nubbʉ guí ma̱jmʉ: “Da ncja hnar jogui pa ʉr xu̱di.” ");
INSERT INTO otsNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bbʉ i tjɛngui nʉr ji̱tzi bbʉ nxudi cja̱ i ndo cja gu̱y, nubbʉ́, guí ma̱jmʉ: “Nuya da hño ʉr nda̱ji̱ ya, cja̱ da wa̱y.” ¡Nuquɛjʉ, guí jiöjtejʉ! Guí pa̱di gui ma̱jmʉ ja da ncja car tiempo bbʉ guí jantitjojʉ nʉr ji̱tzi. ¿Cja jin guí meyajʉ cʉ seña cʉ ya xquí cca̱htijʉ? ¿Dyoca̱ jin guí pa̱dijʉ, ya xí ncumpli cʉ di ncja bbʉ xti ni̱gui ca hnar cja̱hni ca du pɛjni ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Guí nejʉ pa gu cjajpigö da hna ni̱gui jar ji̱tzi hnar milagro, cja̱ bbʉ ji̱na̱, jin guí ne gui hñe̱me̱jʉ, ¿cja guejquigö xpá mɛnquigö car Tzi Ta ji̱tzi? Gue yʉ cja̱hni yʉ rá nttzo quí mfe̱ni cja̱ ya xí jiɛjmʉ ca Ocja̱ i ne da cca̱htijʉ milagro pa da hñe̱me̱jʉ. Pe nugö, jin gu øti tema milagro pa gui cca̱htijʉ. Jøña̱ gu ncjagö ncja ngu̱ car profeta Jonás ca mí bbʉ ya má yabbʉ, cja̱ ncjapʉ gu jñɛbbe ncja hnar seña.― Ncjapʉ gá nda̱jti cʉ fariseo car Jesús, cja̱ diguebbʉ ya, bi wembi, bi má. ");
INSERT INTO otsNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Diguebbʉ ya guegue bi mɛhui quí möxte bi ddaxjʉ car mar. Cja̱ bbʉ mí zøtijʉ ca hnanguadi, quí möxte car Jesús bi hna mbe̱nijʉ, jin te xcuí gʉjʉ tju̱jme̱ pa di zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Diguebbʉ ya car Jesús bi nzojmʉ, bi hñi̱mbijʉ: ―Dyøjma̱jʉ nʉr razón dí ne gu xihquijʉ: Jin gui tzö car levadura ca ba ja̱ cʉ fariseo co cʉ saduceo. Nuquɛjʉ, jin gui ma gui jña̱jʉ‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nu quí möxte bi ña̱tsjɛjʉ bi ma̱jmʉ: ―I xijquijʉ nʉr palabra‑nʉ porque jin te xtá cʉjʉ tju̱jme̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Cja̱ car Jesús bi ba̱di ter bɛh ca̱ már ma̱jmʉ, cja̱ bi dyönijʉ: ―¿Dyoca̱ guí hñönijʉ ja gu ncjajʉ ya, porque jin te xcú cʉjʉ tju̱jme̱? ¿Cja jim be guí e̱me̱guijʉ? ");
INSERT INTO otsNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Cja jim be guí pa̱dijʉ, jin gui nesta gui ntzøtijʉ ter bɛh ca̱ gu tzijʉ? ¿Cja jin guí mbe̱nijʉ te dú cjajpi cʉ cʉtta tju̱jme̱ bbʉ mí zi cʉ cʉtta mil hñøjø? ¿Cja jin guí mbe̱nijʉ tengu̱ bbøtze cʉ pedazo pé bi sobratjo? ");
INSERT INTO otsNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Co guejti cʉ yojto tju̱jme̱ cʉ bi zi cʉ go mil hñøjø, hasta bi ñi̱ña̱jʉ rá zö, ¿cja jin guí mbe̱nijʉ tengu̱ bbøtze cʉ pedazo pé bi huetitjo hne̱je̱? ");
INSERT INTO otsNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Guí ma̱jmʉ, ndár ña̱gö digue car tju̱jme̱, ca xtá xihquijʉ güi mfödijʉ pa jin güi jña̱jʉ car levadura ca ba ja̱ cʉ fariseo co cʉ saduceo.― ");
INSERT INTO otsNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bbʉ mí dyødejʉ nʉr palabra‑nʉ, bi ba̱h quí möxte car Jesús te mí ne di ma̱ guegue. Jí̱ már ña̱ car Jesús digue car levadura ca i ntja̱ntzihui car cjʉni tju̱jme̱. Nu guegue már xih quí möxte jin di dɛmbijʉ cár mfe̱ni cʉ fariseo co cʉ saduceo. Mír jɛquihui cár mfe̱ni guegue‑cʉ́ car levadura. ");
INSERT INTO otsNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Diguebbʉ ya car Jesús bi ma jar jöy ca mí nzøtitjohui car jñini Cesarea de Filipo, cja̱ bi dɛn quí möxte. Nupʉ, car Jesús bi dyön‑cʉ́, bi hñi̱mbijʉ: ―¿Ter bɛh ca̱ i ma̱n yʉ cja̱hni diguejcö? ¿Tema cargo dí ja̱gö?― ");
INSERT INTO otsNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Quí möxte ya, bi da̱dijʉ, bi hñi̱na̱jʉ: ―I ma̱n cʉ dda cja̱hni, nuquiguɛ, gúr Juan ca mí xix yʉ cja̱hni cja̱ bi bböhti, cja̱ nuya pé xí jña̱ ʉ́r jña̱. Cʉ pé ddáa ya i ma̱jmʉ, gúr profeta Elías nguí bbʉy ya má yabbʉ, cja̱ nuya pé xcú ni̱gui. Cja̱ pé i bbʉ pé ddáa cʉ i ma̱jmʉ guehquɛ gúr ndodi Jeremías, o bbʉ ji̱na̱, pé hnahño ʉ́r jmandaderoqui ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Guegue pé bi dyöni, bbʉ: ―Xiquiguɛjʉ, ¿te guí ma̱jmʉ digue cam cargo dí ja̱gö?― ");
INSERT INTO otsNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Cja̱ bi da̱h car Simón ca guejtjo mí ju̱ cár tju̱ju̱ múr Pedro, bi hñi̱na̱: ―Guehquiguɛ, gúr Cristo, xí hñi̱xqui car Tzi Ta ji̱tzi pa gui mandadoguije. ʉ́r Ttʉqui ca Ocja̱ ca ntjumʉy i bbʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Diguebbʉ ya bi da̱h car Jesús, bi xih car Pedro: ―Nuquɛ, Simón, ʉ́r ttʉqui car Jonás. Xí ndo möxqui car Tzi Ta ji̱tzi. Jin tema cja̱hni xí xihqui nʉr palabra nʉ xcú ma̱. Guejtjsɛ cam Tzi Ta ca bí bbʉ ji̱tzi xí xihqui ncjanʉ, eso xcú pa̱di jabʉ xtá e̱jcö cja̱ co tema cargo dí ja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dí xihqui hne̱je̱, nuquɛ, gúr Pedro, guí jñɛjmi hnar me̱do pʉ jabʉ da tsjoxi hnar ngu̱. Ntjumʉy nʉr palabra nʉ xcú ma̱, cja̱ nuquɛ, gui ma gui föx cʉ pé dda cja̱hni pa da hñemegui ncja ngu̱ grí hñemegui. Yʉ to da hñemegui da cja ʉm templogö. Masque da contragui ca Jin Gui Jo co göhtjo quí möxte, pe jin da da̱gui, cja̱ jin da da̱pi yʉ to da hñemegui, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nuquiguɛ, Pedro, xtá ddahqui cʉ ntsjogui pa gui jña̱ quer cargo, gui föxqui cam jmandado pʉ jabʉ i mandado cam Tzi Ta ji̱tzi. Dí ddahqui derecho gui xij yʉm cja̱hni yʉ i tɛngui hua jar jöy, ja i ncja cʉ jin da dyøtijʉ, cja̱ co ni cʉ ja i ncja cʉ i tjɛgui da dyøte. Ncja ngu̱ gri xijmʉ hua jar jöy, da ncjadipʉ drí ma̱n cam Tzi Ta pʉ jar ji̱tzi.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Diguebbʉ ya, car Jesús bi ccax quí möxte cʉ már yojmi, bi xijmʉ, jí̱ bbe di ngöxtejʉ, ¿cja múr Cristo guegue ca xquí hñi̱x car Tzi Ta ji̱tzi pa di mandado? ");
INSERT INTO otsNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde car pa‑cá̱ car Jesús bi mʉdi bi xih quí möxte, guegue mí nesta di ma pʉ jar jñi̱ni Jerusalén cja̱ di du̱ pʉ. Bi xijmʉ, cʉ tita cʉ mí ja̱ cár cargojʉ pʉ, co cʉ möcja̱ cʉ mí mandadobi cʉ pé ddáa, co hne̱h cʉ hñøjø cʉ mí u̱jti cʉ cja̱hni israelita car ley, göhtjo‑cʉ́ di contrabi car Jesús, di mandado pa di ttʉni, cja̱ pa di bböhti. Nu guegue car Jesús, di du̱, cja̱ pé di jña̱ ʉ́r jña̱ ca xtrá jñu̱jpa. Guehcá̱ di ncja‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nu car Pedro, bbʉ mí dyøj nʉr palabra‑nʉ́, bi wejqui car Jesús, gá ma hnanguadi, cja̱ bi mʉdi bi nzofo. Bi xifi: ―Nuquiguɛ, Tzi Jmu̱, dyo guí ma̱nguɛ gui tu̱. Jin da jiɛqui car Tzi Ta ji̱tzi pa da bböjtiqui.― ");
INSERT INTO otsNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Car Jesús ya, bi bböti, cja̱ pé bi nzoh car Pedro, bi hñi̱mbi: ―Nuquɛ, Pedro, dyo guí xijqui ncjanʉ. Guí yojmi car Satanás. Jin gu øjtiqui nʉ xcú xijqui. Guí ne gui ccaxqui pa jin gu øti ca xí ma̱n cam Tzi Ta ji̱tzi. Jí̱ xcuá hñe̱h ca Ocja̱ nir mfe̱ni. ʉ́r mfe̱nitjo hnar cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Diguebbʉ ya, car Jesús bi xih quí möxte: ―Car cja̱hni ca i ne da dɛnguigö, jin da jiøjqui cár nzajqui. Da dyɛmbi ʉ́r mʉy pa da sufri, ncja ngu̱ hnar cja̱hni ca i ddøti pʉ jar ponti pa da du̱. Da ncjapʉ drí dɛnguigö. ");
INSERT INTO otsNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Car cja̱hni ca jin gui ne da dɛnguigö, como i ne da mɛhtzitjo cár vida, guegue da bbɛh cár vida. Nu car cja̱hni ca i bbʉy pa drí dɛnguigö, masque xín da bbɛh cár vida, nucá̱ da döti car nzajqui ca ntju̱mʉy rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ter bɛh ca̱ di ta̱h hnar cja̱hni bbʉ di cjajpi ʉ́r mɛjti göhtjo yʉ i bbʉjcua jar mundo, pe guejtsjɛ guegue di bbɛdi? ¿Ter bɛh ca̱ di dö pa di mɛhtzi car nzajqui ca jin da tjegue? ");
INSERT INTO otsNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy. Dí xihquijʉ, car pa ca pé xcuá cojcua jar jöy, bbʉ xcuá yobbe cʉ ángele cʉ i pɛjpi cam Tzi Ta, ya xcra ja̱gö cam cargo pa gu cja ʉr nzöya. Nubbʉ, gu juzga cada hnar cja̱hni según ca xtrú dyøte hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gui dyøjma̱jʉ nʉr palabra nʉ dí xihquijʉ ya digue yʉ cja̱hni yʉ i bbʉj yʉ pa ya: I bbʉ tengu̱ yʉ da hmʉjti bbʉ pé xcuá coji, jí̱ bbe di tu̱jʉ. Guegue‑yʉ́ xta nu̱jʉ bbʉ xcuá ja̱ cam cargo cja̱ xtá mandado. Guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Diguebbʉ ya, bbʉ mí cja ddajto mpa, car Jesús bi zix car Pedro, hne̱h car Santiago cja̱ co cár cjua̱da̱, gue car Juan. Jøntsjɛ‑cʉ́ bi zix‑cʉ́. Bi möjmʉ gá mbøxjʉ hnar ttøø, már ndo nte. ");
INSERT INTO otsNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yʉ jñu̱ yí möxte‑yʉ, már cca̱htijʉ car Jesús, cja̱ bi mböh cár cara, hnahño mír ni̱gui. Mí juɛtzi ncja nʉr jiadi. Guejti quí da̱jtu̱ már tzi nttaxi ncja nʉr jiahtzi. ");
INSERT INTO otsNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Cja̱ bi hna ni̱gui pʉ car Moisés co car Elías, xcuí hñe̱jmi jar ji̱tzi. Cja̱ bi ña̱hui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Diguebbʉ ya car Pedro bi xih car Jesús, i̱na̱: ―Nuquiguɛ, Tzi Jmu̱, dí ndo mpöjcö ca dár hmʉpjʉ hua. Bbʉ guí neguɛ, gu øti jñu̱ tzi ngu̱ gá dyɛza: hnaaquiguɛ, pé hnáa nʉr Moisés, cja̱ pé hnáa nʉr Elías.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Már ña̱di car Pedro, cja̱ bi hna ga̱h hnar gu̱y, már ndo nttaxi, bi gohmijʉ. Cja̱ bi ni̱gui hnar jña̱, mbí ña̱ pʉ mbo car gu̱y. Bi ma̱: ―Gue nʉm ttʉgö‑nʉ́, dí ma̱di. I pöjpigui nʉm tzi mʉy. Gui dyødejʉ ca i ma̱‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nu quí möxte car Jesús, bbʉ mí dyøj nʉr jña̱ mbí ña̱ mbo car gu̱y, bi ndo ntzu̱jʉ, cja̱ bi hmɛmfojʉ jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Diguebbʉ ya car Jesús bi guati cja̱ bi göx cár dyɛ, bi dön‑cʉ́. Bi xijmʉ: ―Gui bböpjʉ ya, dyo guí ntzu̱jʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cja̱ bbʉ mí jani gueguejʉ, jøntsjɛ car Jesús bi jiantijʉ. Ya xquí wen cʉ pé yojo. ");
INSERT INTO otsNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bbʉ ya xi mbá ca̱jmʉ jar ttøø, car Jesús bi xih quí möxte, jin to di göxjʉ ca xcuí cca̱htijʉ pʉ jar ttøø. Bi xijmʉ: ―Jin to gui xijmʉ ter bɛh ca̱ xcú cca̱htijʉ hasta bbʉ xtá tu̱gö cja̱ pé xtá nantzi. Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Diguebbʉ ya, quí möxte car Jesús, bi dyöni, bi hñi̱mbijʉ: ―¿Dyoca̱ i ma̱n cʉ maestro cʉ i u̱jtiguije car ley, bbɛto xtu e̱h car profeta Elías, cja̱ diguebbʉ, drí ga̱x ca hnaa ca da hñi̱x ca Ocja̱ pa da mandadoguijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Cja̱ bi da̱h car Jesús, bi xijmʉ: ―Cierto nʉr palabra nʉ xí man cʉ maestro. Mí nesta bbɛto di hñe̱h car Elías, di nzoj yʉ cja̱hni pa drí hmʉpjʉ ncja ngu̱ ga ne ca Ocja̱, cja̱ diguebbʉ ya, di hñe̱j na̱ hnáa. ");
INSERT INTO otsNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pe nugö, dí xihquijʉ, ya xpá hñe̱h ca hnár jmandadero ca Ocja̱ ca i jñɛjmi car Elías, cja̱ yʉ cja̱hni, jin gá ne gá meya. Nuyʉ́, bi möhtijʉ. Hne̱jquigö, xta ncjagui ncja ngu̱ gá ncjajpi ca hnáa ca mí jñɛjmi car Elías. Guejquigö dúr cja̱hni, xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nubbʉ́, cja bi hna ba̱h quí möxte car Jesús te mí ne di ma̱ guegue‑cá̱ bbʉ mí ma̱, ya xcuí hñe̱h car Elías. Bi ba̱dijʉ, már ña̱ digue car Juan ca mí xix cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cja̱ bbʉ mí zønijʉ jár ndʉy car ttøø, bi cca̱htijʉ, ya xquí jmu̱ntzi pʉ rá ngu̱ cja̱hni. Bú e̱h hnar hñøjø, bi guati car Jesús, cja̱ bi nda̱ndiña̱jmu̱, bi hñi̱mbi: ");
INSERT INTO otsNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Nuquɛ, Tzi Tada, föxquije tzʉ. Gui dyøtje tzʉ cam ttʉ. I tzöhui car jñini ʉr mexca̱ndu̱, cja̱ i ndo tzöhui nttzɛditjo. Dé i fʉntzi jar gootzibi, guejtjo rá ndo ngu̱ vez xí tzo já deje. ");
INSERT INTO otsNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cja̱ nuya, xtú tzijmpi yir möxte, pe nuyʉ, jí̱ xcá̱ mba̱di di jojqui.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bi da̱j ya car Jesús, i̱na̱: ―Nuquiguɛjʉ, guí cja̱hnijʉ guí bbʉpjʉ rá pa ya, jin te guí e̱me̱jʉ ca Ocja̱, cja̱ jin guí øjtijʉ ca i ma̱. Ya xná ngu̱ mpa xtú hmʉpjʉ, cja̱ jin guí ne gui hñe̱me̱guijʉ. Ya jin gu jötigö ca dár hmʉpjʉ. Bú tzí hua quer ttʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Cja̱ bú tzíji, bbʉ. Diguebbʉ ya, car Jesús bi huɛhti car ttzonda̱ji̱ ca mí yojmi car ba̱jtzi, cja̱ nucá̱, bi bøni, bi wem pʉ. Cja̱ desde car hora‑cá̱ bi joh car tzi hñøjø. ");
INSERT INTO otsNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Diguebbʉ ya, bbʉ ya xquí wen cʉ cja̱hni rá ngu̱, bi guati car Jesús quí möxte, bi dyönijʉ: ―Xigöje, ¿Dyoca̱ jí̱ xtá pa̱jcöje gua fonguije car nda̱ji̱‑cá̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Cja̱ bi da̱j ya car Jesús, bi hñi̱mbijʉ: ―Porque jin guí e̱me̱jʉ ca Ocja̱ göhtjo mbo ir mʉyjʉ. Cierto nʉr palabra nʉ dí xihquijʉ, masque cja guí nxödi gui hñe̱me̱jʉ, bbʉ ntju̱mʉy gri hñe̱me̱jʉ, xquí zɛdijʉ, bbʉ. Bbʉ gui nxödi gui hñe̱me̱jʉ ca Ocja̱ göhtjo mbo ir mʉyjʉ, da jogui gui dyöjpijʉ ca te guí nejʉ, cja̱ da ncja ca xcú ma̱jmʉ. Hasta da jogui gui bbɛjpijʉ nʉr ttøø nʉ rá cjanʉ da wengua drí ma hnanguadi, cja̱ da weni. ");
INSERT INTO otsNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nu cʉ nda̱ji̱ rá nttzo, ncja ca hnáa ca mí yojmi nʉr ba̱jtzi‑nʉ́, jin gui ne da bøn‑cʉ́. Nesta gui ayunajʉ cja̱ gui ndo nzojmʉ ca Ocja̱ pa da jogui gui fonguijʉ cʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cja̱ bbʉ má dyojʉ car Jesús co quí möxte pʉ jar jöy Galilea, guegue bi xijmʉ te di ncja, bi hñi̱na̱: ―Guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy, cja̱ nuya da ndögui jáy dyɛ cʉ cja̱hni cʉ i ʉgui. ");
INSERT INTO otsNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nucʉ́, da möjtiguigö‑cʉ́, pe ca xtrá jñu̱jpa, pé gu nantzi.― Cja̱ bbʉ mí dyøj nʉr palabra‑nʉ́ quí möxte car Jesús, bi ndo du̱mʉyjʉ rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Diguebbʉ ya, car Jesús co quí möxte bi zøtijʉ jar jñini Capernaum. Cja̱ bú e̱h cʉ cobrador cʉ mí dyo, mí jmu̱ntzi cʉ contribución pa di ttzoh pʉ jár ni̱cja̱ cʉ judio. Cʉ cobrador bi guatijʉ car Pedro cja̱ bi dyöjpijʉ cár contribución. Bi dyön car Pedro, bi hñi̱mbijʉ: ―¿Cja i dö car contribución quer maestrojʉ pa da ttum pʉ jar ni̱cja̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bi da̱h car Pedro, bbʉ: ―Ja̱a̱, i dö.― Bbʉ ya xquí ma̱ ncjapʉ, bi ñʉti car Pedro pʉ jar ngu̱ pʉ jabʉ mí tzöya car Jesús. Nu car Jesús nguetica̱ bi nzoh car Pedro, bi dyöni: ―¿Nuquɛ, Simón, ja i ncja quer mfe̱ni? ¿Cja rí ntzöhui gu unijʉ ca i ttöjquijʉ, cja̱ huá ji̱na̱? ¿To cʉ cja̱hni cʉ i ncobrabi cʉ contribución pa da jña̱ car gobierno? ¿Cja gue quí familia car gobernador, cja̱ huá hnahño cja̱hni?― ");
INSERT INTO otsNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Cja̱ bi da̱h car Pedro, i̱na̱: ―Gue cʉ hnahño cja̱hni i ncobrabi.― Car Jesús pé bi xih bbʉ: ―Guehcá̱. Nugöjʉ, jí̱ rí ntzöhui da ncobraguijʉ cʉ contribución cʉ da ttzoh pʉ jar templo, como í ttʉguijʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pe pa jin da hñi̱na̱ cʉ pé dda cja̱hni, dí tzangöjʉ car templo, nde̱jma̱ gu cju̱tijʉ ca i ttöjquijʉ. Eso, gui maguɛ ya jar mar, gui pøti quer hmamöy gá gancho. Car möy ca bbɛto gui tzʉdi, gui cjʉx‑cá̱ cja̱ gui yajquibi cár ne. Pʉ mbo ʉ́r ne xquí töti hnar domi. Gui jña̱x car domi‑cá̱, cja̱ gui ma bú dö pʉ jabʉ i jmu̱ntzi cʉ contribución. Da ntzöhui pa dí yojmi.― ");
INSERT INTO otsNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ca hnajpa, quí möxte car Jesús bi guati cja̱ bi dyönijʉ: ―¿Ja i ncja car cja̱hni ca más da tti̱htzibi pʉ jabʉ i mandado car Tzi Ta ji̱tzi?― ");
INSERT INTO otsNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Cja̱ car Jesús bi nzoh hnar tzi ba̱jtzi, bi hñi̱h pʉ jabʉ már bbʉh quí möxte, ");
INSERT INTO otsNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","cja̱ bi xijmʉ: ―Dyøjma̱jʉ nʉ dí xihquijʉ, i nesta gui pöti quir mfe̱nijʉ cja̱ gui ncjajʉ ncja ngu̱ hnar tzi ba̱jtzi. Bbʉ ji̱na̱, jin da jogui gui cuatijʉ pʉ jár dyɛ ca Ocja̱ pa da mandadoquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Eso, dí xihquijʉ, ca to da ncjá ncja ngu̱ nʉr tzi ba̱jtzi nʉ jin gui mbe̱ni má̱s te i mu̱hui, guegue‑cá̱ da ndo tti̱htzibi pʉ jabʉ i mandado cam Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Car cja̱hni ca i tɛngui, cja̱ por rá nguejquigö da möxi hnar tzi ba̱jtzi ncja ngu̱‑nʉ́, ncjahmʉ guejquigö i föxqui hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Digue yʉ ba̱jtzi yʉ i e̱me̱gui cja̱ co cʉ cja̱hni cʉ di jñɛjmi‑yʉ́, car cja̱hni ca di jöti hna‑yʉ́ pa da dyøti ca rá nttzo, da ttuni hnar castigo drá ndo ʉ́. Más di jogui di hnu̱htibi hnar ndo me̱do jár dyʉga, cja̱ di ttɛnti jar mar, pʉ jabʉ rá ndo je̱, cja̱ jin di jiöti cár hñohui ca cja i fʉdi i e̱me̱gui. ");
INSERT INTO otsNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Da ndo sufri yʉ cja̱hni yʉ i bbʉjcua jar mundo, porque nde̱jma̱ i bbʉh cʉ to i jöti quí hñohui pa da dyøtijʉ ca rá nttzo. Nu ca Ocja̱ da ndo castiga cʉ cja̱hni cʉ i øti ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nuquɛjʉ, gui ndo mfödijʉ pa jin gui dyøtijʉ ca rá nttzo. Dí xihquijʉ, bbʉ i ne da jiöhqui hner dyɛ o hner huá pa gui dyøti ca rá nttzo, más di joh bbʉ güi dyojqui, güi dyɛy, pa jin gui dyøti ca rá nttzo. Más di joh bbʉ di bbɛh hner hua o hner dyɛ, pe nuquɛ, gui cʉti pʉ jabʉ bí bbʉh ca Ocja̱, ni ndra ngue bbʉ di zøti quer cuerpo cja̱ di ttɛntiqui pʉ jar tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Guejtjo, bbʉ i ne da jiöhqui hner dö pa gui dyøti ca rá nttzo, más di joh bbʉ güi jña̱hmi, güi dyɛy pa jin gui dyøti ca rá nttzo. Más di joh bbʉ di bbɛh hner dö, pe nuquɛ, gui cʉti pʉ jabʉ bí bbʉh ca Ocja̱, ni ndra ngue bbʉ güi pɛhtzi göhtjo yojo quir dö, cja̱ di ttɛntiqui pʉ jar tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Gui jña̱jʉ ʉr huɛnda pa jin gui despreciajʉ hna yʉ ba̱jtzi yʉ i e̱me̱gui, como i ndo ma̱j‑yʉ́ cam Tzi Ta ji̱tzi. Cʉ ángele cʉ i föj yʉ tzi ba̱jtzi yʉ i e̱me̱, cada bbʉ ga nejʉ, i cuatijʉ cam Tzi Ta. ");
INSERT INTO otsNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy pa gu jongö cʉ cja̱hni cʉ xí wembijʉ ca Ocja̱. Pé xcuá tzigö‑cʉ́ pa jin da bbɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Gui dyøjma̱jʉ nʉr bbede nʉ gu xihquijʉ. Hnar hñøjø i hñi̱ji̱ cien quí dɛjti. Bbʉ da bbɛh hnáa, ¿cja jin da zoh cʉ noventa y nueve pʉ jár gora cja̱ da má du jon ca pé hnáa? Dyo ya cá̱, da bøni da ma du jom pʉ jar ttøø pʉ jabʉ xpá bbɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cja̱ bbʉ xtu töti, más da ndo pöjpi ʉ́r mʉy car dɛjti ca xquí bbɛdi ni ndra ngue cʉ noventa y nueve cʉ rá bbʉjti pʉ jár ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ncjapʉ hne̱je̱, quer Tzi Tajʉ ca bí bbʉ ji̱tzi i ndo ne yʉ tzi ba̱jtzi ncja‑yʉ́, cja̱ jin gui ne pa da bbɛh hnáa‑yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Cja̱ pé dí xihquijʉ, bbʉ te i øjtiqui quer cjua̱da̱ ca i e̱me̱gui, gui ma grí nzofo, gui ña̱hui, guí yojtsjɛhui. Cja̱ bbʉ xí dyøh ca xcú xifi, ya xcú ta̱h quer cjua̱da̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cja̱ bbʉ jí̱ xcá dyøh ca xcú xifi, nubbʉ, gui tzix pé hnáa o pé yojo cja̱hni cʉ i e̱me̱gui, pa pé gui nzojmʉ car cjua̱da̱‑cá̱. Da hmʉy yojo o jñu̱ testigo pa da dyøde göhtjo cʉ palabra guí ma̱jmi. ");
INSERT INTO otsNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nu ca hner hñohui, bbʉ nde̱jma̱ jin gui ne da dyøh ca guí xijmʉ, nubbʉ́, pé gui xijmʉ cʉ pé dda ir hñohui pʉ jar templo te xí dyøti car cja̱hni‑cá̱, pa pé da nzojmʉ gueguejʉ hne̱je̱. Cja̱ bbʉ guejtjo jin da dyøjti ca da xih quir hñohui pʉ jar templo, nubbʉ́, ya jin gui cca̱htijʉ car cja̱hni‑cá̱ ncja hner hñojʉ. Gui cca̱htijʉ ncja hnar cja̱hni ca jin gui meya ca Ocja̱, o ncja hnar cja̱hni ca i ndu̱jpite. ");
INSERT INTO otsNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Cierto nʉr palabra nʉ dí xihquijʉ, nuquɛjʉ, guí bbʉpjʉ hua jar jöy cja̱ guí tɛnguijʉ, car cja̱hni ca to güi xijmʉ di tu̱di ca rá nttzo ca xí dyøte, guejtica̱ bí ma̱n ca Ocja̱ pʉ jar ji̱tzi hne̱je̱. Nu car cja̱hni ca to güi xijmʉ hua jar jöy, ya xí ccʉhtzibi ca rá nttzo ca mí tu̱, guejtica̱ xta ma̱n ca Ocja̱ pʉ jar ji̱tzi hne̱je̱, ya jin te i tu̱ car cja̱hni‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Cja̱ pé dí xihquijʉ nʉ pé hnar palabra‑nʉ́, bbʉ i bbʉ yojo‑quiguɛjʉ yʉ i e̱me̱gui, cja̱ bbʉ i hnagu̱dihui ca xí mbe̱ni da dyöjpihui cam Tzi Ta pʉ ji̱tzi, guegue da dyøte ncja ngu̱ ga dyöjpihui. ");
INSERT INTO otsNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pʉ jabʉ i mpɛjni yojo o jñu̱ cja̱hni cʉ i nzojtigui cam tzi tju̱ju̱, dí bbʉjcö pʉ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Diguebbʉ ya, car Pedro bi guati car Jesús cja̱ bi dyöni: ―Bbʉ te da dyøjtigui cam hñohui cja̱ da dyöjqui gu perdonabi, ¿tengu̱ vez gu perdonabi? ¿Cja gu perdonabi hasta yojto vez?― ");
INSERT INTO otsNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Car Jesús bi da̱di, i̱na̱: ―Dí xihqui, jin gui jøntsjɛ yojto vez gui perdonabi. Gui segue gui perdonabi göhtjo cʉ vez cʉ da dyöhqui. ");
INSERT INTO otsNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gui dyøjmʉ ya nʉr bbede‑nʉ́ pa gui pa̱dijʉ ja ncja da mbe̱n yʉ cja̱hni yʉ i bbʉ jár dyɛ ca Ocja̱ cja̱ i jñɛgui pa da mandadobi‑yʉ́. Mí bbʉh ca hnar rey, mí hñi̱ muzo cʉ mí pɛjpi. Nucʉ, mí nu̱htibi quí jöy cja̱ co cár domi. Ca hnar pa, car rey mí ne di dyʉhtibi ʉ́r huɛnda quí muzo, eso, bi nzojmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hna‑hnáa gá nzofo pa di dyʉhtibi ʉr huɛnda. Bbɛto bú e̱h hnar muzo ca mí tu̱jpi hnar tjöy rá ndo ngu̱. Mí tu̱jpi cár jmu̱ ddɛtta mil cʉ domi cʉ mí tsjifi talento. ");
INSERT INTO otsNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Como jin te mí ja̱ car muzo‑cá̱ pa drí gu̱ti cár tjöy, car rey ya, bi bbɛjpi di ma du joni pé hnar jmu̱ ca di cuajti gá muzo, cja̱ guegue‑cá̱ di gu̱htibi cár tjöy. Nubbʉ́, car muzo di pɛjpi göhtjo ʉ́r vida cár jmu̱‑cá̱. Guejti cár bbɛjña̱ car muzo, co quí ba̱jtzi, di guatijʉ pʉ hne̱je̱, pé di cjajʉ muzo, göhtjo di mföxjʉ. Guejtjo pé di bbö göhtjo ca mí pɛhtzijʉ, pa ncjapʉ di zøx car tjöy. ");
INSERT INTO otsNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bbʉ mí dyøh car muzo ter bɛh ca̱ bi bbɛjpi cár jmu̱, bi ndo ntzøte cja̱ bi ndo ungui ʉr du̱mʉy. Bi hmɛm pʉ jáy hua car rey, cja̱ bi ndo ttzi̱ni di perdonabi cja̱ di døhmi tzʉ. Bi xifi: “Nuquɛ, Jmu̱, pé gui tzi tøbigui tzʉ. Xtá nú̱gö ja grá cju̱jtiqui göhtjo ca dí tu̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Diguebbʉ ya cár jmu̱ bi jui̱jqui, bi jiɛgui di ma libre. Ya jin gá cobrabi car tjöy ca mí tu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Bi bøn ya car muzo pʉ jabʉ már bbʉh car rey. Bi ma guí ntjɛhui hna quí mi̱nga̱‑muzohui ca mí tu̱jpi hnar tjöy, jin tza mí ngu̱. Mí tju̱jpi hna cientotjo cʉ domi cʉ mí tsjifi denario. Ca bbɛto ʉr muzo ya, bi mi̱htibi ʉ́r dyʉga ca hnáa, cja̱ bi xifi: “Ex xca cju̱jtigui ya ca guí tu̱jqui.” ");
INSERT INTO otsNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nu cár mi̱nga̱‑muzohui bi hmɛm pʉ jáy hua, bi ndo dyöjpi favor, bi xifi: “Gui tzi tøbigui tzʉ. Xtá jon car manera ja gár cju̱jtiqui quer tjöy.” ");
INSERT INTO otsNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nu guegue jin gá ne gá jui̱jqui cár hñohui. Bi dyɛni, bú coti jar födi, bi xifi di hmʉjti pʉ hasta bbʉ di gu̱ti cár tjöy. ");
INSERT INTO otsNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nu cʉ pé dda quí mi̱nga̱‑muzojʉ, bbʉ mí dyødejʉ te xquí dyøti car muzo‑cá̱, bi ndo zøti í mʉyjʉ, cja̱ bi möjmʉ bú xih cár jmu̱jʉ göhtjo te xquí ncja. ");
INSERT INTO otsNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nubbʉ́, cár jmu̱jʉ pé bi nzojti car muzo ca xquí perdonabi, cja̱ bi xifi: “Nuquɛ, gúr nttzomfe̱ni muzoguɛ. Dú perdonaqui göhtjo car ndo tjöy ca nguí tu̱jqui, jøntsjɛtjo porque gú dyöjqui favor. ");
INSERT INTO otsNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Xiquiguɛ ya, ¿cja jí̱ mí tzö güi jui̱jqui quer mi̱nga̱‑muzohui, como ngu̱gö, xtú jui̱quiqui?” Ncjapʉ gá nzofo. ");
INSERT INTO otsNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cja̱ bi ndo ungui ʉr cuɛ cár jmu̱jʉ cʉ muzo‑cʉ́, bi döjti ʉ́r dyɛ cʉ comandante car muzo‑cá̱, pa di ttʉni hasta gue bbʉ di gu̱ti göhtjo ca mí tu̱. Ncjapʉ gá dyøti car rey co car muzo ca jin gá perdonabi cár hñohui. ");
INSERT INTO otsNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nugö, dí xihquijʉ, cam Tzi Ta ca bí bbʉ ji̱tzi da cjahquijʉ ncjadipʉ bbʉ jin gui perdonabi quir hñohuijʉ, göhtjo mbo ir mʉyjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bi guadi bi ma̱ göhtjo yʉ palabra‑yʉ́, cja̱ diguebbʉ ya car Jesús bi bøm pʉ Galilea gá ma jar jöy Judea, cja̱ bi ddatzi gá ma pʉ rí ncjapʉ jar da̱tje Jordán. ");
INSERT INTO otsNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bi dɛnijʉ rá ndo ngu̱ cʉ cja̱hni, cja̱ car Jesús bi dyøtje cʉ döhtji. ");
INSERT INTO otsNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Diguebbʉ ya, cʉ dda fariseo bi guati pʉ jabʉ már bbʉh car Jesús, mí jonijʉ ja drí da̱pijʉ. Mí ne di cjajpijʉ di ma̱ tema palabra ca jin di tzö. Eso, bi dyönijʉ nʉr nttöni‑nʉ́: ―¿Cja i pɛhtzi derecho hnar hñøjø da mɛh cár bbɛjña̱ bbʉ i töhtibi tema cosa ca jin di tzøpi?― ");
INSERT INTO otsNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Guegue car Jesús bi da̱di̱, i̱na̱: ―¿Cja jin guí cca̱htijʉ te i ma̱m pʉ jar Escritura? Bbʉ jin te bbe mí bbʉj yʉ cja̱hni, ca Ocja̱ bi dyøti hnar hñøjø co cár bbɛjña̱ pa di hmʉbi. ");
INSERT INTO otsNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Guejtjo bi ma̱n ca Ocja̱: “Bbʉ xí ndöti cár bbɛjña̱ hnar hñøjø, rí ntzöhui da weguehui cár ta, cár me, pa da hmubi cár bbɛjña̱. Nubbʉ́, cʉ mí yojo má̱hmɛto, da ncja hnadi cár hmʉyhui.” Ncjapʉ ga ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bbʉ ya xqui bbʉbi hnar hñøjø cár bbɛjña̱, ya xqui cjá ncja ngu̱ hnatjo ʉr cja̱hni ya. Ca Ocja̱ ya jin gui cca̱hti‑cʉ́ ncja ngu̱ yojo cja̱hni. Eso, dí xihquijʉ, jin gui tzö bbʉ to da wejqui yʉ ya xí ntja̱jti, como gue ca Ocja̱ xí pɛjni quí vidahui.― Bi da̱h car Jesús ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Guegue cʉ fariseo pé bi dyönijʉ, bbʉ: ―Sá gá mandado car Moisés, bbʉ, i̱na̱: “Hnar hñøjø, bbʉ i ne da juejmi cár bbɛjña̱, da dyøhtibi hnar jɛhmi gá ntsjʉjqui‑ntja̱jti pa da dɛx car bbɛjña̱. Da ncjapʉ da jogui drí jueguehui.”― ");
INSERT INTO otsNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nu car Jesús bi da̱di: ―Car Moisés bi ddahquijʉ ʉr tsjɛjqui güi mpojmʉ quir bbɛjña̱jʉ porque mí pa̱ guegue, nuquɛjʉ, jin guí ma̱jtejʉ cja̱ jin guí ne gui hmʉpjʉ ncja ngu̱ ga ma̱n ca Ocja̱. Nu ca Ocja̱, bbʉ mí dyøti nʉr jöy jar mʉdi, jin gá dyøhtibi car hñøjø hnár bbɛjña̱ pa di mpoguihui. ");
INSERT INTO otsNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nugö, dí xihquijʉ, i pɛhtzi ʉr tsjɛjqui hnar hñøjø pa da mɛh cár bbɛjña̱ jøntsjɛ bbʉ xtrú yojmi pé hnar hñøjø. Car hñøjø ca ya xtrú mɛh cár bbɛjña̱, bbʉ pé da ntja̱jtihui pé hnáa, i yohti bbɛjña̱, bbʉ. Guejti car hñøjø ca da ntja̱jtihui hnar bbɛjña̱ ca xí bbɛgui, i yohti bbɛjña̱ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nu quí möxte car Jesús, bbʉ mí dyøjmʉ nʉr palabra‑nʉ́, bi ma̱jmʉ: ―Bbʉ jin to i pɛhtzi derecho da juejmi cár bbɛjña̱, jøntsjɛtjo bbʉ xtrú hmʉbi pé hnar hñøjø, mejor jin to da ntja̱jti, bbʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Guegue bi da̱di, bi hñi̱mbijʉ: ―Jin gui göhtjo yʉ cja̱hni da jiöti da hnatsjɛ, jøntsjɛtjo cʉ ddáa cʉ xí mbe̱n car Tzi Ta ji̱tzi da hmʉy ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","I bbʉh cʉ dda cja̱hni cʉ jin gui conveni da ntja̱jti. Exque mbá ncjapʉ desde car pa ca bi hmʉy. Guejtjo i bbʉh cʉ dda cja̱hni cʉ jin gui tzö da ønte, por rá ngue ca te xí ttøhtibi quí cuerpojʉ. Nucʉ́, jin gui conveni da ntja̱jti, hne̱je̱. Guejtjo i bbʉh cʉ pé dda cja̱hni cʉ jin gui ntja̱jti, porque i nejʉ jøña̱ ca Ocja̱ da sirvebijʉ. Bbʉ to i jöti da hnatsjɛ, cja̱ i ne da ungui ʉ́r mʉy pa da sirvebi jøña̱ ca Ocja̱, pa guegue bí jogui jin da ntja̱jti.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Diguebbʉ ya, bú ttzijmpi car Jesús cʉ dda tzi ba̱jtzi. Bi ttöjpi di dyʉx quí dyɛ jáy ña̱jʉ cja̱ di orabi. Nu quí möxte bi huɛnti cʉ cja̱hni cʉ mbá tzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nu car Jesús bi xijmʉ: ―Jiɛjmʉ yʉ tzi ba̱jtzi du e̱cua jabʉ dí bbʉy. Dyo guí ccahtzijʉ, porque i jñɛjmʉ yʉ tzi ba̱jtzi cʉ cja̱hni cʉ i cuati jár dyɛ ca Ocja̱ pa da jñɛguijʉ da mandadobijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nubbʉ́, car Jesús bi dyʉx quí dyɛ jáy ña̱ cʉ tzi ba̱jtzi, bi dyöjpi car Tzi Ta ji̱tzi di bendeci. Cja̱ diguebbʉ ya, pé bi ma pé hnar lugar. ");
INSERT INTO otsNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Diguebbʉ ya, bú e̱h hnar ba̱jtzi hñøjø, bi guati car Jesús, bi xifi: ―Nuquiguɛ, Maestro, gúr jogui cja̱hni, xijqui tzʉ tema cosa drá zö gu øte pa gu töti car nzajqui ca jin da tjegue.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nu car Jesús bi da̱di: ―¿Te rá nguehca̱ guí öngui ja i ncja ca rá zö? Hnáatjo ca to i bbʉy ntju̱mʉy rá zö, gue ca Ocja̱ ca bí bbʉ jar ji̱tzi. Nuquiguɛ, bbʉ guí ne gui pɛhtzi car nzajqui ca jin da tjegue, gui dyøjti cʉ mandamiento cʉ bi zoguijʉ car Moisés.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Cja̱ car ba̱jtzi hñøjø pé bi dyöni bbʉ: ―¿Tema mandamiento‑cʉ́?― Cja̱ car Jesús bi da̱di: ―Gue cʉ i ma̱: “Jin gui pöhtite. Jin gui jiöti hnahño bbɛjña̱. Jin gui mpe̱. Jin gui ña̱jqui bbɛtjri. ");
INSERT INTO otsNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gui hñi̱htzibi quer ta hne̱h quer me. Gui ne quer hñohui, como ngu̱ gri netsjɛ.”― ");
INSERT INTO otsNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nubbʉ́, bi ma̱n car ba̱jtzi hñøjø, bbʉ: ―Ya xtú øte göhtjo‑yʉ́ desde bbʉ ndúr ba̱jtzitjo. ¿Te pé hnar cosa i nesta pa gu øte?― ");
INSERT INTO otsNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Car Jesús bi xih, bbʉ: ―Bbʉ guí ne gui dyøte göhtjo ca i ne ca Ocja̱, gui ma bú pö göhtjo cʉ guí pɛhtzi, cja̱ gui un car domi yʉ cja̱hni yʉ jin te i ja̱. Da ncjapʉ grí pɛhtzi ca rá tzi zö pʉ jar ji̱tzi. Cja̱ diguebbʉ ya, pé gu e̱je̱, gui tɛngui, bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nu car ba̱jtzi hñøjø, bbʉ mí dyøj nʉr palabra‑nʉ, bi ndo du̱mʉy gá má, porque már ndo ngu̱ cʉ mí pɛhtzi. ");
INSERT INTO otsNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Diguebbʉ ya, car Jesús bi xih quí amigo cʉ mí tɛni: ―Gui mbe̱nijʉ nʉr palabra nʉ dí xihquijʉ, i ndo tzöjpi rá ndo ntji̱ yʉ rico drí guati jár dyɛ ca Ocja̱ cja̱ drí jñɛgui pa da mandadobi. ");
INSERT INTO otsNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dí xihquijʉ, jin gui tzö da tjoh hnar camello pʉ jár gu̱ hnar dyofani. Guejtjo drá ndo ntji̱ pa hnar rico drí guati jár dyɛ ca Ocja̱, cja̱ drí jñɛgui pa da mandadobi.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nu quí möxte car Jesús, bbʉ mí dyøj ya‑nʉ́, bi ndo hño í mʉyjʉ, bi hñöntsjɛjʉ: ―Nubbʉ́, ¿toca̱ da jogui da döti car nzajqui ca jin da tjegue?― ");
INSERT INTO otsNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nu car Jesús bi cca̱hti quí möxte, cja̱ bi da̱di: ―Cierto, yʉ cja̱hni jin gui tzö da ñʉtitsjɛjʉ pʉ jabʉ bí bbʉh ca Ocja̱. Nu ca Ocja̱, i pa̱di ja da cjajpi yʉ cja̱hni pa da jogui drí ñʉtijʉ pʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Diguebbʉ ya, car Pedro bi xifi: ―Xigöje ya bbʉ́, xtú tzoguije göhtjo pa xtá tɛnquije. ¿Ter bɛh ca̱ gu ta̱cöje ya, bbʉ́?― ");
INSERT INTO otsNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Cja̱ bi da̱h car Jesús, i̱na̱: ―Nuquɛjʉ, xcú tɛnguijʉ, cierto da ttahquijʉ hnar tja̱ja̱ rá tzi zö hne̱je̱. Bbʉ xta ttøte ddadyo nʉr jöy, cja̱ xtá mandadogö pʉ, xtá mi̱h pʉ jabʉ da hñi̱zqui yʉ cja̱hni, cja̱ xta ni̱gui te tza rá nzɛjqui. Hne̱hquiguɛjʉ, guí docejʉ, xtí mi̱pjʉ hnanguadi pʉ jabʉ gu mi̱jcö, xtí föxquijʉ cam jmandado. Xtí cjajʉ nzöya, xtí jña̱mpijʉ ʉr huɛnda göhtjo yʉ cja̱hni israelita. Guehcá̱ da ttahquijʉ‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Cja̱ pé dí xihquijʉ, göhtjoquiguɛjʉ como ngu̱ gri ne gui tɛnguijʉ, ca to da zo ʉ́r ngu̱ o quí hñohui, o cár ta, o cár me, o quí ba̱jtzi, o quí jöy, bbʉ da zoh‑cʉ́ por rá nguejquigö, guegue da ncohtzibi más drá ndo ngu̱ ni digue cʉ xí nzogui, menta i bbʉjti hua jar jöy. Cja̱ bbʉ ya xtrú nguah cár vida hua jar jöy, guejtjo da mɛhtzi car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pe i bbʉ rá ngu̱ cja̱hni cʉ i tti̱htzibi yʉ pa ya, cja̱ nucʉ́, bbʉ pé xcuá e̱cö, jin da tti̱htzibi‑cʉ́. Guejtjo i bbʉh cʉ dda cja̱hni cʉ jin gui tti̱htzibi yʉ pa ya, pe nucʉ́, da ndo tti̱htzibi bbʉ pé xcuá e̱cö.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Car Jesús pé bi ma̱n nʉr bbede‑nʉ́, pa di ba̱dijʉ ja ncja ga mandado ca Ocja̱. Bi ma̱ guegue: ―Mí bbʉh hnar hñøjø, mí tjɛ jöy, cja̱ mí pɛhtzi hnar huerta gá uva. Ca hnar pa ya, bi bøni nxu̱ditjo, bi má bú joni mɛfi, cja̱ bú reglahui pa di pɛh pʉ jár huerta gá uva. ");
INSERT INTO otsNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Car jmu̱ bi reglahui cʉ mɛfi, cada hnáa di da̱h hnar domi gá denario cada pa. Cja̱ diguebbʉ ya guegue bi gu̱h cʉ mɛfi gá möjmʉ jár huerta pa du pɛjmʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cja̱ bbʉ ya xti zʉ ngu̱ gʉjto xu̱di, car jmu̱ bi ma gá ma jar töy, bi jianti cʉ dda mɛfi, már bböjti pʉ, jin te már pɛjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cja̱ guegue bi xijmʉ: “Guehquitjoguɛjʉ, gui möjmʉ jam huerta ya, cja̱ xtá cju̱jtiquijʉ ca drí ntzöhui gui ta̱jmʉ.” Cja̱ bi möjmʉ cʉ mɛfi‑cʉ́, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bbʉ ya xti zʉ ngu̱ ju̱xadi, pé bi bøn car jmu̱ gá ma jar töy. Cja̱ pé hnar vez bi dyøtitjo ncjadipʉ bbʉ ya xti zʉ jñu̱ nde. Cada vez, bi döti pé dda mɛfi, bi reglahui‑cʉ́, cja̱ bi gu̱h pʉ jár huerta. ");
INSERT INTO otsNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Cja̱ bbʉ ya xti zʉ ngu̱ cʉtta nde, pé bi bøn car hñøjø, cja̱ pé bú töti pé dda mɛfi, már bböjti pʉ jar töy, jin te már pɛjmʉ. Cja̱ bi dyönijʉ: “¿Dyoca̱ guí bböjtijʉ hua, göhtjo ʉr pa, jin te guí pɛjmʉ?” ");
INSERT INTO otsNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bi da̱dijʉ guegue‑cʉ́, bi hñi̱na̱: “Porque u̱jtjo jin to i cupaguije.” Car jmu̱ ya bi xijmʉ: “Hne̱hquiguɛjʉ, gui möjmʉ jam huerta, hne̱je̱, cja̱ xtá cju̱jtiquijʉ ca drí ntzöhui.” Cja̱ nucʉ́, bi möjmʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Bbʉ ya xquí nde, car hñøjø ca múr mɛjti car huerta gá uva bi nzoh ca hnar mɛfi ca mí nú̱ cʉ pé ddáa, bi xifi: “Nuya, gui mahti cʉ mɛfi, cja̱ gui cju̱hti cada hnaa cár tja̱ja̱. Dí fʉdi, gui cju̱hti cʉ xcá nga̱tzi xí ñʉti, cja̱ drí ga̱x ya, cʉ tza xcá mʉdi xí ñʉti. Gui uni cada hnáa hnár denario.” ");
INSERT INTO otsNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Diguebbʉ ya, bú e̱h cʉ mɛfi. Bbɛto bú e̱h cʉ xquí ñʉti ngu̱ cʉtta nde, cja̱ bi ttunijʉ hna‑hnár domi gá denario. ");
INSERT INTO otsNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Diguebbʉ ya, pé bú e̱h cʉ mɛfi cʉ bbɛto xquí ñʉti, gá mbe̱n‑cʉ́ di nccu̱htijʉ más drá ngu̱ ni digue cʉ xquí ñʉti bbʉ ya xquí nde. Cja̱ guejti‑cʉ́ bi ttunijʉ hna‑hnár domi gá denario. ");
INSERT INTO otsNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cja̱ bbʉ mí nccu̱hti‑cʉ́, bi zanijʉ car jmu̱, i̱na̱jʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Nuquɛ, Jmu̱, yʉ mɛfi yʉ cja xí nzøjø xí pɛfi hna horatjo, cja̱ xcú cju̱htitjo‑yʉ́ ncja ngu̱göje. Nugöje, xí mbo ʉm cuɛje cor bbɛfi, xtú dejpaje jar jiadi rá mpa.” ");
INSERT INTO otsNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nu car jmu̱ bi da̱di, bi xih ca hnar mɛfi ca már queja, i̱na̱: “Dyøjma̱ja̱, ñø, jin te dí øjtiqui. ¿Cja jí̱ xtú reglahui hnar domi gá denario güi ta̱ja̱? ");
INSERT INTO otsNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jña̱ ya nir mɛjti cja̱ gui má. ʉm gustogö, dí ne gu uni yʉ cja xí ñʉti, ddagu̱di ca xtú cju̱jtiquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ʉm mɛjtigö nʉr domi. ¿Cja jin dí pɛhtzi derecho gu cjajpi ca dí ne? ¿Cja huá guí mvidiabi quer hñohui porque xtú un cam gusto?”― ");
INSERT INTO otsNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nu car Jesús pé bi xih cʉ to már øde: ―Da ncjapʉ drí zʉh car jña̱ ca xtú xihquijʉ: Cʉ dda cja̱hni cʉ ba bbɛfa, da jñɛjtihui cʉ xí hmɛto. Nu cʉ ddáa cʉ xí hmɛto, da jnu̱jʉ parejo co ni cʉ ba bbɛfa. Ca Ocja̱ xí nzofo rá ngu̱ cja̱hni, pe jin gui ngu̱ cʉ xí juajni.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cja̱ bbʉ ya xi má pa jar hñu̱ car Jesús, má pøtze pa drí ma Jerusalén, bi wejqui cʉ doce quí möxte cʉ más mí ntzixihui, gá ma hnanguadi, cja̱ bi xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Nuya, dá pøxijʉ drá mö Jerusalén. Nu pʉ Jerusalén xta ndöguigö jáy dyɛ cʉ möcja̱ cʉ i mandado cja̱ co jáy dyɛ cʉ maestro cʉ i u̱jti yʉ cja̱hni car ley. Cja̱ guegue‑cʉ́ da sentenciagui pa da bböjtigui. Guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pʉ Jerusalén da ndöguigö jáy dyɛ cʉ cja̱hni cʉ jin gui meya ca Ocja̱. Da i̱mbiguijʉ, cja̱ da jiʉbiguijʉ, cja̱ da døjquijʉ jar ponti pa gu tu̱. Pe bbʉ xtrí zʉ jñu̱jpa, pé gu jña̱ ʉm jña̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Diguebbʉ ya bú e̱h cár bbɛjña̱ car Zebedeo. Guegue múr me car Jacobo co car Juan, mbá yojmi quí ttʉ, cja̱ bi guatijʉ car Jesús. Cár mehui ya bi nda̱ndiña̱jmu̱ pʉ jáy hua car Jesús, cja̱ bi dyöjpi hnar favor. ");
INSERT INTO otsNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Cja̱ car Jesús bi dyöni: ―¿Tema favor guí ne gui dyöjqui tzʉ?― Cja̱ bi ma̱n car bbɛjña̱, bbʉ: ―Gui hñi̱x tzʉ yʉ yojo yʉm ttʉ pa da möxqui bbʉ xtí jña̱ quer cargo, xtí mandado.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nu car Jesús, bi nzoh cʉ yojo quí ttʉ car bbɛjña̱, tzʉdi, car Jacobo co car Juan, bi hñi̱mbihui: ―Nuquɛhui, jin guí pa̱dihui ter fɛh ca̱ xcú dyöjquihui. ¿Cja gui jiötihui gui sufrihui ncja ngu̱ gár sufrigö?― Cja̱ bi da̱jmi car Jacobo co car Juan: ―Ja̱a̱, gu jötibbe‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma ya, car Jesús bí xijmi: ―Cierto, gui ma gui sufrihui ncja ngu̱ gár sufrigö, pero pa gui mi̱bi jam jogui dyɛ cja̱ co jam ntchohta, gui föxquihui cam jmandado, jin dí pɛhtzigö derecho gu ddahquihui‑cá̱. Jøntsjɛ cam Tzi Ta ji̱tzi da ma̱ to cʉ cja̱hni cʉ da mi̱h pʉ, como ya xí mbe̱ni guegue tocʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu cʉ pé ddɛtta quí möxte car Jesús, bbʉ mí dyøj nʉr favor nʉ xquí dyöh car Jacobo co car Juan, bi tsjeyabijʉ cʉ yo ncjua̱da̱‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Diguebbʉ ya, car Jesús bi nzoh cʉ doce quí möxte, bi xijmʉ: ―Nuquiguɛjʉ, ya xquí pa̱dijʉ ja ncja ga dyøti yʉ cja̱hni yʉ jin gui e̱me̱ ca Ocja̱. Cʉ rey cja̱ co cʉ pé dda autoridad i mandadobijʉ cʉ pé ddáa. I ndo øhtibijʉ cár fuerza cʉ cja̱hnitjo, cja̱ i huɛhtijʉ pa da mpɛgui da cja ca i bbɛjpijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pe nuquɛjʉ, jin gui ma gui ncjajʉ pʉ. Nuquiguɛjʉ, ca to i ne más da tti̱htzibi, guegue‑cá̱ da pɛjpi yʉ pé ddáa. ");
INSERT INTO otsNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Cja̱ ca to i ne da mandado, guegue‑cá̱ da cja ir muzoguɛjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Gui nxödijʉ gui hmʉpjʉ ncja ngu̱ dar hmʉjcö. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy. Jí̱ xtá e̱je̱ pa gua mandadobi yʉ cja̱hni di pɛjpigui‑yʉ́. Xtá e̱jcö pa gu fötzi rá ngu̱ yʉ cja̱hni, hasta gu dö nʉm vida, gu tú̱, pa da dötijʉ car nzajqui ca jin da tjegue.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cja̱ bbʉ mí bøn car Jesús co quí möxte pʉ jar jñini Jericó, bi dɛni hnar ndo jmundo cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hnanguadi car hñu̱ pʉ jabʉ má pöjmʉ, már ju̱ yojo godö. Nucʉ́, bbʉ mí dyøde má tjoh pʉ car Jesús, bi majmi nzajqui, bi hñi̱na̱hui: ―Nuquɛ, Tzi Jmu̱, gui jui̱guigöbbe tzʉ. ʉ́r cjiquiguɛ car rey David, xquí hñe̱je̱ pa gui föxquigöje.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Cʉ cja̱hni ya, bi huɛhti, bi xijmi di gohti í nehui. Nu cʉ godö ya, más mír ndo majmi nzajqui, mí i̱na̱hui: ―Nuquiguɛ, Tzi Jmu̱, gui jui̱guigöbbe tzʉ. ʉ́r cjiquiguɛ car rey David, xquí hñe̱je̱ pa gui föxquigöje.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Bi dyøh car Jesús te már majmi, bi hmöy, cja̱ bi nzoh cʉ godö, bi hñi̱mbihui: ―¿Te guí ne gu cjahquihui?― ");
INSERT INTO otsNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Cja̱ gueguehui bi xijmi: ―Dí nebbe gui xoguiguibbe yʉm döbbe.― ");
INSERT INTO otsNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Car Jesús bi jui̱jquihui cja̱ bi mötzi. Bi dyʉx quí dyɛ pʉ jáy dö cʉ godö. Cja̱ nguetica̱ bi xoh quí dö bbʉ. Nubbʉ́, cʉ yojo hñøjø bi dɛn car Jesús, bi mɛhui. ");
INSERT INTO otsNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Car Jesús co quí möxte ya xti zøtijʉ jar jñini Jerusalén, cja̱ bi tjoh pʉ hnar tzi jñini mí tsjifi Betfagé. Car tzi jñini‑cá̱ mí bbʉ jár ndʉy car ttøø ca mí tsjifi Cerro de los Olivos. Cja̱ bbʉ mí zøti pʉ, car Jesús bi gu̱ yojo quí möxte di ma hnar jmandado. ");
INSERT INTO otsNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Bi xijmi: ―Gui mɛhui nʉ jar tzi jñini nʉ rá cjanʉ, cja̱ xquí tötihui hnar meburro, rá hna̱ti pʉ, yojmi cár ba̱jtzi. Gui xohtihui cja̱ gu ɛhui hua. ");
INSERT INTO otsNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Cja̱ bbʉ to te du xihquihui, gui xijmi: “Janti, cam Tzi Jmu̱göje i joni‑yʉ́. Pé xcuá cobbe hna rato, xtá tzoguibbe.” ");
INSERT INTO otsNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Car Jesús bi bbɛjpi quí möxte di ma du tzimpi hnar ba̱jtzi burro pa di tøgue, como mí pa̱di, ya xquí zøh car hora pa di ncumpli car palabra ca xquí ma̱n car profeta, ya má yabbʉ. Bi ma̱ ncjahua car profeta: ");
INSERT INTO otsNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gui xijmʉ cʉ mi̱ngu̱ Jerusalén: “Jiantijma̱jʉ, ya xpa e̱j nir reyjʉ, hne̱ da mandadoquijʉ. Guegue‑nʉ́ jin gui hñi̱xtsjɛ‑nʉ́. Janti, ʉr tzi burrotjo nʉ ba tøgue, Ba tøj nʉ́r ba̱jtzi nʉr meburro, cja̱ nʉr meburro ba bbɛfa.” Ncjapʉ gá ma̱n car profeta. ");
INSERT INTO otsNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nubbʉ, cʉ yojo quí möxte car Jesús bi mɛhui bú øtihui ncja ngu̱ gá ma̱ngui guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Cja̱ pé bú cojmi, bú ɛhui car meburro, yojmi cár ba̱jtzi, cja̱ bi ga̱htzihui quí da̱jtu̱ cʉ mí pötihui jár xʉtja car tzi burrotjo. Diguebbʉ ya, car Jesús bi tøh car ba̱jtzi burro. ");
INSERT INTO otsNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Cʉ cja̱hni rá ngu̱ cʉ xquí jmu̱ntzi, guejtjo má pøh quí pötijʉ, má xi̱h pʉ jar hñu̱, cja̱ cʉ ddáa, má wajquibi quí dyɛ cʉ za. Má bbɛtojʉ, má pøjmʉ cʉ xiza pʉ jar hñu̱ pʉ jabʉ di tjoh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Már ndo ngu̱ cʉ cja̱hni cʉ má yojmʉ car Jesús. Má bbɛto cʉ ddáa, nu cʉ ddáa má bbɛfa. Göhtjo má majmʉ nzajqui, má i̱na̱jʉ: ―¡Gloria a Dios! Dí xöjtibijʉ nʉm reyjʉ nʉ ya xpa e̱je̱ pa da mandadoguijʉ. Car Tzi Ta ji̱tzi da bendeci nʉr rey nʉ xpá mɛjnquijʉ guegue. Guejnʉ guá hñe̱je̱ digue cár cji car David. ¡Da tsjöjtibi hua jar jöy cja̱ guejti pʉ ji̱tzi!― Ncjapʉ nguá ma̱n cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bbʉ mí ñʉti car Jesús jar jñini Jerusalén, göhtjo cʉ mi̱ngu̱ pʉ, bi ndo hño ʉ́r mʉyjʉ, cja̱ bi hñönijʉ: ―¿To ya nʉ xí nzøjø?― ");
INSERT INTO otsNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Cja̱ cʉ cja̱hni cʉ mbá hñohui car Jesús bi da̱dijʉ, i̱na̱jʉ: ―Gue nʉr Jesús, ʉ́r jmandadero ca Ocja̱ nʉ ba ja̱ cár palabra guegue‑cá̱. ʉr mi̱ngu̱ car jñini Nazaret, pʉ jar estado Galilea.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Diguebbʉ ya, bi ñʉti car Jesús jár ndo templo cʉ judio. Nu pʉ jár patio car templo, bi cca̱hti cʉ cja̱hni cʉ mí töjmʉ zu̱we̱ pa di möhtijʉ cja̱ di ña̱htibijʉ ca Ocja̱ pʉ jar altar. Guejtjo már bbʉh pʉ cʉ cja̱hni cʉ mí pöjʉ cʉ zu̱we̱‑cʉ́. Nu car Jesús bi fongui göhtjo cʉ cja̱hni‑cʉ́, co quí zu̱we̱. Bi dyentibi quí mexa cʉ pöti‑domi, hne̱h quí tju̱jni cʉ cja̱hni cʉ már pö paloma. ");
INSERT INTO otsNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Cja̱ bi xijmʉ: ―I ma̱m pʉ jar Escritura: “Nu hua na̱r ngu̱‑na̱ da tsjifi ʉr ngu̱ pa da nzoh ca Ocja̱ yʉ cja̱hni,” pe nuquiguɛjʉ, xcú cjajpitjojʉ ncja ʉ́r ngu̱ ʉr be̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bbʉ már bbʉh car Jesús pʉ jár tji car templo, bi guati cʉ dohua hne̱h cʉ godö, cja̱ guegue bi jojqui. ");
INSERT INTO otsNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nu cʉ möcja̱ cʉ mí mandado, hne̱h cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley bi cca̱htijʉ car Jesús cja̱ co cʉ milagro cʉ már øte. Guejtjo bi dyøh cʉ ba̱jtzi hñøjø cʉ már xöjtibijʉ guegue. Már mah cʉ ba̱jtzi‑cʉ́: “Dí xöjtibijʉ nʉm reyjʉ nʉ guá hñe̱je̱ digue cár cji car David.” Nu cʉ maestro cʉ mí nxöh car ley cja̱ co cʉ möcja̱ cʉ mí mandado, bbʉ mí dyødejʉ cʉ ba̱jtzi hñøjø, már xöjtibijʉ car Jesús, bi ndo ntsjeyajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Cja̱ bi xijmʉ car Jesús: ―Jin gui tzö nʉr palabra nʉ i ma̱n yʉ ba̱jtzi hñøjø yʉ i xöjtiqui.― Nu car Jesús bi da̱di: ―Dí ma̱ngö, rá zö nʉ i ma̱n‑yʉ́. Xiquiguɛjʉ, ¿cja jin guí cca̱htijʉ car palabra ca i ma̱m pʉ jar Escritura? I ma̱ ncjahua: Rá tzi zö cár tsjödi cʉ tzi ba̱jtzi bbʉ ga xöjtibi ca Ocja̱, Hasta cʉ tzi ba̱jtzi cʉ i tzʉtjo, i ndo tzøpi ca Ocja̱ cár tsjödijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Diguebbʉ ya, car Jesús bi wembi cʉ hñøjø‑cʉ́, bi bøm pʉ jar jñi̱ni Jerusalén, bi ma gá ma jar tzi jñi̱ni Betania, cja̱ bú ox pʉ. Guejti quí möxte bi ma pʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Car jiax ya cá̱, bbʉ mí nxu̱di, bi ma gá ngojmʉ Jerusalén. Bbʉ má dyojʉ jar hñu̱, ya xi mí tu̱ntju̱ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bi cca̱hti hnar za gá higo, mí jø pʉ hnanguadi car hñu̱. Car Jesús bi guati, bi cca̱hti, ¿cja mí tu̱ higo car za? Pe u̱jtjo, jøntsjɛ quí xi. Cja̱ bi nzoh car za, bi xifi: ―Desde rá pa ya, göhtjo ʉr tiempo, jin te gui ungui higo.― Cja̱ nguetica̱ bi mʉdi bi dyoti car za gá higo. ");
INSERT INTO otsNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cja̱ bbʉ pé má tjojmʉ pʉ jabʉ mí jø car za‑cá̱, quí möxte car Jesús bi cca̱hti car za, ya xquí dyoti. Nubbʉ́, bi hño í mʉyjʉ cja̱ bi dyönijʉ car Jesús: ―¿Dyoca̱ hna hnijitjo xí dyoti nʉr za?― ");
INSERT INTO otsNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Car Jesús bi da̱di, bi xijmʉ: ―Cierto, dí xihquijʉ, bbʉ gui hñe̱me̱jʉ ca Ocja̱ göhtjo mbo ir mʉyjʉ, cja̱ jin gui yomfe̱nijʉ, ¿cja da jogui da dyøti ca guí öjpijʉ? nubbʉ́, da jogui gui dyøti cʉ dda cosa más drá ntji̱ ni ndra ngue ca xtú cjajpi nʉr za gá higo. Nubbʉ́, bbʉ gui bbɛjpijʉ nʉr ttøø nʉ bí cjanʉ da wengua drí hñɛnti jar mar, da ncja‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bbʉ gui hñe̱me̱jʉ, rá nzɛh ca Ocja̱, cja̱ gui tøhmijʉ da ncja ca guí öjpijʉ, nubbʉ́, cierto da ncja‑cá̱, bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Diguebbʉ ya, car Jesús pé bi ñʉti pʉ jár patio car ndo templo, cja̱ bi mʉdi bi u̱jti cʉ cja̱hni cár palabra ca Ocja̱. Cja̱ pé bi guati cʉ möcja̱ cʉ mí mandado hne̱h quí tita cʉ cja̱hni israelita cʉ mí ja̱ ʉ́r cargojʉ. Guegue‑cʉ́ bi dyönijʉ car Jesús: ―¿Tema cargo guí ja̱guɛ pa gui mandado hua jar templo? ¿Toca̱ xí ddahqui quer cargo?― ");
INSERT INTO otsNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Cja̱ car Jesús bi da̱di, bi hñi̱mbijʉ: ―Guehquitjoguɛjʉ, gu önquijʉ hnar nttöni, hne̱je̱. Bbʉ gui xijquijʉ ca ncjua̱ni ca gu önquijʉ, nubbʉ, xtá tja̱jcö ca xcú dyönguijʉ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Car Juan ca mí xix cʉ cja̱hni, ¿jabʉ xcuí jña̱ cár cargo? ¿Cja güí hñe̱ ji̱tzi, cja̱ huá güí hñe̱ti hua jar jöy?― Nu cʉ möcja̱ cja̱ co cʉ tita cʉ mí mandado, bi ña̱tsjɛjʉ, bi ma̱jmʉ: ―Bbʉ gu ma̱jmʉ: “Guá hñe̱ ji̱tzi,” guegue‑nʉ́ xta xijquijʉ: “¿Dyoca̱ jí̱ xcú hñe̱me̱jʉ, bbʉ?” ");
INSERT INTO otsNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Cja̱ bbʉ gu ma̱jmʉ, bi dyøtitsjɛ cár cargo car Juan, dí tzu̱jʉ te da cjaguijʉ cʉ cja̱hni, como nucʉ́, göhtjo i i̱htzibijʉ car Juan. I ma̱jmʉ, guegue‑cá̱ múr profeta, xcuí mɛjni ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Diguebbʉ ya cʉ tita co cʉ möcja̱ bi da̱jtijʉ car Jesús, bi ma̱jmʉ: ―Jin dí pa̱dije jabʉ guá hñe̱h cár cargo car Juan.― Guejti car Jesús bi xijmʉ, bbʉ́: ―Hne̱quigö, jin gu xihquijʉ jabʉ xcuá hñe̱j nʉr cargo nʉ dí ja̱gö.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Cja̱ pé bi ma̱n car Jesús, bi xih cʉ cja̱hni‑cʉ́: ―Gui dyøjma̱jʉ nʉr bbede nʉ gu xihquijʉ, cja̱ gui ntzohmijʉ te i ne da ma̱. Mí bbʉh hnar hñøjø, mí hñi̱ yojo quí ttʉ. Bbɛto bi má bú ña̱hui ca hnáa, bi xifi: “Nuquɛ, ttʉ, gui ma bú pɛh pʉ jam huerta rá pa ya.” ");
INSERT INTO otsNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Cja̱ car ttʉ‑ca̱ bi da̱di: “Jin dí ne gu ma.” Pe diguebbʉ ya, bbʉ mí hna tzi rato, bi repenti cja̱ bi ma. ");
INSERT INTO otsNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Cja̱ cár ta pé bi ma bú nzoh ca pé hnár ttʉ, bi xifi ncjadipʉ. Nuca̱ bi da̱di, i̱na̱: “Ja̱a̱, tzi ta, nugö, xtá magö.” Pe nucá̱ jin gá má. ");
INSERT INTO otsNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nuya, gui ma̱nguɛjʉ ya, ¿ja̱ ndrá ngue cʉ yojo quí ttʉ car hñøjø bi dyøti ca mí ne cár ta?― Cja̱ bi da̱h cʉ möcja̱ co cʉ tita cʉ mí ja̱ ʉ́r cargojʉ pa di mandado, bi ma̱jmʉ: ―Gue car ttʉ ca bbɛto bi ttzofo.― Diguebbʉ ya car Jesús bi xijmʉ: ―Gui ntzohmijʉ te i ne da ma̱ nʉr bbede‑nʉ́ bbʉ, cja̱ gui dyødejʉ nʉ pé hnar palabra nʉ dí xihquijʉ. Cʉ jiöjte hñøjø cʉ i cobra cʉ contribución cja̱ co cʉ ma̱ñaso bbɛjña̱, ya xca cʉti jár dyɛ ca Ocja̱ pa da hñe̱me̱bi cár jmandado. Ya xta da̱hquijʉ cʉ cja̱hni‑cʉ́. Nuquiguɛjʉ, xcú ndo nxöjmʉ cár palabra ca Ocja̱, pe xcú cojmʉ xʉtja, como jin guí ne gui hñe̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bú e̱h car Juan ca mí xix yʉ cja̱hni. Már zö cár vida, cja̱ mí nzohquijʉ, mí xihquijʉ ja ncja güi hmʉpjʉ rá zö hne̱je̱. Pe nuquɛjʉ, jin gú hñe̱me̱jʉ ca mí ma̱. Cʉ jiöjte hñøjø cʉ i cobra cʉ contribución cja̱ cʉ ma̱ñaso bbɛjña̱, guegue‑cʉ́ bi hñe̱me̱. Nuquiguɛjʉ, masque gú cca̱htijʉ cʉ cja̱hni‑cʉ́, mír guatiju car Juan, nim pa gú repentijʉ pa güi hñe̱me̱jʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Cja̱ pé bi ma̱n car Jesús: ―Gui dyødejʉ nʉ pé hnar bbede gá ejemplo, hne̱je̱: Mí bbʉh hnar hñøjø, mí tjɛ jöy. Bi jojqui hnar huerta, bi hñi̱ti uva, bi goti co hnar cerca jáy nttza̱ni. Bi xi̱hmi hnar tanque pa di tjøti pʉ cʉ uva, di ddɛhmi. Guejtjo bi jiøh hnar ntorre pa di hmʉh pʉ car mɛfi ca di möh car huerta. Diguebbʉ ya, bi ma bú reglahui cʉ dda mɛfi pa di pɛjpi quí uva, cja̱ bbʉ ya xti dá̱‑cʉ, di döjʉ hna parte cʉ uva. Diguebbʉ ya car hñøjø ca múr mɛjti car huerta gá uva bi bøni, gá ma pé hnar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cja̱ bbʉ mí zøh car tiempo pa di ddʉjqui cʉ uva, car hñøjø bú pɛjni cʉ dda muzo pʉ jabʉ már pɛh cʉ mɛfi. Bú pɛjni cʉ muzo di ma di dyöh cʉ uva cʉ mí tocabi guegue cja̱ pé drí du̱htzibi. ");
INSERT INTO otsNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bbʉ mí zøti cʉ muzo pʉ jar huerta pa di dyöh cʉ uva, cʉ mɛfi cʉ már pɛh pʉ, bi pɛntijʉ cja̱ bi ndo ʉnijʉ. Bi mɛtijʉ ca hnáa, ca pé hnáa ya bi ndo jøjtijʉ me̱do, cja̱ ca pé hnáa ya bi möhtijʉ. Jin gá ne gá döjʉ cʉ uva. ");
INSERT INTO otsNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Car hñøjø ca múr mɛjti car huerta pé bú cu̱h cʉ dda mɛfi, cja̱ nucʉ́, más már ngu̱ ni ndra ngue cʉ bbɛto xcuí gu̱y. Nu cʉ mɛfi cʉ már bbʉ jar huerta pé bi cjajpitjo pʉ, ncja ngu̱ xquí cjajpi cʉ ddáa. ");
INSERT INTO otsNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tza gá nga̱x ya, car jmu̱ bú pɛjni cár ttʉ. Bi ma̱ntsjɛ: “Nuya, gu cu̱j ya nʉm ttʉ. ¿Cja jin da tte̱me̱bi‑nʉ́?” ");
INSERT INTO otsNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nu cʉ mɛfi cʉ már bbʉ jar huerta, bbʉ mí jiantijʉ cár ttʉ car jmu̱, ya xi mbá e̱je̱, bi ña̱tsjɛjʉ, bi hñi̱na̱jʉ: “Nunʉ́, guejnʉ́ da ttzoquibi nʉr huerta gá herencia. Gu mföxjʉ ya, gu pöhtijʉ, cja̱ gu cjajpi ʉm mɛjtijʉ nʉr huerta.” ");
INSERT INTO otsNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nubbʉ, bi pɛntijʉ cár ttʉ car jmu̱, bi fonguijʉ jar huerta, cja̱ bú pöhtijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Diguebbʉ ya, car Jesús bi dyön cʉ már øde bi hñi̱mbijʉ: ―Xi ya, bbʉ xtu e̱h car hñøjø ca múr mɛjti car huerta, ¿te da cjajpi yʉ xí möhtibi cár ttʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Cja̱ gueguejʉ bi da̱dijʉ: ―Jin da jui̱jqui cʉ mɛfi‑cʉ́, como már ndo nttzo. Tje da möhti. Nu car huerta gá uva, pé da yojpi da zoquibi pé dda mɛfi cʉ da dö cʉ uva bbʉ ya xta zøh car tiempo.― Ncjapʉ gá ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Diguebbʉ ya, car Jesús pé bi nzoh cʉ cja̱hni cʉ xquí dyøj nʉr bbede‑nʉ́. Bi xijmʉ: ―Gui mbe̱nijʉ ya te i ne da ma̱ nʉr palabra nʉ i ju̱x pʉ jar Escritura, i̱na̱: Car me̱do ca bi dyɛndi cʉ cja̱hni cʉ mí jøh car ngu̱, Guehcá̱ xí cjöx pʉ jár esquina car ngu̱, pʉ jabʉ i pɛnti cʉ cjoti. Guejtsjɛ ca Ocja̱ xí mandado xí cjöx pʉ. Nugöjʉ, bbʉ dí ccahtijʉ, i ndo dyo ʉm mʉyjʉ. Ncjapʉ ga ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Eso, dí xihquijʉ, ya jin da tjɛquijʉ guí cja̱hni israelitajʉ gui hmʉpjʉ jabʉ i mandado ca Ocja̱. Nu cʉ hnahño cja̱hni cʉ da dyøtijʉ ca i ma̱n ca Ocja̱, cja̱ da jionijʉ ja drí tzøpijʉ guegue, nucʉ́ da tjɛgui drí ñʉti pʉ jabʉ i mandado. ");
INSERT INTO otsNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Digue car ndo me̱do ca dí xihquijʉ, menta i bbʉjti hua jar jöy, bbʉ to da mfehtze, da tzox pʉ xøtze, da wajqui quí ndodyo. Pe bbʉ ya xtrú ccʉxa ña̱ car me̱do, bbʉ pé xtu ca̱y, ca to da zʉdi, exque da möhti.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nu cʉ möcja̱ cʉ mí mandado hne̱h cʉ dda cʉ fariseo, bbʉ mí dyødejʉ yʉ bbede yʉ bi ma̱n car Jesús, bi ba̱dijʉ, mír jɛquihui gueguejʉ cʉ mɛfi már nttzo cja̱ co cʉ jiøngu̱ cʉ bi zan car me̱do már zö. Nubbʉ́, gueguejʉ bi ndo ʉjʉ car Jesús, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Cja̱ bi ña̱jʉ, bi mbe̱nijʉ ja drí zʉdijʉ‑cá̱. Pe nde̱jma̱ mí tzu̱jʉ te di cjajpijʉ car Jesús, como már ngu̱ cʉ cja̱hni cʉ mí i̱htzibi. Mí ma̱jmʉ, múr jmandadero ca Ocja̱, mbá ja̱ cár palabra guegue‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Diguebbʉ ya, car Jesús pé bi u̱jti cʉ cja̱hni, bi nzofo gá bbede, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Pa gui pa̱dijʉ ja ncja ga mandado ca Ocja̱, i jñɛjmi hnar mbaxcjua gá ntja̱jti. Mí bbʉh ca hnar rey, ya xti ntja̱jti cár ttʉ. Bi dyøhtibi cár mbaxcjua. ");
INSERT INTO otsNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bbʉ mí tzi cjadi mpa pa di ncja car mbaxcjua, car rey bi gu̱h quí muzo di ma du nzoh cʉ cja̱hni cʉ xquí mvitabi di hñe̱h tzʉ jar ntja̱jti. Cja̱ guejtjo, bbʉ ya xquí zʉh car pá, pé bi gu̱h cʉ muzo. Bi ma‑cʉ́ bú nzoh cʉ cja̱hni cʉ xquí mvitabi pa di hñe̱h tzʉ ya. Nu cʉ bi ttzofo, jin guá ne guá hñe̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Car rey ya, pé bi yojpi bi gu̱ pé dda muzo, bi xijmʉ: “Gui xijmʉ cʉ cja̱hni cʉ xtú mvitabi: Ya xtú jojqui cam mbaxcjua. Cʉm nda̱ni co cʉm dɛjti cʉ xquí nojqui, ya xtú pöhti. Göhtjo ya xí tjojqui. Bú e̱jmʉ tzʉ ya, ya xta ncja car mbaxcjua. Bi ma cʉ muzo pé hnar vez, pé bú nzoh cʉ cja̱hni ncja ngu̱ gá mandado car rey. ");
INSERT INTO otsNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nu cʉ cja̱hni‑cʉ́, jin gá dyøhtibi ncaso. Gá möjmʉ pʉ jabʉ mír nejʉ. Ca hnáa ya bi ma jáy jua̱ji̱, cja̱ ca hnáa gá ma jár negocio. ");
INSERT INTO otsNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nu cʉ pé ddáa ya bi ndo zandijʉ cʉ muzo, jønca̱ bi pɛntijʉ cja̱ bi möhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Diguebbʉ ya car rey, bbʉ mí dyøde te xquí ncja, bi ndo zøti ʉ́r mʉy. Bi mɛjni quí sundado. Bi möjmʉ bú pöhtijʉ cʉ möhtite‑cʉ́, cja̱ bú tjʉhtibijʉ cár jñini pʉ jabʉ mí bbʉh cʉ cja̱hni‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nubbʉ́, car rey pé bi nzoh quí muzo, bi xijmʉ: “Ya xtú jojqui rá zö car mbaxcjua gá ntja̱jti. Nu cʉ cja̱hni cʉ dú nzofo, jí̱ mír ntzöhui di nu̱jʉ car mbaxcjua. ");
INSERT INTO otsNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eso, gui möjmʉ ya, pʉ jabʉ i mbonti cʉ da̱hñu̱, cja̱ göhtjo cʉ to xcuí ntjɛjʉ pʉ, gui mvitabijʉ du e̱jmʉ nʉr mbaxcjua gá ntja̱jti.” Ncjapʉ gá ma̱n car rey. ");
INSERT INTO otsNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Diguebbʉ ya, bi bøn cʉ mɛfi, gá hño já hñu̱, cja̱ bú jmu̱ntzi göhtjo cʉ to bú ntjɛhui, cʉ ttzocja̱hni co hne̱h cʉ jogui cja̱hni. Pé bú tziji jár ngu̱ car rey, bbʉ, cja̱ bi ñʉti göhtjo, hasta bi ndʉ pʉ jár ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Diguebbʉ ya, bi ñʉti car rey pʉ jabʉ már ncja car mbaxcjua, pa di cca̱hti cʉ cja̱hni cʉ már ju̱ pʉ ja mexa. Bi cca̱hti pʉ hnar hñøjø, jí̱ már je da̱jtu̱ gá mbaxcjua. Göhtjo cʉ pé ddáa, ya xquí tjejtibi da̱jtu̱ rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nubbʉ́, car rey bi nzoh car hñøjø‑ca̱ bbʉ, bi hñi̱mbi: “Nuquɛ, ñø, ¿ja ncja xquí cʉjquɛ hua, cja̱ jí̱ xcuá tjejtiqui da̱jtu̱ gá mbaxcjua?” Cja̱ guegue ya, bi jø gogu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Diguebbʉ ya car rey bi bbɛjpi quí muzo, bi hñi̱mbijʉ: “Gui tu̱htibijʉ yí dyɛ co yí hua nʉr cja̱hni, cja̱ gui tzixjʉ, grí dyɛnijʉ pʉ tji, drí ma jar bbɛxu̱y. Cʉ cja̱hni cʉ drí hmʉh pʉ, da nzonijʉ cja̱ da sufrijʉ rá ngu̱.” Guehcá̱ bi mandado car rey. ");
INSERT INTO otsNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nugö, dí xihquijʉ, car Tzi Ta ji̱tzi xí nzofo rá ndo ngu̱ yʉ cja̱hni, xí mvitabi da guati jár dyɛ pa da mandadobi. Pe jin gui ngu̱ yʉ cja̱hni yʉ i øjtibi cár jña̱. Nu yʉ xí juajni ca Ocja̱ pa da hmʉpjʉ guegue, guejyʉ́ i øjti ca i ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Diguebbʉ ya, bi möjmʉ cʉ fariseo, bú ña̱tsjɛjʉ. Bi mbe̱nijʉ ja drí jiötijʉ car Jesús pa di cjajpijʉ di ma̱ tema palabra ca jin di tzö. ");
INSERT INTO otsNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Cja̱ bú pɛjnijʉ cʉ dda cja̱hni cʉ mí ntzixihui gueguejʉ. Nucʉ́, mbá yojmʉ cʉ dda cja̱hni cʉ mí föxjʉ cár gobierno car Herodes. Cʉ hñøjø‑cʉ́, bi guatijʉ car Jesús, bi xijmʉ: ―Nuquɛ, Maestro, dí pa̱dije, guehquɛ guí ma̱n ca ncjua̱ni. Guí xij yʉ cja̱hni ja ncja drí hmʉpjʉ pa da tzøh ca Ocja̱. Parejo guí xijmʉ göhtjo. Jin to guí johti cja̱ jin to guí tzu̱, masque dur cja̱hni ca di bbʉh cár cargo o di tti̱htzibi. ");
INSERT INTO otsNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Xijquije tzʉ ya, ¿te guí ma̱nguɛ? ¿Cja rá zö ca dár cju̱tije car contribución ca i öh car gobierno romano, cja huá ji̱na̱?― Bi dyönijʉ nʉr nttöni‑nʉ́, como cʉ judio mí ndo ʉjʉ cʉ autoridad romano cʉ mí mandadobijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nu car Jesús bi ba̱tibi cár mfe̱ni cʉ cja̱hni‑cʉ́. Guegue‑cʉ́ mí ne di jiöti pa di ma̱n hnar palabra di ni̱gui, ncjahmʉ mí contrabi car gobierno. Eso, bi da̱h car Jesús, bi xijmʉ: ―Guí jiöjtejʉ, ¿dyoca̱ guí øjtiguijʉ trampa? ");
INSERT INTO otsNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","u̱jtiguijʉ ya hnar domi digue cʉ dár cju̱tijʉ cʉ contribución.― Cja̱ bú tja̱ hnar domi gá denario, bi ttu̱jti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Diguebbʉ ya, car Jesús bi dyöni: ―¿To ʉ́r retrato‑ná̱ cja̱ to ʉ́r tju̱ju̱ na̱ i cuati na̱r domi?― ");
INSERT INTO otsNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Cja̱ bi hñi̱mbijʉ: ―Gue yí mɛjti car emperador romano.― Diguebbʉ ya, car Jesús pé bi xijmʉ: ―Guehcá̱. Nubbʉ́, gui u̱nijʉ car emperador romano ca bí tocabi, cja̱ guejti ca Ocja̱, gui unijʉ ca bí tocabi hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cʉ cja̱hni‑cʉ́, bbʉ mí dyødejʉ nʉr palabra‑nʉ́, bi ndo hño í mʉyjʉ, bbʉ́. Cja̱ bi wembijʉ car Jesús, bi möjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Exque gue car pa‑cá̱, bú e̱h cʉ dda cja̱hni cʉ mí tsjifi saduceo, bi guatijʉ car Jesús. Cʉ saduceo i ma̱jmʉ, jin da jña̱ ʉ́r jña̱ cʉ ánima. Tzʉdi, i ma̱jmʉ, bbʉ ya xí ndu̱ hnar cja̱hni, xí nttzɛdi pʉ cár vida. Gueguejʉ bi xijmʉ car Jesús hnar bbede pa di dyøhtibijʉ hnar prueba. Bi ma̱jmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Nuquiguɛ, Maestro, bi ma̱n car Moisés pʉ jar ley, bbʉ xí ndu̱ hnar hñøjø, xí nzoh cár bbɛjña̱, pe jin te xí hmʉ í ba̱jtzi, cár cjua̱da̱ car ánima da hmʉbi cár bbɛjpo pa da hmʉ í ba̱jtzi, cja̱ cʉ ba̱jtzi cʉ da hmʉy, da dɛn cár tju̱ju̱ car ánima, pa jin da mpun cár familia. ");
INSERT INTO otsNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nde, bbʉ. Pʉ jabʉ ndí bbʉpje, ndí meyaje yojto hñøjø cʉ mí ncjua̱da̱jʉ. Car da̱cjua̱da̱ bi ntja̱jti, cja̱ diguebbʉ ya bi du̱, jin tema ba̱jtzi mí hñi̱ji̱. Bi goh cár bbɛjña̱, cja̱ nucá̱ pé bi hmʉbi cár mo, gue car cjua̱da̱ ca mír cja yojo. ");
INSERT INTO otsNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Guejti ca xtrá yoncjua̱da̱ pé bi du̱tjo. Jin te pé gá hñi̱hpi ba̱jtzi car bbɛjña̱‑cá̱. Pé bi gojti guegue‑cá̱. Ca xtrá jñu̱ncjua̱da̱ ya hne̱je̱, pé bi ncjadipʉ, cja̱ co cʉ pé dda cjua̱da̱, hna‑hnáa, hasta bi tjeh cʉ yojto hñøjø. Göhtjo‑cʉ́, xquí hmʉbi hnaadi car bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Cja̱ bbʉ ya xquí du̱ göhtjo‑cʉ́, bi du̱ car bbɛjña̱, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Xijquije tzʉ ya, bbʉ xta jña̱ ʉ́r jña̱ cʉ ánima, digue cʉ yojto cjua̱da̱, ¿ja̱ ndrá nguehca̱ mero dúr da̱me car bbɛjña̱‑cá̱, porque göhtjo xquí hmʉbi?― ");
INSERT INTO otsNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nu car Jesús bi da̱di, bi hñi̱mbijʉ: ―Jin gui tzö quer mfe̱nijʉ, porque jin guí ntiendejʉ te i ma̱n cʉ Escritura, cja̱ jin guí e̱me̱jʉ, ¿cja rá nzɛh ca Ocja̱ pa da ungui ʉ́r nzajqui cʉ cja̱hni cʉ xí ndu̱? ");
INSERT INTO otsNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Guí ndo nquivocajʉ. Porque bbʉ xta jña̱ ʉ́r jña̱ cʉ ánima, ya jin da hmʉbi hñøjø co bbɛjña̱. Ya jin da ntja̱jti yʉ cja̱hni. Nubbʉ́, da hmʉj yʉ cja̱hni ncja ngu̱ ga hmʉh cʉ ángele cʉ bí bbʉ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pe nuquɛjʉ, bbʉ guí ne gui pa̱dijʉ, ¿cja cierto da nantzi cʉ ánima? gui mbe̱nijʉ nʉr palabra nʉ xí ma̱n ca Ocja̱ pʉ jar Escritura, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nugö, dú Ocja̱‑gö, mí nzojqui ca ndor Abraham, guejti ca ndor Isaac, cja̱ co ca ndor Jacob. ʉ́r Cja̱a̱‑gui guegue‑cʉ́.” Ncjapʉ gá ma̱n car Tzi Ta ji̱tzi. Guegue‑cá̱ jí̱ ʉ́r Cja̱a̱ cʉ cja̱hni cʉ xí mpu̱ni. ʉ́r Cja̱a̱ cʉ cja̱hni cʉ i bbʉjtjo. Tzʉdi, cʉ cja̱hni cʉ mí e̱me̱ ca Ocja̱ bbʉ mí bbʉjtijʉ hua jar jöy, cja̱ pé xí ndu̱, i bbʉjti‑cʉ́. Jin gá mpun‑cʉ́ bbʉ mí ndu̱. Tiene que da nantzijʉ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cʉ cja̱hni, bbʉ mí dyøj nʉr palabra‑nʉ́, bi ndo hño í mʉyjʉ, porque már ji̱tzi cár mfe̱ni car Jesús, cja̱ már nzɛdi cʉ palabra cʉ mí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Diguebbʉ ya, cʉ fariseo, bi dyødejʉ te mí jma̱ digue car Jesús. øde, guegue‑cá̱ xquí da̱pi cʉ saduceo bbʉ mí ttøhtibi hnar prueba. Nubbʉ́, bi mpɛjnijʉ cʉ saduceo co cʉ fariseo, göhtjo bi guatijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mbá yojmʉ ca hnar fariseo ca mí ndo tti̱htzibi, porque mí ntiende rá zö te i ne da ma̱n car ley ca bi dyøti car Moisés. Guejti car maestro‑cá̱ mí ne di dyøhtibi hnar prueba car Jesús eso, bi dyöni: ");
INSERT INTO otsNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Nuquiguɛ, Maestro, digue cʉ ddɛtta mandamiento cʉ bi zoguijʉ ca ndor Moisés, ¿ja̱ ndrá nguehca̱ más i nesta gu øjtijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Cja̱ car Jesús bi da̱di: ―Gue car mandamiento ca i ma̱: “Gui jion ca Ocja̱ quer Tzi Jmu̱ göhtjo mbo ir mʉy, cja̱ gui ne‑cá̱, cja̱ gui hñe̱me̱, hne̱je̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gue nʉr mandamiento‑nʉ́ más rá nzɛdi. Guejnʉ́ gui fʉdi gui dyøjtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Cja̱ car mandamiento ca rí cja yojo, i jñɛjmi nʉr primero. I ma̱n car mandamiento‑cá̱: “Gui ma̱h quer hñohui ncja ngu̱ gri ma̱jtsjɛ.” ");
INSERT INTO otsNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dí xihqui, bbʉ gui dyøjti ca i ma̱n yʉ yojo mandamiento‑yʉ́, i pøni ncjahmʉ xcrú dyøjti göhtjo ca i ma̱n car ley ca bi zoguijʉ car Moisés, cja̱ co göhtjo ca i ma̱m pʉ ja libro cʉ bi dyøti cʉ profeta.― Ncjapʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Már bbʉjti pʉ cʉ fariseo, cja̱ car Jesús guejtjo bi dyöni nʉr nttöni‑nʉ́: ");
INSERT INTO otsNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Te guí ma̱nguɛjʉ digue ca hnar hñøjø ca da hñi̱x ca Ocja̱ pa da mandadoguijʉ, dí cja̱hni israelitajʉ? ¿Tema familia drí hñe̱h‑cá̱?― Cja̱ gueguejʉ bi da̱dijʉ: ―Da hmʉy digue cár cji ca ndor David. Dúr mboxibbɛjto guegue‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Cja̱ pé bi dyön car Jesús, bbʉ: ―Bbʉ da cja guegue ʉ́r mboxibbɛjto car Davíd, ¿ja ncja drí cja ʉ́r jmu̱‑ca̱ bbʉ́? Como guejtsjɛ car David i xifi ʉ́r jmu̱ pʉ jar Escritura. Gue cár Tzi Espíritu ca Ocja̱ bi möx car David bbʉ mí jñu̱x na̱r palabra‑ná̱ pʉ jar Escritura, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Car Tzi Ta ji̱tzi bi xih cam Tzi Jmu̱gö, bi hñi̱mbi: “Gui mi̱jcua jam jogui dyɛ, gu mföxihui gu mandadohui, Hasta gue bbʉ xtá cjajpigö quir contra du e̱je̱, Da nda̱ndiña̱jmu̱ jer tzi huá, cja̱ nuquiguɛ, xquí mandadobi‑cʉ́.” ");
INSERT INTO otsNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bbʉ mí ma̱ ncjapʉ car David, mí xifi ʉ́r tzi Jmu̱ car Cristo ca di hñe̱je̱. Xi ya bbʉ, ¿ja di ncja dúr jmu̱ guegue car Cristo cja̱ guejtjo dúr mboxibbɛjto?― Ncjapʉ gá dyön car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nu cʉ fariseo, bbʉ mí dyøj nʉr palabra‑nʉ́, jin gá mba̱di te drí da̱dijʉ. Bi gohti í nejʉ, bbʉ. Cja̱ desde car pa‑cá̱, göhtjo bi mɛhtzi ʉ́r tzöjʉ. Ya jin to pé gá dyøhtibi prueba car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Diguebbʉ ya car Jesús bi nzoh cʉ cja̱hni rá ngu̱ cʉ xquí jmuntzi, co hne̱h quí möxte, bi xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Cʉ maestro cʉ i u̱jtiquijʉ car ley, xí ngojmʉ jár lugar ca ndor Moisés, porque i xihquijʉ te i ma̱n cʉ Escritura. ");
INSERT INTO otsNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gui dyødejʉ ca i xihquijʉ, cja̱ gui dyøjtijʉ, pe jin gui ma gui hmʉpjʉ ncja ngu̱ ga hmʉ gueguejʉ. Como hnahño ga ma̱jmʉ, hnahño ga dyøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gueguejʉ i bbɛjpiquijʉ rá ngu̱ jmandado pa gui tɛnijʉ, ncjahmʉ xtrú hñe̱h ca Ocja̱ cʉ jmandado‑cʉ́, cuando ji̱na̱. Jin to di jiöti di dyøte göhtjo‑cʉ́. Cʉ maestro‑cʉ́, jin gui jui̱jqui yʉ cja̱hni cja̱ jin gui fötzi. ");
INSERT INTO otsNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Göhtjo ca i øte, jøntsjɛtjo pa da tti̱htzibijʉ, da ma̱n yʉ pé dda cja̱hni, guegue‑cʉ́ i ndo jonijʉ ca Ocja̱. I cuajtijʉ testo rá ma pʉ jáy de̱jʉ co jáy ntchohta‑dyɛjʉ. Guejtjo i jejʉ da̱jtu̱ cʉ rá ma quí fleco. ");
INSERT INTO otsNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bbʉ i pa pʉ jabʉ to xí mvitabi da zi, i ne da mi̱h pʉ jabʉ da tti̱htzibi cja̱ da jnu̱ rá zö. Cja̱ bbʉ i pa jar templo, i ne da mi̱pjʉ pʉ delante, pʉ jabʉ da ncca̱hti. ");
INSERT INTO otsNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bbʉ i pa jar töy, i ne da ttzɛngua rá zö, da ttzofo gá maestro, pa da tti̱htzibijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nuquiguɛjʉ, dyo guí jonijʉ ja drí tti̱zquijʉ pa da ttzohquijʉ gá maestro, como guí göhtjojʉ, guí hñohuitjojʉ. Cja̱ nuguigö, jønguitsjɛgö xí hñi̱xquigö car Tzi Ta ji̱tzi pa gui tɛnguijʉ gá maestro. ");
INSERT INTO otsNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jin gui ma gui xijmʉ ir tajʉ hnar cja̱hnitjo hua jar jöy, porque jøntsjɛ hnaatjo quer tajʉ guí hñi̱jmʉ, gue ca hnaa ca bí bbʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Guejtjo jin gui jiɛguijʉ cʉ cja̱hni da nzohquijʉ gá jmu̱, porque jønguitsjɛgö xí hñi̱xquigö ca Ocja̱ ir Jmu̱guijʉ, guejquigö xpá mɛnqui guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nuquiguɛjʉ, ca to más rí ntzöhui da tti̱htzibi gue ca to más da pɛjpi yʉ pé ddaa. ");
INSERT INTO otsNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porque car cja̱hni ca i ma̱ntsjɛ, rí ntzöhui da tti̱htzibi, guegue‑cá̱ da go jöy. Nu car cja̱hni ca jin gui hñi̱xtsjɛ, pe i cja jmandado, guehcá̱ da tti̱htzibi‑cá̱.― Ncjapʉ gá xih quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Diguebbʉ ya bi mʉdi bi nzoh cʉ fariseo, cja̱ co cʉ pé dda maestro cʉ mí u̱jti cʉ cja̱hni car ley. Bi ma̱: ―Nuquɛjʉ, guí maestrojʉ guí u̱jtijʉ yʉ cja̱hni car ley, cja̱ hne̱hquiguɛjʉ, guí fariseojʉ, guí jiöjtejʉ. Gui ma gui sufrijʉ rá ngu̱, como drá ndo ngu̱ quer castigojʉ. Guí ccaxjʉ cʉ cja̱hni cʉ i ne da guatijʉ pʉ jár dyɛ ca Ocja̱ pa da nu̱jʉ cár jmandado. Nuquiguɛjʉ, jin guí ne gui cuatijʉ pʉ. Guejtjo jin guí ne gui jiɛjmʉ cʉ pé dda cja̱hni cʉ ya xqui ne da guati pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Cja̱ pé dí xihquijʉ, guí maestrojʉ guí u̱jtijʉ yʉ cja̱hni car ley, cja̱ hne̱hquiguɛjʉ, guí fariseojʉ, gui ma gui sufrijʉ rá ngu̱, como drá ndo ngu̱ quer castigojʉ. Nuquɛjʉ guí jiöjtejʉ. Porque guí recogebijʉ quí ngu̱ cʉ ddanchu̱ cʉ jin te i ja̱, cja̱ pa jin da fa̱di, cja guehquɛjʉ xcú fonguijʉ pʉ, guí ndo dejʉ grí nzojmʉ ca Ocja̱. Guí jiöjtejʉ, da ndo jñu̱x quer castigojʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Guí maestrojʉ, guí u̱jtijʉ yʉ cja̱hni car ley, cja̱ hne̱hquiguɛjʉ, guí fariseojʉ, guí jiöjtejʉ, gui ma gui sufrijʉ rá ngu̱, como drá ndo ngu quer castigojʉ. Porque guí ndo ungui ir mʉyjʉ gui jionijʉ cja̱hni pa gui jiötijʉ da ñʉti quer religiónjʉ. Cja̱ bbʉ ya xtrú ñʉti‑cʉ́, gui xöjpijʉ da cjajʉ más drá ndo nttzo ni ndra nguehquɛjʉ. Nuquɛjʉ, grí möjmʉ pʉ jabʉ jin gui tzö, cja̱ guejti cʉ to xcú jiötijʉ, da ma pʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nuquɛjʉ, da ttahquijʉ quer castigojʉ drá ndo ngu̱. Guí jñɛjmʉ godö, cja̱ guí ne gui cjʉtijʉ cʉ pé dda cja̱hni pa da dɛnquijʉ. Jin te i ntjumʉy ca guí u̱jtijʉ yʉ cja̱hni, porque guí ma̱jmʉ: “Bbʉ da jura hnar cja̱hni, da hñi̱h car templo gá testigo, jin gui nesta da zøjte ca xí ma̱.” I pøni ncjahmʉ guí ma̱jmʉ jin te di ntjumʉy car templo. Cja̱ pé guí ma̱jmʉ, bbʉ to da hñi̱h car oro pʉ jar templo gá testigo, guegue‑cá̱ i nesta da zøjte ca xí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Nttzɛditjo guí dondojʉ! ¿Ja̱ ndrá nguehca̱ más rá nttzu̱ni? ¿Cja gue car oro? ¿Cja jin gui gue car templo pʉ jabʉ ra cuati car oro? ");
INSERT INTO otsNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Guejtjo guí ma̱jmʉ, bbʉ da jura hnar cja̱hni, da hñi̱h car altar gá testigo, jin gui nesta da zøjte cár palabra. Pe bbʉ to da jura por rá ngue car ofrenda ca i cjöx pʉ xøtze car altar, guegue‑ca̱ i nesta da zøjte ca xí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Guí dondojʉ! ¿Ja̱ ndrá nguehca̱ más i mu̱hui? ¿Cja gue car ofrenda? Ji̱na̱. Gue car altar pʉ jabʉ i cjöx ca te i jña̱htibi ca Ocja̱, como guehcá̱ i cjajpi ʉ́r mɛjti ca Ocja̱ ca te i cjöx pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dí xihquijʉ, bbʉ to da jura, da hñi̱h car altar gá testigo, i tzʉdi, xí hñi̱h car altar cja̱ co göhtjo ca i cjöx pʉ xøtze. ");
INSERT INTO otsNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Guejti car templo, bbʉ to da hñi̱ji̱ gá testigo, i pøni ncjahmʉ xí hñi̱h ca Ocja̱, como ʉ́r mɛjti‑cá̱ car templo. ");
INSERT INTO otsNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Guejti car cja̱hni ca i i̱h car ji̱tzi bbʉ ga jura, gue cár nttzöya ca Ocja̱ i i̱ji̱, cja̱ co guejtsjɛ ca Ocja̱ hne̱je̱, como guegue‑cá̱ bí ju̱h pʉ jar ji̱tzi, bí mandado. ");
INSERT INTO otsNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nuguɛjʉ, guí maestrojʉ, guí u̱jtijʉ yʉ cja̱hni car ley, cja̱ hne̱hquiguɛjʉ guí fariseojʉ, guí jiöjtejʉ, gui ma gui sufrijʉ rá ngu̱, como drá ndo ngu̱ quer castigo ca da ttahquijʉ. Guí döjʉ gá diezmo cʉ tzi paxitjo cʉ jin tza te i mu̱hui, ncja ngu̱ car xa̱ccani, co car anís, hne̱h car comino. Nu ca i xijquijʉ ca Ocja̱ pʉ jar ley pa gu øtijʉ, jin guí øtijʉ‑cá̱. Jin guí øtijʉ jujticia, cja̱ jin guí jui̱jqui quir mi̱nga̱‑cja̱hnijʉ. Guejtjo jin guí cumpli ca xcú ma̱jmʉ. Guehcʉ́ i ndo mu̱hui rá ngu̱, cja̱ guehcʉ́ i tzøh ca Ocja̱. Bbʉ ya xcrú dyøtijʉ‑cʉ́, guejtjo bí jogui pa gui döjʉ car diezmo, hasta cʉ tzi paxitjo hne̱je̱, bbʉ guí nejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nuquɛjʉ, ncjahmʉ guí godöjʉ, cja̱ pé guí jötijʉ cʉ pé dda cja̱hni pa da dyøte ncja ngu̱ gri dyøtijʉ. Guí øtijʉ cosa rá ndo nttzo cʉ i ccax ca Ocja̱, cja̱ pé guí ungui ir mʉyjʉ grí tɛnijʉ cʉ dda costumbre cʉ xí mbentsjɛ yʉ cja̱hni, como guí i̱na̱jʉ, co guehcʉ́ gui tzøpijʉ ca Ocja̱. Nu cʉ costumbre‑cʉ́, jin te i ntju̱mʉy. ");
INSERT INTO otsNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Cja̱ pé dí xihquijʉ, guí maestrojʉ, guí u̱jtijʉ yʉ cja̱hni car ley, co hne̱hquiguɛjʉ, guí fariseojʉ, gui ma gui sufrijʉ rá ngu̱, como guí jiöjtejʉ, cja̱ da ttahqui quer castigojʉ drá ngu̱. Guí ndo tzijʉ rá zö göhtjo ʉr pa. Guí pe̱jpi cár domi quer hñohuijʉ, o guí ja̱mbijʉ gá fuerza, pa más gui ndo tzijʉ rá zö. Hmɛditjo guí ndo cjádi mʉyjʉ ja grí xʉti quir trastejʉ pa jin te di tu̱ ca drá nttzo. Guí i̱na̱jʉ co guehcá̱ da nu̱quijʉ rá zö ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yʉ to i tɛn quí costumbre yʉ fariseo, i jñɛjmʉ godö. Nugö, dí xihquijʉ, bbɛto gui jojqui ir mʉyjʉ, cja̱ nubbʉ, da jogui rá zö göhtjo quir vidajʉ, ncja ngu̱ ga tzøh ca Ocja̱. Nubbʉ́, xquí jñɛjmʉ hnar vaso o hnar moji ca xtrú tsjʉti rá zö. Jin te di tu̱ xøtze, cja̱ co guejti pʉ mbo. ");
INSERT INTO otsNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Dí nzohquijʉ, guí maestrojʉ guí u̱jtijʉ yʉ cja̱hni car ley, cja̱ co hne̱hquiguɛjʉ, guí fariseojʉ. Guí jiöjtejʉ, gui ma gui sufrijʉ rá ngu̱, como drá ndo ngu̱ quer castigojʉ. Nuquɛjʉ, guí jñɛjmʉ cʉ ngu̱ pʉ jabʉ i cjöti ánima. Nucʉ́, xí ttaxqui rá tzi zö pʉ xøtze. Pe pʉ mbo ya, nxøgue ndodyo xí dya, rá ndo nxa̱, cja̱ rá ndo nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Guí ncjajʉ pʉ hne̱je̱. Rá zö ga ni̱gui quir vidajʉ pʉ xøtze, pe pʉ mbo ir mʉyjʉ, rá nttzoquijʉ, guí jiöjtejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Cja̱ pé dí xihquijʉ, guí jiöjtejʉ, guí maestrojʉ guí u̱jtijʉ yʉ cja̱hni car ley, co hne̱hquiguɛjʉ, guí fariseojʉ, gui ma gui sufrijʉ rá ngu̱, como drá ngu̱ quer castigojʉ. Guehquɛjʉ guí jojquibijʉ cʉ tzi ni̱cja̱ pʉ jabʉ gá cjöti quí ndodyo cʉ profeta cʉ bi du̱, ya má yabbʉ. Guejtjo guí tja̱xjʉ døni quí tzi ni̱cja̱ cʉ pé dda cja̱hni cʉ guejtjo mí pɛjpijʉ ca Ocja̱ cʉ cjeya xí tjogui. ");
INSERT INTO otsNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Cja̱ guí ma̱jmʉ: “Bbʉ ya xcri bbʉjcöjʉ cʉ pá bbʉ mí bböhti quí jmandadero ca Ocja̱ cʉ xí nttöjcua, nugöjʉ gua ccaxjʉ cʉ ndom titajʉ, pa jin di möhti‑cʉ́.” ");
INSERT INTO otsNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ca guír ma̱jmʉ ncjapʉ, guí ncjua̱nijʉ, í ttʉquiguɛjʉ cʉ ttzocja̱hni cʉ bi möhti cʉ profeta cʉ cjeya cʉ xí tjogui, cja̱ quir mfe̱nijʉ i jñɛjmi quí mfe̱ni gueguejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mí ʉjʉ quí jmandadero car Tzi Ta ji̱tzi qui ndo ir titajʉ, cja̱ nuquɛjʉ, pé guí ncjajʉ pʉ. Bbʉ di hmʉjcua rá pa ya cʉ cja̱hni‑cʉ́, guejtjo di ʉguigö‑cʉ́ como ngu̱ gri ʉguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Guí göhtjojʉ, guí jñɛjmʉ ncja nʉr cci̱ña̱, nuquɛjʉ, cja̱ co qui ndo ir titajʉ. Grí ntzöjʉ da cju̱hquijʉ pʉ jar tzibi ca jin gui jui̱ti. ¿Ja ncja grí huetijʉ car castigo‑cá̱? ");
INSERT INTO otsNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nuquɛjʉ, rá ndo nttzo ca guí øtijʉ, eso, dí pɛjnigö cʉm jmandadero pa da nzohquijʉ. Cjaatjo xtá pɛnquijʉ cʉm mɛfi pa da xihquijʉ ja i ncja cam mfe̱nigö, cja̱ co cʉ ddáa cʉ i ndo pɛhtzi jogui mfe̱ni, cja̱ co pé ddáa cʉ da xihquijʉ te i ne da ma̱n cam palabragö. Nuquiguɛjʉ, xquí pöhtijʉ cʉ ddam jmandadero, cja̱ cʉ pé ddáa ya, xquí pɛntijʉ, xquí tøtijʉ já ponti, cja̱ cʉ pé ddáa ya, xquí tzixjʉ pʉ jer templojʉ cja̱ xquí jiʉtijʉ pʉ. Cʉ pé ddáa ya, xquí tøjna̱ddijʉ, drí ma pé dda jñi̱ni. Cjaatjo xcrí tɛnijʉ, xquí cjajpijʉ pé drí ddatzi pé dda lugar. ");
INSERT INTO otsNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nuquɛjʉ, ya xta zʉh car pa bbʉ xta ncozquijʉ ca xcú dyøtijʉ. Xta ttahquijʉ car castigo ca rí ntzöhui da ttun yʉ to xí möhti göhtjo cʉ jogui cja̱hni cʉ xí bböhti desde bbʉ mí mʉj nʉr mundo hasta rá pa ya. Jár mʉdi bi bböhti car Abel, masque jin te mí tu̱. Cja̱ bbʉ mí tjoh cʉ cjeya, pé bi bböhti pé dda cja̱hni rá ngu̱, cʉ jin te mí tu̱jʉ, hne̱je̱. Gá nga̱x ya, bi bböhti car möcja̱ Zacarías, cár ttʉ car Berequías. Qui ndo ir titajʉ bi möhtijʉ‑cá̱, bbʉ már bbʉh pʉ jár patio car templo, már bböh pʉ hnanguadi car altar. ");
INSERT INTO otsNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cierto dí xihquijʉ, guehquiguɛjʉ, como ngu̱ gri hmʉpjʉ yʉ pa ya yʉ xtú e̱cö, xta zʉhquijʉ car castigo ca mír ntzöhui cʉ to bi möhti cʉ cja̱hni cʉ jin te mí tu̱, göhtjo cʉ bi bböhti desde bbʉ mí mʉj nʉr mundo. Ya jin da jui̱quiquijʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nuquɛjʉ, guí mi̱ngu̱jʉ Jerusalén, ¿dyoca̱ segue guí pöhtijʉ cʉ jmandadero cʉ ba e̱jmʉ? ¿Dyoca̱ guí ccajnijʉ me̱do quí jmandadero ca Ocja̱? Guegue cjaatjo ba pɛnquijʉ‑cʉ́ pa drí nzohquijʉ. Te tza ngu̱ vez ndí ne gua cuajtiquijʉ ncja hnar tzu̱huade i cuajti quí tzi ba̱jtzi, i juitzi co quí jua. Cja̱ nuquɛjʉ, jin gú ne güi hñe̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ya xta jiɛquijʉ car Tzi Ta ji̱tzi pa da da̱hquijʉ quir contrajʉ. Nubbʉ, tje da tjøhti nir templojʉ, ya jin to da hña̱m pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nuya dí xihquijʉ, desde rá pa yá, ya jin gui ma gui cca̱jtiguijʉ hasta gue bbʉ xtí pønijʉ, gui má tja̱jquijʉ, cja̱ xtí ma̱jmʉ: “Car Tzi Ta ji̱tzi da bendeci nʉr hñøjø nʉ xpá mɛjni pa da mandadoguijʉ.”― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ya xquí bøm pʉ jar templo car Jesús, cja̱ ya xi mír ma. Nubbʉ́, bi guatijʉ quí möxte, bi u̱jtijʉ cʉ edificio, bi mʉdi bi ña̱jʉ digue te tza már zö mír ni̱gui‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cja̱ car Jesús bi xijmʉ: ―¿Cja guí cca̱htijʉ nʉr templo, co göhtjo yʉ ndo edificio rá tzi zö? Cierto, dí xihquijʉ, jin da gojcua hnar me̱do ca di mfi̱xihui pé hnáa. Göhtjo da tjøhti‑yʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Diguebbʉ ya, car Jesús bi mi̱h pʉ jar ttøø ca mí tsjifi Cerro de Olivos. Jí̱ már yojmi cja̱hni rá ngu̱ car hora‑cá̱. Nu quí möxte bi guati, mí ne di ña̱tsjɛjʉ. Bi dyönijʉ: ―Xijquije tzʉ, ¿ncjahmʉ da ncja cʉ xcú ma̱? ¿Ja i ncja gu pa̱dije bbʉ ya xqui guejti pʉ gu e̱je̱ cja̱ ya xta tjej nʉr mundo?― ");
INSERT INTO otsNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Cja̱ car Jesús bi da̱di, bi xijmʉ: ―Gui mfödijʉ, jña̱jʉ ʉr huɛnda pa jin to da jiöhquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porque xtu e̱ rá ngu̱ cja̱hni, xta hño, xta nøn cam tju̱ju̱gö, xta ma̱jmʉ: “Guejquigö dúr Cristo‑gö, xpá mɛnqui ca Ocja̱.” Cja̱ rá ngu̱ cja̱hni da hñe̱me̱‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nuquɛjʉ, bbʉ xtí dyødejʉ, ya xqui ncja guerra, o bbʉ i jma̱, pé xta mʉdi xta ncja guerra, jin gui ma gui ntzu̱jʉ, como tiene que da ncja cʉ cosa‑cʉ́. Pe bbʉ xta ncja‑cʉ́, todavía di tzi bbɛjtjo pa drí tjej nʉr mundo. ");
INSERT INTO otsNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Porque cʉ cja̱hni cʉ i bbʉh hnar jöy da ntu̱jnihui cʉ mi̱ngu̱ pé hnar jöy. Hnar gobierno da ncontrahui pé hnar gobierno. Guejtjo da hño jnini rá nttzo, cja̱ da ndo ncja tju̱ju̱, cja̱ da hño hña̱mijöy rá ngu̱ lugar. ");
INSERT INTO otsNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bbʉ xta ncja yʉ cosa‑yʉ́, ya xpa e̱h car tiempo bbʉ xta guaj nʉr mundo. Da sufri yʉ cja̱hni bbʉ xta ncja‑yʉ́, pe más da ndo sufritjo bbʉ pé xta ncja cʉ pé dda cosa cʉ ba bbɛfa. ");
INSERT INTO otsNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Cʉ pa cʉ ba bbɛfa, da ndöquijʉ pa da ttʉnquijʉ, cja̱ da bböjtiquijʉ. Nuquiguɛjʉ, como ngu̱ guir tɛnguijʉ, cʉ cja̱hni, cʉ mi̱ngu̱ rá ngu̱ jöy, da ʉquijʉ por rá nguejquigö. ");
INSERT INTO otsNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bbʉ xtu e̱h cʉ pa‑cʉ́, da wembigui rá ngu̱ cʉ cja̱hni cʉ mí tɛngui má̱hmɛto. Ya jin da hñe̱me̱gui. Mismo cʉ cja̱hni cʉ mí tɛnguijma̱ja̱, xta jiɛguigö, bbʉ́. Jønca̱ da contrahui cʉ pé ddáa cʉ i tɛnguitjo, da dödi quí hñohui cʉ mí yojma̱hui pa da ttʉni cja̱ da bböhti. ");
INSERT INTO otsNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Cʉ pa‑cʉ́, da hño rá ngu̱ jiöjte, da xih cʉ cja̱hni: “Nugö, xpá mɛnquigö ca Ocja̱.” Cja̱ rá ngu̱ cʉ cja̱hni da hñe̱me̱ cʉ jiöjte‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cʉ pa‑cʉ́, da ngu̱jqui cʉ cja̱hni cʉ i øti ca rá nttzo, cja̱ da me̱no cʉ da segue da dɛnguigö. Cja̱ bbʉ ya xtrú ngu̱jqui cʉ cja̱hni cʉ da dyøti ca rá nttzo, nubbʉ, ya xti te tzi ngu̱di cʉ da negui cja̱ da ma̱h quí mi̱nga̱‑hermanojʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nu ca to da segue da dɛngui göhtjo ʉ́r vida, da mɛhtzi car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nʉr tzi ddadyo jña̱ nʉ i ma̱ ja ncja ga mandado ca Ocja̱ i nesta da tsjij yʉ cja̱hni, göhtjo yʉ i bbʉjcua nʉr mundo. Cja̱ diguebbʉ ya, da guaj nʉr mundo. ");
INSERT INTO otsNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nuquɛjʉ, ya xcú cca̱htijʉ jar Escritura te bi ma̱n car profeta Daniel. Ca to da cca̱hti car palabra‑cá̱, da mbe̱ni ja ncja drí ncumpli ca bi ma̱n car Daniel. I ju̱x pʉ jar libro ca bi dyøti‑cá̱, øde, bbʉ ya xti guejti pʉ da guaj nʉr mundo, xta ni̱gui ca hnar hñøjø ca da mandado. Nuca̱, jin da zu̱ ca Ocja̱, cja̱ jin da zu̱jpi nʉ́r templo. Da ñʉti pʉ jabʉ jin gui tjɛj yʉ cja̱hni, da hmöh pʉ mbo, cja̱ da dyøti ca jí̱ rí ntzöhui. Nuquɛjʉ, bbʉ xquí cca̱htijʉ car hmɛtzö‑cá̱, xtí pa̱dijʉ, bbʉ, ya xní zʉh car tiempo. ");
INSERT INTO otsNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bbʉ xta ncja‑cá̱, xquí pa̱dijʉ, bbʉ, ya xta mʉh car sufrimiento rá ndo ngu̱. Nubbʉ́, cʉ cja̱hni cʉ di bbʉjcua jar jöy Judea, da ddaguijʉ, drí möjmʉ já ttøø. ");
INSERT INTO otsNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Guejti car cja̱hni ca di bbʉh pʉ jár sotea cár ngu̱, da ga̱ nttzɛdi, pe jin da ñʉti pʉ́r ngu̱ pa da gʉjqui cʉ cosa cʉ ra bbʉh pʉ. Da wenga nttzɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Cja̱ nu bbʉ to di dyo jar jua̱ji̱, guejti‑cá̱ da ddagui hne̱. Jin du coh pʉ́r ngu̱ pa da ga̱x cár manga. ");
INSERT INTO otsNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bbʉ xta zøh cʉ pa‑cʉ́, da ndo sufri cʉ bbɛjña̱ cʉ di hñʉ, cja̱ co ni cʉ di tjɛ quí tzi ba̱jtzi cʉ di tzʉtjo. ");
INSERT INTO otsNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gui nzojmʉ ca Ocja̱ pa jin da zʉh car tiempo‑cá̱ cʉ za̱na̱ cʉ rá ntzɛ, ni digue hnar pá drá nttzu̱jpi. Como da nesta gui möjmʉ yapʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cʉ pa‑cʉ́, da ndo sufri cʉ cja̱hni. Desde bbʉ mí mʉj nʉr mundo hasta gue bbʉ xta guadi, nunca xcá nú̱ yʉ cja̱hni hnar sufrimiento drá ndo ʉ ncja ngu̱ ca da tjojmʉ cʉ pa‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cja̱ bbʉ jin di jui̱jqui cʉ cja̱hni ca Ocja̱, bbʉ jin di mandado pa di meno cʉ cjeya cʉ da sufrijʉ, tje di du̱ cʉ cja̱hni, jin to di huete. Nu ca Ocja̱ da jui̱jqui quí cja̱jni cʉ xí juajni, eso da menobi cʉ pa‑cʉ́, pa jin da mpu̱n quí cja̱hni guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Bbʉ xta zøh car tiempo‑cá̱, bbʉ to da xihquijʉ: “Dyøjma̱ja̱, dí pa̱di jabʉ i bbʉh car Cristo ca xí hñi̱x car Tzi Ta ji̱tzi pa da möxquijʉ. Rá bbʉj nʉ tal lugar,” o “Bí bbʉh ca hnar ngu̱ ca dí pa̱di,” nuquɛjʉ, jin gui ma gui hñe̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porque da hño jiöjte cja̱hni, da ma̱jmʉ: “Guejquigö xí hñi̱xquigö ca Ocja̱ pa gu föxquijʉ.” Guejtjo da hño pé dda jiöjte cʉ da xihquijʉ, gueguejʉ ba ja̱jʉ hnar palabra i ntju̱mʉy ca rí hñe̱h ca Ocja̱. Cʉ jiöjte‑cʉ́, da u̱jtiquijʉ milagro co maravilla pa da hño ir mʉyjʉ, cja̱ pa gui hñe̱me̱jʉ, cierto xcuí hñe̱jmʉ ca Ocja̱. Da jion car manera ja drí jiöti göhtjo cʉ cja̱hni, co hne̱hquiguɛjʉ xí juajnquijʉ ca Ocja̱, da jioni ja drí jiöhquijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gui mfödijʉ digue cʉ cja̱hni‑cʉ́. Ya xtú xihquijʉ ja da ncja‑cʉ́, ante que da ni̱gui. ");
INSERT INTO otsNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Eso, bbʉ to da nzohquijʉ, da xihquijʉ ncjahua: “Bú e̱jmʉ ya, gui cca̱htijʉ car hñøjø ca xpá mɛjni ca Ocja̱. Rá bbʉjti pʉ jabʉ jin te i bbʉ ngu̱,” nuquɛjʉ, jin gui tɛnijʉ pa gui cca̱htijʉ. O guejtjo bbʉ da tsjihquijʉ: “Ya xí nzøh car cja̱hni ca xpá mɛjni ca Ocja̱. Rá ó ca hnar cuarto pʉ mbo nʉr ngu̱,” masque da tsjihquijʉ ncjapʉ, guejtjo jin gui hñe̱me̱jʉ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porque bbʉ pé xcuá e̱cö, jin gu e̱ gá ntta̱guitjo. Göhtjo cʉ cja̱hni da jiantigui, ncja ngu̱ bbʉ i ndota juɛtzi cja̱ i ni̱gui car rayo göhtjo jar ji̱tzi. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy. Bbʉ pé xcuá e̱je̱, xta fa̱di desde guejnʉ jabʉ rí bøx car jiadi hasta guejnʉ jabʉ rí ñʉy. ");
INSERT INTO otsNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","I fa̱di jabʉ i bbɛngui hnar ndu̱dyo, como guehpʉ i jmu̱ntzi pʉ cʉ ndojpada. Da ncjapʉ hne̱je̱ drí fa̱h bbʉ ya xí nzʉh car pá bbʉ pé xcuá cojcö. ");
INSERT INTO otsNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Cja̱ bbʉ ya xtrú tjoh cʉ pa bbʉ xta ndo sufri cʉ cja̱hni, nubbʉ́, xta jui̱ti car jiadi cja̱ ya jin da yoti car za̱na̱. Cʉ tzø xtu xøti jar ji̱tzi, xta jiøy, cja̱ cʉ i tøx nʉr ji̱tzi xta hna jiɛgui. Cja̱ da ndo jua̱ nʉr ji̱tzi, da yøte. ");
INSERT INTO otsNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Diguebbʉ ya, göhtjo cʉ cja̱hni cʉ i bbʉjcua jar jöy, cʉ mi̱ngu̱ göhtjo cʉ jñini cja̱ co göhtjo tema jöy, da ndo cjajʉ ndu̱mʉy. Da jiantijʉ pʉ jar ji̱tzi, xtu hna ni̱gui pʉ já gu̱y na̱r cja̱hni na̱ du e̱je̱ pa da mandado. Guejquigö, pé xcuá e̱cö, xcuá ja̱ cam cargo pa gu mandado hua jar jöy. Da ndo yoti cam tjay, cja̱ da ni̱gui te tza rá nzɛjquigö. ");
INSERT INTO otsNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Diguebbʉ ya, xcuá cu̱jcö cʉm ángele, da ntʉngui göhtjo nʉr mundo, cja̱ xta jʉxti hnar tjʉxi, drá ndo nzɛh cár jña̱. Cʉ ángele da hñojʉ göhtjo nʉr jöy, hasta guehpʉ jabʉ rá cca. Da jmu̱ntzi quí cja̱hni ca Ocja̱ cʉ xí hñe̱me̱, göhtjo pʉ jabʉ di bbʉy, desde jabʉ rí bøx car jiadi hasta guehpʉ jabʉ rí ñʉy. ");
INSERT INTO otsNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Gui mbe̱nijʉ ja i ncja nʉr za gá higo pa gui pa̱dijʉ ncjahmʉ da ncja‑cá̱. Bbʉ ya xqui ccangui quí dyɛ car za, cja̱ i ddoh quí xi, nubbʉ, xquí pa̱dijʉ, ya xta zøh cʉ za̱na̱ rá mpa. ");
INSERT INTO otsNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Da ncjadipʉ hne̱je̱, bbʉ xquí cca̱htijʉ göhtjo yʉ xtú xihquijʉ ya, nubbʉ, xtí pa̱dijʉ, bbʉ, ya xpa cerca car pa bbʉ xcuá coji. ");
INSERT INTO otsNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Dí xihquijʉ cierto, yʉ dda cja̱hni yʉ i bbʉjcua rá pa ya, da hmʉjtjo, jim be di tu̱‑yʉ́, bbʉ xta ncja cʉ xtú xihquijʉ ya. ");
INSERT INTO otsNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Da mpuni nʉr ji̱tzi co nʉr jöy, pe nde̱jma̱ da ncumpli yʉm palabra yʉ xtú ma̱. Göhtjo da ncja‑yʉ, ncja ngu̱ xtá ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Digue car pá co car hora bbʉ pé xcuá cojcö, jin to i pa̱di ncjahmʉ‑cá̱. Ni digue cʉ ángele cʉ bí bbʉ jar ji̱tzi di pa̱di, ni diguejquigö, ʉ́r Ttʉgui ca Ocja̱. Jøntsjɛ cam Tzi Tagö bí pa̱di. ");
INSERT INTO otsNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Da hna zøh car pa‑cá̱, ncja ngu̱ bbʉ mí hna ncja car mʉnti cja̱ bi ñu̱xi deje nʉr mundo, bbʉ mí bbʉh car Noé. Da ncjadipʉ bbʉ pé xcuá e̱cö. Guejquigö dúr cja̱hni xtu bbɛnqui pa gu mandado. ");
INSERT INTO otsNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bbʉ jí̱ bbe mí ñu̱xi deje nʉr mundo, cʉ cja̱hni jí̱ mí e̱me̱, ¿cja cierto di ncja‑ca̱? masque cjaatjo mír tsjijmʉ. Jí̱ mí cjadi mʉyjʉ digue ca mí xijmʉ car Noé. Mí mpöjmʉ, mí øtijʉ mbaxcjua, mí tzijʉ göhtjo ca mí nejʉ. Cʉ ddáa mí ntja̱jti. Jin te mí mbe̱n cʉ cja̱hni, hasta gue bbʉ mí ñʉti car Noé pʉ mbo car ndo barco. ");
INSERT INTO otsNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Cʉ cja̱hni‑cʉ́, jin gá hñe̱me̱jʉ má̱s te di ncja, hasta bbʉ mí mʉdi mí ñu̱xi deje car jöy, cja̱ nubbʉ́, göhtjo cʉ cja̱hni bi cjá̱ti deje bi du̱. Da ncjapʉ hne̱je̱ bbʉ xcuá e̱cö pa gu mandado hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Car pa‑cá̱, yojo hñøjø dra pɛh pʉ jar jua̱ji̱. Xta hna bbɛh ca hnáa, xta u̱jtjo, cja̱ ca pé hnáa ya, da gojti‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hnar ngu̱, di bbʉ yojo bbɛjña̱, dra mföxihui ʉr cjʉni. Ca hnáa, xta hna bbɛjtjo, cja̱ ca hnáa, xta gojti pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nuquiguɛjʉ, gui hmʉpjʉ listo, cja̱ gui tøbiguijʉ, nugö, ir Jmu̱guijʉ, ncjahmʉ pé xcuá e̱cö, como jin guí pa̱dijʉ tema pa da ncja‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","¿Te guí mbe̱nguɛjʉ? Car mi̱ngu̱, bbʉ di pa̱di tema hora di zøh car be̱, ¿cja jin di døhmi, bbʉ? ¿Cja di jiɛh car be̱ di ñʉti pʉ́r ngu̱ pa di gʉjquibi quí mɛjti? ");
INSERT INTO otsNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eso, dí xihquijʉ, gui tøbiguijʉ hne̱je̱, porque car hora ca guí ma̱jmʉ jin gu e̱je̱, xcuá hna e̱tigö, bbʉ. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Car muzo ca xí ttun cár cargo gá mayordomo, i mbe̱ni te i ne cár jmu̱ cja̱ i pɛjpi rá zö. I ntju̱mʉy car muzo‑cá̱, cja̱ i pɛhtzi mfe̱ni rá zö, eso xí tti̱tzi gá mayordomo, pa da cca̱htibi cár ngu̱ cár jmu̱, cja̱ da nú̱ cʉ pé dda muzo, da uni ca da zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bbʉ pé xta zøh car mi̱ngu̱, da döti car muzo‑cá̱, dra øte rá zö cár bbɛfi, cja̱ da ndo mpöh car muzo, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dí xihquijʉ cierto, car mi̱ngu̱ da hñix car muzo‑cá̱ pa da nú̱ göhtjo quí mɛjti, como xí cca̱hti, i ntju̱mʉy. ");
INSERT INTO otsNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pe bbʉ jin di øti ca rá zö car muzo, bbʉ di ma̱ntsjɛ mbo ʉ́r mʉy: “Xtu ndo dé cam jmu̱göjʉ, jim bé drí gojti‑cá̱,” ");
INSERT INTO otsNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","cja̱ bbʉ di mʉdi di ʉ́n quí mi̱nga̱‑muzohui cja̱ drí zo mbaxcjua o drí zihui cʉ ti̱, ");
INSERT INTO otsNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nubbʉ́, xtu hna e̱h car mi̱ngu̱ car pa ca di ma̱n car muzo jin du e̱je̱, cja̱ xta döti dra øti ca rá nttzo. Car hora ca jin gui ddøhmi, xta hna zøjø, ");
INSERT INTO otsNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","cja̱ da un car muzo‑cá̱ hnar castigo drá ndo ngu̱. Da cju̱h pʉ jabʉ rí ma cʉ jiöjte cja̱hni, ddagu̱tjo drí sufrihui‑cʉ́. Da nzom pʉ, cja̱ da ndo ungui ʉr du̱mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Car Jesús pé bi ma̱m bbʉ: ―Pa gui pa̱dijʉ ja da ncja bbʉ pé xcuá e̱h pʉ ji̱tzi pa gu mandado hua jar jöy, gui dyødejʉ nʉr bbede‑nʉ́: Hna vez, bi ttøti hnar ntja̱jti. Car novia bi mvitabi ddɛtta cʉ ba̱jtzi bbɛjña̱ cʉ mí ntzixihui guegue pa di hñe̱jmʉ car ntja̱jti. Nu cʉ amiga‑cʉ́ bi du̱x quí lámparajʉ gá aste cja̱ bi möjmʉ pʉ jár ngu̱ car novio. Bi døhmijʉ pʉ hasta bbʉ xti zʉh car hora pa di bønijʉ du ntjɛjʉ car novio. ");
INSERT INTO otsNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cʉtta cʉ ba̱jtzi bbɛjña̱ mí pɛhtzi mfe̱ni rá zö. Nu cʉ pé cʉtta jin gá mbe̱ni te di nestajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Cʉ ba̱jtzi bbɛjña̱ cʉ jin gá mbe̱ni di mprevenijʉ, bi du̱x quí lámparajʉ, pe jín gá ndu̱xjʉ pé hnar aste pa di xitijʉ bbʉ xti tjeh ca mí po. ");
INSERT INTO otsNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nu cʉ ba̱jtzi bbɛjña̱ cʉ xquí mpreveni rá zö, bi ñu̱htzi quí lámparajʉ cja̱ pé bi du̱xjʉ pé hnar aste pa di xitijʉ bbʉ xti tjeh ca mí po. ");
INSERT INTO otsNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nu car novio bú dé pʉ jabʉ xquí ma, jim be guá hñe̱tjo. Nu cʉ cja̱hni cʉ már tøhmijʉ, göhtjo bi nwahmijʉ cja̱ bi zʉjmʉ ʉr tta̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Bbʉ ya xquí zʉ madé ʉr xu̱y, car cja̱hni ca már bböh pʉ jar goxtji, bi hna nzoh cʉ pé ddáa, bi mafi: “Tzöjʉ ya, ya xpa e̱j nʉr novio. Exque gui pønijʉ ya, gui ma bú ntjɛjʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Diguebbʉ ya, göhtjo cʉ ba̱jtzi bbɛjña̱ bi bböpjʉ, bi jojqui quí lámparajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nu cʉ jí̱ xquí mbe̱ni di du̱xi pé hnar aste bi xih cʉ pé ddáa cʉ xquí mpreveni, i̱mbijʉ: “Ddajquije tzʉ ir astejʉ, porque ya xqui ne da jui̱ti yʉm lámparaje.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nu cʉ xquí mpreveni bi da̱di, i̱na̱jʉ: “Ex xca ma bú töntsjɛjʉ nʉ jabʉ rá cja. Cam asteje jin da zö pa dí göhtjojʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ya xi má pöjmʉ pa du töjmʉ car aceite, cja̱ bi zøh car novio. Cja̱ cʉ ba̱jtzi bbɛjña̱ cʉ mí pɛhtzi aste bú e̱jmi car novio cja̱ bi ñʉtijʉ jar ngu̱ pa di zöjʉ car mbaxcjua. Cja̱ bi cjoti car goxtji, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ma ya, bú coh cʉ ba̱jtzi bbɛjña̱ cʉ xquí ma pa pé du töngui aste, cja̱ bi nzojmʉ car novio, bi dyöjpijʉ di xojquibijʉ car goxtji. Bi hñi̱na̱jʉ: “Nuquɛ, Tada, xoguije tzʉ car goxtji gu cʉtije.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bi da̱j ya car novio, bbʉ: “Jin gui tzö gu xoquiquijʉ, como jin dí pa̱di toquiguɛjʉ.”― ");
INSERT INTO otsNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Diguebbʉ ya, car Jesús bi xih cʉ cja̱hni cʉ már ødejʉ: ―Nuquiguɛjʉ, dí xihquijʉ gui mprevenijʉ, porque jin guí pa̱dijʉ tema pa o tema hora pé xcuá e̱cö. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Diguebbʉ ya, car Jesús pé bi ma̱, i̱na̱: ―Gui dyødejʉ nʉ pé hnar bbede pa gui pa̱dijʉ ja ncja ga mandado ca Ocja̱. Mí bbʉh hnar hñøjø, múr rico. Mí ne di bøni di ma hnar jöy yapʉ. Bi nzoh quí muzo cja̱ bi döjti cár domi guegue pa di dyombi ʉ́r viaje. ");
INSERT INTO otsNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Car mi̱ngu̱ ya bi uni domi cada hna quí muzo. Ca hnáa, bi ungui cʉtta mil car domi, cja̱ ca pé hnáa, pé bi ungui yo mil domi, cja̱ ca hnáa ya, pé bi ungui hna miltjo. Bi tantea car domi ca bi uni cada hnáa, según cʉ mfe̱ni cʉ mí pɛhtzijʉ pa di ba̱di te drí cjajpijʉ car domi. Diguebbʉ ya bi bøn car jmu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Car muzo ca xquí jña̱x car cʉtta mil car domi, bi má bú dyombi ʉ́r viaje, cja̱ pé bú ta̱ cʉtta mil cár tja̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pé bi ncjadipʉ car muzo ca xquí jña̱x cʉ yo mil car domi. Pé bú ta̱ pé hnar yo mil cár tja̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nu car muzo ca xquí jña̱xi hna miltjo, bi ma bú xi̱hmi jar jöy, cja̱ bi dyöh pʉ cár domi cár jmu̱, pa jin di ttzoni. ");
INSERT INTO otsNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bi tjo tiempo rá ngu̱. Nubbʉ, pé bi zøh car jmu̱, bi nzojni cʉ muzo, bi dyʉhtibi ʉr huɛnda. ");
INSERT INTO otsNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bbɛto bú e̱h car muzo ca xquí jña̱x car cʉtta mil, mbá ja̱mpi cár lamo pé cʉtta mil. Bi ma̱: “Nuquiguɛ, Tzi Jmu̱, gú ddajqui cʉtta mil car domi. Tji na̱ pé hnar cʉtta mil xtú ta̱ja̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Cja̱ car mi̱ngu̱ ya bi xifi: “Rá zö ca xcú dyøte. Gúr jogui mɛfi. Xcú pɛjpigui rá zö digue ca tengu̱. Nuya, gu ddahqui más rá ngu̱ pa gui pɛjpi. Dí cʉti jam ngu̱ ya, gu mpöjmʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ma ya, pé bi zøh car muzo ca xquí jña̱x cʉ yo mil car domi. Cja̱ nucá̱ bi xih cár jmu̱: “Nuquɛ, Jmu̱, gú ddajqui yo mil. Nuya, tji ya na̱ pé yo mil, ʉ́r tja̱ja̱ digue ca gú ddajqui.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Cja̱ pé bi xih car mi̱ngu̱, bi hñi̱mbi: “Rá zö ca xcú dyøte. Nuquɛ, gúr jogui muzo hne̱je̱. Xcú pɛjpi rá zö ca tengu̱ ca dú ddahqui. Nuya, gu ddahqui más rá ngu̱ pa gui pɛjpi. Dí cʉti ya jabʉ dí bbʉy, gu mpöjmʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Diguebbʉ ya, gá nga̱x ya, bi zøh car muzo ca xquí jña̱xi hna miltjo, bi xih cár lamo: “Nuquɛ, Jmu̱, dí pa̱di gúr hñøjø guí ndo pa̱di gui cuajti quer domi. Guí xofo nʉ jabʉ jí̱ xquí tu̱ju̱, cja̱ guí jmu̱ntzi semilla nʉ jabʉ jí̱ xquí poni. ");
INSERT INTO otsNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eso, dú tzu̱, cja̱ dú ma öh quer domi jar jöy. Cja̱ nuyá, hne̱ dá tzoj nir mɛjtiguɛ.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Cja̱ bi da̱h cár jmu̱, bi xifi: “Nuquiguɛ, gúr da̱jni̱, gúr ttzomɛfi. Ya xi nguí pa̱di dí xojcö nʉ jabʉ jí̱ xtá tu̱ju̱, cja̱ dí jmuntzigö nʉ jabʉ jí̱ xtá poni. ");
INSERT INTO otsNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Eso, mír ntzöhui güi ma tzoj nʉm domi pʉ jar banco, cja̱ bbʉ xcua cojcö, gua ma ja̱ cam domi cja̱ co cár tja̱ja̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Diguebbʉ ya cár jmu̱ bi xih cʉ pé dda muzo: “Jña̱mbijʉ ya ca hna miltjo ca i ja̱, cja̱ gui unijʉ nʉ i ja̱ ddɛtta mil. ");
INSERT INTO otsNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque ca to más i ja̱, más da ttuni. Pe nu ca jin tza te i ja̱, ca tchʉtjo ca i ja̱jma̱ja̱, da tja̱mbitjo. ");
INSERT INTO otsNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nʉ nʉr muzo nʉ jin te xcá mɛfi, gui fonguijʉ drí ma pʉ tji, pʉ jabʉ rá hmɛxu̱y. Da nzom pʉ cja̱ da ndo sufri.”― I ttzɛdi hua nʉr bbede‑nʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Cja̱ pé bi ma̱n car Jesús: ―Bbʉ pé xcuá e̱cö pa gu mandado hua jar jöy, xcuá ja̱ cam cargo, cja̱ xcuá yobbe cʉm ángele rá ngu̱. Nubbʉ, gu mandado, gu cja ʉr rey, cja̱ da ni̱gui te tza rá ji̱tzi cam cargo. Guejquigö, dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Diguebbʉ, da jmuntzi göhtjo yʉ cja̱hni delante pʉ jabʉ xtá mi̱. Cja̱ gu juejqui cʉ cja̱hni ncja ngu̱ hnar mödi ga juejqui quí zu̱we̱, hnaani drí hmöh cʉ dɛjti, cja̱ pé hnaani cʉ chivo. ");
INSERT INTO otsNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Gu i̱h cʉm dɛjti jam jogui dyɛ, cja̱ cʉ chivo gu i̱h pʉ jam ntchohta. ");
INSERT INTO otsNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Car pa‑cá̱, ya xcrú cjagö ʉr rey. Xtá nzojcö cʉ cja̱hni cʉ drí hmʉh pʉ jam jogui dyɛ, xtá xijmʉ: “Bú e̱jmʉ ya, nuquɛjʉ, xí juajnquijʉ cam Tzi Ta pa dí cja̱hniquijʉ, cja̱ xí nú̱quijʉ co cár tzi jma̱jte. Nuya, gui cʉtijʉ hua jabʉ gui föxquigöjʉ cam jmandado. Gui hmʉjquɛjʉ hua nʉr lugar nʉ jabʉ xí tjojqui pa gui tzöyajʉ, desde bbʉ mí mʉj nʉr jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rí ntzöhui gui cʉtijʉ hua, porque bbʉ ndí tu̱ntju̱gö, nuquɛjʉ gú wi̱nguijʉ. Bbʉ ndí tu̱tjegö, nuquɛjʉ gú ddajquijʉ te dú tzi. Bbʉ ndí bbʉh pʉ jabʉ jin te mí bbʉh cam ngu̱, nuquɛjʉ, gú ddajquijʉ ʉr tsjɛjqui dú cuati jer ngu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bbʉ ndí nestagö da̱jtu̱, nuquɛjʉ, gú ddajquijʉ‑cá̱. Guejtjo, bbʉ ndí jnini, nuquɛjʉ, gú ma cca̱jtiguijʉ. Bbʉ ndí bbʉ jar födi, gú ma cca̱jtiguijʉ pʉ hne̱je̱.” Da ma̱ ncjapʉ car rey. ");
INSERT INTO otsNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Diguebbʉ ya, da da̱h cʉ cja̱hni cʉ xí tsjifi da ñʉti pʉ jabʉ i bbʉh car rey, da hñi̱na̱jʉ: “Nuquɛ, Tzi Jmu̱, ¿tema pa xcrú cca̱jtiquije nguí tu̱ntju̱ cja̱ xcrú wi̱nquije? ¿Tema pa nguí tu̱tje, cja̱ dú ddahquije te güi tzi? ");
INSERT INTO otsNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ncjahmʉ xcrú cca̱jtiquije bbʉ jin te di bbʉh quer ngu̱ cja̱ xcrú mvitaquije güi cuati jam ngu̱je? Guejtjo, ¿ncjahmʉ nguí nesta da̱jtu̱, cja̱ nugöje xcrú ddahquije cá̱? ");
INSERT INTO otsNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Guejtjo, ¿ncjahmʉ xcrú cca̱jtiquije, nguí jñini, o ngrá bbʉ jar födi, cja̱ dú ma föxquije?” ");
INSERT INTO otsNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nubbʉ, xta da̱h car rey, xta xijmʉ: “Cierto, dí xihquijʉ, ca te gú dyøhtibijʉ hna cʉm hñohui, masque jin tza di ntju̱mʉy car cja̱hni‑cá̱, ncjahmʉ guejquigö gú dyøjtiguijʉ ncjapʉ hne̱je̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Diguebbʉ ya car rey pé da nzoh cʉ cja̱hni cʉ drí hmʉ jár ntchohta dyɛ, da xijmʉ: “Nuquiguɛjʉ, gui wembiguijʉ ya, rá nttzoquiguɛjʉ. Grí möjquɛjʉ pʉ jar tzibi ca jin gui jui̱ti. Xí tjojqui car lugar‑cá̱ pa dúr nttzöya ca Jin Gui Jo co göhtjo quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Rí ntzöhui gui möjmʉ pʉ, porque bbʉ ndí tu̱ntju̱, nuquɛjʉ jin te gú ddajquijʉ pa gua tzi. Bbʉ ndí tu̱tje, guejtjo jin te gú ddajquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bbʉ ndí dyo pʉ jabʉ jin te mí bbʉh cam ngu̱, nuquɛjʉ, jin gú ddajquijʉ ʉr tsjɛjqui gua cuati tzʉ jer ngu̱jʉ. Guejtjo, bbʉ jin te ndí ca̱ da̱jtu̱, jin gú ddajquijʉ‑cá̱. Bbʉ ndí jni̱ni, jin gú ma cca̱jtiguijʉ, cja̱ bbʉ ndár bbʉ jar födi, nuquɛjʉ, jin gú möjmʉ pa güi föxquijʉ tzʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Cja̱ diguebbʉ, guegue‑cʉ́ da da̱di hne̱je̱, da dyönijʉ: “Nuquɛ, Tzi Jmu̱, ¿ncjahmʉ xcrú cca̱jtiquije nguí tu̱ntju̱ o nguí tu̱tje? ¿Ncjahmʉ xcrú cca̱jtiquije, nguí dyo pʉ jabʉ jin te mí bbʉh quer ngu̱, o jin te nguí ca̱ da̱jtu̱ pa güi jie? ¿Ncjahmʉ xcrú cca̱jtiquije, nguí jñini, o ngár bbʉ jar födi? ¿Ncjahmʉ xtrú ncja‑cʉ́, cja̱ nugöje, jin te dá föxquije?” ");
INSERT INTO otsNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Diguebbʉ ya, da da̱h car rey, da xih cʉ cja̱hni‑cʉ́: “Cierto, dí xihquijʉ, cada bbʉ nguí cca̱htijʉ hnáa digue yʉm hñohui mír sufri, masque jin te di ntju̱mʉy car cja̱hni‑cá̱, bbʉ jin gú föxjʉ‑cá̱, ncjahmʉ guejquigö jin gú föxquigöjʉ, hne̱je̱.” ");
INSERT INTO otsNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nugö, dí xihquijʉ, cʉ cja̱hni cʉ jí̱ xcá ne xcá möx cʉm hñohui, da cju̱h pʉ jabʉ jin gui tzö, cja da ttun cár castigojʉ, ni mpa jabʉ drí tzöya. Nu cʉ cja̱hni cʉ xí dyøtijʉ ncja ngu̱ ga ne ca Ocja̱, da ma pʉ jabʉ da ncja car nzajqui göhtjo ʉr tiempo.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Car Jesús, bbʉ ya xquí ma̱ göhtjo yʉ palabra‑yʉ́, pé bi xih quí möxte, bi hñi̱mbijʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Nuquɛjʉ, ya xquí pa̱dijʉ, jøndi yojpa i bbɛj ya pa da ncja car mbaxcjua ca i tsjifi ʉr Pascua. Bbʉ xta ncja car mbaxcjua‑cá̱, xta ndöguigö pa da ddøjqui jar ponti. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Diguebbʉ ya, cʉ möcja̱ cʉ mí mandado, co ni cʉ dda hñøjø cʉ mí nxöh car ley, cja̱ co ni cʉ tita cʉ mí pɛhtzijʉ cargo di mandadobi cʉ cja̱hni israelita, göhtjo‑cʉ́ bi jmuntzi pʉ jár palacio car da̱möcja̱. Guegue‑cá̱ mí ju̱ cár tju̱ju̱ múr Caifás. ");
INSERT INTO otsNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bi ña̱tsjɛjʉ, bi jion car manera ja drí dyøhtibi hnar trampa pa di zʉh car Jesús cja̱ di möhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bi ma̱jmʉ: ―Gu tøhmijʉ hasta bbʉ xta tjoj nʉr mbaxcjua, pa jin da mföxjʉ cʉ cja̱hni rá ngu̱ cʉ xí jmu̱ntzi, jin da cja ʉ́r dyɛjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ca hnajpa, car Jesús már bbʉh pʉ jar tzi jñi̱ni Betania. Már bbʉh pʉ jár ngu̱ ca hnar hñøjø mí ju̱ cár tju̱ju̱ múr Simón. Guegue‑cá̱ mí tzöhui car jnini ca mí tsjifi lepra. ");
INSERT INTO otsNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Car Jesús már ju̱ pʉ jar mexa, már tzi. Cja̱ bú e̱h hnar bbɛjña̱, mbá tu̱ hnar xijto már ndo ma̱di. Car xijto mí po perfume már ma̱di hne̱je̱. Car bbɛjña̱ bi guati car Jesús, cja̱ bi xihtzibi cár ña̱‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nu quí möxte car Jesús, bbʉ mí cca̱htijʉ te már øti car bbɛjña̱, bi unijʉ ʉr cuɛ, cja̱ bi ma̱jmʉ: ―¿Dyoca̱ xí föndi nʉr perfume mí ndo mu̱hui? ");
INSERT INTO otsNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mír ntzöhui di bbö, di nccu̱hti hnar precio rá ngu̱, cja̱ di ttun car domi cʉ tzi probe.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nu car Jesús, bbʉ mí dyøj nʉr palabra‑nʉ́, bi xih quí möxte: ―¿Dyoca̱ gár huɛntijʉ nʉr bbɛjña̱? Rá zö ca xí dyøjtigui‑nʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Porque göhtjo ʉr pa guí bbʉpjʉ cʉ tzi probe. Göhtjo ʉr pa da jogui gui föxjʉ‑cʉ́. Pe nuguigö, ya jin gu hmʉpjʉ rá ngu̱ mpa. ");
INSERT INTO otsNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Guegue‑nʉ́ xí xixqui nʉr perfume ncjahmʉ xí joguigui nʉm cuerpo pa bbʉ xta ttöguigö.― (Bi ma̱ ncjapʉ car Jesús, como cʉ cja̱hni israelita mí pɛhtzijʉ hnar costumbre, mí cohtzibijʉ perfume quí cuerpo quí ánimajʉ.) ");
INSERT INTO otsNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cja̱ pé bi ma̱ guegue: ―Dyøjma̱jʉ nʉ dí xihquijʉ, göhtjo pʉ jabʉ da jma̱ nʉr tzi jogui jña̱, göhtjo hua jar mundo, guejtjo da tsjih cʉ cja̱hni te xí dyøti nʉr bbɛjña̱‑nʉ́, cja̱ da fe̱ni.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Diguebbʉ ya, ca hnáa digue cʉ doce quí möxte car Jesús ca mí ju̱ cár tju̱ju̱ múr Judas Iscariote bi má pʉ jabʉ már bbʉh cʉ möcja̱ cʉ mí mandado, ");
INSERT INTO otsNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","cja̱ bú öni: ―¿Tengu̱ gui ddajquijʉ pa gu döquijʉ car Jesús?― Cja̱ gueguejʉ bi gu̱tijʉ treinta domi gá plata. ");
INSERT INTO otsNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Desde car hora‑cá̱, car Judas Iscariote mí tøhmi hnar hora bbʉ xti jogui di dö car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nubbʉ́, bi mʉdi bi ncja car mbaxcjua gá Pascua. Bbʉ mí ncja car mbaxcjua‑cá̱, cʉ cja̱hni judio mí tzi tju̱jme̱ cʉ jin te mí hua̱nihui levadura. Cár primero car pa car mbaxcjua‑cá̱, bú e̱h quí möxte car Jesús, bi guatijʉ, cja̱ bi dyönijʉ: ―¿Jabʉ guehpʉ guí ne gu jojquije pa gu tzöjʉ car mbaxcjua?― ");
INSERT INTO otsNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Cja̱ guegue bi da̱di: ―Gui möjmʉ pʉ jar jñini Jerusalén, pʉ jár ngu̱ ca hnar hñøjø ca ya xtú xihquijʉ, cja̱ gui xijmʉ: “I ma̱n cam maestroje, ya xta zøh car hora pa da má. I ne guegue, gui ddajquije tzʉ ʉr tsjɛjqui gu tzije car jñu̱ni gá mbaxcjua nuhua ir ngu̱.” Da ncjapʉ grí xijmʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Diguebbʉ ya, bi ma quí möxte, bi dyøte ncja ngu̱ gá bbɛjpi car Jesús, bú jojqui car jñu̱ni gá mbaxcjua pʉ jár ngu̱‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bbʉ ya xquí nde, car Jesús co ni cʉ doce quí möxte bi möjmʉ jár ngu̱‑cá̱. Bi guatijʉ jar mexa, bi mi̱pjʉ cja̱ bi zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bbʉ már tzijʉ, car Jesús bi xih quí möxte, i̱mbijʉ: ―Dí xihquijʉ cierto, i bbʉhquiguɛjʉ ca hnáa ca da döguigö.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nu quí möxte, bbʉ mí dyøjmʉ nʉr palabra‑nʉ́, bi du̱mʉyjʉ rá ngu̱, cja̱ bi mʉdi bi hñönijʉ ngu‑hna ngu̱‑hna: ―¿Cja huá guejquigö, Tzi Jmu̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Diguebbʉ ya, car Jesús bi da̱di, i̱na̱: ―Car hñøjø ca dár tjʉhmibbe parejo cʉm tju̱jme̱bbe hua na̱r moji na̱ ra tixcua, guehcá̱ da döguigö. ");
INSERT INTO otsNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nuya, ya xní ma da bböjtigui, ncja ngu̱ ga ma̱m pʉ jar Escritura, pʉ jabʉ i ma̱ te di ncjajpi car cja̱hni ca di bbɛjni hua jar jöy. Nu car hñøjø ca da döguigö, da ndo ncastiga guegue‑cá̱. Más di joh bbʉ jí̱ xtrú hmʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Diguebbʉ ya bi da̱jtsjɛ car Judas. Guegue‑cá̱ ya xti dö car Jesús. Bi ma̱: ―¿Cja guejquigö, Maestro?― Bi xih car Jesús, i̱na̱: ―Guehquiguɛ, xcú ma̱ntsjɛ.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Menta már tzijʉ, car Jesús bi jña̱ hnar tju̱jme̱, bi dyöjpi car Tzi Ta ji̱tzi di bendeci, bi jejque, cja̱ bi un quí möxte. Bi hñi̱mbijʉ: ―Gui jña̱jʉ na̱r tju̱jme̱‑ná̱, gui tzijʉ. Nuná̱, ʉm cuerpo‑ná̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Diguebbʉ ya, bi du̱u̱ car vaso, mí po vino, cja̱ bi dyöjpi cjama̱di ca Ocja̱. Bi un quí möxte, bbʉ, cja̱ bi xijmʉ: ―Gui tzijʉ na̱r vino‑ná̱, guí göhtjojʉ, porque guejna̱ ʉm cji‑na̱ xta mföni. ");
INSERT INTO otsNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Xtá föngö cam cji pa da ttøti hnar ddadyo acuerdo, pa ncjapʉ drí mperdonabi ca rá nttzo ca xí dyøti yʉ cja̱hni rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Dí xihquijʉ, desde rá pa ya, ya jin gu tzigö vino hasta gue bbʉ xtá fʉdi xtá mandadogöbbe hua jar jöy, nugö cja̱ co cam Tzi Ta. Nubbʉ, pé da ncja mbaxcjua, cja̱ pé gu mpɛjnijʉ, gu tzijʉ hnar ddadyo vino, dí göhtjojʉ.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bbʉ ya xquí ncja‑yʉ́, car Jesús co quí möxte bi xöjmʉ hnar himno, cja̱ bi bøni gá möjmʉ jar ttøø ca mí tsjifi Cerro de Olivos. ");
INSERT INTO otsNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Diguebbʉ ya, car Jesús bi xih quí möxte: ―Göhtjoquiguɛjʉ gui ma gui jiɛjmʉ ca grí hñe̱me̱guijʉ, cja̱ gui wembiguijʉ rá nxu̱nya. Guehcá̱ xta ncja‑cá̱, como i ma̱n ca Ocja̱ pʉ jar Escritura: “Gu jɛh car mödi da bböhti, cja̱ da mfonti car tajo cʉ dɛjti.” ");
INSERT INTO otsNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","I tzʉdi, ya xta bböjtigui, pe bbʉ pé xtá jña̱ ʉm jña̱gö, gu hmɛto gu ma pʉ jar jöy Galilea, cja̱ nuquiguɛjʉ, xquí tɛnguijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Diguebbʉ ya, bi da̱h car Pedro, bi xifi: ―Masque da wembiqui göhtjo yʉ ddáa, pe nugö, jin gu wembiqui.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nu car Jesús bi xifi: ―Cierto dí xihqui, rá nxu̱nya, ante que da mah car ndøxca, nuquiguɛ, xquí ma̱, jin guí meyagui. Jñu̱ vez xquí ma̱ ncjapʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Cja̱ car Pedro pé bi ma̱m bbʉ: ―Masque hnaadipʉ gu tu̱hui, pe jin gu cønqui, nim pa hnar vez.― Cja̱ cʉ pe dda quí möxte car Jesús, göhtjo bi ma̱ ncjapʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Diguebbʉ ya, car Jesús bi möjmʉ quí möxte, gá möjmʉ hnar huerta ca mí tsjifi Getsemaní, cja̱ guegue bi xijmʉ: ―Mi̱jtijma̱jʉ hua menta gár ma nʉ rá cjanʉ, gu ma nzoh ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Cja̱ car Jesús bi zix car Pedro co cʉ yojo quí ttʉ car Zebedeo, gue car Juan co car Jacobo. Diguebbʉ ya, car Jesús bi ndo du̱mʉy, cja̱ bi mʉdi bi ntzøte rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Cja̱ bi xih cʉ jñu̱ quí amigo cʉ xquí zitzi, i̱mbijʉ: ―I ndo du̱mʉy nʉm tzi mʉy, ya xtrá ma gu tu̱. Xtí cojmʉ hua, cja̱ gui tzödijʉ. Nugö, pé xcrá magö nʉ rá cjanʉ, gu ma nzoh ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bbʉ xquí ma̱ ncjapʉ, pé gá ma nʉ rá tzi cjanʉ, bi hmɛmfo jar jöy, cja̱ bi ora, i̱na̱: ―ʉm Tzi Taquigö, bbʉ da jogui, gui cjʉzqui tzʉ nʉr prueba nʉ ba e̱je̱, pa jin da nesta gu tzöbbe. Pe nde̱jma̱ da ttøte ncja ngu̱ gri neguɛ, jin da ncjá ncja ngu̱ dra ne‑gö.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cja̱ pé bú e̱h pʉ jabʉ már bbʉh quí möxte. Bi döti, ya xi már a̱jmʉ, cja̱ guegue bi nzoh car Pedro, bi dyöni: ―Nuquɛjʉ, ¿cja jin güi jiötijʉ tzʉ güi tzödijʉ hna horatjo, menta ndár mahti ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gui tzödijʉ cja̱ gui mahtijʉ ca Ocja̱, pa jin da zʉhquijʉ hnar prueba ca jin gui jiötijʉ. Nuquɛjʉ, mbo ir tzi mʉyjʉ, guí ne gui dyøtijʉ ca rá zö, nu quir cuerpojʉ jin gui jöti rá ngu̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ma ya, pé bi ma car Jesús pʉ jabʉ xcuí ora, pé bi yojpi bi nzoh car Tzi Ta ji̱tzi, bi ma̱: ―ʉm Tzi Taquigö, bbʉ jin gui tzö gui cjʉzqui nʉr prueba nʉ ba e̱je̱, bbʉ nde̱jma̱ dí nesta gu tzöbbe, da ttøjtigui ncja ngu̱ guí mbe̱ni, bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Diguebbʉ ya, pé bú coji, pé bi döti quí möxte, ya pé xquí a̱tijʉ, porque mí ndo ɛjʉ car tta̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nubbʉ, bi jiɛjti‑cʉ́ car Jesús, pé bi ma bú ora ca xtrá jñu̱ vez. Pé bi nzoh ca Ocja̱, bi dyöjpi tzʉ, ¿cja jin di jogui di gʉhtzibi car prueba ca ya xti zʉdi? ");
INSERT INTO otsNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bi guadi bi ora, cja̱ pé bi guati car Jesús pʉ jabʉ már bbʉh quí möxte, cja̱ bi xijmʉ: ―Nuya, gui a̱tijʉ ya, bbʉ́, cja̱ gui tzöyajʉ. Ya xí tjoh car hora pa güi nzojmʉ ca Ocja̱. Ya xí nzʉh car hora pa da ttzʉjquigö cja̱ da ndöguigö jáy dyɛ cʉ cja̱hni cʉ i ndu̱jpite. Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nuya, gui bböpjʉ nttzɛdi ya, gu möjö. Ya xpa e̱j nʉr hñøjø nʉ da döguigö.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Már ña̱di car Jesús, cja̱ bi zøh car Judas Iscariote. Guegue‑cá̱ múr möxte car Jesús, mí yojmi cʉ pé dda once. Car Judas mbá yojmi cja̱hni rá ngu̱, mbá cʉjʉ espada, cja̱ co za. Cʉ cja̱hni rá ngu̱ cʉ mbá e̱je̱, xcuí gu̱h cʉ möcja̱ cʉ mí mandado, cja̱ co cʉ tita cʉ mí pɛhtzijʉ cargo di mandadobi cʉ cja̱hni israelita. ");
INSERT INTO otsNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Car Judas Iscariote ya xquí reglahui cʉ cja̱hni‑cʉ́ di dö car Jesús, cja̱ xquí xijmʉ cʉ cja̱hni cʉ mbá yojmi, hnar seña pa drí meya car Jesús. Guegue xquí xijmʉ, i̱na̱: ―Car hñøjø ca gu nda̱nebi jár jmi̱, guehcá̱ gui pɛntijʉ‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Car Judas nguetica̱ bi guati pʉ jabʉ már bbʉh car Jesús, bi zɛngua, bi hñi̱mbi: ―Nuquɛ, tzi Maestro, ¿cja guí bbʉjtjo?― Cja̱ bi nda̱nebi cár jmi̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nu car Jesús bi xifi, i̱na̱: ―Nuquɛ, ñø, ¿te grí hñe̱jquɛ tzʉ?― Cja̱ nguetica̱ bi guati cʉ nzʉttabi, bi zʉdijʉ car Jesús, bi pɛntijʉ rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Xní ncja‑cá̱, xní wá̱n cár dyɛ ca hnáa digue quí amigo car Jesús cʉ má yojmʉ, mí ne di mötzi. Bi ccohtzi cár espada jár ntto, cja̱ bi fʉjquibi ca hnár gu̱ car muzo ca mí pɛjpi car da̱möcja̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nu car Jesús bi bbɛjpi: ―Gui cuajti ya quer espada. Dyo guí cje ir dyɛ, porque da bböhti yʉ cja̱hni yʉ i cja í dyɛjʉ pa drí möhti yí mi̱nga̱‑cja̱hnijʉ. Ncja ngu̱ ga pöhtite‑yʉ́, da ncjapʉ drí bböhti, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Cja jin guí pa̱di, bbʉ gua negö, gua nzoh cam Tzi Ta ji̱tzi, cja̱ guegue di mɛjni nttzɛdi rá ndo ngu̱ mil quí ángele di möxqui? ");
INSERT INTO otsNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pe bbʉ gua öjpigö‑cá̱, ¿ja ncja drí zʉh ca i ma̱m pʉ jar Escritura? Como i ma̱m pʉ, i nesta da bböjtigö.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Diguebbʉ ya, car Jesús bi nzoh cʉ cja̱hni cʉ xquí jmu̱ntzi, bi xijmʉ: ―¿Dyoca̱ guá cʉjʉ espada co za? ¿Dyoca̱ grí hñe̱jmʉ gui tzʉjquigöjʉ ncja hnar be̱? Göhtjo ʉr pá ndí ju̱h pʉ jar templo ndí u̱jti yʉ cja̱hni. ¿Sá jin gú möjmʉ pa güi tzʉjquijʉ bbʉ ndí pa pʉ? ");
INSERT INTO otsNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nugö, dí pa̱di, xí ncja göhtjo‑yʉ, pa da ncumpli cʉ palabra cʉ bi ma̱n cʉ profeta, pʉ jar Escritura.― Nu quí möxte car Jesús, bbʉ mí cca̱htijʉ, ya xquí ttzʉ guegue, göhtjojʉ bi zoguijʉ cja̱ bi ddajmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Cʉ hñøjø cʉ xquí pɛnti car Jesús bi zitzi gá möjmʉ jár ngu̱ car Caifás, cja̱ bi ñʉtijʉ pʉ. Guegue‑cá̱ múr da̱möcja̱. Ya xquí jmu̱ntzi pʉ cʉ dda hñøjø cʉ mí mandadobi cʉ cja̱hni israelita, tzʉdi, cʉ maestro cʉ mí nxöh car ley cja̱ co cʉ tita cʉ mí pɛhtzijʉ cargo. Már øtijʉ junta. ");
INSERT INTO otsNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nu car Pedro bi dɛn car Jesús, tzi yanʉ, hasta bbʉ gá nzøti pʉ jár patio cár ngu̱ car Caifás. Nupʉ, bi gojti pʉ, bi mi̱bi cʉ nzʉttabi pa di cca̱hti te di ncjajpi car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Cʉ jefe cʉ mí mandadobi cʉ möcja̱ co hne̱je̱ göhtjo cár junta cʉ tita cʉ mí mandadobi cʉ cja̱hnitjo bi ña̱tjsɛjʉ. Mí jonijʉ tema bbɛtjri di jiøxijʉ car Jesús, pa di jogui di ttun car sentencia drí bböhti. ");
INSERT INTO otsNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Már ngu̱ cʉ cja̱hni cʉ bi mpresenta, bi döjʉ testimonio. Hna‑hnáa bi ma̱jmʉ tema cosa rá nttzo xtrú dyøti car Jesús, pe jin te mí bbʉ testigo pa di ma̱, ¿cja cierto xtrú dyøti ncjapʉ? Gá nga̱x ya bi mpresenta pé yojo testigo, cja̱ guejti‑cʉ́ bi ma̱jmi bbɛtjri, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Gueguehui bi ma̱jmi: ―Xtú ødebbe nʉr Jesús, xcá ma̱: “Nugö rá nzɛjqui pa gu yøhti nʉ́r templo ca Ocja̱, cja̱ ca pé xtrá jñu̱jpa, ya xcrú cjuadi pé xcrú xotzi.”― ");
INSERT INTO otsNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nubbʉ, bi bböh car da̱möcja̱, bi dyön car Jesús: ―¿Cja cierto ca i ma̱n yʉ testigo‑yʉ? ¿Sá jin te guí tja̱j ya, bbʉ́?― ");
INSERT INTO otsNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nu car Jesús nde̱jma̱ jin te gá nda̱di. Cja̱ car da̱möcja̱ pé bi xih car Jesús: ―Dí bbɛjpiqui gui xijquije ya ca ncjua̱ni, cja̱ gui hñi̱h car Tzi Ta ji̱tzi gá testigo. Gui ma̱nguɛ ya, ¿Cja guehquiguɛ xí hñi̱xquiguɛ ca Ocja̱ gúr Cristo? ¿Cja ʉ́r Ttʉqui ca Ocja̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Cja̱ car Jesús bi da̱di: ―Ja̱a̱, guejquigö. Guehquɛ xcú ma̱ntsjɛ. Guejtjo hne̱je̱ dí xihquijʉ, ba e̱h car pa bbʉ xtí cca̱jtiguijʉ, ya xcra ju̱ pʉ jár jogui dyɛ car Tzi Ta ca i mandado pʉ ji̱tzi, gra föx cár jmandado. Gue car pa bbʉ pé xcuá e̱h pʉ já gu̱y. Guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy.― Ncjapʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Diguebbʉ ya, car da̱möcja̱ bi ndo uni ʉr cuɛ, bi xɛn quí da̱jtu̱, cja̱ bi xih cʉ pé ddáa cʉ már bbʉh pʉ: ―Nʉr hñøjø‑nʉ́ i ne da cjatsjɛ Ocja̱. ¿Dyoca̱ dí jonijʉ pé dda testigo pa pé da ma̱jmʉ te xtrú dyøti‑nʉ́? Ya xcú dyødejʉ cʉ palabra xí ma̱. Jin gui tzö‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Te guí ma̱nguɛjʉ? ¿Tema castigo da ttuni‑nʉ́?― Cja̱ bi da̱h cʉ cja̱hni, bi ma̱jmʉ: ―I tu̱ pena. ¡Rí ntzöhui da bböhti!― ");
INSERT INTO otsNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bbʉ xquí ma̱jmʉ ncjapʉ, cʉ cja̱hni bi zohtzibijʉ cár jmi car Jesús, cja̱ bi unijʉ mpɛhti. Mí bbʉh cʉ ddáa cʉ bi føjnijʉ, cja̱ bi xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","―Nuquiguɛ, bbʉ xí hñi̱xquiguɛ ca Ocja̱ gúr Cristo, má̱s göhtjo guí pa̱h bbʉ. Gui xijquije ya, ¿toca̱ xí ʉnqui?― ");
INSERT INTO otsNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nu car Pedro már ju̱di pʉ jar patio, cja̱ bú e̱h hnar muza, bi guati, bi hñi̱mbi: ―Guehquitjoguɛ, nguí ntzixihui car Jesús, car mi̱ngu̱ Galilea.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Már øde göhtjo cʉ cja̱hni cʉ már bböh pʉ jar patio. Nu car Pedro bi gøni, bi xih car muza, i̱na̱: ―Jin dí pa̱cö te gár ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cja̱ bi wem pʉ, ya xi mír ma jár goxtji car patio, cja̱ pé bú ntjɛhui pé hnar muza. Guejti‑cá̱ bi xih cʉ dda cja̱hni cʉ már bbʉh pʉ, i̱mbijʉ: ―Guejti nʉr hñøjø‑nʉ́ mí tɛn car Jesús, car mi̱ngu̱ Nazaret.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nu car Pedro pé bi yojpi bi gøni, hasta bi hñi̱h ca Ocja̱, bi hñi̱na̱: ―Bí janti car Tzi Ta ji̱tzi, nim pa dí meyagö car hñøjø‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pé mí hna tzi rato, bi guati car Pedro cʉ cja̱hni cʉ már bböh pʉ, bi xijmʉ: ―Nuquiguɛ, cierto nguí yojmi quí möxte car Jesús hne̱je̱. I ni̱guitjo, gúr mi̱ngu̱ pʉ Galilea, como guí ña̱ ncja ngu̱ ga ña̱ gueguejʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Diguebbʉ ya car Pedro bi mʉdi bi zán cʉ cja̱hni cʉ́, cja̱ pé bi hñi̱h ca Ocja̱ gá testigo, bi ma̱: ―Jin dí meyagö car hñøjø‑cá̱.― Xní ma̱ ncjapʉ, xní hna majti hnar ndøxca. ");
INSERT INTO otsNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bbʉ mí dyøj ya‑cá̱, car Pedro bi mbe̱n car palabra ca xquí ma̱n car Jesús: “Ante que da mah car ndøxca, nuquiguɛ, xquí cønguigö jñu̱ vez.” Nubbʉ́, bi bøni jar goxtji, bi ndo nzoni, como mí ndo ntzøte. ");
INSERT INTO otsNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bbʉ mí tzi nxu̱ditjo, pe bi jmuntzi göhtjo cʉ möcja̱ cʉ mí mandado hne̱h cʉ tita cʉ mí mandadobi cʉ cja̱hni israelita. Bi dyøtijʉ hnar junta, bi mbe̱nijʉ ja drí sentenciajʉ car Jesús pa di bböhti. ");
INSERT INTO otsNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Diguebbʉ ya, bi du̱htibijʉ quí dyɛ car Jesús, cja̱ bi dyɛtijʉ, bú döjtijʉ car Pilato. Guegue‑cá̱ múr gobernador romano. ");
INSERT INTO otsNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Diguebbʉ ya car Judas Iscariote, bbʉ mí cca̱hti, ya xquí jma̱ di bböhti car Jesús, bi ndo ntzøte cja̱ bi ndo du̱mʉy, como guegue xquí dö. Nubbʉ, bi gʉx cʉ treinta domi gá plata cʉ xquí un cʉ möcja̱ cja̱ co cʉ tita cʉ mí pɛhtzi cargo, bi ma bú cohtzibi‑cʉ́, bi hñi̱mbijʉ: ");
INSERT INTO otsNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","―Nugö, xtú øti ca rá nttzo. ʉm nttzojquigö ca xtrí bböhti car Jesús, como guejcö xtú döquijʉ, cja̱ jin te i tu̱‑cá̱.― Nu cʉ möcja̱ ya bi da̱dijʉ: ―Jin gui mportaguigöje‑cá̱. Nuquɛ, xtí mbe̱ntsjɛ, te gui dyøti ya.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nubbʉ́, car Judas bi jiøti cʉ treinta domi gá plata pʉ jár patio car templo, cja̱ bi wem pʉ. Bi ma bú ca̱ti hnar ntja̱ji jár dyʉga, bi hna̱xitsjɛ hnar za, bi du̱. ");
INSERT INTO otsNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nu cʉ möcja̱ cʉ mí mandado bi gʉx cʉ domi‑cʉ́, bi ma̱jmʉ: ―Jin gui tzö gu ʉtijʉ ya domi‑ya jar caja gá ofrenda, porque xí ttuni pa drí bböhti hnar cja̱hni. Ncjahmʉ ʉ́r precio cár cji guegue.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cja̱ bbʉ ya xquí ña̱jʉ te di cjajpijʉ, bi döjmʉ hna pɛdazo ʉr jöy, múr mɛjti hnar dyøti‑moji. Bi döjmʉ car jöy‑cá̱ pa di hñöh pʉ cʉ hnahño cja̱hni cʉ di du̱ pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eso, hasta rá pa ya, i tsjih car jöy‑cá̱ ʉr Campo Gá Cji. ");
INSERT INTO otsNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Bi ncjapʉ gá nzʉh car palabra ca xquí ma̱n car profeta Jeremías, ya má yabbʉ. Guegue bi ma̱ ncjahua: “Bi gʉxijʉ cʉ treinta domi gá plata, bi ma bú töjmʉ hnar jöy ca múr mɛjti car dyøti‑moji. Cʉ domi‑cʉ́ xquí ttuni ca hnar hñøjø. Cʉ ddáa cja̱hni israelita xquí ma̱jmʉ tengu̱ di nccu̱hti car hñøjø‑cá̱. Cja̱ cʉ domi‑cʉ́, bi ncjajpi ncja ngu̱ xquí ma̱n ca Ocja̱, como ya xquí xijquigö te di ncjajpi‑cʉ.” Gue yʉ palabra‑yʉ́ i ju̱x pʉ jar libro ca bi dyøti car profeta Jeremías. ");
INSERT INTO otsNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Car Jesús bi ttzix pʉ jabʉ már bbʉh car gobernador romano, cja̱ bi hmöh pʉ jabʉ mír ncca̱htihui. Car gobernador‑cá̱ mí ju̱ cár tju̱ju̱ múr Pilato. Cja̱ guegue‑cá̱ bi dyön car Jesús, i̱na̱: ―Nuquɛ, ¿cja ʉ́r reyqui yʉ judio?― Cja̱ bi da̱h car Jesús: ―Guejquigö, ncja ngu̱ xcú ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ma ya, quí jefe cʉ möcja̱ cja̱ co cʉ tita cʉ mí mandadobi cʉ pé dda judio, bi jiøxjʉ car Jesús, xtrú dyøti cosa már nttzo. Nucá̱, jin te gá nda̱di. ");
INSERT INTO otsNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Diguebbʉ ya car Pilato bi dyöni: ―¿Cja jin guí øde göhtjo yʉ cosa i jøxqui‑yʉ́?― ");
INSERT INTO otsNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nu car Jesús, nde̱jma̱ jin te gá nda̱di, nim pa hnar palabra gá ma̱. Eso, bi ndo hño ʉ́r mʉy car gobernador, ¿dyoca̱ jí̱ mí mfendetsjɛ car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cʉ cja̱hni israelita mí pɛhtzi hnar costumbre, cada bbʉ nguá dyøtijʉ car mbaxcjua ca mí tsjifi ʉr Pascua, cʉ cja̱hni mí juajnijʉ hnar preso di tsjojqui, cja̱ car gobernador romano mí mandado di tsjojqui car preso‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cʉ pa‑cʉ, mí cjoti födi hnar preso ca mí ju̱ cár tju̱ju̱ múr Barrabás. Ya xquí jmentado már ndo nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cja̱ bbʉ ya xquí jmu̱ntzi cʉ cja̱hni, car Pilato bi dyönijʉ: ―¿Tema preso guí nejʉ gu xojqui? ¿Cja gue car Barrabás, cja̱ huá gue nʉr Jesús nʉ guí xijmʉ ʉr Cristo?― ");
INSERT INTO otsNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Car Pilato bi dyön cʉ cja̱hni ncjapʉ, porque mí pa̱ guegue, quí jefe cʉ judio xquí döjʉ car Jesús porque mí ʉjʉ‑cá̱. Mí ma̱ntsjɛ car gobernador, bbʉ di ttön cʉ cja̱hnitjo toca̱ mí nejʉ, guegue‑cʉ́ di dyöjpijʉ di tsjojqui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Car gobernador már ju̱di pʉ mbo car juzgado, már ju̱x car ndo silla pʉ jabʉ mí juzga cʉ cja̱hni. Cja̱ cár bbɛjña̱ bú pɛjni razón, bi hñi̱mbi: “Jin te gui ma gui cjajpi car hñøjø ca i tsjifi ʉr Jesús, porque jin te i tu̱. Má̱nxu̱y xtú wi̱gö guegue. Bbʉ te gui cjajpi‑cá̱, xta zʉhqui hnar cosa drá ndo nttzo.” ");
INSERT INTO otsNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eso, car gobernador mí jon car manera ja drí xojqui car Jesús. Nu quí jefe cʉ möcja̱ co cʉ tita cʉ mí mandadobi cʉ cja̱hni israelita bi dyɛtijʉ cʉ cja̱hnitjo pa di dyödijʉ di tsjojqui car Barrabás cja̱ di bböhti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Diguebbʉ ya, pé hnar vez car gobernador bi nzoh cʉ cja̱hni, bi dyön‑cʉ: ―¿Ja̱ ndrá ngue cʉ yojo guí nejʉ gu xojqui?― Cja̱ bi ma̱n cʉ cja̱hni: ―Gue car Barrabás.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma ya, car gobernador pé bi dyön cʉ cja̱hni: ―Nubbʉ́, ¿te gu cjajpi nʉr Jesús nʉ guí xijmʉ ʉr Cristo nʉ xpá mɛjni ca Ocja̱?― Cja̱ göhtjo cʉ cja̱hni bi ncötijʉ, bi ma̱jmʉ: ―¡Da ddøti jar ponti!― ");
INSERT INTO otsNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Diguebbʉ ya, car gobernador pé bi dyönijʉ: ―¿Ter bɛh ca̱ xí dyøti‑nʉ ca rá nttzo?― Cja̱ gueguejʉ más mí ndo majmʉ nzajqui: ―¡Da ddøti jar ponti!― ");
INSERT INTO otsNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bbʉ mí cca̱hti car Pilato, jí̱ mí ne cʉ cja̱hni di dyøjmʉ ca mí ma̱ guegue, pe ya xi mí ne di contrabi, bi mandado bú hnu̱ hnar lavamano ʉr deje, cja̱ bi xʉjqui quí dyɛ pʉ jabʉ már janti göhtjo cʉ cja̱hni. Cja̱ bi xijmʉ, bbʉ: ―Jin gu ja̱gö ʉr huɛnda bbʉ da bböhti nʉr hñøjø‑nʉ́. Nugö dí ma̱ngö, jin te i tu̱. Nuquɛjʉ, bbʉ guí nejʉ da bböhti, guehquɛjʉ, xquí tu̱xi ir nttzojquijʉ, bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cja̱ bi da̱di göhtjo cʉ cja̱hni, bi hñi̱na̱jʉ: ―¡Exque da bböhti, masque xín du pɛjnquije ca Ocja̱ cam castigoje, nugöje cja̱ co cʉm ba̱jtzije!― ");
INSERT INTO otsNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Diguebbʉ ya, car Pilato bi mandado di tjɛh car Barrabás di ma libre. Cja̱ pé bi mandado di tjʉti car Jesús co chirio. Cja̱ bbʉ ya xquí ncjajpi‑cá̱, pé bi döjti jáy dyɛ cʉ sundado pa di zixijʉ pʉ jabʉ di ddøti jar ponti. ");
INSERT INTO otsNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Diguebbʉ ya quí sundado car Pilato bi dyɛn car Jesús gá möjmʉ jár palacio car gobernador. Bi mpɛjni göhtjo car batallón cʉ sundado cja̱ bi hñi̱tijʉ madé car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nubbʉ, bi møjquibijʉ cʉ dda quí da̱jtu̱ cja̱ bi pöhtijʉ hnar pöti már ntjɛni. ");
INSERT INTO otsNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cja̱ bi mejʉ hnar corona gá hmi̱ni, bi jñu̱htzibijʉ‑cá̱, cja̱ bi göhtibijʉ hnar za jár jogui dyɛ. Bi guati cʉ sundado, bi nda̱ndiña̱jmu̱ pʉ jáy hua car Jesús. Mí øhtibijʉ ʉr burla, ncjahmʉ mí i̱htzibijʉ. Mí ma̱jmʉ: ―Nuquiguɛ, ʉ́r reyqui cʉ judio. ¡Que viva!― ");
INSERT INTO otsNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Guejtjo mí tzoxijʉ guegue, cja̱ bi jña̱mbijʉ car za már ja̱, gá ndo mɛhtibijʉ cár ña̱. ");
INSERT INTO otsNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cja̱ bbʉ mí guaj ya mí i̱mbijʉ, pé bi møjquibijʉ car pöti cja̱ bi jejtijʉ quí da̱jtu̱tsjɛjɛ. Nubbʉ, bi zixijʉ pa du tøtijʉ jar ponti. ");
INSERT INTO otsNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cja̱ bbʉ má pønijʉ pʉ jar jñini Jerusalén, bi ntjɛjʉ hnar hñøjø, múr mi̱ngu̱ car jöy Cirene, mí ju̱ cár tju̱ju̱ múr Simón. Nucá̱, bi cjajpijʉ ʉ́r ttzɛdi pa di du̱htzibi cár ponti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Diguebbʉ ya, bi zønijʉ hnar lugar ca mí tsjifi Golgota. Nʉr tju̱ju̱ Golgota i ne da ma̱, hnar ximo. ");
INSERT INTO otsNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Cja̱ bi ttun car Jesús vinagre pa di zi. Car vinagre‑cá̱ xquí hua̱ni hnar hñi̱tji pa di meno drí zö ca rá ʉ́. Car Jesús bi zödi car hñi̱tji̱, bbʉ, pe jin gá ne gá nzi. ");
INSERT INTO otsNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nubbʉ, cʉ sundado bi døti car Jesús pʉ jar ponti, cja̱ diguebbʉ ya, bi jejquibi quí da̱jtu̱, bi dyɛntzijʉ bolado pa di ba̱dijʉ toca̱ di ga̱x cada hnáa‑cʉ́. Bi ncjapʉ gá nzʉh car palabra ca xquí ma̱n ca hnar profeta. Guegue bi ma̱ ncjahua: “Cʉ cja̱hni bi jejqui yʉm da̱jtu̱, cja̱ bi dyɛntzijʉ bolado pa di fa̱di toca̱ di mɛhtzi.” ");
INSERT INTO otsNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Diguebbʉ ya cʉ sundado bi mi̱jtijʉ cerca cʉ jñu̱ ponti, mí jantitjojʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pʉ jár ña̱ car ponti pʉ jabʉ már ddøti car Jesús, bi ncuajti hnar tzi tabla, cja̱ mí ju̱x pʉ hnar letrero pa drí fa̱di ter bɛh ca̱ xquí dyøte. Car letrero mí ma̱ ncjahua: “Guejnʉ́ ʉr Jesús. ʉ́r rey yʉ judio‑nʉ́.” ");
INSERT INTO otsNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bbʉ mí ddøti car Jesús, guejtjo hne̱je̱ bi ddøti yojo be̱. Cada hnáa bi ddøti hnár ponti. Ca hnar be̱ mí ddøti hnar ponti ca mí bbʉ jár jogui dyɛ car Jesús, cja̱ ca pé hnáa ya, már bbʉh pʉ jár nccuarga dyɛ. ");
INSERT INTO otsNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cʉ cja̱hni cʉ má tjoh pʉ jabʉ már ddøtijʉ, mí tzanijʉ car Jesús, hasta mí jua̱ti quí ña̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Mí i̱mbijʉ: ―Nuquiguɛ, nguí ma̱ már nzɛhqui pa güi yøhti car templo, cja̱ jñu̱jpatjo pé güi xotzi. Cá̱h pʉ jar ponti ya pa jin gui tu̱, bbʉ cierto ʉ́r ttʉqui ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Guejtjo hne̱je̱ quí jefe cʉ möcja̱ cja̱ co cʉ maestro cʉ mí u̱jti cʉ cja̱hni cár ley car Moisés, yojmi cʉ tita cʉ mí mandadobi cʉ cja̱hni, cja̱ co cʉ fariseo, gueguejʉ bi tjojmʉ pʉ jabʉ már ddøti car Jesús, cja̱ bi dyøhtibijʉ ʉr burla. ");
INSERT INTO otsNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mí ma̱jmʉ: ―Nʉr hñøjø‑nʉ́, xí ungui í nzajqui cʉ dda cja̱hni, pe guegue ya, jin gui pa̱di ja drí untsjɛ cár nzajqui ya. Xí ma̱ntsjɛ, guegue ʉm reyjʉ, dí israelitajʉ. Da ga̱jtsjɛ ya jar ponti pa gu pa̱di̱jʉ, ¿cja cierto xpá mɛjni ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","øde, guegue‑nʉ́ xí hñi̱ti ʉ́r mʉy ca Ocja̱, cja̱ i tøhmi da mötzi, como ʉ́r Ttʉ. Nde bbʉ, xtá cca̱htijʉ ya, ¿cja cierto ca i ma̱? ¿Cja da möx ca Ocja̱ pa jin da du̱?― Ncjapʉ gá ma̱n cʉ cja̱hni‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Guejtjo hne̱je̱ cʉ be̱ cʉ már ddøte hna‑hná hnanguadi car Jesús guejti‑cʉ́ bi zan‑cá̱, bi xijmi ncjadipʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Desde car hora bbʉ mí ju̱ xadi, bi hmɛxu̱y göhtjo car jöy hasta gue bbʉ mí zʉ jñu̱ nde. ");
INSERT INTO otsNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bbʉ ya xti zʉh car hora bbʉ mí jñu̱ nde, car Jesús bi mafi nzajqui, bi ma̱ gá hebreo ya palabra ya, bi hñi̱na̱: ―Elí, Elí, ¿lama sabactani?― Ya palabra‑yá i ne da ma̱: “Nuquɛ, dí nzohqui ya, ʉm Cjá̱a̱‑quigö. ¿Dyoca̱ xcú tzoguigui ya?” ");
INSERT INTO otsNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Cʉ dda cja̱hni cʉ már bböh pʉ, bi dyøj nʉr palabra nʉ bi ma̱, pe jin gá mba̱dijʉ, ¿cja már nzoh car Tzi Ta ji̱tzi? Mí i̱na̱jʉ, pé már mahti ca ndor profeta Elías pa di hñe̱je̱, di mötzi. ");
INSERT INTO otsNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ca hnar cja̱hni bi ne̱xa ddiji, bi ma bú ja̱ hnar esponja, bi ga̱ti jar vino, cja̱ bi tu̱jti hnar tzi za pa di ña̱htibi car Jesús. Diguebbʉ ya bi cuajtibi pʉ jár ne car Jesús, cja̱ guegue‑cá̱ bi zʉhtzi. ");
INSERT INTO otsNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nu cʉ pé dda cja̱hni cʉ már bbʉh pʉ, mí ne di ccaxjʉ car hñøjø‑cá̱ pa jin di ña̱htibi vino car Jesús. Gueguejʉ bi ma̱jmʉ: ―Tøhmijʉ, gu cca̱htijʉ ¿cja du e̱h car Elías pa da xøhti hua jar ponti, pa jin da du̱?― ");
INSERT INTO otsNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nu car Jesús, pé bi mafi nzajqui, bi dö ʉ́r mʉy jáy dyɛ car Tzi Ta ji̱tzi, cja̱ bi du̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mero bbʉ mí du̱ car Jesús bi xɛ madé ca hnar cortina ca már hna̱x pʉ mbo car ndo templo. Car cortina‑cá̱ mí coti car cuarto ca más már bbʉ mbo, cja̱ nucá̱ mí tsjifi: “Pʉ Jabʉ Más Rá Ndo Nttzu̱jpi.” Bi xɛ madé car cortina‑cá̱, bú fʉh pʉ ña̱ hasta gá nga̱y. Guejtjo bi hño car hña̱mijöy, hasta bi je madé cʉ ndo me̱do, cerca pʉ jabʉ bi du̱ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mí bbʉh pʉ cʉ ddaa tzi ni̱cja̱ pʉ jabʉ mí cjöti cʉ ánima. Nucʉ́ bi hna xogui. Cja̱ rá ngu̱ cʉ ánima cʉ xquí hñe̱me̱jma̱ ca Ocja̱ bbʉ mí bbʉjtijʉ, bi nantzijʉ cja̱ bi bøm pʉ jabʉ xquí cjötijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bbʉ ya xquí jña̱ ʉ́r jña̱ car Jesús, cʉ ánima‑cʉ́ bi nantzijʉ, bi bøm pʉ jabʉ xquí cjötijʉ, bi möjmʉ gá möjmʉ jar jñi̱ni Jerusalén, bú hñojʉ pʉ. Cja̱ már ngu̱ cʉ mi̱ngu̱ Jerusalén bi cca̱hti cʉ ánima bbʉ ya xquí nantzi. ");
INSERT INTO otsNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cerca pʉ jabʉ bi ddøti car Jesús mí bböh hnar capitán, mí yojmi cʉ dda sundado. Gueguejʉ mí föjmʉ cár cuerpo car Jesús. Bbʉ mí zöjʉ car hña̱mijöy cja̱ mí cca̱htijʉ cʉ dda cosa, göhtjo cʉ bi ncja, bi ndo ntzu̱jʉ, bi hñi̱na̱jʉ: ―Ntju̱mʉy múr Ttʉ ca Ocja̱ nʉr hñøjø‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tzi yanʉ már bböh cʉ dda bbɛjña̱ rá ngu̱. Guejti‑cʉ́ már jantijʉ ja gá ndu̱ car Jesús. Xcuí dɛnijʉ car Jesús desde pʉ jar estado Galilea, mbá cjajpijʉ ʉ́r jmandado. ");
INSERT INTO otsNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Már bbʉh pʉ car María Magdalena, co car María cár me car Santiago hne̱h car José, co guejti cár me car Jacobo hne̱h car Juan. Guegue‑cá̱ múr bbɛjña̱ car Zebedeo. Cʉ jñu̱ bbɛjña̱‑cʉ́ már yojmʉ cʉ ddáa cʉ már jantijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cja̱ bbʉ ya xquí nde, bú e̱h hnar hñøjø, múr rico. Múr mi̱ngu̱ Arimatea, mí ju̱ cár tju̱ju̱ múr José. Guejti guegue xquí ntzixihui cʉ hñøjø cʉ mí tɛn car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Car José bi ma pʉ jabʉ már bbʉh car Pilato, bú öjpi ʉr tsjɛjqui pa di ma drí du̱htzibi cár cuerpo car Jesús. Cja̱ car Pilato bi uni ʉr tsjɛjqui, bi mandado di ma du ndöjti. ");
INSERT INTO otsNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Diguebbʉ ya, car José bi ma gá ngoh pʉ jabʉ már ddøti car Jesús, bi dɛjquibi cár cuerpo pʉ jar ponti, bi möxi hnar ttaxi da̱tu̱, múr ddadyotjo. ");
INSERT INTO otsNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Car José ya xquí jojqui hnár ngu̱ gá ánima. Xquí tjohti hnar ndo me̱do, xquí dyøti hnar cueva pʉ jabʉ di cjöti bbʉ xti du̱. Jí̱ bbe mí cjöti pʉ tema ánima. Bi du̱htzibi cár cuerpo car Jesús, bi göti pʉ jar cueva‑cá̱, bi pʉntzi hnar ndo do gá ngoti cár goxtji, cja̱ bi má. ");
INSERT INTO otsNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Már bbʉjti pʉ car María Magdalena, co ca pé hnar María ca múr me car Juan. Már ju̱hui pʉ, mír ncca̱htihui cár goxtji car cueva pʉ jabʉ bi cjöti cár cuerpo car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Car jiax pʉ ya‑cá̱, bbʉ mí mʉh car mbaxcjua ca mí tzu̱jpi cʉ judio, bi jmu̱ntzijʉ cʉ möcja̱ cʉ mí mandado, cja̱ co cʉ fariseo. Bú e̱jmʉ pʉ jabʉ már bbʉh car Pilato, ");
INSERT INTO otsNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cja̱ bi xijmʉ: ―Nuquɛ, tada, dí mbe̱nije ca hnar palabra mí ma̱n car jiöjte‑cá̱ bbʉ mí bbʉjtjo. Mí ma̱, bbʉ xtrí cja jñu̱jpa, pé di jña̱ ʉ́r jña̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nuya, gui mandado tzʉ du bböh car lugar pʉ jabʉ xí cjöti cár cuerpo, hasta gue bbʉ xtrí zʉ jñu̱jpa. Bbʉ ji̱na̱, pé ntoja du hna e̱h bbʉ nxu̱y quí amigo cʉ mí ntzixihui, da gʉjquibi cár cuerpo da du̱xijʉ, cja̱ da xih cʉ cja̱hni: “Cierto ya xquí du̱, pe nuya pé xí nantzi.” Cja̱ bbʉ di ncja‑cá̱, más drí ndo ngu̱jqui car ntjöti ca xí hñe̱me̱ yʉ cja̱hni, bbʉ.― Ncjapʉ gá ma̱n cʉ hñøjø‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Cja̱ car Pilato bi da̱di: ―Dí ddahquijʉ ʉr tsjɛjqui gui tzixijʉ hnar grupo cʉ sundado pa da dyohmi pʉ jar ohtzi. Gui ma gui nú̱jʉ pa da ndo hmʉy seguro car ánima, jin to da gʉjqui.― ");
INSERT INTO otsNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Diguebbʉ ya, bi ma cʉ möcja̱ cʉ mí mandado, co ni cʉ fariseo, bú cotijʉ rá zö car ojqui co hnar ndo me̱do. Cja̱ car me̱do‑cá̱, pʉ jabʉ mí nzøtihui quí nttza̱ni car cjoti, bi tjojqui pa bi ncuajti pʉ cár sello car gobernador. Cja̱ bi gojti cʉ guardia pʉ tji car cueva, pa di mödijʉ, pʉ jabʉ xquí cjöti car ánima. ");
INSERT INTO otsNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bbʉ ya xquí tjoh car pá nsabado, car jiax ya‑cá̱ múr primero ʉr pa car semana. Ndo nxu̱ditjo, bbʉ ya xi mír ni̱gui, bi ma car María Magdalena co ca pé hnar María pa du cca̱hti car lugar pʉ jabʉ xquí cjöhtibi cár cuerpo car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cja̱ bi hna hño hnar ndo hña̱mijöy, como ya xi mbá̱ ca̱h pʉ ji̱tzi hnár ángele ca Ocja̱, gá nzøh pʉ jar lugar pʉ jabʉ xquí cjöti cár cuerpo car Jesús. Car ángele bi gʉhtzi car me̱do ca xquí cjojti car goxtji, cja̱ bi mi̱h pʉ xøtze, bi jñu̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Cár jmi car ángele mí juɛtzi rá tzi zö, cja̱ cár da̱jtu̱ hne̱je̱ már tzi nttaxi ncja yʉ xicja. ");
INSERT INTO otsNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nu cʉ sundado cʉ már föh car cueva, bbʉ mí cca̱htijʉ car ángele, bi ndo ntzu̱jʉ, hasta mí jua̱jʉ. Xní fʉntzijʉ jar jöy, ncjahmʉ xquí du̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nu car ángele ya bi nzoh cʉ bbɛjña̱, bi xijmi: ―Dyo guí ntzu̱hui, porque dí pa̱di, nuquɛhui, hne̱ guá jonihui car Jesús. Guegue‑cá̱ bi du̱ jar ponti. ");
INSERT INTO otsNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pe nuya, ya jin gui bbʉjcua. Ya xí nantzi como ngu̱ gá ma̱. Bú e̱jmi ya, hne̱ guí cca̱htihui nʉr lugar nʉ jabʉ már bbɛn cár cuerpo.― Cja̱ bi guati cʉ bbɛjña̱, bbʉ, bi cca̱hti pʉ mbo car cueva. ");
INSERT INTO otsNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Diguebbʉ ya, car ángele pé bi xijmi: ―Nuya, gui mɛhui nttzɛdi, gui ma grí xijmi quí möxte cʉ mí tɛni, ya pé xí nantzi car Jesús. Ya xí hmɛto guegue, ga pa jar hñu̱ ya, rí ma pʉ Galilea. Cja̱ nuquɛjʉ, í amigoquijʉ, gui möjmʉ pʉ hne̱je̱, gui ma grí ntjɛjʉ pʉ. Guejnʉ xtá e̱jcö xtú xihquihui.― Bi ma̱ ncjapʉ car ángele. ");
INSERT INTO otsNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Diguebbʉ ya, cʉ bbɛjña̱ bi bøm pʉ jar cueva. Mí ndo dyo í mʉyhui, cja̱ mí ndo mpöjmi. Bi gʉ ʉr ddiji, bi ma guí xih quí möxte car Jesús car razón ca xquí tsjijmi. ");
INSERT INTO otsNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cja̱ bbʉ ya xi má pɛhui jar hñu̱, bi hna ntjɛjʉ car Jesús. Guegue bi zɛngua, bi xijmi: “Da möxquihui ca Ocja̱.” Nu cʉ bbɛjña̱ bi guatihui car Jesús, bi pɛntibihui quí hua, bi nda̱nehui. ");
INSERT INTO otsNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Car Jesús ya bi xijmi: ―Dyo guí ntzu̱hui, gui mɛhui ya, ma grí xih cʉm möxte cʉ i tɛngui drí möjmʉ Galilea. Nugö, ya xtrá ma pʉ, cja̱ ya xcrí ntjɛje pʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Menta má pɛhui pʉ Jerusalén cʉ bbɛjña̱, pa di xih quí möxte car Jesús nʉr razón‑nʉ́, cʉ ddáa cʉ guardia cʉ xquí möh car cueva guejtjo bi möjmʉ Jerusalén. Bi ma guí ngöxtejʉ, guí xijmʉ quí jefe cʉ möcja̱ göhtjo te xquí ncja. ");
INSERT INTO otsNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nu cʉ möcja̱, bbʉ mí dyødejʉ te xquí ncja, bi mpɛjnijʉ co cʉ tita cʉ mí pɛhtzi cár cargojʉ, cja̱ bi mbe̱nijʉ ter bɛh ca̱ di dyøtijʉ. Bi gu̱htijʉ domi rá ngu̱ cʉ sundado, cja̱ bi bbɛjpijʉ jin di ngöxtejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bi hñi̱mbijʉ: ―Bbʉ to da dyönquijʉ te xí ncja, gui xijmʉ, quí amigo car Jesús xí ma pʉ jar cueva bbʉ mí nxu̱y, xpá ngʉjquijʉ cár cuerpo guegue, bbʉ ngár a̱quɛjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Cja̱ bbʉ da dyøh car gobernador te xí ncja, nugöje xtá nzojme, pa jin da ungui ʉr cuɛ cja̱ jin da castigaquijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nubbʉ́, cʉ sundado bi jña̱ car domi bbʉ, cja̱ bi xih cʉ pé dda cja̱hni ncja ngu̱ gá tsjijmʉ. Bi tʉnguijʉ car bbɛtjri ca bi ma̱n cʉ möcja̱ cja̱ co cʉ tita cʉ mí mandado, hasta bi dyøde göhtjo cʉ cja̱hni israelita. Gue car razón‑cá̱ i ma̱jmʉ hasta rá pa ya. ");
INSERT INTO otsNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Diguebbʉ ya, quí möxte car Jesús cʉ mí tsjifi apóstole bi ma gá ma pʉ jar estado Galilea, bi zøtijʉ jar ttøø pʉ jabʉ xquí tsjijmʉ di ntjɛjʉ car Jesús. Cja̱ bú ntjɛjʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cʉ apóstole ya, bbʉ mí cca̱htijʉ car Jesús, bi nda̱ndiña̱jmu̱jʉ, cja̱ bi hñi̱htzibijʉ. Pe nde̱jma̱ mí bbʉh cʉ ddáa cʉ mí yomfe̱ni, ¿cja cierto múr Jesús‑cá̱? ");
INSERT INTO otsNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Diguebbʉ ya, car Jesús bi guati quí möxte, bi nzojmʉ, i̱na̱: ―Car Tzi Ta ji̱tzi xí ddajqui cam nttzɛdi pa gu mandado göhtjo ʉr tiempo. Gu mandado pʉ jar ji̱tzi cja̱ hne̱cua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nuya, dí cu̱hquijʉ gui pønijʉ ya, ma bú u̱jtijʉ cʉ cja̱hni, göhtjo cʉ i bbʉj nʉr mundo. Gui nzojmʉ cʉ mi̱ngu̱ göhtjo tema jöy pa da hñe̱me̱gui cja̱ da dɛn cam palabra. Cja̱ gui xixjʉ cʉ to da hñe̱me̱. Bbʉ xtí xixjʉ cʉ cja̱hni, gui nønijʉ cár tju̱ju̱ car Tzi Ta ji̱tzi, cja̱ co cam tju̱ju̱gö, ʉ́r Ttʉgui ca Ocja̱, cja̱ co cár tju̱ju̱ car Tzi Espíritu Santo, como nugöje, dí ddahquije quer cargojʉ. ");
INSERT INTO otsNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nu cʉ cja̱hni cʉ da hñe̱me̱, guejtjo gui u̱jtijʉ göhtjo ca xtú bbɛjpiquijʉ, pa da hmʉpjʉ ncja ngu̱ xtá xihquijʉ. Nuquiguɛjʉ, gu yocöjʉ göhtjo ʉr tiempo, hasta bbʉ xtrí tjej nʉr mundo, jin gu tzoquiquijʉ.― Amén. I ttzɛdi hua na̱r bbede‑ná̱.");
INSERT INTO otsNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","I fʉjcua na̱r bbede na̱ i xijquijʉ te bi dyøti car Jesucristo, cár Ttʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ya má yabbʉ ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Isaías bi jñu̱x pʉ jár libro ter bɛh ca̱ di ncja bbʉ xti hñe̱cua jar jöy cár Ttʉ ca Ocja̱. Bi ma̱ ncjahua car profeta: Bi ma̱n car Tzi Ta ji̱tzi, bi xih cár Ttʉ: “Nuya gu pɛjni hnam jmandadero da hmɛto, Da jojqui car hñu̱ pʉ jabʉ grí ma, cja̱ nuquiguɛ, xquí hmɛfa.” ");
INSERT INTO otsNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dyøjma̱jʉ, i dyo hnar cja̱hni pʉ jabʉ jin to i hña̱ni, i ndo ña̱ nzajqui, I xih cʉ pé dda cja̱hni da jojqui quí vidajʉ, como ya xpa e̱h cam Tzi Jmu̱jʉ. I nzojmʉ ncjahua, i̱na̱: “Gui jojquijʉ ya car hñu̱ pʉ jabʉ xtu e̱h ca Ocja̱, Gui cjajpijʉ drá ncjua̱ni.” Bbʉ mí ma̱n yʉ palabra‑yʉ car profeta, mí ma̱ ja di ncja car Juan. ");
INSERT INTO otsNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Cja̱ bi zʉdi como ngu̱ gá ma̱n car profeta. Car Juan mí nzoh cʉ cja̱hni, cja̱ mí xitzi. Mí dyo pʉ jabʉ jin te mí jø ngu̱. Mí xih cʉ cja̱hni di jiɛjmʉ ca rá nttzo ca mí øtijʉ cja̱ di xixtjejʉ. Nubbʉ́, car Tzi Ta ji̱tzi di perdonabijʉ ca xquí dyøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Göhtjo cʉ cja̱hni cʉ mí bbʉh pʉ jar estado Judea, co cʉ mí bbʉh pʉ jar jñi̱ni Jerusalén, mí pønijʉ, mír möjmʉ jabʉ már bbʉh car Juan. Cja̱ mí ncjua̱ntsjɛjʉ, xquí dyøtijʉ ca rá nttzo. Nu car Juan bi xix pʉ jar da̱tje Jordán. ");
INSERT INTO otsNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Cʉ da̱jtu̱ cʉ mí je car Juan, xquí ttøte digue quí xi cʉ camello, cja̱ mí ngʉti hnár ngʉti gá xifani. Mí tza tta̱xi, cja̱ mí tzijpi cár ttafi cʉ colimena cʉ mbí ca̱ pʉ jar ttøø. ");
INSERT INTO otsNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Guegue mí nzoh cʉ cja̱hni, mí xijmʉ: ―Ya xpa e̱h hnar hñøjø ca i ndo hñohui cár ttzɛdi ca Ocja̱. Más i ndo pɛhtzi cár ttzɛdi ni ndra nguejquigö. Nugö, jin dár ntzögöbbe gu cja ʉ́r muzo guegue, pa gu cjajpi jmandado. ");
INSERT INTO otsNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Dí xixquitjojʉ cor deje. Nu ca hnaa ca ba e̱je̱, du pɛnquijʉ car Espíritu Santo pa gui yojmʉ‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cja̱ bbʉ ya xquí mʉh car Juan mí nzoh cʉ cja̱hni cja̱ mí xitzi, car Jesús bi bøm pʉ jar jñi̱ni Nazaret pʉ jar estado Galilea, bi ma gá ma pʉ jabʉ már bbʉh car Juan, cja̱ nucá̱ bi xitzi jar da̱tje Jordán. ");
INSERT INTO otsNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nu car Jesús, bbʉ mí bøx pʉ jar deje, bi jianti car ji̱tzi bú xogui, cja̱ cár tzi Espíritu ca Ocja̱ bú ca̱h pʉ ncja hnar tzi paloma, bi zøh pʉ xøtze pʉ jabʉ már bbʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Cja̱ bi ni̱gui hnar jña̱ mbí ña̱ pʉ jar ji̱tzi, mí ma̱: ―Nuquiguɛ, ʉm tzi Ttʉqui, dí ma̱hqui. Guí pöjpigui nʉm tzi mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Diguebbʉ ya, cár tzi Espíritu ca Ocja̱ bi xih car Jesús mí nesta di ma hnar lugar pʉ jabʉ jin to mí hña̱ni. ");
INSERT INTO otsNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cja̱ car Jesús bi ma bú hmʉh pʉ cuarenta mpa cja̱ cuarenta xu̱y. Ddatsjɛ már bbʉh pʉ, cja̱ bú e̱h car Satanás, bi dyøhtibi prueba, mí ne di jiöti pa di dyøti tema cosa jin di tzö. Már bbʉh pʉ hne̱je̱ cʉ dda zu̱we̱ cʉ mí tzajte, cʉ mbí ca̱ jar ttøø. Nu quí ángele ca Ocja̱ bi möx car Jesús, bi cjajpi jmandado. ");
INSERT INTO otsNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Diguebbʉ ya, car Juan ca mí xix cʉ cja̱hni bi cjoti födi, cja̱ car Jesús bi wem pʉ jar lugar‑ca̱, pé bi ma gá ngoh pʉ jar estado Galilea. Mbá xih cʉ cja̱hni ja ncja ga mandado ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mí ma̱: ―Ya xí nzʉh car pa. Ya xta mʉdi xta mandado ca Ocja̱ hua jar jöy. Nuquiguɛjʉ, gui jiɛjmʉ ca rá nttzo cja̱ gui hñe̱me̱jʉ nʉr tzi jogui jña̱ nʉ dí xihquijʉ pa gui tötijʉ car nzajqui ca rí hñe̱ ji̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Diguebbʉ ya, car Jesús bi ma gá hño pʉ hnanguadi car mar, pʉ jar estado Galilea. Má dyo pʉ cja̱ bi cca̱hti yojo hñøjø cʉ mí ncjua̱da̱. Ca hnaa múr Simón, cja̱ ca pé hnaa múr Andrés. Nucʉ, már pøtihui cár hmamöyhui jar deje, como mí mamöyhui. ");
INSERT INTO otsNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Car Jesús bi xifi, i̱na̱: ―Nuquiguɛhui, gui tɛnguihui ya, gu möjö. Ncja ngu̱ guir pamöyhui, nugö gu cjahqui gui jionihui cja̱hni, cja̱ gu tzihui pa da dɛnguigö.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Cja̱ gueguehui nguetica̱ bi jiɛh cár hmamöyhui, bi möjmʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nu car Jesús pé bi tjoj nʉ rá tzi cjanʉ, pé bi cca̱hti pe yojo hñøjø cʉ mí ncjua̱da̱, car Jacobo co car Juan. Nucʉ, mí ttʉhui car Zebedeo. Gueguehui már cʉ pʉ jar barco, már yojmʉ cár tahui, már tu̱htihui quí hmamöyjʉ pʉ jabʉ xquí xɛgui. ");
INSERT INTO otsNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cja̱ car Jesús ya bi nzofo, bi xifi di dɛnihui. Diguebbʉ ya, gueguehui bi möjmʉ car Jesús. Bi zojmi cár tahui, múr Zebedeo, már ju̱hui quí mɛfi jar barco. ");
INSERT INTO otsNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Diguebbʉ ya, car Jesús co cʉ hñøjø cʉ xquí dɛnijʉ, bi zønijʉ jar jñini Capernaum. Cja̱ bi möjmʉ pʉ jár templo cʉ judio, car pa ca mí tzöyajʉ, cja̱ car Jesús bi u̱jti cʉ cja̱hni cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nu cʉ cja̱hni cʉ bi dyøde, bi ndo hño í mʉyjʉ, como car Jesús már ndo zö mír u̱jti. Mí cca̱htijʉ, guegue mí pa̱di ntjumʉy te i ma̱n cár palabra ca Ocja̱. Nu cʉ maestro cʉ mí ja̱ cár cargojʉ pa di u̱jti cʉ cja̱hni cár palabra ca Ocja̱, jin tza ntju̱mʉy mír ba̱dijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Car pa‑cá̱, már bbʉh pʉ jar templo hnar hñøjø ca mí hñohui hnár nda̱ji̱ ca Jin Gui Tzö. Car hñøjø‑ca̱, bbʉ mí jianti car Jesús, bi ndo mafi nzajqui, ");
INSERT INTO otsNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bi xifi: ―¿Te dí cjahquije, nuquɛ, Jesús, gúr mi̱ngu̱ Nazaret? ¿Cja ya xquír hñe̱je̱ gui cu̱jquije pʉ jabʉ jin gui tzö? Dí pa̱di toquiguɛ. Nuquiguɛ, gúr Cristo, xí hñi̱xqui ca Ocja̱ pa gui mandado, cja̱ xpá mɛnquiguɛ.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nu car Jesús bi huɛnti ca hnár nda̱ji̱ ca Jin Gui Tzö, bi xifi: ―¡Cohti ir ne, cja̱ gui wembi nʉr hñøjø‑nʉ!― ");
INSERT INTO otsNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Diguebbʉ ya, cár nda̱ji̱ ca Jin Gui Tzö bi dyenti car hñøjø, bi cjajpi bi ndo jua̱, bi mbʉntzi jar jöy. Nubbʉ, bi cjajpi car cja̱hni bi mafi nzajqui. Cja̱ diguebbʉ ya, bi wembi car hñøjø, bi zogui. ");
INSERT INTO otsNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Cja̱ göhtjo cʉ cja̱hni cʉ már cca̱htijʉ, bi ntzu̱jʉ, bi hño í mʉyjʉ, cja̱ bi hñöntsjɛjʉ: ―¿Ja i ncja‑nʉ? ¿Tema ddadyo palabra ba ja̱ nʉr Jesús? Guegue‑nʉ i ndo ja̱ cár cargo. I bbɛjpi quí nda̱ji ca Jin Gui Tzö, cja̱ nucʉ, i øjte.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Cja̱ bi ndo fa̱di ja ncja xquí fongui car ttzonda̱ji̱ car Jesús. Göhtjo cʉ cja̱hni cʉ mí bbʉh pʉ jar estado Galilea co hne̱h cʉ mí bbʉh cʉ pe dda lugar cerca pʉ, nguetica̱ bi dyødejʉ ter bɛh ca̱ xquí dyøti guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Diguebbʉ ya car Jesús co car Jacobo co car Juan bi bønijʉ jár templo cʉ judio. Bi ma gá möjmʉ jár ngu̱hui car Simón co car Andrés. ");
INSERT INTO otsNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cár too car Simón mí jñi̱ni, már bbɛntjo, mí ca̱xi pa. Cja̱ nguetica̱ bi tsjih car Jesús te mí cja guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nu car Jesús bi guati jabʉ már bbɛni, bi zɛtibi cár dyɛ, bi xotzi. Cja̱ nguetica̱ bi wen car pa, cja̱ bi joh car bbɛjña̱. Nubbʉ́, bi nantzi, bi jojquibi cʉ cja̱hni te bi zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Diguebbʉ ya, car nde‑cá̱, bbʉ ya xi már cʉj nʉr jiadi, cʉ cja̱hni bú tzí cʉ döhtji co cʉ cja̱hni cʉ xquí zʉh cʉ nda̱ji̱ cʉ jin gui tzö, bi guatijʉ pʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Göhtjo cʉ mi̱ngu̱ car jñi̱ni‑cá̱ bi ndʉ jár goxtji car ngu̱ pʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Cja̱ guegue bi jojqui cʉ döhtji, cja̱ bi fongui göhtjo cʉ ttzonda̱ji̱, cja̱ jí̱ mí jɛgui di ña̱jʉ, como mí meyajʉ to guegue. Már ngu̱ cʉ cja̱hni cʉ bi jojqui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Car jiax ya ca̱, car Jesús bi nantzi ndo nxu̱ditjo, bbʉ jim be mí ni̱gui. Bi bøni gá ma hnar lugar pʉ jabʉ jin to mí hña̱ni, bú tzi dé pʉ, bú nzoh ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Diguebbʉ ya, car Simón bi bøni hne̱je̱, má hñohui pe dda cja̱hni, bi ma bú jonijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cja̱ bbʉ mí dötijʉ, bi xifi: ―Ya xná jonquijʉ göhtjo cʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nu car Jesús bi xih quí möxte: ―Möj ya yʉ tzi jñi̱ni nʉ rá cjanʉ hne̱je̱, pa gu xih cʉ cja̱hni nʉr tzi jogui jña̱. Guejnʉ́ ʉm bbɛfigö‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nubbʉ́, car Jesús bi hño pʉ jar estado Galilea, bi ddatzi göhtjo cʉ tzi jñi̱ni, bi ñʉti mbo quí templo, pʉ jabʉ mí jmu̱ntzi cʉ cja̱hni, cja̱ bi u̱jti cár palabra ca Ocja̱. Cja̱ bbʉ mí ntjɛhui cja̱hni cʉ xquí zʉh cár nda̱ji̱ ca Jin Gui Tzö, bi huɛnti‑cá̱, bi fongui. ");
INSERT INTO otsNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ca hnajpa, hnar hñøjø ca mí tzöhui car jñini lepra bi guati pʉ jabʉ már bbʉh car Jesús, bi nda̱ndiña̱jmu̱, cja̱ bi xifi: ―Bbʉ guí ne gui cjagui car favor, gui joguigui tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Car Jesús bi jui̱jqui, bbʉ, bi tʉngui ʉ́r dyɛ́, bi dön car hñøjø, cja̱ bi xifi: ―Dyo ya ca̱. Gu joquiqui. Nuya, gui zö.― ");
INSERT INTO otsNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cja̱ bbʉ ya xquí ma̱ nʉr palabra‑nʉ, nguetica̱ bi zö car hñøjø. ");
INSERT INTO otsNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nu car Jesús ya bi xifi di ma nttzɛdi, bi hñi̱mbi: ");
INSERT INTO otsNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Gui ndo jña̱ ʉr huɛnda, jin gui ma gui ngöxte ter bɛh ca̱ xí ncja. Gui ma bú jon cʉ zu̱we̱ cʉ i ma̱m pʉ jar ley i nesta gui ña̱htibi ca Ocja̱, cja̱ gui tzix pʉ jabʉ i bbʉh car möcja̱, gui dö, pa da bböhti cja̱ da jña̱htibi ca Ocja̱. Guejtjo gui u̱jti car möcja̱ nir cuerpo pa da cca̱hti, ya xcú zö. Nubbʉ, pé gu coji, cja̱ da cca̱jtiqui yʉ cja̱hni, ya xí joquiqui ca Ocja̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bi ma car hñøjø, bbʉ, pe nde̱jma̱ bi ngöxte rá ngu̱, bi pura bi xih cʉ cja̱hni te xquí dyøti car Jesús. Eso, göhtjo pʉ jabʉ mí pa car Jesús, mí ndo tɛn cʉ cja̱hni, mí ndo dʉ, cja̱ car Jesús, ya jí̱ mí ne di ñʉti cʉ jñi̱ni, como jí̱ mí ne pa di ndʉ cʉ cja̱hni pʉ jabʉ mí dyo. Eso, mí tøhmitjo pʉ jabʉ jin te mí jø ngu̱, cja̱ nde̱jma̱ mbá ndo hñɛ cʉ cja̱hni, mbá jonijʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Diguebbʉ ya, bbʉ ya xquí tzi cja mpa, car Jesús pé bi ma gá ngo jar jñini Capernaum. Cja̱ bi ttøde, pé xquí zøm pʉ́r ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nubbʉ́, bi jmu̱ntzi cja̱hni rá ngu̱, bi ndʉjʉ car ngu̱, hasta ya jí̱ mí tzö to di ñʉti jar goxtji. Nu car Jesús bi u̱jti cʉ cja̱hni cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Diguebbʉ ya, bú e̱h cʉ dda cja̱hni, mbá tzíjʉ hnar döhtji, jí̱ mí tzö di hña̱ni, mbá ncjʉnijʉ gojo quí hñohui. ");
INSERT INTO otsNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nucʉ, jí̱ mí tzö di guatijʉ jabʉ már bbʉh car Jesús, como xquí ndo ndʉ cʉ cja̱hni, eso, bi xohtzijʉ hna pedazo car ña̱jcu̱, xøtze pʉ jabʉ már bbʉ guegue. Mí guadi mí xohtzijʉ ya, bi tsjöhmijʉ car döhtji, göhtjo co cár mfi̱di, gá nzøh pʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nu car Jesús, bbʉ mí cca̱hti cʉ cja̱hni‑cʉ́, bi ba̱di, mí e̱me̱bijʉ. Nubbʉ́, bi xih car döhtji ca jí̱ mí tzö di hña̱ni: ―Nuquiguɛ, ʉm ttʉqui, dí xihqui, ya xí mperdonaqui ca rá nttzo ca xcú dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Cja̱ már ju̱ pʉ cʉ dda maestro cʉ mí u̱jti cʉ cja̱hni car ley. Nucʉ́, bi dyøj nʉr palabra nʉ bi ma̱n car Jesús, cja̱ bi zohmijʉ, mí ma̱ntsjɛjʉ: ");
INSERT INTO otsNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","―¿Dyoca̱ i ma̱ ncjapʉ nʉr hñøjø‑nʉ́? Jin gui tzö nʉr palabra xí ma̱. I ne da cjatsjɛ ca Ocja̱. ¿Toca̱ i ja̱ cár cargo pa da perdonabi yʉ cja̱hni ca rá nttzo ca i øtijʉ? Ddatsjɛ ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nu car Jesús bi ba̱di ter bbɛh ca̱ már mbe̱n cʉ maestro, cja̱ bi xijmʉ: ―¿Dyoca̱ guí tzobiguijʉ mbo ir mʉyjʉ? ");
INSERT INTO otsNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nugö xí ttajqui cam ttzɛdi, eso, dí pɛhtzi derecho gu xij nʉr hñøjø nʉ jin gui tzö da hña̱ni: “Dí perdonaqui ca rá nttzo ca xcú dyøte.” Guejtjo i jñɛjtjo bbʉ gu xifi: “Bböy, gui xox quer mfi̱di, cja̱ gui hño.” ");
INSERT INTO otsNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pe xtú xij nʉr palabra nʉ xtú xifi pa gui pa̱dijʉ, cierto dí ja̱ cam cargo hua jar jöy pa gu perdonabi ca rá nttzo ca xí dyøti yʉ cja̱hni, como guejcö dúr cja̱hni xpá bbɛnqui hua jar jöy.― Diguebbʉ ya car Jesús bi nzoh car hñøjø ca jí̱ mí tzö di hña̱ni, bi hñi̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Nuquiguɛ, dí xihqui ya, bböy, gui xox quer mfi̱dí, cja̱ gui me ir ngu̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cja̱ car hñøjø ca múr döhtjijma̱ bi bbö nttzɛdi, bi xox cár mfi̱di, bi bøni. Göhtjo cʉ cja̱hni bi cca̱hti gá mbøni, már zö mír hño. Cja̱ bi hño í mʉyjʉ, bi ma̱jmʉ: ―¡Te tza rá nzɛh ca Ocja̱! ¡Jabʉ xtá nu̱jʉ hnar cosa di jñɛjmi nʉ́!― ");
INSERT INTO otsNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Diguebbʉ ya, car Jesús pe bi ma gá ma jar nengui zabi. Cja̱ bú e̱ cja̱hni rá ngu̱, bi guati jabʉ már bbʉy, cja̱ car Jesús bi u̱jti cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nubbʉ́, bi ma gá ma pé hnanguadi, bi cca̱hti hnar hñøjø, már ju̱ pʉ jabʉ már nccu̱ti cʉ contribución. Guegue mí ju̱ cár tju̱ju̱ múr Leví, múr ttʉ car Alfeo. Cja̱ car Jesús bi xifi: ―Gui tɛngui ya, gu mɛ.― Mí dyøj ya‑nʉ car Leví, bi bbö nttzɛdi, bi mɛhui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ca pe hnajpa ya, car Jesús már bbʉh pʉ jár ngu̱ car Leví, már ju̱ pʉ jar mexa yojmi quí möxte, már tzijʉ. Guejtjo már ju̱hui guegue rá ngu̱ cʉ jiöjte cja̱hni cʉ mí cobra cʉ contribución, co pe dda cja̱hni cʉ mí ndu̱jpite, como göhtjo tema cja̱hni mí tɛn car Jesús, már ndo ngu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nu cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley, co cʉ dda fariseo, bi cca̱htijʉ car Jesús már tzihui cʉ cja̱hni cʉ mí cobra cʉ contribución, hne̱h cʉ pe dda cja̱hni cʉ mí ndu̱jpite. Gueguejʉ bi dyön quí möxte car Jesús, bi hñi̱na̱jʉ: ―¿Dyoca̱ i tzihui yʉ ttzocja̱hni nir maestrojʉ? Yʉ to i tzihui, jiöjte cja̱hni‑yʉ́, co yʉ pe dda yʉ i ndu̱jpite.― ");
INSERT INTO otsNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bi dyøj nʉr palabra‑nʉ́ car Jesús cja̱ bi da̱di: ―Cʉ cja̱hni cʉ jin te i cja, jin gui nesta médico. Nu yʉ i jñi̱ni, i nesta medico‑yʉ́. Nugö, jí̱ xtá ejcö pa gua nzoj yʉ cja̱hni yʉ i ma̱, jin te i tu̱. Xtá e̱je̱ pa gu nzoj yʉ cja̱hni yʉ i pa̱di xí dyøti ca rá nttzo. Dí ne gu föx‑yʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ca hnajpa, quí möxte car Juan cʉ mí u̱jti guegue co guejti cʉ cja̱hni cʉ mí tɛnijʉ cʉ fariseo már ayunajʉ. Cja̱ bú e̱h cʉ dda cja̱hni pʉ jabʉ már bbʉh car Jesús, bi ma̱jmʉ: ―Rá pa ya i ayunajʉ quí möxte car Juan, co hne̱h cʉ i tɛn cʉ fariseo. Xi yir möxteguɛ, ¿dyoca̱ jin gui ayunajʉ hne̱je̱?― ");
INSERT INTO otsNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nu car Jesús bi da̱h bbʉ: ―Bbʉ i cja ntja̱jti, ¿cja i ayunajʉ cʉ cja̱hni cʉ i tzöjʉ car mbaxcjua? Ji̱na̱. Menta i bbʉjti pʉ car novio cja̱ i cjadi car mbaxcjua, jin gui tzö da ayunajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hasta bbʉ ya xtrú ma car novio, nubbʉ da jogui da ayuna yʉ cja̱hni. Ya xpa e̱h car pa bbʉ jin da ddöjqui hua. Nubbʉ, da ayuna yʉm amigo yʉ i tɛngui. Pe jin gui jogui da ayuna yʉ pa ya. ");
INSERT INTO otsNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ncjadipʉ hne̱je̱, jí̱ rí ntzöhui gui ca̱h hnar zɛda̱tu̱, grí pøhtibi hna pedazo ʉr ddadyo da̱tu̱. Bbʉ gui cjajpi‑ca̱, da ngu̱jqui ca xí xɛh car zɛda̱tu̱, hnanguadi pʉ jabʉ xí bbøhte. ");
INSERT INTO otsNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Guejtjo jí̱ rí ntzöhui gui ca̱h hnar zɛxfani, grí xiti cár jugo cʉ uva pa da ixqui pʉ. Bbʉ gui dyøti‑ca̱, cár jña̱ car vino da xɛjqui cʉ zɛxfani, cja̱ guejtjo da mfön car vino. Göhtjo da bbɛdi, bbʉ. Nesta gui jioni xifani rá zö pa gui xiti cár jugo cʉ uva.― Yʉ palabra yʉ bi ma̱n car Jesús, bi jɛqui cʉ costumbre cʉ mí tɛn cʉ judio co hnar zɛda̱tu̱ o hnar zɛxfani. Nu cʉ palabra cʉ mí ma̱ guegue, bi jɛqui hnar cosa ddadyotjo cja̱ rá nzɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ca hnajpa, car Jesús má dyohui quí möxte, má tjojmʉ já jua̱ttɛy. Múr pa ca mí tzöya cʉ judio, cja̱ bbʉ má dyojʉ, quí möxte bi mʉdi bi dʉjqui ña̱ttɛy pa di zajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nu cʉ fariseo bi cca̱htijʉ ya, cja̱ bi xijmʉ car Jesús: ―¿Dyoca̱ i ta̱mi ttɛy yir möxte? Jin gui tzö nʉ i øtijʉ na̱r pa na̱ dí tzöyajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nu car Jesús bi da̱di: ―Jin gui nttzo ca i øtijʉ, como i nesta da zijʉ. Nuquɛjʉ, ¿cja jin guí cca̱htiguɛjʉ te i ma̱m pʉ jar Escritura? ¿Cja jin guí pa̱dijʉ ter bɛh ca̱ bi dyøti car David bbʉ mí tu̱ntju̱, guegue co hne̱h cʉ hñøjø cʉ mí hñohui, bbʉ jin te mí pɛhtzi pa di zijʉ? ");
INSERT INTO otsNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cʉ pa‑cʉ, mí mandado car da̱möcja̱ Abiatar, cja̱ car David bi ñʉti pʉ jár ngu̱ ca Ocja̱, bi gʉx cʉ tju̱jme̱ már nttzu̱ni, cʉ xquí jña̱htibi ca Ocja̱, bi zi, cja̱ guejtjo bi un cʉ cja̱hni cʉ mí hñohui. Nu cʉ tju̱jme̱‑cʉ, jin gui tjɛgui to da zi, jøndi cʉ möcja̱.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cja̱ pé bi ma̱ guegue: ―Ca Ocja̱ bi dyøti na̱r pa na̱ dí tzöyajʉ pa da hmʉy rá zö yʉ cja̱hni. Jin gá dyøti na̱r pa gá nttzöya jøntjo pa di mandadobi yʉ cja̱hni da zu̱jpijʉ na̱r pa. ");
INSERT INTO otsNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy, eso dí pɛhtzigö derecho gu mandado te da ttøti na̱r pa na̱ rá nttzu̱jpi.― ");
INSERT INTO otsNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Car Jesús pé bi guati pʉ hnár templo cʉ judio, pʉ jabʉ mí jmu̱ntzi cʉ cja̱hnitjo. Már bbʉh pʉ hnar hñøjø, xquí dyoti ca hnár dyɛ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Cja̱ már bbʉh pʉ hne̱je̱ cʉ dda fariseo, már a̱xjʉ car Jesús, pa drí ba̱dijʉ, ¿cja di jojqui döhtji car pa ca mí tzöyajʉ? Como mí joni te di jiøxjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nu car Jesús bi nzoh car hñøjø ca xquí dyoti ca hnár dyɛ, bi hñi̱mbi: ―Gui bböj ya, gui hmöh madé.― ");
INSERT INTO otsNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Diguebbʉ ya, guegue bi dyön cʉ fariseo cʉ már bbʉh pʉ: ―¿Ter bɛh ca̱ i tjɛguijʉ gu øtijʉ nʉr pa gá nttzöya? ¿Cja i tjɛguijʉ gu föxjʉ hnar cja̱hni? ¿Cja huá más bí jogui gu øhtibijʉ ca rá nttzo, jin gu föxijʉ? ¿Cja da jogui gu ta̱pijʉ cár vida, cja huá gu jɛguijʉ da du̱?― Nu cʉ fariseo, jin te gá nda̱dijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Diguebbʉ ya, car Jesús bi cca̱hti, nde̱jma̱ jí̱ mí ne cʉ fariseo di jiɛ guegue di möx car hñøjø‑ca̱, como jin te mí pɛhtzijʉ tti̱jqui. Eso, bi zøti ʉ́r mʉy cja̱ bi ungui ʉr dumʉy. Diguebbʉ ya bi xih car hñøjø: ―Tʉngui quer dyɛ.― Cja̱ car hñøjø bi tʉngui cár dyɛ, cja̱ bi hna jogui. ");
INSERT INTO otsNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bbʉ mí cca̱htijʉ‑ca̱, cʉ fariseo bi bønijʉ, bi ma bú ña̱hui cʉ dda cja̱hni cʉ mí tsjifi herodista, pa di mföxjʉ di möhtijʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nu car Jesús bi mɛhui quí möxte, bi ma gá ma jár nttza̱ni car mar Galilea, cja̱ bi dɛni hnar ndo jmundo cʉ cja̱hni, xcuí hñe̱jmʉ cʉ tzi jñi̱ni pʉ jar estado‑cá̱, cerca pʉ jar mar. ");
INSERT INTO otsNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cja̱ bbʉ mí dyødejʉ, mí ndo øti milagro car Jesús, bú hñɛ cja̱hni rá ngu̱, bú e̱jmʉ pʉ Judea, co pʉ Jerusalén, co pʉ Idumea. Bú e̱jmʉ nʉ rí ncjanʉ car da̱tje Jordán, co pʉ jabʉ rá bbʉh cʉ jñi̱ni Tiro co Sidón. Mbá e̱jmʉ göhtjo cʉ lugar‑cʉ, mí jonijʉ car Jesús, cja̱ bi ndo ndʉjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nu car Jesús bi xih quí möxte di mɛhtzi listo hnar tzi barco pʉ jabʉ di ñʉti guegue, pa jin di dʉhti cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Car Jesús xquí jojqui döhtji rá ngu̱, eso bú hñɛ cʉ cja̱hni cʉ mí tzöjʉ göhtjo tema jñi̱ni, mí ne di guatijʉ car Jesús cja̱ di dönijʉ, pa di ccʉhtzibijʉ ca mí tzöjʉ. Cja̱ bi ndo dʉhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nu cʉ cja̱hni cʉ xquí zʉh quí nda̱ji̱ ca Jin Gui Tzö, bbʉ mí cca̱htijʉ car Jesús, cʉ ttzonda̱ji̱ mí cjajpi‑cʉ́ mí nda̱ndiña̱jmu̱jʉ pʉ jabʉ már bbʉ guegue, cja̱ mí majmʉ nzajqui, mí i̱na̱jʉ: ―Nuquiguɛ, ʉ́r Ttʉqui ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nu car Jesús mí ccahtzi nttzɛdi cʉ ttzonda̱ji̱ pa jin di göx cʉ cja̱hni to guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Diguebbʉ ya car Jesús bi bøx pʉ jar ttøø, mí ddatsjɛ. Cja̱ bbʉ mbú ca̱y, nubbʉ́, bi nzoh cʉ hñøjø cʉ mí ne di hñi̱tzi gá möxte, cja̱ nucʉ́, bi guatijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Digue cʉ cja̱hni rá ngu̱ cʉ mí tɛni, car Jesús bi juajni doce, bi hñi̱x‑cʉ pa di u̱jti cár palabra ca Ocja̱, cja̱ pa di gu̱y, di má drí xih cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Car Jesús guejtjo bi un quí möxte cár cargojʉ pa di jojqui döhtji cja̱ pa di fongui quí nda̱ji̱ ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gue ya doce hñøjø‑ya bi juajni car Jesús cja̱ bi un cár cargojʉ: Bi juajni car Simón, cja̱ pé bi jñu̱htibi pé hnar tju̱ju̱, múr Pedro. ");
INSERT INTO otsNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Guejtjo bi juajni car Jacobo ca múr ttʉ car Zebedeo, co car Juan ca múr cjua̱da̱ car Jacobo. Yʉ yojo‑yʉ, car Jesús pé bi jñu̱htibi cár tju̱ju̱hui, múr Boanerges. Nʉr tju̱ju̱‑nʉ i ne da ma̱, már ndo nzɛh quí jña̱hui, ncja ngu̱ bbʉ i ñʉntzi. ");
INSERT INTO otsNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Guejtjo bi juajni car Andrés, car Felipe, car Bartolomé, car Mateo, car Tomás, car Jacobo ca múr ttʉ car Alfeo, car Tadeo, cja̱ co car Simón ca mí tɛn cʉ cja̱hni cʉ mí tsjifi cananista. ");
INSERT INTO otsNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Guejtjo bi juajni car Judas Iscariote ca bi dö guegue. Car Jesús bi hñi̱x yʉ doce hñøjø‑yʉ gá möxte, cja̱ bi un cár cargojʉ. Diguebbʉ ya, car Jesús pé bú e̱h pʉ jar jñi̱ni Capernaum. Mí yojmi quí möxte, cja̱ bi ñʉtijʉ jar ngu̱ pʉ jabʉ mí cuatijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cja̱ pé bi guati cja̱hni rá ndo ngu̱, pé bi ndʉjʉ. Göhtjo ʉr pa mí dʉjʉ jar ngu̱, nim pa mí unijʉ tiempo gueguejʉ di zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma ya, bi dyøh cár familia car Jesús, ya xquí zøm pʉ jar ngu̱ pʉ jabʉ mí cuati. Nubbʉ́, bú e̱jmʉ pa di zixjʉ. Como mí ma̱n cár familia car Jesús, guegue‑ca̱ xquí bbɛh cár mʉy, xquí nloco. ");
INSERT INTO otsNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Cja̱ már bbʉh pʉ Capernaum cʉ dda maestro cʉ mí u̱jti cʉ cja̱hni car ley. Xcuí hñe̱jmʉ Jerusalén, cja̱ mí ma̱jmʉ: ―Nʉr hñøjø nʉ i tsjifi ʉr Jesús, xí nzʉh cár jefe cʉ nda̱ji̱ jin gui jo, gue car Beelzebú. Guegue‑ca̱ i mandadobi cʉ pe dda nda̱ji̱ cʉ jin gui jo, cja̱ xí un nʉr Jesús cár ttzɛdi pa da fongui‑cʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nu car Jesús bi dyøj nʉr palabra nʉ mí ma̱n cʉ maestro‑cʉ. Bi nzojmʉ cja̱ bi xijmʉ, jí̱ mí tzö ca mí mbe̱nijʉ. Bi nzofo gá bbede, bi xijmʉ ncjahua: ―¿Cja guí i̱na̱jʉ, car Satanás da ne da fongui cʉ pé dda nda̱ji̱ cʉ i mandadobi? Jin da ne. ");
INSERT INTO otsNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bbʉ i bbʉh hnár gobierno hnar jñi̱ni, cja̱ göhtjo cʉ cja̱hni pʉ da ntu̱jnihui car gobierno, jin da dé car gobierno‑ca̱. Da mfongui. ");
INSERT INTO otsNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Guejtjo hne̱je̱, bbʉ i bbʉh hnar familia ca i ntu̱jnitsjɛjʉ, ¿cja da jogui da ntzixijʉ car familia‑cá̱? ¿Cja jin da mfonti? ");
INSERT INTO otsNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ncjapʉ hne̱je̱ car Satanás, bbʉ di fongui quí hñohui cʉ i øhtibi quí jmandado, ¿cja jin di mpun cár cargo, bbʉ? Nguetica̱ di tjegue. ");
INSERT INTO otsNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Bbʉ i bbʉh hnar hñøjø rá nzɛdi, ¿toca̱ da ñʉti pʉ jár ngu̱ pa da gʉjquibi quí mɛjti? Jøntsjɛtjo bbʉ di bbʉ pé hnaa más drá nzɛdi, guegue‑ca̱ bbɛto da da̱pi car mi̱ngu̱, da du̱htibi quí dyɛ, cja̱ diguebbʉ ya da jogui da gʉjquibi quí mɛjti. ");
INSERT INTO otsNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Gui dyøjma̱jʉ na̱r palabra na̱ dí xihquijʉ ya: I bbʉh car manera pa da mperdonabi yʉ cja̱hni göhtjo cʉ cosa rá nttzo cʉ i øtijʉ, cja̱ co cʉ palabra rá nttzo cʉ i ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nu yʉ cja̱hni yʉ i cca̱htijʉ yʉ cosa rá zö yʉ dí øte por digue car Espíritu Santo, cja̱ i ma̱jmʉ, gue ca Jin Gui Jo i øti‑yʉ, jin gui tzö da mperdonabi yʉ cja̱hni‑yʉ. Nuyʉ́, ncjahmʉ xí xijmʉ ca Ocja̱, guegue Jin Gui Jo. Da du̱u̱dijʉ ca rá nttzo ca xí dyøtijʉ, göhtjo ʉr tiempo, nim pa jabʉ da bøm pʉ jár castigojʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bi ma̱ ncjapʉ car Jesús, porque mí ma̱n cʉ dda maestro: “Nʉr Jesús i yojmi cár nda̱ji̱ ca Jin Gui Jo. Guehca̱ i föx‑cá̱.” ");
INSERT INTO otsNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Diguebbʉ ya, bú e̱h quí cjua̱da̱ car Jesús co cár me pʉ jabʉ már bbʉ guegue. Bi hmöjtijʉ pʉ tji car ngu̱, bi nzojnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nu car Jesús már ju̱ pʉ mbo car ngu̱, cja̱ mí i̱tijʉ madé cʉ cja̱hni cʉ már u̱jti. Cja̱ bi tsjih car Jesús: ―Tji nir me cja̱ co yir cjua̱da̱ bí nzohqui hua tji.― ");
INSERT INTO otsNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nu car Jesús bi da̱di: ―¿Cja guí pa̱dijʉ to cʉ dí xifi ʉm megö o ʉm cjua̱da̱gö?― ");
INSERT INTO otsNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bbʉ mí ma̱ nʉr nttöni‑nʉ, car Jesús bi cca̱hti cʉ cja̱hni cʉ már ju̱ pʉ jár ngu̱, cja̱ pé bi xijmʉ: ―Cca̱htijma̱jʉ nʉm megö co yʉm cjua̱da̱gö. ");
INSERT INTO otsNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yʉ cja̱hni yʉ i øti ca i ne ca Ocja̱, ncjahmʉ ʉm cjua̱da̱gö‑yʉ, ncjahmʉ ʉm ncju̱gö‑yʉ, ncjahmʉ ʉm megö‑nʉ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ca pe hnar pa, car Jesús már bbʉh pʉ jár nttza̱ni car mar, pé már u̱jti cʉ cja̱hni. Bi ndo jmuntzi cja̱hni rá ngu̱. Como mí ndo dʉjʉ, car Jesús bi ñʉti hnar tzi barco ca mí o pʉ jár nttza̱ni car deje, nu cʉ cja̱hni rá ngu̱ bi gojti pʉ jár nengui car mar, bi hmöjtijʉ jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Diguebbʉ ya, car Jesús bi mʉdi bi u̱jti cʉ cja̱hni cár palabra ca Ocja̱. Bi xijmʉ ejemplo rá ngu̱. Ncjapʉ gá nzofo. Bi xih cʉ cja̱hni: ");
INSERT INTO otsNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Gui dyødejʉ nʉr bbede‑nʉ: Mí bbʉh hnar hñøjø, bi bøni bi mongui ttɛy. ");
INSERT INTO otsNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cʉ dda ttɛy cʉ bi moni bi jiøh pʉ hnanguadi car hñu̱. Bú e̱h cʉ ttzʉntzʉ, bi za cʉ ttɛy‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Cʉ pe dda ttɛy ya, bi jiøh pʉ jabʉ jin te mí bbon car jöy. Bi jiøh pʉ jabʉ mí bbʉh cʉ ndo me̱do már nxi̱di. Cja̱ nguetica̱ bi bøx cʉ ttɛy‑cʉ́, como mí u̱jtjo jabʉ már je̱ car jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bbʉ mí bøx car jiadi, bi za̱ti cʉ ttɛy‑cʉ́, bi dyoti, como mí u̱jtjo quí dyʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Cja̱ cʉ pe dda ttɛy ya, bi jiøh pʉ jabʉ mí bbon quí ndö cʉ hmini. Bi te cʉ hmi̱ni bi gohmi cʉ ttɛy, ya jin te gá ñʉ cʉ ttɛy. ");
INSERT INTO otsNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Cja̱ cʉ pe dda ttɛy ya, bi jiøh pʉ jar jogui jöy. Bi bøtze, bi te, bi ñʉ rá zö cʉ ttɛy‑cʉ́. Cʉ ddaa bi ndu̱ treinta tzi ttɛy cada hnar tzi ña̱ttɛy, cja̱ pe ddaa bi ndu̱ sesenta tzi ttɛy cada hnar tzi ña̱ttɛy, cja̱ cʉ pé dda ttɛy ya, bi ndu̱ hasta hna ciento tzi ttɛy cada hnar tzi ña̱ttɛy.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bi guadi bi ma̱n nʉr bbede‑nʉ́ car Jesús, cja̱ pé bi xih cʉ cja̱hni: ―Yʉ to i bbʉj yí gu̱, da dyøde te i ne da ma̱ nʉr bbede‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cja̱ bbʉ ya xquí wen cʉ cja̱hni rá ngu̱, cʉ tengu̱di cʉ xquí døhmi, már bbʉbi car Jesús cja̱ co cʉ doce hñøjø cʉ mí ntzixihui, cja̱ gueguejʉ bi dyönijʉ car Jesús, te mí ne di ma̱n car bbede digue cʉ ttɛy cʉ bi bboni. ");
INSERT INTO otsNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Cja̱ bi da̱h car Jesús: ―Nuquɛjʉ, xí ttahquijʉ ʉr tsjɛjqui gui pa̱dijʉ ja ncja ga mandado ca Ocja̱, como guehquɛjʉ xí juanquijʉ ca Ocja̱ pa da ttu̱jtiquijʉ ja i ncja. Nu cʉ pe dda cja̱hni, jin gui ttungui ʉr tsjɛjqui da ntiendejʉ ja ncja ga mandado guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Gueguejʉ, macja̱ i cca̱hti yʉ dí øte, pe jin gui ja̱jʉ ʉr huɛnda ja i ncja. I øj yʉ palabra yʉ dí ma̱, pe jin gui øjmʉ te i ne da ma̱. Cʉ cja̱hni‑cʉ́, dí nzofo gá bbede, pa jin da pöti quí mfe̱nijʉ. Bbʉ di pöti quí mfe̱nijʉ cja̱ di jiɛjmʉ ca rá nttzo, nubbʉ́ ca Ocja̱ di perdonabijʉ ca rá nttzo ca xí dyøtijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cja̱ car Jesús pé bi xih quí möxte: ―¿Cja jin guí pa̱jmʉ te i ne da ma̱ nʉr bbede‑nʉ́? Bbʉ ji̱na̱, ¿ja grí pa̱jmʉ te i ma̱ göhtjo cʉ dda bbede, bbʉ́? ");
INSERT INTO otsNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nʉ́r bbede cʉ ttɛy, car monttɛy i jñɛjmi car cja̱hni ca i xih quí mi̱nga̱‑cja̱hnijʉ nʉ́r palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nu cʉ ttɛy cʉ bi jiøh pʉ hnanguadi car hñu̱, gue cʉ cja̱hni cʉ xí dyødejʉ cár palabra ca Ocja̱, pe jí̱ xcá ntiendejʉ ja i ncja. Nucʉ́, bbʉ ya xí dyødejʉ, nguetica̱ bú e̱h car Satanás, hne̱ bi jña̱htzibi car palabra ca xí dyødejʉ, ya jin gui mbe̱nijʉ ja i ncja. ");
INSERT INTO otsNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nu cʉ ttɛy cʉ bi jiøh pʉ jabʉ már bbon cʉ ndo me̱do, gue cʉ cja̱hni cʉ bi dyøh cár palabra ca Ocja̱, cja̱ bi mpöjmʉ, bi cuajtijʉ nttzɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cʉ cja̱hni‑cʉ́, i jñɛjmi cʉ ttɛy cʉ jin te i bbʉh quí dyʉ. Chi tchtjo ga déjʉ, pe diguebbʉ ya, bbʉ xta ʉjʉ yʉ pe dda cja̱hni, o bbʉ xta ttøhtibi tujni por rá ngue cár palabra ca Ocja̱, nguetica̱ da dyʉxi ʉ́r mʉyjʉ. Ya jin da ne da dɛnijʉ bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nu cʉ ttɛy cʉ bi jiøh pʉ jabʉ mí cja quí ndö cʉ hmi̱ni̱, gue cʉ cja̱hni cʉ i øh cár palabra ca Ocja̱, ");
INSERT INTO otsNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pe rí ma ʉ́r mʉyjʉ nʉr vida hua jar jöy co cʉ cosa rá ngu̱ cʉ i jonijʉ. I mbe̱nijʉ, bbʉ di cjajʉ rico, di mpöjmʉ, bbʉ; eso, i ungui ʉ́r mʉyjʉ pa da ngu̱jqui ca te i pɛhtzijʉ. Cʉ cja̱hni‑cʉ, jin tza i cjajpi ngüɛnda cár palabra ca Ocja̱. Gue cʉ pe dda cosa hua jar jöy i ndo nejʉ. Eso, car palabra ca xí dyødejʉ i coji ncja ngu̱ hnar huattɛy ca jin te i cʉ́ semilla. Xí te cʉ hmi̱ni̱, xí ngohmi cʉ ttɛy. Jin te xcá joh‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nu cʉ ttɛy cʉ bi bbom pʉ jar jogui jöy, gue cʉ cja̱hni cʉ i øh cár palabra ca Ocja̱ cja̱ i e̱me̱ göhtjo mbo ʉ́r mʉy. Cʉ cja̱hni‑cʉ, jin gui jɛjmʉ cár palabra, cja̱ i øtijʉ ncja ngu̱ ga ma̱. I jñɛjmi cʉ ña̱ttɛy cʉ i tu̱ rá ngu̱ semilla. Cʉ ddaa i tu̱ treinta tzi ttɛy cada hnar ña̱ttɛy. Cʉ ddaa i tu̱ sesenta tzi ttɛy cada hnaa, cja̱ cʉ pé ddaa i tu̱ hasta cien tzi ttɛy cada hnaa.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Diguebbʉ ya car Jesús pé bi xih quí möxte: ―¿Te i cjajpi yʉ cja̱hni hnar lámpara? ¿Cja i tjɛ pa da göti pʉ mbo hnar cajón o gue pʉ jöy car gama? Ji̱na̱, i tti̱x pʉ ña̱ pʉ jabʉ da yoti göhtjo nʉr ngu̱. Ncjapʉ hne̱je̱ yʉm palabra yʉ dí xihquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yʉ pa yá, tzi yotjo yʉ cja̱hni i pa̱di te i ne da ma̱, pe ba e̱h car pa bbʉ xta tsjifi göhtjo yʉ cja̱hni. Nugö xtú xihquijʉ gá bbede, pa jí̱ bbe da fa̱di te i ne da ma̱, hasta bbʉ xtu e̱h car pa bbʉ xtrí ntzöhui da fa̱di. ");
INSERT INTO otsNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yʉ to i bbʉj yí gu̱, da dyøde te i ne da ma̱n yʉ palabra‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Car Jesús guejtjo bi xih quí möxte: ―Nuquɛjʉ, ya xquí tzi ødejʉ. Gui jñu̱hpijʉ ndu̱mʉy yʉ palabra yʉ dí xihquijʉ. Bbʉ gui dyɛmbi ir mʉyjʉ pa gui pa̱dijʉ ja i ncja, da möxquijʉ ca Ocja̱, pa más drá zö gui pa̱dijʉ, cja̱ pé da ddahquijʉ jogui mfe̱ni pa gui pa̱dijʉ más drá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nʉr cja̱hni nʉ i ju̱hpi ndu̱mʉy ca tengu̱ ca ya xqui pa̱di, da ba̱di más drá ngu̱. Nu car cja̱hni ca jin te i cjajpi ca chi tchʉtjo ca ya xí dyøde, da da̱be̱nitjo, ya jin da ba̱di ni digue‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Car Jesús pé bi xih quí möxte: ―Gu xihquijʉ pé hnar bbede pa gui pa̱dijʉ ja ncja ga ni̱gui cár jmandado ca Ocja̱ hua jar jöy. I ngu̱jqui ncja ngu̱ ga te car semilla ca i tu̱h hnar hñøjø pʉ jár jua̱ji̱. ");
INSERT INTO otsNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bbʉ ya xí tu̱ju̱, diguebbʉ ya car hñøjø i pa ʉ́r ngu̱, i jɛjti car semilla tengu̱ mpa. Cada bbʉ nxuy ga dyoy, cja̱ cada bbʉ nxudi ga nantzi. I tøhmi hasta bbʉ ya xí føx car semilla. Nu car hñøjø jin gui pa̱di ja ncja xcá føtze. ");
INSERT INTO otsNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Guejtsjɛ nʉr jöy i cjajpi i føx car semilla. Hnajpa ngu̱ hnajpa ga té car planta. Bbɛto i føx nʉr tzi tja̱. Diguebbʉ ya i te, cja̱ i xoti car da̱nxi. Ma ya da ncja car ma̱nxja, cja̱ da nojqui car semilla. ");
INSERT INTO otsNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cja̱ bbʉ ya xí me̱h cʉ tja̱, nubbʉ́ da bøn yʉ cja̱hni du xofo, como ya xí nzøh car pá bbʉ xta tsjongui. Da ncjapʉ hne̱je̱ da ni̱gui ja ncja ga mandado ca Ocja̱ hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cja̱ car Jesús pé bi ma̱ pé hnar bbede, bi xih quí möxte: ―Pé gu ddahquijʉ hnar ejemplo pa gui pa̱dijʉ ja ncja drí ngu̱jqui cár jmandado ca Ocja̱ hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I ncjá ncja ngu̱ hnár ndö ʉr murtaza ca i bboni jar jöy. Car tzi ndö‑cá̱, nttzɛditjo chi tchʉ. Más chi tchʉ ni ndra ngue cʉ pe dda semilla cʉ i bboni. ");
INSERT INTO otsNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pe bbʉ ya xí bboni, i føtze, i te rá nte. I ta̱pi göhtjo cʉ dda ccani cʉ i jø jar jua̱ji̱. I pøh quí dyɛ, i majqui, eso ba e̱h cʉ tzi ttzʉntzʉ, i tzöya pʉ jár xu̱mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Cja̱ car Jesús bi segue bi u̱jti cʉ cja̱hni gá bbede. Mí xijmʉ pé dda bbede cʉ mí jñɛjmi‑yʉ́. Ddahtzʉ nguá u̱jti, hasta pʉ jabʉ mí cca̱hti, ya jin di ntiende cʉ cja̱hni bbʉ pé di xijmʉ pé ddaa. ");
INSERT INTO otsNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Göhtjo ca te mí u̱jti cʉ cja̱hni rá ngu̱, bi xifi gá bbede. Jin gá nzojtjo. Nu quí möxte, car Jesús bi nzoh‑cʉ́, bi xifi göhtjo ja mí ncja. ");
INSERT INTO otsNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Guejti car pa‑cá̱, bbʉ ya xquí nde, car Jesús bi xih quí möxte: ―Möjö, grá ddaxjʉ nʉ pé hnanguadi nʉr mar.― ");
INSERT INTO otsNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Diguebbʉ ya, quí möxte car Jesús bi hñi̱h cʉ cja̱hni rá ngu̱ cʉ xquí dɛni cja̱ bi ñʉtijʉ jar barco pʉ jabʉ már ju̱ car Jesús. Pé már bbʉh pʉ pé dda tzi barcotjo. Cja̱ bi möjmʉ bbʉ́, bi hño car barco jar deje. ");
INSERT INTO otsNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Diguebbʉ ya bi mʉdi bi hño hnar ndo nda̱ji̱. Mí ndo ɛn car deje, már ndo nte, hasta mí mföhtzi pʉ mbo car barco. Ya xti ñu̱tzi, di cjajpi di ñʉy. ");
INSERT INTO otsNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nu car Jesús má a̱h pʉ jár xicji car barco, xquí göx cár ña̱ hnar ntju̱xiña̱. Quí amigo bi dyöjʉ cja̱ bi xijmʉ: ―¡Tzö ya, maestro! ¿Cja jin guí cja ndumʉy gu cja̱tije deje?― ");
INSERT INTO otsNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mí dyøj ya‑cá̱, car Jesús bi nantzi, bi huɛhti car nda̱ji̱ cja̱ bi xih car deje: ―¡Jui̱gui̱, dyo guí hñá̱ni!― Cja̱ bi hna tzöya car nda̱ji̱, bbʉ́. Bi jui̱ nttzɛdi car nda̱ji̱ co car deje. ");
INSERT INTO otsNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Diguebbʉ ya, car Jesús bi xih quí möxte: ―¿Dyoca̱ guí ndo ntzu̱jʉ? ¿Dyoca̱ jin guí e̱me̱guijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Gueguejʉ ya, bi ntzu̱jʉ rá ngu̱, cja̱ bi hño quí mfe̱nijʉ, bi ma̱jmʉ: ―¿To na̱r hñøjø‑ná̱? ¡Nttzɛditjo rá nzɛdi! Hasta nʉr nda̱ji̱ co nʉr deje xí hñe̱me̱bi ca xí ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cja̱ diguebbʉ ya, bbʉ ya xquí ddaxjʉ car mar, car Jesús co quí möxte cʉ mí ntzixihui bi zøtijʉ ca pé hnar lado, pʉ jar jöy ca mí tsjifi Gadara. ");
INSERT INTO otsNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bbʉ mí bøm pʉ jar barco car Jesús, nguetica̱ bi cca̱hti hnar hñøjø, ya xi mbá e̱je̱ di ntjɛhui. Mbá pøh pʉ cʉ tzi ngu̱ pʉ jabʉ mí cjöti cʉ ánima. Car hñøjø‑ca̱, xquí bbɛh cár mfe̱ni, xquí zʉh cʉ dda nda̱ji̱ cʉ jin gui tzö. ");
INSERT INTO otsNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Cja̱ mí tøhmi pʉ jabʉ mí cjöti cʉ ánima. Már ndo nzɛdi. Jí̱ mí bbʉh ca to di jiöti di du̱hti. ");
INSERT INTO otsNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Como ya xquí ndo hnu̱htibi quí dyɛ hne̱h quí hua co cadena. Nu guegue, xquí ccʉjquitjo cʉ dda cadena, cja̱ nu cʉ ddáa, xquí ntzɛgui. Jin to mí bbʉy drá nzɛdi pa di da̱pi car hñøjø‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Göhtjo ʉr pa ʉr xu̱y mí dyo já ttøø, co hne̱h pʉ jabʉ mí bbʉh quí ngu̱ cʉ ánima. Mí mafi, mí jɛntsjɛ cár ngø co me̱do már tzi njo. ");
INSERT INTO otsNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Car hñøjø‑cá̱, bbʉ mí jianti ya xi mbá e̱h car Jesús, bú cjʉ ʉr ddiji, hne̱ bi nda̱ndiña̱jmu̱, bi nda̱ne car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bi mafi nzajqui, bi xih car Jesús: ―¿Te guír hñe̱jcua, nuquɛ Jesús? ʉ́r ttʉqui ca Ocja̱ ca bí bbʉh pʉ ña̱, mbo jar ji̱tzi. Dí öhqui, gui hñi̱h ca Ocja gá testigo, pa jin gui ʉngui.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bi ma̱ ncjapʉ car hñøjø, como car Jesús xquí huɛnti cár nda̱ji̱ ca Jin Gui Jo, xquí xifi: ―Nuquiguɛ, gúr ttzonda̱ji̱ jin gui tzöquiguɛ, gui pøni cja̱ gui jiɛj nʉr hñøjø‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Cja̱ car Jesús pé bi dyön car ttzonda̱ji̱ ca xquí zʉh car hñøjø, bi hñi̱mbi: ―¿Te ʉ́r ju̱ quer tju̱ju̱?― Cja̱ bi da̱h‑cá̱: ―Cam tju̱ju̱gö ʉr Ejército, como rá ngu̱guije.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Cja̱ car nda̱ji̱ ca jin gui jo bi ndo ttzi̱n car Jesús, bi dyöjpi jin di fongui pa drí ma pʉ jabʉ jin gui tzö. ");
INSERT INTO otsNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Car Jesús co car hñøjø már bbʉjcua, cja̱ már bbʉj nʉ rá cjanʉ hnar ttøø. Nʉ hnanguadi car ttøø má dyo hnar ndo partida cʉ zacjua, már ñu̱ni. ");
INSERT INTO otsNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nu cʉ ttzonda̱ji̱ cʉ xquí zʉh car hñøjø, bi dyöjpi ʉr tsjɛjqui car Jesús, i̱na̱jʉ: ―Gui cu̱jquije gu möjme nʉ rá cjanʉ, grá cʉtije mbo í mʉy yʉ zacjua.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Cja̱ car Jesús bi ungui ʉr tsjɛjqui. Nubbʉ, bi bøn cʉ jin gui tzö, bi ma gá ñʉti jáy mʉy cʉ zacjua. Cja̱ car partida cʉ zacjua, göhtjo bi gʉ ʉr ddiji, bi ddagui. Bi má bú ndøjmʉ jár ña̱ car tzi ttøø, bú töguijʉ, bi jiøjʉ jar deje. Már ndo ngu̱ cʉ zacjua, mí bbʉy como yo mil, cja̱ bú cjá̱tijʉ mbo car deje, bú tu̱jʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Diguebbʉ ya, cʉ cja̱hni cʉ már föh cʉ zacjua bi zu̱jʉ, bi ddaguijʉ, bi ma bú ngöxtejʉ jar jñi̱ni hne̱h pʉ ja jua̱ji̱. Cja̱ cʉ cja̱hni bú e̱jmʉ nttzɛdi, bi cca̱htijʉ ter bɛh ca̱ xquí ncja. ");
INSERT INTO otsNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Diguebbʉ ya bú e̱jmʉ pʉ jabʉ már bbʉh car Jesús. Bi cca̱htijʉ car hñøjø ca xquí yojma̱hui cʉ ttzonda̱ji̱ rá ngu̱. Guegue‑cá̱ ya xi már ju̱di pʉ hnanguadi car Jesús, ya xi mí je quí da̱jtu̱, ya xcuí goh cár mʉy. Nu cʉ cja̱hni cʉ xcuí hñe̱jmʉ, bbʉ mí cca̱htijʉ car hñøjø ca múr loco jma̱ja̱, bi ndo zu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bi wenijʉ pʉ, bi ma bú cöxjʉ cʉ pé ddáa cʉ cja mbá e̱je̱. Bi xih‑cʉ te xquí ncjajpi car hñøjø ca xquí zʉh cʉ ttzonda̱ji̱ rá ngu̱, cja̱ hne̱je̱ te xquí ncjajpi cʉ zacjua. ");
INSERT INTO otsNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Diguebbʉ ya cʉ mi̱ngu̱ pʉ, bi mʉdi bi ttzi̱n car Jesús di wem pʉ jár jöy gueguejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cja̱ car Jesús bi ñʉti jar barco, bi ma. Nu car hñøjø ca xquí zʉh quí nda̱ji̱ ca Jin Gui Jo, bi ndo dyöjpi favor car Jesús di ungui ʉr tsjɛjqui di ñʉtihui jar barco, di dɛni. ");
INSERT INTO otsNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nu car Jesús jin gá jiɛgui. Bi xifi: ―Me ir ngu̱, cja̱ gui xih quir mi̱ngu̱jʉ te tza ngu̱ cár jma̱jte ca Ocja̱, como guegue‑ca̱ xí jui̱quiqui cja̱ xí joquiqui.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nubbʉ́, bi ma car hñøjø, bi ma guí ngöxte pʉ jar lugar ca mí tsjifi Decápolis. Bi xih cʉ cja̱hni te tza már zö car milagro xquí dyøti car Jesús, cja̱ co ja ncja xquí cohtzibi quí mfe̱ni. Cja̱ göhtjo cʉ cja̱hni cʉ bi dyødejʉ, bi ndo hño í mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Diguebbʉ ya, car Jesús pé bi ddax car mar, pé bi zøti pʉ ca hnanguadi. Nubbʉ, bi jmuntzi rá ndo ngu̱ cʉ cja̱hni. Bi guati pʉ jabʉ már bbʉh car Jesús, pʉ jar nengui mar. ");
INSERT INTO otsNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cja̱ bú e̱h hnar hñøjø ca mí mandado pʉ jár templo cʉ judio. Mí ju̱ cár tju̱ju̱ múr Jairo. Guegue‑ca̱ bi guati car Jesús, cja̱ bi nda̱ndiña̱jmu̱ pʉ jáy hua. ");
INSERT INTO otsNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Cja̱ bi ndo dyöjpi favor di ma tzʉ pʉ jár ngu̱. Bi xifi: ―Ya xná tu̱ cam tzi tti̱xu̱. Gu mɛ tzʉ, gui dyʉx quir dyɛ pa da zö, da hmʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nubbʉ́, car Jesús bi mɛhui guegue, cja̱ má tɛni hnar ndo jmundo cʉ cja̱hni, má ndo dʉjʉ jar hñu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Guejtjo már bbʉh pʉ hnar bbɛjña̱ ca mí jñi̱ni, mí yojmi cʉ cja̱hni rá ngu̱ cʉ má tɛn car Jesús. Guegue xquí tzöhui doce cjeya ca mír xoti cji. ");
INSERT INTO otsNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Xquí ndo sufri, xquí ndo ddax cʉ médico rá ngu̱. Pe jin te mí jogui, cja̱ ya xquí ttzoni göhtjo cár domi. Ya jin te mí ja̱, cja̱ mír ngu̱jquitjo cár jñi̱ni. ");
INSERT INTO otsNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Car bbɛjña̱‑cá̱, bbʉ mí dyøde te mí ma̱n cʉ cja̱hni digue car Jesús, bi jioni, bi guati pʉ jár xʉtja madé cʉ cja̱hni rá ngu̱, cja̱ bi zɛtibi cár da̱jtu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Como mí ma̱ntsjɛ mbo ʉ́r mʉy: “Bbʉ gu tjömbitjo nʉ́r da̱jtu̱ nʉ i je nʉr Jesús, gu zö.” ");
INSERT INTO otsNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cja̱ bbʉ mí zɛtibi cár da̱jtu̱, nguetica̱ bi tzöya ca mír xoti cji, cja̱ bi ba̱di, ya xquí wen cár jñini. ");
INSERT INTO otsNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nu car Jesús nguetica̱ bi ba̱di, por rá ngue cár ttzɛdi guegue, xquí zö hnar döhtji. Cja̱ bi bböti, bi dyön quí möxte cʉ mí hñohui: ―¿Toca̱ xí zɛtigui nʉm da̱jtu̱?― ");
INSERT INTO otsNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nu quí möxte bi da̱di, bi hñi̱mbijʉ: ―¿Cja jin guí cca̱hti yʉ cja̱hni rá ndo ngu̱, xí nguahqui, hasta i ndo nttzi̱xjʉ? ¿Ja ncja güi tzö bbʉ to di dönqui, bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nu car Jesús bi bböti, bi cca̱hti göhtjo cʉ cja̱hni cʉ már bbʉh pʉ cerca, pa di ba̱di toca̱ xquí dyøhtibi‑ca̱, cja̱ bi cca̱hti car bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mí pa̱h car bbɛjña̱, gue car Jesús xquí jña̱jquibi cár jñi̱ni, pe mí tzu̱, hasta mí jua̱. Nubbʉ, bi guati cja̱ bi nda̱ndiña̱jmu̱ pʉ jáy hua car Jesús, bi ncjua̱ni, bi xifi göhtjo te xquí ncja. ");
INSERT INTO otsNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Cja̱ car Jesús bi xifi: ―Nuquɛ ʉm tti̱xu̱qui, guehca̱ xquí hñe̱me̱gui, xcú zö. Gui má ya rá zö, da jñu̱ ir tzi mʉy. Ya jim pé da yojpi quer jñi̱ni.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bbʉ már ña̱di guegue, bú e̱h cʉ dda cja̱hni, xcuí hñe̱h pʉ jár ngu̱ car hñøjø ca mí mandado pʉ jár templo cʉ judio, cja̱ bi xijmʉ‑cá̱: ―Ya xí ndu̱ quer tzi tti̱xu̱. Jiɛj nʉr maestro‑yá. Hmɛditjo guí ne gui tzix pʉ ir ngu̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nu car Jesús jin gá cjajpi ncaso ca mí ma̱n‑cʉ́. Guegue bi xih car hñøjø ca mí ja̱ cár cargo: ―Dyo guí ntzu̱. Gui hñe̱me̱tjojo.― Diguebbʉ ya bi mɛhui. ");
INSERT INTO otsNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Car Jesús jin gá jiɛh cʉ cja̱hni rá ngu̱ di dɛngui ʉ́r xʉtja. Bi zix car Pedro co car Jacobo co car Juan ca mí ncjua̱da̱hui car Jacobo, jøña̱‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cja̱ bi zøtijʉ pʉ jár ngu̱ car hñøjø ca mí ja̱ cár cargo pʉ jár templo cʉ judio. Car Jesús bi cca̱hti cʉ cja̱hni rá ngu̱ cʉ xquí jmu̱ntzi pʉ, cja̱ bi dyøde, már ndo huɛttzonijʉ cja̱ már ndo ji̱jʉ car ánima. ");
INSERT INTO otsNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nu guegue bi ñʉti car ngu̱ cja̱ bi xih cʉ cja̱hni: ―¿Dyoca̱ gár majmʉ cja̱ gár zonijʉ? Nʉr tzi bbɛjña̱ jin gui tu̱. Dí cca̱htigö ncjahmʉ rá a̱ti‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nu cʉ cja̱hni cʉ már bbʉh pʉ bi denijʉ bbʉ́, como mí pa̱dijʉ, cierto ya xquí du̱ car ba̱jtzi. Cja̱ car Jesús bi fongui göhtjo‑cʉ́, cja̱ bi zix cár ta car ba̱jtzi, co cár me, co hne̱h cʉ jñu̱ quí möxte cʉ xquí dɛni. Bi ma gá ñʉtijʉ ca hnar cuarto pʉ jabʉ már bbɛn car ba̱jtzi bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Diguebbʉ ya car Jesús bi zɛtibi cár dyɛ cja̱ bi nzofo gá hebreo, como guehca̱ mí ña̱ gueguejʉ‑cá̱. Bi xih car ba̱jtzi bbɛjña̱: ―Talita cumi.― Na̱r palabra‑na̱ i ne da ma̱: Nantzi ya chju̱. ");
INSERT INTO otsNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Car hora ca bi nzofo, exque bi nantzi car tzi bbɛjña̱, mí pɛhtzi doce año. Nu cʉ cja̱hni cʉ bi cca̱htijʉ bi ndo hño ʉ́r mʉyjʉ cja̱ bi zu̱jʉ rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nu car Jesús bi ccax cʉ mi̱ngu̱ pʉ, nttzɛditjo bi xih cʉ cja̱hni jin to di ngöxte. Cja̱ pé bi xijmʉ di unijʉ te di zi car tzi ba̱jtzi bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Diguebbʉ ya car Jesús bi bøm pʉ, pé gá ma jár jöy guegue, cja̱ bi dɛn quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cja̱ bbʉ mí zøh car pa ca mí tzöyajʉ, car Jesús bi ma jar templo, bi mʉdi bi u̱jti cʉ cja̱hni rá ngu̱ cʉ xquí mpɛjni pʉ. Cja̱ bbʉ mí dyøh cʉ cja̱hni te mí ma̱n car Jesús, bi ndo hño í mʉyjʉ cja̱ bi ma̱jmʉ: ―¿Ja xcá mba̱j nʉr hñøjø‑nʉ yʉ palabra yʉ i xijquijʉ? ¿Jabʉ guá hñe̱j nʉr jogui mfe̱ni i pɛhtzi ya‑nʉ́? ¿Jabʉ xí nxödi da dyøti milagro? ");
INSERT INTO otsNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Cja jin gui gue nʉr yaxi‑nʉ́, nʉ́r ttʉ car María, nʉ́r cjua̱da̱ car Jacobo co car José co car Judas, co car Simón? ¿Cja jin gui bbʉjcua nʉm jñi̱nijʉ quí ncju̱ hne̱je̱? ¡Ngue! i bbʉjcua göhtjo‑cʉ.― Cʉ mi̱ngu̱ Nazaret mí ma̱jmʉ ncjapʉ, como jí̱ mí ne di hñe̱me̱jʉ, ¿cja güí hñe̱h ca Ocja̱ car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nu car Jesús bi da̱di: ―Jin gui tti̱htzibi yí jmandadero ca Ocja̱ pʉ jabʉ mi̱ngu̱jʉ. Jin gui tti̱htzibi pʉ jár ngu̱, pʉ jabʉ i bbʉh cár ta, co cár me. Nu cʉ cja̱hni cʉ rá bbʉh pʉ pé dda lugar, nucʉ́ da hñi̱htzibi‑cʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Como jí̱ mí tti̱htzibi car Jesús pʉ Nazaret, causa, jin tza mí ngu̱ cʉ milagro bi dyøti pʉ. Bi jojqui tengu̱di cʉ döhtji, bi dyʉx quí dyɛ, cja̱ guegue bi wen cʉ jñi̱ni cʉ mí tzöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nu car Jesús, bi ndo hño ʉ́r mʉy, dyoca̱ jí̱ mí ne di hñe̱me̱ quí mi̱ngu̱. Diguebbʉ ya, bi bøni gá ma cʉ pé dda tzi jñi̱ni cʉ már nzøtitjohui car Nazaret, cja̱ bi xih cʉ cja̱hni cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Diguebbʉ ya, car Jesús bi nzoh cʉ doce hñøjø cʉ mí ntzixihui. Bi xifi di bønijʉ di ma gá yojo, drí hñojʉ göhtjo cʉ tzi jñi̱ni. Cja̱ bi un cár cargojʉ, pʉ jabʉ di ntjɛhui cja̱hni cʉ xquí zʉ ttzonda̱ji̱, di fonguibi‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bi xijmʉ jin te di jña̱xjʉ jar hñu̱, jøntsjɛ hnar tøjø. Jin di du̱xjʉ hnar bbɛni ʉr da̱jtu̱, jin di ma di gʉxjʉ tju̱jme̱, cja̱ jin di jmu̱ntzi domi pa di jña̱xjʉ jar hñu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bi xijmʉ di di̱htijʉ zɛxtji tjojo cja̱ jin di fi̱htzi cár pötijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Car Jesús guejtjo bi xih quí möxte: ―Bbʉ gui tzøtijʉ hnar jñi̱ni cja̱ gui cʉtijʉ hnar ngu̱, gui hmʉjtijʉ pʉ hasta car pa bbʉ xquí pønijʉ car jñi̱ni‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Cja̱ bbʉ i bbʉh hnar jñi̱ni pʉ jabʉ jin da ne da cuajtiquijʉ cʉ cja̱hni, cja̱ jin da ne da dyøh car palabra ca gui xijmʉ, bbʉ xtí pønijʉ jar lugar‑ca̱, gui jøjmijʉ cʉ jöy cʉ di tu̱ quir huajʉ, pa da ba̱h cʉ mi̱ngu̱ pʉ, ya jim pé gu cojmʉ pʉ, como jin gui tzö ca xí dyøjtiquijʉ. Cierto dí xihquijʉ, cʉ mi̱ngu̱ car jñi̱ni Sodoma co car jñi̱ni Gomorra da ttuni hnar castigo drá ngu̱ bbʉ xtu e̱h ca Ocja̱ pa da juzga yʉ cja̱hni. Nʉ cʉ mi̱ngu̱ pʉ jabʉ da mfonguiquijʉ, más drá ndo ngu̱tsjɛ cár castigo ca da ttun‑cʉ, hasta jin da jiötijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Cja̱ bbʉ ya xquí guah car Jesús, xquí nzoh quí möxte, bi bøn‑cʉ́, bi ddaxjʉ rá ngu lugar, bi nzojmʉ cʉ cja̱hni. Bi xijmʉ di jiɛjmʉ ca rá nttzo cja̱ di jionijʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Cja̱ bi jojqui rá ngu̱ cja̱hni cʉ xquí nloco, xquí zʉh cár nda̱ji̱ ca Jin Gui Tzö. Guejtjo bi xoxi döhtji rá ngu. Mí coxi hna tzi tʉjqui ʉr aste, cja̱ bi zö‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nubbʉ, bi dyøh car rey Herodes te mí ma̱n cʉ cja̱hni digue car Jesús, como mí ndo ntʉngui ca mí øti‑ca̱. Cja̱ bi ma̱n car Herodes: ―Gue car Juan ca mí xix yʉ cja̱hni, ya pe xqui dyo. Masque bi du̱, pe nuya pé xí jña̱ ʉ́r jña̱, eso, i ndo øti milagro rá nzɛdi.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Cja̱ mí bbʉh cʉ dda cja̱hni cʉ mí ma̱jmʉ: ―Gue nʉr profeta Elías nʉ i ndo øti milagro.― Cja̱ pé mí bbʉh cʉ ddaa cʉ mí ma̱jmʉ: ―Guejti nʉr Jesús ʉr profeta hne̱je̱, eso, i øti milagro. I jñɛjmi cʉ profeta cʉ mí bbʉ má̱hmɛto.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nu car Herodes nde̱jma̱ mí mbe̱ni: ―Gue car Juan ca dú mandado bi tjɛjquibi cár dyʉga. Cja̱ nuya pé xí jña̱ ʉ́r jña̱, ya pé xqui bbʉjtjo.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Guegue car Herodes xquí cuajti cár bbɛjpo, xquí hmʉjtsjɛhui. Nucá̱, mí ju̱ cár tju̱ju̱ múr Herodías, múr bbɛjña̱ car Felipe, cár cjua̱da̱ car Herodes. Car Juan bi huɛnti car Herodes por rá nguehca̱ xquí yohti bbɛjña̱, eso, car Herodes bi mandado di ttzʉh car Juan cja̱ di cjoti födi. ");
INSERT INTO otsNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Como car Juan xquí xih car Herodes: ―Jin gui tzö ca pé xcú cuajtibi cár bbɛjña̱ quer cjua̱da̱, pé xcú cjajpi ir bbɛjña̱. ʉr hmɛtzö‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Eso, car bbɛjña̱‑ca̱ mí ndo ʉhui car Juan, mí ne di mandado di bböhti. Nu car rey Herodes bi ccahtzi, jin gá jiɛgui di möhti. ");
INSERT INTO otsNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Como car Herodes nde̱jma̱ mí i̱htzibi car Juan. Mí pa̱di jin te mí tu̱‑ca̱ cja̱ mí pɛjpi ca Ocja̱. Eso, mí ntzu̱ pa te di cjajpi car Juan. Guejtjo bi ccax cár bbɛjña̱ pa jin te di cjajpi. Guegue mí gusta di dyøh ca mí ma̱n car Juan, macja̱ mí yomfe̱ni ¿ja ncja di jogui di dyøti ca mí ma̱n‑cá̱? ");
INSERT INTO otsNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pe nde̱jma̱ bi zøh car pa ca mí tøhmi car Herodías, como nucá̱ mí joni ja drí möhti car Juan. Bi zøh car pa bi tzo cár cumpleaños car Herodes. Guegue‑cá̱ bi dyøti hnar mbaxcjua cja̱ bi nzojni cʉ hñøjø cʉ mí föx cár jmandado, co cʉ jefe cʉ mí mandadobi cʉ sundado, co cʉ pe dda hñøjø cʉ mí ja̱ ʉ́r cargojʉ pʉ jar estado Galilea. ");
INSERT INTO otsNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bbʉ mí ttøti car mbaxcjua, cár tti̱xu̱ car Herodías bi ñʉti pʉ jabʉ már bbʉh cʉ cja̱hni, bi ni̱, cja̱ bi ndo tzøh car Herodes co cʉ pe dda cja̱hni cʉ már tzihui guegue. Nubbʉ, car rey bi mahti car ba̱jtzi bbɛjña̱ cja̱ bi xifi: ―Nuquɛ chju̱, rá ndo zö gri ni̱. ¿Tema regalo guí ne gu ddahqui? ");
INSERT INTO otsNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dí i̱h ca Ocja̱, ca te gui dyöjqui, xtá ddahqui, hasta madé nʉr jöy nʉ dí mandado gá rey.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Diguebbʉ ya, car ba̱jtzi bbɛjña̱ bi bøni, bi ma bú cöx cár me, cja̱ bi dyöni: ―¿Ter bɛh ca̱ gu öjpi?― Cár me ya bi da̱di: ―Dyöjpi cár ña̱ car Juan ca mí xix yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cja̱ nguetica̱ car ba̱jtzi bbɛjña̱ bú coh pʉ jabʉ már bbʉh car rey, cja̱ bi xifi: ―Dí negö ya da ttzɛjquibi cár ña̱ car Juan ca mí xix yʉ cja̱hni, da cjöti hnar moji cja̱ du ddɛ hua.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bbʉ mí dyøj ya‑ca̱ car Herodes, bi ungui ʉr dumʉy, pe nde̱jma̱ bi mandado di ttun car ba̱jtzi bbɛjña̱ ca mí ödi. Como xquí hñi̱h ca Ocja̱ gá testigo, guejtjo por rá ngue cʉ cja̱hni cʉ már ju̱ pʉ, már cca̱htijʉ te di ncja, jí̱ mí jogui di gømbi car ba̱jtzi bbɛjña̱ ca xquí dyödi. ");
INSERT INTO otsNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eso, car Herodes nguetica̱ bi nzoh hna cʉ sundado, bi gu̱y di ma du ja̱mpi cár ña̱ car Juan. ");
INSERT INTO otsNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Cja̱ car sundado bi ma gá ma jar födi, bú tzɛjquibi cár dyʉga car Juan, bú cöhtibi cár ña̱ hnar moji, cja̱ pé bú tjɛ, bi un car ba̱jtzi bbɛjña̱. Cja̱ guegue‑ca̱ pé bi un cár me. ");
INSERT INTO otsNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Diguebbʉ ya bi dyøh quí möxte car Juan te xquí ncja. Bi möjmʉ pʉ jar födi, bú tu̱jʉ cár cuerpo car Juan, bú cötijʉ pʉ jár ngu̱ gá ánima. ");
INSERT INTO otsNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Diguebbʉ ya, bú cojmʉ quí möxte car Jesús cʉ xquí bønijʉ xquí tʉnguijʉ car tzi jogui jña̱. Bú e̱jmʉ bi mpɛjnijʉ car Jesús cja̱ bi xi guegue jabʉ xcuí zønijʉ, co ja ncja xcuí u̱jti cʉ cja̱hni cja̱ co göhtjo ca xcuí dyøtijʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nu car Jesús bi xijmʉ: ―Möj ya, dá möh pʉ jabʉ jin to i hña̱ni, gu ma tzöyajʉ tzʉ pʉ.― Mí ma̱ ncjahua, como már ndo ngu̱ cʉ cja̱hni cʉ mí jonijʉ car Jesús. Xní ma cʉ ddaa, ya pé xi mbá e̱h cʉ ddaa. Cja̱ gueguejʉ, ni mpa mí ttungui tiempo pa di zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eso, bi mɛhui quí möxte bi ñʉtijʉ hnar barco, gá möjmʉ ca pé hnanguadi car mar, pʉ jabʉ jin te mí bbʉ jñi̱ni. ");
INSERT INTO otsNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nu cʉ cja̱hni már jantijʉ, cja̱ bi meyajʉ to cʉ xquí ñʉtijʉ jar barco. Nubbʉ, bi möjmʉ, bi cöjtitjojʉ jár nttza̱ni car deje, má tɛnijʉ car barco pʉ jabʉ má pa. Már ngu̱ cja̱hni, mi̱ngu̱jʉ cʉ tzi jñi̱nitjo cʉ mí bbʉ jár nttza̱ni car mar, bi bønijʉ pa di ma du ntjɛhui car Jesús. Bbɛto bi zøti cʉ cja̱hni, cja̱ bbʉ mí zøti pʉ car Jesús, ya xi már tøhmi‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nu car Jesús, bbʉ mbú ca̱h pʉ jar barco, bi cca̱hti cʉ cja̱hni már ndo dʉ, cja̱ bi jui̱jqui, como mí ncjajʉ ncja ngu̱ yʉ tzi dɛti bbʉ jin te i bbʉh cár mödijʉ. Cja̱ bi mʉdi bi u̱jti cʉ cja̱hni rá ngu̱ mfe̱ni digue cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cja̱ bbʉ ya xquí nde, quí amigo car Jesús bi guati, bi xijmʉ: ―u̱jtjo jin te i bbʉ dɛnda hua jabʉ dí bbʉpjʉ. Ncjá ya, ya xí nde. ");
INSERT INTO otsNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gui cu̱h tzʉ ya yʉ cja̱hni da ma já rancho co já tzi jñi̱ni nʉ rá cjanʉ pa du tönijʉ tju̱jme̱, como u̱jtjo te da zijʉ hua.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nu car Jesús bi da̱di: ―Nuquiguɛjʉ, gui unijʉ te da zi‑yʉ́.― Nu quí möxte pé bi xijmʉ: ―¿Cja da jogui gu möjme, gu má töjme tju̱jme̱ rá ngu̱, da mu̱hui yo ciento cʉ domi, pa gu unije da zi‑yʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Cja̱ bi da̱j ya car Jesús: ―¿Tengu̱ tju̱jme̱ guí pɛhtzijʉ hua? Gui möjmʉ ya, bú cca̱htijʉ.― Cja̱ bi möjmʉ bú hñönijʉ, bbʉ́. Diguebbʉ ya, pé bú cojmʉ bi xijmʉ car Jesús: ―Jøndi cʉtta tju̱jme̱ co yojo tzi möy.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma ya, car Jesús bi xih quí möxte di bbɛjpi cʉ cja̱hni rá ngu̱ di wegue gá grupo cja̱ di mi̱h pʉ ja tzi ccangui paxi. ");
INSERT INTO otsNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nubbʉ́, bi wejque gá grupo cʉ cja̱hni. Cʉ dda grupo mí pɛhtzijʉ hna ciento cja̱hni. Nu cʉ pé dda grupo, mí pɛhtzijʉ cincuentatjo. Göhtjo bi mi̱pjʉ jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Diguebbʉ ya car Jesús bi pɛnti cʉ cʉtta tju̱jme̱ co cʉ yojo möy. Bi nøhtzi ji̱tzi, bi dyöjpi ca Ocja̱ di bendeci. Nubbʉ́, bi xɛjqui cʉ tju̱jme̱ cja̱ bi uni quí möxte pa di jejquibi cʉ cja̱hni, di zi‑cʉ́. Cja̱ bi ncjadipʉ cʉ yojo tzi möy, bi jejquibi göhtjo cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nubbʉ́, göhtjo cʉ cja̱hni bi zijʉ, cja̱ bi ñi̱ña̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Diguebbʉ ya, quí amigo car Jesús bi jmuntzijʉ cʉ tzi pedazo cʉ tju̱jme̱ co cʉ tzi pedazo cʉ möy cʉ xquí sobra, bi ñu̱htzijʉ doce cʉ bbøtze. ");
INSERT INTO otsNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mí cʉtta mil cʉ hñøjø cʉ bi zi cʉ tju̱jme̱, aparte cʉ bbɛjña̱ co cʉ ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Diguebbʉ ya car Jesús bi xih quí möxte di hmɛtojʉ di ddax car mar, di möjmʉ ca hnar jñi̱ni mír hmʉh ca pé hnanguadi car deje. Car jñi̱ni‑cá̱ mí tsjifi Betsaida. Eso, bi ñʉtijʉ car barco, bi möjmʉ, cja̱ guegue car Jesús bi xih cʉ cja̱hni di möjmʉ í ngu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cja̱ bbʉ ya xquí wen cʉ cja̱hni, car Jesús bi bøx pʉ jar ttøø, pa drí nzoh ca Ocja̱ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bbʉ ya xquí nxu̱y rá zö, car barco pʉ jabʉ má pa quí amigo car Jesús má dyo jar madé car zabi, nu car Jesús már ddatsjɛ pʉ jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Cja̱ guegue bi jianti quí möxte, ya xquí ndo mbo ʉ́r cuɛjʉ, como mír dɛmpi jár jmi̱jʉ car nda̱ji̱, mbá cohtzitjojo car barco pʉ jabʉ xcuí hñe̱je̱. Cja̱ bbʉ mí bbɛh tzʉ pa di ni̱gui, car Jesús bi hño xøtze car deje. Mír ma du tzʉh quí möxte pʉ jabʉ má pa car barco. ");
INSERT INTO otsNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nucʉ́, bbʉ mí jiantijʉ car Jesús má dyo xøtze car deje, bi hñi̱na̱jʉ, múr pijte, cja̱ bi ndo majmʉ nzajqui. ");
INSERT INTO otsNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Göhtjo bi jiantijʉ, cja̱ bi ndo zu̱jʉ rá ngu̱. Nu car Jesús ya, xní nzofo bi xijmʉ: ―Da jñu̱ ir mʉyjʉ ya. Guejquigö. Dyo guí ntzu̱jʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Diguebbʉ ya bi bøx car Jesús, bi ñʉti jar barco pʉ jabʉ má pa quí möxte. Nubbʉ́, bi hna tzöya car nda̱ji̱. Cja̱ quí möxte, bi ndo hño í mʉyjʉ, ");
INSERT INTO otsNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","como jí̱ mí ntiendejʉ ja mí ncja car Jesús, masque xquí cca̱htijʉ te bi cjajpi cʉ tju̱jme̱, pe nde̱jma̱ jin gá ntiendejʉ, te tza már nzɛh car Jesús, como már me̱di quí mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Diguebbʉ ya, bi ddaxjʉ car mar, bi zønijʉ ca pé hnanguadi car deje, nʉ jar jöy nʉ mí tsjifi Genesaret. Bi da̱tijʉ car barco, cja̱ bi bønijʉ jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cja̱ cʉ cja̱hni cʉ mí bbʉh pʉ, nguetica̱ bi meyajʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Cja̱ bbʉ mí fa̱di, ya xi már bbʉh pʉ car Jesús, bú cjʉ ʉr ddiji göhtjo cʉ mi̱ngu̱ pʉ, co cʉ mi̱ngu̱ cʉ pe dda tzi jñi̱ni cʉ már nzøtihui pʉ jar mar. Bi mpɛguijʉ bú tzí quí döhtjijʉ. Cʉ ddaa cʉ jí̱ mí tzö di hño, bú tu̱dijʉ co göhtjo quí mfi̱di. Göhtjo bú cuatijʉ pʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Göhtjo pʉ jabʉ mí pa car Jesús, ncja ngu̱ já ciudad, ncja ngu̱ já tzi jñi̱nitjo, ncja ngu̱ já rancho, mbá hñɛ cʉ cja̱hni, mbá cuatijʉ car Jesús. Mbá tzí quí döhtjijʉ, mí pɛh pʉ já töy cja̱ co já hñu̱, pa bbʉ xti tjoh pʉ car Jesús, di dyöjpijʉ favor di jiɛjmʉ di dömbijʉ cár nttza̱ni cár da̱jtu̱. Cja̱ göhtjo cʉ to bi dönijʉ, bi zö‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Diguebbʉ ya, bú e̱h cʉ dda fariseo, bi guatijʉ car Jesús. Mbá yojmʉ cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley. Cʉ fariseo co cʉ maestro xcuí hñe̱jmʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Gueguejʉ bi cca̱htijʉ cʉ dda quí möxte car Jesús, már tzijʉ tju̱jme. Pe nucʉ́, jí̱ xcá xʉdyɛjʉ ncja ngu̱ nguá xʉdyɛ cʉ fariseo. Eso, bi zohmijʉ‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Como cʉ fariseo co göhtjo cʉ ddáa cʉ mí tɛndijʉ cár religión cʉ judio, mí tɛnijʉ costumbre cʉ xquí zoh quí titajʉ, masque jí̱ mí cuati jar Escritura cʉ costumbre‑cʉ́. Nu cʉ fariseo co cʉ pé ddáa cʉ mí tɛnijʉ‑cʉ, mí ndo xʉdyɛjʉ rá ngu̱ ante que di zijʉ. Mí ma̱jmʉ, mí nesta di nxʉjqui rá ngu̱ vez pa di goji limpio, ncjapʉ di tzøh ca Ocja̱, como mí i̱na̱jʉ, már nttzo cʉ cja̱hni rá ngu̱ cʉ xcuí ntjɛhui pʉ jar töy. ");
INSERT INTO otsNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cja̱ bbʉ mbá cojmʉ jár töy, mí nxajmʉ, cja̱ bbʉ ji̱na̱, jin di zijʉ. Guejtjo mí tɛnijʉ pé dda costumbre rá ngu̱, mí ma̱jmʉ, i ne ca Ocja̱ gu øtijʉ ncjapʉ. Mí xʉti göhtjo quí traste según quí mandamientojʉ pa jin di contibi quí tzi mʉyjʉ. Dé mí xʉti quí vaso co quí xaro, co quí traste gá xittɛgui, hasta cʉ gama, guejtjo mí pehtijʉ‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Cʉ fariseo co cʉ maestro cʉ mí u̱jti cʉ cja̱hni, mí tɛnijʉ göhtjo cʉ costumbre‑cʉ. Cja̱ gueguejʉ bi dyönijʉ car Jesús: ―Yʉ hñøjø yʉ guí ujti, ¿dyoca̱ jin gui tɛn cʉ costumbre cʉ xí nzoguijʉ cʉm titajʉ? Jin gui xʉdyɛjʉ rá zö bbʉ ya xta zijʉ tju̱jme̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nu car Jesús bi da̱di, bi xijmʉ: ―Nuquiguɛjʉ, guí jiöjtejʉ. Guí øtijʉ ncja ngu gá ma̱n car profeta Isaías ya má yabbʉ cja̱ bi jñux pʉ jar libro ca bi dyøte. Bi jñu̱xi na̱r tzi palabra‑na̱: I ma̱n ca Ocja̱: Yʉ cja̱hni‑yʉ, i xöjtigui, pe jøntsjɛtjo gá palabra, Pʉ mbo ʉ́r mʉyjʉ, yanʉ i dyo, jin gui cuajquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jin te ntjumʉy ga xöjtiguijʉ, Cja̱ pé i ujti quí mi̱nga̱‑cja̱hnijʉ da dɛni jmandado cʉ xí mbe̱ntsjɛ yʉ cja̱hnitjo. I ncjanʉ ga ma̱n car palabra‑ca̱, cja̱ nuquɛjʉ, guí øtijʉ ncjapʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Guí jɛjmʉ cʉ mandamiento cʉ xí ma̱n ca Ocja̱. Nu cʉ mandamiento cʉ xí ma̱n cʉ cja̱hnitjo, guí ndo øjtijʉ‑cʉ́ cja̱ guí tɛnijʉ. Guí ndo ju̱hmpijʉ ndumʉy ja grí xʉtijʉ cʉ xaro co cʉ vaso pa grí tzijʉ. Cja̱ guí ndo tɛnijʉ pé dda costumbre cʉ i jñɛjmʉ‑nʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cja̱ bi segue bi ma̱n car Jesús: ―Nuquiguɛjʉ, jin guí cjajpijʉ ncaso cʉ mandamiento cʉ xí ddajquijʉ ca Ocja̱. Nu cʉ costumbre cʉ xí nzohquijʉ quir mi̱nga̱‑cja̱hnijʉ, guehcʉ́ guí ndo cjajpijʉ ncaso‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Car Moisés bi zoguijʉ na̱r mandamiento‑na̱: “Gui hñi̱htzibi quer ta co quer me.” Guejtjo hne̱je̱ bi ma̱n car Moisés: “Ca to da zan car ta o gue cár me, exque da du̱‑cá, da bböhti.” ");
INSERT INTO otsNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nuquiguɛjʉ, guí xijmʉ yʉ cja̱hni, i nesta gu döjʉ jar templo cam domijʉ, macja̱ jin te da sobra pa gu föx cʉm tajʉ co cʉm mejʉ. Tzʉdi, guí ma̱jmʉ, bí jojtjo pa to da xih cár ta o cár me: “Ya jin te dí ja̱gö pa gu föxqui. Ya xtú un ca Ocja̱ göhtjo ca ndí pɛhtzi pa gua ddahqui.” ");
INSERT INTO otsNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tzʉdi, guí xijmʉ cʉ cja̱hni, jin gui nesta da möx quí tajʉ o gue quí mejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ncjapʉ, guí u̱jtijʉ cʉ cja̱hni jin da cjajpi ncaso car mandamiento ca bi zoguijʉ car Moisés. Nu ca guí mandadotsjɛjʉ, guehcá̱ guí bbɛjpijʉ yʉ cja̱hni da dyøjte. Cja̱ guí øtijʉ pé dda cosa rá ngu̱ cʉ i jñɛjmi‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Diguebbʉ ya, car Jesús pé bi nzoh cʉ cja̱hni rá ngu̱ cʉ xquí jmuntzi, bi xijmʉ: ―Nuquɛjʉ, guí göhtjojʉ, gui dyødejʉ cja̱ gui ntiendejʉ nʉ dí ma̱: ");
INSERT INTO otsNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","I jogui gu tzijʉ göhtjo ca te i ttzi, cja̱ jin da contiguijʉ yʉm tzi mʉyjʉ. Nu cʉ nttzomfe̱ni cʉ i mbe̱n yʉ cja̱hni mbo í mʉyjʉ, nucʉ́, i contibi í tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yʉ to i bbʉj yí gu̱, da dyøde te i ne da ma̱ nʉr palabra‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bbʉ xquí ma̱ ncjanʉ car Jesús, bi hñi̱h cʉ cja̱hni rá ngu̱ cʉ xquí jmuntzi, cja̱ guegue bi ma gá ma hnanguadi, gá ñʉti hnar ngu̱. Nu quí möxte bi dɛni cja̱ bi dyödi di yojpi di xijmʉ, ¿ja i ncja cʉ cosa cʉ i contiguijʉ yʉm tzi mʉyjʉ? ");
INSERT INTO otsNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Bi da̱j ya car Jesús, bbʉ́: ―Xiquiguɛjʉ, ¿cja guí ncjajʉ ncja cʉ pé dda cja̱hni hne̱je̱? ¿Cja jin guí pa̱dijʉ te i ne da ma̱n car palabra‑ca̱? Göhtjo yʉ te i ttzi, jin gui tzö da contiguijʉ yʉm tzi mʉyjʉ, ");
INSERT INTO otsNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","como jin gui cʉti pʉ mero mbo yʉm tzi mʉyjʉ. Gue cʉm nttza̱mfojʉ pʉ jabʉ rí ñʉti ca dí tzijʉ. Diguebbʉ ya, bbʉ xta ma tji car cja̱hni, xtu tzoh pʉ ca te xtrú nzi.― Car Jesús, bbʉ mí ma̱ nʉr palabra‑nʉ, bi xih cʉ cja̱hni cʉ mí tɛnijʉ, i jogui gu tzijʉ göhtjo cʉ alimento. ");
INSERT INTO otsNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cja̱ pé bi ma̱n car Jesús: ―Cʉ mfe̱ni jin gui tzö cʉ i mbe̱n hnar cja̱hni mbo ʉ́r tzi mʉy, guehcʉ i contibi‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","I mbe̱n yʉ cja̱hni rá ngu̱ nttzomfe̱ni, ncjá yʉ gu xihquijʉ ya: I jöhtibi quí bbɛjña̱ cʉ dda hñøjø, o gue quí da̱me cʉ dda bbɛjña̱. I bbʉbi bbɛjña̱ co hñøjø cʉ jí̱ xcá ntja̱jtihui. I pöhtite. ");
INSERT INTO otsNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","I mpe̱. I nejpi cár mɛjti cár mi̱nga̱‑cja̱hnihui. Guejtjo i ʉhui cár mi̱nga̱‑cja̱hnihui. I øti ntjöti. I bbɛ ʉ́r tzö. Jin gui pɛnti quí mfe̱ni. I hui̱htzi cár hñohui, i xohtzibi bbɛtjri, i hñi̱xtsjɛ, i cja ʉr dondo, como jin gui tzu̱ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Göhtjo yʉ nttzomfe̱ni‑yʉ, i mbe̱n yʉ cja̱hni mbo ʉ́r mʉyjʉ, cja̱ guejyʉ i contibi‑yʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Diguebbʉ ya, car Jesús bi bøm pʉ, bi ma gá ma jár lindero car jöy pʉ jabʉ már bbʉh cʉ yo jñi̱ni car Tiro co car Sidón. Cja̱ bbʉ mí zøti pʉ, bi ñʉti hnar ngu̱. Mí ne pa jin di ba̱h cʉ cja̱hni, ¿cja már bbʉh pʉ? Pe nde̱jma̱ bi fa̱di. ");
INSERT INTO otsNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Már bbʉh pʉ ca hnar bbɛjña̱ ca mí jni̱n cár tti̱xu̱, xquí zʉh hnár nda̱ji̱ ca jin gui tzö. Bbʉ mí dyøh car bbɛjña̱, ya xquí zøm pʉ car Jesús, nguetica̱ bi ma bú cuati, bi nda̱ndiña̱jmu̱ pʉ jáy hua, bi dyöjpi favor. ");
INSERT INTO otsNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Car bbɛjña̱‑ca̱ jí̱ múr israelita. Múr mi̱ngu̱ car jöy Fenicia. Guegue bi guati car Jesús cja̱ bi dyöjpi tzʉ di fonguibi car ttzonda̱ji̱ ca xquí zʉh cár tti̱xu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nu car Jesús bi da̱di ncjahmʉ jí̱ mí ne di mötzi. Bi xifi, gue cʉ cja̱hni israelita xcuí hñe̱je̱ di mötzi. Bi ma̱ ncjahua: ―Gui jiɛh quí cja̱hni ca Ocja̱ da ñi̱ña̱ bbɛto. Jin gui tzö gui jña̱jquibi quí tju̱jme̱ cʉ ba̱jtzi, gui dyɛmbi cʉ dyo.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nu car bbɛjña̱ pé bi xih car Jesús: ―Ncjua̱ni, tada, bbɛto i tti̱n cʉ ba̱jtzi, pe guejti cʉ tzi dyo cʉ ra dyo pʉ jöy car mexa i tzi cʉ ngʉnti tju̱jme̱ cʉ i jɛh cʉ ba̱jtzi da dögui.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nu car Jesús pé bi da̱j ya: ―Rá zö nʉr palabra xcú ma̱. Gui mpöj ya, gui me ir ngu̱, como ya xí mbøn car nda̱ji̱ ca xquí zʉh quer tti̱xu̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nubbʉ, bi ma ʉ́r ngu̱ car bbɛjña̱, bi döti cár tzi tti̱xu̱, már bbɛndi pʉ jár gama. Ya xquí jogui, como ya xquí wen cár nda̱ji̱ ca Jin Gui Tzö. ");
INSERT INTO otsNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bbʉ ya xquí ncja‑ca̱, car Jesús bi bøm pʉ jar jöy Tiro, bi tjoh pʉ hnaguadi car jñini Sidón, pé gá göx pʉ jar jöy ca mí tsjifi Decápolis, gá nzøti pʉ jar mar Galilea. ");
INSERT INTO otsNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bbʉ má tjoh pʉ Decápolis, cʉ mi̱ngu̱ pʉ bú tzih hnar gogu̱ ca mí nccʉni nguá ña̱. Cʉ cja̱hni cʉ xcuí ziji, bi dyöjpi car Jesús di göx cár dyɛ car cja̱hni‑ca̱ pa di jogui. ");
INSERT INTO otsNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nubbʉ, bi juejtsjɛhui car gogu̱ car Jesús, bi wembi car ndo jmundo cʉ cja̱hni. Ma ya, bi fojti quí xö pʉ jáy gu̱ car hñøjø. Guejtjo bi zoh cár cji̱jni, co guehca̱ gá ndömbi cár cja̱jni car hñøjø. ");
INSERT INTO otsNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bi nøhtzi ji̱tzi, bi gá̱htzi, cja̱ bi nzofo digue car jña̱ ca mí ña̱jʉ. Bi hñi̱mbi: ―¡Efata!― Na̱r palabra‑na̱ i ne da ma̱: ¡Da xoj yir gu̱! ");
INSERT INTO otsNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cja̱ nguetica̱ bi xoh quí gu̱ car cja̱hni, cja̱ bi joh cár cja̱jni hne̱je̱, bi ña̱ rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Diguebbʉ ya, car Jesús bi xih cʉ cja̱hni cʉ már bbʉh pʉ, már cca̱htijʉ, jin di ngöxtejʉ. Nu gueguejʉ, ca más mír xih car Jesús jin di ngöxtejʉ, más mír tʉnguijʉ car jña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Cja̱ bi ndo hño í mʉy cʉ cja̱hni‑cʉ́, bi ma̱jmʉ: ―Rá tzi zö yʉ milagro yʉ i øti nʉr Jesús. Rá ndo ngu̱ yʉ cja̱hni xí jojqui. Guegue i xojquibi yí gu̱ yʉ to jin gui øde, cja̱ yʉ ngone, i cjajpi da ña̱ rá zö.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Cʉ pa‑cʉ, már ndo ngu̱tsjɛ cʉ cja̱hni cʉ mí tɛnijʉ car Jesús. Ya xquí dejʉ pʉ jabʉ már bbʉ guegue, cja̱ jin te mí pɛhtzi te di zijʉ. Nubbʉ, car Jesús bi nzoh quí möxte, bi xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Dí jui̱jquigö yʉ cja̱hni rá ngu̱ yʉ xí ndɛngui. Ya xí nzʉ jñu̱jpa xí ndøhmi ya, cja̱ jin te i pɛhtzi pa da zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cja̱ bbʉ gu cu̱jmʉ, da ma í ngu̱jʉ, cja̱ jin gui tzijʉ, da ma drí ngüentijʉ pʉ jar hñu̱, porque i bbʉj yʉ ddaa, ndo yanʉ xcuí hñe̱jmʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Cja̱ bi da̱j ya quí möxte, bi dyönijʉ: ―u̱jtjo cʉ dɛnda hua jabʉ dí bbʉpjʉ. Guejtjo hne̱je̱ jin te i bbʉ ngu̱. ¿Jabʉ gu tötijʉ tju̱jme̱ drá ngu̱ pa da ñi̱ña̱ göhtjo yʉ cja̱hni‑yʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nu car Jesús bi dyön quí möxte: ―¿Tengu̱ tju̱jme̱ guí pɛhtzijʉ?― Cja̱ bi ma̱jmʉ: ―Yojto.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nubbʉ, car Jesús bi bbɛjpi car ndo jmu̱ndo cʉ cja̱hni di mi̱pjʉ jöy. Cja̱ guegue bi zɛti cʉ yojto tju̱jme, bi dyöjpi cjama̱di ca Ocja̱, ma ya bi xɛjqui. Diguebbʉ ya, bi un quí möxte, cja̱ nucʉ, bi jña̱jʉ, bi møhmpijʉ cʉ cja̱hni rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mí pɛhtzijʉ hne̱je̱ tengu̱ tzi möy, cja̱ car Jesús pé bi dyöjpi mpöjcje ca Ocja̱ digue cʉ tzi möy. Diguebbʉ ya, pé bi un quí möxte cja̱ guegue‑cʉ bi møhmpijʉ cʉ cja̱hni hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Cja̱ göhtjo cʉ cja̱hni bi zijʉ, bi ñi̱ña̱jʉ rá zö. Ma ya, quí möxte car Jesús bi jmu̱ntzijʉ cʉ tzi pedazo cʉ xquí sobra, bi ñu̱htzijʉ yojto bbøtze rá nojo. ");
INSERT INTO otsNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cja̱ mí bbʉ como go mil cʉ cja̱hni cʉ bi zijʉ. Diguebbʉ ya, car Jesús bi gu̱h cʉ cja̱hni di ma í ngu̱jʉ, ");
INSERT INTO otsNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","cja̱ guegue ya bi ñʉti jar barco, bi mɛhui quí möxte. Ncjapʉ gá nzøtijʉ jar lugar ca mí tsjifi Dalmanuta. ");
INSERT INTO otsNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Diguebbʉ ya bú e̱h cʉ dda cja̱hni cʉ mí tsjifi fariseo, bi guatijʉ car Jesús pa di dyøhtibijʉ hnar prueba. Bi mʉdi bi mbömbihui palabra car Jesús. Bi dyöjpijʉ car Jesús di u̱jti hnar milagro drí hñe̱ ji̱tzi, como jí̱ mí e̱me̱jʉ, ¿cja xcuí hñe̱h ca Ocja̱ car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nu car Jesús bi ntzøte, bi ungui ʉr du̱mʉy, como mí pa̱di, jí̱ mí ne di hñeme cʉ fariseo. Cja̱ bi xijmʉ: ―Nuquɛjʉ, guí cja̱hnijʉ guí bbʉpjʉ yʉ pa ya, ¿dyoca̱ dé guí öjquijʉ gu øti milagro pa gui pa̱dijʉ, jabʉ xtá e̱jcö? Dí xihquijʉ ntju̱mʉy, jin tema milagro gu u̱jtiquijʉ pa gui pa̱dijʉ jabʉ xtá e̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cja̱ bbʉ xquí ma̱ na̱r palabra‑ná̱, car Jesús bi wem pʉ, bi zoh cʉ fariseo, pé bi ñʉti jar barco, cja̱ pé bi ddax car mar. Pé bi ma gá ma hnanguadi, bi mɛhui quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nu quí möxte car Jesús bbʉ mí ñʉtijʉ jar barco jin gá ngʉxjʉ tju̱jme̱ pa di zijʉ, bi da̱be̱nitjojʉ. Hnaatjo ʉr tzi tju̱jme̱ bi jña̱xjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Cja̱ bbʉ már bbʉjtijʉ jar barco, car Jesús bi xih quí möxte: ―Gui mfödijʉ, jin gui ma gui jña̱jʉ car levadura ca rí hñe̱h cʉ fariseo, cja̱ co cʉ cja̱hni cʉ i tɛnijʉ car Herodes.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bbʉ mí dyøj ya nʉr palabra‑nʉ, bi hñöntsjɛjʉ qui amigo, ¿te mí ne di ma̱n car palabra‑cá̱? Ngá ma̱jmʉ, pé ntoja mí nesta di döjmʉ tju̱jme̱, como jin te xcuí gʉjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nu car Jesús bi dyøde te már ma̱jmʉ, cja̱ bi dyöni: ―¿Dyoca̱ guí i̱na̱jʉ dí xihquijʉ guí nesta gui töjmʉ tju̱jme̱? ¿Cja̱ jí̱ bbe guí ntiendejʉ ter bɛh ca̱ dí xihquijʉ? ¿Cja jí̱ bbe guí ja̱jʉ ʉr huɛnda ja ncja ca dí u̱jtiquijʉ? ¿Cja nttzɛditjo guí me̱mʉyjʉ? ");
INSERT INTO otsNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Cja jin guí cca̱htijʉ te dí øtigö? ¿Cja jin guí øjmʉ car palabra ca dí ma̱ngö? ¿Cja huá ya xcú da̱be̱nijʉ ja mí ncja cʉ milagro xcú cca̱jtiguijʉ xtú øte? ");
INSERT INTO otsNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Cja jin guí mbe̱nijʉ ya, bbʉ ndú jejqui cʉ cʉtta tju̱jme̱, cja̱ gú pøhmpijʉ cʉ cja̱hni cʉ cʉtta mil, cja̱ diguebbʉ ya gú jmu̱ntzijʉ cʉ tzi pedazo cʉ xquí sobra, tengu̱ bbøtze bi ñu̱tzi?― Cja̱ bi da̱j ya quí möxte: ―Bi ñu̱xi doce bbøtze.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Cja̱ pé bi dyön car Jesús: ―Guejtjo, bbʉ ndú jejqui cʉ yojto tju̱jme̱, cja̱ gú pøhmpijʉ cʉ cja̱hni cʉ go mil, cja̱ diguebbʉ ya pé gú jmu̱ntzijʉ cʉ tzi pedazo cʉ xquí sobra, ¿cja jin guí mbe̱nijʉ hne̱je̱ tengu̱ bbøtze rá nojo bi ñu̱xi bbʉ́?― Cja̱ pé bi da̱h quí möxe: ―Bi ñu̱xi yojto bbøtze.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pé bi ma̱n car Jesús, bbʉ: ―¿Cja jí̱ bbe guí pa̱dijʉ, jin gui gue car tju̱jme̱ xtú xihquijʉ jin gui jña̱mpijʉ cʉ fariseo?― Ncjapʉ gá ma̱n car Jesús, jin di hñe̱me̱jʉ ca mí u̱jti cʉ fariseo. ");
INSERT INTO otsNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ma ya, car Jesús bi zøti pʉ hnar jñi̱ni ca mí tsjifi Betsaida. Cja̱ cʉ mi̱ngu̱ pʉ bú tzí hnar godö, bi dyöjpi car Jesús di xojquibi quí dö. ");
INSERT INTO otsNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nubbʉ́, car Jesús bi pɛntibi cár dyɛ car godö, bi gʉjqui pʉ jar jñi̱ni gá ma hnanguadi. Diguebbʉ ya, bi gohtzibi cár cji̱jni jáy dö car godö, cja̱ bi dyʉx quí dyɛ. Nubbʉ́, bi dyöni: ―¿Cja ya xquí tzi janti ya?― ");
INSERT INTO otsNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nubbʉ́, bi jani car godö cja̱ bi ma̱: ―Dí janti yʉ dda cja̱hni, i ne da jñɛjmi za, pe nuyʉ́, i dyo.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma ya car Jesús pé bi dyʉx quí dyɛ jáy dö car godö. Nubbʉ́, bi joh quí dö car hñøjø cja̱ bi cca̱hti rá zö. Cja̱ bi jianti rá tzi zö göhtjo, hasta cʉ cosa cʉ már bbʉ yanʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Diguebbʉ ya, car Jesús bi bbɛjpi di má ʉ́r ngu̱, bi xifi jim pé di ñʉti nʉ jar jñi̱ni, cja̱ jin di göx cʉ cja̱hni toca̱ xquí jojquibi quí dö. ");
INSERT INTO otsNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Diguebbʉ ya, pé bi bøn car Jesús, pé má yojmi quí möxte. Bi ma gá ma jar jöy ca mí tsjifi Cesarea de Filipo. Má tjojmʉ pʉ cʉ tzi jñi̱ni cʉ mí bbʉh pʉ. Cja̱ bbʉ má pöjmʉ jar hñu̱, car Jesús má ña̱hui quí möxte, cja̱ bi dyön‑cʉ́: ―¿Te i ma̱n yʉ cja̱hni diguejquigö? ¿Te ʉm oficiogö?― ");
INSERT INTO otsNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Cja̱ bi da̱j ya‑cʉ: ―I bbʉh cʉ ddaa cʉ i ma̱jmʉ, guehquɛ gúr Juan ca mí xix yʉ cja̱hni. øde, bi bböjtiqui, cja̱ nuya pé xcú nantzi. I bbʉh cʉ pe ddaa cʉ i ma̱jmʉ, guehquɛ gúr profeta Elías. Guejtjo i bbʉh cʉ pe ddaa cʉ i ma̱ndijʉ, gúr profeta, guehquiguɛ hnáa quí jmandadero ca Ocja̱ cʉ mí bbʉ ya má yabbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Cja̱ car Jesús pé bi dyön quí möxte: ―¿Xiquiguɛjʉ, toca̱ guí ma̱jmʉ guejquigö?― Cja̱ bi da̱h car Pedro, bi xifi: ―Nuquiguɛ, gúr Cristo‑guɛ. Ndí tøpiquije, dí cja̱hnitjoje, du bbɛnquiguɛ hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nu car Jesús, bbʉ mí dyøj nʉr palabra‑nʉ, bi xih quí möxte, jin di ngöxtejʉ, ¿cja guegue mí gue car Cristo? ");
INSERT INTO otsNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma ya, car Jesús bi mʉdi bi u̱jti quí möxte, mí nesta guegue di sufri rá ngu̱ cja̱ di bböhti, como guehcá̱ di ncjajpi car cja̱hni ca di bbɛjni hua jar jöy. Nu cʉ tita cʉ mí pɛhtzi quí cargo, co cʉ möcja̱ cʉ mí mandadobi cʉ pé ddaa, cja̱ co hne̱h cʉ maestro cʉ mí nxöh car ley, göhtjo gueguejʉ di gønijʉ car Jesús, cja̱ di mandadojʉ pa di bböhti. Cʉ cja̱hni‑cʉ́ di ma̱jmʉ, jí̱ mí gue car Cristo ca xtrú hñi̱x ca Ocja̱. Nu car Jesús bi xih quí möxte, bbʉ ya xtrú ndu̱ guegue, pé di jña̱ ʉ́r jná̱ ca xtrá jñu̱jpa. ");
INSERT INTO otsNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Car Jesús, rá zö gá xih quí möxte nʉr palabra‑nʉ, pa di ntiendejʉ. Cja̱ bbʉ mí dyøh car Pedro, mír ma̱n car Jesús mí nesta di bböhti, guegue bi zitzi, gá mɛtsjɛhui hnanguadi, cja̱ bi xifi: “¿Dyoca̱ guí ma̱ i nesta gui tu̱?” Ncjahmʉ bi huɛnti car Pedro, ca gá ma̱ ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nu car Jesús pe bi bböti, bi jianti cʉ pe dda quí möxte cʉ mí tɛni, cja̱ bi huɛnti car Pedro, bbʉ, bi xifi ncjahua: ―Nuquɛ, Pedro, dyo guí xijqui ncjanʉ. Guí yojmi car Satanás. Jin gu øjti nʉr palabra xcú xijqui, como jí̱ xcuá hñe̱h ca Ocja̱ quer mfe̱ni. ʉ́r mfe̱nitjo hnar cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma ya car Jesús bi nzoh quí möxte co cʉ pe dda cja̱hni cʉ mí tɛni, cja̱ bi xijmʉ: ―Nuquiguɛjʉ, bbʉ to i ne da dɛngui, da ncjá ncja ngu̱guigö, ya jin da hmʉjtsjɛ, cja̱ jin da möjtsjɛ cár vida. Da dɛngui, masque da sufri ncjaguigö gár sufrigö bbʉ xta bböjtigui. ");
INSERT INTO otsNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Car cja̱hni ca jin gui ne da dɛnguigö, como i ne da möjtsjɛ cár vida, da bbɛdi. Nu car cja̱hni ca i ne da dɛnguigö cja̱ da hñe̱me̱ nʉr tzi ddadyo jña̱ nʉ dá ja̱gö, masque xín da bbɛh cár vida por rá nguejquigö, guegue da döti car nzajqui ca ntjumʉy rá zö. ");
INSERT INTO otsNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ter bɛh ca̱ da sirvebi hnar cja̱hni bbʉ da cjajpi ʉ́r mɛjti göhtjo yʉ te i bbʉjcua jar mundo, pe bbʉ xta zøh car pa bbʉ xta du̱, nde̱jma̱ da bbɛh cár tzi mʉy? ");
INSERT INTO otsNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jin gui bbʉh car manera ja grá cju̱tijʉ domi pa jin da bbɛj yʉm tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yʉ pa ya, i bbʉj yʉ to jin gui ne da dɛnguigö, porque i pɛhtzibi ʉ́r tzö yʉ pe dda cja̱hni, cja̱ nuyʉ, jin gui e̱me̱ ca Ocja̱, cja̱ i øti ca rá nttzo. Ca to jin gui ne da dɛngui cja̱ jin gui ne da dyøj yʉm palabra, porque i pɛhtzi ʉ́r tzö, bbʉ pé xcuá e̱cö, xtá ma̱ngö jin te ʉm ncjagöbbe car cja̱hni‑ca̱. Bbʉ xcuá coji, xcuá yobbe quí anxe cʉ i pɛjpi cam Tzi Ta, cja̱ da ni̱gui te tza ngu̱ cár ttzɛdi. Nugö, dúr cja̱hni, xpá mɛnqui hua jar jöy.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Car Jesús guejtjo bi xih quí möxte: ―Cierto, dí xihquijʉ, i bbʉjcua yʉ dda cja̱hni yʉ jin da du̱ hasta gue bbʉ xtrú cca̱htijʉ bbʉ xta mandado ca Ocja̱ hua jar jöy, göhtjo co ni cár ttzɛdi.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cja̱ diguebbʉ ya, pé ddajto mpa, car Jesús bi zix car Pedro co car Jacobo co car Juan, jøña̱‑cʉ. Bi zitzi gá möjmʉ hnar ttøø, már ndo nte. Cja̱ car Jesús bi hna mböjti ca mír ni̱gui, hnahño gá ni̱gui. ");
INSERT INTO otsNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mí juɛx quí da̱jtu̱ már tzi nttaxi, ncja ngu̱ yʉ xicja. Jin gui bbʉh hnar cja̱hni hua jar jöy di pa̱di di cjajpi cʉ da̱jtu̱ drá ndo nttaxi pa di ni̱gui ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Guejtjo bi ni̱gui pʉ jar ttøø car Elías co car Moisés, xcuí hñe̱j nʉ ji̱tzi, cja̱ már ña̱hui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Cja̱ bbʉ mí cca̱hti car Pedro cʉ jñu̱ hñøjø már ña̱jʉ, bi xih car Jesús: ―Nuquɛ, maestro, rá zö dar hmʉpjʉ hua. Gu øtije jñu̱ cʉ ddøxingu̱ gá dyɛza, ca hnaa pa guehquɛ, pé hnaa nʉr Moisés, cja̱ ca pé hnaa ya nʉr Elías.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bi hna ma̱ ncjapʉ car Pedro, porque jí̱ mí pa̱di te di ma̱. Mí ndo ntzu̱ cʉ jñu̱ möxte por rá ngue ca mí cca̱htijʉ, cja̱ mí ndo dyo quí mfe̱nijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Diguebbʉ ya, bú e̱h hnar gu̱y, bi gu̱jti gueguejʉ göhtjo, bi gohmijʉ cár xu̱mʉy. Cja̱ quí möxte car Jesús bi dyødejʉ hnar jña̱ mbí ña̱ pʉ mbo car gu̱y, mí ma̱: ―Gue nʉm Ttʉgö‑nʉ, dí ma̱di. Gui dyødejʉ ca i ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Diguebbʉ ya bi jani quí möxte, cja̱ bi jiantijʉ, ya xi már ddatsjɛ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cja̱ bbʉ mbá ca̱jmʉ pʉ jar ttøø, car Jesús bi ccax quí möxte, bi xijmʉ jin di ngöxte te xcuí cca̱htijʉ pʉ jar ttøø hasta gue bbʉ ya xtrú ndu̱ guegue cja̱ pé xtrú jña̱ ʉ́r jña̱. Bi xijmʉ, guegue mí gue car cja̱hni ca xcuí bbɛjni hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nu quí möxte bi ndo mbe̱n car palabra ca xquí tsjijmʉ, cja̱ bi hñöntsjɛjʉ, ¿te mí ne di ma̱n car palabra, bbʉ ya xtrú ndu̱ guegue cja̱ pé xtrú jña̱ ʉ́r jña̱? Pe jin gá ngöxtejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma ya, gueguejʉ bi dyönijʉ car Jesús nʉr nttöni‑nʉ: ―¿Te rá nguehca̱ i ma̱n cʉ maestro cʉ i u̱jtiguije car ley, i i̱na̱jʉ, i nesta bbɛto du e̱h car profeta Elías, cja̱ diguebbʉ ya pé xtu e̱h car cja̱hni ca da hñi̱x ca Ocja̱ pa da mandadoguije?― ");
INSERT INTO otsNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bi da̱j ya car Jesús, bi xih quí möxte: ―Cierto car palabra‑ca̱. Bbɛto ba e̱h car Elías pa da nzoj yʉ cja̱hni, sa̱nta̱ da jojqui quí tzi mʉyjʉ pa drí ntjɛjʉ ca hnaa. Xiquiguɛjʉ, ¿cja guí pa̱dijʉ te i ma̱n cʉ Escritura digue car hñøjø ca di hñi̱x ca Ocja̱ cja̱ du pɛjni hua jar jöy? I ma̱n cʉ Escritura, guegue da nesta da sufri rá ngu̱, jin da tti̱htzibi, cja̱ jin da tte̱me̱. ");
INSERT INTO otsNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nugö, dí xihquijʉ, ya xpá hñe̱h ca hnár jmandadero ca Ocja̱ ca xí ngo ʉ́r lugar car Elías. Nu yʉ cja̱hni xí möhtijʉ. Xí cjajpijʉ como ngu̱ ga ma̱m pʉ jar Escritura di ncjajpi.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Diguebbʉ ya, car Jesús co ni cʉ jñu quí möxte cʉ xquí zitzi, bi zøtijʉ pʉ jabʉ már bbʉ cʉ pe ddaa, bi cca̱htijʉ hnar ndo jmundo cʉ cja̱hni. Nucʉ, xquí hñi̱ti madé quí möxte car Jesús. Guejtjo már bbʉh pʉ cʉ dda maestro cʉ mí u̱jti cʉ cja̱hni car ley. Gueguejʉ már huɛnihui quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nguetica̱ cʉ cja̱hni rá ngu, bbʉ mí jiantijʉ car Jesús, ya xi mbá e̱je̱, bi ndo mpöjmʉ, bi gʉjʉ ʉr ddiji, bi ma bú ntjɛjʉ cja̱ bi zɛnguajʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nubbʉ, car Jesús bi dyön quí möxte: ―¿Ter bɛh ca̱ már önquijʉ yʉ maestro?― ");
INSERT INTO otsNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cja̱ bi da̱h ca hnaa digue cʉ cja̱hni cʉ xquí jmuntzi pʉ: ―Nuquɛ, Maestro, xtú tzí nʉm ttʉ hua jabʉ guí bbʉy, i yojmi hnar nda̱ji̱ ca jin gui tzö, jin gui jɛgui da ña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pʉ jabʉ i dyo nʉm ttʉ, i hna enti car ttzonda̱ji̱ i cjajpi da fʉj nʉ́r ne cja̱ da ndo gu̱xti quí ttzafi. Cja̱ ya xtú öjpi yir möxte di fongui tzʉ car ttzonda̱ji̱‑ca̱, pe jí̱ xcá hñemebijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Diguebbʉ ya bi da̱h car Jesús, bi xih cʉ cja̱hni: ―Nuquiguɛjʉ, ¿dyoca̱ jin guí e̱me̱jʉ, rá nzɛh ca Ocja̱ pa da möxquijʉ? Ya xná ngu̱ tiempo xtú hmʉpjʉ. ¿Cja jim be guí e̱me̱jʉ? Ya jin gu tzɛjti ca guí cjaguijʉ. Bú tzijʉ hua car ba̱jtzi ya.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nubbʉ́, bú ttzimpi car ba̱jtzi hñøjø. Cja̱ cár nda̱ji̱ ca Jin Gui Tzö, bbʉ mí cca̱hti car Jesús, bi cjajpi car ba̱jtzi bi ndo jua̱, cja̱ nuca̱ bi fʉntzi, bi ndo mbʉntzi jar jöy, mí ndo fʉh cár ne. ");
INSERT INTO otsNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Car Jesús bi dyön cár ta car ba̱jtzi: ―¿Tengu̱ tiempo i ncjanʉ nir ba̱jtzi?― Cja̱ bi da̱j ya cár ta: ―Desde bbʉ mí chi tchʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Rá ngu vez xí dyenti jar tzibi, o bbʉ ji̱na̱, guehpʉ jar deje. Ngu̱ i ne da möhti. Pe bbʉ guí pa̱di te gui cjajpi nʉm ttʉ, gui jui̱guije, cja̱ gui föxquije tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Cja̱ bi da̱j ya car Jesús: ―Ja̱a̱, dí pa̱di gu jojqui, pe guehquɛ, i nesta gui hñeme göhtjo mbo ir mʉy. Ca to i e̱me̱ ca Ocja̱, ca te da dyödi, da ttøhtibi.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Diguebbʉ ya, cár ta car ba̱jtzi bi ña̱ nzajqui, bi da̱di: ―Nugö, dí tzi e̱me̱. Gui föxqui tzʉ pa gu e̱me̱ göhtjo mbo ʉm mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nu car Jesús, bbʉ mí cca̱hti, ya xi mbá ndo cuati cʉ cja̱hni már ngu̱, bi huɛnti cár nda̱ji̱ ca Jin Gui Tzö, bi xifi ncjahua: ―Nuquiguɛ, gúr ttzonda̱ji̱, gúr ngone cja̱ gúr gogu̱. Nuya, dí xihqui gui pøm pʉ jabʉ grá bbʉy, cja̱ ya jim pé gui yojpi gui cʉti mbo ʉ́r mʉy nʉr ba̱jtzi.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nubbʉ, car ttzonda̱ji̱ bi ndo mafi, cja̱ bi jua̱ti nzajqui car ba̱jtzi hñøjø. Diguebbʉ ya, bi bøni, cja̱ ya jí̱ mí hña̱n car ba̱jtzi, bi goji ncjahmʉ ya xquí du̱. Már ngu̱ cʉ cja̱hni cʉ már cca̱htijʉ, bi ma̱jmʉ: “Ya xí ndu̱‑nʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nu car Jesús bi zɛtibi cár dyɛ car ba̱jtzi hñøjø, bi xotzi cja̱ guegue‑ca̱ bi bböy. ");
INSERT INTO otsNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Diguebbʉ ya car Jesús bi mɛhui quí möxte, bi ñʉtijʉ hnar ngu̱. Cja̱ como már bbʉjtsjɛjʉ pʉ, quí möxte car Jesús bi dyönijʉ guegue: ―Xigöje, ¿dyoca̱ jí̱ xcá hñemeguije car ttzonda̱ji̱ ca xtá bbɛjpije di bøni?― ");
INSERT INTO otsNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Cja̱ car Jesús bi da̱di: ―Car nda̱ji̱‑ca̱ co cʉ pe dda ttzonda̱ji̱ cʉ i jñɛjmi, jin gui ne da bønijʉ. Ca to i ne da fongui‑cʉ, i nesta da ayuna cja̱ da dyöjpi ca Ocja̱ pa da mötzi.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Diguebbʉ ya, bi bøm pʉ jar lugar‑ca̱ car Jesús, mí yojmi quí möxte, má tjojmʉ jar estado Galilea. Nu car Jesús mí ne pa jin to di ba̱di jabʉ mír ma. ");
INSERT INTO otsNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Como mí ne di xih quí möxte ter bɛh ca̱ di ncjajpi guegue, mí ne jøntsjɛ‑cʉ di hmʉbi. Mí xijmʉ, ya xti ttzʉ guegue, di ndöjti jáy dyɛ quí contra, cja̱ di bböhti. Pe bbʉ ya xtrú ndu̱, pé di jña̱ ʉ́r jña̱ ca xtrá jñu̱jpa. Guejtjo bi xijmʉ, guegue mí gue car cja̱hni xcuí bbɛjni hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nu quí möxte car Jesús jin gá ntiendejʉ te mí ne di ma̱. Guejtjo jin gá dyöjpijʉ di xijmʉ rá zö ter bɛh ca̱ mí ne di xijmʉ, como mí pɛhtzi ʉ́r tzöjʉ di dyönijʉ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma ya bi zønijʉ jar jñini Capernaum, cja̱ bbʉ ya xquí ñʉtijʉ cár ngu̱, car Jesús bi dyön quí möxte: ―¿Ter bɛh ca̱ ngrí huɛnijʉ bbʉ ndá dyojʉ jar hñu̱?― ");
INSERT INTO otsNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nu gueguejʉ ya, jin te gá nda̱dijʉ, como bbʉ mbá e̱jmʉ jar hñu̱, mbá huɛnijʉ toca̱ más di jña̱ cár cargo cja̱ di mandadobi cʉ pe ddaa. ");
INSERT INTO otsNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nubbʉ, car Jesús bi mi̱jöy, cja̱ bi nzoh quí möxte, bi xijmʉ: ―Ca to i ne da mandado, guegue da cjajpi quí jmandado cʉ pe ddaa, da ncjá ncja hnar muzo.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ma ya car Jesús bú tzí hnar tzi ba̱jtzi ca már bbʉh pʉ cerca, bi hñi̱ti madé quí möxte cja̱ bi xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Car cja̱hni ca i e̱me̱gui cja̱ da möxi hnar tzi ba̱jtzi ncja ngu̱‑na̱ por rá nguejquigö, jin gui jøña̱ car tzi ba̱jtzi i fötzi. Ncjahmʉ guejquigö di föxquigö hne̱je̱. Cja̱ bbʉ to i föxquigö cja̱ i negui, guejtjo i ne car Tzi Ta ji̱tzi ca xpá mɛnquigö.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Diguebbʉ ya, bi ma̱n ca hnar möxte ca mí ju̱ cár tju̱ju̱ múr Juan, bi xih car Jesús: ―Nuquɛ, maestro, xtú ntjɛje hnar hñøjø, mí fongui ttzonda̱ji̱ cja̱ mí nømbiqui quer tzi tju̱ju̱. Nu car cja̱hni̱‑ca̱, jin gui tɛnguijʉ, eso dú ccahtzije, dú xijme di jiɛh ca mír dyøti‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Cja̱ bi ma̱n ya car Jesús: ―Jí̱ mír ntzöhui güi ccahtzijʉ, porque ca to i nømbigui cam tju̱ju̱ cja̱ por rá nguejquigö i øti milagro, jin gʉm contragö‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Car cja̱hni ca jin gui contragui, i ne da möxquigö. ");
INSERT INTO otsNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cja̱ bbʉ to te da ddahquijʉ por rá nguehca̱ guír tɛnguijʉ, má̱di hna vaso ʉr tzɛtje, car Tzi Ta ji̱tzi da bendeci car cja̱hni‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Gui jña̱jʉ ʉr huɛnda, jin to gui ma gui jiötijʉ pa da dyøti ca rá nttzo. Bbʉ to da jiöti hnar cja̱hni ca cja i fʉdi da dɛngui pa da dyøti ca rá nttzo, guegue da ttun hnar castigo drá ndo ji̱tzi. Más di joh bbʉ di hna̱ti hnar cjʉʉni jár dyʉga cja̱ di ttɛnti nʉ jar deje nʉ jabʉ rá ndo je̱, cja̱ jin di jiöti cár hñohui ca cja i fʉdi da hñemegui pa da dyøti ca rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Guejtiquiguɛjʉ, gui jña̱jʉ ʉr huɛnda hne̱je̱ pa jin gui dyøtijʉ ca rá nttzo. Bbʉ da jiöhqui ca hner dyɛ pa gui dyøti ca rá nttzo, gui jiɛh ca guír dyøte. Más di joh bbʉ güi dyojqui quer dyɛ cja̱ jin güi dyøti ca rá nttzo, como más da joh bbʉ gui cʉti pʉ jabʉ i bbʉh ca Ocja̱, gur ntchodyɛ, ni ndra ngue bbʉ da ttɛntiqui pʉ jabʉ jin gui tzö, göhtjo co yojo yir dyɛ, cja̱ grí sufri pʉ jar tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Cʉ cja̱hni cʉ da ttɛnti pʉ jabʉ jin gui tzö, jin da tzöya ca drí sufrijʉ göhtjo ʉr tiempo, como i zø pʉ car tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ncjadipʉ, bbʉ da jiöhqui ca hner hua pa gui dyøti ca rá nttzo, jin gui ma gui dyøte. Más di joh bbʉ güi dyojqui quer hua cja̱ jin güi dyøti ca rá nttzo, como más da joh bbʉ gui cʉti pʉ jabʉ i bbʉh ca Ocja̱ gur ntchohua, ni ndra ngue bbʉ da ttɛntiqui pʉ jabʉ jin gui tzö, göhtjo co yojo yir hua, cja̱ grí sufri pʉ jar tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Cʉ cja̱hni cʉ da ttɛnti pʉ jabʉ jin gui tzö, jin da tzöya ca drí sufrijʉ göhtjo ʉr tiempo, como i zø pʉ car tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Guejtjo bbʉ da jiöhqui hner dö pa gui dyøti ca rá nttzo, gui jiɛj ya ca grí dyøte. Más di joh bbʉ güi jña̱hmi quer dö güi dyɛy cja̱ ya jin güi dyøti ca rá nttzo, como más da joh bbʉ gui cʉti pʉ jabʉ i bbʉh ca Ocja̱ co hnaatjo quer dö, cja̱ jin da ttɛntiqui pʉ jabʉ jin gui tzö, göhtjo co yojo yir dö. ");
INSERT INTO otsNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cʉ cja̱hni cʉ da ttɛnti pʉ, jin da tzöya ca drí sufrijʉ göhtjo ʉr tiempo, como i zø pʉ car tzibi ca jin gui jui̱ti. ");
INSERT INTO otsNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","I nesta gu xöjpi nʉm cuerpojʉ da sufri pa jin da da̱guijʉ ca rá nttzo. Cada hnaagöjʉ gu sufrijʉ ante que gu tzønijʉ pʉ jabʉ bí bbʉh ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Rá ndo zö nʉr u̱, i ndo sirve. Pe bbʉ jin gui u̱xi car u̱, ¿te gui cjajpi pa pé da u̱xqui? u̱jtjo. Nuquiguɛjʉ, i nesta gui ncjajʉ ncja car u̱ ca rá u̱xi pa ncjapʉ grí hmʉpjʉ rá zö, cja̱ da fa̱di ʉm cja̱hni̱quiguɛjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Diguebbʉ ya, car Jesús bi bøm pʉ jar jñi̱ni Capernaum, bi ma gá ma jar estado Judea. Guejtjo bi ma jar jöy ca mír hmʉj nʉ rí ncjanʉ car da̱tje Jordán. Cja̱ pé bi jmuntzi cja̱hni rá ngu̱, bi dɛnijʉ car Jesús, cja̱ guegue bi u̱jti cár palabra ca Ocja̱, ncja ngu̱ nguá dyøte cada bbʉ mí jmu̱ntzi cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nubbʉ́, bi zøh cʉ dda fariseo, bi guati pʉ jabʉ már bbʉh car Jesús. Mí ne di dyøhtibijʉ hnar prueba, eso bi dyönijʉ: ―¿Cja i ttuni ʉr tsjɛjqui hnar hñøjø da weguehui cár bbɛjña̱, da gu̱y?― ");
INSERT INTO otsNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nu car Jesús bi da̱di: ―¿Te i ma̱m pʉ jar ley ca bi dyøti car Moisés?― ");
INSERT INTO otsNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cja̱ bi ma̱jmʉ: ―Car Moisés i ungui ʉr tsjɛjqui hnar hñøjø di xoxi hnar jɛhmi pa da weguehui cár bbɛjña̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nubbʉ́, pé bi ma̱n car Jesús: ―Guegue car Moisés bi dyøjtiquijʉ nʉr mandamiento nʉ́ jøntsjɛ porque bi cca̱hti, rá ndo me̱ quir tzi mʉyjʉ. Eso, bi ddahquijʉ ʉr tsjɛjqui gui weguehui quer bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero desde bbʉ mí mʉj nʉr mundo, ca Ocja̱ bi dyøti hnar hñøjø cja̱ bi uni hnár bbɛjña̱ pa di hmʉbi. ");
INSERT INTO otsNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bi ma̱ guegue: “Hnar hñøjø da zoh cár ta, co cár me, cja̱ da zix cár bbɛjña̱, da hmʉbi. ");
INSERT INTO otsNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nu cʉ mí yojo, da cja hnatjo ya.” Por eso, ya jin da weguehui, nuya da hmubi. ");
INSERT INTO otsNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cʉ yojo cʉ xí pɛjni ca Ocja̱ pa da cja hnatjo, jin gui ne guegue pa to da juejque.― Ncjanʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Diguebbʉ ya, bbʉ ya xquí ñʉti car Jesús pʉ mbo car ngu̱, quí möxte pé bi dyöni ¿cja rá zö bbʉ to da weguehui cár bbɛjña̱? ");
INSERT INTO otsNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Cja̱ car Jesús bi xijmʉ: ―Hnar hñøjø ca ya xí ntja̱jti, bbʉ da weguehui cár bbɛjña̱ cja̱ pé da ntja̱jtihui pe hnaa, i øhtibi ca rá nttzo ca bbɛto ʉ́r bbɛjña̱. I pøni ncjahmʉ xí yohti bbɛjna̱. ");
INSERT INTO otsNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Guejti hnar bbɛjña̱ ca ya xí ntja̱jti, bbʉ da weguehui cár da̱me cja̱ pé da ntja̱jtihui pe hnaa, i øhtibi ca rá nttzo ca bbɛto ʉ́r da̱me, ncjahmʉ xí yohti da̱me.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Diguebbʉ ya, bú e̱h cʉ dda cja̱hni, mbá tzí quí tzi ba̱jtzi pʉ jabʉ már bbʉh car Jesús pa di dyʉx quí dyɛ, di bendeci. Nu quí möxte car Jesús bi huɛntijʉ cʉ cja̱hni cʉ mbá tzí quí ba̱jtzi, mí ne di ccahtzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nu car Jesús, bbʉ mí dyøde te mí ncja, bi ungui ʉr cuɛ, cja̱ bi xih quí amigo: ―Gui jiɛjmʉ yʉ tzi ba̱jtzi du e̱cua jabʉ dí bbʉy, dyo guí ccahtzijʉ. Cam Tzi Ta ji̱tzi xí ungui ʉr tsjɛjqui cʉ cja̱hni cʉ i ncjajʉ ncja ngu̱ yʉ tzi ba̱jtzi da hmʉh pʉ jabʉ i mandado guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cierto, dí xihquijʉ, ca to jin da guati jár dyɛ ca Ocja̱ pa da jñɛgui da mandadobi, ncja ngu̱ hnar tzi ba̱jtzi ga jñɛgui da hmɛjpi jmandado, jin da ñʉti guegue pʉ jabʉ i mandado ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Diguebbʉ ya, car Jesús bi dɛx cʉ tzi ba̱jtzi, bi dyʉx quí dyɛ, cja̱ bi mahtibi ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Diguebbʉ ya, car Jesús bi bøm pʉ, má pa jar hñu̱. Cja̱ bú e̱h hnar ba̱jtzi hñøjø, bú cjʉ ʉr ddiji, bi guati guegue. Bi nda̱ndiña̱jmu̱ pʉ jáy hua car Jesús, cja̱ bi dyöni: ―Nuquiguɛ, Maestro, rá ndo zöquiguɛ, ¿ter bɛh ca̱ gu øte pa gu töti car nzajqui ca jin da tjegue?― ");
INSERT INTO otsNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nu car Jesús bi da̱jti: ―¿Te rá nguehca̱ guí xijqui rá ndo zöguigö? Jin te i bbʉ cja̱hni drá ndo zö, ddatsjɛ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ya xquí pa̱di te i ma̱n cʉ mandamiento cʉ xí ddajquijʉ ca Ocja̱. I ma̱ ncjahua: “Jin gui pöhtite. Jin gui jiöhtibi cár bbɛjña̱ pe hnar hñøjø, ni digue cár da̱me pe hnar bbɛjña̱. Jin gui mpe̱. Jin gui ña̱jquibi bbɛtjri quer mi̱nga̱‑cja̱hnihui. Jin gui jöjte. Gui hñi̱htzibi quer ta hne̱h quer me.”― ");
INSERT INTO otsNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nubbʉ, bi da̱jti car hñøjø, bi ma̱: ―Nuquɛ, Maestro, göhtjo yʉ mandamiento‑yʉ xtú øte desde bbʉ ndúr ba̱jtzitjo.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Car Jesús ya bi ju̱dö, cja̱ bi ma̱di. Diguebbʉ ya bi xifi: ―I bbɛjti hnar cosa pa gui dyøte. Gui ma ya, bú pö göhtjo cʉ guí pɛhtzi, cja̱ gui jejquibi car domi cʉ tzi probe. Nubbʉ́, cja da jogui pé gu e̱je̱ gui tɛnguigö. Bbʉ gui dyøte ncjapʉ, xquí pɛhtzi ca ntju̱mʉy rá zö pʉ jar ji̱tzi.― Ncjanʉ gá xifi. ");
INSERT INTO otsNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nu car ba̱jtzi hñøjø, mí dyøj na̱r palabra‑na̱, bi jmi̱du̱. Bi wembi car Jesús, bi ma, mí du̱mʉytjo, como már ndo ngu̱tsjɛ cʉ mí pɛhtzi. ");
INSERT INTO otsNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Diguebbʉ ya, car Jesús bi jianti göhtjo cʉ már bbʉh pʉ, cja̱ bi xih quí möxte: ―Drá ndo ntji̱ pa gue yʉ rico da guati pʉ jár dyɛ ca Ocja̱ cja̱ drí jñɛgui pa da mandadobi.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bbʉ mí dyøj ya na̱r palabra‑na̱ quí möxte car Jesús, bi ndo hño í mʉyjʉ. Nu car Jesús pé bi yojpi bi xijmʉ: ―Nuquiguɛjʉ, ʉm tzi ba̱jtziquijʉ, jin tza i ngu̱ yʉ cja̱hni yʉ i mbe̱n cár domijʉ co yʉ pé dda yʉ i pɛhtzijʉ da ñʉti pʉ jabʉ i mandado ca Ocja̱. Da zöjpijʉ drá ndo ntji̱, como rí ma ʉ́r mʉyjʉ yʉ te i pɛhtzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","¿Cja da jogui da tjoh hnar camello pʉ jár gu̱ hnar dyofani? Dí xihquijʉ, más drá ndo ntji̱ pa hnar rico drí ñʉti pʉ jabʉ i mandado ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Diguebbʉ ya, más bi ndo hño í mʉy quí möxte car Jesús, cja̱ mí ma̱ntsjɛjʉ: ―Nubbʉ, ¿ja da ncja yʉ cja̱hni pa drí dötijʉ car nzajqui ca jin da tjegue? ¿Cja huá jin to da döti‑ca̱?― ");
INSERT INTO otsNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nu car Jesús pé bi cca̱hti‑cʉ cja̱ bi xijmʉ: ―Yʉ cja̱hni, jin gui tzö da dötitsjɛ car nzajqui ca jin da tjegue. Nu ca Ocja̱ i pa̱di ja ncja drí dyøte göhtjo ca i ne. Guegue i pa̱di ja ncja da un yʉ cjahni car nzajgui ca jin da tjegue.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Diguebbʉ ya car Pedro bi xih car Jesús, bi hñi̱mbi: ―Dyøjma̱ja̱, ʉm tzi Jmu̱quije, xtú tzoguije göhtjo ca ndí pɛhtzije cja̱ xtú tɛnquije, ¿ter bɛh ca̱ da ttajquije?― ");
INSERT INTO otsNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Cja̱ bi da̱h car Jesús, bi xijmʉ: ―Cierto na̱ dí xihquijʉ, como ngu̱ xquí tzoguijʉ cʉ nguí pɛhtzijʉ por rá nguejquigö. Göhtjo yʉ cja̱hni yʉ xtrú nzoh cár ngu̱ o quí cjua̱da̱ o quí ncju̱ o cár ta o cár me o cár bbɛjña̱ o quí ba̱jtzi o quí jöy, cʉ to xtrú nzoj‑yʉ pa da dɛnguigö cja̱ da tʉngui nʉr tzi ddadyo jña̱ nʉ dá ja̱, ca Ocja̱ da cohtzibi más drá ndo ngu̱ ni digue göhtjo cʉ xí nzogui, da uni hua jar jöy rá ngu quí hñohui cʉ da ma̱di cja̱ co rá ngu̱ cʉ cosa cʉ i nesta, más drá ngu̱ ni ndra ngue cʉ xí nzogui, masque guejtjo da ttøhtibi tu̱jni por rá nguejquigö. ");
INSERT INTO otsNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Da cohtzibi rá ngu̱ vez cár ngu̱, quí hñohui, cár ta, cár me, quí ba̱jtzi, quí jöy, cja̱ nu pʉ ji̱tzi, pé da ttuni car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pe i bbʉ rá ngu̱ yʉ cja̱hni yʉ i tti̱htzibi yʉ pa ya, cja̱ nuyʉ, jin da tti̱htzibi bbʉ xta mʉdi xta mandado ca Ocja̱ hua jar jöy. Guejtjo i bbʉ rá ngu̱ yʉ to jin gui ncjajpi ncaso yʉ pa ya, cja̱ nuyʉ́, da tti̱htzibi bbʉ xta ni̱gui cár jmandado ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Diguebbʉ ya car Jesús co quí möxte má dyojʉ jar hñu̱, mír möjmʉ Jerusalén. Car Jesús má bbɛto, nu quí möxte má bbɛfajʉ. Mí mbe̱nijʉ ca xquí ma̱n car Jesús, mí dyo quí mfe̱nijʉ cja̱ mí ntzu̱jʉ. Ma ya, car Jesús pé bi zixi hnanguadi quí möxte pʉ jabʉ jin te már bbʉ cja̱hni. Cja̱ pé bi xijmʉ te di ncjajpi guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Bi ma̱: ―Como ngu̱ gri cca̱htijʉ, ya dár pøxjʉ Jerusalén. Nu pʉ, da ndöguigö jáy dyɛ cʉ möcja̱ cʉ i mandadobi cʉ pé ddaa, co cʉ maestro cʉ i u̱jti yʉ cja̱hni car ley. Nucʉ́ da ma̱, rí ntzöhui gu tu̱, cja̱ da döguigö jáy dyɛ cʉ cja̱hni cʉ jin gui judio pa da bböjtigui. ");
INSERT INTO otsNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cʉ cjahni‑cʉ́, da i̱mbiguitjo, da jiʉbigui, cja̱ da zoxqui. Drí ga̱x ya, da möjtigui. Pe bbʉ xtrí cja jñu̱jpa, pé xtá jña̱ ʉm jña̱gö. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Diguebbʉ ya, car Jacobo hne̱h car Juan, quí ttʉ car Zebedeo, bi guatihui car Jesús, bi xijmi: ―Nuquiguɛ, Maestro, dí nebbe gui cjaguibbe car favor gu öhquibbe.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Cja̱ car Jesús ya bi da̱di: ―¿Tema favor guí ne gu øjtiquihui?― ");
INSERT INTO otsNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Cja̱ gueguehui bi ma̱jmi: ―Gui cjaguibbe nʉ hnaa da mi̱ jer derecho, cja̱ nʉ pe hnaa da mi̱ jer ntchohta, bbʉ xta ttahqui quer cargo pa gui mandado hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Diguebbʉ ya, car Jesús bi da̱di: ―Jin guí pa̱dihui ja i ncja nʉ xcú dyöjquihui. ¿Cja gui tzɛjti gui sufrihui ca gu sufrigö? ¿Cja gui jiötihui car prueba ca da ttøjtiguigö?― ");
INSERT INTO otsNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Cja̱ bi da̱dihui car Jacobo co car Juan: ―Dyo ya cá̱, xtá jötibbe.― Diguebbʉ ya, car Jesús pé bi xijmi: ―Cierto da ncjahquihui gui sufrihui ncja ngu̱ grá sufrigö. Guejtjo da ttøjtiquihui hnar prueba ncja ngu̱ ca da ttøjtiguigö. ");
INSERT INTO otsNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pe nu ca xcú dyöjquihui, nʉ hnaa da mí̱ jam jogui dyɛ, cja̱ nʉ pe hnaa jam ntchohta dyɛ, jin dí pɛhtzigö derecho pa gu ddahquihui‑ca̱. Nucá̱, da ttun cʉ cja̱hni cʉ ya xí mbe̱n ca Ocja̱ da uni.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Diguebbʉ ya, cʉ pé dda ddɛtta quí möxte car Jesús, bbʉ mí dyødejʉ ter bɛh ca̱ xquí dyödihui car Jacobo co car Juan, bi unijʉ ʉ́r cuɛ. ");
INSERT INTO otsNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nu car Jesús bi nzofo göhtjo quí möxte, bi xijmʉ: ―Nuquiguɛjʉ, guí pa̱dijʉ ja i ncja cʉ cja̱hni cʉ i mandadobi cʉ nación hua jar jöy. Guegue‑cʉ i hñi̱xtsjɛ cja̱ i ndo bbɛjpi jmandado cʉ pe dda cja̱hni, pa da fa̱di i ja̱ ʉ́r cargojʉ cja̱ i nesta da ttøjte. ");
INSERT INTO otsNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nuquiguɛjʉ, da hnahño ca gui dyøtijʉ. Bbʉ to i ne da tti̱htzibi, guegue da pɛjpi yʉ pe ddaa. ");
INSERT INTO otsNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ca to i ne da ncca̱hti rá zö, guegue da cja ʉr muzo, da cjajpi ʉ́r jmandado yʉ pe ddaa. ");
INSERT INTO otsNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Como nugö, dí ncjagö pʉ, dúr cja̱hni xpá bbɛnqui hua jar jöy ncja hnar muzo. Jí̱ xtá e̱je̱ pa da pɛjpigui yʉ pe dda cja̱hni. Nugö xtá e̱je̱ pa gu föxcö‑yʉ, cja̱ pa gu dö cam vida pa drí mɛhtzi cár nzajqui rá ngu̱ cja̱hni, jin da bbɛdijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Diguebbʉ ya, car Jesús co quí möxte bi zøtijʉ jar jñini Jericó, cja̱ bi tjojtijʉ pʉ. Bbʉ ya xi má pønijʉ jar jñini, car Jesús co quí möxte co pe dda cja̱hni már ngu̱, bi tjojmʉ pʉ jabʉ már ju̱ hnar godö. Car godö mí ju̱ cár tju̱ju̱ múr Bartimeo, múr ttʉ ca hnar hñøjø ca mí tsjifi ʉr Timeo. Guegue car godö mí ju̱h pʉ jar nttza̱ni car hñu̱, mí öh cár limosna. ");
INSERT INTO otsNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bi dyøde, ya xi mbá e̱h pʉ car Jesús ca múr mi̱ngu̱ Nazaret, cja̱ bi nzoh car Jesús, bi mahti pa di mötzi. Bi hñi̱na̱: ―Nuquiguɛ, Jesús, xquí hñe̱je̱ digue cár cji ca ndo ʉr David pa gui mandadoguije, gui föxqui tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cʉ cja̱hni rá ngu̱ cʉ má tjoh pʉ, bi huɛhti car godö, bi xijmʉ di gohti ʉ́r ne. Nu guegue más mír ndo mafi nzajqui, mí i̱na̱: ―Nuquɛ, Jesús, xcú hñe̱je̱ pa gui mandadoguije, gui jui̱guigui tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Diguebbʉ ya, bi hmöh car Jesús, bi mandado di ttzoh car godö cja du ttzimpi guegue. Nubbʉ, bú ttzoh car godö cja̱ bi tsjifi: ―Gui mpöj ya cja̱ gui bböy, i nzohqui car Jesús.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Guegue ya bi møn cár da̱jtu̱ ca mí pöti, bi bbö nttzɛdi, sta bi ntsjöjqui cor pöjö cja̱ bi guati car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nu car Jesús ya bi xifi: ―¿Ter bɛh ca̱ guí ne gu cjahqui ya?― Cja̱ bi da̱j ya car godö: ―Nuquiguɛ, Maestro, dí ne gui xojqui tzʉ yʉm dö.― ");
INSERT INTO otsNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Cja̱ bi ma̱n car Jesús, bbʉ: ―Ya xí xoj yir dö, como xcú hñemegui. Nuya, ya xí jogui pa gui me ir ngu̱.― Bbʉ mí ma̱n cʉ palabra‑cʉ, bi xoh quí dö ca múr godö jma̱ja̱, cja̱ bi dɛn car Jesús pʉ jabʉ má pa. ");
INSERT INTO otsNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Car Jesús co quí möxte mír möjmʉ Jerusalén. Bbʉ ya xti tjojmʉ cʉ tzi jñi̱ni Betfagé co Betania, bbʉ ya xi mír jñantihui car ttøø ca i tsjifi Olivos, car Jesús bi gu̱ yojo quí möxte, bi xijmi: ");
INSERT INTO otsNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Gui mɛhui ya nʉr tzi jñi̱ni nʉ rá cjanʉ. Cja̱ bbʉ ya xcrí cʉtihui, xquí tötihui hnar tzi burro, rá hna̱ti pʉ, jin to bbe i tøgue. Gui xohtihui cja̱ gu ɛhui hua. ");
INSERT INTO otsNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Cja̱ bbʉ to da xihquihui: ¿Dyoca̱ guí xohtihui nʉr tzi burro? gui xijmi: Cam Tzi Jmu̱je i joni, cja̱ nguetica̱ xcuá e̱ xtá tzogui. Gui xijmi ncjapʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Diguebbʉ ya bi ma cʉ yo quí möxte, bú tötihui car tzi burro, már hna̱ti pʉ tji, pʉ jár goxtji ca hnar ngu̱, pʉ jabʉ mí mbonti yojo tzi hñu̱. Bú xohtihui bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Cʉ ddaa cja̱hni cʉ már bböjti pʉ bi xijmʉ: ―¿Te guí pɛjmi? ¿Dyoca̱ guí xohtihui nʉr tzi burro?― ");
INSERT INTO otsNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Gueguehui ya, bi xijmi ncja ngu̱ gá ma̱n car Jesús. Cja̱ diguebbʉ ya, bi tjɛgui bi dyɛnihui car burro, bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bi dyɛnihui gá nzøm pʉ jabʉ már bbʉh car Jesús. Bi ga̱x pʉ jár xʉtja car tzi burro cʉ dda quí da̱jtu̱ cʉ mí pötijʉ, cja̱ bi jñu̱x pʉ car Jesús. Már bbʉh pʉ cʉ dda cja̱hni cʉ má yojmʉ car Jesús, mír möjmʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cʉ ddáa bi zɛjqui quí xi cʉ za, bi hmɛtojʉ, bi xi̱jmʉ pʉ jar hñu̱ pʉ jabʉ xti tjoh car Jesús, cja̱ bi ncjadijʉ pʉ co ni quí da̱jtu̱jʉ, bi xi̱jmʉ pʉ jar hñu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cʉ cja̱hni cʉ má bbɛto co hne̱ cʉ má bbɛfa, mí mafi nzajqui, mí ma̱jmʉ: ―Da ncja ʉ́r nzajqui nʉ to ba e̱je̱. Cam Tzi Jmu̱jʉ ca bí bbʉ ji̱tzi da bendeci nʉr hñøjø nʉ ba e̱je̱, como xpá mɛjni guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Car Tzi Ta ji̱tzi da möx nʉr hñøjø nʉ ba e̱je̱ pa da mandadoguijʉ, como guejnʉ́ da go jár lugar ca ndom titajʉ David. Dí xöjtibijʉ ca Ocja̱ ca bí bbʉj nʉ ji̱tzi, dí ndo öjpijʉ mpöjcje.― ");
INSERT INTO otsNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Diguebbʉ ya car Jesús bi zøm pʉ jar ciudad Jerusalén, cja̱ bi guati pʉ jar ndo templo. Bi cca̱hti göhtjo te már ncja pʉ, cja̱ pé bi bøm pʉ Jerusalén gá ma jar tzi jñini Betania, como ya xquí nde. Guehpʉ már ox pʉ. Guegue mí yojmi cʉ doce hñøjø cʉ xquí hñi̱tzi gá möxte. ");
INSERT INTO otsNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Car jiax‑cá̱, car Jesús pé bi bøm pʉ jar tzi jñini Betania pa pé drí ma Jerusalén. Cja̱ bbʉ má dyo jar hñu̱, bi du̱ntju̱ bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bi jianti hnar za gá higo, ya xi mí tu̱ quí xi, cja̱ bi guati pa di cca̱hti ¿cja mí tu̱ higo car za? Pe jin te gá ndöti. Jøntsjɛ quí xi mí tu̱, como mí bbɛjtjo di zøh car tiempo pa di du̱ cʉ higo. ");
INSERT INTO otsNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Diguebbʉ ya, car Jesús bi xih car za: ―Desde rá pa ya, pa göhtjo ʉr tiempo, jin tema ixi gui tu̱.― Cja̱ quí möxte car Jesús bi dyøjmʉ nʉr palabra nʉ bi ma̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cja̱ bbʉ mí zøti pʉ Jerusalén car Jesús, pé bi guati pʉ jár tji car ndo templo, cja̱ bi mʉdi bi fongui cʉ cja̱hni cʉ mí mpö pʉ, co hne̱h cʉ mí ntöm pʉ. Bi dyentibi quí mexa cʉ cja̱hni cʉ mí pöti domi, co quí tju̱jni cʉ to mí pö paloma. ");
INSERT INTO otsNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Guejtjo bi ccax cʉ cja̱hni cʉ mí tu̱ quí bbötzi, mí tjoh pʉ jár tji car templo ncjahmʉ dur hñu̱tjo. ");
INSERT INTO otsNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Guegue bi nzoh cʉ cja̱hni, bi xifi: ―I ju̱x pʉ jar Escritura nʉr palabra nʉ i xijquijʉ ja da ncja drí jnu̱ nʉ́r ngu̱ ca Ocja̱: I ma ncjahua “Nʉm ngu̱, da tsjifi ʉr ngu̱ pa du e̱je̱ göhtjo yʉ nación, da nzojquigö.” Nuquiguɛjʉ, xcú cjajpijʉ ʉ́r ngu̱ yʉ be̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nu cʉ maestro cʉ mí u̱jti cʉ cja̱hni cár ley cʉ judio, co cʉ möcja̱ cʉ mí mandadojʉ, bi dyødejʉ nʉr palabra nʉ xquí ma̱n car Jesús. Bi ntsjeyajʉ, cja̱ bi ña̱jʉ ja di cjajpijʉ pa drí möhtijʉ. Pe mí tzu̱jʉ pa te di cjajpijʉ car Jesús, como cʉ cja̱hni mí ndo i̱htzibijʉ‑ca̱. Mí ndo dyo í mʉy cʉ cja̱hni bbʉ mí dyøjmʉ te mí man car Jesús, como már ndo zö ca mí u̱jti. ");
INSERT INTO otsNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cja̱ bbʉ ya xquí nde, car Jesús pé bi bøm pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Car jiax ya‑cá̱, bbʉ mí nxu̱ditjojo, car Jesús pé má hñohui quí möxte, pé má pöjmʉ Jerusalén. Bi tjojmʉ pʉ jabʉ már jø car za gá higo, nxøgue ya xquí dyoti hasta guehpʉ jáy dyʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Diguebbʉ ya car Pedro bi mbe̱n car palabra ca xquí ma̱n car Jesús, cja̱ bi xifi: ―Nuquɛ, Maestro, cca̱htijma̱ na̱r za na̱ gú tzani má nde, ya xí dyoti.― ");
INSERT INTO otsNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Cja̱ bi da̱h car Jesús, bi xifi: ―Gui hñe̱me̱jʉ, rá nzɛh ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cierto dí xihquijʉ, bbʉ to da hñe̱me̱ ca Ocja̱, cja̱ da ne da xij nʉr ttøø: “Wengua, grí hñɛnti jar mar,” bbʉ jin da yomfe̱ni ca xí ma̱, da ncja‑ca̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Guejtjo dí xihquijʉ, bbʉ gri nzojmʉ ca Ocja̱, gui hñe̱me̱jʉ, da ddahquijʉ ca guí öjpijʉ. Nubbʉ́, cierto da ddahquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cja̱ bbʉ guí nzojmʉ ca Ocja̱, bbʉ guí mbe̱nijʉ to te xí cjahquijʉ, gui perdonabijʉ, sa̱nta̱ quer Tzi Tajʉ ca bí bbʉ ji̱tzi da perdonaquijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nuquiguɛjʉ, bbʉ jin guí perdonabi quir hñohuijʉ ca rá nttzo ca xí dyøjtiquijʉ, guejti quer Tzi Tajʉ ca bí bbʉ ji̱tzi jin da perdonaquijʉ ca rá nttzo ca xcú dyøtijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Cja̱ diguebbʉ ya, car Jesús pé bi ma gá ngojti pʉ jar jñi̱ni Jerusalén. Cja̱ bbʉ má dyo car Jesús pʉ jar templo, bú e̱h cʉ dda möcja̱ cʉ mí mandado, co dda cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley. Mbá yojmʉ cʉ dda tita cʉ mí ja̱ ʉ́r cargojʉ jar templo hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Guegue‑cʉ bi dyön car Jesús: ―¿Jabʉ xcú jña̱ quer cargo pa gui mandado hua? ¿Toca̱ xí ddahqui quer cargo pa gui dyøti yʉ guí øte?― ");
INSERT INTO otsNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Cja̱ car Jesús bi da̱di: ―Hne̱hquiguɛjʉ, gu önquijʉ hnar nttöni. Bbʉ gui tja̱jtiguijʉ, xtá tja̱jtiquijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Car Juan ca mí xix yʉ cja̱hni, ¿jabʉ xcuí jña̱ cár cargo pa di xix‑yʉ́? ¿Cja xcuí hñe̱h car Tzi Ta ca bí bbʉ jar ji̱tzi, cja huá xcuí hñe̱j yʉ cja̱hni hua jar jöy? Tja̱jtiguijʉ ya.― ");
INSERT INTO otsNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nucʉ́, bi ntzohmi, cja̱ bi ma̱ntsjɛjʉ: ―Bbʉ gu ma̱jmʉ, xcuí hñe̱ ji̱tzi, guegue da ma̱m bbʉ́, ¿Dyoca̱ jí̱ xtá e̱me̱jʉ? ");
INSERT INTO otsNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Cja̱ bbʉ gu ma̱jmʉ, xcuí hñe̱j yʉ cja̱hni hua jar jöy, dí tzu̱jʉ te da cjaguijʉ yʉ cja̱hni.― Como göhtjo cʉ cja̱hni mí e̱me̱jʉ, cierto múr jmandadero ca Ocja̱ car Juan. ");
INSERT INTO otsNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eso, cʉ cja̱hni‑cʉ́ bi xih car Jesús: ―Jin dí pa̱dije jabʉ xcuí hñe̱h car cargo ca mí ja̱ car Juan.― Diguebbʉ ya, pé bi da̱jti car Jesús, bi xijmʉ: ―Hne̱quigö, jin gu xihquijʉ jabʉ xcuá hñe̱h cam cargo dí ja̱gö pa gu øti yʉ dí øte.― ");
INSERT INTO otsNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Diguebbʉ ya car Jesús pé bi mʉdi bi u̱jti cʉ cja̱hni, bi nzofo gá bbede. Bi ma̱: ―Mí bbʉh hnar hñøjø, bi jojqui hnár huerta gá uva, cja̱ bi hñi̱ti hnar cerca göhtjo jáy nttza̱ni. Bi dyøti hnar tanque pʉ jabʉ di ddi̱n cʉ uva, cja̱ bi jiøh hnar ntorre pa di tjanti car huerta. Diguebbʉ bi döjti car huerta cʉ dda mɛfi, cja̱ guegue bi ma yapʉ, pe hnar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bbʉ ya xquí zøh car tiempo pa di da̱ cʉ uva, car hñøjø bú pɛjni hnár muzo pʉ jabʉ már bbʉh cʉ mɛfi. Bú e̱h car muzo pa di dyöh cʉ uva cʉ mí tocabi, pa pé drí du̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nu cʉ mɛfi bi pɛntijʉ car muzo, bi ʉnijʉ, cja̱ bi gu̱pjʉ. Jin te gá ndu̱x car muzo. ");
INSERT INTO otsNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Diguebbʉ ya, car jmu̱ pé bú cu̱h hnar muzo. Nucá̱, bbʉ mí zøh pʉ jabʉ már bbʉh cʉ mɛfi, bi tjøjti me̱do, bi mfehtibi cár ña̱. Göhtjo te bi tsjifi, cja̱ diguebbʉ ya, pé bi cju̱y. ");
INSERT INTO otsNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Car jmu̱ pé bi yojpi bú cu̱ pé hnaa. Nucá̱, bbʉ pé mí zøm pʉ jabʉ már bbʉh cʉ mɛfi, bi zɛti‑cʉ́, bi möhtijʉ. Diguebbʉ ya car jmu̱ pé bú pɛjni pé dda jmandadero rá ngu̱. Nu cʉ mɛfi bi ncjadijʉ pʉ. Bi ʉnijʉ cʉ ddáa, nu cʉ pé ddáa bi möhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Car jmu̱ ya xquí gu̱y göhtjo quí mɛfi, pe mí hñi̱h hnár ttʉ cja̱ mí ndo ma̱h‑cá. Gá nga̱tzi bú pɛjni‑cá̱ pʉ jabʉ már bbʉh quí mɛfi. Ngá ma̱ guegue: “Nde̱jma̱ da tti̱htzibi nʉm ttʉ.” ");
INSERT INTO otsNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pe guegue ya cʉ mɛfi bi ma̱jmʉ: “Guejnʉ́ da ttzoquibi göhtjo nʉr huerta. Gu mföxjʉ ya, gu pöhtijʉ pa gu cojmʉ yʉ di ttuni guegue.” ");
INSERT INTO otsNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eso, bi pɛntijʉ cár ttʉ car jmu̱, bi möhtijʉ, cja̱ bi dyɛjmʉ yapʉ cár cuerpo. ");
INSERT INTO otsNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Diguebbʉ ya, car Jesús bi dyön cʉ to már øde: ―Xi ca to ʉ́r mɛjti car huerta, ¿te da cjajpi cʉ mɛfi‑cʉ́? Du e̱je̱ da möhti, cja̱ da döjti pé hnahño mɛfi car huerta. ");
INSERT INTO otsNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nuquɛjʉ, ¿cja jí̱ xquí cca̱htijʉ na̱r palabra na̱ i ju̱x pʉ jar Escritura? I i̱na̱: Car me̱do ca bi dyɛndi cʉ cja̱hni cʉ mí jøh car ngu̱, Guehcá̱ xí cjöx pʉ jar esquina car ngu̱, pʉ jabʉ i pɛnti cʉ cjoti. ");
INSERT INTO otsNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Guejtsjɛ ca Ocja̱ xí mandado xí cjöx pʉ. Nugöjʉ, bbʉ dí cca̱htijʉ, i ndo dyo ʉm mʉyjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Cʉ cja̱hni cʉ mí tsjij nʉr bbede‑nʉ́, bi ba̱dijʉ car Jesús már ña̱ di gueguejʉ, már jɛqui cʉ mɛfi cʉ már nttzo. Cja̱ bi jionijʉ ja drí zʉdijʉ car Jesús. Pe mí tzu̱jʉ cʉ cja̱hni rá ngu̱ cʉ mí tɛnijʉ car Jesús. Eso, bi jiɛjtijʉ car Jesús, bi möjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Diguebbʉ ya, cʉ cja̱hni‑cʉ́, bú cu̱jmʉ cʉ dda fariseo co dda cʉ hñøjø cʉ mí tɛnijʉ car rey Herodes pa di dyøhtibijʉ prueba car Jesús, xa̱jma̱ di cjajpijʉ di ma̱ hnar palabra ca jin di tzö. ");
INSERT INTO otsNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bú e̱jmʉ ya gueguejʉ, cja̱ bi xijmʉ car Jesús: ―Nuquiguɛ, Maestro, dí pa̱dije, guí ma̱nguɛ ca ncjua̱ni. Jin to guí tzu̱, cja̱ jin to guí johtitjo, como jin guí cca̱htiguɛ nʉr cja̱hni xøtzetjo, pe guí xifi göhtjo yʉ cja̱hni parejo, te i ne ca Ocja̱. Gui xijquije tzʉ ya, ¿cja rá zö ca dár unije cʉ contribución car rey romano ca i mandadoguijʉ, cja huá jin gui tzö? ");
INSERT INTO otsNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Cja gu cju̱tije, o ya jin gu cju̱tije?― Nu car Jesús bi ba̱di, már øhtibitjojʉ hnar trampa, cja̱ bi da̱h, bbʉ: ―¿Dyoca̱ guí øjtiguijʉ ntjöti? Bú ja̱nquijʉ hnar domi hua, pa gu cca̱htijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Cja̱ bú tja̱ hnar domi, bbʉ. Diguebbʉ ya car Jesús bi hñöni: ―¿To ʉ́r retrato na̱ i cuati hua, cja̱ to ʉ́r tju̱ju̱‑na̱?― Gueguejʉ ya bi xijmʉ: ―Í mɛjti car rey César.― ");
INSERT INTO otsNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bi da̱j ya car Jesús, bi xijmʉ: ―Gui unijʉ car rey yí mɛjti guegue, cja̱ guejti ca Ocja̱, gui unijʉ quí mɛjti‑ca̱ hne̱je̱.― Nu cʉ hñøjø‑cʉ, bbʉ mí dyøde ja ncja gá nda̱h car Jesús, bi ndo hño í mʉyjʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Diguebbʉ ya, bú e̱h cʉ dda saduceo pʉ jabʉ már bbʉh car Jesús. Cʉ saduceo i ma̱jmʉ, jin da jña̱ ʉ́r jña̱ cʉ ánima. Bbʉ ga ndu̱ yʉ cja̱hni, i mpuntjo, göhtjo co quí tzi mʉyjʉ. Ncjapʉ ga ma̱jmʉ. Gueguejʉ bi dyönijʉ car Jesús, ¿cja ntju̱mʉy da nantzi cʉ ánima? Bi hñi̱mbijʉ: ");
INSERT INTO otsNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Nuquiguɛ, Maestro, ca ndor Moisés bi zoguijʉ na̱r palabra‑na̱: Bbʉ da du̱ hnar hñøjø, cja̱ jin tema ba̱jtzi di hñi̱ji̱, cár cjua̱da̱ car ánima da yojmi cár bbɛjpo pa da hñi̱ ba̱jtzi. Cja̱ bbʉ da ønte car bbɛjña̱, car ba̱jtzi ca da hmʉy, da tsjifi dúr ba̱jtzi car ánima, pa ncjapʉ jin da mpun cár tju̱ju̱ car ánima. ");
INSERT INTO otsNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mí bbʉ yojto hñøjø cʉ mí ncjua̱da̱. Car da̱cjua̱da̱ bi ntja̱jti cja̱ bi hmʉbi cár bbɛjña̱. Diguebbʉ ya, bi du̱, jin tema ba̱jtzi gá nzogui. ");
INSERT INTO otsNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Diguebbʉ ya car yocjua̱da̱ ya, pé bi yojmi cár bbɛjpo, cja̱ guegue pé bi du̱tjo. Guejtjo jin tema ba̱jtzi gá nzogui. Ca rá jñu̱ ya, pé bi ncjadipʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cja̱ göhtjo cʉ yojto hñøjø bi hmʉbi car bbɛjña̱, göhtjo bi ncjadijʉ pʉ. Jin tema ba̱jtzi gá nzoguijʉ. Gá nga̱x ya, bi du̱ car bbɛjña̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Xijquije ya bbʉ́, car pa ca da jña̱ ʉ́r jña̱ cʉ ánima, ¿toca̱ dúr bbɛjña̱ guegue, como bi yojmi göhtjo cʉ yojto cjua̱da̱?― ");
INSERT INTO otsNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Diguebbʉ ya bi da̱h car Jesús, bi ma̱: ―Nuquɛjʉ, xcú ndo nquivocajʉ porque jin guí pa̱jmʉ te i ma̱n cʉ Escritura. Guejtjo jin guí e̱me̱jʉ ¿cja rá nzɛdi ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bbʉ pé xta jña̱ ʉ́r jña̱ cʉ cja̱hni cʉ xí ndu̱, ya jín da ntja̱jti. Da hmʉpjʉ ncja ngu̱ cʉ ángele cʉ bí bbʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nu cʉ cja̱hni cʉ xí ndu̱, nde̱jma̱ da jña̱ ʉ́r jña̱‑cʉ́. ¿Dyoca̱ jin guí e̱me̱jʉ‑cá̱? ¿Cja jin guí cca̱htijʉ car libro ca bi dyøti car Moisés? ¿Cja̱ jin guí cca̱htijʉ te bi ma̱n ca Ocja̱ bbʉ mí ntjɛhui car Moisés pʉ jar za gá hmi̱ni? Bi ma̱ ncjahua: “Nugö, ʉ́r Cjá̱a̱‑guigö ca ndor Abraham, cja̱ co ca ndor Isaac, cja̱ co ca ndor Jacobo.” ");
INSERT INTO otsNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Guegue jí̱ ʉ́r Cjá̱a̱ cʉ cja̱hni cʉ ya jin te i bbʉ ʉ́r nzajqui. ʉ́r Cjá̱a̱ cʉ cja̱hni cʉ i cjadi ʉ́r nzajqui, masque ya xí ndu̱, como guegue i ungui nzajqui cʉ to i e̱me̱. Nuquiguɛjʉ, jin guí pa̱dijʉ ja i ncja ca Ocja̱. Jin gui tzö quir mfe̱nijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Guejtjo bi guati pʉ hnar maestro ca mí u̱jti cʉ cja̱hni car ley. Guegue bi dyøde te már ma̱n car Jesús co cʉ saduceo. Bi ba̱di, már ndo zö car palabra ca bi da̱h car Jesús. Eso, bi guati jabʉ már bbʉh‑ca̱, bi dyöni: ―Nuquɛ, Maestro, digue cʉ ddɛtta mandamiento cʉ bi zoguijʉ car Moisés, ¿ja̱ ndrá nguehca̱ más i nesta da ttøjte?― ");
INSERT INTO otsNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Cja̱ car Jesús bi da̱di: ―Gue na̱r mandamiento na̱ i ma̱: “Gui dyødejʉ, guí cja̱hni israelitajʉ: ca Ocja̱, ʉm Tzi Jmu̱göjʉ, ddatsjɛ‑ca̱. Gu e̱me̱jʉ jøntsjɛ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gu nejʉ ca Ocja̱, cam Tzi Jmu̱jʉ, göhtjo mbo ʉm tzi mʉyjʉ. Gu i̱htzibijʉ‑ca̱, gu mbe̱nijʉ, cja̱ gu jonijʉ göhtjo co cam ttzɛdijʉ.” Nʉr mandamiento‑nʉ más i mu̱hui ni ndra ngue cʉ pé ddaa. ");
INSERT INTO otsNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Guejti car mandamiento ca i ntɛndihui, guejtjo i ndo mu̱hui. Gue nʉ pé hnaa nʉ i ma̱: “Gu nejʉ göhtjo tema cja̱hni ncja ngu̱ dar netsjɛjʉ.” Yʉ yojo mandamiento‑yʉ, más i nesta da ttøjte ni ndra ngue cʉ pé ddaa.― ");
INSERT INTO otsNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Diguebbʉ ya, bi da̱h car maestro‑ca̱: ―Cierto nʉr palabra nʉ xcú ma̱, Maestro. Ddatsjɛ ca Ocja̱, u̱jtjo pé hnaa. Jøntsjɛ guegue ʉm Jmu̱göjʉ ca dí e̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bbʉ gu nejʉ guegue göhtjo mbo ʉm tzi mʉyjʉ, bbʉ gu i̱htzibijʉ, cja̱ gu mbe̱nijʉ, cja̱ gu jonijʉ, göhtjo co cam ttzɛdijʉ, guejtjo bbʉ gu ne cʉm mi̱nga̱‑cja̱hnijʉ ncja ngu̱ dar netsjɛjʉ, guehca̱ i ndo mu̱hui‑ca̱. Guehca̱ i ndo tzøh ca Ocja̱, cja̱ jin tza i tzøh cʉ ofrenda cʉ dí döjtijʉ cja̱ co cʉ zu̱we̱ rá ngu̱ cʉ i bböhti cja̱ i ddʉti pʉ jar altar.― Ncjanʉ gá ma̱n car hñøjø‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nu car Jesús, bbʉ mí dyøj ya nʉr palabra‑nʉ, bi ba̱di, már nzɛh cár mfe̱ni car maestro‑ca̱, cja̱ bi xifi: ―Nuquɛ, ya tchʉtjo i bbɛdi pa gui cuati pʉ jár dyɛ ca Ocja̱, pa da mandadoqui.― Nu cʉ pé dda cja̱hni, bbʉ mí dyøj nʉr palabra‑nʉ, ya jin to gá nzö ʉ́r mʉy di dyön car Jesús pé dda nttöni. ");
INSERT INTO otsNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Car Jesús már u̱jti cʉ cja̱hni jar templo, cja̱ guegue bi dyöni hnar nttöni cʉ cja̱hni cʉ már bbʉ pʉ. Bi ma̱: ―Yʉ maestro yʉ i u̱jtiquijʉ car ley, i ma̱jmʉ, dúr mboxibbɛjto car David car Cristo ca da hñi̱x ca Ocja̱ pa da mandadoquijʉ. ¿Dyoca̱ i ma̱jmʉ ncjapʉ? ");
INSERT INTO otsNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Como guejtsjɛ car David bi ña̱ pʉ jar salmo digue car hñøjø ca di hñi̱x ca Ocja̱ pa di mandado. Car Espíritu Santo bi möx car David, cja̱ nuca̱ bi ma̱ ncjahua: Car Tzi Ta ji̱tzi bi xih cam Tzi Jmu̱gö, bi hñi̱mbi: “Gui mi̱jcua jam jogui dyɛ gu mföxihui gu mandadohui, Hasta bbʉ xtá cjajpigö quir contra du e̱je̱, Da nda̱ndiña̱jmu̱ jer tzi huá, cja̱ nuquiguɛ, xquí mandadobi‑cʉ́.” Ncjapʉ ga ma̱n car salmo. ");
INSERT INTO otsNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nuquiguɛjʉ, xijquijʉ ya, bbʉ jøntjo dúr mboxibbɛjto car David car Cristo ca di hñe̱je̱, ¿dyoca̱ i tsjifi ʉ́r jmu̱ car David, bbʉ?― Cja̱ jin to gá nda̱j nʉr nttöni‑nʉ. Már ndo ngu̱ cʉ cja̱hni cʉ mí u̱jti car Jesús, cja̱ mí ndo tzøjmʉ ca mí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Car Jesús már u̱jti cʉ cja̱hni, cja̱ bi xijmʉ: ―Gui jña̱jʉ ʉr huɛnda digue cʉ maestro cʉ i u̱jtiquijʉ car ley, pa jin gui tɛnijʉ‑cʉ́. Gueguejʉ i jejʉ quí da̱jtu̱ rá ma, pa más da tti̱htzibi, cja̱ i ne pa da ttzɛnguajʉ rá zö jar töy. ");
INSERT INTO otsNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Guejtjo, bbʉ i pa jar templo, i ne da mi̱pjʉ pʉ jabʉ da cca̱hti cʉ pe dda cja̱hni, cja̱ bbʉ i pa ja mbaxcjua, i ne da mi̱pjʉ pʉ jabʉ da tti̱htzibi, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Cʉ maestro‑cʉ́, jin gui jui̱jqui cʉ ddanchu masque jin te i ja̱‑cʉ́. Nu cʉ to i tu̱jpi domi, cʉ jin gui tzö da gu̱hti, cʉ maestro i fongui jáy ngu̱jʉ, i recogebi, cja̱ i ja̱xti car domi. Diguebbʉ ya, i pöjmʉ tsjödi, i øtijʉ oración rá ndo ma. Ncøni, i ndo jonijʉ ca Ocja̱. Nu ca Ocja̱ da un cár castigo más drá ngu̱ cʉ maestro‑cʉ ni ndra ngue cʉ tzi cja̱hni cʉ jin tza i pa̱di te i ma̱n car ley.― ");
INSERT INTO otsNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ca hnajpa, car Jesús bi mi̱ jöy, mír ncca̱htihui car caja pʉ jabʉ mí ttzoh cʉ ofrenda, bi cca̱hti cʉ cja̱hni már ʉti quí domi pʉ jar caja. Mbá e̱h cʉ rico, mí ʉtijʉ domi rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Diguebbʉ ya, bú e̱h hnar ddanchu̱, jin te mí ja̱. Bi dyʉti pʉ yojo tzi domi cʉ di mu̱hui ngu̱ cʉtta centavo. ");
INSERT INTO otsNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Cja̱ car Jesús bi nzoh quí möxte, bi xijmʉ: ―Dí xihquijʉ cierto, más i mu̱hui yʉ tzi cʉtta yʉ xí dyʉti nʉr ddanchu̱‑nʉ ni ndra ngue car domi rá ngu̱ ca xí dyʉti yʉ rico. ");
INSERT INTO otsNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Como göhtjo yʉ dda cja̱hni xí undi car domi ca jí̱ mí nestajʉ. Nu nʉr tzi ddanchu̱ nʉ jin te i ja̱, xí dyʉti göhtjo ca mí pɛhtzi pa di zi.― ");
INSERT INTO otsNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Diguebbʉ ya, car Jesús co quí möxte bi bønijʉ jar templo. Nu ca hnaa digue quí möxte bi xifi, i̱na̱: ―Nuquiguɛ, Maestro, cca̱htijma̱ yʉ ndo me̱do co yʉ ndo ngu̱‑yʉ. Rá ndo zö ga ni̱gui‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Bi da̱j ya car Jesús, bi xifi: ―Cierto, guí cca̱hti yʉ ndo ngu̱ yʉ i jøjcua. Pe ya xpa e̱h car pa bbʉ ya jin da gojcua yojo me̱do di mfi̱tzi. Como du e̱h cʉm contrajʉ, tje da yøhti yʉ edificio‑yʉ, cja̱ da mfonti göhtjo yʉ ndo me̱do.― ");
INSERT INTO otsNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Diguebbʉ ya, car Jesús bi ma jar ttøø ca mí tsjifi Olivos, cja̱ bú mi̱h pʉ jabʉ mír jñantihui car ndo templo. Car Pedro co car Juan co car Andrés bi guati pʉ jabʉ már ju̱ car Jesús. Mí ddatsjɛ‑ca̱, cja̱ gueguejʉ bi dyönijʉ: ");
INSERT INTO otsNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xijquije tzʉ, ¿ncjahmʉ da ncja cʉ xcú ma̱? ¿Ter bɛh ca̱ da ncja pa gár pa̱dije bbʉ ya xta zʉh cʉ pá‑cʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Diguebbʉ ya, car Jesús bi mʉdi bi xih quí möxte göhtjo ja da ncja bbʉ xta guaj nʉr mundo. Bi xijmʉ: ―Gui jña̱jʉ ʉr huɛnda pa jin to da jiöhquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Como xtu e̱ rá ngu̱ cja̱hni, xta nøn cam tju̱ju̱gö, xta xihquijʉ: “Guejquigö dúr Cristo, xí hñi̱xquigö ca Ocja̱.” Cja̱ rá ngu̱ cja̱hni da hñeme ca da ma̱n‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nuquiguɛjʉ, bbʉ xtí dyødejʉ, ya xná ntu̱jni cʉ cja̱hni cʉ rá bbʉ hnahño lugar, o guejtjo bbʉ xtí dyødejʉ, ya xpa e̱h car guerra, dyo guí ntzu̱jʉ, porque nde̱jma̱ i nesta da ncja‑cʉ, ante que da guaj nʉr mundo. Bbʉ xta ncja‑cá̱, da tzi bbɛjtjo pa da guadi. ");
INSERT INTO otsNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nubbʉ́, hnar nación da xoxihui tu̱jni pe hnar nación. Guejtjo cár gobierno hnar jöy da ntu̱jnihui cár mi̱nga̱‑gobiernohui, hnahño ʉr jöy. Cja̱ da ndo hño hña̱mijöy. Cja̱ da u̱jtjo car semilla, rá ngu̱ lugar, eso da ndo du̱ntju̱ cʉ cja̱hni. Da mpɛjni cʉ cjahni, da fongui cʉ to i mandado. Bbʉ xta ncja yʉ cosa‑yʉ́, ya xqui tchʉtjo pa da guaj nʉr mundo. Pe más da ndo sufri cʉ cja̱hni bbʉ xta ncja cʉ pé dda cosa cʉ ba bbɛfa. ");
INSERT INTO otsNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nuquiguɛjʉ, gui jña̱jʉ ʉr huɛnda. Porque da ndöquijʉ jár dyɛ cʉ to i mandado, cja̱ da tjʉpiquijʉ jáy ni̱cja̱ cʉ judio. Guejtjo da ttzixquijʉ, gui ma grí hmöpjʉ pʉ jabʉ i bbʉh cʉ gobernador cja̱ co cʉ rey. Da ttzojnquijʉ porque guí tɛnguigöjʉ, cja̱ da ttönquijʉ ja i ncja ca guí e̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pe jin da guaj nʉr mundo hasta bbʉ ya xtrú tsjifi göhtjo cʉ cja̱hni ja i ncja nʉr nzajqui ca jin da tjegue, cja̱ diguebbʉ ya, da guah bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cja̱ bbʉ xta ttzixquijʉ pʉ jabʉ i bbʉh cʉ autoridad cja̱ da ndöquijʉ jáy dyɛ, jin gui ma gui ntzohmijʉ bbɛto te gui xijmʉ‑cʉ́. Hasta car hora ca xta ttzojniquijʉ cja̱ da ttönquijʉ nttöni, hasta guebbʉ́ da tsjihquijʉ te grí tja̱dijʉ. Nubbʉ́, gui ma̱jmʉ ca da xihquijʉ ca Ocja̱, como jin gui guehquiguɛjʉ gui ña̱jʉ. Gue car Tzi Espíritu Santo da xihquijʉ ter bɛh ca̱ gui ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cʉ pa‑cʉ́, hnar hñøjø da dö cár cjua̱da̱ pa da bböhti, cja̱ pe hnar hñøjø da dö cár ttʉ ca i e̱me̱gui. Da bböhti‑cʉ́ por rá nguejquigö. Cja̱ pe dda hñøjø ya, da ntu̱jnihui quí tajʉ por rá nguejquigö, da möhti‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nuquiguɛjʉ, ndu̱ntji cja̱hni da ʉquijʉ porque guí tɛnguigöjʉ. Nu ca to da segue da dɛnguigö hasta xtrí ga̱x cʉ pa‑cʉ́, da mɛhtzi car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nubbʉ́, gui ma gui cca̱htijʉ, da ncja ca bi ma̱n car profeta Daniel. Mí ma̱ guegue, du e̱h ca hnar cja̱hni, da ttzombi cár templo ca Ocja̱. Car cja̱hni‑cá̱, da ñʉti pʉ mbo car templo pʉ jabʉ jin gui tjɛgui to da ñʉti, cja̱ da dyøti ca jí̱ rí ntzöhui. (Bbʉ xquí cca̱hti na̱r palabra‑na̱, gui jioni ja grí ntiende.) Cja̱ bbʉ xtí cca̱htijʉ ya xtrú ncja‑cá̱, gui jña̱jʉ ʉr huɛnda. Cʉ cja̱hni cʉ i bbʉ jar estado Judea, da gʉjʉ ʉr ddiji, da ma ja ttøø. ");
INSERT INTO otsNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bbʉ to di bbʉh pʉ jár ña̱jcu̱ cár ngu̱, du ca̱ nttzɛdi cja̱ da ddagui hne̱je̱. Ya jin da ñʉti pʉ mbo cár ngu̱ pa da gʉjqui quí mɛjti. ");
INSERT INTO otsNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bbʉ to di hño jar jua̱ji̱, guejtjo da ddajtjo, ya jin du coh pʉ jár ngu̱ pa da ga̱x ca da möti. ");
INSERT INTO otsNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jui̱ji̱ cʉ bbɛjña̱ cʉ di hñʉ, cʉ pa‑cʉ́, co cʉ bbɛjña̱ cʉ di tjɛ quí tzi ba̱jtzi, di tzʉjti, como da ndo sufri gueguejʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nuquɛjʉ, gui dyöjpijʉ ca Ocja̱ pa jin da ncja yʉ cosa‑yʉ́ cʉ za̱na̱ rá ntzɛ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Como bbʉ xta ncja yʉ xtú xihquijʉ, da ndo sufri cʉ cja̱hni. Nunca xtúr nú̱ cʉ cja̱hni car sufrimiento ca di jñɛjmi‑cá̱, desde bbʉ mí ttøti nʉr jöy hasta car pa‑cá̱. Nttzɛditjo da sufri‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tanto da sufri cʉ cja̱hni cʉ pa‑cʉ́, tje di du̱jʉ, bbʉ jin di ma̱n ca Ocja̱ da hna nttzɛdi pʉ car sufrimiento. Nu ca Ocja̱, como i mbe̱ndi cʉ cja̱hni cʉ xí cjajpi í mɛjti, xta mandado pa da hna nttzɛdi pʉ car sufrimiento‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Cʉ pa‑cʉ́, bbʉ to da xihquijʉ: “Jiantijma̱jʉ, rá bbʉj nʉ rá cjanʉ car Cristo ca xí hñi̱x ca Ocja̱,” cja̱ huá bbʉ da xihquijʉ: “Cca̱htijma̱jʉ, rá bbʉjcua guegue” nuquɛjʉ, jin gui hñe̱e̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Como cʉ pa‑cʉ́, da hño jiöjte rá ngu̱, da nzoh cʉ cja̱hni, da xijmʉ: “Guejquigö dúr Cristo, xí hñi̱xquigö ca Ocja̱.” Guejtjo da hño jiöjte profeta. Nucʉ́, da dyøti milagro co maravilla gá ntjöti pa da tte̱me̱. Da jionijʉ ja drí jiötijʉ göhtjo cʉ cja̱hni. Hasta quí cja̱hni ca Ocja̱, cʉ xí juajnitsjɛ, da jioni ja drí jiötijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nuquɛjʉ, gui mfödijʉ, cja̱ jin gui hñe̱me̱jʉ‑cʉ́. Ya xtú xihquijʉ te da ncja, pa bbʉ xta ncja, ya xquir pa̱dijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nu cʉ pa‑cʉ́, bbʉ ya xtrú tjoh car sufrimiento ca xtú xihquijʉ, nʉr jiadi xta hmɛxu̱y, cja̱ nʉr za̱na̱ jin da nzø. ");
INSERT INTO otsNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Guejti yʉ tzø xta jiøh pʉ jar ji̱tzi, cja̱ göhtjo yʉ te bí bbʉj nʉ ji̱tzi da ndo jua̱ntsjɛ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Diguebbʉ ya, pé xcuá e̱cö, cʉ cja̱hni da jiantigui, ya xtrá e̱ já gu̱y, xcuá ja̱ cam cargo cja̱ co cam ttzɛdi pa gu mandado, cja̱ da tti̱zquigö. Guejquigö, dúr cja̱hni, xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Car pa‑cá̱, xtá cu̱jcö cʉm ángele, da hñojʉ göhtjo nʉr jöy co göhtjo nʉr ji̱tzi, da jmuntzijʉ göhtjo cʉ cja̱hni cʉ xí hñe̱me̱ ca Ocja̱. Du tzí‑cʉ́ desde pʉ jar norte, co pʉ jar sur, co pʉ jabʉ rí bøxi jiadi, co pʉ jabʉ rí ñʉy. Nu cʉm ángele da zøtijʉ pʉ jabʉ rá cca nʉr jöy co hne̱h pʉ jabʉ rá cca nʉr ji̱tzi, da jmu̱ntzi göhtjo cʉ cja̱hni cʉ xí hñe̱me̱ ca Ocja̱, cja̱ du tzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nuya, gui mbe̱nijʉ ja i ncja car za gá higo. Bbʉ ya xí tu̱hmi quí dyɛ cja̱ ya xqui ddoh quí xi, nubbʉ́, xquí pa̱dijʉ, ya xta mʉh cʉ za̱na̱ rá mpa. ");
INSERT INTO otsNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ncjapʉ hne̱je̱ da jogui gui pa̱dijʉ, bbʉ xta zʉh cʉ cosa‑cʉ́, ya xqui tchʉdipʉ da guaj nʉr mundo. Bbʉ xta ncja cʉ xtú xihquijʉ, ya xqui guejtipʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dí xihquijʉ ntju̱mʉy, jin da mpun yʉ cja̱hni yʉ i bbʉjcua hasta bbʉ ya xtrú nzʉdi göhtjo yʉ te xtú xihquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Da mpun nʉr ji̱tzi co nʉr jöy. Nu yʉ palabra yʉ dí ma̱ngö, jin da mpun‑yʉ́. Göhtjo da ncumpli. ");
INSERT INTO otsNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pe jin to i pa̱di mero ncjahmʉ da zʉh car pa‑cá̱, o tema hora da ncja. Jin gui pa̱h cʉ ángele cʉ bí bbʉ ji̱tzi, ni diguejquigö, ʉ́r Ttʉgui ca Ocja̱, jí̱ bbe dí pa̱di hne̱je̱. Jøntsjɛ cam Tzi Ta ca bí bbʉ ji̱tzi, bí pa̱h‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nuquiguɛjʉ, gui jña̱jʉ ʉr huɛnda, dyo guí da̱be̱nijʉ. Gui tøhmijʉ car pa‑cá̱, cja̱ gui dyöjpijʉ ca Ocja̱ da möxquijʉ, como jin guí pa̱dijʉ ncjahmʉ da zøh car pa‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nugö, xcuá hna e̱tjo, ncja hnar hñøjø ca ya xí mbøm pʉ́r ngu̱, xí ma yapʉ. Ante que di ma, bi döjti cár cargo cʉ muzo, cada hnaa cár bbɛfi. Guejtjo xí bbɛjpi car portero da mföh pʉ jar goxtji, xí xifi jin da a̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hne̱quigö, dí ncja ngu̱ car mi̱ngu̱ ca bi bøni. Dí xihquijʉ hne̱je̱, gui tzödijʉ, gui tøbiguijʉ, como jin guí pa̱dijʉ ncjahmʉ xtá hna tzøjø, nuguigö, ir jmu̱guigöjʉ. Jin guí pa̱dijʉ, ¿cja xcuá e̱cö ya xtúr nde, o madé ʉr xu̱y, o bbʉ xta mah car ndøxca, o bbʉ nxuditjojo? ");
INSERT INTO otsNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gui tøhmijʉ, bbʉ́, pa bbʉ xtá hna tzøcö, jin gu töhquijʉ gri a̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cja̱ yʉ palabra yʉ xtú xihquijʉ, dí xifi göhtjo cʉ to i ne da dɛngui: Gui tzödijʉ, cja̱ gui tøbiguijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mí bbɛjti yojpa pa di zøh car mbaxcjua ca mí tsjifi ʉr Pascua, bbʉ mí tzijʉ car tju̱jme̱ ca jin te mí yojmi levadura. Nubbʉ́, cʉ möcja̱ cʉ mí mandado co cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley, bi mpɛguijʉ, mí jonijʉ ja drí dyøhtibijʉ car Jesús hnar trampa pa di zʉdijʉ cja̱ di möhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pe mí ma̱jmʉ: ―Jin gu pöhtijʉ yʉ pa ya i cja mbaxcjua, pa jin te da cjaguijʉ yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nu car Jesús mí bbʉh pʉ Betania, pʉ jár ngu̱ hnar hñøjø ca mí tsjifi múr Simón. Nucá̱, xquí tzöhui car jñi̱ni lepra. Car Jesús már ju̱h pʉ jar mexa pʉ jabʉ már tzijʉ. Cja̱ bú e̱h hnar bbɛjña̱, mbá tu̱ hnar botella már tzi zö, mí po hnar perfume ca már ndo ma̱di cja̱ mí yʉni rá tzi ncʉji. Car bbɛjña̱ bi wajqui car botella, bi xihtzibi car perfume jár ña̱ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Már bbʉh pʉ cʉ dda cja̱hni cʉ bi ntsjeyɛjʉ, bi ma̱jmʉ: ―Jiøjquitjo nʉr perfume nʉ xí fön nʉr bbɛjña̱‑nʉ. Már ndo ma̱di, cja̱ xí bbɛjtjo. ¿Dyoca̱ xí dyøte ncjanʉ? ");
INSERT INTO otsNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bbʉ di bbö, di tjo tresciento denario car domi di nccu̱hti, cja̱ di jogui di ttun car domi cʉ tzi probe.― Ncjapʉ gá ma̱n cʉ cja̱hni, ngá nzohmijʉ car bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nu car Jesús bi xih‑cʉ́: ―Gui jiɛguijʉ‑nʉ́. Dyo te guí xijmʉ. Rá zö ca xí dyøjtiguigö‑nʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Göhtjo ʉr pa guí bbʉpjʉ cʉ tzi probe cʉ jin te i ja̱. Göhtjo tema pá da jogui gui föxjʉ‑cʉ́. Nuguigö, jin gu hmʉpjʉ göhtjo ʉr tiempo. ");
INSERT INTO otsNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nʉr bbɛjña̱ xí dyøjtigui göhtjo ca mí tzö mbo ʉ́r mʉy. Xí xizqui na̱r perfume na̱m ndodyo, ncjahmʉ gá hñögui, masque jim be dí tu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dí xihquijʉ ncjua̱ni, göhtjo pʉ jabʉ da jma̱ nʉr tzi ddadyo jña̱, göhtjo cʉ lugar hua jar jöy, guejtjo hne̱je̱ da jma̱n ca xí dyøti nʉr bbɛjña̱‑nʉ́, pa da fe̱ni guegue.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Diguebbʉ ya, car Judas Iscariote, hnáa digue cʉ doce hñøjø cʉ mí ntzixihui car Jesús, bi ma pʉ jabʉ már bbʉh cʉ möcja̱ cʉ mí mandado, bi xijmʉ: ―Nugö, bbʉ gui cju̱jtiguijʉ, xtá döquijʉ car Jesús.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cja̱ bi ndo mpöh cʉ möcja̱, bbʉ, bi xijmʉ car Judas tengu̱ di gu̱htijʉ bbʉ di dö car Jesús. Bbʉ ya xquí gojmʉ acuerdo, pé bi ma car Judas, bbʉ, cja̱ desde guebbʉ, bi jioni ja drí dö car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Car primero car pa ca mí tzijʉ cʉ tju̱jme̱ cʉ jin te mí yojmi levadura, bbʉ mí pöhtijʉ cʉ tzi dɛti gá mbaxcjua, quí möxte car Jesús bi dyönijʉ‑cá̱: ―¿Jabʉ guí ne grá möjme gu jojquije pa gu tzöjʉ car mbaxcjua?― ");
INSERT INTO otsNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Guegue ya bi gu̱ yojo quí möxte, bi xijmi: ―Gui mɛhui pʉ jar ciudad, xquí ntjɛjʉ hnar hñøjø ba tu̱ hnar xøni i po deje. Gui tɛnihui car hñøjø‑cá̱, ");
INSERT INTO otsNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","cja̱ pʉ jabʉ da ñʉti, gui cʉtihui hne̱je̱, cja̱ gui xijmi car mi̱ngu̱: “I ma̱n cam maestroje, i̱na̱: ¿Jabʉ i bbʉh car cuarto pʉ jabʉ gu tzi car jñu̱ni gá mbaxcjua, nugö co yʉ hñøjø yʉ dí yobbe?” ");
INSERT INTO otsNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nubbʉ́, car mi̱ngu̱ xta u̱jtiquihui hnar cuarto rá nojo, bí bbʉh pʉ ña̱. Ya xná bbʉh pʉ göhtjo ca te gu nestajʉ. Guehpʉ jar cuarto‑cá̱ gui jojquihui pa gu tzöjʉ car mbaxcjua.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bi ma cʉ yojo quí möxte, bbʉ, gá nzøjmi jar ciudad, bi döti göhtjo ncja ngu̱ gá tsjijmi, cja̱ bi jojquihui ca mí nesta pa di zöjʉ car mbaxcjua. ");
INSERT INTO otsNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mí zøh car nde‑cá̱, car Jesús bi mɛhui cʉ doce quí möxte, cja̱ bi zønijʉ pʉ jabʉ xquí tjojqui. ");
INSERT INTO otsNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cja̱ bi mi̱pjʉ pʉ jar mexa, bi mʉdi bi zijʉ. Bbʉ már tzijʉ, bi ma̱n car Jesús: ―Dí göhtjojʉ dár tzijʉ hua, pe i bbʉhquiguɛjʉ ca hnaa ca da döguigö.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Diguebbʉ ya, quí möxte car Jesús bi mʉdi bi jmi̱du̱jʉ, cja̱ mí ma̱jmʉ ngu̱‑hna ngu̱‑hna, mí önijʉ car Jesús: ―¿Cja guejquigö gua øtigö‑ca̱?, ¿Cja guejquigö?― ");
INSERT INTO otsNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Diguebbʉ ya, car Jesús pé bi da̱di: ―Hnaa diguehquɛjʉ, guí doce ʉm möxtequijʉ, xta dyøjtigui ncjapʉ. Guegue ra tjʉhmi cár tju̱jme̱ hnaadi na̱r moji hua dár tjʉhmi cam tju̱jme̱gö hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cierto, ya xí ma̱n ca Ocja̱ i nesta gu tu̱, ncja ngu̱ ga ma̱m pʉ jar Escritura, como guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. Pe nde̱jma̱ dí ndo jui̱jqui car hñøjø ca da döguigö jáy dyɛ cʉ cja̱hni cʉ da möjtigui. Más di joh bbʉ jin di hmʉh car hñøjø‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Már ju̱jʉ jar mexa, már tzijʉ, cja̱ car Jesús bi jña̱ hnar tju̱jme̱, bi dyöjpi ca Ocja̱ di bendeci. Diguebbʉ ya, bi xɛjqui, cja̱ bi un quí möxte hna‑hnár tzi pedazo. Bi xijmʉ: ―Gui jña̱guɛjʉ, cja̱ gui tzijʉ. Na̱r tju̱jme̱‑na̱, ʉm cuerpogö.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Diguebbʉ ya, bi du̱u̱ car vaso, cja̱ guejtjo bi dyöjpi mpöjcje ca Ocja̱ por rá ngue car vino. Ma ya bi uni hna‑hna quí möxte, cja̱ cada hnaa bi zi hna tzi tʉjqui ʉr vino. ");
INSERT INTO otsNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nubbʉ, bi xijmʉ: ―Na̱r vino‑na̱, gue cam cji bbʉ xta mföni. Bbʉ xta ncja‑ca̱, xta ttøti hnar ddadyo acuerdo pa yʉ cja̱hni rá ngu̱, pa sa̱nta̱ da döti car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dí xihquijʉ ncjua̱ni, ya jin gu yojpi gu tzigö vino hasta car pá bbʉ xtá fʉdi xtá mandadogöbbe co cam Tzi Ta. Nubbʉ, cja xtá tzigöjʉ car ddadyo vino pʉ jabʉ i mandado ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Diguebbʉ ya, car Jesús, yojmi quí möxte, bi xödijʉ hnar tsjödi, cja̱ bi bønijʉ gá möjmʉ jar ttøø ca mí tsjifi Olivos. ");
INSERT INTO otsNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nubbʉ́, car Jesús bi xih quí möxte: ―Göhtjoquiguɛjʉ, gui ma gui wembiguijʉ rá nxu̱nya, como ngu̱ ga ma̱m pʉ jar Escritura. I ma̱ ncjahua: “Da bböhti car mödi, cja̱ tje da mfonti cʉ dɛjti.” ");
INSERT INTO otsNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pe bbʉ ya xcrú nantzigö, gu hmɛto, pe grá ma pʉ Galilea, cja̱ nuquiguɛjʉ, xquí tɛnguijʉ xcrí ntjɛjʉ pʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Diguebbʉ, car Pedro bi xih car Jesús: ―Masque da wembiqui göhtjo yʉ ddáa, pe nugö, jin gu wembiqui.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nu car Jesús bi xifi: ―Dí xihqui ntju̱mʉy, nuquiguɛ, nuya rá nxu̱nya, ante que da mah car ndøxca yo vez, xquí cøngui jñu̱ vez, xquí ma̱ jin guí meyagui.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nubbʉ́, bi zøti ʉ́r mʉy car Pedro, cja̱ bi da̱di nzajqui: ―¡Ji̱na̱! Masque i nesta gu tu̱hui, nim pa gu cønqui ca dár meyaqui.― Diguebbʉ ya göhtjo cʉ dda quí möxte bi ma̱ndijʉ ncjapʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ma ya bi zøtijʉ hnar huerto ca mí tsjifi Getsemaní. Cja̱ car Jesús bi xih quí möxte, bbʉ: ―Gui mi̱pjʉ hua, gár magö nʉ rá cjanʉ, gu ma nzoh ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cja̱ guegue bi zix car Pedro co car Jacobo co car Juan, bi ma nʉ rá tzi cjanʉ, nu car Jesús bi mʉdi bi ndo ntzøte cja̱ bi jmi̱du̱ rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Cja̱ bi xih cʉ jñu̱ quí möxte cʉ xquí zitzi: ―I ndo jmi̱du̱ nʉm tzi mʉy, ya xtá tu̱. Nuquɛjʉ, gui tøhmijʉ hua, gui tzödijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Cja̱ guegue pé bi ma tzi yanʉ, cja̱ bi hmɛmfo jar jöy, bi nzoh ca Ocja̱. Bi dyöjpi ¿cja jin di jogui di gʉhtzibi ca mír nesta di du̱? ");
INSERT INTO otsNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Bi ma̱: ―Nuquiguɛ, ʉm Tzi Taqui, guí pa̱di ja gui cjajpi göhtjo yʉ cosa. Gui cjʉzqui tzʉ nʉr prueba‑nʉ́. Pe nde̱jma̱, jin da ttøti ca dí negö. Da ttøti ca guí neguɛ.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Diguebbʉ ya, bú coh pʉ jabʉ már bbʉh cʉ jñu̱ quí möxte, már a̱h‑cʉ́. Cja̱ car Jesús bi xih car Pedro: ―Nuquɛ, Simón, ¿cja gár a̱quɛ hne̱je̱? ¿Cja jí̱ mí tzö güi tzödiguɛ, ma̱di hna hora? ");
INSERT INTO otsNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gui tzödijʉ cja̱ gui nzojmʉ ca Ocja̱, pa bbʉ xta zʉhquijʉ hnar prueba, jin da da̱hquijʉ. Mbo ir mʉyjʉ, guí ne gui dyøtijʉ ca rá zö. Nu yir cuerpojʉ jin gui ne da jiɛhqui gui tzɛjtijʉ prueba.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Diguebbʉ ya, pé bi ma car Jesús, bi ma bú nzoh ca Ocja̱ nʉ rá cjanʉ. Cja̱ pé bi yojpi bi ma̱n cʉ palabra cʉ ya xquí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cja̱ pé bú coh pʉ jabʉ már bbʉh quí möxte. Pe bi dötitjo már a̱h‑cʉ́, como mí ndo ca̱di tta̱ja̱ quí döjʉ. Cja̱ bbʉ mí nzojmʉ car Jesús, gueguejʉ jí̱ mí pa̱di te drí da̱dijʉ. Car Jesús pe bi ma gá ngoh bbʉ, pé bú ora. ");
INSERT INTO otsNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Diguebbʉ ya, pe hna tzi rato, pé bú e̱h ca xtrá jñu̱ vez, cja̱ bi xih quí möxte: ―¿Cja gár a̱tijʉ? ¿Cja jí̱ xcá jogui güi tzödijʉ? Ya co guehca̱. Jiantijma̱jʉ, ya xí nzʉh car hora. Ya xta ndöguigö jáy dyɛ yʉ cja̱hni yʉ i ndu̱jpite, guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gui nantzijʉ ya, gu möjö. Tji ya‑nʉ́, ya xpa e̱j nʉ to da döguigö.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bbʉ már ña̱di car Jesús, bi zøh car Judas Iscariote pʉ jabʉ már bbʉ guegue. Car Judas mí yojma̱hui cʉ pé dda once quí möxte car Jesús. Guejtjo pé mbá e̱ pé dda cja̱hni rá ngu̱, mbá tɛnijʉ car Judas. Mbá cʉjʉ espada, co za. Cʉ möcja̱ cʉ mí mandado co cʉ maestro cʉ mí nxöh car ley, cja̱ co cʉ tita cʉ mí pɛhtzi cár cargojʉ, göhtjo‑cʉ xcuí gu̱jmʉ cʉ cja̱hni rá ngu̱ pa di mföxijʉ di zʉdijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Car Judas Iscariote ya xquí xih cʉ pé dda cja̱hni hnar seña pa drí meyajʉ toca̱ di pɛntijʉ. Guegue xquí ma̱: ―Car hñøjø ca gu nda̱ne, guehcá̱ gui pɛntijʉ, cja̱ jin gui jiɛjmʉ da ddagui.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cja̱ car Judas, bbʉ mí zøm pʉ jabʉ már bbʉh car Jesús, bi guati nttzɛdi, bi zɛngua, bi xifi: ―Nuquiguɛ, Maestro, ¿cja guí bbʉjtjo?― Cja̱ bi ndo nda̱ne rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Diguebbʉ ya, cʉ to mbá yojmi car Judas bi pɛntijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Hna cʉ hñøjø cʉ mí yojmi car Jesús, bi gʉx cár espada, bi dyojquibi ca hnár gu̱ hnar muzo ca már bböh pʉ. Nucá̱ mí pɛjpi car möcja̱ ca más mí ja̱ cár cargo. ");
INSERT INTO otsNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nu car Jesús bi xih cʉ cja̱hni cʉ xcuí hñe̱je̱, bi hñi̱mbi: ―¿Dyoca̱ xcú e̱jmʉ gui tzʉjquijʉ, ncjahmʉ gur be̱gö, guá cʉjʉ espada co za? ");
INSERT INTO otsNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Göhtjo ʉr pa ndár dégö pʉ jar templo, ndár u̱jti cʉ cja̱hni pʉ́, cja̱ nuquiguɛjʉ, jin te gú cjaguijʉ. Cja̱ nuya, ya xcú tzʉjquijʉ, pa da zʉh ca i ma̱m pʉ jar Escritura.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bbʉ mí ttzʉh car Jesús, göhtjo quí möxte bi wembijʉ, bi ddajmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Guejtjo már bbʉh pʉ hnar ba̱jtzi hñøjø, mí tɛn car Jesús hne̱je̱. Jøña̱ hnar sábana mí pöti‑cá̱. Cʉ cja̱hni bi pɛnti‑cá̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nucá̱ bi ddagui, bi zoh cár sábana, ya jin te mí je. ");
INSERT INTO otsNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nubbʉ́, bi ttzix car Jesús pʉ jabʉ már bbʉh car möcja̱ ca más mí pɛhtzi cár cargo. Cja̱ bi jmu̱ntzijʉ hne̱je̱ göhtjo cʉ dda möcja̱ cʉ mí pɛhtzi cargo, co cʉ tita, co cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley. ");
INSERT INTO otsNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Car Pedro xquí dɛni yapʉ, xquí zøti pʉ jár tji car ngu̱ pʉ jabʉ mí bbʉh car da̱möcja̱. Már ju̱hui cʉ policía, már pahtijʉ pʉ jar tzibi. ");
INSERT INTO otsNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nu cʉ möcja̱ cʉ mí mandado, cja̱ co car junta cʉ tita cʉ mí pɛhtzi cargo jár templo cʉ judio, már jonijʉ tema cosa rá nttzo xtrú dyøti car Jesús, pa di tja̱mpi ʉr huɛnda cja̱ di ttuni sentencia pa drí bböhti. Pe jin gá ndöhtibijʉ te xtrú dyøte. ");
INSERT INTO otsNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Már ngu̱ cʉ jiöjte testigo cʉ mí xohtzibi bbɛtjri car Jesús, bi jiøxjʉ ca te xtrú dyøti‑ca̱, pero jin gá ntjɛhui cʉ palabra cʉ mí ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Diguebbʉ ya, pé bi bböh cʉ ddaa ya, pé bi xohtzibi pé dda bbɛtjri guegue, bi ma̱jmʉ: ");
INSERT INTO otsNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nugöje, dú øjme ngá ma̱ nʉr cja̱hni‑nʉ: “Gu yøhti nʉr templo nʉ xí dyøti yʉ cja̱hni. Diguebbʉ ca xtrá jñu̱jpa, pé gár xoxcö pé hnaa ca jí̱ xtrú dyøti yʉ cja̱hni.”― ");
INSERT INTO otsNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Cja̱ guejti cʉ testigo‑cʉ, jin gá ntjɛhui ca mí ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Diguebbʉ ya, car da̱möcja̱ bi hmöh pʉ madé cʉ pé dda möcja̱ co cʉ tita cʉ xquí jmu̱ntzi, cja̱ bi dyön car Jesús, bi hñi̱mbi: ―Xiquiguɛ, ¿cja jin guí ne gui tja̱di? ¿Cja cierto xcú dyøti cʉ cosa cʉ i ma̱n yʉ cja̱hni‑yʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nu car Jesús jin te gá nda̱di. Ma ya, pé bi dyön car da̱möcja̱: ―¿Cja guehquiguɛ, xí hñi̱xqui ca Ocja̱ pa gui mandadoguije? ¿Cja ʉ́r Ttʉqui ca Ocja̱ ca rá nttzu̱jpi?― ");
INSERT INTO otsNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bi da̱j ya car Jesús, bi xifi: ―Guejquigö. Nuquiguɛjʉ, xquí jiantiguijʉ bbʉ ya xcuá e̱cö já gu̱y pʉ jar ji̱tzi. Guejtjo xquí jiantiguijʉ, xcár mi̱jcö pʉ jár jogui dyɛ car Tzi Ta ji̱tzi, xcár mföxibbe bbʉ xta mandado. Guejquigö dúr cja̱hni, xpá bbɛnquigö hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Diguebbʉ ya, car da̱möcja̱ bi ndo ntzøte, bi xɛjqui quí da̱jtu̱. Cja̱ bi xih cʉ ddaa cʉ már bbʉh pʉ: ―¿Dyoca̱ dí jongöjʉ pé dda testigo? ");
INSERT INTO otsNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya xcú dyødejʉ te xí ma̱ nʉr hñøjø‑nʉ. I ne da cjatsjɛ Ocja̱. Xiquɛjʉ, ¿ja ncja guir mbe̱nijʉ? ¿Te da ncjajpi?― Cja̱ göhtjo bi da̱dijʉ: ―¡Rí ntzöhui da bböhti!― ");
INSERT INTO otsNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cʉ ddaa cʉ már bbʉh pʉ, bi mʉdi bi zoxjʉ car Jesús. Bi gojtibijʉ quí dö, cja̱ bi føjnijʉ. Bi xijmʉ: ―Pa̱quɛ ya, ¿Toca̱ xí føjnqui?― Cja̱ guejti cʉ policia bi mɛhtibijʉ cár jmi car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Car Pedro már bbʉh pʉ jöy, pʉ jar tji. Cja̱ bú e̱h ca hnar muza ca mí pɛjpi car da̱möcja̱. ");
INSERT INTO otsNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bi jianti car Pedro, már pahti pʉ jar tzibi, bi ju̱dö cja̱ bi xifi: ―Nuquiguɛ, hne̱je̱, nguí yojmi car Jesús, car mi̱ngu̱ Nazaret.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nu car Pedro bi gøni, bi ma̱: ―Jin dí meyagö‑cá̱, cja̱ jin dí ntiendegö ca guí ma̱.― Ma ya bi bøm pʉ jar goxtji, cja̱ nubbʉ́, bi mah car ndøxca. ");
INSERT INTO otsNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Car muza pé bi ntjɛhui car Pedro, cja̱ pé bi mʉdi bi xih cʉ már bbʉh pʉ: ―Guejti‑nʉ, mí tɛn car Jesús.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nu car Pedro pé bi yojpi bi gøni. Diguebbʉ hna tzi rato, cʉ cja̱hni cʉ már bbʉh pʉ pé bi xijmʉ car Pedro: ―Ncjua̱ni, nuquiguɛ nguí yojmi quí möxte guegue, como gúr mi̱ngu̱ Galilea hne̱je̱. Guí ña̱ ncja ngu̱ ga ña̱ gueguejʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nubbʉ́, car Pedro bi ndo pura bi gøni, cja̱ bi ma̱ nzajqui: ―Dí hñi̱jcö ca Ocja̱ gá testigo, jin dí meyagö car hñøjø ca guí ma̱jmʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cja̱ car hora‑cá̱ bi mah car ndøxca ca xtrá yo vez. Diguebbʉ ya, car Pedro bi mbe̱n cʉ palabra cʉ xquí ma̱n car Jesús: “Ante que da mah car ndøxca yo vez, xquí cøngui jñu̱ vez.” Cja̱ bi ndo nzoni bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bbʉ mí ni̱gui ya car jiax‑cá̱, bi jmuntzijʉ cʉ möcja̱ cʉ mí mandado, co cʉ tita cʉ mí ja̱ cár cargojʉ jar templo hne̱h cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley, cja̱ co göhtjo cʉ más mí mandado. Bi jmu̱ntzi‑cʉ́ pa bi ma̱jmʉ te di ncjajpi car Jesús. Guegue‑cʉ́ bi mandado bi hnu̱htibi quí dyɛ car Jesús cja̱ bi ttzix pʉ jabʉ már bbʉh car Pilato, como guegue‑ca̱ múr gobernador, cja̱ más már ji̱tzi cár cargo. ");
INSERT INTO otsNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Car Pilato ya bi dyön car Jesús: ―Nuquiguɛ, ¿cja ʉ́r reyqui cʉ judio?― Bi da̱j ya car Jesús: ―Guejquigö, ncja ngu̱ guir ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nu cʉ möcja̱ cʉ mí mandado bi jiøxjʉ car Jesús nduntji cosa rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pé bi yojpi bi dyön car Pilato, bbʉ́: ―¿Cja jin te guí tja̱jquɛ? Dyøjma̱ja̱, te tza rá ngu̱ cʉ cosa i ma̱n yʉ cja̱hni xcú dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nu car Jesús jin te gá nda̱di. Eso, bi ndo hño ʉ́r mʉy car Pilato. ");
INSERT INTO otsNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada ncjeya, bbʉ mí cja car mbaxcjua‑cá̱, mí tjɛgui dí bøni libre hnar preso. Cʉ cja̱hni mí juajnijʉ toca̱ di tjɛgui di bøni. ");
INSERT INTO otsNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mí bbʉh ca hnar preso, mí ju̱ cár tju̱ju̱ múr Barrabás. Guegue mí bbʉ jar födi co cʉ dda cja̱hni xquí mföxjʉ, xquí dyøhtibijʉ tujni cʉ autoridad. Xquí möhtijʉ hnar ánima bbʉ már ntu̱jnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nu cʉ cja̱hni rá ngu̱ cʉ xquí jmu̱ntzijʉ, bi guatijʉ pʉ jabʉ már bbʉh car Pilato. Bi mʉdi bi dyöjpijʉ car Pilato di tjɛgui libre hnar preso, como ngu nguá ttøte cada ncjeya. ");
INSERT INTO otsNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Car Pilato bi dyöni, bbʉ́: ―¿Cja guí nejʉ da tjɛgui libre nir reyjʉ, nuquɛjʉ guí judiojʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bi dyöni ncjapʉ car Pilato, como mí pa̱di te rá nguehca̱ xquí ndö car Jesús. Cʉ möcja̱ cʉ mí mandado xquí döjʉ porque mí ndo ʉjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Cja̱ nucʉ́ bi dyɛti cʉ cja̱hni rá ngu̱ di xih car Pilato, más mí nejʉ pa di tjɛgui libre car Barrabás, cja̱ car Jesús di bböhti. ");
INSERT INTO otsNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pé bi da̱h car Pilato, bi dyön cʉ cja̱hni, bbʉ́: ―¿Te guí nejʉ gu cjajpi nʉr hñøjø nʉ guí xijmʉ nir reyjʉ, nuquɛjʉ guí judiojʉ?― ");
INSERT INTO otsNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Cja̱ cʉ cja̱hni pé bi yojpi bi majmʉ nzajqui: ―¡Da ddøti jar ponti!― ");
INSERT INTO otsNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Car Pilato bi dyöni, bbʉ́: ―¿Ter bɛh ca̱ rá nttzo xí dyøti‑nʉ́?― Nu gueguejʉ rá ngu̱ vez bi ndo majmʉ nzajqui: ―¡Da ddøti jar ponti!― ");
INSERT INTO otsNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Diguebbʉ ya car Pilato bi jiɛgui libre car Barrabás, como mí ne di pöjpi cʉ cja̱hni. Cja̱ bbʉ ya xquí tjʉti car Jesús, bi ndö pa di ttzitzi drí ddøti jar ponti. ");
INSERT INTO otsNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Diguebbʉ cʉ sundado bi zix car Jesús pʉ jár tji cár palacio car gobernador. Car lugar‑cá̱, mí tsjifi car Pretorio. Cja̱ bi ttzojni göhtjo car batallón cʉ sundado, bi jmuntzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nubbʉ́, cʉ sundado bi jejtibijʉ car Jesús hnar da̱jtu̱ már ncjʉjpöy. Cja̱ bi jñu̱htzibijʉ hnar corona gá hmini. ");
INSERT INTO otsNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Diguebbʉ ya bi mʉdi bi burlabitjojʉ, segue mí ma̱jmʉ: ―¡Da ncja ʉ́r nzajqui nʉ́r rey yʉ judio!― ");
INSERT INTO otsNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mí fɛhtibijʉ cár ña̱ co hnar tzi za, cja̱ mí tzoxijʉ guegue. Cja̱ mí fɛjtitjojʉ ncjahmʉ már i̱htzibijʉ, mí cuatijʉ cja̱ mí nda̱ndiña̱jmu̱jʉ pʉ jáy huá car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bbʉ mí guaj ya mí i̱mbijʉ, bi ccohtibijʉ car da̱jtu̱ már ncjʉjpöy, cja̱ bi jejtibijʉ quí da̱jtu̱tsjɛ guegue. Nubbʉ́, bi gʉjquijʉ pʉ jar jñi̱ni, bi dyɛnijʉ pʉ jabʉ di døtijʉ jar ponti. ");
INSERT INTO otsNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cja̱ bbʉ mír möjmʉ, bi ntjɛhui hnar hñøjø ca mbá tjoh pʉ, mbá e̱ jar campo hnanguadi car ciudad Jerusalén. Guegue múr Simón, múr mi̱ngu̱ car jöy Cirene. Múr tahui car Alejandro co car Rufo. Cja̱ cʉ sundado bi cjajpijʉ car Simón bi du̱htzibi cár ponti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bi zixjʉ car Jesús pʉ jar lugar ca mí tsjifi Gólgota. Nʉr tju̱ju̱‑nʉ́ i ne da ma̱ ʉr lugar gá ximo. ");
INSERT INTO otsNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nubbʉ́, cʉ sundado bi ña̱htibijʉ car Jesús vino ca mí yojmi hnar hñi̱tji pa di tzi meno ca di sufri. Car hñi̱tji‑cá̱ mí tsjifi ʉr mirra. Nu car Jesús jin gá nzi. ");
INSERT INTO otsNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cʉ sundado, bbʉ ya xquí døtijʉ jar ponti, bi jejquibijʉ quí da̱jtu̱, cja̱ bi dyɛntzijʉ bolado pa di ba̱dijʉ tema da̱jtu̱ di toca cada hnaa, hna‑hnár da̱jtu̱ di ga̱xjʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cja̱ bbʉ mí ddøti car Jesús pʉ jar ponti, mí zʉ jñu̱ hora desde bbʉ mí bøx car jiadi. ");
INSERT INTO otsNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Cja̱ bi ncuajti hnar seña pʉ jár ña̱ car ponti, pʉ xøtze jár ña̱ car Jesús. Mí ma̱ ncjahua car seña: ―Gue nʉ́r rey yʉ judio.― ");
INSERT INTO otsNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Guejtjo hne̱je̱, bi ddøti já ponti yojo be̱, hnanguadi pʉ jabʉ mí ddøti car Jesús. Ca hnaa gá ddøti pʉ jár jogui dyɛ, cja̱ ca hnaa ya pʉ jár nccuarga. ");
INSERT INTO otsNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bi ncjapʉ gá nzʉh car palabra ca i ma̱m pʉ jar Escritura: “Guegue bi jnu̱ ncja ngu̱ cʉ cja̱hni cʉ i ndu̱jpite.” ");
INSERT INTO otsNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cja̱ cʉ cja̱hni cʉ má tjoh pʉ, má ntsjundöjʉ, göhtjo te mí xijmʉ car Jesús, mí jua̱ti quí ña̱jʉ cja̱ mí øhtibijʉ burla. Mí xijmʉ: ―Nuquiguɛ, nguí ina̱ güi yøhti cár templo ca Ocja̱, cja̱ diguebbʉ, jñu̱jpa pé güi xotzi. ");
INSERT INTO otsNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nuya, gui untsjɛjɛ quer nzajqui ya, cja̱ gui ca̱jtsjɛ pʉ jar ponti.― ");
INSERT INTO otsNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Guejtjo hne̱je̱ cʉ möcja̱ cʉ mí mandado, co cʉ maestro cʉ mí nxöh car ley, mí i̱mbijʉ car Jesús, mí ña̱tsjɛjʉ, mí ma̱jmʉ: ―Nʉr Jesús, xí uni í nzajqui cʉ dda cja̱hni. Nu guejtsjɛ guegue, jin gui tzö da untsjɛ cár nzajqui. ");
INSERT INTO otsNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Tji nʉr cja̱hni nʉ i ma̱, guegue ʉr Cristo nʉ xí hñi̱x ca Ocja̱! ¡Tji nʉ to i ma̱, guegue ʉm reyjʉ, dí judiojʉ! Nuya, da ga̱jtsjɛ pʉ jar ponti, pa gu cca̱htijʉ cja̱ gu e̱me̱jʉ, ¿cja ntju̱mʉy ca xí ma̱‑nʉ́?― Guejtjo hne̱je̱ cʉ yojo be̱ cʉ már ddøtihui pʉ já ponti, hna‑hna hnanguadi car Jesús, guejti‑cʉ́ mí xijmi palabra rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bbʉ mí zʉh car hora mí madé mpa, bi hmɛxu̱y göhtjo nʉr jöy hasta guebbʉ mí zʉ jñu̱ nde. ");
INSERT INTO otsNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Cja̱ bbʉ mí zʉ jñu̱ nde, car Jesús bi mafi nzajqui, bi ma̱: ―Eloi, Eloi, ¿lama sabactani?― Na̱r palabra‑ná̱ i ne da ma̱: “Nuquiguɛ, ʉm Cjá̱a̱‑qui, dí nzohqui ya, ¿dyo ya‑ca̱ xcú jiɛguigui?” ");
INSERT INTO otsNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Cja̱ bbʉ mí dyøh cʉ dda cja̱hni cʉ már bbʉh pʉ, bi ma̱jmʉ: ―¡Dyøjma̱jʉ, i mahti car Elías!― ");
INSERT INTO otsNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nubbʉ́, ca hnar cja̱hni ca már bbʉh pʉ, bi gʉ ʉr ddiji, bi moh hnar esponja cor vinagre, bi dujti hnar tzi za, cja̱ bi pahtzi pʉ jár ne car Jesús, pa di zʉhtzi. Cja̱ bi ma̱jmʉ: ―Tøhmijʉ tzʉ, gu cca̱htijʉ, ¿cja du e̱h car Elías da dɛjqui jar ponti?― Mí ma̱jmʉ ncjapʉ como mí í̱na̱jʉ, bbʉ mí mahti ca Ocja̱ car Jesús, mí ne di nømbi cár tju̱ju̱ car profeta Elías. ");
INSERT INTO otsNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nu car Jesús bi zʉhtzi car vinagre, cja̱ diguebbʉ ya, bi mafi nzajqui, bi du̱. ");
INSERT INTO otsNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bbʉ mí ncja‑cá̱, bi xɛh car cortina ca mí hna̱x pʉ mbo car templo. Bi xɛ madé. Bi mʉdi bi xɛh pʉ ña̱ hasta gá nzø jöy. ");
INSERT INTO otsNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nu car sundado ca mí mandado cʉ pé ddáa, már bböh pʉ hnanguadi pʉ jabʉ mí ddøti car Jesús. Cja̱ bbʉ mí cca̱hti ja gá ndu̱ car Jesús, bi ma̱ guegue: ―Nʉr hñøjø‑nʉ́ cierto múr ttʉ ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Guejtjo hne̱je̱ már bbʉh pʉ cʉ dda bbɛjña̱, már janti yanʉ te mí ncja. Már bbʉh pʉ car María Magdalena co ni car María ca múr mehui car José hne̱h car Jacobo. Nu car Jacobo‑cá̱ mí tsjifi ʉr tchʉ. Guejtjo hne̱je̱ már bbʉh pʉ ca hnar bbɛjna̱ mí ju̱ cár tju̱ju̱ múr Salome. ");
INSERT INTO otsNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nu cʉ bbɛjña̱‑cʉ́, mí tɛnijʉ car Jesús, xcuí hñe̱h pʉ Galilea, cja̱ xquí cjajpijʉ jmandado. Guejtjo hne̱je̱ már bbʉh pʉ pé dda bbɛjña̱ rá ngu̱ cʉ xquí dɛnijʉ car Jesús bbʉ mbú pøx pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bbʉ ya xquí nde, cʉ judio mí mpɛguijʉ, mí jojquijʉ ca te mí nestajʉ pa car jiax‑cá̱, como mí tzu̱jpijʉ car pa‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mí bbʉh ca hnar hñøjø, mí ju̱ car tju̱ju̱ múr José. Guegue múr mi̱ngu̱ Arimatea. Múr tita cja̱ mí pɛhtzi cár cargo co cʉ pe dda tita jár templo cʉ judio, cja̱ mí tti̱htzibi. Guegue mí tøhmi di hñe̱h car pa bbʉ xta mandado ca Ocja̱ hua jar jöy. Nʉr José ddatsjɛ bi ma, bi ñʉti pʉ jabʉ már bbʉh car Pilato, jin te mí tzu̱. Bi dyödi di ungui ʉr tsjɛjqui di mɛhtzibi cár cuerpo car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nu car Pilato bi hño ʉ́r mʉy cja̱ bi hñöni, ¿cja ya xquí du̱ car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bi mahti car capitán, bbʉ, bi dyöni. Nucá̱ bi xifi: ―Ja̱a̱, ya xí ndu̱.― Diguebbʉ ya car Pilato bi mandado di ndöjti cár cuerpo car Jesús pa di du̱x car José. ");
INSERT INTO otsNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nucá̱, bi döni hnar sábana, bi ma bú tjɛjqui cár cuerpo car Jesús pʉ jar ponti, cja̱ bi möx car sábana. Cja̱ bi göti cár ánima mbo hnar cueva gá mé̱do. Diguebbʉ ya, bi pʉntzi hnar ndo me̱do pʉ jár goxtji car cueva, gá ngoti. ");
INSERT INTO otsNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Már bbʉh pʉ car María Magdalena co car María ca múr me car José. Gueguehui már jantihui bbʉ mí cjöti cár cuerpo car Jesús pʉ mbo car cueva. ");
INSERT INTO otsNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cja̱ bbʉ ya xquí tjoh car pa ca mí tzöya cʉ judio, car María Magdalena co car María ca múr me car Jacobo, cja̱ hne̱h car Salome, bi döjmʉ perfume cja̱ bi möjmʉ pʉ jar cueva pa di gohtzibijʉ cár cuerpo car Jesús. Ncjapʉ nguá cjajpi quí ánimajʉ cʉ judio, pa jim pe drí xa̱jtjo. ");
INSERT INTO otsNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cʉ bbɛjña̱ bi möjmʉ ndo nxu̱ditjo ca primero ʉr pa car semana, cja̱ bbʉ mí zønijʉ jar cueva, cja mbá pøx car jiadi. ");
INSERT INTO otsNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Má ña̱tsjɛ cʉ bbɛjña̱, már hñönijʉ: ―¿Toc̱a da pʉntziguijʉ car ndo me̱do pa da wem pʉ jár goxtji car cueva?― ");
INSERT INTO otsNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Diguebbʉ ya, bi cca̱htijʉ, ya xquí mbʉntzi car me̱do, masque már ndo nojo. ");
INSERT INTO otsNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Cja̱ bi ñʉtijʉ mbo car cueva, bi cca̱htijʉ hnar ba̱jtzi hñøjø, már ju̱h pʉ hnanguadi. Mí je da̱jtu̱ rá ma cja̱ rá nttaxi. Cja̱ bi ndo mbih cʉ bbɛjña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nu car hñøjø bi xijmʉ: ―Dyo guí ntzu̱jʉ. Guír hñe̱jmʉ gui jionijʉ car Jesús ca múr mi̱ngu̱ Nazaret cja̱ bi ddøti pʉ jar ponti. Nucá̱ ya xí jña̱ ʉ́r jña̱. Ya jin gui bbʉjcua. Cca̱htijma̱jʉ hua jabʉ bi cjöti cár cuerpo. ");
INSERT INTO otsNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nuquiguɛjʉ, gui möjmʉ bú xijmʉ quí möxte co hne̱h car Pedro, ya xí nantzi car Jesús. Guegue ya xí hmɛto, ya xí ma pʉ Galilea. Nuquiguɛjʉ ya, gui tɛnijʉ, cja̱ pé xcrí ntjɛjʉ guegue pʉ, como ngu gá xihquijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nubbʉ́, cʉ bbɛjña̱ bi bøm pʉ jar cueva, bi ddajmʉ, como nttzɛditjo xquí mbidijʉ, hasta mí bijʉ. Cjuá mí ntzu̱jʉ, eso bi möjmʉ, cja̱ jin to te gá xijmʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Car Jesús bi jña̱ ʉ́r jña̱ ca primero ʉr pa car semana, cja̱ bbɛto bi ni̱gui pʉ jabʉ már bbʉh car María Magdalena. Nʉr María Magdalena, má̱hmɛto mí hñohui yojto cʉ nda̱ji̱ cʉ jin gui tzö, cja̱ car Jesús xquí fonguibi‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Cja̱ nʉr María, bbʉ ya xquí cca̱hti car Jesús, bi ma gá xih quí möxte‑cá̱, como nucʉ, már jmi̱du̱jʉ cja̱ már zonijʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Car María bi xijmʉ, ya xquí jña̱ ʉ́r jña̱ car Jesús, cja̱ guegue ya xquí ncca̱htihui. Nu cʉ möxte, bbʉ mí dyødejʉ, jin gá hñe̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cja̱ diguebbʉ ya, car Jesús pé bi ni̱gui pʉ jabʉ má dyo yojo cʉ hnøjø cʉ xquí dɛni. Pé hnahño mír ni̱gui guegue. Cʉ yojo hñøjø mír ma hnar lugar ca mí tzi jñajquihui car ciudad Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nucʉ́, bbʉ mí meyahui guegue, bú cjʉhui ʉr ddiji, bi ma gá ngojmi Jerusalén, bi xih cʉ pé dda quí amigo car Jesús. Nu cʉ pé ddáa, nde̱jma̱ jin gá hñe̱me̱jʉ, ¿cja cierto xquí jña̱ ʉ́r jña̱ car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Gá nga̱x ya, car Jesús pé bi ni̱gui pʉ jabʉ már bbʉh cʉ once quí möxte, már ju̱jʉ jar mexa. Cja̱ car Jesús bi huɛnti, como jí̱ mí ne di hñe̱me̱jʉ ¿cja cierto xquí jña̱ ʉ́r jña̱ guegue? Bi xifi már ndo me̱ quí mʉyjʉ. ¿Dyoca̱ jí̱ xquí ne xquí hñe̱me̱jʉ cʉ ddaa cʉ xquí cca̱htijʉ guegue bbʉ ya xquí jná̱ ʉ́r jña̱? ");
INSERT INTO otsNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Diguebbʉ ya, car Jesús bi xih quí möxte: ―Gui pønijʉ, gui hñojʉ göhtjo nʉr mundo, cja̱ gui xij nʉr evangelio göhtjo tema cja̱hni, göhtjo pʉ jabʉ i bbʉy. ");
INSERT INTO otsNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu cʉ cja̱hni cʉ da hñe̱me̱gui cja̱ da xixtje, da döti car nzajqui ca jin da tjegue. Nu cʉ jin da hñe̱me̱, da ttɛmbi car castigo‑cʉ́, cja̱ da bbɛdi. ");
INSERT INTO otsNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Cja̱ cʉ cja̱hni cʉ to da hñe̱me̱gui, da ttun cár ttzɛdi pa da dyøti milagro, pa ncjapʉ da fa̱di, cierto car palabra ca ba ja̱jʉ. Da nømbigui cam tju̱ju̱gö pa da fonguibi cʉ cja̱hni cʉ ttzonda̱ji̱ cʉ xí nzʉdi. Guejtjo da ña̱ hnahño jña̱. ");
INSERT INTO otsNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cja̱ bbʉ di hna zɛti hnar cci̱ña̱, jin te da cjajpi. Guejtjo bbʉ da ttuni jñu̱ni ca di yojmi veneno, jin te da cja. Cja̱ gueguejʉ da dyʉx quí dyɛ cʉ döhtji, cja̱ da zö‑cʉ.― ");
INSERT INTO otsNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nubbʉ́, car Tzi Ta Jesús, bbʉ ya xquí nzoh quí möxte, bi hñi̱h‑cʉ, cja̱ diguebbʉ bi ttzix pʉ ji̱tzi. Bi ma guí mi̱h pʉ jár jogui dyɛ car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nu quí möxte bi bønijʉ gá möjmʉ rá ngu̱ lugar, cja̱ bi xijmʉ cʉ cja̱hni nʉr tzi jogui jña̱. Cja̱ cam Tzi Jmu̱jʉ Jesús, bi un quí möxte cár ttzɛdi guegue, bi mötzi pa bi dyøtijʉ milagro, ncja ngu̱ gá xijmʉ. Ncjapʉ gá fa̱di mí cierto car palabra ca mí ma̱jmʉ. Amén. I ttzɛdi hua na̱r libro‑ná̱.");
INSERT INTO otsNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nuquɛ, ʉm tadaqui Teófilo, ya xná ngu̱ yʉ cja̱hni xí jñu̱x ca mí øti car Jesús bbʉ mí dyo hua jar jöy, pa gu pa̱dijʉ ter bɛh ca̱ bi ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mí bbʉh cʉ dda hñøjø cʉ xquí dɛn car Jesús desde jar mʉdi. Guegue‑cʉ bi cca̱hti göhtjo ja mí ncja, eso pé bi xijquije. Cja̱ nugöje, xtú e̱me̱bije cár palabrajʉ, como dí pa̱dijʉ, mí cierto ca mí ma̱jmʉ. Gueguejʉ bi möx cʉ to bi tʉngui car jña̱ digue car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nuguigö hne̱je̱, xtú hñöni rá zö, göhtjo ja mí ncja cár vida car Jesús, desde bbʉ mí mʉdi, cja̱ xtú mbe̱ni xtú ju̱xcö na̱r libro‑na̱, pa gui pa̱quɛ, tada Teófilo. ");
INSERT INTO otsNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Por rá ngue na̱r libro‑na̱, tzö gui pa̱di, ntju̱mʉy car palabra xí tsjihqui. ");
INSERT INTO otsNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bbʉ már mandado car rey Herodes pʉ jar jöy Judea, már bbʉh pʉ hnar möcja̱, mí ju̱ cár tju̱ju̱ múr Zacarías. Mí pertené ca hnar grupo cʉ möcja̱ ca mí tsjifi ʉr Abías. Nu cár bbɛjña̱ car Zacarías mí tsjifi ʉr Elisabet. Guejti guegue xcuí hñe̱je̱ digue cár cji car da̱möcja̱ Aarón. ");
INSERT INTO otsNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Car Zacarías co cár bbɛjña̱, göhtjo yojmi már zö cár hmʉyhui, mí jonihui ca Ocja̱. Mí øtihui göhtjo ca xquí ma̱n ca Ocja̱ pʉ jar ley, mí zøjtihui‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pe jin tema ba̱jtzi mí hñiji, porque jí̱ mí ønte car Elisabet. Ya xquí nchujchu, guejti car Zacarías ya xquí ntita. ");
INSERT INTO otsNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Diguebbʉ ya, car grupo cʉ möcja̱ pʉ jabʉ mí pertené car Zacarías, bi tocabi di möjmʉ pʉ jar ciudad Jerusalén, pa du sirvebijʉ ca Ocja̱ pʉ jar ndo ni̱cja̱ pʉ. Eso, ca hnajpa, car Zacarías már bbʉh pʉ jar ndo ni̱cja̱, már pɛjpi ca Ocja̱ gá möcja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Cʉ möcja̱ mí echa suerte pa di tjajni toca̱ di da̱ja̱ pa di ñʉti pʉ jabʉ már nttzu̱jpi. Car pa‑ca̱, car suerte bi toca car Zacarías, eso, bi ñʉti pʉ mbo car ni̱cja̱, pʉ jabʉ már nttzu̱jpi. Bi dɛx car guitjoni, bi ña̱htibi ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nu cʉ cja̱hni rá ngu̱ mbí tøhmitjo pʉ tji, mbí orajʉ car hora bbʉ már ña̱hti car guitjoni car Zacarías. ");
INSERT INTO otsNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nu pʉ mbo ya, bi hna ni̱guitjo hnár anxe car Tzi Ta ji̱tzi, már bböh pʉ jár jogui dyɛ car arta, pʉ jabʉ mí ttʉ́x car guitjoni. ");
INSERT INTO otsNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Car Zacarías, bbʉ mí cca̱hti ya ca̱, bi ndo hño quí mfe̱ni cja̱ bi ndo ntzu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nu car anxe bi xifi: ―Dyo guí tzu̱guɛ, Zacarías. Ca Ocja̱ xí dyøh ca xcú dyöjpi. Quer bbɛjña̱, car Elisabet, da hmʉh hnár tzi ttʉ. Gui jñu̱htibi cár tju̱ju̱ dur Juan. ");
INSERT INTO otsNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nubbʉ́, gui mpöh bbʉ́. Nubbʉ́, da ddahqui gusto bbʉ́. Cja̱ bbʉ xta ncca̱hti quer tzi ba̱jtzi ca xta hmʉy, nubbʉ, guejtjo pé xta mpöh cʉ pé dda cja̱hni rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Guegue da anunciabi cár palabra ca Ocja̱. Ca Ocja̱ da nú̱ rá zö quer ttʉ cja̱ da hñi̱tzi pa da pɛjpi. Jin da zi guegue yʉ cosa yʉ rí nti̱ yʉ cja̱hni, ni dur vino da zi. Göhtjo ʉ́r vida da yojmi car Espíritu Santo, desde bbʉ xta hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Da nzoj yʉ pé dda cja̱hni israelita pa da mbe̱nijʉ ca Ocja̱, cja̱ da jionijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Guegue car Juan da hmɛto, pa da xij yʉ cja̱hni, ya xpa e̱h cam Tzi Jmu̱jʉ. Da yojmi cár ttzɛdi ca Ocja̱ cja̱ co cár Tzi Espíritu. Da pɛjpi ncja ngu̱ ca hnár jma̱ndadero ca Ocja̱ ca mí tsjifi ʉr Elías. Da nzoh cʉ ndo cja̱hnitsjɛ cja̱ co ni quí ba̱jtzi, pa da ma̱dijʉ. Da nzoh cʉ cja̱hni cʉ xí wembi ca Ocja̱, pa pé du coh‑cʉ. Bbʉ ya xtrú ngoh‑cʉ, da dyøjtibijʉ cár palabra cʉ jogui cja̱hni cʉ i pɛhtzi mfe̱ni rá zö. Guegue quer ttʉ ca da hmʉy, da nzoj yʉ cja̱hni, pa bbʉ xtu e̱h cam Tzi Jmu̱jʉ, ya xtrá ngu̱ cja̱hni da guati cja̱ da hñemejʉ‑ca̱.― Bi ma̱ ncjapʉ car ángele‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nubbʉ, car Zacarías bi dyön car ángele, i̱mbi: ―¿Tema seña gui ddajqui pa grá pa̱di, cja cierto da hmʉh hnam ttʉ? Ya xtúr titagö, co cam bbɛjña̱, ya xí nchujchu hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Car ángele bi da̱di, bi ma̱: ―Nugö dúr Gabriel, dí cjajpi quí jmandado ca Ocja̱. Guegue‑ca̱ xpá ngu̱jqui xtú xihqui nʉr jogui jña̱, pa gui pa̱di. ");
INSERT INTO otsNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pe nuya, gui ngone, como jí̱ xquí hñe̱me̱gui ca xtú xihqui. Ya jin da nzö gui ña̱ hasta gue bbʉ xta hmʉh quer ba̱jtzi, ncja ngu̱ xtú xihqui, cja̱ nubbʉ, cja xta xoh quer ne, cja̱ xtí ña̱, bbʉ. Nde̱jma̱ da ncja nʉ xtú ma̱ bbʉ xta zʉh car tiempo.― Ncjanʉ gá ma̱n car ángele. ");
INSERT INTO otsNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cʉ cja̱hni már tøhmijʉ car Zacarías pʉ tji. Mí dyo quí mfe̱nijʉ, ¿te tza már pɛfi? como ya xcuí ndo de pʉ mbo car ni̱cja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Guegue, bbʉ, bú pøh pʉ mbo car ni̱cja̱, pe jí̱ mí tzö te di xih cʉ cja̱hni, como ya xcuí ngone. Eso, bi fa̱di, pé te xquí cjajpi ca Ocja̱ xcuí cca̱hti pʉ mbo car ni̱cja̱. Car Zacarías dé mí cjadi ʉr seña, pe jí̱ mí tzö di ña̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bbʉ mí zøx cʉ pa cʉ mí tocabi di sirve jar ni̱cja̱, bi ma ʉ́r ngu̱ bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Diguebbʉ, bi hñʉ cár bbɛjña̱ car Zacarías, gue car Elisabet. Cʉtta za̱na̱ mí bbʉjti pʉ mbo ʉ́r ngu̱, jin tza mí pøni. ");
INSERT INTO otsNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mí ma̱, i̱na̱: ―Nuya, xí jui̱guigui car Tzi Ta ji̱tzi, ya xí cjagui xtú hñʉ. Nuya, ya jin da dengui yʉ cja̱hni, ya jin da xijqui jin dí ønte.― Bi ma̱ ncjapʉ car Elisabet. ");
INSERT INTO otsNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bbʉ mí zʉ ddajto za̱na̱ mí hñʉ car Elisabet, nubbʉ, ca Ocja̱ pé bi gu̱h car anxe Gabriel, gá ma pʉ jar tzi jñi̱ni Nazaret, nu pʉ jar estado Galilea. ");
INSERT INTO otsNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bi ma pʉ jár ngu̱ ca hnar ba̱jtzi bbɛjña̱tjo ca jí̱ bbe mí yojmi hnar hñøjø. Mí ju̱ cár tju̱ju̱ múr María. Ya xquí cja ttöjte, gue car José bi dyödi pa di cjajpi ʉ́r bbɛjña̱. Car José ya, xcuí hñe̱je̱ digue cár familia ca ndor David. ");
INSERT INTO otsNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Car anxe bi ñʉti car ngu̱, bi xih car María: ―Jatzi, María. Xí ndo nequi ca Ocja̱, cja̱ guegue da möxqui. Más drá ndo zö car favor ca da dyøjtiqui ni ndra ngue cʉ pé dda bbɛjña̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Car María bi zu̱ cʉ palabra‑cʉ, mí ndo dyo ʉ́r mʉy, mí mbe̱ni: “¿Ja i ncja car ttzɛnguate‑cá̱?” ");
INSERT INTO otsNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bi ma̱n car anxe, bbʉ: ―Dyo guí tzu̱guɛ, María. Ca Ocja̱ i ndo tzøhqui, xta möxqui. ");
INSERT INTO otsNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dyøjma̱ja̱ ya, gui ma gui hñʉ, cja̱ da hmʉh quer ttʉ. Gui jñu̱htibi cár tju̱ju̱ dur Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Guegue‑cá̱ da cja ʉr nda̱, cja̱ da tsjifi ʉ́r Ttʉ ca Ocja̱ ca bí bbʉ ji̱tzi. Car Tzi Ta ca dí i̱htzibijʉ da un cár cargo pa da mandado como ngu̱ nguá mandado ca ndór tita, David, como da hmʉy digue cár cji‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Göhtjo ʉr pá da mandadoquijʉ, guí cja̱hnijʉ israelita. Da mandado göhtjo ʉr tiempo, cja̱ jin da bøn cár cargo ca da ttuni.― Gue yʉ palabra‑yʉ bi ma̱n car ángele. ");
INSERT INTO otsNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Car María bi da̱di, bi dyön car anxe, i̱na̱: ―¿Ja drí hmʉh cam ba̱jtzi, siendo jí̱ bbe dí yobbe hnar hñøjø?― ");
INSERT INTO otsNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bi da̱h car anxe, bbʉ, bi xifi: ―Car Espíritu Santo da guahqui pa gui hñʉ. Gue cár ttzɛdi car Tzi Ta ji̱tzi gui yojmi pa da hmʉh quer ba̱jtzi. Por rá nguehca̱, drá nttzu̱jpi quer tzi ba̱jtzi, cja̱ da tsjifi ʉ́r Ttʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dyøjma̱ja̱, guejti quer prima cjujuɛ car Elisabet, ya xqui tu̱ cár ba̱jtzi hne̱je̱, cja̱ hne̱, ya xnʉr chujchu. Ya xca pa ddajto za̱na̱ i hñʉ, cja̱ mí tsjifi jin gui ønte. ");
INSERT INTO otsNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Rá nzɛh ca Ocja̱, jin te i tzöjpi rá ntji̱. I øte göhtjo ncja ngu̱ ga ma̱.― Guehca̱ bi ma̱n car anxe. ");
INSERT INTO otsNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Car María bi ma̱n ya bbʉ: ―Nugö, ʉ́r muzaguigö ca Ocja̱. Nuya guegue da cjagui como ngu̱ xcá ma̱.― Diguebbʉ, bi hna wen car ángele, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Bbʉ mí tsjih car María, ya xi mí tu̱ cár ba̱jtzi car Elisabet, nguetica̱ bi bøni gá ma jar estado Judea, pʉ jabʉ mí cja ttøø. Bi ma jár ngu̱ car Zacarías co car Elisabet. Bbʉ mí zøti jar jñi̱ni jabʉ mí bbʉ gueguehui, bi ñʉti pʉ jár ngu̱hui, bi zɛngua car Elisabet. ");
INSERT INTO otsNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cja̱ bbʉ mí dyøh car Elisabet már nzɛnguate car María, xní hñá̱n car ba̱jtzi pʉ mbo ʉ́r mʉy. Mismo car hora‑ca̱, car Espíritu Santo bi hna guatitjo car Elisabet, bi xij yʉ palabra yʉ bi ma̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nubbʉ, bi ña̱ nzajqui car Elisabet, bi xih car María, i̱na̱: ―Nuquiguɛ, María, más da tti̱zquiguɛ ni digue yʉ pé dda bbɛjña̱, cja̱ da ndo tti̱htzibi quer ba̱jtzi ca da hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Guehquiguɛ, ʉ́r mequi cam Tzi Jmu̱jʉ, cja̱ nugö, jin te dí ntju̱mʉygö. ");
INSERT INTO otsNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ca xtá øde xquí zɛnguagui, exque xí hñá̱n nʉm ba̱jtzi mbo nʉm mʉy, como xí ndo mpöjö. ");
INSERT INTO otsNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cja̱ hne̱hquiguɛ, rí ntzöhui gui mpöjquɛ, hne̱je̱, porque xcú hñe̱me̱ ca xí tsjihqui. Nde̱jma̱ da ncja como ngu xcá xihqui ca Ocja̱.― Ncjapʉ gá ma̱n car Elisabet. ");
INSERT INTO otsNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nubbʉ, car María bi ndo mpöjö, cja̱ bi ma̱m bbʉ: Dí ndo xöjtibi car Tzi Ta ji̱tzi, ntero göhtjo mbo nʉm tzi mʉy, ");
INSERT INTO otsNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","I ndo mpöj nʉm mʉy por rá ngue ca Ocja̱. Guegue‑ca̱ xta gʉzqui ca rá nttzo ca dí tu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xí nu̱gui co cár tzi tti̱jqui, exque ʉ́r muzagui, masque jin te dí vale. Desde guejya cʉ cja̱hni da ma̱, te tza rá zö car bendición xí ddajqui ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Rá ndo nzɛh ca Ocja̱, xí cjagui ca rá tzi zö. Rí ntzöhui gu xöjtibijʉ cár tzi tju̱ju̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ca Ocja̱, siempre i ndo föx yʉ cja̱hni yʉ i e̱me̱, Cja̱ guejtjo i föx quí ba̱jtzi‑yʉ, co quí bbɛjto‑yʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ca Ocja̱ xí u̱jtiguijʉ, te tza rá nzɛdi guegue, Xí fongui cʉ cja̱hni cʉ mí ma̱ntsjɛ, mí ndo pa̱dijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Cʉ cja̱hni rá nzɛdi cʉ mí mandado, ca Ocja̱ xí jña̱jquibi cár cargo‑cʉ́, pa ya jin da mandado. Nu cʉ cja̱hni cʉ jí̱ mí hñi̱xtjsɛjʉ, guegue‑cʉ ca Ocja̱ xí un cár cargo pa xí mandadojʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ca Ocja̱ xí wi̱ni rá zö cʉ cja̱hni cʉ mí tu̱ntju̱, nu cʉ rico cʉ mí pɛhtzi rá ngu̱, xí ngu̱h‑cʉ́, jin te xcá uni. ");
INSERT INTO otsNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ca Ocja̱ xí möxquigöjʉ, dí cja̱hni israelitajʉ, como dí sirvebijʉ. Ya xí cumpli ca bi xih cʉ ndom titajʉ, ya má yabbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bi ma̱n cam Tzi Tajʉ ji̱tzi di möx cam titajʉ Abraham, co quí ba̱jtzi, co guejti quí bbɛjto cʉ di hmʉy, hasta göhtjo cʉ cja̱hni cʉ di hmʉy digue cár cji car Abraham. Tzʉdi, guejcöjʉ bi ma̱n ca Ocja̱ di möxcöjʉ, Göhtjo ʉr vida jin di jiɛguijʉ. Cja̱ nuya xí jui̱guijʉ, ncja ngu̱ gá ma̱. Ncjapʉ gá ma̱n car María, ngá xöjtibi ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Diguebbʉ, car María bi døhmi pʉ jár ngu̱ car Elisabet. Bi hmʉjti pʉ jñu̱zna̱, sta gue bbʉ mí hmʉh cár ba̱jtzi car Elisabet, cja̱ nubbʉ, bi ma ʉ́r ngu̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ncjapʉ bi zøx cʉ pá, pa bi jñin car Elisabet, cja̱ bi hmʉh cár tzi ttʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bbʉ mí dyøh quí vecino co ni quí pariente, guejtjo bi mpöjmʉ, cja̱ bi möjmʉ pʉ jár ngu̱ car Zacarías pa di cca̱htijʉ. Bi ma̱jmʉ gueguejʉ: ―¡Te tza ngu̱ xí möx ca Ocja̱ nʉr Elisabet, eso, xí hmʉh cár ba̱jtzi!― ");
INSERT INTO otsNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bbʉ mí zʉ ñojto, bi ttøhtibi car ba̱jtzi car seña gá circuncisión, ncja ngu̱ ga ma̱m pʉ jár ley cʉ israelita. Cja̱ cʉ cja̱hni mí ne di jñu̱htibi cár tju̱ju̱ car ba̱jtzi dur Zacarías, pa di dɛmbitjo cár tju̱ju̱ cár ta. ");
INSERT INTO otsNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nu cár me ya, jin gá ne‑cá̱. Bi ma̱n ya bbʉ, i̱na̱: ―Jin da joh cár tju̱ju̱ dur Zacarías. Da tju̱htibi cár tju̱ju̱ dur Juan.― ");
INSERT INTO otsNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cʉ pé dda cja̱hni bi da̱dijʉ ya bbʉ, i̱na̱jʉ: ―¿Dyoca̱ guí ne gui jñu̱htibi cár tju̱ju̱ dur Juan, cuando jin te i bbʉ ir familia ca di tsjifi ncjapʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nubbʉ, bi cjajpitjo ʉr seña cár ta car ba̱jtzi, bbʉ, bi ttöni tema tju̱ju̱ mí ne guegue‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Car Zacarías bi dyöh hnar tzi tabla cja̱ bi jñu̱x pʉ cár tju̱ju̱ car ba̱jtzi, i̱na̱: ―Da tju̱htibi cár tju̱ju̱ dur Juan.― Cʉ cja̱hni bi ndo mbe̱nijʉ‑ca̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cja̱ nubbʉ, bi hna xoh cár ne car Zacarías, bbʉ, cja̱ bi ña̱. Bi xöjtibi ca Ocja̱, bi ndo dyöjpi mpöjcje. ");
INSERT INTO otsNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mí ndo dyo í mʉyjʉ quí vecino, göhtjojʉ. Cja̱ bi ntʉngui car jña̱ ca te xquí ncja, hasta bi ttøh pʉ já ttøø, guehpʉ jar estado Judea. Bi dyøde göhtjo cʉ cja̱hni, ca Ocja̱, guehca̱ xquí uni car tzi ba̱jtzi pa di hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Cʉ to bi dyøde, bi ndo mbe̱nijʉ‑ca̱. Cja̱ bi hñönijʉ: ―¿Te tza göhtjo da dyøti car ba̱jtzi‑ca̱ bbʉ xta té?― Mí ma̱ ncjapʉ cʉ cja̱hni, como ca Ocja̱ bi ndo bendeci car tzi ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Car Espíritu Santo bi hna guati car Zacarías, cár ta car ba̱jtzi, cja̱ bi uni palabra pa drí xöjtibi ca Ocja̱. Bi ma̱n ya car Zacarías, bbʉ, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Da ndo tsjöjtibi ca Ocja̱ ca dí tɛnijʉ, dí israelitajʉ, Porque guegue xí nu̱guijʉ rá zö, yí cja̱hniguijʉ, Ya xpá mɛjni ca hnar cja̱hni ca da gʉzquijʉ ca rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Guegue‑ca̱ du e̱h pʉ jár cji car David, cja̱ drá ndo nzɛdi. Xí hñi̱x car Tzi Ta ji̱tzi pa da gʉzquijʉ göhtjo ca rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ya má yabbʉ bi promete ca Ocja̱ di mɛjni ca hnaa ca di gʉxcöjʉ. Bi xih quí jmandadero cʉ mí pɛjpi guegue. Cja̱ nuya xí dyøti guegue ncja ngu̱ gá ma̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Car Tzi Ta ji̱tzi xquí xijquijʉ di hñi̱xi hnar hñøjø pa da gʉxcöjʉ pʉ jáy dyɛ cʉm contrajʉ, pa ya jin te da cjaguijʉ‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Guegue xquí ma̱, di jui̱jqui cʉ ndom titajʉ, cja̱ di mbe̱n car acuerdo ca xquí dyøtihui car Abraham. ");
INSERT INTO otsNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Car Tzi Ta ji̱tzi xquí ungui hnar promesa ca ndom titajʉ, car Abraham, cja̱ xquí dö cár palabra, cierto di cumpli. Bi xifi, di hñe̱h ca hnar cja̱hni ca di möxcöjʉ, cja̱ nuya, ya xí ni̱gui‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bi xijcöjʉ, guegue‑ca̱ di gʉxcöjʉ pʉ jár dyɛ cʉm contrajʉ, pa ya jin te da cjaguijʉ‑cʉ. Nuya, gu hmʉpjʉ ʉ́r dyɛ ca Ocja̱, gu pɛjpijʉ, cja̱ jin te gu tzu̱jʉ ya. ");
INSERT INTO otsNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nuya, gu jɛguijʉ ca rá nttzo, cja̱ gu øtijʉ ca rá zö. Göhtjo ʉr vida gu tɛnijʉ ca Ocja̱, como guehca̱ dí e̱me̱jʉ‑ca̱. Gue nʉr palabra‑nʉ bi tsjih ca ndom titajʉ, cja̱ ya xí nzʉdi. ");
INSERT INTO otsNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nuquɛ, ʉm tzi ttʉqui, da tsjihqui ʉ́r jmandaderoqui ca Ocja̱, Cja̱ gui ma gui xij yʉ cja̱hni cár palabra car Tzi Ta ji̱tzi. Rí ntzöhui da ndo tti̱htzibi‑ca̱. Guehquɛ gui hmɛto, gui nzoj yʉ cja̱hni, gui xijmʉ, ya xpa e̱h cam Tzi Jmu̱jʉ, ");
INSERT INTO otsNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","cja̱ gui xijmʉ ja ncja drí dötijʉ car nzajqui ca jin da tjegue, cja̱ co ja ncja drí mperdonaguijʉ ca rá nttzo ca xtú øtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Xí ndo jui̱guijʉ car Tzi Ta ji̱tzi cja̱ xí ndo neguijʉ. Ncjahmʉ ya xpa jiahtzi hnar ddadyo mpá rá zö, como guegue xtu pɛjni cár tzi jiahtzi, pa da yoti mbo ʉm tzi mʉygöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Car jiahtzi‑ca̱ guejtjo da yoti cʉ cja̱hni cʉ rá bbʉh pʉ jabʉ rá hmɛxu̱y, gue cʉ ya xní ma da du̱. Ca hnar ba̱jtzi ca da hmʉy da cjaguijʉ gu tɛnijʉ cár hñu̱, pa gu hmʉpjʉ rá zö, gu mpöjmʉ car Tzi Ta ji̱tzi. Ncjapʉ gá ma̱n car Zacarías, bbʉ már xöjtibi ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Cja̱ bi te car ba̱jtzi ya, car tzi Juan, bi ndo ncja ʉ́r mʉy, cja̱ mí ndo tɛn ca Ocja̱. Mí dyo pʉ jabʉ jin to mí hñá̱ni. Bi døhmi pʉ hasta gue bbʉ bi xih car Tzi Ta ji̱tzi di nzoh quí mi̱nga̱‑cja̱hnijʉ, tzʉdi, cʉ cja̱hni israelita. ");
INSERT INTO otsNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nu cʉ pa‑cʉ, car Agusto César bi mandado bi ttøti hnar censo pa ntero cʉ cja̱hni mí bbʉjcua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nucá̱ múr primera vez bi ttøti car censo. Bi tsjox car censo‑ca̱ bbʉ már mandado car Cirenio pʉ jar jöy Siria. ");
INSERT INTO otsNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Göhtjo cʉ cja̱hni bi möjmʉ jar jñini pʉ jabʉ mí bbʉjma̱ja̱ cʉ ndo í tajʉ co ni cʉ ndo í titajʉ, cja̱ bú ju̱x quí tju̱ju̱jʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nu car José bi bøm pʉ jar jñini Nazaret, pʉ jar estado Galilea, como guehpʉ múr mi̱ngu̱ pʉ. Bi bøtze gá ma jar estado Judea, bi zøti jar jñini Belén. Múr ngu̱jma̱ pʉ ca ndo ʉ́r tita David, como car José ya, xcuí hñe̱je̱ digue cár familia ca ndor David. ");
INSERT INTO otsNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eso, bi ma pʉ Belén pa du tju̱x cár tju̱ju̱ pʉ. Bi zix cár bbɛjña̱, múr María, como ya xquí cja ttöjte. Nu car María, ya xi mí hñʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cja̱ bbʉ már bbʉjti pʉ Belén, bi zʉh car tiempo pa bi jñin car María. ");
INSERT INTO otsNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cja̱ bi hmʉh ca primero ʉ́r ba̱jtzi. Cár me ya, bi panti quí da̱jtu̱, cja̱ bi göti pʉ jar presebe, como mí u̱jtjo lugar pʉ mbo car mesón. ");
INSERT INTO otsNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mismo car jöy‑ca̱, már bbʉh cʉ dda mödi. Már ohmi quí dɛjti car xu̱y‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nubbʉ́, bi hna ni̱guitjo hnár anxe ca Ocja̱, mír hmöh hnanguadi pʉ jabʉ már bbʉh cʉ mödi, cja̱ cár tjay ca Ocja̱ bi ndo yoti pʉ. Cʉ mödi ya, bi ndo zu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nu car ángele ya bi xijmʉ: ―Dyo guí ntzu̱jʉ, porque nugö dá ja̱gö hnar ddadyo jña̱ pa da mpöj yʉ cja̱hni, ntero yʉ i bbʉjcua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nuya, rá pa ya, xí hmʉh ca hnar cja̱hni ca da gʉzquijʉ ca rá nttzo. Guegue‑ca̱ ʉr Cristo‑ca̱, como xí hñi̱x car Tzi Ta ji̱tzi, cja̱ ʉm Tzi Jmu̱göjʉ. Xí hmʉ jár jñi̱ni nʉ jabʉ mí bbʉjma̱ ca ndo ʉ́r tita, David. ");
INSERT INTO otsNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dí xihquijʉ hnar seña pa grí meyajʉ car ba̱jtzi. Gui ma gui tötijʉ hnar tzi wɛne, xí bbanti quí tzi da̱tu̱, cja̱ rá bbɛni jar presebe. Gue car tzi ba̱jtzi‑cá̱.― Ncjapʉ gá xih cʉ mödi car ángele. ");
INSERT INTO otsNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nubbʉ, bi hna ni̱gui pʉ cʉ dda ángele rá ngu̱, güí ga̱j nʉ jar ji̱tzi, bi mpɛjnijʉ car anxe‑ca̱. Bi ncötijʉ bi xöjtibijʉ car Tzi Ta ji̱tzi, már ma̱jmʉ, i̱na̱jʉ: ");
INSERT INTO otsNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Da tsjöjtibi ca Ocja̱ pʉ jar ji̱tzi, Nuhua jar jöy da hmʉy rá zö yʉ cja̱hni, porque ca Ocja̱ xí nu̱‑yʉ co cár tzi tti̱jqui! Ncjapʉ gá ma̱n cʉ anxe. ");
INSERT INTO otsNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nubbʉ, bi ma gá ngojmʉ pʉ jar ji̱tzi. Cja̱ cʉ mödi ya, bi ña̱tsjɛjʉ, bi ma̱jmʉ: ―Möj nʉ Belén. Má cca̱htijʉ car tzi ba̱jtzi ca xí hmʉj nʉ, como ya xí xijcöjʉ ca Ocja̱, guehca̱ xpá mɛjnquijʉ‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cja̱ bi möjmʉ nttzɛdi, bú tötijʉ car María co car José, cja̱ co car tzi ba̱jtzi már bbɛm pʉ jar presebe. ");
INSERT INTO otsNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cʉ mödi ya, bbʉ mí cca̱htijʉ car tzi ba̱jtzi, bi xijmʉ car María co car José car palabra ca xquí ma̱n car ángele. Guejtjo bi göxjʉ cʉ pé dda cja̱hni cʉ bi ntjɛjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Göhtjo cʉ to bi dyøh ca mí ma̱n cʉ mödi, bi ndo hño í mʉyjʉ, bi ndo mpöjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nu car María bi ndo mbe̱n cʉ palabra cʉ xquí tsjifi digue cár tzi ba̱jtzi. Jin gá da̱be̱ni‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nubbʉ, bi ma cʉ mödi, bbʉ. Bi ma gá ngojmʉ pʉ jabʉ xcuí hñe̱jmʉ. Má xöjtibijʉ ca Ocja̱, má ndo öjpijʉ cjama̱di, porque ya xquí dötijʉ car tzi wɛne, ncja ngu̱ gá ma̱n cár anxe ca Ocja̱. Bi dyöjpijʉ mpöjcje por rá ngue göhtjo cʉ xquí dyødejʉ cja̱ xquí cca̱htijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bbʉ ya xi mí pɛhtzi ñojto car tzi ba̱jtzi, bi ttøhtibi jár cuerpo car seña ca i tsjifi circuncisión, ncja ngu̱ ga ma̱m pʉ jar ley ca bi dyøti car Moisés, cja̱ bi tju̱htibi cár tju̱ju̱ múr Jesús. Gue nʉr tju̱ju̱‑nʉ bi tsjih car María di jñu̱htibi cár tzi ba̱jtzi. Ante que di hñʉ guegue, car ángele bi xifi ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","I ma̱m pʉ jar ley ca bi dyøti car Moisés, bbʉ ga hmʉh hnar ba̱jtzi ʉr tzi hñøjø, cár me da døhmi cuarenta día, nubbʉ, cja da zix car ba̱jtzi pa du presentabi ca Ocja̱. Eso, bbʉ mí zøx cʉ cuarenta día, car María bi mɛhui car José pʉ Jerusalén pa du presenta cár ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pʉ jar Escritura i cuati cʉ dda palabra cʉ i ma̱ ncjahua: “Cada hnar familia yʉ cja̱hni israelita, da ña̱htibi ca Ocja̱ cár primero car tzi hñøjø ca da hmʉy, como nuca̱ ʉ́r mɛjti ca Ocja̱‑ca̱.” Tzʉdi, mí nesta di möhti hnar zu̱we̱ cja̱ di dʉti pʉ jar altar. Di ncjapʉ drí mbonihui car tzi hñøjø car zu̱we̱, cja̱ nuca̱, di ttun ca Ocja̱‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eso, car José co car María bi mɛhui pʉ Jerusalén pa di ña̱htibi ca Ocja̱ hnar zu̱we̱, guehca̱ drí mbonihui cár tzi ttʉ. I ma̱m pʉ jar Escritura, pʉ jar ley, i̱na̱: “Da ña̱htibi ca Ocja̱ yojo tzi paloma o yo tzi juilo.” ");
INSERT INTO otsNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Car ciudad pʉ Jerusalén már bbʉh hnar tada, mí tsjifi múr Simeón. Ya xi múr tita. Már zö cár vida, cja̱ mí ndo jon ca Ocja̱. Göhtjo ʉr pa, mí pa jar templo. Mí tøhmitjo ca hnar cja̱hni ca di hñe̱je̱ pa di gʉhtzibi cʉ cja̱hni israelita ca mír sufrijʉ. Car Espíritu Santo mí yojmi car Simeón, cja̱ mí nzofo. ");
INSERT INTO otsNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Car Espíritu Santo ya xquí xih car Simeón, jin di du̱ hasta gue bbʉ ya xtrú cca̱hti car cja̱hni ca xtrú hñi̱x car Tzi Ta ji̱tzi, pa di salva cʉ cja̱hni israelita. ");
INSERT INTO otsNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ca hnajpa, car Simeón bi ma pʉ jar templo, bi guati pʉ, ncja ngu̱ xquí xih car Espíritu Santo. Ncjapʉ, ya xi már bbʉh pʉ jar ni̱cja̱ bbʉ mí ñʉtihui cár ta co cár me car tzi Jesús. Gueguehui mír ma di presentahui ca Ocja̱ cár tzi ba̱jtzi cja̱ di ña̱htibi cʉ zu̱we̱ cʉ i ma̱m pʉ jár ley ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Car Simeón ya bbʉ, bi dyöh car ba̱jtzi, bi dɛtzi, cja̱ bi nzoh car Tzi Ta ji̱tzi. Bi ma̱, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nuquiguɛ, Tzi Jmu̱, ir mɛfiguigö. Nuya, ya xná zö gui tzixquigö ya. Ya xí jñu̱ ʉm mʉy. Ya xí nzʉh quer palabra ca gú xijqui. ");
INSERT INTO otsNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ya xtú cca̱hti na̱r cja̱hni na̱ xcú pɛjni pa da gʉzquije ca rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Guejna̱ xcú pɛjni‑na̱ pa da gʉhtzibi ca rá nttzo göhtjo yʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Da ncjá ncja hnar jiahtzi na̱r tzi ba̱jtzi‑na̱. Guejna̱ xcú pɛjni‑na̱ pa da yoti mbo í mʉyjʉ cʉ cja̱hni cʉ jin gui pa̱di ja guí ncjaguɛ. Por rá ngue guegue‑na̱ da tti̱htzibi yʉ cja̱hni israelita, como ir cja̱hniguɛ‑yʉ. Ncjapʉ gá ma̱n car Simeón bbʉ már xöjtibi car Tzi Ta ji̱tzi, már ma̱ te di dyøti car tzi Jesús bbʉ ya xtrú te. ");
INSERT INTO otsNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bbʉ mí dyøj yʉ palabra‑yʉ cár ta co cár me car ba̱jtzi, bi ndo hño í mʉyhui. ");
INSERT INTO otsNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Car Simeón, bbʉ, pé bi nzoh ca Ocja̱, bi dyöjpi di bendeci car tzi ba̱jtzi cja̱ co cár ta hne̱h cár me. Diguebbʉ ya, bi nzoh car meba̱jtzi, car María, bi xifi, i̱na̱: ―Dyøjma̱ja̱, car Tzi Ta ji̱tzi xí hñi̱x na̱r ba̱jtzi‑na̱ pa da ba̱j yʉ cja̱hni israelita, guegue i cumpli ca i ma̱. Cja̱ bbʉ ya xtrú te na̱r ba̱jtzi, da ndo jmeya. Da guatijʉ cja̱hni drá ngu̱, cja̱ da hñe̱me̱ ca Ocja̱. Nu cʉ pé ddaa ya, da wembijʉ, jin da nejʉ. Da ncjapʉ drí fa̱di ja ncja ga mbe̱n yʉ cja̱hni mbo í mʉyjʉ. Da ndo sufri na̱r ba̱jtzi‑na̱, como drá ngu̱ cʉ cja̱hni cʉ da ʉhui cja̱ da zani. Hne̱hquiguɛ, como xta sufri nir ba̱jtzi, xquí ndo sufri hne̱je̱, ncjahmʉ da ntjojtiqui quer tzi mʉy co hnar cjuay.― Ncjapʉ gá ma̱n car Simeón. ");
INSERT INTO otsNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Guejtjo hne̱je̱ már bbʉh pʉ jar templo ca hnar bbɛjña̱, múr mensajera ca Ocja̱. Mí ju̱ cár tju̱ju̱ múr Ana. Múr tti̱xu̱ car Fanuel, xcuí hñe̱je̱ digue cár familia ca ndór tita, Aser. Car Ana, ya xquí ndo nchujchutsjɛ. Xquí ntja̱jti bbʉ múr ba̱jtzi bbɛjña̱tjo, cja̱ bi hmʉbi cár da̱me̱ yojto cjeya. Diguebbʉ, bi du̱‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Cja̱ ya xi mí pɛhtzi ochenta y cuatro año xquí go ddanxu̱. Guejti guegue mí tøhmi ca hnar cja̱hni ca di mɛjni ca Ocja̱. Car Ana jí̱ mí bbɛh pʉ jar templo. Már dedi pʉ, mí xöjtibi ca Ocja̱, hasta mí be̱je̱ pa más di jion ca Ocja̱. Mí mahti ca Ocja̱ gá oración bbʉ mpa co hne̱h bbʉ nxu̱y. ");
INSERT INTO otsNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mismo car hora‑ca̱, car Ana bi guati car José co car María. Bbʉ mí cca̱hti car tzi ba̱jtzi Jesús, exque bi ba̱di, guehca̱ xcuí mɛjni car Tzi Ta ji̱tzi‑ca̱, cja̱ bi dyöjpi cjama̱di. Diguebbʉ, bi bøni cja̱ bi ndo ngöxte, ya xquí hmʉh ca hnar cja̱hni ca xcuí mɛjni car Tzi Ta ji̱tzi pa drí möx quí cja̱hni. Bi xifi ntero cʉ cja̱hni jar ciudad pʉ Jerusalén, göhtjo cʉ to mí tøhmijʉ car pá bbʉ xti ni̱gui car hñøjø ca di gʉx‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Car José co car María bi cumplihui göhtjo ca mí ma̱m pʉ jár palabra ca Ocja̱, tzʉdi, ca i ma̱m pʉ jar ley. Diguebbʉ, bi ma gá ngojmi pʉ jar jñi̱ni Nazaret cja̱ pé bi hmʉbi pʉ. Car tzi jñini Nazaret, mí bbʉh pʉ jar estado Galilea. ");
INSERT INTO otsNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bi te car ba̱jtzi, car tzi Jesús, cja̱ bi zɛdi. Múr tzi jiaxi mʉy, cja̱ mí ndo yojmi car Tzi Ta ji̱tzi, guegue‑ca̱ mí fötzi. ");
INSERT INTO otsNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cada cjeya mí pa jar mbaxcjua pʉ Jerusalén cár me co cár ta car Jesús. Cʉ cja̱hni israelita mí tzöjpijʉ hnar da̱mbaxcjua bbʉ mí mbe̱nijʉ ja ncja gá mbøn cʉ ndo í titajʉ pʉ jar jöy Egipto. ");
INSERT INTO otsNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bbʉ mí pɛhtzi doce año car Jesús, bi ttzitzi gá möjmʉ pʉ Jerusalén, como ngu̱ nguá dyøti cár ta co cár me cada cjeya bbʉ ya xti ncja car mbaxcjua‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cja̱ bbʉ mí guah car mbaxcjua, bú coh cʉ cja̱hni. Nu car tzi Jesús ya, bú dé pʉ Jerusalén, pe jin gá mba̱h cár me, ni ndra ngue cár ta, ¿cja xcuí goh pʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ngá ma̱ndi gueguehui, car Jesús má hñohui cʉ pé dda cja̱hni. Eso, bi hñojʉ göhtjo car pa‑ca̱, mír möjmʉ í ngu̱jʉ. Bbʉ mí nde, bi jionihui car Jesús. Bi dyön quí pariente cja̱ co quí hnangu̱jʉ. u̱jtjo. ");
INSERT INTO otsNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jin te gá ndötihui. Nubbʉ, bi ma gá ngojmi Jerusalén, bú jonihui pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ca mír cja jñu̱jpa, bi dötihui pʉ jar ndo ni̱cja̱. Már bbʉbi cʉ maestro cʉ mí nxödijʉ cʉ Escritura, már ju̱dijʉ pʉ. Car Jesús már øh ca már ma̱n cʉ maestro cja̱ már öni nttöni. ");
INSERT INTO otsNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bbʉ mí dyøh cʉ maestro ca már ma̱n car Jesús, bi hñöntsjɛjʉ: ―¿Ja xcá mba̱j ya nʉr ba̱jtzi yʉ mfe̱ni rá ji̱tzi? Rá ndo zö ca i ma̱ cja̱ co ca i tja̱di.― ");
INSERT INTO otsNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cár me co cár ta, bi cca̱hti car Jesús, már bbʉh pʉ, már ña̱hui cʉ maestro. Cja̱ bi ndo hño ʉ́r mʉyhui, bi hñöntsjɛhui, ¿ter bɛh ca̱ mí jom pʉ? Bi ma̱n cár me, bbʉ, bi dyöni: ―Nuquɛ, ttʉ, ¿dyoca̱ xcú cojtiguɛ hua? Xtú ndo jonquibbe nir ta. Te tza ndí cjabbe ndu̱mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Bi ma̱n car ba̱jtzi, bbʉ, i̱na̱: ―¿Dyoca̱ xcú dé xcú jionguihui? ¿Cja jin guí pa̱dihui, i nesta gu hmʉjcua jár ngu̱ cam Tzi Ta?― Ncjapʉ gá nda̱di. ");
INSERT INTO otsNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nu cár ta co cár me jin gá ntiendehui toca̱ mí xifi múr Tzi Ta. ");
INSERT INTO otsNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nubbʉ, car Jesús bi dɛn cár me co cár ta, bi ma gá ngojmʉ pʉ Nazaret. Cja̱ guegue bi dyøjti ca mí xijmi. Cár me ya, dé mí mbe̱ntjo göhtjo cʉ palabra cʉ xquí ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Cja̱ car Jesús bi te, más bi ncja ʉ́r mʉy, cja̱ bi hñøjø. Nu cʉ cja̱hni mí ndo tzøjmʉ‑ca̱. Guejti car Tzi Ta ji̱tzi mí ndo ne car Jesús cja̱ mí fötzi. ");
INSERT INTO otsNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bi tjoh cʉ cjeya. Bbʉ ya xti zʉh car tiempo ca xquí ma̱n ca Ocja̱, pa di mʉdi di predica car Juan ca mí xix yʉ cja̱hni, car Tiberio César már mandado jar gobierno romano. Ya xi mí pɛhtzi quince año már mandado pʉ. Car Poncio Pilato múr gobernador pʉ jar estado Judea. Car Herodes már mandado pʉ jar estado Galilea, cja̱ cár cjua̱da̱ Felipe már mandado pʉ jar estado Iturea cja̱ co jar estado Traconite. Car Lisanias már mandado pʉ jar estado Abilinia. ");
INSERT INTO otsNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bbʉ ya xti mʉdi di predica car Juan ca mí xix yʉ cja̱hni, cʉ möcja̱ cʉ mí ju̱ quí tju̱ju̱hui car Anás co car Caifás már mandadohui pʉ jár templo cʉ judio. Car cjeya‑ca̱, ca Ocja̱ bi nzoh car Juan, cár ttʉ car Zacarías, bbʉ má dyo pʉ jabʉ jin to mí hña̱ni. Bi gu̱y di ma du nzoh cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nubbʉ, bi ma car Juan, má tjoh pʉ já jñi̱ni cʉ mír hmʉh pʉ jáy nttza̱ni car da̱tje Jordán, má xih cʉ cja̱hni di ntzohmijʉ, di jiɛjmʉ ca rá nttzo, cja̱ di xixtjejʉ pa drí ni̱gui, ya xi mí jonijʉ ca Ocja̱. Nubbʉ, ca Ocja̱ di gʉhtzibijʉ ca rá nttzo ca xquí dyøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bbʉ mí predica car Juan bi zʉh cʉ dda palabra cʉ xquí ma̱n car profeta Isaías ya má yabbʉ. Xquí jñu̱x cʉ palabra‑cʉ pʉ jár libro xquí dyøte. Bi ma̱ ncjahua: Dyøjma̱jʉ, i dyo hnar cja̱hni pʉ jabʉ jin to i hña̱ni, i ndo ña̱ nzajqui, I xih cʉ pé dda cja̱hni da jojqui quí vidajʉ, como ya xpa e̱h cam Tzi Jmu̱jʉ. I nzojmʉ ncjahua, i̱na̱: “Gui jojquijʉ ya car hñu̱ pʉ jabʉ xtu e̱h ca Ocja̱, Gui cjajpijʉ drá ncjua̱ni. ");
INSERT INTO otsNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gui ñu̱htzijʉ jöy göhtjo pʉ jabʉ rá je̱, Gui yøhtijʉ jabʉ rá nte, göhtjo cʉ ttøø, Pʉ jabʉ xí mögui, gui cjʉjquijʉ derecho, Gui jojquijʉ car hñu̱ drá nconi, ");
INSERT INTO otsNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pa du e̱h cam Tzi Jmu̱jʉ. Guehca̱ da gʉzquijʉ ca rá nttzo‑ca̱, Cja̱ jin gui jønguitsjɛgöjʉ da möxquijʉ, pe guejtjo da mötzi göhtjo cʉ pé dda cja̱hni cʉ i bbʉjcua jar jöy.” Bi ma̱ ncjapʉ car profeta Isaías. ");
INSERT INTO otsNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Már ngu̱ cʉ cja̱hni bi guatijʉ car Juan, mí ne di xixtjejʉ. Car Juan ya, mí nzojmʉ, mí xijmʉ: ―¿Toca̱ xí xihquijʉ gui xixtjejʉ? Rá nttzo quir mʉyjʉ. Guí ncjajʉ ncja ngu̱ cci̱ña̱. ¿Cja guí i̱na̱jʉ, bbʉ jøntjo gui xixtjejʉ, nubbʉ, jin da zʉhquijʉ car castigo drá ndo ʉ́ ca xtu pɛnquijʉ ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bbʉ de vera gui repentijʉ cja̱ gui jiɛguijʉ ca rá nttzo, nubbʉ, xquí dyøtijʉ ca rá zö. Nubbʉ, cja da ni̱gui, de vera guí e̱me̱jʉ ca Ocja̱, bbʉ. Nuquiguɛjʉ, guí mbe̱ni mbo ir mʉyjʉ, jin tema castigo da ttahquijʉ, como xquí hñe̱jmʉ jár cji ca ndom titajʉ Abraham. Nugö, dí xihquijʉ, jin te i cja jabʉ xcuí hñe̱h quer cjijʉ. Bbʉ di mandado ca Ocja̱, hasta guejti yʉ me̱do yʉ i bbongua, di cja í ba̱jtzi ca ndom titajʉ Abrahám. ");
INSERT INTO otsNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Xí ma̱n ca Ocja̱, ya xtu pɛnqui quer castigojʉ. Ya xqui guejti pʉ xta zʉhquijʉ. Car hacha ya xna bböjti pʉ hnanguadi car za pa da zɛjqui. Göhtjo cʉ za cʉ jin gui tu̱ ixi rá zö, xta ttzɛjqui, cja̱ xta ddʉti pʉ jar tzibi.― Mí ma̱ ncjapʉ car Juan. ");
INSERT INTO otsNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Cʉ cja̱hni ya, bi dyön car Juan ya bbʉ́, i̱na̱: ―¿Te gu pɛjme ya bbʉ́, pa jin da castigaguije ca Ocja̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Car Juan bi da̱di: ―Bbʉ guí ca̱ yo pajni, gui u̱ni hnaa car cja̱hni ca jin te i ca̱ja̱. Bbʉ guí pɛhtzi semilla rá ngu̱, gui u̱ni tzʉ car cja̱hni ca jin te i pɛhtzi.― Bi ma̱ ncjanʉ car Juan. ");
INSERT INTO otsNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pé bú e̱jmʉ cʉ dda publicano, tzʉdi, cʉ hñøjø cʉ mí cobra cʉ contribución, bi guatijʉ car Juan. Guejti guegue‑cʉ mí ne di xixtje hne̱je̱. Bi dyönijʉ, i̱na̱: ―Nuquɛ, Maestro, xijcöje, ¿te bɛh ca̱ gu pɛjme, bbʉ́, pa da neguije ca Ocja̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Car Juan bi xijmʉ, bbʉ: ―Gui cobrajʉ lúnico ca i ma̱n car gobierno. Dyo pé guí ju̱htzijʉ ca gui cobrajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Guejti cʉ sundado bi guati car Juan, bi dyönijʉ: ―Xigöje, ¿te gu pɛjme?― Cja̱ car Juan bi xijmʉ: ―Dyo guí tzímbi quir hñohuijʉ quí zu̱we̱ gá fuerza, cja̱ dyo te guí ja̱mbijʉ. Dyo guí jøxjʉ bbɛtjri yʉ cja̱hni, hne̱je̱. Gui hmʉpjʉ conforme quer rayajʉ.― Bi ma̱ ncjapʉ car Juan. ");
INSERT INTO otsNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Cʉ cja̱hni ya, mí tøhmijʉ ca hnar cja̱hni ca di gu̱h ca Ocja̱ pa di gʉhtzibijʉ ca rá nttzo. Mí mbe̱nijʉ, ya xti ni̱gui‑ca̱. Bi cca̱htijʉ már ndo zö car Juan. Göhtjo mí mbe̱nijʉ, má̱s guegue car Juan múr Cristo ca xquí hñi̱x ca Ocja̱ pa di hñe̱je̱ di möxjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bi ba̱h car Juan te mí mbe̱n cʉ cja̱hni, eso, bi xifi göhtjo‑cʉ: ―Nugö, jin dúr Cristo‑gö. Jin gui guejquigö guí tøbiguijʉ. Cierto i bbʉh cam cargo. Dí xixquijʉ cor deje. Nu car Cristo, ya xpa e̱je̱, cja̱ guegue más i ndo ja̱ cár cargo ni ndra nguejquigö. Nugö, jin dár ntzögöbbe gu cjajpi quí jmandado‑ca̱. Guegue da ddahquijʉ car tzi Espíritu Santo pa gui yojmʉ‑ca̱, cja̱ car tzi Espíritu Santo i jñɛjmi hnar tzibi. ");
INSERT INTO otsNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ca hnaa ca ya xpa e̱je̱, da mijqui quí ttɛy, da wejque cʉ baxa co cʉ semilla. Car ttɛy ya, da bbɛhtzi, cja̱ car baxa da ddʉti pʉ jar tzibi ca jin gui jui̱ti.― ");
INSERT INTO otsNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mí ncjapʉ nguá nzoh cʉ cja̱hni car Juan. Mí xijmʉ, ya xti mʉdi di mandado ca Ocja̱ hua jar jöy. Guejtjo, pé mí xijmʉ pé dda palabra rá ngu̱, hne̱je̱, cja̱ mí ɛti pa di hñe̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Car Juan guejtjo bi nzoh car rey Herodes, bi huɛnti. Guegue‑ca̱ mí mandado pʉ jar jöy‑ca̱. Car Juan bi huɛnti, porque car Herodes xquí cuajti cár bbɛjpo gá bbɛjña̱, siendo mí bbʉjti cár cjua̱da̱. Cja̱ pé bi huɛnti car Herodes por rá ngue cʉ pé dda cosa cʉ xquí dyøte már nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Car Herodes ya, jin gá ne gá dyøte ncja ngu̱ gá ma̱n car Juan. Más bien, pé bi dyøti pé hnar cosa más már nttzo. Bi mandado bi ttzʉh car Juan, bi cjoti födi. ");
INSERT INTO otsNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pe bbʉ jí̱ bbe mí cjoti car Juan, mí dyodi‑ca̱, mí xix cʉ cja̱hni rá ngu̱. Guejtjo hne̱je̱ bi xix car Jesús. Nu car Jesús, bbʉ mí guadi mí xixtje, bi nzoh ca Ocja̱. Cja̱ bbʉ már oratjo, bi xoj nʉr ji̱tzi, ");
INSERT INTO otsNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","cja̱ bú ca̱h car Espíritu Santo, mí ni̱gui ncja hnar paloma. Nuca̱, bi dex car Jesús. Cja̱ bi ttøh hnar jña̱ mbí ña̱ pʉ mbo jar ji̱tzi, mí ma̱: ―Nuquiguɛ, ʉm tzi ttʉquigö. Guí pöjpigui nʉm tzi mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Car Jesús, jabʉ ya xi mí pɛhtzi hnar treinta año, cja̱ bi mʉdi bi predica. Mí ma̱n cʉ cja̱hni, mí i̱na̱jʉ, car Jesús, múr ta car José. Car José ya, múr ta car Elí. ");
INSERT INTO otsNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Cja̱ car Elí múr ta car Matat, cja̱ car Matat múr ta car Levi, cja̱ car Leví múr ta car Melquí, cja̱ car Melquí múr ta car Jana, cja̱ car Jana múr ta car José. ");
INSERT INTO otsNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Car José ya múr ta car Matatías, cja̱ car Matatías múr ta car Amós, cja̱ car Amós múr ta car Nahum, cja̱ car Nahum múr ta car Esli, cja̱ nucá̱ múr ta car Nagai. ");
INSERT INTO otsNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Car Nagai ya, múr ta car Maat, cja̱ car Maat múr ta car Matatías, cja̱ car Matatías múr ta car Semei, cja̱ car Semei múr ta car José, cja̱ nucá̱ múr ta car Judá. ");
INSERT INTO otsNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Car Judá ya, múr ta car Joana, cja̱ car Joana múr ta car Resa, cja̱ car Resa múr ta car Zorobabel, cja̱ car Zorobabel múr ta car Salatiel, cja̱ nucá̱ múr ta car Neri. ");
INSERT INTO otsNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Car Neri ya, múr ta car Melqui, cja̱ car Melqui múr ta car Adi, cja̱ car Adi múr ta car Cosam, cja̱ car Cosam múr ta car Elmodam, cja̱ nucá̱ múr ta car Er. ");
INSERT INTO otsNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Car Er ya, múr ta car Josué, cja̱ car Josué múr ta car Eliezer, cja̱ car Eliezer múr ta car Jorim, cja̱ car Jorim múr ta car Matat, cja̱ nucá̱ múr ta car Leví. ");
INSERT INTO otsNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Car Leví ya, múr ta car Simeón, cja̱ car Simeón múr ta car Judá, cja̱ car Judá múr ta car José, cja̱ car José múr ta car Jonán, cja̱ nucá̱ múr ta car Eliaquim. ");
INSERT INTO otsNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Car Eliaquim ya, múr ta car Melea, cja̱ car Melea múr ta car Mainán, cja̱ car Mainán múr ta car Matata, cja̱ car Matata múr ta car Natán, cja̱ nucá̱ múr ta car David. ");
INSERT INTO otsNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Car David ya, múr ta car Isaí, cja̱ car Isaí múr ta car Obed, cja̱ car Obed múr ta car Booz, cja̱ car Booz múr ta car Salmón, cja̱ nucá̱ múr ta car Naasón. ");
INSERT INTO otsNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Car Naasón ya, múr ta car Aminadab, cja̱ car Aminadab múr ta car Aram, cja̱ car Aram múr ta car Esrom, cja̱ car Esrom múr ta car Fares, cja̱ nucá̱ múr ta car Judá. ");
INSERT INTO otsNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Car Judá ya, múr ta car Jacob, cja̱ car Jacob múr ta car Isaac, cja̱ car Isaac múr ta car Abraham, cja̱ nucá̱ múr ta car Taré, cja̱ car Taré múr ta car Nacor. ");
INSERT INTO otsNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Car Nacor ya, múr ta car Serug, cja̱ car Serug múr ta car Ragau, cja̱ car Ragau múr ta car Peleg, cja̱ car Peleg múr ta car Heber, cja̱ nucá̱ múr ta car Sala. ");
INSERT INTO otsNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Car Sala ya, múr ta car Cainán, cja̱ car Cainán múr ta car Arfaxad, cja̱ car Arfaxad múr ta car Sem, cja̱ car Sem múr ta car Noé, cja̱ car Noé múr ta car Lamec. ");
INSERT INTO otsNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Car Lamec ya, múr ta car Matusalén, cja̱ car Matasulén múr ta car Enoc, cja̱ car Enoc múr ta car Jared, cja̱ car Jared múr ta car Mahalaleel, cja̱ nucá̱ múr ta car Cainán. ");
INSERT INTO otsNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Car Cainán ya, múr ta car Enós, cja̱ car Enós múr ta car Set, cja̱ car Set múr ta car Adán. Nu car Adán ya, bi dyøti ca Ocja̱‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Car Jesús mí ndo yojmi car Espíritu Santo, mí øte göhtjo ca mí xih‑ca̱. Bbʉ ya xquí xixtje, bi wem pʉ jar da̱tje Jordán. Car tzi Espíritu Santo bi zitzi gá ma pʉ jabʉ jin to mí hñá̱ni, cja̱ bi hño pʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Bu dé pʉ cuarenta mpá. Nu ca Jin Gui Jo mí ndo jon car manera ja ncja drí jiöti car Jesús pa di dyøti tema cosa ca jin di tzö. Mí øhtibi prueba. Car Jesús jin te gá nzi cʉ pa‑cʉ. Diguebbʉ ya, bi ndo du̱ntju̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nubbʉ, ca Jin Gui Jo bi xifi, i̱na̱: ―I jma̱ntjo, ʉ́r ttʉqui ca Ocja̱. Bbʉ de vera ʉ́r ttʉqui ca Ocja̱, gui cjajpi nʉr me̱do‑nʉ da cja tju̱me̱, pa gui tzi.― Bi ma̱ ncjapʉ ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bi da̱h car Jesús, i̱mbi: ―I ju̱x pʉ jár palabra ca Ocja̱, i̱na̱: “Jin gui jøña̱ nʉr tju̱jme̱ i tzi nʉr cja̱hni drí hmʉy. Bbʉ ga mandadotsjɛ ca Ocja̱, da hmʉ ʉ́r nzajqui nʉr cja̱hni, nubbʉ́, da hmʉy.”― ");
INSERT INTO otsNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Diguebbʉ ya, ca Jin Gui Jo bi zix car Jesús ca hnar ttøø pʉ jabʉ már nte. Hna ratotjo bú u̱jti göhtjo nʉr mundo co göhtjo cʉ jöy, már tzi zö mír ni̱gui‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bi ma̱n ca Jin Gui Jo ya bbʉ, i̱mbi: ―Nugö, xtá ddahqui quer cargo göhtjo gui mandadobi yʉ, pa göhtjo cʉ cja̱hni cʉ i bbʉy ntero nʉr mundo da hñi̱zquiguɛ gú Ocja̱‑guɛ. Nuguigö, i tocagui dí mandadobi nʉr mundo, cja̱ bbʉ dí ne to gu un cam cargo, rá nzɛjqui pa gu uni. ");
INSERT INTO otsNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nuque, bbʉ gui ndadiña̱jmu̱, gui hñi̱zquigö, gu ddahquigö‑yʉ, gui cjajpi ir mɛjtiguɛ.― Bi ma̱ ncjapʉ ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bi da̱h car Jesús, bi ma̱: ―Nuquɛ Satanás, gui wembigui nttzɛdi. I ju̱x pʉ jar Escritura ya palabra‑yá, i̱na̱: “Gui nda̱ne ca Ocja̱ quer Tzi Jmu̱. Ddatsjɛ guegue gui nda̱ne cja̱ gui dyøjte.”― ");
INSERT INTO otsNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Diguebbʉ ca Jin Gui Jo bi zix jar Jesús car ciudad pʉ Jerusalén, bi hñi̱x pʉ jár ña̱jcu̱ car ndo ni̱cja̱, pʉ jabʉ már ndo nte. Nubbʉ́, bi xifi: ―Bbʉ ʉ́r ttʉqui ca Ocja̱ gui hñɛn ya guír tö jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porque i ju̱x pʉ jar Escritura, i̱na̱: Ca Ocja̱ da bbɛjpi quí ángele da möhqui. ");
INSERT INTO otsNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Guegue‑cʉ́ da zɛti quir dyɛ pa jin te gui cja, Nim pa jabʉ gui fehtzi hnar me̱do.― ");
INSERT INTO otsNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nu car Jesús bi da̱di ncjahua: ―Guejtjo i ma̱n ca Ocja̱ cam Tzi Jmu̱je pʉ jar Escritura: “Jin gui ma gui dyøti hnar cosa drá nttzo pa grí cca̱hti, ¿cja da dyøti milagro ca Ocja̱ pa da möxqui?”― ");
INSERT INTO otsNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ca Jin Gui Jo, bbʉ ya xquí guadi xquí dyøhtibi yʉ prueba‑yʉ car Jesús, diguebbʉ, bi jiɛgui, bi wembi tengu̱ mpa, hasta bbʉ pé di hñe̱h hnar hora drá zö pa pé di guati. ");
INSERT INTO otsNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Car Jesús bi ma gá ngoh pʉ jar estado Galilea. Göhtjo ca mí øti guegue, mí föx car tzi Espíritu Santo, como göhtjo ʉr tiempo mí yojmi cja̱ mí pɛhtzibi cár ttzɛdi. Göhtjo pʉ jar estado Galilea bi ntʉngui car jña̱, hasta bi ndo fa̱di ter bɛh ca̱ mí øti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mí dyo pʉ Galilea, mí tzøte rá ngu̱ cʉ tzi jñi̱ni, cja̱ mí cʉti cʉ tzi templo pʉ jabʉ mí jmu̱ntzi cʉ cja̱hni, mí u̱jti‑cʉ́ cár palabra ca Ocja̱. Cja̱ cʉ cja̱hni mí ndo respetajʉ. Guejtjo mí ma̱jmʉ, már ndo zö ca mí ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Car Jesús bi zøti pʉ jar jñi̱ni Nazaret, pʉ jabʉ bú te. Car pa ca mí cja tsjödi, gue car nsábado, bi ma jár ni̱cja̱ cʉ judio, porque mí øte ncjapʉ göhtjo ʉ́r vida. Bi hna ttöjpi di nøn cʉ Escritura, pa di dyøh cʉ pé dda cja̱hni, eso bi bböy. ");
INSERT INTO otsNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bi ttu̱n ca hnar jɛhmi ca xquí dyøti ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Isaías. Car Jesús bi xohti car rollo, bbʉ, bi jion car lugar pʉ jabʉ i ma̱ ncjahua, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Xí nguajqui cár tzi Espíritu ca Ocja̱, cja̱ dí yobbe‑ca̱. Guegue xí hñi̱xquigö gu tʉngui car jogui jña̱, gu föx yʉ cja̱hni, göhtjo yʉ to te i nesta. Xpá ngu̱jqui ca Ocja̱ pa gu ju̱htibi í mʉy yʉ cja̱hni yʉ i ndo du̱mʉy, Xpá ngu̱jqui gu xij yʉ preso, ya xta bøxijʉ, Gu xij yʉ godö, ya xta xoj yí döjʉ, Gu föx yʉ to i bbʉ ʉ́r dyɛ quí contrajʉ, ");
INSERT INTO otsNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Gu xij yʉ cja̱hni, ya xí nzʉh car cjeya pa da gʉx yí cja̱hni ca Ocja̱. Gue yʉ palabra‑yʉ bi nøn car Jesús pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bi pantzi car rollo, bbʉ, pé bi un car hñøjø ca mí pɛhtzi cʉ jɛhmi, cja̱ bi mi̱jöy, bbʉ. Cʉ pé dda cja̱hni cʉ már bbʉh pʉ jar ni̱cja̱ már jantitjojʉ car Jesús. Már tøhmijʉ, ngá ma̱jmʉ te pé di ma̱. ");
INSERT INTO otsNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Car Jesús bi ma̱m bbʉ: ―Nuya, rá pa ya, ya xí nzʉh ca i ma̱ngua jar Escritura, como nuya guí cca̱jtiguijʉ, cja̱ guí ødejʉ ca dár ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Göhtjo cʉ cja̱hni mí tzøjmʉ ca mí ma̱n car Jesús. Bi mbe̱ntsjɛ mbo í mʉyjʉ: “¿Jabʉ xcuí hñe̱j yʉ palabra yʉ i ma̱‑nʉ? Rá ndo zö ca i ma̱. ¿Ja ncja ga mba̱j yʉ cosa‑yʉ?” Guejtjo már hñöntsjɛjʉ: ―¿Cja jí̱ ʉ́r ttʉ car José nʉr hñøjø‑nʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Guegue car Jesús bi ma̱m, bbʉ: ―Pé ntoja guí ne gui xijquijʉ nʉr dicho‑nʉ: “Nuquɛ, guí ma̱nguɛ gúr doctor. Nuya, gui hñøtjetsjɛ ya, pa gu cca̱htije, ¿cja cierto guí pa̱di gui dyøtje?” Cja̱ pé guí ne gui xijquijʉ: “Xtu ødeje gú ndo dyøti milagro pʉ jar jñini Capernaum. Nuya, gui dyøjtiguije milagro rá ngu̱ hua jam jñinijʉ Nazaret, hne̱je̱.” Guehca̱ guí ne gui xijquijʉ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nugö, dí xihquijʉ, jin gui tte̱me̱bi hnár jmandadero ca Ocja̱ pʉ jabʉ ʉr mi̱ngu̱, eso, jin guí neguɛjʉ gui hñe̱me̱guijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Cja̱ pé dí xihquijʉ, már ngu̱ cʉ ddanxu̱ mír hmʉjcua jam jöyjʉ, nuhua Israel, bbʉ mí dyo ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Elías. Cʉ pa‑cʉ, bi zʉdi jñu̱ cjeya hne̱ ddajtjo za̱na̱, jí̱ mí wa̱y, cja̱ mí cja hnar ndo tju̱ju̱ göhtjo nʉm jöygöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pe jin gá cjú̱h car Elías pʉ jár ngu̱ hnam mi̱nga̱‑israelitajʉ pa drí guati pʉ. Ji̱na̱‑ca̱. Bi cju̱h pʉ jar jñini Sarepta, cerca pʉ jar jñi̱ni Sidón, cja̱ bi guati pʉ jár ngu̱ hnar ddanxu̱ múr mi̱ngu̱ pʉ, masque jí̱ múr cja̱hni israelita guegue‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Guejtjo már ngu̱ cʉ cja̱hni israelita cʉ mí tzöhui cʉ tsja̱xi cʉ i tsjifi ʉr lepra, cʉ pa cʉ mí bbʉh cár jmandadero ca Ocja̱ ca mí tsjifi ʉr Eliseo. Nu car Eliseo jin gá dyøtje‑cʉ. Ji̱na̱. Bi dyøtje ca hnar mi̱ngu̱ Siria ca mí ju̱ cár tju̱ju̱ múr Naamán. Nuca̱, jí̱ múr cja̱hni israelita‑ca̱ hne̱je̱. Eso, dí xihquijʉ, car Tzi Ta ji̱tzi i pɛjni yí jmandadero pʉ jabʉ jin gui mi̱ngu̱‑yʉ.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cʉ cja̱hni cʉ már bbʉh pʉ jar tzi ni̱cja̱, bbʉ mí dyødejʉ‑ca̱, bi ndo unijʉ ʉr cuɛ, gá jña̱jʉ ʉr huɛnda, már ma̱n car Jesús, jin drí möx cʉ mi̱ngu̱ pʉ Nazaret. Hnahño cja̱hni di möxi guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eso, bi mföxjʉ, bi zɛtijʉ car Jesús, bi gʉtijʉ gá ma jár nttza̱ni car jñi̱ni, pʉ jabʉ már bbʉh hnar ndo jñe̱. Bi hñi̱xjʉ jár nttza̱ni car jñe̱, mí ne di tsjöjquijʉ pʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nu car Jesús ya, xní bböti nttzɛdi, bi hui̱x cʉ cja̱hni, bi wem pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nubbʉ, car Jesús bi maa gá nzøti pʉ jar jñi̱ni Capernaum. Car jñi̱ni‑ca̱, guejtjo már bbʉh pʉ jar jöy Galilea. Cʉ pa cʉ mí cja tsjödi, car Jesús mí pa pʉ jar ni̱cja̱, cja̱ mí u̱jti cʉ cja̱hni pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Guegue‑cʉ mí ndo mpöjmʉ cja̱ mí ndo i̱htzibijʉ car Jesús, porque már ndo zö ca mí ma̱n‑ca̱. Mí pa̱di rá zö, te i ne da ma̱n car Escritura. ");
INSERT INTO otsNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Már bbʉh pʉ jar ni̱cja̱ ca hnar hñøjø ca mí yojmi cár nda̱ji̱ ca Jin Gui Jo. Nuca̱, bbʉ mí cca̱hti car Jesús, bi mafi nzajqui, bi ma̱: ");
INSERT INTO otsNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Nuya, ¿te guí cjaguije ya, nuquɛ, Jesús, gúr mi̱ngu̱ pʉ Nazaret? ¿Cja xcú hñe̱je̱ pa gui jña̱guije cam nttzɛdije? Dí pa̱dije toquiguɛ. Xpá ngu̱hqui car Tzi Ta ji̱tzi, xpá ddahqui quer cargo pa gui ta̱guigöje. Nuquiguɛ, gúr hñøjø rá nttzu̱jpiqui xquí hñe̱h pʉ jabʉ i bbʉh ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nu car Jesús bi huɛnti car ttzonda̱ji̱, bi xifi: ―Nuya, gui jui̱j ya, cja̱ gui wembi nʉr cja̱hni‑nʉ.― Nubbʉ, cár nda̱ji̱ ca Jin Gui Jo bi dɛjni car hñøjø pʉ jár madé cʉ cja̱hni már bbʉh pʉ, cja̱ bi wembi. Pe car hñøjø, jin te gá cjajpi, bi jogui rá zö‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bbʉ mí cca̱hti cʉ cja̱hni ya‑cá̱, bi ndo zu̱jʉ, bi ma̱jmʉ: ―¿Jabʉ xtú cca̱htijʉ ca di jñɛjmi‑nʉ? Nʉr hñøjø nʉ i tsjifi ʉr Jesús, i pɛhtzi cár cargo más rá ndo nzɛdi. I bbɛjpi yʉ ttzonda̱ji̱ da bøni, cja̱ nuyʉ i øjte.― ");
INSERT INTO otsNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Cja̱ bi ntʉngui car jña̱ digue cʉ milagro cʉ mí øti car Jesús. Bi dyøh cʉ cja̱hni cʉ mí bbʉ já tzi jñi̱ni cʉ mí cerca pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Diguebbʉ, bi bøm pʉ jar ni̱cja̱ car Jesús, cja̱ bi ma pʉ jár ngu̱ car Simón. Cár too car Simón mí ndo ca̱x car pá. Quí familia car Simón bi xih car Jesús di dyøtje tzʉ car döhtji. ");
INSERT INTO otsNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nu car Jesús, bbʉ, bi guati pʉ jabʉ már bbɛn car bbɛjña̱, cja̱ bi mandado pa di wen car jñi̱ni ca már tzöhui. Bi wen car jñi̱ni, bbʉ, cja̱ exque bi joh car bbɛjña̱. Bi nantzi, bi wi̱n car Jesús cja̱ co quí amigo cʉ mí yojmi. ");
INSERT INTO otsNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Diguebbʉ ya, bbʉ ya xi már cʉh car jiadi, göhtjo cʉ cja̱hni cʉ mí bbʉh quí döhtjijʉ, bú tzimpijʉ car Jesús. Cja̱ guegue ya, bi dyʉx quí dyɛ, bi jojqui göhtjo cʉ mí jñini. ");
INSERT INTO otsNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Guejto már ngu̱ cʉ cja̱hni cʉ mí yojmi cár nda̱ji̱ ca Jin Gui Jo, cja̱ car Jesús bi cjajpi cár nda̱ji̱‑ca̱ bi bøni. Cja̱ bbʉ nguá mbøn car nda̱ji̱, mí ndo ña̱ nzajqui, mí ma̱: ―Nuquɛ, ʉ́r Ttʉqui ca Ocja̱.― Nu car Jesús ya, mí ccax car ttzonda̱ji̱, jí̱ mí jɛgui di ña̱, porque nuca̱ mí pa̱di, guegue múr hñøjø ca xquí hñi̱x car Tzi Ta ji̱tzi pa di mandado. ");
INSERT INTO otsNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bbʉ mí ni̱gui ya car jiax‑ca̱, bi bøn car Jesús gá ma ca hnar lugar pʉ jabʉ jin to mí hña̱ni. Cja̱ bú tɛn cʉ cja̱hni, como mí ne di za̱mijʉ pa di hmʉjti pʉ, jin di ma di zoh‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nu car Jesús bi xijmʉ: ―Nugö, xpá cju̱jquigö gu má cʉ pé dda jñini hne̱je̱, gu ma grí xih cʉ cja̱hni car tzi jogui jña̱ dá ja̱. Gu xijmʉ, ya xqui mandado ca Ocja̱ hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nubbʉ, bi ma gá tjogui göhtjo cʉ tzi jñi̱ni jar estado Galilea. Mí cʉti göhtjo cʉ tzi ni̱cja̱, cja̱ mí xih cʉ cja̱hni car tzi ddadyo jña̱ ca mbá ja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Diguebbʉ ya, ca hnar pa, car Jesús már bbʉh pʉ jár nttza̱ni car mar ca i tsjifi Genesaret. Már ndo dʉ cʉ cja̱hni, mí ne di dyøjmʉ cár palabra ca Ocja̱, hasta mí ndo ntu̱jquijʉ, cja̱ car Jesús, jí̱ mí tzö jabʉ ngu̱ di hmöy pa di jogui di u̱jti cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nubbʉ, bi jianti yo tzi barco, ya xquí ttzoh pʉ jár nttza̱ni car mar. Ya xquí bøn cʉ mamöy, már pehti quí hmamöyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Car Jesús, bbʉ, bi ñʉti ca hnar barco ca múr mɛjti car Simón. Bi xifi di dyɛti car barco drí tzi ñʉta mbo car mar. Nubbʉ, bi mi̱h pʉ jar barco, bbʉ, cja̱ bi segue bi u̱jti cʉ cja̱hni cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bbʉ ya xquí guadi, pé bi nzoh car Simón, bi xifi: ―Nuya, gui dyɛti nʉr barco drí ma nʉ mbo nʉr deje, nʉ jabʉ rá je̱, cja̱ gui pøti quir hmamöyjʉ pa gui tzʉdijʉ cʉ möy rá ngu̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bi da̱h car Simón, bi xifi: ―Nuquɛ, Maestro, ya xtú pɛjme, xtú jaxje hua má̱nxu̱y, cja̱ jin te xtá tzʉdije cʉ möy. Pe nuya gu pøti nʉr hmamöy, porque guehquɛ guí ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bi møtijʉ cʉ hmamöy bbʉ, cja̱ bi zʉdijʉ rá ndo ngu̱ cʉ möy, hasta ya xi már xɛh quí hmamöyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nubbʉ, bi cjajpi ʉr seña quí mi̱nga̱‑mamöyjʉ cʉ már bbʉh ca hnar barco, pa di mföxjʉ di gʉxjʉ cʉ möy. Bú e̱jmʉ, bbʉ, cja̱ bi ñu̱htzijʉ cʉ möy göhtjo cʉ yo barco. Már ndo ngu̱ cʉ möy, hasta ya xi mí ne di ñʉh cʉ barco. ");
INSERT INTO otsNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Car Simón (guejtjo mí tsjifi ʉr Pedro) bi hna ba̱di, gue ca Ocja̱ xquí unijʉ cʉ möy rá ngu̱. Bi hna guati car Jesús, bbʉ, bi nda̱ndiña̱jmu̱, bi xifi: ―Nuquɛ, Tzi Jmu̱, dí pɛhtzi ʉm tzö já gár hmʉbi, porque rá ndo nttzoguigö.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Car Pedro co cʉ pé dda mamöy cʉ már bbʉpjʉ jár barco guegue, bi ndo mbe̱nijʉ car milagro ca xquí ncja, como már ndo ngu̱tsjɛ cʉ möy xquí zʉdijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Guejti car Jacobo co car Juan bi mbe̱nihui car milagro hne̱je̱. Guegue‑cʉ́ mí mi̱nga̱‑mamöyhui car Simón. Cár tahui múr Zebedeo. Car Jesús bi xih car Simón, bbʉ: ―Dyo guí tzu̱, porque nuya dí ddahqui quer bbɛfi hnahño. Nuya gui nzoj yʉ cja̱hni pa da dɛnguigö. Ya jin gui cja mamöy ya.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Diguebbʉ ya, bi dyɛnijʉ cʉ barco gá ma pʉ jár nttza̱ni car deje. Cja̱ cʉ jñu̱ mamöy bi zoh quí barco co göhtjo cʉ már cʉ pʉ, bi dɛnijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pé hnar vez, car Jesús már dyo pé hnar jñini. Már bbʉh pʉ hnar hñøjø, mí tzöhui hnar jnini i tsjifi ʉr lepra, mí jøtze ntero cár ndodyo rá ngu̱ cʉ ttzotsja̱xi. Guegue‑cá̱, bbʉ mí jianti car Jesús, bi guati, bi nda̱ndiña̱jmu̱, cja̱ bi xifi, i̱na̱: ―Nuquɛ, Tzi Jmu̱, ¿cja guí ne gui joguigui yʉm tsja̱xi?― ");
INSERT INTO otsNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Cja̱ car Jesús bi tʉngui cár dyɛ, bi döni, bi xifi: ―Dyo ya ca̱, dí ne. Xta joh quir tsja̱xi.― Cja̱ bi hna wen cʉ tsja̱xi bbʉ́, bi zö. ");
INSERT INTO otsNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Car Jesús, bbʉ́, bi xifi jin to di götzi, i̱na̱: ―Ma ya, gui ma u̱jti car möcja̱, ya xcú zö, cja̱ gui dö hnar zu̱we̱ pa da jña̱htibi ca Ocja̱, como ngu̱ ga mandado car Moisés pʉ jar ley. Gui dyøte göhtjo ca i ma̱m pʉ, pa ncjapʉ drí ba̱j yʉ cja̱hni, ya xí joh quir tsja̱xi.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pe nde̱jma̱ bi hño car jña̱, más bi ndo fa̱di te mí øti car Jesús. Rá ndo ngu̱ cja̱hni bi jmu̱ntzijʉ pa di dyødejʉ cár tzi palabra ca Ocja̱. Guejtjo bi ngu̱jqui cʉ to mbá tzí quí döhtjijʉ pa di jojqui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nu car Jesús pé bi wem pʉ, bi ma gá ma pʉ jabʉ jin to mí hña̱ni, cja̱ nupʉ, bú nzoh ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pé hnar vez, bbʉ már bbʉjti car Jesús pʉ jar estado Galilea, bi nzoh cʉ cja̱hni. Cja̱ bi guati cja̱hni rá ngu̱ pa di dyøh cár palabra ca Ocja̱. Guejtjo már ju̱h pʉ cʉ dda fariseo co ni cʉ dda maestro, cja̱ nucʉ, bi dyødejʉ hne̱je̱. Cʉ cja̱hni‑cʉ, xquí ndo nxöh cár ley car Moisés. Xcuí hñe̱jmʉ göhtjo tema jñi̱ni pʉ jar estado Galilea, co ni pʉ jar estado Judea, co hne̱h pʉ jar ciudad Jerusalén, pa di dyødejʉ te mí ma̱n car Jesús cja̱ di cca̱htijʉ cʉ milagro mí øte. Car Jesús mí ndo yojmi cár ttzɛdi ca Ocja̱, eso, mí xoxi döhtji rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bi zøti cʉ dda hñøjø, mbá tu̱jʉ hnar döhtji, xquí hna̱htzi quí hua cja̱ jí̱ mí tzö di hña̱ni. Mí ne di ñʉtijʉ pʉ mbo car ngu̱ pʉ jabʉ már bbʉh car Jesús, pa di dyöjpijʉ di jojqui tzʉ car döhtji. ");
INSERT INTO otsNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bi cca̱htijʉ ya, jí̱ mí tzö di cʉhtijʉ car döhtji, como már ndo dʉ cʉ cja̱hni pʉ jar goxtji. Nubbʉ, bi dexjʉ jar ña̱jcu̱, bi xohtzijʉ tengu̱ cʉ teja, cja̱ bi ga̱hmijʉ car hñøjø, ntero co cár mfi̱di, gá tzo pʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Car Jesús ya, bi cca̱hti quí amigo car döhtji cʉ mbá tu̱jʉ, mí ndo e̱me̱jʉ guegue. Cja̱ bi nzoh car döhtji, bbʉ, bi xifi: ―Nuquɛ, tada, ya xí mperdonaqui ca xcú dyøti ca rá nttzo.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Cʉ maestro cʉ mí ndo nxöh car ley, co cʉ fariseo, bbʉ mí dyødejʉ car palabra‑ca̱, bi unijʉ ʉ́r cuɛ, como gá mbe̱nijʉ: “¿Dyoca̱ i ma̱ ncjapʉ? Ncjahmʉ i ne da cjatsjɛ Ocja̱ nʉr cja̱hni‑nʉ. Ddatsjɛ ca Ocja̱ i pɛhtzi derecho da perdonabi yʉ cja̱hni ca xí dyøti ca rá nttzo.” ");
INSERT INTO otsNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nu car Jesús bi ba̱tibi quí mfe̱ni cʉ cja̱hni‑cʉ. Bi dyöni, bbʉ: ");
INSERT INTO otsNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","―¿Dyoca̱ xí ddahquijʉ ʉr cuɛ ca xtá xij nʉr hñøjø‑nʉ́, xí mperdonabi ca xí dyøte? Guejtjo di zö nʉr döhtji bbʉ gua xifi di bböy cja̱ di hño. ");
INSERT INTO otsNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nuya, gu u̱jtiquijʉ, cierto dí pɛhtzigö ʉm cargo hua jar jöy pa gu perdonabi yʉ cja̱hni ca te xí dyøte, como guejcö dúr cja̱hni xpá bbɛnqui hua jar jöy.― Nubbʉ́, bi nzoh car döhtji bbʉ́, bi hñi̱mbi: ―Dí xihqui, nuya gui nantzi, tu̱x nir mfi̱di, cja̱ gui me ir ngu̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cja̱ car döhtji ya, bi hna bböy, bi du̱x cár mfi̱di, cja̱ bi ma ʉ́r ngu̱. Má ndo öjpi mpöjcje ca Ocja̱. Göhtjo cʉ cja̱hni bi cca̱htijʉ te bi ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bi ndo mbe̱nijʉ car milagro, göhtjojʉ, már ndo i̱htzibijʉ car Tzi Ta ji̱tzi, cja̱ co guejti car Jesús, por rá ngue ca xquí dyøti‑cá̱. Bi ma̱jmʉ: ―¿Jabʉ xtú nu̱jʉ hnar cosa ca di jñɛjmi ca xí ncja ya? Rá ndo zö.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Diguebbʉ ya, bi bøn car Jesús, cja̱ bi jianti hnar hñøjø, mí pɛjpi car gobierno, mí cobra cʉ contribución. Már ju̱ pʉ jabʉ mí jmu̱ntzi‑cʉ. Mí ju̱ cár tju̱ju̱ múr Leví. Car Jesús bi nzofo, bi xifi: ―Nuquiguɛ, gui tɛnguigö ya.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Cja̱ guegue car Leví bi bböy nguetica̱, bi zoh cár bbɛfi, bi dɛn car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ca hnajpa, car Leví bi mandado bi ttøti hnar mbaxcjua pʉ́r ngu̱, bi mvitabi car Jesús cja̱ co quí amigo‑ca̱. Guejtjo bi mvitabi quí amigotsjɛ cʉ mí pɛjpi car gobierno. Guejti‑cʉ mí jmuntzi cʉ contribución. Guegue‑cʉ cja̱ co pé dda cja̱hni rá ngu̱ már tzijʉ pʉ́r ngu̱ car Leví. ");
INSERT INTO otsNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Guejtjo bi guati pʉ cʉ dda fariseo co ni cʉ dda maestro cʉ mí u̱jti cʉ cja̱hni car ley ca bi dyøti car Moisés. Guegue‑cʉ́ bi cca̱htijʉ car Jesús cja̱ co quí amigo, már tzijʉ pʉ hne̱je̱, cja̱ bi zohmijʉ. Bi xijmʉ quí amigo car Jesús: ―¿Dyoca̱ xcú mpɛjnijʉ yʉ jiöjte yʉ i cobra car contribución, co hne̱j yʉ pé dda cja̱hni yʉ rá ndo nttzo? Hnaadi hua gár tzijʉ‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Car Jesús bi da̱di bi xijmʉ: ―Rí ntzöhui gu yobbe yʉ cja̱hni yʉ jin gui tzö cár vida. Como i ncjá ncja ngu̱ döhtji‑yʉ́, i nesta nʉr médico. Nu cʉ cja̱hni cʉ jin te i cja, jin gui nesta médico. ");
INSERT INTO otsNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nugö xtú e̱je̱ pa gu nzoj yʉ cja̱hni yʉ i ndu̱jpite, pa da jiɛh ca rá nttzo, da jionijʉ ca Ocja̱. Jí̱ xtá e̱je̱ pa te gu xij yʉ cja̱hni yʉ i ma̱ jin gui ndu̱jpite.― ");
INSERT INTO otsNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nubbʉ́, quí contra car Jesús bi dyönijʉ, bbʉ, bi hñi̱mbijʉ: ―I ayuna cʉ hñøjø cʉ i tɛn car Juan, segue i ayuna‑cʉ́ cja̱ i mahtijʉ ca Ocja̱. Guejti yʉ to i tɛn yʉ fariseo, i øtijʉ ncjadipʉ. Nu yʉ i tɛnquiguɛ, jin gui ayunajʉ. ¿Dyo ya ca̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Car Jesús bi xijmʉ, bbʉ: ―Cierto, jin gui ayuna yʉm amigo yʉ pa ya. Jin da jogui da ayuna yí amigo nʉr novio, bbʉ ra bbʉjti nʉr novio, ra ttøhtibitjo cár mbaxcjua gá ntja̱jti. ");
INSERT INTO otsNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ba e̱j yʉ pa bbʉ ya xtrú ma nʉr novio. Nubbʉ, da ayuna yí amigo, bbʉ.― Ncjapʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Cja̱ pé bi xih cʉ cja̱hni pé hnar comparación, bi hñi̱mbijʉ: ―Jin to di xɛjquibi hnár pedazo hnar ddadyo pajni pa drí møhti hnar zɛpajni. Hmɛditjo xtrú xɛh car ddadyo, cja̱ jin di jñøhui car zɛda̱tu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Guejtjo jin gui tsjiti hnar zɛxfani car ddadyo vino ca jí̱ bbe i mbödi, porque da fʉgui, da ndʉ cár jña̱, da xɛh car xifani. Nubbʉ́, da mfön car vino cja̱ da ttzon car xifani hne̱. ");
INSERT INTO otsNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","I tsjiti car ddadyo vino hnar xifani rá zö. ");
INSERT INTO otsNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Car cja̱hni ca xí nzi car vino ca ya xí mbödi, ya jin gui ne car jugo gá uvatjo. I ma̱ntjo, más rá ncʉji car vino ca ya xí mbödi.― Ncjapʉ gá ma̱n car Jesús. Gue yʉ palabra‑yʉ́ mír jɛquihui cʉ ddadyo palabra cʉ mí ma̱ guegue co car jugo ca jí̱ bbe i mbödi. Nu cʉ costumbre cʉ mí tɛn cʉ judio desde ya má yabbʉ, mír jɛquihui car vino ca ya xí mbödi. ");
INSERT INTO otsNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ca hnar pa nsabado, car Jesús bi tjoh pʉ ja jua̱ttɛy, má hñohui cʉ hñøjø cʉ mí tɛni. Nucʉ, má tʉjqui cʉ ña̱ttɛy, má ta̱jmi co quí dyɛjʉ, cja̱ má tzajʉ hña̱tjo cʉ ttɛy. ");
INSERT INTO otsNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Már bbʉh pʉ hne̱je̱ cʉ dda fariseo, cja̱ bbʉ mí cca̱htijʉ te má øti quí amigo car Jesús cʉ mí tɛnijʉ, bi ma̱ guegue‑cʉ: ―¿Dyoca̱ guí øtijʉ ca jin gui tjɛgui da ttøti nʉr pa nsabado, como rá nttzu̱jpi nʉr pa ya?― ");
INSERT INTO otsNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bi da̱h car Jesús, bbʉ, bi xijmʉ: ―¿Te rá nguehca̱ guí tzobiguije? ¿Cja jí̱ xquí cca̱htijʉ cʉ Escritura, pʉ jabʉ i cuati car bbede, te bi dyøti car David ca hnar vez bbʉ már tu̱ntju̱, co ni cʉ hñøjø cʉ már hñohui? ");
INSERT INTO otsNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Guegue bi ñʉti pʉ jár ngu̱ ca Ocja̱, bi gʉjqui cʉ tju̱jme̱ rá nttzu̱jpi cʉ xquí jña̱htibi ca Ocja̱, cja̱ bi zi. Guejtjo bi un cʉ hñøjø cʉ már hñohui, cja̱ nucʉ bi zi hne̱je̱. Jin gui tjɛgui to da zi cʉ tju̱jme̱‑cʉ, jøntsjɛ cʉ möcja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nugö, dí xihquijʉ, guejcö dúr cja̱hni xpá bbɛnqui hua jar jöy, eso dí pɛhtzi derecho gu mandado, ter bɛh ca̱ da ttøti nʉr pa nʉ rá nttzu̱jpi.― ");
INSERT INTO otsNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ca pé hnar nsabado, car Jesús bi ñʉti jar ni̱cja̱, cja̱ bi u̱jti cʉ cja̱hni cár palabra ca Ocja̱. Guejtjo már bbʉh pʉ hnar hñøjø xquí dyoti cár jogui dyɛ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Cʉ maestro cʉ mí u̱jti car ley, co ni cʉ fariseo, mí jantitjojʉ car Jesús, mí tøhmitjojʉ, cja di dyøtje car döhtji car pa‑cá̱, como már nttzu̱jpi. Mí jonijʉ te di jiøxjʉ car Jesús ca drá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Car Jesús ya, bi ba̱di te már be̱nijʉ. Bi nzoh car hñøjø ca xquí dyoti ca hnár dyɛ, bi xifi: ―Bböy, bú e̱cua jabʉ da cca̱jtiqui yʉ cja̱hni.― Bi bböh car hñøjø, bbʉ́, cja̱ bi ma gá nguati car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Diguebbʉ ya, car Jesús bi dyön cʉ hñøjø cʉ már cca̱htijʉ: ―Dí önquijʉ ya, ¿cja gu föxjʉ yʉ cja̱hni na̱r pa na̱ rá nttzu̱jpi cja huá gu øhtibijʉ ca rá nttzo? ¿Cja gu föxjʉ hnar döhtji pa jin da du̱, cja huá gu jɛguijʉ da du̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nubbʉ́, car Jesús bi cca̱hti göhtjo cʉ már bbʉh pʉ, guegue‑cʉ mí ne te di jiøxjʉ. Bi døhmi te drí da̱h‑cʉ́, pe u̱jtjo. Diguebbʉ bi xih car hñøjø, bi hñi̱mbi: ―Tʉngui ya quer dyɛ.― Car hñøjø bi tʉngui cár dyɛ bbʉ́, cja̱ bi hna jojtjo. ");
INSERT INTO otsNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Cʉ fariseo ya, co ni cʉ maestro, bi ndo ʉjʉ car Jesús, hasta ngu̱ di nlocojʉ. Bi ña̱tsjɛjʉ ja di ncjajʉ pa drí möhtijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gue cʉ pá cʉ́, car Jesús bi bøx pʉ jar ttøø pa di nzoh ca Ocja̱. Bi jaxti ʉr xu̱y, mí mahti Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bbʉ mí nxu̱di ya bbʉ́, bi nzoh cʉ hñøjø cʉ mí tɛni cja̱ bi juajni doce pa di yojmi guegue. Bi un‑cʉ́ cár cargo gá apóstole pa drí hñojʉ, drí tʉngui cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bi hñi̱x car Simón, ca mí tsjifi múr Pedro. Cja̱ bi hñi̱x cár cjua̱da̱, gue car Andrés. Guejtjo bi hñi̱x car Jacobo co car Juan, car Felipe, co ni car Bartolomé. ");
INSERT INTO otsNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Guejti car Mateo, car Tomás, co car Jacobo (múr ttʉ car Alfeo‑cá̱) co car Simón ca mí tsjifi ʉr cananista. Bi hñi̱tzi göhtjo‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Bi hñi̱x car Judas, cár cjua̱da̱ car Jacobo. Guejti car Judas Iscariote, ca bi dö car Jesús, bi hñi̱tzi hne̱je̱. Mí doce quí möxte cʉ bi hñi̱x car Jesús pa di yojmi guegue cja̱ di mötzi di tʉnguibi cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bú ca̱jmʉ jar ttøø, gá nzøjmʉ pʉ jar bbatja. Nupʉ, bi ndo guati cja̱hni rá ngu̱, mír dɛnijʉ pa di dyødejʉ cár palabra ca Ocja̱. Xcuí hñe̱jmʉ car estado Judea, co car jñi̱ni pʉ Jerusalén, co pʉ jar jöy pʉ jár nttza̱ni car ndo mar, pʉ jabʉ mír hmʉh cʉ jñi̱ni Tiro co pʉ Sidón. Bú e̱jmʉ pa di dyødejʉ ca mí ma̱n car Jesús, cja̱ mbá tzimpijʉ döhtji pa di dyøtje guegue. Cja̱ bi zö göhtjo cʉ döhtji. ");
INSERT INTO otsNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Guejti cʉ cja̱hni cʉ xquí zʉ ttzonda̱ji̱, car Jesús bi jojqui ntero‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Göhtjo cʉ cja̱hni, mí ne di guatijʉ car Jesús pa di dönijʉ, como mí ndo pɛhtzi ʉ́r ttzɛdi guegue‑ca̱. Bbʉ mí tjöndijʉ jøntsjɛ quí da̱jtu̱ car Jesús, mí joh cʉ döhtji, göhtjo ca te mí tzöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Car Jesús bi nzoh cʉ hñøjø cʉ mí tɛni, bi xijmʉ: ―Rá ndo zö guir hmʉpjʉ, nuquɛjʉ jin te guí pɛhtzijʉ, porque ca Ocja̱ xí nzohquijʉ pa grí hmʉpjʉ pʉ jabʉ i mandado guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Guejtjo, masque guí tu̱ntju̱jʉ hua jar jöy, rá zö guir hmʉpjʉ, porque ba e̱h car pa bbʉ xta ttahquijʉ te gui tzijʉ hasta gui niña̱jʉ rá zö. Nuquiguɛjʉ, como ngu̱ guir nzonijʉ yʉ pa ya, dí xihquijʉ, rá zö gri hmʉpjʉ, porque xta zøh car pa bbʉ xquí tjedejʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Guejtjo como ngu̱ ga ʉquijʉ yʉ cja̱hni por rá nguejquigö, rí ntzöhui gui mpöjmʉ. Masque da fonquiquijʉ yʉ cja̱hni, yʉ pa ya, masque da zanquijʉ, masque da zo ʉ́r cji̱jnijʉ bbʉ xta dyøh quir tju̱ju̱jʉ, por rá nguehca guír tɛnguigöjʉ, rí ntzöhui gui mpöjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gui ndo mpöjmʉ, hasta gui ntsjöjquijʉ hne̱, porque pʉ jar ji̱tzi da ttahquijʉ ca drá tzi zö. Guejti cʉ cja̱hni cʉ mí bbʉ ya má yabbʉ, mí ncjajʉ pʉ, mí ʉn quí jmandadero ca Ocja̱ cʉ mí xijmʉ cár tzi palabra‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nu yʉ rico yʉ rí ma ʉ́r mʉyjʉ yʉ i pɛhtzi hua jar jöy, da ndo du̱mʉyjʉ, como ya jin te pé da ttun‑yʉ pʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tzi probe yʉ cja̱hni yʉ i ndo ñu̱nijʉ yʉ pa ya, porque xta zøh car pa da ndo du̱ntju̱‑yʉ. Tzi probe hne̱je̱ yʉ cja̱hni yʉ i mpöjmʉ por rá nguehca̱ rí nu̱jʉ cosa rá zö hua jar mundo. Tzi probe‑yʉ, como ya xpa e̱h car pa bbʉ xta nzonijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Da ndo sufri hne̱je̱ yʉ cja̱hni yʉ jin gui ttzangua jar jöy, göhtjo cʉ pé ddaa i tzøjmʉ cja̱ i xijmʉ ca rá zö. I jñɛjmʉ cʉ jiöjte profeta cʉ mí bbʉ ya má yabbʉ. Guegue‑cʉ mí ndo tti̱htzibi cja̱ mí ndo jne hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nuquɛjʉ, ncja ngu̱ guir tɛnijʉ yʉ palabra yʉ dí xihquijʉ, gui ma̱dijʉ quir contrajʉ, cja̱ gui dyøhtibijʉ ca rá zö cʉ to i ʉquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gui dyöjpijʉ ca Ocja̱ da möx cʉ to i tzanquijʉ. Gui nzojmʉ pa da bendeci cʉ to i øjtiquijʉ ca rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nu ca to da cuajtiqui hnar mpɛhti jer jmi, gui jiɛgui pé drí cuajtiqui hnar mpɛhti ca pé hner jmi. Ca to da ga̱nqui quer manga, jiɛgui da ga̱nqui quer pajni hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Car cja̱hni ca te da dyöhqui, gui u̱ni. Bbʉ to da jña̱zqui tema cosa dir mɛjtiguɛ, ya jin gui ma gui dyöjpi‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gui dyøhtibi ca rá zö quer hñohui. Dyøhtibi ncja ngu̱ gri ne di ttøjtiquiguɛ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bbʉ guí nejʉ jøntsjɛ cʉ cja̱hni cʉ i nequijʉ, jin gui tzö ca guí øtijʉ, bbʉ. Hasta yʉ cja̱hni yʉ jin gui e̱me̱ ca Ocja̱, i nejʉ cʉ to i ne gueguejʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Guejtjo bbʉ guí fötzi jøntsjɛ cʉ cja̱hni cʉ xí möxqui, jin gui tzö‑ca̱. Ncjahmʉ guí cohtzibitjo car favor ca xí dyøjtiqui‑cʉ. Guejti cʉ cja̱hni cʉ i ndu̱jpite, i cohtzi cʉ favor cʉ i ttøhtibijʉ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Guejti car cosa ca te guí pɛhtzi, gui jmi̱pi car cja̱hni ca di nesta, masque jin te di ja̱ pa te pé da jmi̱hqui. Bbʉ gui jmi̱pi quir cosa jøntsjɛ cʉ cja̱hni cʉ te pé da jmi̱hqui, jin gui tzö ca guí øte, bbʉ. Hasta yʉ cja̱hni yʉ i ndu̱jpite, i jmi̱pi yí mi̱nga̱‑cja̱hnihui quí cosa, como i ne pé da jmi̱pi ca te da nesta, pé hnar pá. ");
INSERT INTO otsNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nuquɛjʉ, dí xihquijʉ, gui ma̱dijʉ quir contrajʉ, cja̱ gui dyøhtibijʉ ca rá zö. Gui jmi̱pijʉ ca i öhquijʉ, masque jin te pé da jmi̱hquijʉ gueguejʉ. Bbʉ gui dyøtijʉ ncjapʉ, nubbʉ, xquí jñɛjmʉ quer Tzi Tajʉ ca bí bbʉ ji̱tzi, cja̱ guegue‑ca̱ da ddahquijʉ ca drá tzi zö. Guegue‑ca̱ i jui̱jquite cja̱ i föx yʉ cja̱hni, masque nuyʉ, jin gui öjpijʉ cja̱ma̱di, como rá nttzo quí mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nuquɛjʉ, i nesta gui jui̱jquijʉ yʉ cja̱hni, hne̱je̱, ncja ngu̱ quer Tzi Tajʉ i jui̱jquite. ");
INSERT INTO otsNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nuquɛjʉ, bbʉ jin gui nejʉ da ttzopiquijʉ, dyo guí tzohmijʉ quir mi̱nga̱‑cja̱hnijʉ. Dyo guí ma̱nguɛ i ndu̱jpite quer hñohui bbʉ jin guí ne da tsjihqui guí ndu̱jpiteguɛ hne̱je̱. Gui perdonabi quer hñohui pa da mperdonaqui ca guí tu̱guɛ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bbʉ to te gui u̱nijʉ, da cja Ocja̱ pa pé da ttahquijʉ ca gui nestajʉ. Da ñu̱htzi rá zö car ttɛni, da dʉhti, da jua̱ti, hasta da mfonti. Ncjapʉ da ttahquijʉ. Ncja ngu̱ gri u̱nijʉ, da ncjapʉ drí ttahquijʉ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Car Jesús bi nzoh quí amigo cʉ mí tɛnijʉ. Bi xijmʉ nʉr ejemplo‑nʉ, bi hñi̱mbijʉ: ―Hnar godö ya, co pe hnar godö, ¿cja da jogui da u̱jti jabʉ da hño? Ji̱na̱. Pe ntoja göhtjo yojmi da tzohui jar hñu̱tje. ");
INSERT INTO otsNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hnar éscula, cja i nxöjtjo ca i ma̱n cár maestro. Como i nxöjtjo, jin gui jogui da da̱pi cár maestro. Sólo bbʉ xta cjuajti rá zö quí estudio, nubbʉ, xta ba̱di rá zö, ncja ngu̱ cár maestro, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Dyoca̱ guí tzohmi quer hñohui bbʉ guí cca̱hti, xtrú dyøti ca rá nttzo? ¿Dyoca̱ jin gui cca̱htitsjɛ quer falta gú dyøte? Guí jñɛjmi hnar cja̱hni i ne da möx cár hñohui da jña̱hmi hnar tzi ngʉnza xí tzo jár dö. Pe guegue, i o hnar za rá ndo nojo jár dö. ");
INSERT INTO otsNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Cja da jogui gui xih quer hñohui: “Tøhmi, xtá ja̱hmi ca i o nir dö,” siendo, jin guí pa̱di, i o quer döguɛ hnar za rá nojo? ¿Toca̱ guí ne gui jiöti ya, bbʉ? Bbɛto gui jña̱hmi car za ca i o quer döguɛ, cja̱ diguebbʉ ya, cja da jogui gui jña̱hmpi ca te i o jár dö quer hñohui. ");
INSERT INTO otsNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Bbʉ rá zö hnar za, i tu̱ cár fruta rá zö hne̱je̱. Cja̱ bbʉ jin gui tzö car za, jin gui tzö cár fruta i tu̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Según car fruta, i fa̱di tema clase car za. Jin gui tu̱ higo yʉ tzi paxi gá hmini. Jin gui tu̱ uva hnar za gá hmini. ");
INSERT INTO otsNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hnar jogui cja̱hni i mbe̱ngui jogui mfe̱ni, eso i ma̱n ca rá zö hne̱je̱. Hnar cja̱hni rá nttzo i mbe̱ngui nttzomfe̱ni, eso, i ma̱ngui palabra jin gui tzö hne̱je̱. Ca te xí mbe̱ni mbo ʉ́r mʉy hnar cja̱hni, guehcá̱ da ma̱. ");
INSERT INTO otsNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Dyoca̱ guí nzojquigö ir jmu̱guijʉ, bbʉ jin guí ne gui dyøtijʉ ca dí xihquijʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Xtá xihquijʉ ja i ncja car cja̱hni ca i øh ca dí ma̱, cja̱ i øte. ");
INSERT INTO otsNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Guegue‑ca̱ i jñɛjmi hnar hñøjø ca bi xotzi rá zö cár ngu̱. Bbɛto bi göti car cimiento já me̱do. Bi xi̱hmi car jöy, már je̱ bi dyøti car cimiento, hasta bbʉ mí döti car do rá me̱. Cja̱ diguebbʉ ya, bi xox cár ngu̱ pʉ xøtze jar cimiento‑ca̱. Masque bú ndo e̱ deje cja̱ co nzøjtje, bi dɛjni car ngu̱, pe jí̱ mí tzö di dyenti, porque xquí tsjotzi pʉ xøtze car me̱do. ");
INSERT INTO otsNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nu car cja̱hni ca i øh ca dí ma̱, pe jin gui øte, i jñɛjmi car hñøjø ca bi xox cár ngu̱ jar bbomu̱tjo, mí u̱jtjo car cimiento. Bú e̱h cʉ nzøjtje, bi dɛjni, cja̱ ncjatica̱ bi dyenti. Bi tjegue rá zö car ngu̱‑ca̱.― Ncjanʉ gá xih quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Car Jesús bi xih cʉ cja̱hni yʉ palabra‑yʉ, cja̱ guegue‑cʉ bi dyøde. Bbʉ mí guadi mí u̱jti cʉ cja̱hni, nubbʉ, bi ma gá ñʉti jar jñi̱ni Capernaum. ");
INSERT INTO otsNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mí bbʉh pʉ ca hnar capitán romano, mí jñi̱ngui hnár mɛfi. Nucá̱, mí ndo ne rá ngu̱. Cja̱ nu car mɛfi, mí ndo jñini, hasta ya xi mí ne di du̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nu car capitán, bi dyøh ca mí ma̱n cʉ cja̱hni digue car Jesús. Nubbʉ́, bú pɛjni cʉ dda tita cʉ mí mandadobi cʉ cja̱hni israelita, pa di dyöjpi car Jesús hnar favor di ma tzʉ, du dyøtjebi cár mɛfi. ");
INSERT INTO otsNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Cja̱ nucʉ́, bú e̱jmʉ pʉ jabʉ már bbʉh car Jesús. Bi ndo dyöjpijʉ car favor, bi xijmʉ: ―ʉr jogui cja̱hni car capitán ca xpá ngu̱jquije. Rí ntzöhui gui ma bú dyøtjebi cár mɛfi. ");
INSERT INTO otsNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Porque i ndo ma̱j yʉm cja̱hnijʉ, hasta xí dyøjtiguije hnar ni̱cja̱ pʉ jam jñi̱nije.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nubbʉ́, car Jesús bi möjmʉ. Pe bbʉ ya xti zøtijʉ jár ngu̱, car capitán pé bú pɛjni cʉ dda hñøjø cʉ mí yojmi. Hnaa cʉ cja̱hni‑cʉ́ bi guati car Jesús, bi xifi: ―Nuquɛ, Tzi Jmu̱, ya jin gui nesta gui ma pʉ jár ngu̱ car capitán, porque i ma̱ guegue, jí̱ rí ntzöhui gui cʉti pʉ́r ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Guejtjo jí̱ xcuá ne xcuá hñe̱cua pa di nzohqui, como i ma̱ guegue, desde guejcua, bbʉ jøntjo gui ma̱n quer palabra, da zö cár mɛfi. I ma̱ guegue da ttøti ca gui ma̱, como rá nzɛhqui. ");
INSERT INTO otsNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","I ma̱n car capitán, i̱na̱: “Hne̱quigö, xí tti̱xqui, xí ttajqui cam cargo. I bbʉh cʉ to i mandadogui, cja̱ nugö dí øjtibi cár palabrajʉ. Cja̱ pé dí hñi̱jcö cʉm sundado hne̱je̱ cʉ dí mandadobi. Bbʉ dí xij nʉ́ da ma, i pa. Cja̱ nʉ pé hnáa, bbʉ dí mahtitjo du e̱je̱, ba e̱je̱. Hne̱h cam mɛfi, bbʉ dí xifi: Dyøti nʉ́, i øte. Eso, dí pa̱di, ncja ngu̱ ga ttøjtigui cam palabra, ncjadipʉ da ttøjtiqui quer palabra, hne̱je̱.” Ncjapʉ xpá ma̱n car capitán.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bbʉ mí dyøj nʉr palabra‑nʉ car Jesús, bi ndo tzøjø. Bi bböti, bbʉ, bi xih cʉ cja̱hni cʉ má tɛni: ―Nugö dí xihquijʉ, ni jabʉ xtá nu̱ hnar cja̱hni ca xtrú ndo hñe̱me̱gui ncja ngu̱ car capitán‑ca̱. Ni digue yʉm mi̱nga̱‑israelitajʉ, jin gui e̱me̱gui ncja ngu̱‑ca̱.― Bi da̱di ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nubbʉ, cʉ hñøjø cʉ xcuí bbɛjni pʉ jár ngu̱ car capitán bi ma gá ngojmʉ pʉ, cja̱ bi dötijʉ, ya xquí zö car mɛfi ca mí jñi̱nijma̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Diguebbʉ ya, car Jesús bi bøni, mír ma jar jñi̱ni ca mí tsjifi Naín. Má pöjmʉ quí möxte cʉ mí ntzixihui. Guejtjo már ngu̱ cʉ pé dda cja̱hni cʉ má tɛnijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cja̱ bbʉ ya xi mír ma di ñʉti jar jñi̱ni, bi jianti hnar ánima, ya xi mbá hnu̱ du ttögui. Car hñøjø ca xquí du̱, mí ddatsjɛ múr ttʉ cár me, cja̱ nuca̱ múr ddanxu̱. Cja̱ mbá hñojʉ cár me car añima pé dda cja̱hni rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Car Jesús ya, bbʉ mí ntjɛhui cár me car ánima, bi jui̱jqui, cja̱ bi xifi: ―Dyo guí zoni.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Cja̱ bi guati, bi göx cár dyɛ pʉ jar tabla pʉ jabʉ már ox car ba̱jtzi hñøjøtjo, cja̱ nu cʉ to mbá tu̱ ya, bi tzi døhmijʉ. Cja̱ guegue bi nzoh car ánima, bi xifi: ―Nuquɛ, ttʉ, dí xihqui, nantziguɛ ya.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Diguebbʉ ya, bi zö car ba̱jtzi hñøjø, pé bú coh cár mʉy, cja̱ bi mi̱, bi mʉdi bi ña̱. Nubbʉ, car Jesús bi hñi̱hti cár me. ");
INSERT INTO otsNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cja̱ bi ntzu̱jʉ göhtjo cʉ már cca̱htijʉ, bi ma̱jmʉ te tza rá nzɛh ca Ocja̱. Bi hñi̱na̱jʉ: ―Cierto rá nzɛdi nʉ hnár jmandadero ca Ocja̱ nʉ xí nzøcua.― Mí bbʉh cʉ ddáa cʉ bi ma̱jmʉ: ―Cierto xí mbe̱nguigöjʉ cam Tzi Tajʉ ji̱tzi, cja̱ xí ndo möxquijʉ, yí cja̱hniguijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Cja̱ diguebbʉ ya, bi ndo ngöxtejʉ nʉr milagro nʉ xquí dyøti car Jesús. Bi dyøde göhtjo cʉ cja̱hni pʉ jar estado Judea, cja̱ guejtjo bi ttøde hasta cʉ lugar göhtjo jáy nttza̱ni car estado‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Cʉ hñøjø cʉ mí tɛnijʉ car Juan ca mí xix cʉ cja̱hni bi xifi göhtjo cʉ te xquí ncja. Nubbʉ, car Juan bi nzofo yojo‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bi gu̱jmi drí ma pʉ jabʉ már bbʉh car Jesús pa di dyönihui, ¿cja mí gue car Cristo ca di hñe̱cua jar jöy, cja huá mí nesta di døhmijʉ hnahño ʉr cja̱hni? ");
INSERT INTO otsNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bi ma cʉ yojo jmandadero, bbʉ́, bi guatihui car Jesús, cja̱ bi dyönihui ncjahua: ―¿Cja guehquiguɛ gúr cja̱hni xquí jma̱ du bbɛnqui hua jar jöy pa güi föxcöje, cja huá hnahño ʉr cja̱hni dí tøhmije pa da möxcöje?― Ncjapʉ gá hñönihui. ");
INSERT INTO otsNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mero bbʉ mí zøti pʉ cʉ yojo jmandadero, car Jesús már ndo cjʉhtzi rá ngu̱ jñi̱ni, co jñi̱ni cʉ xcuí hñe̱ gá castigo. Guejtjo már cjʉhtzibi cʉ dda döhtji cár nda̱ji̱ ca Jin Gui Jo, cja̱ már xojquibi quí dö cʉ godö rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Diguebbʉ, bi da̱h car Jesús, bi xih cʉ yo hñøjø: ―Ma grí xijmi car Juan digue nʉ xcú cca̱jtiguihui dár øte, hne̱j nʉ xcú dyødehui dár ma̱. Gui xijmi, ya xqui janti yʉ godö, cja̱ yʉ dohua ya xqui dyo. Guejti yʉ döhtji yʉ mí jøxi tsja̱xi gá lepra, ya xí jogui. Guejti yʉ gogu̱, ya xqui øde. Hne̱j yʉ dda ánima yʉ xquí du̱, ya xí nantzi. Cja̱ yʉ tzi probe yʉ jin te i ja̱, ya xí tsjih car tzi ddadyo jña̱ ja ncja drí döti cár nzajqui.― Ncjapʉ gá nda̱h car Jesús, gá mbe̱mbi car Juan digue ca hnar palabra ca i cuati pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cja̱ car Jesús pé bi xih quí jmandadero car Juan: ―Car Tzi Ta ji̱tzi da ndo bendeci car cja̱hni ca da hñemegui göhtjo mbo ʉ́r tzi mʉy, cja̱ jin da jiɛh ca drí hñemegui, guejcö dúr cja̱hni xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bbʉ ya xquí tsjij yʉ palabra‑yʉ, bi ma quí jmandadero car Juan, bbʉ. Diguebbʉ ya, car Jesús bi mʉdi bi ma̱ ja mí ncja car Juan ca mí xix cʉ cja̱hni. Bi hñi̱mbijʉ: ―¿Ja mí ncja ca hnar cja̱hni ca gú ma cca̱htijʉ pʉ jabʉ jin to i hña̱ni? ¿Cja i jñɛjmi cʉ tule cʉ i jua̱n car nda̱ji̱? ¿Cja jí̱ mí pa̱di te di xihquijʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Cja huá gú möjmʉ pa güi cca̱htijʉ hnar hñøjø ca di je quí da̱jtu̱ drá tzi zö? Nu̱jma̱jʉ, cʉ cja̱hni cʉ i je quí da̱jtu̱ rá tzi zö cja̱ i ndo tzijʉ rá zö i bbʉpjʉ pʉ jáy ngu̱ cʉ cja̱hni cʉ i mandado. ");
INSERT INTO otsNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bbʉ jin gui gue yʉ gú ma cca̱htijʉ, ¿ja mí ncja car hñøjø gú ma cca̱htijʉ, bbʉ? ¿Cja jin gúr jmandadero ca Ocja̱ guegue? Ja̱a̱, guehca̱ dí xihquijʉ. Cja̱ pé dí xihquijʉ, más rá ngu̱ cár cargo car Juan nin dra ngue cʉ ddaa quí jmandadero ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","I ju̱x pʉ jar Escritura nʉr jña̱ nʉ i ma̱ ja di ncja ca hnar jmandadero ca di mɛjni car Tzi, Ta ji̱tzi, i̱na̱: Nu̱jma̱ja̱, dí pɛjni nʉm jmandadero da hmɛto, cja̱ nuquɛ gui hmɛfa, Guegue da nzoh cʉ cja̱hni, da xijmʉ, ya xcuá e̱quɛ. Ncjapʉ ga ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cierto dí xihquijʉ, jin tema jmandadero ca Ocja̱ xí ni̱gui hua jar jöy ca di ja̱ cár cargo drá ngu̱ ncja ngu̱ ca i pɛhtzi car Juan. Guejtjo dí xihquijʉ, más drá ndo zö ca da döti cʉ cja̱hnitjo cʉ da nu̱ cár jmandado ca Ocja̱ hua jar jöy, bbʉ ya xtrú cumpli ca Ocja̱ ca xí ma̱. Nucʉ́, masque di cja̱hnitjo cʉ jin te di bbʉh quí cargo, más drá ndo zö ca da dötijʉ ni ndra ngue ca bi döti car Juan.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cʉ cja̱hnitjo co hne̱h cʉ hñøjø cʉ mí cobra cʉ contribución, bbʉ mí dyødejʉ, bi ma̱jmʉ, i̱na̱jʉ: ―Ra ndo zö ca xí dyøti car Tzi Ta ji̱tzi. Bú pɛnquijʉ car Juan, cja̱ guegue‑ca̱ xí nzojcöjʉ. Xí xijquijʉ ca ncjua̱ni‑ca̱.― Cʉ cja̱hni cʉ mí ma̱ ncjanʉ, car Juan xquí xix‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nu cʉ fariseo hne̱h cʉ maestro cʉ mí nxöh car ley ca xquí ma̱n car Moisés, jí̱ mí ne di hñe̱me̱jʉ car Juan, cja̱ jí̱ mí ne di repentijʉ. Cʉ cja̱hni‑cʉ, jin gá nguati car Juan pa di xixtjejʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nubbʉ, bi ma̱n car Tzi Ta Jesús: ―Nuya, gu xihquijʉ ter bɛh ca̱ guí jñɛjmʉ, nuquɛjʉ, guí bbʉpjʉ yʉ pa ya. ");
INSERT INTO otsNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Guí jñɛjmʉ cʉ ba̱jtzi cʉ i ju̱h pʉ jar töy cja̱ i i̱ni. I mahti quí hñohuijʉ, i i̱na̱jʉ: “Xtú jʉxti yʉm tjʉxije, pe nuquɛjʉ jí̱ xquí ne xquí ni̱pjʉ. Cja̱ pé xtú nzonije, xtú i̱ni̱je gá nttögui, hni̱xquiguɛjʉ, jí̱ xquí ne xquí nzonijʉ.” Ncjapʉ ga ma̱n cʉ ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nuquɛjʉ, dí xihquijʉ, guí ncjajʉ ncja ngu̱ cʉ ba̱jtzi‑cʉ́, como jin guí tzøjmʉ yí jmandadero ca Ocja̱ yʉ xpá ngu̱y. Xpá hñe̱h car Juan ca mí xix yʉ cja̱hni. Jin tza te mí tzi, cja̱ jin te mí tzi car vino. Cja̱ nuquɛjʉ, nguí xijtijʉ mí yojmi hnar nda̱ji̱ ca jin gui tzö. ");
INSERT INTO otsNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma ya, pé xtú e̱cö, nugö dúr cja̱hni xpá bbɛnqui hua jar jöy. Dí cuati pʉ jabʉ i mvitagui pa gu tzi, cja̱ dí tzigö göhtjo ca i ttajqui. Pe nuquɛjʉ, pé guí tzanguijʉ hne̱je̱, guí ma̱jmʉ: “Nʉr hñøjø‑nʉ, ʉr ttzodyo cja̱ i ndo tzi vino. Guejtjo i yojmi yʉ jiöjte hñøjø yʉ i cobra contribución, hne̱j yʉ pé dda cja̱hni yʉ i øti ca rá nttzo.” ");
INSERT INTO otsNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dí xihquijʉ, da jogui da jmeya yʉ to xpá ngu̱h car Tzi Ta ji̱tzi masque di ayuna‑yʉ o di pa mbaxcjua. Göhtjo da jmeya, como i pɛhtzi jogui mfe̱ni göhtjo cʉ to rí hñe̱h ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mí bbʉh ca hnar fariseo, mí ju̱ cár tju̱ju̱ múr Simón. Guegue bi mvitabi car Jesús pa di zihui pʉ́r ngu̱. Bi ma car Jesús pʉ jár ngu̱ car fariseo, bbʉ, cja̱ bi mi̱h pʉ jar mexa. ");
INSERT INTO otsNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Diguebbʉ bi zøh hnar bbɛjña̱ múr mi̱ngu̱ pʉ jar jñi̱ni‑cá̱. Nucá̱ múr mañaso bbɛjña̱. Guegue‑ca̱ xquí dyøde, car Jesús már bbʉh pʉ jár ngu̱ car Simón, már tzi pʉ car pa‑ca̱. Eso, bi guati pʉ car bbɛjña̱. Mbá tu̱ hnar xijto már tzi zö, mí po hnar perfume mí yʉni rá tzi ncʉji, cja̱ már ma̱di. ");
INSERT INTO otsNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Car bbɛjña̱ bi guati pʉ jabʉ már ju̱ car Jesús, bi hmöh pʉ hnanguadi guegue, cja̱ bi nzoni. Bi tzox quí guidö pʉ jáy hua car Jesús, cja̱ bi du̱jquibi co ni quí xta̱. Guejtjo bi nda̱nebi quí hua, cja̱ bi xihtzibi car perfume. ");
INSERT INTO otsNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bi cca̱hti‑ca̱ car fariseo ca xquí mvitabi car Jesús, cja̱ bi mbe̱ni ncjahua: “Nʉr hñøjø‑nʉ, bbʉ xtrú mɛjni ca Ocja̱, di pa̱di ja i ncja nʉr bbɛjña̱ nʉ i tjöni, como rá ndo nttzo cár vida.” ");
INSERT INTO otsNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Diguebbʉ, bi ma̱n car Jesús, bi xih car hñøjø: ―Nuquɛ, Simón, dí ne gu xihqui hnar razón.― Cja̱ bi da̱j ya‑cá̱: ―Ma̱nguɛ ya, Maestro.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bi ma̱n car Jesús, bbʉ́: ―Mí bbʉh hnar hñøjø ca mí jmi̱jpite domi, cja̱ pé mí bbʉ yo hñøjø cʉ mí tu̱jpi guegue. Ca hnar hñøjø mí tu̱jpi quiniento domi gá denario. Cja̱ ca hnaa mí tu̱jpi cincuentatjo. ");
INSERT INTO otsNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jin te mí ja̱ cʉ hñøjø‑cʉ pa drí gu̱hti ca mí tu̱hui. Nu ca hnaa ca mí ja̱, bi perdonabi göhtjo cʉ yojo‑cʉ́. Nuya, gui ma̱nguɛ ya, digue cʉ yojo hñøjø, ¿ja̱ ndrá nguehcá̱ más di ma̱h ca hnaá ca xquí jmi̱pi car domi?― ");
INSERT INTO otsNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nubbʉ́, bi da̱h car Simón: ―Dí mbe̱ngö, gue car hñøjø ca más már ngu̱ ca mí tu̱.― Guegue car Jesús bi xifi: ―Cierto, xcú tja̱di rá zö.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Diguebbʉ bi bböti, bi cca̱hti car bbɛjña̱, cja̱ bi xih car Simón: ―¿Cja guí cca̱hti nʉr bbɛjña̱‑nʉ? Dí xihqui, rá zö ca xí dyøjtigui, como i ndo ma̱jqui. Nuquiguɛ, jí̱ xquí ddajqui tzʉ ʉr deje pa gua xʉjqui yʉm hua ca xtá cʉjcua jer ngu̱. Pe guegue‑nʉ, xí xʉjqui yʉm hua co ni quí guidö, cja̱ pé xí ndu̱jqui co ni yí xta̱. ");
INSERT INTO otsNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nuquɛ, jí̱ xquí nda̱negui, pe guegue‑nʉ, desde ca xtá cʉjʉ, jin gui tzöya ca dé ra nda̱neguitjo yʉm huá. ");
INSERT INTO otsNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nuquɛ, jin tema aste xquí xizqui nʉm ña̱, pe nʉr bbɛjña̱‑nʉ, xí xizqui yʉm hua nʉr perfume rá ma̱di. ");
INSERT INTO otsNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Eso, dí xihqui, i ma̱jqui rá ngu̱ nʉr bbɛjña̱‑nʉ, como i pa̱di, már ngu̱ ca mí ndu̱jpite cja̱ nugö dí xifi, ya xí mperdonabi. Pe nʉr cja̱hni nʉ i mperdonabi tchʉtjo, tchʉtjo i ma̱jte hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Cja̱ car Jesús pé bi xih car bbɛjña̱: ―Ya xí mperdonaqui ca rá nttzo ca nguí tu̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Cʉ pé dda cja̱hni cʉ már ju̱jʉ jar mexa bi ma̱ntsjɛjʉ: ―¿Xi nʉr hñøjø, to guegue‑nʉ pa da ma̱, guegue i perdonabi ca rá nttzo ca i øti yʉ cja̱hni?― ");
INSERT INTO otsNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nu car Jesús bi xih car bbɛjña̱: ―Xcú hñe̱me̱gui, eso, ya xí ccʉzqui ca rá nttzo ca nguí tu̱. Nuya, dyo te guí mbe̱ni. Gui ma rá zö ya.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Car Jesús mí dyo, mí visita cʉ jñi̱ni. Má yojmi cʉ doce quí möxte. Mí xih cʉ cja̱hni car tzi ddadyo jña̱. Mí xijmʉ: “Ya xta mʉdi da mandado hua jar jöy ca Ocja̱, ya xta ni̱gui cár jmandado.” ");
INSERT INTO otsNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Guejtjo má pa cʉ dda bbɛjña̱ cʉ xquí dyøtje car Jesús. Guegue‑cʉ́ má̱hmɛto mí hñohui ttzonda̱ji̱ hne̱ mí tzöhui jñini, pe nuya, ya jin te mí cja. Ca hnáa, mí ju̱ cár tju̱ju̱ múr María, cja̱ cár yotju̱ ya, múr Lena. Guegue‑ca̱, bbʉ jí̱ bbe mí ntjɛhui car Jesús, mí hñohui yojto cʉ nda̱ji̱ cʉ jin gui tzö, nu car Jesús bi fongui‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ca pé hnaa ya, múr Juana, múr bbɛjña̱ car Chuza. Nu car Chuza mí pɛhtzi cár cargo jar gobierno, mí pɛjpi car Herodes. Ca pé hnaa ya, múr Susana. Guejtjo már ngu̱jʉ cʉ pé dda bbɛjña̱ cʉ mí föxjʉ car Jesús. Gueguejʉ mí unijʉ car Jesús cja̱ co quí amigo cʉ mí tɛni ca te mí nesta‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Már ndo ngu̱ cʉ cja̱hni cʉ bi jmuntzi. Mír hñe̱jmʉ ja jñini, mbá cuatijʉ jabʉ már bbʉh car Jesús. Cja̱ car Jesús bi xijmʉ hnar tzi bbede gá comparación. Bi ma̱: ");
INSERT INTO otsNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Hnar monttɛy bi bøni du pon cár ttɛy. Má poni, cja̱ bi mfonti cʉ ddaa pʉ jar hñu̱. Bi tjoh cʉ cja̱hni, bi di̱ni, cja̱ guejtjo bi zøh cʉ ttzʉntzʉ, bi za. ");
INSERT INTO otsNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pé dda ttɛy bi jiøh pʉ jabʉ jin tza mí bbon car jöy, como mí ndo cʉ́ pʉ cʉ me̱do rá nojo. Bi bøtze, pe bi dyotitjo, porque jin te mí bbʉh car xajöy. ");
INSERT INTO otsNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Guejtjo bi jiøh cʉ dda ttɛy pʉ jabʉ mí bbon quí ndö cʉ hmi̱ni̱. Bi bøxihui parejo cʉ ttɛy co ni cʉ hmi̱ni̱. Cʉ hmi̱ni̱ ya, bi te, hasta bi gohmi cʉ ttɛy, cja̱ cʉ ttɛy ya, bi go jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Cja̱ pé dda ttɛy bi jiøh pʉ jar jogui jöy. Bi bøtze, bi ndo jogui. Cada hnar tzi ña̱ttɛy ya, mí ndo tu̱ cʉ tzi ttɛy. Hasta cien tzi ttɛy mí tu̱ cʉ ddaa.― Bbʉ mí guaj ya mí ma̱n car bbede‑cá̱, car Jesús, bi ña̱ nzajqui, bi nzoh cʉ cja̱hni cʉ már øde, bi hñi̱mbijʉ: ―Yʉ to i bbʉj yí gu̱, da dyøde te i ne da ma̱n yʉ palabra‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Cja̱ cʉ doce quí möxte car Jesús bi dyöni, bbʉ, bi hñi̱mbijʉ: ―¿Te i ne da ma̱n car bbɛde ca xcú ma̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Cja̱ guegue bi da̱di: ―Nuquɛjʉ, rí ntzöhui gui pa̱dijʉ ja ncja ga mandado ca Ocja̱. Eso, xtá xihquijʉ te i ne da ma̱n yʉ bbede gá comparación. Nu cʉ pé dda cja̱hni, jin gu xijmʉ te i ne da ma̱n yʉ bbede gá comparación. Guegue‑cʉ, bbʉ xta dyøh cʉ dí ma̱, da cjajʉ ncja ngu̱ ga ma̱m pʉ jar Escritura. Masque da cca̱htijʉ cʉ dí øte, pe jin da ba̱dijʉ ja i ncja. Masque da dyødejʉ cʉ dí ma̱ngö, pe jin da ba̱dijʉ te i ne da ma̱. ");
INSERT INTO otsNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nuya, xtá xihquijʉ te i ne da ma̱n nʉr bbede digue cʉ ttɛy. Nʉr ttɛy i jñɛjmi nʉ́r palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nu cʉ ttɛy cʉ xí jiøh hnanguadi car hñu̱ i jñɛjmi cʉ cja̱hni cʉ i øde, pe jin gui e̱me̱. Ba cuati ca Jin Gui Jo, cja̱ i cjʉhtzibi jáy mʉyjʉ car palabra, pa jin da hñe̱me̱, cja̱ jin da mɛhtzi car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Cja̱ cʉ ttɛy cʉ xí jiøh pʉ jabʉ i cʉ́ cʉ me̱do, pʉ jabʉ jin tza i bbon car jöy, i jñɛjmi cʉ cja̱hni cʉ xí dyøde, bi mpöjö gá hñe̱me̱ car palabra, pe jin tza gá hñi̱ti mbo ʉ́r mʉyjʉ. Bi ncjajʉ ncja ngu̱ hnar planta ca jin te i bbʉh quí dyʉ. Cʉ cja̱hni‑cʉ, i e̱me̱ hna tzi tiempotjo, cja̱ bbʉ xta zøh car prueba ya, xta jiɛh bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Guejti cʉ ttɛy cʉ i jøh pʉ jáy ndö cʉ hmi̱ni, i jñɛjmi nʉr cja̱hni nʉ i øde, cja̱ diguebbʉ ya, i mbe̱n cʉ pé dda cosa i ne da jña̱, o i mbe̱n quí asunto i ne da nu̱, o i mbe̱ni te da dyøte pa da mpöh cár tzi mʉy. Eso, jin gui ni̱gui má̱s xtrú dyøh cár palabra ca Ocja̱. I ncjadipʉ cár vida, i bbʉy ncja ngu̱ mír hmʉ má̱hmɛto. ");
INSERT INTO otsNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pe nu cʉ ttɛy cʉ xí jiøh pʉ jar jogui jöy, i jñɛjmi car cja̱hni ca i jon ca Ocja̱ göhtjo mbo ʉ́r mʉy. Gue yʉ cja̱hni yʉ i cuajti car palabra ca xí dyøde, cja̱ i seguetjo, jin gui jɛgui. Guegue‑yʉ i jñɛjmi car ttɛy ca i cʉ́ cár semilla rá ngu̱, como xí ungui í mʉyjʉ, xí hñe̱me̱bijʉ cár tzi palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Bbʉ to i tzøqui hnar tzibi, jin da gohmi, cja̱ jin da jiøh pʉ jöy car gama. Nde̱jma̱ja̱ da hñi̱x pʉ jabʉ rá nte, pʉ jabʉ da ni̱gui, pa drí yoti cʉ to da ñʉti pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Masque xí tta̱h hnar cosa, pe nde̱jma̱ja̱ xta zøh car pá bbʉ xta ni̱gui. Masque xí cjohmitjo hnar cosa, pe nde̱jma̱ja̱ xta fa̱di, xta ccʉjqui jar bbɛxu̱y, cja̱ xta ncca̱hti pʉ jar jiahtzi. Xta fa̱di hne̱je̱ te i ne da ma̱ yʉm palabra yʉ dí xihquijʉ, yʉ jin gui pa̱h cʉ pé dda cja̱hni yʉ pa ya. ");
INSERT INTO otsNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eso, dí xihquijʉ, gui dyødejʉ rá zö yʉ palabra yʉ dí xihquijʉ. Ca to i tzi pa̱di, más drá ngu̱ da ttu̱jti. Cja̱ nu ca jin tza te i pa̱di, hasta da bbɛh ca tchʉ ca i ma̱ i pa̱di.― Ncjapʉ gá xijmʉ quí möxte car Jesús. Ncjapʉ gá xijmʉ quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Diguebbʉ bi zøh cár me co quí cjua̱da̱ car Jesús, gá hñe̱jmʉ pʉ jabʉ már bbʉ guegue. Pe jí̱ mí tzö di ntjɛjʉ car Jesús, como már ndo dʉ cʉ cja̱hni már bbʉh pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Cja̱ bi tsjih car Jesús, bi tti̱mbi ncjahua: ―Quer me co quir cjua̱da̱, ya xpí bböh pʉ tji, i ne da cca̱jtiqui.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Guegue ya bi da̱di, bi ma̱: ―Yʉ cja̱hni yʉ xí dyøj nʉ́r palabra ca Ocja̱ cja̱ i øtijʉ ncja ngu̱ ga ma̱, guejyʉ́ dí cca̱htigö ncjahmʉ dʉm megö‑yʉ o dʉm cjua̱da̱gö‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ca pé hnar pa, car Jesús bi dex car barco co ni cʉ doce quí moxte cʉ mí ntzixihui. Bi xijmʉ: ―Möjö, dá ddaxjʉ nʉ hnanguadi nʉr mar.― Cja̱ bi ddaxjʉ bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cja̱ menta má pöjmʉ, bi a̱h car Jesús. Cja̱ bi ndo hño hnar ndo nda̱ji̱ jar mar, bi ndo dɛjni car deje. Ya xi mí ne di ñu̱xi deje car barco. ");
INSERT INTO otsNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bbʉ mí nu̱jʉ quí amigo car Jesús te mí ncja, bi nzojmʉ car Jesús, bi hñi̱mbijʉ: ―Nuquɛ maestro, ya xqui ne da ñʉj nʉr barco. Ya xtá cjá̱tije deje.― Nubbʉ́, bi zö car Jesús, cja̱ bi huɛnti car nda̱ji co car deje, cja̱ bi tzöya ca mír mföhtzi car deje. ");
INSERT INTO otsNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Cja̱ guegue bi dyön‑cʉ́: ―¿Dyoca̱ jí̱ xcú hñe̱me̱jʉ ca Ocja̱?― Nu gueguejʉ bi ndo ntzu̱jʉ cja̱ bi ndo hño í mʉyjʉ. Bi hñöntsjɛjʉ: ―¿To nʉr hñøjø‑nʉ́? Hasta nʉr nda̱ji̱ cja̱ co nʉr deje, xí nzoj‑nʉ cja̱ nuyʉ́ xí dyøjti‑yʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Car Jesús co quí möxte bi zøjmʉ jar jöy ca mí tsjifi Gadara, ca hnanguadi car deje, mír jñantihui car estado Galilea. ");
INSERT INTO otsNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bi ga̱jmʉ jar barco, bi hñojʉ jar jöy. Cja̱ bú hna e̱h hnar hñøjø, bi ntjɛhui car Jesús co quí möxte. Múr mi̱ngu̱ car hñøjø pʉ jar jñi̱ni Gadara. Ya xquí ndo cja tiempo xquí yojmi ttzonda̱ji̱. Jin te mí je í da̱jtu̱, cja̱ jin te mí bbʉ ʉ́r ngu̱. Jøntjo mí cuatitjojo pʉ já tzi ni̱cja̱ pʉ jabʉ mí cjöti cʉ ánima. ");
INSERT INTO otsNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Car hñøjø‑cá̱, bbʉ mí jianti car Jesús, bi ndo mafi nzajqui. Bi nda̱ndiña̱jmu̱ jáy hua car Jesús, cja̱ bi ndo majtsjɛ, bi xifi: ―Xi ya, ¿te guí mbe̱ni gui cjaguigö ya, Jesús, ʉ́r ttʉqui ca Ocja̱ ca bí bbʉ ji̱tzi? Dí ttzi̱nqui, jin gui ma gui ʉngui.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Bi ma̱ ncjanʉ car hñøjø‑ca, como car Jesús xquí bbɛjpi car ttzonda̱ji̱ di bøni, di zoh car hñøjø. Ya xquí ndo cja tiempo xquí yojmi car ttzonda̱ji̱. Masque mí hnu̱htibi cadena quí dyɛ co quí hua car hñøjø‑ca̱, pe mí wajquitjojo‑cʉ́. Car demonio mí tzitzi mír ma pʉ jabʉ jin to mí hña̱ni. ");
INSERT INTO otsNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nubbʉ́, car Jesús bi dyöni, i̱mbi: ―¿Te gúr ju̱?― Guegue bi da̱di: ―Dúr Ejército.― Bi ma̱ ncjapʉ porque ntero cár ttzɛdi ca Jin Gui Jo xquí ñʉti mbo ʉ́r mʉy guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Cʉ ttzonda̱ji̱‑cʉ, bi ttzi̱n car Jesús, pa jin di gu̱pjʉ pʉ jabʉ jin gui tzö. ");
INSERT INTO otsNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Már ndo ngu̱ cʉ zacjua má dyo nʉ rá cjanʉ jar ttøø. Quí nda̱ji̱ ca Jin Gui Tzö bi ndo ttzi̱n car Jesús pa di ungui ʉr tsjɛjqui di ma drí zʉh‑cʉ cja̱ drí yojmʉ. Cja̱ bi uni ʉr tsjɛjqui, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nubbʉ, cʉ ttzonda̱ji̱ bi wembijʉ car hñøjø, bi ma gá ma pʉ jabʉ már ca̱ cʉ zacjua, bi guatijʉ, cja̱ bi ñʉtijʉ mbo í mʉy‑cʉ́. Cʉ zacjua ya, bi gʉjʉ ʉr ddiji gá nga̱jmʉ, gá jiøjʉ jar deje, bú cjá̱tijʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nubbʉ, cʉ to már föh cʉ zacjua, bbʉ mí cca̱htijʉ te xquí ncja, bi ddaguijʉ, bi ma bú ngöxtejʉ jar jñi̱ni. Guejtjo bi xijmʉ cʉ cja̱hni cʉ mí bbʉ já rancho, cʉ mí cerca pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nu cʉ cja̱hni ya bbʉ, bú pøjmʉ guá hñe̱jmʉ jabʉ már bbʉh car Jesús. Bi dötijʉ car hñøjø, már ju̱h pʉ hnanguadi car Jesús, ya xi mí je í da̱jtu̱, cja̱ ya xcuí goh cár mfe̱ni. Bi cca̱htijʉ ya‑ca̱ bbʉ, cja̱ bi ndo ntzu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Diguebbʉ, cʉ cja̱hni cʉ xquí jianti te xquí ncja, bi xih cʉ ddáa cʉ cja mbá tzøjmʉ, bi xijmʉ ja ncja xquí mfongui cʉ ttzonda̱ji̱ cʉ mí yojma̱hui car hñøjø‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Cja̱ diguebbʉ ya, cʉ mi̱ngu̱ car jñi̱ni Gadara co cʉ pé dda jñi̱ni cʉ mí bbʉ cerca pʉ, bi xijmʉ car Jesús di wen tzʉ pʉ, di ma, como mí ndo ntzu̱jʉ. Nubbʉ, car Jesús bi dex car barco, bi möjmʉ quí möxte, pe gá ngojmʉ pʉ jabʉ xcuí hñe̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nu car hñøjø ca xquí zö, bbʉ ya xquí wen cʉ ttzonda̱ji̱, bi dyöjpi favor car Jesús pa di jiɛgui di dɛni. Pe guegue‑ca̱, jin gá ne gá uni ʉr tsjɛjqui. Bi xih car hñøjø: ");
INSERT INTO otsNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ji̱na̱, gui ma ya, grí coj jer ngu̱. Gui ngöxte pʉ, ja xcá dyøtjequi ca Ocja̱, como rá ndo zö ca xí cjahqui.― Nu car hñøjø bi ma ya, bbʉ, bi ngöxte jar jñi̱ni ja ncja gá zö. Bi xih quí mi̱ngu̱jʉ, már ndo zö ca xquí dyøhtibi car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nu car Jesús, bbʉ mí zøti pʉ jabʉ xcuí hñe̱je̱, ya xi már tøhmitjo cʉ cja̱hni rá ngu̱. Cja̱ nucʉ́, bi ndo mpöjmʉ gá jiantijʉ, ya pé xqui zø guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Diguebbʉ bi guati hnar hñøjø, mí tsjifi múr Jairo, mí mandado pʉ jár ni̱cja̱ cʉ judio. Bi nda̱ndiña̱jmu̱ pʉ jabʉ már bböh car Jesús. Bi dyöjpi di ma tzʉ pʉ jár ngu̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mí jñi̱n cár tti̱xu̱, cja̱ mí jøña̱‑cá̱, mí pɛhtzi doce año. Ya xi már cömbe̱ni. Menta mír ma pʉ car Jesús, bi dɛn cʉ cja̱hni már ndo ngu̱, hasta má ndo ttzi̱htzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Guejtjo má tɛni pʉ hnar bbɛjña̱, mí xoti cji. Ya xquí cja como doce año xquí tzöhui car jñini‑ca̱. Ya xquí ndo bböti já médico, xquí ndo gasto ca mí pɛhtzi, hni̱, jin te mí øjte. ");
INSERT INTO otsNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Guegue‑ca̱ hne̱je̱ bi dɛngui ʉ́r xʉtja car Jesús, cja̱ bi zɛtibi cár nttzani cár da̱jtu̱. Nguetica̱, bbʉ, bi hmöh cár cji. ");
INSERT INTO otsNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Cja̱ ya car Jesús bi ma̱: ―¿Toca̱ xí ndöngui?― Cja̱ göhtjo cʉ cja̱hni cʉ már bbʉ cerca bi ma̱jmʉ, “Jí̱ xtá tjö́nquije.” Diguebbʉ ya bi ma̱n car Pedro, co ni cʉ ddaa cʉ már bböpjʉ pʉ: ―Nuquɛ, maestro, cca̱htijma̱, i ndo dʉ hua yʉ cja̱hni rá ngu̱, hasta i ttzi̱zqui, cja̱ nuquɛ, guí önguije: “¿Toca̱ xí ndöngui?”― ");
INSERT INTO otsNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pe car Jesús bi ma̱: ―Nde̱jma̱ja̱, dí pa̱di, cierto xí ndöngui hnar cja̱hni, porque xtú tzö ca xtá jojqui hnar döhtji co ni cam ttzɛdi.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Diguebbʉ, bi nu̱ car bbɛjña̱, ya xi mí pa̱h car Jesús, guegue xquí dömbi cár da̱jtu̱. Nubbʉ, bi guati pʉ jabʉ már bböh car Jesús, bi nda̱ndiña̱jmu̱ pʉ jáy hua. Mí ndo ntzu̱, hasta már jua̱. Masque már øjmʉ göhtjo cʉ cja̱hni te már ma̱ guegue, car bbɛjña̱ bi ncjua̱ni ja gá zö bbʉ mí zɛtibi quí da̱jtu̱ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nuya car Jesús bi xifi: ―Nuquɛ, na̱na̱, guehca̱ xquí hñemegui, eso xcú zö. Nuya, gui ma rá zö ya.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Menta már ña̱di car Jesús, bi zøh hnar jmandadero, güí hñe̱h pʉ́ jár ngu̱ car Jairo, tzʉdi, car hñøjø ca mí mandado pʉ jár ni̱cja̱ cʉ judio. Bi ma̱n car jmandadero, bi xih car Jairo: ―Ya xí ndu̱ quer tti̱xu̱. Ya jin gui nesta gui tzix nʉr Maestro.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nu car Jesús bi dyøde cja̱ bi xih car Jairo: ―Dyo guí ntzu̱. Gui hñe̱me̱tjojo, xta zö‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bi mɛhui bbʉ́, bi ñʉti pʉ́r ngu̱ car Jairo. Pe jin gá jiɛgui di ñʉti göhtjo cʉ cja̱hni cʉ má tɛni, jøña̱ car Pedro hne̱h car Jacobo co car Juan, guejti cár ta, co cár me car ba̱jtzi bbɛjña̱tjo. ");
INSERT INTO otsNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Cʉ cja̱hni cʉ xquí jmu̱ntzi pʉ, már ndo zonijʉ, como mí ndo jui̱jquijʉ car ba̱jtzi ca ya xquí du̱. Pe guegue car Jesús bi ma̱: ―Dyo guí zonijʉ. Jin gui tu̱ nʉr ba̱jtzi. Xí a̱tjo.― Bi ma̱ ncjapʉ car Jesús, como guegue ya xti cjajpi di jña̱ ʉ́r jña̱. ");
INSERT INTO otsNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nu cʉ pé dda cja̱hni jin gá mba̱dijʉ te mí ne di ma̱. Eso, bi dendijʉ, como mí pa̱dijʉ, ya xquí du̱ car ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nu car Jesús bi pɛntibi cár dyɛ car ba̱jtzi bbɛjña̱ cja̱ bi nzofo, i̱mbi: ―Nuquɛ chju̱, bböj ya.― ");
INSERT INTO otsNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Diguebbʉ, cár tzi mʉy bú coji, cja̱ nguetica̱ bi bböh car ba̱jtzi. Car Jesús bi mandado di ttu̱ni te di zi. ");
INSERT INTO otsNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nuya, cár ta ya, co cár me, bi ndo hño í mʉyhui cja̱ bi ndo mpöjmi ca gá zö cár ba̱jtzihui. Nu car Jesús bi xijmi jin to di göxihui‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Diguebbʉ ya, car Jesús bi jmuntzi cʉ doce quí möxte cʉ xquí hñi̱tzi gá apóstole, cja̱ bi un cár cargojʉ pa di fongui göhtjo tema ttzonda̱ji̱ cja̱ di gʉhtzi göhtjo tema jñi̱ni. ");
INSERT INTO otsNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bi gu̱pjʉ pa di nzojmʉ cʉ cja̱hni, di xijmʉ, ya xti ni̱gui hua jar jöy ca mír mandado ca Ocja̱. Bi u̱jti cár bbɛfijʉ, ja drí gʉhtzibi quí jñi̱ni cʉ döhtji. ");
INSERT INTO otsNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bi xijmʉ, i̱na̱: ―Bbʉ xtí möjmʉ jar hñu̱, jin te gui jña̱xjʉ, ni di hnar tøjø, ni di hnar ddøza̱ pa gui dyʉtijʉ pʉ ca te da ttahquijʉ, ni dur tju̱jme̱, ni mpa ʉr domi, ni mpa gui ca̱xjʉ yojo quir mangajʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Car ngu̱ pʉ jabʉ gui cuatijʉ, gui hmʉjtijʉ pʉ, hasta gue bbʉ xquí pønijʉ car jñi̱ni‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Cja̱ pé dí xihquijʉ, bbʉ gui cʉtijʉ hnar jñi̱ni, cja̱ jin da jnequijʉ pʉ, gui pønijʉ car jñi̱ni‑cá̱, gui jøjmijʉ cʉ jöy i tu̱ quir huajʉ, pa da ba̱h cʉ mi̱ngu̱, ya jim pé grí cojmʉ pʉ, como jin gá dyøh ca gú xijmʉ, cja̱ jin gá nequijʉ.― Ncjapʉ gá xih quí möxte car Jesús, cʉ xquí hñi̱tzi gá apóstole. ");
INSERT INTO otsNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bi bøn cʉ apóstole, bi ma, bbʉ́. Bi tjojmʉ göhtjo cʉ jñi̱ni pʉ jar jöy‑cá̱, bi xijmʉ cʉ cja̱hni car tzi ddadyo jña̱ ca xquí ma̱n car Jesús. Guejtjo bi dyøtjejʉ cʉ döhtji, göhtjo pʉ jabʉ mí tzøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Car rey Herodes bi dyøde göhtjo ca mí øti car Jesús. Nubbʉ, bi ndo hño ʉ́r mʉy, cja̱ bi hñöntsjɛ: “¿To car cja̱hni i dyo ya, i øti milagro?” Mí yomfe̱ni car Herodes, como mí bbʉh cʉ dda cja̱hni cʉ mí ma̱jmʉ: “Gue car Juan ca mí xix yʉ cja̱hni cja̱ bi bböhti. Nuya, pé xí nantzitjo, ya pé xqui dyo.” ");
INSERT INTO otsNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mí bbʉh cʉ pé dda cja̱hni cʉ mí ma̱jmʉ, ya pé xquí ni̱gui car profeta Elías, ya pé xi mí dyo hua jar jöy. Cja̱ pé ddaa ya, mí ma̱jmʉ, car Jesús múr profetatjo, mí hnáa digue quí jmandadero ca Ocja̱ cʉ xquí du̱ ya má yabbʉ, cja̱ nuya, pé xquí nantzi, pé mí dyo mí øti milagro. ");
INSERT INTO otsNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nu car Herodes bi ma̱: ―Sá dú jɛjquibi cár dyʉga car Juan. Xi ya, ¿to ya ca̱ pé xqui dyo, i ndo øti milagro rá nzɛdi, cja̱ göhtjo yʉ cja̱hni i ma̱jmʉ te tza rá nzɛ guegue?― Eso, car Herodes mí jon car manera ja ncja drí cca̱hti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bbʉ ya xquí goh cʉ doce quí möxte car Jesús, gueguejʉ bi xijmʉ car Jesús göhtjo ca xquí dyøtijʉ pʉ jabʉ xcuí zøtijʉ. Diguebbʉ bi möjmʉ car Jesús gá möjmʉ hnanguadi, pʉ jabʉ jin to mí hña̱ni. Bi möjmʉ jár nttza̱ni car jñi̱ni ca mí tsjifi Betsaida. ");
INSERT INTO otsNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nuya, bbʉ mí ba̱h cʉ cja̱hni jabʉ mír ma car Jesús, bi dɛnijʉ. Nu car Jesús bi nzojmʉ cor tti̱jqui, cja̱ diguebbʉ bi u̱jtijʉ, bi xijmʉ ja ncja ga mandado ca Ocja̱. Guejtjo bi jojqui cʉ cja̱hni cʉ mí jñi̱ni. ");
INSERT INTO otsNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bbʉ ya xquí nde, nubbʉ, bi guati cʉ doce quí apóstole, bi xijmʉ car Jesús di gu̱h cʉ cja̱hni drí möjmʉ cʉ tzi jñi̱ni cʉ mí bbʉh pʉ cerca, pa di dötijʉ te di zijʉ cja̱ di oxijʉ pʉ. Bi ma̱jmʉ: ―Nuhua jabʉ dí bbʉpjʉ, jin te i bbʉ ngu̱, cja̱ jin te i bbʉy pa te da zi yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nu car Jesús ya, bi xih quí möxte: ―Nuquɛjʉ, gui unijʉ ca da zi‑yʉ́.― Pe guegue‑cʉ́ bi da̱di: ―Jin te dí pɛhtzije, jøntsjɛtjo cʉtta yʉ tzi tju̱jme̱ cja̱ yo möy. Sólo bbʉ gu ma töjme ca da zi göhtjo‑yʉ́. ¿Pe jabʉ da ni̱gui‑cá̱, como rá ndo ngu̱‑yʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bi ma̱jmʉ ncjapʉ, como jabʉ mí zøti cʉtta mil cʉ hñøjø cʉ már bbʉh pʉ. Diguebbʉ, car Jesús bi xih cʉ doce quí möxte: ―Gui xijmʉ yʉ cja̱hni da mi̱pjʉ jöy. Da jmu̱ntzijʉ gá tzi jmundo, cincuenta cja̱hni cada hnar tzi jmundo, cja̱ da mi̱pjʉ jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bi dyøtijʉ ncjapʉ, bbʉ. Göhtjo cʉ cja̱hni bi mi̱pjʉ gá grupo. ");
INSERT INTO otsNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nubbʉ, car Jesús bi gʉ́ cʉ cʉtta tju̱jme̱, cja̱ co cʉ yojo möy. Bi nøhtza ji̱tzi, bi dyöjpi cár ncja̱jpi‑cʉ́, cja̱ bi jejque, bi un cʉ doce quí möxte pa di wi̱n cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bi zijʉ göhtjo cʉ cja̱hni, bi niña̱jʉ, hasta bi sobratjo doce canista cʉ tzi pɛdazo. ");
INSERT INTO otsNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Diguebbʉ ya, car Jesús bi ma gá ma hnanguadi co quí möxte, cja̱ guegue bi nzoh ca Ocja̱. Bbʉ mí guaj ya, car Jesús bi dyön quí möxte, i̱mbijʉ: ―¿Te i ma̱n yʉ cja̱hni? ¿Cja i pa̱dijʉ toguigö?― ");
INSERT INTO otsNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gueguejʉ bi da̱dijʉ, i̱na̱: ―I ma̱jmʉ guehquiguɛ, gúr Juan ca mí xix yʉ cja̱hni. Cʉ pé ddaa i ma̱jmʉ guehquiguɛ gúr profeta Elías, pé xcú cojti hua jar jöy. Hne̱h cʉ pé ddaa i ma̱, guehquiguɛ gúr jmandadero ca Ocja̱, hnáa digue cʉ mí bbʉy ya má yabbʉ, cja̱ pé xcú jña̱ ir jña̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nubbʉ́, car Jesús bi dyön‑cʉ́, i̱na̱: ―Xiquɛjʉ, ¿te guí mbe̱nijʉ bbʉ́?― Bi da̱h car Pedro bbʉ, i̱na̱: ―Guehquiguɛ gúr Cristo, xí hñi̱xqui car Tzi Ta ji̱tzi, cja̱ guegue‑ca̱ xpá ngu̱hqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Car Jesús, bbʉ, bi ccax quí möxte pa jin di ngöxtejʉ to guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Diguebbʉ, pé bi xijmʉ: ―Guejcö dúr cja̱hni xpá bbɛnqui hua jar jöy, cja̱ i nesta gu ndo sufri. Nu cʉ tita co cʉ maestro cʉ i nxöh car ley, cja̱ co cʉ möcja̱ cʉ i mandado, jin da hñeme‑cʉ, ¿cja guejquigö xpá mɛnqui car Tzi Ta ji̱tzi? Da ndo ʉgui‑cʉ, hasta da möjtigui. Pe nugö, pé gu nantzi bbʉ xtrí zʉh cʉ jñu̱jpa.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma ya, car Jesús bi nzoh cʉ cja̱hni, göhtjo cʉ mí ne di dɛnijʉ, bi xijmʉ: ―Ca to i ne da dɛngui, i nesta cada mpa da jiɛh ca i netsjɛ guegue, da dyɛmbi ʉ́r mʉy pa da sufri, ncjahmʉ i bbʉy pa da du̱ por rá nguejquigö. Da ncjapʉ drí dɛnguigö. ");
INSERT INTO otsNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Porque jin da jogui da dɛnguigö cʉ cja̱hni cʉ i ne da möjtsjɛ quí vida. Cʉ cja̱hni‑cʉ da bbɛh quí nzajqui‑cʉ. Nu car cja̱hni ca da dɛnguigö, masque xín da bbɛh cár nzajqui por rá nguejquigö, da mɛhtzitjo car nzajqui ca ntju̱mʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Te da provechabi hnar cja̱hni bbʉ da cjajpi ʉ́r mɛjti göhtjo yʉ cosa rá zö yʉ i bbʉjcua jar jöy, pe jin da zøm pʉ jabʉ bí bbʉh ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cʉ cja̱hni cʉ i pɛhtzi í tzöjʉ pa drí dɛngui cja̱ pa drí hñeme cam palabra, jin gʉm cja̱hnigö‑cʉ. Car pa ca xcuá coji pa gu mandado hua jar jöy, gu ma̱ngö, jin te ʉm ncjagöbbe cʉ cja̱hni‑cʉ. Nubbʉ, xcuá yojme cʉ ángele rá ngu̱ cʉ i pɛjpi cam Tzi Ta ji̱tzi. Da ndo yoti cár tjayjʉ cja̱ co cár tjay cam Tzi Ta. Nubbʉ, da ni̱gui te tza dúr nda̱gö, cja̱ te tza rá ngu̱ cam cargo. ");
INSERT INTO otsNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cja̱ dí xihquijʉ, i bbʉjcua yʉ dda cja̱hni yʉ jin da du̱ hasta gue bbʉ ya xtrú cca̱hti cár jmandado ca Ocja̱, bbʉ xta ni̱gui hua jar jöy.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bbʉ ya xquí tjoh cʉ jña̱jto mpa xquí ma̱n yʉ palabra‑yʉ, car Jesús bi zix car Pedro co car Juan co car Jacobo, gá mbøxjʉ hnar ttøø, cja̱ nupʉ, car Jesús bú nzoh cár Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bbʉ már nzoh cár Tzi Ta, bi ni̱gui hnahño cár cara, cja̱ cár da̱jtu̱, masque már nttaxi, más bi ndo nttaxqui, sta mí juɛtzi. Bi ti̱ti quí döjʉ cʉ bi cca̱hti. ");
INSERT INTO otsNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Cja̱ bi hna ni̱guitjo pʉ yojo hñøjø, már ña̱hui car Jesús. Ca hnaa, múr tita Moisés, cja̱ ca pé hnaa, múr tita Elías. Nucʉ xcuí hñe̱ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Guejti‑cʉ mí juɛx quí da̱jtu̱hui cja̱ már tzi zö mír ni̱guihui. Cʉ yojo cʉ xcuí hñe̱ ji̱tzi cja̱ co car Jesús már ña̱jʉ, ja ncja di du̱ car Jesús pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nu car Pedro co car Juan cja̱ co car Jacobo, mí ndo cohmijʉ car tta̱ja̱, pe bi tji̱htzijʉ, bi zödijʉ cja̱ bi cca̱htijʉ mí ndo juɛx car Tzi Ta Jesús. Ncjahmʉ mí yoti cár tjay. Cja̱ guejtjo bi cca̱htijʉ cʉ yojo hñøjø cʉ már ña̱hui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cja̱ bbʉ ya xi mír ma di wem pʉ car Moisés cja̱ co car Elías, car Pedro bi xih car Jesús, bi hñi̱mbi: ―Nuquɛ, Maestro, rá zö dar hmʉpjʉ hua. Gu øtijʉ jñu̱ tzi ngu̱ gá dyɛza, ca hnaa pa guehquɛ, ca pé hnaa pa gue car Moisés, cja̱ guejti pé hnaa pa gue car Elías.― Car Pedro bi hna ma̱ ncjapʉ, pe jin tza gá mbe̱ni ter bɛh ca̱ már ma̱. ");
INSERT INTO otsNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Már ña̱di guegue cja̱ bú hna ca̱h hnar gu̱y, bi gohmijʉ, hasta bi zu̱ cʉ jñu̱ quí amigo car Jesús gá ñʉtijʉ jar gu̱y. ");
INSERT INTO otsNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Cja̱ bi hna ttøh hnar jña̱, már ña̱ pʉ mbo car gu̱y, már ma̱: ―Gue nʉm ttʉ‑nʉ, dí ma̱di. Gui dyødejʉ ca i ma̱‑nʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bbʉ mí tzöya car jña̱ ya, bi cca̱htijʉ cʉ jñu̱ quí möxte, ya xi már ddatsjɛ car Jesús. Cja̱ guegue‑cʉ bi ndo mbe̱nijʉ ca xquí cca̱htijʉ, pe jin to gá ngöxjʉ cʉ pa‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ca xtrá yojpa ya, bbʉ ya xi mír ga̱pjʉ jar ttøø, bú tja̱dijʉ hnar ndo jmundo cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hnar hñøjø ca már yojmi cʉ cja̱hni rá ngu̱ bi nzoh car Jesús, bi mahti nzajqui, bi hñi̱mbi: ―Nuquɛ, Maestro, dí öhqui hnar favor, gui cca̱hti tzʉ cam ttʉ, jøña̱‑ca̱ dí hñi̱h‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","I yojmi hnar ttzonda̱ji̱. Cada bbʉ ga nzʉdi, i ndo mah car ba̱jtzi, cja̱ i jua̱htzi nzajqui, hasta i cjajpi i fʉh cár ne. Jin gui ne da jiɛgui da hmʉy rá zö. Cada bbʉ ga dyenti, i pʉhmi nzajqui cár cuerpo, cja̱ i ndo mbʉntzi jar jöy, sta ngu̱ da nxɛni. ");
INSERT INTO otsNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xtú xij yir amigo yʉ i tɛnqui di fonguijʉ tzʉ‑ca̱, hni̱, jin gá jiöti di fonguijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nuya car Jesús bi da̱di, bi hñi̱mbijʉ: ―Nuquɛjʉ, guí mɛgui cja̱hnijʉ, jin guí e̱me̱jʉ ca Ocja̱. Ya xná ngu̱ mpa xtú hmʉpjʉ, cja̱ xtú nzohquijʉ. Hasta ya xtú ʉxi ʉm mʉy, como jin guí nejʉ gui hñe̱me̱guijʉ.― Diguebbʉ bi nzoh car hñøjø, bi xifi: ―Bú tzí hua quer ttʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nubbʉ, menta má cuati car tzi hñøjø, pé bi zʉh cár nda̱ji̱ ca Jin Gui Jo, bi dyenti, bi jua̱htzi nzajqui. Cja̱ bi mbʉntzi jar jöy car ba̱jtzi. Nu car Jesús bi huɛnti cár nda̱ji̱ ca Jin Gui Jo, cja̱ bi dyøtje car ba̱jtzi. Diguebbʉ ya, bi hñi̱hti cár ta. ");
INSERT INTO otsNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nu cʉ cja̱hni, bbʉ mí cca̱htijʉ ter bɛh ca̱ xquí ncja, göhtjo bi ndo zu̱jʉ, como bi ba̱dijʉ, car Jesús mí ndo yojmi cár ttzɛdi ca Ocja̱. Már mbe̱ndi cʉ cja̱hni cʉ milagro rá ngu̱ cʉ mí øti car Jesús, már ndo dyodi í mʉyjʉ. Nu guegue bi xih quí möxte cʉ mí yojmi, bi hñi̱mbijʉ: ");
INSERT INTO otsNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Gui dyødejʉ rá zö ya palabra‑ya. Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy, pe nde̱jma̱ja̱ i bbʉh cʉ to da döguigö jáy dyɛ cʉ cja̱hni cʉm contra.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nu quí möxte car Jesús jí̱ mí pa̱dijʉ te mí ne di ma̱n cʉ palabra‑cʉ. Ncjahmʉ mí bbʉh ca te mí ccahtzijʉ pa jin di ntiendejʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Diguebbʉ ya, quí möxte car Jesús bi mʉdi bi hñɛxijʉ, már ma̱jmʉ toca̱ más di ndo tti̱htzibi. ");
INSERT INTO otsNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nu car Jesús bi ba̱di te már mbe̱ni mbo ʉ́r mʉyjʉ. Eso, bú tzí pʉ hnar tzi ba̱jtzi, ");
INSERT INTO otsNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","cja̱ bi xih quí möxte: ―Ca to da dɛngui cja̱ da mbe̱n yʉm palabra yʉ dí ma̱, bbʉ da cuajti hnar tzi ba̱jtzi ncja‑na̱, da mötzi, ncjahmʉ guejquigö i cuajtigui cja̱ i föxqui. Cja̱ bbʉ to da cuajtigui, ncjahmʉ gue cam Tzi Ta ca bú pɛnqui i cuajti hne̱je̱. Car cja̱hni ca jin da hñi̱xtsjɛ, pe da ncjá ncja ngu̱ na̱r tzi ba̱jtzi‑na̱, guegue‑ca̱ más da ndo tti̱htzibi.― Bi ma̱n yʉ palabra‑yʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nuya bbʉ, bi ma̱n car Juan, bi xih car Jesús: ―Nuquiguɛ, Maestro, xtú cca̱htije hnar hñøjø, már nøn quer tju̱ju̱guɛ, már fongui ttzonda̱ji̱. Nugöje, dú ccahtzije, porque jin gui tɛnguijʉ‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pe car Jesús bi xifi: ―¿Dyoca̱ gú ccahtzijʉ‑ca̱? Car cja̱hni ca jin gui contragui, nuca̱ i föxqui‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bbʉ ya xti zʉh car tiempo pa di ttzitzi drí ma ji̱tzi, car Jesús bi dyɛmbi ʉ́r mʉy di ma Jerusalén, masque ya xi mí pa̱di te di ncjajpi pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Cja̱ bbʉ mí bøn car Jesús, bi bbɛhto dda quí möxte di ma pʉ hnar tzi jñi̱ni pʉ jar jöy Samaria. Eso, bi hmɛto guegue‑cʉ pa di ma drí jioni jabʉ di dyopjʉ bbʉ xti zøti pʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nu cʉ mi̱ngu̱ pʉ, jin gá ne gá unijʉ ʉr tsjɛjqui, como bi ba̱dijʉ, car Jesús cja̱ co quí möxte mí israelitajʉ, mír möjmʉ Jerusalén pa drí xöjtibijʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bi nu̱ ya car Jacobo co car Juan ja nguá mbe̱n cʉ cja̱hni‑cʉ, cja̱ gueguehui bi xih car Tzi Tada Jesús: ―Nuquɛ, Tzi Jmu̱, ¿cja jin guí ne gu mandadoje hnar tzibi drí hñe̱h pʉ ji̱tzi pa da möhti yʉ cja̱hni‑yʉ, ncja ngu̱ gá dyøti car Elías?― ");
INSERT INTO otsNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Guegue ya bi bböti, bi huɛnti‑cʉ́, bi xijmi: ―Nuquɛhui, jin guí pa̱dihui ja ncja dra mbe̱ngö, masque guí ne gui tɛnguihui. Porque nugö dúr cja̱hni xtú e̱cua jar jöy pa gu föx yʉ cja̱hni cja̱ pa gu cjʉhtzibijʉ ca rá nttzo ca i tu̱jʉ. Jí̱ xtá e̱jcö pa gu cjajpi yʉ cja̱hni da du̱.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Diguebbʉ pé gá möjmʉ pé hnar tzi jñi̱ni, bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bbʉ má dyodijʉ, bi guati car Jesús ca hnar hñøjø, bi xifi: ―Nuquɛ, Tzi Jmu̱, xtá tɛnqui göhtjo pʉ jabʉ gui ma.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Car Jesús bi da̱di: ―Cʉ zorra i pɛhtzi quí ojqui pʉ jabʉ i bbʉpjʉ. Cʉ ttzʉntzʉ i pɛhtzi quí ttoxi. Nugö masque dúr cja̱hni xpá bbɛnqui hua jar jöy, pe jin te i bbʉh cam ngu̱ pʉ jabʉ gu tzöya.― Ncjapʉ gá ma̱n car Jesús, ca to i mbe̱ni da dɛni guegue, da ntzohmi, ¿cja ntju̱mʉy i ne da dɛni? ");
INSERT INTO otsNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Diguebbʉ ya car Jesús pé bi ntjɛhui hnar hñøjø, bi nzofo, bi hñi̱mbi: ―Nuquɛ, gui tɛnguigö ya.― Nucá̱ bi da̱di: ―Nuquɛ, Tzi Jmu̱, ddajqui tzʉ ʉr tsjɛjqui bbɛto gu ma öh cam ta.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Car Jesús bi xifi: ―Jiɛh cʉ cja̱hni cʉ jin gui e̱me̱gui da dyöh quí ánimajʉ. Pe nuquɛ, gui maguɛ ya, bú tʉngui car jña̱, ya xí ni̱gui hua jar jöy já ncja ga mandado ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nubbʉ, pé hnar hñøjø guejtjo bi xih car Jesús: ―Guejquitjogö, Tzi Jmu̱, dí ne gu tɛnquigö hne̱je̱. Jøña̱tjo dí ne bbɛto gu má hmʉbbe tzʉ cam familia cʉ rá bbʉh pʉm ngu̱, cja̱ diguebbʉ ya, xcuá hñi̱di, xcuá e̱je̱ gu tɛnqui.― ");
INSERT INTO otsNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nu car Jesús bi xih‑ca̱: ―Hnar hua̱ji̱, bbʉ xta pɛnti car ttabi, i nesta da jianti delante, jabʉ rí ma car yunda. Porque bbʉ da bböti drí jani xʉtja, jin da bøni derecho car tje, bbʉ. Guejti car cja̱hni ca i ne da möxqui cam bbɛfi, hnadi ca da dyøte hne̱je̱. Bbʉ i ne da yohti cár mfe̱ni, te i ne da dyøte, jin gui tzö da pɛjpi ca Ocja̱ pa da tʉnguibi cár jmandado.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Car Tzi Ta Jesús pé bi nzo setenta hñøjø cʉ mí yojmi, cja̱ bi hñi̱tzi pa di mötzi. Bi juejque gá yojo, bi gu̱h‑cʉ́ drí möjmʉ cʉ tzi jñi̱ni, di xijmʉ cʉ cja̱hni car tzi ddadyo jña̱. Di hmɛto‑cʉ́, cja̱ guegue ya di hmɛfa. ");
INSERT INTO otsNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bi xijmʉ: ―Rá ndo ngu̱ nʉr bbɛfi, nu yʉ mɛfi tzi yotjo. Gui nzojmʉ car Tzi Ta ji̱tzi pa pé du pɛjni pé dda mɛfi, como guegue i mandado nʉr bbɛfi‑nʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nuya, dí cu̱hquijʉ, gui möjmʉ ya, gui hñojʉ pʉ jabʉ i bbʉh cʉ cja̱hni cʉ jin gui tzu̱ ca Ocja̱. Eso, gui jña̱jʉ ʉr huɛnda pa jin te da cjahquijʉ. Guí ncjajʉ ncja ngu̱ dɛjti cʉ da hño pʉ jabʉ i bbʉh cʉ mi̱hño. ");
INSERT INTO otsNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jin gui jña̱xjʉ domi bbʉ xtí möjmʉ jar hñu̱. Guejtjo jin gui ca̱xjʉ hnar ddøza̱ pa gui dyʉtijʉ ca te di ttahquijʉ. Gui ti̱htijʉ zɛxtji, cja̱ jin gui cʉxijʉ pé hnar pare. Guejtjo, jin gui dejʉ jar hñu̱ grí nzɛnguatejʉ. Gui xønijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Car ngu̱ pʉ jabʉ gui tzøtijʉ, gui nzojmʉ ca Ocja̱, gui dyöjpijʉ da bendeci cʉ cja̱hni rá bbʉh car ngu̱‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bbʉ i bbʉh pʉ jar ngu̱ hnar cja̱hni ca i pɛhtzi tti̱jqui, ca Ocja̱ da mötzi, da bendeci. Cja̱ bbʉ jin to di bbʉh pʉ jar ngu̱ ca di pɛhtzi tti̱jqui, ca Ocja̱ jin da bendeci cʉ cja̱hni‑cʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Car ngu̱ pʉ jabʉ gui tzøtijʉ, guehpʉ gui dyopjʉ hasta bbʉ xtí pønijʉ car jñi̱ni‑ca̱. Cja̱ gui tzijʉ ca te da ttahquijʉ pʉ. Como guí pɛjpijʉ ca Ocja̱, rí ntzöhui da tti̱nquijʉ. Jin gui ddaxjʉ pé dda ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bbʉ xquí tzøtijʉ hnar jñi̱ni, bbʉ da cuajtiquijʉ cʉ mi̱ngu̱, gui tzijʉ ca da ttahquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gui jojquijʉ cʉ döhtji, cja̱ gui xijmʉ cʉ cja̱hni, ya xí mʉdi i mandado hua jar jöy ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pe bbʉ xquí tzøtijʉ hnar jñi̱ni, cja̱ jin da ne da cuajtiquijʉ cʉ mi̱ngu̱ pʉ, nubbʉ́, gui pønijʉ car jñi̱ni‑ca̱. Cja̱ bbʉ xtí tjoguijʉ ja calle, ");
INSERT INTO otsNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","gui xijmʉ cʉ cja̱hni bbʉ: “Ya xtrá mɛbbe. Ya jin gu cobbe hua. Hasta ya jöy xí jiøx yʉm huabbe, gu tju̱jquibbe, porque jí̱ xcú dyødejʉ car palabra ca xtú xihquibbe. Pe nde̱jma̱ dí xihquijʉ, ya xi ni̱gui hua jer jñi̱nijʉ ja ncja ga mandado ca Ocja̱ hua jar jöy, masque nuquɛjʉ, jí̱ xquí ne xquí dyødejʉ cár palabra.” Da ncjapʉ grí xijmʉ cʉ cja̱hni‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dí xihquijʉ, bbʉ xta zøh car pá bbʉ xta ttun cár castigo yʉ cja̱hni, más da ndo ncastiga cʉ cja̱hni, cʉ mi̱ngu̱ pʉ jabʉ jin gá nequijʉ cja̱ jin gá dyødejʉ nʉm palabra, ni digue cʉ mi̱ngu̱ Sodoma.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Cja̱ pé bi ma̱n car Jesús: ―Nuquɛjʉ, guí mi̱ngu̱jʉ Corazín, drá ndo ngu̱ xquí sufriguɛjʉ. Hne̱hquitjoguɛjʉ, guí mi̱ngu̱jʉ Betsaida, drá ndo ngu̱ xquí sufriguɛjʉ hne̱je̱. Cʉ cja̱hni cʉ mí bbʉh pʉ jar jñini Tiro co pʉ jar jñi̱ni Sidón, bbʉ xtrú cca̱hti gueguejʉ cʉ milagro cʉ xcú cca̱htiguɛjʉ, ya má yabbʉ xtrú repentijʉ, xtrú jiɛjmʉ ca rá nttzo. Guegue‑cʉ́ xtrú ngoxjʉ bojtzibi jáy de̱jʉ pa dír ni̱gui, mí ndo du̱mʉyjʉ por rá nguehca̱ xquí dyøtijʉ ca rá nttzo. Nuquɛjʉ, masque xcú cca̱htijʉ cʉ milagro rá nzɛdi xtú øte, pe jí̱ xcú hñe̱me̱guijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Más da ndo jñu̱x quer castigojʉ ni digue cár castigo ca da ttun cʉ mi̱ngu̱ Tiro co cʉ mi̱ngu̱ Sidón. ");
INSERT INTO otsNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hne̱hquiguɛjʉ, guí mi̱ngu̱jʉ Capernaum, ¿cja guí ma̱nguɛjʉ da ndo tti̱zquijʉ? Ncjahmʉ gri ma̱ntsjɛjʉ, ya xquí tzøxjʉ nʉ jar ji̱tzi. Pe ya xpa e̱h car pa bbʉ xta tjøhti quer jñi̱nijʉ, tje da mpu̱ni. Cja̱ nuquiguɛjʉ, da cju̱hquijʉ pʉ jabʉ jin gui tzö.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Cja̱ car Jesús pé bi xih quí möxte: ―Yʉ cja̱hni yʉ to da dyøh ca guí ma̱jmʉ, guejquitjogö hne̱je̱ i øjtigui. Nu yʉ cja̱hni yʉ jin da nequijʉ, guejquitjogö jin gui negui‑yʉ hne̱je̱. Yʉ cja̱hni yʉ jin da negui, gueguejʉ jin gui nejʉ cam Tzi Ta ca xpá mɛnquigö, hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Diguebbʉ ya, cʉ setenta hñøjø cʉ xquí tjajni, bi möjmʉ bú øtijʉ ca xquí ma̱n car Tzi Ta Jesús. Cja̱ bbʉ pé mbú cojmʉ, mí ndo mpöjmʉ, bi ma̱jmʉ: ―Nuquɛ, Tzi Jmu̱, cʉ ttzonda̱ji̱ i weni bbʉ dí nømbiquije quer tzi tju̱ju̱ cja̱ dí bbɛjpije da bøni.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Cja̱ bi da̱h car Jesús: ―Ja̱a̱, dú pa̱cö bbʉ nguí fonguijʉ‑cʉ́. Dú janti bbʉ mbú töh car Satanás jar ji̱tzi, ncja hnar rayo. ");
INSERT INTO otsNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nugö, xtú ddahquijʉ poder pa gui ti̱nijʉ cʉ cci̱ña̱ co cʉ alacrán, cja̱ pa gui ta̱pijʉ cár ttzɛdi ca Jin Gui Jo, cja̱ nucʉ́, jin te da cjahquijʉ‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nuquɛjʉ, guí mpöjmʉ ya, porque xcú ta̱jpijʉ cʉ nda̱ji̱ cʉ jin gui tzö. Pe más i ndo mu̱hui ca ya xpí ju̱x pʉ ji̱tzi quir tju̱ju̱jʉ. Rí ntzöhui gui ndo mpöjmʉ por rá nguehca̱.― Ncjapʉ gá ma̱n car Jesús bbʉ mí nzoh cʉ setenta hñøjø cʉ xquí juajni. ");
INSERT INTO otsNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Guejti car hora‑ca̱ hne̱je̱, car Jesús bi ndo mpöjö, cja̱ bi nzoh ca Ocja̱. Car Espíritu Santo bi ún ya palabra ya bi ma̱. Bi xih cár Tzi Ta ji̱tzi: ―Nuquɛ, Tzi Ta, ir mɛjtiguɛ nʉr ji̱tzi cja̱ co nʉr jöy, como guehquiguɛ, guí mandadobi‑yʉ. Dí öhqui cjama̱di porque xcú u̱jti yʉm cja̱hni yʉ i tɛngui ja guí ncjaguɛ, cja̱ co ja ncja gri mandado. Nu cʉ sabio, jin gui pa̱di ja guí ncjaguɛ, como jí̱ xquí föxquɛ‑cʉ. Gue yʉm cja̱hni yʉ i tɛngui xcú föx‑yʉ, cja̱ nuyʉ́, i jñɛjmi cʉ tzi ba̱jtzi cʉ jin te bbe i nxödi. Nuquɛ, Tzi Ta, xcú föx‑yʉ co quer tzi pojö como guehca̱ xcú mbe̱ni, cja̱ rá zö quer mfe̱ni.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Cja̱ pé bi ma̱n car Jesús: ―Cam Tzi Ta xí ddajqui cam cargo pa gu u̱jti yʉ cja̱hni ja i ncja guegue, cja̱ pa gu cojcö ʉ́r lugar guegue hua jar jöy. Ddatsjɛ guegue cam Tzi Ta ji̱tzi i cca̱jtigui mbo nʉm tzi mʉy, como ʉ́r Ttʉguigö‑ca̱. Cja̱ ddatsjɛguigö, dí pa̱di göhtjo ja i ncja cam Tzi Ta. Guejti yʉ dda cja̱hni yʉ dí xijmʉ ja i ncja cam Tzi Ta, guegue‑yʉ i pa̱di ja i ncja‑ca̱ hne̱je̱. Nuyʉ́, cja̱ co cʉ pé ddaa cʉ to dí ne gu fötzi, da ba̱dijʉ ja i ncja cam Tzi Ta.― Bi ma̱ ncjanʉ car Jesús bbʉ már ora. ");
INSERT INTO otsNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Diguebbʉ ya, car Jesús bi zix quí möxte, gá möjmʉ hnanguadi pa jin di dyøh cʉ pé dda cja̱hni. Cja̱ bi nzoh‑cʉ́, bi hñi̱mbijʉ: ―Nuquiguɛjʉ, xí ndo möxquijʉ ca Ocja̱, xí ddahquijʉ xcú cca̱jtiguijʉ cja̱ co cʉ cosa rá zö cʉ xí ncja yʉ pa ya. ");
INSERT INTO otsNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Dí xihquijʉ, már ndo ngu̱ quí jmandadero ca Ocja̱, co cʉ rey cʉ mí bbʉ ya má yabbʉ, mí ndo ne di cca̱htijʉ ca hnar cja̱hni ca di hñi̱x ca Ocja̱. Nu gueguejʉ, jin gá nzʉdi di cca̱jtiguijʉ. Guejtjo mí ndo ne di dyødejʉ cʉ palabra cʉ di ma̱n ca hnaa ca di mɛjni ca Ocja̱. Pe jin gá nzʉdi di dyødejʉ. Nuquiguɛjʉ, xcú dyødejʉ cʉ palabra‑cʉ.― Ncjapʉ gá xih quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ca pé hnar pa ya, hnar cja̱hni ca xquí ndo nxöh cár ley car Moisés bi guati car Jesús. Mí ne di dyøhtibi ʉr prueba, eso bi dyöni: ―Maestro, ¿ter bɛh ca̱ gu øte pa gu töti cam nzajqui ca jin da tjegue?― ");
INSERT INTO otsNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Bi xih car Jesús: ―¿Ter bɛh ca̱ i ju̱x pʉ jar ley? ¿Te guí cca̱hti pʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bi da̱di, i̱na̱: ―“Gui ndo jion ca Ocja̱, göhtjo mbo ir tzi mʉy. Gui ndo ne car Tzi Ta ji̱tzi göhtjo co quer ttzɛdi, göhtjo co quer mfe̱ni. Cja̱ gui ma̱h quir hñohui, ncja ngu̱ guir ma̱jtsjɛ.”― ");
INSERT INTO otsNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Bi ma̱n car Jesús, bbʉ́, i̱mbi: ―Xcú tja̱di rá zö. Gui dyøte ncja ngu̱ xcú ma̱, cja̱ nubbʉ, da hmʉh quer nzajqui, bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nu car maestro bi hñöni, bbʉ́: ―¿Ja ncja grá pa̱di to cʉm hñohui? ¿Toca̱ dí nesta gu fötzi?― Bi dyöni nʉr nttöni‑nʉ, como jin tza mí ne di möx quí mi̱nga̱‑cja̱hnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Car Jesús bi da̱j ya bbʉ́, bi xih hnar tzi bbede gá ejemplo: ―øde, hnar hñøjø bi bøm pʉ Jerusalén, mír ma pʉ Jericó. Cja̱ bbʉ má pa jar hñu̱, bi ntjɛhui cʉ be̱. Nucʉ, bi møjquibi göhtjo quí da̱jtu̱, bi jña̱htzibi cár domi, cja̱ bi ndo ʉnijʉ. Bi guaj ya bi ʉnijʉ ya, cja̱ bi zoguijʉ pʉ jar hñu̱, gá ma̱jmʉ, ya xquí du̱. ");
INSERT INTO otsNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Diguebbʉ ya, bi tjoh pʉ hnar möcja̱ digue cár religión cʉ israelita. Cja̱ nuca̱, bi jianti car hñøjø már bbɛm pʉ, cja̱ bi tjojtjo. ");
INSERT INTO otsNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Guejtjo bi tjoh pʉ hnar levita, tzʉdi, hnar hñøjø ca mí föx cʉ möcja̱, mí pɛh pʉ jár templo cʉ israelita. Guejti‑ca̱ bi tjojtjo hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Diguebbʉ ya, ca hnar mi̱ngu̱ Samaria bi tjoh pʉ jar hñu̱ cja̱ bi jianti már bbɛm pʉ car hñøjø‑cá̱. Bi jianti cja̱ bi ndo jui̱jqui. ");
INSERT INTO otsNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Guegue ya bi guati, bi xix car aste co ni car vino pʉ jabʉ mí bbʉh quí herido, cja̱ bi pantibi da̱jtu̱. Ma ya bi hñi̱x pʉ jár zu̱we̱ ca má tø guegue, bi zitzi gá mɛhui hnar mesón. Cja̱ nupʉ, car mi̱ngu̱ Samaria bi nu̱ göhtjo ca te mí nesta car hñøjø ca xquí ttʉni. ");
INSERT INTO otsNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Car jiax pʉ ya cá̱, bi gʉhmi yo pieza cʉ domi, bi un car mi̱ngu̱ pʉ jar mesón. Bi xifi: “Föh tzʉ nʉr cja̱hni. Bbʉ te da nesta gui tömbi, bbʉ pé xcuá cojcö, pé xtá cju̱jtiqui.”― Bi nttzɛdi pʉ car bbede. ");
INSERT INTO otsNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nu car Jesús bi dyön car maestro ca már øde, bi hñi̱mbi: ―Digue cʉ jñu̱ cʉ cja̱hni cʉ bi tjoh pʉ jar hñu̱, ¿toca̱ bi cja ʉ́r hñohui car probe ca xquí ʉn cʉ be̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Car maestro bi da̱h bbʉ́: ―Gue ca hnaa ca bi jui̱jqui.― Car Jesús bi xih, bbʉ: ―Guehquitjoguɛ, gui ma gui dyøte ncja ngu̱ gá dyøti car mi̱ngu̱ Samaria. Gui jui̱jqui car cja̱hni ca i nesta to da mötzi.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Diguebbʉ ya, car Jesús bi segue bi ma pʉ jabʉ mír ma. Bi möjmʉ quí amigo cʉ mí yojmi, cja̱ bi zøtijʉ hnar tzi jñi̱ni. Mí bbʉh pʉ hnar bbɛjña̱, mí ju̱ cár tju̱ju̱ múr Marta. Guegue‑ca̱ bi mvitabi car Jesús co quí möxte di ma pʉ́r ngu̱. Cja̱ bi möjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mí bbʉh cár cju̱juɛ car Marta, mí ju̱ cár tju̱ju̱ múr María. Guegue‑ca̱ bi mi̱jta hnanguadi pʉ jabʉ már bbʉh car Jesús, cja̱ bi dyøjti ca már ma̱n‑ca̱. Jin gá mföxte pa di tjojqui car jñu̱ni. Nu car Marta már mpɛgui már jojqui car jñu̱ni. ");
INSERT INTO otsNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Eso, bi ndo ungui ʉr cuɛ car Marta, como már ngu̱ cár bbɛfi. Nubbʉ, bi guati pʉ jabʉ már ju̱ car Jesús, cja̱ bi xifi: ―Nuquɛ, Tzi Jmu̱, ¿cja jin guí cja ndu̱mʉy, xí nzogui hua nʉm cju̱juɛ, dí ddatsjɛ nʉr bbɛfi. Xih tzʉ da möxqui.― ");
INSERT INTO otsNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bi da̱h car Jesús ya bbʉ: ―Nuquɛ, Marta, guí ndo ntzøte, como rá ngu̱ quer bbɛfi gár øte. Pe jin tza i nesta pa gui dyøte göhtjo‑ca̱. Más i nesta gui dyøj nʉm palabra nʉ dár ma̱. ");
INSERT INTO otsNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xí mbe̱n nʉr María, i ndo ne da dyøj nʉm palabragö, masque jin te da möxquiguɛ. Rá zö cár mfe̱ni, eso da tjɛgui da mi̱jti hua, jin gu cu̱y.― Ncjapʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hna vez, car Jesús már bbʉh hnar lugar, már nzoh cár Tzi Ta gá oración. Bbʉ mí guaj ya, bi ma̱ngui hnaa quí möxte, bi xifi, i̱mbi: ―Nuquiguɛ, Tzi Jmu̱, gui u̱jtiguije tzʉ ja dá nzojme car Tzi Ta ji̱tzi, ncja ngu̱ car Juan bi u̱jti cʉ cja̱hni cʉ i tɛni guegue ja drí nzoh car Tzi Ta.― ");
INSERT INTO otsNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Cja̱ car Jesús bi xijmʉ: ―Bbʉ guí mahtijʉ Ocja̱, gui ma̱jmʉ ncjahua: Nuquɛ, ʉm Tzi Taquije, guí bbʉh pʉ jar ji̱tzi, Dí i̱zquije gú Ocja̱‑guɛ, Tzin drí hñe̱h car pá bbʉ xtí mandado hua jar jöy, Gui föxquije gu øtije hua jar jöy ca guí neguɛ, ncja ngu̱ ga ttøti pʉ jar ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ddajquije tzʉ ca gu tzije rá pa ya, ");
INSERT INTO otsNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cja̱ gui perdonaguije ca rá nttzo ca xtú øtije, ncja ngu̱göje, dí perdonabije ca to te i tu̱jquije. Gui nú̱guije tzʉ pa jin da ttøjtiguije prueba rá pa ya, Cja̱ jin gui jiɛh ca Jin Gui Jo da da̱guije. Da ncjapʉ grí nzojmʉ car Tzi Ta ji̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Diguebbʉ ya, car Jesús pé bi xih quí möxte pé hnar palabra pa di ba̱dijʉ ja i ncja car oración: ―Nuquiguɛjʉ, bbʉ di bbʉhquiguɛjʉ hnaa ca di ma jár ngu̱ hnár amigo, madé ʉr xu̱y, cja̱ di dyöjpi ncjahua: “Hñohui, jmi̱qui tzʉ yojo ir jme̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Xí nzøh cam visitaje, yanʉ xcuá hñe̱je̱. u̱jtjo te gu unije.” ");
INSERT INTO otsNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Car amigo ya, di da̱h pʉ mbo: “Dyo guí mfadagui. Ya xtú coti car goxtji, cja̱ ya xtú obbe yʉm ba̱jtzi hua jar gama. Jin gui tzö gu nantzi te gu ddahqui.” Nu cár amigo ya, jin di tzöya ca mír mahti cja̱ mír dyöjpi cʉ jme̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nugö, dí xihquijʉ, masque jin di ne di nantzi car mi̱ngu̱ pa te di un cár amigo, pe nde̱jma̱ja̱ di nantzi, di uni göhtjo ca mí joni, porque bbʉ ji̱na̱, di dé di dyöjpi. ");
INSERT INTO otsNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Guejtigö, dí xihquijʉ, bbʉ guí orajʉ, dyöjpijʉ ca Ocja̱ ca guí nestajʉ, cja̱ xta ddahquijʉ. Jionijʉ, cja̱ xquí tötijʉ. Ddootijʉ car goxtji, cja̱ xta tsjoquiquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bbʉ to da dyöjpi ca Ocja̱ ca te i joni, xta ttu̱ni. Bbʉ to da jion ca i ne, xta döti. Bbʉ to da ddooti car goxtji, xta tsjojquibi. ");
INSERT INTO otsNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hne̱hquiguɛjʉ, nʉ to i bbʉh quí ba̱jtzi, bbʉ te da dyöjpi, da uni. Hnar ba̱jtzi, bbʉ da dyöjpi cár ta hnar tju̱jme̱, ¿cja da uni hnar me̱do? Ji̱na̱. Bbʉ da dyöjpi hnar möy, ¿cja da uni hnar cci̱ña̱? Ji̱na̱, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bbʉ da dyöh hnar doni, ¿cja da uni hnar alacrán? Ji̱na̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nuquiguɛjʉ, rá nttzo quir tzi mʉyjʉ pe nde̱jma̱ guí pa̱dijʉ gui un quir ba̱jtzijʉ ca rá zö. Hni̱xjma̱ja̱ quer Tzi Tajʉ ca bí bbʉ ji̱tzi, ¿ja jin drí ddahquijʉ car Espíritu Santo bbʉ gui dyöjpijʉ‑ca̱?― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ca pé hnar vez, car Jesús bi fonguibi cár nda̱ji̱ ca Jin Gui Jo. Car nda̱ji̱‑ca̱ mí yojmi hnar hñøjø múr ngone, jí̱ mí tzö di ña̱. Cja̱ bbʉ mí bøn car ttzonda̱ji̱, exque bi mʉdi bi ña̱ rá zö car cja̱hni, bbʉ. Már ngu̱ cʉ cja̱hni cʉ bi cca̱htijʉ te bi ncja. Cja̱ bi ndo hño í mʉyjʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pe mí bbʉh cʉ dda cja̱hni cʉ mí ma̱jmʉ: ―Nʉr Jesús, i yojmi cár nda̱ cʉ ttzonda̱ji̱, cja̱ guegue‑ca̱ xí un cár ttzɛdi, eso, i pɛhtzi poder drí fongui ttzonda̱ji̱. Tzʉdi, i yojmi ca hnar ttzonda̱ji̱ más rá nzɛdi ca i tsjifi Beelzebú.― Ncjapʉ gá ma̱n cʉ cja̱hni‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Cja̱ pé mí bbʉh cʉ dda cja̱hni cʉ bi dyøhtibi prueba car Jesús. Bi dyöjpijʉ di mandado pa di ni̱gui hnar seña pʉ jar ji̱tzi, pa di ba̱dijʉ, ¿cja guegue xcuí mɛjni car Tzi Ta ji̱tzi? ");
INSERT INTO otsNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nu car Jesús bi ba̱di te már mbe̱nijʉ, cja̱ bi xijmʉ: ―Car cja̱hni ca i mandado, bbʉ da ntu̱jnihui quí hñohui, ya jin gui tzö da segue da mandadobi, bbʉ. Xta wen quí hñohui, cja̱ xta mfontijʉ. Ncjadipʉ hnar familia, bbʉ da ntujnijʉ, da mfontijʉ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Guejti car Satanás, jin di ne di ntu̱jnihui cʉ pé dda nda̱ji̱ cʉ jin gui tzö, como nucʉ, i mandadobi‑cʉ, eso, jin da ne da fongui pʉ jabʉ i bbʉh‑cʉ. Bbʉ di fongui‑cʉ, ya jin di jogui di mandadotjobi. Nuquɛjʉ, guí ma̱jmʉ dí yobbe car Beelzebú, cja̱ guegue‑ca̱ i mandadobi cʉ pé dda ttzonda̱ji̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","I bbʉh cʉ dda cja̱hni cʉ i tɛnquiguɛjʉ. Guejti‑cʉ i fongui ttzonda̱ji̱ hne̱je̱. Gui dyönijʉ cʉ cja̱hni‑cʉ, ¿jabʉ rí hñe̱h cár ttzɛdijʉ pa drí fongui ttzonda̱ji̱? ¿Cja jin da xihquijʉ, rí hñe̱h car Tzi Ta ji̱tzi? Eso, jin gui cierto ca guí xijcöjʉ, tzʉdi, por rá ngue cár ttzɛdi ca Jin Gui Jo dár fongui ttzonda̱ji̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nugö, dí xihquijʉ, guejtigö dí yobbe car Tzi Ta ji̱tzi, hne̱je̱, cja̱ por rá ngue cár ttzɛdi guegue‑ca̱ dí fongui cʉ nda̱ji̱ cʉ jin gui tzö. Por rá nguehca̱ dár ta̱jpi cʉ ttzonda̱ji̱, ya xqui fa̱di, ya xqui mandado ca Ocja̱ hua jar jöy co cár ttzɛdi, cja̱ nuquɛjʉ, xcú cca̱htijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Bbʉ i bbʉh hnar hñøjø rá nzɛdi ca i pɛhtzi quí arma, jin to da be̱jpi quí mɛjti guegue. Como rá nzɛdi, da mödi rá zö cár ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sólo bbʉ pé du e̱h hnar cja̱hni más drá nzɛdi ni ndra ngue car mi̱ngu̱, guegue da gʉ́mbi quí arma car mi̱ngu̱ cja̱ da da̱pi. Nubbʉ, da jogui da du̱htzibi quí mɛjti pa pé drí jejquibi quí amigo guegue.― Bbʉ mí ma̱ nʉr palabra‑nʉ car Jesús, mír jɛquihui car mi̱ngu̱ rá nzɛdi co ca Jin Gui Jo. Nu ca hnar hñøjø ca más rá nzɛdi, mír jɛquihui guejtsjɛ guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Cja̱ pé bi ma̱n car Jesús: ―Nugö, dí xihquijʉ, car cja̱hni ca jin gui föxquigö, i contragui. Car cja̱hni ca jin gui föxqui gu jmuntzi cja̱hni pa drí dɛngui, guegue i fonti‑cʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Hna vez, ca hnár nda̱ji̱ ca Jin Gui Jo bi bøm pʉ jár mʉy car cja̱hni ca mí yojmi, cja̱ bi ma bú hño cʉ lugar jabʉ jin te i po deje. Mí joni pé hnar cja̱hni pa di ñʉti mbo ʉ́r mʉy, di hmʉh pʉ. Pe jin to gá ndöti pa di guati. Nubbʉ, bi ma̱ntsjɛ: “Gu ma grá jon ca hnar cja̱hni ca ndí bbʉ mbo ʉ́r mʉy má̱hmɛto, pé gu hmʉh pʉ.” ");
INSERT INTO otsNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nubbʉ, bi ma car ttzonda̱ji̱, bbʉ, bi ma gá ndöti car cja̱hni ca bbɛto mí yojmi. Ya xquí jñojqui rá zö cja̱ jin te mí cja. ");
INSERT INTO otsNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Diguebbʉ ya, car ttzonda̱ji̱ pé bi ma bú tzí pé yojto quí hñohui, más már ndo nttzo‑cʉ ni di guegue. Göhtjo‑cʉ bú e̱jmʉ, bbʉ, bi ñʉtijʉ jár mʉy car cja̱hni‑ca̱, cja̱ bi hmʉjtijʉ pʉ. Nubbʉ, bi ndo ttzon cár vida car cja̱hni, bbʉ. Más már ndo nttzo ca mí tzöhui ni digue ca xquí tzöhui má̱hmɛto bbʉ mí jøntsjɛ ca hnar nda̱ji̱ mí bbʉbi.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Diguebbʉ ya, menta már ma̱ndi yʉ palabra‑yʉ car Jesús, ca hnar bbɛjña̱ ca már bbʉbi cʉ cja̱hni rá ngu̱ bi hna ña̱ nzajqui, bi xih car Jesús, i̱na̱: ―¡Da ndo tti̱htzibi quer me, como guegue xí ønqui cja̱ xí tehqui! Car Tzi Ta ji̱tzi xí ndo möxi guegue, xí uni hnar bendición rá ndo zö!― ");
INSERT INTO otsNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nu car Jesús bi da̱di, bi hñi̱mbi: ―Yʉ cja̱jni yʉ i øj nʉ́r palabra ca Ocja̱ cja̱ i øjte, guejyʉ́ da ndo möx car Tzi Ta ji̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ca hnar vez, bbʉ ya xquí ndo ngu̱jqui cʉ cja̱hni, ca mír guatijʉ car Jesús, bi ma̱ guegue, i̱na̱: ―Jin gui tzö quí mfe̱ni yʉ cja̱hni yʉ i bbʉj yʉ pa ya. I öjqui gu u̱jtijʉ hnar milagro pa da ni̱gui, ¿cja guejcö xpá mɛnquigö car Tzi Ta ji̱tzi? Pe ya jin gu u̱jtigö‑yʉ pé hnar milagro. Jøntjo da cca̱htijʉ te da ncjaguigö. Nuca̱ da jñɛjmi ca bi ncjajpi ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Jonás. ");
INSERT INTO otsNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Guegue car Jonás bú de jñujpa pʉ mbo ʉ́r mʉy car ndo möy, cja̱ pé bi bøni, jin te gá cja. Nu cʉ mi̱ngu̱ Nínive bi cca̱htijʉ car Jonás, xcuí bøh pʉ jár mʉy car ndo möy, jin te mí cja, cja̱ por rá nguehca̱, bi hñe̱me̱, cierto xcuí mɛjni car Jonás ca Ocja̱. Hne̱quigö, car cosa ca xtá tjojcö, xta jñɛjmi ca bi tjoh car Jonás, pa ncjapʉ drí ba̱j yʉ cja̱hni yʉ i bbʉj yʉ pa ya, cierto, guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pe bbʉ pé xtu e̱h car Tzi Ta ji̱tzi pa da jña̱mpi ʉ́r huɛnda yʉ cja̱hni, nubbʉ, da nantzi göhtjo cʉ cja̱hni cʉ mí bbʉ ya má yabbʉ. Guejtjo da ni̱gui pʉ ca hnar reina ca mí mandado ca hnar jöy nʉ jar Sur. Guegue‑ca̱ da xij yʉ cja̱hni yʉ i bbʉj yʉ pa ya, rá nttzo ca xí dyøtijʉ, como jí̱ xcá ne xcá hñe̱me̱guijʉ. Guegue car bbɛjña̱‑ca̱, güí hñe̱ yapʉ, hne̱ bi cca̱hti car rey Salomón, te tza mí ndo pa̱h‑ca̱, bi dyøh ca mí ma̱n‑ca̱, cja̱ bi hñe̱me̱. Nuquɛjʉ, rá ngu̱quiguɛjʉ xcú dyødejʉ ca dí ma̱ngö, pe jin guí e̱me̱guijʉ, cja̱ nugö, más dí ja̱gö cam cargo ni ndra ngue ca mí ja̱ car Salomón. ");
INSERT INTO otsNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bbʉ xta tja̱mpi ʉ́r huɛnda yʉ cja̱hni, cja̱ da nantzi cʉ mí bbʉy ya má yabbʉ, guejti cʉ mi̱ngu̱ Nínive xta hmöjti pʉ hne̱je̱, xta xij yʉ cja̱hni i bbʉj yʉ pa ya, rá nttzo ca xí dyøtijʉ, como jí̱ xcá hñemeguijʉ. Gueguejʉ cʉ mi̱ngu̱ Nínive, bbʉ mí dyødejʉ ca mí ma̱n car Jonás, bi repentijʉ cja̱ bi jiɛjmʉ ca rá nttzo. Nuquɛjʉ, xcú dyøh ca xtú xihquijʉ, pe jí̱ xquí jiɛjmʉ ca rá nttzo, cja̱ nugö, más dí ja̱gö cam cargo ni ndra ngue ca mí ja̱ car Jonás. ");
INSERT INTO otsNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Bbʉ to i tzøqui hnar tzibi, jin gui a̱gui, cja̱ jin gui cohmi hnar caja. I tti̱x car tzibi pʉ jabʉ rá nte, pa drí ni̱gui göhtjo cʉ to da ñʉti pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","I jñɛjmi hnar tzibi yʉm döjʉ. Co guejyʉ dár jantijʉ. Bbʉ jin te i cja yʉm döjʉ, nubbʉ, dí cca̱htijʉ car jiahtzi, bbʉ. Pe bbʉ te da cja yʉm döjʉ, dí bbʉpjʉ jar bbɛxu̱y, bbʉ. Ncjadipʉ yʉm tzi mʉyjʉ, hne̱je̱. Bbʉ te i cja‑yʉ, ncjahmʉ dí bbʉpjʉ jar bbɛxu̱y, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nuya, gui jña̱ ʉr huɛnda pa da hmʉy rá zö quer tzi mʉy, pa sa̱nta̱ jin gui jñɛjmi car cja̱hni ca i bbʉ jar bbɛxu̱y. ");
INSERT INTO otsNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bbʉ jin te i cja quer tzi mʉy, nubbʉ, i yoti car jiahtzi mbo quer tzi mʉy. Nubbʉ, da jogui gui cca̱hti rá zö ja i ncja göhtjo, ncjahmʉ di yoti hnar tzibi pʉ jabʉ guí bbʉy.― ");
INSERT INTO otsNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bbʉ mí guadi mí ma̱n yʉ palabra‑yʉ́ car Jesús, hnar fariseo bi mvitabi di mɛhui pʉ́r ngu̱ du tzihui. Bi mɛhui car Jesús, bbʉ́, bi ñʉti jár ngu̱ cja̱ bi mi̱bi jar mexa. Bbʉ mí xʉdyɛ car Jesús, jin gá dyøte ncja ngu̱ nguá dyøti cʉ fariseo bbʉ nguá nzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bi cca̱hti‑cá̱ car fariseo, cja̱ bi mbe̱ntsjɛ: ―¿Dyoca̱ jin gui xʉdyɛ ya‑nʉ́ ncja ngu̱ dra xʉdyɛgöje?― ");
INSERT INTO otsNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nu cam Tzi Jmu̱jʉ ya, bi xifi: ―Nuquiguɛjʉ, guí fariseojʉ, guí ndo xʉtijʉ rá zö yʉ xaro co yʉ moji pa jin da contiqui quir tzi mʉyjʉ ca rá nttzo ca di tu̱‑yʉ́. Pe nuquɛjʉ, pʉ mbo ir mʉyjʉ, rá nttzoquiguɛjʉ, como guí ttzodyojʉ, guí já̱mbijʉ quí domi quir mi̱nga̱‑cja̱hnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Guí dondojʉ! Hnadi ca Ocja̱ xí dyøjquijʉ cja̱ co ca i bbʉ xøtze yʉm cuerpojʉ. Guejti guegue xí dyøti ca rá bbʉ mbo ʉm tzi mʉyjʉ, cja̱ bí janti göhtjo. ");
INSERT INTO otsNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dí xihquijʉ, bbʉ güi unijʉ cʉ probe ca te di zi, nucá̱ di tzøh ca Ocja̱, cja̱ di ma̱, göhtjo rá nttaxi quir trastejʉ, ya jin di contiqui quir tzi mʉyjʉ, bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nuquɛjʉ, guí fariseojʉ, da ndo ttahqui quer castigojʉ. Guí unijʉ ca Ocja̱ gá diezmo cʉ xa̱ccani co cʉ loda co göhtjo tema paxi ca i pɛhui car jñu̱ni, pe jin guí øtijʉ ca i ne ca Ocja̱. I ne guegue gui ma̱dijʉ‑ca̱, cja̱ gui nu̱jʉ rá zö quir hñohuijʉ, gui unijʉ ca i tocabi‑cʉ́. I nesta gui dyøtijʉ‑cá̱, nubbʉ́, guejtjo da jogui gui döjʉ car diezmo hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nuquɛjʉ, guí fariseojʉ, da ndo ttahqui quer castigojʉ. Bbʉ guí pöjmʉ jar templo, i ndo gustaquijʉ gui jñu̱xjʉ cʉ tju̱jni cʉ rí hmʉ delante, pʉ jabʉ da cca̱jtiquijʉ cʉ pé ddaa. Guejtjo bbʉ guí pöjmʉ jar töy, o bbʉ guí dyojʉ ja calle, guí ndo nejʉ pa da tti̱zquiguɛjʉ cja̱ da ttzɛnguaquijʉ rá zö. ");
INSERT INTO otsNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Drá ndo ngu̱ quer castigojʉ, nuquɛjʉ, guí fariseojʉ co hne̱hquiquɛjʉ guí maestrojʉ guí nxöjmʉ car ley. Guí jiöjtejʉ, guí jñɛjmʉ hnar ohtzi pʉ jabʉ xí ttöh hnar ánima. Ya xná nttzo pʉ mbo, cja̱ jin gui fa̱di, má̱s te xí ttöh pʉ. Eso, i dyo pʉ xøtze cʉ cja̱hni, cja̱ i ttzombi quí tzi mʉyjʉ. Ncjapʉ hne̱je̱, cʉ cja̱hni cʉ i tɛnquijʉ, da nxödi da dyøtijʉ ncja ngu̱quiguɛjʉ, cja̱ nucʉ́, jin gui pa̱dijʉ, ¿cja rá nttzo quir tzi mʉyjʉ?― Bi ma̱n yʉ palabra‑yʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ca hnar hñøjø ca xquí nxödi rá zö cár ley car Moisés bi ma̱m bbʉ, i̱na̱: ―Nuquɛ, Maestro, ncjahmʉ guí xijquije rá ndo nttzoguigöje, hne̱je̱, bbʉ guí ma̱ ncjapʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nu car Jesús pé bi ma̱m bbʉ: ―Guehquitjoguɛjʉ hne̱je̱, guí maestrojʉ, guí u̱jtijʉ yʉ cja̱hni cár ley car Moisés, drá ndo ngu̱ quer castigojʉ. Guí xijmʉ yʉ cja̱hni rá ndo ngu̱ cosa cʉ i nesta da dyøtijʉ, ncjahmʉ di tzøh ca Ocja̱ quí vidajʉ bbʉ di hmʉpjʉ ncja ngu̱ gri xijmʉ. Pe nuquɛjʉ, jin te guí föxjʉ yʉ cja̱hni pa da hmʉpjʉ rá zö. ");
INSERT INTO otsNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Drá ngu̱ quer castigojʉ, como guí xoxjʉ cʉ tzi ni̱cja̱ pa da ni̱gui jabʉ xí ttöh quí jmandadero ca Ocja̱ cʉ mí bbʉ ya má yabbʉ cja̱ bi bböhti. Gue qui ndor titajʉ bi möhti‑cʉ, cja̱ nuquɛjʉ guí tɛmbijʉ cár mfe̱ni guegue‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Qui ndor titajʉ jin gá ne gá dyødejʉ car palabra ca mí ma̱n quí jmandadero ca Ocja̱ cʉ xcuí mɛjni, eso, bi möhti‑cʉ. Cja̱ nuquɛjʉ ya, guí xohtzibijʉ quí tzi ni̱cja̱ cʉ profeta cʉ bi möhti qui ndor titajʉ, ncjahmʉ guí ma̱jmʉ, már zö ca bi dyøti‑cʉ́, como guí tɛmbijʉ cár mfe̱ni‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ya má yabbʉ, ya xi mí pa̱h car Tzi Ta ji̱tzi te di ttøhtibi quí jmandadero, eso, bi ma̱ ncjahua: “Gu cu̱h cʉm profeta co cʉm apóstole, pa da nzoj yʉ cja̱hni. Cʉ ddaa da bböhti, cja̱ cʉ ddaa da cjöhmitjo.” Ncjapʉ gá ma̱n car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nugö, dí xihquijʉ, nuquiguɛjʉ, guí bbʉpjʉ yʉ pa ya, da ttahqui quer castigojʉ por rá ngue quí jmandadero ca Ocja̱ cʉ xí bböhti, göhtjo cʉ xí bböhti desde bbʉ mí mʉj nʉr mundo. ");
INSERT INTO otsNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nuquɛjʉ, guí bbʉpjʉ yʉ pa ya, ca Ocja̱ da dyöhquijʉ ʉr huɛnda digue göhtjo cʉ jogui cja̱hni cʉ xí bböhti desde bbʉ mí mʉj nʉr mundo hasta rá pa ya, desde bbʉ mí bböhti car Abel, cár ttʉ car Adán, hasta bbʉ mí bböhti ca hnár jmandadero ca Ocja̱ ca mí tsjifi ʉr Zacarías. Guegue‑ca̱ bi bböhti jár tji car ndo templo, már bbö mfrente car goxtji. Guehquiguɛjʉ da ttahquijʉ car castigo digue göhtjo cʉ cja̱hni‑cʉ, da zʉhquijʉ hnar castigo drá ndo jñʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Drá ndo ngu̱ quer castigojʉ, nuquɛjʉ, guí maestrojʉ, guí ndo nxödijʉ cár ley car Moisés. Pe guí ccaxjʉ yʉ cja̱hni pa jin da ntiendejʉ te i ne da ma̱n cár palabra ca Ocja̱. Nuquɛjʉ, jin guí ne gui cʉtijʉ jár dyɛ ca Ocja̱, guejtjo jin guí jɛguijʉ da ñʉti cʉ pé dda cja̱hni cʉ i ne da ñʉti pʉ.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bbʉ ya xquí guah car Jesús, xquí ma̱n yʉ palabra‑yʉ́, bi ndo cja í cuɛ cʉ fariseo co ni cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley. Nucʉ́, como mí ndo ʉjʉ car Jesús, bi dejʉ, bi dyönijʉ nttöni, mí jonijʉ ja drí da̱pijʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pʉ jabʉ mí pa car Jesús, ddáa cʉ cja̱hni‑cʉ́ mí tɛnijʉ, mí hñøxjʉ te mí ma̱, como gueguejʉ mí tøhmijʉ, má̱s di ma̱n car Jesús, hnar palabra ca jin di tzö. ");
INSERT INTO otsNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Már ndo ngu̱ cʉ cja̱hni bi jmu̱ntzijʉ pʉ jabʉ már bbʉh car Jesús. Mí tengu̱ mil, mí ndo dʉjʉ, hasta mí ntu̱jquijʉ, jí̱ mí tzö jabʉ di hmöpjʉ. Car Jesús bi nzoh quí möxte, bi xijmʉ: ―Gui mfödijʉ pa jin gui ma gui dyøtijʉ ncja ngu̱ ga dyøti cʉ fariseo, cja̱ jin gui ma gui hñe̱me̱bijʉ ca i ma̱n‑cʉ. Cár vidajʉ i ni̱gui rá zö, pe xøtzetjo. Nu pʉ mbo ʉ́r mʉyjʉ, rá nttzo‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yʉ pa ya, i bbʉh cʉ dda cosa cʉ jin gui fa̱di ja i ncja. Pe ba e̱h car pa bbʉ xta ni̱gui ja i ncja cʉ cosa‑cʉ. Göhtjo yʉ cja̱hni da ba̱di ja i ncja cʉ i cjohmi yʉ pa ya. ");
INSERT INTO otsNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hne̱hquiguɛjʉ, cʉ palabra cʉ xcú ma̱jmʉ pʉ jabʉ nguí i̱na̱jʉ, jin to már bbʉh pʉ, da dyøde göhtjo cʉ cja̱hni. Ca te xcú ma̱jmʉ pʉ jabʉ jin to di dyøde, da ndo fa̱di. ");
INSERT INTO otsNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nuquɛjʉ, ʉm amigoquijʉ, dí xihquijʉ, jin gui tzu̱jʉ yʉ cja̱hni, masque da möjtiquijʉ, porque jin gui tzö te da cjajpi quir tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pe i nesta gui tzu̱jʉ ca Ocja̱, como nuca̱ i pɛhtzi ʉ́r ttzɛdi da möjtiquijʉ cja̱ diguebbʉ ya da gu̱hquijʉ pʉ jabʉ jin gui tzö, pʉ jar infierno. Guehca̱ rí ntzöhui gui tzu̱jʉ‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dyo guí tzu̱jʉ ca te da ncjahquijʉ. Gui mbe̱nijʉ cʉ tzi ttzʉntzʉ cʉ i bbö cʉtta por yojtsjɛ tzi domi. Jin tza te i mu̱hui‑cʉ́, pe car Tzi Ta ji̱tzi bí janti bbʉ te i cja‑cʉ́. Jin gui da̱be̱ni‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Cja̱ nuquɛjʉ, más guí ndo mu̱diguɛjʉ ni ndra ngue cʉ ttzʉntzʉ drá ngu̱. Dyo guí tzu̱jʉ bbʉ́, ca te da ncjahquijʉ, como car Tzi Ta ji̱tzi i föhquijʉ hne̱je̱, hasta i pa̱di tengu̱ yir xta̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Dí xihquijʉ ya, ca to jin da mɛhtzi ʉ́r tzö drí xij yʉ cja̱hni i tɛnguigö, bbʉ xta bböj yʉ cja̱hni delante quí anxe cam Tzi Ta, guejtigö, gu ma̱ngö, ʉm cja̱hnigö‑ca̱, xí ndɛnguigö. Nugö dúr cja̱hni, xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nu ca to da mɛhtzi ʉ́r tzö delante yʉ cja̱hni, cja̱ da ma̱, jin gui tɛnguigö, bbʉ xta bböj yʉ cja̱hni delante quí anxe cam Tzi Ta, guejtigö, gu ma̱ngö, jin te ʉm ncjagöbbe‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bbʉ da ma̱n hnar cja̱hni, jí̱ rí ntzöhui da tti̱zquigö, i bbʉh car manera pa da mperdonabi. Guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. Pe bbʉ to da zan ca i øti car Espíritu Santo, bbʉ da ma̱, gue ca Jin Gui Jo xí dyøti‑ca̱, jin da mperdonabi car cja̱hni‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bbʉ da ttɛnquijʉ pʉ jáy ni̱cja̱ cʉ judio, o ja nzöya, o jabʉ pé i bbʉh cʉ autoridad, dyo cjuá gui ntzohmijʉ te gui tja̱dijʉ, o te gui ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gue car Espíritu Santo xta xihquijʉ mero car hora‑cá̱ ter bɛh ca̱ gui tja̱jmʉ.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hnar hñøjø ca már yojmʉ cʉ cja̱hni rá ngu̱, bi xifi, i̱na̱: ―Maestro, xih tzʉ nʉm cjua̱da̱ gu jebbe car herencia xí ttzoguije.― ");
INSERT INTO otsNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nu car Jesús bi xifi: ―Nuquɛ, tada, ¿tema cargo dí ja̱gö pa gu reglaqui quir asuntojʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Cja̱ pé bi xih quí möxte, bbʉ, i̱mbijʉ: ―Gui jña̱jʉ ʉr huɛnda. Jin da ma ir mʉyjʉ yʉ cosa hua jar jöy. Masque drá ngu̱ cosa i pɛhtzi hnar cja̱hni, jin gui gue yʉ cosa‑yʉ da un cár nzajqui o da jñu̱htibi cár tzi mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Cja̱ bi xijmʉ hnar bbede gá comparación, bi hñi̱mbijʉ: ―Ca hnar rico ya, mí ndo tjɛ quí jöy, cja̱ mí ndo joh quí semilla. ");
INSERT INTO otsNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Cja̱ bi mbe̱ntsjɛ guegue, bbʉ́, bi ma̱: “¿Te gu cjajpi yʉm semilla rá ngu̱? porque ya xqui u̱jtjo jabʉ gu pɛhtzi.” ");
INSERT INTO otsNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nubbʉ́, bi ma̱: “Gu øte ncjahua, gu yøhti cʉm ngu̱ jabʉ dí pɛhtzi cʉm semilla, cja̱ gu xoxi pé dda ngu̱ más drá nojo, pa gu pɛhtzi pʉ göhtjo cʉm semilla. ");
INSERT INTO otsNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Cja̱ bbʉ ya xcrú cuajti göhtjo yʉ xtú jmu̱ntzi, ya jin gu pɛfi, como da zö‑yʉ pa rá ngu̱ cjeya gu tzi. Nubbʉ, jin gu pɛfi, gu tzöyatjo. Gri ju̱jcua gu ñu̱ni, gu øti mbaxcjua cja̱ gu mpöjö.” Ncjapʉ gá ma̱n car hñøjø‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pe diguebbʉ ya, ca Ocja̱ bi nzofo, i̱mbi: “Nuquɛ, nttzɛditjo gúr dondo. Rá nxu̱nya, xquí tu̱. Nuya bbʉ, ¿toca̱ da cjajpi ʉ́r mɛjti yʉ cosa rá ngu̱ yʉ xcú jmuntzi?” Ncjapʉ bi tsjih car rico‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nugö, pé dí xihquijʉ, göhtjo dondo cʉ cja̱hni cʉ i jmuntzi rá ngu̱ quí mɛjtijʉ, cja̱ i mbe̱ni te drí cjajpijʉ, pe jin gui mbe̱n ca Ocja̱ pa da dyøti ca i ne‑cá̱.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Diguebbʉ ya car Jesús bi xih quí möxte, bi hñi̱na̱: ―Nuquɛjʉ, dí xihquijʉ, dyo cjuá guí mbe̱nijʉ ja grí hmʉpjʉ cja̱ co te gui tzijʉ. Dyo cjuá gui mbe̱n yir cuerpojʉ, te da jie. ");
INSERT INTO otsNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Car Tzi Ta ji̱tzi xí ddahqui quer nzajquijʉ. ¿Cja jin da ddahquijʉ hne̱je̱ ca guí nesta pa gui tzijʉ? Guejtjo xí ddahqui quir cuerpojʉ. ¿Cja jin da ddahquijʉ hne̱je̱ ca te gui jiejʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gui mbe̱nijʉ ja i ncja cʉ ttzʉntzʉ. Jin gui ponttɛy cʉ, jin gui xattɛy. Jin gui pɛhtzi ttu̱ pʉ jabʉ di jmuntzi car semilla. Nu quer Tzi Tajʉ ji̱tzi i jui̱jqui cʉ, i wi̱ni. Cja̱ nuquɛjʉ, más guí ndo mu̱huijʉ ni digue cʉ ttzʉntzʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Cja di bbʉh hnaa diguehquɛjʉ ca di pa̱di da tøhtzi madé metro cár cuerpo, pa más drá nte? Ji̱na̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jin guí pa̱dijʉ gui dyøtijʉ‑ca̱. Nubbʉ, ¿dyoca̱ guí ndo mbe̱nijʉ jabʉ drí hñe̱h quir da̱jtu̱jʉ cja̱ co ca te gui tzijʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gui mbe̱nijʉ ja i ncja cʉ tzi døni cʉ i jø nʉ jar jua̱ji̱. Jin gui pɛh‑cʉ, cja̱ jin gui pa̱di da dyøti tema da̱jtu̱. Nugö, dí xihquijʉ car rey Salomón bbʉ mí je quí da̱jtu̱ más már ma̱di cja̱ más már njuɛhtzi, jin di ni̱gui rá tzi zö ncja cʉ tzi døni. ");
INSERT INTO otsNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nu car Tzi Ta ji̱tzi xí dyøti cʉ tzi døni pa da ni̱gui rá tzi zö. Nʉr pa ya, i bbʉjtjo, i jø nʉ jar jua̱ji̱. Xu̱di xta tsja co cʉ paxi, pa da ddʉti. Hne̱hquiguɛjʉ, ¿cja jin da nu̱quijʉ ca Ocja̱ hne̱je̱? Ngu̱ jin tza guí e̱me̱jʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dyo cjuá guí ntzøtijʉ jabʉ drí hñe̱h ca gui tzijʉ. Dyo guí yomfe̱nijʉ ¿cja da möxquijʉ ca Ocja̱ pa gui hmʉpjʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yʉ cja̱hni yʉ jin gui e̱me̱ ca Ocja̱ i ndo pɛjmʉ, göhtjo mbo ʉ́r mʉyjʉ, pa drí dötijʉ cʉ cosa‑cʉ. Nuquiguɛjʉ, quer Tzi Tajʉ ca bí bbʉ ji̱tzi, bí pa̱di göhtjo ca te guí nestajʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nuquiguɛjʉ, gui uni ir mʉyjʉ, gui jionijʉ ca Ocja̱, cja̱ gui dyøtijʉ ca i ne guegue, pa da tte̱me̱bi cár palabra. Nubbʉ, ca Ocja̱ da ddahquijʉ göhtjo cʉ pé dda cosa cʉ guí nestajʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Dyo guí tzu̱jʉ, nuquɛjʉ ʉm tzi dɛtiquijʉ. Masque te guí tzi ngu̱dijʉ, pe ya xí ma̱n quer Tzi Tajʉ ji̱tzi gui möjmʉ grí hmʉpjʉ pʉ jabʉ i mandado guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gui pöjʉ ca guí pɛhtzijʉ, gui jejquibijʉ cʉ probe. Da ncjapʉ gui jmu̱ntzi quir mɛjtijʉ pʉ jar ji̱tzi. Nucʉ, jin da tjeh‑cʉ, como jin gui tzøm pʉ cʉ be̱, cja̱ jin gui bbʉ ta̱ni zu̱we̱ pʉ, pa da deh cʉ guí pɛhtzijʉ. Porque bbʉ gui jmuntzijʉ domi hua jar jöy, nde̱jma̱ da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bbʉ gui jmuntzijʉ rá ngu̱ quir mɛjtijʉ hua jar jöy, gue nʉr jöy gui mbe̱nijʉ, bbʉ. Pe bbʉ gui jmuntzijʉ ca rá zö pʉ jar ji̱tzi, nubbʉ, guehca̱ gui mbe̱nijʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Gui tøhmijʉ ter hora da zøh quer Tzi Jmu̱jʉ, cja̱ gui mbe̱nijʉ, cierto xtu e̱je̱. Gui hmʉpjʉ listo. ");
INSERT INTO otsNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gui cjajʉ ncja ngu̱ cʉ mɛfi cʉ i tøhmi cár patrónjʉ, ter hora du e̱je̱. Guegue‑ca̱ xí ma jar ntja̱jti cja̱ jin gui fa̱di ter hora da zøjø. Cʉ mɛfi i tøhmitjojʉ, pa bbʉ xta zøjø cja̱ xta ddooti car goxtji, xní bböpjʉ, xní xojquibijʉ nguetica̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bbʉ xta zøh cár jmu̱jʉ cja̱ xta döti cʉ mɛfi dra øtitjojʉ ca xquí bbɛjpijʉ, da ndo mpöh cʉ mɛfi, bbʉ. Ntju̱mʉy, dí xihquijʉ, car jmu̱ da bbɛjpi quí mɛfi da mi̱pjʉ jar mexa, cja̱ guejtsjɛ guegue da sirvebi, da wi̱n‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Cja̱ bbʉ xta zøh car patrón, ya xtrú ndo nxu̱y, o bbʉ ya xtrú tjo madé ʉr xu̱y, o ya xní ma da ni̱gui, nde̱jma̱ da ndo mpöh cʉ mɛfi ca xcá ndøhmitjojʉ hasta bbʉ xcá nzøh cár jmu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pa gui pa̱dijʉ ja da ncja bbʉ pé xcuá cojcö, dí xihquijʉ, xcuá hna e̱tjo ncja hnar be̱. Bbʉ di ba̱h car mi̱ngu̱ ter hora di zøh car be̱, di zötjo, di dyøjtjo pa jin di jiɛgui di ñʉti pʉ́r ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Guehquitjoguɛjʉ, dí xihquijʉ, gui tzödijʉ, gui tøbiguijʉ, gui hmʉpjʉ listo, porque car hora ca guí ma̱jmʉ jin te da ncja, xcuá hna cojcö car hora‑ca̱. Nugö dúr cja̱hni xpá bbɛnquigö hua jar jöy.― Ncjapʉ gá xih quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nubbʉ, car Pedro bi dyön car Jesús, bi hñi̱mbi: ―Nuquɛ, Maestro, ¿cja xcú ma̱ nʉr bbede‑nʉ pa göhtjo yʉ cja̱hni, cja huá jønguitjogöje guí xijquije, gu cjaje ncja ngu̱ cʉ mɛfi cʉ i tøhmi cár patrónjʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Car Tzi Ta Jesús bi ma̱n ya bbʉ: ―Dí nzofo göhtjo yʉ i ntju̱mʉy da dɛngui. Guegue‑yʉ da jñɛjmʉ car mayordomo ca bi ttzogui pa di jianti cʉ pé dda mɛfi cʉ mí pɛjpi cár jmu̱, cja̱ pa di un car jñu̱ni ca mí tocabijʉ. Car mɛfi‑ca̱, i ndo pa̱di rá zö cár bbɛfi, cja̱ i øte göhtjo ca i ma̱n cár jmu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bbʉ xta zøh cár jmu̱ cja̱ da döti dra øti ca xquí bbɛjpi, nubbʉ, da ttuni hnar tja̱ja̱ drá ndo zö, cja̱ da ndo mpöh, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cierto, dí xihquijʉ, cár jmu̱ da hñi̱x car mɛfi‑ca̱ pa da cca̱htibi göhtjo cʉ i pɛhtzi. ");
INSERT INTO otsNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nu car mɛfi ca xí ttun cár cargo, bbʉ da mbe̱ntsjɛ mbo ʉ́r mʉy: “Ya xpá ndo dé cam jmu̱ ya, ya jin du e̱j ya,” cja̱ bbʉ da mʉdi da ʉn cʉ pé dda mɛfi cja̱ co cʉ muza, pe guejtsjɛ guegue da ñu̱ni rá zö, dír zo ʉr mbaxcjua cja̱ da nti̱, ");
INSERT INTO otsNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nubbʉ, xtu hna e̱h cár jmu̱jʉ car pa ca jí̱ mí ddøhmi. Car hora ca mí jma̱ jin di hñe̱je̱, xta hna zøjø, cja̱ da ndo castiga car mɛfi‑ca̱. Xta gu̱y drí ma pʉ jabʉ i bbʉh cʉ cja̱hni cʉ jí̱ xcá dyøti ca xquí ma̱n ca Ocja̱, cja̱ da ttun cár castigo, drá ndo ʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Da ndo ncastiga car mɛfi‑ca̱, porque mí pa̱di te mí ne cár jmu̱ pe jin gá dyøte, bi jiɛjtjo. ");
INSERT INTO otsNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nu car mɛfi ca jí̱ mí pa̱di te mí ne cár jmu̱, cja̱ jin gá dyøti ca rá zö, guejtjo da ncastiga‑ca̱, pe da tzi meno car castigo ca da ttuni. Nu car mɛfi ca xí ttun cár cargo rá ngu̱, como mí pɛhtzibi confianza cár jmu̱, da nesta da dö rá ngu̱ cár bbɛfi. Yʉ mɛfi yʉ i ndo tte̱me̱, cja̱ i ttuni rá ngu̱ cár cargojʉ, da ndo ttöjpi rá ngu̱ car bbɛfi ca xtrú dyøti‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Cja̱ pé bi ma̱n car Jesús: ―I jñɛjmi ʉr tzibi nʉr ddadyo jña̱ nʉ xtá ja̱ hua jar jöy. ¡Quiera ya xtrú ndɛ car tzibi‑ca̱! ");
INSERT INTO otsNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","I nesta gu nu̱gö hnar sufrimiento drá ndo ʉ́, cja̱ jin da jñu̱ ʉm mʉy hasta gue bbʉ gu tjojcö‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nuquɛjʉ, pé ntoja guí mbe̱nijʉ, xtú e̱cö hua jar jöy pa gu juejqui yʉ cja̱hni yʉ i ntu̱jni. Ji̱na̱, dí xihquijʉ, xtú e̱cö pa gu cjajpi yʉ cja̱hni da ncontrajʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dí xihquijʉ, desde rá pa ya, hnar ngu̱ pʉ jabʉ i bbʉ cʉtta cja̱hni, da ncontrahui cʉ jñu̱, cʉ pé yojo, como cʉ ddaa da hñe̱me̱gui, nʉ cʉ pé ddaa ya, da ʉgui. ");
INSERT INTO otsNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Car mi̱ngu̱ da ʉhui cár ttʉ, cja̱ car ba̱jtzi da ʉhui cár ta. Car na̱na̱ pʉ jar ngu̱ da ʉhui cár tti̱xu̱, cja̱ car tzi bbɛjña̱tjo da ʉhui cár me. Car na̱na̱ da ʉhui cár ttzijuɛ, cja̱ cár ttzijuɛ da ʉhui cár cö.― Ncjapʉ gá xih quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Diguebbʉ car Jesús bi nzoh cʉ cja̱hni rá ngu̱, bi hñi̱mbijʉ: ―Bbʉ guí jantijʉ, ya xpá mbøx cʉ gu̱y, guí ma̱jmʉ, ya xpa e̱h car dye. Nubbʉ́, i wa̱h bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Cja̱ bbʉ guí jantijʉ, i dyo car nda̱ji̱ rí hñe̱ jar sur, guí ma̱jmʉ, cierto da ncja jiadi. Cja̱ i ncjapʉ, hne̱. ");
INSERT INTO otsNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Guí jiöjtejʉ. Guí pa̱dijʉ te i ne da ma̱n cʉ gu̱y co car nda̱ji̱. Guí jantijʉ car ji̱tzi pa gui pa̱dijʉ tema tiempo da ncja hua jar jöy. ¿Sa jin guí pa̱dijʉ te i ne da ma̱n yʉ xcú cca̱jtigöjʉ dár øtigö yʉ pa ya? Dyoca̱ guí nejʉ da ttahquijʉ seña pa gui pa̱dijʉ, ¿cja ya xí nzøh ca hnar cja̱hni ca bi ma̱n car Tzi Ta ji̱tzi di hñe̱je̱? ");
INSERT INTO otsNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nuquiguɛjʉ, ¿cja jin guí pa̱tsjɛjʉ ter bɛh ca̱ i tzøh car Tzi Ta ji̱tzi? I nesta gui dyøtijʉ‑ca̱ menta i cjadi tiempo. ");
INSERT INTO otsNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bbʉ da ttzixquihui jar nzöya, nuquɛ, cja̱ co hner contra ca xcrú huɛnihui, gui mbe̱ni nttzɛdi ja grí reglatjohui, menta gá pɛhui jar hñu̱. Porque bbʉ ya xtí tzønihui pʉ jabʉ i ttøti jujticia, cja̱ jí̱ bbe gui reglahui, nubbʉ, car nzʉttabi da döqui jár dyɛ car nzöya, cja̱ guegue‑ca̱ da mandado pa da cjohqui födi. ");
INSERT INTO otsNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Dí xihqui, jin da tjɛqui gui pøx pʉ hasta gue bbʉ ya xcrú cju̱ti göhtjo car multa ca da ttöhqui.― Ncjapʉ gá ma̱n car Jesús. Tzʉdi, guejtjo i bbʉh ca hnar Nzöya ca bí bbʉ ji̱tzi. Guegue‑ca̱ da ncjadipʉ, da jña̱nquijʉ ʉr huɛnda digue ca dí øtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mismo cʉ pa cʉ́, bi cjöx car Jesús, bi tsjifi, i̱mbijʉ: ―Xí bböhti cʉ dda mi̱ngu̱ Galilea. øde, car Pilato bi mandado bi bböhti‑cʉ́, cja̱ quí cji cʉ cja̱hni ya, bi hua̱nihui quí cji cʉ zu̱we̱ cʉ már ña̱htibijʉ ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bi da̱h car Jesús, bbʉ́, bi hñi̱mbijʉ: ―Ntoja guí ma̱nguɛjʉ, mí ndo ndu̱jpite cʉ cja̱hni‑cʉ́, más mí ndo ndu̱jpite ni digue cʉ pé dda mi̱ngu̱ Galilea, eso xí jiɛh ca Ocja̱ xí bböhti. ");
INSERT INTO otsNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nugö, dí xihquijʉ jí̱na̱. Dí xihquijʉ guehquitjoguɛjʉ, parejo guí ndu̱jpitejʉ co cʉ ddaa cʉ xí bböhti. Cja̱ pé dí xihquijʉ, bbʉ jin gui repentijʉ, xquí hna tu̱jʉ ncjapʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Xí cʉ dieciocho hñøjø cʉ mí mi̱ngu̱ Jerusalén, nu cʉ bi zɛhmi car ntorre pʉ Siloé bbʉ mí yøte, ¿cja guí ma̱nguɛjʉ, más mí ndo ndu̱jpite‑cʉ́ ni digue cʉ pé dda mi̱ngu̱ Jerusalén? ");
INSERT INTO otsNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ji̱na̱ hne̱je̱. Dí xihquijʉ, bbʉ jin gui repentijʉ, da ncjadipʉ drí zʉhqui quer castigojʉ hne̱je̱, ncja ngu̱ gá nzʉh cár castigo guegue‑cʉ́.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Diguebbʉ ya car Jesús bi xih cʉ cja̱hni hnar bbede gá comparación, i̱na̱: ―Hnar hñøjø bi mandado bi hñi̱ti hnar za gá higo jár jardín. Cja̱ bbʉ ya xquí cja tengu̱ cjeya, car jmu̱ bi ma pʉ jár jardin, bú cca̱hti car za gá higo, pe jin te mí tu̱. Bi segue bi dyøti ncjapʉ tengu̱ vez. ");
INSERT INTO otsNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Diguebbʉ ya, car jmu̱ bi xih car jardinero, bbʉ́, i̱mbi: “Nu̱u̱, ya xí nzʉ jñu̱ cjeya, dé dá e̱je̱ dí cca̱hti nʉr za gá higo, hni̱, jin te i tu̱. ¿Te i pɛjcua jabʉ i jø? Mejor gu tzɛjqui.” ");
INSERT INTO otsNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bi da̱h car jardinero, i̱na̱: “Nuquɛ, Tzi Jmu̱, tøhmijma̱ nʉr cjeya‑yá, gu føhmi nʉr jöy, cja̱ gu jøhti lama. ");
INSERT INTO otsNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Diguebbʉ ya, ʉr cjeya, bbʉ da du̱u̱ cʉ higo, rá zö bbʉ́. Cja̱ bbʉ jin te xcá ndu̱ car cjeya‑cá̱, nubbʉ́, xtá tzɛjqui bbʉ guí netjo.” Ncjapʉ gá nda̱h car jardinero.― ");
INSERT INTO otsNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ca hnar nsabado, car Jesús már bbʉh pʉ jár templo cʉ judio, már u̱jti cʉ cja̱hni cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Cja̱ bi cca̱hti, már bbʉh pʉ hnar bbɛjña̱, xquí ntjɛhui cár nda̱ji̱ ca Jin Gui Jo, eso, mí jñi̱ni. Mí ántjo nguá hño, cja̱ jí̱ mí tzö di hmöy derecho. ");
INSERT INTO otsNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bbʉ mí cca̱hti car bbɛjña̱‑ca̱ car Jesús, bi nzofo, bi xifi: ―Nuquɛ, na̱na̱, ya xí wen quer jñi̱ni ya.― Bi hñi̱mbi ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Diguebbʉ ya, bi dyʉx quí dyɛ car Jesús, cja̱ exque bi joh car döhtji, bi hmöy rá zö, bi ncjua̱ngui cár xʉtja, bbʉ. Cja̱ car bbɛjña̱ ya, bi ndo xöjtibi car Tzi Ta ji̱tzi, bi dyöjpi mpöjcje. ");
INSERT INTO otsNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nu car hñøjø ca már dirigi car tsjödi, bi ndo ungui ʉr cuɛ, porque car pa‑ca̱ múr pa ca mí tzu̱jpi cʉ judio, nu car Jesús, nde̱jma̱ bi jojqui hnar döhtji. Eso, car hñøjø‑ca̱ bi huɛnti cʉ cja̱hni cʉ xquí jmuntzijʉ, bi hñi̱mbijʉ: ―Jin gui tzö ca i øti nʉr cja̱hni‑nʉ, porque i dyøtje döhtji nʉr pa nsábado. I bbʉ ddajto mpa cʉ rí ntzöhui gui pɛjmʉ o gui hñøtjejʉ, meno nʉr pa nsábado. Bbʉ guí ne gui hñøtjejʉ, i nesta gu e̱jmʉ cʉ pé dda ddajto mpa.― Bi ma̱ ncjapʉ car hñøjø‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nu car Tzi Ta Jesús bi da̱di, bi hñi̱mbi: ―Nuquiguɛjʉ, rá ndo ntjötiquiguɛjʉ. Guí göhtjojʉ, ¿cja jin guí tzijtijʉ deje quir nda̱nijʉ cja̱ co quir burrojʉ nʉr pa nsábado? Guí jui̱jquitjojʉ quir zu̱we̱jʉ rá pa ya. Xigö ya, ¿cja jin gui tzö ca dár jui̱jqui yʉ döhtji rá pa ya hne̱je̱? ");
INSERT INTO otsNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Cja jin gui tzö ca xcá joj nʉr bbɛjña̱‑nʉ, xí zötjo, nʉr pa nsábado ya? Dí ma̱ngö, rá ndo zö, como guejti‑nʉ́, ʉ́r cji ca ndom titajʉ Abraham. Mír ntzöhui gua cjʉhtzibi cár jñi̱ni rá pa ya, como ya xí nzʉ dieciocho año ca xcá nguati cár nda̱ji̱ car Satanás.― ");
INSERT INTO otsNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bbʉ mí ma̱ ncjapʉ car Jesús, bi ncja í tzö quí contra, como jin gá mba̱di te pé drí da̱dijʉ. Nu cʉ pé dda cja̱hni bi mpöjmʉ, ca gá zö car bbɛjña̱ ca múr döhtji jma̱ja̱. Bi mpöjmʉ, como mí ndo ni̱gui cár ttzɛdi car Tzi Ta ji̱tzi por rá ngue cʉ milagro cʉ mí øti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Diguebbʉ ya, car Jesús bi xih cʉ cja̱hni: ―Pé gu xihquijʉ ya ja ncja ga mandado ca Ocja̱ hua jar jöy. Gu jɛqui cár jmandado ca Ocja̱ co hnar cosa ya xcú cca̱htijʉ, pa gui pa̱dijʉ ja i ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I ncjá ncja ngu̱ hnár tzi ndö ʉr murtaza ca bi dyɛnti hnar hñøjø pʉ jár jardín. Nttzɛditjo mí chi tchʉ car semilla‑ca̱, pe bi bøtze, bi te, ncja hnar tzi za. Bú e̱h cʉ tzi ttzʉntzʉ, bi ndøh pʉ jáy dyɛ car planta.― Da ncjadipʉ drí ngu̱jqui yʉ cja̱hni yʉ da hñe̱me̱bi nʉ́r palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Cja̱ pé bi ma̱n car Jesús, i̱na̱: ―Pé gu xihquijʉ pé hnar palabra gá ejemplo, pa gui pa̱dijʉ ja ncja ga ngu̱jqui cár jmandado ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nʉ́r palabra ca Ocja̱ i jñɛjmi car levadura ca i hua̱nihui rá ngu̱ car harina pa da ttøti ttu̱jme̱. Es xi jñu̱ ttɛni gá harina xí ñʉti pʉ, cja̱ hna tzi tʉjquitjo car levadura, pe nucá̱, i dyo göhtjo car cjʉni, i cjajpi da mføntzi.― Car Jesús bi nzoh cʉ cja̱hni por rá ngue yʉ tzi bbede‑yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Diguebbʉ ya, bi ma car Jesús. Bi bøm pʉ pa drí ma Jerusalén. Bi tjoh cʉ dda jñi̱ni rá nojo co cʉ dda tzi jñi̱nitjo hne̱je̱, má u̱jti cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ca hnar cja̱hni bi dyön car Jesús nʉr nttöni‑nʉ́: ―Nuquɛ, Tzi Jmu̱, ¿cja drá ngu̱ cʉ cja̱hni cʉ da nsalva, da döti car nzajqui ca jin da tjegue?― Cja̱ guegue bi da̱di, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Gui uni ir mʉyjʉ gui cʉtijʉ jar goxtji rá nttzʉhti, menta i xojtjo. Ba e̱h car pa bbʉ xta ne rá ngu̱ cʉ cja̱hni da ñʉti, pe ya jin da jogui da ñʉtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Car pa‑cá̱, ya xtrú bböh car mi̱ngu, ya xtrú ngoti car goxtji. Nubbʉ, masque xquí hmöjtijʉ pʉ tji, xquí ddootijʉ car goxtji, ya jin da jogui gui cʉtijʉ pʉ. Nubbʉ, xquí xijmʉ car mi̱ngu̱: “Nuquiguɛ, Tzi Jmu̱, xoguije tzʉ nir goxtji, pa gu cʉtije.” Pe guegue da da̱di: “Jin dí pa̱di jabʉ xquí hñe̱jmʉ. Jin dí meyaquijʉ.” ");
INSERT INTO otsNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Diguebbʉ ya, pé xquí xijmʉ car mi̱ngu̱: “Dyøjma̱ja̱, Tzi Jmu̱, guí meyaguitjoje, hasta hnadi pʉ dú tzijʉ, cja̱ nuquiguɛ, gú u̱jtiguije quer tzi palabra pʉ jam ngu̱je.” ");
INSERT INTO otsNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nu guegue pé da da̱di: “Dí xihquijʉ, jin dí pa̱di to í cja̱hniquiguɛjʉ. Wenijʉ ya, como guí ndu̱jpitejʉ.” Da ma̱ ncjapʉ car mi̱ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nuquɛjʉ, guí israelitajʉ, dí xihquijʉ, ba e̱h car pa bbʉ xtí cca̱htijʉ cár jmandado cam Tzi Ta ji̱tzi cja̱ co te da ncja pʉ. Nubbʉ, xquí cca̱htijʉ cʉ ndom titajʉ, nu car Abraham, co car Isaac, co car Jacob cja̱ co göhtjo cʉ profeta cʉ mí bbʉ ya má yabbʉ, guegue‑cʉ́ dra bbʉh pʉ jabʉ i mandado ca Ocja̱, cja̱ nuquɛjʉ, jin gui cʉtijʉ pʉ, gui cojtijʉ pʉ tji. Nu pʉ tji, xquí ndo nzonijʉ cja̱ xquí ndo ntzøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nubbʉ́, cʉ hnahño cja̱hni cʉ cjá xí dyøjmʉ ja i ncja ca Ocja̱, du e̱jmʉ desde pʉ jabʉ ba pøx nʉr jiadi, cja̱ co pʉ jabʉ rí ñʉy, du e̱jmʉ desde jar norte, cja̱ co desde jar sur. Masque jin gui israelita‑cʉ́, xta ñʉti pʉ jabʉ i mandado ca Ocja̱, da dyøtijʉ mbaxcjua. Nuquiguɛjʉ, guí israelitajʉ, xquí cojtijʉ pʉ tji. ");
INSERT INTO otsNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nubbʉ́, cʉ dda cja̱hni cʉ jin tza i pa̱di, yʉ pa ya, ja i ncja ca Ocja̱, da ñʉti‑cʉ́ pʉ jabʉ i bbʉ guegue. Cja̱ yʉ dda cja̱hni yʉ xí ndo nxöjmʉ cár palabra ca Ocja̱, da gojmʉ xʉtja, ni mpa da ñʉtijʉ pʉ.― Car Jesús bi xih cʉ cja̱hni yʉ palabra‑yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mismo car hora‑cá̱, bú e̱h cʉ dda fariseo, bi göx car Jesús, bi xifi: ―Gui ddaj ya, wengua ya, porque ya xqui ne da möjtiqui car Herodes.― ");
INSERT INTO otsNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nu car Jesús bi da̱di, bi xih‑cʉ: ―Má bú xijmʉ car jiöjte Herodes, gui hñi̱mbijʉ: “I ma̱n car Jesús, Rá pa ya dí fongui cʉ nda̱ji̱ cʉ jin gui tzö, cja̱ dí jojqui döhtji. Gu ncjadipʉ ʉr xu̱di hne̱je̱. Hasta bbʉ xtrí zʉ jñu̱jpa, cja̱ gu cjuajti nʉr bbɛfi dí øte.” Da ncjanʉ grí xijmʉ car Herodes. ");
INSERT INTO otsNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cja̱ pé dí xihquijʉ, gu tɛn cam hñu̱ rá pa ya cor xu̱di, cja̱ ʉr ma̱ni xtá tzøngö pʉ jabʉ drá ma. Jí̱ rí ntzöhui da bböjtigui hua, como guehpʉ Jerusalén rá bböhti cʉ profeta, desde ya má yabbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nuquɛjʉ, guí mi̱ngu̱jʉ Jerusalén, segue guí pöhtijʉ cʉ profeta, guí ccajnijʉ me̱do yí jmandadero car Tzi Ta ji̱tzi yʉ mbá pɛjni guegue pa drí nzohquijʉ. Guejquitjogö, xtú nzohquijʉ rá ngu̱ vez, ncja hnar tzu̱huade ga nzoh quí tzi huadetjo da guati, pa da juitzi. Pe nuquɛjʉ, jí̱ xquí ne xquí cuajquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dyøjma̱jʉ ya, ya xpa e̱h car pa bbʉ xta tjøhti quir ngu̱jʉ, como ya xta zoquijʉ car Tzi Ta ji̱tzi. Nugö dí xihquijʉ, ya jim pé gui cca̱jtiguijʉ, desde rá pa ya sta gue bbʉ xtí xijquigöjʉ: “Car Tzi Ta ji̱tzi da bendeci nʉr hñøjø nʉ ya xpa e̱je̱, guejnʉ xpá mɛjni guegue pa da mandadoguije.”― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ca hnar pa nsábado, hnar fariseo ca mí ja̱ cár cargo bi mvitabi car Jesús di ma pʉ́r ngu̱, du tzi pʉ. Cja̱ cʉ pé dda fariseo cʉ már bbʉh pʉ, már cca̱htijʉ, ¿ter bɛh ca̱ di dyøti car Jesús? Como múr pa gá nttzöya car pa‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Cja̱ nu̱jma̱, már bbʉjti pʉ hnar hñøjø, mí jñi̱ni, xquí nen cár cuerpo. ");
INSERT INTO otsNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Car Jesús bi nzoh cʉ maestro co ni cʉ fariseo cʉ már cca̱htijʉ guegue, bi dyöni, i̱na̱: ―¿Te i ma̱n car ley? ¿Cja i jogui da ncja nttøtje nʉr pa nsábado cja huá ji̱na̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nu gueguejʉ, jin te gá nda̱dijʉ. Nubbʉ́, car Jesús bi zɛtibi cár dyɛ car döhtji, bi zitzi hnanguadi, cja̱ bi jojqui. Cja̱ car döhtji bi ma ʉ́r ngu̱ bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Diguebbʉ, car Jesús bi xih cʉ fariseo cʉ már bbʉh pʉ: ―Xiquiguɛjʉ, ¿te güi dyøtijʉ bbʉ di tzoh hnar jñe̱ hner burro o hner nda̱ni nʉr pa nsábado? ¿Cja gra bböjtijʉ pʉ, cja güi jiɛjtijʉ? ¿Cja jin güi cjʉxjʉ‑cá̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gueguejʉ ya, jin gá mba̱di te drí da̱dijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Diguebbʉ car Jesús bi jianti cʉ cja̱hni cʉ xquí ttzofo pa di zijʉ pʉ. Mí juajnijʉ cʉ tju̱jni cʉ más már zö. Cja̱ guegue bi xijmʉ bbʉ́, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Bbʉ da ttzohqui hnar mbaxcjua pa gui ma tzi, jin gui ma gui jñu̱xti car tju̱jni ca más rá zö, porque tal vez da zøh hnar hñøjø más i ntju̱mʉy ni diguehquɛ. ");
INSERT INTO otsNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nubbʉ́, xtu e̱h car mi̱ngu̱ ca bi nzohqui, xta xihqui: “Gui u̱ni tzʉ quer tju̱jni nʉr tada‑nʉ́.” Cja̱ nuquɛ ya, xquí pɛhtzi ir tzö, xquí un car tju̱jni‑cá̱, cja̱ gui ma mi̱jti pʉ jabʉ jin tza i ntju̱mʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bbʉ da ttzohqui hnar mbaxcjua, gui ma bú mi̱jti pʉ jabʉ xí mi̱h cʉ cja̱hni cʉ jin tza i ntju̱mʉy. Diguebbʉ ya, bbʉ xta ne car mi̱ngu̱, du e̱je̱, da xihqui: “Amigo, dí ddaxcua jabʉ rá zö.” Nubbʉ, da jiantiqui cʉ ddáa cʉ gár tzihui, guí tzi ntju̱mʉyguɛ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ca to da hñi̱xtsjɛ, da hmɛtibi ʉ́r tzö, cja̱ nu ca to jin da hñi̱xtsjɛ, da nrespetabi‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Diguebbʉ ya, car Jesús bi nzoh car cja̱hni ca xquí mvitabi, imbi: ―Bbʉ gui dyøti hnar mbaxcjua, hnar cena o hnar jñuni, jin gui jøntsjɛ quir amigo co quir cjua̱da̱ co quir mi̱ni co quir hnangu̱ cʉ i tzi ja̱jʉ gui mvitabi. Bbʉ gui mvitabi‑cʉ́, pé xta mvitaqui quí mbaxcjuajʉ. Nu ca Ocja̱, ya jin da cozqui ca gú dyøte. ");
INSERT INTO otsNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nuquiguɛ, bbʉ gui dyøti hnar mbaxcjua, gui mvitabi cʉ probe, co ni cʉ jin gui zøti ʉ́r cuerpo, co ni cʉ dohua, cja̱ co cʉ godö. ");
INSERT INTO otsNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nubbʉ, ca Ocja̱ da möxqui, porque cʉ cja̱hni‑cʉ́, jin te i ja̱ pa pé drí cozquijʉ. Bbʉ xta ncja car juicio, cja̱ xta nantzi cʉ ánima cʉ mí e̱me̱jʉ ca Ocja̱, nubbʉ́, da ttahqui quer tja̱ja̱, bbʉ.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ca hnar cja̱hni ca már tzi pʉ hne̱, bbʉ mí dyøh ca mí ma̱n car Jesús, bi ma̱ guegue, i̱na̱: ―Da ndo mpöh cʉ cja̱hni cʉ da nú̱jʉ bbʉ xta mandado ca Ocja̱ hua jar jöy cja̱ da guatijʉ car ndo mbaxcjua ca da dyøti‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nu car Jesús bi da̱di, bi xih hnar bbede gá ejemplo digue ja i ncja cʉ cja̱hni cʉ bi ttzofo pa di ñʉti pʉ jabʉ i mandado ca Ocja̱. Bi ma̱ ncjahua: ―Mí bbʉh ca hnar hñøjø, bi dyøti hnar ndo mbaxcjua gá cena, cja̱ bi mvitabi rá ngu̱ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bbʉ mí zøh car hora, bi gu̱h cár mɛfi di ma du nzoh cʉ cja̱hni cʉ xquí mvitabi, du xijmʉ: “Bú e̱jmʉ ya, ya xí joh car jñuni.” ");
INSERT INTO otsNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nuya cʉ xquí mvitabi, jin guá ne guá hñe̱jmʉ. Cada hnaa‑cʉ́ bi xifi te rá nguehcá̱ jin di ma. Ca hnáa bi ma̱, i̱na̱: “Cja xtú töngö hnar jua̱ji̱, i nesta gu ma cca̱hti. Despensagui, hnar favor.” ");
INSERT INTO otsNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ca hnáa bi ma̱, i̱na̱: “Cja xtú töngö cʉtta yunda cʉ nda̱ni. I nesta gu ma tzö. Despensagui hnar favor. Jin gui tzö gu e̱je̱.” ");
INSERT INTO otsNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nu ca pé hnáa bi ma̱: “Cja xtú ntja̱jtigöbbe cam bbɛjña̱. Jin gui tzö gu ma. Despensagui hnar favor.” ");
INSERT INTO otsNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Car mɛfi bú coh bbʉ, bi xih cár jmu̱ te xcuí ma̱n‑cʉ́. Nubbʉ, cár jmu̱ bi ndo ungui ʉr cuɛ. Bi xih car mɛfi bbʉ: “Má nttzɛdi, gui hño nʉ jar jñi̱ni, gui tɛn cʉ calle co cʉ tzi hñu̱ cʉ i bbʉj nʉ. Ma bú tzí cʉ tzi probe cja̱ co cʉ te i cja quí cuerpo, cʉ godö, cʉ dohua.” ");
INSERT INTO otsNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bi dyøti car mɛfi ca xquí tsjifi, cja̱ pé bú coji, bi xih cár lamo: “Nuya, ya xtú coj ya, Tzi Jmu̱, ya xtú øti ca xcú mandado, cja̱ todavía i cjadi lugar pʉ jar mexa, pʉ jabʉ da zi cʉ cja̱hni.” ");
INSERT INTO otsNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Cja̱ car jmu̱ pé bi gu̱h car mɛfi, bbʉ, bi xifi: “Nuya, gui ma pʉ jar carretera, cja̱ co pʉ jáy nttza̱ni nʉr jñini, cja̱ gu tzí göhtjo cʉ gu ntjɛhui pʉ. Du e̱je̱ göhtjo‑cʉ, pa da ndʉ nʉm ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Dí xihqui ya, cʉ cja̱hni cʉ bbɛto xtú mvitabi, ni di hnaa‑cʉ́ da zi cam cena, nim pa da zöjʉ ¿cja rá ncʉji car jñuni?” Ncjapʉ gá ma̱n car tada‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Már ngu̱ cʉ cja̱hni má tɛnijʉ car Jesús. Guegue ya, bi bböti, bi xijmʉ, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Bbʉ to da guajquigö, i nesta da ndo negui. Más da negui ni ndra ngue ca i ne cár ta, co cár me, co cár bbɛjña̱, co quí ba̱jtzi, cja̱ co quí cjua̱da̱, co ni quí ncju̱. Guejtjo, más da neguigö ni ndra nguejtsjɛ guegue. Bbʉ da ndo ne‑yʉ, cja̱ jin tza da negui, jin da jogui da dɛnguigö, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bbʉ to i ne da dɛngui, jin da jiøjqui cár nzajqui. Masque xín da zö ca rá ʉ por rá nguejquigö, ncja ngu̱ hnar cja̱hni ca i ddøti pʉ jar ponti pa da du̱, pe da zɛjtitjojo. Da ncjapʉ drí dɛnguigö. ");
INSERT INTO otsNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bbʉ to i mbe̱ni da jiøh hnár ngu̱ rá nte, ante que da mʉdi, i nesta da ntzohmi, da dyʉti ʉr huɛnda, ¿cja da zö car domi drí guah car ngu̱? ");
INSERT INTO otsNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bbʉ di ji̱na̱, una vez ya xtrú dyøti cʉ cimiento, cja̱ ya jin gui pɛhtzi pa drí cjuajti, da jianti yí vecino, cja̱ da denijʉ bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Da ma̱jmʉ: “Jiantijma̱, nʉr tada xí fʉjti nʉ́r ngu̱, cja̱ nin tzö da cjuajti.” ");
INSERT INTO otsNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Guejti hnar rey, bbʉ i mbe̱ni da contrabi cár mi̱nga̱‑reyhui, bbɛto da mbe̱ni, da ña̱hui quí capitán cʉ i pɛjpi, da dyöni, ¿cja da da̱pi cʉ veinte mil quí contra, siendo guegue ddɛtta miltjo quí sundado i pɛhtzi? ");
INSERT INTO otsNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bbʉ i pa̱di jin da jiöti, menta ba e̱ti yanʉ car rey ca i ne da contrabi, da gu̱h hnar corrego, du öjpi mpaz. ");
INSERT INTO otsNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ncjadijma̱ nʉr cja̱hni nʉ i ne da dɛnguigö. Jin da jiøjqui quí mɛjti cja̱ jin da ndo ne‑cʉ́. I nesta da mbe̱ni, jin te i mporta göhtjo cʉ i pɛhtzi, pa drí dɛnguigö göhtjo mbo ʉ́r mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Cja̱ pé bi ma̱n car Jesús nʉ pé hnar palabra, ja da ncja cʉ cja̱hni cʉ i mbe̱ni da dɛni guegue. Bi hñi̱na̱: ―I ndo sirve car u̱. Pe bbʉ ya jin gui u̱xi, ¿te da ncjajpi pa pé drí u̱xqui, bbʉ? u̱jtjo. ");
INSERT INTO otsNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ya jin te i sirve, bbʉ. Nim pa da sirve gá lama pa da tjøti jar jöy. Da bbontjo. Yʉ to i bbʉj yí gu̱, da dyøde te i ne da ma̱n yʉ palabra yʉ xtú ma̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bbʉ már u̱jti cʉ cja̱hni car Jesús, pe bi guati cʉ jiöjte cja̱hni cʉ mí cobra cʉ contribución, co ni cʉ pé dda cja̱hni cʉ mí ndu̱jpitejʉ. Mí ne di dyødejʉ ca mí ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bbʉ mí nú̱ ya‑ca̱ cʉ fariseo, co cʉ maestro cʉ mí nxöh car ley, bi zohmijʉ car Jesús, bi ma̱jmʉ: ―Nʉr Jesús i ntzixihui yʉ cja̱hni rá nttzo, hnadi pʉ i tzihui‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Car Jesús ya bbʉ, bi xijmʉ hnar bbede gá comparación, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Hnar hñøjø mí hñi̱h hna ciento quí dɛjti, cja̱ bi bbɛh ca hnáa. Nubbʉ́ bi zoh cʉ noventa y nueve pʉ jar bbatja, cja̱ bi ma bú hño, bú jon ca hnaa ca xquí bbɛdi, hasta bbʉ mbú töti. ");
INSERT INTO otsNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nubbʉ́, bú cöxi ʉ́r xi̱hnxi̱, pé bú coji, mbá tzí cár dɛjti, cjuá mbá mpöjö. ");
INSERT INTO otsNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cja̱ bbʉ mí zøti pʉ jár ngu̱, bi nzoh quí amigo, co quí hnangu̱, bi xijmʉ: “Gu mpöjmʉ ya. Ya xtú töti nʉm tzi dɛti xtá bbɛdi.”― ");
INSERT INTO otsNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Cja̱ bi ma̱n car Jesús: ―Nugö dí xihquijʉ ya, ncjapʉ hne̱, nʉ jar ji̱tzi bí ndo ncja ʉr pöjö cada bbʉ ga repenti hnar cja̱hni ca i øti ca rá nttzo. Bí ndo ncja ʉr pöjö por rá ngue car cja̱hni‑cá̱, nu cʉ noventa y nueve cja̱hni cʉ i ma̱jmʉ jin gui ndu̱jpite cja̱ jin gui nesta da repenti, nucʉ́, jin gui pöjpi ʉ́r mʉy ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pé bi ma̱n car Jesús: ―Mí bbʉh hnar bbɛjña̱, mí pɛhtzi ddɛtta quí domi gá plata, cja̱ bi bbɛh ca hnáa. Nubbʉ́, bi tzøqui hnar tzibi, bi paxi jár ngu̱, bi jioni hasta bbʉ mí döti. ");
INSERT INTO otsNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bbʉ mí döti ya, bi nzoh quí amiga, co quí hnangu̱, bi xifi: “Gu mpöjmʉ ya. Ya xtú töti cam domi xtá bbɛdi.” ");
INSERT INTO otsNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cja̱ bi ma̱n car Jesús: ―Dí xihquijʉ, ncjapʉ hne̱, nʉ jar ji̱tzi bí mpöh quí anxe ca Ocja̱ bbʉ ga repenti hnar cja̱hni ca xí dyøti ca rá nttzo.― ");
INSERT INTO otsNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Diguebbʉ ya car Jesús pé bi xih cʉ cja̱hni pé hnar bbede, i̱na̱: ―Mí bbʉh ca hnar hñøjø, mí hñi̱ yojo quí ttʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Car ba̱jtzi ca múr menor bi xih cár ta: “Nuquɛ ta, dí ne ya gui ddajqui cam parte ca i tocagui.” Nubbʉ́, cár ta bi jejquibi cár herencia cʉ yojo quí ttʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bbʉ ya xquí tjogui tengu̱ mpa, car ba̱jtzi hñøjø bi jmu̱ntzi quí mɛjti cja̱ bi bøni, gá ma hnar jöy yapʉ. Nupʉ́, bú ttzon cár domi pʉ, mí ndo øti mbaxcjua, jí̱ mí tzö cár vida. ");
INSERT INTO otsNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bbʉ mí tjeh cár domi ya, bú e̱h hnar ndo tju̱ju̱ jar jöy‑cá̱. Cja̱ mí u̱jtjo te di zi. ");
INSERT INTO otsNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nubbʉ́, bi ma bú öjpi bbɛfi hnar mi̱ngu̱ pʉ jar jöy‑cá̱. Cja̱ nucá̱ bi cjajpi ʉ́r mödi, bi gu̱h pʉ jar bbatja pa di cca̱htibi quí zacjua cja̱ di wi̱ni. ");
INSERT INTO otsNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nubbʉ́, mí ndo tu̱ntju̱ car ba̱jtzi hñøjø, hasta mí ne di zi ca mí ttun cʉ zacjua. Pe u̱jtjo, jin to gá uni te di zi. ");
INSERT INTO otsNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Diguebbʉ ya, bi mbe̱ni, bú coh cár mʉy, bi ma̱: “Quí mɛfi cam ta i pɛhtzijʉ tju̱jme̱ rá ngu̱, hasta i sobratjo. Xigö ya, ¿dyoca̱ dí me̱ntju̱ hua? ");
INSERT INTO otsNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nuya, gu pøngua, gu ma grí cuati cam ta, gu xifi: Nuquɛ, ta, xtú øti ca rá nttzo. Jí̱ xtá øti ca i ne ca Ocja̱, cja̱ hne̱hquiguɛ, jí̱ xtá øjtiqui. ");
INSERT INTO otsNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya nuya, jin drá ntzögöbbe gui xijqui ir ttʉgui. Gui cjaguitjo ncja hner mɛfi ya.” Guejnʉ́ bi mbe̱n car ba̱jtzi hñøjø. ");
INSERT INTO otsNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nubbʉ́, bi bøm pʉ jar jöy‑cá̱, bi ma gá ngoh pʉ jabʉ már bbʉh cár ta. Cja̱ bbʉ jí̱ bbe má tzøte, yadi pʉ má pa, cár ta ya bi jianti, ya xi mbá e̱je̱. Bi jui̱jqui, bbʉ, bi gʉ ʉr ddiji, bi ma bú tja̱di, bi jiʉfi cja̱ bi zʉhtibi cár jmi. ");
INSERT INTO otsNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Car ba̱jtzi hñøjø ya bi xifi: “Nuquɛ, ta, xtú ndo øtigö ca rá nttzo. Jí̱ xtá øti ca i ne ca Ocja̱, cja̱ hne̱hquiguɛ, jí̱ xtá øjtiqui. Ya jin drá ntzögöbbe gui xijqui ir ttʉgui.” ");
INSERT INTO otsNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nu cár ta ya, bi nzoh quí mɛfi, bi hñi̱mbijʉ: “Má ca̱jʉ ca hnar da̱jtu̱ ca más rá zö, gui jiejtijʉ, cja̱ gu ja̱mpijʉ hnar mfodyɛ da fojti nʉ́r xö, cja̱ gu cʉmpijʉ zɛxtji da di̱hti. ");
INSERT INTO otsNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cja̱ bú tzijʉ car tzi nda̱nitjo ca ya xí nojqui, gui pöhtijʉ, gu tzajʉ. Gu øhtibijʉ hnar mbaxcjua nʉm ttʉ nʉ xí nzøjø. ");
INSERT INTO otsNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nʉm ttʉ‑nʉ́, ncjahmʉ ya xquí du̱, cja̱ nuya pé xí jña̱ ʉ́r jña̱. Xquí bbɛdi, cja̱ nuya pé xí ni̱gui.” Cja̱ bi mpöjmʉ bbʉ́, bi mʉdijʉ bi dyøtijʉ mbaxcjua. ");
INSERT INTO otsNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nu car da̱ttʉ, már bbʉ jar jua̱ji̱, cja̱ bú e̱j ya, bi dyøde már jʉx cʉ músico, már ca̱ cʉ ñi̱, cja̱ már mpöjmʉ cʉ cja̱hni cʉ már bbʉh pʉ mbo. ");
INSERT INTO otsNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nubbʉ́, bi mahti hnar mɛfi, bi dyöni ter bɛh ca̱ már ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bi da̱h car mɛfi: “Ya xí nzøh quer cjua̱da̱. Quer ta, xí möhti car nda̱ni ca már tzi nojo, como ya xí nzøh quer cjua̱da̱, jin te i cja.” ");
INSERT INTO otsNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nubbʉ́, bi ntsjeya car da̱ttʉ, jí̱ mí ne di ñʉti. Bi bøn cár ta bbʉ́, bi ttzi̱ni di ñʉti. ");
INSERT INTO otsNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nu car da̱ttʉ bi xih cár ta, bbʉ́, i̱mbi: “Nugö, rá ndo ngu̱ cjeya xtú pɛjpiqui. Göhtjo ca guí bbɛjpigui, göhtjo dí øte. Pe nuquɛ, ni di hnar chivo xcrú pöhti pa gua øtije tzʉ ʉr mbaxcjua cʉm amigo. ");
INSERT INTO otsNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cja̱ nuya, ca xcá nzøh ca hner ttʉ ca xpá ttzon quer domi, xpá yojmi bbɛjña̱ rá nttzo, nuya xcú pöhtibi guegue car tzi nda̱ni ca már nojo.” ");
INSERT INTO otsNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Cár ta ya bi xifi: “Nuquɛ, ttʉ, dí bbʉbi göhtjo ʉr pa. Göhtjo yʉm mɛjtigö, ir mɛjtiguɛ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pe nuya, rí ntzöhui gu mpöjmʉ ya, gu øtijʉ mbaxcjua, como ncjahmʉ ya xquí du̱ quer cjua̱da̱, cja̱ nuya pé xí jña̱ ʉ́r jña̱. Xquí bbɛdi, cja̱ nuya, ya pé xí ni̱gui.”― ");
INSERT INTO otsNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Diguebbʉ ya, car Jesús bi nzoh quí möxte, bi xijmʉ hnar bbede, i̱na̱: ―Hnar hñøjø mí bbʉbi hnar ndo rico, mí föjtibi cár domi. Cja̱ bi tsjih car rico, car hñøjø‑cá̱ mí ttzombi cár domi. ");
INSERT INTO otsNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Car rico ya, bi nzoh car hñøjø ca mí nu̱htibi cár domi. Bi hñi̱mbi: “¿Ter bɛh ca̱ xí tsjijqui? øde, jin gui tzö ca xcú dyøte. u̱jtigui ya cʉ cuenta, te xcú cjajpi cam domi. Diguebbʉ, gui pøngua, ya jin gui hmʉjquɛ hua.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bi mbe̱n ya car mɛfi, bi ma̱ntsjɛ: “Xi ya, ¿te gu pɛj ya? Jin gui nzɛjqui pa gu ca̱hmi hñu̱tje. Dí pɛhtzi ʉm tzö gu mpɛti.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nubbʉ́, bi mbe̱n car mɛfi, bbʉ́, ja di ncja bbʉ xti mfongui. Bi ma̱m bbʉ: “Ya xtí mbe̱ngö te gu pɛjcö bbʉ xta mfonguigui hua, sa̱nta̱ da cuajtigui jáy ngu̱jʉ cʉ to i tzi ja̱ cár domijʉ.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nubbʉ́, bi ma bú nzoh cʉ cja̱hni cʉ mí tu̱jpi domi cár patrón. Hna‑hnaa gá nzofo. Car primero, bi dyöni: “¿Tengu guí tu̱jpi cam jmu̱?” ");
INSERT INTO otsNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Dí tu̱jpi cʉtta ciento decálitro car aste,” i̱na̱ ya cá̱. Bi ma̱n car mɛfi bbʉ: “Tji na̱r nota na̱ gú dyøjtigui. Xɛjqui ya, cja̱ pé gui dyøti pé hnaa. Gui jñu̱tzi yo ciento cincuentatjo ca guí tu̱jpi.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Diguebbʉ ya, pé bi dyön ca pé hnar cja̱hni: “¿Tengu̱ guí tu̱jpiguɛ?” Cja̱ bi ma̱n‑ca̱: “Nugö, dí tu̱jpi cien carga car trigo.” Car mɛfi bi xih, bbʉ: “Tji nir nota. Gui xɛjqui ya, cja̱ pé gui dyøti pé hnaa, gui jñu̱tzi ochentatjo.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bi dyøj ya cár patrón te xquí dyøti car jiöjte mɛfi, cja̱ bi ma̱: “Nʉm mɛgui mɛfi, i pɛhtzi mfe̱ni rá zö. Macja̱ ya xta mfongui, pe xí jioni ja drí wejqui algo pa da bøni rá zö.” Ncjapʉ gá ma̱n car rico. Nu car Jesús bi xih quí möxte: ―Yʉ cja̱hni yʉ jí̱ í ba̱jtzi ca Ocja̱ i pa̱di ja drí dyøtijʉ pa da ntzixihui rá zö quí hñohuijʉ hua jar mundo. Nu yʉ cja̱hni yʉ i tɛn nʉr jiahtzi, jin tza i pa̱dijʉ ja drí cjajpi quí hñohuijʉ pa da ntzixihui rá zö. ");
INSERT INTO otsNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nugö, dí xihquijʉ ya, masque ʉ́r mɛjti nʉr mundo car domi, gui mbe̱nijʉ ja grí cjajpijʉ‑cá̱, sa̱nta̱ gui tzøpijʉ car Tzi Ta ca bí bbʉ ji̱tzi. Nubbʉ, bbʉ xta guah quir vidajʉ cja̱ ya jin da sirvequijʉ car domi, pe guegue ya, da cuajtiquijʉ pʉ jar ji̱tzi, pʉ ja ngu̱ cʉ jin da mpu̱ni. ");
INSERT INTO otsNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Car cja̱hni ca i födi rá zö ca tchʉtjo ca i ja̱, cja̱ jin gui øti ntjöti co nica̱, bbʉ da ttuni rá ngu̱, guejtjo da mödi rá zö. Nu car cja̱hni ca i ja̱ tchʉtjo cja̱ i tzi øti ntjöti, bbʉ di ttuni rá ngu̱, más drá ngu̱ di dyøti ntjöti, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nuquɛjʉ, bbʉ jin gui tzö ca guí cjajpijʉ car domi ca ya xquí pɛhtzijʉ, cja̱ nuca̱, rí hñe̱cua nʉr mundotjo, nubbʉ, car Tzi Ta ji̱tzi jin da ddahquijʉ cʉ cosa más pé rá tzi zö cʉ rí hñe̱h pʉ ji̱tzi, como guejtjo jin di tzö ca güi cjajpijʉ‑cʉ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bbʉ xcú nu̱htibijʉ quí mɛjti pé hnar cja̱hni cja̱ xcú dyøtijʉ ntjöti co nicʉ, ¿toca̱ da ddahquijʉ pé dda cosa pa gui cjajpi ir mɛjtitsjɛjʉ‑cʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Jin gui tzö da dɛngui yojo jmu̱ hnadi car mɛfi. I nesta da juajni ja̱ ndrá nguehca̱ da dɛni. Nde̱jma̱ i bbʉh ca hnaa ca da ne da jiɛgui. Nu ca pé hnaa ya, da ndo ne da guati. Guehquitjoguɛjʉ, jin gui tzö gui un quir mʉyjʉ gui pɛjpijʉ ca Ocja̱ bbʉ guí ndo ne gui jña̱jʉ nʉr domi.― ");
INSERT INTO otsNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nu cʉ fariseo, bbʉ mí dyøj ya nʉr palabra‑nʉ, bi dembitjojʉ car Jesús, como gueguejʉ mí ndo nejʉ car domi. ");
INSERT INTO otsNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Diguebbʉ ya, car Jesús bi xijmʉ‑cʉ́: ―Nuquɛjʉ, guí mbe̱nijʉ ja grí dyøtijʉ ca da ni̱gui rá zö, pa da hñi̱zquijʉ yʉ cja̱hni. Nu car Tzi Ta ji̱tzi göhtjo bí janti, cja̱ guegue bí pa̱di ja ncja gri mbe̱nijʉ mbo ir tzi mʉyjʉ. I bbʉh ca i ndo jon yʉ cja̱hni yʉ i tti̱htzibi hua jar mundo. Nu ca Ocja̱ i ma̱, rá nttzo quí mfe̱ni yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bbʉ jí̱ bbe mí fʉdi mí predica car Juan ca mí xix yʉ cja̱hni, todavía mí ddɛndi car ley ca xquí ma̱n car Moisés, cja̱ co cʉ palabra cʉ mí ma̱n cʉ profeta cʉ mí bbʉ ya má yabbʉ. Pe bbʉ mí mʉdi mí nzoj yʉ cja̱hni car Juan, jí̱ mí ña̱ digue car ley cja̱ co cʉ profeta. Mí xij yʉ cja̱hni car tzi ddadyo jña̱, mí ma̱: “Ya xta mʉdi xta mandado ca Ocja̱ hua jar jöy.” Cʉ pa‑cʉ, dú fʉjcö dú nzoj yʉ cja̱hni, hne̱je̱. Cja̱ nuya, göhtjo yʉ to i ne, i ndo mpɛgui pa da guajquijʉ, pa drí jña̱jʉ cʉ bendición cʉ rí hñe̱h cár jmandado ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nuya, ya xqui ddɛni nʉr tzi ddadyo jña̱ nʉ xtú ja̱gö. Pe nde̱jma̱ i sirvetjo car ley ca bi ma̱n car Moisés. Ni di hnar tzi puntotjo da mpuni. Göhtjo da ncumpli. Masque da mpun nʉr jöy cja̱ co nʉr ji̱tzi, pe jin da mpun car ley. ");
INSERT INTO otsNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Car hñøjø ca da mɛh cár bbɛjña̱ cja̱ pé da ntja̱jtihui pé hnaa, i øhtibi car rá nttzo ca bbɛto ʉ́r bbɛjña̱. I jñɛjmi car hñøjø ca i yohti bbɛjña̱. Guejti car hñøjø ca da ntja̱jtihui hnar bbɛjña̱ ca ya xí bbɛgui, guejtjo i øti ca rá nttzo. I jñɛjmi ca to i jöhtibi cár bbɛjña̱ pé hnar hñøjø.― Ncjapʉ gá man car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Cja̱ pé bi xih cʉ cja̱hni pé hnar bbede: ―Hna vez, mí bbʉh hnar rico. Mí je quí da̱jtu̱ már ma̱di cja̱ mí finu, cja̱ mí tzí rá zö göhtjo ʉr pa. ");
INSERT INTO otsNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Guejtjo mí bbʉh ca hnar tzi mɛti, mí ju̱ cár tju̱ju̱ múr Lázaro, mí ndo jøxi tsja̱xi. Göhtjo ʉr pa, mbá ttziji, mí ju̱h pʉ jár goxtji car rico. ");
INSERT INTO otsNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mí öh cár jme̱, di ttuni te xquí sobra jár mexa car rico. Cja̱ mbá e̱h cʉ dyo, mí tehtzibi quí tsja̱xi. ");
INSERT INTO otsNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Diguebbʉ ya, bi du̱ car tzi probe, car mɛti. Bi zix cʉ anxe pʉ jar ji̱tzi, jabʉ mí bbʉh car Abraham. Cja̱ guejtjo bi du̱ car rico hne̱, bi hñögui rá zö. ");
INSERT INTO otsNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Guegue‑cá̱ bi ttzix pʉ jabʉ jin gui tzö, mí ndo sufri pʉ. Desde pʉ, bi nøhtze, bi jianti car Lázaro, yapʉ mí bbʉy, guehpʉ jár nttzöya ca Ocja̱, már yojmi ca ndom titajʉ car Abraham. ");
INSERT INTO otsNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nubbʉ́, car rico bi mafi, i̱na̱: “Tzi Ta, Abraham, jui̱guigui tzʉ. Cú̱h tzʉ car Lázaro, du coxi deje cár xö, du e̱ da gozqui tzʉ nʉm cja̱jni, xí nza̱ti, como dí ndo sufrigö hua jar tzibi.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pe car Abraham bi xifi: “Nuquɛ, ttʉ, gui mbe̱ni tzʉ ja nguír hmʉ jar jöy. Nuquɛ, nguí bbʉy rá zö, cja̱ nʉr Lázaro mí tjoh cár trabajo, mí ndo sufri, pe nuquɛ jin gú fötzi. Cja̱ nuya, guegue‑nʉ́ xí ndöti cár consuelo ya, cja̱ nuquiguɛ ya, i tocaqui gui sufri. ");
INSERT INTO otsNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Cja̱ guejtjo hne̱ i o madé hnar ndo jñe̱, jin gui tzö to da ddatzi. Yʉ to i bbʉjcua, jin gui tzö da ddax pʉ jabʉ guí bbʉy. Guejtjo, jin gui tzö du ddatzi drí hñe̱cua cʉ to rá bbʉh pʉ.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bi ma̱n car rico bbʉ: “Bbʉ jin gui tzö du ddaxcua car Lázaro, gui jioni to gui cu̱y, da ma pʉ jár ngu̱ cam ta. ");
INSERT INTO otsNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Porque i bbʉh cʉtta cʉm cjua̱da̱. Gui cu̱h tzʉ ca to da ma du nzofo, du xifi da hñe̱me̱bijʉ cár palabra ca Ocja̱, pa jin du e̱jmʉ hua, jin da sufrijʉ hne̱, ncja ngu̱ dra sufrigö.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nu car Abraham pé bi xih bbʉ́: “Gueguejʉ i tjɛjʉ car Escritura ca bi jñu̱x car Moisés co cʉ pé dda profeta. Rí ntzöhui da hñe̱me̱jʉ ya cá̱.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Car rico bi da̱h bbʉ́: “Ji̱na̱, Tzi Ta Abraham. Bbʉ da nantzi hnar ánima digue cʉ ya xí ndu̱, cja̱ da ma du nzojmʉ, nubbʉ, da hñe̱me̱jʉ cja̱ da repentijʉ, bbʉ.” ");
INSERT INTO otsNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bi da̱j ya car Abraham, i̱na̱: “Bbʉ jin gui cjadi mʉy quir cjua̱da̱ digue ca bi ma̱n car Moisés co cʉ pé dda profeta pʉ jar Escritura, guejtjo jin da hñe̱me̱, masque xín da ma hnaa ca ya xtrú ndu̱ cja̱ pé xtrú jña̱ ʉ́r jña̱. Masque da ma du nzojmʉ, guejtjo jin da hñe̱me̱jʉ‑cá̱.”― Bi nttzɛdi pʉ car bbede ca mí ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Diguebbʉ ya, car Jesús bi xih quí möxte, bi hñi̱mbijʉ: ―Yʉ cja̱hni yʉ i bbʉjcua jar mundo, segue i øti ca rá nttzo. Guejtjo i bbʉj yʉ ddaa yʉ i jöti quí mi̱nga̱‑cja̱hnijʉ pa da dyøtijʉ ca rá nttzo. Pe dí xihquijʉ, car cja̱hni ca da jiöti cár hñohui pa da dyøti ca rá nttzo, da ttuni hnar castigo drá ndo ʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más drá ngu̱ da sufri hnar cja̱hni ca xtrú jiöti cár mi̱nga̱‑cja̱hnihui pa xtrú dyøti ca rá nttzo, ni ndra ngue car cja̱hni ca di hna̱htibi hnar me̱do drá nojo cár dyʉga, di ttɛnti pʉ jar deje pa di du̱. ");
INSERT INTO otsNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Eso, dí xihquijʉ, gui jña̱jʉ ʉr huɛnda pa jin gui dyøhtibijʉ ca rá nttzo quir mi̱nga̱‑cja̱hnijʉ. Pe bbʉ da dyøjtiqui ca rá nttzo quer hñohui, gui nzofo. Gui xifi, ¿dyoca̱ xí dyøjtiqui ncjapʉ? Cja̱ bbʉ da repenti, gui perdonabi, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masque xín da dyøjtiqui ca rá nttzo yojto vez, hnajpatjo, bbʉ da mbe̱ni cada vez cja̱ da xihqui: “Dí repenti ca xtú cjahqui ca jin gui tzö,” nubbʉ, gui perdonabi yojto vez hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bi guaj ya car Jesús, bi ma̱n yʉ palabra‑yʉ. Diguebbʉ ya cʉ doce quí möxte cʉ xquí tti̱tzi gá apóstole bi xijmʉ: ―Gui föxquije tzʉ, pa gu zɛdije ca dár e̱me̱je car Tzi Ta ji̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Car Jesús bi da̱h, bbʉ: ―Hnár tzi ndö ʉr murtaza, nttzɛditjo chi tchʉ‑ca̱. Pe bbʉ xta bøtze, nde̱jma̱ da te cár planta, da zɛdi. Hne̱hquiguɛjʉ, ya xquí tzi e̱me̱jʉ ca Ocja̱, hne̱je̱, masque cja guí nxödijʉ gui hñe̱me̱jʉ. Pe bbʉ güi dyøtijʉ ʉr prueba co ca tengu̱tjo ca ya xcú hñe̱me̱jʉ, di jogui güi bbɛjpijʉ nʉr ndo za nʉ rá jø‑nʉ, di ccʉhtzi di ma drí tti̱ti nʉ jar mar, cja̱ di ncjapʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Car Jesús pé bi ma̱ngui hnar bbede, bi xih cʉ cja̱hni cʉ mí tɛnijʉ. ―Ca hnar hñøjø mí hñi̱h hnár mɛfi, cja̱ nucá̱, cjabbʉ mí hua̱ji, cjabbʉ mí mfödi. Göhtjo ʉ́r nde bbʉ mí nde, mbá e̱ jar jua̱ji̱, cja̱ mír zøm pʉ́ jár ngu̱ cár patrón. Nu cár patrón, jí̱ mí xifi di ñʉta mbo, pa di mi̱ jar mexa. ");
INSERT INTO otsNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Al contrario, mí xifi: “Jojqui ya ca gu tzi, cja̱ gui mpɛgui gui sirvegui. Cja̱ bbʉ ya xcúr tzigö, nubbʉ́, xtí tziguɛ hne̱je̱.” Mí xifi ncjapʉ cár jmu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Cja̱ jí̱ mí öjpi mpöjcje digue car bbɛfi ca xquí dyøte, ji̱na̱. Como gue cár oficio hnar mɛfi, da cjajpi quí jmandado cár jmu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nuquiguɛjʉ, hne̱je̱, masque gui purajʉ gui dyøtijʉ göhtjo ca xí mandadoquijʉ ca Ocja̱, jí̱ rí ntzöhui da tti̱zquiguɛjʉ o da ttöhquijʉ mpöjcje por rá ngue ca xcú dyøtijʉ, como gue quer bbɛfitjojʉ‑ca̱. Rí ntzöhui gui ma̱ndijʉ: “Jin te xtú øhtibije ca Ocja̱. Jøntjo xtú øtije ca mí nesta, guehca̱ bi bbɛjpiguije cam Tzi Jmu̱jʉ.”― ");
INSERT INTO otsNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hna vez, car Jesús má tjoh pʉ jár lindero car estado Samaria co ni car estado Galilea, mír ma Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bbʉ ya xi má tzøtijʉ ca hnar tzi jñi̱ni, bi jianti ddɛtta hñøjø, gueguejʉ mí jøx cʉ ttzotsja̱xi cʉ mí tsjifi ʉr lepra. Yadinʉ már bböpjʉ, como jí̱ mí tjɛgui di yojmʉ cʉ cja̱hni cʉ jin te mí cja. ");
INSERT INTO otsNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Cʉ hñøjø‑cʉ bi mahtijʉ car Jesús, bi xijmʉ: ―Nuquɛ, Jesús, maestro, jui̱guije tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Car Jesús ya bi cca̱hti‑cʉ, bi xijmʉ ncjahua: ―Nuya, ya xcú zöjʉ. Gui möjmʉ ya bbʉ, möjmʉ bú u̱jtijʉ car möcja̱, ya xí wen quir tsja̱xi cʉ nguí tzöjʉ.― Bi möjmʉ, bbʉ, cja̱ bbʉ má pöjmʉ jar hñu̱, bi hna jojtsjɛ quí tsja̱xijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ca hnar hñøjø, bbʉ mí cca̱hti, ya xquí joh quí tsja̱xi, bú coh pʉ jabʉ már bbʉh car Jesús, bi xöjtibi ca Ocja̱, bi ña̱ nzajqui. ");
INSERT INTO otsNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bi nda̱ndiña̱jmu̱ pʉ jáy hua car Jesús, bi ndo ani jöy cja̱ bi dyöjpi cjama̱di. Múr mi̱ngu̱ car jöy Samaria car hñøjø‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Bi ma̱n car Jesús, bbʉ, bi xih cʉ cja̱hni cʉ mbá yojmi: ―Sá, mí ddɛtta hñøjø xtú jojqui. ¿Jabʉ i bbʉj ya cʉ pé dda gʉjtjo cʉ xí zö? ");
INSERT INTO otsNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Dyoca̱ jí̱ xcá dyöjqui cjama̱di guegue‑cʉ? Ddatsjɛ nʉr hñøjø‑nʉ xpá ngoy, xí xöjtibi ca Ocja̱, cja̱ hné̱, jin gur judio‑nʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cja̱ diguebbʉ ya bi nzoh car hñøjø‑ca̱, bi xifi: ―Bböj ya, cja̱ gui me ir ngu̱. Ya xcú töti car nzajqui ca jin da tjegue, como xcú hñe̱me̱gui.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ca hnajpa cʉ fariseo bi dyönijʉ car Jesús tema mpa di mʉdi di mandado ca Ocja̱ hua jar jöy. Car Jesús bi da̱di: ―Jin da ncca̱hti bbʉ xta mʉdi xta mandado ca Ocja̱ hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jin da jma̱: “Tji nʉ rá cjanʉ,” o “Tji hua ra cjahua, ya xí ni̱gui hua cár gobierno ca Ocja̱.” Como cár jmandado ca Ocja̱ jin gui ncja ngu̱ yʉ gobierno yʉ i ncca̱hti. Dí xihquijʉ, ya xí mʉdi xí mandado ca Ocja̱ hua jabʉ guí bbʉpjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Diguebbʉ ya, car Jesús bi xih quí möxte, bi hñi̱mbijʉ: ―Xtu e̱h cʉ pa bbʉ xtí ndo sufrijʉ. Nubbʉ, cja xtí ndo mbe̱n yʉ palabra yʉ xtú xihquijʉ digue ja da ncja bbʉ xtá mandadogö hua jar jöy. Nubbʉ, xquí ma̱jmʉ, bbʉ: “Xim pé du coh cam Tzi Jmu̱jʉ pa da möxcöjʉ.” Pe nde̱jma̱, bbʉ xtí ma̱jmʉ ncjapʉ, di bbɛjtjo pa pé xcuá coji. ");
INSERT INTO otsNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Cʉ pa‑cʉ da tsjihquijʉ: “Ya pé xí nzøh ca hnar cja̱hni ca xpá mɛjni car Tzi Ta ji̱tzi. Rá bbʉjcua rá cjahua.” O bbʉ ji̱na̱, xta tsjihquijʉ: “Rí hmʉ pé hnar parte.” Pe jin gui hñe̱me̱jʉ, má̱s guejquigö, como jim pé xcrú coji, cja̱ jin gui ma gui tɛnijʉ cʉ to da xihquijʉ ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Como bbʉ xta zøh car pa bbʉ pé xcuá e̱cö, da fa̱di rá zö. Xta hna zøh car pa‑ca̱ ncja ngu̱ bbʉ i juɛx nʉr rayo. I juɛxi hnanguadi, cja̱ pé i yoti göhtjo nʉr ji̱tzi. Da ncjadipʉ hne̱je̱, drí ndo fa̱h bbʉ pé xcuá coji. ");
INSERT INTO otsNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pe i bbɛjtjo pa da ncja‑ca̱. Porque i nesta bbɛto gu sufri rá ngu̱. Xta zanguitjo cja̱ xta ʉguitjo yʉ cja̱hni yʉ i bbʉj yʉ pa ya. Nuyʉ, jin da hñe̱me̱gui, ¿cja cierto dúr cja̱hnigö xtrú bbɛnquigö hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nu car pa ca pé xcuá e̱, da dyøti cʉ cja̱hni ncja ngu̱ nguá dyøti cʉ cja̱hni bbʉ mí bbʉh ca ndom titajʉ Noé. ");
INSERT INTO otsNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cʉ pa‑cʉ, cʉ cja̱hni mí ñu̱nijʉ, mí øtijʉ mbaxcjua, cja̱ mí ntja̱jtijʉ, hasta mero car pa bbʉ mí ñʉti jar barco car Noé. Diguebbʉ ya, bi ndo wa̱y, sta bi ñu̱xi deje car jöy, cja̱ bi mpuni göhtjo cʉ cja̱hni‑cʉ, bi du̱ pʉ jar deje. ");
INSERT INTO otsNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Guejtjo mí ncjapʉ cʉ pa bbʉ mí bbʉh car Lot, bbʉ ya xti mpun car jñi̱ni Sodoma. Mí ñuni cʉ cja̱hni, mí øtijʉ mbaxcjua, mí ntöjmʉ, mí mpöjʉ, mí tu̱jmʉ semilla, mí xoxjʉ ngu̱. Jin gá mba̱dijʉ ¿cja di hñe̱h car castigo? ");
INSERT INTO otsNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero bbʉ mí ccʉjqui car Lot, ngá mbøm pʉ jar jñini Sodoma, pa di wem pʉ, nubbʉ, bi jiø tzibi güí hñe̱ ji̱tzi, mí yojmi azufre cja̱ mí ndo fʉni, bi dʉti göhtjo cʉ mi̱ngu̱ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Guejtjo da ncjapʉ bbʉ pé xcuá e̱cö, jin da ba̱h cʉ cja̱hni cʉ jin gui e̱me̱ nʉ́r palabra ca Ocja̱, ¿cja ba e̱h car castigo? ");
INSERT INTO otsNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Car pa‑cá̱, bbʉ to xtrú mbøx pʉ jar ña̱jcu̱, cja̱ quí mɛjti dra bbʉh pʉ mbo car ngu̱, jin da ñʉti pʉ mbo cár ngu̱ pa da gʉjqui‑cʉ. Guejtjo, ca to dra bbʉh pʉ jár jua̱ji̱, jin du coh pʉ jár ngu̱ pa da gʉjqui pʉ ca te i pɛhtzi. ");
INSERT INTO otsNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gui mbe̱nijʉ te bi ncjajpi cár bbɛjña̱ car Lot. Guegue bi ñe̱gui gá jani ʉ́r xʉtja, bi jiøjqui cʉ xquí zogui, cja̱ por rá nguehcá̱, bi bbɛh cár nzajqui. ");
INSERT INTO otsNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Cja̱ pé dí xihquijʉ, ca to jin da ne da dɛngui por rá nguehca̱ rí jiøjqui cár vida cja̱ rí mödi, nde̱jma̱ da bbɛdi. Nu ca to da hñi̱ti ʉ́r mʉy ca Ocja̱, masque da bbɛh cár vida hua jar jöy, ca Ocja̱ da un car vida ca ntju̱mʉy, cja̱ nucá̱, jin da bbɛh‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Dí xihquijʉ ya, te da ncja bbʉ pé xcuá cojcö. Yojo cja̱hni cʉ di a̱jmi hnadi car gama, ca hnaa xta hna ttzitzi, da u̱jtjo, nu ca pé hnaa da goji. ");
INSERT INTO otsNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yojo bbɛjña̱ dar cʉnihui jar cjʉni, xta hna ttzix ca hnaa, xta u̱jtjo, nu ca pé hnaa, da goji. ");
INSERT INTO otsNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Car pa‑ca̱, yojo hñøjø dar pɛh pʉ jar jua̱ji̱. Xta hna bbɛjti ca hnaa, xta u̱jtjo, nu ca pé hnaa ya, da gojti‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Diguebbʉ ya, quí möxte car Jesús bi dyönijʉ, bbʉ́: ―¿Jabʉ da ncja ya‑ca̱, Tzi Jmu̱?― Cja̱ guegue bi da̱di: ―Pʉ jabʉ guí jantijʉ, i ndo jöntzi cʉ ndojpada, guí pa̱dijʉ, ra bbɛm pʉ hnar ndu̱dyo. Da ncjadipʉ hne̱je̱ bbʉ xta zøh car pa ca xí ma̱n car Tzi Ta ji̱tzi. Göhtjo pʉ jabʉ xtrú ndo jiɛjmʉ ca Ocja̱ cʉ cja̱hni, guehpʉ xta hna zʉh cár castigojʉ.― Ncjapʉ gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Car Jesús bi xih quí möxte hnar bbede pa di nxödijʉ di nzojmʉ ca Ocja̱ göhtjo ʉr pá, cja̱ jin di jiɛjmʉ ca mír mahtijʉ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Bi ma̱: ―øde, pʉ ca hnar jñini, már bbʉh hnar nzöya már nttzo. Nucá̱, jí̱ mí tzu̱ cʉ cja̱hni, ni mpa digue ca Ocja̱ di zu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Már bbʉh pʉ hne̱je̱ ca hnar ddanxu̱. Guegue‑ca bi ma bú cöx car nzöya, bi xifi di gohtibi hnár contra. ");
INSERT INTO otsNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Car nzöya jí̱ mí øhtibi ncaso. Nu car ddanxu̱, dé mí bböti, dé mí öjpi di gohtibi cár contra. Diguebbʉ ya, bi ma̱ntsjɛ car nzöya bbʉ: “Jin dí tzu̱ yʉ cja̱hni, ni mpa digue ca Ocja̱ dí tzu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pe mejor gu castigabi cár contra nʉr ddanxu̱, porque ya xná ʉdi nʉm ña̱. Dé i bböti hua, dé ba quejagui.” Cja̱ bi cjajpi, bbʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nu car Jesús bi xih quí möxte: ―Gui mbe̱nijʉ ter bɛh ca̱ bi dyøti car nzöya már nttzo. Nde̱jma̱ bi dyøhtibi jujticia car ddanxu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xi car Tzi Ta ji̱tzi, ¿cja jin da möx yí cja̱hni guegue bbʉ te i ttøhtibi‑yʉ? Como xí juajni‑yʉ pa dí mɛjtitsjɛ, cja̱ nuyʉ, i nzofo pá ʉr xu̱y. ¿Cja guí i̱na̱jʉ, da dé car Tzi Ta ji̱tzi drí dyøhtibi jujticia quí cja̱hni? ");
INSERT INTO otsNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ji̱na̱, dí xihquijʉ, guegue tzin drí möx yí cja̱hni. Pe nde̱jma̱ da nesta da hñe̱me̱tjo‑yʉ, cja̱ jin da dyʉxi ʉ́r mʉyjʉ, como jim pé ba e̱h car pa bbʉ xta ncja car juicio. Nugö, dí xihquijʉ, guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. Cja̱ bbʉ pé xcuá cojcö, ya jin tza drá ngu̱ cʉ cja̱hni cʉ da dɛnguitjo. Cʉ pé ddaa rá ngu̱, ya xtrú wembigui.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mí bbʉh cʉ dda cja̱hni cʉ mí mbe̱ntsjɛ, már ndo zö nguá hmʉpjʉ. Nucʉ, mí tzohmi cʉ pé ddaa, mí ma̱jmʉ, jí̱ mí tzö mír hmʉ guegue‑cʉ. Car Jesús bi ma̱n nʉr bbede‑nʉ, bi xih cʉ cja̱hni cʉ mí hñi̱xtsjɛ, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―øde, mí bbʉ yojo hñøjø, bi bøxihui jar ndo ni̱cja̱ pa di nzoh ca Ocja̱. Ca hnáa múr fariseo cja̱ ca hnáa múr tesorero, mí cobrabi yʉ cja̱hni car contribución. ");
INSERT INTO otsNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Car fariseo bi hmöjtjo, bi nzo Ocja̱, bi ma̱: “Nuquɛ Ocja̱, dí öhqui cjama̱di jin dí jñɛbbe yʉ dda cja̱hni. Jin dí mpe̱, jin dí øti ntjöti, jin dí jöti bbɛjña̱, jin dí øtigö ncja ngu̱ ga dyøti nʉr jiöjte tesorero nʉ ra bböjcua. ");
INSERT INTO otsNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dí ayuna yo vez ʉr semana, cja̱ dí un cam diezmo, göhtjo ca dí ta̱ja̱.” ");
INSERT INTO otsNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nu car tesorero, már bböjti nʉ tzi yanʉ. Mí pɛhtzi ʉ́r tzö ja drí nzoh ca Ocja̱, como mí mbe̱n ca xquí dyøte. Bi ñe̱jmi, bi ma̱: “Nuquɛ Ocja̱, gui jui̱gui tzʉ. Dí ndo ndu̱jpitegö.” Ncjapʉ gá ma̱n car tesorero.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Cja̱ bi ma̱n car Jesús: ―Dí xihquijʉ ya, bi mperdonabi car tesorero, porque már zö cár mfe̱ni gá nzoh ca Ocja̱. Pe nu car fariseo ya, jin gá mperdonabi‑ca̱, como mí ndo hñi̱xtsjɛ. Car cja̱hni ca da hñi̱xtsjɛ, ca Ocja̱ da bbɛtibi ʉ́r tzö, cja̱ nu ca to da ncja ʉ́r tzö, ca Ocja̱ da recibi‑cá̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hna vez, mbá ttzi cʉ tzi ba̱jtzi pʉ jabʉ már bbʉh car Jesús, pa di orabi guegue, di dyöjpi car Tzi Ta ji̱tzi di mötzi. Nu quí möxte car Jesús, bbʉ mí cca̱htijʉ te már ncja, jí̱ mí ne di jiɛjmʉ cʉ cja̱hni di guatijʉ. Eso, bi huɛntijʉ quí me co quí ta cʉ ba̱jtzi, bi ccahtzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nu car Jesús, bi nzoh cʉ cja̱hni cʉ mbá tzijʉ‑cʉ́, bi xijmʉ di guatitjojʉ. Cja̱ pé bi xih quí möxte: ―Gui jiɛjmʉ yʉ tzi ba̱jtzi du e̱ da guajquigö. Dyo guí ccahtzijʉ. Cam Tzi Ta ji̱tzi xí uni ʉ́r tsjɛjqui cʉ cja̱hni cʉ i ncjajʉ ncja ngu̱ yʉ tzi ba̱jtzi da hmʉh pʉ jabʉ i mandado guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cierto, dí xihquijʉ, ca to jin da guati jár dyɛ ca Ocja̱ pa da jñɛgui da mandadobi, ncja ngu̱ hnar tzi ba̱jtzi ga jñɛgui da hmɛjpi jmandado, guegue jin da ñʉti pʉ jabʉ i mandado ca Ocja̱.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bú e̱h hnar hñøjø ca mí bbʉh cár cargo pʉ jár ni̱cja̱ cʉ judio, bi dyön car Jesús: ―Nuquɛ, Maestro, rá ndo zöquiguɛ, ¿te gu øtigö pa gu töti cam nzajqui ca jin da tjegue?― ");
INSERT INTO otsNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Car Jesús bi xifi: ―¿Te rá nguehcá̱ guí xijqui rá ndo zöguigö? Jin te i bbʉ cja̱hni drá ndo zö. Ddatsjɛ ca Ocja̱, ntero rá zö cár hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Guí pa̱h cʉ mandamiento cʉ bi zoguijʉ car Moisés: “Jin gui jiöti bbɛjña̱; jin gui pöhtite; jin gui mpe̱; jin gui ña̱jqui bbɛtjri; gui respetabi quer ta, quer me.”― ");
INSERT INTO otsNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bi da̱h car hñøjø, i̱na̱: ―Xtú øti göhtjo‑cʉ́ desde bbʉ ndí tchʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bi dyøj ya cá̱ car Jesús, bi xih bbʉ: ―Todavía hnar cosa i bbɛjtjo. Ma grí coji, ma bú pö göhtjo quir mɛjti, gui jejquibi cʉ probe, pa gui pɛhtzi pʉ ji̱tzi ca ntju̱mʉy rá zö. Cja̱ nubbʉ, gu e̱je̱ gui tɛnguigö, bbʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Car hñøjø ya, bbʉ mí dyøh ca bi ma̱n car Jesús, bi ndo du̱mʉytjo, como múr ndo rico. ");
INSERT INTO otsNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Bi nú̱ ya‑ca̱ car Jesús, bi ma̱: ―Rá ndo ntji̱ pa drí ñʉti jár dyɛ ca Ocja̱ hnar rico. ");
INSERT INTO otsNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jin da jogui drí tjoh hnar camello pʉ jár gu̱ hnar dyofani. ¿Jabʉ di ntzöhui‑ca̱? Ncjadipʉ hne̱je̱ hnar rico, jin da jogui drí nʉti jár dyɛ ca Ocja, bbʉ da jiøjqui quí riqueza cʉ i pɛhtzi.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bi dyøjmʉ ya‑ca̱ quí möxte car Jesús, cja̱ bi hñönijʉ: ―Xi ya, ¿toca̱ da jogui da nsalva, bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Car Jesús pé bi xijmʉ: ―Ca Ocja̱ i pa̱di ja ncja da nsalva yʉ cja̱hni, como guegue i pa̱di da dyøti yʉ cosa yʉ jin gui tzö da dyøti yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bi ma̱n car Pedro, bbʉ: ―Nugöje, xtú tzoguije göhtjo cʉ ndí pɛhtzije, pa xtá tɛnquije.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Bi da̱h car Jesús: ―Cierto dí xihquijʉ, car cja̱hni ca xí nzoh cár ngu̱, o cár bbɛjña̱, o quí cjua̱da̱, o cár ta, o cár me, o quí ba̱jtzi, por rá nguehca̱ xcá ndɛnguigö. ");
INSERT INTO otsNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Guegue‑cá̱ da ttuni más rá ndo ngu̱ ni ndra ngue cʉ xí nzogui. Da ttun‑cʉ́ menta i bbʉjcua jar jöy, cja̱ bbʉ ya xtrú tjej nʉr mundo, guejtjo da ttun car nzajqui ca jin da tjegue.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Diguebbʉ ya, car Jesús bi mahti cʉ doce quí möxte cʉ xquí hñi̱tzi gá apóstole. Bi xijmʉ: ―Nuya, gu pøxjʉ, gu mö Jerusalén, cja̱ xta ttøjtigui göhtjo ncja ngu̱ ga ma̱m pʉ jar Escritura da ttøhtibi ca hnar cja̱hni ca di bbɛjni hua jar jöy. Ya má yabbʉ bi ma̱n quí jmandadero ca Ocja̱ ter bɛh ca̱ di ttøhtibi. ");
INSERT INTO otsNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bi ma̱jmʉ, guegue da ndö jáy dyɛ cʉ autoridad cʉ jin gui e̱me̱ ca Ocja̱, da ttøhtibi ʉr burla, da hmɛtibi ʉ́r tzö, cja̱ da ttzotzi. ");
INSERT INTO otsNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Guejtjo da tjʉhmi, cja̱ drí ga̱x ya, da bböhti. Pe diguebbʉ ya, ca xtrá jñu̱jpa, pé da nantzi.― Ncjapʉ gá xih quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nu quí möxte bi dyøj yʉ palabra yʉ már ma̱n car Jesús, pe jin gá mba̱dijʉ, ¿cja ya xquí zøh car cja̱hni ca di bbɛjni hua jar jöy? Eso, jin gá ntiendejʉ, ¿cja guejtsjɛ guegue‑ca̱ di bböhti? Ncjahmʉ mí bbʉh ca mí ccahtzijʉ pa jin di ntiendejʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Diguebbʉ ya, car Jesús cja̱ co quí möxte ya xti zønijʉ jar jñini pʉ Jericó. Nʉ hnanguadi car hñu̱, mí ju̱ hnar hñøjø, múr godö, mí mpɛti. ");
INSERT INTO otsNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Guegue‑ca̱ bi dyøj ya má tjogui rá ngu̱ cja̱hni, cja̱ bi hñöni: ―Xi yʉ cja̱hni yʉ ga tjogui, ¿te i jon ya yʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bi tsjifi: ―Ya xpa e̱h car Jesús, car mi̱ngu̱ Nazaret.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nubbʉ́, car godö bi mahti nzajqui, i̱na̱: ―Nuquɛ, Jesús, guehquiguɛ, xpá mɛnqui ca Ocja̱ pa gui mandado ncja ngu̱ car rey David. Gui jui̱guigui tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Cʉ cja̱hni cʉ má bbɛto, mí cohtibi ʉ́r ne car godö, pe guegue más mír ndo mafi nzajqui, mí ma̱: ―Nuquɛ, guír hñe̱ gui mandado, ncja ngu̱ car rey David, gui jui̱guigui tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bi dyøh car Jesús, bbʉ, bi hmöy, bi mandado du ttzi car godö. Mí zøti ya car godö jabʉ már bbʉ guegue, cja̱ car Jesús bi dyöni: ");
INSERT INTO otsNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Te guí ne gu cjahqui?― Bi ma̱n car godö bbʉ: ―Dí ne gu jani.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Car Jesús bi xifi: ―Janiguɛ ya bbʉ. Xcú hñe̱me̱gui, eso, xcú jogui.― ");
INSERT INTO otsNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nubbʉ, bi hna xojti quí dö car godö, cja̱ bi dɛn car Jesús, má ndo xöjtibi ca Ocja̱. Cʉ cja̱hni ya, bi nu̱jʉ, ya xquí xoh quí dö car godö, cja̱ gueguejʉ bi ndo xöjtibijʉ ca Ocja̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Diguebbʉ, car Jesús bi zøti pʉ jar jñini Jericó cja̱ bi ñʉti pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mí bbʉh pʉ ca hnar hñøjø, mí ju̱ cár tju̱ju̱ múr Zaqueo. Guegue múr tesorero, múr jefe, mí mandadobi cʉ pé ddaa cʉ mí cobra cʉ contribución. Múr ndo rico car Zaqueo. ");
INSERT INTO otsNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Guegue mí ne di cca̱hti car Jesús, di meya tzʉ. Pe már ndo dʉ cʉ cja̱hni, cja̱ car Zaqueo múr tzi chaparro, jí̱ mí tzö di jianti. ");
INSERT INTO otsNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eso, bi gʉ ʉr ddiji, bi hmɛto, bi ma guí dexi hnar ndo za pa di jogui di jianti car Jesús, porque ya xti tjoh pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bbʉ mí tjoh pʉ‑cá̱, bi nøhtza ña̱, bi nzoh car Zaqueo: ―Nuquɛ Zaqueo, cá̱ nttzɛdi. Rá pa ya gu tzøti pʉ ir ngu̱, gu zɛnguaqui tzʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bi ga̱ nttzɛdi car Zaqueo bbʉ́, te tza má mpöjö, cja̱ bi zix car Jesús pʉ́r ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bi nú̱ ya cʉ cja̱hni, cja̱ bi zohmijʉ car Jesús. Bi hñi̱na̱jʉ: ―Nu nʉr Jesús, xí ma du cʉti pʉ́r ngu̱ nʉr cja̱hni ʉr jiöjte.― ");
INSERT INTO otsNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nu car Zaqueo, bbʉ ya xquí ña̱hui car Jesús, bi bböy, bi xifi: ―Nuquɛ Tzi Jmu̱, nu̱jma̱ja̱, car madé göhtjo cʉ dí pɛhtzi gu jejquibi cʉ tzi probe, cja̱ bbʉ to xcrú cobrabi rá ngu̱ cár domi, xcrú øhtibi ntjöti, gu cohtzibi hnar go vez ca xcrú ja̱mbi.― ");
INSERT INTO otsNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Car Jesús bi da̱di, i̱na̱: ―Nuya xcú töti quer nzajqui ca jin da tjegue, porque xcú hñemegui. Guí jñɛjmi ca ndom titajʉ Abraham, como guegue‑ca̱ bi hñeme ca Ocja̱ göhtjo mbo ʉ́r tzi mʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nugö, dúr cja̱hni, xpá bbɛnqui hua jar jöy pa gu jon yʉ cja̱hni yʉ xí bbɛdi, cja̱ gu cjʉhtzibi ca rá nttzo ca xí dyøtijʉ.― Bi ma̱n yʉ palabra‑yʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Car Jesús má pa jar hñu̱ pa drí zøti pʉ Jerusalén. Cʉ cja̱hni cʉ má yojmi guegue bi dyøjmʉ göhtjo ca mí ma̱. Nu car Jesús ya, pé bi xijmʉ pé hnar bbede gá ejemplo, porque ya xti zøti pʉ Jerusalén, cja̱ mí mbe̱n cʉ dda cja̱hni, ya xti mʉdi di mandado hua jar jöy car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Como mí pa̱h car Jesús ja nguá mbe̱n‑cʉ, bi xih cʉ cja̱hni na̱r bbede‑ná̱, pa di ntiendejʉ, jí̱ bbe di mʉdi di mandado. Bi xijmʉ, i̱na̱: ―øde, mí bbʉh hnar hñøjø, mí ndo tti̱htzibi, cja̱ mí pɛhtzi cár cargo. Bi ttzofo pa di ma pé hnar jöy yapʉ, cja̱ di ttuni pé hnar cargo más drá ngu̱ ni ndra ngue ca mí pɛhtzi, cja̱ diguebbʉ ya, pé di goh pʉ, pé di mandadotjo. ");
INSERT INTO otsNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bbʉ ya xti bøni, bi nzofo ddɛtta quí muzo, cja̱ cada hnaa bi uni hnáatjo ʉ́r domi ca mí mu̱hui rá ngu̱. Bi xijmʉ, i̱na̱: “Ya xtrá magö ya. Gui comerciajʉ co nʉr domi, cja̱ bbʉ xcuá coji, pé xtí ddajquijʉ bbʉ, co ni cár tja̱ja̱.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Diguebbʉ ya, bi ma. Nu cʉ mi̱ngu̱ car jñini‑cá̱, mí ʉjʉ car tada‑cá̱. Jí̱ mí ne di jiɛguijʉ di mandadobijʉ. Eso bi gu̱pjʉ tengu̱ jmandadero, cja̱ nucʉ́ bi dɛnijʉ car tada, bi ma bú reclamajʉ pʉ jabʉ mír ma guegue pa di ttun cár ddadyo cargo, bú ma̱jmʉ: “Nugöje, jin gu jɛguije nʉr hñøjø‑nʉ da mandadoguije.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pe nde̱jma̱ car tada‑cá̱, bú ttun cár cargo, cja̱ pé bú coji. Nubbʉ́, bi nzoh quí muzo, bbʉ́, cʉ xquí un car domi. Mí ne di ba̱di tengu̱ xquí da̱jmʉ ca gá comerciájʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Bú e̱h car primero, bi xifi: “Nuquɛ, tzi jmu̱, tji nir domi. Ya xtú ta̱cö pé ddɛtta.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bi xih bbʉ: “Rá zö ca xcú dyøte. Gúr jogui mɛfi. Gú cca̱hti rá zö ca jin tza mí ngu̱. Nuya, gu ddahqui quer cargo, gui mandadobi ddɛtta jñini.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bú e̱j ya car segundo, bi ma̱: “Nuquɛ, tzi jmu̱, xtú ta̱cö pé cʉtta domi.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bi xih bbʉ: “Nuya, xtá ddahqui cʉtta jñini ya, pa gui mandadobi.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pé bú e̱h ca hnaa ca mír cja jñu̱, bi xifi: “Nuquɛ, tzi jmu̱, tji nir domiguɛ. Xtú tu̱htitjo hnar da̱jtu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Dú tzu̱gö, jin di joh bbʉ gua comerciá, cja̱ nuquɛ güi tzangui, como guí ndo föh quer domi. Nuquɛ, guí xoj nʉ jabʉ jí̱ xquí tu̱ju̱, cja̱ guí cuajti cʉ semilla cʉ di tocabi pé hnar cja̱hni, como jin guí jui̱jqui quer mi̱nga̱‑cja̱hnihui.” Ncjapʉ gá ma̱n car muzo‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bi ma̱n car tada, bbʉ: “Co nʉr palabra nʉ xcú ma̱, xcú ncjua̱ntsjɛ, jí̱ xquí pɛjpigui rá zö. Gúr ttzomuzoguɛ. Ya xi nguí pa̱di, dí ndo föh cam domi. Ncja ngu̱ gri ma̱nguɛ, nugö dí cuajti ca di tocabi pé hnar cja̱hni, cja̱ dí xoj nʉ jabʉ jin dá tu̱ju̱. ");
INSERT INTO otsNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nuya bbʉ, ¿dyoca̱ jin gú tzoh cam domi nʉ jar bango, pa sa̱nta̱ di ttajqui cár tja̱ja̱?” Guejnʉ bi ma̱n car tada‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nubbʉ́, bi bbɛjpi cʉ dda muzo cʉ már bböjti pʉ hnanguadi, bi xijmʉ: “Jña̱mbijʉ ya cár domi‑nʉ́, cja̱ gui unijʉ car hñøjø ca i pɛhtzi ddɛtta domi.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nucʉ́ bi da̱dijʉ: “Tzi Jmu̱, ya xqui pɛhtzi ddɛtta‑cá̱.” ");
INSERT INTO otsNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nu car jmu̱, pé gá nda̱di, bi ma̱ntjo: “Dí xihquijʉ, ca to i tzi ja̱, más drá ngu̱ pé da ttuni, cja̱ nu ca jin tza te i ja̱, hasta ca tchʉtjo ca i ja̱ da tja̱mbi. ");
INSERT INTO otsNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nu cʉm ncontra ya, cʉ jí̱ mí ne di jiɛgui gua mandadobijʉ, bú tzijʉ hua‑cʉ, gu jantigö guír pöhtijʉ.”― ");
INSERT INTO otsNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bbʉ mí guadi mí ma̱ nʉr bbede‑nʉ́, car Jesús bi dɛn car hñu̱, bi hmɛto, cja̱ quí möxte bi dɛnijʉ, mír bøxjʉ pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ya xi má tzøtijʉ cʉ tzi jñini car Betfagé co car Betania. Bi bøxjʉ ca hnar ttøø ca mí tsjifi Olivos, cja̱ car Jesús bi gu̱j yojo quí möxte di mɛhui hnar jmandado. ");
INSERT INTO otsNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Bi xijmi: ―Mɛhui nʉ jar tzi jñini nʉ rá cjanʉ. Cja̱ nu pʉ jabʉ gui cʉtihui, xquí tötihui hnar tzi burro, rá hna̱ti pʉ. Jí̱ bbe i ddøh car tzi burro‑ca̱. Gui xohtihui ya‑ca̱, cja̱ gu ɛhui. ");
INSERT INTO otsNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Cja̱ bbʉ to da dyönquihui, ¿dyoca̱ guí xohtihui? gui xijmi: “I nesta cam Tzi Jmu̱je.”― ");
INSERT INTO otsNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cja̱ bi ma ya cʉ yojo cʉ xquí cju̱y, bi dötihui car burro, ncja ngu̱ gá tsjijmi. ");
INSERT INTO otsNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nu bbʉ már xohtihui, bi zøh cʉ to múr mɛjti car burro, bi xifi: ―¿Dyoca̱ guí xohtihui nʉm burroje?― bi hñi̱mbihui. ");
INSERT INTO otsNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bi da̱h cʉ yo jmandadero: ―Cam Tzi Jmu̱je i nesta.― Cja̱ bi jiɛjmʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Diguebbʉ, bú ɛhui jabʉ már bbʉh car Jesús. Cʉ ddaa quí möxte car Jesús bi møh quí da̱jtu̱jʉ, bi ga̱htzijʉ car burro, cja̱ bi tøh car Jesús, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Cʉ cja̱hni cʉ xquí jmu̱ntzi, guejtjo bi xi̱h quí da̱jtu̱jʉ pʉ jar hñu̱, pʉ jabʉ di tjoh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Car Jesús co cʉ cja̱hni cʉ má tɛnijʉ bú ca̱jmʉ jar ttøø, ya xti zøtijʉ pʉ Jerusalén. Göhtjo cʉ má tɛni bi mʉdi bi ndo majmʉ. Ya xi má ndo mpöjmʉ. Má xöjtibijʉ ca Ocja̱ por rá ngue cʉ milagro xquí cca̱htijʉ, gue cʉ xquí dyøti car Jesús, como már ndo ngu̱‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Má ña̱jʉ nzajqui, má ma̱jmʉ: ―Rá ndo zö nʉm reyjʉ. Ya xca pa hua nʉ hnáa nʉ xpá mɛjni ca Ocja̱. Ya xqui nú̱guijʉ rá zö car Tzi Ta ca bí bbʉh pʉ ji̱tzi, eso dí ndo xöjtibijʉ.― Ncjapʉ mír ma̱n cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Má yojmi cʉ cja̱hni rá ngu̱ cʉ dda fariseo. Nucʉ́ bi ma̱: ―Nuquɛ, maestro, huɛnti yir möxte. Xijmʉ da gohti í nejʉ, como jin gui tzö ca i ma̱n‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nu car Jesús bi da̱h, bbʉ: ―Dí xihquijʉ, bbʉ di gohti í ne‑yʉ, di tzöya ca rí xödijʉ, nubbʉ, di cja Ocja̱ di ndo maj yʉ me̱do yʉ i bbongua, drí xöjtigui‑yʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bbʉ ya xti zøti pʉ Jerusalén, car Jesús bi cca̱hti car ciudad cja̱ bi nzoni, como rá ngu̱ vez xquí nzoh cʉ cja̱hni pʉ. Pe nucʉ́, jí̱ mí ne di hñemejʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Bi ma̱n car Jesús: ―Nuquɛjʉ, guí mi̱ngu̱jʉ Jerusalén, xa̱jma̱ güi pa̱dijʉ yʉ pa ya, toguigö cja̱ jabʉ xtá e̱je̱. Xa̱jma̱ja̱ güi hñemejʉ ca ndí xihquijʉ. Nubbʉ́, güi nú̱jʉ car paz. Pe nuya, ya xtrá magö. Ya xta zʉhquijʉ hnar castigo rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ya xta zøh car pa bbʉ xtu e̱h quir contrajʉ, xta hñi̱hquijʉ madé, xta goti nir jñinijʉ, göhtjo jáy nttza̱ni. Göhtjo ʉr pa da möh quer jñi̱nijʉ, nim pa jabʉ grí pønijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Da möjtiquijʉ, göhtjo co ni quir ba̱jtzijʉ. Da yøhti quir ngu̱jʉ, tje da fonti cʉ me̱do, ni di yojo da mfi̱tzi. Da ttøjtiquijʉ ncjapʉ, porque bbʉ mí nzohquijʉ ca Ocja̱, jin gú hñemeguijʉ, ¿cja guejcö, xpá mɛnquigö guegue?― Guejnʉ bi ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Diguebbʉ ya, car Jesús bi zøti pʉ jar jñi̱ni Jerusalén, bi guati jar ndo ni̱cja̱, cja̱ bi fongui cʉ to már pö pʉ cʉ zu̱we̱ cʉ mí bböhti pa di ddʉti pʉ jar arta. ");
INSERT INTO otsNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Bi huɛnti‑cʉ, bi xijmʉ: ―I ju̱x pʉ jar Escritura, i̱na̱: “Nugö, dú Ocja̱, cja̱ bi ttøti nʉm ngu̱ pa du e̱cua yʉ cja̱hni, da nzojquigö.” Pe nuquɛjʉ, xcú cjajpijʉ ʉ́r ngu̱ cʉ be̱.― Bi ma̱ ncjapʉ car Jesús, como cʉ mö mí ndo jöti yʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Göhtjo ʉr pa, car Jesús mí cuati pʉ jar ndo ni̱cja̱, mí u̱jti cʉ cja̱hni. Nu cʉ möcja̱ cʉ mí mandadobi cʉ pé ddaa, co cʉ maestro cʉ mí u̱jti cʉ cja̱hni cʉ Escritura, cja̱ co cʉ tita cʉ mí mandadobi cʉ cja̱hni, nucʉ, mí jonijʉ ja drí möhtijʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pe jí̱ mí tzö te di cjajpijʉ, como már ngu̱ cʉ cja̱hni cʉ mí tɛnijʉ car Jesús, cja̱ mí ndo tzøjmʉ di dyødejʉ göhtjo ca mí ma̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nu cʉ pa cʉ́, ca hnar vez, car Jesús már bbʉh pʉ jar ndo templo, már ujti cʉ cja̱hni pʉ, már xijmʉ ja i ncja car tzi jogui jña̱. Nubbʉ́, bú e̱h cʉ möcja̱ cʉ mí mandado, co ni cʉ ddáa cʉ mí nxöh cár ley car Moisés, co ni cʉ tita cʉ mí pɛhtzi quí cargojʉ jar templo. ");
INSERT INTO otsNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Guegue‑cʉ́ bi dyön car Jesús: ―Xijquije ya, ¿tema cargo guí pɛhtziguɛ pa gui dyøti yʉ cosa rá ngu̱? ¿To car cja̱hni xí ddahqui quer cargo?― ");
INSERT INTO otsNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Car Jesús bi da̱di, bi xijmʉ: ―Guejtjo gu önquijʉ hnar nttöni, cja̱ nuquɛjʉ, gui tja̱jtiguijʉ hne̱. ");
INSERT INTO otsNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nu car Juan ca mí xix yʉ cja̱hni, ¿cja güí hñe̱h ca Ocja̱ car cargo ca mí ja̱ guegue, cja̱ huá bú hna mbe̱ntsjɛ di hñe̱ di nzohquijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gueguejʉ ya, bi ña̱tsjɛjʉ bi ma̱jmʉ: ―Bbʉ gu ma̱jmʉ, guá hñe̱h ca Ocja̱ car Juan, xta dyönguijʉ nʉr Jesús, ¿dyoca̱ jí̱ xtá e̱me̱jʉ bbʉ́? ");
INSERT INTO otsNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Guejtjo bbʉ gu ma̱jmʉ, bú hna mbe̱ntsjɛ car Juan di hñe̱je̱ di nzojcöjʉ, nubbʉ, xta ccajnquijʉ me̱do yʉ cja̱hni, porque nuyʉ́ i ma̱jmʉ múr jmandadero ca Ocja̱ car Juan.― ");
INSERT INTO otsNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nubbʉ́, bi da̱h cʉ hñøjø‑cʉ́, jí̱ mí pa̱dijʉ jabʉ güí hñe̱h cár cargo car Juan. ");
INSERT INTO otsNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Car Jesús bi xijmʉ, bbʉ: ―Guejtjo jin gu xihquijʉ jabʉ xcuá hñe̱j nʉm cargo nʉ dí pɛhtzigö pa drá øti yʉ dí øte.― ");
INSERT INTO otsNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Diguebbʉ ya car Jesús bi nzoh cʉ cja̱hni, bi xih hnar bbede gá ejemplo: ―øde, ca hnar hñøjø mí tjɛ hnar jöy, xquí hñi̱ti pʉ cʉ za gá uva. Diguebbʉ, bi jion cʉ mɛfi pa di möh cʉ uva. Nucʉ, bbʉ xti da̱ cʉ uva, di döjtijʉ guegue car parte ca mí tocabi. Nubbʉ, bi ma gá ma pé hnar jöy car hñøjø‑ca̱, bú dé pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cja̱ bbʉ mí zøh car tiempo pa di joh cʉ uva, car jmu̱ bi gu̱h hnar mɛfi di ma du öjpi cʉ mɛfi cʉ uva cʉ mí tocabi guegue. Nu cʉ mɛfi cʉ mí föh car huerta, már ndo nttzo, jin gá ne gá döjtijʉ cʉ uva. Bú fɛtitjojʉ car mɛfi, bú ʉnijʉ, cja̱ bú tøjna̱ddijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bi ma gá ngoh car mɛfi pʉ jabʉ már bbʉh cár jmu̱, cja̱ guegue‑ca̱ pé bi gu̱h hnar mɛfi pa pé di ma pʉ. Nu cʉ mɛfi cʉ már bbʉh pʉ jar huerta, pé bú cjajpitjojʉ pʉ, bú fɛtijʉ, bú bbɛtibijʉ ʉ́r tzö, cja̱ bú tøjna̱dditjojʉ. Jin te gá döjtijʉ cʉ uva. ");
INSERT INTO otsNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Diguebbʉ ya, car jmu̱ pé bi gú̱ pé hnar mɛfi ca rí cja jñu̱. Lo mismo, pé bú jojʉ‑cá̱, cja̱ bú fonguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Gá nga̱x ya, car hñøjø ca múr mɛjti car huerta bi mbe̱ntsjɛ, bbʉ: “¿Xi ya? ¿Ja gu ncja ya? Gu cú̱j nʉm tzi ttʉ. ¿Cja jin da respetajʉ nʉ?” ");
INSERT INTO otsNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bi ma cár ttʉ, bbʉ. Nu cʉ mɛfi cʉ mí föh car huerta gá uva, bbʉ mí cca̱htijʉ, ya xi mbá e̱h cár ttʉ car jmu̱, bi chalajʉ, bi ma̱ntsjɛjʉ: “Tji nʉ́r ttʉ car jmu̱, ya xpa e̱je̱. Guejnʉ da tocabi car herencia‑nʉ́. Gu pöhtijʉ pa guejcöjʉ da tocaguijʉ car herencia.” ");
INSERT INTO otsNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Cja̱ bbʉ mí zøti pʉ car ba̱jtzi hñøjø, cʉ mɛfi bú fonguijʉ‑ca̱ cja̱ bú pöhtijʉ.― Diguebbʉ ya car Jesús bi dyön cʉ cja̱hni cʉ már ødejʉ, bi hñi̱mbijʉ: ―Nuya bbʉ, gui xijquijʉ, car tada ca to ʉ́r mɛjti car huerta, ¿te da cjajpi cʉ mɛfi‑cʉ? ");
INSERT INTO otsNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Da ma du mandado da bböhti. Diguebbʉ ya, pé da jioni pé ddáa cja̱ da döjti guegue‑cʉ cár huerta.― Gue nʉr bbede‑nʉ bi ma̱n car Jesús. Nu cʉ möcja̱ cja̱ co cʉ maestro cʉ mí nxöh car ley, bbʉ mí dyødejʉ nʉr bbede, bi ntzøtijʉ, bbʉ́, cja̱ bi ma̱jmʉ: ―Xa̱jma̱, jin da ncjá ncja ngu̱ ga ma̱ nʉr bbede‑nʉ́.― Bi ma̱jmʉ ncjapʉ porque bi jña̱jʉ ʉr huɛnda, mír tjɛquihui gueguejʉ cʉ mɛfi már nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Car Jesús, bbʉ, bi cca̱htitjo‑cʉ, cja̱ bi da̱di: ―Nde̱jma̱ da ncja ca i ma̱ nʉr bbede, como i ma̱m pʉ jar Escritura, guehca̱ i nesta da ncja‑ca̱. I ma̱ ncjahua: Car me̱do ca bi dyɛndi cʉ cja̱hni cʉ mí jøh car ngu̱, Guehcá̱ xí cjöx pʉ jár esquina car ngu̱, pʉ jabʉ i pɛnti cʉ cjoti. Guejtsjɛ ca Ocja̱ xí mandado xí cjöx pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bbʉ to da fehtzi car do‑ca̱, menta i bbʉjti hua jar jöy, da wah quí ndodyo. Pe bbʉ ya xtrú tti̱x pʉ ji̱tzi car me̱do‑ca̱, bbʉ da dögui cja̱ da zʉh hnar cja̱hni, exque da möhti.― Bi ma̱ ncjanʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bbʉ mí dyødejʉ nʉr palabra‑nʉ́, cʉ maestro cʉ mí nxöh car ley ca bi ma̱n car Moisés, co ni cʉ möcja̱ cʉ mí mandado, mí ne di zʉdijʉ car Jesús pa di gotijʉ födi. Como bi ba̱dijʉ, car Jesús már jɛqui gueguejʉ co cʉ mɛfi rá nttzo. Pe mí tzu̱jʉ di zʉjmʉ car Jesús, porque mí i̱na̱jʉ, certa te di cjajpijʉ cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pe nde̱jma̱ mí föjmʉ car Jesús pa jin di weni. Bi gu̱pjʉ cʉ dda hñøjø pa drí dɛnijʉ‑ca̱ cja̱ drí hñøxjʉ te mí ma̱. Nucʉ, mí cuatijʉ car Jesús ncjahmʉ mí ndo tzøjmʉ di dyødejʉ ca mí ma̱ guegue. Xquí tsjih cʉ hñøjø‑cʉ di jionijʉ ja drí jiötijʉ car Jesús pa di ma̱n hnar palabra ca di contrabi car gobierno, pa ncjapʉ di jogui di zʉdijʉ cja̱ di döjtijʉ jár dyɛ car gobernador. ");
INSERT INTO otsNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Cʉ hñøjø‑cʉ bi möjmʉ, bbʉ, bi guatijʉ car Jesús, cja̱ bi dyønijʉ ncjahua: ―Nuquɛ, maestro, dí pa̱dije guí ma̱n ca ncjua̱ni, cja̱ guí u̱jtiguije gu øtije ncjapʉ hne̱je̱. Jin guí johtitjoguɛ car cja̱hni ca i tti̱htzibi, guejtjo jin guí despreciabi car cja̱hni ca jin te i ntju̱mʉy. Guí xijtijʉ göhtjo yʉ cja̱hni parejo ja ncja drí hmʉy pa drí tzøh ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Te guí xijquije ya? ¿Cja rá zö ca dár döjtije car emperador romano cʉ contribución, cja̱ huá jin gui tzö? ¿Te i ma̱m pʉ jár ley ca Ocja̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nu car Jesús bi ba̱di, cʉ cja̱hni‑cʉ már joni ja drí dyøhtibijʉ ʉr ntjöti. Eso, bi xijmʉ: ―¿Dyoca̱ guí øjtiguijʉ trampa? ");
INSERT INTO otsNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Gui u̱jtiguijʉ ya hnar domi gá denario.― Cja̱ bi ttuni hnaa, bi cca̱hti. Nubbʉ, bi hñöni: ―¿To ʉ́r retrato na̱ i cuati huá, cja̱ to ʉ́r tju̱ju̱?― Cja̱ guegue‑cʉ bi da̱dijʉ: ―Gue car emperador, tzʉdi, car César.― ");
INSERT INTO otsNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Cja̱ car Jesús bi xijmʉ, bbʉ: ―Nubbʉ, i nesta gu cju̱htijʉ car emperador cʉ contribución, como í mɛjti guegue. Guejtjo i nesta gu döjtijʉ ca Ocja̱ quí mɛjti guegue‑ca̱ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Cʉ cja̱hni‑cʉ, masque mí joni ja ncja drí jiötijʉ car Jesús, pe jin gá nda̱pijʉ. Bbʉ mí dyøjmʉ ja ncja gá nda̱ guegue, bi hño í mʉyjʉ, cja̱ bi gohti í nejʉ. Guejtjo már øde rá ngu̱ cja̱hni ca te bi jma̱, cja̱ co ja gá nda̱h car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Diguebbʉ ya, bú e̱h cʉ dda cja̱hni cʉ mí tsjifi saduceo, bi guatijʉ car Jesús, como guejti‑cʉ mí ne di dyøhtibijʉ hnar prueba. Cʉ saduceo ya, i ma̱jmʉ, bbʉ i tu̱ hnar cja̱hni, ya jin da jña̱ ʉ́r jña̱. Ya xí mpuntjo. ");
INSERT INTO otsNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Cʉ cja̱hni‑cʉ bi dyönijʉ car Jesús: ―Nuquɛ, maestro, ca ndom titajʉ Moisés bi jñux pʉ jar Escritura, i̱na̱: “Bbʉ di du̱ hnar hñøjø, cja̱ jin te di zo yí ba̱jtzi, cja̱ bbʉ di hñi̱h hnár cjua̱da̱, bbʉ ya xtrú ndu̱ car hñøjø, nubbʉ́, cár cjua̱da̱ di ntja̱jtihui ca múr bbɛjña̱jma̱ car ánima, pa di hmʉh quí ba̱jtzi, ncjahmʉ dí ba̱jtzi car ánima, bbʉ́.” ");
INSERT INTO otsNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nuya bbʉ, hna vez, mí bbʉ yojto cjua̱da̱. Car da̱cjua̱da̱ bi ntjɛhui cár bbɛjña̱ cja̱ bi hmʉbi. Diguebbʉ bi du̱, jin te gá hñi̱hpi ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ca rí cja yojo bi cuajti bbʉ́. Nucá̱ pé bi ncjatjo ncja ca bbɛto ʉ́r cjua̱da̱, pé bi du̱tjo hne̱je̱, jin tema ba̱jtzi gá nzogui. ");
INSERT INTO otsNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nubbʉ́, cár cjua̱da̱ ca mír cja jñu̱ bi cuajti car bbɛjña̱ hne̱je̱. Jønca̱ bi ncjadi pʉ. Göhtjo cʉ yojto hna‑hnáa gá hmʉbi car bbɛjña̱. Nu car bbɛjña̱ jin gá ønte. Bi du̱ göhtjo cʉ cjua̱da̱. ");
INSERT INTO otsNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gá nga̱x ya, bi du̱ car bbɛjña̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nuya, bbʉ xta jña̱ ʉ́r jña̱ cʉ ánima, ¿to da hmʉbi car bbɛjña̱? como göhtjo xquí cjajpijʉ ʉ́r bbɛjña̱ hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Bi da̱h car Jesús bbʉ: ―Nuhua jar jöy yʉ hñøjø i ntjɛhui quí bbɛjña̱, i ntja̱jtihui. ");
INSERT INTO otsNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pe nu yʉ cja̱hni yʉ da ma̱n ca Ocja̱ da jña̱ ʉ́r jña̱ bbʉ ya xtrú ndu̱ cja̱ da hmʉh pʉ jabʉ rá zö, nuyʉ́, ya jin da ntja̱jti pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Guejtjo ya jin da du̱jʉ. Da ncjajʉ ncja ngu̱ cʉ ángele cʉ bí bbʉh pʉ jar ji̱tzi göhtjo ʉr tiempo. Ca Ocja̱ xta xox‑yʉ́, guejtjo xta uni hnar ddadyo nzajqui, ncja ngu̱ ca i pɛhtzi guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pe guejtsjɛ ca ndom titajʉ Moisés i xijquijʉ já libro cʉ bi dyøti guegue, cierto da jña̱ ʉ́r jña̱ cʉ cja̱hni cʉ xí ndu̱. Bbʉ mí ntjɛhui ca Ocja̱ car Moisés, pʉ jabʉ mí cca̱hti car tzi za már zø, nubbʉ ca Ocja̱ bi nzoh car Moisés, bi xifi: “Nugö, ʉ́r Cja̱a̱‑guigö car Abraham, cja̱ co car Isaac, cja̱ cor Jacob.” Ncjapʉ gá ma̱n ca Ocja̱. Pe nucʉ́, ya má yabbʉ xquí du‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¿Xi ya bbʉ? Bbʉ di mpun cʉ cja̱hni cʉ i tu̱, ¿cja di ma̱n car Tzi Ta ji̱tzi, ʉ́r Cja̱a̱ guegue cʉ cja̱hni cʉ xí ndu̱? Ji̱na̱. Guegue ʉ́r Cja̱a̱ cʉ cja̱hni cʉ i bbʉjtjo, masque ya xtrú ndu̱ quí cuerpojʉ. Eso, dí pa̱dijʉ, jin gui mpun cʉ cja̱hni cʉ mí e̱me̱jʉ ca Ocja̱ cja̱ xí ndu̱. Ca Ocja̱ i cca̱hti, i cjadi ʉ́r nzajqui göhtjo‑cʉ.― Bi ma̱ ncjanʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cʉ ddaa maestro cʉ már ødejʉ, bi tzøjmʉ nʉr palabra nʉ xquí ma̱n car Jesús. Cja̱ bi ma̱jmʉ: ―Ra zö nʉr palabra xcú ma̱nguɛ, maestro.― ");
INSERT INTO otsNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nu cʉ cja̱hni cʉ xquí dyøhtibijʉ car prueba car Jesús, bi cca̱htijʉ ya, gueguejʉ xquí hna̱pijʉ. Eso, ya jin gá tzö í mʉyjʉ pé di dyøhtibijʉ prueba car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Diguebbʉ ya, car Jesús bi dyøhtibi hnar prueba cʉ maestro cʉ mí nxöh cʉ Escritura, bi dyöni digue car Cristo ca di hñe̱je̱, ¿te dúr ncjahui car David? Bi ma̱: ―¿Dyoca̱ i ma̱n yʉ to i nxöh cʉ Escritura, bbʉ di hñe̱h ca hnaa ca di hñi̱x ca Ocja̱ pa drí mandado, guegue dúr mboxibbɛjto car David? ");
INSERT INTO otsNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Guejtsjɛ car David bi jñu̱x pʉ jar libro cʉ Salmo, bi hñi̱na̱: Car Tzi Ta ji̱tzi bi xih cam Tzi Jmu̱gö, bi hñi̱mbi: “Gui mi̱jcua jam jogui dyɛ, gu mföxihui gu mandadohui ");
INSERT INTO otsNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Hasta bbʉ xtá cjajpigö quir contra du e̱je̱, Da nda̱ndiña̱jmu̱ jer tzi huá, cja̱ nuquiguɛ, xquí mandadobi‑cʉ́.” ");
INSERT INTO otsNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Bbʉ mí ma̱ ncjapʉ car David, mí xifi ʉ́r tzi Jmu̱ car Cristo ca di hñe̱je̱. Xi ya bbʉ, ¿ja di ncja dúr jmu̱ car David car Cristo cja̱ guejtjo dúr mboxibbɛjto?― Gue nʉr nttöni‑nʉ bi dyön car Jesús. Nu cʉ maestro cʉ már ødejʉ, jin gá mba̱di ja drí da̱dijʉ, cja̱ bi gohtitjo í nejʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Már bbʉh pʉ rá ngu̱ cja̱hni, már øde. Nu car Jesús bi nzoh quí möxte, bi xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gui mfödijʉ, jin gui cjajʉ ncja ngu̱ yʉ maestro yʉ i nxöh car ley. Guegue‑yʉ i ndo tzøjmʉ da jiejʉ yí da̱jtu̱ rá ma, pa da ndo tti̱htzibi. Cja̱ i ne da ttzɛnguajʉ rá zö bbʉ ga hñojʉ já töy o já calle. Guejtjo i ndo tzøjmʉ da mi̱pjʉ jar templo pʉ jabʉ más rá ndo zö, cja̱ guejtjo bbʉ da ncja mbaxcjua, i ne da mi̱pjʉ pʉ jabʉ más da nrespetabijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nu cʉ cja̱hni‑cʉ, i cobrabi rá ma̱di cʉ tzi ddanxu̱ cʉ xí jmi̱pi domi, cja̱ diguebbʉ, bbʉ jin gui tzö da gu̱ti, i fongui jáy ngu̱‑cʉ. Guejtjo i ndo dé ga mahtijʉ ca Ocja̱ pa da mbe̱n cʉ cja̱hni, de vera i e̱me̱jʉ, cja̱ pa da ndo hñi̱htzibijʉ. Jiöjtetjo cʉ cja̱hni‑cʉ́. Ca más xtrú ndo jiöti yʉ cja̱hni, más drá ndo ngu̱ car castigo ca da ttun‑cʉ́.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Car Jesús már bbʉh pʉ jar goxtji car templo. Már jantitjo cʉ cja̱hni cʉ má tjohpʉ, már ʉti quí domijʉ jar caja, már döjʉ gá ofrenda. Bi tjoh cʉ dda rico, bi dyʉti quí domi rá tzi ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Diguebbʉ bi tjoh hnar ddanxu̱, múr tzi probe, bi dyʉti yojo cʉ tzi domi chi tchʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bi ma̱n car Jesús: ―Dyøjma̱jʉ nʉ dí xihquijʉ, nʉr tzi ddanxu̱‑nʉ xí dyʉti más rá ngu̱ ni digue yʉ rico, masque jin te i ja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yʉ rico, gue ca mí sobrabi xí döjʉ. Pe nʉr ddanxu̱‑nʉ́, xí dö göhtjo ca mí ja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Már ña̱jʉ cʉ cja̱hni, már cca̱htijʉ ja mí ncja car ndo templo. Bi ma̱jmʉ te tza már zö nguá ni̱gui cʉ ndo me̱do cʉ xcá ttøti car templo, cja̱ co te tza már zö hne̱je̱ cʉ adorno gá oro co gá plata cʉ xquí un cʉ cja̱hni gá ofrenda. ");
INSERT INTO otsNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Car Jesús bi ma̱m bbʉ: ―Nu yʉ cosa yʉ guí cca̱htijʉ jar templo, xta zøh car pa bbʉ xta mpuni ntero‑yʉ́, ntero xta tjøhte. Da mfonti yʉ ndo me̱do, ni di yojo da mfi̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Cja̱ quí möxte bi dyönijʉ bbʉ: ―Maestro, ¿ncjahmʉ da mpun nʉr templo? ¿Tema seña da ni̱gui pa drí fa̱h bbʉ ya xta ncjapʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Cja̱ bi da̱h car Jesús: ―I bbɛjtjo. Pe gui mfödijʉ rá zö pa jin to da jiöhquijʉ. Dí xihquijʉ, du e̱ rá ngu̱ cja̱hni cʉ da ma̱: “Guejcö dúr cja̱hni xí hñi̱xquigö ca Ocja̱ pa gu mandado.” Guejtjo da xihquijʉ: “Ya xí nzøh car hora, ya xta guaj nʉr mundo.” Pe jin gui ma gui tɛnijʉ‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cja̱ bbʉ xtí dyødejʉ, i ndo cja tu̱jni, o i ndo cja guerra, dyo guí ntzu̱jʉ. I nesta bbɛto da ncja‑cʉ́, pe jí̱ bbe di tzøh car pá bbʉ xta ncja ca xtú ma̱. Nucá̱, pé da tzi dé.― ");
INSERT INTO otsNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cja̱ pé bi xih quí möxte, bi hñi̱mbijʉ: ―Cʉ mi̱ngu̱ hnar jöy da ʉjʉ cʉ pé dda mi̱ngu̱ ca pé hnar jöy. Cár gobierno hnar jöy da ntu̱jnihui cár gobierno ca pé hnar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Da ndo hño cʉ hña̱mijöy, cja̱ cʉ dda lugar da ncja tju̱ju̱, da ndo hño cʉ jñi̱ni rá nttzo. Da ndo ntzu̱ yʉ cja̱hni, cja̱ nʉ jar ji̱tzi da ni̱gui cʉ ndo seña. ");
INSERT INTO otsNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pe ante que da ncja ya‑cʉ́, da ttzʉhquijʉ, da cjöpiquijʉ, da ttzixquijʉ já ni̱cja̱, da cjohquijʉ födi, da ttɛnquijʉ delante cʉ rey co ni cʉ gobernador, por rá nguehca̱ grí tɛnguigöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pe bbʉ xta ttzixquijʉ pʉ, da ttönquijʉ, ¿toca̱ guí e̱me̱jʉ? nubbʉ́, da jogui gui xijmʉ guejquigö guí tɛnguigöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nuya bbʉ, gui dyɛn quir mʉyjʉ, jin gui ndo mbe̱nijʉ te gui tja̱dijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nugö, gu ddahquijʉ jogui mfe̱ni pa gui tja̱dijʉ rá zö, cja̱ quir contrajʉ jin da ba̱dijʉ te pé da xihquijʉ pa da da̱hquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Drá ngu̱ cja̱hni da ʉquijʉ por rá nguejquigö. Hasta mismo quer me, quer ta, quir cjua̱da̱, quir parientejʉ, quir amigojʉ, guejti‑cʉ da döquijʉ pʉ jáy dyɛ quir contrajʉ. Cja̱ ddaaquiguɛjʉ da bböjtiquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pe jin to te da cjahquijʉ bbʉ jí̱ xtrú un cár tsjɛjqui ca Ocja̱. Nim pa hner xta̱jʉ da bbɛdi. ");
INSERT INTO otsNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bbʉ gui zɛjmʉ ca grí hñe̱me̱guijʉ cja̱ jin da dyʉxi ir mʉyjʉ, nubbʉ, cierto da ttahquijʉ car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Xta zøh cʉ sundado rá ngu̱ cja̱ xta hñi̱ti madé na̱r jñi̱ni Jerusalén. Bbʉ xquí jiantijʉ‑cʉ, nubbʉ, xtí pa̱dijʉ, ya xta tjøhti na̱r jñi̱ni‑na̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Cʉ cja̱hni cʉ di bbʉjcua nʉr estado Judea, cʉ pa‑cʉ́, da mpɛgui da ddaguijʉ, drí möjmʉ já ttøø. Cja̱ cʉ to di bbʉjcua na̱r jñi̱ni, mejor da bønijʉ nttzɛdi. Cʉ cja̱hni cʉ di bbʉ jar campo, jim pé du cojmʉ hua jar ciudad, da ddaguijʉ yapʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Cʉ pa‑cʉ́, da ncohtzibi cʉ cja̱hni ca rá nttzo ca xí dyøte, da ncastigajʉ. Da ncumpli göhtjo ca i ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Cʉ bbɛjña̱ cʉ di hñʉ, cja̱ co cʉ di tzi quí tzi wɛne, da ndo sufrijʉ cʉ pa‑cʉ́. Da ndo ncastiga göhtjo cʉ cja̱hni cʉ di bbʉjcua nʉr jöy Israel, cʉ pa‑cʉ́, como ya xtrú ungui ʉr cuɛ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Da ndo ncja guerra, drá ngu̱ cja̱hni da bböhti gá espada, cʉ dda mi̱ngu̱ hua da ttɛni gá preso, pé drí möjmʉ hnahño jöy. Cja̱ cʉ gentile cʉ jin gui tzu̱jʉ ca Ocja̱ da mandadojʉ hua jár jöy yʉ judio. Nu cʉ judio cʉ múr mɛjtijma̱jʉ na̱r jñi̱ni Jerusalén da gojmʉ jöy cja̱ da sufrijʉ. Cʉ hnahño cja̱hni da mandado hua hasta bbʉ xta zøh car tiempo ca xí mbe̱n ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nubbʉ, da ni̱gui cʉ dda seña nʉ jar ji̱tzi, co hne̱cua jar jöy. Bbʉ xta jianti cʉ cja̱hni ja ncja drí ni̱gui car jiadi, car za̱na̱, cja̱ co yʉ tzø, da ndo hño í mʉyjʉ. Guejti nʉr mar da ndota jia, cja̱ nʉr nda̱ji̱ da ndo dyɛntzi car deje. Cja̱ bbʉ da cca̱hti cʉ cja̱hni cʉ seña‑cʉ, da ndo ntzøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Da ndo ntzu̱ yʉ cja̱hni, hasta da ma̱jmʉ, ya jin da jiötijʉ. Da mbe̱nijʉ, ya xta tjej nʉr mundo. Cja̱ guejti pʉ jar ji̱tzi, da ndo hñá̱n cʉ tzø, car jiadi, car za̱na̱, ncjahmʉ di ne di mpunijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hasta gue bbʉ ya xtrú ni̱gui cʉ seña‑cʉ, nubbʉ, cja pé xcuá e̱cö. Nubbʉ, cja xta jiantigui yʉ cja̱hni, gár ca̱ já gu̱y, gár ja̱ cam cargo pa gu mandado. Nubbʉ, xta ni̱gui te tza drá nzɛjqui cja̱ te tza dúr nda̱gö. ");
INSERT INTO otsNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pe nuquɛjʉ, bbʉ xta mʉdi xta ncja cʉ cosa‑cʉ, jin gui ndo ntzøtijʉ, da jñu̱ ir mʉyjʉ. Gui mbe̱nijʉ, ya tchʉtjo pé xcuá cojcö, gu cjʉxquijʉ pa jin gui nú̱jʉ car castigo ca ba e̱je̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Diguebbʉ ya car Jesús bi xih quí möxte hnar palabra gá comparación, bi hñi̱mbijʉ: ―Jiantijma̱jʉ nʉr za gá higo co ni yʉ pé dda za hne̱je̱, cja̱ gui mbe̱nijʉ ja i ncja‑yʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bbʉ i ddoj ya‑yʉ, nubbʉ, guí pa̱dijʉ, ya xta zøh cʉ za̱na̱ rá mpa. Jin gui nesta da tsjihquijʉ te da ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Guejtjo bbʉ xta ncja cʉ cosa cʉ xtú xihquijʉ, nubbʉ, cja xquí pa̱dijʉ, bbʉ, ya xqui tchʉdipʉ xcuá cojcö hua jar jöy pa gu mandado. ");
INSERT INTO otsNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Dyøjma̱jʉ nʉ gu xihquijʉ, ddaaquiguɛjʉ, yʉ cja̱hni yʉ i bbʉj yʉ pa ya, da hmʉjtijʉ hasta cʉ pa‑cʉ, hasta gue bbʉ ya xtrú ncja göhtjo cʉ xtú xihquijʉ ya. ");
INSERT INTO otsNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Xtu e̱h car pá bbʉ xta mpun nʉr jöy co ni nʉr ji̱tzi, ncja ngu̱ xtá xihquijʉ. Nu cʉm palabra xtú ma̱, jin da mpun‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Gui mbe̱nijʉ, cierto da ncja yʉ cosa yʉ xtú xihquijʉ, cja̱ gui hmʉpjʉ listo. Jin da ma ir mʉyjʉ yʉ te i cja hua jar jöy. Jin gui nti̱jʉ, cja̱ jin gui teti quir fuerzajʉ co cʉ cosa cʉ da tjojtjo. Bbʉ gui dyøtijʉ ncjapʉ, gui hñojʉ peligro, certa da hna zʉhquijʉ car pa bbʉ pé xcuá e̱cö, cja̱ nuquɛjʉ, xtá töhquijʉ guir øtijʉ ca jin gui conveni, ncja ngu̱ cʉ cja̱hni cʉ jin gui tɛnguigö. Como xta hna zʉh cʉ cja̱hni car pa‑ca̱, göhtjo cʉ di bbʉjcua jar jöy, cja̱ jin da ba̱h‑cʉ, má̱s te da ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pe nuquɛjʉ, gui mfödijʉ göhtjo ʉr tiempo, gui tøhmijʉ car pa‑cá̱. Gui nzojmʉ ca Ocja̱ pa jin da da̱hquijʉ cʉ prueba cʉ ba e̱je̱. Nubbʉ́, da jogui gui mpresentajʉ pʉ jabʉ xtá hmʉjcö, bbʉ pé xcuá e̱je̱, cja̱ jin gui pɛhtzi ir tzöjʉ. Nugö, dúr cja̱hni xpá bbɛnqui hua jar jöy.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Göhtjo ʉr pa, car Jesús mí ujti cʉ cja̱hni pʉ jar ndo templo. Bbʉ nxu̱y mí pøni, mí pa jar ttøø ca mí tsjifi Olivos, mbí oxi pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bbʉ nxudi ya, mí ndo nxuditjo, mí pa jar templo, már u̱jti cʉ cja̱hni pʉ. Mbá cuatijʉ cja̱hni rá ngu̱ pa di dyødejʉ te mí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Diguebbʉ ya, ya xti ncja car mbaxcjua bbʉ mí tzijʉ tju̱jme̱ cʉ jin te mí yojmi car levadura. Mí tsjih car mbaxcjua‑cá̱, ʉr Pascua. ");
INSERT INTO otsNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Cʉ möcja̱ cʉ mí mandado, co ni cʉ maestro cʉ mí u̱jti cʉ cja̱hni cár ley car Moisés, nucʉ́ mí ne di möhti car Jesús. Mí jonijʉ ja drí möhtijʉ cja̱ jin di ba̱h cʉ cja̱hni, como gueguejʉ mí tzu̱jʉ‑cʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nubbʉ́, ca Jin Gui Jo bi guati car Judas ca mí tsjifi ʉr Iscariote, cja̱ bi xifi di dö car Jesús. Car Judas mí hñohui cʉ pé once quí möxte car Jesús, cja̱ mí tsjifi múr möxte hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Cja̱ bi ma car Judas, bú nzoh cʉ möcja̱ cʉ mí mandado co ni cʉ policia cʉ mí föh car ni̱cja̱. Bi xih‑cʉ, guegue mí ne di dö car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nuya cʉ́, bi mpöjmʉ cja̱ bi ña̱htijʉ domi bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Car Judas bi jña̱ car domi cja̱ bi prometebi cʉ möcja̱ di jion car manera ja drí dö car Jesús bbʉ jin di tɛn cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pé bi tjoh cʉ pa, cja̱ bi zøh ca mero ʉr pa bbʉ mí tzijʉ cʉ tju̱jme̱ cʉ jin te mí yojmi levadura. Car pa‑cá̱, mí bböhti cʉ tzi dɛtitjo, pa di jña̱htibi car Tzi Ta ji̱tzi, cja̱ di ttzajpi cár ngø. ");
INSERT INTO otsNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nubbʉ, car Jesús bi gu̱h car Pedro co car Juan, bi xijmi: ―Gui mɛhui ya, ma bú jojquihui car jñu̱ni gá mbaxcjua pa gu tzijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gueguehui bi dyönihui: ―¿Jabʉ guehpʉ guí ne gu jojquigöbbe‑ca̱?― ");
INSERT INTO otsNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Bi ma̱n car Jesús, bbʉ, bi hñi̱mbihui: ―Bbʉ ya xtí cʉtihui jar ciudad pʉ Jerusalén, xtí ntjɛjʉ hnar hñøjø ba tu̱ hnar xøni car deje. Gui tɛnihui, cja̱ gui cʉtihui pʉ jabʉ da ñʉti‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Gui xijmi car mi̱ngu̱ pʉ, gui hñi̱mbihui: “Cam Maestroje i önqui, i̱na̱: ¿Jabʉ i bbʉh car cuarto pa cʉ visita, pʉ jabʉ gu tzije car jñu̱ni gá mbaxcjua, nugö co cʉm möxte?” Gui dyönihui ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Cja̱ car mi̱ngu̱ pʉ, da u̱jtiquihui hnar cuarto pʉ ña̱. Drá tzi noh car cuarto‑ca̱, cja̱ ya xtrú tjojqui. Guehpʉ jar cuarto‑ca̱ gui jojquihui ca te i nesta pa gu tzijʉ car jñu̱ni gá mba̱xcjua.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nubbʉ, bi ma car Pedro co car Juan, gá ma jar ciudad, bú tötihui ncja ngu̱ gá tsjijmi, cja̱ bú jojquihui car jñu̱ni gá mbaxcjua pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bbʉ mí zʉh car hora, bi ma car Jesús co cʉ pé dda quí möxte. Bi zøtijʉ pʉ, cja̱ göhtjo bi guatijʉ jar mexa. ");
INSERT INTO otsNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Car Jesús bi xih‑cʉ: ―Xtú ndo tøhmi nʉr pa‑ya pa da jogui gu tzijʉ na̱r jñu̱ni gá mbaxcjua, dí göhtjojʉ, cja̱ diguebbʉ ya, i nesta gu sufrigö. ");
INSERT INTO otsNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Dí xihquijʉ, ya jim pé gu tzögö na̱r mbaxcjua‑na̱ hasta gue bbʉ xtá mandadogöbbe car Tzi Ta ji̱tzi hua jar jöy. Nubbʉ, pé da ttøti hnar mbaxcjua ncja ngu̱‑ná̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Diguebbʉ, bi du̱u̱ hnar vaso ca mí po vino, cja̱ bi dyöjpi cjama̱di car Tzi Ta. Ma ya, bi un quí möxte, bi xijmʉ: ―Nuquɛjʉ, hna‑hnaa grí tzijʉ na̱r vino‑na̱. ");
INSERT INTO otsNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nugö, desde rá pa ya, jim pé gu yojpi gu tzi ná̱r jugo car uva hasta gue bbʉ xta mandado cam Tzi Ta hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Diguebbʉ, bi jña̱ hnar tju̱jme̱, bi dyöjpi cjama̱di car Tzi Ta ji̱tzi, bi jejque cja̱ bi un quí möxte, bi xijmʉ: ―Na̱r tju̱jme̱‑na̱, gue nʉm cuerpogö gu dö por rá nguehquɛjʉ. Gui tzijʉ na̱r tju̱jme̱‑na̱ pa grí mbe̱nguigöjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cja̱ bbʉ mí guadi mí zijʉ, car Jesús pé bi du̱u̱ hnar vaso ca mí po vino, bi ma̱: ―Tji na̱r vino‑na̱, gue cam cji ca ya xta mfömbigui por rá nguehquɛjʉ. Da ncjapʉ drí ttøti car ddadyo acuerdo ca gu ddahquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dyøjma̱jʉ. Ra bbʉjcua jar mexa, hua jabʉ dár tzijʉ, ca hnar hñøjø ca da döguigö. ");
INSERT INTO otsNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nugö dúr cja̱hni xpá bbɛnquigö hua jar jöy, cja̱ i nesta gu sufri ncja ngu̱ ga ma̱m pʉ jar Escritura. Nu car cja̱hni ca da döguigö, guegue da ndo castiga ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Diguebbʉ ya, quí möxte car Jesús bi mʉdi bi hñöntsjɛjʉ, ¿toca̱ di dyøhtibi‑ca̱? ");
INSERT INTO otsNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Quí möxte car Jesús már hñɛxjʉ, már ma̱jmʉ ja ndrá nguehca̱ más di tti̱htzibi, como cada hnaa mí ne di mandadobi cʉ pé ddaa. ");
INSERT INTO otsNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nu car Jesús bi nzojmʉ, bi hñi̱mbijʉ: ―Dyo guí ncjajʉ ncja ngu̱ cʉ cja̱hni cʉ jin gui e̱me̱ ca Ocja̱. I ndo hñi̱xtsjɛ quí rey cʉ i mandadobi‑cʉ, cja̱ i ndo ɛti cʉ cja̱hni da cjajpi quí jmandadojʉ. Cja̱ nucʉ, i ndo johtitjo quí autoridadjʉ ga nzojmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nuquiguɛjʉ, dyo guí ncjajʉ pʉ. Bbʉ to i ne da cja ʉr nda̱, da mbe̱ni ncjahmʉ jin te di ntjumʉy guegue. Bbʉ to i ne da tti̱htzibi, da ncjá ncja hnar muzo, da dyøhtibi quí jmandado cʉ pé ddaa. ");
INSERT INTO otsNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Digue yʉ cja̱hni yʉ i bbʉjcua jar mundo, ¿toca̱ más i tti̱htzibi? ¿Cja gue car muzo ca i cja jmandado? ¿Cja huá gue cár patrón ca i ju̱jti pʉ jar mexa? Nuquɛjʉ, güi ma̱jmʉ, más i tti̱htzibi car patrón ca i ju̱h pʉ jar mexa. Pe nugö, ir tzi jmu̱guijʉ, cja̱ dí sirvequitjojʉ ncja ngu̱ hnar muzo. ");
INSERT INTO otsNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Xí ndo ttøjtigui tu̱jni, pe nuquɛjʉ, xcú tɛnguitjojʉ, jí̱ xquí wembiguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Por rá nguehca̱, bbʉ xta zøh car pa ca xí ma̱n car Tzi Ta ji̱tzi̱, nugö, xtá ddahqui quir cargojʉ, ncja ngu̱ cam Tzi Ta xcá ddajqui cam cargogö. ");
INSERT INTO otsNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bbʉ xta ttajqui cam cargo pa gu mandado, da tocaquijʉ gui föxquijʉ. Xquí mi̱pjʉ jam mexagö, xcrí tzijʉ pʉ, dí göhtjojʉ. Guejtjo da tocaquijʉ cada hnaaquɛjʉ hner tronojʉ pa gui jñu̱xjʉ pʉ jabʉ gui mandadobijʉ göhtjo cʉ pé dda cja̱hni israelita.― Bi ma̱ ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Diguebbʉ ya, guegue bi nzoh car Simón, bi xifi: ―Nuquɛ, Simón, dyøjma̱ na̱r palabra na̱ gu xihqui. Car Satanás xí dyöjqui ʉr tsjɛjqui da dyøjtiqui hnar prueba, xta jion car manera ja drí wentziqui pa ya jin gui tɛnguigö. Cja̱ cierto xta dá̱hqui, xta cjahqui gui wembigui pa hna ratotjo. ");
INSERT INTO otsNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pe nugö, xtú nzoh cam Tzi Ta ji̱tzi por rá nguehquɛ, pa jin gui jiɛh ca guír hñe̱me̱gui. Bbʉ pé xcuí coji, pé xtí tɛngui. Nubbʉ, cja xtí föx yir hñohui pa da zɛdi drí dɛngui‑yʉ hne̱je̱.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nu car Pedro bi da̱j ya bbʉ́, bi hñi̱mbi: ―Nuquɛ, Tzi Jmu̱, jin gu wembiqui. Xtá tɛnquitjo masque da cjojquihui födi. Masque xín da bböjtiguihui dí yojmi, pe jin gu jɛquiqui.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Car Jesús ya bi da̱di: ―Dí xihqui, Pedro, jim bé di mah car ndøxca, rá nxu̱nya, cja̱ xquí cønguigö jñu̱ vez, xquí ma̱, nim pa guí meyagui.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Diguebbʉ ya car Jesús bi xih quí möxte: ―¿Cja guí mbe̱nijʉ bbʉ ndú cu̱hquijʉ car jmandado, cja̱ jin te guí jña̱x quir domijʉ, ni digue quir ddøza̱jʉ, guejtjo jin guí cʉxijʉpé hnar pare quir zɛxtijʉ? ¿Cja bi cjahquijʉ tema falta, bbʉ́?― Bi da̱j ya quí möxte, bi hñi̱na̱jʉ: ―Jin te gá cjaguije ʉr falta.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Cja̱ pé bi xijmʉ bbʉ: ―Nuya, dí xihquijʉ, bbʉ guí pɛhtzijʉ domi o bbʉ guí pɛhtzijʉ hner ddøza̱, gui jña̱xjʉ‑cʉ. Guejtjo gui jña̱xjʉ hnar espada. Cja̱ bbʉ jin te guí pɛhtzijʉ espada, gui pö hner da̱jtu̱jʉ, pa gui töjmʉ‑cá̱, porque nugö, ya jin gu hmʉjcua. ");
INSERT INTO otsNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dí xihquijʉ, ya xta ncjagui ca i ma̱m pʉ jar Escritura, pʉ jabʉ i ma̱: “Bi tja̱mpi ʉr huɛnda, bi ma̱jmʉ, mí ndo ndu̱jpite car cja̱hni‑ca̱.” Car palabra‑ca̱, i ña̱ diguejquigö, i ma̱, da tjøxqui ca rá nttzo, cja̱ da bböjtigui. Tiene que da ncumpli göhtjo ca i ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Diguebbʉ ya, bi ma̱n quí möxte, bi hñi̱mbijʉ: ―Nuquɛ, Tzi Jmu̱, nú̱jma̱, ya xtí pɛhtzije yojo yʉm espadaje.― Cja̱ bi u̱jtijʉ. Car Jesús ya bi da̱h bbʉ́: ―Ya co guejyʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Diguebbʉ ya, bi bøn car Jesús, bi ma gá ma jar ttøø ca i tsjifi Olivos, porque göhtjo ʉr nde mí pa pʉ, cja̱ bi dɛn quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bbʉ mí zønijʉ pʉ, car Jesús bi xih‑cʉ́, bi hñi̱mbijʉ: ―Gui dyöjpijʉ car Tzi Ta ji̱tzi da möxquijʉ, pa jin da da̱hquijʉ cʉ prueba cʉ ba e̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nubbʉ, bi weni guegue gá ma hnanguadi. Cja̱ pʉ jabʉ már bbʉy, mí tzi jñajquihui quí möxte, ncjá nʉ jabʉ i tzoh hnar doo bbʉ ga ttɛy. Nupʉ́, bi nda̱ndiña̱jmu̱ cja̱ bi nzoh car Tzi Ta. ");
INSERT INTO otsNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Bi xifi: ―Nuquɛ, Tzi Ta, bbʉ guí ne, gui jña̱gui tzʉ car sufrimiento ca xta zʉjqui, pa jin da nesta gu tu̱. Pe jin da ncjá ncja ngu̱ dar negö. Nu ca guí neguɛ, da ncja‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Cja̱ bú ca̱h hnar anxe jar ji̱tzi, bi guati car Jesús, bi jñu̱htibi ʉ́r mʉy. ");
INSERT INTO otsNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nu car Jesús como már ndo sufri, más bi ndo ora, hasta bi ndo xöntje. Cár xöntje már yojmi cji, cja̱ bi cjʉxti jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bi guadi bi nzoh cár Tzi Ta, cja̱ bi bböy, bi ma gá ngoh pʉ jabʉ már bbʉh quí möxte. Bi döti már a̱jmʉ, como mí ndo du̱mʉy‑cʉ́, jin gá jiöti di zödijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Car Jesús bi nzojmʉ, bi dyönijʉ: ―¿Dyoca̱ guí a̱jmʉ? Nantzijʉ ya, cja̱ gui nzojmʉ car Tzi Ta ji̱tzi pa jin da da̱hquijʉ cʉ prueba cʉ ba e̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Már ma̱ndi cʉ palabra‑cʉ́, cja̱ bi hna zøh cʉ cja̱hni már ngu̱. Mbá bbɛto car Judas Iscariote. Nucá̱, xquí hñohui cʉ pé dda once hñøjø cʉ xquí ttun cár cargojʉ gá apóstole. Guegue‑ca̱ bi guati car Jesús, cja̱ bi zʉhtibi cár jmi. ");
INSERT INTO otsNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Car Jesús bi xifi: ―Nuquɛ, Judas, ¿cja ya xcrí hñe̱j ya, gui döguigö pa da zʉjqui yʉ cja̱hni? ¿Sá hne̱ guá tzʉjtigui nʉm jmi, bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Cʉ pé dda hñøjø cʉ már bbʉbi car Jesús bi cca̱htijʉ ya xti ttzʉh‑cá̱. Bi dyönijʉ, bbʉ: ―¿Cja gu cja ʉm dyɛje, Tzi Jmu̱? ¿Cja gu fendequije co yʉ cjuay?― ");
INSERT INTO otsNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ca hnár möxte ya, bi hna jiɛjquibi hnár gu̱ cár muzo car da̱möcja̱ ca mí mandadobi cʉ pé ddaa. Mí gue cár gu̱ pʉ jár lado derecho bi jiɛjquibi. ");
INSERT INTO otsNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Car Jesús bi nzoh quí möxte, bi xijmʉ: ―Jiɛjma̱jʉ ya.― Cja̱ bi pɛhmpi cár gu̱ car hñøjø‑cá̱, bi jojquibi. ");
INSERT INTO otsNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Diguebbʉ ya, car Jesús bi nzoh cʉ möcja̱ cʉ mí mandado, co cʉ sundado cʉ mí föh car templo, co ni cʉ tita. Göhtjo‑cʉ xquí zøjø, xcuí hñe̱jmʉ pa di zʉdijʉ. Guegue bi xijmʉ: ―¿Dyoca̱ xcú hñe̱jmʉ hua gui tzʉjcöjʉ, guá cʉjʉ cjuay co za, ncjahmʉ dúr be̱gö? ");
INSERT INTO otsNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Göhtjo ʉr pa ndí bbʉpjʉ jar templo. ¿Sá, jin gú tzʉjquijʉ bbʉ́? Gue nʉr hora‑ya xí ttungui ʉr tsjɛjqui ca Jin Gui Jo pa da mandado. Eso, ya xí jogui gui cjaguijʉ ca guí nejʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nubbʉ́, bi pɛntijʉ car Jesús cja̱ bi zixjʉ gá ma pʉ jár ngu̱ car möcja̱ ca más mí ja̱ cár cargo. Nu car Pedro má tɛnda xʉtja car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bi hñu̱h hnar tzibi cʉ cja̱hni pʉ jar patio, cja̱ bi mi̱pjʉ pʉ pa di pahtijʉ. Cja̱ car Pedro ya, guejtjo bi mi̱h pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nubbʉ́, ca hnar muza bi meya car Pedro, como mí töti cár tjay car tzibi pʉ jabʉ már ju̱ guegue. Bi ma̱m bbʉ: ―Nʉr hñøjø‑nʉ́, mí yojmi car Jesús.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bi gøn car Pedro, bbʉ́, bi ma̱: ―Nuquɛ, na̱na̱, jin dí meyagö‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pé hna tzi rato bi ma̱ pé hnar cja̱hni: ―Nuquɛ, nguí yojmi quí möxte car Jesús.― Bi da̱h car Pedro, bbʉ́: ―Ji̱na̱‑gö, tada.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pé bi tjoh hnar hora, cja̱ bi hna ma̱ndi pé hnar cja̱hni̱: ―Ncjua̱ni, nʉr hñøjø‑nʉ mí yojmi car Jesús, como guejti nʉ́ ʉr mi̱ngu̱ Galilea.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Car Pedro bi da̱di: ―Nuquɛ, tada, jin dí pa̱di ter bɛh ca̱ guí ma̱.― Már ma̱ndi ncjapʉ car Pedro, cja̱ bi hna mah car ndøxca. ");
INSERT INTO otsNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nu car Tzi Jesús, bi bböti pʉ jabʉ már bböy, bi jianti car Pedro. Nubbʉ́, bi mbe̱n car Pedro te xquí ma̱n car Jesús bbʉ mí xifi: “Ante que da mah car ndøxca, xquí cønguigö jñu̱ vez.” ");
INSERT INTO otsNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bi bøn car Pedro bbʉ, cja̱ bi ndo nzoni. ");
INSERT INTO otsNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Cʉ hñøjø cʉ mí zɛti car Jesús, bi dyøhtibijʉ ʉr burla, cja̱ bi gʉjʉ za gá mɛtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bi gojtibi hnar da̱jtu̱ qui dö, bi segue bi mɛtijʉ, bi xijmʉ: ―Ma̱nguɛ ya, toca̱ xí ʉnqui, bbʉ guí pa̱di.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Cja̱ pé bi xijmʉ ndu̱ntji palabra már nttzo. Bi dé bi bbɛtibijʉ ʉ́r tzö car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cja̱ bbʉ ya xquí ni̱gui ya, bi jmu̱ntzi cʉ nzöya, co hne̱h cʉ möcja̱ cʉ más mí mandado, co cʉ maestro cʉ mí nxöh car ley. Bi dyɛnijʉ car Jesús pʉ jabʉ már ncja cár junta gueguejʉ, pa di ttöni ter bɛh ca̱ xquí dyøte. ");
INSERT INTO otsNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bi xijmʉ, bbʉ: ―Nuquɛ, gui xijquije ya, ¿cja xí hñi̱xqui ca Ocja̱ pa gui mandado? ¿Cja guehquɛ gúr Cristo ca di mɛjni guegue?― Bi da̱j ya car Jesús: ―Bbʉ gu xihquijʉ, guejquigö, jin gui hñe̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Guejtjo hne̱, bbʉ gu önquijʉ, ¿cja guejquigö dúr cja̱hni di bbɛnqui hua jar jöy? Nuquɛjʉ, jin gui tja̱jtiguiJʉ. Guejtjo jin gui xojtiguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pe desde rá pa ya, xta tti̱xquigö pʉ jabʉ bí bbʉh car Tzi Ta ji̱tzi. Guegue‑ca̱ rá nzɛdi cja̱ göhtjo i mandado. Gu má grí mi̱jcö pʉ jár jogui dyɛ, gu mföxibbe cár jmandado. Guejquigö dúr cja̱hni, xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gueguejʉ bi dyönijʉ, bbʉ: ―¿Casʉ guí ma̱nguɛ ʉ́r Ttʉquiguɛ ca Ocja̱, bbʉ?― Cja̱ car Jesús bi da̱di: ―Ja̱a̱, guejguigö. Guehquiguɛjʉ, ya xcú ma̱ntsjɛjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bi ma̱n‑cʉ, bbʉ: ―¿Te pé dí jonijʉ ya? I nesta da bböhti‑nʉ. Cja xtú ødejʉ xcá ma̱, i ne da cjatsjɛ ca Ocja̱‑nʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bi bøn cár juntajʉ bbʉ, cʉ tita co cʉ möcja̱ cʉ mí mandado, bi zixjʉ car Jesús pʉ jabʉ már bbʉh car gobernador. Guegue‑ca̱ mí ju̱ cár tju̱ju̱ múr Pilato. ");
INSERT INTO otsNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cja̱ bbʉ mí zøtijʉ pʉ, bi mʉdi bi jiøxjʉ bbɛtjri rá ngu̱, mí ma̱jmʉ: ―Nʉr hñøjø‑nʉ, i ndo jöti yʉ cja̱hni, i xifi jin da gu̱hti car gobierno car contribución, cja̱ i ma̱ntsjɛ guegue ʉr rey xpá mɛjni ca Ocja̱, pa da mandadoguije, dí judioje.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Car Pilato bi dyöni, bbʉ: ―¿Cja cierto ʉ́r reyqui yʉ judio?― Cja̱ bi da̱h car Jesús: ―Guejquigö, ncja ngu̱ gri ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nubbʉ, car Pilato bi xih cʉ möcja̱ cʉ mí mandado co cʉ cja̱hni rá ngu̱ cʉ xquí jmu̱ntzi, bi hñi̱mbijʉ: ―Nunʉ́, jin te dí töhtibi ca xtrú dyøti ca rá nttzo.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nu cʉ cja̱hni bi ndo zɛtjo, bi ma̱jmʉ: ―Nʉr hñøjø‑nʉ, cjuá xí jiöti cʉ cja̱hni. I ne da xoxi tu̱jni, como i u̱jti yʉ cja̱hni ddadyo mfe̱ni. Bú fʉh pʉ jar estado Galilea, guá u̱jti cʉ cja̱hni cʉ mfe̱ni‑cʉ, cja̱ pé xcuá hñe̱cua, pé xqui u̱jti hua hne̱je̱. Ya xqui ne da jiöti göhtjo yʉ i bbʉjcua nʉr estado Judea.― Ncjapʉ gá ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nu car Pilato ya, bbʉ mí dyøde, guehpʉ Galilea xcuí mʉdi xcuí u̱jti cʉ cja̱hni car Jesús, nubbʉ, bi dyön cʉ cja̱hni: ―¿Cja ʉr mi̱ngu̱ Galilea nʉr hñøjø‑nʉ?― Cja̱ bi da̱h‑cʉ: ―Ja̱a̱, ʉr mi̱ngu̱ Galilea.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cʉ pa‑cʉ́, car Herodes már bbʉh pʉ jar jñi̱ni Jerusalén, xcuí hñe̱h pʉ jar estado Galilea, pʉ jabʉ már mandado. Mí tocabi guegue di reglabi quí asunto cʉ mi̱ngu̱ Galilea. Nubbʉ, car Pilato, bbʉ mí dyøde múr mi̱ngu̱ pʉ Galilea car Jesús, bi gu̱y gá ma pʉ jabʉ már bbʉh car Herodes. ");
INSERT INTO otsNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Cja̱ car Heroes, bbʉ mí cca̱hti car Jesús, bi ndo mpöjö. Ya xquí cja tiempo mí ne di cca̱hti, pe jí̱ mí tzö di ntjɛhui. Guegue xquí dyøde te mí ma̱n cʉ cja̱hni digue car Jesús, cja̱ mí ne di cca̱hti hnar milagro. ");
INSERT INTO otsNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eso, bi dyön car Jesús rá ngu̱ nttöni, pe jin te gá nda̱h‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Guejtjo már bböh pʉ cʉ möcja̱ cʉ mí mandado co cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley. Nucʉ́, bi ndo jiøxjʉ bbɛtjri car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nubbʉ́, car Herodes co quí sundado, mí øhtibijʉ ʉr burla car Jesús. Bi jejtijʉ ca hnar da̱jtu̱ már njuɛhtzi. Ncøni mí xijmʉ múr rey, cja̱ bi ndo i̱mbitjojʉ. Cja̱ diguebbʉ, car Herodes pé bi gu̱h car Jesús, bi ma gá ngoh pʉ jabʉ már bbʉh car Pilato. Nu car Herodes nde̱jma̱ bi mpöjö por rá nguehca̱ xcuí cju̱h car Jesús pa di juzga guegue. ");
INSERT INTO otsNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Cja̱ por rá nguehcá̱, bi mpöjmi car Pilato co car Herodes car pa‑cá̱, masque má̱hmɛto mí ʉhui. ");
INSERT INTO otsNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Diguebbʉ ya car Pilato bi nzojni cʉ möcja̱ co cʉ nzöya, co cʉ pé dda cja̱hni rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bi xijmʉ: ―Nuquɛjʉ, xcú tzijnquijʉ nʉr cja̱hni, guí ma̱nguɛjʉ xí dyøti ca rá nttzo. Guí ma̱jmʉ i ɛti yʉ cja̱hni da dyøhtibi tu̱jni car gobierno. Pe nugö, xtú ndo hñöni, cja̱ jin te dí töhtibi ca xtrú dyøti ca rá nttzo. ");
INSERT INTO otsNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Guejti car Herodes jin te xcuá ndöhtibi, eso pé xpá cohtzitjo xcuá ngojcua‑nʉ. Nugöbbe dí ma̱mbbe, jin te i ndu̱jpite nʉr Jesús pa da bböhti. ");
INSERT INTO otsNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gu tzi castigatjo, cja̱ diguebbʉ gu jɛgui da ma libre.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cʉ judio mí pɛhtzijʉ car costumbre, cada cjeya, bbʉ nguá nzöjʉ car mbaxcjua‑ca̱, car gobernador mí xojqui hnar preso, mí jɛgui di ma libre. ");
INSERT INTO otsNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nu cʉ cja̱hni bi ndo majmʉ nzajqui, bi hñi̱na̱jʉ: ―Da tzix nʉr hñøjø‑nʉ pa da bböhti, cja̱ gui xojqui car Barrabás. Guehca̱ gui jiɛgui da ma‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nu car Barrabás xquí cjoti porque xquí jiöti cʉ dda cja̱hni xquí xoxjʉ hnar tu̱jni, guejtjo xquí möhti hnar ánima bbʉ már ntu̱jnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Car Pilato pé bi nzoh cʉ cja̱hni, porque guegue mí ne di jiɛh car Jesús di ma libre. ");
INSERT INTO otsNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nu cʉ cja̱hni bi segue bi majmʉ: ―¡Da bböhti‑nʉ́, da ddøti jar ponti!― ");
INSERT INTO otsNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Car Pilato bi hñön ca rá jñu̱ vez: ―¿Dyoca̱ guí nejʉ da bböhti nʉr hñøjø‑nʉ? Jin gui tzö gu mandado da bböhti, como jin te dí töhtibi ca drá nttzo. Gu mandado da tjʉtitjo, cja̱ diguebbʉ, gu jɛgui da ma libre.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pe cʉ cja̱hni co cʉ möcja̱ cʉ mí mandado, más bi ndo zɛjmʉ bbʉ. Bi dé bi majmʉ: ―¡Da bböhti‑nʉ! ¡Da ddøti jar ponti!― ");
INSERT INTO otsNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nubbʉ, car Pilato, bi mandado di ttøti ca mí ne cʉ cja̱hni, como jí̱ mí ne di tzöyajʉ ca mír majmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bi un car orden pa di bböhti car Jesús, cja̱ di tsjojqui car hñøjø ca xquí ma̱n cʉ cja̱hni di tjɛgui. Nu car hnøjø‑cá̱, xquí jiöti cʉ dda cja̱hni xquí xoxjʉ hnar tu̱jni. Guejtjo xquí pöhtite. ");
INSERT INTO otsNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nubbʉ́, bi bønijʉ bi zixjʉ car Jesús pa di bböhti. Bbʉ má pöjmʉ jar hñu̱, bi ntjɛjʉ ca hnar hñøjø, ya xcuí hñe̱h pʉ jáy jua̱ji̱. Guegue mí tsjifi ʉr Simón, múr mi̱ngu̱ Cirene. Cʉ sundado bi dyøhtibijʉ fuerza car hñøjø‑cá̱ pa bi du̱htzibi cár ponti car Jesús, má tɛni xʉtja. ");
INSERT INTO otsNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Má pa rá ngu̱ cja̱hni, má tɛnijʉ car Jesús. Má hñojʉ pʉ hne̱je̱ bbɛjña̱ rá ngu̱, cja̱ nucʉ, má zonijʉ, como mí ndo jui̱jquijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nu car Jesús bi bböti, bi ñe̱gui, bi nzoh cʉ bbɛjña̱‑cʉ, bi xijmʉ: ―Nuquɛjʉ, na̱na̱, guí mi̱ngu̱jʉ hua Jerusalén, dyo cjuá guí zonijʉ por rá nguejquigö. Mejor gui nzonijʉ por rá nguehquitsjɛguɛjʉ cja̱ co quir ba̱jtzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque ya xta zøh car pa bbʉ xtí ndo sufrijʉ hne̱je̱. Cʉ pa‑cʉ, xta ma̱n cʉ cja̱hni: “Tzi probe yʉ bbɛjña̱ yʉ i hñʉ, cja̱ co yʉ ddáa yʉ ya xqui tjɛ yí tzi wɛne cja̱ i nesta da tzʉjti. Di joh bbʉ jin di ønte.” ");
INSERT INTO otsNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cʉ pa‑cʉ, da ndo sufri cʉ cja̱hni, hasta da ma̱n cʉ ddáa: “Xín da yøti yʉ ttøø, da gobiguijʉ, pa ex xcu tu̱jʉ nttzɛdi, cja̱ pa jin da zʉjcöjʉ car castigo ca ya xpa e̱je̱!” ");
INSERT INTO otsNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nugö, dí xihquijʉ, ya xta ttzɛjqui na̱r ccangui za. ¿Te da ncjajpi car za ca ya xtrú dyoti, bbʉ?― Bbʉ mí ma̱ nʉr palabra‑nʉ car Jesús, mí jɛquitsjɛ hnar ccangui za ca jí̱ mír ntzöhui di ttzɛjqui, cja̱ mí xih cʉ cja̱hni di zʉ guegue‑cʉ hnar castigo drá ndo ʉ́. ");
INSERT INTO otsNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Cja̱ mí bbʉ yojo cʉ hñøjø rá nttzo, xquí contrabi car ley. Cʉ yojo hñøjø‑cʉ bi ttzitzi co car Jesús pa di bböhti. Hnadi pʉ jabʉ di hmöh quí pontijʉ pa di bböhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bi zøtijʉ car lugar ca mí tsjifi ʉr Ximo. Diguebbʉ bi døtijʉ car Jesús jar ponti. Mí hña̱ntjo, bi døhtibi quí dyɛ co quí hua jar ponti. Nubbʉ, bi bböhmijʉ car ponti. Guejtjo bi døtijʉ cʉ pé yojo hñøjø, ca hnaa jár jogui dyɛ car Jesús, cja̱ ca pé hnaa jár nccuarga. ");
INSERT INTO otsNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Car Jesús bi ma̱: ―Nuquɛ, ʉm tzi Taqui, gui perdonabi tzʉ yʉ cja̱hni yʉ xí ndøjqui hua jar ponti, porque jin gui pa̱dijʉ, ¿cja guejquigö xcú pɛnqui?― Cja̱ cʉ sundado bi jejquibi quí da̱jtu̱ car Jesús. Bi dyɛntzijʉ bolado pa di ba̱dijʉ tema da̱jtu̱ di tocabi cada hnaa. ");
INSERT INTO otsNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Cʉ pé dda cja̱hni cʉ már bbʉh pʉ, mí ndo ntsjundötjojʉ, már jantijʉ ter bɛh ca̱ már ncja. Guejti cʉ möcja̱ cja̱ co cʉ tita cʉ mí pɛhtzi quí cargojʉ mí ntsjundöjʉ hne̱je̱, cja̱ bi ma̱ndijʉ: ―Nʉr hñøjø‑nʉ, xí salva cʉ pé dda cja̱hni cʉ ya xti du̱. A ver, ¿cja da nsalvatsjɛ hua ya? Como i ma̱, guegue ʉr Cristo, xpá mɛjni ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Cʉ sundado mí øhtibijʉ ʉr burla, mí ña̱htibijʉ vinagre pa di zi, cja̱ mí xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","―Nuquiguɛ, bbʉ cierto ʉ́r reyqui yʉ judio, gui ca̱jtsjɛ pʉ jar ponti ya, pa jin gui tu̱.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mí cuati hnar jɛhmi pʉ jár ña̱ car ponti, mí ju̱x ya palabra‑ya: “Gue nʉ́r rey yʉ judio‑nʉ́.” Bi tju̱x car seña‑cá̱ gá jñu̱ idioma, tzʉdi, gá hebreo, cja̱ co gá griego, cja̱ co gá latín. ");
INSERT INTO otsNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Már ddøti pʉ já ponti hne̱je̱ yojo hñøjø cʉ xquí contrabi car ley. Guejti ca hnaa digue cʉ yojo‑cʉ, bi dyøhtibi ʉr burla car Jesús, hne̱je̱, bi xifi: ―Nuquiguɛ, bbʉ cierto gúr hñøjø xí hñi̱xqui ca Ocja̱, gui ca̱jquɛ ya, bbʉ, cja̱ gui tziguigöbbe hne̱je̱.― Bi ma̱ ncjapʉ car cja̱hni‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nu ca hnaa bi huɛnti cár hñohui, bi hñi̱mbi: ―Nuquiguɛ, ngu̱ jin guí tzu̱ ca Ocja̱, cja̱ ya xquír ma grí ntjɛhui. Nugöjʉ, hnadi na̱r castigo dár tzöjʉ hua, ya xtrá ma gu tu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nugöhui, drá ntzögöhui na̱r castigo‑na̱, como xtú ndo øtihui ca rá nttzo. Pe nʉr hñøjø‑nʉ, jin te xcá dyøti ca rá nttzo.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Diguebbʉ ya, guegue bi nzoh car Jesús, bi xifi: ―Nuquɛ, Jesús, gui mbe̱ngui tzʉ bbʉ xta ttahqui quer cargo pa gui mandado.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Cja̱ car Jesús bi xifi: ―Cierto, dí xihqui, nuya rá pa ya, xcrí ntjɛhui pʉ jabʉ i bbʉh cam Tzi Ta.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ya xquí zʉ ngu̱ ju̱xadi, cja̱ bi ncju̱ni, bi hmɛxu̱y göhtjo car jöy‑ca̱, már hmɛxu̱ytjo hasta gue bbʉ mí zʉ jñu̱ nde. ");
INSERT INTO otsNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jin te gá ncca̱ car jiadi cʉ jñu̱ hora‑cʉ. Pʉ mbo cár ndo ni̱cja̱ cʉ judio bi hna xɛjtsjɛ car da̱jtu̱ ca mír cjojti ca hnar cuarto ca más már nttzu̱jpi. Bi hna xɛh‑ca̱, bbʉ ya xti du̱ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nubbʉ, car Jesús bi hna mafi nzajqui, bi ma̱: ―Nuquɛ, Tzi Ta, dí döhqui jer tzi dyɛ nʉm tzi mʉy, gui cuajti ya.― Xní ma̱ ncjapʉ, xní bøn cár tzi mʉy, xní du̱, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ca hnar sundado múr capitán, már mföh pʉ. Bi cca̱hti ya ja ncja gá ndu̱ car Jesús, cja̱ bi ba̱di, guegue‑cá̱ de vera xcuí hñe̱h pʉ jar Tzi Ta ji̱tzi. Cja̱ bi ma̱: ―Cierto múr jogui cja̱hni nʉr hñøjø‑nʉ. Jin te mí ndu̱jpite‑nʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Car hora‑ca̱, cʉ pé dda cja̱hni rá ngu̱ cʉ xquí jmu̱ntzijʉ, bi cca̱htijʉ hne̱je̱ ja gá ndu̱ car Jesús, cja̱ bi ndo unijʉ ʉr du̱mʉy. Nubbʉ, bi möjmʉ gá ngojmʉ, mí ndo ntzu̱jʉ cja̱ mí ndo ntzøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nu quí amigo car Jesús co ni cʉ bbɛjña̱ cʉ xcuí dɛnijʉ bbʉ mbú e̱h pʉ Galilea, bi tzi døhmijʉ pʉ. Már bböjtijʉ tzi yanʉ, már jantitjojʉ te már ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mí bbʉh hnar hñøjø, mí tsjifi múr José. Múr jogui cja̱hni, mí tzu̱ ca Ocja̱. Guegue mí pɛhtzi cár cargo, mí pertene pʉ jar junta cʉ tita cʉ mí mandado pʉ jár ni̱cja̱ cʉ judio. Nʉr José múr mi̱ngu̱ car jñi̱ni Arimatea, pʉ jar estado Judea. ");
INSERT INTO otsNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Guegue mí tøhmi car pa bbʉ xti ni̱gui ca hnar rey ca xquí ma̱n car Tzi Ta ji̱tzi di hñe̱je̱ pa di möx cʉ cja̱hni israelita. Car José jin gá ndɛmbi cár mfe̱ni cʉ pé dda tita cʉ xquí hmʉpjʉ gá acuerdo pa gá bböhti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bbʉ ya xquí du̱ car Jesús, car José bi guati pʉ jabʉ már bbʉh car Pilato, bi dyöjpi ʉr tsjɛjqui di du̱htzibi cár ndodyo car Jesús du pɛhtzi. Cja̱ bi ttuni ʉr tsjɛjqui. ");
INSERT INTO otsNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nubbʉ, bi ma bú dɛjqui cár cuerpo car Jesús pʉ jar ponti, bi panti hnar ttaxi da̱tu̱ cja̱ bú cöti hnar cueva. Múr ddadyotjo car cueva. Jim be mí cjöti ánima pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nu car nde‑ca̱ quí amigo car Jesús bi ndo mpɛguijʉ bi götijʉ cár cuerpo car Jesús jar cueva ante que di ñʉh car jiadi, porque car hora bbʉ xti ñʉh‑ca̱, ya xti mʉh ca hnar mbaxcjua ca mí ndo tzu̱jpi cʉ judio. Jí̱ mí tjɛgui to te di mɛh car pa‑ca̱. Cja̱ ya xquí ndo nde bbʉ mí cjöhtibi cár cuerpo car Jesús pʉ jar cueva. ");
INSERT INTO otsNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nu cʉ bbɛjña̱ cʉ xcuí hñe̱jmʉ pʉ Galilea, xcuí dɛnijʉ car Jesús, bi ndo jña̱jʉ ʉr huɛnda ja gá cjöti car ánima pʉ mbo car cueva. ");
INSERT INTO otsNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Diguebbʉ ya, bi ma gá ngojmʉ, bi jojquijʉ cʉ dda hñi̱tji cʉ mí yʉni rá zö, co cʉ dda ungüento hne̱je̱. Nucʉ, di gohtzibijʉ cár cuerpo car Jesús, pa jim bé di ttzontjo. Pe bi tzöyajʉ car pa car nsábado, ncja ngu̱ ga ma̱m pʉ jar ley ca mí tɛnijʉ, como már nttzu̱jpi car pa‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Car pa ca mí ñʉti ca hnar semana, bbʉ ya xi mír ma di ni̱gui, cʉ bbɛjña̱ bi möjmʉ jar cueva, bi du̱xjʉ cʉ hñi̱tji cʉ ya xquí jojquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bbʉ mí zøtijʉ pʉ, ya xquí bböti car me̱do ca xquí gojtijma̱ja̱ car goxtji, ya xi mír hmöh hnanguadi. ");
INSERT INTO otsNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bi ñʉtijʉ jar cueva ya, pe jin gá ndötijʉ cár cuerpo car Tzi Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Cja̱ bi ndo hño í mʉyjʉ, ¿toca̱ xquí du̱x‑ca̱? Diguebbʉ ya, bi hna ni̱guitjo yojo cʉ hñøjø, mí ndo juɛx quí da̱jtu̱ már tzi nttaxi. ");
INSERT INTO otsNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Cʉ bbɛjña̱ ya, bi ndo zu̱jʉ, bi gojti quí döjʉ co quí dyɛjʉ, cja̱ bi anijʉ jar jöy. Bi ma̱n cʉ hñøjø, bbʉ: ―¿Dyoca̱ guí jonguɛjʉ hua hnar cja̱hni ca ya pé xqui bbʉ ʉ́r nzajqui? ");
INSERT INTO otsNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ya jin gui bbʉjcua jabʉ i cjöti cʉ ánima, como ya xí jña̱ ʉ́r jña̱. ¿Cja jin guí mbe̱nijʉ te bi xihquijʉ car Jesús bbʉ ngár bbʉpjʉ guegue pʉ Galilea? ");
INSERT INTO otsNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Bi xihquijʉ, i̱na̱, guegue di ndöjti jáy dyɛ cʉ cja̱hni rá nttzo cja̱ di ddøti pʉ jar ponti, di du̱. Cja̱ bbʉ xtrí cja jñu̱jpa, pé di jña̱ ʉ́r jña̱.― Bi ma̱ ncjapʉ cʉ ángele. ");
INSERT INTO otsNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nubbʉ, cʉ bbɛjña̱ bi mbe̱n cʉ palabra cʉ xquí ma̱n car Jesús, bbʉ jí̱ bbe mí tu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cja̱ bi bønijʉ jar cueva, bi ma gá ngojmʉ, bú cöxjʉ cʉ once quí möxte, co ni cʉ pé ddaa, bú xijmʉ te xcuí cca̱htijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mí gue car María Magdalena, co car Juana, co car María, cár me car Santiago, co cʉ pé dda bbɛjña̱ cʉ mí yojmʉ, guegue‑cʉ bi möjmʉ bú xijmʉ cʉ apóstole. ");
INSERT INTO otsNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nu cʉ apóstole jin gá hñe̱me̱jʉ ¿cja mí cierto ca bi ma̱n cʉ bbɛjña̱? Gá mbe̱nijʉ, más múr hña̱ntitjo. ");
INSERT INTO otsNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nu car Pedro bi bböy, bi gʉ ʉr ddiji, bi ma pʉ jar cueva, bi ani, bi cca̱hti pʉ mbo. Már bbøndi pʉ hnanguadi cʉ ttaxi da̱tu̱ cʉ xquí bbantzibi cár cuerpo car Jesús. Jøndi‑cʉ bi cca̱hti‑cʉ. Cja̱ bi ma ʉ́r ngu̱ bbʉ, mí ndo dyo ʉ́r mʉy, má mbe̱ntsjɛ ter bbɛhca̱ xquí ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mismo car pa‑ca̱, bi bøm pʉ Jerusalén yojo cʉ hñøjø cʉ xquí dɛn car Jesús, mír ma hnar tzi jñi̱ni ca mí tsjifi Emaús. Car tzi jñi̱ni‑ca̱ mí jñajquihui car ciudad Jerusalén como once quilómetro. ");
INSERT INTO otsNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Cʉ hñøjø má ña̱hui, ja ncja xquí bböhti car Jesús pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Má hñohui jar hñu̱, má ña̱hui ncjapʉ. Cja̱ bi hna guatitjo hnar hñøjø, bi ntjɛjʉ cʉ yojo, cja̱ bi segue bi hñojʉ‑cʉ. Mí gue car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nu cʉ yojo hñøjø jin gá meyahui car Jesús. Ncjahmʉ mí bbʉh ca te mí cojtibi quí döhui. ");
INSERT INTO otsNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bi dyön car Jesús, bbʉ, i̱na̱: ―¿Ter fɛh ca̱ ngár ma̱jmi ca xtá ntjɛjʉ? ¿Te rá nguehca̱ guí ndo du̱mʉyhui?― ");
INSERT INTO otsNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ca hnar hñøjø ca mí tsjifi múr Cleofas bi da̱di, i̱na̱: ―¿Casʉ cja xcú tzøn nʉ Jerusalén, cja̱ jí̱ bbe guí pa̱di ter bɛh ca̱ xí ncja nʉ? Hasta cʉ visita, ntero i pa̱dijʉ te xí ncja yʉ pa yʉ cja xí tjogui.― ");
INSERT INTO otsNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Cja̱ pé bi hñön car Jesús: ―¿Te xí ncja ya, bbʉ?― Cja̱ gueguehui bi da̱dihui, bbʉ: ―Gue car Jesús, múr mi̱ngu̱ Nazaret. Guegue‑ca̱ múr jmandadero ca Ocja̱ mí ndo pa̱di rá zö. Mí øti milagro már ndo zö. Guejtjo hne̱je̱ már ndo zö ca mí u̱jtiguije. Mí yojmi cár poder car Tzi Ta ji̱tzi, cja̱ cʉ cja̱hni mí ndo i̱htzibijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Guegue‑ca̱ xí nzʉh cʉm möcja̱je, co ni cʉ tita cʉ i mandadoguije, cja̱ xí ttun cár sentencia, xí ddøti jar ponti, xí ndu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pe nugöje, ndí e̱me̱je guegue car Jesús di gʉxquigöje, dí mi̱nguje israel, cja̱ di möxcöje pa gua hmʉpje libre. Pe ncja ya, ya xí cja jñu̱jpa ca xcá ndu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Masque xí xijquije cʉ dda bbɛjña̱ hnar jña̱, (¿Ja̱di, cja cierto? I ndo dyo yʉm mʉyje) xí xijquije, ya pé xí nantzi car Jesús. øde, cʉ bbɛjña̱‑cʉ, xí möjmʉ pʉ jar cueva bbʉ jí̱ bbe mbá pøx nʉr jiadi, cja̱ jí̱ xcuá ndötijʉ cár cuerpo car Jesús. Guejtjo i ma̱jmʉ, xpá cca̱htijʉ cʉ dda ángele, cja̱ nucʉ, bú xijmʉ, ya xí jña̱ ʉ́r jña̱ car Jesús, ya xí nantzi. ");
INSERT INTO otsNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nu cʉ dda ʉm hñohuije cʉ bi tsjifi ncjapʉ, xí möjmʉ jar cueva hne̱je̱, xpá cca̱htijʉ ncja ngu̱ xcá ma̱n cʉ bbɛjña̱, ya xi mí u̱jtjo cár cuerpo pʉ. Pe jí̱ xcá ntjɛjʉ car Jesús.― Guejnʉ bi ma̱n cʉ yo hñøjø‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Diguebbʉ ya bi ma̱n car Jesús, bi hñi̱mbi: ―Guí hmɛditjojʉ, rá ndo me̱ quir mʉyjʉ. ¿Cja jin guí ntiendejʉ te i ne da ma̱n car Escritura? ¿Ncjahmʉ gui hñemejʉ ca bi ma̱n quí jmandadero ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Cja jin gui ma̱m pʉ jar Escritura, mír ntzöhui di sufri ca hnar cja̱hni ca di hñe̱je̱, tzʉdi, car Cristo? Ngué, i ma̱m pʉ, di nesta di du̱‑ca̱, cja̱ pé di jña̱ ʉ́r jña̱, pa ncjapʉ drí ttun cár cargo cja̱ di mandado.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nubbʉ, car Jesús bi xih cʉ hñøjø te i ma̱m pʉ jar Escritura digue car Cristo ca di hñe̱je̱. Bi mʉdi bi xih ca xquí ma̱n car Moisés. Ma ya, bi xijmi ca xquí ma̱n cʉ dda quí jmandadero ca Ocja̱, cada hnaa. Ddahtzʉ bi xijmi göhtjo ca i cuati pʉ jar Escritura, cʉ parte pʉ jabʉ i ma̱ ja di ncja ca hnaa ca di mɛjni car Tzi Ta ji̱tzi. Má dyojʉ jar hñu̱ bbʉ má xijmi ncjapʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nubbʉ, bi zøtijʉ jar tzi jñi̱ni pʉ jabʉ mír ma cʉ yo hñøjø. Nu car Jesús mí ne di segue, di hñotjo, ncjahmʉ jabʉ pé mír ma. ");
INSERT INTO otsNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pe gueguehui bi za̱mihui, bi xifi: ―Oxi ya, ya xí nde. ¿Jabʉ gui ma ya?― bi hñi̱mbihui. Diguebbʉ, bi døhmi guegue, cja̱ bi ñʉtijʉ pʉ mbo car ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nubbʉ, bi mi̱pjʉ jar mexa pa di zijʉ car cena. Cja̱ car Jesús bi jña̱ hnar tju̱jme̱, bi dyöjpi cjama̱di car Tzi Ta ji̱tzi. Bi jejqui car tju̱jme̱ cja̱ bi unihui. ");
INSERT INTO otsNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nubbʉ, bi hna wen ca mí cojtibi quí döhui cʉ yojo hñøjø, cja̱ bi meyahui car Jesús, bbʉ. Nu car Jesús, bi hna bbɛjti pʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nubbʉ, bi ma̱n cʉ yojo‑cʉ: ―Gue cam Tzi Jmu̱jʉ‑ca̱. ¿Cierto, xpá mpöj yʉm tzi mʉyhui, bbʉ ndár ña̱jʉ guegue jar hñu̱, bbʉ már xijquihui te i ma̱n cʉ Escritura. Xtú hna ntiendetjogöhui te i ma̱n‑cʉ. ¡Tji ya ca̱!― Ncjapʉ gá ma̱n cʉ yo hñøjø‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bi hna bböjmi, bbʉ, mismo car hora‑ca̱, bi xønihui bi ma gá ngojmi pʉ Jerusalén. Bi zøtihui pʉ jabʉ már bbʉh cʉ once apóstole cja̱ co cʉ pé dda cja̱hni cʉ már yojmʉ, bú cöxihui te xcuí ncja. ");
INSERT INTO otsNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nu cʉ once apóstole, bbʉ mí dyødejʉ, bi ma̱jmʉ: ―Cierto, xí jña̱ ʉ́r jña̱ cam Tzi Jmu̱jʉ como guejti nʉr Simón xpá ntjɛhui cja̱ xí xijquije.― ");
INSERT INTO otsNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Diguebbʉ cʉ yojo hñøjø bi xih cʉ apóstole göhtjo te xcuí ncja pʉ jar hñu̱, cja̱ co ja gá meyahui car Jesús bbʉ már xɛjqui car tju̱jme̱. ");
INSERT INTO otsNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Már ña̱di ncjapʉ, cja̱ bi hna ni̱guitjo pʉ car Jesús, bi hmöh pʉ madé, bi zɛngua quí möxte, bi xijmʉ: ―Da hmʉy rá zö quir tzi mʉyjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nu gueguejʉ mí ndo ntzu̱jʉ, ngá ma̱jmʉ, mí gue cár nda̱ji̱tjo car Jesús már cca̱htijʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nu car Jesús pé bi ma̱m, bbʉ: ―¿Dyoca̱ guí ntzu̱jʉ? ¿Dyoca̱ cjuá guí yomfe̱nijʉ, toguigö? ");
INSERT INTO otsNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cca̱htijma̱jʉ yʉm dyɛ co yʉm hua. Tjönguijʉ pa gui pa̱dijʉ, ¿cja guejquigö? Bbʉ gur nda̱jitjogö, jin te di bbʉj yʉm ndodyo, ni ndra ngue nʉm ngø.― ");
INSERT INTO otsNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nubbʉ́, bi u̱jti quí dyɛ, co quí hua, pʉ jabʉ xquí ntjohtibi bbʉ mí ddøti jar ponti. ");
INSERT INTO otsNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Gueguejʉ bi ndo mpöjmʉ bbʉ́, pe jí̱ bbe mí e̱me̱jʉ rá zö, mí yomfe̱nitjojʉ. Nubbʉ́, car Jesús bi dyöni, bi hñi̱mbijʉ: ―¿Cja guí pɛhtzijʉ hua te gu tzigö?― ");
INSERT INTO otsNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Cja̱ bi unijʉ hna pedazo ʉr jogui möy ca ya xquí da̱, co hna pedazo ʉr lonja ca mí po ttafi gá colimena. ");
INSERT INTO otsNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Guegue ya bi jña̱‑cʉ cja̱ bi za. Már cca̱htitjojʉ quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nubbʉ, bi nzoh quí möxte, bi xijmʉ: ―Bbʉ jí̱ bbe ndí tu̱, dú xihquijʉ ter bɛh ca̱ di ncja, cja̱ nuya xí nzʉdi ncja ngu̱ dá ma̱, xtú tu̱gö cja̱ pé xtú ja̱ ʉm jña̱. Guejyʉ mí nesta di ncja‑yʉ pa di zʉdi göhtjo ca bi ma̱n car Moisés co cʉ pé dda quí jmandadero ca Ocja̱, co ni cʉ palabra cʉ i ju̱x pʉ já salmo digue ca hnar cja̱hni ca di bbɛjni hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nubbʉ, bi xijmʉ quí möxte te i ma̱m pʉ jar Escritura, cja̱ bi möx‑cʉ́ pa gá ntiendejʉ göhtjo ca i ma̱m pʉ digue ca hnáa ca di mɛjni car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bi xijmʉ ncjahua: ―I ma̱m pʉ jar Escritura, bbʉ xti hñe̱h car Cristo, tiene que di sufri, di du̱, cja̱ pé di jña̱ ʉ́r jña̱ ca xtrá jñu̱jpa. ");
INSERT INTO otsNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Cja̱ bbʉ ya xtrú ncja‑ca̱, di ntʉngui car jña̱, di tsjijmʉ göhtjo yʉ cja̱hni yʉ i bbʉjcua jar jöy. Bbɛto da tsjij yʉ cja̱hni israelita hua jar jñi̱ni Jerusalén. Ma ya, da tsjih cʉ cja̱hni cʉ rá bbʉh cʉ pé dda jñi̱ni, göhtjo cʉ i bbʉ jar mundo. Da tsjijmʉ, ya xí ní̱gui car Cristo ca xquí promete car Tzi Ta ji̱tzi. Da hñe̱me̱jʉ guegue cja̱ da jiɛjmʉ ca rá nttzo. Da ncjapʉ drí mperdonabi ca xí dyøtijʉ ca rá8nttzo, göhtjo cʉ to da guatijʉ jár dyɛ. Guejnʉ i ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Cja̱ nuquɛjʉ, guí testigojʉ, i nesta gui xijmʉ cʉ cja̱hni nʉr palabra‑nʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nuya, dí cu̱hquijʉ gui möjmʉ pa grí nzojmʉ göhtjo cʉ cja̱hni. Pe ante que gui pønijʉ, gui tøhmitjojʉ hua Jerusalén hasta gue bbʉ xtu ca̱h ca hnaa ca xtú xihquijʉ du e̱je̱. Bbʉ xta guahquijʉ‑ca̱, nubbʉ, xquí yojmʉ car ttzɛdi ca rí hñe̱ ji̱tzi, bbʉ.― Ncjapʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Diguebbʉ ya, car Jesús bi zix quí möxte, bi bønijʉ pʉ Jerusalén gá ndɛnijʉ car hñu̱ ca mír zøti pʉ car tzi jñi̱ni Betania. Pe bbʉ mí bbɛjtjo pa di zøtijʉ pʉ, bi hmöpjʉ, bbʉ, cja̱ car Jesús bi pahtzi quí dyɛ, bi dyöjpi car Tzi Ta ji̱tzi di bendeci quí möxte, cja̱ diguebbʉ ya bi hñi̱h‑cʉ́. Bi guaj ya bi hñi̱h‑cʉ, cja̱ bi hna ttzix pʉ ji̱tzi, bi bbɛdi. ");
INSERT INTO otsNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nu quí möxte car Jesús, bbʉ ya xquí bøxi ji̱tzi guegue‑ca̱, bi xöjtibijʉ. Diguebbʉ ya, bi möjmʉ gá ngojmʉ pʉ Jerusalén, cjuá má mpöjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bi tjoh cʉ pá, nu guegue‑cʉ mí ndo mpöjtijʉ. Mí dedijʉ pʉ jar ndo ni̱cja̱, mí xöjtibijʉ ca Ocja̱ göhtjo ʉr pa. Amén. I ttzɛdi hua na̱r libro‑na̱.");
INSERT INTO otsNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bbʉ jí̱ bbe mí bbʉj nʉr mundo, ya xi mí bbʉh ca hnaa ca i tsjifi ʉr Jña̱. Dí xijmʉ ʉr Jña̱, como guegue i u̱jtiguijʉ ja i ncja car Tzi Ta ji̱tzi. Car Jña̱ mí bbʉbi ca Ocja̱, cja̱ guejtsjɛ guegue mú Ocja̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bbʉ mí mʉdi göhtjo, mí bbʉj nʉ jar ji̱tzi car Jña̱, mí ncca̱htihui car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Bi mföxihui car Tzi Ta ji̱tzi co ca hnaa ca i tsjifi ʉr Jña̱, bi dyøtihui göhtjo yʉ dí cca̱htijʉ. Guegue ca i tsjifi ʉr Jña̱ bi cjajpi bi hmʉy göhtjo yʉ i bbʉ í nzajqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mí bbʉ ʉ́r nzajqui guegue, cja̱ bi ungui ʉ́r nzajqui göhtjo yʉ i bbʉy. Car nzajqui ca xí ddajquijʉ, jin gui gue cár nzajqui yʉm cuerpojʉ, como da tjeh‑cá̱. Nu cár nzajqui guegue, i jñɛjmi hnar jiahtzi ca jin da hmɛxu̱y, segue i yoti mbo ʉm tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ca hnaa ca i tsjifi ʉr Jña̱ mí jñɛjmi hnar jiahtzi ca mí yoti jar bbɛxu̱y. Cʉ cja̱hni cʉ jí̱ mí e̱me̱jʉ guegue, bi jionijʉ ja drí ccahtzijʉ, pa jin di ni̱gui cár tjay. Pe jin gá jiöti di gohmijʉ. Hasta yʉ pa ya, i ni̱guitjo cár tjay. ");
INSERT INTO otsNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mí bbʉh ca hnar hñøjø ca mí ju̱ cár tju̱ju̱ múr Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Car Tzi Ta ji̱tzi bi hñi̱x car Juan gá testigo pa di xih cʉ cja̱hni, ya xi mbá e̱cua jar mundo ca hnaa ca di jñɛjmi hnar jiahtzi. Car Juan bi nzoh‑cʉ́, pa sa̱nta̱ di hñemejʉ ca hnáa ca di hñe̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jí̱ mí gue car Juan ca múr jiahtzi. Guegue bú e̱je̱ gá testigotjo, mí xih cʉ cja̱hni di hñemejʉ ca hnar cja̱hni ca mí jñɛjmi hnar jiahtzi, como nuca̱ xcuí hñe̱h ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nu ca hnaa ca i jñɛjmi hnar jiahtzi cja̱ xcuí hñe̱h pʉ jar ji̱tzi, ya xi mbá e̱cua jar jöy. Guegue‑cá̱ ʉr jiahtzi i yoti mbo ʉm tzi mʉyjʉ, dí cja̱hnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Guegue bú e̱cua jar jöy, bi hmʉy gá cja̱hni. Guegue xquí dyøti nʉr mundo, nu cʉ cja̱hni cʉ mí bbʉjcua jar mundo jin gá mba̱dijʉ, ¿cja xcuí hñe̱h ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Guegue bi cja ʉr cja̱hni, bi hmʉjcua jar jöy. Nu cʉ cja̱hni cʉ mí mi̱ngu̱jʉ pʉ jabʉ mí bbʉh car Jña̱, jin gá ne gá hñemejʉ, ¿cja güí hñe̱h pʉ jar ji̱tzi guegue? Tzi yotjo cʉ cja̱hni bi hñemejʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nu cʉ to bi hñemejʉ bi ttun car derecho bi cjajʉ í ba̱jtzi ca Ocja̱. Ca hnáa ca i jñɛjmi hnar jiahtzi bi ún‑cʉ́ car derecho. ");
INSERT INTO otsNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Cʉ cja̱hni cʉ i e̱me̱jʉ guegue, i pɛhtzijʉ hnar ddadyo nzajqui. Car nzajqui‑ca̱ jin guá hñeje digue nʉm cuerpojʉ. Jin gui gue quí me co quí ta yʉ cja̱hni xí unijʉ car nzajqui‑cá̱. Guejtsjɛ car Tzi Ta ji̱tzi xí unijʉ, xí cjajpi í ba̱jtzi‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ca hnáa ca i tsjifi ʉr Jña̱ bi cja ʉr cja̱hni, bi hmʉy. Bi hmʉjcua jar jöy, cja̱ nugöje, dú hmʉpje‑cá̱. Dú cca̱htibije cár vida, már tzi zö, cja̱ dú pa̱dije, ca Ocja̱ xcuí mɛjni‑ca̱, ddatsjɛ guegue múr Ttʉ. Cár Tzi Ttʉ ca Ocja̱ mí ndo jui̱jqui cʉ cja̱hni cja̱ bi mötzi. Guejtjo bi nzofo, bi xijmʉ ca ncjua̱ni. ");
INSERT INTO otsNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Car Juan bi xih cʉ cja̱hni ja mí ncja ca hnáa ca xcuí hñe̱h ca Ocja̱ cja̱ ya xti ni̱gui. Bi xijmʉ, i̱na̱: ―Ya xí nzøh car cja̱hni ca ndí xihquijʉ: “Du e̱h ca hnar hñøjø ca más rá ji̱tzi cár cargo ni ndra ngue cam cargogö. Bbʉ jí̱ bbe ndí bbʉjcö, ya xi mí bbʉ guegue.”― Guejnʉ bi ma̱n car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ca hnáa ca bú e̱cua jar jöy i jñɛjmi hnar hñøjø ʉr rico ca i un quí ba̱jtzi göhtjo ca i nestajʉ. Desde car pa ca xtú emejʉ, segue i ddajquijʉ rá ngu̱ bendición. ");
INSERT INTO otsNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ma̱hmɛto ca Ocja̱ bú pɛjni car Moisés, cja̱ nuca̱ bi dyøti car ley ca bi zoguigöjʉ. Gá nga̱x ya, pé bú pɛjni car Jesucristo, cja̱ guegue‑ca̱ bi u̱jtiguijʉ ja ncja ga ma̱jquijʉ car Tzi Ta ji̱tzi. Guejtjo bi xijquijʉ ca ncjua̱ni. ");
INSERT INTO otsNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jin gui bbʉh hnar cja̱hni ca xtrú cca̱hti car Tzi Ta ji̱tzi. Jøña̱ cár Tzi Ttʉ, ca jin te i bbʉ ʉ́r hñohui, guegue bí ju̱dihui car Tzi Ta ji̱tzi, bí ncca̱htihui. Guegue‑ca̱ xí u̱jtiguijʉ ja i ncja cár Tzi Ta. ");
INSERT INTO otsNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bú e̱h cʉ dda cja̱hni, bi guatijʉ car Juan ca mí xix cʉ cja̱hni. Cʉ ddáa mí möcja̱jʉ digue cár religión cʉ judio. Cʉ pe ddáa ya, mí levitajʉ, mí föxjʉ cʉ möcja̱. Xcuí mɛjni quí mi̱nga̱‑möcja̱jʉ cʉ mbí mandado pʉ Jerusalén. Cʉ hñøjø cʉ xcuí bbɛjni bi dyönijʉ car Juan, bi hñi̱na̱jʉ: ―Nuquɛ, ¿ter oficioguɛ?― ");
INSERT INTO otsNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bi da̱j ya car Juan, bi xijmʉ ca ncjua̱ni, i̱na̱: ―Nugö, jin gui guejquigö nguí tøbiguijʉ gua e̱je̱ gua mandadoquijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Diguebbʉ ya, pé bi dyönijʉ: ―¿Toquiguɛ, bbʉ? ¿Cja gúr profeta Elías?― Nu car Juan bi da̱di: ―Ji̱na̱, jin gui guejcö.― Cja̱ pé bi dyönijʉ: ―¿Cja huá guehquiguɛ ca hnar hñøjø ca mí ma̱n car Moisés di hñe̱je̱ pa di nzoj yʉ cja̱hni?― Nu car Juan pé bi xijtjo: ―Ji̱na̱ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Diguebbʉ ya, pé bi dyönijʉ: ―¿Toquiguɛ, bbʉ́? I ne da ba̱h cʉ to xpá ngu̱jquije, ¿ter oficioguɛ? ");
INSERT INTO otsNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma ya bi ma̱n car Juan, bi xijmʉ: ―Guejquigö ʉ́r jmandaderogui ca Ocja̱ ca bi ma̱n car profeta Isaías di hñe̱je̱. Dí dyo hua jabʉ jin to i hña̱ni, dí ña̱ nzajqui, dí nzohquijʉ. Dí xihquijʉ: “Gui jojqui quir vidajʉ pa bbʉ xtu e̱h cam Tzi Jmu̱jʉ, ya xcri bbʉpjʉ pa gui recibijʉ.”― Ncjanʉ gá ma̱n car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mí fariseojʉ cʉ́m Jerusalén cʉ xcuí gu̱h cʉ möcja̱ co cʉ levita pa di dyönijʉ car Juan, tema cargo mí pɛhtzi. ");
INSERT INTO otsNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Diguebbʉ ya, cʉ möcja̱ co cʉ levita pé bi xijmʉ car Juan: ―Nuquɛ, guí ma̱nguɛ, jin guí guehquɛ du pɛjni ca Ocja̱ pa da mandadoguije. Guejtjo guí ma̱, jin gui guehquɛ gúr profeta ca mí tsjifi Elías, cja̱ jin gui guehquɛ ʉ́r jmandaderoqui ca Ocja̱ ca mí ma̱n car Moisés di hñe̱je̱ pa di nzojquije. ¿Tema cargo guí pɛhtziguɛ, bbʉ́, pa gui xix yʉ cja̱hni?― ");
INSERT INTO otsNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Car Juan ya bi da̱di: ―Xí ttajcö nʉm cargo, dí xix yʉ cja̱hni cor deje. Pe ya xqui bbʉh ca hnáa ca ndí tøhmijʉ. Nuquɛjʉ, ya xquí cca̱htijʉ, pe jim be guí pa̱dijʉ jabʉ xcuá hñe̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nugö, xtú hmɛto, dá nzoj yʉ cja̱hni, cja̱ ca hnáa ba bbɛfa. Nuca̱ i pɛhtzi hnar cargo más rá ji̱tzi ni ndra ngue cam cargogö. Jin drá ntzögöbbe gu cjagö ʉ́r muzo guegue pa gu xohtibi quí zɛxtji.― Ncjapʉ gá ma̱n car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Cʉ möcja̱ co cʉ levita bú ntjɛhui car Juan nʉ rí ncjanʉ car da̱tje Jordán, nʉ jabʉ rí bøxi jiadi, cja̱ bú ña̱hui pʉ. Mí tsjifi Betábara car lugar pʉ jabʉ bú ntjɛhui. Már bbʉh pʉ car Juan, már xix cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Diguebbʉ ya, ca xní cja yojpa, car Juan bi jianti car Jesús, ya xi mbá e̱je̱, cja̱ bi ma̱: ―Jiantijma̱jʉ, ya xpa e̱j nʉr hñøjø nʉ xí hñi̱x ca Ocja̱ pa da ncjá ncja hnar tzi dɛti. Guejnʉ da gʉzquijʉ ca rá nttzo ca dí øtijʉ, göhtjo yʉ cja̱hni hua jar mundo. ");
INSERT INTO otsNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Gue nʉr hñøjø‑nʉ ndí xihquijʉ: “Du e̱h ca hnar hñøjø ca más rá ji̱tzi cár cargo ni ndra ngue cam cargogö.” Bbʉ jí̱ bbe ndí bbʉjcö, ya xi mí bbʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma̱hmɛto, jim be ndí pa̱di, ¿cja gue nʉr hñøjø‑nʉ́ xquí ma̱n ca Ocja̱ di hñe̱je̱? Pe nuya, ya xtí pa̱di, guejnʉ. Nugö, dú e̱je̱, dí xix yʉ cja̱hni cor deje. Guejtjo dí nzojmʉ pa da hñemejʉ, gue nʉr hñøjø‑nʉ xpá mɛnquijʉ ca Ocja̱ pa da möxquijʉ, nugöjʉ dí israelitajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Car Juan guejtjo bi xih cʉ cja̱hni ter bɛh ca̱ bi jianti bbʉ mí xix car Jesús, bi hñi̱mbijʉ: ―Dú janti car Espíritu Santo, mbá ca̱ jar ji̱tzi ncja hnar tzi paloma, gá nguati car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hasta car pa‑ca̱, jí̱ bbe ndí pa̱di to car cja̱hni ca du pɛnquijʉ ca Ocja̱. Car Tzi Ta ji̱tzi xpá mɛnquigö pa gu xix yʉ cja̱hni cor deje. Guejti guegue bi xijqui ncjahua: “Pa gui meya toca̱ xtú i̱xcö pa da gʉzquijʉ ca rá nttzo ca guí tu̱jʉ, xquí jianti car Espíritu Santo xtrí ga̱ ji̱tzi ncja hnar paloma, xta guati pʉ jabʉ i bbʉ guegue. Gue car hñøjø‑ca̱ xtú cu̱h‑ca̱, cja̱ guegue‑ca̱ xta un yʉ cja̱hni car Espíritu Santo pa da yojmʉ.” Ncjanʉ gá xijqui car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nugö, dú janti car Espíritu Santo guá nga̱ ji̱tzi, gá nguati car Jesús. Dúr testigogö, cierto, ʉ́r Ttʉ ca Ocja̱ car hñøjø‑cá.― Ncjapʉ gá ma̱n car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cja̱ bbʉ ya xní cja yojpa, pé bú tjoh car Jesús pʉ jabʉ már bbʉh car Juan. Car Juan mí yojmi yojo quí möxte cʉ mí ntzixihui. ");
INSERT INTO otsNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Guegue‑ca̱ bi jianti car Jesús, má dyo pʉ, cja̱ bi xih quí möxte: ―Jiantijma̱hui, ya xpa e̱j nʉr hñøjø nʉ xpá mɛjni ca Ocja̱ pa da gʉzquijʉ ca rá nttzo ca dí tu̱jʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cʉ yojo quí amigo car Juan bi dyøj nʉr palabra‑nʉ, cja̱ bi ma bú tzʉdihui car Jesús, bi dɛnihui. ");
INSERT INTO otsNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nubbʉ, bi bböti car Jesús, bi cca̱hti cʉ hñøjø cʉ má tɛni xʉtja, cja̱ bi dyöni: ―¿Te grí hñe̱jmi tzʉ?― Cja̱ gueguehui bi ma̱jmi bbʉ: ―Nuquɛ, Rabí, xijquibbe tzʉ, ¿jabʉ i bbʉh quer ngu̱?― (Gueguehui bi nzojmi car Jesús digue cár jña̱jʉ ca mí ña̱ cʉ judio, cja̱ nʉr palabra Rabí i ne da ma̱ Maestro.) ");
INSERT INTO otsNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Bi da̱j ya car Jesús, bi hñi̱na̱: ―Möjö pa gui cca̱htihui.― Diguebbʉ ya, bi möjmʉ bbʉ, bú cca̱htihui jabʉ mí bbʉy, cja̱ bú dehui pʉ car nde‑ca̱, como ya xquí zʉdi ngu̱ go nde. ");
INSERT INTO otsNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mí yojo quí amigo car Juan cʉ bi dɛnihui car Jesús. Ca hnaa múr Andrés, mí ncjua̱da̱hui car Simón Pedro. ");
INSERT INTO otsNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Guegue car Andrés ya, bbʉ ya xquí ña̱hui car Jesús, nguetica̱ bi ma bú xih cár cjua̱da̱, bi hñi̱na̱: ―Ya xtú tötije car Mesías ca xí hñi̱x ca Ocja̱ pa da mandadoguijʉ.― Cʉ cja̱hni cʉ mí ña̱ gá hebreo, mí xijmʉ ʉr Mesías car hñøjø ca di hñi̱x ca Ocja̱. Nu cʉ to mí ña̱ gá griego, mí xijmʉ ʉr Cristo. Hnaadi ca i ne da ma̱n cʉ yo tju̱ju̱‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma ya car Andrés bú tzí car Simón pʉ jabʉ már bbʉh car Jesús. Cja̱ car Jesús bi cca̱hti car Simón ncjahmʉ ya xi mí meya. Bi xifi: ―Guehquɛ, gúr Simón, ʉ́r ttʉqui car Jonás. Nuya, hnahño drí ttzohqui quer tju̱ju̱ ya. Nuya, gúr Cefas.― (Nʉr tju̱ju̱‑nʉ i pøni, Pedro, cja̱ i ne da ma̱, ncja ʉr me̱do.) ");
INSERT INTO otsNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Diguebbʉ, ca xní cja yojpa, car Jesús mí ne di ma pʉ jar estado Galilea. Nupʉ, bú ntjɛhui ca hnar hñøjø, mí ju̱ cár tju̱ju̱ múr Felipe. Car Jesús bi nzofo, bi xifi: ―Gui tɛngui.― Cja̱ bi dɛni. ");
INSERT INTO otsNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Car Felipe múr mi̱ngu̱ car jñini Betsaida. Guejtjo mí mi̱ngu̱hui pʉ car Andrés co car Pedro. ");
INSERT INTO otsNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Car Felipe ya, bi ma bú jon car Natanael, cja̱ bi xifi: ―Ya xtú tötije ca hnar hñøjø ca di hñe̱je̱, gueh ca hnaa ca mí ma̱n car Moisés pʉ jar ley. Guejti guegue mí ma̱n cʉ pe dda profeta pʉ jáy librojʉ. Gue car Jesús, ʉ́r ttʉ car José, ʉr mi̱ngu̱ Nazaret.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Cja̱ bi dyön car Natanael, bbʉ: ―¿Casʉ ʉr mi̱ngu̱ pʉ jar tzi jñinitjojo Nazaret? ¡Hni̱! Jin te i ntju̱mʉy‑ca̱.― Bi da̱j ya car Felipe, bi hñi̱na̱: ―Gu mɛ, má cca̱htihui car Jesús, pa gui cca̱htitsjɛ ¿cja rá zö huá ji̱na̱?― Cja̱ bi mɛhui bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ya xi má cuati car Natanael pʉ jabʉ már bbʉh car Jesús, cja̱ car Jesús ya bi jianti, cja̱ bi xih cʉ to már bbʉbi: ―Cierto i jon ca Ocja̱ nʉr hñøjø nʉ ba e̱je̱. Jin gui øti ntjöti‑nʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Bi dyön car Natanael, bbʉ: ―Nuquɛ, ¿jabʉ xcú cca̱jtigui? Sá ngu̱ ya xquí pa̱di ja dí ncjagö.― Bi da̱j ya car Jesús bi hñi̱na: ―Nu bbʉ jí̱ bbe mí nzohqui car Felipe, dú cca̱jtiqui, ngár ju̱ pʉ jöy ca hnar za gá higo, cja̱ dú pa̱tiqui quir mfe̱ni.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Cja̱ pé bi ma̱n car Natanael, bbʉ: ―Nuquɛ, Rabí, cierto ʉ́r Ttʉqui ca Ocja̱. Guehquiguɛ xquí hñe̱je̱ pa gui mandadoguije, dí israelitaje.― ");
INSERT INTO otsNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Diguebbʉ ya car Jesús bi xifi: ―¿Cja guí ndo e̱me̱gui, ʉ́r Ttʉgui ca Ocja̱, jøntsjɛtjo porque xtú xihqui, dú cca̱jtiqui ngár ju̱ pʉ jöy ca hnar za gá higo? ¿Cja i ndo dyo quer mʉy por rá nguehca̱? Ba e̱h car pa bbʉ xtí cca̱hti ca más drá ndo zö ni ndra ngue ca xcú cca̱hti. Nubbʉ, cja más da ndo hño quer mʉy, bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Cierto na̱ dí xihquijʉ: Gui ma gui cca̱htijʉ, ya xtrú xoh car ji̱tzi, cja̱ da ni̱gui quí anxe cam Tzi Ta ji̱tzi, cʉ ddáa ya xtrí ga̱jmʉ, cʉ ddáa ya xtrí bøxijʉ pʉ jabʉ gri bbʉjcö. Nugö, dúr cja̱hni, xpá bbɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Diguebbʉ ya, ca xtrá jñu̱jpa, bi ncja hnar ntja̱jti pʉ jar tzi jñini Caná, jar estado Galilea. Bi ma jar ntja̱jti cár me car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Guejtjo bi ttzojni car Jesús co quí amigo cʉ mí ntzixihui, cja̱ bi möjmʉ pʉ jar mbaxcjua hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bbʉ már tzijʉ cʉ cja̱hni, bi tjeh car vino. Cja̱ cár me car Jesús bi xifi: ―Ya xí tjeh car vino. ¿Ter bɛh ca̱ da ttun yʉ cja̱hni pa da zijʉ ya?― ");
INSERT INTO otsNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Car Jesús ya bi da̱di, i̱na̱: ―Nuquɛ, me, jiɛgui. Bbʉ xta zøh car hora, xtá nu̱gö ja gu cjajpi‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Diguebbʉ ya, cár me car Jesús bi xih cʉ muzo cʉ már döjʉ car jñu̱ni: ―Nuquɛjʉ, gui dyøtijʉ ca da bbɛjpiquijʉ nʉr hñøjø‑nʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Már jøx pʉ jar ngu̱ ddajto cʉ ndo ttzøy gá me̱do, mí po deje. Cada hnar ttzøy mí ntzöhui yo o jñu̱ xøni cʉ deje. Cʉ judio mí cupa nʉr deje rá ngu̱ pa drí nxʉtijʉ cja̱ drí nxajmʉ, ncja ngu̱ nguá ndɛn quí costumbrejʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Diguebbʉ ya, car Jesús bi xih cʉ muzo: ―Bú tu̱jʉ deje, gui ñu̱htzijʉ yʉ ttzøy.― Cja̱ cʉ muzo bi ñu̱htzijʉ rá zö. ");
INSERT INTO otsNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma ya, car Jesús pé bi xijmʉ: ―Dyöhtzijʉ ya, gui tu̱xijʉ pʉ jabʉ rá bbʉh car presidente pa du tzö, como guegue‑ca̱ i ja̱ ʉr huɛnda digue nʉr mbaxcjua.― Cja̱ bi cjajpi cʉ muzo, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Diguebbʉ ya, car presidente bi zö car deje ca xquí ttøti ʉr vino. Jí̱ mí pa̱ guegue jabʉ xcuí hñe̱h car vino‑ca̱, nu cʉ muzo cʉ xcuí du̱jʉ, mí pa̱dijʉ jabʉ xcuí hñe̱je̱. Car presidente bi nzoh car novio, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Bi xifi: ―Cam costumbrejʉ, bbɛto i ttun car vino ca rá zö, cja̱ bbʉ ya xí nzi rá ngu̱ vino yʉ cja̱hni, nubbʉ, i ttun ca jin tza i ncʉji. Pe nuquiguɛ, ¿dyoca̱ xcú pɛhtzi car vino ca rá zö hasta na̱r hora ya?― Bi ma̱n ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Car Jesús bi dyøti nʉr milagro‑nʉ jar tzi jñini Caná, jar estado Galilea. Gue nʉr primero ʉr milagro bi dyøti guegue. Quí amigo car Jesús cʉ mí ntzixihui bi cca̱htijʉ ter bɛh ca̱ bi ncja, cja̱ bi ba̱dijʉ, mí yojmi cár ttzɛdi ca Ocja̱ car Jesús. Bi hñe̱me̱jʉ, cierto xcuí hñe̱ ji̱tzi‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Diguebbʉ ya car Jesús bi bøm pʉ jar jñini Caná, gá nga̱h pʉ Capernaum. Má yojmi cár me, quí cjua̱da̱, hne̱h quí amigo cʉ mí ntzixihui. Cja̱ bú hmʉpjʉ pʉ jar jñini Capernaum tengu̱ tzi mpa. ");
INSERT INTO otsNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cʉ judio ya xti zöjʉ car mbaxcjua ca i tsjifi ʉr Pascua. Nubbʉ, bi ma car Jesús, gá mbøx pʉ jar jñini Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bi ñʉti pʉ jár tji car ndo templo, cja̱ bú töti pʉ cʉ hñøjø cʉ mí pö nda̱ni, cja̱ co cʉ ddaa cʉ mí pö dɛjti co paloma. Mí bbö cʉ zu̱we̱‑cʉ pa di bböhti cja̱ di jña̱htibi ca Ocja̱ pʉ jar altar. Guejtjo már bbʉh pʉ cʉ dda cja̱hni cʉ mí pöti domi. Göhtjo már øti negocio pʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Bbʉ mí jianti ya‑cʉ car Jesús, bi dyøti hnar chirio gá ntja̱ji̱, bi fongui göhtjo cʉ már bbʉh pʉ, cja̱ co cʉ dɛjti co cʉ nda̱ni. Bi dyentibi quí mexa cʉ to mí pöti domi, bi fontibi quí domi. ");
INSERT INTO otsNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Cja̱ bi xih cʉ to mí pö paloma: ―Cjʉhtzijʉ hua göhtjo yʉ. Dyo guí cjajpitjojʉ ʉr töy nʉ́r ngu̱ cam Tzi Ta.― ");
INSERT INTO otsNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bbʉ mí jianti quí möxte ter bɛh ca̱ bi ncja, bi mbe̱nijʉ ca hnar palabra ca i ju̱x pʉ jar Escritura, i ma̱: “Dí ndo ne pa da jma̱jtibi nʉ́r ngu̱ ca Ocja̱, eso, dí tsjeyabi yʉ to jin gui tzu̱jpi.” ");
INSERT INTO otsNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pe bi da̱j ya quí jefe cʉ judio cʉ mí mandadobi, bi dyönijʉ car Jesús: ―¿Dyoca̱ guí manttɛy hua jar templo? Gui u̱jtiguije hnar seña pa dá pa̱dije tema cargo guá ja̱guɛ.― ");
INSERT INTO otsNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Bi da̱h car Jesús, bi xijmʉ: ―Cierto xtá u̱jtiquijʉ hnar seña pa gui pa̱dijʉ tema cargo dí ja̱gö. Gui yøhtijʉ na̱r templo‑na̱, cja̱ nugö, ca pé xtrá jñu̱jpa, pé gu xotzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Diguebbʉ ya, pé bi ma̱n cʉ judio, bi hñi̱na̱jʉ: ―Bbʉ mí tjøj na̱r templo‑na̱, bi dura cuarenta y seis año pa gá nguadi. Hni̱xquiguɛ ya, guí ma̱nguɛ da jñøhti ya, cja̱ jñu̱jpatjo pé grí xotzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nu car Jesús mí ña̱ digue cár cuerpo guegue ncjahmʉ dur templo‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hasta bbʉ mí du̱ car Jesús cja̱ pé bi nantzi, nubbʉ, cja bi mbe̱n quí möxte nʉr palabra nʉ xquí ma̱ guegue, cja̱ bi ba̱dijʉ te mí ne di ma̱. Nubbʉ, bi hñemejʉ, ya xquí zʉh cʉ palabra cʉ i ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Car Jesús már bbʉh pʉ Jerusalén bbʉ mí ncja car mbaxcjua ca i tsjifi ʉr Pascua. Már ndo ngu̱ cʉ cja̱hni bi cca̱htijʉ cʉ milagro cʉ mí øti car Jesús, cja̱ bi guatijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nu car Jesús, bi cca̱hti cʉ cja̱hni‑cʉ ncjahmʉ jin tza mí ntjumʉy ca mír dɛnijʉ, como ya xi mí pa̱di, jin di segue di dɛni göhtjo‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Como guegue mí cca̱hti mbo í mʉy göhtjo cʉ cja̱hni, cja̱ jí̱ mí nesta pa to di xifi ja i ncja nʉr cja̱hni. Guejtsjɛ guegue mí pa̱di ja ga mbe̱n yʉ cja̱hni mbo ʉ́r tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mí bbʉh hnar hñøjø, múr fariseo, mí ju̱ cár tju̱ju̱ múr Nicodemo. Guegue mí ja̱ cár cargo co ni cʉ pe dda tada cʉ mí mandadobi cʉ judio. ");
INSERT INTO otsNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bbʉ mí nxu̱y, bú e̱h car Nicodemo pʉ jabʉ már bbʉh car Jesús, bi xifi: ―Nuquiguɛ, Maestro, rá ndo zö ca guí u̱jti yʉ cja̱hni. Dí pa̱dije, gue ca Ocja̱ xpá mɛnqui. Hnar cja̱hni ca jin di yojmi ca Ocja̱, jin di jogui di dyøti milagro. Pe nuquiguɛ, guí ndo øti milagro.― ");
INSERT INTO otsNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Bi da̱j ya car Jesús bi xifi: ―Dyøjma̱ja̱ na̱ gu xihqui. Car cja̱hni ca jí̱ xcá ttuni hnar ddadyo hmʉy, jin gui tzö da guati pʉ jár dyɛ ca Ocja̱ pa da mandadobi.― ");
INSERT INTO otsNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Diguebbʉ ya, bi dyön car Nicodemo, bi hñi̱na̱: ―Xi bbʉ ya xí ntada hnar cja̱hni, ¿Ja pé drí yojpi da hmʉy? ¿Cja da jogui pé drí ñʉti mbo ʉ́r mʉy cár me, pa pé da hmʉh ca xtrá yo vez?― ");
INSERT INTO otsNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Bi da̱j ya car Jesús, bbʉ: ―Cierto na̱ dí xihqui, ca to i ne da guati pʉ jár dyɛ ca Ocja̱ pa da mandadobi, i nesta da tsjitzi cor deje pa da ni̱gui, ya xqui ne da jiɛh ca rá nttzo. Guejtjo i nesta da yojmi car Espíritu Santo pa da mɛhtzi hnar ddadyo hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yʉ bbɛjña̱, i øngui ba̱jtzi. Nu cʉ ba̱jtzi cʉ i bbʉy, rí jña̱xti cár ta ʉ́r me. Mi̱ngu̱tjojʉ hua jar jöy. Nu ca to i yojmi car Tzi Espíritu Santo, ddadyo ga hmʉy, cja̱ rí hñe̱ ji̱tzi car nzajqui ca i pɛhtzi. ");
INSERT INTO otsNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dyo te guí mbe̱ni digue nʉr palabra nʉ xtú xihqui. I nesta da ttahqui hnar ddadyo hmʉy, ncjahmʉ güi yojpi güi hmʉh ca xtrá yo vez. ");
INSERT INTO otsNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Guí tzö nʉr nda̱ji̱, i dyo göhtjo pʉ jabʉ i ne. Guí øde i jia, pe jin guí pa̱di jabʉ xcuá hñe̱je̱ cja̱ co jabʉ rí ma. I ncjadipʉ hne̱je̱ car Espíritu Santo. Guegue‑ca̱ i un yʉ cja̱hni car nzajqui ca rí hñe̱ ji̱tzi, masque jin gui pa̱j yʉ cja̱hni ja ncja ga dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Diguebbʉ ya, pé bi dyön car Nicodemo: ―¿Ja ncja di jogui di ttajquije car nzajqui ca rí hñe̱ ji̱tzi?― ");
INSERT INTO otsNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Cja̱ pé bi da̱h car Jesús: ―Nuquiguɛ, gúr ndo maestro, guí u̱jti cár ley ca Ocja̱ yʉ cja̱hni israelita. ¿Cja jin guí pa̱di ja i ncja nʉ xtú xihqui? ");
INSERT INTO otsNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cierto dí xihqui, gue yʉ cosa dí pa̱di rá zö, dí xihqui, pa gui hñemejʉ. Dí ña̱ ncja hnar testigo, dí xihquijʉ yʉ cosa xtú cca̱hti. Nuquiguɛjʉ, jin guí ne gui hñemejʉ ca dí xihquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Xtú xihquijʉ ja i ncja cʉ cosa cʉ rí hñe̱ ji̱tzi, xtú jɛqui yʉ cosa yʉ i ni̱gui hua jar jöy, pa gui ntiendejʉ. Pe nuquɛjʉ, jin guí e̱me̱jʉ yʉ palabra xtú ma̱. Xi bbʉ gua xihquijʉ cʉ dda cosa cʉ bí ncja pʉ jar ji̱tzi, cʉ jí̱ bbe i fa̱jcua jar jöy, meno gri hñemejʉ bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Jin to i bbʉh ca xtrú mbøx pʉ jar ji̱tzi. Jønguitsjɛgö, dúr mi̱ngu̱ pʉ ji̱tzi, xtú ca̱jcö pʉ. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Guí pa̱dijʉ ter bɛh ca̱ bi dyøti car Moisés bbʉ mí hño cʉ cja̱hni israelita pʉ jabʉ jin to mí hña̱ni. Guegue bi dyøti hnar dibujo, ʉr cci̱ña̱ gá ttɛgui, bi hñi̱xi hnar za, bi bböhmi pʉ ña̱ pa di jianti göhtjo cʉ cja̱hni. Guejtigö da ncjaguigö ncja ngu̱ gá ncjajpi car cci̱ña̱. Da tti̱xquigö pʉ ña̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","I nesta da ncja‑ca̱ pa jin da bbɛj yʉ cja̱hni yʉ da hñemegui. Da mɛhtzi‑yʉ́ car nzajqui ca jin da tjegue.― ");
INSERT INTO otsNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ca Ocja̱ i ndo ne yʉ cja̱hni hua jar jöy, cja̱ jin gui ne pa da bbɛdijʉ. Eso, bú pɛjni cár Tzi Ttʉ, jøña̱‑ca̱ mí hñi̱ji̱. Ca to da guati jár dyɛ, jin da bbɛdi, da mɛhtzi car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ca Ocja̱ jin guá mɛjni cár Ttʉ hua jar jöy pa di xij yʉ cja̱hni da gu̱titsjɛjʉ ca rá nttzo ca xí dyøtijʉ. Guegue bú pɛjni cár Tzi Ttʉ pa da gʉhtzibi ca rá nttzo ca xí dyøtijʉ yʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ca to da guati jár dyɛ cár Ttʉ ca Ocja̱, jin da cju̱h pʉ jabʉ da gu̱ti ca rá nttzo ca xí dyøte. Nu ca jin da guati pʉ, i tu̱u̱di ca rá nttzo ca xí dyøte. Ya xí ma̱n ca Ocja̱, da cju̱h pʉ jabʉ jin gui tzö, du hmʉjti pʉ göhtjo ʉr tiempo, porque jin gá ne gá hñemebi cár Ttʉ ca Ocja̱. Nucá̱, ddatsjɛ‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bú e̱cua jar jöy ca hnaa ca mí jñɛjmi hnar jiahtzi. Nu cʉ cja̱hni hua jar mundo jin tza mí nejʉ car jiahtzi‑ca̱. Mí nejʉ di hmʉjtijʉ pʉ jar bbɛxu̱y pa jin di ni̱gui, ¿cja már nttzo ca mí øtijʉ? Car Tzi Ta ji̱tzi ya xí dyɛmbi cár castigo cʉ cja̱hni cʉ jin gá ne gá nguati car jiahtzi. ");
INSERT INTO otsNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Cʉ cja̱hni cʉ i øti ca rá nttzo, i ʉhui car jiahtzi, cja̱ jin gui ne da guatijʉ, pa jin da ni̱gui, ¿cja rá nttzo ca xí dyøtijʉ? ");
INSERT INTO otsNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nu cʉ cja̱hni cʉ i øti ca rá zö, i cuatijʉ jar jiahtzi pa da cca̱htijʉ, ja i ncja ca xí dyøtijʉ, cja̱ pa da fa̱di gue ca Ocja̱ xí möx‑cʉ́ pa xcá dyøtijʉ ca rá zö. ");
INSERT INTO otsNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Diguebbʉ ya, car Jesús bi bøm pʉ jar jñini Jerusalén, bi ma gá ma jar estado Judea. Bi mɛhui quí amigo cʉ mí tɛni. Bú hmʉpjʉ pʉ Judea tengu mpa, cja̱ mí xixjʉ cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Guejti car Juan mí xix cʉ cja̱hni pʉ jar lugar ca mí tsjifi Enón, como már cja deje rá ngu̱ pʉ. Car lugar Enón mí nzøtihui car lugar Salim. Mbá e̱h cʉ cja̱hni pʉ jabʉ már bbʉh car Juan, cja̱ guegue mí xitzi. ");
INSERT INTO otsNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Como jí̱ bbe mí cjoti födi car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Cʉ ddaa quí möxte car Juan mí ntøxtihui cʉ ddaa quí jefe cʉ judio. Mí ña̱jʉ digue cʉ ntsjʉti cʉ mí øti cʉ judio pa di jogui di guati ca Ocja̱ cja̱ co car tsjixtje ca mí øti car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Diguebbʉ ya, quí amigo car Juan bi guatijʉ guegue, bi göxjʉ te mí ncja, bi xijmʉ, i̱na̱: ―Nuquɛ, Maestro, bbʉ nguír hmʉj nʉ rí ncjanʉ nʉr da̱tje Jordán, nguí yojmi ca hnar hñøjø, nguí xijquije guegue‑ca̱ xí hñi̱x ca Ocja̱ pa da gʉzquigöjʉ ca rá nttzo. Ya xqui bbʉjcua car hñøjø‑ca̱, cja̱ ba ndo hñɛdi yʉ cja̱hni, i tɛnijʉ, cja̱ guegue i xitzi hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Bi da̱j ya car Juan, bi hñi̱na̱: ―Jin to di hñeme car hñøjø‑ca̱ bbʉ di ji̱na̱ car Tzi Ta ji̱tzi. Guegue‑ca̱ i mandado toca̱ da tti̱htzibi hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nuquɛjʉ, gú dyøjtsjɛjʉ bbʉ ndú ma̱ngö: “Jin gá hñi̱xquigö car Tzi Ta ji̱tzi pa gua mandadoquijʉ. Nugö xpá mɛnquitjojo, xtú hmɛtogö pa gu xij yʉ cja̱hni: “Ya xpa e̱h car hñøjø ca ndí tøhmijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nugö, jin dí cja ndumʉy ca ya xqui ddɛn car Jesús. Ji̱na̱, dí mpöjcö göhtjo mbo ʉm tzi mʉy. Dí ncja ngu̱ hnar hñøjø ca i föx cár amigo car ttöjte. Cja̱ bbʉ ya xta ntja̱jti cár amigo, i mpöh car möxte hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nuya i nesta más da ndo tti̱htzibi car Jesús, cja̱ nuguigö, ya jin da tti̱zquigö.― Ncjanʉ gá ma̱n car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","I bbʉh cʉ dda cja̱hni cʉ i u̱jtiguijʉ, i xijquijʉ ja i ncja cʉ cosa hua jar jöy. Guegue‑cʉ i tti̱htzibijʉ hua jar mundo. Pe como mi̱ngu̱tjojʉ hua jar mundo, jin gui pa̱dijʉ ter bɛh ca̱ bí ncja pʉ jar ji̱tzi. Guejtjo i bbʉ ca hnar cja̱hni xcuá hñe̱ ji̱tzi cja̱ i nzojquijʉ. Más rá zö guegue ni ndra ngue cʉ ddaa cʉ i tti̱htzibi. ");
INSERT INTO otsNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Guegue‑ca̱ i xij yʉ cja̱hni ja i ncja cʉ cosa cʉ xpá cca̱hti cja̱ xpá dyøh pʉ jar ji̱tzi. Pe tzi yotjo yʉ cja̱hni i e̱me̱jʉ ca i ma̱. ");
INSERT INTO otsNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","I bbʉ tengu̱di cʉ cja̱hni cʉ i e̱me̱bijʉ cár palabra ca hnaa ca xcuá hñe̱h pʉ ji̱tzi. Nucʉ́, i ncjajʉ ncja ngu̱ testigo, i xijmʉ cʉ pe ddáa, cierto car palabra ca xí ma̱n car Tzi Ta ji̱tzi: tzʉdi, xí ma̱n‑cá̱, ya xpá mɛjni cár Tzi Ttʉ hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Car cja̱hni ca xcuá hñe̱h pʉ ji̱tzi i ma̱n cʉ palabra cʉ xí xih car Tzi Ta ji̱tzi, como i yojmi cár Tzi Espíritu ca Ocja̱. Car Tzi Espíritu‑ca̱ i fötzi göhtjo ʉr tiempo, jin gui wembi. ");
INSERT INTO otsNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Car Tzi Ta ji̱tzi i ne cár Tzi Ttʉ, cja̱ xí döjti cár cargo pa da mandadobi göhtjo cʉ i bbʉ jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Car cja̱hni ca i e̱me̱ cár Tzi Ttʉ ca Ocja̱, ya xqui pɛhtzi car nzajqui ca jin da tjegue. Nu ca to jin gui ne da hñeme cár Ttʉ ca Ocja̱, jin da mɛhtzi car nzajqui‑ca̱, como car Tzi Ta ji̱tzi jin gui ne da cca̱hti car cja̱hni‑cá̱, cja̱ da un cár castigo ca rí ntzöhui. ");
INSERT INTO otsNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Diguebbʉ ya, cʉ fariseo bi dyødejʉ car jña̱, ya xi mbá ndo hñɛdi cʉ cja̱hni, mbá cuatijʉ car Jesús, cja̱ nuca̱, mí xitzi. Guegue car Jesús, cja̱ co car Juan már bbʉh pʉ jar estado Judea, hnanguadi car da̱tje Jordán. Más már ngu̱ cʉ cja̱hni cʉ mí tɛn car Jesús ni ndra ngue cʉ mí tɛn car Juan. ");
INSERT INTO otsNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jí̱ mí gue car Jesús mí xix cʉ cja̱hni. Guegue quí möxte cʉ mí yojmi, mí xitzi. Cja̱ bi tsjih cʉ fariseo te mí ncja. ");
INSERT INTO otsNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nu car Jesús, bbʉ mí dyøde, ya xquí tsjih cʉ fariseo ter bɛh ca̱ már pɛ guegue, nubbʉ, bi wem pʉ jar estado Judea, pe gá ma nʉ jar estado Galilea. Má yojmi quí amigo cʉ mí föxjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mí nesta di tjoh pʉ jar jöy Samaria pa di zøti pʉ Galilea. ");
INSERT INTO otsNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bi zøtijʉ hnar tzi jñini ca mí tsjifi Sicar. Car tzi jñini‑ca̱ már nzøtihui ca hna pɛdazo ʉr jöy ca múr mɛjtijma̱ja̱ ca ndor José. Ca ndor Jacobo, cár ta car José, xquí zoquibi car pedazo‑ca̱ gá herencia. ");
INSERT INTO otsNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pʉ jár nttza̱ni car jñini Sicar mí bbʉh hnar ttöti. Mí tsjifi ʉ́r ttöti ca ndor Jacobo. Bi zøti pʉ car Jesús, ya xi mí ju̱xadi. Ya xcuí bo ʉ́r cuɛ pʉ jar hñu̱, cja̱ bi mi̱h pʉ hnanguadi car ttöti. ");
INSERT INTO otsNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Diguebbʉ ya, bú e̱h hnar bbɛjña̱, múr mi̱ngu̱ pʉ, hne̱ bi gʉxi deje. Car Jesús bi xifi, i̱na̱: ―Ddajqui tzʉ ʉr deje, gu tzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Már ddatjsɛ car Jesús, como ya xquí ma nʉ jár centro car jñi̱ni quí möxte cʉ mbá yojmi. Xquí möjmʉ du töjmʉ te di zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Car bbɛjña̱ ʉ́m Samaria bi da̱j ya bbʉ, i̱na̱: ―¿Dyoca̱ guí öjqui deje pa gui tzi, siendo gúr judioguɛ? Nuguigö, dúr mi̱ngu̱ hua Samaria.― Car bbɛjña̱ bi ma̱n nʉr palabra‑nʉ porque cʉ judio jí̱ mí johui cʉ́m Samaria, cja̱ jí̱ mí ntzixihui. ");
INSERT INTO otsNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pé bi da̱h car Jesús, bi hñi̱mbi: ―Bbʉ gri pa̱di toguigö hne̱ ja i ncja car nzajqui ca rí hñe̱h ca Ocja̱, nubbʉ, nuquiguɛ güi dyöjqui deje pa güi tzi. Car deje ca gua ddahquigö, i úngui nzajqui cʉ to i tzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nubbʉ, pé bi ma̱n car bbɛjña̱: ―Nuquɛ, tada, jin te guá tu̱ pa grí cjʉx car deje, cja̱ rá ndo je̱ nʉr ttöti. ¿Jabʉ güi tu̱ car deje güi ddajqui, car deje guí ma̱nguɛ da ddajqui cam nzajqui? ");
INSERT INTO otsNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Casʉ, ¿más guí mandadoguɛ ni ndra ngue ca ndom tajʉ, car Jacobo? Guegue mí tzi nʉr deje‑nʉ́, guejti quí ba̱jtzi cja̱ co quí zu̱we̱ mí tzijʉ, cja̱ bi zoguije na̱r ttöti‑ná̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Pé bi da̱h car Jesús, bi xifi: ―Na̱r deje i po na̱r ttöti, bbʉ to da zi, pé xta yojpi xta du̱tjetjo. ");
INSERT INTO otsNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nu car deje dí xihqui, ca to da zi, ya jim pé da yojpi da du̱tje. Como car deje dí un yʉ cja̱hni, da ncja ngu̱ hnar pøtje ca jin gui xö. Segue ba pøh car deje pʉ mbo ʉ́r tzi mʉy car cja̱hni, i un car nzajqui ca jin da tjegue.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Diguebbʉ ya, bi ma̱n car bbɛjña̱: ―Nuquɛ, tada, ddajqui tzʉ car deje ca guí ma̱nguɛ, pa ya jin gu tu̱tje, cja̱ ya jin da nesta gu e̱cua, hne̱ gu cjʉxi deje.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Car Jesús bi xih, bbʉ: ―Ma bú mahti quer da̱me, cja̱ gu e̱jmi hua.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Bi da̱h car bbɛjña̱, bbʉ: ―Jin te dí hñi̱jcö da̱me.― Nu car Jesús bi hñi̱mbi: ―Rá zö nʉ xcú ma̱. Jin te guí pɛhtzi da̱me. ");
INSERT INTO otsNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porque xcú yojmi cʉtta quir da̱me, cja̱ nu ca guí bbʉbi ya, guejti‑ca̱ jí̱ ir da̱me. Cierto nʉ xcú xijqui.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Diguebbʉ ya pé bi ma̱n car bbɛjña̱: ―Nuquɛ, tada, dí i̱ngö gúr vinador. Göhtjo guí pa̱di. ");
INSERT INTO otsNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Cʉ ndom titaje, mí pøxi nʉ jar ttøø‑nʉ, mbí nda̱nejʉ ca Ocja̱ nʉ bí cjanʉ. Nuquiguɛjʉ, guí judiojʉ, guí ma̱jmʉ, bbʉ to i ne da nzoh ca Ocja̱, da ma pʉ jar jñini Jerusalén. Xiquiguɛ, ¿te guí xijquije? ¿Tema lugar i ne ca Ocja̱ pa gu nzojmʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Bi da̱h car Jesús, bbʉ: ―Dyøjma̱ja̱ nʉ gu xihqui, ya xta zøh car pa bbʉ gui ma gui nzojmʉ car Tzi Ta ji̱tzi sin que gui pøxijʉ nʉ jar ttøø‑nʉ nim pa gui möjmʉ pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nuquiguɛjʉ, guí mi̱ngu̱jʉ Samaria, jin guí pa̱dijʉ ter fɛh ca̱ guí nda̱nejʉ. Nugöje, dí judioje, dí pa̱dije toca̱ dí nda̱neje. I ma̱m pʉ jar Escritura, dur judio ca hnar hñøjø ca da gʉhtzibi ca rá nttzo ca xí dyøti yʉ cja̱hni hua jar mundo. ");
INSERT INTO otsNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ya xpa e̱h car pa, cja̱ mero ya xí nzøjø, ya xqui bbʉh cʉ cja̱hni cʉ i nzojmʉ ca Ocja̱ ncja ngu̱ ga ne guegue. Nucʉ, i jonijʉ ca Ocja̱ göhtjo mbo ʉ́r tzi mʉyjʉ cja̱ i e̱me̱jʉ ca ncjua̱ni. Car tsjödi‑ca̱, i tzøh car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ʉr Espíritu car Tzi Ta ji̱tzi. I bbʉy ncjá ʉr nda̱ji̱. Nu cʉ cja̱hni cʉ i ne da guatijʉ car Tzi Ta ji̱tzi, ni jabʉ i nesta da ma. I nesta da guatijʉ mbo ʉ́r tzi mʉyjʉ, guejtjo i nesta da ba̱dijʉ ja i ncja guegue.― Guejnʉ bi ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Diguebbʉ ya pé bi ma̱n car bbɛjña̱, i̱na̱: ―Ya xtú øjcö, xtu e̱h ca hnar cja̱hni ca xtrú hñi̱x ca Ocja̱ pa da mandadoguijʉ. Guegue da tsjifi car Mesías, guejtjo da tsjifi ʉr Cristo, hne̱je̱. Bbʉ xtu e̱h‑ca̱ da ujtiguijʉ göhtjo ja i ncja ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Bi da̱j ya car Jesús, ―Guejquigö di ña̱hui dúr Cristo. Guejquigö xí hñi̱xquigö ca Ocja̱ pa gu föx yʉ cja̱hni hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Diguebbʉ ya, pé bi zøh quí möxte car Jesús, bi cca̱htijʉ már ña̱hui car bbɛjña̱‑ca̱. Bi hño í mʉyjʉ, bbʉ, cja̱ mí ne di dyönijʉ: ¿“Ter bɛh ca̱ nguí ma̱jmi nʉr bbɛjña̱‑nʉ?” o “¿Te i joni‑nʉ?” Pe mí pɛhtzi ʉ́r tzöjʉ, cja̱ jin te gá xijmʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nu car bbɛjña̱ bi zoti pʉ cár xøni, bi ma gá ngoh pʉ jár centro car jñini, bú cöx cʉ cja̱hni ter bɛh ca̱ xquí ncja, bú xijmʉ: ");
INSERT INTO otsNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Mö nttzɛdi, möjö gu má cca̱htijʉ hnar hñøjø xí xijqui göhtjo cʉ xtú øte. ¿Cja jin gui gue car Cristo ca dí tøhmijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Diguebbʉ ya, bi dɛnijʉ car bbɛjña̱ cʉ cja̱hni, bi bønijʉ jar jñini, mír möjmʉ pʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jim be mbá coh car bbɛjña̱, nu car Jesús már ña̱hui quí möxte. Guegue‑cʉ mí xijmʉ car Jesús, ya xi mír ntzöhui di zi. Mí i̱na̱jʉ: ―Nuquɛ, Maestro, tziguɛ ya.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nu car Jesús bi xih‑cʉ: ―I bbʉh ca dí tzigö macja̱ guí i̱na̱jʉ jin te dí pɛhtzi pa gu tzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Diguebbʉ ya quí möxte bi hñöntsjɛjʉ, bi ma̱jmʉ: ―Ja̱di, ¿cja huá i bbʉh ca to xpá jña̱mpi te xí nzi‑nʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nu car Jesús pé bi ma̱m bbʉ: ―Nugö, jin tza dí tu̱ntju̱ bbʉ dí pɛh car bbɛfi ca xí ddajqui cam Tzi Ta ji̱tzi. Ncjahmʉ dí ñi̱ña̱tjo bbʉ dí øti car bbɛfi‑ca̱, cja̱ i nesta gu cjuajti. ");
INSERT INTO otsNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nuquɛjʉ, pe ntoja guí ma̱jmʉ: “I bbɛjti go za̱na̱ pa da cja tsjattɛy.” Dyøjma̱jʉ na̱ dí xihquijʉ. Gui jiantijʉ ya yʉ jua̱ttɛy, ya xí ccaxti yʉ ttɛy. Guejya xta cja tsjattɛy ya.― Bbʉ már ma̱ndi nʉr palabra‑nʉ car Jesús, ya xi mbá cuati cʉ cja̱hni xcuí hñe̱h car jñini Sicar. ");
INSERT INTO otsNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cja̱ pé bi ma̱n car Jesús: ―Nuquɛjʉ, guí ncjajʉ ncja yʉ xattɛy, cja̱ da ttahqui quer tja̱ja̱jʉ. Gui ma gui cuajtijʉ yʉ cja̱hni yʉ i ne da dɛnguigö, pa jin da bbɛdi. Nubbʉ, gu mpöjmʉ, dí göhtjojʉ, ngu̱ na̱r monttɛy, ngu̱ yʉ xattɛy. ");
INSERT INTO otsNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ya xí nzʉh car jña̱ ca i jma̱: “Xí ponttɛy ca hnaa, cja̱ ca pe hnaa da xattɛy.” ");
INSERT INTO otsNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nugö dú cu̱hquijʉ hua pa güi xattɛyjʉ hua jabʉ jí̱ xquí pɛjmʉ. Pé dda cja̱hni xí mon car semilla, xí xij yʉ cja̱hni car tzi ddadyo jña̱. Cja̱ nuquɛjʉ, xí tocaquijʉ gui cuajtijʉ yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Car jñi̱ni Sicar mí bbʉh pʉ jar jöy Samaria. Már ngu̱ cʉ́m Sicar bi hñeme car Jesús. Nucʉ́, mbá yojmʉ car bbɛjña̱ ca xquí xijmʉ, guegue xquí ntjɛhui hnar hñøjø ca mí pa̱di göhtjo cʉ xquí dyøti guegue, göhtjo cár vida. ");
INSERT INTO otsNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eso bú e̱h cʉ cja̱hni‑cʉ, mí mi̱ngu̱ Samaria, bi guatijʉ pʉ jabʉ már bbʉh car Jesús, cja̱ bi dyöjpijʉ favor di hmʉpjʉ tzʉ, tengu̱ mpa. Cja̱ guegue bi døhmi yojpa pʉ, bi ujti cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cja̱ bbʉ mí dyødejʉ cʉ palabra cʉ mí ma̱n car Jesús, bi ngu̱jqui cʉ cja̱hni cʉ bi hñemejʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Cʉ cja̱hni cʉ bi hñeme, bi xijmʉ car bbɛjña̱ bbʉ: ―Nuya guejtigöje dí e̱me̱je nʉr Jesús, pe jin gui jøntsjɛ car palabra xcú xijquije. Nuya gue yʉ palabra xtú øjtsjɛje xcá ma̱n nʉr Jesús. Ya xtí pa̱dije, guegue nʉr Jesús da gʉzquijʉ ca rá nttzo ca dí tu̱jʉ, göhtjo yʉ cja̱hni yʉ i bbʉjcua jar mundo.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Car Jesús, bbʉ ya xquí døhmi cʉ yojpa pʉ Samaria, bi bøm pʉ gá ma jar estado Galilea. Mí yojmi quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bi má gá ngojti pʉ jár jöy guegue, pʉ jabʉ jin tza di dɛn yʉ cja̱hni. Como guejtsjɛ car Jesús bi ma̱: Jin da tti̱htzibi hnár jmandadero ca Ocja̱ pʉ jabʉ ʉr mi̱ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bbʉ ya xti zøti pʉ Capernaum, pʉ jar estado Galilea, cʉ mi̱ngu̱ pʉ bú e̱jmʉ bi da̱jmʉ car Jesús, mí ndo mpöjmʉ, como xcuí cca̱htijʉ cʉ milagro rá ngu̱ cʉ xcuí dyøti car Jesús pʉ jar jñini Jerusalén. Como guejti cʉ mi̱ngu̱ pʉ Galilea xquí möjmʉ pʉ jar mbaxcjua pʉ Jerusalén. ");
INSERT INTO otsNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Diguebbʉ ya, car Jesús pé bi ma gá nzøti pʉ jar jñini Caná, pʉ jar estado Galilea. Ya xi mír cja yo vez mír zøti pʉ. Guehpʉ jar jñini Caná car Jesús xquí cjajpi car deje xquí cja ʉr vino. Nu pʉ jar jñini Capernaum mí bbʉh ca hnar hñøjø ca mí pɛjpi car rey, cja̱ mí jnin cár ttʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bi dyøh car hñøjø, ya xcuí goh pʉ Judea car Jesús, ya pé xquí zøh pʉ Galilea, cja̱ bi má pʉ jar jñini Caná, bú jon car Jesús. Bi ntjɛhui cja̱ bi dyöjpi favor di ma tzʉ pʉ́r ngu̱, du dyøtjebi cár ttʉ, como ya xi mír ma di du̱. ");
INSERT INTO otsNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nu car Jesús ya, bi xih car hñøjø: ―Nuquɛjʉ, guí ne gui cca̱htijʉ milagro, cja̱ bbʉ ji̱na̱, jin guí ne gui hñe̱me̱jʉ, ¿cja dí yobbe cár ttzɛdi ca Ocja̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nubbʉ, bi da̱h car hñøjø, bi hñi̱na̱: ―Nuquɛ, tada, gu mɛ tzʉ nttzɛdi, hnar favor. Ya xta du̱ cam ttʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nu car Jesús bi xij ya: ―Maguɛ ya, ya xí zö quer ttʉ.― Nubbʉ, car hñøjø bi hñeme nʉr palabra nʉ bi ma̱n car Jesús, cja̱ bi ma ʉ́r ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cja̱ bbʉ ya xti zøti pʉ́r ngu̱, bú pøh quí muzo car hñøjø, bi xijmʉ: ―Ya xí joh quer ttʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Diguebbʉ ya, bi dyön car hñøjø: ―¿Como tema hora xí mʉdi xí jogui?― Cja̱ bi da̱h cʉ muzo, bi xijmʉ: ―Mande, mí zʉdi ngu̱ la una bbʉ mí nde, bi wen car pa.― ");
INSERT INTO otsNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nubbʉ, bi ba̱h car hñøjø‑ca̱, exque gue car hora ca xcuí ma̱n car Jesús: “Ya xí zö quer ttʉ,” mismo car hora‑ca̱ bi joh cár ba̱jtzi. Cja̱ bi hñeme car Jesús, guegue göhtjo co quí familia. ");
INSERT INTO otsNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ya xi mír cja yo vez ca mír dyøti milagro car Jesús. Nʉr milagro‑nʉ bi dyøti car Jesús bbʉ xcuí goh pʉ Judea, pé má tzøti pʉ Galilea. ");
INSERT INTO otsNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bbʉ ya xquí tzi cja mpa, pé bi ncja hnar mbaxcjua pʉ Jerusalén, bi guatijʉ pʉ rá ngu̱ cʉ judio. Guejti car Jesús bi bøx pʉ jar jñini Jerusalén pe hnar vez. ");
INSERT INTO otsNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pʉ Jerusalén mí bbʉh hnar tanque ca mí po deje, mí nzøtihui car cjoti ca mí coti göhtjo car ciudad. Car tanque mí bbʉ cerca pʉ jar goxtji pʉ jabʉ mír ñʉti cʉ dɛjti, cja̱ mí ju̱ cár tju̱ju̱ Betesda. Ncjapʉ nguá xijmʉ cʉ cja̱hni cʉ mí ña̱ gá hebreo. Mí bbʉ cʉtta portal jáy nttza̱ni car tanque, ");
INSERT INTO otsNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","cja̱ mí cuati pʉ rá ngu̱ cʉ döhtji, mí bbom pʉ ja portal. Guegue‑cʉ mí tzöhui rá ngu̱ clase cʉ jnini. Mí bbʉh pʉ cʉ godö, co cʉ dohua, co cʉ cja̱hni cʉ jí̱ mí tzö di hña̱ni. Már tøhmijʉ di hña̱n car deje. ");
INSERT INTO otsNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bbʉ‑bbʉ mbá ca̱h hnar ángele, mí cjajpi mí hña̱n car deje. Nubbʉ, car döhtji ca di ga̱ta nttzɛdi primero bbʉ nguá hñá̱n car deje, nuca̱ di joh‑ca̱, di wen car jnini ca mí tzöhui. ");
INSERT INTO otsNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Már bbʉh pʉ hnar hñøjø, ya xi mí pɛhtzi treinta y ocho año jí̱ mí tzö di hño. ");
INSERT INTO otsNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Car Jesús bi cca̱hti car döhtji‑ca̱, már bbɛm pʉ, cja̱ bi ba̱di, ya xi már ndo ngu̱ cjeya xquí tzöhui car jñini‑ca̱, guejtjo ya xquí ndo dura pʉ jár nttza̱ni car tanque. Guegue bi dyön car döhtji, bbʉ: ―¿Cja guí ne gui zö?― ");
INSERT INTO otsNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Bi da̱j ya car döhtji, bi hñi̱na̱: ―Nuquɛ, tada, u̱jtjo to da hñi̱jcö pʉ jar tanque bbʉ ga hña̱n car deje. Bbʉ dí tzögö gu ca̱ti, ya xní hmɛto pé hnaa, xní ga̱ti, i ta̱guigö.― ");
INSERT INTO otsNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nubbʉ, bi da̱h car Jesús, bi xifi: ―Bböj ya, gui cjʉx quer mfi̱di, cja̱ gui hño.― ");
INSERT INTO otsNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nguetica̱ bi zö car hñøjø, bi nantzi, bi gʉx cár mfi̱di, bi hño. Bbʉ mí ncja‑ca̱, mí nsabado, car pa ca mí tzu̱jpi cʉ judio. ");
INSERT INTO otsNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Diguebbʉ ya, cʉ dda möcja̱ cʉ mí mandadobi cʉ judio bi xijmʉ car hñøjø ca xquí zö: ―Jin gui tzö gui tu̱x quer mfi̱di ya, como nuya, ʉr pa dí tzöyajʉ. Jin gui tzö te gu pɛjmʉ ya.― ");
INSERT INTO otsNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pé bi da̱h car hñøjø ca múr döhtji jma̱ja̱: ―Car hñøjø ca xí dyøtjegui, guegue xí xijqui: “Cjʉx quer mfi̱di cja̱ gui hño.”― ");
INSERT INTO otsNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nubbʉ, quí jefe cʉ judio pé bi dyönijʉ car hñøjø, bi hñi̱mbijʉ: ―¿Toca̱ xí xihqui gui cjʉx quer mfi̱di cja̱ gui hño?― ");
INSERT INTO otsNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nu car hñøjø jin gá mba̱di te múr ju̱ cár tju̱ju̱ car cja̱hni ca xquí jojqui, como már dʉdi pʉ cʉ cja̱hni, cja̱ ya xquí wem pʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Diguebbʉ ya, bbʉ mí hna rato, car hñøjø pé bi ntjɛhui car Jesús pʉ jar templo. Cja̱ car Jesús ya bi xifi: ―Cca̱htijma̱, ya xcú zö. Gui jiɛj ya ca rá nttzo ca nguí øte, pa jim pé da zʉhqui pé hnar cosa más drá ʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Diguebbʉ ya car hñøjø bi ma bú cöx quí jefe cʉ judio, mí gue car Jesús ca xquí dyøtje. ");
INSERT INTO otsNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mí dyøj ya‑ca̱ quí jefe cʉ judio, bi ʉjʉ car Jesús, cja̱ bi dyøhtibijʉ tu̱jni, como guegue mí dyøtje döhtji car pa nsabado, gue car pa mí tzu̱jpijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nu car Jesús, bbʉ mí ttöni ¿dyoca̱ mí pɛh car pa gá nttzöya? bi xih cʉ cja̱hni cʉ mí hñöni: ―Göhtjo ʉr pa i øti ca rá zö cam Tzi Ta ji̱tzi, jin gui tzöya‑ca̱. Hne̱jquigö, dí ncjadipʉ, dí föx yʉ cja̱hni göhtjo ʉr pa.― ");
INSERT INTO otsNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nu cʉ judio cʉ mí mandado, bbʉ mí dyødejʉ nʉr palabra‑nʉ, más gá ndo ungui ʉr cuɛ. Bi mpɛguijʉ bi jioni ja drí möhtijʉ, como car Jesús jí̱ mí tzu̱jpi car pa gá nttzöya. Jønca̱, pé xquí ma̱, mero múr ta guegue car Tzi Ta ji̱tzi, ncjahmʉ mí ne di cjatsjɛ ca Ocja̱. Eso, cʉ judio‑cʉ mí ndo ʉjʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Diguebbʉ ya, car Jesús pé bi xih cʉ judio cʉ mí ja̱ ʉ́r cargojʉ: ―Cierto na̱r palabra na̱ gu xihquijʉ, nugö ʉ́r Ttʉgui ca Ocja̱, cja̱ jin dí mbe̱ntsjɛ ja grá pɛjcö. Dí cca̱hti ja ncja ga pɛh cam Tzi Ta ji̱tzi, cja̱ dí øti ncjadipʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Como i negui cam Tzi Ta pʉ ji̱tzi, i u̱jtigui göhtjo ja ncja grá pɛjcö, eso, dí øtigö milagro. Segue gu øtigö göhtjo ca da u̱jtigui cam Tzi Ta. Nuquiguɛjʉ, xquí cca̱htijʉ cʉ dda milagro más drá nzɛdi ni ndra ngue cʉ ya xcú cca̱htijʉ. Nubbʉ, da ndo hño ir mʉyjʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Rá nzɛh cam Tzi Ta ji̱tzi, cja̱ guegue da cjajpi da jña̱ ʉ́r jña̱ cʉ ánima, pé da xotzi, da un car nzajqui ca jin da tjegue. Hne̱quigö, ʉ́r Ttʉgui ca Ocja̱, dí pɛhtzi cam cargo pa gu ungui nzajqui göhtjo cʉ to dí ne gu xotzi. ");
INSERT INTO otsNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bbʉ xta nantzi cʉ ánima cja̱ da tja̱mpi ʉr huɛnda, jin gui gue cam Tzi Ta da juzga‑cʉ́. Nugö, xtá juzga. Como ʉ́r Ttʉguigö car Tzi Ta ji̱tzi, xí ddajqui cam cargo pa gu cja ʉr nzöya. ");
INSERT INTO otsNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","I ne guegue parejo da tti̱zquibbe dí yobbe. Yʉ cja̱hni yʉ i despreciaguigö, ʉ́r Ttʉgui ca Ocja̱, nuyʉ́ i despreciajʉ hne̱je̱ car Tzi Ta ji̱tzi, como nucá̱ xpá mɛnquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Cierto na̱r palabra na̱ dí xihquijʉ, cʉ cja̱hni cʉ i ju̱hpi ndu̱mʉy yʉ palabra dí ma̱, guejtjo i e̱me̱, gue car Tzi Ta ji̱tzi xpá mɛnquigö. Guegue‑cʉ ya xqui pɛhtzi car nzajqui ca jin da tjegue, cja̱ jin da cju̱h pʉ jabʉ da gu̱tijʉ ca rá nttzo ca xí dyøtijʉ. Má̱hmɛto, ya xi mír ma di bbɛdijʉ, pe nuya, ya xí ndöti car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Dyøjma̱jʉ na̱r palabra na̱ gu xihquijʉ: Nugö, ʉ́r Ttʉgui ca Ocja̱. Ya xí nzʉj nʉr pa, ya xtú fʉh cam bbɛfi. Dí nzoj yʉ cja̱hni, como jin gui pɛhtzi‑yʉ́ car nzajqui ca jin da tjegue. Cʉ to da dyøh ca dí ma̱ngö, xtá ungö cár nzajqui. ");
INSERT INTO otsNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Car Tzi Ta ji̱tzi i pɛhtzi car nzajqui ca jin da tjegue, cja̱ rí hñe̱ guegue car nzajqui‑ca̱. Hne̱quigö, como ʉ́r Ttʉgui ca Ocja̱, dí pɛhtzi car nzajqui ca jin da tjegue. Guejtjo xí ttajqui cam cargo pa gu un yʉ cja̱hni car nzajqui‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Cam Tzi Ta ji̱tzi xí hñi̱xquigö pa gu cja ʉr nzöya, gu ja̱mpi ʉ́r huɛnda yʉ cja̱hni, como guejquigö dúr cja̱hni xpá mɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dyo dí dyo ir mʉyjʉ por rá ngue nʉ xtú xihquijʉ. Ya xpa e̱h car hora bbʉ xtá nzojni göhtjo cʉ cja̱hni, gu ncjá ncja hnar nzöya, xtá mahti göhtjo cʉ ánima. Nucʉ́, xta dyøh bbʉ xtá nzojcö, cja̱ da bøxijʉ pʉ jabʉ xquí hñöjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Göhtjo da nantzijʉ. Cʉ xí dyøti ca rá zö da ttun car nzajqui ca jin da tjegue. Nu cʉ xí dyøti ca rá nttzo da ttɛmbi cár castigojʉ, da cju̱h pʉ jabʉ da gu̱ti ca rá nttzo ca xí dyøtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Göhtjo yʉ dí øtigö, dí yobbe cam Tzi Ta ji̱tzi, cja̱ guegue i xijqui ter bɛh ca̱ gu øte. Cam Tzi Ta xí hñi̱xquigö gá nzöya, cja̱ dí juzga yʉ cja̱hni ncja ngu̱ ga xijqui. Dí øhtibi jujticia yʉ cja̱hni, como dí pɛjpi car Tzi Ta ca xpá mɛnqui. Jin dí øhtibitjo ncja ngu̱ dra mbe̱ntsjɛ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Dí jñɛbbe hnar cja̱hni xí ttzojni pa da dö cár aclaración. I ttönguigö tema cargo dí pɛhtzi. Jin di joh bbʉ gua dötsjɛ cam palabra, como jin di tte̱me̱gui. ");
INSERT INTO otsNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","I bbʉh ca hnam testigo ca i föxqui. Dí pa̱di, i ma̱n ca ncjua̱ni car testigo‑cá̱, cja̱ rí ntzöhui da tte̱me̱. ");
INSERT INTO otsNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nuquiguɛjʉ, gú cu̱jmʉ jmandadero, bi möjmʉ pʉ jabʉ már bbʉh car Juan, bú önijʉ guegue jabʉ xtá e̱jcö. Guegue bi ma̱n ca ncjua̱ni, bi xihquijʉ jabʉ xtá e̱jcö, cja̱ gú dyødejʉ ter bɛh ca̱ bi ma̱. Car Juan bi dö cár palabra ncja ngu̱ hnar testigo. ");
INSERT INTO otsNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nugö, jin tza dí nesta yʉ cja̱hni pa da dö cár testimoniojʉ, toguigö, como i bbʉ pé hnam testigo ca jin gur cja̱hni. Nuya, dí mbe̱mbiquijʉ digue ca mí xihquijʉ car Juan, xa̱jma̱ gui hñemejʉ, guejquigö xpá mɛnquigö car Tzi Ta ji̱tzi cja̱ pa ncjapʉ gui tötijʉ car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Car Juan mí xihquijʉ ca ncjua̱ni. Tzi clarotjo mí nzohquijʉ. Mí jñɛjmi hnar lámpara ca i yoti rá zö. Nuquɛjʉ, tengu̱ mpatjo gú dyøjmʉ car palabra mí ma̱ guegue, ncjahmʉ nguí ne güi hñe̱me̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Car Juan mí xihquijʉ ntjumʉy jabʉ xtá e̱jcö. Mír ntzöhui güi hñe̱me̱jʉ ca mí ma̱. Nu cʉ milagro dí øtigö, mas rá ndo zö‑cʉ pa gui hñe̱me̱jʉ, gue car Tzi Ta ji̱tzi xpá mɛnquigö, cja̱ xí ddajqui poder. Como xí ddajqui cam ttzɛdi cja̱ co cam ntsjɛjqui pa gu øti‑cʉ́, eso, dí øte. ");
INSERT INTO otsNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Guegue cam Tzi Ta xpá mɛnqui hua jar jöy. Guejtjo xí dö cár palabra xí ma̱ toguigö. Ncjahmʉ ʉr testigo guegue, pe como jin gur cja̱hni, jin gui tzö gui cca̱htijʉ dra bböh pʉ, o gui dyødejʉ dra ña̱, como jin gui ni̱gui. ");
INSERT INTO otsNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pe nde̱jma̱ ya xí dö cár palabra cam Tzi Ta. Guehpʉ ja Escritura xí dö cár testimonio. Nuquiguɛjʉ, jin guí e̱me̱jʉ cár palabra cam Tzi Ta, como jin guí e̱me̱jʉ, ¿cja guejcö xpá mɛnqui‑ca̱? ");
INSERT INTO otsNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nuquɛjʉ, guí mpɛguijʉ guí nxödijʉ cʉ Escritura, como guí i̱na̱jʉ, bbʉ gui dyøtijʉ ncjapʉ, xquí tötijʉ car nzajqui ca jin da tjegue. Pe guejtsjɛ cʉ Escritura i ma̱ guejquigö gua e̱jcö pa gua un yʉ cja̱hni car nzajqui‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nuquiguɛjʉ, jin guí ne gui hñemeguijʉ pa gu ddahquijʉ car nzajqui ca dá ja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nugö, jí̱ xtá e̱jcö pa gu joni ja drí hñi̱zquigö yʉ cja̱hni. Gue car Tzi Ta ca bí bbʉ ji̱tzi i i̱zquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nuquiguɛjʉ, hnahño gri mbe̱nijʉ. Dí pa̱di, jin guí nejʉ ca Ocja̱ cja̱ jin guí i̱zquigöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cam Tzi Ta ji̱tzi xpá mɛnquigö cja̱ xí ddajqui cam cargo. Nuquiguɛjʉ, jin guí e̱me̱jʉ, ¿cja cierto xtá e̱jcö pʉ? Bbʉ di hñe̱je̱ pé hnar cja̱hni ca di ja̱tsjɛ cár cargo, nucá̱ güi hñemejʉ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pe jin guí ne gui hñemejʉ nʉr palabra dá ja̱. Nuquɛjʉ, guí ndo ne pa da tzøhquijʉ cja̱ da hñi̱zquijʉ quir mi̱nga̱‑cja̱hnijʉ. Jin guí jonijʉ ja grí hmʉpjʉ pa da tzøhquijʉ ca Ocja̱. Guegue i bbʉjtsjɛ, ddatsjɛ ca Ocja̱ rí ntzöhui gu i̱htzibijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ba e̱h car pa bbʉ xta nzojnquijʉ cam Tzi Ta pʉ ji̱tzi, pa da jña̱nquijʉ ʉr huɛnda. Dyo guí mbe̱nijʉ, má̱s guejcö gu xifi tema cosa rá nttzo xcrú dyøtijʉ. Pe nde̱jma̱ i bbʉh ca hnaa ca da xihquijʉ guí tu̱jʉ ca rá nttzo bbʉ xta ncja car juicio, gue ca ndor Moisés, cja̱ guí ndo i̱htzibijʉ‑ca̱. Nuquɛjʉ, guí tøhmijʉ da möxquijʉ car Moisés, pe jin guí e̱me̱jʉ ca mí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bbʉ güi hñe̱me̱jʉ ca mí ma̱n ca ndor Moisés, güi hñe̱me̱jʉ, guejcö xpá mɛnquigö car Tzi Ta ji̱tzi. Como i ma̱m pʉ ja libro cʉ bi dyøti car Moisés, toguigö cja̱ te rá nguehca̱ gua e̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nuquiguɛjʉ, jin guí ne gui hñe̱me̱jʉ car palabra ca bi ma̱n car Moisés digue ca hnaa ca di hñe̱je̱. ¿Ja ncja grí hñemejʉ ca dí ma̱ngö bbʉ?― Ncjanʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bbʉ pé xquí tzi cja mpa, car Jesús pé bi ma gá ddax nʉ rí ncjanʉ car mar Galilea. Car mar‑ca̱ guejtjo i tsjifi ʉr mar Tiberias. ");
INSERT INTO otsNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cja̱ bi dɛn car Jesús hnar ndo jmundo cʉ cja̱hni, como ya xquí cca̱htijʉ cʉ milagro cʉ mí øti guegue, segue mí dyøtje döhtji. ");
INSERT INTO otsNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nu car Jesús bi bøxi hnar ttøø, mí yojmi quí amigo cʉ mí föxjʉ, cja̱ bú mi̱pjʉ pʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ya xti ncja car da̱mbaxcjua ca i tzö cʉ judio, gue car mbaxcjua ca i tsjifi car Pascua. ");
INSERT INTO otsNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Car Jesús ya, bi ja̱xi ʉ́r ña̱, bi jianti, ya xi mbá e̱h hnar ndo jmundo cʉ cja̱hni. Cja̱ bi xih car Felipe, bi hñi̱mbi: ―¿Jabʉ gu tönijʉ tju̱jme̱ pa gu unijʉ, da zi‑yʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Car Jesús, masque bi dyön car Felipe nʉr nttöni nʉ, ya xi mí pa̱di ter bɛh ca̱ di dyøte, pe bi dyöni ncjapʉ pa di dyøhtibi hnar prueba. ");
INSERT INTO otsNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Bi da̱j ya car Felipe: ―Bbʉ gua gastojʉ yojo ciento ʉr domi gá denario pa gua töjmʉ tju̱jme̱, jin di zö pa di zi hna tzi pedazo cada hnaa yʉ cja̱hni‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nu car Andrés, ca múr cjua̱da̱ car Simón Pedro, guejtjo mí ntzixihui car Jesús hne̱je̱. Guegue ya bi xih car Jesús, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―I dyo hua hnar tzi hñøjø, i cʉ cʉtta tju̱jme̱ gá cɛbara, cja̱ co yojo tzi möy. Pe nucʉ́, nim pa ʉ́r mʉdi ca da ttun nʉr ndo jmundo yʉ cja̱hni.― Pe nde̱jma̱ bi ttöjpi car tzi hñøjø cʉ tju̱jme̱ hne̱h cʉ möy cʉ mí cʉjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Diguebbʉ ya, pé bi ma̱n car Jesús: ―Gui bbɛjpi yʉ cja̱hni da mi̱pjʉ jöy.― Mí ndo jø paxi pʉ jabʉ már bbʉpjʉ, cja̱ göhtjo bi mi̱pjʉ. Bi zøtijʉ como cinco mil hñøjø. ");
INSERT INTO otsNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Diguebbʉ ya car Jesús bi gʉ cʉ tju̱jme̱, bi nzoh ca Ocja̱, bi dyöjpi mpöjcje, cja̱ bi xɛjqui cʉ tju̱jme̱. Nubbʉ, bi un cʉ pedazo quí möxte, cja̱ guegue‑cʉ bi jejquibi cʉ cja̱hni cʉ már ju̱h pʉ jar jöy. Cja̱ pé bi ncjadipʉ co cʉ tzi möy. Bi un cʉ cja̱hni göhtjo ca mí ne di zijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cja̱ bbʉ ya xquí ñi̱ña̱ göhtjo cʉ cja̱hni, car Jesús bi xih quí möxte: ―Nuya, gui jmuntzijʉ göhtjo yʉ tzi pedazo yʉ xí sobra, pa jin da bbɛdi.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Cja̱ bi jmuntzijʉ, bbʉ, bi ñu̱xi doce canista cʉ tzi pedazo tju̱jme̱ cʉ jin gá ttzi. Xquí sobratjo digue cʉ cʉtta tzi tju̱jme̱ gá cɛbara. ");
INSERT INTO otsNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nu cʉ cja̱hni, bbʉ mí cca̱htijʉ nʉr milagro nʉ bi dyøti car Jesús, bi ma̱jmʉ: ―Nʉr Jesús, mero gue ca hnár jmandadero ca Ocja̱ ca ndí tøhmijʉ di hñe̱cua jar mundo.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nubbʉ́, car Jesús bi jña̱ ʉr huɛnda, te mí ma̱n cʉ cja̱hni. Guegue‑cʉ mí ne di zitzi gá fuerza cja̱ di hñi̱xjʉ pa di cjajpi ʉ́r reyjʉ. Eso, bi wem pʉ car Jesús, pé gá ma jar ttøø, mí ddatsjɛ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cja̱ bbʉ mí mpumijöy, quí amigo car Jesús bú ca̱jmʉ jar ttøø gá nzøjmʉ jar mar. ");
INSERT INTO otsNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bi ñʉtijʉ hnar tzi chalupa pa drí ddaxjʉ car deje, pé drí möjmʉ nʉ Capernaum. Cja̱ bbʉ má dyo jar deje car tzi chalupa, bi hmɛxu̱y rá zö, nu car Jesús jí̱ bbe mbá ca̱h pʉ jar ttøø. ");
INSERT INTO otsNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ya xi mí dyo hnar ndo nda̱ji̱, mí tɛjni car deje, hasta mí nantzi. ");
INSERT INTO otsNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Quí möxte car Jesús, bbʉ ya xquí caminajʉ como ddajto quilómetro, bi jiantijʉ, ya xi má tɛnijʉ car Jesús, guegue‑ca̱ má dyo xøtze car deje, ya xi má cuati jar barco. Cja̱ bi ndo ntzu̱jʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nu car Jesús bi nzofo, bi hñi̱mbijʉ: ―¡Dyo guí ntzu̱jʉ! Guejquigö.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Diguebbʉ, bi jñu̱ í mʉyjʉ, cja̱ bi jiɛjmʉ car Jesús di ñʉti jar chalupa. Cja̱ nguetica̱ bi zøtijʉ nʉ Capernaum, nʉ jabʉ mír möjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Diguebbʉ ya, car jiax pʉ ya, car ndo jmundo cʉ cja̱hni pé bi jion car Jesús. Pé bi jmu̱ntzijʉ nʉ rí ncjanʉ car mar Galilea, már bböpjʉ hnanguadi car deje, nʉ jabʉ xquí zijʉ cʉ tju̱jme̱ car pa ca xquí tjogui, már jonijʉ pʉ car Jesús. Bi mbe̱n cʉ cja̱hni, car pa ca xquí tjogui jin te xquí hmʉ barco nʉ jabʉ már bbʉpjʉ, jøña̱ ca hnaatjo pʉ jabʉ xcuí hñe̱h car Jesús co quí amigo. Guejtjo mí pa̱h cʉ cja̱hni rá ngu̱, bbʉ már cʉjʉ pʉ jar chalupa quí möxte car Jesús pa pé drí ddax car deje, jí̱ mí yojmʉ car Jesús, jøña̱ quí möxte már cʉjʉ pʉ. Eso, mí hñöntsjɛ cʉ cja̱hni, ¿jabʉ xquí ma ya car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nu car xudi‑ca̱, pé bi zøjø pé dda tzi barco pʉ jabʉ már bbʉh cʉ cja̱hni. Cʉ tzi barco‑cʉ́, xcuí hñe̱j nʉ jar jñini Tiberias, bi zøh pʉ cerca pʉ jabʉ xquí hmʉh car Jesús ca hnajpa ca xquí tjogui, guehpʉ jabʉ xquí dyöjpi mpöjcje car Tzi Ta ji̱tzi por rá ngue cʉ tju̱jme̱, cja̱ xquí ún car ndo jmundo cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bbʉ mí cca̱hti cʉ cja̱hni, ya jí̱ már bbʉh pʉ car Jesús ni digue quí möxte, gueguejʉ bi ñʉti cʉ tzi chalupa cʉ xquí zøjø, bi ddaxjʉ car mar gá möjmʉ nʉ Capernaum pa du jonijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Diguebbʉ ya, bbʉ mí zøtijʉ nʉ rí ncjanʉ car deje, bú ntjɛjʉ car Jesús, cja̱ bi dyönijʉ: ―Nuquɛ, Maestro, ¿ncjahmʉ xcú e̱quɛ hua?― ");
INSERT INTO otsNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Bi da̱j ya car Jesús, bi hñi̱na̱: ―Nuquɛjʉ, xcú e̱jmʉ hua, hne̱ guá jonguijʉ por rá nguehca̱ dá ddahquijʉ tju̱jme̱ cja̱ gú ñi̱ña̱jʉ. Masque xcú cca̱htijʉ cʉ milagro cʉ xtú øtigö, jí̱ rá nguehcʉ́ xquí hñe̱jmʉ hua. ");
INSERT INTO otsNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Guí pɛjmʉ pa gui ta̱jmʉ tju̱jme̱, gui tzijʉ. Nu ca más i nesta gui jionijʉ, gue car tju̱jme̱ ca jin da tjegue cja̱ da ddahquijʉ car nzajqui ca rí hñe̱ ji̱tzi. Nugö, xtá ddahquijʉ car tju̱jme̱‑ca̱, como guejquigö dúr cja̱hni, dú ca̱h pʉ ji̱tzi. Guejquigö, xpá mɛnquigö car Tzi Ta ji̱tzi cja̱ xí ddajqui cam ttzɛdi gu øti milagro, pa ncjapʉ dír fa̱di jabʉ xtá e̱jcö.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Diguebbʉ ya cʉ cja̱hni bi dyön car Jesús: ―¿Tema bbɛfi i ne ca Ocja̱ pa gu øtije?― ");
INSERT INTO otsNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Bi da̱j ya car Jesús, bi hñi̱na̱: ―I ne ca Ocja̱ gui hñemeguijʉ, guejquigö, xpá mɛnquigö.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Diguebbʉ ya, pé bi ma̱n cʉ cja̱hni: ―Dí neje gui u̱jtiguije hnar milagro rá nzɛdi pa gu e̱me̱quije, ¿cja cierto xquí hñe̱ ji̱tzi? ¿Tema milagro drá nzɛdi gui dyøte ncja ngu̱ cʉ milagro cʉ mí øti car Moisés? ");
INSERT INTO otsNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Cʉ ndom tajʉ bi zijʉ car alimento mbá jøh pʉ ji̱tzi bbʉ mí dyojʉ pʉ jabʉ jin te mí bbʉ ngu̱, mí tɛnijʉ car Moisés. Bi zʉdi ncja ngu̱ ga ma̱m pʉ jar Escritura: “Guegue mí wi̱n‑cʉ, mbá pɛmpi car tju̱jme̱ mír hñe̱ ji̱tzi.”― ");
INSERT INTO otsNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Diguebbʉ ya, pé bi ma̱n car Jesús: ―Dyøjma̱jʉ na̱r palabra na̱ dí xihquijʉ: Jí̱ mí gue ca ndor Moisés mí un cʉ ndom tajʉ car tju̱jme̱ mír hñe̱ ji̱tzi. Gue cam Tzi Ta ca bí bbʉh pʉ, mí unijʉ‑cá̱. Car tju̱jme̱ ca mí un‑cʉ́ mí jñɛjmi na̱ mero ʉr tju̱jme, guejna̱ xcuá hñe̱ ji̱tzi yʉ pa ya. ");
INSERT INTO otsNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cja̱ nuya, guegue xí ddahquijʉ na̱ mero ʉr tju̱jme̱, guejna̱ da ddahquijʉ car nzajqui ca rí hñe̱ ji̱tzi, da un yʉ cja̱hni göhtjo yʉ i bbʉjcua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Diguebbʉ ya, pé bi da̱h cʉ cja̱hni, bi xih car Jesús: ―Nuquɛ, Tzi Tada, ddajquije tzʉ car tju̱jme̱‑ca̱, nuya cja̱ göhtjo ʉr pa.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Cja̱ pé bi ma̱n car Jesús: ―Nugö, dí jñɛjcöbbe car tju̱jme̱‑cá̱. Guejquigö dí un yʉ cja̱hni car nzajqui ca rí hñe̱ ji̱tzi. Ca to da guajquigö cja̱ da hñemegui, ya jin da du̱ntju̱ cja̱ jin da du̱tje, göhtjo ʉ́r vida. ");
INSERT INTO otsNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nuquɛjʉ, pé dí yojpi dí xihquijʉ, jin guí ne gui hñemeguijʉ, masque ya xcú cca̱htijʉ ja i ncja yʉ dí øte. ");
INSERT INTO otsNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ya xí mbe̱n cam Tzi Ta ji̱tzi to cʉ cja̱hni cʉ da hñemegui, cja̱ göhtjo cʉ xí mbe̱ni guegue, guehcʉ da dɛnguigö‑cʉ. Car cja̱hni ca du e̱je̱ pa da jionguigö, ¿cja jin gu cuajtigö‑ca̱? ");
INSERT INTO otsNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nugö, jí̱ xtá ca̱h pʉ ji̱tzi pa gu øti ca dí mbentsjɛgö. Xtá e̱jcö pʉ pa gu øti ca i ne cam Tzi Ta ca xpá mɛnqui. ");
INSERT INTO otsNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Guegue i ne pa gu pɛhtzi rá zö cʉ cja̱hni, göhtjo cʉ xí ma̱ngui guegue da guajqui, cja̱ gu xoxcö‑cʉ bbʉ xta zøh car pa ca xta ncja car juicio. ");
INSERT INTO otsNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Cʉ cja̱hni cʉ i pa̱di toguigö cja̱ i e̱me̱, guejcö ʉ́r Ttʉgui car Tzi Ta ji̱tzi, guegue‑cʉ da mɛhtzi car nzajqui ca jin da tjegue, cja̱ nugö gu cjajpi da jña̱ ʉ́r jña̱‑cʉ́ car pa ca xta ncja car juicio. Guehca̱ xí mandadogui cam Tzi Ta‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Diguebbʉ ya quí jefe cʉ judio bi ña̱tsjɛjʉ, mí tzohmijʉ car Jesús, como xquí ma̱ guegue: “Nugö, mero guejquigö dí uni í nzajqui yʉ cja̱hni, xtá ca̱jcö pʉ ji̱tzi.” ");
INSERT INTO otsNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bbʉ mí dyøj nʉr palabra‑nʉ cʉ cja̱hni, bi ma̱jmʉ: ―¿Cja jin gui gue nʉr Jesús, ʉ́r ttʉ car José? Hni̱, cuando dí meyajʉ cár ta ʉ́r me. ¿Dyoca̱ i ma̱m bbʉ, guegue xpá nga̱h pʉ jar ji̱tzi?― ");
INSERT INTO otsNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bi da̱jti car Jesús, bi hñi̱na̱: ―Nuquɛjʉ, guí tzobiguijʉ, como jin guí ne gui hñemejʉ ca dí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jin gui tzö da dɛngui göhtjo yʉ cja̱hni, jøña̱ yʉ xí nzojtibi ʉ́r mʉyjʉ cam Tzi Ta ji̱tzi. Nuyʉ́ da dɛnguigö, cja̱ nugö gu cjajpi da jna̱ ʉ́r jña̱jʉ car pa ca da nantzi cʉ ánima. ");
INSERT INTO otsNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Xí ncjá ncja ngu̱ ga ma̱n cʉ profeta pʉ ja libro cʉ bi dyøtijʉ: “Car Tzi Ta ji̱tzi da nzojtibi ʉ́r mʉyjʉ göhtjo quí cja̱hni.” Eso, dí xihquijʉ göhtjo cʉ cja̱hni cʉ xí hñeme cam palabragö, guegue‑cʉ́ xí mba̱dijʉ, rí hñe̱h cam Tzi Ta yʉ palabra dí ma̱, cja̱ guegue‑cʉ ba e̱je̱ ba tɛnguigö. ");
INSERT INTO otsNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Jin to i bbʉh ca xtrú cca̱hti car Tzi Ta ji̱tzi, jønguitsjɛgö xtú cca̱hti, como xtá e̱jcö pʉ jabʉ bí bbʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ntjumʉy na̱r palabra na̱ dí xihquijʉ: Car cja̱hni ca xí hñemegui, ya xqui pɛhtzi car nzajqui ca rí hñe̱ ji̱tzi, nim pa jabʉ dír tjeh car nzajqui‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mero guejquigö dí un yʉ cja̱hni car nzajqui ca rí hñe̱ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Cʉ ndo ʉm tajʉ mí tzijʉ car alimento ca mbá jøh pʉ ji̱tzi bbʉ mí dyojʉ pʉ jabʉ jin te mí bbʉ ngu̱. Pe nde̱jma̱ bi du̱‑cʉ, masque güí hñe̱ ji̱tzi car tju̱jme̱ ca mí tzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nuna̱ dí xihquijʉ, guejna̱ mero ʉr tju̱jme̱ na̱ xcuá hñe̱ ji̱tzi. Cʉ cja̱hni cʉ da zi na̱r tju̱jme̱ na̱ dí xihquijʉ, nim pa jabʉ dír du̱‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Guejquigö, mero dúr tju̱jme̱ xtá e̱ ji̱tzi, como guejquigö dí un yʉ cja̱hni car nzajqui ca rí hñe̱ ji̱tzi. Gue nʉm cuerpo gu ddahquijʉ ncja ngu̱ dá ún cʉ tju̱jme̱ cʉ cja̱hni rá ngu̱. Gu dö cam vida pa da mɛhtzi car nzajqui ca jin da tjegue, yʉ cja̱hni hua jar jöy.― Ncjanʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nu quí jefe cʉ judio, bbʉ mí dyøjmʉ nʉr palabra‑nʉ, bi mʉdi bi mbömbitsjɛjʉ, mí ma̱jmʉ: ―¿Ja ncja dír ddajquijʉ nʉ́r cuerpo nʉr hñøjø‑nʉ, pa gu tzijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Car Jesús pé bi xijmʉ, bbʉ: ―Cierto na̱r palabra na̱ dí xihquijʉ, bbʉ jin gui tzijʉ nʉm cuerpo cja̱ co cam cji, jin gui tzö gui pɛhtzijʉ car nzajqui ca ntju̱mʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Car cja̱hni ca da zi nʉm cuerpo cja̱ co cam cji, por rá nguehcá̱, da mɛhtzi car nzajqui ca jin da tjegue, cja̱ nugö gu xotzi car pa ca xta ncja car juicio. ");
INSERT INTO otsNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Como gue nʉm ngø co cam cji da un car nzajqui ca ntjumʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ca to da zi nʉm cuerpo cja̱ co cam cji, nucá̱ da ttun cár nzajqui‑ca̱, cja̱ gu yobbe guegue. Por rá nguehca̱ dár yobbe, da mɛhtzi car nzajqui ca rí hñe̱ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Cam Tzi Ta ji̱tzi xpá mɛnquigö. Guegue i bbʉh cár nzajqui ca jin gui tjegue, cja̱ nugö dí yobbe cam Tzi Ta. Ca dár yobbe‑ca̱, eso, dí pɛhtzi car nzajqui ca rí hñe̱ ji̱tzi. Da ncjapʉ hne̱je̱ car cja̱hni ca da cuajtigui mbo ʉ́r tzi mʉy. Gu yobbe car cja̱hni‑ca̱, cja̱ guejti guegue da mɛhtzi nzajqui por rá nguejquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Guejquigö mero dúr tju̱jme̱ xtá ca̱h pʉ ji̱tzi, ncja ngu̱ xtá xihquijʉ. Xtá e̱jcö pʉ pa gu ddahquijʉ car nzajqui ca ntjumʉy. Na̱r tju̱jme̱ na̱ dí xihquijʉ jin gui ncja ngu̱ car alimento mí tzi cʉ ndom titajʉ. Nde̱jma̱ bi du̱ cʉ cja̱hni cʉ mí tzi‑ca̱. Nu ca to da zi na̱r tju̱jme̱ na̱ xtú xihquijʉ, da hmʉy göhtjo ʉr tiempo.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Car Jesús bi ma̱n yʉ palabra‑yʉ pʉ jar jñini Capernaum, már u̱jti cʉ cja̱hni pʉ jár templo cʉ judio. ");
INSERT INTO otsNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Diguebbʉ ya cʉ cja̱hni rá ngu̱ cʉ mí tɛnijʉ car Jesús, bbʉ mí dyødejʉ yʉ palabra‑yʉ, rá ndo ngu̱‑cʉ bi wembijʉ car Jesús. Bi ma̱jmʉ: ―Jin gui tzö nʉr palabra nʉ xí ma̱. ¿To dur du̱mʉy da zajpi ʉ́r cuerpo ya‑nʉ́?― ");
INSERT INTO otsNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nu car Jesús bi ba̱di, ya xi mír yomfe̱ni cʉ ddaa cʉ mí tɛni, como mí ttzodijʉ nʉr palabra nʉ xquí ma̱. Cja̱ guegue bi dyöni bbʉ: ―Nuquɛjʉ, ¿cja jin guí tzøjmʉ nʉ xtú ma̱? ¿Cja ya jin gui tzö gui hñe̱me̱jʉ ca dí xihquijʉ? ");
INSERT INTO otsNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bbʉ xtí cca̱jtiguijʉ pé xtár pøxcö pʉ jabʉ ndí bbʉ ma̱hmɛto, nubbʉ, cja xquí ntiendejʉ nʉr palabra nʉ xtú ma̱. Guejquigö dúr cja̱hni xpá bbɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Gue cár Espíritu ca Ocja̱ i un yʉ cja̱hni car nzajqui ca rí hñe̱ ji̱tzi. Bbʉ gri bbʉjcö hua ncja hnar cja̱hnitjo, jin di jogui gua ddahquijʉ car nzajqui ca rí hñe̱ ji̱tzi. Gue yʉ palabra yʉ dí xihquijʉ da ddahquijʉ car nzajqui ca jin da tjegue, como guejyʉ́ rí hñe̱h cár Espíritu ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nuquiguɛjʉ, yʉ ddaaquiguɛjʉ guí e̱me̱guijʉ, pe nde̱jma̱ guí yojmjʉ yʉ ddaa yʉ jin gui e̱me̱gui hne̱je̱.― Bi ma̱ ncjapʉ car Jesús, como mí pa̱di desde ʉ́r mʉdi tocʉ jí̱ mí e̱me̱ cja̱ toca̱ di dö. ");
INSERT INTO otsNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nubbʉ, car Jesús pé bi xih quí möxte cʉ mí ntzixihui: ―Jin gui tzö da dɛngui yʉ cja̱hni bbʉ jin gui nzojtibi ʉ́r mʉyjʉ cam Tzi Ta ji̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bbʉ mí dyødejʉ yʉ palabra‑yʉ, rá ndo ngu̱ cʉ cja̱hni cʉ xquí dɛn car Jesús bi wenijʉ, ya jin gá ndɛnijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Diguebbʉ ya, car Jesús bi dyön cʉ doce hñøjø cʉ má̱s mí ntzixihui: ―Xiquiguɛjʉ, ¿cja guí ne gui tzoguijʉ hne̱je̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bi da̱j ya car Simón Pedro, bi hñi̱mbi: ―Nuquɛ, Tzi Jmu̱, jin gu tzoquije, como u̱jtjo to pe gu tɛnije. Guehquiguɛ guí xijquije cʉ palabra cʉ i ddajquije car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nugöje dí meyaquije cja̱ dí e̱me̱je, guehquiguɛ xí hñi̱xqui car Tzi Ta ji̱tzi, cja̱ xpá mɛngui hua jar mundo.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Car Jesús ya pé bi da̱di: ―Xtú juanquigöjʉ, guí docejʉ gá möxte. Pe nde̱jma̱ i bbʉhquiguɛjʉ ca hnaa ca i yojmi ca Jin Gui Jo.― ");
INSERT INTO otsNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Bbʉ mí ma̱ nʉr palabra‑nʉ, mí ña̱ digue car Judas Iscariote, cár ttʉ car Simón. Car Judas mí yojmi cʉ pe dda once quí möxte car Jesús, cja̱ guegue di dö. ");
INSERT INTO otsNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cʉ pa‑cʉ, car Jesús segue mí dyo pʉ Galilea. Ya jí̱ mí ne di hño pʉ Judea, porque mí bbʉh pʉ cʉ dda judio cʉ mí mandado, cja̱ nucʉ́, ya xi mí joni ja dír möhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ya xti zøh car mbaxcjua ca mí tzö cʉ judio bbʉ mí øti quí tzi ngu̱ gá dyɛza. ");
INSERT INTO otsNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nubbʉ, quí cjua̱da̱ car Jesús bi xijmʉ: ―Gui pønguɛ ya, gui ma guír ma pʉ Judea, ya xta ncja car mbaxcjua. Ma bú øti pʉ cʉ ndo milagro cʉ guí øte, pa da cca̱hti quir amigo cʉ i ne da dɛnqui.― Nu quí cjua̱da̱ car Jesús mí øhtibitjojʉ ʉr burla. ");
INSERT INTO otsNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Cja̱ pé bi ma̱jmʉ: ―Bbʉ to i ne da ddɛni, jí̱ rí ntzöhui da pɛh pʉ jabʉ jin to i cca̱hti. Nuquiguɛ, guí øti milagro. Bbʉ guí ne da tti̱zqui, gui ma guír pɛh pʉ jabʉ i bbʉ cja̱hni rá ngu̱, pa da tjantiqui.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bi ma̱ ncjapʉ quí cjua̱da̱ car Jesús, como guejti gueguejʉ jí̱ mí e̱me̱jʉ ¿cja xcuí mɛjni car Tzi Ta ji̱tzi? ");
INSERT INTO otsNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nu car Jesús pé bi da̱h bbʉ: ―Jí̱ bbe i tzøh car tiempo pa gu ma grí øti rá ngu̱ milagro pʉ Jerusalén. Nuquɛjʉ, rí ntzöhui gui möjmʉ pʉ car hora ca guí nejʉ, ");
INSERT INTO otsNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","como jin gui ʉquijʉ yʉ cja̱hni yʉ i tɛn nʉr mundo, pe nugö, i ʉgui, como dí xijmʉ ca ncjua̱ni. Dí xijmʉ, rá nttzo ca i øtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nuquɛjʉ, gui möquɛjʉ ya, guír möjmʉ jar mbaxcjua. Nugö, jí̱ bbe i tzøh car pá gu ma pʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cja̱ bbʉ ya xquí xih quí cjua̱da̱ yʉ palabra‑yʉ, car Jesús pé bi døhmi pʉ Galilea tengu̱ tzi mpa. ");
INSERT INTO otsNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bbʉ ya xquí möjmʉ jar mbaxcjua quí cjua̱da̱, diguebbʉ, guejti car Jesús bi ma gá ma pʉ. Bi precura pa jin di tjanti cja mír ma pʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nu cʉ judio cʉ mí mandado, mí dyo pʉ Jerusalén, pʉ jabʉ már ncja car mbaxcjua, mí jonijʉ car Jesús. Mí i̱na̱jʉ ya xtrú nzø guegue, eso mí hñöntsjɛjʉ: ―¿Jabʉ i bbʉh car hñøjø‑ca̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Guejti cʉ cja̱hni már ngu̱ cʉ xquí jmuntzi pʉ jar mbaxcjua mí ña̱tsjɛjʉ digue car Jesús. Nucʉ, mí ntøxtijʉ. Cʉ ddaa mí ma̱: “Rá zö car hñøjø‑ca̱.” Nu cʉ pe ddaa mí ma̱: “Ji̱na̱, i jöti yʉ cja̱hni.” ");
INSERT INTO otsNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pe mí ña̱jʉ ntta̱guitjo cʉ cja̱hni, porque mí tzu̱jʉ, má̱s di dyøh cʉ möcja̱ cʉ mí mandado. ");
INSERT INTO otsNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bbʉ ya xi mí dyo madé car mbaxcjua, car Jesús bi hna ni̱gui pʉ, bi guati pʉ jar templo cja̱ bi u̱jti cʉ cja̱hni cár palabra ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Diguebbʉ ya bi guati cʉ dda cja̱hni cʉ mí mandadobi cʉ judio, bi dyødejʉ ter bɛh ca̱ mí ma̱n car Jesús. Bi ndo hño í mʉyjʉ bbʉ, cja̱ bi ma̱jmʉ: ―¿Ja gá mba̱j nʉr hñøjø‑nʉ te i ma̱n cʉ Escritura, hne̱ jí̱ xcá nxöh cár ley car Moisés ncja ngu̱ xtá nxöjcöjʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pé bi da̱h car Jesús, bi hñi̱na̱: ―Nugö, jin dí ma̱ngö ca dí mbe̱ntsjɛgö. Dí u̱jti yʉ cja̱hni jøña̱ ca xí xijqui ca hnaa ca xpá mɛnquigö hua. ");
INSERT INTO otsNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Car cja̱hni ca i e̱me̱ cam Tzi Ta ji̱tzi cja̱ i ne da hmʉy ncja ngu̱ ga ne guegue‑ca̱, da ba̱di jabʉ rí hñe̱j yʉ palabra yʉ dí ma̱. Da ba̱di, jin gʉm mfe̱nitsjɛ yʉ dí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bbʉ di hñe̱h hnar cja̱hni ca jí̱ xtrú mɛjni car Tzi Ta ji̱tzi, guegue di xih quí mi̱nga̱‑cja̱hnihui ca te di mbe̱ntsjɛ, como i bbʉjtsjɛ cja̱ i mbe̱ni te da ma̱ pa da tti̱htzibi. Pe nugö, xpá mɛnqui cam Tzi Ta ji̱tzi, cja̱ dí mbe̱ngö ja gu ncja pa da tti̱htzibi jøña̱ guegue. Eso, göhtjo cierto yʉ palabra yʉ dí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nuquiguɛjʉ, guí tjɛjʉ car ley ca bi zoguiguijʉ ca ndor Moisés, cja̱ guí cca̱htijʉ, pe guí göhtjojʉ, jin guí øtijʉ ncja ngu̱ ga ma̱n car ley‑ca̱. ¿Dyoca̱ guí jonijʉ já guír pöjtiguijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bi da̱j ya cʉ cja̱hni, bbʉ: ―Pé ngu̱ xcú ntjɛhui cár nda̱ji̱ ca Jin Gui Tzö, xcú nloco. Xijquije ya, ¿toca̱ i ne da möjtiqui?― ");
INSERT INTO otsNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Bi da̱j ya car Jesús, bi ma̱: ―Xtú dyøtje hnar döhtji car pa ca guí tzu̱jpijʉ, cja̱ nuquɛjʉ guí göhtjojʉ, guí tzobiguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dí mbe̱mbiquijʉ ya digue ca hnar mandamiento ca bi zoguiguijʉ car Moisés, masque jí̱ mí guejtsjɛ car Moisés ca bi ddajquijʉ car mandamiento‑ca̱. Mí gue cʉ ndom titajʉ. Nucʉ́, bi xijquijʉ, bbʉ xta zʉ ñojto ca xcá hmʉh hnar tzi hñøjø, da ncuajtibi car seña gá circuncisión jár ngø. Masque xín da zʉh car ñojto car pa ca dí tzu̱jpijʉ, nde̱jma̱ da ncuajtibi car seña‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nuquɛjʉ, guí ma̱jmʉ, i nesta da ncuajtibi car seña‑ca̱, pa da ncumpli car ley ca bi zoguijʉ car Moisés, masque dur pa nsabado, nde̱jma̱ da ttøhtibi. Nugö xtú jojqui hnar döhtji car pa nsábado, pa xcá jogui rá zö göhtjo cár cuerpo, cja̱ nuquɛjʉ, guí tsjeyaguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jin gui tzö quir mfe̱nijʉ. Guí tzohmijʉ yʉ cja̱hni yʉ jin gui tɛn cʉ costumbre cʉ guí tɛnijʉ. Pe jin guí mbe̱nguɛjʉ, ¿ter bɛh ca i tzøh ca Ocja̱?― Ncjanʉ gá xih cʉ cja̱hni‑cʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bbʉ mí dyødejʉ yʉ palabra‑yʉ́, bi ma̱n cʉ dda cja̱hni, cʉ́m Jerusalén, bi hñöntsjɛjʉ: ―¿Cja jin gui gue nʉr hñøjø‑nʉ i tjoni pa da bböhti? ");
INSERT INTO otsNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Tji ya ca̱ bbʉ! Cja i bböjti hua i u̱jti yʉ cja̱hni. Guejti yʉ ddáa yʉm jefejʉ i bbʉjcua hne̱je̱. ¿Sa jin te i xijmʉ ya? ¿Ja̱di? ¿Cja huá ya xí mbe̱n yʉm jefejʉ, má̱s gue nʉr hñøjø nʉ xí hñi̱x ca Ocja̱ pa da mandadoguijʉ? ¿Cja gue nʉr Cristo nʉ dí tøhmijʉ? Pé jin gui guejnʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Como dí pa̱dijʉ to nʉr hñøjø‑nʉ cja̱ jabʉ ʉr mi̱ngu̱. Pe bbʉ xtu e̱h ca hnaa ca da hñi̱x ca Ocja̱ pa da mandadoguijʉ, jin to da ba̱di jabʉ dur mi̱ngu̱ guegue.― Ncjanʉ gá ma̱n cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Car Jesús már u̱jti cʉ cja̱hni pʉ jar templo, cja̱ bi dyøj nʉr palabra nʉ xquí jma̱. Guegue ya bi ña̱ nzajqui, bi da̱di: ―Nuquɛjʉ, guí ma̱jmʉ guí pa̱dijʉ toguigö cja̱ co jabʉ xtá e̱je̱. Pe nugö, jí̱ xtá mbe̱ntsjɛ gua e̱je̱. I bbʉh ca hnaa ca xpá mɛnquigö cja̱ xpá ddajqui nʉm cargo, gue car Tzi Ta ji̱tzi, i bbʉy göhtjo ʉr tiempo. Nuquɛjʉ, jin guí pa̱dijʉ ja i ncja guegue‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nugö, dí meya, como ndí bbʉbbe, cja̱ guegue xpá mɛnquigö hua.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bbʉ mí ma̱ nʉr palabra‑nʉ car Jesús, mí bbʉh cʉ dda cja̱hni cʉ mí ne di zʉdijʉ pa di gotijʉ födi. Pe jin to gá ngöxi ʉ́r dyɛ, como jí̱ bbe mí tzʉh car hora pa di ttzʉdi. ");
INSERT INTO otsNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cja̱ már ndo ngu̱ cʉ cja̱hni cʉ bi hñe̱me̱jʉ guegue. Mí ma̱jmʉ: ―¿Cja jin gui gue nʉr Cristo nʉ di hñi̱x ca Ocja̱ pa di mandadoguijʉ? Rá ndo zö yʉ i øte. Pé ya jin du e̱ pé hnar hñøjø ca da dyøti milagro más drá zö.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bi dyøh cʉ fariseo te mí ma̱n cʉ cja̱hni digue car Jesús. Nubbʉ, gueguejʉ co cʉ möcja̱ cʉ mí mandado bú pɛjni nzʉttabi pa di zʉdijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Diguebbʉ ya, pé bi ma̱n car Jesús: ―Xtá hmʉjtigö gu hmʉpjʉ tengu̱ tzi mpa, cja̱ diguebbʉ ya, xtá ma pʉ jabʉ bí bbʉh ca hnáa ca xpá mɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nuquɛjʉ, xquí jionguijʉ, pe jin da nzö gui töjquijʉ, porque jin da jogui gui möjmʉ pʉ jabʉ guir bbʉjcö.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nubbʉ, bi hñöntsjɛjʉ cʉ ddáa judio cʉ mí mandado: ―¿Jabʉ da ma nʉr hñøjø‑nʉ pa jin da nzö gu tötijʉ? ¿Cja pé ntoja da ma yapʉ, hnahño ʉr jöy? ¿Cja da bøngua, da ma drí zøti pʉ jabʉ rá bbʉh cʉ dda judio cʉ xí mbøngua, pa du u̱jti cʉ cja̱hni‑cʉ hne̱je̱? ");
INSERT INTO otsNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Jin dí pa̱dijʉ te i ne da ma̱ na̱r palabra na̱ xí xijquijʉ: “Xquí jionguijʉ, pe jin da nzö gui töjquijʉ, porque jin da nzö gui möjmʉ pʉ jabʉ guir bbʉjcö.”― Ncjanʉ gá hñöntsjɛ cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bbʉ mí zøh car pa bbʉ ya xti guah car mbaxcjua, cja̱ ya xi mí ndo ncja mbaxcjua, car Jesús bi hmöh pʉ madé pʉ jabʉ xquí jmu̱ntzi cʉ cja̱hni, bi ña̱ nzajqui, bi nzojmʉ: ―Bbʉ to i tu̱tje, du e̱cua jabʉ dí bbʉjcö, cja̱ nugö gu un car deje ca ntjumʉy, pa ya jim pé da du̱tje. ");
INSERT INTO otsNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ca to da hñemegui, da döti car deje ca jin da tjegue. Cár tzi mʉy car cja̱hni‑ca̱, da jñɛjmi hnar pøtje ca i pøxi deje rá ngu̱ cja̱ jin gui xö, ncja ngu̱ ga ma̱m pʉ jar Escritura.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Bbʉ mí ma̱n nʉr palabra‑nʉ, car Jesús mí jɛqui car Espíritu Santo ncja car deje. Tzʉdi, mí ma̱, car Espíritu Santo di guati cʉ cja̱hni cʉ di hñeme guegue. Cʉ pa‑cʉ́, jim be mí cuati cʉ cja̱hni car Espíritu Santo, como jim pe mí pøx car Jesús pʉ ji̱tzi. Hasta gue bbʉ xti bøtze cja̱ di mɛjni car Espíritu Santo, nubbʉ, cja di guati cʉ cja̱hni bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bbʉ mí dyødejʉ nʉr palabra‑nʉ cʉ cja̱hni, bi ma̱n cʉ ddáa: ―¡Mero, gue nʉ́r jmandadero ca Ocja̱ nʉ mí tsjijquijʉ di hñe̱je̱!― ");
INSERT INTO otsNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Cja̱ pé mí bbʉ pe ddáa cʉ mí ma̱jmʉ: ―Cierto, gue nʉr Cristo‑nʉ́. Xí hñi̱x‑nʉ́ ca Ocja̱ pa da mandadoguijʉ.― Nu cʉ pe ddaa, jin gá hñemejʉ. Guegue‑cʉ bi ma̱jmʉ: ―Pé jin gui guejnʉ. Jin du e̱h pʉ jar estado Galilea car Cristo. ");
INSERT INTO otsNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Como i ma̱m pʉ jar Escritura, bbʉ xtu e̱h car Cristo ca xtúr hñi̱x ca Ocja̱ pa da mandadobi yí cja̱hni, da hmʉy digue cár cji ca ndor David. Guegue dur mi̱ngu̱ car tzi jñini Belén hua jar estado Judea, pʉ jabʉ mí bbʉh ca ndor David.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ncjanʉ nguá mbe̱n cʉ cja̱hni. Hnahño mír ma̱n cʉ ddaa, cja̱ pé hnahño cʉ pe ddaa, mí ntøxtijʉ. Cja̱ bi weguejʉ por rá ngue car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Cʉ ddaa mí ne di zɛtijʉ cja̱ di zitzi gá preso, pe jin to gá ngöxi ʉ́r dyɛ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Diguebbʉ ya, cʉ nzʉttabi cʉ xcuí cju̱y pa du tzʉh car Jesús, bú cojtijʉ jabʉ már bbʉh cʉ fariseo co cʉ möcja̱ cʉ mí mandado. Nucʉ́ bi dyönijʉ, bbʉ: ―¿Dyoca̱ jí̱ xcuá tzijʉ car Jesús?― ");
INSERT INTO otsNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bi da̱h cʉ nzʉttabi, bbʉ: ―Rá ndo zö ca i ma̱ guegue. Nim pa jabʉ xtú ødeje palabra cʉ di jñɛjmi cʉ i ma̱ guegue.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Diguebbʉ ya bi dyön cʉ fariseo, bi hñi̱na̱jʉ: ―¿Cja guehquitjoguɛjʉ hne̱ xí jiöhquijʉ? Guehca̱ jin te xquí nxödijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yʉ cja̱hni yʉ xí nxöh cár ley ca Ocja̱, cja̱ co yʉ möcja̱ yʉ i pɛhtzi cargo, cja̱ co hne̱quigöje, dí fariseoje, dí göhtjogöje jin dí e̱me̱je ¿cja xcuá hñe̱h ca Ocja̱ car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nu nʉr ndo jmundo yʉ cja̱hni, jin te ntjumʉy ca i mbe̱n‑yʉ́, como jin gui pa̱j‑yʉ́ te i ma̱n car ley. Car Tzi Ta ji̱tzi jin gui nu̱ rá zö yʉ cja̱hni‑yʉ.― Ncjanʉ gá tsjih cʉ nzʉttabi. ");
INSERT INTO otsNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Már bbʉh pʉ hne̱je̱ ca hnar fariseo, mí ju̱ cár tju̱ju̱ múr Nicodemo. Guegue mí yojmi cʉ möcja̱ co cʉ pe dda fariseo. Mí gue car Nicodemo ca xcuí hñe̱je̱ ca hna nxu̱y pʉ jabʉ már bbʉh car Jesús, xquí ña̱hui. Car Nicodemo ya, bi xih cʉ möcja̱: ");
INSERT INTO otsNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―I ma̱n cam leygöjʉ, jin gui tzö gu ɛmbijʉ cár castigo hnar cja̱hni bbʉ jim be di tja̱mpi ʉr huɛnda pa da fa̱di ter bɛh ca̱ xtrú dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Cja̱ pé bi da̱h cʉ pe dda fariseo, bi xijmʉ car Nicodemo: ―Hne̱hquitjoguɛ, ¿cja guí ne gui tɛn car Jesús hne̱je̱, ncja ngu̱ cʉ mi̱ngu̱ Galilea? Gui nxödi rá zö pa gui pa̱di te i ma̱n cʉ Escritura. I ma̱n‑cʉ, jin da hmʉh hnár jmandadero ca Ocja̱ ca dur mi̱ngu̱ Galilea.― ");
INSERT INTO otsNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Cja̱ bbʉ ya xquí ma̱jmʉ nʉr palabra‑nʉ, göhtjo bi möjmʉ í ngu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nu car Jesús bi ma jar ttøø ca mí tsjifi Olivos. Mí tsjifi ncjapʉ como mí jø pʉ rá ngu̱ cʉ za, nxøgue gá olivo. ");
INSERT INTO otsNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ca xní cja yojpa, mí ndo nxu̱ditjo, bú coh pʉ jar templo, cja̱ göhtjo cʉ cja̱hni bi guatijʉ. Bi mi̱h car Jesús, bi mʉdi bi u̱jti‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Diguebbʉ ya, bú e̱h cʉ maestro cʉ mí u̱jti cʉ cja̱hni cár ley ca Ocja̱, cja̱ co cʉ fariseo, mbá tzijʉ hnar bbɛjña̱ xcuí dötijʉ már øti ca rá nttzo. Cja̱ bi hñi̱tijʉ car bbɛjña̱ madé cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nubbʉ, cʉ maestro co cʉ fariseo bi xijmʉ car Jesús: ―Nuquɛ, Maestro, xtú tötije na̱r bbɛjña̱‑na̱, már bbonihui hnar hñøjø jí̱ ʉ́r da̱me. Mero xtú tötije. ");
INSERT INTO otsNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","I ma̱m pʉ jar ley ca xí nzoguijʉ ca ndor Moisés te da ncjajpi hnar bbɛjña̱ di yohti da̱me. I nesta da bböhti, da nccajni me̱do. Xiquiguɛ, ¿te guí ma̱nguɛ?― ");
INSERT INTO otsNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nu cʉ cja̱hni‑cʉ, bi dyön car Jesús nʉr nttöni‑nʉ pa di dyøhtibijʉ hnar trampa. ¿Cja jin di da̱di tema palabra jin di tzö, pa ncjapʉ di döti te drí jiøxjʉ? Nu car Jesús, jin te gá nda̱di, bi ani jöy, bi dyøtitjo letra pʉ jar jöy co ni cár xö. ");
INSERT INTO otsNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Diguebbʉ ya, cʉ maestro cja̱ co cʉ fariseo pé bi yojpi bi dyönijʉ ter bɛh ca̱ di ncjajpi car bbɛjña̱‑ca̱. Nubbʉ, bi bböh car Jesús, bi da̱di: ―Nuquiguɛjʉ, bbʉ i bbʉhquiguɛjʉ hnaa ca jin te i ndu̱jpite, guegue‑ca̱ bbɛto da ccajni hnar me̱do nʉr bbɛjña̱‑nʉ̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Cja̱ bbʉ ya xquí ma̱ nʉr palabra‑nʉ, pé bi an car Jesús, pé bi escribi jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nu quí contra, bbʉ mí dyøjmʉ nʉr palabra‑nʉ, hna‑hnaa gá wenijʉ, como göhtjo mí mbe̱nijʉ cʉ cosa rá nttzo xquí dyøtijʉ hne̱je̱. Bbɛto bi bøn cʉ más ya xquí ntita, cja̱ gá nga̱x ya, cʉ mí ba̱jtzi tjojo. Bi gojti pʉ jøña̱ car Jesús co car bbɛjña̱. Nucá̱, már bböjti pʉ jabʉ xquí hmöhmi pa di njuzga. ");
INSERT INTO otsNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Diguebbʉ ya, bi bböh car Jesús, bi cca̱hti jøña̱ car bbɛjña̱ xquí goh pʉ. Bi xifi: ―Nuquɛ, na̱na̱, ¿jabʉ xcá ma ya cʉ cja̱hni cʉ bi xijqui rí ntzöhui da bböjtiqui? ¿Cja jin to xcá ccajnqui doo?― ");
INSERT INTO otsNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Cja̱ bi da̱h car bbɛjña̱: ―u̱jtjo.― Diguebbʉ ya, bi xih car Jesús: ―Hne̱quigö, jin te dí cjahqui, hne̱je̱. Nugö dí xihqui gui ma ya, pe jin gui ma gui yojpi gui dyøti ca rá nttzo ca xcú dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pe hnar vez, car Jesús bi nzoh cʉ cja̱hni, bi hñi̱na̱: ―Nugö, dí jñɛbbe hnar jiahtzi, xtú e̱cua jar jöy pa gu yoti yʉ cja̱hni. Ca to da dɛnguigö, jin da hño jar bbɛxu̱y. Nuca̱, ncjahmʉ da yoti hnar jiahtzi mbo ʉ́r tzi mʉy, da ncja ʉ́r nzajqui.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Diguebbʉ ya, cʉ fariseo pé bi xijmʉ car Jesús: ―Nuquiguɛ, jin te i bbʉh quer testigo pa da ma̱ toquiguɛ. Eso, guí dötsjɛ quer palabra. Jin gui ntjumʉy ca guí ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Bi da̱j ya car Jesús, i̱na̱: ―Macja̱ dí dötsjɛ nʉm palabra ncja hnar testigo, dí ma̱ toguigö, pe nde̱jma̱ ntjumʉy ca dí xihquijʉ, como dí pa̱di jabʉ dá e̱je̱ jar mʉdi, co hne̱je̱ jabʉ gár ma jar ga̱tzi. Nuquiguɛjʉ jin guí pa̱dijʉ jabʉ dá e̱je̱ ni jabʉ pé gár ma. ");
INSERT INTO otsNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nuquiguɛjʉ, guí ne gui cjajʉ nzöya, tzʉdi, guí ne gui cjaguijʉ gu ma̱n ca ncjua̱ni, ncjahmʉ gur mi̱ngutjo hua jar jöy. Nugö, jin dá e̱je̱ pa gua cjagö ʉr nzöya. ");
INSERT INTO otsNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pe bbʉ gua cjagö nzöya, nde̱jma̱ gua øti jujticia, como jin dí ddatsjɛ. Dí yobbe car Tzi Ta ji̱tzi ca xpá mɛnquigö, cja̱ bbʉ xtá cjagö nzöya, gu yobbe guegue, gu ja̱mpibbe ʉr huɛnda yʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","I ma̱n car ley ca guí tɛnijʉ, bbʉ di bbʉ yo testigo, cja̱ di hnagu̱di ca i ma̱, nubbʉ́, da tte̱me̱bi cár palabrahui. ");
INSERT INTO otsNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nugö, dúr testigo. Dí xij yʉ cja̱hni toguigö, dí dötsjɛ cam palabra. Cja̱ hne̱h cam Tzi Ta ca xpá mɛnquigö hua, guejti‑cá̱ i dö cár palabra, i ma̱ toguigö.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Diguebbʉ ya quí jefe cʉ judio pé bi dyönijʉ: ―¿Jabʉ i bbʉh quer ta? Como guí ma̱nguɛ, guegue da dö cár palabra gá testigo.― Bi da̱h car Jesús: ―Nuquɛjʉ, como jin guí pa̱dijʉ toguigö, guejtjo jin guí pa̱dijʉ to cam Tzi Ta. Bbʉ güi pa̱dijʉ toguigö, nubbʉ, güi pa̱dijʉ to cam Tzi Tagö hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Car Jesús már u̱jti cʉ cja̱hni pʉ jar templo bbʉ mí ma̱n yʉ palabra‑yʉ́. Már bbʉh pʉ jabʉ mí ttzoh cʉ ofrenda. Cja̱ jin to te gá cjajpi, como jim be mí tzʉh car hora ca xquí mbe̱n car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Car Jesús pé bi yojpi bi xih cʉ fariseo co cʉ maestro cʉ mí u̱jti cʉ cja̱hni car ley: ―Gu magö, cja̱ nuquiguɛjʉ, gui má gui jionguijʉ, pe jin gui töjquijʉ, eso, xquí tu̱dijʉ, göhtjo co ca rá nttzo ca xcú dyøtijʉ. Pʉ jabʉ dár magö, jin da nzö gui tɛnguijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nubbʉ́, bi hñön cʉ judio, bi ma̱jmʉ: ―¿Ja̱di? ¿Cja huá da mpöhtitsjɛjɛ? Como i ma̱, pʉ jabʉ rí ma, jin da nzö gu tɛnijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Car Jesús pé bi xijmʉ: ―Nuquiguɛjʉ, guí cja̱hnitjojʉ. Nuguigö, xtá ca̱jcö nʉ jar ji̱tzi. Nuquiguɛjʉ, guí mi̱ngu̱tjojʉ hua jar mundo. Nuguigö, jin dúr mi̱ngu̱ hua. ");
INSERT INTO otsNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eso, dí xihquijʉ, gui ma gui tu̱dijʉ, göhtjo co ca rá nttzo ca xcú dyøtijʉ. Jin da mperdonaquijʉ‑cá̱, como jin guí ne gui hñemejʉ, ¿cja guejquigö, xí ttajqui nʉm cargo pa gu cjʉzquijʉ ca guí tu̱jʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nubbʉ́, cʉ judio pé bi dyönijʉ: ―¿Toquiguɛ, bbʉ́?― Bi da̱j ya car Jesús, i̱na̱: ―Ya xtú xihquijʉ. Desde ʉ́r mʉdi xtú xihquijʉ toguigö. ");
INSERT INTO otsNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nugö, dí mbe̱ngö rá ngu̱ cosa dí ne gu xihquijʉ. Dí ne gu nzohquijʉ, como jin gui tzö ca guí øtijʉ. Pe jin gu xihquijʉ ca dí mbe̱ntsjɛ. Gu xihquijʉ jøntsjɛ ca i ma̱n ca hnaa ca xpá mɛnquigö, cja̱ cierto göhtjo cʉ palabra i ma̱ guegue‑ca̱. Jøntsjɛ car palabra ca xí xijqui, guehca̱ dí xij yʉ cja̱hni hua jar mundo.― Ncjanʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nu cʉ judio cʉ már ña̱hui car Jesús jin gá mba̱dijʉ, ¿cja mí gue car Tzi Ta ji̱tzi ca mí ma̱n car Jesús? ");
INSERT INTO otsNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Car Jesús pé bi xijmʉ, bbʉ́: ―Nuquɛjʉ, bbʉ xta zøh car pa bbʉ ya xcrú tu̱gö, nubbʉ́, cja xquí pa̱dijʉ, bbʉ́, nugö xtú xihquijʉ ntjumʉy toguigö. Nubbʉ, xquí pa̱dijʉ hne̱je̱, jin dí øtigö ca dí mbe̱ntsjɛ. Dí øte cja̱ dí ma̱ ncja ngu̱ ga xijqui cam Tzi Ta. Guejquigö, dúr cja̱hni, xpá mɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cja̱ dí yobbe cam Tzi Ta ca xpá mɛnquigö. Guegue jin gui jɛguigui gu hnaatsjɛ. Dí yobbe‑ca̱, como göhtjo ʉr pa dí øti ca i ne guegue.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bbʉ mí ma̱n yʉ palabra‑yʉ car Jesús, rá ngu̱ cja̱hni bi hñemejʉ, cierto xcuí hñe̱h ca Ocja̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Diguebbʉ ya, car Jesús bi xih cʉ judio cʉ xquí hñemejʉ: ―Nuquiguɛjʉ, bbʉ gui tɛnijʉ car palabra ca dí xihquijʉ, xquí cjajʉ ʉm cja̱hniquigöjʉ, cja̱ gui nxödi gui hmʉpjʉ ncja ngu̱ dar hmʉjcö. ");
INSERT INTO otsNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nubbʉ, xquí pa̱dijʉ ter bɛh ca ncjua̱ni, cja̱ xquí hmʉpjʉ libre bbʉ́.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Cʉ judio pé bi da̱dijʉ: ―Nugöje, í ba̱jtziguije ca ndor Abraham, cja̱ jin te xcá hmʉh hnar jmu̱ ca di mandadoguije gá fuerza. ¿Dyoca̱ guí ma̱nguɛ, i nesta gu e̱me̱je ca ncjua̱ni pa gu hmʉpje libre? Göhtjo ʉr vida dí bbʉpje libre.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Bi da̱j ya car Jesús, i̱na̱: ―Cierto na̱ dí xihquijʉ, göhtjo yʉ cja̱hni yʉ i øti ca rá nttzo, i jñɛjmʉ muzo. Cʉ nttzomfe̱ni i mbe̱nijʉ i mandadobi cja̱ i cjajpi da dyøtijʉ ca jin gui tzö. Nuquiguɛjʉ, guí ncjajʉ pʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hnar muzo, da hmʉjti pʉ jár ngu̱ cár jmu̱ tengu̱ mpa, como i pɛjpitjo cár jmu̱, pe jin te ʉ́r ncjahui car mi̱ngu̱. Nu cár ttʉ car mi̱ngu̱, göhtjo ʉ́r vida da hmʉh pʉ jár ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nugö, bbʉ gu xojtiquijʉ jár dyɛ quer jmu̱jʉ, nubbʉ́, ntjumʉy xquí hmʉpjʉ libre bbʉ, göhtjo co quir tzi mʉyjʉ, como ʉ́r ttʉgui car mi̱ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ya xtí pa̱cö, nuquɛjʉ, xquí hñe̱jmʉ digue cár cji ca ndor Abraham. Pe nuquɛjʉ, guí ne gui pöjtiguijʉ, como jin guí tzøjmʉ ca dí ma̱. ");
INSERT INTO otsNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nugö, dí xij yʉ cja̱hni ca dú cca̱hti bbʉ ndí bbʉbbe cam Tzi Ta. Hne̱hquiguɛjʉ, guí øtijʉ ca xí xihquijʉ ca hnaa ca ntju̱mʉy ir tajʉ. Jin gui gue ca ndor Abraham dí ma̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bi da̱h cʉ cja̱hni‑cʉ́, bbʉ́: ―¡Ngue! Múr Abraham ca ndo ʉm tagöje.― Cja̱ pé bi xij ya car Jesús: ―Bbʉ dí ba̱jtziquijʉ car Abraham, güi dyøtijʉ ncja ngu̱ nguá dyøti guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nugö xtú xihquijʉ car palabra ca ncjua̱ni. Dú øjcö‑cá̱ bbʉ ndí bbʉbbe cam Tzi Ta, cja̱ nuquɛjʉ, guí mbe̱nijʉ gui pöjtiguijʉ. Nu car Abraham, jí̱ mí pöhtite‑cá̱. ");
INSERT INTO otsNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nuquɛjʉ, guí øtijʉ ncja ngu̱ ga dyøti ca hnaa quer tajʉ.― Ma ya, pé bi da̱h cʉ cja̱hni‑cʉ́: ―Nugöje, jin dí cco‑ba̱jtzije. Hnaatjo cam tagöje i bbʉy, gue ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nubbʉ́, bi da̱h car Jesús: ―Nu bbʉ dir taguɛjʉ ca Ocja̱, nubbʉ́, güi neguigöjʉ, como guegue bú pɛnquigö hua, eso dú e̱je̱. Jin dá mbe̱ntsjɛgö gua e̱je̱. Guegue bú cu̱jqui. ");
INSERT INTO otsNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Dyoca̱ jin guí ntiendejʉ yʉ palabra yʉ dí ma̱ngö? Jin guí ntiendejʉ, como jin guí ne gui hñe̱me̱jʉ, ¿cja cierto nʉ dí ma̱? ");
INSERT INTO otsNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nuquɛjʉ, guí jñɛjmʉ quer tajʉ, ca Jin Gui Jo, cja̱ guí tzøjmʉ ca i ne guegue. Desde bbʉ mí mʉdi mí hmʉj yʉ cja̱hni hua jar jöy, ʉr möhtite guegue. Jin gui ne da dyøh ca ncjua̱ni, cja̱ jin gui ne da dyøte. I ña̱jqui bbɛtjri, como i ma̱n ca i mbe̱ntsjɛ. ʉr mɛtjri guegue cja̱ rí hñe̱ guegue göhtjo cʉ bbɛtjri. ");
INSERT INTO otsNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nugö, dí ma̱ngö ca ncjua̱ni, cja̱ nuquiguɛjʉ jin guí e̱me̱guijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Cja i bbʉy tema cosa drá nttzo xcrú øtigö? Bbʉ te xtú øtigö, gui ma̱nguɛjʉ ya. Cja̱ bbʉ dí ma̱ngö ca ncjua̱ni, ¿dyoca̱ jin guí e̱me̱guijʉ bbʉ́? ");
INSERT INTO otsNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hnar cja̱hni cár ba̱jtzi ca Ocja̱, i øjti ca i ma̱n ca Ocja̱. Pe nuquɛjʉ, jí̱ í ba̱jtziquijʉ ca Ocja̱, eso, jin guí ne gui dyødejʉ ca dí ma̱ngö.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bi da̱h quí jefe cʉ judio, bbʉ, bi hñi̱na̱jʉ: ―Cierto na̱ dí ma̱jme: Nuquɛ, jí̱ ʉ́r ba̱jtziqui ca Ocja̱. Guí ncja ngu̱ cʉ mi̱ngu̱ Samaria, guí yojquɛhui hnar ttzonda̱ji̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nu car Jesús bi da̱di: ―Jin dí yojcöbbe hnar ttzonda̱ji̱. Bbʉ dí nzohquijʉ, dí xihquijʉ ca xí bbɛjpigui cam Tzi Ta, como dí i̱htzibi‑ca̱ cja̱ dí øjti ca i ma̱. Nuquɛjʉ, jin guí ne gui hñi̱zquijʉ, como jin guí e̱me̱jʉ, ¿cja ʉ́r Ttʉguigö‑ca̱? ");
INSERT INTO otsNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nugö, jin dí cja ndumʉy ¿cja da hñi̱zqui yʉ cja̱hni cja huá ji̱na̱? I bbʉh ca hnaa ca i ne pa da tti̱zquigö, gue car Da̱nzöya ca bí mandado pʉ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Dí xihquijʉ ntju̱mʉy, ca to da dɛn car palabra ca dí ma̱ngö, jin da nú̱ car du̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Diguebbʉ ya, pé bi xih cʉ judio: ―Nuya, dí pa̱dije rá zö, guí yojquɛhui hnár nda̱ji̱ ca Jin Gui Jo, cja̱ xcú bbɛh quir mfe̱ni. Bi du̱ car Abraham, cja̱ pé bi du̱ cʉ profeta, masque mí ndo tɛnijʉ ca Ocja̱. Nuquiguɛ, guí ma̱nguɛ: “Car cja̱hni ca da dyøjti cam palabragö, nim pa da zö car du̱.” ");
INSERT INTO otsNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Cja más rá zöqui ni ndra ngue ca ndom taje, car Abraham? Bi du̱‑ca̱, guejti cʉ profeta bi du̱ hne̱je̱, cja̱ nucʉ́, mí ndo tɛn ca Ocja̱. Xiquiguɛ, ¿Toca̱ guí ne gui jñɛjquɛhui bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Bi da̱j ya car Jesús, bi xijmʉ: ―Bbʉ guir ma̱ntsjɛgö, dí pɛhtzi poder, jin di nesta güi hñemeguijʉ. Gue cam Tzi Tagö ca guí xijmʉ ir Cja̱a̱‑guɛjʉ, guegue‑ca̱ xí ddajqui poder, como i ne pa da tti̱zquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nuquiguɛjʉ, jin guí pa̱jmʉ ja i ncja guegue. Pe nugö dí pa̱di ja i ncja, cja̱ bbʉ gua cøni, gua cjagö hnar mɛtjri ncja ngu̱quiguɛjʉ. Nugö dí meya ca Ocja̱ cja̱ dí øtigö ca i ma̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ca ndor Abraham ca guí xijmʉ ir tajʉ, cjuá mí tøhmi cja̱ mí ndo ne di cca̱hti car pa bbʉ gua e̱cö. Cja̱ bbʉ mí ba̱di ndá e̱cö, bi ndo mpöjö göhtjo mbo ʉ́r mʉy.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Diguebbʉ ya pé bi xijmʉ cʉ judio: ―Nim pa guí pɛhtzi cincuenta año. ¿Dyoca̱ guí ma̱nguɛ, gú cca̱hti car Abraham?― ");
INSERT INTO otsNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Bi da̱j ya car Jesús: ―Cierto na̱r palabra na̱ dí xihquijʉ, bbʉ jim be mí bbʉh car Abraham, ya xi ndí bbʉjcö bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Diguebbʉ ya, bi ndo uni ʉr cuɛ cʉ judio cʉ már ña̱hui car Jesús. Bi gʉxjʉ me̱do pa di ccajnijʉ guegue, drí möhtijʉ, por rá ngue nʉr palabra xquí ma̱, como mí ma̱jmʉ, car Jesús mí ne di cjatsjɛ ca Ocja̱. Nu car Jesús bi hui̱ti madé cʉ cja̱hni, bi wem pʉ jar templo, bi ma. ");
INSERT INTO otsNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ca pé hnar pa, car Jesús má pa jar hñu̱, cja̱ bi cca̱hti hnar godö, már ju̱ pʉ hnanguadi car hñu̱. Nucá̱ múr godö desde bbʉ mí hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Quí möxte car Jesús cʉ má yojmi bi dyönijʉ: ―Xijquije tzʉ, Maestro, nʉr hñøjø‑nʉ́, ¿dyoca̱ xí hmʉy ʉr godö? ¿Toca̱ i ndu̱jpite? ¿Cja xtrú dyøte ca rá nttzo guejtsjɛ guegue, cja huá gue cár ta o cár me?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Bi da̱j ya car Jesús, bi hñi̱na̱: ―Jí̱ ʉ́r nttzojqui nʉr hñøjø‑nʉ. Guejtjo jí̱ ʉ́r nttzojqui cár ta co cár me. Exque i ncjanʉ gá hmʉ guegue pa gu xojquibi yí dö, cja̱ da ni̱gui te tza rá nzɛdi car Tzi Ta ji̱tzi ca xpá mɛnquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I nesta gu øti car bbɛfi xí ddajqui cam Tzi Ta menta i cjadi tiempo. Ya xpa e̱h car pa bbʉ ya jin da ncja tiempo. ");
INSERT INTO otsNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Menta dí bbʉjtigö hua jar jöy, dí jñɛbbe car jiahtzi ca i yoti yʉ cja̱hni hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bbʉ mí guadi mí ma̱n car palabra‑ca̱, car Jesús bi zo ʉ́r cji̱jni jar jöy, bi dyøti tzʉ ʉr bøjöy, cja̱ bi gohtzibi quí dö car godö. ");
INSERT INTO otsNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Diguebbʉ ya bi xifi: ―Gui ma bú xʉdö jar tanque ca i tsjifi Siloé.― (Mí bbʉh pʉ hnar pøtje, mí pøxi deje rá ngu̱, mí ñu̱x car tanque.) Nʉr tju̱ju̱ Siloé i ne da ma̱: “Guejna̱ xpá mɛnquijʉ ca Ocja̱.” Car godö ya, bi ma nttzɛdi, bi ma bú xʉjqui quí dö, cja̱ bbʉ mbú coji, ya xquí xoh quí dö. ");
INSERT INTO otsNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Diguebbʉ ya bi ma̱n quí hnangu̱ co ni cʉ pe dda cja̱hni cʉ xquí meyajʉ má̱hmɛto, bi ma̱ntsjɛjʉ: ―¿Cja jin gui gue nʉr hñøjø‑nʉ, mí ju̱jtjo, mí öh cár limosna?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Cʉ ddaa ya, mí ma̱: ―Guejnʉ.― Nu cʉ pe ddaa ya, bi ma̱jmʉ: ―Ncjahmʉ guejnʉ, pe jin gui guegue.― Nu car hñøjø bi ma̱ntsjɛ: ―Guejquigö.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bi dyönijʉ, bbʉ: ―¿Ja ncja xcá xoj yir dö ya bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Cja̱ bi da̱j ya car hñøjø ca múr godö jma̱ja̱: ―Car hñøjø ca i tsjifi ʉr Jesús bi dyøti bøjöy, bi pɛbigui yʉm dö, cja̱ bi xijqui: “Gui ma pʉ jar tanque Siloé, ma bú xʉdö.” Eso, dú ma xʉjqui yʉm dö, cja̱ bi xogui.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Diguebbʉ ya, pé bi dyönijʉ: ―¿Jabʉ i bbʉh car hñøjø‑ca̱?― Cja̱ bi da̱ guegue: ―Jin dí pa̱di.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Diguebbʉ ya bi ttzix car hñøjø ca múr godö jma̱ja̱, gá ma pʉ jabʉ mí bbʉh cʉ fariseo. ");
INSERT INTO otsNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mí nsabado, gue car pa ca mí tzu̱jpi cʉ judio, bbʉ mí dyøti bøjöy car Jesús cja̱ bi xojquibi quí dö car godö. ");
INSERT INTO otsNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nubbʉ́, guejti cʉ fariseo bi dyönijʉ ja bi ncja gá xoh quí dö. Cja̱ bi ma̱n car hñøjø ca múr godö jma̱ja̱: ―Car Jesús bi pɛbigui bøjöy jam dö, ma ya, dú má xʉdö, cja̱ nuya dí janti.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Diguebbʉ ya, bi ma̱n cʉ dda fariseo, bi hñi̱na̱jʉ: ―Jí̱ xcuá hñe̱h ca Ocja̱ car hñøjø‑ca̱, porque jin gui tzu̱jpi nʉr pa gá nttzöya.― Nu cʉ pe dda cja̱hni ya bi ma̱jmʉ: ―Hnar cja̱hni ca di ndu̱jpite, ¿cja di jogui di dyøti milagro ncja ngu̱ ga dyøti guegue?― Cja̱ bi weguejʉ por rá ngue car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nubbʉ, pé bi yojpi bi dyönijʉ car godö: ―Xiquiguɛ, ¿Te guí mbe̱nguɛ digue car hñøjø ca xpá xoquiqui yir dö? ¿Cja xcuá hñe̱h ca Ocja̱ guegue?― Bi da̱h car hñøjø, bbʉ: ―Dí i̱ngö ʉ́r jmandadero ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nu cʉ fariseo‑cʉ jin gá hñemejʉ ¿cja cierto múr godö jma̱ja̱ car hñøjø‑ca̱? hasta bi nzojmʉ cár ta co cár me, ");
INSERT INTO otsNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","cja̱ bi dyönijʉ: ―¿Cja gue nir ttʉhui‑nʉ, guí ma̱jmi múr godö desde bbʉ mí hmʉy? ¿Ja ncja ga cca̱hti ya bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma ya, bi da̱dihui cár ta ʉ́r me, bi ma̱jmi: ―Dí pa̱dibbe, guejnʉ ʉm ttʉgöbbe‑nʉ, múr godö desde bbʉ mí hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cierto, hne̱je̱, ya xqui cca̱hti, pe jin dí pa̱dibbe já xcá ncja. Guejtjo jin dí pa̱dibbe to xí xojquibi yí dö. Guegue ya xí ncja̱hni. Guejtsjɛ guegue gui dyönijʉ ¿ter bɛh ca̱ xí ncja? Guegue xta ma̱ntsjɛ.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bi da̱di ncjapʉ cár ta co cár me, como mí tzu̱hui cʉ hñøjø cʉ mí mandado pʉ jár ni̱cja̱ cʉ judio. Ya xquí ma̱n cʉ möcja̱ cʉ mí mandado, bbʉ to di ma̱, car Jesús múr Cristo ca xquí hñi̱x ca Ocja̱, gueguejʉ di fongui jár templojʉ, cja̱ jin di nu̱ rá zö. ");
INSERT INTO otsNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eso, bi da̱dihui cár ta co cár me: “Ya xí ncja̱hni. Gui dyönijʉ guejtsjɛ guegue ter bɛh ca̱ xí ncja.” ");
INSERT INTO otsNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Diguebbʉ ya, cʉ fariseo pé bi nzojmʉ car hñøjø ca múr godö jma̱ja̱, bi xijmʉ: ―Nuya, gui xijquije göhtjo ca ncjua̱ni, pa da tti̱htzibi car Tzi Ta ji̱tzi. Nugöje dí pa̱dije i ndu̱jpite car hñøjø ca guí ma̱nguɛ xí xoquiqui yir dö. Xiquiguɛ, ¿te guí ma̱nguɛ digue car hñøjø‑ca̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bi da̱j ya car hñøjø, bi hñi̱na̱: ―¿Ja̱di̱? Jin dí pa̱cö ¿cja i ndu̱jpite guegue cja huá ji̱na̱? Guejnʉ́ dí pa̱j‑nʉ́, bbɛto ndúr godö, cja̱ nuya dí cca̱hti. Guejtjo dí pa̱di guegue bi xoguigui yʉm dö.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pé bi yojpi bi dyön cʉ fariseo: ―¿Te xpá cjahqui car hñøjø‑ca̱? ¿Ja xcá xoj yir dö?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Car hñøjø pé bi da̱jti bbʉ: ―Ya xtú xihquijʉ, cja̱ jin guí ne gui dyødejʉ. ¿Te rá nguehca̱ pé guí nejʉ gu yojpi gu xihquijʉ? ¿Cja huá guí ne gui tɛnijʉ car Jesús, hne̱je̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nu cʉ fariseo, bbʉ mí tsjijmʉ ncjanʉ, bi ndo zanijʉ car hñøjø‑ca̱, bi xijmʉ: ―Nuquiguɛ, guí ne gui tɛn car Jesús, pe nugöje, ji̱na̱guigöje. Dí tɛndije ca ndor Moisés. ");
INSERT INTO otsNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dí pa̱dije, ca Ocja̱ bi nzoh ca ndor Moisés cja̱ bi un car ley. Nu car hñøjø ca i tsjifi ʉr Jesús, jin dí pa̱dije jabʉ xcuá hñe̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nubbʉ, bi da̱h car hñøjø: ―¿Dyo ya‑ca̱ jin guí pa̱quɛjʉ jabʉ xcuá hñe̱je̱, cja̱ guegue xí xoguigui yʉm dö?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dí göhtjojʉ dí pa̱dijʉ, bbʉ i ndu̱jpite hnar cja̱hni, ca Ocja̱ jin gui cjajpi ncaso bbʉ te i öjpi. Nu car cja̱hni ca i bbʉy ncja ngu̱ ga tzøh ca Ocja̱ cja̱ i i̱htzibi, bbʉ te i ödi, da ttuni. ");
INSERT INTO otsNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde bbʉ mí mʉj nʉr mundo, nim pa jabʉ xtá ødejʉ cja xtrú xoj yí dö hnar cja̱hni ca múr godö desde bbʉ mí hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu car Jesús, bbʉ jí̱ xtrú mɛjni ca Ocja̱, jin di jogui di xoguigui yʉm dö.― Ncjanʉ gá nda̱h car hñøjø ca múr godö jma̱ja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Cʉ fariseo bi xijmʉ, bbʉ: ―Nuquiguɛ, desde bbʉ ngú hmʉy, guí ndu̱jpite. Jin guí pa̱di ja i ncja ca Ocja̱. Hñi̱x ya, ya xquí ne gui u̱jtiguije.― Nubbʉ, bi fonguijʉ car hñøjø‑ca̱, bi ccahtzijʉ pa ya jin di guati pʉ jár templo cʉ judio. ");
INSERT INTO otsNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Diguebbʉ ya, bi dyøh car Jesús, ya xquí mfongui car hñøjø ca múr godö jma̱ja̱, cja̱ bi ma bú joni. Cja̱ bbʉ mbú ntjɛhui, bi dyöni: ―Nuquɛ, ¿cja guí e̱me̱, ya xí ni̱gui ca hnaa ca di mɛjni car Tzi Ta ji̱tzi hua jar jöy?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bi da̱h car hñøjø, bi hñi̱na̱: ―Xijqui tzʉ, ¿toca̱? pa gu e̱me̱gö.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Cja̱ pé bi ma̱n car Jesús, bbʉ: ―Guejquigö, ya xcú cca̱jtigui, cja̱ pé dí ña̱hui ya.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nubbʉ, bi ma̱n car hñøjø: ―Ja̱a̱, Tzi Jmu̱. Dí e̱me̱qui, guehquiguɛ xpá mɛnqui car Tzi Ta ji̱tzi.― Cja̱ bbʉ mí ma̱ ncjanʉ, bi nda̱ndiña̱jmu̱ pʉ jáy hua car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Cja̱ pé bi ma̱n car Jesús: ―Nugö, xtá e̱jcua jar jöy pa gu jejqui yʉ cja̱hni. Yʉ jin gui cca̱hti, gu xojquibi yí dö pa da cca̱hti. Nu yʉ i ma̱ i cca̱hti rá zö, gu cjajpi da ngodö‑yʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Diguebbʉ ya, cʉ dda fariseo cʉ már bbʉh pʉ, bi dyøj nʉr palabra‑nʉ, cja̱ bi xijmʉ: ―¿Casʉ guír ma̱nguɛ, nugöje dí godöje hne̱je̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Bi da̱j ya car Jesús: ―Bbʉ guir godöjʉ ncja ngʉ nʉ hnaa nʉ xtú xojquibi quí dö, jin guir tu̱jʉ ca rá nttzo bbʉ. Nuquɛjʉ, guí ma̱jmʉ, rá zö guir hmʉpjʉ, pe como jin gui cierto. Guí ncjajʉ ncja ngu̱ yʉ godö hne̱je̱ mbo ir tzi mʉyjʉ, eso, guí tu̱dijʉ ca rá nttzo.― Ncjanʉ gá xijmʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Pé bi ma̱n car Jesús: ―Dí xihquijʉ ntjumʉy, ca to ba e̱ jar gora jabʉ i bbʉh cʉ dɛjti cja̱ jin gui cʉti pʉ jar goxtji, ʉr be̱ car cja̱hni‑ca̱. Ba e̱je̱ pa da zix cʉ dɛjti gá fuerza, cja̱ i pøx pʉ jár cjoti car gora, jí̱ rí ñʉti pʉ jar goxtji. ");
INSERT INTO otsNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pe nu ca to i cʉti jár goxtji, guegue‑ca̱ ʉ́r mödi cʉ dɛjti. ");
INSERT INTO otsNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bbʉ ba e̱h car mödi, car portero i meya, cja̱ i xojquibi car goxtji. Cʉ dɛjti i øjtibi cár jña̱ car mödi. Diguebbʉ ya car mödi i nømbi cada hnaa cár tju̱ju̱ cʉ dɛjti, cja̱ ba pøh‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cja̱ bbʉ ya xtúr ngʉjqui göhtjo quí dɛjti, car mödi ya xta hmɛto, cja̱ cʉ dɛjti xta dɛndi ʉ́r xʉtja, como i meyabi cár jña̱. ");
INSERT INTO otsNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pe jin gui tɛnijʉ hnahño cja̱hni ca jí̱ ʉ́r mödi. I ddaguijʉ, porque jin gui meyabijʉ cár jña̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Car Jesús bi xih cʉ cja̱hni nʉr palabra‑nʉ́ digue car mödi co cʉ dɛjti pa di ba̱dijʉ ja mí ncja guegue. Nu cʉ cja̱hni jin gá ntiendejʉ ter bɛh ca̱ mí ne di ma̱. ");
INSERT INTO otsNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Diguebbʉ ya, car Jesús pé bi xih cʉ cja̱hni pé hnar vez, i̱na̱: ―Cierto na̱r palabra na̱ dí xihquijʉ. Guejquigö dúr goxtji pa da ñʉti cʉ dɛjti. ");
INSERT INTO otsNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Göhtjo cʉ cja̱hni cʉ xpá hñe̱je̱ ncjahmʉ mödi, bbʉ jí̱ bbe ndá e̱cö, mí be̱‑cʉ, mí ne di zix cʉ dɛjti gá fuerza. Nu cʉ dɛjti jin gá cjajpi ncaso‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nugö dí jñɛbbe hnar goxtji pa da ñʉti cʉ dɛjti jar gora. Ca to da guajqui pa da ñʉti car gora, gu un car nzajqui ca jin da tjegue. Car cja̱hni‑ca̱ da hño libre. Da bøni pa da döti te da zi, cja̱ pé da ñʉti jar gora pa da tzöya pʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","¿Te rí hñe̱h cʉ be̱? Nucʉ́ ba e̱je̱ pa da zix cʉ dɛjti, da jio, cja̱ da möhti. Pe nugö xtú e̱cö pa gu un í nzajqui yʉm tzi dɛti, pa da hmʉy rá zö cja̱ jin te da bbɛtibijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Dí jñɛbbe hnar mödi i nu̱ rá zö quí dɛjti. Nugö gu dö cam vida pa jin da ttzingui cʉm dɛjti. ");
INSERT INTO otsNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nu car ttömödi, ca jí̱ ʉ́r jmu̱ cʉ dɛjti, bbʉ ga jianti ya xpa e̱h car lobo, i jɛjti cʉ dɛjti, i ddajtjo. Car lobo ya, ba fonti cʉ dɛjti cja̱ ba tzʉh cʉ ddaa. ");
INSERT INTO otsNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Car ttömödi i jɛh cʉ dɛjti da du̱x car lobo, como jí̱ í mɛjti‑cʉ, jøña̱ car domi i ne. ");
INSERT INTO otsNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nugö dúr jogui mödi. Dí mpa̱bbe cʉm dɛjti. ");
INSERT INTO otsNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ncja ngu̱ dar mpa̱bbe cam Tzi Ta, ncjapʉ hne̱je̱ ngu̱ dar mpa̱bbe cʉm dɛjti. Gu dö cam vida pa da mɛhtzi í nzajqui cʉm dɛjti. ");
INSERT INTO otsNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Guejtjo pé i bbʉh cʉ ddam dɛjti cʉ jí̱ bbe i cʉti nʉr gora nʉ dí xihquijʉ. Guejti‑cʉ, dí ne gu ma tziji hne̱je̱. Cʉ dɛjti‑cʉ, da dyøh bbʉ xtá nzofo. Ncjapʉ gu cuajti göhtjo cʉm dɛjti, pa da hnaadi cam partida, cja̱ nugö gu födi göhtjo‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","I negui cam Tzi Ta, porque gu dö nʉm vida, gu tu̱, cja̱ pé gu jña̱ ʉm jña̱, pé gu hmʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jin to da jña̱gui nʉm vida bbʉ jin gu jñɛgui. Guejquitsjɛgö gu dö cam vida. Dí pɛhtzigö poder gu dötsjɛ cam vida. Guejtjo dí pɛhtzi poder pa pé gu jña̱ ʉm jña̱. Guejnʉ́ xí xijqui cam Tzi Ta, i nesta gu tu̱, cja̱ pé gu jña̱ ʉm jña̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nu quí jefe cʉ judio, bbʉ mí dyøj yʉ palabra‑yʉ, pé bi ntøxtijʉ cja̱ bi weguejʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Cʉ ddáa már ngu̱ bi ma̱jmʉ: ―Nʉr Jesús i yojmi hnar ttzonda̱ji̱. Xí bbɛh cár mfe̱ni. ¿Dyoca̱ guí øjmʉ ca i ma̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nu cʉ pé ddaa bi ma̱jmʉ: ―Ji̱na̱. Bbʉ to di yojmi hnar nda̱ji̱ drá nttzo, jin di ña̱ ncja ngu̱ ga ña̱ car Jesús. Guejtjo jin di jogui di xojquibi quí dö hnar godö.― ");
INSERT INTO otsNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Diguebbʉ ya, bi tzo car mbaxcjua bbʉ mí mbe̱n cʉ judio car pa ca xquí ndedica car ndo templo pʉ Jerusalén. Múr tiempo bbʉ mí jøh cʉ tzɛ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nu car Jesús már bbʉh pʉ jar templo pʉ Jerusalén. Má dyo pʉ jar portal ca i tsjifi ʉ́r portal car Salomón. ");
INSERT INTO otsNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Cja̱ bi guati cʉ dda quí jefe cʉ judio, bi hñi̱tjʉ madé car Jesús, bi dyönijʉ: ―¿Hasta ncjahmʉ gui cjaguije gu yomfe̱nije? Bbʉ guehquiguɛ gúr Cristo, bbʉ xtrú hñi̱xqui ca Ocja̱ pa gui mandadoguije, ex xca xijquije rá zö ya, pa gu pa̱dije.― ");
INSERT INTO otsNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Bi da̱j ya car Jesús: ―Ya xtú xihquijʉ, pe jin guí e̱me̱jʉ. Cam Tzi Ta xí hñi̱zquigö, xí ddajqui cam ttzɛdi pa gu øti milagro. Por rá ngue yʉ dí øte, i fa̱di toguigö. ");
INSERT INTO otsNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nuquɛjʉ, jin guí e̱me̱jʉ ca dí xihquijʉ, como jin gʉm dɛjtiquigöjʉ. Ya xtú xihquijʉ ma̱hmɛto, te rá nguehca̱ jin guí e̱me̱guijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Cʉ cja̱hni cʉm dɛjtigö i øh bbʉ dí nzofo. Dí meyagö‑cʉ, cja̱ i tɛngui. ");
INSERT INTO otsNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dí un car nzajqui ca jin da tjegue. Ni jabʉ da bbɛdijʉ. Dí pɛhtzi rá zö jam dyɛgö‑cʉ, cja̱ jin to da zingui. ");
INSERT INTO otsNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Gue cam Tzi Ta xí ddajqui cʉm dɛjti. Guegue göhtjo i mandado, rá ndo nzɛdi, cja̱ jin to da da̱pi pa da zimbi cʉm tzi dɛti. Nucʉ, i bbʉ ʉ́r dyɛ guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nugö co cam Tzi Ta, hnaadi cam hmʉygöbbe, hnaadi cam mfe̱nibbe. Dí bbʉbbe göhtjo ʉr tiempo.― ");
INSERT INTO otsNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bbʉ mí dyøjmʉ nʉr palabra‑nʉ, quí jefe cʉ judio pé bi gʉxjʉ me̱do pa di ccajnijʉ car Jesús, dír möhtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Diguebbʉ ya car Jesús bi xijmʉ: ―Rá ngu̱ vez xtú föx yʉ cja̱hni, xtú øti milagro co ni cár ttzɛdi cam Tzi Ta. Nuquɛjʉ, gú cca̱htijʉ cʉ milagro‑cʉ́ hne̱je̱. ¿Ter bɛh ca̱ xtú øtigö pa drí ntzöhui gui ccanquigöjʉ doo?― ");
INSERT INTO otsNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bi da̱j ya cʉ judio, bi hñi̱na̱jʉ: ―Cierto, dí ne gu ccanquije, pe jí̱ rá ngue cʉ xcú dyøhtibi yʉ cja̱hni. Guehca̱ guír ne gui cjatsjɛ ca Ocja̱, siendo gúr cja̱hnitjojo.― ");
INSERT INTO otsNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Bi da̱j ya car Jesús, bi xijmʉ: ―I bbʉh ca hnar tzi palabra i ju̱x pʉ jar ley ca guí nxödijʉ, guehpʉ jabʉ i ña̱ digue cʉ nzöya. I ma̱ ncjahua: “Nuquiguɛjʉ, guí jñɛjmʉ cjá̱a̱.” ");
INSERT INTO otsNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jin gui tzö gu ma̱jmʉ jin gui cierto ca i ma̱n cʉ Escritura, como nucʉ́, rí hñe̱h ca Ocja̱. Guehpʉ ja Escritura i tjɛquihui ca Ocja̱ cʉ nzöya. I tsjifi ncjanʉ, como xquí ttun cʉ nzöya cár ley ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Cja̱ nugö, xí hñi̱xquigö car Tzi Ta ji̱tzi cja̱ xpá mɛnqui hua jar mundo pa gu øhtibi cár bbɛfi. ¿Dyoca̱ guí i̱na̱jʉ, rá nttzo na̱r palabra na̱ xtú ma̱, ca xtá xihquijʉ, ʉ́r Ttʉguigö ca Ocja̱? ");
INSERT INTO otsNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bbʉ jí̱ xtrú hñe̱h cam Tzi Ta ji̱tzi göhtjo yʉ dí øte, nubbʉ́, di jogui güi ma̱jmʉ, jí̱ xcuá mɛnquigö guegue hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pe göhtjo yʉ dí øtigö, rí hñe̱ guegue, como dí yobbe cár ttzɛdi ca Ocja̱. Eso, rí ntzöhui gui hñemeguijʉ por rá ngue yʉ milagro yʉ dí øte, macja̱ jin guí ne gui hñemejʉ ya palabra ya dí xihquijʉ. Por rá ngue yʉ dí øte, da jogui gui pa̱dijʉ, cierto dí yobbe cam Tzi Ta ji̱tzi, hnaadi cam bbɛfibbe.― Ncjanʉ gá ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Diguebbʉ ya, quí jefe cʉ judio pé bi yojpi bi ntoja di zɛtijʉ car Jesús pa di gotijʉ. Nu guegue bi hui̱ti madé cʉ cja̱hni, bi ma. ");
INSERT INTO otsNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma ya, car Jesús pé bi ma gá ddax ca hnanguadi car da̱tje Jordán, pʉ jabʉ rí bøx car jiadi. Bú hmʉjti pʉ jabʉ xquí hmʉh car Juan má̱hmɛto, bbʉ mí xix cʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cja̱ mbá cuatijʉ car Jesús rá ngu̱ cja̱hni, mí ma̱jmʉ: ―Jí̱ mí øti milagro car Juan, pe nde̱jma̱ mí xijquijʉ ja di ncja nʉr Jesús. Mí cierto göhtjo ca mí xijquijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Cja̱ már ngu̱ cʉ cja̱hni cʉ bi hñe̱me̱jʉ, car Jesús mí gue cár jmandadero ca Ocja̱ ca mí ddøhmi. ");
INSERT INTO otsNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mí bbʉh ca hnar hñøjø, mí ju̱ cár tju̱ju̱ múr Lázaro. Múr mi̱ngu̱ hnar tzi jñini ca mí tsjifi Betania. Car Lázaro mí bbʉh pʉ co ni quí ncju̱, car María hne̱h car Marta. Cja̱ bi jñin car Lázaro. ");
INSERT INTO otsNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Car María, cár ncju̱ car Lázaro, guegue xquí xihtzibi perfume jáy hua car Tzi Tada Jesús, cja̱ xquí du̱jquibi co ni quí xta̱. ");
INSERT INTO otsNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bbʉ mí jñin car Lázaro, cʉ yojo quí ncju̱ bú pɛjnihui ʉr jña̱ pʉ jabʉ már bbʉh car Jesús, bi xijmi: ―Nuquɛ, ʉm Tzi Jmu̱quije, i jñin quer amigo, car Lázaro.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bbʉ mí dyøj ya‑ca̱, bi ma̱n car Jesús: ―Jin da du̱ car jñini ca i tzöhui. Nu ca da ncja, da ni̱gui te tza rá nzɛh ca Ocja̱. Guejtjo da ni̱gui te tza rá nzɛjquigö, ʉ́r Ttʉgui ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Car Jesús mí ndo ma̱h car Marta cja̱ co cár cju̱juɛ, co hne̱h car Lázaro. ");
INSERT INTO otsNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pe bbʉ mí dyøde, ya xi mí jñin car Lázaro, nde̱jma̱ pé bú dedi yojpa pʉ jabʉ már bbʉy. ");
INSERT INTO otsNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cja̱ bbʉ xquí tjoh cʉ yojpa‑cʉ, car Jesús bi xih quí amigo cʉ mí ntzixihui: ―Nuya, pé gu möjö, gár möh pʉ Judea.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bi da̱j ya quí amigo, bi xijmʉ: ―Nuquɛ, Maestro, jin tza bbe i cja mpa bbʉ mí ne di möjtiqui gá doo cʉ dda judio rá bbʉh pʉ Judea. ¿Dyoca̱ pé guí ne gui maguɛ pʉ ya?― ");
INSERT INTO otsNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nu car Jesús bi da̱di: ―Nde̱jma̱ dí ne gu ma pʉ. ¿Cja jin gui pɛhtzi doce hora hnajpa? Pa guejcö, mpatjo. Bbʉ i dyo bbʉ mpa hnar cja̱hni, jin da mfehtze. I dyo rá zö, porque i ni̱guitjo, jí̱ bbe i hmɛxu̱y. ");
INSERT INTO otsNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pe bbʉ to da hño bbʉ nxu̱y, da fʉntzi, porque jin gui cca̱hti jabʉ rí ma. Nugö dí ncja ngu̱ hnar cja̱hni i dyo bbʉ mpa, porque jí̱ bbe i tzʉh car hora ca xí ma̱n cam Tzi Ta ji̱tzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Diguebbʉ ya, car Jesús bi xih quí möxte: ―Ya xí a̱h cam amigojʉ, car Lázaro, pe nugö gu má dyö.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Cja̱ quí möxte bi da̱dijʉ bbʉ, bi hñi̱mbijʉ: ―Nuquɛ, Tzi Ta, bbʉ i a̱jtjo, pé ntoja da zö bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Car Jesús mí ne di ma̱, ya xquí du̱ car Lázaro. Nu quí möxte mí mbe̱nijʉ ncjahmʉ mí a̱jtjo. ");
INSERT INTO otsNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nubbʉ, car Jesús bi xijmʉ clarotjojo: ―Ya xí ndu̱ car Lázaro. ");
INSERT INTO otsNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dí mpöjcö ca jí̱ xtá hmʉh pʉ ca xcá ndu̱. Como nuya, rá zö grí hñemeguijʉ por rá ngue ca xquí cca̱htijʉ. Nuya, möj ya, gu ma grí cca̱htijʉ car Lázaro.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Diguebbʉ ya ca hnaa quí möxte car Jesús ca mí tsjifi ʉr cuate, gue car Tomás, bi xih cʉ pe ddáa: ―Pe ntoja ya xta bböhti nʉr Jesús. Pe gu möj ya, pa ddáa gár tu̱göjʉ, dí göhtjojʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bbʉ mí zøti pʉ Betania, car Jesús bi dyøde, ya xquí zʉ go mpa ca xquí nttöh car Lázaro. ");
INSERT INTO otsNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Car Betania co car Jerusalén mí jñajquihui como yo quilómetro madé. ");
INSERT INTO otsNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ya xquí guatijʉ pʉ jár ngu̱ car Marta co car María rá ngu̱ quí amigohui. Göhtjo mí judiojʉ. Cʉ amigo‑cʉ, már ju̱htibi í mʉyhui cʉ yojo bbɛjña̱, como xquí du̱ cár i̱da̱hui. ");
INSERT INTO otsNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nu car Marta, bbʉ mí dyøde, ya xti zøh car Jesús, bi bøna nttzɛdi, bi ma bú ntjɛhui. ");
INSERT INTO otsNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Cja̱ guegue bi xih car Jesús: ―Nuquɛ, ʉm Tzi Jmu̱quije, bbʉ güi hmʉjquɛ hua, jin di du̱ cam hñohui. ");
INSERT INTO otsNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pe guejtjo dí pa̱di, göhtjo ca gui dyöjpi car Tzi Ta ji̱tzi, da dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Car Jesús bi xih car Marta, bbʉ: ―Pé xta jña̱ ʉ́r jña̱ quer hñohui, xta nantzi.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Diguebbʉ ya, pé bi ma̱n car Marta: ―Ja̱a̱, ya xtí pa̱di, ba e̱h car pa bbʉ xta jña̱ ʉ́r jña̱, gue bbʉ xta nantzi cʉ ánima cja̱ xta ncja car juicio.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nu car Jesús pé bi xifi: ―Guejquigö gu xox cʉ ánima, gu cjajpi da jña̱ ʉ́r jña̱ cʉ cja̱hni cʉ xí ndu̱. Cʉ cja̱hni cʉ mí e̱me̱gui bbʉ mí bbʉjtijʉ, masque ya xí ndu̱, pé da jña̱ ʉ́r jña̱‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Cja̱ nu ca to i cjadi ʉ́r nzajqui, bbʉ da hñemegui, masque da du̱ cár cuerpo, da ttun car nzajqui ca jin da tjegue. Xiquiguɛ, ¿cja guí e̱me̱‑na̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Bi da̱j ya car Marta, i̱na̱: ―Ja̱a̱, Tzi Ta, nugö dí e̱me̱, guehquɛ gúr Cristo, xí hñi̱xqui car Tzi Ta ji̱tzi, ʉ́r Tzi Ttʉqui ca Ocja̱. Guehquiguɛ ndí tøpiquije güi hñe̱cua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ncjanʉ gá nda̱h car Marta, cja̱ diguebbʉ ya bi ma bú nzoh cár cju̱juɛ, bi cjontibitjo, i̱na̱: ―Ya xí nzøh cam Maestrojʉ, bí bböh pʉ, bí nzohqui.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nu car María, bbʉ mí dyøj ya ca̱, bi ma nttzɛdi, bi ma bú ntjɛhui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Car Jesús jí̱ bbe mí cʉti pʉ jar jñi̱ni. Már tøhmitjo pʉ jabʉ xcuí ntjɛhui car Marta. ");
INSERT INTO otsNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nu quí amigo car María co car Marta már bbʉh pʉ jár ngu̱hui, már ju̱htibijʉ ʉ́r mʉy car María. Cja̱ bbʉ mí bøna nttzɛdi car María, bi mbe̱n quí amigo, má̱s ya xi mír ma jar lugar pʉ jabʉ xquí ttöh car Lázaro, mír má du nzom pʉ, eso bi dɛnijʉ gá möjmʉ pʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Cja̱ car María, bbʉ mí zøn nʉ jabʉ már bbʉh car Jesús, bi nda̱ndiña̱jmu̱ jáy hua, bi xifi: ―Nuquɛ, ʉm Tzi Jmu̱quije, bbʉ güi hmʉjquɛ hua, jin di du̱ cam i̱da̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nu car Jesús, bbʉ mí cca̱hti már zon car María cja̱ co cʉ judio cʉ xquí dɛnijʉ, nubbʉ bi ndo ungui du̱mʉy, bi ntzøte. ");
INSERT INTO otsNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Diguebbʉ bi dyöni: ―¿Jabʉ guehpʉ xcú dyöh quer ánimajʉ?― Cja̱ bi da̱dijʉ: ―Bú e̱quɛ gui cca̱htitsjɛ tzʉ, Tzi Ta.― Cja̱ bi guati pʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nubbʉ, bi nzon car Jesús hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Cʉ ddaa cʉ judio bi ma̱jmʉ, bbʉ: ―¡Te tza ngu̱ mí ne car Lázaro!― ");
INSERT INTO otsNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Guejtjo mí bbʉh pʉ cʉ ddáa cʉ bi ma̱jmʉ: ―Gue nʉr hñøjø‑nʉ bi xojquibi quí dö hnar godö. ¿Cja jin di jogui di ccax car Lázaro pa jin di du̱ hne̱je̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Diguebbʉ ya, pé bi ndo ntzøti car Jesús, bi ma gá nguati car lugar pʉ jabʉ xquí ttöh car ánima. Múr cueva‑cá̱, xquí cjoti cár goxtji co hnar ndo me̱do. ");
INSERT INTO otsNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nubbʉ, bi ma̱n car Jesús: ―Gui cjʉhtzijʉ ya nʉr me̱do, dír ma hnanguadi.― Nu car Marta, cár ncju̱ car ánima, bi xifi: ―Nuquɛ, Tzi Ta, ya xí cja go mpa ca xcá ndu̱. Pé ya xí xa̱gui.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nu car Jesús bi da̱jti: ―Gui mbe̱nguɛ tzʉ ca xtú xihqui, bbʉ gui hñe̱me̱gui, xtí cca̱hti te tza rá nzɛh ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Diguebbʉ ya bi gʉhtzijʉ car doo. Ma ya car Jesús bi nøhtzi jar ji̱tzi, bi nzoh ca Ocja̱, bi ma̱: ―ʉm Tzi Taqui, cjama̱di quer tzi jma̱jte, xcú dyøh ca xtú öhqui. ");
INSERT INTO otsNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Dí pa̱di, cada bbʉ dí nzohqui, guí øjtigui. Pe xtú xihqui na̱r palabra‑na̱ pa da dyøj yʉ cja̱hni rá ngu̱ yʉ i bbʉjcua, cja̱ pa da hñemejʉ, guehquiguɛ xcú pɛnqui hua jar jöy.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mí guaj ya mí ma̱n yʉ palabra‑yʉ, cja̱ bi nzoh car Lázaro, bi mahti nzajqui, i̱na̱: ―Nuquɛ, Lázaro, bú pøj ya.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Diguebbʉ, bi bøn car ánima, mí bbantitjo cʉ da̱jtu̱ jáy hua co jáy dyɛ. Guejtjo mí hnu̱hti cár ña̱ co pe hnar da̱jtu̱. Cja̱ car Jesús ya bi xih cʉ cja̱hni: ―Nuya, gui xohtibijʉ yʉ da̱jtu̱, gui jiɛguijʉ da hño libre.― Cja̱ bi cjajpijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Már ndo ngu̱ cʉ judio cʉ már tɛnijʉ car María bbʉ mí jña̱ ʉ́r jña̱ car Lázaro. Por rá nguehca̱ gá cca̱htijʉ ter bɛh ca̱ bi ncja, bi hñemejʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nu cʉ dda quí jefe cʉ judio bi ma bú ña̱hui cʉ fariseo, bi xijmʉ te xquí dyøti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Diguebbʉ ya, bi jmu̱ntzijʉ cʉ jefe cʉ mí mandadobi cʉ möcja̱ cja̱ co cʉ fariseo, bi dyøtijʉ hnar junta, bi nzojmʉ hne̱je̱ cʉ pé dda tita cʉ mí ja̱ ʉ́r cargojʉ. Már bbʉh pʉ göhtjo cʉ jefe cʉ mí ntjumʉy, cja̱ bi ña̱jʉ digue car Jesús. Bi ma̱jmʉ: ―¿Ja gu cjajpijʉ car hñøjø‑ca̱? I ndo øti rá ngu̱ milagro. ");
INSERT INTO otsNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bbʉ gu jɛguijʉ da ncjadinʉ, nubbʉ́, göhtjo da hñeme yʉ cja̱hni cja̱ da hñi̱xjʉ gá rey. Nubbʉ, du e̱h cʉ autoridad romano, da yøhti cam templojʉ cja̱ da jña̱ngui cam cargojʉ. Guejtjo da möhti rá ngu̱ yʉm cja̱hnijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Diguebbʉ ya, ca hnar hñøjø ca múr da̱möcja̱, bi ña̱ hne̱je̱. Mí ju̱ cár tju̱ju̱ múr Caifás. Car cjeya‑ca̱, guegue mí ja̱ cár cargo ga da̱möcja̱, mí mandadobi cʉ pe dda möcja̱. Nʉr Caifás bi xih cʉ pé ddáa, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","―Nuquɛjʉ, jin te guí pa̱dijʉ, jin guí ntzohmijʉ ja gu ncjajʉ pa jin da mpun cam naciónjʉ. Nugö, dí i̱na̱, más bí conveni da du̱ ca hnaatjo ʉr hñøjø, cja̱ jin gu nesta gu tu̱jʉ, dí göhtjojʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nʉr palabra nʉ bi ma̱n car Caifás, jin guá hñe̱je̱ digue cár mfe̱nitsjɛ, nu ca Ocja̱ bi un car palabra‑ca̱. Como car Caifás múr da̱möcja̱, cja̱ mí pɛhtzi cár cargo car cjeya‑ca̱, ca Ocja̱ bi cjajpi bi ma̱ ja dír du̱ car Jesús pa jin di bbɛdi göhtjo cʉ cja̱hni judio. ");
INSERT INTO otsNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bbʉ mí du̱ car Jesús, cierto bi möx cʉ cja̱hni cʉ mí judio, pe jin gui jøña̱‑cʉ. Guejtjo bi mötzi göhtjo quí cja̱hni ca Ocja̱, cja̱ nucʉ́, mí bbʉpjʉ göhtjo cʉ pé dda nación hua jar mundo. Mí hua̱nihui cʉ pe dda cja̱hni cʉ jin gui e̱me̱. Bi du̱ car Jesús por rá ngue göhtjo cʉ to di hñeme, cja̱ bi pɛjni göhtjo‑cʉ, pa bi cjajʉ ʉ́r familia ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nubbʉ, desde car pa bbʉ mí ma̱n car da̱möcja̱, mí conveni pa di du̱ car Jesús cja̱ jin di du̱ cʉ pe dda cja̱hni rá ngu̱, cʉ möcja̱ cʉ mí mandado mí jonijʉ ja dír möhtijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eso, bi wem pʉ Jerusalén car Jesús. Ya jin guá hño pʉ jabʉ mí bbʉh cʉ jefe cʉ mí mandadobi cʉ judio. Bi bøm pʉ jar estado Judea, bi ma gá ma pʉ hnar tzi jñini ca mí tsjifi Efraín. Nuca̱, mí bbʉ jár nttza̱ni car desierto, pʉ jabʉ jin tza mí bbʉ cja̱hni rá ngu̱. Car Jesús bú hmʉjti pʉ co ni quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mí bbɛh tzʉ pa di tzo cár mbaxcjua cʉ judio ca mí tsjifi ʉr Pascua. Már ngu̱ cʉ cja̱hni ya xi mír möjmʉ pʉ Jerusalén pa di jñojquijʉ ante que di ncja car mbaxcjua. Mí nxajmʉ ncja ngu̱ mír ma̱n cár ley gueguejʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Cʉ cja̱hni cʉ xquí möjmʉ pʉ Jerusalén pa di zöjʉ car mbaxcjua, mí dyo mí jonijʉ car Jesús. Cja̱ bbʉ már bbʉpjʉ pʉ jar templo, mí hñöntsjɛjʉ, mí ma̱jmʉ: ―¿Te guí mbe̱nguɛjʉ? ¿Cja du e̱h car Jesús hua jar mbaxcjua, o jin du e̱je̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Como cʉ fariseo co hne̱h cʉ jefe cʉ mí mandadobi cʉ möcja̱, ya xquí unijʉ car orden, bbʉ to di ba̱di jabʉ már bbʉh car Jesús, di ma du ngöxte pa di ttzʉdi cja̱ di cjoti födi. ");
INSERT INTO otsNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bbʉ mí bbɛjti ddajto mpa pa di tzo car mbaxcjua, car Jesús bi ma pʉ jar tzi jñini Betania, pʉ jabʉ mí bbʉh car Lázaro. Guegue‑ca̱ xquí du̱, cja̱ car Jesús, pé xquí xotzi. ");
INSERT INTO otsNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pʉ jár ngu̱jʉ car Lázaro co cʉ yojo quí ncju̱, bi ttøhtibi car Jesús hnar jñu̱ni. Car Marta bi dö car jñu̱ni. Nu car Lázaro már ju̱bi cʉ pe dda cja̱hni pʉ jar mexa, már tzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Diguebbʉ ya bi ñʉti car María, mbá tu̱ madé litro ʉr perfume ca mí tsjifi ʉr nardo, már ndo ma̱di. Bi xihtzibi quí hua car Jesús, cja̱ bi du̱jquibi quí hua co ni quí xta̱. Cja̱ car ngu̱ ya bi ndʉ cár jña̱ car perfume. ");
INSERT INTO otsNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Már bbʉh pʉ hne̱je̱ ca hnaa quí möxte car Jesús ca mí tsjifi Judas Iscariote, cár ttʉ car Simón. Guegue di dö car Jesús. Bi ma̱n car Judas, i̱na̱: ");
INSERT INTO otsNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Dyoca̱ xí mfön nʉr perfume‑nʉ? Di jogui di bbö por jñu̱ ciento ʉr domi, cja̱ di tjejquibi cʉ tzi probe.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Car Judas bi ma̱ nʉr palabra‑nʉ ncjahmʉ de vera mí jui̱jqui cʉ probe, hne̱ jí̱ mí jui̱jqui. Jøntjo gá ma̱ntjo, como guegue mí tu̱ car ddøza̱ pʉ jabʉ mí ttʉti car domi, cja̱ mí ja̱jqui hna parte car domi, mí pe̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nu car Jesús bi ma̱: ―Dyo te guí xij nʉr bbɛjña̱. Rá zö nʉ xí dyøjtigui. Guegue xí mɛhtzi nʉr perfume pa di xizqui car pa bbʉ xtá hñöjcö, cja̱ exque xí xizqui ya. ");
INSERT INTO otsNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Göhtjo ʉr tiempo da hmʉj yʉ tzi probe pa gui föxjʉ‑yʉ, pe nugö, jin gui göhtjo ʉr tiempo gu hmʉpjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Rá ndo ngu̱ cʉ judio bi dyødejʉ, már bbʉh pʉ Betania car Jesús, cja̱ bi hñɛjʉ bi möjmʉ pʉ, jin gui jøntsjɛ pa di cca̱htijʉ car Jesús, pe guejti car Lázaro, como car Jesús xquí cjajpi xquí jña̱ ʉ́r jña̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Por rá nguehca̱, quí jefe cʉ möcja̱ bi mbe̱nijʉ di möhtijʉ car Lázaro hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Como guehca̱ gá jña̱ ʉ́r jña̱ car Lázaro, ya jin tza mí ddɛn cʉ möcja̱ cʉ mí pɛhtzi cár cargojʉ. Már ngu̱ cʉ cja̱hni, ya xi mí tɛnijʉ car Jesús cja̱ mí e̱me̱jʉ guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Már ndo ngu̱ cja̱hni xquí möjmʉ Jerusalén pa di zöjʉ car mbaxcjua ca ya xti ncja pʉ. Cʉ ddaa cja̱hni‑cʉ́, bi möjmʉ pʉ Betania, bi ma bú cca̱htijʉ car Jesús cja̱ co car Lázaro, cja̱ pé bú cojmʉ pʉ Jerusalén. Diguebbʉ ya, ca rá yojpa, bi dyøh cʉ cja̱hni cʉ már bbʉh pʉ Jerusalén, ya xti zøm pʉ car Jesús hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nubbʉ́, bi bønijʉ du tja̱jmʉ car Jesús, cja̱ bú tʉjquijʉ quí xi cʉ dɛntji, mí pøjmʉ pʉ jar hñu̱ pʉ jabʉ mbá e̱h car Jesús. Guejtjo mí ndo majmʉ nzajqui, mí i̱na̱jʉ: ―Dí xöjtibijʉ car Tzi Ta ji̱tzi. Guegue da bendecibi nʉr hñøjø nʉ ba e̱je̱, como xpá mɛjni cja̱ xí un cár ttzɛdi. ʉm reygöjʉ‑nʉ, nugöjʉ dí cja̱hni israelitajʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Car Jesús ya bi döti hnar tzi burrotjo, cja̱ bi tøgue. Ncjapʉ gá nzʉh car palabra ca i ma̱m pʉ jar Escritura: ");
INSERT INTO otsNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Dyo guí ntzu̱jʉ, guí mi̱ngu̱jʉ Jerusalén, Jiantijma̱jʉ, ya xpa e̱j nir reyjʉ, ba tøh hnar tzi burrotjo. ");
INSERT INTO otsNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jin te gá mbe̱n quí möxte car Jesús car hora ca má cʉti pʉ Jerusalén ncja ngu̱ hnar rey, má tøh car tzi burrotjo. Hasta guehpʉ mí ttzi̱x car Jesús pʉ ji̱tzi, nubbʉ, bi mbe̱nijʉ cja̱ bi ba̱dijʉ, por rá ngue ca xquí ncja, xquí zʉdi ncja ngu̱ ga ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Cʉ cja̱hni cʉ mí yojmʉ car Jesús bbʉ mí xox car Lázaro, bi ndo ngöxtejʉ, bi xih cʉ pe dda cja̱hni te xcuí cca̱htijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eso, bi bøm pʉ Jerusalén cʉ pe dda cja̱hni rá ngu̱, bi ma bú ntjɛjʉ car Jesús, como xquí dyødejʉ, guegue‑ca̱ xquí xoxi hnar ánima. ");
INSERT INTO otsNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nubbʉ́, más mí ndo ntzøtijʉ cʉ fariseo. Mí ña̱tsjɛjʉ, mí ma̱jmʉ: ―Jiantijma̱jʉ, ¿ja gu ncjajʉ ya? Göhtjo yʉ cja̱hni i tɛnijʉ guegue.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cʉ cja̱hni israelita cʉ xquí ma pʉ Jerusalén, xquí möjmʉ car mbaxcjua pa di nda̱nejʉ ca Ocja̱. Guejtjo mí yojmʉ cʉ dda griego. ");
INSERT INTO otsNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Cʉ cja̱hni‑cʉ bi guatijʉ ca hnár möxte car Jesús ca mí ju̱ cár tju̱ju̱ múr Felipe. Guegue car Felipe múr mi̱ngu̱ car jñini Betsaida, pʉ jar estado Galilea. Nu cʉ griego bi dyöjpi ʉr tsjɛjqui car Felipe pa di cca̱htijʉ car Jesús, bi hñi̱mbijʉ: ―Nuquɛ, tada, dí neje gu cca̱htije tzʉ car Jesús, pa gu ña̱je.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Diguebbʉ ya car Felipe bi ma bú xih car Andrés, cja̱ gueguehui ya, bi mɛhui bú xijmi car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nu car Jesús bi xih quí möxte: ―Ya xí nzøh car hora ca mí nesta di ncja. Nugö dúr cja̱hni xpá bbɛnqui hua jar jöy. Por rá ngue ca xta ncja, da ni̱gui, i ndo i̱zqui cam Tzi Ta. ");
INSERT INTO otsNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Dyøjma̱jʉ na̱ gu xihquijʉ. Nugö dí jñɛbbe hnar ttɛy. Bbʉ da bboni jar jöy hnar ttɛy, da mbödi, cja̱ pé da føtze, da te. Nubbʉ, pé da ndo nxa̱nti rá ngu. Pe bbʉ da bbɛhtzitjo cja̱ jin da bboni, segue da hnaadi car ttɛy, jin jabʉ drí ngu̱jqui, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ca to i föh cár vida hua jar mundo, eso, jin gui ne da dɛngui, nde̱jma̱ da bbɛh cár vida. Nu ca to jin gui jiøjqui cár vida hua jar mundo, pe i ungui ʉ́r mʉy da dɛngui, masque da ncjajpi ca te da ncjajpi, guegue da mɛhtzi car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ca to i ne da sirvegui, i nesta da dɛngui, cja̱ nupʉ jabʉ gu hmʉjcö, guejti guegue da hmʉh pʉ hne̱je̱. Ca to da pɛjpiguigö, cam Tzi Ta ji̱tzi da nú̱ rá zö car cja̱hni‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nuya, i ndo mbe̱n nʉm mʉy ja gu ncja. ¿Ter bɛh ca̱ gu xih cam Tzi Ta? ¿Cja gu öjpi: “Nuquɛ, Tzi Ta, föxqui tzʉ, pa jin gu nesta gu tu̱”? Jin da jogui gu öjpi ncjapʉ, como guehca̱ xtá e̱h‑ca̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Diguebbʉ ya car Jesús bi nzoh ca Ocja̱, bi xifi: ―Nuquɛ, Tzi Ta, ya xí nzøh car hora gu tu̱. Pe nde̱jma̱ gui cjagui ca i nesta pa da tti̱zquiguɛ.― Cja bbʉ mí guadi mí ma̱ ncjanʉ, bi dyøh hnar jña̱ mbí ña̱ pʉ jar ji̱tzi, mí ma̱: ―Por rá ngue ca xcú dyøte, ya xtú cjagö xí hñi̱zquigö yʉ cja̱hni, cja̱ pé gu yojpi gu cjajpi yʉ cja̱hni da hñi̱zquigö por rá ngue ca ya xta ma da ncja.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nu cʉ cja̱hni cʉ már bbʉh pʉ, bbʉ mbí ña̱ car Tzi Ta pʉ jar ji̱tzi, bi dyødejʉ hnar ndo ruido. Cʉ ddáa ya, mí ma̱jmʉ, xquí mføjni car ji̱tzi. Nu cʉ pé ddaa ya mí ma̱jmʉ, múr anxe ca Ocja̱ már nzoh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Diguebbʉ ya, car Jesús bi xijmʉ: ―Nʉr jña̱ nʉ xcú dyøjmʉ, jin gui jønguitsjɛgö xí nzojquigö. Guehquitjoguɛjʉ hne̱je̱, xí nzohquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nuya, ya xí nzøh car hora gu tu̱, cja̱ por rá nguehca̱, car Tzi Ta ji̱tzi da juejqui yʉ cja̱hni yʉ i bbʉjcua jar jöy. Car hora ca xtá tu̱gö, xta tja̱jquibi cár cargo ca Jin Gui Jo. Xta tja̱jquibi ca rí mandado hua jar mundo. ");
INSERT INTO otsNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cja̱ nugö, bbʉ xta ddøjtigui pʉ ña̱ pʉ jabʉ da jiantigui cʉ cja̱hni, gu nzojtibi quí tzi mʉy göhtjo cʉ cja̱hni, sa̱nta̱ du e̱jmʉ pa da ba̱dijʉ toguigö.― ");
INSERT INTO otsNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nʉr palabra nʉ bi ma̱n car Jesús mí ne di ma̱ ja ncja dír du̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nu cʉ cja̱hni cʉ már ødejʉ bi da̱jtijʉ: ―I xijquije cʉ maestro cʉ xí nxöh cʉ Escritura, bbʉ xtu e̱h car Cristo ca da hñi̱x ca Ocja̱ pa da mandadoguije, guegue‑cá̱ da hmʉy göhtjo ʉr tiempo, jin da du̱. Nuquiguɛ, ncjahmʉ hnahño gri xijquije. Como guí xijquije i nesta da ddøti pʉ ña̱ ca hnar cjahni ca guí ma̱nguɛ, xpá bbɛjni hua jar jöy. Xijquije tzʉ, ¿to car cja̱hni‑ca̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Diguebbʉ ya pé bi ma̱n car Jesús: ―Dí bbʉjtigö hua jabʉ guí bbʉjquɛjʉ, dí ncja ngu̱ car jiahtzi. Pe ya xqui chi tchʉtjo i bbɛdi pa gu tzoquijʉ. Gui tɛnguijʉ ya, cja ya dí bbʉpjʉ hua. Ya xqui guejti pʉ xta zʉhquijʉ car bbɛxu̱y, cja̱ nubbʉ́, ya xcúr wengö hua. Dyo guí ncjajʉ ncja ngu̱ cʉ dda cja̱hni cʉ i dyo jar bbɛxu̱y cja̱ jin gui pa̱di jabʉ rí möjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nugö, dí ncja ngu̱ car jiahtzi. Gui hñemeguijʉ menta guí cca̱jtiguijʉ, pa da hmʉh car jiahtzi mbo ir tzi mʉyjʉ.― Bbʉ ya xquí ma̱n yʉ palabra‑yʉ car Jesús, diguebbʉ bi weguehui cʉ cjahni cʉ már nzofo, bi wem pʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nu cʉ cja̱hni‑cʉ́, masque ya xquí cca̱htijʉ ndu̱ntji milagro cʉ xquí dyøti car Jesús, pe jin gá hñemejʉ, ¿cja xcuí hñeh ca Ocja̱ guegue? ");
INSERT INTO otsNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ncjapʉ gá nzʉh car palabra ca xquí ma̱n car profeta Isaías pʉ jar Escritura: I ma̱ ncjahua: Nuquɛ, ʉm Tzi Taqui, tzi yotjo cʉ cja̱hni xí hñeme car palabra ca xtú ma̱ngö. Xtú ndo øti milagro co ni quer ttzɛdi, pe jin tza to i e̱me̱, má̱s guehquiguɛ xcú pɛnquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eso, jí̱ mí tzö di hñeme car Jesús cʉ cja̱hni rá ngu̱, como ya xquí mbe̱n ca Ocja̱ di ncjajʉ pʉ. Bi ncjá ncja ngu̱ ga ma̱ na̱ pe hnar palabra na̱ bi escribi car profeta Isaías. I ma̱ ncjahua: ");
INSERT INTO otsNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ca Ocja̱ bi gojtibi quí döjʉ, pa jin di cca̱htijʉ, Guejtjo bi cjajpi quí mʉyjʉ ncja hnar do gá me̱do, pa jin di ntiendejʉ. Mí ma̱ guegue: “Xí ncjapʉ yʉ cja̱hni, pa jin du cojmʉ jabʉ dí bbʉy cja̱ jin di jionguigö, Como, bbʉ di jionguigö, gua jojquibi quí tzi mʉyjʉ.” ");
INSERT INTO otsNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Bi ncjanʉ gá ma̱n car profeta Isaías, como guegue bi ba̱di ja di ncja car Cristo ca di hñe̱je̱. Bi cca̱hti te tza drá ji̱tzi car cargo di mɛhtzi‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pe nde̱jma̱ bi hñeme car Jesús cʉ ddáa quí jefe cʉ judio. Nucʉ́, jí̱ mí ncjua̱nijʉ má̱s mí e̱me̱jʉ, como mí tzu̱jʉ cʉ fariseo. Ya xquí ma̱n cʉ fariseo, bbʉ to di ma̱, guegue car Jesús múr Cristo ca xquí hñi̱x ca Ocja̱, di fongui jár templojʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Cʉ jefe cʉ bi hñemejʉ, jin gá ncjua̱nijʉ, como mí ndo nejʉ pa di tti̱htzibijʉ, cja̱ jin tza mí nejʉ di hmʉpjʉ pa di tzøh ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Diguebbʉ ya, car Jesús bi ña̱ nzajqui, bi ma̱: ―Car cja̱hni ca i e̱me̱gui, jin gui jøña̱guigö i e̱me̱gui. Guejtjo i e̱me̱ cam Tzi Ta ca xpá mɛnqui. ");
INSERT INTO otsNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Guejtjo dí xihquijʉ, ca to i cca̱jtiguigö, ncjahmʉ ya xí cca̱hti cam Tzi Ta ca xpá mɛnquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nugö, xtá e̱jcua jar mundo ncja ngu̱ hnar jiahtzi, pa jin da go jar bbɛxu̱y car cja̱hni ca da hñemegui. ");
INSERT INTO otsNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ca to da dyøj yʉ palabra yʉ dí ma̱ cja̱ jin da dyøjte, da ttun cár castigo, pe jí̱ rí ntzöhui da ma̱ guegue, guejquigö dí un cár castigo. Nugö, jí̱ xtá e̱jcö hua jar jöy pa gu castiga yʉ cja̱hni. Xtá e̱je̱ pa gu un car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nu car cja̱hni ca jin gui ne da hñeme, ¿cja xpá mɛnquigö car Tzi Ta ji̱tzi? cja̱ jin gui ne da dyøjti yʉ palabra yʉ dí ma̱, cierto ba e̱h car pa bbʉ xta tsjifi, i ndu̱jpite, cja̱ xta ncastiga. Bbʉ xta mbe̱n yʉ palabra yʉ xtú ma̱, xta ba̱tsjɛ mbo ʉ́r mʉy, rí ntzöhui da ttun cár castigo, como rá nttzo ca xí dyøte. ");
INSERT INTO otsNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jin gʉm mfe̱nitsjɛgö yʉ palabra yʉ dí xihquijʉ. Nu cam Tzi Ta ca xpá mɛnqui, guegue xí xijqui ter bɛh ca̱ gu ma̱, cja̱ co ja ncja gár nzoj yʉ cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Dí pa̱di, por rá nguehca̱ dár øti ca i xijqui cam Tzi Ta ji̱tzi, dí pɛhtzi car nzajqui ca rí hñe̱ guegue, gue car nzajqui ca jin da tjegue. Eso, dí nzohquijʉ ncja ngu̱ ga xijqui cam Tzi Ta. Dí xihquijʉ göhtjo ca i bbɛjpigui guegue.― Ncjapʉ gá ma̱n car Jesus. ");
INSERT INTO otsNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bbʉ ya xti ncja car mbaxcjua ca mí tsjifi ʉr Pascua, bi ba̱h car Jesús, ya xquí zʉh car pá pa di bøngua jar jöy, cja̱ pé drí ma pʉ jabʉ bí bbʉh cár Tzi Ta. Desde bbʉ mí mʉdi mí nzoh quí amigo cʉ mí tɛni, mí ma̱di hasta gue bbʉ mí du̱. ");
INSERT INTO otsNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Car Jesús már tzi car cena, már tzihui quí möxte, cja̱ már bbʉh pʉ hne̱je̱ car Judas Iscariote, cár ttʉ car Simón. Guegue car Judas ya xquí mbe̱ni di dö car Jesús pa di bböhti. Ca Jin Gui Tzö xquí un car mfe̱ni‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nu car Jesús mí pa̱di xcuí hñe̱ guegue pʉ jabʉ bí bbʉh ca Ocja̱, cja̱ ya pé xti ma drí goh pʉ. Guejtjo mí pa̱di, cár Tzi Ta pʉ ji̱tzi xquí un cár cargo cja̱ xquí uni ʉr tsjɛjqui di dyøti ca te mí ne. ");
INSERT INTO otsNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bbʉ már tzijʉ car cena, bi bböh car Jesús, bi møh car da̱jtu̱ mí pöti, cja̱ bi ga̱h hnar toalla, bi du̱hti pʉ jár ngʉti. ");
INSERT INTO otsNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Diguebbʉ ya, bi xiti deje hnar bandeja, bi mʉdi bi xʉjquibi quí hua quí möxte. Hna‑hnaa gá xʉjquibi cja̱ pé bi du̱jquibi co ni car toalla xquí du̱hti jár ngʉti. ");
INSERT INTO otsNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bbʉ mí zøh pʉ jabʉ már ju̱ car Simón Pedro, ya xi mír ma di xʉjquibi quí hua, nu car Pedro bi ccax car Jesús, bi xifi: ―Nuquɛ, Tzi Ta, ¿cja bí jogui guehquiguɛ gui xʉguigui yʉm hua? Jiɛj ya.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Car Jesús bi da̱jti bbʉ́: ―Nuya, jin guí ntiende te rá nguehca̱ dár xʉjqui yir huajʉ. Hasta bbʉ ya xtrú ncja ca xta ncja, nubbʉ, cja xquí ntiendejʉ, bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nubbʉ, pé bi ma̱n car Pedro: ―Jin gu jɛqui gui xʉguigö yʉm hua.― Cja̱ diguebbʉ ya bi da̱h car Jesús, bi xifi: ―Bbʉ jin gu xʉquiqui yir hua, ya jin gui tzö gui tɛngui bbʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Car Simón Pedro, bbʉ mí dyøh cʉ palabra‑cʉ́, nubbʉ́, bi pöta nttzɛdi quí mfe̱ni, bbʉ, bi ma̱: ―Jin gui jøntsjɛ yʉm hua gui xʉguigui. Guejtjo gui xʉguigui tzʉ yʉm dyɛ cja̱ co nʉm ña̱ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Diguebbʉ ya, bi ma̱n car Jesús: ―Car cja̱hni ca xí nxaja, jin gui nesta jabʉ pé da tsjʉjquibi, jøntsjɛ quí hua. Nuquɛjʉ, guí bbʉpjʉ limpio, masque jin gui göhtjoquiguɛjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bi ma̱n car Jesús, jí̱ mí göhtjo mí bbʉpjʉ limpio mbo í mʉyjʉ, porque guegue mí pa̱di toca̱ di dö. ");
INSERT INTO otsNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Cja̱ bbʉ mí guadi mí xʉjquibi quí hua göhtjo quí möxte, car Jesús pé bi möti car da̱jtu̱ xquí møgue. Cja̱ diguebbʉ, pé bi guati pʉ jar mexa, bi mi̱bi quí möxte, cja̱ bi xijmʉ: ―Nuquɛjʉ, ¿cja guí ntiendejʉ te rá nguehca̱ xtú cjahquijʉ ncjanʉ? ");
INSERT INTO otsNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Guí xijquijʉ ir maestroguijʉ hne̱ ir tzi Jmu̱guijʉ. Cierto ca guí ma̱jmʉ, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Macja̱ ir Jmu̱guijʉ hne̱ ir maestroguijʉ, nugö xtú xʉjqui yir huajʉ. Guehquitjoguɛjʉ, rí ntzöhui cada hnaaquiguɛjʉ gui xʉjquibi quí hua quir hñohuijʉ, gui dyøhtibijʉ ca te da nesta. ");
INSERT INTO otsNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Xtú ddahquijʉ hnar ejemplo pa gui tɛnijʉ. Xtú ncjagö ncja hnar mɛfitjo. Gui dyøtitsjɛjʉ ncja ngu̱ xtú øjtiquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cja̱ gui dyødejʉ na̱r palabra na̱ dí xihquijʉ: ca tengu̱ da tti̱zquijʉ jin da tjoh ca tengu̱ xí tti̱zquigö. Ca tengu̱ da tti̱htzibi yʉ jmandadero jin da tjoh ca tengu̱ xí tti̱htzibi ná̱r jmu̱‑yʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bbʉ ya xquí ntiendejʉ yʉ palabra xtú xihquijʉ, gui dyøtijʉ ncjapʉ, pa gui ndo mpöjmʉ bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jin gui göhtjoquiguɛjʉ, dí xihquijʉ gui dyøtijʉ ncjapʉ, sino jøña̱ yʉ ddaa yʉ xtú juajni pa da hñemegui. Dí pa̱di to cʉ xtú juajni. Nde̱jma̱ i bbʉquiguɛjʉ ca hnaa ca jin gui e̱me̱gui. Como i nesta da ncumpli na̱r palabra na̱ i ju̱x pʉ jar Escritura: “Ca hnam amigo ca ndí jeguebbe cam tju̱jme̱, xí cja ʉm contra.” ");
INSERT INTO otsNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nuya dí xihquijʉ te da ncjaguigö, ante que da ncja, pa bbʉ xta ncja, jin gui yomfe̱nijʉ, pe gui hñemejʉ, cierto guejquigö dúr cja̱hni xpá mɛnquigö ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cierto na̱r palabra na̱ dí xihquijʉ, ca to da nú̱ rá zö cam jmandadero ca xcuá pɛjnigö, ncjahmʉ guejquigö hne̱je̱ da nú̱gui rá zö. Hne̱quigö, bbʉ da nú̱gui rá zö hnar cja̱hni, i pøni ncjahmʉ gue cam Tzi Ta ca xpá mɛnquigö xtúr recibi hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Car Jesús, bbʉ mí guadi mí ma̱n ya palabra‑ya, bi ndo ntzøte, cja̱ bi ndo ungui ʉr dumʉy. Nubbʉ, pé bi nzoh quí möxte, bi xijmʉ claro ter bɛh ca̱ di ncja: ―Cierto na̱ dí xihquijʉ, i bbʉhquiguɛjʉ ca hnaa ca da döguigö pa da bböjtigui.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nu quí möxte ya, bi mʉdi bi ncca̱htitsjɛjʉ, cja̱ mí hñöntsjɛjʉ, ¿toca̱ di dyøhtibi‑ca̱? ");
INSERT INTO otsNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Már ju̱jʉ pʉ jar mexa car Jesús cja̱ co quí möxte, cja̱ ya ca hnaa ca más mí ne, már nzøtihui car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nubbʉ, car Simón Pedro bi nzoh ca hnaa, bi xifi di dyöni tzʉ car Jesús toca̱ di dö. ");
INSERT INTO otsNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Diguebbʉ ya, car möxte‑ca̱ bi ntja̱htzi gá nguati car Jesús, bi dyöni: ―Nuquiguɛ, Tzi Tada Jesús, ¿toca̱ da döqui ya?― ");
INSERT INTO otsNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Car Jesús ya bi da̱jti guegue, bi hñi̱mbi: ―Gu tjʉhmi hna pedazo ʉr tju̱jme̱ hua jar moji. Car cja̱hni ca gu uni, guehca̱ da dögui‑ca̱.― Bbʉ mí ma̱ ncjapʉ, bi moh hna pedazo ʉr tju̱jme̱ cja̱ bi un car Judas Iscariote, cár ttʉ car Simón. ");
INSERT INTO otsNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bbʉ mí jña̱ car pedazo ʉr tju̱jme̱ car Judas, exque bi dyɛmbi ʉ́r mʉy di dyøti ca mí xih ca Jin Gui Jo. Diguebbʉ ya car Jesús bi xifi: ―Dyøti nttzɛdi ca guí ne gui dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nu cʉ pe dda quí amigo car Jesús cʉ már tzijʉ jar mexa, jin to gá mba̱di te mí ne di ma̱n cʉ palabra cʉ xquí tsjih car Judas. ");
INSERT INTO otsNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mí i̱na̱jʉ, car Jesús már nzoh car Judas, como nucá̱ mí tu̱ car ddøza̱ ca mí cʉ car domi. Mí mbe̱nijʉ, má̱s már xih car Judas di ma du töy tema cosa mí nestajʉ pa car mbaxcjua, o di uni algo ʉr domi cʉ tzi probe. ");
INSERT INTO otsNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nu car Judas, bbʉ ya xquí jña̱ car pedazo ʉr tju̱jme̱, nubbʉ, bi bøm pʉ jabʉ már tzijʉ. Cja̱ ya xi mí nxu̱y. ");
INSERT INTO otsNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bbʉ ya xquí bøn car Judas, bi ma̱n car Jesús: ―Nuya xta fa̱di ja ncja ga hñi̱zquigö cam Tzi Ta, nugö dúr cja̱hni xpá mɛnqui hua jar jöy. Por rá nguejquigö xta fa̱di hne̱je̱ te tza rá nzɛh ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cja̱ bbʉ xta ncja nʉ dí xihquijʉ, nubbʉ́, cam Tzi Ta pé xta hñi̱zquigö pʉ jabʉ bí bbʉ guegue, cja̱ más da ndo tti̱zquigö, bbʉ́, nugö ʉ́r Ttʉgui ca Ocja̱. Cja̱ ncjatica̱ da ncja yʉ xtú xihquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nuquɛjʉ, ʉm tzi ba̱jtziquijʉ, ya xqui tchʉtjo ʉr tiempo gu hmʉpjʉ. Xquí jionguijʉ, pe jin gui töjquijʉ, como jin gui tzö gui möjmʉ pʉ jabʉ dár magö. Dí xihquijʉ mismo na̱r palabra na̱ dú xih quí jefe cʉ judio má̱hmɛto. Nuya, dí xihquijʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Dí tzohquijʉ hnar ddadyo jmandado. Gui ma̱jtsjɛjʉ, guí göhtjojʉ, como ngu̱ xtá ma̱hquigöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bbʉ gui ma̱jtsjɛjʉ, guí göhtjojʉ, nubbʉ da fa̱di, cierto, ʉm cja̱hniquiguɛjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Diguebbʉ ya car Simón Pedro bi dyön car Jesús: ―Nuquɛ, Tzi Ta Jesús, ¿jabʉ guír ma ya bbʉ?― Cja̱ bi da̱jti car Jesús: ―Nugö, pʉ jabʉ dár ma, jin gui tzö gui möjmʉ ya. Xta zøh car pa xquí möjmʉ pʉ, pe jin gui guejya.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Diguebbʉ ya, pé bi dyön car Pedro, bi hñi̱na̱: ―Nuquɛ, Tzi Jmu̱ Jesús, ¿dyoca̱ jin da jogui gu tɛnqui ya? Dí bbʉy dispuesto gu tɛnqui, masque xin gu tu̱ por rá nguehquiguɛ.― ");
INSERT INTO otsNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma ya pé bi da̱h car Jesús: ―¿Cja cierto, guí bbʉy dispuesto gui tu̱ por rá nguejquigö? Dyøjma̱ja̱ na̱ dí xihqui ya, ante que da mah car ndøxca rá nxu̱nya, gui ma gui cøngui jñu̱ vez, gui ma̱, jin guí meyagui.― ");
INSERT INTO otsNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Diguebbʉ ya, car Jesús pé bi xih quí möxte: ―Dyo guí ntzøtijʉ ca ya xtrá magö. Gui hñemejʉ ca Ocja̱. Guejtigö, gui hñemeguigöjʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pʉ jár ngu̱ cam Tzi Ta i bbʉy rá ngu cʉ ngu̱ pʉ jabʉ gui tzöyajʉ. Bbʉ jin di ncjapʉ, jin gua xihquijʉ xquí möjmʉ pʉ. Nuya, ya xtrá magö, gu ma grí jojqui car lugar pʉ jabʉ gui hmʉpjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Diguebbʉ ya, bbʉ ya xcrú jojqui, xcuá cojcö pa gu tzixquijʉ. Pʉ jabʉ gu hmʉjcö, guehquitjoguɛjʉ gui ma grí hmʉpjʉ pʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ya xquí pa̱dijʉ jabʉ gu ma, cja̱ guejtjo guí pa̱dijʉ car hñu̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nubbʉ, bi ma̱n car Tomás, bi dyön car Jesús: ―Nuquɛ, Tzi Jmu̱, jin dí pa̱dije jabʉ grí ma. ¿Ja grá pa̱jcöje car hñu̱, bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Car Jesús bi xifi: ―Nugö dúr hñu̱ pa gui tɛnguijʉ, guejtjo dí xihquijʉ ca ncjua̱ni pa gui hñemejʉ. Guejtjo dí ja̱gö car nzajqui ca jin da tjegue pa gu ddahquijʉ. Bbʉ di ji̱na̱gö, jin to di zøm pʉ jabʉ bí bbʉh cam Tzi Ta. ");
INSERT INTO otsNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bbʉ gri pa̱dijʉ toguigö, guejtjo gri pa̱dijʉ to cam Tzi Ta. Pe nuya, ya xtú xihquijʉ, pa gui pa̱dijʉ ja i ncja cam Tzi Ta, como ya xcú cca̱jtiguijʉ ja dí ncjagö.― ");
INSERT INTO otsNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Diguebbʉ ya, car Felipe pé bi xifi: ―Nuquɛ, Tzi Ta Jesús, u̱jtiguije tzʉ car Tzi Ta ji̱tzi, pa da mpöj yʉm tzi mʉyje.― ");
INSERT INTO otsNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Car Jesús pé bi da̱jti, bbʉ: ―Nuquɛ, Felipe, ya xná ngu̱ tiempo xtú hmʉpjʉ. Ya xquí pa̱dijʉ ja dí ncjagö. ¿Cja jí̱ bbe guí pa̱di te ʉm ncjagöbbe car Tzi Ta ji̱tzi? Car cja̱hni ca xí cca̱jtigui, ncjahmʉ ya xí cca̱hti cam Tzi Ta hne̱je̱. ¿Sá guí ma̱nguɛ bbʉ́: “Ujtiguije tzʉ car Tzi Ta ji̱tzi”? ");
INSERT INTO otsNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Cja jin guí e̱me̱, guejquigö dí bbʉbbe car Tzi Ta ji̱tzi cja̱ dí yobbe‑ca̱? Jin gʉm mfe̱nitsjɛgö cʉ palabra dí xihquijʉ. Nucʉ́, rí hñe̱h cam Tzi Ta ji̱tzi. Guejti yʉ göhtjo yʉ dí øte, ncjahmʉ i øti‑yʉ́ cam Tzi Ta, como i bbʉ mbo ʉm tzi mʉy guegue, i nzojqui. ");
INSERT INTO otsNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gui hñemejʉ na̱ dí xihquijʉ, nugö, dí bbʉbbe car Tzi Ta ji̱tzi, cja̱ guegue i bbʉ mbo ʉm tzi mʉy. O bbʉ jí̱ bbe guí e̱me̱jʉ ya palabra dí xihquijʉ, nubbʉ, gui mbe̱nijʉ ja i ncja yʉ milagro dí øte, cja̱ por rá nguejyʉ, gui hñemejʉ, cierto dí yobbe car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Dí xihquijʉ cierto, yʉ cja̱hni yʉ i e̱me̱gui, da dyøti milagro ncja ngu̱ yʉ dí øtigö. Hasta más drá nzɛdi cʉ milagro cʉ da dyøtijʉ ni ndra ngue yʉ dí øtigö, como ya xtrá magö pʉ jabʉ bí bbʉh cam Tzi Ta. ");
INSERT INTO otsNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nuquɛjʉ, göhtjo ca te gui dyöjpijʉ cam Tzi Ta por rá nguehca̱ guír hñemeguijʉ, ʉ́r Ttʉgui ca Ocja̱, nugö xtá øtigö, pa da ni̱gui te tza rá nzɛh cam Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Guejtjo, bbʉ te gui dyöjquijʉ gu øte por rá nguehca̱ guír hñemeguijʉ, xtá øtigö‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Bbʉ guí neguijʉ, gui dyøjtiguijʉ ca dí mandadoquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nugö xcuá öjpi cam Tzi Ta du pɛjnquijʉ ca hnaa ca da u̱jtiquijʉ car hñu̱, pa gui hmʉpjʉ‑ca̱ göhtjo ʉr vida. ");
INSERT INTO otsNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Gue car Tzi Espíritu Santo gui hmʉpjʉ, cja̱ guegue da u̱jtiquijʉ ca ncjua̱ni. Car Espíritu‑ca̱ jin gui tzö da yojmi cʉ cja̱hni cʉ jin gui e̱me̱gui. Nim pa i pa̱h‑cʉ́ ¿cja i bbʉ guegue? Guejtjo jin gui pa̱dijʉ ja i ncja. Nuquɛjʉ, ya xquí pa̱dijʉ to car Tzi Espíritu Santo, como guehca̱ guí bbʉpjʉ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nugö, ya xtá ma, pe jin gu tzoquijʉ ncja ngu̱ tzi jioya. Xcuá cojcö pa pé gu hmʉjcöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pé hna ratotjo, cja̱ ya jin da cca̱jtigui yʉ cja̱hni yʉ jin gui e̱me̱gui. Pe nuquɛjʉ, xquí cca̱jtiguijʉ, como pé xta ncjadi cam nzajqui. Hne̱hquiguɛjʉ, car nzajqui ca xtá pɛhtzigö, gui ma gui pɛhtziguɛjʉ‑cá̱ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Car pa‑ca̱, xquí pa̱dijʉ, dí göhtjojʉ dí bbʉpjʉ, nugö cja̱ co cam Tzi Ta ji̱tzi, cja̱ co nuquɛjʉ. Nugö, dí yobbe cam Tzi Ta, co hne̱hquiguɛjʉ, dí yojmʉ hne̱je̱. Ncjahmʉ guir bbʉjcö mbo ir tzi mʉyjʉ, cja̱ cam Tzi Ta da nú̱quijʉ, ncja ngu̱ ga nú̱guigö‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Car cja̱hni ca ntjumʉy i negui, i mbe̱n cʉ jmandado cʉ xtú xihquijʉ, cja̱ i øti‑cʉ. Cam Tzi Ta ji̱tzi da ne car cja̱hni‑ca̱ hne̱je̱. Hne̱quigö xtá ne car cja̱hni‑ca̱ cja̱ xtá u̱jti rá zö, ja dí ncjagö.― ");
INSERT INTO otsNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Diguebbʉ ya, bi ma̱n ca pé hnar Judas ca jí̱ múr Judas Iscariote, bi dyön car Jesús: ―¿Te rá nguehca̱ gui ma gui u̱jtiguije ja guí ncjaguɛ, pe nu cʉ cja̱hni cʉ i tɛn nʉr mundo, jin gui ma gui u̱jti‑cʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Bi da̱h car Jesús, bi xifi: ―Car cja̱hni ca i negui, i øjti yʉ palabra yʉ dí ma̱. Cam Tzi Ta ji̱tzi da ne car cja̱hni‑ca̱. Nugö co cam Tzi Ta, gu cuatibbe car cja̱hni‑ca̱, gu hmʉpje guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Car cja̱hni ca jin gui negui, jin gui cjajpi ncaso yʉ palabra yʉ dí ma̱. Yʉ palabra yʉ xtú xihquijʉ cja̱ xcú dyøjmʉ, jin gʉm mfe̱nitsjɛjɛ. Gue quí mfe̱ni cam Tzi Ta ca xpá mɛjnquigö. Tzʉdi, car cja̱hni ca jin gui cjajpi ncaso ca dí ma̱, guejtjo jin gui cjajpi ncaso ca i ma̱n car Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yʉ palabra‑yʉ, ya xtú xihquijʉ cja ya dí bbʉjtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pe bbʉ ya xcúr magö ji̱tzi, gue car Tzi Espíritu Santo da ddahquijʉ consejo. Car Tzi Ta ji̱tzi du pɛjnquijʉ‑cá̱ pa gui hmʉpjʉ. Da go guegue jam lugar, ncjahmʉ segue guir bbʉjtigöjʉ. Guegue car Tzi Espíritu Santo da u̱jtiquijʉ göhtjo ca guí nesta gui pa̱dijʉ, cja̱ da mbe̱mbiquijʉ göhtjo cʉ palabra xtú xihquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nuya, ya xtí ne gu hñi̱hquijʉ, cja̱ dí ne gu tzohquijʉ hnar bendición, gue ca dír jñu̱ ir mʉyjʉ. Jin dí hñi̱hquijʉ ncja ngu̱ di hñi̱jte hnar cja̱hni ca di tɛndi nʉr mundo. Nugö, dí xihquijʉ, masque da zʉhquijʉ ca te da zʉhquijʉ, nde̱jma̱ da jñu̱ ir mʉyjʉ. Dyo te guí mbe̱nijʉ, cja̱ dyo guí ntzu̱jʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya xcú dyødejʉ ca xtá xihquijʉ: “Ya xtár magö cja̱ pé xcuá coji pa gu hmʉpjʉ.” Bbʉ ntjumʉy guir neguijʉ, güi mpöjmʉ ca xtá xihquijʉ, ya xtár ma grí hmubbe cam Tzi Ta ji̱tzi. Nubbʉ́, da ndo tti̱zquigö bbʉ, como más i tti̱htzibi cam Tzi Ta ni ndra nguejquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nuya, dí xihquijʉ ter bɛh ca̱ da ncjagui, pa bbʉ xta ncja‑cá̱, nde̱jma̱ xquí hñemeguijʉ cja̱ jin gui yomfe̱nijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Ya jim pé gu dé gu ña̱jʉ, como ya xpa̱ e̱h ca hnáa ca i mandado hua jar mundo. Nucá̱, da dyøhtibi cár jmandado ca Jin Gui Jo, pe jin te i pɛhtzi ʉ́r ttzɛdi pa da mandadogui. Nugö, gu jñɛgui da dyøjtigui ca xí ttuni ʉr tsjɛjqui da dyøjtigui, pa ncjapʉ drí ni̱gui, dí ndo ne cam Tzi Ta, cja̱ dí øte ncja ngu̱ xcá bbɛjpigui. Bböpjʉ ya, gu wenijʉ hua.― ");
INSERT INTO otsNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Diguebbʉ, pé bi ma̱n car Jesús, bi xih quí möxte: ―Nugö, dí ncja ngu̱ hnar za gá uva ca i ndo tu̱ uva rá zö, cja̱ cam Tzi Ta ji̱tzi i ncja ngu̱ car mɛfi ca i föh car huerta. ");
INSERT INTO otsNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yʉ cja̱hni yʉ xí nguati jam dyɛ i jñɛjmʉ quí dyɛza car za gá uva. Cʉ dyɛza cʉ jin te i ungui ixi, da zɛjqui cam Tzi Ta. Nu cʉ dyɛza cʉ i tu̱ ixi, i jojqui‑cʉ, pa da ngu̱jqui car ixi i tu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nuquiguɛjʉ, guí ncjajʉ ncja ngu̱ cʉ dyɛza cʉ ya xí tjojqui, nu cam palabra ca xtú u̱jtiquijʉ, guehca̱ xí jojqui quir tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gui segue gui tɛnguijʉ, cja̱ nugö gu segue gu yojmʉ. Hnar dyɛza, bbʉ da ttzɛjqui jár za, ya jin gui tzö da du̱ ixi. I nesta da hmʉjti pʉ jar za pa da ún quí ixi. Hne̱hquiguɛjʉ, jin te xquí sirveguijʉ bbʉ gui wembiguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nugö dí jñɛbbe hnar za, cja̱ nuquɛjʉ, guí jñɛjmʉ quí dyɛ. Yʉ to dí yobbe, dí ungö nzajqui hne̱je̱. Guegue‑yʉ da jñɛjmi dyɛza cʉ i tu̱ ixi rá ngu̱. Nu cʉ to jin dí yobbe, jin gui tzö da dyøti tema cosa drá zö. ");
INSERT INTO otsNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Car cja̱hni ca jin gui ne da dɛnguigö, da ttzo hnanguadi, ya jin te da hmʉ ʉ́r nzajqui. Nucá̱ da ncjá ncja ngu̱ cʉ dyoti dyɛza i cuajti yʉ cja̱hni pa da ttu̱di. ");
INSERT INTO otsNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pe nuquɛjʉ, bbʉ segue gui tɛnguijʉ cja̱ gui mbe̱nijʉ cʉm palabra xtú xihquijʉ, da jogui gui dyöjpijʉ ca Ocja̱ göhtjo ca guí nejʉ, cja̱ guegue da ddahquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nubbʉ, xquí ncjajʉ ncja ngu̱ hnar jogui za, drá zö quir vidajʉ, cja̱ da fa̱di, cierto ʉm cja̱hniquijʉ. Guejtjo da fa̱di te tza rá zö cam Tzi Ta ji̱tzi, por rá ngue quir vidajʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","I neguigö cam Tzi Ta ji̱tzi. Guejtjo dí ncjadigö pʉ, dí nequijʉ. Nuquiguɛjʉ, gui tɛnguijʉ, bbʉ, cja̱ gui mbe̱nijʉ te tza ngu̱ dí nequijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bbʉ gui dyøtijʉ ncja ngu̱ ga ma̱n cʉm mandamiento, nubbʉ, xquí mbe̱nijʉ ja ncja dar nequijʉ, cja̱ xquí tɛnguijʉ, bbʉ́. Ncjaguigö hne̱je̱, dí øjti cam Tzi Ta, cja̱ dí mbe̱ni ja ncja ga negui‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ya xtú xihquijʉ ja gui ncjajʉ pa gui mpöjmʉ ncja ngu̱ dar mpöjcö. Bbʉ gui dyøtijʉ ncjapʉ, xquí mpöjmʉ göhtjo mbo ir tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dí tzohquiquijʉ hnar ddadyo mandamiento: Gui netsjɛjʉ, guí göhtjojʉ, ncja ngu̱ xtá nequigöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Car cja̱hni ca más i ne quí hñohui, guegue da dö cár vida por rá nguehcʉ. Nugö gu øtigö ncjapʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nuquiguɛjʉ, ʉm amigoquijʉ bbʉ gui dyøtijʉ ca dí xihquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ya jin dí xihqui ʉm mɛfiquijʉ, como yʉ mɛfi, jin gui pa̱di ter bɛh ca̱ i mbe̱n cár jmu̱jʉ. Nuquɛjʉ, ya xtí nzohquijʉ gá ámigo, como ya xtú u̱jtiquijʉ göhtjo ca xí xijqui cam Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jin guí guehquɛjʉ xcúr juanquigöjʉ. Guejquigö, xtú juanquijʉ pa gui hñe̱me̱guijʉ, cja̱ xtú i̱xquijʉ gui möjmʉ pʉ jabʉ gu cu̱hquijʉ, gui sirveguijʉ, cja̱ jin gui wembiguijʉ göhtjo ʉr vida. Como xtú juanquijʉ, bbʉ te gui dyöjpijʉ cam Tzi Ta por rá nguehca̱ guír hñemeguijʉ, da ddahquijʉ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Gue na̱r mandamiento‑na̱ dí xihquijʉ, gui ma̱jtsjɛjʉ, guí göhtjojʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Bbʉ xta ʉquijʉ yʉ cja̱hni yʉ i tɛn nʉr mundo, gui mbe̱nijʉ, bbɛto xí ʉguigö‑yʉ hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bbʉ dí mɛjtiquijʉ nʉr mundo, nubbʉ, di ma̱hquijʉ bbʉ. Pe nugö, dú wequiquijʉ bbʉ nguí bbʉpjʉ jar mundo, pa güi tɛnguigöjʉ. Cja̱ nuya, como ya jí̱ í mɛjtiquijʉ nʉr mundo, ya jin gui nequijʉ yʉ cja̱hni yʉ i tɛn nʉr mundo. ");
INSERT INTO otsNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gui mbe̱nijʉ na̱r palabra na̱ xtú xihquijʉ. Da jnu̱ hnar mɛfi ncja ngu̱ ga jnu̱ cár jmu̱. Pʉ jabʉ xí ttøjtigui tu̱jni, guejtjo da ttøjtiquijʉ tu̱jni hne̱je̱. Cja̱ pʉ jabʉ xí tte̱me̱ ca dí ma̱, guejtjo da tte̱me̱ ca guí ma̱jmʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Cʉ cja̱hni cʉ i ʉguigö da cjahquijʉ ndu̱ntji cosa rá nttzo, por rá nguehca̱ guír tɛnguigöjʉ, como guegue‑cʉ jin gui pa̱di ja i ncja ca hnáa ca xpá mɛnquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nugö xtú e̱je̱, xtú nzoh cʉ cja̱hni‑cʉ, xtú xijmʉ ca ncjua̱ni. Bbʉ jin gua nzofo, nubbʉ, jin di ndu̱jpitejʉ bbʉ. Pe xtú nzojcö‑cʉ, cja̱ jí̱ xcá ne xcá dyødejʉ, eso i tu̱di ca rá nttzo ca xí dyøtijʉ, cja̱ jin da mperdonabi. ");
INSERT INTO otsNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Car cja̱hni ca i ʉguigö, ncjahmʉ i ʉhui cam Tzi Ta ji̱tzi hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nugö, xtú e̱je̱, cja̱ xtú øti ndu̱ntji milagro pʉ jabʉ mí cca̱jtigui cʉm contra. Jin to i bbʉh ca xtrú dyøti milagro ncja ngu̱ cʉ xtú øtigö. Bbʉ jí̱ xtrú cca̱hti cʉm contra cʉ milagro xtú øte, jin di ndu̱jpite‑cʉ́. Pe guegue‑cʉ xí cca̱hti cʉ xtú øtigö cja̱ nde̱jma̱ xí ʉguitjo. Eso, i tzʉdi ncjahmʉ xí ʉhui cam Tzi Ta ji̱tzi hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Xí dyøtijʉ ncjapʉ pa di ncumpli car palabra ca i ju̱x pʉ jar Escritura, pʉ jabʉ i ma̱: “Gueguejʉ xí ʉguigö, cja̱ u̱jtjo jin tema du̱muy.” ");
INSERT INTO otsNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pe bbʉ xtu e̱h car Tzi Espíritu ca da ddahquijʉ consejo, guegue da u̱jtiquijʉ ja dí ncjagö, cja̱ da xihquijʉ ca ncjua̱ni, da jñɛjmi hnar testigo. Cam Tzi Ta ji̱tzi co nigö, xcuá pɛjnibbe car Espíritu‑ca̱ pa da guahquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Guehquitjoguɛjʉ hne̱je̱, xquí cjajʉ testigo, xquí xijmʉ cʉ cja̱hni toguigö, como guehquɛjʉ xtú hmʉpjʉ desde bbʉ ndú fʉdi dú nzoj yʉ cja̱hni.― ");
INSERT INTO otsNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Cja̱ pé bi ma̱n car Jesús: ―Ya xtú xihquijʉ te da ncja, pa bbʉ xta ncja, jin da ga̱x ir mʉyjʉ, cja̱ jingui wembiguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba e̱h car pa bbʉ xta mfonquiquijʉ jáy templo cʉ judio. Guejtjo da zøh car pa bbʉ xta möjtiquijʉ cʉ cja̱hni, porque ga ma̱jmʉ, ncjapʉ ga tzøjmʉ ca Ocja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Da ʉquijʉ, cja̱ da dyøjtiquijʉ tu̱jni, porque jí̱ xcá mba̱dijʉ ja i ncja cam Tzi Ta ji̱tzi, cja̱ co toguigö. ");
INSERT INTO otsNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ya xtú xihquijʉ ncjanʉ, pa bbʉ xta zøh car hora, xquí mbe̱nijʉ, ya xtá xihquigöjʉ te di ncja. Bbʉ cja ndí fʉdi ndí nzohquijʉ, jin dá xihquijʉ te da ncjahquijʉ, porque mí cjadi mpa pa gua hmʉpjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pe nuya, ya xtár magö pʉ jabʉ bí bbʉh cam Tzi Ta ca bú pɛnqui, cja̱ ni di hnaaquiguɛjʉ, jin guí önguijʉ jabʉ gár ma. ");
INSERT INTO otsNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nuquɛjʉ, guí ndo du̱mʉyjʉ, porque xtú xihquijʉ ter bɛh ca̱ da ncja bbʉ ya xcrú magö. ");
INSERT INTO otsNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nugö dí xihquijʉ ca ncjua̱ni: Bí jogui pa guehquɛjʉ ca ya xtár magö. Bbʉ jin gu magö, nubbʉ, jin du e̱h ca hnaa ca da möxquijʉ. Cja̱ bbʉ xtá magö, nubbʉ, xcuá cu̱jcö‑ca̱ pa du e̱je̱ gui hmʉpjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bbʉ xtu e̱h car Tzi Espíritu Santo, guegue da nzoj yʉ cja̱hni hua jar mundo. Da xijmʉ i tu̱jʉ ca rá nttzo. Guejtjo da xijmʉ ja i ncja ca rá zö, tzʉdi, cam hmʉygö ca xtú hmʉjcua jar jöy. Cja̱ pé da xijmʉ, ba e̱h car pa bbʉ xta tja̱mpijʉ ʉr huɛnda. ");
INSERT INTO otsNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Da xij yʉ cja̱hni yʉ rí dɛn nʉr mundo, rá nttzo ca i øtijʉ, como jin gui ne da hñemeguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Guejtjo da xijmʉ, göhtjo már zö ca ndí øtigö, por eso, ya xí cuajtigui pʉ ji̱tzi cam Tzi Ta. Pe como ya xcúr magö, ya jin da jogui gui cca̱jtiguijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Guejtjo da xij yʉ cja̱hni ja da ncja bbʉ xta dyøti cár juicio ca Ocja̱. Nugö, ya xtá juzga ca Jin Gui Jo, cja̱ nucá̱ i mandado hua jar mundo. Bbʉ xtá tu̱, gu ja̱jquibi cár poder. ");
INSERT INTO otsNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","I bbʉy pé dda palabra rá ngu̱ dí ne gu xihquijʉ, pero jin güi jiöti güi dyødejʉ rá pa ya. ");
INSERT INTO otsNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bbʉ xtu e̱h car Espíritu Santo, guegue da u̱jtiquijʉ pé dda mfe̱ni cʉ ncjua̱ni, da xihquijʉ göhtjo ca jí̱ xtá xihquijʉ. Como guegue jin da xihquijʉ quí mfe̱nitsjɛjɛ. Da xihquijʉ göhtjo ca xpá xih cam Tzi Ta ji̱tzi. Guejtjo da xihquijʉ pé dda cosa cʉ i nesta da ncja. ");
INSERT INTO otsNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Como dí yojcöbbe car Tzi Espíritu Santo, guegue da u̱jtiquijʉ te tza ngu̱ cam poder, cja̱ da möxquijʉ pa gui ntiendejʉ cʉm mfe̱ni. ");
INSERT INTO otsNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dí yojcöbbe cam Tzi Ta ji̱tzi. Ncja ngu̱ ga hmʉh‑ca̱, dí bbʉjcö hne̱je̱. Cár ttzɛdi cja̱ co quí mfe̱ni cam Tzi Ta, göhtjo ʉm mɛjtigö hne̱je̱. Bbʉ xtu e̱h car Espíritu Santo, guegue da xihquijʉ göhtjo ja dí ncjagö. ");
INSERT INTO otsNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","I bbɛjti tengu̱ tzi hora, cja̱ ya jim pé gui cca̱jtiguijʉ. Diguebbʉ ya, pé tengu̱ tzi mpatjo, cja̱ pé xquí cca̱jtiguitjojʉ, porque ya xtá ma pʉ jabʉ bí bbʉh cam Tzi Ta.― ");
INSERT INTO otsNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Diguebbʉ ya, cʉ dda quí möxte car Jesús bi hñöntsjɛjʉ ja mí ncja cʉ palabra cʉ xquí ma̱n car Jesús. Mí hñöntsjɛ‑cʉ: ―¿Ter bɛh ca̱ i ne da xijquijʉ bbʉ ga ma̱, i bbɛjti tengu̱ tzi hora, cja̱ ya jim pé gu cca̱htijʉ guegue, cja̱ diguebbʉ ya pé tengu̱ tzi mpa, cja̱ pé gu cca̱htitjojʉ, porque pé drí ma pʉ jabʉ bí bbʉh cár Tzi Ta? ");
INSERT INTO otsNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Te i ne da ma̱ bbʉ ga xijquijʉ: “I bbɛjti tengu̱ tzi hora”? Jin di ntiendejʉ‑cá̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bi ba̱h car Jesús te mí ne di dyön quí möxte, cja̱ bi xijmʉ: ―Nugö, xtú xihquijʉ: “I bbɛjti tengu̱ tzi hora cja̱ ya jim pé gui cca̱jtiguijʉ. Diguebbʉ, pé tengu̱ tzi mpatjo, cja̱ pé xquí cca̱jtiguitjojʉ.” Pe ntoja guí hñöntsjɛjʉ, ¿te i ne da ma̱n‑ca̱? ");
INSERT INTO otsNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cierto dí xihquijʉ, ya xqui guejtipʉ da ncjagui ca i ne nʉr mundo. Nubbʉ́, cʉ cja̱hni cʉ i tɛn nʉr mundo da mpöjmʉ. Nuquiguɛjʉ gui ma gui nzonijʉ, cja̱ gui ndo cjajʉ ndu̱mʉy. Pe diguebbʉ ya, pé da wen quer du̱mʉyjʉ, cja̱ da ndo mpöh quir tzi mʉyjʉ, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hnar bbɛjña̱, bbʉ ya xní ma da odi, i ndo sufri. Pe bbʉ ya xí hmʉh cár tzi ba̱jtzi, ya nubbʉ, ni mpa di mbe̱n ca xí tzöhui, ¿cja már ʉ? I ndo mpöh bbʉ, como ya xí hmʉh hnar tzi ba̱jtzi. ");
INSERT INTO otsNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Guehquitjoguɛjʉ hne̱je̱, xquí ncjajʉ pʉ. Da ndo ddahquijʉ ʉr du̱mʉy bbʉ xtá magö. Pe bbʉ xcuá coji, nubbʉ, da ndo mpöh quir tzi mʉyjʉ bbʉ, cja̱ jin da wen car pöjö‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bbʉ ya xcúr pøxcö pʉ ji̱tzi, cja̱ ya xquí yojmʉ ca hnaa ca xcuá pɛnquijʉ, nubbʉ, jin da nesta gui dyönguijʉ tema nttöni. Cierto na̱ dí xihquijʉ, göhtjo ca te gui dyöjpijʉ cam Tzi Ta ji̱tzi por rá nguehca̱ guír hñemeguijʉ, xta ddahquijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta rá pa ya, jin te xquí dyöjpijʉ cam Tzi Ta por rá nguehca̱ guír hñemeguijʉ. Dí xihquijʉ ya, gui dyöjpijʉ ca guí nejʉ, cja̱ da ddahquijʉ cam Tzi Ta, pa ncjapʉ da ndo mpöh quir tzi mʉyjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yʉ pa ya, xtú nzohquijʉ gá ejemplo. Cada bbʉ dí xihquijʉ ja i ncja ca Ocja̱, dí jɛquihui guegue tema cosa. Pe ya xpa e̱h car pa bbʉ ya jin gu ña̱ gá ejemplo bbʉ xtá nzohquijʉ. Nubbʉ, xtá xihquijʉ clarotjo, göhtjo ja i ncja cam Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bbʉ ya xcrú magö pʉ jabʉ bí bbʉh cam Tzi Ta, nubbʉ da jogui gui dyöjpitsjɛjʉ quir nttödijʉ por rá nguehca̱ grí hñemeguijʉ. Nubbʉ́, ya jin da nesta gu cuatigö cam Tzi Ta pa gu öjpi da dyøh bbʉ xtí nzojmʉ, ");
INSERT INTO otsNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Como guejtsjɛ guegue i ma̱hquijʉ. I nequijʉ cam Tzi Ta, porque xcú neguijʉ cja̱ xcú hñemejʉ, guegue xpá mɛnquigö hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nugö xtá e̱h pʉ jabʉ bí bbʉh cam Tzi Ta, xtú e̱jcua jar jöy. Cja̱ nuya gu tzoj nʉr jöy, pé gu ma dá ma pʉ jabʉ bí bbʉh cam Tzi Ta.― ");
INSERT INTO otsNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Diguebbʉ quí möxte car Jesús bi ma̱jmʉ: ―Nuya, cja guí xijquije claro ter bɛh ca̱ gui ma gui dyøte. Ya jin te guí jɛqui gá ejemplo. ");
INSERT INTO otsNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nuya, cja dí pa̱dije guehquɛ guí pa̱di göhtjo, cja̱ jin gui nesta to te da dyönqui, pa da dyøjtiqui prueba. Nuya dí e̱me̱je guehquɛ xquí hñe̱h pʉ jabʉ bí bbʉh ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Diguebbʉ ya car Jesús pé bi xih quí möxte, i̱na̱: ―¿Cja ntju̱mʉy guí e̱me̱guijʉ ya? ");
INSERT INTO otsNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nuya, ya xpa e̱h car hora, ya mero xta zʉdi, guí göhtjojʉ gui mfontijʉ, hna‑hnaa jabʉ guír möjmʉ, cja̱ nuguigö, gui ma gui tzoguijʉ guir ddatsjɛ. Pe jin guir ddatsjɛgö, porque nde̱jma̱ dí yobbe cam Tzi Ta ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ya xtú xihquijʉ te da ncja, pa gui hñemeguijʉ, göhtjo mbo ir mʉyjʉ, cja̱ pa da jñu̱ ir mʉyjʉ. Masque da dyøjtiquijʉ tu̱jni yʉ cja̱hni yʉ i tɛn nʉr mundo, pe jin da ga̱x ir mʉyjʉ. Nugö, ya xtú ta̱pi göhtjo yʉ i cja hua jar mundo.― ");
INSERT INTO otsNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bbʉ mí guadi mí xih quí möxte yʉ palabra‑yʉ, car Jesús bi nøhtze jar ji̱tzi, cja̱ bi nzo Ocja̱, bi xifi: ―Nuquiguɛ, ʉm Tzi Taqui, ya xí nzøh car hora, ya xtrá ma gu tu̱. Gui föxqui tzʉ, pa da tti̱zquigö cja̱ da fa̱di ir Ttʉguigö. Guejtiquɛ, da tti̱zquiguɛ hne̱je̱ bbʉ xtá tu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Guehquɛ gú ddajqui cam cargo bbʉ ndú e̱cua jar jöy, cja̱ gú döjqui jam dyɛ göhtjo yʉ cja̱hni. Nuquiguɛ, göhtjo cʉ to ya xquí juajni, xcú ddajqui cam cargo pa gu un‑cʉ́ car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nucʉ́ i pa̱di guí ddatsjɛ gú Ocja̱, cja̱ guejquigö xcú hñi̱xqui dúr Cristo, cja̱ xcú pɛnqui hua jar jöy. Guegue‑cʉ xí ttun car nzajqui ca rí hñe̱ ji̱tzi. ");
INSERT INTO otsNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nuya, ya xtú cjuadi xtú u̱jti yʉ cja̱hni hua jar jöy göhtjo ca gú xijqui gua u̱jti. Xtú u̱jti‑yʉ te tza rá zöquiguɛ. ");
INSERT INTO otsNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cja̱ nuya, ʉm Tzi Taqui, gui cuajtigui tzʉ pʉ jabʉ ndí bbʉ ma̱hmɛto, bbʉ jí̱ bbe nguí øti nʉr jöy. Gui ddajqui tzʉ cam cargo ca ndí pɛhtzi bbʉ ndí bbʉbi pʉ, pa pé da tti̱zquigö ncja ngu̱ nguá tti̱zquigö ma̱hmɛto. ");
INSERT INTO otsNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yʉ cja̱hni hua jar jöy yʉ gú juajni pa di dɛngui, ya xtú u̱jti‑yʉ ja guí ncjaguɛ. Nuyʉ, bbʉ jí̱ bbe ndí nzofo, ya xquí juajniguɛ, cja̱ nuya xcú nzojtibi í tzi mʉyjʉ cja̱ xí hñemegui‑yʉ́. Guegue‑yʉ xí dyøjti quer palabra. ");
INSERT INTO otsNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ya xí mba̱dijʉ, rí hñe̱h car Tzi Ta ji̱tzi göhtjo cʉ palabra cʉ xtú xijmʉ, cja̱ co göhtjo ca xtú u̱jtijʉ, como guehquiguɛ gú xijqui ter bɛh ca̱ mír ntzöhui gua u̱jti‑yʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nugö xtú xijmʉ cʉ palabra cʉ gú xijqui, cja̱ guegue‑yʉ xí hñeme cja̱ xí mba̱dijʉ, ntjumʉy dá e̱h pʉ jabʉ ndí bbʉbi, cja̱ guehquɛ gú pɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nuya, dí öhqui tzʉ, gui cuajti yʉ cja̱hni yʉ xí hñemegui. Jin dí öhqui gui cuajti cʉ cja̱hni cʉ jí̱ xquí nzojquɛ. Gue yʉ ya xcú nzojtibi í mʉyjʉ, dí öhqui tzʉ gui föj‑yʉ́, como ir mɛjtiguɛ‑yʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Göhtjo cʉ cja̱hni cʉm mɛjtigö, ir mɛjtiguɛ hne̱je̱. ʉm mɛjtigöhui göhtjo yʉ to i e̱me̱gui, como nuquiguɛ, ya xquí juajni‑yʉ́. Por rá ngue yʉm cja̱hnihui, da tti̱zquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nugö, ya xtrá tzoj nʉr jöy, pe gueguejʉ da gojtijʉ hua. Nugö, ya xtrá ma pʉ jabʉ guí bbʉy pa pé gu hmʉbi. Nuquɛ, ʉm Tzi Taqui, göhtjo rá zöqui, dí öhqui gui pɛhtzi tzʉ jer dyɛ yʉ cja̱hni yʉ xcú nzojtibi í tzi mʉyjʉ, gue yʉ xí ndɛngui. Gui föx‑yʉ pa da hnaadi cár mfe̱nijʉ. Gui cjajpi da hmʉpjʉ rá zö ncja ngu̱ dra hmʉjcöhui rá zö. ");
INSERT INTO otsNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bbʉ ndí bbʉjcöbbe yʉm amigo yʉ xí ndɛngui hua jar jöy, ndí föj‑yʉ́ co ni quer ttzɛdi, ndí manttɛy. Jøndi ca hnaatjo xí bbɛdi, gue ca hnar cja̱hni ca ya xi nguí pa̱di di bbɛdi. Cja̱ nuca̱ bi bbɛh‑ca̱ pa di ncumpli ca i ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nuya, ya xtrá magö pʉ jabʉ guí bbʉy. Ante que gu tzoj nʉr jöy, xtú öhqui yʉ nttödi‑yʉ, pa da hmʉpjʉ rá zö yʉm amigo yʉ xí ndɛngui, como ya xtá tzoj‑yʉ́. Gui cjaguɛ tzʉ pa da mpöjmʉ göhtjo mbo í mʉyjʉ, ncja ngu̱ dra mpöjcö. ");
INSERT INTO otsNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yʉ cja̱hni yʉ xí ndɛngui, ya xtú xijcö quer tzi palabra. Nu cʉ cja̱hni cʉ jin gui e̱me̱gui, jin gui ne da nú̱jʉ rá zö‑yʉ, como ya jí̱ í mɛjti nʉr mundo yʉm cja̱hnigö, ncja ngu̱guigö, jí̱ ʉ́r mɛjtigui nʉr mundo hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jin dí öhqui gui cjʉhtzi hua jar mundo yʉ cja̱hni yʉ xí hñemegui. Dí öhqui tzʉ gui manttɛy, gui föx‑yʉ́ pa jin da jiöti ca Jin Gui Jo. ");
INSERT INTO otsNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Como jí̱ ʉ́r mɛjtiguigö nʉr mundo, guejti yʉ to xí hñemegui, jí̱ í mɛjti nʉr mundo, hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gui wejqui tzʉ yʉm cja̱hni yʉ xí hñemegui, pa da cjajʉ ir mɛjtiguɛ, cja̱ pa da segue da dɛnijʉ quer palabra. I ma̱n ca ncjua̱ni quer tzi palabra. ");
INSERT INTO otsNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nuquiguɛ, gú pɛnquigö hua jar jöy pa gua nzoj yʉ cja̱hni, cja̱ xtú nzofo. Ncjapʉ hne̱je̱, ya xtá pɛjni yʉm amigo yʉ xí hñemegui, xtá cu̱j‑yʉ pa da bøni da nzoj yʉ pé dda cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ya xtár döjtiqui nʉm vida pa gu tu̱ ncja ngu̱ xcú mbe̱ni. Ya xtá tu̱gö pa da ccʉhtzibi göhtjo ca rá nttzo ca i tu̱ yʉ to xí hñemegui. Ncjapʉ da jogui pa guegue‑yʉ da cje ir mɛjti‑yʉ́ cja̱ da dɛndijʉ car palabra ca ncjua̱ni. ");
INSERT INTO otsNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pe jin gui jøntjo por rá ngue yʉ cja̱hni yʉ ya xí hñemegui dí öhqui. Guejtjo dí öhqui por rá ngue cʉ pé ddaa cʉ da hñemegui bbʉ xta dyøjmʉ quer tzi palabra, gue cʉ da nzoj yʉm möxte bbʉ xta bøn‑yʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Dí öhqui por rá ngue göhtjo cʉ to da hñemegui. Da hnaadi cár mfe̱nijʉ. Ncja ngu̱ dar hmʉjcöhui rá zö, ncjapʉ da hmʉpjʉ rá zö hne̱je̱ göhtjo‑cʉ, ʉm Tzi Taqui. Gui cjaguɛ tzʉ gu yojmʉ, nuquɛ, cja̱ co nigö, cja̱ guejti cʉ to da hñemegui, sa̱nta̱ da ntzixjʉ por rá nguejcöhui. Ncjapʉ da fa̱di, cierto, guehquiguɛ xcú pɛnqui hua jar jöy. ");
INSERT INTO otsNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ʉm Tzi Taqui, xcú cjaguɛ xí tti̱zquigö hua jar jöy. Nuya, ya xtrá magö. Gu cjagö da tti̱htzibi yʉm cja̱hnigö hne̱je̱, como dí yobbe‑yʉ. Da hnaadi cár mfe̱nijʉ, ncja ngu̱göhui, hnaadi ca dí mbe̱nihui cja̱ hnaadi cam hmʉyhui. Da ncjapʉ drí ni̱gui, ʉm cja̱hnigöhui‑yʉ́. ");
INSERT INTO otsNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nugö, gu yobbe‑cʉ, cja̱ nuquɛ, dí yojmi hne̱je̱. Gui cjaguɛ tzʉ da hmʉy rá zö cʉ to da hñemegui, como ngu̱ dra hmʉjcöhui rá zö, da hnaadi cár mfe̱nijʉ. Ncjapʉ da ba̱h cʉ cja̱hni cʉ jin gui e̱me̱, guehquɛ gú pɛnqui hua jar jöy. Guejtjo da ba̱dijʉ, nuquiguɛ, guí ne cʉ to i e̱me̱gui, ncja ngu̱ gri neguigö. ");
INSERT INTO otsNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nuquiguɛ, ʉm Tzi Taqui, xcú nzojtibi í mʉyjʉ yʉm cja̱hnihui, xcú cjajpi xí ndɛngui. Cja̱ nuya dí ne pa da hmʉ guegue‑yʉ́ pʉ jabʉ drá ma hmʉjcö. Dí negö, da cca̱htijʉ te tza ngu̱ i tti̱zquigö pʉ ji̱tzi, como nuquɛ, ya xi nguí negui bbʉ jim be mí ttøti nʉr mundo. ");
INSERT INTO otsNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nuquiguɛ, ʉm Tzi Taqui, göhtjo rá zö ca guí øte. Cʉ cja̱hni cʉ jin gui e̱me̱gui, jin gui pa̱di ja guí ncjaguɛ. Jøña̱guigö, ir Ttʉgui, dí bbʉbi desde ʉ́r mʉdi, cja̱ dí pa̱di göhtjo ja i ncja quer tzi mʉy. Guejti yʉ cja̱hni yʉ xí hñemegui i pa̱di, guehquiguɛ gú pɛnquigö. ");
INSERT INTO otsNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nuyʉ, ya xtú xijmʉ ja guí ncjaguɛ, cja̱ gu segue gu u̱jti‑yʉ, pa más da ba̱dijʉ. Gu segue gu yojme yʉm cja̱hnihui yʉ xí hñemegui, pa da netsjɛjʉ, ncja ngu̱ gri negui, ʉm Tzi Taqui. Ncjapʉ da hmʉpjʉ rá zö, ncjahmʉ guejquitsjɛgö gri bbʉ mbo ʉ́r mʉyjʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bbʉ ya xquí guadi xquí ma̱n yʉ palabra‑yʉ, bi bøn car Jesús, bi mɛhui quí möxte, bi ddaxijʉ car jñe̱ ca i tsjifi Cedrón. Bi ma gá möjmʉ jabʉ mí jø rá ngu̱ cʉ za gá olivo. Ya xquí nxu̱y. Bi ñʉti pʉ mbo cʉ za car Jesús cja̱ co quí möxte. ");
INSERT INTO otsNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Guejti car Judas Iscariote mí pa̱h car lugar‑ca̱, porque ya xi már ngu̱ vez car Jesús xquí mpɛjnihui quí amigo pʉ jar huerto‑ca̱. Nu car Judas, ya xti dö car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Diguebbʉ ya, car Judas bi ma bú tzí hnar compañía cʉ sundado, mbá yojmi cʉ dda nzʉttabi cʉ xcuí gu̱h quí jefe cʉ möcja̱ cja̱ co cʉ fariseo. Mbá tu̱jʉ linterna co za mbá zø, mír yojʉ‑cʉ. Guejtjo mbá cʉjʉ espada cja̱ co pé dda arma. ");
INSERT INTO otsNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nu car Jesús, ya xi mí pa̱di göhtjo te di ncjajpi, eso, bi bøni, bi ma bú ntjɛhui cʉ cja̱hni cʉ mbá cuati, cja̱ bi dyöni: ―¿Toca̱ guí jonijʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bi da̱j ya cʉ: ―Gue car Jesús, car mi̱ngu̱ Nazaret.― Cja̱ bi da̱j ya car Jesús: ―Guejquigö.― Guejti car Judas mbá yojmʉ cʉ sundado cja̱ co cʉ pé dda hñøjø cʉ xcuí hñe̱je̱. Guegue xcuí zí cʉ cja̱hni‑cʉ pa di zʉdijʉ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bbʉ mí ma̱n car Jesús: “Guejquigö,” cʉ hñøjø cʉ xcuí hñe̱je̱ pa di zʉdijʉ, bi ntji̱xtajʉ cja̱ bi fʉntzijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ma ya, car Jesús pé bi dyöni: ―¿Toca̱ guí jonijʉ?― Cja̱ pé bi ma̱jmʉ: ―Car Jesús, car mi̱ngu̱ Nazaret.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Car Jesús pé bi xijmʉ, bbʉ: ―Ya xtú xihquijʉ, guejquigö. Cja̱ bbʉ guejquigö guí jonguijʉ, gui jiɛguijʉ da ma yʉ pé ddaa.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Car Jesús bi xih cʉ sundado di jiɛjmʉ quí möxte, pa di cumpli car palabra ca xquí xih cár Tzi Ta. Guegue xquí ma̱: “Xtú pɛhtzi rá zö göhtjo cʉ hñøjø cʉ xcú nzojtibi í mʉyjʉ pa di dɛnguigö. Jí̱ xtá bbɛdi nim pa hnaa‑cʉ.” ");
INSERT INTO otsNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Diguebbʉ ya, car Simón Pedro bi ccohtzi cár espada jár ntto, cja̱ bi dyojquibi hnár gu̱ ca hnar muzo ca mí pɛjpi cár jefe cʉ möcja̱. Mí gue cár gu̱ jár lado derecho bi dyojquibi. Car muzo‑ca̱ mí ju̱ cár tju̱ju múr Malco. ");
INSERT INTO otsNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nu car Jesús nguetica̱ bi xih car Pedro: ―Fohtzi nir espada pʉ jár ntto. I nesta gu tzögöbbe nʉr prueba nʉ xí ddajqui cam Tzi Ta.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Diguebbʉ ya, cʉ sundado co cár capitánjʉ, cja̱ co cʉ nzʉttabi cʉ xcuí gu̱h quí jefe cʉ judio, bi zʉh car Jesús, cja̱ bi du̱htibijʉ quí dyɛ. ");
INSERT INTO otsNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Cja̱ bi dyɛnijʉ pʉ jár ngu̱ car Anás. Nu car Anás múr ndøjña̱ car da̱möcja̱. Car Caifás múr da̱möcja̱ car cjeya‑ca̱, mí mandadobi cʉ pé dda möcja̱. ");
INSERT INTO otsNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mí gue car Caifás xquí xih cʉ pé dda judio, di conveni bbʉ di bböhti hnaatjo ʉr hñøjø cja̱ jin di du̱ cʉ cja̱hni rá ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bbʉ mí ttɛn car Jesús pʉ jár ngu̱ car Anás, má tɛn car Simón Pedro co ca pé hnar möxte. Nu ca pé hnaa, mí mpa̱dihui car da̱möcja̱, gue car Caifás. Eso, bbʉ mí ñʉti car Jesús pʉ jár patio cár ngu̱ car da̱möcja̱, bi ñʉti pʉ hne̱je̱ ca pé hnaa quí möxte car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nu car Pedro már tøhmi pʉ tji, bi hmöjti pʉ jar goxtji. Diguebbʉ ya, ca hnar möxte ca mí mpa̱dihui car da̱möcja̱, bi ña̱hui car muza ca mí föh car goxtji. Ma ya car möxte‑ca̱ bi cʉhti car Pedro pʉ mbo. ");
INSERT INTO otsNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Cja̱ car muza ca mí föh car goxtji bi dyön car Pedro: ―¿Nuquiguɛ, cja jin guí ntzixihui nʉr hñøjø nʉ xpá ttziji?― Bi da̱j ya car Pedro, bi hñi̱na̱: ―Jin gui guejquigö.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cʉ muzo cʉ mí pɛh pʉ jar ngu̱‑ca̱, co cʉ nzʉttabi, már bböh pʉ jar patio. Xquí hñu̱dijʉ hnar tzibi gá tji̱ña̱, como már ntzɛ. Már pahtijʉ pʉ. Guejti car Pedro xquí guati jar tzibi, már bböh pʉ co cʉ muzo, már pahti hne̱je̱. Nu car Jesús, ya xquí ttzix pʉ mbo car ngu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Car da̱möcja̱ bi dyön car Jesús digue quí möxte cʉ mí ntzixihui, co hne̱je̱ ter bɛh ca̱ mí u̱jti‑cʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Car Jesús ya bi da̱di, i̱na̱: ―Rá ngu̱ vez ndí ña̱ pʉ jabʉ mí jmuntzi cja̱hni rá ngu̱. Segue ndí u̱jti cʉ cja̱hni pʉ jam ni̱cja̱jʉ, co hua jam templojʉ. Rá ngu̱ cʉ möcja̱ cja̱ co cʉ maestro cʉ i nxöh cam leyjʉ xí dyøde ter bɛh ca̱ dí ma̱. Jí̱ xtá ña̱gö gá ntta̱guitjo. ");
INSERT INTO otsNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Dyoca̱ guí öngui ter bɛh ca̱ ndí u̱jti, bbʉ? Gui dyön cʉ cja̱hni rá ngu̱ cʉ xí dyøh ca ndí ma̱. Gueguejʉ i pa̱di da xihqui.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bbʉ ya xquí ma̱ nʉr palabra‑nʉ car Jesús, hnáa digue cʉ nzʉttabi cʉ már bbʉh pʉ, bi uni hnar mpɛhti, cja̱ bi xifi: ―¿Dyoca̱ xcú tjá̱jti ncjanʉ nʉr da̱möcja̱?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Cja̱ pé bi da̱h car Jesús, bi hñi̱na̱: ―Bbʉ már nttzo ca xtú ma̱, ma̱nguɛ ya bbʉ, ¿ter bɛh ca̱ jí̱ mí tzö? Pe bbʉ már zö ca xtú ma̱, ¿dyoca̱ xcú ddajqui hnar mpɛhti bbʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Diguebbʉ ya, car Anás bi mandado di ttzix car Jesús pʉ jabʉ már bbʉh car da̱möcja̱. Nuca̱ mí ju̱ cár tju̱ju̱ múr Caifás. Nubbʉ, bi ttzix car Jesús, mí hnu̱htitjo quí dyɛ. ");
INSERT INTO otsNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Car Pedro ya, már bböjti pʉ jár patio cár ngu̱ car Anás, Már pahtitjo jar tzibi. Cja̱ hnaa cʉ cja̱hni cʉ már bböbi, bi dyöni: ―¿Nuquiguɛ, cja jin guí ntzixihui car hñøjø ca xpá ttzí hua?― Cja̱ guegue ya bi gøntjo, bi ma̱: ―Ji̱na̱‑gö.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Diguebbʉ ya, hna cʉ muzo cʉ mí pɛjpi car da̱möcja̱ bi dyön car Pedro: ―¿Cja jin guí guehquɛ xtú cca̱jtiqui nguí yojmi car Jesús pʉ jar huerto?― Car hñøjø ca bi dyön car Pedro, guegue múr pariente ca hnar muzo ca xquí ttojquibi hnár gu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nu car Pedro pé bi gøndi pé hnar vez. Nubbʉ, bi hna majti car ndøxca. ");
INSERT INTO otsNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Car hora‑ca̱, car Jesús már bbʉh pʉ jár ngu̱ car Caifás. Nubbʉ, cʉ sundado bi dyɛnijʉ, bi zixjʉ pʉ jár palacio car gobierno, cja̱ ya xi mír ma di ni̱gui. Nu cʉ judio jin gá ñʉti pʉ mbo car palacio, como már dyo pʉ cʉ gentile. Mí mbe̱n cʉ judio, már nttzo quí costumbre cʉ gentile, cja̱ bbʉ di ntjɛti‑cʉ, di contibi quí tzi mʉyjʉ, cja̱ ya jin di jogui di nú̱jʉ car mbaxcjua. Eso, mí tøhmitjojʉ pʉ tji. ");
INSERT INTO otsNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Por rá nguehca̱, car gobernador bi bøm pʉ tji pʉ jabʉ mí tøhmi cʉ judio, pa di nzoh‑cʉ́. Guegue mí ju̱ cár tju̱ju̱ múr Pilato. Bi bøni ya, bi dyön cʉ judio: ―¿Ter bɛh ca̱ xí dyøti nʉr hñøjø‑nʉ, eso xcú tzijʉ hua?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Cja̱ bi da̱jmʉ gueguejʉ: ―I ndu̱jpite. Bbʉ jí̱ xtrú dyøti ca rá nttzo, jí̱ xcrú tzije hua.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Diguebbʉ ya car Pilato bi xijmʉ: ―Nuquɛjʉ, rí ntzöhui gui tzixjʉ cja̱ gui juzgajʉ ncja ngu̱ ga ma̱n quer leyjʉ.― Cja̱ pé bi da̱h cʉ judio, bi hñi̱na̱jʉ: ―Jin gui jɛguije car ley gu castigaje hnar cja̱hni ca i nesta da bböhti.― Como jí̱ mí tjɛh cʉ judio di möhtijʉ hnar cja̱hni ca xquí njuzga, quí jefe cʉ judio bi döjʉ car Jesús pʉ jár dyɛ car gobernador romano pa di un car sentencia gá du̱. ");
INSERT INTO otsNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ncjanʉ gá nzʉh car palabra ca xquí ma̱n car Jesús, di ddøti pʉ jar ponti pa di du̱ pʉ. Como mí gue cʉ romano cʉ mí tøti pʉ ja ponti cʉ cja̱hni cʉ mí ndu̱jpite. ");
INSERT INTO otsNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Diguebbʉ ya, car Pilato pé bi ñʉti pʉ mbo car palacio, cja̱ bi nzojni car Jesús, bi dyöni: ―¿Cja guehquiguɛ ʉ́r reyqui cʉ judio?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Cja̱ bi da̱j ya car Jesús: ―¿Cja guehquitsjɛguɛ guí ne gui dyöngui‑nʉ, cja huá to xí xihqui gui dyöngui ncjanʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bi da̱j ya car Pilato, bbʉ: ―Xigö, ¿cja dúr judiogö pa gua önqui ncjanʉ? Gue quir cja̱hnitsjɛ cja̱ co cʉ möcja̱ cʉ i mandadobi‑cʉ́ xpá nziqui hua, xí ndöqui jam dyɛ. ¿Ter bɛh ca̱ xcú dyøte?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Cja̱ pé bi da̱h car Jesús: ―Cam cargo dí ja̱gö jin gui jñɛjmi cár cargo yʉ rey hua jar jöy. Bbʉ gur reygö hua jar mundo, nubbʉ, di möxqui cʉm mɛfi, di ntu̱jnihui cʉ to i ʉgui pa jin gua tzo jáy dyɛ‑cʉ. Nugö, hnahño cam cargo dí ja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Diguebbʉ ya, pé bi dyön car Pilato, bbʉ: ―¿Cja nde̱jma̱ gúr reyguɛ bbʉ?― Cja̱ bi da̱j ya car Jesús: ―Ja̱a̱, ncja ngu̱ gri ma̱nguɛ, dúr reygö. Nugö dú hmʉy cja̱ dá e̱jcua jar jöy pa gu xij yʉ cja̱hni ja i ncja ca ncjua̱ni. Göhtjo cʉ cja̱hni cʉ i ne da dɛn car palabra ca ncjua̱ni, guegue‑cʉ i e̱me̱ ca dí ma̱― ");
INSERT INTO otsNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Cja̱ pé bi ma̱n car Pilato, bbʉ: ―¿Ter bɛh car palabra ca ncjua̱ni?― Nu car Pilato, bbʉ ya xquí dyön nʉr nttöni‑nʉ, pé bi bøm pʉ jabʉ mí tøhmi cʉ judio, cja̱ bi xih‑cʉ́: ―Jin te dí töhtibi ca rá nttzo xtrú dyøti car cja̱hni ca xcú döjquijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nuquɛjʉ, guí judiojʉ, guí pɛhtzijʉ hnar costumbre, cada ncjeya bbʉ i ncja na̱r mbaxcjua na̱ guí tzöjʉ ya, guí mandadojʉ pa da tsjojqui car preso ca da gustaquijʉ. ¿Cja jin guí nejʉ da tsjojqui ya car hñøjø ca i tsjifi ir reyjʉ?― ");
INSERT INTO otsNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nubbʉ, göhtjo cʉ judio bi ncötijʉ, bi majmʉ nzajqui, i̱na̱jʉ: ―Jin gui xojqui car hñøjø‑ca̱. Dí neje gui xojqui car Barrabás.― Nu car Barrabás múr be̱, már ndo nttzo. ");
INSERT INTO otsNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Diguebbʉ ya, car Pilato bi mandadobi cʉ sundado di zix car Jesús cja̱ di jiʉtijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Cʉ sundado ya, bi mejʉ hnar corona gá hmini, cja̱ bi jñu̱htzijʉ car Jesús. Diguebbʉ ya bi jejtijʉ hnar da̱jtu̱ már ncjʉjpöy. ");
INSERT INTO otsNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Cja̱ mí burlabijʉ car Jesús, ncjahmʉ múr rey. Mí cuatijʉ, mí xijmʉ: ―¡Que viva! Guehquiguɛ ʉ́r reyqui cʉ judio.― Guejtjo mí cuajtibijʉ mpɛhti jár jmi. ");
INSERT INTO otsNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma ya, pé bi bøn car Pilato pʉ jabʉ mí bbʉh cʉ judio, bi gʉjqui car Jesús pa di jianti cʉ cja̱hni. Cja̱ bi xijmʉ: ―Tji nʉr hñøjø nʉ xcú döjquijʉ. Pé xtú tziji pa gu xihquijʉ, ya xtú juzga, cja̱ jin te dí töhtibi ca rá nttzo ca xtrú dyøte.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nubbʉ, bi bøn car Jesús, mbá ju̱xti cár corona gá hmini, guejtjo mí pötitjo car da̱jtu̱ már ncjʉjpöy. Nubbʉ, car Pilato bi xih cʉ cja̱hni: ―Tji nʉr cja̱hni‑nʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nu quí jefe cʉ möcja̱, co cʉ nzʉttabi, bbʉ mí cca̱htijʉ car Jesús, bi ncötijʉ, bi majmʉ nzajqui: ―¡Da ddøti jar ponti! ¡Da ddøti jar ponti!― Car Pilato ya bi xijmʉ: ―Nuquɛjʉ, bbʉ guí ne gui tzixjʉ ya, cja̱ gui tøtijʉ jar ponti, gui cjajpijʉ ya. Nugö, jin te xtá töhtibi ca már nttzo.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Diguebbʉ ya quí jefe cʉ judio bi da̱dijʉ: ―Nugöje, dí pɛhtzije hnar ley, cja̱ i ma̱n cam leyje i nesta da du̱ nʉr hñøjø‑nʉ, como i ne da cjatsjɛ ʉ́r Ttʉ ca Ocja̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nu car Pilato, bbʉ mí dyøj nʉr palabra‑nʉ, más mí ndo ntzu̱ bbʉ, como mí yomfe̱ni, ¿to ʉr hñøjø‑nʉ? ");
INSERT INTO otsNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Cja̱ pé bi ñʉti pé hnar vez pʉ mbo car palacio, pa di ña̱hui car Jesús. Cja̱ bi dyöni: ―Nuquiguɛ, ¿jabʉ xquí hñe̱je̱?― Nu car Jesús jin gá nda̱di. ");
INSERT INTO otsNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ma ya, car Pilato pé bi xifi: ―¿Dyoca̱ jin guí tja̱jtigui? ¿Cja jin guí pa̱di, dí pɛhtzigö cam cargo pa gu mandado. Bbʉ gu mandado pa da tsjoquiqui, nubbʉ, xquí ma libre, bbʉ, cja̱ bbʉ gu mandado pa da ddøjtiqui jar ponti, nubbʉ, xquí tu̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nu car Jesús ya bi da̱di: ―Rí hñe̱ ji̱tzi car cargo guí pɛhtziguɛ. Bbʉ jin di ddahqui ʉr tsjɛjqui ca Ocja̱ pa güi mandado, jin di jogui te güi cjaguigö, bbʉ. Nu car cja̱hni ca más xí dyøti ca rá ndo nttzo ni ndra nguehquɛ, gue ca hnár jefe yʉ judio ca xí döguigö jer dyɛ pa da bböjtigui.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Car Pilato ya, bbʉ mí dyøj nʉr palabra‑nʉ, mí ne di xohti car Jesús, cja̱ bi jion car manera pa di uni hnahño ʉr castigo, jin di bböhti. Nu car jmundo cʉ cja̱hni cʉ már bbʉh pʉ, pé bi majmʉ nzajqui, mí i̱na̱jʉ: ―Nuquiguɛ, bbʉ gui xojqui nʉr hñøjø‑nʉ, jin guí föx car rey César, bbʉ. Hnar cja̱hni ca i ne da cjatsjɛ ʉr rey, i ne da contrabi car rey.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Car Pilato, bbʉ mí dyøj nʉr palabra nʉ mí ma̱n cʉ judio, pé bi gʉjqui car Jesús pʉ jabʉ mí bbʉh‑cʉ. Cja̱ guegue car Pilato bi mi̱h pʉ jar ndo tjujni jabʉ mí juzga cʉ cja̱hni. Car tjujni‑ca̱ mí tix pʉ xøtze hnar plataforma gá me̱do. Car lugar‑ca̱, mí xijmʉ Gabata cʉ cja̱hni cʉ mí ña̱jʉ gá hebreo, tzʉdi, car lugar pʉ jabʉ xí cjöti doo. ");
INSERT INTO otsNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bbʉ mí mi̱h pʉ jar tjujni car Pilato pa di juzga car Jesús, ya xi mí ju̱ xadi, múr vispera car mbaxcjua. Nubbʉ, car Pilato bi xih cʉ judio: ―¡Tji nir reyjʉ, ra bböjcua!― ");
INSERT INTO otsNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nu cʉ judio pé bi ndo majmʉ nzajqui: ―¡Da bböhti‑nʉ! ¡Da bböhti‑nʉ! ¡Da ddøti jar ponti!― Car Pilato ya pé bi dyöni: ―¿Cja guí nejʉ da ddøti jar ponti nir reyjʉ?― Cja̱ bi da̱h cʉ möcja̱ cʉ mí mandado: ―Jin tema rey dí pɛhtzije, jøndi car César.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bbʉ mí dyøj ya‑nʉ car Pilato, bi dö car Jesús jáy dyɛ quí jefe cʉ judio pa di ddøti jar ponti. Nubbʉ, guegue‑cʉ bi dyɛnijʉ car Jesús pa du bböhti. ");
INSERT INTO otsNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nubbʉ, car Jesús bi bøm pʉ jar ciudad Jerusalén, bi ncjajpi bi ndu̱xtja cár ponti. Bi bønijʉ gá möjmʉ ca hnar lugar ca mí ju̱ cár tjuju múr Xímo, cja̱ guejtjo mí tsjifi Golgota, digue car jña̱ hebreo. ");
INSERT INTO otsNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bbʉ ya xquí zønijʉ jar lugar‑ca̱, cʉ sundado bi døtijʉ car Jesús pʉ jar ponti. Guejtjo pé bi døtijʉ yo hñøjø ja ponti hne̱je̱, hna‑hná hnanguadi car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Cja̱ car Pilato bi mandado di ttøhtibi hnar seña pa di ncuajti pʉ jár ña̱ car ponti pʉ jabʉ mí ddøti car Jesús. Car seña mí ma̱ ncjahua: “Gue na̱r Jesús‑na̱, ʉr mi̱ngu̱ Nazaret, ʉ́r rey yʉ judio.” ");
INSERT INTO otsNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bi tju̱x car seña‑ca̱ gá jñu̱ idioma. Bi tju̱tzi gá hebreo, cja̱ co gá griego, cja̱ co gá latín. Rá ngu cʉ cja̱hni judio bi cca̱htijʉ car seña‑ca̱, como már nzøtihui car ciudad Jerusalén car lugar pʉ jabʉ bi ddøti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Cja̱ bbʉ mí cca̱hti car seña‑ca̱ quí jefe cʉ möcja̱, guegue‑cʉ bi nzojmʉ car Pilato, bi xijmʉ: ―Car seña ca xcú dyøtijʉ, jin gui tzö ga ma̱: “ʉ́r rey yʉ judio.” Mejor da ma̱: “I ma̱ntjsɛ guegue‑na̱, ʉ́r rey yʉ judio.”― ");
INSERT INTO otsNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nu car Pilato bi da̱jti: ―Da ncjadinʉ car seña, como ya xí ttøte.― ");
INSERT INTO otsNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nu cʉ sundado, bbʉ ya xquí døtijʉ car Jesús pʉ jar ponti, bi jmuntzibijʉ quí da̱jtu̱, cja̱ bi jejque gá go parte. Cada hnar sundado bi tocabi hnaa quí da̱jtu̱ car Jesús. Guejtjo bi ga̱jʉ cár pajni. Nuca̱ már ma, cja̱ como jin te mí bbʉ ʉ́r ttɛdi‑ca̱, bi mbe̱nijʉ jin di xɛjquijʉ. Car da̱jtu̱‑ca̱ xquí bbe hnaatjo ʉ́r pedazo, desde ca hnár nttza̱ni hasta ca pé hnaa. ");
INSERT INTO otsNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Eso, bbʉ mí cca̱hti‑ca̱ cʉ sundado, bi ma̱jmʉ: ―Jin gu xɛjquijʉ‑na̱. Mejor gu ɛntzijʉ bolado pa gu pa̱dijʉ toca̱ da ga̱tzi.― Cja̱ bi cjajpijʉ bbʉ. Ncjanʉ gá nzʉh car palabra ca i ju̱x pʉ jar Escritura, pʉ jabʉ i ma̱: Cʉ cja̱hni bi jejqui cʉm da̱jtu̱ cja̱ bi ga̱tzi, Bi dyɛntzijʉ bolado pa di ba̱dijʉ toca̱ di cjajpi ʉ́r mɛjti cam pajni ndí je. Bi ncjanʉ gá dyøti cʉ sundado ncja ngu̱ ga ma̱m pʉ jar Escritura. ");
INSERT INTO otsNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bbʉ mí ddøti car Jesús pʉ jar ponti, cár me már bböh pʉ cerca. Mí yojmi cár zijtzi car Jesús, cja̱ co pe yojo bbɛjña̱. Ca hnáa múr bbɛjña̱ car Cleofas, cja̱ mí ju̱ cár tjuju múr María. Cja̱ ca pé hnáa mí tsjifi María Magdalena, como múr mi̱ngu̱ Magdala. ");
INSERT INTO otsNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nu car Jesús, bbʉ mí cca̱hti cár me már bböh pʉ cerca, co hne̱h ca hnaa quí möxte ca más mí ndo ntzixihui, guegue bi nzoh cár me, bi xifi: ―Nuquɛ, me, tji nir ttʉ.― Mí ña̱ digue ca hnár möxte már bböh pʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma ya, bi nzoh car möxte‑ca̱, bi xifi: ―Gui nú̱ tzʉ‑nʉ, ncjahmʉ dir me.― Desde car pa‑ca̱ car möxte ca bi ttzofo bi cuajti cár me car Jesús pʉ jár ngu̱ guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Diguebbʉ ya, bbʉ mí zö car Jesús, ya xti du̱, bi ma̱: ―Dí tu̱tje.― Bbʉ mí ma̱ ncjanʉ, bi zʉh ca hnar palabra ca i ju̱x pʉ jar Escritura. Como i ma̱m pʉ, di ttuni vinagre pa di zi. ");
INSERT INTO otsNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Már jø pʉ jar jöy hnar bbada, hnanguadi pʉ jabʉ mí bbʉh cʉ sundado, mí ñuxi vinagre. Diguebbʉ ya, hna cʉ sundado bi jña̱ hnar esponja, bi zihmi jar vinagre, cja̱ bi fohtzi hnar tzi za ca mí tsjifi ʉr hisopo. Bi pahtzi‑ca̱, bi cuajti pʉ jár ne car Jesús pa di zʉhtzi. ");
INSERT INTO otsNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Car Jesús bi zʉhtzi car vinagre bbʉ, cja̱ bi ma̱: ―Ya xí nzʉdi göhtjo ca mí nesta di ncja.― Nubbʉ, bi ñe̱jmi, bi döjti cár tzi mʉy pʉ jáy dyɛ car Tzi Ta, bi du̱. ");
INSERT INTO otsNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bbʉ mí du̱ car Jesús, múr vispera ca hnar ndo mbaxcjua, cja̱ ya xquí nde. Cʉ judio mí ne di dɛjquijʉ quí cuerpo cʉ to xquí ddøti pʉ ja ponti, pa jin di hmʉjti pʉ car pa gá mbaxcjua, como mí tzu̱jpijʉ car pa‑ca̱, már ndo ma̱di. Eso, guegue‑cʉ bi dyöjpi car Pilato di mandado pa di nwajquibi quí hua cʉ to mí ddøti ja ponti, pa di du̱ nttzɛdi‑cʉ cja̱ di hnu̱x quí cuerpojʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Por rá nguehca̱, cʉ sundado bi wajquibi hna‑hnáa quí huahui cʉ yo be̱, pa nguetica̱ di du̱hui, tanto ca hnaa ca mí bbʉ jár derecho car Jesús, tanto ca hnaa ca mí bbʉ jár nccuarga. ");
INSERT INTO otsNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pe bbʉ mí zønijʉ pʉ jar ponti jabʉ mí ddøti car Jesús, bi cca̱htijʉ, ya xquí du̱‑ca̱, eso jin gá wajquibijʉ quí hua. ");
INSERT INTO otsNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nu ca hnar sundado ca mbá ja̱ hnar lanza, nde̱jma̱ bi tjohtibi cár ngø car Jesús, pʉ jáy bbøtze, cja̱ bi bøngui cji, mí yojmi deje. ");
INSERT INTO otsNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nugö xtú juxcö ya palabra‑ya, dú cca̱hti göhtjo te bi ncja, cja̱ dí xihquijʉ ca ncjua̱ni. Como dú cca̱hti bbʉ mí ncja, dí pa̱di, cierto göhtjo yʉ xtú ju̱xcua, cja̱ dí xihquijʉ pa gui hñemejʉ hne̱je̱, nuquɛjʉ, como ngu̱ gri cca̱htijʉ na̱r libro‑na̱. ");
INSERT INTO otsNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jin gá nwajquibi quí hua car Jesús. Nu cár ngø, pʉ jáy bbøtze, bi ntjohtibi‑cá̱. Bi ncjapʉ gá ncumpli yojo palabra cʉ i ma̱m pʉ jar Escritura. Ca hnaa i ma̱: “Car tzi dɛti ca da bböhti, jin da nwajquibi tema ndodyo.” ");
INSERT INTO otsNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Cja̱ i ma̱n ca pé hnaa: “Cʉ cja̱hni cʉ bi tjohtibi cár cuerpo cár jmandadero ca Ocja̱, pé xta cca̱htijʉ‑ca̱.” ");
INSERT INTO otsNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bbʉ ya xquí ncja‑yʉ, bú e̱h hnar hñøjø, mí ju cár tjuju múr José, múr mi̱ngu̱ Arimatea. Guegue mí e̱me̱, xcuí hñe̱h ca Ocja̱ car Jesús, pe jí̱ mí ne di ncjua̱ni, como mí tzu̱ quí jefe cʉ judio. Car José ya, bi guati car gobernador Pilato, cja̱ bi dyöjpi ʉr tsjɛjqui di ma du pɛhtzi cár cuerpo car Jesús. Cja̱ car Pilato bi ungui ʉr tsjɛjqui. Eso, bi ma car José gá ndu̱htzibi cár cuerpo car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Guejtjo bú e̱h car Nicodemo. Guegue‑ca̱ xquí jion car Jesús ca hnar vez bbʉ mí nxu̱y. Nuya, bi guati pʉ jabʉ di cjöhtibi cár cuerpo car Jesús. Mbá tu̱ como treinta quilo hnar hñi̱tji̱ ca mí yʉni rá ncʉji, pa di dyʉhtzibi cár cuerpo car Jesús. Múr polvo car hñi̱tji̱‑ca̱, mí yojmi mirra co áloe. ");
INSERT INTO otsNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Car José bi mföxihui car Nicodemo, bi du̱xihui cár cuerpo car Jesús, cja̱ bi jojquihui co ni car polvo rá ncʉji. Mí pantihui tzi da̱jtu̱ gá tira. Mí ncjapʉ nguá jojqui quí ánima cʉ judio bbʉ mí öjmʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mí bbʉh hnar huerto cerca pʉ jar lugar pʉ jabʉ bi ddøti car Jesús jar ponti, cja̱ pʉ jar huerto‑ca̱ mí bbʉh hnar cueva gá nttögui. Ya xquí tjojqui car cueva, pe jí̱ bbe mí cjöti pʉ tema ánima. ");
INSERT INTO otsNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bi mpɛguijʉ, bi götijʉ cár cuerpo car Jesús pʉ jar cueva‑ca̱, porque már cerca pʉ jabʉ xquí du̱, cja̱ guejtjo porque ya xi múr víspera cár mbaxcjua cʉ judio, cja̱ jin te mí pɛjmʉ car pa gá mbaxcjua. ");
INSERT INTO otsNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Car primero ʉr pa car semana, bi ma car María Magdalena ndo nxu̱ditjo pʉ jabʉ xquí cjöti cár cuerpo car Jesús. Jí̱ tza bbe mí ni̱gui bbʉ mí ma. Bi zøti pʉ jar cueva pʉ jabʉ xquí cjöti cár cuerpo, cja̱ bi cca̱hti, ya xquí ccʉhtzi car ndo me̱do pʉ jar goxtji, xquí ma hnanguadi. ");
INSERT INTO otsNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bbʉ mí cca̱hti‑ca̱ car María, bi gʉ ʉr ddiji, bi ma pʉ jabʉ mí bbʉh car Pedro cja̱ co ca hnaa quí möxte car Jesús ca más mí ntzixihui, cja̱ bi xih‑cʉ: ―Xí hnu̱htizibi cár cuerpo cam Tzi Jmu̱jʉ. Ya jí̱ rá bbʉh pʉ jabʉ bi cjöti, cja̱ jin dí pa̱dije jabʉ xcá hnu̱x ya.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bbʉ mí dyøj ya‑ca̱, car Pedro co ca pé hnaa quí möxte car Jesús bi bøm pʉ jar ciudad, bi ma nttzɛdi gá mɛhui pʉ jar cueva. ");
INSERT INTO otsNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bi tijmi car Pedro co ca pé hnar hñøjø ca más mí ntzixhui car Jesús. Cja̱ car Pedro bi ttzo xʉtja. Nu ca pé hnaa bi da̱ja̱, bbɛto bi zøti pʉ jabʉ xquí cjöhtibi cár cuerpo car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Cja̱ bi am pʉ jar goxtji car cueva, bi cca̱hti pʉ mbo, xquí ttzoh pʉ cʉ da̱jtu̱ cʉ xquí bbanti cár cuerpo car Jesús. Nu car möxte‑ca̱, jim be mí cʉti pʉ mbo car cueva. ");
INSERT INTO otsNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Diguebbʉ ya, pé bi zøti car Simón Pedro, mbá ntɛnihui ca pé hnaa. Guegue ya bi ñʉti jar cueva, cja̱ bi cca̱hti ja már ncja cʉ da̱jtu̱. ");
INSERT INTO otsNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Car bayo ca xquí hnu̱htibi cár ña̱ car Jesús, jí̱ mí yojmi cʉ pé ddaa. Hnani már bbʉy, xquí bbantzi. ");
INSERT INTO otsNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bbʉ ya xquí ñʉti pʉ mbo car Pedro, diguebbʉ ya, pé bi ñʉti ca pé hnaa ca bbɛto xquí zøte. Guejti‑ca̱ bi cca̱hti ja már ncja cʉ da̱jtu̱. Nubbʉ, bi hñeme car möxte‑cá̱, cierto ya xquí jña̱ ʉ́r jña̱ car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hasta car hora‑ca̱, jí̱ bbe mí ntiendejʉ quí möxte car Jesús car palabra ca i ma̱m pʉ jar Escritura, bbʉ di hñe̱h ca hnar hñøjø ca xtrú hñi̱x ca Ocja̱, guegue mí nesta di du̱ cja̱ pé di nantzi. Nu car hora‑ca̱, bi ntiendejʉ cja̱ bi hñe̱mejʉ bbʉ́. ");
INSERT INTO otsNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Diguebbʉ ya cʉ yojo‑cʉ bi ma í ngu̱hui, bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nu car María Magdalena xcuí goh pʉ jar cueva, pʉ jabʉ xquí cjöti car ánima már bböjti pʉ tji, már zontjo. Bi ani, bi cca̱hti pʉ mbo. ");
INSERT INTO otsNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bi cca̱hti yojo anxe mí je ttaxi da̱tu̱, már ju̱ pʉ mbo, pʉ jabʉ xquí cjötijma̱ car ánima. Ca hnaa már ju̱h pʉ jabʉ xquí cjöxjma̱ cár ña̱ car Jesús, nu ca pé hnaa ya már ju̱h pʉ jabʉ xquí bbojma̱ quí hua. ");
INSERT INTO otsNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Guegue cʉ anxe bi xijmi car María: ―Nuquɛ, na̱na̱, ¿dyoca̱ guí zoni?― Cja̱ bi da̱h car María: ―Porque xí hnu̱htzibi cár cuerpo ca ndom Tzi Jmu̱je, cja̱ jin dí pa̱di jabʉ xí cjöti.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bbʉ mí ma̱ ncjapʉ, car María bi bböti, bi cca̱hti car Jesús már bböh pʉ. Pe jin gá meya toca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma ya, car Jesús pé bi dyön car María: ―Nuquiguɛ, na̱na̱, ¿dyoca̱ guí zoni? ¿Toca̱ guí joni?― Nu car María bi mbe̱ni má̱s mí gue car hñøjø ca mí föh car huerta, cja̱ bi da̱di: ―Nuquɛ, tada, bbʉ guehquiguɛ xcú tu̱x cam tzi ánimaje, gui xijqui tzʉ jabʉ xcú cöti, cja̱ nugö gu ma tu̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Diguebbʉ ya, car Jesús bi nømbi cár tju̱ju̱, bi nzofo, i̱na̱: ―¡Nuquɛ, María!― Nubbʉ, bi bböti car María, pé bi da̱di gá hebreo, car jña̱ ca mí ña̱ gueguejʉ, bi xifi: ―¡Nuquɛ, Raboni!― Na̱r palabra‑na̱ i ne da ma̱ Maestro. Cja̱ bbʉ mí ma̱ ncjanʉ, car María mí ne di zɛti car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Diguebbʉ ya car Jesús bi xifi: ―Dyo guí tza̱mbigui, como jim pe dí pøx pʉ jabʉ bí bbʉh cam Tzi Tagö. Nuquiguɛ, gui ma pʉ jabʉ rá bbʉh cʉm hñohui, cja̱ gui xijmʉ, nugö, ya xtrá pøxcö pʉ jabʉ bí bbʉh cam Tzi Tagö, gue quer Tzi Tajʉ hne̱je̱. Ya xtrá pøx pʉ jabʉ bí bbʉh ca Ocja̱ ca bú pɛnquigö, gue ca Ocja̱ ca xcú hñemejʉ hne̱je̱.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Diguebbʉ ya car María Magdalena bi ma gá ma pʉ jabʉ már bbʉh quí möxte car Jesús, cja̱ bú xih‑cʉ́: ―Xtú cca̱htigö cam Tzi Jmu̱jʉ Jesús. Ya xí nantzi‑ca̱.― Cja̱ pé bi xijmʉ cʉ pé dda palabra cʉ xquí ma̱n car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Bbʉ ya xquí nde, exque gue car pa‑ca̱, car primero ʉr pa car semana, bi jmuntzi quí möxte car Jesús, bi gotijʉ cʉ goxtji, como mí ntzu̱jʉ, certa di zʉdijʉ quí jefe cʉ judio. Nubbʉ, car Jesús bi hna ni̱guitjo pʉ jabʉ már bbʉh‑cʉ. Bi hmöh madé cja̱ bi nzofo, bi xijmʉ: ―Dyo guí ntzu̱jʉ. Gui hmʉpjʉ rá zö.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bbʉ xquí ma̱ ncjanʉ car Jesús, bi tʉngui quí dyɛ cja̱ bi xohtzi cár bbøtze, bi u̱jti‑cʉ. Cja̱ bi cca̱hti quí möxte, bi meyajʉ car Tzi Ta Jesús. Nubbʉ, bi ndo mpöjmʉ bbʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma ya, car Jesús pé bi xih‑cʉ: ―Dyo guí ntzu̱jʉ, gui hmʉpjʉ rá zö. Ncja ngu̱ guá ngujqui hua jar jöy cam Tzi Ta, cja̱ dú e̱cua, nuya dí cu̱hquijʉ pa gui pønijʉ, ma grí nzojmʉ cʉ pe dda cja̱hni. ");
INSERT INTO otsNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bbʉ mí guadi mí ma̱n car palabra‑ca̱, bi juijni quí möxte, bi xijmʉ: ―Dí ddahquijʉ car Tzi Espíritu Santo pa gui yojmʉ‑ca̱. ");
INSERT INTO otsNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Guejtjo dí ddahqui quer cargojʉ pa gui xijmʉ cʉ cja̱hni cʉ da hñemegui, ca Ocja̱ ya xí perdonabi ca rá nttzo ca xí dyøtijʉ. Guejti cʉ cja̱hni cʉ jin da hñemegui, dí ddahqui quer cargojʉ gui xijmʉ‑cʉ́, i tu̱di ca rá nttzo ca xí dyøtijʉ. Ca Ocja̱ jin da perdonabi cʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mí bbʉh ca hnaa quí möxte car Jesús, mí ju̱ cár tju̱ju̱ múr Tomás, guejtjo mí tsjifi ʉr Cuate. Ca hna xu̱y bbʉ mí ni̱gui car Jesús pʉ jabʉ xquí jmuntzi quí möxte, jí̱ már bbʉh pʉ car Tomás. ");
INSERT INTO otsNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eso, cʉ pé dda möxte bi xijmʉ car Tomás bbʉ mí ntjɛjʉ: ―Xtú cca̱htije cam Tzi Jmu̱jʉ Jesús. Ya xí jña̱ ʉ́r jña̱.― Nu car Tomás ya bi da̱di: ―Nugö, i nesta gu cca̱htibi quí dyɛ cja̱ co cár bbøtze, pa gu fojti nʉm xö pʉ jabʉ bi ntjohtibi. Cja̱ bbʉ ji̱na̱, jin gu e̱me̱gö, ¿cja xtrú jña̱ ʉ́r jña̱ guegue?― ");
INSERT INTO otsNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Cja̱ bbʉ mí zʉ ñojto, quí möxte car Jesús pé bi jmu̱ntzi pʉ mbo car ngu̱. Car pa‑ca̱, guejti car Tomás már bbʉbi cʉ pé ddaa. Car Jesús, pé hnar vez bi ñʉti pʉ jabʉ már bbʉpjʉ, már cjotitjo cʉ goxtji. Bi hmöh pʉ madé, cja̱ bi nzoh quí möxte, pé bi xijmʉ: ―Dyo guí ntzu̱jʉ, gui hmʉpjʉ rá zö.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma ya bi nzoh car Tomás, bi xifi: ―Nuquiguɛ, Tomás, gui cca̱hti ya yʉm dyɛ, cja̱ gui fohtzi quer xö hua jabʉ bi ntjojtigui. Gui jiɛj ya ca guír yomfe̱ni, ¿cja cierto xtú jña̱ ʉm jña̱gö? Gui hñemegui ya.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Bi da̱j ya car Tomás, bi xifi: ―Nuquɛ, ʉm Tzi Jmu̱qui, gú Ocja̱‑guɛ, dí e̱me̱qui.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Diguebbʉ ya, car Jesús bi xifi: ―Tomás, guehca̱ xquí cca̱hti ya seña‑ya, eso xcú hñemegui. Más da ndo mpöh cʉ cja̱hni cʉ jí̱ xcá cca̱jtigui pe nde̱jma̱ da hñemegui.― ");
INSERT INTO otsNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Car Jesús pé bi dyøti pé dda milagro már ngu̱, cja̱ bi cca̱htijʉ quí möxte. Jin gui ju̱xcua na̱r libro‑na̱ göhtjo cʉ milagro cʉ bi dyøte. ");
INSERT INTO otsNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yʉ tengu̱tjo xtú ju̱xcua da sirve pa gui hñemejʉ, car Jesús mí gue car Cristo ca xquí hñi̱x ca Ocja̱, guegue múr Ttʉ‑ca̱. Xí ttøti na̱r libro‑na̱ pa gui hñemejʉ guegue, cja̱ pa gui pɛhtzijʉ car nzajqui ca jin da tjegue. ");
INSERT INTO otsNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bbʉ ya xquí tzi cja mpa, pé bi ni̱gui car Jesús pʉ jabʉ már bbʉh quí möxte. Guegue‑cʉ má dyojʉ ca hnanguadi car mar ca i tsjifi Tiberias. Bi ncjahua gá ni̱gui guegue. ");
INSERT INTO otsNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Car pa‑ca̱, már yojmʉ cʉ ddaa quí möxte car Jesús: car Simón Pedro, car Tomás, ca guejtjo mí tsjifi ʉr Cuate, car Natanael ca múr mi̱ngu̱ Caná pʉ jar jöy Galilea, cʉ yojo quí ttʉ car Zebedeo, cja̱ co pé dda yojo cʉ hñøjø cʉ xquí dɛn car Jesús hne̱je̱. ");
INSERT INTO otsNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Bi ma̱n car Simón Pedro, bi xih cʉ pé ddaa: ―Gu ma pamöy.― Bi da̱j ya cʉ ddaa hne̱je̱: ―Guejquitjogöje, gu möjö.― Bi möjmʉ bbʉ, bi ñʉtijʉ hnar barco, bi jaxi ʉr xu̱y, bú pamöyjʉ, pe jin te gá nzʉdijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bbʉ ya xní ni̱gui, bi jiantijʉ hnar hñøjø, már bböj nʉ jár nttza̱ni car mar. Nu cʉ hñøjø cʉ már pamöyjʉ jin gá mba̱dijʉ, ¿cja gue car Jesús‑ca̱? ");
INSERT INTO otsNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Diguebbʉ ya, car Jesús bi mahti, bi dyönijʉ: ―Nuquɛjʉ, ¿cja ya xcú tzʉdijʉ hnar möy?― Cja̱ bi da̱h quí möxte, bbʉ: ―Ujtjo, nim pa hnáa xtá tzʉdije.― ");
INSERT INTO otsNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Diguebbʉ ya, car Jesús bi xijmʉ: ―Gui dyɛntijʉ ya quer hmamöyjʉ jar derecho nʉr barco, cja̱ xquí tzʉdijʉ, bbʉ.― Cja̱ bi cjajpijʉ. Nubbʉ, bi ndota ñu̱x car hmamöy cʉ möy, ya xti xɛgui. Ya jí̱ mí jöti di gʉxijʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Diguebbʉ ya, ca hnaa quí möxte car Jesús ca más mí ntzixihui bi nzoh car Pedro, bi xifi: ―¡Gue nʉm Tzi Jmu̱jʉ‑nʉ!― Nu car Pedro, bbʉ mí dyøde, mí gue car Jesús már bböj nʉ, bi hna jie cár pajni, como ya xquí møgue, cja̱ bi hna hñɛnti jar mar, bi mfɛti jar deje pa gá nzøni nttzɛdi nʉ jabʉ már bbʉh car Jesús. ");
INSERT INTO otsNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nu cʉ pé dda quí möxte, ddahtzʉ nguá hñe̱jmʉ jar barco, mbá cjʉtijʉ car hmamöy, mí ñu̱xi möy. Porque mí bbɛjti como cien metro pa di zøni jár nttza̱ni car mar. ");
INSERT INTO otsNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cja̱ bbʉ mí bøxjʉ jar barco, bi cca̱htijʉ hnar tzibi, nxøgue dɛjtzibi, xquí cjöx pʉ xøtze cʉ dda möy, cja̱ co cʉ dda tju̱jme̱. ");
INSERT INTO otsNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Car Jesús ya bi xih quí möxte: ―Bú cʉjʉ ya tengu̱ cʉ möy cʉ xcú tzʉdijʉ.― ");
INSERT INTO otsNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nubbʉ, car Pedro bi ñʉti jar barco, bi gʉx car hmamöy gá ma jar jöy, mí ñu̱x cʉ möy, cja̱ göhtjo mí ndo möytsjɛ, mí zøti ciento cincuenta y tres. Masque már ndo ngu̱, jin gá xɛh car hmamöy. ");
INSERT INTO otsNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Diguebbʉ ya, car Jesús bi mahti quí möxte, bi xijmʉ: ―Bú e̱jmʉ ya, hne̱ gu tzijʉ.― Quí möxte, ya xi mí tzö ʉ́r mʉyjʉ, mí gue cam Tzi Jmu̱jʉ Jesús, masque mí tzi yomfe̱nitjojʉ. Pe jin to gá ne gá hñöni: “¿Toquiguɛ?” o “¿Te ʉ́r ju̱ quer tzi tju̱ju̱?” como mí pɛhtzi ʉ́r tzöjʉ. ");
INSERT INTO otsNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Cja̱ bbʉ ya xquí guatijʉ jar tzibi, car Jesús bi gʉx cʉ tju̱jme̱ cja̱ bi un quí möxte, cja̱ co guejti cʉ möy. ");
INSERT INTO otsNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Guejnʉ ya xi mír cja jñu̱ vez ca mír ni̱gui car Jesús pʉ jabʉ mí bbʉh quí möxte, bbʉ ya xquí du̱ guegue, cja̱ pé xquí jña̱ ʉ́r jña̱. ");
INSERT INTO otsNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cja̱ bbʉ ya xquí guadi xquí zijʉ, car Jesús bi nzoh car Simón Pedro, bi dyöni: ―Nuquɛ Simón, ʉ́r ttʉqui car Jonás, ¿cja más guí negui ni ndra ngue yʉ pé ddáa?― Bi da̱j ya car Pedro: ―Ja̱a̱, ʉm Tzi Jmu̱qui, guí pa̱di dí ma̱hqui.― Cja̱ pé bi xih car Jesús: ―Nubbʉ, gui wi̱n tzʉ cʉm tzi dɛti.― ");
INSERT INTO otsNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma ya car Jesús bi yojpi bi dyön car Pedro: ―Nuquɛ, Simón, ʉ́r ttʉqui car Jonás, ¿cja ntjumʉy guí negui?― Cja̱ pé bi da̱h car Pedro bbʉ: ―Ja̱a̱, ʉm Tzi Jmu̱qui, guí pa̱di dí nequi.― Cja̱ pé bi xih car Jesús: ―Nuya, gui föh tzʉ cʉm tzi dɛti.― ");
INSERT INTO otsNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nu car Jesús pé bi ma̱n ca rí cja jñu̱ vez: ―Nuquɛ, Simón, ʉ́r ttʉqui car Jonás, ¿cja ntjumʉy guí ma̱jqui?― Nubbʉ, car Pedro 