﻿USE sofia;
DROP TABLE IF EXISTS sofia.otqNT_vpl;
CREATE TABLE otqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES otqNT_vpl WRITE;
INSERT INTO otqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ár ndu̱i nunar tꞌofonu̱, ma da ꞌyotkagihu̱ ar ꞌñu togo yá pale ar Hesukristo, nꞌár ma̱ngaꞌbe̱to ar Dabi ne ar Abra. ");
INSERT INTO otqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ar Abra már dada ar Isa, har Isa már dada ar Hakob, har Hakob már dada ar Huda ne yá jödöpꞌu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ar Huda már dada ar Fare ne ar Zara ár jödönu̱, gehyu̱ xki ꞌyo̱mba ar Tamar. Nunar Fare már dada ar Esrom, ha nunar Esrom már dada ar Aram. ");
INSERT INTO otqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ar Aram már dada ar Aminadab, har Aminadab már dada ar Naso, har Naso már dada ar Salmon. ");
INSERT INTO otqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ar Salmon már dada ar Bos xki ꞌyo̱mba ar Rahab, nunar Bos már dada ar Obed xki ꞌyo̱mba ar Rut, har Obed már dada ar Isai. ");
INSERT INTO otqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ar Isai már dada ar ndö Dabi, ar ndö Dabi már dada ar Salomon xki ꞌyo̱mba nöꞌö ár ꞌbe̱hñöhmö ar Urias. ");
INSERT INTO otqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Nunar Salomon már dada ar Roboam, ar Roboam már dada ar Abia, har Abia már dada ar Asa. ");
INSERT INTO otqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ar Asa már dada ar Hosafat, ar Hosafat már dada ar Horam, har Horam már dada ar Usias. ");
INSERT INTO otqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ar Usias már dada ar Hotam, ar Hotam már dada ar Akas, har Akas már dada ar Esekias. ");
INSERT INTO otqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ar Esekias már dada ar Manases, ar Manases már dada ar Amon, har Amon már dada ar Hosias. ");
INSERT INTO otqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ar Hosias már dada ar Hekonias ne yá jödöpꞌu̱ꞌö, nuya pa mi tsꞌixa ya me Israel har ha̱i Mbabilonia. ");
INSERT INTO otqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Núnu̱ Mbabilonia ka ba tinu̱ ár bötsi ar Hekonias már thuhu ar Salatiel, ha nunar Salatiel már dada ar Sorobabel. ");
INSERT INTO otqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ar Sorobabel már dada ar Abiud, ar Abiud már dada ar Eleakim, har Eleakim már dada ar Asor. ");
INSERT INTO otqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ar Asor már dada ar Sadok, ar Sadok már dada ar Akim, har Akim már dada ar Eliud. ");
INSERT INTO otqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ar Eliud már dada ar Eleasar, ar Eleasar már dada ar Matan, har Matan már dada ar Hakob. ");
INSERT INTO otqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ar Hakob már dada ar Huse nöꞌö már döme ar Maria togo bi ꞌyo̱nga ar Hesu tꞌembabi ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nuꞌmú̱, gatho nuyá pale ne yá ma̱ngapale, ga du̱ꞌmhu̱ nuya pa mi ꞌbu̱ ar Abra, di göxa núꞌmu̱ mi ꞌbu̱ ar Dabi, bi tho ꞌre̱tꞌamagoho mꞌu̱i. Ha di ndu̱i ar ꞌbede nuya pa mi ꞌbu̱ ar Dabi, di göxa núꞌmu̱ mi tsꞌixa ya me Israel har ha̱i Mbabilonia, bi tho ma ꞌre̱tꞌamagoho mꞌu̱i nꞌehe. Ha nu mi tsꞌixa ya me Israel har ha̱i Mbabilonia, di göxa núꞌmu̱ mi mꞌu̱ ar Hesukristo, bi tho ma ꞌre̱tꞌamagoho ya mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Gehnu̱ ar ꞌbede hanja bi mꞌu̱ ar Hesukristo. Ar Maria xki tꞌa̱di nda nthötwi ar Huse. Himi tso̱ta ar pa nda mꞌu̱hwi, bi nda̱thi hár tsꞌe̱di ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ha nunar Huse togo xki ꞌya̱di, mar hogajöꞌi; himi ne nda ꞌbe̱twa ár tsa̱, jange ma nda hye̱pꞌu̱tho ñꞌöntho. ");
INSERT INTO otqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Núꞌmu̱ mi benga njapꞌu̱, nꞌa mbi nhekitho nꞌár e̱nxe̱ ar tsi Hmu, bi zo ntꞌi ne bi ꞌñembabi: —Huse, ár ꞌbe̱toꞌi ar Dabi, yo gi ntsu gi tsixa ar Maria ha ri ngu, ngetho ár Hñö Jö gehnu̱ xi japi xi ñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma da mꞌu̱ nꞌár bötsi, ne ma gi hñuꞌspabi ár thuhu ar Hesu, ngetho ma da po̱ ár hnini da gutwa yá tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bi njapꞌu̱ ne bi tho ngu xki mönga ár mꞌe̱hni Jö mamꞌe̱tꞌo núꞌmu̱ bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nꞌar nxutsi ma da nda̱thi ne da mꞌu̱ ár bötsi, ne da thuꞌspabi ár thuhu Emanuel, di bo̱ni da ꞌñenö: Di ꞌbu̱hwihu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nu mi nu ar Huse, bi ma ba o̱tꞌa ngu xki xipa ár e̱nxe̱ ar tsi Hmu, ne bi zixa ar Maria hár ngu. ");
INSERT INTO otqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ne himbi ñꞌöhwi ngur ꞌbe̱hñö, bi do̱ꞌmi bi mꞌu̱ ár ꞌbe̱tꞌo tꞌu̱, ne bi hñuꞌspabi ár thuhu ar HESU. ");
INSERT INTO otqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ar Hesu bi mꞌu̱hnu̱ Belen har ha̱i Nhudea núꞌmu̱ mar ndö ar Erode. Getya payu̱ bi zo̱hnu̱ Herusalen ꞌra ya ñꞌo̱ho̱ mi hetꞌa ya tso̱ xki ꞌñe mahyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ne mi ñꞌa̱ni mi eñꞌu̱: —Habu̱ bi ꞌbu̱ ár ndö ya xodyo xi mꞌu̱i, ngetho xta hanthwe ár tsꞌo̱nu̱ mahyatsꞌi, ne xta ehe ga ndöñhe. ");
INSERT INTO otqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nu mi ꞌyo̱ njapꞌu̱ ar Erode, xa bi ntsu, ne gatho ya me Herusalen bi ntsuwi mahye̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ar Erode dama bi zohna gatho ya ndömöjö ne ya bötꞌofo mi ꞌbu̱hnu̱, ne bi ꞌya̱mbabiꞌu̱ habu̱ nda mꞌu̱ ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ne bi ꞌñeñꞌu̱: —Núnu̱ Belen har ha̱i Nhudea, ngetho njapꞌu̱ bi mönga ár mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nuꞌahu̱ gar menguhu̱ Belen har ha̱i Huda, hinxi the̱kꞌase̱hu̱, ngetho xa ma da tꞌesꞌa ri nsuhu̱ gi töhu̱ gatho nu maꞌra ya döhni har ha̱i Nhudea; ngetho ma da bo̱mpꞌu̱ nꞌar ndö da suka ma hnini ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nuꞌmú̱ ar Erode bi ñöwise̱ nuꞌu̱ ya ñꞌo̱ho̱ mi hetꞌa ya tso̱, ne ꞌramtxꞌu̱ bi gu̱kwabiꞌu̱ hamꞌu̱ xki hyantꞌu̱ ar tso̱. ");
INSERT INTO otqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ne bi ꞌñembabiꞌu̱: —Di möhu̱ Belen ne ñꞌa̱ñhu̱ xiñho habu̱ ꞌbu̱ ar bötsi, ne núꞌmu̱ xki tiñhu̱, gi e gi xikagihu̱, ne ma ga ndönga nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nu mi wadi bi ꞌyo̱xa nöꞌö bi mönga ar ndö Erode, bi gu̱ yá ꞌñu bi maꞌu̱, ne nor tso̱ xki hyanda mahyatsꞌi mi ꞌbe̱tꞌo mi utwabiꞌu̱ ar ꞌñu. Ha nu mi zo̱nga habu̱ mi ꞌbu̱ ar bötsi, ka bi mꞌa̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nu mi hyantꞌu̱ ar tso̱ manꞌagi, xa bi njohya. ");
INSERT INTO otqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ne bi yu̱tꞌu̱ har ngu, ka bi hyandnu̱ꞌu̱ ar tsi bötsi mi ꞌbu̱hwi ar Maria ár nönö, ne bi nda̱ndihmö bi ndöñꞌu̱. Ne bi xotꞌa yá mꞌe̱tsꞌi, bi umba ya mꞌo̱ñho̱: ya kꞌaxtꞌabo̱jö xi mar mhödi, ya githni ne nꞌar hogañu̱ni ár thuhu ar mira. ");
INSERT INTO otqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma nda thota habu̱ xki ꞌñehyu̱ nda kꞌöꞌsa ar Erode. Ha Jö bi xipabi ntꞌi hinge nda manu̱ꞌu̱, jange bi pa̱ta yá ꞌñu, bi mengyá ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nu mi mengyá ha̱i ya jöꞌi mi hetꞌa ya tso̱, nꞌár e̱nxe̱ Jö bi ꞌñemba ntꞌi ar Huse: —Nangi, tsixa ar bötsi ne ár nönö di ma har ha̱i Ehipto. Ne ka gi kohnu̱, go xka xiꞌaꞌi hamꞌu̱ gi ehe, ngetho ar Erode ma da hyonga ar bötsi da hyo. ");
INSERT INTO otqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ne bi nu ar Huse bi gu̱ ar bötsi ne ár nönö, bi ñꞌo ar ꞌñu bi zixa har ha̱i Ehipto núꞌmu̱ mi nxuitho. ");
INSERT INTO otqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ne ka ba ꞌbu̱hnu̱ bi do̱ꞌmi bi du ar Erode. Njapꞌu̱ nda tho ngu xki mönga ár mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö: Da zo ma Tꞌu̱ nda bo̱nga har ha̱i Ehipto. ");
INSERT INTO otqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ar Erode xa bi mbo̱ ár kwe̱ núꞌmu̱ mi bödi xki ka ya ñꞌo̱ho̱ mi hetꞌa ya tso̱. Jange bi japi nda tho gatho ya tsi bötsi hinxki jwatꞌatho hñu nje̱ye̱, mi ꞌbu̱hnu̱ Belen ne gatho ár nthetꞌi, ngu xki gu̱kwa nuꞌu̱ ya ñꞌo̱ho̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bi tho njapꞌu̱ ngu xki mönga ar Heremia ár mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bi nheki nꞌar mhafi núnu̱ har ha̱i Rama ne nꞌar döta tsꞌoni; ar Rakel zontꞌa yá bötsi, ne himbi ne togo nda hotꞌi ngetho bi thopabi. ");
INSERT INTO otqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mꞌe̱fa mi du ar Erode, Jö bi mengi bi me̱hna nꞌár e̱nxe̱ ma ba kꞌöꞌsa ar Huse núnu̱ Ehipto, ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Nangi, penga ri ha̱i Israel, tsixa ar bötsi ne ár nönö, ngetho nuꞌu̱ mi honga ar bötsi nda hyohmö, xi duꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nuꞌmú̱, bi nangi bi zixa ar bötsi ne ár nönö, bi menga har ha̱i Israel. ");
INSERT INTO otqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ha nu mi ꞌyo̱de mar ndö ar Arkelao ár tꞌu̱ ar Erode har ha̱i Nhudea, bi ntsu nda manu̱. Ne Jö bi zo ntꞌi, jange bi ma har ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne bi mꞌu̱ har hnini ár thuhu Nasare. Njapꞌu̱ bi tho ngu xki mönga ár mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö: Ma da tꞌembabi ar me Nasare. ");
INSERT INTO otqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nuya paꞌu̱ ar Xuwa Xixthe bi ndu̱i bi zo ya jöꞌi ha ya otꞌatꞌo̱ho̱ núnu̱ Nhudea. ");
INSERT INTO otqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ne mi emba njanu̱: —ꞌYo̱thwu̱ ár ntso̱ꞌmi ngetho ár tsꞌu̱tꞌwi Jö ba epꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nunar Xuwa gehnu̱ ar ñꞌo̱ho̱ mi no̱nga ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: Ár mhafi nꞌa togo enga har otꞌatꞌo̱ho̱: Hyojwu̱ ár ꞌñu ar tsi Hmu. Jömfu̱ habu̱ da thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ar Xuwa mi hö nꞌar he xki nju̱mpa ár xi nꞌar me̱ti ár thuhu ar kameyo ne xki mꞌe, ne mi ngu̱tꞌa nꞌar ximhni. Ha nunar ñhuni mi tsi, ya ma̱ngakꞌoto ne ya tꞌafi mi tinga har tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne nze̱ye̱ ya jöꞌi mi po̱nga ha ya hnini nda ꞌyo̱xa nöꞌö mi möñꞌö, nuya me Herusalen ne gatho har ha̱i Nhudea, ne nuya jöꞌi mi ꞌbu̱ hár ñöni ar döthe Hordan. ");
INSERT INTO otqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mi eꞌu̱ nda da̱majöni yá tsꞌoki, ne ar Xuwa mi xixthe har döthe Hordan. ");
INSERT INTO otqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nu mi hyandi nze̱ye̱ ya de̱ngaꞌbe̱pate ne ya de̱ngamöjö mi e nda nxixthe nꞌehe, bi ꞌñembabiꞌu̱: —Yá bötsiꞌihu̱ ya kꞌeñö gi ha̱tehu̱. Togo xi utꞌahu̱ gi kꞌonthu̱ ár kwe̱ Jö xi ꞌñepꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mahyoni gi ꞌyo̱thu̱ nöꞌö xiñho, ne da nheki xka ꞌyo̱thwu̱ ár ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yo ma gi ꞌñexa ri nsuhu̱ gi ꞌñense̱hu̱: Ma dadahe ar Abra. Ngetho nuga di xiꞌahu̱, Jö tsa̱ da gu̱xa nuya doyu̱, ne da ꞌñexa ngu yá bötsi ar Abra. ");
INSERT INTO otqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ne di xiꞌahu̱ nꞌehe, Jö ngu ar tse̱nza, höda ar ntsꞌe̱nza hár ꞌye̱ da ze̱ka ar za. Ha nunar za hinte mañho uni, da tsꞌe̱ki ne da tꞌe̱ntꞌa har tsibi. ");
INSERT INTO otqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nuga di xixtheꞌihu̱ har dehe ngetho xka ꞌyo̱thwu̱ ár ntso̱ꞌmi. Nöꞌö ꞌbe̱fa ma da xixtheꞌihu̱ hár Hñö Jö ne har tsibi. Nuga hindi ꞌñepkagi ga höꞌspa yá thiza, ngetho xa tökagi ár tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nöꞌö xi ñhoki piꞌsa ar tꞌe̱i, ma da paxtꞌa ár thi ne da kwata ar tꞌe̱i hár tꞌu. Ha nöꞌö ar paxi da ꞌyu̱ꞌsa har tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Geꞌmu̱ ba po̱nga ar Hesu har ha̱i Ngalilea, ba e har döthe Hordan habu̱ mi ꞌbu̱ ar Xuwa, ne nda xixthenu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Har Xuwa himi ne, mi embabi: —Hanja xka e ga xixtheꞌi. Nuꞌge go di ꞌñepꞌaꞌi gi xixthegi. ");
INSERT INTO otqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Har Hesu bi döti: —Xixthegipya, ne njapꞌu̱ ga o̱thu̱ gatho nöꞌö numañho Jö. Nuꞌmú̱ ar Xuwa bi netho bi xixthe ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nu mi wadi bi nxixthe, mi bo̱nga har dehe, nꞌa mbi xota mhetsꞌi, ne bi hyanda ár Hñö Jö ba köi ngu nꞌar domtxu, ba e bi zu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne bi nheki nꞌar mhö ndi ꞌñe mhetsꞌi mi enö: —Gehnu̱ ma hmöka Tꞌu̱, jakagi ga njohya. ");
INSERT INTO otqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nepꞌu̱ ár Hñö Jö bi zixa ar Hesu ha ya otꞌatꞌo̱ho̱, ne ja nda tsa̱tnu̱ ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ka ba ꞌbu̱hnu̱ yonꞌa̱te mpa ne yonꞌa̱te nxui hinte bi zi. Mꞌe̱fa bi zu̱ ar thuhu. ");
INSERT INTO otqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ba epꞌu̱ ar tsꞌondöhi mi tsa̱ti mi embabi: —Nuꞌmu̱ ár Tꞌu̱ꞌi Jö, japa nuya doyu̱ da nthuhme xö. ");
INSERT INTO otqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ha nu ar Hesu bi döti ne bi ꞌñembabi: —Njawa enga hár Tꞌofo Jö: Hinge ho̱nse̱ ar thuhme da umba ár te ar jöꞌi, mahyonibi ár mhö Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mꞌe̱fa ar tsꞌondöhi bi zixa ar Hesu har jöpahnini Herusalen, ne bi ꞌñexa mañö hár ngötsꞌi ar dönganijö. ");
INSERT INTO otqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne bi ꞌñembabi: —Nuꞌmu̱ majöni ár Tꞌu̱ꞌi Jö, ꞌye̱nga ar nsa̱gi köi xö, ngetho njanu̱ huxa har Tꞌofo: Jö da me̱hna yá e̱nxe̱ da suꞌaꞌi, ne da mipꞌa ri ꞌye̱, hingi fama ri wa ha ya do. ");
INSERT INTO otqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Xi tꞌotꞌi nꞌehe: Yo ma gi tsa̱ta Jö ri Hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nepꞌu̱ ar tsꞌondöhi manꞌagi bi zixa ar Hesu ha nꞌar tꞌo̱ho̱ mar ñhetsꞌi, ne bi utwabi gatho ya hnini ꞌbu̱ hár nxidi ar ximha̱i ne gatho yá ñho pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne bi ꞌñembabi: —Gatho nuya hniniyu̱ ga ꞌraꞌi nuꞌmu̱ gi nda̱ndihmö gi nsundagi. ");
INSERT INTO otqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ar Hesu bi ꞌñembabi: —Hye̱gagiwa tsꞌondöhi, ngetho huxa har Tꞌofo: Nsunda Jö ri Hmu, ne ho̱nse̱ꞌö gi pe̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nuꞌmú̱ ar tsꞌondöhi dama bi ꞌwege, ne ba e yá e̱nxe̱ Jö mi umba te nda zi ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Núꞌmu̱ mi ꞌyo̱ ar Hesu mi o har fa̱di ar Xuwa Xixthe, bi menga har ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ba tsopꞌu̱ Nasare bi ma ba ꞌbu̱ Nkapernaum, getꞌu̱ ar ñho̱nthe núnu̱ ha yá ha̱i ar Sabulon ne ar Neftali. ");
INSERT INTO otqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Njapꞌu̱ bi tho ngu xki mönga ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ár ha̱i ar Sabulon ne ár ha̱i ar Neftali, ꞌbu̱ har ꞌñu di ma har ñho̱nthe ꞌranditho ar döthe Hordan, núnu̱ Ngalilea ár ha̱i nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nöꞌö ar hnini mi ꞌbu̱ har ꞌbe̱xui bi hyanda nꞌar döta ñotꞌi. Nuꞌu̱ xki mꞌe̱ har ꞌbe̱xui bi yotꞌwa nꞌar hyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nuya paꞌu̱ ar Hesu bi du̱ꞌmi bi mönga ar hoga mhö, ne mi emba ya jöꞌi: —ꞌYo̱thwu̱ ár ntso̱ꞌmi ngetho ár tsꞌu̱tꞌwi Jö ꞌba̱pꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ar Hesu mi ꞌyo hár ñöni ar ñho̱nthe Ngalilea. Nꞌa mbi hyandatho yoho ya ñꞌo̱ho̱ mi njödö, nꞌa már thuhu ar Simu nöꞌö bi tꞌembabi ar Pedro, nöꞌö manꞌa már thuhu ar Andre, mi kötꞌa yá ntꞌa̱tsꞌi, ngetho ma ya ngu̱xhwö. ");
INSERT INTO otqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne bi ꞌñembabiꞌu̱: —Ba e gi te̱ngagihu̱, ne ma ga exꞌahu̱ gi ju̱xu̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dama bi zopꞌu̱ yá ntꞌa̱tsꞌiꞌu̱, bi de̱nga ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bi ñꞌo manꞌa tsi tu̱i ar Hesu, ne bi hyanda ma yoho mi njödö, ar Hakobo ne ar Xuwa yá tꞌu̱ ar Sebedeo, mi to̱hwinu̱ yá dada har motsa mi po̱tꞌa yá ntꞌa̱tsꞌi. Bi xipa nuya yohoyu̱ nda de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ne nuyu̱ dama bi zopꞌu̱ ar motsa ne ár dadaꞌu̱, nꞌagitho bi de̱nga ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ar Hesu mi thetꞌa xo̱ge har ha̱i Ngalilea, mi ku̱tꞌa ha yá nijö ya xodyo mi utwabi, ne mi xipabi ar hoga mhö no̱nga ár tsꞌu̱twi Jö. Ne mi o̱thebi yá hñeni ne yá u̱gi gatho ya mengunu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bi nxanga ar ꞌbede nöꞌö mi pe̱fi xo̱ge har ha̱i Nsiria. Ne ba tsꞌimpabi gatho ya da̱thi, nuꞌu̱ mi tho ya u̱gi ne xki zu̱ ya hñeni, nuꞌu̱ mi nthe̱xkwi ya tsꞌondöhi, nuꞌu̱ ma ya ndungo ne nuꞌu̱ himi tsa̱ nda ꞌñöni. Ne ar Hesu bi o̱the xo̱geyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ne bi de̱nga nze̱ye̱ ya jöꞌi me Ngalilea, me Ndekapoli, me Herusalen, ya me Nhudea ne nuꞌu̱ mi ꞌbu̱ ꞌrandi ar döthe Hordan. ");
INSERT INTO otqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nu mi hyanda ar Hesu mi ñꞌowi nze̱ye̱ ya jöꞌi, bi bo̱xa har tꞌo̱ho̱. Ne mi zo̱ni bi hñudi, ha nuyá ma̱xte bi ma ba tsu̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ne ar Hesu bi ndu̱i bi utwabiꞌu̱, mi embabi njawa: ");
INSERT INTO otqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Nza̱tho nuꞌu̱ togo hingya ñꞌetsꞌi, ngetho xi nhwëkwabi ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nza̱tho nuꞌu̱ zoni, ngetho Jö go ma da hotꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nza̱tho nuꞌu̱ tse̱tatho gatho, ngetho go ma da tꞌumba ar ximha̱i yá me̱tiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nza̱tho nuꞌu̱ xa ne da ꞌyo̱tꞌa nöꞌö xiñho, ngetho Jö xa ma da umba nöꞌö neꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nza̱tho nuꞌu̱ pe̱ꞌsa yá nhwëki, ngetho Jö ma da me̱ꞌspa ar nhwëki nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nza̱tho nuꞌu̱ xintꞌaxi yá mfeni, ngetho ma da hyantꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nza̱tho nuꞌu̱ togo ꞌba̱ made höka ar hñö, ngetho ma da tꞌembabi yá bötsi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nza̱tho nuꞌu̱ tho ya ntꞌu̱tsa o̱tꞌa nöꞌö xiñho, ngetho ma da mꞌu̱ꞌu̱ hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nza̱tho núꞌmu̱ xta tsꞌañꞌahu̱ ne xta ntꞌu̱tsaꞌihu̱, ne da nju̱sꞌahu̱ ya nhemhñö ngetho gi te̱ngagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xa gi njohyahu̱, ngetho Jö ma da ꞌraꞌahu̱ nꞌar döta nthöhö núnu̱ mañö mhetsꞌi. Njapꞌu̱ bi ntꞌu̱tsa yá mꞌe̱hni Jö mi ꞌbu̱ mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nuꞌahu̱ gi ñhe̱hwihu̱ ar u xi nku̱hi habu̱ tꞌu̱tsꞌi. Jange ꞌñuhu̱ ri hogamꞌu̱ihu̱, ngetho xiꞌmu̱ ar u da mꞌe̱ ár ñꞌuxi, hanja dar nku̱hi ꞌmu̱. Nöꞌö ar uꞌö hinter ñho, da tꞌe̱mpꞌu̱tho da nheꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nuꞌahu̱ gi ñhe̱hwihu̱ nꞌar ñotꞌi. Nꞌar hnini di huxa mañö nꞌar tꞌo̱ho̱, hinda tsa̱ da tꞌögi. Nuꞌahu̱ nꞌehe hinda tsa̱ gi ꞌñöhu̱ ri hogamꞌu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hinto tso̱ nꞌar ñotꞌi ne da yeꞌma nꞌar tsꞌo̱i da goꞌmi. Da ꞌñexa habu̱ xi ñhetsꞌi, ne da yotꞌwa gatho nuꞌu̱ ꞌbu̱ har ngu. ");
INSERT INTO otqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jahu̱pꞌu̱, ñꞌuhu̱ nꞌar hogamꞌu̱i ha yá nthandi ya jöꞌi, ne xta hyantꞌu̱, da nsundabi ri Dadahu̱ bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yo gi beñhu̱ xta e ga hwatwa yá ꞌbe̱pate ar Moise, wa xta e ga jöꞌspa nöꞌö xi mönga yá mꞌe̱hni Jö. Nuga xta e ga o̱tꞌa gatho ngu xi möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Xa majöni di xiꞌahu̱, hinxi göxta ar ximha̱i ne ar mhetsꞌi, xta wadi da tho gatho nöꞌö mönga hár tꞌofo ar Moise, hinda ma da go nꞌar mhö wa nꞌar xe̱ni da njapꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nöꞌö togo hinda ꞌyo̱tꞌa gatho nöꞌö mönga hár Tꞌofo Jö, mödi nꞌar tsi tꞌu̱lo ꞌbe̱pate, ne njapꞌu̱ da uta maꞌra, hintsꞌu̱ ma da nhumañho hár tsꞌu̱tꞌwi Jö. Ha nöꞌö togo da ꞌyo̱tꞌa gatho ngu mönga hár Tꞌofo Jö ne da uta maꞌra, nöꞌö ma da tꞌeꞌspa ár nsunu̱ hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Di xiꞌahu̱, nuꞌmu̱ hingi pe̱ꞌsu̱ nꞌar hogamꞌu̱i di töta yá mꞌu̱i ya de̱ngaꞌbe̱pate ne yá mꞌu̱i ya bötꞌofo, hinda tsa̱ gi ku̱thu̱ hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gi pöhu̱, ri palehu̱ bi nsipabi mamꞌe̱tꞌo: Yo gi ñhotehu̱. Nöꞌö toga da ñhote, hinda kꞌontꞌa ar mfe̱i xi tꞌe̱kwabi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ha nuga di xiꞌahu̱, nuꞌmu̱ togo da mbo̱ ár kwe̱ da u̱tsa ár ñꞌohu̱, ja te da hñöxa majöni har tsꞌu̱tꞌwi. Nöꞌö togo da ꞌñemba ár ñꞌohu̱ xi ꞌbe̱ ár mfeni, ma da duxa ar tsꞌoki ne pe̱ꞌsa te da dö har tsꞌu̱tꞌwi. Ha nuꞌmu̱ togo da zanga ár ñꞌohu̱ ne da ꞌñembabi hinter ꞌbe̱fi, nöꞌö ma da gutꞌa har tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jange nuꞌmu̱ xka hömfu̱ nꞌar mꞌo̱ñho̱ Jö har nijö, ne ka gi beñhu̱nu̱ xka tso̱thwu̱ ár mu̱i ri ñꞌohu̱, ");
INSERT INTO otqNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tsohnu̱hmö ri mꞌo̱ñho̱hu̱, ne di möhu̱ ba a̱fu̱ ar pumbate ri ñꞌohu̱, ne nupya hö, ba e gi umfu̱ ri mꞌo̱ñho̱hu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nuꞌmu̱ nꞌa ri ñꞌu̱nihu̱ da zixꞌahu̱ har tsꞌu̱tꞌwi, núꞌmu̱ gi ñꞌowihu̱ har ꞌñu, ñhogamu̱iwihu̱. Ngetho xki tso̱ngwihu̱ har tsꞌu̱tꞌwi, da da̱ꞌahu̱ ar nza̱ya̱, ne nöꞌö da xipa yá ma̱xte da goꞌahu̱ har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Xa majöni di xiꞌahu̱, hinda tsa̱ gi po̱ñhu̱, mꞌe̱tꞌo gi kꞌotꞌa ri tha̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Xka ꞌyo̱hu̱ xi tꞌenga mamꞌe̱tꞌo: Yo gi tsimfu̱ ár nthöti ri ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ha nuga di xiꞌahu̱, nuꞌmu̱ togo da kꞌötꞌa nꞌar ꞌbe̱hñö da ꞌbe̱nte, xi ꞌyo̱tꞌa nꞌar tsꞌoki. Ñhe̱hwitho ngu xi zimba ár ꞌbe̱hñö manꞌa, ngetho bi benga hár mfeni. ");
INSERT INTO otqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jange nuꞌmu̱ ri da̱hu̱ ar ñꞌe̱i ha̱ꞌahu̱ gi ꞌyo̱thu̱ ar tsꞌoki, hñöhu̱ gi ꞌye̱ñhu̱. Xiñho ho̱nse̱ gi ꞌbe̱hu̱ nꞌa xe̱ni ri ndoꞌyohu̱, ngetho tema ñho gi ju̱ju̱ di xo̱ge ri ndoꞌyohu̱ ne da tꞌe̱ntꞌahu̱ har tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nuꞌmu̱ ri ꞌye̱hu̱ ar ñꞌe̱i ha̱ꞌahu̱ gi ꞌyo̱thu̱ ar tsꞌoki, hye̱ju̱ gi ꞌye̱ñhu̱. Xiñho ho̱nse̱ da mꞌe̱ nꞌa xe̱ni ri ndoꞌyohu̱, ngetho tema ñho gi ju̱ju̱ di xo̱ge ri ndoꞌyohu̱ ne da tꞌe̱ntꞌahu̱ har tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Xi tꞌenö nꞌehe: Nöꞌö togo da hye̱ ár ꞌbe̱hñö, mahyoni da hyokwa nꞌar he̱ꞌmi ñhe̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ha nuga di xiꞌahu̱, nöꞌö togo da hye̱pꞌu̱ ár ꞌbe̱hñö, ne hinte ma tsꞌoki xi dimbabi ñꞌowi manꞌar jöꞌi, nöꞌö ar dömeꞌö japa ar ꞌbe̱hñö da ntsꞌoki. Ha nöꞌö togo da nthötwi, po̱ntho xi zimba ár ꞌbehñö ár ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Xka ꞌyo̱hu̱ nꞌehe, bi nsipabi ri palehu̱ mamꞌe̱tꞌo: Yo gi ꞌñetꞌa Jö made nuꞌmu̱ hingi pödi da za̱ gi ꞌyo̱tꞌe, ha nuꞌmu̱ te xka ñötꞌa Jö, ꞌyo̱tꞌa ngu xka xipabi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ha nuga di xiꞌahu̱: Hinto gi ꞌñethu̱ made; hingi ꞌñethu̱ made mhetsꞌi, ngetho ka bi ꞌbu̱hnu̱ ár thuxandö Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hingi ꞌñethu̱ made ar ximha̱i, ngetho ka expꞌu̱ ár wa. Hingi ꞌñethu̱ made ar hnini Herusalen, ngetho ár hnini ar döta Ndö. ");
INSERT INTO otqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hingi ꞌñethu̱ made ri ñöhu̱, ngetho hinda tsa̱ gi japa ri xtöhu̱ da tꞌaxki wa da boki. ");
INSERT INTO otqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hinge mahyoni te gi ꞌñethu̱ made gi hoñhu̱ da tꞌo̱xꞌahu̱. Nuꞌmu̱ gi möñhu̱ hö, hö, ha nuꞌmu̱ hinꞌö, hinꞌö, ngetho nuꞌmu̱ teme gi huxu̱, go unga ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Xka ꞌyo̱hu̱ xi tꞌenga mamꞌe̱tꞌo: Nöꞌö togo da kꞌe̱tꞌwa ár da̱ manꞌa, nda nkꞌe̱tꞌwa ár da̱ꞌö nꞌehe. Ha nöꞌö togo nda dokwa nꞌár tsꞌi manꞌa, nda nthokwa nꞌár tsꞌi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ha nuga di xiꞌahu̱, yo gi to̱xu̱ ar tsꞌojöꞌi. Nuꞌmu̱ togo da me̱pꞌa ri hmihu̱ har ñꞌe̱i, umfu̱ da me̱pꞌahu̱ har ngöhö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ha nuꞌmu̱ togo ne da hñömpꞌahu̱ ri pa̱tꞌihu̱, umfu̱ da hñöxa ri pahnihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nuꞌmu̱ togo da jaꞌahu̱ gi hñöꞌsfu̱ nꞌar ꞌbe̱ni nꞌapa ar ꞌñu, hñöꞌsfu̱ yoꞌgi ár yapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nuꞌmu̱ nꞌar jöꞌi te da ꞌya̱ꞌahu̱, umfu̱. Ha nuꞌmu̱ te da mipꞌahu̱, yo ma gi ko̱mfu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Xka ꞌyo̱hu̱ xi tꞌenö nꞌehe: Möhu̱ ri ñꞌohu̱ ne u̱tsa ri ñꞌu̱nihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ha nuga di xiꞌahu̱, möhu̱ ri ñꞌu̱nihu̱, mathwu̱ Jö nuꞌu̱ togo tsañꞌahu̱, ꞌyo̱thwu̱ ar ñho nuꞌu̱ togo u̱tsaꞌihu̱, ꞌya̱fu̱ Jö da ma̱xa nuꞌu̱ togo ñömañꞌu̱ ne e̱kꞌathohu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ngetho nuꞌmu̱ gi ꞌyo̱thu̱ njapꞌu̱, nuꞌmú̱ hö, yá bötsiꞌihu̱ Jö ar Dada bi ꞌbu̱ mhetsꞌi, nöꞌö togo japa ar hyadi da yotꞌwa ya hogajöꞌi ne ya tsꞌomꞌu̱i, ne pe̱mpa ar ꞌye nuꞌu̱ o̱tꞌa xiñho ne nuꞌu̱ hingi o̱tꞌa xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nuꞌmu̱ gi möhu̱ ho̱nse̱ nuꞌu̱ möꞌahu̱ ne nu maꞌra ya jöꞌi hinꞌö, tema nthöhö gi to̱ꞌmhu̱ ꞌmu̱. Ha hingi njapꞌu̱ ya tsꞌomꞌu̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nuꞌmu̱ ho̱nse̱ ri kuhu̱ gi ze̱ngwahu̱ ne nu maꞌra ya jöꞌi hinꞌö, tema ñho gi o̱thu̱ ꞌmu̱. Ha hingi njapꞌu̱ nuꞌu̱ hingya gamfi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mahyoni gi ñhogajöꞌihu̱ gi möhu̱ gatho, ngu Jö ar Dada bi ꞌbu̱ mhetsꞌi ar hogajöꞌi möꞌa gathoꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jamasuhu̱ yo ma gi ꞌyo̱thu̱ ya hoga ꞌbe̱fi gi hoñhu̱ da numañhoꞌihu̱ ya jöꞌi. Ngetho nuꞌmu̱ gi ꞌyo̱thu̱ njapꞌu̱, hinte ma nthöhö da ꞌraꞌahu̱ ri Dadahu̱ bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jange nuꞌmu̱ gi umfu̱ nꞌar mfa̱tsꞌi ya hyoya, yo gi jafu̱ da nu̱nga ar ꞌbede ngu o̱tꞌa ya nemhñö, ne da nthu̱xtꞌa ya kꞌaxtꞌathu̱xi ha ya nijö ne ha ya döꞌñu, honi da tꞌeꞌspa yá nsu. Nuꞌu̱ o̱tꞌa njapꞌu̱, gehnu̱ yá nthöhöꞌu̱, hinte to̱ꞌma manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ha nuꞌahu̱, nu xki umfu̱ nꞌar mfa̱tsꞌi ya hyoya, pöse̱hu̱. Nöꞌö da unga ri ꞌñe̱ihu̱, hinda bö ri ngöhöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ne ri mfa̱tsꞌihu̱ gi unthu̱ ñꞌöntho, ri Dadahu̱ togo handa ñꞌöntho, da ꞌraꞌahu̱ ri nthöhöhu̱ ha yá nthandi ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Núꞌmu̱ gi a̱fu̱ Jö, yo gi o̱thu̱ ha yá nthandi ya jöꞌi ngu o̱tꞌa ya nemhñö, ne da ꞌñexyá nsu. Nuyu̱ a̱pabi ꞌba̱tho ha ya nijö ne ha ya ta̱i. Xa majöni di xiꞌahu̱, gehnu̱ yá nthöhöyu̱, hinte to̱ꞌma manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ha nuꞌahu̱, núꞌmu̱ xki ꞌya̱fu̱ Jö, ku̱tꞌa ha ri nguhu̱ ne kothu̱ ri goxthi. ꞌYa̱fu̱ Jö ri Dadahu̱ ñꞌöntho gi ꞌbu̱se̱wihu̱nu̱, ne ri Dadahu̱ togo handa ñꞌöntho, da ꞌraꞌahu̱ ri nthöhöhu̱ ha yá nthandi ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Núꞌmu̱ gi a̱fu̱ Jö, yo xa gi thöthu̱ getꞌa ya mhö ngu o̱tꞌa nuꞌu̱ hingya gamfi, beñꞌu̱ ngu ár nze̱ye̱ ya mhö, njapꞌu̱ Jö ma da ꞌyo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jange yo gi o̱thu̱ ngu yá ꞌbe̱fiꞌu̱, ngetho Jö ar Dada pödi xiñho tema gi kꞌathu̱ núꞌmu̱ hinxka ꞌya̱fu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Núꞌmu̱ gi zohu̱ Jö, ꞌya̱fu̱ njawa: Ma tsi Dadaꞌihe gi ꞌbu̱ mhetsꞌi, xa nsunda ri thuhu. ");
INSERT INTO otqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ba e gi ndöwa, ne da tꞌo̱tꞌwa nöꞌö gi mönge har ximha̱i ngu bi tꞌo̱tꞌapꞌu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ꞌRaje te ga tsihe ar pania. ");
INSERT INTO otqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pumgagihe ma tha̱ihe, nguje di pumfe nuꞌu̱ togo tukagihe. ");
INSERT INTO otqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne yo gi he̱gagihe da tsa̱tje ar tsꞌoki, ñöngagihe hinga o̱the nöꞌö hingi ho. Ngetho gar ndöge, ne ja ri tsꞌe̱di ne hiñhamꞌu̱ da göxa ri nsunda. Dá njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ngetho nuꞌmu̱ gi pumbabihu̱ nöꞌö togo o̱tꞌahu̱ ar tsꞌomꞌu̱i, ri Dadahu̱ mhetsꞌi nꞌehe da pumpꞌahu̱ ri tsꞌokihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ha nuꞌmu̱ hingi pumbabihu̱ nöꞌö togo o̱tꞌahu̱ ar tsꞌomꞌu̱i, Jö ar Dada hinda pumpꞌahu̱ ri tsꞌokihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Núꞌmu̱ gi bëhu̱, yo gi ponga ri hmihu̱ gi uhu̱ ar dumu̱i ngu o̱tꞌa ya nemhñö, honi da födi xi bëꞌu̱. Xa majöni di xiꞌahu̱, gehnu̱ yá nthöhöꞌu̱, hinte to̱ꞌma manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ha nuꞌahu̱, núꞌmu̱ gi bëhu̱, ꞌyeka ri ñöhu̱ ne xu̱ka ri hmihu̱ ngu gi o̱thu̱ hyaxꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Njapꞌu̱ hinda födi gi bëhu̱. Ho̱nse̱ Jö togo ꞌbu̱ habu̱ hingi nheki, go da bö nöꞌö gi o̱tꞌase̱hu̱, ne da ꞌraꞌahu̱ ri nthöhöhu̱ ha yá nthandi ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yo xa gi umba ri mu̱ihu̱ gi munsu̱wa har ximha̱i nze̱ye̱ ya ñho habu̱ da zi ya zuꞌwe, da zi ar ha̱i ne da bëꞌahu̱ ya bë. ");
INSERT INTO otqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pe̱ꞌsu̱ ri ñhohu̱nu̱ mhetsꞌi habu̱ hinte da japa ar zuꞌwe, hinda zi ar ha̱i, hinda bëꞌahu̱ ya bë. ");
INSERT INTO otqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngetho habu̱ gi pe̱ꞌsu̱ ri ñhohu̱, ka gehnu̱ oda ri mfenihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nuya ri da̱hu̱ go yotꞌa gatho ri ndoꞌyohu̱, jange nuꞌmu̱ ri da̱hu̱ ꞌbu̱i xiñho, gatho ri ndoꞌyohu̱ ꞌbu̱ har hyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ha nuꞌmu̱ hingi ꞌbu̱ xiñho ri da̱hu̱, gatho ri ndoꞌyohu̱ ꞌmu̱, ꞌbu̱ har ꞌbe̱xui. Ha nuꞌmu̱ nunar ñotꞌi yotꞌahu̱ xi mꞌe̱xui, tenguhmö ár mpothi ar ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hinda tsa̱ gi pe̱fu̱ yoho ya hmu, ngetho gi u̱tsahu̱ nꞌa, ha gi möhu̱ nöꞌö manꞌa. Nꞌa gi pe̱fu̱ xiñho, ha nöꞌö manꞌa hinꞌö. Njapꞌu̱tho nꞌehe, hinda tsa̱ gi pe̱fu̱ Jö nuꞌmu̱ ho̱nse̱ oda ri mfenihu̱ yá ñho ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jange di xiꞌahu̱, yo gi tu ri mu̱ihu̱ núꞌmu̱ hiñꞌotho te gi tsihu̱ wa te gi hyethu̱ ri ndoꞌyohu̱. Ha hinge ri tehu̱ töpa ár nsu ar ñhuni, ne ri ndoꞌyohu̱ töpa ár nsu ar he. ");
INSERT INTO otqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hyanthu̱ ya tsꞌintsꞌu̱ nza̱nga mhetsꞌi. Nuꞌu̱ hingi potꞌi, hingi xofo, hinte pe̱ꞌsa yá tꞌu, ha ri Dadahu̱ mhetsꞌi umba te da ziꞌu̱. Ha hingi töfu̱ ár nsu pe̱ꞌsa ya tsꞌintsꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Togo tsa̱ da japa ár ndoꞌyo da hñuxa ár ñhetsꞌi xa di tupa ár mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yoꞌö gi tu ri mu̱ihu̱ gi beñhu̱ tema gi hyehu̱ ꞌmu̱. Hyanthu̱ hanja te ya do̱ni har ꞌbatha. Nuꞌu̱ hingi hetꞌi, hingi pe̱ manꞌar ꞌbe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ha di xiꞌahu̱, nunar ndö Salomon, mödi xa mi döta ár nsu, himbi za̱ bi hye nꞌar he ngu ár nza̱thoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nuꞌmu̱ Jö heta njapꞌu̱ ya do̱ni ꞌba̱ har ꞌbatha ár pania, ne xudi da nkꞌu̱tsꞌi da tꞌu̱ꞌsa har tsibi, tengu da hetꞌahu̱ ꞌmu̱. Yoꞌö xa hinte gi pe̱ꞌsu̱ ri jamfihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jange yo gi tu ri mu̱ihu̱, gi eñhu̱: Tema ga tsihu̱pya, wa te ga hehu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ngetho nuꞌu̱ hinxi jamfi, hyaxꞌmu̱ tu yá mu̱i núꞌmu̱ hinte pe̱tsꞌi te da zi, wa te da hye. Ha nuꞌahu̱, ri Dadahu̱ bi ꞌbu̱ mhetsꞌi pöꞌö teme gi kꞌathu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nuꞌahu̱, hyoñhu̱ mꞌe̱tꞌo hanja gi ꞌbu̱hu̱ xiñho hár tsꞌu̱tꞌwi Jö, ne gi ꞌyo̱thu̱ nöꞌö neꞌö, ne njapꞌu̱ hö, hinda kꞌatꞌahu̱ gatho nöꞌö gi hoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jange yo gi tu ri mu̱ihu̱ nöꞌö te di ꞌñepꞌahu̱ xudi, ngetho hyaxtho ja te ga thohu̱. Nꞌa ngu nꞌa ya pa pe̱ꞌsase̱ yá thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yo gi nthentehu̱, ne hinda ntheñꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngetho ngu gi thenga ri ñꞌohu̱, Jö ma da hñösꞌahu̱ majöni. Nuꞌmu̱ himbi go ri mu̱ihu̱, hinda ma da gor mu̱iꞌö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hanja gi handwa ár tsꞌoki ri ku, jangutho nꞌar paxi o hár da̱ꞌö, ne hingi jamasu ri döta tsꞌoki ngu nꞌar xo̱kaza o ha ri da̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hanja da tsa̱ gi ꞌñemba ri ku: To̱ꞌmi ga höpꞌa ar paxi o ha ri da̱, ne hanja hingi handa nöꞌö ar xo̱kaza o ha ri da̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Xa gar nemhñö. Hñö mꞌe̱tꞌo ar xo̱kaza o ha ri da̱ge, ne njapꞌu̱ hö, da tsa̱ gi hyanda xiñho, ne gi hñömba ar paxi o hár da̱ ri ku. ");
INSERT INTO otqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yo gi umfu̱ nöꞌö ár me̱ti Jö nuꞌu̱ hingi numañho. Yo gi umfu̱ ri ñhohu̱ xi nhwëkꞌahu̱ nuꞌu̱ hingi numansu, ngetho ngu ya ꞌyo da ne da zaꞌahu̱, ne ngu ya tsꞌu̱di tsꞌotꞌa gatho nöꞌö tꞌumbabi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ꞌYa̱hu̱ ne da tꞌaꞌahu̱, hyoñhu̱ ne gi tiñhu̱, nzotehu̱ ne da nsokꞌahu̱ ar goxthi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngetho nöꞌö togo da ꞌya̱di, da tꞌumbabi, nöꞌö togo da hyoni da dini, ha nöꞌö nzote, da nsokwabi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Xiꞌmu̱ nꞌa ri bötsihu̱ da ꞌya̱ꞌahu̱ nꞌar thuhme, hage gi umfu̱ nꞌar do. ");
INSERT INTO otqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Xiꞌmu̱ da ꞌya̱ꞌahu̱ nꞌar hwö, hage gi umfu̱ nꞌar kꞌeñö. ");
INSERT INTO otqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nuꞌmu̱ gar tsꞌoktehu̱ ne gi pöhu̱ gi umfu̱ nöꞌö xiñho ri bötsihu̱, hanguhmö ar Dada bi ꞌbu̱ mhetsꞌi xa da umba ar ñho gatho nuꞌu̱ togo da ꞌya̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ngu gi nehu̱ da jaꞌahu̱ ya jöꞌi, japabihu̱ njapꞌu̱ nꞌehe. Gehnu̱ ne da ꞌñenga yá ꞌbe̱pate bi ꞌyotꞌa ar Moise ne nu maꞌra yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ku̱thu̱ har goxthi xi ntsꞌixtꞌi. Ngetho xi maxtꞌi ar goxthi ne xi nxidi ar ꞌñu di ma har ꞌbe̱xui, ne nze̱ye̱ nuꞌu̱ ku̱tnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Xi ntsꞌixtꞌi ar gosthi, ne hingi maxtꞌi ar ꞌñu di ma mhetsꞌi, jange txꞌu̱tho nuꞌu̱ togo tini da yu̱tnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jamasuhu̱ hinda tsꞌokꞌa ri mfenihu̱ nuꞌu̱ ense̱ yá mꞌe̱hni Jö empꞌö. Ma da ꞌñepꞌu̱ da ne da hya̱ꞌahu̱, fe̱ta ya hogajöꞌi ngu nꞌar tsi de̱ti, ha mbo yá mfeni ñhe̱hwi nꞌar dumanthuhu miñꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma gi pöhu̱ togoꞌu̱, nhekitho yá tsꞌoꞌbe̱fi. Ngetho nuya tsꞌomꞌu̱i hingi tsa̱ da ꞌyo̱tꞌa nꞌar hoga ꞌbe̱fi. Ngu nꞌar ꞌminza hinda unga ya obxi, ne hingi tu̱ju̱ ya iuxi ha ya nkꞌaxhnaꞌmini. ");
INSERT INTO otqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Njapꞌu̱ ar hoga ꞌba̱iza tsa̱ da tsꞌipa nöꞌö te uni, ha nöꞌö hingar hogaza hingi tsa̱ da tsꞌipabi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Xi nꞌar hoga ꞌba̱iza, hage tsa̱ da unga nöꞌö hingi ho da tsꞌi. Wa nꞌar tsꞌoza, hage tsa̱ da unga nöꞌö xiñho da tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gatho ya ꞌba̱iza hingi unga nöꞌö xiñho da tsꞌi, da nkꞌu̱tsꞌi ne da tꞌu̱ꞌsa har tsibi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jange gi pöhu̱ togo yá kate mꞌe̱hni Jö empꞌö, xki hyanthwu̱ yá tsꞌoꞌbe̱fi o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hinga gatho nuꞌu̱ engagi: Ma tsi Hmuꞌi, ma tsi Hmuꞌi, ma da yu̱tꞌa hár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi; ho̱nse̱ nuꞌu̱ o̱tꞌa nöꞌö mönga ma Dada bi ꞌbu̱hnu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Núꞌmu̱ xta göxa xo̱ge, nze̱ye̱ ma da ꞌñengagi nuya paꞌu̱: Ma tsi Hmuꞌihe, ma tsi Hmuꞌihe, nuje da ju̱ñꞌahe ár tsꞌe̱di ri thuhu da mömpꞌahe ri mhö, da e̱ñhe ya tsꞌondöhi, ne da o̱the nze̱ye̱ ya ntꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ha nuga ma ga thötwabi: Hiñhamꞌu̱ xta mpöhwihu̱. ꞌWehu̱, ꞌyo̱tꞌatsꞌokiꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nöꞌö togo da ꞌyo̱ nuya mhö di xiꞌahu̱ ne da ꞌyo̱tꞌe, nöꞌö ma ga he̱ka ngu nꞌar ñꞌo̱ho̱ benga nöꞌö ma da me̱fi, ne bi hyo̱ ár ngu har medo. ");
INSERT INTO otqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mꞌe̱fa ba e ya döꞌye, ba kö ya nzo̱the ne bi ñꞌo ya ꞌyomndöhi. Gathoyu̱ bi zu̱ har nguꞌö, himbi dextꞌi ngetho mi thötꞌa xiñho har medo. ");
INSERT INTO otqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ha nöꞌö togo da ꞌyo̱xa nuya mhöyu̱ ne hinda ꞌyo̱tꞌe, nöꞌö ñhe̱hwi nꞌar jöꞌi hingi benga nöꞌö pe̱fi, ne bi hyo̱ ár ngu har ꞌbaxka ꞌbomu. ");
INSERT INTO otqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ba e ya döꞌye, bi gö ya nzo̱the, bi ñꞌo ya ꞌyomndöhi bi zu̱ nöꞌö ar nguꞌö, bi yo̱tꞌe xo̱ge ne gatho bi mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nu mi wa ar Hesu bi mönga njapꞌu̱, ya jöꞌi xa mi ꞌyo̱da nöꞌö xki xipabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngetho mi hömpa ár tsꞌe̱di Jö, hinge ngu nuya bötꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nu mi gö ar Hesu har tꞌo̱ho̱, ba köhwi nze̱ye̱ ya jöꞌi mi te̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nꞌa mbi nthe̱witho nꞌar jöꞌi mi tsitꞌa ár ndoꞌyo, ba e bi nda̱ndihmö hár wa ar Hesu ne bi ꞌñembabi: —Ma tsi Hmuꞌi, nuꞌmu̱ gi ne, da tsa̱ gi o̱thegi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ar Hesu bi maka ár ꞌye̱, bi hñuꞌspabi ne bi ꞌñembi: —Hö, di ne ga o̱theꞌi. Dá dixꞌaꞌi. Ngu mi wadi bi mönga njapꞌu̱, nunar tsi jöꞌi dama bi hñöka ár hñeni. ");
INSERT INTO otqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Hinto ma gi xipabi, ho̱nse̱ di ma har nijö da hyantꞌa ar möjö, ne hñöxa ri mꞌo̱ñho̱ ngu bi mönga ar Moise, ne da hyantꞌaꞌi ya jöꞌi xi dixꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nꞌagi ar Hesu mi yu̱tꞌa har hnini Nkapernaum, ba e bi zu̱di nꞌar döndogu me Nroma, mi a̱pa ar möte. ");
INSERT INTO otqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ne bi ꞌñembabi: —Ha gi o̱de, tsi Tata. Nꞌa ma ꞌbe̱go oxa ar tꞌoxi ꞌwe̱tsꞌi, hingi tsa̱ da ꞌñöni, xa tho ya u̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nuꞌmú̱ ar Hesu bi ꞌñenö: —Gar manu̱, ma ga o̱thega. ");
INSERT INTO otqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nunar ndöꞌö bi dödi ne bi ꞌñenö: —Hinꞌö, tsi Tata, ngetho hindi ꞌñepkagi gi ku̱tꞌa ha ma ngu. Nöꞌö di a̱ꞌi, ho̱nse̱ gi mö da dixa ma ꞌbe̱go, nuga di ñꞌemu̱i da njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngetho nuga ꞌbu̱ togo ꞌbe̱pkagi, ha di pe̱ꞌsa ya ndogu di ꞌbe̱pabi nꞌehe. Nuꞌmu̱ ga emba nꞌa, di manu̱, da ma. Ha nuꞌmu̱ ga emba manꞌa, ba ehe, da ehe. Nuꞌmu̱ ga emba ma ꞌbe̱go: ꞌYo̱tꞌa nunar ꞌbe̱finu̱, da ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nu mi ꞌyo̱xa njapꞌu̱ ar Hesu xa bi ꞌyo̱tho, ne bi ꞌñemba ya jöꞌi mi te̱ni: —Xa majöni di xiꞌahu̱, hinxta tinga nꞌar me Israel di pe̱ꞌsa nꞌar ñꞌemu̱i ngu nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne di xiꞌahu̱, ma da e nze̱ye̱ xo̱ge ár nxidi ar ximha̱i da yu̱tꞌa mhetsꞌi da hñuxkwi ar Abra, ar Isa ne ar Hakob hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ha nuꞌu̱ ndi ꞌñepahmö nda ꞌyu̱tꞌa mhetsꞌi hár tsꞌu̱tꞌwi Jö, hinda ma da tꞌumba ar se̱ki. Ma da tꞌe̱nga nthi, da tꞌetꞌa har ꞌbe̱xui habu̱ ma da nzoni ne da guxtꞌa yá tsꞌi di tho ya u̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nepꞌu̱ ar Hesu bi ꞌñemba ar döndogu: —Di ma ri ngu, da njapꞌu̱ ngu xka ñꞌemu̱i. Ne geꞌmu̱ dama bi dixa ár ꞌbe̱go. ");
INSERT INTO otqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nꞌagi ar Hesu bi ma hár ngu ar Pedro, ka bi dinbabinu̱ ár to mi the̱ ar mpatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ar Hesu bi mipa ár ꞌye̱, ne dama bi hye̱ ar mpatꞌi mi the̱. Bi nanga nunar ꞌbe̱hñönu̱, ne bi umbabi te nda ziꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mi taknxui ba tsꞌimpa ar Hesu nze̱ye̱ xki nthe̱xkwi ya tsꞌondöhi, ha nöꞌö nꞌadar mhö nda ꞌbe̱pabiyu̱, dama nda bo̱ni, ne bi o̱the gatho ya da̱thi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Njapꞌu̱ bi tho ngu xki mönga ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: Gese̱ꞌö bi hñögagihu̱ ma hñenihu̱, ne bi hñöska ma u̱gihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nꞌagi mi hyanda ar Hesu xki gotꞌatho ya jöꞌi, bi ꞌñemba yá ma̱xte: —Möhö ꞌrandi ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nꞌa mba epꞌu̱tho nꞌar bötꞌofo, ne bi ꞌñemba ar Hesu: —Tsi Utate, ga te̱ñꞌaꞌi habu̱ gatho gi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ne bi dötwabi ar Hesu: —Ya miñꞌo pe̱ꞌsa yá oki habu̱ ku̱, nuya tsꞌintsꞌu̱ pe̱ꞌsa yá mꞌafi, ha Nöꞌö Togo ba e bi Njöꞌi hiñꞌotho habu̱ da me̱ ár ñö. ");
INSERT INTO otqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Manꞌa nuꞌu̱ mi te̱ni bi ꞌñembabi: —Ma tsi Hmuꞌi, ꞌraka ar se̱ki ma ga a̱ ma dada, ne xka pengi, ga te̱ñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ar Hesu bi döti ne bi ꞌñembabi: —Hye̱pꞌu̱ nuꞌu̱ xi du da ꞌya̱ nuꞌu̱ mahye̱gi xi duwi, ne ba e te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mi bo̱xa ar Hesu har motsa, nuyá ma̱xte bi de̱ni nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Núꞌmu̱ mi ku̱ har dehe, bi ñꞌo nꞌar ꞌyomndöhi. Yá mfe̱tsꞌi ar dehe mi hexta ar motsa, har Hesu mi ötho. ");
INSERT INTO otqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nuyá ma̱xte bi ma ba ꞌya̱, ne bi ꞌñembabi: —Tsi Hmu, fa̱xkagihe, ꞌbu̱tho ga jöthu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ne nöꞌö bi ꞌñembabi: —Yoꞌö gi ntsuhu̱. Tema bi ja ri jamfihu̱. Ne bi nangi bi zu̱ ar ꞌyomndöhi ne ar ñho̱nthe, ne dama bi ñhetho. ");
INSERT INTO otqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nuꞌmú̱ nuyá ma̱xte xa bi ꞌyo̱tho ne mi eñꞌu̱: —Togonu̱ ꞌmu̱, ar ꞌyomndöhi ne ar dehe o̱ta nöꞌö ꞌbe̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nu mi zo̱ngwi ar Hesu yá ma̱xte ꞌrandi ar dehe har ha̱i Gadara, ba e yoho ya ñꞌo̱ho̱ bi zu̱di xki nthe̱xkwi ya tsꞌondöhi, ba po̱nga ha ya tꞌa̱gi, xa ma ya ntsꞌo, hinto mi tsa̱ nda tho har ꞌñu habu̱ mi ꞌbu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nuya ñꞌo̱ho̱yu̱ bi ñö ntsꞌe̱di ne bi ꞌñemba ar Hesu: —Te gi hongwa Hesu, ár Tꞌu̱ꞌi Jö. Hage xka e gi ꞌraje ar mfe̱i mödi hingi tso̱ta ar pa. ");
INSERT INTO otqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mi ꞌyonu̱ yapꞌu̱ nꞌa mutꞌi ya tsꞌu̱di mi ñuni. ");
INSERT INTO otqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nuya tsꞌondöhi bi ꞌya̱pa ar möte ar Hesu ne bi ꞌñembabi: —Nuꞌmu̱ ma gi ꞌye̱ngagihe, ꞌraje ar se̱ki ma ga ku̱the ha ya tsꞌu̱di ꞌyonu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Hö, di möhu̱ ma ba ku̱thu̱. Nuꞌmú̱ ya tsꞌondöhi bi bo̱nga ha ya ñꞌo̱ho̱, ne bi ma ba ku̱tꞌa ha ya tsꞌu̱di. Ne gatho nuya tsꞌu̱di dama bi nixtꞌi ba ñho̱ma ha nꞌar maꞌye, ba tso har dehe ne bi jötꞌa gatho. ");
INSERT INTO otqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nuꞌu̱ mi su ya tsꞌu̱di xa bi ntsu bi nixtꞌi, ma ba ku̱tꞌa har hnini. Nu mi zo̱ñꞌu̱, dama bi xipa ya jöꞌi nöꞌö tema xki ja nuya ñꞌo̱ho̱ mi nthe̱xkwi ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gatho ya mengu nor hniniꞌö bi bo̱ñꞌu̱ ma ba tsu̱ ar Hesu, ne mi hyantꞌu̱, bi ꞌya̱pa ar möte nda bo̱ni nda zokwabinu̱ yá ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nuꞌmú̱ ar Hesu bi bo̱xa har motsa ne bi ꞌranga ꞌrandi ar dehe, bi menga hár ha̱i manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mi zo̱nga hár ñöni ar dehe, ba tsꞌimpa nꞌar ñꞌo̱ho̱ xki nza ár ndoꞌyo mi oxa ha nꞌar tꞌoxi, ne nu mi hyandwa yá ñꞌemu̱i nuꞌu̱ mi tsihi, ar Hesu bi ꞌñemba ar da̱thi: —Ndada, yo gi tu ri mu̱i, ngetho xi mpumpꞌa ri tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nuꞌmú̱ ꞌra ya bötꞌofo mi bense̱ njawa: Nunar ñꞌo̱ho̱nu̱ po̱ntho tsanga Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nunar Hesu mi pötwatho yá mfeni, jange bi ꞌñembabiꞌu̱: —Yoꞌö gi beñhu̱ hingi ho nöꞌö di mönga. ");
INSERT INTO otqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Temar ñhembi ga xipabinu̱: Xi mpumpꞌa ri tsꞌoki, wa ga embabi: Nangi gi ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pöhu̱ꞌmu̱, Nöꞌö Togo ba e bi Njöꞌi pe̱ꞌskwa ar tsꞌe̱di har ximha̱i da pungya tsꞌoki, hyanthu̱ꞌmu̱ te di pe̱fi. Nuꞌmú̱ ar Hesu bi ꞌñemba ar da̱thi: —Nangi, ju̱xa ri fidi, di ma ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nuꞌmú̱ ar da̱thi dama bi nangi, bi ma ár ngu. ");
INSERT INTO otqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mi hyanda ya jöꞌi nöꞌö xki thogi, xa mi ꞌyo̱tho, mi nsundabi Jö togo xki umba ar tsꞌe̱di ya meximha̱i da ꞌyo̱tꞌa ya döta ntꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ar Hesu bi thohnu̱ bi ma, ne har ꞌñu bi hyanda nꞌar ñꞌo̱ho̱ ár thuhu ar Mateo mar njotꞌabojö, mi huxa habu̱ mi njutꞌa ar bojö mi jotꞌa ya ndö, ne bi ꞌñembabi: —Ba ehe, te̱ngagi. Ha nöꞌö bi nangi bi de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mꞌe̱fa ar Hesu bi hñuhwi har mexa hár nguꞌö, ne nze̱ye̱ ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki ba e bi hñuhwi ar Hesu mi ꞌbu̱hwinu̱ yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nu mi hyanda njapꞌu̱ ya de̱ngaꞌbe̱pate, bi ꞌñemba yá ma̱xte ar Hesu: —Yoꞌö ñungwi ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki ri Utatehu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mi ꞌyo̱ ar Hesu bi ꞌñembabiꞌu̱: —Nuꞌu̱ ꞌyomañho hingi honga togo da o̱the, ha nuꞌu̱ hñeni hö, hoñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Di ma ba hoñhu̱ tema di bo̱nga habu̱ enö: Hindi ne gi hönju̱ ya mꞌo̱ñho̱, ꞌñuhu̱ ar nhwëki. Hinxta e ga zo ya hogajöꞌi. Xta e ga zo ya ꞌyo̱tꞌatsꞌoki da ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mꞌe̱fa ba epꞌu̱ yá ma̱xte ar Xuwa Xixthe, bi ꞌya̱mba ar Hesu ne bi ꞌñeñꞌu̱: —Yoꞌö hingi bë nuya ri ma̱xte, ha nuje ne ya de̱ngaꞌbe̱pate xa di bëhë. ");
INSERT INTO otqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ar Hesu bi ꞌñembabi: —Nuꞌmu̱ da tꞌo̱tꞌa nꞌar ngo, ne nöꞌö togo bi nthöti da zohna yá mpödi, nuyu̱ mahyoni da njohyawi, ngetho ꞌbu̱hwi nöꞌö togo tꞌo̱tꞌwa ar da̱ngo. Njapꞌu̱ ma ma̱xte nꞌehe, núꞌmu̱ di ꞌbu̱ꞌbe johyayu̱. Ma da zo̱ ar pa núꞌmu̱ xta tsꞌixkagi, nuꞌmú̱ hö, xinda ne, da bëhyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hinjoꞌo nꞌa togo ju̱ nꞌar ꞌraꞌyo mꞌo̱tꞌe po̱tꞌa nꞌar ze̱ dutu, ngetho nu xta yu̱tꞌa ar ꞌraꞌyo mꞌo̱tꞌe, da gu̱tꞌa ar ze̱ dutu ne da xe̱ döta xe̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hingi sitꞌa ar ꞌraꞌyo tꞌafi ha ya ze̱ ximhni, ngetho nuꞌmu̱ da njapꞌu̱ da xe̱ ya ze̱ ximhni, da nöꞌma ar tꞌafi ne da mꞌe̱ ya ximhni. Ha nuꞌmu̱ da sitꞌa ar ꞌraꞌyo tꞌafi ha ya ꞌraꞌyo ximhni, gatho yoho hinte da ja. ");
INSERT INTO otqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mi wadi bi mönga njapꞌu̱ ar Hesu, ba epꞌu̱ nꞌar ndö bi nda̱ndihmö ne bi ꞌñembi: —Mañhemꞌu̱tho bi du ma tꞌinxu, jange xta e ga a̱ꞌar möte gi ma gi hñuxa ri ꞌye̱; di ñꞌemu̱i da mengi da nte. ");
INSERT INTO otqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Har Hesu ne yá ma̱xte bi me̱wi nunar ndöꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Núꞌmu̱ mi ꞌyo ar ꞌñuꞌu̱, nꞌar ꞌbe̱hñö mi xotꞌwa ya ji, xki tho ꞌre̱tꞌamayoho nje̱ye̱ mi pe̱ꞌsa nunar hñeninu̱, bi zo̱nga hár xu̱tha ar Hesu ne bi da̱mba ár ñöni ár pa̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngetho mi ense̱ hár mfeni: Nuꞌmu̱ mödi ho̱nse̱ ga tha̱mbahmö ár pa̱tꞌi, da dixkagi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ar Hesu bi ñegi ne bi ꞌñemba nunar ꞌbe̱hñö: —Ma tsi tꞌinxuꞌi, njohya. Nuna ri jamfi xi jaꞌaꞌi xi dixꞌi. Ne nꞌagitho bi dixa nunar ꞌbe̱hñönu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nu mi zo̱nga ar Hesu hár ngu ar ndö xki du ár tꞌinxu, mi hyandi mi ꞌbu̱hnu̱ nuꞌu̱ mi hu̱xtꞌa ya nthu̱za, ne nze̱ye̱ ya jöꞌi xa mi umba yá mu̱i mi zoni. ");
INSERT INTO otqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bi ꞌñembabiꞌu̱: —Po̱ñhu̱, ngetho nunar nxutsinu̱, hinxi du, ötho. Ne nuya jöꞌi xa mi thentho. ");
INSERT INTO otqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nu mi bo̱nga gatho ya jöꞌi, ar Hesu bi yu̱tꞌa mbo har ngu, bi mipa ár ꞌye̱ ar nxutsi, ne nuna dama bi nangi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne nunar ꞌbedenu̱ bi nu̱nga xo̱ge nunar ha̱iꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Núꞌmu̱ mi manu̱ ar Hesu, bi de̱nga yoho ya goda̱ mi ꞌbe̱fa xa mi mafi mi eñꞌu̱: —Ár bötsiꞌi ar Dabi, hwëgagihe. ");
INSERT INTO otqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ar Hesu bi thotho ne bi yu̱tꞌa ha nꞌar ngu. Nuya goda̱ himba kohi, ba e bi yu̱tꞌu̱ har ngu nꞌehe. Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Ha gi jamfihu̱ da tsa̱ ga o̱theꞌihu̱. Bi döꞌu̱: —Hö da tsa̱, ma tsi Hmuꞌihe. ");
INSERT INTO otqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nuꞌmú̱ ar Hesu bi hñuꞌspa yá ꞌye̱ ha yá da̱ꞌu̱, ne bi ꞌñembabi: —Dá njapꞌu̱ ngu xka jamfihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ne bi xo yá da̱ꞌu̱. Ar Hesu bi hñuꞌmba yá mu̱i ne bi ꞌñembabi: —Jamasuhu̱ hinto da bö nöꞌö xi thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mödi bi nsipa njapꞌu̱, mi bo̱ñꞌu̱ bi ꞌyonga ar ꞌbede hagatho nor ha̱iꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mi bo̱nga nuya goda̱, ba tsꞌimpa nꞌar gone xki nthe̱xkwi nꞌar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ar Hesu bi ꞌye̱nga ar tsꞌondöhi, ne nunar gone bi za̱ bi ñö. Gatho ya jöꞌi mi ꞌbu̱hnu̱, xa mi ꞌyo̱tho ne mi eñꞌu̱: —Hiñhamꞌu̱ xta hanthu̱wa ha ma ha̱ihu̱ Israel nꞌar ntꞌudi ngu nöꞌö xta hanthu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ha nuya de̱ngaꞌbe̱pate mi eñꞌu̱: —Nunu̱ e̱nga ya tsꞌondöhi, ju̱mpa ár tsꞌe̱di ár ndö ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ar Hesu bi ñꞌo gatho ya döta hnini ne ya tꞌu̱lo hnini, mi ku̱tꞌa ha yá nijö ya xodyo mi utwabi, mi xipa ár hoga mhö ár tsꞌu̱tꞌwi Jö, mi o̱thebi yá hñeni ne yá u̱gi nuya mengunu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nu mi hyanda gatho ya jöꞌi xa bi nkor nhwëki, ngetho bi hyanda ngu ꞌra ya tsi de̱ti xi mfontꞌi, hinte ꞌñe ár ma̱ꞌyo da su. ");
INSERT INTO otqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nuꞌmú̱ ar Hesu bi ꞌñemba yá ma̱xte: —Xa majöni di xiꞌahu̱, nze̱ye̱ ar sofo ne txꞌu̱da ya ꞌbe̱go. ");
INSERT INTO otqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jange ꞌya̱pabihu̱ Jö togo ár me̱ti ar ꞌbe̱fi, da me̱hna maꞌra ya ꞌbe̱go, da e da gu̱xa nunar sofonu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nuꞌmú̱ ar Hesu bi zohna nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, ne bi umba ar tsꞌe̱di nda ꞌye̱nga ya tsꞌondöhi, ne nda o̱thebi tsa̱ntꞌö yá hñeni ne yá u̱gi ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gehyu̱ yá thuhu nuꞌu̱ ꞌre̱tꞌamayoho yá mpo̱te ar Hesu xki zohni: Mꞌe̱tꞌo ar Simu nöꞌö bi thuꞌspabi ar Pedro, ar Andre ár jödöpꞌu̱ꞌö, ar Hakobo ne ar Xuwa ár jödö, yá tꞌu̱yu̱ ar Sebedeo. ");
INSERT INTO otqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ar Lipe, ar Bartolo, ar Toma, ar Teo nöꞌö mar njotbojö, manꞌar Hakobo ár tꞌu̱ ar Alfeo, ar Lebeo nöꞌö bi tꞌembabi ar Tadeo. ");
INSERT INTO otqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nöꞌö manꞌar Simu xki ñꞌowi nuꞌu̱ mi ntuhni mi ñönga ár hnini, ne ar Huda Iskariote nöꞌö mꞌe̱fa bi da̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ar Hesu bi me̱hna nuꞌu̱ ꞌre̱tꞌamayoho yá mpo̱te xki hwahni ne bi ꞌñembabiꞌu̱: —Yo ma gi thohu̱ habu̱ bi ꞌbu̱ nuꞌu̱ hingya xodyo. Yo gi ku̱thu̱ ha yá hnini ya me Nsamaria. ");
INSERT INTO otqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Di ma ba zohu̱ ya me Israel nuꞌu̱ ꞌbu̱ ngu ya tsi de̱ti hinte ꞌñe yá ma̱ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Di möhu̱ ne gi ꞌñembabihu̱ njawa: Ár tsꞌu̱tꞌwi Jö ꞌba̱pꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","O̱thehu̱ ya da̱thi, ne hñöjwu̱ yá hñeni nuꞌu̱ tsu̱ ar tsitꞌandoꞌyo, jafu̱ da nte nuꞌu̱ xi du, ꞌye̱mbabihu̱ ya tsꞌondöhi nuꞌu̱ togo xi nthe̱xkwi. Xta hwëkꞌahu̱ nunar tsꞌe̱dinu̱, hwëkwathobihu̱ nu maꞌra nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yo gi nxöꞌsu̱ ar bojö xi nkꞌaxtꞌi, wa ya tꞌaxbojö, wa ya the̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yo gi te̱xju̱ ri ꞌro̱zöhu̱, yo ma gi hñöxu̱ yo mponi ar dutu, wa maꞌra ya thiza, hinte gi hñöxu̱ nꞌar ndo̱ho̱. Ngetho ar ꞌbe̱go di ꞌñepi da tꞌumba nöꞌö te kꞌatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nu xki tso̱ñhu̱ ha nꞌar döta hnini wa nꞌar tꞌu̱lo hnini, hyoñhu̱ nꞌar hogajöꞌi, ne ka gi ꞌbu̱hu̱nu̱ hár nguꞌö gatho ya pa gi oxu̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu xki ku̱thu̱ har nguꞌö, ze̱ngwahu̱ nuꞌu̱ ꞌbu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nuꞌmu̱ da ꞌraꞌahu̱ nse̱ki, ár hogamꞌu̱i Jö da zu̱ꞌu̱. Ha nuꞌmu̱ hinda ꞌraꞌahu̱ nse̱ki, ar njöpi xka ꞌya̱fu̱, da mengi da zu̱ꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nuꞌmu̱ hinto da ꞌyo̱xꞌahu̱, ne hinto da jamfi nöꞌö gi xifu̱, po̱ñhu̱ har nguꞌö wa har hniniꞌö, ne gi hwöthu̱ ri wahu̱, da hyo̱ ar fontha̱i xi watꞌa ha ri thizahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Xa majöni di xiꞌahu̱, nunar pa da thöxamajöni, nunar hniniꞌö ma da hñönga nꞌar döta mfe̱i, di töta ár mfe̱i ya hnini Sodoma ne ar Gomora. ");
INSERT INTO otqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nupya di pe̱ñꞌahu̱ gi möhu̱, ma gi ꞌyohu̱ ngu ya tsi de̱ti madeda ya miñꞌo. Jange zo̱tꞌa ri da̱hu̱ ngu nꞌar kꞌeñö, ne di hñöxꞌahu̱ nꞌar tsi domtxu. ");
INSERT INTO otqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jamasuhu̱ ngetho ya jöꞌi ma da da̱tꞌahu̱ ha yá ꞌye̱ ya tsꞌu̱tꞌwi, ne ma da me̱pꞌahu̱ ha yá nijö. ");
INSERT INTO otqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nuꞌu̱ ma da da̱tꞌahu̱ ha ya tsꞌu̱tꞌwi, ma da mꞌa̱pꞌahu̱ ha ya ndö ngetho gi te̱ngagihu̱. Njapꞌu̱ gi da̱twabihu̱ majöniyu̱, ne nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Núꞌmu̱ xta tsꞌoñꞌahu̱, yo gi tu ri mu̱ihu̱ tema gi möñhu̱ wa tema gi thöhu̱, ngetho geꞌmu̱ Jö ma da ꞌraꞌahu̱ gatho nöꞌö gi möñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hingo ma gi ñöse̱hu̱; nu ár Hñö Jö ar Dada go ma da mönga nöꞌö da bo̱nga ha ri nehu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nuya paꞌu̱ ya jöꞌi ma da u̱tsase̱ yá ku, ma da da̱ da tho. Nuya dada da da̱ yá tꞌu̱, nuya tꞌu̱ ma da u̱tsa yá dada, ne da da̱ꞌu̱ da tho nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gatho ya jöꞌi ma da u̱tsaꞌihu̱ ngetho gi te̱ngagihu̱, ha nöꞌö togo da ze̱tatho da do̱ꞌmi da göxa xo̱ge, go ma da mpo̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nuꞌmu̱ da ntꞌu̱tsaꞌihu̱ ha nꞌar hnini, po̱ñhu̱ di möhu̱ manꞌa. Xa majöni di xiꞌahu̱, hingi jwahu̱ gi ꞌyohu̱ xo̱ge ya hnini har ha̱i Israel, ne Nöꞌö Togo ba e bi Njöꞌi da menga manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ar ma̱xte hingi töpa ár nsu ár utate, ha nꞌar ꞌbe̱go hingi töpa ár nsu ár hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Xiñho nuꞌmu̱ ar ma̱xte da ñhe̱hwi ár utate, ne ar ꞌbe̱go da ñhe̱hwitho ár hmu. Nuꞌmu̱ ar dada bi tꞌembabi ar Belsebu, hanja to̱ꞌmi da nsipabi yá bötsi ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jange hinto gi tsuhu̱wa, ngetho hiñꞌotho tema xi tꞌögi ne hinda thandi, wa tema xi tꞌo̱tꞌa ñꞌöntho ne hinda födi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nöꞌö di utꞌase̱hu̱ ñꞌöntho, utwabihu̱ gatho ya jöꞌi, ha nöꞌö di xiꞌahu̱ njantetho, möñhu̱ ntsꞌe̱di, da ꞌyo̱ gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yo gi tsuhu̱ togo ne da hyoꞌahu̱, ngetho ri pahu̱ hingi tsa̱ da hyoꞌu̱. Tsuhu̱ Jö togo pe̱ꞌsa ar tsꞌe̱di da me̱hna ri pahu̱ ne ri ndoꞌyohu̱ har tsibi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nuya tsi tsꞌintsꞌu̱ hingi hmödi, tꞌunga yoho ha nꞌar tsi ku̱tꞌa, ha hinda za̱ da da̱ nꞌa har ha̱i nuꞌmu̱ hinda ungar se̱ki Jö ar Dada. ");
INSERT INTO otqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xiꞌahu̱hmö. Ngetho ri xtöhu̱, Jö pödi hanguꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jange yo gi ntsuhu̱, ngetho gi töfu̱ ár nsu nꞌa mutꞌi ya tsꞌintsꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nöꞌö togo da da̱tkagi majöni ha yá nthandi ya jöꞌi xi bökagi, nuga nꞌe ma ga da̱majöni xi bökagi hár nthandi ma Dada bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ha nöꞌö togo da ko̱ngagi ha yá nthandi ya jöꞌi, nuga nꞌehe ma ga ko̱nga hár nthandi ma Dada bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yo gi hu ri mu̱ihu̱ xta e ga jöꞌsa ya tuhniwa har ximha̱i. Hinꞌö, ma da ga̱hni ngetho xta ehe. ");
INSERT INTO otqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Xta e ga heka ya jöꞌi: nuya tꞌu̱ ma da do̱xa yá dada, nuya tꞌinxu ma da do̱xa yá nönö, ha nuya tsꞌihwe̱ ma da do̱xa yá tsa. ");
INSERT INTO otqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nuyá ñꞌu̱ni ya jöꞌi ma da bo̱nga ha yá nguse̱. ");
INSERT INTO otqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nöꞌö töte ár mhöte pe̱ꞌspa ár dada wa ár nönö, ne mꞌe̱fa ka mökagiga, hindi ꞌñepi da de̱ngagi. Ne nöꞌö töte ár mhöte pe̱ꞌspa ár tꞌu̱ wa ár tꞌinxu, ne mꞌe̱fa ka mökagi, hindi ꞌñepanu̱ nꞌehe da de̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ne nöꞌö togo hinda ꞌye̱ntꞌa ár te da de̱ngagi, hindi ꞌñepi ga ñꞌoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nöꞌö togo xa suwa ár te har ximha̱i, ma da ꞌbe̱di. Ha nöꞌö da ꞌbe̱ ár te te̱ngagi, ma da dinga ár te hiñhamꞌu̱ da thege. ");
INSERT INTO otqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nöꞌö togo da ꞌraꞌahu̱ ar se̱ki go xi ꞌrakagiga, ha nöꞌö togo ꞌraka ar se̱kiga go umba ar se̱ki nöꞌö togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nöꞌö togo da umba ar se̱ki nꞌár mꞌe̱hni Jö ngetho mar mꞌe̱hni, ma da hñönga ar nthöhö ngu ar mꞌe̱hni. Ha nöꞌö da umba ar se̱ki nꞌar hogajöꞌi ngetho mar hogajöꞌi, ma da hñönga nꞌar nthöhö mahye̱gi ngu hönga nꞌar hogajöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne nöꞌö togo da umba nꞌa tsi ꞌbada ar tse̱the nꞌa nuya tsi hyoyayu̱ te̱ngagi, xa majöni di xiꞌahu̱ hinda ꞌbe̱ ár nthöhö. ");
INSERT INTO otqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nu mi wa ar Hesu bi xipa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte teme nda me̱fi, bi ma ba tso̱nga ya hnini har ha̱iꞌö, mi uta ya jöꞌi ne mi mönga ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Núꞌmu̱ mi o har fa̱di ar Xuwa Xixthe, bi ꞌyo̱ gatho nöꞌö mi o̱tꞌa ar Hesu, jange bi me̱hna yoho yá ma̱xte ma ba kꞌötsꞌi, ");
INSERT INTO otqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ne bi ꞌñembabi: —Ha go geꞌe ár mꞌe̱hni Jö ma nda ehe, wa ga to̱ꞌmhe manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Di möhu̱ ba xifu̱ ar Xuwa nöꞌö xka ꞌyo̱hu̱ ne xka hyanthu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nuya goda̱ xo yá da̱, ya dowa ꞌyo, ya gogu o̱de, nuꞌu̱ tsu̱ ar tsitꞌandoꞌyo thitsꞌi, nuꞌu̱ xi du pengi nte, ha nuya tsi hyoya xi nsipabi ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nza̱tho nöꞌö togo hinda u̱ ár mu̱i xi zo ár gu nöꞌö di pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nu mi bo̱ni bi ma yá ma̱xte ar Xuwa Xixthe, ar Hesu bi ndu̱i bi no̱nga ar Xuwa ne bi ꞌñemba ya jöꞌi: —Togo ma ga hyanthu̱ har otꞌatꞌo̱ho̱. Hage ma ga hyanthu̱ nꞌar ñꞌo̱ho̱ hinte mi pe̱ꞌsa ár tsꞌe̱di, ngu nꞌar xithi hwönda ar ndöhi. Hinꞌö wainꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Te ga po̱ñhu̱ ga hyanthu̱ ꞌmu̱. Hage nꞌar ñꞌo̱ho̱ mi he ya dutu ximhödi. Hinꞌö, ngetho nuꞌu̱ kö yá nza̱tho dutu ꞌbu̱ ha yá ngu ya ndöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tema ga po̱ñhu̱ ma ga hyanthu̱ ꞌmu̱. Hage nꞌár mꞌe̱hni Jö. Hö, ne xa majöni di xiꞌahu̱, hinge ho̱nse̱ nꞌár mꞌe̱hni Jö, pe̱ꞌsa manꞌar döta nsu. ");
INSERT INTO otqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ngetho gehnu̱ xki nho̱nga mamꞌe̱tꞌo har Tꞌofo habu̱ enö: Nuga di pe̱hna ma mꞌe̱hni da mꞌe̱tꞌo da hyokꞌa ar ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Xa majöni di xiꞌahu̱, hinxi mꞌu̱ manꞌar ñꞌo̱ho̱ di töpa ár nsu ar Xuwa Xixthe. Mödi njapꞌu̱hmö, nöꞌö ar tsi tꞌu̱lo xi yu̱tꞌa hár tsꞌu̱tꞌwi Jö, töpa ár nsu ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nuya pa bi ndu̱i bi xixthe ya jöꞌi ar Xuwa ne nubyatho, ár tsꞌu̱tꞌwi Jö tho ar nhweni, ne ho̱nse̱ nuꞌu̱ umbyá mu̱i go ku̱tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gatho yá mꞌe̱hni Jö ne ár tꞌofo ar Moise bi möñꞌu̱ nda e ár tsꞌu̱tꞌwi Jö, ha nu mi zo̱ ar Xuwa Xixthe bi möñꞌö mi ꞌba̱pꞌu̱tho nda zo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nuꞌmu̱ gi ne gi ñꞌemu̱ibihu̱, gehnu̱ ar Elia xka ꞌyo̱hu̱ nda penga manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nöꞌö togo tu ár gu, dá ꞌyo̱xa nöꞌö di mö. ");
INSERT INTO otqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Togo ga he̱kwabi nuya jöꞌi ꞌbu̱ nuya payu̱. Nuyu̱, ñhe̱hwi nuya bötsi hu ha ya ta̱i, mafi ñꞌengwi yá ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ne eñꞌu̱: Da hu̱xthe ma nthu̱zahe ne hinga nehu̱, da ntuhe ya thuhu ntꞌa̱gi ne hinga nzoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ngetho ba e ar Xuwa Xixthe, hinto mi ntsixkwi, ne hinto mi ñungwi, ne gi eñhu̱: Nthe̱xkwi nꞌar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mꞌe̱fa ba e Nöꞌö Togo bi Njöꞌi, to gatho ntsixkwi ne ñungwi, gi eñhu̱ nꞌar tsꞌoꞌyo ne nꞌar mihni, ár ñꞌowi ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki. Nöꞌö togo pe̱ꞌsa ar mfödi, nhekitho ha yá hoga ꞌbe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mꞌe̱fa ar Hesu bi ndu̱i bi hñuꞌmba yá hmi ya hnini habu̱ xki ꞌyo̱tꞌa ya ntꞌudi, ngetho hinxki ꞌyo̱tꞌwa yá ntso̱ꞌmi, mödi xki hyandwa ár tsꞌe̱di Jö. Ne bi ꞌñeñꞌö: ");
INSERT INTO otqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Hwëkateꞌihu̱ gar menguhu̱ Korasi ne gar me Betsaidahu̱. Ngetho nuꞌmu̱ ya me Tiro ne ya me Sidon xi hyanthmö ya ntꞌudi xi tꞌo̱tꞌa ha ri ha̱ihu̱, xi ꞌyo̱tꞌwahmö yá ntso̱ꞌmi, ne xi hyemhö ya he dumu̱i, ne xi nkoxhmö ar ꞌbospi ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jange nuga di xiꞌahu̱, nunar pa da thösꞌahu̱ majöni, ri mfe̱ihu̱ ma da döta nöꞌö ma da hñönga ya me Tiro ne ya me Sidon. ");
INSERT INTO otqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ha nuꞌahu̱ gar menguhu̱ Nkapernaum, ha gi hu ri mu̱ihu̱ ma da nju̱xꞌahu̱ mhetsꞌi. Hinꞌö, ma da tꞌeꞌahu̱ har ꞌbe̱xui. Ngetho nuꞌmu̱ har ha̱i Sodoma xi tꞌo̱thmö nuya ntꞌudi xka hyanthu̱, xi ꞌyo̱tꞌwahmö yá ntso̱ꞌmi, ne hinxi nhwati, di ꞌbu̱hmöꞌu̱ nuya payu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jange di xiꞌahu̱, nunar pa da thösꞌahu̱ majöni, ri mfe̱ihu̱ ma da döta ár mfe̱i ya me Sodoma. ");
INSERT INTO otqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nor paꞌö ar Hesu bi ñö ne bi ꞌñenö: —Di nsundaꞌi, ma tsi Dadaꞌi, gar Hmu mhetsꞌi ne gatho ar ximha̱i. Di ꞌraꞌa njamödi ngetho xka utwabi ri ntꞌuti nuꞌu̱ ngu ya tsi bötsi hintsꞌu̱ te pödi, ne xka ꞌñökwa nuꞌu̱ ja yá mfödi ne ya nimfeni. ");
INSERT INTO otqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ngetho njapꞌu̱ xka numañhoge, ma tsi Dadaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mꞌe̱fa bi ꞌñemba nuꞌu̱ mi ꞌbu̱hnu̱: —Gatho xi utkagi ma Dada. Ho̱nse̱ꞌö pötka ma mfeni. Hinto pötwa ár mꞌu̱i ma Dada, ho̱nse̱ nuga ár Tꞌu̱gi ne nuꞌu̱ xta hwahni ga utwabi. ");
INSERT INTO otqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ba ehu̱ gatho nuya gi nduhu̱ ne xi za̱ꞌahu̱, ne ga tukꞌa ri ꞌbe̱nihu̱ gi tsa̱ya̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngu nꞌar tsi boi ntꞌe̱i, hñöñhu̱ ar zanꞌwe̱i di husꞌahu̱, ne da tsa̱ gi te̱ngagihu̱ ma mꞌu̱i, dar hogajöꞌi ne hindar ñꞌetsꞌi. Nuꞌmu̱ gi ꞌbu̱hu̱ njapꞌu̱, hinda za̱ꞌahu̱ ne hinda du ri mu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngetho nunar zanꞌwe̱i di husꞌahu̱, hingi hembi gi tuxu̱, ha nunar ꞌbe̱ni di tutꞌahu̱, hingi hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nuya paꞌu̱ ar Hesu ne yá ma̱xte bi ꞌranga ha ya hwöhi xki ꞌbotꞌa ya tꞌe̱i. Mar pa ntsa̱ya̱, ha nuyá ma̱xte mi tsu̱ ar thuhu, jange bi ndu̱i bi dokwa yá ngöhö ya tꞌe̱i, mi töki mi tsaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mi hyanda ya de̱ngaꞌbe̱pate, bi ꞌñemba ar Hesu: —Yoꞌö ri ma̱xte o̱tꞌa nöꞌö hingi ho da ꞌyo̱tꞌa har pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ha nunar Hesu bi dötwabi njawa: —Ha hinxka nehu̱ habu̱ enga nöꞌö bi ꞌyo̱tꞌa ar Dabi núꞌmu̱ mi zu̱ ar thuhu, nöꞌö ne yá ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bi yu̱tꞌö hár nijö Jö, ne bi zi nuya thuhme xki ꞌbo̱ꞌspa Jö, ha nöꞌö ne yá ñꞌohu̱ himi ho nda ziꞌu̱, ho̱nse̱ ya möjö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ha hinxka nehu̱ hár tꞌofo ar Moise, nuya möjö mpe̱ har nijö, mödi ar pa ntsa̱ya̱, hingi nhu ngu nꞌar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ha nuga di xiꞌahu̱, ꞌbu̱kwa nꞌa töpa ár nsu ar nijö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nuꞌmu̱ gi pöhmöhu̱ tema di bo̱nga nöꞌö mönga ár Tꞌofo Jö habu̱ enö: Hindi ne gi hönkagihu̱ ya mꞌo̱ñho̱. Nöꞌö di ne, gi ꞌñu ri nhwëkihu̱. Nuꞌmu̱ xi zohmö ri mfenihu̱, hingi tsu̱hmöhu̱ nuyu̱ hinte xi ꞌyo̱tꞌa nöꞌö hingi njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngetho Nöꞌö Togo ba e bi Njöꞌi gehnu̱ ár Hmu ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ar Hesu bi thogi, ma ba ku̱tꞌa ha yá nijöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ka mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ xki ꞌyotꞌa nꞌár ꞌye̱. Ne nuya de̱ngaꞌbe̱pate bi ꞌya̱mba ar Hesu: —Hage xiñho gi o̱the nꞌar jöꞌi har pa ntsa̱ya̱. Bi ꞌya̱nga njapꞌu̱ ngetho mi ne nda dinga te nda hyo̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ha nunar Hesu bi ꞌñembabiꞌu̱: —Xiꞌmu̱ gi ꞌñehu̱ nꞌar tsi de̱ti ne da zo ha nꞌar otsꞌi, ha hingi hñöhu̱ mödi ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ha hinge nꞌar ñꞌo̱ho̱ töpa ár nsu nꞌar tsi de̱ti. Jange mahyoni ga o̱thu̱ ar ñho mödi ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nuꞌmú̱ ar Hesu bi ꞌñemba ar ñꞌo̱ho̱ xki ꞌyotꞌa ár ꞌye̱: —Maka ri ꞌye̱. Nöꞌö bi japꞌu̱, ne dama bi dixa ár ꞌye̱, ne bi gohi ngu nöꞌö manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nu mi bo̱nga ya de̱ngaꞌbe̱pate, bi ñꞌu̱tꞌi hanja nda tsa̱ nda hyo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ar Hesu mi pötho te mi beñꞌu̱, bi zohnu̱ bi ma, ne nze̱ye̱ ya jöꞌi bi de̱ni mi o̱thebi yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne xa mi huꞌmba yá mu̱i hinto nda metwabi togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ne njapꞌu̱ nda tho ngu xki mönga ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Gehnu̱ ma hoga ꞌbe̱go xta hutsꞌi, togo di mödi ne jakagi ga njohya. Ga umba ma Hñö, da zohna gatho ya hnini ꞌbu̱ hár nxidi ar ximha̱i, ne da xipabiꞌu̱ xi ꞌñepꞌu̱ ar pa da thöꞌspa majöni. ");
INSERT INTO otqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hinto ma da ntsa̱hñökiwi, hinda ma da mafi, ne hinda ma da tꞌo̱ ár mhö ha ya ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma da hñuꞌmba yá mu̱i nuꞌu̱ hintsꞌu̱ pe̱ꞌsa ár tsꞌe̱di yá ñꞌemu̱i, ngu nꞌar xithi ꞌbu̱tho da dehmi. Ma da me̱ꞌspa ar nhwëki nuꞌu̱ pe̱ꞌsa nꞌa tsi tu̱i ar ndo̱ꞌmi, ngu nꞌar tsibi fu̱ni. Ne da japi da ntöte ar ñho. ");
INSERT INTO otqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne gatho ya jöꞌi ꞌbu̱ hár nxidi ar ximha̱i da do̱ꞌmba ár mfa̱tsꞌi uñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nuꞌmú̱ ar Hesu ba tsꞌimpa nꞌar jöꞌi mi gone ne mi goda̱, ngetho xki nthe̱xkwi nꞌar tsꞌondöhi. Bi o̱the, ne dama bi za̱ bi ñö ne bi hyandi. ");
INSERT INTO otqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jange gatho ya jöꞌi xa mi ꞌyo̱tho, ne mi enga nꞌa ngu nꞌa: —Hage go gehnu̱ ár Tꞌu̱ ar Dabi ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ha nuya de̱ngaꞌbe̱pate mi ꞌyo̱xa nöꞌö mi mönga ya jöꞌi, bi ꞌñeñꞌu̱: —Nunu̱ hingi e̱nse̱ ya tsꞌondöhi, hömpa ár tsꞌe̱di ar Belsebu ár ndö ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nunar Hesu bi bötwatho yá mfeniꞌu̱, ne bi ꞌñembabi: —Nuꞌmu̱ nꞌar hnini da ñhege ne da ntunse̱, da jöꞌsase̱ gatho nöꞌö xi ꞌyo̱tꞌe. Ha nuꞌmu̱ da ntꞌu̱tsase̱ yá mengu nꞌar ngu, hiñꞌotho ár tsꞌe̱di, ne da nhwati. ");
INSERT INTO otqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xi ar tsꞌondöhi, hage da ꞌye̱nse̱ yá mitsꞌondöhiwi. Nuꞌmu̱ da japꞌu̱, hinte di pe̱ꞌsa ár tsꞌe̱di ne xi nhwata gatho ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gi eñhu̱ nuga di e̱nga ya tsꞌondöhi ngetho di hömpa ár tsꞌe̱di ar Belsebu. Xi ri mꞌe̱hnihu̱, tema tsꞌe̱di höꞌu̱ e̱nga ya tsꞌondöhi ꞌmu̱. Go da hñupꞌa ri hmihu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ha nuꞌmu̱ di hömpa ár tsꞌe̱di ár Hñö Jö di e̱nga ya tsꞌondöhi, pöhu̱ ꞌmu̱, xi zo̱kwa habu̱ gi ꞌbu̱hu̱ ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hanja da za̱ da yu̱tꞌa nꞌar bë hár ngu nꞌar ñꞌo̱ho̱ xa di pe̱ꞌsa ár tsꞌe̱di, da bëpa yá ñho nuꞌmu̱ hinda xo̱tꞌe mꞌe̱tꞌo. Ne xta wadi hö, ja da tsa̱ da bëpa yá ñho. ");
INSERT INTO otqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nuꞌu̱ togo hindi ñꞌoꞌbe, u̱tsagi, ne nöꞌö togo hindi musꞌbe mahye̱gi, go fontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Di xiꞌahu̱, gatho ya tsꞌoki o̱tꞌa ya jöꞌi, ne gatho ya tsꞌate möñꞌu̱, ma da mpumbabi. Ha nöꞌö togo da ꞌye̱mba ar ñömañꞌu̱ ár Hñö Jö, hinda ma da mpumbabi. ");
INSERT INTO otqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nuꞌmu̱ togo da zanga Nöꞌö ba e bi Njöꞌi, ma da mpumbabi. Ha nöꞌö togo da ñömañꞌu̱ ár Hñö Jö, hinda ma da mpumbabipya, ne hiñhamꞌu̱ da me̱ꞌsa ar pumbate. ");
INSERT INTO otqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Beñhu̱ nuꞌmu̱ ar za xiñho, ma da unga nöꞌö xiñho nꞌehe. Ha nuꞌmu̱ ar za hingi ho, hingi ho nöꞌö ma da uni, ngetho nöꞌö te unga nꞌar za, ja föpꞌu̱ tema zaꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tsꞌojöꞌihu̱ di hñöxꞌahu̱ ya kꞌeñö. Hanja da tsa̱ gi möñhu̱ nöꞌö xiñho xa gar tsꞌojöꞌihu̱. Ngetho nöꞌö ñuxa ha ri mu̱ihu̱, gehnu̱ gi möñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nöꞌö togo benga ya hoga mfeni, mönga nöꞌö xiñho, ha nöꞌö benga ya tsꞌomfeni, mönga ya tsꞌomhö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nuga di xiꞌahu̱, gatho nöꞌö te gi möñhu̱ ne hingi jamasuhu̱, ja tema gi thöhu̱ núꞌmu̱ xta thösꞌahu̱ majöni. ");
INSERT INTO otqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ngetho Jö ma da hñösꞌahu̱ majöni gatho nöꞌö gi möñhu̱, ne da nsiꞌahu̱ ri hogajöꞌihu̱ wa ri tsꞌomꞌu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nuꞌmú̱ ꞌra ya bötꞌofo ne ya de̱ngaꞌbe̱pate mi ꞌbu̱hnu̱, bi ꞌñemba ar Hesu: —Utate, di ne ga hanthe gi ꞌyo̱tꞌa nꞌar ntꞌudi, njapꞌu̱ da nheki xpa pe̱ñꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ar Hesu bi dödi ne bi ꞌñenö: —Ya tsꞌojöꞌi ꞌbu̱ nuya payu̱ a̱di da hyanda nꞌar ntꞌudi, ne hinte ma ntꞌudi da tꞌumbabi, ho̱nse̱ ár ntꞌudi ar mꞌe̱hni Honas. ");
INSERT INTO otqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngetho nöꞌö bi ñꞌo hñupa ne hñuxui mbo ár mu̱i ar döta hwö. Ma da njapꞌu̱ Nöꞌö Togo ba e bi Njöꞌi, ma da mꞌu̱ hñupa ne hñuxui hár mu̱i ar ha̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nuya me Ninibe ma da nanga har thöxamajöni, ne ma da hñuꞌmba yá hmi nuya jöꞌi ꞌbu̱ nuya payu̱. Ngetho nuꞌu̱ bi ꞌyo̱tꞌwa yá ntso̱ꞌmi núꞌmu̱ mi zo ar Honas, ha ꞌbu̱kwa nꞌa töpa ár nsu ar Honas. ");
INSERT INTO otqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nunar ꞌbe̱hñö mar ndö ndi ꞌñe makꞌangi, ma da nanga har thöxamajöni, da hñuꞌmba yá hmi nuya jöꞌi ꞌbu̱ nuya payu̱. Ngetho nuna ba e har yapꞌu̱ ha̱i nda ꞌyo̱ꞌspa ár mfödi ar Salomon, ne gi ꞌbu̱hwihu̱wa nꞌa xa töpa ár nsu ar Salomon. ");
INSERT INTO otqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nepꞌu̱ ar Hesu bi ꞌñenö: —Nuꞌmu̱ nꞌar tsꞌondöhi da hye̱ nꞌar jöꞌi, da ñꞌo ha ya otꞌatꞌo̱ho̱ di honga habu̱ da ntsa̱ya̱, ne hinte tini, ");
INSERT INTO otqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nꞌa nda bense̱ ne da ꞌñenö: Xiꞌmu̱ ga penga ha ma ngu da po̱ni. Ne xta zo̱ho̱ da dini hinto di ꞌbu̱i, xi njoki ne xi thoki xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nuꞌmú̱ nöꞌö ar tsꞌondöhiꞌö ma da hyonga ma yoto yá mitsꞌondöhiwi di töte yá ntsꞌo, ne da ku̱tꞌi da mꞌu̱hwi. Ne nunár ꞌbe̱fa mꞌu̱i nunar jöꞌi xki hye̱hmö ar tsꞌondöhi, di töte ár ntsꞌo hinge ngu ꞌbe̱tꞌo. Ma da thota yá ntsꞌo nuya jöꞌi ꞌbu̱ nuya payu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ar Hesu himi jwatho nda zo ya jöꞌi, nꞌa mbi zo̱ta ár nönö ne yá jödö mi ꞌba̱ nthi mi ne nda ñöwi. ");
INSERT INTO otqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nꞌa togo bi ꞌñembabi: —Ri nönö ne ri jödö bi ꞌba̱hnu̱ nthi, ne gi ñöwi ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ar Hesu bi dötwabiꞌö: —Togo ma nönö ne ma jödö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bi uti habu̱ mi ꞌbu̱ yá ma̱xte, ne bi ꞌñenö: —Go gehyu̱ ma nönö ne ma jödö. ");
INSERT INTO otqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ngetho gatho nuꞌu̱ o̱tꞌa ngu mönga ma Dada bi ꞌbu̱ mhetsꞌi, gehyu̱ ma jödö, ma nju ne ma nönö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nunar paꞌö ar Hesu bi bo̱nga har ngu habu̱ mi ꞌbu̱i, ne bi ma ba hu har ñönthe. ");
INSERT INTO otqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bi watꞌa nze̱ye̱ ya jöꞌi habu̱ mi ꞌbu̱ꞌö, jange bi bo̱xa ha nꞌar motsa ne ka bi hñuxnu̱, ha gatho ya jöꞌi mi ꞌba̱ har ñönthe. ");
INSERT INTO otqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ne bi metwabi nze̱ye̱ ya ꞌbede mi utwabi. Mꞌe̱tꞌo bi me nꞌár ꞌbede nꞌar motꞌi ne bi ꞌñenö: —Nꞌar motꞌi bi bo̱ni ma ba potꞌa ár hwöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Núꞌmu̱ mi mpotꞌi, nꞌa tu̱i bi zo har ꞌñu, ba e ya tsꞌintsꞌu̱ bi go bi za. ");
INSERT INTO otqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Manꞌa tu̱i bi zo ha ya do habu̱ himi köxa nze̱ye̱ ar ha̱i. Ngutꞌa bi kꞌontsꞌi ngetho himar mpidi ar ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ne nu mi bo̱xa ar hyadi bi hwixki. Himi tsa̱ nda nu̱nga yá ꞌyu̱, jange bi ꞌyotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Manꞌa tu̱i bi zo habu̱ mi ja ya ꞌmini, bi xuhña ne bi otꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ha manꞌa tu̱i bi zo habu̱ mar ñho ar ha̱i, xa bi unga nꞌar hoga sofo, ꞌra nꞌa nthehe, maꞌra hñunꞌa̱te, ne maꞌra nꞌa̱temaꞌre̱tꞌa nꞌa ngu nꞌar ꞌba̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nöꞌö togo tu ar gu da ꞌyo̱de, dá ꞌyo̱xa nöꞌö te di mö. ");
INSERT INTO otqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mꞌe̱fa yá ma̱xte bi watꞌa habu̱ mi ꞌbu̱ ar Hesu ne bi ꞌñembabi: —Yoꞌö gi zo mꞌede ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ar Hesu bi dötwabi ne bi ꞌñembabiꞌu̱: —Nuꞌahu̱, Jö utꞌahu̱ nöꞌö hinxki fö mamꞌe̱tꞌo tengu ár tsꞌu̱tꞌwi, ha nu maꞌra hinxi tꞌutwabi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngetho nöꞌö to pe̱tsꞌi, ma da thuꞌspabi, ha nöꞌö hinte pe̱tsꞌi, ma da thömba xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jange di zo mꞌede, ngetho tu yá da̱, ne hingi handi, tu yá gu, ne hingi o̱de, ne hingi tso yá mfeni. ");
INSERT INTO otqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Thohyu̱ ngu bi mönga ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: Ma gi ꞌyo̱hu̱, ne hinda zo ri mfenihu̱. Ma gi hyanthu̱, ne hingi pöhu̱ teme di bo̱nga nöꞌö gi hanthu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ngetho nuya jöꞌiyu̱ xi japi xi më yá ñö, ne hingi ne da ꞌyo̱xa nöꞌö o̱de. Xi tsꞌa̱ntꞌa yá da̱, njapꞌu̱ hinda xo yá da̱ da hyandi, ne hinda zo yá gu, hinda kwata ha yá mu̱i, ne da hñuxka yá da̱, ha nuga da tsa̱ ga umba ar nzaki. ");
INSERT INTO otqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ha nuꞌahu̱, nza̱tho ri da̱se̱hu̱ xka hyanthu̱, ne ri guse̱hu̱ xka ꞌyo̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngetho xa majöni di xiꞌahu̱, nze̱ye̱ yá mꞌe̱hni Jö ne maꞌra ya hogajöꞌi, mi nemhö nda hyanda nöꞌö gi hanthu̱pya, ha himbi tsa̱ bi hyantꞌu̱. Ne mi nemhö nda ꞌyo̱xa nöꞌö gi o̱hu̱pya, ha himbi ꞌyo̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ꞌYo̱hu̱pya tema di bo̱nga ár ꞌbede ar motꞌi da xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nöꞌö togo da ꞌyo̱xa ar mhö no̱mba ár tsꞌu̱tꞌwi Jö ne hinda zo ár mfeni, mꞌe̱fa da e ar tsꞌondöhi ne da hñömba ar mhö xki zomhö hár mu̱i, gehnu̱ nöꞌö nꞌa tu̱i bi zo har ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nuꞌu̱ maꞌra bi zo ha ya do, ngu nöꞌö bi ꞌyo̱xa ár mhö Jö ne da njohya da hñöni. ");
INSERT INTO otqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ha hinxi ꞌñetꞌa xiñho hár mu̱i nunar mhönu̱, jange xta e ya thogi ne ya ntꞌu̱tsa ngetho xi hñömga ma mhö, da ꞌwege, ngu ar tꞌe̱i hinxi nu̱nga ár ꞌyu̱ ngutꞌa da ꞌyotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nöꞌö nꞌa tu̱i bi zo habu̱ mi ja ya ꞌmini, gehyu̱ nuya xi ꞌyo̱xa ár mhö Jö, ne dama bi ꞌbe̱ ar ñꞌemu̱i, ngetho tupa ár mu̱i gatho nöꞌö te jawa har ximha̱i, ne ñhe̱gi da ka ar bojö. Gathoyu̱ da jöꞌsa ar mhö, jangutho ar tꞌe̱i hinte bi uni. ");
INSERT INTO otqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ha nu maꞌra bi zo habu̱ mar ñho ar ha̱i, gehyu̱ nuya bi ꞌyo̱xa ár mhö Jö ne bi zo yá mfeni. Xa bi unga nꞌar hoga zofoyu̱, ꞌra bi unga nꞌanthebe, ꞌra hñunꞌa̱te, ha nu maꞌra nꞌa̱temaꞌre̱tꞌa nꞌa ngu nꞌar ꞌba̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mꞌe̱fa ar Hesu bi metwabiꞌu̱ manꞌar ꞌbede ne bi ꞌñenö: —Ár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi jangu nꞌar motꞌi bi ma hár hwöhi ba potꞌa ar tꞌe̱i xi thahni. ");
INSERT INTO otqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ha núꞌmu̱ mi ö yá ꞌbe̱go, ba e ár ñꞌu̱ni ne bi motꞌwa ya nxotꞌo hár hwöhi xki motꞌa ar tꞌe̱i, ne bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nu mi te ar tꞌe̱i ne mi fu̱di nda ngöhö, bi kꞌontsꞌa ar nxotꞌo ꞌmu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nuya ꞌbe̱go bi ma ba a̱nga nöꞌö togo ár me̱ti ar hwöhi ne bi ꞌñembabiꞌu̱: Tsi ndada, ha hinga potꞌa ar tꞌe̱i xki nthahni ha ri hwöhi. Xiꞌmu̱ ha xpa e nuya nxotꞌo ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nor ñꞌo̱ho̱ꞌö bi ꞌñemba yá ꞌbe̱go: Zage nꞌa ma ñꞌu̱ni xi motꞌi. Nuyu̱ bi ꞌñembabi ꞌmu̱: Ha gi ne ma ga kꞌu̱se ya nxotꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nöꞌö togo ár me̱ti ar hwöhi bi dödi ne bi ꞌñembabiꞌu̱: Hinꞌö, yo gi kꞌu̱su̱ ngetho yo ma da kꞌu̱xkwi ya tꞌe̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hye̱hu̱pꞌu̱ da tewi mahye̱gi, ne nu xta zo̱ ár pa ar sofo, ga xipa ya xathe da xatꞌa mꞌe̱tꞌo ya nxotꞌo da dutꞌi, ne da göꞌsa har tsibi da zötꞌi. Ha nor tꞌe̱i da muntsꞌi da kwata ha ma tꞌu. ");
INSERT INTO otqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ne ar Hesu bi metwa manꞌar ꞌbede ne bi ꞌñembabi: —Ár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi ñhe̱hwi nꞌar nda̱murtasa bi motꞌa nꞌar ñꞌo̱ho̱ hár hwöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nöꞌö ar nda̱ꞌö xa tsi tꞌu̱lo töta gatho nu maꞌra. Ha nu xta te, töta gatho nu maꞌra ya kꞌani, habu̱ bi e ya tsꞌintsꞌu̱ köxa yá mꞌafi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bi xipa manꞌar ꞌbede ne bi ꞌñembabi: —Ár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi ñhe̱hwi ar njoxthuhme bi pantꞌa nꞌar ꞌbe̱hñö ha gu̱to hwada ar ju̱ni, ne bi do̱ꞌmi bi joxa xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ar Hesu gatho nöꞌö te mi xipa ya jöꞌi, mi xipa mꞌede. Nuꞌmu̱ himar ꞌbede hinte mi xipabi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Njapꞌu̱ bi thogi ngu xki mönga mahamꞌu̱ ár mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö: Mꞌede ma ga zo ya jöꞌi, Ma ga mönga nöꞌö xki tꞌögi núꞌmu̱ mi thoka ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ar Hesu mi wadi bi ꞌñe ya jöꞌi, bi ma har ngu habu̱ mi ꞌbu̱i, ne bi watꞌa yá ma̱xte, bi ꞌñembabi: —Xiꞌmu̱ gi xikagihe teme di bo̱nga ár ꞌbede ar nxotꞌo ꞌba̱ har hwöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ar Hesu bi dötwabiꞌu̱ ne bi ꞌñenö: —Nöꞌö togo potꞌa ar tꞌe̱i xi thahni, gehnu̱ Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ar hwöhi gehnu̱ ar ximha̱i, ha nöꞌö ar tꞌe̱i xi thahni, gehyu̱ nuꞌu̱ ꞌbu̱ hár tsꞌu̱tꞌwi Jö. Ha nunar nxotꞌo, nuya te̱nga ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ar ñꞌu̱ni potꞌa ar nxotꞌo, ar tsꞌondöhi. Nunar sofo gehnu̱ ár ngötsꞌi ar ximha̱i, ne nuya xathe gehyu̱ yá e̱nxe̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jangu ya xatꞌe̱i ꞌweka ar nxotꞌo da tsꞌötꞌi, njapꞌu̱ hár ngötsꞌi ar ximha̱i, ya e̱nxe̱ ma da ꞌweka nuya jöꞌi te̱nga ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nöꞌö Togo ba e bi Njöꞌi ma da me̱hna yá e̱nxe̱ da gu̱ka hár tsꞌu̱tꞌwi gatho nuya ꞌyo̱tꞌatsꞌoki ne nuꞌu̱ japa maꞌra da ntsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ne ma da tꞌu̱tꞌa har tsibi, ka ma da nzonu̱ ne da guxtya tsꞌi di tho ya u̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ne nuꞌu̱ ya hogajöꞌi ma da yotꞌu̱ ngu ar hyadi núnu̱ mhetsꞌi, habu̱ bi ꞌbu̱ ár tsꞌu̱tꞌwi Jö yá Dada. Nuꞌu̱ togo tu yá gu da ꞌyo̱de, dá ꞌyo̱xa nöꞌö di mö. ");
INSERT INTO otqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi ñhe̱hwi nꞌar mꞌe̱tsꞌi tꞌa̱ har ha̱i. Nunar mꞌe̱tsꞌinu̱ bi dinga nꞌar jöꞌi, ne bi mengi bi ꞌñö manꞌagi. Ne xa bi njohya bi ma ba pa̱ gatho nöꞌö mi pe̱tsꞌi, bi da̱nga ar ha̱i habu̱ mi tꞌa̱ ar mꞌe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nunár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi jangu nꞌar ma̱ honga ya nza̱tho do xa xi mhödi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nu mi dinga nꞌar hoga do, bi ma ba pa̱ gatho nöꞌö mi pe̱tsꞌi ne bi ma ba ta̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi jangu nꞌar ntꞌa̱tsꞌi njötꞌa har dehe ne tsa̱ntꞌö ar zuꞌwe bi gu̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nu xta ñuxa yá ntꞌa̱tsꞌi, nuya ngu̱xhwö da gu̱ka har ñönthe, ne da hñudi da hwahna nuya xiñho da ꞌyu̱tꞌa ha yá ꞌbo̱tsꞌe, ne nu maꞌra hingi ho da ꞌye̱nga nthi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma da njapꞌu̱ xta göxa ar ximha̱i, da e ya e̱nxe̱ da ꞌweka ya tsꞌomꞌu̱i xi nthöskwi ya hogajöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne da tho̱tꞌa har tsibi, ka ma da nzonu̱ ne da guxtꞌa yá tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nuꞌmú̱ ar Hesu bi ꞌya̱nga yá ma̱xte: —Ha xi zo ri mfenihu̱ gatho nöꞌö xta xiꞌahu̱. Bi döꞌu̱ ne bi ꞌñeñꞌu̱: —Hö, ma tsi Hmuꞌihe. ");
INSERT INTO otqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nuꞌmu̱ nöꞌö bi ꞌñembabiꞌu̱: —Njapꞌu̱ nꞌar bötꞌofo pötwa xiñho ár tsꞌu̱tꞌwi Jö, ñhe̱hwi nꞌar dada pe̱ꞌsa ár mꞌe̱tsꞌi, ne ju̱ka nuꞌu̱ mi ja mahamꞌu̱ ne nuꞌu̱ ja getya xi nja. ");
INSERT INTO otqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mi wadi bi mönga nuya ꞌbedeyu̱, bi ma bi zohnu̱ nunar hnininu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ne bi zo̱nga hár ha̱iꞌö, mi ku̱tꞌa ha yá nijö mi uti, ne nuya jöꞌi xa mi ꞌyo̱tho ne mi eñꞌu̱: —Ha xpa tinga ar mfödi ne ar tsꞌe̱di da ꞌyo̱tꞌa nuya döta ntꞌudiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ha hinga gehnu̱ ár tꞌu̱ ar hye̱nza. Ha hingar Maria ár nönönu̱, ne ár jödö ar Hakobo, ar Huse, ar Simu ne ar Huda ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ha hinge di ꞌbu̱hwihu̱wa yá nju nꞌehe. Ha xpa pöhnu̱ gatho nöꞌö mö ne o̱tnu̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ne nuya mengunu̱ xa mi tso̱tꞌa yá mu̱i, jange ar Hesu bi ꞌñembabiꞌu̱: —Nꞌár mꞌe̱hni Jö habu̱ gatho hnumansu, ha nu hár ha̱ise̱ hinꞌö, ne hár nguse̱. ");
INSERT INTO otqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jange himbi ꞌyo̱tꞌa nze̱ye̱ ya döta ntꞌudinu̱, ngetho ya jöꞌi himi ñꞌemu̱ibi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nuya paꞌu̱ ar ndö Erode bi zo ár gu gatho nöꞌö mi o̱tꞌa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ne bi ꞌñemba yá ꞌbe̱go: —Nöꞌö ar ñꞌo̱ho̱ꞌö, gehni ar Xuwa Xixthe xi mengi xi nte, jange pe̱ꞌsa nor tsꞌe̱diꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ar Erode mi mönga njapꞌu̱ ngetho xki gu̱ ar Xuwa Xixthe, xki dötꞌi, ne xki gotꞌa har fa̱di. Nunu̱ mi hökwahmö hinge nda mꞌu̱hwi ar Erodia ár ꞌbe̱hñö ar Lipe ár jödöpꞌu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ngetho ar Xuwa Xixthe xki ꞌñemba ar Erode: —Hingi ho gi ꞌbu̱hwi nunar ꞌbe̱hñönu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jange ar Erode mi ne nda hyo. Himbi ꞌyo̱tꞌe ngetho mi tsu ya jöꞌi, nuyu̱ mi jamfi már mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ha nꞌagi mi tꞌo̱tꞌwa ár da̱ngo ar Erode, nunár tꞌinxu ar Erodia bi nei madeda gatho nuꞌu̱ mi ꞌbu̱hnu̱, ha nu ar Erode xa bi numañho. ");
INSERT INTO otqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jange bi ñötꞌwabi nda umba gatho nöꞌö nda ꞌya̱di, ne bi ꞌñetꞌa made Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nuꞌmú̱ ar nxutsi bi ꞌñemba ar Erode: —Di ne gi ꞌrakagiwa ár ñö ar Xuwa Xixthe ha nꞌar manza. Go bi ꞌya̱ꞌö ngetho ár nönö xki ꞌyu̱tꞌi tema nda ꞌya̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ar ndö Erode xa bi zo̱tꞌa ár mu̱i. Mödi njapꞌu̱ himbi tsa̱ bi ponga ár ne, ngetho xki ꞌñetꞌa made Jö, ne xki ꞌyo̱xa gatho nuꞌu̱ mi ꞌbu̱hwinu̱ har mexa. Jange bi mö nda tꞌumbabi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ne bi möñꞌö nda the̱kwa ár ñö ar Xuwa Xixthe har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba thömpa ár ñö ha nꞌar döta manza, bi tꞌumba ar nxutsi, ne nunu̱ bi hñöꞌspa ár nönö. ");
INSERT INTO otqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mꞌe̱fa bi zo̱ yá ma̱xte har fa̱di habu̱ mi jothmö, bi hñöꞌspa ár ndoꞌyo ma ba a̱gi, ne bi maꞌu̱ ba xipa ar Hesu nöꞌö xki thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mi ꞌyo̱ ar Hesu njapꞌu̱, bi bo̱xa ha nꞌar motsa, bi ꞌranga ꞌrandi ar dehe, bi ma habu̱ hinto mi ꞌbu̱i. Ha nu mi ꞌyo̱ ya jöꞌi ndi manu̱, ba po̱nga ha ya hnini, bi ma watho ma ba kꞌötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nu mi bo̱nga ar Hesu har ñönthe, bi hyandi mi ꞌbu̱hnu̱ nze̱ye̱ ya jöꞌi mi to̱ꞌmi. Xa bi hwëki ne bi o̱thebi yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nu mi nde bi watꞌa yá ma̱xte habu̱ mi ꞌba̱ꞌö, ne bi ꞌñembabi: —Pe̱hna ya jöꞌi ma da da̱nga te da zi ha ya tꞌu̱lo hnini, ngetho bi nde, ne te da dingwa habu̱ di ꞌbu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Hinda ma da hyonga te da ziyu̱, go ma gi umfu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nuyá ma̱xte bi dödi ne bi ꞌñeñꞌu̱: —Habu̱ ga tiñhe tema ga umfeyu̱. Ho̱nse̱ ꞌbu̱kwa ku̱tꞌa ya thuhme ne yoho ya tsi hwö. ");
INSERT INTO otqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ne ar Hesu bi ꞌñenö: —Ba höhu̱wa. ");
INSERT INTO otqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mꞌe̱fa bi xipabi ya jöꞌi nda hñu ha ya do̱ni. Ne bi gu̱ nuꞌu̱ ku̱tꞌa ya thuhme ne yoho ya tsi hwö, bi no̱ꞌsa mhetsꞌi bi jöpi, bi heke ne bi thokwabi yá ma̱xte, ne nuyu̱ bi hemba ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gatho ya jöꞌi bi ñuni ne xa bi niñö, ha nuya xe̱ni bi bongi bi njo, ne bi ñhuꞌsa ꞌre̱tꞌamayoho ya ꞌbo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nuꞌu̱ togo bi ñuni mi tsu̱ ngu ngu̱dminthebe ya ñꞌo̱ho̱, himbi yu̱tꞌa ar mꞌede ya ꞌbe̱hñö ne ya bötsi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nepꞌu̱ ar Hesu bi xipa yá ma̱xte nda bo̱xa har motsa, ne nda mꞌe̱tꞌo ndi ma ꞌrandi ar dehe. Nöꞌö nda gotho nda ꞌñe ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nu mi ñꞌehwi gatho ya jöꞌi, bi bo̱xase̱ har tꞌo̱ho̱ ma ba a̱pa Jö. Nu mi nxui mi ꞌbu̱se̱nu̱ har tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ha nunar motsa mi ꞌyo madedar ñho̱nthe, ne xa mi mfe̱tsꞌi ngetho mi nto̱xkwi ar ndöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngu nꞌar hñumxudi ar Hesu bi ma ba tsu̱ yá ma̱xte, mi ꞌyoda mañö ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nuyá ma̱xte mi hyandi mi ꞌyo mañö ar dehe, xa bi ntsu ne mi eñꞌu̱: —Atho di hanthu̱ nꞌar pite. Ne xa mi mafi mi ntsuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ha nunar Hesu bi zofo ne bi ꞌñembabiꞌu̱: —Go gekaga, yo gi ntsuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nuꞌmú̱ ar Pedro bi ꞌñenö: —Ma tsi Hmuꞌi, nuꞌmu̱ xa majöni go geꞌe, ꞌbe̱pkagi ga ꞌyo mañö ar dehe ma ga tsu̱ꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ne ar Hesu bi ꞌñembabi: —Ba e xö. Ar Pedro bi gö har motsa, bi ma nda tsu̱ ar Hesu mi ꞌyoda mañö ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ha nu mi za̱ ar ndöhi bi zu, jange bi ndu̱i bi yu̱ har dehe. Dama bi mafi ne bi ꞌñenö: —Ma tsi Hmuꞌi, ju̱xkagi, ꞌbu̱tho ga jötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nuꞌmú̱ ar Hesu ngutꞌa bi pe̱ntꞌi, ne bi ꞌñembabi: —Yoꞌö ga ntsu, ha hingi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bi bo̱xkwi har motsa, ne ngutꞌa bi ntsa̱ya̱ ar ndöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nu maꞌra xki go har motsa ba e bi nsunda ar Hesu, bi nda̱ndihmö ne bi ꞌñenö: —Xa majöni go ár Tꞌu̱ꞌi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ne bi zo̱ñꞌu̱ ꞌrandi ar dehe har ha̱i Genesare. ");
INSERT INTO otqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nuya mengunu̱ mi böꞌu̱ mar Hesu togo xki zo̱nu̱, bi xañꞌu̱ ar ꞌbede gatho ár nthetꞌi nor ha̱iꞌö, ne ba tsꞌimpa gatho ya da̱thi. ");
INSERT INTO otqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ha nuyu̱ ho̱nse̱ mi a̱di nda the̱gi nda da̱mba ár ñöni ár pa̱tꞌi, ne gatho nuꞌu̱ mi tha̱mbabi mi thitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nuꞌmú̱ ꞌra ya bötꞌofo ne ꞌra ya de̱ngaꞌbe̱pate xki ꞌñe Herusalen nda kꞌönga ar Hesu, bi watꞌi ne bi ꞌñembi: ");
INSERT INTO otqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Yoꞌö ri ma̱xte tsꞌokwa ár ntꞌumbi ma palehu̱ bi zoju̱. Yoꞌö hingi xu̱ꞌye̱ mꞌe̱tꞌo núꞌmu̱ ñuni. ");
INSERT INTO otqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Xi nuꞌahu̱, yoꞌö gi tsꞌojwu̱ ár ꞌbe̱pate Jö gi te̱ñhu̱ nuya ri ntꞌumbihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ngetho Jö bi mönga njawa: ꞌÑeꞌspa ár nsu ri dada ne ri nönö, ha nöꞌö togo da zanga ár dada wa ár nönö, hinda ma da kꞌontꞌi da tho. ");
INSERT INTO otqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mödi nuꞌahu̱ gi eñhu̱ xiñho togo da ꞌñemba ár dada wa ár nönö: Hinda tsa̱ ga fa̱xꞌaꞌi, ngetho nöꞌö ma nga ꞌraꞌahmö, xta ñötꞌwa Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Njapꞌu̱ gi etꞌa ri xu̱thahu̱ hinda tꞌeꞌspa ár nsu ár dada wa ár nönö. Jange xka tsꞌokwabihu̱ ár ꞌbe̱pate Jö gi te̱ñhu̱ ri ntꞌumbihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Xa gar nemhñöhu̱. Xa majöni xi zu̱ꞌahu̱ nöꞌö bi mönga ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nuya jöꞌiyu̱ oxta mañö enö eska ma nsu, ngetho himbi po̱nga ha yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tema ñhoꞌö eska ma nsu, embabi nꞌar hoga ntꞌuti nöꞌö xi bense̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nepꞌu̱ ar Hesu bi zo ya jöꞌi nda watꞌi, ne bi ꞌñembabi: —ꞌYo̱xu̱ xiñho nöꞌö ma ga xiꞌahu̱, ne da zo ri mfenihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hingi tsꞌoka ar jöꞌi nöꞌö ku̱tꞌa hár ne. Nöꞌö po̱ni hö, tsꞌokꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mꞌe̱fa bi watꞌa yá ma̱xte habu̱ mi ꞌbu̱ ar Hesu, ne bi ꞌñembabiꞌu̱: —Ha gi o̱de, nuya de̱ngaꞌbe̱pate xa bi mbo̱ yá kwe̱ mi ꞌyo̱xa nuya mhö ga mö. ");
INSERT INTO otqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ar Hesu bi dötwabi yá ma̱xte ne bi ꞌñembabi: —Gatho nuya do̱ni hinxi motꞌa ma dada bi ꞌbu̱ mhetsꞌi, ma da nkꞌu̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hye̱hu̱pꞌu̱ ya goda̱ ne da gu̱mhö yá migoda̱wi. Nuꞌmu̱ nꞌar goda̱ da gu̱hna manꞌar goda̱, da zowi har otsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ar Pedro bi ꞌya̱mba ar Hesu ne bi ꞌñembabi: —Xikagihe tema di bo̱nga nöꞌö ar ꞌbede xka mö. ");
INSERT INTO otqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ar Hesu bi dödi ne bi ꞌñembabi: —Ha hinxi zo ri mfenihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ha hingi pöhu̱, gatho nöꞌö gi tsihu̱, di ma ri mu̱ihu̱ ne da thogi gi ꞌye̱ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ha nuꞌmu̱ gi beñhu̱ ya tsꞌomfeni, go di bo̱nga ha ri nehu̱, ne go da jaꞌahu̱ gi ntsꞌoju̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngetho ha yá ne ya jöꞌi ka bi po̱mpꞌu̱ ya tsꞌomfeni, ngu ar ntho, ar tsꞌinga nthöti, ar mꞌe̱ngwi jöꞌi, ar mfë, ar nhemhñö ne ar tsꞌate. ");
INSERT INTO otqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gehyu̱ tsꞌoka ar jöꞌi. Ha nöꞌö hingi xu̱ka ár ꞌye̱ mꞌe̱tꞌo, mꞌe̱fa da ñuni, nöꞌö hinte ma tsꞌoki o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ar Hesu bi gu̱ ar ꞌñu bi ma ha yá ha̱i ya hnini Tiro ne Sidon. ");
INSERT INTO otqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nꞌa mba eta nꞌar ꞌbe̱hñö me Nkanan xa mi mafi mi enö: —Tsi Hmu, ár Tꞌu̱ꞌi ar Dabi, hwëgagi. Ma tꞌinxu xa nthe̱xkwi ne xa fe̱ka nꞌar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ha nunar Hesu hinte bi döti. Nuꞌmú̱ nuyá ma̱xte bi ma ba tsu̱di ne bi ꞌya̱pa ar möte mi embabi: —Xipabi da ma, ngetho xa mafi ꞌbe̱fa mo̱te ma xu̱thahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Nuga ho̱nse̱ xpa mꞌe̱nkagi ga munsa ya me Israel jangu ya tsi de̱ti xi mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nuꞌmú̱ ba epꞌu̱ nunar ꞌbe̱hñöꞌö, bi nda̱ndihmö hár wa ar Hesu, ne bi ꞌñembi: —Ma tsi Hmuꞌi, fa̱xkagi. ");
INSERT INTO otqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ar Hesu bi dödi ne bi ꞌñembabi: —Hage xiñho da thömba ár ñhuni ya bötsi ne da tꞌumba ya ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nunar ꞌbe̱hñönu̱ bi dödi ne bi ꞌñenö: —Majöni nöꞌö gi mö. Mödi njapꞌu̱, nuya ꞌyo tsipa yá bo̱ne yá hmu ta̱ har mexa. ");
INSERT INTO otqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Tsi ꞌbe̱hñö, xa döta ri ñꞌemu̱i. Dá njapꞌu̱ ngu xka ꞌya̱di. Ne ja bi dixnu̱ ár tꞌinxu. ");
INSERT INTO otqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ar Hesu bi zohnu̱ nor ha̱iꞌö, bi thogi bi ma ba tso̱nga hár ñöni ar ñho̱nthe Ngalilea, ne bi bo̱xa mañö ha nꞌar ngwani, ma ba huhnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ne bi zo̱nu̱ nze̱ye̱ ya jöꞌi mi tsi ya dowa, ya goda̱, ya gone, ya doꞌye̱ ne ma nze̱ye̱ ya da̱thi. Ba tsꞌihi bi mꞌo̱kwa hár wa ar Hesu, ne nöꞌö mi o̱the. ");
INSERT INTO otqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jange nuꞌu̱ ya jöꞌi mi ꞌbu̱hnu̱ xa mi ꞌyo̱tho mi o̱de nda ñö ya gone, nuya doꞌye̱ mi thitsꞌi, nuya dowa mi ꞌyo, nuya goda̱ mi handi. Ne gathoꞌu̱ mi nsunda Jö ár Dada ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mꞌe̱fa ar Hesu bi zohna yá ma̱xte ne bi ꞌñembabiꞌu̱: —Di hwëka nuya jöꞌiyu̱, ngetho pe̱ꞌsa hñupa di ñꞌohu̱ ne hinte hö te da ziyu̱. Hindi ne ga pe̱hna yá ngu hinte xi zi, yo ma da wentꞌa har ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nuꞌmú̱ nuyá ma̱xte bi ꞌñembabi: —Habu̱ ga tiñhu̱wa har otꞌatꞌo̱ho̱ nze̱ye̱ ya thuhme, ne ga ꞌwiñhu̱ gatho nuya jöꞌiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Har Hesu bi ꞌya̱mbabiꞌu̱: —Hangu ya thuhme gi höhu̱. Nuyá ma̱xte bi dödi ne bi ꞌñeñꞌu̱: —Yoto, ne ꞌra ya tsi hwö. ");
INSERT INTO otqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ne ar Hesu bi ꞌbe̱pa ya jöꞌi nda hñu har ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bi gu̱ nuꞌu̱ yoto ya thuhme ne nuya tsi hwö, bi umba njamödi Jö, bi xe̱ka nuya thuhme ne bi umba yá ma̱xte nda thokwa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gatho ya jöꞌi bi ñuni ne bi niñöꞌu̱. Nepꞌu̱ bi njo nuya xe̱ni thuhme xki bongi, ne bi ñhuꞌsa yoto mꞌo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gatho nuꞌu̱ xki ñuni, mi tsu̱ ngu yonꞌa̱tenthebe ya ñꞌo̱ho̱, himbi yu̱tꞌar mꞌede ya ꞌbe̱hñö ne ya bötsi. ");
INSERT INTO otqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ne ar Hesu bi ñꞌehwi ya jöꞌi, ne bi bo̱xa har motsa bi ma har ha̱i Magdala. ");
INSERT INTO otqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ba e ya de̱ngaꞌbe̱pate ne ya de̱ngamöjö, ma ba honga ar Hesu nda tsa̱ti, ne mi a̱pabi nda uta nꞌar ntꞌudi ndi ꞌñe mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nöꞌö bi döti ne bi ꞌñembi: —Nuꞌahu̱, nuꞌmu̱ gi hanthu̱ mhetsꞌi xi nthe̱ni ꞌbu̱ nde, gi eñhu̱: Xudi ma da ñhoga mpa. ");
INSERT INTO otqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ha nuꞌmu̱ gi hanthu̱ xi the̱nga ya gui ꞌbu̱ xudi, gi eñhu̱ ma da ndöꞌye. Nemhñöhu̱, hanja gi hanthu̱ núꞌmu̱ mponga mhetsꞌi, ne hinxka hyanthu̱ ya ntꞌudi ponga nuya payu̱, ne njapꞌu̱ gi pöhmöhu̱ xi zo̱ ya pa xi benga Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nuꞌahu̱ gar tsꞌojöꞌihu̱ xka hye̱hu̱ Jö, jange gi a̱hu̱ da tꞌaꞌahu̱ nꞌar ntꞌudi di ꞌñe mhetsꞌi. Ha hinte ma ntꞌudi ma da tꞌaꞌahu̱, ho̱nse̱ ár ntꞌudi ar Honas ár mꞌe̱hni Jö. Ne bi zohnu̱ bi gu̱ ar ꞌñu bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mi zo̱ñꞌu̱ ꞌrandi ar dehe, ka bi böhnu̱ yá ma̱xte xki mpumhni nda hñöxa te nda ziꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne ar Hesu bi ꞌñembabiꞌu̱: —Zo̱tꞌa ri da̱hu̱ ne jamasubihu̱ yá ntꞌu̱sthuhme ya de̱ngaꞌbe̱pate ne ya de̱ngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nuyá ma̱xte mi ense̱ nꞌa ngu nꞌa: —Mönga njapꞌu̱ ngetho hinda höhu̱ ar thuhme ga tsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mi böta ar Hesu bi ꞌñembabiꞌu̱: —Tema jamfi gi pe̱ꞌsu̱. Yoꞌö xa tupꞌa ri mu̱ihu̱ nöꞌö tema gi tsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ha hingi tsoda ri mfenihu̱. Wa xka pumhnihu̱ da hemba ngu̱dminthebe ya jöꞌi, ne hangu mꞌo̱tsꞌe ya xe̱ni ga johu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ne ha hingi beñhu̱ nuꞌu̱ yoto ya thuhme da hembabi yonꞌa̱tenthebe ya jöꞌi, ne hangu mꞌo̱tsꞌe ya xe̱ni ga johu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hanja himbi zo ri mfenihu̱ nöꞌö ar ntꞌu̱sthuhme da xiꞌahu̱. Hindi xiꞌahu̱ nöꞌö ar thuhme ga pumhnihu̱. Nuga di xiꞌahu̱ gi jamasuhu̱ yá ntꞌu̱sthuhme ya de̱ngaꞌbe̱pate ne ya de̱ngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nuꞌmú̱ hö, ka bi zo yá mfeniꞌu̱, nunar Hesu himi xipabiꞌu̱ nda jamasu ar ntꞌu̱sthuhme tsꞌi. Mi xipabiꞌu̱ nda jamasu yá ntꞌuti ya de̱ngaꞌbe̱pate ne ya de̱ngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mi zo̱ñꞌu̱ har ha̱i getꞌu̱ Nsesarea Filipo, ar Hesu bi ꞌya̱nga yá ma̱xte ne bi ꞌñembabiꞌu̱: —Núꞌmu̱ nho̱nga Togo ba e bi Njöꞌi, togo benga ya jöꞌi geꞌö ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bi döꞌu̱ njawa: —ꞌRa enö gar Xuwa Xixthe. Maꞌra gar mꞌe̱hni Elia, ha maꞌra enö gar Heremia wa manꞌár mꞌe̱hni Jö mi ꞌbu̱ mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Xiꞌahu̱, togo gi eñhu̱ go gekaga. ");
INSERT INTO otqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ar Simu Pedro bi dödi ne bi ꞌñenö: —Nuꞌge gar Kristo xi tꞌexꞌi gi ndö, ár Tꞌu̱ Jö togo höse̱ ar te. ");
INSERT INTO otqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Simu ár tꞌu̱ꞌi ar Honas, xa xi jöpꞌa Jö ma Dada bi ꞌbu̱ mhetsꞌi, ngetho bi xiꞌase̱ togogi, himbi xiꞌa ar meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nupya di xiꞌaꞌi gar Pedro, nuri thuhu di bo̱ni da ꞌñenö nꞌar do. Ne har ndo̱donu̱ ma ga hoka ma nijö, ne ár tsꞌe̱di ar ꞌbe̱xui hinda ma da döhö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nuꞌge ma ga ꞌraꞌa yá nsoki ár tsꞌu̱tꞌwi Jö. Nöꞌö gi thötꞌwa har ximha̱i, ma da nthötnu̱ mhetsꞌi nꞌehe, ne nöꞌö gi xotꞌwa har ximha̱i, ma da nsotnu̱ mhetsꞌi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nuꞌmú̱ bi xipa yá ma̱xte hinto nda xipabi go mi geꞌö ar Kristo xki ꞌñexa Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nuya paꞌu̱ ar Hesu bi ndu̱i bi xipabi yá ma̱xte mi mahyoni nda ma har hnini Herusalen, habu̱ ma nda u̱tsa ya dönziandö, ya ndömöjö, ya bötꞌofo, ne nda tho. Ne ár hñupa nda mengi nda nte. ");
INSERT INTO otqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nuꞌmú̱ ar Pedro bi gu̱ki, ne bi ndu̱i bi hñuꞌmba ár mu̱i bi ꞌñenö: —Ma tsi Hmuꞌi, hinda nejö. Yo ma da njaꞌa nöꞌö xka mö. ");
INSERT INTO otqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nuꞌmú̱ ar Hesu bi ꞌba̱tꞌi bi ñhandwi ar Pedro ne bi ꞌñembabi: —Hye̱gagiwa tsꞌondöhi, ngetho nuꞌge gi ne gi pa̱tka ma mfeni hinga o̱twa nöꞌö ne Jö. Nuꞌge hingi te̱mba ár mfeniꞌö, gi te̱mba ár mfeni ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nuꞌmú̱ ar Hesu bi zo yá ma̱xte ne bi ꞌñembabiꞌu̱: —Nöꞌö togo ne da de̱ngagi, dá pumhnise̱ ár te, ne da ñꞌe̱ntꞌatho ga ñꞌoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngetho nöꞌö ne da japi da kꞌontꞌa ár te, ma da ꞌbe̱di. Ha nöꞌö e̱ntꞌi da unga ár te da de̱ngagi, ma da dinga ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tema ñho da gu̱kwa nꞌar jöꞌi da dö gatho nöꞌö te jawa har ximha̱i, ne da ꞌbe̱ ár pa. Wa tema tsa̱ da unga nꞌar jöꞌi da da̱nga ár pa. ");
INSERT INTO otqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nöꞌö Togo ba e bi Njöꞌi ma da penga manꞌagi di hömpa ár nsunda ár Dada mhetsꞌi, ne di ñꞌowi yá e̱nxe̱. Geꞌmu̱ ma da umbyá nthöhö nꞌa ngu nꞌa tengu xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Xa majöni di xiꞌahu̱, ꞌra gi ꞌbu̱hu̱wa hinge ma gi tuhu̱, mꞌe̱tꞌo gi hyanthu̱ Nöꞌö Togo ba e bi Njöꞌi da zo̱ho̱ di ndö hár tsꞌu̱tꞌwi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mi tho ꞌrato mpa, ar Hesu bi zixa ar Pedro, ar Hakobo ne ar Xuwa ár jödö, ne bi bo̱xase̱yu̱ ha nꞌar tꞌo̱ho̱ mar ñhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Núꞌmu̱ mi ꞌbu̱hnu̱ har tꞌo̱ho̱ꞌu̱, ar Hesu bi mponga ár ꞌba̱i. Nor hmi mi yotꞌa ngu ar hyadi, ne ár he xa mi hyatsꞌi ngu nꞌar ñotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nꞌa mbi hyandatho yá ma̱xte mi ꞌba̱hwi ar Moise ne ar Elia xki zo̱hnu̱ mi ñöwi ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nuꞌmú̱ ar Pedro bi ꞌñemba ar Hesu: —Ma tsi Hmuꞌi, di za̱ ga ꞌbu̱hu̱wa. Nuꞌmu̱ gi ne, ga hoje hñu ya mꞌetꞌe, nꞌa habu̱ gi ꞌbu̱ke, nꞌa habu̱ da mꞌu̱ ar Moise, ne manꞌa habu̱ da mꞌu̱ ar Elia. ");
INSERT INTO otqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Himi jwatho nda ñö ar Pedro, nꞌa mbi goꞌmathoꞌu̱ nꞌar hyaꞌsagui, ne ka bi nhekinu̱ nꞌar mhö mi enö: —Gehnu̱ ma hmöka Tꞌu̱, jakagi ga njohya. ꞌYo̱hu̱ nöꞌö xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nuyá ma̱xte mi ꞌyo̱xa nuya mhöꞌu̱, xa bi zo ar mbidi yá mu̱i, ne bi ntsꞌa̱mꞌu̱, nuyá hmi mi tso̱nga har ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ar Hesu bi watꞌa habu̱ mi ꞌboñꞌu̱, bi hñuxa ár ꞌye̱ ne bi ꞌñembabiꞌu̱: —Nanju̱, yo gi ntsuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nu mi gu̱xyá da̱ꞌu̱, hinto manꞌa bi hyandi, ho̱nse̱ ar Hesu mi ꞌba̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nu mi göꞌu̱ har tꞌo̱ho̱, ar Hesu bi hñuꞌmba yá mu̱i hinto nda xipabi nöꞌö xki hyantꞌu̱. Nda do̱ꞌmi mꞌe̱tꞌo nda mengi nda nte manꞌagi Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nuyá ma̱xte bi ñꞌa̱ni ne bi ꞌñembabi: —Yoꞌö enga ya bötꞌofo, mꞌe̱tꞌo ma da e ar Elia ne ka da e ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ar Hesu bi dödi ne bi ꞌñembabi: —Hö majöni, ar Elia ma da mꞌe̱tꞌo da ehe da hyokwa yá mfeni ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ha di xiꞌahu̱, nunar Elia ba ehe, ne hinto bi jamfi ha go mi geꞌö. Ne bi tꞌo̱tꞌwabi gatho nöꞌö bi ne ya jöꞌi, ne ma da njapabipꞌu̱ nꞌehe Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nuꞌmú̱ nuyá ma̱xte bi zo yá mfeni mi no̱nga ar Xuwa Xixthe. ");
INSERT INTO otqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nu mi zo̱ñꞌu̱ habu̱ mi ꞌbu̱ nze̱ye̱ ya jöꞌi, ba epꞌu̱ nꞌar ñꞌo̱ho̱ bi nda̱ndihmö hár wa ar Hesu, ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tsi Tata, pe̱ꞌspa ar nhwëki ma bötsi, ar ndungo. Xa ntsꞌe̱di, nꞌandi tso har tsibi ne nꞌandi har dehe. ");
INSERT INTO otqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xta tsimpa ri ma̱xte, ne hinxi tsa̱ xi o̱the. ");
INSERT INTO otqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñenö: —Yá bötsiꞌihu̱ ya me̱ꞌsku ne gar tsꞌojöꞌihu̱. Hangu mpa ma ga ꞌbu̱hwithohu̱, ne ga pe̱sꞌahu̱ ar tsꞌe̱ti. Ba tsinkagiwa ri tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ar Hesu bi zu̱ ar tsꞌondöhi, ne dama bi hye̱ nor bötsiꞌö, ha nunu̱ bi ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mꞌe̱fa yá ma̱xte bi ñöse̱wi ar Hesu ne bi ꞌñembabi: —Hanja himbi tsa̱ da e̱ñhe ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ar Hesu bi ꞌñembabiꞌu̱: —Ngetho thota ár txꞌu̱tho ri ñꞌemu̱ihu̱. Xa majöni di xiꞌahu̱, nuꞌmu̱ gi pe̱ꞌsu̱ ngu ár döta nꞌar nda̱murtasa, da tsa̱ gi ꞌñembabihu̱ nunar tꞌo̱ho̱nu̱: Di ma injanu̱, ne nöꞌö da ma, ne hindi ñꞌotho nöꞌö hinda tsa̱ gi ꞌyo̱thu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Di xiꞌahu̱, nuya tsꞌondöhiyu̱ xi ñhembi da bo̱ni, mahyoni ar ntꞌa̱pa Jö ne ar bëhë. ");
INSERT INTO otqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ar Hesu núꞌmu̱ mi ꞌbu̱hnu̱ Ngalilea, bi ꞌñemba yá ma̱xte: —Nöꞌö Togo ba e bi Njöꞌi ma da nda̱twa ha yá ꞌye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ne nuya jöꞌi ma da hyo, ha nu ár hñupa da mengi da nte manꞌagi. Ha nuyá ma̱xte xa bi du yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nu mi zo̱ngwi ar Hesu yá ma̱xte har hnini Nkapernaum, nuꞌu̱ togo mi jotꞌa ár bojö ar nijö ba e bi kꞌönga ar Pedro, ne bi ꞌñembabi: —Xi ri Utatehu̱, ha hingi jutꞌa ar bojö jotꞌa ar nijö. ");
INSERT INTO otqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ar Pedro bi dödi ne bi ꞌñembabi: —Hö jutꞌi. Nu mi yu̱tꞌa har ngu, ar Hesu bi ñö mꞌe̱tꞌo bi ꞌñembabi: —Ha gi o̱de Pedro. Xi nunar bojö jotꞌa ya ndö, hage jotꞌwa yá mëni wa nuꞌu̱ hinte njawi. ");
INSERT INTO otqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ar Pedro bi döti: —Nuꞌu̱ hinte njawi. Ar Hesu bi ꞌñembabi: —Nuyá mëni hinte jotꞌwabi ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Di honi hinda mbo̱ yá kwe̱ nuꞌu̱ jotꞌa ar bojö, jange di ma ar nju̱xhwö, ne nöꞌö ar mꞌe̱tꞌo hwö gi ju̱tsꞌi, xokwa ár ne, ka gi tinu̱ nꞌar bojö da wadi gi jutꞌa ri me̱ti ne ma me̱ti. ");
INSERT INTO otqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nuya paꞌu̱ ba e yá ma̱xte bi zu̱ ar Hesu ne bi ꞌya̱mbabi: —Togo ma da ntöte ár nsu hár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nuꞌmú̱ ar Hesu bi matꞌa nꞌar tsi bötsi, bi ꞌba̱ꞌma madetho. ");
INSERT INTO otqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ne bi ꞌñemba yá ma̱xte: —Xa majöni di xiꞌahu̱, nuꞌmu̱ hingi pa̱ta ri mꞌu̱ihu̱ ne gi ꞌbu̱hu̱ ngu nꞌar tsi bötsi, hinda tsa̱ gi ku̱thu̱ hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nöꞌö togo ne da ndönu̱ hár tsꞌu̱tꞌwi Jö, mahyoni da ñhe̱hwi nꞌar tsi bötsi hinga ñꞌetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nöꞌö togo da po̱tka ma thuhu japamasu nꞌa di ñhe̱hwi nꞌar tsi bötsi, go jamasugi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nöꞌö togo da japi da da̱ nꞌa nuya tsi bötsi ñꞌemu̱igi, nunar jöꞌiꞌö xiñhohmö da tsꞌu̱twa nꞌar doju̱ni hár ꞌyu̱ga, ne da tꞌe̱ntꞌa madeda ar ñho̱nthe. ");
INSERT INTO otqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hwëkate ya meximha̱i ngetho nze̱ye̱ ya ntꞌu̱tꞌi. Hyaxꞌmu̱ ja ya ntꞌu̱tꞌi. Hwëkate nuya ntꞌu̱tate. ");
INSERT INTO otqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jange nuꞌmu̱ ri ꞌye̱hu̱ wa ri wahu̱ da jaꞌahu̱ gi ꞌyo̱thu̱ nꞌar tsꞌoki, hye̱ju̱ ne gi ꞌye̱ñhu̱ yapꞌu̱. Töte ar ñho gi ku̱thu̱ mhetsꞌi di kꞌatꞌa nꞌa ri wahu̱ wa ri ꞌye̱hu̱, ne hingi me̱wihu̱ gatho yoho ri ꞌye̱hu̱ ne yoho ri wahu̱, da tꞌe̱ntꞌahu̱ har tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nuꞌmu̱ nꞌa ri da̱hu̱ jaꞌahu̱ gi ꞌyo̱thu̱ ar tsꞌoki, hñöhu̱ ne ꞌye̱ñhu̱ yapꞌu̱. Töte ár ñho nꞌada ri da̱hu̱ gi ku̱thu̱ mhetsꞌi, hinge gatho yoho ri da̱hu̱ da tꞌeꞌahu̱ har ꞌbe̱xui habu̱ bi zo̱ ar tsibi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jamasuhu̱ hingi u̱tsahu̱ nꞌa nuyá tsi bötsiyu̱. Ngetho di xiꞌahu̱, nuya e̱nxe̱ mhetsꞌi xi me̱hna Jö da su, hyaxꞌmu̱ handwa ár hmi ma Dada bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nöꞌö Togo ba e bi Njöꞌi xpa e da po̱ nuꞌu̱ xki mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Te gi beñhu̱, nuꞌmu̱ nꞌar ma̱ꞌyo ꞌñe nꞌanthebe ya de̱ti ne da ꞌbe̱ nꞌa, hage hinda zopꞌu̱ nuꞌu̱ gohonꞌa̱temaꞌre̱tꞌa ne gu̱to, ne ma da hyonga ha ya tꞌo̱ho̱ nöꞌö xi mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne núꞌmu̱ xta dini, xa majöni di xiꞌahu̱ xa da njohya bi dinga nöꞌö ar de̱ti xki mꞌe̱di, ne hindi benga nuꞌu̱ maꞌra gohonꞌa̱te ne ꞌre̱tꞌamagu̱to. ");
INSERT INTO otqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Njapꞌu̱ nuri Dadahu̱ bi ꞌbu̱ mhetsꞌi nꞌehe, hingi neꞌö da mꞌe̱ nꞌa nuyá tsi bötsiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Di xiꞌahu̱, nuꞌmu̱ nꞌaꞌahu̱ da ꞌyo̱tꞌahu̱ nꞌar tsꞌoki ri ku, di ma ba kꞌötsꞌi gi ñöwise̱. Nuꞌmu̱ da ꞌyo̱xa nöꞌö gi xipi, xka pengi gi ñhogamu̱iwi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ha nuꞌmu̱ hinda ꞌyo̱tꞌaꞌi, tsixa manꞌa wa yoho ri ku da ꞌyo̱xa nöꞌö ma gi xipabi, ne njapꞌu̱ da da̱majöni yoho wa hñu. ");
INSERT INTO otqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nuꞌmu̱ hinda ꞌyo̱ta nuꞌu̱ ga tsitsꞌi, xipabi gatho ya ku har nijö, ne nuꞌmu̱ ar nijö hinda ne da ꞌyo̱te nꞌehe, hyandi ngu nꞌar ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Xa majöni di xiꞌahu̱, nöꞌö gi hñuꞌspabihu̱wa har ximha̱i, ma da thuꞌspabinu̱ mhetsꞌi, ne nöꞌö gi hñökwabihu̱wa har ximha̱i, ma da thökwabinu̱ mhetsꞌi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Di xiꞌahu̱ nꞌehe, nuꞌmu̱ yoho gi nkohu̱wa har ximha̱i tema gi ꞌya̱hu̱, ma Dada bi ꞌbu̱ mhetsꞌi da ꞌraꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngetho habu̱ xi mhuntsꞌa yoho wa hñu matkagi, ka di ꞌbu̱ꞌbeganu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nuꞌmú̱ ar Pedro bi watꞌa habu̱ mi ꞌba̱ ar Hesu ne bi ꞌñembabi: —Tengu ár nze̱ye̱ ga pumbabi ma ku o̱tkagi ar tsꞌoki. Hage ga to̱ꞌmi da zo̱nga yoto. ");
INSERT INTO otqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ar Hesu bi dödi ne bi ꞌñenö: —Nuga di xiꞌaꞌi, hinge ho̱nse̱ yoto ar nze̱ye̱. Pumbabi hñunꞌa̱temaꞌre̱tꞌa ya yoto ár nze̱ye̱, ne hingi nuhu̱tho nze̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ár tsꞌu̱tꞌwi Jö ñhe̱hwi nꞌar ndö ma da hñöꞌspa majöni yá ꞌbe̱go. ");
INSERT INTO otqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nu mi ndu̱i ba tsꞌimpa nꞌar ꞌbe̱go mi tupabi nꞌanthebe ya ꞌre̱tꞌanthebe ar bojö. ");
INSERT INTO otqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nöꞌö ar ꞌbe̱goꞌö himbi tsa̱ bi gutꞌwa nöꞌö mi tupabi. Jange ár hmu bi mö nda ꞌba̱wi mahye̱gi ár ꞌbe̱hñö, yá bötsi ne gatho nöꞌö mi pe̱tsꞌi, ne nda njoꞌspa ár bojö. ");
INSERT INTO otqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nöꞌö ar ꞌbe̱goꞌö bi nda̱ndihmö hár wa ár hmu, ne mi a̱pa ar möte mi embabi: Pe̱ꞌska ar tsꞌe̱ti, to̱bgagi ne ga jutꞌa gatho ri bojö. ");
INSERT INTO otqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nuꞌmú̱ nu ár hmu nor ꞌbe̱goꞌö bi go ár mu̱i ne bi pumbabi gatho nöꞌö mi tupabi, ne bi hye̱gi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ha nu mi manu̱, bi nthe̱wi nꞌár miꞌbe̱gowi mi tupabi nꞌanthebe ya tsi tꞌaxbojö. Bi ma ba mihi ne bi mitꞌwa ár ꞌyu̱ga mi embabi: Nupya hö, ma gi jutka gatho nöꞌö gi tukagi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nu ár miꞌbe̱gowi bi nda̱ndihmö hár wa, ne bi ꞌñembabi: Pe̱ꞌska ar tsꞌe̱ti to̱bgagi, ne ga jutꞌa gatho ri bojö. ");
INSERT INTO otqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ha nöꞌö himbi ne bi do̱ꞌmi. Bi zixa har fa̱di habu̱ ba kotꞌi, bi do̱ꞌmi nda gutꞌwa gatho nöꞌö mi tupabi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nu mi hyanda njapꞌu̱ nu maꞌra ya ꞌbe̱go, xa bi zo̱tꞌa yá mu̱i ne bi ma ba petwa ár hmu gatho nöꞌö xki hyantꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ar hmu bi zohna nu ar ndutha̱i xki mpumbabi nze̱ye̱, ne bi ꞌñembabi: Nuꞌge xa gar tsꞌojöꞌi. Gatho nöꞌö ar bojö ngi tukagi da pumpꞌaꞌi, ngetho ga ꞌya̱ka ar möte. ");
INSERT INTO otqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ha hinge ndi ꞌñepꞌaꞌi nda go ri mu̱i ngi pumpabi ri miꞌbe̱gowi, ngu nuga bi go ma mu̱i da pumpꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nuꞌmú̱ nu ár hmu xa bi mbo̱ ár kwe̱, bi da̱twa ha yá ꞌye̱ ya sufa̱di nda gotꞌi, ne nda do̱ꞌmi nda gutꞌa gatho ár tha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma Dada bi ꞌbu̱ mhetsꞌi ma da jaꞌahu̱ njapꞌu̱ nꞌehe, nuꞌmu̱ hindi tsitꞌa ri mu̱ihu̱ gi pumbabihu̱ yá tsꞌoki ri kuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ar Hesu mi wadi bi mönga njapꞌu̱, bi zohnu̱ ar ha̱i Ngalilea. Bi gu̱ ar ꞌñu bi ma har ha̱i Nhudea ꞌrandi ar döthe Hordan. ");
INSERT INTO otqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bi de̱nga nze̱ye̱ ya jöꞌi, ne nuꞌu̱ mi pe̱ꞌsa ya hñeni ka ba o̱thenu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nuꞌmú̱ ya de̱ngaꞌbe̱pate bi ma ba kꞌöꞌsa ar Hesu nda tsa̱ti, ne bi ꞌñembabi: —Hage tsa̱ntꞌö ya thogi da tsa̱ da hye̱ ár ꞌbe̱hñö nꞌar ñꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Ha hinxka nehu̱ har Tꞌofo, nu hár ndu̱i, Jö bi hyoka ar ndo̱ ne ar ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ne bi ꞌñenga Jö: Jange ar ñꞌo̱ho̱ da zopꞌu̱ ár dada ne ár nönö, ne da mꞌu̱hwi ár ꞌbe̱hñö, ne nuya yohoyu̱, da nꞌatho. ");
INSERT INTO otqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hinga yoho ꞌmu̱, nꞌase̱. Jange nöꞌö xi ju̱nga Jö, hinda ꞌweka ar jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nuya de̱ngaꞌbe̱pate bi ꞌñemba ar Hesu: —Yoꞌö bi mönga ar Moise nda thoka nꞌar he̱ꞌmi ñhe̱gi, ne nda tsa̱ nda hye̱pꞌu̱ ár ꞌbe̱hñö nꞌar ñꞌo̱ho̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ar Hesu bi ꞌñembabiꞌu̱: —Ar Moise bi unga ar se̱ki ngetho xa xi me ri ñöhu̱. Nu hár ndu̱i Jö himi ne njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Di xiꞌahu̱, nöꞌö togo da hye̱pꞌu̱ ár ꞌbe̱hñö, ne hinte ma tsꞌoki xi dimbabi di ñꞌowi manꞌar jöꞌi, ne da nthötwi manꞌar ꞌbe̱hñö, gehnu̱ nꞌar tsinganthöti. Ne nöꞌö togo da nthötwi nor ꞌbe̱hñö xi nthe̱pꞌu̱, gehnu̱ nꞌar tsinganthöti nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nuyá ma̱xte bi ꞌñemba ar Hesu: —Nuꞌmu̱ njapꞌu̱ ár mꞌu̱i ar ñꞌo̱ho̱ ne ár ꞌbe̱hñö, xiñho hinda nthöta nꞌa ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bi dö ar Hesu ne bi ꞌñembabiꞌu̱: —Hinga gatho da tsa̱ da ꞌyo̱tꞌa njapꞌu̱, ho̱nse̱ nuꞌu̱ xpa umba Jö hinda nthöti. ");
INSERT INTO otqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ꞌRa ya ñꞌo̱ho̱ hingi tsa̱ da nthöti ngetho xi mꞌu̱i njapꞌu̱, maꞌra xi japabi njapꞌu̱ ya jöꞌi, maꞌra xi ne mꞌe̱tꞌo da me̱pabi Jö togo ar ndö mhetsꞌi. Nöꞌö togo tsa̱ da hñönga nunar mhönu̱, dá hñöni. ");
INSERT INTO otqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mꞌe̱fa ba tsꞌimpabi ꞌra ya tsi bötsi ar Hesu nda hñuxa yá ꞌye̱ ne nda ꞌya̱pa Jö nda jöpi. Ha nuyá ma̱xte bi zu̱i nuꞌu̱ togo mi tsihi. ");
INSERT INTO otqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nuꞌmú̱ ar Hesu bi ꞌñemba yá ma̱xte: —Hye̱hu̱ ya tsi bötsi da e da zu̱kagi, yo gi hökwabihu̱, ngetho gatho nuꞌu̱ ꞌbu̱ hár tsꞌu̱tꞌwi Jö, ñhe̱hwi nꞌar tsi bötsi. ");
INSERT INTO otqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nu mi wadi bi hñuxa yá ꞌye̱ ha ya tsi bötsi, bi gu̱ ar ꞌñu bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mꞌe̱fa ba e nꞌa bi ꞌyo̱tꞌwa nꞌar ntꞌa̱ni ar Hesu, ne bi ꞌñembabi: —Hoga Utate, tema ñho ga pe̱fi, ne njapꞌu̱ ga pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ar Hesu bi dödi ne bi ꞌñembabi: —Yoꞌö gi xikagi dar hogajöꞌi. Ho̱nse̱ Jö go ar hogajöꞌiꞌö. Ha nuꞌmu̱ gi ne gi pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi, ꞌyo̱twa gatho yá ꞌbe̱pate Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nor ñꞌo̱ho̱ꞌö bi ꞌñenö: —Tema ꞌbe̱pateꞌu̱. Ar Hesu bi ꞌñembabi: —Yo gi ñhote, yo gi tsimba ár nthöti ri ñꞌohu̱, yo gi mpë, yo gi ju̱xya nhemhñö. ");
INSERT INTO otqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ꞌÑeꞌspa ár nsu ri dada ne ri nönö, ne mö ri ñꞌohu̱ ngu gi mhöse̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nunar ñꞌo̱ho̱ bi ꞌñenö: —Gathoyu̱ xta o̱tꞌa ndi bötsitho. Teme di ꞌbe̱di ga o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ar Hesu bi ꞌñembabi: —Nuꞌmu̱ xa gi ne gi ꞌbu̱i xiñho, di ma ba pa̱ gatho nöꞌö gi pe̱tsꞌi ne hyemba ya hyoya. Njapꞌu̱ gi pe̱ꞌsa ri ñhonu̱ mañö mhetsꞌi, ne ba e gi te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nu mi ꞌyo̱ njapꞌu̱ nunar ñꞌo̱ho̱nu̱, bi ma xa mi tu ár mu̱i, ngetho mi the̱ nze̱ye̱ ya ñho. ");
INSERT INTO otqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nuꞌmú̱ ar Hesu bi ꞌñemba yá ma̱xte: —Xa majöni di xiꞌahu̱, xa xi ñhembi da yu̱tꞌa hár tsꞌu̱tꞌwi Jö nꞌar jöꞌi hinte kꞌatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Di xiꞌahu̱ xi ñhembi da tho nꞌar döta me̱ti hár gu nꞌar ꞌyomhni. Töte ár ñhembi da yu̱tꞌa nꞌa hinte kꞌatꞌi hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nu mi ꞌyo̱ njapꞌu̱ yá ma̱xte, xa bi ꞌyo̱tho ne bi ꞌñeñꞌu̱: —Nuꞌmu̱ njapꞌu̱, togo tsa̱ da mpo̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ar Hesu bi kꞌötꞌi ne bi ꞌñembabiꞌu̱: —Nöꞌö hingi tsa̱ da ꞌyo̱tꞌa ya jöꞌi, Jö hinter ñhembibi da ꞌyo̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ar Pedro bi ꞌñembabi ꞌmu̱: —Nuje xta tsohe xo̱ge ne xta te̱ñꞌahe. Tema nthöhö di to̱ꞌmhe ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ar Hesu bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, xta zo̱ ar pa da nꞌaꞌyo xo̱ge, xta hñuxa hár thuxandö Nöꞌö Togo ba e bi Njöꞌi, nuꞌahu̱ xka te̱ngagihu̱ ma gi hñuxu̱ nꞌehe ha ꞌre̱tꞌamayoho ya thuxandö, gi hñöꞌsfu̱ majöni nuꞌu̱ ꞌre̱tꞌamayoho yá mꞌu̱i ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","To gatho xpa tsopꞌu̱ yá ngu, yá jödö, yá nju, yá dada, yá nönö, yá ꞌbe̱hñö, yá bötsi wa yá ha̱i te̱mga ma thuhu, ma da hñönga nꞌanthebe ár nze̱ye̱ di töta nöꞌö xi zogi, ne ma da hñönga ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nze̱ye̱ nuꞌu̱ ꞌbe̱tꞌopya ma da mꞌe̱fa, ha nuꞌu̱ togo ꞌbe̱fapya ma da mꞌe̱tꞌoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ár tsꞌu̱tꞌwi Jö ñhe̱hwitho nꞌar ñꞌo̱ho̱ pe̱ꞌsa nꞌar hwöhiꞌobxi, ne da bo̱nga ra nꞌitho ma da hyonga ya ꞌbe̱go da ma̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne bi nkohwi nuya ꞌbe̱go nda gutꞌwa nöꞌö tö nꞌar ꞌbe̱go nꞌa pa, ne bi me̱hna har hwöhi nda mpe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ngu nꞌar gu̱to xudi bi bo̱nga manꞌagi ma ba honga maꞌra, ne bi dinga ꞌra mi ꞌbu̱hnu̱ har ta̱i hinte mi pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne bi ꞌñembabiꞌu̱: Di möhu̱ ba mpe̱hu̱ ha ma hwöhi nꞌehe, ne ga jutꞌahu̱ xiñho. Ne bi ma ba mpe̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ngu madempa ne ar hñunde bi bo̱nga manꞌagi, ne bi nthe̱wi maꞌra, ne bi gohwi nda gutꞌwa xiñho nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ngu nꞌar ku̱tꞌa nde bi bo̱nga manꞌagi, ne bi nthe̱wi maꞌra ya jöꞌi hinte mi pe̱fi, ne bi ꞌñembabi: Yoꞌö gi ꞌbu̱thu̱wa gatho ar pa hinte gi pe̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nuꞌu̱ bi dödi ne bi ꞌñembabi: Hinto xi ꞌraje ar ꞌbe̱fi. Nuꞌmú̱ nor ñꞌo̱ho̱ꞌö bi ꞌñenö: Di ma ba mpe̱hu̱ ha ma hwöhi nꞌehe, ne ga jutꞌahu̱ xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nu mi yu̱ ar hyadi, nunar hmu bi ꞌñemba ar ndöngi: Zohna ya ꞌbe̱go gi jutꞌwa nꞌapa nꞌa ngu nꞌa. Jutꞌwa mꞌe̱tꞌo nuꞌu̱ bi yu̱tꞌa mꞌe̱fa, nepꞌu̱ nuꞌu̱ bi yu̱tꞌa ar ndu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nu mi tho nuꞌu̱ bi yu̱tꞌa ngu ku̱tꞌa nde, bi njutꞌwabi xo̱ge ar pa. ");
INSERT INTO otqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nu mi tho nuꞌu̱ ya ꞌbe̱tꞌo xki yu̱tꞌa mi xudi, mi empꞌö nda hñuxa ár nze̱ye̱ nda tꞌumbabi, ha nuꞌu̱ bi njutꞌwabi nꞌapa nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nu mi hñönga ho̱nse̱ꞌö, mi ñömañꞌu̱ mi no̱nga ar hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mi eñꞌu̱: Nuyu̱ xi yu̱tꞌa mꞌe̱fa, ho̱nse̱ nꞌa xe̱nimpa xi mpe̱fi, ne xka jutꞌwabi mahye̱gi nguje xta mpe̱he gatho ar pa, xta tse̱the ar pahyadi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nuꞌmú̱ ar hmu bi ꞌñemba nꞌaꞌu̱: Ha gi o̱de ño̱, hage xta ko̱mpꞌa ri bojö. Hage hinda nkohwi nga jutꞌa nöꞌö ar nthöhö tꞌunga nꞌapa. ");
INSERT INTO otqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hñöxa nöꞌö xka töhö ne di ma, ngetho nuga xta ne ga jutꞌwa nguꞌi nuyu̱ xi yu̱tꞌa mꞌe̱fa. ");
INSERT INTO otqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hage ma gi xikagi teme ga japa ma bojö. Wa tso̱tꞌa ri mu̱i gi handgi ko ma mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ngetho nuꞌu̱ ꞌbe̱tꞌo ma da mꞌe̱fa, ne nuꞌu̱ ꞌbe̱fa ma da mꞌe̱tꞌoꞌu̱. Nze̱ye̱ xi tsꞌohni, txꞌu̱tho nuꞌu̱ xi thahni. ");
INSERT INTO otqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ar Hesu mi ꞌyo ar ꞌñu ndi ma Herusalen, nꞌa mbi ꞌweka nꞌampꞌu̱ nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Pöhu̱, núꞌmu̱ xka tso̱ñhu̱nu̱ Herusalen, ka ma da mhihnu̱ Nöꞌö Togo ba e bi Njöꞌi. Ma da nda̱twa ha yá ꞌye̱ ya ndömöjö ne ya bötꞌofo, ne da tꞌe̱ntꞌi da tho. ");
INSERT INTO otqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mꞌe̱fa ma da nda̱twa ha yá ꞌye̱ nuꞌu̱ hingya xodyo. Nuyu̱ ma da zani, da ꞌwe̱tꞌi, ne da tsu̱ta ha nꞌar pontꞌi da the̱gi da du, ha nu ár hñupa da mengi da nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nepꞌu̱ ba e ár ꞌbe̱hñö ar Sebedeo mi ñꞌowi yá tꞌu̱, dama bi nda̱ndihmö hár wa ar Hesu mi a̱pa ar möte. ");
INSERT INTO otqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Teme gi ne. Nor ꞌbe̱hñö bi ꞌñenö: —Di ne gi ꞌñexa nuyu̱ yoho ma tꞌu̱ gi hñuxkwi há ri ndö, nꞌa da hñuxa ha ri ñꞌe̱i, ne nöꞌö manꞌa ha ri ngöhö. ");
INSERT INTO otqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñemba ar Xuwa ne ar Hakobo: —Hingi pöhu̱ teme gi a̱hu̱. Ha gi hanthu̱ gi tse̱thu̱ ya thogi ngu ma ga tse̱tka. Nuꞌu̱ bi dödi ne bi ꞌñeñꞌu̱: —Hö ga tse̱the. ");
INSERT INTO otqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ar Hesu bi ꞌñembabiꞌu̱: —Majöni ma gi thohu̱ ya thogi ngu ma ga thoka. Ha nöꞌö gi ne gi hñuxu̱ ha ma ñꞌe̱i ne ha ma ngöhö, hinda tsa̱ te ga mönga. Ma Dada xi hokwabi togo xi hñuxꞌö ga huxꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu mi bö nuꞌu̱ ma ꞌre̱tꞌa yá ma̱xte nöꞌö xki ꞌya̱ nuya yoho mi njödö, xa bi mbo̱ yá kwe̱. ");
INSERT INTO otqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ne ar Hesu bi zo yá ma̱xte, ne bi ꞌñembabi: —Gi pöhu̱ nuyá ndö ya hnini ñꞌexase̱ꞌu̱ honi da hyo̱ma ha̱i nu maꞌra, ne nuya xi tꞌexa ngu ar ñöxhmu xa meꞌmda ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ha nuꞌahu̱, yo gi njahu̱pꞌu̱, ngetho nuꞌmu̱ gi ne gi ndötahu̱, mahyoni gi pe̱fu̱ nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nöꞌö togo gi ne gi ꞌbe̱tꞌohu̱, mahyoni gi mꞌe̱gohu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jahu̱ ngu Nöꞌö Togo ba e bi Njöꞌi. Nöꞌö himba ehe honi togo da me̱pabi. Xpa ehe da mꞌe̱go ne da unga ár te da gutꞌwa yá tha̱i nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nu mi bo̱nga ar Hesu har hnini Heriko, mi te̱nga yá ma̱xte ne mi te̱nga nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Har ꞌñu bi nthe̱wi mi huhnu̱ yoho ya goda̱, ne mi böꞌu̱ mi thohnu̱ ar Hesu, bi matꞌi ne bi ꞌñembabi: —Tsi Hmu, ár Tꞌu̱ꞌi ar Dabi, pe̱ꞌskagihe ar nhwëki. ");
INSERT INTO otqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ya jöꞌi mi tsu̱i hinge nda mafi, ha nuꞌu̱ xa mi umba yá mu̱i mi mafi mi eñꞌu̱: —Tsi Hmu, ár Tꞌu̱ꞌi ar Dabi, hwëgagihe. ");
INSERT INTO otqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nuꞌmú̱ ar Hesu bi mꞌa̱i bi matꞌi, ne bi ꞌñembabiꞌu̱: —Te gi ne ga jaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nuꞌu̱ bi dödi ne bi ꞌñenö: —Ma tsi Hmuꞌi, di nehe da xo ma da̱he. ");
INSERT INTO otqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nuꞌmú̱ ar Hesu bi hwëki ne bi hñuxa ár ꞌye̱ ha yá da̱ꞌu̱, ne dama bi xogi, ne bi de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ar Hesu mi zo̱ngwi yá ma̱xte núnu̱ Betfage, mo̱te ar tꞌo̱ho̱ Njömdo̱ni, getꞌu̱ ar hnini Herusalen. Ka bi me̱hnu̱ yoho nda mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ne bi ꞌñembabi: —Di möhu̱ har tꞌu̱lo hnini gi hanthu̱ ꞌbu̱hnu̱. Ne xki tso̱ñhu̱ ma gi tiñhu̱ nꞌar tsi nꞌo̱ge di thötwinu̱ ár tꞌu̱bru, gi xothu̱ ne gi tsinkagihu̱wa. ");
INSERT INTO otqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nuꞌmu̱ togo da ꞌya̱ñꞌahu̱, gi ꞌñembabihu̱ njawa: Ar tsi Hmu honi, ne ka da kosꞌa manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gathoyu̱ bi njapꞌu̱ ne nda thogi ngu xki mönga ár mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Di möhu̱ Herusalen nöꞌö ar hnini tꞌembabi ar Sion nꞌehe, ne xifu̱ ya mengunu̱: Hyanthu̱ ba ekwa ri Hmuhu̱ xpa e da kꞌösꞌahu̱, hingar ñꞌetsꞌi, ngetho xpa nto̱ nꞌar tsi nꞌo̱ge, ár bötsi nꞌar tsi zuꞌwe ndu. ");
INSERT INTO otqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nuꞌmú̱ yá ma̱xte bi maꞌu̱ ne bi ꞌyo̱tꞌa ngu xki xipabi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nepꞌu̱ ba tsimpa ar tsi nꞌo̱ge mi ñꞌowi ár bötsi, ne yá ma̱xte bi göꞌspa yá pa̱tꞌi ne bi bo̱xa ar Hesu bi nto̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mi panu̱ nze̱ye̱ ya jöꞌi, ꞌra mi höka yá pa̱tꞌi mi xi har ꞌñu, maꞌra mi toka ya xiza mi po habu̱ nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nuya jöꞌi mi ꞌbe̱tꞌo ne nuꞌu̱ mi ꞌbe̱fa xa mi mafi mi eñꞌu̱: —Xa nsunda ár Tꞌu̱ ar Dabi. Dá jöpa Jö ár mꞌe̱hni. Xa nsunda Jö bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ngu mi yu̱tꞌu̱ har hnini Herusalen, xa mi ñꞌentya jöꞌi ne mi enga nꞌa ngu nꞌa: —Togonu̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ne nuꞌu̱ togo mi te̱ni mi thödi ne mi eñꞌu̱: —Gehnu̱ ar Hesu ár mꞌe̱hni Jö, ar me Nasare har ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nepꞌu̱ ar Hesu bi yu̱tꞌa hár thi ár dönganijö ar tsi Dada, ne bi ꞌye̱nga gatho nuꞌu̱ mi mpa̱ ne nuꞌu̱ mi nta̱i. Bi pu̱ꞌspa yá mexa ya pa̱tbojö ne yá nthutsꞌi nuꞌu̱ mi pa̱ ya domtxu. ");
INSERT INTO otqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne bi ꞌñembabi: —Hár Tꞌofo Jö enö: Ma ngu gehnu̱ ár ngu mhatꞌajö. Ha nuꞌahu̱ xka ꞌyo̱thu̱ nꞌar ngu jar mfë. ");
INSERT INTO otqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ꞌRa ya goda̱ ne ya dowa ba e bi zu̱hnu̱ har nijö, ne nöꞌö bi o̱thebi yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nuya ndömöjö ne nuya bötꞌofo mi hyanda ya döta ntꞌudi bi ꞌyo̱tꞌa ar Hesu, xa bi mbo̱ yá kwe̱ mi ꞌyo̱xa nuya bötsi mi ma mbor nijö mi eñꞌu̱: Xa nsunda ár Tꞌu̱ ar Dabi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ne bi xipa ar Hesu njawa: —Ha hingi o̱xa nöꞌö mönga ya bötsi. Ar Hesu bi dötwabi ne bi ꞌñembabiꞌu̱: —Hö, di o̱de. Xi nuꞌahu̱, ha hinxka nehu̱ ár Tꞌofo Jö habu̱ enö njawa: Nuya bötsi ne nuꞌu̱ ya le̱le̱ tsu̱tho, Jö bi xokwa yá ne nda matꞌajö xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ne bi zohnu̱ꞌu̱ bi bo̱nga har hnini, bi ma Betania, ka ba oxhnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ár hyaxꞌö nꞌitho bi menga manꞌagi Herusalen, ne núꞌmu̱ mi ꞌyo har ꞌñu bi ntunthu. ");
INSERT INTO otqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hár ñöni ar ꞌñu bi hyandi mi ꞌba̱hnu̱ nꞌar ꞌba̱iꞌiuxi. Bi ma ba kꞌöni, xömhö nda dinga te nda zi. Ha hinte mi tu, ho̱nse̱ xa mi kꞌamatho yá xi. Nuꞌmú̱ bi ꞌñemba ar ꞌba̱iꞌiuxi: —Hiñhamꞌu̱ gi penga da ndu ri iuxi. Ne dama bi ꞌyotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nu mi hyanda yá ma̱xte nöꞌö xki thogi, xa mi ꞌyo̱tho ne bi ꞌñemba ar Hesu: —Hanja dama bi ꞌyotꞌa ar ꞌba̱iꞌiuxi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ar Hesu bi dödi ne bi ꞌñenö: —Xa majöni di xiꞌahu̱, nuꞌmu̱ xa gi jamfihu̱, ne hingi yomihu̱ da njapꞌu̱ ngu gi nehu̱, hinge ho̱nse̱ da tsa̱ gi ꞌyo̱thu̱ ngu xta o̱tꞌwa ar ꞌba̱iꞌiuxi. Da tsa̱ gi ꞌñembabihu̱ nunar tꞌo̱ho̱nu̱ da mponi di ma har dehe, ne da ma. ");
INSERT INTO otqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ne gatho nöꞌö gi ꞌya̱hu̱ ne gi ñꞌemu̱ihu̱ da tꞌaꞌahu̱, gi hñöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nepꞌu̱ ar Hesu bi yu̱tꞌa manꞌagi har dönganijö Herusalen, mi uta ya jöꞌi. Ne ja bi zo̱hnu̱ ya ndömöjö ne yá dönziandö ya xodyo, ne bi ꞌñembabi: —Togo xpa pe̱ñꞌaꞌi gi ꞌyo̱tꞌa gatho nöꞌö gi pe̱fi. Togo gi hömpa ár tsꞌe̱di gi ꞌyo̱tꞌa njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Nuga nꞌe, ma ga o̱tꞌahu̱ nꞌar ntꞌa̱ni. Nuꞌmu̱ gi thöhu̱, nuga nꞌe ga xiꞌahu̱ togo di hömpa ár tsꞌe̱di ga o̱tꞌa nöꞌö di pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nöꞌö ar xixthe mi o̱tꞌa ar Xuwa Xixthe, togo ba pe̱ñꞌö, Jö wa ya jöꞌi. Nuꞌu̱ bi ndu̱i bi njontꞌane nꞌa ngu nꞌa, ne mi eñꞌu̱: —Xipya te ga thöhu̱. Nuꞌmu̱ ga emfu̱ ba pe̱hna Jö, ma da ꞌñengagihu̱: Yoꞌö hinga ꞌyo̱thu̱ nöꞌö mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ha nuꞌmu̱ ga emfu̱ ar Xuwa ba pe̱hna ya jöꞌi, da mbo̱ yá kwe̱yu̱, ngetho gatho handa ar Xuwa Xixthe ngu ár mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nuꞌmú̱ ya ndömöjö ne yá dönziandö ya xodyo bi ꞌñemba ar Hesu: —Hindi pöhe. Nuꞌmú̱ ar Hesu bi dödi: —Nuga nꞌe hinga xiꞌahu̱ togo xpa pe̱nkagi ga o̱tꞌa nöꞌö di pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ne ar Hesu bi ꞌñembabiꞌu̱: —Te gi nuhu̱. Nꞌar ñꞌo̱ho̱ mi ꞌñe yoho yá tꞌu̱, ne bi ꞌñemba nꞌaꞌu̱: Di ma ba mpe̱ har hwöhi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nöꞌö ar tꞌu̱ꞌö bi dödi ne bi ꞌñenö: Hinꞌö, hindi ne ga ma. Ne mꞌe̱fa bi ꞌyo̱tꞌwa ár ntso̱ꞌmi ne bi ma ba mpe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nepꞌu̱ nu ár dadaꞌö bi ꞌñemba nöꞌö manꞌár tꞌu̱: Di ma ba mpe̱ har hwöhi. Nöꞌö bi dödi ne bi ꞌñenö: Hö, ga ma. Ha himbi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Xipya, nuya yohoyu̱, togo bi ꞌyo̱tꞌa nöꞌö bi ꞌbe̱pa ár dada. Bi dö nuya ndömöjö: —Nöꞌö ar tꞌu̱ bi me̱hna mꞌe̱tꞌo. Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, nuya hya̱te ne nuya tsꞌoꞌbe̱hñö ma da döꞌahu̱ mꞌe̱tꞌo da yu̱tꞌa hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngetho ba e ar Xuwa Xixthe bi utꞌahu̱ hanja gi ñhogajöꞌihu̱, ne nuꞌahu̱ hinga ne ga jamfihu̱ nöꞌö mi möñꞌö. Nuya hya̱te ne ya tsꞌoꞌbe̱hñö, nuꞌu̱ hö, bi ꞌyo̱tꞌwa yá ntso̱ꞌmi. Ha nuꞌahu̱, mödi te gatho xka hyanthu̱, hinxka ñꞌemu̱ihu̱ nöꞌö bi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ar Hesu bi metwa manꞌar ꞌbede ne bi ꞌñembabiꞌu̱: —ꞌYo̱hu̱ manꞌar ꞌbede ga xiꞌahu̱: Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ xa mi the̱ nze̱ye̱ yá ha̱i. Ne bi ꞌñetꞌa nꞌar hwöhiꞌobxi, bi gu̱xa nꞌar jödo bi gotꞌi. Bi xa̱ꞌma nꞌar moto, ne bi hyoka nꞌar heꞌsa ngu nda hyanda xo̱ge. Mꞌe̱fa bi umba ñhandi maꞌra nda su, ne bi ma yapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nu mi zo̱ ar sofo, bi me̱hna ꞌra yá ꞌbe̱go ma nda kꞌöꞌsa yá ñhandi, ne nda umba nöꞌö made ndi ꞌñepi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nuya ñhandi bi gu̱mpa yá ꞌbe̱go, nꞌa bi me̱i, nöꞌö manꞌa bi hyo, ne nöꞌö manꞌa bi te̱do bi gui bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mꞌe̱fa bi mengi bi me̱hna ma nze̱ye̱ yá ꞌbe̱go, ha nuya ñhandi bi mengi bi ꞌyo̱tꞌwa ngu xki ꞌyo̱tꞌwa nuꞌu̱ mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nu ár ngötsꞌi, nöꞌö tor me̱ti ar hwöhi bi me̱hna ár tꞌu̱, ne bi ꞌñenö: Numa tꞌu̱ hö, ma da ꞌyo̱te. ");
INSERT INTO otqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ha nuya ñhandi mi hyandwa ár tꞌu̱, bi ꞌñenga nꞌa ngu nꞌa: Go gehnu̱ togo ma da gohwi ya ha̱i. Ma ga hohu̱ ne ga tsömfu̱ yá ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nuꞌmú̱ nuya ñhandi bi gu̱mpa ár tꞌu̱, bi gu̱ka har hwöhi ne bi hyo. ");
INSERT INTO otqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nu xta penga nöꞌö tor me̱ti ar hwöhi, tema da japa nuya ñhandi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nuꞌmú̱ nuya ndöxodyo bi ꞌñenö: —Nöꞌö togo ár me̱ti ar hwöhi da ꞌweka nuya tsꞌojöꞌi da hyo, hinda ma da hwëki. Ne da umba maꞌra ya ꞌbe̱go ár ha̱i, nuꞌu̱ togo da umba nöꞌö di ꞌñepi xta zo̱ ar sofo. ");
INSERT INTO otqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Hage hinxka nehu̱ har Tꞌofo habu̱ enö: Nöꞌö ar do bi ꞌye̱mpꞌu̱hmö ya guxjödo, nupya gehnu̱ ar mu̱di do xi njuꞌspa ár nijö Jö. Gese̱ Jö xi ꞌyo̱tꞌa njapꞌu̱, ne di hanthu̱ nza̱tho nöꞌö bi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jange di xiꞌahu̱, ma da thömpꞌahu̱ nöꞌö ar tsꞌe̱di gi pe̱ꞌsu̱ gi ku̱thu̱hmö hár tsꞌu̱tꞌwi Jö, ne da tꞌumba maꞌra ya jöꞌi nuꞌu̱ togo ne da ꞌyo̱ta nöꞌö mönga Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nöꞌö togo da nto̱xkwi nor doꞌö, da ꞌwaka yá ndoꞌyo, ha nöꞌö togo da ze̱ꞌmi, da ku̱ntꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nu mi ꞌyo̱ ya ndömöjö ne ya de̱ngaꞌbe̱pate nöꞌö mi mönga ar Hesu, bi böꞌu̱ go mi e̱mbabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jange xa mi nemhöꞌu̱ nda gu̱ ar Hesu. Ho̱nse̱ mi tsu ya jöꞌi, ngetho nuyu̱ mi beni ar Hesu már mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ar Hesu bi metwa manꞌar ꞌbedeyu̱ ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ár tsꞌu̱tꞌwi Jö bi ꞌbu̱ mhetsꞌi, ma ga he̱ju̱ ngu nꞌar ndö bi ꞌyo̱tꞌwa nꞌar ngo ár tꞌu̱ bi nthöti. ");
INSERT INTO otqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bi me̱hna yá ꞌbe̱go ma nda tsi nuꞌu̱ mi tho̱ꞌmi nda e har ngo, ha nuꞌu̱ himba ne ba ehe. ");
INSERT INTO otqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nepꞌu̱ nunar ndö bi me̱hna maꞌra ya ꞌbe̱go, ne bi ꞌñembabi: Ba xifu̱ nuꞌu̱ togo di to̱ꞌmhe, xta ñhoje. Xta hohe ya me̱ti ne ya nokaboi. Gatho xi thoki. ꞌÑembabihu̱: Ba ehu̱ ar ngo. ");
INSERT INTO otqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ha nuꞌu̱ mi tho̱ꞌmi, himbi japamasu nöꞌö bi xipa nuya ꞌbe̱go. Nꞌa bi mada ar ꞌbe̱fi ha yá hwöhi, ha manꞌa bi ma ba kꞌönga yá mꞌa̱ har hnini. ");
INSERT INTO otqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Maꞌra bi gu̱mpa yá ꞌbe̱go ar ndö, bi fe̱nza ne bi hyo. ");
INSERT INTO otqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nu mi ꞌyo̱ ar ndö gatho nöꞌö xki njapa yá ꞌbe̱go, xa bi mbo̱ ár kwe̱. Bi muntsꞌa yá ndogu, ne bi me̱hni ma nda hyonga nuya hyote nda hyo ne nda tsötꞌwa yá hnini. ");
INSERT INTO otqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nepꞌu̱ ar ndö bi ꞌñemba yá ꞌbe̱go: Xi thoka gatho da ho ar ngo, ne nuꞌu̱ ndi to̱ꞌmi himba ne ba ehe. Bi ntsꞌokse̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jange nupya, di möhu̱ ha ya döꞌñu, ne ba tsihu̱ gatho nuꞌu̱ gi nthe̱wihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bi ma yá ꞌbe̱go ma ba muntsꞌa gatho nuꞌu̱ mi nthe̱wi ha ya ꞌñu, ya tsꞌomꞌu̱i ne ya hogajöꞌi. Njapꞌu̱ bi ñuxa nöꞌö ar döta ngu habu̱ mi tꞌo̱tꞌa ar ngo. ");
INSERT INTO otqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nuꞌmú̱ ar ndö bi yu̱tꞌa har ngu nda ze̱ngwa nuꞌu̱ xki zo̱ho̱, ne bi hyanda nꞌa mi ꞌbu̱hnu̱ hinxki theta ar hengo. ");
INSERT INTO otqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jange bi ꞌñembabi: Ha gi o̱de ño̱. Hanja ga ku̱tꞌwa ne hingi he ar hengo. Nöꞌö hinte bi za̱ te bi dödi. ");
INSERT INTO otqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nuꞌmú̱ ar ndö bi ꞌñemba yá ꞌbe̱go: Xo̱thwu̱ yá ꞌye̱ ne yá wa, ba e̱ñhu̱ nthi har ꞌbe̱xui habu̱ da nzoni ne da guxtyá tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nu mi wa ar Hesu bi metwa nunar ꞌbedenu̱, bi ꞌñenö: —Ngetho nze̱ye̱ xi tsꞌohni, ha txꞌu̱tho nuꞌu̱ xi thahni. ");
INSERT INTO otqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nu mi ꞌyo̱ ya de̱ngaꞌbe̱pate njapꞌu̱, bi nju̱ki bi maꞌu̱, ma nda nkohi hanja nda tsa̱ nda hya̱tꞌa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba pe̱hna ꞌra yá ma̱xte bi me̱wi ꞌra yá ñꞌowi ar Erode, ma nda ꞌyo̱tꞌwa nꞌar ntꞌa̱ni, ne bi ꞌñembabi: —Utate, di pöhe gi mönga nöꞌö majöni ne gi utwa ya jöꞌi ár ꞌñu Jö. Hinto gi tsu, ne hinto gi hwantho. ");
INSERT INTO otqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jange di ne gi xikagihe, hage xiñho ga juthwe ar bojö jotꞌa ar Sesar, wa hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ha nunar Hesu mi pötwatho yá tsꞌomfeni, jange bi ꞌñembabi: —Xa gar nemhñöhu̱, yoꞌö gi ne gi hya̱ju̱. ");
INSERT INTO otqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Utkagihu̱ nꞌar bojö a̱ ar Sesar. Nuꞌmú̱ ba thömpabi ar bojö mi a̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne ar Hesu bi ꞌñembabiꞌu̱: —Togo ár me̱ti ar hmi huxkwa ne nöꞌö te mö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ha nuꞌu̱ bi dödi ne bi ꞌñenö: —Ár me̱ti ar Sesar. Ar Hesu bi ꞌñenö: —Umfu̱ ar Sesar nöꞌö ár me̱tiꞌö, ne umfu̱ Jö nöꞌö ár me̱tiꞌö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nu mi ꞌyo̱ njapꞌu̱, xa bi ꞌyo̱tho, ne bi zohnu̱ ar Hesu bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nor paꞌö bi zo̱hnu̱ ꞌra ya de̱ngamöjö, nuꞌu̱ hingi ñꞌemu̱i da mengi da nte nuꞌu̱ xi du, ne bi ꞌya̱mbabi, ");
INSERT INTO otqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","bi ꞌñeñꞌu̱: —Utate, ar Moise bi ꞌñenö, nuꞌmu̱ nꞌar ñꞌo̱ho̱ da du ne hinda zo nꞌar bötsi, nꞌár jödöpꞌu̱ꞌö da nthötwi ar ꞌranxu, ne da gu̱ꞌspa ár thuhu ár jödö manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nuje da pöhe yoto mi njödö. Nöꞌö ar ꞌbe̱tꞌo bi nthöti, bi du ne hinte bi zo ar bötsi. Jange nunar ꞌbe̱hñö bi mengi bi nthötwi ár jödöpꞌu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nor ñoho ñꞌo̱ho̱ bi du nꞌehe, ne ar hñu, ne bi njapꞌu̱ gatho yoto. ");
INSERT INTO otqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ár ngötsꞌi bi du ar ꞌbe̱hñö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Núꞌmu̱ xta mengi da nte manꞌagi, togo ár ꞌbe̱hñönu̱ ꞌmu̱, ngetho bi nthötwi gatho yoto ya ñꞌo̱ho̱ mi njödö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Xi tsꞌonga ri mfenihu̱, ngetho hingi pöhu̱ ar Tꞌofo, ne hingi po̱hu̱ ár tsꞌe̱di Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nu xta menga ya jöꞌi da nte manꞌagi, hinda ma da nthöti, hinda ma da tꞌa̱di. Ma da ñhe̱hwi yá e̱nxe̱ Jö bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nöꞌö ha pengi da nte nuꞌu̱ xi du wa hinꞌö, hage hinxka nehu̱ habu̱ enga njawa Jö har Tꞌofo: ");
INSERT INTO otqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nuga ár Jögi ar Abra, ar Isa ne ar Hakob. Jö go ár Jö nuꞌu̱ te, hinge nuꞌu̱ xi du. ");
INSERT INTO otqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nu mi ꞌyo̱xa njapꞌu̱ ya jöꞌi, xa bi ꞌyo̱da nöꞌö mi utꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nu mi bö ya de̱ngaꞌbe̱pate nunar Hesu xki gotwa yá ne ya de̱ngamöjö, bi mhuntsꞌi nda nu te nda me̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nepꞌu̱ nꞌa nuꞌu̱ már bötꞌofo, bi ma ba o̱tꞌwa nꞌar ntꞌa̱ni ar Hesu, xömhö nda hya̱tꞌi, ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Utate, ndana ar ꞌbe̱pate töte ár nsu hár tꞌofo ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ar Hesu bi ꞌñenö: —Xa gi ꞌñetꞌa ri mu̱i, gi ꞌye̱ntꞌa ri te, ne gi hñuxa ri mfeni gi mö Jö ri Hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Go gehnu̱ ar ꞌbe̱tꞌo ꞌbe̱pate, ne gehnu̱ töpa ár nsu gatho nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne nor ñoho ñhe̱hwitho: Gi mö ri mijöꞌiwi ngu gi mhöse̱. ");
INSERT INTO otqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ha nuya ꞌbe̱pateyu̱, ka po̱ngwa gatho yá ꞌbe̱pate ar Moise, ne gatho nöꞌö mönga yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Núꞌmu̱ xki mhuntsꞌa ya de̱ngaꞌbe̱pate, ar Hesu bi ꞌyo̱tꞌwa nꞌar ntꞌa̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ne bi ꞌñembabi: —Togo gi beñhu̱ ar Kristo. Togo ár tꞌu̱ꞌö. Nuya de̱ngaꞌbe̱pate bi ꞌñeñꞌu̱: —Ár tꞌu̱ ar Dabi. ");
INSERT INTO otqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nuꞌmú̱ ar Hesu bi ꞌñenö: —Xiꞌmu̱, yoꞌö ar Dabi, xki nzinga ár Hñö Jö, embabi ár Hmu ꞌmu̱. Ngetho bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jö ar Dada bi ꞌñemba ma tsi Hmu: Hñu ha ma ñꞌe̱i ga huxkwi, to̱ꞌmi ga tsiñꞌa nuya ri ñꞌu̱ni ga tse̱pꞌa ha ri wa. ");
INSERT INTO otqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nuꞌmu̱ ar Dabi embabi ár Hmu, hanja ár tꞌu̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ne hinte bi za̱ te bi dödi. Nu ar paꞌö di ꞌñe injawa, hinto bi ne bi ꞌyo̱tꞌwa ya ntꞌa̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nuꞌmú̱ ar Hesu bi zo yá ma̱xte ne gatho ya jöꞌi mi ꞌbu̱hnu̱, ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Nuya de̱ngaꞌbe̱pate ne ya bötꞌofo, xi tꞌumba ar nsu da utꞌahu̱ tema di bo̱nga nöꞌö bi ꞌyotꞌa ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jange ꞌyo̱thu̱ gatho nöꞌö da xiꞌahu̱. Ho̱nse̱ yo gi te̱mbabihu̱ yá tsꞌoꞌbe̱fi, ngetho möñꞌu̱ xiñho, ha hingi o̱tꞌa njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nuꞌu̱ tutwa ya ꞌbe̱ni ya jöꞌi xi ñhu̱, ha nuyu̱ hingi ne da da̱ñꞌu̱tsꞌu̱ da ma̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nöꞌö o̱tꞌu̱, te gatho pe̱ ha yá nthandi ya jöꞌi, ne da ꞌñexyá nsu. Tsu̱ta ya tꞌofo ha yá dë ne ha yá ꞌye̱, ne tutwa xi nxidi ár ñöni yá he. ");
INSERT INTO otqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nu ha ya da̱ngo xa honga da hñuxa ha ya mꞌe̱tꞌo nthutsꞌi, ne xa ne da hñuxa ha ya hoga nthutsꞌi ha ya nijö, honi da tꞌeꞌspa yá nsu. ");
INSERT INTO otqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Xa ne da ndömbyá ꞌye̱ núꞌmu̱ da nze̱ngwa ha ya ta̱i, ne da tꞌembabiꞌu̱: Ma tsi utateꞌihe. ");
INSERT INTO otqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ha nuꞌahu̱, yo ma gi ñhe̱hu̱ da tꞌesꞌahu̱ ri nsuhu̱, ne da tꞌeñꞌaꞌihu̱ gar utatehu̱. Ngetho nꞌadar Utate, ho̱nse̱ ar Kristo, ha nuꞌahu̱ gatho gi nkuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hinto ma gi ꞌñembabihu̱ ri dadahu̱wa har ximha̱i, ngetho nꞌada ri Dadahu̱, gehnu̱ bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yo ma gi ñhe̱hu̱ da tꞌeñꞌahu̱ gar utatehu̱ gi tsixu̱ ar ꞌñu, ngetho nꞌada togo tsixa ar ꞌñu, gehnu̱ ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nöꞌö togo ꞌbu̱ mañö pe̱ꞌsa nꞌar döta nsu, mahyoni da me̱pa nu maꞌra nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngetho nöꞌö togo da ñꞌexase̱, mꞌe̱fa ma da mꞌe̱twa ár tsa̱, ha nöꞌö togo da ntsꞌa̱ꞌmi, ma da tꞌeꞌspa ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hwëkate nuꞌahu̱ gar bötꞌofohu̱ ne gar de̱ngaꞌbe̱patehu̱, xa gar nemhñöhu̱. Hingi ku̱thu̱, ne hingi he̱hu̱ da yu̱tꞌa nuꞌu̱ togo ne da yu̱tꞌa hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nuꞌahu̱ gar bötꞌofohu̱ ne gar de̱ngaꞌbe̱patehu̱, xa gar nemhñöhu̱. Gi ha̱thu̱ ya tsi ꞌranxu, gi hömfu̱ yá ngu, ne xa gi o̱thu̱ ya nsa̱di, hingi ne da nheki ri tsꞌoꞌbe̱fihu̱. Jange xa döta ri mfe̱i gi to̱ꞌmhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hwëkate nuꞌahu̱ gar bötꞌofo ne gar de̱ngaꞌbe̱patehu̱, nemhñöhu̱. Xa gi mpu̱nthu̱ gi hoñhu̱ togo da de̱mpꞌa ri ntꞌutihu̱. Ne xki tiñhu̱, xa gi tsꞌokwabihu̱ yá mfeni, gi ꞌbe̱tꞌohu̱ da ma njöntho har ꞌbe̱xui habu̱ gir möhu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Di hñöxꞌahu̱ ya goda̱ gu̱hna maꞌra. Hwëkateꞌihu̱ gi eñhu̱, nuꞌmu̱ togo da ꞌñetꞌa made ar dönganijö, hinter me̱ꞌö. Ha nuꞌmu̱ togo da ꞌñetꞌa made ar kꞌaxtꞌabo̱jö ja har dönganijö, nuꞌmú̱ hö, xi ntsꞌuni nöꞌö bi mö. ");
INSERT INTO otqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gar goda̱hu̱ ne xa xka ꞌbe̱ ri mfenihu̱. Ndana töte ár nsu, ar kꞌaxtꞌabo̱jö wa ar dönganijö japi da hñuxa ár nsunu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne gi eñhu̱, nuꞌmu̱ togo da ꞌñetꞌa made ar tꞌu̱xmꞌo̱ñho̱, hinter me̱ꞌö. Ha nuꞌmu̱ togo da ꞌñetꞌa made nöꞌö ar mꞌo̱ñho̱ oxhnu̱, nuꞌmú̱ hö, xi ntsꞌuni nöꞌö bi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Goda̱hu̱ xka ꞌbe̱thwu̱ ár ꞌñu ar tsi Dada. Ndana töte ár nsu, ar mꞌo̱ñho̱ wa ar tꞌu̱xmꞌo̱ñho̱ nuna japi da hñuxa ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jange nöꞌö togo etꞌa made ar tꞌu̱xmꞌo̱ñho̱, etꞌa made gatho nöꞌö te ku̱xhnu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Njapꞌu̱ hinge ho̱nse̱ etꞌa made ar dönganijö, etꞌa made Jö togo ꞌbu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nöꞌö togo etꞌa made mhetsꞌi, etꞌa made ár thuxandö Jö, ne gese̱ Jö togo huxhnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hwëkateꞌihu̱ gar bötꞌofohu̱ ne gar de̱ngaꞌbe̱patehu̱, gar nemhñöhu̱. Ngetho gi uñhu̱ ár ꞌre̱tꞌa xe̱ni ya do̱ni tꞌu̱ꞌsa ar ñhuni, ne xka hye̱hu̱ nuna ꞌbe̱tꞌo ha yá ꞌbe̱pate ar Moise. Xka hye̱hu̱ gi ꞌyo̱thwu̱ xiñho maꞌra, ar nhwëki ne ar ñꞌemu̱i. Xiñho gi ꞌyo̱thu̱yu̱, ne hingi hye̱hu̱ nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gar goda̱ gu̱hnatehu̱. Gi o̱thu̱ nöꞌö hintsꞌu̱ ntsꞌuni, ne gi he̱hu̱ nöꞌö xa pe̱ꞌsa ár ntsꞌuni. Jangutho gi ntsuñhu̱ hingi tuthu̱ nꞌar tsi tꞌu̱lo zuꞌwe, ne gi tutꞌathohu̱ ya döta zuꞌwe. ");
INSERT INTO otqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hwëkate nuꞌahu̱ gar bötꞌofohu̱ ne gar de̱ngaꞌbe̱patehu̱, xa gar nemhñöhu̱. Gi ñhe̱hwihu̱ nꞌar ꞌbada wa nꞌar mohi, ho̱nse̱ xi nsu̱tꞌa nthi, ne mbo ri mu̱ihu̱ ne ri mfenihu̱ xa ñuxa ar mfë ne ar tsꞌomꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Goda̱ de̱ngaꞌbe̱patehu̱, xu̱thu̱ mꞌe̱tꞌo mbo ri mfenihu̱ ne ri mu̱ihu̱, ne njapꞌu̱ da tꞌaxkꞌahu̱ nthi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hwëkate nuꞌahu̱ gar bötꞌofohu̱ ne gar de̱ngaꞌbe̱patehu̱, xa gar nemhñöhu̱. Di hñöxꞌahu̱ ya tꞌa̱gi xintꞌaxi nthi ne nheki nza̱tho, ha ku̱ yá ndoꞌyo nuꞌu̱ xi du thota yá ntsꞌotho. ");
INSERT INTO otqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gi njahu̱pꞌu̱ nꞌehe, ngetho ha yá hmi ya jöꞌi xa gi o̱thu̱ gar hogajöꞌiꞌihu̱, ne ha ri mfenihu̱ hingi tsa̱ya̱ ar nhemhñö ne ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hwëkate nuꞌahu̱ gar bötꞌofohu̱ ne gar de̱ngaꞌbe̱patehu̱, xa gar nemhñöhu̱. Ngetho gi hojwu̱ yá tꞌa̱gi yá mꞌe̱hni Jö, ne gi köꞌthwu̱ yá tꞌa̱gi ya hogajöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne gi eñhu̱: Nuꞌmu̱ xta ꞌbu̱hmöhu̱ nuya pa mi ꞌbu̱ ma palehu̱, hinxta fa̱xhmöhu̱ xi hyopa yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jange gi nda̱se̱hu̱ yá ꞌbe̱toꞌihu̱ nuꞌu̱ togo bi hyopa yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jwathu̱ ꞌmu̱ nöꞌö bi du̱ꞌma ri palehu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yá bötsiꞌihu̱ ya kꞌeñö. Hanja ma gi kꞌonthu̱ da ꞌbe̱ñꞌahu̱ har tsibi. ");
INSERT INTO otqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jange ma ga pe̱ñꞌahu̱ maꞌra ya mꞌe̱hni, ne nuꞌu̱ di pe̱ꞌsa yá hoga mfeni ne ya bötꞌofo. ꞌRayu̱ ma gi hyohu̱, maꞌra gi tsu̱thu̱ har pontꞌi, maꞌra gi fe̱hu̱ ha ri nijöhu̱ ne gi kuhu̱ di ne ya hnini. ");
INSERT INTO otqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ne njapꞌu̱ go ma gi kꞌothu̱ ar tha̱i xi thutsꞌi núꞌmu̱ mi nhöꞌmba ár ji ya hogajöꞌi. Di ndu̱ꞌma núꞌmu̱ mi nhöꞌmba ár ji ar hoga Abel, di göxa ár ji ar Sakaria ár tꞌu̱ ar Berekia, togo ga hyohu̱ madeda ar tsꞌötmꞌo̱ñho̱ ne ar nijö. ");
INSERT INTO otqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Xa majöni di xiꞌahu̱, gatho nor tha̱inu̱, ma da kꞌotꞌa nuya jöꞌi ꞌbu̱ nuya payu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nuꞌahu̱ gar menguhu̱ Herusalen, gi kꞌampabihu̱ togo bi pe̱ñꞌahu̱, ne gi hofu̱ yá mꞌe̱hni Jö. Hangu xta nemhö nga muntsꞌaꞌihu̱, ngu nꞌar tsi o̱ni muntsꞌa yá tsi tꞌu̱ꞌni da hwixa ha yá hwa, ne hinga nehu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pöhu̱, Jö ma da hye̱kꞌase̱ ri nijöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngetho di xiꞌahu̱, hinge ma gi hyandgagihu̱ nuya payu̱. Gi to̱ꞌmhu̱ mꞌe̱tꞌo da zo̱ ar pa gi ꞌñeñhu̱: Nsunda togo xpa pe̱hna Jö ma Hmuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nu mi bo̱nga ar Hesu har dönganijö, mi ꞌba̱ ar ꞌñu nda ma, bi watꞌa yá ma̱xte mi utwabi tengu ár nza̱tho ar nijö. ");
INSERT INTO otqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱: Gatho nuya jödoyu̱ gi hanthu̱, ma da thextꞌa gatho. Hinda ma da go nꞌar do mañö ár midowi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nepꞌu̱ ar Hesu bi ma har tꞌo̱ho̱ Njömdo̱ni ne ka ba huhnu̱. Ba epꞌu̱ yá ma̱xte bi ꞌya̱mbase̱ ne bi ꞌñembabi: —Di ne gi xikagihe hamꞌu̱ ma da tho gatho nöꞌö xka mö, ne tema ntꞌudi ma ga hanthe, njapꞌu̱ ga pöhe ꞌba̱pꞌu̱tho gi pengi, ne da göxa nuya payu̱ di ꞌbu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nuꞌmú̱ ar Hesu bi dötwabi ne bi ꞌñenö: —Jamasuhu̱ yo ma gi ñhe̱hu̱ to da hya̱ꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngetho ma da e nze̱ye̱ togo ma da gu̱mka ma thuhu ne da ꞌñeñꞌu̱: Nuga go dar Kristo. Ne njapꞌu̱ ma da ka nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma gi ꞌyo̱hu̱ habu̱ bi ja ya tuhni ne habu̱ ja ma da ndu̱i. Nuꞌahu̱ yo gi tu ri mu̱ihu̱, ngetho mahyoni da njapꞌu̱. Mödi thohyu̱, hinxi zo̱ta ár ngötsꞌi gatho nöꞌö te japya. ");
INSERT INTO otqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nuya hnini ma da ntunkwi yá mihniniwi. Ma da nja ya textehñeni, ar thuhu, ha nunar ximha̱i habu̱ gatho ma da nhwöni. ");
INSERT INTO otqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gatho nuya dumu̱iyu̱, ho̱nse̱ ár ndu̱i ar u̱gi xi ꞌñepꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ma da nda̱tꞌahu̱ da mfe̱pꞌahu̱, da thoꞌahu̱, ne xa ma da ntꞌu̱tsaꞌihu̱ ngetho xka ñꞌemu̱igihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nuya paꞌu̱ nze̱ye̱ ma da ꞌbe̱ yá jamfi, ne ma da ñꞌu̱tsa nꞌa ngu nꞌa, ne ma da da̱se̱ yá ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma da e nze̱ye̱ ya hya̱te da ꞌñenö xpa pe̱hna Jö, ne ma da hya̱tꞌa nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ne ár mhöte nze̱ye̱ ya jöꞌi ma da ꞌbe̱di, ngetho ma da xu ar tsꞌoki gatho har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nuꞌu̱ togo da ze̱ta gatho nuya thogiyu̱, da do̱ꞌmi da göxa xo̱ge, go ma da mpo̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ne ma da nu̱nga nunar hoga mhönu̱ no̱mba ár tsꞌu̱tꞌwi Jö gatho ár nxidi ar ximha̱i, ne da ꞌyo̱ gatho ya jöꞌi. Mꞌe̱fa da göxa xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jange xki hyanthu̱ ar tsꞌoki xi ntsꞌotho da yu̱tꞌa habu̱ ndönga Jö, ngu bi ꞌyotꞌa ar mꞌe̱hni Dañe (nöꞌö togo da nehe, dá bödi xiñho tema ne da mö), ");
INSERT INTO otqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nuꞌmú̱, nuꞌahu̱ gi ꞌbu̱hu̱wa Nhudea, di möhu̱ ba ñꞌöñhu̱ ha ya tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nöꞌö togo di to̱ mañö ar ngu, yo ma gi ku̱thu̱ te gi ju̱ju̱. Nixtꞌi di möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nöꞌö togo ꞌyo har ꞌbatha, yo ma gi penju̱ gi ju̱ju̱ ri pa̱tꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Hwëkate nuꞌu̱ ya ꞌbe̱hñö di ñꞌu̱, ne nuꞌu̱ di tsu̱tyá bötsi nuya paꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ꞌYa̱pabihu̱ Jö, nöꞌö ar pa gi nixtꞌihu̱, hinda da̱tꞌa ya tse̱, ne hindar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngetho nuya paꞌu̱, xa ma da nja ya thogi ngu hinxka hyanthu̱ núꞌmu̱ mi ndu̱ta ar ximha̱i di njawa, ne xta thogi hinda ma da nja manꞌa nguꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nuꞌmu̱ hinda göxa ngutꞌa nuya paꞌu̱, hinto da bonkꞌmu̱. Jö ma da jötsꞌi, ngetho ma da ma̱xa togo xi hwañꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nuꞌmu̱ da tꞌeñꞌahu̱: Ka bi ꞌbu̱kwa ar Kristo, wa da tꞌeñꞌahu̱: Ndi, bi ꞌbu̱hnu̱, yo ma gi jafu̱masu. ");
INSERT INTO otqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngetho ma da e ya kate Kristo ne ya kate mꞌe̱hni. Ma da ꞌyo̱tꞌa ya döta ntꞌudi da hya̱tꞌa ya jöꞌi, ne nuꞌmu̱ da tsa̱hmö, da hya̱tꞌa nuꞌu̱ xi thahni. ");
INSERT INTO otqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nuya xta xiꞌahu̱ mꞌe̱tꞌo, yo ma gi ñhe̱hu̱ da hya̱ꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jange nuꞌmu̱ da siꞌahu̱: Bi ꞌbu̱hnu̱ har otꞌatꞌo̱ho̱, yo ma gi kꞌöꞌsu̱. Wa nuꞌmu̱ da tꞌeñꞌahu̱: ꞌBu̱kwa har ngu, yo ma gi jafu̱masu. ");
INSERT INTO otqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngetho nu xta penga Nöꞌö Togo ba e bi Njöꞌi, xki tha̱ñhu̱ dama da zo̱ho̱. Ne da nheki xo̱ge ar ximha̱i, ngu nꞌar hwe̱i da yotꞌa ha mahyatsꞌi ne di mꞌe̱ mampuni. ");
INSERT INTO otqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nuya paꞌu̱ ma da ñhe̱hwi jangu ya pada kwatꞌa habu̱ ꞌbe̱nga nꞌar me̱ti xi du. ");
INSERT INTO otqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ngu da göxa nuya paꞌu̱ ñꞌu̱tho, ar hyadi ma da mꞌe̱xui, ha nunar zönö hinda ma da unga ár hyatsꞌi. Ya tso̱ ma da hyo̱i, ne gatho nuꞌu̱ ja yá tsꞌe̱di mhetsꞌi ma da nhwötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nuꞌmú̱ ma da nheki nꞌar döta ntꞌudi mhetsꞌi ár yo mpengi Nöꞌö Togo ba e bi Njöꞌi. Ne gatho ya jöꞌi ꞌbu̱ hár nxidi ar ximha̱i, ma da nzoni nu xta hyandi da zo̱ho̱ xta ꞌñe ha ya gui, di hö nꞌar döta tsꞌe̱di ne nꞌar döta nsunda. ");
INSERT INTO otqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ne ma da me̱hna yá e̱nxe̱ xta ntꞌo̱ ar kꞌaxtꞌathu̱xi, da muspa gatho nuꞌu̱ togo xi hwañꞌö xo̱ge ár nxidi ar ximha̱i, di ndu̱ ha nꞌár ñöni, di göxa manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Pöhu̱ tema ne da utkagihu̱ ár ꞌbede ar iuxi: Núꞌmu̱ xki hyanthu̱ po̱xa yá nꞌogi ne po̱ yá xi, gi pöhu̱ ba epꞌu̱tho ar pahyadi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jange núꞌmu̱ xki hyanthu̱ gatho nuya thogiyu̱, pöhu̱, ꞌba̱pꞌu̱tho da göxa xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Xa majöni di xiꞌahu̱, hinda theta gatho nuya jöꞌi ꞌbu̱ nuya payu̱, ne xi wadi xi tho gatho nuya thogiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mödi da mꞌe̱di ar mhetsꞌi ne ar ximha̱i, nuya mhö xta mö, hinda ma da mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nöꞌö ar pa ne ar xe̱nimpa hamꞌu̱ da göxa xo̱ge, hinto pödi. Nuyá e̱nxe̱ Jö hingi pöhmö nꞌehe, ho̱nse̱ ma Dada bi ꞌbu̱ mhetsꞌi go pöꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nu xta mengi da e manꞌagi Nöꞌö Togo ba e bi Njöꞌi, ma da njangu nuya pa mi ꞌbu̱ ar Noe. ");
INSERT INTO otqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Núꞌmu̱ himi tso̱ta ar pa nda yu̱tꞌa ar Noe har motsa, ne nda ñuxa ar dehe xo̱ge ar ximha̱i, nuya jöꞌi mi ñuntho, mi tsithetho ne mi o̱tya ngo. ");
INSERT INTO otqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Himbi ne bi ꞌyo̱ꞌu̱, mi da̱ñꞌu̱ bi ñuxa ar dehe xo̱ge ar ximha̱i, ne gatho bi jötꞌi. Ma da njapꞌu̱ xta penga Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nuya paꞌu̱, nuꞌmu̱ yoho ya ñꞌo̱ho̱ di ꞌyo har hwöhi di mpe̱fi, xta da̱ñꞌu̱ nꞌa ma da tsꞌitsꞌi ne nöꞌö manꞌa ma da tsꞌopꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nuꞌmu̱ yoho ya ꞌbe̱hñö di ku̱nga mahye̱gi, da tsꞌixa nꞌa, nöꞌö manꞌa da tsꞌogi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jange ndo̱ꞌmhu̱, ngetho hingi pöhu̱ hamꞌu̱ da zo̱ ri Hmuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Beñhu̱ ꞌmu̱, nuꞌmu̱ nꞌar mengu di pöhmö hamꞌu̱ da zo̱ ar bë, hinda ñꞌö ꞌmu̱. Da su hinda hye̱gi togo da bëpa ár ngu. ");
INSERT INTO otqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jange nuꞌahu̱ nꞌehe ndo̱ꞌmhu̱, ngetho xki tha̱ñhu̱ ma da epꞌu̱ Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nöꞌö togo ar hoga ꞌbe̱go xa di ja ár mfeni, tsa̱ da tꞌe̱ntꞌwa hár ꞌye̱ ár ngu ár hmu, ne da tsꞌokwabi da ꞌwinga gatho nuꞌu̱ togo ꞌbu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nuꞌmú̱ xa ma da njöpa nunar hoga ꞌbe̱goꞌö, xta zo̱ ár hmu da dini di o̱tꞌa xiñho gatho ar ꞌbe̱fi xi tsꞌokwabi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Xa majöni di xiꞌahu̱, nöꞌö ar hmuꞌö ma da ꞌye̱ntꞌwa hár ꞌye̱ gatho nöꞌö te pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ha xiꞌmu̱ nöꞌö ar ꞌbe̱goꞌö xi ntsꞌo, ne ka̱xmbeni ár hmu hinda ma da penga ngutꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ne da gu̱ da me̱ nuꞌu̱ yá miꞌbe̱gowi, ne da ñungwi ne da ntsithewi ya mihni. ");
INSERT INTO otqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Xta da̱ni nunar pa hingi to̱ꞌmi, dama da zo̱ ár hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nuꞌmú̱ nor hmuꞌö ma da mbo̱ ár kwe̱, xa ma da umba ar mfe̱i, ne da ꞌñetꞌa habu̱ bi ꞌbu̱ ya kate. Ka ma da nzonu̱ ne da guxtyá tsꞌinu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Núꞌmu̱ xta penga Nöꞌö Togo ba e bi Njöꞌi da ꞌñekwa ár tsꞌu̱tꞌwi, ma da ñhe̱hwi ngu nꞌar nthöti bi tꞌo̱tꞌe. ꞌRe̱tꞌa ya nxutsi bi hñöxa yá ñotꞌi, ma ba thö ar ñꞌo̱ho̱ ma nda nthöti. ");
INSERT INTO otqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ha nuya nxutsiꞌu̱, ku̱tꞌa mi ja yá mfeni ne ku̱tꞌa mi ñꞌentho. ");
INSERT INTO otqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nuꞌu̱ ku̱tꞌa mi ñꞌentho, himbi hñöxa nze̱ye̱ ar nziki da xitꞌa yá ñotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ha nuꞌu̱ ma ku̱tꞌa mi ja yá mfeni, bi hñöxkwi mahye̱gi yá ñotꞌi nꞌa xito mi po ar nziki. ");
INSERT INTO otqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nöꞌö ma nda nthöti himbi ngutꞌa bi zo̱ho̱, jange gatho ꞌre̱tꞌa ya nxutsi bi zo̱pa ar tꞌöhö ne bi ñꞌöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ngu made ar xui bi nheki nꞌar mhafi mi emba ya nxutsi: Xi ꞌñepꞌu̱ nöꞌö togo ma da nthöti. Di ma ba thöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nuꞌmú̱ nuꞌu̱ ꞌre̱tꞌa ya nxutsi bi nuhu, ne dama bi tso̱ yá ñotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nuꞌu̱ mi ñꞌentho bi ꞌñemba nu ma ku̱tꞌa mi ja yá mfeni: Thogagihe nꞌa tu̱i ri nzikihu̱, ngetho ma ñotꞌihe hwetꞌatho. ");
INSERT INTO otqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ha nuya nxutsi mi ja yá mfeni, bi ꞌñemba nu maꞌra: Hinꞌö, xiꞌmu̱ da kꞌatkagihe nꞌe. Xiñho ma gi ta̱nse̱hu̱ habu̱ bi ꞌba̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Núꞌmu̱ mi ꞌyo ar ꞌñu ma nda da̱nga ar nziki, geꞌmu̱ bi zo̱ nöꞌö togo ma nda nthöti. Nuꞌmú̱ nuꞌu̱ ku̱tꞌa ya nxutsi xki ñhoki bi yu̱tꞌwi har ngo, ne bi njotꞌa ar goxthi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mꞌe̱fa bi zo̱ nuꞌu̱ maꞌra ya nxutsi, ne mi eñꞌu̱: Ndada, xogagihe ar goxthi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ha nöꞌö togo ma nda nthöti, bi döti ne bi ꞌñembabiꞌu̱: Xa majöni di xiꞌahu̱, hindi pöka togoꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jange nuꞌahu̱ ndo̱ꞌmhu̱, ngetho hingi pöhu̱ tema pa, wa tema xe̱nimpa, ma da zo̱ Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ár tsꞌu̱tꞌwi Jö jangu nꞌar hmu mi ꞌba̱ ar ꞌñu nda ma manꞌar ha̱i yapꞌu̱. Ne bi zohna yá ꞌbe̱go ne bi hyemba ár bojö nda japabi nda xu, ");
INSERT INTO otqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ngu ár nihi yá mfeni nꞌa ngu nꞌa. Nꞌa bi umba ku̱tꞌa ya bojö, manꞌa bi umba yoho, ha nöꞌö manꞌa nꞌase̱ bi umbabi. Nepꞌu̱ bi gu̱ ar ꞌñu bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nöꞌö togo bi tꞌumbabi ku̱tꞌa, bi ma ba japa nunar bojönu̱ bi mpe̱fi, ne bi gu̱ka ma ku̱tꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Njapꞌu̱ nöꞌö xki tꞌumba yoho nꞌehe, bi gu̱ka ma yoho. ");
INSERT INTO otqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nöꞌö togo xki tꞌumba nꞌa, bi ma ba xa̱ꞌma nꞌar otsꞌi, ne ka bi ꞌñöhnu̱ ár bojö ár hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mi tho nze̱ye̱ ya pa ba penga ar hmu, ne bi hñöꞌspa majöni yá ꞌbe̱go. ");
INSERT INTO otqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mi zo̱ nöꞌö xki tsꞌokwabi ku̱tꞌa ya bojö, bi umba ár hmu ma ku̱tꞌa xki döhö, ne bi ꞌñembabi: Tsi ndada, ga tsogagi ku̱tꞌa ya bojö, ha nuga da höñꞌa ma ku̱tꞌa xta töhö. ");
INSERT INTO otqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nuꞌmú̱ ar hmu bi dödi ne bi ꞌñenö: Xiñho nöꞌö xka pe̱fi, xa gar hoga ꞌbe̱go gi o̱tꞌa nöꞌö nsiꞌaꞌi. Ga pödi ga su nöꞌö tsi tu̱i da ꞌraꞌi. Nupya ma ga husꞌa ár nze̱ye̱. Ba e ga ꞌbu̱hwi ri hmugi, ne ga njohyawi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mꞌe̱fa bi zo̱ nöꞌö xki tꞌumbabi yoho ya bojö, ne bi ꞌñemba ár hmu: Tsi ndada, ga tsogagi yoho ya bojö, ha nuga xta höñꞌa ma yoho xta töhö. ");
INSERT INTO otqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nuꞌmú̱ ar hmu bi dödi ne bi ꞌñenö: Xiñho nöꞌö xka pe̱fi, xa gar hoga ꞌbe̱go gi o̱tꞌa nöꞌö nsiꞌaꞌi. Ga pödi ga su nöꞌö tsi tu̱i da ꞌraꞌi. Nupya ma ga husꞌa ár nze̱ye̱. Ba e ga ꞌbu̱hwi ri hmugi, ga njohyawi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Núꞌmu̱ mi zo̱ ar ꞌbe̱go xki tsꞌokwa nꞌar bojö, bi ꞌñemba ár hmu: Tsi ndada, di pödi xi ntsꞌoꞌi, ne ma gi hñömga nöꞌö xta töhö, ngetho gi xo nöꞌö hinxka potꞌi, ne gi muntsꞌa ar tꞌe̱i hinxka pitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jange nuga da tsu, ne ma da a̱gi, ha nupya xi ꞌbu̱kwa nöꞌö ri me̱ti. ");
INSERT INTO otqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ar hmu bi dödi ne bi ꞌñenö: Xa gar tsꞌoꞌbe̱go ne gar döhñe. Nuꞌmu̱ ngi pödi di xo nöꞌö hinxta potꞌi ne di muntsꞌa nöꞌö hinxta pitsꞌi, ");
INSERT INTO otqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nuꞌmú̱, yoꞌö hinga kwata ma bojö ha ya jwatbojö, ne xta pengi nda tꞌakagi ma bojö ne nöꞌö xki döhö. ");
INSERT INTO otqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ne bi ꞌñemba nuꞌu̱ togo mi ñꞌowi: Hñömbabihu̱ ar bojö da tsokwabinu̱, ne umbabihu̱ togo pe̱ꞌsa ꞌre̱tꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngetho nöꞌö togo pe̱tsꞌi, ma da tꞌumbabi da bongwathobi, ha nöꞌö tsi tu̱i pe̱tsꞌi, ma da thömbabi xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne nöꞌö ar ꞌbe̱go hinter ꞌbe̱fi, ꞌñethu̱ har ꞌbe̱xui habu̱ jar tsꞌoni ne ar nguxtꞌatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nu xta penga Nöꞌö Togo ba e bi Njöꞌi di hö nꞌar döta nsunda, ne di ñꞌowi yá e̱nxe̱, da hñuxa hár thuxandö da hñöꞌspa majöni ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma da mhuntsꞌa gatho ya jöꞌi ꞌbu̱ hár nxidi ar ximha̱i, ne da hwahna nꞌa ngu nꞌa, njangu nꞌar ma̱ꞌyo ꞌweka ya de̱ti ne ya tꞌöxi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne ma da ꞌba̱ꞌma hár ñꞌe̱i ya tsi de̱ti, ne hár ngöhö ya tꞌöxi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nuꞌmú̱ nunar Ndö ma da ꞌñemba nuꞌu̱ ꞌba̱ hár ñꞌe̱i: Ba ehu̱ nuꞌahu̱ xi jöpꞌahu̱ ma Dada, ku̱thu̱ hár tsꞌu̱tꞌwi Jö xi thokꞌahu̱ núꞌmu̱ hinte mi ꞌbu̱hmö ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngetho núꞌmu̱ ndi tunthu, ga ꞌraju̱ te da tsi. Núꞌmu̱ ndi tuthe, ga ꞌraju̱ ar dehe, ne núꞌmu̱ ndi ne ar ꞌñu, ga ꞌraju̱ habu̱ da oxi. ");
INSERT INTO otqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Núꞌmu̱ himi otho te nga he, ga hetkagihu̱. Núꞌmu̱ ndi hñeni ne ndi o ar fa̱di, ga e ga kꞌöskagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nuꞌmú̱ nuꞌu̱ bi ꞌyo̱tꞌa xiñho da ꞌñeñꞌu̱: Ma tsi Hmuꞌihe, hamꞌu̱ da hantꞌahe ngi tunthu, ne da ꞌraꞌahe te ngi tsi. Wa hamꞌu̱ da hantꞌahe ngi tuthe, ne da ꞌraꞌahe ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hamꞌu̱ da hantꞌahe ngi ne ar ꞌñu, ne da ꞌraꞌahe habu̱ ngi oxi. Wa hamꞌu̱ da hantꞌahe mi otho te ngi hye, ne da hetꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hamꞌu̱ da hantꞌahe ngi hñeni, wa ngi o ar fa̱di, ne ma da kꞌösꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nuꞌmú̱ ar Ndö da dödi ne da ꞌñenö: Xa majöni di xiꞌahu̱, nuꞌmu̱ ga ꞌyo̱thwu̱ nꞌa nuꞌu̱ ma tsi ku, mödi hingi döta hár nthandi ya jöꞌi, pöhu̱ go ga ꞌyo̱tkagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mꞌe̱fa ar Ndö da ꞌñemba nuꞌu̱ ꞌba̱ hár ngöhö: ꞌWehu̱ di möhu̱ nuꞌahu̱ xi zu̱ꞌahu̱ ár kwe̱ Jö. Di ma ba ñho̱hu̱ har tsibi hiñhamꞌu̱ da hwetꞌi, xi tꞌe̱kwabi ar tsꞌondöhi ne yá e̱nxe̱ te̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngetho ndi tunthu, ne hinga ꞌraju̱tsꞌu̱ te nga tsi. Ndi tuthe, ne hinga ꞌraju̱tsꞌu̱ ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ndi ne ar ꞌñu, hinga ꞌraju̱ ar se̱ki habu̱ nga oxi. Mi otho te nga he, ne hinga hyetkagihu̱. Ndi hñeni ne ndi o ar fa̱di, ne hinga ma ga kꞌöskagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nuꞌmú̱ ya tsꞌojöꞌi ma da dödi ne da ꞌñeñꞌu̱: Ma tsi Hmuꞌihe, hamꞌu̱ da hantꞌahe ngi tunthu, ngi tuthe, ngi ne ar ꞌñu, hinte ngi pe̱ꞌsa te ngi hye, ngi hñeni wa ngi o har fa̱di, ne hinda fa̱xꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nuꞌmú̱ ar Ndö da dötwabi ne da ꞌñenö: Xa majöni di xiꞌahu̱, nuꞌmu̱ hingi fa̱xu̱ nꞌa numa tsi ku hingi döta hár nthandi ya jöꞌi, pöhu̱ go gekagi togo hinxka fa̱xu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nuꞌmú̱ nuꞌu̱ di ma habu̱ ma da hñönga ar mfe̱i hiñhamꞌu̱ da götsꞌi. Ha nuꞌu̱ xi ꞌyo̱tꞌa xiñho, ma da yu̱tꞌa mhetsꞌi habu̱ hiñhamꞌu̱ da göxa yá te. ");
INSERT INTO otqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nu mi wa ar Hesu bi mönga gatho nuya mhöyu̱, bi ꞌñemba yá ma̱xte nꞌehe: ");
INSERT INTO otqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ngu gi pöhu̱, ho̱nse̱ yopa ꞌbe̱di da da̱tꞌa ar da̱ngo mbaxjwa. Nuya paꞌu̱ ma da nda̱ Nöꞌö Togo ba e bi Njöꞌi, da tsꞌu̱ta har pontꞌi, ne da tho. ");
INSERT INTO otqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nöꞌö ar paꞌö bi mönga njapꞌu̱ ar Hesu, nuya ndömöjö, ya bötꞌofo ne ya dönziandö bi mhuntsꞌa gatho hár thi ár ngu ar Kaifas nöꞌö mar döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mi hoñꞌu̱ hanja nda gu̱ ar Hesu ñꞌöntho, ne nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ho̱nse̱ mi eñꞌu̱: —Hinda tsa̱ ga ju̱hu̱ nuya pa nda̱ngo, ngetho da mbo̱ yá kwe̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Núꞌmu̱ mi ꞌbu̱ ar Hesu har hnini Betania, hár ngu ar Simu togo xki hye̱ ar hñeni tsitꞌandoꞌyo, ");
INSERT INTO otqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nꞌa mba epꞌu̱ nꞌar ꞌbe̱hñö mi hö nꞌar xito do, mi po nꞌar hogañu̱ni xa mar mhödi, ne bi xispa hár ñö ar Hesu núꞌmu̱ mi hu har mexa. ");
INSERT INTO otqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nu mi hyanda njapꞌu̱ yá ma̱xte, xa bi mbo̱ yá kwe̱, ne mi eñꞌu̱: —Yoꞌö xi tꞌe̱mpꞌu̱tho nunar hogañu̱ninu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xi ꞌba̱hmö ne xi tꞌunga nze̱ye̱ ar bojö xi themba ya hyoya. ");
INSERT INTO otqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ar Hesu bi ꞌyo̱ nöꞌö mi möñꞌu̱, ne bi ꞌñembabi: —Yoꞌö gi theñhu̱ nunar ꞌbe̱hñönu̱. Nza̱tho nöꞌö xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yo gi hyo̱ju̱ nöꞌö xi goxkagi. Ngetho nuya hyoya hyaxꞌmu̱ ma gi ꞌbu̱hwihu̱, ha nuga hinge hyaxtho ma gi hyandgagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nöꞌö ar hogañu̱ni xi goxkagi, ngu nꞌar ñhoki di to̱ꞌma ma ntꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Xa majöni di xiꞌahu̱, habu̱ gatho ma da nho̱nga nunar hoga mhö xo̱ge hár nxidi ar ximha̱i, ne da mhönga nöꞌö xi ꞌyo̱tnu̱ ngu nꞌar feni. ");
INSERT INTO otqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nepꞌu̱ nꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte már thuhu ar Huda, bi ma ba kꞌöꞌsa ya ndömöjö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ne bi ꞌñembabi: —Hangu gi ꞌraju̱ nuꞌmu̱ ga da̱tꞌahu̱ ha ri ꞌye̱hu̱ ar Hesu. Ne bi gohwi nꞌar nkohi, ha nuya ndömöjö bi umba nꞌa̱temaꞌre̱tꞌa ya tꞌaxbojö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nor paꞌö ar Huda bi ndu̱i mi honga hanja nda za̱ nda da̱twa ar Hesu ha yá ꞌye̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nöꞌö ar pa bi ndu̱ ar da̱ngo tsꞌi ya thuhme hingi jotsꞌi, yá ma̱xte bi watꞌa habu̱ mi ꞌbu̱ ar Hesu ne bi ꞌñembabi: —Habu̱ gi ne ga o̱the ar tꞌoximbaxjwa. ");
INSERT INTO otqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ar Hesu bi dödi ne bi ꞌñenö: —Di möhu̱ har hnini, ne xipabihu̱ nꞌar ñꞌo̱ho̱ ꞌbu̱hnu̱: Ba pe̱nkagihe ar Utate ga xiꞌahe njawa: Xi da̱tꞌa ar pa xi hñuska Jö, ne di ne ga tsiꞌbe ar tꞌoximbaxjwa ma ma̱xte ha ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ne nuyá ma̱xte bi ꞌyo̱tꞌa ngu xki ꞌbe̱pabi, bi ma ba hoka ar tꞌoximbaxjwa. ");
INSERT INTO otqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nu mi nxui ar Hesu bi hñu har mexa, ne nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte bi hñuhwi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Núꞌmu̱ mi ñuni bi ꞌñemba yá ma̱xte: —Xa majöni di xiꞌahu̱, nꞌa nuꞌu̱ gi huhu̱wa ma da da̱gagi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nuyá ma̱xte xa bi du yá mu̱i, ne nꞌa ngu nꞌa mi a̱mbabi: —Ma tsi Hmuꞌi, ha go geke. ");
INSERT INTO otqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ne ar Hesu bi ꞌñembabiꞌu̱: —Nöꞌö togo nꞌadar mohi di ñumꞌe, go ma da da̱gagi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Majöni, Nöꞌö Togo ba e bi Njöꞌi ꞌba̱ ar ꞌñu da tꞌo̱tꞌwa gatho nöꞌö mönga hár Tꞌofo Jö, ha hwëkate nöꞌö togo ma da da̱. Xiñhohmö hinxi zo̱kwa har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nuꞌmú̱ ar Huda nöꞌö togo ma nda da̱, bi ꞌya̱mba ar Hesu ne bi ꞌñembabi: —Utate, ha go geke. Ar Hesu bi döti ne bi ꞌñembabi: —Go xka mönse̱ go geꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Núꞌmu̱ mi ntꞌoxꞌu̱, ar Hesu bi gu̱ ar thuhme, bi ꞌya̱pa Jö nda jöpi. Bi heke, bi hembabi yá ma̱xte, ne bi ꞌñembabi: —Tsihu̱, gehnu̱ ma ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nepꞌu̱ bi gu̱xa ar tꞌe̱ni mi po ar tꞌafiꞌobxi, bi umba njamödi Jö, ne bi thokwa yá ma̱xte, bi ꞌñembabiꞌu̱: —Tsihu̱ gi gathohu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gehnu̱ ma ji da nhöꞌmi, ne da go ar ꞌraꞌyo nkohi. Njapꞌu̱ da njutꞌwa yá tsꞌoki nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nupya di xiꞌahu̱, hinga pengi ga tsipa ár tꞌafi ar ꞌba̱iꞌobxi nuya payu̱. Ma ga to̱ꞌmi ga tsiwihu̱ maꞌraꞌyo hár tsꞌu̱tꞌwi ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nu mi waꞌu̱ bi ntu nꞌar jöhñö, bi maꞌu̱ har tꞌo̱ho̱ Njömdo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Nunar nxuinu̱ gatho ma gi hye̱gase̱gihu̱, ngetho xi tꞌotꞌa har Tꞌofo: Ma ga ho ar ma̱ꞌyo, ne nuyá de̱ti ma da mfontꞌa gatho. ");
INSERT INTO otqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ha núꞌmu̱ xka pengi ga nte manꞌagi, ma ga ꞌbe̱tꞌo gar nthe̱hu̱nu̱ Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nuꞌmú̱ ar Pedro bi dödi ne bi ꞌñenö: —Mödi gatho nuꞌu̱ maꞌra da hye̱kꞌaꞌi, nuga hinga ma ga he̱kꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ar Hesu bi ꞌñembabi: —Xa majöni di xiꞌaꞌi, nunar nxuinu̱ hinxi mata ar boxi, ha nuꞌge xka ko̱ngagi hñuꞌgi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ar Pedro bi dödi ne bi ꞌñembabi: —Mödi ga tuga nꞌehe, hinga ko̱ñꞌaꞌi. Ne gatho nu maꞌra yá ma̱xte bi mönga njapꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ar Hesu bi zo̱ngwi yá ma̱xte habu̱ mar thuhu Getsemani, ne bi ꞌñembabiꞌu̱: —Hñuhu̱wa. Nuga ma ga ma nꞌa tsi tu̱i injanu̱, ma ga a̱pa Jö ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne bi zixa ar Pedro ne nuꞌu̱ yoho yá tꞌu̱ ar Sebedeo, bi ma tsi yapꞌu̱, ne ar Hesu bi mu̱di xa bi du ár mu̱inu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne bi ꞌñemba nuꞌu̱ hñu yá ma̱xte: —ꞌBu̱tho ga tu ar dumu̱i. Kohu̱wa, mahye̱gi ga a̱fu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne ar Hesu bi tho tsi tu̱i ár yapꞌu̱. Bi zohnu̱ yá ma̱xte, bi nda̱ndihmö, bi me̱ ár hmi har ha̱i, bi ꞌya̱pa Jö ár Dada ne bi ꞌñembabi: —Ma Dadaꞌi, nuꞌmu̱ da tsa̱hmö, da thota nunar tꞌe̱ni xi ꞌñepꞌu̱ ne hinda zu̱kagi. Mödi hindi ne gi ꞌyo̱tꞌa ngu di nega, ꞌyo̱tꞌa ngu gi nege. ");
INSERT INTO otqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mꞌe̱fa bi mengi ma ba kꞌöꞌsa nuꞌu̱ hñu yá ma̱xte, ne bi dini mi öꞌu̱, jange bi ꞌñemba ar Pedro: —Ha himi tsa̱ ngi tse̱thu̱ ngi fa̱xju̱ nga a̱fu̱ Jö nꞌa tsi xe̱nimpa. ");
INSERT INTO otqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Zo̱tꞌa ri da̱hu̱ ne ꞌya̱fu̱ Jö gi tse̱thu̱ ya tsꞌothogi xi ꞌñepꞌu̱. Xa majöni di xiꞌahu̱, nuna ri hñöhu̱ ꞌbu̱i da tse̱ti, ho̱nse̱ ri ndoꞌyohu̱ kꞌatꞌa ár tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ar Hesu bi menga manꞌagi habu̱ mi a̱pa Jö, ne bi ꞌñenga manꞌagi njawa: —Ma Dadaꞌi, nuꞌmu̱ da tsa̱hmö da thota nuya thogi ne hinda zu̱kagi, ho̱nse̱ ꞌyo̱tꞌa ngu gi nege. ");
INSERT INTO otqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ba pengi bi kꞌönga yá ma̱xte habu̱ xki zogi, ne bi dini mi öhö manꞌagi. Himi tsa̱ nda zo̱tꞌa yá da̱, ngetho xa mi kö ar tꞌöhö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nuꞌmú̱ ar Hesu bi zopꞌu̱ manꞌagi, ne bi ma ba a̱pa Jö ár Dada. Getꞌu̱ ya mhö xki mönga mꞌe̱tꞌo bi mengi bi xipabi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ba penga habu̱ xki zo nuꞌu̱ hñu yá ma̱xte, ne bi ꞌñembabiꞌu̱: —Nupya hö, te ri tꞌöhöhu̱ ne tsa̱ya̱hu̱ xiñho. Xi da̱tꞌa ar pa xi thuꞌspabi Nöꞌö Togo ba e bi Njöꞌi, ma da nda̱twa ha yá ꞌye̱ ya ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nanju̱ möhö, ba ehnu̱ nöꞌö togo ma da da̱gagi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Himi jwadi nda mönga njapꞌu̱ ar Hesu, mi zo̱ ar Huda, nꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, mi ñꞌowi nze̱ye̱ ya jöꞌi mi hö ya ndo̱jwai ne ya za. Nuya jöꞌi xki me̱hna ya ndömöjö ne ya dönziandö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ar Huda togo mi da̱ ar Hesu, xki nkohwiꞌu̱ ne xki ꞌñembabi: —Nöꞌö gi hyanthu̱ ga tsu̱ꞌspa ár hmi, gehnu̱ dama gi ju̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nuꞌmú̱ ar Huda dama ba tsu̱ ar Hesu, ne bi ꞌñembabi: —Xa̱ ar tsi te, Utate. Ne dama bi zu̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ar Hesu bi döti ne bi ꞌñembi: —Xiꞌge, te xka ꞌñeke ño̱. Ha nuya jöꞌi bi watꞌi bi gu̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngu mi nju̱ ar Hesu, nꞌa nuꞌu̱ mi ñꞌowiꞌö, bi kꞌosꞌa ar ndo̱jwai, ne bi dakwa ár gu nꞌár ꞌbe̱go ar döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nuꞌmú̱ ar Hesu bi ꞌñemba nöꞌö mi hö ar ndo̱jwai: —Kwata ri jwai, ngetho gatho nuꞌu̱ togo ju̱ ar jwai ñhote, ma da nju̱ ar jwai da thoꞌö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ha hinxka pöthu̱ da tsa̱ ga a̱pa ma Dada da me̱nka nꞌa mutꞌi ya e̱nxe̱, ne nöꞌö da ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nuꞌmu̱ ga japꞌu̱, hanja da tho ngu mönga har Tꞌofo ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nuꞌmú̱ ar Hesu bi ꞌñemba ya jöꞌi: —Hage dar bë xka ehu̱ gi mikagihu̱, gi höhu̱ ya jwai ne ya za. Hyaxꞌmu̱ ndi ꞌbu̱hnu̱ har dönganijö ndi utꞌahu̱, ne hinte ga jaju̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gathoyu̱ xi thogi, ne nda njapꞌu̱ ngu xki mönga yá mꞌe̱hni Jö har Tꞌofo. Nuꞌmú̱ gatho yá ma̱xte bi zohnu̱ bi mfontꞌi bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nuꞌu̱ togo xki gu̱ ar Hesu, bi zixa habu̱ mi ꞌbu̱ ar döngamöjö már thuhu Kaifas. Ka xki mhushnu̱ nꞌehe ya bötꞌofo ne ya dönziandö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ha nu ar Pedro mi ꞌbe̱fatho tsi yapꞌu̱ mi te̱nga ar Hesu. Mi zo̱nga hár thi ár ngu ar döngamöjö, ka bi hñuhwinu̱ ya ndogu, mi ne nda hyandi tema nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nuya ndömöjö, ya dönziandö ne gatho ár mhuntsꞌandö ya xodyo, mi honga ya nhemhñö te nda hyo̱xa ar Hesu, ne njapꞌu̱ nda tsa̱ nda tho. ");
INSERT INTO otqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ne hinte bi za̱ te bi thimbabi, mödi nze̱ye̱ ya jöꞌi mi ju̱spa ya nhemhñö. Ha mꞌe̱fa bi zo̱hnu̱ yoho ya nemhñö jöꞌi, ");
INSERT INTO otqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne bi ꞌñeñꞌu̱: —Nunar ñꞌo̱ho̱nu̱ bi ꞌñenö: Da tsa̱ ga yo̱tꞌwa ár nijö Jö, ne ár hñupa da tsa̱ ga pengi ga ju̱xa manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nuꞌmú̱ ar döngamöjö bi mꞌa̱i ne bi ꞌñemba ar Hesu: —Hage hinte gi thödi. Te di bo̱nga nuya tho̱xꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nunar Hesu hinte bi dödi. Nuꞌmú̱ ar döngamöjö bi ꞌñembabi: —Hár thuhu Jö nöꞌö te, xikagihe, hage go geꞌe ar Kristo ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nuꞌmú̱ ar Hesu bi döti ne bi ꞌñenö: —Hö, njapꞌu̱ ngu xka mö. Ne di xiꞌahu̱, nuya pa xi ꞌñepꞌu̱ ma gi hyanthu̱ Nöꞌö Togo ba e bi Njöꞌi da hñu hár ñꞌe̱i Jö togo jár tsꞌe̱di. Mꞌe̱fa ma gi hyanthu̱ da e ha ya gui. ");
INSERT INTO otqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nuꞌmú̱ ar döngamöjö bi xika yá he, ngetho mi beni ar Hesu xki ñömañꞌu̱bi Jö, ne bi ꞌñenö: —Xi zanga Jö. Te ga jafu̱ manꞌa te da hyo̱tsꞌe, go xka ꞌyo̱se̱hu̱ tema xi mö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Te gi möñhu̱. Ha nu maꞌra bi dödi ne bi ꞌñeñꞌu̱: —Nunu̱ di ꞌñepi da tho. ");
INSERT INTO otqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nuꞌmú̱ ꞌraꞌu̱ bi zospa ár hmi ne mi fe̱i, ne maꞌra mi umba ya mpe̱tgu. ");
INSERT INTO otqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ne mi embabi: —Gi enö gar Kristo, xije ꞌmu̱ togo bi me̱pꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ar Pedro mi huhnu̱ har thi, nꞌa mba epꞌu̱tho nꞌar nxutsi mi mꞌe̱go. Bi ma ba tsu̱di ne bi ꞌñembabi: —Nuꞌge nꞌe, ngi ñꞌowi ar Hesu ar me Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nu ar Pedro bi nko̱ni ha yá nthandi gatho ya jöꞌi ne bi ꞌñenö: —Hindi pöka te gi mönge. ");
INSERT INTO otqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nepꞌu̱ bi maꞌö har goxthi. Ne manꞌar nxutsi mi mꞌe̱go nꞌehe bi hyandi, ne bi ꞌñemba nuya jöꞌi mi ꞌbu̱hnu̱: —Nunar ñꞌo̱ho̱nu̱ mi ñꞌowi ar Hesu me Nasare nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ar Pedro bi mengi bi nko̱ni, bi ꞌñetꞌa Jö made ne bi ꞌñenö: —Hindi pöka nor ñꞌo̱ho̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hingar yaꞌö bi watꞌa nuya jöꞌi mi ꞌbu̱hnu̱, ne bi ꞌñemba ar Pedro: —Xa majöni ngi ñꞌowi nꞌehe, ngetho nhekitho hanja gi ñö. ");
INSERT INTO otqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nuꞌmú̱ ar Pedro bi ntsate, ne bi ꞌñetꞌa Jö made bi ꞌñenö: —Hindi pödi tema ñꞌo̱ho̱ gi no̱ñhu̱. Ne bi ma ꞌmu̱ ar boxi. ");
INSERT INTO otqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nuꞌmú̱ ar Pedro bi zo ár mfeni nöꞌö xki xipa ar Hesu núꞌmu̱ xki ꞌñembabi: Hinxi mata ar boxi, ha nuꞌge xka ko̱ngagi hñuꞌgi. Ne bi bo̱nga nthi, xa bi hyu̱ ár ñö bi nzoni. ");
INSERT INTO otqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nu ár hyaxꞌö ja mi hatsꞌi, gatho ya ndömöjö ne ya dönziandö bi nkoꞌu̱ nda hyo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne bi zixꞌu̱ xki nso̱tꞌe, ma ba da̱twa ha yá ꞌye̱ ar Ponsio Pilato togo mar ndö Nhudea. ");
INSERT INTO otqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ar Huda togo xki da̱ ar Hesu, mi hyandi xki tꞌe̱ntꞌi nda tho, xa bi du ár mu̱i nöꞌö xki ꞌyo̱tꞌe. Ne bi ntso̱ꞌmi, bi ma ba koꞌsa nuꞌu̱ nꞌa̱temaꞌre̱tꞌa ya tꞌaxbojö xki umba ya ndömöjö ne ya dönziandö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne bi ꞌñenö: —Nuga xta o̱tꞌa nꞌa ra döta tsꞌoki, ngetho xta da̱ da tho nꞌar ñꞌo̱ho̱ hinte tu. Ha nuꞌu̱ bi ꞌñeñꞌu̱: —Hindi pöje. Hyandge te gi pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nuꞌmú̱ ar Huda bi gu̱ bi fo̱ta ya bojö mbo har nijö, ne bi bo̱ni bi götꞌa ar xögu ár ꞌyu̱ga, ne bi ñhose̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nuya ndömöjö bi go ya bojö, ne bi ꞌñeñꞌu̱: —Nunar bojönu̱ hinda tsa̱ ga u̱thu̱ hár mꞌe̱sbojö ar nijö, ngetho ár njutꞌi ár ji nꞌar jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nepꞌu̱ bi nkoꞌu̱ nunar bojöꞌö, ma nda da̱nga nunar ha̱i ár thuhu ár Ha̱i ar Gö, ne nda ntꞌa̱hnu̱ ya nzo̱ho̱ jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jange gehnu̱ ár thuhu pe̱ꞌsa nuya payu̱, ár thuhu ar Ha̱iji. ");
INSERT INTO otqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Njapꞌu̱ bi tho ngu xki mönga ár mꞌe̱hni Jö ár thuhu Heremia núꞌmu̱ bi ꞌñenö: Bi nju̱ nöꞌö nꞌa̱temaꞌre̱tꞌa ya tꞌaxbojö, gehnu̱ ár nze̱ye̱ ar bojö xki thuꞌspa togo bi ꞌba̱, ngu xki hñuꞌspa ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne bi tꞌuni bi tha̱mba ár ha̱i ar gö, ngu xki ꞌbe̱pkagi ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ar Hesu mi ꞌba̱hnu̱ hár nthandi ar Pilato, togo mar ndö Nhudea, ne nunar ndönu̱ bi ꞌya̱mba nꞌar ntꞌa̱ni: —Ha go geꞌe ár Ndö ya xodyo. Ar Hesu bi dödi ne bi ꞌñenö: —Hö, ngu xka mönse̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nepꞌu̱ ya ndömöjö ne ya dönziandö xa te gatho mi ho̱tsꞌe, ha nöꞌö hinte bi dödi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nuꞌmú̱ ar Pilato bi ꞌñemba ar Hesu: —Ha hingi o̱de gatho nöꞌö tho̱xꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nunar Hesu hinte bi dötwabi, jange ar ndö xa mi ꞌyo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Xki nzönga ar ndö ta̱tꞌa je̱ye̱ har da̱ngo mbaxjwa nda hye̱ nꞌar ꞌyofa̱di, nöꞌö nda ꞌya̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nuya paꞌu̱ mi o ar fa̱di nꞌar ñꞌo̱ho̱ már thuhu Baraba. Gatho mi pödi tema jöꞌiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ne núꞌmu̱ mi mhuntsꞌa nze̱ye̱ ya jöꞌi, ar Pilato bi ꞌya̱mbabi ne bi ꞌñenö: —Togo gi ne ga he̱kꞌahu̱, ar Baraba wa ar Hesu tꞌembabi ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ar Pilato mi pödi xki ziꞌspabi ar Hesu nuya ndöxodyo, ngetho xki zo̱tꞌa yá mu̱i mi ꞌbe̱twa yá tsa̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Núꞌmu̱ mi huxa ar Pilato har thuxandö, ár ꞌbe̱hñö ba pe̱mpa nꞌar mhö, ne bi ꞌñembabi: Yo te gi ñꞌe̱ntꞌi gi japa nunar hogajöꞌinu̱, ngetho xa xi pikagi nꞌar tꞌi ar pania. ");
INSERT INTO otqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ha nuya ndömöjö ne ya dönziandö bi u̱tꞌa ya jöꞌi nda ꞌya̱di nda the̱ ar Baraba, ne nda tho ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nuꞌmú̱ ar Pilato bi ꞌya̱mba ya jöꞌi manꞌagi ne bi ꞌñembabi: —Nuya yohoyu̱, ndana gi nehu̱ ga he̱kꞌahu̱. Nuya jöꞌi bi dödi ne bi ꞌñenö: —Ar Baraba. ");
INSERT INTO otqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jange ar Pilato bi mengi bi ñꞌa̱ni ne bi ꞌñenö: —Xiꞌmu̱, teme ga japa nunar Hesu tꞌembabi ar Kristo. Gatho bi döꞌu̱ bi ꞌñenö: —Tsu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nuꞌmú̱ ar Pilato bi ꞌñembabiꞌu̱: —Tema tsꞌoki xi ꞌyo̱tnu̱. Ha nuꞌu̱ xa bi ga̱hni bi mafi mi eñꞌu̱: —Tsu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nu mi hyanda ar Pilato hinte mi tsa̱ te nda me̱fi, ho̱nse̱ mi fu̱di nda mu̱xma ya jöꞌi, bi ꞌya̱di nda thömpa nꞌa tu̱i ar dehe, ne bi nxu̱ꞌye̱ ha yá nthandi ya jöꞌi, bi ꞌñenö: —Hingo ma ga tuꞌspa ár ji ma da nhöꞌmba nunar ñꞌo̱ho̱nu̱. Hyanthu̱ te gi pe̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Gatho ya jöꞌi bi dödi ne bi ꞌñeñꞌu̱: —Nuje ne ma bötsihe go ma ga tusfe ár ji ma da nxani. ");
INSERT INTO otqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nuꞌmú̱ ar Pilato bi hye̱ ar Baraba. Ha nunar Hesu bi japi nda nꞌwe̱xtꞌi, ne bi ꞌye̱ntꞌwa ha yá ꞌye̱ ya ndogu nda tsu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nuꞌmú̱ ya ndogu bi zixa ar Hesu habu̱ mi ꞌbu̱ ar döta tsꞌu̱tꞌwi, ne nunu̱ xa ba kotꞌatho nꞌa mutꞌi ya ndogu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne nuꞌu̱ bi mo̱kwa yá he, ne bi göꞌspa nꞌar the̱nga dutu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bi hñuꞌspabi hár ñö nꞌa ntsantꞌi ya ꞌmini xki mꞌe, ne bi tꞌe̱ntꞌwa hár ñꞌe̱i nꞌar tsꞌu̱tꞌo. Bi nda̱ndihmö hár nthandiꞌö, ne mi o̱tꞌwa ar thede mi embabiꞌu̱: —Xa̱r tsi te, ár Ndöꞌi ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mi tsoxꞌu̱, ne mi hömba ar tꞌo mi fe̱mba ár ñö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nu mi wadi bi ꞌyo̱tꞌwa ar thede, bi thökwa ar dutu, ne bi mengi bi thetwa ár he, ne bi tsꞌixa habu̱ ma nda tsꞌu̱ta har pontꞌi, ka nda dunu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nu mi bo̱ñꞌu̱ bi nthe̱winu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Simu, mar me Sirene. Nunar ñꞌo̱ho̱nu̱ bi njapi bi duxa ar pontꞌi habu̱ ma nda tsꞌu̱ta ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ne mi zo̱nga habu̱ már thuhu Golgota, di bo̱ni da ꞌñenö, Nñöxhmundoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ka ba tꞌumbabinu̱ ar ixkatꞌafi mi nthöskwi nꞌar bopo xi nju, ne nu mi za̱, himbi ne bi zi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nuya ndogu mi wadi bi tsu̱ta ar Hesu har pontꞌi, bi ñheꞌu̱ yá dutu bi ꞌye̱ntsꞌa ar nthöhö. Ne bi thogi ngu xki mönga ár mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö: Bi hega ma dutu, ne bi ꞌye̱ntsꞌa ar nthöhö, ne njapꞌu̱ nda böꞌu̱ togo nda hñöska ma he. ");
INSERT INTO otqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ne ka bi hñuhnu̱ꞌu̱ bi su ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne bi thuta nꞌar xithe̱ har pontꞌi mañö ár ñö, mi mö yoꞌö xki tsꞌu̱ti, mi enö njawa: Gehnu̱ ar Hesu, ár Ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bi tsꞌu̱ta yoho ya bë habu̱ bi tsꞌu̱ta ar Hesu nꞌehe, nꞌa mi zu̱ hár ñꞌe̱i, ha nöꞌö manꞌa hár ngöhö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ne nuꞌu̱ mi thohnu̱ xa mi theni ne mi hwötyá ñö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Mi embabiꞌu̱: —Nuꞌge xka mö gi yo̱tꞌa ar dönganijö, ne ár hñupa gi pengi gi ju̱tsꞌi, mpo̱se̱ xö, kö har pontꞌi nuꞌmu̱ xa majöni ár Tꞌu̱ꞌi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nuya ndömöjö, ya bötꞌofo, ya de̱ngaꞌbe̱pate ne ya dönziandö mi ñömañꞌu̱bi ar Hesu nꞌehe, mi eñꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Bi po̱ maꞌra, ha hingi tsa̱ da mpo̱se̱. Nuꞌmu̱ go gehnu̱ ár Ndö ya me Israel, dá göpya har pontꞌi ne ga ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jamfi Jönu̱ ꞌnö. Dá ma̱xꞌö ꞌmu̱, nuꞌmu̱ xa majöni mödi. Ha hinxi mönse̱ gehnu̱ ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nuya bë xki tsꞌu̱ta mahye̱gi, mi njapꞌu̱ mi o̱tꞌwa ar thede nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ngu made mpa bi ndu̱i bi mꞌe̱xui xo̱ge ar ximha̱i, ne bi göxa ngu ar hñu nde. ");
INSERT INTO otqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Núꞌmu̱ ma nda zu̱ ar hñu nde, ar Hesu bi ñö ntsꞌe̱di ne bi ꞌñenö: —Eli, Eli, lama sabaktani. Di bo̱ni da ꞌñenö: Ma tsi Dada, ma tsi Dadaꞌi, yoꞌö xka hye̱gase̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ꞌRa nuꞌu̱ mi ꞌbu̱hnu̱ bi ꞌyo̱de ne bi ꞌñeñꞌu̱: —Nunar ñꞌo̱ho̱nu̱ matꞌa ar mꞌe̱hni Elia. ");
INSERT INTO otqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nꞌaꞌu̱ dama bi nixtꞌi ba hö nꞌar xiꞌyo ne bi pobo har ixkatꞌafi, bi tuta ha nꞌar xithi, ne bi kwatwa hár ne. ");
INSERT INTO otqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ha maꞌra mi eñꞌu̱: —Hye̱hu̱pꞌu̱, ma ga nuhu̱ ha da ꞌñepꞌu̱ ar Elia da ma̱tsꞌi da kꞌontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ar Hesu bi mengi bi ñö ntsꞌe̱di manꞌagi, bi da̱ ár hñö ne bi du. ");
INSERT INTO otqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Geꞌmu̱ bi xi ar dutu mi naxa mbo ar dönganijö, bi ndu̱ mañö di göxa ha̱i ár nse̱gi. Ne bi nja nꞌa ra döta nhwöni, ne ya ndo̱do bi hege. ");
INSERT INTO otqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bi xo ya tꞌa̱gi, ne nze̱ye̱ ya hogajöꞌi xki du mꞌe̱tꞌo bi mengi bi nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bi bo̱ñꞌu̱ ha yá tꞌa̱gi, ne mi mengi bi nte manꞌagi ar Hesu, bi yu̱tꞌu̱ har hnini Herusalen, ne bi hyanda nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nöꞌö ar döndogu ne yá mindoguwi mi su ar Hesu, mi hyantꞌu̱ bi nhwönga ar ha̱i ne gatho nuya xki thogi, xa bi zuꞌu̱ ne bi ꞌñeñꞌu̱: —Xa majöni nunar ñꞌo̱ho̱nu̱ már Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yapꞌu̱tho mi ꞌba̱hnu̱ nze̱ye̱ ya ꞌbe̱hñö, mi handa gatho nöꞌö mi thogi, gehyu̱ nuꞌu̱ ba te̱nga ar Hesu har ha̱i Ngalilea mi fa̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ꞌRaꞌu̱ mar Maria me Magdala, ar Maria ár nönö ar Hakobo ne ar Huse, ne ár nönö nuꞌu̱ yoho yá tꞌu̱ ar Sebedeo. ");
INSERT INTO otqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Núꞌmu̱ ꞌbu̱tho nda yu̱ ar hyadi, ba ehnu̱ nꞌar ñꞌo̱ho̱ mi te̱nga ar Hesu, már thuhu ar Huse me Arimatea, mi the̱ ya ñho. ");
INSERT INTO otqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Bi ma ba a̱pa ar Pilato nda umba ár ndoꞌyo ar Hesu. Nuꞌmú̱ ar Pilato bi mö nda tꞌumbabi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ar Huse bi ma ba hömpa ár ndoꞌyo ar Hesu, ne bi ma̱xa ha nꞌar tꞌaxdutu. ");
INSERT INTO otqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ne bi ma ba a̱ ha nꞌar ꞌraꞌyo tꞌa̱gi, habu̱ ma nda tꞌa̱se̱ꞌö, xki nsa̱ꞌma ha nꞌar ndo̱do. Nepꞌu̱ bi tönga nꞌa ra döta do, bi gota ar tꞌa̱gi, ne bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Getnu̱, mi huhnu̱ mi ñhandwi ar tꞌa̱gi ar Maria me Magdala ne nöꞌö manꞌar Maria. ");
INSERT INTO otqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ár hyaxꞌö, nu xki tho ár pa ñhoki, bi ma ya ndömöjö ne ya de̱ngaꞌbe̱pate, ma ba kꞌöꞌsa ar Pilato, ");
INSERT INTO otqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ne bi ꞌñembabi: —Ma ndöꞌahe, da beñhe nunar hya̱te ñꞌo̱ho̱ núꞌmu̱ mi tetho, bi ꞌñenö ár hñupa nda mengi nda nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jange di nehe gi pe̱hna togo ma da su ar tꞌa̱gi hñupa, yo ma da e yá ma̱xte da bë, ne da ꞌñeñꞌu̱ xi mengi xi nte. Ne nunar nhemhñöꞌö da döta nöꞌö xi mhönga mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bi dö ar Pilato ne bi ꞌñenö: —Xi ꞌbu̱hnu̱ ꞌra ya ndogu, tsixu̱ ne suhu̱ xiñho ngu gi möñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nuꞌmú̱ nuya ndömöjö ne ya de̱ngaꞌbe̱pate bi maꞌu̱ ma ba thötꞌa ar do mi kotꞌa ar tꞌa̱gi, ne bi zohnu̱ ya ndogu nda su. ");
INSERT INTO otqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nu mi tho ar pa ntsa̱ya̱, ja mi fu̱di nda hatsꞌi ár ꞌbe̱tꞌo mpa manꞌa hñöto, ar Maria me Magdala ne manꞌa ar Maria ba e bi kꞌönga ar tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nuꞌmú̱, bi nja nꞌa ra döta nhwöni, ngetho ba kö nꞌar e̱nxe̱ mhetsꞌi. Ne mi zo̱hnu̱ habu̱ mi tꞌa̱ ar Hesu, bi hñöka nunar do mi kotꞌa ar tꞌa̱gi, ne ka bi hñuxhnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nunár ꞌba̱i ar e̱nxe̱ xa mi yotꞌa ngu nꞌar hwe̱i, ne nuyá he mar ntꞌaxi ngu nꞌar tꞌaxtse̱. ");
INSERT INTO otqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nu mi hyanda ya ndogu xa bi zuꞌu̱, ne bi gohnu̱ to da ꞌñenö xki du. ");
INSERT INTO otqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ha nunar e̱nxe̱ bi zo nuya ꞌbe̱hñö, ne bi ꞌñembabi: —Yo gi ntsuhu̱. Di pödi gi hoñhu̱ ar Hesu togo bi du har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hinjoꞌowa, bi mengi bi nte ngu bi möñꞌö. Ba e gi hyanthu̱ habu̱ bi ꞌbe̱ ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ngutꞌa di möhu̱, ba xifu̱ yá ma̱xte xi mengi xi nte. Ne nupya xi mꞌe̱tꞌo di ma Ngalilea, ka ma gi hyanthu̱nu̱ manꞌagi. Gehnu̱ xta e ga xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nuꞌmú̱ nuꞌu̱ yoho ya Maria, xa mi johya ne mi ntsu, bi nixtꞌi ma ba xipa nunar mhönu̱ yá ma̱xte ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne nu mi paꞌu̱ har ꞌñu, nꞌa mbi da̱ñꞌu̱ ar Hesu bi bo̱ni bi nthe̱wi, ne bi ze̱ngwa bi ꞌñembabi: —Xa̱ ar tsi te. Nuꞌmú̱ nuya ꞌbe̱hñö bi watꞌi bi hyu̱pa yá wa, ne bi nsundabi. ");
INSERT INTO otqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ne ar Hesu bi ꞌñembabiꞌu̱: —Yo gi ntsuhu̱. Di möhu̱ ba xifu̱ ma ku da maꞌu̱ Ngalilea, ka ga nthe̱ꞌbenu̱ manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nu mi ꞌyo ar ꞌñu ya ꞌbe̱hñö, bi ma ꞌra ya ndogu mi su ar tꞌa̱gi har hnini, ma ba xipa ya ndömöjö gatho nöꞌö xki thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nuya ndömöjö bi ñöwi ya dönziandö, ne bi nkoꞌu̱ nda umba nze̱ye̱ ya bojö ya ndogu nda goꞌmnda nöꞌö xki thogi. ");
INSERT INTO otqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ne bi ꞌñembabiꞌu̱: —Nuꞌahu̱ ma gi möñhu̱, mi nxui bi zu̱ꞌahu̱ ar tꞌöhö, ne geꞌmu̱ bi zo̱ yá ma̱xte, bi bëpa ár ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne nuꞌmu̱ ar ndö da bödi teme bi thogi, yo gi tu ri mu̱ihu̱, ngetho nuje ga ñöhe hinte da njaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ne nuya ndogu bi hñönga ar bojö, ne bi maꞌu̱ bi ꞌyo̱tꞌa ngu xki nsipabi. Jange gehnu̱ ar mfeni no̱nga ya xodyo nuya payu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nuya ꞌre̱tꞌamanꞌa yá ma̱xte bi ma Ngalilea har tꞌo̱ho̱ habu̱ xki xipabi ar Hesu nda nthe̱wi. ");
INSERT INTO otqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nu mi hyantꞌu̱, bi nsundabi, mödi ꞌra himi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ar Hesu bi watꞌi ne bi ꞌñembabiꞌu̱: —Gatho ar tsꞌu̱tꞌwi xi tꞌe̱ntka ha ma ꞌye̱ núnu̱ mhetsꞌi ne nuwa har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jange di möhu̱ ba zohu̱ ya jöꞌi xo̱ge ár nxidi ar ximha̱i. Uthu̱ da de̱ngagiꞌu̱ nꞌehe, ne xixthehu̱ hár thuhu ar Dada, ar Tꞌu̱ ne ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ne utwabihu̱ da ꞌyo̱tꞌa gatho ngu nöꞌö xta ꞌbe̱pꞌahu̱. Ne nuga hyaxꞌmu̱ ga ꞌbu̱hwihu̱ gatho ya pa di ꞌbu̱ta ar ximha̱i. Dá njapꞌu̱.");
INSERT INTO otqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ár ndu̱i ár hoga mhö ar Hesukristo ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngu bi ꞌyotꞌa ar mꞌe̱hni Isaia: Hyandi di pe̱hna ma mꞌe̱hni da mꞌe̱tꞌo habu̱ gi pa, da mꞌe̱tꞌo da hyokꞌa ar ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ár mhafi nꞌa togo enga har otꞌatꞌo̱ho̱: Hyojwu̱ ár ꞌñu ar tsi Hmu; jömfu̱ habu̱ da thogi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ar Xuwa mi xixthe ya jöꞌi har otꞌatꞌo̱ho̱, ne mi xipabi ar hoga mhö, ne nuyu̱ nda ꞌyo̱tꞌwa yá ntso̱ꞌmi ne nda mpumbabi yá tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne mi po̱nga ya jöꞌi mi e nda zu̱ ar Xuwa, gatho nuꞌu̱ mi ꞌbu̱ har hnini Herusalen ne nuꞌu̱ maꞌra ya hnini har ha̱i Nhudea, mi da̱majöni yá tsꞌoki, ne mi xixtheꞌö har döthe Hordan. ");
INSERT INTO otqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ar Xuwa mi hö nꞌar he xki nju̱mpa ár xi nꞌar me̱ti ár thuhu kameyo ne xki mꞌe, ne mi ngu̱tꞌa nꞌar ximhni, ha mi tsi ya ma̱ngakꞌoto ne ar tꞌafi mi tꞌinga har tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ne mi mönga ar hoga mhö mi enö: —ꞌBe̱fa nꞌa xa tökagi ár tsꞌe̱di, hindi ꞌñepkagi ga xotꞌwatsꞌu̱ ár thiza. ");
INSERT INTO otqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nuga xta xixtheꞌihu̱ har dehe, ha nöꞌö ma da xixtheꞌihu̱ hár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nuya paꞌu̱ ba e ar Hesu ba po̱nga har hnini Nasare har ha̱i Ngalilea, ne bi xixthe ar Xuwa har döthe Hordan. ");
INSERT INTO otqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nepꞌu̱ mi bo̱nga har dehe, bi hyandi bi xo mhetsꞌi, ne ár Hñö Jö ngu nꞌar domtxu ba köi bi zu̱di. ");
INSERT INTO otqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne bi nheki nꞌar mhö ndi ꞌñe mhetsꞌi mi enö: —Go ma hmöka Tꞌu̱ꞌi, gi jakagi ga njohya. ");
INSERT INTO otqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mꞌe̱fa ár Hñö Jö bi zixa ar Hesu har otꞌatꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ne ba ꞌbu̱hnu̱ yonꞌa̱te mpa, har tsꞌondöhi mi tsa̱tnu̱. Ba ꞌbu̱ madeda ya zuꞌwe, ha nuyá e̱nxe̱ Jö mi pe̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Núꞌmu̱ mi njotꞌa ar Xuwa har fa̱di, ar Hesu bi menga Ngalilea mi mömba ár hoga tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mi enö njawa: —Xi zo̱ ar pa xki mhö, ne ár tsꞌu̱tꞌwi Jö ꞌba̱pꞌu̱tho. ꞌYo̱thwu̱ ár ntso̱ꞌmi, ne ñꞌemu̱ihu̱ ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mi ka̱ta hár ñöni ar ñho̱nthe Ngalilea, ne bi hyanda ar Simu ne ar Andre ár jödöpꞌu̱, mi kötꞌa yá ntꞌa̱tsꞌi har dehe, ngetho ma ya ngu̱xhwö. ");
INSERT INTO otqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne ar Hesu bi ꞌñembabiꞌu̱: —Ba e gi te̱ngagihu̱, ne ga exꞌahu̱ gi ju̱xu̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dama bi zopꞌu̱ yá ntꞌa̱tsꞌiꞌu̱ bi de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bi ñꞌo manꞌa tsi tu̱i ar Hesu, ne bi hyanda ar Hakobo ne ar Xuwa ár jödöpꞌu̱ꞌö, yá tꞌu̱ ar Sebedeo. Nuyu̱ mi to̱hnu̱ har motsa mi po̱tꞌa yá ntꞌa̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dama bi zohni, ne nuyu̱ bi zopꞌu̱ ar Sebedeo yá dadaꞌu̱, mi to̱hwi yá ꞌbe̱go har motsa, ne bi de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bi zo̱ñꞌu̱ har hnini Nkapernaum, ne ar pa ntsa̱ya̱ bi yu̱tꞌa ar Hesu ha yá nijö ya xodyo mi uti. ");
INSERT INTO otqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nuꞌu̱ togo mi o̱tsꞌe mi ꞌyo̱da ár ntꞌuti, ngetho mi ñö ngu nꞌa pe̱ꞌsa ár tsꞌe̱di, hinge ngu nuya bötꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ha mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ ha yá nijöꞌu̱ mi nthe̱xkwi nꞌar tsꞌondöhi, nꞌa mbi hye̱xta nꞌar mhafi, ");
INSERT INTO otqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bi ꞌñenö: —Tema gi pe̱kwa, Hesu me Nasare. Hage xka e gi hwatkagihe. Di pödi togoꞌi, ár hoga Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nunar Hesu bi zu̱i ne bi ꞌñembabi: —Kotꞌa ri ne, ne po̱ni hye̱ nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ha nunar tsꞌondöhi bi hwöꞌsa nunar ñꞌo̱ho̱, ne bi hye̱xa nꞌar mhafi bi bo̱ni bi zopꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gatho xa mi ꞌyo̱tho, ne mi ñöxhnatho mi eñꞌu̱: —Ter me̱hnu̱pya. Tema ꞌraꞌyo ntꞌutinu̱ ꞌmu̱. Pe̱ꞌsa ar tsꞌe̱di ꞌbe̱pa ya tsꞌondöhi, ne nuyu̱ o̱te. ");
INSERT INTO otqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ne ngutꞌa bi nu̱nga ár ꞌbede xo̱ge hár nthetꞌi ar ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mi bo̱nga hár nijöꞌu̱, bi ma hár ngu ar Simu ne ar Andre, bi me̱wi ar Hakobo ne ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ha nunár to ar Simu mi ꞌbe̱nu̱ mi the̱ ar mpatꞌi, ne ngutꞌa bi nsipabi ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nuꞌmú̱ bi watꞌi bi mipa ár ꞌye̱ bi gu̱tsꞌi, ne dama bi hñöka ár mpatꞌi, ne bi nangi mi umbabi te nda ziꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mi taknde, ja xki yu̱ ar hyadi, ba tsꞌimpa gatho ya da̱thi ne nuꞌu̱ mi nthe̱xkwi ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gatho ya mengunu̱ xa mi ñꞌentꞌi bi watꞌa har goxthi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ne bi o̱the nze̱ye̱ tsa̱ntꞌö ar hñeni mi pe̱tsꞌi, ne bi ꞌye̱nga nze̱ye̱ ya tsꞌondöhi, ne himi he̱gi nda ñö, ngetho mi pöꞌu̱ togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ár hyaxꞌö ar Hesu bi nanga nꞌitho núꞌmu̱ mi nxuitho, bi ma ba a̱pa Jö ha nꞌar ha̱i hinto mi ꞌbu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ar Simu ne nu maꞌra mi ñꞌowi, bi ma ba honi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ne mi dini bi ꞌñembabi: —Gatho ya jöꞌi hoñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nöꞌö bi ꞌñembabiꞌu̱: —Möhö ma ga tso̱ñhu̱ maꞌra ya hnini ha ya nthetꞌi, ga xipabiꞌu̱ ar hoga mhö nꞌehe, ngetho geꞌö xta ehe. ");
INSERT INTO otqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne bi ñꞌo xo̱ge Ngalilea, mi ku̱tꞌa ha yá nijö, mi mönga ar hoga mhö ne mi e̱nga ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ba e nꞌar ñꞌo̱ho̱ mi tsu̱ ar tsitꞌandoꞌyo, bi nda̱ndihmö ne mi a̱pa ar möte mi embi: —Nuꞌmu̱ gi ne, da tsa̱ gi o̱thegi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ne ar Hesu bi ko ár nhwëki, bi maka ár ꞌye̱ bi hñuꞌspabi, ne bi ꞌñembi: —Hö, di ne ga o̱theꞌi. Dá dixꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nu mi mönga njapꞌu̱, nu ar tsitꞌandoꞌyo dama bi hye̱gi, ne bi ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nuꞌmú̱ xa mi pe̱mbabi, ne bi me̱hni nda ma. ");
INSERT INTO otqNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ne bi ꞌñembabi: —Ha gi o̱de, hinto ma gi xipabi. Ho̱nse̱ di ma ba ñꞌudi da hyantꞌa ar möjö. Ne gi hñöxa ar mꞌo̱ñho̱, gi jutꞌa ri ntꞌaxki ngu bi mönga ar Moise, njapꞌu̱ da böꞌu̱ xi dixꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ha nu mi maꞌö, xa to gatho mi xipabi, ne bi ꞌyonga ar ꞌbede nöꞌö tema xki thogi. Jange ar Hesu himi tsa̱ nda yu̱tꞌa har hnini xiñho. Mi kota ha ya ha̱i hinto mi ꞌbu̱i, ne ka mi panu̱ ya jöꞌi ma nda zu̱di. Nuya jöꞌiyu̱ hagatho ya ha̱i mi ehe. ");
INSERT INTO otqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xki tho ꞌra ya tsi pa, ne ar Hesu bi yu̱tꞌa manꞌagi har hnini Nkapernaum, ne bi födi mi ꞌbu̱hnu̱ har ngu. ");
INSERT INTO otqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ne dama bi watꞌa nze̱ye̱ ya jöꞌi. Himi tsu̱di nda yu̱tꞌa har ngu, mödi nda mꞌa̱ta har goxthi, ne nunu̱ mi xipabi ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nuꞌmú̱ ba e ꞌra ya ñꞌo̱ho̱ mi honi, mi tsi nꞌar ñꞌo̱ho̱ xki nza ár ndoꞌyo, mi nju̱nga goho mi mutsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nuya jöꞌi xa mi nze̱ye̱, himi tsa̱ nda yu̱tꞌi. Jange bi xosꞌu̱ nꞌa xe̱ni ár mꞌetꞌe ar ngu, ne ka bi göꞌmnu̱ har oki nunar fidi mi oxa ar ñꞌo̱ho̱ xki nza ár ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ar Hesu mi hyandwa yá jamfi nuꞌu̱ togo mi tsihi, bi ꞌñemba ar ñꞌo̱ho̱ xki nza ár ndoꞌyo: —Ndada, xi mpumpꞌa ri tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mi ꞌbu̱hnu̱ ꞌra ya bötꞌofo, mi ꞌyo̱xa njapꞌu̱ mi ense̱ ha yá mfeni: ");
INSERT INTO otqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Yoꞌö ñö njapꞌu̱nu̱. Tsꞌokwa Jö. Hinjoꞌo manꞌa tsa̱ da pungya tsꞌoki, ho̱nse̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ar Hesu mi pötwatho yá mfeni ne te gatho mi beñꞌu̱, jange bi ꞌñembabi: —Yoꞌö te gatho gi benthu̱ ha ri mfenihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Temar ñhembi ga embabi nunar ñꞌo̱ho̱nu̱ xi nza ár ndoꞌyo: Xi mpumpꞌa ri tsꞌoki, wa ga embabi: Nangi, ju̱xa ri fidi, di ma. ");
INSERT INTO otqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pöhu̱pya, Nöꞌö Togo ba e bi Njöꞌi pe̱ꞌskwa ar tsꞌe̱di har ximha̱i da pungya tsꞌoki, nuhu̱ teme ma ga pe̱fi. Ne bi ꞌñemba nöꞌö togo xki nza ár ndoꞌyo: ");
INSERT INTO otqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Nuꞌge di xiꞌaꞌi: Nangi, ju̱xa ri fidi, di ma ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nuꞌmú̱ nöꞌö dama bi gu̱xa ár fidi, bi thota madeda ya jöꞌi bi ma. Gatho xa mi ꞌyo̱tho mi nsundabi Jö mi eñꞌu̱: —Hiñhamꞌu̱ xta hanthu̱ nꞌar ntꞌudi njanu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mꞌe̱fa ar Hesu bi mengi bi ma har ñönthe, ha nuya jöꞌi mi e nda zu̱di, ne nöꞌö mi uti. ");
INSERT INTO otqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Núꞌmu̱ mi thohnu̱, bi hyanda ar Lebi ár tꞌu̱ ar Alfeo, mi huxnu̱ habu̱ mi njutꞌa ar bojö mi jotꞌa ya ndö, ne bi ꞌñembabi: —Ba ehe te̱ngagi. Ha nöꞌö bi nangi bi de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mꞌe̱fa ar Hesu bi ma hár ngu ne bi hñu har mexa. Bi watꞌa nze̱ye̱ ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki, mi huhwi ar Hesu mahye̱giwi yá ma̱xte, ngetho mi ja nze̱ye̱ togo xki de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ha nuya bötꞌofo ne ya de̱ngaꞌbe̱pate, mi hyandi mi ñungwi ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki, bi ꞌñemba yá ma̱xte: —Tema di bo̱mpyanu̱, ñungwi ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ar Hesu mi ꞌyo̱ njapꞌu̱, bi ꞌñembabiꞌu̱: —Nuꞌu̱ ꞌyomañho hingi honga togo da o̱the, ha nuꞌu̱ hñeni hö, hoñꞌu̱. Hinxta e ga zo ya hogajöꞌi, xta e ga zo ya ꞌyo̱tꞌatsꞌoki da ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nuyá ma̱xte ar Xuwa Xixthe ne yá ma̱xte ya de̱ngaꞌbe̱pate, xki nzöi mi bëꞌu̱. Jange nꞌagi ba e ꞌra, bi ꞌya̱mba ar Hesu: —Yoꞌö yá ma̱xte ar Xuwa Xixthe ne yá ma̱xte ya de̱ngaꞌbe̱pate bëhë, ha nuya ri ma̱xte hingi bëhyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ar Hesu bi ꞌñembabi: —Hage tsa̱ da bë nuꞌu̱ togo xi tsꞌohna ha nꞌar ngo ne huhwi nöꞌö togo xi nthöti. Hingi tsa̱ da bëhyu̱, ngetho ꞌbu̱hwi togo xi nthöti. ");
INSERT INTO otqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Xta zo̱hmö ya pa da tsꞌimbabi; nuꞌmú̱ hö, xi inda nehmö, da bëhyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hinjoꞌo togo ju̱ nꞌar ꞌraꞌyo mꞌo̱tꞌe po̱ta nꞌar ze̱ dutu. Ngetho nu xta yu̱tꞌa ar ꞌraꞌyo mꞌo̱tꞌe, da gu̱tꞌa ar ze̱ dutu ne da xe̱ döta xe̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hinto xitꞌa ar ꞌraꞌyo tꞌafi ha ya ze̱ ximhni. Ngetho nuꞌmu̱ da japꞌu̱, nunar ꞌraꞌyo tꞌafi da xe̱ka ya ze̱ ximhni, ar tꞌafi da nöꞌmi ne da mꞌe̱ ya ximhni. Jange ar ꞌraꞌyo tꞌafi nsitꞌa ha ya ꞌraꞌyo ximhni. ");
INSERT INTO otqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nꞌar pa ntsa̱ya̱ ar Hesu bi tho ha ya hwöhi. Nuyá ma̱xte núꞌmu̱ mi thohnu̱, bi ndu̱i bi dokwa yá ngöhö ya tꞌe̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nuꞌmú̱ nuya de̱ngaꞌbe̱pate bi ꞌñembabi ar Hesu: —Ndimhö, yoꞌö pe̱hyu̱ nöꞌö hingi ho da me̱ har pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nöꞌö bi ꞌñembabiꞌu̱: —Ha hinxka nehu̱ nöꞌö bi me̱ ar Dabi núꞌmu̱ mi the ar ñhuni, ne bi zu̱hwi ar thuhu gatho nuꞌu̱ mi ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Bi yu̱tꞌa hár nijö Jö núꞌmu̱ mar döngamöjö ar Abiatar, ne bi zi ya thuhme xki ꞌbo̱ꞌspa Jö, nöꞌö hingi ho to gatho da zi, ho̱nse̱ ya möjö. Ne himbi zise̱ꞌö, bi hyemba yá ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne ar Hesu bi ꞌñembabiꞌu̱ nꞌehe: —Nunar pa ntsa̱ya̱ bi thoki ngetho mi honga ar ñꞌo̱ho̱, hinge ar ñꞌo̱ho̱ bi thoki ngeꞌö mi honga ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jange Nöꞌö Togo ba e bi Njöꞌi, gehnu̱ ár Hmu ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Manꞌagi ar Hesu bi yu̱tꞌa ha yá nijö ya xodyo, ne mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ xki ꞌyotꞌa nꞌár ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ne nuya jöꞌi mi öthó, mi ne nda hyandi ha nda o̱the nunar da̱thi har pa ntsa̱ya̱, ne nda dini te nda hyo̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nuꞌmú̱ nöꞌö bi ꞌñemba ar ñꞌo̱ho̱ xki ꞌyotꞌa ár ꞌye̱: —Nangi, ꞌba̱ madetho. ");
INSERT INTO otqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne bi ꞌya̱mba nuꞌu̱ mi ꞌbu̱hnu̱: —Teme xiñho da tꞌo̱tꞌa har pa ntsa̱ya̱, ar ñho wa ar tsꞌomꞌu̱i. Ha da tꞌo̱the nꞌar da̱thi, wa da the̱gi da du. Gatho bi ñhetho. ");
INSERT INTO otqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nuꞌmú̱ nöꞌö bi mbo̱ ár kwe̱ bi ñhanda hár nthetꞌi, bi du ár mu̱i ngetho xa mi kotyá mu̱i, ne bi ꞌñemba nunar ñꞌo̱ho̱: —Maka ri ꞌye̱. Nöꞌö bi maki, ne dama bi ditsꞌi bi mꞌu̱i xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nu mi bo̱nga ya de̱ngaꞌbe̱pate, bi ñꞌu̱tꞌwi yá ñꞌohu̱ ar Erode hanja nda tsa̱ nda hyoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ha nu ar Hesu bi me̱wi yá ma̱xte hár ñöni ar ñho̱nthe. Ne bi de̱nga nze̱ye̱ ya jöꞌi, ya me Ngalilea, ya me Nhudea, ");
INSERT INTO otqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ya me Herusalen, ya me Idumea, nuꞌu̱ mi ꞌbu̱ ꞌrandi ar döthe Hordan, ne nuꞌu̱ mi ꞌbu̱ hár nthetꞌi ar hnini Tiro ne ar Sidon. Xki zo yá guꞌu̱ mi o̱tꞌa ya döta ntꞌudi, nze̱ye̱yu̱ ma ba kꞌöni. ");
INSERT INTO otqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ar Hesu bi ꞌñemba yá ma̱xte nda ñhokꞌu̱ di pe̱ꞌsa nꞌar motsa núꞌmu̱ mi mahyoni nda bo̱tsꞌe, ne hinge nda ꞌyentꞌa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ngetho xki o̱the nze̱ye̱ ya jöꞌi, jange gatho nuꞌu̱ mi hñeni, xa mi ñꞌentꞌi mi ne nda da̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ha nuya mi nthe̱xkwi ya tsꞌondöhi, núꞌmu̱ nda hyandi, mi nda̱ndihmö hár waꞌö, ne mi mafi mi eñꞌu̱: —Nuꞌge go ár Tꞌu̱ꞌi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nöꞌö xa mi tsu̱i hinge nda möñꞌu̱ togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mꞌe̱fa bi bo̱xa har tꞌo̱ho̱, ne bi zohna nuꞌu̱ togo mi neꞌö, ne nuyu̱ bi ma ba tsu̱di. ");
INSERT INTO otqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ne bi hñuxa ꞌre̱tꞌamayoho nda ñꞌowi, ne nda me̱hni ma nda mönga ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ne nda me̱ꞌsa ar tsꞌe̱di nda o̱the ya hñeni, ne nda ꞌye̱nga ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nꞌaꞌu̱ ar Simu nöꞌö bi hñuꞌspabi ar Pedro, ");
INSERT INTO otqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ar Hakobo ár tꞌu̱ ar Sebedeo, ne ar Xuwa ár jödö ar Hakobo, gehyu̱ bi thuꞌspabi ya Boanerges, ne da ꞌñenö: Ya bötsi di hñöxa ár hñeti ar ñu̱ni; ");
INSERT INTO otqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ar Andre, ar Lipe, ar Bartolo, ar Teo, ar Toma, ar Hakobo ár tꞌu̱ ar Alfeo, ar Tadeo, ne ar Simu togo xki ñꞌowi nuꞌu̱ mi ntuhni mi ñönga ár hnini, ");
INSERT INTO otqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne ar Huda Iskariote nöꞌö togo bi da̱. Ne mi wadi bi hwañꞌu̱, bi menkꞌu̱ habu̱ mi ꞌbu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nu mi zo̱ñꞌu̱nu̱, xa bi watꞌa ra nze̱ye̱ ya jöꞌi manꞌagi, himi he̱gi nda ñuni. ");
INSERT INTO otqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nu mi ꞌyo̱ yá mëni ar Hesu, ba eꞌu̱ nda zitsꞌi, ngetho mi eñꞌu̱ xi ꞌbe̱ ár mfeni. ");
INSERT INTO otqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nuya bötꞌofo xki ꞌñe Herusalen mi eñꞌu̱ mi pe̱ꞌsa ar Belsebu, ne mi hömpa ár tsꞌe̱di ár ndö ya tsꞌondöhi, njapꞌu̱ mi e̱nga ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ar Hesu bi xipabi nda watꞌa ya jöꞌi, ne mi utꞌu̱ mꞌede, mi enö: —Hanja tsa̱ ar tsꞌondöhi da ñꞌe̱nse̱. ");
INSERT INTO otqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nuꞌmu̱ nꞌar hnini da ntunse̱, da nhwati. ");
INSERT INTO otqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne nuꞌmu̱ nuꞌu̱ togo ꞌbu̱ ha nꞌar ngu da ntunse̱, da ñhege. ");
INSERT INTO otqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ne nuꞌmu̱ ya tsꞌondöhi da mpo̱xkwe̱ ne da ñhege, da nhwatase̱. ");
INSERT INTO otqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hinto tsa̱ da yu̱tꞌa hár ngu nꞌar ñꞌo̱ho̱ xa ja ár tsꞌe̱di, ne da bëpa yá ñho nuꞌmu̱ hinxi xo̱tꞌe mꞌe̱tꞌo. Núꞌmu̱ xta wadi da xo̱tꞌe hö, da tsa̱ da bëpa yá ñho. ");
INSERT INTO otqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Xa majöni di xiꞌahu̱, gatho yá tsꞌoki ya meximha̱i ma da mpumbabi, ne tsa̱ntꞌö ar tsꞌate xi mö. ");
INSERT INTO otqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ha nöꞌö togo da ꞌye̱mba ar ñömañꞌu̱ ár Hñö Jö, hinda ma da mpumbabi. Xi tꞌe̱kwabi ar mfe̱i hiñhamꞌu̱ da thege. ");
INSERT INTO otqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bi ꞌñembabi njapꞌu̱ ngetho xki ꞌñeñꞌu̱: Xi nthe̱xkwi nꞌar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mꞌe̱fa ba ehnu̱ ár nönö ne yá jödö, himbi thoꞌu̱, bi gota nthi, ne bi me̱ñꞌu̱ togo nda zofo. ");
INSERT INTO otqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nuꞌu̱ togo mi hu har nthetꞌi habu̱ mi huꞌö, bi ꞌñembabi: —Ri nönö ne ri jödö bi ꞌba̱ nthi, hoñꞌaꞌi ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ne nöꞌö bi dödi: —Togo ma nönö ne ma jödö. ");
INSERT INTO otqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bi kꞌötꞌa nuꞌu̱ mi hu hár nthetꞌiꞌö, ne bi ꞌñenö: —Xi ꞌbu̱kwa nuꞌu̱ togo ma nönö ne ma jödö. ");
INSERT INTO otqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngetho gatho nuꞌu̱ togo o̱tꞌa ngu mönga Jö, go gehyu̱ ma jödö, ma nju ne ma nönö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ar Hesu bi du̱ꞌma manꞌagi bi uta ya jöꞌi har ñönthe. Ne bi gotꞌatho nze̱ye̱ ya jöꞌi, xa mar nze̱ye̱. Jange nöꞌö bi yu̱tꞌa har motsa ne ka bi hñuxnu̱, ha gatho ya jöꞌi mi ꞌba̱ta har ñönthe. ");
INSERT INTO otqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ne te gatho mi utꞌu̱ mꞌede, ne njapꞌu̱ mi utwabiꞌu̱ ár ntꞌuti, bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—ꞌYo̱xu̱ nöꞌö ma ga xiꞌahu̱: Nꞌar motꞌi bi bo̱ni ma ba mpotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ne núꞌmu̱ mi mpotꞌi, nꞌa tu̱i bi zo har ꞌñu, ba e ya tsꞌintsꞌu̱ bi go bi za. ");
INSERT INTO otqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Manꞌa tu̱i bi zo ha ya do habu̱ himi köxa nze̱ye̱ ar ha̱i. Ngutꞌa bi kꞌontsꞌi ngetho himar mpidi ar ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Núꞌmu̱ mi bo̱xa ar hyadi, bi hwixki, ne bi ꞌyotꞌi, ngetho himi tsa̱ nda nu̱nga yá ꞌyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Manꞌa tu̱i bi zo habu̱ mi ja ya ꞌmini. Ne nu mi te nuya ꞌmini, bi xuhña bi otꞌi ne hinte bi uni. ");
INSERT INTO otqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Manꞌa tu̱i bi zo habu̱ mar ñho ar ha̱i, ne bi unga nꞌar hoga sofo, bi kꞌontsꞌi ne bi te. Bi unga nꞌa̱temaꞌre̱tꞌa, hñunꞌa̱te ne nꞌanthebe nꞌa ngu nꞌa ar ꞌba̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne bi ꞌñembabiꞌu̱: —Nöꞌö togo tu ár gu, dá ꞌyo̱xa nöꞌö di mö. ");
INSERT INTO otqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Núꞌmu̱ mi mꞌu̱se̱ nuꞌu̱ mi te̱ni ne nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, bi ꞌya̱mbabi tema ndi bo̱nga nunar ꞌbedeꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ne bi ꞌñembabiꞌu̱: —Nuꞌahu̱ xi utꞌahu̱ Jö nöꞌö hinxi fö mamꞌe̱tꞌo tengu ár tsꞌu̱tꞌwi, ha nu maꞌra hindi ñꞌohu̱, di utamꞌede. ");
INSERT INTO otqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ne xta hyandi, hinda bödi ter me̱ꞌö, nu xta ꞌyo̱de hinda zo yá mfeni, njapꞌu̱ hinda ꞌyo̱tꞌwa yá ntso̱ꞌmi, ne da mpumbabi. ");
INSERT INTO otqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne bi ꞌñembabiꞌu̱: —Ha hingi pöhu̱ tema di bo̱nga nunar ꞌbedenu̱. Hanja ma gi pöhu̱ tema di bo̱nga gatho nuya ꞌbede ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nunar motꞌi, gehnu̱ nöꞌö togo xanga ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nöꞌö te ꞌbotꞌi bi zo har ꞌñu, njangu nuꞌu̱ togo xi nsipa ár mhö Jö. Ne xta wadi da ꞌyo̱de, ngutꞌa da ꞌñepꞌu̱ ar tsꞌondöhi, ne da hñömba nunar mhö xki zomhö ár mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Njapꞌu̱tho nöꞌö bi ꞌbotꞌa ha ya do, núꞌmu̱ xta nsipa ar mhö, njohya da hñöni. ");
INSERT INTO otqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ha hinxi nu̱nga yá ꞌyu̱, jange ngutꞌa da ꞌyotꞌi nu xta ꞌñepabi ya thogi ne ya ntꞌu̱tsa ngetho te̱mba ár mhö Jö, dama da ꞌwege. ");
INSERT INTO otqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ha nöꞌö bi ꞌbotꞌa habu̱ mi ja ya ꞌmini, ñhe̱hwi nuꞌu̱ togo xi ꞌyo̱ ár mhö Jö, ");
INSERT INTO otqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ne tupár mu̱i gatho nöꞌö te jawa har ximha̱i. Ne ñhe̱gi da ka ar bojö ne gatho nu maꞌra te hyo̱ke, ne da hwata ar mhö xki zo hár mu̱i, njangu ar tꞌe̱i hinte bi uni. ");
INSERT INTO otqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ha nu maꞌra bi zo habu̱ mar ñho ar ha̱i. Geꞌu̱ togo xi ꞌyo̱ ár mhö Jö, ne da hñöni xiñho, njangutho nuꞌu̱ bi unga ar hoga sofo, ꞌra nꞌa̱temaꞌre̱tꞌa, maꞌra hñunꞌa̱te, ne maꞌra nꞌanthebe nꞌa ngu nꞌar ꞌba̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ar Hesu bi ꞌñembabiꞌu̱ nꞌehe: —Hage da thö nꞌar ñotꞌi ne da joꞌma ha nꞌar hwada, wa da ꞌbo̱ ha̱i nꞌar fidi. Hage hinda tꞌexa har mfoxꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Njapꞌu̱tho nꞌehe, gatho nöꞌö tꞌo̱tꞌa ñꞌöntho, nꞌar pa ma da födi, ne ma da bo̱xa gatho nöꞌö xi joꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nöꞌö togo tu ár gu, dá ꞌyo̱xa nöꞌö di mö. ");
INSERT INTO otqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne bi ꞌñembabi nꞌehe: —Hyanthu̱ xiñho tema gi o̱hu̱, ngetho nuꞌmu̱ gi kwathu̱ xiñho nöꞌö nsiꞌahu̱, ma da thusꞌahu̱ ár nze̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ngetho nöꞌö togo pe̱tsꞌi, ma da thuꞌspabi ár nze̱ye̱, ha nöꞌö hinte pe̱tsꞌi, da thömba nöꞌö beni mi pe̱ꞌshmö. ");
INSERT INTO otqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ar Hesu bi ꞌñembabi nꞌehe: —Ár tsꞌu̱tꞌwi Jö ñhe̱hwi ngu nꞌar ñꞌo̱ho̱ pontꞌe̱i har ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Da ñꞌöhö ne da nangi, parxui po̱tsꞌe ne te, mödi hingi pödi hanja. ");
INSERT INTO otqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ngetho nunár ñhose̱ ar ha̱i unga ar sofo: mꞌe̱tꞌo ar do̱nitho, mꞌe̱fa da ngöhö, ne nuya ngöhö da ñuxa ya tꞌe̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ne nu xta ñötsꞌi, ngutꞌa da mfota ar tꞌe̱xu̱, ngetho xi zo̱ ar sofo. ");
INSERT INTO otqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Bi ꞌñembabi nꞌehe: —Tema ga emfu̱ di hñöxa ár tsꞌu̱tꞌwi Jö, wa tema ꞌbede ga he̱jwu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ñhe̱hwi nꞌar nda̱murtasa, nuꞌmu̱ xta ꞌbotꞌi xa tsi tꞌu̱lo, töta gatho nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ha nu xta te, töpa ár döta maꞌra ya kꞌani. Ne xa di döta yá ꞌye̱, nuya tsꞌintsꞌu̱ hokyá mꞌafi ha yá xudi. ");
INSERT INTO otqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ar Hesu mi mönga nze̱ye̱ ya ꞌbede nguyu̱. Njapꞌu̱ mi utwa ya jöꞌi ár mhö Jö, njangu mi tsa̱ nda zo yá mfeniꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nuꞌmu̱ himar ꞌbede, hinte mi xipabiꞌu̱, mödi yá ma̱xte mi otꞌwa ar ꞌñu tema ndi bo̱ni, núꞌmu̱ mi ꞌbu̱se̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nor paꞌö mi nxui, bi ꞌñemba yá ma̱xte: —Ma ga thohu̱ ꞌrandi. ");
INSERT INTO otqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bi ꞌñe ya jöꞌi, ne har motsa habu̱ mi ku̱ꞌu̱, bi maꞌu̱. Mi ꞌbu̱hnu̱ maꞌra ya motsa nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Núꞌmu̱ mi ku̱ har dehe, bi ñꞌo nꞌar ꞌyomndöhi, ne xa mi e̱nsa ar dehe har motsa, ꞌbu̱tho nda ku̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ne ar Hesu mi ꞌbe̱nga hár xu̱tha ar motsa mi öhö, xki ga̱xa ár ñö ha nꞌar huhni. Bi ma ba tꞌa̱, ne bi tꞌembabi: —Utate, ha hingi handi ma ga ku̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ne bi nankꞌö bi zu̱ ar ndöhi, ne bi ꞌñemba ar ñho̱nthe: —Ñhe, ntsa̱ya̱. Ne bi ntsa̱ya̱ ar ndöhi, ne gatho bi ñhetho. ");
INSERT INTO otqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ar Hesu bi ꞌñemba yá ma̱xte: —Yoꞌö xa gi ntsuhu̱. Hanja hingi ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nuꞌmú̱ xa bi zu̱ nꞌar mbidi, ne mi enga nꞌa ngu nꞌaꞌu̱: —Togoꞌmu̱nu̱. Ar ndöhi ne ar ñho̱nthe o̱te te ꞌbe̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bi ꞌrañꞌu̱ ꞌrandi ar ñho̱nthe, bi zo̱ñꞌu̱ ha yá ha̱i ya me Gadara. ");
INSERT INTO otqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ne nu mi gö ar Hesu har motsa, dama ba e bi zu̱ nꞌar ñꞌo̱ho̱ xki ꞌñe ha ya tꞌa̱gi, mi nthe̱xkwi nꞌar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nunar ñꞌo̱ho̱nu̱ mi ꞌbu̱ ha ya tꞌa̱gi, ne hinto mi tsa̱ nda xo̱tꞌe, himi o̱ta ya nthöhibo̱jö. ");
INSERT INTO otqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ngetho hinga nꞌagitho xki nthötꞌa ya nthöhibo̱jö, ne nöꞌö mi xe̱ki ne mi ku̱ntꞌa ya bo̱jö, hinto mi tsa̱ nda döhö. ");
INSERT INTO otqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ne hyaxꞌmu̱, parxui mi ꞌyo mi he̱xya mhafi ha ya tꞌo̱ho̱ ne ha ya tꞌa̱gi, ne mi ju̱ ya do xa mi ntse̱nse̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nu mi hyanda ar Hesu mi e yapꞌu̱, bi nixtꞌi ba e bi nda̱ndihmö hár wa. ");
INSERT INTO otqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ne mi mafi ntsꞌe̱di mi enö: —Te gi hongwa Hesu, ár Tꞌu̱ꞌi Jö bi ꞌbu̱ mhetsꞌi. Di etꞌa Jö, di a̱ꞌi hingi ꞌraka ar mfe̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ngetho ar Hesu mi embabi: —Tsꞌondöhi, hye̱ nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ne bi ꞌya̱mbabi: —Temar huꞌi. Ne bi dödi bi ꞌñenö: —Nꞌa mutꞌi, ngetho di nze̱ye̱he. ");
INSERT INTO otqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne xa mi a̱pa ar möte, hinge nda me̱hni nda ma maꞌra ya ha̱iꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Getꞌu̱nu̱ mi ꞌyonu̱ nze̱ye̱ ya tsꞌu̱di mi ñunga har ngwani. ");
INSERT INTO otqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gatho nuya tsꞌondöhi mi a̱pa ar möte ar Hesu mi embabi: —Pe̱nkagihe ma ga ku̱the ha ya tsꞌu̱diyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ne ar Hesu bi umba ar se̱ki. Nuya tsꞌondöhi bi bo̱ni bi ma ba ku̱tꞌa ha ya tsꞌu̱di. Nuyu̱ mi tsu̱ ngu nꞌa̱tenthebe, ne gatho bi ñho̱ har maꞌye, ma ba tso har ñho̱nthe, bi jötꞌa gatho. ");
INSERT INTO otqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ne nuꞌu̱ togo mi su ya tsꞌu̱di, bi nixtꞌi ma ba xipa ya jöꞌi mi ꞌbu̱ har hnini ne har nthetꞌi. Ne bi bo̱nga ya jöꞌi, ma ba handa te xki thohnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba e bi kꞌönga ar Hesuꞌu̱, ne bi hyantꞌu̱ mi ꞌbu̱hwinu̱ nöꞌö togo xki nthe̱xkwi ár mutꞌi ya tsꞌondöhi, mi huhnu̱ xki hye ár dutu ne mi ja ár mfeni. Nuꞌmú̱, xa bi zuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne nuya togo mi ꞌbu̱hnu̱, ne bi hyanda tema xki ja nöꞌö togo mi pe̱ꞌsa ya tsꞌondöhi ne ya tsꞌu̱di, mi petwa nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne nuya jöꞌi bi ndu̱i bi ꞌya̱pa ar möte ar Hesu nda manu̱ nda zokwabinu̱ yá ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ne mi bo̱xa ar Hesu har motsa, nöꞌö ar ñꞌo̱ho̱ xki nthe̱xkwihmö ya tsꞌondöhi, mi a̱pa ar möte nda hye̱gi nda me̱wi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nöꞌö himbi hye̱gi, ne bi ꞌñembabi: —Di ma ri ngu ne ba tsu̱ ri mëni. Petwabi hangu ya döta ntꞌudi xi ꞌyo̱tꞌa ar tsi Hmu, ne hanja xi me̱sꞌa ar nhwëki. ");
INSERT INTO otqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ne bi ma, bi ndu̱i bi metwanu̱ Ndekapoli tengu ár döta ya ntꞌudi xki hwëkwa ar Hesu, ne gatho xa mi ꞌyo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bi ꞌraxa manꞌagi ar Hesu ꞌrandi ar ñho̱nthe ha nꞌar motsa. Bi watꞌa ra nze̱ye̱ ya jöꞌi, ne nöꞌö mi ꞌba̱ta har ñönthe. ");
INSERT INTO otqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ne ba e nꞌar ndö ha yá nijö ya xodyo mar thuhu ar Hairo, mi hyandi bi nda̱ndihmö hár wa. ");
INSERT INTO otqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ne xa mi a̱pa ar möte mi embabi: —Ma tꞌinxu ntsa̱wi ar ndöte. Ba e gi hñuxa ri ꞌye̱ gi o̱the ne da nte. ");
INSERT INTO otqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bi me̱wi ꞌmu̱. Ra nze̱ye̱ ya jöꞌi mi te̱ni, ne nuyu̱ xa mi tsꞌitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja mi panu̱ nꞌar ꞌbe̱hñö mi pe̱ꞌsa ꞌre̱tꞌa ma yonje̱ye̱ mi xotꞌwa ya ji. ");
INSERT INTO otqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Xa mi ñꞌu̱da ár mꞌu̱i. Xki kꞌönga nze̱ye̱ ya unga ñꞌethi, xki de gatho nöꞌö mi pe̱tsꞌi ne hinte mañho xki dini, ho̱nse̱ mi tsa̱ꞌye̱ hyaxꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nu mi ꞌyo̱de mi nho̱nga ar Hesu, bi yu̱tꞌa madeda ya jöꞌi, ne ba e hár xu̱tha bi da̱mba ár patꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ngetho mi ense̱: Nuꞌmu̱ mödi ho̱nse̱ ga tha̱mbahmö ár patꞌi, da dixkagi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ne nꞌagitho bi kꞌu̱ nuya ji, ne bi za̱ hár ndoꞌyo xki hñöka nunar u̱giꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ar Hesu dama bi za̱ xki bo̱nga ar tsꞌe̱di hár ndoꞌyo, bi ñegi bi hyanda ya jöꞌi, ne bi ꞌñembabi: —Togo xi da̱mga ma he. ");
INSERT INTO otqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nuyá ma̱xte bi ꞌñembabi: —Gi handi tsꞌisꞌa gatho ya jöꞌi, ne gi enö: Togo xi da̱ñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ha nöꞌö mi handa hár nthetꞌi mi honi togo xki ꞌyo̱tꞌa njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nuꞌmú̱ nunar ꞌbe̱hñö, mi ntsu ne xa mi nhwötꞌi, mi pöꞌö tema xki me̱fi, ba e bi nda̱ndihmö hár waꞌö, ne bi da̱twa majöni. ");
INSERT INTO otqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ha nöꞌö bi ꞌñembabi: —Ma tsi tꞌinxu, nuna ri jamfi xi ma̱xꞌi xi dixꞌi. Di ma ter entho, xi hñöka ri u̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hinxki watho nda ñö, ba e ꞌra xki ꞌñe hár ngu ár ndö yá nijö ya xodyo, ne bi ꞌñembabi: —Yo gi hökwa ár ꞌbe̱fi ar Utate. Xi du ri tꞌinxu. ");
INSERT INTO otqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mi ꞌyo̱ ar Hesu, bi ꞌñemba ár ndö ar nijö: —Yo gi ntsu. Ho̱nse̱ ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne hinto bi hye̱gi nda de̱ni, ho̱nse̱ ar Pedro, ar Hakobo ne ar Xuwa ár jödöpꞌu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ne bi ma hár ngu ar ndöꞌö, ne bi hyanda ya jöꞌi xa mi nxintꞌi mi zoni ne mi mafi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ne nu mi yu̱tꞌi, bi ꞌñembabiꞌu̱: —Yoꞌö xa gi nxinthu̱ ne xa gi zoñhu̱. Nunar nxutsinu̱ hinxi du, ötho. ");
INSERT INTO otqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ha nuꞌu̱ togo mi ꞌbu̱hnu̱ mi thentho. Nunu̱ bi ꞌye̱nga gatho, ne ho̱nse̱ bi hye̱gi nda yu̱tꞌa habu̱ mi ꞌbe̱ngar nxutsi ár dada, ár nönö ne nuꞌu̱ mi ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bi mipa ár ꞌye̱ ar nxutsi, ne bi ꞌñembabi: —Talita kumi —di bo̱ni da ꞌñenö: Nuꞌge nxutsi, di xiꞌaꞌi gi nangi. ");
INSERT INTO otqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ne dama bi nangi bi ñꞌo. Nunar nxutsinu̱ mi pe̱ꞌsa ꞌre̱tꞌa ma yonje̱ye̱. Ne gatho nuꞌu̱ bi hyandi, xa bi ꞌyo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ar Hesu xa bi hñuꞌmba yá mu̱i, hinto nda metwabi nöꞌö xki thogi, ne nda tꞌumba te nda zi ar nxutsi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ar Hesu ba po̱nu̱ bi ma ár ha̱i, ne nuyá ma̱xte mi te̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mi zo̱ ar pa ntsa̱ya̱, bi ndu̱i bi uta ya jöꞌi ha yá nijö. Ne nze̱ye̱ mi ꞌyo̱de, xa bi ꞌyo̱tho, ne mi eñꞌu̱: —Ha xpa pöhnu̱ gatho nöꞌö mö. Tema mfödi xi tꞌumbabinu̱. Hanja o̱tꞌa gatho nuya döta ntꞌudiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ha hinga gehnu̱ ar hye̱nza, ár tꞌu̱ ar Maria, ár jödö ar Hakobo, ar Huse, ar Huda ne ar Simu nꞌehe. Ha hindi ꞌbu̱hwihu̱wa yá nju. Ne xa mi tso̱tꞌa yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ha nunar Hesu mi embabiꞌu̱: —Nꞌár mꞌe̱hni Jö habu̱ gatho nhumansu, ha nu hár ha̱ise̱ hinꞌö, ne hingi numansu yá mëni, ne hár nguse̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ne himbi tsa̱ bi ꞌyo̱tꞌa nze̱ye̱ ya döta ntꞌudinu̱, ho̱nse̱ bi o̱the ꞌra ya da̱thi mi hñuꞌspa ár ꞌye̱yu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne xa mi ꞌyo̱tho hanja himi ñꞌemu̱iꞌu̱. Ne mi ꞌyo ha ya tꞌu̱lo hnini har nthetꞌi, mi uta ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mꞌe̱fa ar Hesu bi zohna nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, ne ꞌrama yoho bi me̱hni nda maꞌu̱, ne bi umba ar tsꞌe̱di nda ꞌye̱nga ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne bi xipabi hinte nda hñöxa nda ñꞌo har ꞌñu. Hinte nda hñöxa ar ꞌro̱zö, wa te nda zi. Hinge nda nxöꞌsa ar bojö ha yá ngu̱tꞌi, ho̱nse̱ nꞌar ndo̱ho̱ nda hñötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nda ditꞌa yá thiza, ne hinge nda hñöxa yomponi ar dutu. ");
INSERT INTO otqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne bi ꞌñembabiꞌu̱: —Núꞌmu̱ xki ku̱thu̱ ha nꞌar ngu, ka gi oxu̱nu̱ gatho ya pa gi ꞌbu̱hu̱nu̱ har hniniꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nu habu̱ hinda tꞌaꞌahu̱ ar se̱ki, ne hinda ne da ꞌyo̱xꞌahu̱, po̱ñhu̱nu̱ ne hwöju̱ ar fontha̱i xi watꞌa ha ri wahu̱. Njapꞌu̱ da böꞌu̱ hingi ho nöꞌö te pe̱ꞌu̱. Xa majöni di xiꞌahu̱, nunar pa ma da thöꞌspa majöni nöꞌö ar hniniꞌö, ma da hñönga nꞌar döta mfe̱i, di töpa yá mfe̱i ya hnini Sodoma ne Gomora. ");
INSERT INTO otqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ne mi bo̱ñꞌu̱ mi xipa ya jöꞌi nda ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mi e̱nga nze̱ye̱ ya tsꞌondöhi, mi koxa ar nziki nze̱ye̱ ya da̱thi, ne mi o̱theꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ar ndö Erode bi zo ár gu gatho nöꞌö mi o̱tꞌa ar Hesu, ngetho xki nu̱nga ár thuhu gatho nuya ha̱iꞌu̱. Ne mi enö: —Ar Xuwa Xixthe xi mengi xi nte zëi, jange pe̱ꞌsa nor tsꞌe̱diꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ha maꞌra mi enö mar Elia. Ne maꞌra mi enö már mꞌe̱hni Jö, ngu nu maꞌra ya mꞌe̱hni mi ꞌbu̱ mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nu mi ꞌyo̱ njapꞌu̱ ar Erode bi ꞌñenö: —Gehnu̱ ar Xuwa togo da he̱kwa ár ꞌyu̱ga xi mengi xi nte. ");
INSERT INTO otqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ngetho gese̱ ar Erode xki me̱hna togo nda gu̱ ar Xuwa, xki dötꞌa ya bo̱jö har fa̱di. Xki japꞌu̱ ngetho xki hñökwahmö hinge nda mꞌu̱hwi ar Erodia, ár ꞌbe̱hñö ar Lipe ár jödöpꞌu̱ꞌö, xki zimbabi ne mi ꞌbu̱hwi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ngetho ar Xuwa xki ꞌñemba ar Erode: —Hingi ho gi ꞌbu̱hwi ár ꞌbe̱hñö ri jödö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ha nunar Erodia mi öthó, mi ne nda hyohmö, ha himi tsa̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ngetho nunar Erode mi tsu ar Xuwa, mi pödi mar hogajöꞌi ne hinte ma tsꞌoki mi tu, jange mi fa̱tsꞌi nda kꞌontꞌi. Ne núꞌmu̱ mi o̱xa nöꞌö mi möñꞌö, himi pödi te nda beni, ne mi johya mi o̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ha nꞌagi bi zo̱ ar pa mi to̱ꞌma ar Erodia. Núꞌmu̱ mi da̱ ár da̱ngo ar Erode, mi umba nꞌar tꞌoxi yá ma̱xte mi ndöwi, ya ndöndogu ne ya ndöngi me Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nꞌa mbi yu̱tꞌatho ár tꞌinxu ar Erodia bi nei, ne bi numañho ar Erode ne gatho nuꞌu̱ mi huhwi har mexa. Nꞌa mbi ꞌñembatho nunar nxutsi: —ꞌYa̱ka gatho nöꞌö gi ne, ne ga ꞌraꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bi ꞌñetꞌa made Jö bi ꞌñembabi: —Gatho nöꞌö gi ꞌya̱kagi, ga ꞌraꞌi. Di ꞌbu̱i ga ꞌraꞌa made ma tsꞌu̱tꞌwi di pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mi bo̱nga nunar nxutsi, bi ꞌñemba ár nönö: —Te ga a̱pa ar ndö. Ne nunár nönö bi ꞌñembabi: —ꞌYa̱pa da ꞌraꞌa ár ñö ar Xuwa Xixthe. ");
INSERT INTO otqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nuꞌmú̱ dama bi yu̱tꞌa habu̱ mi ꞌbu̱ ar ndö, ne bi ꞌya̱ njawa: —Di ne gi ꞌraka nꞌagitho ha nꞌar manza ár ñö ar Xuwa Xixthe. ");
INSERT INTO otqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ne nunar ndö Erode xa bi zo̱tꞌa ár mu̱i. Ne himbi tsa̱ bi ponga ár ne, ngetho xki ꞌñetꞌa made Jö, ne xki ꞌyo̱xa gatho nuꞌu̱ mi huhwinu̱ har mexa. ");
INSERT INTO otqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jange nꞌagitho bi me̱hna nꞌar ndogu nda hömpa ár ñö ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ar ndogu bi ma ba he̱kwa ár ñö har fa̱di, ne ba hömpabi mi o ha nꞌar döta manza. Ne bi da̱twa ar nxutsi, ha nuna bi thokwa ár nönö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nu mi ꞌyo̱ yá ma̱xte ar Xuwa tema xki thogi, ba eꞌu̱ ne bi hñöꞌspa ár ndoꞌyo ma ba a̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Núꞌmu̱ ba penga yá ma̱xte ar Hesu, bi ma ba tsu̱ꞌö, ne bi metwabi gatho nöꞌö xki me̱ꞌu̱ ne nöꞌö xki utwa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ha nöꞌö bi ꞌñembabi: —Möhö har tꞌo̱ho̱ gi tsa̱ya̱hu̱ nꞌa tsi tu̱i habu̱ hinto ꞌbu̱i. Xa nze̱ye̱ ya jöꞌi ndi ma ne ndi ꞌñehe, himi he̱gi nda ñuni. ");
INSERT INTO otqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ne bi mase̱ꞌu̱ ha nꞌar motsa, ndi ma habu̱ hinto mi ꞌbu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ha nze̱ye̱ ya jöꞌi bi hyandi mi maꞌu̱, ne bi bödi go mi geꞌö. Ba po̱ñꞌu̱ ha ya hnini bi ma watho, ne bi döhö bi zo̱ñꞌu̱ mꞌe̱tꞌo habu̱ ndi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ne nu mi gö ar Hesu har motsa, bi hyandi xa mi nze̱ye̱. Ne xa bi hwëki, ngetho mi ñhe̱hwi ꞌra ya tsi de̱ti hinte ꞌñe ár ma̱ꞌyo, ne bi mu̱di te gatho mi uti. ");
INSERT INTO otqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Núꞌmu̱ mi nde, bi watꞌa yá ma̱xte ne bi ꞌñembabi: —Hinte jawa ya ngu har tꞌo̱ho̱, ha bi nde. ");
INSERT INTO otqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ꞌÑedi ma da hyonga te da ziyu̱ har nthetꞌi ne ya tꞌu̱lo hnini, ngetho hinte höyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ar Hesu bi dödi ne bi ꞌñembabi: —Go gi umfu̱ te da zi. Bi döꞌu̱: —Habu̱ ga tiñhe yonthebe mpa ar nthöhö ga ta̱ñhe ya thuhme, ne ga ꞌwiñheyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nöꞌö bi ꞌñembabiꞌu̱: —Hangu ya thuhme gi höhu̱. Dí ma ba nuhu̱. Ne mi bödi bi ꞌñeñꞌu̱: —Ku̱tꞌa, ne yoho ya tsi hwö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bi möñꞌö nda nsipabi ya jöꞌi nda hñudi mutꞌitho har kꞌangdo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne bi hñuꞌu̱ bi ꞌyo̱tꞌa ya mutꞌi nthebe, ne maꞌra ngu̱dmi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nuꞌmú̱ ar Hesu bi gu̱ nuya ku̱tꞌa ya thuhme ne nuya yoho ya hwö, bi no̱ꞌsa mhetsꞌi bi jöpi. Bi heka ya thuhme, ne bi thokwa yá ma̱xte bi hyemba ya jöꞌi. Ne bi japꞌu̱ nuya yoho ya hwö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gatho ya jöꞌi bi ñuni ne xa bi niñö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mꞌe̱fa bi njo nuya xe̱ni thuhme ne ya hwö bi bongi, bi ñhuꞌsa ꞌre̱tꞌamayoho ya ꞌbo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ha nuꞌu̱ togo xki ñuni, mi tsu̱ ngu ngu̱dminthebe ya ñꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mꞌe̱fa ar Hesu bi xipa yá ma̱xte nda bo̱xa har motsa, nda mꞌe̱tꞌo ndi maꞌu̱ Betsaida, mi ꞌbu̱ ꞌrandi har ngwani. Ha nöꞌö nda gohmö nda ñꞌehwi ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ne mi wadi bi ꞌñeꞌu̱, bi bo̱xa har tꞌo̱ho̱ ma ba a̱pa Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nu mi nxui, ar motsa mi pa madeda ar ñho̱nthe, ne nöꞌö mi ꞌbu̱se̱ har tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mi hyanda yá ma̱xte xa mar ñhembi nda ñꞌo har dehe, ngetho ar ndöhi mi nto̱xkwiꞌu̱. Mi zo̱ ngu ar hñumxudi, bi ma ba tsu̱di mi ꞌyoda mañö ar dehe, ne bi ꞌyo̱tꞌe ngu mi ne nda thotho. ");
INSERT INTO otqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mi hyantꞌu̱ mi ꞌyo har dehe, bi beñꞌu̱ mar pite, ne xa bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gatho bi hyandi ne xa bi ntsu. Nꞌagitho bi zofo ne bi ꞌñembabi: —Go gekaga, yo gi ntsuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ne bi bo̱xkwiꞌu̱ har motsa. Nuꞌmú̱ bi nkötꞌa ar ndöhi, ne nuꞌu̱ xa bi ꞌyo̱tho, himi pödi te nda beni. ");
INSERT INTO otqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ngetho hinxki zoda yá mfeni núꞌmu̱ mi japa ya thuhme bi xu, xa mar me yá mfeni. ");
INSERT INTO otqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mi zo̱ñꞌu̱ ꞌrandi ar dehe har ha̱i Genesare, ka bi dötnu̱ ar motsa. ");
INSERT INTO otqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ne nu mi göꞌu̱, nꞌagitho bi bö ya jöꞌi go mar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bi ne ya nguyu̱ xo̱ge har nthetꞌi nor ha̱iꞌö, ne bi ndu̱i habu̱ gatho mi tsꞌimpa ya da̱thi mi ku̱xa ha ya fidi, habu̱ nda ntꞌo̱de mi ꞌbu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne habu̱ gatho mi ku̱tꞌa ar Hesu ha ya tꞌu̱lo hnini, ha ya döhni ne ha xki fontꞌa ya ngu, mi tsꞌi ya da̱thi ne nda ꞌbo̱ ha ya döꞌñu. Ne nuyu̱ ho̱nse̱ mi a̱di nda the̱gi nda da̱mba ár ñöni ár pa̱tꞌi, ne gatho nuꞌu̱ mi tha̱mbabi, mi thitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nuya de̱ngaꞌbe̱pate ne ꞌra ya bötꞌofo xki ꞌñe Herusalen, ba e bi watꞌa habu̱ mi ꞌbu̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ne mi hyantꞌu̱ ꞌra yá ma̱xte ar Hesu hinge mi xu̱ꞌye̱ nda ñuni, ne mi theñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ngetho nuya de̱ngaꞌbe̱pate ne gatho ya xodyo xa mi te̱nga nunar ntꞌumbi xki zokwa yá pale, hinge nda ñuni nuꞌmu̱ hinge nda nxu̱ꞌye̱ xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ne núꞌmu̱ nda menga har ta̱i, mꞌe̱tꞌo nda nxu̱ꞌye̱, ne ja nda ñuni. Hinge ho̱nse̱nu̱, bi gu̱ maꞌra ya ntꞌumbi nda me̱fi, ngu ar su̱tꞌatꞌe̱ni, ar su̱tꞌbada, ar su̱tꞌatꞌe̱nibo̱jö, ne nda menga yá fidi. ");
INSERT INTO otqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bi ꞌya̱mbabi ꞌmu̱ ya de̱ngaꞌbe̱pate ne ya bötꞌofo: —Yoꞌö ri ma̱xte hingi te̱mba yá ntꞌumbi ma palehu̱, ñuni hingi nxu̱ꞌye̱ mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ar Hesu bi dötwabiꞌu̱ ne bi ꞌñembabi: —Xa gar nemhñöhu̱. Majöni nöꞌö bi ꞌye̱mpꞌahu̱ ar mꞌe̱hni Isaia xi tꞌotꞌi njawa: Nunar hnininu̱ oxta mañö eñꞌu̱ eska ma nsu, ngetho himbi po̱nga ha yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ter ñhoꞌö eska ma nsu, embabi ar hoga ntꞌuti nöꞌö xi bense̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ngetho xka hye̱hu̱ ár ꞌbe̱pate Jö, ne xa gi ne gi te̱mfu̱ yá ntꞌumbi ya meximha̱i, ngu ar nsu̱tꞌatꞌe̱ni, ar nsu̱tꞌbada, ne gatho nu maꞌra gi pe̱hu̱ njapꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mi embabiꞌu̱ nꞌehe: —Hinte gi nuthu̱ ár ꞌbe̱pate Jö, gi te̱ñhu̱ nuya ri ntꞌumbihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ngetho ar Moise bi ꞌñenö: ꞌÑeꞌspa ár nsu ri dada ne ri nönö. Ne enö: Nöꞌö togo da zanga ár dada wa ár nönö, hinda kꞌontꞌi da tho. ");
INSERT INTO otqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ha nuꞌahu̱ gi eñhu̱ xiñho togo da ꞌñemba ár dada wa ár nönö: Hingi tsa̱ ga fa̱xꞌi, ngetho nöꞌö nga ꞌraꞌahmö, gehnu̱ ar Korban (po̱ni da ꞌñenö ár mꞌo̱ñho̱ Jö). ");
INSERT INTO otqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ne njapꞌu̱ hingi he̱hu̱ da ma̱xa ár dada ne ár nönö. ");
INSERT INTO otqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hinte gi nuthu̱ ár mhö Jö, gi hokse̱ ri ntꞌumbihu̱, ne nze̱ye̱ maꞌra ya ꞌbe̱fi nguyu̱ gi o̱thu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ne bi zo gatho nuꞌu̱ mi ꞌbu̱hnu̱, bi ꞌñembabiꞌu̱: —Gi gathohu̱, ꞌyo̱hu̱ ne dá zo ri guhu̱ nöꞌö ma ga xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hiñꞌotho te da yu̱tꞌa hár mu̱i ar jöꞌi ne da tsꞌokwabi. Nöꞌö bi po̱nga mbo hö, go tsꞌokꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nöꞌö togo tu ár gu da ꞌyo̱de, dá ꞌyo̱xa nöꞌö te di mö. ");
INSERT INTO otqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Núꞌmu̱ mi zopꞌu̱ ya jöꞌi, bi yu̱tꞌa har ngu, nuyá ma̱xte bi ꞌya̱mbabi tema ndi bo̱nga nöꞌö xki mö. ");
INSERT INTO otqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ne ar Hesu bi ꞌñembabiꞌu̱: —Hage nuꞌahu̱ nꞌehe hinte xi zo ri mfenihu̱. Ha hinxka pöhu̱ gatho nöꞌö ku̱tꞌa hár ne ar jöꞌi, hingi tsa̱ da tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ngetho hingi tsinga hár mfeni, ho̱nse̱ tho hár mu̱i, ne da ꞌye̱i xta ñꞌe̱xjo. Bi mö njapꞌu̱, ne mi ñꞌudi gatho ya ñhuni xintꞌaxi. ");
INSERT INTO otqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne mi enö: —Gatho nöꞌö po̱nga hár mfeni, nöꞌö hö, japi da tsꞌoka ar jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ngetho ka bi ehnu̱ ya tsꞌomfeni, ya tsꞌinga nthöti, ya mꞌe̱ngwi jöꞌi, ar ntho, ");
INSERT INTO otqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ar mfë, ar nhemꞌe̱tsꞌi, ya tsꞌomꞌu̱i, ar nhemhñö, ar nheꞌbe̱hñö, ar hyo̱ke, ne da ꞌyomba ar ꞌbede maꞌra, ar ñꞌetsꞌi, ne ar kꞌatꞌamfeni. ");
INSERT INTO otqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gatho nuya tsꞌokiyu̱, di bo̱nga mbo, ne tsꞌoka ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bi nangu̱nu̱ bi ma har ha̱i Tiro ne Sidon. Mi zo̱ni bi yu̱tꞌa ha nꞌar ngu, hinto mi ne nda bödi mi ꞌbu̱hnu̱, ho̱nse̱ himbi tsa̱ bi ñꞌöni. ");
INSERT INTO otqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngutꞌa bi zo ár gu nꞌar ꞌbe̱hñö mi ꞌñe nꞌár tꞌinxu xki nthe̱xkwi nꞌar tsꞌondöhi. Mi bödi mi ꞌbu̱hnu̱, dama ba e bi nda̱ndihmö hár wa. ");
INSERT INTO otqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nunar ꞌbe̱hñönu̱ himar me Israel, xki mꞌu̱ har ha̱i Sirofenisia. Ne mi a̱pa ar möte ar Hesu nda ꞌye̱mba ar tsꞌondöhi ár tꞌinxu. ");
INSERT INTO otqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Har Hesu bi ꞌñembabi: —To̱ꞌma mꞌe̱tꞌo da niñö ya bötsi, ngetho hingi ho da gu̱mpa yá thuhme tsiꞌu̱, ne da tꞌe̱mba ya ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nunar ꞌbe̱hñö bi dödi ne bi ꞌñenö: —Hö tsi Hmu, mödi njapꞌu̱, nuya ꞌyo tsipa yá bo̱ne ya bötsi ta̱ har mexa. ");
INSERT INTO otqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Ngetho xka mönga nunar mhönu̱, di ma. Ar tsꞌondöhi xi hye̱kꞌa ri tꞌinxu. ");
INSERT INTO otqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ne nu mi zo̱nga ár ngu, bi dinga ár tꞌinxu mi ꞌbe̱nga har fidi, xki hye̱ ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bi bo̱nga ar Hesu har ha̱i Tiro, bi thota har ha̱i Sidon, ndi ma har ñho̱nthe Ngalilea, bi ꞌraxtꞌa ar ha̱i Dekapoli. ");
INSERT INTO otqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne ba tsꞌimpanu̱ nꞌar ñꞌo̱ho̱ mi gogu ne mar köne, bi tꞌa̱pa ar möte nda hñuꞌspa ár ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nöꞌö bi ꞌwekase̱, ne bi dintꞌwa yá xa̱ ha yá guꞌö. Bi zoxa ár ꞌye̱ ne bi da̱mba ár jöhne. ");
INSERT INTO otqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bi gu̱xa ár da̱ mhetsꞌi, bi ngötsꞌi ne bi ꞌñembabi: —Efata —ne da ꞌñenö: Dá xogi. ");
INSERT INTO otqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ne dama bi xo ár gu, ne bi tuka ár jöhne, bi ñö xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ar Hesu bi hñuꞌmba yá mu̱i hinto nda xipabiꞌu̱. Ha núꞌmu̱ mi xipabiꞌu̱ hinte nda mö, xa mi peꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ne xa mi ꞌyo̱ꞌu̱ ne mi eñꞌu̱: —Gatho nöꞌö pe̱fi, o̱tꞌe xiñho: nuya gogu xokwa yá gu, ha nuya gone japi da ñö. ");
INSERT INTO otqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nuya paꞌu̱ xki watꞌa ra nze̱ye̱ ya jöꞌi manꞌagi, ne hinte mi pe̱ꞌsa te nda zi. Ar Hesu bi zohna yá ma̱xte ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Di hwëka nuya jöꞌi, ngetho pe̱ꞌsa hñupa di ñꞌohu̱, ne hinte hö te da ziyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ha nuꞌmu̱ ga pe̱hna yá ngu hinte xi zi, yo ma da wentꞌa har ꞌñu, ꞌra xpa e yapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nuyá ma̱xte bi ꞌñembabi: —Ha di ꞌñe gatho ar thuhme da japa da niñöwa har otꞌatꞌo̱ho̱ nuya jöꞌiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ha nöꞌö bi ꞌya̱mbabiꞌu̱: —Hangu ya thuhme gi pe̱ꞌsu̱. Ne bi ꞌñeñꞌu̱: —Yoto. ");
INSERT INTO otqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ar Hesu bi ꞌbe̱pa ya jöꞌi nda hñu har ha̱i ꞌmu̱. Bi gu̱xa nuya yoto ya thuhme, bi umba njamödi Jö. Bi heke ne bi hyemba yá ma̱xte, ha nuyá ma̱xte bi mo̱kwa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mi pe̱sꞌu̱ nꞌehe ꞌra ya tsi hwö. Bi jöpꞌö nꞌehe, ne bi me̱hna nda mꞌo̱kwa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bi ñuñꞌu̱ ne xa bi niñö. Bi njo nuya xe̱ni xki bongi, ne bi ñuxa yoto mꞌo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mi tsu̱ ngu yonꞌa̱tenthebe nuꞌu̱ bi ñuni, ne ar Hesu bi ꞌñedi bi me̱hni bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mꞌe̱fa bi bo̱xkwi yá ma̱xte har motsa, ne bi maꞌu̱ har ha̱i Dalmanuta. ");
INSERT INTO otqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ba e ꞌmu̱ ya de̱ngaꞌbe̱pate nda ntsa̱hñökiwi, ne mi a̱pa nda uta nꞌar ntꞌudi ndi ꞌñe mhetsꞌi, ne njapꞌu̱ nda tsa̱ti. ");
INSERT INTO otqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ar Hesu bi ꞌye̱ntsꞌa nꞌar ngötsꞌi dumu̱i, ne bi ꞌñenö: —Yoꞌö a̱ ya ntꞌudi nuya tsꞌojöꞌi ꞌbu̱pya. Xa majöni di xiꞌahu̱, hinda ma da tꞌumbabi. ");
INSERT INTO otqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bi zopꞌu̱ꞌu̱, ne bi mengi bi yu̱tꞌa har motsa, bi ꞌraxa ꞌrandi ar ngwani. ");
INSERT INTO otqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yá ma̱xte bi pumhni nda hñöxa ya thuhme, ne ho̱nse̱ nꞌa mi höꞌu̱ har motsa. ");
INSERT INTO otqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Har Hesu bi ꞌñembabiꞌu̱: —Zo̱tꞌa ri da̱hu̱ ne jamasubihu̱ yá ntꞌu̱sthuhme ya de̱ngaꞌbe̱pate ne yá ntꞌu̱sthuhme ar Erode. ");
INSERT INTO otqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mi ñöxhnatho nꞌa ngu nꞌa mi eñꞌu̱: —Xikagihu̱ njapꞌu̱ ngetho hinda höhu̱ ya thuhme. ");
INSERT INTO otqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mi böta ar Hesu, bi ꞌñembabiꞌu̱: —Hage xa gi ñöxnathohu̱ gi no̱ñhu̱ hinte gi pe̱ꞌsu̱ ar thuhme. Wa hinxi xota ri mfenihu̱, ne xi meda ri ñöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ha hingi zo̱ ri da̱hu̱, wa hingi xo ri guhu̱, ne xka pumhnihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Núꞌmu̱ nda hemba ku̱tꞌa thuhme ngu̱dminthebe ya jöꞌi, hangu mꞌo̱tsꞌe ya xe̱ni ga ñuꞌsu̱. Bi döꞌu̱ ne bi ꞌñenö: —ꞌRe̱tꞌamayoho. ");
INSERT INTO otqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ne núꞌmu̱ nda hemba yoto thuhme yonꞌa̱tenthebe ya jöꞌi, hangu mꞌo̱tsꞌe ya xe̱ni ga ñuꞌsu̱ nꞌehe. Ne bi ꞌñeñꞌu̱: —Yoto. ");
INSERT INTO otqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ar Hesu bi ꞌñembabiꞌu̱ ꞌmu̱: —Hanja hinxi zoda ri mfenihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mꞌe̱fa ar Hesu ba e Betsaida, ne ka ba tsꞌimpanu̱ nꞌar goda̱, ne mi tꞌa̱pa ar möte nda hñuꞌspa ár ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bi mipa ár ꞌye̱ ar goda̱ ꞌmu̱, ne bi gu̱ka nthi ar hnini. Bi zospa ár da̱, bi hñuꞌspa ár ꞌye̱, ne bi ꞌya̱mbabi ha mi handa nꞌa tsi tu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nöꞌö mi wadi bi hyandi bi ꞌñenö: —Di handa ya jöꞌi ñhe̱hwi ya za, ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ne bi hñuꞌspa ár ꞌye̱ manꞌagi hár da̱, bi japi bi hyandi. Ne bi ho yá da̱, bi hyanda yapꞌu̱, ne bi hyanda gatho xiñho. ");
INSERT INTO otqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ar Hesu bi me̱hna ár ngu, ne bi hñuꞌmba ár mu̱i bi ꞌñembabi: —Yo ma gi ku̱tꞌa har hnini. ");
INSERT INTO otqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ar Hesu bi bo̱ngwi yá ma̱xte, bi ma ha ya tꞌu̱lo hnini har ha̱i Nsesarea Filipo. Ne núꞌmu̱ mi ne ar ꞌñu, bi ꞌya̱mbabi yá ma̱xte: —Togo enga ya jöꞌi go geke ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bi döꞌu̱ njawa: —ꞌRa enö gar Xuwa Xixthe, maꞌra gar mꞌe̱hni Elia, ha maꞌra enö go geꞌe nꞌa nuya mꞌe̱hni mi ꞌbu̱ mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nuꞌmú̱ nöꞌö bi ꞌñembabi: —Xiꞌahu̱, togo gi eñhu̱ go gekaga. Bi dö ar Pedro ne bi ꞌñenö: —Nuꞌge go gar Kristo xi ꞌñexꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ar Hesu bi ꞌñembabi hinto nda xipabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ne bi ndu̱i bi uti mi mahyoni nda tho nze̱ye̱ ya thogi Nöꞌö Togo ba e bi Njöꞌi. Ne nda u̱tsa ya dönziandö, ya ndömöjö ne ya bötꞌofo. Nda tho, ne ár hñupa nda mengi nda nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mi otꞌwa ar ꞌñu xiñho. Nuꞌmú̱ ar Pedro bi gu̱ki ne bi ndu̱i bi hñuꞌmba ár mu̱i hinge nda japꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nunar Hesu bi ñhanda habu̱ mi ꞌba̱ yá ma̱xte, ne bi zu̱ ar Pedro bi ꞌñembabi: —Di mawa, tsꞌondöhi. Ngetho hingi te̱mba ár mfeni Jö, gi te̱mbatho yá mfeni ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bi zohna ya jöꞌi ne yá ma̱xte, bi ꞌñembabi: —Nöꞌö togo ne da de̱ngagi, mahyoni da pumhnise̱ ár te, ne da ñꞌe̱ntꞌatho ga ñꞌoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ngetho nöꞌö togo ne da japi da kꞌontꞌa ár te, ma da ꞌbe̱di. Ha nöꞌö togo e̱ntꞌi da unga ár te da de̱ngagi ne da mönga ar hoga mhö, ma da dinga ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ngetho tema ñho da gu̱kwa nꞌar jöꞌi, da dö gatho nöꞌö te jawa har ximha̱i ne da ꞌbe̱ ár pa. ");
INSERT INTO otqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tema tsa̱ da unga nꞌar jöꞌi da da̱nga ár pa. ");
INSERT INTO otqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ngetho nöꞌö togo da ntsa̱ da da̱tka majöni ha yá nthandi nuya tsꞌojöꞌi ꞌbu̱ nuya payu̱, ne da ntsa̱ da mömga ma mhö, Nöꞌö Togo ba e bi Njöꞌi ma da ntsa̱ nꞌehe xta ehe di hömpa ár nsunda ár Dada, ne di ñꞌowi ya hoga e̱nxe̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bi ꞌñembabi nꞌehe: —Xa majöni di xiꞌahu̱, gi ꞌbu̱hu̱wa ꞌrapya, hingi ma gi tuhu̱, mꞌe̱tꞌo ma gi hyanthwu̱ ár tsꞌu̱tꞌwi Jö da ehe, xa di nheki ár tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mi tho ꞌrato mpa ar Hesu bi zixa ar Pedro, ar Hakobo ne ar Xuwa, bi bo̱xase̱yu̱ ha nꞌar tꞌo̱ho̱ mar ñhetsꞌi. Mi zo̱ñꞌu̱ bi mponga ár ꞌba̱i ar Hesu hár nthandiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne ár he xa mi hyatsꞌi, bi tꞌaxki ngu ar tse̱. Hinjoꞌowa har ximha̱i nꞌar meni da tsa̱ da japi da tꞌaxki njanguꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nꞌa mbi hyandatho yá ma̱xte mi ꞌba̱hnu̱ ar Elia ne ar Moise mi ñöwi ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nuꞌmú̱ ar Pedro bi ꞌñemba ar Hesu: —Ma tsi Utateꞌi, xiñho ga ꞌbu̱hu̱wa. Te gi mö, ga hoje hñu ya mꞌetꞌe, nꞌa habu̱ gi ꞌbu̱ke, nꞌa habu̱ da mꞌu̱ ar Moise, ne manꞌa habu̱ da mꞌu̱ ar Elia. ");
INSERT INTO otqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ar Pedro mi mönga njapꞌu̱, ngetho himi pödi teme nda mö, xa xki zuyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nꞌa mba eta nꞌar gui bi goꞌmtho, ne bi nhekinu̱ nꞌar mhö bi ꞌñenö: —Gehnu̱ ma hmöka Tꞌu̱. ꞌYo̱hu̱ nöꞌö xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mꞌe̱fa mi mengi bi hyantꞌu̱ manꞌagi, ho̱nse̱ ar Hesu mi ꞌba̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ne mi göꞌu̱ har tꞌo̱ho̱, bi hñuꞌmba yá mu̱iꞌu̱ hinto nda xipabi nöꞌö xki hyantꞌu̱, nda do̱ꞌmi mꞌe̱tꞌo nda mengi nda nte manꞌagi Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bi kwatathoꞌu̱ nunar mhönu̱, ne mi ñöꞌu̱ nꞌa ngu nꞌa teme ndi bo̱nga nöꞌö xki mö, nda mengi nda nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne bi ꞌya̱mbabiꞌu̱ ar Hesu: —Yoꞌö enga ya bötꞌofo, mꞌe̱tꞌo ma da e ar Elia, ne ka da e ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Xa majöni ar Elia da e mꞌe̱tꞌo, ne da ꞌñexa xiñho manꞌagi gatho te jawa. Xiꞌmu̱, yoꞌö xi tꞌotꞌa har Tꞌofo, Nöꞌö Togo ba e bi Njöꞌi ma da tho ya thogi, ne hinte ma da nhu. ");
INSERT INTO otqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ha di xiꞌahu̱, ar Elia ba ehe, ne bi ꞌyo̱tꞌwabi gatho nöꞌö mi ne ya jöꞌi, ngu xki tꞌotꞌi nda thoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nu mi zo̱ñꞌö habu̱ mi ꞌbu̱ yá ma̱xte, bi hyandi nze̱ye̱ ya jöꞌi xa xki gotꞌatho, ne mi ñöwi ya bötꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne mi zo̱ꞌö, gatho ya jöꞌi xa bi ꞌyo̱tho, bi nixtꞌi ma ba tsu̱di ne bi ze̱ngwa. ");
INSERT INTO otqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nöꞌö bi ꞌya̱mbabi: —Tema gi ñöwihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bi dö nꞌa mi ꞌbu̱ har mutꞌi, ne bi ꞌñenö: —Tsi Utate, da tsiñꞌa ma tꞌu̱ nthe̱xkwi nꞌar tsꞌondöhi japi da ngone. ");
INSERT INTO otqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Habu̱ gatho da zu̱di xa hwötsꞌi, ne japi da ꞌye̱ntsꞌa ya fu̱gi hár ne, xa guxtꞌa yá tsꞌi, ne ꞌramtxꞌu̱ di ꞌyotꞌi. Da xipa nuya ri ma̱xte nda ꞌye̱mhö, ne hinte bi japabi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bi döꞌö ne bi ꞌñenö: —Yá bötsiꞌihu̱ ya me̱ꞌsku. Hangu ma ga ꞌbu̱hwithohu̱ ne ga pe̱sꞌahu̱ ar tsꞌe̱ti. Ba tsinju̱wa ar metsi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne ba tsꞌimpabi. Ha nunar tsꞌondöhi mi hyanda ar Hesu, xa bi hwöꞌsa ar bötsi, mi zo har ha̱i xa mi ntöni, ne xa mi e̱ntsꞌa ya fu̱gi hár ne. ");
INSERT INTO otqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ar Hesu bi ꞌya̱mba ár dada: —Hangu pe̱tsꞌi njanu̱. Ar dada bi dödi ne bi ꞌñenö: —Bi du̱ꞌmbabi mi tꞌu̱lotho. ");
INSERT INTO otqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nꞌandi e̱ntꞌa har tsibi ne har dehe, ne da hyohmö. Ha nuꞌmu̱ da tsa̱ te gi japi, pe̱ꞌskagihe ar nhwëki ne fa̱xkagihe. ");
INSERT INTO otqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ar Hesu bi ꞌñembabi: —Nuꞌmu̱ da tsa̱ gi ñꞌemu̱i hö, ngetho nöꞌö togo ñꞌemu̱i, hinter ñhembibi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ne nꞌagitho ár dada ar bötsi bi ñö ntsꞌe̱di ne bi ꞌñenö: —Di ñꞌemu̱i. Fa̱xkagi da hñuxa ma ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nu mi hyanda ar Hesu ya jöꞌi mi ntutsꞌi mi kwatꞌi, bi zu̱ ar tsꞌondöhi ne bi ꞌñembabi: —Tsꞌondöhi gone ne gogu, di ꞌbe̱pꞌaꞌi gi hye̱hnu̱, ne hingi pengi gi ku̱tꞌa manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nuꞌmú̱ ar tsꞌondöhi xa bi hye̱xa ar mhafi, ne xa bi nhwöste bi bo̱ni. Ne nunar bötsi bi gohnu̱ wande xki du, jange nze̱ye̱ mi enö: —Xi du. ");
INSERT INTO otqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ha nunar Hesu bi mipa ár ꞌye̱ bi ꞌñei, ne bi nangi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nu mi yu̱tꞌö har ngu, yá ma̱xte bi ꞌya̱mbase̱: —Yoꞌö himbi tsa̱ da e̱ñhe. ");
INSERT INTO otqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Har Hesu bi ꞌñembabi: —Nuya tsꞌondöhiyu̱ xi ñhembi da bo̱ni, mahyoni ar ntꞌa̱pa Jö ne ar bëhë. ");
INSERT INTO otqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ne mi bo̱nu̱ꞌu̱, bi ñꞌoꞌu̱ har ha̱i Ngalilea, ne himi neꞌö togo nda bödi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ngetho mi uta yá ma̱xte, ne mi embabi: —Nöꞌö Togo ba e bi Njöꞌi ma da nda̱twa yá ꞌye̱ ya jöꞌi, ne ma da tho. Ne ár hñupa da mengi da nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ne nuyá ma̱xte himi tso yá mfeni nöꞌö mi xipabiꞌö, ne mi tsu nda ꞌya̱mbabi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ne bi zo̱nga Nkapernaum, mi yu̱tꞌu̱ har ngu, ar Hesu bi ꞌya̱mbabi yá ma̱xte: —Te ngi mpehu̱ har ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ha nuꞌu̱ bi ñhetho, ngetho har ꞌñu mi ñöxhnathoꞌu̱, mi honi togo ma nda ntöte ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nuꞌmú̱ ar Hesu bi hñudi, ne bi zohna nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, ne bi ꞌñembabiꞌu̱: —Nöꞌö togo ne da mꞌu̱ mꞌe̱tꞌo, mahyoni xa da mꞌe̱fa, ne da me̱pa gatho nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bi gu̱ nꞌar tsi bötsi ne bi ꞌba̱ꞌma madetho, bi de̱tsꞌi, ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Nöꞌö togo da po̱tka ma thuhu japamasu nꞌar tsi bötsi, jakamasugi. Ha nöꞌö togo jakamasugi, go japamasu togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ar Xuwa bi ꞌñembabi: —Tsi Utate, xta hanthe nꞌa e̱nga ya tsꞌondöhi ju̱ñꞌa ár tsꞌe̱di ri thuhu. Da höjwe ngetho hindi ñꞌowihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ha nunar Hesu bi ꞌñembabi: —Yo gi hökwabihu̱, ngetho hinjoꞌo nꞌa togo di o̱tꞌa ya ntꞌudi ju̱nka ár tsꞌe̱di ma thuhu, ne mꞌe̱fa da ñömañꞌu̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngetho nöꞌö togo hingo ma ñꞌu̱nihu̱, fa̱xkagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nöꞌö togo da ꞌraꞌahu̱ nꞌar tsi ꞌbada ar dehe po̱tka ma thuhu ngetho yá me̱tiꞌihu̱ ar Kristo, xa majöni di xiꞌahu̱, hinda ma da ꞌbe̱ ár nthöhö. ");
INSERT INTO otqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nöꞌö togo da japi da da̱ nꞌa nuya tsi bötsi ñꞌemu̱igi, xiñho da tsꞌu̱twa nꞌar doju̱ni hár ꞌyu̱ga nöꞌö ar jöꞌiꞌö, ne da tꞌe̱ntꞌa har dehe. ");
INSERT INTO otqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nuꞌmu̱ ri ꞌye̱hu̱ da jaꞌahu̱ gi ta̱hu̱, hye̱ju̱. Xiñho gi ku̱thu̱ mhetsꞌi di kꞌatꞌa nꞌa ri ꞌye̱hu̱, ne hingi me̱wihu̱ gatho yoho ri ꞌye̱hu̱ har tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nunu̱ hingi the ya zuꞌwe, ha nunar tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ha nuꞌmu̱ ri wahu̱ jaꞌahu̱ gi ta̱hu̱, hye̱ju̱. Xiñho gi ku̱thu̱ mhetsꞌi hinte di tu ri wahu̱, ne hinge gi me̱wi ri wahu̱ har tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nunu̱ hingi the ya zuꞌwe, ha nunar tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ha nuꞌmu̱ ri da̱hu̱ jaꞌahu̱ gi ta̱hu̱, hñöhu̱. Xiñho gi ku̱thu̱ hár tsꞌu̱tꞌwi Jö di kꞌatꞌa nꞌa ri da̱hu̱, ne hingi me̱wihu̱ gatho yoho har tsibi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nunu̱ hingi the ya zuꞌwe, ha nunar tsibi hiñhamꞌu̱ da hwetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ngetho gatho ma da thoka har tsibi, jangu gatho ar mꞌo̱ñho̱ da tꞌu̱ꞌsa ar u. ");
INSERT INTO otqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ar u xiñho, ha nuꞌmu̱ da ꞌbe̱ ár ñꞌuxi, hanja gi koꞌsfu̱ ár nku̱hi. Di hñöxꞌahu̱ ar u, ne gi ꞌbu̱hu̱ nꞌar hogamꞌu̱i nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ar Hesu bi zohnu̱ nor ha̱iꞌö, bi gu̱ ar ꞌñu bi ma har ha̱i Nhudea ꞌrandi ar döthe Hordan. Ya jöꞌi bi mengi bi mhuntsꞌi, ne nöꞌö bi uti ngu xki nzöñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bi watꞌa ya de̱ngaꞌbe̱pate nda hya̱thmö, ne bi ꞌya̱mbabi ha nda tsa̱ nda hye̱ ár ꞌbe̱hñö nꞌar ñꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nöꞌö bi döti ne bi ꞌñembabi: —Te bi ꞌbe̱pꞌahu̱ ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nuꞌu̱ bi ꞌñeñꞌu̱: —Ar Moise bi unga ar se̱ki da tꞌunga nꞌar he̱ꞌmi ñhe̱gi, ne nda hye̱pꞌu̱ ár ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Bi ꞌyotꞌa njapꞌu̱ nunar ꞌbe̱patenu̱, ngetho xa xi me ri ñöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hár ndu̱i, Jö bi hyoka ar ndo̱ ne ar ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jange ar ñꞌo̱ho̱ da zopꞌu̱ ár dada ne ár nönö, ne da mꞌu̱hwi ár ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ne nuya yohoyu̱ da nꞌatho. Hindi yoho, nꞌase̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jange nöꞌö xi ju̱nga Jö, hinda ꞌweka ar jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nu mi zo̱ñꞌu̱ har ngu, nuyá ma̱xte bi mengi bi ꞌya̱mbabi nöꞌö xki wadi xki mö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ne ar Hesu bi ꞌñembabiꞌu̱: —Nöꞌö togo da hye̱ ár ꞌbe̱hñö ne da nthötwi manꞌa, nꞌar tsinganthöti. ");
INSERT INTO otqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ha nuꞌmu̱ ar ꞌbe̱hñö da hye̱ ár döme ne da nthötwi manꞌa, nꞌar tsinganthöti nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ne mi tsꞌimpa ya tsi bötsi nda hñuxyá ꞌye̱, ha nuyá ma̱xte mi tsu̱i togo mi tsihi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mi hyanda ar Hesu, bi zo̱tꞌa ár mu̱i, ne bi ꞌñembabiꞌu̱: —Hye̱hu̱ ya tsi bötsi da e da zu̱kagi, ne yo gi höjwu̱, ngetho gatho nuꞌu̱ ꞌbu̱ hár tsꞌu̱tꞌwi Jö, ñhe̱hwi nꞌar tsi bötsi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Xa majöni di xiꞌahu̱, nöꞌö togo hinda hñömba ár tsꞌu̱tꞌwi Jö ngu nꞌar tsi bötsi, hinda ma da yu̱tnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ne mi the̱xꞌu̱, mi huꞌspa yá ꞌye̱ ne mi jöpi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mi bo̱ñꞌö nda mengi nda gu̱ ar ꞌñu, ba e nꞌa mi nixtꞌi ne bi nda̱ndihmö hár waꞌö, ne bi ꞌñembabi: —Ma tsi hoga Utate, tema ga pe̱fi ne da tꞌaka ar te hinda götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ar Hesu bi ꞌñenö: —Yoꞌö gi engagi dar hogajöꞌi. Ho̱nse̱ Jö go ar hogajöꞌiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gi pötwa yá ꞌbe̱pate Jö: Yo gi tsimba ár nthöti ri ñꞌohu̱, yo gi ñhote, yo gi mpë, yo gi ju̱xa ya nhemhñö, yo gi ha̱te, ꞌñeꞌspa ár nsu ri dada ne ri nönö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bi dö nunar ñꞌo̱ho̱ ne bi ꞌñenö: —Utate, gathoyu̱ xta o̱tꞌe ndi bötsitho. ");
INSERT INTO otqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nuꞌmú̱ ar Hesu bi kꞌötꞌi xa mi mödi, ne bi ꞌñembabi: —ꞌBe̱ta nꞌa te gi pe̱fi: di ma ba pa̱ gatho nöꞌö te gi pe̱tsꞌi, ne hyembabi ya hyoya, njapꞌu̱ gi pe̱ꞌsa ya ñhonu̱ mañö mhetsꞌi. Ne gi ꞌye̱ntꞌa ri te gi e gi te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ha nöꞌö mi ꞌyo̱ nunar mhönu̱, xa bi du ár mu̱i ne njapꞌu̱ bi ma, ngetho xa mi the̱ nze̱ye̱ yá ñho. ");
INSERT INTO otqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nuꞌmú̱ ar Hesu bi hyanda hár nthetꞌi, ne bi ꞌñemba yá ma̱xte: —Xa xi ñhembi da yu̱tꞌa hár tsꞌu̱tꞌwi Jö nꞌar jöꞌi hinte kꞌatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nuyá ma̱xte xa bi ꞌyo̱da nöꞌö te bi möñꞌö. Ar Hesu bi döti ne bi ꞌñembabiꞌu̱: —Ma tsi bötsiꞌihu̱, xa xi ñhembi da yu̱tꞌa hár tsꞌu̱tꞌwi Jö nuꞌu̱ togo xi hñuxyá jamfi ha ya ñho. ");
INSERT INTO otqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xi ñhembi da tho nꞌar döta me̱ti hár gu nꞌar ꞌyomhni, ha töte ár ñhembi da yu̱tꞌa nꞌa hinte kꞌatꞌi hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nu mi ꞌyo̱ njapꞌu̱, bi hñuxa yá ꞌyo̱ꞌu̱, ne bi ꞌñeñꞌu̱ nꞌa ngu nꞌa: —Togo da mpo̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nuꞌmú̱ ar Hesu bi kꞌötꞌi, ne bi ꞌñembabi: —Nöꞌö hingi tsa̱ da ꞌyo̱tꞌa ya jöꞌi, Jö hö, tsa̱ da ꞌyo̱tꞌö, ngetho Jö hinter ñhembibi da ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nuꞌmú̱ ar Pedro bi ndu̱i bi ꞌñembabi: —Nuje xta tsohe xo̱ge xta te̱ñꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ar Hesu bi dödi ne bi ꞌñenö: —Xa majöni di xiꞌahu̱, gatho nuꞌu̱ togo xi zopꞌu̱ ár ngu, yá jödö, yá nju, ár dada, ár nönö, ár ꞌbe̱hñö, yá bötsi, wa xpa tsopꞌu̱ yá ha̱i xi de̱ngagi mönga ar hoga mhö, ");
INSERT INTO otqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ma da hñuxa nꞌanthebe ár nze̱ye̱ nöꞌö xi zopꞌu̱: yá ngu, yá jödö, yá nju, yá nönö, yá bötsi, yá ha̱i, mödi da tho ya ntꞌu̱tsa nuya payu̱, ne mꞌe̱fa to̱ꞌma ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nze̱ye̱ nuꞌu̱ ꞌbe̱tꞌopya ma da mꞌe̱fa, ha nuꞌu̱ togo ꞌbe̱fapya ma da mꞌe̱tꞌoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mi ꞌyo ar ꞌñuꞌu̱ ndi ma Herusalen, ar Hesu mi ꞌbe̱tꞌo, ha nuyá ma̱xte xa mi ꞌyo̱tho, mi te̱ni mi ntsuꞌu̱. Nuꞌmú̱ bi mengi bi ꞌweka nuꞌu̱ ꞌre̱tꞌamayoho, ne bi mu̱di bi xipabi nuya thogi ma nda thogi. Bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Nupya gar möhö har hnini Herusalen, ne Nöꞌö Togo ba e bi Njöꞌi ma da tꞌe̱ntꞌwa ha yá ꞌye̱ ya ndömöjö ne ya bötꞌofo. Ma da ꞌye̱ntꞌu̱ da tho, ne da nda̱twa ha yá ꞌye̱ nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ne ma da tsꞌani, ma da nꞌwe̱tꞌi, ma da tsꞌotsꞌi ne da tho, ha nu ár hñupa ma da mengi da nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nuꞌmú̱ ar Hakobo ne ar Xuwa yá tꞌu̱ ar Sebedeo, bi watꞌa habu̱ mi ꞌbu̱ ar Hesu, ne bi ꞌñembabi: —Tsi Utate, di nehe gi ja ar möte gi ꞌraje nöꞌö ma ga a̱ꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nöꞌö bi ꞌñembabi: —Tema gi ne ga ꞌraꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bi ꞌñeñꞌu̱: —ꞌRakagihe ar se̱ki xka tso̱ñhe ha ri nsunda, nꞌa da hñuxa ha ri ñꞌe̱i, ne manꞌa ha ri ngöhö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Hingi pöhu̱ tema gi a̱hu̱. Ha gi hanthu̱ gi tse̱thu̱ ya thogi ngu ma ga tse̱tka. ");
INSERT INTO otqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nuꞌu̱ bi dödi ne bi ꞌñeñꞌu̱: —Hö ga tse̱the. Ar Hesu bi ꞌñembabiꞌu̱: —Majöni ma gi thohu̱ ya thogi ngu ma ga thoka. ");
INSERT INTO otqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mödi njapꞌu̱, nöꞌö gi ne gi hñuxu̱ ha ma ñꞌe̱i ne ha ma ngöhö, hinda tsa̱ ga unga. Ma da tꞌumba nuꞌu̱ togo xi tꞌe̱kwabi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nu mi ꞌyo̱ nuꞌu̱ ma ꞌre̱tꞌa yá ma̱xte, bi ndu̱i bi mbo̱ yá kwe̱, himi numañho ar Hakobo ne ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nuꞌmú̱ ar Hesu bi zoñꞌu̱ ne bi ꞌñembabi: —Gi pöhu̱, nuꞌu̱ togo xi tꞌexa ngu ar ndö ha nꞌar ha̱i, exyá nsu, ne nuya xi tꞌexa ngu ar ñöxhmu, xa memnda ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nuꞌahu̱ yo gi njahu̱pꞌu̱. Nuꞌmu̱ gi ne gi ndötahu̱, mahyoni gi pe̱fu̱ nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne nöꞌö togo gi ne gi ꞌbe̱tꞌohu̱, mahyoni gi mꞌe̱gohu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jahu̱ ngu Nöꞌö Togo ba e bi Njöꞌi. Nöꞌö himba ehe honi togo da me̱pabi, ba ehe da mꞌe̱go, ne da unga ár te da gutꞌwa yá tha̱i nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ba eꞌu̱ Nheriko, ne núꞌmu̱ mi ꞌyo ndi bo̱ni, mi ñꞌowi yá ma̱xte, ne nze̱ye̱ ya jöꞌi mi te̱ni. Ar goda̱ Bartimeo, ár tꞌu̱ ar Timeo, mi hu har ꞌñu mi pe̱ti. ");
INSERT INTO otqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ne mi ꞌyo̱de mar Hesu me Nasare nöꞌö mi thohnu̱, bi ndu̱i bi mafi mi enö: —Hesu, ár tꞌu̱ꞌi ar Dabi, hwëgagi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nze̱ye̱ mi tsu̱i hinge nda mafi, ha nöꞌö xa mi umbár mu̱i mi mafi: —Ár tꞌu̱ꞌi ar Dabi, hwëgagi. ");
INSERT INTO otqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nuꞌmú̱ ar Hesu bi mꞌa̱i ne bi mö nda tsꞌohna ar goda̱, ne bi nsipabi njawa: —Yo gi tu ri mu̱i. Nangi ngutꞌa, zoꞌaꞌi gi ma ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nuꞌmú̱ bi ꞌye̱mpꞌu̱ ár pa̱tꞌi, dama bi nangi ba e bi zu̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ar Hesu bi ꞌñembabi: —Te gi ne ga jaꞌaꞌi. Ar goda̱ bi ꞌñenö: —Tsi Utate, di ne da xo ma da̱. ");
INSERT INTO otqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ar Hesu bi ꞌñenö: —Di ma, nuna ri ñꞌemu̱i xi ma̱xꞌaꞌi xka hñöni. Ne nꞌagitho bi tsa̱ bi hyandi, ne bi de̱nga ar Hesu har ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Núꞌmu̱ mi ꞌbu̱tho nda zo̱nga har hnini Herusalen, mi paꞌu̱ getꞌu̱ ha ya tꞌu̱lo hnini Betfage ne Betania, mi ku̱xa har tꞌo̱ho̱ Njömdo̱ni. Ne ar Hesu bi me̱hna yoho yá ma̱xte, ");
INSERT INTO otqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ne bi ꞌñembabi: —Di möhu̱ har tꞌu̱lo hnini gi hanthu̱ ꞌbu̱hnu̱, ne nu xki tso̱ñhu̱, ma gi tiñhu̱ nꞌar tsi tꞌu̱lo nꞌo̱ge di thötꞌi hinto xi nto̱ge. Gi xothu̱ ne gi tsihu̱ injawa. ");
INSERT INTO otqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ha nuꞌmu̱ togo da ꞌñeñꞌahu̱: Yoꞌö gi pe̱hu̱ njapꞌu̱, ꞌñemfu̱: Ar tsi Hmu honi, ne mꞌe̱fa da mengi da kosꞌa manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bi maꞌu̱ ne bi dinga nꞌar tsi nꞌo̱ge mi thötꞌa hár goxthi nꞌar ngu mi ꞌbu̱ta hár ñöni ar ꞌñu, ne bi xotꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ne ꞌra nuꞌu̱ mi ꞌbu̱hnu̱ bi ꞌñembabi: —Te gi pe̱hu̱ gi xothu̱ nunar tsi nꞌo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nuya ma̱xte bi ꞌñemba ngu xki xipabi ar Hesu, ne bi hye̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ne ba tsꞌimpa ar tsi tꞌu̱lo nꞌo̱ge ar Hesu, ne bi göꞌspa yá pa̱tꞌiꞌu̱, ne bi nto̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ne nze̱ye̱ mi xi yá pa̱tꞌi har ꞌñu, ha maꞌra mi tokwa ya xiza ne mi po̱kwa habu̱ nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nuꞌu̱ mi ꞌbe̱tꞌo ne nuꞌu̱ mi ꞌbe̱fa mi maꞌu̱ ne mi enö: —Xa nsunda Jö. Dá jöpa Jö ár mꞌe̱hni. ");
INSERT INTO otqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dá jöpa Jö ár tsꞌu̱tꞌwi ma palehu̱ ar Dabi xi ꞌñepꞌu̱. Nsunda Jö bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ne bi yu̱tꞌa ar Hesu núnu̱ Herusalen ne har dönganijö. Ne mi wadi bi hyanda gatho ár nthetꞌi, bi menga Betania bi me̱wi yá ma̱xte, ngetho mi fu̱di nda nxui. ");
INSERT INTO otqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nu ár hyaxꞌö mi bo̱ñꞌu̱ har hnini Betania, ar Hesu bi ntunthu. ");
INSERT INTO otqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bi hyanda yapꞌu̱ nꞌar ꞌba̱iꞌiuxi xa mi heda yá xi, bi ma ba kꞌöni, xömhö nda dinga te nda zi. Núꞌmu̱ mi zo̱ni hinte bi dini ngetho himyá pa ya iuxi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nuꞌmú̱ bi ꞌñemba ar ꞌba̱iꞌiuxi: —Hinto manꞌa da zimpꞌa ri sofo. Ne nuyá ma̱xte bi ꞌyo̱ tema xki mö. ");
INSERT INTO otqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ba eꞌu̱ Herusalen ꞌmu̱, ne mi yu̱tꞌa ar Hesu hár thi ar dönganijö, bi mu̱di bi ꞌye̱nga nuꞌu̱ togo mi mpa̱ ne mi nta̱i. Ne bi pu̱spa yá mexa ya pa̱tbojö, ne yá nthutsꞌi nuꞌu̱ mi pa̱ ya domtxu. ");
INSERT INTO otqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne hinto mi he̱gi nda naꞌsa ar nijö te mi mutsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne mi utwabi njawa: —Ha hinxka nehu̱ habu̱ enö: Ma ngu nꞌar ngu habu̱ da matꞌa Jö gatho ya hnini ꞌbu̱ har nxidi ar ximha̱i. Ha nuꞌahu̱ xka jafu̱ ngu nꞌar oki habu̱ ñꞌönga ya bë. ");
INSERT INTO otqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ne bi ꞌyo̱ nuya bötꞌofo ne nuya ndömöjö, mi honga hanja nda hyohmö. Himi tsa̱ te nda japꞌu̱, mi tsu ya jöꞌi, ngetho xa mi numañhoꞌu̱ ár ntꞌuti mi udi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ha mi nxui ar Hesu bi zohnu̱ ar hnini, bi ma. ");
INSERT INTO otqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ne mi thohnu̱ manꞌagi ár hyaxꞌö, bi hyantꞌu̱ xki ꞌyotꞌa ar iuxi xo̱ge ár ꞌba̱i ne yá ꞌyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nuꞌmú̱ ar Pedro bi beni, ne bi ꞌñembabi: —Utate, ndi nunar ꞌba̱iꞌiuxi ga tsu̱i, bi ꞌyotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bi dö ar Hesu ne bi ꞌñembabi: —Ñꞌemu̱ihu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngetho majöni di xiꞌahu̱, nöꞌö togo da xipa nunar tꞌo̱ho̱nu̱: ꞌBa̱i di ma ba tso har ñho̱nthe, ne hindi yomi, ne ka̱xmbeni da njapꞌu̱, ma da thogi nöꞌö xi beni. ");
INSERT INTO otqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jange di xiꞌahu̱, gatho nöꞌö gi ꞌya̱fu̱ Jö, ka̱xmbenihu̱ ma gi hñöñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne núꞌmu̱ gi a̱fu̱ Jö, pumbabihu̱ maꞌra nuꞌmu̱ ja te gi tsa̱mañꞌu̱hu̱, ne njapꞌu̱ ri Dadahu̱ bi ꞌbu̱ mhetsꞌi da pumpꞌaꞌihu̱ ri tsꞌokihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ngetho nuꞌmu̱ hingi pumbabihu̱ maꞌra, ri Dadahu̱ bi ꞌbu̱ mhetsꞌi hinda pumpꞌaꞌihu̱ ri tsꞌokihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ba penkꞌu̱ manꞌagi har hnini Herusalen, ne nu mi ꞌyo har dönganijö, ba e bi zu̱ ya ndömöjö, ya bötꞌofo ne ya dönziandö, ");
INSERT INTO otqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ne bi ꞌñembabiꞌu̱: —Togo gi hömpa ár tsꞌe̱di, ne togo xpa pe̱ñꞌaꞌi gi ꞌyo̱tꞌa nöꞌö gi pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Ma ga a̱ñꞌahu̱ nꞌar ntꞌa̱ni nꞌehe. Nuꞌmu̱ gi thöhu̱, ma ga xiꞌahu̱ togo di hömpa ár tsꞌe̱di ga o̱tꞌa nöꞌö di pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nunár xixthe ar Xuwa, ha xki ꞌñe mhetsꞌi, wa xki me̱hnatho ya jöꞌi. Xikagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nuꞌu̱ mi ñöse̱ mi eñꞌu̱: —Nuꞌmu̱ ga xifu̱ ndi ꞌñe mhetsꞌi, ma da ꞌñengagihu̱ ꞌmu̱: Yoꞌö hinga ñꞌemu̱ibihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ha nuꞌmu̱ ga eñhu̱ xki me̱hnatho ya jöꞌi, ma da mbo̱ yá kwe̱yu̱. Mi tsu ya jöꞌi, ngetho mi nuꞌu̱ ar Xuwa ngu ár mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jange bi döꞌu̱ ne bi ꞌñembabi ar Hesu: —Hindi pöhe. Nuꞌmú̱ bi döꞌö ne bi ꞌñembabiꞌu̱ nꞌehe: —Njapꞌu̱ nuga hinga xiꞌahu̱ togo xpa pe̱nkagi ga o̱tꞌa nöꞌö di pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nuꞌmú̱ ar Hesu bi ndu̱i mi utamꞌede: —Nꞌar ñꞌo̱ho̱ bi ꞌñetꞌa nꞌar hwöhiꞌobxi, bi guxa nꞌar jödo, ne bi ꞌya̱ꞌma nꞌar moto habu̱ nda de̱ꞌmi. Bi hyoka nꞌar heꞌsangu nda hyanda xo̱ge. Mꞌe̱fa bi umba ñhandi maꞌra nda su, ne bi ma yapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mi zo̱nga ar pa bi me̱hna nꞌar ꞌbe̱go ma nda kꞌöꞌsa ya ñhandi, ne nda ꞌya̱pa ar sofo ndi ꞌñepi nda hñöni. ");
INSERT INTO otqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ha nuꞌu̱ bi gu̱ bi fe̱nza ne bi kotsꞌi, ho̱nse̱ yá ꞌye̱ bi hñötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nöꞌö togo már me̱ti ar hwöhi, bi mengi bi me̱mpabi manꞌar ꞌbe̱go. Nuyu̱ bi hyo̱xa ya nkꞌahni, bi ze̱mba ár ñö ne bi kosꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bi mengi bi me̱hna manꞌa, ne nunu̱ bi tho. Ne njapꞌu̱ bi mengi bi me̱hna nze̱ye̱, ꞌra mi fe̱nza ne maꞌra mi ho. ");
INSERT INTO otqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ár ngötsꞌi, mi ꞌñe nꞌár tꞌu̱ xa mi mödi, bi me̱mpabi nꞌehe, mi eñꞌö: Numa tꞌu̱ ma da numansu. ");
INSERT INTO otqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nuya ꞌbe̱goꞌu̱ bi ꞌñenga nꞌa ngu nꞌa: Gehnu̱ togo ma da gohwi ya ñho. Ba ehu̱ ga hohu̱ ne ga kohwihu̱ yá ñho. ");
INSERT INTO otqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ne bi gu̱ꞌu̱ bi hyo, ne bi ꞌye̱ñꞌu̱ nthi har hwöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tema da me̱hmö nuna togo ár me̱ti ar hwöhi ꞌmu̱. Ma da ehe ne da hyo ya tsꞌoñhandi, ne da thokwa ár ꞌbe̱fi maꞌra ya ꞌbe̱go. ");
INSERT INTO otqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ha hinxka nehu̱ nunar tꞌofonu̱ enga njawa: Nöꞌö ar do bi ꞌye̱mpꞌu̱hmö ya guxjödo, nupya gehnu̱ ar mu̱di do xi njuꞌspa ár nijö Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gese̱ Jö xi ꞌyo̱tꞌa njapꞌu̱, ne di hanthu̱ nza̱tho nöꞌö bi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nuya ndö xa mi nemhöꞌu̱ nda gu̱, ngetho bi zo yá mfeni go mi ho̱xꞌu̱ nunar ꞌbedenu̱. Ho̱nse̱ mi tsu nda mbo̱ yá kwe̱ ya jöꞌi mi ꞌbu̱hnu̱, jange bi zohnu̱ bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ba ꞌbe̱mpabi ꞌra ya de̱ngaꞌbe̱pate ne ꞌra yá ñꞌowi ar Erode, xömhö nda dinga te nda hyo̱xa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mi zo̱ꞌu̱ bi ꞌñembabi: —Utate, di pöhe gi mönga nöꞌö majöni, ne hinto gi tsu, ngetho hingi hwanta ya jöꞌi, majöni gi u ár ꞌñu Jö. Hage xiñho ga umfe ar bojö jotꞌa ar Sesar. Ga uñhe wa hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ha nöꞌö bi bötwa yá tsꞌomfeni, bi ꞌñembabiꞌu̱: —Yoꞌö gi ne gi hya̱kagihu̱. Ba hönkagihu̱ nꞌar bojö ga handi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nuꞌu̱ ba hömpa nꞌar bojö, ne bi ꞌñembabiꞌu̱: —Togo ár me̱ti ar hmi huxkwa ne nöꞌö te mö. Ne bi döꞌu̱: —Ár me̱ti ar Sesar. ");
INSERT INTO otqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Umfu̱ ar Sesar nöꞌö ár me̱tiꞌö, ne umfu̱ Jö nöꞌö ár me̱tiꞌö nꞌehe. Ne xa bi ꞌyo̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nuꞌmú̱ ba epꞌu̱ ya de̱ngamöjö nuꞌu̱ hingi ñꞌemu̱i da mengi da nte nuꞌu̱ xi du, ne bi ꞌya̱mbabi njawa: ");
INSERT INTO otqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Utate, ar Moise bi zogagihu̱ har tꞌofo, nuꞌmu̱ nꞌar ñꞌo̱ho̱ da du ne da zo ár ꞌbe̱hñö hinte xi dinga ar bötsi, nu ár jödö da nthötwi ar ꞌranxu, ne da gu̱ꞌspa ár thuhu ár jödö manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gi numhö: Mi ꞌbu̱ yoto ya ñꞌo̱ho̱ mi njödö. Nunar ꞌbe̱tꞌo bi nthöti, ne bi du hinte bi zo ar bötsi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ne nunár ñoho bi nthötwi ar ꞌranxu, ne bi du. Njapꞌu̱nu̱ himbi zokwa ar bötsi, ne nunár hñu bi njapꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ne bi njapꞌu̱ gatho yoto, ne hinte bi dinga ar bötsi. Ár ngötsꞌi bi du ar ꞌbe̱hñö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Núꞌmu̱ xta zo̱ ar menga nte, ne da nankꞌu̱, togo ár ꞌbe̱hñönu̱ ꞌmu̱, ngetho bi nthötwi gatho yoto ya ñꞌo̱ho̱ mi njödö. ");
INSERT INTO otqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Xi tsꞌoka ri mfenihu̱, ngetho hingi pöhu̱ ar Tꞌofo, ne hingi pöthwu̱ ár tsꞌe̱di Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngetho nu xta mengi da nte ya jöꞌi manꞌagi, hinda ma da tꞌa̱di, ne hinda ma da nthöti, ngetho ma da ñhe̱hwi yá e̱nxe̱ Jö bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ha nöꞌö ntꞌa̱ni wa pengi da nte nuꞌu̱ xi du wa hinꞌö, ha hinxka nehu̱ hár tꞌofo ar Moise núꞌmu̱ mi zo Jö ha nꞌar ꞌminza mi zo̱, ne bi ꞌñembabi: Nuga ár Jögi ar Abra, ar Isa, ne ar Hakob. ");
INSERT INTO otqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jö go ár Jö nuꞌu̱ te, hinge nuꞌu̱ xi du. Jange nuꞌahu̱ xa xka ꞌbe̱ ri mfenihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bi watꞌa nꞌar bötꞌofo xki ꞌyo̱de xki dödi xiñho, ne bi ꞌya̱mbabi: —Ndana ar ꞌbe̱pate töpa ár nsu gatho nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ar Hesu bi döti: —Nunar ꞌbe̱tꞌo ꞌbe̱pate gehnu̱: Ha gi o̱hu̱, menguhu̱ Israel. Ar tsi Hmu ma Jöhu̱, nꞌatho. ");
INSERT INTO otqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Xa gi ꞌñetꞌa ri mu̱i, gi hñuxa ri mfeni, gi ꞌye̱ntꞌa ri te ne ri tsꞌe̱di gi mö Jö ri Hmu. Gehnu̱ ar ꞌbe̱pate töte ár tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ne nor ñoho di hñötsꞌi: Gi mö ri mijöꞌiwi ngu gi mhöse̱. Hiñꞌotho manꞌar ꞌbe̱pate di töte ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nuꞌmú̱ nunar bötꞌofo bi ꞌñembabi: —Xiñho, Utate. Majöni nöꞌö xka mö, nꞌadar Jö ꞌbu̱i ne hinjoꞌo manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne nöꞌö togo etꞌa ár mu̱i, huxa ár mfeni, e̱ntꞌa ár te ne ár tsꞌe̱di da mö Jö, ne da mö ár mijöꞌiwi ngu mhöse̱, töpa ár nsu gatho nuya mꞌo̱ñho̱ ne ya ñhötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ar Hesu nu mi hyandi mi ja ár mfödi, bi dödi ne bi ꞌñembabi: —Hingi ꞌyo yapꞌu̱ gi ku̱tꞌa hár tsꞌu̱tꞌwi Jö. Ne hinto bi ne bi ꞌyo̱tꞌwa maꞌra ya ntꞌa̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ar Hesu mi uta ya jöꞌi har dönganijö, ne mi enö: —Yoꞌö enga nuya bötꞌofo ar Kristo ár tꞌu̱ ar Dabi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngetho gese̱ ar Dabi bi ꞌñenö xki nzinga ár Hñö Jö: Jö ar Dada bi ꞌñemba ma tsi Hmu: Hñu ha ma ñꞌe̱i ga huxkwi, to̱ꞌmi ga tsiñꞌa nuya ri ñꞌu̱ni ga tse̱pꞌa ha ri wa. ");
INSERT INTO otqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Gese̱ ar Dabi embabi ár Hmu. Yoꞌö mhö ár tꞌu̱ ꞌmu̱. Ne nze̱ye̱ ya jöꞌi xa mi johya mi o̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ar Hesu mi embabi ya jöꞌi ha yá ntꞌuti: —Jamasuhu̱ hinda kaꞌahu̱ ya bötꞌofo, xa ne da ñꞌo di he yá dutu koꞌmba yá wa, ne xa ne da nze̱ngwabi ya jöꞌi di ꞌbe̱nga ntꞌekꞌei núꞌmu̱ ꞌyo har ta̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Xa ne da hñuxa ha ya ꞌbe̱tꞌo nthutsꞌi ha ya nijö ne ha ya ñhuni. ");
INSERT INTO otqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nuyu̱ tekwa yá ngu ya tsi ꞌranxu, ne o̱tꞌa ꞌra ya nsa̱di ra ma, ne da goꞌmahmö. Njapꞌu̱ ma da hñönga nꞌa ra döta mfe̱iyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ar Hesu mi huhnu̱ mi ñhandwitho ár ntꞌu̱tmꞌo̱ñho̱ ar nijö. Mi handi hanja ya jöꞌi mi pa mi tsohnu̱ yá mꞌo̱ñho̱, ne nuꞌu̱ mi pe̱ꞌsa yá ñho xa mi u̱tꞌa nze̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ne ba e nꞌar tsi hyoya ꞌranxu, bi ꞌyu̱tꞌa yoho ya tsi bojö himar mhödi. ");
INSERT INTO otqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nuꞌmú̱ ar Hesu bi matꞌa yá ma̱xte, ne bi ꞌñembabi: —Xa majöni di xiꞌahu̱, nunar tsi hyoya ꞌranxunu̱, töte ár döta ár mꞌo̱ñho̱, xi döta gatho nu maꞌra unga yá mꞌo̱ñho̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ngetho gatho xi unga nöꞌö pongwabi. Ha nunu̱, mödi mi hyoya, bi unga gatho nöꞌö mi pe̱ꞌshmö nda zi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mi bo̱nga ar Hesu har dönganijö, nꞌa nuyá ma̱xte bi ꞌñembabi: —Utate, ndi, tengu ár nza̱tho ya do ne ár ñhetsꞌi yá jödo ar nijö. ");
INSERT INTO otqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ar Hesu bi dödi ne bi ꞌñenö: —Ha gi handa nuya döta jödoyu̱. Gatho ma da thextꞌi, hinda ma da go nꞌar do mañör midowi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mi zo̱nga ar Hesu har tꞌo̱ho̱ Njömdo̱ni, bi hñudi mi ñhandwi ar dönganijö. Ha nu ar Pedro, ar Hakobo, ar Xuwa, ne ar Andre bi ꞌya̱mbase̱: ");
INSERT INTO otqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Xikagihe, hamꞌu̱ ma da tho gathoyu̱. Tema ntꞌudi ma da nheki, ne da födi ꞌba̱pꞌu̱tho da göxa gathoyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ar Hesu bi dötwabiꞌu̱ ne bi ꞌñembabi: —Jamasuhu̱, yo ma gi ñhe̱hu̱ to da kaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ngetho ma da e nze̱ye̱ togo da gu̱mka ma thuhu da ꞌñenö: Nuga go dar Kristo. Ne njapꞌu̱ da ka nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ha núꞌmu̱ xki ꞌyo̱hu̱ habu̱ gatho di ja ya tuhni, ne maꞌra ma da ndu̱i, yo gi tu ri mu̱ihu̱. Ngetho mahyoni da tho njapꞌu̱, mödi hinxi zo̱ta ár ngötsꞌi ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ngetho ya hnini ma da ntukwi yá mihniniwi, ya ndö ma da ntunkwi yá mindöwi. Ne xa hagatho ma da nhwönga ar ha̱i, ne ma da nja ar thuhu, ne ya jöꞌi xa di mu̱xmatho. Ho̱nse̱ ár ndu̱inu̱ ya u̱gi xi ꞌñepꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ha ntsunse̱hu̱, ngetho ma da tsꞌixꞌahu̱ ha ya tsꞌu̱tꞌwi, ne da mfe̱nzaꞌihu̱ ha yá nijö ya xodyo. Ma da mꞌa̱pꞌahu̱ ha ya tsꞌu̱tꞌwi ne ya ndö ngetho gi te̱ngagihu̱, njapꞌu̱ da tsa̱ gi da̱thu̱ majöni xka pökagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ne mahyoni mꞌe̱tꞌo da mhönga ar hoga mhö ha gatho ya ha̱i jawa har ximha̱i, ne ka da e ar ngötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ha nuꞌahu̱, nu xta tsꞌixꞌahu̱ ma da nda̱tꞌahu̱ ha ya ndö, yo gi tu ri mu̱ihu̱ tema gi möñhu̱, ne hingi hyoñhu̱ tema gi thöhu̱. Geꞌmu̱ ma da tꞌaꞌahu̱ tema gi möñhu̱, ngetho hingo geꞌahu̱ togo gi ñöhu̱, go ñö ár Hñö Jö ꞌbu̱ ha ri mu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nuya njödö ma da da̱se̱ ár jödö da tho. Ne nuya dada ma da da̱se̱ yá bötsi, ha nuya bötsi ma da gu̱ yá dada da hyo. ");
INSERT INTO otqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ne gatho ma da u̱tsaꞌihu̱ ngetho gi te̱ngagihu̱. Nöꞌö da ze̱tatho, da do̱ꞌmi da göxa xo̱ge nuya thogiyu̱, go ma da mpo̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ha núꞌmu̱ xki hyanthu̱ ar tsꞌoki xi ntsꞌotho di ꞌbu̱ habu̱ hingi ho da mꞌu̱i, ngu bi ꞌyotꞌa ar mꞌe̱hni Dañe (nöꞌö togo nehe, dá bödi xiñho teme ne da mö), nuꞌu̱ togo gi ꞌbu̱hu̱nu̱ Nhudea, di ma ba ñꞌöñhu̱ ha ya tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nuꞌu̱ togo gi to̱hu̱ mañö ar ngu, yo ma gi ku̱thu̱ te gi ju̱ju̱. Nixtꞌi di möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ha nuꞌu̱ togo gi ꞌyohu̱ har ꞌbatha, yo ma gi penju̱ gi ju̱ju̱ ri pa̱tꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hwëkate nuꞌu̱ ya ꞌbe̱hñö di ñꞌu̱, ne nuꞌu̱ di tsi yá bötsi di tsu̱da nuya paꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ꞌYa̱pabihu̱ Jö, nunar pa gi nixtꞌihu̱, hinda da̱tꞌa ya pa xi ntse̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngetho nuya paꞌu̱ xa ma da nja ya thogi ngu hinxka hyanthu̱ manꞌa, núꞌmu̱ Jö bi hyoka ar ximha̱i, ne xta thogi hinda ma da nja manꞌa nguꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ha nuꞌmu̱ ar tsi Dada hinda japi da göxa nuya paꞌu̱, hinto ma da bonkꞌmu̱. Ma da jösꞌö, ngetho ma da ma̱xa togo xi hwañꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jange nuꞌmu̱ da tꞌeñꞌahu̱: Ndi, ka bi ꞌbu̱kwa ar Kristo, wa da tꞌeñꞌahu̱: Ndi, bi ꞌbu̱hnu̱, yo ma gi jafu̱masu. ");
INSERT INTO otqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngetho ma da nja ya kate Kristo ne ya kate mꞌe̱hni. Ne ma da ꞌyo̱tꞌa ya döta ntꞌudi da hya̱tꞌa ya jöꞌi, ne nuꞌmu̱ da tsa̱hmö, da hya̱tꞌa nuꞌu̱ xi hwahna ar tsi Dada. ");
INSERT INTO otqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ha nuꞌahu̱, zo̱tꞌa xiñho ri da̱hu̱, ngetho xta xiꞌahu̱ nöꞌö ma da thogi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Núꞌmu̱ xta göxa nuya paꞌu̱ ñꞌu̱tho, ar hyadi ma da mꞌe̱xui, ha nunar zönö hinda ma da unga ár hyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ne nuya tso̱ ma da hyo̱i, ha nuya tsꞌe̱di bi ꞌbu̱ mhetsꞌi ma da nhwötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ne ma gi hyanthu̱ ꞌmu̱ Nöꞌö Togo ba e bi Njöꞌi, ma da nheki di e ha ya gui, di hö nꞌar döta tsꞌe̱di ne nꞌar döta nsunda. ");
INSERT INTO otqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne ma da me̱hna yá e̱nxe̱ ꞌmu̱, da muspa gatho nuꞌu̱ togo xi hwañꞌö xo̱ge hár nxidi ar ximha̱i, ne habu̱ di göxa mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Hyanthu̱ ar ꞌba̱iꞌiuxi ne beñhu̱ tema utkagihu̱: Núꞌmu̱ po̱xa yá nꞌogi ne kꞌontsꞌa yá xi, gi pöhu̱ ꞌba̱pꞌu̱tho ar pahyadi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Njapꞌu̱ nuꞌahu̱ nꞌehe, nu xki hyanthu̱ da tho gatho nuya thogiyu̱, pöhu̱, ꞌba̱pꞌu̱tho da göxa xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Xa majöni di xiꞌahu̱, hinda theta nuya jöꞌi ꞌbu̱ nuya payu̱, ne xi wadi xi tho gatho nuya thogiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mödi da mꞌe̱di ar mhetsꞌi ne ar ximha̱i, nuya mhö xta mönga, hinda ma da mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nor pa hamꞌu̱ ma da göxa xo̱ge hinto pödi. Nuya e̱nxe̱ bi ꞌbu̱ mhetsꞌi hingi pöhmö nꞌehe, ne ár Tꞌu̱ Jö hingi pödi, ho̱nse̱ ar Dada go pöꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Zo̱thu̱ ri da̱hu̱, ndo̱ꞌmhu̱ ne ꞌya̱fu̱ Jö, ngetho hingi pöhu̱ hamꞌu̱ da zo̱ ar ngötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ñhe̱hwi nꞌar ñꞌo̱ho̱ bi ma yapꞌu̱, bi zo ár ngu ne bi umba ar tsꞌe̱di nuyá ꞌbe̱go. Bi zokwa yá ꞌbe̱fi nꞌa ngu nꞌa, ne ar sugoxthi bi xipabi hinge nda ñꞌöhö. ");
INSERT INTO otqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jange ndo̱ꞌmhu̱, ngetho hingi pöhu̱ tema xe̱nimpa da epꞌu̱ togo ár me̱ti ar ngu, wa xta nde, made nxui, hár mhafi ar boxi, wa xta hatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nuꞌmu̱ nꞌa nda epꞌu̱tho, hinda diñꞌahu̱ gi öthu̱ hingi to̱ꞌmhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ne nöꞌö di xiꞌahu̱, getꞌö di xipabi gatho: Ndo̱ꞌmhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ár yopapꞌu̱ mar baxjwa ne ar da̱ngo mi tsꞌi ar thuhme himi jotsꞌi, nuya ndömöjö ne ya bötꞌofo mi honga hanja nda gu̱ ar Hesu ñꞌöntho, ne nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ne mi eñꞌu̱: —Hinda tsa̱ ga ju̱hu̱ ha ya pa da̱ngo, ngetho da mu̱xma ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nu mi ꞌbu̱hnu̱ Mbetania hár ngu ar Simu xki hye̱ ar hñeni tsitꞌandoꞌyo, ne núꞌmu̱ mi hu har mexa, nꞌa mba epꞌu̱tho nꞌar ꞌbe̱hñö mi hö nꞌar xito tꞌaxdo, mi po nꞌar hogañu̱ni xa mar mhödi. Bi tehma nunar xito ne bi nöꞌspa ár ñö ar Hesu nunar hogañu̱ninu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ja ꞌra togo bi mbo̱ yá kwe̱, ne mi eñꞌu̱: —Yoꞌö xi tꞌe̱mpꞌu̱tho nunar hogañu̱ninu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngetho mi tsa̱ xi ꞌba̱ ngu nꞌa nje̱ye̱ ár nthöhö nꞌar jöꞌi, ne xi themba ya tsi hyoya. Ne xa mi theñꞌu̱ nuna tsi ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Hye̱hu̱nu̱. Yoꞌö gi theñhu̱. Nza̱tho nöꞌö xi ꞌyo̱tkagi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nuya hyoya hyaxꞌmu̱ ma gi ꞌbu̱hwihu̱, ne da tsa̱ gi ꞌyo̱thwu̱ ar ñho nuꞌmu̱ gi nehu̱. Ha nuga hinge hyaxꞌmu̱ ma gi hyandgagihu̱wa. ");
INSERT INTO otqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nunu̱ xi umbár mu̱i xi ꞌyo̱tꞌa nöꞌö mi tsa̱ nda me̱fi. Ne nunar hogañu̱ninu̱ xi goxkagi, gehnu̱ nꞌar ñhoki di to̱ꞌma ha ma ntꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Xa majöni di xiꞌahu̱, habu̱ gatho ma da mhönga nunar hoga mhönu̱ xo̱ge ár nxidi ar ximha̱i, ma da mhönga nöꞌö xi ꞌyo̱tnu̱ ngu nꞌar feni. ");
INSERT INTO otqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ar Huda Iskariote ꞌmu̱, nꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, bi ma ba kꞌönga ya ndömöjö, mi ne nda da̱twa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Núꞌmu̱ mi ꞌyo̱ꞌu̱ xa bi njohya, ne bi ñötꞌi nda umba ar bojö. Ha nunar Huda mi honi hanja nda tsa̱ nda da̱twabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nöꞌö ar pa bi ndu̱i ar da̱ngo tsꞌi ar thuhme hinxi jotsꞌi, núꞌmu̱ mi tho ngu nꞌar mꞌo̱ñho̱ ar ndöni mbaxjwa, nuyá ma̱xte ar Hesu bi ꞌñembabi: —Habu̱ gi ne ga hoje ar tꞌoximbaxjwa. ");
INSERT INTO otqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne bi me̱hna yoho yá ma̱xte, bi ꞌñembabiꞌu̱: —Di möhu̱ har hnini, ne nu xki nthe̱wihu̱ nꞌar ñꞌo̱ho̱ muxa nꞌar xo̱ni ar dehe, te̱ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nu habu̱ da yu̱tꞌi, gi ꞌñembabihu̱ nöꞌö togo ár me̱ti ar ngu: Ar Utate ba pe̱hna ar nze̱ngwa ga eñꞌahe njawa: Habu̱ ꞌbu̱ ar ngu di hoñhe ga tsiꞌbe ar tꞌoximbaxjwa ma ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ne nöꞌö ma da utꞌahu̱ nꞌar döta ngu di to̱ mañö, xi thoki xiñho. Ka gi hyoju̱nu̱ ar tꞌoximbaxjwa ga tsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nuyá ma̱xte mi zo̱ñꞌu̱ har hnini, bi diñꞌu̱ ngu xki nsipabi, ne bi hyoknu̱ ar tꞌoxi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nu mi nxui ar Hesu ba ehwi nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Núꞌmu̱ mi hñuhnu̱ har mexa mi ntꞌoxi, ar Hesu bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, nꞌa di ñungwihu̱, ma gi da̱gagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nuꞌu̱ xa bi du yá mu̱i, ne bi ndu̱i bi ꞌya̱mbabiꞌu̱ nꞌa ngu nꞌa: —Ha go geke. Ne manꞌa mi embabi: —Ha go nuga. ");
INSERT INTO otqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nöꞌö bi dödi ne bi ꞌñembabiꞌu̱: —Nꞌa nuꞌu̱ ꞌre̱tꞌamayoho togo nꞌadar mohi di thinthwu̱ mahye̱gi ar thuhme. ");
INSERT INTO otqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Majöni Nöꞌö Togo ba e bi Njöꞌi ꞌba̱ ar ꞌñu da tho ngu xi tꞌotꞌwabi, ne hwëkate nöꞌö togo ma da da̱ꞌö. Xiñhohmö hinxi zo̱kwa har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne núꞌmu̱ mi ntꞌoxꞌu̱, ar Hesu bi gu̱ ar thuhme ne bi ꞌya̱pa Jö nda jöpi. Bi heke bi hemba yá ma̱xte, ne bi ꞌñembabiꞌu̱: —Tsihu̱; gehnu̱ ma ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mꞌe̱fa bi gu̱xa ar tꞌe̱ni mi po ar tꞌafiꞌobxi, bi umba njamödi Jö, bi thokwa yá ma̱xte, ne gatho bi zi nꞌa tsi ntsꞌiki. ");
INSERT INTO otqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne bi ꞌñembabiꞌu̱: —Gehnu̱ ma ji ma da nhöꞌmi da epa ár ñho nze̱ye̱ ya jöꞌi, ne njapꞌu̱ da go ar ꞌraꞌyo nkohi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Di xiꞌahu̱, hinga pengi ga tsipa ár tꞌafi ar ꞌba̱iꞌobxi nuya payu̱. Ma ga to̱ꞌmi ga tsi maꞌraꞌyo hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nu mi wadi bi ntuꞌu̱ nꞌar jöhñö, bi bo̱ñꞌu̱ ndi ma har tꞌo̱ho̱ Njömdo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Nunar nxuinu̱ gatho ma gi hye̱gase̱gihu̱, ngetho xi tꞌotꞌa har Tꞌofo, enö njawa: Ma ga ho ar ma̱ꞌyo, ne da mfontꞌa xo̱ge yá de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ha núꞌmu̱ xka pengi ga nte manꞌagi, ma ga ꞌbe̱tꞌo gar nthe̱hu̱nu̱ Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nuꞌmú̱ ar Pedro bi ꞌñenö: —Mödi gatho nuꞌu̱ maꞌra da hye̱kꞌaꞌi, nuga hinga ma ga he̱kꞌase̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ha nu ar Hesu bi ꞌñembabi: —Xa majöni di xiꞌaꞌi, nunar nxuinu̱ hinxi zo̱ta ár ñoho ár mhafi ar boxi, ha nuꞌge ya xka ko̱ngagi hñuꞌgi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ha nunar Pedro himi tsa̱ya̱ mi enö: —Mödi ga tuga nꞌehe, hinga ko̱ñꞌaꞌi. Ne gatho nu maꞌra mi mönga njapꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ba eꞌu̱ núnu̱ habu̱ tꞌembabi ar Getsemani, ne ar Hesu bi ꞌñemba yá ma̱xte: —Hñuhu̱wa. Nuga ma ga a̱patsꞌu̱ Jö ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne bi zixa ar Pedro, ar Hakobo, ne ar Xuwa, ne bi ndu̱i xa bi du ár mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bi ꞌñembabiꞌu̱: —ꞌBu̱tho ga tu ar dumu̱i. Kohu̱wa ne ndo̱ꞌmhu̱, yo gi öhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bi tho manꞌa tsi tu̱i ár yapꞌu̱ ne ka bi nda̱ndihmönu̱. Ne bi ꞌya̱pa Jö, nuꞌmu̱ nda tsa̱hmö, hinge nda zo̱pabi nuya thogi ñꞌu̱tho mi epꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne mi enö: —Ma tsi Dadaꞌi, nuꞌge hinter ñhembiꞌi. Hñöga nuya thogi xi ꞌñepꞌu̱. Mödi hindi ne gi ꞌyo̱tꞌa ngu di nega, ꞌyo̱tꞌa ngu gi nege. ");
INSERT INTO otqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mꞌe̱fa ba ehe ne bi dinga nuya hñuyu̱ mi öhö, ne bi ꞌñemba ar Pedro: —Simu, ha gi öhö. Ha himbi tsa̱ ga nuta nꞌa tsi xe̱nimpa. ");
INSERT INTO otqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Zo̱tꞌa ri da̱hu̱ ne ꞌya̱fu̱ Jö gi tse̱thu̱ ya tsꞌothogi xta epꞌu̱. Xa majöni ri hñöhu̱ ꞌbu̱i da tse̱ti, ha nuna ri ndoꞌyohu̱ kꞌatꞌa ár tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bi ma ba a̱pa Jö manꞌagi, ne bi mengi bi xipa nuya mhö xki xipa mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nu mba pengi bi diñꞌu̱ mi öhö manꞌagi, ngetho nuyá da̱ꞌu̱ xa mi kö ya tꞌöhö, ne himi pöꞌu̱ te nda dödi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ba e ár hñuꞌgi, ne bi ꞌñembabiꞌu̱: —Nupya hö, te ri tꞌöhöhu̱ ne kö ri ndoꞌyohu̱. Xi zo̱ ar pa xi thutsꞌi, ma da nda̱twa ha yá ꞌye̱ ya ꞌyo̱tꞌatsꞌoki Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nanju̱ möhö, ba ehnu̱ nöꞌö togo ma da da̱gagi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Himi jwata nda ñö ar Hesu núꞌmu̱ mba epꞌu̱ ar Huda, nꞌa nuya ꞌre̱tꞌamayoho yá ma̱xte. Ne mi ñꞌowi nze̱ye̱ ya jöꞌi mi hö ya ndo̱jwai ne ya za, xki me̱hna ya ndömöjö, ya bötꞌofo, ne ya dönziandö. ");
INSERT INTO otqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ha nöꞌö togo mi da̱, xki nkohwi ya jöꞌi ne xki ꞌñembabi: —Nöꞌö togo gi hyanthu̱ ga tsu̱spa ár hmi, gehnu̱ gi hoñhu̱. Ju̱hu̱ ne xo̱thu̱ xiñho gi tsixu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nu mi zo̱ho̱, dama bi watꞌa habu̱ mi ꞌba̱ ar Hesu, ne bi ꞌñembabi: —Utate. Ne bi zu̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nuya jöꞌi ꞌmu̱, dama bi watꞌi ne bi gu̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ha nꞌa nuꞌu̱ mi ꞌbu̱hwinu̱, bi kꞌoꞌsa ár jwai, ne bi dakwa ár gu ár ꞌbe̱go ar döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nuꞌmú̱ ar Hesu bi ꞌñembabi ya jöꞌi: —Hage dar bë xka ehu̱ gi mikagihu̱, gi höhu̱ ya jwai ne ya za. ");
INSERT INTO otqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hyaxꞌmu̱ ndi ꞌbu̱hwihu̱ har dönganijö, ne hinte ga jaju̱. Ne xi njanu̱, njapꞌu̱ da tho ngu mönga har Tꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nuꞌmú̱ gatho nuyá ma̱xte bi zohnu̱ bi nixtꞌi bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ha nꞌar bötsi mi te̱ni, ho̱nse̱ xki mpa̱xa nꞌar dutu, ne nu mi nju̱, ");
INSERT INTO otqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","dama bi zopꞌu̱ ar dutu ne bi nixtꞌi ngo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba tsꞌi ar Hesu bi mꞌa̱mba ar döngamöjö, ne bi watꞌa gatho ya ndömöjö, ya dönziandö ne ya bötꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ha nunar Pedro bi de̱nda yapꞌu̱, ne bi zo̱nga hár thi ar döngamöjö, bi hñuhwi ya ndogu mi mpatꞌa har tsibi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nuya ndömöjö ne gatho ar mhuntsꞌandö, mi honga te nda hyo̱xa ar Hesu ne nda tꞌe̱ntꞌi nda tho, hinte mi tiñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ngetho nze̱ye̱ mi ho̱xa ya nhemhñö, mödi himi nthe̱xkwi nöꞌö te mi möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nꞌa mbi mꞌa̱ta ꞌra bi hyo̱xa ya nhemhñö, mi eñꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nuje xta o̱he xi ꞌñenö: Nuga ma ga yo̱tꞌa nunar nijönu̱ xi hyoka ar jöꞌi, ne ár hñupa ga pengi ga ju̱xa manꞌa, hinte ma jöꞌi xi hyoki. ");
INSERT INTO otqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ha nuyu̱ nꞌehe himi nthe̱ nöꞌö mi möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nuꞌmú̱ ar döngamöjö bi mꞌa̱ made ne bi ꞌñemba ar Hesu: —Ha hinte gi thödi. Te di bo̱nga nöꞌö tho̱xꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nöꞌö mi ñhetho, hinte bi dödi. Ar döngamöjö bi mengi bi ꞌya̱ni ne bi ꞌñenö: —Hage go geꞌe ar Kristo, ár Tꞌu̱ nöꞌö togo nsundabi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ne ar Hesu bi ꞌñembabi: —Hö, go geke. Ne ma gi hyanthu̱ Nöꞌö Togo ba e bi Njöꞌi di hu hár ñꞌe̱i Jö togo pe̱ꞌsa gatho ar tsꞌe̱di, ne di ehnu̱ ha ya gui mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nuꞌmú̱ ar döngamöjö bi xika ár he, ngetho mi beni ar Hesu xki ñömañꞌu̱bi Jö, ne bi ꞌñenö: —Te ga jafu̱ manꞌa te da hyo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Xka ꞌyo̱hu̱ teme xi mö. Te gi möñhu̱. Ne gathoꞌu̱ bi hyo̱xꞌu̱ ndi ꞌñepi nda tho. ");
INSERT INTO otqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ne ꞌra bi mu̱di mi tsotsꞌi. Mi kotwa yá da̱ ne xa mi umba ya mfe̱i, ne mi embabi: —Xije togo bi me̱pꞌaꞌi. Ne nuya ndogu xa mi umba ya mpe̱tgu. ");
INSERT INTO otqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ar Pedro mi ꞌbu̱hnu̱ ha̱i har thi, ne nꞌa mba epꞌu̱tho nꞌar ꞌbe̱hñö mi pe̱pa ar döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ne mi hyanda ar Pedro mi mpatꞌa har tsibi, bi ꞌñenö: —Nuꞌge nꞌehe ngi ñꞌowi ar Hesu me Nasare. ");
INSERT INTO otqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ha nöꞌö bi nko̱ni bi ꞌñenö: —Hindi pöka togoꞌö. Hindi pöhmö tema gi mö. Ne bi watꞌa har goxthi. Ne geꞌmu̱ bi ma ar boxi. ");
INSERT INTO otqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ne nunar ꞌbe̱hñönu̱ mi hyanda manꞌagi, bi mu̱di bi ꞌñemba nuꞌu̱ mi ꞌbu̱hnu̱: —Nunu̱ go yá ñꞌohu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ha nöꞌö bi mengi bi nko̱nga manꞌagi. Ne hingar yaꞌö nuꞌu̱ mi ꞌbu̱hnu̱ bi mengi bi ꞌñembabi ar Pedro: —Majöni nuꞌge go ár ñꞌowiꞌu̱ nꞌehe, ngetho gar me Ngalilea, ne gi ñö mahye̱gi ngu ñöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nöꞌö bi ndu̱i bi ntsate ne mi etꞌa made Jö, mi enö: —Hindi pöka togo ar ñꞌo̱ho̱ gi no̱ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ne ar boxi bi ma ár ñoꞌgi. Nuꞌmú̱ ar Pedro bi benga nöꞌö te xki mönga ar Hesu: Hinxi zo̱ta ár ñoho ár mhafi ar boxi, ha nuꞌge ya xka ko̱ngagi hñuꞌgi. Mi oda ár mfeni njapꞌu̱, xa mi zoni. ");
INSERT INTO otqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ár hyaxꞌö ra nꞌitho, mi wadi bi nkoꞌu̱ ya ndömöjö, ya dönziandö, ya bötꞌofo ne gatho ar mhuntsꞌandö, bi zixꞌu̱ ar Hesu xki nso̱tꞌe, ma ba e̱ntꞌwa hár ꞌye̱ ar Pilato. ");
INSERT INTO otqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ar Pilato bi ꞌya̱mbabi ar Hesu ne bi ꞌñembabi: —Hage go geꞌe ár Ndö ya xodyo. Nöꞌö bi dödi ne bi ꞌñembabi: —Hö, ngu xka mönse̱. ");
INSERT INTO otqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ne nuya ndömöjö xa te gatho mi ho̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Manꞌagi ar Pilato bi ꞌya̱mbabi ar Hesu ne bi ꞌñenö: —Ha hinte gi thödi. Ndimhö te gatho tho̱xꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ha nunar Hesu hinte bi dödi, jange ar Pilato xa mi ꞌyo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ar ndö xki nzöi nda hye̱kwa nꞌar ꞌyofa̱di har da̱ngo nöꞌö nda ꞌya̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ne mi onu̱ nꞌa már thuhu Baraba, xki jotꞌwi yá ñꞌohu̱, ngetho xki ñhote núꞌmu̱ xki nju̱tsꞌi nda ntukwi ar ndö. ");
INSERT INTO otqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ne mba e gatho ya jöꞌi, bi ndu̱i bi ꞌya̱pabi nda umba ngu xki nzöi mi umba ta̱tꞌa da̱ngo. ");
INSERT INTO otqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Har Pilato bi dötwabiꞌu̱ njawa: —Ha gi ne ga he̱kꞌahu̱ ár Ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mi pöꞌö xki nda̱twabi ngetho xki zo̱tꞌwa yá mu̱i nuya ndömöjö. ");
INSERT INTO otqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ha nuya ndöyu̱ mi ka ya jöꞌi nda ꞌya̱ꞌu̱ nda the̱ ar Baraba. ");
INSERT INTO otqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ar Pilato bi dödi ne bi ꞌñembabiꞌu̱: —Tema gi nehu̱ ga japka nöꞌö gi emfu̱ ár Ndö ya xodyo ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne nuꞌu̱ bi mengi bi mafi, mi eñꞌu̱: —Tsu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ar Pilato mi embabi: —Tema tsꞌoki xi ꞌyo̱tnu̱. Ha nuꞌu̱ xa bi ga̱hni bi mafi mi eñꞌu̱: —Tsu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ha nu ar Pilato mi ne nda gohwi xiñho ya jöꞌi, jange bi xoka ar Baraba. Ha nu ar Hesu bi mö nda nꞌwe̱xtꞌi, ne bi da̱twa ya jöꞌi nda tsu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nuꞌmú̱, nuya ndogu bi zixa mbo hár thi ar döta tsꞌu̱tꞌwi, ne bi tsꞌohna gatho yá mindoguwi mi ꞌbu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ne bi göꞌspabiꞌu̱ nꞌar the̱nga dutu, ne bi hñuꞌspabi nꞌár ntsantꞌi ya ꞌmini xki mꞌe. ");
INSERT INTO otqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bi mu̱di bi ze̱ngwabiꞌu̱ njawa: —Xa̱r tsi te, ár Ndöꞌi ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne mi ju̱ nꞌar tꞌo mi fe̱mba ár ñö, mi tsoxꞌu̱, ne mi nda̱ndihmö mi ndöñꞌu̱ empꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nu mi wadi bi tꞌo̱tꞌwa ar thede, bi thökwa ar the̱nga dutu xki njöꞌspabi, bi thetwa yá dutuse̱, ne bi nju̱ki nda tsꞌu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mi thohnu̱ ar Simu me Sirene, ár dada ar Handro ne ar Rufo, xki ꞌñe har hwöhi, bi njapi nda hñöxa ar pontꞌi habu̱ nda tsꞌu̱ta ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ne bi tsꞌixa habu̱ mi tꞌembabi ar Golgota, di bo̱ni da ꞌñenö Nñöxhmundoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne nunu̱ bi tꞌumbabi ar ixkatꞌafi, mi nthöskwi nꞌar bopo xi nju ár thuhu ar mira, ha nöꞌö himbi ne bi zi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nuya ndogu mi wadi bi tsu̱tꞌu̱ har pontꞌi, bi ñheꞌu̱ yá dutu, mi e̱ntsꞌa ya nthöhö nda nuꞌu̱ te nda hñöxa nꞌa ngu nꞌaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mi tsu̱ ngu nꞌar gu̱to xudi núꞌmu̱ mi tsꞌu̱ti. ");
INSERT INTO otqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne nunar xithe̱ habu̱ xki tꞌotꞌa yoꞌö xki tsꞌu̱ti, mi enö: Gehnu̱ ár Ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bi tsꞌu̱twi ma yoho ya ñꞌo̱ho̱ ma ya bë, nꞌa hár ñꞌe̱i ne manꞌa hár ngöhö. ");
INSERT INTO otqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Njapꞌu̱ bi thogi ngu xki tꞌotꞌa har Tꞌofo habu̱ enö: Bi nhu ngu nꞌar tsꞌokte. ");
INSERT INTO otqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ha gatho nuꞌu̱ mi thohnu̱, xa mi theni, ne mi hwötꞌa yá ñö mi eñꞌu̱: —Xipya, ngi enö ngi yo̱tꞌwa ár nijö Jö, ne ar hñupa ngi pengi ngi ju̱spa manꞌagi, ");
INSERT INTO otqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mpo̱se̱ ꞌmu̱, ne kö habu̱ gi zu̱di. ");
INSERT INTO otqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mi njapꞌu̱ nuꞌu̱ ya ndömöjö nꞌehe, mi theni. Ne ya bötꞌofo mi mpehwi mi eñꞌu̱ nꞌa ngu nꞌa: —Bi po̱ maꞌra, ne hingi tsa̱ da mpo̱se̱. ");
INSERT INTO otqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nunar Kristo ꞌnö, ár Ndö ya me Israel, dá göpya har pontꞌi. Ga hanthe ne ga ñꞌemu̱ihe. Ha nuꞌu̱ togo xki tsꞌu̱twi mahye̱gi mi theni nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nu mi zo̱nga madempa bi mꞌe̱xui xo̱ge ar ximha̱i, ne bi wadi mi zo̱tꞌa hñunde. ");
INSERT INTO otqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nu mi zo̱nga hñunde, ar Hesu bi ꞌñenö ntsꞌe̱di: —Eloi, Eloi lama sabaktani, —po̱ntho da ꞌñenö: Ma tsi Dadaꞌi, ma tsi Dadaꞌi, yoꞌö xka hye̱gase̱. ");
INSERT INTO otqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ꞌRa nuya mi ꞌbu̱hnu̱ mi ꞌyo̱de bi ꞌñeñꞌu̱: —Hyanthu̱ hanja zo ar Elia. ");
INSERT INTO otqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ne bi nixtꞌi nꞌa, ma ba po nꞌar xiꞌyo har ixkatꞌafi. Bi tuta ha nꞌar xithi ne bi kwatwa hár ne, ne bi ꞌñeñꞌö: —Hye̱hu̱, ma ga to̱ꞌmhu̱ ha da e ar Elia da ma̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Har Hesu bi mafi ntsꞌe̱di, ne bi du. ");
INSERT INTO otqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nuꞌmú̱ bi xita made ar döta dutu mi naxa mbo har dönga nijö, mi kotꞌa habu̱ xa mar nsunda, ba ndu̱ mañö bi göxa ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ha nunar döndogu mi ꞌba̱hnu̱ mi ñhandwi ar Hesu, mi hyandi bi du njapꞌu̱ xki wadi bi mafi ntsꞌe̱di, bi ꞌñeñꞌö: —Xa majöni nunar ñꞌo̱ho̱nu̱ már Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mi ꞌbu̱hnu̱ ꞌra ya ꞌbe̱hñö nꞌehe mi handatho yapꞌu̱. Mi ñꞌowiꞌu̱ ar Maria me Magdala, ar Salome, ne ar Maria ár nönö ar ꞌbe̱fa Hakobo ne ar Huse. ");
INSERT INTO otqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nu mi ꞌbu̱hyu̱ Ngalilea mi te̱ni ne mi fa̱tsꞌi, ne ma nze̱ye̱ xki de̱ni mba e Herusale. ");
INSERT INTO otqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Núꞌmu̱ ꞌbu̱tho nda yu̱ ar hyadi nor paꞌö ar ñhoki, nunár hyaxꞌöpꞌu̱ mar pa ntsa̱ya̱, ");
INSERT INTO otqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","nunar Huse me Arimatea mi ꞌbu̱hwi ar mhuntsꞌandö, ne xa mi nhumañho, mi to̱ꞌmi nda hyandwa ár tsꞌu̱tꞌwi Jö nꞌehe, bi ze̱ta ár mu̱i ne bi yu̱tꞌi ma ba ñöwi ar Pilato, bi ꞌya̱pa nda umba ár ndoꞌyo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ar Pilato xa bi ꞌyo̱tho mi ꞌyo̱de xki du. Bi zofo nda e ar döndogu nda ꞌya̱mbabi ha majöni xki du. ");
INSERT INTO otqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ne mi wadi bi da̱majöni ar döndogu, bi tꞌumba ar Huse ár ndoꞌyo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ar Huse bi da̱nga nꞌar tꞌaxdutu, ne bi köꞌmba ár ndoꞌyo har pontꞌi. Bi ma̱tsꞌi, ne bi ꞌye̱ntꞌa ha nꞌar tꞌa̱gi xki nsa̱ꞌma ha nꞌar ndo̱do, ne bi tönga nꞌar döta do bi gotwa ár goxthi ar tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ha nunar Maria me Magdala ne ar Maria ár nönö ar Huse mi hantꞌu̱ habu̱ bi tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nu mi tho ar pa ntsa̱ya̱, ar Maria me Magdala, ar Maria ár nönö ar Hakobo, ne ar Salome, bi da̱nga ya hogañu̱ni ma nda goꞌspa ár ndoꞌyo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ne ár hyaxꞌö ra nꞌitho ár ndu̱i ar hñöto, ba eꞌu̱ har tꞌa̱gi, mi kꞌontsꞌa ar hyadi. ");
INSERT INTO otqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nu mi ꞌyo har ꞌñu, mi ense̱ꞌu̱ nꞌa ngu nꞌa: —Xipya, togo da hñögagihu̱tsꞌu̱ ar do kotꞌa ar tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ne mi hyantꞌu̱, bi nuꞌu̱ xki thöka ar do. Nunar donu̱ xa mar döta. ");
INSERT INTO otqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ne nu mi yu̱tꞌu̱ har tꞌa̱gi, bi hyantꞌu̱ mi huhnu̱ har ñꞌe̱i nꞌar bötsi, mi he nꞌar tꞌaxhe mi ju̱tꞌatho. Ne xa bi zuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ne nunu̱ bi ꞌñembabiꞌu̱: —Yo gi ntsuhu̱. Gi hoñhu̱ ar Hesu me Nasare nöꞌö togo bi tsꞌu̱ta har pontꞌi. Bi mengi bi nte. Ndi, hyanthu̱ habu̱ bi ꞌbe̱gi, hinte jawa. ");
INSERT INTO otqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jange di möhu̱ ba xipabihu̱ yá ma̱xte ne ar Pedro: Bi mꞌe̱tꞌo di ma Ngalilea, ja gi hyanthu̱nu̱ ngu bi xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ne xa bi nixtꞌi bi maꞌu̱, ngetho xa xki zo ar mbidi yá mu̱i. Ne hinto mi ñöwiꞌu̱, ngetho xa mi ntsu. ");
INSERT INTO otqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nu mi mengi bi nte ar Hesu nꞌitho har ꞌbe̱tꞌo mpa ar hñöto, bi ñꞌudi bi hyanda mꞌe̱tꞌo ar Maria me Magdala, togo xki ꞌye̱mba yoto ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nunar ꞌbe̱hñönu̱ bi ma ba kꞌönga nuꞌu̱ mi ñꞌowi ar Hesu. Nuyu̱ xa mi tu yá mu̱i mi zoñꞌu̱, ne nunar ꞌbe̱hñö bi xipabi xki hyantꞌö. ");
INSERT INTO otqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nu mi ꞌyo̱ꞌu̱ mi tetho ne xki hyantꞌö, himbi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mꞌe̱fa bi ñꞌudi nꞌañꞌo, bi hyanda ma yoho nuya mi te̱ni, mi ꞌyo ar ꞌñu ndi ma har ꞌbatha. ");
INSERT INTO otqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nuyu̱ nꞌehe bi ma ba xipa nuꞌu̱ maꞌra. Njapꞌu̱tho himbi ñꞌemu̱ibi. ");
INSERT INTO otqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mꞌe̱fa bi ñꞌudi bi hyanda nuꞌu̱ ꞌre̱tꞌamanꞌa yá ma̱xte, mi huꞌu̱ har mexa. Ne bi zu̱ꞌu̱ yoꞌö himi ñꞌemu̱i, ne xa mar me yá ñö, ngetho hinxki ñꞌemu̱i nuꞌu̱ togo xki hyandi xki mengi xki nte. ");
INSERT INTO otqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ne bi ꞌñembabiꞌu̱: —Di möhu̱ xo̱ge ár nxidi ar ximha̱i, ne xipabihu̱ gatho ya jöꞌi ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nöꞌö togo da ñꞌemu̱i ne da nxixthe, ma da mpo̱ho̱. Ha nöꞌö togo hinda ñꞌemu̱i, ma da tꞌe̱ntꞌi da hñömba ár mfe̱i Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne nuya ntꞌudiyu̱ ma da ꞌyo̱tꞌa nuꞌu̱ togo da ñꞌemu̱i: Po̱tka ma thuhu ma da ꞌye̱nga ya tsꞌondöhi, ma da ñö ya ꞌraꞌyo mhö, ");
INSERT INTO otqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ma da mita ya kꞌeñö, ne nuꞌmu̱ da zi nꞌar ꞌñethi hote, hinte da japabi, da hñuxa yá ꞌye̱ ha ya da̱thi ne da ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mi wadi bi zo yá ma̱xte, ar tsi Hmu bi nju̱tsꞌi bi tsꞌixa mhetsꞌi, ne bi hñuxa hár ñꞌe̱i Jö. ");
INSERT INTO otqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ne nuyu̱ bi bo̱ni hagatho, ma ba mönga ar hoga mhö. Ne ar tsi Hmu mi fa̱tsꞌi, ne mi umba ár tsꞌe̱di ár mhö ha ya ntꞌudi mi o̱tꞌu̱. Dá njapꞌu̱.");
INSERT INTO otqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ja nze̱ye̱ togo xi ne xi ꞌyotkagihu̱ ar ꞌñu gatho nöꞌö xta thohu̱wa, ne di pöhu̱ hö njapꞌu̱, ");
INSERT INTO otqNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","njangu xi utkagihu̱ nuꞌu̱ hár ndu̱i bi hyandase̱, ne bi ñꞌo bi mömbabiꞌu̱ ár mhö ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jange nuga nꞌehe, Nda Teofilo, nu nda jwadi da ñꞌa̱ni xiñho hanja bi ndu̱i ne hanja bi thohyu̱, xta beni ga otꞌi ga pe̱ñꞌaꞌi, ne njapꞌu̱ ga oꞌtꞌa ar ꞌñu, ");
INSERT INTO otqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ne gi pö xiñho nuna majöni xi tꞌutꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nuya paꞌu̱ mar ndö ar Erode har ha̱i Nhudea, ne ka mi ꞌbu̱hnu̱ nꞌar möjö már thuhu ar Sakaria, mi ꞌbu̱ har mhuntsꞌi ár thuhu ar Abia. Ha nöꞌö ár ꞌbe̱hñö már thuhu ar Sabe. Gatho yohoyu̱ ma yá mengu ar mꞌe̱tꞌo möjö Aron. ");
INSERT INTO otqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ar Sakaria ne ár ꞌbe̱hñö xa mi ꞌbu̱i xiñho hár nthandi Jö, ne mi o̱twa gatho yá ꞌbe̱pate. ");
INSERT INTO otqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ho̱nse̱ hinxki dinga ar bötsi, ngetho ar Sabe himi tsa̱ nda ñꞌo̱nte, ne gatho yoho mi pe̱ꞌsa nze̱ye̱ ya je̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nu ar Sakaria ne maꞌra yá mimöjöwi nuya mi mpe̱hwi, bi zo̱tꞌar pa nda yu̱tꞌa har dönganijö nda me̱pa Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nuya möjö bi ꞌye̱ntsꞌa ar nthöhö ngu yá ntꞌumbiꞌu̱, togo nda yu̱tꞌi nda tsötꞌa ar githni. Ne bi zo ár thuhu ar Sakaria. ");
INSERT INTO otqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ha núꞌmu̱ mi tsötꞌa ar githni mbo har nijö, nze̱ye̱ ya jöꞌi mi ꞌba̱ nthi mi matꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ar Sakaria nꞌa mbi hyandwatho nꞌár e̱nxe̱ Jö mi ꞌba̱ hár ñꞌe̱i ar tꞌuꞌsgithni. ");
INSERT INTO otqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ha núꞌmu̱ mi hyandi xa bi zu, ne himi pödi teme nda me̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ha nunar e̱nxe̱ bi ꞌñembabi: —Sakaria, yo gi ntsu, ngetho xta ehe ga xiꞌaꞌi, nuya ri nsa̱di xi ꞌyo̱xa Jö, ne xi numañho. Jange ar Sabe ri ꞌbe̱hñö ma da ꞌyo̱mpꞌaꞌi nꞌa ri tꞌu̱, ne gi hñuꞌspabi ár thuhu ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nunu̱ xa ma da jaꞌaꞌi gi njohya, ne nze̱ye̱ ya jöꞌi xa ma da njohya nꞌehe xta mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ngetho nunu̱ xa ma da njár nsu hár nthandi Jö. Hinda za̱ da zi ar ixkatꞌafi ne gatho nöꞌö unga ar nti. Ne di oda nzitꞌe̱i, di hömpa ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma da zo ya me Israel, ne nze̱ye̱ ma da hye̱pꞌu̱ yá tsꞌoki, ne da mengi da hyonga Jö ár Dadaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Gehnu̱ di ꞌbe̱tꞌo hokwa habu̱ da tho ar tsi Hmu. Ma da tꞌumba ár tsꞌe̱di ngu nöꞌö bi tꞌumba ar Elia, da xokwabi yá mfeni ya dada da mö yá bötsi, ne nuya me̱ꞌsku da ꞌyo̱de nöꞌö nsipabi. Njapꞌu̱ da hyokwa yá mꞌu̱i ya jöꞌi, ne xta ꞌñepꞌu̱ ar tsi Hmu da ꞌyo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ha nuna ar Sakaria bi ꞌñemba ar e̱nxe̱: —Hanja ga pödi ma da thogi ngu xka xikagi. Ngetho nuga xta ndönzia, ne numa ꞌbe̱hñö xi ndötajöꞌi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bi döta ar e̱nxe̱ ne bi ꞌñembabi: —Nuga dar Grabie, di ꞌbu̱i habu̱ bi ꞌbu̱ Jö di pe̱pabi. Jange go xpa pe̱nkagi ga xiꞌaꞌi nunar hoga mhö xta mö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ha hinga ñꞌemu̱i, jange ma gi ngone, hinda za̱ gi ñö gatho nuya payu̱ hinxi mꞌu̱ta ri bötsi. Ngetho ma da thogi gatho ngu xta mö xta zo̱nga ar pa xi benga Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ha nuꞌu̱ ya jöꞌi mi ꞌba̱ nthi, mi to̱ꞌmi nda bo̱nga ar Sakaria. Ne himi pödi teme nda beni, ngetho mi yaꞌö mi o mbo har nijö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ha nu mi bo̱ñꞌö, hinto mi tsa̱ nda ñöwi ngetho mi gone. Njapꞌu̱ bi böta ya jöꞌi xki hyanda nꞌa ngu ar tꞌi núnu̱ mbo. Ne mi ja yá ꞌye̱ mi zoꞌu̱, ne bi gotho mi gone. ");
INSERT INTO otqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ha nu mi wa ya pa mi mpe̱ har nijö, bi menga ár ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hingar yapa ar Sabe ár ꞌbe̱hñö bi mu̱di bi nda̱thi, ne himbi bo̱ngár ngu ku̱tꞌa nzönö. Ne mi enö: ");
INSERT INTO otqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nunár hwëki Jö xi hñögagi ma mꞌe̱tsa̱ himi tsa̱ nga tingar bötsi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mi tho ꞌrato nzönö, Jö ba pe̱hna manꞌagi ar e̱nxe̱ Grabie, bi zo̱nga har hnini Nasare har ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ba e bi kꞌöꞌsa nꞌar nxutsi már thuhu Maria. Nunar nxutsinu̱ xki tꞌa̱di nda nthötwi nꞌar ñꞌo̱ho̱ már thuhu ar Huse, nꞌa yá ꞌbe̱to ar ndö Dabi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mi yu̱tꞌa ar e̱nxe̱ mbor ngu habu̱ mi ꞌbu̱ ar Maria, bi ze̱ngwa ne bi ꞌñembabi: —Njohya, xi hwëkꞌaꞌi ár mhöte Jö. Gi ꞌbu̱hwi ar tsi Hmu. Xa xi jöpꞌaꞌi gi töta gatho maꞌra ya ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nu ar Maria mi hyanda ar e̱nxe̱, bi ꞌyo̱da nuya mhö mi nsipabi, ne mi bense̱ teme ndi bo̱nga nunar nze̱ngwanu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nuꞌmú̱ ar e̱nxe̱ bi ꞌñembabi: —Maria, yo gi ntsu, ngetho xka tsu̱pa ár nhwëki Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ma gi nda̱thi ne ma da mꞌu̱ nꞌa ri bötsi, ne gi hñuꞌspabi ár thuhu ar HESU. ");
INSERT INTO otqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nöꞌö xa ma da me̱ꞌsa nꞌar döta nsu, ne ma da tꞌembabi ár Tꞌu̱ Jö bi ꞌbu̱ mhetsꞌi. Ne Jö ar tsi Hmu ma da ꞌñexa hár thuxandö, habu̱ mi huxa ar ndö Dabi ár pale. ");
INSERT INTO otqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ne ma da ndö hár hnini yá ꞌbe̱to ar Hakob gatho ya pa, ne nuna ár tsꞌu̱tꞌwi hinda ma da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nuꞌmú̱ ar Maria bi ꞌya̱mbabi ar e̱nxe̱: —Hanja da za̱ da thogi nöꞌö xka mö. Hinxta ꞌbu̱ꞌbe nꞌar ndo̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ar e̱nxe̱ bi dödi ne bi ꞌñembabi: —Ár Hñö Jö da zu̱ꞌaꞌi, ne ár tsꞌe̱di ar tsi Dada ꞌbu̱ mhetsꞌi da gopꞌatho ár xudi. Jange nöꞌö ri bötsi ma da mꞌu̱i xa nsunda, da tꞌembabi ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ne ar Sabe ri mëni, ngu gatho gi pöhu̱ himi tsa̱ nda dingya bötsi, nupya mödi xi ndötajöꞌi, pe̱ꞌsa ꞌrato nzönö bi mu̱di bi nda̱thi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngetho Jö hinter ñhembibi da ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nuꞌmú̱ ar Maria bi ꞌñembabi ar e̱nxe̱: —Nuga dár ꞌbe̱gogi Jö. Da njapꞌu̱ ngu xka xikagi. Mi wa ar Maria bi mönga njapꞌu̱, ar e̱nxe̱ bi zopꞌu̱ bi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nuya paꞌu̱ dama bi ma ar Maria, ma ba tso̱nga ha nꞌar hnini mi ꞌbu̱ ha ya tꞌo̱ho̱ har ha̱i Nhudea. ");
INSERT INTO otqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mi zo̱ni bi yu̱tꞌa hár ngu ar Sakaria, ne bi ze̱ngwa ar Sabe. ");
INSERT INTO otqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nu mi ꞌyo̱ ár nze̱ngwa ar Maria, bi ꞌñönga ár bötsi mbo hár mu̱i, ne xa bi hñönga ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bi ñö ntsꞌe̱di ne bi ꞌñemba ar Maria: —Jö xa xi jöpꞌaꞌi, gi töta gatho maꞌra ya ꞌbe̱hñö, ne xi jöpꞌa ri bötsi o nzitꞌe̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hanja xi tꞌakar se̱ki da kꞌöskagi ár nönö ma tsi Hmuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngetho ngu da o̱xa ri nze̱ngwa, numa bötsi bi njohya bi nsa̱gi mbo ha ma mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jö xi jöpꞌaꞌi, ngetho ga ñꞌemu̱i gatho ngu xi xiꞌaꞌi ar tsi Hmu nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nuꞌmú̱ ar Maria bi ꞌñenö: Di e̱ntꞌa ma mu̱i di nsundabi ma tsi Hmu mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ne di e̱ntꞌa ma tsꞌe̱di di johya di o̱xa nöꞌö xi ꞌyo̱tkagi Jö ma Po̱ho̱te. ");
INSERT INTO otqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngetho xi ko ár mu̱i xi hyandgagi ár tsi ꞌbe̱gogi. Da ndu̱ nunar panu̱ di mapꞌu̱, nuya jöꞌi di ꞌñepꞌu̱ da ꞌñengagi, Jö xa xi jöpꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngetho Jö togo ár me̱ti ar tsꞌe̱di, xa xi ꞌyo̱tkagi ya döta ꞌbe̱fi. Xa nsunda ár thuhuꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jö pe̱ꞌspa ar nhwëki gatho nuꞌu̱ ne da ꞌyo̱tꞌa nöꞌö möñꞌö, ne hingi thege, thota nꞌar mꞌu̱i di ma manꞌar mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Xi ñꞌudi ngu nöꞌö hinte kꞌatꞌa ár tsꞌe̱di. Ne xi japi xi ꞌbe̱ yá tsa̱ gatho nuꞌu̱ xa exa yá nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xi hñöka nuꞌu̱ mi ja yá tsꞌe̱di habu̱ mi hutsꞌi, ne nöꞌö ar nsu mi pe̱sꞌu̱, xi umba nuꞌu̱ hinte mi pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nuꞌu̱ mi tu ar thuhu, xi umbabi xi niñö, ha nuꞌu̱ mi pongwathobi, xi hñömbabi gatho. ");
INSERT INTO otqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xi ma̱xa ár hnini Israel yá ꞌbe̱go, ne hinxi pumhni da me̱ꞌspa ar nhwëki. ");
INSERT INTO otqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Xi ꞌyo̱tꞌa ngu xki ñötꞌwabi ma dadahu̱ ar Abra, ne gatho yá ꞌbe̱to ne yá ma̱ngaꞌbe̱to; hinge nda the ár nhwëki pe̱ꞌspabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ar Maria bi mꞌu̱hwi ar Sabe ngu hñu nzönö. Mꞌe̱fa bi menga ár ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mi zo̱nga ar pa bi mꞌu̱ ár bötsi ar Sabe. ");
INSERT INTO otqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ne mi bö gatho yá nꞌangu ne yá mëni hanja Jö xki hwëkwabi nꞌar bötsi, ma ba kꞌötsꞌi bi njohyawi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ha nu ár hñöto mpa, ba eꞌu̱ bi hñuꞌspabi ar nse̱gi hár ndoꞌyo ngu yá ntꞌumbiꞌu̱. Mi ne nda thuꞌspabi ár thuhu ar Sakaria ngu ár dada. ");
INSERT INTO otqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ha nunár nönö bi ꞌñenö: —Hinꞌö, hinga huꞌspabihu̱ njapꞌu̱. Ma ga huꞌspabihu̱ ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nuyu̱ bi dötwabi ar Sabe: —Hanja ma da thuꞌspabi njapꞌu̱. Hinte gi ꞌñe nꞌa ri mëni di pe̱ꞌsa nunar thuhunu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nepꞌu̱ bi ja yá ꞌye̱ bi tꞌa̱mba ár dada tema thuhu nda thuꞌspabi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Har Sakaria xki ngone, jange bi ꞌya̱ nꞌar xithe̱, ne ka bi hñuxpꞌu̱: Ár thuhu ar Xuwa. Gatho nuya mi ꞌbu̱hnu̱ xa mi ꞌyo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Geꞌmu̱ bi mengi bi xo ár ne ar Sakaria, ne bi mu̱di bi nsundabi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gatho nuya jöꞌi bi hyanda nu te xki thogi, mi ꞌyo̱tho ne himi pödi te nda beni. Ne nunar ꞌbedenu̱ bi nxanga xo̱ge ya tꞌo̱ho̱ Nhudea. ");
INSERT INTO otqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Gatho nu togo xki bödi, mi o yá mfeni, ne mi ense̱ nꞌa ngu nꞌa: —Tema nsu ma da tꞌumba nunar bötsinu̱. Ngetho mi ꞌbu̱hwi ár tsꞌe̱di Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nu ar Sakaria ár dada ar bötsi, xa bi zinga ár Hñö Jö, ne bi ndu̱i bi mönga nöꞌö mi umba Jö nda mö, ne bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Xa nsunda Jö ma tsi Hmu mhetsꞌi, ár Dada ya me Israel, ngetho xpa e da po̱kagihu̱ yá hninigihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xpa pe̱nkagihu̱ nꞌar Po̱ho̱te nöꞌö hinda the ár tsꞌe̱di, xpa po̱nga ha yá ma̱ngaꞌbe̱to ar ndö Dabi ár ꞌbe̱go Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gehnu̱ xki ñötkagihu̱ Jö, ngu bi mönga yá hoga mꞌe̱hni mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bi ñötkagihu̱ nda ñöngagihu̱, hinte nda jaju̱ ma ñꞌu̱nihu̱ ne nuꞌu̱ hingi ne da nugagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nda me̱ꞌspa ar nhwëki ma palehu̱, ne hinge nda pumhni ár hoga nkohi bi nkohwi. ");
INSERT INTO otqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nunár ñhötꞌi Jö bi ꞌñetꞌase̱ ár thuhu, bi xipa ar Abra ma palehu̱, nda ꞌrakagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bi xipabi nda ñöngagihu̱ hinte nda jaju̱ ma ñꞌu̱nihu̱, njapꞌu̱ nga pe̱pabihu̱ꞌö, ne hinto nda pikagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ne nga ꞌyohu̱ xiñho, nga ꞌbu̱hu̱ xintꞌaxi hár nthandi Jö gatho ma tehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ha nuꞌge ma tsi bötsiꞌi, ma da nsiꞌaꞌi ár mꞌe̱hniꞌi Jö ꞌbu̱ mhetsꞌi, ngetho ma gi ꞌbe̱tꞌo gi paxtꞌwa ár ꞌñu ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gi xipa ár hnini Jö ma da mpumbabi yá tsꞌoki, ne njapꞌu̱ da mpo̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ngetho Jö ma tsi Dadahu̱ bi ko ár mu̱i, bi ñꞌudi ba pe̱nkagihu̱ nꞌar ꞌraꞌyo hyatsꞌi bi nheki mhetsꞌi, ");
INSERT INTO otqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","da yotꞌwabi yá mfeni gatho nuꞌu̱ ꞌbu̱ har ꞌbe̱xui, to̱ꞌmda ar ndöte. Ne da yotkagihu̱ ar ꞌñu ga ꞌbu̱hu̱ nꞌar hogamꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ne nuna ar bötsi mi te ne mi xu ár tsꞌe̱di ár pa. Mi ꞌbu̱se̱ ha ya otꞌatꞌo̱ho̱. Ba e bi ñꞌudi núꞌmu̱ mi zo̱nga ar pa bi ndu̱i bi zo ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nuya paꞌu̱ ar döngandö Augusto Sesar bi japi nda nju̱spa yá thuhu gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Geꞌmu̱ mar tsꞌu̱tꞌwi ar Sirenio har ha̱i Nsiria, nu mi nja ar mꞌe̱tꞌo nju̱xthuhu. ");
INSERT INTO otqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gatho ya jöꞌi mi penga ha yá hnini habu̱ mi ꞌbu̱ yá mengu, nda unga yá thuhu. ");
INSERT INTO otqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jange ar Huse bi bo̱nga har hnini Nasare har ha̱i Ngalilea, bi ma har hnini Belen har ha̱i Nhudea, ngetho mar mengunu̱ ar ndö Dabi, ha nu ar Huse ka xki ꞌñehnu̱ ha yá mëni ar Dabi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bi ma nda unga yá thuhu, nöꞌö ne ar Maria xki ꞌya̱di nda nthötwi, ha nuna mi ñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Núꞌmu̱ mi ꞌbu̱hnu̱ har hnini Belen, bi wa yá pa nda mꞌu̱ ár bötsi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ka bi mꞌu̱hnu̱ ár ꞌbe̱tꞌo bötsi, bi ma̱xa ya mꞌantꞌi, ne bi ga̱xa habu̱ mi ñunga ya me̱ti, ngetho himi otho habu̱ nda tꞌumba ar se̱ki nda ñꞌoxi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hingar yapꞌu̱nu̱, ꞌra ya ma̱ꞌyo mi haxa har ꞌbatha mi su yá de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nꞌa mbi da̱ñꞌu̱ bi hyandwa nꞌár e̱nxe̱ ar tsi Dada, ne ár nsunda Jö bi yotꞌa gatho habu̱ mi ꞌbu̱ꞌu̱, ne xa bi zuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nunar e̱nxe̱ bi ꞌñembabiꞌu̱: —Yo gi ntsuhu̱, ngetho xta ehe ga xiꞌahu̱ nꞌar hoga mhö, xa gi njohyahu̱ ne gatho nu maꞌra ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngetho nupya xi mꞌu̱ hár hnini ar ndö Dabi, nꞌa togo da po̱ꞌahu̱, ne go geꞌö ar Kristo ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Gehnu̱ nꞌar ntꞌudi: Gi tiñhu̱ ar bötsi ꞌba̱xa ya mꞌantꞌi, di oxa habu̱ ñunga ya me̱ti. ");
INSERT INTO otqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nu mi wadi bi mönga njapꞌu̱ ar e̱nxe̱, nꞌa mbi nhekitho nꞌa mutꞌi ya e̱nxe̱ mhetsꞌi mi ꞌba̱hwi, ne mi nsundabi Jö mi eñꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Dar nsunda Jö bi ꞌbu̱ mhetsꞌi, ne da mꞌu̱i nꞌar hogamꞌu̱i nuya meximha̱i hár mhöteꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nu mi menga mhetsꞌi ya e̱nxe̱, ya ma̱ꞌyo mi enga nꞌa ngu nꞌa: —Möhö Belen, ma ga kꞌöꞌsu̱ nöꞌö xi thogi ngu xi xikagihu̱ ar tsi Dada. ");
INSERT INTO otqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nepꞌu̱ nuya ma̱ꞌyo dama bi maꞌu̱, ne bi dinga ar Huse ne ar Maria, ha nunár bötsi mi oxa habu̱ mi ñunga ya me̱ti. ");
INSERT INTO otqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ha nu mi hyantꞌu̱ ar bötsi, bi ndu̱i bi möñꞌu̱ gatho nöꞌö xki nsipabi mi nho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ne gatho nuꞌu̱ togo mi o̱tsꞌe, xa mi ꞌyo̱da nöꞌö te mi möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ha nunar Maria mi kwatatho hár mfeni gatho te mi mhö, ne mi bense̱ teme ndi bo̱nga gathoyu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ha nuya ma̱ꞌyo bi menga har ꞌbatha, mi nsunda ne mi umba njamödi Jö, gatho nuya xki ꞌyo̱de ne xki hyandi bi thogi ngu xki nsipabi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mi pe̱ꞌsa hñöto mpa xki mꞌu̱ ar bötsi, bi thuꞌspabi ar nse̱gi hár ndoꞌyo ngu yá ntꞌumbiꞌu̱. Ne bi thuꞌspabi ár thuhu ar Hesu, gehnu̱ ar thuhu xki mönga ar e̱nxe̱ núꞌmu̱ hinxki ꞌrotho. ");
INSERT INTO otqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nu mi wa ya pa nda tꞌaxkꞌu̱ ngu mönga ha yá ꞌbe̱pate ar Moise, ar Huse ne ar Maria bi zixa ar bötsi har dönganijö Herusalen, nda nda̱twabi hár ꞌye̱ ar tsi Dada. ");
INSERT INTO otqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bi ꞌyo̱tꞌa njapꞌu̱, ngetho njanu̱ xki tꞌotꞌa ha yá ꞌbe̱pate ar tsi Dada: Gatho nuya ꞌbe̱tꞌo bötsi da mꞌu̱i, nuꞌmu̱ ar tsꞌu̱ntꞌu̱, mahyoni nda tꞌe̱kwa ar tsi Dada. ");
INSERT INTO otqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ne bi maꞌu̱ har dönganijö, bi hñöꞌspabi ár mꞌo̱ñho̱ Jö, ngu mönga ha yá ꞌbe̱pate ar tsi Dada, enö: Nuꞌmu̱ nꞌar ꞌbe̱hñö nda mꞌu̱ ár bötsi, mahyoni nda zixa yoho ya ngongo wa yoho ya domtxu, nda hñöꞌspabi Jö ngu ar mꞌo̱ñho̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nuya paꞌu̱ mi ꞌbu̱ nꞌar ñꞌo̱ho̱ núnu̱ Herusalen már thuhu ar Simiu. Xa mi ꞌyo xiñho hár nthandi Jö, mi hömpa ár Hñö Jö, ne mi to̱ꞌma nda hyanda ar Ñönte, nöꞌö togo ma nda ñönga ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Go gehnu̱ xki xipabi ár Hñö Jö, nda hyanda mꞌe̱tꞌo nöꞌö togo xki ꞌñexa Jö nda ndö, ne ka nda du. ");
INSERT INTO otqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nunu̱ xki ma har nijö ngetho ár Hñö Jö xki zitsꞌi. Núꞌmu̱ mi ꞌbu̱hnu̱ mbo, bi yu̱tꞌa ar Huse ne ar Maria, mi tsi ar tsi Hesu nda nda̱twa hár ꞌye̱ Jö, ngu mi mönga ha yá ꞌbe̱pate ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nuꞌmú̱ ar Simiu bi gu̱ bi de̱tsꞌi, ne bi nsunda Jö bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Jö ma Dadaꞌi, da za̱ gi hyongagi. Xi hñu ma mu̱i, ngetho xta handa ngu xka xikagi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xi hyanda ma da̱ ar Po̱ho̱te xka pe̱hni, ");
INSERT INTO otqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ne xka hyokwa ár ꞌñu ha yá nthandi gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nöꞌö ngu nꞌar ñotꞌi da yotꞌwa yá mfeni gatho nuꞌu̱ hingya me Israel, ne njanu̱ ma da tꞌeꞌspa ár nsu ri hnini Israel. ");
INSERT INTO otqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ha nu ar Huse ne ar Maria ár nönö ar Hesu, xa mi ꞌyo̱tho gatho nöꞌö mi mhö mi nho̱ñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nepꞌu̱ nu ar Simiu bi ꞌya̱pa Jö nda jöpꞌu̱, ne bi ꞌñembabi ar Maria ár nönö ar Hesu: —Nunar bötsinu̱ xpa ꞌbe̱hni da po̱ho̱ nze̱ye̱ ya me Israel, ne maꞌra ma da mꞌe̱di. Gehnu̱ nꞌar ntꞌudi nze̱ye̱ ma da do̱xta nöꞌö te da möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne njapꞌu̱ ma da nheki gatho nöꞌö te pe̱ꞌsa ha yá mfeni ya jöꞌi. Ne nuꞌge xa ma gi tho nꞌar dumu̱i, ngu nꞌar ndo̱jwai da nsu̱sꞌa ri mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mi ꞌbu̱hnu̱ nꞌar ꞌbe̱hñö nꞌehe már thuhu ar Ana, nunu̱ mi ñö mi hömpa ár tsꞌe̱di Jö. Gehnu̱ már tꞌinxu nꞌar ñꞌo̱ho̱ már thuhu ar Fanuel, nuyá mengu ma yá ꞌbe̱to ar Aser. Xki ndötajöꞌinu̱, bi nthöti mi nxutsitho, ne xki mꞌu̱hwi ár döme yoto nje̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ha xki jwata gohonꞌa̱te ma goho nje̱ye̱ xki nꞌanxu. Himi po̱nga har nijö, ka mi ꞌbu̱hnu̱ parxui mi pe̱pa Jö, mi bëhë ne xa mi a̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Núꞌmu̱ mi ñö ar Simiu, bi watꞌa ar Ana nꞌehe habu̱ mi ꞌba̱ꞌu̱. Bi ndu̱i bi umba njamödi Jö, ne mi no̱nga ar tsi bötsi, mi xipa nuꞌu̱ mi to̱ꞌmi nda ñhönga ar hnini Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Núꞌmu̱ mi wadi ar Huse ne ar Maria bi ꞌyo̱tꞌa gatho ngu mi huxa ha yá ꞌbe̱pate ar tsi Dada, bi menga har hnini Nasare har ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ha nunar bötsi mi te, ne mi huxa ár tsꞌe̱di. Xa mi te ár mfödi, ne ár nhwëki Jö mi ñꞌowi hyaxꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ta̱tꞌa je̱ye̱ mi pa yá dada ar Hesu nda mꞌu̱ har da̱ngo mbaxjwa núnu̱ Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jange mi jwata ꞌre̱tꞌamayoho nje̱ye̱ ar Hesu, bi maꞌu̱ ar da̱ngo Herusalen ngu yá ntꞌumbiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nu mi wa ar da̱ngo, ba penga ar Huse ne ar Maria. Ha nu ar Hesu ba kohnu̱ Herusalen, ne nuyá dada himbi bödi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nuꞌu̱ mi hu yá mu̱i mi nthöskwi ya jöꞌi nuꞌu̱ mi papꞌu̱ ndi menga yá ngu. Bi ñꞌo xo̱ge nꞌapa. Mꞌe̱fa ka bi hyoñꞌu̱ ha mi ñꞌowi yá mëni ne yá mpöhwi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ne himbi diñꞌu̱, jange bi gu̱ ar ꞌñu bi menga Herusalen manꞌagi, ma nda hyoni. ");
INSERT INTO otqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ne ár hñupa bi diñꞌu̱ mi ꞌbu̱hnu̱ mbo har dönganijö, mi huhnu̱ madeda nuꞌu̱ ya bötꞌofo, mi o̱tsꞌe ne mi o̱tꞌwabi ya ntꞌa̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ne gatho nuꞌu̱ ya jöꞌi mi o̱xa nöꞌö te mi möñꞌö, xa mi ꞌyo̱tho, ngetho xa mi jár mfödi, mi thödi xiñho gatho nöꞌö te mi tꞌa̱mbabi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ne nu mi hyanda ár nönö ne ar Huse mi huhwinu̱ ya bötꞌofo, himi pödi te nda beni. Ne ár nönö bi ꞌñembabi: —Ma tsi tꞌu̱ꞌi, yoꞌö xka jakagihe njapꞌu̱. Ri dada ne nuga tu ma mu̱ihe di hoñꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ha nunar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Yoꞌö gi hongagihu̱. Ha hingi pöhu̱ mahyoni ga mpe̱ hár ꞌbe̱fi ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mödi nuyu̱ himbi zo yá mfeni teme mi ne nda xipabi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ne bi me̱wiꞌu̱, bi menga Nasare, ne mi o̱ta gatho nöꞌö mi xipabiꞌu̱. Ha ár nönö mi kwatatho hár mfeni gatho nöꞌö te xki bödi. ");
INSERT INTO otqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ne nu ar Hesu mi te ár mfeni ne ár ndoꞌyo, ne mi ꞌyo ndi hñuxa mi numañho Jö ne ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Xki mꞌu̱ ngu ar döngandö ar Tiberio Sesar ꞌre̱tꞌamaku̱tꞌa nje̱ye̱, ha nu har ha̱i Nhudea mar ndö ar Ponsio Pilato, har Erode mar ndö har ha̱i Ngalilea. Ha nunar Lipe ár jödönu̱, mar ndö har ha̱i Iturea ne har ha̱i Trakonite, ne ar Lisania mar ndö har ha̱i Abilinia. ");
INSERT INTO otqNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Geꞌmu̱ ma ya döngamöjö ar Anas ne ar Kaifas. Nunar je̱ye̱nu̱ Jö bi zohna ar Xuwa ár tꞌu̱ ar Sakaria, mi ꞌbu̱ ha ya otꞌatꞌo̱ho̱, nda zo ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nuꞌmú̱ ar Xuwa bi ñꞌo xo̱ge ár ñöni ar döthe Hordan. Ne mi xipa ya jöꞌi nda ꞌyo̱tꞌwa yá ntso̱ꞌmi, ne nda nxixthe, njapꞌu̱ nda mpumba yá tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bi thogi ngu xki ꞌyotꞌa ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: Ár mhafi nꞌa togo enga har otꞌatꞌo̱ho̱: Hyokwabihu̱ ár ꞌñu ar tsi Hmu, jömfu̱ habu̱ da thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gatho ya hñe da ñhutsꞌi. Da thextꞌa ya tꞌo̱ho̱ ne ya ngwani, da jönga ya ꞌñu nuꞌu̱ xi no̱ni, ne da tsꞌu̱ka habu̱ gatho xi ñꞌödi. ");
INSERT INTO otqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ne gatho ya jöꞌi da hyanda ar mpo̱ho̱ unga Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nze̱ye̱ ya jöꞌi mi pa mi kꞌöꞌsa ar Xuwa mi ne nda nxixthe, ne nöꞌö mi embabi: —Yá bötsiꞌihu̱ ya kꞌeñö gi ha̱tehu̱. Togo xi utꞌahu̱ gi kꞌonthu̱ ár kwe̱ Jö xi ꞌñepꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mahyoni gi ꞌyo̱thu̱ nöꞌö xiñho, njapꞌu̱ da nheki xka ꞌyo̱thwu̱ ár ntso̱ꞌmi. Yo ma gi ꞌñexase̱ ri nsuhu̱ gi ꞌñeñhu̱: Ma dadahe ar Abra. Ngetho nuga di xiꞌahu̱, Jö tsa̱ da gu̱xa nuya doyu̱, ne da ꞌñexa ngu yá bötsi ar Abra. ");
INSERT INTO otqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ne di xiꞌahu̱ nꞌehe, Jö ngu ar tse̱nza hödar ntsꞌe̱nza hár ꞌye̱ da ze̱ka ar za. Ha nunar za hinte mañho uni, da tsꞌe̱ki ne da tꞌe̱ntꞌa har tsibi. ");
INSERT INTO otqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nuꞌmú̱ nuya jöꞌi bi ꞌya̱ni ne bi ꞌñembabi: —Xiꞌmu̱, teme ga pe̱je. ");
INSERT INTO otqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ne ar Xuwa bi döti ne bi ꞌñembabi: —Nöꞌö togo pe̱ꞌsa yoho yá pahni, da umba nꞌa nöꞌö hinte köhö. Ha nöꞌö togo pe̱ꞌsa te da zi, da ñhehwi nöꞌö hinte pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ne ba e ꞌra ya njotbojö nda nxixthe nꞌehe, ne bi ꞌya̱mba ar Xuwa: —Utate, xi nuje, te ga pe̱he. ");
INSERT INTO otqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ar Xuwa bi dötwabi: —Ho̱nse̱ jothu̱ nöꞌö xi nsiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nepꞌu̱ ba e ꞌra ya ndogu, ne bi ꞌya̱mba ar Xuwa: —Xije, te ga pe̱je. Ar Xuwa bi ꞌñembabi: —Yo gi hömfu̱ yá bojö ya tsi jöꞌi. Yo gi pehu̱ ya nhemhñö ne njapꞌu̱ da jotꞌi. Ñhogamu̱ihu̱ nöꞌö ar bojö gi töhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gatho ya jöꞌi mi oda yá mfeni ne mi ense̱ꞌu̱: Xi nunar Xuwa, hage go gehnu̱ ar Kristo ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jange ar Xuwa bi ꞌñembabi: —Nuga di xixtheꞌihu̱ har dehe, ha ꞌbe̱fa manꞌa togo ma da xixtheꞌihu̱ hár Hñö Jö ne ar tsibi. Xa tökagi ár tsꞌe̱di, ne nuga hindi ꞌñepkagi ga xotꞌwatsꞌu̱ yá nthötꞌi ár thiza. ");
INSERT INTO otqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nöꞌö xi ñhoki da miꞌsa ar tꞌe̱i. Ma da paxtꞌa ár thi, ne da kwata ar tꞌe̱i hár tꞌu, ne nunar paxi da ꞌyu̱ꞌsa har tsibi habu̱ hiñhamꞌu̱ da wadi da nzo̱. ");
INSERT INTO otqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Njapꞌu̱ ar Xuwa mi mönga nze̱ye̱ ya mhö mi zohna ya jöꞌi, ne mi xipa ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nꞌagi bi zu̱i ar ndö Erode, ngetho xki zimbabi ár ꞌbe̱hñö ár jödö már thuhu ar Lipe, ne xki ꞌyo̱tꞌa ma nze̱ye̱ ya tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nunar Erode, bi hñuꞌsa manꞌar tsꞌoki, bi gu̱ ar Xuwa ne bi ꞌñetꞌa har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Núꞌmu̱ mi xixthe ya jöꞌi ar Xuwa, nuya paꞌu̱ ar Hesu bi nxixthe nꞌehe. Ne nu mi ꞌya̱pa Jö, bi xo mhetsꞌi, ");
INSERT INTO otqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ne ár Hñö Jö ba köi ngu nꞌar domtxu, ne bi zu̱ꞌö. Ne bi nheki nꞌar mhö ndi ꞌñe mhetsꞌi, bi ꞌñenö: —Go ma hmöka Tꞌu̱ꞌi, gi jakagi ga njohya. ");
INSERT INTO otqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ar Hesu mi pe̱ꞌsa ngu nꞌa̱temaꞌre̱tꞌa nje̱ye̱ núꞌmu̱ mi du̱ꞌma ár ꞌbe̱fi. Ne nöꞌö, ngu mi benga ya jöꞌi, már tꞌu̱ ar Huse, ha nu ar Huse már tꞌu̱ ar Eli. ");
INSERT INTO otqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ar Eli már tꞌu̱ ar Matat, har Matat már tꞌu̱ ar Lebi, ar Lebi már tꞌu̱ ar Melki, ar Melki már tꞌu̱ ar Hana, har Hana már tꞌu̱ manꞌar Huse. ");
INSERT INTO otqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ha nöꞌö manꞌar Huse már tꞌu̱ ar Matatia, ar Matatia már tꞌu̱ ar Amos, ar Amos már tꞌu̱ ar Naum, ar Naum már tꞌu̱ ar Esli, har Esli már tꞌu̱ ar Nagai. ");
INSERT INTO otqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ar Nagai már tꞌu̱ ar Mat, ar Mat már tꞌu̱ manꞌar Matatia, ha nöꞌö manꞌar Matatia már tꞌu̱ ar Semei, ar Semei már tꞌu̱ manꞌar Huse, ha nöꞌö manꞌar Huse már tꞌu̱ ar Huda. ");
INSERT INTO otqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ar Huda már tꞌu̱ ar Hoana, ar Hoana már tꞌu̱ ar Resa, ar Resa már tꞌu̱ ar Sorobabel, ar Sorobabel már tꞌu̱ ar Salatiel, har Salatiel már tꞌu̱ ar Neri. ");
INSERT INTO otqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ar Neri már tꞌu̱ manꞌar Melki, ha nöꞌö manꞌar Melki már tꞌu̱ ar Adi, ar Adi már tꞌu̱ ar Kosam, ar Kosam már tꞌu̱ ar Elmodam, har Elmodam már tꞌu̱ ar Er. ");
INSERT INTO otqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ar Er már tꞌu̱ ar Hosue, ar Hosue már tꞌu̱ ar Elieser, ar Elieser már tꞌu̱ ar Horim, har Horim már tꞌu̱ manꞌar Matat. ");
INSERT INTO otqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ha nöꞌö manꞌar Matat már tꞌu̱ manꞌar Lebi, ha nöꞌö manꞌar Lebi már tꞌu̱ ar Simiu, ar Simiu már tꞌu̱ manꞌar Huda, ha nöꞌö manꞌar Huda már tꞌu̱ manꞌar Huse, ha nöꞌö manꞌar Huse már tꞌu̱ ar Honan, har Honan már tꞌu̱ ar Eliakim. ");
INSERT INTO otqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ar Eliakim már tꞌu̱ ar Melea, ar Melea már tꞌu̱ ar Mainan, ar Mainan már tꞌu̱ ar Matata, har Matata már tꞌu̱ ar Natan. ");
INSERT INTO otqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ar Natan már tꞌu̱ ar Dabi, ar Dabi már tꞌu̱ ar Isai, ar Isai már tꞌu̱ ar Obed, ar Obed már tꞌu̱ ar Bos, ar Bos már tꞌu̱ ar Salmon, har Salmon már tꞌu̱ ar Naso. ");
INSERT INTO otqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ar Naso már tꞌu̱ ar Aminadab, ar Aminadab már tꞌu̱ ar Aram, ar Aram már tꞌu̱ ar Esrom, ar Esrom már tꞌu̱ ar Fare, har Fare már tꞌu̱ manꞌar Huda. ");
INSERT INTO otqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ha nöꞌö manꞌar Huda már tꞌu̱ ar Hakob, ar Hakob már tꞌu̱ ar Isa, ar Isa már tꞌu̱ ar Abra, ar Abra már tꞌu̱ ar Tare, har Tare már tꞌu̱ ar Nakor. ");
INSERT INTO otqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ar Nakor már tꞌu̱ ar Serug, ar Serug már tꞌu̱ ar Ragau, ar Ragau már tꞌu̱ ar Peleg, ar Peleg már tꞌu̱ ar Eber, har Eber már tꞌu̱ ar Sala. ");
INSERT INTO otqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ar Sala már tꞌu̱ ar Kainan, ar Kainan már tꞌu̱ ar Arfaxad, ar Arfaxad már tꞌu̱ ar Sem, ar Sem már tꞌu̱ ar Noe, har Noe már tꞌu̱ ar Lamek. ");
INSERT INTO otqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ar Lamek már tꞌu̱ ar Matusale, ar Matusale már tꞌu̱ ar Enok, ar Enok már tꞌu̱ ar Hared, ar Hared már tꞌu̱ ar Malalel, har Malalel már tꞌu̱ manꞌar Kainan. ");
INSERT INTO otqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ha nöꞌö manꞌar Kainan már tꞌu̱ ar Enos, ar Enos már tꞌu̱ ar Set, ar Set már tꞌu̱ ar Adan, ha nu ar Adan már tꞌu̱ Jö bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mi wadi bi nxixthe ar Hesu, ne xki nzinga ár Hñö Jö, bi zohnu̱ ar döthe Hordan, ne ár Hñö Jö bi zixa ha ya otꞌatꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne ka ba ꞌbu̱hnu̱ yonꞌa̱te mpa, ne mi ehnu̱ ar tsꞌondöhi mi tsa̱ti. Ha nu ar Hesu gatho nuya payu̱ hinte xki zi, ne mi wahyu̱ bi ntunthu. ");
INSERT INTO otqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nuꞌmú̱ ar tsꞌondöhi bi ꞌñembabi: —Nuꞌmu̱ ár Tꞌu̱ꞌi Jö, japa nunar do da nthuhme xö. ");
INSERT INTO otqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ha nu ar Hesu bi döti ne bi ꞌñembabi: —Huxa har Tꞌofo njawa: Hinge ho̱nse̱ ar thuhme da umba ár te ar jöꞌi, mahyonibi ár mhö Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ne ar tsꞌondöhi bi zixa ar Hesu ha nꞌar tꞌo̱ho̱ xa mar ñhetsꞌi, ne bi utwabi gatho ya hnini ꞌbu̱ har ximha̱i, ne bi nhekinu̱ xo̱geyu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ne bi ꞌñembabi nꞌehe: —Ga jaꞌi gi ndö gatho nuya hniniyu̱, di pe̱wi yá ñho, ngetho xi tꞌe̱ntkꞌa ha ma ꞌye̱yu̱, ne da tsa̱ ga umbabi togo di nega. ");
INSERT INTO otqNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ho̱nse̱ nuꞌmu̱ gi nda̱ndihmö ne gi nsundagi, gatho ga e̱ntꞌa ha ri ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Hye̱gagiwa tsꞌondöhi. Ngetho huxa har Tꞌofo: Nsunda Jö ri Hmu, ne ho̱nse̱ꞌö gi pe̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nepꞌu̱ ar tsꞌondöhi bi zixa ar Hesu har hnini Herusalen, ne bi ꞌñexa mañö hár ngötsꞌi ar dönganijö, ne bi ꞌñembabi: —Nuꞌmu̱ go ár Tꞌu̱ꞌi Jö, ꞌye̱ngar nsa̱gi xö. ");
INSERT INTO otqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ngetho huxa har Tꞌofo: Jö da me̱hna yá e̱nxe̱ da suꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ne da mipꞌa ri ꞌye̱, hingi fama ri wa ha ya do. ");
INSERT INTO otqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñenö: —Enga har Tꞌofo nꞌehe: Yo ma gi tsa̱ta Jö ri Hmu. ");
INSERT INTO otqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Núꞌmu̱ himi tini hanja nda tsa̱ti, ar tsꞌondöhi bi ꞌwege ꞌra ya pa. ");
INSERT INTO otqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nepꞌu̱ mi hömpa ár tsꞌe̱di ár Hñö Jö, ar Hesu bi menga har ha̱i Ngalilea. Gatho nuꞌu̱ ya jöꞌi mi ꞌbu̱ hár nthetꞌi bi ꞌyo̱ mi nho̱ñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne nöꞌö mi ku̱tꞌa ha yá nijöꞌu̱ mi uti. Ne gatho mi eꞌspa ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nepꞌu̱ ar Hesu bi menga har hnini Nasare habu̱ xki teꞌö. Bi zo̱ta nꞌar pa ntsa̱ya̱, bi yu̱tꞌa har nijö ngu ár ntꞌumbiꞌö, ne bi mꞌa̱i nda né ar Tꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bi tꞌumbabi nda ne ar tꞌofo xki ꞌyotꞌa ar mꞌe̱hni Isaia, ne bi dinga nöꞌö ar xe̱ni enö njawa: ");
INSERT INTO otqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nu ár Hñö Jö xi gobgatho, ngetho xi hñuxkagi ga xipa ar hoga mhö ya hyoya. Xpa pe̱nkagi ga hotꞌa nuꞌu̱ tu yá mu̱i, ga xipabi nuꞌu̱ togo jotꞌi, xi zo̱ ar pa da bo̱ni, ga xokwabi yá da̱ ya goda̱, ga ju̱xa nuꞌu̱ xi tho̱maha̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ne ga xipabi gatho ya jöꞌi xi zo̱ ar pa da hwëgagihu̱ ár mhöte Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mi wa ar Hesu bi nepa ár Tꞌofo Jö, bi tani bi da̱twabi nöꞌö mi fa̱xte har nijö, ne bi hñudi. Ha gatho nuꞌu̱ mi ꞌbu̱hnu̱ himi ju̱xa yá da̱ mi kꞌötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nöꞌö bi ndu̱i bi zofo, ne bi ꞌñembabiꞌu̱: —Ar pania xi tho gatho nöꞌö xka ꞌyo̱hu̱ da nehe har Tꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ne gatho nuꞌu̱ mi ꞌbu̱hnu̱ xa mi ñömañho, ne xa mi ꞌyo̱da ya nza̱tho mhö mi mönga ar Hesu, ne mi eñꞌu̱: —Ha hinga gehnu̱ ár tꞌu̱ ar Huse. ");
INSERT INTO otqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Di pödi ma gi ꞌñengagihu̱: Nuꞌmu̱ xa majöni gi o̱the maꞌra, ñꞌo̱these̱. Ne ma gi ꞌñengagihu̱: ꞌYo̱tꞌwa ha ma ha̱ihu̱ nꞌehe, ngu xta o̱he xka ꞌyo̱tnu̱ Nkapernaum. ");
INSERT INTO otqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ne bi ꞌñenö nꞌehe: —Xa majöni di xiꞌahu̱, hinjoꞌo nꞌár mꞌe̱hni Jö da nhumañho hár ha̱ise̱. ");
INSERT INTO otqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Di xiꞌahu̱ majöni, núꞌmu̱ mi ꞌbu̱ ar mꞌe̱hni Elia, himi kꞌatꞌa ya ꞌranxu har ha̱i Israel, geꞌmu̱ hinxki ꞌwö hñu nje̱ye̱ made, ne hagatho mi jar thuhu. ");
INSERT INTO otqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ha Jö himbi me̱hna ar Elia nda tꞌinga ha yá nguꞌu̱. Bi me̱hna ba ꞌwinga nꞌar ꞌranxu me Sarepta, getꞌu̱ ar hnini Sidon. ");
INSERT INTO otqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne nuya pa mi ꞌbu̱ ar mꞌe̱hni Eliseo nꞌehe, himi kꞌatꞌa togo mi tsu̱ ar tsitꞌandoꞌyo har ha̱i Israel, ha hinto bi dixyu̱, ho̱nse̱ ar Naman mar me Nsiria. ");
INSERT INTO otqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nu mi ꞌyo̱xꞌu̱ nöꞌö mi mönga ar Hesu, gatho nuya jöꞌi xki mhuntsꞌa mbo har nijö xa bi mbo̱ yá kwe̱. ");
INSERT INTO otqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xa bi mꞌa̱ꞌu̱, bi gu̱ka ar Hesu har hnini, bi zixa har nengamaꞌye habu̱ mi huxa nunar hnininu̱, ne mi ne nda hyo̱tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ha nunar Hesu bi thota madeda ya jöꞌi, ne bi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nepꞌu̱ ar Hesu bi ma Nkapernaum, nꞌar hnini har ha̱i Ngalilea, ne ha ya pa ntsa̱ya̱ mi uta ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ne gatho nuya jöꞌi xa mi ꞌyo̱tho tengu ár ntꞌuti, ngetho mi ñö ngu nöꞌö togo pe̱ꞌsa ar tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ka mi ꞌbu̱hnu̱ har nijö nꞌar ñꞌo̱ho̱ mi nthe̱xkwi nꞌar tsꞌondöhi. Nꞌa mbi hye̱xta nꞌar mhafi, ne bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Te gi hongwa. Hye̱gagihe, Hesu me Nasare. Hage xka e gi hwatkagihe. Di pödi togoꞌi, ár hoga Tꞌu̱ꞌi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ar Hesu bi zu̱ ar tsꞌondöhi, ne bi ꞌñembabi: —Kotꞌa ri ne, po̱ni hye̱ nunar ñꞌo̱ho̱nu̱. Nuꞌmú̱ ar tsꞌondöhi bi fo̱ma ar ñꞌo̱ho̱ madeda habu̱ mi ꞌba̱ꞌu̱, bi hye̱gi ne hinte bi japi. ");
INSERT INTO otqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ne gathoyu̱ xa bi zu, ne mi enga nꞌa ngu nꞌa: —Tema mhö mönu̱. Ho̱nse̱ da ꞌbe̱pabi ya tsꞌondöhi da bo̱ni, ne nuyu̱ o̱te. ");
INSERT INTO otqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne gatho har ha̱iꞌö ne ár nthetꞌi bi nu̱nga ár ꞌbede ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nepꞌu̱ mba po̱nga ar Hesu har nijö, bi ma hár ngu ar Simu. Ne ár to xa mi the̱ ar mpatꞌi. Ne bi tꞌa̱pabi ar Hesu nda nu. ");
INSERT INTO otqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ne nunu̱ bi ñꞌani habu̱ mi ꞌbe̱nga ar da̱thi, ne bi xipa ar mpatꞌi nda bo̱ni. Ne nunar mpatꞌi dama bi hye̱gi, ne nunar ꞌbe̱hñönu̱ bi nangi bi umba te nda ziꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Núꞌmu̱ mi yu̱ ar hyadi, gatho nuꞌu̱ tsa̱ntꞌö ar hñeni mi thogi, mi tsꞌixa habu̱ mi ꞌbu̱ ar Hesu nda hñuꞌspa ár ꞌye̱ nꞌa ngu nꞌa, ne gatho mi o̱the. ");
INSERT INTO otqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne nze̱ye̱ ya da̱thi nuꞌu̱ mi nthe̱xkwi ya tsꞌondöhi mi e̱mbabi, ne nu nda bo̱ñꞌu̱, mi mafi mi enö: —Go geꞌe ár Tꞌu̱ Jö. Ha nunar Hesu mi tsu̱i, ne himi he̱gi nda ñö, ngetho nuyu̱ mi pödi go mi gehnu̱ ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ár hyaxꞌö nꞌitho ar Hesu bi bo̱nga har hnini, bi ma ha nꞌar ha̱i habu̱ hinto mi ꞌbu̱i. Ha nuya jöꞌi xa bi ñꞌo bi hyoni, ne mi zo̱nga habu̱ mi ꞌyoꞌö, mi tsömi himi ne nda hye̱gi nda ma. ");
INSERT INTO otqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Mahyoni ga ma maꞌra ya hnini, ga mönga ar hoga mhö no̱nga ár tsꞌu̱tꞌwi Jö, ngetho gehnu̱ xpa ꞌbe̱nkagi ga e ga möngaꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ne mi ꞌyo xo̱ge Ngalilea, mi zo ya jöꞌi ha yá nijö. ");
INSERT INTO otqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nꞌar pa ar Hesu mi ꞌyo hár ñöni ar ñho̱nthe Genesare. Nor paꞌö xa bi watꞌa ra nze̱ ya jöꞌi, ꞌbu̱tho nda ꞌyentꞌi, ngetho gatho mi ne nda ꞌyo̱xa ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ar Hesu mi hyanda yoho ya motsa mi ku̱ har ñönthe. Hinto mi ꞌyoni, ngetho nu togo yá me̱ti xki göi, mi petꞌa yá ntꞌa̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ne ar Hesu bi bo̱xa nꞌa nuya motsa mi ꞌbu̱hnu̱, már me̱ti ar Simu. Ne bi ꞌya̱pa ar möte nda ꞌñetꞌa nꞌar tsi tu̱i mbo ar dehe, ne ka bi hñuxnu̱ mi uta gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ne mi wadi bi zofo, bi ꞌñemba ar Simu: —ꞌYe̱tꞌa ar motsa habu̱ xi ñhe, ne ka gi köthu̱nu̱ ri ntꞌa̱tsꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ha nu ar Simu bi dödi ne bi ꞌñembabi: —Ma tsi Utateꞌi, xta mpe̱he gatho ar xui, ne hinte xta ju̱xe. Mödi njapꞌu̱, nuꞌmu̱ gi pe̱nje, ma ga köthe ar ntꞌa̱tsꞌi zëi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne nu mi ꞌyo̱tꞌa ngu xki nsipabi, mi gu̱xa nuya ntꞌa̱tsꞌi xa mi ñutsꞌi, ꞌbu̱tho nda xe̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jange bi gu̱xa yá ꞌye̱ bi matꞌa nu maꞌra yá ñꞌohu̱ mi e̱tꞌa manꞌar motsa, nda e nda ma̱tsꞌi. Mba eꞌu̱, bi ñuꞌsa gatho yoho ya motsa, ꞌbu̱tho nda yu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ha nu mi hyanda ar Simu njapꞌu̱, bi nda̱ndihmö hár wa ar Hesu, ne bi ꞌñembabi: —Tsi Hmuꞌi, hindi ꞌñepkagi ga ñꞌowi, ngetho dar tsꞌokte. ");
INSERT INTO otqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bi ꞌñenö njapꞌu̱ ngetho nguꞌö ne nu maꞌra, xa xki zu, ne himi pödi te nda beni, xki hyanda gatho nuya hwö xki gu̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Njapꞌu̱ nu maꞌra mi fa̱xa ar Simu har ntꞌa̱xhwö, ar Hakobo ne ar Xuwa nuyá tꞌu̱ ar Sebedeo, xa xki zo ar mbidi yá mu̱i. Ha nunar Hesu bi ꞌñemba ar Simu: —Yo gi ntsu. Di ndu̱ ar pania ma gi ꞌya̱xa ya jöꞌi da e da de̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nuꞌmú̱ bi ꞌye̱tꞌa ya motsa hár ñöni ar dehe, ne bi zohnu̱ gatho yá ꞌbe̱fi, bi de̱nga ar Hesu bi me̱wi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nꞌagi ar Hesu mi ꞌbu̱ ha nꞌar hnini, ne ba e nꞌar ñꞌo̱ho̱ ntsꞌe̱di mi tsu̱ ar tsitꞌandoꞌyo. Mi hyanda ar Hesu, bi watꞌa habu̱ mi ꞌba̱ꞌö, bi nda̱ndihmö, bi me̱ ár hmi har ha̱i. Ne mi a̱pa ar möte mi embabi: —Ma tsi Hmuꞌi, nuꞌmu̱ gi ne, da tsa̱ gi o̱thegi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nuꞌmú̱ ar Hesu bi maka ár ꞌye̱, bi hñuꞌspabi ne bi ꞌñembi: —Hö, di ne ga o̱theꞌi. Dá dixꞌaꞌi. Ne ar tsitꞌandoꞌyo dama bi hye̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nu ar Hesu bi hñuꞌmba ár mu̱i hinto nda xipabi, ne bi ꞌñembabi: —Ho̱ntꞌa di ma ba ñꞌudi da hyantꞌa ar möjö. Ne gi hñöxa ri mꞌo̱ñho̱ gi jutꞌa ri ntꞌaxki ngu bi mönga ar Moise, njapꞌu̱ da böꞌu̱ xi dixꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ha nunar ꞌbedenu̱ bi nu̱ngi, bi zo yá gu ya jöꞌi nöꞌö mi o̱tꞌa ar Hesu. Ne xa mi kwatꞌi nda ꞌyo̱xa nöꞌö te mi mö, ne nda o̱thebi yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jange ar Hesu mi ꞌwege habu̱ hinte mi ꞌbu̱ ya jöꞌi, mi matꞌa Jö ár Dada. ");
INSERT INTO otqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nꞌar pa ar Hesu mi uta ya jöꞌi, ne mi ꞌbu̱hnu̱ ꞌra ya de̱ngaꞌbe̱pate ne ya bötꞌofo, xki ꞌñe Herusalen ne maꞌra ya hnini har ha̱i Nhudea ne Ngalilea. Ne ar Hesu mi hömpa ár tsꞌe̱di Jö mi o̱the ya da̱thi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nepꞌu̱ bi zo̱ ꞌra ya ñꞌo̱ho̱ mi tsi nꞌar da̱thi xki ꞌye̱ntsꞌa ha nꞌar fidi, ngetho xki nza ár ndoꞌyo. Ne nuꞌu̱ togo mi tsihi, mi ne nda ku̱tꞌa mbo habu̱ mi ꞌbu̱ ar Hesu nda o̱the. ");
INSERT INTO otqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ha himi tsa̱ nda yu̱tꞌi, ngetho xa mi ja nze̱ ya jöꞌi. Jange bi bo̱xa mañö ar ngu, ne bi gu̱ka ꞌra ya domhi. Njapꞌu̱ bi tsa̱ bi köꞌma ar da̱thi mi oxa ár fidi habu̱ mi ꞌba̱ ar Hesu, mbo har ngu madeda ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Har Hesu mi hyandwa yá jamfi nuꞌu̱ ya ñꞌo̱ho̱ mi tsihi, bi ꞌñembabi ar da̱thi: —Ha gi o̱de, ndada. Xi mpumpꞌa ri tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nuꞌmú̱ nuya bötꞌofo ne ya de̱ngaꞌbe̱pate mi ense̱ꞌu̱ njawa: Teme xi benga nunar ñꞌo̱ho̱nu̱, tsꞌokwa Jö. Ngetho ho̱nse̱ Jö tsa̱ da pungya tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ar Hesu bi bötwatho yá mfeni, jange bi ꞌñembabiꞌu̱: —Yoꞌö gi beñhu̱ njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Temar ñhembi ga xipkanu̱: Xi mpumpꞌa ri tsꞌoki. Wa ga embabi: Nangi gi ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pöhu̱pya, Nöꞌö Togo xpa e bi Njöꞌi pe̱ꞌskwa ar tsꞌe̱di har ximha̱i da punga ya tsꞌoki, nuhu̱ teme ma ga pe̱fi. Ne bi ꞌñembabi ar da̱thi: —Nuꞌge di xiꞌaꞌi: Nangi, ju̱xa ri fidi, di ma ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nuꞌmú̱ ar da̱thi bi nanga madeda ya jöꞌi, bi gu̱xa ár fidi, ne bi ma ár ngu, mi umba njamödi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ne gatho ya jöꞌi bi hyandi xa bi ꞌyo̱tho, mi eꞌspa ár nsu Jö, xa mi ntsu mi eñꞌu̱: —Ar pania xta hanthu̱ ya döta ntꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mꞌe̱fa ar Hesu bi bo̱ni bi ma, ne bi hyanda nꞌar njotbojö már thuhu Lebi, mi huxa habu̱ mi njutꞌar bojö mi jotꞌa ya ndö. Ne bi ꞌñembabi: —Ba e gi te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nuꞌmú̱ ar Lebi bi zopꞌu̱ xo̱ge, bi de̱ni bi me̱wi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mꞌe̱fa bi ꞌyo̱tꞌwa nꞌar da̱ngo ar Hesu hár ngu. Bi watꞌa nze̱ye̱ maꞌra yá minjotbojöwi, ne maꞌra ya jöꞌi bi hñuxkwiyu̱ har mexa. ");
INSERT INTO otqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nepꞌu̱ nuya bötꞌofo ne ya de̱ngaꞌbe̱pate bi ndu̱i bi ñömañꞌu̱ mi e̱mba nuꞌu̱ mi te̱nga ar Hesu, ne mi embabiꞌu̱: —Hanja gi ñuñhu̱ ne gi ntsixkwihu̱ ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Nuꞌu̱ ꞌyomañho, hingi honga togo da o̱the, ha nuya da̱thi hö, hoñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nuga hinxta e ga zo ya hogajöꞌi. Xta e ga zo ya ꞌyo̱tꞌatsꞌoki da ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bi tꞌa̱mbabi ar Hesu, ne bi tꞌembabi: —Yoꞌö yá ma̱xte ar Xuwa Xixthe ne yá ma̱xte ya de̱ngaꞌbe̱pate xa bëhë ne matꞌa Jö. Ha nuya ri ma̱xte ñuni ne tsithe. ");
INSERT INTO otqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ar Hesu bi dödi ne bi ꞌñenö: —Hage da tsa̱ gi jafu̱ da bëhë nuꞌu̱ togo xi tsꞌohna ha nꞌar ngo ne ꞌbu̱hwi nöꞌö togo nthöti. Njapꞌu̱ ma ma̱xte nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ha ma da zo̱ ya pa núꞌmu̱ xta tsꞌixkagi. Nuya paꞌu̱ hö, xinda ne, da bëhyu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne bi xipa manꞌar ꞌbede, enö njawa: —Hinjoꞌo togo da hye̱nga nꞌar ꞌraꞌyo he da mo̱ꞌtꞌa nꞌar ze̱ dutu. Ngetho nuꞌmu̱ da japꞌu̱, hinge ho̱ntꞌa da tsꞌonga ar ꞌraꞌyo he, ar gönga dutu da xe̱gi xta yu̱tꞌa nöꞌö ar ꞌraꞌyo mꞌo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne hinto xitꞌa ar utꞌafi ha ya ze̱ ximhni, ngetho ar tꞌafi da fo̱ka ya ze̱ ximhni, njapꞌu̱ ya ximhni ne ar tꞌafi da mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jange mahyoni da nsitꞌa ar utꞌafi ha ya ꞌraꞌyo ximhni, ne njapꞌu̱ hinte da jayu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nöꞌö togo tsi ar tꞌafi xi ñhe̱gi, hingi ne da zi nöꞌö xi ñꞌutho, ngetho eñꞌu̱, nöꞌö xi ñhe̱gi xiñhoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nꞌar pa ntsa̱ya̱ ar Hesu ne yá ma̱xte bi tho ha ya hwöhi xki ꞌbotꞌa ya tꞌe̱i, ha nuyá ma̱xte mi toka ya ngötꞌe̱i, ne mi töki mi tsa. ");
INSERT INTO otqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nuꞌmú̱ ꞌra ya de̱ngaꞌbe̱pate mi hyandi, bi ꞌya̱ni ne bi ꞌñembabiꞌu̱: —Yoꞌö gi o̱thu̱ nöꞌö hingi ho da tꞌo̱tꞌa har pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ha nu ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Ha hinxka nehu̱ nöꞌö bi ꞌyo̱tꞌa nꞌagi ar Dabi núꞌmu̱ mi zu̱hwi ar thuhu yá ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bi yu̱tꞌa hár nijö Jö, ne bi gu̱ka nuya thuhme xki ꞌbo̱ꞌspa Jö. Nuya thuhmeyu̱, hinto mi tsa̱ nda zi, ho̱nse̱ ya möjö. Mödi ar Dabi bi zi, ne bi umbabi gatho nuꞌu̱ togo mi ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ne bi ꞌñembabi nꞌehe: —Nöꞌö Togo ba e bi Njöꞌi, gehnu̱ ár Hmu ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Manꞌar pa ntsa̱ya̱ ar Hesu bi yu̱tꞌa ha yá nijöꞌu̱, ne bi du̱ꞌmi mi uti. Ka mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ xki ꞌyotꞌa ár ꞌye̱ ñꞌe̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ha nuya bötꞌofo ne ya de̱ngaꞌbe̱pate, mi öda ar Hesu mi handi ha nda o̱the ar ñꞌo̱ho̱ har pa ntsa̱ya̱, ne nda dinga te nda hyo̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Har Hesu mi pötwatho yá mfeniꞌu̱, ne bi ꞌñemba ar ñꞌo̱ho̱ xki ꞌyotꞌa ár ꞌye̱: —Nangi, ꞌba̱ madetho. Ha nöꞌö ar ñꞌo̱ho̱ dama bi nangi, ne bi mꞌa̱ madetho. ");
INSERT INTO otqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nepꞌu̱ ar Hesu bi ꞌñembabi nuya bötꞌofo ne nuya de̱ngaꞌbe̱pate: —Ma ga o̱tꞌahu̱ nꞌar ntꞌa̱ni: Teme xiñho da tꞌo̱tꞌe har pa ntsa̱ya̱, ar ñho wa ar tsꞌomꞌu̱i. Da tꞌo̱the nꞌar da̱thi, wa da the̱gi da du. ");
INSERT INTO otqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ne bi kꞌötꞌa gatho nuꞌu̱ mi ꞌbu̱hnu̱, ne bi ꞌñembabi ar ñꞌo̱ho̱: —Maka ri ꞌye̱. Ar ñꞌo̱ho̱ bi maka ár ꞌye̱, ne dama bi ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nuya de̱ngaꞌbe̱pate ne ya bötꞌofo xa bi mbo̱ yá kwe̱, ne mi ñꞌa̱nga nꞌa ngu nꞌa teme nda japꞌu̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nuya paꞌu̱ ar Hesu bi bo̱xa ha nꞌar tꞌo̱ho̱, ma ba a̱pa Jö, ne gatho ar xui bi mꞌu̱hnu̱ mi ñöwi ár Dada. ");
INSERT INTO otqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ár hyaxꞌö bi zohna gatho nuꞌu̱ mi te̱ni. Ne bi hwahna ꞌre̱tꞌamayoho yá ma̱xte, ne bi ꞌñembabi yá mpo̱te nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Go gehyu̱ yá thuhuꞌu̱: ar Simu nöꞌö bi tꞌembabi ar Pedro, ar Andre ár jödöpꞌu̱ꞌö, ar Hakobo ne ar Xuwa, ar Lipe, ne ar Bartolo, ");
INSERT INTO otqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ar Teo, ar Toma, ne nöꞌö manꞌar Hakobo ár tꞌu̱ ar Alfeo, manꞌar Simu togo mi tꞌembabi ar ñöngahnini nꞌehe, ");
INSERT INTO otqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ar Huda nöꞌö ár jödö ar Hakobo, ne ar Huda Iskariote togo mꞌe̱fa bi da̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nepꞌu̱ ar Hesu ba kö har tꞌo̱ho̱, ba ñꞌowi nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte. Ne bi zo̱ñꞌu̱ ha nꞌar ꞌbatha habu̱ xki mhuntsꞌa nze̱ye̱ ya jöꞌi mi te̱ni. Ne mi janu̱ ma nze̱ye̱ ya jöꞌi, ma ya me Herusalen ne maꞌra ya hnini har ha̱i Nhudea, maꞌra xki ꞌñe har hnini Tiro ne Sidon ꞌbu̱ hár ñöni ar döta ñho̱nthe. Nuya jöꞌiyu̱ ba ehe nda ꞌyo̱xa nöꞌö mi mönga ar Hesu, ne nda o̱thebi yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nuꞌu̱ mi nthe̱xkwi ya tsꞌondöhi mi e̱mbabi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ne gatho ya jöꞌi xa mi ne nda da̱nga ar Hesu, ngetho nuꞌu̱ togo nda da̱ni, mi po̱nga nꞌar tsꞌe̱di mi hökwa gatho yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ar Hesu bi hyanda yá ma̱xte, ne bi ꞌñenö: —Nza̱tho nuya gi hyoyahu̱, ngetho xi nhwëkꞌahu̱ ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nza̱tho nuya gi thohu̱ ar thuhu, ngetho ma gi niñöhu̱. Nza̱tho nuya gi zoñhu̱pya, ngetho ma gi njohya gi nthehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nza̱tho núꞌmu̱ xta u̱tsaꞌihu̱ ya jöꞌi, xta guꞌahu̱, xta zañꞌahu̱, ne hinda ne da beñꞌahu̱ ri thuhuhu̱ ngu nꞌar tsꞌojöꞌi, ngetho gi te̱ñhu̱ Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nuya pa xki thohu̱ gatho nuya thogiyu̱, xa gi njohyahu̱, ngetho xa ma gi hñöñhu̱ nꞌar nthöhönu̱ mañö mhetsꞌi. Beñhu̱ mamꞌe̱tꞌo, gatho nuyá mꞌe̱hni ar tsi Dada bi ntꞌu̱tsa nguꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ha hwëkate nuꞌahu̱ te xka pe̱ꞌsu̱wa har ximha̱i. Xi göxa ri johyahu̱ xka pe̱ꞌsu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hwëkate nuꞌahu̱ hinxka thohu̱ ar thuhu, ngetho mꞌe̱fa xa ma da zitꞌahu̱ ar thuhu. Hwëkate nuꞌahu̱ xa gi johyahu̱pya, ngetho mꞌe̱fa xa ma gi nzoñhu̱ gi thohu̱ ar dumu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Hwëkateꞌihu̱ nuꞌmu̱ gatho ya jöꞌi esꞌahu̱ ri nsuhu̱, ngetho nuya jöꞌi mi ꞌbu̱ mamꞌe̱tꞌo, njapꞌu̱ mi eꞌspa yá nsu nuyá mꞌe̱hnise̱ hinxki me̱hna Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ha nuꞌahu̱ gi o̱xu̱ nöꞌö teme di mö, möhu̱ ri ñꞌu̱nihu̱, ne ꞌyo̱tꞌwabihu̱ ar ñho nuꞌu̱ togo u̱tsaꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ꞌYa̱fu̱ Jö da jöpa nuꞌu̱ togo tsañꞌahu̱, ne matꞌwabihu̱ Jö nuꞌu̱ togo ñömañꞌu̱ꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ha nuꞌmu̱ togo da me̱pꞌa nꞌa ri hmihu̱, ñhe̱hu̱ da me̱pꞌa nöꞌö manꞌa nꞌehe. Ha nuꞌmu̱ da hñömpꞌa ri pa̱tꞌihu̱, hye̱hu̱ da hñöxa ri pahnihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nuꞌmu̱ togo te da ꞌya̱ꞌahu̱, umbabihu̱. Ne nuꞌmu̱ da hñöñꞌahu̱ nꞌa te ri me̱tihu̱, yo gi a̱pabihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nöꞌö teme gi nehu̱ da ꞌyo̱tꞌahu̱ ya jöꞌi, ꞌyo̱tꞌwabihu̱ njapꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nuꞌmu̱ ho̱nse̱ gi möhu̱ togo möꞌahu̱, tema ñho gi o̱thu̱ ꞌmu̱. Ha hingi japꞌu̱ yá ñꞌohu̱ ya tsꞌokte nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne nuꞌmu̱ ho̱nse̱ gi koꞌsfu̱ ar ñho nuꞌu̱ togo xi ꞌyo̱tꞌahu̱ nꞌehe, tema ñho gi o̱thu̱ ꞌmu̱. Ngetho nuya tsꞌokte njapꞌu̱tho nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ha nuꞌmu̱ gi hmifu̱ ri bojöhu̱ ho̱nse̱ nuꞌu̱ togo gi pöhu̱ da gutꞌahu̱, tema ñho gi o̱thu̱ ꞌmu̱. Ngetho ya tsꞌokte njapꞌu̱ꞌu̱, hmipa yá bojö nuꞌu̱ togo pödi da koꞌspabi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nuꞌahu̱ möhu̱ ri ñꞌu̱nihu̱ ne ꞌyo̱tꞌwabihu̱ ar ñho. Hmipabihu̱ nöꞌö da miꞌahu̱, ne yo gi to̱ꞌmhu̱ da kosꞌahu̱. Ngetho nuꞌmu̱ gi ꞌyo̱thu̱ njapꞌu̱, ma gi hñöñhu̱ nꞌar döta nthöhö, ne da nheki yá bötsiꞌihu̱ Jö bi ꞌbu̱ mhetsꞌi. Ngetho nöꞌö pe̱ꞌspa ar tsꞌe̱ti ya tsꞌomꞌu̱i ne nuꞌu̱ hiñꞌotho yá njamödi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jange nuꞌahu̱ pe̱ꞌspabihu̱ ar hwëki gatho ya jöꞌi, ngu o̱tꞌa Jö ri Dadahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yo gi nthentehu̱, ne njapꞌu̱ hinda ntheñꞌahu̱ nꞌehe. Yo gi ñöthu̱ ar mfe̱i, ne hinda ñhötꞌahu̱ ar mfe̱i nꞌehe. Pumbabihu̱ maꞌra, ne njapꞌu̱ da mpumpꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Uñhu̱, ne da tꞌaꞌahu̱, nꞌar hoga tꞌe̱ni xi nhwötꞌi ne xa di ꞌbaxki. Ngu nöꞌö ar tꞌe̱ni gi e̱ñhu̱, getꞌar tꞌe̱ni ma da tꞌe̱ñꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nepꞌu̱ nöꞌö bi xipabiꞌu̱ nꞌar ꞌbede, ne bi ꞌñembabi: —Hage da za̱ nꞌar goda̱ da gu̱hna manꞌár migoda̱wi. Hage hinda hyo̱ gatho yoho har otsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hinjoꞌo nꞌar jöꞌi togo tꞌuti di töpa ár mfödi ár utate. Ha nuꞌmu̱ da bödi xiñho, nuꞌmú̱ hö, da ñhe̱hwi ár utate. ");
INSERT INTO otqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hanja gi handwa ár tsꞌoki ri ku, njangutho nꞌar paxi o hár da̱ꞌö, ne hanja hingi jamasu nöꞌö ri döta tsꞌoki ngu nꞌar xo̱ka za o ha ri da̱ge. ");
INSERT INTO otqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne hanja da za̱ gi ꞌñembabi ri ku: To̱ꞌmi ga höpꞌa ar paxi o ha ri da̱. Ne hanja hingi handa nöꞌö ar xo̱ka za o ha ri da̱ge. Xa gar nemhñö. Hñö mꞌe̱tꞌo nöꞌö ar za o ha ri da̱ge, ne njapꞌu̱ da za̱ gi hyanda xiñho, ne gi hñöꞌmba ar paxi o hár da̱ ri ku. ");
INSERT INTO otqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hiñꞌotho nꞌar hoga ꞌba̱iza da unga nöꞌö hingi ho da tsꞌi, wa nꞌar tsꞌoꞌba̱i da unga nöꞌö xiñho. ");
INSERT INTO otqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Föta tema zaꞌö xta födi te uni. Ngetho nuya ꞌmini hinda tsa̱ da nthu̱kwa ya iuxi, ha nuya ꞌminza hinda tsa̱ da njo ya obxi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Njapꞌu̱tho nꞌehe nꞌar hogajöꞌi o̱tꞌa nöꞌö xiñho, ngetho xi me̱ꞌsa ar ñho hár mfeni. Ha nor tsꞌomꞌu̱i jöꞌi o̱tꞌa nöꞌö hingi ho, ngetho hár mfeni hyaxtho benga nöꞌö hingi ho. Nöꞌö di pe̱ꞌsu̱ ha ma mfenihu̱, geꞌö po̱nga ha ma nehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hanja gi engagihu̱: Ma tsi Hmuꞌihe, ma tsi Hmuꞌihe, ne hingi ne gi ꞌyo̱thu̱ nöꞌö di xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nöꞌö togo da e da zu̱kagi, da ꞌyo̱xa nöꞌö di mö ne da ꞌyo̱tꞌe, ma ga xiꞌahu̱ te ñhe̱hwi. ");
INSERT INTO otqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nöꞌö ma ga he̱kwatho nꞌar ñꞌo̱ho̱ ho̱ nꞌar ngu. Bi xa̱ꞌma habu̱ da ꞌñe ár ndu̱i, bi zo̱nga habu̱ o ar medo, ne ka bi du̱ꞌmnu̱ bi gutsꞌi. Ne nu mi zo̱ ya döꞌye, ne bi gö ya nzo̱the, bi tho habu̱ mi ꞌbu̱ ar ngu. Nunar nguꞌö himbi ꞌñöni, ngetho ár ndu̱i mi foxa har medo. ");
INSERT INTO otqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ha nöꞌö togo da ꞌyo̱xa nöꞌö di mö ne hinda ꞌyo̱tꞌe, ma ga he̱kwatho nꞌar ñꞌo̱ho̱ bi hyo̱ ár ngu har ꞌbaxka ha̱i, himbi xa̱ꞌmi nda hyokwa ár ndu̱i. Ne mi zo̱ ya nzo̱the, xa mar nze̱di, ne bi textꞌa nor nguꞌö, ne xa bi hwata gatho. ");
INSERT INTO otqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mi wa ar Hesu bi zo ya jöꞌi, bi mengi bi yu̱tꞌa manꞌagi har hnini Nkapernaum. ");
INSERT INTO otqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ka mi ꞌbu̱hnu̱ nꞌar döndogu me Nroma, mi ꞌñe nꞌár ꞌbe̱go xa mi mödi, ne mi hñeni, xa mi ntsꞌe̱di, ꞌbu̱tho nda du. ");
INSERT INTO otqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nunar döndogu mi ꞌyo̱de mi nho̱nga ar Hesu, bi me̱hna ꞌra ya ndöxodyo, nda ꞌya̱pa ar möte nda e nda o̱thebi ár ꞌbe̱go. ");
INSERT INTO otqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ha nu mi zo̱ñꞌu̱ habu̱ mi ꞌbu̱ ar Hesu, xa bi ꞌya̱pa ar möte nda ma, ne bi ꞌñembabiꞌu̱: —Nunar döndogu ba pe̱nkagihe, di beñhe di ꞌñepabi gi fa̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ngetho mö ma jöꞌihu̱, go gese̱ bi mö nda thogagihe nꞌar nijö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jange ar Hesu bi me̱wi. Ne núꞌmu̱ ma nda zo̱nga hár ngu ar döndogu, bi me̱hna ꞌra yá ñꞌohu̱ nda ꞌñembabi: —Yo gi tu ri mu̱i, tsi Tata. Pengwatho, ngetho hindi ꞌñepkagi gi ku̱tꞌa ha ma ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jange hinda ne da mase̱ ma nga tsiꞌaꞌi. Nöꞌö di a̱ꞌi, ho̱nse̱ gi mö ma ꞌbe̱go da ditsꞌi, nuga di ñꞌemu̱i da njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngetho nuga ꞌbu̱ togo ꞌbe̱pkagi, ha di pe̱ꞌsa ya ndogu di ꞌbe̱pabi nꞌehe. Nuꞌmu̱ ga emba nꞌa: Di ma, da ma. Nuꞌmu̱ ga emba manꞌa: Ba ehe, da ehe. Ha nuꞌmu̱ ga emba ma ꞌbe̱go: ꞌYo̱tꞌa nunar ꞌbe̱finu̱, da ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nu mi ꞌyo̱ ar Hesu njapꞌu̱, xa bi ꞌyo̱tho. Ne bi ñhanda habu̱ mi ꞌbu̱ ar mhuntsjöꞌi mi te̱ni, ne bi ꞌñembabiꞌu̱: —Di xiꞌahu̱, hinxta tinga nꞌar me Israel di pe̱ꞌsa nꞌar jamfi ngu nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ha nu mi menga nuꞌu̱ xki mꞌe̱hni hár ngu ar ndöndogu, bi hyandwa ár ꞌbe̱go xki ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mꞌe̱fa ar Hesu bi thogi bi ma manꞌar hnini ár thuhu Nain, mi ñꞌowi yá ma̱xte, ne nze̱ye̱ ya jöꞌi mi te̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Núꞌmu̱ mi ꞌba̱i nda yu̱tꞌa har hnini, bi nthe̱wi mi po̱nga nꞌár mhuntsꞌi ya jöꞌi, ndi ma nda ꞌya̱ ár tꞌu̱ nꞌar ꞌranxu, ne ho̱nse̱nu̱ mi ꞌñehe. ");
INSERT INTO otqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ar tsi Hmu mi hyanda ar tsi ꞌbe̱hñö, xa bi hwëki ne bi ꞌñembabi: —Yo gi zoni. ");
INSERT INTO otqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nepꞌu̱ bi watꞌa habu̱ mi paꞌu̱, ne bi hñuxa ár ꞌye̱ har xithe̱ habu̱ mi oxa nöꞌö xki du. Ha nuya mi mutsꞌi bi mꞌa̱i, ne ar Hesu bi ꞌñemba nöꞌö xki du: —Tsꞌu̱ntꞌu̱, di xiꞌaꞌi gi nangi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nuꞌmú̱ nöꞌö xki du bi nangi bi hñudi, ne bi ndu̱i bi ñö. Ne ar Hesu bi da̱twabi ár nönö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ha nu mi hyanda njapꞌu̱ gatho ya jöꞌi, xa bi zu, ne bi ndu̱i bi nsunda Jö mi eñꞌu̱: —Nꞌar döta mꞌe̱hni Jö xi zo̱kagihu̱. Jö xpa pe̱hni da ma̱xkagihu̱ ár hmöka hninigihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ne gatho har ha̱i Nhudea, ne gatho nuya hnini mi ꞌbu̱ hár nthetꞌi, bi zo yá gu nöꞌö xki ꞌyo̱tꞌa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nuyá ma̱xte ar Xuwa Xixthe bi ma ba xipabi gatho nöꞌö xki thogi. Ne ar Xuwa bi zohna yoho, ");
INSERT INTO otqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","bi me̱hna ma nda ꞌya̱nga ar Hesu: Ha go geꞌe ár mꞌe̱hni Jö ma nda ehe, wa ga to̱ꞌmhe manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nuꞌmú̱ yá mꞌe̱hni ar Xuwa bi ma ba kꞌöꞌsa ar Hesu, ne bi ꞌñembabi: —Ar Xuwa Xixthe ba pe̱nje ga eñꞌahe: Ha go geꞌe ár mꞌe̱hni Jö ma nda ehe, wa ga to̱ꞌmhe manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ha núꞌmu̱ mi zo̱nga yá ma̱xte ar Xuwa, ar Hesu mi o̱the nze̱ye̱ ya da̱thi, mi e̱nga ya tsꞌondöhi, ne mi o̱the nze̱ye̱ ya goda̱. ");
INSERT INTO otqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jange nöꞌö bi dödi ne bi ꞌñembabiꞌu̱: —Di möhu̱ ne ba xipabihu̱ ar Xuwa nöꞌö xka jwadi xka hyanthu̱ ne xka ꞌyo̱hu̱. Xipabihu̱ nuya goda̱ xo yá da̱, nuya dowa ꞌyo, ha nuꞌu̱ tsu̱ ar tsitꞌandoꞌyo thitsꞌi. Nuya gogu o̱de, ne nuya xki du pengi da nte, ha nuya tsi hyoya xi nsipabi ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ne nza̱tho nöꞌö togo hinda u̱ ár mu̱i xi zo ár gu nöꞌö di pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ha nu mi menga yá ma̱xte ar Xuwa, ar Hesu bi ndu̱i bi no̱nga ar Xuwa, ne bi ꞌñemba ya jöꞌi: —Togo ma ga hyanthu̱ har otꞌatꞌo̱ho̱. Hage ma ga hyanthu̱ nꞌar ñꞌo̱ho̱ mi otho ár tsꞌe̱di, ngu nꞌar xithi mi hwönda ar ndöhi. Hinꞌö wainꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Xiꞌmu̱ teme ga po̱ñhu̱ ma ga hyanthu̱. Hage nꞌar ñꞌo̱ho̱ mi he ya dutu xi mhödi. Hinꞌö, ngetho nuꞌu̱ kö ya nza̱tho dutu ne pe̱ꞌsa gatho nöꞌö ne, ꞌbu̱ ha yá ngu ya ndöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tema ga po̱ñhu̱ ga hyanthu̱ ꞌmu̱. Nꞌár mꞌe̱hni Jö. Hö, ne di xiꞌahu̱ hinge ho̱nse̱ nꞌár mꞌe̱hni Jö, pe̱ꞌsa manꞌar döta nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gehnu̱ xki nho̱nga mamꞌe̱tꞌo har Tꞌofo habu̱ enö: Nuga di pe̱hna ma mꞌe̱hni da mꞌe̱tꞌo, da hyokꞌa ar ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nuga di xiꞌahu̱, hinxi mꞌu̱ manꞌár mꞌe̱hni Jö togo xi me̱ꞌsa ár nsu ngu ar Xuwa Xixthe. Ha nuꞌu̱ xi yu̱tꞌa hár tsꞌu̱tꞌwi Jö, mödi nheki hinte pe̱ꞌsa yá nsu, töpa ár nsu ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Gatho nuꞌu̱ ya jöꞌi mi o̱xa nöꞌö mi mönga ar Xuwa, ne nuꞌu̱ ya njotbojö bi hñömbár xixthe, mi da̱majöni xiñho gatho nöꞌö o̱tꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ha nuya de̱ngaꞌbe̱pate ne ya bötꞌofo, himbi numañho, ne himbi hñönga nunar ñho mi ne nda ꞌyo̱tꞌwa Jö. Jange himbi neꞌu̱ nda xixthe ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ne ar tsi Hmu bi ꞌñenö: —Togo ga he̱kwabi nuya jöꞌi ꞌbu̱ nuya payu̱, ne togo di hñötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nuꞌu̱ di hñöxa ya bötsi hu har ta̱i ñꞌeni, ne matꞌa yá mibötsiwi, enö: Da hu̱xthe ma nthu̱zahe, ne hinga nehu̱. Da ntuhe ya thuhu dumu̱i, ne hinga nzoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jange nuꞌahu̱ di hñöxꞌahu̱ nuꞌu̱ ya bötsiꞌu̱, gi hanthu̱ gatho hingi ho. Ngetho ga hyanthu̱ bi zo̱ ar Xuwa, hinto mi ñungwi, hinto mi ntsixkwi, ne ngi emfu̱ mi pe̱ꞌsa ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mꞌe̱fa bi zo̱ Nöꞌö Togo ba e bi Njöꞌi, ñungwi ne ntsixkwi ya jöꞌi, gi emfu̱ xa tsu̱ ar tsꞌoꞌyo ne ar nti, ár ñꞌowi ya njotbojö ne ya ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ha nöꞌö togo pe̱ꞌsa ar hoga mfödi, nhekitho ha yá hoga ꞌbe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nꞌar de̱ngaꞌbe̱pate bi zohna ar Hesu hár ngu nda ñungwi. Ne núꞌmu̱ mi zo̱ni bi yu̱tꞌa har ngu ne bi hñuxa har mexa. ");
INSERT INTO otqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mi ꞌbu̱hnu̱ nꞌar tsꞌoꞌbe̱hñö har hniniꞌö. Mi bödi xki zo̱hnu̱ ar Hesu hár ngu ar de̱ngaꞌbe̱pate nda ñunu̱, bi ma ba kꞌötsꞌi. Ne bi hñöxa nꞌar xito tꞌaxdo, mi po nꞌar ñu̱ni xa mi yu̱ni xiñho. ");
INSERT INTO otqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mi zo̱ni bi nda̱ndihmö hár wa ar Hesu, xa bi hñu ár mu̱i bi nzoni. Nuyá gida̱ mi nöꞌmi, mi xu̱kwa yá wa ar Hesu, ne mi ju̱ yá xtö mi thukwabi. Xa mi tsu̱spabi, ne mi koꞌspa nöꞌö ar hogañu̱ni mi hö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nu mi hyanda ar de̱ngaꞌbe̱pate xki zohna ar Hesu hár ngu, mi ense̱ hár mfeni: Nuꞌmu̱ majöni ár mꞌe̱hni Jö nunar ñꞌo̱ho̱nu̱, di pöhmö tema ꞌbe̱hñö tha̱mba ár wa, ngetho nꞌar tsꞌoꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jange ar Hesu bi ꞌñembabi ar de̱ngaꞌbe̱pate: —Ha gi o̱de Simu. Di ne ga xiꞌaꞌi nꞌar ꞌbede. Ar Simu bi dödi ne bi ꞌñembabi: —Xikagi, ma tsi Utateꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne bi ꞌñenga ar Hesu: —Nꞌagi yoho ya ñꞌo̱ho̱ mi tupa nꞌar hmibojö. Nꞌa mi tu ku̱tꞌanthebe ya tꞌaxbojö, ha nöꞌö manꞌa mi tu madenthebe. ");
INSERT INTO otqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ha nuꞌu̱ himi tsa̱ nda gutꞌwa ár bojö nöꞌö togo xki hmipabi. Jange nöꞌö ar hmibojö, bi pumbabi yá tha̱i. Xikagipya, nuya yoho ya ñꞌo̱ho̱yu̱ bi mpumbabi yá tha̱i, togo mi tsitꞌa ár mu̱i mi mö togo xki hmi ar bojö. ");
INSERT INTO otqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nuꞌmú̱ ar Simu bi dödi ne bi ꞌñenö: —Za di enga nöꞌö ar ñꞌo̱ho̱ mi tu nze̱ye̱. Ar Hesu bi ꞌñembabi: —Hö, xka thödi xiñho. ");
INSERT INTO otqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nepꞌu̱ bi ñhanda habu̱ mi ꞌbu̱ ar ꞌbe̱hñö, ne bi ꞌñembabi ar Simu: —Nu nda tso̱kwa ri ngu, hinxka ꞌrakatsꞌu̱ ar dehe ga xu̱ka ma wa. Ha ndimhö, nunar ꞌbe̱hñönu̱, xi nöꞌma yá gida̱ xi xu̱ga ma wa, ne xi gu̱ yá xtö xi duki. ");
INSERT INTO otqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nuꞌge hinxka tsu̱ski ngu ma ntꞌumbihu̱. Ha nunar ꞌbe̱hñönu̱, ja nda ku̱tꞌatho, hingi tsa̱ya̱ tsu̱ska ma wa. ");
INSERT INTO otqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nuꞌge hinga koꞌska ar nziki ma ñö, ha nunar tsi ꞌbe̱hñönu̱ xi goska ma wa nꞌar hogañu̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jange di xiꞌaꞌipya, nunar ꞌbe̱hñönu̱ xi mpumbabi gatho yá tsꞌoki, mödi nze̱ye̱ xki ꞌyo̱tꞌe, jange xa ja nze̱ye̱ ár mhöte. Ha nöꞌö hingi nze̱ye̱ ár tsꞌoki xi mpumbabi, hingi nze̱ ár mhöte. ");
INSERT INTO otqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nuꞌmú̱ ar Hesu bi ꞌñembabi ar ꞌbe̱hñö: —Xta pumpꞌaꞌi gatho ri tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ha gatho nuꞌu̱ maꞌra ya jöꞌi mi huhwinu̱ har mexa, bi ndu̱i bi bense̱ ha yá mfeni, ne mi eñꞌu̱: —Togopyanu̱, pumba yá tsꞌoki ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ha nu ar Hesu bi ꞌñembabi ar ꞌbe̱hñö: —Gi ñꞌemu̱i, jange xka mpo̱ho̱, ha nupya di ma ter entho. ");
INSERT INTO otqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mi tho gathoyu̱, ar Hesu bi ñꞌo mi tso̱nga ya döhni ne ya tꞌu̱lo hnini, mi zohna ya jöꞌi, ne mi xipabiꞌu̱ ar hoga mhö no̱nga ár tsꞌu̱tꞌwi Jö. Ne mi ñꞌowi nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mi te̱nga ꞌra ya ꞌbe̱hñö nꞌehe, nuya xki o̱thebi yá hñeni, ne nuya xki ꞌye̱mba ya tsꞌondöhi. Nꞌa már thuhu ar Maria mi tꞌembabi me Magdala, nöꞌö xki tꞌe̱mbabi yoto ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mi te̱ñꞌu̱ ar Huana, nöꞌö már ꞌbe̱hñö nꞌar ñꞌo̱ho̱ már thuhu ar Txusa, mar ndöngi mi pe̱pa ar ndö Erode. Mi te̱ñꞌu̱ nꞌehe ar Txana, ne maꞌra ya ꞌbe̱hñö nuꞌu̱ mi fa̱xa ar Hesu, mi unga yá ñho mi pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mi mhuntsꞌa nze̱ye̱ ya jöꞌi, ne maꞌra mi ꞌyo mi po̱nga ha yá hnini mi e mi kꞌötsꞌi, ar Hesu bi metwa nꞌar ꞌbede, ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Nꞌar pa nꞌar motꞌi bi ma nda mpotꞌa hár hwöhi. Núꞌmu̱ mi mpontꞌe̱i, ꞌra bi zo har ꞌñu. Mi tho ya jöꞌi bi netsꞌi, ne ba e ya tsꞌintsꞌu̱ bi go bi za. ");
INSERT INTO otqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ha nu maꞌra bi zo ha ya do habu̱ himi köxa nze̱ ar ha̱i. Nu mi kꞌontsꞌi, bi ꞌyotꞌatho, ngetho bi kꞌatꞌa ár xa ar ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nu maꞌra bi zo habu̱ mi ja ya ꞌmini. Nu mi kꞌontsꞌi bi tewi mahye̱gi, bi xuhña ne bi otꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ha nu maꞌra bi zo habu̱ mar ñho ar ha̱i, ne nu mi hoꞌyaꞌu̱, xa bi unga nꞌar hoga sofo, bi unga nꞌanthebe nꞌa ngu nꞌa ar ꞌba̱i. Nu mi wadi bi mönga njapꞌu̱, bi zo ntsꞌe̱di ya jöꞌi, ne bi ꞌñembabi: —Nuꞌu̱ togo tu yá gu, dá ꞌyo̱xa nöꞌö te di mö. ");
INSERT INTO otqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yá ma̱xte bi ꞌya̱mba ar Hesu ne bi ꞌñembabi: —Teme di bo̱nga nunar ꞌbedenu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ha nöꞌö bi dödi ne bi ꞌñembabiꞌu̱: —Nuꞌahu̱ xi utꞌahu̱ Jö nöꞌö hinxki fö mamꞌe̱tꞌo tengu ár tsꞌu̱tꞌwiꞌö. Ha nu maꞌra ya jöꞌi, di zofo mꞌede. Da hyandi ne hinda bödi teme̱ꞌö, ne da ꞌyo̱de ne hinda zo yá mfeni tema di bo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nunar ꞌbedenu̱ xka jwadi xka ꞌyo̱hu̱, di bo̱ni da ꞌñenö: Nöꞌö te ꞌbotꞌi, gehnu̱ ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ha nuya bi zo har ꞌñu, jangu nuꞌu̱ xi ꞌyo̱ ár mhö Jö. Ne xta ꞌñepꞌu̱ ar tsꞌondöhi da hñömba ar mhö xki zohmö ár mu̱i, njapꞌu̱ hinda ñꞌemu̱i ne hinda mpo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ha nu maꞌra bi zo ha ya do, ñhe̱hwi nuꞌu̱ xi ꞌyo̱ ár mhö Jö, ne johya höni, po̱ntho hinxi nu̱nga yá ꞌyu̱. Jamfi ꞌra ya tsi pa, ne xta epꞌu̱ ya tsꞌothogi da ꞌwege. ");
INSERT INTO otqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nuya bi zo ha ya ꞌmini, di hñöxa nuꞌu̱ togo xi ꞌyo̱ ár mhö Jö, ne tupár mu̱i gatho nöꞌö te jawa har ximha̱i, ne ñhe̱gi da ka ar bojö, ne umba gatho te ne ár te. Njapꞌu̱ ꞌramtxꞌu̱ da ꞌbe̱di gatho nöꞌö te xi ꞌyo̱de, po̱ntho hinte unga ar sofo. ");
INSERT INTO otqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ha nuꞌu̱ bi zo habu̱ mar ñho ar ha̱i, njangu nuꞌu̱ togo e̱ntꞌa yá mu̱i da ꞌyo̱twa ár mhö Jö, ne da kwata xiñho nöꞌö xi ꞌyo̱de, to̱ꞌmi da unga ar hoga sofo. ");
INSERT INTO otqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ar Hesu bi ꞌñenö nꞌehe: —Hinto tso̱ nꞌar ñotꞌi ne da goꞌma ha nꞌar tsꞌo̱i, wa da ꞌñö ha nꞌar fidi ne hinda yotꞌi. Nöꞌö da me̱fi, da ꞌñexa har mfoxꞌyo, ne njapꞌu̱ gatho nuꞌu̱ da yu̱tꞌi da tsa̱ da hyandi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Njapꞌu̱tho nꞌehe gatho nöꞌö tꞌo̱tꞌa ñꞌöntho, nꞌar pa ma da födi, ne ma da bo̱xa gatho nöꞌö xi joꞌmi, ne da födi xiñho. ");
INSERT INTO otqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jange hyanthu̱ xiñho tema gi o̱hu̱, ngetho nuꞌmu̱ gi kwathu̱ xiñho nöꞌö nsiꞌahu̱, ma da thusꞌahu̱ ár nze̱ye̱. Ha nöꞌö togo hingi kwati, da thömba nöꞌö mi beni mi pe̱ꞌshmö. ");
INSERT INTO otqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nꞌagi mi uta ya jöꞌi, nꞌa mbi zo̱ta ár nönö ne yá jödö, ha himbi za̱ bi yu̱tꞌa habu̱ mi ꞌbu̱ꞌö, ngetho xa xki watꞌa nze̱ye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ne bi tꞌembabi ar Hesu: —Bi zo̱ ri nönö ne ri jödö, to̱pꞌa nthi gi ñöwi ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ar Hesu bi dödi ne bi ꞌñenö: —Nuꞌu̱ togo xi ꞌyo̱ ár mhö Jö ne da ꞌyo̱tꞌe, go gehyu̱ ma nönö ne ma jödö. ");
INSERT INTO otqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nꞌar pa ar Hesu bi bo̱xa ha nꞌar motsa bi me̱wi yá ma̱xte, ne bi ꞌñembabiꞌu̱: —Möhö ꞌrandi ar dehe. Ne bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nu mi pa har dehe, ar Hesu bi ñꞌöhö. Ne mi da̱ñꞌu̱ bi ñꞌo nꞌar ꞌyomndöhi, ne yá mfe̱tsꞌi ar dehe mi hexta ar motsa, ꞌbu̱tho nda yu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nuꞌmú̱ nuyá ma̱xte dama ba a̱ ar Hesu, ne bi ꞌñembabi: —Ma tsi Utateꞌihe, ꞌbu̱tho ga jöthu̱. Ar Hesu bi nankꞌmu̱ bi zu̱ ar ꞌyomndöhi ne ar ñho̱nthe. Nuꞌmú̱ dama bi ntsa̱ya̱ gatho, xa bi ñhetho. ");
INSERT INTO otqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nepꞌu̱ ar Hesu bi ꞌñembabi yá ma̱xte: —Te bi ja ri jamfihu̱. Ha nuꞌu̱ xa bi ntsu, mi ꞌyo̱tho nöꞌö bi ꞌyo̱tꞌa ar Hesu, ne mi eñꞌu̱ nꞌa ngu nꞌa: —Togonu̱ ꞌmu̱. Ar ꞌyomndöhi ne ar dehe o̱te nöꞌö ꞌbe̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nu mi ꞌranga ar dehe, ne bi zo̱nga har ha̱i Gadara, mi ꞌbu̱ hár ñöni ar ñho̱nthe, mi ñhandwitho ar ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ha nu mi gö ar Hesu har motsa, nꞌa mba epꞌu̱tho bi zu̱ nꞌar ñꞌo̱ho̱ mar mengunu̱. Mi pe̱ꞌsa nze̱ye̱ ya pa xki nthe̱xkwi ya tsꞌondöhi, hinte mi he ar dutu, himi ꞌbu̱ hár ngu, mi haxa ha ya tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ne nu mi hyanda ar Hesu, ba e bi nda̱ndihmö hár wa, ne bi hye̱xa nꞌar mhafi bi ꞌñenö: —Te gi hongwa, Hesu ár Tꞌu̱ꞌi Jö bi ꞌbu̱ mhetsꞌi. Xa di a̱ꞌaꞌi, yo ma gi ꞌraka ar mfe̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Bi mönga njapꞌu̱ ngetho ar Hesu mi ꞌbe̱pa ar tsꞌondöhi nda bo̱ni. Mi pe̱ꞌsa nze̱ye̱ ya pa xki nthe̱xkwi nunar ñꞌo̱ho̱nu̱, ne xa te gatho mi japi. Nuya jöꞌi nda gu̱ ne nda dötꞌa ya nthöhibo̱jö, ha mi xe̱ktho. Ha nöꞌö ar tsꞌondöhi mi japi nda bo̱ni nda ma ha ya otꞌatꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ar Hesu bi ꞌya̱mbabi ne bi ꞌñenö: —Temár huꞌi. Nöꞌö bi dödi ne bi ꞌñenö: —Nꞌa mutꞌi. Bi mönga njapꞌu̱, ngetho xa xki yu̱tꞌa nze̱ye̱ ya tsꞌondöhi har ñꞌo̱ho̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ha nuꞌu̱ ya tsꞌondöhi xa bi ꞌya̱pa ar Hesu hinge nda me̱hna har ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Xa mi ꞌyonu̱ nze̱ye̱ ya tsꞌu̱di, mi ñunga har ngwani. Jange ya tsꞌondöhi xa bi ꞌya̱pa ar Hesu nda umba ar se̱ki nda yu̱tꞌa ha ya tsꞌu̱diyu̱. Ne nöꞌö bi umba ar se̱ki. ");
INSERT INTO otqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jange ya tsꞌondöhi dama bi hye̱ ar ñꞌo̱ho̱, bi ma ba ku̱tꞌa ha ya tsꞌu̱di. Nuya tsꞌu̱diyu̱ bi nixtꞌi ma ba ñho̱ har maꞌye, ba tso har dehe habu̱ ba jötꞌa xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ne nuꞌu̱ togo mi su ya tsꞌu̱di, mi hyandi xa bi ntsu, bi hye̱ ar nhixtꞌi ma ba ꞌyonga ar ꞌbede har hnini ne gatho ár nthetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gatho ya jöꞌi bi ma ba handase̱ nöꞌö xki nsipabi. Ne mi zo̱ñꞌu̱ habu̱ mi ꞌbu̱ ar Hesu, ka bi zu̱hnu̱ nöꞌö ar ñꞌo̱ho̱ xki tꞌe̱mbabi ya tsꞌondöhi, mi huhnu̱ hár wa, xki hye ár dutu, ne mi ja ár mfeni. Ne xa bi zuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nepꞌu̱ nuꞌu̱ mi ꞌbu̱hnu̱ ne xki hyanda nöꞌö xki thogi, mi xipabiꞌu̱ hanja xki mengi xki mꞌu̱i xiñho nöꞌö ar ñꞌo̱ho̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nuꞌmú̱ gatho ya me Gadara bi ꞌya̱pa ar möte ar Hesu nda bo̱ni nda zokwabinu̱ yá ha̱i, ngetho xa mi ntsuꞌu̱. Jange ar Hesu bi bo̱xa har motsa, ne bi mengi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ha nöꞌö ar ñꞌo̱ho̱ xki tꞌe̱mba ya tsꞌondöhi, xa mi a̱pa ar Hesu nda umba ar se̱ki nda de̱ni. Nöꞌö bi xipabi nda gohi, ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Di ma ri ngu, ne gi xipabi gatho ya jöꞌi nuꞌu̱ ya döta ntꞌudi xi hwëkꞌa Jö. Jange bi mengi, ne bi ndu̱i bi xipabi gatho ya jöꞌi tengu ar döta ya ntꞌudi xki hwëkwa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Núꞌmu̱ mba penga ar Hesu ꞌrandi ar dehe, ya jöꞌi xa bi njohya mi hyandi, ngetho mi to̱ꞌmtho nda pengi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nꞌa mba epꞌu̱tho nꞌar ñꞌo̱ho̱ már thuhu ar Hairo, mar ndö hár nijö ya xodyonu̱. Bi nda̱ndihmö hár wa ar Hesu, ne bi ꞌya̱pa ar möte nda me̱wi hár ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngetho ár tꞌinxu mi ntsa̱wi ar ndöte. Ho̱nse̱ ár tꞌinxunu̱ mi ꞌñehe, ne mi pe̱ꞌsa ꞌre̱tꞌa ma yonje̱ye̱. Jange ar Hesu bi me̱wi. Ne nu mi ma, ra nze̱ ya jöꞌi bi de̱ni, xa mi tsꞌitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Núnu̱ hár mhuntsꞌi ya jöꞌi, ka mi panu̱ nꞌar ꞌbe̱hñö xki tho ꞌre̱tꞌa ma yonje̱ye̱ xki xotꞌwa ya ji. Ne xa xki de gatho nöꞌö mi pe̱tsꞌi mi honi nda ñꞌo̱thehmö, ne hinxki za̱ nda ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nunar ꞌbe̱hñönu̱ bi watꞌa hár xu̱tha ar Hesu, bi da̱mba ár ñöni ár pa̱tꞌi. Ne dama bi ditsꞌi, ne bi ntsa̱ya̱ nöꞌö mi xotꞌwa ya ji. ");
INSERT INTO otqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nuꞌmú̱ ar Hesu bi ñꞌa̱ni ne bi ꞌñenö: —Togo xi da̱ngagi. Gatho ya jöꞌi bi nko̱ni. Ha nu ar Pedro ne nu maꞌra mi ñꞌowi, bi ꞌñembabi ar Hesu: —Ma tsi Utateꞌihe, gi nuse̱ nze̱ye̱ ya jöꞌi xa tsꞌisꞌi, ne ꞌbu̱tho da ꞌyentꞌaꞌi. Yoꞌö gi ñꞌa̱ni togo xi da̱ñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ha nu ar Hesu bi ꞌñenö: —Di pödi xi ntha̱ngagi, ngetho da tsa̱ bi bo̱nga ar tsꞌe̱di ha ma ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nu mi hyanda ar ꞌbe̱hñö xki böta ar Hesu xki tha̱mba ár pa̱tꞌi, ba e bi nda̱ndihmö hár wa, ne xa mi nhwötꞌi. Madeda ya jöꞌi bi da̱majöni yoꞌö xki da̱ñꞌö, ne bi mö, núꞌmu̱ mi da̱mba ár ñöni ár pa̱tꞌi, dama bi ntsa̱ya̱ ar hñeni mi thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Ma tsi tꞌinxuꞌi, nuna ri jamfi xi ma̱xꞌi xi dixꞌi. Di ma ter entho. ");
INSERT INTO otqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mi ñöda ar Hesu, nꞌa mbi zo̱ta nꞌar ñꞌo̱ho̱ xki ꞌñe hár ngu ar Hairo már ndö har nijö, ne bi ꞌñembabi: —Yo gi hökwa ár ꞌbe̱fi ar Utate, ngetho xi du ri tꞌinxu. ");
INSERT INTO otqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ha nu mi ꞌyo̱ njapꞌu̱ ar Hesu, bi ꞌñembabi ar Hairo: —Yo gi tu ri mu̱i, ho̱nse̱ gi jamfi ne ri tꞌinxu da kꞌontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nu mi zo̱nga hár ngu ar Hairo, ar Hesu hinto maꞌra bi hye̱gi bi yu̱tꞌi, ho̱nse̱ ar Pedro, ar Hakobo, ar Xuwa, ár dada ne ár nönö ar nxutsi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nze̱ye̱ ya jöꞌi xki mhuntsꞌa nthi, xa mi zontꞌi ne mi mafi. Ar Hesu bi ꞌñembabiꞌu̱: —Yo gi zoñhu̱, ngetho nunar nxutsi hinxi du, ötho. ");
INSERT INTO otqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ha nuꞌu̱ bi dentho, ngetho mi pöꞌu̱ xiñho xki du. ");
INSERT INTO otqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nepꞌu̱ ar Hesu bi mipa ár ꞌye̱ ar nxutsi, ne bi matꞌi ntsꞌe̱di: —Nangi nxutsi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ar nxutsi bi menga ár pa, ne dama bi nangi. Nepꞌu̱ ar Hesu bi mö nda tꞌumba te nda zi. ");
INSERT INTO otqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ha nu ár dada ne ár nönö xa mi ꞌyo̱tho. Ne nu ar Hesu bi hñuꞌmba yá mu̱i hinto nda xipabi nöꞌö xki thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ha nu ar Hesu bi muntsꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, ne bi umba ar tsꞌe̱di nda ꞌye̱nga gatho ya tsꞌondöhi, ne nda o̱thebi yá hñeni ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne bi me̱hni nda xipa ár tsꞌu̱tꞌwi Jö ya jöꞌi, ne nda o̱thebi yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne bi ꞌñembabiꞌu̱: —Yo te gi höxu̱ nöꞌö gi hoñhu̱ har ꞌñu. Yo gi höxu̱ ri ndo̱ho̱hu̱, wa nꞌar ꞌro̱zö, wa te gi tsihu̱, wa ar bojö, yo ma gi hñöxu̱ yo mponi ar dutu. ");
INSERT INTO otqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nor ngu habu̱ ma gi tso̱ñhu̱, ka gi po̱nthu̱nu̱ núꞌmu̱ xki möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne nöꞌö ar hnini habu̱ hinda ne da tꞌaꞌahu̱ ar se̱ki gi kohu̱, po̱ñhu̱, ne hwöju̱ ár fontha̱i ri thizahu̱. Njapꞌu da böꞌu̱ hinda ma da kꞌontꞌa ár kwe̱ Jö, ngetho himbi ne bi ꞌyo̱xa nöꞌö ga xifu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ne nu mi wadi bi xipa ar Hesu te nda ꞌyo̱tꞌu̱, bi nxañꞌu̱ ha gatho ya hnini, mi mönga ar hoga mhö, ne mi o̱thebi yá hñeni ya jöꞌi habu̱ gatho mi tso̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ar ndö Erode bi zo ár gu nöꞌö mi o̱tꞌa ar Hesu, ne himi pödi te nda beni, ngetho nꞌañꞌo mi mönga nꞌa ngu nꞌa. ꞌRa mi enö ma ar Xuwa Xixthe xki mengi xki nte. ");
INSERT INTO otqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Maꞌra mi enö már mꞌe̱hni Jö Elia xki menga har ximha̱i. Ha nu maꞌra mi enö nꞌár mꞌe̱hni Jö mi ꞌbu̱ mahamꞌu̱ xki mengi xki nte. ");
INSERT INTO otqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nuꞌmú̱ ar ndö Erode mi ense̱: —Ha hinge go gekase̱ da ꞌbe̱pa togo bi hye̱kwa ár ñö ar Xuwa. Togo di o̱de mhö o̱tꞌa ya döta ꞌbe̱fi ꞌmu̱. Ne mi honi hanja nda tsa̱ nda hyanda ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yá ma̱xte ar Hesu mba pengi mi petwabi gatho nöꞌö xki ꞌyo̱tꞌu̱. Mꞌe̱fa bi zixyu̱ nda me̱wi habu̱ hinte mi ꞌbu̱ ya jöꞌi, getꞌu̱ ar hnini Betsaida. ");
INSERT INTO otqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ha nu mi bö ya jöꞌi ndi manu̱, bi de̱ni. Ne nu mi zo̱ñꞌu̱, ar Hesu himbi kotsꞌi, bi metwabi ár tsꞌu̱tꞌwi Jö, ne bi o̱thebi yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nu mi nde, bi watꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, ne bi ꞌñembabi: —Di za̱ gi pe̱hna ya jöꞌi da mfontꞌi, da ma ha ya tꞌu̱lo hnini ne ya ngu ꞌbu̱ har nthetꞌi, ma da hyonga te da zi ne habu̱ da ñꞌoxi. Ngetho habu̱ di ꞌbu̱hu̱, teme da dingwa te da zi har tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Go gi umfu̱ te da ziyu̱. Nuꞌu̱ bi dödi ne bi ꞌñembabi: —Teme ga umfe. Ho̱nse̱ ku̱tꞌa ya thuhme ne yoho ya tsi hwö di höhe. Wa gi ne ga ta̱mfe te da zi gathoyu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Xa mi ra nze̱ye̱ ya jöꞌi, ho̱nse̱ ya ñꞌo̱ho̱ mi tsu̱ ngu ngu̱dminthebe. Ha nunar Hesu bi ꞌñembabi yá ma̱xte: —Xifu̱ da hñu madenthebe nꞌa ngu nꞌa ya mutꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Njapꞌu̱ bi ꞌyo̱tꞌu̱, ne bi japa gatho bi hñudi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ar Hesu bi hñönga nuꞌu̱ ku̱tꞌa ya thuhme ne yoho ya tsi hwö, bi no̱ꞌsa mhetsꞌi, bi jöpi. Bi heke ne bi thokwa yá ma̱xte, ne nuyu̱ bi hyemba ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gatho ya jöꞌi bi ñuni ne xa bi niñö. Mꞌe̱fa bi njo ya xe̱ni thuhme xki bongi, ne bi ñhuꞌsa ꞌre̱tꞌamayoho ya ꞌbo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nꞌagi ar Hesu mi ꞌbu̱se̱ ngetho xki ma nda ꞌya̱pa Jö, ho̱nse̱ yá ma̱xte mi ñꞌowi. Nꞌa mbi ꞌya̱mbathoꞌu̱, ne bi ꞌñembabi: —Togo benga ya jöꞌi go geke ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bi döꞌu̱ njawa: —ꞌRa enö gar Xuwa Xixthe, maꞌra enö gar mꞌe̱hni Elia, ne maꞌra enö go geꞌe nꞌa nuyá mꞌe̱hni Jö mi ꞌbu̱ mamꞌe̱tꞌo, xi mengi xi nte. ");
INSERT INTO otqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Xiꞌahu̱, togo gi eñhu̱ go gekaga. Ar Pedro bi dödi, ne bi ꞌñenö: —Nuꞌge go gar Kristo xi ꞌñexꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nuꞌmú̱ ar Hesu bi hñuꞌmba yá mu̱i hinto nda xipabi togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ne bi ꞌñembabi: —Nöꞌö Togo ba e bi Njöꞌi, mahyoni nda tho nze̱ye̱ ya thogi. Nda u̱tsa ya dönziandö, ya ndömöjö ne ya bötꞌofo, ne nda tho. Ha nu ár hñupa nda mengi nda nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mꞌe̱fa bi zo gatho ya jöꞌi xki mhuntsꞌi, ne bi ꞌñembabi: —Nöꞌö togo ne da de̱ngagi, mahyoni da pumhnise̱ ár te, ne hyaxꞌmu̱ da ñꞌe̱ntꞌatho ga ñꞌoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ngetho nöꞌö togo ne da japi da kꞌontꞌa ár te, ma da ꞌbe̱di. Ha nöꞌö togo e̱ntꞌi da unga ár te da de̱ngagi, ma da dinga ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tema ñho da gu̱kwa nꞌar jöꞌi, da döhö gatho nöꞌö te jawa har ximha̱i, ne da ꞌbe̱ ár pa. ");
INSERT INTO otqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nöꞌö togo da ntsa̱ da da̱majöni pökagi ne da mönga ma mhö, Nuga Xta e ga Njöꞌi ma ga ntsa̱ga nꞌehe xka ehe di nheki ma nsunda, ne ga hömpa ár nsunda ma Dada, ne gar ñꞌoꞌbe ya hoga e̱nxe̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Xa majöni di xiꞌahu̱, ꞌra gi ꞌbu̱hu̱wa hinge ma gi tuhu̱, mꞌe̱tꞌo gi hyandwabihu̱ ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mi tho ñhöto mpa xki wadi xki mönga ar Hesu njapꞌu̱, bi bo̱xa ha nꞌar tꞌo̱ho̱ nda ñöwi Jö ár Dada, ne bi zixa ar Pedro, ar Hakobo ne ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Núꞌmu̱ mi ñöwi Jö, bi mpa̱ta ár hmi, ne ár he xa bi tꞌaxki ne mi hyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ne bi nhekinu̱ yoho ya ñꞌo̱ho̱ mi ꞌba̱hwi mi ñöwi, mar Moise ne ar Elia. ");
INSERT INTO otqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Habu̱ mi ꞌba̱ꞌu̱ xki goꞌmatho nꞌar hyatsꞌi. Mi no̱ñꞌu̱ ár ndöte ar Hesu ma nda thohnu̱ Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nu ar Pedro ne nuꞌu̱ mi ñꞌowi xa mi tsu̱ nꞌar tꞌöhö, ha himbi döhö. Ne bi hyanda ar nsunda mi nheki har Hesu ne nuꞌu̱ yoho ya ñꞌo̱ho̱ mi ꞌba̱hwi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Núꞌmu̱ mi ꞌba̱i nda ñꞌedi nuya ñꞌo̱ho̱yu̱, ar Pedro bi ꞌñenö: —Ma tsi Utateꞌi, xiñho ga ꞌbu̱hu̱wa. Te gi mö, ga hoje hñu ya mꞌetꞌe, nꞌa habu̱ gi ꞌbu̱ke, nꞌa habu̱ da mꞌu̱ ar Moise, ne manꞌa habu̱ da mꞌu̱ ar Elia. Ngetho ar Pedro himi pödi teme mi mö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Himi jwadi nda mönga njapꞌu̱, nꞌa mbi nhekitho nꞌar gui, xa bi goꞌmathoꞌu̱, ne xa bi ntsuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne har gui bi nheki nꞌar mhö, bi ꞌñenö: —Gehnu̱ ma hmöka Tꞌu̱. ꞌYo̱hu̱ nöꞌö xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mi ñhe nu ar mhöꞌö, ka bi hyantꞌu̱ mi ho̱nse̱ ar Hesu mi ꞌba̱hnu̱. Ha nuyu̱ hinte bi mö, ne hinto bi xipabi nuya paꞌu̱ nöꞌö xki hyantꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ár hyaxꞌö ba köꞌu̱ har tꞌo̱ho̱, ne ra nze̱ye̱ ya jöꞌi bi ma ba kꞌöꞌsnu̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nꞌa mbi ñö ntsꞌe̱di nꞌar ñꞌo̱ho̱ madeda ya jöꞌi, ne bi ꞌñemba ar Hesu: —Tsi Utate, ꞌyo̱tka ar möte gi e gi nutka ma tꞌu̱, ngetho ho̱nse̱ꞌö di ꞌñehe. ");
INSERT INTO otqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nthe̱xkwi nꞌar tsꞌondöhi, ne nu xta umbabi japi da mafi. Xa hwötsꞌi, ne xa e̱ntsꞌa ya fu̱gi hár ne. Xa fo̱mi, ꞌbe̱di da hye̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xta a̱pahmö nuya ri ma̱xte da ꞌye̱ni, ne hinte xi japabi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñenö: —Yá bötsiꞌihu̱ ya me̱ꞌsku ne gar tsꞌojöꞌihu̱. Hangu ma ga ꞌbu̱hwithohu̱ ne ga pe̱sꞌahu̱ ar tsꞌe̱ti. Ba tsinkawa ri tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nu mi tsꞌimpabi ar Hesu nöꞌö ar bötsiꞌö, ar tsꞌondöhi bi fo̱ma har ha̱i, ne xa mi hwötsꞌi. Nuꞌmú̱ ar Hesu bi ꞌye̱nga ar tsꞌondöhi, bi o̱the ar bötsi, ne bi mengi bi da̱twa ár dada. ");
INSERT INTO otqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Gatho ya jöꞌi xa mi ꞌyo̱tho mi handwa ár tsꞌe̱di Jö. Nuya paꞌu̱ xa mi ꞌyo̱da ya jöꞌi gatho nöꞌö xki ꞌyo̱tꞌa ar Hesu. Nöꞌö bi ꞌñembabi yá ma̱xte: ");
INSERT INTO otqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—ꞌYo̱hu̱ xiñho nuna ma ga xiꞌahu̱, yo ma gi pumhnihu̱: Nöꞌö Togo ba e bi Njöꞌi, ma da nda̱twa yá ꞌye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ha nuyá ma̱xte himbi bödi tema ndi bo̱nga nöꞌö bi xipabi, ngetho himi nthe̱gi nda zo yá mfeniꞌu̱. Ne mi ntsu nda ꞌya̱mbabi tema ndi bo̱nga nöꞌö xki möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nepꞌu̱ nuyá ma̱xte bi ndu̱i bi ñöxhnatho nꞌa ngu nꞌa togo nda ntöte ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nunar Hesu mi pötwatho yá mfeniꞌu̱. Jange ba tsi nꞌar tsi bötsi, bi ꞌba̱ꞌma habu̱ mi ꞌbu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ne bi ꞌñembabiꞌu̱: —Nöꞌö togo po̱tka ma thuhu da japamasu nꞌar tsi bötsi ngunu̱, jakamasugi. Ne nöꞌö togo jakamasugi, japamasu nöꞌö togo ba pe̱nkagi. Ngetho nöꞌö togo hingar ñꞌetsꞌihu̱, go töte ri nsuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nepꞌu̱ ar Xuwa bi ꞌñembabi ar Hesu: —Ma tsi Utateꞌi, xta hanthe nꞌar ñꞌo̱ho̱ ju̱ñꞌa ár tsꞌe̱di ri thuhu, e̱nga ya tsꞌondöhi. Da höjwe ngetho hindi ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Yo gi hökwabihu̱, ngetho nöꞌö togo hingo ma ñꞌu̱nihu̱, fa̱xkagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Núꞌmu̱ mi ꞌba̱pꞌu̱tho nda zo̱ ar pa nda menga ar Hesu mhetsꞌi, nꞌa mbi ze̱ta ár mu̱i, bi gu̱ ar ꞌñu bi ma Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ne bi me̱hna ꞌra togo bi mꞌe̱tꞌo nda ma ha nꞌar hnini har ha̱i Nsamaria, nda hyoni habu̱ ndi zo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ha nuya mengunu̱ himbi ne bi umba nse̱ki, ngetho mi ꞌyo ar ꞌñu ndi ma Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nu mi bö njapꞌu̱ ar Hakobo ne ar Xuwa, yoho yá ma̱xte, bi ꞌñeñꞌu̱: —Ma tsi Hmuꞌihe, ha hingi ne ga a̱hu̱ da da̱ ar tsibi mhetsꞌi, da tsötꞌa nunar hnininu̱, ngu bi ꞌyo̱tꞌa ar Elia. ");
INSERT INTO otqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nu mi mönga njapꞌu̱ꞌu̱, ar Hesu bi ꞌba̱tꞌi bi kꞌötꞌi, ne bi zu̱i bi ꞌñembabi: —Nuꞌahu̱, hingi pöhu̱ tema mfeni gi pe̱ꞌsu̱ gi möñhu̱ njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nöꞌö Togo ba e bi Njöꞌi, hinxpa e da hñökwa yá te ya jöꞌi, ba e da po̱hyu̱. Ne bi thogi bi me̱wi yá ma̱xte manꞌar tꞌu̱lo hnini. ");
INSERT INTO otqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Núꞌmu̱ mi ꞌyo ar ꞌñu, nꞌar ñꞌo̱ho̱ bi ꞌñemba ar Hesu: —Ma tsi Hmuꞌi, ga te̱ñꞌaꞌi habu̱ gatho gi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ar Hesu bi dödi ne bi ꞌñembabi: —Nuya miñꞌo pe̱ꞌsa yá oki, ne nuya tsꞌintsꞌu̱ pe̱ꞌsa yá mꞌafi, ha Nöꞌö Togo ba e bi Njöꞌi hiñꞌotho habu̱ da me̱ ár ñö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nuꞌmú̱ ar Hesu bi ꞌñemba manꞌar ñꞌo̱ho̱: —Ba e gi te̱ngagi. Ha nöꞌö bi dödi ne bi ꞌñenö: —Ma tsi Hmuꞌi, di ne gi ꞌraka ar se̱ki mꞌe̱tꞌo ma ga a̱ ma dada, ne xka pengi ga te̱ñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Hye̱pꞌu̱ nuꞌu̱ xi du da ꞌya̱ nuꞌu̱ mahye̱gi xi duwi. Ne di mage ba mömba ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nepꞌu̱ manꞌar ñꞌo̱ho̱ bi ꞌñemba ar Hesu: —Ma tsi Hmuꞌi, nuga di ne ga te̱ñꞌaꞌi nꞌehe. Ho̱nse̱ ꞌraka ar se̱ki mꞌe̱tꞌo ma ga e ma mengu. ");
INSERT INTO otqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ha nunar Hesu bi ꞌñembabi: —Nuꞌmu̱ nꞌar wöhi he̱ka nꞌar the ne ñegi, nu ar the hinda ma njöntho. Njapꞌu̱tho nöꞌö togo da ñꞌe̱ntꞌi da de̱ngagi, ne da ñegi, hingar hoga ꞌbe̱go hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mi tho gathoyu̱, ar tsi Hmu bi hwahna ma hñunꞌa̱te ma ꞌre̱tꞌa ya ñꞌo̱ho̱ mi te̱ni. Bi me̱hni ꞌra ma yoho, nda mꞌe̱tꞌoꞌu̱ ha gatho ya hnini habu̱ mꞌe̱fa nda those̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne bi ꞌñembabiꞌu̱: —Majöni xa nze̱ye̱tho ar sofo, ha txꞌu̱tho ya ꞌbe̱go. Jange ꞌya̱fu̱ Jö togo ár me̱ti ar sofo, da me̱hna ya ꞌbe̱go da gu̱ꞌspa ár sofo. ");
INSERT INTO otqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Di möhu̱ ne zo̱tꞌa ri da̱hu̱, di pe̱ñꞌahu̱ ngu ya tsi de̱ti madeda ya miñꞌo. ");
INSERT INTO otqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yo te gi höxu̱ ar ntꞌu̱tbojö, yo ma gi hyoju̱ ri ꞌbe̱nihu̱, yo gi höxu̱ nꞌa mponi ri thizahu̱. Ne yo ma gi ꞌba̱hu̱ gi ze̱ngwahu̱ ya jöꞌi har ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nu xki ku̱thu̱ ha nꞌar ngu, gi ze̱ngwahu̱ njawa: Jö da hwëkꞌahu̱ nꞌar hogamꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ha nuꞌmu̱ ya mengunu̱ di ꞌbu̱ nꞌar hogamꞌu̱i, nuꞌmú̱ Jö da hwëkwabi ngu xka xifu̱. Ha nuꞌmu̱ hinꞌö, da mengtho da zu̱ꞌahu̱ ar hwëki. ");
INSERT INTO otqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nu habu̱ da tꞌaꞌahu̱ nse̱ki, ka gi kohu̱nu̱, ne gi tsihu̱ nöꞌö da tꞌaꞌahu̱. Ngetho nꞌar ꞌbe̱go di ꞌñepi da tꞌumbabi ár nthöhö. Ne ka gi ꞌbu̱thu̱nu̱, yo gi ꞌyo gi nehu̱ ya ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nuꞌmu̱ gi tso̱ñhu̱ ha nꞌar hnini ne da tꞌaꞌahu̱ ar se̱ki, tsihu̱ gatho nöꞌö te da ꞌbo̱sꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","O̱thehu̱ ya da̱thi nuꞌu̱ di ꞌbu̱hnu̱, ne xifu̱ nuya mengunu̱, ba epꞌu̱tho ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ha nuꞌmu̱ gi tso̱ñhu̱ ha nꞌar hnini ne hinda tꞌaꞌahu̱ ar se̱ki, ꞌba̱hu̱ habu̱ da ꞌyo̱ꞌahu̱ ya jöꞌi, ne gi ꞌñembabihu̱: ");
INSERT INTO otqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ma ga hwöthe ma wahe da hyo̱ ár ha̱i nuna hnininu̱ xi mꞌa̱tꞌi. Njapꞌu̱ gi pöhu̱ döta ri mfe̱ihu̱ ba epꞌu̱, ngetho hinga ñꞌemu̱ihu̱ nöꞌö xta xiꞌahe. Pöhu̱ xiñho, ba epꞌu̱tho ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Di xiꞌahu̱, nunar pa da nthöxmajöni, xa ma da me̱ꞌsa nꞌar mfe̱i nunar hniniꞌö, ma da döta ar hnini Sodoma nöꞌö bi hwata Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hwëkate nuꞌahu̱ gar menguhu̱ Korasi, ne nuꞌahu̱ gar me Betsaidahu̱. Ngetho nuꞌmu̱ ya me Tiro ne ya me Sidon xi hyanthmö nuya ntꞌudi xi tꞌo̱tꞌa ha ri ha̱ihu̱, nuꞌu̱ xi ꞌyo̱tꞌwahmö yá ntso̱ꞌmi. Ne xi hyehmö ya he dumu̱i, ne xi nkoxhmö ya ꞌbospi tsꞌoni. ");
INSERT INTO otqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ha nunar paꞌö xta thöspꞌahu̱ majöni, ma da döta ri mfe̱ihu̱ nöꞌö ma da hñönga ya me Tiro ne ya me Sidon. ");
INSERT INTO otqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ha nuꞌahu̱ gar menguhu̱ Nkapernaum, gi hu ri mu̱ihu̱ ma da nju̱xꞌahu̱ mañö mhetsꞌi. Hinꞌö. Ma da tꞌeꞌahu̱ har ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ne bi ꞌñembabi yá ma̱xte: —Nöꞌö togo da ꞌyo̱xa nöꞌö gi xifu̱, go o̱tkagi. Ne nöꞌö togo hinda ꞌyo̱xa nöꞌö gi xifu̱, hingi o̱tkagi. Ha nöꞌö togo hingi o̱tkagi, hingi o̱ta nöꞌö togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Núꞌmu̱ mba penga nuꞌu̱ hñunꞌa̱te ma ꞌre̱tꞌa ya mꞌe̱hni, xa mi johya bi zo̱ho̱, ne bi ꞌñemba ar Hesu: —Ma tsi Hmuꞌihe, nuya tsꞌondöhi himi tse̱ta ár tsꞌe̱di ri thuhu. Nöꞌö ndi ꞌbe̱fe, mi o̱tkagihe. ");
INSERT INTO otqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ha nu ar Hesu bi ꞌñembabiꞌu̱: —Hö. Nuga ndi handa ar tsꞌondöhi ba ta̱ mhetsꞌi ngu nꞌar hwe̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xta ꞌraꞌahu̱ ar tsꞌe̱di gi nethu̱ ya kꞌeñö ne ya penzu̱, ne gi töhu̱ gatho ár tsꞌe̱di ar tsꞌondöhi, ne nöꞌö hinte da za̱ te da jaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ha hintsꞌu̱ gi njohyahu̱ ngetho ya tsꞌondöhi o̱tꞌa nöꞌö gi xifu̱. Mꞌe̱tꞌo njohyahu̱ ngetho ri thuhuhu̱ xi ntꞌotꞌa mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nuꞌmú̱ ar Hesu xa bi njohya hár tsꞌe̱di ár Hñö Jö, ne bi ꞌñenö: —Ma tsi Dadaꞌi, go gar Hmu mhetsꞌi ne gatho har ximha̱i. Di nsundaꞌi ngetho xka utwabi ri ntꞌuti nuꞌu̱ ngu ya tsi bötsi hintsꞌu̱ te pödi, ne xka ꞌñökwa nuꞌu̱ ja yá mfödi ne ya nimfeni. Hö, ngetho njapꞌu̱ xka numañhoge, ma tsi Dadaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mi wadi bi mönga njapꞌu̱ ar Hesu, bi ꞌñemba nuꞌu̱ mi ꞌbu̱hnu̱: —Ma Dada xi ꞌye̱ntkꞌa gatho ha ma ꞌye̱. Hinto pötka ma mꞌu̱i, nuga ár Tꞌu̱gi Jö, ho̱nse̱ ma Dada. Ne hinto pötwa ár mꞌu̱i ma Dada, ho̱nse̱ ár Tꞌu̱gi ne nuꞌu̱ togo xta hwahni ga utwabi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne bi ñhanda habu̱ mi ꞌbu̱ yá ma̱xte, ne bi ꞌñembase̱ꞌu̱: —Njohyahu̱ ngetho xi tꞌaꞌahu̱ ar se̱ki gi hyanthu̱ nöꞌö gi hanthu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngetho nuga di xiꞌahu̱, nze̱ye̱ yá mꞌe̱hni Jö ne ya ndö mi ꞌbu̱ mamꞌe̱tꞌo, mi nehmö xi hyanda nöꞌö gi hanthu̱pya, ne himbi za̱ bi hyantꞌu̱. Ne mi nehmö xi ꞌyo̱ nöꞌö gi o̱hu̱pya, ne himbi za̱ bi ꞌyo̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nepꞌu̱ nꞌar bötꞌofo ma ba kꞌöꞌsa ar Hesu nda ꞌyo̱tꞌwa nꞌar ntꞌa̱ni, ne nda tsa̱ti ha nda dödi xiñho, ne bi ꞌñemba njawa: —Ma Utateꞌi, tema mahyoni ga pe̱fi ne ga pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Teme mönga ár tꞌofo ar Moise. Tema gi hetꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nu ar bötꞌofo bi dödi ne bi ꞌñenö: —Ar tꞌofo enö njawa: ꞌÑetꞌa ri mu̱i, ꞌye̱ntꞌa ri te ne ri tsꞌe̱di, ne hñuxa ri mfeni gi mö Jö ri Hmu, ne gi mö ri mijöꞌiwi ngu gi mhöse̱. ");
INSERT INTO otqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nepꞌu̱ ar Hesu bi ꞌñembabi: —Nuꞌmu̱ gi ꞌyo̱tꞌa ngu xka mö, da tsa̱ gi ꞌbu̱ nꞌar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ha nunar bötꞌofo himi ne to nda kꞌaꞌspa ár ntꞌa̱ni. Jange bi mengi bi ꞌya̱ni: —Togo ma mijöꞌiꞌbe ga mödi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Nꞌagi nꞌar ñꞌo̱ho̱ mi ne ar ꞌñu, xki ꞌñe Herusalen ndi ma har hnini Heriko. Bi da̱ka ꞌra ya da̱kate, ne bi mo̱kwabi yá dutu bi hñöꞌspa gatho nöꞌö te mi hö. Xa bi fe̱nza, ne bi tsꞌohnu̱ ꞌbu̱tho nda du. ");
INSERT INTO otqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mꞌe̱fa bi thopꞌu̱tho har ꞌñuꞌö nꞌar möjö, ne nu mi hyandi mi ꞌbe̱mpꞌu̱ har ꞌñu, bi ga̱xa hár ñöni, ne bi thogi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nepꞌu̱ bi thopꞌu̱tho nꞌar ma̱xte har nijö. Nunu̱ nꞌe, bi hyandatho ar ñꞌo̱ho̱ mi ꞌbe̱mpꞌu̱, ne bi ga̱xa hár ñöni ar ꞌñu, bi thogi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ha nꞌar me Nsamaria bi thopꞌu̱tho har ꞌñuꞌö. Ne mi zo̱nga getꞌu̱ habu̱ mi ꞌbe̱ñꞌö, mi hyandi, xa bi hwëki. ");
INSERT INTO otqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bi ma ba kꞌötsꞌi, ne bi goꞌspa ar nziki ha yá ntsꞌe̱ni, bi xiꞌspa ar ixkatꞌafi, ne bi dutꞌwabi. Mꞌe̱fa bi ꞌye̱ntsꞌa hár nꞌo̱ge, bi zixa ha nꞌar ngu tꞌungar hatsꞌi, ne ka bi sunu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ár hyaxꞌöpꞌu̱, nu mi ꞌba̱ ar ꞌñu nda ma, bi hñö ar bojö, ne bi gutꞌwabi yopa ar ꞌbe̱fi nöꞌö ar unga hatsꞌi. Ne bi ꞌñembabi: Di tsokꞌatsꞌu̱wa nunar ñꞌo̱ho̱nu̱ gi su, ne nuꞌmu̱ da kꞌatꞌa ar bojö, nu xka pengi ga jutꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nu mi wadi bi mönga njapꞌu̱ ar Hesu, bi ꞌya̱mba ar bötꞌofo, ne bi ꞌñembabi: —Nuya hñu ya ñꞌo̱ho̱yu̱, togo gi beni ger mijöꞌiwi ar ñꞌo̱ho̱ xki tha̱ki. ");
INSERT INTO otqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nu ar bötꞌofo bi dödi ne bi ꞌñenö: —Nöꞌö togo bi me̱ꞌspa ar nhwëki. Ne ar Hesu bi ꞌñembabi: —Hö. Di ma ba japꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ar Hesu bi mengi bi ne ar ꞌñu, ne bi zo̱nga ha nꞌar hnini. Ka mi ꞌbu̱hnu̱ nꞌar ꞌbe̱hñö már thuhu ar Marta, togo bi umba ar se̱ki hár ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mi ꞌñe nꞌár juhwe̱ már thuhu ar Maria, gehnu̱ bi hñu hár wa ar Hesu mi o̱xa nöꞌö mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ha nu ar Marta xa mi nxintꞌi mi o̱tꞌa ar ꞌbe̱fi har ngu. Nꞌa mbi watꞌatho habu̱ mi ꞌbu̱ ar Hesu, ne bi ꞌñembabi: —Ma tsi Hmuꞌi, ha hingi handi numa juhwe̱ tsogagi gatho ar ꞌbe̱fi. Xipabi da e da ma̱xkagi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nunar Hesu bi ꞌñembabi: —Marta, tsi Marta, xa gi xo̱ni, ne xa gi tu ri mu̱i, ngetho nze̱ye̱ ar ꞌbe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ho̱nse̱ nꞌar ꞌbe̱fi mahyoni gi ꞌyo̱tꞌe, ngu nunar hoga ꞌbe̱fi xi hwahna ar Maria. Hinjoꞌo togo da hñökwabi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bi zo̱ta nꞌar pa ar Hesu mi a̱pabi Jö ár Dada, ne nu mi waꞌö, nꞌár ma̱xte bi ꞌñembabi: —Ma tsi Hmuꞌi, di ne gi utkagihe hanja ga a̱fe Jö, ngu ar Xuwa mi utwabi yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nu ar Hesu bi ꞌñembabiꞌu̱: —Núꞌmu̱ xki ꞌya̱fu̱ Jö, gi ꞌñeñhu̱ njawa: Ma tsi Dadaꞌihe gi ꞌbu̱ mhetsꞌi, dár nsunda ri thuhu. Dá ekwa ri tsꞌu̱tꞌwi, ne da tꞌo̱tꞌaꞌiwa har ximha̱i ngu bi tꞌo̱tꞌaꞌipꞌu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ꞌRakagihe te ga tsihepya. ");
INSERT INTO otqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ne pumgagihe ma tsꞌokihe, ngetho nuje nꞌehe di pumfe togo xi tsꞌokagihe. Ne yo gi he̱je da döje ar tsꞌa̱ti, ñöngagihe hinga o̱the nöꞌö xi ntsꞌotho. ");
INSERT INTO otqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne ar Hesu bi ꞌñemba yá ma̱xte nꞌehe: —Ma ga möñhu̱, nꞌar jöꞌi ntsixkwi manꞌa nꞌanguthowi. Ne ngu made nxui ma da kꞌönga hár ngu, ne da ꞌñembabi: Xta ehe gi ꞌyo̱tka ar möte gi hmika hñu ya thuhme. ");
INSERT INTO otqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ngetho ka di zo̱ manꞌar ñꞌo̱ho̱ di ntsixꞌbe nꞌehe, xpa e yapꞌu̱, ha hiñꞌotho te ga umbi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ne nöꞌö da dödi mbo hár ngu, ne da ꞌñenö: Hindi ne gi kꞌöskagipya. Xta kotꞌa ma goxthi, ne di hwixa ma bötsi. Jange hinda tsa̱ ga nangi ga ꞌraꞌa nöꞌö teme gi a̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ha nuga di xiꞌahu̱, hinda nangi da umbabi nöꞌö te a̱di mödi ár mpöhwi. Da nangi da umba gatho nöꞌö kꞌatꞌi, njapꞌu̱ da hye̱gi da ꞌya̱pa ár tꞌöhö. ");
INSERT INTO otqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jange di xiꞌahu̱, ꞌya̱hu̱ ne da tꞌaꞌahu̱. Hyoñhu̱, ne gi tiñhu̱. Mathu̱, ne da nsokꞌahu̱ ar goxthi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngetho nöꞌö togo da ꞌya̱di, da tꞌumbabi. Nöꞌö togo da hyoni, da dini. Ne nöꞌö togo da mafi, da nsokwabi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Núꞌahu̱ gar dadahu̱, nuꞌmu̱ ri bötsihu̱ da ꞌya̱ꞌahu̱ nꞌar thuhme, hage gi umfu̱ nꞌar do. Xiꞌmu̱ da ꞌya̱ꞌahu̱ nꞌar hwö, hage gi umfu̱ nꞌar kꞌeñö. ");
INSERT INTO otqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Xiꞌmu̱ da ꞌya̱ꞌahu̱ nꞌar tꞌaxi, hage gi umfu̱ nꞌar penzu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nuꞌmu̱ gar tsꞌoktehu̱, ne gi pöhu̱ gi umfu̱ nöꞌö xiñho ri bötsihu̱, hanguhmö ar Dada mhetsꞌi xa da umbabi ár Hñö Jö gatho nuꞌu̱ togo da ꞌya̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nꞌar pa ar Hesu bi ꞌye̱mba nꞌar tsꞌondöhi nꞌar ñꞌo̱ho̱ xki japi nda ngone. Nu mi bo̱nga ar tsꞌondöhi, ar gone bi za̱ bi ñö. Ha nuya jöꞌi bi hyandi, xa bi ꞌyo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ha ꞌra mi eñꞌu̱: —Nunar ñꞌo̱ho̱nu̱ e̱nga ya tsꞌondöhi, hömpa ár tsꞌe̱di ar Belsebu ár ndö ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Maꞌra ho̱ntꞌa mi ne nda hya̱thmö, mi a̱pabi nꞌar ntꞌudi ndi ꞌñe mañö mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ar Hesu mi pötho tema mi beñꞌu̱, jange bi ꞌñembabiꞌu̱: —Nuꞌmu̱ nꞌar hnini da ñhege ne da ntunse̱, ma da jöꞌsase̱ꞌu̱ gatho nöꞌö xi ꞌyo̱tꞌe. Ha nuꞌmu̱ nꞌar ngu da ntunse̱ nuya mengu, da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Njapꞌu̱tho nꞌehe, nuꞌmu̱ ar tsꞌondöhi da ntunkwi yá mitsꞌondöhiwi, hanja da me̱ꞌsa ár tsꞌe̱diꞌö. Nuga di xiꞌahu̱ njapꞌu̱, ngetho gi eñhu̱ di e̱nga ya tsꞌondöhi di hömpa ár tsꞌe̱di ar Belsebu ár ndö ya tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ha nuꞌmu̱ njapꞌu̱ ngu gi möñhu̱, xi nuya ri mꞌe̱hnihu̱ ꞌmu̱, togo ár tsꞌe̱di hömpabi da ꞌye̱nga ya tsꞌondöhi. Go da hñumpꞌa ri hmihu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ha nuꞌmu̱ di e̱nga ya tsꞌondöhi di hömpa ár tsꞌe̱di Jö, pöhu̱ ꞌmu̱, ár tsꞌu̱tꞌwi Jö xi zo̱kwapya habu̱ gi ꞌbu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nuꞌmu̱ nꞌar ñꞌo̱ho̱ jár tsꞌe̱di ne the̱ ya bo̱jö tsa̱ da su ár ngu, ꞌbe̱ꞌsa xiñho gatho yá ñho ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ha nuꞌmu̱ da zo̱ manꞌa di töte ár tsꞌe̱di, ne da döhö, da hñömba yá bo̱jö the̱ nda su ár ngu. Da hñöꞌspabi nöꞌö mi pe̱tsꞌi, ne da hyemba yá ñꞌohu̱ gatho nöꞌö te janu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nöꞌö togo hindi ñꞌoꞌbe, u̱tsagi. Ne nöꞌö togo hindi musꞌbe mahye̱gi, go fontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nuꞌmu̱ nꞌar tsꞌondöhi da bo̱nga ha nꞌar jöꞌi, da ñꞌo ha ya otꞌa ha̱i, di honga habu̱ da ntsa̱ya̱, ne hinte tini. Nuꞌmú̱ da bense̱ ne da ꞌñenö: Xiꞌmu̱ ga penga ha ma ngu da po̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ha nu xta pengi da dinga nöꞌö ár ꞌbe̱tꞌo ngu habu̱ mi ꞌbu̱i, xi njoki, ne xi thoki xiñho. ");
INSERT INTO otqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nuꞌmú̱ nunar tsꞌondöhiꞌö, dama da hyonga ma yoto yá mitsꞌondöhiwi di töpa ár ntsꞌo, ne da ku̱tꞌi da mꞌu̱hwi. Ne nunár ꞌbe̱famꞌu̱i nunar jöꞌi xki hye̱hmö ar tsꞌondöhi, di töta ár ntsꞌo, hinge ngu ꞌbe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Núꞌmu̱ mi mönga njapꞌu̱ ar Hesu, nꞌar ꞌbe̱hñö mi ꞌbu̱hnu̱ har mhuntsꞌi bi ñö ntsꞌe̱di, ne bi ꞌñenö: —Xa xi jöpa Jö nöꞌö ar ꞌbe̱hñö xi ꞌyo̱ñꞌaꞌi, ne xi tedeꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñenö: —Töta ar njöpi xi hñönga nuꞌu̱ togo o̱twabi nöꞌö mönga Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mi ꞌyo mi mhuntsꞌa ya jöꞌi hár nthetꞌi ar Hesu, ne nöꞌö bi ꞌñembabiꞌu̱: —Nuya jöꞌi ꞌbu̱ nuya payu̱ thota yá ntsꞌo, a̱di da hyanda nꞌar ntꞌudi, ha hinda ma da tꞌumbabi. Ho̱nse̱ da tꞌumba ár ntꞌudi ar mꞌe̱hni Honas. ");
INSERT INTO otqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngetho njangu ar Honas bi ꞌbe̱hni ngu ar ntꞌudi da hyanda ya me Ninibe, njapꞌu̱tho Nöꞌö Togo ba e bi Njöꞌi, gehnu̱ nꞌar ntꞌudi da hyanda ya jöꞌi ꞌbu̱ nuya payu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nunar ꞌbe̱hñö mar ndö ndi ꞌñe makꞌangi, ma da nanga har thöxamajöni, ne ma da hñuꞌmba yá hmi nuya jöꞌi ꞌbu̱ nuya payu̱. Ngetho nuna ba e har yapꞌu̱ ha̱i nda ꞌyo̱ꞌspa ár mfödi ar Salomon. Ne gi ꞌbu̱hwihu̱wa nꞌa xa töpa ár nsu ar Salomon. ");
INSERT INTO otqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nuya me Ninibe ma da nanga har thöxamajöni, ne ma da hñuꞌmba yá hmi nuya jöꞌi ꞌbu̱ nuya payu̱. Ngetho nuꞌu̱ bi ꞌyo̱tꞌwa ár ntso̱ꞌmi nu mi zo ar Honas. Ne gi ꞌbu̱hwihu̱wa nꞌa xa töpa ár nsu ar Honas. ");
INSERT INTO otqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hinjoꞌo nꞌar jöꞌi togo da tso̱ nꞌar ñotꞌi ne da ꞌñögi, wa da goꞌma ha nꞌar tsꞌo̱i. Nöꞌö da ꞌyo̱tꞌe, da ꞌñexa habu̱ da tsa̱ da yotꞌa gatho mbo har ngu, ne da hyanda nuꞌu̱ togo da yu̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nuya ri da̱hu̱ ngu ꞌra yá ñotꞌi ri ndoꞌyohu̱. Nuꞌmu̱ ri da̱hu̱ xiñho, xo̱ge ri ndoꞌyohu̱ ꞌbu̱ har hyatsꞌi. Ha nuꞌmu̱ ri da̱hu̱ hingi ho, xo̱ge ri ndoꞌyohu̱ ꞌbu̱ har ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jange jamasuhu̱ nöꞌö ar ñotꞌi gi pe̱ꞌsu̱, da yotꞌa xiñho ri mfenihu̱, ne hingi ꞌbu̱hu̱ har ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nuꞌmu̱ gatho ri ndoꞌyohu̱ ꞌbu̱ har hyatsꞌi, ne hinte tsꞌompꞌa ri mfenihu̱, xa di kopꞌathohu̱ ar hyatsꞌi, ngu nꞌar ñotꞌi e̱sꞌahu̱ ár hyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nu mi wadi bi mönga njapꞌu̱ ar Hesu, nꞌar de̱ngaꞌbe̱pate bi ꞌya̱par möte nda me̱wi nda ñungwi hár ngu. Bi yu̱tꞌa ar Hesu, ne bi hñu har mexa. ");
INSERT INTO otqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ha nu ar de̱ngaꞌbe̱pate xa bi ꞌyo̱tho mi hyanda ar Hesu himbi nxu̱ꞌye̱ mꞌe̱tꞌo ne nda ñuni ngu yá ntꞌumbiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌö: —Nuꞌahu̱ gar de̱ngaꞌbe̱patehu̱, gi njanguhu̱ nꞌar xu̱tꞌbada ne ar xu̱tmohi, ho̱nse̱ xu̱tꞌa nthi, ha nu mbo xi ntsꞌotho. Nuꞌahu̱ gi ne gi po̱nga ri hmihu̱ ha yá nthandi ya jöꞌi, mödi gi pe̱ꞌsu̱ ha ri mfenihu̱ ar mfë ne ar tsꞌomꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xa xka ꞌbe̱ ri mfenihu̱. Ha hingi pöhu̱, Jö geꞌö bi hyoka xo̱ge ár ꞌba̱i ar jöꞌi, nthi ár ndoꞌyo ne mbo ár mfeni nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Fa̱xu̱ ya hyoya hyemfu̱ nöꞌö gi pe̱ꞌsu̱, ne njapꞌu̱ hö, da ntꞌaxkꞌaꞌihu̱ xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hwëkate nuꞌahu̱ gar de̱ngaꞌbe̱patehu̱. Ngetho gi ꞌwekwabihu̱ Jö nꞌa ꞌre̱tꞌa xe̱ni ar xökꞌni, ar ruda ne gatho nu maꞌra ya do̱ni. Ha hinto gi o̱tꞌwabihu̱ ar ñho, ne hingi möhu̱ Jö. Xiñho gi ꞌwejwu̱ ár me̱ti Jö, ne hingi hye̱hu̱ gi ꞌyo̱tꞌwabihu̱ ar ñho maꞌra, ne gi möhu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hwëkate nuꞌahu̱ gar de̱ngaꞌbe̱patehu̱. Ngetho gi ne gi hñuhu̱ ha ya nthudi nsu ha ya nijö, ne gi nehu̱ da nze̱ngwaꞌihu̱ xa di ꞌbe̱nga ntꞌekꞌei ha ya ta̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Hwëkate nuꞌahu̱ gar bötꞌofohu̱, ne gar de̱ngaꞌbe̱patehu̱, xa gar katehu̱. Gi ñhe̱hwihu̱ ya ntꞌa̱gi hingi nheki, thotya jöꞌi mañö, ne hingi pöꞌu̱ tengu ar ntsꞌotho mbo. ");
INSERT INTO otqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nepꞌu̱ bi dö nꞌar bötꞌofo, ne bi ꞌñembabi ar Hesu: —Ma Utateꞌihe, núꞌmu̱ gi mönga njapꞌu̱, gi e̱mgagihe dar bötꞌofohe nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ha nunar Hesu bi ꞌñenö: —Hwëkate nuꞌahu̱ gar bötꞌofohu̱ nꞌehe. Ngetho gi jafu̱ ya jöꞌi da muxa ya ꞌbe̱ni nuꞌu̱ hingi tsa̱ da mutsꞌi, ha nuꞌahu̱ hingi ne gi tha̱ñhu̱tsꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hwëkateꞌihu̱. Ngetho gi pengi gi hokwabihu̱ yá ntꞌa̱gi yá mꞌe̱hni Jö mi ꞌbu̱ mamꞌe̱tꞌo, nuꞌu̱ bi hyose̱ ri palehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Njapꞌu̱ nheki gi etꞌathohu̱ ri xu̱thahu̱ nöꞌö bi ꞌyo̱tꞌa ri palehu̱. Ngetho nuꞌu̱ bi hyo ya mꞌe̱hni, ha nuꞌahu̱ go gi pengi gi hokwabihu̱ yá ntꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jange Jö xki ꞌñense̱ hár döta mfödi: Ma ga pe̱mpabiꞌu̱ ma mꞌe̱hni ne ma mpo̱te. ꞌRa ma da tho, ne maꞌra xa ma da ntꞌu̱tsa. ");
INSERT INTO otqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jange nuya jöꞌi ꞌbu̱pya, Jö go ma da gotꞌwabi gatho ár ji yá mꞌe̱hni xi nhöꞌmba di ndu̱i núꞌmu̱ mi thoka ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Da ndu̱ꞌma núꞌmu̱ mi nhöꞌmba ár ji ar Abel, di göxa ár ji ar Sakaria nöꞌö bi tho madedar mꞌo̱xmꞌo̱ñho̱ ne ar nijö. Jange di xiꞌahu̱, Jö gatho ma da gotꞌwa nuya jöꞌi ꞌbu̱ nuya payu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hwëkate nuꞌahu̱ gar bötꞌofohu̱. Ngetho hingi he̱hu̱ da bötwa ár mhö Jö nuꞌu̱ togo ne da bödi. Himbi zo ri mfenihu̱, ne hingi he̱hu̱ maꞌra nda zo yá mfeni. ");
INSERT INTO otqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nu mi wadi bi mönga njapꞌu̱ ar Hesu, nuya bötꞌofo ne nuya de̱ngaꞌbe̱pate, xa bi fa̱tsꞌi mi o̱tꞌwa nze̱ ya ntꞌa̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ngetho xa mi ne nda ꞌyo̱ꞌu̱ nda mönga nöꞌö himi ho, ne njapꞌu̱ nda dinga te nda hyo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nepꞌu̱ xa mi thota ár nze̱ye̱ ya jöꞌi bi mhuntsꞌi, ne mi ñꞌentꞌa nꞌa ngu nꞌa. Nuꞌmú̱ ar Hesu bi ndu̱i bi ñö, ne mꞌe̱tꞌo bi ꞌñemba yá ma̱xte: —Jamasuhu̱, yo ma gi te̱mbabihu̱ yá tsꞌomꞌu̱i ya de̱ngaꞌbe̱pate, ngetho nuꞌu̱ xa o̱tꞌa ñhogajöꞌi ne ya nemhñö, ne ꞌramtxꞌu̱ tsꞌomba yá mfeni ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hiñꞌotho teme xi tꞌögi ne hinda thini, wa teme xi tꞌo̱tꞌa ñꞌöntho ne hinda födi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jange nuga di xiꞌahu̱, gatho nöꞌö gi möñhu̱ ñꞌöntho, mꞌe̱fa ma da födi. Ne gatho nöꞌö gi njontꞌanehu̱, ma da mhönga ntsꞌe̱di gatho da ꞌyo̱de. ");
INSERT INTO otqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ha nuga di eñꞌahu̱, ma tsi ñꞌowiꞌihu̱, yo gi tsuhu̱ togo ne da hñökꞌahu̱ ri tehu̱, ne mꞌe̱fa hinda tsa̱ te manꞌa da jaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma ga xiꞌahu̱ togo mahyoni gi tsuhu̱. Tsuhu̱ nöꞌö tsa̱ da hñökꞌa ri tehu̱, ne pe̱ꞌsa ar tsꞌe̱di da me̱ñꞌahu̱ har tsibi nꞌehe. Hö, go gi tsuhu̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nuya tsi tsꞌintsꞌu̱ hingi hmödi, tꞌunga ku̱tꞌa ha nꞌar tsi ngu̱dmi. Ha Jö hinxi pumhni nꞌayu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xiꞌahu̱hmö. Gatho ri xtöhu̱ Jö pödi hanguꞌu̱. Jange yo gi ntsuhu̱, ngetho gi töfu̱ ár nsu pe̱ꞌsa nꞌa mutꞌi ya tsꞌintsꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Di xiꞌahu̱, gatho nuꞌu̱ togo da da̱majöni ha yá nthandi ya jöꞌi xi bökagi, Nuga xta e ga Njöꞌi, ma ga da̱majöni ha yá nthandi yá e̱nxe̱ Jö xta mpöꞌbeꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ha nuꞌu̱ togo da ko̱ngagi ha yá nthandi ya jöꞌi, nuga nꞌe, ma ga ko̱nga ha yá nthandi yá e̱nxe̱ Jö, ga enö hiñhamꞌu̱ xta mpöꞌbeꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nuꞌmu̱ nꞌa da ñömañꞌu̱bi Nöꞌö Togo ba e bi Njöꞌi, da mpumbabi. Ha nöꞌö togo da zanga ár Hñö Jö, hinda ma da mpumbabi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nu xta tsꞌixꞌahu̱ ha yá nijö ya xodyo, wa ha yá nthandi ya nza̱ya̱, wa maꞌra yá ndö ya hnini, yo gi tu ri mu̱ihu̱ tema gi thöhu̱, yo gi beñhu̱ mꞌe̱tꞌo tema gi möñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ngetho nu xki ñöhu̱, ár Hñö Jö ma da utꞌahu̱ teme mahyoni gi möñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nepꞌu̱ nꞌar ñꞌo̱ho̱ mi ꞌyo har mhuntsjöꞌi, bi ꞌñemba ar Hesu: —Ma Utateꞌi, xipatsꞌu̱ ma jödö ga ñheꞌbe nöꞌö bi zogagihe ndu ma dadahe. ");
INSERT INTO otqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nunar Hesu bi ꞌñembabiꞌö: —Xiꞌge Ndada, togo xi hñuxkaga ngu ar nza̱ya̱ ga hekꞌahu̱ ar ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne bi ꞌñenö nꞌe: —Jamasuhu̱ hinge xa gi hyomfu̱ yá ñho ar ximha̱i, ngetho ha ya ñho, hinge ja bi ehnu̱ ar hogamꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ne bi xipa nꞌar ꞌbede nuꞌu̱ ya jöꞌi xki mhuntsꞌi, ne bi ꞌñembabi: —Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ xa mi pe̱ꞌsa nze̱ye̱ ya ñho, ne nuyá ha̱i xa bi unga nꞌar hoga sofo. ");
INSERT INTO otqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nuꞌmú̱ nöꞌö ar ñꞌo̱ho̱ꞌö bi bense̱, ne bi ꞌñenö: Te ga pe̱pya. Hiñꞌotho habu̱ ga kwata gatho ma sofo. ");
INSERT INTO otqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nꞌa mbi ꞌñense̱ hár mfeni: Da beni tema ga pe̱fi. Ma ga yo̱tꞌa nuyu̱ ma tꞌu, ne ma ga hoka maꞌra di töte ár döta. Ne ka ga u̱tnu̱ gatho ma sofo ne gatho nöꞌö te di pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nepꞌu̱ ka jwadi ga kwata gatho ma sofo, ma ga embase̱ ma te: Nupya hö, janu̱ gatho nöꞌö te di honi ga tsi nze̱ye̱ ya je̱ye̱ da ꞌñepꞌu̱. Nupya da tsa̱ ga tsa̱ya̱, ga ñuni, ga ntsithe, ne xa ga njohya. ");
INSERT INTO otqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ha Jö bi ꞌñembabi nöꞌö ar ñꞌo̱ho̱ꞌö: Xa xka ꞌbe̱ ri mfeni, ngetho ar nxuinu̱, ma gi tu, ne gatho nöꞌö gi pe̱tsꞌi, hingi pödi togo ma da gohwi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Njapꞌu̱tho nꞌehe, nöꞌö togo xi muntsꞌa nze̱ye̱ ya ñho ár me̱tise̱, nu xta du, ma da ñhoya hár nthandi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nepꞌu̱ ar Hesu bi ꞌñemba yá ma̱xte: —Nupya di xiꞌahu̱, yo gi tu ri mu̱ihu̱ tema gi tsihu̱, wa tema gi hyehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngetho ri tehu̱ töpa ár nsu ar ñhuni, ne ri ndoꞌyohu̱ töpa ár nsu ar he. ");
INSERT INTO otqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hyanthu̱ ya ka. Nuꞌu̱ hingi potꞌi, hingi xofo, ne hiñꞌotho yá tꞌu. Jö go ꞌwiñꞌu̱. Ne nuꞌahu̱ gi töfu̱ ár nsu gatho ya zuꞌwe nsa̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Togo da hñuꞌsa ár ñhetsꞌi xa di tu ár mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nuꞌmu̱ hingi tsa̱ gi ꞌyo̱thu̱ nöꞌö hingi hembi, yoꞌö tupꞌa ri mu̱ihu̱ gatho nu maꞌra ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Hyanthu̱ hanja te ya do̱ni. Hingi hetꞌi, hingi pe̱ manꞌar ꞌbe̱fi. Ha di xiꞌahu̱, nunar ndö Salomon, mödi xa mi pe̱ꞌsa ár nsu, himbi za̱ bi ñhe ngu ár nza̱thoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nuꞌmu̱ Jö heta ya do̱ni da ndo̱mpya har ꞌbatha, ne xudi da nkꞌu̱tsꞌi da tꞌu̱ꞌsa har tsibi, xiꞌahu̱, tengu da thetꞌahu̱ ꞌmu̱. Yoꞌö xa hinte gi pe̱ꞌsu̱ ri jamfihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jange yo gi tu ri mu̱ihu̱ tema gi tsihu̱ ne tema gi hyehu̱, ne hindi oda ri mfenihu̱ tema gi kꞌathu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ngetho gatho nuꞌu̱ ya jöꞌi hinxi ñꞌemu̱i, hyaxꞌmu̱ oda yá mfeni nöꞌö te da zi ne te da hye. Ha nuꞌahu̱, ri Dadahu̱ bi ꞌbu̱ mhetsꞌi, pöꞌö teme gi kꞌathu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jange hyoñhu̱ mꞌe̱tꞌo hanja gi ꞌbu̱hu̱ xiñho hár tsꞌu̱tꞌwi Jö, ne njapꞌu̱ hö, hinda kꞌatꞌahu̱ gatho nöꞌö gi hoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma tsi tꞌu̱lo mhuntsꞌiꞌihu̱, yo gi ntsuhu̱, ngetho Jö ri Dadahu̱ xi hwëkꞌahu̱ gi ꞌbu̱hu̱ hár tsꞌu̱tꞌwiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jange pa̱hu̱ ri mꞌe̱tsꞌihu̱, ne hyembabihu̱ ya hyoya. ꞌYo̱thu̱ ri ꞌbe̱nihu̱ hingi thege, ne ri mꞌe̱tsꞌihu̱nu̱ mhetsꞌi hinda götsꞌi, habu̱ hinda yu̱tꞌa ya bë da bëpꞌahu̱, ne hinda de ar zuꞌwe. ");
INSERT INTO otqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ngetho habu̱ ꞌbu̱ ri mꞌe̱tsꞌihu̱, ka ꞌbu̱hnu̱ ri mfenihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ñhoju̱ ne ndo̱ꞌmhu̱, ngu ꞌra ya hoga ꞌbe̱go di zo̱ yá ñotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jahu̱ ngu ꞌra ya ꞌbe̱go to̱ꞌma yá hmu xta menga nꞌar ngo nthöti, ne nu xta ga̱ntꞌa ar goxthi, nuꞌu̱ ngutꞌa da xokwabi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Xa ma da njohya nuꞌu̱ ya ꞌbe̱go di nuhu núꞌmu̱ xta zo̱ ár hmu. Nuga di xiꞌahu̱, nunar hmuꞌö da mo̱ ar mexa, ne da ꞌñei da ꞌwini. ");
INSERT INTO otqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mödi da zo̱ made ar xui, wa núꞌmu̱ ꞌbu̱tho da hatsꞌi, xa ma da njohya nuꞌu̱ ya ꞌbe̱go da tsꞌu̱di nuhu. ");
INSERT INTO otqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ne di xiꞌahu̱, nuꞌmu̱ nꞌar jöꞌi di pöhmö hamꞌu̱ da zo̱ ar bë, nu ar jöꞌiꞌö hinda ñꞌöhö, da su ár ngu, hinda hye̱ ar bë da yu̱tꞌi da bëpabi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jange nuꞌahu̱ ndo̱ꞌmhu̱, ngetho nöꞌö ar pa hingi beñhu̱, nꞌa ngi tha̱ñhu̱tho, ma da mengi da ehe Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nepꞌu̱ ar Pedro bi ꞌya̱mbar Hesu, ne bi ꞌñembi: —Ma tsi Hmuꞌi, xi nunar ꞌbede ga jwadi ga mö, hage ho̱nse̱ ga xije, wa ga xipa gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ne ar tsi Hmu bi dödi: —Xiꞌmu̱ nꞌar hmu da bo̱nga ár ngu da ma, togo da zokwa ár ꞌbe̱fi da su ne da ꞌwimbabi gatho yá ꞌbe̱go. Hage hinda zokwabi nꞌar hoga ꞌbe̱go di pödi te gatho mahyoni da me̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xa da njohya nöꞌö ar ꞌbe̱go nu xta zo̱ ár hmu, ne da dini di o̱tꞌa gatho ngu nöꞌö xki zokwabi nda me̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Xa majöni di xiꞌahu̱, nu ar hmuꞌö ma da ꞌñexa ar hoga ꞌbe̱goꞌö, da supa gatho nöꞌö te pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ha nuꞌmu̱ nöꞌö ar ꞌbe̱go togo bi tsꞌogi nda supa ár ꞌbe̱fi ár hmu, da benga hár mfeni, nunár hmu hinda nxo̱ni da pengi. Ne da ndu̱i da me̱ ya ñꞌo̱ho̱ ne ya ꞌbe̱hñö nuꞌu̱ yá miꞌbe̱gowi, ne xa di ñuntho, ne di tsithetho, ne xa di ntitho. ");
INSERT INTO otqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ha nuꞌmu̱ ár hmu da zo̱ho̱ nöꞌö ar paꞌö hindi to̱ꞌma nor ꞌbe̱goꞌö, xa ma da tꞌumba nꞌar döta mfe̱i, ne da ꞌñetꞌa habu̱ bi ku̱ nuꞌu̱ hingi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nöꞌö ar ꞌbe̱go pödi xiñho tema xi ꞌbe̱pa ár hmu, ne hinda ꞌyo̱tꞌe, töte ár mfe̱i ma da tꞌumbabiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ha nöꞌö ar ꞌbe̱go hindi pödi xiñho teme xi ꞌbe̱pa ár hmu ne hinda me̱fi xiñho, da tꞌumba ar mfe̱i, mödi hingar nze̱ye̱ ngu nöꞌö manꞌa. Ngetho nöꞌö togo da tꞌe̱ntꞌwa nze̱ye̱ ar ꞌbe̱fi hár ꞌye̱, njapꞌu̱tho ma da thöꞌspa majöni nꞌehe. Ne nöꞌö togo da tꞌumbabi nze̱ye̱ da su, njapꞌu̱tho ma da thöꞌspa majöni. ");
INSERT INTO otqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nuga xta ekwa har ximha̱i ga u ar tsibi, ne xa di nehmö da ndu̱i da nzo̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mahyoni ga tho nze̱ye̱ ya u̱gi ne ya dumu̱i, ne xa di nehmö da ndu̱i ga thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ha gi beñhu̱ xta ekwa ga jöꞌsa ya tuhni har ximha̱i. Hinꞌö, xta e ga exa ya jöꞌi da ntuhni. ");
INSERT INTO otqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Da ndu̱ ar pania di mapꞌu̱, nuꞌmu̱ ha nꞌar ngu di ꞌbu̱ ku̱tꞌa, ma da ñhehyu̱, hñu da u̱tsa nu yoho, ne yoho da u̱tsa nu hñu. ");
INSERT INTO otqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ya dada da u̱tsa yá tꞌu̱, ha nuya tꞌu̱ da do̱xa yá dada. Ya nönö da u̱tsa yá tꞌinxu, ha nuya tꞌinxu da do̱xa yá nönö. Nuya ka̱ da u̱tsa yá tsꞌihwe̱, ha nuya tsꞌihwe̱ da u̱tsa yá ka̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ar Hesu bi ꞌñembabi ya jöꞌi nꞌehe: —Núꞌmu̱ gi hanthu̱ da nju̱xa ya gui núnu̱ mampuni, gi eñhu̱ ma da ꞌwöi, ne majöni da njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nuꞌmu̱ da ndu̱i da ñꞌo ar ndöhi, gi eñhu̱ ma da zo̱ ar pahyadi, ne majöni da njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nemhñöhu̱. Gi pöhu̱ gi hyanthu̱ hamꞌu̱ mponga mhetsꞌi ne ar ximha̱i, hanja hingi pöhu̱ mponga nuya payu̱ gi ꞌbu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hanja hingi bense̱hu̱ ndanaꞌö xiñho gi ꞌyo̱thu̱, ne ndanaꞌö hingi ho. ");
INSERT INTO otqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nuꞌmu̱ nꞌa da zixꞌahu̱ har tsꞌu̱tꞌwi, nu xki ꞌyohu̱ har ꞌñu, dama gi nkohwihu̱ núꞌmu̱ gi ꞌyose̱hu̱, njapꞌu̱ hinda zixꞌahu̱ har nza̱ya̱. Ngetho núꞌmu̱ xki tso̱ñhu̱ har nza̱ya̱, nöꞌö da da̱tꞌahu̱ ár mfa̱tsꞌi, ne nöꞌö ár mfa̱tsꞌi da zixꞌahu̱, ma da goꞌahu̱ har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Di xiꞌahu̱ hinda za̱ gi po̱ñhu̱, ma gi ꞌbu̱hu̱nu̱ gi kꞌothu̱ gatho nöꞌö gi tuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Núꞌmu̱ mi ꞌbu̱hnu̱ ꞌra ya jöꞌi bi metwabi ar Hesu hanja ar Pilato bi me̱hna togo nda hyo ꞌra ya me Ngalilea. Ne bi nthöspabi ár jise̱ꞌu̱ ár ji ya me̱ti mꞌo̱ñho̱ mi uñꞌu̱ har dönganijö Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ne ar Hesu bi ꞌñembabiꞌu̱: —Ha gi beñhu̱ nuya ñꞌo̱ho̱yu̱ bi tꞌo̱tꞌwa njapꞌu̱ ngetho mi töpa yá tsꞌoki gatho nu maꞌra ya me Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Di xiꞌahu̱ hinꞌö. Ha nuꞌmu̱ hingi ꞌyo̱tꞌwabihu̱ ár ntso̱ꞌmi, ma gi mꞌe̱hu̱ ngu bi mꞌe̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Xi nuꞌu̱ ꞌre̱tꞌamahñöto ya jöꞌi bi ze̱ꞌma ar heꞌsjödo Siloe núꞌmu̱ mi yo̱tꞌe, ha gi hu ri mu̱ihu̱ mi töpa yá tsꞌoki gatho nu maꞌra ya me Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Di xiꞌahu̱ hinꞌö. Ha nuꞌmu̱ hingi ꞌyo̱tꞌwabihu̱ ár ntso̱ꞌmi, ma gi mꞌe̱hu̱ ngu bi mꞌe̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne ar Hesu bi xipa nꞌar ꞌbede ya jöꞌi, ne bi ꞌñembabi: —Nꞌar ñꞌo̱ho̱ mi pe̱ꞌsa nꞌar ꞌba̱iꞌiuxi mi ꞌba̱ hár hwöhi. Ne nꞌar pa bi ma ba kꞌötsꞌi nda nu ha xki ndu, ne hinte bi dini. ");
INSERT INTO otqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nepꞌu̱ bi ꞌñemba ár ꞌbe̱go mi su ar hwöhi: Di ne gi tse̱ka nunar ꞌba̱iꞌiuxi, ngetho hñu nje̱ye̱ xta ehe di handi ha da ndu, ne hinte xta tini. Jange te ga jafu̱, ho̱nse̱ honga nze̱ ar ha̱i ne hinte uni. ");
INSERT INTO otqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nuꞌmú̱ bi ꞌñenga ar ꞌbe̱go: Ma tsi hmuꞌi, yo gi tse̱jmö. Ma ga he̱hu̱ manꞌa nje̱ye̱. Ma ga fo̱mba ar ha̱i ne ga u̱tꞌwa ar ꞌyai. ");
INSERT INTO otqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xömhö njapꞌu̱ da ndu. Ha nuꞌmu̱ hinda uni, nuꞌmú̱ hö, da za̱ gi tse̱ki. ");
INSERT INTO otqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nꞌar pa ntsa̱ya̱ ar Hesu mi ꞌbu̱ ha nꞌár nijö ya xodyo, mi uta ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ne mi ꞌbu̱hnu̱ nꞌar tsi ꞌbe̱hñö xki nkꞌoxtha. Xki tho ꞌre̱tꞌamahñöto nje̱ye̱ nꞌar tsꞌondöhi xki japi nda ñheni, himi he̱gi nda jönga ár xu̱tha. ");
INSERT INTO otqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nu mi hyanda ar Hesu, bi zofo ne bi ꞌñembabi: —Nönö, nupya xi hye̱kꞌaꞌi ri hñeni. ");
INSERT INTO otqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nuꞌmú̱ bi hñuꞌspa yá ꞌye̱ ar tsi ꞌbe̱hñö. Ne dama bi za̱ bi jönga xiñho ár ndoꞌyo, ne bi mu̱di bi umba njamödi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ne nöꞌö mar ndöngi har nijö, bi mbo̱ ár kwe̱, ngetho ar Hesu bi o̱the ar tsi ꞌbe̱hñö har pa ntsa̱ya̱. Ne bi ꞌñemba ya jöꞌi: —Di pe̱ꞌsu̱ ꞌrato mpa ga mpe̱hu̱. Nuꞌmu̱ tsu̱ꞌahu̱ ya hñeni, ba ehu̱ nuya paꞌu̱ da tꞌo̱theꞌihu̱, hinge nuya pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ar tsi Hmu bi dödi ne bi ꞌñenö: —Nemhñöhu̱. Ha hingi xoꞌthu̱ ri boihu̱ wa ri nꞌo̱gehu̱ gi tsíthu̱, mödi ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Xi nunar tsi ꞌbe̱hñönu̱ ár ma̱ngaꞌbe̱to ar Abra, xi ꞌwe̱ꞌsa ar tsꞌondöhi ꞌre̱tꞌamahñöto nje̱ye̱, hage hingi ho da sotꞌi mödi ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ne nu mi mönga njapꞌu̱ ar Hesu, gatho nuyá ñꞌu̱niwi mi ꞌbu̱hnu̱, bi ꞌbe̱ yá tsa̱. Ha nu maꞌra ya jöꞌi xa mi johya mi hyanda ya döta ntꞌudi mi o̱tꞌa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bi ꞌñenga ar Hesu nꞌehe: —Tema ga emfu̱ di hñöxa ár tsꞌu̱tꞌwi Jö, wa tema ga he̱kwabihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Njangu nꞌar tsi nda̱murtasa bi motꞌa nꞌar ñꞌo̱ho̱ hár hwöza. Ne xa bi te nꞌar ꞌba̱iza, ne ya tsꞌintsꞌu̱ ka köxhnu̱ yá mꞌafi. ");
INSERT INTO otqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bi ꞌñenga ar Hesu nꞌehe: —Tema ga he̱kwabipya ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ñhe̱hwi ar njoxthuhme bi pantꞌa nꞌar ꞌbe̱hñö ha gu̱to hwada ar ju̱ni, ne bi do̱ꞌmi bi joxa xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ar Hesu mi ne ar ꞌñu ndi ma Herusalen, mi tho ha ya döta hnini ne ya tꞌu̱lo hnini, mi uta ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ne nꞌar jöꞌi bi ꞌya̱ni ne bi ꞌñembi: —Tsi Hmuꞌi, hage tsi tu̱i ya jöꞌi ma da mpo̱ho̱. Ha nöꞌö bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Umba ri mu̱ihu̱ gi ku̱thu̱ har goxthi xi ntsꞌixtꞌi. Nuga di xiꞌahu̱, nze̱ye̱ di nemhö da yu̱tnu̱, ne hinda tsa̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jangu xta gotꞌa ar goxthi nöꞌö togo ár me̱ti ar ngu, njapꞌu̱ nuꞌahu̱ mꞌe̱fa xa ma gi mahmöhu̱ ne gi ꞌñeñhu̱: Ma tsi Hmuꞌihe, xogagihe ar goxthi. Ha nöꞌö ma da dödi ne da ꞌñeñꞌahu̱: Hindi pödi habu̱ xka ꞌñehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nepꞌu̱ nuꞌahu̱ ma gi ꞌñembabihu̱: Hanja hingi pöje. Ndi ñuñhu̱ ne ndi tsithehu̱, ne ha ma hninihe go ngi utkagihe ri ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ha nöꞌö ma da ꞌñeñꞌahu̱: Di xiꞌahu̱ hindi pödi habu̱ xka ꞌñehu̱. ꞌWehu̱, ꞌyo̱tꞌatsꞌokiꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ne xa gi nzoñhu̱nu̱, ne xa ma da du ri mu̱ihu̱, nu xki hyanthu̱ ndu ri mu̱di palehu̱ ar Abra, ne ar Isa, ne ar Hakob, ne gatho yá mꞌe̱hni Jö di ꞌbu̱hnu̱ hár tsꞌu̱tꞌwi Jö, ne nuꞌahu̱ hinda the̱kꞌahu̱ gi ku̱thu̱. Ma gi kohu̱ nthi. ");
INSERT INTO otqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ne ma da e ya jöꞌi xo̱ge ar ximha̱i, di du̱ꞌma mahyatsꞌi, di göxa mampuni, ne mahwifi di göxa makꞌangi. Ne ma da yu̱tꞌu̱ hár tsꞌu̱tꞌwi Jö, ma da hñuhnu̱ har mexa da ñuni. ");
INSERT INTO otqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ne nuya paꞌu̱, nuꞌu̱ ꞌbe̱tꞌopya, ma da mꞌe̱fa, ha nuꞌu̱ ꞌbe̱fa, ma da mꞌe̱tꞌoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nunar paꞌö, bi zo̱ ꞌra ya de̱ngaꞌbe̱pate ha mi ꞌbu̱ ar Hesu, ne bi ꞌñembabi: —Di ma, tsokwa nunar ha̱inu̱, ngetho ar ndö Erode e̱kꞌatho da hyoꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ha nu ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Di möhu̱ ba xifu̱ nöꞌö ar hya̱te jöꞌi: Nupya ne xudi hinga tsa̱ya̱ ga e̱nga ya tsꞌondöhi, ne ga o̱the ya da̱thi, ne ndamöni ga jwata ma ꞌbe̱fiwa. ");
INSERT INTO otqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nupya ne xudi ne ndamöni, ga ne ma ꞌñu gar ma Herusalen, ngetho habu̱ xi thopa yá mꞌe̱hni Jö, mahyoni da thogaginu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nuꞌahu̱ gar menguhu̱ Herusalen, gi hofu̱ yá mꞌe̱hni Jö, ne gi kꞌampabihu̱ togo bi pe̱ñꞌahu̱. Hangu xta nehmö nga muntsꞌahu̱, ngu nꞌar tsi o̱ni muntsꞌa yá tꞌu̱ꞌni da hwixa ha yá hwa, ne hinga nehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pöhu̱, Jö ma da hye̱kꞌase̱ ri nijöhu̱. Ne di xiꞌahu̱, hinge ma gi hyandgagihu̱ nuya payu̱. Gi to̱ꞌmhu̱ da zo̱ ar pa gi ꞌñeñhu̱: Nsunda nöꞌö togo xpa pe̱hna Jö ma tsi Hmuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nꞌar pa ntsa̱ya̱ ar Hesu bi ma ba ñunga hár ngu nꞌar ndö mar de̱ngaꞌbe̱pate, ne nuyá ñꞌohu̱ mi öthó tema mi o̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne ka mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ mi ñhandwi xa mi neni. ");
INSERT INTO otqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nepꞌu̱ ar Hesu bi ꞌya̱mbabi ya de̱ngaꞌbe̱pate ne ya bötꞌofo, bi ꞌñembabiꞌu̱: —Hage ja ar se̱ki da tꞌo̱the nꞌar da̱thi har pa ntsa̱ya̱, wa hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ha nuꞌu̱ bi ñhetho, hinte bi dödi. Nuꞌmú̱ ar Hesu bi hñuꞌspa ár ꞌye̱ nöꞌö ar ñꞌo̱ho̱ mi neni, bi o̱the ne bi me̱hni bi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nepꞌu̱ bi ꞌñembabi ya de̱ngaꞌbe̱pate ne ya bötꞌofo: —Nuꞌmu̱ da zo nꞌa ri nꞌo̱gehu̱ wa nꞌa ri boihu̱ ha nꞌar po̱the, ha hinge dama gi hñöhu̱ mödi ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ha nuꞌu̱ himbi za̱ te bi dödi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ar Hesu mi hyanda mi tso̱ nuꞌu̱ xki tsꞌohna har ñhuni, ne mi hwañꞌu̱ ya ꞌbe̱tꞌo nthutsꞌi nda hñu har mexa. Bi xipabiꞌu̱ nꞌar ꞌbede, ne bi ꞌñembabi: ");
INSERT INTO otqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Núꞌmu̱ xta tsꞌoñꞌaꞌi ha nꞌar ngo, yo ma gi hñuxa ha ya ꞌbe̱tꞌo nthutsꞌi. Xiꞌmu̱ da zo̱ manꞌa nöꞌö xi tsꞌohni ne töte ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nepꞌu̱ nöꞌö togo xi zoñꞌaꞌi, da ꞌñeñꞌaꞌi: Tsokwapꞌu̱ ar nthutsꞌi nuna manꞌa. Geꞌmu̱ nꞌar mꞌe̱tsa̱ nu xki ꞌba̱i gi hñu har ngötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jange núꞌmu̱ xta tsꞌoñꞌaꞌi ha nꞌar ñhuni, hñuxa har ngötsꞌi. Ne nu xta hyantꞌa togo xi zoñꞌaꞌi, da ꞌñeñꞌaꞌi: Hanja ga hñuxkwa, ño̱. Thogi di ma ba hñuxa ha ya ꞌbe̱tꞌo nthutsꞌi. Ne njapꞌu̱ da hyanda nuꞌu̱ maꞌra di huhnu̱ har mexa, ne da tꞌesꞌaꞌi ri nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nuga di xiꞌahu̱, nöꞌö togo da ñꞌexase̱, ma da ꞌbe̱ ár tsa̱. Ha nöꞌö togo hingar ñꞌetsꞌi, da tꞌeꞌspabi ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ne bi ꞌñembabi nöꞌö togo xki zohni: —Nuꞌmu̱ gi beni gi unga nꞌar ñhuni wa nꞌar ntꞌoxiwa ha ri ngu, yo gi zohna nuya ri mpödi, ri ku, nuya ri mëni, wa ri nꞌangu nuꞌu̱ pe̱ꞌsa ya bojö. Ngetho njapꞌu̱, nuꞌu̱ nꞌar pa ma da zoñꞌaꞌi nꞌehe, ne da kosꞌatho ngu xka ꞌyo̱tꞌwabi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Núꞌmu̱ xki ꞌyo̱tꞌa nꞌar ngo, zohna ya tsi hyoya, nuꞌu̱ doꞌye̱, nuꞌu̱ dowa, nuꞌu̱ ya tsi goda̱. ");
INSERT INTO otqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nuya tsi jöꞌiꞌu̱, hinda ma da kosꞌa nöꞌö gi o̱twabiꞌu̱. Ne mꞌe̱fa har ñoho mꞌu̱i, nu xki pengi gi ntewi gatho nu maꞌra xi ꞌyo̱tꞌa xiñho, ma gi njohya gi hñönga ri nthöhö. ");
INSERT INTO otqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nu mi ꞌyo̱ njapꞌu̱ nuꞌu̱ ya jöꞌi mi huhnu̱ har mexa, nꞌaꞌu̱ bi ꞌñemba ar Hesu: —Tengu ár johya nöꞌö togo ma da hñudi da ñunga hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Nꞌar pa nꞌar ñꞌo̱ho̱ bi ꞌyo̱tꞌa nꞌar döta ñhuni, ne bi zohna nze̱ ya jöꞌi nda ñungwi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Núꞌmu̱ mi ñhoki nda ñuni, bi me̱hna yá ꞌbe̱go nda xipa nuya jöꞌi xki zohni: Ba ehu̱, ngetho xi ꞌbo̱kꞌahu̱ ar mexa. ");
INSERT INTO otqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ha gatho nuꞌu̱ ya jöꞌi xki zohni, bi ꞌya̱ ar mpumbate, ngetho hinge nda ma. Nöꞌö mꞌe̱tꞌo bi ꞌñenö: Gi pumgagi ngetho hingi tsa̱ ga ma. Ka di jwadi di ta̱nga nꞌar ha̱i, ne mahyoni ma ga kꞌötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ha nöꞌö manꞌa bi ꞌñenö: Xta ta̱nga ku̱tꞌa ntꞌe̱i ya boi. Jange di a̱di gi pumgi, hinda tsa̱ ga ma, ngetho mahyoni ma ga nu ha mpe̱fi xiñho. ");
INSERT INTO otqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ha nöꞌö manꞌa bi ꞌñenö: Ka di jwadi di nthöti, hinda tsa̱ ga ma. ");
INSERT INTO otqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mi menga ar ꞌbe̱go, bi xipabi ár hmu hanja bi dö gatho nuꞌu̱ xki zohni. Nuꞌmú̱ ar hmu xa bi mbo̱ ár kwe̱, ne bi ꞌñemba ár ꞌbe̱go: Di ma har ta̱i ne ha ya ꞌñu har hnini, ne ba tsinkawa gatho nuꞌu̱ gi timpꞌu̱, ya tsi hyoya, ne nuꞌu̱ doꞌye̱, nuꞌu̱ dowa, ne ya goda̱, ba tsihi ga ñumꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mꞌe̱fa nu ar ꞌbe̱go bi ꞌñemba ár hmu: Xta o̱tꞌa ngu xka xikagi, ne pongda habu̱ da hñuxa maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nepꞌu̱ ar hmu bi ꞌñembabi ár ꞌbe̱go: Nupya di ma ha ya döꞌñu, ne hár nthetꞌi ar hnini. Ne gatho nuꞌu̱ gi nthe̱wi gi japi da ehe, ne da ñuxa ma ngu habu̱ pongi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngetho nuya da zohna mꞌe̱tꞌo, di xiꞌahu̱ hinto ma da zipka ma ñhuni. ");
INSERT INTO otqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nze̱ye̱ ya jöꞌi mi ñꞌowi ar Hesu, ne nöꞌö bi ñhandwi ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Nöꞌö togo ne da de̱ngagi, mahyoni di töte ar mhöte di pe̱ꞌskagi, ne mꞌe̱fa da mö ár dada, ár nönö, ár ꞌbe̱hñö, yá bötsi, yá ku, ne ár tese̱. Ha nuꞌmu̱ hindi njapꞌu̱, hinda tsa̱ ga embabi ma ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ha nöꞌö togo hinda ñꞌe̱ntꞌa ár te da de̱ngagi, hinda tsa̱ ga embabi ma ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Xiꞌmu̱ nꞌar jöꞌi beni da hyoka nꞌar heꞌsjödo, hage hinda hñudi mꞌe̱tꞌo da nu ha jwa ar bojö, wa hinda za̱ da jwati. ");
INSERT INTO otqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ha nuꞌmu̱ hinda nu mꞌe̱tꞌo, ne ho̱nse̱ da du̱ꞌmba ár wa ar jödo, ne hinda za̱ da jwati, gatho nuꞌu̱ ya jöꞌi bi hyandi, ma da deni. ");
INSERT INTO otqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ne da ꞌñeñꞌu̱: Nunar ñꞌo̱ho̱nu̱, ho̱nse̱ bi du̱ꞌma ar ꞌbe̱fi, ne himbi za̱ bi jwati. ");
INSERT INTO otqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xiꞌmu̱ nꞌar ndö beni da do̱xa manꞌár mindöwi togo pe̱ꞌsa yonthebenthebe ya ndogu, hage hinda hñudi da nu mꞌe̱tꞌo, ha da za̱ da döhö hönse̱ di pe̱ꞌsa nuꞌu̱ nꞌanthebenthebe ya ndogu. ");
INSERT INTO otqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ha nuꞌmu̱ handi hinda ntöte, da me̱mpa ꞌra yá mꞌe̱hni ár mindöwi bi e yapꞌu̱tho, da xipabi teme a̱di, ne da mengtho hinda ntunkwi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jange nuga di xiꞌahu̱, nuꞌu̱ togo hinda hye̱pꞌu̱ gatho nöꞌö te pe̱tsꞌi, hinda tsa̱ ga embabi ma ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nu ar u xiñho, ha nuꞌmu̱ da ꞌbe̱ ár ñꞌuxi, hanja da menga ár nku̱hi. ");
INSERT INTO otqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Hingi ho da tꞌu̱tꞌa har hwöhi, wa da jwata ngu ar ꞌyai. Hinte ár ñho, jange da tꞌe̱mpꞌu̱. Nöꞌö togo tu ár gu, dá ꞌyo̱xa nöꞌö te di mö. ");
INSERT INTO otqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nze̱ye̱ ya njotbojö ne maꞌra ya tsꞌojöꞌi, bi ma ba tsu̱ ar Hesu nda ꞌyo̱xa nöꞌö mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jange nuya de̱ngaꞌbe̱pate ne nuya bötꞌofo, mi ñömañꞌu̱ mi eñꞌu̱: —Nunar ñꞌo̱ho̱nu̱ ñöwi ne ñungwi ya tsꞌojöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nuꞌmú̱ ar Hesu bi xipabi nꞌar ꞌbede, ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Xiꞌmu̱ gi ꞌñehu̱ nꞌanthebe ya de̱ti, ne gi ꞌbe̱hu̱ nꞌa, ha hingi tsohu̱ nuya gohonꞌa̱te ne ꞌre̱tꞌamagu̱to har ꞌbatha, ne gi ꞌyohu̱ xo̱ge ar ngwani, gi hyoñhu̱ nöꞌö xka ꞌbe̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ne xki tiñhu̱, gi ꞌye̱ntsꞌa ha ri xiꞌnxihu̱, ne xa gi njohyahu̱ gi tsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ne xki tso̱hu̱ ri nguhu̱, gi zoñhu̱ gatho ri mpöhwihu̱ ne ri nꞌanguhu̱, ne gi ꞌñembabihu̱: Di ne ga njohyahu̱, ngetho xta tinga nꞌa ma de̱ti xki mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jange di xiꞌahu̱, njapꞌu̱tho nꞌehe, nuꞌmu̱ nꞌar ꞌyo̱tꞌatsꞌoki da ꞌyo̱tꞌwa ár ntso̱ꞌmi, xa töte ar johya mañö mhetsꞌi, töta nuꞌu̱ gohonꞌa̱te ne ꞌre̱tꞌamagu̱to ya hogajöꞌi beni himahyoni da ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Xiꞌmu̱ nꞌar ꞌbe̱hñö pe̱ꞌsa ꞌre̱tꞌa ya bojö ne da ꞌbe̱ nꞌa, ha hinda tso̱ ar ñotꞌi, ne ꞌramtxꞌu̱ da goka xo̱ge ár ngu da hyoni. ");
INSERT INTO otqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne xta dini, da zohna gatho yá mpödi ne yá nꞌangu, ne da ꞌñembi: Di ne ga njohyahu̱, ngetho xta tinga nꞌa ma bojö xki mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jange di xiꞌahu̱, njapꞌu̱tho nꞌehe, nuꞌmu̱ nꞌar ꞌyo̱tꞌatsꞌoki da ꞌyo̱tꞌwa ár ntso̱ꞌmi, bi ja ar johya habu̱ bi ꞌbu̱i yá e̱nxe̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ar Hesu bi ꞌñenö nꞌe: —Nꞌar ñꞌo̱ho̱ mi ꞌñe yoho yá tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nöꞌö ar ꞌbe̱fatꞌu̱ bi ꞌñemba ár dada: Te gi mö dada, xiꞌmu̱ gi ꞌraka nöꞌö ar xe̱ni ma gi tsogagi. Ha nu ár dada bi hyembabi yá tꞌu̱ gatho nöꞌö mi pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xki tho ꞌra ya tsi pa, nu ar ꞌbe̱fatꞌu̱ bi muntsꞌa gatho nöꞌö te xki tꞌumbi. Ne bi bo̱nga hár ngu, bi gu̱ ar ꞌñu bi hñötsꞌi, bi ma manꞌar ha̱i yapꞌu̱, habu̱ ba e̱mpꞌu̱ ár bojö mi ꞌbu̱ nꞌar ꞌmu̱i himar ñho. ");
INSERT INTO otqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ha nu mi dege gatho nöꞌö te mi hö, xa bi nja nꞌar thuhu har hnininu̱ habu̱ mi ꞌbu̱ꞌö, hinte mi tini te nda zi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bi ma ba a̱pa ar ꞌbe̱fi nꞌar ñꞌo̱ho̱ mar mengunu̱, ne nunar ñꞌo̱ho̱ꞌö bi me̱hna hár ꞌbatha nda supa yá tsꞌu̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Xa mi tsu̱ nꞌar thuhu, mi ne nda zipahmö nuyá ñhuni mi tsi ya tsꞌu̱di, ne hinto mi hwëki nda umbatsꞌu̱ te nda zi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nꞌa mbi bense̱: Hangu yá ꞌbe̱go ma dada pongwathobi te da zi, ha nuga di tuwa ar thuhu. ");
INSERT INTO otqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma ga penga hár ngu ma dada, ne ga embabi: Ma dadaꞌi, xta tsꞌokwa Jö, ne nuꞌge nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hindi ꞌñepkagi gi ꞌñengagi ri tꞌu̱gi. Hyandgagipya ngu nꞌa ri ꞌbe̱gotho. ");
INSERT INTO otqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ne bi gu̱ ar ꞌñu bi menga hár ngu ár dada. ꞌBu̱tho nda zo̱ni, bi hyanda ár dada, ne xa bi hwëki, bi nixtꞌi ba thödi. Mi nthe̱wi bi hyu̱fi, ne bi zu̱ꞌtsi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ar tꞌu̱ bi ꞌñenö: Ma dadaꞌi, xta tsꞌokwa Jö, ne nuꞌge nꞌehe. Hindi ꞌñepkagi gi ꞌñengagi ri tꞌu̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ha nu ár dada bi ꞌñembabi yá ꞌbe̱go: Ba hömfu̱ ar hoga he, ne hyethu̱. Tuthwu̱ nꞌar mfoꞌye̱, ne titꞌwabihu̱ ya thiza. ");
INSERT INTO otqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne ba tsihu̱ ar nokaboi, ga hohu̱ ne ga ñuñhu̱. Ma ga o̱thu̱ nꞌar da̱ngo njohya. ");
INSERT INTO otqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ngetho numa tꞌu̱ ndi humamu̱i xki du, ha tetho. Xki mꞌe̱di ne da pengi da tini. Ne bi ndu̱i ar da̱ngo njohya. ");
INSERT INTO otqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mꞌe̱fa bi zo̱ ar ꞌbe̱tꞌotꞌu̱ mi ꞌyo har hwöhi. Ha nu mi zo̱nga getꞌu̱ ar ngu, bi ꞌyo̱de mi ja ya me̱ꞌmda ne ya nhei. ");
INSERT INTO otqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bi matꞌa nꞌar ꞌbe̱go, ne bi ꞌya̱ni te mi ja har ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nu ar ꞌbe̱go bi ꞌñembabi: Ri jödö ba pengi, jange ri dada xi mö nda tho ar nokaboi da njohya, ngetho xi zo̱mañho. ");
INSERT INTO otqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nuꞌmú̱ nunar ꞌbe̱tꞌojödö xa bi mbo̱ ár kwe̱, himi ne nda yu̱tꞌi. Ne ba po̱nga ár dada nda xipabi nda yu̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ha nunu̱ bi ꞌñemba ár dada: Gi pöse̱ hangu ya je̱ye̱ di ꞌbu̱hwi, ne di pe̱pꞌaꞌi. Xta o̱tꞌa gatho ngu xka xikagi, ne hinxka ꞌraka nꞌar tsi tꞌöxi ga njohyaꞌbe ma mpödi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ha nupya hö, xi zo̱ ri tꞌu̱ togo xpa e̱mba ri bojö ya tsꞌoꞌbe̱hñö. Nöꞌö hö, gi hopa ar nokaboi. ");
INSERT INTO otqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nunár dada bi ꞌñembabi: Ma tsi tꞌu̱ꞌi, nuꞌge hyaxtho di ꞌbu̱hwi, ne gatho nöꞌö di pe̱tsꞌi ri me̱ti nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ho̱nse̱ nupya mahyoni ga njohyahu̱, ne ga o̱thu̱ ar da̱ngo njohya. Ngetho ri jödö ndi humamu̱i xki du, ne xpa pengi tetho. Xki mꞌe̱di, ne da pengi da tiñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ar Hesu bi ꞌñembabi yá ma̱xte nꞌehe: —Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ xa hinte mi kꞌatꞌi. Ne mi ꞌñe nꞌar ꞌbe̱go, xki nsipabi mi e̱mba ár bojö. ");
INSERT INTO otqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jange ar hmu bi zohna ár ꞌbe̱go, ne bi ꞌñembabi: Xta o̱ka ꞌra ya ꞌbede ntho̱xꞌaꞌi. Jange di ne gi da̱tka majöni gatho ri ꞌbe̱fi, ngetho hindi ne gi pe̱pkathogi. ");
INSERT INTO otqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nepꞌu̱ nöꞌö ar ꞌbe̱goꞌö bi bense̱ hár mfeni, ne bi ꞌñenö: Xipya te ga pe̱fi. Ma hmu da hñömga ma ꞌbe̱fi, ha hiñꞌotho ma tsꞌe̱di ga xa̱ꞌmar ha̱i, ha ꞌraka ar mꞌe̱tsa̱ ga mpe̱ti. ");
INSERT INTO otqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Xta beni te ga pe̱fi. Ma ga nu ha ga japi da ꞌrakar se̱ki ha yá ngu nuꞌu̱ togo tupabi ma hmu, núꞌmu̱ xta thögagi ma ꞌbe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ne bi zohna ꞌramanꞌa nuꞌu̱ togo mi tupabi ár hmu. Nöꞌö ar ndu̱i bi ꞌya̱mbabi: Hangu gi tupa ma hmu. ");
INSERT INTO otqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nöꞌö bi dödi ne bi ꞌñenö: Di tupabi nꞌanthebe ntsꞌo̱i ar nziki. Ha nöꞌö ar ꞌbe̱go bi ꞌñembabi: ꞌBu̱kwa ar he̱ꞌmi habu̱ hutsꞌi hangu gi tupa ma hmu. Dama hyoka manꞌa habu̱ di mö, ho̱nse̱ madenthebe ntsꞌo̱i gi tu. ");
INSERT INTO otqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nepꞌu̱ nöꞌö manꞌa bi ꞌñembabi: Xiꞌge hangu gi tuge. Nöꞌö bi ꞌñenö: Nꞌanthebe ndu ar tꞌe̱i. Nepꞌu̱ nöꞌö ar ꞌbe̱go bi ꞌñembabi: ꞌBu̱kwa ri he̱ꞌmi habu̱ huxa hangu gi tupa ma hmu. Hyoka manꞌa habu̱ di mö, ho̱nse̱ gohonꞌa̱te gi tu. ");
INSERT INTO otqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nepꞌu̱ nu ár hmu bi ꞌñeꞌspa ár nsu nöꞌö ar tsꞌoꞌbe̱goꞌö, ngetho dama bi tita ár mfeni bi gohwi xiñho nuꞌu̱ togo mi tu ya tha̱i. Jange njapꞌu̱ nuya meximha̱i, xa ka mbödi da zixkwi xiñho yá ñꞌohu̱ nuyá ꞌbe̱fiꞌu̱, ha nuꞌu̱ xi jamfi Jö hingi njapꞌu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ha nuga di xiꞌahu̱, nunár bojö ar tsꞌoximha̱i gi pe̱ꞌsu̱, fa̱xu̱ maꞌra, ne njapꞌu̱ gi ntsixkwihu̱. Ne nu xta the ri tehu̱, ne da the ar bojö, ma da tꞌaꞌahu̱ habu̱ gi tsa̱ya̱hu̱nu̱ mhetsꞌi hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nöꞌö togo su xiñho nöꞌö nꞌa tsi tu̱i tꞌumbabi, njapꞌu̱tho nuꞌmu̱ da tꞌumba nze̱ye̱. Ha nöꞌö hingi su xiñho nöꞌö tsi tu̱i tꞌumbabi, nuꞌmu̱ da tꞌumba nze̱ye̱, hinda su nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Njapꞌu̱tho nꞌehe, nuꞌmu̱ hingi sufu̱ xiñho ya ñho jawa har ximha̱i, togo da ka̱xmbeniꞌihu̱ da ꞌraꞌahu̱ gi kwathu̱ ya ñho hiñhamꞌu̱ da thege. ");
INSERT INTO otqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nuꞌmu̱ hingi suhu̱ xiñho nöꞌö hingo ri me̱tihu̱, togo da ꞌraꞌahu̱ nöꞌö ri me̱tihu̱ gi suhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nꞌar ꞌbe̱go hinda tsa̱ da me̱pa yoho yá hmu, ngetho njapꞌu̱ da u̱tsa nꞌa, ne da mö manꞌa. Wa da me̱pa nꞌa, ne nöꞌö manꞌa hinꞌö. Njapꞌu̱ nꞌehe, hinda tsa̱ gi pe̱fu̱ Jö ne di oda ri mfenihu̱ ya ñho. ");
INSERT INTO otqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ha nuya de̱ngaꞌbe̱pate mi ꞌbu̱hnu̱ mi o̱tsꞌe, xa mi thenthoꞌu̱, ngetho xa mi mö ya bojö. ");
INSERT INTO otqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ha nu ar Hesu bi ꞌñembabiꞌu̱: —Nuꞌahu̱ ho̱nse̱ gi ꞌñu ri hmihu̱ ha yá nthandi ya jöꞌi. Ha Jö pötꞌathoꞌihu̱ ri mfenihu̱, ngetho nöꞌö numañho ya jöꞌi, Jö handi xi ntsꞌotho. ");
INSERT INTO otqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Núꞌmu̱ himi tso̱ta ar Xuwa Xixthe, ya ngi pe̱ꞌsfu̱ yá ꞌbe̱pate ar Moise ngi ꞌyo̱thu̱, ne nöꞌö xki mönga maꞌra yá mꞌe̱hni Jö. Ne nu mi zo̱ ar Xuwa dinjawa, xka ꞌyo̱hu̱ xi nsiꞌahu̱ ar hoga mhö no̱nga ár tsꞌu̱tꞌwi Jö, ne nze̱ye̱ xi umba yá mu̱i da yu̱tꞌa hár tsꞌu̱tꞌwiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ar mhetsꞌi ne ar ximha̱i hingi hembi da götsꞌi. Ha hiñꞌotho nꞌar tꞌofo xi tꞌotꞌa hár Tꞌofo Jö, hinda njapꞌu̱tho. Ma da tho gatho ngu möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nuꞌmu̱ nꞌar ñꞌo̱ho̱ da hye̱pꞌu̱ ár ꞌbe̱hñö ne da nthötwi manꞌa, tsimbabi ár nthöti. Ne nöꞌö togo da nthötwi nꞌar ꞌbe̱hñö xi hye̱ ár döme, tsimba ár nthöti nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ hinte mi kꞌatꞌi, ne xa mi ñhe xiñho, mi ko̱ ꞌra ya hoga dutu xa mar nza̱tho. Ne hyaxꞌmu̱ mi exa ár nsu mi o̱tꞌa ya da̱ngo. ");
INSERT INTO otqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne mi ꞌbu̱ nꞌar tsi me̱ti már thuhu ar Lasaro, hyaxꞌmu̱ mi huhnu̱ hár goxthi ár ngu ar ñꞌo̱ho̱ hinte mi kꞌatꞌi. Nunar tsi me̱tinu̱ xa xki fo̱xtꞌa xo̱ge ár ndoꞌyo, ne mi po. ");
INSERT INTO otqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mi e ya ꞌyo mi teꞌspabi habu̱ xki ꞌya. Ne nöꞌö ar tsi ñꞌo̱ho̱ꞌö, mi nemhö nda go nda zi nuꞌu̱ ya xe̱ni mi ta̱ hár mexa ar ñꞌo̱ho̱ hinte mi kꞌatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nꞌar pa bi du ar tsi me̱ti, ne ya e̱nxe̱ mhetsꞌi ba e bi zitsꞌi nda mꞌu̱hwi ar Abra. Mꞌe̱fa bi du nöꞌö hinte mi kꞌatꞌi nꞌehe, ne bi tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nu mi onu̱ har ꞌbe̱xui, xa mi tho nꞌar u̱gi. Bi gu̱xnu̱ ár da̱, ne bi hyanda yapꞌu̱ ar Abra ne ar Lasaro mi ꞌbu̱hwinu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bi matꞌi ne bi ꞌñembabi: Ma tsi dadaꞌi Abra, pe̱ꞌska ar nhwëki. Ba pe̱hna ar Lasaro da po nꞌár xa̱ ha nꞌar tsi tu̱i ar dehe, da e da tse̱tka ma jöhne. Ngetho xa di thokwa ya u̱gi ha ya faspi. ");
INSERT INTO otqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ha nu ar Abra bi ꞌñembabi: Ma tsi tꞌu̱ꞌi, benga núꞌmu̱ ngi ꞌbu̱hnu̱ har ximha̱i, xa ngi ꞌbu̱i xiñho, ha nu ar Lasaro mi ñꞌu̱da ár mꞌu̱i mi hyoya. Ha nupya, nunu̱ ꞌbu̱kwa xiñho, ha nuꞌge ñꞌu̱da habu̱ gi ꞌbu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ha hinda tsa̱ da mapꞌu̱ ar Lasaro, ngetho ja nꞌar maꞌye madetho xa ra ñhe. Jange nuꞌu̱ ꞌbu̱kwa, hinda za̱ da mapꞌu̱, ha nuꞌu̱ bi ꞌbu̱pꞌu̱, hinda za̱ di ꞌñekwa. ");
INSERT INTO otqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ha nöꞌö ar ñꞌo̱ho̱ꞌö bi ꞌñenö: Ma tsi dadaꞌi Abra, nuꞌmú̱, di a̱ꞌa ar möte gi pe̱hnatsꞌu̱ ar Lasaro hár ngu ma dada. ");
INSERT INTO otqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ngetho di ꞌñe ku̱tꞌa ma jödö, di ne da zofo ne hinda ekwa da tho ya u̱gi ngu di thoka. ");
INSERT INTO otqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ha nunar Abra bi ꞌñembabi: Nuꞌu̱ bi pe̱ꞌspa nöꞌö bi ꞌyotꞌa ar Moise ne nöꞌö bi ꞌyotꞌa nuꞌu̱ maꞌra yá mꞌe̱hni Jö. Go da ꞌyo̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nunar ñꞌo̱ho̱ꞌö bi mengi bi ꞌñenö: Hö, majöni nöꞌö gi mö, ma dadaꞌi Abra. Di beni, nuꞌmu̱ gi pe̱hna nꞌa nuꞌu̱ xi du, da ꞌyo̱tsꞌe ne da ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ha nunar Abra bi mengi bi ꞌñembabi: Nuꞌmu̱ hingo o̱ta nöꞌö bi mönga ar Moise ne maꞌra yá mꞌe̱hni Jö, hinda ne da jamfi nöꞌö da xipa nꞌa togo xi mengi xi nte. ");
INSERT INTO otqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ar Hesu bi ꞌñembabi yá ma̱xte: —Hyaxmꞌu̱ ja togo da japa ya jöꞌi da ntsꞌoki. Hwëkate nöꞌö ar jöꞌi da ꞌyo̱tꞌa njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Xiñhohmö nöꞌö ar jöꞌiꞌö da tsꞌu̱twa nꞌar doju̱ni hár ꞌyu̱ga, ne da tꞌe̱ntꞌa har dehe, ne njapꞌu̱ hinda japi da da̱ nuꞌu̱ hinxi ze̱ta yá ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jange ntsuñhu̱. Nuꞌmu̱ nꞌa ri kuhu̱ da ꞌyo̱tꞌahu̱ nꞌar tsꞌomꞌu̱i, hñökwabihu̱. Nuꞌmu̱ da ꞌyo̱tꞌwa ár ntso̱ꞌmi, pumbabihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nuꞌmu̱ da ꞌyo̱tꞌahu̱ ar tsꞌomꞌu̱i yoto mpengi ar pa, ne yoto mpengi da ehe da ꞌñeñꞌahu̱: Pumgagi, pumbabihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nuyá ma̱xte ar Hesu bi ꞌñembabi: —Hñuska ma ñꞌemu̱ihe. ");
INSERT INTO otqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nuꞌmú̱ ar tsi Hmu Hesu bi ꞌñenö: —Nuꞌmu̱ gi pe̱ꞌsu̱hmö ar ñꞌemu̱i ngu nꞌar nda̱murtasa ár döta, da za̱ gi ꞌñembabihu̱ nunar döta ꞌba̱izanu̱: Kꞌu̱xa habu̱ gi ꞌba̱i, ne di ma ba ku̱tꞌa har dehe. Ne nunar zaꞌö da ꞌyo̱tꞌahu̱ ngetho gi ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ar Hesu bi ꞌñembabiꞌu̱ nꞌehe: —Nuꞌahu̱ gi ꞌñehu̱ nꞌar ꞌbe̱go, hage gi ꞌñembabihu̱ xta penga har hwöhi wa ar ꞌba̱ꞌyo: Thogi gi hñudi gi ñuni. ");
INSERT INTO otqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hinꞌö. Ma gi ꞌñembabihu̱: Mꞌe̱tꞌo hogar tꞌoxi, ne gi ꞌraka te ga tsi. Mꞌe̱fa xka jwadi, ka gi hñudi gi ñunge nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ha gi umfu̱ njamödi nöꞌö ar ꞌbe̱go bi ꞌyo̱tꞌa nöꞌö ga ꞌbe̱fu̱. Di enga hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Njapꞌu̱tho nꞌehe, nu xki jwahu̱ gi pe̱fu̱ ár ꞌbe̱fi Jö xi ꞌbe̱pꞌahu̱, mahyoni gi ꞌñeñhu̱: Hindi ꞌñepkagihe gi ꞌraje njamödi, ngetho dar ꞌbe̱gothohe, ne ho̱nse̱ xta pe̱he nöꞌö ndi ꞌñepkagihe nga pe̱he. ");
INSERT INTO otqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ar Hesu ndi ma Herusalen, ne bi ꞌranga madeda yoho ya ha̱i, nꞌár thuhu Nsamaria, ha nöꞌö manꞌa Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Núꞌmu̱ mi zo̱nga hár ñu̱tꞌi nꞌar hnini, bi bo̱nga ꞌre̱tꞌa ya ñꞌo̱ho̱ mi tsu̱ ar tsitꞌandoꞌyo. Nuya ñꞌo̱ho̱yu̱ bi mꞌa̱ yapꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bi maꞌu̱ ntsꞌe̱di, ne bi ꞌñeñꞌu̱: —Hesu, tsi Utate, hwëgagihe. ");
INSERT INTO otqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ar Hesu nu mi hyantꞌu̱, bi ꞌñembabi: —Di möhu̱ ba ñꞌuhu̱ da hyantꞌahu̱ ya möjö. Ne nu mi maꞌu̱, mi ꞌyo ar ꞌñu bi dixa yá hñeni. ");
INSERT INTO otqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ne nꞌayu̱, mi za̱ xki ditsꞌi, bi mengi xa bi ñö ntsꞌe̱di, mi nsunda Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ne bi nda̱ndihmö hár wa ar Hesu, bi me̱ ár hmi har ha̱i, bi umba njamödi ngetho xki o̱thebi. Nöꞌö ar ñꞌo̱ho̱ꞌö mar me Nsamaria. ");
INSERT INTO otqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nuꞌmú̱ ar Hesu bi ꞌñenö: —Hage himi ꞌre̱tꞌa nuꞌu̱ bi ditsꞌi. Xö nuꞌu̱ ma gu̱to ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hage ho̱nse̱ nuna hingár me Israel ba pengi da nsunda Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne bi ꞌñemba nöꞌö ar ñꞌo̱ho̱ꞌö: —ꞌBa̱i di ma. Ya xka mpo̱ho̱ ngetho xka jamfigi. ");
INSERT INTO otqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nepꞌu̱ nuya de̱ngaꞌbe̱pate bi ꞌya̱mba ar Hesu hamꞌu̱ nda zo̱ ár tsꞌu̱tꞌwi Jö nuwa har ximha̱i. Nöꞌö bi dödi ne bi ꞌñembabi: —Nu xta e ár tsꞌu̱tꞌwi Jö, hinda ma da thandi. ");
INSERT INTO otqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hinda za̱ da tꞌeñꞌahu̱: Xi ꞌbu̱kwa. Wa da tꞌeñꞌahu̱: Bi ꞌbu̱hnu̱. Nu ár tsꞌu̱tꞌwi Jö gi ꞌbu̱hwihu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nepꞌu̱ bi ꞌñembabi yá ma̱xte: —Nuya pa xi ꞌñepꞌu̱, ma gi nehmöhu̱ gi hyanthu̱ mödi nꞌa pa di ndö Nöꞌö Togo ba e bi Njöꞌi, ha hinda tsa̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ne ma da tꞌeñꞌahu̱: Ka ꞌbu̱kwa. Wa da tꞌeñꞌahu̱: Ka bi ꞌbu̱hnu̱. Yo gi pa̱hu̱ gi kꞌöꞌsu̱, ne yo gi te̱ñhu̱ nuꞌu̱ togo da xiꞌahu̱ njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngetho ngu gi hanthu̱ nꞌar hwe̱i dama da yotꞌa nꞌár ñöni mhetsꞌi, ne da kꞌonga nöꞌö manꞌár ñöni, ma da njapꞌu̱ nöꞌö ar pa xta penga Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ne nunu̱ mahyoni mꞌe̱tꞌo da tho nze̱ye̱ ya thogi, ne xa ma da u̱tsa ya jöꞌi ꞌbu̱ nuya payu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ngu bi tho nuya paꞌu̱ mi ꞌbu̱ ar Noe, ma da njapꞌu̱tho nuya pa xta penga Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nuya jöꞌiꞌu̱ mi ñuntho, mi tsithetho, ne mi nthöta nꞌa ngu nꞌa. Mi da̱ñꞌu̱ bi zo̱ ar pa bi yu̱tꞌa ar Noe har döta motsa, ne bi ñuxa ar dehe xo̱ge ar ximha̱i, ne bi jötꞌu̱ gatho. ");
INSERT INTO otqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bi njapꞌu̱ nuya pa mi ꞌbu̱ ar Lot nꞌehe. Ya jöꞌi mi ñuni, mi tsithe, mi mpa̱ ne mi nta̱i, mi mpotꞌi ne mi ho̱ ya ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ha nunar pa bi bo̱nga ar Lot har hnini Sodoma, bi ꞌwö ya tsibi mi nthöskwi ya kꞌaxtꞌado mi zo̱, ne gatho ya jöꞌi bi zötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ma da njapꞌu̱ nöꞌö ar pa xta penga Nöꞌö Togo ba e bi Njöꞌi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nu ar paꞌö, nuꞌmu̱ nꞌa di to̱ mañör ngu, yo ma da göi da yu̱tꞌa hár ngu da gu̱ka te pe̱tsꞌi. Ne nöꞌö togo di ꞌyo hár hwöhi, yo ma da mengár ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Beñhu̱ teme bi ja ár ꞌbe̱hñö ar Lot. ");
INSERT INTO otqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gatho nuꞌu̱ da su ár te, da ꞌbe̱di. Ha nuꞌu̱ togo xi ꞌye̱ntꞌa ár te da thökwi, da dini. ");
INSERT INTO otqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Di xiꞌahu̱, nöꞌö ar nxuiꞌö, yoho di ꞌbonga ha nꞌar fidi, xta da̱ñꞌu̱ nꞌa da tsꞌitsꞌi, ha nöꞌö manꞌa da tsꞌopꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yoho ya ꞌbe̱hñö di ku̱nga mahye̱gi, xta da̱ñꞌu̱ nꞌa da tsꞌitsꞌi, ha nöꞌö manꞌa da tsꞌopꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yoho ya ñꞌo̱ho̱ di ꞌyo ha nꞌar hwöhi, nꞌa da tsꞌitsꞌi, ha nöꞌö manꞌa da tsꞌogi. ");
INSERT INTO otqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nu mi ꞌyo̱ njapꞌu̱ yá ma̱xte, bi ꞌya̱mbabi ar Hesu ne bi ꞌñembabi: —Ma tsi Hmuꞌihe, habu̱ ma da nja nöꞌö ga mö. Nöꞌö bi dödi ne bi ꞌñembabiꞌu̱: —Núnu̱ habu̱ di ꞌbe̱nga nꞌar me̱ti xi du, ka ma da watnu̱ ya pada da zaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ar Hesu bi xipa nꞌar ꞌbede yá ma̱xte, mi honi nda böꞌu̱, mahyoni hinge nda ntsa̱ya̱, ne hinda za̱ꞌu̱ nda ꞌya̱pa Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ne bi ꞌñembabiꞌu̱: —Mi ꞌbu̱ nꞌar nza̱ya̱ ha nꞌar hnini, himi tsupa Jö, ne himi japamasu nöꞌö nda mönga ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ka mi ꞌbu̱hnu̱ har hniniꞌö nꞌar ꞌranxu nꞌehe. Xa mi doni mi kꞌöꞌsa ar nza̱ya̱, ne mi embabi: ꞌYo̱tka ar tsꞌu̱tꞌwi, ñöngagi hinte da jakagi ma ñꞌu̱niꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bi tho ꞌra ya pa nunar nza̱ya̱nu̱ himbi ne bi ꞌyo̱tꞌwa ar tsꞌu̱tꞌwi. Ne nꞌa mbi bense̱, bi ꞌñenö: Nuga hindi tsupa Jö, ne hindi japamasu nöꞌö mönga ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mödi njapꞌu̱, nunar ꞌranxunu̱ xa tso̱tka ma mu̱i. Jange ma ga o̱tꞌwa ar tsꞌu̱tꞌwi, xiꞌmu̱ hyaxtho da ehe, ne da ꞌbe̱tka ma tse̱ti. ");
INSERT INTO otqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nuꞌmú̱ ar tsi Hmu Hesu bi ꞌñenö: —ꞌYo̱hu̱ nöꞌö bi mönga ar tsꞌonza̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xi Jö, hage hinda ꞌyo̱tꞌwa ar tsꞌu̱tꞌwi nuꞌu̱ togo xi hwahni, gehyu̱ parxui a̱pabi. Hage hinge ngutꞌa da ma̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Di xiꞌahu̱ hö, dama da ꞌyo̱tꞌwa ar tsꞌu̱tꞌwi. Ha nu xta penga Nöꞌö Togo ba e bi Njöꞌi, hage da dinga nꞌa togo di ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ar Hesu bi mönga manꞌar ꞌbede, mi xipa nuꞌu̱ mi beñꞌu̱ ma ya hogajöꞌi ne himi numañho yá ñꞌohu̱. Bi ꞌñemba njawa: ");
INSERT INTO otqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Yoho ya ñꞌo̱ho̱ bi ma ba a̱pa Jö har dönganijö, nꞌa mar de̱ngaꞌbe̱pate, ha nöꞌö manꞌa mar njotbojö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nu ar de̱ngaꞌbe̱pate mi ꞌba̱i mi a̱pase̱ Jö, ne mi enö njawa: Ma tsi Dadaꞌi, di jamödi ngetho nuga hindi ñhe̱ꞌbe nu maꞌra ya jöꞌi, ya bë, ya tsꞌomꞌu̱i, ya zinga ꞌbe̱hñö, ne hindi hñöxkagi nunar njotbojö ꞌba̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nuga ta̱tꞌa hñöto di bë yoꞌgi, ne di ꞌraꞌa ár ꞌre̱tꞌa xe̱ni ma nthöhö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ha nöꞌö ar njotbojö mi ꞌba̱ta yapꞌu̱, himi ne nda gu̱xhmö ár da̱ mhetsꞌi. Xa mi etꞌa ár mu̱i mi a̱pa Jö, mi enö: Ma tsi Dadaꞌi, hwëgagi, dar ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jange bi ꞌñenga ar Hesu: —Di xiꞌahu̱, nöꞌö ar njotbojö bi zu̱ ár mpumbate yá tsꞌoki, ne bi menga ár ngu mi nhu hinte ma tsꞌoki mi tu. Ha nunar de̱ngaꞌbe̱pate himbi zu̱ ar mpumbate. Ngetho nöꞌö togo da ñꞌexase̱, ma da mꞌe̱twa ár tsa̱. Ha nöꞌö togo hinda ñꞌetsꞌi, mꞌe̱fa da tꞌeꞌspa ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ba tsꞌimpa ya tsi bötsi ar Hesu nda hñuꞌspa yá ꞌye̱ ne nda jöpabiꞌu̱. Ha nu mi hyanda yá ma̱xte, bi zu̱i nuꞌu̱ togo mi tsihi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ha nunar Hesu bi matꞌa ya bötsi nda watꞌi, ne bi ꞌñenö: —Hye̱hu̱ ya tsi bötsi da e da zu̱kagi, yo gi hökwabihu̱. Ngetho gatho nuꞌu̱ ꞌbu̱ hár tsꞌu̱tꞌwi Jö, ñhe̱hwi nꞌar tsi bötsi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Xa majöni di xiꞌahu̱, nöꞌö togo hinda hñömba ár tsꞌu̱tꞌwi Jö ngu nꞌar tsi bötsi, hinda ma da yu̱tnu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nꞌar ndö bi ꞌya̱mbabi ar Hesu, ne bi ꞌñembabi: —Hoga Utate, te ga pe̱fi ne da tꞌaka ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ha nu ar Hesu bi ꞌñembabi: —Yoꞌö gi engagi dar hogajöꞌi. Ho̱nse̱ Jö go ar hogajöꞌiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gi pötwa yá ꞌbe̱pate Jö: Yo gi tsimba ár nthöti ri ñꞌohu̱, yo gi ñhote, yo gi mpë, yo gi ju̱xa ya nhemhñö, ꞌñeꞌspa ár nsu ri dada ne ri nönö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nöꞌö ar ñꞌo̱ho̱ bi ꞌñenö: —Gatho xta o̱tyu̱ ndi bötsitho. ");
INSERT INTO otqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ha nu mi ꞌyo̱ ar Hesu njapꞌu̱, bi ꞌñembabi: —ꞌBe̱ta nꞌa te gi pe̱fi. Di ma ba pa̱ gatho nöꞌö gi pe̱tsꞌi, ne hyembabi ya hyoya. Njapꞌu̱ gi pe̱ꞌsa ri ñhonu̱ mañö mhetsꞌi. Ne ba e gi te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Núꞌmu̱ mi ꞌyo̱ njapꞌu̱ nöꞌö ar ndöꞌö, xa bi du ár mu̱i, ngetho mi the̱ nze̱ye̱ yá ñho. ");
INSERT INTO otqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nu mi hyanda ar Hesu xa xki du ár mu̱i, bi ꞌñenö: —Xa xi ñhembi da yu̱tꞌa hár tsꞌu̱tꞌwi Jö nꞌar jöꞌi hinte kꞌatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Xi ñhembi da tho nꞌar döta me̱ti hár gu nꞌar ꞌyomhni, ha töte ár ñhembi da yu̱tꞌa nꞌa hinte kꞌatꞌi hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ha nuꞌu̱ togo bi ꞌyo̱de mi mönga njapꞌu̱, bi ꞌñenö: —Nuꞌmu̱ njapꞌu̱, togo da za̱ da mpo̱ho̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nu ar Hesu bi ꞌñembabi: —Nöꞌö hingi tsa̱ da ꞌyo̱tꞌa ya jöꞌi, Jö hinter ñhembibi da ꞌyo̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ar Pedro bi ꞌñembabi: —Nuje xta tsohe gatho nöꞌö ndi pe̱ꞌshmöhe ne xta te̱ñꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Xa majöni di xiꞌahu̱, nöꞌö togo xi zopꞌu̱ ár ngu, ár dada, ár nönö, ár ku, ár ꞌbe̱hñö, wa yá bötsi, ngetho xi hñömba ár tsꞌu̱tꞌwi Jö, ");
INSERT INTO otqNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ma da thuꞌspabi ár nze̱ye̱ nöꞌö da hñöngwa nuya payu̱, ne mꞌe̱fa ma da hñönga ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ar Hesu bi ꞌweka nꞌampꞌu̱ nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, ne bi ꞌñembabi: —Nupya gar möhö Herusalen, habu̱ ma da tho gatho ngu xi ꞌyotꞌa yá mꞌe̱hni Jö, bi möñꞌu̱ te gatho nda tꞌo̱tꞌwa Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ma da tꞌe̱ntꞌwa yá ꞌye̱ ya jöꞌi nuꞌu̱ hingyá xodyo. Ha nuꞌu̱ ma da zani, te gatho da tho̱tsꞌe, ne ma da tsꞌotsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xa ma da nꞌwe̱tꞌi, nepꞌu̱ da tho. Ne ár hñupa ma da mengi da nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ha nuyá ma̱xte himi tso yá mfeni nöꞌö mi xipa ar Hesu, ne himi tsa̱ nda böꞌu̱ te ndi bo̱nga nöꞌö mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nu mi zo̱nga ar Hesu hár ñu̱tꞌi ar hnini Heriko, ka bi nthe̱winu̱ nꞌar tsi goda̱ mi huhnu̱ har ꞌñu, mi pe̱ti. ");
INSERT INTO otqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ha nu mi ꞌyo̱de mi thohnu̱ nze̱ye̱ ya jöꞌi, bi ñꞌa̱ni teme mi thohnu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ne bi nsipabi mi thohnu̱ ar Hesu me Nasare. ");
INSERT INTO otqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Bi mafi ntsꞌe̱di ne bi ꞌñenö: —Nuꞌge Hesu, ár Tꞌu̱ꞌi ar ndö Dabi, pe̱ꞌska ar nhwëki. ");
INSERT INTO otqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nuya jöꞌi mi ꞌbe̱tꞌo mi tsu̱i, ne mi xipabi nda ñhe. Ha nöꞌö xa mi umba ár mu̱i mi mafi mi enö: —Ár Tꞌu̱ꞌi ar Dabi, hwëgagi. ");
INSERT INTO otqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nuꞌmú̱ ar Hesu bi mꞌa̱i, ne bi me̱hna togo nda tsihi. Mi zo̱nga habu̱ mi ꞌba̱ꞌö, bi ꞌya̱ni, ");
INSERT INTO otqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ne bi ꞌñembabi: —Te gi ne ga jaꞌaꞌi. Ha nu ar goda̱ bi dödi: —Ma tsi Hmuꞌi, di ne da xo ma da̱. ");
INSERT INTO otqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ne ar Hesu bi ꞌñembabi: —Nupya dá njapꞌu̱ ngu gi ne. Ga ñꞌemu̱i, jange xka hñöni. ");
INSERT INTO otqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nuꞌmú̱ ar goda̱ bi za̱ bi hyandi, ne bi de̱nga ar Hesu, mi umba njamödi Jö. Ne gatho nuꞌu̱ ya jöꞌi bi hyandi, mi nsunda Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nu mi zo̱nga ar Hesu har hnini Heriko, bi thota madeda ar hnini. ");
INSERT INTO otqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ka mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ hinte mi kꞌatꞌi, már ndö ya njotbojö. ");
INSERT INTO otqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xa mi ne nda hyanda ar Hesu, ne himi tsa̱, ngetho xki gotꞌatho nze̱ye̱ ya jöꞌi, ne nöꞌö himar ñhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jange bi mꞌe̱tꞌo, ne bi bo̱xa ha nꞌar za habu̱ ma nda tho ar Hesu, ne njapꞌu̱ nda tsa̱ nda hyandi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nu mi thopꞌu̱ ar Hesu habu̱ mi to̱ge, bi no̱tsꞌe ne bi ꞌñembabi: —Sakeo, ngutꞌa ba köi, ngetho mahyoni ga oxa ar pania ha ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nöꞌö dama bi göi, ne xa mi johya bi zixa ar Hesu hár ngu. ");
INSERT INTO otqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nuya jöꞌi mi hyandi xa bi nthente, mi nöñꞌu̱ ar Hesu xki yu̱tꞌa hár ngu nꞌar tsꞌokte. ");
INSERT INTO otqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nunar Sakeo bi mꞌa̱i, ne bi ꞌñemba ar Hesu: —Ma tsi Hmuꞌi, ma ga hemba ya hyoya made nuya ñho di pe̱tsꞌi, ha nuꞌmu̱ togo xta pëpa nꞌa, ga koꞌspa goho. ");
INSERT INTO otqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ha nu ar Hesu bi ꞌñenö: —Ár pania xi zo̱ ar mpo̱ho̱ har ngunu̱, ngetho nunu̱ ár ma̱ngaꞌbe̱to ar Abra nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nöꞌö Togo bi Njöꞌi, ba e da hyoni ne da po̱ho̱ nuꞌu̱ togo xi mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ya jöꞌi mi o̱xa nöꞌö mi mönga ar Hesu. Ne nöꞌö bi xipa nꞌar ꞌbede, ngetho ꞌbu̱tho nda zo̱nga Herusalen, ne nuya jöꞌi mi hu yá mu̱i ma nda nheki nꞌagitho ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jange ar Hesu bi ꞌñembabi: —Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ már mëni nꞌar ndö. Bi ma ha nꞌar ha̱i yapꞌu̱, ma nda tꞌetsꞌi ngu ar ndö hár ha̱ise̱, ne mꞌe̱fa nda pengi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ha mꞌe̱tꞌo, bi zohna ꞌre̱tꞌa yá ꞌbe̱go, bi umba nꞌar bojö. ꞌRangutho bi umbabi, ne bi ꞌñembabiꞌu̱: Jafu̱ da mpe̱ da xu nöꞌö ar bojö xta ꞌraꞌahu̱, ne gi ꞌraju̱ xka pengi. Ne bi gu̱ ar ꞌñu bi maꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ha nuya mengunu̱ xa mi u̱tsa, ne bi me̱hna ꞌra togo nda de̱ni, ma nda mö njawa: Hindi nehe ngu ma ndöhenu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mödi njapꞌu̱, bi tꞌetsꞌi ngu ar ndö. Ne mba penga ár ha̱i, bi zohna gatho nuꞌu̱ xki umbabi ar bojö, mi ne nda bödi hangu xki dö nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mꞌe̱tꞌo ba e nꞌa, ne bi ꞌñenö: Ma ndöꞌi, nuri bojö ga ꞌrakagi, da japi bi xu ma ꞌre̱tꞌa ár nze̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Xa bi njohya ar ndö, ne bi ꞌñembabi: Di za̱ nöꞌö xka pe̱fi. Xka japi bi xu nöꞌö tsi tu̱i da ꞌraꞌi. Ma ga exꞌaꞌi gi ndö ꞌre̱tꞌa ya hnini. ");
INSERT INTO otqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ba epꞌu̱ manꞌar ꞌbe̱go, ne bi ꞌñembabi: Ma ndöꞌi, nuri bojö ga ꞌrakagi, da japi bi döhö ma ku̱tꞌa ár nze̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nuꞌmú̱ ar ndö bi ꞌñembabi: Nuꞌge nꞌehe, ma ga exꞌaꞌi gi ndö ku̱tꞌa ya hnini. ");
INSERT INTO otqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ne bi zo̱ manꞌa nuꞌu̱ ya ꞌre̱tꞌa xki tꞌumbabi ar bojö, ne bi ꞌñenö: Ma ndöꞌi, xta höñꞌa ri bojö, ho̱ntꞌa da pa̱xa ha nꞌar nthuꞌmxi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Da tsu da mbo̱ ri kwe̱, ngetho hingi pe̱ꞌsa ar hwëki. Gi hönga nöꞌö hingi töhö, ne gi xofo nöꞌö hingi potꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nuꞌmú̱ ar ndö bi ꞌñembabi: Tsꞌoꞌbe̱go, nuna xka mö, bi tsꞌokꞌaꞌi. Nuꞌmu̱ ngi pödi hiñꞌotho ma nhwëki, di hönga nöꞌö hinxta töhö, ne di xo nöꞌö hinxta potꞌi, ");
INSERT INTO otqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","yoꞌö hinga tsokwa ma bojö ya njwatbojö ꞌmu̱, ne núꞌmu̱ nga pengi, nda njoska ma bojö ne yá nthöhö. ");
INSERT INTO otqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nepꞌu̱ bi ꞌñembabi nu maꞌra yá ꞌbe̱go mi ꞌbu̱hnu̱: Hñömfu̱ ar bojö, ne umbabihu̱ nöꞌö togo bi dö ma ꞌre̱tꞌa. ");
INSERT INTO otqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nuꞌmú̱ nuꞌu̱ bi ꞌñembabi: Ma tsi ndöꞌahe, nöꞌö ya pe̱ꞌsa ꞌre̱tꞌa ya bojö. ");
INSERT INTO otqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ha nunar ndö bi dödi ne bi ꞌñenö: Di xiꞌahu̱, nuꞌu̱ togo pe̱ꞌsa nze̱ye̱, da tꞌumbabi. Ha nuꞌu̱ togo pe̱ꞌsa txꞌu̱tho, da thömbabi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ha nuya ma ñꞌu̱ni himi ne nda nugagi ngu yá ndöꞌu̱, ba tsihu̱wa ga handi gi hyohu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nu mi wadi bi mönga njapꞌu̱, bi gu̱ ar ꞌñu mi ꞌbe̱tꞌo ndi bo̱xa Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Núꞌmu̱ mi zo̱nga getꞌu̱ ar hnini Betfage ne ar hnini Betania ku̱xa har tꞌo̱ho̱ Njömdo̱ni, bi me̱hna yoho yá ma̱xte, ");
INSERT INTO otqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ne bi ꞌñembabi: —Di möhu̱ har tꞌu̱lo hnini gi hanthu̱ ꞌbu̱hnu̱, ne nu xki tso̱ñhu̱, ma gi tiñhu̱ nꞌar tsi nꞌo̱ge di thötnu̱, hinto xi nto̱ge. Gi xothu̱ ne gi tsihu̱ injawa. ");
INSERT INTO otqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nuꞌmu̱ togo da ꞌya̱ñꞌahu̱ yoꞌö gi xothu̱, gi ꞌñembabihu̱: Ar tsi Hmu honi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nuꞌmú̱ nuya yoho yá ma̱xte bi ma ne bi dini ngu xki xipabiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ka mi xotꞌa ar nꞌo̱ge, ba epꞌu̱ nuꞌu̱ togo yá me̱ti, ne bi ꞌñembabiꞌu̱: —Yoꞌö gi xothu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nuyu̱ bi dödi ne bi ꞌñembabi: —Ar tsi Hmu honi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne ba tsimpabi ar Hesu, bi göꞌspa yá pa̱tꞌi, ne bi nto̱ge. ");
INSERT INTO otqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Xo̱ge har ꞌñu habu̱ mi thogi, ya jöꞌi mi xiꞌmbabi yá pa̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ne nu mi dontsꞌa har tꞌo̱ho̱ Njömdo̱ni nda göi, gatho nuꞌu̱ mi te̱ni bi ndu̱i bi mafi mi johyaꞌu̱. Ne mi nsunda Jö mi handa gatho nöꞌö xki ꞌyo̱tꞌa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ne mi eñꞌu̱: —Njöpa ar Ndö xpa e po̱ta Jö. Xa enda ár mꞌu̱i Jö, ne xa nsunda núnu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nuꞌmú̱ nuya de̱ngaꞌbe̱pate mi panu̱ nꞌehe, bi ꞌñembabi ar Hesu: —Utate, hñökwabi nuyu̱ te̱ñꞌaꞌi hinda mafi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nuꞌmú̱ ar Hesu bi dötwabi: —Di xiꞌahu̱, nuꞌmu̱ da ñheyu̱, ya do da mafi. ");
INSERT INTO otqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nu mi zo̱nga getꞌu̱ ar hnini Herusalen, mi hyandi, xa bi hwëki ne bi nzoni. ");
INSERT INTO otqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ne bi ꞌñenö: —Nuꞌmu̱ xi zohmö ri mu̱ihu̱ togo tsa̱ da ꞌraꞌahu̱ ar hogamꞌu̱i. Nöꞌö bi zo̱ho̱ ngi pöhmöhu̱, ne hinxi za̱ xka hyanthu̱, ngetho xi njotꞌa ri da̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ma da zo̱ ya pa ñꞌu̱tho, ngetho ri ñꞌu̱nihu̱ ma da ehe, xa da goꞌathohu̱ gatho ar nthetꞌi, ne hinda tsa̱ gi po̱ñhu̱, xa ma da tsisꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma da thextꞌa ri jödohu̱, hinda go nꞌar do mañör midowi. Ma da thoꞌa gatho ri jöꞌihu̱ ꞌbu̱ har hnini, ngetho hinga ne ga hñöñhu̱ ar mpo̱ho̱ xpa pe̱ñꞌahu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nepꞌu̱ ar Hesu bi yu̱tꞌa hár thi ar dönganijö, ne bi ndu̱i bi ꞌye̱nga gatho nuꞌu̱ mi mpa̱ ne mi nta̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne bi ꞌñembabi: —Enga hár Tꞌofo Jö: Ma ngu, ar ngu mhatꞌajö. Ha nuꞌahu̱ xka jafu̱ ngu nꞌar oki habu̱ ñꞌönga ya bë. ");
INSERT INTO otqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hyaxꞌmu̱ ar Hesu mi uta ya jöꞌi har nijö. Ha nuya ndömöjö, nuya bötꞌofo, ne ya ndöxodyo, mi honi hanja nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ha himi tini handa japi, ngetho gatho ya jöꞌi xa mi o̱xa nöꞌö mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nꞌar pa ar Hesu mi ꞌbu̱ har dönganijö mi uta ya jöꞌi, ne mi xipa ar hoga mhö. Nꞌa mbi zo̱ta ya ndömöjö, ya bötꞌofo, ne ya dönziandö. ");
INSERT INTO otqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ne bi ꞌñembabiꞌu̱: —Di ne gi xije, togo xpa pe̱ñꞌaꞌi gi ꞌyo̱tꞌa nuya te gi pe̱fi, ne togo xi ꞌraꞌa ar tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ar Hesu bi dödi ne bi ꞌñembabi: —Nuga ma ga a̱ñꞌahu̱ nꞌar ntꞌa̱ni nꞌehe. Di ne gi thöhu̱: ");
INSERT INTO otqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Togo xki me̱hna ar Xuwa mi xixthe. Hage Jö, wa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nuꞌmú̱ nuꞌu̱ bi ndu̱i bi ñꞌa̱ni nꞌa ngu nꞌa, ne mi eñꞌu̱: —Te ga thöhu̱pya. Nuꞌmu̱ ga emfu̱ Jö ba pe̱hni, ma da ꞌñengagihu̱: Yoꞌö hinga jamfihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ha nuꞌmu̱ ga emfu̱ ba pe̱hna ya jöꞌi, da mbo̱ yá kwe̱yu̱, ne da hyoju̱ nkꞌahni, ngetho beñꞌu̱ ar Xuwa xi me̱hna Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nuꞌu̱ bi dödi himi pödi togo xki me̱hni. ");
INSERT INTO otqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jange ar Hesu bi ꞌñembabiꞌu̱: —Njapꞌu̱ nuga, hinga xiꞌahu̱ nꞌehe togo xi ꞌraka ar tsꞌe̱di ga o̱tꞌa nöꞌö di pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nepꞌu̱ ar Hesu bi du̱ꞌmi bi xipa ya jöꞌi nꞌar ꞌbede, ne bi ꞌñembabi: —Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ bi ꞌñetꞌa nꞌar hwöhiꞌobxi. Bi umba ñhandi ꞌra ya jöꞌi, ne bi ma yapꞌu̱ nze̱ye̱ ya pa. ");
INSERT INTO otqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nu mi zo̱ ar sofo, bi me̱hna nꞌár ꞌbe̱go ma nda nu ya ñhandi, ne nda ꞌya̱pa nöꞌö ndi ꞌñepabiꞌö. Ha nuya ñhandi bi gu̱ ar ꞌbe̱go bi me̱i, ne bi kotsꞌi, ho̱nse̱ yá ꞌye̱ bi hñötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ha nöꞌö togo már me̱ti ar hwöhi, bi mengi bi me̱hna manꞌar ꞌbe̱go. Nöꞌö nꞌehe bi mfe̱i, bi tsꞌani, ne bi njui hinte bi tꞌe̱ntꞌwa hár ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nepꞌu̱ bi me̱hna manꞌa. Ha nuya ñhandi bi gu̱ bi fe̱nza, ne xa bi ze̱ni, ne bi gui bi ma. ");
INSERT INTO otqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nepꞌu̱ nöꞌö togo már me̱ti ar hwöhi bi bense̱ hár mfeni, ne bi ꞌñenö: Xipya, te ga pe̱pya. Ma ga pe̱hna ma hmöka tꞌu̱. Xömhö xta hyantꞌu̱, da numansu. ");
INSERT INTO otqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ha nuya tsꞌoñhandi, mi hyandi bi zo̱ ár tꞌu̱ nöꞌö togo már me̱ti ar hwöhi, bi ꞌñeñꞌu̱: Gehnu̱ togo ma da gohwi yá ha̱i ár dada. Ma ga hohu̱ ne ga tsömfu̱ yá ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jange nuꞌu̱ bi gu̱mpa ár tꞌu̱, bi gu̱ka har hwöhi, ne bi hyo. Nuꞌmú̱ ar Hesu bi ꞌya̱mbabi ya jöꞌi, ne bi ꞌñembi: —Xi nöꞌö togo már me̱ti ar hwöhi, tema gi beñhu̱ da japa nuya tsꞌoñhandi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ma da e da hyo gathoꞌu̱, ne da umba ár hwöhi maꞌra ya ñhandi. Nu mi ꞌyo̱ njapꞌu̱ ya jöꞌi, bi ꞌñeñꞌu̱: —Hinda ne Jö ga njahu̱pꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nuꞌmú̱ ar Hesu bi hyantꞌu̱, ne bi ꞌñembabi: —Tema di bo̱nga nöꞌö huxa hár Tꞌofo Jö, habu̱ enö njawa: Nöꞌö ar do bi ꞌye̱mpꞌu̱hmö ya guxjödo, nupya gehnu̱ ar mu̱dido xi njuꞌspa ár nijö Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nöꞌö togo da nto̱xkwi nöꞌö ar doꞌö, da ꞌwaka yá ndoꞌyo. Ha nöꞌö togo da ze̱ꞌmi, da ku̱ntꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ya ndömöjö ne ya bötꞌofo xa mi nehmö geꞌmu̱ nda gu̱ ar Hesu, ngetho bi tso̱tꞌwa yá mu̱i nunar ꞌbede xki ꞌye̱mbabiꞌu̱. Mödi mi tsu nda mbo̱ yá kwe̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jange bi me̱hna ꞌra ya ꞌñöxte nuꞌu̱ mi o̱tꞌa ngu ya hogajöꞌi, xömhö nda ꞌyo̱ ar Hesu nda ñömañꞌu̱, ne nda dini te nda hyo̱tsꞌe, ne nda ꞌye̱ntꞌwa ár ꞌye̱ ar tsꞌu̱tꞌwi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nuya ꞌñöxteyu̱ bi ꞌyo̱tꞌwa nꞌar ntꞌa̱ni, ne bi ꞌñembabi: —Ma tsi Utateꞌihe, di pöhe gi mö ne gi uta nöꞌö xiñho, ne hingi hwahna togo gi o̱tꞌwa ar ñho, ngetho gi utkagihe ár ꞌñu Jö majöni. ");
INSERT INTO otqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Di ne gi xikagihe, hage xiñho ga juthe ar bojö jotꞌa ar Sesar, wa hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nunar Hesu bi bötwatho yá tsꞌomfeniꞌu̱, ne bi ꞌñembabi: —Yoꞌö gi ne gi hya̱ju̱. ");
INSERT INTO otqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Utju̱ nꞌar bojö. Togo ár me̱ti ar hmi huxkwa ne nöꞌö te mö. Bi döꞌu̱ ne bi ꞌñembabi: —Ár hmi ar ndö Sesar. ");
INSERT INTO otqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Umfu̱ ar Sesar nöꞌö ár me̱tiꞌö, ne umfu̱ Jö nöꞌö ár me̱tiꞌö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ne hinte bi za̱ bi dimpꞌu̱ te nda hyo̱tsꞌe nöꞌö mi möñꞌö ha yá nthandi ya jöꞌi. Go bi ꞌyo̱se̱ꞌu̱ nöꞌö bi dödi, ne hinte bi za̱ te bi möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mꞌe̱fa mi zo̱ ꞌra ya de̱ngamöjö nuꞌu̱ hingi ñꞌemu̱i da mengi da nte nuꞌu̱ xi du. Ne bi ꞌya̱mbabiꞌu̱, ");
INSERT INTO otqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bi ꞌñenö: —Utate, ar Moise bi zogagihu̱ har tꞌofo, nuꞌmu̱ nꞌar ñꞌo̱ho̱ da du ne da zopꞌu̱ ár ꞌbe̱hñö hinte bi dinga ar bötsi, ár jödöpꞌu̱ꞌö da nthötwi ar ꞌranxu, ne da gu̱ꞌspa ár thuhu ár jödö manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gi nuhmö, mi ꞌbu̱ yoto ya ñꞌo̱ho̱ mi njödö. Nunar ꞌbe̱tꞌo bi nthöti, ne bi du hinte bi zo ar bötsi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ne nunár jödö mi nto̱ngwi bi mengi bi nthötwi ar ꞌranxu. Bi duꞌö nꞌehe, ne hinte bi zokwa ar bötsi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Bi nthötwi ár hñu nꞌehe, ne bi njapꞌu̱ gatho yoto, hinte bi zokwa ar bötsi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ar ngötsꞌi bi du ar ꞌbe̱hñö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jange xi xta mengi da nte, togo ár ꞌbe̱hñönu̱ mhetsꞌi ꞌmu̱. Ngetho gatho yoto ya jödö bi nthötwi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nepꞌu̱ ar Hesu bi dödi ne bi ꞌñembabi: —Nuwa har ximha̱i ya jöꞌi nthöti ne ntꞌa̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ha nu xta mengi da nteꞌu̱, ne xta mꞌu̱hnu̱ mhetsꞌi nuꞌu̱ di ꞌñepi da mꞌu̱hnu̱, hinda ma da tꞌa̱di, ne hinda ma da nthöti. ");
INSERT INTO otqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ngetho hinda tsa̱ da mengi da du. Ma da ñhe̱hwi ya e̱nxe̱, ne yá bötsi Jö gatho nuꞌu̱ xi mengi xi nte. ");
INSERT INTO otqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ha nuꞌmu̱ gi ne gi pöhu̱ ar menga nte, gese̱ ar Moise bi udi har Tꞌofo, ma da mengi da nte nuꞌu̱ xi du. Nu habu̱ no̱nga ar ꞌminza mi zo̱, ka bi no̱mpꞌu̱tho: Gehnu̱ ár Jö ar Abra, ar Isa, ne ar Hakob. ");
INSERT INTO otqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ngetho Jö, ár Jö nuꞌu̱ te, hinge nuꞌu̱ xi du. Hár nthandiꞌö, gatho ya jöꞌi ja yá te. ");
INSERT INTO otqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nepꞌu̱ ꞌra ya bötꞌofo bi ꞌñembabi: —Utate, majöni nöꞌö xka mö. ");
INSERT INTO otqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne bi ntsa̱ya̱ hinte bi ne te bi ꞌya̱mbabi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ar Hesu bi ꞌñembabiꞌu̱: —Hanja tꞌenö ar Kristo ár tꞌu̱ ar Dabi. ");
INSERT INTO otqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ne ar Dabi ense̱ njawa hár Tꞌofo Jö ha ya Dönga Nsa̱di: Jö ar Dada bi ꞌñemba ma tsi Hmu: Hñu ha ma ñꞌe̱i ga huxkwi, ");
INSERT INTO otqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","to̱ꞌmi ga tsiñꞌa nuya ri ñꞌu̱ni ga tse̱pꞌa ha ri wa. ");
INSERT INTO otqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nuꞌmu̱ ar Dabi embabi ár Hmu, hanja ár tꞌu̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nu mi o̱xta gatho ya jöꞌi, ar Hesu bi xipa yá ma̱xte njawa: ");
INSERT INTO otqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Jamasuhu̱ hinda kaꞌahu̱ ya bötꞌofo. Xa ne da ñꞌo ko̱ yá he xi ma ju̱tꞌatho, honi da tꞌeꞌspa yá nsu. Ne xa ne da ze̱ngwabi ya jöꞌi di ꞌbe̱nga ntꞌekꞌei núꞌmu̱ ꞌyo ha ya ta̱i. Ne xa ne da hñuxa ha ya ꞌbe̱tꞌo nthutsꞌi ha ya nijö ne ha ya ñhuni. ");
INSERT INTO otqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ne tekwa yá ngu ya tsi ꞌranxu, ne xa o̱tꞌa ꞌra ya nsa̱di ra ma, honi da goꞌmahmö. Nuyu̱ xa ma da hñönga nꞌa ra döta mfe̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ar Hesu mi handa gatho nuꞌu̱ hinte mi kꞌatꞌi, mi u̱tꞌa yá bojö hár ntꞌu̱tmꞌo̱ñho̱ ar nijö. ");
INSERT INTO otqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne bi hyanda nꞌar tsi ꞌranxu, xa mi hyoya, bi ꞌye̱ntnu̱ yoho ya tsi bojö. ");
INSERT INTO otqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ne ar Hesu bi ꞌñenö: —Xa majöni di xiꞌahu̱, nunar tsi hyoya ꞌranxu xi unga nze̱ye̱, töta gatho nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ngetho gatho nu maꞌra xi ꞌyu̱tꞌa hár ntꞌu̱tmꞌo̱ñho̱ Jö nöꞌö pongwathobi. Ha nunu̱, mödi mi hyoya, bi unga gatho nöꞌö mi pe̱ꞌshmö nda zi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ꞌRa nuꞌu̱ mi ꞌbu̱hnu̱ mi mpede mi no̱ñꞌu̱ ar dönganijö. Mi möñꞌu̱ mi nheki nza̱tho ya hoga do xki thoki, ne xa xki thutnu̱ nuꞌu̱ tema xki tꞌuni ngu ya mꞌo̱ñho̱. Nepꞌu̱ ar Hesu bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Gatho nöꞌö te gi hanthu̱, ma da zo̱ ar pa da thextꞌi, ne hinda ma da go nꞌar do mañö ár midowi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nepꞌu̱ nuyá ma̱xte bi ꞌya̱ni ne bi ꞌñembabi: —Ma tsi Utateꞌihe, hamꞌu̱ da tho nöꞌö xka mö. Tema ntꞌudi ma da nheki ne da födi ꞌba̱pꞌu̱tho da tho gathoyu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nuꞌmú̱ ar Hesu bi ꞌñenö: —Jamasuhu̱, yo ma gi ñhe̱hu̱ togo da kaꞌahu̱. Ngetho ma da epꞌu̱ nze̱ye̱ togo da gu̱mka ma thuhu, ne da ꞌñeñꞌu̱: Nuga go dar Kristo. Ne da ꞌñenö nꞌehe: Xi zo̱ ar pa ma da mhuntsꞌa xo̱ge. Yo ma gi te̱ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ne nu xki ꞌyo̱hu̱ hagatho di ja ya tuhni, ne habu̱ gatho ya jöꞌi di to̱xa ya tsꞌu̱tꞌwi, yo gi ntsuhu̱. Ngetho mꞌe̱tꞌo mahyoni da tho gathoyu̱, mödi hinda dama göxta ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ne bi ꞌñembabi nꞌehe: —Nuya hnini ma da ntunkwi yá mihniniwi, ha nuya ndö da ntunkwi yá mindöwi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne xa ma da nja ya nhwöni di ntsꞌe̱di, ne hagatho xa ma da nja ar thuhu ne ya textehñeni. Ha nu mañö mhetsꞌi, ma da nheki ꞌra ya döta ntꞌudi nuꞌu̱ xa ma da japi da bitꞌa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma da tho gatho nöꞌö di xiꞌahu̱. Ha mꞌe̱tꞌo ma da tꞌu̱tsaꞌihu̱, ma da tsꞌixꞌahu̱ da mꞌa̱pꞌahu̱ ha yá nijö, ne da joꞌahu̱ har fa̱di. Ma da tsꞌixꞌahu̱ ha ya ndö ne ha ya tsꞌu̱tꞌwi ngetho gi te̱ngagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ne ka da tsa̱ gi da̱hu̱nu̱ majöni xka pökagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Umba ri mu̱ihu̱ hingi beñhu̱ hanja gi thöthwu̱ ya tsꞌu̱tꞌwi gi ñönga ri tehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ngetho nuga go ma ga ꞌraꞌahu̱ nöꞌö tema gi möñhu̱ ne ar mfödi. Njapꞌu̱ nuya ri ñꞌu̱nihu̱ hinda za̱ te da dötꞌahu̱, ne hinda za̱ da döꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nuri dadase̱hu̱, ri kuhu̱, ri mënihu̱, ne ri mpöhu̱, go ma da da̱ꞌahu̱, ne ꞌra ma da thökꞌa ri tehu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ne gatho ya jöꞌi ma da u̱tsaꞌihu̱ ngetho gi jamfigihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mödi njapꞌu̱, hinda ma da mꞌe̱ nꞌase̱ ri xtöhu̱, gatho da gotho. ");
INSERT INTO otqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ne nuꞌmu̱ gi tse̱thu̱ gatho nöꞌö da tꞌo̱tꞌahu̱, ma gi tsu̱hu̱ ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nu xki hyanthu̱ ár nthetꞌi ar hnini Herusalen di ñuxa ya ndogu, pöhu̱, bi zo̱ ar pa da nhwati. ");
INSERT INTO otqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Gatho nuꞌu̱ di ꞌbu̱ har ha̱i Nhudea, dá nixtꞌi ma da ñꞌönga ha ya tꞌo̱ho̱. Nuꞌu̱ togo di ꞌbu̱ mbo har hnini Herusalen, dama da bo̱ni. Ha nuꞌu̱ togo di ꞌyo har ꞌbatha, yo ma da mengi da yu̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngetho nuya paꞌu̱ ma da nheki ár kwe̱ Jö, ne ma da tho gatho ngu mönga hár Tꞌofo Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Hwëkate nuꞌu̱ ya ꞌbe̱hñö di ñꞌu̱, ne nuꞌu̱ di tsu̱ta yá bötsi nuya paꞌu̱. Ngetho xa ma da nja nꞌar döta u̱gi ha nunar ha̱inu̱, ne ma da thiꞌsa ár kwe̱ Jö ha nunar hnininu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ngetho ma da tho ndo̱jwai ꞌra, ha maꞌra ma da tsꞌixa yapꞌu̱ da nxanga ha ya ha̱i. Ne nuya nzo̱ho̱ jöꞌi ma da ndö har hnini Herusalen. Ma da njapꞌu̱ gatho ya pa da umba ar se̱ki Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nuya paꞌu̱ ma da nheki ya ntꞌudi har hyadi, har zönö ne ha ya tso̱. Ne gatho ya jöꞌi xo̱ge har ximha̱i xa di ntsu, ne hindi pödi te da beni nu xta hida ar döta ñho̱nthe xa di mpu̱ntsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ha nuya jöꞌi ma da kꞌatꞌa yá tsꞌe̱di xa di ntsu, ne di ndo̱ꞌmtho te da thokwa har ximha̱i, ngetho nuya tsꞌe̱di janu̱ mhetsꞌi ma da nhwötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ne gatho ma da hyanda Nöꞌö Togo ba e bi Njöꞌi xta pengi, di e har gui di ꞌñu ár döta tsꞌe̱di ne ár döta nsunda. ");
INSERT INTO otqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu xki hyanthu̱ da ndu̱i da nheki nöꞌö di xiꞌahu̱, yo gi ntsuhu̱. Ju̱xa ri da̱hu̱ mhetsꞌi, ngetho ꞌba̱pꞌu̱tho da zo̱ togo ma da ñöñꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne bi xipabiꞌu̱ nꞌar ꞌbede, bi ꞌñenö: —Hyanthu̱ ár ꞌba̱i ar iuxi ne maꞌra ya za. ");
INSERT INTO otqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu xta ndu̱i da kꞌontsꞌa yá xi, gi pöhu̱ xi ꞌñepꞌu̱tho ar pahyadi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Njapꞌu̱ nꞌehe, nu xki hyanthu̱ da thogi ngu xta xiꞌahu̱, pöhu̱ xi ꞌñepꞌu̱tho ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Xa majöni di xiꞌahu̱, hinda ma da theta nuya jöꞌi ꞌbu̱ nuya payu̱, ne xi wadi xi tho gatho nuya thogiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mödi da mꞌe̱di mhetsꞌi ne ar ximha̱i, nuya mhö xta mö hinda ma da mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ntsuñhu̱, yo gi ñhe̱hu̱ da me ri mfenihu̱ har tsꞌoꞌyo, har nti, ne ha ya ꞌbe̱fi jawa har ximha̱i, yo ma da zu̱ꞌahu̱ nunar pa hinge ngi to̱ꞌmhu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ngetho ma da njapꞌu̱ gatho nuꞌu̱ ꞌbu̱ hár nxidi ar ximha̱i, xta da̱ni da zo̱ ar pa, njangu nꞌár xögu ar nthöhi bi thu̱tsꞌi, himi to̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jange ndo̱ꞌmhu̱ hyaxꞌmu̱, ne xa gi ꞌya̱fu̱ Jö da tsa̱ gi kꞌonthu̱ gatho nuya thogi xi ꞌñepꞌu̱, ne njapꞌu̱ da za̱ da nhuꞌahu̱ xiñho hár nthandi Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ar Hesu mi uta ya jöꞌi har dönganijö ꞌbu̱ mpa, ha nuꞌmu̱ xui mi pa har tꞌo̱ho̱ Njömdo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ne gatho ya jöꞌi hyaxꞌmu̱ mi e nꞌitho har dönganijö, mi o̱xa nöꞌö mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ma nda da̱tꞌa ar da̱ngo mbaxjwa núꞌmu̱ mi tsꞌi ar thuhme himi jotsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ya ndömöjö ne ya bötꞌofo mi honga hanja nda hyo ar Hesu, ne himi pödi hanja nda gu̱, ngetho mi tsu ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nepꞌu̱ ar tsꞌondöhi bi yu̱tꞌa hár mfeni ar Huda, nöꞌö mi tꞌembabi ar Iskariote, nꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ne bi ma ba kꞌöꞌsa ya ndömöjö ne yá ndö ya sunijö, ma ba ñöwi hanja nda za̱ nda da̱twa ar Hesu ha yá ꞌye̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nuꞌu̱ xa bi njohya, ne bi nkohi nda umba ar bojö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ha nunar Huda mi honga hanja nda tsa̱ nda da̱twa ar Hesu ha yá ꞌye̱ꞌu̱, ne mi hwahna haꞌmu̱ hindi njoꞌo nze̱ ya jöꞌi habu̱ mi ꞌbu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bi da̱tꞌa ar da̱ngo núꞌmu̱ mi tsꞌi ar thuhme hinxki jotsꞌi, geꞌmu̱ mi mahyoni nda tho ngu nꞌar mꞌo̱ñho̱ ar ndöni mbaxjwa. ");
INSERT INTO otqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nuꞌmú̱ ar Hesu bi me̱hna ar Pedro ne ar Xuwa, ne bi ꞌñembabiꞌu̱: —ꞌBe̱tꞌo di möhu̱ ba hyoju̱ ar tꞌoxi mbaxjwa ga tsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne nuꞌu̱ bi ñꞌa̱ni ne bi ꞌñembabi: —Habu̱ gi ne ga hoje. ");
INSERT INTO otqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ar Hesu bi ꞌñembabiꞌu̱: —Núꞌmu̱ xki ku̱thu̱ har hnini, gi nthe̱wihu̱nu̱ nꞌar ñꞌo̱ho̱ di muxa nꞌar xo̱ni ar dehe. Te̱ñhu̱ habu̱ di yu̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ne gi ꞌñembabihu̱ nöꞌö togo ár me̱ti ar ngu: Ar Utate ba pe̱hna ar nze̱ngwa ga eñꞌahe njawa: Habu̱ ꞌbu̱ ar ngu di hoñhe ga tsiꞌbe ar tꞌoxi mbaxjwa ma ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ne nöꞌö ma da utꞌahu̱ nꞌar döta ngu di to̱ mañö, xi thoki xiñho, ne ka gi hoju̱nu̱ ar tꞌoxi mbaxjwa. ");
INSERT INTO otqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mi maꞌu̱, bi thogi gatho ngu xki xipa ar Hesu. Ne ka bi hyoknu̱ ar tꞌoxi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ne nu mi hñuꞌu̱ nda ñuni, ar Hesu bi hñuhwi yá ma̱xte har mexa. ");
INSERT INTO otqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne bi ꞌñembabiꞌu̱: —Hangu xta to̱ꞌmi ga tsiwihu̱ mahye̱gi nunar tꞌoxinu̱ mbaxjwa mꞌe̱tꞌo, ne ka ga tho ar thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngetho di xiꞌahu̱, xta wadi da tho xo̱ge nöꞌö tema mi ne nda bo̱ni, ma ga pengi ga tsi manꞌagi hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nepꞌu̱ bi gu̱ nꞌar tꞌe̱ni, bi umba njamödi Jö, ne bi ꞌñembabiꞌu̱: —Hñöñhu̱, mfa̱xu̱ tsihu̱ nꞌar tsi ntsiki nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngetho di xiꞌahu̱, hinga pengi ga tsipa ár tꞌafi ar ꞌba̱iꞌobxi nuya payu̱. Ma ga to̱ꞌmi ga tsi manꞌagi xta e ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mꞌe̱fa bi gu̱ nꞌar thuhme, bi umba njamödi Jö, bi hekwabiꞌu̱ ne bi ꞌñembabi: —Gehnu̱ ma ndoꞌyo ma ga uni di hompꞌa ri ñhohu̱. ꞌYo̱thu̱ njanu̱ gi bengagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mi wadi bi ntꞌoxi, bi japꞌu̱tho bi gu̱ ar tꞌe̱ni, ne bi ꞌñembabiꞌu̱: —Nunar tꞌafiꞌobxinu̱, po̱ntho nꞌar ntꞌudi no̱nga ar ꞌraꞌyo nkohi, ma da gohi xta nhöꞌma ma ji, di hompꞌa ri ñhohu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ha nꞌa gi huhu̱wa har mexa, ma gi da̱gagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Majöni Nöꞌö Togo ba e bi Njöꞌi, ꞌba̱ ar ꞌñu da tho gatho ngu xi thuꞌspabi, ha hwëkate nöꞌö togo ma da da̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nepꞌu̱ nuꞌu̱ yá ma̱xte bi ndu̱i bi ñꞌa̱nga nꞌa ngu nꞌa togo nda ꞌyo̱tꞌa nunar tsꞌokinu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nuyá ma̱xte mi ñꞌa̱ni nꞌa ngu nꞌa, mi ne nda böꞌu̱ togo mi töte ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nunar Hesu bi ꞌñembabiꞌu̱: —Ya ndö tsixa ya hnini meꞌma nu maꞌra, ne nuꞌu̱ pe̱ꞌsa yá nsu nsipabi o̱tꞌa nꞌar ñho. ");
INSERT INTO otqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ha nuꞌahu̱, yo gi njahu̱pꞌu̱. Nöꞌö togo di pe̱ꞌsa ár nsu, mahyoni da ntsꞌa̱ꞌmi. Ha nöꞌö togo di ja ár tsꞌe̱di, mahyoni da njangu nꞌar ꞌbe̱go. ");
INSERT INTO otqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Togo töte ár nsu. Hage nöꞌö huxa har mexa, wa nöꞌö togo pe̱pabi. Hage hinge nöꞌö huxa har mexa. Hö njapꞌu̱, mödi nuga di ꞌbu̱kwa ngu nꞌa ri ꞌbe̱gogihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ha nuꞌahu̱ hinxka hye̱gase̱gihu̱, xta thohwihu̱ gatho ya thogi xta thoka. ");
INSERT INTO otqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jange nuga ma ga ꞌraꞌahu̱ ri nsuhu̱ ngu ar ndö, ngu ma Dada xi ꞌrakagi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ma ga ꞌbu̱hwihu̱ ha ma tsꞌu̱tꞌwi, ga ñuñhu̱, ga tsithehu̱, ne ga exꞌahu̱nu̱ ha ri thuxandöhu̱, gi hñöꞌsfu̱ majöni nuꞌu̱ ꞌre̱tꞌamayoho yá mꞌu̱i ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ar tsi Hmu Hesu bi ꞌñemba ar Simu Pedro: —Simu, ar tsꞌondöhi xpa a̱di da jaꞌahu̱ ngu ar tꞌe̱i núꞌmu̱ tho̱ke. ");
INSERT INTO otqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ha nuga xta a̱pa Jö ma Dada hinda the ri ñꞌemu̱i. Ne nu xta mengi da xu ri jamfi manꞌagi, fa̱xa nuꞌu̱ maꞌra ri ku da ze̱ta yá ñꞌemu̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ha nu ar Simu bi ꞌñembabi: —Ma tsi Hmuꞌi, nuga di ꞌbu̱i ga te̱ñꞌaꞌi teme gatho gi thogi. Nuꞌmu̱ har fa̱di, ga maga nꞌe. Ha nuꞌmu̱ da thoꞌi, da thogagi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ha nu ar Hesu bi ꞌñembabiꞌö: —Nuga di xiꞌaꞌi Pedro, nuna nxuinu̱, hindi mata ar boxi, ha nuꞌge xka ko̱ngagi hñuꞌgi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ar Hesu bi ꞌya̱mba yá ma̱xte, ne bi ꞌñembabi: —Núꞌmu̱ nda pe̱ñꞌahu̱, hinga hñöxu̱ ar ntꞌu̱tbojö, hinga hñöxu̱ ri ꞌbe̱nihu̱, wa nꞌar mponi ya thiza, hage te ga kꞌathu̱. Nuꞌu̱ bi dödi ne bi ꞌñenö: —Hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nepꞌu̱ nöꞌö bi ꞌñembabi: —Nupya hö di xiꞌahu̱, nuꞌu̱ togo pe̱ꞌsa ar ntꞌu̱tbojö, dá hñötsꞌi, ne dá hyoka ár ꞌbe̱ni. Ha nöꞌö hinte hö ár jwai, dá ma̱ ár pa̱tꞌi da da̱nga nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngetho nuga di xiꞌahu̱, mahyoni ga tho ngu mönga ár Tꞌofo Jö, habu̱ enö: Bi the̱ta ya ꞌyo̱tꞌatsꞌoki. Ngetho gatho nöꞌö xi tꞌotkagi, mahyoni da thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nuꞌmú̱ bi ꞌñeñꞌu̱: —Ma tsi Hmuꞌihe, ꞌbu̱kwa yoho ya jwai. Nöꞌö bi dödi ne bi ꞌñembabiꞌu̱: —Di za̱, ho̱nse̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nepꞌu̱ ar Hesu bi bo̱ni bi ma har tꞌo̱ho̱ Njömdo̱ni ngu xki nzöi. Ne nuyá ma̱xte bi de̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ha nu mi zo̱ñꞌu̱, bi ꞌñenö: —ꞌYa̱fu̱ Jö gi tse̱thu̱ ya thogi xta ꞌñepꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nepꞌu̱ bi ꞌwege ngu ar yapꞌu̱ tso̱nga nꞌar nkꞌahni, ne bi nda̱ndihmö ba a̱pa Jö ár Dada. ");
INSERT INTO otqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ne mi enö: —Ma Dadaꞌi, nuꞌmu̱ gi nehmö, da thota nunar tꞌe̱ni xi ꞌñepꞌu̱ ne hinda zu̱kagi. Mödi hindi ne gi ꞌyo̱tꞌa ngu di nega, ꞌyo̱tꞌa ngu gi nege. ");
INSERT INTO otqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ne núnu̱ habu̱ mi a̱pa Jö, bi zo̱hnu̱ nꞌar e̱nxe̱ xki ꞌñe mhetsꞌi mi umba ar tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ha nu ar Hesu xa mi döta ár dumu̱i, xa mi e̱ntꞌa ar tsꞌe̱di mi a̱pa Jö. Xa mi xa̱nthe, ne nunár xa̱nthe mi tu̱ har ha̱i, mi ñhe̱hwi nꞌár döta tu̱i ar ji. ");
INSERT INTO otqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nu mi wadi bi ꞌya̱pa Jö, ba penga habu̱ xki zo yá ma̱xte, ne bi diñꞌu̱ mi öhö, ngetho xki wentꞌi mi tu yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ne bi ꞌñembabiꞌu̱: —Hanja xka öhu̱. Nanju̱ ne ꞌya̱fu̱ Jö gi tse̱thu̱ ya thogi xta ꞌñepꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Himi jwatho nda ñö ar Hesu, nꞌa mbi zo̱ta nze̱ye̱ ya jöꞌi. Ne ar Huda, nꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte, mi ꞌbe̱tꞌo, ne dama bi watꞌi bi zu̱ꞌsa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Har Hesu bi ꞌñembabi: —Huda, hage har ntsu̱tsꞌinu̱ gi da̱ Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nuyá ma̱xte mi ñꞌowi ar Hesu, mi hyandi tema nda thogi, bi ꞌñembabi: —Ma tsi Hmuꞌihe, ha gi ne ga ju̱je ya jwai ga ñöñꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nꞌaꞌu̱ bi kꞌoꞌsa ar jwai, ne bi dakwa ár gu ñꞌe̱i nꞌár ꞌbe̱go ar döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Hye̱hu̱pꞌu̱, yo te gi jafu̱. Ne bi hñuxa ár ꞌye̱ hár gu ar ꞌbe̱go, ne bi o̱thebi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nepꞌu̱ bi ꞌñemba ya ndömöjö, ya ndö sunijö, ne ya dönziandö nuꞌu̱ xki ꞌñe nda zitsꞌi: —Hage dar bëga xka ehu̱ gi mikagihu̱, gi höhu̱ ya za ne ya ndo̱jwai. ");
INSERT INTO otqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hyaxꞌmu̱ ndi ꞌbu̱hwihu̱ har dönganijö, hinte ga jaju̱. Ha nupya hö, ja ri tsꞌe̱dihu̱, ne ja ár tsꞌe̱di ar ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nepꞌu̱ bi nju̱ ar Hesu, ne bi tsꞌixa hár ngu ar döngamöjö. Ha nu ar Pedro mi ꞌbe̱fa yapꞌu̱tho, mi te̱ni. ");
INSERT INTO otqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ne mi zo̱nga hár ngu ar döngamöjö, xki tꞌu nꞌar tsibi har thi, ka mi huhnu̱ ꞌra ya jöꞌi mi mpatꞌi, ne ar Pedro ka bi hñuhwinu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nꞌa mba epꞌu̱tho nꞌar nxutsi mi mꞌe̱go. Nu mi hyanda ar Pedro mi huhnu̱ har tsibi, xa bi kꞌötꞌi, ne bi ꞌñenö: —Nunar ñꞌo̱ho̱nu̱ mi ñꞌowi ar Hesu nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ha nöꞌö bi nko̱ni, ne bi ꞌñenö: —Nönö, hindi pödi togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hingar yaꞌö bi hyanda manꞌar jöꞌi, ne bi ꞌñembabi: —Ha hingo ngi ñꞌowi ar Hesu nꞌehe. Ha nu ar Pedro bi mengi bi nko̱ni, bi ꞌñenö: —Tata, hinge ndi ñꞌoꞌbegaꞌö. ");
INSERT INTO otqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mꞌe̱fa xki tho nꞌa tsi tu̱i, manꞌa bi ꞌñenö: —Majöni nunar ñꞌo̱ho̱nu̱ go mi ñꞌowi ar Hesu, ngetho fötho ar me Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ne ar Pedro bi ꞌñenö: —Tata, hindi pödi teme gi mö. Himi jwata nda mönga njapꞌu̱, nꞌa mbi ma ar boxi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nuꞌmú̱ bi ꞌba̱tꞌa ar tsi Hmu bi hyanda ar Pedro. Ha nu ar Pedro dama bi benga nöꞌö xki xipabi mꞌe̱tꞌo, núꞌmu̱ xki ꞌñembabi: Hindi mata ar boxi, ha nuꞌge ya xka ko̱ngagi hñuꞌgi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jange ar Pedro bi bo̱nga nthi, xa bi hyu̱ ár ñö bi nzoni. ");
INSERT INTO otqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nuya jöꞌi mi su ar Hesu, xa mi o̱tꞌwa ar thede, ne xa mi fe̱i. ");
INSERT INTO otqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bi gu̱ nꞌar dutu bi dutꞌwa yá da̱, mi umba ya mpe̱tgu, ne mi embabiꞌu̱: —Xijexö, togo bi me̱pꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne xa ra ntsꞌotho nöꞌö te mi xipabiꞌu̱, mi tsani. ");
INSERT INTO otqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ár hyaxꞌö bi mhuntsꞌa ya dönziandö, ya ndömöjö, ne ya bötꞌofo, ne bi tsꞌixa ar Hesu habu̱ xki mhuntsꞌu̱. Ka bi tꞌa̱mbabinu̱, ne bi tꞌembabi: ");
INSERT INTO otqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Xije, ha go geꞌe ar Kristo xi ꞌñexa Jö. Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Nuꞌmu̱ ga xiꞌahu̱ go geke, hingi ñꞌemu̱igihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ha nuꞌmu̱ ga o̱tꞌahu̱ ya ntꞌa̱ni, hingi thöhu̱, ne hingi hye̱gagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gi numhöhu̱ nuya pa xi ꞌñepꞌu̱, Nöꞌö Togo ba e bi Njöꞌi ma da hñu hár ñꞌe̱i Jö togo pe̱ꞌsa gatho ar tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nepꞌu̱ gathoꞌu̱ bi ꞌya̱mbabiꞌö, ne bi ꞌñembabi: —Nuꞌmú̱ ha go ár Tꞌu̱ꞌi Jö. Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Hö, njapꞌu̱ ngu xka mönse̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nuꞌmú̱ bi ꞌñeñꞌu̱: —Te ga jafu̱ maꞌra te da hyo̱tsꞌe. Xta o̱se̱hu̱ nöꞌö xi wadi xi mö. ");
INSERT INTO otqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dama bi nanga gatho nuꞌu̱ mi ꞌbu̱ har mhuntsꞌi, bi gu̱ ar Hesu bi ziꞌspa ar Pilato. ");
INSERT INTO otqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne nunu̱ te gatho bi ndu̱i bi hyo̱xꞌu̱, ne bi ꞌñeñꞌu̱: —Xta tiñhe nunar ñꞌo̱ho̱nu̱ mi ꞌyonu̱ mi tsꞌokwa yá mfeni ya jöꞌi, ne mi u̱tꞌi hinda gutꞌa yá njutꞌi a̱ ar ndö Sesar. Ne xi ꞌñense̱ gehnu̱ ar Kristo xi ꞌñexa Jö ngu nꞌar ndö ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jange ar Pilato bi ꞌñembabi: —Ha go geꞌe ár Ndö ya xodyo. Nu ar Hesu bi dödi ne bi ꞌñenö: —Hö, ngu xka mönse̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ha nu ar Pilato bi ꞌñemba ya ndömöjö ne gatho ya jöꞌi: —Hinte ma tsꞌoki di timba nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ha nuꞌu̱ xa himi tsa̱ya̱ mi a̱pabi ne mi eñꞌu̱: —Gehnu̱ xa hagatho ꞌyo, utya jöꞌiwa har ha̱i Nhudea, ba du̱ꞌma har ha̱i Ngalilea, ne xi göꞌskwa Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nu mi ꞌyo̱ ar Pilato mi nho̱nga Ngalilea, bi ñꞌa̱ni hage már me Ngalilea ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jange nu mi bö ar Pilato már mengu habu̱ már ndö ar Erode, dama bi me̱mpabi, ngetho nuya paꞌu̱ xki zo̱ho̱ mi ꞌbu̱hnu̱ Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ar Erode, nu mi hyanda ar Hesu, xa bi njohya. Nze̱ye̱ ya pa mi ne nda hyandi, ngetho xa xki ꞌyo̱de mi nho̱ni. Ne xki do̱ꞌmi nda nu nda ꞌyo̱tꞌa nꞌar ntꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bi ꞌya̱mba nze̱ye̱ ya ntꞌa̱ni, mödi ar Hesu hinte bi dödi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ka mi ꞌbu̱hnu̱ ya ndömöjö ne ya bötꞌofo, xa mi umba yá mu̱i te gatho mi ho̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nepꞌu̱ ar Erode ne yá ndogu mi nuꞌu̱ hinter me̱ꞌö, xa mi o̱tꞌwa ar thede, bi göꞌspa nꞌar hoga he nza̱tho, ne bi mengi bi me̱mpa ar Pilato manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nor paꞌö, ar Pilato ne ar Erode bi ñhogamu̱i, ngetho himi ntsixꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nepꞌu̱ ar Pilato bi zohna ya ndömöjö, nuya tsꞌu̱tꞌwi, ne gatho nu maꞌra ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ne bi ꞌñembabiꞌu̱: —Nuꞌahu̱ xka tsinkagihu̱wa nunar ñꞌo̱ho̱nu̱, gi eñhu̱ u̱tꞌa ya jöꞌi. Nuga xta o̱tꞌwa ya ntꞌa̱ni ha ri nthandihu̱, ne xka ꞌyo̱se̱hu̱ hinte ma tsꞌoki xta timbabi ngu gi ho̱xu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nunar ndö Erode hinxpa timba nꞌar tsꞌoki, jange ba pe̱hna manꞌagi injawa. Pöhu̱ ꞌmu̱, nunu̱ hinte ma tsꞌoki xi ꞌyo̱tꞌe gi ꞌñeñhu̱ di ꞌñepi da tho. ");
INSERT INTO otqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jange nuga, ho̱nse̱ ma ga japi nda nꞌwe̱xtꞌi, ne ga he̱gi da ma. ");
INSERT INTO otqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ar Pilato mi mahyoni nda hye̱ nꞌar ꞌyofa̱di ta̱tꞌa da̱ngo mbaxjwa, ngetho njapꞌu̱ ma yá ntꞌumbiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ha gatho nuꞌu̱ ya jöꞌi mi ꞌbu̱hnu̱, bi ndu̱i bi nꞌamamafi, ne bi ꞌñeñꞌu̱: —Hñöka made nunar ñꞌo̱ho̱nu̱. Hye̱ ar Baraba. ");
INSERT INTO otqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nu ar Baraba xki njotꞌa har fa̱di, ngetho xki gu̱xa ya jöꞌi nda ntunkwi ya ndö har hnini, ne xki ñhote. ");
INSERT INTO otqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ha nunar Pilato mi ne nda hye̱ ar Hesu, jange bi mengi bi zo ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nuyu̱ bi ndu̱i bi nꞌamamafi manꞌagi, mi eñꞌu̱: —Tsu̱ta har pontꞌi, tsu̱ta har pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nu ar Pilato bi hñuꞌgi bi ꞌñembabiꞌu̱: —Te ma tsꞌoki xi ꞌyo̱tnu̱. Nuga hinte ma tsꞌoki di timbabinu̱ di ꞌñepi da tho. Ma ga japi da nꞌwe̱xtꞌi, nepꞌu̱ ga he̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ha nuya jöꞌi xa bi ga̱hni bi mafi, mi a̱di nda tsu̱ta har pontꞌi. Ne nuyá mhafiꞌu̱, ne yá mhafi ya ndömöjö, bi japi nda tꞌumba nöꞌö mi neꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jange ar Pilato bi ꞌye̱ntꞌa ar Hesu nda tꞌo̱tꞌwa nöꞌö mi a̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bi hye̱ nöꞌö ar ñꞌo̱ho̱ xki ꞌya̱ ya jöꞌi, már thuhu Baraba, xki njotꞌa har fa̱di ngetho xki gu̱xa ya jöꞌi nda ntuhni, ne xki ñhote. Ha nu ar Hesu bi nda̱ti nda tho ngu mi beñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mi pa mi tsꞌixa ar Hesu ma nda tsu̱ta har pontꞌi, bi nthe̱wi nꞌar ñꞌo̱ho̱ mar me Sirene, már thuhu ar Simu, xki ꞌñe har ꞌbatha. Bi njapi bi duꞌspa ár pontꞌi, mi ꞌbe̱fa mi te̱nga ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ne mi te̱nga ra nze̱ye̱ ya jöꞌi, ne nze̱ye̱ ya ꞌbe̱hñö mi zontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nunar Hesu bi ñegi bi hyantꞌu̱, ne bi ꞌñembabi: —ꞌBe̱hñöhu̱ gar menguhu̱ Herusalen, yo gi zontkagihu̱, nzoñhu̱se̱hu̱ ne zonthu̱ ri bötsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngetho ma da zo̱ ar pa ma da ꞌñenga ya jöꞌi: Matꞌa Jö nuꞌu̱ togo hinxi dinga ar bötsi, ne hinto xi tede. ");
INSERT INTO otqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nuya paꞌu̱ nuya jöꞌi ma da ꞌñemba ya tꞌo̱ho̱: Tse̱bgagihe. Ha nuya ngwani da ꞌñembabiꞌu̱: Kobgagihe. ");
INSERT INTO otqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xa majöni ma da epꞌu̱ ya thogi, ngetho nuꞌmu̱ hinte nhu ar kꞌaza, teme da do̱ꞌma ar ꞌyonza. ");
INSERT INTO otqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bi tsꞌixkwi ar Hesu ma yoho ya ñꞌo̱ho̱ xki tꞌe̱ntꞌi nda tho nꞌehe, ngetho ma ya ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ha nu mi zo̱nga habu̱ mi tꞌembabi Nñöxhmundoꞌyo, ka bi tsꞌu̱tnu̱ har pontꞌi ar Hesu ne nuꞌu̱ ma yoho ya ñꞌo̱ho̱, nꞌa bi tsꞌu̱ta hár ñꞌe̱i, ha nöꞌö manꞌa hár ngöhö. ");
INSERT INTO otqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nu mi zu̱hnu̱ ar Hesu har pontꞌi, bi ꞌñenö: —Ma Dadaꞌi, pumbabi nöꞌö o̱tka nuya jöꞌiyu̱, ngetho hingi pöhyu̱ nöꞌö te pe̱fi. Ha nuya ndogu mi ꞌbu̱hnu̱, bi ꞌye̱ntsꞌa ar nthöhö togo nda hñöꞌspa yá dutu ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ya jöꞌi mi ꞌba̱hnu̱ mi handi, ya ndöxodyo mi ꞌba̱hnu̱ nꞌehe, xa mi theñꞌu̱ mi enö: —Nunu̱ mi po̱ maꞌra, ha nuꞌmu̱ xa majöni go gehnu̱ ar Kristo xi ꞌñexa Jö, di ne ga hanthu̱ da mpo̱se̱pya xö. ");
INSERT INTO otqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nuya ndogu xa mi theni nꞌehe, bi watꞌi mi umba ar ixkatꞌafi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ne bi ꞌñembabiꞌu̱: —Nuꞌmu̱ xa majöni ár Ndöꞌi ya xodyo, mpo̱se̱ xö. ");
INSERT INTO otqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne xki thutwa nꞌar xithe̱ har pontꞌi mañö hár ñö, mi mö yoꞌö xki tsꞌu̱ti. Xki tꞌotꞌi har griego, har lati, har ebreo, ne mi enö njawa: Go gehnu̱ ár Ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nepꞌu̱ nꞌa nuya ꞌyo̱tꞌatsꞌoki mi zu̱hwinu̱ mahye̱gi, bi ñömañꞌu̱bi, ne bi ꞌñenö: —Nuꞌmu̱ majöni go geꞌe ar Kristo, mpo̱se̱ ne po̱kagihe nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ha nöꞌö manꞌa ar ꞌyo̱tꞌatsꞌoki xki tsꞌu̱ti, mi tsu̱i ne mi embabi: —Ha hingi tsupke Jö, yoꞌö gi mönga njapꞌu̱. ꞌBu̱tho gi tuge nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuju̱ majöni di ꞌñepkagihu̱ nöꞌö di thohu̱, ngetho di juthu̱ ma tsꞌokihu̱ xta o̱thu̱. Ha nunar ñꞌo̱ho̱nu̱ hinte ma tsꞌoki xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nepꞌu̱ bi ꞌñembabi ar Hesu: —Bengagi núꞌmu̱ xki hñuxa ha ri thuxandö. ");
INSERT INTO otqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ar Hesu bi döti ne bi ꞌñembabi: —Nuga di xiꞌaꞌi, ár pania ma ga ꞌbu̱hwinu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ngu made mpa bi ndu̱i bi mꞌe̱xui xo̱ge ar ximha̱i, ne bi göxa ngu hñunde, ");
INSERT INTO otqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ngetho ar hyadi himbi yotꞌi. Ha nu ar döta dutu mi naxa mbo har dönganijö, bi xi madetho. ");
INSERT INTO otqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nepꞌu̱ ar Hesu bi mafi ntsꞌe̱di ne bi ꞌñenö: —Ma Dadaꞌi, di da̱tꞌa ha ri ꞌye̱ ma hñö. Ne mi wadi bi mönga njapꞌu̱, bi du. ");
INSERT INTO otqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nu mi hyanda ar döndogu nöꞌö xki thogi, bi nsunda Jö, ne bi ꞌñenö: —Majöni nunar ñꞌo̱ho̱nu̱ xa mar hogajöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gatho nuꞌu̱ ya jöꞌi xki watꞌi, mi hyanda tema xki thogi, bi du yá mu̱i bi mu̱di bi mfontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ha gatho nuyá mpödi ar Hesu, ne nuya ꞌbe̱hñö xki de̱ni xki ndu̱ har ha̱i Ngalilea, bi gohi tsi yapꞌu̱tho, mi handa gatho nöꞌö te mi thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Huse, már mengu ar hnini Arimatea har ha̱i Nhudea, xa mi o̱tꞌa xiñho ne mar hogajöꞌi. Mi ꞌbu̱ hár mhuntsꞌandö ya xodyo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ha mi to̱ꞌmi nda hyandwa ár tsꞌu̱tꞌwi Jö, ne hinxki ꞌñetꞌa ár xu̱tha nöꞌö mi o̱tꞌa yá mindöwi, ne nöꞌö xki nkoꞌu̱ har mhuntsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ne bi manu̱ ma ba kꞌöꞌsa ar Pilato nda ꞌya̱pa ár ndoꞌyo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ne bi köꞌma har pontꞌi, bi ma̱xa nꞌar dutu, ne ba e̱ntꞌa ha nꞌar ꞌraꞌyo tꞌa̱gi xki nsa̱ꞌma ha nꞌar ndo̱do. Nunar tꞌa̱ginu̱ hinto xki ꞌraꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ha nor paꞌö már pa ar ñhoki, mi thota nde, ꞌbu̱tho nda yu̱tꞌa ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nuya ꞌbe̱hñö xki de̱nga ar Hesu har ha̱i Ngalilea, mi ꞌbe̱fa nda hyanda habu̱ xki tꞌa̱ ar Hesu, ne hanja xki ꞌbe̱kwa ár ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ha nu mi menga habu̱ mi ꞌbu̱ꞌu̱, bi hyoka ꞌra ya hogañu̱ni ne ꞌra ya njotsꞌi nda goꞌspa ár ndoꞌyo ar Hesu. Ne bi ntsa̱ya̱ꞌu̱ ar pa ntsa̱ya̱ ngu mi mönga ar ꞌbe̱pate. ");
INSERT INTO otqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ár hyaxꞌö ra nꞌitho ár mꞌe̱tꞌo mpa ar hñöto, nuya ꞌbe̱hñö bi menga habu̱ xki tꞌa̱ ar Hesu, mi höꞌu̱ nöꞌö ar hogañu̱ni xki hyoki. Ne bi me̱wi maꞌra yá miꞌbe̱hñöwi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mi zo̱ñꞌu̱ har tꞌa̱gi, bi hyandi xki thöka nunar do mi kothmö. ");
INSERT INTO otqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nu mi yu̱tꞌu̱, himbi dimba ár ndoꞌyo ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Himi pödi te nda beñꞌu̱. Nꞌa mbi da̱ñꞌu̱, bi hyandi mi ꞌba̱hnu̱ yoho ya ñꞌo̱ho̱, nuyá he xa mi hyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ha nuya ꞌbe̱hñö bi ntsu bi ntsꞌa̱ꞌmthoꞌu̱, himi ju̱xyá da̱. Ne nuya ñꞌo̱ho̱ bi ꞌñembabiꞌu̱: —Yoꞌö gi hoñhu̱wa har tꞌa̱gi nöꞌö te. ");
INSERT INTO otqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hinjoꞌowa, xi mengi xi nte. Beñhu̱ te bi xiꞌahu̱ núꞌmu̱ ngi ꞌbu̱hu̱ Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mi eñꞌahu̱, Nöꞌö Togo ba e bi Njöꞌi, mi mahyoni nda nda̱twa ha yá ꞌye̱ ya ꞌyo̱tꞌatsꞌoki, ne nda tsꞌu̱ta har pontꞌi. Ne ár hñupa nda mengi nda nte. ");
INSERT INTO otqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nuya ꞌbe̱hñö ka bi beñꞌu̱ ꞌmu̱ nöꞌö teme xki xipa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nu mba penkꞌu̱ har tꞌa̱gi, bi mu̱di bi metwa nuꞌu̱ ꞌre̱tꞌamanꞌa yá ma̱xte ne nu maꞌra mi te̱nga ar Hesu, gatho nöꞌö xki hyantꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Gehyu̱ ya ꞌbe̱hñö togo bi ma ba xipa ya ma̱xte: Ar Maria me Magdala, ar Huana, ar Maria ár nönö ar Hakobo, ne maꞌra ya ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ha nuya ma̱xte himi ñꞌemu̱i, mi beñꞌu̱ xki ꞌbe̱ yá mfeni nuya ꞌbe̱hñöyu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ha nunar Pedro bi nixtꞌi ma ba kꞌöꞌsa ar tꞌa̱gi. Mi zo̱ñꞌö bi hyanda mbo, ne ho̱nse̱ bi hyanda ya dutu xki mꞌa̱xa ar Hesu mi ꞌbo̱mpꞌu̱. Nepꞌu̱ bi menga habu̱ mi ꞌbu̱ꞌu̱, xa mi ꞌyo̱tho, himi pödi te nda beni teme xki thogi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Getꞌö ar paꞌö yoho ya ñꞌo̱ho̱ mi te̱mhö ar Hesu, mi ne ar ꞌñu ndi ma har tꞌu̱lo hnini Emaus, mi pe̱ꞌsa ngu madempa ar ꞌñu nda ñꞌo nda zo̱nga Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mi ꞌyo ar ꞌñu, mi mpeꞌu̱ te gatho xki tho nuya paꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ha núꞌmu̱ mi mpeꞌu̱, gese̱ ar Hesu bi zu̱di, ne bi me̱wi mahye̱gi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mödi mi ñꞌowitho, himi tsa̱ nda bödi togoꞌö, ngetho xki njotꞌa yá da̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ha nu ar Hesu bi ꞌya̱mbabi njawa: —Tema gi ꞌyo ar ꞌñu gi möñhu̱. Hanja xa gi tu ri mu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nꞌa mar thuhu ar Kleofa, bi dödi ne bi ꞌñembabi: —Gatho ya jöꞌi pödi tema xi thohnu̱ Herusalen nuya payu̱. Hanja hinte gi pöke. ");
INSERT INTO otqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nepꞌu̱ ar Hesu bi ꞌñembabi: —Teme xi thogi. Ne nuꞌu̱ bi dödi: —Ha hinxka ꞌyo̱ xi nho̱nga ar Hesu me Nasare, gehnu̱ már mꞌe̱hni Jö. Mi nheki ár tsꞌe̱di ha ya mhö mi mö, ne ha ya ntꞌudi mi o̱tꞌa ha yá nthandi ya jöꞌi ne hár nthandi Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ha nuya ndömöjö, ne nuꞌu̱ maꞌra ma ndöhu̱, bi gu̱ bi tꞌe̱ntꞌi nda tho, ne bi tsꞌu̱ta ha nꞌar pontꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuje ndi beñhe go mi geꞌö nöꞌö ma nda ñönju̱ ya me Israel. Ha nupya ya pe̱ꞌsa hñupa xi du. ");
INSERT INTO otqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hinge ho̱nse̱ꞌö, ꞌra ya ꞌbe̱hñö ma ñꞌowihe, bi ma manxudi ra nꞌitho har tꞌa̱gi. Ne pikagihe, ");
INSERT INTO otqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","enö himbi dimba ár ndoꞌyo ar Hesu. Ne mi eñꞌu̱ nꞌehe, xki hyanda ꞌra ya e̱nxe̱ ngu nꞌar tꞌi. Nuyu̱ bi xipabi ar Hesu xki mengi xki nte. ");
INSERT INTO otqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nepꞌu̱ bi ma ꞌra ma ñꞌowihe, ma ba kꞌöꞌsa ar tꞌa̱gi. Ne eñꞌu̱ bi dinga ngu xki mönga ya ꞌbe̱hñö. Nuyu̱ nꞌehe himbi dimba ár ndoꞌyo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ar Hesu bi ꞌñembabiꞌu̱: —Yoꞌö xa xi me ri ñöhu̱, ne xi ñhembi gi jamfihu̱ nöꞌö xi mönga yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ha hingi pöhu̱ mi mahyoni nda tho njapꞌu̱ ar Kristo, nepꞌu̱ nda mengi nda nte, ne nda hñuxa hár nsunda. ");
INSERT INTO otqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne bi ndu̱i bi ꞌyotꞌwa ar ꞌñu gatho ngu mönga ár Tꞌofo Jö habu̱ no̱ñꞌö. Bi ndu̱ hár tꞌofo ar Moise, ne gatho nöꞌö bi mönga maꞌra yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ha nu mi zo̱nga har hnini habu̱ ndi maꞌu̱, ar Hesu bi ꞌyo̱tꞌe ngu ma nda thotho. ");
INSERT INTO otqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nuyu̱ bi zömi nda ñꞌoxhnu̱, ne bi ꞌñembabi: —Kohi, ngetho bi nde, ne txꞌu̱tho ꞌbe̱di da nxui. Jange ar Hesu bi yu̱tꞌa ha yá nguꞌu̱ nda gohnu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nu mi hñu har mexa nda ntꞌoxi, ar Hesu bi gu̱ ar thuhme, bi umba njamödi Jö, ne bi heke bi umbabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dama bi xo yá da̱ꞌu̱, ne bi böꞌu̱ mar Hesu. Ha nunu̱ bi mꞌe̱tho. ");
INSERT INTO otqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne bi ꞌñense̱ꞌu̱: —Xa majöni ndi tsa̱hu̱ nꞌar johya ha ma mu̱ihu̱ núꞌmu̱ mi utkagihu̱ ár Tꞌofo Jö ndi ꞌyohu̱ har ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nuꞌmú̱ dama bi menkꞌu̱ Herusalen. Ne ka bi dinu̱ nuꞌu̱ ꞌre̱tꞌamanꞌa yá ma̱xte xki mhuntsꞌi, ne maꞌra yá ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ne bi ꞌñeñꞌu̱: —Xa majöni xi mengi xi nte ma tsi Hmuhu̱. Ar Simu xi hyandi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nepꞌu̱ nuya yohoꞌu̱ bi metwabiꞌu̱ nꞌehe gatho nöꞌö xki tho har ꞌñu, ne hanja bi böꞌu̱ mar Hesu núꞌmu̱ mi hyeka ar thuhme. ");
INSERT INTO otqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Himi tsa̱ nda watho nda mönga nöꞌö xki hyantꞌu̱ ne nöꞌö xki thogi, nꞌa mbi nhekitho ar Hesu madeda habu̱ mi ꞌbu̱ꞌu̱, ne bi ꞌñenö: —ꞌBu̱hu̱ ter entho. ");
INSERT INTO otqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ha nuꞌu̱ xa bi ntsu, ne mi beni xki handwa ár pa nꞌar jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ne ar Hesu bi ꞌñembabiꞌu̱: —Hanja gi ntsuhu̱. Yoꞌö gi yomihu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hyandgagihu̱ ma ꞌye̱ ne ma wa, go gekaga. Tha̱ngagihu̱ ne hyandgagihu̱ xiñho, ngetho ár pa nꞌar jöꞌi hinte pe̱ꞌsa ár ngo̱, hingi pe̱ꞌsa ár ndoꞌyo ngu gi hanthu̱ di pe̱ꞌska. ");
INSERT INTO otqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nu mi wadi bi mönga njapꞌu̱, bi utwabi yá ꞌye̱ ne yá wa. ");
INSERT INTO otqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ha himi tsa̱ nda ñꞌemu̱iꞌu̱, ngetho xa mi johya ne mi ꞌyo̱ꞌu̱. Jange himi he̱gi nda bödi ha majöni nöꞌö mi hantꞌu̱. Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Ha gi pe̱ꞌsu̱wa te da tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ne bi tꞌumba nꞌar xe̱ni ar hwö xki nthöxi, ne nꞌa xe̱ni ar tꞌafi sefi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ar Hesu bi hñöni, ne bi za ha yá nthandiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nepꞌu̱ bi ꞌñembabi: —Xta thogi nöꞌö da xiꞌahu̱ núꞌmu̱ ndi ꞌbu̱hwithohu̱. Ngetho mi mahyoni nda tho gatho nöꞌö xi tꞌotka hár tꞌofo ar Moise, ne nöꞌö xi ꞌyotka maꞌra yá mꞌe̱hni Jö, ne nöꞌö mönga ha ya Dönga Nsa̱di. ");
INSERT INTO otqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nepꞌu̱ nöꞌö bi xokwa yá da̱ nda zo yá mfeni nöꞌö mönga hár Tꞌofo Jö. ");
INSERT INTO otqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne bi ꞌñembabi: —Njapꞌu̱ xi ntꞌotꞌi, ar Kristo mi mahyoni nda du, ne ár hñupa nda mengi nda nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ne bi ꞌñenö nꞌehe, ma da nju̱mpa ár tsꞌe̱di ár thuhuꞌö, da nho̱nga xo̱ge ár nxidi ar ximha̱i, da ndu̱ꞌmnu̱ Herusalen. Da nsipabi ya jöꞌi da ꞌyo̱tꞌwa yá ntso̱ꞌmi ne da mpumba yá tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ne bi ꞌñembabi nꞌehe: —Nuꞌahu̱ ma gi da̱hu̱ majöni nöꞌö xka hyanthu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ne nuga ma ga pe̱ñꞌahu̱ nöꞌö xi ñötꞌahu̱ ma Dada. Jange ka gi kohu̱wa Herusalen, to̱ꞌmhu̱ mꞌe̱tꞌo gi hñöñhu̱ ar tsꞌe̱di di ꞌñe mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nepꞌu̱ ar Hesu bi zixa yá ma̱xte getꞌu̱ har tꞌu̱lo hnini Betania. Ne nunu̱ bi gu̱xa yá ꞌye̱ bi jöpabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ne núꞌmu̱ mi jöpi, bi ñꞌo bi mꞌe̱di bi tsꞌixa mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nuyá ma̱xte mi wadi bi nsundabi bi menkꞌu̱ Herusalen, xa mi pe̱sꞌu̱ nꞌar döta johya. ");
INSERT INTO otqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne hyaxꞌmu̱ mi ꞌbu̱hnu̱ har nijö, mi nsunda Jö. Dá njapꞌu̱.");
INSERT INTO otqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Har ndu̱i núꞌmu̱ hinte mi jawa har ximha̱i, hinte mi janu̱ mhetsꞌi, Nöꞌö Togo mar Mhö mi ꞌbu̱ꞌö, mi ꞌbu̱hwi Jö, ne go gese̱ Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Har ndu̱i, Nöꞌö Togo mar Mhö, mi ꞌbu̱hwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ne gatho nöꞌö te ja go bi hyokꞌö. Nuꞌmu̱ hinte xi hyoki, hinte di jamhö ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Geꞌö hör te, ne nunar tenu̱ gehnu̱ ar ñotꞌi yotꞌwa yá mfeni ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nunar ñotꞌinu̱ yotꞌa har ꞌbe̱xui, ne nunar ꞌbe̱xui hinxi za̱ xi döhö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Xuwa, xki me̱hna Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ba ꞌbe̱hni ngu nꞌar nda̱majöni. Nunu̱ bi da̱majöni togo ar ñotꞌi, ne njapꞌu̱ nda ñꞌemu̱i gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ar Xuwa hingo mi geꞌö ar ñotꞌi, ho̱nse̱ ba ehe nda da̱majöni togo mar ñotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nuna togo mar ñotꞌi majöni, ne yotꞌwa yá mfeni ya jöꞌi, ndi ꞌñekwa har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gese̱ bi hyoka ar ximha̱i, ha núꞌmu̱ mba ekwa har ximha̱i bi mꞌu̱i, nuya jöꞌi himbi bödi togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ba e hár ha̱ise̱, ha nuya mengunu̱ himbi numansu. ");
INSERT INTO otqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ha nuꞌu̱ togo bi numansu, ne bi ñꞌemu̱ibi ár thuhu, bi tꞌumba ar tsꞌe̱di bi mbötsi Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nuyu̱ hinto hömpa ár ji, ne hinto di hñöꞌspa ár ndoꞌyo, hinxi mꞌu̱i ngetho xi ne nꞌar ñꞌo̱ho̱, ho̱nse̱ Jö xi japꞌu̱ yá bötsi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nöꞌö Togo mar Mhö ba e bi njöꞌi, ne da ꞌbu̱hwihu̱wa. Xa mi ko ár nhwëki, ne himi tsa̱ya̱ mi mönga nöꞌö majöni. Da handwabihe ár nsunda, ngu ár nsunda nöꞌö nꞌase̱ ár Tꞌu̱ ar Dada bi ꞌbu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ar Xuwa bi da̱majöni togoꞌö, mi ñö ntsꞌe̱di mi enö: —Gehnu̱ togo ndi xiꞌahu̱ ndi ꞌñepꞌu̱ mꞌe̱fa. Ne nunu̱ xa töka ár nsu, ngetho núꞌmu̱ hinge ndi mꞌu̱katho, ha mi ꞌbu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gathogihu̱ xa di hömfu̱ yá ñho, ne hiñhamꞌu̱ di kꞌathu̱ ár nhwëkiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nuya ꞌbe̱pate ba ꞌbe̱hna ar Moise bi utkagihu̱. Ha nupya xpa ꞌbe̱hna ar tsi Hmu Hesukristo, xpa hönju̱ ar nhwëki ne nöꞌö majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hinto xi hyanda Jö ar Dada. Nöꞌö nꞌase̱ ár Tꞌu̱ bi ꞌbu̱hwi ar Dada, gehnu̱ xi utkagihu̱ ár mꞌu̱iꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Gehnu̱ ar mhö bi da̱majöni ar Xuwa Xixthe, núꞌmu̱ ya xodyo bi me̱hna ya möjö ne yá ma̱xte xki ꞌñe Herusalen, nda tꞌa̱mbabi mi togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Himbi nko̱ni bi da̱majöni bi ꞌñenö: —Nuga hindar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nuꞌu̱ bi ꞌya̱mbabi ne bi ꞌñeñꞌu̱: —Xiꞌmu̱, togoꞌi. Hage gar mꞌe̱hni Elia. Ar Xuwa bi dödi ne bi ꞌñenö: —Hinꞌö, hingo geke. Bi mengi bi tꞌa̱mbabi ne bi tꞌembabi: —Hage go geꞌe ár döta mꞌe̱hni Jö ma nda ehe. Bi dödi ne bi ꞌñenö: —Hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bi mengi bi ꞌñembabiꞌu̱: —Xiꞌmu̱, togoꞌi. Xikagihe tema gi mönse̱ go geꞌaꞌi. Ne ga höꞌsfe ar mhö nuꞌu̱ togo xpa pe̱nkagihe ga kꞌösꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ar Xuwa bi dödi ne bi ꞌñembabiꞌu̱: —Nuga go geke nöꞌö bi mönga ar mꞌe̱hni Isaia: Ár mhafi nꞌa togo enga har otꞌatꞌo̱ho̱: Jömfu̱ ár ꞌñu ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nuya jöꞌi xki mꞌe̱hni ma yá ñꞌohu̱ ya de̱ngaꞌbe̱pate. ");
INSERT INTO otqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bi mengi bi ꞌya̱mba manꞌagi ar Xuwa ne bi ꞌñeñꞌu̱: —Xiꞌmu̱, yoꞌö gi xixthe nuꞌmu̱ hingar Kristo, hingar Elia, hingár döta mꞌe̱hni Jö nda ehe. ");
INSERT INTO otqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ar Xuwa bi dödi ne bi ꞌñenö: —Nuga di xixtheꞌihu̱ har dehe, ha gi ꞌbu̱hwihu̱wa nꞌa hingi pöhu̱ togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Gehnu̱ ndi enga nda ꞌñepꞌu̱ mꞌe̱fa. Nunu̱ xa töka ár nsu, hindi ꞌñepkagi ga xotꞌwatsꞌu̱ ár nthötꞌi yá thiza. ");
INSERT INTO otqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gathoyu̱ ba tho núnu̱ Betabara ꞌrandi ar döthe Hordan, habu̱ mi xixthe ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nu ár hyaxꞌöpꞌu̱, ar Xuwa mi hyanda ar Hesu ndi ꞌñe nda zu̱di, bi ꞌñenö: —Ndi, ba ehnu̱ togo xpa pe̱hna Jö ngu nꞌar tsi Ntxönandöni, da tꞌuni ngu ar mꞌo̱ñho̱, ne da hñökwa yá tsꞌoki ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Go gehnu̱ togo ndi xiꞌahu̱: ꞌBe̱fa nꞌar ñꞌo̱ho̱ xa töka ár nsu. Núꞌmu̱ hinge ndi mꞌu̱katho, mi ꞌbu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nuga hinge ndi pödi togoꞌö. Di xixthega ya jöꞌi har dehe, ne njapꞌu̱ nda bö ya me Israel núꞌmu̱ nda eꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ne ar Xuwa bi da̱majöni bi ꞌñenö: —Nuga da handwa ár Hñö Jö ba kö mhetsꞌi ngu nꞌar tsi domtxu, ba e bi zu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nuga hinge ndi pöhmö togoꞌö. Nöꞌö togo ba pe̱nkagi ga xixtheꞌihu̱ har dehe bi ꞌñengagi: Ma gi hyandwa ár Hñö Jö da gö mhetsꞌi, ne da zu̱ nꞌar ñꞌo̱ho̱ da mꞌu̱hwi. Gehnu̱ ma da xixtheꞌihu̱ ne gi hñömfu̱ ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nuga da handi, jange di da̱majöni go gehnu̱ ár Tꞌu̱ Jö mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ár hyaxꞌö manꞌagi mi ꞌba̱hwinu̱ ar Xuwa yoho yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mi hyanda ar Hesu mi thohnu̱ bi ꞌñenö: —Ndi ba ehnu̱ togo xpa pe̱hna Jö ngu nꞌar tsi Ntxönandöni, ma da tꞌuni ngu ar mꞌo̱ñho̱. ");
INSERT INTO otqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nuya yoho yá ma̱xte ar Xuwa mi ꞌyo̱ njapꞌu̱, dama bi de̱nga ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ar Hesu mi ñegi bi hyandi mi te̱nga nuya yohoyu̱, bi ꞌñenö: —Te gi hoñhu̱. Nuꞌu̱ bi dödi ne bi ꞌñeñꞌu̱: —Rabi (po̱ntho da ꞌñenö Utate), habu̱ gi ꞌbu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nöꞌö bi ꞌñembabiꞌu̱: —Möhö gi hyanthu̱. Bi maꞌu̱ ne bi bödi habu̱ mi ꞌbu̱ꞌö. Ne bi mꞌu̱hwinu̱ gatho nor paꞌö, ngetho mi tsu̱ ngu nꞌar goho nde. ");
INSERT INTO otqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nuꞌu̱ yoho yá ma̱xte ar Xuwa bi ꞌyo̱xa nöꞌö xki mö ne bi de̱nga ar Hesu, nꞌaꞌu̱ már thuhu ar Andre ár jödö ar Simu nöꞌö bi tꞌembabi ar Pedro. ");
INSERT INTO otqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nu mi maꞌö, mꞌe̱tꞌo bi nthe̱wi ar Simu ár jödö, ne bi ꞌñembabi: —Xta nthe̱he ar Mesia (ne da ꞌñenö ar Kristo). ");
INSERT INTO otqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nepꞌu̱ bi ziꞌspa ar Hesu. Ha núꞌmu̱ mi zo̱ni, ar Hesu bi kꞌötꞌi ne bi ꞌñembabi: —Nuꞌge gar Simu ár tꞌu̱ꞌi ar Honas. Nupya di husꞌaꞌi gar Sefa (ne da ꞌñenö ar Pedro). ");
INSERT INTO otqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ár hyaxꞌö bi benga ar Hesu nda ma har ha̱i Ngalilea, ne nu mi ma, bi nthe̱wi ar Lipe ne bi ꞌñembabi: —Ba e gi te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ar Lipe mar me Betsaida, ja ma ya mengunu̱ ar Andre ne ar Pedro nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ar Lipe bi nthe̱wi ar Natanael ne bi ꞌñembabi: —Xta nthe̱he nöꞌö togo xi no̱nga ar Moise hár tꞌofo, ne ngu bi ꞌyotꞌa nu maꞌra yá mꞌe̱hni Jö. Gehnu̱ ar Hesu ár tꞌu̱ ar Huse me Nasare. ");
INSERT INTO otqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ar Natanael bi ꞌñenö: —Hage da tsa̱ di ꞌñe nꞌar ñhonu̱ har hnini Nasare. Nuꞌmú̱ ar Lipe bi ꞌñembabi: —Ba e gi hyandase̱. ");
INSERT INTO otqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ar Hesu mi hyanda ar Natanael ndi ꞌñe nda zu̱di, bi ꞌñenö: —Hyanthu̱, xi ꞌñekwa nꞌar me Israel hingar nemhñö. ");
INSERT INTO otqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nuꞌmú̱ ar Natanael bi ꞌñemba ar Hesu: —Hanja gi pökagi. Ha nu ar Hesu bi dötwabi: —Núꞌmu̱ hinxki zoꞌatho ar Lipe ngi e ngi kꞌöskagi, da hantꞌaꞌi ngi ꞌba̱ hár wa ar ꞌba̱iꞌiuxi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ar Natanael bi dödi ne bi ꞌñenö: —Utate, nuꞌge go ár Tꞌu̱ꞌi Jö, ne go geꞌe ár Ndö ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ar Hesu bi dödi ne bi ꞌñembabi: —Hage ga ñꞌemu̱i núꞌmu̱ ho̱nse̱ da xiꞌaꞌi da hantꞌaꞌi ngi ꞌba̱ hár wa ar ꞌba̱iꞌiuxi. Nuya pa xi ꞌñepꞌu̱ ma gi hyanda maꞌra ya döta ntꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne bi ꞌñembabi: —Xa majöni di xiꞌaꞌi, nunar panu̱ ne nuya di ꞌñepꞌu̱, ma gi hyanda mhetsꞌi di xogi, ne gi hyandwa yá e̱nxe̱ Jö di po̱tsꞌe ne di köi da zu̱ Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ár hñupa bi nja nꞌar nthöti núnu̱ Nkana har ha̱i Ngalilea. Ka mi ꞌbu̱hnu̱ ár nönö ar Hesu nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ar Hesu ne yá ma̱xte bi nsipabi nda ma har ngo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Núꞌmu̱ mi kꞌatꞌa ar ixkatꞌafi, ár nönö ar Hesu bi ꞌñembabi: —Bi the ar ixkatꞌafi. ");
INSERT INTO otqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ha nu ar Hesu bi ꞌñenö: —Yoꞌö gi xikagiga, tsi ꞌbe̱hñö. Hinxi zo̱ta ar pa da nheki ma tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nepꞌu̱ ár nönö bi ꞌñemba nuꞌu̱ mi fa̱xte har ngo: —ꞌYo̱thu̱ gatho nöꞌö da xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ne mi tihnu̱ ꞌrato ya döta moto mi sitꞌa ar dehe, ngu yá ntꞌumbi ya xodyo ja mi ntꞌaxku̱nu̱. Mi ñꞌe̱nga ngu hñu wa goho xo̱ni ar dehe nꞌa ngu nꞌa ya motoyu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ar Hesu bi ꞌñemba ya ꞌbe̱go: —Ñuꞌsu̱ ar dehe nuya motoyu̱. Ne nuꞌu̱ bi ñutsꞌi xiñho, xa bi ꞌbaxki. ");
INSERT INTO otqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mꞌe̱fa bi ꞌñembabi nꞌehe: —ꞌYa̱thu̱ ne hñöꞌspabihu̱ ár ndö nunar ngonu̱. Nuꞌu̱ bi hñöꞌspabiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nunár ndö ar ngo mi za̱ ar dehe xki ñꞌixkatꞌafi, himi pöhnu̱ habu̱ xki ꞌñehe. Ho̱nse̱ nuya ꞌbe̱goyu̱ mi pöꞌu̱ xki ꞌya̱tꞌu̱ har dehehmö. Nunar ndö ꞌmu̱ bi ma ba zo nöꞌö togo xki nthöti. ");
INSERT INTO otqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ne bi ꞌñembabi: —Gatho nuꞌu̱ togo o̱tꞌa nꞌar ngo, mꞌe̱tꞌo unga ar hoga ixkatꞌafi, ne núꞌmu̱ xi nithe nuꞌu̱ xi tsꞌohni, unga nöꞌö hintsꞌu̱ ho. Ha nuꞌge xka kwata nöꞌö xiñho, ne ja xka umpya. ");
INSERT INTO otqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gehnu̱ ar ꞌbe̱tꞌo dötantꞌudi bi ꞌyo̱tꞌa ar Hesu núnu̱ Nkana har ha̱i Ngalilea. Bi ñꞌu ár nsunda ne nuyá ma̱xte bi ñꞌemu̱ibi. ");
INSERT INTO otqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nepꞌu̱ ar Hesu bi ma Nkapernaum, bi me̱wi ár nönö, yá jödö ne yá ma̱xte. Ka ba ꞌbu̱hnu̱ ꞌra ya tsi pa. ");
INSERT INTO otqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Núꞌmu̱ mi ꞌba̱pꞌu̱tho ar baxjwa ár da̱ngo ya xodyo, ar Hesu bi bo̱tsꞌe bi ma Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mi zo̱nu̱ bi hyanda ꞌra mi ꞌbu̱hnu̱ hár thi ar dönganijö mi pa̱ ya boi, ya de̱ti, ya domtxu, ne mi huhnu̱ ya pa̱tbojö. ");
INSERT INTO otqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ar Hesu bi hyoka nꞌar nkꞌe̱nxi nthöhi, ne bi ꞌye̱nga nuya ma̱, mahye̱giwi yá de̱ti ne yá boi mi ꞌbu̱ har nijö. Bi fontꞌwa yá bojö ya pa̱tbojö ne bi pu̱spa yá mexa. ");
INSERT INTO otqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne bi ꞌñemba nuꞌu̱ togo mi pa̱ ya domtxu: —Juju̱wayu̱, yo gi jafu̱ ár ngu ma Dada nꞌar ta̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nuꞌmú̱, nuyá ma̱xte bi beñꞌu̱ xki tꞌotꞌa hár Tꞌofo Jö habu̱ enö: Di tuse̱ di supꞌa ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nuya ndöxodyo bi ꞌñemba ar Hesu: —Tema dötantꞌudi gi utkagihe, njapꞌu̱ ga pöhe togo xi ꞌraꞌa ar tsꞌe̱di gi ꞌyo̱tꞌa njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Hwathu̱ nunar nijönu̱, ne ár hñupa ga pengi ga ju̱xa manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nuꞌmú̱ nuya xodyo bi ꞌñeñꞌu̱: —Yonꞌa̱temaꞌrato nje̱ye̱ bi nju̱xa nunar nijönu̱. Hage hñupatho gi ju̱xa manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nunar nijö mi no̱nga ar Hesu gehnu̱ ár ndoꞌyose̱. ");
INSERT INTO otqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ha núꞌmu̱ mi mengi bi nte manꞌagi ar Hesu, nuyá ma̱xte bi beñꞌu̱ xki mönga njapꞌu̱, ne bi ñꞌemu̱iꞌu̱ gatho nöꞌö xki tꞌotꞌa hár Tꞌofo Jö, ne nöꞌö mi mönga ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nu mi ꞌbu̱hnu̱ Herusalen har da̱ngo mbaxjwa, nze̱ye̱ ya jöꞌi bi ñꞌemu̱i ar Hesu, mi hyanda ya ntꞌudi mi o̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ha nöꞌö himi ñhe̱tho, ngetho mi pötwatho yá mfeniꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne himi hoñꞌö togo nda xipabi tengu yá mꞌu̱i ya jöꞌi, ngetho nöꞌö mi pötho tema mi benga nꞌa ngu nꞌaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ mar de̱ngaꞌbe̱pate már thuhu Nikodemo, mar ndö madeda yá mixodyowi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nunu̱ ba e nxui bi kꞌönga ar Hesu ne bi ꞌñembabi: —Utate, di pöhe xpa pe̱ñꞌa Jö ngu ár utate, ngetho hingi tsa̱ to da ꞌyo̱tꞌa nuya ntꞌudi gi o̱tge nuꞌmu̱ hingi ꞌbu̱hwiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ar Hesu bi döti ne bi ꞌñembabi: —Xa majöni di xiꞌaꞌi, nöꞌö togo hinda mengi da mꞌu̱ manꞌagi, hinda tsa̱ da hyandwa ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ar Nikodemo bi ꞌñembabi: —Hanja tsa̱ da mengi da mꞌu̱ manꞌagi nꞌar ñꞌo̱ho̱ xi ndönzia. Hage tsa̱ da yu̱tꞌa hár mu̱i ár nönö manꞌagi, ne da mengi da mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Bi dötwa ar Hesu: —Xa majöni di xiꞌaꞌi, nöꞌö togo hinda mꞌu̱ har dehe ne hár Hñö Jö, hinda tsa̱ da yu̱tꞌa hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nuꞌu̱ to gatho xi ꞌyo̱nga nꞌar jöꞌi, ar jöꞌi nꞌehe. Ha nuꞌu̱ xi umba ár te ár Hñö Jö, ar hñö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yo gi ꞌyo̱ nuꞌmu̱ di xiꞌaꞌi, mahyoni gi pengi gi mꞌu̱ manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ar ndöhi habu̱ gatho ꞌyo ne gi o̱de bu̱, ha hingi pödi habu̱ xpa ehe, wa habu̱ di ma. Njapꞌu̱ nuꞌu̱ xi mꞌu̱ manꞌagi xi nzinga ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ar Nikodemo bi dödi ne bi ꞌñembabi: —Hanja tsa̱ da tho njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ar Hesu bi dödi ne bi ꞌñenö: —Ár utateꞌi ya me Israel, yoꞌö hingi pöhyu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xa majöni di xiꞌaꞌi, nöꞌö di pöhe di xiꞌahu̱, ne nöꞌö xta hanthe di da̱he majöni, ha nuꞌahu̱ hingi ñꞌemu̱ihu̱ nöꞌö di xiꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nuꞌmu̱ hingi ñꞌemu̱ihu̱ nöꞌö di xiꞌahu̱ di he̱kwa nöꞌö te jawa har ximha̱i, hanja ma gi ñꞌemu̱ihu̱ nuꞌmu̱ ga xiꞌahu̱ nuꞌu̱ te janu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hinto xi bo̱xa mañö mhetsꞌi, gese̱ꞌö ba kö mhetsꞌi, gehnu̱ Togo ba e bi Njöꞌi, ar mengunu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ne njangu ar Moise bi tsu̱ta nꞌar kꞌeñö ha nꞌar za, núꞌmu̱ mi ꞌyo ya me Israel ha ya otꞌatꞌo̱ho̱, ma da njapꞌu̱ Nöꞌö Togo ba e bi Njöꞌi, mahyoni da tsꞌu̱ta ha nꞌar za nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ne gatho nuꞌu̱ togo da ñꞌemu̱i, hinda mꞌe̱di, ma da me̱sꞌu̱ ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Jö xa bi mö ya meximha̱i, jange bi unga nöꞌö nꞌase̱ ár Tꞌu̱, ne njapꞌu̱ gatho nuꞌu̱ togo da ñꞌemu̱i, hinda mꞌe̱di, ma da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ngetho Jö hinxpa pe̱hna ár Tꞌu̱ har ximha̱i da me̱hna har ꞌbe̱xui ya meximha̱i. Xpa pe̱hni da po̱hyu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nöꞌö togo da ñꞌemu̱ibiꞌö, hinda ma da ꞌbe̱hna har ꞌbe̱xui. Ha nöꞌö togo hinda ñꞌemu̱i, xi tꞌe̱kwabi da ꞌbe̱hna har ꞌbe̱xui, ngetho himbi ñꞌemu̱ibi nöꞌö nꞌase̱ ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nuꞌu̱ ma da mꞌe̱hna har ꞌbe̱xui, ngetho ar hyatsꞌi ba ekwa har ximha̱i, ha nuꞌu̱ xa bi mö ar ꞌbe̱xui, ngetho himi o̱tꞌu̱ nöꞌö xiñho. ");
INSERT INTO otqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gatho nuꞌu̱ togo o̱tꞌa nöꞌö hingi ho, u̱tsa ar hyatsꞌi, ne hingi kwatꞌi, njapꞌu̱ hinda nheki hingi ho nöꞌö o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ha nöꞌö togo o̱tꞌa nöꞌö majöni, kwatꞌa har hyatsꞌi, honi da nheki nöꞌö o̱tꞌe, ngetho o̱tꞌe ju̱mpa ár tsꞌe̱di Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mꞌe̱fa ar Hesu bi me̱wi yá ma̱xte har ha̱i Nhudea, ne ka ba ꞌbu̱hnu̱ ꞌra ya pa, mi xixthe ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ar Xuwa nꞌehe mi xixthe núnu̱ Enon getꞌu̱ ar hnini Salim, ngetho mi janu̱ nze̱ye̱ ar dehe. Jange ya jöꞌi mi panu̱ nda nxixtheꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gathoyu̱ bi thogi núꞌmu̱ hinxki tꞌetꞌatho ar fa̱di ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nuꞌmú̱ yá ma̱xte ar Xuwa bi ntsa̱hñökiwi yá mixodyowi, mi no̱ñꞌu̱ ar xixthe ntꞌaxki. ");
INSERT INTO otqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bi ma ba kꞌöꞌsa ar Xuwa, ne bi ꞌñembabi: —Utate, nunar ñꞌo̱ho̱ ga nthe̱wi ꞌrandi ar döthe Hordan, nöꞌö ga da̱majöninu̱, xixthe nꞌehe, ne gatho ya jöꞌi pa bi tsu̱di. ");
INSERT INTO otqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ar Xuwa bi dödi ne bi ꞌñenö: —Hinto tsa̱ te da me̱ꞌsase̱ nuꞌmu̱ hingo xi umba Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nuꞌahu̱ xka ꞌyo̱se̱hu̱ núꞌmu̱ nda enö: Nuga hindar Kristo. Ho̱nse̱ xpa ꞌbe̱nkagi ga ꞌbe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Njangu nꞌar ñꞌo̱ho̱ ma da nthöti, go ma da zixa ar ꞌbe̱hñöꞌö, ha nöꞌö ar ꞌya̱te ñꞌowi, o̱xa nöꞌö te mö ne xa johya. Di njagapꞌu̱ nꞌehe, di johya di o̱ nöꞌö te thogi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngetho mahyoni da hñuxa ár nsuꞌö, ne nuga da the ma nsu. ");
INSERT INTO otqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nöꞌö xpa e mhetsꞌi töpa ár nsu nuya ꞌbu̱kwa har ximha̱i. Ha nuya meximha̱i ár me̱ti ar ximha̱i, ne ho̱nse̱ mönga nöꞌö te jawa. Hö, töte ár nsu nöꞌö togo xpa e mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nunu̱ xipa ya jöꞌi te xpa o̱de ne xpa handnu̱, mödi njapꞌu̱ hinto ñꞌemu̱i nöꞌö möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nuꞌu̱ togo hömba ár mhö, ñꞌu njapꞌu̱ majöni nöꞌö mönga Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nöꞌö togo xpa pe̱hna Jö, mömba ár mhöꞌö, ngetho Jö hingi e̱mbatho ár Hñö umbabi. ");
INSERT INTO otqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jö ar Dada xa mö ár Tꞌu̱, jange xi ꞌye̱ntꞌwa gatho hár ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nöꞌö togo ñꞌemu̱i ar Tꞌu̱, pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. Ha nöꞌö hingi ne da ñꞌemu̱i ar Tꞌu̱, hinda ma da me̱ꞌsa nunar tenu̱, ho̱nse̱ ár kwe̱ Jö ma da nthe̱xkwiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Núꞌmu̱ mi bö ar tsi Hmu xki zo yá gu ya de̱ngaꞌbe̱pate nöꞌö mi pe ya jöꞌi, mi eñꞌu̱: Ar Hesu xa xixthe nze̱ye̱ ya jöꞌi, töta ar Xuwa Xixthe ");
INSERT INTO otqNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(mödi ar Hesu hingo mi xixtheꞌö, yá ma̱xte go mi o̱tꞌu̱). ");
INSERT INTO otqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ne bi bo̱nga har ha̱i Nhudea, bi menga manꞌagi har ha̱i Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mi mahyoni nda thota har ha̱i Nsamaria. ");
INSERT INTO otqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jange mi thohnu̱ Nsamaria, ba e ha nꞌar hnini ár thuhu Sikar, getꞌu̱ habu̱ ꞌbu̱ ár ha̱i ar Hakob xki zokwa ar Huse ár tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ka mi ꞌbu̱hnu̱ nꞌar po̱the, mi tꞌembabi ár po̱the ar Hakob. Nu mi thohnu̱ ar Hesu, xki za̱bi mi ne ar ꞌñu, bi ma ba huhnu̱ habu̱ mi ꞌbu̱ ar po̱the, mi tsu̱ ngu made mpa. ");
INSERT INTO otqNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ba e har po̱the nꞌar ꞌbe̱hñö me Nsamaria nda ꞌya̱tꞌa ar dehe, ne ar Hesu bi ꞌñembabi: —ꞌRaka nꞌa tsi tu̱i ar dehe ga tsi. ");
INSERT INTO otqNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ha nuyá ma̱xte xki ma har hnini, ma nda da̱nga te nda ziꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nunar ꞌbe̱hñö me Nsamaria bi ꞌñemba ar Hesu: —Hanja gi a̱kar dehe, ngetho gar xodyo, ha nuga dar me Nsamaria. Bi mönga njapꞌu̱ ngetho nuya xodyo himi ne nda ntsixkwi ya me Nsamaria. ");
INSERT INTO otqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabi: —Nuꞌmu̱ gi pötwahmö ár ntꞌuni Jö, ne nuꞌmu̱ gi pöhmö togo a̱ꞌa ar dehe, go xka ꞌya̱kagi ꞌmu̱, ne nuga xta ꞌraꞌa ar dehe unga ar te. ");
INSERT INTO otqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ne nunar ꞌbe̱hñö bi ꞌñenö: —Tsi Tata, nunar po̱the xi ñhe, ne hinte gi hö te gi ꞌya̱tꞌi. Habu̱ ma gi hö ar dehe unga ar te ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Hage gi töpke ár nsu ma palehe ar Hakob togo bi zogagihe nunar po̱thenu̱. Ka mi tsithewaꞌö, yá tꞌu̱ ne gatho yá me̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ar Hesu bi dödi ne bi ꞌñembabi: —Nuꞌu̱ togo da zi nunar dehenu̱, ma da mengi da ntuthe. ");
INSERT INTO otqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ha nöꞌö togo da zi nunar dehe di unga, hinda ma da mengi da ntuthe. Ngetho nunar dehe ga umbabi, ma da njangu nꞌar po̱the hár mu̱i, unga ar dehe hiñhamꞌu̱ da xa̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nuꞌmú̱ nunar ꞌbe̱hñö bi ꞌñembabi: —Tsi Tata, ꞌraka nöꞌö ar deheꞌö. Njapꞌu̱ hinga pengi ga ntuthe, ne hinga e ga höxa ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ar Hesu bi ꞌñembabi: —Di ma ba tsi ri döme, ne gi penga injawa. ");
INSERT INTO otqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ar ꞌbe̱hñö bi dödi ne bi ꞌñenö: —Hinte ma döme di ꞌñehe. Ar Hesu bi ꞌñembabi: —Majöni nöꞌö xka mö, hinte gi ꞌñe ri döme. ");
INSERT INTO otqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ngetho ku̱tꞌa ya ndo̱ xka ꞌñehe, nöꞌö gi ꞌbu̱hwipya hingo ri döme. Jange majöni nöꞌö xka mö, hinte ma döme gi ꞌñehe. ");
INSERT INTO otqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nuꞌmú̱ bi ꞌñemba ar ꞌbe̱hñö: —Tsi Tata, gar mꞌe̱hni Jö ngubeni. ");
INSERT INTO otqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Numa palehe bi ndönga Jö núnu̱ har tꞌo̱ho̱nu̱. Ha nuꞌahu̱ gar xodyohu̱, gi eñhu̱ mahyoni da ndönga Jö núnu̱ Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ar Hesu bi ꞌñembabi: —Ma ga xiꞌaꞌi, nönö, ma da zo̱ ar pa núꞌmu̱ gatho nuꞌu̱ togo ne da ndönga Jö ar Dada, hinda ma da ekwa har tꞌo̱ho̱nu̱, ne hinda manu̱ Nherusalen. ");
INSERT INTO otqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nuꞌahu̱ gi ndöñhu̱ nöꞌö hingi pöhu̱, ha nuje hö, di pöhe togo di ndöñhe, ngetho ar mpo̱ho̱ bi e ha ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Xi ꞌñepꞌu̱ ar pa ne xi zo̱pya, núꞌmu̱ togo majöni ndönga Jö ar Dada, da ꞌyo̱tꞌe di po̱nga hár mu̱i ne ngu nöꞌö majöni, ngetho ar Dada honga togo da ndönga njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jö ar hñö, ne hingi nheki. Jange nuꞌu̱ togo da ndöni, mahyoni di po̱nga hár mu̱i ne ngu nöꞌö majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bi ꞌñenga ar ꞌbe̱hñö: —Di pödi ma da e ar Mesia nöꞌö tꞌembabi ar Kristo, ne núꞌmu̱ xta eꞌö, ma da ꞌyotkagihe xiñho ar ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ar Hesu bi ꞌñembabi: —Go geke togo di ñöwipya. ");
INSERT INTO otqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Geꞌmu̱ bi zo̱ yá ma̱xte, ne nuꞌu̱ xa bi ꞌyo̱tho bi hyantꞌu̱ ar Hesu mi ñöwi nꞌar ꞌbe̱hñö, mödi hinto bi ñꞌa̱ni tema mi a̱mbabi, wa tema mi mpeꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nuꞌmú̱ nunar ꞌbe̱hñö dama bi zopꞌu̱ ár xo̱ni, bi nixtꞌi bi ma har hnini, ne bi ꞌñemba gatho ya jöꞌi: ");
INSERT INTO otqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ba ehu̱ gi hyanthu̱ nꞌar ñꞌo̱ho̱ xi xikagi gatho nöꞌö xta o̱tꞌe. Ha hinga gehnu̱ ar Kristo ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nuꞌmú̱ nze̱ye̱ ya jöꞌi ba po̱nga har hnini, ba e bi kꞌötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nu mi ma ar ꞌbe̱hñö, nuyá ma̱xte mi pe̱mbabiꞌu̱ ar Hesu mi embabi: —Utate, ba e gi ñuni. ");
INSERT INTO otqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ha nöꞌö bi ꞌñembabiꞌu̱: —Di pe̱ꞌska nꞌar ñhuni di tsi, nöꞌö hingi pöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nuyá ma̱xte mi enga nꞌa ngu nꞌa: —Hage to xpa hömpa te da zi ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ar Hesu bi ꞌñembabiꞌu̱: —Numa ñhuniga, ga o̱tꞌwa ngu ne nöꞌö togo xpa pe̱nkagi, ne ga jwata gatho nöꞌö xi ꞌbe̱pkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nuꞌahu̱ gi eñhu̱, ꞌbe̱ta goho nzönö da zo̱ ar sofo. Ha nuga di xiꞌahu̱: Ndi, hyanthu̱ ya ꞌbotꞌi xi ñötsꞌi da nsofo. ");
INSERT INTO otqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nuya xathe hönga ar nthöhö ne ju̱xa ya sofo hiñhamꞌu̱ thege, jange nuya xofo njohyawi ya motꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Xa majöni nöꞌö engar jöꞌi: Nꞌañꞌo togo potꞌi ne manꞌa togo xofo. ");
INSERT INTO otqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nuga di pe̱ñꞌahu̱ gi munsu̱ ya jöꞌi, ngu nꞌar xofo nöꞌö hinxka mpe̱hu̱. Maꞌra togo xi mpotꞌi, ne nuꞌahu̱ go xka johu̱ ar sofo. ");
INSERT INTO otqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ne nze̱ye̱ ya mengu ar hniniꞌö har ha̱i Nsamaria, bi ñꞌemu̱i mi ꞌyo̱ꞌu̱ nöꞌö mi da̱majöni nunar ꞌbe̱hñönu̱, mi enö: Xi xikagi gatho nöꞌö xta o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Núꞌmu̱ mi zo̱nga ya me Nsamaria habu̱ mi ꞌbu̱ ar Hesu, bi ꞌya̱pa ar möte nda gohnu̱, ne bi gohnu̱ yopa. ");
INSERT INTO otqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ne ma nze̱ye̱ bi ñꞌemu̱i mi ꞌyo̱ nöꞌö te mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne mi embabiꞌu̱ ar ꞌbe̱hñö: —Nupya di ñꞌemu̱ihe hinge ho̱nse̱ da o̱he nöꞌö ga xikagihe. Xta o̱se̱he nöꞌö mö, ne di pöhe xiñho go gehnu̱ ar Kristo togo xpa ꞌbe̱hni da po̱ ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ár yopa bi gu̱ ar ꞌñu manꞌagi ndi ma Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ngetho ar Hesu xki da̱se̱ majöni bi ꞌñenö, nꞌár mꞌe̱hni Jö hingi tꞌeꞌspa ár nsu hár ha̱ise̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mi zo̱nga Ngalilea, nuya mengunu̱ bi numañho, ngetho xki hyanda gatho nöꞌö xki ꞌyo̱tꞌa núnu̱ Herusalen har da̱ngo. Nuya paꞌu̱ ka mi ꞌbu̱hnu̱ꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mꞌe̱fa ar Hesu bi ma manꞌagi núnu̱ Nkana har ha̱i Ngalilea, habu̱ xki japa ar dehe xki ñꞌixkatꞌafi. Núnu̱ Nkapernaum ka mi ꞌbu̱hnu̱ nꞌár ma̱xte ar ndö togo mi hñenga ár bötsi. ");
INSERT INTO otqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nu mi ꞌyo̱hnu̱ ar Hesu ba tsopꞌu̱ Nhudea, ba e Ngalilea, bi ma ba a̱pabi nda e nda hyandwa ár bötsi, ngetho mi txꞌu̱da ár te. ");
INSERT INTO otqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ne ar Hesu bi ꞌñembabi: —Nuꞌahu̱, nuꞌmu̱ hingi hyanthu̱ ya dötantꞌudi, hingi ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nunár ma̱xte ar ndö bi ꞌñenö: —Tsi Hmu, ba e ngutꞌa, ꞌbu̱tho da du ma tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ar Hesu bi ꞌñembabi: —Di ma, ri tꞌu̱ ꞌbu̱i xiñho. Ne nunar ñꞌo̱ho̱nu̱ bi ñꞌemu̱i nöꞌö bi nsipabi, bi gu̱ ár ꞌñu bi ma. ");
INSERT INTO otqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Núꞌmu̱ mi ꞌyo ar ꞌñu ndi ma ár ngu, nuyá ꞌbe̱go ba e bi dödi, ne bi ꞌñeñꞌu̱: —Ri tꞌu̱ ꞌbu̱i xiñho. ");
INSERT INTO otqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nöꞌö bi ꞌya̱mbabi hamꞌu̱ bi ndu̱i bi mꞌu̱ xiñho. Nuꞌu̱ bi ꞌñembabi: —Mande, ngu nꞌar nde bi hye̱ ar mpatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nunár dada ar bötsi bi beni geꞌmu̱ xki xipa ar Hesu mi ꞌbu̱ xiñho ár tꞌu̱, ne bi ñꞌemu̱iwi gatho yá mëni. ");
INSERT INTO otqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Go gehnu̱ ár ñoho ar döta ntꞌudi bi ꞌyo̱tꞌa ar Hesu núnu̱ Ngalilea núꞌmu̱ mba penga Nhudea. ");
INSERT INTO otqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mꞌe̱fa bi da̱tꞌa nꞌár da̱ngo ya xodyo núnu̱ Herusalen, ne ar Hesu bi manu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Núnu̱ Herusalen ka ꞌbu̱hnu̱ nꞌar po̱the tꞌembabi Betesda har hñö ebreo, ne pe̱ꞌsa ku̱tꞌa ya mꞌetꞌe, ꞌbu̱ getꞌu̱ ar goxthi tꞌembabi ar Goxthide̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ka mi ꞌbonu̱ nze̱ye̱ ya da̱thi, ya goda̱, ya dowa ne nuꞌu̱ xki nza yá ndoꞌyo, gathoyu̱ mi to̱ꞌmi nda mfe̱ꞌsa ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ngetho mi jar pa mi kö nꞌár e̱nxe̱ Jö mi wöntꞌa ar dehe, ne nöꞌö togo nda ntöte nda yu̱tꞌa mꞌe̱tꞌo har dehe, nöꞌö nda dixa tsa̱ntꞌö ar hñeni mi thogi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ne mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ mi pe̱ꞌsa nꞌa̱temaꞌre̱tꞌa ne hñöto nje̱ye̱ mi hñeni. ");
INSERT INTO otqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ar Hesu bi hyandi mi ꞌbe̱nu̱, mi bödi mi pe̱ꞌsa nze̱ye̱ ya je̱ye̱ mi njapꞌu̱, bi ꞌñembabi: —Ha gi ne da dixꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ar da̱thi bi dödi ne bi ꞌñembabi: —Tsi Tata, hinto di ꞌñe togo da ma̱xkagi ga ku̱tꞌa har dehe núꞌmu̱ xta mfe̱tsꞌi, ngetho núꞌmu̱ di pahmö ga ku̱tꞌi, manꞌa tökagi da yu̱tꞌa mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ar Hesu bi ꞌñembabi: —Nangi, ju̱xa ri fidi ne ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ne nunar ñꞌo̱ho̱nu̱ dama bi ditsꞌi, bi gu̱xa ár fidi ne bi ñꞌo. Ha nor paꞌö mar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jange nuya ndöxodyo bi ꞌñembabi nunar ñꞌo̱ho̱ xki tꞌo̱the: —Ar pa ntsa̱ya̱pya, hingi ho gi hñöxa ri fidi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nunar ñꞌo̱ho̱ xki ditsꞌi bi ꞌñembabiꞌu̱: —Nöꞌö togo bi o̱thegi, gese̱ꞌö bi ꞌñengagi: Ju̱xa ri fidi gi ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ne nuꞌu̱ bi ꞌya̱mbabi: —Togo bi xiꞌaꞌi gi ju̱xa ri fidi gi ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ha nunar ñꞌo̱ho̱ xki ditsꞌi, himbi bödi togo xki o̱the, ngetho mi ꞌbu̱hnu̱ nze̱ye̱ ya jöꞌi, ha nunar Hesu xki ma. ");
INSERT INTO otqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mꞌe̱fa ar Hesu bi nthe̱wi har nijö nunar ñꞌo̱ho̱nu̱ mi hñemhö, ne bi ꞌñembabi: —Ha gi o̱de, nuꞌge bi dixꞌaꞌi. Yo ma gi pengi gi ꞌyo̱tꞌa ar tsꞌoki, yo ma da ꞌñepꞌaꞌi nꞌar thogi di töte ár döta. ");
INSERT INTO otqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nepꞌu̱ nunar ñꞌo̱ho̱nu̱ bi ma ba kꞌöꞌsa ya ndöxodyo, bi xipabiꞌu̱ ar Hesu go xki o̱theꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jange nuya ndöxodyo xa mi u̱tsa ar Hesu, ne xa mi nemhöꞌu̱ nda hyo, ngetho mi o̱tꞌa ya döta ntꞌudi har pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Ma Dada hinxi ntsa̱ya̱ mpe̱fi, di njagapꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mi ꞌyo̱xa nuya mhöyu̱, nuya ndöxodyo xa bi hñuxa yá kwe̱. Ne mi ne nda hyoꞌu̱, ngetho himi o̱tꞌa nöꞌö mönga har tꞌofo habu̱ no̱nga ar pa ntsa̱ya̱, ne mi embase̱ Jö go már Dada, njapꞌu̱ mi ñhuxkwi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nuꞌmú̱ ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, hinte tsa̱ te da ꞌyo̱tꞌase̱ ár Tꞌu̱ Jö. Te̱nda nöꞌö o̱tꞌa ár Dada, ngetho gatho nöꞌö o̱tꞌa ar Dada, o̱tꞌa ar Tꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jö ar Dada xa mö ár Tꞌu̱ jange uta gatho nöꞌö te o̱tꞌö. Ne ma da uta maꞌra xa di thota ár döta, ne xki hyanthu̱ xa gi ꞌyo̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jö ar Dada koꞌspa yá te nuꞌu̱ xi du, njapꞌu̱ ár Tꞌu̱ nꞌehe umba ár te nuꞌu̱ togo da neꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jö ar Dada hinto höꞌspa majöni, ngetho gatho bi ꞌye̱ntꞌwa hár ꞌye̱ ár Tꞌu̱, go da hñöxa majöniꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ne njapꞌu̱ gatho ya jöꞌi da ꞌñeꞌspa ár nsu ar Tꞌu̱, ngu tꞌeꞌspa ár nsu Jö ar Dada. Nöꞌö togo hingi eꞌspa ár nsu ar Tꞌu̱, hingi eꞌspa ár nsu ar Dada togo xpa pe̱hni. ");
INSERT INTO otqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Xa majöni di xiꞌahu̱, nöꞌö togo jamasu nöꞌö di mö, ne ñꞌemu̱i Jö togo xpa pe̱nkagi, pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. Ne hinda ꞌbe̱hna har ꞌbe̱xui, ngetho ꞌbu̱tho xki du, ne bi mengi bi me̱ꞌsa nꞌar ꞌraꞌyo te. ");
INSERT INTO otqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Xa majöni di xiꞌahu̱, xi ꞌñepꞌu̱ ar pa, ne xi zo̱pya, núꞌmu̱ nuꞌu̱ xi du ma da ꞌyo̱ ár mhö ár Tꞌu̱ Jö, ne nuꞌu̱ togo da ꞌñetꞌa ár mu̱i, ma da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngetho jangu Jö ar Dada höse̱ ar te, njapꞌu̱ xi umba ar tsꞌe̱di ár Tꞌu̱ da hñöse̱ ar te nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne xi ꞌye̱ntꞌwa hár ꞌye̱ ár Tꞌu̱ da hñöꞌspa majöni gatho ya jöꞌi, ngetho go ba e bi njöꞌiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yo gi ꞌyo̱hu̱ nuꞌmu̱ di xiꞌahu̱ njapꞌu̱, ngetho ma da zo̱ ar pa, nuꞌu̱ to gatho xi tꞌa̱gi ma da ꞌyo̱ꞌspa ár mhö ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ne nuꞌu̱ togo xi ꞌyo̱tꞌa nöꞌö xiñho, ma da nangi da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. Ha nuꞌu̱ togo xi ꞌyo̱tꞌa nöꞌö hingi ho, ma da nangi da ꞌbe̱hna har ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nuga hingi tsa̱ te ga o̱tꞌase̱. Ngu di o̱de xika ma Dada, njapꞌu̱ di o̱tꞌa ar tsꞌu̱tꞌwi. Ne ma tsꞌu̱tꞌwi xiñho, ngetho hindi o̱tꞌa ngu di nega, di o̱tꞌe ngu ne ma Dada togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nuꞌmu̱ ga mönse̱ togogi, hinter me̱ nöꞌö di mö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ꞌBu̱i nꞌa togo da̱majöni togogi, ne di pödi pe̱ꞌsa ár nsu nöꞌö möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nuꞌahu̱ ga pe̱ñhu̱ ꞌra togo ma ba a̱mba ar Xuwa togogi, ne nöꞌö bi da̱majöni togogi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ha nuga hindi honga da da̱majönigi nꞌar jöꞌi. Nuꞌmu̱ xta xiꞌahu̱ njapꞌu̱, di honi gi mpo̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ar Xuwa mi ñhe̱hwi nꞌar ñotꞌi. Nöꞌö mi xiꞌahu̱ mi yotꞌa ri mfenihu̱, ne ga njohyahu̱ ꞌra ya tsi pa ngi o̱xu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ha nuya ꞌbe̱fi di pe̱fi töpa ár tsꞌe̱di ar Xuwa da da̱majöni togogi. Ngetho di pe̱ ar ꞌbe̱fi ba pe̱nkagi Jö ga jwati, ne nuya ꞌbe̱fiyu̱ da̱majöni geꞌö xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Dada togo ba pe̱nkagi go da̱majöni nꞌehe togogi, mödi hinxka ꞌyo̱hu̱ xi ñö, ne hinxka hyanthu̱ tenguꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hingi pe̱ꞌsfu̱ ár mhö ha ri mu̱ihu̱, ngetho hinga ñꞌemu̱ihu̱ togo ba pe̱ñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hñethwu̱ ár Tꞌofo Jö, ngetho gi ka̱xmbenihu̱ ka gi tiñhu̱nu̱ ar te hiñhamꞌu̱ da götsꞌi. Hinxi zoda ri mfenihu̱ ka no̱ngaginu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ne hingi ne gi ñꞌemu̱igihu̱, ne gi pe̱ꞌsu̱ ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nuga hindi honi da ꞌñeska ma nsu ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Di pötho nuꞌahu̱ hingi pe̱ꞌsfu̱ ár mhöte Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nuga xta e di po̱ta Jö ar Dada, ne hingi numañhogihu̱. Nuꞌmu̱ da ehmö nꞌar jöꞌi di e di no̱nse̱ ár thuhuse̱, nuꞌmú̱ hö, gi numansuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hingi tsa̱ gi ñꞌemu̱ihu̱, ngetho mꞌe̱tꞌo gi hoñhu̱ da tꞌesꞌahu̱ ri nsuhu̱ nꞌa ngu nꞌa, ne hingi hoñhu̱ da ꞌñesꞌahu̱ ri nsuhu̱ nöꞌö nꞌase̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yo gi beñhu̱ ma ga da̱tꞌaꞌihu̱ hár nthandi Jö ma Dada. Nöꞌö togo ma da da̱ꞌahu̱, gese̱ ar Moise togo gi ka̱xmbenihu̱ ma da ñöñꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngetho nuꞌmu̱ gi ñꞌemu̱ihmöhu̱ ar Moise, gi ñꞌemu̱igihu̱ ꞌmu̱, ngetho ar Moise bi ꞌyotꞌa ar tꞌofo no̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ha nuꞌmu̱ hingi ñꞌemu̱ihu̱ nöꞌö bi ꞌyotꞌö, hinda tsa̱ gi ñꞌemu̱ihu̱ nöꞌö di mönga. ");
INSERT INTO otqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mꞌe̱fa ar Hesu bi ꞌranga ꞌrandi ar dehe habu̱ ár thuhu Ngalilea, getꞌö ar ñho̱nthe Tiberia. ");
INSERT INTO otqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ha nze̱ye̱ ya jöꞌi bi de̱ni, ngetho xki hyanda ya ntꞌudi mi o̱tꞌe, núꞌmu̱ mi o̱the ya da̱thi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nuꞌmú̱ ar Hesu bi bo̱xa mañö ar tꞌo̱ho̱ ne ka ba huxkwinu̱ yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mi ꞌba̱pꞌu̱tho ar baxjwa ár da̱ngo ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ar Hesu mi hyanda ra nze̱ye̱ ya jöꞌi xki ꞌñe nda zu̱di, bi ꞌñemba ar Lipe: —Habu̱ ga ta̱ñhu̱ ya thuhme ga ꞌwiñhu̱ gatho nuya jöꞌiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Bi xipa njapꞌu̱ mi ne nda tsa̱ta ar Lipe, ngetho ar Hesu mi pödi teme nda me̱fi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ar Lipe bi dödi ne bi ꞌñembabi: —Nunar nthöhö hönga yonthebe ya jöꞌi nꞌa pa, hinda wadi ga ta̱ñhu̱ ar thuhme ga hemfu̱ nꞌa tsi xe̱ni nꞌa ngu nꞌayu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nꞌa mbi döta nꞌár ma̱xte ár thuhu ar Andre, ár jödö ar Simu nöꞌö mi tꞌembabi ar Pedro, ne bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—ꞌBu̱kwa nꞌar bötsi hö ku̱tꞌa ya tsi thuhmesebada ne yoho ya tsi hwö. Te di no̱mbabiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nuꞌmú̱ ar Hesu bi ꞌñemba yá ma̱xte: —Xifu̱ ya jöꞌi da hñudi. Xa mi janu̱ ya do̱ni ne ka bi hñuhnu̱, mi tsu̱ ngu ngu̱dminthebe ya ñꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ne ar Hesu bi hñönga nuꞌu̱ ya tsi thuhme, bi umba njamödi Jö, ne bi hyemba yá ma̱xte. Nuyu̱ bi umba nuꞌu̱ mi hudi, ne bi japꞌu̱ ya hwö nꞌehe, mi tꞌumba gatho nöꞌö mi neꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Núꞌmu̱ mi niñö gatho ya jöꞌi, ar Hesu bi ꞌbe̱pa yá ma̱xte, ne bi ꞌñembabi: —Johu̱ nuya xe̱ni bi bongi ne hinte da mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bi goꞌu̱ ne bi ñuꞌsa ꞌre̱tꞌamayoho mꞌo̱tsꞌe ya xe̱ni thuhme bi bongwabi nuꞌu̱ xki ñuni. ");
INSERT INTO otqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nuya ñꞌo̱ho̱ꞌu̱ mi hyanda nuna döta ntꞌudinu̱ bi ꞌyo̱tꞌa ar Hesu, bi ꞌñeñꞌu̱: —Xa majöni go gehnu̱ ár mꞌe̱hni Jö ma nda e har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ar Hesu mi pötho mi ne nda zixꞌu̱ nda ꞌñexa ngu yá ndö. Jange nöꞌö bi mengi bi ma ba ꞌbu̱se̱ har tꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nu mi nxui ba kö yá ma̱xte, bi ma hár ñöni ar ñho̱nthe. ");
INSERT INTO otqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ne bi yu̱tꞌu̱ ha nꞌar motsa ndi maꞌu̱ Nkapernaum. Núꞌmu̱ mi ꞌyoꞌu̱ har dehe, xki mꞌe̱xui, har Hesu hinxki zo̱ta habu̱ mi ꞌbu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ne bi ñꞌo nꞌar ꞌyomndöhi, xa mi japi nda mpu̱nsa ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Núꞌmu̱ xki ꞌye̱tꞌu̱ ar motsa ngu yonꞌa̱tenthebe ya wëni ár yapꞌu̱, bi hyantꞌu̱ ar Hesu mi papꞌu̱ mi ꞌyo har dehe, ndi watꞌa har motsa, ne xa bi zuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ha nöꞌö bi ꞌñembabiꞌu̱: —Yo gi ntsuhu̱, go geke. ");
INSERT INTO otqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nuꞌmú̱ nuyu̱ xa bi njohya bi po̱ꞌsa ar Hesu har motsa, ne dama bi zo̱ñꞌu̱ hár ñöni ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nu ár hyaxꞌöpꞌu̱, nuya jöꞌi xki go ꞌrandi ar dehe, xki hyantꞌu̱ nꞌadar motsa mi ꞌbu̱hnu̱, ne ka xki manu̱ yá ma̱xte, ha nu ar Hesu hinxki me̱wiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nuꞌmú̱ bi zo̱ maꞌra ya motsa xki ꞌñe Tiberia, bi zo̱ñꞌu̱ getꞌu̱ habu̱ ar tsi Hmu xki umba njamödi Jö, ne xki ꞌwinga gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nu mi hyanda ya jöꞌi himi ꞌbu̱hnu̱ ar Hesu ne yá ma̱xte, bi bo̱xa ha ya motsa, ne bi maꞌu̱ Nkapernaum ma ba honi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nu mi dinga ar Hesu mi ꞌyo ꞌrandi ar dehe, bi ꞌñeñꞌu̱: —Utate, hamꞌu̱ ga tso̱kwa. ");
INSERT INTO otqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, gi hongagihu̱ ngetho da ꞌraꞌahu̱ ga tsihu̱ ar thuhme ne ga niñöhu̱, hinge gi honju̱ ngetho ga hyanthu̱ ya döta ntꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yo gi umba ri mu̱ihu̱ gi hoñhu̱ ar ñhuni ngutꞌa da thege. Umba ri mu̱ihu̱ gi hyoñhu̱ ar ñhuni unga ar te hiñhamꞌu̱ da götsꞌi, da ꞌraꞌahu̱ Nöꞌö Togo ba e bi Njöꞌi, ngetho go xi hñuxa Jö ár Dada da uñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nuꞌmú̱ bi ꞌñeñꞌu̱: —Tema mahyoni ga pe̱he, ne njapꞌu̱ ga pe̱he nöꞌö ne Jö ga o̱the. ");
INSERT INTO otqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ar Hesu bi dödi ne bi ꞌñenö: —Gehnu̱ ar ꞌbe̱fi ne Jö gi ꞌyo̱thu̱, gi ñꞌemu̱ihu̱ nöꞌö togo xpa pe̱ñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bi ꞌñeñꞌu̱ ꞌmu̱: —Tema ntꞌudi gi o̱tꞌe ga hanthe ne ga ñꞌemu̱iꞌihe. Tema döta ꞌbe̱fi gi pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Numa palehu̱ bi zi ar thuhme mi ta̱ mahetsꞌi núnu̱ ha ya otꞌatꞌo̱ho̱, ngu enga har tꞌofo: Bi umba ar thuhme ndi ꞌñe mhetsꞌi nda ziꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ar Hesu bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, ar Moise himbi ꞌraꞌahu̱ ar thuhme ndi ꞌñe mhetsꞌi. Ha numa Dada hö, ꞌraꞌahu̱ ar thuhme majöni di ꞌñe mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ngetho ar thuhme unga Jö, gehnu̱ nuna ba kö mhetsꞌi, ne umba ár te ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nuꞌu̱ bi ꞌñembabi: —Tsi Hmu, ꞌraje hyaxꞌmu̱ nunar thuhmeꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ne ar Hesu bi ꞌñembabiꞌu̱: —Nuga go dar thuhme ungar te. Gatho nuꞌu̱ togo da e da hyongagi, hiñhamꞌu̱ ma da ntunthu, ha nuꞌu̱ togo da ñꞌemu̱igi, hiñhamꞌu̱ ma da ntuthe. ");
INSERT INTO otqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngu xta xiꞌahu̱, mödi xka hyandgagihu̱, hingi ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gatho nuꞌu̱ togo xi ꞌraka Jö ma Dada, ma da e da hyongagi. Ha gatho nuꞌu̱ togo da e da zu̱kagi, hinga kotsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ngetho nuga xta kö mhetsꞌi, hinxta ehe ga o̱tꞌa nöꞌö di nese̱ga, xta e ga o̱tꞌa gatho nöꞌö ne togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Gehnu̱ ne ma Dada togo xpa pe̱nkagi, gatho nuꞌu̱ togo xi ꞌye̱ntkꞌa ha ma ꞌye̱ hinga ꞌbe̱di, ne nuya ngöxapa, ma ga koꞌspa yá te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nöꞌö togo xpa pe̱nkagi, neꞌö gatho nuꞌu̱ togo da hñuxka yá da̱ ár Tꞌu̱gi Jö, ne da ñꞌemu̱igi, pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi, ne nuga ga koꞌspa yá te ha ya ngöxapa. ");
INSERT INTO otqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nuꞌmú̱ nuya xodyo mi njontꞌane nꞌa ngu nꞌa, ngetho xki ꞌñeñꞌö: Nuga go dar thuhme xta kö mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne mi eñꞌu̱: —Ha hinga gehnu̱ ar Hesu ár tꞌu̱ ar Huse, di pöthwu̱ togo yá dada. Hanja emꞌu̱ xpa kö mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ar Hesu bi döti ne bi ꞌñembabiꞌu̱: —Yoꞌö gi ñöxhnathohu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngetho hinto tsa̱ da e da hyongagi nuꞌmu̱ hinda zopa ár mfeni Jö ma Dada togo xpa pe̱nkagi. Ne nuga ga koꞌspa ár te ha ya ngöxapa, ne da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Njawa xi ꞌyotꞌa yá mꞌe̱hni Jö har tꞌofo: Jö ma da uta gatho ya jöꞌi. Jange gatho nuꞌu̱ togo xi ꞌyo̱xa nöꞌö mönga ma Dada, ne xi zo hár mfeni, da e da hyongagi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hingi ꞌbu̱ nꞌa togo xi hyanda Jö ar Dada, ho̱nse̱ nöꞌö togo xpa pe̱hni. Nöꞌö hö, go xi hyanda ar Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Xa majöni di xiꞌahu̱, nu togo ñꞌemu̱igi pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nuga go dar thuhme ungar te. ");
INSERT INTO otqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nuya ri palehu̱ mamꞌe̱tꞌo bi zi ar thuhme mi ta̱ mhetsꞌi ha ya otꞌatꞌo̱ho̱, ne bi duꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nunar thuhme di xiꞌahu̱, hingi njapꞌu̱. Nunu̱ di ꞌñe mhetsꞌi, ne gatho nuꞌu̱ togo da zi, hinda ma da du. ");
INSERT INTO otqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nuga go dar thuhme ungar te xpa e mhetsꞌi. Nöꞌö togo da zi nuna thuhmenu̱, ma da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. Nunar thuhme di xiꞌahu̱, gehnu̱ ma ndoꞌyose̱ ga da̱, ne njapꞌu̱ ya meximha̱i da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nuya xodyo mi ntsa̱hñöki nꞌa ngu nꞌa mi eñꞌu̱: —Hanja da tsa̱ da ꞌrakagihu̱ ga tsafu̱ ár ndoꞌyose̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ar Hesu bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, nuꞌmu̱ hingi tsafu̱ ár ndoꞌyo ne hingi tsifu̱ ár ji Nöꞌö Togo ba e bi Njöꞌi, hinda nja ri tehu̱ hiñhamꞌu̱ thege. ");
INSERT INTO otqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nöꞌö togo tsaka ma ndoꞌyo ne tsika ma ji, pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi, ne ga koꞌspa ár te hár ngötsꞌi ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ngetho ma ndoꞌyo gehnu̱ ar ñhuni majöni, ne ma ji ar tsꞌithe majöni. Gehyu̱ unga ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nöꞌö togo tsaka ma ndoꞌyo ne tsika ma ji, ma ga ꞌbu̱ꞌbeꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Njangu Jö ar Dada togo ba pe̱nkagi hö ar te, nuga di te ngetho di ꞌbu̱ꞌbegaꞌö. Ha nuꞌu̱ togo da zaka ma ndoꞌyo, da nte nꞌehe ngetho di ꞌbu̱ꞌbegaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Go gehnu̱ ar thuhme di xiꞌahu̱ ba kö mhetsꞌi. Nöꞌö togo da zi, ma da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi, hinge njangu ri palehu̱ bi zi ar thuhme mi ta̱ mhetsꞌi, ne bi duꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nuya mhöyu̱ bi mönga ar Hesu núꞌmu̱ mi uta ya jöꞌi ha yá nijöꞌu̱ núnu̱ Nkapernaum. ");
INSERT INTO otqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nze̱ye̱ nuꞌu̱ togo mi te̱ni, mi ꞌyo̱xa njapꞌu̱ mi eñꞌu̱: —Xi ñhembi nöꞌö teme mö. Togo tsa̱ da ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ar Hesu mi pötho tema mi njontꞌane, ne bi ꞌñembabiꞌu̱: —Hage tso̱tꞌa ri mu̱ihu̱ nöꞌö di xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tema gi beñhu̱ nuꞌmu̱ gi hyanthu̱ Nöꞌö Togo ba e bi Njöꞌi, da mengi da bo̱xa mhetsꞌi habu̱ mi ꞌbu̱ꞌö mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ar hñö go unga ar te, ha nöꞌö bi e har ndoꞌyo hinte fa̱tsꞌi. Nuya mhö xta xiꞌahu̱ no̱nga ar hñö ne unga ar te. ");
INSERT INTO otqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ho̱nse̱, ꞌra hingi ñꞌemu̱ihu̱. Ngetho ar Hesu hár ndu̱i mi pötho togo himi ñꞌemu̱ibi, ne togo ma nda da̱. ");
INSERT INTO otqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne bi ꞌñenö: —Jange da eñꞌahu̱, hinto tsa̱ da e da hyongagi nuꞌmu̱ hinda zo ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mꞌe̱fa nze̱ye̱ nuꞌu̱ togo mi te̱ni, bi hye̱pꞌu̱ ne himi ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jange ar Hesu bi ꞌñemba nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte xki hwahni: —Hage gi ne gi möhu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ar Simu Pedro bi dödi ne bi ꞌñenö: —Tsi Hmu, togo manꞌa ga te̱ñhe. Ho̱nse̱ꞌi gi mönga ya mhö ungar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ha nuje xta ñꞌemu̱ihe ne xta pöhe go gar Kristo ár Tꞌu̱ꞌi Jö togo höse̱ ar te. ");
INSERT INTO otqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ar Hesu bi dödi: —Nuga da hwañꞌahu̱ gi ꞌre̱tꞌamayohohu̱. Mödi njapꞌu̱, nꞌa di hñöxꞌahu̱ ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nöꞌö mi no̱nga ar Huda Iskariote ár tꞌu̱ ar Simu, ngetho go ma nda da̱ꞌö, ne mi nꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mꞌe̱fa ar Hesu mi ꞌyo har ha̱i Ngalilea, himi ne nda mꞌu̱hnu̱ Nhudea ngetho ya xodyo mi honi nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mi ꞌba̱pꞌu̱tho ár da̱ngo ya xodyo nöꞌö ár thuhu, ar da̱ngo nguxiza. ");
INSERT INTO otqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nuyá jödö bi ꞌñemba ar Hesu: —Po̱ni di ma Nhudea, ne nuꞌu̱ togo te̱ñꞌaꞌi da hyanda nuya döta ntꞌudi gi o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ngetho nuꞌmu̱ nꞌar jöꞌi ne da ñꞌudi, hingi o̱tꞌa ar ꞌbe̱fi ñꞌöntho. Nuꞌge gi o̱tꞌa nuya döta ntꞌudiyu̱, ñꞌudi habu̱ gatho da hyantꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mi mönga njapꞌu̱ ngetho mödi ma yá jödö, himi ñꞌemu̱iꞌu̱ xki ꞌñexa Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Hingi tsa̱da ga manu̱, ha nuꞌahu̱ tsa̱da hamꞌu̱ gi ne gi möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nuya jöꞌi hingi tsa̱ da u̱tsaꞌihu̱, ha nuga hö u̱tsagi, ngetho di xipa yá tsꞌoꞌbe̱fi pe̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Di möhu̱ ar da̱ngo. Nuga hingi tsa̱da ga ma. ");
INSERT INTO otqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ho̱nse̱ bi xipabi njapꞌu̱, ne bi gohnu̱ Ngalilea. ");
INSERT INTO otqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nu mi wadi bi ma yá jödö, ar Hesu bi ma har da̱ngo nꞌehe, mödi bi ma ngu ñꞌöntho, himi ñꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nuya ndöxodyo mi honga har da̱ngo, ne mi eñꞌu̱: —Habu̱ bi ꞌyoꞌö ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ne nze̱ye̱ nuya mi ꞌbu̱hnu̱ mi no̱nga ar Hesu, ꞌra mi enö: Nunu̱ ar hogajöꞌi, ne maꞌra mi enö: Hingar hogajöꞌi, ngetho ka ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Txi ꞌramtxꞌu̱ mi ñöꞌu̱, ngetho mi tsu nuya ndöxodyo. ");
INSERT INTO otqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Xki tho ngu made ar da̱ngo, mi yu̱tꞌa ar Hesu har dönganijö ne mi uta ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nuya ndöxodyo xa mi ꞌyo̱tho ne mi eñꞌu̱: —Hanja pe̱ꞌsa nze̱ye̱ ar mfödinu̱, hiñhabu̱ xi ma xpa tꞌuti. ");
INSERT INTO otqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ar Hesu bi dötwabiꞌu̱ ne bi ꞌñenö: —Nöꞌö te di udi hingo di mönse̱ga, go ár me̱ti togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nuꞌu̱ togo ne da ꞌyo̱tꞌa nöꞌö ne Jö, da böꞌu̱ di utwa ár mhö Jö, hinge nöꞌö di bense̱ga. ");
INSERT INTO otqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nöꞌö togo bense̱ nöꞌö mö, ho̱nse̱ ne da tꞌeꞌspa ár nsu. Ha nöꞌö togo ne da tꞌeꞌspa ár nsu togo xpa pe̱hni, geꞌö mönga majöni ne hingar kate. ");
INSERT INTO otqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ar Moise bi ꞌraꞌahu̱ ar tꞌofo. Hinto xka ꞌyo̱thu̱ ngu mönga har tꞌofonu̱. Yoꞌö gi ne gi hyogagihu ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nuya jöꞌi xki mhuntsꞌi bi dödi ne bi ꞌñeñꞌu̱: —Gi pe̱ꞌsa ar tsꞌondöhi. Togo ne da hyoꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Ho̱nse̱ nꞌar ꞌbe̱fi da o̱tꞌe, ne xa gi ꞌyo̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ar Moise bi ꞌraꞌahu̱ ar nse̱gi gi huxu̱ ha ri ndoꞌyohu̱, mödi hingo mar me̱tiꞌö, már me̱ti ya pale. Ha nuꞌahu̱ gi huxu̱ ar nse̱gi mödi ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Núꞌmu̱ gi huꞌsfu̱ ar nse̱gi ri bötsihu̱, mödi ar pa ntsa̱ya̱, hingi nehu̱ gi tsꞌokwabihu̱ ár tꞌofo ar Moise. Xiꞌmu̱ hanja gi mbo̱ ri kwe̱hu̱ ngetho da o̱thebi gatho ár ndoꞌyo nꞌar ñꞌo̱ho̱ har pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Beñhu̱ xiñho hanja gi nthentehu̱, wa njapꞌu̱ wa hinꞌö. Yo ma gi nthentehu̱ ho̱nse̱ gi hanthu̱ nöꞌö oxa mañö. ");
INSERT INTO otqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ꞌRa ya me Herusalen mi eñꞌu̱: —Ha hinga gehnu̱ togo thoni da tho. ");
INSERT INTO otqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hyanthu̱ ꞌba̱hnu̱ madeda ya jöꞌi uti, ne hinte nsipabi. Hage xi ñꞌemu̱i ma ndöhu̱ go gehnu̱ ar Kristo ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngetho di pöhu̱ habu̱ xpa ehnu̱, ha nu xta e ar Kristo, hinto ma da bödi habu̱ di ꞌñehe. ");
INSERT INTO otqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Núꞌmu̱ mi ꞌyo̱ njapꞌu̱ ar Hesu, mi ꞌba̱hnu̱ mi uta ya jöꞌi har dönganijö, bi ñö ntsꞌe̱di ne bi ꞌñenö: —Gi pökagihu̱ ne gi pöhu̱ habu̱ dar mengu. Ha hinxta ese̱ga, xpa pe̱nkagi nöꞌö togo majöni, ne nuꞌahu̱ hingi pöhu̱ togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nuga hö di pödi, ngetho ka xta ehnu̱, ne ba pe̱nkagi ga ehe. ");
INSERT INTO otqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nuya ndöxodyo mi ꞌyo̱xa njapꞌu̱, xa mi ne nda gu̱hmöꞌu̱. Ne hinte bi japabi, ngetho hinxki zo̱ta ár pa. ");
INSERT INTO otqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ha nze̱ye̱ ya jöꞌi mi ꞌbu̱hnu̱ bi ñꞌemu̱ibi, ne mi eñꞌu̱: —Xi nu xta e ar Kristo, hage ma da döhö da ꞌyo̱tꞌa ya ntꞌudi ngu nuya xi ꞌyo̱tnu̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nuya de̱ngaꞌbe̱pate mi bödi mi no̱nga ar Hesu ya jöꞌi, nuyu̱ ne ya ndömöjö bi me̱ñꞌu̱ ya nsunijö ma nda gu̱hmö. ");
INSERT INTO otqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jange ar Hesu bi ꞌñenö: —Ho̱nse̱ maꞌra ya tsi pa ga ꞌbu̱hwihu̱, ne ga penga habu̱ bi ꞌbu̱ togo ba pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma gi hyongagihu̱ ne hingi tingagihu̱. Nu habu̱ gar maga, hinda tsa̱ gi möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nuꞌmú̱, nuya ndöxodyo mi ꞌbu̱hnu̱ mi enga nꞌa ngu nꞌaꞌu̱: —Habu̱ di manu̱ ꞌmu̱, enö hinda tsa̱ ga tiñhu̱. Hage ma da zu̱ nuꞌu̱ xi mfontꞌa ha yá ha̱i nuꞌu̱ hingya xodyo, ne da utꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tema di bo̱nga nöꞌö bi ꞌñenö: Ma gi hyongagihu̱ ne hingi tingagihu̱, ne nu habu̱ gar maga, hinda tsa̱ gi möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nöꞌö ar pa mar nsu ár ngötsꞌi ar da̱ngo, ar Hesu bi mꞌa̱i ne bi ñö ntsꞌe̱di bi ꞌñenö: —Nuꞌmu̱ ja togo tsu̱ ar duthe, da e da hyongagi da ntsithe. ");
INSERT INTO otqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nöꞌö togo ñꞌemu̱igi, ma da bo̱nga hár mu̱i ngu ya döthe ar dehe unga ar te, ngu mönga har Tꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ar Hesu mi no̱nga ár Hñö Jö, nöꞌö ma nda hñönga nuꞌu̱ togo nda ñꞌemu̱ibiꞌö. Ha nunár Hñö Jö hinxki etho, ngetho ar Hesu hinxki mengda hár nsunda mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nu mi ꞌyo̱xa njapꞌu̱ ya jöꞌi, ꞌra mi eñꞌu̱: —Xa majöni gehnu̱ ár mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Maꞌra mi enö: —Gehnu̱ ar Kristo. Ha maꞌra mi eñꞌu̱: —Hage di ꞌñe Ngalilea ar Kristo ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Hinꞌö, ngetho har Tꞌofo enö, ar Kristo ma nda e ha yá ꞌbe̱to ar Dabi mar mengu Belen. ");
INSERT INTO otqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mi nꞌañꞌo nꞌa ngu nꞌa yá mfeni mi no̱nga ar Hesu, jange ya jöꞌi bi ñhege. ");
INSERT INTO otqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ꞌRa mi ne nda gu̱mhö, ne hinte bi japabi. ");
INSERT INTO otqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nuꞌu̱ togo xki mꞌe̱hni nda gu̱hmö ar Hesu, bi mengi ma ba kꞌöꞌsa ya ndömöjö ne ya de̱ngaꞌbe̱pate. Ne nuya ndöyu̱ bi ꞌñeñꞌu̱: —Yoꞌö hinga tsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nuꞌu̱ xki ꞌbe̱hni bi dödi: —Hinda tsihe, ngetho da o̱he nöꞌö bi mö, ngu hinto manꞌa xi mönga njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nuꞌmú̱ nuya de̱ngaꞌbe̱pate bi döti ne bi ꞌñembabiꞌu̱: —Hage xi kaꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Gi pöhu̱ xiñho, hinjoꞌo nꞌar ndömöjö, wa nꞌar de̱ngaꞌbe̱pate xi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nuꞌu̱ togo xi ñꞌemu̱i, gehyu̱ nuꞌu̱ hingi pö ar tꞌofo, ne xi theke da mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ar Nikodemo, nöꞌö togo xki ma nxui ma ba kꞌönga ar Hesu, mar de̱ngaꞌbe̱pate nꞌehe, bi ꞌñemba nuꞌu̱ mi ꞌbu̱hnu̱: ");
INSERT INTO otqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Gi pöhu̱ numa tꞌofohu̱, hingi ho̱xa ár tsꞌoki nꞌar jöꞌi nuꞌmu̱ hinxi ꞌyo̱tsꞌe mꞌe̱tꞌo, ne xi bödi teme xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nuya ndömöjö ne yá mi de̱ngaꞌbe̱patewi bi ꞌñembabi: —Hage gar me Ngalilea nꞌehe. Hñetꞌa xiñho ar Tꞌofo, ne gi pödi hinxpa ehnu̱ Ngalilea nꞌár mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mi wa ar da̱ngo, nꞌa ngu nꞌa bi menga yá ngu. ");
INSERT INTO otqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ha nu ar Hesu bi ma har tꞌo̱ho̱ Njömdo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nu ár hyaxꞌö nꞌitho, ba penga manꞌagi har dönganijö, ne bi watꞌa ra nze̱ye̱ ya jöꞌi, bi hñuhnu̱ bi uti. ");
INSERT INTO otqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nꞌa mba epꞌu̱tho ya bötꞌofo ne ya de̱ngaꞌbe̱pate, mi tsimpa nꞌar ꞌbe̱hñö xki tsꞌu̱di mi ꞌbe̱ngwi nꞌar ñꞌo̱ho̱ himár döme. Bi mꞌa̱ꞌma madetho, ");
INSERT INTO otqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ne bi ꞌñembabiꞌu̱: —Utate, nunar ꞌbe̱hñönu̱ xi tsꞌu̱di mi ꞌbe̱ngwi nꞌar ñꞌo̱ho̱ himár döme. ");
INSERT INTO otqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ar Moise ꞌbe̱pkagihu̱ hár tꞌofo ga hohu̱ nkꞌahni nuya ꞌbe̱hñö njanu̱. Wa te gi mönge. ");
INSERT INTO otqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nuꞌu̱ bi mönga njapꞌu̱ mi honi nda hya̱thmö, mi ne nda dimbabi teme nda hyo̱tsꞌe. Ha nunar Hesu bi ñꞌani, bi ja ár ꞌye̱ mi otꞌa har ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ha nuꞌu̱ himi tsa̱ya̱ mi a̱mbabi. Nuꞌmú̱ ar Hesu bi mꞌa̱i ne bi ꞌñembabiꞌu̱: —Nöꞌö togo hinte ma tsꞌoki tu, dá du̱ꞌmi da unga ar nkꞌahni. ");
INSERT INTO otqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ne bi mengi bi ñꞌani mi otꞌa har ha̱i manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nu mi ꞌyo̱ njapꞌu̱, ba e ha yá mfenise̱ nuyá tsꞌoki xki ꞌyo̱tꞌu̱, ne ꞌramanꞌa bi bo̱ni bi maꞌu̱, mꞌe̱tꞌo bi bo̱nga nuꞌu̱ ya dönzia, mꞌe̱fa nu maꞌra mi bötsitho. Ho̱nse̱ bi gohnu̱ ar ꞌbe̱hñö mi ꞌba̱ made, ne ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mi mengi bi mꞌa̱ ar Hesu, hinto bi hyandi, ho̱nse̱ ar ꞌbe̱hñö mi ꞌba̱hnu̱, ne bi ꞌñembabi: —Habu̱ima nuꞌu̱ togo mi ho̱xꞌaꞌi. Hage hinto bi ne bi kꞌañꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Bi ꞌñeñꞌö: —Hinjoꞌo, tsi Tata. Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Nuga nꞌe, hinte di ho̱xꞌaꞌi. Di ma, ne yo ma gi pengi gi ꞌyo̱tꞌa ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ar Hesu bi mengi bi zo ya jöꞌi ne bi ꞌñembabiꞌu̱: —Nuga go dar ñotꞌiga di yotꞌwa ya meximha̱i. Nöꞌö togo da de̱ngagi, hinda ma da ñꞌo har ꞌbe̱xui, ngetho da yotꞌwabi ar ñotꞌi unga ar te. ");
INSERT INTO otqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nuꞌmú̱ nuya de̱ngaꞌbe̱pate bi ꞌñembabiꞌö: —Gi mönse̱ togoꞌi, jange hinga majöni nöꞌö gi mö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Mödi di mönse̱ togogi, majöni nuna di mö, ngetho nuga di pödi habu̱ xta ehe ne habu̱ gar ma. Nuꞌahu̱ hingi pöhu̱ habu̱ xta ehe wa habu̱ gar ma. ");
INSERT INTO otqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nuꞌahu̱ gi höxu̱ majöni ngu ri mfenise̱hu̱, ha nuga hinto di höꞌspa majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ha nuꞌmu̱ togo di höꞌspa majöni, nöꞌö di mö majöni ꞌmu̱, ngetho hindi höxase̱, di höxꞌbe ma Dada togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nu ha ri tꞌofohu̱ enö: Nuꞌmu̱ yoho ya jöꞌi nꞌatꞌwu̱ mö, majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nuga di da̱majöni togogi, ma Dada togo ba pe̱nkagi da̱majöni togogi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bi ꞌya̱mbabiꞌu̱: —Habu̱ bi ꞌbu̱ ri Dada. Ar Hesu bi dödi ne bi ꞌñenö: —Hingi pökagihu̱, ne hingi pöhu̱ ma Dada. Nuꞌmu̱ gi pökagihu̱hmö, gi pöhmöhu̱ togo ma Dada nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ar Hesu bi mönga njapꞌu̱ núꞌmu̱ mi uta ya jöꞌi núnu̱ habu̱ mi ꞌbu̱ ar mꞌe̱sbojö har dönganijö. Ne hinto bi tsa̱ bi gu̱, ngetho hinxki zo̱ta ar pa nda jwata ár ꞌbe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ar Hesu bi mengi bi ꞌñembabiꞌu̱: —Ma ga maga, ne nuꞌahu̱ gi hyongagihu̱hmö. Ha ma gi tuwi ri tsꞌokihu̱, ne hinda tsa̱ gi möhu̱ habu̱ gar maga. ");
INSERT INTO otqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nuya ndöxodyo mi ense̱ꞌu̱: —Hage ma da ñhose̱ ꞌmu̱. Hanja enö: Habu̱ gar maga, hinda tsa̱ gi möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nepꞌu̱ ar Hesu bi ꞌñembabiꞌu̱: —Nuꞌahu̱ ja gar menguhu̱wa, ha nuga xta e mañö mhetsꞌi. Nuꞌahu̱ ár me̱tiꞌihu̱ ar ximha̱i, ha nuga hingo ár me̱tigi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jange da xiꞌahu̱ ma gi tuwi ri tsꞌokihu̱, ngetho nuꞌmu̱ hingi ñꞌemu̱ihu̱ go geke, ma gi tuhu̱ gi tuxta ri tsꞌokihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nepꞌu̱ nuꞌu̱ bi ꞌñembabiꞌö: —Xiꞌge togoꞌi ꞌmu̱. Ar Hesu bi dödi ne bi ꞌñembabiꞌu̱: —Getꞌö ngu da xiꞌahu̱ har ndu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nuga mödi di pe̱ꞌsa maꞌra teme ga xiꞌahu̱, ne ga hösꞌa majöni ri mꞌu̱ihu̱, ho̱nse̱ di xiꞌahu̱ nöꞌö xi xikagi togo xpa pe̱nkagi. Gehnu̱ di mönga har ximha̱i, ne majöni nöꞌö möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ha nuꞌu̱ togo mi o̱tsꞌe, himbi böꞌu̱ mi no̱nga Jö ár Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jange ar Hesu bi ꞌñembabiꞌu̱: —Núꞌmu̱ xki tsu̱thu̱ Nöꞌö Togo ba e bi Njöꞌi gi hyohu̱, ma gi pöhu̱ ꞌmu̱ togo xa majöni go geke. Ne gi pöhu̱ nꞌehe hinte di o̱tꞌase̱. Nöꞌö ba utka ma Dada, gehnu̱ di xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Numa Dada togo ba pe̱nkagi hinxi hye̱gase̱, hyaxꞌmu̱ di ꞌbu̱ꞌbe, ngetho nuga di o̱tꞌa nöꞌö numañhoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Núꞌmu̱ mi mönga njapꞌu̱ ar Hesu, nze̱ye̱ ya jöꞌi bi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ar Hesu bi ꞌñemba nuꞌu̱ ya xodyo xki ñꞌemu̱i: —Nuꞌmu̱ gi ꞌñetꞌa xiñho ri mu̱ihu̱ ma mhö, xa majöni ma ñꞌowiꞌihu̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne ma gi pöhu̱ nöꞌö majöni, ha nuꞌmu̱ gi pöhu̱ nöꞌö majöni, gehnu̱ da xokꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nuꞌu̱ bi dödi ne bi ꞌñembabi: —Nuje yá ꞌbe̱togihe ar Abra. Hiñhamꞌu̱ xi jokagihe ngu togo yá me̱tigihe. Hanja gi enö da sogagihe. ");
INSERT INTO otqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ar Hesu bi dödi ne bi ꞌñenö: —Xa majöni di xiꞌahu̱, nöꞌö togo o̱tꞌa ar tsꞌoki, nunu̱ xi gotꞌatho ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nuꞌu̱ togo mꞌe̱gotho, hinda ma da go har ngu gatho ya pa. Ha nu ar tꞌu̱ hö, da gohnu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Njapꞌu̱tho nꞌehe, nuꞌmu̱ ár Tꞌu̱ Jö da gu̱kꞌahu̱ har tsꞌoki, majöni xka po̱ñhu̱, ne hinte koꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Di pödi yá ꞌbe̱toꞌihu̱ ar Abra. Mödi njapꞌu̱ gi ne gi hyogagihu̱, ngetho gi tsa̱mañꞌu̱hu̱ nöꞌö di xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nuga di mönga nöꞌö xi utkagi ma Dada, ha nuꞌahu̱ gi o̱thu̱ nöꞌö xi mönga ri dadahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nuꞌu̱ bi dödi ne bi ꞌñembabi: —Ma palehe ar Abra. Ar Hesu bi ꞌñembabiꞌu̱: —Nuꞌmu̱ yá ꞌbe̱toꞌihu̱ ar Abra, gi te̱mbahmöhu̱ ár ꞌbe̱fiꞌö ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ha nuꞌahu̱ mödi xta xiꞌahu̱ nöꞌö majöni xi xika Jö, gi ne gi hyogagihu̱. Ar Abra himbi ꞌyo̱tꞌa njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nuꞌahu̱ gi o̱thu̱ ngu o̱tꞌa ri dadahu̱. Nuꞌmú̱ nuꞌu̱ bi ꞌñemba ar Hesu: —Nuje hinge togatho di emfe ma dadahe. Ho̱nse̱ nꞌa ma Dada di ꞌñehe, gehnu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Nuꞌmu̱ ri Dadahu̱hmö Jö, gi mökagihu̱, ngetho xta e habu̱ bi ꞌbu̱ꞌö. Hinda ese̱, go ba pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hanja hingi tso ri mfenihu̱ nöꞌö di xiꞌahu̱. Hingi tso, ngetho xi njotꞌa ri mu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ar tsꞌondöhi go ri dadahu̱ꞌö, ne gi ne gi ꞌyo̱thwu̱ nöꞌö neꞌö. Hár ndu̱itho mar hyote ne ar hya̱te, hiñhamꞌu̱ mönga nöꞌö majöni. Núꞌmu̱ mönga ya nhemhñö, go bense̱, ngetho ar nemhñö, ne go bi du̱ꞌma ar nhemhñöꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nuꞌahu̱ hingi ñꞌemu̱igihu̱, ngetho di mönga nöꞌö majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hinjoꞌö togo da tsa̱ te gi hyo̱xkagihu̱ nꞌar tsꞌoki. Nuꞌmu̱ di mönga nöꞌö majöni, yoꞌö hingi ñꞌemu̱igihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nuꞌu̱ togo yá me̱ti Jö, o̱twa ár mhö. Hingi ne gi ꞌyo̱ꞌspabihu̱, ngetho hingo yá me̱tiꞌihu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nepꞌu̱ nuya xodyo bi dödi ne bi ꞌñembabi: —Hage hinge majöni nöꞌö di xiꞌahe, gar me Nsamaria ne xka nthe̱xkwi nꞌar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ar Hesu bi dödi ne bi ꞌñenö: —Hindi nthe̱xꞌbega nꞌar tsꞌondöhi. Nuga di numansu ma Dada, ha nuꞌahu̱ hingi numansugihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nuga hindi mönga njapꞌu̱ di honi gi ꞌñeskagihu̱ ma nsu. Ngetho ꞌbu̱ nꞌa togo eskagi, ne go ma da hñöxmajöniꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Xa majöni di xiꞌahu̱, nöꞌö togo o̱tꞌa nöꞌö di mö, hiñhamꞌu̱ da du. ");
INSERT INTO otqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nuꞌmú̱ ya xodyo bi ꞌñembabi: —Nupya hö, di pöhe gi nthe̱xkwi nꞌar tsꞌondöhi. Ngetho ar Abra bi du, nuyá mꞌe̱hni Jö bi duꞌu̱ nꞌehe. Hanja gi enö, nöꞌö togo da ꞌyo̱tꞌa nöꞌö gi mö, hiñhamꞌu̱ da du. ");
INSERT INTO otqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Hage ri nsu töpa ár nsu ar Abra ꞌmu̱. Ngetho bi duꞌö ne yá mꞌe̱hni Jö bi duꞌu̱ nꞌehe. Tema nsu gi beni gi pe̱ꞌske ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ha nu ar Hesu bi dödi ne bi ꞌñenö: —Nuꞌmu̱ ga exase̱ ma nsu, po̱ntho hinter me̱ꞌö. Numa Dada go eska ma nsu, nöꞌö togo gi emfu̱ ri Jöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ha nuꞌahu̱ hingi pöhu̱ togoꞌö. Nuga hö di pödi. Nuꞌmu̱ ga enö hindi pödi, gar nemhñöhmö nguꞌahu̱, ngetho di pödi ne di o̱twa ár mhö. ");
INSERT INTO otqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri palehu̱ ar Abra xa mi johya, mi to̱ꞌma nda zo̱nga ar pa nga ꞌbu̱kwa har ximha̱i, ne bi njohya bi hyandi. ");
INSERT INTO otqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nuya xodyo bi ꞌñembabiꞌö: —Hinxka jwata madenthebe nje̱ye̱. Hanja tsa̱ xka hyanda ar Abra. ");
INSERT INTO otqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ar Hesu bi ꞌñembabiꞌu̱: —Xa majöni di xiꞌahu̱, ndi ꞌbu̱ka mamꞌe̱tꞌo núꞌmu̱ hinxki mꞌu̱ta ar Abra. ");
INSERT INTO otqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jange nuꞌu̱ bi gu̱xya do nda kꞌahmö. Ha nunar Hesu bi ñꞌöni, bi bo̱nga har nijö bi thota madetho bi ma. ");
INSERT INTO otqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nu mi panu̱ ar Hesu, bi hyandi mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ xki mꞌu̱i mi goda̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nuyá ma̱xte bi ꞌya̱mbabiꞌö ne bi ꞌñeñꞌu̱: —Utate, togo bi ꞌyo̱tꞌa ar tsꞌoki ne bi mꞌu̱i goda̱, gese̱nu̱ wa yá dada. ");
INSERT INTO otqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ar Hesu bi dödi ne bi ꞌñenö: —Hingo ár tsꞌokinu̱, ne hingo ár tsꞌoki yá dada nꞌehe. Ngetho njanu̱ nda nheki ár döta ꞌbe̱fi Jö hár teꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Núpya mpa, mahyoni ga pe̱pa ár ꞌbe̱fi nöꞌö togo ba pe̱nkagi. Ba epꞌu̱ ar xui núꞌmu̱ hinto tsa̱ da mpe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Núpya di ꞌbu̱kwa har ximha̱i, go dar ñotꞌiga di yotꞌwa ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mi wadi bi mönga njapꞌu̱, bi ntsojni har ha̱i, bi ꞌñötꞌa ar bo̱ha̱i. Ne bi goꞌspa ha yá da̱ ar ñꞌo̱ho̱ mi goda̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ne bi ꞌñembabi: —Di ma ba peka ri da̱ har po̱the Siloe (nunar thuhuꞌö po̱ni da ꞌñenö, xi mꞌe̱hni). Bi maꞌö ma ba peka ár da̱, ne mba pengi mi tsa̱ nda hyandi. ");
INSERT INTO otqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nuꞌmú̱ nuyá nꞌangu ne nuya jöꞌi xki hyandi mi goda̱, mi eñꞌu̱: —Hage hinga gehnu̱ togo mi hudi mi pe̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ꞌRa mi enö mi geꞌö, maꞌra mi enö ndi hñötsꞌi. Nöꞌö mi ense̱: —Go geke. ");
INSERT INTO otqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ne bi tꞌembabi: —Hanja xi xo ri da̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nöꞌö bi dödi ne bi ꞌñenö: —Nu ar ñꞌo̱ho̱ ár thuhu ar Hesu, bi ꞌñötꞌa ar bo̱ha̱i, bi goska ma da̱, ne bi ꞌñengagi: Di ma har po̱the Siloe ba peka ri da̱. Nuga da ma da peke, ne bi tsa̱ da handi. ");
INSERT INTO otqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nuꞌu̱ bi ꞌya̱mbabi: —Habu̱ bi ꞌbu̱ꞌö. Bi döꞌö ne bi ꞌñenö: —Hindi pödi. ");
INSERT INTO otqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ya jöꞌi bi ziꞌspa ya de̱ngaꞌbe̱pate nöꞌö mar goda̱hmö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ha nöꞌö ar pa xki ꞌñötꞌa ar bo̱ha̱i ar Hesu, ne xki xokwa ár da̱ ar ñꞌo̱ho̱ mi goda̱, mar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nuya de̱ngaꞌbe̱pate bi ꞌya̱mbabi nꞌehe hanja xki dixa ár da̱. Nöꞌö bi dödi ne bi ꞌñenö: —Bi goska ar bo̱ha̱i ha ma da̱, da ma da peke, ne bi za̱ da handi. ");
INSERT INTO otqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ꞌRa ya de̱ngaꞌbe̱pate mi eñꞌu̱: —Nunar ñꞌo̱ho̱nu̱ hinxpa pe̱hna Jö, ngetho hingi japamasu ar pa ntsa̱ya̱. Ha maꞌra mi enö: —Nuꞌmu̱ nꞌar ꞌyo̱tꞌatsꞌokihmö, hage da tsa̱ da ꞌyo̱tꞌa nuya döta ntꞌudiyu̱. Ne njapꞌu̱ bi ñheꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nepꞌu̱ bi mengi bi tꞌembabi ar ñꞌo̱ho̱ mi goda̱hmö: —Xiꞌge, tema gi enge togo bi xokꞌa ri da̱. Nöꞌö bi dödi ne bi ꞌñenö: —Gehnu̱ nꞌár mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ha nuya ndöxodyo himi ñꞌemu̱i mar goda̱ ne xki xo yá da̱, jange bi zompabi ár dada ne ár nönö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ne bi ñꞌa̱ñꞌu̱: —Hage go gehnu̱ ri tꞌu̱hu̱ gi eñhu̱ bi mꞌu̱i mi goda̱. Xiꞌmu̱, hanja hantya. ");
INSERT INTO otqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nuyá dada bi ꞌñeñꞌu̱: —Di pöhe xiñho, go gehnu̱ ma tꞌu̱he bi mꞌu̱i mi goda̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nuje hindi pöhe hanja hantya, wa togo bi xokwabi ár da̱. Pe̱ꞌsa yá je̱ye̱, ꞌya̱mbabihu̱ꞌö, tsa̱ da döse̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bi mönga njapꞌu̱ yá dada, ngetho mi tsu ya ndöxodyo, hinge nda hye̱gi nda yu̱tꞌa ha yá nijöꞌu̱. Ngetho nuya ndö xki ꞌyo̱tꞌa nꞌar nkohiꞌu̱, mi enö, nöꞌö togo nda ꞌñemba ar Hesu mar Mesia, mi to̱ꞌmi nda tꞌe̱nga har nijö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jange bi ꞌñenga yá dada: Pe̱ꞌsa yá je̱ye̱, ꞌya̱mbase̱hu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nuꞌmú̱ bi mengi bi tsꞌohna nunar ñꞌo̱ho̱ mar goda̱hmö ne bi tꞌembabi: —Umba njamödi Jö. Di pöhe xiñho, nunar ñꞌo̱ho̱ togo bi xokꞌa ri da̱, nꞌar ꞌyo̱tꞌatsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nöꞌö bi dödi ne bi ꞌñenö: —Hindi pöka hage ar ꞌyo̱tꞌatsꞌoki wa hinꞌö. Ho̱nse̱ di pöka ndar goda̱, ha nupya di handi. ");
INSERT INTO otqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bi mengi bi tꞌa̱mbabi manꞌagi: —Tema bi jaꞌaꞌi. Hanja bi xokꞌa ri da̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nöꞌö bi dödi ne bi ꞌñembabiꞌu̱: —Xta xiꞌahu̱, mödi hinxka ne xka ꞌyo̱xu̱. Yoꞌö gi ne gi ꞌyo̱hu̱ manꞌagi. Ha gi ne gi te̱ñhu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nuꞌu̱ bi zani ne bi ꞌñembabi: —Nuꞌge go gi te̱nge. Di te̱nje ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Di pöhe Jö bi zo ar Moise, ha nunar ñꞌo̱ho̱nu̱ hindi pöhe habu̱ xpa ehe. ");
INSERT INTO otqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nunar ñꞌo̱ho̱ mar goda̱hmö bi dödi ne bi ꞌñenö: —Tenguꞌö, nuꞌahu̱ hingi pöhu̱ habu̱ xpa ehe, ha nuga bi xoga ma da̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Di pöhu̱ xiñho, Jö hingi o̱xa ya ꞌyo̱tꞌatsꞌoki. Ha nuꞌu̱ togo tsupi ne o̱tꞌa ngu neꞌö, hö o̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hiñhamꞌu̱ xta o̱hu̱ nꞌa togo xi xokwa yá da̱ nꞌa xi mꞌu̱ goda̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nuꞌmu̱ hinxpa pe̱hna Jö nunar ñꞌo̱ho̱nu̱, hinte xi tsa̱hmö xi ꞌyo̱tꞌa nöꞌö xi ꞌyo̱tꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ha nuꞌu̱ bi dödi ne bi ꞌñembabi: —Nuꞌge ga mꞌu̱hwi ar tsꞌoki. Tema da za̱ gi utkagihe. Ne bi ꞌye̱ñꞌu̱ har nijö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ar Hesu bi ꞌyo̱de xki tꞌe̱nga har nijö nöꞌö mar goda̱hmö. Bi ma ba honi, ne nu mi dini bi ꞌñembabi: —Ha gi ñꞌemu̱ibi ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nöꞌö bi dödi ne bi ꞌñenö: —Ndada, togoꞌö ne ga ñꞌemu̱ibi. ");
INSERT INTO otqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ne bi ꞌñenga ar Hesu: —Xka hyandi. Nöꞌö togo gi ñöwipya go geꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nöꞌö mar goda̱hmö bi ꞌñenö: —Tsi Hmu, di ñꞌemu̱iꞌi. Ne bi nda̱ndihmö bi nsunda. ");
INSERT INTO otqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ar Hesu bi ꞌñenö: —Nuga xta ekwa har ximha̱i ga o̱tꞌa ar tsꞌu̱tꞌwi. Njapꞌu̱ nuꞌu̱ goda̱ da xo yá da̱, ha nuꞌu̱ xo yá da̱ da ngoda̱. ");
INSERT INTO otqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nuꞌmú̱ ꞌra ya de̱ngaꞌbe̱pate mi ꞌbu̱hnu̱, bi ꞌyo̱ nöꞌö bi möñꞌö ne bi ꞌñembabi: —Xi nuje, hage dar goda̱he nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ar Hesu bi ꞌñembabiꞌu̱: —Nuꞌmu̱ gar goda̱hu̱hmö, hinte ma tsꞌoki gi tuhu̱. Ngetho gi eñhu̱ gi hanthu̱, jange gi tuda ri tsꞌokihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Xa majöni di xiꞌahu̱, nöꞌö togo hingi ku̱tꞌa hár goxthi ár nguñꞌo ya de̱ti, ne po̱xta har jödo, nꞌar bë ne ar da̱kate. ");
INSERT INTO otqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ha nöꞌö togo ku̱tꞌa har goxthi, gehnu̱ ar ma̱ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ar sugoxthi xokwabi, ne ya de̱ti pötwa ár mhö ar ma̱ꞌyo. Ne nunu̱ da zopa yá thuhu nꞌa ngu nꞌa, ne da gu̱ki. ");
INSERT INTO otqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu xta bo̱nga nthi gatho yá me̱ti, da mꞌe̱tꞌo ar ma̱ꞌyo, ne nuya de̱ti te̱ni, ngetho pötwa ár mhö. ");
INSERT INTO otqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ne nuyá de̱ti hingi te̱nga ya nꞌañꞌo ma̱ꞌyo, da nixtꞌi ngetho hingi pö ya nꞌañꞌo mhö. ");
INSERT INTO otqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nunar ꞌbedenu̱ bi xipabiꞌu̱ ar Hesu, mödi himbi böꞌu̱ teme mi ne nda xipabi. ");
INSERT INTO otqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jange ar Hesu bi mengi bi xipabiꞌu̱: —Xa majöni di xiꞌahu̱, nuga go dar goxthigi habu̱ ku̱tꞌa ya de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gatho nuꞌu̱ togo xi zo̱ mꞌe̱tꞌo, núꞌmu̱ hinge ndi tso̱tka, ma ya bë ne ya da̱kate, ne nuya de̱ti himbi ꞌyo̱te. ");
INSERT INTO otqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nuga go dar goxthi. Nöꞌö togo da yu̱tꞌa har goxthiꞌö da mpo̱ho̱, di ku̱tꞌi ne di po̱ni, ne xta bo̱ni da dinga te da zi. ");
INSERT INTO otqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nꞌar bë ho̱nse̱ bi ehe da mpë, da ñhote ne da hwati. Ha nuga xta ehe ga unga ar te, hinge nꞌar tetho, nꞌar hoga te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nuga go dar hoga ma̱ꞌyo. Ar hoga ma̱ꞌyo e̱ntꞌa ár te da ñönga yá de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ha nöꞌö togo mꞌe̱gotho ne hingar ma̱ꞌyoꞌö, hingo yá me̱ti ya de̱ti, xta hyandi da e ar miñꞌo, da nixtꞌi da zopꞌu̱ ya de̱ti. Ha nunar miñꞌo da fontꞌi habu̱ gatho da ma. ");
INSERT INTO otqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Njapꞌu̱ nöꞌö togo mꞌe̱gotho, da nixtꞌi da ma, ngetho ger ꞌbe̱go hingi tupa ár mu̱i te da ja ya de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nuga go dar hoga ma̱ꞌyo, ne di pödi togo ma de̱ti, ne numa de̱ti pökagi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jangutho ar Dada pökagi, ne nuga di pökaꞌö, ne di e̱ntꞌa ma te ga ñönga ma de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ne ꞌbu̱ maꞌra ma de̱ti nuꞌu̱ hingya mengu nunar nguñꞌonu̱. Nuꞌu̱ nꞌehe ma ga tsihi, ma da ꞌyo̱ ma mhö. Nꞌadar mhuntsꞌi ma da nja, ne nꞌadar ma̱ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jö ar Dada xa mökagi ngetho di unga ma te, ne ga pengi ga hönga manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hinto da hñömga ma te, nuga go di unse̱. Di pe̱ꞌsa ar tsꞌe̱di ga uni, ne di pe̱ꞌsa ar tsꞌe̱di ga hönga manꞌagi. Njapꞌu̱ bi ꞌbe̱pkagi ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nuya xodyo bi mengi bi ñöxhnatho ngetho bi ꞌyo̱xa nöꞌö bi mönga ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nze̱ye̱ mi eñꞌu̱: —Nthe̱xkwi nꞌar tsꞌondöhi ne xi ꞌbe̱ ár mfeni. Yoꞌö gi japamasuhu̱ gi o̱xu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ha maꞌra mi enö: —Nuya te mö, hinda tsa̱ da mönga nꞌa togo di nthe̱xkwi nꞌar tsꞌondöhi. Ha nꞌar tsꞌondöhi hinda tsa̱ da xokwa yá da̱ ya goda̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Núnu̱ Herusalen mi ta̱tꞌa nꞌar da̱ngo mfeni, mi fenga ar pa xki mengi xki nꞌaꞌyo manꞌagi ar nijö, ne nuya paꞌu̱ mar ntse̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ha nu ar Hesu mi ꞌyonu̱ hár mꞌetꞌe ar dönganijö, tꞌembabi ár mꞌetꞌe ar Salomon. ");
INSERT INTO otqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nuya ndöxodyo xa bi gotꞌatho ne bi ꞌñembabi: —Hamꞌu̱ ma gi hye̱gagihe gi jaje di yomihe. Nuꞌmu̱ xa majöni go gar Kristo, xikagihe nꞌagitho. ");
INSERT INTO otqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ar Hesu bi dödi: —Xta xiꞌahu̱, ne hingi ne gi ñꞌemu̱ihu̱. Nuya ꞌbe̱fi di pe̱fi di po̱ta ma Dada, ka nhekipꞌu̱ togogi, ngu xta xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ne ngu xta xiꞌahu̱, nuꞌahu̱ hingi ñꞌemu̱igihu̱, ngetho hingo ma de̱tiꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nuya ma de̱ti o̱xa ma mhö. Di pökaꞌu̱, ha nuꞌu̱ te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne di umba ar te hiñhamꞌu̱ da götsꞌi, hiñhamꞌu̱ ma da mꞌe̱di, ne hinto tsa̱ da zimga ha ma ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Numa Dada togo bi ꞌrakagi, xa döta ár tsꞌe̱di, ne hinto tsa̱ da zimba hár ꞌye̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nuga ne ma Dada di nꞌathoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mi ꞌyo̱xa njapꞌu̱ ya ndöxodyo, bi mengi bi gu̱xya do, mi ne nda hyo̱xya nkꞌahni. ");
INSERT INTO otqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nuꞌmú̱ ar Hesu bi ꞌñembabiꞌu̱: —Nze̱ye̱ ya hoga ꞌbe̱fi xta o̱tꞌe bi pe̱hna ma Dada. Tema ꞌbe̱fiꞌö hingi hanthu̱ xiñho, ngetho gi ne gi kꞌankagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nuꞌu̱ bi dödi ne bi ꞌñenö: —Hindi ne ga kꞌañꞌahe ngetho gi o̱tꞌa ya hoga ꞌbe̱fi. Di ne ga o̱the ngetho gi hökwa ár nsu Jö. Gar jöꞌi nguje, ne gi ñhuxkwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ar Hesu bi dötwabiꞌu̱: —Ha hingi enga njawa ha ri tꞌofohu̱: Nuga da enö: Nuꞌahu̱ gar jöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nuꞌmu̱ bi hñuꞌspabi ya jö nuꞌu̱ togo bi umba ár mhö, ha nunar Tꞌofo bi zoju̱ Jö hinto tsa̱ da ꞌñenö hinga majöni, ");
INSERT INTO otqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nuga togo xpa e̱ntkꞌagi ne xpa pe̱nkagi Jö ar Dada, hanja gi engagihu̱ di hökwa ár nsu, ho̱nse̱ da mönga ár Tꞌu̱gi Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nuꞌmu̱ hindi o̱tꞌwa ár ꞌbe̱fi ma Dada, yo gi ñꞌemu̱igihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ha nuꞌmu̱ di o̱tꞌwabi, mödi hingi ñꞌemu̱igihu̱, ñꞌemu̱ihu̱ nuya ꞌbe̱fi di o̱tꞌe, ne njapꞌu̱ gi ꞌñetꞌa ri mu̱ihu̱ gi pöhu̱ di ꞌbu̱ꞌbe Jö ar Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Manꞌagi ya ndöxodyo mi nehmö nda gu̱, ha bi kꞌotꞌi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nepꞌu̱ ar Hesu bi mengi bi ma ꞌrandi ar döthe Hordan, habu̱ mꞌe̱tꞌo mi xixthehmö ar Xuwa, ne ka ba kohnu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne nze̱ye̱ ya jöꞌi mi pa mi tsu̱di, ne mi eñꞌu̱: —Majöni nunar Xuwa hinte ma ntꞌudi bi ꞌyo̱tꞌe. Mödi njapꞌu̱, gatho nöꞌö bi xikagihu̱ mi no̱nga ar Hesu, xi tho njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ne nze̱ye̱ ya jöꞌi bi ñꞌemu̱inu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mi hñenga nꞌar ñꞌo̱ho̱ már thuhu Lasaro me Betania, ar tꞌu̱lo hnini habu̱ mar mengu ar Maria, ne ár juhwe̱ ár thuhu ar Marta. ");
INSERT INTO otqNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ar Lasaro nöꞌö mi hñeni, már indö ar Maria, togo xki goꞌspa ar hogañu̱ni hár wa ar Hesu, ne mi ju̱ yá xtö mi thukwabi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nuya ꞌbe̱hñö mi njuhwe̱ bi me̱mpa ar mhö nda nsipa ar Hesu njawa: —Tsi Hmu, nöꞌö togo xa gi mödi hñeni. ");
INSERT INTO otqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mi nsipa ar Hesu njapꞌu̱ ne bi ꞌñeñꞌö: —Nunar hñeninu̱ hingar ndöte. Njapꞌu̱ ma da nheki ár nsunda Jö, ne njapꞌu̱ da nsundabi ár Tꞌu̱ Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ha nu ar Hesu xa mi mö ar Marta, ár juhwe̱ ne ár jödö Lasaro, nuya hñuyu̱ mi nku. ");
INSERT INTO otqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ne núꞌmu̱ mi ꞌyo̱ mi hñenga ar Lasaro, bi gohnu̱ ma yopa habu̱ mi ꞌbu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mi tho nuya yopa, ar Hesu bi ꞌñemba yá ma̱xte: —Möhö Nhudea manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nuyá ma̱xte bi ꞌñembabi: —Utate, hingar yapa nuya ndöxodyo mi ne nda hyoꞌa nkꞌahnitho. Yoꞌö gi ne gi penga injanu̱ manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ar Hesu bi dödi ne bi ꞌñenö: —Hage hingi pöhu̱, nunar pa pe̱ꞌsa ꞌre̱tꞌamayoho xe̱nimpa. Nuꞌu̱ togo ꞌyo ꞌbu̱ mpa, hingi nthe̱wi ya mfetsꞌe, ngetho yotꞌwa ar ñotꞌi yotꞌa ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ha nöꞌö togo ꞌyo ꞌbu̱ xui, da nthe̱wi ya mfetsꞌe, ngetho hiñꞌothobi ar ñotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mi wadi bi xipabi njapꞌu̱, bi ꞌñembabi nꞌehe: —Ma tsi ñꞌohu̱ Lasaro öhö. Ma ga a̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nuyá ma̱xte bi ꞌñemꞌu̱: —Tsi Hmu, nuꞌmu̱ ötho, da dixꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nunar Hesu mi no̱mba ár ndöte ar Lasaro, ha nuꞌu̱ mi hu yá mu̱i ar tꞌöhötho. ");
INSERT INTO otqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nuꞌmú̱ ar Hesu bi ꞌñembabi xiñho: —Ar Lasaro xi du. ");
INSERT INTO otqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Di johya hinda ꞌbu̱hnu̱ núꞌmu̱ mi hñeni. Gehnu̱ ri ñhohu̱, ngetho njanu̱ da te ri ñꞌemu̱ihu̱. Möhö ma ga kꞌöꞌsu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nuꞌmú̱ bi ꞌñenga ar Toma nöꞌö mi tꞌembabi ar Didimo ngetho xki mꞌu̱hwi manꞌár ku, bi ꞌñemba nuyá mima̱xtewi: —Möhö nꞌehe, ga tuwihu̱ mahye̱giꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mi zo̱nga ar Hesu habu̱ mi ꞌbu̱ ar Lasaro, bi nsipabi mi pe̱ꞌsa goho mpa xki tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ar hnini Betania ꞌbu̱ getꞌu̱ ar hnini Herusalen, ngu nꞌa̱tenthebe ya wëni ár yapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne nze̱ye̱ ya xodyo xki ma ba kꞌöꞌsa ar Marta ne ar Maria, nda hñuꞌmba yá mu̱i ngetho xki du yá indö. ");
INSERT INTO otqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nu mi ꞌyo̱ ar Marta ndi ꞌñe ar Hesu hár ngu, bi ma ba thödi. Ha nunar Maria bi gota har ngu. ");
INSERT INTO otqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ne ar Marta bi ꞌñemba ar Hesu: —Ma tsi Hmuꞌi, nuꞌmu̱ xka ꞌbu̱hmöwa, ma indö hinxi duhmö. ");
INSERT INTO otqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mödi di pöpya nꞌehe, gatho nöꞌö te gi ꞌya̱pa Jö da ꞌraꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ha ar Hesu bi ꞌñembabi: —Ri indö ma da mengi da nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nepꞌu̱ ar Marta bi ꞌñembabi: —Di pödi, har ngöxpa ma da mengi da ntenu̱, xta mengi da nte gatho nuꞌu̱ xi du. ");
INSERT INTO otqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ar Hesu bi ꞌñembabi: —Nuga di ju̱xa nuꞌu̱ xi du, ne di unga ar te. Nuꞌu̱ togo ñꞌemu̱igi, mödi xi du, da mengi da nte. ");
INSERT INTO otqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nuꞌu̱ togo ꞌbu̱i ne ñꞌemu̱igi, hiñhamꞌu̱ da du. Ha gi ñꞌemu̱i nöꞌö di xiꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ar Marta bi ꞌñembabi: —Hö tsi Hmuꞌi, di ñꞌemu̱i go gar Kristo ár Tꞌu̱ Jö, ndi to̱ꞌmhe nda ekwa har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ngu mi wadi bi mönga njapꞌu̱ ar Marta, dama ba xipa ar Maria ár juhwe̱, txi ꞌramtxꞌu̱ bi ꞌñembabi: —Xi zo̱kwa ar Utate ne to̱pꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nu mi ꞌyo̱ꞌö, dama bi mꞌa̱i ma ba kꞌötsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ar Hesu hinxki yu̱tꞌatho har hnini, ka xki gohnu̱tho habu̱ ma ba thö ar Marta. ");
INSERT INTO otqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ha nuya xodyo mi ꞌbu̱hnu̱ hár ngu ar Maria mi huꞌmba ár mu̱i, mi hyantꞌu̱ dama bi nangi bi bo̱nga har ngu, bi de̱ñꞌu̱, ne mi enga nꞌa ngu nꞌa: —Di ma da nzonga hár tꞌa̱gi ár indö. ");
INSERT INTO otqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ar Maria nu mi zo̱nga habu̱ mi ꞌbu̱ ar Hesu, mi hyandi bi nda̱ndihmö hár wa, ne bi ꞌñenö: —Ma tsi Hmuꞌi, nuꞌmu̱ xka ꞌbu̱kwa, hinxi duhmö ma indö. ");
INSERT INTO otqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nu mi hyanda ar Hesu xa mi zonga ar Maria, ne nuya xodyo mi ñꞌowi xa mi zoñꞌu̱ nꞌehe, xa bi ko ár mu̱i ne xa bi za̱mañꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne bi ꞌñeñꞌö: —Habu̱ ga ꞌya̱hu̱. Nuꞌu̱ bi ꞌñembabi: —Ma tsi Hmuꞌihe, ba e gi hyandi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ne ar Hesu bi nzoni. ");
INSERT INTO otqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nuya xodyo bi ꞌñenga nꞌa ngu nꞌa: —Hyanthu̱ tengu mi mödi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ꞌRa bi ꞌñeñꞌu̱: —Gehnu̱ togo bi xokwa ár da̱ ar goda̱. Hage hinge mi tsa̱ te nda me̱fi ne hinxi duhmö ar Lasaro. ");
INSERT INTO otqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ar Hesu xa bi za̱mañꞌu̱ manꞌagi, bi ma ba kꞌöꞌspa ár tꞌa̱gi, mi ꞌbu̱ ha nꞌar oki, ne mi kota nꞌar döta do. ");
INSERT INTO otqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Bi ꞌñenga ar Hesu: —Hñöju̱ ar do. Ha nu ar Marta ár nju nöꞌö xki du, bi ꞌñenö: —Ma tsi Hmuꞌi, xi xötꞌi, ngetho pe̱ꞌsa goho mpa xi du. ");
INSERT INTO otqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ar Hesu bi ꞌñembabi: —Ha hinxta xiꞌi, nuꞌmu̱ gi ñꞌemu̱i ma gi hyandwa ár nsunda Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nepꞌu̱ nuya jöꞌi bi hñöka nöꞌö ar do mi kotꞌa ár goxthi habu̱ xki tꞌa̱ ar Lasaro, ne ar Hesu bi no̱ꞌsa mhetsꞌi ne bi ꞌñenö: —Ma tsi Dadaꞌi, di jamödi xka ꞌyo̱xa nöꞌö xta a̱ꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Di pödi hyaxꞌmu̱ gi o̱xkagi. Núꞌmu̱ da mönga njapꞌu̱, di honga nuya nze̱ ya jöꞌi xi mhuntsꞌi, da ñꞌemu̱i go xka pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mi wadi bi mönga njapꞌu̱, bi mafi ntsꞌe̱di ne bi ꞌñenö: —Lasaro, po̱nga nthi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ne nöꞌö xki duhmö, ba po̱ni mi so̱tꞌa ya xu̱ni dutu yá ꞌye̱ ne yá wa, ne mi ꞌba̱xa nꞌar nthuꞌmxi ár ñö. Ar Hesu bi ꞌñemba ya jöꞌi: —Xothwu̱ ya dutu, hye̱hu̱ da ma. ");
INSERT INTO otqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nze̱ye̱ ya xodyo nuꞌu̱ ma ba huꞌmba ár mu̱i ar Maria, mi hyantꞌu̱ nöꞌö bi ꞌyo̱tꞌa ar Hesu, bi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ha maꞌra bi ma ba xipa ya de̱ngaꞌbe̱pate nöꞌö xki ꞌyo̱tꞌa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nuꞌmú̱ nuya ndömöjö ne ya de̱ngaꞌbe̱pate bi ꞌyo̱tꞌa nꞌar mhuntsꞌandö, ne bi ꞌñeñꞌu̱: —Te ga pe̱hu̱pya. Ngetho nunar ñꞌo̱ho̱nu̱ o̱tꞌa nze̱ye̱ ya ntꞌudi. ");
INSERT INTO otqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nuꞌmu̱ ga he̱hu̱tho njapꞌu̱, gatho ya jöꞌi ma da ñꞌemu̱i. Mꞌe̱fa da e ya me Nroma da hwata ma nijöhu̱ ne ma hninihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nu ar Kaifas nꞌa nuya möjö mar döngamöjö nor je̱ye̱ꞌö, bi ꞌñembabiꞌu̱: —Nuꞌahu̱ hinte gi pöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hinxka beñhu̱, xiñho nꞌar ñꞌo̱ho̱ da unga ár te da po̱ta gatho ar hnini, ne njapꞌu̱ gatho ma ha̱ihu̱ hinda mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Himbi bense̱ nöꞌö bi möñꞌö. Ngetho mar döngamöjö nunar je̱ye̱ꞌö, jange Jö bi umba nöꞌö bi mö. Mi enö, nunar Hesu ma nda unga ár te nda po̱ta ya mengu nunar ha̱iꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ne hinge ho̱nse̱ nor ha̱inu̱, gatho yá bötsi Jö habu̱ gatho xi nxani, da muntsꞌa nꞌatho. ");
INSERT INTO otqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jange nor paꞌö nuya ndöyu̱ bi nkohi nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nuꞌmú̱ ar Hesu bi hye̱gi mi ꞌyo ha yá nthandi ya ndöxodyo. Bi ma getꞌu̱ ha ya otꞌatꞌo̱ho̱ ha nꞌar hnini ár thuhu Efrain, ne ka bi gohwinu̱ yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mi ꞌba̱pꞌu̱tho ar baxjwa, nꞌár da̱ngo ya xodyo. Nze̱ye̱ ya jöꞌi ha yá ha̱iꞌu̱ bi mꞌe̱tꞌo bi maꞌu̱ har hnini Herusalen, ma ba ntꞌaxki. ");
INSERT INTO otqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Núꞌmu̱ mi ꞌbu̱hnu̱ har dönganijö mi honga ar Hesu, ne mi enga nꞌa ngu nꞌa: —Te gi beñhu̱. Hage hinda e ar da̱ngopya ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ha nuya ndömöjö ne ya de̱ngaꞌbe̱pate xki xipabi ya jöꞌi, nöꞌö togo nda bödi habu̱ ndi ꞌbu̱i, nda da̱ ne nda nju̱ nda njotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Núꞌmu̱ mi ꞌbe̱ ꞌrato mpa nda zo̱ ar baxjwa, ar Hesu ba e har hnini Betania, habu̱ mi ꞌbu̱ ar Lasaro nöꞌö xki duhmö ne bi mengi bi koꞌspa ár te manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ne ka bi tꞌo̱tꞌwabinu̱ nꞌar tꞌoxi. Ar Marta go mi po̱xa ar mexa, ne ar Lasaro mi huhwinu̱ har mexa nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ar Maria nꞌa mbi hñö nꞌar xito, mi ñꞌe̱nga ngu made ntꞌe̱ni nꞌar hogañu̱ni xa mar mhödi, ne bi goꞌspa ár wa ar Hesu. Ne bi gu̱ yá xtö mi thukwabi, ne xo̱ge ar ngu bi ñuxa nor hogañu̱niꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ne bi ꞌñenga ar Huda Iskariote ár tꞌu̱ ar Simu, nꞌa nuyá ma̱xte togo ma nda da̱ mꞌe̱fa: ");
INSERT INTO otqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Yoꞌö himbi ꞌba̱ nunar hogañu̱ninu̱, xi tꞌa̱ nꞌa nje̱ye̱ ár nthöhö nꞌar jöꞌi, ne xi themba ya tsi hyoya. ");
INSERT INTO otqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ar Huda bi mönga njapꞌu̱, hinge mi tupa ár mu̱i ya hyoya. Bi mö ngetho már bë, ha go mi höꞌö ar ꞌro̱zöbojö, ne mi ju̱ nöꞌö mi neꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ha nunar Hesu bi ꞌñembabi: —Hye̱hnu̱. Xi goxka ar hogañu̱ni xki kwati to̱ꞌma ár pa ma ntꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ngetho nuya hyoya hyaxꞌmu̱ ma gi ꞌbu̱hwihu̱, ha nuga hinge hyaxꞌmu̱ ma ga ꞌbu̱hwihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nze̱ye̱ ya xodyo bi bödi ar Hesu mi ꞌbu̱hnu̱ Betania, ba eꞌu̱ ma ba kꞌöni. Ne hinge ho̱nse̱ꞌö, mi ne nda nuꞌu̱ nꞌehe ar Lasaro togo xki mengi xki nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nuꞌmú̱ nuya ndömöjö bi nkoꞌu̱ nda hyo ar Lasaro nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ngetho nöꞌö xki tꞌo̱tꞌwabinu̱, bi japa nze̱ye̱ ya xodyo xki ꞌwege ne xki ñꞌemu̱i ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ár hyaxꞌö nze̱ye̱ ya jöꞌi xki ꞌñe ar da̱ngo. Mi ꞌyo̱ꞌu̱ ndi ꞌñe ar Hesu Herusalen, ");
INSERT INTO otqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","bi doka ya de̱nthi, ne bi ma ba thödi xa mi mafi mi eñꞌu̱: —Xa nsunda Jö. Njöpa ár mꞌe̱hni Jö, gehnu̱ ár ndö ya me Israel. ");
INSERT INTO otqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ar Hesu bi dinga nꞌar tsi nꞌo̱ge ne bi nto̱ge, njapꞌu̱ nda tho ngu mönga har Tꞌofo habu̱ enö: ");
INSERT INTO otqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Yo gi ntsuhu̱, menguhu̱ Sion; hyanthu̱ ba ehnu̱ ri Ndöhu̱, nto̱ nꞌar tsi nꞌo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nuyá ma̱xte himbi zo yá mfeni nꞌagitho yoꞌö xki thogi njapꞌu̱. Núꞌmu̱ mi menga hár nsunda ar Hesu, ka bi beñꞌu̱ xki tꞌotꞌa gatho nuna tema xki njapi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ne mi da̱majöni nuya mi ꞌbu̱hwi hár tꞌa̱gi ar Lasaro, núꞌmu̱ mi matꞌi ne bi koꞌspa ár te xki du. ");
INSERT INTO otqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jange nuya jöꞌi ba e bi dödi, ngetho xki ꞌyo̱ꞌu̱ xki ꞌyo̱tꞌa ar Hesu nunar ntꞌudinu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ha nuya de̱ngaꞌbe̱pate bi ꞌñense̱ nꞌa ngu nꞌa: —Hinte xi za̱ te xka pe̱hu̱. Hyanthu̱hmö gatho ya jöꞌi di ma te̱ni. ");
INSERT INTO otqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ꞌRa ya me Gresia mi ꞌbu̱hnu̱, xki ma nda ndönga Jö har da̱ngo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ne nuyu̱ bi watꞌa habu̱ mi ꞌba̱ ar Lipe ar me Betsaida har ha̱i Ngalilea, ne bi ꞌya̱pa ar möte bi ꞌñeñꞌu̱: —Tata, di ne ga hanthe ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ar Lipe bi ma ba xipa ar Andre, ne bi ma ba xipabiꞌu̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ar Hesu bi dötwabiꞌu̱ ne bi ꞌñenö: —Xi zo̱ ar pa da hñönga ár nsunda mhetsꞌi Nöꞌö Togo ba e bi Njöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Xa majöni di xiꞌahu̱, nuꞌmu̱ nꞌar nda̱tꞌe̱i hinda zo har hwöhi ne da du, da gose̱. Ha nuꞌmu̱ da du, da unga nze̱ye̱ ar sofo. ");
INSERT INTO otqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nöꞌö togo xa mö ár te, da ꞌbe̱di. Ha nöꞌö togo da u̱tsa ár tewa har ximha̱i, ma da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nöꞌö togo ne da me̱pkagi, dá de̱ngagi, ne habu̱ ga ꞌbu̱ka ka da mꞌu̱hnu̱ nꞌehe. Nuꞌu̱ togo da me̱pkagi, ma Dada da ꞌñeꞌspa ár nsu. ");
INSERT INTO otqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nupya xa di tu ma mu̱i. Te ga a̱pa Jö ma Dada. Hage ga embabi: Ñöngagi hinga tho nunar thogi ba epꞌu̱. Hinda tsa̱, ngetho xta e ga thoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ma Dadaꞌi, japa da nsunda ri thuhu. Bi nheki ꞌmu̱ nꞌar mhö ndi ꞌñe mhetsꞌi mi enö: —Xa xta japi xi nsunda, ne ga japi da nsunda manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mi ꞌbu̱hnu̱ nze̱ye̱ ya jöꞌi nuꞌu̱ bi ꞌyo̱xa nunar mhönu̱. ꞌRa mi enö xki tꞌo̱ nꞌar ñu̱ni, maꞌra mi enö nꞌar e̱nxe̱ xki zo ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ar Hesu bi dödi ne bi ꞌñenö: —Hinge ma ñhoga nunar mhö xpa ehnu̱ mhetsꞌi, xpa hoñꞌa ri ñhohu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Xi zo̱ ar pa ya meximha̱i ma da thöꞌspa majöni, ne ar tsꞌondöhi ár ndö nunar ximha̱inu̱, ma da thömba ár tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nuga, núꞌmu̱ xta nju̱xka har ha̱i ne da tsꞌu̱tkagi, ma ga tsigase̱ gatho da hyongagi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Bi mönga njapꞌu̱, ne nda födi hanja nda du. ");
INSERT INTO otqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ya jöꞌi bi dödi ne bi ꞌñenö: —Nuje xta pöhe enga har tꞌofo, nunar Kristo hinda ma da göxa ár mꞌu̱i. Yoꞌö gi enö ma da nju̱xa Nöꞌö Togo ba e bi Njöꞌi. Togo Nuna ba e bi Njöꞌi ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ar Hesu bi ꞌñembabi ꞌmu̱: —Ho̱nse̱ maꞌra ya tsi pa ma gi ꞌbu̱hwihu̱ ar ñotꞌi. ꞌYohu̱ núpya gi pe̱ꞌsu̱ ar ñotꞌi, yo ma da zu̱ꞌahu̱ ar ꞌbe̱xui. Ngetho nuꞌu̱ ꞌyo har ꞌbe̱xui hingi handi habu̱ di ma. ");
INSERT INTO otqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jange núpya gi ꞌbu̱hwihu̱ ar ñotꞌi, ñꞌemu̱ibihu̱ ne gi mbötsihu̱ ar ñotꞌi. Njapꞌu̱ bi mönga ar Hesu. Mꞌe̱fa bi ma ba ñꞌöni habu̱ hinge nda hyantꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mödi ar Hesu xki ꞌyo̱tꞌa nze̱ye̱ ya ntꞌudi ha yá hmi ya xodyo, nuꞌu̱ himi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bi njanu̱ ne nda tho ngu xki mönga ar mꞌe̱hni Isaia núꞌmu̱ bi ꞌñenö: Tsi Hmuꞌi, hinto xi jamfi nöꞌö di möñhu̱. Hinto xi ñꞌemu̱i nuya döta ntꞌudi xka ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Himi tsa̱ nda ñꞌemu̱iꞌu̱, ngetho bi ꞌñenga ar Isaia nꞌehe: ");
INSERT INTO otqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Jö bi gotwa yá da̱, ne bi japi bi me yá mfeni, Njapꞌu̱ hinda xo yá da̱ da hyandi, ne hinda kwata ha yá mu̱i, ha nuga da tsa̱ ga umba ar nzaki. ");
INSERT INTO otqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ar Isaia bi mönga njapꞌu̱ núꞌmu̱ mi hyandwa ár nsunda, ne bi da̱majöni togonu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mödi njapꞌu̱, nze̱ye̱ ya xodyo bi ñꞌemu̱ibi ar Hesu, mödi himi da̱majöni, ngetho mi tsu ya de̱ngaꞌbe̱pate nda ꞌye̱nga ha yá nijö. ");
INSERT INTO otqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ngetho mi honi nda ꞌñeꞌspa yá nsu ya jöꞌi, hinge Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ar Hesu bi ñö ntsꞌe̱di bi ꞌñenö: —Nöꞌö togo ñꞌemu̱igi, hinge ho̱nse̱ ñꞌemu̱igi, ñꞌemu̱i togo xpa pe̱nkagi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne nöꞌö togo handgagi ma mꞌu̱i, handwa ár mꞌu̱i nöꞌö togo ba pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nuga go dar ñotꞌi, xta ekwa har ximha̱i. Gatho nuꞌu̱ togo da ñꞌemu̱igi, hinda mꞌu̱ har ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nöꞌö togo xi ꞌyo̱xa nöꞌö xta mö ne hinda ꞌyo̱tꞌe, hingo ma ga e̱ntꞌwa ár mfe̱i. Ngetho hinxta eka ga e̱ntꞌwa ár mfe̱i ya meximha̱i, xta e ga po̱kaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nöꞌö togo u̱tsagi ne hingi ne da ñꞌemu̱i nöꞌö di mö, ꞌñe togo da ꞌye̱ntꞌwa ár mfe̱i, gehnu̱ ar mhö xta xiꞌahu̱, go da ꞌye̱ntꞌwa ár mfe̱iꞌö har ngöxapa. ");
INSERT INTO otqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngetho hinxta bense̱ nöꞌö xta mö. Ma Dada togo ba pe̱nkagi, bi xikagi teme ga mö ne ga xipa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne di pödi, nöꞌö te xi ꞌbe̱pkagi, gehnu̱ da xiꞌahu̱, ne da ꞌraꞌahu̱ ar te hiñhamꞌu̱ da götsꞌi. Jange nöꞌö di mö di te̱nda ngu xi xikagi ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mi ꞌba̱pꞌu̱tho ar da̱ngo mbaxjwa. Ar Hesu mi pödi xki zo̱ ar pa nda zokwa ar ximha̱i, ne nda menga habu̱ bi ꞌbu̱ ár Dada. Nöꞌö bi mödi nuꞌu̱ mi ꞌbu̱kwa har ximha̱i mi te̱ni, xa bi möꞌu̱ gatho ya pa bi mꞌu̱kwa. ");
INSERT INTO otqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ha núꞌmu̱ mi ntꞌoxꞌu̱, ar tsꞌondöhi xki wadi xki ꞌye̱ntꞌwa hár mu̱i ar Huda Iskariote, ár tꞌu̱ ar Simu, nda da̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mi pö ar Hesu ár Dada xki ꞌye̱ntꞌwa gatho hár ꞌye̱, ne xki ꞌñe habu̱ mi ꞌbu̱ꞌö, ne ma nda mengnu̱ manꞌagi, ");
INSERT INTO otqNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","jange mi ntꞌoxi, nꞌa mbi nangtho, bi mo̱ ár pa̱tꞌi, bi gu̱ nꞌar dutu bi bötꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nepꞌu̱ bi xitꞌa ar dehe ha nꞌar döngmohi, ne bi ndu̱i bi xu̱kwa yá wa yá ma̱xte. Ne mi ju̱ ar dutu mi bötꞌi, mi thukwabi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ha núꞌmu̱ ma nda xu̱kwabi yá wa ar Pedro, bi ꞌñeñꞌö: —Ma tsi Hmuꞌi, hage ma gi xu̱ga ma wa. ");
INSERT INTO otqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ar Hesu bi dödi ne bi ꞌñenö: —Nöꞌö tema di pe̱pya hingi tso ri mfeni, ne mꞌe̱fa ma gi pödi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ar Pedro bi ꞌñembabi: —Hinga ñhe̱gi gi xu̱ga ma wa. Ar Hesu bi döti: —Nuꞌmu̱ hinga xu̱kꞌaꞌi, hinte ma njawi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ne bi ꞌñenga ar Simu Pedro: —Ma tsi Hmuꞌi, nuꞌmú̱, hinge ho̱nse̱ gi xu̱ga ma wa, xu̱ga ma ꞌye̱ ne ma ñö. ");
INSERT INTO otqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ar Hesu bi ꞌñembabi: —Nöꞌö togo xi wadi xi nxaha, xi ntꞌaxki, ho̱nse̱ mahyoni da xu̱ka yá wa. Ne nuꞌahu̱ xi ntꞌaxkꞌaꞌihu̱, mödi hingi gathohu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ngetho mi pöꞌö togo ma nda da̱, jange bi ꞌñenö: Hinga gatho xi ntꞌaxkꞌaꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Núꞌmu̱ mi wadi bi xu̱kwa yá wa yá ma̱xte, bi gu̱ bi ma̱tꞌa ár pa̱tꞌi, ne bi mengi bi hñu har mexa, bi ꞌñembabiꞌu̱: —Ha gi pöhu̱ tema di bo̱nga nöꞌö xta jaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nuꞌahu̱ gi engagihu̱ dar Utate ne dar Hmu. Majöni nöꞌö gi xiju̱, ngetho hö njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngu xka möñhu̱, nuga dar Hmu ne dar Utate xta xu̱kꞌahu̱ ri wahu̱. Nuꞌahu̱ nꞌehe mahyoni gi xu̱kwabihu̱ yá wa nꞌa ngu nꞌa ri ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nuga xta utꞌahu̱ gi te̱nthu̱ ngu xta o̱tka, njapꞌu̱ gi ꞌyo̱thu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Xa majöni di xiꞌahu̱, nꞌar ꞌbe̱go hingi töpa ár nsu ár Hmu, ngu nꞌar mꞌe̱hni hingi töpa ár nsu togo xi me̱hni. ");
INSERT INTO otqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nuꞌahu̱ gi pöhu̱ nöꞌö di xiꞌahu̱, ne nuꞌmu̱ gi ꞌyo̱thu̱, xa xi njöpꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Hinga gathoꞌihu̱ di no̱ñꞌahu̱, di pöka togo xta hwañꞌahu̱. Ho̱nse̱ mahyoni da thogi ngu mönga har Tꞌofo habu̱ enö: Nöꞌö togo di ñheꞌbe ar thuhme, bi gu̱xa ár ꞌye̱ bi do̱xkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Di xiꞌahu̱pya hingi thotho, ne núꞌmu̱ xta thogi, gi ñꞌemu̱ihu̱ go geke. ");
INSERT INTO otqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Xa majöni di xiꞌahu̱, nöꞌö togo numansu ma mꞌe̱hni, numansugi. Ha nöꞌö togo numansugi, numansu togo ba pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mi wadi bi mönga njapꞌu̱ ar Hesu, xa bi du ár mu̱i, ne bi ꞌyotꞌwa ar ꞌñu yá ma̱xte tema ndi bo̱nga nuya mhö, ne bi ꞌñenö: —Xa majöni di xiꞌahu̱, nꞌa gi ꞌbu̱hu̱wa ma gi da̱gagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nuyá ma̱xte mi nkꞌötꞌa nꞌa ngu nꞌa, himi pöꞌu̱ togo mi no̱ni. ");
INSERT INTO otqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nꞌár ma̱xte togo ar Hesu xa mi mödi, mi huhwi getꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jange ar Pedro bi ja ár ꞌye̱ nda ꞌya̱mbabi togo mi no̱ni. ");
INSERT INTO otqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nuꞌmú̱, nunar ma̱xtenu̱ bi njwaxa hár tiñö ar Hesu, ne bi ꞌñembabi: —Ma tsi Hmuꞌi, togoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ar Hesu bi dödi ne bi ꞌñenö: —Nöꞌö togo ma ga umba ar thuhme xi mobo, go geꞌö. Bi mo ar thuhme ne bi umba ar Huda Iskariote ár tꞌu̱ ar Simu. ");
INSERT INTO otqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mi wa ar Huda bi zi nunar xe̱nithuhmenu̱, ar tsꞌondöhi bi yu̱tꞌa hár mfeni. Nuꞌmú̱ ar Hesu bi ꞌñembabi: —Nöꞌö ma gi pe̱fi, ꞌyo̱tꞌa ngutꞌa. ");
INSERT INTO otqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nuꞌu̱ mi huhnu̱ har mexa, hinto bi bödi yoꞌö mi xipabi njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ꞌRa mi beni mi emba ar Hesu: Di ma ba ta̱nga tema di hoñhu̱ har da̱ngo. Wa mi embabi nda ma nda umba nꞌa tu̱i ar bojö ya hyoya, ngetho ar Huda go mi kwata ar bojö. ");
INSERT INTO otqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Núꞌmu̱ mi wadi bi zi ar xe̱nithuhme, dama bi bo̱ni bi ma. Mar mꞌe̱xui ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nu mi bo̱ñꞌö, ar Hesu bi ꞌñenö: —Nupya ma da nheki ár nsunda Togo ba e bi Njöꞌi, ne ma da ñꞌu ár nsunda Jö xta tho ya thogi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Núꞌmu̱ xta ñꞌu ár nsunda Jö, Jö ma da ñꞌu ár nsundaꞌö nꞌehe, ne ngutꞌa ma da njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ma tsi bötsiꞌihu̱, hinga ma ga ꞌbu̱hwihu̱ nze̱ye̱ ya pa. Ma gi hyongagihu̱, ne ngu xta xipabi ya xodyo, di xiꞌahu̱ nꞌehe: Habu̱ gar maga, hinda tsa̱ gi möhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Di ꞌbe̱pꞌahu̱ nꞌar ꞌraꞌyo ꞌbe̱pate, gi mhöhu̱ nꞌa ngu nꞌa. Ngu xta möꞌahu̱, njapꞌu̱ gi mhöhu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nuꞌmu̱ xa majöni gi mhöhu̱ nꞌa ngu nꞌa, njapꞌu̱ gatho ya jöꞌi ma da bödi ma ma̱xteꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ar Simu Pedro bi ꞌñembabi: —Tsi Hmu, habu̱ gi ma. Ar Hesu bi ꞌñembabi: —Habu̱ gar maga, hinda tsa̱ gi te̱ngagipya, mödi mꞌe̱fa hö, gi te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ar Pedro bi ꞌñembabi: —Ma tsi Hmuꞌi, yoꞌö hingi tsa̱ ga te̱ñꞌapya. Di ꞌbu̱i ga unga ma te ga te̱ñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ar Hesu bi döti: —Hage gi ꞌbu̱i gi unga ri te. Xa majöni di xiꞌaꞌi, mꞌe̱tꞌo ma gi ko̱ngagi hñuꞌgi, ne ka da ma ar boxi. ");
INSERT INTO otqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yo gi tu ri mu̱ihu̱. Gi ñꞌemu̱ihu̱ Jö, ñꞌemu̱igihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Núnu̱ habu̱ bi ꞌbu̱ ma Dada, bi ja nze̱ye̱ ya ngu. Nuꞌmu̱ hindi njapꞌu̱, xta xiꞌahu̱ nꞌagitho. Gar manu̱ ꞌmu̱, ma ga hokꞌahu̱ habu̱ gi ꞌbu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne xka ma ga hokꞌahu̱ habu̱ gi ꞌbu̱hu̱, ma ga pengase̱ ga tsixꞌahu̱, ne njapꞌu̱ mahye̱gi ga ꞌbu̱huihu̱, ne habu̱ ga ꞌbu̱ka ka gi ꞌbu̱hu̱nu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gi pöhu̱ habu̱ gar ma, ne gi pöhu̱ ar ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ar Toma bi ꞌñembabi: —Tsi Hmu, hindi pöhe habu̱ gi ma. Hanja ma ga pöhe ar ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ar Hesu bi ꞌñembabi: —Nuga dar ꞌñu, dar majöni ne dar te. Hinjoꞌo togo da zo̱nga habu̱ bi ꞌbu̱ ma Dada nuꞌmu̱ hindi te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nuꞌmu̱ gi pökahmögihu̱, gi pöhmöhu̱ ma Dada nꞌehe. Di ndu̱ ar pania, xka pöhu̱ ne xka hyanthu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ha ar Lipe bi ꞌñembabi: —Tsi Hmu, ho̱nse̱ di nehe gi utkagihe ar Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nuꞌmú̱ ar Hesu bi ꞌñenö: —Xta ꞌbu̱hwihu̱ nze̱ye̱ ya pa. Hanja hinxka pökagi, Lipe. Nöꞌö togo xi hyandgagi, xi hyanda ma Dada. Hanja gi enge: Utkagihe ar Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Hage hingi ñꞌemu̱i di nꞌatꞌbe ar Dada. Nuya mhö di xiꞌahu̱, hinxta bense̱, ngetho ar Dada togo di ꞌbu̱ꞌbe go o̱tꞌa ar ꞌbe̱fiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ñꞌemu̱ihu̱ nuga di nꞌatꞌbe ar Dada. Nuꞌmu̱ hingi ñꞌemu̱igihu̱ nöꞌö di mö, ñꞌemu̱igihu̱ ngetho di o̱tꞌa nuya ꞌbe̱fiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Xa majöni di xiꞌahu̱, nöꞌö togo ñꞌemu̱igi ma da ꞌyo̱tꞌa nuya ꞌbe̱fi di o̱tka nꞌehe, ne da dökagi da ꞌyo̱tꞌe, ngetho gar maga habu̱ bi ꞌbu̱ ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ne gatho nöꞌö tema gi ꞌya̱fu̱ ma Dada gi thötju̱ ma thuhuga, nuga ma ga o̱tꞌahu̱, ne njapꞌu̱ nuga ár Tꞌu̱gi ga eꞌspa ár nsu ar Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nuꞌmu̱ tema gi ꞌya̱fu̱ Jö gi thötju̱ ma thuhu, ga o̱tga. ");
INSERT INTO otqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nuꞌmu̱ gi mökagihu̱, ꞌyo̱thu̱ nöꞌö di ꞌbe̱pꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne nuga ma ga a̱pa Jö ma Dada da me̱ñꞌahu̱ manꞌa togo da hupꞌa ri mu̱ihu̱, ne ma gi ꞌbu̱hwihu̱ gatho ya pa. ");
INSERT INTO otqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Geꞌö ár Hñö Jö togo mönga majöni. Ne nuya jöꞌi hingya gamfi hinda tsa̱ da hñöñꞌö, ngetho hingi handi, ne hingi pöꞌu̱ togoꞌö. Ha nuꞌahu̱ hö, gi pöhu̱, ngetho gi ꞌbu̱hwihu̱, ne ma da mꞌu̱ ha ri mu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Hinga ma ga he̱kꞌase̱hu̱. Ga pengi ga ꞌbu̱hwihu̱ manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Maꞌra ya tsi patho, ne nuya jöꞌi hinda ma da hyandgagi, ha nuꞌahu̱ ma gi hyandgagihu̱. Ngetho nuga di te, nuꞌahu̱ nꞌehe ma gi ntehu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nuya paꞌu̱ ma gi pöhu̱ di nꞌathoꞌbe ma Dada, ne gi nꞌatꞌwihu̱ ma mꞌu̱i, ne di nꞌatꞌwi ri mꞌu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nöꞌö togo o̱tꞌa nöꞌö di ꞌbe̱pabi, go mökagi. Ne nöꞌö togo mökagi, ma Dada ma da mödi nꞌehe, ne nuga ma ga mödi, ne ma ga ñꞌudi da hyandga ma mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nuꞌmú̱ ar Huda (hinge ar Iskariote) bi ꞌñemba ar Hesu: —Ma tsi Hmuꞌi, yoꞌö ho̱nse̱ ma gi ñꞌudi ga hantꞌahe ri mꞌu̱i, ha nu maꞌra ya jöꞌi hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ar Hesu bi dödi ne bi ꞌñembabi: —Nöꞌö togo mökagi, da ꞌyo̱tꞌa nöꞌö di mö. Ne ma Dada da mödi, ne ga eꞌbe ga ꞌbu̱he nꞌatꞌwu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nöꞌö togo hingi mökagi, hingi o̱tꞌa nöꞌö te di mö. Ha nöꞌö ar mhö xka ꞌyo̱hu̱, hingo xta mönse̱, ár me̱ti ma Dada togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Xta xiꞌahu̱yu̱ núpya di ꞌbu̱hwihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ha nunár Hñö Jö togo ar Humamu̱i, ma da me̱hna ma Dada po̱tka ma thuhu, go da utꞌahu̱ ne da beñꞌahu̱ gatho te xta xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Di tsokꞌahu̱ gi ꞌbu̱hu̱ nꞌar hogamꞌu̱i ngu di ꞌbu̱ka, hinge ngu nunar mꞌu̱i unga ar ximha̱i. Jange yo gi tu ri mu̱ihu̱, yo gi ntsuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ngu xka ꞌyo̱hu̱ xta xiꞌahu̱, ma ga ma, ne ga pengi ga ꞌbu̱hwihu̱. Nuꞌmu̱ gi mökhmöhu̱, xka njohyahu̱ núꞌmu̱ nda xiꞌahu̱: Gar ma habu̱ ꞌbu̱ ma Dada. Ngetho töpka ma nsu. ");
INSERT INTO otqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Di xiꞌahu̱pya nöꞌö hinxi thotho, ne núꞌmu̱ xta njapꞌu̱ gi ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hinga ma ga ñöwihu̱ nze̱ye̱ ya pa, ngetho ba epꞌu̱ ár ndö nunar ximha̱inu̱, ne nöꞌö hinte di njaꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Di ne da bö ya meximha̱i di mö ar Dada, jange di o̱tꞌa ngu ꞌbe̱pkagiꞌö. Nanju̱, möhö ga po̱ñhu̱wa. ");
INSERT INTO otqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nepꞌu̱ ar Hesu bi ꞌñembabi yá ma̱xte: —Nuga go dar ꞌba̱iꞌobxi majöni, ne ma Dada gehnu̱ togo su. ");
INSERT INTO otqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nuꞌu̱ togo di ꞌbu̱ꞌbe, jangu yá ꞌye̱ ar ꞌba̱iꞌobxi. Nuꞌu̱ yá ꞌye̱ uni, nöꞌö togo su da hoki xiñho, honi xa da du. Ha nuꞌmu̱ hinte uni, da me̱ki. ");
INSERT INTO otqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nuꞌahu̱ xi hokꞌahu̱ xiñho nuya mhö xta xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kwathu̱ ga ꞌbu̱hwihu̱. Jangu ar ꞌye̱za hingi tsa̱ te da uni nuꞌmu̱ hingi thötꞌa hár ꞌba̱i, njapꞌu̱thoꞌihu̱ nꞌehe, nuꞌmu̱ hindi ꞌbu̱hwihu̱, hinte mañho gi uñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nuga go dar ꞌba̱iꞌobxi, ha nuꞌahu̱ yá ꞌye̱. Nöꞌö togo di ꞌbu̱ꞌbe, nunu̱ xa unga ar ñho. Ha nuꞌmu̱ hindi ꞌbu̱ꞌbe, hinte tsa̱ te da me̱fi. ");
INSERT INTO otqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nöꞌö togo hindi ꞌbu̱ꞌbe, ma da tꞌe̱nga har ñöni ngu nꞌar ꞌye̱za, ne da ꞌyotꞌi. Nepꞌu̱ da njo, ne da tꞌu̱ꞌsa har tsibi habu̱ da nzo̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nuꞌmu̱ xa gi umba ri mu̱ihu̱ ga ꞌbu̱hwihu̱, ne di oda ri mfenihu̱ ma mhö, ꞌya̱hu̱ gatho nöꞌö gi nehu̱ ne da tꞌaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nuꞌmu̱ xa gi uñhu̱ ar ñho, njapꞌu̱ nheki ár nsunda ma Dada, ne njapꞌu̱ gi ꞌñuhu̱ go ma ma̱xteꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngu xi mökagi ar Dada, njapꞌu̱ di möꞌahu̱ nꞌehe. Yo ma gi ꞌwehu̱, ꞌbu̱hu̱ ha ma mhöte. ");
INSERT INTO otqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nuꞌmu̱ gi ꞌyo̱thu̱ nöꞌö xta ꞌbe̱pꞌahu̱, gi ꞌbu̱hu̱ ha ma mhöte ꞌmu̱, jangu xta o̱tꞌa nöꞌö xpa ꞌbe̱pkagi ma Dada, ne di ꞌbu̱ hár mhöteꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Di xiꞌahu̱ njapꞌu̱ ne ga thokꞌahu̱ ma johya, ne da nxo̱ge ri johyahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gehnu̱ ma ꞌbe̱pate: Gi mhöhu̱ nꞌa ngu nꞌa ngu xta möꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hiñꞌotho manꞌar mhöte di töpa ár nsu, da unga ár te da po̱ yá ñꞌohu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nuꞌahu̱ go ma ñꞌohu̱ nuꞌmu̱ gi ꞌyo̱thu̱ nöꞌö di ꞌbe̱pꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nupya hindi nuꞌahu̱ ngu nꞌar ꞌbe̱go, ngetho nꞌar ꞌbe̱go hingi pödi tema pe̱ ár hmu. Ha nuꞌahu̱ ma ñꞌohu̱, ngetho gatho nöꞌö xta o̱de xi mönga ma Dada, xta xiꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nuꞌahu̱ hinga hwankagihu, nuga go da hwañꞌahu̱, ne xta exꞌahu̱ gi möhu̱, ne da nheki ri hoga ꞌbe̱fihu̱ hiñhamꞌu̱ da thege. Njapꞌu̱ gatho nöꞌö gi ꞌya̱fu̱ ma Dada gi po̱tju̱ ma thuhu, da ꞌraꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nöꞌö di ꞌbe̱pꞌahu̱: Mhöhu̱ nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Núꞌmu̱ xta u̱tsaꞌihu̱ ya jöꞌi, beñhu̱ bi u̱tsagiga mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nuꞌmu̱ ár me̱tiꞌihu̱hmö ar ximha̱i, nuya meximha̱i da möꞌahu̱ ngu mö yá mi meximha̱iwi. Ha nuꞌahu̱ hingyá me̱tiꞌihu̱, ngetho nuga núꞌmu̱ nda hwañꞌahu̱, da zoñꞌahu̱ madeda ya meximha̱i, jange u̱tsaꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Beñhu̱ nöꞌö xta xiꞌahu̱, ar ꞌbe̱go hingi töpa ár nsu ár hmu. Nöꞌö togo xi u̱tsagi, ma da u̱tsaꞌihu̱ nꞌehe. Ha nuꞌmu̱ xi ꞌyo̱tꞌa nöꞌö xta mö, ma da ꞌyo̱tꞌahu̱ nöꞌö gi xipabihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ha nuꞌu̱ togo da u̱tsaꞌihu̱, ma da japꞌu̱ ngetho xka ñꞌemu̱igihu̱, ne hingi pöꞌu̱ togo xpa pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nuꞌmu̱ hinxta ekahmö ne hinxta zohmö nuya jöꞌiyu̱, hinte ma tsꞌoki di tuhmöyu̱. Ha xta ehe xta xipabi, jange hiñꞌotho te da döꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nöꞌö togo u̱tsagi, po̱ntho u̱tsa ma Dada nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nuꞌmu̱ hinxta ñꞌuhmö ya ntꞌudi nöꞌö hinto manꞌa xi za̱ xi ꞌyo̱tꞌe, hinte ma tsꞌoki di tuhmöꞌu̱. Ha xi hyandya ntꞌudi, ne xi u̱tsagi mahye̱giꞌbe ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Xi njapꞌu̱ ne nda tho ngu mönga ha yá tꞌofo habu̱ enö: Xi u̱tsagi mödi hinte xta japabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ne ma ga pe̱ñꞌahu̱ ar Humamu̱i, gehnu̱ ár Hñö Jö mönga majöni, di ꞌñe habu̱ bi ꞌbu̱ ma Dada. Nunu̱ da da̱tꞌahu̱ majöni togogi. ");
INSERT INTO otqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nuꞌahu̱ nꞌehe ma gi da̱thwu̱ majöni maꞌra togogi, ngetho har ndu̱itho ndi ꞌbu̱hwihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Di xiꞌahu̱ njapꞌu̱, ne hingi ꞌwehu̱ xta ꞌñepꞌu̱ ya ntꞌu̱tsa. ");
INSERT INTO otqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ma da tꞌe̱ñꞌahu̱ ha ya nijö, ne ma da zo̱ ya pa núꞌmu̱ togo ma da hyoꞌahu̱, njapꞌu̱ pe̱pa Jö empꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nuꞌu̱ ma da ꞌyo̱tꞌahu̱ njapꞌu̱, ngetho hingi pöꞌu̱ togo ma Dada, ne hingi pöꞌu̱ togogi. ");
INSERT INTO otqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Xta xiꞌahu̱ nuya mhöyu̱, ne núꞌmu̱ xta tho njapꞌu̱, gi beñhu̱ xta xiꞌahu̱ mꞌe̱tꞌo. Hinda xiꞌahu̱ njapꞌu̱ ár ndu̱i, ngetho ndi ꞌbu̱hwithohu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ha nupya ma ga penga habu̱ bi ꞌbu̱ togo ba pe̱nkagi. Ne hinto xka ꞌya̱ngagihu̱ habu̱ gar ma. ");
INSERT INTO otqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ho̱nse̱ xa gi tu ri mu̱ihu̱ ngetho xta xiꞌahu̱ njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Majöni di xiꞌahu̱, gi to̱ꞌmhu̱ ri ñhohu̱ nuꞌmu̱ gar maga. Nuꞌmu̱ hinga ma, hinda e ar Humamu̱i. Ha nuꞌmu̱ ga ma, ma ga pe̱mpꞌahu̱ gi ꞌbu̱hwihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nu xta zo̱ꞌö, ma da hñuꞌmba yá hmi ya jöꞌi, da böꞌu̱ xa tu yá tsꞌoki, hanja da mꞌu̱ xiñho, ne Jö ma da hñöꞌspa majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ma da utwabiꞌu̱ xa tu ya tsꞌoki, ngetho hingi ñꞌemu̱igi. ");
INSERT INTO otqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma da utwabi hanja da mꞌu̱i xiñho, ngetho nuga ma ga penga manꞌagi habu̱ bi ꞌbu̱ ma Dada, ne hinge ma gi hyandgagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne da utwabi ar thöxamajöni, ngetho nöꞌö togo ndöwa har ximha̱i, xi wadi xi thuꞌspa ár mfe̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Di pe̱ꞌsta ma nze̱ye̱ tema ga xiꞌahu̱, ha nupya hinda tsa̱ ga utꞌahu̱, ngetho hinda tsa̱ da zo ri mfenihu̱ xo̱ge. ");
INSERT INTO otqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nu xta epꞌu̱ ár Hñö Jö nöꞌö mönga majöni, ma da ꞌyotꞌahu̱ xiñho ar ꞌñu nöꞌö majöni. Ngetho hinda ma da mönga nöꞌö bense̱, ma da mönga nöꞌö xi ꞌyo̱de, ne da xiꞌahu̱ nöꞌö tema da tho mꞌe̱fa. ");
INSERT INTO otqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ma da ꞌñeska ma nsu, ngetho ma da gu̱nka ma me̱ti ne da utꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gatho nöꞌö ár me̱ti ma Dada ma me̱ti nꞌehe, jange xta xiꞌahu̱ da gu̱nka ma me̱ti ne da utꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ꞌBe̱ ꞌra ya tsi pa, ne hinge ma gi hyandgagihu̱. Ne da tho maꞌra ya tsi pa, ne ma gi hyandgagihu̱ manꞌagi, ngetho gar ma habu̱ bi ꞌbu̱ ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nuꞌmú̱ ꞌra yá ma̱xte mi enga nꞌa ngu nꞌa: —Tema di bo̱nga nöꞌö te mö enö: ꞌBe̱ ꞌra ya tsi pa, ne hinge ma gi hyandgagihu̱. Ma da tho maꞌra ya tsi pa, ne gi pengi gi hyandgagihu̱, ngetho gar ma habu̱ bi ꞌbu̱ ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mi eñꞌu̱: —Tema di bo̱nga nöꞌö eñꞌö: ꞌBe̱ ꞌra ya tsi pa. Hindi pöhu̱ tema ne da mö. ");
INSERT INTO otqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ar Hesu bi bötho tema mi ne nda ꞌya̱mbabiꞌu̱, jange bi ꞌñembabiꞌö: —Yoꞌö gi ñꞌa̱ñhu̱ nꞌa ngu nꞌa nöꞌö te xta xiꞌahu̱: ꞌBe̱ ꞌra ya tsi pa, ne hingi hyandagihu̱. Ne ma da tho maꞌra ya tsi pa, ne gi hyandgagihu̱ manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Xa majöni di xiꞌahu̱, xa ma gi nzoñhu̱ ne ma gi thohu̱ ar dumu̱i, ha nuya meximha̱i ma da njohya. Mꞌe̱fa nuna ri dumu̱ihu̱ ma da thege, ne ma da e ar johya. ");
INSERT INTO otqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ma gi njahu̱ ngu nꞌar ꞌbe̱hñö tho ya u̱gi ngetho xi zo̱ yá pa da mꞌu̱ ár bötsi. Ha nu xta wadi da mꞌu̱ ár bötsi, da pumhnitho ar u̱gi bi thogi, di töte ar johya pe̱tsꞌi, ngetho xi zo̱kwa nꞌar bötsi har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gi njahu̱pya, xa gi tu ri mu̱ihu̱. Ha núꞌmu̱ xka pengi ga hantꞌahu̱, xa ma gi njohyahu̱, ne hinto ma da hñöñꞌahu̱ nunar johyanu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nuya paꞌu̱ hinte ma ntꞌa̱ni gi ꞌya̱ngagihu̱. Xa majöni di xiꞌahu̱, gatho nöꞌö gi ꞌya̱pabihu̱ ma Dada gi no̱nju̱ ma thuhu, go da ꞌraꞌahu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hinte xka ꞌya̱pathohu̱ gi no̱nju̱ ma thuhu. ꞌYa̱fu̱ ne da tꞌaꞌahu̱, njapꞌu̱ da nxo̱ge ri johyahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nöꞌö xta xiꞌahu̱ xta mönga mꞌede. Ma da zo̱ ar pa hinga zoꞌahu̱ njapꞌu̱. Ma ga xiꞌahu̱ nꞌagitho togo ma Dada, ne njapꞌu̱ da zo xiñho ri mfenihu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nuya paꞌu̱ ma gi ꞌya̱pabihu̱ ma Dada gi no̱nju̱ ma thuhu. Di xiꞌahu̱ hinge mahyoni ga a̱pa ma Dada da ꞌyo̱tꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gese̱ ma Dada möꞌahu̱, ngetho xka mökagihu̱, ne xka ñꞌemu̱ihu̱ xta e habu̱ bi ꞌbu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ndi ꞌbu̱ habu̱ bi ꞌbu̱ ma Dada, ne xta ekwa har ximha̱i. Ma ga tsokwa ar ximha̱i, ne ga penga manꞌagi habu̱ bi ꞌbu̱ ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nuyá ma̱xte bi ꞌñembabi: —Nupya gi ñö xiñho, ne hinte ma ꞌbede gi mö. ");
INSERT INTO otqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Xi zo ma mfenihepya gi pö gatho, hinge mahyoni te da tꞌa̱ñꞌaꞌi. Jange di ñꞌemu̱ihe xka e habu̱ bi ꞌbu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ar Hesu bi dötwabiꞌu̱ ne bi ꞌñenö: —Hage gi ñꞌemu̱ihu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pöhu̱ ma da epꞌu̱ ar pa, ne di xiꞌahu̱, ꞌba̱pꞌu̱tho núꞌmu̱ ma gi mfonthu̱. Nꞌa ngu nꞌa ma gi ju̱hu̱ ri ꞌñuhu̱, ne ma gi hye̱gase̱hu̱. Mödi hinga ma ga ꞌbu̱se̱, ma ga ꞌbu̱ꞌbe ma Dada. ");
INSERT INTO otqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Xta xiꞌahu̱ njapꞌu̱, gehnu̱ da jaꞌahu̱ gi ꞌbu̱hu̱ ter entho ga ꞌbu̱hwihu̱. Nuwa har ximha̱i ma gi thohu̱ ya thogi. Yo gi tu ri mu̱ihu̱, ngetho nuga xta tö ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mi wadi bi mönga njapꞌu̱, ar Hesu bi no̱ꞌsa mhetsꞌi ne bi ꞌñenö: —Ma Dadaꞌi, xi zo̱ ar pa da göxkwa nöꞌö xka ꞌbe̱pkagi ga o̱tꞌe. ꞌÑeꞌspa ár nsu ri Tꞌu̱gi, ne nuga ga esꞌa ri nsuge nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngetho xka ꞌraka ar tsꞌe̱di töpa gatho ya meximha̱i, ga umba ar te hiñhamꞌu̱ da götsꞌi nuꞌu̱ togo xka da̱tka ha ma ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Gehnu̱ ar te hiñhamꞌu̱ da götsꞌi: da böꞌaꞌi ho̱nse̱ꞌi gar Jö majöni, ne da bökagi dar Hesukristo togo xka pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nuga xta jwata ma ꞌbe̱fi xka ꞌrakagi, njapꞌu̱ xta ñꞌu ri nsundawa har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ma tsi Dadaꞌi, koska ma nsunda ga ꞌbu̱hwi habu̱ gi ꞌbu̱i, ne njapꞌu̱ da nheki ma nsu, ngu nunar nsu ndi pe̱ꞌskwi núꞌmu̱ hinxki thoktho ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Xta utwabi togoꞌi nuyu̱ xka hwahna har ximha̱i, ne xka ꞌye̱ntkꞌa ha ma ꞌye̱. Go ma ri me̱ti ne xka ꞌrakagipya. Nuyu̱ xi ꞌyo̱tꞌa gatho ngu xka pe̱nkagi ga xipi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nupya pöhyu̱, gatho nöꞌö di pe̱fi, go xka ꞌbe̱pkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngetho xta xipa nöꞌö xka xikagi, ne nuyu̱ xi hñöni. Ne xi böhyu̱ majöni xta ehe habu̱ ndi ꞌbu̱hwi, ne xi ñꞌemu̱i go xka pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nuga di a̱ꞌi gi suyu̱. Hinge di a̱ꞌi gi su nuꞌu̱ hingya gamfi, di a̱ꞌi gi su nuyu̱ togo xka ꞌrakagi, ngetho go ri me̱ti nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Gatho nöꞌö ma me̱ti go ri me̱ti nꞌehe, ne nöꞌö ri me̱tige go ma me̱ti nꞌe. Gehyu̱ xa japabi xi nheki ma nsunda. ");
INSERT INTO otqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma ga he̱gi di ꞌbu̱ka har ximha̱i, ngetho gar mapꞌu̱ habu̱ gi ꞌbu̱i. Ha nuyu̱ ma da mꞌu̱kwatho har ximha̱i. Ma tsi Dadaꞌi xa xintꞌaxiꞌi, nuya xka ꞌrakagi, suyu̱ hár tsꞌe̱di ri thuhu, ne da nꞌathoyu̱, nguju̱ di nꞌathowi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Núꞌmu̱ ndi ꞌbu̱ꞌbewa har ximha̱i, go ndi suga hár tsꞌe̱di ri thuhu hinge nda ꞌwege. Nuꞌu̱ ga ꞌrakagi ndi su, hinto bi mꞌe̱di, ho̱nse̱ nöꞌö xki tꞌe̱ntꞌi nda mꞌe̱di, ne nda tho ngu huxa har Tꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nupya ma ga mapꞌu̱ habu̱ gi ꞌbu̱i. Núꞌmu̱ di ꞌbu̱kwatho har ximha̱i di mönga nuya mhöyu̱, njapꞌu̱ ga thokwabi ma johya ne da nxo̱ge yá johyayu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Xta umbabi ri mhöyu̱. Ne ar ximha̱i bi u̱tsa, ngetho hingyá me̱ti ar ximha̱i, nguga hingo ár me̱tigi ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hindi a̱ꞌi gi ju̱ka har ximha̱i, ho̱nse̱ di a̱ꞌi gi ñöni hinte da japa ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nuyu̱ hingyá me̱ti ar ximha̱i, nguga hingar me̱tigi ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Di a̱ꞌi gi utwabi nöꞌö majöni, ne da ꞌye̱ntꞌa yá te da me̱pꞌaꞌi. Nuna ri mhö gehnu̱ majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jangu xka pe̱nkagi har ximha̱i, njapꞌu̱ xta pe̱nkayu̱ har ximha̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nuga di homba yá ñhoyu̱. Gese̱gi di e̱ntꞌa ma te ha ri ꞌbe̱fi, ne njapꞌu̱ nuyu̱ nꞌehe da ꞌye̱ntyá te ha ri ꞌbe̱fi, ngetho pöhyu̱ nöꞌö majöni. ");
INSERT INTO otqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Hinge ho̱nse̱ di a̱ꞌaꞌi gi fa̱xyu̱. Fa̱xatsꞌu̱ nuꞌu̱ togo ma da ñꞌemu̱igi nꞌehe xta ꞌyo̱ yá mhö da̱majöniyu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ne da nꞌathoyu̱ ngu di nꞌathowi, ma tsi Dadaꞌi, ngetho nuꞌge ne nuga di ꞌbu̱hwi mahye̱gi. Ne ga nꞌatꞌwihu̱yu̱ nꞌehe, ne njapꞌu̱ ya meximha̱i da ñꞌemu̱i go xka pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngu nöꞌö ar nsunda xka ꞌrakagi, njapꞌu̱ ga thokwabiyu̱ nꞌehe, ne da nꞌathoyu̱ ngu di nꞌathowi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nuga ma ga ꞌbu̱ꞌbeyu̱, ne nuꞌge di ꞌbu̱hwi. Njapꞌu̱ di nꞌathoyu̱, ne ya meximha̱i da bödi xka pe̱nkagi, ne xa gi möhyu̱ ngu xka mökagi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ma tsi Dadaꞌi, núyu̱ xka ꞌye̱ntkꞌa ha ma ꞌye̱, di ne da mꞌu̱ habu̱ di ꞌbu̱ka, ne da hyanda nöꞌö ar nsunda xka ꞌrakagi; ngetho ngi möki núꞌmu̱ hinxki thoktho ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ma tsi hoga Dadaꞌi, nuya jöꞌi hingya gamfi hinxi böꞌi. Ha nuga di pöꞌi, ne nuyu̱ xka ꞌrakagi pöhyu̱ nꞌehe go xka pe̱nkagi. ");
INSERT INTO otqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xta utwabiyu̱ togoꞌi ne tengu ri mꞌu̱i, ne hinga ma ga tsa̱ya̱ ga utwabi. Ne njangu xka mökagi, nuyu̱ nꞌehe da me̱ꞌsa nunar mhöteꞌö ha yá mu̱i, ne ma ga ꞌbu̱ꞌbegayu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ar Hesu mi wadi bi mönga njapꞌu̱, bi me̱wi yá ma̱xte bi ꞌrañꞌu̱ ar hñe ár thuhu Nsedro. Mi ꞌbu̱hnu̱ nꞌar hwöza, ne ka bi yu̱tnu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ha nu ar Huda, togo bi da̱ ar Hesu, mi pödi habu̱ mi ꞌbu̱ nunar hwöhinu̱, ngetho nze̱ye̱ ya pa ar Hesu xki me̱winu̱ yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jange ar Huda bi zixa nꞌa mutꞌi ya ndogu xki ꞌñe har tsꞌu̱tꞌwi, ne ꞌra ya ndogu mi su ar nijö, xki me̱hna ya ndömöjö ne ya de̱ngaꞌbe̱pate, bi mayu̱ mi hö ya ñotꞌi, ya tu̱nza, ya za ne ya jwai. ");
INSERT INTO otqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ar Hesu mi pötho tema nda ꞌñepabi, jange bi mꞌe̱tꞌo ma ba thödi, ne bi ꞌñembabiꞌu̱: —Togo gi hoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nuꞌu̱ bi dödi ne bi ꞌñeñꞌu̱: —Di hoñhe ar Hesu me Nasare. Ar Hesu bi ꞌñembabiꞌu̱: —Go geke. Ne mi ñꞌowiꞌu̱ nꞌehe ar Huda togo mi da̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Núꞌmu̱ mi ꞌñembabiꞌu̱: Go geke, nuꞌmú̱ bi nthixtha ne bi hwankꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ar Hesu bi mengi bi ꞌñembabiꞌu̱: —Togo gi hoñhu̱. Nuꞌu̱ bi ꞌñeñꞌu̱: —Ar Hesu me Nasare. ");
INSERT INTO otqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ar Hesu bi dötwabi: —Xta xiꞌahu̱, go geke. Nuꞌmu̱ gi hongagihu̱, hye̱hu̱ da ma nuyu̱ di ñꞌoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Bi njapꞌu̱ ne bi tho ngu xki möñꞌö xki ꞌñenö: Gatho nuꞌu̱ xka ꞌrakagi, di pe̱ꞌstho, hinto xta ꞌbe̱di. ");
INSERT INTO otqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nuꞌmú̱ ar Simu Pedro nꞌa mbi kꞌosta nꞌar ndo̱jwai mi nxötsꞌi, ne bi dakwa ár gu hár ñꞌe̱i ár ꞌbe̱go ar ndömöjö. Nor ꞌbe̱goꞌö már thuhu ar Malko. ");
INSERT INTO otqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ar Hesu bi ꞌñemba ar Pedro ꞌmu̱: —Kwata nor ndo̱jwai hár ntꞌo. Ngetho nunar ntꞌe̱ni xinju xi hñuska ma Dada, hage ga he̱pꞌu̱ hinga tsi ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nepꞌu̱ nunar mutꞌinu̱ ya ndogu mi ñꞌowi yá ndö, ne ya ndogu mi su ar nijö xki me̱hna ya dönziandö, bi gu̱ ar Hesu ne bi xo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mꞌe̱tꞌo bi tsꞌiꞌspa ar Anas, ngetho már ndo̱hñö ar Kaifas togo mar döngamöjö nor je̱ye̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nunar Kaifasnu̱ gehnu̱ togo xki xipa ya ndöxodyo mar ñho nda duse̱ nꞌar ñꞌo̱ho̱, hinge gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ha nu ar Simu Pedro ne nöꞌö manꞌa ár mima̱xtewi mi te̱ñꞌu̱ ar Hesu mi nju̱. Nöꞌö manꞌar ma̱xte már mpödi ar döngamöjö, jange bi yu̱tꞌa hár thi ar ngu. ");
INSERT INTO otqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Har Pedro xki go nthi har goxthi. Jange ba e nöꞌö manꞌar ma̱xte mi mpöhwi ar döngamöjö, bi xipa ar ꞌbe̱hñö mi su ar goxthi, nda hye̱ ar Pedro nda yu̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nuꞌmú̱ nor ꞌbe̱hñö mi su ar goxthi bi ꞌñemba ar Pedro: —Ha hingo ngi ñꞌowi nor ñꞌo̱ho̱nu̱ nꞌehe. Ar Pedro bi dödi ne bi ꞌñenö: —Hinꞌö, nuga hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nuya ꞌbe̱go ne nuya sunijö xki ꞌñuꞌu̱ nꞌar tsibi ngetho mar ntse̱, mi ꞌba̱hnu̱ mi mpatꞌu̱. Ar Pedro mi ꞌba̱hnu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ha nu ar döngamöjö bi ꞌya̱mba ar Hesu tema xki ja yá ma̱xte ne ár ntꞌuti. ");
INSERT INTO otqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ar Hesu bi dödi ne bi ꞌñenö: —Nuga hinte xta o̱tka ñꞌöntho. Nöꞌö di mö xta mönga ha ya tꞌu̱lo nijö ne har dönganijö habu̱ tso̱nga gatho ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yoꞌö gi a̱ngagihu̱. ꞌYa̱mbabihu̱ nuꞌu̱ togo xi ꞌyo̱xkagi, go pöꞌu̱ tema xta mö. ");
INSERT INTO otqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nu mi mönga njapꞌu̱ ar Hesu, nꞌar sunijö bi umba nꞌar mpe̱tgu ne bi ꞌñenö: —Hage njapꞌu̱ gi thöta ar döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ar Hesu bi ꞌñembabi: —Gi enö xta ñömañꞌu̱. Hage da za̱ gi hñubga ma hmi. Ha nuꞌmu̱ xta ñö xiñho, yoꞌö xka fe̱bgagi ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nuꞌmú̱ ar Anas bi me̱hna ar Hesu xki nso̱tꞌe, nda tsꞌixa habu̱ mi ꞌbu̱ ar Kaifas togo mar döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ar Pedro mi ꞌba̱ getꞌu̱ ar tsibi mi mpatꞌi, ne bi tꞌembabi: —Hage hinga geꞌe nꞌár ma̱xte nꞌehe. Nöꞌö bi nko̱ni ne bi ꞌñenö: —Hinꞌö, nuga hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nꞌár ꞌbe̱go ar döngamöjö már mëni nöꞌö togo bi hye̱kwa ár gu ar Pedro, bi ꞌñembabi: —Hage hinda hantꞌaꞌi ngi ꞌba̱hwiꞌö har hwöza. ");
INSERT INTO otqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ar Pedro bi mengi bi nko̱ni, ne bi ma ar boxi. ");
INSERT INTO otqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mi takxuditho núꞌmu̱ mi nju̱ka ar Hesu hár ngu ar Kaifas, ne bi tsꞌixa har döta ngu habu̱ mi ꞌbu̱ ya ndö me Nroma. Nuya ndöxodyo himbi ne bi yu̱tꞌu̱, himi ne nda ja̱xtꞌa yá mꞌu̱i, ne nda tsa̱ nda zi ar baxjwa. ");
INSERT INTO otqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nuꞌmú̱, ba po̱nga ar Pilato ne bi ꞌñembabiꞌu̱: —Tema gi ho̱xu̱ nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nuꞌu̱ bi dödi ne bi ꞌñeñꞌu̱: —Nuꞌmu̱ hinte ma tsꞌoki xi ꞌyo̱thmö, hinxta tsiñꞌahe ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ar Pilato bi dötwabiꞌu̱: —Tsixu̱ ne ꞌyo̱thwu̱ ar tsꞌu̱tꞌwi ngu mönga ri tꞌofohu̱. Ha nuya xodyo bi ꞌñembabi: —Nuje hingi the̱gagihe togo ga hohe. ");
INSERT INTO otqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bi njapꞌu̱ ne nda thogi ngu xki mönga ar Hesu, núꞌmu̱ xki mönga hanja nda du. ");
INSERT INTO otqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ar Pilato bi mengi bi yu̱tꞌa har döta ngu, ne bi zohna ar Hesu, ne bi ꞌñembabi: —Hage gár ndöge ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ar Hesu bi dötwabi njawa: —Nöꞌö xka mö, ha gi mönse̱, wa togo xi xiꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ar Pilato bi dödi ne bi ꞌñenö: —Hindar xodyoga. Nuya ri mixodyowi ne ya ndömöjö go xpa tsiꞌaꞌi ha ma tsꞌu̱tꞌwi. Te xka ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ha nu ar Hesu bi dödi: —Numa tsꞌu̱tꞌwiga hinga gekwa har ximha̱i. Nuꞌmu̱ di njapꞌu̱hmö, nuꞌu̱ togo te̱ngagi xi ntuhni ne xi ñöngagi, hinxi nda̱tkagi ya ndöxodyo. Ngetho numa tsꞌu̱tꞌwiga hingar menguwa. ");
INSERT INTO otqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ar Pilato bi ꞌñembabi ꞌmu̱: —Hage gar ndöge ꞌmu̱. Ar Hesu bi dödi ne bi ꞌñenö: —Hö, ngu xka mö dar ndö. Jange da mꞌu̱i ne xta ekwa har ximha̱i ga mönga nöꞌö majöni. Gatho nuꞌu̱ te̱nga nöꞌö majöni, o̱xa nöꞌö di mö. ");
INSERT INTO otqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ar Pilato bi ꞌñenö: —Teme nöꞌö majöni. Mi wadi bi mönga njapꞌu̱, bi bo̱nga nthi ma ba kꞌönga ya xodyo manꞌagi, ne bi ꞌñembabiꞌu̱: —Hinte ma tsꞌoki di timbabinu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nuꞌahu̱ gi pe̱ꞌsu̱ nꞌar ntꞌumbi di he̱kꞌahu̱ nꞌar ꞌyofa̱di har da̱ngo mbaxjwa. Ha gi nehu̱ ga he̱kꞌahu̱ ri Ndöxodyohu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nuꞌmú̱ gatho bi mengi bi maꞌu̱ ne bi ꞌñeñꞌu̱: —Hindi nehe gi hye̱hnu̱. Hye̱ ar Baraba. Ha nu ar Baraba mar bë. ");
INSERT INTO otqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nuꞌmú̱ ar Pilato bi japi nda nꞌwe̱xtꞌa ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne nuya ndogu bi me nꞌar ntsantꞌi ya ꞌmini ne bi hñuꞌspabi. Mꞌe̱fa bi göꞌspa nꞌar the̱nga dutu xa xki zi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ne bi ꞌñeñꞌu̱: —Xa̱ ar tsi te, ár Ndöꞌi ya xodyo. Ne mi umba ya mpe̱tgu. ");
INSERT INTO otqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mꞌe̱fa ar Pilato bi bo̱nga manꞌagi ne bi ꞌñemba ya xodyo: —Hyanthu̱ di tsiñꞌahu̱wa nunar ñꞌo̱ho̱nu̱. Nuse̱hu̱ hinte ma tsꞌoki xta timbabi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nu mi bo̱nga ar Hesu mi huꞌsa ya ꞌmini xki mꞌe, ne mi he ar the̱nga dutu, bi ꞌñenga ar Pilato: —Xi ꞌbu̱kwa nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mi hyanda nuya ndömöjö ne ya sunijö, bi ndu̱i bi mafi ne mi eñꞌu̱: —Tsu̱ta har pontꞌi, tsu̱ta har pontꞌi. Bi ꞌñenga ar Pilato: —Tsixu̱ ba tsu̱thu̱ har pontꞌi ngu xka möñhu̱, ngetho nuga hinte ma tsꞌoki di timbabinu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nuya xodyo bi dötwabi ne bi ꞌñeñꞌu̱: —Nunu̱ xi ꞌñense̱ ár Tꞌu̱ Jö, jange mahyoni da tho, ngetho njapꞌu̱ enga ha ma tꞌofohe. ");
INSERT INTO otqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nu mi ꞌyo̱ njapꞌu̱ ar Pilato bi hñuxa ár ntsu. ");
INSERT INTO otqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ne bi mengi bi yu̱tꞌa har döta ngu, ne bi ꞌñemba ar Hesu: —Habu̱ gar mengu. Ar Hesu hinte bi döti. ");
INSERT INTO otqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jange ar Pilato bi ꞌñembabi: —Ha hingi ne gi thödi. Wa hingi pödi di pe̱ꞌsa ar tsꞌe̱di ga jaꞌaꞌi da tsꞌu̱tꞌa har pontꞌi, wa da tsa̱ ga he̱kꞌaꞌi gi ma nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ar Hesu bi dödi ne bi ꞌñenö: —Hinte ma tsꞌe̱di gi pe̱ꞌshmö nuꞌmu̱ hinte xi ꞌraꞌa Jö. Jange nöꞌö togo xi ꞌye̱ntkꞌagi ha ri ꞌye̱, go töte ár tsꞌoki tuxꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mi wa ar Hesu bi mönga njapꞌu̱, ar Pilato xa bi umba ár mu̱i mi honi hanja nda hye̱gi. Ha nuya ndöxodyo xa mi mafi mi eñꞌu̱: —Nuꞌmu̱ gi hye̱ nunar ñꞌo̱ho̱nu̱, hingár ñꞌowi ar Sesar. Ngetho gatho nuꞌu̱ ñꞌexase̱ ngu nꞌar ndö, gehyu̱ yá ñꞌu̱niwiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nu mi ꞌyo̱ njapꞌu̱ ar Pilato bi gu̱ka ar Hesu. Ne bi hñuxa hár nthutsꞌi habu̱ höxa majöni, mi ꞌbu̱ har Gabata har mhö ebreo, di bo̱ni da ꞌñenö har Ntꞌu̱tꞌado. ");
INSERT INTO otqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mi ꞌbe̱ nꞌapa nda zo̱ ar da̱ngo mbaxjwa, ngu made mpa núꞌmu̱ ar Pilato bi ꞌñemba ya ndöxodyo: —Ndi, ꞌbu̱kwa ri ndöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ha nuya ndöxodyo bi maꞌu̱ ne bi ꞌñeñꞌu̱: —Tsitsꞌi ba tsu̱ta har pontꞌi. Ha nu ar Pilato bi ꞌñembabiꞌu̱: —Hage gi nehu̱ ga tsu̱tꞌa ri ndöhu̱. Nuya ndömöjö bi dödi ne bi ꞌñenö: —Ho̱nse̱ ar Sesar di ꞌñehe ngu ar ndö, hinto manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jange bi da̱twa ha yá ꞌye̱ꞌu̱ nda tsu̱tꞌu̱ har pontꞌi, ne nuya ndöxodyo bi gu̱ ar Hesu bi zixꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ar Hesu bi bo̱ni mi muxa ár pontꞌi habu̱ ma nda tsꞌu̱ti, ndi ma har Nñöxhmundoꞌyo, har hñö ebreo tꞌembabi Golgota. ");
INSERT INTO otqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ne ka bi tsꞌu̱tnu̱ har pontꞌi. Ne bi tsꞌu̱tnu̱ ma yoho nꞌehe, har Hesu bi go madetho. ");
INSERT INTO otqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ar Pilato bi ꞌyotꞌa nꞌar döta thuhu, ne bi hñuxa mañö ar pontꞌi, mi enö njawa: Gehnu̱ ar Hesu me Nasare, ár Ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nunar thuhunu̱ bi ne nze̱ye̱ ya xodyo; ngetho habu̱ xki tsꞌu̱ti mi getꞌu̱ ar hnini, ne mi huxa har hñö ebreo, ar griego ne ar latin. ");
INSERT INTO otqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nuya ndöxodyo bi ꞌñemba ar Pilato: —Yo gi otꞌa: Ár Ndö ya xodyo. Di nehe gi ꞌyotꞌa njawa: Go mi eñꞌö ár Ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ar Pilato bi dödi ne bi ꞌñenö: —Nöꞌö xta otꞌi, njapꞌu̱ da gohi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nuya ndogu mi wadi bi tsu̱ta ar Hesu, bi gu̱mpa yá dutu nda ꞌyo̱tꞌa goho xe̱ni, ne nda hñöxa nꞌa xe̱ni nꞌa ngu nꞌa. Bi gu̱mpa ár pa̱tꞌi nꞌehe, nunu̱ mi nꞌadar mꞌe xki tꞌo̱tꞌe xki ndu̱ mañö ndi göxa ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nꞌa mbi bentho ne bi ꞌñeñꞌu̱: —Hinga xe̱ju̱. Ma ga e̱nsu̱ nꞌar nthöhö ga nuhu̱ togo da hñötsꞌi. Gathoyu̱ bi njapꞌu̱, ne bi tho ngu mi enga har Tꞌofo habu̱ hutsꞌi njawa: Bi ñheꞌu̱ ma dutu, Ne bi ꞌye̱nsa ar nthöhö nda nu togo nda hñöska ma he. Ne bi japꞌu̱ ya ndogu. ");
INSERT INTO otqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Getꞌu̱ har pontꞌi habu̱ xki tsꞌu̱ta ar Hesu, ka mi ꞌba̱hnu̱ ár nönö ne ár juhwe̱pꞌu̱ꞌö, ar Maria ár ꞌbe̱hñö ar Kleofa, ne ar Maria me Magdala. ");
INSERT INTO otqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ar Hesu mi hyanda ár nönö ne ár ma̱xte togo xa mi mödi mi ꞌba̱hnu̱ nꞌehe, bi ꞌñemba ár nönö: —Nönö, xi ꞌba̱pꞌu̱ ri tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nepꞌu̱ bi ꞌñemba ár ma̱xte togo xa mi mödi: —Hyandi, xi ꞌba̱hnu̱ ri nönö. Ne nor paꞌö nunar ma̱xtenu̱ bi zixa hár ngu bi su. ");
INSERT INTO otqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mꞌe̱fa mi bö ar Hesu xki jwata xo̱ge, bi ꞌñenö: —Di tuthe. Njapꞌu̱ bi tho ngu mönga har Tꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mi ꞌbu̱hnu̱ nꞌar mohi mi po ar ixkatꞌafi. Bi nju̱ nꞌar xiꞌyo bi mpobo, bi nthuta ha nꞌar tꞌo ne bi njwatwa hár ne. ");
INSERT INTO otqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ar Hesu mi wadi bi zi ar ixkatꞌafi bi ꞌñenö: —Xi göxa xo̱ge. Ne bi tsꞌa̱ꞌma ár ñö, bi da̱ ár hñö bi du. ");
INSERT INTO otqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mi ꞌbe̱ nꞌapa nda da̱tꞌa ar da̱ngo mbaxjwa. Jange ya ndöxodyo ma ba a̱pa ar möte ar Pilato nda nꞌwakwabi yá wa nuꞌu̱ xki tsꞌu̱ti. Ne nda njömba yá ndoꞌyo, hinge nda gopꞌu̱ har pontꞌi nöꞌö ar pa ntsa̱ya̱. Nunar panu̱ mar ntsꞌupi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jange ba e ꞌmu̱ ya ndogu, ne bi ꞌwakwa yá wa nöꞌö ar ꞌbe̱tꞌo ne nöꞌö ár ñꞌowi xki tsꞌu̱twi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ha núꞌmu̱ mi zo̱nga habu̱ mi zu̱ ar Hesu, himbi ꞌwakwa yá wa, ngetho bi hyantꞌu̱ xki du. ");
INSERT INTO otqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ne nꞌa nuya ndogu bi gu̱ nꞌar maza, bi su̱ꞌspa ár ꞌbo̱tsꞌe, ne bi kꞌontsꞌa ar ji ner dehe. ");
INSERT INTO otqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ha nöꞌö togo bi hyandi go da̱majöni, jange pödi xiñho majöni nöꞌö te mö. Ne petꞌahu̱, njapꞌu̱ gi ñꞌemu̱ihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bi njapꞌu̱ ne nda tho ngu mönga har Tꞌofo habu̱ enö: Hinte ma ndoꞌyo nda nꞌwakwabi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Manꞌár xe̱ni ar Tꞌofo enö njawa nꞌehe: Ya jöꞌi da hyanda nöꞌö togo bi su̱nse̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mi wa xo̱geyu̱, ar Huse me Arimatea, togo mi te̱nga ar Hesu nꞌehe, mödi ñꞌöntho ngetho mi tsu yá mi ndöxodyowi, bi ma ba a̱pa ar Pilato nda umba ar se̱ki nda hñöꞌspa ár ndoꞌyo ar Hesu. Ne ar Pilato bi umbabi, jange bi ma ba hömpabi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ar Nikodemo nꞌehe togo ba e mi nxui bi kꞌönga nꞌagi ar Hesu, ba hö ar bopo ár thuhu ar mira, mi nthöskwi manꞌar hogañu̱ni ár thuhu aloe, mi tho ngu nꞌa̱temaꞌre̱tꞌa ya ntsꞌu̱ti ár ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jange bi gu̱ꞌu̱ ár ndoꞌyo ar Hesu, bi goꞌspa ya hogañu̱ni, ne bi ma̱xa ya dutu, ngu yá ntꞌumbi ya xodyo mi a̱ yá jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Getꞌu̱nu̱ habu̱ xki tsꞌu̱ta ar Hesu mi ꞌbu̱hnu̱ nꞌar hwöza, ne har hwöza mi ꞌbu̱hnu̱ nꞌar ꞌraꞌyo tꞌa̱gi hinto xki tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jange ka bi tꞌa̱hnu̱ꞌö, ngetho mi getꞌu̱tho, ne ma nda ndu̱ ar pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ár mꞌe̱tꞌo mpa ar hñöto, ar Maria me Magdala bi ma ra nꞌitho mi nxuitho har tꞌa̱gi, ne bi hyandi xki thöka ar do mi kothmöꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nuꞌmú̱, dama bi nixtꞌi ma ba xipa ar Simu Pedro ne nöꞌö manꞌar ma̱xte xa mi mö ar Hesu, bi ꞌñembabiꞌu̱: —Xi thöꞌspa ár ndoꞌyo ar tsi Hmu mi ꞌbu̱ har tꞌa̱gi, ne hindi pöhe habu̱ xpa ꞌbo̱kwe. ");
INSERT INTO otqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dama bi bo̱nga ar Pedro ne nöꞌö manꞌar ma̱xte, bi maꞌu̱ har tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Xa bi hye̱ ar nhixtꞌi gatho yoho, ha nöꞌö manꞌar ma̱xte bi ntöte ár nihi, jange bi zo̱nga mꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Bi ka̱ka ár ñö ne bi hyanda ya xu̱ni dutu mi ꞌbu̱hnu̱, ha himbi yu̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ne mi zo̱ ar Simu Pedro nꞌehe mi ꞌbe̱fa, dama bi yu̱tꞌi ne bi hyanda ya xu̱ni dutu mi ꞌbonu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ne bi hyanda nunar nthuꞌmxi xki ꞌba̱ꞌspahmö ár ñö ar Hesu, himi nthöskwi nu maꞌra ya xu̱ni dutu, mi ꞌbu̱se̱ xki ntotꞌi xiñho. ");
INSERT INTO otqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bi yu̱tꞌa nöꞌö manꞌa xki zo̱ mꞌe̱tꞌo, ne bi hyanda gatho nöꞌö te mi ja mbo, ne bi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nuya paꞌu̱ hinxki zoda yá mfeni nöꞌö mönga har Tꞌofo, mi enö mi mahyoni ar Kristo nda mengi nda nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ne bi menkꞌu̱ habu̱ mi ꞌbu̱ yá ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nunar Maria me Magdala mi ꞌba̱ nthi hár goxthi ar tꞌa̱gi mi zoni, bi ka̱ka ár ñö bi hyanda mbo. ");
INSERT INTO otqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ne bi hyanda yoho ya e̱nxe̱ mi he ya tꞌaxdutu, mi huhnu̱ habu̱ xki ꞌbo̱kwa ár ndoꞌyo ar Hesu, nꞌa habu̱ xki gohmö ár ñö, ne manꞌa habu̱ xki gohmö yá wa. ");
INSERT INTO otqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ne bi ꞌñenga nuya yohoyu̱: —Ha gi o̱de nönö. Yoꞌö gi zoni. Nöꞌö bi dödi: —Di zoni ngetho xi thöꞌspa ár ndoꞌyo ma tsi Hmu, ne hindi pödi habu̱ xpa tsꞌogi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nu mi wadi bi mönga njapꞌu̱, bi ñegi ne bi hyanda ar Hesu mi ꞌba̱hnu̱, ne himbi bödi ha go mi geꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ar Hesu bi ꞌñembabi: —Ha gi o̱de, nönö. Yoꞌö gi zoni. Togo gi honi. Nunar ꞌbe̱hñö mi beni mar suhwöhiza, jange bi ꞌñembabi: —Tata, nuꞌmu̱ xka hñöꞌspa ár ndoꞌyo ma tsi Hmu, xikagi habu̱ xka tsogi, ne ma ga hö. ");
INSERT INTO otqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ar Hesu bi ꞌñembabi: —Maria. Nuꞌmú̱ ar Maria bi ꞌba̱tꞌi ne bi ꞌñembabi: —Raboni (di bo̱ni da ꞌñenö, Utate). ");
INSERT INTO otqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ar Hesu bi ꞌñembabi: —Yo gi tha̱ngagi, ngetho hinxta mada habu̱ bi ꞌbu̱ ma Dada. Di ma ba xipa ma ku gar ma habu̱ bi ꞌbu̱ ma Dada ne ri Dadahu̱, ma Jö ne ri Jöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ar Maria me Magdala bi ma ba xipa yá ma̱xte xki hyanda ar Hesu, ne bi metwa nöꞌö xki nsipꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nu mi nxui nor ꞌbe̱tꞌo paꞌö, nuyá ma̱xte xki gotꞌa gatho ya goxthi habu̱ xki mhusꞌu̱ ngetho mi tsu ya xodyo, ba e ar Hesu bi mꞌa̱ madetho, ne bi ꞌñembabiꞌu̱: —ꞌBu̱hu̱ ter entho. ");
INSERT INTO otqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nu mi xipa njapꞌu̱, bi utwa yá ꞌye̱ ne ár ꞌbo̱tsꞌe, ne nuyá ma̱xte xa bi njohya bi hyanda ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ar Hesu bi ꞌñemba manꞌagi ꞌmu̱: —ꞌBu̱hu̱ ter entho. Ngu bi me̱nka ma Dada, njapꞌu̱ di pe̱ñꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nu mi wadi bi xipa njapꞌu̱, bi hwifi ne bi ꞌñembabiꞌu̱: —Hñöñhu̱ ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nuꞌu̱ togo gi pumbabihu̱ yá tsꞌoki, da mpumbabi. Ha nuꞌu̱ hingi pumbabihu̱, ma da duxta yá tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nunar Toma nꞌa yá ma̱xte ar Hesu, mi tꞌembabi ar Didimo ngetho xki mꞌu̱hwi mahye̱gi manꞌár ku, himi ꞌbu̱hnu̱ núꞌmu̱ mi zo̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bi ꞌñemba nuyá mi ma̱xtewi: —Xta hanthe ar tsi Hmu. Nöꞌö bi ꞌñenö: —Nuꞌmu̱ hinga handwase̱ yá ꞌye̱ habu̱ bi mfoꞌspa ya bo̱jö, ne ga fota ma xa̱, mꞌe̱fa ga fota ma ꞌye̱ hár ꞌbo̱tsꞌe, nuꞌmu̱ hinꞌö, hinga ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ár hñötopꞌu̱ manꞌagi mi ꞌbu̱ yá ma̱xte mbo ar ngu, ne ar Toma nꞌehe. Bi yu̱tꞌa ar Hesu núꞌmu̱ mi jotꞌa ya goxthi, bi mꞌa̱ madetho ne bi ꞌñembabiꞌu̱: —ꞌBu̱hu̱ ter entho. ");
INSERT INTO otqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne bi ꞌñemba ar Toma: —Xö ri xa̱, hyandga xiñho ma ꞌye̱. Höwa ri ꞌye̱, fota ha ma ꞌbo̱tsꞌe. Yo gi yomi, ñꞌemu̱igi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ar Toma bi dödi ne bi ꞌñembabi ꞌmu̱: —Ma tsi Hmuꞌi, ma Jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ar Hesu bi ꞌñembabi: —Toma, ga hyandgagi jange ga ñꞌemu̱i. Ha nza̱tho nuꞌu̱ hinxi hyandgagi ne xi ñꞌemu̱igi. ");
INSERT INTO otqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ar Hesu bi ꞌyo̱tꞌa ma nze̱ye̱ ya ntꞌudi hár nthandi yá ma̱xte, ne hingi huxkwa har tꞌofonu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nuyu̱ xi tꞌotꞌi, ne da tsa̱ gi ñꞌemu̱ihu̱ nunar Hesu gehnu̱ ar Kristo ár Tꞌu̱ Jö, ne xki ñꞌemu̱ihu̱ gi pe̱ꞌsu̱ ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mi wadi bi tho gathoyu̱, ar Hesu bi ñꞌudi manꞌagi nda hyanda yá ma̱xte núnu̱ hár ñöni ar ñho̱nthe Tiberia. Njanu̱ bi ñꞌudi: ");
INSERT INTO otqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Mi ꞌyo mahye̱gi ar Simu Pedro, ar Toma togo mi nsipabi ar Didimo ngetho xki mꞌu̱hwi manꞌa, ar Natanael ar mengu Kana har ha̱i Ngalilea, nuyá tꞌu̱ ar Sebedeo, ne ma yoho yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ar Simu Pedro bi ꞌñemba nu maꞌra: —Gar ma ar nju̱xhwö. Bi döꞌu̱: —Ga te̱ñꞌahe nꞌehe. Bi maꞌu̱, bi bo̱xa ha nꞌar motsa, ne nor nxuiꞌö hinte bi gu̱xꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Núꞌmu̱ ꞌbu̱tho nda hatsꞌi, bi nheki ar Hesu mi ꞌba̱ har ñönthe, ha himi pöꞌu̱ ha go mi geꞌö wa hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nöꞌö bi ꞌñembabiꞌu̱: —Ñꞌohu̱, ha hinte xka ju̱xu̱ nꞌar hwö ga tsahu̱. Bi döꞌu̱: —Hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ar Hesu bi ꞌñembabiꞌu̱: —Köthu̱ ar ntꞌa̱tsꞌi hár ñꞌe̱i ar motsa, ne gi ju̱xu̱. Bi götꞌu̱, ne himi tsa̱ nda gu̱tsꞌi, ngetho xa mi nze̱ye̱ ya hwö. ");
INSERT INTO otqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nuꞌmú̱ nöꞌö ar ma̱xte xa mi mö ar Hesu bi ꞌñemba ar Pedro: —Gehnu̱ ar tsi Hmu. Nu mi ꞌyo̱ njapꞌu̱ ar Pedro, dama bi hye ár dutu ngetho xki mo̱ge, ne bi ꞌye̱nga ar nsa̱gi har dehe bi bo̱nga ñꞌa̱nthe. ");
INSERT INTO otqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nu maꞌra ba e mi e̱ ar motsa, mi ju̱tꞌa ar ntꞌa̱tsꞌi mi ku̱ ya hwö, ngetho himar yapꞌu̱ ar ñönthe, ngu nꞌanthebe ya ñhu̱fi ár yapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ha nu mi göꞌu̱ har ñönthe, bi hyantꞌu̱ mi janu̱ ya de̱spi habu̱ mi oxa nꞌar hwö, ne mi janu̱ ya thuhme nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ar Hesu bi ꞌñembabiꞌu̱: —Ba höhu̱wa ꞌra ya hwö ja xka ju̱xu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Bi bo̱xa ar Simu Pedro har motsa, ne bi gu̱tꞌa ar ntꞌa̱tsꞌi bi gu̱ka har ñöni. Xa mi ñuxa ya hwö, mi tsu̱ nꞌanthebe ne ngu̱dmihñu ya döta hwö. Mödi mi nze̱ye̱ himbi xe̱ ar ntꞌa̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ar Hesu bi ꞌñembabiꞌu̱: —Ba ehu̱ gi nzimxudihu̱. Gatho mi tsu, hinto bi ꞌya̱mbabi, togoꞌi. Mi pöꞌu̱ mar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ba e ar Hesu bi gu̱ ar thuhme ne bi umbabiꞌu̱, ne bi japꞌu̱tho ar hwö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mꞌe̱fa xki mengi xki nte manꞌagi ar Hesu, ár hñuꞌginu̱ mi ñꞌudi nda hyanda yá ma̱xte. ");
INSERT INTO otqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Núꞌmu̱ mi wadi bi ñuñꞌu̱, ar Hesu bi ꞌñemba ar Simu Pedro: —Nuꞌge Simu, ár Tꞌu̱ꞌi ar Honas, hage mꞌe̱tꞌo gi mökagi, ne ka gi möhyu̱. Bi doꞌö ne bi ꞌñenö: —Hö ma tsi Hmuꞌi, gi pöke di möꞌaꞌi. Ar Hesu bi ꞌñembabi ꞌmu̱: —Suka ma belo. ");
INSERT INTO otqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bi mengi bi xipa ár ñoꞌgi: —Simu, ár tꞌu̱ꞌi ar Honas, ha gi mökagi. Ar Pedro bi dödi ne bi ꞌñenö: —Hö ma tsi Hmuꞌi, gi pöke di möꞌaꞌi. Nöꞌö bi ꞌñembabi: —Ta̱ga ma de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bi ꞌñemba ár hñuꞌgi: —Simu, ár Tꞌu̱ꞌi ar Honas, ha gi mökagi. Ar Pedro bi zo̱tꞌa ár mu̱i xki xipa ár hñuꞌgi, ha gi mökagi. Ne bi döti: —Ma tsi Hmuꞌi, gi pöke xiñho gatho. Gi pödi di möꞌaꞌi. Ar Hesu bi ꞌñembabi: —Suka ma de̱ti. ");
INSERT INTO otqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Xa majöni di xiꞌaꞌi, núꞌmu̱ ngi bötsi, ngi ngu̱tꞌase̱ ri bötꞌi, ne ngi ma habu̱ ngi nege. Ha núꞌmu̱ xki ndönzia, gi ju̱xa ri ꞌye̱, manꞌa da dutꞌa ri bötꞌi, ne da tsꞌixꞌa habu̱ hingi nege. ");
INSERT INTO otqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Bi ꞌñenga njapꞌu̱ mi xipa ar Pedro hanja nda du ne nda nsundabi Jö, ne bi ꞌñembabi nꞌehe: —Te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nepꞌu̱ ar Pedro bi ñegi, ne bi hyanda nunar ma̱xte xa mi mö ar Hesu. Getꞌö togo xki njwaxa hár tiñö ar Hesu nu ar nxui mi tsi ar tꞌoxi, ne xki ꞌñembabi: Tsi Hmu, togo ma da da̱ꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ar Pedro nu mi hyantꞌö, bi ꞌya̱mba ar Hesu: —Tsi Hmu, xipyanu̱. ");
INSERT INTO otqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ar Hesu bi ꞌñembabi: —Nuꞌmu̱ di nega da mꞌu̱tho núꞌmu̱ xka pengi, tema gi ñꞌa̱nge. Nuꞌge te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nunar ꞌbedenu̱ bi nu̱nga ha gatho ya gamfi, mi mhö nunar ma̱xtenu̱ hinge ma nda du. Himbi ꞌñembabi hinge nda duꞌö, ho̱nse̱ bi ꞌñenö: Nuꞌmu̱ di nega da mꞌu̱tho núꞌmu̱ xka pengi, tema gi ñꞌa̱nge. ");
INSERT INTO otqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Gehnu̱ ár ma̱xte ar Hesu togo da̱majöni te bi thogi, ne bi ꞌyotꞌi, ne di pöhu̱ majöni nöꞌö möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ja ma nze̱ye̱ ya ꞌbe̱fi bi ꞌyo̱tꞌa ar Hesu. Nuꞌmu̱ togo da ꞌyotꞌa nꞌa ngu nꞌa, di beni gatho ar ximha̱i hinda ñꞌe̱nga ya he̱ꞌmiꞌu̱. Dá njapꞌu̱.");
INSERT INTO otqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nuga dar Luka, nöꞌö ar ꞌbe̱tꞌo tꞌofo da otꞌi ne da pe̱ñꞌa ꞌmu̱, nuꞌge nda Teofilo, ja mömpꞌu̱ gatho te bi ndu̱i bi ꞌyo̱tꞌe ne te mi uta ar tsi Hmu Hesu, ");
INSERT INTO otqNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ne di göxa núꞌmu̱ bi mengi bi ma mhetsꞌi. Mꞌe̱tꞌo bi zohna yá mpo̱te xki hwahni, ne mi hömpa ár tsꞌe̱di ár Hñö Jö, bi xipabi tema nda ꞌyo̱tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ar tsi Hmu mi wadi bi tho ne bi mengi bi nte manꞌagi, bi ñꞌudi yonꞌa̱te mpa nda hyanda yá ma̱xte ne nda ñꞌemu̱iꞌu̱, ne himi tsa̱ya̱ mi petwabiꞌu̱ ár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Núꞌmu̱ mi ꞌbu̱hwiyu̱, bi ꞌñembabi: —Yo ma gi po̱ñhu̱ har hnini Herusalen. To̱ꞌmhu̱ gi hñöñhu̱ nöꞌö xi ñötꞌahu̱ Jö ar Dada, ne ngu xta xiꞌahu̱ ma gi hñöñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Majöni ar Xuwa mi xixtheꞌihu̱ har dehe. ꞌBa̱pꞌu̱tho ar pa ma gi nxixthehu̱ gi hñöñhu̱ ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Núꞌmu̱ mi ñöwi yá ma̱xte xki mhuntsꞌi, nꞌa mbi ꞌya̱mbathoꞌu̱ ne bi ꞌñembabi: —Ma tsi Hmuꞌihe, hage nuya payu̱ ma gi umba manꞌagi ár tsꞌe̱di ar hnini Israel da ndö ngu mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nuꞌmú̱ ar Hesu bi dötwabiꞌu̱ ne bi ꞌñembabi: —Hingo di ꞌñepꞌahu̱ gi pöhu̱ hamꞌu̱ ma da ꞌyo̱tꞌa Jö ar Dada nöꞌö o hár ꞌye̱ da ꞌyo̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ha nu xta e da zu̱ꞌahu̱ ár Hñö Jö, ma gi hñömfu̱ ár tsꞌe̱di, ne ma gi da̱hu̱ majöni togogi nuwa Herusalen, gathowa Nhudea, núnu̱ Nsamaria, ne gatho ár nxidi ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nu mi wadi bi mönga njapꞌu̱, bi nju̱xa mañö mhetsꞌi núꞌmu̱ mi handa yá mpo̱te, ha nꞌar gui bi goꞌmatho, ne himbi tsa̱ bi hyantꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nuꞌu̱ xa mi no̱ꞌsa mañö mi handa ar Hesu bi ma mhetsꞌi, nꞌa mbi da̱ñꞌu̱ mi ꞌba̱hwi yoho ya e̱nxe̱ mi he ya tꞌaxdutu. ");
INSERT INTO otqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ne nuya e̱nxe̱ bi ꞌñembabi nuꞌu̱ yá ma̱xtehmö: —Me Ngalileahu̱, tema gi no̱ꞌsu̱ mañö. Nu ar Hesu xka hyanthu̱pya xi ma mhetsꞌi, go gehnu̱tho ma da mengi da ehe ngu xka hyanthu̱ bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mꞌe̱fa nuyá ma̱xte ar Hesu, ba kö har tꞌo̱ho̱ Njömdo̱ni, bi menga har hnini Herusalen. Mi getꞌu̱tho, bi ñꞌo ngu hñötonthebe ya wëni ár yapꞌu̱, ngu ár yapꞌu̱ mi tsa̱ nda ñꞌo har pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nu mi zo̱ñꞌu̱ har hnini, bi bo̱xꞌu̱ har to̱ngu habu̱ mi koꞌu̱. Ka mi ꞌbu̱hnu̱ ar Pedro, ar Hakobo, ar Xuwa, ar Andre, ar Lipe, ar Toma, ar Bartolo, ar Teo, manꞌa ar Hakobo ár tꞌu̱ ar Alfeo, ar Simu nöꞌö mi tꞌembabi ar ñöngahnini, ne ar Huda ár jödö ar Hakobo. ");
INSERT INTO otqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gathoyu̱ hyaxꞌmu̱ mi mhuntsꞌi, mi pe̱sꞌu̱ nꞌadar mfeni mi a̱pa Jö. Mi ꞌbu̱hwiꞌu̱ mahye̱gi yá jödö ar Hesu, ar Maria ár nönöꞌö, ne maꞌra ya ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ha nuya paꞌu̱ bi mhushnu̱ ngu nꞌanthebe ne nꞌa̱te ya ku. Nuꞌmú̱ ar Pedro bi mꞌa̱ madetho ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Ma tsi kuhu̱, mi mahyoni nda njapꞌu̱ ngu nöꞌö xki mönga ar Dabi har Tꞌofo, nu mi ꞌyotꞌi ngu xki xipabi ár Hñö Jö. Bi no̱nga ar Huda nöꞌö togo bi zixa ya jöꞌi ba ju̱ ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ne nuju̱ ndi pöhu̱ mi gehnu̱ nꞌár ma̱xte ar Hesu, ne mahye̱gi ndi pe̱fu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Bi ma̱ꞌö ar tsi Hmu Hesu, ne nunar bojö bi tꞌumbabi, bi da̱nga nꞌa xe̱ni ar ha̱i. Ka gehnu̱ habu̱ bi da̱gi nzitꞌe̱i, ne bi fo̱ ár mu̱i, gatho yá xefo bi nxani. ");
INSERT INTO otqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ne gatho ya me Herusalen bi bö nöꞌö bi thogi, jange bi thuꞌspabi nor ha̱iꞌö ha yá hñöꞌu̱: Aseldama, di bo̱ni da ꞌñenö, ar Ha̱iji. ");
INSERT INTO otqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bi njapꞌu̱ ngu xi tꞌotꞌa hár Tꞌofo Jö ne ha ya Dönga Nsa̱di habu̱ enö: Nda nhwata ár nguꞌö, hinto ma da mꞌu̱hnu̱. Ne enö nꞌe: Nunár ꞌbe̱fihmö, manꞌar jöꞌi da me̱fi. ");
INSERT INTO otqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jange mahyoni ga hwañhu̱pya nꞌa togo ndi ñꞌohu̱ nuya paꞌu̱ ndi ꞌbu̱hwihu̱ ma tsi Hmuhu̱ Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bi du̱ꞌmi da ñꞌohu̱ núꞌmu̱ mi xixthe ar Xuwa ne hiñhamꞌu̱ bi ꞌwege, bi zo̱nga ar pa mi tsꞌixa ar tsi Hmu mhetsꞌi. Nöꞌö togo ma ga hwañhu̱ go ma da ma̱xkagihu̱ ga da̱hu̱ majöni, nuna ma tsi Hmuhu̱ Hesu xi mengi xi nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bi hwañꞌu̱ yoho ya ku, nꞌa már thuhu ar Huse nöꞌö xki thuꞌspabi ar Barsaba, ne mi tꞌembabi ar ꞌYomañho, ne bi nhwahna manꞌa ár thuhu ar Matia. ");
INSERT INTO otqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nepꞌu̱ bi ꞌya̱pabiꞌu̱ Jö ne bi ꞌñenö: —Ma tsi Dadaꞌihe, gi pötka ma mfenihe, utkagihe nuya yoho ya ku ꞌbu̱kwa, togo xka hwahni. ");
INSERT INTO otqNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nuꞌge go gi pödi togo xka hwahni da me̱pꞌaꞌi. Ne gi ꞌñetsꞌi ngu ri mpo̱te, da po̱ta ar Huda nöꞌö togo bi ntsꞌoki, ne bi ꞌwege bi gu̱ ar ꞌñu habu̱ ndi ꞌñepi nda ma. ");
INSERT INTO otqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ne nuꞌu̱ bi ꞌye̱ntsꞌa nꞌar nthöhö, ne bi bo̱nga ár thuhu ar Matia. Jange bi mꞌede ngu nꞌa nuꞌu̱ ꞌre̱tꞌamayoho yá ma̱xte ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nu mi zo̱ ar da̱ngo ár thuhu Pentekoste, gatho ya ku xki mhuntsꞌa ha nꞌadar ngu, ne nꞌadar mfeni mi pe̱sꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nꞌa mbi nhekitho nꞌar döta ñu̱ni ndi ꞌñe mhetsꞌi ngu nꞌar ꞌyomndöhi, ne xa bi fatꞌa mbo ar ngu. ");
INSERT INTO otqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne bi nheki ꞌra ngu ya jöhne faspi xki ñhege mi ꞌba̱ ha yá ñö nꞌa ngu nꞌa nuꞌu̱ mi ꞌbu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne gathoꞌu̱ bi hñömba ár nzini ár Hñö Jö, ne bi ndu̱i bi ñö maꞌra ya hñö nꞌa ngu nꞌa, ngu mi japabi ár Hñö Jö nda ñöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nuya paꞌu̱ mi ꞌbu̱hnu̱ Herusalen ꞌra ya xodyo, habu̱ gatho ár nxidi ar ximha̱i xki ꞌñehe, gehyu̱ mi ndönga Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ne núꞌmu̱ mi ntꞌo̱de ar döta ñu̱ni, nze̱ye̱ ya jöꞌi xa dama bi mhuntsꞌi habu̱ mi ꞌbu̱ ya ku, ne bi ꞌyo̱tho ngetho mi o̱xa yá hñö nꞌa ngu nꞌayu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ne himi pödi te nda beni, mi eñꞌu̱: —Hage hingya me Ngalilea nuyu̱ di o̱hu̱ ñö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nuꞌmú̱, hanja di o̱hu̱ nꞌa ngu nꞌa ma hñöhu̱ di ñöhu̱ har ha̱i xta mꞌu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ngetho ꞌra dar menguhu̱ Partia ne Media, Elam, Mesopotamia, Nhudea, Kapadosia, Mponto, ne Asia. ");
INSERT INTO otqNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Maꞌra ya me Frigia, Panfilia, Ehipto, ne ꞌra ya hnini Afrika tho ár yapꞌu̱ ar ha̱i Sirene. Ne maꞌra ya me Nroma, ꞌra majöni ya xodyo, ha nu maꞌra xi nxodyo ngetho te̱mga ma ntꞌumbihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ya me Kreta ne Arabia nꞌehe, gatho di o̱hu̱ ma hñöhu̱ ñöyu̱ ngu di ñöhu̱ nꞌa ngu nꞌa, ne xikagihu̱ yá döta ꞌbe̱fi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nuya jöꞌi himi pödi te nda beni, ne xa mi ꞌyo̱tho mi enga nꞌa ngu nꞌa: —Xipya, te di bo̱mpyanu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ha maꞌra mi thentho mi eñꞌu̱: —Xi ntiyu̱ zëi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nuꞌmú̱ ar Pedro bi mꞌa̱hwi nuꞌu̱ ma ꞌre̱tꞌamanꞌa yá mi ma̱xtewi. Bi ñö ntsꞌe̱di ne bi ꞌñenö: —Nuꞌahu̱ me Nhudea, ne gatho nuꞌahu̱ gi ꞌbu̱hu̱wa Herusalen, ꞌyo̱xu̱ xiñho nöꞌö ma ga mö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nuya togo gi o̱hu̱ ñö, hinxi nti ngu xka beñhu̱, ngetho jar gu̱to xudi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nöꞌö gi hanthu̱ xi thopya, gehnu̱ xki mönga ar mꞌe̱hni Hoel ma nda njapꞌu̱. Xki ꞌyotꞌa njawa: ");
INSERT INTO otqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jö bi ꞌñenö: Nuya pa xi ꞌñepꞌu̱, ma ga pe̱mpa ma Hñö gatho ya meximha̱i. Nuya ri tꞌu̱hu̱ ne ri tꞌinxuhu̱ ma da ñö di hömpa ár tsꞌe̱diꞌö. Nuya bötsi ma da hyanda ya nthandi, nuya dönzia ma da ꞌwi ya tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Xa majöni nuya paꞌu̱, nuya ñꞌo̱ho̱ ne ya ꞌbe̱hñö di pe̱pkagi, xa ma ga umba ma Hñö. Gehnu̱ da umba tema da möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ne ma ga utꞌwaꞌu̱ ꞌra ya döta ntꞌudi mañö mhetsꞌi ne nuwa har ximha̱i, ár ntꞌudi ar ji, ar tsibi, ne ar ꞌbifi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma da nheki da boka ar hyadi. Ar zönö ma da the̱nga ngu ar ji. Mꞌe̱fa da zo̱ ar pa da e ar tsi Hmu. Geꞌö ar pa ma da nheki ár döta tsꞌe̱diꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne gatho nuꞌu̱ da matwa ár thuhu ar tsi Hmu, da mpo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nuꞌahu̱ gar menguhu̱ Israel, ꞌyo̱hu̱ nöꞌö tema ga xiꞌahu̱: Gi pöhu̱ ar Hesu me Nasare, gatho nuꞌu̱ ya döta ntꞌudi bi ꞌyo̱tꞌe ga hyanthu̱, bi ꞌyo̱tꞌe mi hömpa ár tsꞌe̱di Jö, ne njapꞌu̱ mi ñꞌu Jö go xki me̱ñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ha nuꞌahu̱ ga ju̱hu̱, ne ga da̱thu̱ ha yá ꞌye̱ ya ꞌyo̱tꞌatsꞌoki, ne bi hyoꞌu̱ ha nꞌar pontꞌi. Gatho nöꞌö bi thogi, bi njapꞌu̱ ngetho Jö go xki bense̱ nda japꞌu̱ ngu mi neꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ne gese̱ Jö bi japi bi nte manꞌagi. Njapꞌu̱ bi gu̱ka har u̱gi mi ꞌbu̱i xki du, ngetho ar ndöte himi pe̱ꞌsa ar tsꞌe̱di nda zömꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ar ndö Dabi xki no̱ñꞌö núꞌmu̱ bi ꞌñenö: Ndi handga Jö hyaxꞌmu̱ ndi ꞌbu̱ꞌbe, ꞌba̱ ha ma ñꞌe̱i, hinga ntsu. ");
INSERT INTO otqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jange nuga xa di johya ne di petwa maꞌra nor johyaꞌö. Ne di to̱ꞌmi núꞌmu̱ xka tu, ma ga pengi ga nte. ");
INSERT INTO otqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ngetho nuꞌge, ma tsi Dadaꞌi, hinge ma gi tsohnu̱ ma te habu̱ bi ku̱ gatho nuꞌu̱ xi du. Ne hingi ma gi hye̱ ma ndoꞌyo da ꞌya har ha̱i, ngetho go ri hoga ꞌbe̱gogi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Xka utka ar ꞌñu tsixka har te, ne ma gi ꞌraka nꞌar döta johya nu xka ꞌbu̱hwipu̱ mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nuꞌahu̱ ma tsi kuhu̱ xka mhunshu̱wa, ngu xka pöhu̱, ma palehu̱ ar Dabi bi du, bi tꞌa̱gi, ne nuya payu̱ di handwathobihu̱ ꞌbu̱kwa ár tꞌa̱gi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ha nunar Dabi már mꞌe̱hni Jö mi mönga nöꞌö ma nda thogi. Ne mi pödi ma nda mꞌu̱ nꞌár tꞌu̱ togo nda po̱tꞌö, ngetho njapꞌu̱ xki ñötꞌwa Jö. Ne nór tꞌu̱ꞌö gehnu̱ ar Kristo xki ñhötꞌwabi nda mꞌe̱hni nda ndö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jange ar Dabi xki tꞌutwa nöꞌö mꞌe̱fa bi thogi. Ne bi ꞌyotꞌi ma nda mengi nda nte ar Kristo, ne hinge nda gohnu̱ ár te habu̱ ku̱ nuꞌu̱ xi du, ne hinge nda ꞌyanu̱ ár ndoꞌyo har ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nuje di da̱he majöni, Jö bi japi bi nte manꞌagi nunar Hesunu̱ di no̱ñhe. ");
INSERT INTO otqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jange nupya xi tꞌexa hár ñꞌe̱i Jö, bi nju̱xa mhetsꞌi ba huxkwi ár Dada. Ne bi umba ár Hñö Jö xki ñhötkagihu̱. Gehnu̱ ba pe̱nkagihu̱, ne xi tho nöꞌö xka hyanthu̱ ne xka ꞌyo̱hu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ar ndö Dabi himbi nju̱xa mhetsꞌi, ha go bi ꞌñeñꞌö: Jö ar Dada bi ꞌñemba ma tsi Hmu: Hñu ha ma ñꞌe̱i ga huxkwi, ");
INSERT INTO otqNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","to̱ꞌmi ga tsiñꞌa nuya ri ñꞌu̱ni ga tse̱pꞌa ha ri wa. ");
INSERT INTO otqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nupya, mahyoni da bö gatho ya me Israel, hinto di yomi: Jö ar Dada xi hñuxa ar Hesu ngu ar Hmu ne ar Ndö, ngetho gehnu̱ ar Kristo xpa pe̱ñꞌö, togo ga tsu̱thu̱ har pontꞌi ga hyohu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ha nu mi ꞌyo̱de nöꞌö bi mönga ar Pedro, nuya jöꞌi mi ꞌbu̱hnu̱ xa bi du yá mu̱i, ne bi ꞌya̱mba ar Pedro ne nuꞌu̱ maꞌra yá mpo̱te ar tsi Hmu mi ꞌbu̱hnu̱, ne bi ꞌñeñꞌu̱: —Ma tsi kuhu̱, xiꞌmu̱ tema mahyoni ga pe̱hepya. ");
INSERT INTO otqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nuꞌmú̱ ar Pedro bi ꞌñembabi: —ꞌYo̱thu̱ ár ntso̱ꞌmi, ne gi nxixthehu̱ gatho hár thuhu ar tsi Hmu Hesukristo. Njapꞌu̱ da pumpꞌahu̱ ri tsꞌokihu̱, ne gi hñöñhu̱ ár Hñö Jö da mꞌu̱ ha ri mu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ngetho nuna ar ñhötꞌinu̱ go xi tꞌaju̱ ne ma bötsihu̱, ne gatho nuya maꞌra ya jöꞌi ꞌbu̱ hár nxidi ar ximha̱i, nuꞌu̱ da zohna Jö ma Hmuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ar Pedro xa mi zo ya jöꞌi, ne mi xipa nze̱ye̱ ya mhö, ne mi embabiꞌu̱: —Mpo̱hu̱, ne hinda zu̱ꞌahu̱ ár mfe̱i to̱ꞌma nuya tsꞌojöꞌi ꞌbu̱ nuya payu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Gatho nuꞌu̱ togo bi ꞌñetꞌa yá mu̱i nöꞌö te mi möñꞌö, bi nxixthe. Jange nu ar paꞌö bi hñuxa ngu nꞌa̱temaꞌre̱tꞌanthebe ya gamfi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ne nuyu̱ mi te̱nda nöꞌö mi xipa yá ma̱xte ar tsi Hmu, ne nꞌadar mfeni mi pe̱sꞌu̱. Ne hyaxꞌmu̱ mi ntꞌoxi mahye̱gi ne mi tsipa ár tꞌoxi ar tsi Hmu, ne mi matꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gatho ya mengunu̱ xa bi ntsu, ngetho xki hyandwa yá ma̱xte ar tsi Hmu mi o̱tꞌa nze̱ye̱ ya döta ntꞌudi, ne ya ꞌbe̱fi xa mi ꞌyo̱tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ne gatho ya gamfi mi mpe̱ mahye̱gi, ne mi mfa̱xa nꞌa ngu nꞌa, njapꞌu̱ hinte nda kꞌatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ne mi pa̱ꞌu̱ nöꞌö te mi pe̱sꞌu̱, ne mi thekwabi nöꞌö te mi kꞌatꞌa nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ne hyaxtho mi mhuntsꞌa har dönganijö, mi pe̱sꞌu̱ nꞌadar mfeni. Ne mi tsiꞌu̱ ár tꞌoxi ar tsi Hmu ha yá nguꞌu̱, ne xa mi johya mi ñuñꞌu̱ mahye̱gi, ne mi pe̱sꞌu̱ nꞌar hogamu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ne mi nsunda Jö mahye̱gi. Ne maꞌra ya jöꞌi mi handa te mi pe̱ꞌu̱, mi numañhoꞌu̱. Ne hyaxꞌmu̱ ar tsi Hmu mi huꞌsa ya gamfi, hyaxtho mi ñꞌemu̱i maꞌra ne nda mpo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nꞌar pa ar Pedro ne ar Xuwa yá ma̱xtehmö ar Hesu, ndi ma har dönganijö ngu hñu nde, geꞌmu̱ mi jar mhatꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ne nu hár goxthi ar dönganijö ár thuhu Nza̱tho, ka mi huhnu̱ nꞌar ñꞌo̱ho̱ xki mꞌu̱i mi dowa. Hyaxtho mi tꞌehnu̱ mi a̱pa ar tsi bojö gatho nuꞌu̱ mi thohnu̱ ndi yu̱tꞌa har nijö. ");
INSERT INTO otqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nunar tsi dowanu̱ nꞌa mbi hyandatho ar Pedro ne ar Xuwa, ma nda yu̱tꞌa har nijö, bi ꞌya̱pa nꞌar tsi bojö. ");
INSERT INTO otqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nuꞌmú̱ ar Pedro ne ar Xuwa bi mꞌa̱i, bi ñhanda habu̱ mi hu ar tsi me̱tí, ne ar Pedro bi ꞌñembabi: —Hyandgagihe. ");
INSERT INTO otqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nu ar tsi dowa xa bi gohi mi kꞌötꞌa nuya yohoyu̱, mi to̱ꞌmi te nda hwëkwabi. ");
INSERT INTO otqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nuꞌmú̱ ar Pedro bi ꞌñembabi: —Hinte di hö ar tꞌaxbojö wa ar kꞌaxtbojö ga ꞌraꞌi. Ho̱nse̱ nöꞌö di pe̱tsꞌi, geꞌö ga ꞌraꞌi. Hár thuhu ar Hesukristo mar me Nasare, di xiꞌaꞌi, nangi gi ꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ne bi mipa ár ñꞌe̱i, bi ꞌba̱ꞌmi, ne bi me̱ꞌsa ár tsꞌe̱di yá wa ne yá bosndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Dama bi ꞌye̱nga nꞌar nsa̱gi bi mꞌa̱i xiñho, ne bi ñꞌo. Bi me̱wiyu̱ bi yu̱tꞌa mbo ar nijö, mi ꞌyo ne xa mi sa̱gi mi matꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ne gatho ya jöꞌi bi hyanda ar dowa mi tsa̱ nda ñꞌo ne mi matꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Dama bi bötꞌu̱ go mi gehnu̱ togo mi dowahmö, mi hu hár goxthi ar nijö ár thuhu Nza̱tho, mi a̱ ar tsi bojö. Xa bi ꞌyo̱tho ne xa bi zuꞌu̱ nöꞌö xki thogi. ");
INSERT INTO otqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nöꞌö ar ñꞌo̱ho̱ mar dowahmö himi ne nda hye̱ ar Pedro ne ar Xuwa. Ne gatho ya jöꞌi xa mi ꞌyo̱da nöꞌö mi handi, jange dama bi mhuntsꞌa ha ya mꞌetꞌe ár thuhu ar Salomon, habu̱ mi ꞌbu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ar Pedro mi hyanda xki mhuntsꞌa ya jöꞌi, bi ꞌñembabiꞌu̱: —Nuꞌahu̱ gar me Israelhu̱, hanja xa gi ꞌyo̱thu̱ ne xa gi kꞌötkagihe. Ha gi beñhu̱ ma tsꞌe̱dise̱he, wa xa di ꞌbu̱he xiñho, jange xta jafe xi ñꞌo nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jö togo mi ndönga ar Abra ne ar Isa ne ar Hakob, ne gatho nuꞌu̱ maꞌra ma palehu̱ xi du, getꞌö ar Jö togo bi japi bi ñꞌo nunar ñꞌo̱ho̱nu̱, ne bi ꞌñeꞌspa ár nsu ar Hesukristo ár Tꞌu̱ꞌö. Gehnu̱ togo ga da̱thu̱ ya ndö, ne ga xifu̱ ar Pilato hinge nda hye̱gi, mödi mi nemhö nda hye̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ha nuꞌahu̱ hinga nehu̱, mödi gehnu̱ ár hoga Tꞌu̱ Jö hinte ma tsꞌoki xki ꞌyo̱tꞌe. Ne ga ꞌya̱hu̱ nda the̱ nꞌar hyote. ");
INSERT INTO otqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ne njapꞌu̱ ga hyohu̱ togo hö ar te. Ha Jö bi japi bi nte manꞌagi. Go da hanthe, jange di da̱he majöni. ");
INSERT INTO otqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Go di ñꞌemu̱ibiheꞌö, jange nunar ñꞌo̱ho̱nu̱ gi hanthu̱ ne gi pöhu̱, xi ditsꞌi, ne njapꞌu̱ xi ñꞌu ár tsꞌe̱diꞌö. Xi o̱the nunar ñꞌo̱ho̱ gi hanthu̱pya. Xi njapꞌu̱ ngetho di ñꞌemu̱ibihe. ");
INSERT INTO otqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tsi kuhu̱, di pöhe xiñho ga da̱hu̱ ar Hesu ngetho hinte ngi pöhu̱, ngu nuꞌu̱ ma ndöhu̱ himbi zo yá mfeni nꞌehe teme bi ꞌyo̱tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Njapꞌu̱ Jö bi japi nda thogi ngu xki xipabi yá mꞌe̱hni mahamꞌu̱, xki ꞌyotꞌu̱ mi mahyoni ar Kristo nda tho ya u̱gi, ne nda du. ");
INSERT INTO otqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jange ꞌyo̱thwu̱ ár ntso̱ꞌmi ne penju̱ gi hyoñhu̱ Jö, ne da pumpꞌahu̱ ri tsꞌokihu̱. Njapꞌu̱ hö, da ꞌraꞌahu̱ nꞌar hogamꞌu̱i, ter entho gi ꞌbu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ne da mengi da me̱ñꞌahu̱ ar tsi Hmu Hesukristo xki thuxa mamꞌe̱tꞌo nda me̱hni. ");
INSERT INTO otqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ne xa majöni bi bo̱xnu̱ mhetsꞌi, bi ꞌbu̱hnu̱ to̱ꞌmda ar pa Jö da hoka maꞌraꞌyo gatho, ngu xki xipa mahamꞌu̱ yá hoga mꞌe̱hni nda möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ngu bi mönga ar Moise, bi xipa ma palehu̱ ne bi ꞌñembabiꞌu̱: Jö ma tsi Hmuhu̱ ma da hñuxꞌa nꞌaꞌahu̱ ngu ár mꞌe̱hniꞌö, njangu xi hñuxkagi nꞌehe, ne ma gi ꞌyo̱thu̱ nöꞌö da xiꞌahu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ne gatho nuꞌu̱ hinda ne da ꞌyo̱ta nöꞌö ar mꞌe̱hniꞌö, ma da ꞌweka har hnini. ");
INSERT INTO otqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Di ndu̱ ar Samuel injawa, gatho nuyá mꞌe̱hni Jö xi no̱nga nuya pa di ꞌbu̱hu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ne gatho nuꞌu̱ ya ñhötꞌi bi mönga nuya mꞌe̱hniꞌu̱, go xiꞌahu̱. Ne nuꞌu̱ ya njöpi bi nkohwi Jö ma palehu̱, xi zokꞌahu̱ nꞌehe. Jange Jö bi ꞌñembabi ar Abra: Ha nꞌa ri nꞌogi ma da e mꞌe̱fa, ma ga jöpa xo̱ge ya jöꞌi ꞌbu̱ hár nxidi ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ne nuꞌahu̱ go gar ꞌbe̱tꞌohu̱ ba pe̱ñꞌahu̱ ár Tꞌu̱ Jö, bi jöpꞌahu̱ gi hye̱hu̱pꞌu̱ ri tsꞌokihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ar Pedro ne ar Xuwa mi ꞌbu̱hnu̱ har dönganijö mi zo ya jöꞌi. Nꞌa mbi zo̱hnu̱ ꞌra ya möjö mi ñꞌowi ár ndö ya sunijö, ne ya de̱ngamöjö nuꞌu̱ himi ñꞌemu̱i nda mengi nda nte nuꞌu̱ xi du. ");
INSERT INTO otqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Xa bi mbo̱ yá kwe̱ mi böꞌu̱ ar Pedro ne ar Xuwa mi uta ya jöꞌi nda mengi da nte nuꞌu̱ xi du, ngu bi mengi bi nte ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nuꞌmú̱ bi nju̱ ar Pedro ne ar Xuwa, ne bi tsꞌitsꞌi ba njotꞌa har fa̱di. Ne ka bi gohnu̱ nor nxuinu̱, ngetho xki nde nor paꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ha nuꞌu̱ togo xki ꞌyo̱de nöꞌö mi mönga ar Pedro, nze̱ye̱ bi ñꞌemu̱i, mi tsu̱ ngu ngu̱dminthebe ya ñꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nu ár hyaxꞌö bi mhuntsnu̱ Herusalen yá dönziandö ya xodyo, ya bötꞌofo, ne gatho nu maꞌra yá ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gathoyu̱ bi mhuskwi mahye̱gi ar Anas, gehnu̱ mar döngamöjö. Ka mi ꞌbu̱hnu̱ ar Kaifas, ar Xuwa ne ar Handro, ne gatho nuyá mëni ya döngamöjö. ");
INSERT INTO otqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nepꞌu̱ bi tsꞌixnu̱ ar Pedro ne ar Xuwa, bi mꞌa̱ꞌma madetho ne bi tꞌa̱mbabi njawa: —Togo yá mꞌe̱hniꞌihu̱, ne togo ár tsꞌe̱di gi hömfu̱ gi pe̱hu̱ njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nuꞌmú̱ ar Pedro xki nzinga ár Hñö Jö bi ꞌñembabiꞌu̱: —Nuꞌahu̱ gár ndöhu̱ ha ma hninihu̱ Israel. ");
INSERT INTO otqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ngetho gi ñꞌa̱nihu̱ nöꞌö ar ñho bi tꞌo̱tꞌwa nunar tsi ñꞌo̱ho̱nu̱ mi dowa, ne gi ne gi pöhu̱ hanja bi ditsꞌi, ");
INSERT INTO otqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ma ga xiꞌahe hanja bi za̱ bi dixhnu̱, ne njapꞌu̱ gi pöhu̱ ne gatho nuꞌu̱ maꞌra ya me Israel. Nunar ñꞌo̱ho̱ gi hanthu̱ ꞌba̱hnu̱, nunu̱ bi ditsꞌi bi mhömba ár thuhu ar Hesukristo mar me Nasare, nöꞌö ga tsu̱thu̱ ha nꞌar pontꞌi, ne Jö bi japi bi mengi bi nte manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gehnu̱ ar Hesu ga u̱tsahu̱, gi ñhe̱hwihu̱ nꞌar guxjödo bi ꞌye̱mpꞌu̱tho ar mu̱di do nöꞌö ma nda hyoka ár nijö Jö. Ha nupya gehnu̱ ar mu̱di do xi njuꞌspa ár nijö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hinjoꞌo manꞌa togo da ꞌraju̱ ar tsꞌe̱di ga mpo̱hu̱, ho̱nse̱ ma tsi Hmuhu̱ Hesu. Ngetho hinjoꞌo manꞌa xi tꞌumba nunar tsꞌe̱dinu̱ ne da thokwa ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nuꞌmú̱ nuya ndö mi ꞌbu̱hnu̱ xa mi ꞌyo̱tho, ngetho bi hyanda ar Pedro ne ar Xuwa himi ntsu. Ne mi pöꞌu̱ himya ñꞌo̱ho̱ mi pe̱ꞌsa ar döta mfödi, gehyu̱ ma ya hyoya jöꞌi. Njapꞌu̱ bi böꞌu̱ xki ñꞌowi ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ne himbi za̱ te bi dötwabiꞌu̱, ngetho bi hyandi mi ꞌba̱hwiꞌu̱ nöꞌö ar tsi dowa xki ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nuꞌmú̱ nuya ndöꞌu̱ bi ꞌbe̱pabi nda bo̱nga har mhuntsꞌi, ne bi gohnu̱thoꞌu̱ mi ñöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ne mi eñꞌu̱: —Xipya, te ga jafu̱ nuya ñꞌo̱ho̱yu̱. Ngetho xi ꞌyo̱tꞌa nꞌar döta ntꞌudi, pö gatho ya jöꞌiwa ha ma hninihu̱ Herusalen, ne hinda tsa̱ ga ko̱ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Hindi nehu̱ da nu̱ngar ꞌbede. Ma ga zoñhu̱ ne ga pihu̱, ne njapꞌu̱ hinto ma da zofo hár thuhu ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nepꞌu̱ bi tsꞌohna manꞌagi ar Pedro ne ar Xuwa, bi pidi, ne bi nsipabi hinte nda möñꞌu̱, ne hinto nda zofo hár thuhu ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nuꞌmú̱ ar Pedro ne ar Xuwa bi dödi ne bi ꞌñenö: —Beñhu̱, hage da ꞌñetꞌa mañho ár mu̱i Jö ga o̱tꞌahe mꞌe̱tꞌo ne mꞌe̱faꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ngetho hinda tsa̱ ga he̱he ga möñhe nöꞌö xta hanthe ne xta o̱he. ");
INSERT INTO otqNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nuꞌmú̱ nuya ndö bi hñuꞌspar pidi, njapꞌu̱ hinte nda xipabi ya jöꞌi, ne bi hye̱gi bi maꞌu̱. Himbi tsa̱ te bi japabi, ngetho mi tsu ya jöꞌi nda mbo̱ yá kwe̱. Gatho xa mi umba njamödi Jö nöꞌö bi ꞌyo̱tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ngetho nöꞌö ar ñꞌo̱ho̱ xki tꞌo̱tꞌwa ar ntꞌudi xki ditsꞌi, mi tho yonꞌa̱te nje̱ye̱ xki mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nu mi nthe̱ ar Pedro ne ar Xuwa, bi ma ba kꞌöꞌsa nuꞌu̱ maꞌra ya gamfi, ne bi metwabi nöꞌö xki xipabi ya ndömöjö ne yá dönziandö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ha nu mi ꞌyo̱ ya ku, nꞌadar mfeni bi umba njamödi Jö, ne bi ꞌñeñꞌu̱: —Ma tsi Hmuꞌihe, go geꞌe ar Jö togo ga hoka mhetsꞌi ne ar ximha̱i, ar dehe ne gatho nöꞌö te janu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nuꞌge ga xipa ri ꞌbe̱go ar Dabi nda mönga njawa: Yoꞌö ya jöꞌi bi mhuntsꞌi bi ñꞌu̱tꞌu̱ hanja nda ꞌyo̱tꞌa ar tsꞌomꞌu̱i, ne nuya hnini te gatho bentho da ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bi mhuntsꞌa gatho yá ndö ya hnini ne yá ma̱xte ꞌbu̱ har ximha̱i, ne nꞌatꞌwu̱ bi ñꞌu̱tꞌu̱ nda u̱tsa Jö ne ár Kristo togo xi hñuxꞌö da ndö. ");
INSERT INTO otqNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ngetho xa majöni har hnininu̱, bi mhuntsꞌa ar ndö Erode ne ar Ponsio Pilato, ya me Israel ne nuꞌu̱ himya me Israel, bi u̱tsa ri hoga Tꞌu̱ ar Hesu togo xka ꞌñetsꞌi da ndö. ");
INSERT INTO otqNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ne bi ꞌyo̱tꞌu̱ ngu nöꞌö xka beni, ne xka mönga mamꞌe̱tꞌo nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ha nupya ma tsi Hmuꞌihe, hyanda hanja huꞌsje ya jöꞌi. Ne fa̱xkagihe hinga ntsuhe ga möñhe ri mhö, ngetho go ri ꞌbe̱gogihe. ");
INSERT INTO otqNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne hñuxke ri ꞌye̱ ha ya da̱thi da dixꞌu̱. Ne gi ꞌyo̱tꞌa nze̱ye̱ ya döta ntꞌudi hár thuhu ri hoga Tꞌu̱ Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ngu mi waꞌu̱ bi ñöwi Jö, bi nhwönga ar ngu habu̱ xki mhuntsꞌi. Ne gatho nuꞌu̱ mi ꞌbu̱hnu̱ bi nthe̱xkwi ár nzini ár Hñö Jö, ne himbi ntsuꞌu̱ bi mömba ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ne gatho nuꞌu̱ xki ñꞌemu̱i ár mhö Jö, mi pe̱ꞌsa nꞌada ar mfeni, ne nꞌada yá mhöteꞌu̱. Gatho nöꞌö mi pe̱sꞌu̱, mahye̱gi mar me̱tiꞌu̱. Himi njoꞌo nꞌar ku mi enö te mi pe̱tsꞌi mar me̱tise̱. ");
INSERT INTO otqNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ne xa mi pe̱sꞌu̱ ar tsꞌe̱di yá mpo̱te ar tsi Hmu Hesu, mi da̱majöni xki mengi xki nteꞌö, ne Jö xa mi hwëkwabiꞌu̱ ár mfa̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ha hinto mi thoꞌu̱ ar kꞌatꞌi, ngetho gatho nuꞌu̱ mi pe̱ꞌsa yá ha̱i ne yá ngu mi pa̱ꞌu̱, ne mi hö gatho nöꞌö mi njutꞌwabi, ");
INSERT INTO otqNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ne mi umba yá mpo̱te ar tsi Hmu. Ha nuyu̱ mi hekwabi nꞌa ngu nꞌa ya gamfi, ngu nöꞌö mi o̱tꞌwa ar ꞌbe̱di, njapꞌu̱ mi tꞌumbabi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ne mi ꞌbu̱hnu̱ nꞌar ku már thuhu ar Huse me Txipre, xki ꞌñe ha yá ꞌbe̱to ar Lebi. Ha nuyá mpo̱te ar tsi Hmu bi hñuꞌspabi ar Berhnabe, di bo̱ni da ꞌñenö, nöꞌö huꞌmba yá mu̱i maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nöꞌö mi pe̱ꞌsa nꞌa xe̱ni ar ha̱i, bi gu̱ bi ma̱, ne gatho ar bojö bi njutꞌwi ba hö bi da̱twa yá mpo̱te ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mi ꞌbu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Anania, ha nunár ꞌbe̱hñö már thuhu ar Safira. Nuyu̱ bi ma̱ nꞌa xe̱ni ar ha̱i mar me̱tiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ne bi zöma nꞌa xe̱ni ar bojö xki njutꞌwabi ar ha̱i, ne ár ꞌbe̱hñö bi bödi nꞌehe. Nöꞌö manꞌar xe̱ni bi ma ba da̱twa yá mpo̱te ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nuꞌmú̱ ar Pedro bi ꞌñembabi: —Anania, hanja xka hye̱ ar tsꞌondöhi xi hya̱ꞌaꞌi. Yoꞌö xka ne ngi hya̱tꞌa ár Hñö Jö. Ngetho hinga unga gatho ar bojö bi njutꞌa ri ha̱i ga pa̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nuꞌmu̱ xka tsöma ri ha̱i go ma ri me̱ti, ne nöꞌö ar bojö bi njutꞌaꞌi go ma ri me̱ti nꞌehe. Yoꞌö ga beni ga japꞌu̱. Hinge go xka kakagihe, xka beni gi ka Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nu mi ꞌyo̱ njapꞌu̱ ar Anania, bi hwangi xki du. Ne gatho nuꞌu̱ maꞌra bi bö nöꞌö xki thogi, xa bi zuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nepꞌu̱ nuya bötsi mi ꞌbu̱hnu̱ bi gu̱ bi ma̱tsꞌi, ne bi gu̱ki ma ba a̱gi. ");
INSERT INTO otqNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Xki tho ngu hñu xe̱nimpa, bi yu̱tnu̱ ár ꞌbe̱hñö nꞌehe. Ha nunu̱ hinte mi pödi te xki thogi. ");
INSERT INTO otqNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ne ar Pedro bi ꞌñembabi: —Ha gi o̱de. Xikagi, hage bi njutꞌahu̱ njanu̱ ar ha̱i ga pa̱hu̱. Nuꞌmú̱ nöꞌö bi dödi ne bi ꞌñenö: —Hö, njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nuꞌmú̱ ar Pedro bi ꞌñembabi: —Yoꞌö ga nkohwi nꞌada ar nkohi ri döme, ne ngi hya̱thmöhu̱ ár Hñö ma tsi Hmuhu̱. Xi ꞌñehnu̱ har goxthi nuꞌu̱ togo xpa pengi ba a̱kꞌa ri döme, ha nupya xpa ehe da duxꞌaꞌi ma da ꞌya̱kꞌaꞌi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nuꞌmú̱ ar Safira bi hwangi xki du ha yá wa ar Pedro. Ne mi yu̱tꞌa nuꞌu̱ ya bötsi, bi hyandi xki duꞌö nꞌehe, dama bi dutsꞌi bi ma ba a̱gi habu̱ mi o ár döme, ka bi tꞌa̱pꞌu̱tho nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nepꞌu̱ gatho nuya ku bi bödi tema bi jayu̱, xa bi ntsu, ngu gatho nuya bi zo yá gu. ");
INSERT INTO otqNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nuyá mpo̱te ar tsi Hmu mi o̱tꞌa nze̱ye̱ ya döta ntꞌudi mi handa ya jöꞌi. Ne gathoyu̱ mi pe̱sꞌu̱ nꞌada ar mfeni mi mhuntsꞌa ha ya mꞌetꞌe mi tꞌembabi ár thuhu Salomon. ");
INSERT INTO otqNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gatho nuꞌu̱ himya ku mi ntsu nda mhunskwiꞌu̱, mödi mi numañho gatho nöꞌö mi o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ne mi ꞌyo mi ñꞌemu̱i ar tsi Hmu nze̱ye̱ ya jöꞌi, ya ñꞌo̱ho̱ ne ya ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ne ꞌyo mi födi nuya ntꞌudi mi o̱tꞌu̱. Jange mi nju̱ka ya da̱thi nthi ha ya ꞌñu, ne mi ꞌbe̱ ha ya fidi, ne núꞌmu̱ nda thohnu̱ ar Pedro, mödi nda zu̱hmö ho̱nse̱ ár xudi, nda dixa ya da̱thi. ");
INSERT INTO otqNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nze̱ye̱ ya jöꞌi mi ꞌbu̱ ha ya hnini getꞌu̱ Herusalen, mi pa mi tsixa ya da̱thi ne nuꞌu̱ mi nthe̱xkwi ya tsꞌondöhi, gathoyu̱ mi thitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nepꞌu̱ bi nju̱xa ar döngamöjö ne ya de̱ngamöjö mi mfa̱xꞌu̱, ngetho xki zo̱tꞌa yá mu̱i, hinto mi ne nda hñömba yá nsu. ");
INSERT INTO otqNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ne bi nju̱mpa yá mpo̱te ar tsi Hmu, bi njotꞌa har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ha nunar nxuiꞌö, nꞌár e̱nxe̱ Jö bi xokwa ár goxthi ar fa̱di, bi gu̱ka nuyá mpo̱te ar tsi Hmu, ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Di ma ba ꞌba̱hu̱ har dönganijö, ba zohu̱ ya jöꞌi, ne xipabihu̱ ar hoga mhö no̱nga ar ꞌraꞌyo te. ");
INSERT INTO otqNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jange ár hyaxꞌö ra nꞌitho, bi maꞌu̱ har dönganijö, ngu xki xipabi ár e̱nxe̱ Jö. Ne nu mi zo̱ñꞌu̱, bi yu̱tꞌa mbo bi zofo ya jöꞌi. Núꞌmu̱ mi ꞌbu̱hnu̱ mi zohyu̱, ar döngamöjö ne yá ma̱xte bi zohnu̱ yá mindöwi me Israel nda me̱ꞌsa nꞌar mhuntsꞌi. Ne bi me̱hna togo nda tsi nuꞌu̱ ya mpo̱te mi jotꞌa har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ha nu mi zo̱nga ya gu̱jöꞌi har fa̱di, himi njoꞌonu̱ ya ꞌyofa̱di. Nuꞌmú̱, dama ba penkꞌu̱ bi mö, ");
INSERT INTO otqNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ne bi ꞌñeñꞌu̱: —Da tiñhe ar fa̱di mi jotꞌi xiñho, ne nuya sufa̱di ka mi ꞌba̱hnu̱ har goxthi. Ha núꞌmu̱ nda ku̱the, hinto da tiñhenu̱ mbo. ");
INSERT INTO otqNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nu mi ꞌyo̱ njapꞌu̱ ar döngamöjö, ne ár ndö ya sunijö, ne maꞌra ya ndömöjö, himi pödi te nda beni, ne mi eñꞌu̱: —Xipya, te di bo̱mpyanu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nꞌa mbi zo̱ta nꞌar jöꞌi, ne bi ꞌñembabiꞌu̱: —Nuꞌu̱ ya ñꞌo̱ho̱ ga kothu̱hmö har fa̱di, bi ꞌbu̱ har dönganijö bi zo ya jöꞌi manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nuꞌmú̱ ár ndö ya sunijö bi me̱wi ya gu̱jöꞌi, ne bi mengi bi gu̱ ya mpo̱te. Ba ju̱ꞌu̱ ne hinte bi japabi, ngetho mi tsu nda mbo̱ yá kwe̱ ya jöꞌi, ne nda umba ya nkꞌahni. ");
INSERT INTO otqNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nepꞌu̱ bi zixa hár mhuntsꞌi ya ndöxodyo, ne bi ꞌba̱ꞌma madetho. Ne ar döngamöjö bi ꞌya̱mbabi: ");
INSERT INTO otqNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Hage hinda xiꞌahe hinge ngi zohu̱ ya jöꞌi, ne hingi no̱mfu̱ ár thuhu ar Hesu. Nuꞌmú̱, hanja hinxka ꞌyo̱hu̱. Gatho ya me Herusalen xka xifu̱ ri jamfihu̱. Ne gi ne gi hyo̱xkagihe da hoje nöꞌö ar ñꞌo̱ho̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nuꞌmú̱ ar Pedro ne gatho nu maꞌra ya mpo̱te, bi dödi ne bi ꞌñeñꞌu̱: —Nuje mahyoni mꞌe̱tꞌo ga o̱the Jö, ne mꞌe̱fa ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jö togo mi ndönga ma palehu̱, go bi japi bi nte manꞌagi ar Hesu, gehnu̱ ga tsu̱thu̱ ha nꞌar za, ne ga hyohu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ne nupya Jö xi ꞌñe hár ñꞌe̱i da ndöwi ne da mpo̱ho̱te, njapꞌu̱ da ꞌyo̱tꞌwa yá ntso̱ꞌmi ya me Israel, ne da mpumba yá tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nuje di da̱he majöni togonu̱, ne ár Hñö Jö da̱majöni nꞌehe, ha Jö xi umba ár Hñö gatho nuꞌu̱ togo o̱te. ");
INSERT INTO otqNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ha nu mi ꞌyo̱ njapꞌu̱ ya ndö, xa bi mbo̱ yá kwe̱, xa mi nehmö nda hyo ya mpo̱te. ");
INSERT INTO otqNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bi nankꞌmu̱ nꞌar ñꞌo̱ho̱ mi ꞌbu̱hnu̱ har mhuntsꞌi mar de̱ngaꞌbe̱pate, már thuhu ar Gamalie, nꞌar bötꞌofo, ne gatho ya jöꞌi xa mi numañhoꞌö. Bi mꞌa̱i ne bi mö nda tꞌe̱nga nꞌa tsi tu̱i ya mpo̱te. ");
INSERT INTO otqNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nepꞌu̱ bi ꞌñembabi gatho ya jöꞌi xki mhunsnu̱: —Ha gi o̱hu̱ ndadahu̱. Hyanthu̱ xiñho nöꞌö te gi jafu̱ nuya ñꞌo̱ho̱yu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Beñhu̱ hingar yapa bi nanga nꞌar ñꞌo̱ho̱ mar thuhu Teuda, mi humamu̱i mi pe̱ꞌsa nꞌar nsu, ne bi de̱nga ngu gohonthebe ya ñꞌo̱ho̱. Bi thoꞌö, ne gatho nuꞌu̱ mi ñꞌowi bi mfontꞌi, ne hinte ponkꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mꞌe̱fa ba e manꞌar ñꞌo̱ho̱ már thuhu ar Huda, mar me Ngalilea, núꞌmu̱ mi nja ar nthuxthuhu. Nöꞌö bi gu̱tꞌa nze̱ye̱ ya jöꞌi bi de̱ni. Bi thoꞌö nꞌehe, ne bi mfontꞌa gatho ya jöꞌi mi ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jange nuga di xiꞌahu̱, hye̱hu̱pꞌu̱ nuya ñꞌo̱ho̱yu̱. Nuꞌmu̱ nöꞌö te pe̱hyu̱ go xi bense̱ꞌu̱, ma da göxtho. ");
INSERT INTO otqNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ha nuꞌmu̱ ár me̱ti Jö nöꞌö te pe̱hyu̱, hinda za̱ gi hñökwabihu̱. Ngetho nuꞌmu̱ gi jahu̱pꞌu̱, po̱ntho gi ntunkwihu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ne nuꞌu̱ mi ꞌbu̱hnu̱ har mhuntsꞌi, bi ꞌyo̱xa nöꞌö te bi möñꞌö. Jange bi mengi bi ku̱tꞌa ya mpo̱te, bi ꞌwe̱xtꞌu̱. Ne bi xipabiꞌu̱ nda hye̱gi nda mömba ár thuhu ar Hesu, ne bi hye̱gi bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ne mi bo̱ñꞌu̱ har mhuntsꞌi, xa mi johyaꞌu̱, ngetho Jö xki ꞌñetꞌamañho ár mu̱i nda tho nꞌar mꞌe̱tsa̱ ngetho mi no̱mba ár thuhu ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ne hyaxꞌmu̱ himi tsa̱ya̱ mi zofo ne mi uta ya jöꞌi har dönganijö, ne mi ꞌyo ha ya ngu mi mömba ár hoga mhö ar tsi Hmu Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nuya paꞌu̱ xa mi xönda ya ku. Ne nuꞌu̱ ya ku mi ñö ar griego bi ñömañꞌu̱bi ya ku mi ñö ar ebreo. Ne mi eñꞌu̱, nuyá ꞌranxu himi tꞌumba mahye̱gi ar ñhuni mi thekwabi hyaxꞌmu̱, ngu nu maꞌra ma ya ebreo. ");
INSERT INTO otqNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nuꞌmú̱ nuꞌu̱ ꞌre̱tꞌamayoho ya mpo̱te bi zohna gatho ya ku ha nꞌar mhuntsꞌi, ne bi ꞌñembabiꞌu̱: —Ma tsi kuhu̱, nuje di ꞌbu̱he ga mömfe ár mhö Jö, hanja ma ga tsa̱ya̱he ga hemfe te da zi nuꞌu̱ hingi jwadi. ");
INSERT INTO otqNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jange hwañhu̱ yotoꞌihu̱ nuꞌu̱ xka hyanthu̱ ꞌbu̱i xiñho, xi nzimba ár Hñö Jö, ne xa di ja ár mfödi. Nuꞌu̱ go ma da me̱ꞌsa nuna ar ꞌbe̱finu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nuje hinga ma ga tsa̱ya̱he ga a̱fe Jö, ne ga mömfe ár mhöꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ha nu mi ꞌyo̱xa nöꞌö xki nsipabi, gatho bi numañho njapꞌu̱. Ne bi nhwahna ar Teba nöꞌö mi pe̱ꞌsa nꞌar döta ñꞌemu̱i, ne xki nzimba ár Hñö Jö, ar Lipe, ar Prokoro, ar Nikanor, ar Timon, ar Parmena, ne ar Nikola mar me Antiokia, xki nxodyo ngetho xki de̱mba yá ntꞌumbiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ne bi tsꞌixa habu̱ mi ꞌbu̱ ya mpo̱te, ne nuyu̱ bi te̱tꞌwa Jöꞌu̱, mi huspa yá ꞌye̱. ");
INSERT INTO otqNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne njapꞌu̱ dama mi nxanga ár mhö Jö, ne ya ku hyaxꞌmu̱ xa mi xu núnu̱ Herusalen, ne nze̱ye̱ ya möjö bi gamfi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ha nu ar ku Teba xa mi pe̱ꞌspa ár tsꞌe̱di Jö ne ár nthekate. Mi o̱tꞌa ya döta ntꞌudi ha yá nthandi ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ne núnu̱ ha yá nijö ya xodyo, nöꞌö mar thuhu Nuꞌu̱ xi The̱gi, bi nju̱xa ꞌra ya ñꞌo̱ho̱, ne bi mfa̱xkwi ꞌra ya me Sirene, maꞌra ya me Alejandria, ya me Nsilisia, ne ya me Asia. Gathoꞌu̱ bi ntsa̱hñökiwi ar Teba. ");
INSERT INTO otqNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Himi tsa̱ te nda dötꞌu̱, ngetho nöꞌö mi pe̱ꞌsa ar hoga mfödi, ne mi hömpa ár tsꞌe̱di ár Hñö Jö mi ñö. ");
INSERT INTO otqNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nepꞌu̱ nuya jöꞌiꞌu̱ bi ꞌyu̱tꞌa ꞌra ya ñꞌo̱ho̱, ne bi guꞌtwabi nda mönga ya nhemhñö, ne nda ꞌñeñꞌu̱, xki ꞌyo̱ꞌu̱ mi tsanga ar Moise, ne mi tsanga Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Njapꞌu̱ bi po̱mpa yá kwe̱ ya jöꞌi, yá dönziandö ya xodyo, ne ya bötꞌofo. Nepꞌu̱ bi nju̱ ar ku Teba, ne ntukitho bi tsꞌixa hár mhuntsꞌa ndö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ne bi njapabi ꞌra ya jöꞌi nda hyo̱xa ya nhemhñö ar ku Teba, ne bi ꞌñeñꞌu̱: —Nuna ar ñꞌo̱ho̱nu̱ hingi tsa̱ya̱ tsanga nuna ar jöpa nijönu̱ ne ár tꞌofo ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nuje go xta o̱he teme xi mö, xi ꞌñenö, nunar Hesu mar me Nasare ma da hwata nunar nijönu̱, ne ma da pa̱ta ma ntꞌumbihu̱ nuꞌu̱ bi utkagihu̱ ar Moise ga o̱thu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nuꞌmú̱ gatho nuꞌu̱ togo mi ꞌbu̱hnu̱ har mhuntsꞌi, núꞌmu̱ mi kꞌötꞌa ar ku Teba, bi hyandwabi ár hmi mi ñhe̱hwi ár hmi nꞌár e̱nxe̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nepꞌu̱ ar döngamöjö bi ꞌya̱mba ar Teba, ne bi ꞌñembabi: —Hage majöni nöꞌö ntho̱xꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nuꞌmú̱ ar Teba bi dödi ne bi ꞌñenö: —Ma tsi kuꞌahu̱, ne ma tsi ndadahu̱, ꞌyo̱hu̱ nöꞌö tema ga xiꞌahu̱. Jö nöꞌö xar nsunda, bi zo ma palehu̱ ar Abra núꞌmu̱ mi ꞌbu̱hnu̱tho Mesopotamia, hinxki mada har ha̱i Aran. ");
INSERT INTO otqNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ne bi ꞌñembabi: Po̱ni, tsokwa nunar ha̱inu̱, ne tsopꞌu̱ nuꞌu̱ te ri njawi. Di ma manꞌar ha̱i habu̱ ma ga utꞌaꞌi, ne ka ma gi ꞌbu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nunar Abra ꞌmu̱, bi bo̱nga habu̱ mi ꞌbu̱hmö núnu̱ ha yá ha̱i ya kaldeo, ne bi ma ba ꞌbu̱ har ha̱i Aran. Ne nu mi du ár dada, Jö ba tsi injawa habu̱ di ꞌbu̱hu̱pya, ka bi mꞌu̱kwa nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ha Jö himbi umba nꞌa xe̱ni ar ha̱i nda ꞌñenö már me̱ti. Bi ñöꞌtwabi mꞌe̱fa nda umbabinu̱ ne gatho yá ꞌbe̱to nda mꞌu̱i. Nunar ñhöꞌtinu̱ bi nsipabi núꞌmu̱ hinte mi ꞌñeta ar bötsi. ");
INSERT INTO otqNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ne Jö bi ꞌñembabinu̱: Nuya ri ꞌbe̱to ma da mꞌu̱ ha nꞌar ha̱i ngu ya nzo̱ho̱tho habu̱ hingya me̱ti. Ne ka ma da mꞌu̱hnu̱ ngu gohonthebe nje̱ye̱ di mꞌe̱go, ne xa ma da mfe̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ne bi ꞌñenö nꞌehe: Nuga ma ga koꞌspár mfe̱i nunar hnininu̱ habu̱ ma da mꞌe̱goꞌu̱. Ne mꞌe̱fa ma nda bo̱nu̱ nda ndöngagiwa. ");
INSERT INTO otqNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nepꞌu̱ Jö bi gohwi nꞌar nkohi ar Abra, bi xipabi gatho nuyá ꞌbe̱to nda thuꞌspa nꞌar nse̱gi ha yá ndoꞌyo. Jange nu mi mꞌu̱ ár tꞌu̱ ar Abra mar thuhu ar Isa, ár hñöto mpa bi hñuꞌspa ar nse̱gi xki gohwi Jö. Ne njapꞌu̱ bi ꞌyo̱tꞌwa ar Isa ár tꞌu̱, már thuhu ar Hakob. Ne bi japꞌu̱ꞌö nꞌehe, bi tutwa nor nse̱giꞌö nuꞌu̱ ꞌre̱tꞌamayoho yá tꞌu̱, go gehyu̱ ma palehu̱ habu̱ xta ehu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Mꞌe̱fa nuyá tꞌu̱yu̱ xa bi u̱tsa nꞌár jödö már thuhu ar Huse. Bi ma̱yu̱, har Huse bi tsꞌixa Ehipto. Ha Jö himbi hye̱se̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bi ma̱xa ha ya thogi bi thoꞌö. Ne bi umba nꞌar döta mfödi, ne bi hwëkwabi nda numañho ar faraon togo már ndö Ehipto. Ne nunu̱ bi ꞌñexa ngu ár ma̱xte xo̱ge har ha̱i Ehipto, ne nda supa ár ngu ar ndö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mꞌe̱fa xa bi nja nꞌar thuhu xo̱ge Ehipto ne Kanan, ne xa mi ñꞌu̱da yá mꞌu̱iꞌu̱. Numa palehu̱ hinte mi tini te nda ziꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nepꞌu̱ ar Hakob bi ꞌyo̱de mi ja ar tꞌe̱i núnu̱ Ehipto, jange bi me̱hna yá tꞌu̱, gehyu̱ ma dadahu̱, ka bi ndu̱pꞌu̱ ndi ma Ehipto. ");
INSERT INTO otqNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nepꞌu̱ ar ñoꞌgi mi maꞌu̱, ar Huse bi ñꞌudi togoꞌö, njapꞌu̱ bi böꞌu̱ már jödöꞌu̱. Ne bi bö ar faraon togo yá mëni ar Huse. ");
INSERT INTO otqNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mꞌe̱fa ar Huse bi me̱mpar nze̱ngwa ár dada nda e nda mꞌu̱hwi, nunu̱ ne gatho yá mëni, mi tsu̱ ngu hñunꞌa̱te ne ꞌre̱tꞌamaku̱tꞌa. ");
INSERT INTO otqNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Njanu̱ bi maꞌu̱ Ehipto. Ne ka ba tunu̱ ar Hakob ne yá tꞌu̱, nuꞌu̱ ma palehu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mꞌe̱fa mi duꞌu̱, ba nju̱kwa yá ndoꞌyonu̱, bi thöxa Sikem, ne ba tꞌa̱ hár ntꞌa̱gi ar Abra xki da̱mba yá tꞌu̱ ar Hamor. ");
INSERT INTO otqNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Núꞌmu̱ mi ꞌba̱pꞌu̱tho nda tho ngu ár ñhöꞌti Jö xki gohwi ar Abra, xa xki xönda nuyá ꞌbe̱to har ha̱i Ehipto. ");
INSERT INTO otqNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ne bi yu̱tꞌa manꞌar ndö himi pödi togo mar Huse. ");
INSERT INTO otqNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nunar ndöꞌö bi kadi ne bi ꞌyo̱tꞌwar tsꞌomꞌu̱i nuya ma palehu̱. Ne bi japabi nda gu̱ka nthi yá tsi bötsi mi le̱le̱tho nda duꞌu̱, ne hinge nda nxöndi. ");
INSERT INTO otqNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ha nuya paꞌu̱ bi mꞌu̱ ar Moise, ne xa bi numañho Jö. Bi tede yá dada ho̱nse̱ hñu nzönö ha yá nguꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nu mi tho nuꞌu̱ hñu nzönö, bi gu̱ka nthi nda duhmö. Geꞌmu̱ ár tꞌinxu ar faraon ba ju̱tsꞌi, ne bi tede ngu ár bötsiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jange ar Moise bi tꞌutwa gatho yá mfödi ya me Ehipto, ne mi pe̱ꞌsa ar tsꞌe̱di te nda mö ne te nda ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nu mi jwata yonꞌa̱te nje̱ye̱, bi zo̱pa ár mfeni nda ma nda kꞌöꞌsa yá ku, ya me Israel, ne nda nu tengu yá mꞌu̱iꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nu mi zo̱nga habu̱ mi ꞌbu̱ꞌu̱, bi hyanda nꞌar me Ehipto mi netꞌwa nꞌa yá kuꞌu̱. Bi ma ba ñöni, jange ar Moise bi hyo nöꞌö ar me Ehipto, ne njapꞌu̱ bi koꞌspa ár ñöni. ");
INSERT INTO otqNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nu ar Moise mi beni nda zo yá mfeni yá mi me Israelwi gehnu̱ xki me̱ñꞌö Jö nda ñöñꞌu̱, ha nuꞌu̱ himbi benga njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ne ár hyaxꞌöpꞌu̱ bi mengi bi thohnu̱ ar Moise manꞌagi, bi hyanda yoho ya me Israel mi ntuñꞌu̱. Bi ma nda hyekꞌu̱, ne bi ꞌñembabi: Nuꞌahu̱ gi nkuhu̱, yoꞌö gi ntuñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nuꞌmú̱ nöꞌö togo mi netꞌa ár ñꞌohu̱, bi umba nꞌar ntuki ar Moise, ne bi ꞌñembabi: Togo xi hñuxꞌage ngu ar tsꞌu̱tꞌwi wa ngu ar ndö, ne da tsa̱ gi hñögagihe nöꞌö te di pe̱he. ");
INSERT INTO otqNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wa gi ne gi hyogagi ngu ga hyo ar me Ehipto mande. ");
INSERT INTO otqNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nu mi ꞌyo̱ njapꞌu̱ ar Moise, bi ma ba ñꞌönga har ha̱i ár thuhu Madian. Ka ba ꞌbu̱hnu̱ ngu nꞌar nzo̱ho̱, ne ka ba tinu̱ yoho yá tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nu mi tho yonꞌa̱te nje̱ye̱, bi hyanda nꞌár e̱nxe̱ Jö bi ñꞌudi mi ꞌba̱ madeda nꞌar ꞌminza mi fagi, mi ꞌbu̱hnu̱ har otꞌatꞌo̱ho̱ ár thuhu Sinai. ");
INSERT INTO otqNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nu mi hyanda ar Moise, xa bi ꞌyo̱tho. Bi watꞌa har faspi nda hyanda te mar me̱ꞌö, bi ꞌyo̱xa ár mhö Jö, mi embabi: ");
INSERT INTO otqNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nuga dár Jö ri pale ar Abra, ar Isa, ne ar Hakob. Nuꞌmú̱ ar Moise xa bi ntsu mi nhwötꞌi, ne himi nemhö nda hyanda nöꞌö ar faspiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ha bi ꞌñemba ar tsi Hmu: Kꞌotꞌa ri thiza, ngetho nuwa habu̱ gi netsꞌi, nꞌar jöpa ha̱i xintꞌaxi. ");
INSERT INTO otqNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Xa majöni xta handa ya dumu̱i thohnu̱ Ehipto ma bötsi. Xta o̱xa yá tsꞌoni, ne xta e ga ñöni. Jange nupya ba e ga pe̱ñꞌa gi penga Ehipto. ");
INSERT INTO otqNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Nunar Moisenu̱ xki ntꞌu̱tsabi ár mfa̱tsꞌi ne xki tꞌembabi: Togo xi hñuxꞌage ngu ar tsꞌu̱tꞌwi wa ngu ar ndö, ne da tsa̱ gi hñögagihe nöꞌö te di pe̱he. Gehnu̱ togo bi ꞌñexa Jö ngu ar ndö, ne nda ma̱xa yá ku nda bo̱nga Ehipto, ngu xki me̱hna ár e̱nxe̱ nda mö, xki ñꞌudi har ꞌminza mi zo̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Gehnu̱ ar Moise ba tsinga gatho ya me Israel mi ꞌbu̱hnu̱ Ehipto. Ka ba o̱tnu̱ nze̱ye̱ ya döta ntꞌudi, ne har The̱nga Ñho̱nthe, ne núnu̱ ha ya otꞌatꞌo̱ho̱ habu̱ ba ꞌyoꞌu̱ yonꞌa̱te nje̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nöꞌö ar Moiseꞌö go bi xipa ma jöꞌihu̱ ya me Israel, ne bi ꞌñembabi: Jö ma tsi Hmuhu̱ ma da ꞌñexa nꞌaꞌahu̱ ngu ár mꞌe̱hniꞌö, njangu xi hñuxkagi nꞌehe. Ne ma gi ꞌyo̱thu̱ nöꞌö da xiꞌahu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Getnu̱ ar Moise mi ꞌyo har mhuntsꞌi ndu ma palehu̱ núꞌmu̱ mi ꞌyo ha ya otꞌatꞌo̱ho̱. Ne ka ba ꞌbu̱hwinu̱ ár e̱nxe̱ Jö mi ñöwi har tꞌo̱ho̱ Sinai. Ne bi hñönga ya mhö ungar te, ne bi thogagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ha nuꞌu̱ ndu ma palehu̱ himbi ne bi ꞌyo̱te, bi zantho, ne yá mfeni mi ꞌyoda Ehipto. ");
INSERT INTO otqNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nuꞌmú̱ bi ꞌñembabiꞌu̱ ar Aron: Di nehe gi hogagihe ꞌra ma tsitahe ga te̱ñhe. Ngetho nunar Moise ba ju̱gagihe Ehipto, hindi pöhe teme xi jaꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jange bi hyokꞌu̱ nꞌar boi bo̱jö, ne bi ꞌbo̱ꞌspabi yá mꞌo̱ñho̱. Ne xa bi njohyaꞌu̱ bi ndönga nöꞌö bi hyokase̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nuꞌmú̱ Jö bi ꞌwege, ne bi hye̱pꞌu̱ nda nsundaꞌu̱ ya tso̱, ar zönö, ne ar hyadi, ngu xi tꞌotꞌa ha yá tꞌofo yá mꞌe̱hni Jö, ha enö njawa: Me Israelhu̱, hamꞌu̱ ga ꞌrakagihu̱ nꞌar mꞌo̱ñho̱ núꞌmu̱ ga ꞌyohu̱ yonꞌa̱te nje̱ye̱ ha ya otꞌatꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hinga jahu̱pꞌu̱, ngetho nöꞌö ngi o̱thu̱ ngi muꞌsfu̱ ár ngu ar Molok, ne ngi ju̱thwu̱ ár tso̱ ri tsitahu̱ ar Renfán. Gehyu̱ ya tsita ga hyoju̱ ngi ndöñhu̱. Jange ma ga thokꞌahu̱ da tsꞌixꞌahu̱ injanu̱ har ha̱i Mbabilonia. ");
INSERT INTO otqNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Núnu̱ har otꞌatꞌo̱ho̱ habu̱ bi ꞌranga ndu ma palehu̱, ka xki thoknu̱ nꞌar ngudutu, habu̱ mi ndönga Jö. Nunar ngudutuꞌö xki thoki ngu xki utwa Jö, ne xki xipa ar Moise nda hyoki. ");
INSERT INTO otqNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mꞌe̱fa nunar ngudutuꞌö bi gohwi ndu ma palehu̱. Ne ba hö injawaꞌu̱ mi ñꞌowi ar Hosue, núꞌmu̱ bi hñömba yá ha̱i nuꞌu̱ himya me Israel. Jö go bi ꞌye̱ñꞌu̱ mi zo̱kwa ndu ma palehu̱. Geꞌmu̱ bi ndu̱ꞌu̱ bi nsundabiwa Jö. Mi japꞌu̱thoꞌu̱ nuya pa mi ꞌbu̱ ar Dabi. ");
INSERT INTO otqNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nunar ñꞌo̱ho̱nu̱ xa bi numañho Jö. Mi nemhö nda hyokwa nꞌar ngu habu̱ nda nsundabi nöꞌö ar Jö mi ndönga ndu ma palehu̱ ar Hakob. ");
INSERT INTO otqNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ha nꞌár tꞌu̱ꞌö hö, nöꞌö már thuhu Salomon, go bi hyokwa ár ngu Jö nöꞌö mi bemhö nda hyoka ár dada. ");
INSERT INTO otqNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mödi Jö bi ꞌbu̱ mañö mhetsꞌi, hingi ꞌbu̱ ha nꞌar ngu xi hyoka ár ꞌye̱ ar jöꞌi, ngu bi ꞌñenga ár mꞌe̱hni Jö, mi enö njawa: ");
INSERT INTO otqNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mhetsꞌi go ma thuxandö, har ximha̱i habu̱ di exa ma wa. Tema ngu da tsa̱ gi hyogagihu̱ ꞌmu̱, enga ar tsi Hmu. Wa habu̱ ga tsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hage hinxta hokaga gathoyu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Xa xi me ri ñöhu̱, hinti tuka ri mu̱ihu̱, ne gar me̱ꞌskuhu̱. Xa hingi ne gi ꞌyo̱thu̱ ár Hñö Jö, gi njanguthohu̱ ndu ma palehu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hangu yá mꞌe̱hni Jö himbi ꞌyo̱tꞌwa ar tsꞌomꞌu̱i ri palehu̱. Ne bi hyo nuꞌu̱ togo mi no̱mba ár ꞌñehe ar Hogañꞌo̱ho̱, gehnu̱ ga da̱hu̱ ne ga hyohu̱ nuya payu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nuꞌahu̱ ga hñöñhu̱hmö ar tꞌofo bi zokꞌahu̱ yá e̱nxe̱ Jö, ne hinga ꞌyo̱thu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nu mi ꞌyo̱ njapꞌu̱ nuya jöꞌi xa mi ntsinse̱ yá kwe̱, ne xa mi guxtꞌu̱ yá tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ha nunar ku Teba xa bi nzinga ár Hñö Jö, bi no̱ꞌsa mhetsꞌi, ne bi hyandwa ár nsunda Jö ne ar tsi Hmu Hesu mi huhnu̱ hár ñꞌe̱i Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ne bi ꞌñenö: —ꞌYo̱hu̱. Di handa mhetsꞌi xogi, ne di handa Nöꞌö Togo ba e bi Njöꞌi bi huhnu̱ hár ñꞌe̱i Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nuꞌmú̱, gatho nuꞌu̱ ya jöꞌi xa bi mafi ne bi gotꞌa yá gu, bi mfa̱tsꞌi bi gu̱ ar Teba. ");
INSERT INTO otqNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nepꞌu̱ bi nju̱ka har hnini bi nkꞌahni. Nuya jöꞌi bi mo̱ yá dutu hár wa nꞌar ñꞌo̱ho̱ mi bötsitho ár thuhu ar Saulo. ");
INSERT INTO otqNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ne núꞌmu̱ mi tho̱xa ya nkꞌahni ar Teba, mi matꞌa Jö, ne mi enö: —Ma tsi Hmu Hesu, ha ri ꞌye̱ di e̱ntꞌa ma hñö. ");
INSERT INTO otqNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bi nda̱ndihmö, ne bi ꞌñenga ntsꞌe̱di: —Ma tsi Hmuꞌi, yo ma gi hñöꞌspa majöni nunar tsꞌokinu̱. Ne ngu mi wadi bi mönga njapꞌu̱, bi hyoñꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nunar Saulo xki ꞌñetꞌatho ár xu̱tha núꞌmu̱ bi tho ar ku Teba. Nor paꞌö bi ndu̱i bi ntꞌu̱tsa ya ku núnu̱ Herusalen. Hagatho bi mfontꞌa nuya gamfi har ha̱i Nhudea ne Nsamaria. Ho̱nse̱ yá mpo̱te ar tsi Hmu himbi mfontꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ꞌRaya hogajöꞌi bi gu̱ꞌspa ár ndoꞌyo ar Teba bi ꞌya̱gi, ne xa bi zontꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ar Saulo xa mi e nꞌar mꞌu̱i ya gamfi, ꞌramanꞌar ngu mi ku̱tꞌi mi ju̱ka ya ñꞌo̱ho̱ ne ya ꞌbe̱hñö nda zixa nda gotꞌar fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ha nu maꞌra ya gamfi xki njui ne xki mfontꞌi, habu̱ gatho mi thogi, mi mönga ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ha nöꞌö már thuhu ar Lipe, bi ma har hnini Nsamaria, ma ba xipa ya jöꞌi togo ar tsi Hmu Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ne nuya jöꞌi nꞌatꞌwu̱ mi huxa ma su nöꞌö mi mönga ar Lipe, ne mi hantꞌu̱ nuꞌu̱ ya ntꞌudi mi o̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ngetho nze̱ye̱ ya jöꞌi nuꞌu̱ xki nthe̱xkwi ya tsꞌondöhi mi e̱mbabi, ha nuya tsꞌondöhi xa mi he̱xa ya mhafi nda bo̱ni. Ne nze̱ye̱ ya da̱thi xki nza yá ndoꞌyo, ne ya dowa mi thitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ne njapꞌu̱ xa mi pe̱ꞌsa nꞌar döta johya nuya mengu nor hniniꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ka mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Simu, mar ñꞌete har hniniꞌö. Xki hya̱tꞌa nze̱ye̱ ya me Nsamaria, ne xa mi o̱tꞌa ndöta. ");
INSERT INTO otqNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ne gatho ya mengunu̱, ya döta ne ya txꞌu̱lo, xa mi jamasu mi o̱xa nöꞌö te mi mönga nöꞌö ar ñꞌeteꞌö, ne mi eñꞌu̱: —Nunar ñꞌo̱ho̱nu̱ hömpa ár döta tsꞌe̱di Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gatho ya jöꞌi xa mi japamasu, ngetho ya mahamꞌu̱ xki hya̱tꞌu̱ mi uta ya ntꞌete. ");
INSERT INTO otqNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ha nu mi zo̱nga ar ku Lipe har hniniꞌö, bi mönga ar hoga mhö no̱mba ár tsꞌu̱tꞌwi Jö, ne ár thuhu ar tsi Hmu Hesukristo. Ne nze̱ye̱ ya ñꞌo̱ho̱ ne ya ꞌbe̱hñö mi ñꞌemu̱i ne mi nxixtheꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Gese̱ ar Simu bi jamfi ne bi nxixthe. Ne hyaxꞌmu̱ mi ñꞌowi ar Lipe, mi handa tengu ya döta ntꞌudi mi o̱tꞌe, ne xa mi ꞌyo̱tho. ");
INSERT INTO otqNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nu mi bö ya mpo̱te mi ꞌbu̱ Herusalen, nuya me Nsamaria xki hñömba ár mhö Jö nꞌehe, jange dama bi me̱hna ar Pedro ne ar Xuwa bi ma injanu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nu mi zo̱ñꞌu̱, bi ꞌya̱pa Jö nda hñöñꞌu̱ ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ngetho hinto xki mꞌe̱mpatho ár Hñö Jö, ho̱nse̱ xki nxixthe hár thuhu ar tsi Hmu Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jange ar Pedro ne ar Xuwa bi hñuꞌspa yá ꞌye̱ ya gamfi, ne bi hñömbabiꞌu̱ ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nu mi hyanda njapꞌu̱ ar Simu nöꞌö mar ñꞌetehmö, mi hömba ár Hñö Jö nuꞌu̱ togo mi hñuꞌspa yá ꞌye̱ ya mpo̱te, jange bi xipabi nda umba ar bojö, ");
INSERT INTO otqNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ne bi ꞌñembabi: —ꞌRaju̱ nꞌa tu̱i ar tsꞌe̱di gi höhu̱. Njapꞌu̱ to gatho ga huxa ma ꞌye̱ da hñömba ár Hñö Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nuꞌmú̱ ar Pedro bi döti ne bi ꞌñembabi: —Mꞌe̱hwi ri bojö. Yoꞌö xka beni da tsa̱ da tha̱nga ár tsꞌe̱di Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hingi pe̱ꞌsa ar se̱ki, ne hindi ꞌñepꞌaꞌi gi pe̱ nunar ꞌbe̱finu̱, ngetho Jö hingi numañho nöꞌö xka beni. ");
INSERT INTO otqNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Jange mahyoni gi ꞌyo̱tꞌwa ár ntso̱ꞌmi ri tsꞌoki xka beni, ne ꞌya̱pa Jö, xömhö da pumpꞌa nöꞌö ga tsa̱ ha ri mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngetho nuga di handi xa tso̱tꞌa ri mu̱i, ne xi gopꞌatho ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nuꞌmú̱ ar Simu bi dödi ne bi ꞌñenö: —ꞌYa̱pkagihu̱tsꞌu̱ Jö, hinda zu̱kagi nöꞌö xka möñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ne nuꞌu̱ ya mpo̱te bi da̱majöni togo ma tsi Hmuhu̱ Hesu, bi mömba ár mhö Jö. Mꞌe̱fa bi menga Herusalen, ne hagatho ya hnini Nsamaria mi thogi, mi mönga ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mꞌe̱fa nꞌár e̱nxe̱ Jö bi zo ar ku Lipe, ne bi ꞌñembabi: —Lipe, xta e ga pe̱ñꞌaꞌi gi ma makꞌangi, ju̱ ar ꞌñu kö Herusalen, di ma har hnini ár thuhu Gasa, thota ha ya otꞌatꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nuꞌmú̱ ar Lipe dama bi gu̱ ar ꞌñu bi ma. Ne núꞌmu̱ mi ꞌyo ar ꞌñu, bi nthe̱wi nꞌar ñꞌo̱ho̱ már me Etiopia, ár ma̱xte ar ndöꞌbe̱hñö ár thuhu Kandase mar ndönu̱ Etiopia. Nor ñꞌo̱ho̱ꞌö már me̱sbojö ar ndöꞌbe̱hñö, xki mengi ma ba ndönga núnu̱ Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mi huxa har tönza ndi menga ár ha̱i, ne mi ne ar tꞌofo xki ꞌyotꞌa ar mꞌe̱hni Isaia. ");
INSERT INTO otqNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nuꞌmú̱ ár Hñö Jö bi ꞌñemba ar Lipe: —Di ma ba tsu̱ nunar tönza xi manu̱, ne me̱wi. ");
INSERT INTO otqNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ar Lipe xa bi ntihi bi ma ba tsu̱ ar tönza. Ne bi ꞌyo̱xa nöꞌö ar ñꞌo̱ho̱ꞌö mi ne ár tꞌofo ar mꞌe̱hni Isaia, ne bi ꞌñembabi: —Hage gi pödi tema di bo̱nga nöꞌö gi nehe. ");
INSERT INTO otqNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ha nor ñꞌo̱ho̱ꞌö bi dödi ne bi ꞌñenö: —Hanja da za̱ ga pödi te di bo̱ni nuꞌmu̱ hinto da utkagi. Ne bi ꞌya̱pa ar Lipe nda bo̱tsꞌe ne nda hñuhwi. ");
INSERT INTO otqNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nöꞌö ar xe̱ni ár Tꞌofo Jö habu̱ mi nehe, enö njawa: Nöꞌö bi ñhetho ngu nꞌar tsi de̱ti tsꞌitsꞌi da tho. Ngu nꞌa tsi ndöni da ngone núꞌmu̱ da tꞌöxi, njapꞌu̱ himbi mafi. ");
INSERT INTO otqNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mi ñꞌenda ya jöꞌi, ne hinto bi ꞌyo̱tꞌwa ar tsꞌu̱tꞌwi. Ne nuyá mëni, hinto tsa̱ da metwabi, ngetho bi thökwa ár tewa har ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nepꞌu̱ nor me Etiopia bi ꞌñembabi ar Lipe: —Jakar möte gi xikagi togo no̱nga ár mꞌe̱hni Jö. Hage mi no̱nga ár mꞌu̱ise̱, wa mi no̱nga manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nuꞌmú̱ ar Lipe bi gu̱ nunár xe̱ni ar Tꞌofo mi ne ar me Etiopia, ne bi ndu̱i bi xipabi ar hoga mhö no̱nga ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Núꞌmu̱ mi ꞌyo ar ꞌñuꞌu̱, bi zo̱nga habu̱ mi jar dehe, ne bi ꞌñenga nöꞌö ar me Etiopia: —Jawa ar dehe. Hage hinda tsa̱ ga nxixthega ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ha nor Lipe bi ꞌñembabi: —Nuꞌmu̱ xa gi ñꞌemu̱i ne xi zo ri mu̱i, hö da tsa̱. Nor me Etiopia bi ꞌñenö: —Hö, di ñꞌemu̱i ar tsi Hmu Hesukristo gehnu̱ ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nunu̱ bi mö nda mꞌa̱ꞌma ar tönza, ne bi göi bi yu̱tꞌu̱ har dehe gatho yoho. Ne ar Lipe bi xixthe ar me Etiopia. ");
INSERT INTO otqNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ha nu mi bo̱xꞌu̱ har dehe, ar Lipe bi mꞌe̱tho, ngetho ár Hñö Jö bi zitsꞌi. Ne ar me Etiopia himbi mengi bi hyandi, ne xa bi njohyaꞌö bi gu̱ ar ꞌñu bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ha nunar Lipe bi zo̱nu̱ Asoto. Ha núꞌmu̱ mi thohnu̱, bi ndu̱i bi mönga ar hoga mhö ha ya hnini mi ja har ꞌñu ndi ma Nsesarea. ");
INSERT INTO otqNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ha nuya paꞌu̱ ar Saulo mi huꞌsa nda hyo gatho nuꞌu̱ mi ñꞌemu̱i ar tsi Hmu. Ne bi ma ba kꞌöꞌsa ar döngamöjö, ");
INSERT INTO otqNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma ba a̱pa ya he̱ꞌmi nda hñöꞌspa yá nijö ya xodyo núnu̱ Ndamasko. Njapꞌu̱ núꞌmu̱ nda dinga ꞌra nuꞌu̱ mi te̱mba ár ꞌñu ar tsi Hmu Hesu, ya ñꞌo̱ho̱ wa ya ꞌbe̱hñö, gatho nda tsi Herusalen, ne nda gotꞌa har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ha núꞌmu̱ mi ꞌyo ar ꞌñu, ꞌbu̱tho nda zo̱nga Ndamasko, nꞌa mbi hyexta nꞌar hyatsꞌi ndi ꞌñe mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Bi hwankꞌmu̱, ne bi ꞌyo̱ nꞌar mhö mi enö: —Saulo, Saulo, yoꞌö gi u̱tsagi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nuꞌmú̱ ar Saulo bi dödi ne bi ꞌñenö: —Ndada, togoꞌi. Nöꞌö bi dödi: —Nuga dar Hesu, togo gi u̱tsa. Go xka ntsꞌokse̱, ngu nꞌar boi pu̱nga ar maza. ");
INSERT INTO otqNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ne ar Saulo xa mi ntsu mi nhwötꞌi, ne bi ꞌñenö: —Ma tsi Hmuꞌi, teme gi ne ga pe̱pya. Nuꞌmú̱ ar tsi Hmu bi ꞌñembabi: —Nangi, di ma ba ku̱tꞌa har hnini, ka ma da nsiꞌanu̱ tema gi pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ne nuꞌu̱ ya ñꞌo̱ho̱ mi ñꞌowi ar Saulo, bi mꞌa̱ꞌu̱ himi pödi te nda beñꞌu̱, ngetho bi ꞌyo̱ꞌu̱ ar mhö nꞌehe, ha hinto bi hyandi togo mi ñö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nepꞌu̱ ar Saulo bi nangi bi mꞌa̱i, ne bi zo̱tyá da̱, mödi himbi za̱ te bi hyandi. Jange bi ngu̱hni bi tsꞌixa har hnini Ndamasko. ");
INSERT INTO otqNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ne ka ba ꞌbu̱hnu̱ hñupa himi handi. Ne nuya hñupayu̱ hinte bi zi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Núnu̱ Ndamasko ka mi ꞌbu̱hnu̱ nꞌar gamfi már thuhu ar Anania. Nunu̱ bi zo ar tsi Hmu ngu nꞌar tꞌi, ne bi ꞌñembabi: —Ha gi o̱de, Anania. Nöꞌö bi dötwabi: —Te gi jaki, tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ha nu ar tsi Hmu bi ꞌñembabi: —Nangi di ma har ꞌñu ár thuhu Njöntho, ne ba honga nꞌar ñꞌo̱ho̱ ár thuhu ar Saulo me Tarso, ꞌbu̱ hár ngu ar Huda. Nu xki tso̱nu̱ ma gi tini matꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nöꞌö xta utwabi ngu nꞌar tꞌi, ma da zo̱nga nꞌar ñꞌo̱ho̱ ár thuhu ar Anania, ne da hñuꞌspa yá ꞌye̱, njapꞌu̱ da mengi da hyandi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nu mi ꞌyo̱ njapꞌu̱ ar ku Anania, bi dödi ne bi ꞌñenö: —Ma tsi Hmuꞌi, nze̱ye̱ togo xi xikagi nunar ñꞌo̱ho̱nu̱ xa xi ꞌñe ar mꞌu̱i nuꞌu̱ te̱ñꞌaꞌi ꞌbu̱hnu̱ Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ha xi umba nse̱ki ya ndömöjö da e da gu̱ gatho nuꞌu̱ matꞌa ri thuhuwa nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nuꞌmú̱ ar tsi Hmu bi ꞌñemba ar Anania: —Di ma gi ꞌyo̱tꞌa nöꞌö di xiꞌaꞌi. Ngetho go ger ñꞌo̱ho̱nu̱ xta hwahni da me̱pkagi, ne da utka ma thuhu nuꞌu̱ ya me Israel, nuꞌu̱ hingya me Israel ne yá ndö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne go ma ga utka hangu ma da thogi ngetho da̱tka ma thuhu. ");
INSERT INTO otqNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nuꞌmú̱ ar Anania bi ma, ba ku̱tꞌa har ngu habu̱ mi ꞌbu̱ ar Saulo, bi hñuꞌspa yá ꞌye̱, ne bi ꞌñembabi: —Ku Saulo, ar tsi Hmu Hesu nöꞌö ga hyanda har ꞌñu ngi ꞌñekwa, gehnu̱ xpa pe̱nkagi ga husꞌa ma ꞌye̱ ne da mengi gi hyandi, ne gi nzinga ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nuꞌmú̱ bi hyo̱ ꞌra ngu yá koto ya hwö mi kotwa yá da̱ ar Saulo, ne dama bi mengi bi hyandi, ne bi mꞌa̱i bi ma ba nxixthe. ");
INSERT INTO otqNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nu mi ñuni bi menga ár tsꞌe̱di, ne bi mꞌu̱hwinu̱ ya ku Ndamasko ꞌra ya pa. ");
INSERT INTO otqNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nepꞌu̱ ngutꞌa bi ma ba da̱majöni ar tsi Hmu Hesukristo ha yá nijö ya xodyo, mi xipabiꞌu̱ ar Hesu gehnu̱ ár Tꞌu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ne gatho nuꞌu̱ togo mi o̱xa nöꞌö mi möñꞌö, xa mi ꞌyo̱tho ne mi eñꞌu̱: —Ha hinga gehnu̱ togo mi ju̱ mi netꞌa nuꞌu̱ togo mi matꞌwa ár thuhu ar Hesu núnu̱ Herusalen. Wa hinga gehnu̱ xki ꞌñehe nda xo̱tya gamfi, ne nda ziꞌspa ya ndömöjö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ha nunar ku Saulo hyaxꞌmu̱ mi huxa ár tsꞌe̱di nda xipa yá mixodyowi nunar Hesu gehnu̱ ar Kristo. Ne nuya xodyo mi ꞌbu̱hnu̱ Ndamasko himi pödi te nda beni. ");
INSERT INTO otqNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bi tho yapa, ne ya xodyo bi nko nda hyoꞌu̱ ar Saulo. ");
INSERT INTO otqNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bi nsipabi ar Saulo nöꞌö mi beñꞌu̱ nda ꞌyo̱tꞌe. Parxui mi supa gatho yá goxthi ar hnini, mi ne nda hyohmö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jange nuya ku bi ma̱xa ar Saulo nda bo̱nga har hnini, bi njöꞌmtho har jödo mi kotꞌa ar hnini, bi tꞌe̱ntꞌa ha nꞌar ꞌbo̱tsꞌe mi nxui. ");
INSERT INTO otqNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nu mi zo̱nu̱ Herusalen ar Saulo, mi nemhö nda ñꞌowi ya ku. Ha nuyu̱ xa mi ntsu, himi ñꞌemu̱iꞌu̱ xki gamfi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nunar ku Berhnabe bi zixa habu̱ mi ꞌbu̱ ya mpo̱te, ne bi metwabiꞌu̱ hanja xki hyanda ar tsi Hmu har ꞌñu, ne xki ñöwi, ne himbi ntsu bi da̱ta majöni ár thuhu ar tsi Hmu Hesu núnu̱ Ndamasko. ");
INSERT INTO otqNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ne njapꞌu̱ bi za̱ bi mpe̱hwi ya gamfinu̱ Herusalen habu̱ gatho mi ꞌyoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Himi ntsunu̱ nda mömba ár thuhu ar tsi Hmu, ne mi ntsa̱hñökiwi nuya xodyo mi ñö ar griego, jange nuyu̱ nꞌe, mi nehmö nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ha nu mi bö ya ku nöꞌö xki tꞌe̱kwabi, bi zixꞌu̱ Nsesarea, nepꞌu̱ bi me̱ñꞌu̱ nda ma Tarso. ");
INSERT INTO otqNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nuꞌmú̱ gatho ya gamfi mi pe̱ꞌsa nꞌar hogamꞌu̱inu̱ Nhudea, Ngalilea ne Nsamaria. Ne ndi hñuxa yá jamfi, ne mi ꞌyoꞌu̱ mi tsupa Jö, ne ár Hñö Jö mi fa̱xꞌu̱ nda xu ya gamfi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Har ku Pedro mi ꞌyo mi tso̱nga gatho ya gamfi, ne bi ma ba kꞌöꞌsa ya ku mi ꞌbu̱hnu̱ Lida. ");
INSERT INTO otqNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ne ka bi nthe̱winu̱ nꞌar ñꞌo̱ho̱ ár thuhu ar Enea, mi pe̱ꞌsa hñöto nje̱ye̱ mi ꞌbe̱ngar tꞌoxi, xki nza ár ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ne bi ꞌñemba ar Pedro: —Ha gi o̱de Enea, ar tsi Hmu Hesukristo xi o̱theꞌi. Nangi, ju̱xa ri fidi. Ne nöꞌö dama bi nangi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ne gatho ya mengunu̱ Lida ne ya me Saron, mi hyantꞌu̱, bi ñꞌemu̱i ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Núnu̱ har hnini Nhope mi ꞌbu̱hnu̱ nꞌar ꞌbe̱hñö mar gamfi, mar thuhu ar Tabita, har griego tꞌembabi Dorka. Nunu̱ himi tsa̱ya̱ mi o̱tꞌa ya ñho ne mi fa̱xa ya hyoya. ");
INSERT INTO otqNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ha nuya paꞌu̱ bi zu̱ nꞌar hñeni ne bi du. Nepꞌu̱ bi nsu̱kwa ár ndoꞌyo ngu yá ntꞌumbiꞌu̱, ne ba ꞌbe̱ ha nꞌar ngu mi to̱ mañö. ");
INSERT INTO otqNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Getꞌu̱ Nhope ꞌbu̱ ar hnini Lida. Ne nuya gamfi me Nhope xki ꞌyo̱de mi ꞌbu̱hnu̱ Nlida ar ku Pedro. Jange bi mꞌe̱hna yoho togo ma nda tsihi, ne nda ꞌñembabi: —Di a̱ꞌahe gi jar möte ga möhö ngutꞌa Nhope. ");
INSERT INTO otqNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Dama bi nanga ar Pedro bi me̱wi. Ne nu mi zo̱ni, bi tsꞌixa har ngu mi to̱ mañö, habu̱ xki mhuntsꞌa nze̱ye̱ ya ꞌranxu xa mi zontꞌa togo bi du. Ne ar Pedro bi gotꞌatho, ne bi tꞌutwabi nuya pahni ne maꞌra ya he xki hyoka ar Dorka núꞌmu̱ mi tetho. ");
INSERT INTO otqNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nuꞌmú̱ ar Pedro bi ꞌbe̱pa nda bo̱nga nthi gatho nuꞌu̱ mi ꞌbu̱hnu̱, ne bi nda̱ndihmö, bi ꞌya̱pa Jö. Nepꞌu̱ bi ñhanda habu̱ mi ꞌbe̱nga nöꞌö xki du, ne bi ꞌñembabi: —Tabita, nangi. Ne nöꞌö dama bi zo̱tꞌa yá da̱, ne nu mi hyanda ar Pedro, bi nangi bi hñudi. ");
INSERT INTO otqNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ne ar Pedro bi mipa ár ꞌye̱, ne bi ꞌba̱ꞌmi. Nepꞌu̱ bi zohna ya ꞌranxu ne nu maꞌra ya ku, ne bi utwabi xki mengi xki nte. ");
INSERT INTO otqNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ne xo̱ge har hnini Nhope bi nxanga nöꞌö teme xki thogi, ne nze̱ye̱ ya jöꞌi bi ñꞌemu̱i ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Har Pedro bi gohnu̱ Nhope nze̱ye̱ ya pa hár ngu nꞌar ku ár thuhu ar Simu, ar hokaximhni. ");
INSERT INTO otqNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mi ꞌbu̱hnu̱ Nsesarea nꞌar ñꞌo̱ho̱ már thuhu ar Kornelio. Nunu̱ mar döndogu har mhuntsꞌa ndogu mi tꞌembabi ya me Italia. ");
INSERT INTO otqNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nunu̱ xa mar hogajöꞌi, ne mi tsupa Jö, mahye̱giwi gatho nuꞌu̱ mi ꞌbu̱ hár ngu. Ne mi fa̱xa nuꞌu̱ ma ya hyoya, ne hyaxꞌmu̱ mi matꞌa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Zo̱ta nꞌar pa ngu nꞌar hñu nde, bi hyanda xiñho nꞌár e̱nxe̱ Jö ngu nꞌar tꞌi, bi watꞌa habu̱ mi ꞌbu̱ꞌö, ne bi ꞌñembabi: —Kornelio. ");
INSERT INTO otqNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nu mi hyandi xa bi kꞌötꞌi ne xa bi ntsu, bi ꞌñenö: —Tsi Hmu, te gi jaki. Ha nunar e̱nxe̱ bi ꞌñembabi: —Nuya ri ntꞌa̱pa Jö, ne nuya ri hoga ꞌbe̱fi xka ꞌyo̱tꞌe, xi hyantꞌa Jö ne hinxi pumhni. ");
INSERT INTO otqNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jange nupya pe̱hna ꞌra ya mꞌe̱hni har hnini Nhope, ma da tsi ar Simu nöꞌö xi thuꞌspabi ar Pedro. ");
INSERT INTO otqNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nöꞌö bi ꞌbu̱ hár ngu manꞌar Simu nöꞌö hoka ya ximhni, ꞌbu̱ har ñönthe. Nunar Pedronu̱ go ma da xiꞌaꞌi te di ꞌñepꞌaꞌi gi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ne nu mi ma nor e̱nxe̱ mi ñöwi ar Kornelio, nunu̱ bi zohna yoho yá ꞌbe̱go ne nꞌar ndogu xa mi honga Jö nꞌehe, gehnu̱ mi pe̱pabi xiñho. ");
INSERT INTO otqNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bi metwabi gatho nöꞌö te xki thogi, ne bi me̱hna har hnini Nhope. ");
INSERT INTO otqNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ha nu ár hyaxꞌö mi ꞌyo ar ꞌñuꞌu̱, ne txꞌu̱tho mi ꞌbe̱di nda zo̱nga har hnini Nhope, geꞌmu̱ ar Pedro bi bo̱xa mañö ár njoꞌmi ar ngu nda ꞌya̱pa Jö, ngu mi made mpa. ");
INSERT INTO otqNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ne xa mi tsu̱ nꞌar thuhu, xa mi nemhö nda ñuni. Ha núꞌmu̱ mi thokwabi te nda zi, bi hyanda nꞌar ntꞌudi ngu nꞌar tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bi hyandi bi xo mhetsꞌi, ne ba jöꞌma har ha̱i ngu nꞌar döta dutu mi thuꞌsa gatho goho yá ñöni. ");
INSERT INTO otqNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ne har dutuꞌö, mi ku̱xa gatho ya zuꞌwe tu goho yá wa, nuꞌu̱ nju̱tꞌa har ha̱i, ne nuꞌu̱ nsa̱nga har ndöhi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ne bi ꞌyo̱ nꞌar mhö mi enö: —Pedro, nangi, hyo ya zuꞌwe gi tsa. ");
INSERT INTO otqNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ha nunar Pedro bi dödi ne bi ꞌñenö: —Hinda nejö, tsi Hmu, ngetho hiñhamꞌu̱ xta tsi nöꞌö hindi ꞌñepki ga tsi ne hingi tꞌaxi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Bi mengi bi nheki nuna ar mhö manꞌagi: —Yo gi xipa hindi ꞌñepꞌaꞌi gi tsi nöꞌö xi xu̱ka Jö ne xi tꞌaxki. ");
INSERT INTO otqNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hñuꞌgi bi ntꞌo̱de, ne bi nju̱xa mhetsꞌi manꞌagi nöꞌö ar dutuꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nunar Pedro mi ꞌbu̱hnu̱ xa mi ꞌyonga ár mfeni, mi ne nda bödi te ndi bo̱nga nöꞌö ngu ar tꞌi xki hyandi. Ja bi zo̱ ꞌmu̱ har goxthi yá mꞌe̱hni ar Kornelio, mi ñꞌa̱ni habu̱ mi ꞌbu̱ ár ngu ar Simu mi hoka ya ximhni. ");
INSERT INTO otqNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ne bi ñꞌa̱ñꞌu̱ ntsꞌe̱di, ha mi ꞌbu̱hnu̱ ar Simu nöꞌö xki thuꞌspabi ar Pedro nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ar Pedro mi benda nöꞌö ngu ar tꞌi xki hyandi, geꞌmu̱ bi ꞌñembabi ár Hñö Jö: —Bi zo̱ hñu ya ñꞌo̱ho̱ hoñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ꞌBa̱i, ne köi gi me̱wi. Yo gi yomi, ngetho go xta pe̱nkayu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nuꞌmú̱ ar Pedro bi göi bi ma habu̱ mi ꞌba̱ nuꞌu̱ yá mꞌe̱hni ar Kornelio, ne bi ꞌñembabiꞌu̱: —Go geke togo gi hoñhu̱. Tema xka ꞌñehu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nuyu̱ bi dödi ne bi ꞌñenö: —Xpa pe̱nje ma döndoguhe ar Kornelio, nꞌar hoga ñꞌo̱ho̱ tsupa Jö, ne gatho ya xodyo ñömañhobi. Ha nꞌár e̱nxe̱ Jö bi xipabi nda me̱hna togo nda e nda zixꞌa ár nguꞌö, da ꞌyo̱xa nöꞌö gi xipabi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ar Pedro bi thoki bi umba nse̱ki bi ñꞌoxꞌu̱ nöꞌö ar nxuiꞌö habu̱ mi ꞌbu̱ꞌö. Ne ár hyaxꞌö ar Pedro bi nangi bi me̱wiꞌu̱, ne bi de̱nga maꞌra ya ku ma ya mengunu̱ Nhope. ");
INSERT INTO otqNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ár yopa bi zo̱ñꞌu̱ Nsesarea habu̱ mi ꞌbu̱ ar Kornelio mi to̱ꞌmi. Ne xki zohna gatho yá mëni, ne nuꞌu̱ yá ñꞌowi mi ntsixkwi xiñho. ");
INSERT INTO otqNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nu mi zo̱nga ar Pedro hár ngu ar Kornelio, nunu̱ bi bo̱ni bi dödi, ne bi nda̱ndihmö ha yá wa mi ne nda ndöni. ");
INSERT INTO otqNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ha nunar Pedro bi ꞌba̱ꞌmi, ne bi ꞌñembabi: —Nangi, ngetho nuga dar ñꞌo̱ho̱ ngu nu maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Núꞌmu̱ mi ñöwi, bi yu̱tꞌu̱ mbor ngu. Ka mi ꞌbu̱hnu̱ nze̱ye̱ ya jöꞌi xki mhuntsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ne ar Pedro bi ꞌñembabiꞌu̱: —Nuꞌahu̱ gi pöhu̱ dar xodyohe, ne ha ma ntꞌumbihe högagihe ga nthöskwihe nuꞌahu̱ hingar xodyohu̱, ne hingi tsa̱ ga ku̱the ha ri nguhu̱. Mödi njapꞌu̱, Jö xi utkagi hinto ga embabi hindi ꞌñepi ga ñöꞌbe, ne hinga xipi hingi tꞌaxi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jange mi xikagi ri mꞌe̱hni nga ekwa, hinda o̱tꞌa ma ꞌñöngi, ngutꞌa da ehe. Xikagihu̱ te gi jaju̱. ");
INSERT INTO otqNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nuꞌmú̱ ar Kornelio bi döti ne bi ꞌñembabi: —Pe̱ꞌsa goho mpa ngu ar xe̱nimpanu̱, ndi ꞌbu̱kwa ha ma ngu, ndi bëhë ne ndi matꞌa Jö ngu di nzöi di o̱tꞌe. Ngur hñu nde, nꞌa nda handatho nꞌar ñꞌo̱ho̱ mi he nꞌar dutu xa mi hwe̱xki, mi ꞌba̱hnu̱ ndi ñhantꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ne bi ꞌñengagi: Kornelio, Jö xi ꞌyo̱xa nöꞌö xka ꞌya̱pabi, ne xi hyanda nöꞌö ar ñho xka ꞌyo̱tꞌwa ya hyoya. ");
INSERT INTO otqNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pe̱hna togo da ma har hnini Nhope, ma da tsiñꞌa ar Simu, nöꞌö tꞌembabi ar Pedro nꞌehe. ꞌBu̱ hár ngu manꞌa ar Simu ar hokaximhni, ꞌbu̱ har ñönthe. Ne nu xta zo̱ꞌö, ma da xiꞌa te gi pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jange ngutꞌa da pe̱mpꞌu̱ togo ba hoñꞌaꞌi, ne xka ꞌyo̱tꞌa xiñho xka ekwa. Ngu gi nu, gatho di ꞌbu̱hewa hár nthandi Jö, ne di ne ga o̱he nöꞌö xi ꞌraꞌi gi xije. ");
INSERT INTO otqNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nuꞌmú̱ ar Pedro bi du̱ꞌmi bi ñö, ne bi ꞌñenö: —Nupya hö, xta pödi majöni Jö handa mahye̱tho gatho ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Numañhoꞌö gatho nuꞌu̱ togo ꞌyo hár nsuꞌö ne o̱tꞌa nöꞌö xiñho, mödi habu̱ gatho ya menguꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Jö ba pe̱mpa ár mhö ya me Israel, ar hoga mhö no̱nga ar hogamꞌu̱i unga ar Hesukristo, gehnu̱ ár Hmu gatho ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ngu xka ꞌyo̱se̱hu̱ gatho nöꞌö xi tho ha ma ha̱ihe nuje dar xodyohe, bi ndu̱ Ngalilea núꞌmu̱ ar Xuwa xki wadi mi no̱nga ar xixthe, ne bi nu̱nga gatho har ha̱i Nhudea. ");
INSERT INTO otqNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gi pöhu̱ nꞌe, Jö bi umba ár Hñö ar Hesu me Nasare. Bi me̱ꞌsa ar tsꞌe̱di bi ñꞌo bi ꞌyo̱tꞌa ya ñho, ne bi o̱thebi yá hñeni gatho nuꞌu̱ togo xki dëntꞌa ar tsꞌondöhi. Bi tsa̱ bi ꞌyo̱tꞌa njapꞌu̱, ngetho mi ꞌbu̱hwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ne nuje di da̱he majöni gatho nöꞌö bi ꞌyo̱tꞌa ar Hesu har hnini Herusalen ne xo̱ge har ha̱i Nhudea. Mꞌe̱fa nunu̱ bi tsꞌu̱ta ha nꞌar za bi tho. ");
INSERT INTO otqNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gehnu̱tho togo Jö bi japi bi nte manꞌagi ár hñupa, ne bi ñꞌudi da hanthe. ");
INSERT INTO otqNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Himbi ñꞌudi bi hyanda gatho ya jöꞌi. Ho̱nse̱gihe da hanthe, ngetho hár ndu̱itho, Jö xki hwankagihe nga da̱thwe majöni. Nuje da ñumꞌehe ne da tsithehe mahye̱gi núꞌmu̱ mi mengi bi nte. ");
INSERT INTO otqNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ne bi me̱nkagihe ga xife ya jöꞌi, ne ga da̱he majöni gehnu̱ xi hñuxa Jö ngu ar tsꞌu̱tꞌwi, ne da hñöꞌspa majöni nuꞌu̱ tetho ne nuꞌu̱ xi du. ");
INSERT INTO otqNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ne gatho yá mꞌe̱hni Jö mi ꞌbu̱ mamꞌe̱tꞌo, bi da̱majöni bi ꞌñeñꞌu̱, gatho nuꞌu̱ da ñꞌemu̱ibi ár thuhu, da mpumbabi yá tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ar Pedro himi jwatho nda mönga nuya mhöyu̱, ba kö ár Hñö Jö, ne bi zu̱ gatho nuꞌu̱ mi o̱xa nöꞌö mi mönga ar Pedro. ");
INSERT INTO otqNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ha nuya xodyo ma ya gamfi ba ñꞌowi ar Pedro, xa mi ꞌyo̱tho, ngetho xki hñömba ár Hñö Jö nꞌehe nuꞌu̱ himya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bi ꞌyo̱de mi ñö maꞌra ya mhö nuꞌu̱ himi pöꞌu̱, ne mi umba njamödi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nuꞌmú̱ ar Pedro bi ꞌñenö: —Togo da za̱ da hñökwabi da nxixtheyu̱. Nuyu̱ xi hñömba ár Hñö Jö mahye̱gi ngu xta höñhu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ne bi ꞌbe̱pabiꞌu̱ nda nxixthe hár thuhu ar tsi Hmu Hesukristo. Ha nuyu̱ bi ꞌya̱pa ar Pedro nda gohwinu̱ maꞌra ya pa. ");
INSERT INTO otqNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bi ꞌyo̱ ya mpo̱te ne maꞌra ya gamfi mi ꞌbu̱ Nhudea, nuya himya xodyo xki hñömba ár mhö Jö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ne mi menga ar ku Pedro Herusalen, ka ba tsu̱hnu̱ nuyá mixodyowi ma ya gamfi ne mi te̱nda yá ntꞌumbiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ne bi ꞌñembabi: —Hanja xka ku̱tꞌa ha yá ngu ya ñꞌo̱ho̱ hingya xodyo, ne xka ñungwi. ");
INSERT INTO otqNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nuꞌmú̱ ar Pedro bi mu̱di bi ꞌyotꞌwa ar ꞌñu gatho nöꞌö xki thogi, ne bi ꞌñembabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nuga ndi ꞌbu̱hnu̱ ndi a̱pa Jö har hnini Nhope, ne da handa nꞌar ntꞌudi ngu ar tꞌi. Ba jöꞌma mhetsꞌi nꞌar döta dutu mi thuꞌsa gatho goho yá ñöni, ne bi jöꞌma habu̱ ndi ꞌbu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ne nu nda kꞌötꞌi, da handi mi ku̱ gatho ya zuꞌwe tu goho yá wa, ya zate, ya zuꞌwe nju̱tꞌa har ha̱i, ne nuꞌu̱ nsa̱nga har ndöhi. ");
INSERT INTO otqNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nꞌa nda o̱ta nꞌar mhö bi ꞌñengagi: Pedro, nangi gi hyo gi tsa. ");
INSERT INTO otqNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ne da embabi: Hinda nejö, tsi Hmu, ngetho hiñhamꞌu̱ xta tsiga nöꞌö hindi ꞌñepki ga tsi hingi tꞌaxi. ");
INSERT INTO otqNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nuꞌmú̱, nöꞌö ar mhö mi e mhetsꞌi bi mengi bi zokagi, ne bi ꞌñengagi: Yo gi xipabi hindi ꞌñepꞌaꞌi gi tsi nöꞌö xi xu̱ka Jö, ne xi tꞌaxki. ");
INSERT INTO otqNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bi nheki ar hñuꞌgi, ne bi nju̱xa mhetsꞌi nöꞌö ar dutuꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nꞌa mbi zo̱nda hñu ya ñꞌo̱ho̱ har ngu habu̱ ndi ꞌbu̱ka, xki ꞌñe Nsesarea xki ꞌbe̱hni nda zixkagi. ");
INSERT INTO otqNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ne ár Hñö Jö bi xikagi hinge nga yomi nga me̱ꞌbeꞌu̱. Ne da me̱ꞌbe nuyu̱ ma ꞌrato ya kuyu̱. Nda tso̱ñhe da ku̱the hár ngu nöꞌö togo xki me̱hna yá mꞌe̱hni nda zixkagi. ");
INSERT INTO otqNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ha nor ñꞌo̱ho̱ꞌö bi xije hanja xki hyandnu̱ hár ngu nꞌár e̱nxe̱ Jö mi ꞌba̱hnu̱, ne bi ꞌñembabi ꞌnö: Pe̱hna ꞌra ya mꞌe̱hni har hnini Nhope, ma da tsi ar Simu nöꞌö xi thuꞌspabi ar Pedro. ");
INSERT INTO otqNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nunu̱ ma da xiꞌaꞌi ya mhö da ma̱xꞌaꞌi gi mpo̱ho̱, ne gatho ya mengu ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ha nu nda du̱ꞌmi da ñö, bi hñöñꞌu̱ ár Hñö Jö ngu da höñhu̱ ar ndu̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Da bemꞌu̱ nöꞌö xki mönga ma tsi Hmuhu̱ núꞌmu̱ bi ꞌñenö: Ar Xuwa mi xixthe har dehe, ha nuꞌahu̱ ma gi nxixthehu̱ gi nziñhu̱ ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nuꞌmu̱ Jö bi ne bi hwëkwabi ár Hñö mahye̱gi nguju̱ di ñꞌemu̱ihu̱ ma tsi Hmuhu̱ Hesukristo, ter mꞌe̱kagiga ga hökwa ár ꞌbe̱fi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nu mi ꞌyo̱ njapꞌu̱ nuya ku mi ꞌbu̱hnu̱ Herusalen, bi ñhetho, ne bi nsunda Jö, bi ꞌñeñꞌu̱: —Njapꞌu̱tho xi hwëkwa Jö nuꞌu̱ hingya xodyo da ꞌyo̱tꞌwár ntso̱ꞌmi, ne da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi nguju̱. ");
INSERT INTO otqNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nuꞌu̱ ya ku xki ntꞌu̱tsa xki mfontꞌi nuꞌu̱ ya pa mi tho ar ku Teba, ꞌra ba tso̱nga har ha̱i Fenisia, maꞌra Txipre, ha maꞌra Antiokia. Ne habu̱ gatho mi thoꞌu̱, hinto maꞌra mi xipa ár mhö Jö, ho̱nse̱ yá mixodyowi. ");
INSERT INTO otqNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ha mi ñꞌowi ꞌra ya ku ma ya me Txipre, ne maꞌra ya me Sirene. Nu mi zo̱ñꞌu̱ har hnini Antiokia, bi metwabiꞌu̱ ár hoga mhö ar tsi Hmu Hesu nuꞌu̱ ya jöꞌi himya xodyo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jö bi umba ar tsꞌe̱diꞌu̱, ne nze̱ye̱ ya jöꞌi bi ñꞌemu̱i, ne bi de̱mba ár ꞌñu ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nu mi bö ya ku mi ꞌbu̱hnu̱ Herusalen nöꞌö mi thohnu̱ Antiokia, bi me̱ñꞌu̱ injanu̱ ar ku Berhnabe. ");
INSERT INTO otqNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ne mi zo̱ñꞌö, bi hyandi teme xki hwëkwabi Jöꞌu̱, ne xa bi njohya. Ne bi xipa gatho nuꞌu̱ xki ñꞌemu̱inu̱, hinge nda hye̱pꞌu̱ nunar jamfinu̱, ne nda umba yá mu̱i nda hyonga Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ar Berhnabe xa mar hoga ku, ne xki nzinga ár Hñö Jö, xa mi tse̱ ár jamfi. Njapꞌu̱ nze̱ye̱ ya jöꞌi bi ñꞌemu̱i ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nepꞌu̱ ar Berhnabe bi ma Tarso, ba honga ar Saulo, ne mba tini bi zixa Antiokia. ");
INSERT INTO otqNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ne ka bi mꞌu̱hnu̱ nꞌa nje̱ye̱ nuya yohoyu̱, mi mhunskwi ya gamfi, ne mi utwa ár mhö Jö nze̱ye̱ ya jöꞌi. Ka gehnu̱ Antiokia habu̱ bi ndu̱i bi nsipabi ya gamfi ma ya me̱pa Kristo. ");
INSERT INTO otqNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nuya paꞌu̱ ba po̱nga Herusalen ꞌra yá mꞌe̱hni Jö, bi ma Antiokia. ");
INSERT INTO otqNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nꞌaꞌu̱ már thuhu ar Agabo, bi mꞌa̱ madeda habu̱ xki mhuntsꞌa ya ku. Ne bi nzinga ár Hñö Jö, bi ꞌñenö ma nda nja nꞌar döta thuhu xo̱ge ár nxidi ar ximha̱i. Ne hö, bi tho ngu xki möñꞌö nuya pa mar dönga ndö Nroma ar Klaudio. ");
INSERT INTO otqNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nepꞌu̱ nuya gamfi me Antiokia bi beñꞌu̱ nda me̱mpa nꞌar mfa̱tsꞌi nuꞌu̱ maꞌra ya gamfi mi ꞌbu̱hnu̱ Nhudea. Nꞌa ngu nꞌa bi unga nöꞌö mi tsu̱pa yá tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ne nunar mfa̱tsꞌi bi uñꞌu̱, bi me̱mpa nuyá ndö ar nijö Nhudea, ne go bi hñöxa ar Berhnabe, bi me̱wi ar Saulo. ");
INSERT INTO otqNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nuya paꞌu̱ ar ndö Erode bi ndu̱i bi u̱tsa ya gamfi, mi honi hanja nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ne ndo̱jwaitho bi tho ar Hakobo ár jödö ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ha nu mi bödi mi numañho ya xodyo, bi me̱hna nda nju̱ ar Pedro nꞌehe. Bi nju̱ ha nꞌár ngo ya xodyo núꞌmu̱ mi tsꞌi ar thuhme himi jotsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ha nu mi nju̱ꞌö, bi jotꞌa har fa̱di. Ne bi tꞌe̱ntꞌwa ha yá ꞌye̱ ꞌre̱tꞌamaꞌrato ya ndogu, xki ñhege goho nꞌa ngu nꞌa nda suꞌö. Ngetho ar Erode mi beni ngu nda wata ár ngo ar baxjwa, nda nju̱ka har fa̱di nda mꞌa̱ꞌma ntsꞌu̱tꞌwi madeda ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nuꞌmú̱ ar Pedro, xa mi nsu xiñho har fa̱di. Ha nuya ku himi tsa̱ya̱ mi matꞌwa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nꞌapatho mi ꞌbe̱di nda gu̱ka har fa̱di ar Erode, nor nxuiꞌö ar Pedro mi öhö madeda yoho ya ndogu, mi thötꞌa ya nthöhibo̱jö, ne nu maꞌra ya ndogu mi ꞌba̱ hár goxthi ar fa̱di mi su. ");
INSERT INTO otqNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mi da̱ni bi mꞌa̱hnu̱ nꞌár e̱nxe̱ Jö, ne xa bi yotꞌa mbo har fa̱di. Nunar e̱nxe̱ bi da̱mbár ꞌbo̱tsꞌe ar Pedro ne bi ꞌya̱, ne bi ꞌñembabi: —Nxo̱ni nangi. Nuꞌmú̱, dama bi hyo̱ta ya bo̱jö ha yá ꞌye̱ ar Pedro. ");
INSERT INTO otqNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nepꞌu̱ bi ꞌñemba ar e̱nxe̱: —Du̱tꞌa ri ngu̱tꞌi ne thötꞌa ri thiza. Ne nöꞌö dama bi ꞌyo̱tꞌa ngu xki mꞌe̱pabi. Bi ꞌñemba ar e̱nxe̱ nꞌehe: —Pa̱tꞌa ri pa̱tꞌi, ne te̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nuꞌmú̱ ar Pedro bi bo̱ni mi te̱nga ar e̱nxe̱, mödi himi ñꞌemu̱i mi majöni nöꞌö mi thogi, ngetho mi beñꞌö mi ꞌwiꞌthö. ");
INSERT INTO otqNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bi tho habu̱ mi ꞌba̱ ar ꞌbe̱tꞌo nsute. Nepꞌu̱ bi tho habu̱ mi ꞌba̱ manꞌa, ne bi zo̱nga har döta goxthibo̱jö mi tso̱nga nthi. Nunar goxthinu̱ bi xose̱. Ne bi bo̱ñꞌu̱ bi ꞌrañꞌu̱ nꞌar ꞌñu. Ne nꞌa mbi ꞌweta ar e̱nxe̱. ");
INSERT INTO otqNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nuꞌmú̱ ar Pedro bi nja ár mfeni, ne bi ꞌñense̱: —Nupya hö, di pödi xpa pe̱hna ár e̱nxe̱ Jö, bi ñöngagi da kꞌontꞌa hár ꞌye̱ ar Erode, ne gatho nöꞌö mi ne nda jaka ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mi wadi bi zo ár mfeni njapꞌu̱, bi már ngu ar Maria ár nönö ar Xuwa, nöꞌö xki thuꞌspabi ar Mörko nꞌehe. Ne ka mi ꞌbu̱hnu̱ nze̱ye̱ ya ku mi a̱pa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mi zo̱ni bi ma har goxthi, ne nꞌar nxutsi már thuhu ar Rode, bi ma ba nu togo mi ꞌba̱ har goxthi. ");
INSERT INTO otqNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nöꞌö ar nxutsi bi bötwatho ár mhö ar Pedro. Xa bi njohyaꞌö, jange himbi beni bi xokwa ar goxthi. Bi nixtꞌi bi ma ba xipa nuꞌu̱ maꞌra ya ku mi ꞌba̱ ar Pedro nthi. ");
INSERT INTO otqNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nuꞌu̱ bi ꞌñembabi: —Xka ꞌbe̱ ri mfeni. Ha nöꞌö xa mi huꞌmba yá mu̱i go mi geꞌö ar Pedro. Jange nuya ku bi ꞌñeñꞌu̱: —Hingo geꞌö, zage ár e̱nxe̱ xpa ehe. ");
INSERT INTO otqNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ha nunar Pedro himi tsa̱ya̱ mi mafi. Ne nu mi soka ar goxthi, ka bi hyantꞌu̱ mi geꞌö, ne himi pödi te nda beñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ar Pedro bi ja ár ꞌye̱ bi xipabi nda ñheꞌu̱, ne bi metwabi hanja xki gu̱ka Jö har fa̱di. Ne bi ꞌñembabiꞌu̱: —Xifu̱ ar ku Hakobo ne gatho nu maꞌra ya ku teme xi thogi. Ne bi bo̱ni bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ár hyaxꞌö nuya ndogu xa mi nxintꞌi, himi pödi te xki ja ar Pedro. ");
INSERT INTO otqNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nuꞌmú̱ ar ndö Erode bi me̱hna nda mengi nda thoni, ne hinto bi dini. Jange bi zohna ya sufa̱di bi hñöꞌspa majöni, ne bi mö nda tho. Ne bi bo̱nga núnu̱ Nhudea, bi ma ba ꞌbu̱ har hnini Nsesarea. ");
INSERT INTO otqNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ar ndö Erode xki po̱mpa ár kwe̱ ya me Tiro ne Sido. Nuyu̱ xki nkohi ma nda kꞌöꞌsa ar Erode. Ha mꞌe̱tꞌo bi umbar bojö ar Blasto nöꞌö mi supa ár ngu, mi ne nda ma̱tsꞌi nda ñöwi, ne nda ꞌya̱par hogamꞌu̱i. Ngetho gatho nöꞌö te mi tsiꞌu̱, mi hö habu̱ mar ndö ar Erode. ");
INSERT INTO otqNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nu mi zo̱ ar pa xki zohna ya me Tiro ne ya me Sido, ar Erode bi hye yá he ngu ar ndö, bi hñuxa har nthutsꞌi habu̱ mi o̱tꞌa ar tsꞌu̱tꞌwi, ne bi ndu̱i bi zoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nuꞌmú̱ nuya jöꞌi xa mi he̱xa ya mhafi mi eñꞌu̱: —Nöꞌö togo xta o̱xu̱ xi ñö, hingar jöꞌi, gehnu̱ nꞌar jö. ");
INSERT INTO otqNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nꞌár e̱nxe̱ Jö dama bi umba ar mfe̱i ar Erode, ngetho himbi ꞌñeꞌspa ár nsu Jö. Jange bi du xki deta ya zuꞌwe. ");
INSERT INTO otqNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ha nuya paꞌu̱ xa bi ñꞌo bi nxangár mhö Jö hagatho ya hnini. ");
INSERT INTO otqNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nu mi wa ar ꞌbe̱fi ar Berhnabe ne ar Saulo núnu̱ Herusalen, bi bo̱ni bi menga Antiokia. Ne bi zixꞌu̱ ar ku Xuwa nöꞌö mi tꞌembabi ar Mörko nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mi ꞌbu̱hnu̱ har nijö Antiokia ꞌra yá mꞌe̱hni Jö ne ꞌra ya utate: Ar Berhnabe, ar Simu nöꞌö mi tꞌembabi ar ꞌBojöꞌi, ar Lusio nöꞌö mar me Sirene, ar Saulo, ne ar Manaen nöꞌö bi tewi mahye̱gi ar ndö Erode. ");
INSERT INTO otqNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nꞌar pa xki mhuntsꞌi mi ndönga Jö, ne xki bëꞌu̱. Ár Hñö Jö bi ꞌñembabiꞌu̱: —ꞌWegagihu̱ ar Berhnabe ne ar Saulo da ꞌyo̱tꞌa ar ꞌbe̱fi xta huꞌspabi nda me̱hyu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jange mi wadi bi bëꞌu̱ ne bi ꞌya̱pa Jö, bi hñuꞌspa yá ꞌye̱ꞌu̱, ne bi ñꞌehwi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nuꞌmú̱ ár Hñö Jö bi me̱hna ar Berhnabe ne ar Saulo har hnini Seleusia. Ne mi zo̱nu̱ bi yu̱tꞌa ha nꞌar motsa, ne bi maꞌu̱ ha nꞌar ha̱i oda madeda ar dehe, ár thuhu ar Txipre. ");
INSERT INTO otqNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ne nu mi zo̱ñꞌu̱ har hnini Salamina, bi du̱ꞌmi bi mömba ár mhö Jö mbo ha yá nijö yá mixodyowi. Mi ñꞌowiꞌu̱ ar Xuwa mi fa̱xte nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bi thoꞌu̱ xo̱ge ar ha̱i Txipre, ne bi zo̱nga ha nꞌar hnini már thuhu Pafos. Ka bi nthe̱winu̱ nꞌar xodyo már thuhu Barhesus, mar ñꞌete ne mi ha̱tya jöꞌi, mi embabi már mꞌe̱hnihmö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hyaxꞌmu̱ mi ñꞌowi ar ndö Sergio Paulo togo xaka mbödi te da me̱fi. Nunar ndönu̱ bi zohna ar Berhnabe ne ar Saulo, ngetho mi ne nda ꞌyo̱twa ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nunar ñꞌetenu̱ mi tꞌembabi ar Elima (di bo̱ni da ꞌñenö ꞌñete), mi ne nda hñökwahmö ar ndö hinge nda ñꞌemu̱ibi ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nuꞌmú̱ ar Saulo nöꞌö már thuhu ar Pablo nꞌehe, xki nzimba ár Hñö Jö, xa bi kꞌötꞌa nöꞌö ar ñꞌete. ");
INSERT INTO otqNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ne bi ꞌñembabi: —Nuꞌge xa gar nemhñö ne gar ꞌyo̱tꞌatsꞌoki, ár bötsiꞌi ar tsꞌondöhi, gi u̱tsa gatho nöꞌö xiñho. Hamꞌu̱ gi hye̱pꞌu̱ gi tsꞌokwa yá mfeni ya jöꞌi hinda hyomba ár ꞌñu ar tsi Hmu mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ha gi o̱de, ma gi tsa̱pa ár ꞌye̱ Jö. Nupya ma gi ngoda̱ ne hinda tsa̱ gi hyanda ar hyadi ꞌra ya pa. Dama bi zoxa nꞌar ꞌbe̱xui ár da̱. Himi tsa̱ nda hyandi, ne mi honga togo nda gu̱hni nda ñꞌo. ");
INSERT INTO otqNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ar ndö mi hyanda nöꞌö xki thogi, bi ñꞌemu̱ibi ár mhö Jö, ngetho xa bi ꞌyo̱da nöꞌö xki ꞌyo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ar Pablo ne nuꞌu̱ maꞌra yá ñꞌohu̱, bi gu̱nu̱ Pafos nꞌar motsa, bi maꞌu̱ har hnini Perge har ha̱i Panfilia. Ha nunar Xuwa bi ꞌwege bi menga Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nu mi zo̱ñꞌu̱ Perge, bi gu̱ ar ꞌñu bi thoꞌu̱ har hnini Antiokia har ha̱i Pisidia. Ne nꞌar pa ntsa̱ya̱ bi yu̱tꞌu̱ ha yá nijö yá mixodyowi, ne bi thogi bi hñuhnu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nu mi wadi bi nhehe ár tꞌofo Jö bi ꞌyotꞌa ar Moise ne nu maꞌra yá mꞌe̱hni Jö, nuꞌmú̱ nuyá ndö ar nijö bi zohna ar Pablo ne ar Berhnabe, ne bi ꞌñembabi: —Tsi kuhu̱, nuꞌmu̱ gi pe̱ꞌsu̱ teme gi möñhu̱ gi hñuꞌmfu̱ yá mu̱i ya jöꞌi, möñhu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nuꞌmú̱ ar Pablo bi mꞌa̱i, ne bi jár ꞌye̱ bi xipabi nda ñhe gatho, ne bi ꞌñembabiꞌu̱: —Nuꞌahu̱ ma ñꞌowihu̱ gar me Israelhu̱, ne gathoꞌihu̱ gi tsufu̱ Jö, ꞌyo̱hu̱ nöꞌö ma ga xiꞌahu̱: ");
INSERT INTO otqNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Jö togo ndönga ya me Israel bi hwahna ma palehu̱, ne bi japi bi xu núꞌmu̱ ma ya nzo̱ho̱tho har ha̱i Ehipto, ne bi ñꞌu ár döta tsꞌe̱di mi gu̱knu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne bi me̱ꞌspa ar tsꞌe̱ti yonꞌa̱te nje̱ye̱ mi ꞌyo ha ya otꞌatꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nepꞌu̱ Jö bi hwata yoto ya hnini har ha̱i Kanan, ne bi hemba ma palehu̱ nuya ha̱iyu̱, ne ja bi mꞌu̱hnu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mꞌe̱fa Jö bi hñuxa ya nza̱ya̱ nda ñöni. Bi mꞌu̱ njapꞌu̱ ngu gohonthebe ne ngu̱dmi nje̱ye̱, ne ka bi mꞌu̱ ár mꞌe̱hni Jö ár thuhu ar Samuel. ");
INSERT INTO otqNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nepꞌu̱ ma palehu̱ bi ꞌya̱ꞌu̱ nꞌar ndö nda ꞌyo̱tꞌwa ar tsꞌu̱tꞌwi. Jö bi umba ar Saul már tꞌu̱ ar Sis, nꞌa yá ma̱ngaꞌbe̱to ar Benjamin, bi ndö yonꞌa̱te nje̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mꞌe̱fa bi thöka ar Saul ngu ar ndö, ne bi thuxa ar Dabi. Ne Jö bi ꞌñenö mi no̱ñꞌö: Nunar Dabinu̱ ár tꞌu̱ ar Isai, pe̱ꞌsa nꞌar hogamꞌu̱i jakagi ga njohya, ne nunu̱ da ꞌyo̱tkagi gatho nöꞌö di nega. ");
INSERT INTO otqNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ha nꞌár ma̱ngaꞌbe̱to ar Dabi, ka ba ehnu̱ ar Hesu, ba e bi po̱ ya me Israel ngu xki ñötꞌwabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Himi du̱ꞌmda ár ꞌbe̱fi ar Hesu núꞌmu̱ ar Xuwa mi xipa gatho ya me Israel nda ꞌyo̱tꞌwa yá ntso̱ꞌmi, ne nda nxixtheꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ne núꞌmu̱ ma nda wa ár ꞌbe̱fi ar Xuwa, bi ꞌñenö: Togo gi beñhu̱ go geke. Nuga hingo geke togo gi to̱ꞌmhu̱. Ja togo ꞌbe̱fa, hindi ꞌñepkagi ga xotꞌwatsꞌu̱ ár thiza hár waꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ꞌYo̱hu̱ ma mixodyowihu̱, yá ma̱ngaꞌbe̱togihu̱ ar Abra, ne nuꞌahu̱ gi tsufu̱ Jö, go xpa ꞌbe̱nkagihu̱ nunar mhönu̱ no̱nga ar mpo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nuya me Herusalen ne yá ndö, himi pödi togoꞌö ar Hesu. Hinxki zo yá mfeni teme ndi bo̱nga nöꞌö xki ꞌyotꞌa mahamꞌu̱ yá mꞌe̱hni Jö, mödi mi neꞌu̱ gatho ya pa ntsa̱ya̱. Ne núꞌmu̱ mi ꞌye̱ntꞌu̱ bi tho, bi thogi ngu xki tꞌotꞌa mahamꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Himbi thimba nꞌar tsꞌoki xki ꞌyo̱tꞌö ndi ꞌñepi nda thomhö. Mödi bi böꞌu̱ njapꞌu̱, bi ꞌya̱pa ar Pilato nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ne nu mi wadi bi ꞌyo̱tꞌwabiꞌu̱ gatho ngu xki tꞌotꞌwabi, bi gömꞌu̱ har pontꞌi ma ba a̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ha Jö bi koꞌspa ár te. ");
INSERT INTO otqNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nuꞌu̱ togo xki ñꞌowi núꞌmu̱ ba po̱nga har ha̱i Ngalilea ba e Herusalen, go gehyu̱ togo bi hyanda nze̱ye̱ ya pa núꞌmu̱ xki wadi xki mengi xki nte. Ne nupya gehyu̱ togo da̱twa majöni ya jöꞌi ha ma hninihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nuje nꞌehe di xiꞌahe ar hoga mhö, bi tho ngu xki ñhötꞌwabi ma palehu̱ mahamꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ne nupya Jö xi ꞌyo̱tkagihu̱ ngu xki mö, yá ꞌbe̱togihu̱ nuꞌu̱ togo xki ñhötwabi. Bi njapꞌu̱ núꞌmu̱ mi koꞌspa ár te ar tsi Hmu Hesu, ngu xi tꞌotꞌa hár ñoho ar Dönga Nsa̱di, habu̱ enö njawa: Go ma tꞌu̱ꞌi, ne nupya di ñꞌudi go ri Dadagi. ");
INSERT INTO otqNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jö bi koꞌspa ár te, hiñhamꞌu̱ nda tsꞌonga ár ndoꞌyo har ha̱i. Gehnu̱ xki mö bi ꞌñenö: Ga ꞌraꞌahu̱ gatho ya ñhöꞌti da ñötꞌa ar Dabi nga umbabi. ");
INSERT INTO otqNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ha manꞌar Dönga Nsa̱di bi ꞌñenga ar Dabi nꞌehe: Hinge ma gi hye̱ ri hoga ꞌbe̱gogi da tsꞌonga ár ndoꞌyo har ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Xa majöni ar Dabi bi me̱mpa yá mijöꞌiwi mi ꞌbu̱ nuya paꞌu̱ ngu mi ne Jö. Nepꞌu̱ bi du ne bi tꞌa̱gi, ha ár ndoꞌyo bi tsꞌonga har ha̱i, ngu gatho nu maꞌra ndu ma palehu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ha nöꞌö togo bi koꞌspa ár te Jö, nöꞌö himbi tsꞌonga ár ndoꞌyo har ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ndadahu̱, dá zo ri mfenihu̱ nöꞌö di xiꞌahu̱: Nuna bi ꞌyo̱tꞌa ar tsi Hmu, gehnu̱ bi pumgagihu̱ gatho ma tsꞌokihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Gatho nöꞌö himbi tsa̱ da o̱thu̱ ndi te̱ñhu̱ yá ꞌbe̱pate ar Moise, ne njapꞌu̱ nda nhugagihu̱ hinte ma tsꞌoki ndi tuhu̱, nupya hö da tsa̱, nuꞌmu̱ ga ñꞌemu̱ibihu̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Jange jamasuhu̱ hinda zu̱ꞌahu̱ nöꞌö xi mönga yá mꞌe̱hni Jö núꞌmu̱ bi ꞌñenö njawa: ");
INSERT INTO otqNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ꞌYo̱hu̱, nuꞌahu̱ gi tsañhu̱ nöꞌö majöni, xa ma gi ꞌyo̱hu̱ ne ma gi nhwathu̱. Ngetho nuya pa gi ꞌbu̱hu̱, xa ma ga o̱tꞌa ya döta ntꞌudi. Nu xta nsiꞌahu̱ nuya ntꞌudiyu̱, hingi ma gi ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ar Pablo ne yá ñꞌohu̱, núꞌmu̱ mi po̱nga ha yá nijö ya xodyo, bi tꞌa̱pa ar möte nda mengi nda xipabiꞌu̱ nor mhöꞌö ár hñöto manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ne mi wadi bi bo̱ñꞌu̱, nze̱ye̱ ya xodyo ne maꞌra ya jöꞌi xki de̱mba yá ntꞌumbi ya xodyo ne mi ndönga Jö, bi de̱nga ar Pablo ne ar Berhnabe. Ne nuyu̱ mi ñöwi ne mi huꞌmba yá mu̱i nda tsunga nöꞌö xki hwëkwa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ar hñötopꞌu̱ har pa ntsa̱ya̱, txꞌu̱tho mi ꞌbe̱di nda mhunsa xo̱ge ar hnini nda ꞌyo̱ꞌspa ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ha nuya xodyo mi hyanda ra nze̱ye̱ ya jöꞌi, xa bi zo̱tꞌa yá mu̱i ne mi kꞌaꞌspa nöꞌö mi mönga ar Pablo, ne xa mi ñömañꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nuꞌmú̱ ar Pablo ne ar Berhnabe himbi ntsu bi ꞌñeñꞌu̱: —Da du̱ꞌmhe da xiꞌahe ár mhö Jö, nuꞌahu̱ gar xodyohu̱, ngetho mi mahyoni nga jahepꞌu̱. Ha hinga ne ga hñöñhu̱, ne njapꞌu̱ gi ñꞌuhu̱ hindi ꞌñepꞌahu̱ ar te hiñhamꞌu̱ da götsꞌi. Jange nupya ma ga zohe nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ngetho njawa xi ꞌbe̱mkagihe ar tsi Dada: Xta huxꞌahu̱ ngu nꞌar ñotꞌi gi yotꞌwahu̱ gatho nuꞌu̱ hingya xodyo, ne gi xipabihu̱ ar mhö no̱nga ar mpo̱ho̱ xo̱ge ár nxidi ar ximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nu mi ꞌyo̱ njapꞌu̱ nuꞌu̱ himya xodyo, xa bi njohya, ne xa mi ñömañhobi ár mhö Jö. Ne bi jamfi gatho nuꞌu̱ xki thahni nda me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ne ár mhö ar tsi Hmu bi mhömba xo̱ge nor ha̱iꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nuꞌmú̱ nuya xodyo bi u̱tya hoga ꞌbe̱hñö mi nhumañho, ne ya ñꞌo̱ho̱ mi pe̱ꞌsa yá nsu har hnini, ne bi ntꞌu̱tsa ar Pablo ne ar Berhnabe, ne bi tꞌe̱nga ha yá hniniꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nuꞌmú̱ ar Pablo ne ar Berhnabe bi hwöka ar ha̱i mi tu ha yá wa, ne bi gu̱ yá ꞌñuꞌu̱ bi ma har hnini Ikonio. ");
INSERT INTO otqNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ha nuꞌu̱ xki ñꞌemu̱i ba kohnu̱, xa mi johyaꞌu̱, ne xa xki nziñꞌu̱ ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ar Pablo ne ar Berhnabe, mi zo̱nga har hnini Ikonio, bi yu̱tꞌa ha yá nijö yá mixodyowi, mi xipa ya jöꞌi ár mhö Jö. Ne mi hyanda hanja mi ñöꞌu̱, bi ñꞌemu̱i nze̱ye̱ ya xodyo ne nuꞌu̱ himya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ha nuya xodyo himbi ne bi jamfi, bi u̱tꞌa nuꞌu̱ himya xodyo ne bi tsꞌokwa yá mfeni nda u̱tsa ya ku. ");
INSERT INTO otqNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jange ar Pablo ne ar Berhnabe bi gohnu̱ nze̱ye̱ ya pa. Ne himi ntsuꞌu̱ nda mömba ár mhö Jö, ngetho mi pöꞌu̱ mi fa̱xa Jö, ne mi umbar tsꞌe̱di nda ꞌyo̱tꞌa ya dötꞌa ntꞌudi. Njapꞌu̱ bi ñꞌudi gehnu̱ ar mhö no̱nga ar nhwëki nöꞌö mi möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nuya mengunu̱ xki ñhege. ꞌRa mi te̱nga ya xodyo, ha maꞌra mi te̱mba yá mpo̱te ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ha ꞌra ya xodyo ne ꞌra nuꞌu̱ himya xodyo, bi mfa̱xkwi yá ndöꞌu̱ nda me̱i, mi ne nda gu̱ nkꞌahni ya mpo̱te. ");
INSERT INTO otqNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ha nunar Pablo ne ar Berhnabe mi bödi nöꞌö mi ne nda njapabiꞌu̱, bi bo̱ni bi maꞌu̱ har hnini Listra ne har hnini Derbe, yá hnini ar ha̱i Likaonia, ne bi ñꞌoꞌu̱ gatho ár nthetꞌi nöꞌö ar ha̱iꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ne ka ba möñꞌu̱nu̱ ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Har hnini Listra mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ himi tsa̱ nda ñꞌo, ngetho xki mꞌu̱i njapꞌu̱, ne hiñhamꞌu̱ xki ñꞌo, hyaxꞌmu̱ mi huhnu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nor ñꞌo̱ho̱ꞌö mi o̱xa nöꞌö mi mönga ar Pablo, ha nunar ku bi kꞌötꞌi, ne bi hyandi mi pe̱ꞌsa ar ñꞌemu̱i nda ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jange bi ꞌñenga ra ntsꞌe̱di: —Nangi gi ꞌba̱i njöntho. Nor ñꞌo̱ho̱ꞌö nꞌa nsa̱githo bi nangi bi ñꞌo. ");
INSERT INTO otqNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nuꞌmú̱ nuya jöꞌiꞌu̱ mi hyanda nöꞌö xki ꞌyo̱tꞌa ar Pablo, bi ꞌñenga ntsꞌe̱di ha yá hñöse̱ꞌu̱: —Ya jö xi ñhe̱hwi ya jöꞌi, xpa kökwa xi kꞌöskagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jange ar Berhnabe bi tꞌembabi mar jö Hupiter, ha nu ar Pablo ar jö Merkurio, ngetho go mi höxa ar mhö, ngu yá ꞌbe̱fi yá jöꞌu̱ ya me Likaonia. ");
INSERT INTO otqNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nuꞌmú̱ ár möjö ar Hupiter, mi pe̱ꞌsa ár nijö hár ñu̱tꞌi ar hnini, ba tsi ya boi ne ba hö ya do̱ni, nda zo har goxthi. Ne gatho ya jöꞌi mi ne nda ungwi mahye̱gi ar mꞌo̱ñho̱ nda ndömba ya ku. ");
INSERT INTO otqNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nu mi hyanda njapꞌu̱ ar Berhnabe ne ar Pablo, bi xika yá dutu, ne bi nixtꞌi bi yu̱tꞌa har mhuntsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Mi enö njawa: —Ñꞌo̱ho̱hu̱, yoꞌö gi pe̱hu̱ njanu̱. Nuje dar jöꞌihe nguꞌahu̱ nꞌehe. Xta ehe ga xiꞌahe gi hye̱hu̱ ya njötꞌi gi ndöñhu̱ hinter me̱ꞌu̱. Ne pe̱fu̱ Jö togo te, ne xi hyoka mhetsꞌi, ar ximha̱i, ar ñho̱nthe, ne gatho nuꞌu̱ te janu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Maꞌra ya mꞌu̱i mahamꞌu̱ Jö xi hye̱ ya jöꞌi xi ꞌyo̱tꞌa gatho nöꞌö xi beñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ha hinxi hye̱gi nꞌagitho. Hyaxꞌmu̱ xi ñꞌudi núꞌmu̱ ꞌraju̱ ar ꞌye bi e mhetsꞌi. ꞌRaju̱ ya hoga sofo, ꞌraju̱ te ga tsihu̱, ne ꞌraju̱ ar johya ha ma mu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mödi ar Pablo ne ar Berhnabe mi xipa njapꞌu̱, ne hinge nda hyompa ya me̱ti mꞌo̱ñho̱, xa mar ñhei nda hñökwabiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bi zo̱ ꞌmu̱ ꞌra ya xodyo xki ꞌñeꞌu̱ har hnini Antiokia ne Ikonio. Mi zo̱hyu̱ bi u̱tya jöꞌi bi kꞌahna ar Pablo, ne bi gu̱ka hár ñöni ar hnini ba e̱i, mi hu yá mu̱i xki du. ");
INSERT INTO otqNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ha núꞌmu̱ xki mhuntsꞌa ya gamfi har nthetꞌi habu̱ mi ꞌbe̱ñꞌö, bi mꞌa̱i ne bi mengi bi yu̱tꞌa har hnini. Ne ár hyaxꞌö bi me̱wi ar Berhnabe, bi maꞌu̱ manꞌar hnini ár thuhu Derbe. ");
INSERT INTO otqNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bi möñꞌu̱nu̱ ar hoga mhö, bi uta ya mengunu̱, ne bi gu̱xa nze̱ye̱ ya gamfi. Ne mi waꞌu̱, bi menkꞌu̱ har hnini Listra, ne bi tho Ikonio, nepꞌu̱ bi maꞌu̱ Antiokia. ");
INSERT INTO otqNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ha ya hniniyu̱ mi fa̱xa ya ku nda ze̱ta yá ñꞌemu̱i, ne mi huꞌmba yá mu̱i hinge nda hye̱pꞌu̱ ar ꞌñu. Njanu̱ mi embabiꞌu̱: —Mahyoni ga thohu̱ nze̱ye̱ ya thogi, ne njapꞌu̱ ga ku̱thu̱ hár tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ne bi tꞌexa ꞌra ya ku, mi tꞌe̱ntꞌwa ha yá ꞌye̱ꞌu̱ ar nijö mi ꞌbu̱ ha ya hnini mi thoꞌu̱. Nepꞌu̱ bi bëꞌu̱ ne bi tꞌe̱ntꞌwa ha yá ꞌye̱ Jö togo xki gamfiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bi thotꞌu̱ har ha̱i Pisidia, bi zo̱ñꞌu̱ har ha̱i Panfilia. ");
INSERT INTO otqNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ne mi wadi bi mömba ár mhö Jö har hnini Perge, bi thogi imanu̱ har hnini Atalia. ");
INSERT INTO otqNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mi zo̱nu̱ꞌu̱, bi gu̱ ar motsa bi ꞌraxa ar ñho̱nthe, bi menga Antiokia habu̱ xki tꞌe̱ntꞌwa ár ꞌye̱ Jö, nda hwëkwa ár mfa̱tsꞌi har ꞌbe̱fi xki wadi xki me̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nu mi zo̱ñꞌu̱, bi muntsꞌa gatho ya ku, ne bi metwabiꞌu̱ ya döta ntꞌudi xki ꞌyo̱tꞌa Jö ha yá ꞌbe̱fiꞌu̱, ne hanja Jö xki xoka ar goxthi nda ñꞌemu̱i nuꞌu̱ himya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ar Pablo ne ar Berhnabe ka bi gohwinu̱ ya gamfi nze̱ye̱ ya pa. ");
INSERT INTO otqNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nuya paꞌu̱ ꞌra ya ku xki ꞌñe har ha̱i Nhudea, bi du̱ꞌmi bi uta ya ku, nuꞌmu̱ hinge nda thuꞌspa ar nse̱gi ha yá ndoꞌyo, ngu ar ntꞌumbi bi unga ar Moise, hinge nda mpo̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jange ar Pablo ne ar Berhnabe xa bi ntsa̱hñökiwiꞌu̱. Bi nkoꞌu̱ nda ꞌbe̱hna ar Pablo ne ar Berhnabe ne maꞌra ya ku, ma nda kꞌönga ya mpo̱te ne yá ndö ar nijö Herusalen, ne nda mhuntsꞌi nda no̱nga nöꞌö mi thohnu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nuya gamfi bi ñꞌehwi ne bi ꞌñetꞌar ꞌñu ya ku xki mꞌe̱hni. Ha nuyu̱ bi thotꞌu̱ har ha̱i Fenisia ne Nsamaria, mi petwa ya ku habu̱ mi thoꞌu̱, nuyu̱ himya xodyo mi ñꞌemu̱i ár mhö Jö nꞌehe. Njapꞌu̱ nuya ku xa mi johya mi o̱xa nöꞌö mi nsipabi. ");
INSERT INTO otqNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nu mi zo̱ñꞌu̱ Herusalen, bi döta ya mpo̱te, yá ndö ar nijö, ne maꞌra ya ku mi ꞌbu̱hnu̱. Ha nu ar Pablo ne nuꞌu̱ mi ñꞌowi, bi metwabiꞌu̱ gatho nöꞌö xki ꞌyo̱tꞌa Jö ha yá ꞌye̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ꞌRa ya de̱ngaꞌbe̱pate xki jamfi mi ꞌbu̱hnu̱ nꞌehe, bi mꞌa̱i ne bi ꞌñenö: —Mahyoni da thuꞌspa ar nse̱gi hár ndoꞌyo ya gamfi nuꞌu̱ hingya xodyo, ne da ꞌbe̱pabi da ꞌyo̱tꞌa gatho ngu bi tꞌotꞌa hár tꞌofo ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nepꞌu̱ nuya mpo̱te ne yá ndö ar nijö bi mhuntsꞌi nda ñöꞌu̱ hanja nda japꞌu̱ nöꞌö mi thohnu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Núꞌmu̱ ya xa xki ñöꞌu̱, ar Pedro bi mꞌa̱i ne bi ꞌñembabiꞌu̱: —Ma tsi kuhu̱, ngu gi pöse̱hu̱, ya mahamꞌu̱ Jö bi hwankagi ga xipabi nuꞌu̱ hingya xodyo ar hoga mhö ne nda ñꞌemu̱iꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ha Jö togo pötwa yá mfeni ya jöꞌi, bi da̱majöni xki ñꞌemu̱iꞌu̱ mi umba ár Hñö Jö, jangu xi ꞌrakagihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ne bi nu mahye̱gigihu̱, ngetho mi ñꞌemu̱iꞌu̱, gese̱ Jö bi xu̱kwabi yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nuꞌmú̱, yoꞌö gi ne gi tso̱thwu̱ ár mu̱i Jö. Yoꞌö gi jafu̱ ya ku da ꞌyo̱tꞌa nöꞌö hinxi tsa̱ dá o̱thu̱, ne himbi tsa̱ bi ꞌyo̱tꞌa ma palehu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nuju̱ di ñꞌemu̱ihu̱ ar tsi Hmu Hesukristo bi hwëgathohu̱ ar mpo̱ho̱, ne njapꞌu̱ gatho nuꞌu̱ maꞌra nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nuꞌmú̱ gatho nuꞌu̱ mi ꞌbu̱hnu̱, bi ñheꞌu̱ bi ꞌyo̱xa nöꞌö mi mönga ar Berhnabe ne ar Pablo. Bi metwabiꞌu̱ hanja mi hömpa ár tsꞌe̱di Jö mi o̱tꞌa ya döta ntꞌudi ha yá nthandi nuꞌu̱ himya xodyo ");
INSERT INTO otqNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nu mi wadi bi ñöꞌu̱, ar Hakobo bi ꞌñenö: —Tsi kuhu̱, ꞌyo̱hu̱ nöꞌö ma ga xiꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ar Simu Pedro xi metkagihu̱ hanja Jö bi ndu̱i bi jöpa nuꞌu̱ hingya xodyo, ne bi hwahna ꞌraꞌu̱ da ꞌyo̱tꞌa ár hniniꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Njangu bi mönga yá mꞌe̱hni Jö habu̱ bi ꞌyotꞌa njanu̱: ");
INSERT INTO otqNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mꞌe̱fa ma ga pengi, ga koꞌspabi ár tsꞌu̱tꞌwi ar Dabi, ga ju̱xa ngu nꞌar ngu xki nhwati. Ga pengi ga hoka manꞌagi ngu ar ndu̱i, ga ju̱xa habu̱ xi yo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ne njapꞌu̱ gatho nuꞌu̱ maꞌra ya jöꞌi da hyongagi dar Hmu, da njapꞌu̱ gatho nuꞌu̱ hingya xodyo matka ma thuhu. ");
INSERT INTO otqNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mönga njapꞌu̱ ar tsi Hmu nöꞌö togo mahamꞌu̱ mi ñꞌudi nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jange di enga, hinga kꞌasfu̱ nuꞌu̱ hingya xodyo da e da ñꞌemu̱i Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ho̱nse̱ ma ga pe̱mfu̱ nꞌar he̱ꞌmi, ga xifu̱ hinda zipa yá ñhuni ya tsita empꞌö, hinda mꞌe̱ngwi nöꞌö hingo ár nthöti, hinda za nꞌar me̱ti hinxi mpo̱mba ár ji, hinda zi ar ji. ");
INSERT INTO otqNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ngetho mahamꞌu̱ hagatho ya hnini, ja togo mömba ár tꞌofo ar Moise nöꞌö nhehe tatꞌa pa ntsa̱ya̱ ha yá nijö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nuꞌmú̱ nuya mpo̱te, yá ndö ar nijö ne gatho ya gamfi, bi numañho. Jange ma nda nhwahna ꞌraꞌu̱ nda ꞌbe̱hna Antiokia, da me̱wi ar Pablo ne ar Berhnabe. Bi thahna yoho, nꞌa már thuhu ar Huda nöꞌö mi tꞌembabi ar Barsaba, ne ar Sila. Nuyu̱ mi pe̱ꞌsa yá nsu har nijö mi ꞌbu̱hnu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ne bi ꞌyotꞌa nꞌar he̱ꞌmi bi hñöꞌspa ya ku, mi enga njawa: Nuje dar mpo̱tehe, dar ndöhe har nijö, ne gatho ya ku di ꞌbu̱hewa, dí pe̱ñꞌahe nuna he̱ꞌminu̱, tsi kuhu̱ hingya xodyohu̱, gi ꞌbu̱hu̱ Antiokia har ha̱i Nsiria ne Nsilisia. Gathoꞌihu̱ di ze̱ngwaꞌihe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Xta pöhe ꞌra ya ku xi bo̱ngwa hinxta pe̱ñhe. Xi mapꞌu̱, ma xpa tupꞌa ri mu̱ihu̱, ne xi xiꞌahu̱ ꞌra ya mhö xi tsꞌompꞌa ri mfenihu̱. Xi ꞌbe̱pꞌahu̱ gi tuthu̱ ar nse̱gi ha ri ndoꞌyohu̱, ne gi ꞌyo̱thu̱ gatho nöꞌö bi mönga ar Moise har tꞌofo. ");
INSERT INTO otqNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jange gathogihe xta beñhe xiñho ga hwañhe ꞌra ya ñꞌo̱ho̱ di ꞌbu̱hewa, ga pe̱ñhe da kꞌösꞌahu̱, ne da mengwi ma tsi kuhu̱ Berhnabe ne ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nuya mꞌe̱hniyu̱ xi ꞌye̱ntꞌa yá te da mömba ár thuhu ma tsi Hmuhu̱ Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Di pe̱ñꞌahe ar ku Huda ne ar ku Sila, go ma da zoꞌase̱ꞌihu̱ nuna xta ñöhe nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ár Hñö Jö ne nuje xta beñhe xiñho hinga ꞌbe̱pꞌahe gi ꞌyo̱thu̱ nze̱ye̱ ya ꞌbe̱pate. Ho̱nse̱ ga ꞌbe̱pꞌahe gi ꞌyo̱thu̱ nuyu̱ mahyoni: ");
INSERT INTO otqNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nuꞌmú̱, yo ma gi tsifu̱ yá ñhuni ya tsita empꞌö, hingi ma gi tsihu̱ ya ji, yo ma gi tsahu̱ nꞌar me̱ti hinxi mpo̱mba ár ji, hingi ꞌbe̱ngwi nöꞌö hinga ri nthötihu̱. Nuꞌmu̱ gi ꞌyo̱thu̱yu̱, gi pe̱hu̱ xiñho. Jö da ma̱xꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jange nuꞌu̱ xki mꞌe̱hni, bi ma Antiokia. Bi mhuntsꞌa gatho ya gamfi ne bi umba ar he̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nu mi wadi bi neꞌu̱, xa bi njohyaꞌu̱ ngetho xa mi huꞌmbabi yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ar Huda ne ar Sila ma yá mꞌe̱hni Jö nꞌehe, jange xa mi pe̱sꞌu̱ te nda möñꞌu̱, mi zo ya ku, ne mi huꞌmba yá mu̱i nda hñuxa yá ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ka bi gohwinu̱ ya ku nze̱ye̱ ya pa. Mꞌe̱fa bi tꞌumba nꞌar hoga ntꞌedi nda menga Herusalen habu̱ xki mꞌe̱hni. ");
INSERT INTO otqNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ha nunar Sila bi beni mar ñho nda gohnu̱ Antiokia. ");
INSERT INTO otqNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ar Pablo ne ar Berhnabe ka bi gohnu̱ nꞌehe, mi mfa̱xkwi maꞌra ya ku, mi utꞌu̱ ár mhö Jö, ne mi mömba ár hoga mhö ar tsi Hmu, mi xipa nze̱ye̱ maꞌra. ");
INSERT INTO otqNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Núꞌmu̱ xki tho ꞌra ya pa, ar Pablo bi ꞌñemba ar Berhnabe: —Möhö manꞌagi, ma ga kꞌöꞌsu̱ ya ku ha gatho ya hnini da thohu̱ da mömfu̱ ár mhö Jö, ma ga nuhu̱ tengu yá mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ar Berhnabe mi ne nda zixa ar Xuwa nöꞌö mi tꞌembabi ar Mörko nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ha nunar Pablo himbi numañho nda zixꞌu̱, ngetho mamꞌe̱tꞌo mi ꞌñowi, ne núnu̱ Panfilia bi ꞌwege, ne himbi ne nda me̱witho nda mömba ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Njapꞌu̱ xa bi ntsa̱hñökiwi ar Pablo ne ar Berhnabe, jange bi ma nꞌampꞌu̱ nꞌa ngu nꞌa. Ar Berhnabe bi zixa ar Mörko, bi gu̱ ar motsa bi ꞌraxa ñho̱nthe ndi ma Txipre. ");
INSERT INTO otqNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nor Pablo bi hwahna ar Sila nda me̱wi. Ne nuya ku bi ꞌye̱ntꞌwa ár ꞌye̱ Jö ne nda hwëkwa ár mfa̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ne bi gu̱ yá ꞌñu bi ma har ha̱i Nsiria, bi ꞌranda Nsilisia mi huꞌmba yá mu̱i ya ku, njapꞌu̱ nda hñuxa yá ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Mi zo̱nga ar Pablo ne ar Sila har hnini Derbe, ne bi thoꞌu̱ bi ma har hnini Listra, habu̱ ba nthe̱wi nꞌar gamfi ár thuhu Timoteo. Ár nönö mar xodyo ne mar gamfi, ha nu ár dada mar me Gresia. ");
INSERT INTO otqNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nuya ku mi ꞌbu̱ Listra ne Ikonio, xa mi ñömañhobi ar ku Timoteo. ");
INSERT INTO otqNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ar Pablo bi beni mar ñho nda zitsꞌi. Ho̱nse̱ mꞌe̱tꞌo bi hñuꞌspa ar nse̱gi hár ndoꞌyo, ne hinge nda bo̱ yá kwe̱ nuꞌu̱ ya xodyo mi ꞌbu̱hnu̱, ngetho gatho mi pödi már me Gresia ár dada. ");
INSERT INTO otqNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ne bi gu̱ ar ꞌñu bi maꞌu̱, ne ha gatho ya hnini mi thogi, mi xipabi ya gamfi nöꞌö xki nko ya mpo̱te ne yá ndö ar nijö Herusalen, tema nda ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Njapꞌu̱ xa mi huxa yá jamfi ya ku, ne hyaxꞌmu̱ mi xuꞌu̱ ár nze̱ye̱. ");
INSERT INTO otqNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ne bi mengi bi gu̱ yá ꞌñuꞌu̱, bi ga̱xta Frigia ne Galasia, ngetho ár Hñö Jö himbi hye̱gi nda thoꞌu̱ har ha̱i Asia nda mömba ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nu mi zo̱nga har ha̱i Misia, mi nehmö nda thoꞌu̱ Bitinia, nunár Hñö Jö himbi hye̱gi. ");
INSERT INTO otqNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jange bi thota Misia, bi maꞌu̱ har hnini Ntroa. ");
INSERT INTO otqNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mi nxui ar Pablo bi hyanda ntꞌi nꞌar ñꞌo̱ho̱ me Nmasedonia, mi ꞌba̱hnu̱, mi a̱pa ar möte, ne mi embabi: Di a̱ꞌi gi ekwa Nmasedonia gi fa̱xkagihe. ");
INSERT INTO otqNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nu mi wa ar Pablo bi hyanda nöꞌö ngu ar tꞌi, dama da hoñhe hanja nga möhe har ha̱i Nmasedonia, ngetho ndi pöhe xiñho gese̱ Jö mi pe̱nkagihe ma nga mömfenu̱ ar hoga mhö. ");
INSERT INTO otqNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mꞌe̱fa da po̱ñhenu̱ Ntroa, da ꞌraxe njöntho har ñho̱nthe, da tso̱ñhe har ha̱i Samotrasia. Ár hyaxꞌöpꞌu̱ da tso̱ñhe har hnini Neapolis. ");
INSERT INTO otqNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Da thohenu̱ da möhe Nfilipo nꞌár hnini ya me Nroma, ne gehnu̱ nꞌar döta hnini har ha̱i Nmasedonia. Ka da ꞌbu̱henu̱ ꞌra ya pa. ");
INSERT INTO otqNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nꞌar pa ntsa̱ya̱, da po̱ñhe har hnini da möhe har döthe, habu̱ xki nzöngya jöꞌi mi a̱pa Jö. Ka da huhenu̱ habu̱ xki mhuntsꞌa ꞌra ya ꞌbe̱hñö, ne da du̱ꞌmhe da xife ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mi ꞌbu̱hnu̱ nꞌar ꞌbe̱hñö mar thuhu Lidia, me Tiatira. Mi pa̱ ya hoga dutu xki njötꞌa the̱ni, ne xa mi honga Jö. Mi ꞌyo̱ nöꞌö mi mönga ar Pablo, Jö bi xokwa ár mfeni nda jamasu ñöꞌö mi möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nu mi wadi bi nxixtheꞌö ne gatho nuꞌu̱ mi ꞌbu̱ hár ngu, bi ꞌñengagihe: —Nuꞌmu̱ gi hanthu̱ xa majöni xta ñꞌemu̱i ar tsi Hmu, di ne gi möhu̱ ma gi haxu̱ ha ma ngu. Njapꞌu̱ bi jaje da kohenu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nꞌar pa ngar möhe habu̱ xki nzöi mi tꞌa̱pa Jö, har ꞌñu da nthe̱he nꞌar nxutsi mi nthe̱xkwi nꞌar tsꞌondöhi mi japi nda bödi. Nuyá hmu xa mi tö nze̱ ar bojö har ꞌbe̱fi mi pe̱ ngu ar bödi. ");
INSERT INTO otqNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nunar nxutsinu̱ mi te̱ngagihe, ne xa mi mafi mi enö: —Nuya ñꞌo̱ho̱yu̱ yá ꞌbe̱go Jö bi ꞌbu̱ mhetsꞌi, ne utꞌahu̱ ar ꞌñu hanja gi mpo̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hyaxꞌmu̱ mi njapꞌu̱ nze̱ye̱ ya pa mi te̱ngagihe. Ar Pablo bi the ár tsꞌe̱ti mi o̱tsꞌe hyaxꞌmu̱. Nuꞌmú̱, bi mengi ne bi xipa nöꞌö ar tsꞌondöhi mi pe̱ꞌsa ar nxutsi: —Hár thuhu ar Hesukristo di ꞌbe̱pꞌaꞌi gi po̱nga har nxutsinu̱. Nuꞌmú̱, dama bi bo̱nga ar tsꞌondöhi. ");
INSERT INTO otqNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ha nu mi hyanda yá hmu hinge nda dö ar bojö, bi gu̱ ar Pablo ne ar Sila, bi ziꞌspa yá ndö mi ꞌbu̱hnu̱ har ta̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mi mꞌa̱ꞌma ha ya nza̱ya̱, bi tꞌembabi: —Nuya xodyoyu̱, xpa ekwa ho̱nse̱ da japa da mu̱nsa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Utkagihu̱ yá ntꞌumbi nuꞌu̱ hingi ho ga höñhu̱ ga o̱thu̱, ngetho dar me Nromahu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gatho nuya jöꞌi xki mhuntsꞌi, bi watꞌi nda me̱i. Ha nuya nza̱ya̱ bi mo̱kwa yá dutu, ne bi ꞌbe̱pa nda thu̱xtꞌa ya tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mi wadi xa bi nꞌwe̱xtꞌi, bi tꞌetꞌa har fa̱di, ne bi nsipa ar sufa̱di nda su xiñho. ");
INSERT INTO otqNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mi ꞌyo̱ njapꞌu̱ ar sufa̱di, bi gotꞌa ya mbo ar fa̱di, ne bi ze̱ꞌmba yá wa ha nꞌar za, ne njapꞌu̱ hinge nda za̱ nda xotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ha nu made ar xui, ar Pablo ne ar Sila mi matꞌa Jö, mi tutwa ya thuhu, ne gatho nu maꞌra ya ꞌyofa̱di mi o̱xtho. ");
INSERT INTO otqNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nꞌa mbi da̱ñꞌu̱ bi nja nꞌar döta nhwöni. Xa mi nhwönga ya jödo, ne bi xo gatho ya goxthi, ha nuya bo̱jö mi thötꞌa yá ꞌye̱ ya ꞌyofa̱di bi xotꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bi nu ar sufa̱di, ne mi hyandwa yá goxthi ar fa̱di mi xotho, bi gu̱ ár ndo̱jwai nda ñhose̱, ngetho mi humamu̱i xki bo̱nga gatho ya ꞌyofa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nunar Pablo bi matꞌi, ne bi ꞌñembabi: —Yo ma gi ñho. Di ꞌbu̱thewa gatho. ");
INSERT INTO otqNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nuꞌmú̱ ar sufa̱di bi ꞌya̱ nꞌar ñotꞌi, bi nixtꞌi bi yu̱tꞌa mbor fa̱di, ne xa mi nhwötꞌar ntsu. Ngutꞌa bi nda̱ndihmö ha yá wa ar Pablo ne ar Sila. ");
INSERT INTO otqNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nepꞌu̱ bi gu̱ka nthi, ne bi ꞌya̱mbabi njawa: —Ñꞌo̱ho̱hu̱, tema mahyoni ga pe̱fi ne da za̱ ga mpo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nuya ku bi ꞌñembabi: —Ñꞌemu̱i ar tsi Hmu Hesukristo ne gi mpo̱ho̱, nuꞌge ne gatho nuꞌu̱ ꞌbu̱ ha ri ngu. ");
INSERT INTO otqNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ne bi xipabi ár mhö Jö ar sufa̱di ne gatho nuꞌu̱ mi ꞌbu̱hnu̱ hár ngu. ");
INSERT INTO otqNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Núꞌmu̱ mi nxuitho, ar sufa̱di bi xu̱kwabi habu̱ xki nthe̱wi ya mfe̱i. Ne hingar yaꞌö bi nxixthewi gatho yá mëni. ");
INSERT INTO otqNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nepꞌu̱ bi zixa hár ngu, ba umba te nda ziꞌu̱. Ne xa bi njohyawi gatho nuꞌu̱ mi ꞌbu̱ hár ngu, ngetho xki ñꞌemu̱ibi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ár hyaxꞌö, ya nza̱ya̱ bi me̱hna yá mfa̱tsꞌi, ma nda ꞌñemba ar sufa̱di: —Hye̱ nuya ñꞌo̱ho̱yu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ar sufa̱di bi ꞌñemba ar Pablo: —Xpa ꞌbe̱nka ár mhö ya ndö ga he̱kꞌahu̱. Da za̱ gi po̱ñhu̱, di möhu̱ ter entho. ");
INSERT INTO otqNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nunar Pablo bi ꞌñembabi nuꞌu̱ togo ba hö ar mhö: —Xi mfe̱bgagihe ha yá nthandi ya jöꞌi, hinxi thimgagihe yoꞌö, ha dar me Nromahe nꞌehe, ne xi jokagihe har fa̱di. Ha nupya hö, ne da the̱gagihe ñꞌöntho, hingi ne to da bödi. ꞌÑembabihu̱ ya ndö da ese̱ da gu̱gagihe. ");
INSERT INTO otqNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nuyá mfa̱tsꞌi ya nza̱ya̱ bi mengi, ma ba xipabi nöꞌö bi möñꞌö. Núꞌmu̱ mi bödi ma ya me Nroma, xa bi ntsu. ");
INSERT INTO otqNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jange nuya ndö bi ma ba a̱pa ar mpumbate ya ku, bi gu̱ka har fa̱di, ne bi ꞌya̱pabi nda bo̱nga har hnini. ");
INSERT INTO otqNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nu mi bo̱nga ya ku har fa̱di, bi ma hár ngu ar Lidia, habu̱ ba huꞌmbabi yá mu̱i ya ku. Nepꞌu̱ bi bo̱ni bi maꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ar Pablo ne ar Sila bi thota ha ya hnini Anfipoli ne Apolonia, ne bi zo̱ñꞌu̱ har hnini Ntesalonika. Ka mi ꞌbu̱hnu̱ nꞌár nijö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ar Pablo ngu xki nzöñꞌö bi yu̱tꞌa har nijö, mi ñöwi ya xodyo hñu ya pa ntsa̱ya̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mi xipabi ne mi utꞌu̱ ngu mi mönga ár Tꞌofo Jö. Mi enö mi mahyoni nda tho nze̱ye̱ ya u̱gi ar Kristo, nda du, ne nda mengi nda nte. Ne mi enö nꞌehe: —Nuna ar Hesu di xiꞌahu̱, gehnu̱ ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ꞌRaya xodyo bi ñꞌemu̱i, ne bi de̱nga ar Pablo ne ar Sila. Bi ñꞌemu̱i nze̱ye̱ ya me Gresia nꞌehe nuꞌu̱ mi honga Jö, ne nze̱ye̱ ya ꞌbe̱hñö nuꞌu̱ mi numañho ar hnini. ");
INSERT INTO otqNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Jange ya xodyo nuꞌu̱ himya gamfi, xa bi mbo̱ yá kwe̱, ne bi ma ba muntsꞌa ꞌra ya tsꞌojöꞌi mi ꞌyo döhñetho. Bi gu̱xa ya jöꞌi ne bi zixa hár ngu ar Hason, ma nda gu̱jhmö ar Pablo ne ar Sila, ne nda ꞌye̱ntꞌwa ha yá ꞌye̱ ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ne himbi dini, jange bi gu̱ka ar Hason ne maꞌra ya ku, bi zixa ha yá ndö ar hnini, ne xa mi mafi mi eñꞌu̱: —Nuya jöꞌi ne da pongar ximha̱i, xi zo̱kwa nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ha nunar Hason xi umbar se̱ki hár ngu. Gathoyu̱ hingi o̱ta nöꞌö xi möngar Sesar ma ndöhu̱ Nroma, ngetho eñꞌu̱ ꞌbu̱ manꞌar ndö ár thuhu ar Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nu mi ꞌyo̱ njapꞌu̱ ya jöꞌi ne yá ndö ar hnini, bi mbo̱ yá kwe̱ ne xa mi ñöxhnatho. ");
INSERT INTO otqNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nunar Hason ne nu maꞌra mi ñꞌowi, bi unga ar bojö mi tꞌa̱pabi, ne bi nthe̱gi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ngu mi nxuitho, ya ku mi ꞌbu̱hnu̱ dama bi me̱hna ar Pablo ne ar Sila nda ma har hnini Berea. Nu mi zo̱ñꞌu̱, bi yu̱tꞌa ha yá nijö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nuya xodyo me Berea xa ma ya hogajöꞌi, hinge ngu nuya me Ntesalonika. Jange xa bi njohya bi ꞌyo̱ꞌspa ár mhö Jö, ne hyaxtho mi honga har Tꞌofo, mi he̱ki ha majöni mi njapꞌu̱ nöꞌö mi möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ne nze̱ye̱ ya xodyo bi ñꞌemu̱i, njapꞌu̱tho nꞌehe ꞌra ya ꞌbe̱hñö me Gresia mi nhumahño. Ne nze̱ye̱ ya ñꞌo̱ho̱ ya mengunu̱ bi ñꞌemu̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ha nu mi ꞌyo̱ ya xodyo me Ntesalonika xki zo̱nga ar ku Pablo Berea, mi mömba ár mhö Jö nu̱ nꞌehe, nuyu̱ bi ma ba japa ya jöꞌi bi mu̱xmatho. ");
INSERT INTO otqNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ne nuya ku ngutꞌa bi gu̱ka ar Pablo bi me̱hna har ñönthe, ha nunar Sila ne ar Timoteo bi gohnu̱ꞌu̱ Berea. ");
INSERT INTO otqNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nuꞌu̱ togo bi zixa ar Pablo, bi me̱wi ba tso har hnini Atena. Nu mba penkꞌu̱, ba hömpa ar nze̱ngwa nda xipa ar Sila ne ar Timoteo nda ma ngutꞌa ma nda nthe̱winu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nu mi ꞌbu̱hnu̱ Atena ar Pablo, mi to̱ꞌma ar Sila ne ar Timoteo, xa mi tso̱tꞌa ár mu̱i, ngetho bi hyandi xa mi janu̱ nze̱ye̱ ya tsita empꞌö mi ndönga ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jange mi ñöwi ya xodyo ha yá nijö, ne gatho nu maꞌra mi honga Jö, ne hyaxtho mi ꞌyonu̱ har ta̱i mi zo ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bi ntsa̱hñökiwi ꞌra ya utate te gatho bentho. ꞌRa mi enö da tꞌumba gatho nöꞌö ne ár ndoꞌyo, maꞌra mi enö nunar mfödi da jakagihu̱ ga ꞌbu̱hu̱ xiñho. Ne mi eñꞌu̱: —Tema ne da xiju̱ nunar ñꞌo̱ho̱ xa te gatho mö. Ha maꞌra mi enö: —Atho no̱nga maꞌra ya ꞌraꞌyo jö. Mi mönga njapꞌu̱ ngetho ar Pablo mi xipabi ár hoga mhö ar tsi Hmu Hesu, ne ar menga nte. ");
INSERT INTO otqNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nepꞌu̱ bi tsꞌixa ar Pablo ha nꞌar mhuntsꞌi mi tꞌo̱tꞌa har nꞌar tsi tꞌo̱ho̱ xki thuꞌspa ár thuhu yá jöꞌu̱ Ares. Ne bi tꞌembabi: —Hage da tsa̱ gi ꞌyotkagihe ar ꞌñu nunar ꞌraꞌyo ntꞌuti gi ꞌyo gi mö. ");
INSERT INTO otqNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ngetho gi xikagihe nöꞌö hinxta o̱he. Di ne ga pöhe te di bo̱nga nuya mhö gi mö. ");
INSERT INTO otqNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bi mönga njapꞌu̱ ngetho gatho ya me Atena ne nuya nzo̱ho̱ mi ꞌbu̱hnu̱, xki nzöi nda mhuntsꞌi ho̱nse̱ nda mpede tema xki bödi maꞌraꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nuꞌmú̱ ar Pablo bi mꞌa̱ madeda ar mhuntsꞌi har tsi tꞌo̱ho̱ Ares, ne bi ꞌñenö: —Nuꞌahu̱ gar me Atenahu̱, xta pödi xa gi pe̱hu̱ ngu mönga ri ntꞌumbihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ndi tho ha ri nijöhu̱ habu̱ gi ndöñhu̱, da handa habu̱ gi exu̱ ri jöhu̱, mi tu nꞌar ntꞌofo enö: Ka ꞌbu̱kwa nöꞌö ar Jö hingi födi. Nunar Jö gi ndöñhu̱ ne hingi pöhu̱, getꞌö nöꞌö xta e ga xiꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nöꞌö ar Jö togo bi hyoka ar ximha̱i ne gatho te jawa, go geꞌö ar ndö mhetsꞌi ne ar ximha̱i, hingi ꞌbu̱ ha ya nijö xi hyoka ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Hingi japar ꞌbe̱di nöꞌö te da mo̱ꞌspa ya jöꞌi, ngetho geꞌö togo hö ar te, ne ꞌraju̱ ar ndöhi ga joxa ma hñöhu̱, ne ꞌraju̱ gatho nöꞌö di hoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ha nꞌadar jöꞌi bi japi bi bo̱nga gatho ya meximha̱i, ne bi xanga xo̱ge ár nxidi ar ximha̱i. Xi hñuꞌspa hangu nje̱ye̱ da mꞌu̱i, ne habu̱ tso̱nga ár me̱ti. ");
INSERT INTO otqNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Bi japꞌu̱ ne nga hoñhu̱ Jö, xömhö ga tiñhu̱, xa majöni hingi yapꞌu̱ di ꞌbu̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngetho di ꞌbu̱hwihu̱ꞌö, di ꞌñöñhu̱, ne go gekagihu̱ ngu neꞌö. Jangu bi ꞌñenga ꞌra ri duhuhu̱: Nuju̱ go yá bötsigihu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Jange nuꞌmu̱ yá bötsigihu̱ Jö, hinga ma ga möñhu̱ ñhe̱hwi Jö nꞌar tsita xi thoka ar kꞌaxtꞌabo̱jö, wa ar tꞌaxbo̱jö, wa ar do, ngu xi bense̱ xi hyoka ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nuya pa xi thogi, Jö himbi jamasu nuna tema bi ꞌyo̱tꞌa ya jöꞌi himi pöꞌö. Ha nupya hö, ne gatho ya jöꞌi da ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ngetho Jö xi hñuxa nꞌar pa hamꞌu̱ ma da hñöꞌspa majöni gatho nuya jöꞌi xi mꞌu̱kwa har ximha̱i, ma da ꞌyo̱tꞌa har hoga tsꞌutꞌwi. Ha nöꞌö togo xi hñutsꞌi da hñöxa majöni, getꞌö togo bi ñꞌuꞌö núꞌmu̱ mi koꞌspa ár te. ");
INSERT INTO otqNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nu mi ꞌyo̱ꞌu̱ da mengi da nte nuꞌu̱ xi du, ꞌra mi thentho ne maꞌra mi enö: —Manꞌar pa gi pengi gi zokagihe nöꞌö gi mö. ");
INSERT INTO otqNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nuꞌmú̱ ar Pablo bi ma bi zopꞌu̱ habu̱ mi ꞌbu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ha ꞌra bi ñꞌemu̱i ne mi ñꞌowi, nꞌa már thuhu ar Nisio mar ndö nꞌehe har mhuntsꞌinu̱, nꞌar ꞌbe̱hñö már thuhu Damari, ne maꞌra ya mengunu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mꞌe̱fa ar Pablo bi bo̱nga Atena, bi ma har hnini Nkorinto. ");
INSERT INTO otqNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ka bi nthe̱winu̱ nꞌar xodyo már thuhu Akila, mar me Ponto. Ja xki ꞌñe har ha̱i Italia, mi ñꞌowi ár ꞌbe̱hñö, ár thuhu Prisila. Xki bo̱ñꞌu̱ har hnini Nroma, ngetho ar ndö Klaudio bi mö nda tꞌe̱nga gatho ya xodyo mi ꞌbu̱hnu̱. Ar Pablo bi ma ba tsu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bi ma ba ꞌbu̱hwiꞌu̱, ngetho nꞌadar ꞌbe̱fi mi pe̱ꞌu̱, ma ya hoka ngudutu nꞌa ngu nꞌaꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Gatho ya pa ntsa̱ya̱, ar Pablo mi pa ha yá nijö ya xodyo mi ñöwi. Ne mi umbár mu̱i mi nehmö nda ñꞌemu̱i ya xodyo ne nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mi zo̱ ar Sila ne ar Timoteo, xki ꞌñe Nmasedonia. Nu mi nthe̱wi ar Pablo, xa mi umbár mu̱i mi xipabi ar hoga mhö ya xodyo, mi embabiꞌu̱ nunar Hesu gehnu̱ ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ha nuya xodyo bi do̱xtho ne mi tsani. Nuꞌmú̱ ar Pablo bi hwötꞌa ár he, ne bi ꞌñembabiꞌu̱: —Nuꞌahu̱ go xka ntsꞌokse̱hu̱. Nuga hinte ma tha̱i di tuga. Nupya di mapꞌu̱ ma ga zo nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ar Pablo bi bo̱ni bi ma hár ngu nꞌar ñꞌo̱ho̱ már thuhu ar Husto, xa mi honga Jö. Nor nguꞌö mi ꞌbu̱ getꞌu̱ ár nijö ya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nepꞌu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Krispo, már ndö ha yá nijö ya xodyo, bi ñꞌemu̱i ar tsi Hmu Hesu, nunu̱ ne gatho nuꞌu̱ mi ꞌbu̱ hár ngu. Ne nze̱ye̱ ya me Nkorinto bi ꞌyo̱twa ár mhö Jö, bi ñꞌemu̱iꞌu̱, ne bi nxixthe. ");
INSERT INTO otqNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nꞌar nxui ar tsi Hmu bi zo ar Pablo ngu nꞌar tꞌi, ne bi ꞌñembabi: —Yo gi ntsu, mönga ar mhö, yo ma gi ñhe. ");
INSERT INTO otqNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ngetho nuga di ꞌbu̱hwi, hinjoꞌo togo da gu̱xa ár ꞌye̱ da ꞌyo̱tꞌar tsꞌomꞌu̱i. Ha nunar hnininu̱ ꞌbu̱ nze̱ye̱ ya jöꞌi xta hwahni da ñꞌemu̱igi. ");
INSERT INTO otqNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jange ar Pablo bi gohnu̱ nꞌa nje̱ye̱ made har hnini Nkorinto, mi utwa ya jöꞌi ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bi zo̱ta nꞌar pa ya xodyo bi me̱ꞌsa nꞌadar nkohi bi gu̱ ar Pablo, ne bi ziꞌspa ar tsꞌu̱tꞌwi. Nuya paꞌu̱ ar Galio mar ndö núnu̱ har ha̱i Akaya. ");
INSERT INTO otqNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ne bi ꞌñenga ya xodyo: —Nunar ñꞌo̱ho̱nu̱ u̱tꞌa ya jöꞌi hinda ndönga Jö ngu mönga ár tꞌofo ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ar Pablo mi fu̱di nda ñömhö, ha nunar ndö Galio bi ꞌñemba ya xodyo: —Nuꞌmu̱ tema xi jaꞌahu̱, wa nuꞌmu̱ xi ꞌyo̱tꞌa nꞌar döta tsꞌoki, nuꞌmú̱ hö, da tsa̱ ga o̱tꞌahu̱, nuꞌahu̱ gar xodyohu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ha nuꞌmu̱ ho̱nse̱ gi no̱ñhu̱ ya mhö, ya thuhu, ne yá ꞌbe̱fi ri tꞌofohu̱, nuhu̱ tema gi pe̱hu̱. Hindi ne gi ju̱gagihu̱ ngu ar tsꞌu̱tꞌwi. ");
INSERT INTO otqNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ne bi tꞌe̱nga hár tsꞌu̱tꞌwi. ");
INSERT INTO otqNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nuꞌmú̱ nuꞌu̱ himya xodyo bi gu̱ ar Sostene, ár ndö ár nijö ya xodyo mi ꞌbu̱ har hniniꞌö, xa bi fe̱nza hár nthandi ar ndö Galio, ha nunu̱ himbi dupa ár mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ar Pablo bi gohnu̱ ma nze̱ye̱ ya pa. Mꞌe̱fa bi ꞌñe ya ku, bi me̱wi ar Akila ne ar Prisila, bi ꞌraxa ar ñho̱nthe bi ma har ha̱i Nsiria. Nu mi ꞌyo ar ꞌñu, ar Pablo bi ꞌñöxa ár xtö núnu̱ Nsenkrea, ngetho xki ñötꞌwa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nu mi zo̱nga Efeso, ka bi hye̱hnu̱ ar Akila ne ar Prisila, ne nöꞌö bi yu̱tꞌa ha yá nijö yá mixodyowi mi ñöwi. ");
INSERT INTO otqNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nuya mengunu̱ mi a̱par möte nda gohnu̱ ꞌra ya pa, ha nunar Pablo himbi ne. ");
INSERT INTO otqNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Jange bi ñꞌehwi, ne bi ꞌñembabi: —Mahyoni ga ꞌbu̱ Herusalen, ma ga thohnu̱ ar da̱ngo ba epꞌu̱. Mꞌe̱fa ga pengi ga kꞌösꞌahu̱, nuꞌmu̱ njapꞌu̱ ne Jö. Ne bi gu̱ ar motsa ba po̱nu̱ Efeso. ");
INSERT INTO otqNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nu mi zo̱nga Nsesarea, bi thogi ndi ma Herusalen, ma ba ze̱ngwa ya ku. Nepꞌu̱ bi gu̱ ar ꞌñu bi ma Antiokia. ");
INSERT INTO otqNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ka bi gohnu̱ ꞌra ya pa. Ne bi mengi bi bo̱ni, ma ba kꞌöꞌsa nꞌa ngu nꞌa ya hnini har ha̱i Galasia, ne har ha̱i Frigia. Mi xipa ya ku hyaxꞌmu̱ nda ze̱ta yá ñꞌemu̱i, nda umbyá mu̱i nda mpe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nuya paꞌu̱ nꞌar xodyo már thuhu Apolo bi zo̱nga Efeso. Mar me Alejandria, xaka mbödi te nda mö, ne mi pötwa xiñho ár Tꞌofo Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nunu̱ xki tꞌutꞌwabi ár ꞌñu ar tsi Hmu, xa mi umba ár mu̱i mi mömba ár mhö ar tsi Hmu, ne njapꞌu̱ mi uta maꞌra, mödi ho̱nse̱ mi pötwa ár xixthe ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bi ndu̱i bi zo ya xodyo ha yá nijöꞌu̱, hinto mi tsu. Ha nu mi ꞌyo̱xa ar Prisila ne ar Akila, bi zixyu̱ nꞌampꞌu̱, bi utwabi xiñho ár ꞌñu Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nunu̱ mi ne nda ma Akaya, ne nuya ku me Efeso bi hñuꞌmba ár mu̱i. Ne bi me̱mpa nꞌar he̱ꞌmi nuya ku mi ꞌbu̱hnu̱ Akaya nda numañho núꞌmu̱ nda zo̱ho̱. Nu mi zo̱ñꞌö, xa bi ma̱xa gatho nuꞌu̱ xki hwëkwa Jö nda ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ngetho xa mi umba ár mu̱i mi kotwa yá ne ya xodyo madeda ya jöꞌi, ne mi otꞌwa ar ꞌñu hár Tꞌofo Jö, nda böꞌu̱ ar Hesu gehnu̱ ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Núꞌmu̱ mi ꞌbu̱hnu̱ Nkorinto ar Apolo, ar Pablo bi thota ar ꞌñu tho ha ya tꞌo̱ho̱ ba tso̱nga Efeso. Ka bi nthe̱winu̱ ꞌra ya gamfi. ");
INSERT INTO otqNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ne bi ꞌya̱mbabi: —Ha ga hñöñhu̱ ár Hñö Jö núꞌmu̱ nga ñꞌemu̱ihu̱. Bi döꞌu̱: —Hinꞌö, hindi pöhe teme ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nuꞌmú̱ ar Pablo bi ꞌya̱mbabiꞌu̱: —Tema xixthe xka hñöñhu̱ ꞌmu̱. Nuꞌu̱ bi ꞌñeñꞌu̱: —Ár xixthe ar Xuwa. ");
INSERT INTO otqNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ar Pablo bi ꞌñembabiꞌu̱: —Ar Xuwa mi xixthe ya jöꞌi xki ꞌyo̱tꞌwa ár ntso̱ꞌmi yá tsꞌoki. Ne bi xipabi mi mahyoni nda ñꞌemu̱i togo nda ꞌñepꞌu̱ mꞌe̱fa. Mi no̱nga ar Hesu togo ar Kristo. ");
INSERT INTO otqNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nu mi ꞌyo̱ njapꞌu̱, bi nxixtheꞌu̱ hár thuhu ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nepꞌu̱ ar Pablo bi hñuꞌspa ár ꞌye̱ ya ku, ne bi hñöñꞌu̱ ár Hñö Jö. Bi ndu̱i bi ñö maꞌra ya hñö, ne mi ñöꞌu̱ ngu mi xipa ár Hñö Jö nda möñꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nuya mi ꞌbu̱hnu̱ mi tsu̱ ngu ꞌre̱tꞌamayoho ya ñꞌo̱ho̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ar Pablo mi ku̱tꞌa ha yá nijö ya xodyo. Mi ñöwi ne himi ntsu mi mömba ár mhö Jö, ne mi umba ár mu̱i mi utyu̱ ár tsꞌu̱tꞌwi Jö. Hñu nzönö bi japꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ꞌRa bi gotꞌa yá mfeni, himbi ne bi jamfi, ne madeda ya jöꞌi, mi tsamba ár ꞌñu Jö. Jange ar Pablo bi ꞌweka ya gamfi, ne hyaxꞌmu̱ mi uta ha nꞌar ngu ntꞌuti, már me̱ti nꞌar utate már thuhu ar Tirano, mar mengunu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Yo nje̱ye̱ bi japꞌu̱, ne gatho nuꞌu̱ mi ꞌbu̱ har ha̱i Asia bi ꞌyo̱twa ár mhö ar tsi Hmu Hesu, ngu ya xodyo ne nuꞌu̱ himya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ar Pablo bi ꞌyo̱tꞌa nze̱ye̱ ya döta ntꞌudi mi hömpa ár tsꞌe̱di Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nꞌandi ho̱nse̱ mi thöꞌspa yá nthuꞌmxi ne maꞌra yá dutu xki hye ar Pablo, ne nda thöꞌspa habu̱ mi ꞌbu̱ ya da̱thi, mi thitsꞌi, ne ya tsꞌondöhi mi po̱ni mi he̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ne ꞌra ya xodyo ma ya gu̱ka ndöhi, habu̱ gatho mi ꞌyo mi ju̱ka ya tsꞌondöhi, nꞌa mbi beñꞌu̱ nda ꞌye̱nga ya tsꞌondöhi nda no̱mba ár thuhu ar tsi Hmu Hesu nꞌehe. Njanu̱ mi embabi ya tsꞌondöhi: —Di no̱ñhe ár thuhu ar Hesu nöꞌö no̱nga ar Pablo, di xiꞌahe gi po̱ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mi pe̱ njanu̱ nuꞌu̱ yoto yá tꞌu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Seba, mar xodyo ne már ndö ya möjö. ");
INSERT INTO otqNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ha núꞌmu̱ mi e̱nga nꞌar tsꞌondöhi, nunu̱ bi dödi ne bi ꞌñenö: —Nuga di pödi togo ar Hesu, ne di pödi togo ar Pablo. Xi nuꞌahu̱, togoꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nöꞌö ar ñꞌo̱ho̱ xki nthe̱xkwi ar tsꞌondöhi, bi ꞌye̱ngar nsa̱gi ne bi ꞌyentꞌa nuya ñꞌo̱ho̱yu̱. Bi ntöte, ne nuya ñꞌo̱ho̱ núꞌmu̱ mi bo̱nga nhixtꞌitho har ngu, mi nthe̱mfotho, ne xa xki ntsꞌe̱ni. ");
INSERT INTO otqNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Gatho ya me Efeso, ya xodyo ne nuꞌu̱ himya xodyo, bi ꞌyo̱xa nöꞌö xki thogi, jange xa bi zuꞌu̱, ne xa mi tꞌeꞌspár nsu ár thuhu ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nze̱ye̱ nuꞌu̱ xki ñꞌemu̱i mi e madeda gatho ya ku mi da̱majöni nöꞌö xki ꞌyo̱tꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nze̱ye̱ ya ku ma ya ñꞌete bi hñöxa yá he̱ꞌmi bi tsꞌötꞌa habu̱ xki mhuntsꞌa gatho. Nu mi nuꞌu̱ hangu xki ꞌbe̱pꞌu̱, mi tsu̱ ngu ku̱tꞌanthebe ya nthebe ya tꞌaxbojö. ");
INSERT INTO otqNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Njapꞌu̱ xa mi ntu̱nga ár mhö ar tsi Hmu ne mi nheki ár tsꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mi wadi da tho gathoyu̱, ar Pablo bi beni nda tho Nmasedonia ne Akaya, ne nda zo̱nga Herusalen. Ne mi enö: —Xka jwadi ga ꞌbu̱hnu̱ Herusalen, mahyoni ga ma Nroma nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ne bi me̱hna yoho yá ma̱xte bi ma Nmasedonia, ar Timoteo ne ar Erasto. Ha nöꞌö bi gohnu̱ Asia maꞌra ya pa. ");
INSERT INTO otqNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nuya paꞌu̱ bi mu̱xma ya me Efeso, ngetho mi mhömba ár ꞌñu Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mi ꞌbu̱hnu̱ nꞌar ñꞌo̱ho̱ mar thuhu ar Demetrio. Már ꞌbe̱fiꞌö mi hoka ya tsita ma ya tꞌaxbo̱jö. Mi kꞌoꞌspabi ár nijö yá tsita ar Diana, mi pa̱pa ya jöꞌi. Njapꞌu̱ nuꞌu̱ togo mi mpe̱ nor ꞌbe̱finu̱, mi tö nze̱ye̱ ya bojö. ");
INSERT INTO otqNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ar Demetrio bi muntsꞌa gatho nuꞌu̱ mi pe̱ nunar ꞌbe̱finu̱, ne bi ꞌñembabiꞌu̱: —Ha gi o̱hu̱ ñꞌo̱ho̱hu̱. Gi pöhu̱ xiñho, nunar ꞌbe̱finu̱ fa̱xju̱ di töhu̱ nze̱ye̱ ar bojö. ");
INSERT INTO otqNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Xka ꞌyo̱hu̱ ne xka hyanthu̱ ar Pablo, ꞌyo xipa ya jöꞌi nuya tsita hoka ya ñꞌo̱ho̱, hingya jöꞌu̱. U̱tꞌa ya jöꞌi, ne nze̱ye̱ xi ꞌweke te̱ñꞌö, hinge ho̱nse̱wa Efeso, xi japꞌu̱ xo̱ge har ha̱i Asia. ");
INSERT INTO otqNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nunar tsꞌokinu̱, hinge ho̱ntꞌa da hwata ma ꞌbe̱fihu̱. Da tsa̱ da mꞌe̱ ár nsu ár nijö ma tsi nönöhu̱ Diana, ne da mꞌe̱ ár nsunda nuna togo ndönga gatho ya jöꞌiwa me Asia, ne gatho ya meximha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mi ꞌyo̱xa gatho nuꞌu̱ mi pe̱ nunar ꞌbe̱finu̱, xa bi mbo̱ yá kwe̱, ne mi he̱xa ya mhafi, mi eñꞌu̱: —Döta ar tsita Diana, ár me̱ti ya me Efeso. ");
INSERT INTO otqNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Gatho ya mengunu̱ himi pödi te nda beñꞌu̱, ne nꞌa mfenitho bi nixtꞌi bi ma habu̱ xki nzöi mi tꞌo̱tꞌa ya mhuntsꞌi. Ne bi nju̱ ar ku Gayo ne ar ku Aristarko, ya me Nmasedonia, yá ñꞌohu̱ ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ar Pablo mi nehmö nda yu̱tꞌi nda zo ya jöꞌi, ha nuya ku mi ꞌbu̱hnu̱ himbi hye̱gi. ");
INSERT INTO otqNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ꞌRa ya ndö me Asia mi ntsixkwi ar Pablo, bi me̱mpa ar nze̱ngwa hinge nda ma har döta mhuntsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nu har mhuntsꞌi, ꞌra mi mafi mi mönga nꞌar mhö, maꞌra mi mönga manꞌa, ngetho ya jöꞌi himi pödi tema nda beni, ne maꞌra himi pödi yoꞌö xki mhuntsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nuya xodyo bi gu̱ka ar Handro nda zohmö ya jöꞌi. Bi jár ꞌye̱ bi xipa ya jöꞌi nda ñhe, ne nda tsa̱ nda ñönga yá mixodyowi. ");
INSERT INTO otqNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Núꞌmu̱ mi bö ya jöꞌi mar xodyo nꞌe, bi ndu̱i nꞌatꞌwu̱ bi mafi ntsꞌe̱di ngu yo xe̱nimpa, mi eñꞌu̱: —Döta ar tsita Diana ár me̱ti ya me Efeso. ");
INSERT INTO otqNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nepꞌu̱ nꞌár ma̱xte ár ndö ar hnini, núꞌmu̱ mi wadi bi japi bi ñhe ya jöꞌi, bi ꞌñembabi: —Ndadahu̱ gar menguhu̱wa Efeso, togo hingi pödi nuya me Efeso supa ár nijö ma tsitahu̱ Diana, ne ár njötꞌi ba kö mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nuꞌmu̱ hinjoꞌo togo da tsa̱ da ko̱ni, xiñho gi ñheꞌu̱ ne hinge dama gi ju̱xa ri ꞌye̱hu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Xka tsihu̱wa nuya ñꞌo̱ho̱yu̱ hinte xi bë har nijö, ne hinxi ñömañꞌu̱ ma tsitahu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nuꞌmu̱ ar Demetrio ne nuyá ñꞌowi ja te da ga̱ꞌspa ya nza̱ya̱, ꞌbu̱ꞌu̱ da ꞌyo̱tsꞌe. Jange ꞌbu̱ nuya tsꞌu̱tꞌwiyu̱, dá nga̱xte nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ha nuꞌmu̱ ja manꞌa te gi nga̱xtehu̱, ma ga e̱nthu̱ nꞌar mhuntsꞌi habu̱ da tsa̱ da hogi. ");
INSERT INTO otqNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ma ga ntsuñhu̱ hinda tho̱xkagihu̱ di ju̱xu̱ ya jöꞌi xta böꞌu̱ nöꞌö xi thopya, ngetho nuꞌmu̱ da tꞌa̱ngagihu̱, tema ga thöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nu mi wadi bi mönga njapꞌu̱ ár ma̱xte ar ndö, bi fontꞌa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nu mi wa ar mu̱xmajöꞌi, ar Pablo bi zohna gatho ya ku, bi hñuꞌmba yá mu̱i, bi hyu̱fi, ne bi ñꞌedi bi bo̱ni bi ma Nmasedonia. ");
INSERT INTO otqNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bi mengi bi thota habu̱ xki tho mꞌe̱tꞌo mi tso̱nga ya ku, ne xa mi zofo mi huꞌmba yá mu̱i. Bi japꞌu̱ gatho ar ꞌñu ndi ma Gresia. ");
INSERT INTO otqNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ka bi mꞌu̱hnu̱ hñu nzönö, mi ñhoki ndi ma Nsiria. Ha bi zo ár gu nuya xodyo xki hñutsꞌi nda hyo núꞌmu̱ nda gu̱ ar motsa ndi manu̱, jange bi beni nda ga̱xta har ha̱i Nmasedonia manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bi me̱wi ndi ma Asia ar Sopate me Berea, ar Aristarko ne ar Segundo ya me Ntesalonika, ar Gayo me Derbe, ar Tikiko ne ar Trofimo ya me Asia, ne ar Timoteo. ");
INSERT INTO otqNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nuya kuyu̱ bi mꞌe̱tꞌo, ma ba to̱bgagihe Ntroa. Ka dá nthe̱henu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nuje da to̱ꞌmhe bi tho ar da̱ngo núꞌmu̱ tsꞌi ar thuhme hingi jotsꞌi. Mꞌe̱fa da po̱ñhenu̱ Mfilipo, da ꞌrañhe ar ñho̱nthe. Ku̱tꞌa mpa da ꞌyohe har dehe, ne da tso̱ñhe Ntroa. Dá nthe̱henu̱ ya ku xki mꞌe̱tꞌo, ne da kohenu̱ ma yoto mpa. ");
INSERT INTO otqNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nöꞌö ár ꞌbe̱tꞌo mpa ar hñöto, bi mhuntsꞌa gatho ya gamfi nda zipa ár tꞌoxi ar tsi Hmu. Ar Pablo mi uti, mi zo̱nga made nxui himi tsa̱ya̱tho, ngetho ma nda bo̱nga ár hyaxꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nunar ngu habu̱ xki mhuntsꞌi, mi to̱ mañö, ne xki tso̱ nze̱ye̱ ya ñotꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nꞌar tsꞌu̱ntꞌu̱ már thuhu Eutiko, mi huhnu̱ ha nꞌar ku̱tꞌahyatsꞌi. Bi zo̱par tꞌöhö, ngetho ar Pablo bi ñö yaꞌö. Mi mitꞌar tꞌöhö bi da̱ har hñu nto̱ngu. Ha bi nju̱tsꞌi, xki du. ");
INSERT INTO otqNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nuꞌmú̱ ar Pablo bi göi, bi ꞌyoxa nöꞌö ar bötsi ne bi hyu̱fi. Ne bi ꞌñembabi ya ku: —Yo gi ntsuhu̱, tetho. ");
INSERT INTO otqNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bi bo̱xa manꞌagi habu̱ xki mhuntsꞌi. Bi heka ar thuhme, bi ziꞌu̱ ár tꞌoxi ar tsi Hmu bi ñuñꞌu̱. Mꞌe̱fa ar Pablo bi mengi bi ñö yaꞌö, ne mi nthe̱ngxudi bi gu̱r ꞌñu bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ha nu mi tsꞌixa nöꞌö ar tsꞌu̱ntꞌu̱ xki da̱gi mi tetho, gatho ya ku xa bi hñu yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nuje da ju̱he ar motsa da ꞌbe̱tꞌohe, da möhe har hnini Nꞌason, ka nga nthe̱henu̱ ar Pablo ngu dá möñhe, ngetho mi neꞌö nda ma watho. ");
INSERT INTO otqNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nda nthe̱henu̱ Nꞌason, da tsixe har motsa ndi ehe, da möhe mahye̱gi har hnini Mitilene. ");
INSERT INTO otqNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Da po̱ñhenu̱, ne ár hyaxꞌö da tso̱ñhe getꞌu̱ har xe̱ni ha̱i Kio. Ár yopa da tso̱ñhe ha manꞌa xe̱ni ár thuhu Nsamo, ne da kohe habu̱ ár thuhu Trogilio. Ár hñupa da tso̱ñhe har hnini Mileto. ");
INSERT INTO otqNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ar Pablo xki beni hinge nda tho har hnini Efeso, ngetho himi ne nda mꞌu̱ nze̱ye̱ ya pa har ha̱i Asia. Mi xo̱ni nda zo̱nga har hnini Herusalen, ma nda mꞌu̱ har da̱ngo Pentekoste, nuꞌmu̱ nda za̱mhö nda zo̱ni. ");
INSERT INTO otqNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nu mi ꞌbu̱hnu̱ Mileto, ar Pablo bi me̱mpa ar nze̱ngwa yá ndö ar nijö Efeso, bi ꞌñembi mi to̱ꞌmnu̱ Mileto. ");
INSERT INTO otqNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nu mi zo̱ñꞌu̱ habu̱ mi ꞌbu̱ ar Pablo, bi ꞌñembabiꞌu̱: —Nuꞌahu̱ gi pöhu̱ xiñho tengu ma mꞌu̱i núꞌmu̱ ndi ꞌbu̱hwihu̱ nuya pa xi thogi, nda tso̱kwa har ha̱i Asia. ");
INSERT INTO otqNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Xta pe̱pa ma tsi Hmuhu̱, hinxta ñꞌetsꞌi. Xta nöꞌma ma gida̱, xta tho ya tsꞌomꞌu̱i nuꞌu̱ xi ꞌyo̱tka ya xodyo, huꞌskathogi da hyogagiꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mödi njapꞌu̱, hinte xta ögi nöꞌö gi hoñhu̱ da jaꞌahu̱ ar ñho. Gatho xta utꞌahu̱ ha ya mhuntsꞌi wa ha ri nguhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nuꞌahu̱ gar xodyohu̱ ne nuꞌu̱ hingya xodyohu̱, xta zoꞌahu̱ gi ehu̱ hár nthandi Jö gi ꞌyo̱thwu̱ ár ntso̱ꞌmi, ne gi ñꞌemu̱ihu̱ ma tsi Hmuhu̱ Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ha nupya tsixka ár Hñö Jö gar ma Herusalen, mödi hindi pödi teme bi to̱bgaginu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ho̱nse̱ di pödi xi xikagi ár Hñö Jö ha gatho ya hnini di thogi, bi to̱bgagi ar fa̱di ne ya thogi. ");
INSERT INTO otqNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ha nuyu̱, hindi japamasu, ne hindi japa ma te da me̱pkase̱. Nöꞌö di nega, ga johya ga jwata nunar ꞌbe̱fi bi ꞌraka ar tsi Hmu Hesu. Nor ꞌbe̱fiꞌö, ga mömba ár hoga mhö no̱nga teme xi hwëgagihu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ha di pöpya xiñho, nuꞌahu̱ xtá thopꞌu̱ xta xiꞌahu̱ ár tsꞌutꞌwi Jö, hingi ma gi penju̱ gi hyandagihu̱ manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jange di xiꞌahu̱, hingo ꞌba̱ ma ñöni núꞌmu̱ gi mꞌe̱hu̱pya. ");
INSERT INTO otqNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ngetho nuga hinte xta ögi. Gatho nöꞌö xi utka Jö, xta utꞌahu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Di xiꞌahu̱, ntsuñhu̱, ne suhu̱ gatho ya gamfi xi ꞌye̱ntꞌahu̱ ri ꞌye̱hu̱ ár Hñö Jö, ngu nꞌar ma̱ꞌyo su yá tsi de̱ti. Gese̱ꞌö xi ꞌñexꞌahu̱ gi sufu̱ ár nijö ar tsi Hmu xi unga ár ji xi da̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nuga di pödi nꞌehe, nu xka magawa, ma da epꞌu̱ ꞌra ya tsꞌojöꞌi, da ne da hwatwa gatho ár nijö Jö, ngu nꞌar miñꞌo hinte ma de̱ti e̱gi. ");
INSERT INTO otqNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hinge ho̱nse̱ꞌu̱, ꞌra da bo̱nga madeda ri mhuntsꞌihu̱, ma gi möñhu̱ ꞌra ya ntꞌuti hinga majöni, ne gi ꞌweju̱ ya ku gi tsixu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jange ntsuñhu̱, ne beñhu̱ nuꞌu̱ hñu nje̱ye̱ parxui hinge ndi tsa̱ya̱ ndi nöꞌma ma gida̱, xa ndi hupꞌa ri mu̱ihu̱ nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nupya tsi kuhu̱, di te̱tꞌahu̱ Jö ne ár mhö mönga teme xi hwëkꞌahu̱. Gehnu̱ pe̱ꞌsa ar tsꞌe̱di da ze̱tꞌa ri jamfihu̱, ne gi hñöñhu̱ gatho nöꞌö xi ñhötꞌwa nuꞌu̱ xi tꞌaxka yá mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nuga hinto xta hyo̱kwabi ár bojö wa ár he. ");
INSERT INTO otqNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ngetho nuga ngu gi pöse̱hu̱, nuya ꞌye̱yu̱ xi ma̱xkagi xta mpe̱fi xta tö nöꞌö ndi honse̱ ne nöꞌö honga nuꞌu̱ di ñꞌoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Hyaxꞌmu̱ xta utꞌahu̱ ga mpe̱hu̱ njapꞌu̱, ne da tsa̱ ga fa̱xu̱ nuꞌu̱ hinte pe̱tsꞌi. Ne ga beñhu̱ nöꞌö bi mönga ar tsi Hmu Hesu, núꞌmu̱ bi ꞌñenö: Töte ár nza̱tho ga uñhu̱, hinge nöꞌö ga höñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nu mi wadi bi mönga njapꞌu̱ ar Pablo, bi nda̱ndihmöwi gatho ya ku, ne mahye̱gi bi ꞌya̱pa Jöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Gatho ya ku xa mi zoni, mi döta ár dumu̱iꞌu̱. Mi hu̱ ar Pablo ne mi tsu̱ꞌspa ár hmi. ");
INSERT INTO otqNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ngetho xa mi tu yá mu̱i mi ꞌyo̱xa nöꞌö bi mönga ar Pablo, hinge nda mengi nda hyandi. Bi ma ba exa har motsa, bi ñꞌehwi bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nu nda ñꞌehe ya ku, da ju̱he ar motsa da möhe njöntho har xe̱ni ha̱i ár thuhu Kos. Ár hyaxꞌöpꞌu̱ da tso̱ñhe manꞌar xe̱ni ha̱i ár thuhu Roda. Mꞌe̱fa da möhe har hnini ár thuhu Patara. ");
INSERT INTO otqNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Núnu̱ Patara da tiñhe nꞌar motsa ndi ma Fenisia, dá po̱xenu̱ ne da möhe. ");
INSERT INTO otqNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nu ndi pa̱he har dehe, da hanthe ha ma ngöhöhe ar xe̱ni ha̱i Txipre. Da thothe da möhe har ha̱i Nsiria, ngetho nöꞌö ar motsa ka ma nda zohnu̱ nöꞌö te mi hö har hnini Tiro ꞌbu̱ har ñönthe, ne ka da kohenu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ma da tsu̱henu̱ ya ku, ne da ꞌbu̱hwihenu̱ yoto mpa. Nuya ku xki nzinga ár Hñö Jö mi xipabi ar Pablo hinge nda ma Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mi wa ya yoto mpa, bi de̱ngagihe gatho ya gamfi, yá ꞌbe̱hñö ne yá bötsi. Da po̱ñhe har hnini ma ba tsogagihe har motsa, ne ka da nda̱ndihmöhenu̱ har ñönthe da a̱pabihe Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nu nda ehe ya ku, da ñhu̱he nꞌa ngu nꞌa, ne da po̱xe har motsa, ha nuꞌu̱ bi mengi bi ma yá ngu. ");
INSERT INTO otqNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Núnu̱ Tiro bi göxa ar ꞌñu ndi ꞌyohe har dehe, ne da möhe har hnini Tolemaida. Da ze̱ngwahe ya ku, ne da kohwihenu̱ nꞌa pa. ");
INSERT INTO otqNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ár hyaxꞌö ar Pablo ne nuꞌu̱ ndi ñꞌohe, da po̱ñhe da möhe har hnini Nsesarea. Ne da haxe hár ngu ar Lipe nöꞌö mi mömba ár mhö Jö, mi nꞌa nuꞌu̱ yoto ya ma̱xte xki thahna har nijö Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ar Lipe mi ꞌñe goho yá tꞌinxu himi nthöti, ne mi möñꞌu̱ nöꞌö mi xipa ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Da ꞌbu̱henu̱ ꞌra ya pa, ne bi zo̱hnu̱ nꞌár mꞌe̱hni Jö xki ꞌñe Nhudea, már thuhu Agabo. ");
INSERT INTO otqNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ba e bi kꞌöskagihe, bi hñömba ár bötꞌi ar Pablo, ne bi dutꞌa yá ꞌye̱ ne yá wa, ne bi ꞌñenö: —Ár Hñö Jö mö ma da dutꞌa njawa ya xodyo ꞌbu̱ Herusalen nöꞌö togo ár me̱ti nuna ar bötꞌinu̱, ne da da̱twa ha yá ꞌye̱ nuꞌu̱ ya jöꞌi hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nda o̱he njapꞌu̱, nuya ku ma ya mengunu̱ ne nuje, da tsa̱hmöhe nga hökwe hinge nda ma Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ha nunar Pablo bi ꞌñenö: —Yoꞌö gi zoñhu̱ ne gi tso̱tju̱ ma mu̱i. Nuga hinge ho̱nse̱ di ꞌbu̱i da nso̱tkaginu̱ Herusalen, di ꞌbu̱i ga unga ma te di ñömba ár thuhu ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nda nuhe hinge nda tsa̱ nga hökwabihe hinge nda manu̱. Hinte da xife, ho̱nse̱ da eñhe: —Da ꞌyo̱tꞌa ngu ne ar tsi Dada. ");
INSERT INTO otqNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mꞌe̱fa nu mi tho nuya paꞌu̱, da ñhoje da möhe Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ba te̱ngagihe ꞌra ya ku mi ꞌbu̱hnu̱ Nsesarea, nꞌa már thuhu Naso me Txipre. Mi pe̱ꞌsa nze̱ye̱ ya je̱ye̱ xki ñꞌemu̱i ar tsi Hmu Hesu. Gehnu̱ bi ꞌrakagihe ar se̱ki hár ngunu̱ Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Núꞌmu̱ nda tso̱ñhe Herusalen, ya ku xa bi njohya bi ze̱ngwagihe. ");
INSERT INTO otqNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ár hyaxꞌö da me̱ꞌbehe ar Pablo ma da kꞌöse ar Hakobo, ne ka xki mhushnu̱ gatho ya ku ma ya ndö har nijö. ");
INSERT INTO otqNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ar Pablo bi ze̱ngwaꞌu̱, ne bi metwabi gatho nöꞌö xki ꞌyo̱tꞌa Jö hár ꞌbe̱fi xki tꞌumbabi, nda hñöꞌspa ár mhö nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nu mi ꞌyo̱ꞌu̱ njapꞌu̱, bi nsundabi Jö, ne bi ꞌñemba ar Pablo: —Tsi ku, gi pödi hangu ár nze̱ye̱ ya xodyo xi jamfibi ár mhö ar tsi Hmu Hesu, ne xa umba yá mu̱iyu̱ te̱mba yá ꞌbe̱pate ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Xi nsipabiꞌu̱ gi uta ya xodyo bi ꞌbu̱ ha maꞌra ya ha̱i, hinda de̱mba ár tꞌofo ar Moise. Enö gi hökwabi da hñuꞌspabi ar nse̱gi yá bötsi, ne hinda de̱nga ma ntꞌumbihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Xipya, te ga pe̱hu̱ ꞌmu̱. Ngetho nu xta böhyu̱ gi ꞌbu̱kwa, ma da mhuntsꞌa gathoꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jange di xiꞌahe gi ꞌyo̱tꞌa njawa: ꞌBu̱kwa goho ya ku ma da ꞌyo̱tꞌa nꞌar ñhötꞌi xi ñötꞌwa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tsitsꞌi me̱wi, ma gi nxu̱ju̱ ngu ma ntꞌumbihu̱, ne jutꞌi da ñꞌöxyu̱. Ne njapꞌu̱ da hyanda gatho ma mixodyohu̱ gi o̱tꞌa ngu mönga har tꞌofo, ne hinga majöni nöꞌö xi ꞌyo̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ha nuya gamfi hingya xodyo, xta xipabihe hinga mahyoni da ꞌyo̱tꞌa ngu ma ntꞌumbihu̱. Ho̱nse̱ mahyoni hinda zi ya ñhuni xi ñhötꞌwa ya tsita empꞌö, hinda zipa yá ji ya me̱ti, hinda za ya me̱ti hinxi po̱mba ár ji, ne hinda mꞌe̱ngwi manꞌa nöꞌö hingo ár nthöti. ");
INSERT INTO otqNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nuꞌmú̱ ár hyaxꞌöpꞌu̱, ar Pablo bi zixa nuꞌu̱ goho ya ñꞌo̱ho̱, ne mahye̱giwi bi nxu̱kꞌu̱ ngu yá ntꞌumbiꞌu̱. Mꞌe̱fa bi yu̱tꞌu̱ har dönganijö, ma ba mö hamꞌu̱ nda wa ya pa nda ntꞌaxki, ne hamꞌu̱ nda zo̱ ar pa nda unga yá mꞌo̱ñho̱ nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ne núꞌmu̱ ma nda wa nuꞌu̱ yoto mpa ntꞌaxki, ꞌra ya xodyo ya me Asia bi hyanda ar Pablo mi ꞌbu̱ har dönganijö, bi ꞌyu̱tꞌa ya jöꞌi bi mbo̱ yá kwe̱, ne bi gu̱ ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Xa mi maꞌu̱ ntsꞌe̱di mi eñꞌu̱: —Me Israelhu̱, fa̱xje. Go gehnu̱ ar ñꞌo̱ho̱ habu̱ gatho ꞌyo uta ya jöꞌi da ñömañꞌu̱ ma hninihu̱, ma ꞌbe̱patehu̱ ne ma nijöhu̱. Ne xi ku̱tꞌa ꞌra ya jöꞌi hingya xodyo, ho̱nse̱ tsꞌonga ma jöpa nijöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mi möñꞌu̱ njapꞌu̱, ngetho xki hyanda ar Pablo har hnini mi ñꞌowi ar Trofimo ar me Efeso, mi hu yá mu̱iꞌu̱ ar Pablo xki zixa har nijö. ");
INSERT INTO otqNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jange gatho ar hnini bi mu̱xmatho, ne xa mi maꞌu̱. Bi watꞌu̱ bi mi ar Pablo, ne bi gu̱tꞌi bi gu̱ka har nijö, ne dama bi njotꞌa ya goxthi. ");
INSERT INTO otqNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Mi ne nda hyoꞌu̱, ne bi nsipabi ar ndöndogu, gatho ar hnini Herusalen mi mu̱xmatho. ");
INSERT INTO otqNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nuꞌmú̱, bi musnu̱ gatho ya ndogu ne yá ndö, bi nixtꞌi bi ma habu̱ xki mhuntsꞌa ya jöꞌi. Nu mi hyantꞌu̱ mi epꞌu̱ ya ndogu ne yá ndö, bi hye̱pꞌu̱ ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mi zo̱nga ar ndöndogu, bi gu̱ ar Pablo, ne bi xipa togo nda xo̱tꞌa yoho ya nthöhibo̱jö, ne bi ñꞌa̱ni togoꞌö ne te xki ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ha nuya jöꞌi xa mi ñöxhnatho, nꞌañꞌo mi mönga nꞌa ngu nꞌa. Hinte bi zo ár mfeni ar ndöndogu, jange bi beni mar ñho nda zixa habu̱ mi ꞌbu̱ ya ndogu. ");
INSERT INTO otqNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nu mi zo̱nga ha ya ꞌrendo ár goxthi yá nguꞌu̱, ya ndogu bi gu̱xta ar Pablo, ngetho ya jöꞌi xa mi ne nda netꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ya jöꞌi mi ꞌbe̱fa xa mi mafi mi eñꞌu̱: —Dá du nöꞌö ar ñꞌo̱ho̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Núꞌmu̱ ma nda tꞌetꞌa habu̱ mi ku̱ ya ndogu, ar Pablo bi ꞌñemba yá ndöꞌu̱: —Ha da tsa̱ ga ñö nꞌa tsi tu̱i. Bi döhnu̱ ne bi ꞌñenö: —Atho gi ñö ar griego. ");
INSERT INTO otqNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Hinga geꞌe nöꞌö ar me Ehipto bi gu̱xa ya jöꞌi nda ntuhni pe̱ꞌsa ꞌra ya pa, ne bi zixa ha ya otꞌatꞌo̱ho̱ nuꞌu̱ yonꞌa̱tenthebe ya hyote. ");
INSERT INTO otqNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ar Pablo bi dödi ne bi ꞌñenö: —Hinꞌö. Nuga dar xodyo me Tarso nꞌar döta hnini har ha̱i Nsilisia. Di a̱ꞌar möte gi ꞌraka ar se̱ki ga zo nuya jöꞌiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ar Pablo mi tꞌumba ar se̱ki nda ñö, bi mꞌa̱ ha ya ꞌrendo ne bi jár ꞌye̱ bi xipya jöꞌi nda ñhe. Núꞌmu̱ hinto mi ñö, bi ndu̱i bi ñö ebreo, ne bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Ha gi o̱hu̱ ndadahu̱ di nkuhu̱, ne nuꞌahu̱ tatahu̱. ꞌYo̱hu̱ ma ga xiꞌahu̱ nöꞌö xta o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nuya jöꞌi mi ꞌyo̱ ar Pablo mi ñö ar hñö ebreo, gatho dama bi ñhetho. Nuꞌmú̱ ar Pablo bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Nuga dar xodyo, da mꞌu̱ har hnini Tarso har ha̱i Nsilisia, da tewa Herusalen. Bi utkagi ar utate ár thuhu ar Gamalie. Bi tꞌutkagi xiñho teme di bo̱nga ar tꞌofo bi zogagihu̱ ma palehu̱. Ne xa ndi umba ma mu̱i ndi ne nga pe̱pa Jö, ngu gi o̱thu̱ gathoꞌihu̱ ar pania. ");
INSERT INTO otqNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nuga nꞌehe da u̱tsa nuꞌu̱ togo mi te̱nga nunar ꞌÑunu̱, ndi nehmö nga ho. Ndi ju̱ nda njotꞌa har fa̱di, hinge ndi jamasu ha ma ya ndo̱ wa ma ya ꞌbe̱hñö. ");
INSERT INTO otqNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nunar döngamöjö ne gatho ya dönziandö, da tsa̱ da da̱majöni bi ꞌraka ya he̱ꞌmi nga höꞌspa ma kuhu̱. Ne da ma Ndamasko, ma nga ju̱ nuꞌu̱ mi te̱nga nunar ꞌÑunu̱, ne nga tsi Herusalen nda mfe̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Núꞌmu̱ ndi ne ar ꞌñu txꞌu̱tho mi ꞌbe̱di nga ku̱tꞌa Ndamasko, ngu made mpa, nꞌa nda tha̱ni bi gobgatho nꞌa ra döta hyatsꞌi ba e mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Da hwangi, ne da o̱ nꞌar mhö mi enö: Saulo, Saulo, yoꞌö gi u̱tsagi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nuga da thöti ne da embabi: Ndada, togoꞌi. Nöꞌö bi dötkagi: Nuga dar Hesu me Nasare, togo gi u̱tsa. ");
INSERT INTO otqNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nuꞌu̱ ndi ñꞌoꞌbe bi hyanda ar hyatsꞌi, ne xa bi ntsu, mödi himbi ꞌyo̱ꞌu̱ nöꞌö ar mhö mi zokagi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nuga da a̱ni ne da embabi: Ma tsi Hmuꞌi, tema gi ne ga pe̱pya. Nöꞌö bi ꞌñengagi: Nangi di ma Ndamasko, ka gehnu̱ ma da nsiꞌaꞌi gatho nöꞌö xta beni gi pe̱fi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nunar hyatsꞌiꞌö xa mi ntsꞌe̱di, jange da ngoda̱, ne nuꞌu̱ ndi ñꞌoꞌbe bi gu̱nkagi bi zixka Ndamasko. ");
INSERT INTO otqNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nuꞌmú̱ nꞌar ñꞌo̱ho̱ már thuhu Anania, xa mi o̱tꞌa xiñho mi te̱mba yá ꞌbe̱pate ar Moise, ne gatho ya xodyo mi ꞌbu̱hnu̱ xa mi ñömañhobi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Bi ma ba kꞌöskagi, ne mi zo̱nga habu̱ ndi ꞌbu̱i, bi ꞌñengagi: Ma tsi ku Saulo, hñönga ri nthandi. Ne bi tsa̱ da handa togo mi kꞌöskagi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nepꞌu̱ bi ꞌñengagi: Jö togo mi ndönga ma palehu̱, xi hwañꞌaꞌi ngi pö teme beni da ꞌyo̱tꞌe, ne gi hyandwa ár tsꞌe̱di, ne gi ꞌyo̱ꞌspa ár mhö Nöꞌö Togo ar Hogajöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ngetho ma da me̱ñꞌaꞌi gi da̱twa majöni gatho ya jöꞌi nöꞌö xka hyandi ne xka ꞌyo̱de. ");
INSERT INTO otqNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nuꞌmú̱, tema gi to̱ꞌmi. Nangi, möhö ma gi nxixthe, ne gi xu̱ka ri tsꞌoki, gi matꞌwa ár thuhu ar tsi Hmu. ");
INSERT INTO otqNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Nepꞌu̱ da penga Herusalen, nda tso̱ho̱ da ku̱tꞌa har dönganijö ma nga ndönga Jö, nꞌa nda handatho nꞌa ngur tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Da handa ar tsi Hmu, mi engagi: Ngutꞌa po̱ngwa Herusalen, ngetho nuya jöꞌi ꞌbu̱kwa, hinda ma da ñꞌemu̱i nöꞌö ma gi da̱twa majöni gi no̱ngagi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ha nuga da embabi: Ma tsi Hmuꞌi, pöꞌu̱ xiñho ndi ku̱tꞌa ha yá nijö, ndi ju̱ nga etꞌa ar fa̱di ne ndi fe̱ nuꞌu̱ togo mi ñꞌemu̱iꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Núꞌmu̱ mi nhöꞌmba ár ji ar Teba togo mi da̱majöniꞌi, ka ndi ꞌbu̱hnu̱ nꞌehe. Hinda hökwa nuꞌu̱ mi kꞌahni, nuga go da supa yá dutu ya hyote. ");
INSERT INTO otqNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ha nunar tsi Hmu bi ꞌñengagi: Di ma, di pe̱ñꞌaꞌi ma gi zo nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nu mi mönga njapꞌu̱ ar Pablo, ya jöꞌi himbi ne bi ꞌyo̱tsꞌe. Bi ndu̱i bi ñöxhnatho, ne mi eñꞌu̱: —Hñökwa ár te nunar ñꞌo̱ho̱nu̱, ngetho hindi ꞌñepi di tetho. ");
INSERT INTO otqNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Xa mi he̱xa ya mhafi, mi fo̱ta yá dutu ne mi pönsa ya ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nuꞌmú̱ ar ndöndogu bi mö nda thoka ar Pablo mbo ha yá nguꞌu̱ nda mfe̱i, ne njapꞌu̱ nda mö tema xki ꞌyo̱tꞌe, hanja ya jöꞌi xa xki mbo̱ yá kwe̱. ");
INSERT INTO otqNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Núꞌmu̱ mi nso̱tꞌe nda mfe̱i, ar Pablo bi ꞌñemba nꞌar döndogu mi ꞌba̱hnu̱: —Hage da tsa̱ gi fe̱hu̱ nꞌar ñꞌo̱ho̱ me Nroma, hingi pöhu̱ wa xi ꞌyo̱tꞌa nꞌar tsꞌoki wa hinꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nu mi ꞌyo̱ njapꞌu̱ ar döndogu, dama ba xipa ár ndöpꞌu̱ nꞌehe, ne bi ꞌñembabi: —Te ma gi japa nunar ñꞌo̱ho̱nu̱, ngetho ar me Nroma. ");
INSERT INTO otqNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nuꞌmú̱ ar ndöndogu bi ma ba kꞌöꞌsa ar Pablo ne bi ꞌya̱mbabi: —Hage gar me Nroma. Ar Pablo bi dödi: —Hö, majöni. ");
INSERT INTO otqNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nuꞌmú̱ nunu̱ bi ꞌñembabi: —Nuga da jutꞌa nze̱ye̱ ar bojö, njapꞌu̱ bi tꞌexkagi ngu ar me Nroma. Ar Pablo bi ꞌñenö: —Ha nuga dar mengunu̱ nda mꞌu̱tho. ");
INSERT INTO otqNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nu mi ꞌyo̱ njapꞌu̱ nuꞌu̱ ma nda hyu̱xtꞌi, dama bi zopꞌu̱. Gese̱ ar ndöndogu bi zu nꞌehe núꞌmu̱ mi bödi mar me Nroma, ngetho xki ꞌbe̱pa yá ma̱xte nda xo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ár hyaxꞌöpꞌu̱ ar ndöndogu mi ne nda bödi tema xki ꞌyo̱tꞌe, bi mö nda thökwa ya bo̱jö xki so̱tꞌe. Ne bi zohna ya ndömöjö ne gatho yá ndö ya xodyo, bi ꞌyo̱tꞌa nꞌar mhuntsꞌi, ne bi gu̱kwa ar Pablo habu̱ mi ꞌbu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Nuꞌmú̱ ar Pablo bi kꞌötꞌa yá ndö ya xodyo, ne bi ꞌñembabi: —Ma tsi kuhu̱, nuga gatho ya pa xta ꞌbu̱i hinte xta tsa̱mañꞌu̱ hár nthandi Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Geꞌmú̱ ar Anania togo mar döngamöjö, bi ꞌbe̱pa nuꞌu̱ mi ꞌba̱ getꞌu̱ habu̱ mi ꞌba̱ ar Pablo nda me̱tꞌwa ár ne. ");
INSERT INTO otqNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nuꞌmú̱ ar Pablo bi ꞌñembabi: —Jö ma da ꞌraꞌa ri mfe̱i, nemhñö jöꞌi. Xka hñupꞌu̱ gi hñöska majöni ngu huxa har tꞌofo bi ꞌyotꞌa ar Moise. Hanja gi tsꞌoka nunar tꞌofo ꞌmu̱, xka ꞌbe̱pa togo xi me̱bgagi. ");
INSERT INTO otqNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nu maꞌra ya jöꞌi mi ꞌbu̱hnu̱ bi ꞌñembabi: —Hage njapꞌu̱ gi thöta ar döngamöjö pe̱pa Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Nuꞌmú̱ ar Pablo bi dödi: —Tsi kuhu̱, nuga hinge ndi pödi ha go mi gehnu̱ ar döngamöjö, ngetho xi tꞌotꞌa njawa: Yo ma gi tsanga nꞌár ndö ri hnini. ");
INSERT INTO otqNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ar Pablo mi nu mi ꞌbu̱hnu̱ made ya de̱ngamöjö ne made ya de̱ngaꞌbe̱pate, bi ñö ntsꞌe̱di ne bi ꞌñenö: —Ma kuhu̱, nuga dar de̱ngaꞌbe̱pate ngu gatho ma pale nꞌehe. Xi mꞌa̱bgagiwa hár nthandi ya ndö, ngetho di jamfi da mengi da nte nuꞌu̱ xi du. ");
INSERT INTO otqNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nu mi mönga njapꞌu̱ ar Pablo, ya de̱ngaꞌbe̱pate ne ya de̱ngamöjö bi ndu̱i bi ntsa̱hñöki nꞌa ngu nꞌa, ne njapꞌu̱ bi ñhe ar mhuntsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ngetho nuya de̱ngamöjö eñꞌu̱, nuꞌu̱ togo xi du, hinda mengi da nte, ne hingi ñꞌemu̱iꞌu̱ ꞌbu̱ ya e̱nxe̱, hingi ꞌbu̱ yá pa ya jöꞌi ꞌnö. Ha nuya de̱ngaꞌbe̱pate hö, eñꞌu̱ da mengi da nte nꞌa, ꞌbu̱ ya e̱nxe̱, ne ꞌbu̱ yá pa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ne gatho xa mi ñöxhnatho. Nꞌa mbi mꞌa̱ ꞌra ya bötꞌofo ma ya de̱ngaꞌbe̱pate, ne bi ꞌñeñꞌu̱: —Nunar ñꞌo̱ho̱nu̱ hinte ma tsꞌoki di timfe. Nuꞌmu̱ xi zo nꞌár pa nꞌar jöꞌi, wa nꞌar e̱nxe̱, ma ga o̱thu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Xa bi ga̱hni ar tuhni. Jange ar ndöndogu, mi tsu nda nxe̱nga ar Pablo, bi zohna yá ndogu nda e nda zixnu̱ nda ꞌñetꞌa habu̱ mi ꞌbu̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nu mi nxui ar tsi Hmu bi zo ar Pablo ne bi ꞌñembabi: —Pablo, yo gi tu ri mu̱i, ngetho ngu xka da̱tka majöniwa Herusalen, njapꞌu̱ ma gi da̱tka majöninu̱ Nroma nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ár hyaxꞌö ꞌra ya xodyo bi mhuntsꞌi nda hyonga hanja nda hyo ar Pablo. Bi ꞌñetꞌu̱ made Jö hinte nda ziꞌu̱, mꞌe̱tꞌo nda ꞌyo̱tꞌa nöꞌö xki beñꞌu̱. Nuꞌmu̱ hinꞌö, ndá zu̱twa ár mfe̱i Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mi tho yonꞌa̱te nuya ñꞌo̱ho̱ mi mönga njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nuya ñꞌo̱ho̱yu̱ bi ma ba kꞌöꞌsa ya ndömöjö ne ya dönziandö, bi ꞌñeñꞌu̱: —Nuje xta ethe made Jö hinte ga tsihe, mꞌe̱tꞌo ga hohe ar Pablo. Nuꞌmu̱ hinꞌö, dá zu̱je ár mfe̱i Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jange nuꞌahu̱ ne gatho ya ndö, ꞌya̱fu̱ ar ndöndogu da tsiñꞌahu̱ xudi ha ri mhuntsꞌihu̱. Gi ꞌñemfu̱ gi ne gi pöhu̱ xiñho nöꞌö te xi ꞌyo̱tꞌe. Ne nuje ma ga ta̱je har ꞌñu ga hohe, hinga he̱he da zo̱kwa. ");
INSERT INTO otqNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bi ꞌyo̱ nꞌár tꞌu̱ ár nju ar Pablo nöꞌö xki tꞌe̱kwabi. Ngutꞌa bi ma ba kꞌöꞌsa ha yá ngu ya ndogu ne bi xipabi. ");
INSERT INTO otqNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Nuꞌmú̱ ar Pablo bi zohna nꞌar döndogu, ne bi ꞌñembabi: —Tsiꞌspa ri ndö nunar tsꞌu̱ntꞌu̱nu̱, ngetho ne da xipa ꞌra ya mhö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nunar döndogunu̱ bi zixa habu̱ mi ꞌbu̱ ár ndö, ne bi ꞌñenö: —Nöꞌö ar ꞌyofa̱di ár thuhu Pablo, bi ꞌya̱ka ar möte nga tsiñꞌa nunar tsꞌu̱ntꞌu̱nu̱, ngetho höñꞌa nꞌar mhö ꞌnö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nöꞌö ar ndöndogu bi mipa ár ꞌye̱ ar bötsi, ne bi zixa habu̱ bi ꞌya̱mbase̱: —Tema gi ne gi xikagi. ");
INSERT INTO otqNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ar tsꞌu̱ntꞌu̱ bi ꞌñembabi: —Ya xodyo xi ꞌyo̱tꞌa nꞌar nkohi, ma da e da ꞌya̱ꞌa ar möte gi tsiꞌspa ar Pablo xudi ha yá mhuntsꞌandö, ngetho eñꞌu̱ ne da bödi xiñho tema xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Yo ma gi ꞌyo̱te, ngetho ngu yonꞌa̱te ya ñꞌo̱ho̱ ma da ꞌñöthó. Xi ꞌñetꞌa made Jö hinte ma da ziꞌu̱, mꞌe̱tꞌo da hyo ar Pablo. Nuꞌmu̱ hinꞌö, dá zu̱twa ár mfe̱i Jö. Ho̱ntꞌa to̱ꞌmatho tema gi mönge. ");
INSERT INTO otqNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ne ar ndöndogu bi ꞌñemba ar bötsi nda ma, ne hinto nda xipabi xki metwabi nöꞌö ma nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nöꞌö ar ndöndogu bi zohna yoho ya döndogu, bi ꞌbe̱pabi nda japi nda ñhoka yonthebe ya ndogu watho, ne ngu̱dmi ma nꞌa̱te ya to̱ge, ne ma yonthebe ya ndogu hö ya maza, nda maꞌu̱ har hnini Nsesarea ngu ar gu̱to nxui. ");
INSERT INTO otqNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ne bi ꞌya̱ ꞌra ya fani nda nto̱ ar Pablo, ne nda tsꞌiꞌspa ar ndö Feli. Bi ꞌbe̱pabi nda su xiñho, hinte nda njapabi. ");
INSERT INTO otqNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ne bi ꞌyotꞌa nꞌar he̱ꞌmi bi me̱mpa ar ndö Feli, mi enö njawa: ");
INSERT INTO otqNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Nuga dar Klaudio Lisia, di ze̱ngwaꞌi ma hoga ndöꞌi Feli. ");
INSERT INTO otqNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nunar ñꞌo̱ho̱nu̱ ár thuhu ar Pablo, bi gu̱ ya xodyo ꞌbu̱tho nda hyo. Ha nuga nda pödi mar me Nroma, da tsixa ma ndogu, ma da ñöni. ");
INSERT INTO otqNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ha ndi ne nga pödi tema mi ho̱xꞌu̱, jange da tsiꞌspa ha yá mhuntsꞌandö. ");
INSERT INTO otqNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Da pödi mi tho̱xa xki tsꞌokwa yá tꞌofose̱ꞌu̱, ha hinte xki ꞌyo̱tꞌe ndi ꞌñepi nda tho, hinge ndi ꞌñepi nda tꞌetꞌa har fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ha nuga bi nsikagi xki mhuntsꞌa ya xodyo mi öthó nda hyo. Jange ngutꞌa dá pe̱ñꞌaꞌi, ne da xipabi nuꞌu̱ yá nga̱xte, go da ga̱xꞌaꞌi nöꞌö teme ho̱tsꞌe. Di ne gi ꞌbu̱i xiñho. ");
INSERT INTO otqNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nepꞌu̱ nuya ndogu, ngu xki mꞌe̱pabi, bi zixa ar Pablo mi nxui har hnini Antipatri. ");
INSERT INTO otqNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ár hyaxꞌö nuya ndogu mi ꞌyotho bi menkꞌu̱ habu̱ mi ꞌbu̱ꞌu̱. Ho̱nse̱ nuya to̱ge bi zixa ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nu mi zo̱ñꞌu̱ Nsesarea, bi umba ar he̱ꞌmi xki mꞌe̱mpa ar ndö Feli, ne bi tꞌentꞌwa ha yá ꞌye̱ ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nu mi wadi bi ne ar he̱ꞌmi ar ndö Feli, bi ꞌya̱ni habu̱ mar mengu. Ne nu mi bödi mar me Nsilisia, ");
INSERT INTO otqNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","bi ꞌñembabi: —Ga o̱xꞌaꞌi nu xta ꞌñepꞌu̱ ri nga̱xte. Nepꞌu̱ bi ꞌbe̱pa togo nda su xiñho habu̱ mar nguhmö ar Erode. ");
INSERT INTO otqNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nu mi tho ku̱tꞌa mpa mi ꞌbu̱hnu̱ ar Pablo Nsesarea, bi zo̱nga ar döngamöjö már thuhu Anania, mi ñꞌowi ꞌra ya dönziandö, ne nꞌar ñꞌo̱ho̱ már thuhu Tertulo mi fa̱xa ya jöꞌi ha ya tsꞌu̱tꞌwi. Bi zo̱ñꞌu̱ ma nda hyo̱xhya nhemhñö ar Pablo hár nthandi ar Feli. ");
INSERT INTO otqNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nepꞌu̱ bi tsꞌohna ar Pablo, ne nu mi zo̱ habu̱ mi ꞌbu̱ꞌu̱, ar Tertulo bi mu̱di bi ñö te gatho mi ho̱tsꞌe, ne bi ꞌñemba ar Feli: —Di jamödihe, hoga ndö, ngetho xta pe̱ꞌse nꞌar hogamꞌu̱i, ne tꞌo̱tꞌa xiñho ar tsꞌu̱tꞌwi ha ma hninihe, xaka mbödi gi ndö. ");
INSERT INTO otqNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Hoga ndö Feli, di to̱pꞌahe gatho ya pa habu̱ gatho gi ma, ga ꞌraꞌahe njamödi nuya ñho xka ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Hindi ne ga hökꞌahe ri ꞌbe̱fi. Di a̱ꞌahe gi jar möte gi ꞌyo̱xkagihe nꞌa tsi tu̱i nöꞌö ma ga xiꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Xta tiñhe nunar ñꞌo̱ho̱nu̱, ñhe̱hwi nꞌar hñeni ꞌyo habu̱ gatho ꞌbu̱ ya xodyo u̱tꞌi. Di pöhe go gehnu̱ ár ñöxhmu ꞌra ya jöꞌi te̱nga nꞌar me Nasare. ");
INSERT INTO otqNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nunu̱ mi ne nda tsꞌoka ma dönganijöhe. Jange nuje da ju̱he ndi ne nga höꞌsfe majöni ngu mönga ma tꞌofohe. ");
INSERT INTO otqNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ha nunar ndöndogu ár thuhu Lisia, ba ehe bi zimgagihe nunar ñꞌo̱ho̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nepꞌu̱ bi ꞌñenö, nuꞌmu̱ togo mi ne nda nga̱xte, nda e nda ga̱xꞌaꞌi. Ne núꞌmu̱ xki hñöꞌspa majöni, ma gi pöse̱ ha majöni nöꞌö di xiꞌahe. ");
INSERT INTO otqNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Gatho nuya xodyo mi ꞌbu̱hnu̱, bi ꞌñeñꞌu̱ majöni nöꞌö mi mönga ar Tertulo. ");
INSERT INTO otqNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ar ndö Feli bi jár ꞌye̱ bi umba ar se̱ki ar Pablo nda ñö, jange nunu̱ bi ndu̱i bi ꞌñenö: —Di pödi pe̱ꞌsa nze̱ye̱ ya je̱ye̱ gar ndö ha nunar hnininu̱, hinga ntsu ga thöta nuya ma nga̱xte. ");
INSERT INTO otqNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Da tsa̱ gi ñꞌa̱ni ne gi pödi xiñho, ja pe̱ꞌsa ꞌre̱tꞌamayoho mpa xta tso̱nga Herusalen ma nga ndönga Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Hinto xi zu̱kagi di ntsa̱ꞌbe manꞌa. Hinxi tsꞌu̱kagi di u̱tꞌa ya jöꞌi har dönganijö, ha ya tꞌu̱lo nijö, wa har hnini. ");
INSERT INTO otqNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nuya jöꞌiyu̱ hinda tsa̱ da hñubga ma hmi nöꞌö te ho̱xkagi. ");
INSERT INTO otqNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nuga di da̱majöni di te̱nga nunar ꞌÑunu̱, ne njapꞌu̱ di pe̱pa Jö mi ndönga ma pale, mödi nuyu̱ enö nꞌar tsꞌontꞌuti. Di jamfi gatho nöꞌö xi mhönga hár tꞌofo ar Moise, ne gatho nöꞌö xi ꞌyotꞌa yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nuga di ndo̱ꞌmi ngu mi ndo̱mꞌu̱ nꞌehe, Jö ma da gu̱xa manꞌagi nuꞌu̱ xi du, ya hogajöꞌi ne ya tsꞌojöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Jange hyaxꞌmu̱ di umba ma mu̱i ga pe̱ꞌsa nꞌar hogamꞌu̱i, hinte ga tsa̱mañꞌu̱ hár nthandi Jö ne ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Mi tho ꞌra ya je̱ye̱ ndi ꞌyo yapꞌu̱, da pengi nga umba ma ñhötꞌi Jö, ne nga hömpa nꞌar mfa̱tsꞌi nuꞌu̱ ma mixodyoꞌbe hyoya. ");
INSERT INTO otqNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Go ndi o̱tꞌö har nijö núꞌmu̱ mi hyangagi ꞌra ya xodyo me Asia. Bi zu̱kagi ndi nxu̱ki ngu ma ntꞌumbihe, himbi tsꞌu̱kagi ndi u̱tꞌa nze̱ye̱ ya jöꞌi, ne himi mu̱xhyu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Go di ꞌbu̱kwaꞌu̱, da ga̱xꞌaꞌi nuꞌmu̱ pe̱ꞌsa tema da hyo̱xkagi. ");
INSERT INTO otqNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Dá mönga nuyu̱ ꞌbu̱kwa nuꞌmu̱ xi dimgagi nꞌar tsꞌoki núꞌmu̱ bi tsꞌixkagi hár mhuntsꞌi ya ndöxodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ho̱nse̱ nöꞌö da mönga ntsꞌe̱di ha yá mhuntsꞌi, núꞌmu̱ nda enö: Ngi zonkagihu̱ ngetho di jamfi da mengi da nte nuꞌu̱ xi du. ");
INSERT INTO otqNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Núꞌmu̱ mi wadi bi ꞌyo̱xa gatho ar ndö Feli, ngetho mi pöhnu̱ ár mꞌu̱i nuꞌu̱ togo mi te̱mba ár ꞌÑu ar tsi Hmu, bi ꞌye̱ntꞌa manꞌar pa, ne bi ꞌñembabiꞌu̱: —Nu xta zo̱ ar ndöndogu Lisia, ka ga o̱thu̱ nꞌar ñhandi, ne ga pö xiñho nöꞌö gi xikagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ne bi ꞌbe̱pa nꞌar döndogu nda su xiñho ar Pablo, nda the̱tsꞌu̱ nda bo̱ni, ne nda tꞌumba ar se̱ki nuꞌu̱ togo mi ne nda kꞌötsꞌi nda hñöꞌspa te mi honi. ");
INSERT INTO otqNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mi tho ꞌra ya pa, ba e ar ndö Feli, mi ñꞌowi ár ꞌbe̱hñö ár thuhu Drusila mar xodyo. Bi ꞌbe̱pa togo nda zixa ar Pablo, bi ꞌyo̱xa ár jamfi ꞌbe̱ꞌspabi ar tsi Hmu Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ha núꞌmu̱ mi ndu̱ ar Pablo bi mönga nöꞌö xiñho ga o̱thu̱, ne ga ntsuñhu̱ hinga o̱thu̱ ya tsꞌoki, ne Jö ma da hñöxa majöni ar ngötsꞌi, nuꞌmú̱ ar Feli bi zu, ne bi ꞌñembabi: —Di za̱ nöꞌö xka xikagi. Nu xta bongagi, ga zoñꞌaꞌi manꞌagi. ");
INSERT INTO otqNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ar ndö Feli mi to̱ꞌmi nda umbar bojö nda hye̱gi, jange himi tsa̱ya̱ mi zohni nda ñöwi. ");
INSERT INTO otqNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Mi wa yo nje̱ye̱ bi bo̱nga ar Feli ngu ar ndö, ne bi go ar Porsio Festo ngúr mponi. Ar Feli mi ne nda gohwi xiñho ya xodyo, jange himbi hye̱ ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ar Festo bi zo̱nu̱ Nsesarea, bi bo̱xa ngur ndönu̱. Nepꞌu̱ ár hñupa bi ma ba tso̱nga Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nunu̱ ya ndömöjö ne maꞌra ya ndöxodyo, bi ma ba kꞌötsꞌi nda ga̱xa nöꞌö xki ꞌyo̱tꞌa ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bi ꞌya̱pa ar möte nda tsꞌi Herusalen, mi beñꞌu̱ nda ꞌñöthó ne nda da̱ki nda hyo. ");
INSERT INTO otqNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nunar Festo bi ꞌñembabiꞌu̱ bi jotꞌa ar Pablo har fa̱di Nsesarea, ha nöꞌö ngutꞌa ma nda menga injanu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bi ꞌñembabiꞌu̱: —Nuꞌmu̱ togo tsa̱ da ma, möhö, ne nuꞌmu̱ ja te gi hyo̱xu̱, ka gi nga̱xtehu̱nu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ar Festo bi mꞌu̱hnu̱ Herusalen ho̱nse̱ ngu ma hñöto wa ꞌre̱tꞌa mpa, ne bi menga Nsesarea. Ár hyaxꞌöpꞌu̱ bi hñu habu̱ mi o̱tꞌa ar tsꞌu̱tꞌwi, ne bi ꞌbe̱pa togo nda tsi ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nu mi yu̱tꞌa ar Pablo, nuya xodyo xki ꞌñe Herusalen xa bi gotꞌatho, ne te gatho mi ho̱xꞌu̱, mödi hinte mi tsa̱ nda hñuꞌmbár hmi. ");
INSERT INTO otqNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Nu ar Pablo bi dödi ne bi ꞌñenö: —Nuga hinto xta tsꞌokwabi. Hinxta tsꞌokwa ár tꞌofo ya xodyo, ma dönganijöhe, wa ar Sesar ma ndöhu̱ Nroma. ");
INSERT INTO otqNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ha nunar Festo mi ne nda gohwi xiñho ya xodyo, jange bi ꞌya̱mba ar Pablo ne bi ꞌñembabi: —Ha gi ne ga möhö Herusalen ga o̱tꞌa ar tsꞌu̱tꞌwinu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nuꞌmú̱ ar Pablo bi dödi njawa: —Di ꞌbu̱kwa har tsꞌu̱tꞌwi ya me Nroma, ka di ꞌñepki ga ñhantꞌbewa ma nga̱xte nuꞌu̱ togo ho̱xkagi. Ngu gi pöke xiñho, hinte ma tsꞌoki xta o̱tꞌwa ma mixodyoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nuꞌmu̱ xta o̱tꞌa nꞌar döta tsꞌoki ne di ꞌñepkagi da thogi, hindi o̱tꞌa ma ꞌñöngi. Ha nuꞌmu̱ hinge majöni nuꞌu̱ tho̱xkagi, hinto pe̱ꞌsa ar se̱ki da tꞌe̱ntkagi ha yá ꞌye̱ ya xodyo. Jange nuga di a̱di ma ga da̱majöninu̱ Nroma hár nthandi ar ndö Sesar. ");
INSERT INTO otqNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nuꞌmú̱ ar Festo bi ñöwi yá ma̱xte, nepꞌu̱ bi ꞌñembabi ar Pablo: —Nuꞌge xka ꞌya̱di ma gi da̱twa majöni ar ndö Sesar. Jange nupya, dá njapꞌu̱ ngu xka mönse̱. ");
INSERT INTO otqNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Bi tho ꞌra ya pa, ne bi zo̱hnu̱ Nsesarea ar ndö Agripa ne ár ꞌbe̱hñö ár thuhu Berenise, bá e bi ze̱ngwaꞌu̱ ar ndö Festo. ");
INSERT INTO otqNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bi mꞌu̱hnu̱ nze̱ye̱ ya pa, jange ar Festo bi metwabi ár thogi ar Pablo, ne bi ꞌñembabi: —Nuwa har fa̱di ꞌbu̱kwa nꞌar ñꞌo̱ho̱ bi zo ar Feli. ");
INSERT INTO otqNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nda ꞌbu̱hnu̱ Herusalen bá kꞌöskagi ya ndömöjö ne yá dönziandö ya xodyo, mi ho̱xa ar Pablo ꞌra ya tsꞌoki, ne mi a̱di nga e̱ntꞌi nda tho. ");
INSERT INTO otqNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ha nuga da xipabiꞌu̱ ar tsꞌu̱tꞌwi Nroma hinxi nzöi ho ya jöꞌi nꞌagitho. Mꞌe̱tꞌo da ñhandwi yá nga̱xte da hñuꞌmba yá hmi. ");
INSERT INTO otqNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Jange ngu mi zo̱kwaꞌu̱, ár hyaxꞌöpꞌu̱ nꞌagitho da huxa ha ma tsꞌu̱tꞌwi, ne da ꞌbe̱pa togo nda tsinka nöꞌö ar ñꞌo̱ho̱ꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ka mi ꞌbu̱hnu̱ gatho nuꞌu̱ mi ho̱tsꞌe, mödi hinte bi hyo̱xꞌu̱ ngu nuya ndi benga. ");
INSERT INTO otqNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ho̱nse̱ mi ho̱xꞌu̱ tema mi jamfiꞌu̱, ne mi no̱ñꞌu̱ nꞌar ñꞌo̱ho̱ már thuhu ar Hesu xki du, ha nunar Pablo mi mö mi tetho. ");
INSERT INTO otqNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ha nuga hinte ndi pödi te nga thöti, jange da emba ar Pablo, hage mi ne nda ma Herusalen nda tꞌo̱tꞌwa ar tsꞌu̱tꞌwinu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ha nöꞌö bi ꞌya̱di nda hñöꞌspa majöni ar döngandö Augusto. Jange da ꞌbe̱pa togo da su xiñho ne ga pe̱mpabinu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Nuꞌmú̱ ar ndö Agripa bi ꞌñembabi ar Festo: —Nuga nꞌe di ne ga o̱xa nöꞌö te mönga nöꞌö ar ñꞌo̱ho̱ꞌö. Ar Festo bi dödi: —Xudi gi ꞌyo̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Jange ár hyaxꞌö ar Agripa ne ar Berenise bi zo̱ho̱ ne bi yu̱tꞌu̱ xa xki ñhe nda ñꞌu yá nsu. Bi mhuskwi ya döngandogu, ne bi yu̱tꞌu̱ mahye̱gi maꞌra ya ndö har hnini. Ne ba tsꞌi ar Pablo ngu xki mönga ar Festo. ");
INSERT INTO otqNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ne ar Festo bi ꞌñenö: —Ndö Agripa, ne gatho nuꞌu̱ gi ꞌbu̱hu̱wa. ꞌBa̱kwa nunar ñꞌo̱ho̱nu̱, togo xi hyo̱xya xodyo núnu̱ Herusalen ne nuwa Nsesarea, ne hingi tsa̱ya̱ꞌu̱ mafi enö mahyoni da tho. ");
INSERT INTO otqNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ha nuga hinte ma tsꞌoki xta timbabi da tsa̱ da tho. Ne nunu̱ xi ꞌya̱se̱ da ma da da̱twa majöni ar ndö Augusto Sesar, jange xta e̱ntꞌi ga pe̱mpabi. ");
INSERT INTO otqNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nuga hinte di pe̱tsꞌi te ga xipa ar ndö Nroma. Jange xta tsiñꞌaꞌi, nuꞌge ndö Agripa, ne gatho nuya gi ꞌbu̱hu̱wa, xki jwahu̱ gi ñöwihu̱, ga pe̱tsꞌi tema ga otꞌwabi ma ndöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ngetho di enga, hingi ho ga pe̱mpa nꞌar ꞌyofa̱di ma ndöhu̱ Sesar, ne hinga xipabi tema tsꞌoki tho̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nepꞌu̱ ar ndö Agripa bi ꞌñembabi ar Pablo: —Di ꞌraꞌa ar se̱ki gi ñönga ri te. Nuꞌmú̱ ar Pablo bi gu̱xa ár ꞌye̱, ne bi ndu̱i bi ñhuꞌmba yá hmi hinte mi njapꞌu̱ nöꞌö bi tho̱tsꞌe, bi ꞌñenö: ");
INSERT INTO otqNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Hoga ndö Agripa, di johya ma ga ñhönse̱ ha ri nthandi, ne ga otꞌar ꞌñu te gatho ho̱xkagi ma mixodyoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Döta ma johya ngetho gi pötwa xiñho yá ntꞌumbi ya xodyo, ne tema thohnu̱. Jange nuga di a̱ꞌar möte gi pe̱ꞌska ar tsꞌe̱ti gi ꞌyo̱xa nöꞌö ma ga mö. ");
INSERT INTO otqNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Gatho ya xodyo pötka ma mꞌu̱i, di ndu̱ núꞌmu̱ ndi bötsi ndi ꞌbu̱ ha ma ha̱i, ne núꞌmu̱ nda e Herusalen. ");
INSERT INTO otqNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Go pöꞌu̱ nꞌehe, nuꞌmu̱ ne da mömhö, nda ndu̱i xta te̱mba yá ntꞌumbi ya de̱ngaꞌbe̱pate. Ngu gi pöse̱ go töte umba yá mu̱i o̱tꞌwa yá ꞌbe̱pate ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ha nupya, ngetho di pe̱ꞌsa nꞌa ndo̱ꞌmi ma da mengi da nte nuꞌu̱ xi du, ngu xi ñötꞌwa Jö ma palehe, xi ja̱xkagi ar tsꞌu̱tꞌwi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Gatho ma mixodyoꞌbe, yá ꞌbe̱togihe nuꞌu̱ ꞌre̱tꞌamayoho ya pale mi ꞌbu̱ mamꞌe̱tꞌo, to̱ꞌmi da hñönga ár ñhötꞌi Jö, jange parxui pe̱pabi. Ngu gi numhö, hoga ndö Agripa, ngetho di pe̱ꞌsa nunar ndo̱ꞌminu̱, nuya ma mixodyoꞌbe xi ꞌba̱bgagi ha ya tsꞌu̱tꞌwi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Xiꞌmu̱, wa hingi ñꞌemu̱ihu̱, Jö tsa̱ da gu̱xa nuꞌu̱ xi du. ");
INSERT INTO otqNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nuga nꞌehe har ndu̱i, ndi beni mar ñho te gatho nga o̱tꞌwa nuꞌu̱ togo mi no̱mba ár thuhu ar Hesu me Nasare. ");
INSERT INTO otqNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Njapꞌu̱ da o̱tnu̱ Herusalen. Xki ꞌraka ya he̱ꞌmi ya ndömöjö nda tsa̱ nga ju̱ ya gamfi. Nze̱ye̱ ndi kotꞌa ha ya fa̱di, ne ndi etꞌatho ma xu̱tha núꞌmu̱ mi tho. ");
INSERT INTO otqNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Hinge ndi tsa̱ya̱ ndi o̱tꞌwa nöꞌö ndi ne ha yá nijö ya xodyo, ndi ne nga japi nda ko̱nga ar tsi Hmu. Xa xki zu̱kar kwe̱, ndi pa maꞌra ya ha̱i ndi honi ne nga o̱tꞌwa ar tsꞌomꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Jange ngar mamhö Ndamasko, xki ꞌraka ar tsꞌe̱di ne xki me̱nkagi ya ndömöjö nga ju̱ ya gamfi, nga etꞌa ar fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ha ngu made mpa, tsi ndöꞌi di xiꞌaꞌi, ndi ꞌyohe ar ꞌñu, nꞌa nda handatho nꞌar hyatsꞌi mi töta ár hyatsꞌi ar hyadi, bi gobgathogihe, nuga ne gatho nuꞌu̱ ndi ñꞌoꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Dama da hwanje gathogihe, ne dá o̱ nꞌar mhö mi ñö ebreo, bi ꞌñengagi: Saulo, Saulo, yoꞌö gi u̱tsagi. Go gi ntsꞌokse̱, ngu nꞌar boi pu̱nse̱ ar maza. ");
INSERT INTO otqNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nuꞌmú̱ nuga da embabi: Ndada, togoꞌi. Har tsi Hmu bi ꞌñengagi: Nuga dar Hesu, togo gi u̱tsa. ");
INSERT INTO otqNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ha nupya nangi gi ꞌba̱i, ngetho xta ñꞌupya ga huxꞌaꞌi gi pe̱pkagi, ne gi da̱majöni nöꞌö xka hyandi ne nöꞌö ma ga utꞌa mꞌe̱fa. ");
INSERT INTO otqNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nuga ga ñöñꞌaꞌi hinte da jaꞌaꞌi nuyu̱ ri mixodyowi, ne nuꞌu̱ hingya xodyo habu̱ gatho ma ga pe̱ñꞌaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ka ma gi zohnu̱ ya jöꞌi, gi xokwa yá da̱ da bo̱nga har ꞌbe̱xui, ne da e da mꞌu̱ har hyatsꞌi. Da kꞌotꞌa ha yá ꞌye̱ ar tsꞌondöhi, ne da e da zu̱ Jö. Da ñꞌemu̱igi, ne njapꞌu̱ ga pumbabi yá tsꞌoki, ne da hñönga gatho nöꞌö xa ñhötꞌwa nuꞌu̱ xi ntꞌaxkwabi yá mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Jange, nuꞌge ndö Agripa, nuga da o̱ta nöꞌö ngur tꞌi ndi ꞌñe mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ne da du̱ꞌma Ndamasko da zo ya jöꞌi, nepꞌu̱ Herusalen ne gatho maꞌra ya hnini Nhudea. Mꞌe̱fa da ma habu̱ mi ꞌbu̱ nuꞌu̱ hingya xodyo, da zofo nda ꞌyo̱tꞌwa yá ntso̱ꞌmi ne da ñꞌemu̱i Jö. Ne da ꞌyo̱tꞌu̱ nöꞌö xiñho, njapꞌu̱ da ñꞌudi xi ꞌyo̱tꞌwa yá ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Gehnu̱ ndi pe̱fi, jange bi mikagi ya xodyo har dönganijö, ꞌbu̱tho nda hyogagi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ha Jö bi ma̱xkagi, jange di ꞌbu̱kwatho ga zo ya jöꞌi, wa nuꞌu̱ pe̱ꞌsa yá nsu ne nuꞌu̱ hinte pe̱tsꞌi. Hinte di hutsꞌi, ho̱nse̱ di mönga ngu bi ꞌyotꞌa ar Moise ne maꞌra yá mꞌe̱hni Jö ma nda thogi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bi möñꞌu̱, nunar Kristo ma nda tho nze̱ye̱ ya u̱gi ne nda tho. Ha mꞌe̱fa gehnu̱ ar ꞌbe̱tꞌo nda mengi nda nte, ne nda utwa ar hyatsꞌi ya xodyo ne nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nu mi mönga njapꞌu̱ ar Pablo mi ñönga ár te, ar ndö Festo bi ñö ntsꞌe̱di ne bi ꞌñenö: —Pablo, nuya nze̱ye̱ ya he̱ꞌmi xka nehe xi tsꞌompꞌa ri mfeni. ");
INSERT INTO otqNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ha nunar Pablo bi dödi ne bi ꞌñenö: —Hinxta ꞌbe̱ ma mfeniga, hoga ndö Festo, ngetho di mönga nöꞌö majöni, ne di pödi yoꞌö. ");
INSERT INTO otqNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nunar ndö Agripa pödi xiñho tema di mö, jange hindi ntsu ga ñö hár nthandinu̱. Di pödi nunu̱, xi zo ár gu nöꞌö di mö, ngetho hinxi tho ñꞌöntho. ");
INSERT INTO otqNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ndö Agripa, ha gi ñꞌemu̱i nöꞌö xi mönga yá mꞌe̱hni Jö. Di pödi hö, gi jamfi. ");
INSERT INTO otqNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nuꞌmú̱ ar ndö Agripa bi dödi ne bi ꞌñenö: —Txꞌu̱tho bi ꞌbe̱di ngi jaki nga ñꞌemu̱i ar Hesukristo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Jange ar Pablo bi ꞌñembabi: —Txꞌu̱tho bi ꞌbe̱di wa nze̱ye̱, dá nemhö Jö da njapꞌu̱. Hinge ho̱nse̱ꞌi, gatho nuyu̱ xi ꞌyo̱xa nöꞌö xta mö, di ne da ñꞌemu̱iyu̱ ngu xta ñꞌemu̱iga nꞌehe. Ho̱nse̱ hindi ne da nthötꞌa ya nthöhibo̱jö ngu di thötka. ");
INSERT INTO otqNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nu mi wadi bi mönga njapꞌu̱ ar Pablo, ar ndö Agripa ne ar Festo, ar Berenise ne gatho nuꞌu̱ mi ꞌbu̱hnu̱, bi mꞌa̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Mi maꞌu̱ nꞌampꞌu̱se̱, bi ꞌñembabi nꞌa ngu nꞌa: —Hinte xi ꞌyo̱tꞌa nunar ñꞌo̱ho̱nu̱ di ꞌñepi da tho, wa da tꞌetꞌar fa̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ar ndö Agripa bi ꞌñemba ar Festo: —Nunar ñꞌo̱ho̱nu̱ xi za̱ xi the̱hmö nuꞌmu̱ hinxi ꞌya̱di ma da mꞌa̱ hár nthandi ma ndöhu̱ Sesar. ");
INSERT INTO otqNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nu mi beñꞌu̱ nda ꞌbe̱nkagihe ga ꞌyohe ar dehe gár möhe har ha̱i Italia, ar Pablo ne maꞌra ya ꞌyofa̱di bi tꞌe̱ntꞌwár ꞌye̱ nꞌar döndogu már thuhu Hulio, yá ndogu ar Augusto Sesar. ");
INSERT INTO otqNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Da po̱xe ne da möhe ha nꞌar döta motsa xki ꞌñe har hnini Adramitio, ne nda mengi nda thota ha ya hnini ꞌbu̱ har ñönthe har ha̱i Asia. Mi panu̱ ndi ñꞌohe nꞌehe ar Aristarko me Ntesalonika har ha̱i Nmasedonia. ");
INSERT INTO otqNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ár hyaxꞌö da tso̱ñhe har hnini Sidon. Ar Hulio xa bi ñhogajöꞌi bi hye̱ ar Pablo nda kꞌöꞌsa yá mpödi mi ꞌbu̱hnu̱, ne nda tꞌumba nöꞌö mi kꞌatꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Da po̱ñhenu̱ Sidon, da thothe habu̱ mi ta̱gagihe ar ndöhi ar xe̱niha̱i Txipre, ngetho ndi nto̱xkwihe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Da ꞌranthe njöntho har dehe, da thothe getꞌu̱ ar ha̱i Nsilisia ne Panfilia, da tso̱ñhe har hnini Mira har ha̱i Lisia. ");
INSERT INTO otqNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ar döndogu ka bi dinu̱ nꞌar motsa mar me Alejandria, ndi ma har ha̱i Italia. Ka bi ꞌñexkagihenu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Dá ꞌyohe ꞌramtxꞌu̱ nze̱ye̱ ya pa, xa nꞌar döta ꞌbe̱fiꞌö dá tso̱ñhe ꞌranditho ar hnini Gnido. Xa mi ntsꞌe̱di ar ꞌyomndöhi, ne himi he̱gagihe nga ꞌyohe, da thothe har xe̱niha̱i Kreta habu̱ mi ta̱gagihe ar ndöhi getꞌu̱ ar xe̱niha̱i Salmon. ");
INSERT INTO otqNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Da ka̱tathohe ar xe̱niha̱i Kreta, ꞌramtxꞌu̱ ndi ꞌyohe ndi nto̱xkwihe ar ꞌyomndöhi. Da tso̱ñhe ha nꞌar ñönthe xki thuꞌspabi Ya Hoga Goxthi getꞌu̱ ar hnini Lasea. ");
INSERT INTO otqNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Xki tho nze̱ye̱ ya pa ndi ꞌyohe har dehe, ne mar ñhembi, ngetho xki tho ar ndöbëhë ne xki zo̱ ya tse̱. Jange ar Pablo mi xipabiꞌu̱: ");
INSERT INTO otqNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Ha gi o̱hu̱, ndadahu̱. Di handi ma ga thohu̱ nze̱ye̱ ya thogi har ꞌñu. Da tsa̱ ga ꞌbe̱hu̱ ar motsa ne gatho nöꞌö hö. Hinge ho̱nse̱ꞌö, tsa̱ ga jöthu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ha nunar döndogu himbi japamasu nöꞌö mi mönga ar Pablo. Mi te̱nda nöꞌö mi mönga togo mi e̱tꞌa ar motsa ne togo már me̱ti. ");
INSERT INTO otqNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ngetho hintsꞌu̱ mar ñho nda gohnu̱ ar motsa ha Ya Hoga Goxthi nuya pa mar ntse̱. Jange nze̱ye̱ nuꞌu̱ mi panu̱ bi beñꞌu̱ mar ñho nda bo̱nu̱, xömhö nda tsa̱ nda zo̱nga har hnini ñhanda mahyatsꞌi ár thuhu Fenise har xe̱niha̱i Kreta, ne nda thohnu̱ ya tse̱. ");
INSERT INTO otqNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nꞌa mbi ñꞌoda nꞌar ndöhi ndi ꞌñe makꞌangi, jange bi beñꞌu̱ gehnu̱ mi hoñꞌu̱. Dama bi gu̱xa ya bo̱jö mi to̱ꞌsa ar motsa, ne da ka̱tathohe ár ñönthe ar xe̱niha̱i Kreta. ");
INSERT INTO otqNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Hingar yaꞌö bi zu̱je nꞌar ꞌyomndöhi xa mi ntsꞌe̱di, ndi ꞌñe mahwifi ne mahyatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nor ꞌyomndöhi xa mi tsꞌe̱di bi duxa ar motsa, da tsa̱hmöhe nga ñhanthwe, ne himbi tsa̱. Jange da he̱he bi dutsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Da thothe getꞌu̱ nꞌar xe̱niha̱i ár thuhu Klauda habu̱ mi ta̱gagihe ar ndöhi. Xa da o̱the ar tsꞌe̱di da ju̱xenu̱ ar tꞌu̱lo motsa mi ju̱tꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Da jwahe da ju̱xe ar tꞌu̱lo motsa, bi xo̱tꞌu̱ nor döta, hinge nda nhwati. Nuꞌu̱ togo mi e̱tꞌa ar motsa, mi tsu nda nthe̱xkwi ya boꞌsaꞌbomu ja mbo ar dehe yá thuhu Sirte. Jange bi göꞌma ya dutu nuꞌu̱ tuxa ar motsa nda ñꞌo, ne bi hye̱ꞌu̱ nda ñꞌose̱. ");
INSERT INTO otqNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ár hyaxꞌöpꞌu̱ mi nto̱xkwitho ar ꞌyomndöhi, jange bi ndu̱i bi ꞌye̱nga har dehe gatho nöꞌö mi tu ar motsa. ");
INSERT INTO otqNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ár hñupapꞌu̱, manꞌagi bi menkꞌu̱ bi ꞌyu̱tꞌa har dehe nuya tema pongwa ar motsa. ");
INSERT INTO otqNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Bi tho nze̱ye̱ ya pa himbi nheki ar hyadi wa ya tso̱, ngetho xa mi ꞌyo ar ꞌyomndöhi. Ho̱nse̱ ndi to̱ꞌmthohe ar ndöte. ");
INSERT INTO otqNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Xki tho nze̱ye̱ ya pa hinte ndi tsihe, jange ar Pablo bi mꞌa̱ madetho, ne bi ꞌñengagihe: —Ha gi o̱hu̱, ndadahu̱. Nuꞌmu̱ xka jahmöhu̱masu nöꞌö da xiꞌahu̱, ne xta kohmöhu̱nu̱ Nkreta, hinxta thohmöhu̱ nuna di thohu̱pya, ne hinxka ꞌbe̱hmöhu̱ gatho nöꞌö xka hyo̱thu̱ har dehe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ha nupya di xiꞌahu̱, yo gi tu ri mu̱ihu̱, ngetho hinto ma ga tuhu̱, ho̱nse̱ ar motsa ma da mꞌe̱di. ");
INSERT INTO otqNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ngetho manxui bi zokagi nꞌár e̱nxe̱ Jö, togo ár me̱tigi ne di pe̱pabi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ne bi ꞌñengagi: Pablo, yo gi ntsu, ngetho mahyoni gi ꞌba̱hnu̱ hár nthandi ar ndö Sesar. Ne hinge ho̱nse̱ꞌi, Jö xi hwëkꞌaꞌi da kꞌontꞌa gatho nuꞌu̱ gi ñꞌowi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Jange nupya di xiꞌahu̱, ndadahu̱, yo gi tu ri mu̱ihu̱, ngetho nuga di ñꞌemu̱i Jö, ne ma da ꞌyo̱tꞌa ngu xi xikagi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mödi ar ndöhi ma da ꞌye̱ngagihu̱ ha nꞌar xe̱niha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nu mi zo̱ ár ꞌre̱tꞌamagoho mpa ndi ꞌyohe njapꞌu̱, mi tuxkagihe ar ndöhi har ñho̱nthe ár thuhu Adriatico. Ngu made ar xui, nuꞌu̱ togo mi e̱ ar motsa mi beni ma nga tso̱ñhe ha nꞌar ha̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ne bi ndu̱i bi ꞌye̱nga hangu ár ñhe ar dehe. Mi pe̱ꞌsa nꞌa̱te ñhu̱fi ár ñhe. Da thohe manꞌa tsi tu̱i, bi mengi bi ꞌye̱ni manꞌagi. Ho̱nse̱ mi pe̱ꞌsa ꞌre̱tꞌamaku̱tꞌa ñhu̱fi ár ñhe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mi ntsuꞌu̱ nda nto̱xkwi ya do ar motsa, jange bi köꞌma goho ya bo̱jö mo̱te ar motsa nuꞌu̱ tso̱nga har ha̱i, tsöma ar motsa. Gathogihe xa ndi nehe ngutꞌa nda hatsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nuꞌu̱ togo mi e̱tꞌa ar motsa, mi ne nda göi nda zopꞌu̱. Jange bi mengi bi ꞌye̱ntꞌa har dehe ar tꞌu̱lo motsa, mi o̱tꞌu̱ ngu mi e̱ntꞌa maꞌra ya bo̱jö hár ñö ar motsa. ");
INSERT INTO otqNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ha nunar Pablo dama bi xipabi ar döndogu ne yá ndogu, bi ꞌñembabiꞌu̱: —Nuꞌmu̱ hinda gokwayu̱, hinto ma gi kꞌonthu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Jange ya ndogu dama bi hye̱ka ya nthöhi habu̱ mi zu̱ ar tꞌu̱lo motsa, ne bi ntho̱ge bi ma. ");
INSERT INTO otqNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nu mi hatsꞌi, ar Pablo mi xikagihe gatho nga nzimxudihe, ne bi ꞌñenje: —Pe̱ꞌsa ꞌre̱tku̱tꞌa hinxka öhu̱ ngi ndo̱ꞌmhu̱, hinte xka tsihu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Jahu̱ ar möte gi ñuñhu̱. Mahyoni gi pe̱ꞌsu̱ ar tsꞌe̱di, ngetho di xiꞌahu̱ hinto gi ꞌbe̱hmöhu̱ nꞌar xtö. ");
INSERT INTO otqNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mi mönga njapꞌu̱ ar Pablo, bi gu̱ nꞌar thuhme, bi umba njamödi Jö ha yá nthandiꞌu̱. Ne bi xe̱ka nꞌa xe̱ni bi ndu̱i bi zi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nuꞌmú̱ gatho bi hñu yá mu̱i, ne bi ñuñꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nuꞌu̱ ndi pa̱he har motsa, yonthebe hñunꞌa̱temaꞌre̱tꞌa ne ꞌrato ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nu mi niñöꞌu̱, bi ꞌyu̱tꞌa har dehe ya tꞌe̱i, ne njapꞌu̱ nda götꞌa ár ñhu̱ ar motsa. ");
INSERT INTO otqNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nu mi hatsꞌi, nuꞌu̱ togo mi e̱tꞌa ar motsa bi hyanda nꞌar ha̱i, mödi himi pödi tema ha̱iꞌö. Mi pe̱ꞌsa nꞌar ñu̱tꞌi har ñönthe habu̱ mi nheki ar ꞌbomu. Bi beñꞌu̱ xömhö nda tsa̱ nda ꞌba̱ꞌmnu̱ ar motsa. ");
INSERT INTO otqNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bi hye̱ka ya nthöhi mi thötꞌa ya bo̱jö mi tsöma ar motsa, ne bi zopꞌu̱ har ñho̱nthe. Bi nsotꞌwa yá nthöhi nöꞌö ar za e̱tꞌa ar motsa. Nepꞌu̱ bi po̱ꞌsa nuꞌu̱ ya dutu hár ñö ar motsa, ne njapꞌu̱ ar ndöhi bi ꞌye̱tꞌa har ñönthe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ha núꞌmu̱ mi zo̱nga habu̱ mi pe̱ꞌsa yoho ya tsꞌe̱di ar dehe, ar motsa bi nthe̱wi ar ꞌbomu, ne bi mfoxa ár ñö, ne himbi tsa̱ bi ñꞌo. Ha nu mo̱te mi nhwati xa mi fe̱ꞌsa ar dehe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Nuꞌmú̱ nuya ndogu bi beni mar ñho nda hyo gatho ya ꞌyofa̱di, ne hinge nda hya̱tꞌi nda maꞌu̱ ñꞌa̱nthe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nunar döndogu himi ne nda tho ar Pablo, jange himbi hye̱gi nda ꞌyo̱tꞌu̱. Ne bi ꞌbe̱pa nda ꞌye̱ngar nsa̱gi mꞌe̱tꞌo gatho nuꞌu̱ mi pödi nda ñꞌa̱nthe, ne nda bo̱nga har ñönthe. ");
INSERT INTO otqNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ha nu maꞌra himi pödi nda ñꞌa̱nthe, bi ꞌbe̱pabi nda gu̱ ꞌra ya xithe̱ ne ꞌra yá xe̱ni ar motsa. Ne njapꞌu̱ hinto bi du, gatho da tso̱ñhe har ñönthe. ");
INSERT INTO otqNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nu nda jwadi da po̱ñhe har dehe, da pöhe nunar xe̱niha̱inu̱ már thuhu Malta. ");
INSERT INTO otqNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nuya mengunu̱ xa bi numañhogihe. Bi ꞌñutkagihe nꞌar tsibi nga mpathe, ngetho mi ra ntse̱ mi ꞌwöi. ");
INSERT INTO otqNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ar Pablo bi gu̱xa ꞌra ya tꞌo nda ꞌyu̱ꞌsa har tsibi. Ka mi opꞌu̱ nꞌar kꞌeñö, mi za̱ ár mpa ar tsibi, bi bo̱ni ne bi mꞌa̱tꞌa hár ꞌye̱ ar Pablo. ");
INSERT INTO otqNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nu mi hyanda nuya mengunu̱ mi zu̱ta ar kꞌeñö hár ꞌye̱ ar Pablo, mi eñꞌu̱ nꞌa ngu nꞌa: —Xar tsꞌokte nunar ñꞌo̱ho̱nu̱, ngetho bi kꞌonthmö nda jötꞌa har dehe, ha nunár tsꞌu̱tꞌwi Jö hingi he̱gi da mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ha nunar Pablo bi hwötꞌa ár ꞌye̱ har tsibi nda da̱ ar kꞌeñö, ne hinte bi ja. ");
INSERT INTO otqNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nuya mengunu̱ mi to̱ꞌmtho hamꞌu̱ nda neni, wa nda hwangi xi du. Xa bi do̱ꞌmi ne hinte bi ja. Nu mi hyanda njapꞌu̱ bi pongyá mfeni, mi eñꞌu̱ nunar Pablo mi nꞌar jö. ");
INSERT INTO otqNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Habu̱ da tso̱ñhe, ka mi the̱nu̱ ꞌra yá ha̱i nꞌar ñꞌo̱ho̱ már thuhu Publio, togo mar ndö gatho ar ha̱iꞌö. Xa mar hogajöꞌi, bi ꞌraje nse̱ki hñupa hár ngu. ");
INSERT INTO otqNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nór dadaꞌö mi oxar tꞌoxi, mi umbar mpatꞌi ne ar ꞌbiji. Ar Pablo bi ma ba kꞌötsꞌi, ne mi ꞌya̱pa Jö bi hñuxpa yá ꞌye̱, ne dama bi ditsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Njapꞌu̱, gatho nuꞌu̱ maꞌra ya mengunu̱ har ha̱iꞌö mi hñeni, mi e nda kꞌötsꞌi ne mi thitsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Xa bi numansugihe, bi ꞌraje nꞌar hoga tsa̱ya̱. Ne nda po̱ñhenu̱, bá tutkagihe gatho nöꞌö nga hoñhe har ꞌñu. ");
INSERT INTO otqNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Da ꞌbu̱henu̱ hñu nzönö. Nepꞌu̱ da ju̱henu̱ nꞌar motsa mar me Alejandria, xki thohnu̱ ya tse̱ nꞌehe. Mi tu hár ñö ar motsa yoho yá ja̱tꞌi yá jöꞌu̱, nꞌa már thuhu Kasto, ha nöꞌö manꞌa már thuhu Polu. ");
INSERT INTO otqNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nepꞌu̱ da tso̱ñhe ha nꞌar hnini ár thuhu Sirakusa, ka da ꞌbu̱henu̱ hñupa. ");
INSERT INTO otqNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Da ka̱tathohe nor xe̱niha̱iꞌö, ne da möhe har hnini Regio. Ha nu ár hyaxꞌö bi ñꞌo ar ndöhi ndi ꞌñe makꞌangi, jange ár yopa da tso̱ñhe har hnini Puteoli. ");
INSERT INTO otqNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ka da nthe̱henu̱ ꞌra ya ku, bi ꞌya̱kagihe nga kohenu̱ yoto mpa. Ne ka da po̱ñhe da möhe har hnini Nroma. ");
INSERT INTO otqNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nuya ku me Nroma, xki ꞌyo̱ꞌu̱ ma nga tso̱ñhe, bi bo̱ñꞌu̱ ma ba thöje har döꞌñu getꞌu̱ ar ta̱i ár thuhu Apio, ne maꞌra har hnini Hñu Ngu. Ar Pablo mi hyanda ya ku, bi umba njamödi Jö, ne bi ze̱ta ár mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nu nda tso̱ñhe Nroma, ar döndogu bi ꞌye̱ntꞌwa ár ꞌye̱ ar ndösufa̱di nuꞌu̱ ya ꞌyofa̱di mi tsiꞌö. Ha nunar Pablo bi tꞌumba nse̱ki bi mꞌu̱ nꞌampꞌu̱, mi su nꞌar ndogu. ");
INSERT INTO otqNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Mi tho hñupa xki zo̱nga ar Pablo Nroma, bi zohna gatho ya ndöxodyo mi ꞌbu̱hnu̱. Nu mi watꞌu̱, bi ꞌñembabiꞌu̱: —Ndadahu̱ di nkuhu̱, di ne gi pöhu̱ hinte ma tsꞌoki xta o̱tꞌwa ma jöꞌihu̱, hinxta tsꞌokwa ma ntꞌumbihu̱ xi zoju̱ ma palehu̱. Mödi hinte xta o̱tꞌe, bi tsꞌonkaginu̱ Herusalen, ne bi tꞌe̱ntkꞌagi ha yá ꞌye̱ ya me Nroma. ");
INSERT INTO otqNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ha nu mi thöꞌska majöni, hinte ma tsꞌoki bi thimgagi ndi ꞌñepki nda hyogagiꞌu̱, jange mi ne nda hye̱gahmöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ha numa mixodyohu̱, himbi neꞌu̱, jange da a̱di nda hñöska majöni ar ndö Sesar. Mödi hinte di ne te ga ho̱xa ma mixodyohu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Jange xta zoñꞌahu̱ ga hantꞌahu̱ ne ga ñöhu̱. Ngetho di pe̱ꞌspa ár ndo̱ꞌmi ya me Israel, xi nthötkagi nuya nthöhibo̱jöyu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Nuꞌmú̱ nuya ndö xodyo bi ꞌñembabi: —Nuje hinte ma he̱ꞌmi xta höñhe xpa ehnu̱ Nhudea, hinxi zo̱hnu̱ nꞌar ku xpa ehnu̱ xi ñömañꞌu̱ꞌi. ");
INSERT INTO otqNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ndi to̱ꞌmhe ngi xikagihe nöꞌö gi beni, ngetho ho̱nse̱ di pöhe habu̱ gatho ya jöꞌi ñömañꞌu̱ nuna ar ꞌraꞌyo ꞌñunu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nepꞌu̱ bi nkoꞌu̱ hamꞌu̱ nda penkꞌu̱. Bi zo̱ ar pa, bi zo̱hnu̱ nze̱ye̱ habu̱ mi ꞌbu̱ ar Pablo. Gatho ar pa mi zofo ne mi da̱twa majöni ár tsꞌu̱tꞌwi Jö. Mi otꞌwa ar ꞌñu ár tꞌofo ar Moise ne nöꞌö bi ꞌyotꞌa yá mꞌe̱hni Jö mahamꞌu̱, mi neꞌö nda ñꞌemu̱iꞌu̱ ar tsi Hmu Hesu. ");
INSERT INTO otqNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ꞌRa mi ñꞌemu̱i nöꞌö mi mönga ar Pablo, ha maꞌra himi ne nda jamfi. ");
INSERT INTO otqNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ne himi nꞌatꞌwu̱ mi ñꞌemu̱i, jange mi maꞌu̱ bi ꞌñenga ar Pablo: —Majöni nöꞌö bi mönga ar mꞌe̱hni Isaia xki nzinga ár Hñö Jö, núꞌmu̱ bi me̱hni nda ꞌñemba njawa ma palehu̱: ");
INSERT INTO otqNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Di ma ba zo nuya jöꞌiyu̱, ne gi ꞌñembabi: Ma gi ꞌyo̱hu̱, ne hinte da zo ri mfenihu̱. Ma gi hyanthu̱, ha hingi pöhu̱ tema di bo̱nga nöꞌö gi hanthu̱. ");
INSERT INTO otqNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ngetho nuya jöꞌiyu̱ xi japi xi më yá ñö, hingi ne da ꞌyo̱xa nöꞌö o̱de. Xi tsꞌa̱ntꞌa yá da̱, njapꞌu̱ hinda xo yá da̱ da hyandi, ne hinda zo yá gu, hinda kwata ha yá mu̱i, ne da hñuxka yá da̱, ha nuga da tsa̱ ga umba ár nzaki. ");
INSERT INTO otqNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Jange pöhu̱ ꞌmu̱, nuna ar mpo̱ho̱nu̱ unga Jö, ma da tꞌumbabi nuꞌu̱ hingya xodyo, ngetho nuꞌu̱ ma da ꞌyo̱tsꞌe ne da ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Nu mi wadi bi mönga njapꞌu̱ ar Pablo, ya xodyo bi maꞌu̱, xa mi ñöxhnatho nꞌa ngu nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ha nor Pablo bi mꞌu̱hnu̱ xo̱ yo nje̱ye̱ ha nꞌar ngu njutꞌi, ne mi thöta gatho nuꞌu̱ mi tso̱ho̱ nda ñöwi. ");
INSERT INTO otqNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Mi xipabi ya jöꞌi ár tsꞌu̱tꞌwi Jö, ne mi utwabiꞌu̱ togo ar tsi Hmu Hesukristo. Himi ntsu nda ñö, ne hinto bi hñökwabi.");
INSERT INTO otqNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nuga dar Pablo, ár ꞌbe̱gogi ar tsi Hmu Hesukristo. Xi tsꞌonkagi ngu ár mpo̱te, ne xi tꞌexkagi ga mömba ár hoga mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Nuna xki ñötkagihu̱ mamꞌe̱tꞌo ha yá jöpa Tꞌofo bi ꞌyotꞌa yá mꞌe̱hniꞌö. ");
INSERT INTO otqNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ja no̱mpꞌu̱ ár Tꞌu̱, nuna ma tsi Hmuhu̱ Hesukristo. Bi mꞌu̱ ngu nꞌar jöꞌi ndi ꞌñe ha yá ma̱ngaꞌbe̱to ar Dabi. ");
INSERT INTO otqNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ne ár Hñö Jö xintꞌaxi bi ñꞌu gehnu̱ ár Tꞌu̱ Jö pe̱ꞌsa ár tsꞌe̱di, núꞌmu̱ mi menga ár te manꞌagi xki wadi xki du. ");
INSERT INTO otqNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Gese̱ xi hwëgagihu̱ ga po̱thu̱ ga zohu̱ ya jöꞌi ꞌbu̱ ha ya ha̱i gatho ár nxidi ar ximha̱i, ne da ñꞌemu̱i da de̱ni, njapꞌu̱ da tꞌeꞌspa ár nsu ár thuhu. ");
INSERT INTO otqNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Jange gi nthöskwihu̱yu̱ nꞌehe, xi tsꞌoñꞌahu̱ ngu yá me̱tiꞌihu̱ ar tsi Hmu Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Di pe̱ñꞌahu̱ nunar he̱ꞌminu̱ gatho nuꞌahu̱ gi ꞌbu̱hu̱ Nroma, xa möꞌahu̱ Jö ne xi zoꞌahu̱ gi ꞌbu̱hu̱ xintꞌaxi. Jö ma Dadahu̱ ne ar tsi Hmu Hesukristo da ꞌraꞌahu̱ nꞌar hogamꞌu̱i, ne da hwëkꞌahu̱ yá ñho. ");
INSERT INTO otqNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Di ne ga xiꞌahu̱ mꞌe̱tꞌo, di umba njamödi Jö hár thuhu ar tsi Hmu Hesukristo, xka ñꞌemu̱ihu̱ xiñho, ne hagatho nho̱ni gar gamfihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ar tsi Dada togo xa di umba ma mu̱i di pe̱pabi, di mömba ár hoga mhö no̱nga ár Tꞌu̱, gehnu̱ pödi hindi tsa̱ya̱ di matꞌahu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Di a̱pa Jö da neꞌö da ꞌrakar se̱ki ga tso̱ñꞌahu̱, ngetho pe̱ꞌsa ya pa di to̱ꞌmi ga mapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ngetho di ne ga hantꞌahu̱ ne ga fa̱xꞌahu̱ gi hñöñhu̱ nꞌar ñho di ꞌñe mhetsꞌi, ne njapꞌu̱ da ze̱ta ri ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Njanu̱ mahye̱gi da te ma ñꞌemu̱ihu̱, ngetho nꞌadar jamfi di pe̱ꞌsu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Tsi kuhu̱, di ne gi pöhu̱, hinge nꞌagitho xta ne xta mapꞌu̱, ne hinxi kꞌatꞌi te xi kꞌaski. Di ne ga fa̱xꞌahu̱ da te ri ñꞌemu̱ihu̱, ngu xta fa̱xa maꞌra hingya xodyo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Di beni gatho di tupabi ma ga zofo, ya bötꞌofo ne hingya bötꞌofo, nuꞌu̱ xa te gatho pödi, ne nuꞌu̱ hinte pödi. ");
INSERT INTO otqNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Jange xa di nemhö ma ga kꞌösꞌahu̱ gar me Nromahu̱, ne ga xiꞌahu̱ ar hoga mhö nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Hindi ntsa̱ga ga mönga ar hoga mhö, ngetho ka nhekinu̱ ár tsꞌe̱di Jö da po̱ gatho nuꞌu̱ da ñꞌemu̱i, mꞌe̱tꞌo ya xodyo, mꞌe̱fa nuꞌu̱ hingya xodyo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ngetho har hoga mhö, ka nhekipꞌu̱ hanja ga ꞌbu̱hwihu̱ xiñho Jö ngetho di ñꞌemu̱ibihu̱. Ne ga ꞌbu̱hu̱ di ñꞌemu̱ihu̱, ngu enga har Tꞌofo: Nöꞌö togo ñꞌemu̱i, ꞌbu̱i xiñho hár nthandi Jö, ne pe̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Jö ñꞌu ár kwe̱ di ꞌñe mhetsꞌi, da umba ár mfe̱i ya tsꞌojöꞌi. Nuyá tsꞌoꞌmu̱iyu̱ kꞌaꞌsa nöꞌö majöni. ");
INSERT INTO otqNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nuyu̱ xi bö nöꞌö tsa̱ da fötwa Jö, ngetho Jö xi utwabiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ngetho nöꞌö hingi tsa̱ ga handwabihu̱, ngu ár tsꞌe̱di hingi thege ne ár nsunda, bi nheki núꞌmu̱ bi hyokar ximha̱i, ha gathoyu̱ födi togoꞌö. Jange hiñꞌotho te da dödi. ");
INSERT INTO otqNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bi böꞌu̱ Jö, ha himbi nsundabi ngu ndi ꞌñepi, himbi umpꞌu̱ njamödi. Te gatho bi bentꞌu̱ ne bi me̱ꞌsku, jange bi tsꞌoka yá mfeni. ");
INSERT INTO otqNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Mi o̱tꞌu̱ xa mi pödi, bi ꞌbe̱ yá mfeniꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bi hye̱gi bi nsunda Jö hiñhamꞌu̱ da göxa ár te. Ne bi ndu̱i bi nsundabi ár ꞌba̱i ya jöꞌi the yá te, ya tsꞌintsꞌu̱, ya me̱ti ne ya zuꞌwe ju̱tꞌa yá mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Jange Jö bi hye̱gi bi ꞌyo̱tꞌa gatho nuya tsꞌoki mi neꞌu̱. Njapꞌu̱ bi ꞌbe̱twa ár tsa̱ yá ndoꞌyose̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ngetho bi hye̱ꞌu̱ nöꞌö majöni xi zogagihu̱ Jö, ne bi de̱nga nöꞌö hinga majöni. Bi ndönga mꞌe̱tꞌo ya nthojtho, hinge nöꞌö togo bi hyoki, togo di ꞌñepi hinda the ar nsunda tꞌumbabi. Dá njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Jange Jö bi hye̱gi bi ꞌyo̱tꞌa gatho nuya tsꞌomfeni ndi ꞌñepabi. Njapꞌu̱ bi ꞌbe̱se̱ yá tsa̱. Nuya ꞌbe̱hñö bi hye̱ nöꞌö ngu xki tꞌumbabi nda ꞌyo̱tꞌe, ne bi ꞌyo̱tꞌa nöꞌö hinxi tꞌumbabi nda ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Njapꞌu̱tho ya ñꞌo̱ho̱ nꞌehe, bi hye̱pꞌu̱ yá ꞌbe̱hñö, bi nhese̱ yá mindo̱wi, ne bi ꞌyo̱tꞌu̱ nöꞌö ar mꞌe̱tsa̱. Jange bi hñöñꞌu̱ ár njutꞌi yá tsꞌoki ha yá ndoꞌyose̱. ");
INSERT INTO otqNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ne himbi ne bi beñꞌu̱ Jö. Jange Jö bi hye̱gi nda tsꞌoka yá mfeni, ne nda ꞌyo̱tꞌa gatho nöꞌö xi ntsꞌotho. ");
INSERT INTO otqNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Xa bi ñꞌe̱ntꞌi nda ntsꞌojöꞌi, ya mꞌe̱ngwi jöꞌi, ya tsꞌomꞌu̱i, ya ne mꞌe̱tsꞌi, ya ñö tsꞌate. ꞌBe̱ntebi yá me̱ti maꞌra, ya hyote, ya tuhni, ya nemhñö, ya tsꞌokte; ");
INSERT INTO otqNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ya ñömañꞌu̱, hingi ne da ꞌyo̱de, u̱tsa Jö, ya tsate, ya ñꞌetsꞌi, ya gese̱, nuꞌu̱ togo honi hanja da ntsꞌokte, hingi o̱ta yá dada; ");
INSERT INTO otqNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ya me̱ꞌsku, hingi o̱tꞌa nöꞌö möñꞌu̱, hinte ja yá mhöte, hinto hwëki. ");
INSERT INTO otqNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Nuya jöꞌiyu̱ pötwabi tengu ár njutꞌi Jö, pöꞌu̱ nuꞌu̱ togo o̱tꞌa njapꞌu̱ di ꞌñepi da du. Mödi pöhyu̱, hinge ho̱nse̱ o̱tꞌe, johya da hyanda togo o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Jange nuꞌahu̱ gi ꞌyomfu̱ ár ꞌbede maꞌra, hinda tsa̱ gi kꞌonthu̱. Ngetho nuꞌmu̱ gi mömfu̱ ár mfe̱i di ꞌñepabi, gi ku̱tꞌase̱hu̱ har tsibi, ngetho gi njahu̱pꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ne di pöhu̱ o̱tꞌa nꞌar hoga tsꞌu̱tꞌwi Jö, núꞌmu̱ xta umba yá mfe̱i togo o̱tꞌa nuya tsꞌokiyu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nuꞌahu̱ gi theñhu̱ nuꞌu̱ togo hingi o̱tꞌa xiñho, ha gi beni gi kꞌonthu̱ hinda zu̱ꞌahu̱ ár kwe̱ Jö gi ñhe̱xkwihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Yoꞌö gi u̱tsabihu̱ ár döta ñhogajöꞌi Jö, ár tsꞌe̱ti, ne ár mhöte. Ha hingi pöhu̱, gehnu̱ ár ñhogajöꞌi da ma̱xꞌahu̱ gi ꞌyo̱thwu̱ ár ntso̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ngetho xa gar me̱ꞌskuhu̱, hinxka ne xka ꞌyo̱thwu̱ ár ntso̱ꞌmi. Njapꞌu̱ xka hñuꞌsu̱ ár mfe̱i ma da tꞌaꞌahu̱ nor pa da ñꞌu ár döta kwe̱ ne ár hoga tsꞌu̱tꞌwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Gehnu̱ ma da umba ár njutꞌi nꞌa ngu nꞌa ngu yá ꞌbe̱fi xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ma da tꞌumba ar te hinda götsꞌi nuꞌu̱ xi umba yá mu̱i xi ꞌyo̱tꞌa nöꞌö xiñho, xi hyonga da mꞌu̱ hár nsunda Jö, ne da tꞌeꞌspa ár nsu, ne xi hyonga nöꞌö di ꞌñe mhetsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ha ma da nto̱xkwi ár kwe̱ ne ár nzo̱tꞌamu̱i Jö nuꞌu̱ ya hyonga tuhni, ne hingi ne da de̱nga nöꞌö majöni. Ho̱nse̱ ne da ꞌyo̱tꞌa nöꞌö hingi ho. ");
INSERT INTO otqNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ma da mfe̱i ne da tho ar tsꞌoni gatho nuꞌu̱ bi ꞌyo̱tꞌa nöꞌö xi ntsꞌotho, ya xodyo mꞌe̱tꞌo, ne mꞌe̱fa nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ha ma da mꞌu̱ nsunda, da tꞌeꞌspa ár nsu, ne da mꞌu̱ nꞌar hogamꞌu̱i gatho nuꞌu̱ togo da ꞌyo̱tꞌa ar ñho, ya xodyo mꞌe̱tꞌo, mꞌe̱fa nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ngetho Jö handa gatho ya jöꞌi mahye̱tho. ");
INSERT INTO otqNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Gatho nuꞌu̱ togo himi pötwa yá ꞌbe̱pate ar Moise, ne bi ꞌyo̱tꞌa ya tsꞌoki, núꞌmu̱ xta thöꞌspa majöni, hinda ma nda nho̱mba ya ꞌbe̱pate. Ha nuꞌu̱ togo mi pötwa yá ꞌbe̱pate ar Moise, ne bi ꞌyo̱tꞌa ya tsꞌoki, núꞌmu̱ xta thöꞌspa majöni, ma da tꞌa̱pa ngu mönga ya ꞌbe̱pate. ");
INSERT INTO otqNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Hingi ꞌbu̱hwi xiñho Jö nuꞌu̱ togo ho̱nse̱ xi ꞌyo̱ꞌspa ya ꞌbe̱pate, mahyoni da ꞌyo̱tꞌa ngu möñꞌu̱. Gehyu̱ ma da nhu hinte ma tsꞌoki tuꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ngetho nuꞌmu̱ nuꞌu̱ hingya xodyo o̱tꞌa ngu mönga ya ꞌbe̱pate, mödi hingi pödi teme̱ꞌu̱, o̱tꞌa njapꞌu̱ ngetho gese̱ꞌu̱ pödi tema xiñho ne tema hingi ho. ");
INSERT INTO otqNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Njapꞌu̱ nheki o̱tꞌa ya hoga ꞌbe̱fi huxa ha ya ꞌbe̱pate ne xi thuꞌspa ha yá mu̱i, ne nuꞌmu̱ da hñudi da beni wa ja te tsu̱pa yá mfeni, wa hinte tsu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Njapꞌu̱tho nu xta hñöxa majöni Jö hár ꞌye̱ ar tsi Hmu Hesukristo, ma da xetꞌwa yá mfeni nuꞌu̱ togo xi kwati ho̱nse̱ pöꞌu̱. Njapꞌu̱ mönga ar hoga mhö di mönga. ");
INSERT INTO otqNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ha nuꞌahu̱, xi thusꞌahu̱ gar xodyohu̱, ne gi hu ri mu̱ihu̱ gi ꞌbu̱hu̱ xiñho, ngetho gi pe̱ꞌsfu̱ yá ꞌbe̱pate ar Moise. Xa gi exa ri nsuhu̱ gi ndöñhu̱ ri Jöhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Gi pöhu̱ teme neꞌö, ne xi tꞌutꞌahu̱ ha ya ꞌbe̱pate, gi ꞌñethu̱ ri mu̱ihu̱ nöꞌö xiñho. ");
INSERT INTO otqNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Gi ka̱xmbenihu̱ gar gu̱hnihu̱ ya goda̱, ne yá ñotꞌi nuꞌu̱ togo ꞌbu̱ har ꞌbe̱xui. ");
INSERT INTO otqNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Gi hu ri mu̱ihu̱ gi uthu̱ nuꞌu̱ hinte pödi, gar utatehu̱ ya bötsi, xka hñuxa ri mfenihu̱ har mfödi majöni mönga ha ya ꞌbe̱pate. ");
INSERT INTO otqNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Nuꞌahu̱ gi uthu̱ maꞌra, yoꞌö hingi ñꞌutase̱hu̱. Gi uthu̱ maꞌra hinda mpë, yoꞌö gi mpëhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Gi möñhu̱ hingi ho da tsꞌimba ár nthöti maꞌra, yoꞌö gar tsinganthötihu̱. Gi u̱tsahu̱ ya tsita, yoꞌö gi pëfu̱ yá nijö ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Nuꞌahu̱ gi exu̱ ri nsuhu̱ gi pe̱ꞌsfu̱ yá ꞌbe̱pate ar Moise, yoꞌö gi tsꞌojwu̱ Jö, hingi o̱thu̱ nöꞌö mönga ha ya ꞌbe̱pate ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ngetho ngu enga hár tꞌofo Jö: Go ri tsꞌokihu̱ tsamba ár thuhu Jö nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nunar nse̱gi gi tuthu̱ ri ndoꞌyohu̱, fa̱xꞌahu̱ nuꞌmu̱ gi ꞌyo̱thu̱ ngu mönga ha yá ꞌbe̱pate ar Moise. Ha nuꞌmu̱ hingi ꞌyo̱thu̱, po̱ntho hinte ma nse̱gi gi pe̱ꞌsu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ha nuꞌmu̱ togo hinxi thuꞌspa ar nse̱gi, ne da ꞌyo̱tꞌa ngu mönga ha yá ꞌbe̱pate ar Moise, ma da nhuꞌmbabi wande xi thuꞌspabi. ");
INSERT INTO otqNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nöꞌö togo hinxi thuꞌspa ar nse̱gi hár ndoꞌyo ne o̱tꞌa ngu mönga yá ꞌbe̱pate ar Moise, ma da xiꞌa ri mfe̱ihu̱. Ngetho gi pe̱ꞌsu̱ ya ꞌbe̱pate ntꞌotꞌi ne ar nse̱gi, ha hingi te̱ñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Hinge gehnu̱ ar xodyo majöni nöꞌö oxta mañö, wa nunar nse̱gi thutwa hár ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Majöni ar xodyo togo di ꞌñe mbo hár mu̱i. Ne ar hoga nse̱gi nöꞌö ꞌbe̱ꞌsa hár mu̱i unga ár Hñö Jö, hinge ar tꞌofo. Ne nunar nsu go eskagihu̱ Jö, hinge ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Nuꞌmú̱, hage töte ár mfa̱tsꞌi pe̱ꞌsa nꞌar xodyo. Wa tema ñho japabi da tuta ar nse̱gi hár ndoꞌyo. ");
INSERT INTO otqNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Nze̱ye̱ ya mfa̱tsꞌi pe̱ꞌsa ya xodyo, ne töte ár hño. Gehyu̱ mꞌe̱tꞌo bi tꞌe̱ntꞌwa ha yá ꞌye̱ ár mhö Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Nuꞌmu̱ ꞌrayu̱ hinxi ñꞌemu̱i, hage njapꞌu̱ Jö hinda ꞌyo̱tꞌa nöꞌö xi mö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Hö, da ꞌyo̱tꞌe. Mödi gatho ya jöꞌi da mönga ya nhemhñö, Jö hinꞌö. Ngu enga har tꞌofo: Ma da födi gi mönge majöni, ne ma gi ntöte núꞌmu̱ theñꞌa ya jöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nuꞌmu̱ ma tsꞌokihu̱ japi da nheki ár hogajöꞌi Jö, hage hingi njapꞌu̱ nöꞌö o̱tꞌa Jö ꞌrakagihu̱ ar mfe̱i ꞌmu̱. (Di te̱nda nöꞌö mönga ya jöꞌi.) ");
INSERT INTO otqNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Hinꞌö, hinda njapꞌu̱. Ngetho hanja da hñöꞌspa majöni ya meximha̱i ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Tsa̱ da ꞌñenga ya jöꞌi nꞌehe, nuꞌmu̱ ma nhemhñö japi da nheki nöꞌö majöni mönga Jö, ne njapꞌu̱ da tꞌeꞌspa ár nsu, yoꞌö ma da tꞌaka ar mfe̱i ngu nꞌar ꞌyo̱tꞌatsꞌoki ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ha nuꞌmu̱ njapꞌu̱, yoꞌö hinga eñhu̱ ꞌmu̱ nꞌehe: Ma ga o̱thu̱ ar tsꞌoki ga to̱ꞌmhu̱ ar ñho, ngu ho̱xkagihe ꞌra, thengagihe eñꞌu̱ di uthe njapꞌu̱. Nuya xi mönga njapꞌu̱, to̱ꞌma yá mfe̱i di ꞌñepabi. ");
INSERT INTO otqNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Te ga möñhu̱pya. Hage nuju̱ dar xodyohu̱ di tötehu̱ di ꞌbu̱hu̱ xiñho. Hinꞌö, hingi njapꞌu̱, ngetho xta möñhu̱, mahye̱gi di ohu̱ hár ꞌye̱ ar tsꞌoki, ya xodyo ne nuꞌu̱ hingya xodyo. ");
INSERT INTO otqNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ngu enga har tꞌofo: Hinjoꞌo nꞌar hogajöꞌi, hinjoꞌo nꞌamhö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Hinjoꞌo togo o̱de, hinjoꞌo togo honga Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Gatho bi hye̱pꞌu̱ ar hoga ꞌñu, nꞌatꞌwu̱ bi ntsꞌoki. Hinjoꞌo togo da ꞌyo̱tꞌa ar ñho, hinjoꞌo nꞌamhö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ngu nꞌar tꞌa̱gi xoxtho, njapꞌu̱ yá neꞌu̱. Nuyá jöhne kate, ha yá ne thente, ñhe̱hwi ár ngi nꞌar kꞌeñö po ha yá ne. ");
INSERT INTO otqNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Nuyá ne odar tsꞌate ne ar tso̱tꞌamu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Nuyá wa ntihi ma da xangar ji. ");
INSERT INTO otqNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Habu̱ gatho thogi, tso ar dumu̱i ne ar tsꞌoni; ");
INSERT INTO otqNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ne hinxi böꞌu̱ tengu ar hogamꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Hingi tsupa Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ne di pöhu̱, gatho nöꞌö mönga yá ꞌbe̱pate ar Moise, xipa nuꞌu̱ togo te̱ni. Njapꞌu̱ gatho hinte da tsa̱ te da dödi núꞌmu̱ xta thöꞌspa majöni. ");
INSERT INTO otqNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Hinto tsa̱ da tꞌembabi, hinte ma tsꞌoki tu hár nthandi Jö ngetho o̱tꞌa ngu mönga yá ꞌbe̱pate ar Moise. Nuya ꞌbe̱pate ho̱nse̱ jakagihu̱ ga pöhu̱ ma tsꞌokihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ha nupya xi tꞌutkagihu̱ hanja ga ꞌbu̱hwihu̱ xiñho Jö. Hinge ga ꞌbu̱hu̱ ga o̱thwu̱ yá ꞌbe̱pate ar Moise, mödi ja mönu̱, ne ha ya he̱ꞌmi bi ꞌyotꞌa maꞌra yá mꞌe̱hni Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Gatho nuꞌu̱ xi ñꞌemu̱i ar tsi Hmu Hesukristo, ꞌbu̱i xiñho hár nthandi Jö. Nöꞌö handgagihu̱ mahye̱gi di gathohu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ngetho gatho xi ntsꞌokte ne hindi ꞌñepi da hyandwa ár nsunda Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ha Jö xi ñꞌu ár nhwëki, ne bi nhugagihu̱ hinte ma tsꞌoki di tuhu̱. Gehnu̱ bi tꞌakthogihu̱, ngetho ar tsi Hmu Hesukristo bi zimgagihu̱ ha yá ꞌye̱ ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Gehnu̱ Jö bi ꞌye̱ntꞌa ngu nꞌar mꞌo̱ñho̱, da gutꞌwa yá tsꞌoki ya meximha̱i nuꞌmu̱ da jamfibi ár ñho ungár ji bi nöꞌmi. Njapꞌu̱ bi ñꞌu ár ñhogajöꞌi ne ár tsꞌe̱ti, himbi umbár mfe̱i ya jöꞌi xki ꞌyo̱tꞌa ya tsꞌoki mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Xki beñꞌö nda ñꞌudi nuya payu̱ ár hoga tsꞌu̱tꞌwi. Njapꞌu̱ xi nheki ár hogajöꞌinu̱, ne embabi hinte ma tsꞌoki tu gatho nuꞌu̱ ñꞌemu̱i ar tsi Hmu Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Hage da tsa̱ ga ñꞌexu̱ ꞌmu̱ handgagihu̱ xiñho Jö ngetho xta o̱thu̱ ya hoga ꞌbe̱fi. Hinꞌö, hinda tsa̱. Jö numañhogihu̱, ho̱nse̱ nuya xta ñꞌemu̱ihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Jange di pöhu̱, nunar meximha̱i nhu hinte ma tsꞌoki tu ngetho ñꞌemu̱i. Hingi nhumañho ngetho te̱mba yá ꞌbe̱pate ar Moise. ");
INSERT INTO otqNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Hage Jö ho̱nse̱ ár Jö ya xodyo. Hage hinge ár Jö nuꞌu̱ togo hingya xodyo nꞌehe. Hö, majöni yá me̱ti nuꞌu̱ hingya xodyo nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ngetho Jö nꞌase̱, ne ma da nu hinte ma tsꞌoki tu nuꞌu̱ togo pe̱ꞌsa ar nse̱gi ne ñꞌemu̱i. Njapꞌu̱tho ma da numañho nuꞌu̱ hinte pe̱ꞌsa ar nse̱gi ne da ñꞌemu̱i nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Hage nuꞌmu̱ di ñꞌemu̱ihu̱, hinte di nuhu̱ ya ꞌbe̱pate. Hinꞌö, di ñꞌuhu̱ pe̱ꞌsa yá nsu. ");
INSERT INTO otqNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Te ga beñhu̱ bi dinga ar Abra ꞌmu̱, ma palehu̱ mi ꞌbu̱ mamꞌe̱tꞌo. ");
INSERT INTO otqNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nuꞌmu̱ ar Abra bi nhu hinte ma tsꞌoki mi tu ngetho bi ꞌyo̱tꞌa ya hoga ꞌbe̱fi, tsa̱ da ꞌñexhmö ár nsu, ha nunu̱ hingi tsa̱ te da netebi Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ngetho te mönga har Tꞌofo. Ar Abra bi ñꞌemu̱ibi Jö, ne njapꞌu̱ bi nhu hinte ma tsꞌoki mi tu. ");
INSERT INTO otqNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ha nuꞌu̱ togo o̱tꞌa ya hoga ꞌbe̱fi, nunar nthöhö tꞌumbabi, hinge ntꞌuntho ꞌmu̱, ngetho xi döhö, ne da njutꞌwabi ngu nꞌar tha̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ha nuꞌu̱ togo ñꞌemu̱ibi Jö togo hökwa yá tsꞌoki ya tsꞌokte, nunar ñꞌemu̱inu̱ ma da japi da nhu hinte ma tsꞌoki tu, mödi hinte ma hoga ꞌbe̱fi xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Jangu ar Dabi bi no̱nga yá nza̱thomꞌu̱i nuꞌu̱ bi numañhobi Jö, mödi hinte ma hoga ꞌbe̱fi xi ꞌyo̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Bi ꞌñenö njawa: Nza̱thomꞌu̱i pe̱ꞌsa nuꞌu̱ togo xi mpumbabi yá tsꞌoki, ne xi njutꞌwabi yá tsꞌomꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Nza̱tho nuꞌu̱ togo ar tsi Hmu hinte ma tsꞌoki ho̱tsꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Hage nunar nza̱thomꞌu̱inu̱ ho̱nse̱ xi tꞌe̱kwa ya xodyo togo xi thuꞌspa ar nse̱gi, wa da tsa̱ da hñönga nu maꞌra hingya xodyo nꞌehe. Jangu xta eñhu̱, ar Abra bi ñꞌemu̱ibi Jö, jange bi nhu hinte ma tsꞌoki mi tu. ");
INSERT INTO otqNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Hanja bi nhumañho ꞌmu̱. Hage bi nhumañho ngetho xki thuꞌspa ar nse̱gi wa hinꞌö. Bi nhumañho hinxki thuꞌspatho. ");
INSERT INTO otqNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ar Abra mꞌe̱tꞌo bi gamfi, mꞌe̱fa bi hñönga ar nse̱gi. Gehnu̱ nꞌar ntꞌudi da̱majöni xki nhu hinte ma tsꞌoki mi tu ngetho xki ñꞌemu̱i núꞌmu̱ hinxki thuꞌspatho ar nse̱gi. Njapꞌu̱ ar Abra bi tꞌembabi ár dada gatho nuꞌu̱ hinxki thuꞌspa ar nse̱gi xta ñꞌemu̱i, ne nunar ñꞌemu̱inu̱ japi da nhu hinte ma tsꞌoki tu nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Njapꞌu̱ ár dada nꞌehe gatho nuꞌu̱ hinge ho̱nse̱ xi thuꞌspa ar nse̱gi, te̱mba ár mꞌu̱i xa mi ñꞌemu̱i ndu ma dadahu̱ ar Abra núꞌmu̱ hinxki thuꞌspathobi ar nse̱gi. ");
INSERT INTO otqNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Himbi ñhötꞌwabi ar Abra ne yá ꞌbe̱to nda hñönga ar ximha̱i nuꞌmu̱ nda de̱nga ya ꞌbe̱pate. Bi ñhötꞌwabi núꞌmu̱ mi nhumañhobi ár ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ngetho nuꞌmu̱ ma da tꞌumba ar ximha̱i nuꞌu̱ te̱nga ya ꞌbe̱pate, hinter me̱ꞌö ar ñꞌemu̱i ꞌmu̱, ne xi ꞌbe̱ ár tsꞌe̱di ár ñhötꞌi Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Nu habu̱ ja ya ꞌbe̱pate, ja bi ehnu̱ ár kwe̱ Jö. Ne habu̱ hiñꞌotho ya ꞌbe̱pate, hiñꞌotho hanja da me̱ꞌsku. ");
INSERT INTO otqNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Jange gatho nuꞌu̱ togo ñꞌemu̱i, ma da tꞌumba nöꞌö xi hwëkwa Jö, ne njapꞌu̱ gatho yá ꞌbe̱to ar Abra da zu̱ ar ñhötꞌi. Nunar ñhötꞌinu̱ ma da hñönga nuꞌu̱ yá ꞌbe̱to te̱nga ya ꞌbe̱pate, ne nuꞌu̱ te̱mba ár ñꞌemu̱i ar Abra togo ár dada nꞌa ne manꞌa. ");
INSERT INTO otqNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ngu xi ntꞌotꞌi: Nuga xta exꞌaꞌi ngu ár dada nze̱ye̱ ya jöꞌi. Jange nuju̱ yá bötsigihu̱ ar Abra hár nthandi Jö togo bi ñꞌemu̱iꞌö. Gehnu̱ ju̱xa nuꞌu̱ xi du, ne handa nöꞌö hinxi thoktho wande xi thoki. ");
INSERT INTO otqNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Mödi mar ñhembi nda ñꞌemu̱i, ar Abra bi do̱ꞌmi nda tho ngu xki ñhötꞌwabi. Njapꞌu̱ bi thutsꞌi ár dada nze̱ye̱ ya jöꞌi. Bi tꞌembabi: Ma da njapꞌu̱ ár nze̱ye̱ ri ꞌbe̱to. ");
INSERT INTO otqNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ne himbi wentꞌa ár ñꞌemu̱i núꞌmu̱ mi hyandi bi za̱ ár ndoꞌyo, mi pe̱ꞌsa ngu nꞌanthebe nje̱ye̱, ne mi pödi himi tsa̱ nda ñꞌo̱nte ar Sara. ");
INSERT INTO otqNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Himbi tsꞌoka ár mfeni nda ꞌñenö hinge nda ꞌyo̱tꞌa Jö ngu xki ñötꞌwabi. Nöꞌö bi me̱ꞌö, bi no̱xka ár ñꞌemu̱i, ne njapꞌu̱ bi nsundabi Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Xa xki zo hár mu̱i xiñho, mi pe̱ꞌsa ar tsꞌe̱di Jö nda ꞌyo̱tꞌa gatho nöꞌö xki ñötꞌwabi. ");
INSERT INTO otqNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Jange bi nhu hinte ma tsꞌoki mi tu, ngetho mi pe̱ꞌsa nunar ñꞌemu̱inu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Hinge ho̱nse̱ nda zu̱ ar Abra nöꞌö xi tꞌotꞌi bi nhu hinte ma tsꞌoki mi tu. ");
INSERT INTO otqNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Da nhugagihu̱ hinte ma tsꞌoki di tuhu̱ nꞌehe, núꞌmu̱ di ñꞌemu̱ihu̱ togo bi koꞌspa ár te ar Hesu ma tsi Hmuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Gehnu̱ bi nda̱, ne njapꞌu̱ bi gutꞌa ma tsꞌokihu̱. Ne bi mengi bi nte, njapꞌu̱ bi nhugagihu̱ hinte ma tsꞌoki di tuhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Xi nhugagihu̱ hinte ma tsꞌoki di tuhu̱ ngetho di ñꞌemu̱ihu̱. Jange di ꞌbu̱hwihu̱ xiñho Jö, ngetho bi mꞌa̱ made ma tsi Hmuhu̱ Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Númꞌu̱ nda ñꞌemu̱ihu̱, ba tsigagihu̱ nda zu̱kagihu̱ ár nhwëki Jö. Ne xa xta mꞌa̱thu̱, ne di johyahu̱ di to̱ꞌmhu̱ ga ꞌbu̱hu̱ hár nsunda. ");
INSERT INTO otqNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hinge ho̱nse̱ꞌö. Di johyahu̱ núꞌmu̱ di thohu̱ ya thogi nꞌehe, ngetho di pöhu̱ ar thogi fa̱xkagihu̱ ga pe̱ꞌsu̱ ar tsꞌe̱ti. ");
INSERT INTO otqNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ar tsꞌe̱ti fa̱xkagihu̱ ga thohu̱ xiñho xta tsꞌa̱tkagihu̱, ha nunar tsꞌa̱ti fa̱xkagihu̱ ga pe̱ꞌsu̱ ar ndo̱ꞌmi. ");
INSERT INTO otqNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ha nunar ndo̱ꞌmi hinda ꞌbe̱tka ma tsa̱hu̱, ngetho ár Hñö Jö xi tꞌakagihu̱ xi ñuska ma mu̱ihu̱ ár mhöte Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ar tsi Hmu Hesukristo núꞌmu̱ xki wentkathogihu̱, mi zo̱nga ar pa bi unga ár te bi po̱kagihu̱ ndar tsꞌoktehu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Xi ñhembi da thinga nꞌa togo ne da unga ár te da po̱ta nꞌar jöꞌi ꞌbu̱i xiñho. Ha nuꞌmu̱ di ꞌbu̱hmö nꞌa di ñꞌe̱ntꞌi da ne da po̱ta nꞌa xa dar hogajöꞌi. ");
INSERT INTO otqNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ha Jö bi ñꞌuse̱ hangu mökagihu̱, ngetho núꞌmu̱ ndar tsꞌoktehu̱, ar tsi Hmu Hesukristo bi unga ár te bi po̱kagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Xipyahmö, xi nhugagihu̱ hinte ma tsꞌoki di tuhu̱ ngetho bi nöꞌma ár ji, ne gatho nöꞌö bi me̱fi da jaju̱ ga kꞌonthu̱ ár kwe̱ Jö xi ꞌñepꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ngetho núꞌmu̱ ndar ñꞌu̱nihu̱ Jö, bi ñhogamu̱igihu̱ ár Tꞌu̱ núꞌmu̱ mi du. Xipyahmö, xta jwahu̱ xta ñhogamu̱iwihu̱, hage hinda po̱kagihu̱ ár te. ");
INSERT INTO otqNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Hinge ho̱nse̱ꞌö, di johyahu̱ di ꞌbu̱hwihu̱ Jö. Numa tsi Hmuhu̱ Hesukristo go bi mꞌa̱ madeꞌö, ne njapꞌu̱ da ñhogamu̱iwihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nuꞌmú̱, nꞌadar ñꞌo̱ho̱ bi ku̱tꞌa ar tsꞌoki har ximha̱i, ne har tsꞌoki bi yu̱tꞌa ar ndöte. Ne ar ndöte bi nexa gatho ya jöꞌi, ngetho gatho bi ntsꞌokte. ");
INSERT INTO otqNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Númꞌu̱ hinxki tꞌunda yá ꞌbe̱pate ar Moise, mi jar tsꞌoki har ximha̱i. Ho̱nse̱ nu habu̱ hiñꞌotho ya ꞌbe̱pate, hinte ma tsꞌoki tho̱xa nꞌa. ");
INSERT INTO otqNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Mödi njapꞌu̱, ar ndöte xki ntöte mi tsixa gatho nuꞌu̱ xki ntsꞌokte, mödi nuyu̱ hinxki de̱mbahmö ár mhe̱ꞌsku ar Adan. Bi ndu̱i nuya pa mi ꞌbu̱ ar Adan, ne mi njapꞌu̱tho nuya pa mi ꞌbu̱ ar Moise. Ha nunar Adan nu̱, gehnu̱ ngu nꞌar ntꞌudi nöꞌö togo ma nda e mꞌe̱fa. ");
INSERT INTO otqNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nuna ár mhe̱ꞌsku ar Adan himi tsa̱ nda ñhuxkwi ár ntꞌuni hwëgagihu̱ Jö. Ngetho ár njutꞌi ar mhe̱ꞌsku, ba e ar ndöte bi zu̱ nze̱ye̱. Ha nunár nhwëki ne ár ntꞌuni Jö bi hyexta nuya nze̱ye̱yu̱, gehnu̱ ár nhwëki nuna nꞌadar ñꞌo̱ho̱nu̱, ar tsi Hmu Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nunár tsꞌoki nꞌadar ñꞌo̱ho̱, hingi tsa̱ da ñhe̱xkwi ár nhwëki Jö. Ngetho nunar nꞌadar tsꞌokinu̱, ba tsimpar mfe̱i bi zu̱ ya meximha̱i. Ha nuna ár nhwëki Jö ba e bi zu̱ ya meximha̱i, ne bi tꞌembi hinte ma tsꞌoki tu, mödi xi ꞌyo̱tꞌa nze̱ye̱ ya tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nunár tsꞌoki nuna nꞌadar ñꞌo̱ho̱, bi japi bi ntöte ar ndöte. Ha nunár ꞌbe̱fi nuna manꞌa nꞌase̱ ar ñꞌo̱ho̱, japi da mꞌu̱ xiñho ya meximha̱i, nuꞌu̱ togo xi hyexta ár nhwëki Jö ne ár ntꞌuni, gehyu̱ xi numañho Jö. Nuna nꞌase̱ ar ñꞌo̱ho̱nu̱, gehnu̱ ar Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nunár tsꞌoki nꞌadar ñꞌo̱ho̱ bi ku̱tꞌa ar mfe̱i, bi zu̱ gatho ya meximha̱i. Njapꞌu̱tho nꞌehe, nunár hogamꞌu̱i nꞌadar ñꞌo̱ho̱, nda nhu hinte ma tsꞌoki tu gatho ya meximha̱i nꞌehe, ne da me̱ꞌsyu̱ ar te. ");
INSERT INTO otqNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ngetho njangu ár mhe̱ꞌsku nꞌadar ñꞌo̱ho̱, gatho ya jöꞌi bi tꞌembabi ya tsꞌokte. Njapꞌu̱tho nꞌehe nunár ntꞌo̱de nꞌar ñꞌo̱ho̱, gatho bi nhu hinte ma tsꞌoki mi tu. ");
INSERT INTO otqNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Nuya ꞌbe̱pate bi tꞌuni, ne njapꞌu̱ nda xönda ar tsꞌoki. Ha núꞌmu̱ mi xönda ar tsꞌoki, xa bi ntöte bi xu ár nze̱ye̱ ár nhwëki Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Njangu ar tsꞌoki bi ntöte, bi nja ar ndöte, njapꞌu̱ ár nhwëki Jö bi ntöte, bi nhu hinte ma tsꞌoki tu ya jöꞌi. Ne da me̱ꞌsa ar te hiñhamꞌu̱ da götsꞌi har ꞌbe̱fi bi ꞌyo̱tꞌa ma tsi Hmuhu̱ ar Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Te ga möñhu̱ ꞌmu̱. Hage ga ꞌbu̱hu̱ har tsꞌoki, ga to̱ꞌmhu̱ da hyexkathogihu̱ ár nhwëki Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Hinꞌö, hinga njahu̱pꞌu̱. Ngetho ar tsꞌoki handgagihu̱ wande xta tuhu̱, hage ma ga ꞌbu̱thu̱ ga o̱thu̱ nöꞌö hingi ho ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Wa hingi pöhu̱, gatho nuꞌu̱ xi xixthegihu̱, di nꞌatꞌwihu̱ ar tsi Hmu Hesukristo. Po̱ntho da nxixthewihu̱ núꞌmu̱ mi du, ne da tuhu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ngetho núꞌmu̱ da nxixthehu̱, po̱ntho bi thogagihu̱ mahye̱giwi ar Kristo. Ha núꞌmu̱ mi mengi bi nte manꞌagi, bi gu̱xa ár tsꞌe̱di ár Dada, njapꞌu̱ nuju̱ nꞌehe, ga ꞌbu̱hu̱ nꞌar ꞌraꞌyo mꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ngetho núꞌmu̱ ndi hñöxkagihu̱ hár ndöte, njapꞌu̱ ndi hñöxkagihu̱ hár menga nte nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Di pöhu̱ ꞌmu̱, numa ꞌbe̱tꞌo mꞌu̱ihu̱ bi tsꞌu̱ta har pontꞌi mahye̱giwiꞌö. Ne njapꞌu̱ nunar mꞌu̱inu̱ bi nhwati, hinda mengi da me̱pa ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Jangu nuꞌu̱ xi du, hinte tsa̱ te da japabi ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ha nuꞌmu̱ xta tuwihu̱ mahye̱gi ar tsi Hmu Hesukristo, di ñꞌemu̱ihu̱ ma ga ꞌbu̱hwihu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Di pöhu̱, ar Kristo mi nte manꞌagi, hinda mengi da du. Ha nunar ndöte hinte tsa̱ te da japabi. ");
INSERT INTO otqNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ngetho nunár ndöte bi hwata ar tsꞌoki nꞌagitho. Ha nupya te, ꞌbu̱hwi Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Njapꞌu̱ nuꞌahu̱, beñhu̱ nunar tsꞌoki hantꞌaꞌihu̱ wande xka tuhu̱. Ne gi tehu̱ gi pe̱fu̱ Jö, gi ꞌbu̱hwihu̱ ma tsi Hmuhu̱ Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Yo ma gi ñhe̱hu̱ da dö ar tsꞌoki ri ndoꞌyohu̱ tso̱nga ár ngötsꞌi. Jange yo gi o̱thwu̱ ya tsꞌoki ne. ");
INSERT INTO otqNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Hingi ꞌye̱nthu̱ ri ndoꞌyohu̱ da me̱pabi ar tsꞌoki. ꞌYe̱ntꞌase̱ ri tehu̱ hár ꞌye̱ Jö, ngu nꞌa xi mengi xi nte, ne japi da me̱ nöꞌö xiñho. ");
INSERT INTO otqNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ngetho ar tsꞌoki hinda hyo̱pꞌahu̱ ha̱i. Hingi gu̱ñꞌahu̱pya yá ꞌbe̱pate ar Moise. Nupya tsixꞌahu̱ ár nhwëki Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Xiꞌmu̱, hage ga o̱thu̱ ya tsꞌoki ngetho hindi ꞌbu̱hu̱ ha yá ꞌbe̱pate ar Moise, di ꞌbu̱hu̱ hár nhwëki Jö. Hinꞌö, hingi njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Hage hingi pöhu̱, nuꞌmu̱ gi ñhe̱hu̱ gi mꞌe̱gohu̱ gi pe̱fu̱ nꞌa, go ár ꞌbe̱goꞌihu̱ togo gi o̱thu̱. Wa ar tsꞌoki tsixꞌahu̱ har ndöte, wa Jö da ma̱xꞌahu̱ gi ꞌbu̱hu̱ xiñho. ");
INSERT INTO otqNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Jamödi Jö, mödi ngar ꞌbe̱goꞌihu̱hmö ar tsꞌoki, xka umba ri mu̱ihu̱ xka te̱ñhu̱ nunar mhönu̱ xi tꞌaꞌahu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ne bi nju̱kꞌahu̱ har tsꞌoki, ne gi pe̱fu̱ ar ñhopya. ");
INSERT INTO otqNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Xta he̱kwa nöꞌö gi hanthu̱ hyaxꞌmu̱, ne njapꞌu̱ da zo ri mfenihu̱. Mahamꞌu̱ ngi e̱ntꞌa ri ndoꞌyohu̱ nda me̱pa nöꞌö hingi ho ne nöꞌö xintsꞌotho. ꞌYe̱nthu̱pya da me̱pa nöꞌö xiñho, ne njapꞌu̱ gi ꞌbu̱hu̱ nꞌar mꞌu̱i xintꞌaxi. ");
INSERT INTO otqNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ngetho núꞌmu̱ ngi pe̱fu̱ ar tsꞌoki, hinge ngi pe̱fu̱ ar ñho. ");
INSERT INTO otqNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Tema ñho ga ju̱jwu̱ nöꞌö ngi pe̱hu̱ ꞌbe̱tꞌa ri tsa̱hu̱pya. Ngetho nunar njutꞌi ngi to̱ꞌmhu̱, gehnu̱ ar ndöte. ");
INSERT INTO otqNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ha nupya xi nju̱kꞌahu̱ har tsꞌoki, ne ár ꞌbe̱goꞌihu̱ Jö, gi pe̱ꞌsu̱ ar mꞌu̱i xintꞌaxi ngu ri nthöhöhu̱. Ne ár ngötsꞌi gi to̱ꞌmhu̱ ar te hiñhamꞌu̱ da thege. ");
INSERT INTO otqNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nunár njutꞌi ar tsꞌoki, ar ndöte. Ha nor ntꞌuni Jö, ar te hiñhamꞌu̱ da götsꞌi, ngetho di ꞌbu̱hwihu̱ ma tsi Hmuhu̱ Hesukristo. ");
INSERT INTO otqNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Tsi kuhu̱, gi pöhu̱ ya ꞌbe̱pate, jange gi pöhu̱ nuya ꞌbe̱pateyu̱ ho̱nse̱ pe̱ꞌsa ar tsꞌe̱di ha nꞌar jöꞌi tetho. ");
INSERT INTO otqNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Njangu nꞌar ꞌbe̱hñö, nuya ꞌbe̱pate hingi umba ar se̱ki da hye̱ ár döme núꞌmu̱ tetho. Ha nuꞌmu̱ da du ár döme, da mꞌe̱ ár tsꞌe̱di nunar nkohi mi te̱tꞌö. ");
INSERT INTO otqNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Jange nuꞌmu̱ ꞌbu̱ta ár döme, ne da me̱wi manꞌar ñꞌo̱ho̱, da nhu ngu nꞌar zinganthöti. Ha nuꞌmu̱ da du ár döme, ne da me̱wi manꞌar ñꞌo̱ho̱, njapꞌu̱ hingi tsꞌoka nor nkohiꞌö, hinda nhu ngu nꞌar zinganthöti. ");
INSERT INTO otqNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Njapꞌu̱pya tsi kuhu̱, núꞌmu̱ nga tuwihu̱ ár ndoꞌyo ar tsi Hmu Hesukristo, ga hye̱hu̱pꞌu̱ ngi te̱ñhu̱ ya ꞌbe̱pate. Gi ꞌbu̱hwihu̱pya manꞌa nunu̱ togo bi mengi bi nte, ne da tsa̱ gi ꞌyo̱thu̱ ya hoga ꞌbe̱fi gi e̱nthwu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ngetho núꞌmu̱ ndi ꞌbu̱hu̱ nga o̱thu̱ gatho nöꞌö ndi nehu̱, ar tsꞌoꞌyotsꞌoki mi jakagihu̱ nga o̱thu̱ nöꞌö mi högagihu̱ ya ꞌbe̱pate. Ne nuya tsꞌoꞌbe̱fiyu̱ ndi o̱thu̱, ho̱nse̱ ndi to̱ꞌmhu̱ ar ndöte nda tꞌakagihu̱ ngu ma njutꞌihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ha nupya hindi ohu̱ hár ꞌye̱ ya ꞌbe̱pate, ngetho po̱ntho xta tuhu̱, ne hinte tsa̱ te da jakagihu̱. Jange di pe̱fu̱ Jö ha nunar ꞌraꞌyo mꞌu̱i bi ꞌrakagihu̱ ár Hñö Jö, ne hindi te̱nthu̱ nuya ꞌbe̱pate xi tꞌotꞌi xi ndönziatho. ");
INSERT INTO otqNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Te da tsa̱ ga möñhu̱ ꞌmu̱. Hage nꞌar tsꞌoki da tꞌo̱tꞌa ya ꞌbe̱pate ꞌmu̱. Hinꞌö, hingi njapꞌu̱. Ho̱nse̱ nuga, nuya ꞌbe̱pate bi utkar tsꞌoki. Ngetho hinga pöhmö ga ꞌbe̱nte nuꞌmu̱ hinxi xika ya ꞌbe̱pate: Yo ma gi ꞌbe̱nte. ");
INSERT INTO otqNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ha nor tsꞌoki bi gu̱ ar ꞌbe̱pate ne bi jakagi da ꞌbe̱nte. Ngetho nuꞌmu̱ hindi othohmö ar ꞌbe̱pate, ar tsꞌoki xi mꞌe̱tho. ");
INSERT INTO otqNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nuga ndi tehmö ꞌra ya tsi pa, hinge ndi pöta ya ꞌbe̱pate. Ha mi zo̱ ya ꞌbe̱pate, da pödi tema ar tsꞌoki. Ne po̱ntho da tuga, ngetho da tsꞌoka ya ꞌbe̱pateyu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ne da timbi nunar ꞌbe̱pate xki ñötkagi ar te, bi jakagi da tu. ");
INSERT INTO otqNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ngetho ar tsꞌoki bi gu̱ ar ꞌbe̱pate bi kakagi, ne njapꞌu̱ bi hyogagi. ");
INSERT INTO otqNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Xa majöni ar tꞌofo ne ya ꞌbe̱pate xintꞌaxi, o̱tꞌar ñho ne fa̱xkagihu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Hage nöꞌö mar ñhomhö bi jakagi da tu ꞌmu̱. Hinꞌö, hingi njapꞌu̱. Nunar tsꞌoki bi ñꞌudi tenguꞌö, bi gu̱ nöꞌö mar ñho, bi jakagi da tu. Ne njapꞌu̱ nunar ꞌbe̱pate bi utkagi hangu ár ntsꞌotho ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ngetho di pöhu̱, nuya ꞌbe̱pate xpa e mhetsꞌi, ha nuga dar meximha̱i, di pe̱par tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Hindi pödi tema di pe̱fi. Ngetho hindi o̱tꞌa nöꞌö di ne, ne di o̱tꞌa nöꞌö di u̱tsa ga o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Nuꞌmu̱ nöꞌö hindi ne ga o̱tꞌe, go di pe̱ꞌö, di etꞌa ma mu̱i xiñho ya ꞌbe̱pate. ");
INSERT INTO otqNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Hingo geke togo te gatho o̱tꞌmu̱, go o̱tꞌa ar tsꞌoki di pe̱ꞌsa mbo. ");
INSERT INTO otqNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ne di pödi hingi ꞌbu̱ ar ñho ha ma ndoꞌyo, ngetho di bemhö ga o̱tꞌa xiñho, ne hindi o̱tꞌa njapꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ngetho hindi o̱tꞌa nöꞌö ar ñho di nemhö ga o̱tꞌe. Ha xa di o̱tꞌa nöꞌö hingi ho, hindi nemhö ga o̱tꞌe. ");
INSERT INTO otqNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nuꞌmu̱ di o̱tꞌa nöꞌö hindi ne, hingo di o̱tga ꞌmu̱, go o̱tꞌa ar tsꞌoki di pe̱ꞌsa mbo. ");
INSERT INTO otqNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ngetho di nemhö ga o̱tꞌa nöꞌö xiñho, ne di handi ꞌyoda ar tsꞌoki ha ma mu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ngetho mbo ha ma mu̱i xa di johya di ne ga te̱mba ár ꞌñu Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ne di handi nꞌehe, nuna ma ndoꞌyo nto̱xkwi ma mfeni, ne tsixkagi hár ꞌye̱ ar tsꞌoki di ꞌbu̱ꞌbe. ");
INSERT INTO otqNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Hwëkategi. Togo da gu̱gagi ga he̱ nunar ndoꞌyonu̱ tsixka har ndöte. ");
INSERT INTO otqNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Di umba njamödi Jö, bi ñöngagi har ꞌbe̱fi bi me̱ ma tsi Hmuhu̱ Hesukristo. Gekase̱, ha ma mfeni di pe̱pa Jö, mödi ma ndoꞌyo pe̱pa ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nupya hinte ma mfe̱i to̱ꞌma nuꞌu̱ togo ꞌbu̱hwi ar tsi Hmu Hesukristo, ne o̱tꞌa ngu xipa ár Hñö Jö, hinge ngu nese̱ꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ngetho di ꞌbu̱hwihu̱ ar tsi Hmu Hesukristo, nu ár Hñö Jö togo unga ar te, xi gu̱gagihu̱ ndi ohu̱ hár ꞌye̱ ar tsꞌoki ne ar ndöte. ");
INSERT INTO otqNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nöꞌö himbi tsa̱ bi ꞌyo̱tꞌa ya ꞌbe̱pate, ngetho ya meximha̱i himi otho yá tsꞌe̱di nda ꞌyo̱tꞌe, jange gese̱ Jö ba pe̱hna ár Tꞌu̱, jangutho nꞌar meximha̱i mi tsa̱hmö nda ꞌyo̱tꞌa ar tsꞌoki. Nunu̱ bi unga ár te bi hñömba ár tsꞌe̱di ar tsꞌoki. ");
INSERT INTO otqNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Njapꞌu̱ bi tsa̱ ndar hogajöꞌihu̱ ngu a̱kagihu̱ ya ꞌbe̱pate. Ngetho hindi ꞌyohu̱ ngu di nese̱hu̱, di ꞌyohu̱ ngu ne ár Hñö Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ngetho nuꞌu̱ togo ꞌbu̱ ngu ne yá mfenise̱, ho̱nse̱nu̱ beni. Ha nuꞌu̱ togo da̱twa yá mfeni ár Hñö Jö, ho̱nse̱nu̱ beñꞌu̱ nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nuꞌu̱ togo pe̱pa yá mfenise̱, ma da dinga ar ndöte. Ha nuꞌu̱ togo pe̱pa ár Hñö Jö, ma da dinga ar te ne ar hogamꞌu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Nuꞌu̱ ꞌbu̱ ngu ne yá mfenise̱, nto̱xkwi Jö, ngetho hingi ne, ne hingi tsa̱ da ꞌyo̱twa yá ꞌbe̱pate möñꞌö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ne nuꞌu̱ togo ꞌbu̱ ngu neꞌu̱, Jö hinda tsa̱ da numañhobi yá teꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ha nuꞌahu̱ hingi pe̱fu̱ ri mfenise̱hu̱, gi pe̱fu̱ ár Hñö Jö ꞌbu̱ ha ri mu̱ihu̱, nuꞌmu̱ majöni ꞌbu̱hnu̱. Ha nuꞌmu̱ nꞌa hingi pe̱ꞌspa ár Hñö ar tsi Hmu Hesukristo, hingo ár me̱tiꞌö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ha nuꞌmu̱ ar tsi Hmu Hesukristo ꞌbu̱ ha ri mu̱ihu̱, mödi ri ndoꞌyohu̱ ꞌbu̱tho xi du har tsꞌoki, nuri hñöhu̱ te, ngetho gi ꞌbu̱hwihu̱ xiñho Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Nuꞌmu̱ ꞌbu̱ ha ri mu̱ihu̱ ár Hñö Jö togo bi koꞌspa ár te ar tsi Hmu Hesukristo, Jö, ngu bi gu̱xa ar tsi Hmu, njapꞌu̱ da umba nꞌar ꞌraꞌyo te ri ndoꞌyohu̱ xi du. Da njapꞌu̱ ngetho gi ꞌbu̱hwihu̱ ár Hñö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Jange tsi kuhu̱, hindi ꞌñepi ga pe̱fu̱ gatho nöꞌö ne ma ndoꞌyohu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ngetho nuꞌmu̱ gi ꞌbu̱hu̱ ngu xiꞌahu̱ ri mfenise̱hu̱, ma gi tuhu̱. Ha nuꞌmu̱ gi ꞌbu̱hu̱ ngu utꞌahu̱ ár Hñö Jö, gi jafu̱ da mꞌe̱ nöꞌö ne ar ndoꞌyo, ne gi pe̱ꞌsu̱ ar te. ");
INSERT INTO otqNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ngetho nuꞌu̱ togo tsixa ár Hñö Jö, go yá bötsi Jöꞌu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Hinxta höñhu̱ ár Hñö Jö ne ga penju̱ ga ntsuhu̱. Xta höñhu̱ ár Hñö Jö xi jakagihu̱ yá tedegihu̱ Jö. Jange di emfu̱pya: Ma tsi Dadaꞌi. ");
INSERT INTO otqNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ár Hñö Jö da̱twa majöni ma hñöse̱hu̱, ne embabi yá bötsigihu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ha nuꞌmu̱ yá bötsigihu̱, ma da ꞌraju̱ nuya ñho xi ñötkagihu̱, ne ga ñhehwihu̱ ar tsi Hmu Hesukristo. Ngetho nuꞌmu̱ ga thohu̱ ya thogi ngu bi thoꞌö, ma ga ꞌbu̱hwihu̱ hár nsunda. ");
INSERT INTO otqNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Di pöka xiñho, nuya thogi di thohu̱pya, hinter me̱ꞌö nuꞌmu̱ ga he̱jwu̱ ar nsunda di to̱ꞌmhu̱ ga hanthu̱ mꞌe̱fa. ");
INSERT INTO otqNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Gatho nöꞌö xi hyoka ár ꞌye̱ Jö, to̱ꞌma ar pa da hyanda ar tsi Dada da ñꞌu yá bötsi. ");
INSERT INTO otqNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ngetho gatho nöꞌö bi hyoka ár ꞌye̱ Jö, bi ꞌbe̱ ar ꞌñu nöꞌö nda me̱fi. Hingo bi nese̱ nda njapꞌu̱, bi ne Jö togo bi umba ar ndo̱ꞌmi nꞌehe. ");
INSERT INTO otqNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Gatho nöꞌö bi hyoka ár ꞌye̱ Jö, ma da thökwabi nunar tsꞌe̱di japabi da nhwati, ne da njohyawi xta hñönga ár nsunda yá bötsi Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ngetho di pöhu̱, gatho nöꞌö bi hyoka Jö, ꞌrangutho xa hu̱ ár ñö hinxi ntsa̱ya̱ xi nzoñꞌu̱, ntsa̱wi ar u̱gi ngu nꞌar ꞌbe̱hñö ma da da̱ ár bötsi. ");
INSERT INTO otqNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ne hinge ho̱nse̱ꞌu̱. Gese̱gihu̱ nꞌehe, togo xi tꞌakagihu̱ ár Hñö Jö ngu nꞌar nkohi nöꞌö da tꞌakagihu̱ mꞌe̱fa. Ne di zoñhu̱ tu ma mu̱ihu̱ di to̱ꞌmhu̱ da tekagihu̱ Jö, ne da ꞌrakagihu̱ nꞌar ꞌraꞌyo ndoꞌyo hinda du. ");
INSERT INTO otqNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ngetho núꞌmu̱ nda mpo̱hu̱, gehnu̱ di to̱ꞌmhu̱. Ha nuꞌmu̱ gar hanthu̱hmö, hingar ndo̱ꞌmi. Hinto to̱ꞌma nöꞌö pe̱tsꞌi. ");
INSERT INTO otqNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ha nuꞌmu̱ di to̱ꞌmhu̱ nöꞌö hindi hanthu̱, ga tse̱thu̱ ga to̱ꞌmhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Njapꞌu̱tho ár Hñö Jö togo fa̱xkagihu̱ hinte ja ma tsꞌe̱dihu̱. Ngetho hindi pöhu̱ ga a̱hu̱ ngu di ꞌñepi. Gese̱ꞌö xa hu̱ ár ñö zoni, ꞌba̱ made a̱pkagihu̱ tema di hoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ne Jö togo hetꞌwa yá mu̱i ya jöꞌi, pödi tema ne ár Hñö Jö. Ngetho nunu̱ a̱pkagihu̱ ngu benga Jö xiñho da umba yá bötsi xi ñꞌemu̱i. ");
INSERT INTO otqNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Di pöhu̱, nuꞌu̱ togo mö Jö, gatho nöꞌö te thogi fa̱tsꞌi di ꞌñepa ar ñho, gehyu̱ togo xi tsꞌofo ngu xi benga Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Nuꞌu̱ xki bödi nda mpo̱ho̱ núꞌmu̱ hinxki thokta ar ximha̱i, gehyu̱ bi hñutsꞌi nda ñhe̱hwi ár Tꞌu̱, togo nda ñöxhmu gatho ya ku. ");
INSERT INTO otqNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ha nuꞌu̱ togo xki hñutsꞌi, gehyu̱ bi zohni. Ha nuꞌu̱ togo bi zohni, gehyu̱ bi nu hinte ma tsꞌoki mi tu. Ha nuꞌu̱ togo bi nu hinte ma tsꞌoki mi tu, gehyu̱ togo bi umbi nda mꞌu̱ hár nsunda. ");
INSERT INTO otqNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Tema da tsa̱ ga möñhu̱ ꞌmu̱. Nuꞌmu̱ di ꞌbu̱hwihu̱ Jö, togo tsa̱ te da jakagihu̱ ꞌmu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Jö togo himbi ꞌyo̱tꞌa ár ꞌñöngi bi da̱ ár Tꞌu̱ bi po̱kagihu̱, hage hinda ꞌrakagihu̱ mahye̱giwi ár Tꞌu̱ gatho nöꞌö di hoñhu̱. ");
INSERT INTO otqNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Togo tsa̱ te da hyo̱xa nuꞌu̱ togo xi hwahna Jö, nuꞌmu̱ gese̱ Jö xi nu hinte ma tsꞌoki mi tu. ");
INSERT INTO otqNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Hage ꞌbu̱ manꞌa togo da hñuxhmö ar mfe̱i. Ar tsi Hmu Hesukristo bi unga ár te. Hinge ho̱nse̱ꞌö, getꞌö togo bi mengi bi nte, ne bi huxkwi ár Dada hár ñꞌe̱i, habu̱ bi ꞌba̱ made a̱pkagihu̱ Jö. ");
INSERT INTO otqNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Hiñꞌotho te da japa ma tsi Hmuhu̱ Hesukristo da hye̱gi da mökagihu̱. Wa di thohu̱ ar thogi, ar dumu̱i, ar ntꞌu̱tsa, ar thuhu, ar kꞌatꞌa he. Núꞌmu̱ ꞌbu̱tho da thöga ma tehu̱, wa ñhötju̱ ar jwai. ");
INSERT INTO otqNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ngu enga har Tꞌofo: Ngetho di te̱ñꞌahe, hyaxꞌmu̱ ꞌ