﻿USE sofia;
DROP TABLE IF EXISTS sofia.otnNT_vpl;
CREATE TABLE otnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES otnNT_vpl WRITE;
INSERT INTO otnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ja ua ra̱ lista ngue yø mboxita ra̱ Jesucristo, guehna̱ ra̱ mbom'mɛto na̱ ngue ra̱ David. Ra̱ David, ra̱ mbom'mɛto na̱ ngue ra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ra̱ Abraham, ra̱ papá na̱ ngue ra̱ Isaac. Ra̱ Isaac, ra̱ papá na̱ ngue ra̱ Jacob. Ra̱ Jacob, ra̱ papá na̱ ngue ra̱ Judá co 'nɛ̱'ʉ mi̱'da yø n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ra̱ Judá, ra̱ papá na̱ ngue ra̱ Fares 'nɛ̱hra̱ Zara. Nu̱ ra̱ mamá ya yonc'ɛ̱i̱ ya, ni̱ hu̱ ngue ra̱ Tamar. Ra̱ Fares, ra̱ papá na̱ ngue ra̱ Esrom. Ra̱ Esrom, ra̱ papá na̱ ngue ra̱ Aram. ");
INSERT INTO otnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ra̱ Aram, ra̱ papá na̱ ngue ra̱ Aminadab. Ra̱ Aminadab, ra̱ papá na̱ ngue ra̱ Naasón. Ra̱ Naasón, ra̱ papá na̱ ngue ra̱ Salmón. ");
INSERT INTO otnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ra̱ Salmón, ra̱ papá na̱ ngue ra̱ Booz. Nu̱ ra̱ mamá na̱ ra̱ Booz ni̱ hu̱ ngue ra̱ Rahab. Ra̱ Booz, ra̱ papá na̱ ngue ra̱ Obed. Nu̱ ra̱ mamá na̱ ra̱ Obed, ni̱ hu̱ ngue ra̱ Rut. Ra̱ Obed, ra̱ papá na̱ ngue ra̱ Isaí. ");
INSERT INTO otnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ra̱ Isaí, ra̱ papá na̱ ngue ra̱ da̱st'abi David. Ra̱ David, ra̱ papá na̱ ngue ra̱ Salomón. Nu̱ ra̱ mamá na̱ ra̱ Salomón, gue'a̱ ra̱ 'danxu̱ ma̱rá̱ xisu ndu̱ ra̱ Urías, bi̱ ntha̱tui ra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ra̱ Salomón, ra̱ papá na̱ ngue ra̱ Roboam. Ra̱ Roboam, ra̱ papá na̱ ngue ra̱ Abías. Ra̱ Abías, ra̱ papá na̱ ngue ra̱ Asa. ");
INSERT INTO otnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ra̱ Asa, ra̱ papá na̱ ngue ra̱ Josafat. Ra̱ Josafat, ra̱ papá na̱ ngue ra̱ Joram. Ra̱ Joram, ra̱ papá na̱ ngue ra̱ Uzías. ");
INSERT INTO otnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ra̱ Uzías, ra̱ papá na̱ ngue ra̱ Jotam. Ra̱ Jotam, ra̱ papá na̱ ngue ra̱ Acaz. Ra̱ Acaz, ra̱ papá na̱ ngue ra̱ Ezequías. ");
INSERT INTO otnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ra̱ Ezequías, ra̱ papá na̱ ngue ra̱ Manasés. Ra̱ Manasés, ra̱ papá na̱ ngue ra̱ Amón. Ra̱ Amón, ra̱ papá na̱ ngue ra̱ Josías. ");
INSERT INTO otnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ra̱ Josías, ra̱ papá na̱ ngue ra̱ Jeconías co 'nɛ̱hmi̱'da yø n'yohʉ. Gue'a̱ ra̱ pa'a̱ ngue yø judío bi̱ ma ma̱bɛnt'i̱, bi ts'its'i i̱ map'ʉ ja ra̱ häi Babilonia. ");
INSERT INTO otnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","M'mɛfa p'ʉya ra̱ Jeconías, ra̱ papá na̱ ngue ra̱ Salatiel. Ra̱ Salatiel, ra̱ papá na̱ ngue ra̱ Zorobabel. ");
INSERT INTO otnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ra̱ Zorobabel, ra̱ papá na̱ ngue ra̱ Abiud. Ra̱ Abiud, ra̱ papá na̱ ngue ra̱ Eliaquim. Ra̱ Eliaquim, ra̱ papá na̱ ngue ra̱ Azor. ");
INSERT INTO otnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ra̱ Azor, ra̱ papá na̱ ngue ra̱ Sadoc. Ra̱ Sadoc, ra̱ papá na̱ ngue ra̱ Aquim. Ra̱ Aquim, ra̱ papá na̱ ngue ra̱ Eliud. ");
INSERT INTO otnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ra̱ Eliud, ra̱ papá na̱ ngue ra̱ Eleazar. Ra̱ Eleazar, ra̱ papá na̱ ngue ra̱ Matán. Ra̱ Matán, ra̱ papá na̱ ngue ra̱ Jacob. ");
INSERT INTO otnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ra̱ Jacob, ra̱ papá na̱ ngue ra̱ José, nu̱na̱ rá̱ da̱mme ra̱ Ma̱ya. Guehna̱ ra̱ Ma̱ya rá̱ mamá ra̱ Jesús. A nu̱na̱ ra̱ Jesús, ni̱ hu̱ ngue ra̱ Cristo, guehna̱ bá̱ t'ɛ̱ts'i̱ ngue di̱ nda̱st'abi. ");
INSERT INTO otnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ja̱na̱ngue 'dɛ'ma̱ goho yø papá bi̱ m'mʉi ngue bi̱ m'mʉhyø ba̱si̱, bá̱ fʉdi ngue ra̱ Abraham asta̱ ra̱ David. 'Dɛ'ma̱ goho yø papá bi̱ m'mʉi, bá̱ fʉdi ngue ra̱ David asta̱ gue'mø mi̱ mbɛntyø judío ngue bi ts'ixpʉ ja ra̱ häi Babilonia. Bá̱ fʉ'ʉ yø pa'ʉ p'ʉya ngue bi̱ m'mʉhmi̱ 'dɛ'ma̱ goho yø papá asta̱ gue'mø mi̱ m'mʉhra̱ Cristo. ");
INSERT INTO otnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ngu̱na̱ bá̱ njap'ʉ bá̱ mi̱hra̱ Jesucristo. Nu̱na̱ ra̱ Ma̱ya ya xi̱ nhohra̱ hya̱ ngue di̱ ntha̱tui ra̱ José. Pɛ hante ngue da̱ mɛ, ya mi̱ ha̱ rá̱ ba̱si̱. Pɛ ra̱ Espíritu Santo'a̱ bi japi ngue bi hya̱ rá̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A nu̱na̱ ra̱ José, ya ja ngue da̱ 'yøt'e ngue rá̱ da̱mme. Mi̱ zä mi̱ ba̱di̱ ngue ya ha̱ rá̱ ba̱si̱ ra̱ Ma̱ya, bi̱ ne ra̱ José ngue xta̱ 'yøt'e te mma̱mp'ʉ ja ra̱ ley ngue xti̱ nxu̱mmi̱ rá̱ xisu. Pɛ hi̱mbi̱ nepe xta̱ mba̱di̱ xa̱ngu̱ yø ja̱'i̱ te xta̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mɛ̱nte di̱ n'yomfɛ̱ni̱ te ja ngue da̱ 'yørbʉya, nu̱'mø mi̱ n'a̱ha̱, bi̱ nu̱ n'na rá̱ anxɛ Oja̱ 'mø mi̱ n'ui̱. Bi 'yɛ̱mbi̱: ―Ague José rá̱ mbom'mɛto'i ra̱ David, oguí su̱ guí̱ mmɛ'a̱ ni̱ xisu ra̱ Ma̱ya. Porque nu̱'a̱ rá̱ ba̱si̱ ha̱'a̱, gue'a̱ ra̱ Espíritu Santo bi japi bi hya̱ rá̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nu̱na̱ ra̱ Ma̱ya, di̱ m'mʉ'a̱ n'na rá̱ ts'ʉnt'ʉ 'nɛ̱ gdi hu̱ti̱ ngue ra̱ Jesús. Porque nu̱ná̱, guehna̱ da̱ ya̱nyø ja̱'i̱ ja yø ts'oqui na̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ya bi̱ nja gätho ya yø hya̱ ya para ngue di̱ nja'a̱ te ra̱ hya̱ bi bɛ̱nnba̱bi̱ rá̱ pønga̱hya̱ Oja̱ bi̱ ma̱, bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nu̱'a̱ n'na ra̱ hmu̱te xisu da̱ hya̱ rá̱ ba̱si̱ ngue dra̱ ts'ʉnt'ʉ. Nu̱'mø bi̱ m'mʉi, di hu̱ ngue ra̱ Emanuel”, bi 'yɛ̱na̱. A nu̱na̱ ra̱ Emanuel i̱ nne da̱ ma̱ ngue ya 'daua di 'bʉhmʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mi̱ nnu̱'a̱ nt'a̱ha̱ ra̱ José, bi 'yøt'e tengu̱tho xi xihra̱ anxɛ nu̱na̱ rá̱ m'mɛnhni̱ Oja̱. Bi zixra̱ Ma̱ya p'ʉya ngue di̱ m'mʉhmi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pɛ hi̱mbi dädi mɛ̱nte ra̱ pa bi hya̱ rá̱ ba̱si̱ ra̱ Ma̱ya. Mi̱ zä mi̱ m'mʉhrá̱ mʉdi ts'ʉnt'ʉ ra̱ Ma̱ya̱, nu̱na̱ ra̱ José i hu̱ti̱ ngue ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nu̱p'ʉ ja ra̱ hni̱ni̱ Belén ngue ra̱ häi Judea, ja bi̱ mi̱p'ʉ ra̱ Jesús. Guehya yø pa mi̱ nda̱st'abi ra̱ Herodes, gä ma̱di̱ ma̱nda'a̱ ra̱ xɛqui'a̱. Nu̱p'ʉ ja ra̱ da̱ni̱hni̱ Jerusalén bi zøp'ʉ 'da yø n'yohʉ ngue ja yø mfa̱di̱ ngue di xädi te ga̱ 'yo yø sø, bi 'yɛ̱p'ʉ ja n'na ra̱ häi ni̱ bøxyadi. ");
INSERT INTO otnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Hapʉ 'bʉhra̱ 'uɛne nu̱'a̱ bi̱ mi̱hya, nu̱na̱ rá̱ da̱st'abi yø judio? Porque nu̱p'ʉ ni̱ bøxyadi dá̱ handähe n'na ra̱ da̱sø, gue'a̱ ra̱ hmɛ̱ya'a̱ ngue ya bi̱ mi̱. A nu̱yá, nná̱ ɛ̱hɛ̱ ga̱ tha̱nnehe ya ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nu̱na̱ ra̱ da̱st'abi Herodes mi̱ zä mi̱ 'yøhna̱ ra̱ hya̱ na̱, ya da̱ zährá̱ n'yomfɛ̱ni̱ ngue su̱. Da̱ guehyø mmɛ̱ngu̱ Jerusalén, gä bi̱ nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nu̱na̱ ra̱ da̱st'abi bi zonhni̱ gätho'ʉ yø hmu̱ yø mmäcja̱, da̱ guehyø xännba̱te ngue ra̱ ley. Bi 'yørpa̱ ra̱ nt'änni̱ ngue hapʉ ja ngue di̱ mi̱hra̱ Cristo nu̱na̱ bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi. ");
INSERT INTO otnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nu̱ya bi t'ørpa̱ ra̱ nt'änni̱ p'ʉya, bi 'yɛ̱mbra̱ Herodes: ―Nu̱p'ʉ ja ra̱ hni̱ni̱ Belén ngue ra̱ häi Judea ja di̱ mi̱p'ʉ. Porque gue'a̱ ra̱ hya̱ bi 'yotrá̱ pønga̱hya̱ Oja̱'a̱, bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Nu̱p'ʉ ja ra̱ hni̱ni̱ Belén ngue ra̱ häi Judea, ma̱n'na ta̱te'a̱ ngue gätho yø da̱ni̱hni̱ ja'a̱ ra̱ häi'a̱. Porque ja da̱ pømp'ʉ n'na ra̱ da̱st'abi nu̱'a̱ di̱ ma̱ndagui̱'ʉ ma̱ ja̱'i̱ ngue yø judío”. ");
INSERT INTO otnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","A nu̱na̱ ra̱ Herodes nt'a̱gui̱tho bi zon'ʉ yø n'yohʉ øtra̱ nt'änni̱, ɛ̱na̱ ngue pa̱di̱ te ga̱ 'yo yø sø. Ra̱ Herodes bi 'yänni̱ tema̱ pa bá̱ fʉdi bi̱ nɛ̱qui̱ ra̱ sø. ");
INSERT INTO otnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mi̱ xifi hanja p'ʉya, nu̱na̱ ra̱ Herodes bi 'yɛ̱mbi̱: ―Ni̱ mähä Belén, bá̱ homhmʉ ra̱ 'uɛne asta̱ gue'mø guá̱ ti̱mhmʉ. Nu̱'mø guá̱ ti̱mhmʉ p'ʉya, gdí 'yɛ̱hmi̱ ua ngue guí xicjʉ njua̱ni̱, n'namhma̱ ngue 'nɛ̱qui̱ ga̱ mma ngue ga̱ ma tha̱nne ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nu̱ya yø n'yohʉ, mi̱ 'yø'a̱ ra̱ hya̱ bi xihra̱ da̱st'abi, bi̱ ma. Nu̱'a̱ ra̱ sø xi hyanda̱ m'mɛt'o p'ʉ ni̱ bøxyadi, ma̱hømbi hyandi̱ ngue bí ja ra̱ sø p'ʉ ha ni̱ ma. Nu̱p'ʉ ja ra̱ ngu̱ 'bʉhra̱ 'uɛne ja søp'ʉ rá̱ thai ra̱ sø, gue'a̱ hantho'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mi̱ zä mi̱ hyandi̱ hapʉ ɛxa̱ ja ngue da̱ zøni̱, ja̱njua̱ni̱ di johya. ");
INSERT INTO otnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mi̱ zømp'ʉ ja ra̱ ngu̱, bi yʉt'a̱mbo. Bi̱ nu̱ ngue 'bʉp'ʉ ra̱ 'uɛne conna̱ Ma̱ya rá̱ mamá. Gä bi̱ nda̱ntyøhmu̱'ʉ yø n'yohʉ ngue bi da̱nne ra̱ 'uɛne. Bi xʉhyø 'bɛni̱ ngue bi hya̱hra̱ oro op'ʉ, conna̱ hoga̱ bopo ma̱hotho ga̱ yʉni̱ 'nɛ̱ ma̱n'na ra̱ hoga̱ bopo ni̱ hu̱ ngue ra̱ mirra, gä bi u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","M'mɛfa p'ʉya, nu̱'mø mi̱ n'a̱hya yø n'yohʉ, bi 'yu̱t'a̱ Oja̱ ngue nu̱'mø bi̱ mengui̱, ya hi̱ndi̱ map'ʉ ha 'bʉhra̱ Herodes. Sinoque n'nan'yo ma̱n'na ra̱ 'yu̱ di̱ mengui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mi̱ ma ya yø n'yohʉ, nu̱'a̱ n'na rá̱ anxɛ Oja̱ bi̱ nu̱ ra̱ José 'mø mi̱ n'a̱ha̱ ngue bi̱ n'yɛ̱mbi̱: ―Da̱mi̱ nangui̱ n'na zihma̱ntho, guí sixra̱ 'uɛne co 'nɛ̱hrá̱ mamá. Gui 'dagui, i̱ map'ʉ ja ra̱ häi Egipto. Ja bá̱ m'mʉp'ʉ asta̱ gue'mø ga̱ xi'i ngue guá̱ pengui̱. Porque nu̱yá, ra̱ Herodes da̱ hyonna̱ 'uɛne ngue da̱ hyo ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nxu̱i̱tho'a̱ ra̱ ora'a̱, pɛ ra̱ José n'na zihma̱ntho bi̱ nangui̱ ngue bi zixra̱ 'uɛne conná̱ mamá. Bi̱ ma, i̱ ma Egipto. ");
INSERT INTO otnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ja bá̱ m'mʉp'ʉ asta̱ gue'mø mi̱ du̱ ra̱ Herodes. Ngu̱na̱ bi̱ nja para ngue di̱ nja ya yø hya̱ bi bɛ̱nnba̱bi̱ rá̱ pønga̱hya̱ Oja̱ da̱ ma̱ ngue bi 'yɛ̱na̱: “Ga̱ ma si ma̱ Ts'ʉnt'ʉ bí 'bʉ'a̱ Egipto”, bi 'yɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mi̱ ba̱hra̱ Herodes ngue nu̱ya yø n'yohʉ bi̱ nya̱ui ngue honna̱ 'uɛne ya hi̱n'i̱ mengbʉ ha 'bʉi, ma̱n'natho bi̱ mbøcuɛ p'ʉya. Bi̱ mɛnhyø soldado p'ʉ ja ra̱ hni̱ni̱ Belén ngue bá̱ ho yø ts'ʉnt'ʉ nu̱'ʉ 'bʉ'a̱ nyo jɛya pani̱ ga̱i̱. Gätho ma̱thɛ̱t'i̱ ra̱ hni̱ni̱ Belén bi tho yø ts'ʉnt'ʉ. Porque yø n'yohʉ bi xifi ngue hi̱ngui̱ tho'a̱ nyo jɛya xi̱ mʉdi bi̱ nu̱ ra̱ sø. ");
INSERT INTO otnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ra̱ ndødu̱mmʉi bi̱ nja tengu̱tho ra̱ hya̱ bi 'yotra̱ pønga̱hya̱ Jeremías, bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nu̱p'ʉ ja ra̱ hni̱ni̱ Ramá bi t'øde ngue ja̱njua̱ni̱ ngue ya̱ du̱mmʉi n'na ra̱ xisu, 'nɛ̱ zoni̱. Guehna̱ ra̱ Raquel i zoni̱ ngue xi thopyø ba̱si̱. 'Nɛ̱ hi̱mbi̱ ne xtí̱ nhojpa̱bi̱ rá̱ mmʉi porque ya gä xi du̱ yø ba̱si̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mi̱ du̱ ra̱ Herodes, nu̱p'ʉ Egipto ma̱mbi̱ 'bʉhra̱ José bi̱ n'ui̱ 'mø mi̱nxu̱i̱ ngue n'na rá̱ anxɛ Oja̱ bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―A nu̱yá, da̱mi̱ sixra̱ ts'ʉnt'ʉ conná̱ mamá, i̱ map'ʉ ja ra̱ häi Israel. Porque ya bi du̱ ra̱ Herodes nu̱na̱ mi̱ nne xta̱ hyo ra̱ ts'ʉnt'ʉ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nu̱na̱ ra̱ José p'ʉya, bi zixra̱ ts'ʉnt'ʉ conná̱ mamá, bi̱ ma i̱ map'ʉ ja ra̱ häi Israel. ");
INSERT INTO otnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pɛ mi̱ 'yø p'ʉya ngue nu̱na̱ ra̱ Arquelao rá̱ ts'ʉnt'ʉ ra̱ Herodes, guehna̱ mi̱ nda̱st'abi p'ʉ ja ra̱ xɛqui mi̱ nne xtí̱ ma. Porque bi ponnba̱bi̱ ndu̱ rá̱ papá. Ra̱ José p'ʉya bi zu̱ xtí̱ map'ʉ ja ra̱ xɛqui ngue ra̱ häi Judea ma̱di̱ ma̱nda na̱. Ma̱hømbi̱ n'ui̱ ra̱ José p'ʉya, bi sifi ngue di̱ map'ʉ ja ra̱ häi Galilea. ");
INSERT INTO otnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mi̱ zømp'ʉ ja ra̱ häi Galilea, bi̱ m'mʉp'ʉ ja ra̱ hni̱ni̱ Nazaret. Ngu̱na̱ bi 'yøt'e para ngue di̱ nja ya yø hya̱ xi̱ ma̱nyø pønga̱hya̱ Oja̱ ngue bi 'yɛ̱na̱: “Nu̱ná̱, di hu̱tyø ja̱'i̱ ngue ra̱ mmɛ̱ngu̱ Nazaret”. ");
INSERT INTO otnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nu̱'ʉ yø pa'ʉ p'ʉya, nu̱na̱ ra̱ Xuua mi̱ øtra̱ nxixya̱ p'ʉ ja ra̱ häi Judea, mi̱ dʉ'mi̱ bi xihra̱ hya̱ yø ja̱'i̱ bi̱ mpɛti p'ʉ ja ra̱ da̱po. ");
INSERT INTO otnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Bi 'yɛ̱mbyø ja̱'i̱: ―Da̱mi̱ 'bä'ni̱ mmʉihʉ, gui hyɛhmʉ p'ʉ ra̱ nts'o gni̱ 'yohʉ. Porque ya da̱ guehyø pa jap'ʉya da̱ 'yu̱ Oja̱ ngue di̱ ma̱nda ua ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nu̱na̱ ra̱ Xuua guehna̱ bi̱ ma̱nna̱ pønga̱hya̱ Isaías 'mø mi̱ nya̱ ngue bi 'yɛ̱na̱: “Da̱ t'øde te da̱ ma̱n'a̱ n'na nc'ɛ̱i̱ da̱ ma̱nna̱ hya̱ p'ʉ ja ra̱ da̱po ngue da̱ 'yɛ̱na̱: Da̱mi̱ nsähʉ ya, porque ya bá̱ ɛ̱p'ʉ ra̱ Hmu̱, da̱ 'yɛ̱mbyø ja̱'i̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nu̱ rá̱ he ra̱ Xuua, gue'ʉ yø xingu̱ ra̱ cameyo ntøt'e ngue ra̱ u̱lu. Di̱ ngʉt'a̱ n'na ra̱ xifani̱. Nu̱'a̱ te si p'ʉya, yø mmäcja̱ t'a̱xi̱ mi̱ sa. 'Nɛ̱ ra̱ t'afi t'asa ti̱mp'ʉ ja ra̱ da̱po mi̱ si. ");
INSERT INTO otnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Xa̱ngu̱ yø ja̱'i̱ bi zøp'ʉ 'bʉhra̱ Xuua ngue øxra̱ hya̱ bi̱ ma̱. Bi zøp'ʉ yø ja̱'i̱ bá̱ nɛ̱xpʉ ja ra̱ hni̱ni̱ Jerusalén, gätho'ʉ yø hni̱ni̱ ja'a̱ ra̱ häi Judea, gätho'ʉ yø xɛqui ngue ra̱ da̱the Jordán, gä bá̱ ɛ̱hyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nu̱ya yø ja̱'i̱ bi̱ ma̱ ngue ja yø ts'oqui, guehya bi xixya̱bi̱ ra̱ Xuua p'ʉ ja ra̱ da̱the Jordán. ");
INSERT INTO otnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mi̱ nu̱ ra̱ Xuua ngue ma̱ndøngu̱ dyø judío 'bʉp'ʉ ni̱ 'yɛ̱hɛ̱ di xixya̱bi̱. 'Bʉp'ʉ yø fariseo, 'bʉp'ʉ yø saduceo. Bi 'yɛ̱mbʉya: ―Guí øthʉ tengu̱tho øtyø c'ɛ̱ya̱ ngue 'da'mø bá̱ ɛ̱p'ʉ ra̱ sibi. Xiya, ¿hague gni̱ pa̱hmʉ ngue bá̱ ɛ̱p'ʉ ra̱ nda̱te castigo di̱ nja? ");
INSERT INTO otnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Da̱mi̱ 'yøthʉ ra̱ nho, n'namhma di̱ nɛ̱qui̱ ngue ya gá̱ hyɛhmʉ p'ʉ ra̱ nts'o. ");
INSERT INTO otnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Yo sä guí ɛ̱na̱ ngue ya hi̱nte guí jahʉ ngue yø mbom'mɛto'a̱hʉ ra̱ Abraham. Porque dí xi'a̱hʉ ngue nu̱ua ja yø do ja ua, da̱ zä da̱ 'yøt'Oja̱ ngue da̱ bøcua yø mbom'mɛto ra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Guí øthʉ tengu̱tho yø za hi̱ngui̱ zʉdi, guí̱ njathʉ p'ʉya. Pɛ ya ja ra̱ acha da̱ 'yɛxyø za. Gätho yø za hi̱ngui̱ nne di̱ nzʉdi, da̱ t'ɛts'i ngue da̱ ma nt'u̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","A nu̱gui̱, ma̱jua̱ni̱ ngue nu̱ya yø ja̱'i̱ i̱ mma̱ ngue da̱ hyɛp'ʉ ra̱ nts'o, guehya da̱di xixya̱bi̱ conna̱ dehe ya. Pɛ bá̱ ɛ̱p'ʉ ma̱n'na da̱ 'yøtra̱ nxixya̱ conna̱ sibi 'mø bi ha̱'a̱hʉ ra̱ ts'ɛdi ra̱ Espíritu Santo. Nu̱na̱, ma̱n'na ta̱te na̱ ngue nu̱gä. ¿Hapʉ gue ga̱ sʉcä tengu̱ na̱? ");
INSERT INTO otnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Guehna̱ da̱ huanhyø ja̱'i̱ na̱ tengu̱tho 'mø ma̱hoqui ra̱ trigo, n'nani̱ ni̱ ma yø xi. Ra̱ trigo p'ʉya, ma̱pɛti ngue da̱ 'bɛts'i. Nu̱'a̱ rá̱ xi p'ʉya, da̱ t'u̱p'ʉ ja ra̱ sibi hi̱nja̱m'mø da̱ huɛ̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nu̱na̱ ra̱ Jesús bá̱ nɛxpʉ ja ra̱ häi Galilea, bi zøp'ʉ ja ra̱ da̱the Jordán mi̱ 'bʉhra̱ Xuua ngue bi xixya̱bi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pɛ ra̱ Xuua hi̱ngui̱ nne xtí xixya̱bi̱ ra̱ Jesús. Bi 'yɛ̱mbi̱: ―Nu̱gä go dí̱ nnegä ngue gui xixya̱gui̱, 'nɛ̱ go gni̱ 'yɛ̱hɛ̱ ngue ga̱ xixya̱'i̱ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pɛ ra̱ Jesús bi 'yɛ̱mbra̱ Xuua: ―Da̱mi̱ ne ngue gui xixya̱gui̱, porque jatho ga̱ øt'ui'a̱ te gä di̱ ma̱nda Oja ―bi 'yɛ̱mbi̱. Ja̱na̱ngue ra̱ Xuua bi xixya̱bi̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Høntho bi̱ nxixya̱ ra̱ Jesús, bi̱ ma nenthe p'ʉya. Bi̱ nu̱ ngue bi xohra̱ c'ama̱hɛ̱ts'i̱. Nu̱'a̱ ra̱ Espíritu Santo, ɛ̱ntho n'na ra̱ paloma p'ʉ i hnu̱, ngue bi zøp'ʉ ja rá̱ ya̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bi t'ø p'ʉya ngue bá̱ nya̱ Oja̱ ma̱ya̱, bi 'yɛ̱na̱: ―Nu̱na̱ 'bʉcua ya, guehna̱ ma̱ Ts'ʉnt'ʉ da̱di̱ ma̱di̱. A nu̱yá, ja̱njua̱ni̱ ngue ja ga̱mpähä conná̱ nguehna̱ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ra̱ Espíritu Santo bi zixpʉ bí ja ra̱ da̱po ra̱ Jesús para ngue ja da̱ sämhya̱ p'ʉ ra̱ zithu̱, da̱ hyonnbi̱ ha di̱ mɛstho ra̱ hya̱ di̱ ma̱nda Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mɛ̱nte nyote ma̱ pa, ra̱ pa ra̱ xu̱i̱ hi̱mbi̱ zi ra̱ hmɛ̱. M'mɛfa p'ʉya, ya bi zä ngue ma̱thoguitho tu̱ ma̱nthu̱hu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ra̱ zithu̱ p'ʉya bi guarbʉ 'bähra̱ Jesús. Bi hyonnbi̱ ha di 'yøtra̱ ts'oqui, bi 'yɛ̱mbi̱: ―Nu̱'mø ngue gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱, da̱mi̱ 'yøt'e ngue yø do janʉ da̱ gohi di̱ nthu̱hmɛ̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbra̱ zithu̱: ―Nu̱p'ʉ ja ra̱ Ma̱ca̱ Libro, nt'ot'i p'ʉ ra̱ hya̱ ngue ɛ̱na̱: “Nu̱ ra̱ ja̱'i̱ hi̱nda̱ ne da̱ 'yøde te mma̱n'Oja̱, ma̱da̱gue'a̱ da̱ zi ra̱ hmɛ̱ ra̱ ja̱'i̱, pɛ ya hi̱nda̱ zä di̱ m'mʉi”. ");
INSERT INTO otnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ra̱ zithu̱ p'ʉya, bi zixpʉ ja ra̱ ma̱ca̱ da̱ni̱hni̱ Jerusalén, bi̱ ntøp'ʉ ja rá̱ 'bet'e ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bi 'yɛ̱mbi̱: ―Nu̱'mø gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱ ya, da̱mi̱ nsäcua ya. Porque nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ra̱ hya̱ ngue ɛ̱na̱: “Nu̱na̱ Oja̱, da̱ pɛnhyø anxɛ ngue da̱ mä'i. Da̱ 'yøt'e ngue njana̱te gdi søt'a̱ häi, n'namhma̱ ngue hi̱ndi̱ ʉn'na̱ ni̱ gua yø do” ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbra̱ zithu̱: ―Xquet'a̱ nt'ot'i ra̱ hya̱ p'ʉ ja ra̱ Ma̱ca̱ Libro ngue nu̱na̱ Oja̱, hi̱njonda̱ zännbi̱ te da̱ 'yøt'e para ngue da̱ fa̱di̱ ngue'mø ma̱jua̱ni̱ te mma̱ ogue hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ra̱ zithu̱ p'ʉya bi zixpʉ bí ja n'na ra̱ da̱nyu̱ni̱. Bi japi ngue da̱ hyandi̱ gätho yø nación i ja rá̱ ngʉni̱ nxi̱mhäi. 'Nɛ̱ da̱ hyandi̱ te gä ra̱ nho ga̱ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bi 'yɛ̱mbi̱: ―Nu̱ te gä guí handya, gä ga̱ 'da'i ngue'mø gui̱ nda̱ntyøhmu̱ gui tha̱nnegui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Da̱mi̱ 'uegue grá̱ zithu̱. Porque nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue hønt'a̱ ra̱ Hmu̱ Oja̱ ja ngue da̱ ma ntha̱nne, hi̱njom ma̱n'na. ");
INSERT INTO otnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nu̱'a̱ ra̱ zithu̱ p'ʉya, bi zop'ʉ ra̱ Jesús, bi̱ ma. Bá̱ ɛ̱hyø anxɛ p'ʉya ngue bi̱ mäts'i. ");
INSERT INTO otnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bi 'yɛ̱hra̱ pa ngue bi̱ n'ofädi ra̱ Xuua. Mi̱ 'yøhra̱ Jesús ngue ya ofädi, bi̱ ma p'ʉya i̱ mpa p'ʉ ja ra̱ häi Galilea. ");
INSERT INTO otnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Bá̱ sop'ʉ ra̱ hni̱ni̱ Nazaret, bi̱ ma da̱ni̱ m'mʉp'ʉ ja ra̱ hni̱ni̱ Capernaum. Nu̱na̱ ra̱ hni̱ni̱ na̱, ja jarbʉ ja ra̱ nenzabi nu̱p'ʉ di̱ ntøt'a̱ häiui ra̱ Zabulón conna̱ häi Neftalí. ");
INSERT INTO otnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngu̱na̱ ra̱ hya̱ bi̱ nja para ngue di̱ nja'a̱ te ra̱ hya̱ bi 'yotra̱ pønga̱hya̱ Isaías ngue bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nu̱'ʉ yø mmɛ̱ngu̱ p'ʉ ja ra̱ häi Zabulón, 'nɛ̱'ʉ yø mmɛ̱ngu̱ p'ʉ ja ra̱ häi Neftalí, guehya yø ja̱'i̱ 'bʉp'ʉ jonna̱ nenzabi, 'nɛ̱'ʉ rá̱ m'mʉp'ʉ ma̱n'na nguadi ra̱ da̱the Jordán, 'nɛ̱p'ʉ ja ra̱ häi Galilea, ja jap'ʉ n'na ra̱ xɛqui ngue 'bʉhyø ja̱'i̱ hi̱ngyø judío. ");
INSERT INTO otnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nu̱ya yø ja̱'i̱ ya mi̱ 'bʉ 'bɛxu̱i̱, pɛ nu̱yá, ya bi̱ nu̱ xa̱nho ra̱ nyot'i ya. Guehya yø ja̱'i̱ ɛ̱ntho ya xi du̱, pɛ nu̱yá, ya bi yorpa̱bi̱ ra̱ nyot'i ya”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ya bi dʉ'mi̱ bi xihra̱ hya̱ yø ja̱'i̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'bä'ni̱ mmʉi ngue gui hyɛhmʉ p'ʉ ra̱ nts'o gni̱ 'yohʉ. Ya da̱ guehyø pa ja p'ʉya da̱ 'yu̱ Oja̱ ngue di̱ ma̱nda ua ya. ");
INSERT INTO otnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nu̱p'ʉ ja ra̱ nenzabi Galilea, bi thop'ʉ n'na pa ra̱ Jesús. Ja bi di̱mp'ʉ yoho yø mahua̱ ngue di̱ n'yohʉ. Nu̱'a̱ n'na i Simu̱, 'nɛ̱ xquet'a̱ i Bɛdu. Nu̱na̱ ma̱n'na, ra̱ Andre. Nu̱ya yonc'ɛ̱i̱ ya, mi̱ ɛntyø xit'a̱ p'ʉ ja ra̱ dehe ngue pahua̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mi̱ nu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma ga̱ mmähä n'yø. Ya hi̱ngyø hua̱ guí thɛui ya, sinoque ga̱ xän'na̱ui ha gdi thɛui yø ja̱'i̱ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'Bexpi zop'ʉ yø xit'a̱ ngue bi̱ mähä ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mi̱ thohmi̱ts'ʉ ni̱nguep'ʉ p'ʉya, ma̱hømbi̱ di̱mp'ʉ mi̱ yonc'ɛ̱i̱ di̱ n'yohʉ ngue n'nat'a̱ yø papá. Ra̱ Jacobo 'nɛ̱hra̱ Xuua, guehya yø ts'ʉnt'ʉ ra̱ Zebedeo. 'Dap'ʉ mi̱ ohʉ rá̱ papá p'ʉ ja ra̱ barco ngue pøtyø xit'a̱. Ra̱ Jesús bi xifi ngue da̱ mähä. ");
INSERT INTO otnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nu̱ya ts'its'i, 'bexpi̱ mähä ra̱ Jesús, bi zop'ʉ ja ra̱ barco yø papá. ");
INSERT INTO otnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ra̱ Jesús bi̱ n'yo ndap'ʉ bi zä gä ra̱ häi Galilea. Nu̱'mø bi zømp'ʉ ja yø ni̱ja̱ di̱ mpɛti yø judío, xännba̱bi̱ yø ja̱'i̱ rá̱ hya̱ Oja̱. Xihyø ja̱'i̱ ra̱ hoga̱ 'da'yo hya̱ ngue ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱ yø ja̱'i̱. 'Nɛ̱ øthe yø ja̱'i̱ di hyɛ̱nni̱. Hønt'a̱ bi zä ma̱n'ʉ hɛ̱mbyø ja̱'i̱, gä øthe. ");
INSERT INTO otnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gätho ra̱ häi Siria bi̱ n'yo ra̱ hya̱ te øtra̱ Jesús. Ja̱na̱ngue nu̱p'ʉ 'bʉhra̱ Jesús bi ts'i̱nnba̱bi̱ to gä xa̱n'ʉ, ndana̱ bi zä ma̱n'ʉ hɛ̱mbi̱. Nu̱'ʉ yø ja̱'i̱ n'youi yø ts'onthi̱ bi ts'i̱nnbi̱ ngue øthe. Bi ts'i̱nnba̱bi̱ yø ja̱'i̱ di gu̱xtyø ts'i 'mø bi gʉ ra̱ n'ʉ n'youi. Da̱ guehyø ja̱'i̱ tu̱dyø gua bi ts'i̱nnba̱bi̱ ra̱ Jesús ngue da̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nu̱p'ʉ ni̱ ma ra̱ Jesús xa̱ndøngu̱ yø ja̱'i̱ tɛnni̱. Bá̱ nɛ̱xi̱'da yø ja̱'i̱ p'ʉ ja ra̱ häi Galilea. Bá̱ nɛ̱xi'da yø ja̱'i̱ p'ʉ ja ra̱ häi Decápolis. Bá̱ nɛ̱xi'da yø ja̱'i̱ p'ʉ ja ra̱ hni̱ni̱ Jerusalén. Bá̱ nɛ̱xi'da yø ja̱'i̱ p'ʉ ja ra̱ häi Judea. Bá̱ nɛ̱xi'da yø ja̱'i̱ p'ʉ ma̱n'na nguadi ra̱ da̱the Jordán. ");
INSERT INTO otnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bi̱ nu̱ ra̱ Jesús ngue xa̱ndøngu̱ yø ja̱'i̱ bi zøhø. Bi̱ map'ʉ bí ja n'na ra̱ nyu̱ni̱, bi hyoni̱ hapʉ da̱ mi̱. Nu̱'ʉ yø xädi p'ʉya bi̱ mäspʉ hu̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nu̱na̱ ra̱ Jesús bi dʉ'mi̱ bi xännba̱ ra̱ hya̱ yø ja̱'i̱. Bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ nu̱ya ɛ̱ntho hyoya, porque ti̱nyø mmʉi ngue di 'bɛhra̱ nho. Porque guehya yø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ tu̱ yø mmʉi. Porque Oja̱ di hojpa̱bi̱ yø mmʉi ya yø ja̱'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ hi̱ndi 'yɛ̱xpʉ 'bʉhyø mmi̱c'ɛ̱i̱ui. Porque guehya yø ja̱'i̱ da̱ gohmi̱ ra̱ häi ma̱ ya̱t'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ nu̱ya ho yø mmʉi ngue honi̱ ha di 'yøtra̱ nho, tengu̱tho 'mø di tu̱ma̱nthu̱hu̱ di ja ndu̱mmʉi ngue honi̱ ha di̱ nsi̱hmɛ̱. Porque da̱ mäx Oja̱ ngue da̱ zä da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ nu̱ya da̱ 'yøtra̱ ma̱te ngue da̱ mäxyø mmi̱c'ɛ̱i̱ui. Porque guehya yø ja̱'i̱ ya da̱ 'yørpa̱ ra̱ ma̱te Oja̱ ngue da̱ mäts'i. ");
INSERT INTO otnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ ngue hi̱n tema̱ nts'o so yø mmʉi. Porque guehya yø ja̱'i̱ da̱ nu̱ Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ nuya da̱ japi ngue di̱ nhojpa̱'ʉ di̱ nsʉi. Porque guehya yø ja̱'i̱ da̱ gohi ngue yø ba̱si̱ Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ra̱ mmɛ̱nthi̱ di̱ nthɛui yø ja̱'i̱ nu̱ya da̱ zä ra̱ n'ʉ da̱ ts'ʉi ngue honi̱ ha di̱ n'yo xa̱nho. Porque guehya yø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ra̱ mmɛ̱nthi̱ gui̱ nthɛui 'mø bi ts'ʉ'i ngue guí tɛnnga̱hʉ. Da̱ ts'an'a̱hʉ, da̱ ts'än'na̱hʉ yø fɛhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Da̱mi̱ johyahʉ 'mø ngue ngu̱'a̱ bi̱ nja, di̱ nja'a̱hʉ mpähä, porque xa̱ngu̱ ni̱ nzäbihʉ bí ja ma̱hɛ̱ts'i̱. Ya quí pa̱hmʉ ngue nu̱'ʉ yø pønga̱hya̱ Oja̱ xa̱ m'mʉ'a̱ m'mɛt'o xquet'a̱ bi ts'ʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nu̱ ra̱ u̱, i ja rá̱ 'bɛfi ngue nu̱ tema̱ japi ya hi̱ndi̱ nts'oni̱. Guí̱ njathʉ p'ʉ ua ja ra̱ xi̱mhäi ya, ngue guí 'bʉhmʉ ua, ya xøt'a̱tho ra̱ nts'o da̱ 'yøtyø ja̱'i̱. Pɛ nu̱'mø bi̱ m'mɛhrá̱ ts'ɛdi ra̱ u̱, ya hi̱nda̱ zä to da̱ japi ngue xta̱ n'u̱ ma̱høn'a̱. Ya hi̱nte di̱ mu̱ui ra̱ u̱, da̱ t'ɛi, da̱ nɛ̱p'ʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nu̱'a̱ te gni̱ 'yohʉ ya, i̱ nnu̱dyø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi. Gue'a̱hʉ, tengu̱tho n'na ra̱ nyot'i di yorbʉ ja ra̱ 'bɛxu̱i̱, i̱ nnu̱tho gätho yø ja̱'i̱. Gue'a̱hʉ, tengu̱tho n'na ra̱ hni̱ni̱ 'mø bi ja ma̱xøts'e ra̱ nyu̱ni̱, i̱ nnu̱tho gätho yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nu̱'mø bi̱ ma ma̱ sa̱qui̱ n'na ra̱ lámpara, hi̱nda̱ thørbʉ ja ra̱ huada, sinoque da̱ thøxpʉ ja ra̱ nthøxa̱nyot'i n'namhma̱ ngue di yorpi gätho'ʉ 'bʉ'a̱mbo ra̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Da̱mi̱ njathʉ p'ʉya, da̱mi̱ nehʉ ngue da̱ nu̱ yø ja̱'i̱'a̱ te ra̱ nho guí øthʉ. Nu̱'mø bi̱ nu̱ yø ja̱'i̱'a̱ ra̱ nho guí øthʉ p'ʉya, yø ja̱'i̱ da̱ 'yɛ̱spa̱bi̱ na̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","A nu̱yá, 'yo guí ɛ̱mhmʉ ngue dá̱ ɛ̱hɛ̱ ga̱ ha̱cä ra̱ ley bi 'yotra̱ Moisés, ogue ga̱ ha̱cä'ʉ yø hya̱ bi̱ nxännba̱te yø pønga̱hya̱ Oja̱. Nu̱'a̱, hi̱n'na̱'a̱. Sinoque dá̱ ɛ̱hɛ̱ ngue nu̱'a̱ te gäma̱ hya̱ mma̱mp'ʉ ja ra̱ ley, gä gue'a̱ ga̱ thogä'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nu̱gä ma̱jua̱ni̱ te dí xi'a̱hʉ, mɛ̱nte ngue di siguetho ja ra̱ c'ama̱hɛ̱ts'i̱ 'nɛ̱hra̱ häi, nu̱'a̱ te gäma̱ hya̱ nt'ot'i p'ʉ ja ra̱ ley, ni̱ xi̱nga̱ n'na ra̱ letra, ni̱ xi̱nga̱ n'na ra̱ punto di sä ngue da̱ tha̱qui̱ asta̱ gue'mø bi̱ nja gätho'a̱ tema̱ hya̱ nt'ot'i. ");
INSERT INTO otnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ja̱na̱ngue nu̱yá, nu̱ to bi zä ngue fɛstho ra̱ hya̱ di̱ ma̱nda ra̱ ley, ma̱da̱gue'a̱ zits'ʉtho, 'nɛ̱ da̱ ngu̱'a̱ da̱ xännba̱bi̱ mi̱'da yø ja̱'i̱ ngue da̱ mɛstho ra̱ hya̱, guehna̱ ra̱ ja̱'i̱ ngue hi̱nga̱ ɛda̱ hnu̱ ma̱nsu̱ p'ʉ ma̱hɛ̱ts'i̱ na̱. Pɛ nu̱ ra̱ ja̱'i̱ ngue da̱ 'yøt'e te mma̱nna̱ ley 'nɛ̱ da̱ ngu̱'a̱ da̱ xännba̱bi̱ mi̱'da yø ja̱'i̱ ngue da̱ 'yøt'e, guehna̱ ra̱ ja̱'i̱ da̱ hnu̱ ma̱nsu̱ p'ʉ ma̱hɛ̱ts'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nu̱gä dí xi'a̱hʉ ngue nu̱'mø guí̱ nne di̱ ncʉ'a̱hʉ p'ʉ di̱ ma̱nda Oja̱, ma̱ da̱tho nne ngue xtá̱ ndønho te gdi̱ n'yohʉ, ngue'a̱ te ga̱ 'yo yø xännba̱te ngue ra̱ ley 'nɛ̱'a̱ te ga̱ 'yo yø fariseo. ");
INSERT INTO otnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ya xcá̱ 'yøhmʉ yø hya̱ bi sännba̱bi̱ yø ndiua ma̱nja̱m'mø ngue bi t'ɛ̱mbi̱: “'Yo grá̱ hyote. A nu̱ ra̱ ja̱'i̱ ngue di̱ nhote, jatho da̱ tha̱spa̱ ra̱ güɛnda ngue da̱ ma ra̱ castigo”, bi t'ɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pɛ nu̱gä dí xi'a̱hʉ ngue nu̱ ra̱ ja̱'i̱ da̱ nu̱ ma̱n'ʉ rá̱ cu̱, jatho da̱ tha̱spa̱bi̱ ra̱ güɛnda. A nu̱ ra̱ ja̱'i̱ ngue xihyø ts'omhya̱ rá̱ cu̱ 'mø ya̱ui, jatho ngue di̱ mpɛti yø ts'ʉt'abi da̱ hya̱spa̱bi̱ ra̱ güɛnda. Nu̱ to ɛ̱mbi̱ ngue ra̱ ndonda rá̱ cu̱, da̱ ma ra̱ ni̱du̱ hapʉ di̱ nzø. ");
INSERT INTO otnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","A nu̱yá, xi'mø guí̱ mmap'ʉ ja ra̱ altar ngue guá̱ ørpa̱hʉ ra̱ 'bøt'e Oja̱, 'nɛ̱ ja da̱ sop'ʉ ni̱ mmʉi ngue hi̱ngui̱ ho te xcá̱ 'yørpa̱ ni̱ cu̱hʉ, ya hi̱nguá̱ øthʉ ra̱ 'bøt'e. ");
INSERT INTO otnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Sinoque bá̱ sohni̱ 'bøt'ehʉ p'ʉ ja ra̱ altar, guá̱ pengui̱ gui̱ nhojpa̱ui ni̱ cu̱. Ja guá̱ pengui̱ gui dä ni̱ 'bøt'ehʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nu̱'mø bi̱ ma ma̱ ya̱pi̱'a̱hʉ, nu̱'a̱ di ya̱p'a̱hʉ da̱mi̱ nhojpa̱hʉ p'ʉ ja ra̱ 'yu̱, n'namhma̱ ngue hi̱ndi̱ dä'a̱hʉ p'ʉ ja ra̱ ts'ʉt'abi. Porque nu̱'mø ya bi̱ ndä'a̱hʉ p'ʉ ja ra̱ ts'ʉt'abi, ra̱ ts'ʉt'abi di dä'a̱hʉ ra̱ policía. Ra̱ policía p'ʉya da̱ zixa̱hʉ fädi. ");
INSERT INTO otnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ma̱jua̱ni̱ te dí xi'a̱hʉ, ngue nu̱p'ʉ ja ra̱ fädi, ya hi̱nda̱ zä guá̱ pønthohʉ, guá̱ pømhmʉ asta̱ gue'mø guá̱ ju̱t'i̱ gätho ra̱ mɛ̱nyu̱ da̱ ts'än'na̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ya xcá̱ 'yøhmʉ ra̱ hya̱ bi sännba̱bi̱ yø ja̱'i̱ ngue bi t'ɛ̱mbi̱: “'Yo grá̱ 'yots'om'mäi”. ");
INSERT INTO otnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pɛ nu̱gä dí xi'a̱hʉ ngue nu̱ to hɛ̱ta̱ n'na ra̱ xisu 'nɛ̱ so rá̱ mmʉi ngue di̱ n'yots'om'mäiui, ya sʉtho 'mø ma̱jua̱ni̱ bi̱ n'yots'om'mäui ra̱ xisu hɛ̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A nu̱yá, nu̱'mø guí ɛ̱na̱ ngue rá̱ ts'oqui ni̱ dä ngue ni̱ n'yɛi p'ʉ guí øthʉ ra̱ ts'oqui, da̱mi̱ hya̱hni̱ dä, gui 'yɛi. Ma̱n'na xa̱nho ngue di̱ m'mɛ'a̱ n'na ni̱ dähʉ, hi̱nda̱ gue'a̱ ngue gä ni̱ do'yohʉ da̱ ma ra̱ ni̱du̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nu̱'mø guí ɛ̱na̱ ngue rá̱ ts'oqui ni̱ 'yɛ ngue ni̱ n'yɛi p'ʉ guí øthʉ ra̱ ts'oqui, da̱mi̱ hyɛjni̱ 'yɛ, gui 'yɛi yap'ʉtho. Ma̱n'na xa̱nho ngue di̱ m'mɛ'a̱ n'na ni̱ 'yɛhʉ, hi̱nda̱ gue'a̱ ngue gä ni̱ do'yohʉ da̱ ma ra̱ ni̱du̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ya xcá̱ 'yøhmʉ ya yø hya̱ bi sännba̱bi̱ yø ja̱'i̱ 'mø yø pa xa̱ thogui ngue bi t'ɛ̱mbi̱: “Nu̱ to da̱ ne da̱ 'yɛnná̱ xisu, i jatho da̱ nangra̱ sʉcua̱ ngue ra̱ nxu̱ni̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pɛ nu̱gä dí xi'a̱hʉ ngue n'na ra̱ xisu 'mø bi 'yɛnná̱ ndø, nu'mø bi̱ ntha̱tui ma̱n'na ra̱ n'yohʉ, ya ra̱ ts'oqui øt'ui na̱ da̱ mɛ. Pɛ go rá̱ ts'oqui na̱ ra̱ n'yohʉ bi 'yɛnná̱ xisu ngue te di̱ nja, porque høndra̱ xisu ngue ra̱ 'yots'om'mäi i sä ngue da̱ t'ɛi. ");
INSERT INTO otnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ya xcá̱ 'yøhmʉ ya yø hya̱ bi sännba̱bi̱ yø ndiua 'mø yø pa xa̱ thogui ngue bi t'ɛ̱mbi̱: “Nu̱'mø guí ɛ̱xhʉ ntestigo Oja̱ ngue ma̱jua̱ni̱ di̱ nja'a̱ ra̱ hya̱ guí̱ mma̱mhmʉ, ya ja ts'ɛditho ngue gui 'yøthʉ'a̱ te ra̱ hya̱ ga̱di ya̱rpa̱ ni̱ mmi̱c'ɛi̱hʉ ngue di̱ nja”. ");
INSERT INTO otnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pɛ nu̱gä dí xi'a̱hʉ ngue 'yo guí ɛ̱xhʉ ntestigo Oja̱ p'ʉ guí ya̱hʉ ngue gdí̱ ha̱tra̱ ts'ɛdi ni̱ hya̱hʉ. Nu̱ te bi ja ma̱hɛ̱ts'i̱, 'yo guí ɛ̱xhʉ ntestigo, porque ja bí 'bʉp'ʉ Oja̱, ɛ̱ntho go t'ɛ̱xa̱ ntestigo'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'Yo guí ɛ̱xhʉ ntestigo ra̱ häi, porque Oja̱ di̱ ma̱nda gä ra̱ xi̱mhäi, ɛ̱ntho go t'ɛ̱xa̱ ntestigo'a̱. 'Yo guí ɛ̱xhʉ ntestigo ra̱ da̱ni̱hni̱ Jerusalén, porque ja ra̱ da̱st'abi p'ʉ Oja̱, ɛ̱ntho go t'ɛ̱xa̱ ntestigo'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","'Yo guí ɛ̱na̱ ngue da̱ zä da̱ t'øc'a̱ ni̱ ya̱ 'mø hi̱mma̱ jua̱ni̱ te guí̱ mma̱mhmʉ. Porque ni̱ ya̱hʉ, ni̱ xi̱nga̱ n'na ni̱ xta̱hʉ da̱ zä gui 'yøthʉ ngue xtá̱ nt'axi ogue xtá̱ mpothi. ");
INSERT INTO otnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","A nu̱'mø guí̱ nne gui̱ ma̱mhmʉ n'na ra̱ hya̱, njua̱ntho da̱mi̱ ma̱mhmʉ ngue'mø da̱ zä, ogue hi̱nda̱ zä. Porque ra̱ ja̱'i̱ ngue rá̱ n'youi ra̱ zi̱thu̱, hi̱ngui̱ t'ɛ̱c'ɛ̱i̱ te mma̱, ja̱na̱ngue ngue honi̱ te ɛ̱xa̱ ntestigo. ");
INSERT INTO otnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ya xcá̱ 'yøhmʉ yø hya̱ bi sännba̱bi̱ yø ja̱'i̱ 'mø yø pa xa̱ thogui ngue bi t'ɛ̱mbi̱: “Nu̱ ra̱ ja̱'i̱ da̱ hya̱mba̱ rá̱ dä rá̱ mmi̱c'ɛ̱i̱ui, xquet'a̱ da̱ tha̱mba̱bi̱ rá̱ dä. Nu̱ ra̱ ja̱'i̱ da̱ 'yøjpa̱ yø ts'i rá̱ mmi̱c'ɛ̱i̱ui, xquet'a̱ da̱ t'øjpa̱ yø ts'i”. ");
INSERT INTO otnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pɛ nu̱gä dí xi'a̱hʉ, ngue nu̱'a̱ te ra̱ nts'o øt'a̱hʉ n'na ra̱ ja̱'i̱, 'yo ga̱di cospa̱hʉ. Hante gue nu̱'mø to bi̱ mɛp'a̱ ni̱ hmi̱hʉ, da̱mi̱ u̱nma̱n'na nguadi ni̱ hmi̱ ngue da̱ mɛ'mi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A nu̱'mø to guí tu̱pi̱, 'nɛ̱ di ya̱p'a̱'i̱ ngue ä'i ni̱ pahni̱, co 'nɛ̱hni̱ tu̱hu̱ da̱mi̱ u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nu̱'mø to da̱ 'yɛ̱n'i̱ gui fäxʉ n'na kilómetro ma̱de ngue gui tu̱spa̱ rá̱ 'bɛni̱, da̱mi̱ doblehʉ'a̱ te xi'i gui fäxhʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nu̱'mø te'o da̱ 'yä'a̱hʉ n'na ra̱ cosa, da̱mi̱ u̱nni̱. Nu̱'a̱ te'o da̱ mi̱p'a̱hʉ n'na ra̱ cosa, da̱mi̱ hmi̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ya xcá̱ 'yøhmʉ'ʉ yø hya̱ bi sännba̱bi̱ yø ja̱'i̱ 'mø yø pa xa̱ thogui ngue bi t'ɛ̱mbi̱: “Da̱mi̱ ma̱hni̱ amigohʉ. A nu̱'ʉ sʉ'a̱hʉ, 'yo ga̱di̱ ma̱hmʉ'ʉ”, bi t'ɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pɛ nu̱gä dí xi'a̱hʉ ngue da̱mi̱ ma̱hni̱ nsʉihʉ. Da̱mi̱ 'yäphʉ Oja̱ ngue di ja̱pi̱ to san'a̱hʉ. Nu̱ te'o gä nnu̱ ma̱n'ʉ'a̱hʉ, da̱mi̱ 'yørpa̱hʉ ra̱ nho. Da̱mi̱ marpa̱hʉ Oja̱ te'o ya̱ ma̱nts'o 'mø guí ya̱hʉ. Marpa̱hʉ Oja̱'ʉ hi̱ngui̱ ho te øt'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","A nu̱'mø gui 'yøthʉ ya yø hya̱ dí xi'a̱hʉ ya, ya di̱ nɛ̱qui̱ ngue yø ba̱si̱'a̱hʉ'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ 'mø. Porque ra̱ hyadi bi hoc'a̱ Oja̱, hi̱nga̱ hønnbʉ 'bʉhyø hoja̱'i̱ øtra̱ nho, sinoque 'nɛ̱p'ʉ 'bʉhyø ts'oc'ɛ̱i̱ øtra̱ nho ra̱ hyadi. Ra̱ 'ye p'ʉya, hi̱nga̱ høndyø hoja̱'i̱ 'ye p'ʉ ja yø hua̱hi̱, sinoque 'nɛ̱hyø ts'oc'ɛ̱i̱ 'ye p'ʉ ja yø hua̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A nu̱'mø ngue hønt'ʉ to di̱ ma̱'a̱hʉ ga̱di̱ ma̱hmʉ, ¿ndana̱ ra̱ nho di̱ nɛ̱qui̱ ngue guí øthʉ 'mø? Conque asta̱ yø ngʉthäi njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Xi'mø ngue hønt'ʉ ni̱ amigo ga̱di zɛnguahʉ, ¿ndana̱ ra̱ nho guí øthʉ 'mø? Porque xquet'a̱ njap'ʉ yø ja̱'i̱ hi̱ngui̱ pa̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nu̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱, ma̱ da̱tho ngue xa̱ndønho te øt'e. Gui̱ njathʉ p'ʉya, da̱mi̱ nehʉ ngue ma̱ da̱tho xtá̱nho te gui 'yøthʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nu̱'a̱ te gä ra̱ nho ja ngue gui 'yøthʉ, 'yo guí̱ nnehʉ ngue hønnbʉ 'bʉi xa̱ngu̱ yø ja̱'i̱ da̱ nu̱ ha gdi̱ 'yøthʉ ra̱ nho. A nu̱'mø ngue ra̱ n'yɛ̱ts'i̱ gni̱ 'yøthʉ ra̱ nho p'ʉ ha 'bʉhyø ja̱'i̱, nu̱'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ ya hi̱n tema̱ nzäbi di 'da'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ja̱na̱ngue nu̱yá, nu̱'mø guí fäxhʉ yø ja̱'i̱ nu̱'ʉ hyoya, 'yo guí̱ nnehʉ ngue 'da di ba̱tyø ja̱'i̱ te guí øthʉ. Porque ngu̱'a̱ øt'i'da yø ja̱'i̱ p'ʉ ja yø ni̱ja̱ 'nɛ̱p'ʉ ja yø caye, høntho nne ngue di 'yɛ̱ts'i̱ ngue da̱ nu̱ yø ja̱'i̱'a̱ ra̱ nho øt'e. Pɛ ma̱jua̱ni̱ te dí xi'a̱hʉ ngue nu̱ya yø ja̱'i̱ njap'ʉ, nu̱'a̱ ga̱ nnu̱ ma̱nho yø ja̱'i̱ te øt'e, ya hønt'a̱ yø nzäbi'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pɛ nu̱'a̱hʉ, nu̱'mø guí fäxhʉ yø hyoya, nu̱ te ja ngue gui 'yøthʉ, 'yo 'be gui xihni̱ amigo ga̱di̱ nsixui. ");
INSERT INTO otnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nu̱'mø guí øthʉ ra̱ 'bäxte, nt'a̱gui̱tho da̱mi̱ 'yøthʉ. Nu̱'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ i̱ nnu̱tho te guí øthʉ, go da̱ gu̱t'a̱hʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","A nu̱'mø ngue guí̱ mmat'Oja̱hʉ, 'yo guí øthʉ tengu̱tho øtyø ja̱'i̱ ngue hi̱ngyø mmʉi ga̱ 'yøt'a̱ te øt'e. Di ho te ørbʉ ja yø ni̱ja̱ ngue 'bäi ha ga̱ mmat'Oja̱. I̱ nnepe ngue da̱ nu̱ gätho yø ja̱'i̱ te øt'e. Da̱ guep'ʉ ja yø caye i̱ mmat'Oja̱ p'ʉ ni̱ ma. Pɛ nu̱gä ma̱jua̱ni̱ te dí xi'a̱hʉ ngue nu̱'a̱ ga̱ nnu̱ma̱nho yø ja̱'i̱ te øt'e, ya hønt'a̱ yø nzäbi'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pɛ nu̱'a̱hʉ, nu̱'mø guí̱ mmat'Oja̱hʉ, da̱mi̱ cʉt'a̱mbo ni̱ ngu̱hʉ, tøtra̱ goxthi, da̱mi̱ ma̱t'Oja̱hʉ p'ʉya. A nu̱na̱ Oja̱ ni̱ Papáhʉ, ja 'bʉp'ʉ ha guí 'bʉhmʉ na̱, go nnu̱ dra̱ mhmat'Oja̱ guí ørbʉ ja ni̱ ngu̱hʉ na̱, 'nɛ̱ go da̱ gu̱t'a̱hʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nu̱'mø gá̱ ma̱t'Oja̱hʉ, 'yo ja ga̱di 'yopthobi yø hya̱ guí̱ xihmʉ Oja̱. Porque ngu̱'a̱ øtyø ja̱'i̱ hi̱ngui̱ pa̱ Oja̱, i̱ ɛ̱na̱ ngue nu̱'a̱ ya'atho gui ya̱hni̱, gue'a̱ di 'yø Oja̱ te xi'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pɛ 'yoguí øthʉ tengu̱tho øt'ʉ. Porque nu̱na̱ Oja̱ ni̱ Papáhʉ, ya pa̱di̱ te gä guí homhmʉ hante ngue gui 'yäpi te guí̱ nnehʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ja̱na̱ngue nu̱'mø gá̱ mat'Oja̱hʉ, da̱mi̱ 'yɛ̱mhmʉ: Ma̱ Papá'a̱he guí 'bʉ ma̱hɛ̱ts'i̱, da̱mi̱ 'yøt'e ngue da̱ hnu̱ ma̱nsu̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bá̱ ɛ̱hɛ̱ gui̱ ma̱nda ua. Di̱ nja'a̱ te ni̱ pähä ua ja ra̱ xi̱mhäi tengu̱tho bí ja ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Da̱mi̱ 'dacje ra̱ hmɛ̱ n'na pa ngu̱ n'na pa. ");
INSERT INTO otnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Nɛ̱ da̱mi̱ pu̱nnga̱ ma̱ ts'oquihe, tengu̱tho gähe xquet'a̱ da̱di pu̱nnba̱he to hi̱ngui̱ ho te ørca̱he. ");
INSERT INTO otnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Da̱mi̱ fäxca̱he ngue hi̱nga̱ øt'ähe ra̱ nts'o. Da̱mi̱ ya̱nje ngue ra̱ nts'o. Porque nu̱'i̱, gue'e ga̱di̱ mma̱ndasɛ, jasɛ ni̱ ts'ɛdi, guí ta̱te para za̱ntho. Da̱ ngu̱t'a̱tho. ");
INSERT INTO otnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nu̱'mø guí 'bʉi ngue guí pu̱nnba̱bi̱ yø ja̱'i̱ hi̱ngui̱ ho te øt'a̱hʉ, nu̱'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ xquet'a̱ di pu̱n'na̱ ni̱ ts'oquihʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pɛ nu̱'mø hi̱nguí̱ nne guí pu̱nnba̱bi̱ ni̱ mmi̱c'ɛ̱i̱ui te øt'a̱hʉ, nu̱'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ xquet'a̱ hi̱ndi̱ pu̱n'na̱ ni̱ ts'oquihʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nu̱'mø guí̱ nne ngue gui 'yɛ'ni̱ mmʉihʉ, 'yo ga̱di hmi̱ du̱mmʉihʉ tengu̱tho øtyø ja̱'i̱ ngue hi̱ngyø mmʉi ga̱ 'yøt'a̱ te øt'e. A nu̱yá, di hmi̱ du̱mmʉi 'mø ɛtyø mmʉi, i̱ nne ngue da̱ nu̱ yø ja̱'i̱ te øt'e. Pɛ ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱'a̱ ga̱ nnu̱ ma̱nho yø ja̱'i̱ te øt'e, ya hønt'a̱ yø nzäbi'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pɛ nu̱'a̱hʉ, nu̱'mø guí ɛ'ni̱ mmʉihʉ, 'yo ga̱di hmi̱ du̱mmʉihʉ, sinoque da̱mi̱ 'yejni̱ ya̱hʉ 'nɛ̱ da̱mi̱ nxʉdähʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","'Yo guí̱ nnehʉ ngue di u̱nna̱ güɛnda yø ja̱'i̱ ngue guí ɛ'ni̱ mmʉihʉ. Hi̱nda̱ hønt'a̱ ni̱ Papáhʉ pa̱di̱ ngue guí ɛ'ni̱ mmʉihʉ, go da̱ gu̱t'a̱hʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","'Yo guí̱ nnehʉ ngue xøgue nma̱ mu̱nts'i̱tho'a̱ te guí pɛshʉ ua ja ra̱ xi̱mhäi. Porque nu̱'a̱ te guí pɛshʉ ua ja ra̱ xi̱mhäi, da̱ zi yø zu̱'ɛ̱, ya di̱ nts'oni̱. Ogue da̱ bɛ̱ yø bɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","A nu̱yá, da̱mi̱ nehʉ ngue nu̱p'ʉ ma̱hɛ̱ts'i̱, ja bí jap'ʉ ra̱ nho guí̱ nthɛhʉ, nu̱'a̱ hi̱nha di̱ m'mɛdi. Ya hi̱nda̱ zä da̱ zi yø zu̱'ɛ̱, 'nɛ̱ hi̱nda̱ zä da̱ zønyø bɛ̱ ngue da̱ bɛ̱'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nu̱'mø guí ɛ̱mhmʉ ngue bí ja ma̱hɛ̱ts'i̱'a̱ ra̱ nho ta̱te di̱ mu̱ui, hønnbʉ da̱ zo ni̱ mmʉihʉ p'ʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nu̱'mø bi xogui xa̱nho ni̱ dähʉ ya, ya guí hɛ̱thʉ xa̱nho ra̱ nyot'i i ja. Njarbʉtho ni̱ n'yomfɛ̱ni̱hʉ ya, nu̱'mø bi xogui xa̱nho, ya guí pa̱hmʉ ndana̱ ra̱ nho gdi̱ n'yohʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pɛ nu̱'mø hi̱ngui̱ xogui xa̱nho ni̱ n'yomfɛ̱ni̱hʉ, ya hi̱mma̱ jua̱ni̱ guí pa̱hmʉ ndana̱ ra̱ nho gdi̱ n'yohʉ 'mø. Ya nsʉtho 'mø ngue ra̱ ts'a'bɛxu̱i̱ p'ʉ gni̱ mähä, porque hi̱ngui̱ xohni̱ n'yomfɛ̱ni̱hʉ ngue guí pa̱hmʉ ndana̱ ra̱ nho. ");
INSERT INTO otnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hi̱ngui̱ sä ngue yoho yø hmu̱ ra̱ ja̱'i̱ di̱ m'mʉi. A nu̱'mø ngue yoho yø hmu̱ di̱ m'mʉi, n'na'a̱ di̱ ma̱di̱, n'na'a̱ hi̱ndi̱ ma̱di̱. N'na rá̱ hmu̱ da̱ 'yørpe te di̱ ma̱nda, ma̱n'na rá̱ hmu̱ hi̱nda̱ 'yørpe te di̱ ma̱nda. Gui̱ njathʉ p'ʉya, hi̱ngui̱ sä ngue mbø yoho p'ʉ di̱ ma ni̱ mmʉihʉ. Di̱ ma ni̱ mmʉihʉ Oja̱, xi̱ndi̱ ma ni̱ mmʉihʉ ra̱ mɛ̱nyu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nu̱gä dí̱ mma̱, nu̱'a̱ te ja ngue gui sihʉ, ogue te ja ngue gui hyehʉ, 'yo gue'a̱ ma̱thoguitho ga̱ ndu̱ ni̱ mmʉihʉ'a̱. A nu̱yá, nu̱ rá̱ te ra̱ ja̱'i̱, ma̱n'natho di̱ mu̱ui ngue'a̱ te da̱ zi. Nu̱ rá̱ do'yo ra̱ ja̱'i̱, ma̱n'natho di̱ mu̱ui ngue'a̱ te da̱ hye. ");
INSERT INTO otnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ya guí̱ nnu̱hʉ yø ts'ints'ʉ 'yo ma̱ya̱, ngue hi̱ngui̱ ua̱hi̱, 'nɛ̱ hi̱ngui̱ xofo ngue te da̱ mɛts'i. Pɛ nu̱na̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱, go di u̱nni̱ te si yø ts'ints'ʉ na̱. Goma̱ gue'a̱hʉ ya, ngue hi̱nda̱ mäxa̱hʉ Oja̱, porque ma̱n'na xa̱mma̱di̱'a̱hʉ ngue yø ts'ints'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Xiya, xi ra̱ ja̱'i̱ tu̱ rá̱ mmʉi ngue hi̱ngui̱ hɛ̱ts'i̱, ¿ua da̱ zä di̱ nte ma̱n'na doyʉni̱ ngue'a̱ ga̱ nhɛ̱ts'i̱? ");
INSERT INTO otnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","'Yo di tu̱ ni̱ mmʉi te gui hyehʉ. Ya guí̱ nnu̱hʉ yø døni̱ bí ja da̱po ngue hi̱ndi̱ mpɛfi, ni̱ xi̱ngui̱ mpe, pɛ ma̱hotho gui̱ nɛ̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dí xi'a̱hʉ na̱ ra̱ hya̱ na̱, ngue tengu̱ ra̱ da̱st'abi Salomón, ma̱ndønho drá̱ he bi hye, pɛ hi̱nha da̱ zʉdi tengu̱ ga̱nho yø døni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Porque guesɛ Oja̱ øt'e ngue ma̱zihotho gui̱ nɛ̱qui̱ yø døni̱ bí ja da̱po. Bí ja da̱po ya, pɛ ni̱xu̱di̱ p'ʉya, di̱ nzø p'ʉ ja ra̱ orno. Goma̱ gue'a̱hʉ ngue hi̱ndi̱ he'a̱hʉ Oja̱. Pɛ hi̱ngá̱ ɛgui ɛ̱c'ɛ̱i̱hʉ xa̱nho ngue fäxa̱hʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ja̱na̱ngue nu̱yá, 'yo ma̱thoguitho di tu̱ ni̱ mmʉihʉ ngue sä gui 'yɛ̱mhmʉ: “¿Te 'bɛ'a̱ ga̱ sihʉ ya, o gue te 'bɛ'a̱ ga̱ hehʉ ya?” gui 'yɛ̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porque yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi, hønt'a̱ te da̱ zi 'nɛ̱'a̱ te da̱ hye ni̱ ma yø mmʉi honi̱. Pɛ nu̱'a̱hʉ, nu̱'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱, ya pa̱di̱ ngue guí homhmʉ gätho ya yø cosa ya. ");
INSERT INTO otnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ja̱na̱ngue nu̱yá, ma̱ da̱tho da̱mi̱ hyoni̱ ha gdi sohʉ rá̱ 'yɛ Oja̱. Nu̱ya yø hya̱ di̱ ma̱nda Oja̱, da̱mi̱ ja ndu̱mmʉi gui 'yøthʉ, n'namhma̱ ngue di 'da'i te gäma̱ cosa gui homhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","A nu̱yá, 'yo sä ma̱'dihi di tu̱ ni̱ mmʉihʉ'a̱ te ja ngue gui thohmʉ ni̱xu̱di̱. Porque n'na ngu̱ n'na yø pa ja te thohyø ja̱'i̱. Høntho ngue nu̱'a̱ ra̱ n'ʉ guí thohmʉ n'na pa ngu̱ n'na pa da̱mi̱ hyoni̱ ha gdi thohmʉ'a̱ ra̱ pa'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","'Yo guí ha̱spa̱hʉ ra̱ güɛnda te ør'mi̱'da yø ja̱'i̱, n'namhma̱ ngue hi̱nda̱ hya̱ts'a̱hʉ ra̱ güɛnda Oja̱ te guí øthʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porque da̱ tha̱ts'a̱hʉ ra̱ güɛnda tengu̱tho gni̱ hya̱spa̱hʉ ra̱ güɛnda mi̱'da yø ja̱'i̱. Tengu̱tho gui 'yøthʉ, xquet'a̱ gue'a̱ di̱ nja'a̱hʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Hanja yø ja̱'i̱ ngue ja xa̱ngu̱ yø ts'oqui, guehya nne da̱ hya̱spa̱ ra̱ güɛnda yø ja̱'i̱ ngue ts'ʉdyø ts'oqui ja ya? Tengu̱tho 'mø guí xihni̱ cu̱ ngue oxra̱ häi rá̱ dä, pɛ nu̱'i̱ p'ʉya, ra̱ biga di o ni̱ dä. ");
INSERT INTO otnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ya hi̱nda̱ zä gui 'yɛ̱mni̱ cu̱: “Ague n'yø, tø ga̱ ha̱hmi̱ ra̱ häi o ni̱ dä”, gui 'yɛ̱mbi̱. A nu̱'i̱ p'ʉya, hi̱n ga̱di̱ u̱nna̱ güɛnda ngue ra̱ biga oxni̱ dä. ");
INSERT INTO otnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ya hi̱nni̱ 'yu̱p'ʉ te guí̱ mma̱. 'Be da̱mi̱ hya̱hra̱ biga o ni̱ dä n'namhma̱ da̱ zä gui hya̱mba̱ ra̱ häi o rá̱ dä ni̱ cu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nu̱na̱ ra̱ hya̱ guí̱ nnu̱ ma̱ndʉxquihʉ, nu̱ ra̱ ja̱'i̱ ngue ma̱ndønts'o drá̱ mmʉi hi̱nda̱ zä gui xihmʉ ra̱ hya̱. Porque n'na ra̱ cosa xa̱ndʉxqui, hi̱ngui̱ sä di t'u̱nyø fo'yo. Nu̱'mø bi̱ ncuɛ ra̱ fo'yo, da̱ za'a̱hʉ. Xi̱mma̱ngu̱ n'na ra̱ cosa ngue ma̱ndø mma̱di̱tho, hi̱ngui̱ sä di t'u̱nyø ts'ʉdi, porque ra̱ ts'ʉdi di 'da'mi̱, da̱ nɛp'ʉ häi'a̱ te guí u̱nhnʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nu̱na̱ Oja̱ di 'da'i te guí homhmʉ. Da̱mi̱ 'yäpi te guí̱ nnehʉ. Nu̱ te gui hyoni̱, gui ti̱ni̱. Nu̱'mø gá̱ jätra̱ goxthi ngue gui̱ nzohmʉ Oja̱, da̱ xoc'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porque nu̱ ra̱ ja̱'i̱ ädi te nne, ma̱ t'u̱nni̱. Nu̱'a̱ honi̱, i ti̱ni̱. Nu̱'a̱ di jätra̱ goxthi, i sojpi. ");
INSERT INTO otnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Conque nu̱ ra̱ ja̱'i̱ 'bʉhrá̱ ba̱si̱, nu̱'mø bi 'yäpra̱ thu̱hmɛ̱, hi̱ngui̱ sä rá̱ mmʉi ra̱ ja̱'i̱ ngue ra̱ do di u̱nná̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ogue ra̱ hua̱ da̱ 'yäprá̱ ba̱si̱, hi̱ngra̱ c'ɛ̱ya̱ di u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A nu̱yá, i ja ni̱ ts'oquihʉ, pɛ guí pa̱di̱ guí u̱nna̱ cosa nu̱'a̱ xa̱nho ni̱ ba̱si̱hʉ. Ma̱n'natho'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ ngue xa̱ndønho te di 'da'a̱hʉ 'mø gui 'yäphʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tengu̱ gni̱ ne ngue da̱ mäxa̱hʉ yø ja̱'i̱, da̱ ngu̱'a̱ gui 'yøthʉ, da̱mi̱ 'yørpa̱hʉ ra̱ 'bäxte mi̱'da yø ja̱'i̱. Ja ni̱ ga̱xpʉ gätho yø hya̱ nt'ot'i p'ʉ ja ra̱ ley, da̱ gue'ʉ yø hya̱ bi 'yotyø pønga̱hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mɛ̱nte guí 'bʉhmʉ ua ja ra̱ xi̱mhäi, da̱mi̱ hya̱xhʉ ra̱ 'yu̱ njua̱ntho. A nu̱yá, para ngue da̱ zä gui hya̱xhʉ na̱ ra̱ 'yu̱ na̱, da̱mi̱ cʉthʉ p'ʉ ja ra̱ goxthi̱ hi̱ngui̱ xi̱di̱. Porque nu̱na̱ ra̱ 'yu̱ ni̱ ma ni̱du̱ hi̱ngui̱ nnu̱ ma̱nhɛ̱nni̱ yø ja̱'i̱ na̱, ngue xa nxi̱di̱ ra̱ goxthi 'nɛ̱ xa̱ nxi̱di̱ ra̱ 'yu̱. Pɛ ma̱ndøngu̱ dyø ja̱'i̱ ni̱ map'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pɛ nu̱ ra̱ 'yu̱ njua̱ntho da̱ hya̱xra̱ ja̱'i̱ di̱ nthɛui ra̱ 'da'yo te, hi̱ngui̱ xi̱di̱ ra̱ goxthi 'nɛ̱ hi̱ngui̱ xi̱di̱ ra̱ 'yu̱. Pɛ ziyohotho yø ja̱'i̱ ni̱ map'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Da̱mi̱ mfähmʉ xa̱ndønho, nu̱ya yø fɛhni̱ xännba̱te da̱ zøp'ʉ guí 'bʉhmʉ, da̱ 'yɛ̱na̱ ngue mma̱mbrá̱ hya̱ Oja̱. 'Yo di hä'a̱hʉ, porque ma̱xøts'itho di̱ nɛ̱qui̱ ngue yø hoga̱ n'yohʉ, pɛ nu̱ te ga̱ 'yo, gä ra̱ nts'oni̱ ørbʉ ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nu̱'a̱ te ga̱ 'yo, gue'a̱ gdi̱ pa̱hmʉ te'o'a̱. Tengu̱tho p'ʉ ja ra̱ 'ui̱ni̱, guí pa̱hmʉ ngue hi̱nga̱ ja di̱ nzʉp'ʉ yø uva. Ni̱ xi̱ngyø igo di̱ nzʉp'ʉ ja yø 'ui̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Porque guí pa̱hmʉ ngue n'na ra̱ hoga̱ za, ra̱ hoga̱ ndät'ä zʉdi. Pɛ nu̱'a̱ hi̱ngra̱ hoga̱ za, hi̱ngui̱ ho yø ndät'ä zʉdi. ");
INSERT INTO otnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nu̱ ra̱ hoga̱ za, hi̱nga̱ ja zʉp'ʉ ra̱ ndät'ä hi̱ngui̱ ho. Nu̱'a̱ hi̱ngra̱ hoga̱ za, hi̱nga̱ ja zʉp'ʉ ra̱ hoga̱ ndät'ä. ");
INSERT INTO otnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nu̱ gätho yø za hi̱ngui̱ ho yø ndät'ä zʉdi da̱ ma nt'ɛts'i ngue da̱ t'u̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ja̱na̱ngue dí xi'a̱hʉ ngue nu̱'a̱ te ga̱ 'yo ya yø fɛhni̱ xännba̱te, gue'a̱ gdí pa̱hmʉ te'o'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nu̱ya yø ja̱'i̱ da̱ 'yɛ̱ngui̱ ngue drá̱ Hmu̱gui̱, hi̱nga̱ gä da̱ yʉrbʉ ha di̱ ma̱nda Oja̱. Nu̱'ʉ ma̱jua̱ni̱ ngue da̱ yʉrbʉ di̱ ma̱nda Oja̱, gue'ʉ yø ja̱'i̱ da̱ 'yørpa̱bi̱ rá̱ pähä ma̱ Papá bí 'bʉ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nu̱'mø bi zønna̱ pa da̱ tha̱spa̱ ra̱ güɛnda yø ja̱'i̱, xa̱ndøngu̱ yø ja̱'i̱ da̱ 'yɛ̱ngui̱: “Grá̱ hmu̱, grá̱ hmu̱. Xquet'a̱ 'nɛ̱cähe dá̱ xicähe yø ja̱'i̱ te'o'i. 'Nɛ̱ conni̱ thu̱hu̱ dá̱ øthegähe yø ja̱'i̱ mi̱ n'youi yø ts'onthi̱. 'Nɛ̱ conni̱ thu̱hu̱ dá̱ øt'ähe xa̱ngu̱ yø milagro”, da̱ 'yɛ̱ngui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nu̱'mø dá̱ tha̱cä p'ʉya, ga̱ ɛ̱mbi̱: “Da̱mi̱ 'uemhmʉ ua dí 'bʉcä, porque hi̱mma̱ amigo'a̱hʉ. Porque høndra̱ nts'o xquí̱ n'yohʉ”, ga̱ ɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nu̱ ra̱ ja̱'i̱ øde te gäma̱ hya̱ dí̱ mma̱ngä 'nɛ̱ da̱ 'yøt'e te dí xifi, guehna̱ nná̱ hyɛjpa̱bi̱ n'na ra̱ n'yohʉ ngue ra̱ njammʉi na̱, ngue ra̱ mmʉndo p'ʉ bi hyøhrá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nu̱'mø bi̱ nja ra̱ 'ye, bi̱ mo ra̱ da̱the, bi̱ n'yo ra̱ nda̱hi̱ ngue bi̱ nønhna̱ ngu̱. Pɛ hi̱mbi̱ dägui, porque ra̱ mmʉndo p'ʉ høxrá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pɛ nu̱ ra̱ ja̱'i̱ øde te gäma̱ hya̱ dí̱ mma̱ngä, 'nɛ̱ hi̱nda̱ 'yøt'e te dí xifi, guehna̱ nná̱ hyɛjpa̱bi̱ n'na ra̱ n'yohʉ ngue hi̱n'yʉ rá̱ n'yomfɛ̱ni̱ na̱. Guep'ʉ ja ra̱ 'bomu̱ dehe bi hyøhrá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mi̱ n'ye p'ʉya, bi̱ mo ra̱ da̱the, bi̱ n'yo ra̱ nda̱hi̱ ngue bi̱ nønhna̱ ngu̱. Bi xot'i, ma̱xøgue bi̱ n'uɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mi̱ juahya yø hya̱ bi xännba̱ yø ja̱'i̱ ra̱ Jesús, di 'yødyø ja̱'i̱ ya yø hya̱ bi xifi. ");
INSERT INTO otnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porque yø xännba̱te ngue ra̱ ley hi̱ngui̱ ya̱ ma̱nzaqui 'mø xännba̱te, pɛ nu̱na̱ ra̱ Jesús ɛ̱na̱ nts'ʉt'abitho 'mø xännba̱te, nu̱ te mma̱ ngue di̱ nja gue'a̱ di̱ njahma̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ma̱mbá̱ ɛ̱p'ʉ bí ja ra̱ nyu̱ni̱ ma̱mbi 'bʉhra̱ Jesús, xa̱ngu̱ yø ja̱'i̱ bá̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bi guat'a̱ n'na ra̱ n'yohʉ mi̱ hɛ̱mbra̱ ts'o'ya p'ʉya. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bʉhra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ hmu̱, nu̱'mø guí̱ nne gui 'yørca̱ ra̱ ma̱te gui 'yøthegui, nu̱gä dí pa̱di̱ ngue da̱ zägui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ra̱ Jesús bi dots'i conná̱ 'yɛ, bi 'yɛ̱mbʉya: ―A̱há̱, dí̱ nne ga̱ øthe'i. Da̱ zä'i ya ―bi 'yɛ̱mbi̱. Høntho bi̱ ma̱nna̱ ra̱ hya̱ na̱, nu̱na̱ ra̱ därquɛ̱hi̱ mi̱ 'ya rá̱ do'yo, 'bexpi zä ha mi̱ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ra̱ Jesús bi 'yɛ̱mbra̱ n'yohʉ mi̱'ʉ: ―Nu̱yá, 'yo to guí xifi te dá̱ øt'a̱'i̱ ya. 'Be ni̱ ma ya, sømp'ʉ 'bʉhra̱ mmäcja̱. Da̱ nu̱ ngue ya bi zä'i. Da̱mi̱ 'yøtra̱ 'bøt'e tengu̱tho bi̱ ma̱nda ra̱ Moisés ngue da̱ 'yøtyø ja̱'i̱ 'mø bi zä ra̱ 'ya hɛ̱mbi̱. Ja̱na̱ngue da̱ ba̱di̱ gätho yø ja̱'i̱ ngue ya bi zä'i. ");
INSERT INTO otnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nu̱na̱ ra̱ Jesús, mi̱ zømp'ʉ ja ra̱ hni̱ni̱ Capernaum. Bi̱ ma bá̱ äpra̱ ma̱te n'na ra̱ capita. ");
INSERT INTO otnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Bi 'yɛ̱mbi̱: ―Ague grá̱ hmu̱, nu̱'a̱ n'na ra̱ ts'ʉnt'ʉ di̱ mpɛp'ʉ ja ma̱ ngu̱, sä ra̱ nda̱te ngue tu̱ gä rá̱ do'yo ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ra̱ Jesús bi 'yɛ̱mbra̱ n'yohʉ äpra̱ ma̱te: ―Ga̱ mmagä p'ʉ 'mø, ga̱ ma øthegä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nu̱'a̱ ra̱ capita p'ʉya, ma̱hømbi 'yɛ̱mbra̱ Jesús: ―Pɛ ague grá̱ hmu̱, 'yo ga̱di̱ n'ʉni̱. Nu̱gä hi̱mma̱ nsä'be ngue guí cʉrbʉ ja ma̱ ngu̱. A nu̱yá, høntho da̱mi̱ ma̱nya ngue da̱ zä ra̱ ts'ʉnt'ʉ dí xi'i, ya dí pa̱di̱ ngue da̱ zä ra̱ n'ʉ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porque nu̱gui̱ xquet'a̱ 'bʉi to 'bɛt'o ngue di̱ ma̱ndagui̱. A nu̱gä p'ʉya, xquet'a̱ dí si ma̱ soldado da̱di̱ ma̱nda. Nu̱'mø dí xi'a̱ n'na ra̱ soldado ngue ha da̱ ma, i pap'ʉ dí ɛt'i. Ogue ga̱ ɛ̱mbi̱: “Bi 'yɛ̱cua”, ra̱ soldado p'ʉya bá̱ ɛ̱p'ʉ. Ogue ma̱ hmi̱qui̱, ga̱ 'bɛpi te da̱ mɛfi, ra̱ hmi̱qui̱ øt'e te dí xifi. ");
INSERT INTO otnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nu̱na̱ ra̱ Jesús mi̱ 'yøde te xihra̱ capita, di 'yøtho te sifi. Bi 'yɛ̱mbyø ja̱'i̱ n'youi p'ʉya: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue hi̱njonni̱ judío di pøni̱ ngue gdi ti̱nnbä rá̱ nt'ɛ̱c'ɛ̱i̱ tengu̱ ga̱ 'yɛ̱c'ɛ̱i̱gä na̱ ra̱ n'yohʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nu̱gä dí xi'a̱hʉ ngue xa̱ngu̱ yø ja̱'i̱ hi̱ngyø judío dí bømp'ʉ ni̱ bøxyadi 'nɛ̱p'ʉ ni̱ yʉhra̱ hyadi, ngue nu̱p'ʉ di̱ ma̱nda Oja̱ p'ʉ ma̱hɛ̱ts'i̱, 'dap'ʉ di̱ nsi̱hmɛ̱ui ra̱ Abraham, conna̱ Isaac, conna̱ Jacob. ");
INSERT INTO otnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A nu̱'ʉ yø ja̱'i̱ mi̱ jahma̱ ngue xta̱ nzo rá̱ 'yɛ Oja̱ 'nɛ̱ hi̱mbi̱ ne, da̱ t'ɛmp'ʉ thi ja ra̱ 'bɛxu̱i̱'ʉ. Ja di̱ nzomp'ʉ 'nɛ̱ ja di gu̱xpʉ yø ts'i'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ra̱ Jesús bi 'yɛ̱mbra̱ capita mi̱ nya̱ui: ―Ni̱ ma ni̱ ngu̱ ya. Nu̱'a̱ ra̱ hya̱ guí ɛ̱c'ɛ̱i̱ ngue da̱ zä ga̱ øt'e, ya bi̱ nja ya. Ngu̱ ra̱ ora bi̱ ma̱nna̱ ra̱ hya̱ na̱, 'bexpi zä ra̱ ts'ʉnt'ʉ mi̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ra̱ Jesús bi̱ map'ʉ ja rá̱ ngu̱ ra̱ Bɛdu. Nu̱'a̱ rá̱ to ra̱ Bɛdu oxpʉ ja rá̱ t'ots'i ngue mi̱ hɛ̱mbra̱ pa. ");
INSERT INTO otnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ra̱ Jesús bi bɛnnba̱ rá̱ 'yɛ ra̱ därquɛ̱hi̱ ngue bi gʉts'i. 'Bexpi zä ra̱ pa mi̱ hɛ̱mbi̱. Nu̱na̱ ra̱ xisu p'ʉya, bi̱ nangui̱ ngue bi hojpi te da̱ zi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mi̱ dähra̱ nde p'ʉya, nu̱p'ʉ 'bʉhra̱ Jesús, xa̱ngu̱ yø ja̱'i̱ n'youi yø ts'onthi̱ bá̱ ts'i̱nnbi̱ ngue da̱ 'yøthe. Pɛ ra̱ Jesús høntho da̱ ma̱ ngue da̱ zä yø ja̱'i̱ n'youi yø ts'onthi̱, 'bexi sä. 'Dama̱ 'dan'yo yø n'ʉ hɛ̱mbyø ja̱'i̱, pɛ gä bi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mi̱ nja na̱ ra̱ hya̱ na̱, ya bi̱ nja'a̱ te ra̱ hya̱ bi̱ ma̱nna̱ pønga̱hya̱ Isaías ngue bi 'yɛ̱na̱: “Nu̱ te gäma̱ n'ʉ gmi̱ hɛ̱mphʉ, gä bi hya̱qui hapʉ mi̱'ʉ”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mi̱ nu̱ ra̱ Jesús ngue ma̱ndøngu̱ dyø ja̱'i̱ di̱ mäts'i. Bi xihyø xädi p'ʉya ngue bi̱ mähä dí̱ ma ma̱n'na nguadi ra̱ zabi. ");
INSERT INTO otnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nu̱'a̱ n'na ra̱ xännba̱te ngue ra̱ ley bi guarbʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, nu̱gä dí̱ nne ga̱ mmɛ hapʉ gdí̱ ma ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ra̱ Jesús bi 'yɛ̱mp'a̱ ya̱ui: ―Yø haho ja yø 'bido hapʉ säya. Yø ts'ints'ʉ ja yø 'bafi hapʉ säya. Pɛ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, hi̱n'yʉ rá̱ ngu̱ hapʉ di̱ n'oxi. ");
INSERT INTO otnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pɛ nu̱'a̱ n'na nc'ɛ̱i̱ rá̱ xädi bi 'yɛ̱mbi̱: ―Ague grá̱ hmu̱, da̱mi̱ 'dacra̱ nt'ɛ̱di̱ ngue 'be da̱ du̱ ma̱ papá, ga̱ ägui, ya ga̱ mɛ p'ʉya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma ga̱ mmɛhma̱. Nu̱'ʉ yø ja̱'i̱ ɛ̱ntho ya xa̱ ndu̱ ngue hi̱ngui̱ pa̱ Oja̱, gue'ʉ da̱ 'yähyø mmi̱ndu̱ui'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nu̱na̱ ra̱ Jesús bi yʉrbʉ ja ra̱ barco ngue bi̱ ma, bi̱ mähä yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pɛ nu̱p'ʉ ja ra̱ zabi, bi̱ nanga̱ n'na ra̱ nda̱te nda̱hi̱. Nu̱'ʉ yø fʉnthe nangui̱, so mbo ra̱ barco mɛ̱nte a̱tho ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nu̱'ʉ yø xädi p'ʉya, bá̱ äp'ʉ bí̱ a̱ha̱, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, da̱mi̱ ya̱nje. Ya ja ngue da̱ thu̱nt'a̱ mbonthe ra̱ barco. Ya ga̱ tu̱hʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―¿Hanja ngue guí su̱hʉ? ¿Ua hi̱nguí̱ ɛ̱c'ɛ̱i̱ ngue ga̱ fäxa̱hʉ? ―bi 'yɛ̱mbi̱. Mi̱ nangra̱ Jesús, bi hɛjpa̱bi̱ ra̱ nda̱hi̱ 'nɛ̱hyø fʉnthe. Mi̱ hɛjpi, 'bexpi̱ nsäya. ");
INSERT INTO otnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nu̱'ʉ yø xädi p'ʉya, di 'yøtho te bi̱ nja. Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na: ―¿Te'o ni̱ n'yohʉ na̱ n'yø? Asta̱ ra̱ nda̱hi̱ 'nɛ̱hra̱ dehe ɛ̱c'ɛ̱i̱ 'mø bi zofo ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mi̱ zøm ma̱n'na nguadi ra̱ zabi, ja ra̱ häi ni̱ hu̱ ngue Gadara. Ja bi̱ nthɛui p'ʉ ra̱ Jesús yoho yø n'yohʉ mi̱ n'youi yø ts'onthi̱. Pɛ ma̱ndønts'otho, xpí 'yɛ̱p'ʉ ja ra̱ camposanto. Asta̱ nts'u̱tho to da̱ thop'ʉ ja ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mi̱ nu̱ ra̱ Jesús, bi̱ mʉhra̱ mafi. Bi 'yɛ̱mbi̱: ―Ague Jesús, rá̱ Ts'ʉnt'ʉ'i Oja̱, ¿hanja ngue ga̱di̱ nthi̱nt'ua dí̱ 'bʉcähe? Porque tobe hi̱ngui̱ sønna̱ pa ngue gui pɛnnga̱he ra̱ castigo ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nu̱p'ʉ yap'ʉtho, ma̱mbi̱ 'yop'ʉ n'na 'bʉi yø ts'ʉdi, ma̱ 'yoni̱ p'ʉ ngue si̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nu̱'ʉ yø ts'onthi̱ bi 'yɛ̱mbra̱ Jesús: ―Nu̱'mø guí̱ nne ngue ga̱ hɛcähe ua ya yø n'yohʉ 'bʉcua, pɛ da̱mi̱ 'dacje ra̱ nt'ɛ̱di̱ ngue ga̱ cʉt'ähe yø mmʉi yø ts'ʉdi bí 'yonʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ra̱ Jesús bi̱ u̱nna̱ nt'ɛ̱di̱ yø ts'onthi̱, bi 'yɛ̱mbi̱: ―I̱ mähä nʉ bí 'bʉhyø ts'ʉdi 'mø. Ja̱na̱ngue nu̱'ʉ yø ts'onthi̱ bi hyɛp'ʉ yø n'yohʉ mi̱ n'youi, i̱ ncʉrbʉ ja yø mmʉi yø ts'ʉdi. Yø ts'ʉdi p'ʉya, bi gʉ ra̱ 'dihi, bi̱ nhyørbʉ ja ra̱ zabi. Gä ja bi ja̱rbʉ ra̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nu̱'ʉ mi̱ fähyø ts'ʉdi p'ʉya, bi̱ nsu̱ 'mø mi̱ nu̱ te bi̱ nja. N'na 'dihitho bi̱ map'ʉ bí ja ra̱ hni̱ni̱ ngue bá̱ ma̱ te bi̱ nja. Bi̱ ma̱ tengue xi thohyø ts'ʉdi, 'nɛ̱ bi̱ ma̱ tengue xi tho'ʉ yø n'yohʉ mi̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nu̱'ʉ yø ja̱'i̱ ma̱mbí̱ 'bʉp'ʉ ja ra̱ hni̱ni̱, gä bi̱ ma ngue bi zømp'ʉ bí 'bʉhra̱ Jesús. Mi̱ zønyø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús, bi xifi ngue da̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ra̱ Jesús bi yʉrbʉ ja ra̱ barco ngue da̱ ma, di̱ ma ma̱n'na nguadi ra̱ zabi ha bí ja rá̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mi̱ zømp'ʉ ja ra̱ hni̱ni̱, bá̱ thu̱nnba̱bi̱ n'na nc'ɛ̱i̱ bá̱ oxrá̱ fi̱di̱ ngue tu̱dyø gua. Mi̱ nu̱ ra̱ Jesús te øtyø ja̱'i̱ bá̱ du̱ ra̱ därquɛ̱hi̱, i pa̱di̱ ngue ɛ̱c'ɛ̱i̱ yø ja̱'i̱ ngue da̱ zä da̱ 'yøthe ra̱ därquɛ̱hi̱. Bi 'yɛ̱mbra̱ därquɛ̱hi̱ p'ʉya: ―Ague ts'ʉnt'ʉ'i, 'yo tu̱ ni̱ mmʉi, ya dá̱ pu̱n'na̱ ni̱ ts'oqui ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nuna̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, mi̱ 'yøhyø xännba̱te ngue ra̱ ley, bi̱ mbøcuɛ. Bi 'yɛ̱mp'ʉ ja yø n'yomfɛ̱ni̱: “Nu̱na̱ ra̱ n'yohʉ 'bʉcua, thenma̱hya̱ Oja̱ na̱ co nu̱'a̱ ra̱ hya̱ i̱ mma̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pɛ ra̱ Jesús i pa̱tho te mbɛ̱nya yø n'yohʉ mbøcuɛ, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ hya̱ gá̱ bɛ̱mhmʉ ya, hi̱nga̱ ja rá̱ njap'ʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nu̱gä dá̱ xihra̱ n'yohʉ 'bʉcua, dí ɛ̱mbi̱: “Ya dá̱ pu̱n'na̱ ni̱ ts'oqui ya”. Pɛ nu̱yá, hi̱ndi̱ nɛ̱qui̱ xa̱nho ngue'mø bi̱ mpu̱nnbi̱ ogue hi̱n'na̱. Pɛ nu̱'mø ga̱ ɛ̱mbi̱: “Da̱mi̱ nangui̱, gui ca̱xni̱ fi̱di̱, gui̱ mma”, ga̱ ɛ̱mbi̱, nu̱'mø ngue bi̱ n'yo p'ʉya, ya guí pa̱hmʉ xa̱nho ngue ja ma̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","A nu̱yá, da̱mi̱ pa̱hmʉ ya ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ja rá̱ ts'ɛdi ua ja ra̱ xi̱mhäi ngue di pu̱nnba̱ yø ts'oqui yø ja̱'i̱. Bi 'yɛ̱mbra̱ n'yohʉ xa̱n'ʉ p'ʉya: ―Da̱mi̱ nangui̱, ca̱xni̱ fi̱di̱, ni̱ ma ni̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ra̱ därquɛ̱hi̱ p'ʉya, bi̱ nangui̱, bi̱ ma rá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mi̱ nu̱ yø ja̱'i̱ te bi̱ nja, bi̱ nsu̱ yø ja̱'i̱. Pɛ ɛ̱spa̱bi̱ Oja̱ porque di̱ nɛ̱qui̱ ngue Oja̱ di u̱nna̱ ts'ɛdi te ø'na̱ ra̱ n'yohʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mi̱ ma ra̱ Jesús, ni̱ nthop'ʉ ja rá̱ oficina n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Mateo, nu̱na̱ jʉmba̱ ra̱ mɛ̱nyu̱ yø ja̱'i̱ ja te pä. Mi̱ nu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma ga̱ mmɛ n'yø, ga̱ øt'e ngue ma̱ xädi'i ―bi 'yɛ̱mbi̱. Ra̱ Mateo p'ʉya, bi zop'ʉ rá̱ oficina ngue bi̱ mɛ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma̱n'na ra̱ pa p'ʉya, nu̱na̱ ra̱ Jesús bi̱ mɛ yø xädi p'ʉ ja rá̱ ngu̱ ra̱ Mateo ngue da̱ nsi̱hmɛ̱. Xa̱ngu̱ yø ngʉthäi 'bʉp'ʉ, co 'nɛ̱ hmi̱'da yø ja̱'i̱ t'ɛ̱mbi̱ ngue ja yø ts'oqui, gä 'dap'ʉ si̱hmɛ̱ui ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yø fariseo p'ʉya mi̱ nu̱ te øtra̱ Jesús, bi 'yørpa̱bi̱ ra̱ nt'änni̱'ʉ yø xädi, bi 'yɛ̱mbi̱: ―¿Hanja ni̱ xännba̱tehʉ ngue 'dap'ʉ si̱hmɛ̱hʉ yø ngʉthäi co 'nɛ̱hyʉ mi̱'da yø ja̱'i̱ ja xa̱ngu̱ yø ts'oqui? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mi̱ 'yøhra̱ Jesús te sipyø xädi, bi 'yɛ̱mp'ʉ di̱ ya̱hni̱: ―Nu̱ya yø ja̱'i̱ di hyɛ̱nni̱, guehya ni̱ 'yɛ̱hra̱ 'yøthe ya. Pɛ yø ja̱'i̱ xa̱nzaqui, hi̱nga̱ gue'ʉ ni̱ 'yɛ̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Da̱mi̱ xähmʉ te ni̱ bønyø hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Dí̱ nnegä ngue di̱ nja ni̱ nhuɛ̱ca̱tehʉ, porque guehna̱ ma̱n'natho di̱ mu̱ui na̱ ngue yø 'bøt'e guí ørca̱hʉ”, ɛ̱n'Oja̱. A nu̱gä, dá̱ ɛ̱hɛ̱ ngue gue'ʉ yø ja̱'i̱ ja yø ts'oqui ga̱ xifi da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo, hi̱nga̱ gue'ʉ yø ja̱'i̱ ɛ̱na̱ ngue ya 'yo xa̱nho dá̱ ɛ̱hɛ̱ ga̱ nzofo ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nu̱'ʉ yø xädi ra̱ Xuua bi guarbʉ 'bähra̱ Jesús. Bi 'yɛ̱mbi̱: ―¿Hanja ni̱ xädi ngue hi̱ngui̱ ɛtyø mmʉi? Conque nu̱gähe 'nɛ̱hyø fariseo ɛ̱mmɛ̱i̱ dí ɛ'ma̱ mmʉigähe ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ra̱ Jesús bi 'yɛ̱mbya ya̱ui: ―Nu̱'ʉ yø ja̱'i̱ ts'ofo ngue da̱ nu̱ ra̱ ntha̱ti̱, hi̱ngui̱ 'bʉ ndu̱mmʉi ngue da̱ 'yɛtyø mmʉi mɛ̱nte 'dap'ʉ 'bʉhmʉ ra̱ novio. Njarbʉtho ma̱ xädigä ya, hi̱ngui̱ ɛtyø mmʉi ngue 'daua dí̱ n'yo'be. Pɛ bá̱ ɛ̱p'ʉ ra̱ pa ngue da̱ ziga̱gui̱ ma̱ nsʉi'be. Nu̱'a̱ ra̱ pa'a̱ p'ʉya, mfa̱di̱ ngue da̱ zä da̱ 'yɛtyø mmʉi ya ma̱ xädi 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nu̱na̱ ra̱ 'da'yo hya̱ dí xännba̱te, n'nan'yo na̱ ngue ra̱ nyogui xädi. Tengu̱tho n'na ra̱ 'da'yo u̱lu, hi̱nda̱ zä di 'bøtra̱ zɛ'u̱lu. Porque ra̱ 'da'yo u̱lu di̱ nga̱nts'i̱, ya ma̱n'na di̱ nts'onna̱ zɛ'u̱lu. ");
INSERT INTO otnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tengu̱tho ra̱ 'da'yo vino hi̱ngui̱ sä da̱ sirbʉ ja ra̱ zɛxfani̱ ngue da̱ zɛdi. Porque ra̱ 'da'yo vino da̱ xɛtra̱ zɛxfani̱ 'mø da̱ sit'i, ja di̱ m'mɛp'ʉ p'ʉya. Ja̱na̱ngue ra̱ 'da'yo vino, ra̱ 'da'yo xifani̱ da̱ sit'i n'namhma ngue gä yoho hi̱ndi̱ m'mɛdi. ");
INSERT INTO otnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mɛ̱nte ra̱ Jesús bi xihyø ja̱'i̱ ya yø hya̱ ya, bi zø'a̱ n'na ra̱ n'yohʉ 'bɛt'o ngue yø judío. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ ma̱ t'i̱xu̱ ɛxa̱ ja bi̱ du̱, pɛ nu̱'mø guí̱ mma, gui japni̱ 'yɛ p'ʉ ja rá̱ do'yo, ma̱høndi̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ra̱ Jesús bi̱ nangbʉ mi̱ hu̱di̱, bi̱ mɛ'a̱ sits'i. Bi̱ mähä yø xadi. ");
INSERT INTO otnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mɛ̱nte ni̱ 'yo ra̱ Jesús, nu̱na̱ n'na ra̱ xisu ya n'nɛ'ma̱ yonjɛya mi̱ hɛ̱mbra̱ m'mäcji, bi guarbʉ ja rá̱ xʉtha ra̱ Jesús ngue bi därpa̱ rá̱ nya̱ni̱ rá̱ he. ");
INSERT INTO otnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","I ɛ̱n'a̱ mbo rá̱ mmʉi: “Nu̱'mø ga̱ thärpa̱bi̱ rá̱ he ra̱ Jesús, da̱ zägui”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mi̱ dädi, 'bexpi 'bätra̱ Jesús ngue bi hyɛ̱tra̱ xisu. Bi 'yɛ̱mbʉya: ―Ague t'i̱xu̱, da̱ hyu̱ ni̱ mmʉi. Ya bi zä'i ngue gá̱ 'yɛ̱c'ɛ̱i̱gui̱ ngue da̱ zä'i comma̱ ts'ɛdi ―bi 'yɛ̱mbi̱. 'Bexque'a̱ bi zä ra̱ n'ʉ mi̱ hɛ̱mbra̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mi̱ zømp'ʉ ja rá̱ ngu̱ ra̱ n'yohʉ na̱ ra̱ Jesús, bi̱ nu̱ ngue 'bʉp'ʉ yø mɛ'bida. Di yänni̱ yø ja̱'i̱ 'bʉp'ʉ ngue zoni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Da̱mi̱ pømhmʉ ua. Nu̱na̱ ra̱ hmu̱te 'bʉcua, hi̱ngui̱ tu̱ na̱, i a̱tho na̱ ―bi 'yɛ̱mbi̱. Pɛ nu̱ya yø ja̱'i̱ ya̱ui ra̱ Jesús, i̱ thentho, porque pa̱di̱ ngue ya xi du̱ ra̱ hmu̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mi̱ bøn'athi gätho yø ja̱'i̱ p'ʉya, ra̱ Jesús bi thop'ʉ brá̱ 'bɛnna̱ hmu̱te. Bi bɛnnba̱ rá̱ 'yɛ ra̱ hmu̱te bi gʉts'i. Ra̱ hmu̱te p'ʉya bi bɛ̱nna̱te, bi̱ nangui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nu̱ te bi 'yøtra̱ Jesús, bi̱ n'yo ra̱ hya̱ ndap'ʉ bi zä'a̱ ra̱ xɛqui'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ma̱mbá̱ ɛ̱p'ʉ ja ra̱ ngu̱ na̱ ra̱ Jesús, nu̱p'ʉ ja ra̱ 'yu̱ bi dɛnni̱ yoho yø xädä. Ni̱ mafi, bi 'yɛ̱mbi̱: ―Ague rá̱ mbom'mɛto'i ra̱ David, da̱mi̱ huɛ̱ga̱'be. ");
INSERT INTO otnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mi̱ yʉrbʉ ja rá̱ ngu̱ ra̱ Jesús, bi guatyø xädä. Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Ua guí ɛ̱c'ɛ̱i̱ui ngue da̱ zä ga̱ øt'ä na̱ te guí xicui ya? Yø xädä p'ʉya bi 'yɛ̱mbi̱: ―A̱há̱ grá̱ Hmu̱, dí ɛ̱c'ɛ̱i̱'be ngue da̱ zä gui 'yøt'e ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bi̱ macyø 'yɛ ra̱ Jesús ngue bi därpa̱ yø dä yø xädä. Bi 'yɛ̱mbi̱: ―Ngue guí ɛ̱c'ɛ̱i̱ui ngue da̱ zä ga̱ øthe'a̱ui, da̱ zä'a̱ui ya. ");
INSERT INTO otnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nu̱'ʉ yø xädä p'ʉya 'bexpi̱ nzø yø dä. Pɛ ra̱ Jesús di hɛjpi ngue hi̱nte da̱ ma̱, bi 'yɛ̱mbi̱: ―Ma̱n'nan'yo mi̱ 'yøt'e ngue guí̱ mma̱mmi̱ te dá̱ øt'a̱ui ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pɛ nu̱ya ma̱yø xädä, høntho bi̱ nhyɛhmi̱ ra̱ Jesús, to bi zä xifi te xi 'yørpa̱bi̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Høntho bi̱ ma ya ma̱yø xädä, bi zø hmi̱'da yø ja̱'i̱ p'ʉ ha 'bähra̱ Jesús, bá̱ zi̱nnba̱bi̱ n'na ra̱ n'yohʉ di gonebi ra̱ ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nu̱na̱ ra̱ Jesús bi japra̱ ts'onthi̱ ngue bi hyɛp'ʉ ra̱ ja̱'i̱ n'youi. Bi zä bi̱ nya̱ ra̱ gone. Pɛ yø ja̱'i̱ bi̱ nu̱ te bi̱ nja, di 'yøtho, di̱ n'yɛ̱mbi̱: ―Nu̱na̱ te dá̱ nu̱hʉ bi̱ nja ya, mɛ̱nte yø pa xa̱ thogui hi̱njongui̱ pøni̱ ngue da̱ ngu̱'a̱ da̱ 'yøt'ua ja ra̱ häi Israél. ");
INSERT INTO otnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pɛ yø fariseo bi 'yɛ̱na̱: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, i øthe yø ja̱'i̱ n'youi yø ts'onthi̱, porque gue'a̱ ra̱ zithu̱ yø hmu̱ yø ts'onthi̱ i fäts'i te øt'e ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nu̱na̱ ra̱ Jesús bi̱ n'yo ndap'ʉ bi zä yø hni̱ni̱. Nu̱p'ʉ ja yø hni̱ni̱ søni̱, xännba̱bi̱ rá̱ hya̱ Oja̱ yø ja̱'i̱ di̱ mpɛti p'ʉ ja yø ni̱ja̱ yø judío. I xihyø ja̱'i̱ ra̱ hoga̱ 'da'yo hya̱ ngue ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱ yø ja̱'i̱. Yø ja̱'i̱ 'dama̱ 'dan'yo ma̱n'ʉ hɛ̱mbi̱, pɛ gä bi 'yøthe ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nu̱'mø bi̱ nu̱ ngue xa̱ngu̱ yø ja̱'i̱ di̱ mpɛti p'ʉ ha søni̱, ɛ̱mmɛ̱i̱ di huɛ̱qui̱. Porque yø ja̱'i̱ 'bʉ ndu̱mmʉi, hi̱ngui̱ pa̱di̱ te da̱ 'yøt'e. Ɛ̱ntho yø dɛ'yo 'mø hi̱njo'o to da̱ mädi. ");
INSERT INTO otnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pɛ ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue xa̱ngu̱ ra̱ 'bɛfi i ja, pɛ yø mɛfi zi yohotho 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ja̱na̱ngue nu̱yá, nu̱na̱ Oja̱ rá̱ mmɛti ra̱ 'bɛfi, da̱mi̱ 'yäphʉ ngue da̱ mɛnhyø mɛfi p'ʉ ja rá̱ 'bɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ra̱ Jesús bi zo'ʉ 'dɛ'ma̱ yoho yø xädi ya xi huanhni̱. Bi u̱nna̱ ts'ɛdi ngue da̱ 'yøthe yø ja̱'i̱ n'youi yø ts'onthi̱, da̱ gue'ʉ yø ja̱'i̱ hɛ̱mbi̱ n'na ma̱ 'dan'yo ma̱ n'ʉ, da̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ja ua yø thu̱hu̱ ya 'dɛ'ma̱ yonc'ɛ̱i̱ yø representante ra̱ Jesús. Rá̱ mʉdi rá̱ thu̱hu̱ ra̱ Simu̱, nu̱'a̱ i̱ nhu̱ta̱ m'mɛfa ngue ra̱ Bɛdu. Ra̱ Andre nu̱na̱ rá̱ n'yohʉ ra̱ Bɛdu. Ra̱ Jacobo, 'nɛ̱hra̱ Xuua, guehya yø ts'ʉnt'ʉ ra̱ Zebedeo ya. ");
INSERT INTO otnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ra̱ Lipe. Ra̱ Bartolomé. Ra̱ Toma̱. Ra̱ Mateo nu̱na̱ ra̱ ngʉthäi. Ra̱ Jacobo nu̱na̱ rá̱ ts'ʉnt'ʉ ra̱ Alfeo. Ra̱ Lebeo nu̱na̱ ja ma̱n'na ra̱ thu̱hu̱ ngue ra̱ Tadeo. ");
INSERT INTO otnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ra̱ Simu̱ nu̱na̱ n'youi ra̱ partido ngue ra̱ cananista. 'Nɛ̱hra̱ Judas Iscariote nu̱na̱ bi dä ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nu̱ya 'dɛ'ma̱ yoho yø xädi ra̱ Jesús, bi 'yɛt'i ngue da̱ ma̱nna̱ hya̱. Rá̱ mʉdi bi 'yɛ̱mbi̱: ―'Yo gni̱ mähä p'ʉ ja rá̱ m'mʉhyø ja̱'i̱ hi̱ngyø judío. 'Nɛ̱ 'yo guí cʉthʉ p'ʉ ja yø hni̱ni̱ ja'a̱ ra̱ ra̱ häi Samaria. ");
INSERT INTO otnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sinoque i̱ mähä p'ʉ 'bʉhyø judío. Porque yø judío tengu̱tho yø dɛ'yo ngue xa̱ m'mɛdi. ");
INSERT INTO otnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Guí xihmʉ yø ja̱'i̱ p'ʉ gdi̱ mähä ngue nu̱na̱ Oja̱ bi 'bʉ ma̱hɛ̱ts'i̱, ya da̱ guehyø pa jap'ʉ da̱ 'yu̱di̱ ngue di̱ ma̱nda ua ya. ");
INSERT INTO otnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Da̱mi̱ 'yøthehʉ yø ja̱'i̱ di hyɛ̱nni̱. Gui 'yøthʉ ngue di bɛ̱nna̱te yø ánima. Gui 'yøthehʉ yø ja̱'i̱ 'ya yø do'yo. Gui 'yøthehʉ yø ja̱'i̱ n'youi yø ts'onthi̱. Nu̱na̱ ra̱ ts'ɛdi ga̱ 'da'a̱hʉ, hi̱nte dá̱ jʉp'a̱hʉ. Ja̱na̱ngue nu̱yá, nu̱ yø ja̱'i̱ gui 'yøthehʉ, 'yo te gui jʉmba̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","'Yo guí ha̱xhʉ ra̱ mɛ̱nyu̱ ngue ra̱ oro ogue ra̱ t'axi ogue ra̱ cobre. ");
INSERT INTO otnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","'Yo tema̱ lega guí ca̱xhʉ. O guí ca̱xni̱ mponi̱hʉ. 'Yo guí cʉxhʉ mi̱'da yø thi̱xfani̱ ogue yø tøhø. Porque rá̱ mɛfi Oja̱ jatho ngue di t'u̱nni̱ te da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nu̱'mø gá̱ sømhmʉ p'ʉ ja n'na ra̱ da̱ni̱hni̱ ogue ja n'na ra̱ t'ʉni̱hni̱, da̱mi̱ hyomhmʉ n'na ra̱ n'yohʉ nu̱'a̱ hnu̱ma̱nho p'ʉ ja rá̱ hni̱ni̱, da̱mi̱ 'yäphʉ ra̱ nt'ɛ̱di̱ ngue di 'da'a̱hʉ ra̱ ts'äya. Ja da̱mi̱ nsäyahʉ p'ʉ ja rá̱ ngu̱'a̱, asta̱ gue'mø guá̱ ɛ̱hmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu̱'mø gá̱ cʉthʉ mbo ra̱ ngu̱, gui 'yɛ̱mhmʉ: “Oja̱ di ja̱pyø ja̱'i̱ 'bʉcua”. ");
INSERT INTO otnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nu̱'mø da̱ nu̱ ma̱nho'a̱hʉ yø ja̱'i̱ 'bʉp'ʉ ja ra̱ ngu̱, ya di tocabi na̱ ra̱ nzɛngua guí xihmʉ 'mø. Pɛ nu̱'mø ngue hi̱ngui̱ nnu̱ ma̱nho'a̱hʉ, nu̱'a̱ ra̱ nzɛngua guí xihmʉ, ya hi̱ndi̱ tocabi. ");
INSERT INTO otnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nu̱'mø ngue hi̱mbi̱ hnu̱ ma̱nho'a̱hʉ p'ʉ ja n'na ra̱ hni̱ni̱ ogue ja n'na ra̱ ngu̱ hi̱ndi̱ n'na'a̱hʉ ra̱ ts'äya 'nɛ̱ hi̱nda̱ ne da̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ guí xihmʉ, ni̱ mähä p'ʉya, pømhmʉ p'ʉ ja ra̱ hni̱ni̱ ogue ja ra̱ ngu̱. Da̱mi̱ hua̱mhmra̱ fonthäi di̱ n'youi ni̱ mbonguahʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱'mø ra̱ pa da̱ni̱ hya̱spa̱ ra̱ güɛnda Oja̱ ya yø ja̱'i̱ di ja'a̱hʉ p'ʉ, ma̱n'na xa̱ngu̱ ra̱ castigo da̱ thohya, ngue'a̱ te ra̱ castigo da̱ tho'ʉ yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Sodoma 'nɛ̱p'ʉ ja ra̱ hni̱ni̱ Gomorra. ");
INSERT INTO otnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","A nu̱yá, ga̱ pɛn'na̱hʉ p'ʉ ha 'bʉhyø ts'oc'ɛ̱i̱, ngue nts'u̱tho, tengu̱tho yø dɛ'yo 'mø bi zømp'ʉ 'bʉhyø zate. Pɛ da̱mi̱ 'yøt'e ngue gyø njammʉihʉ, gui̱ mfähmʉ, tengu̱tho guí̱ mfähyø c'ɛ̱ya̱. Pɛ 'yo to guí sʉhmʉ, gui 'yøthʉ tengutho yø paloma ngue hi̱ngyø nequisʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Da̱mi̱ mfähmʉ p'ʉ 'bʉhyø ja̱'i̱. Porque yø ja̱'i̱ da̱ zixa̱hʉ fädi. Nu̱p'ʉ ja yø ni̱ja̱ yø ja̱'i̱ da̱ mɛp'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Di dä'a̱hʉ p'ʉ 'bʉhyø ts'ʉt'abi 'nɛ̱p'ʉ 'bʉhyø gobierno. Di ʉ'a̱hʉ yø ja̱'i̱ ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. Nu̱'mø ngue ya gdí 'bʉhmʉ p'ʉ ha 'bʉhyø ts'ʉt'abi, ngu̱'ʉ yø judío, ngu̱'ʉ hi̱ngyø judío, gä da̱ zä da̱ 'yøhna̱ ra̱ hoga̱ 'da'yo hya̱ guí xihmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nu̱'mø bi jo'a̱hʉ, 'yo sä di tu̱ ni̱ mmʉihʉ'a̱ te ra̱ hya̱ ja ngue gui xihmʉ ra̱ ts'ʉt'abi. Nu̱'a̱ ra̱ ora guí dä ni̱ hya̱hʉ p'ʉ ja ra̱ ts'ʉt'abi, Oja̱ di 'da'a̱hʉ ra̱ hya̱ ja ngue guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porque ra̱ Espíritu Santo di bɛ̱n'na̱hʉ ra̱ hya̱ gui xihmʉ ra̱ ts'ʉt'abi. Hi̱ngni̱ n'yomfɛ̱ni̱sɛ gui jʉcra̱ hya̱ guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nu̱ yø n'yohʉ ɛ̱c'ɛ̱i̱gui̱, di̱ ya̱psɛ yø n'yohʉ hi̱ngui̱ ɛ̱c'ɛ̱i̱gui̱ ngue da̱ tho. Yø papá, nu̱'mø bi 'yɛ̱c'ɛ̱i̱gui̱ yø ba̱si̱, di dä yø ba̱si̱ ngue da̱ tho. Yø ba̱si̱ p'ʉya, nu̱'mø bi 'yɛ̱c'ɛ̱i̱gui̱ yø papá, di dä yø papá ngue da̱ tho. ");
INSERT INTO otnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Hønnbʉ bi zä da̱ zʉ'a̱hʉ yø ja̱'i̱ ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. Pɛ nu̱ ra̱ ja̱'i̱ da̱ zɛti hangu̱ ra̱ n'ʉ da̱ thogui, guehna̱ di̱ nya̱nná̱ te na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu̱'mø bá̱ ju̱'a̱hʉ n'na ra̱ hni̱ni̱, da̱mi̱ 'dagui gdi̱ mähä ma̱n'na ra̱ hni̱ni̱. Pɛ nu̱gä dí xi'a̱hʉ, tobe hi̱n ga̱di täti ga̱di 'yomhmʉ ra̱ hya̱ p'ʉ ha 'bʉhyø judío 'mø mi̱ zønna̱ pa da̱ hya̱spa̱ ra̱ güɛnda yø ja̱'i̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nu̱ ra̱ xädi, 'yo di ɛ̱na̱ ngue hi̱nda̱ thogui tengu̱tho thohrá̱ xännba̱te. Xi mma̱ngu̱ ra̱ hmi̱qui̱, 'yo di ɛ̱na̱ ngue hi̱nda̱ thogui tengu̱tho thohrá̱ hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nu̱ ra̱ xädi, di̱ m'mʉi ngue ra̱ conforme, ngue da̱ thogui tengu̱tho da̱ thohrá̱ xännba̱te. Ra̱ hmi̱qui̱ p'ʉya, di̱ m'mʉi ngue ra̱ conforme, ngue da̱ thogui tengu̱tho da̱ thohrá̱ hmu̱. Nu̱'mø ngue bi̱ nu̱ ma̱n'ʉgä yø ja̱'i̱, gui hu̱qui̱ ngue drá̱ zithu̱, goma̱ gue'a̱hʉ hi̱nda̱ nu̱ mma̱n'ʉ'a̱hʉ yø ja̱'i̱ ngue guí tɛnnga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ja̱na̱ngue nu̱ya yø ja̱'i̱ sʉ'a̱hʉ, 'yo guí su̱hʉ ya. Nu̱ te gäma̱ hya̱ njo'mi̱, siempre da̱ fa̱mhma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nu̱ya yø hya̱ dí xi'a̱sɛhʉ, da̱mi̱ xihmʉ gätho yø ja̱'i̱. Nu̱ya yø hya̱ dí hu̱t'a̱tho ni̱ gu̱hʉ, i nt'øde ra̱ hya̱ gä ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","'Yo guí su̱hʉ'ʉ da̱ ne da̱ hyo'a̱hʉ. Porque nu̱'mø bi hyo'a̱hʉ, nu̱ ra̱ te ya hi̱nda̱ zä te da̱ japi. Nu̱na̱ Oja̱, ja rá̱ ts'ɛdi ngue di juat'a̱ ni̱ do'yohʉ 'nɛ̱ ni̱ tehʉ p'ʉ ja ra̱ ni̱du̱, guehna̱ da̱mi̱ su̱hʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nu̱'mø bi 'bä yoho yø ts'ints'ʉ, hønda̱ n'na ra̱ xani̱ ma̱ t'u̱ni̱. Pɛ hi̱nga̱ n'na di m'mɛ'ʉ yø ts'ints'ʉ mɛ̱nte ngue hi̱ndi̱ u̱nna̱ nt'ɛ̱di̱ ni̱ Papáhʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ja̱njua̱ni̱ ngue fäxa̱hʉ Oja̱. Conque asta̱ ni̱ xta̱hʉ i̱ m'mede n'na ngu̱ n'na. ");
INSERT INTO otnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ja̱na̱ngue 'yo guí su̱hʉ yø ja̱'i̱. Porque ma̱n'na xa̱mma̱di̱'a̱hʉ ngue yø ts'ints'ʉ, ma̱dague'a̱ ngue yø mmu̱ndotho'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nu̱ to gätho da̱ ma̱mp'ʉ 'bʉhyø ja̱'i̱ ngue ɛ̱c'ɛ̱i̱gui̱, xquet'a̱ ga̱ mma̱ngä p'ʉ 'bʉhma̱ Papá bí 'bʉ ma̱hɛ̱ts'i̱ ngue da̱di̱ n'amigo'be ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pɛ nu̱ te'o da̱ gøngä p'ʉ 'bʉhyø ja̱'i̱, da̱ ma̱ ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱gui̱, xquet'a̱ ga̱ mma̱ngä p'ʉ ha bí 'bʉhma̱ Papá ma̱hɛ̱ts'i̱ ngue hi̱n da̱di̱ n'amigo'be ra̱ ja̱'i̱ da̱ gøngui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","'Yo guí ɛ̱mhmʉ ngue dá̱ ɛ̱cä ua ja ra̱ xi̱mhäi ngue hi̱n tema̱ n'ʉ guí sähʉ. Nu̱'á̱, hi̱n'na̱'a̱. Sinoque di̱ nja ra̱ sʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Dá̱ ɛ̱cä ua ngue di̱ nja'a̱ di̱ nsʉhyø ja̱'i̱. Ra̱ ts'ʉnt'ʉ di̱ nsʉhmi̱ ra̱ papá. Ra̱ hmu̱te di̱ nsʉhmi̱ ra̱ mamá. Ra̱ ts'i̱huɛ di̱ nsʉhmi̱ rá̱ cä. ");
INSERT INTO otnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nu̱'ʉ yø nsʉiui ra̱ ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱gui̱, gue'ʉ 'bʉp'ʉ ja rá̱ ngu̱ da̱ zʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","A nu̱yá, nu̱ ra̱ ja̱'i̱ ngue ma̱ da̱tho di̱ ma̱hrá̱ papá, di̱ ma̱hrá̱ mamá, ngue nu̱gui̱, guehna̱ ra̱ ja̱'i̱ ya hi̱ngrá̱ nsäui da̱ dɛnngui̱. A nu̱ ra̱ ja̱'i̱ ngue ma̱ da̱tho di̱ ma̱hrá̱ ts'ʉnt'ʉ, di̱ ma̱hrá̱ t'i̱xu̱ ngue nu̱gui̱, guehna̱ ra̱ ja̱'i̱ ya hi̱ngrá̱ nsäui da̱ dɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nu̱ ra̱ ja̱'i̱ hi̱ngui̱ nne da̱ dɛnngui̱ ngue su̱ da̱ tho, guehna̱ ra̱ ja̱'i̱ ya hi̱ngrá̱ nsäui da̱ dɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nu̱ ra̱ ja̱'i̱ da̱ gohrá̱ mmʉi ngue su̱ da̱ tho, guehna̱ ra̱ ja̱'i̱ di̱ m'mɛhrá̱ te na̱. Pɛ nu̱ ra̱ ja̱'i̱ hi̱nha ga̱ gohrá̱ mmʉi ma̱da̱ tho, guehna̱ ra̱ ja̱'i̱ di̱ nya̱nná̱ te na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nu̱ ra̱ ja̱'i̱ da̱ 'yøt'a̱hʉ ma̱su̱, guehna̱ ra̱ ja̱'i̱ tengu̱tho 'mø go di ørca̱gui̱ ma̱su̱ na̱. Nu̱ ra̱ ja̱'i̱ da̱ 'yørca̱gui̱ ma̱su̱, tengu̱tho 'mø go di ørpa̱bi̱ ma̱su̱'a̱ to bá̱ pɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu̱ ra̱ ja̱'i̱ ørpa̱ ma̱su̱ n'na rá̱ pønga̱hya̱ Oja̱ porque pa̱hra̱ ja̱'i̱ ngue gue'a̱ rá̱ m'mɛnhni̱ Oja̱, di t'u̱nná̱ nzäbi ra̱ ja̱'i̱ tengu̱tho rá̱ nzäbi ma̱ t'u̱nni̱ rá̱ pønga̱hya̱ Oja̱. Ximma̱ngu̱ ra̱ ja̱'i̱ ørpa̱ ma̱su̱ n'na ra̱ hoga̱ n'yohʉ, porque pa̱di̱ ngue xa̱nho ga̱ 'yo ra̱ n'yohʉ, di t'u̱nná̱ nzäbi ra̱ ja̱'i̱ tengu̱tho rá̱ nzäbi ma̱ t'u̱nni̱ ra̱ hoga̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A nu̱yá, ndana̱ bi zä ya ma̱ xädi, nu̱ ra̱ ja̱'i̱ da̱ 'yørpa̱ ra̱ nho ngue pa̱di̱ ngue i tɛnngui̱, ma̱da̱gue'a̱ n'na zi vaso ra̱ dehe di u̱nni̱, hi̱ndi̱ 'bɛhrá̱ nzäbi ra̱ ja̱'i̱, Oja̱ da̱ gu̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nu̱ya 'dɛ'ma̱ yoho yø xädi ra̱ Jesús, mi̱ juadi bi xifi te ja ngue da̱ 'yøt'e, bi̱ map'ʉ bí ja yø hni̱ni̱ na̱ ra̱ Jesús ngue da̱ xännba̱ ra̱ hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ra̱ Xuua ya mi̱ ofädi bi 'yøde te øtra̱ Cristo. Ja̱na̱ngue bi̱ mɛnhni̱ yoho yø xädi ngue bá̱ nya̱ui ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mi̱ zømp'ʉ ha 'bʉi, bi 'yɛ̱mbra̱ Jesús: ―¿Ua gue'e na̱ ra̱ Cristo mi̱ ja ngue dá̱ ɛ̱hɛ̱ di̱ nda̱st'abi, ua gue ga̱ tø'mähe ma̱n'na? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ra̱ Jesús bi 'yɛ̱mbya ya̱ui: ―Ni̱ mɛ ya, bá̱ xihmi̱ ra̱ Xuua'a̱ te ra̱ hya̱ gá̱ nu̱ui bi̱ nja. Xihmi̱ ya yø hya̱ gá̱ 'yøhmi̱ dí̱ mma̱ngä. ");
INSERT INTO otnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Da̱mi̱ xihmi̱ ngue yø xädä ya zø yø dä. Yø dogua, ya i 'yo. Yø ja̱'i̱ mi̱ 'ya yø do'yo, ya bi zä ha hɛ̱mbi̱. Yø gogu̱, ya øhra̱ hya̱. Yø ánima, ya di bɛ̱nna̱te. Yø hyoya, ya sihra̱ hoga̱ 'da'yo hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ra̱ mmɛ̱nthi̱ di̱ nthɛui ra̱ ja̱'i̱ hi̱nha di gohrá̱ mmʉi ngue ɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mi̱ mengyø m'mɛnhni̱ ra̱ Xuua, nu̱na̱ ra̱ Jesús bi dʉ'mi̱ bi c'a̱nnba̱bi̱ yø ja̱'i̱ na̱ ra̱ Xuua. Bi 'yɛ̱mbi̱: ―¿Te'o gá̱ ma guá̱ nu̱hʉ p'ʉ bí ja ra̱ da̱po? ¿Ua guá̱ nu̱hʉ n'na ra̱ n'yohʉ hi̱ngui̱ nzaqui rá̱ mmʉi, ɛ̱ntho n'na ra̱ zafani̱ 'mø a̱nna̱ nda̱hi̱? ");
INSERT INTO otnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Xi'mø ngue hi̱n'na̱, ¿te'o guá̱ nu̱hʉ 'mø? ¿Ua guá̱ nu̱hʉ n'na ra̱ n'yohʉ ngue he ra̱ hoga̱ u̱lu? Pɛ guí pa̱hmʉ ngue yø ja̱'i̱ he ra̱ hoga̱ u̱lu, guep'ʉ ja yø ngu̱ yø da̱st'abi 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pɛ xi'mø hi̱nga̱ gue'a̱ guá̱ nu̱hʉ'a̱, ¿te'o guá̱ nu̱hʉ 'mø? ¿Ua guá̱ nu̱hʉ n'na rá̱ pønga̱hya̱ Oja̱? Ma̱jua̱ni̱ ngue gue'a̱ rá̱ pønga̱hya̱ Oja̱ guá̱ nu̱hʉ. Pɛgue ta̱te na̱, ngue gätho mi̱'da yø pønga̱hya̱ xa̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nu̱na̱ ra̱ Xuua guehna̱ rá̱ m'mɛnhni̱ Oja̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro na̱, ngue ɛ̱na̱: “Nu̱gä ga̱ ɛt'ä ma̱ m'mɛnhni̱, di̱ m'mɛt'o p'ʉ gdi̱ ma. Gue'a̱ di hoqui hapʉ ja ngue gui thogui”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱ hangu̱ yø ja̱'i̱ 'bʉi, hi̱njongui̱ pøni̱ ngue di ta̱te nguehna̱ ra̱ Xuua bi 'yøtra̱ nxixya̱. Pɛ nu̱yá, to bi zä ma̱ ja̱'i̱ ya o rá̱ 'yɛ Oja̱ ya, guehya ma̱ da̱tho bi̱ nthɛui ra̱ mmɛ̱nthi̱ ya ngue ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bá̱ fʉ'mø yø pa bá̱ øtra̱ nxixya̱ ra̱ Xuua ya, asta̱ quehyø pa dí 'bʉhmʉ ya, ja̱njua̱ni̱ di xønyø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱. Nu̱ya yø ja̱'i̱ di xøni̱ da̱ zo rá̱ 'yɛ Oja̱, i̱ nne ngue xøgue ra̱ søni̱tho di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hante ngue di̱ m'mʉhra̱ Xuua, nu̱ te gäma̱ hya̱ bi̱ ma̱n'a̱ m'mɛt'o yø pønga̱hya̱ Oja̱, da̱gue'ʉ yø hya̱ nt'ot'i p'ʉ ja ra̱ ley, gätho bi̱ ma̱ ngue bá̱ ɛ̱p'ʉ ra̱ pa di̱ ma̱nda ua Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A nu̱na̱ ra̱ Elías bi̱ ma̱n'a̱ m'mɛt'o rá̱ pønga̱hya̱ Oja̱, nu̱'mø guí̱ nne gui pa̱hmʉ ha rá̱ nja ra̱ hya̱, nu̱na̱ ra̱ Xuua ya, quehna̱ bi t'ɛ̱mbi̱ ngue ra̱ Elías. ");
INSERT INTO otnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A nu̱yá, di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ na̱ ra̱ hya̱ dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma ga̱ honi̱ te gda̱ hyɛjpä yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya. Gdá̱ hyɛjpa̱bi̱ yø ba̱si̱ n'yɛ̱mp'ʉ ja ra̱ täi. I̱ mmatyø mmi̱mba̱si̱ui ngue di̱ n'yɛ̱mmi̱, i ɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Dá̱ pixt'ähe ra̱ xithi ngue xqui̱ nnɛ̱hmʉ, pɛ hi̱ngá̱ nnɛ̱hmʉ. Dá̱ tu̱t'a̱he yø thu̱hu̱ ngue yø thu̱ndu̱mmʉi, pɛ hi̱ngá̱ nzomhmʉ”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Guí̱ njathʉ p'ʉya, nu̱'mø hi̱mbi̱ nja'a̱ te guí̱ mma̱mhmʉ, guí̱ mbøcuɛhʉ. Porque ba̱ ɛ̱hra̱ Xuua, nu̱na̱ bi 'yɛtrá̱ mmʉi, a nu̱'a̱hʉ p'ʉya, gá̱ 'yɛ̱mhmʉ ngue n'youi ra̱ ts'onthi̱ ngue'a̱ te øt'e. ");
INSERT INTO otnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A nu̱yá, guecä drá̱ N'yohʉ dá̱ ɛ̱ ma̱hɛ̱ts'i̱, dí si'a̱ te dí ti̱ni̱, a nu̱'a̱hʉ p'ʉya guí ɛ̱njʉ ngue drá̱ nhyøt'a̱ zi̱hmɛ̱. Guí ɛ̱njʉ ngue da̱di thɛgä'be'ʉ yø ja̱'i̱ ja yø ts'oqui 'nɛ̱'ʉ yø ngʉthäi. Pɛ nu̱na̱ ra̱ hya̱ njua̱ntho, nu̱'mø di̱ n'yomfɛ̱ni̱ xa̱nho yø ja̱'i̱, da̱ ba̱di̱ ha rá̱ nja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nu̱na̱ ra̱ Jesús, nu̱'ʉ yø ja̱'i̱ 'bʉp'ʉ ja yø hni̱ni̱ xi 'yøt'e xa̱ngu̱ yø milagro, bi̱ mʉdi bi hɛjpi te ga̱ 'yo yø ja̱'i̱, porque hi̱ngui̱ nne yø ja̱'i̱ da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo. Bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Hague ngu̱ ra̱ castigo da̱ thohyø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Corazín. Hague ngu̱ ra̱ castigo da̱ thohyø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Betsaida. Porque hi̱mbi̱ 'yɛ̱c'ɛ̱i̱gui̱ 'mø mi̱ nu̱ yø milagro dá̱ ørbʉ ha 'bʉi. A nu̱'mø xta̱ nnu̱ yø milagro yø ja̱'i̱ mi̱ 'bʉp'ʉ ja yø nyogui hni̱ni̱ Tiro 'nɛ̱p'ʉ Sidón, n'na zihma̱ntho xta̱ hyɛp'ʉ ra̱ nts'o ma̱ni̱ n'yo yø ja̱'i̱. Xti̱ n'yʉxyø 'bospi 'nɛ̱ xta̱ hye yø he nu̱'a̱ he yø ja̱'i̱ 'mø 'bʉ ndu̱mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nu̱gä dí xi'a̱hʉ ngue nu̱'mø ra̱ pa da̱ni̱ tha̱xra̱ güɛnda, ma̱n'na xa̱ngu̱ ra̱ castigo da̱ thohyø ja̱'i̱ fɛsta̱ ra̱ hya̱ ya, ngue'a̱ ra̱ castigo da̱ thohyø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Tiro 'nɛ̱p'ʉ ja ra̱ hni̱ni̱ Sidón. ");
INSERT INTO otnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A nu̱ya yø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Capernaum, rá̱ nzɛgui ɛ̱na̱ ngue da̱ t'ɛ̱spa̱bi̱ ua ja ra̱ häi, 'nɛ̱p'ʉ ma̱hɛ̱ts'i̱ da̱ t'ɛ̱spi̱. Pɛ gue di̱ map'ʉ ja ra̱ ni̱du̱ ya. Porque hi̱mbi̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo. Nu̱'ʉ yø nyogui ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Sodoma, nu̱'mø xta̱ nnu̱ yø milagro tengu̱tho bi̱ njap'ʉ ja ra̱ hni̱ni̱ Capernaum, xta̱ hyɛp'ʉ ra̱ nts'o ma̱ni̱ n'yo yø ja̱'i̱'a̱ ra̱ hni̱ni̱'a̱ 'nɛ̱ hi̱nxta̱ nguahyø ja̱'i̱ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nu̱gä dí xi'a̱hʉ ngue nu̱'mø ra̱ pa da̱ni̱ tha̱xra̱ güɛnda, ma̱n'na xa̱ngu̱ ra̱ castigo da̱ tho'ʉ yø mmɛ̱ngu̱ Capernaum ngue ra̱ castigo da̱ thohyø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Sodoma. ");
INSERT INTO otnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma̱n'na ra̱ ora p'ʉya, ra̱ Jesús bi 'yɛ̱na̱: ―Ma̱ Papá'i, da̱di ja ma̱mma̱di̱'i̱, grá̱ Hmu̱ p'ʉ ma̱hɛ̱ts'i̱, grá̱ Hmu̱ ua ja ra̱ xi̱mhäi. Porque yø ja̱'i̱ ɛ̱na̱ ngue yø ba̱mhya̱, i ɛ̱na̱ ngue ti̱ni̱ xa̱nho yø mmʉi hanja ra̱ hya̱, pɛ gá̱ 'ya̱jpa̱bi̱ ya yø hya̱ ya. Gá̱ japi ngue go bi ba̱hya yø ja̱'i̱ ngue yø 'yøde tengu̱tho yø ba̱si̱ ngue yø 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ngu̱na̱ gá̱ 'yøt'e ma̱ Papá'i, porque gue'a̱ guá̱ sänni̱ ngue di̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱'a̱ ma̱ Papá, bi däqui gätho yø cosa ngue ga̱ ma̱nda. Hi̱njongui pøni̱ ngue da̱di̱ mpa̱hmi̱ xa̱nho'a̱ rá̱ Ts'ʉnt'ʉ Oja̱, sinoque hønsɛ'a̱ rá̱ Papá di̱ mpa̱hmi̱. Hi̱njongui pøni̱ ngue da̱di̱ mpa̱hmi̱'a̱ ra̱ Papá, sinoque hønsɛ'a̱ rá̱ Ts'ʉnt'ʉ di̱ mpa̱hmi̱. Nu̱ ra̱ ja̱'i̱ da̱ neprá̱ Ts'ʉnt'ʉ Oja̱ ngue da̱ ba̱di̱ te'o na̱ rá̱ Papá, da̱ zä da̱ ba̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nu̱ gätho yø ja̱'i̱ ya xa̱ nyägui ngue hi̱ngui̱ hät'i da̱ 'yøt'e te gäma̱ hya̱ sännbi̱, da̱mi̱ n'u̱ni̱ ngue ga̱ fäxa̱hʉ n'namhma̱ ngue da̱ di̱ni̱ ha di̱ nsäya ni̱ tehʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Da̱mi̱ 'yøt'e ngue ni̱ Hmu̱jʉ. Da̱mi̱ hya̱xhʉ na̱ ra̱ hya̱ dí xän'na̱hʉ. A nu̱gui̱, dí ya̱ ma̱ntu̱di̱, hi̱ngrá̱ n'yɛ̱ts'i̱ nna̱ ya̱. Nu̱na̱ ra̱ hya̱ dí̱ mma̱ngä, da̱ hyu̱t'a̱ ni̱ mmʉihʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nu̱ya yø hya̱ da̱di̱ ma̱ndagä gui 'yøthʉ, hi̱ndi̱ ʉn'a̱hʉ ya. Porque nu̱ te dí xännba̱te, hi̱ngui̱ hɛnni̱ gdi 'yøthʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nu̱ya yø pa ya, nu̱na̱ ra̱ Jesús co 'nɛ̱hyø xädi bi tocabi ngue bi thop'ʉ ja yø nua̱trigo 'mø ra̱ pa ngue ra̱ ts'äya. Nu̱'ʉ yø xädi bi zä ngue tu̱ ma̱nthu̱hu̱, ja̱na̱ngue bi daxtyø trigo, bi za. ");
INSERT INTO otnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mi̱ nu̱ yø fariseo te øtyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ ni̱ xädi gue di̱ mpɛfi. Conque mma̱mp'ʉ ja ra̱ ley ngue nu̱'mø ra̱ pa ngue ra̱ ts'äya, hi̱ngui̱ sä ngue to di̱ mpɛfi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xi'mø mi̱ zʉhra̱ thu̱hu̱ n'na ndi̱ ra̱ David, co 'nɛ̱'ʉ mi̱ n'youi, ¿ua hi̱nja̱m'mø ga̱di xähmʉ p'ʉ ha nt'ot'i'a̱ te bi 'yøt'e? ");
INSERT INTO otnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nu̱ ra̱ David bi yʉrbʉ ja rá̱ ngu̱ Oja̱ ngue bi zi yø thu̱hmɛ̱ xi t'ʉspa̱bi̱ Oja̱ ngue da̱ nu̱. Bi zi ra̱ David co 'nɛ̱'ʉ mi̱ n'youi. Conque nu̱'ʉ yø thu̱hmɛ̱'ʉ, hi̱ndi̱ u̱nna̱ nt'ɛ̱di̱ ra̱ ley ngue to bi zä da̱ zi, hi̱nda̱ høndyø mmäcja̱ yø ts'i'ʉ yø thu̱hmɛ̱ t'ʉspa̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ua hi̱n ga̱di xähmʉ te mma̱mp'ʉ ja ra̱ ley, ngue yø mmäcja̱ 'bʉp'ʉ ja ra̱ ni̱ja̱, nu̱'mø ra̱ pa ngue ra̱ ts'äya di̱ mpɛfi, pɛ hi̱nda̱ t'ɛ̱mbi̱ ngue ra̱ ts'oqui øt'e ngue njap'ʉ? ");
INSERT INTO otnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nu̱gä dí xi'a̱hʉ ya, ngue nu̱ua ha guí 'bʉhmʉ, 'bʉcua n'na nc'ɛ̱i̱ ta̱te ngue ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pɛ hi̱ngui̱ ti̱nni̱ mmʉihʉ hanja'a̱ te ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Dí̱ nnegä ngue di̱ nja ni̱ nhuɛ̱ca̱tehʉ, porque guehna̱ ma̱n'natho di̱ mu̱ui'a̱ ngue yø 'bøt'e guí ørca̱hʉ”, i ɛ̱na̱. Porque nu̱'mø di ja ni̱ nhuɛ̱ca̱tehʉ, nuya yø ja̱'i̱ hi̱n tema̱ hya̱ øt'e, hi̱ngui̱ 'yɛ̱mphʉ ngue ja yø ts'oqui 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ja rá̱ ts'ɛdi ngue nu̱'a̱ go da̱ zänni̱, gue'a̱ di̱ nja 'mø ra̱ pa ngue ra̱ ts'äya'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mi̱ ma ra̱ Jesús, i̱ map'ʉ ja rá̱ ni̱ja̱ yø judío. ");
INSERT INTO otnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nu̱p'ʉ ja ra̱ ni̱ja̱, mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ xi 'yotrá̱ 'yɛ̱. Yø ja̱'i̱ honi̱ ha di di̱nnba̱bi̱ ra̱ Jesús ngue da̱ ma ma̱ ya̱pi, ja̱na̱ngue bi 'yørpa̱bi̱ ra̱ nt'änni̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua guí ɛ̱mbi̱ ngue ja ra̱ nt'ɛ̱di̱ da̱ t'øthe n'na ra̱ därquɛ̱hi̱ 'mø ra̱ pa ngue ra̱ ts'äya? ");
INSERT INTO otnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―¿Teni̱ 'bɛ'a̱ gui 'yøthʉ 'mø gdi sihʉ n'na ra̱ dɛ'yo, 'nɛ̱ da̱ zop'ʉ ja ra̱ ots'i 'mø ra̱ pa ngue ra̱ ts'äya? Ua̱ngui̱ 'bexque'a̱ guá̱ jʉts'i n'nahma̱ntho, ma̱da̱gue'a̱ ra̱ pa ngue ra̱ ts'äya. ");
INSERT INTO otnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Xi ra̱ ja̱'i̱ ya, ya fa̱di̱ ngue ma̱n'na xa̱mma̱di̱ ra̱ ja̱'i̱ ngue ra̱ dɛ'yo. Ja̱na̱ngue ma̱da̱gue'a̱ dra̱ pa ngue ra̱ ts'äya, i jatho ngue da̱ t'ørpa̱ ra̱ nho yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ra̱ Jesús bi 'yɛ̱mbra̱ n'yohʉ mi̱'ʉ rá̱ 'yɛ: ―Da̱mi̱ majni̱ 'yɛ ya ―bi 'yɛ̱mbi̱. Ra̱ n'yohʉ p'ʉya bi̱ macrá̱ 'yɛ, pɛ 'bexpi zä rá̱ 'yɛ mi̱ 'ʉ. Bi gohi tengu̱tho ja'a̱ ma̱n'na rá̱ 'yɛ. ");
INSERT INTO otnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mi̱ zä mi̱ nu̱ yø fariseo ngue bi̱ n'øthe ra̱ Jesús, bi̱ ma bá̱ nhɛca̱hya̱ ngue honi̱ ha di hyo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mi̱ ba̱di̱ te mbɛ̱nnba̱bi̱ yø ja̱'i̱ ra̱ Jesús, bi̱ ma. Pɛ bi̱ ntɛt'i xa̱ndøngu̱ yø ja̱'i̱. Gä bi 'yøthe yø ja̱'i̱ di hyɛ̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pɛ nu̱ya yø ja̱'i̱ øthe, di 'bɛpi ngue hi̱njonda̱ xifi te ørpe. ");
INSERT INTO otnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nu̱ya te gä øtra̱ Jesús, ya bi̱ nja'a̱ te ra̱ hya̱ bi̱ ma̱nna̱ pønga̱hya̱ Isaías ngue Oja̱ bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nu̱na̱ 'bʉcua ya, guehna̱ ma̱ mɛfi ya xtá̱ huanhni̱. Ɛ̱mmɛ̱i̱ da̱di̱ ma̱di̱. Co nu̱ná̱, i ja ga̱mpähä. Ga̱ japi ngue di̱ n'youi ra̱ Espíritu Santo ya, n'namhma ngue di ha̱tra̱ ts'ɛdi te da̱ 'yøt'e. Guehna̱ da̱ xihyø ja̱'i̱ hi̱ngyø judío na̱, ngue nu̱na̱ Oja̱, da̱ hya̱spa̱ ra̱ güɛnda te ga̱ 'yo yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nu̱ná̱, hi̱ndra̱ nequisʉi na̱. Hi̱ngra̱ hmafi di̱ nya̱ p'ʉ ha di̱ nya̱. Hi̱n hapʉ da̱ t'øde ngue di da̱ma̱ ya̱hni̱ p'ʉ ja ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Da̱ zɛrpa̱bi̱ yø ja̱'i̱ hi̱ngui̱ ha̱ ra̱ ts'ɛdi. Di ha̱tra̱ ts'ɛdi yø ja̱'i̱ asta̱ gue'mø bi zønna̱ pa ngue di̱ ma̱nda ua. ");
INSERT INTO otnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Gätho yø ja̱'i̱ 'bʉ'a̱ nxi̱mhäi p'ʉya da̱ 'yɛ̱c'ɛ̱i̱ ngue gue'a̱ da̱ ya̱n'a̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nu̱na̱ n'na ra̱ n'yohʉ ma̱di gonebi 'nɛ̱ ma̱di xädäbi ra̱ ts'onthi̱ mi̱ n'youi, bi ts'ixpʉ 'bʉhra̱ Jesús ngue bi 'yøthe. Mi̱ 'yøthe p'ʉya, bi zä bi̱ nya̱ ra̱ n'yohʉ 'nɛ̱ bi zä bi̱ nzø yø dä. ");
INSERT INTO otnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gä di 'yødyø ja̱'i̱ bi̱ nu̱ te øtra̱ Jesús, bi 'yɛ̱na̱: ―Pɛ guehna̱ rá̱ mbom'mɛto ra̱ David ja ngue di thojpa̱bi̱ rá̱ 'bɛfi na̱, uague hi̱nga̱ guehna̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mi̱ 'yøhyø fariseo na̱ te ra̱ hya̱ mma̱nyø ja̱'i̱, bi 'yɛ̱na̱: ―Nu̱na̱ ra̱ n'yohʉ i hma̱, i øthe yø ja̱'i̱ n'youi yø ts'onthi̱, pɛ gue gue'a̱ ra̱ zithu̱ rá̱ hmu̱ yø ts'onthi̱ fäts'i ngue njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pɛ ra̱ Jesús, gä pa̱di̱ tema̱ hya̱ mbɛ̱nyø ja̱'i̱, bi 'yɛ̱mbʉya: ―Xip'ʉ ha di̱ ma̱nda n'na ra̱ da̱st'abi, nu̱'mø di̱ ndu̱nhyø ja̱'i̱, hi̱nja̱m'mø da̱ zä da̱ zɛhyø hya̱. Xip'ʉ ja n'na ra̱ hni̱ni̱ ogue ja n'na ra̱ ngu̱, nu̱'mø di̱ nsʉhyø ja̱'i̱ 'bʉp'ʉ, di̱ n'uɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Njarbʉtho na̱ ra̱ hya̱ dí xi'a̱hʉ ya. Xi'mø ngue di hɛjpa̱sɛ yø mɛfi ra̱ zithu̱, ya rá̱ 'bɛfisɛ di ts'oni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Guí ɛ̱mhmʉ ngue ra̱ zithu̱ fäxqui ngue dí øthegä yø ja̱'i̱ n'youi yø ts'onthi̱. A nu̱'mø ngue ngu̱'a̱, xi ni̱ mmi̱judíohʉ tɛnna̱ hya̱ guí xännba̱tehʉ, ¿ua ra̱ zithu̱ fäx'mø øthe yø ja̱'i̱ n'youi yø ts'onthi̱? A nu̱yá, ja di̱ nɛ̱qui̱ p'ʉya ngue guí ya̱ xädähʉ, hi̱nguí̱ pa̱di̱ te guí mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A nu̱gui̱, Oja̱ bá̱ pɛnnga̱gui̱ ra̱ Espíritu Santo ngue ga̱ n'yo'be, da̱ mäxqui ga̱ øthe yø ja̱'i̱ n'youi yø ts'onthi̱. Ja di̱ nɛ̱qui̱ p'ʉya, ngue ya di̱ ma̱nda ua Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hi̱ngra̱ zithu̱ øthe yø ja̱'i̱ n'youi yø ts'onthi̱. Xi n'na ra̱ n'yohʉ xa̱nzaqui, nu̱'mø to da̱ du̱t'i̱, ya da̱ zä to da̱ yʉrbʉ ja rá̱ ngu̱ ngue da̱ jʉjpi te ja mbo. Di̱ njadä p'ʉya, di tu̱t'ä ra̱ zithu̱ di̱ ma̱nda yø ts'onthi̱, ja̱na̱ngue sä dí øthe yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nu̱ ra̱ ja̱'i̱ hi̱ngui̱ nne ngue ma̱ n'yo'be, guehna̱ ra̱ ja̱'i̱ rá̱ n'youi ma̱ nsʉi'be na̱. Nu̱ ra̱ ja̱'i̱ hi̱ngui̱ fäxqui ngue ga̱ ør'be ra̱ 'bɛfi, guehna̱ ra̱ ja̱'i̱ di ts'onnga̱tho ma̱ 'bɛfi na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Da̱mi̱ pa̱hmʉ ya, ngue nu̱'a̱ te gäma̱ ts'oqui øtyø ja̱'i̱, da̱ gue'a̱ te gäma̱ hya̱ ma̱n'ʉ ga̱ ya̱ yø ja̱'i̱, da̱ zä ngue di̱ mpu̱nnbi̱. Pɛ nu̱ ra̱ ja̱'i̱ ngue da̱ nømma̱n'ʉ ra̱ Espíritu Santo, ya hi̱ndi̱ pu̱nnba̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ja̱na̱ngue nu̱ ra̱ ja̱'i̱ da̱ nømma̱n'ʉ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, i sä ngue di̱ mpu̱nnbi̱. Pɛ nu̱ ra̱ ja̱'i̱ da̱ nømma̱n'ʉ ra̱ Espíritu Santo, ya hi̱ndi̱ mpu̱nnbi̱, ni̱ xi̱nga̱ guehra̱ pa dí 'yohʉ ya, ni̱ xi̱nga̱ guehra̱ pa di 'yɛ̱p'ʉ di̱ mpu̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nu̱ ra̱ hoga̱ za, ra̱ hoga̱ ndät'ä zʉdi. Pɛ ra̱ za hi̱ngui̱ ho, hi̱ngra̱ hoga̱ ndät'ä zʉdi. Ja̱na̱ngue nu̱yá, n'na ra̱ za, nu̱ te rá̱ ndät'ä zʉdi, gue'a̱ di fa̱'a̱ ngue'mø ra̱ hoga̱ za ogue hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Guí øthʉ tengu̱tho yø c'ɛ̱ya̱ ngue n'youi ra̱ nda̱te yø ne. Porque hi̱ngui̱ sä guí̱ mma̱mhmʉ n'na ra̱ hoga̱ hya̱. Nu̱ te ra̱ hya̱ bí̱ mi̱hrá̱ mmʉi ra̱ ja̱'i̱, gue'a̱ pønná̱ ne'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nu̱ ra̱ hoja̱'i̱, ra̱ hoga̱ hya̱ i̱ mma̱, porque xa̱nho rá̱ mmʉi. Pɛ nu̱ ra̱ ja̱'i̱ hi̱ngui̱ ho rá̱ mmʉi, xa̱nts'o ra̱ hya̱ ja mbo rá̱ mmʉi, gue'a̱ pønná̱ ne'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nu̱gä dí xi'a̱hʉ ngue nu̱'mø ra̱ pa da̱ni̱ hya̱xra̱ güɛnda Oja̱, nu̱ te gäma̱ ts'omhya̱ pønni̱ nehʉ, gä da̱ tha̱t'a̱hʉ ra̱ güɛnda. ");
INSERT INTO otnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nu̱'mø xa̱nho ra̱ hya̱ xcá̱ ma̱mhmʉ, ya hi̱n tema̱ castigo gui thohmʉ. Pɛ nu̱'mø xa̱nts'o ra̱ hya̱ xcá̱ ma̱mhmʉ, gue'a̱ ra̱ castigo gui thohmʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nu̱ 'da yø fariseo conyø xännba̱te ngue ra̱ ley bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, dí̱ nne ga̱ nnu̱gähe ha gdi 'yøt'a̱ n'na ra̱ milagro para ngue da̱ fa̱di̱ te'o'i ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ yø ja̱'i̱ 'bʉhya, ja yø ts'oqui ngue hi̱ngui̱ pa̱ Oja̱, 'bet'o äcyø milagro da̱ nu̱, ja da̱ 'yɛ̱c'ɛ̱i̱gui̱. Pɛ hi̱n tema̱ milagro ga̱ øt'e ngue da̱ nu̱ yø ja̱'i̱. Nu̱'a̱ da̱ nøpa̱ hmɛ̱ya yø ja̱'i̱ ya, gue'a̱ te bi thohra̱ pønga̱hya̱ Jonás. ");
INSERT INTO otnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Porque ra̱ Jonás nhyu̱ pa bá̱ o rá̱ mmʉi ra̱ hua̱. Di̱ njarbʉtho'a̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ya, nhyu̱ pa da̱ o häi. ");
INSERT INTO otnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nu̱'mø ra̱ pa da̱ni̱ hya̱xra̱ güɛnda Oja̱, nu̱ya yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Nínive da̱ nangui̱ ngue di ya̱pya yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya. Porque yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Nínive, bi 'bätyø mmʉi 'mø mi̱ 'yø'a̱ ra̱ hya̱ bi̱ ma̱nna̱ Jonás. Conque ma̱n'na dí ta̱tegä ya ngue ra̱ Jonás, pɛ hi̱nguí̱ nne gui 'yøhmʉ ra̱ hya̱ dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dá̱ gue'a̱ n'na ra̱ xisu mi̱ nda̱st'abi p'ʉ sur, nu̱'mø ra̱ pa da̱ni̱ hya̱xra̱ güɛnda Oja̱, da̱ nangui̱ ngue di ya̱pya yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya. Porque nu̱na̱ ra̱ xisu na̱, ndøyap'ʉtho rá̱ häi bí 'yɛ̱hɛ̱ ngue bi 'yøxra̱ hya̱ mi̱ pa̱hra̱ Salomón. Conque ma̱n'na dí ta̱tegä ya ngue ra̱ Salomón, pɛ hi̱nguí̱ nne gui 'yøhmʉ ra̱ hya̱ dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nu̱ ra̱ ts'onthi̱ 'mø bi hyɛp'ʉ ra̱ ja̱'i̱ mi̱ n'youi, bi 'yo ra̱ ts'onthi̱ p'ʉ ja ra̱ xɛqui ma̱thoguitho xa̱ 'yot'i, honi̱ ha di̱ nsäya. Pɛ nu̱'mø hi̱mbi̱ di̱ni̱ ha di̱ nsäya, i ɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Ga̱ pengä p'ʉ ja ma̱ ngu̱ dá̱ pøni̱”, i ɛ̱na̱. Nu̱'mø bá̱ pengbʉya, da̱ di̱nnba̱bi̱ rá̱ mmʉi ra̱ ja̱'i̱ ngue hi̱njongui̱ 'bʉp'ʉ, tengu̱tho n'na ra̱ ngu̱ ngue ma̱hoqui xa̱nho, i̱ njoqui. ");
INSERT INTO otnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Da̱ mengbʉya, da̱ si mi̱ yoto yø ts'onthi̱ ma̱n'na xa̱nts'o ngue'a̱ ra̱ ts'onthi̱ rá̱ mʉdi. Gä da̱ yʉrbʉ ja rá̱ mmʉi ra̱ ja̱'i̱ ngue di̱ m'mʉp'ʉ. M'mɛfa p'ʉya, ma̱n'na di̱ m'mʉmma̱n'ʉ ra̱ ja̱'i̱ ngue'a̱ te ra̱ n'ʉ mi̱ sä m'mɛt'o. Xquet'a̱ ngu̱na̱ ra̱ hya thohyø ja̱'i̱ 'bʉhya. ");
INSERT INTO otnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ra̱ Jesús tobe ya̱duitho yø ja̱'i̱ 'mø mi̱ zøhrá̱ mamá conyø n'yohʉ. 'Bäp'ʉ thi, i̱ nnepe da̱ ts'ohra̱ Jesús ngue di̱ nya̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hi̱ndi̱ 'bɛdi to bi xihra̱ Jesús, bi 'yɛ̱mbi̱: ―Ni̱ mamá 'nɛ̱ ni̱ n'yohʉ 'bäcua thi. I̱ nzo'i ngue gui̱ nya̱ui 'na̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱ntho: ―Ma ga̱ xi'a̱hʉ ndana̱ ma̱ mamá, ndana̱ ma̱ n'yohʉ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bi macyø 'yɛ p'ʉya, bi 'yu̱hyø xädi, bi 'yɛ̱mbyø ja̱'i̱ di̱ mäts'i: ―'Bʉcua ya yø ja̱'i̱ di̱ nnøpe ngue ma̱ mamá, di̱ nnøpe ngue ma̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porque nuya yø ja̱'i̱ di ho da̱ 'yørpa̱bi̱ rá̱ pähä ma̱ Papá bí 'bʉ ma̱hɛ̱ts'i̱, guehya ɛ̱ntho ma̱ n'yohʉ, ogue ma̱ nju̱, ogue ma̱ mamá ―bi 'yɛ̱mbyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nu̱'a̱ ra̱ pa'a̱, ra̱ Jesús bi bømp'ʉ ja ra̱ ngu̱ mi̱ 'bʉi, bi̱ ma i̱ mmi̱p'ʉ ja ra̱ nenzabi. ");
INSERT INTO otnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pɛ ma̱ndøngu̱ dyø ja̱'i̱ bi̱ mpɛti p'ʉ ha 'bʉi. Ja̱na̱ngue bi yʉt'a̱ n'na ra̱ barco ja bá̱ mi̱p'ʉ. Nu̱ gätho mi̱'da yø ja̱'i̱ 'bʉ'a̱ nenzabi. ");
INSERT INTO otnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Xa̱ngu̱ yø hya̱ bi xännba̱bi̱ yø ja̱'i̱, honi̱ te gui hyɛjpa̱ yø hya̱ xifi. Ngu̱na̱ n'na ra̱ hya̱ bi hyɛqui, bi 'yɛ̱mbyø ja̱'i̱: ―N'na ra̱ n'yohʉ bi̱ ma da̱ ponna̱ trigo. ");
INSERT INTO otnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nu̱p'ʉ bi thogui ngue ponyø hmu̱dä, bi zop'ʉ ja ra̱ 'yu̱ 'da yø hmu̱dä. Bi̱ map'ʉ yø ts'ints'ʉ ngue bi za yø hmu̱dä. ");
INSERT INTO otnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mi̱'da yø hmu̱dä bi̱ moni̱, bi zop'ʉ hi̱ngui̱ pidi ra̱ häi ngue o ra̱ do. Guehya yø hmu̱dä n'nahma̱ntho bi bøts'e ngue hi̱ngui̱ pidi ra̱ häi p'ʉ bi zo. ");
INSERT INTO otnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hi̱nga̱ ya mbo pa yø 'yʉ. Nu̱'mø bá̱ pøxra̱ hyadi, bi̱ 'yu̱hyø hmu̱dä ya xi bøts'e. ");
INSERT INTO otnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mi̱'da yø hmu̱dä bi zop'ʉ ja yø 'ui̱ni̱. Mi̱ nte yø 'ui̱ni̱ p'ʉya, bi ts'onyø hmu̱dä ngue bi hyøt'a̱mbo. ");
INSERT INTO otnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mi̱'da yø hmu̱dä bi zop'ʉ ja ra̱ hoga̱ häi, guehya ɛ̱mmɛ̱i̱ bi̱ nja ya. Nu̱ 'da yø hmu̱dä, n'na ciento bi bøni̱ ngue n'na mhmu̱dä. Mi̱'da p'ʉya, hya̱te bi bøni̱ ngue n'na mhmu̱dä. Mi̱'da p'ʉya, 'däte ma̱'dɛt'a bi bøni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","A nu̱yá, di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ na̱ ra̱ hya̱ dí̱ mma̱ngä ya ―bi 'yɛ̱mbyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ra̱ Jesús bi guatyø xädi, bi 'yɛ̱mbi̱: ―¿Hanja ngue guí honi̱ te gni̱ hyɛjpa̱ yø hya̱ guí xihyø ja̱'i̱? ");
INSERT INTO otnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Nu̱ya yø hya̱ hi̱ngui̱ fa̱di̱ ha di̱ ma̱nda Oja̱ yø ja̱'i̱, nu̱na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ i̱ nne na̱ ngue da̱ di̱nni̱ mmʉihʉ hanja ya yø hya̱ ya. Pɛ nu̱'ʉ mi̱'da yø ja̱'i̱, hi̱nda̱ di̱nyø mmʉi ya yø hya̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A nu̱ ra̱ ja̱'i̱ bi di̱nna̱ mmʉi hanja ra̱ hya̱ ya, da̱ mäx'Oja̱ ngue ma̱n'na di ba̱di̱. Pɛ nu̱ya yø ja̱'i̱ hi̱ngui̱ ørpa̱tho ma̱su̱ ya yø hya̱ dí̱ mma̱, nu̱'a̱ zits'ʉ ra̱ hya̱ bi ba̱di̱, da̱ tha̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ja̱na̱ngue dí honi̱ te nná̱ hyɛjpa̱ yø hya̱ dí xihyø ja̱'i̱. Porque yø ja̱'i̱ nnu̱ te dí øt'e, pɛ øtyø ja̱'i̱ tengu̱tho 'mø ngue hi̱nte bi̱ nu̱. Nu̱ya yø hya̱ bi 'yøde, tengu̱tho 'mø ngue hi̱n tema̱ hya̱ bi 'yøde, hi̱mbi̱ di̱nyø mmʉi hanja na̱ ra̱ hya̱ dá̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nu̱ te øtyø ja̱'i̱, ya bi̱ nja'a̱ ra̱ hya̱ bi 'bɛt'o ra̱ pønga̱hya̱ Isaías ngue bi 'yɛ̱na̱: “Yø ja̱'i̱ da̱ 'yøde hanja ra̱ hya̱, pɛ hi̱nda̱ di̱nyø mmʉi hanja ra̱ hya̱ da̱ 'yøde. Nu̱ te da̱ nu̱ yø ja̱'i̱, hi̱nda̱ di̱nyø mmʉi yø ja̱'i̱ hanja'a̱ te da̱ nu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porque nu̱ya yø ja̱'i̱ ya, i̱ njot'i yø n'yomfɛ̱ni̱. Ɛ̱ntho xa̱ ngotyø gu̱ ngue hi̱ngui̱ nne da̱ 'yøhra̱ hya̱. Ɛ̱ntho xa̱ ts'a̱ntyø dä ngue hi̱ngui̱ nne da̱ hyɛ̱t'a̱ te ja ngue da̱ hyɛ̱ti̱. Porque hi̱ngui̱ nne da̱ di̱nyø mmʉi hanja ra̱ hya̱, 'nɛ̱ hi̱ngui̱ nne di 'bätyø mmʉi ngue da̱ 'yɛ̱c'ɛ̱i̱gui̱, n'namhma̱ ngue ga̱ pu̱nnba̱bi̱ yø ts'oqui”, ɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pɛ ra̱ mmɛ̱nthi̱ gá̱ nthɛhʉ, porque nu̱ te gä guí̱ nnu̱hʉ, bi di̱nni̱ mmʉihʉ hanja ra̱ hya̱. Nu̱ te ra̱ hya̱ gá̱ 'yøhmʉ, guí pa̱hmʉ ha rá̱ nja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue yø pa xa̱ thogui, xa̱ngu̱ yø pønga̱hya̱ Oja̱ xa̱ m'mʉi, yø hoga̱ n'yohʉ xa̱ m'mʉi, bi̱ ne xta̱ nnu̱'a̱ te guí̱ nnu̱hʉ ya, pɛ hi̱mbi̱ zä bi̱ nu̱. Bi̱ ne xta̱ 'yø'a̱ ra̱ hya̱ guí øhmʉ ya, pɛ hi̱mbi̱ zä bi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nu̱ya yø hya̱ da̱di hyɛjpa̱bi̱ ra̱ momhmu̱dä, da̱mi̱ 'yøhmʉ xa̱nho hanja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nu̱ya yø ja̱'i̱ ngue høntho bi 'yøhra̱ hya̱, guehya gui̱ nhyɛjpi ngue ra̱ nen'yu̱ p'ʉ bi zo yø hmu̱dä ya. Bi 'yøhra̱ hya̱ yø ja̱'i̱ ngue ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱, pɛ hi̱mbi̱ di̱nyø mmʉi yø ja̱'i̱ hanja ra̱ hya̱. Bi̱ map'ʉ ra̱ zithu̱ p'ʉya, nu̱na̱ ra̱ hya̱ xi 'yøhyø ja̱'i̱, bi japi ngue bi pu̱mbɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mi̱'da yø ja̱'i̱, gui̱ nhyɛjpa̱ ra̱ häi hi̱ngui̱ pidi ngue mi̱ o ra̱ do p'ʉ bi zo yø hmu̱dä. Mi̱ zä mi̱ 'yøhra̱ hya̱ yø ja̱'i̱, ja̱njua̱ni̱ di johya ngue bi̱ nu̱ ma̱nho. ");
INSERT INTO otnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Guehya yø ja̱'i̱ hi̱mbi̱ bɛnt'i̱ xa̱nho ra̱ hya̱ ya. Zits'ʉtho honi̱ ngue ha di hyɛp'ʉ ra̱ hya̱. Nu̱'mø bi ts'ʉi ngue ra̱ hya̱ ɛ̱c'ɛ̱i̱, 'bexi cohyø mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mi̱'da yø ja̱'i̱ p'ʉya, gui̱ nhyɛjpa̱bi̱ ra̱ häi ngue ja yø 'ui̱ni̱ p'ʉ bi zo yø hmu̱dä. Guehya yø ja̱'i̱ bi 'yøde hanja ra̱ hya̱ ya. Pɛ nu̱'a̱ te yø 'bɛfi i ja n'na pa ngu̱ n'na pa, høndyø 'bɛfi ni̱ ma yø mmʉi yø ja̱'i̱. Di ja ndu̱mmʉi honi̱ ha di̱ mmɛ̱mmɛti. Ya hi̱n tema̱ nhotho bi 'yørpa̱bi̱ na̱ ra̱ hya̱ bi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pɛ mi̱'da yø ja̱'i̱, gui̱ nhyɛjpa̱ ra̱ hoga̱ häi p'ʉ bi zo yø hmu̱dä. Mi̱ zä mi̱ 'yøhra̱ hya̱, bi di̱nyø mmʉi hanja ra̱ hya̱. Bi 'yørpa̱bi̱ ra̱ nho na̱ ra̱ hya̱ bi 'yøde. Pɛ 'bʉ'i'da yø ja̱'i̱ ngue ma̱thoguitho bi 'yørpa̱bi̱ ra̱ nho ra̱ hya̱ bi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ra̱ Jesús bi hyoni̱ te gui hyɛjpa̱bi̱ n'na ra̱ hya̱ bi xihyø ja̱'i̱. Bi 'yɛ̱mbi̱: ―Nu̱ua ja ra̱ xi̱mhäi di̱ ma̱nda Oja̱, ja nnøpe ngue rá̱ hua̱hi̱ ua Oja̱ bi thu̱hra̱ hoga̱ hmu̱dä. ");
INSERT INTO otnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pɛ mi̱ n'a̱ha̱ gätho yø ja̱'i̱, nu̱'a̱ rá̱ nsʉiui ra̱ mmɛ̱hui̱ bi yʉrbʉ ja ra̱ nua̱trigo ngue ra̱ xu̱i̱. Bi du̱prá̱ mi̱hyu̱ui ra̱ trigo. Bi̱ ma p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mi̱ nte yø trigo p'ʉya, ya ts'a̱ts'i̱ ngue di̱ nja yø trigo. Ja bi̱ nɛ̱qui̱ p'ʉ ndana̱ gue'a̱ ra̱ paxitho p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mi̱ nu̱ yø hmi̱qui̱ ra̱ mmɛ̱hui̱ te ja ra̱ hua̱hi̱, bi̱ ma bá̱ xihra̱ hmu̱. Bi 'yɛ̱mbi̱: “Ague grá̱ Hmu̱, nu̱'mø ma̱ tu̱hmʉ ni̱ hua̱hi̱, xa̱nho ra̱ hmu̱dä dá̱ tu̱hmʉ. ¿Hanja ngue n'youi yø paxi ra̱ trigo ya'mø?” bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ra̱ hmu̱ p'ʉya bi 'yɛ̱mbyø hmi̱qui̱ ya̱ui: “Gue'a̱ ma̱ nsʉigä'be bi du̱'ʉ yø paxi guí̱ mma̱mmi̱ ya”. Yø hmi̱qui̱ p'ʉya bi 'yɛ̱mbra̱ hmu̱: “¿Ua guí̱ nne ga̱ ma xat'ähe yø paxi n'youi ra̱ trigo?” bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pɛ ra̱ hmu̱ bi 'yɛ̱na̱: “Hi̱n'na̱. Ogui xathʉ yø paxi n'youi ra̱ trigo, porque nu̱'mø gá̱ xathʉ yø paxi, 'nɛ̱hra̱ trigo da̱ c'ʉts'i. ");
INSERT INTO otnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Da̱mi̱ hyɛmhma̱ui hma̱ 'dap'ʉ di̱ nte asta̱ gue'mø bi thɛts'i. Ga̱ xicä yø mɛfi ngue da̱ ga̱cyø paxi, da̱ 'yøtyø tu̱t'i̱, da̱ t'u̱di̱. Nu̱'a̱ ra̱ trigo p'ʉya, da̱ 'bɛspʉ ja ra̱ njʉtrigo'a̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ma̱hømbi̱ hyoni̱ te gui hyɛjpa̱ yø hya̱ xihyø ja̱'i̱ ra̱ Jesús. Bi 'yɛ̱mbi̱: ―Ma ga̱ xän'na̱hʉ ha di̱ njap'ʉ di̱ nxa̱ndyø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱ ya. N'na ra̱ n'yohʉ bi du̱p'ʉ ja rá̱ hua̱hi̱ n'na zihmu̱dä ra̱ mostasa. ");
INSERT INTO otnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma̱jua̱ni̱ ngue ma̱n'na zitchʉ na̱ ra̱ hmu̱dä na̱ ngue gätho mi̱'da yø hmu̱dä i ja. Pɛ nu̱'mø bi̱ nte, ma̱n'na ta̱te ra̱ da̱t'o ngue gätho mi̱'da yø c'ani̱ i ja. Nu̱p'ʉ ja yø 'yɛt'o, ja ørbʉ yø 'bafi yø ts'ints'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ma̱hømbi hyonna̱ Jesús te gui hyɛjpa̱ mi̱'da yø hya̱ bi xihyø ja̱'i̱. Bi 'yɛ̱mbi̱: ―Nu̱'a̱ di̱ nxa̱ndyø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱, gui̱ nhyɛjpa̱bi̱ tengu̱tho ra̱ íxi 'mø bi japi hyu̱ t'ɛ̱ni̱ ra̱ hojʉni̱ n'na ra̱ xisu, asta̱ gue'mø di ixqui gä ra̱ jʉni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ngu̱ya yø hya̱ bi̱ ma̱nna̱ Jesús ngue honi̱ te gui hyɛjpa̱ yø hya̱ xihyø ja̱'i̱. Nu̱'mø i ya̱, za̱nt'a̱ honi̱ te gui hyɛjpa̱ yø hya̱ xännba̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngu̱na̱ bi 'yøt'e, porque mi̱ jatho ngue di̱ nja ya yø hya̱ bi̱ ma̱nná̱ pønga̱hya̱ Oja̱ ngue bi 'yɛ̱na̱: “Ga̱ honi̱ te gdá̱ hyɛjpa̱ yø hya̱ ga̱ xihyø ja̱'i̱. Ga̱ xicä yø ja̱'i̱ yø hya̱ hi̱ngui̱ fa̱di̱ hanja asta̱ gue'mø ma̱mbá̱ nhohra̱ xi̱mhäi”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mi̱ juadi bi̱ n'yɛ̱hmi̱ yø ja̱'i̱ ra̱ Jesús, bi 'yʉt'a̱mbo rá̱ ngu̱ p'ʉya. Bi guatyø xädi, bi 'yɛ̱mbi̱: ―Da̱mi̱ xicje te ga̱ mbønya yø hya̱ gá̱ hyɛqui ngue yø mi̱hyu̱ui ra̱ trigo bi thu̱p'ʉ ja ra̱ hua̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Nu̱'a̱ bi̱ du̱hra̱ hoga̱ hmu̱dä, gue'a̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nu̱ ra̱ hua̱hi̱, ga̱ mbøni̱ ngue guecua ja ra̱ xi̱mhäi'a̱. A nu̱ ra̱ hoga̱ hmu̱dä, ga̱ mbøni̱ ngue gue'ʉ yø ja̱'i̱ o rá̱ 'yɛ Oja̱. A nu̱'a̱ rá̱ mi̱hyu̱ui ra̱ trigo, ga̱ mbøni̱ ngue gue'ʉ yø ja̱'i̱ o rá̱ 'yɛ ra̱ zithu̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A nu̱'a̱ rá̱ nsʉiui ra̱ mmɛ̱hui̱ bi̱ du̱prá̱ mi̱hyu̱ui ra̱ trigo p'ʉ ja rá̱ hua̱hi̱, gue'a̱ ra̱ zithu̱'a̱. A nu̱'mø bi thɛxyø trigo, ga̱ mbøni̱ ngue gue'mø bi gua'a̱ nxi̱mhäi 'mø. A nu̱'ʉ yø mɛfi da̱ hyɛxyø trigo, gue'ʉ yø anxɛ'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A nu̱'a̱ rá̱ mi̱hyu̱ui ra̱ trigo da̱ ma ma̱pɛti ngue da̱ t'u̱di̱, ga̱ mbøni̱ ngue gue'a̱ ra̱ nda̱te di̱ nja 'mø bi gua'a̱ nxi̱mhäi'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Porque ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ mɛnhyø anxɛ p'ʉ ha 'bʉhyø ja̱'i̱ ya o rá̱ 'yɛ. Da̱ ziqui gätho yø ja̱'i̱ nu̱ya xa̱ japi ngue øtra̱ ts'oqui mi̱'da yø mmi̱c'ɛ̱i̱ui, da̱ ziqui gätho'ʉ xa̱nts'o te ga̱ 'yo. ");
INSERT INTO otnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nu̱ya yø ts'oc'ɛ̱i̱, da̱ hyørbʉ ja ra̱ orno di da̱nzø. Ja di̱ nzomp'ʉ yø ja̱'i̱ 'nɛ̱ da̱di gu̱xtyø ts'i ngue ra̱ nda̱te da̱ zä. ");
INSERT INTO otnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pɛ nu̱ya yø ja̱'i̱ xa̱ 'yøt'e te di̱ ma̱nda Oja̱, di̱ m'mʉp'ʉ ha di̱ ma̱nda yø Papá, da̱di yoxni̱ tengu̱tho gui yotra̱ hyadi. Di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ ya yø hya̱ dí̱ mma̱ngä. ");
INSERT INTO otnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nu̱ya yø ja̱'i̱ honi̱ ha di zo rá̱ 'yɛ Oja̱ bí 'bʉ ma̱hɛts'i̱, guehya tengu̱tho n'na ra̱ ja̱'i̱ bi di̱ni̱ ha nt'ägui xa̱ndøngu̱ ra̱ mɛ̱nyu̱ ya. Mi̱ zä mi̱ di̱ni̱ ha o ra̱ mɛ̱nyu̱, ma̱ hømbi go'mi̱, di johya ngue'a̱ te bi di̱ni̱. Da̱ mä te gä pɛspʉya ngue da̱ dänna̱ häi ha o ra̱ mɛ̱nyu̱ bi di̱ni̱. Ya drá̱ mmɛti ra̱ häi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nu̱ya yø ja̱'i̱ honi̱ ha di zo rá̱ 'yɛ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱, guehya tengu̱tho n'na ra̱ pøhø i 'yo ngue honyø perla, ta̱te ma̱ndøngu̱ drá̱ mu̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nu̱'mø bi di̱nna̱ perla ma̱ndøngu̱ drá̱ mu̱ui, da̱ mä te gä pɛts'i, da̱ dänna̱ perla bi di̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nu̱na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱, nu̱ya yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi di̱ ma̱nda, tengu̱tho yø hua̱ bi thɛ ra̱ xit'a̱ 'mø bi̱ ma yø mahua̱ p'ʉ ja ra̱ ja̱the. 'Dama̱ 'dan'yo yø hua̱ bí thɛ. ");
INSERT INTO otnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nu̱'mø bá̱ yu̱hra̱ xit'a̱ yø mahua̱, da̱ jʉca̱ nenthe p'ʉya, da̱ mi̱ ngue da̱ huanhni̱. Yø hoga̱ hua̱ i pɛts'i, pɛ yø hua̱ hi̱ngui̱ ho i ɛi. ");
INSERT INTO otnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Di̱ njarbʉtho'a̱ te ra̱ hya̱ di̱ nja 'mø bi gua'a̱ nxi̱mhäi ya. Da̱ ma yø anxɛ ngue da̱ sicyø ts'oc'ɛ̱i̱ p'ʉ ha di 'bʉhyø ja̱'i̱ xa̱nho te ga̱ 'yo. ");
INSERT INTO otnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Yø ts'oc'ɛ̱i̱ da̱ hyørbʉ ja ra̱ orno di da̱nzø. Ja di̱ nzomp'ʉ 'nɛ̱ ja di̱ gu̱xpʉ yø ts'i ngue ra̱ nda̱te di sä. ");
INSERT INTO otnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bi 'yänyø ja̱'i̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua ti̱ni̱ xa̱nho ni̱ mmʉihʉ ya yø hya̱ dá̱ ma̱ngä ya, uague hi̱n'na̱? ―bi 'yɛ̱mbi̱. Yø ja̱'i̱ p'ʉya bi 'yɛ̱na̱: ―A̱há̱, grá̱ Hmu̱, ti̱nma̱ mmʉigähe hanja ra̱ hya̱ guí̱ mma̱nya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ra̱ Jesús ma̱hømbi 'yɛ̱mbyø ja̱'i̱: ―Nu̱ ra̱ xännba̱te ngue ra̱ ley, nu̱'mø da̱ gohi ngue ma̱ xädi, ma̱'da'yo di xädi ha di zo rá̱ 'yɛ Oja̱, ya ma̱n'na xa̱ngu̱ yø hya̱ da̱ ba̱di̱. Da̱ gohi tengu̱tho n'na ra̱ n'yohʉ xa̱ngu̱ te pɛspʉ ja rá̱ ngu̱, jap'ʉ yø cosa ngue yø nyogui, xi̱mmi̱ jap'ʉ yø cosa ngue ma̱'da'yo. ");
INSERT INTO otnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ra̱ Jesús høntho bi juadi bi xihyø ja̱'i̱ ya yø hya̱ bi hyɛqui, bi̱ ma p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mi̱ zømp'ʉ Nazaret ja ra̱ hni̱ni̱ bá̱ nte. Bi̱ map'ʉ ja ra̱ ni̱ja̱ ngue bí xännba̱ ra̱ hya̱ yø ja̱'i̱. Nu̱ya yø ja̱'i̱ bi 'yøde hanja ra̱ hya̱ bi̱ ma̱, gä di 'yøtho, di̱ n'yɛ̱mbi̱: ―¿Hague go ga̱ mba̱'a̱ te ra̱ hya̱ pa̱hna̱? ¿Hague ga̱ nzä øtyø milagro? ");
INSERT INTO otnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Conque guehna̱ rá̱ ts'ʉnt'ʉ ra̱ yaxi na̱. Nu̱na̱ rá̱ mamá p'ʉya, gue'a̱ ra̱ Ma̱ya. Yø n'yohʉ p'ʉya, gue'a̱ ra̱ Jacobo, 'nɛ̱hra̱ José, 'nɛ̱hra̱ Simu̱, 'nɛ̱hra̱ Judas. ");
INSERT INTO otnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yø nju̱ p'ʉya, gä 'dadua ra̱ hni̱ni̱ dí 'bʉhmʉ. Xina̱, ¿hapʉ go bá̱ ha̱'a̱ te ra hya̱ xännba̱te na̱? ―di̱ n'yɛ̱mbyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ja̱na̱ngue yø ja̱'i̱ ɛ̱mbi̱ ngue to bi zä ma̱n'yohʉ na̱ ra̱ Jesús. Hi̱ngui̱ ørpa̱tho ma̱su̱ yø ja̱'i̱ te xifi. Pɛ ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Gätho yø pønga̱hya̱ Oja̱ n'nanni̱ ni̱ 'yɛ̱hɛ̱, gä hnu̱ ma̱nsu̱. Pɛ nu̱'ʉ yø mmɛ̱ngu̱hʉ yø pønga̱hya̱, hi̱ngui̱ nnu̱ ma̱nsu̱. Ni̱ xi̱nga̱ gue'ʉ to 'bʉp'ʉ ja rá̱ ngu̱ ra̱ pønga̱hya̱ di̱ nnu̱ ma̱nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ya hi̱mbi̱ 'yøt'e xa̱ngu̱ yø milagro p'ʉ ja ra̱ hni̱ni̱ p'ʉya, porque yø mmɛ̱ngu̱hʉ hi̱ngui̱ ɛ̱c'ɛ̱i̱tho ya yø hya̱ bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nu̱'ʉ yø pa'ʉ, nu̱p'ʉ ja ra̱ häi Galilea mi̱ nda̱st'abi ra̱ Herodes. Ra̱ Herodes mi̱ 'yøde te mma̱nyø ja̱'i̱ ngue xa̱ngu̱ yø milagro øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ra̱ Herodes bi 'yɛ̱mbyø ja̱'i̱ ja yø 'bɛfi p'ʉ ha 'bʉi: ―Nu̱gä dí ɛ̱na̱ ngue xpi bɛ̱nna̱te'a̱ ra̱ Xuua mi̱ øtra̱ nxixya̱. Ja̱na̱ngue sä øtyø milagro ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nu̱'mø yø pa bi thogui, ra̱ Herodes bi̱ ma̱nda bi̱ mbɛntra̱ Xuua, bi du̱t'i̱ conyø cadena bi got'a̱ fädi. Bi ʉpi ngue nu̱na̱ ra̱ Xuua ya xi xihra̱ Herodes ngue hi̱ngui̱ ho di̱ m'mʉhmi̱ rá̱ 'bɛpo Herodías nu̱na̱ ma̱rá̱ xisu'a̱ rá̱ n'yohʉ Lipe. ");
INSERT INTO otnNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nu̱na̱ ra̱ Xuua xi 'yɛ̱mbra̱ Herodes: “Hi̱n'yʉ ra̱ nt'ɛ̱di̱ guí̱ m'mʉhmi̱ ni̱ 'bɛpo”, xi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ra̱ Herodes mi̱ sihna̱ ra̱ hya̱ na̱, bi̱ ne xta̱ hyo ra̱ Xuua, pɛ hi̱mbi̱ zä porque ra̱ Herodes bi zu̱ yø ja̱'i̱. I pa̱di̱ ngue gätho yø ja̱'i̱ i̱ mma̱ ngue rá̱ pønga̱hya̱ Oja̱ na̱ ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pɛ mi̱ zøhrá̱ pa bi̱ nsänni̱go ra̱ Herodes. Nu̱na̱ rá̱ t'i̱xu̱ ra̱ Herodías bi yʉrbʉ 'bʉhyø ja̱'i̱ xi pɛtra̱ Herodes ngue sänni̱go, bi̱ mʉhra̱ hnɛ̱i̱ p'ʉya. Ra̱ Herodes di ho te øtra̱ hmu̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ra̱ Herodes bi 'yɛ̱mbra̱ hmu̱te: “Nu̱'mø tema̱ cosa gui 'yäqui, nu̱gä ga̱ 'da'i”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ra̱ hmu̱te p'ʉya bi̱ ma bá̱ änná̱ mamá te 'bɛ'a̱ da̱ 'yädi. Mi̱ xihrá̱ mamá te da̱ 'yäp'ʉ ya, bi̱ ma ra̱ hmu̱te, bi 'yɛ̱mbra̱ Herodes: “Da̱mi̱ 'dacrá̱ ya̱ ra̱ Xuua nu̱na̱ mi̱ 'yøtra̱ nxixya̱, dá̱ o ra̱ mohi”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma̱mbi du̱trá̱ mmʉi ra̱ da̱st'abi 'mø mi̱ 'yø'a̱ te sifi. Pɛ ya xi xihra̱ hmu̱te ngue di u̱nni̱ te da̱ 'yäpi. Yø ja̱'i̱ 'bʉp'ʉ mi̱ 'bʉi, gä xi 'yøde te xi̱ ma̱. Bi̱ ma̱nda p'ʉya ngue bi t'u̱nna̱ hmu̱te'a̱ te ädi. ");
INSERT INTO otnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bi 'yɛt'i to bá̱ hɛjpa̱ rá̱ ya̱ ra̱ Xuua p'ʉ ja ra̱ fädi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bá̱ jät'a̱ n'na ra̱ mohi, bi t'u̱nna̱ hmu̱te. Ra̱ hmu̱te p'ʉya, bi däprá̱ mamá. ");
INSERT INTO otnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mi̱ ba̱hyø xädi ra̱ Xuua ngue bi du̱, bi̱ ma bá̱ ha̱ ra̱ ánima ngue bi 'yägui. M'mɛfa p'ʉya, nu̱'a̱ te bi̱ nja, bi̱ ma bá̱ xihra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nu̱na̱ ra̱ Jesús mi̱ zä mi̱ ba̱di̱ ngue ya bi̱ du̱ ra̱ Xuua, bi 'yo ra̱ barco i̱ ma n'nanni̱ hapʉ hi̱njo'o yø ja̱'i̱. Pɛ yø ja̱'i̱ bi ba̱di̱ hapʉ i̱ ma, ma̱ndøngu̱ dyø ja̱'i̱ bi dɛnni̱ ni̱ nɛtra̱ nenthe. Nu̱p'ʉ ja yø hni̱ni̱ thogui, ja nɛ̱xpʉ mi̱'da yø ja̱'i̱ ngue tɛt'i. ");
INSERT INTO otnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mi̱ zøhra̱ barco bá̱ o ra̱ Jesús, bi bøni̱. Pɛ ya ma̱ndøngu̱ dyø ja̱'i̱ 'bʉp'ʉ. Ra̱ Jesús bi huɛ̱cyø ja̱'i̱ p'ʉya, bi 'yøthe yø därquɛ̱hi̱ bi zispa̱bi̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nu̱'mø ya ni̱ ma di̱ nde p'ʉya, nu̱'ʉ yø xädi ra̱ Jesús bi guarbʉ 'bäi, bi 'yɛ̱mbi̱: ―Ya bi̱ nde, 'nɛ̱ nu̱ua dí 'bʉhmʉ ra̱ da̱po ua. Da̱mi̱ 'yɛ̱hyø ja̱'i̱ n'namhma̱ da̱ map'ʉ bí ja yø hni̱ni̱, da̱ dänsɛ ra̱ hmɛ̱ da̱ zi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bi 'yɛ̱mbyø xädi ra̱ Jesús: ―Hi̱ngui̱ ja ngue da̱ ma yø ja̱'i̱ da̱ täi te da̱ zi. Da̱mi̱ u̱nhnʉ ra̱ hmɛ̱ da̱ zi yø ja̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nu̱'ʉ yø xädi p'ʉya bi 'yɛ̱mbi̱: ―Pɛ høndi cʉt'a yø thu̱hmɛ̱ dí ha̱gähe, 'nɛ̱ yoho yø hua̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Bí 'dacjʉ ua yø thu̱hmɛ̱ conyø hua̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bi 'bɛpyø ja̱'i̱ p'ʉya ngue bi̱ mi̱p'ʉ ja ra̱ 'batha. Bi hya̱n'ʉ cʉt'a yø thu̱hmɛ̱ 'nɛ̱'ʉ yoho yø hua̱. Bi hyanma̱ hɛ̱ts'i̱ p'ʉya, bi ja ma̱mma̱di̱ Oja̱. Bi xɛnyø thu̱hmɛ̱ p'ʉya, bi u̱nyø xädi ngue di 'darpa̱bi̱ yø ja̱'i̱. Da̱guehyø hua̱ bi dat'i. ");
INSERT INTO otnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bi̱ nsi̱hmɛ̱ xa̱nho yø ja̱'i̱, gä bi̱ nni̱ya̱. Mi̱ juate ra̱ ts'i̱hmɛ̱ yø ja̱'i̱ p'ʉya, nu̱'ʉ yø xädi ra̱ Jesús bi pɛti 'dɛ'ma̱yo canasta yø thu̱hmɛ̱ bi bongui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nu̱'ʉ yø ja̱'i̱ bi̱ nsi̱hmɛ̱'a̱ ra̱ ora'a̱, cʉt'a ma̱hua̱hi̱ ma̱'yohʉ bi̱ nsi̱hmɛ̱. Hi̱mma̱ cʉt'i ra̱ güɛnda yø xisu 'nɛ̱hyø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mɛ̱nte ɛ̱hyø ja̱'i̱ ra̱ Jesús, bi xihyø xädi ngue di̱ m'mɛt'o da̱ 'yo ra̱ barco di̱ ma ma̱n'na nguadi ra̱ zabi. ");
INSERT INTO otnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Høntho bi juadi bi 'yɛ̱hyø ja̱'i̱ ra̱ Jesús, bi̱ map'ʉ bí ja ra̱ nyu̱ni̱ bá̱ mat'Oja̱. Mi̱ dähra̱ nde, bi 'bʉsɛ p'ʉ ja ra̱ nyu̱ni̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pɛ ra̱ barco ya bi 'yo ma̱de ra̱ zabi. Nu̱p'ʉ ja ra̱ zabi, bi̱ nangra̱ nda̱te nda̱hi̱ ngue di cosra̱ barco. Asta̱ pa ma̱ya̱ yø fʉnthe. ");
INSERT INTO otnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mi̱ zʉ'i hyu̱ xu̱di̱ p'ʉya, nu̱na̱ ra̱ Jesús bi̱ map'ʉ bí 'bʉhyø xädi ni̱ 'yo ma̱xøts'e ra̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nu̱'mø ni̱ ma da̱ zømp'ʉ 'bʉhyø xädi, mi̱ hyandi̱ ngue mmap'ʉ ni̱ 'yo ma̱xøts'e ra̱ dehe. Bi zu̱ p'ʉya. Nu̱'a̱ ga̱ nzu̱ p'ʉya, bi 'yɛ̱na: ―Bá̱ ɛ̱cua ra̱ nda̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pɛ ra̱ Jesús bi zofo 'bexque'a̱, bi 'yɛ̱mbi̱: ―Go guecä, 'yoguí su̱hʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ra̱ Bɛdu p'ʉya bi 'yɛ̱mbra̱ Jesús: ―A nu̱'mø ngue gue'e grá̱ Hmu̱, da̱mi̱ 'yøt'e ngue da̱ zä ga̱ n'yogä ma̱xøts'e ra̱ dehe. Ga̱ søngä p'ʉ ga̱rá̱ ɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Gue bá̱ 'yo 'mø ―bi 'yɛ̱mbi̱. Ra̱ Bɛdu p'ʉya bi ga̱p'ʉ ja ra̱ barco, ni̱ 'yo ma̱xøts'e ra̱ dehe ngue da̱ zømp'ʉ bá̱ ɛ̱hra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pɛ nu̱'a̱ ga̱ 'yo ra̱ nda̱hi̱, i tønhni̱, bi̱ nsu̱ p'ʉya. 'Bexpi̱ mʉdi bi yʉ'a̱ mbonthe. Xøgue rá̱ mafi bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ Hmu̱, da̱mi̱ jʉxca̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Bexpi̱ macrá̱ 'yɛ ra̱ Jesús, bi gʉts'i. Bi 'yɛ̱mbi̱: ―Ague n'yø, ¿hanja ngue guí yobɛ̱ni̱? Gue zits'ʉtho guí ɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Høntho bi yʉt'a̱mbo ra̱ barco ra̱ Jesús, 'bexpi̱ nsäya ra̱ nda̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nu̱ya mi̱ o ra̱ barco p'ʉya bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mi̱ zøn'a̱ nenthe ja ra̱ häi Genesaret. ");
INSERT INTO otnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mi̱ ba̱hyø ja̱'i̱ 'bʉ'a̱ ra̱ xɛqui'a̱ ngue ya 'bʉp'ʉ ra̱ Jesús, ndap'ʉ bi zä, bi̱ n'yonnba̱sɛ ra̱ hya̱ yø ja̱'i̱ ngue bá̱ ɛ̱hɛ̱. Di̱ nxifi ngue da̱ zixyø därquɛ̱hi̱ p'ʉ 'bʉhra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yø ja̱'i̱ bi 'yäpra̱ ma̱te ra̱ Jesús ngue squera̱ngue rá̱ nya̱ni̱ rá̱ he da̱ därpa̱bi̱ yø därquɛ̱hi̱, 'bexque'a̱ sä ha hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nu̱ya yø fariseo 'nɛ̱hyø xännba̱te ngue ra̱ ley ngue yø mmɛ̱ngu̱ Jerusalén bi guarbʉ 'bähra̱ Jesús ngue ørpa̱ ra̱ nt'änni̱. Bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Hanja ni̱ xädi ngue fɛstho ra̱ hya̱ bi zoga̱hʉ yø ndiua? Porque hi̱ngui̱ pecra̱ ts'oqui ja yø 'yɛ, ngue di̱ nxʉ'yɛ hante di̱ nsi̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mi̱ da̱hra̱ Jesús, xquet'a̱ bi 'yørpa ra̱ nt'änni̱ ya ya̱ui, bi 'yɛ̱mbi̱: ―Da̱ gue'a̱hʉ, xiya yø hya̱ di̱ ma̱nda Oja̱, ¿hanja ngue guí fɛsthohʉ, ngue nu̱ya yø hya̱ xcá̱ sänsɛhʉ, gue'a̱ ga̱di ja ndu̱mmʉi guí øthʉ'a̱? ");
INSERT INTO otnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque Oja̱ bi xihyø ja̱'i̱, bi 'yɛ̱mbi̱: “Da̱mi̱ su̱ ni̱ papá, da̱mi̱ su̱ ni̱ mamá”. Ma̱hømbi 'yɛ̱mbi̱: “Nu̱ ra̱ ja̱'i̱ da̱ zanná̱ papá, ogue da̱ zanná̱ mamá, i ja ngue di̱ njapra̱ castigo 'nɛ̱ da̱ tho”, bi 'yɛ̱mbyø ja̱'i̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pɛ ya xcá̱ xännba̱hʉ yø ja̱'i̱ ngue ra̱ ja̱'i̱ da̱ zä da̱ 'yɛ̱mbra̱ papá ogue rá̱ mamá: “Nu̱gä papá, nu̱gä mamá, ya hi̱nda̱ zä ga̱ 'da'i te guí siui ya. Porque nu̱ te gä dí pɛts'i, guehna̱ Oja̱ da̱di̱ u̱nni̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nu̱'mø ngu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ ja̱'i̱ p'ʉya, ya hi̱n ga̱di japhʉ ngue di jamma̱nsu̱ rá̱ papá ogue rá̱ mamá ra̱ ja̱'i̱. Ja di̱ nɛ̱qui̱ p'ʉya ngue nu̱ya yø hya̱ di̱ ma̱nda Oja̱, guí ɛ̱mhmʉ ngue hi̱nte di̱ mu̱ui. Porque nu̱ya yø costumbre xa̱ nzänyø ndiua, guehya guí ɛ̱mhmʉ ngue ja ts'ɛditho gui 'yøthʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ni̱ xirbʉ guí ɛ̱na̱ ngue guí ɛ̱c'ɛ̱i̱hʉ Oja̱. Go guí øthʉ na̱ te ra̱ hya̱ bi 'yotra̱ pønga̱hya̱ Isaías ngue Oja̱ bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Nu̱ya yø ja̱'i̱ 'bʉcua, nu̱'mø bi̱ nya̱, xøgue ɛ̱na̱ ma̱jua̱ni̱ ngue nnu̱ ma̱nsu̱gui̱. Pɛ hi̱mma̱ jua̱ni̱ ngue yø mmʉi ga̱ nda̱nnegui. ");
INSERT INTO otnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ya hi̱nte ni̱ bøntho ngue tha̱nnegui yø ja̱'i̱. Nu̱ te gäma̱ hya̱ xännba̱te, xa̱ngu̱ yø hya̱ xa̱ nzänsɛ ngue ɛ̱mbi̱ di̱ ma̱nda Oja̱”, bi 'yɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ra̱ Jesús bi zonhyø ja̱'i̱, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'yøhmʉ xa̱nho ya yø hya̱ ga̱ mma̱ngä ya. Da̱mi̱ 'yɛ̱t'a̱mmʉihʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nu̱ ra̱ ja̱'i̱ øtra̱ ts'oqui, hi̱nga̱ gue'a̱ te si ra̱ ja̱'i̱ ga̱ 'yøtra̱ ts'oqui. Nu̱'a̱ ga̱ 'yøtra̱ ts'oqui ra̱ ja̱'i̱, gue'a̱ ra̱ ts'omhya̱ pønná̱ ne ra̱ ja̱'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yø xädi ra̱ Jesús bi guarbʉ 'bäi, bi 'yɛ̱mbi̱: ―¿Ua guí̱ pa̱di̱ ngue mbøcuɛ yø fariseo 'mø mi̱ 'yøhna̱ ra̱ hya̱ guí xifi? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ra̱ Jesús ɛ̱ntho 'mø mi̱ da̱di̱: ―Nu̱'a̱ ma̱ Papágä bí 'bʉ ma̱hɛ̱ts'i̱, nu̱'ʉ yø ja̱'i̱ hi̱ngui̱ o rá̱ 'yɛ, da̱ zijpʉ ha 'bʉhyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Da̱mi̱ hyɛgui, o sä guí su̱hʉ. Nu̱ya guehya yø xädä xännba̱bi̱ ra̱ hya̱ mi̱'da yø mmi̱nxädäui ya. Nu̱'mø bi̱ nthɛui ra̱ ots'i, nu̱p'ʉ da̱ zo ra̱ xännba̱te, ja da̱ zop'ʉ yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ra̱ Bɛdu bi 'yɛ̱mbra̱ Jesús: ―Da̱mi̱ xicje te ga̱ mbønya yø hya̱ gá̱ hyɛqui ngue te si ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Ua xquet'a̱ hi̱ngui̱ ti̱nni̱ mmʉihʉ hanja ya yø hya̱ dí̱ mma̱ngä? ");
INSERT INTO otnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ua hi̱nguí̱ pa̱hmʉ ngue nu̱ te gäma̱ cosa si ra̱ ja̱'i̱, mbo rá̱ mmʉi ra̱ ja̱'i̱ ni̱ ma, pɛ pigui te si ra̱ ja̱'i̱? ");
INSERT INTO otnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pɛ nu̱ ra̱ hya̱ pønná̱ ne ra̱ ja̱'i̱, mbo rá̱ n'yomfɛ̱ni̱ ra̱ ja̱'i̱ ní̱ 'yɛ̱hra̱ hya̱. Nu̱'mø xa̱nts'o ra̱ hya̱ bi̱ ma̱nna̱ ja̱'i̱, guehna̱ ra̱ ts'oqui na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porque mbo rá̱ n'yomfɛ̱ni̱ ra̱ ja̱'i̱ bi̱ mi̱hra̱ ts'o n'yomfɛ̱ni̱, ra̱ nthote, ra̱ n'yots'om'mäi, ra̱ mfɛ̱, ra̱ fɛhni̱, ra̱ ts'ate. Gä mbo rá̱ n'yomfɛ̱ni̱ ra̱ ja̱'i̱ ní̱ 'yɛ̱hra̱ ts'omhya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nu̱na̱ ra̱ hya̱ na̱ya, guehna̱ ra̱ ts'oqui øtyø ja̱'i̱ na̱. Pɛ nu̱'mø hi̱ngui̱ xʉ'yɛ ra̱ ja̱'i̱ 'mø bi̱ nsi̱hmɛ̱, hi̱nga̱ gue'a̱ ra̱ ts'oqui'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mi̱ bømp'ʉ mi̱ 'bʉhra̱ Jesús, i̱ map'ʉ ja n'na ra̱ häi ja ra̱ hni̱ni̱ Tiro conna̱ hni̱ni̱ Sidón. ");
INSERT INTO otnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nu̱p'ʉ ja ra̱ hni̱ni̱ bi zønna̱ Jesús, mi̱ 'bʉp'ʉ n'na ra̱ xisu hi̱ngra̱ judío, ma̱rá̱ mmɛ̱ngu̱ p'ʉ ja ra̱ häi Canaán. Bi̱ ma ra̱ xisu p'ʉya, ní̱ mafi, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, rá̱ mbom'mɛto'i ra̱ David, da̱mi̱ huɛ̱ga̱gui̱. Nu̱ ma̱ t'i̱xu̱ dí si, n'youi ra̱ ts'onthi̱. Pɛ ɛ̱mmɛ̱i̱ di ʉni̱, da̱mi̱ 'yøthets'ʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pɛ ra̱ Jesús hi̱ngui̱ tha̱tho. Yø xädi p'ʉya bi 'yɛ̱mbra̱ Jesús: ―Da̱mi̱ 'yørpa̱bi̱ nts'ɛdi'a̱ te xi'i, porque ra̱ nxu̱na̱nya̱tho ngue nuɛrca̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ra̱ Jesús bi 'yɛ̱mbra̱ xisu: ―Nu̱gä bá̱ pɛnga̱gui̱ Oja̱ ngue høndyø judío ga̱ fäts'i. Porque yø judío ɛ̱ntho yø dɛ'yo ya xa̱ n'uɛ̱ni̱, ngue hi̱njongui̱ fädi. ");
INSERT INTO otnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pɛ ra̱ xisu bi guarbʉ 'bähra̱ Jesús ngue bi̱ nda̱ntyøhmu̱, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, da̱mi̱ fäxquits'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ra̱ Jesús bi 'yɛ̱mbra̱ xisu ya̱ui: ―Pɛ nu̱'mø ngue 'bet'o go ga̱ fäxa̱'i̱, 'nɛ̱ hi̱ngrá̱ judío, ya sʉtho 'mø da̱ tha̱nnba̱ ra̱ hmɛ̱ yø ba̱si̱, ngue yø fo'yo di t'u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ra̱ xisu p'ʉya bi 'yɛ̱mbi̱: ―A̱há̱, grá̱ Hmu̱, gue'a̱ guí̱ mma̱. Pɛ yø fo'yo, gue'ʉ yø xɛmhmɛ̱ täp'ʉ ja ra̱ mɛ̱xa̱ si̱hmɛ̱ yø hmu̱ si'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ra̱ Jesús bi 'yɛ̱mbra̱ xisu ya̱ui: ―Ague grá̱ xisu, guí ɛ̱c'ɛ̱i̱gui̱ xa̱ndønho ngue da̱ zä di̱ nja'a̱ te guí̱ mma̱. Ja̱na̱ngue di̱ nja ya. Nu̱'a̱ rá̱ t'i̱xu̱ ra̱ xisu mi̱ n'youi ra̱ ts'onthi̱ p'ʉya, 'bexque'a̱ bi zä. ");
INSERT INTO otnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mi̱ thohra̱ Jesús, i̱ mpa ma̱n'na nguadi ra̱ zabi Galilea. Nu̱p'ʉ ja ra̱ nyu̱ni̱ bi zøni̱, bi̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Xa̱ndøngu̱ yø ja̱'i̱ bi zømp'ʉ 'bʉi. Bi zispa̱ yø därquɛ̱hi̱ xa̱ nnu̱nts'i̱, yø xädä, yø gone, yø do'yɛ, yø dogua, xa̱ngu̱ mi̱'da yø därquɛ̱hi̱ bi ts'ispa̱bi̱ ra̱ Jesús ngue bi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mi̱ nu̱ yø ja̱'i̱ te øtra̱ Jesús ngue bi zä bi 'yøthe yø därquɛ̱hi̱, di 'yødyø ja̱'i̱. Yø gone bi zä bi̱ nya̱, bi zä yø do'yɛ, bi zä yø dogua. Bi̱ nzø yø dä yø xädä. Mi̱ nja'a̱ p'ʉya, gätho yø ja̱'i̱ bi 'yɛ̱spa̱bi̱ Oja̱ nu̱na̱ tha̱nne yø judío. ");
INSERT INTO otnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Bi zonhyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱di huɛ̱cä yø ja̱'i̱ 'bʉcua, porque ya rá̱ hyu̱ pa 'daua dí 'yohʉ ya. Dí pa̱'a̱ njua̱ni̱ ngue ya hi̱n'yʉ te da̱ zi yø ja̱'i̱. Nu̱gä hi̱ndí̱ nne ga̱ ɛt'i ngue da̱ ma yø ngu̱ 'nɛ̱ hi̱ndi̱ si̱hmɛ̱, porque da̱ güennbʉ ja ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nu̱'ʉ yø xädi bi 'yɛ̱mbi̱: ―Pɛ ¿hapʉ go ga̱ ha̱nnba̱hʉ te da̱ zi ya yø ja̱'i̱ 'bʉcua? Porque xa̱ndøngu̱. A nu̱ua dí 'bʉhmʉ, ra̱ da̱po ua. ");
INSERT INTO otnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bi 'yänyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hangu̱ yø thu̱hmɛ̱ guí ha̱hʉ 'mø? Nu̱'ʉ yø xädi p'ʉya bi 'yɛ̱mbi̱: ―Høndi yoto yø thu̱hmɛ̱ ja ua, 'nɛ̱ zi yoho yø hua̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bi̱ ma̱nda ra̱ Jesús ngue bi̱ mi̱hyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bi hya̱n'ʉ yoto yø thu̱hmɛ̱ p'ʉya conyø hua̱. Bi ja ma̱mma̱di̱ Oja̱ ngue ya di̱ nsi̱hmɛ̱ yø ja̱'i̱. Bi xɛnyø thu̱hmɛ̱ p'ʉya, bi u̱nyø xädi ngue di 'darpa̱ yø ja̱'i̱ da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Nu̱'ʉ yø ja̱'i̱ bi̱ nsi̱hmɛ̱, goho ma̱hua̱hi̱ ma̱'yohʉ. A nu̱ yø xisu 'nɛ̱hyø ba̱si̱ hi̱ngui̱ cʉtra̱ güɛnda'ʉ. Pɛ gä bi̱ nni̱ya̱. Mi̱ juate ra̱ ts'i̱hmɛ̱ yø ja̱'i̱, nu̱'ʉ yø xädi ra̱ Jesús bi pɛti yoto canasta yø thu̱hmɛ̱ bi bongui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","M'mɛfa p'ʉya, ra̱ Jesús bi 'yɛ̱hyø ja̱'i̱. Bi̱ ma p'ʉya, bi 'yo ra̱ barco, bi zømp'ʉ ja ra̱ häi ni̱ hu̱ ngue Magdala. ");
INSERT INTO otnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ngu̱ i zøhra̱ Jesús, nu̱ya yø fariseo conyø saduceo bi̱ ma bá̱ sämhya̱ ra̱ Jesús. Di 'bɛpi ngue da̱ 'yøt'a̱ n'na ra̱ milagro nu̱ ma̱hɛ̱ts'i̱, para ngue di̱ nɛ̱qui̱ ngue rá̱ m'mɛnhni̱ Oja̱ na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱'mø ngue ra̱ nde, guí ɛ̱mhmʉ: “Xta̱ nho ra̱ tiempo ya, porque ja yø zøgu̱i̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nu̱'mø xu̱di̱ p'ʉya, guí ɛ̱mhmʉ 'mø: “Nu̱ya hi̱ndi̱ ho ra̱ pa ya, porque ra̱ ndu̱hmi̱ ra̱ c'amma̱hɛ̱ts'i̱ ngue ja ra̱ gu̱i̱”, guí ɛ̱mhmʉ. Guí ɛ̱na̱ ngue guí pa̱hmʉ xa̱nho te ga̱ mbøn'a̱ te bí ja ma̱ya̱. Pɛ nu̱ya guí ɛ̱na̱ ngue hi̱nguí̱ pa̱hmʉ te ga̱ mbønya te gäma̱ hya̱ guí̱ nnu̱hʉ yø pa dí 'bʉhmʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yø ja̱'i̱ 'bʉhya, yø ts'oc'ɛ̱i̱ ngue hi̱ngui̱ pa̱ Oja̱. 'Bet'o nne da̱ nu̱ yø milagro, ja da̱ 'yɛ̱c'ɛ̱i̱gui̱. Pɛ hi̱n tema̱ ma̱n'na ma̱ mi̱lagro di̱ nja ya, hi̱nda̱ hønt'a̱ te bi thohra̱ Jonás da̱ nøpa̱ hmɛ̱ya yø ja̱'i̱ ya. Bi zop'ʉ yø ja̱'i̱ p'ʉya, bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mi̱ zøm ma̱n'na nguadi ra̱ zabi, nu̱'ʉ yø xädi ra̱ Jesús xi pu̱mbɛ̱ni̱ ra̱ thu̱hmɛ̱ xta̱ hya̱ts'i ngue da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Da̱mi̱ mfähmʉ ya, ma̱mi̱ sihʉ'a̱ ra̱ íxi di u̱nyø fariseo ya, conyø saduceo. ");
INSERT INTO otnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na'ʉ yø xädi p'ʉya: ―Rá̱ nzɛgui xicjʉ ya ngue hi̱nxtá̱ ha̱ ra̱ thu̱hmɛ̱ ga̱ sihʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bi ba̱hra̱ Jesús te di̱ nxihyø xädi, bi 'yɛ̱mbi̱: ―Gue guí ɛ̱na̱ dí xi'a̱hʉ ngue hi̱nxcuá̱ ha̱ ra̱ thu̱mhɛ̱ gui sihʉ. ¿Ua hi̱ngui̱ 'yo ni̱ mmʉihʉ na̱ ra̱ hya̱ dí̱ mma̱ngä 'mø? Masque ma̱di̱ zits'ʉ guí ɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ua hi̱ngui̱ 'yo ni̱ mmʉihʉ ya yø hya̱ dí̱ mma̱ngä? ¿Ua hi̱nguí̱ mbɛ̱mhmʉ'a̱ te guí̱ nnu̱hʉ p'ʉ nná̱ mähä? Xi'mø ra̱ pa ngue høndi cʉt'a nthu̱hmɛ̱ i̱ nsi̱hmɛ̱ cʉt'a ma̱hua̱hi̱ ma̱'yohʉ, ¿ua hi̱nguí̱ mbɛ̱mhmʉ njammi̱ canasta yø thu̱hmɛ̱ bi bongui̱? ");
INSERT INTO otnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Xi'mø ra̱ pa ngue høndi yoto yø thu̱hmɛ̱ i̱ nsi̱hmɛ̱ goho ma̱hua̱hi̱ ma̱'yohʉ, ¿ua hi̱nguí̱ mbɛ̱mhmʉ njammi̱ canasta yø thu̱hmɛ̱ bi bongui̱? ");
INSERT INTO otnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Hanja ngue hi̱ngui̱ 'yo ni̱ mmʉihʉ ngue hi̱ngra̱ thu̱hmɛ̱ dí̱ mma̱ ngue dí xi'i ngue guí mfähmʉ ngue ra̱ íxi di u̱nyø fariseo 'nɛ̱hyø saduceo? ");
INSERT INTO otnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ya bi̱ di̱nyø mmʉi'ʉ yø xädi te mma̱nna̱ Jesús, ngue hi̱ngra̱ íxi pɛ ra̱ thu̱hmɛ̱'a̱ xifi ngue di̱ mfädi. Sinoque nu̱'a̱ ra̱ hya̱ xifi, ngue hi̱ndi̱ xä'ʉ yø hya̱ xännba̱te yø fariseo 'nɛ̱hyø saduceo. ");
INSERT INTO otnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nu̱p'ʉ ja ra̱ xɛqui ja ra̱ hni̱ni̱ Cesarea ngue Filipos, mi̱ zømp'ʉ ra̱ Jesús. Bi 'yänyø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱gä drá̱ N'yohʉ dá̱ ɛ̱ ma̱hɛ̱ts'i̱, ¿te'o ɛ̱nyø ja̱'i̱ ngue guecä? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nu̱'ʉ yø xädi p'ʉya bi 'yɛ̱mbi̱: ―'Bʉ i'da yø ja̱'i̱ ɛ̱mbi̱ ngue gue'e grá̱ Xuua gmi̱ øtra̱ nxixya̱. Mi̱'da yø ja̱'i̱ p'ʉya, ɛ̱mbi̱ ngue gue'e grá̱ Elías. Mi̱'da p'ʉya, ɛ̱mbi̱ ngue grá̱ Jeremías. Mi̱'da p'ʉya, ɛ̱mbi̱ ngue 'bʉi toni̱ pønga̱hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ra̱ Jesús ma̱hømbi 'yɛ̱mbyø xädi: ―Xi'a̱hʉ p'ʉya, ¿te'ogä p'ʉ gni̱ bɛ̱mhmʉ ngue guecä? ");
INSERT INTO otnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mi̱ da̱hra̱ Bɛdu, bi 'yɛ̱mbi̱: ―Nu̱'i̱, gue'e grá̱ Cristo, rá̱ Ts'ʉnt'ʉ'i Oja̱ nu̱na̱ ma̱jua̱ni̱ ngue 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Ra̱ mmɛ̱nthi̱ gá̱ nthɛui grá̱ Simu̱, rá̱ ts'ʉnt'ʉ'i Jonás. Porque hi̱njonni̱ ja̱'i̱ bi bɛ̱n'na̱'i̱ ra̱ hya̱ guí̱ mma̱, sinoque guesɛ na̱ ma̱ Papá bí 'bʉ ma̱hɛ̱ts'i̱ bi ja'i̱ gá̱ ma̱nna̱ ra̱ hya̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nu̱gä dí xi'i ya, gue'e gni̱ hu̱ ngue grá̱ Bɛdu, i̱ nne da̱ ma̱ ngue tengu̱tho n'na ra̱ do ngue dʉp'ʉ fots'i, hi̱njongui̱ a̱ni̱. Gue'e grá̱ mʉdi 'yɛ̱c'ɛ̱i̱ ya ngue gätho mi̱'da yø ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱gui̱ m'mɛfa. Nu̱ to gä da̱ 'yɛ̱c'ɛ̱i̱gui̱ da̱ da̱pra̱ nda̱te i ja. ");
INSERT INTO otnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Di̱ nja ni̱ cargo p'ʉ ha di̱ ma̱nda Oja̱ ya. Gue'e rá̱ representante'i Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. Nu̱'a̱ ra̱ hya̱ gui̱ u̱nna̱ nt'ɛ̱di̱ da̱ 'yøtyø ja̱'i̱, gue'a̱ di̱ nja'a̱. Nu̱'a̱ ra̱ hya̱ hi̱ngui̱ u̱nna̱ nt'ɛ̱di̱ da̱ 'yøtyø ja̱'i̱ ua ja ra̱ xi̱mhäi, hi̱ngui̱ sä da̱ 'yøtyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱, bi xihyø xädi p'ʉya ngue hi̱njonni̱ ja̱'i̱ da̱ xifi ngue guehna̱ ra̱ Cristo na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ra̱ Jesús bi xihyø xädi ngue ja ts'ɛditho di̱ ma Jerusalén, ja da̱ni̱ ma ma̱'ʉni̱ p'ʉ. Di ʉnyø mmäcja̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley, 'nɛ̱hyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱. Da̱ hyo, pɛ rá̱ hyu̱ pa p'ʉya di bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ra̱ Bɛdu p'ʉya, bi zica̱ n'nanni̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, 'yo da̱ ne Oja̱ ngue da̱ ngu̱'a̱ gui thogui. ");
INSERT INTO otnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mi̱ 'bätra̱ Jesús, bi 'yɛ̱mbra̱ Bɛdu: ―Da̱mi̱ 'uegue, rá̱ mɛfi'i ra̱ zithu̱. Porque nu̱'i̱ guí orca̱thogui. Hi̱nga̱ gue'a̱ rá̱ ts'änni̱ Oja̱ so ni̱ mmʉi di̱ nja. Sinoque gue'a̱ te yø hya̱sɛ yø ja̱'i̱ so ni̱ mmʉi di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bi 'yɛ̱mbyø xädi ra̱ Jesús: ―Nu̱ to nne da̱ dɛnngui̱, hi̱ngui̱ sä ngue da̱ zänsɛ te da̱ n'yo. Hi̱nha di gohrá̱ mmʉi, ma̱da̱gue'a̱ da̱ thop'ʉ ja ra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nu̱ ra̱ ja̱'i̱ da̱ 'uegue ngue su̱ da̱ tho, guehna̱ ra̱ ja̱'i̱ di̱ m'mɛhrá̱ te na̱. Pɛ nu̱ ra̱ ja̱'i̱ hi̱ngui̱ cohrá̱ mmʉi'a̱ ga̱ 'yɛ̱c'ɛ̱i̱gui̱, ma̱da̱ tho conná̱ ngueque, guehna̱ ra̱ ja̱'i̱ di̱ nya̱nná̱ te na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Porque hi̱nte da̱ da̱hra̱ ja̱'i̱, ma̱da̱gue'a̱ da̱ 'yøt'e ngue rá̱ mmɛti gä ra̱ xi̱mhäi 'nɛ̱ di̱ m'mɛhrá̱ te. Ni̱ xi̱nda̱ ha̱ngu̱ ra̱ mɛ̱nyu̱ da̱ gu̱tra̱ ja̱'i̱, hi̱nda̱ zä da̱ ya̱nná̱ te. ");
INSERT INTO otnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","A nu̱'mø bá̱ ɛ̱hɛ̱ ma̱høn'a̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, dí ha̱tra̱ ts'ɛdi Oja̱, da̱ n'youi yø anxɛ. Di u̱nyø nzäbi n'na ngu̱ n'na yø ja̱'i̱, da̱ gu̱t'i̱ te xa̱ 'yøt'e, xa̱nho ogue xa̱nts'o. ");
INSERT INTO otnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱ya 'da 'bʉcua ya, hi̱nda̱ du̱, asta̱ gue'mø da̱ nu̱ ngue da̱ hya̱ ra̱ ts'ɛdi ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ di̱ ma̱nda ua. ");
INSERT INTO otnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mi̱ tho'a̱ n'nato ma̱ pa, nu̱na̱ ra̱ Jesús bi zixra̱ Bɛdu 'nɛ̱hya mi̱ yonc'ɛ̱i̱ di̱ n'yohʉ, ra̱ Jacobo 'nɛ̱hra̱ Xuua. Bi̱ mɛp'ʉ bí ja n'na ra̱ nyu̱ni̱ xa̱nhɛ̱ts'i̱ ngue di̱ m'mʉsɛ. ");
INSERT INTO otnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ja bá̱ nu̱p'ʉ yø xädi p'ʉya ngue bi̱ mpä'a̱ gui̱ nɛ̱qui̱ ra̱ Jesús. Nu̱ rá̱ hmi̱, di yoxni̱ tengu̱ ra̱ hyadi. Rá̱ he p'ʉya, ra̱ mbøsɛ asta̱ di yoxni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bi̱ nu̱ yø xädi p'ʉya ngue 'bäp'ʉ ra̱ Moisés conna̱ Elías ngue ya̱ui ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ra̱ Bɛdu bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ Hmu̱, ya xa̱nho ngue dí 'bʉhmʉ ua. Xiya, ¿ua guí̱ nne ga̱ høcähe hyu̱ yø t'ʉnni̱gu̱, n'na'i̱, n'na ra̱ Moisés, n'na ra̱ Elías? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tobe ya̱dra̱ Bɛdu 'mø mi̱ go'mra̱ gu̱i̱ p'ʉ ha 'bʉi. Xøgue di yoxni̱ ra̱ gu̱i̱. Bi 'yø p'ʉya ngue nu̱p'ʉ ja ra̱ gu̱i̱ ja bá̱ nya̱p'ʉ Oja̱, bi 'yɛ̱na̱: ―Nu̱na̱ 'bʉcua ya, guehna̱ ma̱ Ts'ʉnt'ʉ da̱di̱ ma̱di̱. Co nu̱na̱ ya i ja ga̱mpähä. Nu̱ya yø hya̱ da̱ ma̱nna̱ ya, da̱mi̱ 'yɛ̱t'a̱mmʉihʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mi̱ 'yøhyø xädi na̱ ra̱ hya̱ bá̱ ma̱n'Oja̱ ma̱ya̱, bi̱ m'mɛmfo häi p'ʉya, pɛ ma̱thoguitho bi̱ nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nu̱p'ʉ ha 'boni̱, bi guatra̱ Jesús. Bi dots'i n'na ngu̱ n'na, bi 'yɛ̱mbi̱: ―Da̱mi̱ nangüi̱, 'yo guí̱ nsu̱ui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mi̱ hyɛ̱tyø xädi p'ʉya, ya hi̱njon gui 'bäp'ʉ'ʉ yoho yø n'yohʉ xi̱ nu̱. Ya 'bäsɛ p'ʉ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ya bá̱ 'yo ngue ní̱ ga̱p'ʉ ja ra̱ ngua̱ni̱ p'ʉya. Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―'Yo to gui xifi te gá̱ nu̱ui ya, asta̱ gue'mø bi hnu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ngue di bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nu̱ya yø xädi ra̱ Jesús bi 'yänna̱ n'na ra̱ hya̱, bi 'yɛ̱mbi̱: ―¿Hanja na̱ ra̱ hya̱ mma̱nyø xännba̱te ngue ra̱ ley, ngue ra̱ Elías ɛ̱mbi̱ ngue jatho da̱ 'bɛt'o hante ngue da̱ ɛ̱hra̱ Cristo? ");
INSERT INTO otnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mi̱ da̱hra̱ Jesús bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue ra̱ Elías mi̱ jatho ngue rá̱ mʉditho da̱ ɛ̱hɛ̱ da̱ xihyø ja̱'i̱ ngue di̱ nsä. ");
INSERT INTO otnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pɛ da̱mi̱ pa̱hmʉ ya ngue nu̱na̱ t'ɛ̱mbi̱ ra̱ Elías, ya bá̱ ɛ̱hɛ̱. Pɛ hi̱mbi̱ n'yo yø mmʉi yø ja̱'i̱ te'o na̱. Ja̱na̱ngue nu̱ hangu̱ ra̱ n'ʉ bi̱ ne da̱ japi, gä bi̱ nja. Xquet'a̱ di̱ njarbʉtho ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ya, di ʉnyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nu̱'ʉ yø xädi p'ʉya bi̱ n'yo yø mmʉi'a̱ ra̱ hya̱ mma̱nna̱ Jesús ngue nu̱na̱ ra̱ Xuua bi 'yøtra̱ nxixya̱, guehna̱ bi t'ɛmbi̱ ngue ra̱ Elías. ");
INSERT INTO otnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mi̱ zøp'ʉ 'bʉhyø ja̱'i̱ ra̱ Jesús, bi guat'a̱ n'na ra̱ n'yohʉ bi̱ nda̱ntyøhmu̱ p'ʉ 'bäi, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Ague grá̱ hmu̱, nu̱ ma̱ ts'ʉnt'ʉ dí si n'youi ra̱ n'ʉ ngue ra̱ ataque, ja̱njua̱ni̱ ngue di ʉni̱. Nu̱'mø bi gʉ, høt'a̱ sibi, ja'mø hørbʉ ja ra̱ dehe. Da̱mi̱ huɛ̱ga̱gui̱ ma̱ ts'ʉnt'ʉ, gui 'yøthe ts'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ya xtá̱ xihni̱ xädi ngue xta̱ 'yøthe ts'ʉ, pɛ hi̱nxa̱ nzä xa̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ra̱ Jesús bi 'yɛ̱mbi̱ gätho yø ja̱'i̱ 'bʉp'ʉ: ―¿Asta̱ nja̱m'mø da̱ zønna̱ pa gui 'yɛ̱c'ɛ̱i̱ga̱hʉ? ¿Ua guí ɛ̱na̱ ngue ha̱ngu̱ ra̱ pa ga̱ sɛt'a̱hʉ? Bá̱ si ua ra̱ ts'ʉnt'ʉ, ga̱ øthegä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nu̱na̱ ra̱ Jesús bi xihra̱ ts'onthi̱ n'youi ra̱ ts'ʉnt'ʉ ngue bi hyɛp'ʉ. Ra̱ ts'ʉnt'ʉ p'ʉya 'bexpi zä ra̱ n'ʉ mi̱ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","M'mɛfa p'ʉya, bi 'yänsɛ n'nanni̱ yø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hanja ngue hi̱nxa̱ nzä xtá̱ øthegähe ra̱ ts'ʉnt'ʉ mi̱ n'youi ra̱ ts'onthi̱? ");
INSERT INTO otnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Hi̱nxa̱ nzätha̱, porque hi̱n ga̱di segura ni̱ mmʉihʉ ngue da̱ zä ra̱ därquɛ̱hi̱. Ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱'mø ngue di ja zits'ʉ ni̱ nt'ɛ̱c'ɛ̱i̱hʉ, ma̱da̱gue'a̱ tengu̱tho ga̱ nnoho n'na zi hmu̱dä ra̱ mostasa, ya da̱ zä gui 'yɛ̱mphʉ ra̱ nyu̱ni̱ ja nʉ: “Da̱mi̱ 'uecua guí ja grá̱ nyu̱ni̱, i̱ ma ma̱n'na nguadi”, gui 'yɛ̱mphʉ, ra̱ nyu̱ni̱ p'ʉya da̱ 'uegue. Hi̱nte gui hyɛ̱mphʉ 'mø di ja'a̱hʉ zits'ʉ ra̱ nt'ɛ̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","A nu̱na̱ tengu̱ ra̱ ts'onthi̱ mi̱ n'youi ra̱ ts'ʉnt'ʉ, para ngue da̱ zä da̱ hyɛp'ʉ ra̱ ja̱'i̱ n'youi, mahyoni̱tho ngue da̱ mat'Oja̱ ra̱ ja̱'i̱ 'nɛ̱ da̱ 'yɛtrá̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mɛ̱nte 'youi p'ʉ ja ra̱ häi Galilea yø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, di̱ ndäpyø ja̱'i̱ ngue da̱ hyo. ");
INSERT INTO otnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nu̱'mø bi hyo p'ʉya, di bɛ̱nna̱te'a̱ rá̱ hyu̱ pa. Nu̱na̱ ra̱ hya̱ bi xihyø xädi, ɛ̱mmɛ̱i̱ bi du̱ yø mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ní̱ n'youi yø xädi ra̱ Jesús, bi zømp'ʉ ja ra̱ hni̱ni̱ Capernaum. Nu̱'ʉ yø n'yohʉ jʉhra̱ mɛ̱nyu̱ p'ʉ ja ra̱ ni̱ja̱ p'ʉya, bi 'yɛ̱mbra̱ Bɛdu: ―Xi ni̱ xännba̱tehʉ n'yø, ¿ua hi̱nda̱ gu̱tra̱ mɛ̱nyu̱ njʉi p'ʉ ra̱ ni̱ja̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ra̱ Bɛdu p'ʉya bi 'yɛ̱mbra̱ n'yohʉ jʉhra̱ mɛ̱nyu̱: ―A̱há̱, da̱ gu̱tra̱ mɛ̱nyu̱ ra̱ xännba̱te. M'mɛfa p'ʉya bi̱ ma ra̱ Bɛdu p'ʉ bí ja ra̱ ngu̱ 'bʉhra̱ Jesús. Hante ngue di̱ nya̱ ra̱ Bɛdu, ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague Simu̱, ¿te guí̱ mma̱nya? Xi yø da̱st'abi 'bʉcua ja ra̱ xi̱mhäi, ¿ndana̱ gue'a̱ jʉmba̱bi̱ ra̱ mɛ̱nyu̱ i jʉi, gue'ʉ yø ba̱si̱ jʉmbi̱, ua gue gue'ʉ yø ja̱'i̱ n'nan'yo jʉmbi̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Gue'ʉ yø ja̱'i̱ n'nan'yo njʉmba̱ ra̱ mɛ̱nyu̱ ―bi 'yɛ̱mbi̱. Ma̱hømbi 'yɛ̱nna̱ Jesús: ―Ja̱na̱ngue nu̱'ʉ yø ba̱si̱ Oja̱ hi̱ngui̱ ja ngue da̱ gu̱tra̱ mɛ̱nyu̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","A nu̱yá, para ngue hi̱nda̱ zʉcjʉ yø ja̱'i̱, ni̱ map'ʉ ja ra̱ zabi ya. Da̱mi̱ hya̱xra̱ xone t'ɛgui, guá̱ thɛ n'na ra̱ hua̱. Nu̱'a̱ rá̱ mʉdi ra̱ hua̱ guá̱ hʉqui, nu̱p'ʉ ja rá̱ ne ra̱ hua̱, gui ti̱nnba̱bi̱ ra̱ mɛ̱nyu̱ di op'ʉ. Di zʉ'a̱ p'ʉya ngue gui ju̱tra̱ mɛ̱nyu̱ t'äcä p'ʉ ja ra̱ ni̱ja̱, co 'nɛ̱'a̱ ra̱ mɛ̱nyu̱ t'ä'i gui ju̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nu̱'a̱ ra̱ ora'a̱, bi guatyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿ndana̱ ha̱nt'a̱ ni̱ mmʉi ngue ma̱ da̱tho da̱ hnu̱ ma̱nsu̱ p'ʉ ha di̱ ma̱nda Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱? ");
INSERT INTO otnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ra̱ Jesús bi zohna̱ n'na ra̱ ts'ʉnt'ʉ mi̱ 'bäp'ʉ, bi 'bämbʉ ma̱de ha 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Bi y'ɛ̱mbyø xädi p'ʉya: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱'mø hi̱ngui̱ pähni̱ n'yomfɛ̱ni̱hʉ, gui cohmʉ tengu̱tho ra̱ ts'ʉnt'ʉ 'bʉcua ya, hi̱ndi̱ cʉ'a̱hʉ p'ʉ di̱ ma̱nda Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A nu̱yá, nu̱na̱ ma̱ da̱tho da̱ hnu̱ ma̱nsu̱ p'ʉ di̱ ma̱nda Oja̱ ya, guehna̱ ra̱ ja̱'i̱ da̱ 'yøt'e ngue hi̱nte di̱ mu̱ui, di mmu̱tho tengu̱tho ra̱ ts'ʉnt'ʉ 'bʉcua ngue hi̱ndi̱ 'yani̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nu̱ ra̱ ja̱'i̱ di ja mma̱nsu̱ n'na ra̱ basi̱ tengu̱ na̱ 'bʉcua ya, ngu̱na̱ da̱ 'yøt'e porque pa̱hra̱ ja̱'i̱ ngue nu̱ te øt'e, gue'a̱ dí̱ nnu̱ ma̱nho ngue da̱ 'yøt'a̱, tengu̱tho 'mø ngue go di jamma̱nsu̱ gra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nu̱'ʉ yø ba̱si̱ ɛ̱c'ɛ̱i̱gui̱ ndap'ʉ bi zä, tengu̱tho na̱ ra̱ ba̱si̱ 'bʉcua ya, nu̱ ra̱ ja̱'i̱ da̱ japi ngue da̱ hyɛga̱gui̱ p'ʉ yø ba̱si̱ ɛ̱c'ɛ̱i̱gui̱, ra̱ nda̱te castigo tø'mra̱ ja̱'i̱ da̱ thogui. Hante ngue da̱ 'yøtra̱ ts'oqui ra̱ ja̱'i̱, ma̱n'na xa̱nho ngue da̱ t'ɛnnbʉ ja ra̱ ja̱the ra̱ ja̱'i̱, di̱ ntha̱rpa̱ rá̱ 'yʉga n'na ra̱ njʉni̱ ngue da̱ gʉ'mi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Xa̱n'ʉtho te ja ua ja ra̱ xi̱mhäi, porque hi̱ndi̱ 'bɛdi tema̱ cosa ga̱ 'yøtra̱ ts'oqui yø ja̱'i̱. Porque ngu̱tho siempre øtra̱ ts'oqui ra̱ ja̱'i̱, pɛ hague ngu̱ ra̱ castigo da̱ tho ra̱ ja̱'i̱ nu̱'a̱ di japi ngue øtra̱ ts'oqui rá̱ mmi̱c'ɛ̱i̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ja̱na̱ngue nu̱'mø guí ɛ̱na̱ ngue rá̱ ts'oqui ni̱ 'yɛ ogue rá̱ ts'oqui ni̱ gua p'ʉ gá̱ 'yøtra̱ ts'oqui, da̱mi̱ hyɛqui, 'yɛi yap'ʉtho. Ma̱n'na xa̱nho ngue ga̱rá̱ do'yɛ ogue ga̱rá̱ dogua 'mø gá̱ cʉrbʉ ha gui̱ m'mʉhmi̱ Oja̱, hi̱nda̱ gue'a̱ ngue di ja yoho ni̱ 'yɛ ogue di ja gä yoho ni̱ gua 'nɛ̱ ngu̱tho gui̱ mmap'ʉ ja ra̱ sibi para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nu̱'mø guí ɛ̱na̱ ngue rá̱ ts'oqui ni̱ dä p'ʉ gá̱ 'yøtra̱ ts'oqui, da̱mi̱ hya̱hni̱ dä, gui 'yɛi yap'ʉtho. Ma̱n'na xa̱nho ngue da̱ n'natho ni̱ dä 'mø gá̱ cʉrbʉ ha gui̱ m'mʉhmi̱ Oja̱, hi̱nda̱ gue'a̱ ngue di ja gä yoho ni̱ dä 'nɛ̱ ngu̱tho gui̱ mmap'ʉ ja ra̱ ni̱du̱ di̱ da̱nzø. ");
INSERT INTO otnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","'Yo guí ɛ̱mhmʉ ngue hi̱nte di̱ mu̱ui yø ba̱si̱. Nu̱gä dí xi'a̱hʉ ngue nu̱p'ʉ ma̱hɛ̱ts'i̱ bí 'bʉhma̱ Papá, nu̱'ʉ yø anxɛ za̱mp'ʉ ha 'bʉi, gue'ʉ fäxyø ba̱si̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, bi 'yɛ̱hɛ̱ ngue da̱ ya̱nyø ja̱'i̱ xa̱ m'mɛdi. ");
INSERT INTO otnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","A nu̱yá, xi'mø ngue di 'bʉi to di si n'na ciento yø dɛ'yo, 'nɛ̱ da̱ 'ue'a̱ n'na ndɛ'yo, ua̱ngui̱ da̱ zop'ʉ'ʉ goho 'däte ma̱'dɛ'ma̱ gʉto ndɛ'yo p'ʉ ja ra̱ da̱po di 'yo. Da̱ ma da̱ honná̱ ndɛ'yo xá̱ 'uegue. ");
INSERT INTO otnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nu̱'mø bá̱ ti̱mp'ʉya, ma̱n'natho di johya ngue bá̱ ti̱n'a̱ n'na ndɛ'yo xí 'uegue, hi̱nda̱ gue'ʉ goho 'däte ma̱'dɛ'ma̱ gʉto ndɛ'yo hi̱ngui̱ 'uegue. ");
INSERT INTO otnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Njarbʉtho ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ ya, hi̱ngui̱ nnepe ngue di̱ mm'mɛ'a̱ n'na mba̱si̱ ya yø ba̱si̱ 'bʉcua. ");
INSERT INTO otnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nu̱'mø hi̱ngui̱ ho te øt'a̱ ni̱ cu̱, da̱mi̱ zofo, jʉca̱ n'nani̱ ngue gui̱ nya̱sɛui. Da̱mi̱ xifi ngue hi̱ngui̱ ho te øt'e. Nu̱'mø bi̱ ne bi 'yø'a̱ ra̱ hya̱ guí xifi, ya xa̱nho. Ya gá̱ nhojpa̱ui ni̱ cu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pɛ nu̱'mø hi̱mbi̱ ne bi 'yøde te guí xifi, da̱mi̱ hyon'i yonc'ɛ̱i̱ ogue hyu̱ nc'ɛ̱i̱ gui sits'i, da̱ 'yøde hapʉ gui̱ nya̱ui ni̱ cu̱, ngue guí̱ nne gui̱ nhojpa̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A nu̱'mø hi̱nda̱ ne da̱ 'yøde te da̱ xi'ʉ gui sits'i, da̱mi̱ dä ra̱ güɛnda p'ʉ ja ra̱ ni̱ja̱ 'mø. A nu̱'mø hi̱nda̱ ne da̱ 'yø'a̱ te ra̱ hya̱ da̱ sip'ʉ ja ra̱ ni̱ja̱ p'ʉya, gui 'yø'ni̱ güɛnda ngue nu̱na̱ ni̱ cu̱ tengu̱tho 'mø hi̱ngra̱ 'yɛ̱c'ɛ̱i̱ ogue tengu̱tho 'mø drá̱ ngʉthäi. ");
INSERT INTO otnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Dí xi'a̱hʉ ngue go gyø representantehʉ nguehna̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. Nu̱na̱ ra̱ hya̱ gui̱ u̱nhnʉ ra̱ nt'ɛ̱di̱ da̱ 'yøtyø ja̱'i̱, gue'a̱ di̱ nja'a̱. Nu̱'a̱ ra̱ hya̱ hi̱ngui̱ u̱nhnʉ ra̱ nt'ɛ̱di̱ da̱ 'yøtyø ja̱'i̱ ua ja ra̱ xi̱mhäi, hi̱nda̱ sä da̱ 'yøtyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","I ja ma̱n'na̱ ra̱ hya̱ ga̱ xi'a̱hʉ ya. Nu̱ua ja ra̱ xi̱mhäi, nu̱'mø bi thɛ yø hya̱ yo nc'ɛ̱i̱ ngue 'da'igu̱ da̱ 'yäp'a̱ Oja̱, Oja̱ di u̱n'a̱ te da̱ t'äpi. ");
INSERT INTO otnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porque nu̱p'ʉ ha di̱ mpɛti yø ja̱'i̱ ɛ̱c'ɛ̱i̱gui̱, ma̱da̱gue'a̱ høndi yonc'ɛ̱i̱ ogue hyu̱ nc'ɛ̱i̱ di̱ mpɛti, pɛ nu̱p'ʉ ha 'bʉi, ja dí 'bʉcä p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ra̱ Bɛdu p'ʉya bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ hmu̱, xi ma̱ cu̱ ya ga̱ 'bʉ'a̱ ngue hi̱ngui̱ ho te ørque, ¿nja mmi̱ndi̱ ga̱ pu̱nnbi̱? ¿Gue asta̱ nyoto nni̱di̱? ");
INSERT INTO otnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱gä hi̱nte dí xi'i ngue høndi̱ nyoto nni̱di̱ ja ngue guí pu̱nnbi̱. Sinoque dí xi'i nja mmi̱ndi̱ guí pu̱nnbi̱, yoto yø hya̱te ma̱'dɛt'a nni̱di̱ ja ngue guí pu̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ja̱na̱ngue jatho gui pu̱nnba̱bi̱ ni̱ mmi̱c'ɛ̱i̱hʉ, porque nu̱na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱, ma̱hyɛjpi n'na ra̱ da̱st'abi ngue ørpa̱ ra̱ güɛnda yø hmi̱qui̱ hangu̱ tu̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mi̱ dʉ'mi̱ bi 'yørpa̱ ra̱ güɛnda yø hmi̱qui̱, bá̱ ts'innba̱bi̱ n'na nc'ɛ̱i̱ ngue yø mi̱yonetho rá̱ mɛ̱nyu̱ mi̱ tu̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pɛ nu̱na̱ ra̱ hmi̱qui̱ bá̱ ts'i, hi̱n'yʉ ra̱ mɛ̱nyu̱ di gu̱trá̱ güɛnda. Ra̱ da̱st'abi p'ʉya bi̱ ma̱nda ngue da̱ bä ra̱ hmi̱qui̱, 'nɛ̱ da̱ bäprá̱ xisu, 'nɛ̱ da̱ bäpyø ba̱si̱, 'nɛ̱ da̱ bäpi hangu̱ pɛts'i ngue di̱ gu̱trá̱ güɛnda. ");
INSERT INTO otnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pɛ ra̱ hmi̱qui̱ p'ʉya bi̱ nda̱ntyøhmu̱ p'ʉ 'bährá̱ hmu̱. Bi 'yäpra̱ ma̱te, bi 'yɛ̱mbi̱: “Ague grá̱ hmu̱, da̱mi̱ tøgba̱gui̱ ts'ʉ mɛ̱nte ga̱ ti̱ngä ni̱ mɛ̱nyu̱ ga̱ ju̱t'a̱'i̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nu̱'a̱ ra̱ hmu̱ p'ʉya bi huɛ̱crá̱ hmi̱qui̱, bi pu̱nnba̱bi̱ rá̱ güɛnda mi̱ tu̱pi̱. Bi thøgue. ");
INSERT INTO otnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pɛ nu̱na̱ ra̱ hmi̱qui̱ bi̱ ma ma̱pu̱nnbi̱ rá̱ güɛnda, høntho bi̱ ma ma̱thøgue, bi̱ nthɛui ma̱n'na nc'ɛ̱i̱ ngue mi̱ tu̱pi̱ zits'ʉ rá̱ mɛ̱nyu̱. Bi bɛnnbʉya bi dorpa̱ rá̱ 'yʉga. Bi 'yɛ̱mbi̱: “Gui ju̱rca̱gui̱ ma̱ mɛ̱nyu̱ guí tu̱qui̱, uague hi̱n'na̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nu̱'a̱ ra̱ n'yohʉ mi̱ ndu̱pa̱te zits'ʉ ra̱ mɛ̱nyu̱ p'ʉya, bi̱ nda̱ntyøhmu̱ p'ʉ 'bä'a̱ tu̱pi̱, bi 'yäpra̱ ma̱te, bi 'yɛ̱mbi̱: “Da̱mi̱ tøgba̱gui̱ ts'ʉ mɛ̱nte ga̱ ti̱ngä ni̱ mɛ̱nyu̱, ga̱ ju̱t'a̱'i̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pɛ nu̱'a̱ ra̱ n'yohʉ mi̱ thu̱prá̱ mɛ̱nyu̱ p'ʉya, hi̱mbi̱ ne xta̱ ndø'ma̱ tu̱pi̱. Sinoque bi bɛnt'i̱, bi zixa̱ fädi asta̱ gue'mø di japi da̱ gu̱trá̱ mɛ̱nyu̱ tu̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mi̱ nu̱ mi̱'da yø hmi̱qui̱'a̱ te bi 'yørbʉya, bi där'ma̱n'ʉ yø mmʉi'a̱ te bi japrá̱ mmi̱c'ɛ̱i̱ui. Bi̱ ma'ʉ p'ʉya bá̱ xiprá̱ hmu̱ te bi 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nu̱na̱ ra̱ hmu̱ p'ʉya, bi̱ ma̱nda bá̱ ts'ofo ma̱høn'a̱, bi 'yɛ̱mbi̱: “Grá̱ ts'oc'ɛ̱i̱ n'yø. Conque nu̱ hangu̱ ma̱ mɛ̱nyu̱ gmi̱ tu̱qui̱, gä dá̱ pu̱n'na̱'i̱ ngue gá̱ 'yäcra̱ ma̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ua̱ngui̱ xta̱ nzä xqui pu̱nnba̱bi̱ ni̱ amigo mi̱ tu̱'i̱ tengu̱tho dá̱ pu̱n'na̱'i̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nu̱'a̱ ra̱ hmu̱, ja̱njua̱ni̱ ngue mbøcuɛ. Bi̱ ma̱nda p'ʉya ngue bi ts'ixa̱ fädi rá̱ hmi̱qui̱ asta̱ gue'mø da̱ gu̱trá̱ mɛ̱nyu̱ tu̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Di ja'a̱hʉ p'ʉ ma̱ Papágä bí 'bʉ ma̱hɛ̱ts'i̱ ya, hi̱ndi̱ pu̱n'na̱hʉ, ngue'mø hi̱nni̱ mmʉi gdi pu̱nnba̱bi̱ te øt'a̱ ni̱ cu̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ra̱ Jesús mi̱ juadi bi̱ ma̱nya yø hya̱ ya, nu̱p'ʉ Galilea mi̱ 'yo, bi̱ ma ma̱n'na nguadi ra̱ da̱the Jordán, i̱ mpa p'ʉ ja ra̱ häi Judea. ");
INSERT INTO otnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pɛ xa̱ndøngu̱ yø ja̱'i̱ bi dɛnni̱. Nu̱p'ʉ bi zøni̱, bi 'yøthe yø ja̱'i̱ ma̱di hyɛ̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bi guat'i'da yø fariseo p'ʉ 'bʉhra̱ Jesús, porque honnbi̱ ha di zʉdi ngue hi̱nda̱ gue'a̱ ra̱ hya̱ da̱ ma̱. Bi 'yɛ̱mbi̱: ―¿Ua ja ra̱ nt'ɛ̱di̱ ngue di̱ nxu̱mmi̱ rá̱ xisu n'na ra̱ n'yohʉ hønt'a̱ bi zä ma̱ hya̱ di ʉpi, uague hi̱n'na̱? ");
INSERT INTO otnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua hi̱n ga̱di xähmʉ'a̱ te ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, ngue nu̱'mø ma̱mbá̱ nhohra̱ xi̱mhäi, Oja̱ bi hocra̱ n'yohʉ 'nɛ̱ bi hocra̱ xisu? ");
INSERT INTO otnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Oja̱ bi 'yɛ̱na̱: “Ja̱na̱ngue ra̱ n'yohʉ sop'ʉ rá̱ papá, sop'ʉ rá̱ mamá ngue 'bʉhmi̱ rá̱ xisu. Nu̱ya yo nc'ɛ̱i̱ ya, di̱ nne n'na ngu̱ n'na, ja̱na̱ngue ya hi̱ngui̱ yo nc'ɛ̱i̱, sinoque ɛ̱ntho n'na nc'ɛ̱i̱tho”. ");
INSERT INTO otnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ja̱na̱ngue nu̱yá, nu̱ya yo nc'ɛ̱i̱ bi pɛn'na̱ Oja̱, hi̱n'yʉ ra̱ nt'ɛ̱di̱ ngue to di xu̱nnba̱bi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yø fariseo p'ʉya bi 'yɛ̱mbi̱: ―¿Pɛ hanja na̱ ra̱ Moisés ngue bi 'yɛ̱mbi̱ i sä da̱ 'yøtra̱ sʉcua̱ ra̱ n'yohʉ ngue di̱ nxu̱mmi̱ rá̱ xisu 'mø? ");
INSERT INTO otnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ Moisés bi u̱nna̱ nt'ɛ̱di̱ ngue da̱ nangra̱ sʉcua̱ ngue ra̱ nxu̱ni̱, pɛ ngue ma̱ndø nna̱xi̱tho yø n'yomfɛ̱ni̱ yø ja̱'i̱, ja̱na̱ngue bi̱ njap'ʉ. Pɛ nu̱p'ʉ rá̱ mʉdi, hi̱nga̱ ngu̱'a̱ ra̱ hya̱ bá̱ sännba̱ Oja̱ da̱ 'yøtyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pɛ nu̱gä dí xi'a̱hʉ, ngue yø n'yohʉ di̱ nxu̱mmi̱ yø xisu 'nɛ̱ hi̱ngra̱ n'yots'om'mäi di ʉpi, nu̱'mø hømbi̱ ntha̱tra̱ n'yohʉ, da̱ mɛ ma̱n'na ra̱ xisu, ya ra̱ ts'oqui øtra̱ n'yohʉ. A nu̱'mø bi̱ ntha̱tra̱ xisu bi t'ɛi, ya ra̱ ts'oqui øt'ui ra̱ n'yohʉ bi̱ mɛ. ");
INSERT INTO otnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nu̱'ʉ yø xädi p'ʉya bi 'yɛ̱mbi̱: ―Ma̱n'na xa̱nho ngue hi̱ndi̱ ntha̱tra̱ ja̱'i̱ 'mø ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pɛ ra̱ Jesús ma̱hømbi 'yɛ̱na̱: ―Nu̱na̱ ra̱ hya̱ dí̱ mma̱, hi̱ngui̱ nne da̱ ma̱ ngue da̱ gätho yø ja̱'i̱ di ja ngue di̱ ntha̱ti̱. Sinoque nu̱ya yø ja̱'i̱, Oja̱ nnepe ngue di̱ ntha̱ti̱, guehya dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","I 'bʉhyø n'yohʉ ngue hi̱ngui̱ sä di̱ ntha̱ti̱. Porque 'bʉhyø n'yohʉ ya i̱ mi̱'a̱ ngue hi̱nda̱ zä di̱ m'mʉhrá̱ xisu. Xi̱mmi̱ 'bʉhyø n'yohʉ ngue m'moqui. Xi̱mmi̱ 'bʉhyø n'yohʉ hi̱ndi̱ ntha̱ti̱ para ngue da̱ zäp'ʉ da̱ 'yørpe xa̱nho rá̱ 'bɛfi Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. Pɛ nu̱ to ɛ̱na̱ ngue da̱ zä di̱ ntha̱ti̱, ya da̱ 'yøt'e tengu̱tho ra̱ hya̱ dí̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bi zixyø ba̱si̱ yø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús, i̱ nnepyø ja̱'i̱ ngue da̱ dospa̱ yø ya̱ yø ba̱si̱ 'nɛ̱ da̱ xi Oja̱ ngue di ja̱pyø ba̱si̱. Pɛ nu̱ya yø xädi ra̱ Jesús bi hɛjpa̱ yø ja̱'i̱ ba̱ zi yø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ra̱ Jesús, bi 'yɛ̱mbyø xädi: ―Da̱mi̱ hyɛhmʉ yø ba̱si̱ da̱ thocua dí 'bʉi. Porque tengu̱tho yø ja̱'i̱ ya o rá̱ 'yɛ Oja̱, xquet'a̱ njarbʉ ya yø ba̱si̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ra̱ Jesús bi japyø 'yɛ p'ʉ ja yø ya̱ yø ba̱si̱. M'mɛfa p'ʉya, bi̱ map'ʉ ja ra̱ xɛqui mi̱ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","N'na ra̱ n'yohʉ bi guarbʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ hoga̱ xännba̱te, ¿ndana̱ ra̱ nho ɛxa̱ ja ts'ɛdi ga̱ øt'e n'namhma̱ ngue Oja̱ di 'dacra̱ 'da'yo te para za̱ntho? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua guí pa̱di̱ te guí̱ mma̱nya, ngue guí ɛ̱ngui̱ xa̱nhogä? Porque hønsɛ Oja̱ xa̱nho. Nu̱'mø guí̱ nne ya ngue di 'da'i ra̱ 'da'yo te Oja̱, da̱mi̱ 'yøt'ʉ yø hya̱ di̱ ma̱nda Oja̱ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ra̱ n'yohʉ p'ʉya bi 'yɛ̱na̱: ―Xi'ʉ yø hya̱ di̱ ma̱nda Oja̱ p'ʉya, ¿ndana̱ gue'a̱ ya yø hya̱ guí̱ mma̱? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―'Yo grá̱ hyote. 'Yo grá̱ 'yots'om'mäi. 'Yo grá̱ bɛ̱. 'Yo to guí sännba̱ ra̱ fɛhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Da̱mi̱ su̱ ni̱ papá, da̱mi̱ su̱ ni̱ mamá. Da̱mi̱ ma̱hni̱ mmi̱c'ɛ̱i̱ui tengu̱tho gni̱ ne ngue di̱ ma ma̱ ma̱di̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mi̱ da̱hra̱ n'yohʉ p'ʉya, bi 'yɛ̱na̱: ―Nu̱ya yø hya̱ guí xicya, ya gä xtá̱ øt'e asta̱ gue'mø ma̱rá̱ ngüɛgui. Xiya, ¿ndana̱ guehna̱ ra̱ hya̱ di 'bɛdi ngue hi̱ndí̱ øtya? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Pɛ ra̱ Jesús bi 'yɛ̱mbra̱ n'yohʉ ya̱ui: ―Nu̱'mø guí̱ nne ngue gätho gui 'yøt'a̱ te ni̱ 'yu̱p'ʉ gui 'yøt'e, ni̱ ma ya, da̱mi̱ pä te gä guí pɛts'i. Da̱mi̱ u̱nna̱ mɛ̱nyu̱ yø hyoya. Nu̱'mø gá̱ 'yøt'e te dí xi'i ya, ya bí ja ni̱ mmɛti ma̱hɛ̱ts'i̱ p'ʉya. Bá̱ ɛ̱p'ʉ ya, ga̱ mmɛp'ʉ nná̱ magä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pɛ mi̱ 'yøhra̱ n'yohʉ na̱ ra̱ hya̱ bi sifi, ma̱mbi du̱drá̱ mmʉi. Bi̱ matho, porque ma̱rá̱ ndømmɛ̱mmɛti. ");
INSERT INTO otnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Nu̱ yø mmɛ̱mmɛti, guehya dí̱ mma̱ ngue xa̱nhɛ̱nni̱tho ha di̱ n'u̱ni̱ da̱ zo rá̱ 'yɛ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ya fa̱di̱ ngue ra̱ cameyo, hi̱nja̱m'mø da̱ zä da̱ thop'ʉ ja rá̱ xa̱gu̱ n'na ra̱ 'yofani̱. Pɛ dí xi'a̱hʉ ngue ma̱n'na xa̱ndøn hɛ̱nni̱tho ngue n'na ra̱ mmɛ̱mmɛti di̱ n'u̱ni̱ da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús mi̱ 'yøhyø xädi, ma̱n'natho bi̱ nsu̱ yø n'yomfɛ̱ni̱ p'ʉya. Di̱ n'yɛ̱mbi̱: ―Rá̱ nzɛgui ya hi̱njonni̱ ja̱'i̱ da̱ zä di̱ nya̱nná̱ te ya'mø ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bi hyɛ̱tyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'a̱ ngue yø ja̱'i̱tho, hi̱nda̱ zä da̱ zänsɛ ha di̱ nya̱nyø te. Pɛ Oja̱ hi̱nte hɛ̱mbi̱, nu̱ te nne da̱ 'yøt'e, da̱ zä ha di japi. ");
INSERT INTO otnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nu̱na̱ ra̱ Bɛdu bi 'yɛ̱mbra̱ Jesús: ―Nu̱gähe, ya xtá̱ sohme p'ʉ te gä dí pɛshe ngue dí tɛn'na̱he. ¿Te 'bɛ'a̱ ja ngue di tocagähe 'mø? ");
INSERT INTO otnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱'mø ra̱ pa da̱ni̱ gom'na'yo gätho yø cosa i ja, gue'a̱ ra̱ pa'a̱ ngue ra̱ N'yohʉ dí 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ mi̱p'ʉ ja rá̱ nthu̱ts'i̱, di̱ ma̱nda te di̱ nja. A nu̱'a̱hʉ p'ʉya ngue guí tɛnnga̱hʉ, nu̱p'ʉ ha di hø'i 'dɛ'ma̱ yoho yø nthu̱ts'i̱, ja gui̱ mmi̱hmʉ p'ʉ ngue gui̱ nts'ʉt'abihʉ p'ʉ ha di 'bʉ'ʉ 'dɛ'ma̱yo 'bʉi yø mbom'mɛto ra̱ Israel. ");
INSERT INTO otnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nu̱ to gä xpá̱ nzohyø ngu̱, xpá̱ nzohyø cu̱, xpá̱ nzohyø papá, xpá̱ nzohyø mamá, xpá̱ nzohyø xisu, xpá̱ nzohyø ba̱si̱, xpá̱ nzohyø häi ngue tɛnngui̱, pɛ yø ciento nni̱di̱tho gá̱ ngu̱'a̱ te da̱ di̱ni̱ ngue'a̱ te gä xpá̱ nzogui. Ra̱ pa di 'yɛ̱p'ʉ p'ʉya, di t'u̱nna̱ te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Xa̱ngu̱ yø ja̱'i̱ hnu̱ ma̱nsu̱ ua, pɛ nu̱'a̱ ra̱ pa'a̱, ts'ʉtho da̱ hnu̱ ma̱nsu̱ p'ʉ. Xa̱ngu̱ yø ja̱'i̱ hi̱ngui̱ hnu̱ ma̱nsu̱ ua, pɛ nu̱'a̱ ra̱ pa'a̱, ja da̱ni̱ hnu̱ ma̱nsu̱ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nu̱na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ da̱ gu̱tra̱ nzäbi. Tengu̱tho n'na ra̱ n'yohʉ bi̱ ma mxu̱di̱tho ngue da̱ honyø mɛfi da̱ tʉcyø uva. ");
INSERT INTO otnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bi gohmi̱ ra̱ cohi yø mɛfi ngue nu̱'a̱ n'na pa ra̱ 'bɛfi, da̱ gu̱t'i co n'na ra̱ mɛ̱nyu̱ ni̱ hu̱ ngue ra̱ denario. Bi̱ mɛnhyø mɛfi p'ʉ bí ja rá̱ hua̱hi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mi̱ zʉ'i gʉto xu̱di̱ p'ʉya, ma̱hømbi̱ ma täi ra̱ mmɛ̱hui̱. Bi di̱mp'ʉ ja ra̱ täi mi̱'da yø ja̱'i̱ ngue hi̱nte pɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Bi 'yɛ̱mbʉya: “Ni̱ mɛ ra̱ 'bɛfi ma̱ hua̱hi̱gä n'yø. Ga̱ ju̱t'a̱ui'a̱ te ni̱ 'yu̱p'ʉ guí ta̱hmi̱”, bi 'yɛ̱mbi̱. Nu̱'ʉ bi si ra̱ 'bɛfi p'ʉya, bi̱ ma ra̱ 'bɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mi̱ hyu̱xyadi p'ʉya, ma̱hømbi̱ ma täi ra̱ mmɛ̱hui̱. Bi̱ nthɛui p'ʉ mi̱'da yø ja̱'i̱ ngue hi̱nte pɛfi. Ma̱hømbi 'yɛtra̱ 'bɛfi rá̱ hua̱hi̱. Mi̱ zʉ'i hyu̱ nde, ma̱hømbi̱ ma täi ra̱ mmɛ̱hui̱. Bi̱ nthɛui mi̱'da yø ja̱'i̱ ngue hi̱nte pɛfi. Ma̱hømbi 'yɛtra̱ 'bɛfi rá̱ hua̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mi̱ zʉ'i cʉt'a nde, ma̱hømbi̱ ma täi ra̱ mmɛ̱hui̱. Hømbi̱ nthɛui mi̱'da yø ja̱'i̱ ngue hi̱nte pɛfi. Bi 'yɛ̱mbʉya: “¿Hanja ngue xcá̱ ndethohʉ ua n'yø, hi̱nxcá̱ mpɛhmʉ?” bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bi 'yɛ̱n'ʉ zo p'ʉya: “Xtá̱ ndedähe ua ngue hi̱njon xa̱ xicje ra̱ 'bɛfi”, bi 'yɛ̱mbi̱. Ra̱ mmɛ̱hui̱ p'ʉya bi 'yɛ̱mbi̱: “Ni̱ mɛ ra̱ 'bɛfi ma̱ hua̱hi̱gä 'mø. Ga̱ ju̱t'a̱ui'a̱ te ni̱ 'yu̱p'ʉ guí ta̱hmi̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mi̱ dähra̱ nde p'ʉya, nu̱na̱ ra̱ mmɛ̱hui̱ bi xihrá̱ hmi̱qui̱ nu̱na̱ di̱ ma̱ndabi yø mɛfi, bi 'yɛ̱mbi̱: “Da̱mi̱ zonhyø mɛfi ya, gui ju̱tyø nzäbi. Rá̱ mʉdi gui u̱nyø nzäbi'ʉ yø mɛfi rá̱ nzɛguitho xa̱ nzømp'ʉ ja ra̱ 'bɛfi. A nu̱'ʉ xa̱ mpɛfi gä ra̱ pa, rá̱ nzɛguitho gui u̱nyø nzäbi'ʉ”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mi̱ nju̱tyø nzäbi ya yø hmi̱qui̱ xi yʉtra̱ 'bɛfi cʉt'a nde. Bi̱ juarpa̱ yø pa, bi u̱nni̱ 'da'a̱ n'na ra̱ mɛ̱nyu̱ ngue ra̱ denario. ");
INSERT INTO otnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mi̱ tocabi bi t'u̱nyø nzäbi ya yø hmi̱qui̱ xi̱nde ra̱ 'bɛfi p'ʉya. Bi 'yɛ̱na̱ ngue ma̱n'na xa̱ngu̱ yø nzäbi xti t'u̱nni̱ porque xi̱ mpɛfi gä ra̱ pa. Pɛ mi̱ t'u̱nyø nzäbi, hønda̱ n'na ra̱ mɛ̱nyu̱ ngue ra̱ denario bi t'u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mi̱ hyanyø nzäbi p'ʉya, bi zʉhra̱ mmɛ̱hui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bi 'yɛ̱mbi̱: “Nu̱ya yø n'yohʉ 'bʉcua, rá̱ nzɛguitho bi zømp'ʉ ja ra̱ 'bɛfi ya. Conque n'na oratho bi̱ mpɛfi, ¿hanja ngue 'da'igu̱ gá̱ ju̱rca̱he? Nu̱gähe p'ʉya xtá̱ sägähe ra̱ n'ʉ gä ra̱ pa ngue xa̱ mpa ra̱ hya̱di”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nu̱'a̱ ra̱ mmɛ̱hui̱ p'ʉya bi 'yɛ̱mbrá̱ hmi̱qui̱ nya̱ui: “Ague n'yø, nu̱gä hi̱ngra̱ nts'oc'ɛ̱i̱ dí øt'a̱hʉ. Ua̱ngui̱ xtá̱ nya̱hʉ ngue nu̱'a̱ n'na pa ra̱ 'bɛfi, ga̱ ju̱t'aui co n'na ra̱ mɛ̱nyu̱ ngue ra̱ denario. ");
INSERT INTO otnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Da̱mi̱ hyanni̱ nzäbi'a̱ n'na zi pa xca̱ mpɛfi, ni̱ ma p'ʉya. Nu̱na̱ ma̱ mɛfi rá̱ nzɛguitho xa̱ nyʉtra̱ 'bɛfi, dí̱ nne ga̱ ju̱t'i̱ tengu̱tho dá̱ ju̱t'a̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ua ga̱di̱ ma̱ndagui̱? ¿Ua hi̱n'yʉ ra̱ nt'ɛ̱di̱ ngue ga̱ sänsɛ te dí̱ nne ga̱ ørpa̱bi̱ ma̱ mɛ̱nyu̱? ¿Ua gue ga̱di sɛyabi ni̱ mmi̱c'ɛ̱i̱ui ngue'a̱ ra̱ nho dí̱ nne ga̱ ørpe?” bi 'yɛ̱nna̱ mmɛ̱hui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ja̱na̱ngue nu̱yá, nu̱ya yø mɛfi rá̱ nzɛgui xa̱ nyʉtra̱ 'bɛfi ya, guehya rá̱ mʉdi di t'u̱nyø nzäbi ya. A nu̱ya yø mɛ̱fi rá̱ mʉdi xa̱ nyʉtra̱ 'bɛfi, guehya rá̱ nzɛguitho di t'u̱nyø nzäbi ya. Ma̱ndøngu̱ dyø ja̱'i̱ bi ts'ofo, pɛ ziyohotho yø ja̱'i̱ bi thanhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ra̱ Jesús ni̱ hya̱ ra̱ 'yu̱ ngue ni̱ ma Jerusalén, pɛ bi zica̱ n'nanni̱'ʉ 'dɛ'ma̱ yoho yø xädi, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―A nu̱yá, ya nná̱ mähä Jerusalén. Nu̱na̱ ra̱ hni̱ni̱ na̱, nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ di̱ ndäpyø hmu̱ yø mmäcja̱ conyø xännba̱te ngue ra̱ ley. Nu̱ya p'ʉya, guehya da̱ zännbi̱ ngue da̱ du̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Di däpyø ja̱'i̱ hi̱ngyø judío. Da̱ denni̱, di ʉni̱, 'nɛ̱ di cuatra̱ pont'i̱ ngue da̱ hyo. Pɛ rá̱ hyu̱ pa di bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nu̱na̱ ra̱ Jacobo 'nɛ̱hra̱ Xuua, guehya yø ts'ʉnt'ʉ ra̱ Zebedeo ya, 'dap'ʉ 'youi rá̱ mamá, bi guarbʉ 'bähra̱ Jesús. Bi nda̱ntyøhmu̱ na̱ ra̱ xisu, bi xifi ngue da̱ 'yørpa̱ ra̱ ma̱te na̱ ra̱ hya̱ nne da̱ xifi. ");
INSERT INTO otnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Tema̱ ma̱te guí̱ nne ga̱ øt'a̱'i̱? ―bi 'yɛ̱mbi̱. Ra̱ xisu p'ʉya bi 'yɛ̱mbra̱ Jesús: ―Dí̱ nne ngue nu̱p'ʉ ha gui̱ mmi̱ ngue gui̱ nda̱st'abi, guí u̱nna̱ nt'ɛ̱di̱ ya yoho ma̱ ts'ʉnt'ʉ 'bʉcua, ngue n'na di̱ mi̱hni̱ n'yɛi, n'na di̱ mi̱hni̱ ga̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pɛ mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ts'ʉnt'ʉ: ―Ague n'yø, hi̱ngui̱ pa̱di̱ te rá̱ nsäui na̱ ra̱ hya̱ guí ähmi̱. ¿Ua da̱ zä gui thohmi̱'a̱ ra̱ n'ʉ ja ngue ga̱ thocä? Porque nu̱gä ma̱thoguitho ja ngue di ʉngä yø ja̱'i̱ ―bi 'yɛ̱mbi̱. Bi 'yɛ̱nyø ts'ʉnt'ʉ p'ʉya: ―A̱há̱, da̱ zä ga̱ sägä'be ra̱ n'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue ngu̱'a̱, xa̱ndøngu̱ ra̱ n'ʉ ja ngue gui säui, tengu̱tho ra̱ n'ʉ ja ngue ga̱ thocä. Ma̱thoguitho di ʉn'a̱ui yø ja̱'i̱ tengu̱tho ja ngue dí ʉngä yø ja̱'i̱. Pɛ nu̱na̱ ra̱ hya̱ guí̱ mma̱mmi̱, hi̱ndi̱ tocagui̱ ngue go ga̱ sänni̱ to di̱ mi̱p'ʉ ja ma̱ n'yɛi, ogue to di̱ mi̱p'ʉ ja ma̱ ga̱ha̱. Ma̱ Papá'a̱ ya xa̱ nzänni̱ to di̱ mi̱ n'na ngu̱ n'na ma̱ hyo. ");
INSERT INTO otnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu̱na̱ ra̱ hya̱ ähya yo nc'ɛ̱i̱ di̱ n'yohʉ, bi̱ mbøcuɛ 'mø mi̱ ba̱hya mi̱ 'dɛt'a yø xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pɛ ra̱ Jesús bi pɛti gätho yø xädi, bi 'yɛ̱mbi̱: ―Ya guí pa̱hmʉ ngue yø da̱st'abi xa̱ t'ɛ̱ts'i̱, co gätho mi̱'da yø ts'ʉt'abi 'bʉp'ʉ ja yø hni̱ni̱, gä di̱ ma̱nda yø ja̱'i̱. Nu̱ te di̱ ma̱nda yø ts'ʉt'abi ngue da̱ 'yøtyø ja̱'i̱, gue'a̱ øt'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pɛ nu̱'a̱hʉ, 'yo guí̱ nne ngue guí̱ ma̱ndathohʉ yø ja̱'i̱. Nu̱ ra̱ ja̱'i̱ nne ngue xtá̱ nhɛ̱ts'i̱ rá̱ cargo da̱ mɛfi, guehna̱ ra̱ ja̱'i̱ jatho ngue di̱ mpɛfi da̱ mäxyø mmi̱c'ɛ̱i̱ui na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A nu̱'a̱hʉ ya, nu̱'a̱ da̱ ne di̱ m'mɛt'o ngue gätho yø amigo ya, guehna̱ jatho da̱ gohi ngue ni̱ mɛfihʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Conque ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, hi̱mbi 'yɛ̱hɛ̱ ngue n'narbʉ da̱ mi̱ di̱ ma̱ndatho. Sinoque bi 'yɛ̱hɛ̱ ngue di̱ mpɛfi da̱ mäxyø ja̱'i̱. 'Nɛ̱ hi̱nga̱ høndra̱ 'bäxte da̱ 'yøt'e, asta̱ da̱ du̱ ngue da̱ ya̱ni̱ xa̱ndøngu̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mi̱ bømp'ʉ ja ra̱ hni̱ni̱ Jericó ra̱ Jesús, bi̱ ntɛt'i xa̱ndøngu̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nu̱p'ʉ ja ra̱ 'yu̱ i̱ nthogui, mi̱ hu̱p'ʉ yoho yø xädä. Mi̱ ba̱hyø xädä ngue guehna̱ ra̱ Jesús ja ngue da̱ thop'ʉ hu̱di̱. Bi̱ mʉhra̱ hmafi p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, rá̱ mbom'mɛto'i ra̱ David, da̱mi̱ huɛ̱ga̱'be ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A nu̱'ʉ yø ja̱'i̱ mi̱ 'bʉp'ʉ hu̱hyø xädä, di hɛjpi ngue hi̱ndi̱ mmafi. Pɛ yø xädä p'ʉya, ɛ̱na̱ ma̱n'na ma̱'bɛpi ngue nts'ɛdi ga̱ mafi, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, rá̱ mbom'mɛto'i ra̱ David, da̱mi̱ huɛ̱ga̱'be. ");
INSERT INTO otnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ra̱ Jesús bi̱ m'mäi ngue øde hmat'i. Bi zonhyø xädä p'ʉya, bi 'yɛ̱mbi̱: ―¿Te guí̱ nne ngue di̱ nja'a̱ui? ");
INSERT INTO otnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yø xädä p'ʉya bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, dí̱ nne ngue di̱ nzø ma̱ dä'be. ");
INSERT INTO otnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bi huɛ̱cyø xädä na̱ ra̱ Jesús. Bi dospa̱bi̱ yø dä, pɛ 'bexpi̱ nzø yø dä. Ja̱na̱ngue bi̱ mähä ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nu̱'mø ya ni̱ ma da̱ zømp'ʉ ja ra̱ hni̱ni̱ Jerusalén, ya 'yop'ʉ ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos. Ja jarbʉtho ra̱ hni̱ni̱ Betfagé. Ra̱ Jesús bi 'yɛt'i yoho yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Bi 'yɛ̱mbi̱: ―Ni̱ mɛ nʉ ja ra̱ hni̱ni̱ bí ja nʉ. Nu̱'mø gá̱ cʉt'ui ra̱ hni̱ni̱, gui ti̱mmi̱ p'ʉ da̱ ntha̱t'i̱ n'na ra̱ burru, n'youi rá̱ ba̱si̱. Bá̱ xoqui ngue guá̱ siui ua. ");
INSERT INTO otnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu̱'mø to di hɛc'a̱ui ngue gui xocui ra̱ burru, gui xihmi̱ ngue honna̱ Hmu̱. Pɛ da̱mi̱ xihmi̱ ngue hi̱nda̱ ya'atho di̱ ndäpi. ");
INSERT INTO otnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ngu̱na̱ bi 'yøt'e para ngue di̱ nja na̱ te ra̱ hya̱ bi̱ ma̱nná̱ pønga̱hya̱ Oja̱ ngue bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Da̱mi̱ xihmʉ yø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Sión, gui 'yɛ̱mphʉ: Nu̱ua guí 'bʉhmʉ, ya bá̱ ɛ̱p'ʉ ni̱ nda̱st'abihʉ da̱ zøcua. Pɛ hi̱ngra̱ tu̱nhni̱ ga̱ 'yo ni̱ da̱st'abihʉ, bá̱ hu̱xa̱ n'na ra̱ burru ngue rá̱ ba̱si̱ n'na ra̱ mbo'øni̱ ngue ra̱ ndu̱, gui 'yɛ̱mphʉ”. ");
INSERT INTO otnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nu̱ya yoho yø xädi ra̱ Jesús bi̱ map'ʉ bi 'yɛt'i ngue bá̱ si ra̱ burru, bá̱ n'youi rá̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mi̱ zøp'ʉ 'bʉhra̱ Jesús, yø tu̱hu̱ yø ja̱'i̱ bi ga̱spa̱ yø burru ngue bi̱ nøpa̱ nts'ʉt'i. Bi hyu̱xra̱ burru ra̱ Jesús, bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Xa̱ngu̱ yø ja̱'i̱ di tʉns'yø tu̱hu̱ ngue pøp'ʉ ja ra̱ 'yu̱ ja ngue da̱ thohra̱ Jesús. Mi̱'da yø ja̱'i̱ p'ʉya, bi sa̱jpa̱ yø xi yø palma ngue pøp'ʉ ja ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","O ma̱de p'ʉ ni̱ ma yø ja̱'i̱ ra̱ Jesús. I 'bɛt'o 'da, bá̱ 'bɛfa 'da. Pɛ yø ja̱'i̱ 'da ga̱ matho ngue di johya, i ɛ̱na̱: ―Nu̱na̱ Oja̱, di ja̱phna̱ rá̱ m'mɛnhni̱ 'bʉcua, guehna̱ ta̱te na̱ya. Guehna̱ rá̱ mbom'mɛto ra̱ David. Oja̱ di ja̱pi̱. Ma̱guesɛ na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nu̱na̱ ra̱ Jesús mi̱ yʉrbʉ ja ra̱ hni̱ni̱ Jerusalén. Gä bá̱ yʉns'yø ja̱'i̱ ngue bi̱ nu̱. Di 'yɛ̱mbyø ja̱'i̱: ―¿Te'o ni̱ n'yohʉ na̱ n'yø? ");
INSERT INTO otnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mi̱'da yø ja̱'i̱ p'ʉya bi 'yɛ̱na̱: ―Nu̱ná̱ ya, guehna̱ ra̱ Jesús, rá̱ pønga̱hya̱ Oja̱ na̱, guehna̱ ra̱ mmɛ̱ngu̱ Nazaret ja ra̱ häi Galilea na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nu̱na̱ ra̱ Jesús bi̱ map'ʉ ja rá̱ ni̱ja̱ Oja̱. Nu̱'ʉ yø ja̱'i̱ mi̱ mpäp'ʉ thi̱nni̱ja̱, da̱ gue'ʉ ma̱di̱ ntäi, gä bi 'yɛt'i. Nu̱ya yø ja̱'i̱ di pøspa̱ yø mɛ̱nyu̱ yø ja̱'i̱ yap'ʉ ni̱ 'yɛ̱hɛ̱, bi 'yennba̱ yø mɛ̱xa. 'Nɛ̱ bi 'yennba̱ yø nthu̱ts'i̱'ʉ pä yø paloma. ");
INSERT INTO otnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱p'ʉ ja ra̱ Ma̱ca̱ Libro, nt'ot'i p'ʉ ra̱ hya̱ ngue ɛ̱n'Oja̱: “Nu̱na̱ ma̱ ngu̱ngä, ni̱ hu̱ ngue ra̱ ngu̱nga̱ mhmat'Oja̱ na̱”. Pɛ nu̱'a̱hʉ, guí øthʉ ngue ja di̱ mpɛti ua yø bɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nu̱p'ʉ ja ra̱ ni̱ja̱, bi guatyø xädä 'nɛ̱hyø dogua p'ʉ 'bähra̱ Jesús ngue bi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pɛ yø hmu̱ yø mmäcja̱ conyø xännba̱te ngue ra̱ ley, mi̱ nu̱ yø milagro øtra̱ Jesús, 'nɛ̱ bi 'yøde te mma̱nyø ba̱si̱ p'ʉ ja ra̱ ni̱ja̱, ngue ɛ̱nyø ba̱si̱: “Nu̱na̱ rá̱ mbom'mɛto ra̱ David i ta̱te na̱”, ɛ̱nyø ba̱si̱. Ja̱na̱ngue bi̱ mbøcuɛ. ");
INSERT INTO otnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bi 'yɛ̱mbra̱ Jesús: ―¿Ua hi̱nguí̱ øde te mma̱nyø ba̱si̱? Da̱mi̱ hɛjpi. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―A̱há̱, dí øde. Pɛ, ua hi̱n ga̱di xähmʉ'ʉ yø hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, ua̱ngui̱ ja nt'ot'i p'ʉ te øtyø ba̱si̱ ya, ngue ɛ̱na̱: “Nu̱ yø t'ʉba̱si̱, da̱gue'ʉ sʉtho, gá̱ japi ngue da̱ 'yɛ̱ts'a̱'i̱”, ua̱ngui̱ ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bi zop'ʉ yø ja̱'i̱ p'ʉya, i̱ map'ʉ ja ra̱ hni̱ni̱ Betania, ja bá̱ n'oxpʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mi̱ hyaxpʉya, hømbá̱ pengui, i̱ ma Jerusalén. Nu̱p'ʉ ja ra̱ 'yu̱ p'ʉya, nu̱na̱ ra̱ Jesús bi zä ngue tu̱ ma̱nthu̱hu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bi hyanda̱ n'na nza ra̱ igo p'ʉ ja ra̱ nen'yu̱. Bi̱ ma bá̱ nu̱ 'mø ngue di zʉdi. Pɛ hi̱nte mi̱ zʉdi, sinoque høntho xi c'amyø xi. Ra̱ Jesús bi 'yɛ̱mbra̱ za: ―Ya hi̱nni̱ mantho di̱ nzʉhni̱ ndät'ä ya grá̱ za ―bi 'yɛ̱mbi̱. 'Bexpi̱ m'manhna̱ za ngue da̱ 'yot'i. ");
INSERT INTO otnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mi̱ nu̱ yø xädi ra̱ Jesús ngue ya fʉdi otra̱ za, di 'yøtho hanja. Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Hague nja ngue n'na zihmantho ya nne da̱ 'yotra̱ za? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø xädi: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, a nu̱'mø guí ɛ̱c'ɛ̱i̱hʉ xa̱nho ngue gue'a̱ nnu̱ ma̱nho Oja̱ ngue di̱ nja'a̱ te guí xihmʉ, 'nɛ̱ hi̱ngui̱ yobɛ̱ni̱ ni̱ mmʉihʉ, hi̱nga̱ hønt'a̱ te gá̱ nu̱hʉ dá̱ japä ra̱ za da̱ zä gui 'yøthʉ, sinoque da̱ zä gui 'yɛ̱mphʉ ra̱ nyu̱ni̱ ja nʉ: “Da̱mi̱ 'uegue grá̱ nyu̱ni̱, i̱ map'ʉ ja ra̱ ja̱the”, gui 'yɛ̱mphʉ. Ra̱ nyu̱ni̱ p'ʉya da̱ 'uegue, di̱ map'ʉ gui ximhmʉ ngue di̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ja̱na̱ngue nu̱'mø te guí äphʉ Oja̱, da̱mi̱ 'yɛ̱c'ɛ̱i̱hʉ ngue di 'da'a̱hʉ Oja̱ te guí äphʉ. Oja̱ p'ʉya, da̱ 'yøt'e ngue di̱ nja'a̱ te gui 'yäphʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mi̱ zømp'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús, bi xännba̱ ra̱ hya̱ yø ja̱'i̱. Mɛ̱nte xännba̱te p'ʉya, bi guatyø hmu̱ yø mmäcja̱ conyø n'yohʉ 'bɛt'o ngue yø judío, bi 'yɛ̱mbra̱ Jesús: ―Ague n'yø, ¿hanja te guí øt'e? ¿To bi 'da'i ra̱ nt'ɛ̱di̱'a̱ te guí øt'e? ");
INSERT INTO otnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱gä xquet'a̱ ga̱ øt'a̱hʉ n'na ra̱ nt'änni̱ ya. Pɛ gue gui xicjʉ hanja'a̱ ra̱ hya̱ ga̱ än'na̱hʉ, n'namhma̱ ngue xquet'a̱ ga̱ xi'a̱hʉ to bi 'dacä ra̱ nt'ɛ̱di̱'a̱ te dí øt'ä ua. ");
INSERT INTO otnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xiya, ¿te'o bi u̱nna̱ nt'ɛ̱di̱ ra̱ Xuua ngue bi xixya̱bi̱ yø ja̱'i̱? ¿Ua Oja̱ bi u̱nna̱ nt'ɛ̱di̱, uague yø ja̱'i̱tho rá̱ nt'ɛ̱di̱'a̱ te bi 'yøt'e? Yø ja̱'i̱ p'ʉya, di̱ n'yänni̱ te di da̱di̱. Di̱ n'yɛ̱mbi̱: ―¿Teni̱ 'bɛ'a̱ ga̱ xihmʉ ya 'mø? Nu̱'mø ga̱ xihmʉ ngue Oja̱ bi u̱nna̱ nt'ɛ̱di̱ te bi 'yøtra̱ Xuua, da̱ 'yɛ̱njʉ p'ʉya: “Xina̱ ra̱ hya̱ bi̱ ma̱nna̱ Xuua conná̱ ngueque, ¿hanja ngue hi̱ngá̱ 'yɛ̱c'ɛ̱i̱hʉ 'mø?” da̱ 'yɛ̱njʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A nu̱'mø ga̱ xihmʉ ngue yø ja̱'i̱tho bi u̱nna̱ nt'ɛ̱di̱ te bi 'yøtra̱ Xuua, ya nts'u̱dyø ja̱'i̱. Porque gätho yø ja̱'i̱ ɛ̱c'ɛ̱i̱ ngue rá̱ pønga̱hya̱ Oja̱ na̱ ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mi̱ da̱hyø ja̱'i̱ p'ʉya, bi 'yɛ̱mbra̱ Jesús: ―Hi̱ndí̱ pa̱cähe to bi u̱nna̱ nt'ɛ̱di̱'a̱ te bi 'yøtra̱ Xuua. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Ya hi̱ngá̱ xicjʉ na̱ ra̱ hya̱ dí än'na̱hʉ, ni̱ xi̱nga̱ guecä ga̱ xi'a̱hʉ to di 'dacra̱ nt'ɛ̱di̱ na̱ te dí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―¿Tengu̱ p'ʉ gdí̱ bɛ̱mhmʉ na̱ ra̱ hya̱ ga̱ mma̱ngä ya? N'na ra̱ n'yohʉ di si yoho yø ts'ʉnt'ʉ. Da̱ 'yɛ̱mba̱ n'na'ʉ yø ts'ʉnt'ʉ: “Ague ts'ʉnt'ʉ, ni̱ ma ra̱ 'bɛfi p'ʉ ja ma̱ hua̱hi̱gä”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nu̱'a̱ ra̱ ts'ʉnt'ʉ t'ɛtra̱ 'bɛfi, da̱ 'yɛ̱ntho: “Nu̱gä hi̱nga̱ mma”, da̱ 'yɛ̱mbrá̱ papá. Pɛ m'mɛfa p'ʉya di pährá̱ n'yomfɛ̱ni̱, da̱ ma ra̱ 'bɛfi t'ɛt'i. ");
INSERT INTO otnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nu̱'a̱ ma̱n'na rá̱ ts'ʉnt'ʉ p'ʉya hønda̱ xifi ngue da̱ ma ra̱ 'bɛfi. Nu̱na̱ ra̱ ts'ʉnt'ʉ p'ʉya di̱ n'u̱nni̱ ngue da̱ ma ra̱ 'bɛfi, da̱ 'yɛ̱mbi̱: “A̱há̱ papá, ga̱ mmagä 'mø”, da̱ 'yɛ̱mbi̱. Pɛ hi̱mma̱ jua̱ni̱ ngue da̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Xiya, ¿ndana̱ guehna̱ ya yoho yø ts'ʉnt'ʉ ngue bi 'yøt'e te di̱ ma̱nda rá̱ papá? Mi̱ da̱hyø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Gue'a̱ ra̱ ts'ʉnt'ʉ rá̱ mʉdi bi ts'ofo, bi 'yøt'e te di̱ ma̱nda rá̱ papá ―bi 'yɛ̱mbi̱. Ma̱hømbi 'yɛ̱nna̱ Jesús: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue yø ngʉthäi 'nɛ̱hyø xisu ngue yø 'yots'om'mäi, ma̱n'na m'mɛt'o da̱ zo rá̱ 'yɛ Oja̱'ʉ ngue'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porque ra̱ Xuua bi 'yøtra̱ nxixya̱, bá̱ ɛ̱hɛ̱ bi xän'na̱hʉ ra̱ 'yu̱ njua̱ntho, pɛ hi̱ngá̱ 'yɛ̱c'ɛ̱i̱hʉ te bi̱ ma̱. Pɛ nu̱ya yø ngʉthäi 'nɛ̱hyø xisu ngue yø 'yots'om'mäi, bi 'yɛ̱c'ɛ̱i̱ te bi̱ ma̱nna̱ Xuua̱. Pɛ nu̱'a̱hʉ, ma̱da̱gue'a̱ gui̱ nnu̱hʉ te øtyø ja̱'i̱ di pähyø n'yomfɛ̱ni̱ ngue hɛp'ʉ ra̱ nts'o ga̱ 'yo, pɛ hi̱ngá̱ ne xqui pähni̱ n'yomfɛ̱ni̱hʉ ngue xqui 'yɛ̱c'ɛ̱i̱hʉ te bi̱ ma̱nna̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Da̱mi̱ 'yøhmʉ ha rá̱ nja na̱ ra̱ hya̱ ga̱ hyɛcä ya. N'na ra̱ n'yohʉ bi 'yøt'a̱ n'na rá̱ nua̱'uva. Bi føt'e gä rá̱ häi. Bi hoqui hapʉ da̱ dɛ'myø uva 'mø bi̱ nja. 'Nɛ̱ bi hocra̱ n'nøque hapʉ da̱ mi̱hra̱ mähui̱. Bi hyoni̱ to da̱ gonhui rá̱ hua̱hi̱, n'namhma̱ ngue nu̱'mø bi̱ nja yø uva, di̱ t'u̱nna̱ mmɛ̱hui̱'a̱ te di tocabi. Bi̱ ma yap'ʉtho ra̱ mmɛ̱hui̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mi̱ zønna̱ pa da̱ thʉcyø uva p'ʉya, nu̱na̱ ra̱ mmɛ̱hui̱ bi̱ mɛnhyø hmi̱qui̱ ngue da̱ tu̱ yø uva di tocabi. ");
INSERT INTO otnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pɛ nu̱'ʉ yø mɛfi ma̱mbi̱ 'bʉp'ʉ bí ja rá̱ hua̱hi̱, bi bɛnnba̱bi̱ yø hmi̱qui̱ ra̱ mmɛ̱hui̱ ngue bi ʉni̱. Bá̱ ho 'da, bá̱ pʉndo 'da. ");
INSERT INTO otnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ra̱ mmɛ̱hui̱ p'ʉya ma̱n'na xa̱ngu̱ yø hmi̱qui̱ hømbi̱ mɛnnbʉ bí ja rá̱ hua̱hi̱. Pɛ nu̱'ʉ yø mɛfi ya ma̱mbi 'bʉp'ʉ ja rá̱ hua̱hi̱, ma̱hømbi ʉnyø mɛfi bi zømp'ʉ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Rá̱ nzɛgui p'ʉya, nu̱na̱ ra̱ mmɛ̱hui̱ ya rá̱ ts'ʉnt'ʉsɛ bi̱ mɛnnbʉ bí 'bʉhyø mɛfi conhui rá̱ hua̱hi̱. Bi 'yɛ̱na̱: “Nu̱yá, ma ga̱ pɛnhnä na̱ ma̱ ts'ʉnt'ʉ ya. Nu̱'mø bi̱ nu̱ yø mɛfi p'ʉya, da̱ nu̱ ma̱nsu̱, porque ma̱ ts'ʉnt'ʉ na”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pɛ nu̱'mø mi̱ zømp'ʉ 'bʉhyø mɛfi na̱ rá̱ ts'ʉnt'ʉ ra̱ mmɛ̱hui̱, yø mɛfi di̱ n'yɛ̱mbi̱: “Nu̱na̱ ya, guehna̱ ra̱ ts'ʉnt'ʉ ja ngue da̱ gohmi̱ ra̱ hua̱hi̱ na̱ya. Ma ga̱ hohʉ ya, n'namhma̱ ngue ya ma̱ mmɛtihʉ ra̱ hua̱hi̱”, di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bi bɛnnba̱bi̱ rá̱ ts'ʉnt'ʉ ra̱ mmɛ̱hui̱ p'ʉya, bi gʉjma̱xøts'e ra̱ hua̱hi̱, ja bá̱ hop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nu̱na̱ ra̱ Jesús, bi 'yänyø ja̱'i̱, bi 'yɛ̱mbi̱: ―Xi'mø ya bi̱ nja ya yø hya̱ dí xi'a̱hʉ ya, ¿teni̱ 'bɛ'a̱ da̱ 'yøtra̱ mmɛ̱hui̱ 'mø bi zømp'ʉ 'bʉhyø mɛfi conhui rá̱ hua̱hi̱? ");
INSERT INTO otnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bi 'yɛnyø ja̱'i̱ 'mø mi̱ da̱di̱: ―¿Te 'bɛ'a̱ da̱ jap'ʉ 'mø? Gä da̱ hyo'ʉ yø mɛfi ngue yø dondo, hi̱ndi̱ huɛ̱qui̱. Nu̱'a̱ rá̱ hua̱hi̱ p'ʉya, n'nan'yo mi̱'da yø mɛfi hønda̱ gonhui ra̱ hua̱hi̱. Nu̱ya yø mɛfi da̱ gonhui rá̱ hua̱hi̱ p'ʉya, nu̱'mø bi zønna̱ pa da̱ thʉcyø uva, di däpra̱ mmɛ̱hui̱'a̱ te di tocabi. ");
INSERT INTO otnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ra̱ Jesús ma̱hømbi 'yɛ̱mbyø ja̱'i̱: ―Guí pa̱hmʉ xa̱nho ra̱ hya̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Nu̱na ra̱ do hi̱mbi̱ nu̱ ma̱nho yø hyønni̱gu̱, guehna̱ ra̱ do brá̱ 'bɛbo p'ʉ brá̱ fʉhra̱ ja̱do na̱. Ngu̱na̱ ra̱ hya̱ xa̱ nzän'Oja̱ ngue di̱ nja ya. A nu̱jʉ p'ʉya, dí ɛ̱mhmʉ ngue ma̱zihotho te øt'Oja̱”, ɛ̱nna̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ja̱na̱ngue nu̱yá, mi̱ ja ngue xqui sohʉ rá̱ 'yɛ Oja̱, pɛ ya hi̱n'na̱ ya. Nu̱'ʉ yø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱ ya, gue'ʉ yø ja̱'i̱ da̱ 'yøtra̱ nho i̱ nne Oja̱ da̱ 'yøtyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nu̱ ra̱ ja̱'i̱ da̱ zoxma̱ xøts'e ra̱ do, da̱ føhra̱ ja̱'i̱. A nu̱'mø da̱ dähra̱ do ngue da̱ zoxra̱ ja̱'i̱, da̱ xɛni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nu̱'ʉ yø hmu̱ yø mmäcja̱ 'nɛ̱hyø fariseo mi̱ 'yøhna̱ ra̱ hya̱ bi hyɛcra̱ Jesús, bi̱ n'yo yø mmʉi ngue go sihna̱ ra̱ hya̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","'Bexque'a̱ bi̱ ne xti bɛntra̱ Jesús ngue xta̱ ngot'i. Nja ngue bi zu̱pi̱ xti̱ mbøcuɛ yø ja̱'i̱, ja̱na̱ngue hi̱mbi̱ bɛnt'i̱. Porque gätho yø ja̱'i̱ ɛ̱mbi̱ ngue rá̱ pønga̱hya̱ Oja̱ na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ra̱ Jesús ma̱hømbi̱ hyoni̱ te gui hyɛjpa̱ yø hya̱ xihyø ja̱'i̱. Bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nu̱na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ di̱ mbita yø ja̱'i̱ ngue da̱ zo rá̱ 'yɛ. Ɛ̱̱ntho n'na ra̱ da̱st'abi di̱ mbita yø ja̱'i̱ ngue da̱ nu̱ ra̱ ngo 'mø bi̱ ntha̱trá̱ ts'ʉnt'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bi̱ mɛnhyø mɛfi ngue da̱ si yø ja̱'i̱ nu̱ya xa̱ mbita ngue da̱ nu̱ ra̱ ntha̱ti̱. Pɛ nu̱'ʉ yø ja̱'i̱ bá̱ ts'i, hi̱mbi̱ ne bá̱ ɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ma̱hømbi̱ mɛnhmi̱'da yø mɛfi p'ʉya, bi 'yɛ̱mbi̱: “Ga̱ 'youi, bá̱ xihmi̱ yø ja̱'i̱ ya xtá̱ mbitagä, ngue ya xtá̱ nsä tengue da̱ ts'i. Ya xtá̱ ho ma̱ nda̱ni̱ xi̱ noqui. Ya xtá̱ nsä xa̱nho. Bá̱ xihmʉ ngue da̱ ɛ̱hɛ̱ da̱ nu̱ ra̱ ntha̱ti̱”, bi 'yɛ̱mbyø mɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pɛ yø ja̱'i̱ bi ts'i hi̱mbi̱ ne bá̱ ɛ̱hɛ̱. Nu̱'a̱ n'na nc'ɛ̱i̱ bi̱ ma dra̱ 'bɛfi rá̱ hua̱hi. Ma̱n'na nc'ɛ̱i̱ p'ʉya, di sigue ngue mpätho. ");
INSERT INTO otnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mi̱'da yø ja̱'i̱ p'ʉya bi bɛntyø nzite xi̱ mɛnhna̱ nda̱st'abi, bi ʉni̱, bi hyo 'da. ");
INSERT INTO otnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ra̱ da̱st'abi p'ʉya bi 'yɛ̱mmɛ̱i̱ bi̱ mbøcuɛ. Bi̱ mɛnhyø soldado ngue da̱ ho'ʉ yø ja̱'i̱ bi ho yø nzite. Bá̱ u̱rpa̱bi̱ yø hni̱ni̱ ya yø hyote. ");
INSERT INTO otnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ma̱hømbi̱ 'yɛ̱mbyø mɛfi p'ʉya: “Nu̱gä ya xtá̱ nsä ngue ra̱ ntha̱ti̱ di̱ nja, pɛ nu̱'ʉ yø ja̱'i̱ ya xtá̱ zofo, hi̱nni̱ 'yu̱p'ʉ ngue xta̱bá̱ thocua'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pɛ nu̱ya ni̱ mähä p'ʉ ja yø 'yu̱ ya. To bi zä ma̱ ja̱'i̱ gui̱ nthɛhʉ, bá̱ xihmʉ ngue da̱ ɛ̱hɛ̱ da̱ nu̱ ra̱ ntha̱ti̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nu̱'ʉ yø mɛfi p'ʉya bi̱ map'ʉ bí ja yø 'yu̱ bi sifi. Nu̱ ha̱ngu̱ yø ja̱'i̱ bi̱ nthɛui, gä bá̱ si. Bá̱ si yø ts'oc'ɛ̱i̱, bá̱ si yø hoja̱'i̱. Ja̱na̱ngue bi yu̱hyø ja̱'i̱ p'ʉ ja ra̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ra̱ da̱st'abi p'ʉya, mi̱ yʉt'a̱mbo rá̱ ngu̱ ngue da̱ nu̱ yø ja̱'i̱ xi ts'ofo. Bi nu̱ p'ʉya ngue 'bʉp'ʉ n'na nc'ɛ̱i̱ hi̱ngui̱ he rá̱ he tengu̱tho yø he yø ja̱'i̱ sänni̱go ngue ra̱ ntha̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bi 'yɛ̱mbʉya: “Ague n'yø, ¿hague xqui cʉtua ya? 'Nɛ̱ hi̱ngui̱ he ni̱ he tengu̱ he yø ja̱'i̱ nu̱ya sänni̱go ngue nnu̱ ra̱ ntha̱ti̱”, bi 'yɛ̱mbi̱. Pɛ nu̱na̱ ra̱ n'yohʉ hi̱nte ga̱ nda̱tho. ");
INSERT INTO otnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ra̱ da̱st'abi p'ʉya bi 'yɛ̱mbyø mɛfi: “Nu̱na̱ ra̱ n'yohʉ 'bʉcua, da̱mi̱ tu̱rpa̱ui yø gua 'nɛ̱hyø 'yɛ. 'Yɛmmi̱ p'ʉ thi ja ra̱ 'bɛxu̱i̱, ja di̱ nzomp'ʉ, 'nɛ̱ ja di gu̱xpʉ yø ts'i”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porque xa̱ngu̱ yø ja̱'i̱ bi ts'ofo, pɛ ziyohotho yø ja̱'i̱ bi thanhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yø fariseo p'ʉya bi̱ nhɛca̱hya̱ ha di japi ngue da̱ jʉjpa̱tho häi te ga̱ ya̱ ra̱ Jesús para ngue da̱ zäp'ʉ di ya̱pa̱ m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ja̱na̱ngue bi̱ mɛnhyø n'yohʉ p'ʉya, bi̱ mähä 'da yø ja̱'i̱ ra̱ Herodes ngue bá̱ nya̱ui ra̱ Jesús. Bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, dí pa̱cähe ngue grá̱ hoga̱ n'yohʉ, porque gä pønma̱nho ra̱ hya̱ guí̱ mma̱. Ma̱jua̱ni̱ ngue guí xännba̱te'a̱ ra̱ hya̱ nne Oja̱ ngue gdá̱ n'yohʉ. Ni̱ xi̱ngui̱ su̱'a̱ te mbɛ̱n'na̱'i̱ yø ja̱'i̱. Ma̱da̱gue'a̱ ja yø cargo 'da yø n'yohʉ gui ya̱ui, pɛ hi̱ngui̱ su̱ gui xifi ndana̱ ra̱ hya̱ ma̱jua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","A nu̱yá, dí̱ nne guí xicje ya, ¿ua xa̱nho ngue di nju̱tra̱ mɛ̱nyu̱ ähra̱ da̱st'abi, uague hi̱n'na̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pɛ ra̱ Jesús ya pa̱tho te mbɛ̱nnba̱bi̱ yø ja̱'i̱ nguehna̱ ra̱ nt'änni̱ ørpe, i sämhya̱tho. Bi 'yɛ̱mbʉya: ―¿Hanja ngue guí sämhya̱ga̱hʉ? ");
INSERT INTO otnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Da̱mi̱ 'yu̱rca̱hʉ ra̱ mɛ̱nyu̱ nu̱'a̱ ga̱di̱ u̱mhmʉ 'mø bi gʉp'a̱hʉ ra̱ mɛ̱nyu̱ ra̱ da̱st'abi. Bi u̱nna̱ mɛ̱nyu̱ p'ʉya ngue da̱ nu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mi̱ nu̱ ra̱ mɛ̱nyu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿To rá̱ hmi̱ na̱ n'youi ra̱ mɛ̱nyu̱ ja ua? ¿To rá̱ thu̱hu̱ na̱ ra̱ thu̱hu̱ n'youi ra̱ mɛ̱nyu̱? ");
INSERT INTO otnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mi̱ da̱hyø ja̱'i̱ ya̱ui ra̱ Jesús, bi 'yɛ̱mbi̱: ―Guehna̱ ra̱ da̱st'abi na̱ya ―bi 'yɛ̱mbi̱. Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―Nu̱'a̱ ja ngue gui 'yøthʉ ya, da̱mi̱ u̱nhnʉ ra̱ mɛ̱nyu̱ di tocabi ra̱ da̱st'abi. Da̱ gue Oja̱ p'ʉya, da̱mi̱ u̱nhnʉ'a̱ te di tocabi. ");
INSERT INTO otnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nu̱na̱ ra̱ hya̱ i da̱hra̱ Jesús, mi̱ 'yøhyø nsʉiui, di 'yøtho, ya hi̱mbi̱ zä ha xti japi te mbɛ̱nnbi̱. Bi zop'ʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, bi̱ ma 'da yø saduceo, nu̱ya ɛ̱mbi̱ ngue hi̱ndi̱ bɛ̱nna̱te yø ánima. Bi 'yɛ̱mbra̱ Jesús: ");
INSERT INTO otnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Ague grá̱ xännba̱te, nu̱p'ʉ ja ra̱ ley bi 'yotra̱ Moisés, nt'ot'i p'ʉ ra̱ hya̱ ngue ɛ̱na̱: nu̱'mø bi du̱ n'na ra̱ n'yohʉ, 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱, nu̱ rá̱ xisu ra̱ ánima da̱ zogui, nu̱'a̱ rá̱ n'yohʉ ra̱ ánima gue'a̱ di̱ ntha̱tui ra̱ 'danxu̱'a̱, n'namhma̱ ngue di̱ m'mʉhyø ba̱si̱ tengu̱tho 'mø xti̱ m'mʉhyø ba̱si̱ ra̱ ánima. ");
INSERT INTO otnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A nu̱yá, nu̱ua dí 'bʉhmʉ ya, xi'mø ga̱ ɛ̱mhmʉ ngue di 'bʉ'i yoto ma̱'yohʉ ngue ɛda̱di̱ ncu̱. Nu̱'a̱ ra̱ n'yohʉ ma̱ da̱, di̱ ntha̱ti̱. Pɛ da̱ 'yɛ̱hra̱ pa da̱ du̱, 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱. Ja̱na̱ngue nu̱'a̱ rá̱ n'yohʉ ra̱ ánima m'mɛfa bi̱ m'mʉi, go di̱ ntha̱tui ra̱ 'danxu̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pɛ xquet'a̱ da̱ du̱ ra̱ n'yohʉ 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱. Di siguetho di̱ ntha̱tra̱ xisu 'mø bi du̱ ra̱ ndø, asta̱ gue'mø bi du̱ gä yoto ma̱'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mi̱ zʉdi ngue bi̱ m'mʉhmi̱ gä yoto ma̱'yohʉ na̱ ra̱ xisu p'ʉya, xquet'a̱ 'nɛ̱hsɛ ra̱ xisu da̱ du̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A nu̱yá, xi'mø ra̱ pa da̱ni̱ bɛ̱nna̱te yø ánima ya, ¿ndana̱ gue'a̱ ya yoto ma̱'yohʉ rá̱ mmɛti ra̱ xisu? Porque gä bi̱ m'mʉhmi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―Hi̱nguí̱ pa̱di̱ ha rá̱ nja ra̱ hya̱ guí̱ mma̱mhmʉ. Porque hi̱nga̱ guep'ʉ gá̱ ndi̱nni̱ mmʉihʉ'a̱ te ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro. 'Nɛ̱ hi̱nguí̱ pa̱hmʉ hangu̱ rá̱ ts'ɛdi Oja̱ i ja. ");
INSERT INTO otnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A nu̱'mø bi bɛ̱nna̱te yø ánima, da̱ gohi tengu̱tho yø anxɛ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱, ya hi̱ndi̱ ntha̱tyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nu̱na̱ te ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, ja di̱ nɛ̱qui̱ p'ʉ ngue di bɛ̱nna̱te yø ánima. Porque nt'ot'i p'ʉ ra̱ hya̱ bi̱ ma̱n'Oja̱ ngue bi 'yɛ̱na̱: “Guecä drá̱ Oja̱gä ngue ra̱ Abraham. Drá̱ Oja̱gä ngue ra̱ Isaac. Drá̱ Oja̱gä ngue ra̱ Jacob”, bi 'yɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ja di̱ nɛ̱qui̱ p'ʉya ngue nu̱p'ʉ 'bʉ Oja̱, hi̱ngui̱ tu̱ yø te yø ánima. ");
INSERT INTO otnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mi̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ xännba̱te ra̱ Jesús, yø ja̱'i̱ di 'yøtho. ");
INSERT INTO otnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mi̱ 'yøhyø fariseo ngue ra̱ Jesús bi̱ da̱pra̱ hya̱ yø saduceo, bi̱ nhɛca̱ hya̱ p'ʉya ngue honi̱ ha di japra̱ hya̱ da̱ xihra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nu̱'a̱ n'na'ʉ yø fariseo xännba̱te ra̱ ley, bi̱ ma bá̱ sämhya̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Ague grá̱ xännba̱te, xi'ʉ yø hya̱ nt'ot'i p'ʉ ja rá̱ ley Oja̱, ¿ndana̱ ra̱ hya̱ ɛxa̱ ma̱ da̱tho di ja ts'ɛdi Oja̱ ngue da̱ 'yøtyø ja̱'i̱? ");
INSERT INTO otnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ hya̱ guí änngui̱, guehna̱ ra̱ hya̱ ngue ɛ̱na̱: “Da̱mi̱ ja ndu̱mmʉi ngue ma̱thoguitho gui̱ ma̱hmʉ Oja̱ co gätho ni̱ mmʉihʉ. Hønt'a̱ guí̱ mbɛ̱mhmʉ'a̱”. ");
INSERT INTO otnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nu̱na̱ ra̱ hya̱ na̱ya, guehna̱ ɛxa̱ ma̱ da̱tho di ja ts'ɛdi Oja̱ ngue da̱ 'yøtyø ja̱'i̱ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nu̱na̱ rá̱ yoho ra̱ hya̱ di̱ ma̱nda Oja̱ p'ʉya, 'nɛ̱ di ja ts'ɛdi Oja̱ ngue da̱ 'yøtyø ja̱'i̱, guehna̱ ra̱ hya̱ ngue ɛ̱na̱: “Da̱mi̱ ma̱hni̱ mmi̱c'ɛ̱i̱ui, tengu̱tho gni̱ ne ngue di̱ ma ma̱ma̱di̱'i̱”, ɛ̱nna̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Guehya yoho yø hya̱ 'bɛt'o ya ngue gätho mi̱'da yø hya̱ di̱ ma̱nda Oja̱. Porque nu̱ya gä mi̱'da yø hya̱ bi 'yotra̱ Moisés co 'nɛ̱hyø pønga̱hya̱ Oja̱, høntho xännba̱bi̱ yø ja̱'i̱ ha di̱ ma̱ Oja̱, co 'nɛ̱hyø mmi̱c'ɛ̱i̱ui di̱ ma̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nu̱p'ʉ 'bʉhra̱ Jesús, tobe 'bärpʉtho yø fariseo. ");
INSERT INTO otnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Xi'a̱ t'ɛ̱mbi̱ ra̱ Cristo, ¿ua guí pa̱hmʉ to rá̱ ts'ʉnt'ʉ'a̱? Yø fariseo p'ʉya bi 'yɛ̱na̱: ―Nu̱'a̱ ra̱ Cristo, gue'a̱ rá̱ mbom'mɛto ra̱ David ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Pɛ ¿hanja na̱ ra̱ hya̱ bi bɛ̱nnba̱bi̱ ra̱ Espíritu Santo ra̱ David 'mø? Porque ra̱ David, bi̱ ma̱ ngue rá̱ Hmu̱'a̱ ra̱ Cristo. Ra̱ David bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Nu̱na̱ Oja̱, nu̱'mø mi̱ zojba̱gui̱ ma̱ Hmu̱, ngu̱na̱ ra̱ hya̱ bi xifi, bi 'yɛ̱mbi̱: Da̱mi̱ mi̱cua ja ma̱ n'yɛigä ya, asta̱ gue'mø ga̱ øt'e ngue guí̱ ma̱nda gätho'ʉ ni̱ nsʉiui”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ja di̱ nɛ̱qui̱ p'ʉya ngue ra̱ David, nu̱'mø nnønna̱ Cristo, ni̱ hu̱ti̱ ngue rá̱ Hmu̱. Ja̱na̱ngue ra̱ Cristo di̱ nɛ̱qui̱ ngue hi̱ngra̱ ja̱'i̱tho, ma̱da̱gue'a̱ ngue rá̱ mbom'mɛto ra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni̱ xi̱nga̱ n'na nc'ɛ̱i̱ xta̱ mba̱di̱ te xti da̱hya yø hya̱ bi̱ ma̱nna̱ Jesús. Bi mʉ'a̱ ra̱ pa'a̱ p'ʉya ngue nu̱ya yø nsʉiui ra̱ Jesús bi zu̱ ngue ni̱mantho xta̱ 'yørpa̱bi̱ yø nt'änni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ra̱ Jesús bi zofo gätho yø ja̱'i̱ co 'nɛ̱hyø xädi, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Nu̱'ʉ yø xännba̱te ngue ra̱ ley 'nɛ̱hyø fariseo, guehya ɛ̱mbyø ja̱'i̱ ngue bi t'u̱nyø 'bɛfi ngue di̱ nxännba̱te te ga̱ mbønna̱ ley bi 'yotra̱ Moisés. ");
INSERT INTO otnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ja̱na̱ngue nuya yø hya̱ di̱ ma̱nda ngue gui 'yøthʉ, da̱mi̱ 'yɛ̱c'ɛ̱i̱hʉ. Nu̱'mø te di 'bɛp'a̱hʉ ngue gui 'yøthʉ, da̱mi̱ 'yøthʉ. Pɛ 'yoguí øthʉ tengu̱tho ga̱ 'yo ya yø xännba̱te ya, porque nu̱yá, nu̱'a̱ ra̱ hya̱ xännba̱te, hi̱nga̱ gue'a̱ øt'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A nu̱na̱ ra̱ ley xännba̱ yø ja̱'i̱ ngue da̱ 'yøt'e, hi̱njongui̱ hät'i da̱ 'yøt'e. Porque ɛ̱ntho ra̱ nda̱te 'bɛni̱ di du̱tyø ja̱'i̱, pɛ yø ja̱'i̱ hi̱ngui̱ hät'i da̱ du̱ts'i̱. Ni̱ xi̱nga̱ n'na rá̱ saha di̱ nne di̱ mfäxte ngue di tøxra̱ 'bɛni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nu̱ te gä øt'e, ga̱ 'yøt'e ngue høntho di 'yɛ̱xpʉ ha 'bʉhyø ja̱'i̱. Porque di ho te øt'e, ngue nu̱p'ʉ ja yø dɛ̱ 'nɛ̱p'ʉ ja yø gu̱yʉni̱, xa̱ cuatyø sʉcua̱ ngue nt'ot'i rá̱ hya̱ Oja̱. 'Nɛ̱ di ho ngue søt'a̱ häi yø he. ");
INSERT INTO otnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nu̱p'ʉ ha øt'a̱ ngo yø ja̱'i̱, da̱ guep'ʉ ja yø ni̱ja̱, huantho yø nthu̱ts'i̱ ta̱te xa̱nho ngue ja hu̱p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Nɛ̱ di ho ngue nu̱p'ʉ ja yø täi, di respeta yø ja̱'i̱ ha gui zɛngua. 'Nɛ̱ di ho 'mø t'ɛ̱mbi̱ ngue yø xännba̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pɛ nu̱'a̱hʉ, 'yo guí̱ nne gui 'yɛ̱xʉ ngue di hu̱'a̱hʉ yø ja̱'i̱ ngue gyø xännba̱tehʉ. Porque n'natho ni̱ xännba̱tehʉ 'bʉi, gue'a̱ ɛ̱mbyø ja̱'i̱ ngue ra̱ Cristo'a̱. A nu̱'a̱hʉ, gä ga̱di̱ ncu̱thohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nu̱ua ja ra̱ häi, 'yo toni̱ ja̱'i̱ gni̱ hu̱ti̱ ngue ni̱ Papáhʉ. Porque nu̱'a̱ ni̱ Papáhʉ, hønda̱ n'na i 'bʉi, pɛ ma̱hɛ̱ts'i̱ bí 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'Yo guí̱ nne da̱ 'yøt'e ngue yø hmu̱'a̱hʉ yø ja̱'i̱. Nu̱'a̱ da̱ 'yøt'e ngue yø hmu̱ yø ja̱'i̱, høndra̱ Cristo'a̱ ra̱ hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nu̱ ra̱ ja̱'i̱ di̱ mpɛfi ngue fäxrá̱ mmi̱c'ɛ̱i̱ui, guehna̱ ta̱te na̱ ngue gätho'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porque nu̱'a̱ nne ngue ma̱n'na di hnu̱ ma̱nsu̱, gue'a̱ ma̱n'na ts'ʉtho hnu̱ ma̱nsu̱'a̱. Pɛ nu̱'a̱ øt'e ngue hi̱ngui̱ hnu̱ ma̱nsu̱ p'ʉ ga̱ mbɛ̱ni̱, gue'a̱ ma̱n'natho hnu̱ ma̱nsu̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ague gyø xännba̱tehʉ ngue ra̱ ley conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ, ngue hi̱mma̱ jua̱ni̱ gyø hoja̱'i̱hʉ. Go guí cothʉ ra̱ 'yu̱, hi̱n ga̱di japhʉ yø ja̱'i̱ ngue da̱ zo rá̱ 'yɛ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. Ni̱ xi̱nga̱ gue'a̱hʉ guí̱ nne gui sohʉ rá̱ 'yɛ Oja̱. Nu̱'ʉ yø ja̱'i̱ nne ngue da̱ zo rá̱ 'yɛ Oja̱, hi̱n ga̱di japhʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ague gyø xännba̱tehʉ ngue ra̱ ley conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ, ngue hi̱mma̱ jua̱ni̱ gyø hoja̱'i̱hʉ. Porque guí tu̱nnba̱hʉ yø ngu̱ yø 'danxu̱. Guí hät'i ngue guí ɛ̱mbi̱ gui xa̱nnba̱hʉ te pɛts'i. Pɛ para ngue guí corpa̱hʉ yø dä yø ja̱'i̱, ndø ya'atho gui̱ mmat'Oja̱hʉ. Pɛ nu̱yá, ma̱thoguitho ra̱ castigo gui thohmʉ ngue guí̱ njahʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ague gyø xännba̱tehʉ ngue ra̱ ley conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ, ngue hi̱mma̱ jua̱ni̱ gyø hoja̱'i̱hʉ. Ndap'ʉ bi zä gui 'yohʉ ua ja ra̱ häi, gui 'daxhʉ yø ja̱the ngue gui homhmʉ yø ja̱'i̱ da̱ dɛnna̱ hya̱ guí xännba̱tehʉ. Nu̱'mø ya gá̱ 'bäthʉ n'na ra̱ ja̱'i̱ ngue da̱ dɛnna̱ hya̱ guí xännba̱tehʉ, nu̱na̱ ra̱ ja̱'i̱ gui 'bäthʉ, da̱ gohi ngue ndoble ra̱ castigo da̱ thop'ʉ ja ra̱ ni̱du̱ ngue'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nu̱ to gä guí xännba̱tehʉ ra̱ hya̱ 'nɛ̱ hi̱nguí̱ pa̱hmʉ teni̱ bønna̱ hya̱ guí̱ mma̱mhmʉ, hague ngu̱ ra̱ n'ʉ gui thohmʉ. Porque nu̱ya yø ja̱'i̱ di ya̱t'a̱ n'na ra̱ hya̱ ngue da̱ 'yøt'e, 'nɛ̱ bi 'yɛ̱xa̱ ntestigo ra̱ ni̱ja̱, guí xännba̱tehʉ yø ja̱'i̱ ngue hi̱ngui̱ ja ts'ɛdi di̱ nja'a̱ ra̱ hya̱ bi̱ ma̱nna̱ ja̱'i̱. Pɛ nu̱ ra̱ ja̱'i̱ ɛ̱xa̱ ntestigo ra̱ oro ja mbo ra̱ ni̱ja̱, guí xihmʉ ra̱ ja̱'i̱ ngue ja ts'ɛditho da̱ 'yøt'a̱ te ra̱ hya̱ bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pɛ ngue ma̱'bɛdi ni̱ mmʉihʉ, hi̱nguí̱ ti̱mhmʉ teni̱ bønna̱ hya̱ guí̱ mma̱mhmʉ. ¿Ua guí ɛ̱mhmʉ ngue mi̱ts'ʉ ta̱te ra̱ oro ngue ra̱ ni̱ja̱, nu̱na̱ øt'e ngue xa̱ndʉxqui ra̱ oro? ");
INSERT INTO otnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xquet'a̱ nu̱ya yø ja̱'i̱ ɛ̱xa̱ ntestigo ra̱ altar ngue tema̱ hya̱ di ya̱tra̱ ja̱'i̱ da̱ 'yøt'e, guí xännba̱hʉ ra̱ ja̱'i̱ ngue hi̱ngui̱ ja ts'ɛdi da̱ 'yøtra̱ ja̱'i̱'a̱ ra̱ hya̱ bi̱ ma̱. Pɛ nu̱'mø ngue bi 'yɛ̱xa̱ ntestigo ra̱ ja̱'i̱'a̱ ra̱ 'bøt'e xa̱ jäxpʉ ja ra̱ altar, guí xihmʉ ra̱ ja̱'i̱ ngue ja ts'ɛditho da̱ 'yøtra̱ ja̱'i̱ na̱ ra̱ hya̱ bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pɛ ngue ma̱'bɛdi ni̱ mmʉihʉ, hi̱nguí̱ ti̱mhmʉ teni̱ bønna̱ hya̱ guí̱ mma̱mhmʉ. ¿Ua guí ɛ̱mhmʉ ngue mi̱ts'ʉ ta̱te ja rá̱ ts'ɛdi ra̱ 'bøt'e ngue ra̱ altar, ngue'a̱ ga̱ ndʉxqui ra̱ 'bøt'e? ");
INSERT INTO otnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pɛ nu̱ ra̱ ja̱'i̱ ngue ɛ̱xa̱ ntestigo ra̱ altar hi̱nga̱ høndra̱ altar ɛ̱xa̱ ntestigo, sinoque ɛ̱xa̱ ntestigo'a̱ te gä ja p'ʉ ja ra̱ altar. ");
INSERT INTO otnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A nu̱ ra̱ ja̱'i̱ ngue ɛ̱xa̱ ntestigo ra̱ ni̱ja̱, hi̱nga̱ høndra̱ ni̱ja̱ ɛ̱xa̱ ntestigo, sinoque gue'a̱ Oja̱ 'bʉp'ʉ ja ra̱ ni̱ja̱ ɛ̱xa̱ ntestigo ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Xi mma̱ngu̱ ra̱ ja̱'i̱ ɛ̱xa̱ ntestigo ma̱hɛ̱ts'i̱, gue'a̱ rá̱ nthu̱ts'i̱ Oja̱ ɛ̱spa̱bi̱ ntestigo. Da̱ guesɛ Oja̱ p'ʉya, porque go bí hu̱p'ʉ bí ja rá̱ nthu̱ts'i̱ ma̱hɛ̱ts'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ague gyø xännba̱tehʉ ngue ra̱ ley conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ, ngue hi̱mma̱ jua̱ni̱ gyø hoja̱'i̱hʉ. Nu̱'a̱ ra̱ diezmo ga̱di̱ u̱nhnʉ Oja̱, ga̱di̱ u̱nni̱ te gä guí ti̱mhmʉ asta̱ ra̱ xa̱c'a̱ndehe ga̱di̱ u̱nhnʉ ra̱ diezmo Oja̱. Da̱ guehra̱ anís, da̱ guehra̱ comino ga̱di̱ u̱nhnʉ ra̱ diezmo Oja̱. Ya xa̱nho ngue ngu̱na̱ guí øthu̱, pɛ nu̱p'ʉ ja ra̱ ley, i̱ mma̱mp'ʉ ma̱n'na ra̱ hya̱ ngue ja ts'ɛditho gui 'yøthʉ. Porque nt'ot'i ra̱ hya̱ ngue ma̱hyoni̱tho gui̱ n'yo ma̱nhohʉ, 'nɛ̱ di̱ nja ni̱ nhuɛ̱ca̱tehʉ, 'nɛ̱ ma̱jua̱ni̱ ngue gä da̱ gue'a̱ te gdi̱ n'yohʉ. Guehna̱ ra̱ hya̱ ja ts'ɛditho ngue gui 'yøthʉ na̱ya, da̱ guehra̱ diezmo da̱mi̱ siguetho guí u̱nhnʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nu̱ya te gäma̱ hya̱ guí xännba̱tehʉ, 'nɛ̱ hi̱nguí̱ pa̱hmʉ te ni̱ bøni̱. Go gui ørpa̱hʉ ma̱su̱ ya yø hya̱ zits'ʉtho ja ts'ɛdi, pɛ nu̱ya yø hya̱ ma̱ da̱tho ja ts'ɛdi ngue gui 'yøthʉ, hi̱nga̱ ɛguí ørpa̱hʉ ma̱su̱ xa̱nho ya. ");
INSERT INTO otnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ague gyø xännba̱tehʉ ngue ra̱ ley conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ, ngue hi̱mma̱ jua̱ni̱ gyø hoja̱'i̱hʉ. Porque ma̱xøts'etho di̱ nɛ̱qui̱ ngue gyø hoja̱'i̱hʉ, pɛ mbo ni̱ mmʉihʉ, gyø bɛ̱hʉ ngue hønt'a̱ te pɛs'yø ja̱'i̱ so ni̱ mmʉi gui hya̱nnba̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ague gyø fariseohʉ, hi̱ngui̱ ti̱nni̱ mmʉi teni̱ bøn'a̱ guí øthʉ. 'Be da̱ bo mbo ni̱ mmʉihʉ, n'namhma̱ ngue 'nɛ̱hma̱ xøts'e ni̱ do'yohʉ di̱ nɛ̱qui̱ ngue xta̱nho. ");
INSERT INTO otnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ague gyø xännba̱tehʉ ngue ra̱ ley conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ, ngue hi̱mma̱ jua̱ni̱ gyø hoja̱'i̱hʉ. Porque nu̱'a̱hʉ, tengu̱tho yø panteón, ngue ma̱zihotho gui̱ nɛ̱qui̱ ma̱xøts'e ngue ma̱t'axqui, pɛ mbo yø panteón ma̱ndø nts'otho ngue yu̱p'ʉ yø do'yo yø ánima. ");
INSERT INTO otnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Guí̱ njathʉ p'ʉya, ma̱xøts'etho di̱ nɛ̱qui̱ ngue xa̱nho te gni̱ 'yohʉ, pɛ mbo ni̱ mmʉihʉ, ma̱dits'ʉ ha da̱di̱ nɛ̱qui̱ p'ʉ'a̱ tengue ma̱jua̱ni̱, høndra̱ nts'o i ja mbo ni̱ mmʉihʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ague gyø xännba̱tehʉ ngue ra̱ ley conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ, ngue hi̱mma̱ jua̱ni̱ gyø hoja̱'i̱hʉ. Nu̱ya yø pønga̱hya̱ Oja̱ xa̱ tho ma̱nja̱m'mø, go ga̱di hojpa̱hʉ yø panteón. Nu̱ya yø ánima xa̱ 'yøtra̱ nho, asta̱ xcá̱ japhʉ yø døni̱ yø do 'bäp'ʉ ha o yø ánima. ");
INSERT INTO otnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Guí ɛ̱mhmʉ p'ʉya: “Nu̱'mø xca̱bá̱ m'mʉhmʉ'ʉ yø pa bá̱ m'mʉhma̱ mboxitahʉ, hi̱nxca̱ fäxʉ ngue xca̱ hohʉ yø pønga̱hya̱ Oja̱”, guí ɛ̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pɛ nu̱'mø ngue ngu̱na̱ ra̱ hya̱ guí̱ mma̱mhmʉ, ya guí pa̱hmʉ xa̱nho ngue yø ba̱si̱'a̱hʉ yø hyote nu̱ya bi hyopyø pønga̱hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¿Te guí tømhmʉ ya? Da̱mi̱ 'yøthʉ nts'ɛdi tengu̱tho xa̱ 'yøt'a̱ m'mɛt'o ni̱ mboxitahʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Guí 'bʉhmʉ tengu̱tho yø c'ɛ̱ya̱ ngue n'youi ra̱ nda̱te. ¿Ha di zä gui̱ mpomhmʉ ra̱ castigo p'ʉ ja ra̱ ni̱du̱? ");
INSERT INTO otnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","A nu̱yá, ga̱ pɛnhnä yø pønga̱hya̱ p'ʉ ha guí 'bʉhmʉ, ga̱ pɛnhnä p'ʉ yø ba̱mhya̱, ga̱ pɛnhnä p'ʉ yø xännba̱te. Nu̱ 'da'ʉ p'ʉya gui hyohʉ, gui cuathʉ ra̱ pont'i̱. Mi̱'da p'ʉya, gui ʉmhmʉ p'ʉ ja yø ni̱ja̱. Mi̱'da p'ʉya guí cu̱hmʉ, nu̱'mø bi 'dagui ngue di̱ ma mi̱'da yø hni̱ni̱, guí̱ mma guá̱ homhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ja̱na̱ngue nu̱p'ʉ ha guí 'bʉhmʉ, gä ja da̱ ma ma̱ pɛn'na̱hʉ p'ʉ ra̱ castigo i ja ngue di̱ nja ngue yø hoja̱'i̱ xa̱ tho. Da̱ fʉp'ʉ bá̱ tu̱ ra̱ hoja̱'i̱ Abel asta̱ guep'ʉ i̱ ntu̱ rá̱ ts'ʉnt'ʉ ra̱ Berequías, nu̱na̱ ra̱ Zacaría bi hyo ni̱ mboxitahʉ p'ʉ ha gui̱ nhyacui ra̱ ni̱ja̱ ra̱ altar. ");
INSERT INTO otnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ma̱jua̱ni̱ dí xi'a̱hʉ ya, ngue nu̱na̱ ra̱ castigo ja ngue di̱ nja, ngu̱na̱ da̱ thogui gätho yø ja̱'i̱ 'bʉhya. ");
INSERT INTO otnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ague gyø mmɛ̱ngu̱hʉ Jerusalén, gue'e gui hophʉ yø pønga̱hya̱ Oja̱, da̱ gue'ʉ yø ma̱mhya̱ Oja̱ bi 'bɛn'na̱hʉ gui pʉndothohʉ. Xa̱ngu̱ yø nni̱di̱ dá̱ ne ngue ga̱ pɛn'na̱hʉ tengu̱tho ra̱ øni̱ 'mø di pɛtyø ba̱si̱ ngue di huits'i conyø zahua, da̱di ja'a̱hʉ p'ʉ. Pɛ hi̱ngá̱ nehʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A nu̱yá, da̱ hyɛc'a̱hʉ p'ʉ Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Dí xi'a̱hʉ ngue ya hi̱nni̱ mantho gui nnu̱jʉ asta̱ gue'mø da̱ 'yɛ̱hra̱ pa gui 'yɛ̱mhmʉ: “Di ja̱prá̱ m'mɛnhni̱ Oja̱ bá̱ pɛnhua”, gui 'yɛ̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nu̱na̱ ra̱ Jesús mi̱ bømma̱ xøts'e ra̱ ni̱ja̱, ya ja ngue da̱ ma. Bi guatyø xädi ngue u̱ti̱ te ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Ya guí̱ nnu̱hʉ te ja ra̱ ni̱ja̱ ya. Pɛ ga̱ xi'a̱hʉ'a̱ te ma̱jua̱ni̱. Nu̱na̱ ra̱ ni̱ja̱ na̱ya, bá̱ ɛ̱p'ʉ ra̱ pa da̱ xotyø ja̱'i̱ na̱. Xøgue di̱ nxʉdi, hi̱n hapʉ nmi̱ nɛ̱qui̱ ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nu̱p'ʉ ni̱ hyandra̱ ni̱ja̱, ja ni̱ gop'ʉ ra̱ nyu̱ni̱ bí ja ra̱ mbonza ja yø olivos. Ja i̱ mɛp'ʉ yø xädi ra̱ Jesús. Bi̱ mi̱p'ʉ bi zøni̱. Bi guatyø xädi p'ʉya ngue ya̱sɛui, bi 'yɛ̱mbi̱: ―Dí̱ nne gui xicje nja̱m'mø di̱ nja ya yø hya̱ guí̱ mma̱, ngue da̱ xotra̱ ni̱ja̱ yø ja̱'i̱. 'Nɛ̱ da̱mi̱ xicje tema̱ hmɛ̱ya di̱ nja'mø guá̱ ɛ̱hɛ̱, da̱ gue'mø bi gua'a̱ nxi̱mhäi, te 'bɛ'a̱ ma̱ hmɛ̱ya di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø xädi: ―Da̱mi̱ mfähmʉ xa̱ndønho, 'yo guí̱ nne ngue to da̱ hyä'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porque xa̱ngu̱ yø ja̱'i̱ di̱ n'yo ngue da̱ 'yɛ̱mbyø ja̱'i̱: “Go guecä drá̱ Cristogä ya”, da̱ 'yɛ̱mbi̱. Gue'a̱ di hyät'i xa̱ngu̱ yø ja̱'i̱'a̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nu̱'mø gá̱ 'yøhmʉ ngue ya ja yø da̱tu̱nhni̱, ogue gui 'yøhmʉ ngue ya ja ngue di̱ nja yø tu̱nhni̱, 'yo sä guí su̱hʉ. Porque jatho ngue ya ngu̱'a̱ ja ngue di̱ nja. Pɛ hi̱nga̱ gue'ʉ yø hmɛ̱ya'ʉ ngue rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Da̱ nangyø nación ngue da̱ 'yørpa̱ ra̱ tu̱nhni̱ mi̱'da yø nación. Da̱ nangyø da̱st'abi ngue da̱ 'yørpa̱ ra̱ tu̱nhni̱ mi̱'da yø da̱st'abi. Di̱ nja yø thu̱hu̱, di̱ nja yø guɛ̱hi̱. Di̱ 'ya̱n'a̱häi ndap'ʉ bi zä. ");
INSERT INTO otnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ja da̱ fʉp'ʉ ra̱ n'ʉ ja ngue da̱ tho'a̱ m'mɛfa yø ja̱'i̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Da̱ ma ma̱dä'i ngue da̱ ma ma̱'ʉni̱'a̱hʉ, 'nɛ̱ da̱ tho'a̱hʉ. Ndap'ʉ bi zä da̱ zʉ'a̱hʉ yø ja̱'i̱ ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Xa̱ngu̱ yø ja̱'i̱ da̱ hyɛp'ʉ yø nt'ɛ̱c'ɛ̱i̱. Asta̱ di däsɛ yø mmi̱'yɛ̱c'ɛ̱i̱ui da̱ zʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Xa̱ngu̱ yø fɛhni̱ pønga̱hya̱ di̱ m'mʉi, da̱ 'yɛ̱na̱ ngue Oja̱ di bɛ̱nnba̱bi̱ ra̱ hya̱ da̱ ma̱. Gue'a̱ di hyät'i xa̱ngu̱ yø ja̱'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nu̱'mø ya bi zɛhra̱ nts'o, xa̱ngu̱ yø ja̱'i̱ da̱ 'yɛspʉ'a̱ gui̱ ma̱hyø mmi̱'yɛ̱c'ɛ̱i̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pɛ nu̱ ra̱ ja̱'i̱ hi̱nda̱ hyɛga̱gui̱, xi̱nda̱ ha̱ngu̱ ra̱ n'ʉ da̱ thogui, gä da̱ zɛti, guehna̱ ra̱ ja̱'i̱ di̱ nya̱nná̱ te na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hante ngue da̱ zɛgui te ja ngue gä di̱ nja, da̱ ma ma̱'yoni̱ na̱ ra̱ hoga̱ 'da'yo hya̱ gä rá̱ ngʉni̱ mxi̱mhäi n'namhma̱ ngue gätho yø ja̱'i̱ da̱ ba̱di̱ ha di̱ njap'ʉ di̱ nzo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Xquet'a̱ gui̱ nnu̱hʉ ngue di̱ nja ya yø hya̱ bi̱ ma̱nna̱ pønga̱hya̱ Daniel, ngue nu̱p'ʉ ja ra̱ xɛqui ma̱dʉxquibi, ja di ts'omp'ʉ yø ja̱'i̱. (A nu̱yá, nu̱ ra̱ ja̱'i̱ di xädi, di̱ n'yo rá̱ mmʉi 'mø bi̱ nu̱ ngue di̱ nja ya yø hya̱ ja ua.) ");
INSERT INTO otnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nu̱'mø gá̱ nu̱hʉ ngue ya bi̱ nja'a̱ p'ʉya, nu̱ yø ja̱'i̱ di 'bʉp'ʉ ja ra̱ häi Judea, da̱ 'dagui, di̱ map'ʉ ja yø xa̱nthø. ");
INSERT INTO otnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nu̱ ra̱ ja̱'i̱ di tøhma̱ xøts'e rá̱ ngu̱, 'yo di ɛ̱na̱ ngue di̱ ma mbo rá̱ ngu̱ ngue te da̱ ha̱, sinoque da̱ 'dagui. ");
INSERT INTO otnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nu̱ ra̱ ja̱'i̱ di 'yo ra̱ 'bɛfi, hi̱ndi̱ ma rá̱ ngu̱ ngue da̱ ca̱ rá̱ tu̱hu̱, sinoque da̱ 'dagui n'nahma̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pɛ huɛ̱ca̱te yø xisu di ha̱dyø ba̱si̱'a̱ ra̱ pa'a̱, ogue di sʉdyø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Da̱mi̱ 'yäphʉ Oja̱ ngue nu̱ya yø hya̱ ja ua, hi̱nda̱ gue'mø ra̱ pa ngue xta̱ nsɛ di̱ nja, ni̱ xi̱nga̱ gue'mø ra̱ pa ngue ra̱ ts'äya di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porque xa̱ndøn'ʉtho te da̱ thohyø ja̱'i̱'a̱ ra̱ pa'a̱. Nu̱ te di̱ nja, hi̱nja̱m'mø xa̱ njap'ʉ asta̱ gue'mø ma̱mbá̱ fʉ'a̱ nxi̱mhäi. 'Nɛ̱ ya hi̱nni̱ mantho da̱ hnu̱ ngue ma̱høndi̱ njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nu̱na̱ Oja̱, ya xa̱ nzänni̱ ngue hi̱nga̱ ya'atho yø pa di̱ nja̱ na̱ ra̱ nda̱te na̱. A nu̱'mø ngue ya'atho di̱ nja, ya hi̱njonda̱ bongui̱. Pɛ da̱ 'yøt'e ngue da̱ thotho, porque Oja̱ di̱ ma̱hya yø ja̱'i̱ ya xa̱ huanhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nu̱'ʉ yø pa'ʉ, 'yo sä guí ɛ̱c'ɛ̱i̱hʉ ya yø ja̱'i̱ da̱ 'yɛ̱n'a̱hʉ: “Nu̱ua, ja bí 'bʉcua ra̱ Cristo”, ogue da̱ 'yɛ̱n'a̱hʉ: “Ni̱nguehnʉ ja bí 'bʉhnʉ”, da̱ 'yɛ̱n'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porque xa̱ngu̱ yø ndøbɛthani̱ di̱ n'yo ngue da̱ 'yɛ̱mbyø ja̱'i̱: “Go guecä drá̱ Cristogä ya”, ogue da̱ 'yɛ̱mbi̱: “Go guecä rá̱ pønga̱hya̱gä Oja̱ ya”, da̱ 'yɛ̱na̱. 'Nɛ̱ da̱ zä da̱ 'yøtyø milagro. Nu̱ya yø milagro da̱ 'yøt'e, guehya da̱ ne ngue di hyätyø ja̱'i̱ nu̱ya yø thanhni̱ Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pɛ nu̱yá, da̱di 'bɛt'o'a̱hʉ ya yø hya̱ ja ngue di̱ nja m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nu̱'mø toni̱ ja̱'i̱ da̱ 'yɛ̱n'a̱hʉ: “Nu̱nʉ bí ja ra̱ da̱po, ja bí 'bʉhnʉ ra̱ Cristo”, da̱ 'yɛ̱n'a̱hʉ, 'yo sä gui pähä p'ʉ ha da̱ si'a̱hʉ. Ogue da̱ 'yɛ̱n'a̱hʉ: “Nu̱p'ʉ bí ja n'na ra̱ cuarto ma̱'ya̱gui̱, ja bí 'bʉp'ʉ”, da̱ 'yɛ̱n'a̱hʉ, 'yo sä guí ɛ̱c'ɛ̱i̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porque nu̱'mø bi zønna̱ pa da̱ ɛ̱hra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱, gätho yø ja̱'i̱ da̱ nu̱. Tengu̱tho ra̱ huɛi 'mø bí yot'i, gä handyø ja̱'i̱ ndap'ʉ bi zä. ");
INSERT INTO otnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nu̱p'ʉ ha di 'bʉhyø ja̱'i̱ ni̱ 'yu̱p'ʉ da̱ tha̱spa̱ ra̱ güɛnda, ja di̱ njap'ʉ ra̱ castigo. ");
INSERT INTO otnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nu̱'mø bi tho'ʉ yø nda̱te di̱ nja, di̱ m'mɛxu̱i̱ ra̱ hyadi 'nɛ̱hra̱ za̱na̱. Da̱ tähyø sø bí ja ma̱hɛ̱ts'i̱. Nu̱ te gä bí ja ma̱ya̱, gä di pädi ha thogui. ");
INSERT INTO otnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nu̱nʉ ma̱ya̱, di̱ nja ra̱ hmɛ̱ya ngue ra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱. Ndap'ʉ bi zä da̱ra̱ zonyø ja̱'i̱ 'mø bi thandra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱, da̱ n'youi ra̱ gu̱i̱. Da̱ nu̱ yø ja̱'i̱ ngue ma̱guesɛ, porque ma̱thoguitho ja rá̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ngu̱ di̱ nya̱ ra̱ corneta, nu̱'ʉ yø anxɛ da̱ n'youi, da̱ mɛnhni̱ gä rá̱ ngʉni̱ nxi̱mhäi, ngue di pɛrpa̱bi̱ yø ja̱'i̱ nu̱ya xa̱ huanhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Da̱mi̱ pa̱hmʉ na̱ ra̱ hya̱ ga̱ hyɛcä ya, ngue gdá̱ hyɛjpa̱bi̱ ra̱ hya̱ n'na nza ra̱ igo. Nu̱'mø ya bi c'amyø 'yɛza ngue bi 'dogui, gui pa̱hmʉ p'ʉya ngue ya ni̱ ma di pat'i xa̱nho häi. ");
INSERT INTO otnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ngu̱na̱ ra̱ hya̱ ja ngue di̱ nja ya. Nu̱'mø gá̱ nu̱hʉ ngue bi̱ nja ya yø hya̱ dí xi'a̱hʉ ya, da̱mi̱ pa̱hmʉ ngue ya xma̱ nguerpʉtho ga̱ ma ɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nu̱ya yø hmɛ̱ya dí xi'a̱hʉ ya, da̱mi̱ pa̱hmʉ ngue guehya di̱ nja ya hante ngue da̱ du̱ yø ja̱'i̱ 'bʉhyø pa ja p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nu̱ te bí ja ma̱ya̱, 'nɛ̱cua ja ra̱ häi hi̱ngui̱ za̱i̱. Pɛ nu̱na̱ ra̱ hya̱ dí̱ mma̱ngä, ja para za̱ntho na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","I pa̱sɛ Oja̱ tema̱ pa di̱ nja ya yø hya̱ dí xi'a̱hʉ. Ni̱ xi̱ngyø anxɛ di pa̱di̱, ni̱ xi̱nga̱ gueque dí pa̱di̱ tema̱ pa di̱ nja, ma̱da̱gue'a̱ ngue rá̱ Ts'ʉnt'ʉgui Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tengu̱tho bá̱ nja'mø yø pa ma̱mbá̱ m'mʉhra̱ Noé, xquet'a̱ ngu̱'a̱ di̱ nja'a̱ ra̱ pa da̱ ɛ̱hra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Porque nu̱'a̱ ra̱ pa'a̱, mi̱ si̱hmɛ̱ yø ja̱'i̱, ma̱di̱ ntha̱ti̱ 'da, ja t'äpyø t'i̱xu̱ 'da. Pɛ hi̱mbi̱ u̱nna̱ güɛnda yø ja̱'i̱ te ja ngue di̱ nja, asta̱ ja gue'mø ra̱ pa mi̱ yʉrbʉ ja ra̱ barco ra̱ Noé. ");
INSERT INTO otnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ja bi ba̱hyø ja̱'i̱ te ja ngue di̱ nja'mø ya jap'ʉ ra̱ nda̱te 'ye bi juadi gätho yø ja̱'i̱. Ma̱høndi̱ njarbʉtho yø ja̱'i̱ 'mø bá̱ ɛ̱hra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nu̱'a̱ ra̱ pa'a̱, yoho yø n'yohʉ 'dap'ʉ da̱di̱ mpɛfi. N'na nc'ɛ̱i̱ da̱ ts'its'i, n'na nc'ɛ̱i̱ da̱ gohi. ");
INSERT INTO otnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yoho yø xisu 'dap'ʉ di̱ ncʉni̱. N'na nc'ɛ̱i̱ da̱ ts'its'i, n'na nc'ɛ̱i̱ da̱ gohi. ");
INSERT INTO otnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ja̱na̱ngue da̱mi̱ ndø'ma̱tehʉ, porque hi̱nguí̱ pa̱di̱ tema̱ pa, tema̱ ora da̱ ɛ̱p'ʉ ni̱ Hmu̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Da̱mi̱ pa̱hmʉ na̱ ra̱ hya̱ ja ua, ngue n'na ra̱ mmɛ̱nni̱gu̱, nu̱'mø da̱ ba̱di̱ tema̱ ora da̱ zøhra̱ bɛ̱ p'ʉ ja rá̱ ngu̱'a̱ di̱ nxu̱i̱, di̱ mfädi xa̱nho, hi̱ndi̱ n'a̱ha̱. Porque hi̱ndi̱ n'u̱ni̱ da̱ sojpa̱ rá̱ ngu̱ ngue da̱ fɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Xquet'a̱ da̱mi̱ njathʉ p'ʉya, da̱mi̱ ndø'ma̱tehʉ. Porque nu̱'a̱ ra̱ ora ngue hi̱nte di so ni̱ mmʉihʉ, xi'mø gue'a̱ ra̱ ora da̱ zøhra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ga̱ xi'a̱hʉ te 'bɛ'a̱ da̱ 'yøtra̱ ja̱'i̱ bi di̱nna̱ mmʉi hanja ra̱ hya̱, nu̱ te sifi da̱ 'yøt'e, gue'a̱ da̱ 'yøt'a̱. Guehna̱ tengu̱tho n'na ra̱ hmi̱qui̱ ngue da̱ ma ma̱fäti te'o 'bʉp'ʉ ja rá̱ ngu̱ rá̱ hmu̱. Nu̱'mø bi zønna̱ ora di̱ nsi̱hmɛ̱ yø ja̱'i̱ ma̱fäti, da̱ 'ui̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ra̱ mmɛ̱nthi̱ di̱ nthɛui ra̱ hmi̱qui̱ nu̱na̱ da̱ 'yøt'e te di 'bɛprá̱ hmu̱. Nu̱'mø bi zøhrá̱ hmu̱ da̱ di̱ni̱ ngue da̱di̱ mpɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱ te gä pɛsrá̱ hmu̱, gä di fätrá̱ hmi̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pɛ nu̱na̱ ra̱ hmi̱qui̱ ngue ra̱ ts'oc'ɛ̱i̱, da̱ 'yɛ̱mp'ʉ ja rá̱ mmʉi ngue hi̱m'be da̱ zøhrá̱ hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Da̱ mʉdi da̱ mʉtyø mmi̱mhmi̱qui̱ui. Da̱ ma ra̱ hmi̱nhni̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nu̱'a̱ rá̱ hmu̱ ra̱ hmi̱qui̱ p'ʉya, nu̱'a̱ ra̱ pa ra̱ ora ngue hi̱ngui̱ tø'mrá̱ hmu̱, da̱ gue'a̱ ra̱ ora da̱ zø'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nu̱'a̱ rá̱ hmu̱ p'ʉya, ma̱thoguitho da̱ mɛi, pɛts'i ngue da̱ xɛni̱. Di 'yɛmp'ʉ ni̱ gohyø ja̱'i̱ hi̱mma̱ jua̱ni̱ yø hoja̱'i̱. Ja di̱ nzomp'ʉ p'ʉya, 'nɛ̱ ja di gu̱xpʉ yø ts'i. ");
INSERT INTO otnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nu̱ya yø ja̱'i̱ ya o rá̱ 'yɛ Oja̱, gui̱ nhyɛjpa̱bi̱ 'dɛt'a yø hmu̱te bi du̱xyø nyot'i ga̱ zø conna̱ aceite. Guehya ndø'ma̱te ngue di hyʉnna̱ novia 'mø bi zøhrá̱ ndø bá̱ ɛ̱p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nu̱ya 'dɛt'a yø hmu̱te p'ʉya, cʉt'a'ʉ yø m'mɛmmʉi, xi̱mmi̱ cʉt'a'ʉ yø njammʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A nu̱'ʉ cʉt'a yø hmu̱te ma̱'bɛdi yø mmʉi, bi du̱xyø nyot'i, pɛ hi̱mbi̱ du̱x hma̱n'na ra̱ aceite da̱ hyom'mø bi guahra̱ aceite ga̱ zø yø nyot'i. ");
INSERT INTO otnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A nu̱ya yø hmu̱te ngue yø njammʉi bi du̱xyø nyot'i, pɛ bi du̱x hma̱n'na ra̱ aceite da̱ hyoni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A nu̱'a̱ ra̱ novio nthø'mi̱ p'ʉya, hi̱nha ni̱ 'ya̱ni̱. Mi̱ nnetha̱ yø hmu̱te p'ʉya, gä bi̱ n'a̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mi̱ zo ma̱de ra̱ xu̱i̱ p'ʉya, bi t'øde ngue bá̱ ɛ̱nna̱ hmafi n'na nc'ɛ̱i̱, bi 'yɛ̱na̱: “Bá̱ ɛ̱cua ra̱ novio ya. Ga̱ 'yo ni̱ ma güí c'athʉ”, bi 'yɛ̱mbyø hmu̱te. ");
INSERT INTO otnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mi̱ nangui̱ gätho yø hmu̱te, ya mi̱ ts'ʉtho zø yø nyot'i, bi̱ ne xta̱ xirpa̱ ma̱n'na ra̱ aceite ngue di̱ nzø xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nu̱ya cʉt'a yø hmu̱te ma̱'bɛdi yø mmʉi bi 'yɛ̱mbya yø hmu̱te ngue yø njammʉi: “Da̱mi̱ 'dacjets'ʉ ni̱ aceiteui, porque ma̱ nyot'igähe ya nne da̱ huɛ̱t'i̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pɛ nu̱'ʉ yø hmu̱te ngue yø njammʉi, ɛ̱ntho 'mø mi̱ da̱di̱: “Hi̱nda̱ zä'a̱, porque nu̱'mø ga̱ 'da'a̱he ra̱ aceite guí homhmʉ, m'mɛfa ya hi̱n'yʉ te di̱ nzø ma̱ nyot'ihe. A nu̱yá, ma̱n'na xa̱nho ni̱ mähä p'ʉ bí 'bä ra̱ aceite, bá̱ tänna̱ aceite guí hyomhmʉ”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bi̱ ma ra̱ thän'aceite'ʉ yø hmu̱te ma̱'bɛdi yø mmʉi p'ʉya. Pɛ ra̱ novio ya bi zøhø. A nu̱ya yø hmu̱te ya xi̱ nsä, 'da i yʉthʉ mbo ra̱ ngu̱ ra̱ novio ya. Bi nøtra̱ goxthi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mi̱ ma n'nøt'e ra̱ goxthi p'ʉya, ja bi zø'ʉ mi̱ cʉt'a yø hmu̱te xi̱ ma ra̱ thän'aceite, bi 'yɛ̱mbʉya: “Ague grá̱ hmu̱, da̱mi̱ xoga̱he ra̱ goxthi”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pɛ ra̱ novio bi 'yɛ̱mbi̱: “Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱gä hi̱ndí̱ pa̱'a̱hʉ”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Da̱mi̱ njathʉ p'ʉya, ya xqui̱ nsähʉ 'mø ra̱ pa da̱ ɛ̱p'ʉ ra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱. Porque hi̱ngui̱ pa̱hmʉ tema̱ pa, tema̱ ora da̱ ɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nu̱na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ di̱ ma̱nda yø ja̱'i̱ ua, gui̱ nhyɛjpi tengu̱tho n'na ra̱ n'yohʉ ja ngue da̱ ma n'na ra̱ häi yap'ʉtho. Bi zonhyø mɛfi ngue di däprá̱ mɛ̱nyu̱, da̱ 'yørpa̱bi̱ rá̱ 'bɛfi mɛ̱nte ra̱ pa da̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","N'na ngu̱ n'na yø mɛfi bi u̱nna̱ mɛ̱nyu̱ hangu̱ da̱ zä da̱ 'yørpa̱bi̱ rá̱ 'bɛfi. Nu̱'a̱ n'na ra̱ mɛfi bi u̱nni̱ cʉt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱. Ma̱n'na ra̱ mɛfi p'ʉya, bi u̱nni̱ yo ma̱hua̱hi̱ ra̱ mɛ̱nyu̱. Ma̱n'na ra̱ mɛfi p'ʉya, bi u̱nna̱ n'na ma̱hua̱hi̱ ra̱ mɛ̱nyu̱. Mi̱ däpra̱ mɛ̱nyu̱ yø mɛfi na̱ ra̱ hmu̱, bi̱ ma yap'ʉtho p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nu̱na̱ ra̱ mɛfi bi̱ ndäpi cʉt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱, bi 'yørpa̱ rá̱ 'bɛfi ra̱ mɛ̱nyu̱ bi t'u̱nni̱. Mi̱ cʉt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ bi da̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nu̱na̱ ra̱ mɛfi bi̱ ndäpi yo ma̱hua̱hi̱ ra̱ mɛ̱nyu̱, bi 'yørpa̱ rá̱ 'bɛfi ra̱ mɛ̱nyu̱ bi t'u̱nni̱. Mi̱ yo ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ bi da̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pɛ nu̱na̱ ra̱ mɛfi bi̱ ndäpa̱ n'na ma̱hua̱hi̱ ra̱ mɛ̱nyu̱, bi 'ya'ma̱ n'na ra̱ ots'i. Ja bi gärpa̱ p'ʉ rá̱ mɛ̱nyu̱ rá̱ hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mi̱ ma ya'a̱tho yø pa p'ʉya, bi zøhrá̱ hmu̱ yø mɛfi. Bi 'yørpa̱bi̱ ra̱ güɛnda'a̱ ra̱ mɛ̱nyu̱ xi däpi. ");
INSERT INTO otnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Rá̱ mʉdi bi zo'a̱ rá̱ mɛfi xi däpi cʉt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱. Gä bi däprá̱ hmu̱'a̱ 'dɛt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ mi̱ ha̱. Bi 'yɛ̱mbi̱: “Ague grá̱ hmu̱, cʉt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ gá̱ däqui, pɛ jaua mi̱ cʉt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ dá̱ ta̱ha̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nu̱'a̱ ra̱ hmu̱ p'ʉya bi 'yɛ̱mbrá̱ mɛfi: “Ya xa̱nho grá̱ hoga̱ mɛfi, hi̱ngá̱ nhyɛtho. Gá̱ pømma̱nho co nu̱'a̱ zits'ʉ ra̱ mɛ̱nyu̱ dá̱ fät'a̱'i̱. A nu̱yá, ma̱n'na xa̱ngu̱ ga̱ fät'a̱'i̱ ya. Nu̱ya hangu̱ ra̱ pa di̱ nja'i̱ mpähä ya”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bi zø'a̱ ra̱ mɛfi xi̱ ndäpi yo ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ p'ʉya. Bi 'yɛ̱mbrá̱ hmu̱: “Ague grá̱ hmu̱, yo ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ gá̱ däqui, pɛ jaua mi̱ yo ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ dá̱ ta̱ha̱, ya goho ma̱hua̱hi̱'a̱ ya”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ra̱ hmu̱ p'ʉya bi 'yɛ̱mbrá̱ mɛfi: “Ya xa̱nho grá̱ hoga̱ mɛfi, hi̱ngá̱ nhyɛtho. Gá̱ pømma̱nho co nu̱'a̱ zits'ʉ ra̱ mɛ̱nyu̱ dá̱ fät'a̱'i̱. A nu̱yá, ma̱n'na xa̱ngu̱ ga̱ fät'a̱'i̱ ya. Nu̱ya hangu̱ ra̱ pa di̱ nja'i̱ mpähä ya”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Rá̱ nzɛguitho bi zø'a̱ ra̱ mɛfi xi̱ ndäpa̱ n'na ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ p'ʉya. Bi 'yɛ̱mbrá̱ hmu̱: “Ague grá̱ hmu̱, nu̱gä dí pa̱di̱ ngue guí ya̱ ma̱nzaqui. Guí ä'a̱ te hi̱nxca̱ ta̱ha̱. Guí xoc'a̱ te hi̱nxca̱ pɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ja̱na̱ngue nu̱gä dí su̱'i̱. Dá̱ cät'ä häi ni̱ mɛ̱nyu̱. Pɛ nu̱yá, jaua na̱ te ni̱ mmɛti ya”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nu̱'a̱ ra̱ hmu̱ p'ʉya bi 'yɛ̱mbrá̱ mɛfi: “Ua go grá̱ ts'omɛfi n'yø, gue grá̱ ndø da̱nhyɛ̱i̱. Guí ɛ̱ngui̱ ngue dí äcä'a̱ te hi̱nxtá̱ ta̱ha̱. Guí ɛ̱ngui̱ ngue dí xocä'a̱ te hi̱nxtá̱ pɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ua̱ngui̱ xta̱ nzä xqui dä ma̱ mɛ̱nyu̱gä p'ʉ ja ra̱ banco. Nu̱'mø ma̱ søhø, ua̱ngui̱ xti̱ ndäcrá̱ nzäbi ma̱ mɛ̱nyu̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nu̱na̱ ra̱ hmu̱ p'ʉya bi 'yɛ̱mbyø mɛfi 'bʉp'ʉ: “Nu̱na̱ ra̱ mɛfi 'bʉcua, da̱mi̱ hyannba̱ui'a̱ n'na ma̱hua̱hi̱ ra̱ mɛ̱nyu̱ ha̱. Da̱mi̱ u̱nnui ra̱ mɛ̱nyu̱'a̱ ra̱ mɛfi ha̱ 'dɛt'a ma̱hua̱hi̱ ra̱ mɛ̱nyu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque nu̱'a̱ ra̱ mɛfi ya xa̱ngu̱ ra̱ mɛ̱nyu̱ ha̱, gue'a̱ ma̱n'natho ma̱ t'u̱nni̱'a̱. Pɛ nu̱'a̱ ra̱ mɛfi zits'ʉtho ha̱, da̱ tha̱nnba̱bi̱'a̱ zits'ʉ ra̱ mɛ̱nyu̱ ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A nu̱na̱ ra̱ mɛfi hi̱ngui̱ nne te da̱ mɛfi, da̱mi̱ 'yɛmhmʉ p'ʉ thi na̱. Ja di̱ nzomp'ʉ 'nɛ̱ ja di gu̱xpʉ yø ts'i”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nu̱na̱ ra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱, 'mø bá̱ ɛ̱hɛ̱ ngue di̱ nda̱st'abi, da̱ n'youi yø anxɛ. Nu̱p'ʉ da̱ mi̱, ja di̱ njap'ʉ ra̱ ts'ʉt'abi. ");
INSERT INTO otnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gätho yø ja̱'i̱ 'bʉ'a̱ nxi̱mhäi ja di̱ mpɛti p'ʉ di̱ hu̱ti̱. Di 'ueque n'na ngu̱ n'na yø ja̱'i̱ tengu̱tho ra̱ mändɛ'yo 'mø sicyø chivo p'ʉ ha 'bʉhyø dɛ'yo. ");
INSERT INTO otnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nu̱'ʉ yø dɛ'yo di go'a̱ n'yɛi, nu̱'ʉ yø chivo di go'a̱ nga̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nu̱'a̱ ra̱ da̱st'abi da̱ 'yɛ̱mbyø ja̱'i̱ di gop'ʉ ja rá̱ n'yɛi: “Bí 'yɛ̱hmʉ ua dí 'bʉi, di ja̱p'a̱hʉ ma̱ Papá. Porque ngu̱'a̱ bá̱ sänni̱ ngue di̱ nja hante ngue di̱ nhohra̱ xi̱mhäi, ngue nu̱ua ha dí ma̱nda ja guí̱ m'mʉhmʉ ua. ");
INSERT INTO otnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porque nu̱gä dá̱ ntu̱ ma̱nthu̱hu̱, pɛ gá̱ 'dacjʉ ra̱ hmɛ̱ dá̱ si. Nu̱'mø ma̱ nthu̱the, gá̱ 'dacjʉ ra̱ dehe dá̱ si. Nu̱'mø ma̱ n'yo n'nanni̱ n'na ra̱ häi, gá̱ 'dacjʉ ra̱ ts'äya. ");
INSERT INTO otnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nu̱'mø hi̱n'yʉ ra̱ u̱lu ga̱ he, gá̱ 'dacjʉ ra̱ u̱lu dá̱ he. Nu̱'mø ma̱ hyɛ̱nni̱, gá̱ ma güi zɛnguaga̱hʉ. Nu̱'mø ma̱ o ra̱ fädi, gá̱ ma güa̱ nu̱jʉ”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nu̱ya yø ja̱'i̱ ya bi̱ nhohyø ts'oqui, da̱ 'yɛ̱mbra̱ Hmu̱: “Ague grá̱ Hmu̱, ¿nja̱m'mø dá̱ nu̱'a̱he ngue gui tu̱ ma̱nthu̱hu̱, 'nɛ̱ dá̱ 'da'a̱he ra̱ hmɛ̱ gá̱ si? ¿Nja̱m'mø dá̱ nu̱'a̱he ngue guí tu̱the, 'nɛ̱ dá̱ 'da'a̱he ra̱ dehe gá̱ si? ");
INSERT INTO otnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nja̱m'mø dá̱ nu̱'a̱he ngue gá̱ n'yo n'nanni̱ n'na ra̱ häi, 'nɛ̱ dá̱ 'da'a̱he ra̱ ts'äya? ¿Nja̱m'mø dá̱ nu̱'a̱he ngue hi̱n'yʉ ra̱ u̱lu gui hye, 'nɛ̱ dá̱ 'da'a̱he ra̱ u̱lu gá̱ hye? ");
INSERT INTO otnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nja̱m'mø dá̱ nu̱'a̱he ngue gá̱ hyɛ̱nni̱, ogue gá̱ 'yo ra̱ fädi, 'nɛ̱ dá̱ ma di zɛngua'a̱he?” ");
INSERT INTO otnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nu̱'a̱ ra̱ da̱st'abi da̱ 'yɛ̱mbyø ja̱'i̱: “Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue nu̱'a̱ te gä gá̱ 'yørpa̱hʉ ya ma̱ cu̱gä 'bʉcua, ma̱da̱gue'a̱ hi̱ngui̱ nnu̱ ma̱nsu̱ yø ja̱'i̱, pɛ nu̱ te ra̱ 'bäxte gá̱ 'yørpa̱hʉ ya, go gá̱ fäxca̱hʉ'a̱”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ra̱ da̱st'abi p'ʉya da̱ 'yɛ̱mbyø ja̱'i̱ ni̱ gop'ʉ ja rá̱ ga̱ha̱: “Da̱mi̱ 'uehmʉ ua dí 'bʉi, porque hi̱ngui̱ nnu̱ ma̱nho'a̱hʉ Oja̱. A nu̱yá, guí̱ mmähä ra̱ castigo ja ra̱ sibi i ja para za̱ntho. Guehna̱ ra̱ sibi bi zän'Oja̱ ngue di̱ ma ra̱ zithu̱ co 'nɛ̱'ʉ yø anxɛ tɛnni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porque nu̱gä, nu̱'mø ma̱ ntu̱ ma̱nthu̱hu̱, hi̱ngá̱ 'dacjʉ ra̱ hmɛ̱ xcá̱ si. Nu̱'mø ma̱ ntu̱nthe, hi̱ngá̱ 'dacjʉ ra̱ dehe xcá̱ si. ");
INSERT INTO otnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Dá̱ n'yo n'nanni̱ n'na ra̱ häi, pɛ hi̱ngá̱ 'dacjʉ ra̱ ts'äya. Ja'mø hi̱n'yʉ ra̱ u̱lu ga̱ he, pɛ hi̱ngá̱ 'dacjʉ ra̱ u̱lu xcá̱ he. Bi̱ nja ra̱ ora dá̱ hyɛ̱nni̱, 'nɛ̱ dá̱ o ra̱ fädi, pɛ hi̱ngá̱ ma güi zɛnguaga̱hʉ”. ");
INSERT INTO otnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mi̱ da̱'ʉ yø ja̱'i̱ ts'o p'ʉya, bi 'yɛ̱mbra̱ Hmu̱: “Ague grá̱ Hmu̱, ¿nja̱m'mø dá̱ nu̱'a̱he ngue guí tu̱ ma̱nthu̱hu̱, 'nɛ̱ hi̱ndá̱ 'da'a̱he ra̱ hmɛ̱ xqui si? ¿Nja̱m'mø dá̱ nu̱'a̱he ngue gui tu̱the, 'nɛ̱ hi̱ndá̱ 'da'a̱he ra̱ dehe xqui si? ¿Nja̱m'mø dá̱ nu̱'a̱he ngue gá̱ n'yo n'nanni̱ n'na ra̱ häi, 'nɛ̱ hi̱ndá̱ 'da'a̱he ra̱ ts'äya? ¿Nja̱m'mø dá̱ nu̱'a̱he ngue hi̱n'yʉ ra̱ u̱lu gui hye, 'nɛ̱ hi̱ndá̱ 'da'a̱he ra̱ u̱lu xqui hye? ¿Nja̱m'mø dá̱ nu̱'a̱he ngue gá̱ hyɛ̱nni̱, ogue gá̱ 'yo ra̱ fädi, 'nɛ̱ hi̱ndá̱ ma xca̱bi zɛngua'a̱he?” ");
INSERT INTO otnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ra̱ da̱st'abi p'ʉya da̱ 'yɛ̱mbi̱: “Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue nu̱'mø hi̱n tema̱ 'bäxte gui 'yørpa̱hʉ ya yø ja̱'i̱ 'bʉcua hi̱ngui̱ nnu̱ ma̱nsu̱ yø ja̱'i̱, go gueque hi̱nguí̱ nne gui fäxca̱hʉ”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nu̱ya yø ja̱'i̱ ya, guehya da̱ ma ra̱ castigo para za̱ntho ya. A nu̱'ʉ yø ja̱'i̱ ya bi̱ nhohyø ts'oqui, di t'u̱nna̱ te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ra̱ Jesús, mi̱ juadi bi̱ ma̱ gätho ya yø hya̱ ya, bi 'yɛ̱mbyø xädi: ");
INSERT INTO otnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Guí pa̱hmʉ ngue ma̱nyo patho di̱ nja ra̱ ngo ngue ra̱ pascua ya. Da̱ gue'mø ɛdi ja ra̱ ngo da̱ ma ma̱ dä ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ngue da̱ ma ma̱ cuati ra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nu̱'ʉ yø hmu̱ yø mmäcja̱ conyø xännba̱te ngue ra̱ ley, conyø n'yohʉ 'bɛt'o ngue yø judío, gä bi̱ mpɛti p'ʉ ja rá̱ ngu̱ ra̱ Caifás, nu̱na̱ ra̱ 'bɛt'o mmäcja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ja bi̱ nhɛca̱ hya̱ p'ʉ, bi zänni̱ ha di japi ngue di bɛntra̱ Jesús da̱ hyo. ");
INSERT INTO otnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nu̱na̱ ra̱ hya̱ bi zänni̱, di̱ n'yɛ̱mbi̱: ―Hi̱nga̱ gue'mø ɛra̱ ngo di̱ mbɛnt'i̱, n'namhma̱ ngue hi̱nda̱ nangyø ja̱'i̱, da̱ ya̱ni̱ ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nu̱na̱ ra̱ Jesús, ya 'bʉp'ʉ ja ra̱ hni̱ni̱ Betania ja rá̱ ngu̱ ra̱ Simu̱ nu̱na̱ xi 'yøthe m'mɛt'o ngue mi̱ 'ya rá̱ do'yo. ");
INSERT INTO otnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nu̱na̱ ra̱ Jesús, ya si̱hmɛ̱ p'ʉ ja ra̱ mɛ̱xa. Nu̱'a̱ ra̱ ora'a̱, bi yʉt'a̱mbo n'na ra̱ xisu ni̱ du̱ n'na ra̱ m'mo aceite ngue ra̱ alabastro. I yu̱p'ʉ ra̱ aceite ma̱zihotho ga̱ yʉni̱, xa̱ndøngu̱ rá̱ mu̱ui. Bi xispa̱bi̱ ra̱ aceite rá̱ ya̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nu̱'ʉ yø xädi ra̱ Jesús mi̱ nu̱ te øtra̱ xisu, bi̱ mbøcuɛ p'ʉya, bi 'yɛ̱mbi̱: ―¿Hanja ngue bi̱ ma ma̱'ʉni̱tho na̱ ra̱ aceite na̱? ");
INSERT INTO otnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xa̱ndøngu̱ rá̱ mu̱ui na̱, xta̱ nzä xta̱ 'bä ngue xti t'u̱nna̱ mɛ̱nyu̱ yø hyoya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mi̱ 'yøhra̱ Jesús te mma̱nyø xädi, bi 'yɛ̱mbi̱: ―Oguí sʉhmʉ na̱ ra̱ xisu 'bʉcua, porque xa̱nho te ørque. ");
INSERT INTO otnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A nu̱ya yø hyoya guí̱ mma̱mhmʉ, hangu̱ ra̱ pa guí̱ nnu̱hʉ ya yø hyoya. Pɛ nu̱gä hi̱nga̱ nza̱mhmʉ ua. ");
INSERT INTO otnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A nu̱na̱ ra̱ aceite bi xisca̱ ma̱ ya̱ na̱ ra̱ xisu, ya bi̱ nja'a̱ te mi̱ ja ngue xti̱ nja'mø dá̱ n'yägui. ");
INSERT INTO otnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱p'ʉ ha da̱ hma̱nna̱ hoga̱ 'da'yo hya̱ gä rá̱ ngʉni̱ nxi̱mhäi, xquet'a̱ 'nɛ̱'a̱ te bi 'yørca̱gui̱ na̱ ra̱ xisu, da̱ hma̱. Gue'a̱ di fɛn'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nu̱na̱ ra̱ Judas Iscariote, guehna̱ n'na nc'ɛ̱i̱'ʉ 'dɛ'ma̱ yoho yø xädi ra̱ Jesús, bi̱ ma bá̱ nya̱ui yø hmu̱ yø mmäcja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Bi 'yɛ̱mbi̱: ―¿Hangu̱ ra̱ mɛ̱nyu̱ guí̱ nne gui 'dacjʉ n'namhma̱ ga̱ dä'a̱hʉ ra̱ Jesús? ―bi 'yɛ̱mbi̱. Nu̱'ʉ yø mmäcja̱ p'ʉya, 'däte ma̱'dɛt'a yø mɛ̱nyu̱ ngue ra̱ t'axi bi u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ja̱na̱ngue nu̱na̱ ra̱ Judas, bi hyoni̱ ha di japi ngue di däpyø mmäcja̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ya fʉhra̱ ngo nguehya yø pa ts'i ra̱ thu̱hmɛ̱ hi̱ngui̱ n'youi ra̱ íxi. Bi guatyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hapʉ guí̱ nne ga̱ hocähe ra̱ nzibde gdá̱ nsänni̱gohʉ ngue ra̱ pascua ya? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø xädi: ―Ni̱ mɛ nʉ bí ja ra̱ hni̱ni̱ ya, gui sømmi̱ p'ʉ ja rá̱ ngu̱ n'na ra̱ n'yohʉ. Gui 'yɛ̱nui: “Ra̱ xännba̱te i ɛ̱na̱: Ya bi zønna̱ ora ya. Nu̱ua ja ni̱ ngu̱ ja ga̱ sägähe ua ra̱ ngo ngue ra̱ pascua, comma̱ xädi, ɛ̱n'a̱ mma̱”, guí 'yɛ̱nui. ");
INSERT INTO otnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nu̱ya yø xädi mi̱ ya̱ui ra̱ Jesús, bi 'yøt'e te bi xifi. Nu̱p'ʉ ja ra̱ ngu̱ bi zøni̱, ja bi hojpʉ ra̱ nzibde ngue ra̱ pascua. ");
INSERT INTO otnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mi̱ dähra̱ nde p'ʉya, nu̱na̱ ra̱ Jesús, gätho'ʉ 'dɛ'ma̱ yoho yø xädi, gä 'bʉp'ʉ ja ra̱ mɛ̱xa. ");
INSERT INTO otnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mɛ̱nte si̱hmɛ̱ p'ʉya, bi 'yɛ̱mbyø xädi: ―Nu̱yá, dí xi'a̱hʉ ngue 'bʉcua n'na nc'ɛ̱i̱ ngue jʉga̱tho häi, ya xa̱ hyoni̱ ha di japi ngue di dägui. ");
INSERT INTO otnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nu̱ya yø xädi ra̱ Jesús ɛ̱mmɛ̱i̱ bi du̱ yø mmʉi na̱ ra̱ hya̱ bi xifi. Bi̱ mʉdi bi 'yänni̱ 'da mi̱'da p'ʉya te'o na̱ i̱ mma̱, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿ua go guecä'a̱ guí̱ mma̱nya? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱na̱ dí com'me ma̱ mohi ua dí si̱hmɛ̱ ya, guehna̱ di dägä na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ma̱jua̱ni̱ ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, da̱ tho'a̱ te ra̱ n'ʉ ja ngue da̱ thogui, tengu̱tho nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue di̱ nja. Pɛ hague ngu̱ ra̱ castigo da̱ thohna̱ ra̱ n'yohʉ ja ngue di dägui. Nu̱na̱ ra̱ n'yohʉ na̱, ma̱n'na xa̱nho ngue'mø hi̱n xta̱bá̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nu̱na̱ ra̱ Judas ja ngue di dä p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ¿ua go guecä na̱ ra̱ hya̱ guí̱ mma̱nya? ―bi 'yɛ̱mbi̱. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mthobi: ―A̱há̱, go gue'e tengu̱tho guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mɛ̱nte si̱hmɛ̱ p'ʉya, bi hya̱jma̱n'na ra̱ thu̱hmɛ̱ ra̱ Jesús. Mi̱ ja ma̱mma̱di̱ Oja̱ p'ʉya, bi xɛnna̱ thu̱hmɛ̱, bi u̱nyø xädi ngue da̱ zi. Bi 'yɛ̱mbi̱: ―Da̱mi̱ sihʉ ra̱ thu̱hmɛ̱ ja ua ya. Nu̱ná̱, guehna̱ ma̱ do'yogä na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bi dɛcra̱ vaso po rá̱ ngui ra̱ uva p'ʉya. Mi̱ ja ma̱mma̱di̱ Oja̱, bi u̱nyø xädi ngue da̱ zi 'da'its'ʉ. Bi 'yɛ̱mbi̱: ―Da̱mi̱ si gätho'a̱hʉ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nu̱na̱ po ra̱ vaso ja ua ya, guehna̱ ma̱ jigä na̱. Porque guehna̱ ra̱ hmɛ̱ya na̱ya ngue nu̱'mø dá̱ tu̱, di̱ nja rá̱ ts'ɛdi ra̱ 'da'yo cohi øt'a̱hʉ Oja̱. Porque nu̱'a̱ di̱ mfämma̱ ji, xa̱ndøngu̱ yø ja̱'i̱ di̱ nhohyø ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A nu̱yá, dí xi'a̱hʉ ngue ya hi̱nni̱ mantho 'dap'ʉ ga̱ sihʉ rá̱ ngui ra̱ uva, asta̱ gue'mø bi zønna̱ pa ngue ma̱'da'yo hønga̱ sihʉ p'ʉ ha di̱ ma̱nda ma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mi̱ juate ra̱ nsi̱hmɛ̱ p'ʉya, bi du̱ta̱ n'na ra̱ thu̱hu̱ ngue ɛ̱spa̱bi̱ Oja̱. Bi̱ ma p'ʉya, i̱ map'ʉ bí ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos. ");
INSERT INTO otnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Gätho'a̱hʉ ya, gui soga̱hʉ p'ʉ'a̱ di̱ nxu̱i̱. Porque di̱ nja'a̱ te mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Ga̱ øt'ä ngue da̱ du̱ ra̱ mändɛ'yo. Yø dɛ'yo p'ʉya di̱ n'uɛ̱ni̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pɛ nu̱'mø dá̱ bɛ̱nna̱te, ga̱ni̱ mpagä Galilea ja ga̱ni̱ tøp'a̱hʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ra̱ Bɛdu p'ʉya bi 'yɛ̱mbi̱: ―Ma̱da̱gue'a̱ ngue gätho da̱ zoc'a̱'i̱ p'ʉ ya mi̱'da ma̱ n'yohʉ, pɛ nu̱gä hi̱nga̱ soc'a̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ra̱ Jesús bi 'yɛ̱mbra̱ Bɛdu: ―Ma̱jua̱ni̱ dí xi'i ngue nu̱'a̱ di̱ nxu̱i̱ ya, nu̱'mø tobe hi̱ndi̱ ma̱hra̱ øni̱, ya xqui cønga̱ nhyu̱ndi̱, guí̱ mma̱ ngue hi̱nguí̱ pa̱qui̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pɛ ra̱ Bɛdu p'ʉya ma̱høn'a̱ ɛ̱na̱: ―A, nu̱'a̱, hi̱n'na̱'a̱. Ma̱da̱gue'a̱ ngue 'dap'ʉ ga̱ tu̱ui, pɛ nu̱gä hi̱nga̱ cøn'a̱'i̱ ―bi 'yɛ̱mbi̱. Gätho'ʉ mi̱'da yø xädi p'ʉya, 'da'igu̱ bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nu̱na̱ ra̱ Jesús bi̱ mähä yø xädi, bi zømp'ʉ ja ra̱ xɛqui ni̱ hu̱ ngue Getsemaní. Nu̱p'ʉ bi zøni̱, bi 'yɛ̱mbi̱: ―Da̱mi̱ mi̱hmi̱ ua ya, mɛ̱nte ga̱ thocä mi̱ts'ʉ ni̱ nguehnʉ ngue ga̱ ma mat'Oja̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bi thohmi̱ts'ʉ ni̱ nguep'ʉ ra̱ Jesús, bi̱ mɛ ra̱ Bɛdu 'nɛ̱ bi̱ mɛ'ʉ yoho yø ts'ʉnt'ʉ ra̱ Zebedeo. Bi̱ mʉdi bi där'ma̱n'ʉ rá̱ mmʉi ra̱ Jesús, ma̱thoguitho ngue bi du̱ rá̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Bi 'yɛ̱mbyø n'youi p'ʉya: ―Ja̱njua̱ni̱ ngue tu̱ ma̱ mmʉigä, nu̱p'ʉ nná̱ sä, ya ja ngue 'bexca̱ tu̱. Da̱mi̱ cohmi̱ ua ya, pɛ 'yogui a̱hmi̱. Ma ga̱ ä ma̱ t'a̱ha̱hʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ra̱ Jesús bi thohmi̱ts'ʉ ní̱ nguep'ʉ. Bi̱ m'mɛmfo häi p'ʉya ngue mmat'Oja̱. Bi 'yɛ̱na̱: ―Ague ma̱ Papá'i, nu̱'mø guí̱ nnu̱ ma̱nho, da̱mi̱ ya̱ngui̱ ngue'a̱ ra̱ nda̱te ja ngue ga̱ thocä. Pɛ hi̱nga̱ nu̱'a̱ go ga̱ sännä gue'a̱ di̱ nja'a̱, sinoque nu̱ te guí sänni̱, gue'a̱ di̱ nja'a̱ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mi̱ juadi bi̱ mat'Oja̱ p'ʉya, bí 'yɛ̱p'ʉ 'bʉ'ʉ hyu̱ yø xädi. Pɛ bi di̱ni̱ ngue ya mi̱ a̱ha̱. Bi 'yɛ̱mbra̱ Bɛdu p'ʉya: ―¿Ua xi̱nga̱ n'na ora di sä guí 'yä ni̱ t'a̱ha̱hʉ n'yø? ");
INSERT INTO otnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Da̱mi̱ mat'Oja̱, 'yogui a̱hmʉ. Nu̱'mø hi̱ngá̱ mat'Oja̱hʉ, ntha̱mbɛni̱tho hi̱nda̱ gue'a̱ gui 'yøthʉ. I̱ nne ni̱ mmʉi ngue gui 'yøthʉ na̱ ra̱ hya̱ dí̱ mma̱ngä, pɛ ɛ̱mmɛ̱i̱ cuen'ni̱ do'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ma̱hømbi̱ zop'ʉ yø xädi, bi̱ mengbʉ xpi 'yɛ̱hɛ̱ ngue bá̱ mat'Oja̱. Bi 'yɛ̱na̱: ―Ague ma̱ Papá'i, nu̱'mø ya hi̱nguí̱ nnu̱ ma̱nho ngue gui̱ nya̱ngui̱ ngue'a̱ ra̱ nda̱te ja ngue ga̱ thogui, di̱ nja'a̱ te ni̱ pähä 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma̱mbá̱ pengbʉya, ma̱hømbi̱ di̱nyø xädi ngue mi̱ a̱ha̱, porque ɛ̱mmɛ̱i̱ ne tha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma̱hømbi̱ zop'ʉ p'ʉya, bi̱ ma'a̱ rá̱ hyu̱ ndi̱ ngue bá̱ mat'Oja̱. Tengu̱tho xi man'a̱ m'mɛt'o, ngu̱t'a̱ ra̱ hya̱ xi Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ma̱hømbi̱ 'yɛ̱p'ʉ 'bʉhyø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Gue ma̱hønguí̱ a̱hmi̱ n'yø. A nu̱yá, ya bi zønna̱ ora ngue di̱ ndäpyø ts'oc'ɛ̱i̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Da̱mi̱ nangüi. Ya bá̱ ɛ̱cua na̱ di dägui, ma ga̱ ma c'athʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mɛ̱nte nzohyø xädi ra̱ Jesús, bi zøhna̱ ra̱ Judas rá̱ n'youi'ʉ 'dɛ'ma̱ yoho yø xädi, bá̱ n'youi xa̱ngu̱ yø ja̱'i̱, bá̱ gʉ yø juai, bá̱ gʉ yø za. Guehya yø ja̱'i̱ xi̱ mɛnhyø hmu̱ yø mmäcja̱ conyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nu̱na̱ ra̱ Judas, ya xi xihyø ja̱'i̱ tema̱ senya da̱ 'yøt'e, xi 'yɛ̱mbi̱: “Nu̱'a̱ ra̱ n'yohʉ ga̱ zɛnguagä ya, 'nɛ̱ ga̱ sʉrpa̱ rá̱ hmi̱, gue'a̱ guí homhmʉ'a̱ p'ʉya. Da̱mi̱ bɛnthʉ”, xi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ja̱na̱ngue mi̱ zømp'ʉ 'bähra̱ Jesús, bi guat'i ngue bi zɛngua. Bi 'yɛ̱mbi̱: ―Xca̱de grá̱ xännba̱te ―bi 'yɛ̱mbi̱. Bi zʉrpa̱ rá̱ hmi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague amigo, ya da̱ guehra̱ ora jap'ʉ di̱ nja'a̱ te gni̱ 'yɛ̱hya. 'Bexque'a̱ bi bɛntyø ja̱'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mi̱ ma ma̱ bɛnt'i̱ ra̱ Jesús, bi gʉxrá̱ juai'a̱ n'na nc'ɛ̱i̱ rá̱ xädi. Bi zɛnnba̱bi̱ rá̱ 'yɛ̱hɛ̱ ra̱ 'bɛt'o mmäcja̱, bi hyɛjpa̱bi̱ rá̱ gu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ra̱ Jesús bi 'yɛ̱mbra̱ zɛte: ―Da̱mi̱ fos'ni̱ juai. Porque ra̱ ja̱'i̱ hote conna̱ juai, xquet'a̱ conna̱ juai ja ngue di du̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ua hi̱nguí̱ pa̱di̱ ngue nu̱'mø ga̱ äpä ma̱ Papá ngue da̱ mäxqui, da̱ pɛnnga̱gui̱ tho'i 'dɛ'ma̱ yo'bʉi yø anxɛ ngue da̱ mäxqui? ");
INSERT INTO otnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pɛ nu̱'mø ngu̱'a̱ ga̱ øt'e, ya hi̱nda̱ zä di̱ nja'a̱ te ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro 'mø. Porque nu̱ te dí thocä ya, ya nt'ot'i ngue ngu̱'a̱ di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ra̱ Jesús bi 'yɛ̱mbyø nzite: ―¿Ua guí ɛ̱mhmʉ ngue drá̱ bɛ̱gä, ngue guí cʉhʉ yø juai, 'nɛ̱ guí cʉhʉ yø za ngue guí bɛnnga̱hʉ? Conque n'na pa ngu̱ n'na pa nmi̱ xännbä ra̱ hya̱ yø ja̱'i̱ p'ʉ ja ra̱ ni̱ja̱. Ua̱ngui̱ xta̱ nzä ngue ja xqui bɛnnga̱hʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pɛ nu̱ te guí ørca̱hʉ ya, ya bi̱ nja'a̱ te ra̱ hya̱ bi 'yotyø pønga̱hya̱ Oja̱ p'ʉ ja ra̱ Ma̱ca̱ Libro ―bi 'yɛ̱mbi̱. Gä bi zop'ʉ yø xädi ra̱ Jesús ngue bi 'dagui. ");
INSERT INTO otnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nu̱na̱ ra̱ Jesús bi ts'ixpʉ 'bʉhra̱ Caifás, nu̱na̱ ra̱ 'bɛt'o mmäcja̱. Nu̱p'ʉ ja rá̱ ngu̱ na̱ ra̱ mmäcja̱ na̱, ja bi̱ mpɛti p'ʉ yø xännba̱te ngue ra̱ ley, conyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pɛ ra̱ Bɛdu ni̱ 'bɛfa ya'atho p'ʉ ni̱ ma yø ja̱'i̱ ni̱ zi ra̱ Jesús. Mi̱ zømp'ʉ ja rá̱ ngu̱ ra̱ 'bɛt'o mmäcja̱, bi yʉt'a̱mbo ra̱ da̱thi. 'Dap'ʉ bi̱ mi̱hmi̱ yø policía. I tø'mi̱ tengu̱ da̱ thohra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nu̱'ʉ yø hmu̱ yø mmäcja̱ co 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o ngue yø judío, 'dap'ʉ bi̱ mpɛti ngue bi̱ nhɛca̱ hya̱, honi̱ ha di japyø fɛhni̱, da̱ 'yɛ̱mbi̱ ngue ni̱ 'yu̱p'ʉ da̱ du̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pɛ hi̱ngui̱ ti̱ni̱ ha di japra̱ hya̱, madague'a̱ xa̱ngu̱ yø ja̱'i̱ bi̱ ma̱nyø fɛhni̱ ngue di̱ ya̱pra̱ Jesús. M'mɛfa p'ʉya, ma̱hømbi̱ guar'mi̱ yonc'ɛ̱i̱ ngue di̱ ya̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, bi 'yɛ̱n'a̱ n'na ndi̱: “Nu̱gä da̱ zä ga̱ xorpa̱bi̱ rá̱ ni̱ja̱ Oja̱, 'nɛ̱ nhyu̱ patho gdá̱ hojma̱n'na ra̱ ni̱ja̱ ma̱'da'yo”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bi̱ m'mähra̱ 'bɛt'o mmäcja̱ p'ʉya ngue bi 'yɛ̱mbra̱ Jesús: ―¿Te guí̱ mma̱nna̱ ra̱ hya̱ gui̱ nya̱p'a̱'i̱ ya n'yø? ¿Ua hi̱n tema̱ hya̱ gdi tha̱di̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pɛ ra̱ Jesús hi̱nte ga̱ nda̱tho. Ra̱ 'bɛt'o mmäcja̱ p'ʉya ma̱hømbi 'yɛ̱mbi̱: ―Nu̱na̱ Oja̱ i 'bʉi, da̱mi̱ 'yɛ̱xa̱ ntestigo, da̱mi̱ xicje njua̱ni̱ ya ngue'mø ma̱jua̱ni̱ gue'e grá̱ Cristo rá̱ Ts'ʉnt'ʉ'i Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―A̱há̱, go guecä tengu̱tho ra̱ hya̱ guí̱ mma̱nya. 'Nɛ̱ dí xi'a̱hʉ, gui̱ nnu̱hʉ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ni̱ mmi̱p'ʉ bí ja rá̱ n'yɛi Oja̱ nu̱na̱ jasɛ rá̱ ts'ɛdi. 'Nɛ̱ da̱ 'yɛhra̱ pa ngue hønda̱ ɛ̱hɛ̱, di 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ n'youi ra̱ gu̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mi̱ 'yøhra̱ mmäcja̱ na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, n'na xɛt'itho rá̱ pahni̱ ngue bi̱ ncuɛ. Bi 'yɛ̱mbyø ja̱'i̱ p'ʉya: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, thenma̱hya̱ Oja̱ na̱. Nu̱ya mfa̱di̱ ya ngue hi̱n tema̱ ma̱n'na ma̱ testigo dí homhmʉ ya. Ya gá̱ 'yøsɛhʉ ya ngue thenma̱hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Xiya, ¿te guí̱ mma̱mhmʉ na̱ ra̱ hya̱ bi̱ ma̱nya? ―bi 'yɛ̱mbyø ja̱'i̱. Yø ja̱'i̱ p'ʉya bi 'yɛ̱na̱: ―Nu̱na̱, ni̱ 'yu̱p'ʉ ngue da̱ tho na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yø ja̱'i̱ p'ʉya bi zospa̱bi̱ rá̱ hmi̱ ra̱ Jesús 'nɛ̱ bi̱ mʉt'i. Mi̱'da p'ʉya bi̱ mɛmba̱ rá̱ hmi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Yø ja̱'i̱ bi 'yɛ̱mbra̱ Jesús: ―Nu̱'i̱ guí̱ mma̱ ngue grá̱ Cristo, da̱mi̱ pa̱hya te'o bi̱ mɛp'a̱'i̱ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ya hu̱p'ʉ ja ra̱ da̱thi̱ ra̱ Bɛdu. Nu̱na̱ n'na ra̱ xisu ngue ra̱ gʉni̱ p'ʉ ja ra̱ ngu̱ bi guarbʉ hu̱ ra̱ Bɛdu. Bi 'yɛ̱mbi̱: ―'Nɛ̱'i̱ ni̱ n'youi ra̱ Jesús nu̱na̱ ra̱ mmɛngu̱ Galilea. ");
INSERT INTO otnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ra̱ Bɛdu p'ʉya, nu̱na̱ ra̱ hya̱ bi̱ ma̱, gä bi 'yøhyø ja̱'i̱ mi̱ 'bʉp'ʉ ngue bi 'yɛ̱na̱: ―Hi̱n'na̱, hi̱ndí̱ pa̱cä tema̱ hya̱ guí̱ nne gui xicya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ra̱ Bɛdu p'ʉya i̱ map'ʉ bí ja rá̱ goxthi ra̱ da̱thi. Mi̱ nu̱ ma̱n'na ra̱ xisu p'ʉya, ma̱hømbi̱ 'yɛ̱mbyø ja̱'i̱ 'bʉp'ʉ: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, xquet'a̱ rá̱ n'youi ra̱ Jesús nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret. ");
INSERT INTO otnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ra̱ Bɛdu p'ʉya asta̱ bi 'yɛ̱xa̱ ntestigo Oja̱ ngue bi 'yɛ̱na̱: ―Hi̱n'na̱, hi̱ndí̱ pa̱cä na̱ ra̱ n'yohʉ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mi̱ tho hma̱n'na ts'ʉquits'ʉ p'ʉya, nu̱'ʉ yø ja̱'i̱ 'bʉp'ʉ, bi guatra̱ Bɛdu, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue ni̱ n'youi ra̱ Jesús, porque di̱ nɛ̱qui̱ ngue ni̱ mmɛ̱ngu̱hʉ'a̱, xøgue nt'ødetho'a̱ te gni̱ ya̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mi̱ da̱hra̱ Bɛdu p'ʉya, ma̱hømbi 'yɛ̱na̱: ―Da̱ jacä ra̱ castigo Oja̱ 'mø ngue hi̱mma̱ jua̱ni̱ te dí xi'a̱hʉ. Pɛ nu̱na̱ ra̱ n'yohʉ guí xicjʉ, hi̱ndí̱ pa̱cä te'o na̱. Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱, bi̱ mmahra̱ øni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ra̱ Bɛdu p'ʉya bi zo rá̱ mmʉi na̱ ra̱ hya̱ xi xihra̱ Jesús ngue xi 'yɛ̱mbi̱: “Tobe hi̱ndi̱ ma̱hra̱ øni̱, ya xqui cønga̱ nhyu̱ndi̱, guí̱ mma̱ ngue hi̱ngui̱ pa̱qui̱”, xi 'yɛ̱mbi̱. Ra̱ Bɛdu p'ʉya, asta̱ ra̱ zondu̱mmʉi bi bøn'a̱thi. ");
INSERT INTO otnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mi̱ nɛ̱ca̱häi p'ʉya, bi̱ mpɛti gätho yø hmu̱ yø mmäcja̱ conyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱. Bi̱ nhɛca̱hya̱ ngue sänni̱ ha di japi da̱ hyo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bi du̱tra̱ Jesús ngue bi zixpʉ 'bʉhra̱ Pilato ma̱rá̱ gobierno. ");
INSERT INTO otnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nu̱na̱ ra̱ Judas xi dä ra̱ Jesús, mi̱ ba̱di̱ ngue ya bi̱ nhɛca̱hya̱ yø ja̱'i̱ ngue da̱ hyo ra̱ Jesús, bi där'ma̱n'ʉ rá̱ mmʉi p'ʉya. Bi̱ map'ʉ bí 'bʉhyø hmu̱ yø mmacja̱ co 'nɛ̱'ʉ yø n'yohʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱. Bi cospa̱bi̱'ʉ 'däte ma̱'dɛt'a yø mɛ̱nyu̱ ngue ra̱ t'axi xi u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Bi 'yɛ̱mbi̱: ―Ra̱ ts'oqui dá̱ øt'ä ngue dá̱ dä'a̱hʉ na̱ ra̱ n'yohʉ hi̱nte ndu̱pa̱te ngue da̱ tho ―bi 'yɛ̱mbi̱. Pɛ nu̱'ʉ yø mmäcja̱ p'ʉya, bi 'yɛ̱mbra̱ Judas: ―Nu̱'a̱ guí̱ mma̱nya, ya hi̱ndi̱ mportagähe'a̱ ya. Ya gui̱ nnu̱sɛ p'ʉ te guí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nu̱na̱ ra̱ Judas bá̱ ɛnyø mɛ̱nyu̱ p'ʉ ja ra̱ ni̱ja̱. Bi̱ ma p'ʉya, bi da̱trá̱ 'yʉga conna̱ ntha̱hi̱ i̱ nzʉdi ngue bi du̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nu̱p'ʉ ja ra̱ ni̱ja̱ p'ʉya, nu̱'ʉ yø hmu̱ yø mmäcja̱ bi hya̱xra̱ mɛ̱nyu̱ xi 'yɛnna̱ Judas, di̱ n'yɛ̱mbi̱: ―Nu̱yá, hi̱ngui̱ sä ngue ga̱ ua̱nspa̱hʉ ra̱ mɛ̱nyu̱ ngue ra̱ ofrenda na̱ya, porque rá̱ nzabi'a̱ to bi dä ra̱ ja̱'i̱ ngue da̱ tho na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bi̱ nya̱ p'ʉya, bi zänni̱ ngue nu̱na̱ ra̱ mɛ̱nyu̱, da̱ dän'a̱ n'na ra̱ häi ni̱ hu̱ ngue ra̱ nja̱ts'øye. Bi̱ ne ngue nu̱na̱ ra̱ häi da̱ däi, ja da̱ 'yäp'ʉ yø ja̱'i̱ da̱ du̱, ngue hi̱ngyø mmɛ̱ngu̱ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja̱na̱ngue nu̱na̱ ra̱ häi na̱ya, gui hu̱tyø ja̱'i̱ ngue ra̱ Ji. ");
INSERT INTO otnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ya bi̱ nja na̱ te ra̱ hya̱ xi ma̱nna̱ pønga̱hya̱ Jeremías ngue bi 'yɛ̱na̱: “Bi̱ njo'ʉ 'däte ma̱'dɛt'a yø mɛ̱nyu̱ ngue ra̱ t'axi. Guehna̱ ra̱ nzäbi xi zänyø judío ngue da̱ gu̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nu̱na̱ ra̱ mɛ̱nyu̱ na̱ p'ʉya, guehna̱ i thänna̱ häi ni̱ hu̱ ngue ra̱ nja̱ts'øye na̱. Ya bi̱ nja tengu̱tho ra̱ hya̱ bi 'bɛjpa̱gui̱ Oja̱ ngue di̱ nja”, bi 'yɛ̱nna̱ Jeremías. ");
INSERT INTO otnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ra̱ Jesús bi ts'ixpʉ 'bʉhra̱ gobierno. Ra̱ gobierno p'ʉya bi 'yɛ̱mbra̱ Jesús: ―¿Ua gue'e rá̱ da̱st'abi'i yø judío? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―A̱há̱, go guecä tengu̱tho ra̱ hya̱ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nu̱'ʉ yø hmu̱ yø mmäcja̱ p'ʉya co 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱, gä di ya̱pra̱ Jesús. Pɛ ra̱ Jesús hi̱nte ga̱ nda̱tho te sifi. ");
INSERT INTO otnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ra̱ Pilato bi 'yɛ̱mbra̱ Jesús: ―¿Ua hi̱nguí̱ øde te gäma̱ hya̱ gui̱ nya̱p'a̱'i̱ ya? ");
INSERT INTO otnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pɛ ngu̱tho ra̱ Jesús hi̱ngui̱ tha̱di̱. Ja̱na̱ngue ra̱ gobierno di 'yøtho ngue hi̱n tema̱ hya̱ ga̱ nda̱tho. ");
INSERT INTO otnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nu̱na̱ ra̱ Pilato, ja n'na rá̱ costumbre ngue di thø'a̱ n'na ra̱ ofädi 'mø ja ra̱ ngo ngue ra̱ pascua. Pɛ yø ja̱'i̱'ʉ huanhni̱ ndana̱ ra̱ ofädi da̱ ma ma̱thøgue. ");
INSERT INTO otnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, mi̱ ofädi n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Barrabás. 'Nɛ̱ gätho yø ja̱'i̱ pa̱di̱ ngue xa̱nhɛ̱ts'i̱ rá̱ ts'oqui mi̱ ja na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nu̱p'ʉ bi̱ mpɛti yø ja̱'i̱, ra̱ Pilato bi 'yɛ̱mbyø ja̱'i̱: ―¿Ndana̱ guí̱ nnehʉ ngue ga̱ thøcä ya, ra̱ Barrabás, uague ra̱ Jesús nu̱na̱ gui hu̱tyø ja̱'i̱ ngue ra̱ Cristo? ");
INSERT INTO otnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngu̱na̱ bi xihyø ja̱'i̱ ra̱ Pilato, ngue bi̱ ne xti thohra̱ Jesús. Porque pa̱di̱ ngue ra̱ nts'ɛyatho øtyø mmäcja̱ nu̱ya xi däpra̱ Pilato na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ya hu̱p'ʉ ja rá̱ nhu̱di̱ ra̱ Pilato ngue da̱ 'yøtra̱ ts'ʉt'abi. Pɛ nu̱'a̱ rá̱ xisu ra̱ Pilato bi̱ mɛnnba̱bi̱ ra̱ hya̱, bi 'yɛ̱mbi̱: “Nu̱na̱ ra̱ n'yohʉ 'yost'abi, ra̱ hoja̱'i̱ na̱, 'yo tega̱ di̱ nthi̱nt'i̱ ngue'a̱ te ga̱ 'yost'abi na̱. Porque ma̱nxu̱i̱ nts'u̱tho te xtá̱ 'ui̱pi̱ ngue da̱ thogui”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pɛ yø hmu̱ yø mmäcja̱ conyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱ ɛ̱mmɛ̱i̱ di ha̱tra̱ ts'ɛdi yø ja̱'i̱ ngue da̱ 'yäpra̱ Pilato ngue di thø ra̱ Barrabás, go da̱ tho ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ra̱ gobierno ma̱hømbi 'yɛ̱mbyø ja̱'i̱: ―¿Ndana̱ gue'a̱ ya yonc'ɛ̱i̱ guí nnehʉ ngue da̱ ma ma̱thøgue ya? Yø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Da̱ ma ma̱thøgue ra̱ Barrabás. ");
INSERT INTO otnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ra̱ Pilato ma̱hømbi̱ 'yørpa̱ ra̱ nt'änni̱ yø ja̱'i̱, bi 'yɛ̱mbi̱: ―Xina̱ ra̱ Jesús gui hu̱tyø ja̱'i̱ ngue ra̱ Cristo, ¿te guí̱ nnehʉ ga̱ japä na̱? ―bi 'yɛ̱mbi̱. Yø ja̱'i̱ p'ʉya, gätho bi 'yɛ̱na̱: ―Da̱ guatra̱ pont'i̱ na̱ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ra̱ Pilato p'ʉya bi 'yɛ̱mbyø ja̱'i̱: ―Pɛ ¿tema̱ nts'o xa̱ 'yø'na̱ p'ʉya? Yø ja̱'i̱ p'ʉya, ma̱n'natho ngue mafi, bi 'yɛ̱na̱: ―Da̱ guatra̱ pont'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ra̱ Pilato p'ʉya bi ba̱di̱ ngue hi̱nda zä ha di japi di thøhra̱ Jesús. Porque ma̱thoguitho mahyø ja̱'i̱ ngue ncuɛ. Bi̱ ma̱nda bá̱ tha̱nnba̱ ra̱ dehe p'ʉya ngue yø hmi̱ yø dä yø ja̱'i̱ p'ʉ bi̱ nxʉ'yɛ. Bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, hi̱nte ndu̱pa̱te na̱. Hi̱mma̱ ts'oquigä p'ʉ ngue da̱ tho na̱. Ya gui̱ nnu̱sɛhʉ p'ʉ te guí øthʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yø ja̱'i̱ p'ʉya bi 'yɛ̱na̱: ―Nu̱gähe co 'nɛ̱hma̱ ba̱si̱he, go ma̱ ts'oquigähe p'ʉ da̱ du̱ na̱ ra̱ n'yohʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ra̱ Pilato p'ʉya bi̱ ma̱nda ngue bi̱ ma ma̱thøgue ra̱ Barrabás. A nu̱na̱ ra̱ Jesús, bi sityø soldado ngue da̱ fɛi, 'nɛ̱ da̱ zits'i ngue di cuatra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nu̱'ʉ yø soldado ra̱ gobierno bi zixra̱ Jesús, i̱ map'ʉ ja rá̱ da̱thi ra̱ cuarte. Bi̱ ma ma̱pɛti gätho yø soldado p'ʉya ngue di̱ mäts'i. ");
INSERT INTO otnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yø soldado p'ʉya bi̱ møjpa̱bi̱ rá̱ he ra̱ Jesús, bi heta̱ n'na ra̱ tu̱hu̱ ngue ra̱ jʉpoi. ");
INSERT INTO otnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yø soldado ya xi me n'na ra̱ corona ngue yø 'ui̱ni̱, bi gäspa̱ rá̱ ya̱ ra̱ Jesús. Bi gärpa̱ n'na ra̱ t'o rá̱ 'yɛ ngue rá̱ n'yɛi. 'Nɛ̱ bi̱ nda̱ntyøhmu̱ p'ʉ ha 'bähra̱ Jesús tengu̱tho 'mø ngue ma̱jua̱ni̱ hnu̱ ma̱nsu̱ n'na ra̱ da̱st'abi. I thenma̱hya̱ p'ʉya, bi 'yɛ̱mbi̱: ―I ta̱te na̱ rá̱ da̱st'abi yø judío ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bi zots'i. Bi guaspa̱bi̱ ra̱ t'o mi̱ fo rá̱ 'yɛ p'ʉya, di jännba̱bi̱ rá̱ ya̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mi̱ juadi bi denma̱hya̱ p'ʉya, bi ga̱jpa̱bi̱ ra̱ tu̱hu̱ xi hete. Bi hetrá̱ he ya mi̱ he p'ʉya. Bi zixpʉya ngue di cuatra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nu̱p'ʉ ja ra̱ 'yu̱, bi̱ nthɛui p'ʉ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ hni̱ni̱ Cirene, ni̱ hu̱ ngue ra̱ Simu̱. Nu̱'ʉ yø soldado ma̱ni̱ zi ra̱ Jesús, bi japra̱ Simu̱ ngue bi du̱xra̱ pont'i̱ nu̱na̱ da̱ ma ma̱cuati ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nu̱na̱ ra̱ Jesús, i zixyø ja̱'i̱ p'ʉ ja ra̱ xɛqui ni̱ hu̱ ngue Gólgota. Nu̱na̱ ra̱ hya̱ na̱ i̱ nne da̱ ma̱ ngue ra̱ Njʉya̱xhmu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nu̱p'ʉ bi zønna̱ Jesús, bi t'u̱nna̱ vino n'youi ra̱ mirra para ngue di pu̱mbɛ̱ni̱bi. Mi̱ zä te ja p'ʉya, hi̱mbi̱ ne bi zi. ");
INSERT INTO otnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bi cuatra̱ pont'i̱ p'ʉya, mi̱ juadi bi̱ nø'mi̱. Bi̱ ma ra̱ ta̱ha̱ yø soldado p'ʉya ngue to xta̱ ra̱ ta̱ha̱, gue'a̱ da̱ ga̱ca̱ n'na xɛqui rá̱ he ra̱ Jesús. Ya bi̱ nja tengu̱tho ra̱ hya̱ bi̱ ma̱nná̱ pønga̱hya̱ Oja̱ 'mø yø pa xa̱thogui ngue bi 'yɛ̱na̱: “Da̱ ma ra̱ ta̱ha̱ yø ja̱'i̱ ngue to di tocabi ma̱ he”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bi̱ mi̱hyø soldado p'ʉya ngue hɛ̱tho te di ja ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nu̱p'ʉ ja rá̱ ya̱ ra̱ pont'i̱ cuatra̱ Jesús, bi̱ ma ma̱cuati n'na ra̱ letrero xi 'yot'i ngue mma̱mp'ʉ te bi̱ ma ma̱'ʉpi. Nu̱na̱ ra̱ letrero, i ɛ̱na̱: “Nu̱na̱ ra̱ n'yohʉ 'bʉcua, guehna̱ ra̱ Jesús rá̱ da̱st'abi yø judío na̱”, ɛ̱nna̱ letrero. ");
INSERT INTO otnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","'Nɛ̱ yoho yø bɛ̱ bi̱ ma ma̱cuati ra̱ pont'i̱, n'na i gohrá̱ n'yɛi, n'na i gohrá̱ ga̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Asta̱ hua̱tyø ya̱ yø ja̱'i̱ thop'ʉ ja ra̱ pont'i̱ cuatra̱ Jesús ngue thenni̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","I ɛ̱mbi̱: ―A nu̱ya n'yø, da̱mi̱ xorpa̱bi̱ rá̱ ni̱ja̱ Oja̱ ya. 'Nɛ̱ guí ɛ̱na̱ ngue nhyu̱ patho gdi hojma̱n'na ra̱ ni̱ja̱. Da̱mi̱ nya̱nsɛ ya, bá̱ ca̱p'ʉ ja ra̱ pont'i̱ guí cuatya ngue'mø ma̱jua̱ni̱ rá̱ Ts'ʉnt'ʉ'i Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nu̱'ʉ yø hmu̱ yø mmäcja̱ conyø xännba̱te ngue ra̱ ley, conyø fariseo, conyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱, gä thenma̱hya̱ ra̱ Jesús. Di̱ n'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Mi̱ mma̱nnʉ ra̱ n'yohʉ ngue da̱ ya̱nyø ja̱'i̱. Pɛ nu̱yá, hi̱nda̱ zä ha di japi di̱ nya̱nsɛ ya. A nu̱'mø ma̱jua̱ni̱ ngue rá̱ da̱st'abi yø judío ya, da̱ zä da̱ ca̱hnʉ ja ra̱ pont'i̱ ya n'namhma̱ ngue ga̱ ɛ̱c'ɛ̱i̱hʉ te da̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mi̱ mma̱ ngue rá̱ Ts'ʉnt'ʉ Oja̱, 'nɛ̱ mi̱ mma̱ ngue fäx Oja̱. A nu̱yá, ma ga̱ nnu̱hʉ ya ngue'mø nne Oja̱ ya, da̱ mäx'mø ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nu̱ya yø bɛ̱ 'dap'ʉ cuathʉ ra̱ pont'i̱ ra̱ Jesús 'nɛ̱hya thenma̱hya̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mi̱ hyu̱xyadi p'ʉya, bi̱ m'mɛxu̱i̱ gä ra̱ xi̱mhäi asta̱ hyu̱nde. ");
INSERT INTO otnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nu̱'mø ni̱ ma da̱ zʉ'i hyu̱nde p'ʉya, ra̱ Jesús ra̱ ndøts'ɛdi bi 'yɛ̱na̱: ―Elí, Elí, ¿lama sabactani? ―bi 'yɛ̱na̱. I̱ nne da̱ ma̱nna̱ ra̱ hya̱ na̱: “Ma̱ Oja̱'i̱, ma̱ Oja̱'i̱, ¿hanja ngue gá̱ hyɛga̱gui̱ p'ʉ?” ");
INSERT INTO otnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ja mi̱ 'bärpʉtho 'da yø ja̱'i̱, bi 'yøde te bi̱ ma̱nna̱ Jesús. Yø ja̱'i̱ p'ʉya di̱ n'yɛ̱mbi̱: ―Nu̱na̱ ra̱ n'yohʉ na̱, i̱ nzohra̱ Elías. ");
INSERT INTO otnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Bexque'a̱ bi̱ ma n'na nc'ɛ̱i̱ mi̱ 'bäp'ʉ, bá̱ ha̱ n'na xɛqui ra̱ esponja xa̱ ntu̱di̱, bi pop'ʉ ja ra̱ vino xa̱n'ixi. Bi̱ nøtra̱ t'o p'ʉya ngue bi cuarpa̱bi̱ rá̱ ne ra̱ Jesús ngue da̱ zʉts'i. ");
INSERT INTO otnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pɛ mi̱'da yø ja̱'i̱ 'bäp'ʉ bi 'yɛ̱mbi̱: ―Ma̱ ga̱ nnu̱hʉ ya ngue'mø da̱ ɛ̱hna̱ ra̱ Elías i̱ nzofo ngue da̱ ya̱nya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ra̱ ndøts'ɛdi bi 'yɛn'a̱ n'na rá̱ hmafi ra̱ Jesús. Bi du̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, nu̱'a̱ ra̱ u̱lu mi̱ zʉp'ʉ ja ra̱ goxthi ni̱ja̱, bi xɛt'i, i ga̱i̱. 'Nɛ̱ bi 'ya̱n'a̱häi, yø t'øhø bi hyegue. ");
INSERT INTO otnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bi xohyø panteón mi̱ o yø ánima. Bi bɛ̱nna̱te xa̱ngu̱ yø ja̱'i̱ mi̱ ɛ̱c'ɛ̱i̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nu̱'mø mi̱ bɛ̱nna̱te, bi bømp'ʉ ja yø panteón. Pɛ nu̱'mø mi̱ bɛ̱nna̱te m'mɛfa ra̱ Jesús, nu̱ya yø ja̱'i̱ xi bɛ̱nna̱te bi̱ map'ʉ ja ra̱ ma̱ca̱ hni̱ni̱ Jerusalén. Ja bi̱ nu̱p'ʉ xa̱ngu̱ yø ja̱'i̱ ngue ya 'bʉi ma̱høn'a̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nu̱'a̱ ra̱ capita co 'nɛ̱hyø soldado 'bäp'ʉ ni̱ hyandra̱ Jesús. Mi̱ nu̱ ya p'ʉya ngue bi 'ya̱n'a̱häi 'nɛ̱ bi̱ nu̱ te gä bi 'yøtra̱ Jesús mɛ̱nte bi du̱. Ɛ̱̱mmɛ̱i̱ bi̱ nsu̱, di̱ n'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue nu̱na̱ ra̱ n'yohʉ na̱, rá̱ ts'ʉnt'ʉ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Xa̱ngu̱ yø xisu yap'ʉtho ma̱mbi̱ 'bäi ngue hantho te gä bi̱ nja. Nu̱ya yø xisu ya, bá̱ nɛ̱xa̱ Galilea ngue bá̱ tɛn'mø ma̱ni̱ ma Jerusalén ra̱ Jesús. 'Nɛ̱ guehya yø xisu mi̱ fäts'i ngue di u̱nni̱ te mi̱ honi̱. ");
INSERT INTO otnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nu̱ya yø xisu ya, n'youi p'ʉ ra̱ Ma̱ya nu̱na̱ ra̱ mmɛ̱ngu̱ Magdala, co 'nɛ̱hna̱ ra̱ Ma̱ya rá̱ mamá ra̱ Jacobo 'nɛ̱hra̱ José, co 'nɛ̱hna̱ ma̱n'na ra̱ xisu, rá̱ mamá'ʉ yoho yø ts'ʉnt'ʉ ra̱ Zebedeo. ");
INSERT INTO otnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ya ni̱ ma da̱ dähra̱ nde p'ʉya, bi zø'a̱ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱mmɛti ni̱ hu̱ ngue ra̱ José, ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ hni̱ni̱ Arimatea. Xquet'a̱ 'nɛ̱hna̱ ma̱rá̱ xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nu̱na̱ ra̱ José, bi̱ ma bá̱ nya̱ui ra̱ Pilato, bá̱ äpra̱ nt'ɛ̱di̱ ngue da̱ hya̱jpa̱ rá̱ do'yo ra̱ Jesús. Ra̱ Pilato p'ʉya bi u̱nna̱ nt'ɛ̱di̱ ngue da̱ tha̱cra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nu̱na̱ ra̱ José, mi̱ hya̱jpʉ ja ra̱ pont'i̱ ra̱ Jesús, bi 'uɛnnba̱bi̱ rá̱ do'yo co n'na ra̱ sábana ma̱'da'yo. ");
INSERT INTO otnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ra̱ José ya xi 'yambʉ ja ra̱ t'øhø n'na ra̱ 'da'yo panteón ngue xta̱ 'yo 'mø xta̱ ndu̱, ja bi gärbʉ ra̱ Jesús. Bi gotra̱ goxthi co n'na ra̱ ndø do. Bi̱ ma p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A nu̱na̱ ra̱ Ma̱ya ngue ra̱ mmɛ̱ngu̱ Magdala co 'nɛ̱hna̱ ma̱n'na ra̱ Ma̱ya, hu̱rpʉtho gä i̱ ma nt'ägui ra̱ ánima ya. ");
INSERT INTO otnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ya ra̱ pa ngue ra̱ ts'äya 'mø mi̱ hyats'i. Nu̱'ʉ yø hmu̱ yø mmäcja̱ conyø fariseo bi̱ ma bá̱ nya̱ui ra̱ Pilato. ");
INSERT INTO otnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bi 'yɛ̱mbi̱: ―Ague grá̱ ts'ʉt'abi, nu̱'mø mi̱ ya̱ na̱ ra̱ fɛhni̱ n'yohʉ bi̱ du̱, mi̱ ɛ̱na̱ ngue nu̱'mø bi gua'a̱ nhyu̱ pa xta̱ ndu̱, di bɛ̱nna̱te p'ʉ da̱ nt'ägui. ");
INSERT INTO otnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ja̱na̱ngue nu̱yá, da̱mi̱ 'yɛtyø soldado ngue da̱ fädi ha o ra̱ ánima asta̱ gue'mø bi tho'a̱ rá̱ hyu̱ pa xa̱ t'ägui. Ya hi̱nda̱ zäp'ʉ da̱ ma yø xädi 'mø ra̱ xu̱i̱ ngue da̱ hya̱xra̱ ánima, m'mɛfa p'ʉya da̱ hyätyø ja̱'i̱, da̱ 'yɛ̱mbi̱ ngue ya bi bɛ̱nna̱te. Ya ma̱n'natho bi thär'ma̱nts'ojʉ p'ʉya ngue m'mɛt'o. ");
INSERT INTO otnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ra̱ Pilato bi 'yɛ̱mbyø mmäcja̱: ―'Bʉp'ʉ yø soldado guí ähmʉ. Ni̱ mähä, bi fäthʉ ra̱ panteón, pɛ da̱mi̱ segurahʉ xa̱ndønho. ");
INSERT INTO otnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Gä bi̱ ma p'ʉya ngue bá̱ fädi xa̱nho ra̱ panteón. Bi̱ mɛ̱pyabi rá̱ njo'mi̱ ra̱ panteón. Bá̱ sop'ʉ'ʉ yø soldado ngue yø mädi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nu̱'a̱ ra̱ pa ngue ra̱ ts'äya ya bi thogui. Mi̱ hyaxa̱ ndomingo rá̱ mʉdi ra̱ pa ngue ra̱ semana. Nu̱na̱ ra̱ Ma̱ya ra̱ mmɛ̱ngu̱ Magdala co 'nɛ̱'a̱ ma̱n'na ra̱ Ma̱ya bi̱ ma ngue bá̱ nu̱ ra̱ panteón. ");
INSERT INTO otnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nu̱'mø ya ni̱ ma da̱ zøni̱, ntha̱mbɛ̱ni̱tho bi 'ya̱n'a̱häi. Porque n'na rá̱ anxɛ Oja̱ bi 'yɛ̱ ma̱hɛ̱ts'i̱, bi zøp'ʉ ja ra̱ panteón. Bi du̱ntrá̱ do mi̱ co'mra̱ panteón. Ja bi hyu̱xpʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nu̱na̱ ra̱ anxɛ di yoxni̱ tengu̱tho ra̱ huɛi 'mø di yot'i. Rá̱ he p'ʉya, xa̱ndønt'axi. ");
INSERT INTO otnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yø soldado ngu̱ i̱ nu̱ ra̱ anxɛ, asta̱ ra̱ hua̱qui̱ ngue ra̱ ts'u̱. Ɛ̱̱ntho ya xi du̱ ngue ra̱ ngüent'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mi̱ sønya yø xisu, ra̱ anxɛ bi 'yɛ̱mbi̱: ―'Yo gui su̱ui. Porque dí pa̱cä ngue guí hommi̱ ra̱ Jesús nu̱na̱ bi cuatra̱ pont'i̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Da̱mi̱ nu̱ui ua bi 'bɛgui, ya hi̱njo'o ua, ya xa̱ bɛ̱nna̱te tengu̱tho ra̱ hya̱ bi xi'a̱hʉ 'mø mi̱ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A nu̱ya ni̱ mɛ n'nahma̱ntho ya, ni̱ xihmi̱ yø xädi ngue ya xa̱ bɛ̱nna̱te ra̱ Jesús 'nɛ̱ da̱ni̱ døp'a̱hʉ Galilea, ja gni̱ nu̱hʉ p'ʉ. Guehna̱ ja ngue ga̱ xi'a̱hʉ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nu̱'ʉ yø xisu p'ʉya, n'na zihma̱ntho bi̱ ma. Ma̱de di johya, ma̱di i su̱, pɛ ni̱ tihi ngue da̱ni̱ xipyø xädi te xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nu̱p'ʉ ja ra̱ 'yu̱ p'ʉya, mi̱ da̱mbɛ̱ni̱ ya bi̱ nthɛui ra̱ Jesús ngue di zɛngua. Nu̱'ʉ yø xisu p'ʉya bi guarbʉ 'bähra̱ Jesús ngue bi dospa̱ yø gua ha ga̱ nda̱nne. ");
INSERT INTO otnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ra̱ Jesús bi 'yɛ̱mbyø xisu: ―'Yo guí su̱ui ya. Ni̱ mɛ ya bá̱ xihmi̱'ʉ ma̱ cu̱gä ngue jatho da̱ ma Galilea, ja ga̱ni̱ nnu̱hʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mɛ̱nte ni̱ hya̱ ra̱ 'yu̱ yø xisu, nu̱ya 'da yø soldado mi̱ fähra̱ panteón, bi̱ map'ʉ ja ra̱ hni̱ni̱, bá̱ xipyø hmu̱ yø mmäcja̱ te gä xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yø mmäcja̱ p'ʉya, bi̱ ma bá̱ nya̱ui yø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱, bi gohra̱ acuerdo te 'bɛ'a̱ ja ngue da̱ 'yøt'e. Bi zännbʉya ngue nu̱ya yø soldado xi̱ nu̱p'ʉ xi bɛ̱nna̱te ra̱ Jesús, da̱ gu̱t'i̱ xa̱ngu̱ ra̱ mɛ̱nyu̱. ");
INSERT INTO otnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bi 'yɛ̱mbyø soldado: ―Nu̱ya gui 'yɛ̱mphʉ yø ja̱'i̱ ya: “Ma̱nxu̱i̱ xa̱ nzʉcje ra̱ t'a̱ha̱. Mɛ̱nte dí a̱hme p'ʉya, xa̱ nzøhyø xädi ra̱ Jesús ngue xa̱ hya̱ts'i̱”, gui 'yɛ̱mphʉ yø ja̱'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nu̱'mø da̱ ba̱hra̱ ts'ʉt'abi ngue guí̱ mma̱mmi̱ ngue xa̱ nzʉ'a̱hʉ ra̱ t'a̱ha̱, a nu̱'mø ngue da̱ zʉ'a̱hʉ, 'yo te gui̱ mbɛmhmʉ hi̱nte da̱ ja, go ga̱ hojpähe rá̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yø soldado p'ʉya, bi hya̱nna̱ mɛ̱nyu̱ bi t'u̱nni̱, bi̱ ma̱ tengu̱tho ra̱ hya̱ bi sifi ngue da̱ ma̱. Nu̱na̱ ra̱ hya̱ bi̱ ma̱nyø soldado, gue'a̱ ra̱ hya̱ sihyø judío'a̱ ya asta̱ guehra̱ pa ja p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nu̱'ʉ 'dɛ'ma̱'da yø xädi ra̱ Jesús i̱ ma Galilea. Nu̱p'ʉ ja ra̱ nyu̱ni̱ mi̱ mma̱nna̱ Jesús ngue di̱ nthɛhʉ, ja bi zømp'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ja̱ mi̱ nu̱ yø xädi ra̱ Jesús ngue ya 'bʉp'ʉ, gä bi da̱nne. Pɛ yobɛ̱ni̱ di'da ngue'mø ma̱jua̱ni̱ ngue gue'a̱ ra̱ Jesús ogue hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pɛ ra̱ Jesús bi guarbʉ ha 'bʉhyø xädi, bi 'yɛ̱mbi̱: ―Nu̱gä, bi̱ n'najhma̱ cargo ngue ga̱ ma̱nda ma̱hɛ̱ts'i̱ 'nɛ̱ cua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ja̱na̱ngue nu̱yá, dí xi'a̱hʉ ya ngue guí̱ mmähä gä rá̱ ngʉni̱ nxi̱mhäi. Da̱mi̱ hyoni̱ ha gdí japhʉ yø ja̱'i̱ ha di gohi ngue ma̱ xädi. Da̱mi̱ xixya̱ba̱hʉ yø ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱gui̱, gue'a̱ di̱ nɛ̱qui̱'a̱ ngue n'youi ra̱ Papá, n'youi rá̱ Ts'ʉnt'ʉ Oja̱, n'youi ra̱ Espíritu Santo. ");
INSERT INTO otnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nu̱ya te gäma̱ hya̱ xtá̱ xi'a̱hʉ gui 'yøthʉ, da̱mi̱ xännba̱hʉ yø ja̱'i̱ ngue da̱ngu̱'a̱ da̱ 'yøt'e. Da̱mi̱ pa̱hmʉ ngue dí̱ n'yohʉ hangu̱ ra̱ pa, asta̱ gue'mø da̱ni̱ njua'a̱ nxi̱mhäi. Da̱ ngu̱t'a̱tho.");
INSERT INTO otnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ja bi̱ mʉcua ra̱ hoga̱ 'da'yo hya̱, ngue mma̱ hanja na̱ ra̱ Jesucristo rá̱ Ts'ʉnt'ʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nu̱'mø yø pa xa̱ thogui, ra̱ pønga̱hya̱ Isaías bi̱ ma̱ hanja na̱ ra̱ hya̱ ja ngue di̱ nja m'mɛfa. Bi 'yɛ̱mbyø ja̱'i̱: “Nu̱na̱ Oja̱ bi 'yɛ̱mbrá̱ ts'ʉnt'ʉ: Nu̱yá, ga̱ ɛt'ä ma̱ m'mɛnhni̱, di̱ m'mɛt'o p'ʉ gdi̱ ma ngue di hoqui ha gui thogui, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Di̱ m'mʉp'ʉ ja ra̱ da̱po na̱ ra̱ m'mɛnhni̱. Nu̱'ʉ yø ja'i di̱ mpɛti p'ʉ di̱ m'mʉi, da̱ xifi te da̱ 'yøt'e, da̱ 'yɛ̱mbi̱: Da̱mi̱ nsähʉ ya, porque ya bá̱ ɛ̱p'ʉ ra̱ Hmu̱, da̱ 'yɛ̱mbyø ja̱'i̱”. ");
INSERT INTO otnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ya ma̱m'mɛt'o nt'ot'i ya yø hya̱ ya, pɛ ya bi̱ nja'mø yø pa mi̱ m'mʉp'ʉ ja ra̱ da̱po ra̱ Xuua. Nu̱na̱ ra̱ Xuua, bi xihra̱ hya̱ yø ja̱'i̱, 'nɛ̱ bi xixya̱bi̱. Bi 'yɛ̱mbi̱: ―Da̱mi̱ hyɛhmʉ p'ʉ ra̱ nts'o gni̱ 'yohʉ. Da̱mi̱ nxixya̱hʉ, n'namhma̱ ngue di pu̱n'na̱ ni̱ ts'oquihʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Xa̱ngu̱ yø ja̱'i̱ bi zøp'ʉ 'bʉhra̱ Xuua ngue øxra̱ hya̱ bi̱ ma̱. Bi zøp'ʉ yø ja̱'i̱ bá̱ nɛ̱xpʉ ja ra̱ hni̱ni̱ Jerusalén. Gä bi zøp'ʉ yø ja̱'i̱ 'bʉhyø hni̱ni̱ ja'a̱ ra̱ häi Judea. Nu̱ya yø ja̱'i̱ bi̱ ma̱ ngue ja yø ts'oqui, guehya bi xixya̱bi̱ ra̱ Xuua p'ʉ ja ra̱ da̱the Jordán. ");
INSERT INTO otnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nu̱ rá̱ he ra̱ Xuua, gue'ʉ yø xingu̱ ra̱ cameyo ntøt'e ra̱ u̱lu. Di̱ ngʉt'a̱ n'na ra̱ xifani̱. Nu̱'a̱ te si p'ʉya, yø mmäcja̱ t'a̱xi̱ mi̱ sa. 'Nɛ̱hra̱ t'afi t'asa ti̱mp'ʉ ja ra̱ da̱po mi̱ si. ");
INSERT INTO otnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Bi 'yɛ̱mbyø ja̱'i̱: ―Ya mi̱ ts'ʉdyø pa da̱ ɛ̱p'ʉ ma̱n'na ra̱ n'yohʉ ya. Pɛ ma̱n'natho ta̱te na̱ ngue nu̱gä. ¿Hapʉ gue ga̱ sʉcä tengu̱ na̱? ");
INSERT INTO otnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A nu̱gä, dá̱ xixya̱'a̱hʉ conna̱ dehe. Pɛ nu̱na̱ ra̱ n'yohʉ dí xi'a̱hʉ, guehna̱ da̱ 'yøt'e ngue di ha̱'a̱hʉ ra̱ ts'ɛdi ra̱ Espíritu Santo na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nu̱'ʉ yø pa'ʉ p'ʉya, nu̱p'ʉ ja ra̱ hni̱ni̱ Nazaret ngue ra̱ häi Galilea, ja bá̱ nɛ̱xpʉ ra̱ Jesús ngue bi zøp'ʉ 'bʉhra̱ Xuua. Ra̱ Xuua p'ʉya, bi xixya̱bi̱ p'ʉ ja ra̱ da̱the Jordán. ");
INSERT INTO otnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mi̱ nxixya̱ p'ʉya, bi̱ ma nenthe. Bi̱ nu̱ ra̱ Jesús ngue bá̱ xohra̱ c'ama̱hɛ̱ts'i̱. Bá̱ ɛ̱p'ʉ ra̱ Espíritu Santo, tengu̱tho n'na ra̱ paloma bi zøp'ʉ ja rá̱ ya̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bi t'ø p'ʉya ngue bá̱ nya̱ Oja̱ ma̱ya̱, bi 'yɛ̱na̱: ―Gue'e ma̱ Ts'ʉnt'ʉ, da̱di̱ ma̱'i̱. A nu̱yá, ja̱njua̱ni̱ ngue ja ga̱mpähä conná̱ ngue'e ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","'Bexque'a̱ ra̱ ora'a̱ p'ʉya, nu̱na̱ ra̱ Espíritu Santo bi zixpʉ ja ra̱ da̱po ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nu̱p'ʉ 'bʉhyø zate, ja bá̱ n'yop'ʉ nyote ma̱ pa ra̱ Jesús. Mɛ̱nte gue'ʉ yø pa'ʉ p'ʉya, ɛ̱mmɛ̱i̱ bi hyonna̱ zithu̱ ha di japra̱ Jesús ngue da̱ mɛstho ra̱ hya̱ di̱ ma̱nda Oja̱. Yø anxɛ Oja̱ p'ʉya, gue'ʉ bi̱ mäxra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mi̱ 'yɛ̱hra̱ pa ngue bi̱ n'ofädi ra̱ Xuua. Nu̱na̱ ra̱ Jesús, bi̱ mengui̱, i̱ map'ʉ ja ra̱ häi Galilea. Nu̱p'ʉ ha thogui, xihyø ja̱'i̱ ra̱ hoga̱ 'da'yo hya̱ ngue ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Ya da̱ guehyø pa jap'ʉya da̱ 'yu̱ Oja̱ ngue di̱ ma̱nda ua ya. A nu̱yá, da̱mi̱ hyɛhmʉ p'ʉ ra̱ nts'o gni̱ 'yohʉ. Da̱mi̱ 'yɛ̱c'ɛ̱i̱hʉ ra̱ hoga̱ 'da'yo hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nu̱p'ʉ ja ra̱ nenzabi Galilea, bi thop'ʉ n'na pa ra̱ Jesús. Ja bi di̱mp'ʉ yoho yø mahua̱ ngue di̱ n'yohʉ. Nu̱'a̱ n'na, ni̱ hu̱ ngue ra̱ Simu̱. Nu̱'a̱ ma̱n'na, ni̱ hu̱ ngue ra̱ Andre. Nu̱ya yonc'ɛ̱i̱ ya, mi̱ ɛntyø xit'a̱ p'ʉ ja ra̱ dehe ngue pahua̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mi̱ nu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma ga̱ mmähä n'yø. Ya hi̱ngyø hua̱ guí thɛui ya, sinoque ga̱ xän'na̱ui ha gdi thɛui yø ja̱'i̱ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","'Bexpi zop'ʉ yø xit'a̱ ngue bi̱ mähä ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mi̱ thohmi̱ts'ʉ ni̱nguep'ʉ p'ʉya, bi di̱mp'ʉ mi̱ yonc'ɛ̱i̱ di̱ n'yohʉ, ra̱ Jacobo 'nɛ̱hra̱ Xuua. Guehya yø ts'ʉnt'ʉ ra̱ Zebedeo. Mi̱ hu̱p'ʉ ja yø barco ngue pøtyø xit'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma̱hømbi xihra̱ Jesús ngue bi̱ mähä. Nu̱ya ts'its'i, bi̱ mähä ra̱ Jesús, bi zop'ʉ ja ra̱ barco yø papá co 'nɛ̱hyø hmi̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gä 'dap'ʉ ni̱ 'yo, bi zømp'ʉ ja ra̱ hni̱ni̱ Capernaum. Mi̱ zøhra̱ pa ngue säya yø ja̱'i̱, bi̱ map'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús ngue bi xännba̱ ra̱ hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mi̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ xännba̱te ra̱ Jesús, gä di 'yøtho. Porque nu̱'mø xännba̱te ra̱ Jesús, ɛ̱na̱ nts'ʉt'abitho ngue ya̱ ma̱nzaqui. Pɛ yø xännba̱te ngue ra̱ ley, hi̱ngui̱ njap'ʉ ga̱ ya̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mi̱ 'bʉp'ʉ ja ra̱ ni̱ja̱ n'na ra̱ n'yohʉ mi̱ n'youi ra̱ ts'onthi̱. Nts'ɛdi i zohra̱ Jesús, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Ague Jesús grá̱ mmɛ̱ngu̱ Nazaret, ¿hanja ngue ga̱di̱ nthi̱nt'ua dí 'bʉcähe? ¿Ua gní̱ 'yɛ̱hɛ̱ gui juacje? Nu̱gä dí pa̱di̱ te'o'i, go gue'e'a̱ ra̱ Ma̱ca̱ Ja̱'i̱ mi̱ ja ngue dá̱ pɛnhua Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pɛ ra̱ Jesús bi 'yɛ̱mbra̱ ts'onthi̱: ―Xa̱nhɛ̱n'i̱ grá̱ ts'onthi̱. Da̱mi̱ hyɛp'ʉ ra̱ n'yohʉ guí̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mi̱ 'yøhra̱ ts'onthi̱ na̱ ra̱ hya̱ sifi, nu̱'a̱ ra̱ n'yohʉ mi̱ n'youi ra̱ ts'onthi̱, asta̱ ra̱ päni̱ bi 'yɛn'a̱häi. Xøgue rá̱ mafi. Bi hyɛp'ʉ ra̱ ts'onthi̱ mi̱ n'youi ra̱ n'yohʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nu̱'ʉ yø ja̱'i̱ bi̱ nu̱ te bi̱ nja, gä di 'yøtho. Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na: ―Hi̱nja̱m'mø ha xtá̱ øhmʉ n'na ra̱ hya̱ tengu̱ xännba̱te na̱ ra̱ n'yohʉ 'bʉcua. Di̱ nɛ̱qui̱ ngue ja rá̱ ts'ɛdi, porque asta̱ 'nɛ̱hyø ts'onthi̱ ɛ̱c'ɛ̱i̱ 'mø xifi ngue da̱ hyɛp'ʉ ra̱ ja̱'i̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","N'na zihmantho bi̱ n'yo ra̱ hya̱ gä ra̱ häi Galilea, ngue di̱ nxihyø ja̱'i̱ te bi 'yøtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mi̱ bømp'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús, bi̱ mähä ra̱ Jacobo 'nɛ̱hra̱ Xuua co 'nɛ̱'ʉ mi̱'da yø xädi. I̱ map'ʉ ja rá̱ ngu̱ ra̱ Simu̱ 'nɛ̱hra̱ Andre. ");
INSERT INTO otnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nu̱'a̱ rá̱ to ra̱ Simu̱ oxpʉ ja rá̱ t'ots'i ngue hɛ̱mbra̱ pa. Mi̱ zønna̱ Jesús, bi sifi ngue di hyɛ̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bi yʉrbʉ ha 'bɛnna̱ därquɛ̱hi̱ ra̱ Jesús, bi bɛnnba̱ rá̱ 'yɛ ngue bi xots'i. 'Bexque'a̱ bi zä ra̱ pa mi̱ hɛ̱mbi̱. Nu̱na̱ ra̱ xisu mi̱'ʉ p'ʉya, guehna̱ bi hojpi te da̱ zi yø ja̱'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ya xi yʉhra̱ hyadi, ya bi̱ nxu̱i̱. Ma̱ndøngu̱ dyø ja̱'i̱ bi̱ map'ʉ 'bʉhra̱ Jesús. Bi zixyø därquɛ̱hi̱ co 'nɛ̱hyø ja̱'i̱ n'youi yø ts'onthi̱ bi zispi ngue da̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bi̱ mpɛti p'ʉ ja ra̱ goxthi gätho yø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ra̱ Jesús bi 'yøthe yø ja̱'i̱ ma̱di hyɛ̱nni̱. 'Nɛ̱ bi 'yøthe yø ja̱'i̱ mi̱ n'youi yø ts'onthi̱. Pɛ nu̱'ʉ yø ts'onthi̱ hi̱ndi̱ japi di̱ nya̱, porque yø ts'onthi̱ i̱ nne da̱ ma̱ te'o na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mi̱ hyaxpʉya, bi̱ nangma̱ xu̱di̱tho ra̱ Jesús. Tobe ra̱ 'bɛxu̱i̱tho 'mø mi̱ bømp'ʉ ja ra̱ hni̱ni̱, bi̱ ma da̱po ngue da̱ mat'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","M'mɛfa p'ʉya, bi̱ ma ra̱ Simu̱ co 'nɛ̱'ʉ mi̱'da yø xädi, ngue bi honi̱ hapʉ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mi̱ di̱mp'ʉya, bi 'yɛ̱mbi̱: ―Xa̱ndøngu̱ yø ja̱'i̱ søp'ʉ ja ra̱ ngu̱ ngue hon'a̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pɛ ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Ja ua mi̱'da yø hni̱ni̱ ga̱ mmähä ngue ga̱ ma ma̱mhmʉ ra̱ hoga̱ 'da'yo hya̱. Porque gue'a̱ dá̱ ɛ̱cä'a̱ ngue ga̱ mma̱nna̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bi̱ n'yo gä ra̱ häi Galilea ra̱ Jesús, sømp'ʉ ja yø ni̱ja̱ ngue mma̱nna̱ hoga̱ 'da'yo hya̱. 'Nɛ̱ øthe yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ma̱n'na ra̱ pa p'ʉya, nu̱p'ʉ 'bähra̱ Jesús, bi guat'a̱ n'na ra̱ n'yohʉ mi̱ hɛ̱mbra̱ ts'o'ya. Bi̱ nda̱ntyøhmu̱ p'ʉ ha 'bäi, bi 'yɛ̱mbi̱: ―Nu̱'mø guí̱ nne gui 'yørca̱ ra̱ ma̱te gui 'yøtheguits'ʉ, nu̱gä dí pa̱di̱ ngue da̱ zägui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ra̱ Jesús bi huɛ̱cra̱ n'yohʉ mi̱'ʉ, bi dots'i conná̱ 'yɛ. Bi 'yɛ̱mbʉya: ―A̱há̱, dí̱ nne ga̱ øthe'i. Da̱ zä'i ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Høntho bi̱ ma̱nna̱ ra̱ hya̱ na̱, nu̱na̱ ra̱ därquɛ̱hi̱ mi̱ 'ya rá̱ do'yo, 'bexpi zä ra̱ n'ʉ mi̱ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hante ngue di̱ n'yɛ̱hmi̱'a̱ ra̱ n'yohʉ, bi zɛmba̱ ma̱zaqui, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Nu̱yá, 'yo to guí xifi te dá̱ øt'a̱'i̱ ya. 'Be ni̱ ma ya, sømp'ʉ 'bʉhra̱ mmäcja̱. Da̱ nu̱ ngue ya bi zä'i. Da̱mi̱ 'yøtra̱ 'bøt'e tengu̱tho bi̱ ma̱nda ra̱ Moisés ngue da̱ 'yøtyø ja̱'i̱ 'mø bi zä ra̱ 'ya hɛ̱mbi̱. Ja̱na̱ngue da̱ ba̱di̱ gätho yø ja̱'i̱ ngue ya bi zä'i. ");
INSERT INTO otnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mi̱ ma ra̱ n'yohʉ p'ʉya, to bi zä ni̱ ja̱'i̱ xifi ngue ya xi 'yøthe ra̱ Jesús. Ja̱na̱ngue bi n'yo da̱po ra̱ Jesús, ya hi̱nga̱ ɛdi̱ 'yu̱p'ʉ ja yø hni̱ni̱, porque ma̱thoguitho di̱ mpɛti yø ja̱'i̱ 'mø bi̱ nu̱ ra̱ Jesús. Pɛ ma̱da̱gue'a̱ di̱ n'ya̱ni̱, ndap'ʉ bi zä ni̱ 'yɛ̱hyø ja̱'i̱, pap'ʉ bí 'bʉhra̱ Jesús ngue bi̱ nnu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma̱n'na ra̱ pa p'ʉya, bi̱ mengra̱ Jesús, i̱ map'ʉ ja ra̱ hni̱ni̱ Capernaum. Mi̱ ba̱hyø ja̱'i̱ ngue ya 'bʉp'ʉ ja rá̱ ngu̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","N'na zihmantho bi̱ mpɛti yø ja̱'i̱, asta̱ hi̱nni̱ 'yɛnyø ja̱'i̱ p'ʉ ja ra̱ goxthi. Nu̱na̱ ra̱ Jesús bi xännba̱ yø ja̱'i̱ rá̱ hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mɛ̱nte ya̱ ra̱ Jesús, bi zø hmi̱'da yø ja̱'i̱. Nu̱'ʉ goho nja̱'i̱ bá̱ du̱ n'na nc'ɛ̱i̱ bá̱ oxrá̱ fi̱di̱ ngue tu̱dyø gua. ");
INSERT INTO otnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bi̱ ne xti cʉtra̱ därquɛ̱hi̱ p'ʉ mbo ra̱ ngu̱ brá̱ 'bähra̱ Jesús. Pɛ hi̱mbi̱ zä xti cʉt'i, porque xa̱ndøngu̱ yø ja̱'i̱ 'bʉp'ʉ. Ja̱na̱ngue bi tets'a̱ ya̱nni̱gu̱ ra̱ därquɛ̱hi̱ p'ʉya. Bi xots'a̱ n'na xɛqui ra̱ 'bet'e ha brá̱ 'bähra̱ Jesús. Ja i ca̱mbʉ ra̱ därquɛ̱hi̱ ni̱ oxrá̱ fi̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mi̱ nu̱ te øtyø ja̱'i̱ ra̱ Jesús, i pa̱di̱ ngue ɛ̱c'ɛ̱i̱ yø ja̱'i̱ ngue da̱ zä da̱ 'yøthe ra̱ därquɛ̱hi̱. Bi 'yɛ̱mbra̱ därquɛ̱hi̱ p'ʉya: ―Ague ts'ʉnt'ʉ'i, ya dá̱ pu̱n'na̱ ni̱ ts'oqui ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nu̱'ʉ yø xännba̱te ngue ra̱ ley mi̱ hu̱p'ʉ, bi̱ mbøcuɛ 'mø mi̱ 'yø'a̱ ra̱ hya̱ mma̱nna̱ Jesús. Bi 'yɛ̱mp'ʉ ja yø n'yomfɛ̱ni̱: ");
INSERT INTO otnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nu̱na̱ ra̱ n'yohʉ 'bʉcua, thenma̱hya̱ Oja̱ na̱ co nu̱'a̱ ra̱ hya̱ i̱ mma̱. Porque hi̱njonda̱ zä di pu̱nnba̱ yø ts'oqui yø ja̱'i̱, hi̱nda̱ hønt'a̱ Oja̱ sä ngue da̱ 'yøtra̱ mpu̱nnbi̱”, ɛ̱mp'ʉ ja yø n'yomfɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pɛ ra̱ Jesús 'be xi pa̱tho te mbɛ̱mp'ʉ ja yø n'yomfɛ̱ni̱ ya yø xännba̱te ngue ra̱ ley. Bi 'yɛ̱mbʉya: ―¿Hanja ngue ngu̱na̱ guí̱ mbɛ̱mhmʉ? ");
INSERT INTO otnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nu̱gä dá̱ xihra̱ n'yohʉ 'bʉcua, dí ɛ̱mbi̱: “Ya dá̱ pu̱n'na̱ ni̱ ts'oqui ya”. Pɛ nu̱yá, hi̱ndi̱ nɛ̱qui̱ xa̱nho ngue'mø bi̱ mpu̱nnbi̱ ogue hi̱n'na. Pɛ nu̱'mø ga̱ ɛ̱mbi̱: “Da̱mi̱ nangui̱, gui ca̱xni̱ fi̱di̱, gui̱ mma”, ga̱ ɛ̱mbi̱, nu̱'mø ngue bi̱ n'yo p'ʉya, ya guí pa̱hmʉ xa̱nho ngue ja ma̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A nu̱yá, da̱mi̱ pa̱hmʉ ya ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ja rá̱ ts'ɛdi ua ja ra̱ xi̱mhäi ngue di pu̱nnba̱ yø ts'oqui yø ja̱'i̱. Bi 'yɛ̱mbra̱ n'yohʉ xa̱n'ʉ p'ʉya: ");
INSERT INTO otnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Nu̱gä dí xi'i, da̱mi̱ nangui̱, ca̱xni̱ fi̱di̱, ni̱ ma ni̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ra̱ därquɛ̱hi̱ p'ʉya, bi̱ nangui̱. Bi ga̱xrá̱ fi̱di̱, bi̱ ma rá̱ ngu̱. Nu̱'ʉ gätho yø ja̱'i bi̱ nu̱ te bi̱ nja, gä di 'yøtho. Yø ja̱'i̱ p'ʉya, ɛ̱spa̱bi̱ Oja̱, i ɛ̱na̱: ―Hi̱nja̱m'mø xtá̱ nu̱hʉ'a̱ te dá̱ nu̱hʉ bi̱ nja ya. ");
INSERT INTO otnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ma̱n'na ra̱ ora p'ʉya, ra̱ Jesús ma̱hømbi̱ map'ʉ ja ra̱ nenzabi. Pɛ ma̱ndøngu̱ dyø ja̱'i̱ bi̱ mpɛti p'ʉ ha 'bʉi, pɛ gä bi xännba̱bi̱ ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mi̱ tho p'ʉya, bi zømp'ʉ ja rá̱ oficina n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Leví. Guehna̱ rá̱ ts'ʉnt'ʉ ra̱ Alfeo, guehna̱ jʉmba̱ ra̱ mɛ̱nyu̱ yø ja̱'i̱ ja te pä. Mi̱ nu̱ ra̱ n'yohʉ na̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma ga̱ mmɛ n'yø, ga̱ øt'e ngue ma̱ xädi'i ―bi 'yɛ̱mbi̱. Nu̱na̱ ra̱ Leví bi zop'ʉ rá̱ oficina, bi̱ mɛ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma̱n'na ra̱ pa p'ʉya, nu̱na̱ ra̱ Jesús bi̱ mɛ yø xädi p'ʉ ja rá̱ ngu̱ ra̱ Leví ngue da̱ nsi̱hmɛ̱ui. Xa̱ngu̱ yø ngʉthäi 'bʉp'ʉ, da̱ gue hmi̱'da yø ja̱'i̱ t'ɛ̱mbi̱ ngue ja yø ts'oqui, gä 'dap'ʉ si̱hmɛ̱ui ra̱ Jesús. Porque xquet'a̱ 'nɛ̱hya nne da̱ dɛnna̱ hya̱ mma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pɛ nu̱'ʉ 'da yø xännba̱te ngue ra̱ ley, 'nɛ̱'da yø fariseo, mi̱ nu̱ te øtra̱ Jesús ngue 'dap'ʉ si̱hmɛ̱hʉ yø ja̱'i̱ nu̱'ʉ t'ɛ̱mbi̱ ngue ja yø ts'oqui. Nuya mbøcuɛ p'ʉya, bi 'yɛ̱mbya yø xädi ra̱ Jesús: ―Nu̱ ni̱ xännba̱tehʉ, hi̱ngui̱ ho ngue 'dap'ʉ si̱hmɛ̱hʉ yø ngʉthäi co 'nɛ̱hyʉ mi̱'da yø ja̱'i̱ ja xa̱ngu̱ yø ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mi̱ 'yøde te sipyø xädi ra̱ Jesús, bi 'yɛ̱mp'ʉ di ya̱hni̱ p'ʉya: ―Nu̱ya yø ja̱'i̱ di hyɛ̱nni̱, guehya ni̱ 'yɛ̱hra̱ 'yøthe ya. Pɛ yø ja̱'i̱ xa̱nzaqui, hi̱nga̱ gue'ʉ ni̱ 'yɛ̱'ʉ. A nu̱gä, dá̱ ɛ̱hɛ̱ ngue gue'ʉ yø ja̱'i̱ ja yø ts'oqui ga̱ xifi da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo, hi̱nga̱ gue'ʉ yø ja̱'i̱ ɛ̱na̱ ngue ya 'yo xa̱nho dá̱ ɛ̱hɛ̱ ga̱ nzofo. ");
INSERT INTO otnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma̱n'na ra̱ ora p'ʉya, bi̱ nti̱ni̱ ngue nu̱'ʉ yø xädi ra̱ Xuua 'nɛ̱'ʉ yø fariseo mi̱ ɛtyø mmʉi. Ja̱na̱ngue bi̱ ma 'da yø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hanja ni̱ xädi ngue hi̱ngui̱ ɛtyø mmʉi? Conque yø xädi ra̱ Xuua 'nɛ̱hyø fariseo ɛtyø mmʉi'ʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―Nu̱'ʉ yø ja̱'i̱ ts'ofo ngue da̱ nu̱ ra̱ ntha̱ti̱, hi̱ngui̱ ɛtyø mmʉi mɛ̱nte 'dap'ʉ 'bʉhmʉ ra̱ novio. Njarbʉtho ma̱ xädigä ya, hi̱ngui̱ ɛtyø mmʉi ngue 'daua dí̱ n'yo'be. Pɛ bá̱ ɛ̱p'ʉ ra̱ pa ngue da̱ ziga̱gui̱ ma̱ nsʉi'be. Nu̱'a ra̱ pa'a̱ p'ʉya, mfa̱di̱ ngue da̱ zä da̱ 'yɛtyø mmʉi ya ma̱ xädi 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nu̱na̱ ra̱ 'da'yo hya̱ dí xännba̱te, n'nan'yo na̱ ngue ra̱ nyogui xädi. Tengu̱tho n'na ra̱ 'da'yo u̱lu, hi̱nda̱ zä di 'bøtra̱ zɛ'u̱lu. Porque ra̱ 'da'yo u̱lu di̱ nga̱nts'i̱, ya ma̱n'na di̱ nts'onna̱ zɛ'u̱lu. ");
INSERT INTO otnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tengu̱tho ra̱ 'da'yo vino hi̱ngui̱ sä da̱ sirbʉ ja ra̱ zɛxfani̱ ngue da̱ zɛdi. Porque ra̱ 'da'yo vino da̱ xɛtra̱ zɛxfani̱ 'mø da̱ sit'i, ja di̱ m'mɛp'ʉ p'ʉya. Ja̱na̱ngue ra̱ 'da'yo vino, ra̱ 'da'yo xifani̱ da̱ sit'i. ");
INSERT INTO otnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Man'na ra̱ pa ngue säya yø ja̱'i̱ p'ʉya, nu̱na̱ ra̱ Jesús co 'nɛ̱hyø xädi bi tocabi bi thop'ʉ ja yø nua̱trigo. Nu̱ya yø xädi p'ʉya, bi daxtyø trigo bi za. ");
INSERT INTO otnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pɛ nu̱ya yø fariseo bi 'yɛ̱mbra̱ Jesús: ―¿Hanja ni̱ xädi ngue di̱ mpɛfi? Conque mma̱mp'ʉ ja ra̱ ley ngue nu̱'mø ra̱ pa ngue ra̱ ts'äya, hi̱ngui̱ sä ngue to di̱ mpɛfi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xi'mø mi̱ zʉhra̱ thu̱hu̱ n'na ndi̱ ra̱ David, co 'nɛ̱'ʉ mi̱ n'youi, ¿ua hi̱nja̱m'mø ga̱di xähmʉ p'ʉ ha nt'ot'i'a̱ te bi 'yøt'e? ");
INSERT INTO otnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Conque nu̱p'ʉ ja rá̱ ngu̱ Oja̱ mi̱ 'bʉhra̱ mmäcja̱ Abiatar, nu̱na̱ ma̱di̱ ma̱nda yø mmi̱mmäcja̱ui. Ja bi yʉrbʉ ra̱ David ngue bi zi yø thu̱hmɛ̱ xi t'ʉspa̱bi̱ Oja̱ ngue da̱ nu̱. Bi zi ra̱ David co 'nɛ̱'ʉ mi̱ n'youi. Conque nu̱'ʉ yø thu̱hmɛ̱'ʉ, hi̱ndi̱ u̱nna̱ nt'ɛ̱di̱ ra̱ ley ngue to bi zä da̱ zi, hi̱nda høndyø mmäcja̱ yø ts'i'ʉ yø thu̱hmɛ̱ t'ʉspa̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A nu̱yá, nu̱'a̱ te bi 'yøtya ma̱ xädigä, ua̱ngui̱ Oja̱ bá̱ sänni̱ bá̱ nja ra̱ pa ngue ra̱ ts'äya para ngue di di̱nna̱ nho yø ja̱'i̱. Hi̱ngue masque bi zän'Oja̱ ra̱ pa ngue ra̱ ts'äya ngue di̱ m'mʉmma̱n'ʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ja̱na̱ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ja rá̱ ts'ɛdi ngue nu̱'a̱ go da̱ zänni̱, gue'a̱ di̱ nja'mø ra̱ pa ngue ra̱ ts'äya'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ma̱n'na ra̱ pa p'ʉya, ma̱hømbi̱ map'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús. Nu̱p'ʉ ja ra̱ ni̱ja̱, mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ xi 'yotrá̱ 'yɛ. ");
INSERT INTO otnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yø fariseo p'ʉya, tøjtho te øtra̱ Jesús. I̱ nne da̱ nu̱ 'mø ngue di̱ n'øthe 'mø ra̱ pa ngue ra̱ ts'äya, para ngue da̱ zäp'ʉ di̱ ya̱pi̱, da̱ 'yɛ̱mbi̱ ngue hi̱ngui̱ su̱pra̱ ley. ");
INSERT INTO otnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pɛ ra̱ Jesús bi 'yɛ̱mbra̱ n'yohʉ xi 'yotrá̱ 'yɛ: ―Bá̱ nangui̱ n'yø, ga̱ 'bäcua ma̱de ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ya njua̱ntho bi zohyø fariseo p'ʉya, bi 'yɛ̱mbi̱: ―¿Te 'bɛ'a̱ ma̱ hya̱ mma̱mp'ʉ ja ra̱ ley ja ngue ga̱ øthʉ 'mø ra̱ pa ngue ra̱ ts'äya? ¿Ga̱ øthʉ ra̱ nho, ogue ra̱ n'ʉ? ¿Da̱ t'øthe ra̱ ja̱'i̱ 'mø xa̱n'ʉ, ogue di̱ njapi da̱ du̱? Nu̱'ʉ ts'o p'ʉya, hi̱nte ga̱ nda̱tho. ");
INSERT INTO otnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ra̱ Jesús bi hyɛ̱ti̱ gätho yø ja̱'i̱ 'bʉp'ʉ, pɛ di̱ nɛ̱qui̱ ngue mbøcuɛ. Pɛ tu̱ rá̱ mmʉi ngue ma̱ndø nna̱xi̱tho yø mmʉi yø ja̱'i̱. Bi 'yɛ̱mbra̱ n'yohʉ mi̱'ʉ p'ʉya: ―Da̱mi̱ majni̱ 'yɛ ya ―bi 'yɛ̱mbi̱. Ra̱ n'yohʉ p'ʉya bi̱ macrá̱ 'yɛ, pɛ 'bexpi zä rá̱ 'yɛ mi̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mi̱ zä mi̱ nu̱ yø fariseo ngue bi̱ n'øthe ra̱ Jesús, bi̱ ma p'ʉya. Bi 'yøtra̱ junta. 'Dap'ʉ bi̱ mpɛtihʉ yø ja̱'i̱ ra̱ Herodes, bi zänni̱ ha di japi da̱ hyo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ra̱ Jesús bi̱ mɛ yø xädi, i̱ map'ʉ ja ra̱ nenzabi Galilea. Pɛ xa̱ndøngu̱ yø ja̱'i̱ bi dɛnni̱, porque øhyø ja̱'i̱ ngue øtyø milagro ra̱ Jesús. Nu̱ya yø ja̱'i̱ ya, yø mmɛ̱ngu̱ 'da p'ʉ ja ra̱ häi Galilea, yø mmɛ̱ngu̱ 'da p'ʉ ja ra̱ hni̱ni̱ Jerusalén, yø mmɛ̱ngu̱ 'da p'ʉ ja ra̱ häi Judea, yø mmɛ̱ngu̱ 'da p'ʉ ja ra̱ häi Idumea, yø mmɛ̱ngu̱ 'da p'ʉ ma̱n'na nguadi ra̱ da̱the Jordán, xa̱ngu̱ mi̱'da yø hni̱ni̱ ja'ʉ yø häi ha ja ra̱ hni̱ni̱ Tiro 'nɛ̱hra̱ hni̱ni̱ Sidón, gä ja bi 'yɛ̱p'ʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Xa̱ngu̱ yø därquɛ̱hi̱ bi zøp'ʉ mi̱ 'bʉhra̱ Jesús. Gä bi 'yøthe, asta̱ di̱ ntøtyø ja̱'i̱ ngue nne da̱ zømp'ʉ 'bähra̱ Jesús. Porque høntho da̱ därpa̱ rá̱ he ra̱ Jesús, 'bexi sä ha hɛ̱mbyø ja̱'i̱. Ja̱na̱ngue bi xihyø xädi ra̱ Jesús ngue di̱ nsä n'na ra̱ barco, ja da̱ yʉrbʉ. Porque hi̱nga̱ mbɛ̱nnbʉ ngue ni̱ mantho di̱ mpɛti mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Xquet'a̱ 'bʉp'ʉ 'da yø ja̱'i̱ ngue n'youi yø ts'onthi̱. Nu̱'mø bi guarbʉ 'bähra̱ Jesús, ra̱ ts'onthi̱ di japra̱ ja̱'i̱ ngue nda̱ntyøhmu̱. 'Nɛ̱ di japi ngue nts'ɛdi ga̱ ya̱ ra̱ ja̱'i̱, i ɛ̱na̱: ―Gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱ ―i ɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pɛ ra̱ Jesús ja̱njua̱ni̱ ngue di hɛjpi ngue hi̱nda̱ ma̱ te'o. ");
INSERT INTO otnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","M'mɛfa p'ʉya, bi̱ map'ʉ bí ja n'na ra̱ nyu̱ni̱ ra̱ Jesús. Bi zonhni̱ hangu̱ bi̱ neprá̱ mmʉi da̱ zofo ngue bi̱ map'ʉ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ja bi zijpʉ 'dɛ'ma̱ yonc'ɛ̱i̱ yø xädi, bi 'yɛ̱ts'i̱ ngue 'dap'ʉ di̱ n'youi. Guehya da̱ mɛnhni̱ di̱ map'ʉ ja yø hni̱ni̱ ngue da̱ xihyø ja̱'i̱ rá̱ hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bi u̱nna̱ ts'ɛdi ngue da̱ zä da̱ 'yøthe yø därquɛ̱hi̱, 'nɛ̱ da̱ 'yøthe yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ja ua yø thu̱hu̱ ya 'dɛ'ma̱ yonc'ɛ̱i̱ bi thanhni̱: ra̱ Simu̱ nu̱na̱ i̱ nhu̱ta̱ m'mɛfa ngue i Bɛdu, ");
INSERT INTO otnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ra̱ Jacobo, 'nɛ̱hra̱ Xuua guehya yø ts'ʉnt'ʉ ra̱ Zebedeo ya, 'nɛ̱ guehya i hu̱tra̱ Jesús ngue ra̱ Boanerges porque nu̱na̱ ra̱ hya̱ na̱, i nne da̱ ma̱ ngue ya̱ ma̱nzaqui, ɛ̱ntho ra̱ ngäni̱ 'mø ya̱, ");
INSERT INTO otnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ra̱ Andre, ra̱ Lipe, ra̱ Bartolomé, ra̱ Mateo, ra̱ Toma, ra̱ Jacobo nu̱na̱ rá̱ ts'ʉnt'ʉ ra̱ Alfeo, ra̱ Tadeo, 'nɛ̱hna̱ ma̱n'na ra̱ Simu̱ yø n'yohʉ yø ja̱'i̱ n'youi ra̱ partido ngue ra̱ cananista, ");
INSERT INTO otnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ra̱ Judas Iscariote nu̱na̱ bi dä ra̱ Jesús. Nu̱na̱ ra̱ Jesús, mi̱ juadi bi 'yɛ̱xyø n'yohʉ ja ngue da̱ mɛp'ʉ di̱ ma, i̱ ma rá̱ ngu̱ p'ʉya, 'dap'ʉ ni̱ 'yo. ");
INSERT INTO otnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mi̱ zønná̱ ngu̱ p'ʉya, ma̱hømbi̱ mpɛti xa̱ndøngu̱ yø ja̱'i̱, asta̱ xi̱nga̱ mbongui̱ ra̱ ora da̱ ziui ra̱ hmɛ̱ yø xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mi̱ 'yøhyø mɛ̱ni̱'a̱ te øtra̱ Jesús, bi̱ ma p'ʉya ngue xta̱bá̱ nzijpʉ ha 'bʉhyø ja̱'i̱. I ɛ̱na̱: ―Ha̱ntho sʉhrá̱ nloco'a̱ ―ɛ̱nyø mɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nu̱'a̱ ga̱ mma̱nyø ja̱'i̱ te øtra̱ Jesús, nu̱'ʉ yø xännba̱te ngue ra̱ ley xpí 'yɛ̱'a̱ Jerusalén, bi 'yɛ̱n'ʉ p'ʉya: ―Nu̱na̱ ra̱ n'yohʉ na̱, ra̱ zithu̱ n'youi na̱. Porque nu̱'a̱ ra̱ zithu̱ rá̱ hmu̱ yø ts'onthi̱, gue'a̱ di ha̱tra̱ ts'ɛdi'a̱ ngue sä øthe yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ja̱na̱ngue nu̱'mø mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Guí pa̱hmʉ ngue nu̱'ʉ yø ts'onthi̱ n'youi yø ja̱'i̱, gue'ʉ yø mɛfi ra̱ zithu̱'ʉ. Pɛ hi̱nda̱ ne ra̱ zithu̱ di hɛjpa̱sɛ yø mɛfi. ");
INSERT INTO otnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Xip'ʉ ha di̱ ma̱nda n'na̱ ra̱ da̱st'abi, nu̱'mø di̱ ndu̱nhyø ja̱'i̱, hi̱nja̱m'mø da̱ zä da̱ zɛhyø hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Xip'ʉ ja n'na ra̱ ngu̱ ya, nu̱'mø di̱ nsʉsɛ yø ja̱'i̱ 'bʉp'ʉ, da̱ 'yɛ̱hra̱ pa di̱ n'uɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Njarbʉtho na̱ ra̱ hya̱ dí xi'a̱hʉ ya. Xi'mø ngue di hɛjpa̱sɛ yø mɛfi ra̱ zithu̱, ya rá̱ 'bɛfisɛ di ts'oni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Xi n'na ra̱ n'yohʉ xa̱nzaqui, 'bʉ'a̱mbo rá̱ ngu̱, hi̱nda̱ zä to da̱ yʉt'a̱mbo rá̱ ngu̱ ngue da̱ jʉjpi te pɛts'i. Nu̱'mø da̱ thu̱tra̱ mmɛ̱nni̱gu̱, gue'mø da̱ zä to da̱ yʉt'a̱mbo 'mø. Di̱ njadä p'ʉya, dí tu̱t'ä ra̱ zithu̱ di̱ ma̱nda yø ts'onthi̱, ja̱na̱ngue sä dí øthe yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A nu̱yá, da̱mi̱ pa̱hmʉ ngue ma̱jua̱ni̱ na̱ ra̱ hya̱ ja ua, ngue nu̱'a te gäma̱ ts'oqui øtyø ja̱'i̱, da̱ gue'a̱ te gäma̱ hya̱ ma̱n'ʉ ga̱ ya̱ yø ja̱'i̱, da̱ zä di̱ mpu̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pɛ nu̱ ra̱ ja̱'i̱ da̱ nømma̱n'ʉ ra̱ Espíritu Santo, ya hi̱ndi̱ pu̱nnba̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ngu̱na̱ ra̱ nya̱ bi̱ ma̱nna̱ Jesús, porque ɛ̱mbyø ja̱'i̱ ngue ra̱ zithu̱ fäts'i te øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, nu̱na̱ ra̱ Jesús bi zøhrá̱ mamá 'nɛ̱hyø n'yohʉ 'bäp'ʉ thi. Bi̱ ma̱nda bá̱ ts'o ra̱ Jesús ngue di̱ nya̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Xa̱ngu̱ yø ja̱'i̱ di̱ mäspʉ 'bʉhra̱ Jesús. Bi t'ɛ̱mbʉya: ―Ni̱ mamá 'nɛ̱ ni̱ n'yohʉ 'bäcua thi, i̱ nzo'i ngue gui̱ nya̱ui 'na̱ ―bi t'ɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱ntho: ―Ma ga̱ xi'ahʉ ndana̱ ma̱ mamá, ndana̱ ma̱ n'yohʉ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bi hyɛ̱tyø ja̱'i̱ di̱ mäspʉ 'bʉi, bi 'yɛ̱mbʉya: ―'Bʉcua ya yø ja̱'i̱ di̱ nnøpe ngue ma̱ mamá, di̱ nnøpe ngue ma̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porque nu̱ya yø ja̱'i̱ di ho da̱ 'yørpa̱bi̱ rá̱ pähä Oja̱, guehya ɛ̱ntho ma̱ mamá ya, ogue ma̱ n'yohʉ ya, ogue ma̱ nju̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ma̱n'na ndi̱ p'ʉya, nu̱p'ʉ ja ra̱ nenzabi Galilea, bi xännba̱ ra̱ hya̱ yø ja̱'i̱ ra̱ Jesús. Pɛ ma̱ndøngu̱ dyø ja̱'i̱ bi̱ mpɛti p'ʉ ha 'bʉi. Ja̱na̱ngue bi yʉrbʉ ja n'na ra̱ barco ja bá̱ mi̱p'ʉ. Bi zoquits'ʉ ra̱ nenzabi, i̱ ma mbo ra̱ dehe. Gätho yø ja̱'i̱ 'bʉ'a̱ nenzabi. ");
INSERT INTO otnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xa̱ngu̱ yø hya̱ bi xännba̱ yø ja̱'i̱, honi̱ te gui hyɛjpa̱ yø hya̱ xifi. Ngu̱na̱ n'na ra̱ hya̱ bi hyɛqui, bi 'yɛ̱mbyø ja̱'i̱: ");
INSERT INTO otnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Da̱mi̱ 'yørpa̱hʉ ra̱ güɛnda xa̱ndønho ya yø hya̱ ga̱ xi'ahʉ ya. N'na ra̱ n'yohʉ bi̱ ma da̱ ponna̱ trigo. ");
INSERT INTO otnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nu̱p'ʉ bi thogui ngue ponyø hmu̱dä, bi zop'ʉ ja ra̱ 'yu̱ 'da yø hmu̱dä. Bi̱ map'ʉ yø ts'ints'ʉ ngue bi za yø hmu̱dä. ");
INSERT INTO otnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mi̱'da yø hmu̱dä bi̱ moni̱, bi zop'ʉ hi̱ngui̱ pidi ra̱ häi ngue o ra̱ do. Guehya yø hmu̱dä n'nahma̱ntho bi bøts'e ngue hi̱ngui̱ pidi ra̱ häi p'ʉ bi zo. ");
INSERT INTO otnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hi̱nga̱ ya mbo pa yø 'yʉ. Nu̱'mø bá̱ pøxra̱ hyadi, bi 'yu̱hyø hmu̱dä ya xi bøts'e. ");
INSERT INTO otnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mi̱'da yø hmu̱dä bi zop'ʉ ja yø 'ui̱ni̱. Mi̱ nte yø 'ui̱ni̱ p'ʉya, bi ts'onyø hmu̱dä ngue bi hyøt'a̱mbo. Ya hi̱mbi̱ nja yø hmu̱dä. ");
INSERT INTO otnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mi̱'da yø hmu̱dä bi zop'ʉ ja ra̱ hoga̱ häi. Nu̱'mø mi̱ bøts'e, ma̱zihotho gui̱ nɛ̱qui̱. Mi̱ nja p'ʉya, 'däte ma̱'dɛt'a bi bøni̱ ngue n'na mhmu̱dä. Mi̱'da p'ʉya, hya̱te bi bøni̱ ngue n'na mhmu̱dä. Mi̱'da p'ʉya, n'na ciento bi bøni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","A nu̱yá, di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ na̱ ra̱ hya̱ dí̱ mma̱ngä ya ―bi 'yɛ̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ya 'yo pa gätho yø ja̱'i̱ p'ʉya. Nu̱'ʉ 'dɛ'ma̱ yoho yø xädi ra̱ Jesús bi guarbʉ 'bäi, da̱ guehyø ja̱'i̱ nu̱'ʉ tobe 'bʉrpʉ bi guat'i. Bi 'yännbʉya te ga̱ mbønya yø hya̱ xi hyɛqui. ");
INSERT INTO otnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱ya yø hya̱ hi̱ngui̱ fa̱di̱ ha di̱ ma̱nda Oja̱ yø ja̱'i̱, i̱ nne Oja̱ ngue da̱ di̱nni̱ mmʉihʉ hanja ya yø hya̱ ya. Pɛ nu̱'ʉ mi̱'da yø ja̱'i̱, guehya dí honi̱ te da̱di hyɛjpa̱ yø hya̱ dí xifi. ");
INSERT INTO otnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nu̱ te gä nnu̱ ya yø ja̱'i̱ ya, ɛ̱ntho 'mø hi̱nte bi̱ nu̱. Nu̱ya yø hya̱ øde dí̱ mma̱ngä, ɛ̱ntho 'mø hi̱n tema̱ hya̱ bi 'yøde. Gue'a̱ di siguetho ra̱ nts'o ga̱ 'yo'a̱. Oja̱ p'ʉya, ya hi̱ndi̱ pu̱nnba̱ yø ts'oqui yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―Xquet'a̱ 'nɛ̱'a̱hʉ hi̱nguí̱ pa̱hmʉ te ni̱ bønya yø hya̱ da̱di hyɛcä 'mø. ¿Pɛ hague gdá̱ japi da̱ di̱nni̱ mmʉihʉ te ni̱ bønya yø hya̱ ga̱ hyɛcä ma̱høn'a̱ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nu̱na̱ ra̱ momhmu̱dä dí̱ mma̱ngä, guehna̱ ra̱ ja̱'i̱ pap'ʉ 'bʉhyø ja̱'i̱ ngue bi̱ mma̱mbrá̱ hya̱ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nu̱ya yø ja̱'i̱ ngue høntho bi 'yøhra̱ hya̱, guehya gui̱ nhyɛjpi ngue ra̱ nen'yu̱ p'ʉ bi zo yø hmu̱dä ya. Høntho juadi bi 'yøhra̱ hya̱, bi̱ map'ʉ ra̱ zithu̱, bi japi bi pu̱mbɛ̱ni̱ ra̱ hya̱ xi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mi̱'da yø ja̱'i̱, gui̱ nhyɛjpa̱ ra̱ häi hi̱ngui̱ pidi ngue mi̱ o ra̱ do p'ʉ bi zo yø hmu̱dä. Mi̱ zä mi̱ 'yøhra̱ hya̱ yø ja̱'i̱, ja̱njua̱ni̱ di johya ngue bi̱ nu̱ ma̱nho. ");
INSERT INTO otnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Guehya yø ja̱'i̱ hi̱mbi̱ bɛnt'i̱ xa̱nho ra̱ hya̱ ya. Zits'ʉtho honi̱ ha di hyɛp'ʉ ra̱ hya̱. Nu̱'mø bi ts'ʉi ngue ra̱ hya̱ ɛ̱c'ɛ̱i̱, 'bexi cohyø mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mi̱'da yø ja̱'i̱ p'ʉya, gui̱ nhyɛjpa̱bi̱ ra̱ häi ngue ja yø 'ui̱ni̱ p'ʉ bi zo yø hmu̱dä. Guehya yø ja̱'i̱ bi 'yøde hanja ra̱ hya̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pɛ nu̱'a̱ te yø bɛfi i ja n'na pa ngu̱ n'na pa, høndyø 'bɛfi ni̱ ma yø mmʉi yø ja̱'i̱. Di ja ndu̱mmʉi honi̱ ha di̱ mmɛ̱mmɛti. Hi̱nga̱ ngu̱t'a̱ te gä sänni̱ da̱ 'yøt'e. Ya hi̱n tema̱ nhotho bi 'yørpa̱bi̱ na̱ ra̱ hya̱ bi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pɛ mi̱'da yø ja̱'i̱ gui̱ nhyɛjpa̱ ra̱ hoga̱ häi p'ʉ bi zo yø hmu̱dä. Nu̱'mø mi̱ 'yøhra̱ hoga̱ 'da'yo hya̱, bi̱ nu̱ ma̱nho. Bi 'yørpa̱bi̱ ra̱ nho na̱ ra̱ hya̱ bi 'yøde. Pɛ 'bʉ i'da yø ja̱'i̱ ngue ma̱thoguitho bi 'yørpa̱bi̱ ra̱ nho ra̱ hya̱ bi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma̱hømbi 'yɛ̱mbyø ja̱'i̱ ra̱ Jesús: ―Xi'mø ngue ha̱ ra̱ nyot'i n'na ra̱ ja̱'i̱, nu̱'a̱ ra̱ nyot'i ha̱, hi̱nda̱ gombʉ ja ra̱ huada. 'Nɛ̱ hi̱nda̱ hyøt'a̱ 'bit'ots'i. Sinoque da̱ hyøxpʉ ja ra̱ nthøxa̱nyot'i n'namhma̱ di yot'i xa̱nho mbo ra̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Njarbʉtho ya yø hya̱ hi̱ngui̱ fa̱di̱ hanja ya. Zi yohotho yø ja̱'i̱ ti̱nyø mmʉi hanja ra̱ hya̱. Pɛ da̱ 'yɛ̱hra̱ pa ngue gätho yø ja̱'i̱ da̱ ba̱di̱ hanja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ ya yø hya̱ dí̱ mma̱ngä. ");
INSERT INTO otnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma̱hømbi̱ 'yɛ̱mbyø ja̱'i̱ ra̱ Jesús: ―Da̱mi̱ 'yɛ̱t'a̱mmʉihʉ teni̱ bønya yø hya̱ dí̱ mma̱ngä. Nu̱'mø gui 'yørpa̱hʉ ma̱su̱ ya yø hya̱ ya, da̱ di̱nni̱ mmʉihʉ xa̱nho hanja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A nu̱ ra̱ ja̱'i̱ da̱ di̱ni̱ xa̱nho rá̱ mmʉi hanja ra̱ hya̱, da̱ mäx Oja̱ ngue ma̱n'na di ba̱hra̱ hya̱. Pɛ nu̱ ra̱ ja̱'i̱ hi̱ngui̱ nne da̱ 'yørpa̱bi̱ ma̱su̱ ra̱ hya̱ dí̱ mma̱, nu̱'a̱ zits'ʉ ra̱ hya̱ pa̱di̱, da̱ tha̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ra̱ Jesús bi 'yɛ̱na̱: ―Nu̱ya yø ja̱'i̱ di̱ ma̱nda Oja̱, gui̱ nhyɛjpi tengu̱tho 'mø bi thu̱'a̱ n'na ra̱ hmu̱dä. ");
INSERT INTO otnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nu̱ ra̱ ja̱'i̱ bi du̱hra̱ hmu̱dä, di sigue di̱ mpɛtho mɛ̱nte 'danyø pa brá̱ o häi ra̱ hmu̱dä, sär'mø da̱ bogui, da̱ bøxpʉya. Pɛ nu̱na̱ ra̱ ja̱'i̱ bi du̱hra̱ hmu̱dä, hi̱ngui̱ pa̱di̱ hanja ngue bá̱ te ra̱ hmu̱dä. ");
INSERT INTO otnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Porque ra̱ häi øt'e ngue da̱ bohra̱ hmu̱dä, da̱ bøts'e, di̱ nda̱xi̱, da̱ 'yot'i. ");
INSERT INTO otnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nu̱'mø bi 'yot'i, da̱ soqui. ");
INSERT INTO otnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ma̱hømbi̱ 'yɛ̱mbyø ja̱'i̱ ra̱ Jesús: ―Ma̱hønga̱ hyɛcä ma̱n'na ra̱ hya̱ ya. Ma ga̱ xän'na̱hʉ ha di̱ njap'ʉ di̱ nxa̱ndyø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nu̱p'ʉ rá̱ mʉdi, tengu̱tho n'na zihmu̱dä ra̱ mostasa, ngue ma̱n'na zitchʉ ngue gätho mi̱'da yø hmu̱dä ja ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pɛ nu̱'mø bi̱ ma nthu̱hu̱ na̱ ra̱ hmu̱dä na̱, ma̱n'na ta̱te ra̱ da̱t'o ngue gätho mi̱'da yø c'ani̱ i ja. Nu̱p'ʉ ja yø 'yɛt'o, ja ørbʉ yø 'bafi yø ts'ints'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Xa̱ngu̱ yø hya̱ bi hyɛcra̱ Jesús. I honnbi̱ ndana̱ ra̱ hya̱ da̱ di̱ni̱ xa̱nho p'ʉ ja yø mmʉi yø ja̱'i̱, gue'a̱ xännba̱bi̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nu̱'mø ya̱sɛui yø xädi p'ʉya, i xifi te ga̱ mbønyø hya̱ di hyɛqui. Pɛ nu̱'mø gue'ʉ mi̱'da yø ja̱'i̱ xännba̱bi̱ ra̱ hya̱, guehya honi̱ te gui hyɛjpa̱ yø hya̱ xännba̱bi̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mi̱ dähra̱ nde'a̱ ra̱ pa'a̱, bi 'yɛ̱mbyø xädi ra̱ Jesús: ―A nu̱yá, ma ga̱ 'dasʉ ra̱ zabi gdá̱ mähä ma̱n'na nguadi. ");
INSERT INTO otnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nu̱'ʉ yø xädi ra̱ Jesús, mi̱ juadi bi 'yɛ̱hyø ja̱'i̱, bi yʉrbʉ ja ra̱ barco mi̱ o ra̱ Jesús, bi̱ ma. Bi̱ mähä mi̱'da yø barco mi̱ jap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nu̱p'ʉ ja ra̱ zabi, bi̱ nanga̱ n'na ra̱ nda̱te nda̱hi̱. Nu̱'ʉ yø fʉnthe nangui̱, so mbo ra̱ barco. Ja̱na̱ngue ya nne da̱ thu̱ntra̱ barco ngue'a̱ ga̱ nhyʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pɛ ra̱ Jesús ma̱mbi̱ oxpʉ ja n'na ra̱ nhu̱di̱ jap'ʉ ja rá̱ xʉtha ra̱ barco ngue a̱ha̱. Nu̱'ʉ yø xädi p'ʉya, bá̱ äp'ʉ bi a̱ha̱, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ya ga̱ tu̱hʉ. Nu̱'a̱'i̱ p'ʉya, guí a̱tho ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mi̱ nangra̱ Jesús, bi hɛjpa̱bi̱ ra̱ nda̱hi̱ 'nɛ̱hyø fʉnthe. Bi xifi ngue di̱ nsäya. 'Bexque'a̱ ra̱ ora'a̱ p'ʉya, gä bi̱ nsäya. ");
INSERT INTO otnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pɛ ra̱ Jesús bi 'yɛ̱mbyø xädi: ―¿Hanja ngue guí su̱hʉ? ¿Ua hi̱nguí̱ ɛ̱c'ɛ̱i̱ ngue ga̱ fäxa̱hʉ? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mi̱ nu̱ yø xädi ra̱ Jesús ngue te bi 'yøt'e, bi̱ nti̱nnbʉtho yø ts'u̱ mi̱ ja. Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na p'ʉya: ―¿Te'o ni̱ n'yohʉ na̱ n'yø? Asta̱ ra̱ nda̱hi̱ 'nɛ̱hra̱ dehe ɛ̱c'ɛ̱i̱ 'mø bi zofo ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mi̱ zøm ma̱n'na nguadi ra̱ zabi, ja ra̱ häi ni̱ hu̱ ngue Gadara. ");
INSERT INTO otnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Høntho bi bømp'ʉ ja ra̱ barco ra̱ Jesús, ya xpa̱ ɛ̱p'ʉ n'na ra̱ n'yohʉ mi̱ n'youi ra̱ ts'onthi̱. Nu̱na̱ ra̱ n'yohʉ na̱, mi̱ nnøpa̱ ngu̱ p'ʉ ja yø n'o yø ánima. Ma̱da̱gue'a̱ ntha̱t'i̱ conyø cadena, pɛ xɛjtho. Ja̱na̱ngue ya hi̱njongui̱ sä da̱ za̱mmi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Xa̱ngu̱ yø nni̱di̱ ngue ntha̱t'i̱ yø 'yɛ 'nɛ̱hyø gua conyø cadena. Pɛ xɛjtho, hi̱ngui̱ hät'i da̱ za̱mmi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ra̱ pa ra̱ xu̱i̱ 'yo da̱po, bi 'yop'ʉ ha o yø ánima, i̱ mafi hapʉ ni̱ ma. 'Nɛ̱ xa̱ nguahyø nsä'mi̱ rá̱ do'yo ngue di̱ ntɛ yø do. ");
INSERT INTO otnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yap'ʉtho ma̱mbá̱ ɛ̱hɛ̱, pɛ mi̱ hyandra̱ Jesús. Bi̱ ntihi i̱ nda̱ntyøhmu̱ p'ʉ 'bäi. ");
INSERT INTO otnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ra̱ ndøts'ɛdi i zofo, bi 'yɛ̱mbi̱: ―Ague Jesús, rá̱ Ts'ʉnt'ʉ'i Oja̱ nu̱na̱ jasɛ rá̱ ts'ɛdi, ¿hanja ngue ga̱di̱ nthi̱nt'ua dí 'bʉi? Nguet'Oja̱'i̱, 'yo ga̱di ʉngui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ngu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ n'yohʉ, porque ya xi xihra̱ ts'onthi̱ ra̱ Jesús ngue da̱ hyɛp'ʉ ra̱ n'yohʉ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Teni̱ hu̱'i̱? Ra̱ n'yohʉ p'ʉya bi 'yɛ̱na̱: ―Nná̱ hu̱gä ngue yø mmu̱ndotho gähe, porque xa̱ngu̱gähe ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nu̱'ʉ yø ts'onthi̱ p'ʉya, bi xihra̱ Jesús ngue nu̱p'ʉ mi̱ 'bʉi, hi̱nga̱ yap'ʉtho da̱ mɛnhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ja mi̱ 'yorbʉtho n'na 'bʉi yø ts'ʉdi, ma̱'yoni̱ p'ʉ bí ja ra̱ nguani̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nu̱'ʉ yø ts'onthi̱ p'ʉya, bi 'yɛ̱mbra̱ Jesús: ―Da̱mi̱ 'dacje ra̱ nt'ɛ̱di̱ ga̱ cʉt'ähe p'ʉ ja yø mmʉi yø ts'ʉdi bí 'yo nʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ra̱ Jesús bi u̱nna̱ nt'ɛ̱di̱ yø ts'onthi̱ ngue ja i̱ map'ʉ. Ja̱na̱ngue bi hyɛp'ʉ ra̱ n'yohʉ mi̱ n'youi, bi̱ ma, i̱ ncʉrbʉ ja yø mmʉi yø ts'ʉdi p'ʉya. Nu̱'ʉ yø ts'ʉdi mi̱ jua'i yo ma̱hua̱hi̱. Bi gʉ ra̱ 'dihi yø ts'ʉdi p'ʉya, bi̱ nhyørbʉ ja ra̱ zabi. Gä ja bi ja̱rbʉ ra̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nu̱'ʉ mi̱ fähyø ts'ʉdi p'ʉya, bi̱ nsu̱ 'mø mi̱ nu̱ te bi̱ nja. N'na 'dihitho bi̱ map'ʉ bí ja ra̱ hni̱ni̱ ngue bá̱ ma̱ te bi̱ nja. Da̱ gue'ʉ yø ja̱'i̱ 'da'a̱ n'nanni̱ bí 'bʉi, gä bá̱ xifi. Mi̱ 'yøhyø ja̱'i̱'a̱ te bi̱ nja, ma̱ndøngu̱ dyø ja̱'i̱ bá̱ ɛ̱hɛ̱ da̱ nu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mi̱ zønyø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús, 'dap'ʉ 'bʉhmi̱'a̱ ra̱ n'yohʉ mi̱ n'youi yø ts'onthi̱. Ya hi̱nte di ja, ya he ra̱ u̱lu, ya xi di̱ts'i̱. Pɛ bi zu̱ yø ja̱'i̱'a̱ te xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nu̱ya yø ja̱'i̱ xi̱ nu̱sɛ'a̱ te xi thohra̱ n'yohʉ mi̱ n'youi yø ts'onthi̱, 'nɛ̱'a̱ te xi thohyø ts'ʉdi, gä xihyø ja̱'i̱ nu̱ya ja søhø. ");
INSERT INTO otnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yø ja̱'i̱ p'ʉya, bi xihra̱ Jesús ngue da̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ja̱na̱ngue ma̱hømbi yʉrbʉ ja ra̱ barco ra̱ Jesús ngue da̱ ma. Nu̱'a̱ ra̱ n'yohʉ mi̱ n'youi yø ts'onthi̱, bi xihra̱ Jesús ngue xta̱ mmɛp'ʉ ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pɛ hi̱mbi̱ nepra̱ Jesús, sinoque bi 'yɛ̱mbi̱: ―Ma̱n'na xa̱nho ni̱ ma ni̱ ngu̱. Da̱mi̱ xihni̱ mɛ̱ni̱ te dá̱ øt'a̱'i̱. Xihni̱ amigo. Da̱mi̱ xifi ha bi̱ nja ngue bi huɛ̱c'a̱'i̱ Oja̱ bi 'yøthe'i ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bi̱ ma ra̱ n'yohʉ p'ʉya, bi̱ n'yo gätho p'ʉ ja yø hni̱ni̱ Decápolis, xifi gätho yø ja̱'i̱ te xi 'yørpa̱bi̱ ra̱ Jesús. Nu̱ to gä bi 'yøde te xi 'yøtra̱ Jesús, gä di 'yøtho. ");
INSERT INTO otnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mi̱ zømma̱n'na nguadi ra̱ zabi ra̱ Jesús, xa̱ndøngu̱ yø ja̱'i̱ hømbi̱ mpɛti. ");
INSERT INTO otnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bi zø'a̱ n'na ra̱ n'yohʉ 'bɛt'o ngue di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱ p'ʉya, ni̱ hu̱ ngue ra̱ Jairo. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ja̱njua̱ni̱ ngue äpra̱ ma̱te, bi 'yɛ̱mbi̱: ―Nu̱gä nná̱ ɛ̱hɛ̱ ga̱ xi'i ngue ma̱ t'i̱xu̱ dí si, ya pa ma̱n'ʉ, ya ja ngue da̱ du̱. Xi'mø gui 'yørca̱ ra̱ ma̱te ga̱ mmɛ, gui japni̱ 'yɛ p'ʉ ja rá̱ do'yo, ja̱na̱ngue da̱ zä ra̱ n'ʉ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nu̱na̱ ra̱ Jesús bi̱ mɛ na̱ ra̱ n'yohʉ bi zits'i. Xa̱ngu̱ mi̱'da yø ja̱'i̱ bi dɛnni̱ asta̱ di̱ ntørbʉ ja ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nu̱'ʉ yø ja̱'i̱ ni̱ dɛnna̱ Jesús, n'youi p'ʉ n'na ra̱ xisu ngue ya n'nɛ'ma̱ yonjɛya mi̱ hɛ̱mbra̱ m'mäcji. ");
INSERT INTO otnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nu̱na̱ ra̱ xisu ma̱di̱ hyɛ̱nni̱, xa̱ndøngu̱ rá̱ mɛ̱nyu̱ xi ʉni ngue honyø 'yøthe da̱ 'yøthe. Ya xi ʉni̱ gätho'a̱ te mi̱ pɛts'i, porque nne ngue da̱ zä te hɛ̱mbi̱. Pɛ hi̱n'i zä'a̱ ngue ma̱di̱ n'yøthe. Sinoque ma̱n'na ma̱ni̱ ma ma̱n'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Mi̱ zä mi̱ 'yøhna̱ ra̱ xisu ngue øtyø milagro ra̱ Jesús, bi 'yɛ̱nna̱ xisu p'ʉya: “Nu̱'mø ga̱ thärpa̱bi̱ rá̱ he ra̱ Jesús, da̱ zägui”, bi 'yɛ̱na̱. Ja̱na̱ngue bi̱ nthi̱nnbʉ ha mma yø ja̱'i̱ p'ʉya, asta̱ gue'mø mi̱ guatra̱ Jesús ngue bi därpa̱ rá̱ he. ");
INSERT INTO otnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngu̱'i därpa̱ rá̱ he p'ʉya, 'bexpi̱ nsäya ra̱ ji, bi zä ra̱ n'ʉ mi̱ hɛ̱mbra̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mi̱ ba̱hra̱ Jesús ngue bi zä n'na nc'ɛ̱i̱ conná̱ ts'ɛdi, bi̱ m'mä p'ʉya ngue hɛ̱tyø ja̱'i̱. Bi 'yɛ̱mbi̱: ―¿Te'o bi därca̱gui̱ ma̱ he? ―bi 'yɛ̱mbyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bi 'yɛ̱m'mø mi̱ da̱hyø xädi ra̱ Jesús: ―Guí änni̱ to bi dät'a̱ ni̱ he. Conque guí̱ nnu̱ ngue xa̱ndøngu̱ yø ja̱'i̱ di̱ ntøt'ua nná̱ mähä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pɛ ra̱ Jesús bi sigue di za di hɛ̱ti̱ yø ja̱'i̱, ngue nne da̱ ba̱di̱ te'o bi dädi. ");
INSERT INTO otnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nu̱'a̱ ra̱ xisu p'ʉya, ya pa̱di̱ te xi 'yøt'e, mmap'ʉ p'ʉya ni̱ hua̱qui̱ ngue su̱. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús. Bi xi'a̱ njua̱ni̱ ngue xi därpa̱bi̱ rá̱ he. ");
INSERT INTO otnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nu̱na̱ ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague t'i̱xu̱, ya bi zä'i ngue gá̱ 'yɛ̱c'ɛ̱i̱ ngue di zä'i comma̱ ts'ɛdigä. Ni̱ ma ya, da̱ hyu̱ ni̱ mmʉi ngue bi zä'i ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nu̱na̱ ra̱ Jesús, mɛ̱nte ya̱ui ra̱ xisu ma̱di̱ hyɛ̱nni̱, bi zø hma̱n'na nc'ɛ̱i̱ bá̱ nɛ̱xpʉ ja rá̱ ngu̱ ra̱ Jairo, bi 'yɛ̱mbra̱ Jairo: ―Ya bi du̱ ni̱ t'i̱xu̱ n'yø, 'yoni̱ mantho gui sixra̱ xännba̱te ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nu̱na̱ ra̱ hya̱ bi sihra̱ Jairo, bi 'yøhra̱ Jesús, pɛ hi̱ngui̱ ørpa̱tho ma̱su̱. Sinoque bi 'yɛ̱mbra̱ Jairo: ―'Yo sä guí su̱'a̱ si'i ngue bi du̱ ni̱ t'i̱xu̱. Sinoque da̱mi̱ 'yɛ̱c'ɛ̱i̱gui̱ ngue da̱ zä ga̱ fäxa̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ya hi̱mbi̱ nepe xta̱ thogui gätho yø ja̱'i̱. Sinoque høndra̱ Bɛdu bi zits'i, co 'nɛ̱hya yonc'ɛ̱i̱ di̱ n'yohʉ, ra̱ Xuua 'nɛ̱hra̱ Jacobo. ");
INSERT INTO otnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mi̱ zømp'ʉ ja rá̱ ngu̱ ra̱ Jairo p'ʉya, ya zonyø ja̱'i̱, tär'ma̱n'ʉ yø mmʉi ngue ya xi du̱ ra̱ hmu̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pɛ ngu̱'i zønna̱ Jesús, bi yʉt'a̱mbo, bi 'yɛ̱mbyø ja̱'i̱: ―¿Te 'bɛ'a̱ guí øthʉ ua ga̱di yänni̱hʉ? 'Yoni̱ mantho gui zomhmʉ. Nu̱na̱ ra̱ hmu̱te hi̱ngui̱ tu̱ na̱, i a̱tho na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pɛ nu̱ya yø ja̱'i̱ ya̱ui ra̱ Jesús, i thentho, porque pa̱di̱ ngue ya xi du̱ ra̱ hmu̱te. Mi̱ bøn'athi gätho yø ja̱'i̱ p'ʉya, ra̱ Jesús bi thop'ʉ brá̱ 'bɛnna̱ hmu̱te. Ni̱ n'youi rá̱ papá ra̱ hmu̱te 'nɛ̱hrá̱ mamá. Co 'nɛ̱'ʉ yø xädi ni̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ra̱ Jesús bi bɛnnba̱ rá̱ 'yɛ ra̱ hmu̱te xi du̱, bi 'yɛ̱mbi̱: ―Talita cumi ―bi 'yɛ̱mbi̱. Nu̱na̱ ra̱ hya̱ na̱ p'ʉya, i̱ nne da̱ ma̱ ngue ɛ̱na̱: “Ague grá̱ hmu̱te, dí xi'i, da̱mi̱ nangui̱”. ");
INSERT INTO otnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Høntho bi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, 'bexpi̱ nangra̱ hmu̱te, bi̱ n'yo. Ra̱ hmu̱te p'ʉya, ya 'dɛ'ma̱ yonjɛya mi̱ 'bʉi. Nu̱ya bi̱ nu̱p'ʉ bi bɛ̱nna̱te ra̱ hmu̱te, di 'yøtho. ");
INSERT INTO otnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pɛ ra̱ Jesús ɛ̱mmɛ̱i̱ di hɛjpa̱ yø ja̱'i̱ ngue hi̱njonda̱ ma̱ te bi 'yøt'e. Bi̱ ma̱nda p'ʉya ngue di t'u̱nna̱ hmɛ̱ da̱ zi ra̱ hmu̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ma̱mbá̱ ɛ̱p'ʉ ja rá̱ ngu̱ ra̱ Jairo ra̱ Jesús, i̱ map'ʉ ja rá̱ häi bá̱ nte, bi̱ mɛ yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nu̱'mø ra̱ pa säya yø ja̱'i̱ p'ʉya, pap'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús, ngue bi xännba̱bi̱ ra̱ hya̱ yø ja̱'i̱. Xa̱ngu̱ yø ja̱'i̱ øxra̱ hya̱ bi̱ ma̱. Pɛ gä di 'yødyø ja̱'i̱ hanja'a̱ ra̱ hya̱ øde, di̱ n'yɛ̱mbi̱: ―¿Hapʉ go bá̱ ha̱'a̱ ra̱ hya̱ xännba̱te na̱ ra̱ n'yohʉ ya̱ ua? ¿Hague go ga̱ mba̱'a̱ ra̱ hya̱ pa̱di̱? ¿Hague ga̱ nzä øtyø milagro? ");
INSERT INTO otnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Conque guehna̱ ra̱ yaxi rá̱ ts'ʉnt'ʉ ra̱ Ma̱ya na̱. Yø n'yohʉ p'ʉya, guehna̱ ra̱ Jacobo, 'nɛ̱hra̱ José, 'nɛ̱hra̱ Judas, 'nɛ̱hra̱ Simu̱. Yø nju̱ p'ʉya, gä 'dadua ra̱ hni̱ni̱ dí 'bʉhmʉ. Ja̱na̱ngue ɛ̱mbyø ja̱'i̱ ngue to bi zä ma̱n'yohʉ na̱ ra̱ Jesús. Hi̱ngui̱ ørpa̱tho ma̱su̱ yø ja̱'i̱ ra̱ hya̱ xifi. ");
INSERT INTO otnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pɛ bi 'yɛ̱mbyø ja̱'i̱ ra̱ Jesús: ―Gätho yø pønga̱hya̱ Oja̱ n'nanni̱ ni̱ 'yɛ̱hɛ̱, gä hnu̱ ma̱nsu̱. Pɛ nu̱'ʉ yø mmɛ̱ngu̱hʉ yø pønga̱hya̱, hi̱ngui̱ nnu̱ ma̱nsu̱. Ni̱ xinga̱ gue'ʉ to 'bʉp'ʉ ja rá̱ ngu̱ ra̱ pønga̱hya̱ di̱ nnu̱ ma̱nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ja bi̱ njap'ʉ ngue hi̱mbi̱ zä xta̱ 'yøt'e xa̱ngu̱ yø milagro ra̱ Jesús. Høndi zi hangu̱tho yø därquɛ̱hi̱ bi japrá̱ 'yɛ ngue bi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Di 'yødra̱ Jesús hanja ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱ yø mmɛ̱ngu̱ui. Mi̱ bømp'ʉ ja ra̱ hni̱ni̱ mi̱ 'bʉhra̱ Jesús, bi̱ ma bá̱ n'yop'ʉ ja yø hni̱ni̱, ma̱nyarbʉ i̱ ma ngue xännba̱ ra̱ hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nu̱ya 'dɛ'ma̱ yoho yø xädi ya xi huanhni̱, bi zofo ngue da̱ mɛnnbʉ ja yø hni̱ni̱. Bi xifi ngue yø yonc'ɛ̱i̱ p'ʉ da̱ ma. Bi u̱nna̱ ts'ɛdi ngue da̱ 'yøthe yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bi xi p'ʉya, ngue hi̱n teni̱ buxa da̱ ga̱ts'i̱. 'Nɛ̱ hi̱n tema̱ thu̱hmɛ̱ da̱ hya̱ts'i̱. 'Nɛ̱ hi̱n tema̱ mɛ̱nyu̱ da̱ hya̱ts'i̱. Sinoque høndra̱ tøhø da̱ hya̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bi xifi ngue da̱ gʉxyø thi̱xfani̱ 'nɛ̱ hi̱nda̱ ga̱xrá̱ mponi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bi sigue bi 'yɛ̱mbi̱: ―Nu̱'mø gá̱ sømhmʉ p'ʉ ja n'na ra̱ hni̱ni̱, nu̱'mø to da̱ zixa̱hʉ rá̱ ngu̱ ngue di säya'a̱hʉ, ja m'mʉhmʉ p'ʉ ja ra̱ ngu̱ di̱ n'na'a̱hʉ ra̱ ts'äya, asta̱ gue'mø guá̱ ɛ̱hmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nu̱p'ʉ ja n'na ra̱ hni̱ni̱ gui sømhmʉ, 'nɛ̱ hi̱ndi̱ n'na'a̱hʉ ra̱ ts'äya, ogue hi̱njonda̱ 'yøt'a̱hʉ ma̱su̱, da̱mi̱ thogui, gdi̱ mähä n'nanni̱ ra̱ hni̱ni̱. Pɛ da̱mi̱ hua̱mhmra̱ fonthäi di̱ n'youi ni̱ mbonguahʉ, gue'a̱ ra̱ hmɛ̱ya'a̱ ngue ya da̱ thɛp'ʉ ya yø ja̱'i̱ hi̱mbi 'yøt'a̱hʉ ma̱su̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nu̱'ʉ yø xädi ra̱ Jesús bi̱ ma bá̱ n'yop'ʉ ja yø hni̱ni̱. I xihyø ja̱'i̱ ngue da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo. ");
INSERT INTO otnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xa̱ngu̱ yø nni̱di̱ bi 'yøthe yø ja̱'i̱ n'youi yø ts'onthi̱. Nu̱'mø bi gospa̱bi̱ ra̱ aceite yø därquɛ̱hi̱, 'bexi sä ha hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nu̱na̱ ra̱ da̱st'abi Herodes mi̱ 'yøde te mma̱nyø ja̱'i̱ ngue xa̱ngu̱ yø milagro øtra̱ Jesús. Bi 'yɛ̱mp'ʉya: ―Nu̱gä dí ɛ̱na̱ ngue xpí bɛ̱nna̱te'a̱ ra̱ Xuua mi̱ øtra̱ nxixya̱. Ja̱na̱ngue sä øtyø milagro ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mi̱'da yø ja̱'i̱ p'ʉya bi 'yɛ̱na̱: ―Nu̱na̱ ra̱ n'yohʉ i hma̱, rá̱ nzɛgui guehna̱ ra̱ pønga̱hya̱ Elías. Pɛ mi̱'da yø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Nu̱gä dí ɛ̱na̱ ngue 'bʉi toni̱ pønga̱hya̱ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ra̱ Herodes bi 'yɛ̱n'a̱ p'ʉya: ―Pɛ nu̱gä dí ɛ̱na̱ ngue gue'a̱ ra̱ Xuua mi̱ øtra̱ nxixya̱ xpí bɛ̱nna̱te ya. Porque nu̱na̱ ra̱ Xuua, guehna̱ dá̱ ma̱ndagä bi thɛjpa̱bi̱ rá̱ ya na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nu̱'mø yø pa xa̱ thogui, bi̱ ma̱nda ra̱ Herodes ngue bi̱ mbɛntra̱ Xuua, bi du̱t'i̱ conyø cadena bi got'a̱ fädi. Bi ʉpi ngue nu̱na̱ ra̱ Xuua ya xi xihra̱ Herodes ngue hi̱ngui̱ ho di̱ m'mʉhmi̱ na̱ rá̱ 'bɛpo Herodías nu̱na̱ ma̱rá̱ xisu na̱ rá̱ n'yohʉ Lipe. ");
INSERT INTO otnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nu̱na̱ ra̱ Xuua, xi 'yɛ̱mbra̱ Herodes: “Hi̱n'yʉ ra̱ nt'ɛ̱di̱ guí̱ m'mʉhmi̱ ni̱ 'bɛpo”, xi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mi̱ 'yøhra̱ xisu na̱ ra̱ hya̱ mma̱nna̱ Xuua, bi̱ mbøcuɛ ra̱ xisu, i sʉhra̱ Xuua ngue'a̱ te ra̱ hya̱ bi̱ ma̱. I̱ nnepe ngue da̱ tho ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Pɛ ra̱ Herodes hi̱ngui̱ nne da̱ hyo, porque nnu̱ ma̱nsu̱ na̱ ra̱ Xuua, 'nɛ̱ pa̱rpi̱ ngue ra̱ hoga̱ n'yohʉ. Nu̱'a̱ te ra̱ hya̱ mi̱ mma̱nna̱ Xuua, ma̱di̱ ho da̱ 'yøde, pɛ mi̱ yobɛ̱ni̱tho ha ga̱ 'yøde te gäma̱ hya̱ mma̱nna̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pɛ nu̱na̱ ra̱ Herodías bi di̱ni̱ ha di japra̱ Xuua nu̱na̱ sʉi. Mi̱ zøhra̱ pa bi̱ nsänni̱go ra̱ Herodes. Bi zonhyø mmi̱st'abiui ngue bi 'yørpa̱bi̱ ra̱ nts'i̱hmɛ̱. Gätho yø hmu̱ yø soldado, gä bi zofo. Nu̱p'ʉ ja ra̱ häi Galilea, gätho'ʉ yø ja̱'i̱ hnu̱ ma̱nsu̱ p'ʉ ja yø hni̱ni̱, gä bi zofo. ");
INSERT INTO otnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nu̱na̱ rá̱ t'i̱xu̱ ra̱ Herodías, bi yʉrbʉ 'bʉhyø ja̱'i̱ xi pɛtra̱ Herodes ngue sänni̱go, bi̱ mʉhra̱ hnɛ̱i̱ p'ʉya. Ra̱ Herodes co gätho yø ja̱'i̱ bi ho te øtra̱ hmu̱te. Ja̱na̱ngue bi 'yɛ̱mbra̱ hmu̱te ra̱ Herodes: “Nu̱'mø tema̱ cosa gui 'yäqui, nu̱gä ga̱ 'da'i”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ra̱ Herodes bi 'yɛ̱xa̱ ntestigo Oja̱ ngue ma̱jua̱ni̱ di u̱nna̱ hmu̱te'a̱ te gäma̱ cosa da̱ 'yäpi, ma̱da̱gue'a̱ di u̱n ma̱de'a̱ te gä pɛts'i. ");
INSERT INTO otnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ra̱ hmu̱te p'ʉya, hi̱nga̱ 'bexpi xifi te 'bɛ'a̱ nne da̱ 'yäpi. Sinoque 'be bá̱ änna̱ mamá. Bi 'yɛ̱mbi̱: “Ague mamá, ¿teni̱ 'bɛ'a̱ ga̱ ädi?” Nu̱'a̱ rá̱ mamá ra̱ hmu̱te p'ʉya, bi 'yɛ̱mbi̱: “Da̱mi̱ 'yäpya ngue di 'da'i rá̱ ya̱ ra̱ Xuua mi̱ øtra̱ nxixya̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nu̱'a̱ ra̱ hmu̱te p'ʉya, bi̱ mengui̱, i̱ ma mbo, ngue bá̱ ɛ̱mbra̱ da̱st'abi: “Nu̱'a̱ rá̱ ya̱ ra̱ Xuua mi̱ øtra̱ nxixya̱ ya, da̱mi̱ 'daqui, di o n'na ra̱ mohi”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mi̱ zä mi̱ 'yøde te 'bɛ'a̱ t'äpra̱ da̱st'abi, ma̱mbi du̱drá̱ mmʉi. Pɛ ya xi̱ ma̱ ngue di u̱nna̱ hmu̱te'a̱ te da̱ 'yäpi. Yø ja̱'i̱ 'bʉp'ʉ ha mi̱ 'bʉi, gä xi 'yøde te xi̱ ma̱. Bi̱ ma̱nda p'ʉya ngue bi t'u̱nna̱ hmu̱te'a̱ te ädi. ");
INSERT INTO otnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Bi 'yɛt'a̱ n'na ra̱ soldado da̱ hɛjpa̱ rá̱ ya̱ ra̱ Xuua p'ʉ ja ra̱ fädi p'ʉya. Bá̱ jät'a̱ n'na ra̱ mohi, bi t'u̱nna̱ hmu̱te. Ra̱ hmu̱te p'ʉya, bi däprá̱ mamá'a̱ ra̱ ya̱ bi t'u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mi̱ ba̱hyø xädi ra̱ Xuua ngue ya bi du̱, bi̱ ma bá̱ ha̱nnba̱ rá̱ do'yo ra̱ ánima ngue bi 'yägui. ");
INSERT INTO otnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ma̱mbá̱ pengyø xädi ra̱ Jesús ngue bá̱ ma̱nna̱ hya̱ p'ʉ ja yø hni̱ni̱, bi däpra̱ güɛnda te xi 'yøt'e, bi däpra̱ güɛnda tema̱ hya̱ xi̱ nxännba̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nu̱'ʉ yø pa'ʉ, ni̱ ma ni̱ 'yɛ̱hyø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús. Nu̱na̱ ra̱ Jesús co 'nɛ̱hyø xädi, ni̱ xi̱ngra̱ hmɛ̱ da̱ mbongui ra̱ ora da̱ zi. Ja̱na̱ngue bi 'yɛ̱mbyø xädi: ―A nu̱yá, ma ga̱ mmähä p'ʉ hi̱njo'o yø ja̱'i̱ ya, n'namhma̱ ga̱ nsäyahʉ zits'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bi yʉrbʉ ja n'na ra̱ barco ra̱ Jesús conyø xädi, i̱ map'ʉ hi̱njongui̱ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Xa̱ngu̱ yø ja̱'i̱ bi̱ nu̱ 'mø mi̱ ma ra̱ barco, pɛ pa̱di̱ te'o ni̱ op'ʉ ja ra̱ barco. Bi̱ ma yø ja̱'i̱ p'ʉya, ní̱ n'yoguatho, bi dɛnna̱ nenzabi. Nu̱p'ʉ ja yø hni̱ni̱ thohyø ja̱'i̱, i tɛr'mi̱'da yø ja̱'i̱, ma̱ndøngu̱rbʉ ni̱ ma yø ja̱'i̱. M'mɛt'o bi zønyø ja̱'i̱ p'ʉ ha ja ngue da̱ zønna̱ barco. ");
INSERT INTO otnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mi̱ zøhra̱ barco bá̱ o ra̱ Jesús, bi bøni̱. Pɛ ya ma̱ndøngu̱ dyø ja̱'i̱ 'bʉp'ʉ. Bi huɛ̱jpʉya, porque yø ja̱'i̱ 'bʉi tengu̱tho yø dɛ'yo 'mø hi̱njo'o to da̱ mädi, njarbʉtho. Ja̱na̱ngue ndø ya'atho ra̱ ora bi xännba̱bi̱ ra̱ hya̱ yø ja̱'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ya ni̱ ma di̱ nde p'ʉya, bi guatyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ya bi̱ nde, 'nɛ̱ nu̱ua dí 'bʉhmʉ ra̱ da̱po ua. ");
INSERT INTO otnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Da̱mi̱ 'yɛ̱hyø ja̱'i̱, n'namhma̱ da̱ map'ʉ bí ja yø hni̱ni̱, da̱ dänsɛ ra̱ hmɛ̱ da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bi 'yɛ̱mbyø xädi ra̱ Jesús: ―Da̱mi̱ u̱nhnʉ ra̱ hmɛ̱ da̱ zi yø ja̱'i̱ ―bi 'yɛ̱mbi̱. Nu̱'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―¿Hapʉ gue ga̱ ha̱hʉ'a̱ yo ciento ma̱ pa ra̱ nzäbi ngue ga̱ tämphʉ ra̱ hmɛ̱ da̱ zi yø ja̱'i̱ 'bʉcua? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma̱hømbi 'yɛ̱mbyø xädi ra̱ Jesús: ―Da̱mi̱ nu̱ hangu̱ yø thu̱hmɛ̱ guí ha̱hʉ. Nu̱'ʉ yø xädi p'ʉya, bi̱ nu̱ hangu̱ yø thu̱hmɛ̱ ha̱. Bi 'yɛ̱mbʉya: ―Ja ua cʉt'a yø thu̱hmɛ̱ 'nɛ̱ yoho yø hua̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ra̱ Jesús bi 'yɛ̱mbyø xädi ya̱ui: ―Da̱mi̱ xihmʉ yø ja̱'i̱ da̱ mi̱cua ja ra̱ 'batha. Da̱ 'yøtyø zimu̱ndo p'ʉ da̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bi̱ mi̱hyø ja̱'i̱ p'ʉya ngue di̱ nsi̱hmɛ̱. Yø ciento nja̱'i̱ p'ʉ bi̱ mi̱ i'da, yø yote ma̱'dɛt'a nja̱'i̱ p'ʉ bi̱ mi̱ i'da. ");
INSERT INTO otnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ra̱ Jesús bi hya̱n'ʉ cʉt'a yø thu̱hmɛ̱ 'nɛ̱'ʉ yoho yø hua̱. Bi hyanma̱ hɛ̱ts'i̱ p'ʉya, bi ja ma̱mma̱di̱ Oja̱. Bi xɛnyø thu̱hmɛ̱ p'ʉya, bi u̱nyø xädi ngue di 'darpa̱bi̱ yø ja̱'i̱. Da̱ guehyø hua̱ bi dat'i. ");
INSERT INTO otnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bi̱ nsi̱hmɛ̱ xa̱nho yø ja̱'i̱, gä bi̱ nni̱ya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mi̱ juate ra̱ ts'i̱hmɛ̱ yø ja̱'i̱ p'ʉya, nu̱'ʉ yø xädi ra̱ Jesús bi pɛti 'dɛ'ma̱yo canasta yø thu̱hmɛ̱ bi bongui̱. Xquet'a̱ bi̱ mɛs'yø hua̱ bi bongui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nu̱'ʉ yø ja̱'i̱ bi̱ nsi̱hmɛ̱'a̱ ra̱ ora'a̱, cʉt'a ma̱hua̱hi̱ ma̱'yohʉ bi̱ nsi̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mɛ̱nte ɛ̱hyø ja̱'i̱ ra̱ Jesús, bi xihyø xädi ngue di̱ m'mɛt'o da̱ 'yo ra̱ barco, di̱ ma ma̱n'na nguadi ra̱ zabi ha bí ja ra̱ hni̱ni̱ Betsaida. ");
INSERT INTO otnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mi̱ juadi bi 'yɛ̱hyø ja̱'i̱ ra̱ Jesús, bi̱ map'ʉ bí ja ra̱ nyu̱ni̱ ngue bá̱ mat'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mi̱ nxu̱i̱ p'ʉya, ya bí 'yo ma̱de ra̱ zabi ra̱ barco ni̱ o yø xädi, pɛ ra̱ Jesús bi 'bʉsɛ p'ʉ bí ja ra̱ nyu̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bi ba̱hra̱ Jesús ngue hangu̱ pɛfi di 'yonna̱ barco'ʉ yø xädi, pɛ hi̱ngui̱ sä da̱ thogui, porque ra̱ nda̱hi̱ di cots'i. Mi̱ zʉ'i hyu̱ xu̱di̱ p'ʉya, bi̱ map'ʉ bí 'bʉhyø xädi ra̱ Jesús, ni̱ 'yo ma̱xøts'e ra̱ dehe. Bi̱ ne ngue xta̱ nui̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pɛ mi̱ hyandyø xädi ngue mmap'ʉ ni̱ 'yo ma̱xøts'e ra̱ dehe. Nu̱'ʉ yø xädi ra̱ Jesús bi 'yɛ̱na̱ ngue ra̱ nda̱hi̱ i̱ nnu̱. Bi̱ mʉhra̱ mafi p'ʉya ngue su̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gä bi hyandi̱, pɛ gä bi̱ nsu̱. Pɛ ra̱ Jesús 'bexpi zofo, bi 'yɛ̱mbi̱: ―Go guecä, 'yoguí su̱hʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mi̱ yʉrbʉ ja ra̱ barco mi̱ o yø xädi ra̱ Jesús, 'bexpi̱ nsäya ra̱ nda̱hi̱. Mi̱ nu̱ yø xädi'a̱ te bi 'yøt'e, ma̱n'natho bi̱ nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ma̱da̱gue'a̱ xi̱ nu̱ yø xädi'ʉ yø milagro xi 'yøtra̱ Jesús, ngue bi xa̱ndyø thu̱hmɛ̱ bi zi yø ja̱'i̱, pɛ hi̱ngui̱ 'yo yø mmʉi te'o na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mi̱ zøn'a̱ nenthe ja ra̱ häi Genesaret, bi da̱t'yø barco 'mø mi̱ bøni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Høntho bi bønna̱ barco ra̱ Jesús, 'bexpi ba̱hyø ja̱'i̱ mi̱ 'bʉp'ʉ ngue te'o. ");
INSERT INTO otnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bi̱ ma yø ja̱'i̱ p'ʉya, bi 'yonnba̱bi̱ mi̱'da yø ja̱'i̱ ngue da̱ ɛ̱hɛ̱. Xifi ngue da̱ tu̱ yø därquɛ̱hi̱ da̱ oxyø fi̱di̱, da̱ zøp'ʉ 'bʉhra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hønnbʉ bi zä sønna̱ Jesús, sømp'ʉ ja yø hni̱ni̱, sømp'ʉ ja yø ngu̱nhui̱, hønnbʉ ts'ʉ hapʉ søni̱, bi̱ njʉqui yø därquɛ̱hi̱ ngue 'bop'ʉ ja yø caye, t'äpra̱ ma̱te ra̱ Jesús squera̱ngue rá̱ nya̱ni̱ rá̱ he da̱ därpa̱bi̱ yø därquɛ̱hi̱. 'Be xi sä ha hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nu̱ya 'da yø fariseo 'nɛ̱hyø xännba̱te ngue ra̱ ley ngue yø mmɛ̱ngu̱ Jerusalén bi guarbʉ 'bähra̱ Jesús ngue di̱ nya̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bi̱ mbøcuɛ 'mø mi̱ nu̱ te øt'i'da yø xädi ra̱ Jesús, ngue hi̱ngui̱ xʉ'yɛ hante di̱ nsi̱hmɛ̱, ngue da̱ mecra̱ ts'oqui n'youi yø 'yɛ. ");
INSERT INTO otnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nu̱ya yø fariseo 'nɛ̱ gätho mi̱'da yø judío, i øtyø costumbre xa̱ nzänyø ndiua. Za̱nt'a̱ xʉ'yɛ hante di̱ nsi̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nu̱'mø bá̱ penga̱ täi xquet'a̱ xʉ'yɛ, porque ɛ̱na̱ ngue pecra̱ ts'oqui ja yø 'yɛ. Xa̱ngu̱ mi̱'da yø costumbre øt'e, xʉtyø ts'øye, xʉtyø mohi, pu̱nnbi̱ da̱ dätra̱ häi. 'Nɛ̱hyø t'ots'i nts'i̱hmɛ̱ pet'e. ");
INSERT INTO otnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mi̱ zä mi̱ nu̱rpi te øtyø xädi ra̱ Jesús ngue hi̱ngui̱ øt'e tengu̱tho ga̱ 'yo, bi̱ mbøcuɛ p'ʉya, bi 'yørpa̱ ra̱ nt'änni̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hanja ni̱ xädi ngue fɛstho ra̱ hya̱ bi zoga̱hʉ yø ndiua? Porque hi̱ngui̱ pecra̱ ts'oqui ja yø 'yɛ, ngue di̱ nxʉ'yɛ hante di̱ nsi̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ni̱ xirbʉ guí ɛ̱na̱ ngue guí ɛ̱c'ɛ̱i̱hʉ Oja̱. Go guí øthʉ na̱ ra̱ hya̱ bi 'yotra̱ pønga̱hya̱ Isaías ngue bi 'yɛ̱n'Oja̱: “Nu̱ya yø ja̱'i̱ 'bʉcua, nu̱'mø bi̱ nya̱, xøgue ɛ̱na̱ ma̱jua̱ni̱ ngue nnu̱ ma̱nsu̱gui̱. Pɛ hi̱mma jua̱ni̱ ngue yø mmʉi ga̱ nda̱nnegui. ");
INSERT INTO otnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ya hi̱nte ni̱ bøntho ngue tha̱nnegui yø ja̱'i̱. Nu̱ te gäma̱ hya̱ xännba̱te, xa̱ngu̱ yø hya̱ xa̱ nzänsɛ ngue ɛ̱mbi̱ di̱ ma̱nda Oja̱”, ngu̱na̱ bi̱ ma̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nu̱'a̱hʉ, guí fɛsthohʉ yø hya̱ di̱ ma̱nda Oja̱ ngue go ga̱di ja ndu̱mmʉi guí øthʉ yø costumbre bi zohyø ndiua. Porque xa̱ngu̱ yø costumbre guí øthʉ, tengu̱ yø ts'øye 'nɛ̱hyø mohi guí xʉthʉ, pu̱nnbi̱ da̱ dätra̱ häi. ");
INSERT INTO otnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Go xcá̱ 'yɛmhmʉ n'na nguadi ya yø hya̱ di̱ ma̱nda Oja̱ ngue go guí øthʉ yø costumbre bi zohyø ndiua. ");
INSERT INTO otnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nu̱na̱ ra̱ Moisés bi xihyø ja̱'i̱ te 'bɛ'a̱ ja ngue da̱ 'yøt'e, bi 'yɛ̱mbi̱: “Da̱mi̱ su̱ ni̱ papá, da̱mi̱ su̱ ni̱ mamá”. Bi xi ma̱n'na ra̱ hya̱ p'ʉya, bi 'yɛ̱mbi̱: “Nu̱ ra̱ ja̱'i̱ da̱ zanná̱ papá, ogue da̱ zanná̱ mamá, i ja ngue di̱ njapra̱ castigo 'nɛ̱ da̱ tho”, bi 'yɛ̱mbyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pɛ ya xcá̱ xännba̱hʉ yø ja̱'i̱, ngue ra̱ ja̱'i̱ da̱ zä da̱ 'yɛ̱mbrá̱ papá ogue rá̱ mamá: “Nu̱gä papá, nu̱gä mamá, ya hi̱nda̱ zä ga̱ 'da'i te guí siui ya. Porque nu̱ te gä dí pɛts'i, guehna̱ Oja̱ da̱di̱ u̱nni̱”. ");
INSERT INTO otnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nu̱'mø ngu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ ja̱'i̱ p'ʉya, ya hi̱n ga̱di japhʉ di jamma̱nsu̱ rá̱ papá ogue rá̱ mamá ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Xa̱ngu̱ mi̱'da yø hya̱ jap'ʉ hi̱nguí̱ øthʉ, tengu̱tho ya yø hya̱ dí xi'a̱hʉ ya. Nu̱'mø ngu̱na̱ guí øthʉ p'ʉya, ya guí øthʉ ngue hi̱nte di̱ mu̱ui ya yø hya̱ di̱ ma̱nda Oja̱ p'ʉya, ngue guí ɛ̱mhmʉ go ja ts'ɛditho gui 'yøthʉ ya yø costumbre bi zohyø ndiua. ");
INSERT INTO otnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bi zonhyø ja̱'i̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'yøhmʉ xa̱nho ya yø hya̱ ga̱ mma̱ngä ya. Da̱mi̱ 'yɛ̱t'a̱mmʉihʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nu̱ ra̱ ja̱'i̱ øtra ts'oqui, hi̱nga̱ gue'a̱ te si ra̱ ja̱'i̱ ga̱ 'yøtra̱ ts'oqui. Nu̱'a̱ ga̱ 'yøtra̱ ts'oqui ra̱ ja̱'i̱, gue'a̱ ra̱ ts'omhya̱ pønná̱ ne ra̱ ja̱'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ na̱ ra̱ hya̱ dí̱ mma̱ngä ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mi̱ ma yø ja̱'i̱ p'ʉya, bi zop'ʉ ra̱ Jesús. Nu̱na̱ ra̱ Jesús bi̱ map'ʉ ja ra̱ ngu̱ säya. Nu̱ya yø xädi p'ʉya, bi 'yäpi ngue da̱ xifi te ga̱ mbønya yø hya̱ ja juadi bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―¿Ua xquet'a̱ hi̱ngui̱ ti̱nni̱ mmʉihʉ hanja ya yø hya̱ dí̱ mma̱ngä 'mø? ¿Ua hi̱nguí̱ pa̱hmʉ na̱ ra̱ hya̱ dá̱ ma̱ngä ngue nu̱ te si ra̱ ja̱'i̱, hi̱nga̱ gue'a̱ ra̱ ts'oqui'a̱? ");
INSERT INTO otnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porque nu̱'a̱ te gä si ra̱ ja̱'i̱, hi̱ndi̱ nua̱nsui rá̱ n'yomfɛ̱ni̱ ra̱ ja̱'i̱'a̱, sinoque rá̱ mmʉi ra̱ ja̱'i̱ ni̱ ma'a̱ te si, pɛ pigui te si ra̱ ja̱'i̱. Ngue ngu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, di̱ nɛ̱qui̱ xa̱nho ngue nu̱'a̱ te gä si ra̱ ja̱'i̱, bi 'yøt'e ngue gä xa̱nho ngue da̱ ts'i. ");
INSERT INTO otnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ra̱ Jesús bi sigue bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱ ra̱ ja̱'i̱ ngue øtra̱ ts'oqui, mbo rá̱ n'yomfɛ̱ni̱ ní̱ 'yɛ̱hra̱ ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porque mbo rá̱ n'yomfɛ̱ni̱ ra̱ ja̱'i̱ bi̱ mi̱hra̱ ts'o n'yomfɛ̱ni̱, tengu̱ ra̱ n'yots'om'mäi, ra̱ nthote, ");
INSERT INTO otnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ra̱ mfɛ̱, ra̱ nts'o, ra̱ fɛhni̱, ra̱ 'yøt'its'oqui, ra̱ zɛya, ra̱ zate, ra̱ n'yɛ̱ts'i̱, ra̱ m'mɛmmʉi, da̱ gue'a̱ so rá̱ mmʉi ngue da̱ hya̱nnba̱ rá̱ mmɛti rá̱ mmi̱c'ɛ̱i̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gätho ya yø nts'o ya, mbo rá̱ n'yomfɛ̱ni̱ ra̱ ja̱'i̱ ní̱ 'yɛ̱hɛ̱. Guehya di ts'onna̱ ja̱'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mi̱ bømp'ʉ mi̱ 'bʉhra̱ Jesús, i̱ map'ʉ ja n'na ra̱ häi ja ra̱ hni̱ni̱ Tiro conna̱ hni̱ni̱ Sidón. Nu̱p'ʉ ja ra̱ ngu̱ bi̱ nsäya, hi̱ngui̱ nnepe to xta̱ mba̱di̱ ngue 'bʉp'ʉ. Pɛ hi̱mbi̱ zä bi̱ n'ya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nu̱'a̱ ra̱ hni̱ni̱'a̱, mi̱ 'bʉp'ʉ n'na ra̱ hmu̱te mi̱ n'youi ra̱ ts'onthi̱. Mi̱ 'yøhrá̱ mamá ra̱ hmu̱te ngue 'bʉp'ʉ ra̱ Jesús. Bi̱ ma ra̱ xisu p'ʉ 'bʉhra̱ Jesús, bi̱ nda̱ntyøhmu̱ p'ʉ 'bäi. ");
INSERT INTO otnNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pɛ hi̱ngra̱ judío na̱ ra̱ xisu, porque ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ häi Sirofenicia. Bi 'yäpra̱ ma̱te ra̱ Jesús ngue da̱ 'yøthebi rá̱ t'i̱xu̱ n'youi ra̱ ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱gä, gue'ʉ yø judío ja ts'ɛdi ga̱ fäts'i. A nu̱yá, nu̱'mø 'bet'o go ga̱ fäxa̱'i̱, ya sʉtho 'mø da̱ tha̱nnba̱ ra̱ hmɛ̱ yø ba̱si̱, ngue yø fo'yo di t'u̱nni̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ra̱ xisu p'ʉya, bi 'yɛ̱mbi̱: ―A̱há̱, grá̱ Hmu̱, gue'a̱ guí̱ mma̱. Pɛ nu̱'ʉ yø fo'yo, guep'ʉ 'bimɛ̱xa si̱hmɛ̱'ʉ. I jo yø xɛmhmɛ̱ hɛhyø ba̱si̱ p'ʉ si̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ra̱ Jesús bi 'yɛ̱mbra̱ xisu: ―Xa̱nho te guí̱ mma̱. Ni̱ ma ni̱ ngu̱ ya, nu̱ ni̱ t'i̱xu̱ n'youi ra̱ ts'onthi̱, ya bi zä. ");
INSERT INTO otnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ra̱ xisu p'ʉya, bi̱ mengui̱, i̱ ma rá̱ ngu̱. Mi̱ zønná̱ ngu̱ p'ʉya, nu̱'a̱ rá̱ t'i̱xu̱ mi̱ n'youi ra̱ ts'onthi̱ ya hu̱p'ʉ ja rá̱ t'ots'i, ya xi zä te mi̱ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mi̱ 'danyø pa p'ʉya, bi bømp'ʉ mi̱ 'bʉhra̱ Jesús, i̱ map'ʉ ja ra̱ zabi Galilea. I̱ nthop'ʉ ja ra̱ hni̱ni̱ Sidón, i̱ mpa p'ʉ ja ra̱ häi Decápolis. ");
INSERT INTO otnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nu̱p'ʉ ja ra̱ häi Decápolis mi̱ zømp'ʉ ra̱ Jesús, bá̱ ts'innba̱bi̱ n'na ra̱ n'yohʉ ngue ra̱ gogu̱ 'nɛ̱ ra̱ c'ʉne. Bi t'äpra̱ ma̱te ngue bi japyø 'yɛ p'ʉ ja rá̱ ya̱ ngue da̱ zä te hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nu̱na̱ ra̱ Jesús bi zica̱ n'nani̱ na̱ ra̱ n'yohʉ, bi cʉrpa̱ yø saha p'ʉ ja yø gu̱. Bi pohrá̱ saha conná̱ ji̱ni̱ ngue bi därpa̱ rá̱ ja̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bi hyanma̱ hɛ̱ts'i̱ p'ʉya, bi 'yɛ̱n'a̱ n'na ra̱ ja̱ts'i̱. Bi 'yɛ̱mbra̱ därquɛ̱hi̱ p'ʉya: ―Efata ―bi 'yɛ̱mbi̱. Nu̱na̱ ra̱ hya̱ bi̱ ma̱, i̱ nne da̱ ma̱ ngue ɛ̱na̱: “Da̱ xohni̱ ne, da̱ xohni̱ gu̱”. ");
INSERT INTO otnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nu̱'a̱ ra̱ ora'a̱, nu̱na̱ ra̱ n'yohʉ mi̱ gogu̱ bi 'yøde xa̱nho ra̱ hya̱, 'nɛ̱ bi zä bi̱ nya̱ xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pɛ ra̱ Jesús bi xihyø ja̱'i̱ ngue hi̱njonda̱ xifi te bi̱ nu̱rpi̱ bi 'yøt'e. Pɛ ɛ̱na̱ ma̱n'na ngue di hɛjpa̱bi̱ yø ja̱'i̱ ngue hi̱nte da̱ ma̱, i̱ mma̱nyø ja̱'i̱ p'ʉ ni̱ ma'a̱ te xi nu̱rpi̱ xi øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nu̱ to gä bi 'yøde te bi̱ nja, gä di 'yødyø ja̱'i̱, di̱ n'yɛ̱mbi̱: ―Gä xa̱nho te øt'e. Porque øt'e ngue øhra̱ hya̱ yø gogu̱, 'nɛ̱ di japi ngue ya̱ xa̱nho yø gone. ");
INSERT INTO otnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ma̱n'na ra̱ pa p'ʉya, xa̱ndøngu̱ yø ja̱'i̱ bi̱ mpɛti p'ʉ 'bʉhra̱ Jesús. Ya hi̱n'yʉ te da̱ zi yø ja̱'i̱, ya bi hyätyø nzɛdi. Bi zonhyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Da̱di huɛ̱cä yø ja̱'i̱ 'bʉcua, porque ya rá̱ hyu̱ pa 'daua dí 'yohʉ ya. Dí pa̱'a̱ njua̱ni̱ ngue ya hi̱n'yʉ te da̱ zi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu̱'mø ga̱ ɛtyø ja̱'i̱ ngue da̱ ma yø ngu̱, 'nɛ̱ hi̱ngui̱ si̱hmɛ̱, da̱ güennbʉ ja ra̱ 'yu̱. Porque yap'ʉ yø ngu̱ 'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nu̱'ʉ yø xädi bi 'yɛ̱mbi̱: ―Pɛ ¿hapʉ go ga̱ ha̱nnba̱hʉ te da̱ zi ya yø ja̱'i̱ 'bʉcua? A nu̱ua dí 'bʉhmʉ, ra̱ da̱po ua. ");
INSERT INTO otnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bi 'yänyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hangu̱ yø thu̱hmɛ̱ guí ha̱hʉ 'mø? Nu̱'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Høndi yoto yø thu̱hmɛ̱ ja ua. ");
INSERT INTO otnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bi̱ ma̱nda ra̱ Jesús ngue bi̱ mi̱hyø ja̱'i̱. Bi hya̱n'ʉ yoto yø thu̱hmɛ̱ p'ʉya, bi ja ma̱mma̱di̱ Oja̱. Bi xɛnyø thu̱hmɛ̱ p'ʉya, bi u̱nyø xädi ngue di 'darpa̱ yø ja̱'i̱ da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xquet'a̱ mi̱ ha̱ zihangu̱ yø hua̱. Ra̱ Jesús bi ja ma̱mma̱di̱ Oja̱. Bi u̱nyø xädi p'ʉya, ngue di 'darpa̱ yø ja̱'i̱ da̱ za. ");
INSERT INTO otnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Nu̱'ʉ yø ja̱'i̱ bi̱ nsi̱hmɛ̱, goho ma̱hua̱hi̱ ma̱'yohʉ. Pɛ gä bi̱ nni̱ya̱. Mi̱ juate ra̱ ts'i̱hmɛ̱ yø ja̱'i̱, nu̱'ʉ yø xädi ra̱ Jesús bi pɛti yoto canasta yø thu̱hmɛ̱ bi bongui̱. 'Bexque'a̱ bi̱ n'yɛ̱hmi̱ yø ja̱'i̱ ra̱ Jesús ngue bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bi yʉrbʉ ja ra̱ barco p'ʉya, co 'nɛ̱hyø xädi, i̱ map'ʉ ja ra̱ häi Dalmanuta. ");
INSERT INTO otnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ngu̱ i zøhra̱ Jesús, nu̱ya yø fariseo bi̱ ma bá̱ sämhya̱ ra̱ Jesús. Di 'bɛpi da̱ 'yøt'a̱ n'na ra̱ milagro nʉ ma̱hɛ̱ts'i̱ para ngue di̱ nɛ̱qui̱ ngue rá̱ m'mɛnhni̱ Oja̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bi̱ nga̱sra̱ Jesús, bi 'yɛ̱mbi̱: ―Høndyø milagro guí̱ nne guí̱ nnu̱hʉ di̱ nja. Pɛ nu̱gä dí xi'a̱hʉ ngue hi̱n tema̱ milagro ga̱ øt'ä guí̱ nnu̱hʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bi zop'ʉ yø ja̱'i̱ p'ʉya, bi yʉrbʉ ja n'na ra̱ barco conyø xädi, i̱ ma ma̱n'na nguadi ra̱ zabi. ");
INSERT INTO otnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nu̱'ʉ yø xädi ra̱ Jesús xi pu̱mbɛ̱ni̱ ra̱ thu̱hmɛ̱ xta̱ hya̱ts'i̱ da̱ zi. Hønda̱ n'na ra̱ thu̱hmɛ̱ mi̱ ha̱p'ʉ ja ra̱ barco. ");
INSERT INTO otnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Da̱mi̱ mfähmʉ ya, ma̱mi̱ sihʉ'a̱ ra̱ íxi di u̱nyø fariseo da̱ guehra̱ Herodes. ");
INSERT INTO otnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na'ʉ yø xädi p'ʉya: ―Rá̱ nzɛgui xicjʉ ya ngue hi̱nxtá̱ ha̱ ra̱ thu̱hmɛ̱ ga̱ sihʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mi̱ ba̱hra̱ Jesús te di̱ nxihyø xädi, bi 'yɛ̱mbʉya: ―Gue guí ɛ̱na̱ dí xi'a̱hʉ ngue hi̱nxcuá̱ ha̱ ra̱ thu̱hmɛ̱ gui sihʉ. ¿Ua hi̱ngui̱ 'yo ni̱ mmʉihʉ na̱ ra̱ hya̱ dí̱ mma̱ngä 'mø? Rá̱ nzɛgui ma̱'bɛdi ni̱ mmʉihʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Guí̱ nnu̱hʉ te dí øt'ä, pɛ tengu̱tho 'mø ngue hi̱nte gdí̱ nnu̱hʉ. Guí øhmʉ yø hya̱ dí̱ mma̱ngä, pɛ tengu̱tho 'mø hi̱n tema̱ hya̱ gdí øhmʉ. ¿Ua hi̱nguí̱ mbɛ̱mhmʉ'a̱ te guí̱ nnu̱hʉ p'ʉ ha nná̱ mähä? ");
INSERT INTO otnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xi'mø ra̱ pa ma̱ xɛngä'ʉ cʉt'a yø thu̱hmɛ̱ ngue bi zi cʉt'a ma̱hua̱hi̱ ma̱'yohʉ, ¿njammi̱ canasta yø thu̱hmɛ̱ bi bongui̱? Nu̱'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―'Dɛ'ma̱ yo canasta yø thu̱hmɛ̱ bi bongui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Xi'mø ma̱ xɛngä'ʉ yoto nthu̱hmɛ̱ ngue bi zi goho ma̱hua̱hi̱ ma̱'yohʉ, ¿njammi̱ canasta yø thu̱hmɛ̱ bi bongui̱? ―bi 'yɛ̱mbi̱. Yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Yoto canasta yø thu̱hmɛ̱ bi bongui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ra̱ Jesús bi 'yɛ̱mbi̱ ma̱høn'a̱ p'ʉya: ―Pɛ ¿hanja ngue hi̱ngui̱ 'yo ni̱ mmʉihʉ ya yø hya̱ dí̱ mma̱ngä 'mø? ");
INSERT INTO otnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mi̱ zømp'ʉ ja ra̱ hni̱ni̱ Betsaida ra̱ Jesús, bá̱ ts'i̱nnba̱bi̱ n'na ra̱ xädä. Bi t'äpra̱ ma̱te da̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ra̱ Jesús bi bɛnnba̱bi̱ rá̱ 'yɛ ra̱ xädä, bi zixa̱ neni̱hni̱. Nu̱p'ʉ bi zøni̱, bi zorpa̱ yø dä. Bi dospa̱ ma̱xøts'e yø dä p'ʉya, bi 'yɛ̱mbi̱: ―¿Ua guí hɛ̱ti̱ zits'ʉ ya? ");
INSERT INTO otnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nu̱'a̱ ra̱ xädä p'ʉya, bi̱ nhanni̱, bi 'yɛ̱mp'ʉya: ―Dí hɛ̱tyø ja̱'i̱ ngue 'yo, pɛ ɛ̱ntho ra̱ 'bänza p'ʉ nná̱ hɛ̱ti̱, porque di hmar'ma̱ dä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma̱hømbi dospa̱ yø dä p'ʉya. Nu̱'a̱ ra̱ n'yohʉ mi̱ xädä, bi japi ngue di za di hɛ̱ti̱ p'ʉ hɛ̱ti̱. Bi̱ nzø xa̱nho yø dä p'ʉya, handi̱ yap'ʉtho. ");
INSERT INTO otnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Ni̱ ma ni̱ ngu̱ ya, 'yo 'be gui 'yo ua ja ra̱ hni̱ni̱ ngue gui xihyø ja̱'i̱ te dá̱ øt'a̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","M'mɛfa p'ʉya, bi̱ mɛ yø xädi ra̱ Jesús. Nu̱p'ʉ ja'a̱ ra̱ hni̱ni̱ Cesarea ngue Filipos, ma̱thɛ̱t'i̱ ja yø hni̱ni̱, ja bi̱ ma da̱ 'yop'ʉ ra̱ Jesús. Nu̱p'ʉ ja ra̱ 'yu̱ p'ʉya, bi 'yänyø xädi, bi 'yɛ̱mbi̱: ―¿Te'ogä p'ʉ ga̱ mbɛ̱nyø ja̱'i̱ ya'mø? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nu̱'ʉ yø xädi p'ʉya bi 'yɛ̱mbi̱: ―'Bʉ i'da yø ja̱'i̱ ɛ̱mbi̱ ngue gue'e grá̱ Xuua gmi̱ øtra̱ nxixya̱. Mi̱'da yø ja̱'i̱ p'ʉya, ɛ̱mbi̱ ngue gue'e grá̱ Elías. Mi̱'da p'ʉya, ɛ̱mbi̱ ngue 'bʉi toni̱ pønga̱hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ra̱ Jesús ma̱hømbi 'yɛ̱mbyø xädi: ―Xi'a̱hʉ p'ʉya, ¿te'ogä p'ʉ gni̱ bɛ̱mhmʉ ngue guecä? Ra̱ Bɛdu p'ʉya bi 'yɛ̱mbi̱: ―Nu̱'i̱, gue'e grá̱ Cristo, bá̱ ɛ̱xa̱'i̱ Oja̱ ngue guí̱ nda̱st'abi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ra̱ Jesús ma̱hømbi 'yɛ̱mbi̱: ―A nu̱yá, 'yo to gui xifi te'ogä ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ra̱ Jesús bi xihyø xädi, bi 'yɛ̱mbi̱: ―Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, da̱ 'yɛ̱mmɛ̱i̱ da̱ ma ma̱'ʉni̱. Nu̱'ʉ yø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱ da̱ zʉi, da̱ guehyø hmu̱ yø mmäcja̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley, gä da̱ zʉi 'nɛ̱ da̱ hyo. Pɛ rá̱ hyu̱ pa p'ʉya, di bɛ̱nna̱te ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ngu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, bi xifi xa̱nho yø xädi hanja'a̱ te da̱ thogui. Ja̱na̱ngue ra̱ Bɛdu bi zica̱ n'nanni̱ ra̱ Jesús, bi xifi ngue da̱ hyoni̱ ha di̱ mpommi̱ ra̱ nda̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pɛ ra̱ Jesús mi̱ 'yøde te sifi, bi 'bärbʉya ngue hɛ̱rhmi̱'da yø xädi. Bi zʉhra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'uegue, rá̱ mɛfi'i ra̱ zithu̱. Porque hi̱nga̱ gue'a̱ rá̱ ts'änni̱ Oja̱ so ni̱ mmʉi di̱ nja, sinoque gue'a̱ yø hya̱sɛ yø ja̱'i̱ i so ni̱ mmʉi di̱ nja ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bi zonhyø xädi ra̱ Jesús, da̱ gue hmi̱'da yø ja̱'i̱. Bi 'yɛ̱mbi̱: ―Nu̱ to nne da̱ dɛnngui̱, hi̱ngui̱ sä da̱ zänsɛ te da̱ n'yo. Hi̱nha di gohrá̱ mmʉi, ma̱da̱gue'a̱ da̱ thop'ʉ ja ra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nu̱ ra̱ ja̱'i̱ da̱ 'uegue ngue su̱ da̱ tho, guehna̱ ra̱ ja̱'i̱ di̱ m'mɛhrá̱ te na̱. Pɛ nu̱ ra̱ ja̱'i̱ hi̱ngui̱ cohrá̱ mmʉi'a̱ ga̱ 'yɛ̱c'ɛ̱i̱gui̱, ma̱da̱gue'a̱ da̱ tho conná̱ ngueque 'nɛ̱ conná̱ nguehra̱ hoga̱ 'da'yo hya̱, guehna̱ ra̱ ja̱'i̱ di̱ nya̱nná̱ te na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Porque hi̱nte da̱ da̱hra̱ ja̱'i̱, ma̱da̱gue'a̱ da̱ 'yøt'e ngue rá̱ mmɛti gä ra̱ xi̱mhäi, 'nɛ̱ di̱ m'mɛhrá̱ te. ");
INSERT INTO otnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ni̱ xi̱nda̱ hangu̱ ra̱ mɛ̱nyu̱ da̱ gu̱tra̱ ja̱'i̱, hi̱nda̱ zä da̱ ya̱nná̱ te. ");
INSERT INTO otnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A nu̱ya yø ja̱'i̱ ngue yø 'yøt'its'oqui ngue hi̱ngui̱ ørpa̱ ma̱su̱ Oja̱, guehya da̱ den'na̱thohʉ ngue guí ɛ̱c'ɛ̱i̱hʉ ma̱ hya̱gä ya. A nu̱yá, nu̱ ra̱ ja̱'i̱ ngue pɛsrá̱ sä conná̱ ngueque, ogue pɛsrá̱ sä conná̱ nguehra̱ hya̱ dí xännba̱te, xquet'a̱ da̱ 'yɛ̱hra̱ pa ngue nu̱gui̱ drá̱ N'yohʉ dá̱ ɛ̱ ma̱hɛ̱ts'i̱, xquet'a̱ ga̱ pɛs'ma̱ sä conná̱ ngue'ʉ to di jagbʉ. Guehna̱ ra̱ pa ga̱ ma pengui̱ conná̱ ts'ɛdi Oja̱, ga̱ ma n'yo'be yø ma̱ca̱ anxɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nu̱na̱ ra̱ Jesús ma̱hømbi 'yɛ̱mbyø ja̱'i̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱ya 'da 'bʉcua ya, hi̱nda̱ du̱, asta̱ gue'mø da̱ nu̱ ngue da̱ hya̱ ra̱ ts'ɛdi Oja̱ di̱ ma̱nda ua. ");
INSERT INTO otnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mi̱ tho'a̱ n'nato ma̱ pa, nu̱na̱ ra̱ Jesús bi zixra̱ Bɛdu, ra̱ Jacobo, ra̱ Xuua. Bi̱ mɛp'ʉ bí ja n'na ra̱ nyu̱ni̱ xa̱nhɛ̱ts'i̱ ngue di̱ m'mʉsɛ. Ja bá̱ nu̱p'ʉ yø xädi ngue bi̱ mpä'a̱ gui̱ nɛ̱qui̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nu̱ rá̱ he, di yoxni̱, xa̱ndønt'axi bi gohi. Hi̱njo'o n'na ra̱ meni̱ ua ja ra̱ xi̱mhäi da̱ zä da̱ menna̱ u̱lu tengu̱ ga̱ nt'axi bi gohrá̱ he ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bi̱ nu̱ yø xädi p'ʉya ngue 'bäp'ʉ ra̱ Elías conna̱ Moisés ngue ya̱ui ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ra̱ Bɛdu bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, ya xa̱nho ngue dí 'bʉhmʉ ua. Ma ga̱ hocähe hyu̱ yø t'ʉnni̱gu̱, n'na'i, n'na ra̱ Moisés, n'na ra̱ Elías ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ngu̱na̱ ra̱ hya̱ bi xifi, porque ra̱ Bɛdu co 'nɛ̱'ʉ yø amigo, ɛ̱mmɛ̱i̱ bi̱ nsu̱, asta̱ hi̱ngui̱ mbɛ̱ni̱ ha ga̱ mma̱n'a̱ ra̱ hya̱ bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","'Bexque'a̱ ra̱ ora'a̱ p'ʉya, bi go'mra̱ gu̱i̱ p'ʉ mi̱ 'bʉi. Bi 'yø p'ʉya ngue nu̱p'ʉ ja ra̱ gu̱i̱ ja bá̱ nya̱p'ʉ Oja̱, bi 'yɛ̱na̱: ―Nu̱na̱ 'bʉcua ya, guehna̱ ma̱ Ts'ʉnt'ʉ da̱di̱ ma̱di̱. Nu̱ya yø hya̱ da̱ ma̱nna̱ ya, da̱mi̱ 'yɛ̱t'a̱mmʉihʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mi̱ hyɛ̱tyø xädi p'ʉya, ya hi̱njongui 'bäp'ʉ'ʉ yoho yø n'yohʉ xi̱ nu̱. Ya 'bäsɛ p'ʉ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ya bá̱ 'yo ngue ni̱ ga̱p'ʉ ja ra̱ ngua̱ni̱ p'ʉya. Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―'Yo to gui xifi te gá̱ nu̱ui ya, asta̱ gue'mø bi hnu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ngue di bɛ̱nna̱te ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nu̱'ʉ yø xädi ra̱ Jesús, nu̱'ʉ yø hya̱ bi xifi hønt'a̱ mbɛ̱n'a̱, pɛ hi̱njombi̱ xifi te bi̱ nu̱. Sinoque di̱ nyänsɛ'ʉ yø xädi te 'bɛ'a̱ ga̱ mbønna̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús ngue ɛ̱na̱ di bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nu̱ya yø xädi ra̱ Jesús bi 'yännbʉ ja ra̱ 'yu̱, bi 'yɛ̱mbi̱: ―¿Hanja na̱ ra̱ hya̱ mma̱nyø xännba̱te ngue ra̱ ley, ɛ̱mbi̱ ngue jatho da̱ 'bɛt'o ra̱ Elías hante ngue da̱ ɛ̱hra̱ Cristo? ");
INSERT INTO otnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue ra̱ Elías i jatho ngue rá̱ mʉditho da̱ ɛ̱hɛ̱ da̱ xihyø ja̱'i̱ ngue di̱ nsä. Pɛ da̱mi̱ bɛ̱mhmʉ ra̱ hya̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue te da̱ thohra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱. I̱ mma̱mp'ʉ ngue da̱ zä ra̱ n'ʉ, da̱ zʉhyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pɛ da̱mi̱ pa̱hmʉ ya ngue nu̱na̱ t'ɛ̱mbi̱ ra̱ Elías, ya bá̱ ɛ̱hɛ̱. Ya bi̱ nja tengu̱tho ra̱ hya̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue di̱ nja. Porque nu̱ hangu̱ ra̱ n'ʉ bi̱ ne da̱ japyø ja̱'i̱, gä bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nu̱'mø ni̱ ma da̱ zøp'ʉ mi̱ 'bʉ hmi̱'da yø xädi p'ʉya, bi̱ nu̱ ngue nu̱ya yø xännba̱te ngue ra̱ ley di̱ mäspa̱bi̱ yø xädi ngue di̱ nju̱n'ma̱hya̱ui. Xa̱ngu̱ mi̱'da yø ja̱'i̱ xi̱ mpɛti p'ʉ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pɛ ra̱ Jesús, ɛ̱na̱ ha bi 'yɛ̱tho, ja̱ mi̱ nu̱ yø ja̱'i̱ ya bi zøhø, bi̱ ma yø ja̱'i̱ p'ʉya ngue di zɛngua. ");
INSERT INTO otnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―¿Te 'bɛ'a̱ gni̱ nju̱n'ma̱hya̱hʉ ya 'bʉcua? ");
INSERT INTO otnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bá̱ tha̱'a̱ n'na nc'ɛ̱i̱ p'ʉ 'bʉhyø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Ague grá̱ xännba̱te, nu̱na̱ ma̱ ts'ʉnt'ʉ 'bʉcua, n'youi ra̱ ts'onthi̱ asta̱ di gonebi, xtá̱ sigä ua ngue gui 'yøthets'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nu̱'mø bi gʉ ra̱ ts'onthi̱ n'youi, ɛn'a̱ häi 'nɛ̱ sohyø fʉgui. Di gʉxtyø ts'i, asta̱ di 'yøts'e. Ya xtá̱ xihni̱ xädi ngue xta̱ 'yøthets'ʉ, pɛ hi̱nxa̱ nzä xa̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ra̱ Jesús bi 'yɛ̱mbi̱ gätho yø ja̱'i̱ 'bʉp'ʉ: ―¿Asta̱ nja̱m'mø da̱ zønna̱ pa gui 'yɛ̱c'ɛ̱i̱ga̱hʉ? ¿Ua guí ɛ̱na̱ ngue hangu̱ ra̱ pa ga̱ sɛt'a̱hʉ? Bá̱ si ua ra̱ ts'ʉnt'ʉ, ga̱ øthegä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bi zispa̱bi̱ p'ʉya. Nu̱'mø mi̱ nu̱ ra̱ ts'onthi̱ ra̱ Jesús, bi gʉ ra̱ ts'onthi̱ ra̱ ts'ʉnt'ʉ p'ʉya. Bi 'yɛn'a̱häi asta̱ di da̱nni̱. 'Nɛ̱ sohyø fʉgui. ");
INSERT INTO otnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ra̱ Jesús bi 'yɛ̱mbra̱ papá ra̱ ts'ʉnt'ʉ: ―¿Njammi̱ pa nja p'ʉya? Mi̱ da̱hra̱ n'yohu̱ p'ʉya, bi 'yɛ̱na̱: ―Ya njap'ʉ asta̱ guep'ʉ bá̱ ngüɛ ra̱ ts'ʉnt'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nu̱'a̱ ra̱ ts'onthi̱ n'youi, mø bi gʉ, xa̱ngu̱ yø nni̱di̱ ya ja ngue da̱ hyo. I høt'a̱ sibi, ogue hørbʉ ja ra̱ dehe. Da̱mi̱ huɛ̱ga̱'be, fäxca̱'be 'mø ngue da̱ zä gui 'yøthets'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Ua hi̱ngui̱ ɛ̱c'ɛ̱i̱gui̱? Nu̱ ra̱ ja̱'i̱ ngue da̱ 'yɛ̱c'ɛ̱i̱gui̱, nu̱ te gä ma̱n'ʉ hɛ̱mbi̱, hi̱nga̱ hɛ̱mbi̱ ga̱ øthe. ");
INSERT INTO otnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nu̱'a̱ rá̱ papá ra̱ ts'ʉnt'ʉ p'ʉya, asta̱ ra̱ mafi ha i 'yɛ̱na̱: ―Nu̱gä dí ɛ̱c'ɛ̱i̱'i̱. Pɛ da̱mi̱ 'yøt'e ngue ma̱n'na ga̱ ɛ̱c'ɛ̱i̱'i̱ xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mi̱ nu̱ ra̱ Jesús ngue gä ba̱ ɛ̱p'ʉ yø ja̱'i̱ da̱ zøp'ʉ 'bäi. Ja̱na̱ngue bi xihra̱ ts'onthi̱ n'youi ra̱ ts'ʉnt'ʉ, bi 'yɛ̱mbi̱: ―Ague grá̱ ts'onthi̱, ga̱di gogu̱bi 'nɛ̱ ga̱di gonebi ra̱ ts'ʉnt'ʉ 'bʉcua. Nu̱ya dí xi'i ngue da̱mi̱ hyɛp'ʉ ya. 'Yoni̱ mantho güi pengui̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nu̱'a̱ ra̱ ts'onthi̱ p'ʉya, bi japra̱ ts'ʉnt'ʉ ngue xøgue ra̱ mafi, asta̱ päni̱. Ra̱ ndu̱ssu̱tho te ørpe. Bi 'yɛn'a̱häi 'mø mi̱ hyɛp'ʉ. Ɛ̱ntho bi du̱. Gätho yø ja̱'i̱ p'ʉya, di̱ n'yɛ̱mbi̱: ―Bi du̱ na̱ cuø ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pɛ ra̱ Jesús bi bɛnnba̱bi̱ rá̱ 'yɛ ra̱ ts'ʉnt'ʉ, ma̱hotho i xots'i. ");
INSERT INTO otnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ya 'bʉp'ʉ ja ra̱ ngu̱ ra̱ Jesús. Nu̱'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―¿Hanja ngue hi̱nxa̱ nzä xtá̱ øthegähe ra̱ ts'ʉnt'ʉ mi̱ n'youi ra̱ ts'onthi̱? ");
INSERT INTO otnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ tengu̱ na̱ ra̱ ts'onthi̱ mi̱ n'youi ra̱ ts'ʉnt'ʉ, para ngue da̱ hyɛp'ʉ ra̱ ja̱'i̱ n'youi, ma̱hyoni̱tho da̱ mat'Oja̱ ra̱ ja̱'i̱, 'nɛ̱ da̱ 'yɛtrá̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","M'mɛfa p'ʉya, ra̱ Jesús co 'nɛ̱hyø xädi bi̱ map'ʉ ha mi̱ 'bʉi, i̱ nthop'ʉ ja ra̱ häi Galilea. Pɛ hi̱ngui̱ nnepe xta̱ mba̱hyø ja̱'i̱ hapʉ di̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Porque bi xännba̱sɛ yø xädi ra̱ Jesús. Bi 'yɛ̱mbi̱: ―Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, da̱ ma ma̱ däpyø ja̱'i̱ ngue da̱ hyo. Nu̱'mø bi hyo p'ʉya, di bɛ̱nna̱te'a̱ rá̱ hyu̱ pa. ");
INSERT INTO otnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pɛ nu̱'ʉ yø xädi hi̱mbi di̱nyø mmʉi na̱ ra̱ hya̱ bi xifi. I su̱ xta̱ 'yänni̱ te ga̱ mbønya yø hya̱ xi̱ ma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mi̱ zømp'ʉ ja ra̱ hni̱ni̱ Capernaum, mi̱ yʉrbʉ ja ra̱ ngu̱ säya. Ra̱ Jesús bi 'yänyø xädi, bi 'yɛ̱mbi̱: ―¿Tema̱ hya̱ ga̱di̱ nxihmʉ p'ʉ ja ra̱ 'yu̱? ");
INSERT INTO otnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nu̱'ʉ yø xädi p'ʉya, hi̱njongui̱ tha̱di̱. Porque xi̱ nju̱n'ma̱hya̱ p'ʉ ja ra̱ 'yu̱ ngue n'na ngu̱ n'na nne ngue ma̱ da̱tho da̱ hnu̱ ma̱nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ja̱na̱ngue nu̱p'ʉ bi̱ mi̱hra̱ Jesús, bi pɛti gä 'dɛ'ma̱ yoho yø xädi, bi 'yɛ̱mbi̱: ―Nu̱'a̱ nne di̱ m'mɛt'o ya ngue nu̱'a̱hʉ, jatho da̱ 'yøtra̱ 'bɛfi ngue da̱ mäxyø amigo, pɛgue hi̱ndi̱ 'yɛ̱ts'i̱ ngue te da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ra̱ Jesús bi zonhna̱ n'na ra̱ ts'ʉnt'ʉ mi̱ 'bäp'ʉ, bi 'bämbʉ ma̱de ha 'bʉi. Bi gʉspʉya bi dɛts'i. Bi 'yɛ̱mbyø xädi p'ʉya: ");
INSERT INTO otnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nu̱ ra̱ ja̱'i̱ di ja mma̱nsu̱ n'na ra̱ ba̱si̱ tengu̱ na̱ 'bʉcua ya, ngu̱na̱ da̱ 'yøt'e porque pa̱hra̱ ja̱'i̱ ngue nu̱ te øt'e, gue'a̱ dí̱ nnu̱ ma̱nho ngue da̱ 'yøt'a̱, ɛ̱ntho go di jamma̱nsu̱ gra̱ ja̱'i̱. Nu̱ ra̱ ja̱'i̱ di ja mma̱nsu̱gui̱, hi̱nga̱ høngthogui di ja mma̱nsu̱gui̱, sinoque gue'a̱ Oja̱ bá̱ pɛnngui̱ di ja mma̱nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ra̱ Xuua p'ʉya, bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, xtá̱ nu̱gähe n'na nc'ɛ̱i̱ ngue nnøn'na̱ ni̱ thu̱hu̱ ha ga̱ 'yøthe yø ja̱'i̱ n'youi yø ts'onthi̱. Pɛ xtá̱ hɛjpa̱he, porque hi̱ndi̱ n'yohʉ p'ʉ nná̱ mähä. ");
INSERT INTO otnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―'Yo ga̱di hɛjpa̱hʉ yø ja̱'i̱ nnønnga̱ ma̱ thu̱hu̱ 'mø bi 'yøthe yø ja̱'i̱. Porque hi̱nga̱ høntho da̱ nønnga̱ ma̱ thu̱hu̱ ra̱ ja̱'i̱, xi̱nda̱ ma da̱ zangui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porque nu̱ya yø ja̱'i̱ hi̱ngui̱ sʉcjʉ, ma̱ n'yohʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nu̱ya yø ja̱'i̱ da̱ 'yøt'a̱hʉ ra̱ nho ngue i pa̱di̱ ngue guí tɛnhnʉ ra̱ Cristo, Oja̱ da̱ gu̱t'i̱. Xquet'a̱ ja rá̱ nzäbi ra̱ ja̱'i̱, ma̱da̱gue'a̱ n'na ra̱ zi vasotho ra̱ dehe di u̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A nu̱yá, nu̱'ʉ yø ba̱si̱ ɛ̱c'ɛ̱i̱gui̱ ndap'ʉ bi zä, tengu̱tho na̱ ra̱ ba̱si̱ 'bʉcua ya, nu̱ ra̱ ja̱'i̱ da̱ japi ngue da̱ hyɛga̱gui̱ p'ʉ yø ba̱si̱ ɛ̱c'ɛ̱i̱gui̱, ra̱ nda̱te castigo tø'mra̱ ja̱'i̱ da̱ thogui. Hante ngue da̱ 'yøtra̱ ts'oqui ra̱ ja̱'i̱, ma̱n'na xa̱nho ngue da̱ t'ɛnnbʉ ja ra̱ ja̱the ra̱ ja̱'i̱, di̱ ntha̱rpa̱ rá̱ 'yʉga n'na ra̱ njʉni̱ ngue da̱ gʉ'mi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ja̱na̱ngue nu̱'mø guí ɛ̱na̱ ngue rá̱ ts'oqui ni̱ 'yɛ p'ʉ gá̱ 'yøtra̱ ts'oqui, da̱mi̱ hyɛjni̱ 'yɛ, gui 'yɛi. Ma̱n'na xa̱nho ngue ga̱rá̱ do'yɛ 'mø gá̱ cʉrbʉ ha gui̱ m'mʉhmi̱ Oja̱, hi̱nda̱ gue'a̱ ngue di ja gä yoho ni̱ 'yɛ 'nɛ̱ ngu̱tho gui̱ mma ra̱ ni̱du̱ hapʉ ja ra̱ sibi di da̱nzø para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nu̱p'ʉ ja ra̱ ni̱du̱ 'bʉhyø dønxʉ hi̱nha rá̱ nzɛgui da̱ zi'a̱ ni̱ ngø. Ra̱ sibi p'ʉya, hi̱nja̱m'mø da̱ huɛ̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nu̱'mø guí ɛ̱na̱ ngue rá̱ ts'oqui ni̱ gua p'ʉ gá̱ 'yøtra̱ ts'oqui, da̱mi̱ hyɛqui, gui 'yɛi. Ma̱n'na xa̱nho ngue ga̱rá̱ dogua 'mø gá̱ cʉrbʉ ha gui̱ m'mʉhmi̱ Oja̱, hi̱nda̱ gue'a̱ ngue di ja gä yoho ni̱ gua 'nɛ̱ ngu̱tho gui̱ mma ra̱ ni̱du̱ hapʉ ja ra̱ sibi di da̱nzø para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nu̱p'ʉ ja ra̱ ni̱du̱ 'bʉhyø dønxʉ hi̱nha rá̱ nzɛgui da̱ zi'a̱ ni̱ ngø. Ra̱ sibi p'ʉya, hi̱nja̱m'mø da̱ huɛ̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nu̱'mø guí ɛ̱na̱ ngue rá̱ ts'oqui ni̱ dä p'ʉ gá̱ 'yøtra̱ ts'oqui, da̱mi̱ hya̱hni̱ dä, gui 'yɛi. Ma̱n'na xa̱nho ngue da̱ n'natho ni̱ dä 'mø gá̱ cʉrbʉ ha gui̱ m'mʉhmi̱ Oja̱, hi̱nda̱ gue'a̱ ngue di ja gä yoho ni̱ dä 'nɛ̱ ngu̱tho gui̱ mma ra̱ ni̱du̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nu̱p'ʉ ja ra̱ ni̱du̱ 'bʉhyø dønxʉ hi̱nha rá̱ nzɛgui da̱ zi'a̱ ni̱ ngø. Ra̱ sibi p'ʉya, hi̱nja̱m'mø da̱ huɛ̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Porque nu̱ to gä da̱ ma ra̱ ni̱du̱, di̱ nzø conna̱ sibi. ");
INSERT INTO otnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tengu̱ ra̱ u̱, xa̱nho ngue te di̱ ma ma̱'u̱t'i̱. Pɛ nu̱'mø ya hi̱ngui̱ u̱, ya hi̱nte di̱ mu̱ui. Xquet'a̱ gui̱ njathʉ p'ʉya, 'yo guí̱ nnehʉ ngue hi̱nte da̱di̱ mu̱ui'a̱ te gni̱ 'yohʉ. 'Yo ga̱di̱ nju̱nt'i n'na ngu̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nu̱na̱ ra̱ Jesús mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Capernaum, pɛ bi̱ ma i̱ mpa p'ʉ ja ra̱ häi Judea. Bi thogui i̱ ma ma̱n'na nguadi ra̱ da̱the Jordán. Ma̱ndøngu̱ dyø ja̱'i̱ bi zømp'ʉ 'bʉi. Gä bi xännba̱ ra̱ hya̱ yø ja̱'i̱, tengu̱tho xi 'yørbʉ ja yø hni̱ni̱ xi thogui. ");
INSERT INTO otnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bi guat'i 'da yø fariseo p'ʉ 'bʉhra̱ Jesús ngue da̱ 'yørpa̱ yø nt'änni̱, porque honnbi̱ ha di zʉdi ngue hi̱nda̱ gue'a̱ ra̱ hya̱ da̱ ma̱. Bi 'yɛ̱mbi̱: ―¿Ua ja ra̱ nt'ɛ̱di̱ ngue di̱ nxu̱mmi̱ rá̱ xisu n'na ra̱ n'yohʉ, ua gue hi̱n'na̱? ");
INSERT INTO otnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xi ra̱ ley bi 'yotra̱ Moisés, ¿te 'bɛ'a̱ ma̱ hya̱ mma̱mp'ʉ? ");
INSERT INTO otnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mi̱ da̱hyø fariseo p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱p'ʉ ja ra̱ ley bi 'yot'a̱, i̱ mma̱mp'ʉ ngue da̱ zä da̱ 'yøtra̱ sʉcua̱ n'na ra̱ n'yohʉ ngue di̱ nxu̱mmi̱ rá̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ Moisés bi u̱nna̱ nt'ɛ̱di̱ ngue da̱ nangra̱ sʉcua̱ ngue ra̱ nxu̱ni̱, pɛ ngue ma̱ndø nna̱xi̱tho yø n'yomfɛ̱mi̱ yø ja̱'i̱, ja̱na̱ngue bi̱ njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pɛ nu̱p'ʉ rá̱ mʉdi hi̱nga̱ ngu̱'a̱ ra̱ hya̱ bá̱ sännba̱ Oja̱ da̱ 'yøtyø ja̱'i̱. Porque mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue nu̱'mø ma̱mbá̱ nhohra̱ xi̱mhäi, Oja bi hocra̱ n'yohʉ 'nɛ̱ bi hocra̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ja̱na̱ngue ra̱ n'yohʉ sop'ʉ rá̱ papá, sop'ʉ rá̱ mamá ngue 'bʉhmi̱ rá̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nu̱ya yo nc'ɛ̱i̱ ya, di̱ nne n'na ngu̱ n'na, ja̱na̱ngue ya hi̱ngui̱ yo nc'ɛ̱i̱, sinoque ɛ̱ntho n'na nc'ɛ̱i̱tho. ");
INSERT INTO otnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ja̱na̱ngue nu̱yá, nu̱ya yo nc'ɛ̱i̱ bi pɛn'na̱ Oja̱, hi̱n'yʉ ra̱ nt'ɛ̱di̱ ngue to di xu̱nnba̱bi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nu̱p'ʉ ja ra̱ ngu̱ p'ʉya, nu̱ya yø xädi ra̱ Jesús bi 'yänni̱ te nne da̱ ma̱nya yø hya̱ xi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱ ra̱ n'yohʉ di̱ nxu̱mmi̱ rá̱ xisu, nu̱'mø hømbi̱ ntha̱tra̱ n'yohʉ, da̱ mɛ ma̱n'na ra̱ xisu, ya ra̱ ts'oqui øtra̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A nu̱ ra̱ xisu di̱ nxu̱mmi̱ rá̱ ndø, 'nɛ̱ høndi̱ ntha̱tui ma̱n'na ra̱ n'yohʉ, ya ra̱ ts'oqui øtra̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bi zixyø ba̱si̱ yø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús, i̱ nnepyø ja̱'i̱ ngue da̱ dospa̱ yø ya̱ yø ba̱si̱ 'nɛ̱ da̱ xi Oja̱ ngue di ja̱pyø ba̱si̱. Pɛ nu̱ya yø xädi ra̱ Jesús bi hɛjpa̱ yø ja̱'i̱ bá̱ zi yø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bi̱ mbøcuɛ 'mø mi̱ nu te øtyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ hyɛhmʉ yø ba̱si̱ da̱ thocua dí 'bʉi. Porque tengu̱tho yø ja̱'i̱ ya o rá̱ 'yɛ Oja̱, xquet'a̱ njarbʉ ya yø ba̱si̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue n'na ra̱ ja̱'i̱ hi̱ngra̱ 'yøde tengu̱tho n'na ra̱ ba̱si̱ ngue ra̱ 'yøde, hi̱nda̱ zä da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I thɛxyø ba̱si̱ ra̱ Jesús, di japrá̱ 'yɛ p'ʉ ja yø ya̱ yø ba̱si̱, i äp'a̱ Oja̱ ngue di ja̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ya ja ngue da̱ ma ra̱ Jesús, pɛ bá̱ jʉ ra̱ 'dihi n'na ra̱ n'yohʉ. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bäi, bi 'yɛ̱mbi̱: ―Ague grá̱ hoga̱ xännba̱te, ¿te 'bɛ'a̱ ja ngue ga̱ øt'e n'namhma̱ ngue Oja̱ di 'dacra̱ 'da'yo te para za̱ntho? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua guí pa̱di̱ te guí̱ mma̱nya, ngue guí ɛ̱ngui̱ xa̱nhogä? Porque hønsɛ Oja̱ xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ua hi̱ngui̱ pa̱di̱ hanja'ʉ yø hya̱ di̱ ma̱nda Oja̱ ngue ɛ̱na̱: “'Yo grá̱ hyote. 'Yo grá̱ 'yots'om'mäi. 'Yo grá̱ bɛ̱. 'Yo to guí sännba̱ ra̱ fɛhni̱. 'Yo grá̱ hyäte. 'Da̱mi̱ su̱ ni̱ papá, da̱mi̱ su̱ ni̱ mamá” ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mi̱ da̱hra̱ n'yohʉ p'ʉya, bi 'yɛ̱na̱: ―Ague grá̱ xännba̱te, nu̱ya yø hya̱ guí xicya, ya gä xtá̱ øt'e asta̱ gue'mø ma̱rá̱ ngüɛgui. ");
INSERT INTO otnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nu̱na̱ ra̱ Jesús bi hyɛ̱tra̱ n'yohʉ ya̱ui, pɛ di̱ nɛ̱qui̱ ngue di̱ ma̱di̱. Bi 'yɛ̱mbʉya: ―Di 'bɛ hma̱n'na ra̱ hya̱ ja ngue gui 'yøt'e. Ni̱ ma ya, da̱mi̱ pä te gä guí pɛts'i. Da̱mi̱ u̱nna̱ mɛ̱nyu̱ yø hyoya. Nu̱'mø gá̱ 'yøt'e te dí xi'i ya, ya bí ja ni̱ mmɛti ma̱hɛ̱ts'i̱ p'ʉya. Bá̱ ɛ̱ p'ʉya, ga̱ mmɛ ma̱da̱gue'a̱ da̱ tho'i p'ʉ ja ra̱ pont'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pɛ mi̱ 'yøhra̱ n'yohʉ na̱ ra̱ hya̱ bi sifi, ma̱mbi du̱drá̱ mmʉi. Bi̱ matho, porque ma̱rá̱ ndømmɛ̱mmɛti. ");
INSERT INTO otnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bi hyɛ̱tyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Xa̱ndøn hɛ̱nni̱tho ha di̱ n'u̱nyø mmɛ̱mmɛti ngue da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nu̱'ʉ yø xädi ra̱ Jesús, di 'yøtho hanja ya yø hya̱ bi̱ ma̱. Pɛ ra̱ Jesús ma̱hømbi 'yɛ̱mbi̱: ―Ague ts'ʉnt'ʉ'a̱hʉ, nu̱ya dí̱ mma̱ngä ngue xa̱nhɛ̱nni̱tho ha di zo rá̱ 'yɛ Oja̱, guehya yø ja̱'i̱ xøgue ma̱høndra̱ mɛ̱nyu̱ ni̱ ma yø mmʉi ya. ");
INSERT INTO otnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ya fa̱di̱ ngue ra̱ cameyo, hi̱nja̱m'mø da̱ zä da̱ thop'ʉ ja rá̱ xa̱gu̱ n'na ra̱ 'yofani̱. Pɛ ma̱n'na xa̱ndøn hɛ̱nni̱tho ngue n'na ra̱ mmɛ̱mmɛti di̱ n'u̱ni̱ da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, mi̱ 'yøhyø xädi, ma̱n'natho bi̱ nsu̱ yø n'yomfɛ̱ni̱ p'ʉya. Di̱ n'yɛ̱mbi̱: ―Rá̱ nzɛgui ya hi̱njonni̱ ja̱'i̱ da̱ zä di̱ nya̱nná̱ te ya'mø ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bi hyɛ̱tyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu'a̱ ngue yø ja̱'i̱tho, hi̱nda̱ zä da̱ zänsɛ ha di̱ nya̱nyø te. Pɛ Oja̱ hi̱nte hɛ̱mbi̱, nu̱ te nne da̱ 'yøt'e, da̱ zä ha di japi. ");
INSERT INTO otnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nu̱na̱ ra̱ Bɛdu bi 'yɛ̱mbra̱ Jesús: ―Nu̱gähe, ya xtá̱ sohme p'ʉ te gä dí pɛshe ngue dí tɛn'na̱he. ");
INSERT INTO otnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue nu̱ to gä xpá̱ nzohyø ngu̱, xpá̱ nzohyø cu̱, xpá̱ nzohyø papá, xpá̱ nzohyø ba̱si̱, xpa̱ nzohyø häi ngue tɛnngui̱ ngue mma̱nna̱ hoga̱ 'da'yo hya̱, ");
INSERT INTO otnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","pɛ mɛ̱nte 'bʉcua ja ra̱ xi̱mhäi ra̱ ja̱'i̱, yø ciento nni̱di̱tho ga̱ngu̱'a̱ te gä da̱ di̱ni̱ ngue'a̱ te gä xpá̱ nzogui. Ma̱da̱gue'a̱ da̱ ts'ʉi, pɛ ra̱ pa di 'yɛ̱p'ʉ, di t'u̱nna̱ te para zantho. ");
INSERT INTO otnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Xa̱ngu̱ yø ja̱'i̱ hnu̱ ma̱nsu̱ ua, pɛ nu̱'a̱ ra̱ pa'a̱, ja ts'ʉtho da̱ni̱ hnu̱ ma̱nsu̱ p'ʉ. Xa̱ngu̱ yø ja̱'i̱ hi̱ngui̱ hnu̱ ma̱nsu̱ ua, pɛ nu̱'a̱ ra̱ pa'a̱, ja da̱ni̱ hnu̱ ma̱nsu̱ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ya ni̱ hya̱ ra̱ 'yu̱ ngue ni̱ ma Jerusalén, ni̱ 'bɛt'otho p'ʉ ni̱ ma yø xädi ra̱ Jesús. Nu̱'ʉ yø xädi ya i su̱, di 'yøtho hanja'a̱ te øtra̱ Jesús ngue ni̱ ma Jerusalén. Pɛ ra̱ Jesús bi zica̱ n'nanni̱'ʉ 'dɛ'ma̱ yoho yø xädi, bi xifi xa̱nho hanja'a̱ te da̱ thogui. Bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―A nu̱yá, ya nná̱ mähä Jerusalén. Nu̱na̱ ra̱ hni̱ni̱ na̱, nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ di̱ ndäpyø hmu̱ yø mmäcja̱ conyø xännba̱te ngue ra̱ ley. Nu̱ya p'ʉya, guehya da̱ zännbi̱ ngue da̱ du̱. Di däpyø ja̱'i̱ hi̱ngyø judío ngue da̱ hyo. ");
INSERT INTO otnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nu̱ya yø ja̱'i̱ di̱ ndäpi, da̱ n'yɛmma̱hya̱, da̱ zots'i, da̱ mɛi. M'mɛfa p'ʉya, da̱ hyo. Pɛ rá̱ hyu̱ pa di bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ra̱ Jacobo conna̱ Xuua, guehya yø ts'ʉnt'ʉ ra̱ Zebedeo ya, bi guarbʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, dí̱ nne ga̱ ä'a̱'be n'na ra̱ ma̱te ya. ");
INSERT INTO otnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Tema̱ ma̱te guí̱ nne ga̱ øt'a̱ui? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bi 'yɛ̱n'ʉ ähra̱ ma̱te p'ʉya: ―Dí̱ nnegä'be ngue nu̱p'ʉ ha gui̱ mmi̱ ngue gui̱ nda̱st'abi, n'na dí̱ mi̱hni̱ n'yɛi, n'na dí̱ mi̱hni̱ ga̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pɛ mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague n'yø'a̱ui, hi̱nguí̱ pa̱di̱ te rá̱ nsäui na̱ ra̱ hya̱ guí ähmi̱. ¿Ua da̱ zä gui thohmi̱'a̱ ra̱ n'ʉ i ja ngue ga̱ thocä? Porque nu̱gä ma̱thoguitho ja ngue di ʉngä yø ja̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bi 'yɛ̱mbʉya: ―A̱há̱, da̱ zä ga̱ sägä'be ra̱ n'ʉ. Mi̱ da̱hra̱ Jesús, ma̱hømbi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue ngu̱'a̱, xa̱ndøngu̱ ra̱ n'ʉ ja ngue gui säui, tengu̱tho ra̱ n'ʉ ja ngue ga̱ thocä. Ma̱thoguitho di ʉn'a̱ui yø ja̱'i̱ tengu̱tho ja ngue dí̱ ʉngä yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pɛ nu̱na̱ ra̱ hya̱ guí mma̱mmi̱, hi̱ndi̱ tocagui̱ ngue go ga̱ sänni̱ to di̱ mi̱p'ʉ ja ma̱ n'yɛi, ogue to di̱ mi̱p'ʉ ja ma̱ ga̱ha̱. Nu̱na̱ Oja̱, ya xa̱ nzänni̱ to dí̱ mi̱ n'na ngu̱ n'na ma̱ hyo. ");
INSERT INTO otnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nu̱na̱ ra̱ hya̱ ähya yo nc'ɛ̱i̱ mi̱ ya̱ui ra̱ Jesús, bi̱ mbøcuɛ 'mø mi̱ ba̱hya mi̱ 'dɛt'a yø xädi, i sʉhra̱ Jacobo 'nɛ̱hra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pɛ ra̱ Jesús bi pɛti gätho yø xädi, bi 'yɛ̱mbi̱: ―Ya guí pa̱hmʉ ngue yø da̱st'abi xa̱ t'ɛ̱ts'i̱, co gätho mi̱'da yø ts'ʉt'abi 'bʉp'ʉ ja yø hni̱ni̱, gä di̱ ma̱nda yø ja̱'i̱. Nu̱ te di̱ ma̱nda ngue da̱ 'yøtyø ja̱'i̱, gue'a̱ øt'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pɛ nu̱'a̱hʉ, 'yo guí̱ nne ngue gui̱ ma̱ndathohʉ yø ja̱'i̱. Nu̱ ra̱ ja̱'i̱ nne ngue xta̱ nhɛ̱ts'i̱ rá̱ cargo da̱ mɛfi, guehna̱ ra̱ ja̱'i̱ jatho ngue di̱ mpɛfi da̱ mäxyø mmi̱c'ɛ̱i̱ui na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A nu̱'a̱hʉ ya, nu̱'a̱ da̱ ne di̱ m'mɛt'o ngue gätho yø amigo ya, guehna̱ jatho da̱ gohi ngue ni̱ mɛfihʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Conque ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, hi̱mbi̱ 'yɛ̱hɛ̱ ngue n'narbʉ da̱ mi̱ di̱ ma̱ndatho. Sinoque bí 'yɛ̱hɛ̱ ngue di̱ mpɛfi da̱ mäxyø ja̱'i̱. 'Nɛ̱ hi̱nga̱ høndra̱ 'bäxte da̱ 'yøt'e, asta̱ da̱ du̱ ngue da̱ ya̱ni̱ xa̱ndøngu̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mi̱ zømp'ʉ ja ra̱ hni̱ni̱ Jericó ra̱ Jesús, bi thogui ni̱ n'youi yø xädi. Pɛ xa̱ndøngu̱ yø ja̱'i̱ bi̱ ntɛt'i. Nu̱p'ʉ neni̱hni̱ p'ʉya, mi̱ hu̱p'ʉ na̱ ra̱ Bartimeo mi̱ xädä, rá̱ ts'ʉnt'ʉ ra̱ Timeo. Mi̱ hu̱p'ʉ ja ra̱ nen'yu̱ ngue äpra̱ mɛ̱nyu̱ yø ja̱'i̱ thop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mi̱ ba̱hra̱ xädä ngue nu̱na̱ ja ngue da̱ thop'ʉ hu̱di̱, guehna̱ ra̱ Jesús ra̱ mmɛ̱ngu̱ Nazaret. Bi̱ mʉhra̱ hmafi p'ʉya, bi 'yɛ̱mbi̱: ―Da̱mi̱ huɛ̱ga̱gui̱ ague Jesús rá̱ mbom'mɛto'i ra̱ David ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nu̱'ʉ yø ja̱'i̱ 'bʉp'ʉ mi̱ hu̱hra̱ xädä, di hɛjpi ngue hi̱ndi̱ mmafi. Pɛ ra̱ xädä p'ʉya, ɛna̱ ma̱n'na ma̱'bɛpi ngue nts'ɛdi ga̱ mafi, bi 'yɛ̱mbi̱: ―Da̱mi̱ huɛ̱ga̱gui̱ ague rá̱ mbom'mɛto'i ra̱ David ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bi̱ m'mähra̱ Jesús ngue øde hmat'i. Bi 'yɛ̱mbyø ja̱'i̱ p'ʉya: ―Da̱mi̱ xihmi̱ ngue da̱ ɛ̱cua. Bi̱ ma bá̱ ts'ohra̱ xädä p'ʉya, bi t'ɛ̱mbi̱: ―Da̱ hyu̱ ni̱ mmʉi ya, ga̱ 'yo, bi ts'o'i'na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ra̱ xädä p'ʉya, bi 'yɛmp'ʉ rá̱ tu̱hu̱, bi̱ nangui̱, asta̱ ra̱ n'nats'i ngue di johya. Bi̱ map'ʉ bi 'bähra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Te guí̱ nne di̱ nja'i? Ra̱ xädä p'ʉya, bi 'yɛ̱na̱: ―Ague grá̱ xännba̱te, dí̱ nne ngue di̱ nzø ma̱ dä. ");
INSERT INTO otnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ra̱ Jesús bi 'yɛ̱mbra̱ xädä: ―Ya da̱ zä gui̱ mma ya, bi zä ni̱ dä ngue guí ɛ̱c'ɛ̱i̱gui̱ ngue jagä ra̱ ts'ɛdi ga̱ øthe'i. 'Bexpi̱ nzø yø dä ra̱ xädä p'ʉya. Bi zä bi̱ n'yo ngue bi̱ mɛp'ʉ ni̱ ma ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nu̱'mø ya ni̱ ma da̱ zømp'ʉ ja ra̱ hni̱ni̱ Jerusalén, ya 'yop'ʉ ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos. Ja jarbʉtho ra̱ hni̱ni̱ Betfagé 'nɛ̱hra̱ hni̱ni̱ Betania. Nu̱na̱ ra̱ Jesús bi 'yɛt'i yoho yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Bi 'yɛ̱mbi̱: ―Ni̱ mɛ nʉ ja ra̱ hni̱ni̱ bí ja nʉ. Nu̱'mø gá̱ cʉt'ui ra̱ hni̱ni̱, gui ti̱mmi̱ p'ʉ da̱ ntha̱t'i̱ n'na ra̱ burru ngue ma̱'da'yotho, hi̱njongui sä. Bá̱ xoqui ngue guá̱ siui ua. ");
INSERT INTO otnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nu̱'mø to da̱ 'yɛ̱n'a̱ui, hanja ngue guí xocui ra̱ burru, gui xihmi̱ p'ʉya ngue honna̱ Hmu̱. Pɛ da̱mi̱ xihmi̱ ngue hi̱nda̱ ya'atho di̱ ndäpi. ");
INSERT INTO otnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bi̱ ma'ʉ yoho yø xädi bi 'yɛt'i. Bi di̱mp'ʉ ma̱ntha̱t'i̱ ra̱ burru jonna̱ goxthi ja ra̱ nen'yu̱. Bi xojpʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nu̱'ʉ yø ja̱'i̱ mi̱ 'bäp'ʉ p'ʉya, bi 'yɛ̱n'a̱ n'na nc'ɛ̱i̱: ―¿Te 'bɛ'a̱ guí øt'ui? ¿Hanja ngue guí xocui ra̱ burru? ");
INSERT INTO otnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nu̱'ʉ xocra̱ burru p'ʉya, bi̱ ma̱ tengu̱tho xi̱ ma̱nna̱ Jesús. Nu̱'ʉ yø n'yohʉ p'ʉya, bi u̱nna̱ nt'ɛ̱di̱ bi zixra̱ burru. ");
INSERT INTO otnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mi̱ zøp'ʉ 'bʉhra̱ Jesús, bi ga̱spa̱ ra̱ burru yø tu̱hu̱ ngue bi nøpa̱ nts'ʉt'i. Bi hyu̱xra̱ burru ra̱ Jesús, bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nu̱p'ʉ ja ra̱ 'yu̱ ja ngue da̱ thohra̱ Jesús, xa̱ngu̱ yø ja̱'i̱ ni̱ 'bɛt'o ngue di tʉns'yø tu̱hu̱ pøp'ʉ ja ra̱ 'yu̱. Mi̱'da yø ja̱'i̱ p'ʉya, bi sa̱jpa̱ yø xi yø palma ngue pøp'ʉ ja ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","O ma̱de p'ʉ ni̱ ma yø ja̱'i̱ ra̱ Jesús. I 'bɛt'o 'da, bá̱ 'bɛfa 'da. Pɛ yø ja̱'i̱ 'da ga̱ matho ngue di johya, i ɛ̱na̱: ―Nu̱na̱ Oja̱, di ja̱phna̱ rá̱ m'mɛnhni̱ 'bʉcua, guehna̱ ta̱te na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Oja̱ di ja̱phna̱ ra̱ da̱st'abi bá̱ 'bɛnhni̱ ngue di thocra̱ 'bɛfi mi̱ pɛhra̱ da̱st'abi David. Ma̱guesɛ na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nu̱na̱ ra̱ Jesús mi̱ yʉrbʉ ja ra̱ hni̱ni̱ Jerusalén, bi zømp'ʉ ja ra̱ ni̱ja̱. Bi̱ nu̱ te øtyø ja̱'i̱ 'bʉp'ʉ. Mi̱ dähra̱ nde, bi̱ mengui, i̱ ma Betania. Bi̱ mɛ'ʉ 'dɛ'ma̱ yoho yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mi̱ hyaxpʉya, nu̱na̱ ra̱ Jesús bá̱ ɛ̱p'ʉ Betania bá̱ n'oxi, i̱ ma Jerusalén. Nu̱p'ʉ ja ra̱ 'yu̱ p'ʉya, bi zä ngue tu̱ ma̱nthu̱hu̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bi hyanda̱ n'na nza ra̱ igo ngue ya xi 'dogui xa̱nho. Bi̱ ma bá̱ nu̱ ngue'mø di zʉdi. Pɛ hi̱ngui̱ zʉdi, porque hi̱ngra̱ pa p'ʉ ngue di̱ nzʉdi. ");
INSERT INTO otnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bi 'yø'ʉ yø xädi te bi xihra̱ za, ngue bi 'yɛ̱mbi̱: ―Ya hi̱nni̱ mantho di̱ nzʉhni̱ ndät'ä ya grá̱ za ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nu̱na̱ ra̱ Jesús, nu̱'mø mi̱ zømp'ʉ ja ra̱ hni̱ni̱ Jerusalén, bi̱ map'ʉ ja ra̱ ni̱ja̱. Nu̱'ʉ yø ja̱'i̱ mi̱ mpäp'ʉ thi̱nni̱ja̱, da̱ gue'ʉ ma̱di̱ ntäi, gä bi 'yɛt'i. Nu̱ya yø ja̱'i̱ di pøspa̱ yø mɛ̱nyu̱ yø ja̱'i̱ yap'ʉ ni̱ 'yɛ̱hɛ̱, bi 'yennba̱ yø mɛ̱xa. 'Nɛ̱ bi 'yennba̱ yø nthu̱ts'i̱'ʉ pä yø paloma. ");
INSERT INTO otnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nu̱'ʉ yø ja̱'i̱ ja te ha̱, ya hi̱ndi̱ japi da̱ thop'ʉ ja ra̱ thi̱nni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bi 'yɛ̱mbyø ja̱'i̱ p'ʉya: ―Nu̱p'ʉ ja ra̱ Ma̱ca̱ Libro, nt'ot'i p'ʉ ra̱ hya̱ ngue Oja̱ i ɛ̱na̱: “Nu̱na̱ ma̱ ngu̱ngä, ni̱ hu̱ ngue ra̱ ngu̱nga̱ mhmat'Oja̱ na̱, 'nɛ̱ ja nda̱nne ua gätho yø ja̱'i̱ 'bʉ'a̱ nxi̱mhäi”. Pɛ nu̱'a̱hʉ, guí øthʉ ngue ja di̱ mpɛti ua yø bɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pɛ nu̱'ʉ yø hmu̱ yø mmäcja̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley mi̱ ba̱di̱ te bi 'yøtra̱ Jesús, hi̱ngui̱ nnu̱ ma̱nho. Bi hyoni̱ ha di japi ngue da̱ hyo ra̱ Jesús. Pɛ hi̱nga̱ 'bexpi zä ha di japi, porque su̱pi̱ di̱ mbøcuɛ yø ja̱'i̱. Porque nu̱'ʉ yø hya̱ xännba̱te ra̱ Jesús, gä di 'yødyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mi̱ dähra̱ nde p'ʉya, bi bømp'ʉ ja ra̱ hni̱ni̱ ra̱ Jesús, bi̱ mɛ yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mi̱ hyaxpʉya, bi thop'ʉ 'bähra̱ za ngue ra̱ igo. Bi̱ nu̱ ra̱ za p'ʉya ngue xi 'yot'i asta̱ yø 'yʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ra̱ Bɛdu p'ʉya bi zo rá̱ mmʉi'a̱ te ra̱ hya̱ xi̱ ma̱nna̱ Jesús. Bi 'yɛ̱mbʉya: ―Ague grá̱ xännba̱te, nu̱na̱ ra̱ za gá̱ sʉ hma̱nde, gue xa̱ 'yot'i ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Da̱mi̱ 'yɛ̱c'ɛ̱i̱ ngue nu̱'mø gui̱ mmat'Oja̱hʉ, da̱ mäxa̱hʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nu̱'mø guí ɛ̱c'ɛ̱i̱hʉ xa̱nho ngue gue'a̱ nnu̱ ma̱nho Oja̱ ngue di̱ nja'a̱ te guí xihmʉ, 'nɛ̱ hi̱ngui̱ yobɛ̱ni̱ ni̱ mmʉihʉ, da̱ zä gui 'yɛ̱mphʉ ra̱ nyu̱ni̱ ja nʉ: “Da̱mi̱ 'uegue grá̱ nyu̱ni̱, i̱ map'ʉ ja ra̱ ja̱the”, gui 'yɛ̱mphʉ. Ra̱ nyu̱ni̱ p'ʉya, da̱ 'uegue, di̱ map'ʉ gui xihmʉ ngue di̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ja̱na̱ngue dí xi'a̱hʉ, nu̱'mø te guí äphʉ Oja̱, da̱mi̱ 'yɛ̱c'ɛ̱i̱hʉ ngue di 'da'a̱hʉ Oja̱ te guí äphʉ. Oja̱ p'ʉya, da̱ 'yøt'e ngue di̱ nja'a̱ te gui 'yäphʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nu̱'mø guí̱ mmat'Oja̱hʉ, 'nɛ̱ bi zo ni̱ mmʉi ngue hi̱ngui̱ nnu̱ ma̱nho te øt'a̱ ni̱ mmi̱c'ɛ̱i̱ui, da̱mi̱ pu̱nnbi̱, n'namhma̱ ngue xquet'a̱ di pu̱n'na̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pɛ nu̱'mø ngue hi̱n ga̱di pu̱nnba̱bi̱ ni̱ mmi̱c'ɛ̱i̱ui, xquet'a̱ hi̱ndi̱ pu̱n'na̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ra̱ Jesús, mi̱ zømp'ʉ ja ra̱ hni̱ni̱ Jerusalén, i 'yop'ʉ ja ra̱ ni̱ja̱. Bi guatyø hmu̱ yø mmäcja̱ p'ʉya, 'nɛ̱hyø xännba̱te ngue ra̱ ley, 'nɛ̱hya yø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bi 'yɛ̱mbra̱ Jesús: ―Ague n'yø, ¿hanja te guí øt'e? ¿To bi 'da'i ra̱ nt'ɛ̱di̱'a̱ te guí øt'e? ");
INSERT INTO otnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱gä xquet'a̱ ga̱ øt'a̱hʉ n'na ra̱ nt'änni̱ ya. Pɛ gue gui xicjʉ hanja'a̱ ra̱ hya̱ ga̱ än'na̱hʉ, n'namhma̱ ngue xquet'a̱ ga̱ xi'a̱hʉ to bi 'dacä ra̱ nt'ɛ̱di̱'a̱ te dí øt'ä ua. ");
INSERT INTO otnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Xiya, ¿te'o bi u̱nna̱ nt'ɛ̱di̱ ra̱ Xuua ngue bi xixya̱bi̱ yø ja̱'i̱? ¿Ua Oja̱ bi u̱nna̱ nt'ɛ̱di̱, uague yø ja̱'i̱tho rá̱ nt'ɛ̱di̱'a̱ te bi 'yøt'e? ");
INSERT INTO otnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yø ja̱'i̱ p'ʉya, di̱ n'yänni̱ te di da̱di̱. Di̱ n'yɛ̱mbi̱: ―¿Teni̱ 'bɛ'a̱ ga̱ xihmʉ ya'mø? Nu̱'mø ga̱ xihmʉ ngue Oja̱ bi u̱nna̱ nt'ɛ̱di̱ te bi 'yøtra̱ Xuua, da̱ 'yɛ̱njʉ p'ʉya: “Xina̱ ra̱ hya̱ bi̱ ma̱nna̱ Xuua conná̱ ngueque, ¿hanja ngue hi̱ngá̱ 'yɛ̱c'ɛ̱i̱hʉ 'mø?” da̱ 'yɛ̱njʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A nu̱'mø ga̱ xihmʉ ngue yø ja̱'i̱tho bi u̱nna̱ nt'ɛ̱di̱ te bi 'yøtra̱ Xuua, ya nts'u̱dyø ja̱'i̱ ―di̱ n'yɛ̱mbi̱. Rá̱ nzɛgui p'ʉya, bi zänyø ja̱'i̱ ngue ya hi̱nte da̱ xifi te'o bi u̱nna̱ nt'ɛ̱di̱'a̱ te bi 'yøtra̱ Xuua, i su̱pi̱ di̱ mbøcuɛ yø ja̱'i̱. Porque gätho yø ja̱'i̱ ɛ̱c'ɛ̱i̱ ngue rá̱ pønga̱hya̱ Oja̱ na̱ ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ja̱na̱ngue bi 'yɛ̱mbʉya: ―Hi̱ndí̱ pa̱cähe to bi u̱nna̱ nt'ɛ̱di̱'a̱ te bi 'yøtra̱ Xuua. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ya hi̱ngá̱ xicjʉ na̱ ra̱ hya̱ dí än'na̱hʉ, ni̱ xi̱nga̱ guecä ga̱ xi'a̱hʉ to di 'dacra̱ nt'ɛ̱di̱ na̱ te dí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nu̱na̱ ra̱ Jesús, bi hyoni̱ te gui hyɛjpa̱ yø hya̱ bi̱ xihyø ja̱'i̱. Bi 'yɛ̱mbi̱: ―Mi̱ 'bʉ'a̱ n'na ra̱ n'yohʉ ngue bi 'yøt'a̱ n'na rá̱ nua̱'uva. Bi føt'e gä rá̱ häi. Bi hoqui hapʉ da̱ dɛ'myø uva 'mø bi̱ nja. 'Nɛ̱ bi hocra̱ n'nøque hapʉ da̱ mi̱hra̱ mähui̱. Bi hyoni̱ to da̱ gonhui rá̱ hua̱hi̱, n'namhma̱ ngue nu̱'mø bi̱ nja yø uva, di̱ t'u̱nna̱ mmɛ̱hui̱'a̱ te di tocabi. Bi̱ ma yap'ʉtho ra̱ mmɛ̱hui̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mi̱ zønna̱ pa da̱ thʉcyø uva p'ʉya, nu̱na̱ ra̱ mmɛ̱hui̱ bi̱ mɛnhna̱ n'na rá̱ hmi̱qui̱ ngue da̱ tu̱ yø uva di tocabi. ");
INSERT INTO otnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pɛ nu̱'ʉ yø mɛfi ma̱mbi 'bʉp'ʉ bí ja ra̱ hua̱hi̱, bi bɛntra̱ hmi̱qui̱ 'mø mi̱ zømp'ʉ 'bʉi. Bi ʉni̱, bá̱ ɛrbʉya. Pɛ hi̱nte bi u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ra̱ mmɛ̱hui̱ p'ʉya, ma̱hømbi̱ mɛnhma̱n'na rá̱ hmi̱qui̱ p'ʉ bí ja ra̱ hua̱hi̱. Nu̱'ʉ yø mɛfi ya ma̱mbi 'bʉp'ʉ, hømbá̱ mbøcuɛ. Bá̱ pʉndothobi rá̱ hmi̱qui̱ ra̱ mmɛ̱hui̱. Bá̱ sɛrpa̱ rá̱ ya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ra̱ mmɛ̱hui̱ p'ʉya, ma̱hømbi̱ mɛnhma̱n'na rá̱ hmi̱qui̱. Pɛ ya bá̱ tho'a̱ bi mɛnnbʉya. Bi sigue bi̱ mɛnnba̱bi̱ mi̱'da p'ʉya. Ngu̱t'a̱tho bi ørpe, 'bʉ i'da bi pʉt'i, 'bʉ i'da bi ho. ");
INSERT INTO otnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nu̱na̱ ra̱ mmɛ̱hui̱ p'ʉya, mi̱ si n'na rá̱ ts'ʉnt'ʉ ngue ɛ̱mmɛ̱i̱ di̱ ma̱di̱. Ya ɛ̱mp'ʉya: “Ma ga̱ pɛnhnä na̱ ma̱ ts'ʉnt'ʉ ya. Nu̱'mø bi̱ nu̱ yø mɛfi na̱, da̱ nu̱ ma̱nsu̱, porque ma̱ ts'ʉnt'ʉ na̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pɛ nu̱'mø mi̱ zømp'ʉ 'bʉhyø mɛfi na̱ rá̱ ts'ʉnt'ʉ ra̱ mmɛ̱hui̱, di̱ n'yɛ̱mbyø mɛfi: “Nu̱na̱ ya, guehna̱ ra̱ ts'ʉnt'ʉ ja ngue da̱ gohmi̱ ra̱ hua̱hi̱ na̱ya. Ma ga̱ hohʉ ya, n'namhma̱ ngue ya ma̱ mmɛtihʉ ra̱ hua̱hi̱”, di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bi bɛnnbʉya ngue bi hyo. Bi̱ ma bá̱ ɛmma̱ xøts'e ra̱ hua̱hi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nu̱na̱ ra̱ Jesús, bi 'yänyø ja̱'i̱, bi 'yɛ̱mbi̱: ―Xi'mø ya bi̱ nja ya yø hya̱ dí xi'a̱hʉ ya, ¿teni̱ 'bɛ'a̱ da̱ 'yøtra̱ mmɛ̱hui̱? Siempre da̱ ma ra̱ mmɛ̱hui̱ p'ʉya, da̱ ho yø mɛfi conhui rá̱ hua̱hi̱. N'nan'yo mi̱'da yø ja̱'i̱ di fätra̱ hua̱hi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Guí pa̱hmʉ xa̱nho ra̱ hya̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Nu̱na̱ ra̱ do hi̱mbi̱ nu̱ ma̱nho yø hyønni̱gu̱, guehna̱ ra̱ do brá̱ 'bɛbo p'ʉ brá̱ fʉ ra̱ ja̱do na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ngu̱na̱ ra̱ hya̱ xa̱ nzän'Oja̱ ngue di̱ nja. A nu̱jʉ p'ʉya, dí ɛ̱mhmʉ ngue ma̱zihotho te øt'Oja̱”, ɛ̱nna̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ra̱ Jesús høntho bi xihyø ja̱'i̱ ya yø hya̱ ya, bi̱ ne yø ja̱'i̱ xti bɛntra̱ Jesús ngue xta̱ ngot'i. Porque pa̱hyø ja̱'i̱ ngue go xihya yø hya̱ bi hyɛcra̱ Jesús. Pɛ hi̱mbi̱ zä xti bɛnt'i̱, porque su̱pi̱ di̱ mbøcuɛ mi̱'da yø ja̱'i̱. Ja̱na̱ngue hi̱nte bi japi. ");
INSERT INTO otnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nu̱ya 'da yø fariseo, da̱ gue'da yø ja̱'i̱ ra̱ Herodes, bi 'bɛnhni̱ ngue da̱ jʉjpa̱tho häi te ga̱ ya̱ ra̱ Jesús, para ngue da̱ zäp'ʉ di ya̱pa̱ m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, dí pa̱cähe ngue grá̱ hoga̱ n'yohʉ, porque gä pømma̱nho ra̱ hya̱ guí̱ mma̱. 'Nɛ̱ hi̱nguí̱ su̱'a̱ te mbɛ̱n'na̱'i̱ yø ja̱'i̱. Ma̱da̱gue'a̱ ja yø cargo 'da yø n'yohʉ gui ya̱ui, pɛ hi̱nguí̱ su̱ gui xifi ndana̱ ra̱ hya̱ ma̱jua̱ni̱. Sinoque ma̱jua̱ni̱ ngue guí xännba̱te'a̱ ra̱ hya̱ nne Oja̱ ngue gdá̱ n'yohʉ. Da̱mi̱ xicje ya, ¿ua xa̱nho ngue di̱ nju̱tra̱ mɛ̱nyu̱ ähra̱ da̱st'abi, uague hi̱n'na̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pɛ ra̱ Jesús ya pa̱di̱ te mbɛ̱nnba̱bi̱ yø ja̱'i̱ ngue'a̱ ra̱ nt'änni̱ ørpe, bi 'yɛ̱mbʉya: ―¿Hanja ngue guí sämhya̱ga̱hʉ? Da̱mi̱ 'yu̱rca̱hʉ ra̱ mɛ̱nyu̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bi u̱nna̱ mɛ̱nyu̱ p'ʉya ngue da̱ nu̱. Mi̱ nu̱ ra̱ mɛ̱nyu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿To rá̱ hmi̱ na̱ n'youi ra̱ mɛ̱nyu̱ ja ua? ¿To rá̱ thu̱hu̱ na̱ ra̱ thu̱hu̱ n'youi ra̱ mɛ̱nyu̱? Mi̱ da̱hyø ja̱'i̱ ya̱ui ra̱ Jesús, bi 'yɛ̱mbi̱: ―Guehna̱ ra̱ da̱st'abi na̱ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―Nu̱'a̱ ja ngue gui 'yøthʉ ya, da̱mi̱ u̱nhnʉ ra̱ mɛ̱nyu̱ di tocabi ra̱ da̱st'abi. Da̱ gue Oja̱ p'ʉya, da̱mi̱ u̱nhnʉ'a̱ te di tocabi. Nu̱na̱ ra̱ hya̱ i da̱hra̱ Jesús, di 'yødya yø ja̱'i̱ ya̱ui. ");
INSERT INTO otnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","M'mɛfa p'ʉya, bi̱ ma 'da yø saduceo, nu̱ya ɛ̱mbi̱ ngue hi̱ndi̱ bɛ̱nna̱te yø ánima. Bi 'yɛ̱mbra̱ Jesús: ");
INSERT INTO otnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Ague grá̱ xännba̱te, nu̱p'ʉ ja ra̱ ley bi 'yotra̱ Moisés, nt'ot'i p'ʉ ra̱ hya̱ ngue ɛ̱na̱: nu̱'mø bi du̱ n'na ra̱ n'yohʉ, 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱, nu̱ rá̱ xisu ra̱ ánima da̱ zogui, nu̱'a̱ rá̱ n'yohʉ ra̱ ánima, gue'a̱ di̱ ntha̱tui ra̱ 'danxu̱'a̱, n'namhma̱ ngue di̱ m'mʉhyø ba̱si̱ tengu̱tho 'mø xti̱ m'mʉhyø ba̱si̱ ra̱ ánima. ");
INSERT INTO otnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A nu̱yá, xi'mø di 'bʉ'i yoto ma̱'yohʉ ngue ɛda̱di̱ ncu̱ ya. Nu̱'a̱ ra̱ n'yohʉ ma̱ da̱, di̱ ntha̱ti̱. Pɛ da̱ 'yɛ̱hra̱ pa da̱ du̱, 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ja̱na̱ngue nu̱'a̱ rá̱ n'yohʉ ra̱ ánima m'mɛfa bi̱ m'mʉi, go di̱ ntha̱tui ra̱ 'danxu̱'a̱. Pɛ xquet'a̱ da̱ du̱ ra̱ n'yohʉ 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱. Nu̱'a̱ rá̱ hyu̱ rá̱ n'yohʉ p'ʉya, høndi̱ ntha̱tui ra̱ 'danxu̱ 'mø bi du̱ rá̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Di siguetho di̱ ntha̱tra̱ xisu 'mø bi du̱ rá̱ ndø, asta̱ gue'mø bi du̱ gä yoto ma̱'yohʉ. Gä di̱ ntha̱tui ra̱ xisu, 'nɛ̱ gä bi du̱ yø n'yohʉ. Pɛ hi̱mbi̱ m'mʉhyø ba̱si̱. Rá̱ nzɛgui p'ʉya, da̱ du̱ ra̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A nu̱yá, xi'mø ra̱ pa da̱ni̱ bɛ̱nna̱te yø ánima ya, ¿ndana̱ gue'a̱ ya yoto ma̱'yohʉ rá̱ mmɛti ra̱ xisu? Porque gä bi̱ m'mʉhmi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―Hi̱nguí̱ pa̱di̱ ha rá̱ nja ra̱ hya̱ guí̱ mma̱mhmʉ. Porque hi̱nga̱ guep'ʉ gá̱ ndi̱nni̱ mmʉihʉ'a̱ te ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro. 'Nɛ̱ hi̱nguí̱ pa̱hmʉ hangu̱ rá̱ ts'ɛdi Oja̱ i ja. ");
INSERT INTO otnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A nu̱'mø bi bɛ̱nna̱te yø ánima, da̱ gohi tengu̱tho yø anxɛ Oja̱, ya hi̱ndi̱ ntha̱tyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nu̱p'ʉ ja ra̱ hya̱ bi 'yotra̱ Moisés, ja di̱ nɛ̱qui̱ p'ʉ ngue di bɛ̱nna̱te yø ánima. Porque nt'ot'i p'ʉ ra̱ hya̱ bi̱ ma̱n'Oja̱ 'mø mi̱ nya̱p'ʉ bi̱ nzø ra̱ ndʉt'o, ngue bi 'yɛ̱na̱: “Guecä drá̱ Oja̱gä ngue ra̱ Abraham. Drá̱ Oja̱gä ngue ra̱ Isaac. Drá̱ Oja̱gä ngue ra̱ Jacob”, bi 'yɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ja di̱ nɛ̱qui̱ p'ʉya, ngue nu̱p'ʉ 'bʉ Oja̱, hi̱ngui̱ tu̱ yø te yø ánima. Ja̱na̱ngue hi̱nguí̱ pa̱di̱ ha rá̱ nja'a̱ ra̱ hya̱ guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nu̱'a̱ n'na ra̱ xännba̱te ngue ra̱ ley, bi 'yøde ha i da̱pra̱ hya̱ yø ja̱'i̱ mi̱ ya̱ui ra̱ Jesús. I̱ nnu̱ ngue bi da̱di̱ xa̱nho. Bi 'yɛ̱mbʉya: ―Xiya yø hya̱ di̱ ma̱nda Oja̱ p'ʉ ja rá̱ ley, ¿ndana̱ ra̱ hya̱ ɛxa̱ ma̱ da̱tho di ja ts'ɛdi Oja̱ ngue da̱ 'yøtyø ja̱'i̱? ");
INSERT INTO otnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ya yø hya̱ di̱ ma̱nda Oja̱, nu̱na̱ ɛxa̱ ma̱ da̱tho di ja ts'ɛdi Oja̱ ngue da̱ 'yøtyø ja̱'i̱, guehna̱ ra̱ hya̱ ngue ɛ̱na̱: “Ague gyø judíohʉ, da̱mi̱ 'yøhmʉ na̱ ra̱ hya̱ ja ua. Nu̱na̱ ra̱ Hmu̱ ma̱ Oja̱hʉ, 'dasɛ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Da̱mi̱ ja ndu̱mmʉi ngue ma̱thoguitho gui̱ ma̱hmʉ Oja̱ co gätho ni̱ mmʉihʉ. Hønt'a̱ guí̱ mbɛ̱mhmʉ'a̱”. ");
INSERT INTO otnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nu̱na̱ rá̱ yoho ra̱ hya̱ di̱ ma̱nda Oja̱, 'nɛ̱ di ja ts'ɛdi Oja̱ ngue da̱ 'yøtyø ja̱'i̱, guehna̱ ra̱ hya̱ ngue ɛ̱na̱: “Da̱mi̱ ma̱hni̱ mmi̱c'ɛ̱i̱ui tengu̱tho gni̱ ne ngue di̱ ma ma̱ma̱di̱'i̱”, ɛ̱nna̱ hya̱. Guehya yoho yø hya̱ di̱ ma̱nda Oja̱ ya, 'nɛ̱ ta̱te di ja ts'ɛdi Oja̱ ngue da̱ 'yøtyø ja̱'i̱. Guehya yø hya̱ 'bɛt'o ya ngue gätho mi̱'da yø hya̱ di̱ ma̱nda Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mi̱ da̱hra̱ xännba̱te ngue ra̱ ley p'ʉya, bi 'yɛ̱mbi̱: ―Xa̱nho te guí̱ mma̱ grá̱ xännba̱te. Ma̱jua̱ni̱ te guí̱ mma̱ ngue nu̱na̱ Oja̱ ma̱ Hmu̱hʉ 'dasɛ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Guehya yø hya̱ ma̱ da̱tho ja ngue da̱ 'yøtra̱ ja̱'i̱ ya, da̱ hya̱hrá̱ mmʉi ra̱ ja̱'i̱ ngue di̱ ma̱ Oja̱, 'nɛ̱ di ma̱hrá̱ mmi̱c'ɛ̱i̱ui. Nu̱'mø ngue ngu̱'a̱ dí øthʉ p'ʉya, ya ma̱n'natho nnu̱ ma̱nho Oja̱ te dí øthʉ p'ʉya, ngue'ʉ yø 'bøt'e ørpa̱ yø ja̱'i̱ p'ʉ ja ra̱ ni̱ja̱, da̱ gue'ʉ mi̱'da yø cosa ma̱ t'u̱nni̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Bi̱ nu̱ ra̱ Jesús ngue pa̱di̱ te mma̱n'a̱ ra̱ n'yohʉ ya̱ui, bi 'yɛ̱mbʉya: ―Ya mi̱ zits'ʉtho ga̱di 'bɛdi ngue guí so rá̱ 'yɛ Oja̱ ―bi 'yɛ̱mbi̱. Mi̱ xifi tengu̱ na̱ ra̱ hya̱ na̱ p'ʉya, ya hi̱nni̱ mantho tema̱ hya̱ hønxta̱ 'yänyø ja̱'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nu̱na̱ ra̱ Jesús bi xännba̱ ra̱ hya̱ yø ja̱'i̱ p'ʉ ja ra̱ ni̱ja̱. Bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi, yø xännba̱te ngue ra̱ ley p'ʉya, i̱ mma̱n'ʉ ngue da̱gue'a̱ n'na'ʉ yø mbom'mɛto ra̱ David. Pɛ nu̱gä ga̱ xi'a̱hʉ hanja ya, ma̱da̱gue'a̱ ngue rá̱ mbom'mɛto ra̱ David, pɛ nu̱na̱ i hma̱, hi̱ngra̱ ja̱'i̱tho na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porque ra̱ David, gue'a̱ ra̱ Espíritu Santo bi bɛ̱nnba̱bi̱ ra̱ hya̱ bi 'yot'i, ngue bi 'yɛ̱na̱: “Nu̱na̱ Oja̱, nu̱'mø mi̱ zojba̱gui̱ ma̱ Hmu̱, ngu̱na̱ ra̱ hya̱ bi xifi, bi 'yɛ̱mbi̱: Da̱mi̱ mi̱cua ja ma̱ n'yɛigä ya, asta̱ gue'mø ga̱ øt'e ngue guí̱ ma̱nda gätho'ʉ ni̱ nsʉiui”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ja di̱ nɛ̱qui̱ p'ʉya ngue ra̱ David, nu̱'mø nnønna̱ Cristo, ni̱ hu̱ti̱ ngue rá̱ Hmu̱. Ja̱na̱ngue ra̱ Cristo di̱ nɛ̱qui̱ ngue hi̱ngra̱ ja̱'i̱tho, ma̱da̱gue'a̱ ngue rá̱ mbom'mɛto ra̱ David. Xa̱ndøngu̱ yø ja̱'i̱ 'bʉp'ʉ ja ra̱ ni̱ja̱. Nu̱na̱ ra̱ hya̱ xännba̱te ra̱ Jesús, ja̱njua̱ni̱ ngue yø mmʉi ga̱ 'yøxyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bi sigue bi xännba̱bi̱ ra̱ hya̱ yø ja̱'i̱ ra̱ Jesús. Bi 'yɛ̱mbi̱: ―Da̱mi̱ mfähmʉ xa̱nho ya, 'yo di hä'a̱hʉ yø xännba̱te ngue ra̱ ley. 'Yo guí øthʉ tengu̱tho ga̱ 'yo'ʉ. Porque di ho ngue søt'a̱ häi yø he. 'Nɛ̱ di ho ngue di respeta yø ja̱'i̱ ha gui zɛngua p'ʉ ja ra̱ täi. ");
INSERT INTO otnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nu̱p'ʉ ja yø ni̱ja̱ p'ʉya, i huantho yø nthu̱ts'i̱ ta̱te xa̱nho ngue ja hu̱p'ʉ. Nu̱p'ʉ øt'a̱ ngo yø ja̱'i̱ p'ʉya, xquet'a̱ nne ngue ta̱te xta̱nho ha da̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","I tu̱nnba̱ yø ngu̱ yø 'danxu̱, i häti ngue ɛ̱mbi̱ di xa̱nnbi̱ te pɛts'i. Nu̱na̱ ra̱ hya̱ ga̱ ngorpa̱ yø dä yø ja̱'i̱ p'ʉya, nu̱'mø mmat'Oja̱, ndø ya'atho mmat'Oja̱. I̱ nne da̱ 'yɛ̱mbyø ja̱'i̱ ngue yø ndøhoga̱ n'yohʉ. Pɛ nu̱yá, guehya ma̱thoguitho ra̱ castigo da̱ thohya ngue gätho mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nu̱na̱ ra̱ Jesús, mi̱ hu̱p'ʉ ja ra̱ ni̱ja̱ ha ja ra̱ huada ʉtyø mɛ̱nyu̱ yø ja̱'i̱. Hɛ̱ti̱ ha ga̱ yʉtyø mɛ̱nyu̱ yø ja̱'i̱ p'ʉ ja ra̱ huada. Bi̱ nu̱ xa̱ngu̱ yø ja̱'i̱ ngue yø mmɛ̱mmɛti xa̱ndøngu̱ ra̱ mɛ̱nyu̱ di u̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bi̱ nu̱ n'na ra̱ 'danxu̱ ngue ra̱ zibøhyoya, xquet'a̱ bi gät'i yoho yø zi xani̱ p'ʉ ja ra̱ njʉmɛ̱nyu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bi zonhyø xädi ra̱ Jesús, bi 'yɛ̱mbʉya: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue ra̱ zibøhyoya na̱ ra̱ 'danxu̱ bi u̱nna̱ mɛ̱nyu̱ ya, pɛ ma̱n'natho nnu̱ ma̱nho Oja̱ rá̱ mɛ̱nyu̱ bi u̱nna̱, hi̱nda̱ gue'ʉ yø mɛ̱nyu̱ mi̱'da yø ja̱'i̱ di u̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porque nu̱ya mi̱'da yø ja̱'i̱, yø mmɛ̱mmɛti ya, pɛ gue'a̱ rá̱ mɛ̱nyu̱ xa̱ pongui̱ di u̱ni̱. A nu̱na̱ ra̱ 'danxu̱, zits'ʉ drá̱ mɛ̱nyu̱ mi̱ ha̱. Mi̱ ja ngue xta̱ nzi rá̱ mɛ̱nyu̱ bi u̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mi̱ bømp'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús, nu̱na̱ n'na rá̱ xädi bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, nu̱ ra̱ ni̱ja̱, gue xa̱ndønnoho yø do n'youi. 'Nɛ̱ ma̱zihotho yø hmi̱ yø do. ");
INSERT INTO otnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―A̱há̱, ma̱zihotho gui̱ nɛ̱qui̱ ra̱ ni̱ja̱. Pɛ nu̱na̱ ra̱ ni̱ja̱ na̱ya, bá̱ ɛ̱p'ʉ ra̱ pa da̱ xotyø ja̱'i̱ na̱. Xøgue di̱ nxʉdi, hi̱n hapʉ nmi̱ nɛ̱qui̱ ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nu̱p'ʉ ni̱ hyandra̱ ni̱ja̱, ja ni̱ gop'ʉ ra̱ nyu̱ni̱ bí ja ra̱ mbonza ja yø olivos. Ja i̱ mɛp'ʉ yø xädi ra̱ Jesús. Nu̱p'ʉ bi zøni̱, bi̱ mi̱. Bi guatra̱ Bɛdu p'ʉya, conna̱ Jacobo, ra̱ Xuua, ra̱ Andre. Bi̱ nya̱sɛui ra̱ Jesús, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Dí̱ nne gui xicje nja̱m'mø di̱ nja ya yø hya̱ guí̱ mma̱nya, ngue da̱ xotra̱ ni̱ja̱ yø ja̱'i̱. ¿Tema̱ hmɛ̱ya di̱ nja'mø ya ni̱ ma da̱ zønna̱ pa di̱ nja na̱ te guí̱ mma̱nya? ");
INSERT INTO otnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø xädi: ―Da̱mi̱ mfähmʉ xa̱ndønho, 'yo guí̱ nne to da̱ hyä'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porque xa̱ngu̱ yø ja̱'i̱ di̱ n'yo ngue da̱ 'yɛ̱mbyø ja̱'i̱: “Go guecä drá̱ Cristogä ya”, da̱ 'yɛ̱mbi̱. Gue'a̱ di hyät'i xa̱ngu̱ yø ja̱'i̱'a̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nu̱'mø gá̱ 'yøhmʉ ngue ya ja yø da̱tu̱nhni̱, ogue gui 'yøhmʉ ngue ya ja ngue di̱ nja yø tu̱nhni̱, 'yo sä guí su̱hʉ. Porque jatho ngue ya ngu̱'a̱ ja ngue di̱ nja. Pɛ hi̱nga̱ gue'ʉ yø hmɛ̱ya'ʉ ngue rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Da̱ nangyø nación ngue da̱ 'yørpa̱ ra̱ tu̱nhni̱ mi̱'da yø nación. Da̱ nangyø da̱st'abi ngue da̱ 'yørpa̱ ra̱ tu̱nhni̱ mi̱'da yø da̱st'abi. Di 'ya̱n'a̱häi ndap'ʉ bi zä. Di̱ nja yø thu̱hu̱. Ja da̱ fʉp'ʉ ra̱ n'ʉ ja ngue da̱ tho'a̱ m'mɛfa yø ja̱'i̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Da̱mi̱ mfähmʉ. Porque da̱ 'yɛ̱hra̱ pa ngue da̱ ts'ixa̱hʉ fädi. Da̱ mɛp'a̱hʉ yø ja̱'i̱ p'ʉ ja yø ni̱ja̱. Da̱ ma ma̱ dä'a̱hʉ p'ʉ 'bʉhyø da̱st'abi. Di̱ ndä'a̱hʉ p'ʉ 'bʉhyø gobierno. Ngu̱na̱ da̱ ja'a̱hʉ yø ja̱'i̱ ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. Ngue ngu̱na̱ di̱ nja'a̱hʉ, nu̱'mø ya gdi̱ ya̱hʉ yø ts'ʉt'abi, ja gui xihmʉ p'ʉ ra̱ hoga̱ 'da'yo hya̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hante ngue da̱ zɛ'a̱ te ja ngue di̱ nja, nu̱na̱ ra̱ hoga̱ 'da'yo hya̱ jatho ngue da̱ ma ma̱'yoni̱ gä rá̱ ngʉni̱ nxi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nu̱'mø bi̱ ma ma̱ bɛnt'i̱'a̱hʉ, 'yo sä di tu̱ ni̱ mmʉihʉ'a̱ ra̱ hya̱ ja ngue gui xihmʉ ra̱ ts'ʉt'abi. Porque nu̱'a̱ ra̱ ora gui dä ni̱ hya̱hʉ p'ʉ ja ra̱ ts'ʉt'abi, gue'a̱ ra̱ Espíritu Santo di bɛ̱n'na̱ ra̱ hya̱ gui xihmʉ ra̱ ts'ʉt'abi. Ya hi̱ngni̱ n'yomfɛ̱ni̱sɛ gui jʉcjʉ ra̱ hya̱ gui̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","A nu̱ yø n'yohʉ ɛ̱c'ɛ̱i̱gui̱, di däsɛ'ʉ yø n'yohʉ hi̱ngui̱ ɛ̱c'ɛ̱i̱gui̱ ngue da̱ tho. Yø papá p'ʉya, nu̱'mø bi 'yɛ̱c'ɛ̱i̱gui̱ yø ba̱si̱, di däsɛ yø ba̱si̱ ngue da̱ tho. Yø ba̱si̱ p'ʉya, nu̱'mø bi 'yɛ̱c'ɛ̱i̱gui̱ yø papá, di däsɛ yø papá ngue da̱ tho. ");
INSERT INTO otnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ndap'ʉ bi zä da̱ zʉ'a̱hʉ yø ja̱'i̱ ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. Pɛ nu̱ ra̱ ja̱'i̱ hi̱nda̱ hyɛga̱gui̱, xi̱nda̱ hangu̱ ra̱ n'ʉ da̱ thogui, gä da̱ zɛti, guehna̱ ra̱ ja̱'i̱ di̱ nya̱nná̱ te na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Xquet'a̱ guí̱ nnu̱hʉ ngue di̱ nja ya yø hya̱ bi̱ ma̱nna̱ pønga̱hya̱ Daniel, ngue nu̱p'ʉ ja ra̱ xɛqui hi̱n'yʉ ra̱ nt'ɛ̱di̱ di̱ m'mʉhyø ja̱'i̱, ja da̱ 'yørbʉ ra̱ nts'oni̱ yø ja̱'i̱. (A nu̱yá, nu̱ ra̱ ja̱'i̱ di xädi, di̱ n'yo rá̱ mmʉi 'mø bi̱ nu̱ ngue di̱ nja ya yø hya̱ ja ua.) Nu̱'mø gá̱ nu̱hʉ ngue ya bi̱ nja'a̱ p'ʉya, nu̱ yø ja̱'i̱ di 'bʉp'ʉ ja ra̱ häi Judea, da̱ 'dagui, di̱ map'ʉ ja yø xa̱nthø. ");
INSERT INTO otnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu̱ ra̱ ja̱'i̱ di tøhma̱ xøts'e rá̱ ngu̱, 'yo di ɛ̱na̱ ngue di̱ ma mbo rá̱ ngu̱ ngue te da̱ ha̱, sinoque da̱ 'dagui. ");
INSERT INTO otnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu̱ ra̱ ja̱'i̱ di 'yo ra̱ 'bɛfi, hi̱ndi̱ ma rá̱ ngu̱ ngue da̱ ca̱ rá̱ tu̱hu̱, sinoque da̱ 'dagui n'nahma̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pɛ huɛ̱ca̱te yø xisu di ha̱dyø ba̱si̱'a̱ ra̱ pa'a̱, ogue di sʉdyø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Da̱mi̱ 'yäphʉ Oja̱ ngue nu̱ya yø hya̱ ya, hi̱nda̱ gue'mø ra̱ pa ngue xta̱ nsɛ di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porque xa̱ndøn'ʉtho te da̱ thohyø ja̱'i̱ na̱ ra̱ pa na̱. Nu̱ te di̱ nja, hi̱nja̱m'mø xa̱ nnu̱ yø ja̱'i̱ ngue xa̱ njap'ʉ asta̱ gue'mø ma̱mbá̱ fʉ'a̱ nxi̱mhäi. 'Nɛ̱ ya hi̱nni̱ mantho da̱ hnu̱ ngue ma̱høndi̱ njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nu̱na̱ Oja̱, ya xa̱ nzänni̱ ngue hi̱nga̱ ya'atho yø pa di̱ nja na̱ ra̱ nda̱te na̱. A nu̱'mø ngue ya'atho di̱ nja, ya hi̱njonda̱ bongui̱. Pɛ da̱ 'yøt'e ngue da̱ thotho, porque Oja̱ di̱ ma̱hya yø ja̱'i̱ ya xa̱ huanhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nu̱'ʉ yø pa'ʉ, 'yo sä guí ɛ̱c'ɛ̱i̱hʉ ya yø ja̱'i̱ da̱ 'yɛ̱n'a̱hʉ: “Nu̱ua, ja bí 'bʉcua ra̱ Cristo”, ogue da̱ 'yɛ̱n'a̱hʉ: “Ní̱ nguehnʉ ja bí 'bʉhnʉ”, da̱ 'yɛ̱n'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porque xa̱ngu̱ yø ndøbɛthani̱ di̱ n'yo ngue da̱ 'yɛ̱mbyø ja̱'i̱: “Go guecä drá̱ Cristogä ya”, ogue da̱ 'yɛ̱mbi̱: “Go guecä rá̱ pønga̱hya̱gä Oja̱ ya”, da̱ 'yɛ̱na̱. 'Nɛ̱ da̱ zä da̱ 'yøtyø milagro. Nu̱ya yø milagro da̱ 'yøt'e, guehya da̱ ne ngue di hyätyø ja̱'i̱ nu̱ya yø thanhni̱ Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ma̱mi̱ n'u̱ni̱ da̱ thä'a̱hʉ. Ja̱na̱ngue da̱di 'bɛt'o'a̱hʉ ya yø hya̱ ja ngue di̱ nja m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nu̱'mø bi tho'ʉ yø nda̱te di̱ nja, di̱ m'mɛxu̱i̱ ra̱ hyadi 'nɛ̱hra̱ za̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Da̱ tähyø sø bí ja ma̱hɛ̱ts'i̱. Nu̱ te gä bí ja ma̱ya̱, gä di pädi ha thogui. ");
INSERT INTO otnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Da̱ thandra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱ ngue da̱ n'youi ra̱ gu̱i̱. Da̱ hnu̱ ngue ma̱guesɛ, porque ma̱thoguitho ja rá̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nu̱'ʉ yø anxɛ da̱ n'youi, da̱ mɛnhni̱ gä rá̱ ngʉni̱ nxi̱mhäi, ngue di pɛrpa̱bi̱ yø ja̱'i̱ nu̱ya xa̱ huanhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Da̱mi̱ pa̱hmʉ na̱ ra̱ hya̱ ga̱ hyɛcä ya, ngue gdá̱ hyɛjpa̱bi̱ ra̱ hya̱ n'na nza ra̱ igo. Nu̱'mø ya bi c'amyø 'yɛza ngue bi 'dogui, guí pa̱hmʉ p'ʉya ngue ya ni̱ ma di pat'i xa̱nho häi. ");
INSERT INTO otnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ngu̱na̱ ra̱ hya̱ ja ngue di̱ nja ya. Nu̱'mø gá̱ nu̱hʉ ngue bi̱ nja ya yø hya̱ dí xi'a̱hʉ ya, da̱mi̱ pa̱hmʉ ngue ya xma̱ nguerpʉtho ga̱ ma ɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nu̱ya yø hmɛ̱ya dí xi'a̱hʉ ya, da̱mi̱ pa̱hmʉ ngue guehya di̱ nja ya, hante ngue da̱ du̱ yø ja̱'i̱ 'bʉhyø pa ja p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nu̱ te bí ja ma̱ya̱, 'nɛ̱cua ja ra̱ häi, hi̱ngui̱ za̱i̱. Pɛ nu̱na̱ ra̱ hya̱ dí̱ mma̱ngä, ja para za̱ntho na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","I pa̱sɛ Oja̱ tema̱ pa di̱ nja ya yø hya̱ dí xi'a̱hʉ. Ni̱ xi̱ngyø anxɛ di pa̱di̱, ni̱ xi̱nga̱ gueque dí pa̱di̱ tema̱ pa di̱ nja, ma̱da̱gue'a̱ ngue rá̱ Ts'ʉnt'ʉgui Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ja̱na̱ngue da̱mi̱ ndø'ma̱tehʉ, mat'Oja̱hʉ hangu̱ ra̱ pa. Porque hi̱nguí̱ pa̱hmʉ tema̱ pa, tema̱ ora ga̱ søcä ua. ");
INSERT INTO otnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A nu̱yá, tengu̱tho n'na ra̱ n'yohʉ bi̱ ma yap'ʉtho, pɛ hi̱mbi̱ zohra̱ hya̱ tema̱ pa da̱ pengui̱. Nu̱'ʉ yø mɛfi bi fäti te pɛts'i. N'na ngu̱ n'na yø mɛfi bi zännba̱ yø tarea ja ngue da̱ 'yøt'e. Nu̱p'ʉ ja ra̱ goxthi, bi 'bämbʉ n'na ra̱ mängoxthi, bi xifi ngue da̱ mädi xa̱nho ra̱ goxthi. ");
INSERT INTO otnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pɛ nu̱ya bi̱ ma ma̱fäti ra̱ 'bɛfi, hi̱ngui̱ pa̱di̱ tema̱ pa da̱ zøhyø hmu̱. Da̱ gue'a̱hʉ ya, da̱mi̱ mfähmʉ xa̱ndønho. Porque xquet'a̱ hi̱nguí̱ pa̱hmʉ tema̱ ora da̱ zøhni̱ hmu̱hʉ, o nu̱hma̱ ndetho da̱ zøhø, ogue ma̱de ra̱ xu̱i̱ da̱ zøhø, ogue ni̱ ma da̱ hyats'i da̱ zøhø, ogue nɛ̱ca̱häi da̱ zøhø. ");
INSERT INTO otnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Porque hønt'a̱ goma̱ ora da̱ zøhø, pɛ ma̱n'nan'yo mi̱ 'yøthʉ ngue hi̱njondi̱ ndø'ma̱te 'mø bi zøhø. ");
INSERT INTO otnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nu̱na̱ ra̱ hya̱ dí xi'a̱hʉ ngue gui̱ ndø'ma̱tehʉ, hi̱nga̱ høn'a̱thohʉ dí xi'a̱hʉ na̱ ra̱ hya̱ na̱, sinoque gätho yø ja̱'i̱ dí xifi ngue di̱ ndø'ma̱te xa̱ndønho. ");
INSERT INTO otnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ya ma̱ nyo patho di̱ nsänni̱go yø ja̱'i̱ ngue ra̱ pascua. Guehna̱ ra̱ pa ts'i ra̱ thu̱hmɛ̱ hi̱ngui̱ n'youi ra̱ íxi. A nu̱'ʉ yø hmu̱ yø mmäcja̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley, guehya ya rá̱ ya'atho yø pa honi̱ ha di̱ mbɛntra̱ Jesús ngue da̱ tho. ");
INSERT INTO otnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Di̱ n'yɛ̱mbi̱: ―A nu̱yá, hi̱nga̱ gue'mø ra̱ pa ngue ra̱ ngo ga̱ bɛnthʉ ya, n'namhma̱ hi̱nda̱ nangyø ja̱'i̱ da̱ ya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ya 'bʉp'ʉ ja ra̱ hni̱ni̱ Betania ra̱ Jesús. Ɛxa̱ si̱hmɛ̱ p'ʉ ja rá̱ ngu̱ ra̱ Simu̱ nu̱na̱ xi 'yøthe m'mɛt'o ngue mi̱ 'ya rá̱ do'yo. Bi yʉt'a̱mbo n'na ra̱ xisu ni̱ du̱ n'na ra̱ m'mo aceite ngue ra̱ alabastro. I yu̱p'ʉ ra̱ aceite ma̱zihotho ga̱ yʉni̱, bi̱ ma ma̱hoqui conna̱ paxi ngue ra̱ nardo, pɛ xa̱ndøngu̱ rá̱ mu̱ui. Bi 'yøjpa̱ rá̱ 'yʉga ra̱ m'mo aceite p'ʉya, bi xispa̱bi̱ rá̱ ya ra Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bi̱ mbøcuɛ 'da yø ja̱'i̱ mi̱ 'bʉp'ʉ, di̱ n'yɛ̱mbi̱: ―¿Hanja ngue bi̱ ma ma̱'ʉni̱tho na̱ ra̱ aceite na̱? ");
INSERT INTO otnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Xta̱ nzä xta̱ 'bä na̱ ngue xti t'u̱nna̱ mɛ̱nyu̱ yø hyoya. Porque ma̱n'na xa̱ngu̱ xti 'bä ra̱ aceite ngue'a̱ te ra̱ nzäbi ta̱hra̱ ja̱'i̱ n'na jɛya. Hi̱ngui̱ nnu̱ ma̱nho yø ja̱'i̱ te bi 'yøtra̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pɛ ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Da̱mi̱ hyɛhmʉ na̱ ra̱ xisu 'bʉcua. 'Yogui sʉhmʉ, porque xa̱nho te ørque. ");
INSERT INTO otnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A nu̱ya yø hyoya guí̱ mma̱mhmʉ, hangu̱ ra̱ pa guí̱ nnu̱hʉ ya yø hyoya. Da̱ zä gui fäxhʉ te honi̱ hønt'a̱ goma̱ ora guí̱ nne gui fäxhʉ. Pɛ nu̱gä hi̱nga̱ nza̱mhmʉ ua. ");
INSERT INTO otnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A nu̱na̱ ra̱ xisu guí̱ mma̱mhmʉ, bi 'yørca̱gui̱'a̱ te bi zʉrpa̱bi̱ rá̱ ts'ɛdi bi 'yøt'e. Porque ya bi̱ nja'a̱ te mi̱ ja xtí̱ nja'mø dá̱ n'yägui. ");
INSERT INTO otnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱p'ʉ ha da̱ hma̱nna̱ hoga̱ 'da'yo hya̱ gä rá̱ ngʉni̱ nxi̱mhäi, xquet'a̱ 'nɛ̱'a̱ te bi 'yørca̱gui̱ na̱ ra̱ xisu, da̱ hma̱. Gue'a̱ di fɛn'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nu̱na̱ ra̱ Judas Iscariote, guehna̱ n'na nc'ɛ̱i̱'ʉ 'dɛ'ma̱ yoho yø xädi ra̱ Jesús, bi̱ ma bá̱ nya̱ui yø hmu̱ yø mmäcja̱. Bá̱ nhɛca̱ hya̱ui yø mmäcja̱ ha di japi di däpra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mi̱ 'yø'a̱ ra̱ hya̱ sihyø mmäcja̱, asta̱ ra̱ ndijohya. Bi xi p'ʉya ngue di u̱nna̱ mɛ̱nyu̱. Ja̱na̱ngue bi hyonna̱ Judas ha di japi ngue di däpyø mmäcja̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ya fʉhra̱ ngo nguehya yø pa ts'i ra̱ thu̱hmɛ̱ hi̱ngui̱ n'youi ra̱ íxi. Nu̱na̱ ra̱ pa fʉhra̱ ngo, guehna̱ ra̱ pa hodɛ'yo yø ja̱'i̱ ngue sänni̱go, ngue di̱ nzibde ngue ra̱ pascua. Bi yɛ̱mbyø xädi ra̱ Jesús: ―¿Hapʉ guí̱ nne ga̱ hocähe ra̱ nzibde gdá̱ nsänni̱gohʉ ngue ra̱ pascua ya? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bi 'yɛ̱mbya yoho yø xädi ra̱ Jesús: ―Ní̱ mɛ nʉ bí ja ra̱ hni̱ni̱ ya. Gui̱ nthɛui n'na ra̱ n'yohʉ ni̱ ma rá̱ ngu̱, di tu̱ n'na xøni̱ ra̱ dehe. Da̱mi̱ tɛnnui hapʉ da̱ zøni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nu̱p'ʉ ja ra̱ ngu̱ da̱ zømp'ʉya, da̱mi̱ 'yɛ̱nui ra̱ mmɛ̱nni̱gu̱: “Ra̱ xännba̱te i ɛ̱na̱: ¿Hapʉ ja ra̱ cuarto ga̱ nzibdehe ma̱ xädi ya, ja ga̱ sähe p'ʉ ra̱ ngo ngue ra̱ pascua?” gui 'yɛ̱nui. ");
INSERT INTO otnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ra̱ mmɛ̱nni̱gu̱ p'ʉya, da̱ 'yu̱t'a̱ui n'na ra̱ da̱cuarto ya ma̱hoqui, bí ja ma̱ya̱ ra̱ tøca̱ngu̱. Ja da̱mi̱ hocui p'ʉ'a̱ te ja ngue gdá̱ nzibdehʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nu̱ya yø xädi mi̱ ya̱ui ra̱ Jesús, bi̱ map'ʉ ja ra̱ hni̱ni̱ bi xifi ngue da̱ ma. Mi̱ zømp'ʉ ja ra̱ hni̱ni̱, nu̱na̱ ra̱ hya̱ xi̱ ma̱nna̱ Jesús, gue'a̱ bi̱ nja'a̱. Bi di̱nna̱ ngu̱ tengu̱tho xi xifi, ja bi hojpʉ ra̱ nzibde ngue ra̱ pascua p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mi̱ dähra̱ nde p'ʉya, nu̱p'ʉ ja ra̱ ngu̱ xi̱ ma ma̱hojpi te da̱ zi, ja bi zømp'ʉ ra̱ Jesús, ní̱ n'youi'ʉ 'dɛ'ma̱ yoho yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mɛ̱nte si̱hmɛ̱ p'ʉ ja ra̱ mɛ̱xa p'ʉya, bi 'yɛ̱mbyø xädi: ―Nu̱yá, dí xi'a̱hʉ ngue nu̱ua ja ra̱ mɛ̱xa dí si̱hmɛ̱hʉ, 'bʉcua n'na nc'ɛ̱i̱ jʉga̱tho häi, ya xa̱ hyoni̱ ha di japi ngue di dägui. ");
INSERT INTO otnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, ɛ̱mmɛ̱i̱ bi du̱ yø mmʉi yø xädi. Bi̱ mʉdi bi 'yänni̱ 'da mi̱'da p'ʉya te'o na̱ i̱ mma̱, bi 'yɛ̱mbi̱: ―¿Ua go guecä'a̱ guí̱ mma̱nya? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bi 'yɛ̱ntho 'mø mi̱ da̱hra̱ Jesús: ―Nu̱na̱ dí com'be ma̱ mohi ua dí si̱hmɛ̱ ya, guehna̱ di dägä na̱ya. Guehna̱ n'na nc'ɛ̱i̱ ngue gui 'dɛma̱ yohohʉ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma̱jua̱ni̱ ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ tho'a̱ te ra̱ n'ʉ ja ngue da̱ thogui, tengu̱tho nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue di̱ nja. Pɛ hague ngu̱ ra̱ castigo da̱ thohna̱ ra̱ n'yohʉ ja ngue di dägui. Nu̱na̱ ra̱ n'yohʉ na̱, ma̱n'na xa̱nho ngue'mø hi̱n xta̱bá̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mɛ̱nte si̱hmɛ̱ ra̱ Jesús, bi hya̱jma̱n'na ra̱ thu̱hmɛ̱. Mi̱ ja ma̱mma̱di̱ Oja̱ p'ʉya, bi xɛnna̱ thu̱hmɛ̱, bi u̱nyø xädi da̱ zi. Bi 'yɛ̱mbi̱: ―Da̱mi̱ sihʉ ra̱ thu̱hmɛ̱ ja ua ya. Nu̱ná̱, guehna̱ ma̱ do'yogä na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bi dɛcra̱ vaso po rá̱ ngui ra̱ uva p'ʉya. Mi̱ ja ma̱mma̱di̱ Oja̱, bi u̱nyø xädi da̱ zi 'da'its'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bi 'yɛ̱mbi̱: ―Nu̱na̱ po ra̱ vaso ja ua ya, guehna̱ ma̱ jigä na̱. Porque guehna̱ ra̱ hmɛ̱ya na̱ya ngue nu̱'mø dá̱ tu̱, di̱ nja rá̱ ts'ɛdi ra̱ 'da'yo cohi øt'a̱hʉ Oja̱. Porque nu̱'a̱ di̱ mfämma̱ ji, xa̱ndøngu̱ yø ja̱'i̱ di̱ nhohyø ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ma̱jua̱ni̱ dí xi'a̱hʉ ya, ngue ya hi̱nni̱ mantho 'dap'ʉ ga̱ sihʉ rá̱ ngui ra̱ uva, asta̱ gue'mø bi zønna̱ pa ma̱'da'yo hønga̱ sihʉ p'ʉ di̱ ma̱nda Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mi̱ juate ra̱ nsi̱hmɛ̱ p'ʉya, bi du̱ta̱ n'na ra̱ thu̱hu̱ ngue ɛ̱spa̱bi̱ Oja̱. Bi̱ ma p'ʉya, i̱ map'ʉ bí ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos. ");
INSERT INTO otnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Gätho'a̱hʉ ya, gui soga̱hʉ p'ʉ'a̱ di̱ nxu̱i̱. Porque di̱ nja'a̱ te mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na: “Ga̱ øt'ä ngue da̱ du̱ ra̱ mändɛ'yo. Yø dɛ'yo p'ʉya di̱ n'uɛ̱ni̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pɛ nu̱'mø dá̱ bɛ̱nna̱te, ga̱ni̱ mpagä Galilea, ja ga̱ni̱ tøp'a̱hʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Ma̱da̱gue'a̱ ngue gä da̱ zoc'a̱'i̱ p'ʉ ya mi̱'da ma̱ n'yohʉ, pɛ nu̱gä hi̱nga̱ soc'a̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbra̱ Bɛdu: ―Ma̱jua̱ni̱ dí xi'i ngue nu̱'a̱ di̱ nxu̱i̱ ya, tobe hi̱ndi̱ ma'a̱ rá̱ yohmafi ra̱ øni̱, ya xqui cønga̱ nhyu̱ndi̱, gui̱ mma̱ ngue hi̱ngui̱ pa̱qui̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pɛ ra̱ Bɛdu p'ʉya n'nat'a̱ mma̱ ngue bi 'yɛ̱na̱: ―A nu̱'a̱, hi̱n'na̱'a̱. Ma̱da̱gue'a̱ ngue 'dap'ʉ ga̱ tu̱ui, pɛ nu̱gä hi̱nga̱ cøn'a̱'i̱ ―bi 'yɛ̱mbi̱. Gätho'ʉ mi̱'da yø xädi p'ʉya, 'da'igu̱ bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nu̱na̱ ra̱ Jesús bi̱ mähä yø xädi, bi zømp'ʉ ja ra̱ xɛqui ni̱ hu̱ ngue Getsemaní. Nu̱p'ʉ bi zøni̱, bi 'yɛ̱mbi̱: ―Da̱mi̱ mi̱hmi̱ ua ya, mɛ̱nte ga̱ thocä mi̱ts'ʉ ní̱ nguehnʉ ngue ga̱ ma mat'Oja̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bi thohmi̱ts'ʉ ní̱ nguep'ʉ ra̱ Jesús, bi̱ mɛ ra̱ Bɛdu, ra̱ Jacobo, ra̱ Xuua. Bi̱ mʉdi bi där'ma̱n'ʉ rá̱ mmʉi ra̱ Jesús, ma̱thoguitho ngue bi du̱ rá̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bi 'yɛ̱mbyø n'youi p'ʉya: ―Ja̱njua̱ni̱ ngue tu̱ ma̱ mmʉigä, nu̱p'ʉ nna̱ sä, ya ja ngue 'bexca̱ tu̱. Da̱mi̱ cohmi̱ ua ya, pɛ 'yogui a̱hmi̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ra̱ Jesús bi thohmi̱ts'ʉ ní̱ nguep'ʉ. Bi̱ m'mɛmfo häi p'ʉya ngue mmat'Oja̱. Bi 'yäp'Oja̱ ngue'mø da̱ ne, da̱ ya̱ni̱ ngue'a̱ ra̱ nda̱te ja ngue da̱ thogui. ");
INSERT INTO otnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Bi 'yɛ̱mp'ʉya: ―Ague ma̱ Papá'i, nu̱'i̱, gätho da̱ zä'i. Da̱mi̱ ya̱ngui̱ ngue'a̱ ra̱ nda̱te ja ngue ga̱ thocä. Pɛ hi̱nga̱ nu̱'a̱ go ga̱ sännä gue'a̱ di̱ nja'a̱, sinoque nu̱ te guí sänni̱, gue'a̱ di̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mi̱ juadi bi̱ mat'Oja̱ p'ʉya, bí 'yɛ̱p'ʉ 'bʉ'ʉ hyu̱ yø xädi. Pɛ bi di̱ni̱ ngue ya mi̱ a̱ha̱. Bi 'yɛ̱mbra̱ Bɛdu p'ʉya: ―Ague Simu̱, ¿hanja ngue guí a̱ha̱? ¿Ua xi̱nga̱ n'na ora di sä gui 'yä ni̱ t'a̱ha̱? ");
INSERT INTO otnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Da̱mi̱ mat'Oja̱, 'yogui a̱hmʉ. Nu̱'mø hi̱ngá̱ mat'Oja̱hʉ, ntha̱mbɛni̱tho hi̱nda̱ gue'a̱ gui 'yøthʉ. I̱ nne ni̱ mmʉi ngue gui 'yøthʉ na̱ ra̱ hya̱ dí̱ mma̱ngä, pɛ ɛ̱mmɛ̱i̱ cuen'ni̱ do'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma̱hømbi zop'ʉ yø xädi, bi̱ mengbʉ xpí 'yɛ̱hɛ̱ ngue bá̱ mat'Oja̱. Tengu̱tho xi̱ ma̱n'a̱ m'mɛt'o, ngu̱'a̱ ra̱ hya̱ xi Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma̱mbá̱ pengbʉya, ma̱hømbi di̱nyø xädi ngue mi̱ a̱ha̱, porque ɛ̱mmɛ̱i̱ netha̱. Mi̱ da̱mbɛ̱ni̱ yø xädi ya nzofo, hi̱ngui̱ pa̱di̱ te di da̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bi̱ ma'a̱ rá̱ hyu̱ ndi̱ p'ʉya ngue bá̱ mat'Oja̱. Ma̱mbá̱ pengui̱, bi 'yɛ̱mbyø xädi: ―Gue ma̱hønguí a̱hmi̱ n'yø. Ga̱ nu̱hmi̱, ya bi zønna̱ ora di̱ ndäpyø ts'oc'ɛ̱i̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Da̱mi̱ nangüi̱. Ya bá̱ ɛ̱cua na̱ di dägui, ma ga̱ ma c'athʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mɛ̱nte nzohyø xädi ra̱ Jesús, bi zøhna̱ Judas rá̱ n'youi'ʉ 'dɛ'ma̱ yoho yø xädi, bá̱ n'youi xa̱ngu̱ yø ja̱'i̱, bá̱ gʉ yø juai, bá̱ gʉ yø za. Guehya yø ja̱'i̱ xi̱ mɛnhyø hmu̱ yø mmäcja̱, co 'nɛ̱hyø xännba̱te ngue ra̱ ley, co 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nu̱na̱ ra̱ Judas, ya xi xihyø ja̱'i̱ tema̱ senya da̱ 'yøt'e, xi 'yɛ̱mbi̱: “Nu̱'a̱ ra̱ n'yohʉ ga̱ zɛnguagä ya, 'nɛ̱ ga̱ sʉrpa̱ rá̱ hmi̱, gue'a̱ guí homhmʉ'a̱ p'ʉya. Gui bɛnthʉ, pɛ gue ma̱mi̱ thøhmʉ”, xi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ja̱na̱ngue mi̱ zømp'ʉ 'bähra̱ Jesús, bi guat'i ngue bi zɛngua. Bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te ―bi 'yɛ̱mbi̱. Bi zʉrpa̱ rá̱ hmi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","'Bexpi bɛntyø ja̱'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bi gʉxrá̱ juai n'na nc'ɛ̱i̱ rá̱ xädi ra̱ Jesús. Bi zɛnnba̱bi̱ rá̱ 'yɛ̱hɛ̱ ra̱ 'bɛt'o mmäcja̱, bi hyɛjpa̱bi̱ rá̱ gu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱ bi bɛnt'i̱: ―¿Ua guí ɛ̱mhmʉ ngue drá̱ bɛ̱gä, ngue guí cʉhʉ yø juai, 'nɛ̱ guí cʉhʉ yø za ngue gui bɛnnga̱hʉ? ");
INSERT INTO otnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Conque n'na pa ngu̱ n'na pa nmi̱ xännbä ra̱ hya̱ yø ja̱'i̱ p'ʉ ja ra̱ ni̱ja̱. Ua̱ngui̱ xta̱ nzä ja xqui bɛnnga̱hʉ p'ʉ. Pɛ nu̱ te guí ørca̱hʉ ya, ya bi̱ nja'a̱ te ra̱ hya̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Gä bi zop'ʉ yø xädi ra̱ Jesús ngue bi 'dagui. ");
INSERT INTO otnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nu̱'mø ya ni̱ zi yø ja̱'i̱ ra̱ Jesús, bi ntɛt'a̱ n'na ra̱ ts'ʉnt'ʉ. Hønda̱ n'na ra̱ sábana di̱ mpät'i. Xquet'a̱ 'nɛ̱hna̱ ra̱ ts'ʉnt'ʉ bi̱ ne xti bɛntyø ja̱'i̱ ngue xta̱ nzits'i. ");
INSERT INTO otnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pɛ nu̱na̱ ra̱ ts'ʉnt'ʉ bi gua̱s'yø ja̱'i̱ ngue bi 'dagui. Bi zop'ʉ ra̱ sábana mi̱ tu̱hu̱, bi̱ ma ma̱ngøtho. ");
INSERT INTO otnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nu̱na̱ ra̱ Jesús, bi ts'ixpʉ 'bʉhra̱ 'bɛt'o mmäcja̱. Nu̱p'ʉ ja rá̱ ngu̱ ra̱ mmäcja̱, ja bi̱ mpɛti p'ʉ gätho yø hmu̱ yø mmäcja̱, co 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱, conyø xännba̱te ngue ra̱ ley, gä 'dap'ʉ bi̱ mpɛti. ");
INSERT INTO otnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pɛ ra̱ Bɛdu ní̱ 'bɛfa ya'a̱tho p'ʉ ní̱ ma yø ja̱'i̱ ní̱ zi ra̱ Jesús. Mi̱ zømp'ʉ ja rá̱ ngu̱ ra̱ 'bɛt'o mmäcja̱, bi yʉt'a̱mbo ra̱ da̱thi. 'Dap'ʉ bi̱ mi̱hmi̱ yø policía ma̱di̱ nharpʉ ja ra̱ sibi. ");
INSERT INTO otnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nu̱'ʉ yø hmu̱ yø mmäcja̱ co 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o ngue yø judío, 'dap'ʉ bi̱ mpɛti ngue bi̱ nhɛca̱ hya̱, honi̱ ha di japi ngue da̱ 'yɛ̱mbi̱ ni̱ 'yu̱p'ʉ da̱ du̱ ra̱ Jesús. Pɛ hi̱ngui̱ ti̱ni̱ ha di japra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Xa̱ngu̱ yø ja̱'i̱ bi̱ ma̱nyø fɛhni̱ ngue di ya̱pra̱ Jesús. Pɛ hi̱ndi̱ nti̱nyø hya̱ ngue da̱ 'da'igu̱ da̱ ma̱mp'ʉ di ya̱pa̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","M'mɛfa p'ʉya, bi guar'mi̱'da yø ndøbɛthani̱ ngue di ya̱pi̱. Bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, ya xtá̱ øcähe tema̱ hya̱ xa̱ mma̱n'a̱ m'mɛt'o na̱, ngue mi̱ ɛ̱na̱: “Ga̱ xot'ä na̱ ra̱ ni̱ja̱ ngue ra̱ ja̱'i̱tho bi hoqui. Rá̱ hyu̱ pa p'ʉya, dí jap'ʉ ma̱n'na ra̱ ni̱ja̱ ngue hi̱njonni̱ ja̱'i̱ di hoqui”, mi̱ ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngu̱na̱ ra̱ hya̱ bi hma̱, mi̱'da yø ja̱'i̱ p'ʉya, n'nan'yo ra̱ hya̱ i̱ mma̱. Ya hi̱ndi̱ nti̱nyø hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bi̱ m'mähra̱ 'bɛt'o mmäcja̱ p'ʉya ngue bi 'yɛ̱mbra̱ Jesús: ―¿Te guí̱ mma̱nna̱ ra̱ hya̱ gui̱ nya̱p'a̱'i̱ ya n'yø? ¿Ua hi̱n tema̱ hya̱ gdi tha̱di̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pɛ ra̱ Jesús hi̱nte ga̱ nda̱tho. Ra̱ 'bɛt'o mmäcja̱ p'ʉya ma̱hømbi̱ 'yɛ̱mbi̱: ―¿Ua gue'e grá̱ Cristo, rá̱ Ts'ʉnt'ʉ'i Oja̱ nu̱na̱ ma̱guesɛ? ");
INSERT INTO otnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―A̱há̱, go guecä. 'Nɛ̱ gui̱ nnu̱hʉ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ni̱ mmi̱p'ʉ bí ja rá̱ n'yɛi Oja̱ nu̱na̱ jasɛ rá̱ ts'ɛdi. 'Nɛ̱ da̱ 'yɛ̱hra̱ pa ngue hønda̱ ɛ̱hɛ̱, di 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ n'youi ra̱ gu̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mi̱ 'yøhra̱ mmäcja̱ na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, n'na xɛt'itho rá̱ pahni̱ ngue bi̱ ncuɛ. Bi 'yɛ̱mbyø ja̱'i̱ p'ʉya: ―Nu̱ya mfa̱di̱ ya ngue hi̱n te ma̱n'na ma̱ testigo dí homhmʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya gá̱ 'yøsɛhʉ ya ngue thenma̱hya̱ Oja̱. Xiya, ¿te guí̱ mma̱mhmʉ na̱ ra̱ hya̱ bi̱ ma̱nya? ―bi 'yɛ̱mbyø ja̱'i̱. Gätho yø ja̱'i̱ p'ʉya 'da'igu̱ bi̱ ma̱, bi 'yɛ̱na̱: ―Nu̱na̱, ni̱ 'yu̱p'ʉ ngue da̱ tho na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bi̱ mʉhyø ja̱'i̱ p'ʉya ngue soxra̱ Jesús. Bi gorpa̱ yø dä conna̱ u̱lu, 'nɛ̱ bi̱ mɛ'mi̱, bi 'yɛ̱mbi̱: ―Da̱mi̱ pa̱di̱ te'o bi̱ mɛp'a̱'i̱ ya ―bi 'yɛ̱mbi̱. Yø soldado p'ʉya, xquet'a̱ bi̱ mɛ'mi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ya 'bʉp'ʉ ja ra̱ da̱thi ra̱ Bɛdu. Nu̱'a̱ n'na ra̱ xisu ngue ra̱ gʉni̱ p'ʉ ja rá̱ ngu̱ ra̱ 'bɛt'o mmäcja̱, bi thop'ʉ 'bʉhra̱ Bɛdu. ");
INSERT INTO otnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mi̱ nu̱ ngue di̱ nharpʉ ja ra̱ sibi, bi za di hɛ̱ti̱ p'ʉya. Bi 'yɛ̱mbi̱: ―'Nɛ̱'i̱ ni̱ n'youi ra̱ Jesús nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret. ");
INSERT INTO otnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ra̱ Bɛdu p'ʉya, bi 'yɛ̱na̱: ―Nu̱'a̱ ra̱ Jesús guí̱ mma̱nya, hi̱ndí̱ pa̱cä te'o na̱. Ja̱na̱ngue hi̱ndí̱ pa̱cä tema̱ hya̱ guí̱ nne gui xicya. Ra̱ Bɛdu p'ʉya, bi̱ map'ʉ bí ja rá̱ goxthi ra̱ da̱thi. Høntho bi zøn'a̱ goxthi p'ʉya, bi̱ mmahra̱ øni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma̱hømbi̱ nu̱ ra̱ Bɛdu'a̱ ra̱ xisu p'ʉya. Nu̱na̱ ra̱ xisu bi 'yɛ̱mbyø ja̱'i̱ 'bʉp'ʉ: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, guehna̱ n'na nc'ɛ̱i̱ yø xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ra̱ Bɛdu p'ʉya, ma̱hømbi̱ ma̱ ngue hi̱ngui̱ pa̱di̱ te'o ra̱ Jesús. Mi̱ tho hma̱n'na ts'ʉquits'ʉ p'ʉya, yø ja̱'i̱ 'bʉp'ʉ hømbi̱ 'yɛ̱mbra̱ Bɛdu: ―Ma̱jua̱ni̱ ngue ni̱ n'youi ra̱ Jesús, porque di̱ nɛ̱qui̱ ngue grá̱ mmɛ̱ngu̱ Galilea, nt'ødetho'a̱ te gni̱ ya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mi̱ da̱hra̱ Bɛdu p'ʉya, ma̱hømbi̱ 'yɛ̱na̱: ―Da̱ jacä ra̱ castigo Oja̱ 'mø ngue hi̱mma̱ jua̱ni̱ te dí xi'a̱hʉ. Pɛ nu̱na̱ ra̱ n'yohʉ guí xicjʉ, hi̱ndí̱ pa̱cä te'o na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, ma̱hømbi̱ mmahra̱ øni̱. Ra̱ Bɛdu p'ʉya bi zo rá̱ mmʉi na̱ ra̱ hya̱ xi xihra̱ Jesús ngue xi 'yɛ̱mbi̱: “Tobe hi̱ndi̱ ma'a̱ rá̱ yohmafi ra̱ øni̱, ya xqui cønga̱ nhyu̱ndi̱, guí̱ mma̱ ngue hi̱ngui̱ pa̱qui̱”, xi 'yɛ̱mbi̱. Mi̱ zo rá̱ mmʉi ra̱ Bɛdu na̱ ra̱ hya̱ na̱ p'ʉya, asta̱ ra̱ zondu̱mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mi̱ nɛ̱ca̱häi p'ʉya, bi̱ mpɛti gätho yø hmu̱ yø mmäcja̱, conyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱, conyø xännba̱te ngue ra̱ ley, conyø n'yohʉ 'bɛt'o ngue yø judío. Bi̱ nhɛca̱hya̱ ngue sänni̱ ha di japi di ya̱pra̱ Jesús. Bi du̱rpʉya, bi zixpʉ 'bʉhra̱ Pilato. ");
INSERT INTO otnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ra̱ Pilato bi 'yɛ̱mbra̱ Jesús: ―¿Ua gue'e rá̱ da̱st'abi'i yø judío? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―A̱há̱, go guecä tengu̱tho ra̱ hya̱ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yø mmäcja̱ p'ʉya, xa̱ngu̱ mi̱'da yø hya̱ gui ya̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ra̱ Pilato ma̱hømbi̱ 'yɛ̱mbra̱ Jesús: ―Ya guí øsɛ te gäma̱ hya̱ gui̱ nya̱p'a̱'i̱ ya. ¿Ua hi̱n tema̱ hya̱ gdi tha̱di̱? ");
INSERT INTO otnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ra̱ Pilato di 'yøtho ngue hi̱n tema̱ hya̱ ga̱ nda̱tho ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nu̱na̱ ra̱ Pilato, ja n'na rá̱ costumbre ngue di thø'a̱ n'na ra̱ ofädi 'mø ja ra̱ ngo ngue ra̱ pascua. Pɛ yø ja̱'i̱'ʉ huanhni̱ ndana̱ ra̱ ofädi da̱ ma ma̱thøgue. ");
INSERT INTO otnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, mi̱ ofädi n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Barrabás. 'Dap'ʉ ofädiui mi̱'da yø ja̱'i̱ ngue yø hyote, xi̱ n'øt'a̱ tu̱nhni̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mi̱ pɛti yø ja̱'i̱ ngue da̱ xihra̱ Pilato ngue di thø'a̱ n'na ra̱ ofädi. ");
INSERT INTO otnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ra̱ Pilato bi 'yɛ̱mbyø ja̱'i̱: ―¿Ua guí̱ nnehʉ ngue ga̱ thøcä'a̱ rá̱ da̱st'abi yø judío? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I pa̱hra̱ Pilato ngue ra̱ nts'ɛya øtya yø mmäcja̱ xi däpra̱ Jesús. Ja̱na̱ngue ngu̱na̱ bi xihyø ja̱'i̱, porque bi̱ ne xti thøgue. ");
INSERT INTO otnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pɛ yø hmu̱ yø mmäcja̱ ɛ̱mmɛ̱i̱ di ha̱tra̱ ts'ɛdi yø ja̱'i̱ ngue da̱ 'yäpra̱ Pilato ngue di thøhra̱ Barrabás. ");
INSERT INTO otnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma̱hømbi 'yɛ̱mbyø ja̱'i̱ ra̱ Pilato: ―Xina̱ ra̱ n'yohʉ guí̱ ɛ̱mhmʉ ngue rá̱ da̱st'abi yø judío p'ʉya, ¿te guí̱ nnehʉ ga̱ japä na̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yø ja̱'i̱ p'ʉya, xøgue n'na hma̱fitho bi 'yɛ̱na̱: ―Da̱ guatra̱ pont'i̱ na̱ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ra̱ Pilato p'ʉya, bi 'yɛ̱mbyø ja̱'i̱: ―Pɛ ¿tema̱ nts'o xa̱ 'yø'na̱ p'ʉya? Yø ja̱'i̱ p'ʉya, ma̱n'natho ngue mafi, bi 'yɛ̱na̱: ―Da̱ guatra̱ pont'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ra̱ Pilato p'ʉya, bi̱ ne di hojpa̱ yø mmʉi yø ja̱'i̱ mbøcuɛ. Ja̱na̱ngue bi thøhra̱ Barrabás. A nu̱na̱ ra̱ Jesús, bi xihyø soldado ngue da̱ fɛi, 'nɛ̱ da̱ zits'i ngue di cuatra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bi zixyø soldado ra̱ Jesús, i̱ map'ʉ ja ra̱ da̱thi cuarte. Ja bi̱ ma ma̱pɛti p'ʉ gätho yø soldado. ");
INSERT INTO otnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yø soldado p'ʉya bi heta̱ n'na ra̱ u̱lu ngue ra̱ jʉpoi ra̱ Jesús. Ya xi̱ me n'na ra̱ corona ngue yø 'ui̱ni̱, bi gäspa̱ rá̱ ya̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","I thenma̱hya̱ p'ʉya, bi 'yɛ̱mbi̱: ―I ta̱te na̱ rá̱ da̱st'abi yø judío ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bi jännba̱ rá̱ ya̱ co n'na ra̱ t'o. 'Nɛ̱ bi zots'i. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús tengu̱tho 'mø ngue ma̱jua̱ni̱ hnu̱ ma̱nsu̱ n'na ra̱ da̱st'abi. ");
INSERT INTO otnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mi̱ juadi bi denma̱hya̱, bi ga̱jpa̱bi̱ ra̱ tu̱hu̱ xi hete. Bi hetrá̱ he ya mi̱ he p'ʉya. Bi zixpʉya ngue di cuatra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nu̱p'ʉ ja ra̱ 'yu̱, bi̱ nthɛui p'ʉ n'na ra̱ n'yohʉ xpi 'yɛ̱hra̱ 'bɛfi. Rá̱ mmɛ̱ngu̱ Cirene na̱ ra̱ n'yohʉ, ni̱ hu̱ ngue ra̱ Simu̱. Guehna̱ rá̱ papá ra̱ Alejandro 'nɛ̱hra̱ Rufo. Nu̱'ʉ yø soldado ma̱ni̱ zi ra̱ Jesús, bi japra̱ Simu̱ ngue bi du̱xra̱ pont'i̱ nu̱na̱ da̱ ma ma̱cuati ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nu̱na̱ ra̱ Jesús, i zixyø ja̱'i̱ p'ʉ ja ra̱ xɛqui ni̱ hu̱ ngue Gólgota. Nu̱na̱ ra̱ hya̱ na̱, i̱ nne da̱ ma̱ ngue ra̱ Njʉya̱xhmu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nu̱p'ʉ bi zønna̱ Jesús, bi t'u̱nna̱ vino n'youi ra̱ mirra para ngue di pu̱mbɛ̱ni̱bi̱. Pɛ ra̱ Jesús hi̱mbi̱ ne bi zi. ");
INSERT INTO otnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bi cuatra̱ pont'i̱ p'ʉya, mi̱ juadi bi̱ nø'mi̱. Bi̱ ma ra̱ ta̱ha̱ yø soldado p'ʉya ngue to xta̱ ra̱ ta̱ha̱, gue'a̱ da̱ ga̱ca̱ n'na xɛqui rá̱ he ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gʉto xu̱di̱'a̱ ra̱ ora bi̱ ma ma̱cuati ra̱ pont'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nu̱p'ʉ ja rá̱ ya̱ ra̱ pont'i̱ bi cuati, bi̱ ma ma̱cuati n'na ra̱ letrero xi 'yot'i ngue mma̱mp'ʉ te bi̱ ma ma̱'ʉpi. Nu̱na̱ ra̱ letrero, i ɛ̱na̱: “Nu̱na̱ ra̱ n'yohʉ 'bʉcua, guehna̱ rá̱ da̱st'abi yø judío na̱”, ɛ̱nna̱ letrero. ");
INSERT INTO otnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","'Nɛ̱ yoho yø bɛ̱ bi̱ ma ma̱cuati ra̱ pont'i̱, n'na i gohrá̱ n'yɛi, n'na i gohrá̱ ga̱ha̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ya bi̱ nja tengu̱tho ra̱ hya̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Tengu̱tho ma̱japi yø ts'oc'ɛ̱i̱, ngu̱'a̱ da̱ thogui”. ");
INSERT INTO otnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Asta̱ hua̱tyø ya̱ yø ja̱'i̱ thop'ʉ ja ra̱ pont'i̱ cuatra̱ Jesús ngue thenni̱. I ɛ̱mbi̱: ―A nu̱ya n'yø, da̱mi̱ xorpa̱bi̱ rá̱ ni̱ja̱ Oja̱ ya. 'Nɛ̱ guí ɛ̱na̱ ngue nhyu̱ patho gdi hojma̱n'na ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Da̱mi̱ nya̱nsɛ ya, bá̱ ca̱p'ʉ ja ra̱ pont'i̱ guí cuatya ―ɛ̱mbyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nu̱'ʉ yø hmu̱ yø mmäcja̱ p'ʉya, conyø xännba̱te ngue ra̱ ley, gä thenma̱hya̱ ra̱ Jesús. Di̱ n'yɛ̱mbi̱: ―Mi̱ mma̱nnʉ ra̱ n'yohʉ ngue da̱ ya̱nyø ja̱'i̱. Pɛ nu̱yá, hi̱nda̱ zä ha di japi di̱ nya̱nsɛ ya. ");
INSERT INTO otnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A nu̱'mø ma̱jua̱ni̱ ngue ra̱ Cristo rá̱ da̱st'abi yø judío ya, da̱ zä da̱ ca̱hnʉ ja ra̱ pont'i̱ ya, n'namhma̱ ga̱ ɛ̱c'ɛ̱i̱hʉ te da̱ ma̱. Xquet'a̱ 'nɛ̱'ʉ yonc'ɛ̱i̱ 'dap'ʉ cuathʉ ra̱ pont'i̱ thenma̱hya̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mi̱ hyu̱xyadi p'ʉya, bi̱ m'mɛxu̱i̱ gä ra̱ xi̱mhäi asta̱ hyu̱ nde. ");
INSERT INTO otnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nu̱'mø ni̱ ma da̱ zʉ'i hyu̱ nde p'ʉya, ra̱ ndøts'ɛdi bi 'yɛ̱nna̱ Jesús: ―Eloi, Eloi, ¿lama sabactani? ―bi 'yɛ̱na̱. I̱ nne da̱ ma̱nna̱ ra̱ hya̱ na̱: “Ma̱ Oja̱'i̱, ma̱ Oja̱'i̱, ¿hanja ngue gá̱ hyɛga̱gui̱ p'ʉ?” ");
INSERT INTO otnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ja mi̱ 'bärpʉtho 'da yø ja̱'i̱, bi 'yøde te bi̱ ma̱nna̱ Jesús. Yø ja̱'i̱ p'ʉya di̱ n'yɛ̱mbi̱: ―Nu̱na̱ ra̱ n'yohʉ na̱, i̱ nzohra̱ Elías. ");
INSERT INTO otnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nu̱na̱ n'na nc'ɛ̱i̱ mi̱ 'bäp'ʉ, bi̱ ma n'na 'dihitho bá̱ ha̱ n'na xɛqui ra̱ esponja xa̱ ntu̱di̱, bi pop'ʉ ja ra̱ vino xa̱n'ixi. Bi̱ nøtra̱ t'o p'ʉya ngue bi cuarpa̱ rá̱ ne ra̱ Jesús ngue da̱ zʉts'i. I ɛ̱mbyø n'youi p'ʉya: ―Ma ga̱ nnu̱hʉ ya ngue'mø da̱ ɛ̱p'ʉ ra̱ Elías i̱ nzofo ngue da̱ hya̱jhnʉ ja ra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pɛ ra̱ ndøts'ɛdi i 'yɛn'a̱ n'na rá̱ hmafi ra̱ Jesús. Bi du̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, nu̱'a̱ ra̱ u̱lu mi̱ zʉp'ʉ ja ra̱ goxthi ni̱ja̱, bi xɛt'i, i ga̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nu̱'a̱ ra̱ capita mi̱ 'bäp'ʉ ni̱ hyandra̱ Jesús, bi̱ nu̱ te 'bɛ'a̱ gä bi 'yøtra̱ Jesús ha i du̱. Bi 'yɛ̱n'a̱ p'ʉya: ―Ma̱jua̱ni̱ ngue nu̱na̱ ra̱ n'yohʉ na̱, rá̱ ts'ʉnt'ʉ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Xa̱ngu̱ yø xisu bí 'bäp'ʉ yap'ʉtho, hantho te gä bi̱ nja. Nu̱'ʉ yø xisu'ʉ p'ʉya, n'youi p'ʉ ra̱ Salomé, conna̱ Ma̱ya nu̱na̱ ra̱ mmɛ̱ngu̱ Magdala, co 'nɛ̱hna̱ ma̱n'na ra̱ Ma̱ya rá̱ mamá ra̱ t'ʉ Jacobo 'nɛ̱hra̱ José. ");
INSERT INTO otnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nu̱ya yø xisu ya, nu̱'mø ma̱mbi 'yop'ʉ ja ra̱ häi Galilea ra̱ Jesús, mi̱ n'youi p'ʉ ni̱ ma, guehya mi̱ fäts'i ngue di u̱nni̱ te honi̱. 'Nɛ̱ xa̱ngu̱ mi̱'da yø xisu 'bäp'ʉ ngue bi dɛn'mø mi̱ ma Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mi̱ 'bʉp'ʉ n'na ra̱ mmɛ̱ngu̱ Arimatea ni̱ hu̱ ngue ra̱ José, i 'bɛt'o ngue yø judío, 'nɛ̱ di respeta yø ja̱'i̱. Xquet'a̱ mi̱ tø'mi̱ ngue n'nahma̱ntho di̱ ma̱nda ua Oja̱. Pɛ comma̱ ngue ya bi̱ nde, ya da̱ yʉtra̱ pa ngue ra̱ ts'äya, go guehna̱ ra̱ José bi hya̱ ra̱ ts'ɛdi bi̱ ma bá̱ nya̱ui ra̱ Pilato, bi 'yäpra̱ nt'ɛ̱di̱ ngue da̱ hya̱jpa̱ rá̱ do'yo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mi̱ 'yøhra̱ Pilato ngue ya xi du̱ ra̱ Jesús, di 'yøtho hanja. Bi zonhna̱ capita p'ʉya, bi 'yänni̱ ngue'mø ma̱jua̱ni̱ ya xi du̱, ogue hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ra̱ capita bi̱ ma̱ ngue ya xi du̱. Ra̱ Pilato p'ʉya, bi u̱nna̱ nt'ɛ̱di̱ ra̱ José ngue da̱ hya̱xra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nu̱na̱ ra̱ José bi dän'a̱ n'na ra̱ sábana ngue ra̱ hoga̱ u̱lu, ngue nu̱'mø bi hya̱jpʉ ja ra̱ pont'i̱ ra̱ Jesús, da̱ 'uɛnnba̱bi̱ rá̱ do'yo. Mi̱ jap'ʉ n'na ra̱ panteón ngue xi̱ ma nt'a'mi̱ p'ʉ ja n'na ra̱ 'bido, ja bi hya̱xpʉ ngue bá̱ ägui. Bi gotra̱ goxthi conn'na ra̱ ndødo. ");
INSERT INTO otnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nu̱na̱ ra̱ Ma̱ya ngue ra̱ mmɛ̱ngu̱ Magdala 'nɛ̱hna̱ ma̱n'na ra̱ Ma̱ya rá̱ mamá ra̱ José, guehya bi̱ mähä ya ngue bi̱ nu̱ ha bi t'ägui. ");
INSERT INTO otnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mi̱ thohra̱ pa ngue ra̱ ts'äya, nu̱na̱ ra̱ Ma̱ya ngue ra̱ mmɛ̱ngu̱ Magdala, conna̱ Ma̱ya rá̱ mamá ra̱ Jacobo, conna̱ Salomé bi dänyø 'yɛ̱thi̱ ya p'ʉya, ngue da̱ map'ʉ bí o ra̱ Jesús, da̱ cots'i. ");
INSERT INTO otnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mi̱ hyaxa̱ ra̱ pa ndomingo rá̱ mʉdi ra̱ pa ngue ra̱ semana, ya pøxyadi, bi̱ map'ʉ bí ja ra̱ panteón. ");
INSERT INTO otnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nu̱p'ʉ ja ra̱ 'yu̱ p'ʉya, di̱ n'yɛ̱mbi̱: ―Xiya, ¿te'o gue da̱ hya̱cra̱ do juaxpʉ ja ra̱ goxthi ya? ");
INSERT INTO otnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mi̱ zømp'ʉ ja ra̱ panteón, bi̱ nu̱ ngue ya n'nanni̱ 'bɛnna̱ do mi̱ juaxra̱ goxthi, ya xi tha̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mi̱ yʉt'a̱mbo, hu̱p'ʉ n'na ra̱ anxɛ he rá̱ t'axca̱ he, ni̱ mi̱hrá̱ hyo ra̱ goxthi ngue n'yɛi. Bi zu̱ 'mø mi̱ nu̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pɛ ra̱ anxɛ bi 'yɛ̱mbi̱: ―'Yo guí su̱ui. Dí pa̱cä ngue guí hommi̱ ra̱ Jesús nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret bi cuatra̱ pont'i̱ yø ja̱'i̱. Ya hi̱njo'o ua, ya xa̱ bɛ̱nna̱te. Da̱mi̱ nu̱ui nʉ ha bi 'bɛgui. ");
INSERT INTO otnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","A nu̱yá, ni̱ mɛ ya, ni̱ xihmi̱ ra̱ Bɛdu co 'nɛ̱'ʉ mi̱'da yø xädi ngue da̱ni̱ døp'a̱hʉ p'ʉ Galilea ra̱ Jesús. Ja gni̱ nu̱hʉ p'ʉ tengu̱tho bi xi'a̱hʉ m'mɛt'o. ");
INSERT INTO otnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mi̱ bømma̱ xøts'e ya yø xisu p'ʉya, n'na 'dihitho bi̱ ma, ma̱de di johya, ma̱de i su̱. Pɛ hi̱njonni̱ ja̱'i̱ xta̱ xifi te xi nu̱, asta̱ hua̱qui̱ ngue ra̱ ts'u̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Xu̱di̱tho'a̱ ndomingo bi bɛ̱nna̱te ra̱ Jesús. Rá̱ mʉditho bi̱ nthɛui na̱ ra̱ Ma̱ya ngue ra̱ mmɛ̱ngu̱ Magdala. Guehna̱ xi 'yøthe m'mɛt'o ngue mi̱ n'youi yoto yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nu̱'a̱ te xi̱ nja, go guehna̱ bi̱ ma bá̱ xi hmi̱'da yø xädi ra̱ Jesús, porque zoni̱ ngue tu̱ yø mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mi̱ 'yøhya p'ʉya ngue ya xi bɛ̱nna̱te ra̱ Jesús, 'nɛ̱ i̱ mma̱nna̱ ra̱ Ma̱ya ngue ya xi̱ nu̱ ra̱ Jesús, pɛ hi̱ngui̱ ɛ̱c'ɛ̱i̱tho te sifi. ");
INSERT INTO otnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","M'mɛfa p'ʉya, ra̱ Jesús ma̱hømbi̱ nthɛui p'ʉ ja ra̱ 'yu̱ mi̱ yoho yø xädi, ma̱ni̱ map'ʉ ja ra̱ hni̱ni̱. Pɛ nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi 'yøtra̱ Jesús ngue n'nan'yo p'ʉ i̱ nɛ̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nu̱ya yonc'ɛ̱i̱ ya, bi̱ ma bá̱ xihyø mmi̱xädiui. Pɛ ma̱høn'a̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱tho yø amigo te xifi. ");
INSERT INTO otnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Rá̱ nzɛgui p'ʉya, nu̱ya 'dɛ'ma̱'da yø xädi ra̱ Jesús 'darbʉ 'bʉi, si̱hmɛ̱ p'ʉ ja n'na ra̱ mɛ̱xa. Ja̱ mi̱ da̱nnbɛ̱ni̱, ya 'bäp'ʉ ra̱ Jesús. Bi zʉ p'ʉya, ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱ 'mø mi̱ sifi ngue ya xi bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bi xihyø xädi te ja ngue da̱ 'yøt'e, bi 'yɛ̱mbi̱: ―A nu̱yá, ni̱ mähä rá̱ ngʉni̱ nxi̱mhäi ya, gui xihmʉ ra̱ hoga̱ 'da'yo hya̱ gätho yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu̱ ra̱ ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱ ra̱ hya̱ 'nɛ̱ di̱ nxixya̱, guehna̱ di̱ nya̱nná̱ te na̱. Pɛ nu̱ ra̱ ja̱'i̱ hi̱nda̱ 'yɛ̱c'ɛ̱i̱ ra̱ hya̱, da̱ ma ra̱ castigo. ");
INSERT INTO otnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nu̱'ʉ yø ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱ ra̱ hya̱, da̱ zä da̱ 'yøtyø milagro, porque høntho da̱ 'yäqui ngue ga̱ fäts'i, ya da̱ zä da̱ 'yøthe yø ja̱'i̱ n'youi yø ts'onthi̱. 'Nɛ̱ da̱ zä da̱ nya̱ yø hya̱ hi̱nxa̱ xädi. ");
INSERT INTO otnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Da̱ zä di bɛntyø c'ɛ̱ya̱, pɛ hi̱nte da̱ japi. Ma̱da̱ zi ra̱ 'yɛ̱thi̱ ngue ra̱ nda̱te, pɛ hi̱nte da̱ japi. Da̱ japyø 'yɛ p'ʉ ja yø ya̱ yø därquɛ̱hi̱, 'nɛ̱ da̱ zä ha hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nu̱na̱ ra̱ Jesús, mi̱ juadi bi xihyø xädi ya yø hya̱ di 'bɛpi da̱ 'yøt'e, bi̱ ma ma̱hɛ̱ts'i̱ p'ʉya, i̱ mmi̱p'ʉ ja rá̱ n'yɛi Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nu̱'ʉ yø xädi p'ʉya, bi̱ ma ndap'ʉ bi zä, bi xihra̱ hoga̱ 'da'yo hya̱ yø ja̱'i̱. A nu̱'a̱ ra̱ Hmu̱ p'ʉya, i fäts'i ngue øtyø milagro tengu̱tho bi xifi. Nu̱'mø bi̱ nu̱ yø ja̱'i̱ yø milagro øtyø xädi ra̱ Jesús, i ha̱xa̱ njua̱ni̱ yø ja̱'i̱ ngue ma̱jua̱ni̱ na̱ ra̱ hya̱ sifi. Da̱ ngu̱t'a̱tho.");
INSERT INTO otnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Xa̱ngu̱ yø ja̱'i̱ bi̱ ne bi 'yʉtra̱ hya̱, 'nɛ̱ bi cuatra̱ sʉcua̱ ya yø hya̱ xa̱ nja ua dí 'bʉhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Guehya bi cuatra̱ sʉcua̱'a̱ te gäma̱ hya̱ bi̱ nxännba̱te yø ma̱mhya̱ nu̱ya bi̱ nu̱ te gä bi 'yøtra̱ Jesús, asta̱ gue'mø ma̱mbá̱ fʉdi bá̱ xännba̱ ra̱ hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nu̱gä xquet'a̱ da̱di ja ndu̱mmʉi dí honi̱ ha bi̱ njap'ʉ bá̱ fʉdi, asta̱ guehra̱ tiempo ja p'ʉya. Ague ma̱ ndø'amigo Teófilo, nu̱gä dí̱ nnu̱ ma̱nho ngue ga̱ ʉtra̱ hya̱ ga̱ cuarpʉ ja ra̱ sʉcua̱, ga̱ pɛn'na̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Porque dí̱ nne guí pa̱di̱ xa̱nho ngue ma̱jua̱ni̱ na̱ ra̱ hya̱ bi sän'na̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nu̱'a̱ ra̱ tiempo mi̱ nda̱st'abi p'ʉ ja ra̱ häi Judea ra̱ Herodes, mi̱ 'bʉ'a̱ n'na ra̱ mmäcja̱ ngue yø judío ni̱ hu̱ ngue ra̱ Zacarías. Nu̱na̱ ra̱ Zacarías, yø mmi̱mmɛfihʉ'ʉ yø mmäcja̱ tɛnna̱ ndu̱ ra̱ mmäcja̱ Abías. Nu̱'a̱ rá̱ xisu ra̱ Zacarías, ni̱ hu̱ ngue ra̱ Elisabet, guehna̱ n'na rá̱ mbom'mɛto ra̱ mmäcja̱ Aarón. ");
INSERT INTO otnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nu̱ya yonc'ɛ̱i̱ ya, nu̱'a̱ ra̱ nho nne Oja̱ ngue da̱ 'yøt'e, gue'a̱ bi 'yøt'a̱. Gä bi 'yøt'ʉ yø hya̱ mma̱mp'ʉ ja rá̱ ley Oja̱. Hi̱njongui̱ pøni̱ da̱ 'yɛ̱mbi̱ ngue hi̱nga̱ gue'a̱ øt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pɛ hi̱mbi̱ m'mʉhyø ba̱si̱, porque ma̱rá̱ 'ya̱ba̱si̱ na̱ ra̱ Elisabet. 'Nɛ̱ ya gä yø da̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nu̱na̱ ra̱ mmäcja̱ Zacarías, bi tocabi ngue bi zønna̱ ora di̱ m'mɛt'o p'ʉ ja ra̱ da̱ni̱ja̱ ngue da̱ da̱nne Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nu̱'ʉ yø mmäcja̱, ja yø costumbre ngue jʉcra̱ suerte ndana̱ gue'a̱ ra̱ mmäcja̱ da̱ yʉrbʉ ja ra̱ ni̱ja̱ dá̱ u̱hra̱ bopo. Nu̱'a̱ ra̱ ora'a̱, bi tocabi ra̱ suerte ra̱ Zacarías ngue da̱ u̱hra̱ bopo. ");
INSERT INTO otnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Gätho 'bʉ'a̱thi yø ja̱'i̱ ngue mmat'Oja̱, mɛ̱nte brá̱ ombo ra̱ Zacarías ngue brá̱ u̱hra̱ bopo. ");
INSERT INTO otnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ra̱ Zacarías bi̱ nu̱ ngue bi zø'a̱ n'na rá̱ anxɛ Oja̱, bi̱ m'mäp'ʉ ja rá̱ hyo ra̱ altar ngue n'yɛi, ha zø ra̱ bopo. ");
INSERT INTO otnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ɛ̱mmɛ̱i̱ bi̱ nsu̱ 'mø mi̱ nu̱ ra̱ anxɛ ra̱ Zacarías. Hi̱ngui̱ pa̱di̱ te da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pɛ ra̱ anxɛ bi 'yɛ̱mbi̱: ―Ague Zacarías, 'yo guí su̱. Porque da̱ 'yøt'a̱ Oja̱ ngue di̱ nja'a̱ te guí äpi. A nu̱yá, di̱ m'mʉ'a̱ n'na rá̱ ts'ʉnt'ʉ ni̱ xisu Elisabet. Gdi hu̱ti̱ ngue di Xuua. ");
INSERT INTO otnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gui johya 'mø bi̱ m'mʉi, di̱ nja'i mpähä. Xquet'a̱ xa̱ngu̱ yø ja̱'i̱ di johya 'mø bi̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Porque da̱ nu̱ ma̱nho Oja̱ ni̱ ts'ʉnt'ʉ. Nu̱na̱ ni̱ ts'ʉnt'ʉ hi̱nja̱m'mø da̱ zi ra̱ vino, 'nɛ̱ hi̱nte ma̱n'na ma̱ cosa da̱ zi ngue di̱ n'i̱ti̱. Mɛ̱nte yø pa di̱ m'mʉi, di̱ n'youi ra̱ Espíritu Santo. ");
INSERT INTO otnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Da̱ 'yøt'e ngue xa̱ngu̱ yø judío di 'bärpa̱ yø mmʉi da̱ 'yɛ̱c'ɛ̱i̱ Oja̱ nu̱na̱ 'bʉi ngue ra̱ Hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nu̱na̱ ra̱ Xuua di̱ m'mɛt'o p'ʉ di̱ ma ra̱ Hmu̱. Tengu̱tho ra̱ pønga̱hya̱ Elías ngue bi ma ma̱ha̱ti̱ ra̱ ts'ɛdi, xquet'a̱ di̱ njarbʉtho ni̱ ts'ʉnt'ʉ ya, da̱ ma ma̱ha̱ti̱ ra̱ ts'ɛdi. Da̱ japyø ja̱'i̱ di 'bätyø mmʉi, da̱ 'yøt'e tengu̱tho mi̱ øtyø mboxita. Nu̱'ʉ yø mmɛjhma̱hya̱, da̱ ba̱di̱ ngue da̱ dɛnnba̱bi̱ yø hya̱ yø hoja̱'i̱ bá̱ di̱nna̱ hya̱. Da̱ japyø ja̱'i̱ ngue di̱ nsäp'ʉ ja yø mmʉi ngue da̱ 'yɛ̱c'ɛ̱i̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nu̱na̱ ra̱ Zacarías bi 'yørpa̱ ra nt'änni̱ ra̱ anxɛ, bi 'yɛ̱mbi̱: ―¿Hanja na̱ ra̱ hya̱ guí xiqui? Porque nu̱gä ya dá̱ ndø, da̱ guehma̱ xisu p'ʉya, ya ra̱ da̱c'ɛ̱i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bi 'yɛ̱nna̱ anxɛ p'ʉya: ―Guecä drá̱ Gabriel. Dí 'bʉcä p'ʉ ja rá̱ hmi̱ rá̱ dä Oja̱. Go xpa̱ mmɛngä Oja̱ ya ngue ga̱ xi'i na̱ ra̱ hoga̱ 'da'yo hya̱ dí xi'i. ");
INSERT INTO otnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pɛ nu̱ya ngue hi̱nguí̱ ɛ̱c'ɛ̱i̱ na̱ ra̱ hya̱ dí xi'i ya, gui̱ ngone ya, hi̱nda̱ zä gui̱ nya̱, asta̱ gue'mø di̱ m'mʉhni̱ ts'ʉnt'ʉ dí xi'i. Nu̱na̱ ra̱ hya̱ dí xi'i, bá̱ ɛ̱p'ʉ ra̱ pa di̱ nja na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nu̱'ʉ yø ja̱'i̱ 'bʉ'a̱thi p'ʉya, i tø'mi̱ ngue da̱ pønna̱ Zacarías. Di 'yødyø ja̱'i̱ ngue ya'atho ra̱ ora bá̱ ombo nni̱ja̱ ra̱ Zacarías. ");
INSERT INTO otnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ya hi̱ngui̱ sä di̱ nya̱ 'mø ma̱mbá̱ pøni̱. Ja̱na̱ngue bi ba̱hyø ja̱'i̱ ngue ja te bá̱ t'u̱ta̱ mbonni̱ja̱. Ya yø 'yɛtho ga̱ 'yøtra̱ senya p'ʉya, porque ya hi̱ngui̱ sä di̱ nya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nu̱'mø mi̱ dätra̱ pa ngue øtrá̱ nda̱nne p'ʉ ja ra̱ ni̱ja̱ ra̱ Zacarías, bi̱ ma rá̱ ngu̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","M'mɛfa p'ʉya, mi̱ hya̱ rá̱ ba̱si̱ rá̱ xisu Elisabet. Bi̱ m'mʉrpʉ ja rá̱ ngu̱, hi̱n hapʉ i̱ ma mɛ̱nte ncʉt'a za̱na̱. Ya ɛ̱n'a̱ nbɛ̱mp'ʉya: ");
INSERT INTO otnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ngu̱na̱ bi jacä Oja̱ ya, i̱ nnepe ngue ya hi̱nni̱ mantho da̱ dennga̱gui̱ yø ja̱'i̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mi̱ dät'a̱ n'nato za̱na̱ ngue ha̱ rá̱ ba̱si̱ ra̱ Elisabet, nu̱na̱ Oja̱ hømbi̱ mɛnhna̱ anxɛ Gabriel, bi̱ map'ʉ ja n'na ra̱ hni̱ni̱ ni̱ hu̱ ngue Nazaret, ja ra̱ häi Galilea. ");
INSERT INTO otnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bi̱ ma da̱ nya̱ui n'na ra̱ hmu̱te xisu ni̱ hu̱ ngue ra̱ Ma̱ya. Nu̱ná̱, ya ja ngue di̱ ntha̱tui n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ José. Nu̱na̱ ra̱ José, rá̱ mbom'mɛto ra̱ da̱st'abi David. ");
INSERT INTO otnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nu̱'a̱ ra̱ anxɛ bi zøp'ʉ mi̱ 'bʉhra̱ hmu̱te, bi 'yɛ̱mbi̱: ―Nná̱ ha̱n'na̱'i̱ ra̱ nzɛngua ngue gá̱ nthɛui rá̱ ma̱te Oja̱. I̱ nnu̱ ma̱nho'i Oja̱, 'nɛ̱ ma̱n'na di ja̱p'a̱'i̱ ngue gätho mi̱'da yø xisu ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nu̱'mø mi̱ nu̱ ra̱ Ma̱ya ngue 'bäp'ʉ ra̱ anxɛ, di 'yøtho hanja na̱ ra̱ hya̱ xifi. I ɛ̱na̱: “¿Tegue ma̱nzɛngua'a̱ xicä na̱?” ");
INSERT INTO otnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ra̱ anxɛ p'ʉya bi 'yɛ̱mbi̱: ―Ague Ma̱ya, 'yo guí su̱. Nu̱'i̱, gá̱ nthɛui rá̱ ma̱te Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A nu̱ya gui hya̱ ni̱ ba̱si̱ ya, 'nɛ̱ drá̱ ts'ʉnt'ʉ'a̱ gui øni̱. Nu̱'mø bi̱ m'mʉi, gdí hu̱ti̱ ngue ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hi̱njonda̱ zʉdi tengu̱ na̱. 'Nɛ̱ di hu̱ ngue rá̱ Ts'ʉnt'ʉ Oja̱ ma̱guesɛ. Nu̱na̱ Oja̱ ma̱ Hmu̱hʉ, da̱ japi ngue di̱ nda̱st'abi na̱ ni̱ ts'ʉnt'ʉ tengu̱tho mi̱ pɛhrá̱ mboxita David. ");
INSERT INTO otnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ja̱na̱ngue di̱ ma̱nda para za̱ntho yø judío, 'nɛ̱ di̱ nda̱st'abi hi̱nha rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ra̱ Ma̱ya p'ʉya bi 'yørpa̱ ra̱ nt'änni̱ ra̱ anxɛ, bi 'yɛ̱mbi̱: ―¿Ha di zä di̱ nja'a̱ guí xiqui, conque tobe hi̱n da̱di̱ ntha̱ti̱? ");
INSERT INTO otnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bi 'yɛ̱nna̱ anxɛ p'ʉya: ―Ra̱ Espíritu Santo da̱ zøp'ʉ gdi 'bʉi. Nu̱na̱ Oja̱ ma̱guesɛ ja rá̱ ts'ɛdi, da̱ zä da̱ 'yøt'e ngue gui hya̱ ni̱ ba̱si̱. Ja̱na̱ngue nu̱na̱ ra̱ ts'ʉnt'ʉ di̱ m'mʉi, gä ra̱ nho da̱ n'yo, 'nɛ̱ di̱ nhu̱ti̱ ngue rá̱ Ts'ʉnt'ʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A nu̱yá, xquet'a̱ 'nɛ̱'a̱ ni̱ mɛ̱ni̱ Elisabet di̱ m'mʉ'a̱ n'na rá̱ ts'ʉnt'ʉ ya, 'nɛ̱ guí pa̱di̱ ngue ya ra̱ da̱c'ɛ̱i̱'a̱ ra̱ xisu. 'Nɛ̱ t'ɛ̱mbi̱ ngue ra̱ 'ya̱ba̱si̱ na̱ ra̱ xisu̱ na̱. A nu̱yá̱, ya n'nato za̱na̱ ha̱ rá̱ ba̱si̱ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nu̱na̱ Oja̱, hi̱nte hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Bi 'yɛ̱nna̱ Ma̱ya̱ p'ʉya: ―Ya dí øcä na̱ ra̱ hya̱ mma̱n'Oja̱ 'mø. Da̱ jacä Oja̱ na̱ ra̱ hya̱ guí xiqui. Mi̱ ma̱nna̱ Ma̱ya na̱ ra̱ hya̱ na̱ p'ʉya, bi̱ ma ra̱ anxɛ. ");
INSERT INTO otnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A nu̱yá, nu̱na̱ ra̱ Ma̱ya bi̱ ma n'nahma̱ntho p'ʉ ja n'na ra̱ hni̱ni̱ rá̱ njap'ʉ ja yø xanthø ja'a̱ ra̱ häi Judea. ");
INSERT INTO otnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mi̱ zømp'ʉ ja rá̱ ngu̱ ra̱ Zacarías, bi yʉt'a̱mbo ra̱ Ma̱ya, bi zɛngua ra̱ Elisabet. ");
INSERT INTO otnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nu̱'mø mi̱ 'yøhra̱ Elisabet ngue di zɛnguate ra̱ Ma̱ya, ra̱ Elisabet bi 'ya̱nná̱ ba̱si̱ o rá̱ mmʉi. Ra̱ Espíritu Santo bi bɛ̱nnba̱bi̱ ra̱ hya̱ da̱ xihra̱ Ma̱ya. ");
INSERT INTO otnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bi ts'ɛdi bi 'yɛ̱mbʉya: ―Ma̱n'natho bi ja̱p'a̱'i̱ Oja̱ ngue gätho mi̱'da yø xisu. 'Nɛ̱ xquet'a̱ bi u̱nná̱ nja̱pi̱ ni̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Hague ngu̱ ra̱ njama̱ mma̱di̱ ja ngue ga̱ øt'ä, ngue bá̱ ɛ̱hɛ̱ bi zɛnguagui̱ rá̱ mamá ma̱ Hmu̱? ");
INSERT INTO otnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Høntho bi zo ma̱ gu̱ ngue ga̱di zɛnguagui̱, nu̱na̱ ma̱ ba̱si̱ o ma̱ mmʉi bi 'ya̱ni̱ ngue di johya. ");
INSERT INTO otnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ra̱ mmɛ̱nthi̱ gá̱ nthɛui ngue gá̱ 'yɛ̱c'ɛ̱i̱ ra̱ hya̱ bi si'i, porque nu̱'a̱ te mma̱n'Oja̱, di̱ nja'a̱ ―bi 'yɛ̱nna̱ Elisabet. ");
INSERT INTO otnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ra̱ Ma̱ya bi 'yɛ̱na̱: ―Nu̱gä dí ɛ̱spa̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Di johya ma̱ mmʉi conná̱ nguehna̱ Oja̱ ma̱ ya̱ntegä. ");
INSERT INTO otnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Porque bi 'yørcagui̱ ma̱ su̱ Oja̱, 'nɛ̱ hi̱nga̱ njua̱ni̱gui̱, nu̱gä drá̱ mɛfitho. Nu̱ ra̱ pa di̱ ma p'ʉya, gätho yø ja̱'i̱ da̱ 'yɛ̱ngui̱ ngue ra̱ mmɛ̱nthi̱ dá̱ nthɛ'be. ");
INSERT INTO otnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porque jasɛ rá̱ ts'ɛdi Oja̱, ¿hague ngu̱ ga̱nho'a̱ te bi 'yørcagui̱? Nu̱na̱ Oja̱, ma̱guesɛ na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hangu̱ ra̱ pa di huɛ̱cyø ja̱'i̱ su̱prá̱ xu̱di̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I ja ts'ɛdi te bi 'yøt'e. Bi hyɛjpa̱ yø hya̱ yø ja̱'i̱ di 'yɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bi 'yenspʉ ja yø nhu̱di̱ yø da̱st'abi. Bi japi bi hya̱ ra̱ ts'ɛdi yø ja̱'i̱ hi̱nga̱ njua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bi 'yøt'e ngue mbongui̱tho te da̱ zi yø ja̱'i̱ mi̱ tu̱ma̱nthu̱hu̱. Bi 'yɛtyø mmɛ̱mmɛti, hi̱ndi̱ japi te da̱ hya̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bi̱ nja rá̱ yemmʉi conná̱ ngue'ʉ yø judío mi̱ tha̱nne, hi̱mbi̱ pu̱mbɛ̱ni̱ bi̱ mäts'i. ");
INSERT INTO otnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bi̱ nja tengu̱tho ra̱ hya̱ bi sihma̱ mboxitahʉ Abraham, ngue para za̱ntho da̱ ma ma̱huɛ̱qui̱'ʉ yø mbom'mɛto. ");
INSERT INTO otnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nu̱na̱ ra̱ Ma̱ya, nhyu̱shna̱ bá̱ m'mʉp'ʉ 'bʉhra̱ Elisabet. Bi̱ ma rá̱ ngu̱ m'mɛfa p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mi̱ zønna̱ pa di ønná̱ ts'ʉnt'ʉ ra̱ Elisabet. ");
INSERT INTO otnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bi̱ ma di zɛngua'ʉ yø besino, 'nɛ̱hyø mɛ̱ni̱. Bi ba̱hyø ja̱'i̱ ngue xa̱ndøngu̱ ra̱ nho bi 'yørpa̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ya rá̱ hya̱to ma̱ pa xi̱ mi̱hra̱ ts'ʉnt'ʉ, bi̱ ma mhmɛ̱pya p'ʉya, bi̱ njapra̱ circuncisión. Yø ja̱'i̱ p'ʉya nnepe di hu̱ ra̱ ts'ʉnt'ʉ tengu̱tho gui hu̱ rá̱ papá Zacarías. ");
INSERT INTO otnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pɛ rá̱ mamá ra̱ ts'ʉnt'ʉ bi 'yɛ̱na̱: ―Hi̱n'na̱. Ma̱n'na xa̱nho di hu̱ ngue di Xuua ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bi t'ɛ̱mbʉya: ―¿Hanja? Conque hi̱nga̱ n'na ni̱ mɛ̱ni̱ ni̱ hu̱'a̱ ra̱ thu̱hu̱ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bi t'ørpa̱ ra̱ senya rá̱ papá ra̱ ts'ʉnt'ʉ p'ʉya, ngue t'änni̱ te di hu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bi 'yä'a̱ n'na ra̱ xithɛ p'ʉya, bi cuatra̱ thu̱hu̱ di ho, bi 'yɛ̱na̱: “Di hu̱ ngue di Xuua”. Gätho yø ja̱'i̱ p'ʉya, di 'yøtho. ");
INSERT INTO otnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Bexque'a̱ ra̱ ora'a̱ p'ʉya, bi zä bi̱ nya̱ ra̱ Zacarías. Ja̱njua̱ni̱ ngue di ja ma̱mma̱di̱ Oja̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gä di 'yøtho'ʉ yø besino'a̱ te bi̱ nja. Gätho'a̱ ra̱ xɛqui mi̱ 'bʉi ja ra̱ häi Judea, i̱ mma̱nyø ja̱'i̱ te bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Gätho ya yø ja̱'i̱ bi ba̱di̱ te bi̱ nja, di̱ n'yomfɛ̱ni̱, 'nɛ̱ di̱ n'yänni̱ n'na ngu̱ n'na, hague nja'a̱ ya. Di̱ n'yɛ̱mbyø ja̱'i̱: ―¿Te 'bɛ'a̱ gätho da̱ 'yør'mø bi̱ nda̱n'yohʉ na̱ ra̱ ts'ʉnt'ʉ na̱? ―di̱ n'yɛ̱mbi̱. Porque ɛ̱mmɛ̱i̱ di̱ u̱nná̱ nja̱pi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nu̱na̱ ra̱ Zacarías rá̱ papá ra̱ Xuua, bi bɛ̱nnba̱bi̱ ra̱ Espíritu Santo ra̱ hya̱ da̱ ma̱. Bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","―Ma ga̱ ɛ̱spa̱bi̱ na̱ ma̱ Hmu̱ Oja̱. Porque da̱ ɛ̱sɛ ua 'bʉhyø judío ngue di pøhø. ");
INSERT INTO otnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Da̱ pɛnnga̱hʉ n'na ra̱ Ya̱nte ja rá̱ ts'ɛdi. Guehna̱ n'na rá̱ mbom'mɛto ra̱ David nu̱na̱ bi 'yøt'e te nne Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nu̱'mø yø pa xa̱ thogui ngu̱na̱ ra̱ hya̱ bi bɛ̱nnba̱bi̱ yø pønga̱hya̱ Oja̱ 'mø mi̱ ya̱t'a̱ ra̱ hya̱ bi̱ nepe bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bi̱ ma̱ ngue da̱ ya̱njʉ p'ʉ 'bʉhma̱ nsʉihʉ. 'Nɛ̱ da̱ ya̱njʉ ngue'ʉ to gä nnu̱ ma̱n'ʉjʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bi̱ ma̱ ngue di huɛ̱c'ʉ ma̱ mboxitahʉ xa̱ m'mʉi. 'Nɛ̱ bi̱ ma̱ ngue nu̱'a̱ rá̱ ma̱ca̱ hya̱ bi xifi, hi̱ndi̱ pu̱mbɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Guehna̱ ra̱ hya̱ bi ya̱rpa̱bi̱ Oja̱ na̱ ma̱ mboxitahʉ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bi xifi ngue da̱ ya̱njʉ p'ʉ 'bʉhma̱ nsʉihʉ, n'namhma̱ ngue ya hi̱nga̱ su̱ ga̱ tha̱nnehʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","'Nɛ̱ ga̱ nsu̱phʉ, gä ra̱ nho gdá̱ n'yohʉ mɛ̱nte ra̱ pa ga̱ m'mʉhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A nu̱'i̱ grá̱ zits'ʉnt'ʉ, gdi hu̱ ngue rá̱ pønga̱hya̱'i na̱ Oja̱ ma̱guesɛ ya. Porque gui̱ m'mɛt'o ngue gui xojpa̱ yø mmʉi yø ja̱'i̱ hante dá̱ ɛ̱hra̱ Hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nu̱'i̱ gui japi da̱ ba̱hyø ja̱'i̱ ngue ya da̱ ma nhya̱ni̱, 'nɛ̱ di̱ mpu̱nnba̱bi̱ yø ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nu̱na̱ Oja̱ di̱ ma̱cjʉ, 'nɛ̱ di huɛ̱ga̱hʉ. Tengu̱ ra̱ hyadi di yor'mø ma̱ pa, asta̱ ma̱ya̱ bi̱ nɛ̱xrá̱ nyot'i søcua ja ra̱ häi. ");
INSERT INTO otnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nu̱'ʉ yø ja̱'i̱ 'bʉ 'bɛxu̱i̱ da̱ zä da̱ di̱nna̱ 'yu̱. Njarbʉtho ya, nu̱ya yø ja̱'i̱ xa̱nts'o ga̱ 'yo, ya ja ngue di̱ nthɛui ra̱ nda̱te. Da̱ xojpa̱ Oja̱ yø mmʉi. Da̱ japi da̱ ba̱hyø ja̱'i̱ ha di̱ nhojpa̱ui Oja̱ ―bi 'yɛ̱nna̱ Zacarías. ");
INSERT INTO otnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma̱n'na ni̱ zacra̱ ts'ʉnt'ʉ, bi̱ nte 'nɛ̱ ma̱n'na ni̱ ba̱ Oja̱. Pɛ bá̱ m'mʉp'ʉ ja ra̱ da̱po asta̱ gue'mø mi̱ zønna̱ pa da̱ xihra̱ hya̱ yø judío. ");
INSERT INTO otnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nu̱'ʉ yø pa'ʉ p'ʉya, gätho'ʉ yø nación di̱ ma̱nda ra̱ da̱st'abi Augusto, bi̱ ma̱nda ngue da̱ ma nsots'i ra̱ censo. ");
INSERT INTO otnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Guehna̱ rá̱ mʉdi ra̱ censo bi̱ ma nsots'i 'mø mi̱ nda̱st'abi ra̱ Cirenio p'ʉ ja ra̱ häi Siria. ");
INSERT INTO otnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gätho yø ja̱'i̱, ja ngue da̱ map'ʉ ja ra̱ hni̱ni̱ xa̱ m'mʉhyø mboxita, ngue di cuatyø thu̱hu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ja̱na̱ngue nu̱na̱ ra̱ José bá̱ nɛ̱xpʉ ja ra̱ hni̱ni̱ Nazaret ja ra̱ häi Galilea, i̱ map'ʉ ja ra̱ hni̱ni̱ Belén ja ra̱ häi Judea ma̱rá̱ mmɛ̱ngu̱ ra̱ David. Porque ra̱ José, rá̱ mbom'mɛto ra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bi̱ ma ra̱ José di cuatrá̱ thu̱hu̱ conna̱ Ma̱ya rá̱ xisu. Nu̱na̱ ra̱ José hi̱mbi dährá̱ xisu, pɛ ra̱ Ma̱ya ya ha̱ rá̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mɛ̱nte 'bʉp'ʉ ja ra̱ hni̱ni̱ Belén, nu̱na̱ ra̱ Ma̱ya bi zønna̱ ora di̱ m'mɛni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bi̱ m'mʉhrá̱ mʉdi ts'ʉnt'ʉ. Bi 'uɛ ra̱ u̱lu 'mø mi̱ mi̱. Bi gärbʉ ja rá̱ mosa yø fani̱, porque hi̱n'yʉ ha di̱ nsäya, hi̱nda̱ hønnbʉ ja ra̱ ngu̱mfani̱ i sä. ");
INSERT INTO otnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mi̱ 'bʉp'ʉ yø mändɛ'yo p'ʉ jon'a̱ Belén, ma̱di haxpʉ ngue fädi gä ra̱ xu̱i̱ yø dɛ'yo. ");
INSERT INTO otnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mi̱ da̱mbɛ̱ni̱, ya 'bʉp'ʉ n'na rá̱ anxɛ Oja̱. Rá̱ nyot'i Oja̱ p'ʉya, bi yot'i gätho p'ʉ 'bʉi. Pɛ ɛ̱mmɛ̱i̱ bi̱ nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ra̱ anxɛ p'ʉya bi 'yɛ̱mbi̱: ―'Yo guí su̱hʉ. Porque nná̱ ha̱n'na̱hʉ ra̱ hoga̱ 'da'yo hya̱ ya, 'nɛ̱ hønnbʉ bi zä di johya yø ja̱'i̱ 'mø bi 'yøhna̱ ra̱ hya̱ nná̱ ha̱gä ya. ");
INSERT INTO otnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","A nu̱yá, ya bi̱ mi̱hni̱ Yantehʉ p'ʉ ja ra̱ hni̱ni̱ mi̱ 'bʉhra̱ David. Guehna̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ga̱ xi'i te jap'ʉ ha gui ti̱mhmʉ. I̱ nt'ɛ ra̱ u̱lu na̱ ra̱ ts'ʉnt'ʉ, op'ʉ ja rá̱ mosa yø fani̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mɛ̱nte ya̱ ra̱ anxɛ p'ʉya, bi̱ nɛ̱qui̱ mi̱'da yø anxɛ bí 'yɛ̱ ma̱hɛ̱ts'i̱. Gä ɛ̱spa̱bi̱ Oja̱ yø anxɛ, i ɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―Ma̱guesɛ na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. 'Nɛ̱cua ja ra̱ xi̱mhäi, da̱ hyu̱rpa̱ yø mmʉi yø ja̱'i̱ da̱ nu̱rpa̱ rá̱ ma̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Høntho bi̱ ma̱nyø anxɛ na̱ ra̱ hya̱ na̱ p'ʉya, bi̱ mengui̱, i̱ ma ma̱hɛ̱ts'i̱. Yø mändɛ'yo p'ʉya, di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na: ―Ma ga̱ mmähä Belén. Ga̱ ma nu̱hʉ'a̱ ra̱ hya̱ bi ørca̱hʉ Oja̱ ngue bi̱ nja ya. ");
INSERT INTO otnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","N'nahma̱ntho bi̱ ma yø mändɛ'yo p'ʉya. Bi di̱mp'ʉ mi̱ 'bʉhra̱ Ma̱ya 'nɛ̱hra̱ José. Nu̱'a̱ rá̱ ts'ʉnt'ʉ, op'ʉ ja rá̱ mosa yø fani̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mi̱ nu̱p'ʉ ha 'bʉi, bi xifi ngue ya xi̱ ma̱nna̱ anxɛ ngue xi̱ mi̱hra̱ 'uɛne. ");
INSERT INTO otnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nu̱'ʉ yø ja̱'i̱ bi 'yøhya yø hya̱ bi̱ ma̱nyø mändɛ'yo, di 'yøtho hanja na̱ ra̱ hya̱ sifi. ");
INSERT INTO otnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pɛ ra̱ Ma̱ya hi̱nha gui pu̱mbɛ̱ni̱ na̱ ra̱ hya̱ bi sifi, hønt'a̱ mbɛ̱n'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nu̱'ʉ yø mändɛ'yo bi̱ mengbʉ xpi 'yɛ̱hɛ̱, pɛ ɛ̱spa̱bi̱ Oja̱, 'nɛ̱ di ja ma̱mma̱di̱ ngue'a̱ te ra̱ hya̱ xi 'yøde, 'nɛ̱'a̱ te gä xi̱ nu̱. Gä bi̱ nja tengu̱tho xi sifi. ");
INSERT INTO otnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ja rá̱ hya̱to ma̱ pa xi̱ m'mʉhra̱ ts'ʉnt'ʉ p'ʉya, bi̱ ma mhmɛ̱pya, bi̱ njapra̱ circuncisión. 'Nɛ̱ i hu̱ti̱ ngue ra̱ Jesús, tengu̱tho ra̱ thu̱hu̱ bi̱ ma̱nna̱ anxɛ nu̱na̱ bi̱ nya̱ui ra̱ Ma̱ya hante da̱ hya̱ rá̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nu̱p'ʉ ja ra̱ ley bi 'yotra̱ Moisés, i̱ nt'ot'i p'ʉ njammi̱ pa xa̱ m'mʉhra̱ ba̱si̱ 'mø da̱ zä da̱ ma ni̱ja̱. Ja̱na̱ngue nu̱'mø mi̱ dätra̱ pa, bi ts'ixra̱ 'uɛne p'ʉ ja ra̱ hni̱ni̱ Jerusalén ngue da̱ ma ma̱ däpi Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngu̱na̱ bi 'yøt'e porque nu̱p'ʉ ja rá̱ ley Oja̱, i̱ nt'ot'i p'ʉ ra̱ hya̱ ngue ɛ̱na̱: “Nu̱'a̱ rá̱ mʉdi ba̱si̱ ra̱ ja̱'i̱ di̱ m'mʉi ngue drá̱ ts'ʉnt'ʉ, da̱ ma ma̱ däpi Oja̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bi̱ ma p'ʉya ngue bá̱ øtra̱ 'bøt'e tengu̱tho nt'ot'i p'ʉ ja ra̱ ley, ngue da̱ hyo yoho yø ts'ints'ʉ ngue ra̱ tórtola, ogue yoho yø paloma. ");
INSERT INTO otnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nu̱'a̱ ra̱ tiempo'a̱ p'ʉya, mi̱ 'bʉp'ʉ Jerusalén n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Simeón. Guehna̱ n'na ra̱ hoga̱ n'yohʉ mi̱ tha̱nne Oja̱, 'nɛ̱ mi̱ tø'mi̱ ngue da̱ ma nhya̱ni̱ yø judío. Ra̱ Espíritu Santo di bɛ̱nnbi̱ te da̱ 'yø'na̱ ra̱ Simeón. ");
INSERT INTO otnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ya xi 'yu̱ti̱ ngue hante da̱ du̱, 'be da̱ nu̱ ra̱ Cristo nu̱'a̱ ja ngue da̱ pɛn'Oja̱ ngue di̱ nda̱st'abi. ");
INSERT INTO otnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nu̱na̱ ra̱ Simeón bi bɛ̱nnba̱bi̱ ra̱ Espíritu Santo ngue bi̱ map'ʉ ja ra̱ ni̱ja̱. A nu̱na̱ rá̱ papá 'nɛ̱hrá̱ mamá na̱ ra̱ t'ʉts'ʉnt'ʉ Jesús, ya bi zøp'ʉ ja ra̱ ni̱ja̱, nnepe ngue da̱ ma ma̱ däpi Oja̱ na̱ ra̱ Jesús, tengu̱tho mma̱mp'ʉ ja ra̱ ley. ");
INSERT INTO otnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nu̱na̱ ra̱ Simeón bi hyanna̱ ts'ʉnt'ʉ ngue bi dɛts'i. Bi ja ma̱mma̱di̱ Oja̱ p'ʉya, bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Ma̱ Oja̱'i̱, bi hyu̱ ma̱ mmʉigä ya. Porque ya bi̱ nja'a̱ te gá̱ ya̱rqui̱ ngue di̱ nja hante ga̱ tu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ya dá̱ nu̱gä na̱ ja ngue di̱ nya̱nte ya. ");
INSERT INTO otnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Guehna̱ guá̱ sänni̱ ngue da̱ ba̱di̱ gätho yø ja̱'i na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nu̱na̱ ya guehna̱ da̱ xojpa̱ yø mmʉi yø ja̱'i̱ hi̱ngyø judío na̱. Conná̱ nguehna̱ da̱ ma ma̱ya̱ yø judío. ");
INSERT INTO otnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nu̱na̱ ra̱ hya̱ bi xihra̱ zi'uɛne ra̱ Simeón, ra̱ José 'nɛ̱hrá̱ mamá ra̱ Jesús di 'yøtho hanja'a̱ ra̱ hya̱ øde. ");
INSERT INTO otnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nu̱na̱ ra̱ Simeón, bi 'yäp'a̱ Oja̱ ngue di ja̱pi̱. Bi t'ɛ̱mbra̱ Ma̱ya rá̱ mamá ra̱ Jesús: ―Nu̱na̱ ra̱ zi'uɛne 'bʉcua, bá̱ ts'ännba̱bi̱ na̱ ngue nu̱'mø bi̱ nda̱n'yohʉ, xa̱ngu̱ yø judío hi̱nda̱ nu̱ ma̱nho, guehya di̱ m'mɛhya. Pɛ nu̱ to da̱ nu̱ ma̱nho, guehna̱ ra̱ ja̱'i̱ di̱ nya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Guehna̱ di fa̱di̱ te mbɛ̱mp'ʉ ja yø mmʉi n'na ngu̱ n'na yø ja̱'i̱ na̱. Dí xi'i te ja ngue di̱ nja, ngue ra̱ du̱mmʉi gui thogui, tengu̱tho 'mø da̱ thohra̱ juai p'ʉ ja ni̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nu̱p'ʉ ja ra̱ ni̱ja̱ p'ʉya, mi̱ 'bʉp'ʉ n'na ra̱ xisu ngue di bɛ̱nnba̱bi̱ Oja̱ ra̱ hya̱ xihyø ja̱'i̱. Ni̱ hu̱ ngue ra̱ Ana na̱ ra̱ xisu, rá̱ t'i̱xu̱'a̱ ndu̱ ra̱ Fanuel, rá̱ mbom'mɛto ra̱ Aser. Rá̱ ngüɛtho 'mø mi̱ ntha̱ti̱, pɛ hønda̱ nyoto jɛya bi̱ m'mʉhmi̱ rá̱ ndø. Pɛ ya ra̱ bøda̱c'ɛ̱i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A nu̱yá, ya goho 'däte ma̱goho njɛya ra̱ 'danxu̱ ya. Hi̱nha ni̱ bømp'ʉ ja ra̱ ni̱ja̱. I tha̱nne Oja̱ ra̱ pa ra̱ xu̱i̱, mmat'Oja̱ hi̱n'yʉ p'ʉ rá̱ nzɛgui 'nɛ̱ ɛtrá̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mi̱ yʉtra̱ Ana p'ʉ 'bʉhra̱ zi'uɛne Jesús, bi̱ mat'Oja̱, di ja ma̱mma̱di̱ Oja̱. M'mɛfa p'ʉya, bi xihyø ja̱'i̱ 'bʉp'ʉ ja ra̱ ni̱ja̱, ngue nu̱'a̱ ra̱ 'uɛne 'bʉp'ʉ, gue'a̱ ra̱ Ya̱nte mi̱ tø'myø judío p'ʉ Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mi̱ juadi bi 'yøt'e te gä nt'ot'i p'ʉ ja rá̱ ley Oja̱, bi̱ mengbʉya, i̱ map'ʉ ja ra̱ hni̱ni̱ Nazaret ja ra̱ häi Galilea. ");
INSERT INTO otnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nu̱'a̱ ra̱ zits'ʉnt'ʉ, ma̱n'na ni̱ zaqui, i te, 'nɛ̱ ma̱n'na ni̱ di̱nna̱ hya̱, porque Oja̱ ɛ̱mmɛ̱i̱ bi ja̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nu̱na̱ ra̱ José 'nɛ̱hra̱ Ma̱ya, njɛya njɛya pa Jerusalén, bí̱ nnu̱ ra̱ ngo ngue ra̱ pascua. ");
INSERT INTO otnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ya ha̱ n'nɛma̱ yo njɛya ra̱ Jesús, xquet'a̱ 'nɛ̱hna̱ 'da i̱ ma dra̱ ts'änni̱go p'ʉ Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mi̱ guahra̱ ngo, bi̱ mengui, i̱ ma yø ngu̱. Pɛ ra̱ Jesús bá̱ cop'ʉ Jerusalén, hi̱ngui̱ pa̱hrá̱ papá 'nɛ̱hrá̱ mamá ngue bá̱ cohi. ");
INSERT INTO otnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","T'ɛ̱mbi̱ ngue ni̱ n'yohʉ yø ja̱'i̱ p'ʉ ja ra̱ 'yu̱ na̱ ra̱ Jesús. Bi̱ n'yo n'na pa, ja bi̱ mʉdi bi hyomp'ʉya, änyø mɛ̱ni̱ 'nɛ̱hyø mpa̱di̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pɛ hi̱mbi̱ di̱ni̱. Hømbi̱ mengbʉya, i̱ ma Jerusalén ngue bá̱ honi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Rá̱ hyu̱ pa p'ʉya, bi di̱mp'ʉ ja ra̱ ni̱ja̱ na̱ ra̱ Jesús, 'dap'ʉ hu̱mhmʉ yø xännba̱te ngue ra̱ ley. Nu̱na̱ ra̱ Jesús øts'e te mma̱n'ʉ ya̱ui, 'nɛ̱ ørpa̱ ra̱ nt'änni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pɛ xquet'a̱ t'ørpa̱bi̱ ra̱ nt'änni̱ p'ʉya. Pɛ nu̱'ʉ to gä øde te ga̱ nda̱di̱, di 'yøtho hanja rá̱ n'yomfɛ̱ni̱ bá̱ di̱ni̱ ngue'a̱ te ga̱ nda̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nu̱na̱ ra̱ José 'nɛ̱hra̱ Ma̱ya di 'yøtho 'mø mi̱ nu̱ ngue hu̱p'ʉ ra̱ Jesús. Rá̱ mamá ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague ma̱ ba̱si̱'i̱, ¿hanja ngue ngu̱'a̱ guí ørca̱'be? Ni̱ papá co 'nɛ̱qui̱ hi̱ndí̱ pa̱di̱ te ga̱ ør'be ngue dí hon'a̱'be ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua hi̱nguí̱ pa̱hmi̱ ha dí 'bʉi ngue gui hongüi? ¿Ua hi̱nguí̱ pa̱hmi̱ ngue jatho ga̱ m'mʉcua ha ja ra̱ xädi ngue rá̱ hya̱ ma̱ Papá? ");
INSERT INTO otnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pɛ nu̱ya ya̱ui, hi̱mbi̱ di̱nyø mmʉi ya yø hya̱ bi xifi. ");
INSERT INTO otnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bi̱ mengbʉya, i̱ ma Nazaret, 'da i̱ mähä ra̱ Jesús. Pɛ ɛ̱c'ɛ̱i̱ te xifi. Nu̱na̱ rá̱ mamá ra̱ Jesús, nu̱'a̱ ra̱ hya̱ bi xifi hønt'a̱ mbɛ̱n'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mɛ̱nte 'danyø pa p'ʉya, bi̱ nda̱n'yohʉ ra̱ Jesús, ma̱n'na ni̱ di̱nna̱ hya̱. 'Nɛ̱ nnu̱ ma̱nho Oja̱'a̱ te ga̱ 'yo, da̱ guehyø ja̱'i̱ xquet'a̱ nnu̱ ma̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ya n'nɛ'ma̱ cʉt'a̱ njɛya mi̱ 'yop'ʉ ra̱ nda̱st'abi n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Tiberio. Nu̱na̱ ra̱ Poncio Pilato ma̱rá̱ da̱st'abi p'ʉ ja ra̱ häi Judea na̱. A nu̱na̱ ra̱ Herodes ma̱rá̱ da̱st'abi p'ʉ ja ra̱ häi Galilea na̱. Nu̱na̱ ra̱ Lipe rá̱ n'yohʉ ra̱ Herodes ma̱rá̱ da̱st'abi p'ʉ ja ra̱ häi Iturea na̱, 'nɛ̱p'ʉ ja ra̱ häi Traconite ma̱di̱ ma̱nda. Nu̱na̱ ra̱ Lisanias ma̱rá̱ da̱st'abi p'ʉ ja ra̱ häi Abilinia na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nu̱na̱ ra̱ Anás 'nɛ̱hna̱ ra̱ Caifás, guehya yø 'bɛt'o mmäcja̱ ya. Oja̱ bi zoprá̱ mmʉi na̱ ra̱ Xuua rá̱ ts'ʉnt'ʉ ra̱ Zacarías ma̱mbí 'bʉp'ʉ ja ra̱ da̱po. ");
INSERT INTO otnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nu̱na̱ ra̱ Xuua, bi̱ n'yo gätho'ʉ yø xɛqui jap'ʉ ja ra̱ da̱the Jordán. Bi xihyø ja̱'i̱ ngue da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo, n'namhma̱ ngue di̱ mpu̱nnba̱ yø ts'oqui, di xixya̱bi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bi 'yøtra̱ Xuua tengu̱tho ra̱ hya̱ mma̱mp'ʉ ja ra̱ libro bi 'yotra̱ pønga̱hya̱ Isaías, ngue ɛ̱na̱: “Dá̱ t'øde te da̱ ma̱n'a̱ n'na nc'ɛ̱i̱ da̱ ma̱nna̱ hya̱ p'ʉ ja ra̱ da̱po ngue da̱ 'yɛ̱na̱: Da̱mi̱ jua̱nnba̱hʉ rá̱ 'yu̱ ra̱ Hmu̱. Da̱mi̱ cähmʉ ra̱ 'yu̱ da̱ gohi xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Da̱ ma ma̱jua̱nni̱ gätho yø nenhäi. Da̱ ma ma̱ni̱hibi gätho yø nyu̱ni̱ 'nɛ̱hyø nguani̱. Da̱ ma ma̱jua̱nni̱'ʉ yø 'yu̱ xa̱mpäni̱. Nu̱'ʉ yø 'yu̱ xa̱nts'oni̱, da̱ ma ma̱jua̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Gä da̱ nu̱ yø ja̱'i̱'a̱ ra̱ Ya̱nte da̱ pɛn'Oja̱”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nu̱'ʉ yø ja̱'i̱ bi zøp'ʉ mi̱ 'bʉhra̱ Xuua ngue di xixya̱bi̱. Ra̱ Xuua bi 'yɛ̱mbi̱: ―Guí øthʉ tengu̱tho øtyø c'ɛ̱ya̱ ngue 'da'mø bá̱ ɛ̱p'ʉ ra̱ sibi. Xiya, ¿hague gni̱ pa̱hmʉ ngue bá̱ ɛ̱p'ʉ ra̱ nda̱te castigo di̱ nja? ");
INSERT INTO otnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Da̱mi̱ 'yøthʉ ra̱ nho, n'namhma̱ di̱ nɛ̱qui̱ ngue ya gá̱ hyɛhmʉ p'ʉ ra̱ nts'o. 'Yo sä guí ɛ̱na̱ ngue ya hi̱nte gui jahʉ ngue yø mbom'mɛto'a̱hʉ ra̱ Abraham. Porque dí xi'a̱hʉ ngue nu̱ua ja yø do ja ua, da̱ zä da̱ 'yøt'Oja̱ ngue da̱ bøcua yø mbom'mɛto ra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Guí øthʉ tengu̱tho yø za hi̱ngui̱ zʉdi, gui̱ njathʉ p'ʉya. Pɛ ya ja ra̱ acha da̱ 'yɛxyø za. Gätho yø za hi̱ngui̱ nne di̱ nzʉdi, da̱ t'ɛts'i ngue da̱ ma nt'u̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yø ja̱'i̱ p'ʉya, bi 'yänna̱ Xuua, bi 'yɛ̱mbi̱: ―¿Teni̱ 'bɛ'a̱ ja ngue ga̱ øt'ähe p'ʉya? ");
INSERT INTO otnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bi 'yɛ̱nna̱ Xuua p'ʉya: ―Nu̱'a̱ ca̱ yoho yø pahni̱, ja ngue di u̱nna̱ n'na mpahni̱'a̱ to hi̱n'yʉ rá̱ pahni̱. Nu̱'a̱ ja te da̱ zi, ja ngue da̱ xɛpi to hi̱n'yʉ da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xquet'a̱ bi zø i'da yø ngʉthäi p'ʉya, ngue nne da̱ ma ma̱xixya̱bi̱. Bi 'yørpa̱ ra̱ nt'änni̱ ra̱ Xuua p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ¿te 'bɛ'a̱ ja ngue ga̱ øt'ähe? ");
INSERT INTO otnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ra̱ Xuua bi 'yɛ̱mbi̱: ―'Yo di tho'a̱ guí jʉhmʉ ngue'a̱ te di̱ marca ra̱ ley. ");
INSERT INTO otnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Xquet'a̱ 'nɛ̱ 'da yø soldado bi 'yørpa̱ ra̱ nt'änni̱, bi 'yɛ̱mbi̱: ―Xigähe, ¿teni̱ 'bɛ'a̱ ja ngue ga̱ øt'ähe? Mi̱ da̱hra̱ Xuua, bi 'yɛ̱mbi̱: ―'Yo to ga̱di pihmʉ. 'Nɛ̱ 'yo te guí ha̱nnba̱hʉ yø ja̱'i̱. 'Yo sä ga̱di ya̱phʉ n'na ra̱ ja̱'i̱ ngue hi̱nte øt'e. Ya da̱ hønt'a̱ te ni̱ nzäbi guí ta̱ha̱ gui hya̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pɛ yø ja̱'i̱, hi̱ngui̱ nnu̱ ra̱ pa da̱ ba̱di̱ te'o na̱ ra̱ Xuua. Ɛ̱nyø ja̱'i̱ ngue nu̱na̱ ra̱ Xuua, xa̱mhma̱tho guehna̱ ra̱ Cristo bá̱ pɛn'Oja̱ ngue di̱ nda̱st'abi na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pɛ ra̱ Xuua bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱gä ma̱jua̱ni̱ da̱di xixya̱'a̱hʉ conna̱ dehe. Pɛ bá̱ ɛ̱p'ʉ ma̱n'na da̱ 'yøtra̱ nxixya̱ conna̱ sibi 'mø bi ha̱'a̱hʉ ra̱ ts'ɛdi ra̱ Espíritu Santo. A nu̱na̱, ma̱n'na ta̱te na̱ ngue nu̱gä. ¿Hapʉ gue ga̱ sʉcä tengu̱ na̱? ");
INSERT INTO otnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Guehna̱ da̱ huanhyø ja̱'i̱ na̱, tengu̱tho 'mø ma̱hoqui ra̱ trigo, n'nani̱ ni̱ ma yø xi. Ra̱ trigo p'ʉya, ma̱pɛti ngue da̱ 'bɛts'i. Nu̱'a̱ rá̱ xi p'ʉya, da̱ t'u̱p'ʉ ja ra̱ sibi hi̱nja̱m'mø da̱ huɛ̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Xa̱ngu̱ mi̱'da yø hya̱ bi̱ ma̱nna̱ Xuua ngue honi̱ ha gui opa̱n'yu̱ yø ja̱'i̱ di øtra̱ hoga̱ 'da'yo hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bi hɛjpa̱bi̱ ra̱ Xuua'a̱ te xi 'yøtra̱ da̱st'abi Herodes, porque nu̱na̱ rá̱ 'bɛpo Herodías rá̱ xisu'a̱ rá̱ n'yohʉ Lipe, ya xi 'yøt'e ngue rá̱ xisu. Xquet'a̱ xa̱ngu̱ mi̱'da yø hya̱ xa̱nts'o xi 'yøt'e, pɛ gä bi hɛjpi. ");
INSERT INTO otnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pɛ ma̱hømbi 'yør'ma̱n'na ra̱ nts'o ra̱ Herodes, ngue bi got'a̱ fädi ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nu̱'mø tobe hi̱m ma̱ni̱ jotra̱ Xuua, bi xixya̱bi̱ gätho yø ja̱'i̱. Xquet'a̱ bi xixya̱bi ra̱ Jesús. Mɛ̱nte mmat'Oja̱ p'ʉya, bi xohra̱ c'ama̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nu̱'a̱ ra̱ Espíritu Santo, ɛ̱ntho n'na ra̱ paloma p'ʉ i hnu̱, ngue bi zøp'ʉ ja rá̱ ya̱ ra̱ Jesús. 'Nɛ̱ bi t'ø'a̱ n'na ra̱ hya̱ bá̱ nya̱ ma̱hɛ̱ts'i̱, bi 'yɛ̱na̱: ―Gue'e ma̱ Ts'ʉnt'ʉ, da̱di̱ ma̱'i̱. A nu̱yá, ja̱njua̱ni̱ ngue ja ga̱mpähä conná̱ ngue'e. ");
INSERT INTO otnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nu̱'mø mi̱ dʉ'mi̱ bi xännba̱bi̱ ra̱ hya̱ yø ja̱'i̱ ra̱ Jesús, ya mi̱ ha̱ 'däte ma̱'dɛt'a njɛya. I t'ɛ̱mbi̱ ngue rá̱ ts'ʉnt'ʉ ra̱ José. Pɛ nu̱'a̱ ɛrá̱ xita ra̱ Jesús, gue'a̱ ra̱ Elí. ");
INSERT INTO otnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nu̱ya mi̱'da yø mboxita ra̱ Jesús guehna̱: ra̱ Matat, ra̱ Leví, ra̱ Melqui, ra̱ Jana, ra̱ José, ");
INSERT INTO otnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ra̱ Matatías, ra̱ Amós, ra̱ Nahum, ra̱ Esli, ra̱ Nagai, ");
INSERT INTO otnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ra̱ Maat, ra̱ Matatías, ra̱ Semei, ra̱ José, ra̱ Judá, ");
INSERT INTO otnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ra̱ Joana, ra̱ Resa, ra̱ Zorobabel, ra̱ Salatiel, ra̱ Neri, ");
INSERT INTO otnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ra̱ Melqui, ra̱ Adi, ra̱ Cosam, ra̱ Elmodam, ra̱ Er, ");
INSERT INTO otnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ra̱ Josué, ra̱ Eliezer, ra̱ Jorim, ra̱ Matat, ");
INSERT INTO otnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ra̱ Leví, ra̱ Simeón, ra̱ Judá, ra̱ José, ra̱ Jonán, ra̱ Eliaquim, ");
INSERT INTO otnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ra̱ Melea, ra̱ Mainán, ra̱ Matata, ra̱ Natán, ");
INSERT INTO otnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ra̱ David, ra̱ Isaí, ra̱ Obed, ra̱ Booz, ra̱ Salmón, ra̱ Naasón, ");
INSERT INTO otnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ra̱ Aminadab, ra̱ Aram, ra̱ Esrom, ra̱ Fares, ra̱ Judá, ");
INSERT INTO otnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ra̱ Jacob, ra̱ Isaac, ra̱ Abraham, ra̱ Taré, ra̱ Nacor, ");
INSERT INTO otnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ra̱ Serug, ra̱ Ragau, ra̱ Peleg, ra̱ Heber, ra̱ Sala, ");
INSERT INTO otnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ra̱ Cainán, ra̱ Arfaxad, ra̱ Sem, ra̱ Noé, ra̱ Lamec, ");
INSERT INTO otnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ra̱ Matusalén, ra̱ Enoc, ra̱ Jared, ra̱ Mahalaleel, ra̱ Cainán, ");
INSERT INTO otnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ra̱ Enós, ra̱ Set, ra̱ Adán. Pɛ ra̱ Adán, Oja̱ bi hoqui. ");
INSERT INTO otnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nu̱na̱ ra̱ Jesús ya n'youi ra̱ Espíritu Santo, ma̱mbá̱ ɛ̱p'ʉ ja ra̱ da̱the Jordán. Ra̱ Espíritu Santo bi zixpʉ bí ja ra̱ da̱po. ");
INSERT INTO otnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ja bá̱ m'mʉp'ʉ nyote ma̱ pa. Pɛ nu̱'ʉ yø hya̱ di̱ ma̱nda Oja̱, ɛ̱mmɛ̱i̱ bi hyonna̱ zithu̱ ha di̱ mɛstho ra̱ hya̱ ra̱ Jesús. Nu̱'ʉ yø pa'ʉ, hi̱mbi̱ zi ra̱ hmɛ̱ ra̱ Jesús. M'mɛfa p'ʉya, bi zä ngue ma̱thoguitho tu̱ ma̱nthu̱hu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ra̱ zithu̱ p'ʉya bi 'yɛ̱mbi̱: ―Nu̱'mø ngue gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱, da̱mi̱ 'yøt'e ngue nu̱na̱ ra̱ do 'bɛngua, da̱ gohi di̱ nthu̱hmɛ̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbra̱ zithu̱: ―Nu̱p'ʉ ja ra̱ Ma̱ca̱ Libro, nt'ot'i p'ʉ ra̱ hya̱ ngue ɛ̱na̱: “Nu̱ ra̱ ja̱'i̱ hi̱nda̱ ne da̱ 'yøde te mma̱n'Oja̱, ma̱da̱gue'a̱ da̱ zi ra̱ hmɛ̱ ra̱ ja̱'i̱, pɛ ya hi̱nda̱ zä di̱ m'mʉi”. ");
INSERT INTO otnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ra̱ zithu̱ p'ʉya bi zixpʉ bí ja n'na ra̱ da̱nyu̱ni̱. Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi japra̱ Jesús ngue bi hyandi̱ gätho yø nación i ja rá̱ ngʉni̱ nxi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ra̱ zithu̱ bi 'yɛ̱mbra̱ Jesús: ―Nu̱gä dí ɛ̱xa̱'i̱ ngue gui̱ nda̱st'abi, gui̱ ma̱nda gätho yø nación. Nu̱ te gä pɛts'i, gä ni̱ mmɛti. Porque go bi̱ ndäcä yʉ. Nu̱ te'o ga̱ nne ga̱ u̱nni̱, ga̱ u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nu̱'mø gui̱ nda̱ntyøhmu̱ ngue gui tha̱nnegui ya, nu̱ te gä ja nʉya, gä ni̱ mmɛti ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'uegue grá̱ zithu̱. Porque nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue hønt'a̱ ra̱ Hmu̱ Oja̱ ja ngue da̱ ma ntha̱nne, hi̱njom ma̱n'na. ");
INSERT INTO otnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","M'mɛfa p'ʉya, nu̱p'ʉ ja ra̱ hni̱ni̱ Jerusalén, ja i zixpʉ ra̱ zithu̱ na̱ ra̱ Jesús. Bi̱ ntøp'ʉ ja rá̱ 'bet'e ra̱ ni̱ja̱. Bi 'yɛ̱mbi̱: ―Nu̱'mø gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱ ya, da̱mi̱ nsäcua ya. ");
INSERT INTO otnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porque nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ra̱ hya̱ ngue ɛ̱na̱: “Nu̱na̱ Oja̱ da̱ pɛnhyø anxɛ ngue da̱ mä'i. ");
INSERT INTO otnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Da̱ 'yøt'e ngue njana̱te gdi søt'a̱ häi, n'namhma̱ ngue hi̱ndi̱ ʉn'na̱ ni̱ gua yø do” ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xquet'a̱ nt'ot'i ra̱ hya̱ p'ʉ ja ra̱ Ma̱ca̱ Libro ngue nu̱na̱ Oja̱, hi̱njonda̱ zännbi̱ te da̱ 'yøt'e para ngue da̱ fa̱di̱ ngue'mø ma̱jua̱ni̱ te mma̱ ogue hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ra̱ zithu̱, ya hi̱mbi̱ di̱nna̱ forma ha xti japi ngue xta̱ 'yøtra̱ ts'oqui ra̱ Jesús. Bi zop'ʉ njammi̱ pa p'ʉya, bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bi̱ mengra̱ Jesús, i̱ ma Galilea. Pɛ n'youi rá̱ ts'ɛdi ra̱ Espíritu Santo. Yø ja̱'i̱ p'ʉya, ndap'ʉ bi zä di c'a̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Da̱ zømp'ʉ da̱ zønna̱ Jesús, pap'ʉ ja yø ni̱ja̱ yø judío ngue xännba̱bi̱ ra̱ hya̱ yø ja̱'i̱. Gä nnu̱ ma̱nho yø ja̱'i̱ ra̱ hya̱ mma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bi̱ map'ʉ ja ra̱ hni̱ni̱ Nazaret bá̱ nte ra̱ Jesús. Mi̱ zøhra̱ pa ngue ra̱ ts'äya, bi̱ map'ʉ ja ra̱ ni̱ja̱, gä ngu̱'a̱ xi 'yørbʉ ja yø hni̱ni̱ xi thogui ngue pap'ʉ ja yø ni̱ja̱. Bi̱ m'mähra̱ Jesús ngue da̱ ma̱nna̱ letra nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro. ");
INSERT INTO otnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bi t'u̱nna̱ libro bi 'yotra̱ pønga̱hya̱ Isaías. Mi̱ xospʉya, bi̱ nthɛui p'ʉ nt'ot'i na̱ ra̱ hya̱ ja ua ngue ɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Dí̱ n'yogä'be ra̱ Espíritu Santo. Porque bá̱ t'ɛ̱xqui̱ ngue ga̱ xicä ra̱ hoga̱ 'da'yo hya̱ yø hyoya. Bá̱ 'bɛnngui̱ ngue ga̱ hojpa̱ yø mmʉi yø ja̱'i̱ 'bʉ ndu̱mmʉi. Nu̱'ʉ yø ja̱'i̱ xa̱ mbɛnt'ui ra̱ ts'oqui, ga̱ xifi ngue ya da̱ ma nhya̱ni̱. Ga̱ xojpa̱ yø n'yomfɛ̱ni̱ yø ja̱'i̱ ngue da̱ ba̱ Oja̱. Ga̱ japi ngue ya hi̱nni̱ mantho da̱ zä ra̱ n'ʉ yø ja̱'i̱ di ʉnyø hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ga̱ xicä yø ja̱'i̱ ngue ya bi zønna̱ pa da̱ ya̱n'Oja̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mi̱ juadi bi̱ ma̱nna̱ letra nt'ot'i p'ʉ ja ra̱ sʉcua̱ ra̱ Jesús, bi dä ra̱ sʉcua̱ p'ʉya, bi u̱n'na̱ ra̱ mäxte p'ʉ ja ra̱ ni̱ja̱. Bi̱ mi̱ p'ʉya. Nu̱'ʉ yø ja̱'i̱ 'bʉp'ʉ ja ra̱ ni̱ja̱ p'ʉya, gä di zadi hɛ̱ti̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma̱hømbi̱ mʉdi bi̱ nya̱ ra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱ ra̱ ora ja p'ʉya, ya bi̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, ngue ni̱ hmi̱ ni̱ dä guí̱ nnu̱jʉ ngue dí 'bʉcä ua ya. ");
INSERT INTO otnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bi̱ nu̱ ma̱nho gätho yø ja̱'i̱ ra̱ Jesús. Nu̱na̱ ra̱ hoga̱ hya̱ xihyø ja̱'i̱, gä di 'yødyø ja̱'i̱ na̱ ra̱ hya̱ øde. Di̱ n'yänsɛ yø ja̱'i̱, di̱ n'yɛ̱mbi̱: ―¿Ua hi̱nga̱ guehna̱ rá̱ ts'ʉnt'ʉ ra̱ José na̱? ");
INSERT INTO otnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Rá̱ nzɛgui guehna̱ ra̱ hya̱ ja ua guí̱ nne gui xicjʉ, ngue ɛ̱na̱: “Ague grá̱ 'yøthe, 'be da̱mi̱ n'yøthe sɛ”. Gui̱ nne gui 'yɛ̱njʉ: “Nu̱'a̱ dí øcähe guá̱ ørbʉ Capernaum, nu̱ua ja ni̱ hni̱ni̱ ya, xquet'a̱ da̱ ngu̱'a̱ gui 'yøt'ua ya”, guí̱ nne gui 'yɛ̱njʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bi sigue bi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue hi̱nga̱ n'na ra̱ pønga̱hya̱ di pøni̱ ngue da̱ hnu̱ ma̱nsu̱ p'ʉ ja rá̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Njarbʉtho na̱ ra̱ hya̱ dí xi'a̱hʉ ya, tengu̱tho ra̱ pa bá̱ m'mʉhra̱ pønga̱hya̱ Elías, bi̱ nja ra̱ nda̱te thu̱hu̱ p'ʉ ja ra̱ häi mi̱ 'bʉi, ngue hi̱mbi̱ n'ye nhyu̱ jɛya ma̱de. Xa̱ngu̱ yø 'danxu̱ ngue yø judío mi̱ 'bʉ 'mø ya. ");
INSERT INTO otnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pɛ hi̱nga̱ n'na'ʉ yø 'danxu̱ ngue yø judío xta̱ mmɛnnba̱bi̱ Oja̱ ra̱ Elías ngue xta̱bá̱ mmäts'i. Sinoque bi 'bɛnhni̱ ngue bá̱ fäxa̱ n'na ra̱ 'danxu̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Sarepta, querpʉtho ra̱ hni̱ni̱ Sidón. ");
INSERT INTO otnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nu̱'a̱ ra̱ tiempo bi̱ m'mʉhra̱ pønga̱hya̱ Eliseo, xa̱ngu̱ yø judío mi̱ hɛ̱mbra̱ n'ʉ ngue mi̱ 'ya yø do'yo. Pɛ hi̱njombi̱ 'yøthe ya yø judío mi̱ ʉ. A nu̱na̱ ra̱ Naamán ngue ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ häi Siria, go bi̱ ma bá̱ øthe na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Gä bi̱ mbøcuɛ yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ ni̱ja̱ 'mø mi̱ 'yøhya yø hya̱ bi̱ ma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bi̱ nangyø ja̱'i̱ p'ʉya, bi bɛntra̱ Jesús ngue bi gʉjpʉ ja ra̱ hni̱ni̱. Bi zixpʉ bí ja ra̱ nya̱ngua̱ni̱ ngue da̱ hørbʉ ja ra̱ t'øhø. ");
INSERT INTO otnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pɛ bi gua̱syø ja̱'i̱ ra̱ Jesús, bi thop'ʉ ma̱de, bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nu̱na̱ ra̱ Jesús, i̱ map'ʉ ja ra̱ hni̱ni̱ Capernaum ngue ra̱ häi Galilea. Nu̱'mø ra̱ pa ngue ra̱ ts'äya, nhya̱to, nhya̱to pap'ʉ ja ra̱ ni̱ja̱ ngue xännba̱ ra̱ hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Di 'yødyø ja̱'i̱'a̱ ra̱ hya̱ xännba̱bi̱, porque nu̱'mø xännba̱te ra̱ Jesús, ɛ̱na̱ nts'ʉt'abitho ngue ya̱ ma̱nzaqui 'mø nzohyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nu̱p'ʉ ja ra̱ ni̱ja̱ p'ʉya, mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ n'youi ra̱ ts'onthi̱. Nts'ɛdi i zohra̱ Jesús, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ague Jesús grá̱ mmɛ̱ngu̱ Nazaret, da̱mi̱ hyɛga̱he p'ʉ. ¿Hanja ngue ga̱di̱ nthi̱nt'ua dí 'bʉcähe? ¿Ua gní̱ 'yɛ̱hɛ̱ gui juacje? Nu̱gä dí pa̱di̱ te'o'i, gue'e rá̱ ma̱ca̱ Ts'ʉnt'ʉ'i Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pɛ ra̱ Jesús bi 'yɛ̱mbra̱ ts'onthi̱: ―Xa̱nhɛ̱n'i̱ grá̱ ts'onthi̱. Da̱mi̱ hyɛp'ʉ ra̱ n'yohʉ guí̱ n'youi. Ra̱ ts'onthi̱ p'ʉya, yø hmi̱ yø dä yø ja̱'i̱ p'ʉ bi 'yɛn'a̱häi ra̱ n'yohʉ. Pɛ hi̱nha bi zɛt'i. Bi̱ ma ra̱ ts'onthi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Gä di 'yødyø ja̱'i̱ bi̱ nu̱ te bi̱ nja. Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na: ―Hi̱njongui̱ pa̱di̱ tema̱ hya̱'a̱ ya. Di̱ nɛ̱qui̱ ngue ja rá̱ ts'ɛdi na̱ ra̱ n'yohʉ, porque asta̱ 'nɛ̱hyø ts'onthi̱ ɛ̱c'ɛ̱i̱ 'mø xifi ngue da̱ hyɛp'ʉ ra̱ ja̱'i̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ndap'ʉ bi zä di c'a̱ yø ja̱'i̱ te øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","I̱ map'ʉ ja rá̱ ngu̱ ra̱ Simu̱ 'mø ma̱mbá̱ pøn'a̱ ni̱ja̱ ra̱ Jesús. Mi̱ hɛ̱mbra̱ pa na̱ rá̱ to ra̱ Simu̱ p'ʉya. Bi t'äpra̱ ma̱te ra̱ Jesús ngue bi 'yøthe na̱ ra̱ xisu ma̱di̱ hyɛ̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nu̱na̱ ra̱ Jesús bi̱ ndojpʉ 'bɛnna̱ därqüɛ̱hi̱. Bi hɛjpa̱ ra̱ pa, pɛ 'bexpi bønna̱ pa. Bi̱ nangra̱ xisu ngue bi hojpi te da̱ zi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mi̱ dähra̱ nde p'ʉya, gätho yø ja̱'i̱ si yø därquɛ̱hi̱ ngue hɛ̱mbi̱ 'dama̱ 'dan'yo ma̱n'ʉ, bi zispa̱bi̱ ra̱ Jesús ngue da̱ 'yøthe. Bi japyø därquɛ̱hi̱ yø 'yɛ ra̱ Jesús ngue bi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'Bʉp'ʉ xa̱ngu̱ yø därquɛ̱hi̱ ngue n'youi yø ts'onthi̱, pɛ ra̱ Jesús bi japyø ts'onthi̱ ngue hɛp'ʉ yø ja̱'i̱ n'youi. Asta̱ mahyø ts'onthi̱, i ɛ̱na̱: ―Nu̱'i̱, gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱. Pɛ ra̱ Jesús di hɛjpa̱ yø ts'onthi̱, hi̱ndi̱ japi di̱ nya̱. Porque nnepyø ts'onthi̱ da̱ fa̱di̱ ngue gue'a̱ ra̱ Cristo. ");
INSERT INTO otnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mi̱ nɛ̱ca̱häi p'ʉya, bi bømp'ʉ ja ra̱ hni̱ni̱ ra̱ Jesús, bi̱ ma da̱po. Pɛ ɛ̱mmɛ̱i̱ honyø ja̱'i̱ hapʉ 'bʉi. Mi̱ zønyø ja̱'i̱ p'ʉ bí 'bʉi, i sa̱mmi̱, hi̱ngui̱ nnepe xta̱ nzop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pɛ ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Jatho ngue ga̱ mma ma̱ngä ra̱ hoga̱ 'da'yo hya̱ mi̱'da yø hni̱ni̱. Porque guehna̱ bi 'bɛnngä na̱ ngue ga̱ xihyø ja̱'i̱ ha di̱ njap'ʉ da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ja̱na̱ngue gä bá̱ n'yop'ʉ ja ra̱ häi Galilea ra̱ Jesús ngue bi̱ ma̱nna̱ hya̱ p'ʉ ja yø ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nu̱p'ʉ ja ra̱ nenzabi ni̱ hu̱ ngue Genesaret, ja 'bäp'ʉ n'na pa ra̱ Jesús. Bi zøhø xa̱ngu̱ yø ja̱'i̱ p'ʉya, asta̱ di̱ ntøt'e ngue nne da̱ 'yørpa̱bi̱ rá̱ hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bi̱ nu̱ yoho yø barco p'ʉ ja ra̱ nenzabi ra̱ Jesús, ngue hi̱njongui̱ o. Ya xi bønyø mahua̱ ngue petyø xit'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bi yʉrbʉ ja rá̱ barco ra̱ Bɛdu ra̱ Jesús. Bi xi p'ʉya ngue da̱ zoquits'ʉ ra̱ nnengui̱, di̱ map'ʉ xa̱nhɛ̱ ra̱ dehe. Bi̱ mi̱p'ʉ ja ra̱ barco ra̱ Jesús ngue ja bá̱ nya̱ p'ʉ, ngue bi xännba̱ ra̱ hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mi̱ juadi bi̱ ma̱n'a̱ ra̱ hya̱ nne da̱ ma̱mp'ʉya, bi 'yɛ̱mbra̱ Bɛdu: ―Da̱mi̱ 'yonna̱ barco, di̱ manʉ xa̱nhɛ̱ ra̱ dehe. Ja gui 'yɛnt'ui nʉ ra̱ xit'a̱ ngue gui paui yø hua̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bi 'yɛ̱nna̱ Bɛdu p'ʉya: ―Ague grá̱ xännba̱te, ya xtá̱ mmpɛhme gä ra̱ xu̱i̱, pɛ hi̱n teni̱ hua̱ xtá̱ thɛhe. Pɛ ngue guí ɛ̱ngui̱ ga̱ ɛnt'ä ra̱ xit'a̱, ma ga̱ ɛnt'ä ra̱ xit'a̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mi̱ 'yɛntra̱ xit'a̱ p'ʉya, xa̱ndøngu̱ yø hua̱ bá̱ thɛ, asta̱ ya nne xta̱ xɛtra̱ xit'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bi 'yørpa̱bi̱ ra̱ senya'ʉ yø n'yohʉ bí o ma̱n'na ra̱ barco ngue bá̱ ɛ̱hɛ̱, da̱ mäts'i. Bá̱ ɛ̱'ʉ p'ʉya, pɛ bi yu̱ts'i̱ gä yoho yø barco'ʉ yø hua̱, asta̱ ya nne da̱ thu̱nt'a̱ mbonthe yø barco ngue'a̱ ga̱nhyʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mi̱ nu̱ ra̱ Bɛdu'a̱ te bi̱ nja, bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, da̱mi̱ 'uecua dí 'bʉcä, porque ja ma̱ ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ngu̱na̱ bi̱ ma̱nna̱ Bɛdu, porque bi̱ nsu̱. Xquet'a̱ 'nɛ̱'ʉ yø n'yohʉ bi̱ nsu̱ 'mø mi̱ nu̱ ngue xa̱ndøngu̱ yø hua̱ bi dɛ. ");
INSERT INTO otnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Xquet'a̱ bi̱ nsu̱ ra̱ Jacobo 'nɛ̱hra̱ Xuua, yø ts'ʉnt'ʉ ra̱ Zebedeo, gä mi̱ n'youi ra̱ Bɛdu. Pɛ ra̱ Jesús bi 'yɛ̱mbra̱ Bɛdu: ―'Yo guí su̱ ague Bɛdu. Nu̱ya hi̱nni̱ mantho gui thɛhyø hua̱ ya, yø ja̱'i̱ gui thɛya ngue gui 'bärpa̱ yø mmʉi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bi sønna̱ nenthe'ʉ yø barco p'ʉya, bi zop'ʉ yø barco ngue bi dɛnna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ya mi̱ 'bʉp'ʉ ja n'na ra̱ hni̱ni̱ ra̱ Jesús. Bi zøn'a̱ n'na ra̱ n'yohʉ p'ʉ ha 'bʉi, ngue mi̱ hɛ̱mbra̱ ts'o'ya. Mi̱ nu̱ ra̱ Jesús, asta̱ bi̱ m'mɛmfo häi ngue äpra̱ ma̱te, bi 'yɛ̱mbi̱: ―Ague grá̱ hmu̱, nu̱'mø guí̱ nne gui 'yørca̱ ra̱ ma̱te gui 'yøtheguits'ʉ, nu̱gä dí pa̱di̱ ngue da̱ zägui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bi dosra̱ därquɛ̱hi̱ conná̱ 'yɛ ra̱ Jesús, bi 'yɛ̱mbʉya: ―A̱há̱, dí̱ nne ga̱ øthe'i. Da̱ zä'i ya ―bi 'yɛ̱mbi̱. Høntho bi̱ ma̱nna̱ ra̱ hya̱ na̱, nu̱na̱ ra̱ därquɛ̱hi̱ mi̱ 'ya rá̱ do'yo, 'bexpi zä ra̱ n'ʉ mi̱ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nu̱na̱ ra̱ Jesús, bi 'bɛpi ngue hi̱njonda̱ xifi te bi japi, bi 'yɛ̱mbi̱: ―Høntho ni̱ ma ya, sømp'ʉ 'bʉhra̱ mmäcja̱. Da̱ nu̱ ngue ya bi zä'i. Da̱mi̱ 'yøtra̱ 'bøt'e tengu̱tho bi̱ ma̱nda ra̱ Moisés ngue da̱ 'yøtyø ja̱'i̱ 'mø bi zä ra̱ 'ya hɛ̱mbi̱. Ja̱na̱ngue da̱ ba̱di̱ gätho yø ja̱'i̱ ngue ya bi zä'i. ");
INSERT INTO otnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pɛ nu̱'a̱ ga̱ 'yo ra̱ hya̱ te øtra̱ Jesús, ma̱n'na, ma̱n'na ni̱ fa̱di̱. Xa̱ndøngu̱ yø ja̱'i̱ di̱ mpɛti p'ʉ ha ni̱ ma ngue øxra̱ hya̱ i̱ mma̱. I̱ nne yø ja̱'i̱ da̱ 'yøthebi hapʉ xa̱n'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pɛ mi̱ pa da̱po ra̱ Jesús ngue ja bi̱ mmat'Oja̱ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nu̱p'ʉ mi̱ xännba̱te n'na pa ra̱ Jesús, hu̱p'ʉ 'da yø fariseo, hu̱p'ʉ 'da yø xännba̱te ngue ra̱ ley. Xpi 'yɛ̱p'ʉ ja yø hni̱ni̱ ja'a̱ ra̱ häi Galilea, 'nɛ̱p'ʉ ja yø hni̱ni̱ ja'a̱ ra̱ häi Judea, 'nɛ̱p'ʉ Jerusalén xpi 'yɛ̱ i'da. Pɛ n'youi rá̱ ts'ɛdi Oja̱ na̱ ra̱ Jesús ngue sä øthe yø därquɛ̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bi zø i'da yø ja̱'i̱ bá̱ du̱ n'na ra̱ därquɛ̱hi̱ ngue tu̱dyø gua, bá̱ oxrá̱ fi̱di̱. Bi̱ ne yø ja̱'i̱ ngue xti thocra̱ därquɛ̱hi̱ p'ʉ brá̱ 'bähra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pɛ hi̱mbi̱ zä ha xti yʉt'i, porque hi̱nga̱ nzäni̱ yø ja̱'i̱. Bi tets'a̱ ya̱nni̱gu̱ p'ʉya, bi xots'a̱ n'na xɛqui ra̱ 'bet'e. Ja i ca̱mbʉ ra̱ därquɛ̱hi̱ ni̱ oxrá̱ fi̱di̱. Bi zørbʉ 'bʉhyø ja̱'i̱ brá̱ 'bähra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mi̱ nu̱ te øtyø ja̱'i̱ na̱ ra̱ Jesús, i pa̱di̱ ngue ɛ̱c'ɛ̱i̱ yø ja̱'i̱ ngue da̱ zä da̱ 'yøthe ra̱ därquɛ̱hi̱. Bi 'yɛ̱mbra̱ därquɛ̱hi̱ p'ʉya: ―Ague n'yø, ya dá̱ pu̱n'na̱ ni̱ ts'oqui ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yø xännba̱te ngue ra̱ ley p'ʉya, 'nɛ̱hyø fariseo, bi 'yɛ̱mp'ʉ ja yø n'yomfɛ̱ni̱: “¿Te go ma̱ngu̱ na̱ ra̱ n'yohʉ na̱, i then'na̱ Oja̱ na̱ ngue ngu̱'a̱ mma̱? Porque hi̱njonda̱ zä di pu̱nnba̱ yø ts'oqui yø ja̱'i̱, hi̱nda̱ hønt'a̱ Oja̱ sä ngue da̱ 'yøtra̱ mpu̱nnbi̱”, ɛ̱mp'ʉ ja yø n'yomfɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pɛ ra̱ Jesús i pa̱tho te mbɛ̱nyø ja̱'i̱ mbøcuɛ, bi 'yɛ̱mbi̱: ―¿Hanja ngue ngu̱na̱ guí̱ mbɛ̱mhmʉ? ");
INSERT INTO otnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nu̱gä dá̱ xihra̱ n'yohʉ 'bʉcua, dí ɛ̱mbi̱: “Ya dá̱ pu̱n'na̱ ni̱ ts'oqui ya”. Pɛ nu̱yá, hi̱ndi̱ nɛ̱qui̱ xa̱nho ngue'mø bi̱ mpu̱nnbi̱ ogue hi̱n'na̱. Pɛ nu̱'mø ga̱ ɛ̱mbi̱: “Da̱mi̱ nangui̱, gui ca̱xni̱ fi̱di̱, gui̱ mma”, ga̱ ɛ̱mbi̱, nu̱'mø ngue bi̱ n'yo p'ʉya, ya gui pa̱hmʉ xa̱nho ngue ja ma̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","A nu̱yá, da̱mi̱ pa̱hmʉ ya ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ja rá̱ ts'ɛdi ua ja ra̱ xi̱mhäi ngue di pu̱nnba̱ yø ts'oqui yø ja̱'i̱. Bi 'yɛ̱mbra̱ n'yohʉ xa̱n'ʉ p'ʉya: ―Nu̱gä dí xi'i, da̱mi̱ nangui̱, ca̱xni̱ fi̱di̱, ni̱ ma ni̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Bexque'a̱ p'ʉya, nu̱na̱ ma̱rá̱ därquɛ̱hi̱, yø hmi̱ yø dä yø ja̱'i̱ p'ʉ bi̱ nangui̱, bi ga̱xra̱ fi̱di̱, bi̱ ma rá̱ ngu̱. Pɛ di ja ma̱mma̱di̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Gä di 'yødyø ja̱'i̱'a̱ te bi̱ nja, pɛ gä ɛ̱spa̱bi̱ Oja̱ yø ja̱'i̱. Asta̱ nsu̱ ha ga̱ 'yɛ̱nyø ja̱'i̱: ―A nu̱yá, dá̱ nu̱hʉ yø cosa ngue hi̱nja̱m'mø xtá̱ nu̱hʉ ya ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mi̱ ma m'mɛfa ra̱ Jesús, ni̱ nthop'ʉ ja rá̱ oficina ra̱ Leví, nu̱na̱ jʉmba̱ ra̱ mɛ̱nyu̱ yø ja̱'i̱ ja te pä. Mi̱ nu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma ga̱ mmɛ n'yø, ga̱ øt'e ngue ma̱ xädi'i ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bi zop'ʉ rá̱ oficina ra̱ Leví ngue bi̱ mɛ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nu̱p'ʉ ja rá̱ ngu̱ ra̱ Leví, bi 'yørpa̱bi̱ n'na ra̱ da̱nts'i̱hmɛ̱ ra̱ Jesús. Nu̱p'ʉ ja ra̱ mɛ̱xa 'dap'ʉ 'bʉhmʉ mi̱'da yø ngʉthäi, da̱ guehmi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pɛ yø fariseo 'nɛ̱hyø xännba̱te ngue ra̱ ley bi zʉmba̱ yø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hanja ngue 'dap'ʉ guí si̱hmɛ̱hʉ yø ngʉthäi 'nɛ̱hyʉ mi̱'da yø ja̱'i̱ ja xa̱ngu̱ yø ts'oqui? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱ya yø ja̱'i̱ di hyɛ̱nni̱, guehya ni̱ 'yɛ̱hra̱ 'yøthe ya. Pɛ yø ja̱'i̱ xa̱nzaqui, hi̱nga̱ gue'ʉ ni̱ 'yɛ̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A nu̱gä, dá̱ ɛ̱hɛ̱ ngue gue'ʉ yø ja̱'i̱ ja yø ts'oqui ga̱ xifi da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo, hi̱nga̱ gue'ʉ yø ja̱'i̱ ɛ̱na̱ ngue ya 'yo xa̱nho dá̱ ɛ̱hɛ̱ ga̱ nzofo. ");
INSERT INTO otnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yø ja̱'i̱ p'ʉya, bi 'yɛ̱mbra̱ Jesús: ―¿Hanja ni̱ xädi ngue za̱nt'a̱ si'a̱ te ti̱ni̱? Conque yø xädi ra̱ Xuua 'nɛ̱hyø fariseo ɛ̱mmɛ̱i̱ ɛtyø mmʉi, 'nɛ̱ ɛ̱mmɛ̱i̱ mmat'Oja̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱'ʉ yø ja̱'i̱ ts'ofo ngue da̱ nu̱ ra̱ ntha̱ti̱, hi̱ngui̱ ɛtyø mmʉi mɛ̱nte 'dap'ʉ 'bʉhmʉ ra̱ novio. Njarbʉtho ma̱ xädigä ya, hi̱ngui̱ ɛtyø mmʉi ngue 'daua dí̱ n'yo'be. ");
INSERT INTO otnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pɛ bá̱ ɛ̱p'ʉ ra̱ pa ngue da̱ ziga̱gui̱ ma̱ nsʉi'be. Nu̱'a̱ ra̱ pa'a̱ p'ʉya, mfa̱di̱ ngue da̱ zä da̱ 'yɛtyø mmʉi ya ma̱ xädi 'mø. ");
INSERT INTO otnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hømbi hyɛcra̱ hya̱ bi xihyø ja̱'i̱. Bi xifi ngue ra̱ 'da'yo xädi, hi̱nga̱ 'da'igu̱ui ra̱ nyogui xädi. Bi 'yɛ̱mbi̱: ―Hi̱nda̱ zä to da̱ hyɛca̱ n'na xɛqui ra̱ 'da'yo u̱lu ngue da̱ møtra̱ nyon'u̱lu. A nu̱'mø ngue da̱ japi, di̱ ts'onna̱ 'da'yo u̱lu. Ra̱ 'da'yo xɛn'u̱lu hi̱ndi̱ nɛ̱jma̱nho ngue di bøtra̱ nyon'u̱lu. ");
INSERT INTO otnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tengu̱tho ra̱ 'da'yo vino hi̱ngui̱ sä da̱ sirbʉ ja ra̱ zɛxfani̱ ngue da̱ zɛdi. Porque ra̱ 'da'yo vino da̱ xɛtra̱ zɛxfani̱ 'mø da̱ sit'i, ja di̱ m'mɛp'ʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ja̱na̱ngue ra̱ 'da'yo vino, ra̱ 'da'yo xifani̱ da̱ sit'i, n'namhma̱ ngue gä yoho hi̱ndi̱ m'mɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nu̱'ʉ si ra̱ nyogui vino, hi̱njongui̱ pøni̱ ngue di̱ nne ra̱ 'da'yo vino, porque i ɛ̱na̱: “Xa̱ndønho dra̱ nyogui vino”. ");
INSERT INTO otnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","N'na ra̱ pa ngue säya yø ja̱'i̱, bi thop'ʉ ja n'na ra̱ nua̱trigo ra̱ Jesús, ni̱ n'youi yø xädi. Nu̱'ʉ yø xädi p'ʉya, bi daxtyø trigo ngue sa. ");
INSERT INTO otnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nu̱ 'da yø fariseo p'ʉya, bi 'yɛ̱mbi̱: ―¿Hanja ngue ga̱di̱ mpɛhmʉ? Conque mma̱mp'ʉ ja ra̱ ley ngue nu̱'mø ra̱ pa ngue ra̱ ts'äya, hi̱ngui̱ sä to di̱ mpɛfi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xi'mø mi̱ zʉhra̱ thu̱hu̱ n'na ndi̱ ra̱ David, co 'nɛ̱'ʉ mi̱ n'youi, ¿ua hi̱nja̱m'mø ga̱di xähmʉ p'ʉ ha nt'ot'i'a̱ te bi 'yøt'e? ");
INSERT INTO otnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nu̱na̱ ra̱ David bi yʉrbʉ ja rá̱ ngu̱ Oja̱ ngue bi zi yø thu̱hmɛ̱ xi t'ʉspa̱bi̱ Oja̱ ngue da̱ nu̱. Bi zi ra̱ David co 'nɛ̱'ʉ mi̱ n'youi. Conque nu̱'ʉ yø thu̱hmɛ̱'ʉ, hi̱ndi̱ u̱nna̱ nt'ɛ̱di̱ ra̱ ley ngue to bi zä da̱ zi, hi̱nda̱ høndyø mmäcja̱ yø ts'i'ʉ yø thu̱hmɛ̱ t'ʉspa̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma̱hømbi 'yɛ̱mbi̱: ―Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ja rá̱ ts'ɛdi ngue nu̱'a̱ go da̱ zänni̱, gue'a̱ di̱ nja'mø ra̱ pa ngue ra̱ ts'äya'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma̱n'na ra̱ pa ngue ra̱ ts'äya p'ʉya, nu̱na̱ ra̱ Jesús bi yʉrbʉ ja ra̱ ni̱ja̱ ngue bi̱ nxännba̱te ra̱ hya̱. Mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ xi 'yotrá̱ 'yɛ ngue rá̱ n'yɛi. ");
INSERT INTO otnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nu̱'ʉ yø xännba̱te ngue ra̱ ley 'nɛ̱'ʉ yø fariseo p'ʉya, tøjtho te øtra̱ Jesús. I̱ nne da̱ nu̱ 'mø ngue di̱ n'øthe 'mø ra̱ pa ngue ra̱ ts'äya, para ngue da̱ zäp'ʉ di̱ ya̱pi̱, da̱ 'yɛ̱mbi̱ ngue hi̱ngui̱ su̱pra̱ ley. ");
INSERT INTO otnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nu̱na̱ ra̱ Jesús ya pa̱tho te mbɛ̱nnba̱bi̱ yø ja̱'i̱. Ja̱na̱ngue bi 'yɛ̱mbra̱ n'yohʉ xi 'yotrá̱ 'yɛ: ―Bá̱ nangui̱ n'yø, ga̱ 'bäcua ma̱de ―bi 'yɛ̱mbi̱. Nu̱na̱ ra̱ n'yohʉ p'ʉya, bi nangui̱, bi̱ m'mäp'ʉ sifi di̱ m'mäi. ");
INSERT INTO otnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱ya ga̱ øt'a̱hʉ n'na ra̱ nt'änni̱ ya. ¿Te 'bɛ'a̱ ma̱ hya̱ mma̱mp'ʉ ja ra̱ ley ja ngue ga̱ øthʉ 'mø ra̱ pa ngue ra̱ ts'äya? ¿Ga̱ øthʉ ra̱ nho, ogue ra̱ n'ʉ? ¿Da̱ t'øthe ra̱ ja̱'i̱ 'mø xa̱n'ʉ, ogue di̱ njapi da̱ du̱? ");
INSERT INTO otnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ra̱ Jesús bi hyɛ̱ti̱ gätho yø ja̱'i̱ di̱ mäts'i. Bi 'yɛ̱mbra̱ n'yohʉ mi̱'ʉ p'ʉya: ―Da̱mi̱ majni̱ 'yɛ ya ―bi 'yɛ̱mbi̱. Ra̱ n'yohʉ p'ʉya bi macrá̱ 'yɛ, pɛ 'bexpi zä rá̱ 'yɛ mi̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pɛ bi̱ mbøcuɛ'ʉ mi̱'da yø ja̱'i̱. Di̱ n'yänni̱ n'na ngu̱ n'na ngue te da̱ japra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mi̱ ma njammi̱ pa p'ʉya, bi̱ map'ʉ ja n'na ra̱ nyu̱ni̱ ra̱ Jesús ngue bá̱ mat'Oja̱. Bi haxa̱ mhmat'Oja̱ gä ra̱ xu̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mi̱ hyaxpʉya, bi zonhyø xädi ngue bi huanhni̱ 'dɛ'ma̱ yonc'ɛ̱i̱, i hu̱ti̱ ngue yø representante. ");
INSERT INTO otnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ja ua yø thu̱hu̱ ya yø n'yohʉ bi thanhni̱: ra̱ Simu̱ nu̱'a̱ ja ma̱n'na ra̱ thu̱hu̱ ngue i Bɛdu, ra̱ Andre rá̱ n'yohʉ na̱ ra̱ Bɛdu, ra̱ Jacobo, ra̱ Xuua, ra̱ Lipe, ra̱ Bartolomé, ");
INSERT INTO otnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ra̱ Mateo, ra̱ Toma, ra̱ Jacobo nu̱'a̱ rá̱ ts'ʉnt'ʉ ra̱ Alfeo, ra̱ Simu̱ nu̱'a̱ n'youi n'na 'bʉi yø ja̱'i̱ honi̱ ha di̱ mma̱ndasɛ p'ʉ ja yø häi, ");
INSERT INTO otnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ra̱ Judas nu̱'a̱ rá̱ n'yohʉ ra̱ Jacobo, 'nɛ̱hra̱ Judas Iscariote nu̱na̱ bi dä ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ra̱ Jesús bá̱ ɛ̱p'ʉ ja rá̱ hyo ra̱ nyu̱ni̱ ma̱mbi 'bʉi, bi zøp'ʉ xa̱njua̱ni̱, bá̱ n'youi yø xädi. Xa̱ngu̱ yø ja̱'i̱ mi̱ 'bʉp'ʉ bi zøhø, bá̱ nɛ̱xpʉ ja yø hni̱ni̱ ja'a̱ ra̱ häi Judea, ra̱ hni̱ni̱ Jerusalén, gä bá̱ ɛ̱hyø ja̱'i̱ 'bʉi gä rá̱ nnengui̱ ra̱ ja̱the ha ja yø hni̱ni̱ Tiro 'nɛ̱ Sidón. Di ho yø ja̱'i̱ da̱ 'yøxra̱ hya̱ mma̱nna̱ Jesús, 'nɛ̱ nne da̱ t'øthebi p'ʉ ha hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Xquet'a̱ bi t'øthe yø ja̱'i̱ ma̱di ʉnyø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Gätho yø ja̱'i̱, gä nne ngue da̱ dähra̱ Jesús, porque ja rá̱ ts'ɛdi ra̱ Jesús ngue nu̱'ʉ yø ja̱'i̱ thädi, gä sä ha hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Bi hyɛ̱tyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ra̱ mmɛ̱nthi̱ gá̱ nthɛhʉ ngue guí hyoyahʉ. Porque ya guí ohʉ rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ra̱ mmɛ̱nthi̱ gá̱ nthɛhʉ 'mø guí tu̱ma̱nthu̱hu̱hʉ. Porque Oja̱ da̱ 'yøt'e ngue gui ti̱ni̱ te gui sihʉ. Ra̱ mmɛ̱nthi̱ gá̱ nthɛhʉ 'mø guí zomhmʉ. Porque m'mɛfa di̱ nja'a̱hʉ mpähä ngue gui̱ nthehmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ra̱ mmɛ̱nthi̱ gá̱ nthɛhʉ 'mø nnu̱ ma̱n'ʉ'a̱hʉ yø ja̱'i̱ ngue guí tɛnhnʉ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱. Porque da̱ 'yɛ̱hra̱ pa da̱ zʉ'a̱hʉ yø ja̱'i̱, da̱ hyøn'a̱hʉ thi p'ʉ ha 'bʉi. Da̱ nu̱ ts'oc'ɛ̱i̱'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Da̱mi̱ johyahʉ, di̱ nja'a̱hʉ ra̱ ndøpähä'a̱ ra̱ pa'a̱, porque xa̱ngu̱ ni̱ nzäbihʉ bí ja ma̱hɛ̱ts'i̱. Xquet'a̱ bi̱ njarbʉ m'mɛt'o yø mboxita'ʉ yø ja̱'i̱'ʉ ya, bi̱ nu̱ ma̱n'ʉ byø pønga̱hya̱ Oja̱ xa̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pɛ huɛ̱ca̱te'ʉ ɛ̱na̱ ngue yø mmɛ̱mmɛti. Ya bi tho'a̱ ra̱ pähä xa̱nja mɛ̱nte ra̱ pa xa̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Huɛ̱ca̱te'ʉ ɛ̱na̱ ngue hi̱nte di 'bɛdi, porque di̱ ntu̱ma̱nthu̱hu̱. Huɛ̱ca̱te'ʉ ja mpähä ngue thede, porque da̱ 'yɛ̱hra̱ pa di̱ nzoni̱ ngue ra̱ du̱mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Huɛ̱ca̱te'a̱hʉ, 'mø gä nnu̱ ma̱nho'a̱hʉ yø ja̱'i̱. Mi̱ njarbʉtho'ʉ yø mboxita yø ja̱'i̱ ya, mi̱ nnu̱ ma̱nho te mi̱ øt'ui yø fɛhni̱ pønga̱hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Di xifi te'o gä øde te dí̱ mma̱, da̱mi̱ ma̱hni̱ nsʉihʉ. Da̱mi̱ 'yørpa̱hʉ ra̱ nho'ʉ gä nnu̱ ma̱n'ʉ'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Da̱mi̱ 'yäphʉ Oja̱ ngue di ja̱pi̱ to san'a̱hʉ. Da̱mi̱ marpa̱hʉ Oja̱'ʉ sʉ'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nu̱'mø to bi̱ mɛp'a̱ ni̱ hmi̱hʉ, da̱mi̱ u̱n ma̱n'na nguadi ni̱ hmi̱ ngue da̱ mɛ'mi̱. Nu̱'mø te'o da̱ ga̱n'na̱ ni̱ tu̱hu̱, 'nɛ̱hni̱ pahni̱ da̱mi̱ u̱nni̱ da̱ ga̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nu̱'mø te'o da̱ 'yä'a̱hʉ n'na ra̱ cosa, da̱mi̱ u̱nni̱. Nu̱ te'o da̱ ne ngue da̱ hya̱n'na̱'i̱'a̱ te ni̱ mmɛti, 'yo gui̱ mma̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tengu̱tho gni̱ ne ngue da̱ mäxa̱hʉ yø ja̱'i̱, da̱ ngu̱'a̱ gui 'yøthʉ, da̱mi̱ 'yørpa̱hʉ ra̱ 'bäxte mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","A nu̱'mø ngue hønt'ʉ di̱ ma̱'a̱hʉ ga̱di̱ ma̱hmʉ, ¿ndana̱ ra̱ nho di̱ nɛ̱qui̱ ngue guí øthʉ 'mø? Conque asta̱ yø ts'oc'ɛ̱i̱ njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nu̱'mø hønt'ʉ to øt'a̱hʉ ra̱ nho guí ørpa̱hʉ ra̱ nho, ¿ndana̱ ra̱ nho di̱ nɛ̱qui̱ ngue guí øthʉ 'mø? Porque xquet'a̱ 'nɛ̱'ʉ yø ts'oc'ɛ̱i̱ njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Xi'mø ja'a̱ ma̱cosa ga̱di hmi̱thʉ n'na ra̱ ja̱'i̱, 'nɛ̱ gui tø'mi̱ ngue xquet'a̱ di hmi̱'a̱hʉ, ¿ndana̱ ra̱ nho guí øthʉ 'mø? Porque xquet'a̱ njap'ʉ yø ts'oc'ɛ̱i̱ ngue di hmi̱ n'na ra̱ cosa, pɛ xi̱ mmi̱ tø'mi̱ ngue da̱ ma ma̱hmi̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pɛ nu̱'a̱hʉ, da̱mi̱ ma̱hmʉ'ʉ sʉ'a̱hʉ. Da̱mi̱ yørpa̱hʉ ra̱ nho. Da̱mi̱ hmi̱hʉ n'na ra̱ cosa, pɛ nu̱'a̱ ra̱ ja̱'i̱ ga̱di hmi̱thʉ n'na ra̱ cosa, 'yo gui tø'mi̱ ngue xquet'a̱ di hmi̱'a̱hʉ. Nu̱'mø gá̱ 'yøthʉ tengu̱ na̱ ra̱ hya̱ dí xi'a̱hʉ ya, xa̱ngu̱ rá̱ nja̱pi̱ Oja̱ di 'da'a̱hʉ. 'Nɛ̱ di̱ nɛ̱qui̱ ngue ya yø ba̱si̱'a̱hʉ na̱ Oja̱ ma̱guesɛ. Porque xquet'a̱ ørpa̱bi̱ ra̱ nho Oja̱'ʉ yø ts'oc'ɛ̱i̱, ma̱da̱que'a̱ hi̱ndi̱ ja ma̱mma̱di̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Di̱ nja ni̱ nhuɛ̱ca̱tehʉ tengu̱tho Oja̱ ni̱ Papáhʉ i ja rá̱ nhuɛ̱ca̱te'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","'Yo guí ha̱spa̱hʉ ra̱ güɛnda te ør'mi̱'da yø ja̱'i̱, n'namhma̱ ngue hi̱nda̱ hya̱ts'a̱hʉ ra̱ güɛnda Oja̱ te guí øthʉ. 'Yo sä gui̱ mma̱mhmʉ ngue da̱ ma ra̱ castigo mi̱'da yø ja̱'i̱, n'namhma̱ ngue hi̱nda̱ mɛn'na̱hʉ ra̱ castigo Oja̱. Da̱mi̱ pu̱nnba̱bi̱ ni̱ mmi̱c'ɛ̱i̱hʉ, n'namhma̱ ngue xquet'a̱ di pu̱n'na̱hʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Da̱mi̱ fäxhʉ'ʉ sä ra̱ n'ʉ, n'namhma̱ ngue da̱ mäxa̱hʉ Oja̱. Da̱ 'yɛn'na̱hʉ xa̱nho, di dʉtra̱ t'ɛni̱, da̱ hua̱ti̱ asta̱ da̱ bonspʉ gui 'yʉthʉ. Porque tengu̱tho gui 'yøthʉ, xquet'a̱ gue'a̱ di̱ nja'a̱hʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bi hyɛcra̱ hya̱ ra̱ Jesús ngue hi̱nga̱ te bi zä ma̱xädi da̱ dɛnyø ja̱'i̱. Bi 'yɛ̱na̱: ―Xi n'na ra̱ xädä, ¿ua da̱ zä di̱ m'mɛt'o p'ʉ di̱ ma rá̱ mmi̱nxädäui? Hi̱nda̱ zä di̱ m'mɛt'o, porque nu̱'mø bi̱ nthɛui n'na ra̱ ots'i, 'dap'ʉ da̱ zo. ");
INSERT INTO otnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nu̱'a̱ ngue ra̱ xäditho, hi̱n ma̱n'na xa̱ngu̱ pa̱di̱ ngue rá̱ xännba̱te, pɛ da̱ zä da̱ ba̱di̱ te gäma̱ hya̱ pa̱hrá̱ xännba̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Hanja yø ja̱'i̱ ngue ja xa̱ngu̱ yø ts'oqui, guehya nne da̱ hya̱spa̱ ra̱ güɛnda yø ja̱'i̱ ngue ts'ʉdyø ts'oqui ja ya? Tengu̱tho 'mø guí xihni̱ cu̱ ya ngue oxra̱ häi rá̱ dä, pɛ nu̱'i̱ p'ʉya, ra̱ biga di o ni̱ dä. ");
INSERT INTO otnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ya hi̱nda̱ zä gui 'yɛ̱mni̱ cu̱: “Ague n'yø, tø ga̱ ha̱hmi̱ ra̱ häi o ni̱ dä”, gui 'yɛ̱mbi̱. A nu̱'i̱ p'ʉya, hi̱n ga̱di̱ u̱nna̱ güɛnda ngue ra̱ biga oxni̱ dä. Ya hi̱nni̱ 'yu̱p'ʉ te guí̱ mma̱. 'Be da̱mi̱ hya̱hra̱ biga oxni̱ dä, n'namhma̱ da̱ zä gui hya̱mba̱bi̱ ra̱ häi o rá̱ dä ni̱ cu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nu̱ ra̱ hoga̱ za, hi̱nga̱ ja zʉp'ʉ ra̱ ndät'ä hi̱ngui̱ ho. Nu̱'a̱ hi̱ngra̱ hoga̱ za, hi̱nga̱ ja zʉp'ʉ ra̱ hoga̱ ndät'ä. ");
INSERT INTO otnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","N'na ngu̱ n'na yø za, nu̱'a̱ te yø ndät'ä zʉdi, gue'a̱ di fa̱'a̱. Tengu̱tho p'ʉ ja ra̱ 'ui̱ni̱, hi̱nga̱ ja zʉp'ʉ yø igo. Ni̱ xingyø uva di zʉp'ʉ ja yø 'ui̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Njarbʉtho n'na ra̱ hoga̱ n'yohʉ ya, ra̱ hoga̱ hya̱ mma̱, porque xa̱nho rá̱ mmʉi. Pɛ ra̱ ts'oc'ɛ̱i̱, xa̱nts'o te mma̱, porque xa̱nts'o rá̱ mmʉi. Nu̱'a̱ ra̱ hya̱ pønna̱ ne, mbo rá̱ mmʉi ni̱ 'yɛ̱hɛ̱, ogue xa̱nho, ogue xa̱nts'o. ");
INSERT INTO otnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Hanja ngue guí ɛ̱njʉ ngue ni̱ hmu̱jʉ, 'nɛ̱ hi̱nguí̱ øthʉ'a̱ te dí̱ nnegä ngue gui 'yøthʉ? ");
INSERT INTO otnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nu̱ te'o gä tɛnngui̱, i øde hanja ra̱ hya̱ dí̱ mma̱, 'nɛ̱ da̱ 'yøt'e te dí xifi, ga̱ xi'a̱hʉ ra̱ hya̱ nna̱ hyɛjpi. ");
INSERT INTO otnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nna̱ hyɛjpa̱bi̱ n'na ra̱ n'yohʉ ngue nne di̱ nhønni̱gu̱. Xta̱nhɛ̱ ra̱ häi da̱ 'ya'mi̱. Nu̱p'ʉ ja ra̱ mmʉndo, ja da̱ fʉp'ʉ ra̱ ja̱do. Nu̱'mø bi tho'a̱ n'na ra̱ da̱the p'ʉya, ra̱ dehe nts'ɛdi ga̱ nnønhna̱ ngu̱, pɛ hi̱nda̱ 'ya̱nna̱ ngu̱, porque ra̱ mmʉndo p'ʉ høts'e. ");
INSERT INTO otnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pɛ nu̱ ra̱ ja̱'i̱ ngue øhra̱ hya̱ dí̱ mma̱, 'nɛ̱ hi̱nda̱ 'yøt'e te dí xifi, nna̱ hyɛjpa̱bi̱ n'na ra̱ n'yohʉ ngue guep'ʉ ja ra̱ häitho bi hyøhrá̱ ngu̱. Hi̱mbi̱ hyøxpʉ ja ra̱ mmʉndo. Nu̱'mø mi̱ tho ra̱ da̱the, bi̱ nønhna̱ ngu̱. Bi hyømbʉya, bi xʉdi. ");
INSERT INTO otnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ bi xihyø ja̱'i̱ ra̱ Jesús, bi̱ ma, i̱ map'ʉ ja ra̱ hni̱ni̱ Capernaum. ");
INSERT INTO otnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nu̱na̱ ra̱ hni̱ni̱ na̱, mi̱ 'bʉp'ʉ n'na ra̱ capita ngue mi̱ si n'na ra̱ hmi̱qui̱ ɛ̱mmɛ̱i̱ di̱ ma̱di̱. Nu̱na̱ ra̱ hmi̱qui̱, ma̱di̱ hyɛ̱nni̱, ya ja ngue da̱ du̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mi̱ zä mi̱ 'yøhra̱ capita ngue hma̱ te øtra̱ Jesús, bi̱ mɛnhni̱ 'da yø judío 'bɛt'o p'ʉ ja ra̱ ni̱ja̱ ngue bá̱ äpra̱ ma̱te ra̱ Jesús ngue da̱ ɛ̱hɛ̱ da̱ 'yøthebi na̱ rá̱ hmi̱qui̱ ra̱ capita. ");
INSERT INTO otnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nu̱'ʉ yø judío bi guarbʉ 'bʉhra̱ Jesús. Bi 'yäpra̱ ma̱te, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ capita, ni̱ 'yu̱p'ʉ gui fäxna̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Porque di̱ ma̱hyø judío na̱, 'nɛ̱ bi hoga̱he n'na ra̱ ni̱ja̱ ngue bi gu̱sɛhɛ. ");
INSERT INTO otnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ra̱ Jesús bi̱ mɛ'ʉ yø judío sits'i. Pɛ nu̱'mø ya xma̱nguerpʉ da̱ zømp'ʉ ja ra̱ ngu̱, nu̱na̱ ra̱ capita bi̱ mɛnhni̱ 'da yø amigo ngue bá̱ ɛ̱mbra̱ Jesús: ―Ague n'yø, 'yo ga̱di̱ n'ʉni̱, porque hi̱mma̱ nsäga̱'be ngue gui cʉrbʉ ja ma̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ja̱na̱ngue nu̱gä ni̱ xinga̱ gue'a̱ xca̱ masɛgä p'ʉ ngue xca̱bá̱ ä'i ra̱ ma̱te. A nu̱yá, høntho da̱mi̱ ma̱nya ngue da̱ zä ma̱ hmi̱qui̱ dí xi'i, ya dí pa̱di̱ ngue da̱ zä ra̱ n'ʉ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porque nu̱gui̱ xquet'a̱ 'bʉi to 'bɛt'o ngue di̱ ma̱ndagui̱. Nu̱gä p'ʉya, xquet'a̱ dí si ma̱ soldado da̱di̱ ma̱nda. Nu̱'mø dí xi'a̱ n'na ra̱ soldado ngue ha da̱ ma, pap'ʉ dí ɛt'i. Ogue ga̱ ɛ̱mbi̱: “Bi 'yɛ̱cua”, ra̱ soldado p'ʉya bá̱ ɛ̱p'ʉ. Ogue ma̱ hmi̱qui̱ ga̱ 'bɛpi te da̱ mɛfi, ra̱ hmi̱qui̱ øt'e te dí xifi. ");
INSERT INTO otnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nu̱na̱ ra̱ hya̱ t'ɛ̱mbi̱ bi̱ ma̱nna̱ n'yohʉ, di 'yøtho 'mø mi̱ 'yøhra̱ Jesús. Bi 'yɛ̱mbyø ja̱'i̱ n'youi p'ʉya: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue hi̱njonni̱ judío di pøni̱ ngue gdi ti̱nnbä rá̱ nt'ɛ̱c'ɛ̱i̱ tengu̱ ga̱ 'yɛ̱c'ɛ̱i̱gä na̱ ra̱ n'yohʉ na̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mi̱ zøp'ʉ ja ra̱ ngu̱'ʉ yø m'mɛnhni̱, nu̱'a̱ ra̱ hmi̱qui̱ bi di̱ni̱ ngue ya xi ya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","M'mɛfa p'ʉya, nu̱p'ʉ ja ra̱ hni̱ni̱ Naín, ja i̱ map'ʉ ra̱ Jesús. Ní̱ n'youi yø xädi, xa̱ngu̱ mi̱'da yø ja̱'i̱ ní̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nu̱'mø ni̱ ma da̱ zømp'ʉ ja ra̱ hni̱ni̱, bi̱ nu̱ ngue mmap'ʉ n'na ra̱ ánima ni̱ du̱ yø ja̱'i̱ ngue da̱ ägui. Hønt'a̱ rá̱ 'dants'ʉnt'ʉ mi̱ si n'na ra̱ 'danxu̱'a̱. Ni̱ n'youi xa̱ngu̱ yø ja̱'i̱ ngue yø mmɛ̱ngu̱ p'ʉ ja ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mi̱ nu̱ ra̱ 'danxu̱ ra̱ Jesús, bi huɛ̱qui̱, bi 'yɛ̱mbi̱: ―Ogui zoni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nu̱na̱ ra̱ Jesús, bi guatra̱ huada ni̱ thu̱ ngue bi jäti. Bi̱ m'mä'ʉ ni̱ du̱ p'ʉya. Ra̱ Jesús bi 'yɛ̱mbra̱ ánima: ―Ague n'yø, dí xi'i ngue da̱mi̱ nangui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nu̱'a̱ ra̱ du̱ p'ʉya bi̱ nangui̱ bi̱ mi̱. 'Nɛ̱ bi̱ nya̱. Nu̱na̱ ra̱ Jesús bi däprá̱ mamá na̱ ma̱rá̱ du̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɛ̱mmɛ̱i̱ bi̱ nsu̱ yø ja̱'i̱ 'mø mi̱ nu̱'a̱ te bi̱ nja. Pɛ ɛ̱spa̱bi̱ Oja̱ yø ja̱'i̱, i ɛ̱na̱: ―Hi̱n hapʉ xa̱ hnu̱ n'na ra̱ pønga̱hya̱ tengu̱ na̱ bi zøcua dí̱ m'mʉhmʉ ya. Ma̱høn'a̱ ɛ̱mp'ʉya: ―Ya dá̱ nu̱rpa̱hʉ rá̱ ts'ɛdi Oja̱, ngue fäxte ua dí 'bʉhmʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gä ra̱ häi Judea bi̱ n'yo ra̱ hya̱ te bi 'yøtra̱ Jesús, porque ndap'ʉ bi zä bi fa̱di̱ te bi 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nu̱'ʉ yø xädi ra̱ Xuua, bi xifi te 'bɛ'a̱ gä øtra̱ Jesús. Ra̱ Xuua p'ʉya, bi zonhni̱ yoho yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bi 'yɛt'i ngue da̱ ørpa̱ ra̱ nt'änni̱ ra̱ Jesús ngue'mø ma̱jua̱ni̱ gue'a̱ ra̱ Cristo ja ngue da̱ ɛ̱hɛ̱ di̱ nda̱st'abi, ogue da̱ thøm'ma̱n'na. ");
INSERT INTO otnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nu̱ya yø m'mɛnhni̱ ra̱ Xuua, mi̱ zømp'ʉ 'bʉhra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ Xuua øtra̱ nxixya̱, xpá̱ mmɛnga̱'be ngue ga̱ øt'a̱'be ra̱ nt'änni̱ 'mø gue'e na̱ ra̱ Cristo ja ngue da̱ ɛ̱hɛ̱ di̱ nda̱st'abi, ogue ga̱ tø'mähe ma̱n'na ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nu̱'a̱ ra̱ ora bi zøn'ʉ yø m'mɛnhni̱ p'ʉya, bi 'yøthe xa̱ngu̱ yø därquɛ̱hi̱ ra̱ Jesús, bi 'yøthe'ʉ mi̱ n'youi yø ts'onthi̱. Xa̱ngu̱ yø xädä bi̱ nzø yø dä. ");
INSERT INTO otnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ra̱ Jesús bi 'yɛ̱mbya ya̱ui: ―Ni̱ mɛ ya, bá̱ xihmi̱ ra̱ Xuua na̱ ra̱ hya̱ gá nu̱ui bi̱ nja. Xihmi̱ ya yø hya̱ gá̱ 'yøhmi̱ dí̱ mma̱ngä. Da̱mi̱ xihmi̱ ngue yø xädä ya zø yø dä. Yø dogua, ya i 'yo. Yø ja̱'i̱ mi̱ 'ya yø do'yo, ya bi zä ha hɛ̱mbi̱. Yø gogu̱, ya øhra̱ hya̱. Yø ánima, ya di bɛ̱nna̱te. Yø hyoya, ya sihra̱ hoga̱ 'da'yo hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ra̱ mmɛ̱nthi̱ di̱ nthɛui ra̱ ja̱'i̱ hi̱nha di gohrá̱ mmʉi ngue ɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mi̱ mengyø m'mɛnhni̱ ra̱ Xuua, nu̱na̱ ra̱ Jesús bi dʉ'mi̱ bi c'a̱nnba̱bi̱ yø ja̱'i̱ na̱ ra̱ Xuua. Bi 'yɛ̱mbi̱: ―¿Te'o gá̱ ma guá̱ nu̱hʉ p'ʉ bí ja ra̱ da̱po? ¿Ua guá̱ nu̱hʉ n'na ra̱ n'yohʉ hi̱ngui̱ nzaqui rá̱ mmʉi, ɛ̱ntho n'na ra̱ zafani̱ 'mø a̱nna̱ nda̱hi̱? ");
INSERT INTO otnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Xi'mø ngue hi̱n'na̱, ¿te'o guá̱ nu̱hʉ 'mø? ¿Ua guá̱ nu̱hʉ n'na ra̱ n'yohʉ ngue he ra̱ hoga̱ u̱lu? Pɛ guí pa̱hmʉ ngue yø ja̱'i̱ he ra̱ hoga̱ u̱lu ngue 'bʉ mma̱pähä, guep'ʉ ja yø ngu̱ yø da̱st'abi 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pɛ xi'mø hi̱nga̱ gue'a̱ guá̱ nu̱hʉ'a̱, ¿te'o guá̱ nu̱hʉ 'mø? ¿Ua guá̱ nu̱hʉ n'na rá̱ pønga̱hya̱ Oja̱? Ma̱jua̱ni̱ ngue gue'a̱ n'na rá̱ pønga̱hya̱ Oja̱ guá̱ nu̱hʉ. Pɛgue ta̱te na̱ ngue gätho mi̱'da yø pønga̱hya̱ xa̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nu̱na̱ ra̱ Xuua, guehna̱ rá̱ m'mɛnhni̱ Oja̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro na̱, ngue ɛ̱na̱: “Ga̱ ɛt'ä ma̱ m'mɛnhni̱, di̱ m'mɛt'o p'ʉ gdi̱ ma. Gue'a̱ di hoqui hapʉ ja ngue gui thogui”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Dí xi'a̱hʉ, nu̱ hangu̱ yø ja̱'i̱ 'bʉi, hi̱njongui̱ pøni̱ ngue di ta̱te ngue ra̱ Xuua. Pɛ nu̱yá, to bi zä ma̱ ja̱'i̱ ya o rá̱ 'yɛ Oja̱ ya, guehya ma̱ da̱tho bi̱ nthɛui ra̱ mmɛ̱nthi̱ ya, ngue ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mi̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ na̱. Gätho yø ja̱'i̱ p'ʉya, co 'nɛ̱hyø ngʉthäi xi xixya̱bi̱ ra̱ Xuua, bi ba̱hyø ja̱'i̱ ngue xa̱nho te mma̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pɛ yø fariseo 'nɛ̱hyø xännba̱te ngue ra̱ ley, hi̱mbi̱ ne'a̱ ra̱ nxixya̱ bi 'yøtra̱ Xuua'ʉ, nu̱'a̱ te nne Oja̱ xta̱ 'yørpa̱bi̱ hi̱mbi̱ nu̱ ma̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ja̱na̱ngue bi 'yɛ̱nna̱ Jesús: ―¿Tegue gda̱ hyɛjpä ya yø ja̱'i̱ ya? ¿Tep'ʉ gui̱ nɛ̱qui̱? ");
INSERT INTO otnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gda̱ hyɛjpa̱bi̱ yø ba̱si̱ n'yɛ̱mp'ʉ ja ra̱ täi. I̱ mmatyø mmi̱mba̱si̱ui ngue di̱ n'yɛ̱mmi̱, i ɛ̱mbi̱: “Dá̱ pixt'ähe ra̱ xithi ngue xqui̱ nnɛ̱hmʉ, pɛ hi̱ngá̱ nnɛ̱hmʉ. Dá̱ tu̱t'a̱he yø thu̱hu̱ ngue yø thu̱ndu̱mmʉi, pɛ hi̱ngá̱ nzomhmʉ”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Guí̱ njathʉ p'ʉya, nu̱'mø hi̱mbi̱ nja'a̱ te guí̱ mma̱mhmʉ, guí̱ mbøcuɛhʉ. Porque bá̱ ɛ̱hra̱ Xuua nu̱na̱ mi̱ øtra̱ nxixya̱ 'nɛ̱ bi 'yɛtrá̱ mmʉi, nu̱'a̱hʉ p'ʉya, gá̱ 'yɛ̱mhmʉ ngue n'youi ra̱ ts'onthi̱ ngue'a̱ te øt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A nu̱yá, guecä drá̱ N'yohʉ dá̱ ɛ̱ ma̱hɛ̱ts'i̱, dí si'a̱ te dí ti̱ni̱, nu̱'a̱hʉ p'ʉya guí ɛ̱njʉ ngue drá̱ nhyøt'a̱ zihmɛ̱. Guí ɛ̱njʉ ngue da̱di thɛgä'be'ʉ yø ja̱'i̱ ja yø ts'oqui 'nɛ̱'ʉ yø ngʉthäi. ");
INSERT INTO otnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pɛ nu̱na̱ ra̱ hya̱ njua̱ntho, nu̱'mø di̱ n'yomfɛ̱ni̱ xa̱nho yø ja̱'i̱, da̱ ba̱di̱ ha rá̱ nja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nu̱'a̱ n'na nc'ɛ̱i̱ yø fariseo bi zixra̱ Jesús ngue da̱ nsi̱hmɛ̱ p'ʉ ja rá̱ ngu̱. Mi̱ zømp'ʉ ja ra̱ ngu̱ ra̱ Jesús, bi̱ mi̱p'ʉ ja ra̱ mɛ̱xa p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nu̱na̱ n'na ra̱ xisu ma̱rá̱ 'yots'om'mäi p'ʉ ja ra̱ hni̱ni̱, mi̱ ba̱di̱ ngue bi̱ ma da̱ nsi̱hmɛ̱ p'ʉ ja rá̱ ngu̱ ra̱ fariseo na̱ ra̱ Jesús. Bi zømp'ʉ ja ra̱ ngu̱ p'ʉya, ni̱ du̱ n'na ra̱ m'mo'aceite, yu̱p'ʉ ra̱ aceite ma̱hotho ga̱ yʉni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bi̱ nda̱ntyøhmu̱ p'ʉ 'bʉhra̱ Jesús ngue bi da̱nnebi yø gua. Mɛ̱nte zoni̱, nu̱'ʉ yø guidä tägui, soxpʉ ja yø gua ra̱ Jesús, thu̱qui̱ conyø xta̱. Bi gospa̱bi̱ ra̱ aceite ma̱hotho ga̱ yʉni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nu̱na̱ ra̱ fariseo xi zixra̱ ts'i̱hmɛ̱ ra̱ Jesús, mi̱ nu̱ te øtra̱ xisu, ngu̱na̱ ra̱ hya̱ bi bɛ̱ni̱, bi 'yɛ̱na̱: “Nu̱'mø ngue nma̱jua̱ni̱ rá̱ pønga̱hya̱ Oja̱ na̱ ra̱ n'yohʉ na̱, di pa̱di̱ te rá̱ m'mäi na̱ ra̱ xisu cuar'mø, ngue ra̱ 'yots'om'mäi”. ");
INSERT INTO otnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ra̱ Jesús bi 'yɛ̱mbra̱ fariseo: ―Ague Simu̱, jap'ʉ n'na ra̱ hya̱ dí̱ nne ga̱ xi'i ―bi 'yɛ̱mbi̱. Ɛ̱nna̱ fariseo p'ʉya: ―Da̱mi̱ xiqui grá̱ xännba̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bi 'yɛ̱nna̱ Jesús: ―Yoho yø n'yohʉ di tu̱pra̱ mɛ̱nyu̱'a̱ to di hmi̱ ra̱ mɛ̱nyu̱. Nu̱'a̱ n'na ra̱ ndu̱pa̱te p'ʉya, nu̱'a̱ hangu̱ pøxa̱ cʉt'a ciento ma̱ pa ra̱ nzäbi, gue'a̱ ndu̱pa̱te'a̱. Ma̱n'na nc'ɛ̱i̱ p'ʉya, nu̱'a̱ hangu̱ pøxa̱ yote ma̱'dɛt'a ma̱ pa ra̱ nzäbi, gue'a̱ ndu̱pa̱te'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pɛ nu̱'ʉ mi̱ ndu̱pa̱te, ya hi̱mbi̱ zä bi gu̱tyø güɛnda. Nu̱'a̱ bi hmi̱ ra̱ mɛ̱nyu̱ p'ʉya, bi pu̱nnbi̱ gä yoho. Da̱mi̱ xicya, ¿ndana̱ gue'a̱ ya yø ndu̱pa̱te ngue ta̱te di ja ma̱mma̱di̱ rá̱ hmu̱? ");
INSERT INTO otnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bi 'yɛ̱nna̱ Simu̱ p'ʉya: ―Nu̱p'ʉ nná̱ bɛ̱ngä, ma̱n'natho ta̱te di ja ma̱mma̱di̱'a̱ xa̱ngu̱ mi̱ ndu̱pa̱te, 'nɛ̱ bi pu̱nnbi̱. Bi 'yɛ̱nna̱ Jesús: ―Nu̱'a̱ gá̱ ma̱nya, gue'a̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bi hyɛ̱tra̱ xisu na̱ ra̱ Jesús, bi 'yɛ̱mbra̱ Simu̱: ―Guí̱ nnu̱ na̱ ra̱ xisu 'bʉcua ya. Dá̱ cʉt'ä ua ja ni̱ ngu̱, pɛ hi̱ngá̱ 'dacra̱ dehe xca̱ nxʉgua. Pɛ nu̱na̱ ra̱ xisu 'bʉcua, bi̱ merca̱ ma̱ gua conyø guidä, 'nɛ̱ bi du̱qui̱ conyø xta̱. ");
INSERT INTO otnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nu̱'i̱, hi̱nxcá̱ zɛnguagui̱ conn'na ra̱ beso, pɛ nu̱ná̱, mɛ̱nte ra̱ ora xtá̱ cʉt'ä ua ja ni̱ ngu̱ ya, hi̱ngui̱ säya tha̱nnegui ma̱ gua. ");
INSERT INTO otnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nu̱'i̱, hi̱nxcá̱ cosca̱ ra̱ aceite ma̱ ya̱. Pɛ nu̱ná̱, ma̱hotho ga̱ yʉnna̱ aceite bi gosca̱gui̱ ma̱ gua. ");
INSERT INTO otnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Guehna̱ dí xi'i na̱ya, ngue ɛ̱mmɛ̱i̱ di̱ ma̱qui̱, ja di̱ nɛ̱qui̱ p'ʉ ngue xa̱ngu̱ rá̱ ts'oqui, pɛ di̱ mpu̱nnbi̱. Pɛ nu̱ ra̱ ja̱'i̱ ngue ts'ʉtho ma̱pu̱nnbi̱, ts'ʉtho di̱ nɛ̱qui̱ ngue di̱ ma̱'a̱ n'na. ");
INSERT INTO otnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ra̱ Jesús bi 'yɛ̱mbra̱ xisu: ―Ya dá̱ pu̱n'na̱'i̱ ni̱ ts'oqui ya. ");
INSERT INTO otnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nu̱'ʉ mi̱'da yø ja̱'i̱ xi ts'ofo 'dap'ʉ 'bʉhmʉ p'ʉ ja ra̱ mɛ̱xa p'ʉya, di̱ n'yɛ̱mbi̱: ―¿Te'o ni̱ n'yohʉ na̱ ɛ̱na̱ ngue di pu̱nnba̱ yø ts'oqui yø ja̱'i̱? ");
INSERT INTO otnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pɛ ra̱ Jesús bi 'yɛ̱mbra̱ xisu: ―Ya gá̱ nya̱nya ngue gá̱ 'yɛ̱c'ɛ̱i̱gui̱. Da̱ hyu̱ ni̱ mmʉi ya, ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","M'mɛfa p'ʉya, xa̱ngu̱ yø hni̱ni̱ bi thohna̱ ra̱ Jesús ngue xihyø ja̱'i̱ ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱. Ní̱ n'youi'ʉ 'dɛ'ma̱ yoho yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Xquet'a̱ n'yohʉ 'da yø xisu xi 'yøthe ngue mi̱ n'youi yø ts'onthi̱, da̱ gue'ʉ ma̱di hyɛ̱nni̱. N'yohʉ p'ʉ ra̱ Ma̱ya nu̱na̱ ja ma̱n'na rá̱ thu̱hu̱ ngue ra̱ Magdalena. Guehna̱ xi 'yøthe m'mɛt'o ngue mi̱ n'youi yoto yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","N'youi p'ʉ ra̱ Juana nu̱na̱ rá̱ xisu ra̱ Chuza, guehna̱ di̱ ma̱nda gätho yø mɛfi p'ʉ ja rá̱ palacio ra̱ Herodes. 'Nɛ̱ ra̱ Susana n'youi p'ʉ. N'youi p'ʉ xa̱ngu̱ yø xisu ngue ja te pɛts'i, nu̱'mø te honna̱ Jesús, guehya fäxya. ");
INSERT INTO otnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Xa̱ngu̱ yø ja̱'i̱ bá̱ ɛ̱p'ʉ ja yø hni̱ni̱ ngue nne da̱ 'yøde te mma̱nna̱ Jesús. Mi̱ mpɛti xa̱ngu̱ yø ja̱'i̱, bi hyoni̱ te gui hyɛjpa̱ ra̱ hya̱ xihyø ja̱'i̱. Bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―N'na ra̱ n'yohʉ bi̱ ma da̱ ponna̱ trigo. Nu̱p'ʉ bi thogui ngue ponyø hmu̱dä, bi zop'ʉ ja ra̱ 'yu̱ 'da yø hmu̱dä. Bi̱ nɛ̱hyø ja̱'i̱ thop'ʉ ja ra̱ 'yu̱. Bi̱ map'ʉ yø ts'ints'ʉ ngue bi za yø hmu̱dä. ");
INSERT INTO otnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mi̱'da yø hmu̱dä bi̱ moni̱, bi zop'ʉ hi̱ngui̱ pidi ra̱ häi ngue o ra̱ do. Bi 'yotra̱ hmu̱dä 'mø mi̱ bøts'e, ngue hi̱ngui̱ xa ra̱ häi. ");
INSERT INTO otnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mi̱'da yø hmu̱dä bi zop'ʉ ja yø 'ui̱ni̱. Mi̱ nte yø 'ui̱ni̱ p'ʉya, bi ts'onyø hmu̱dä ngue bi hyøt'a̱mbo. ");
INSERT INTO otnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mi̱'da yø hmu̱dä, bi zop'ʉ ja ra̱ hoga̱ häi, guehya ɛ̱mmɛ̱i̱ bi̱ nja ya. Nu̱'a̱ n'na mhmu̱dä bi bøn'a̱ n'na ciento yø hmu̱dä. Nu̱'mø mi̱ ma̱nna̱ ra̱ hya̱ na̱, bi ts'ɛdi bi 'yɛ̱mbyø ja̱'i̱: ―A nu̱yá, di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ na̱ ra̱ hya̱ dí̱ mma̱ngä ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nu̱'ʉ yø xädi bi 'yänni̱ te ga̱ mbønya yø hya̱ xi hyɛqui. ");
INSERT INTO otnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱ya yø hya̱ hi̱ngui̱ fa̱di̱ ha di̱ ma̱nda Oja̱ yø ja̱'i̱, i̱ nne Oja̱ ngue da̱ di̱nni̱ mmʉihʉ ya yø hya̱ ya. Pɛ nu̱ya mi̱'da yø ja̱'i̱, dá̱ thonna̱ hya̱ di̱ nhyɛjpi te dá̱ sifi, n'namhma̱ ngue nu̱ te da̱ nu̱, tengu̱tho 'mø ngue hi̱nte da̱ nu̱. Nu̱ya yø hya̱ da̱ 'yøde, tengu̱tho 'mø ngue hi̱n tema̱ hya̱ da̱ 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ma ga̱ xi'a̱hʉ te ga̱ mbønna̱ ra̱ hya̱ dá̱ ma̱. Nu̱ ra̱ hmu̱dä bi 'boni̱, gue'a̱ rá̱ hya̱ Oja̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nu̱ya yø ja̱'i̱ ngue høntho bi 'yøhra̱ hya̱, guehya gui̱ nhyɛjpi ngue ra̱ nen'yu̱ p'ʉ bi zo ra̱ hmu̱dä ya. Høntho juadi bi 'yøhra̱ hya̱, bi map'ʉ ra̱ zithu̱, bi japi bi pu̱mbɛ̱ni̱ ra̱ hya̱ xi 'yøde. Hi̱ngui̱ nnepe ngue da̱ 'yɛ̱c'ɛ̱i̱ ra̱ hya̱, ngue di̱ nya̱nyø te yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mi̱'da yø ja̱'i̱, gui̱ nhyɛjpa̱ ra̱ häi hi̱ngui̱ pidi ngue mi̱ o ra̱ do p'ʉ bi zo yø hmu̱dä. Mi̱ zä mi̱ 'yøhra̱ hya̱ yø ja̱'i̱, ja̱njua̱ni̱ di johya ngue bi̱ nu̱ ma̱nho. Guehya yø ja̱'i̱ hi̱mbi̱ bɛnt'i xa̱nho ra̱ hya̱ ya. Bi 'yɛ̱c'ɛ̱i̱ njammi̱ pa. Nu̱'mø bi ts'ʉi, 'bexi cohyø mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mi̱'da yø ja̱'i̱ p'ʉya, gui̱ nhyɛjpa̱bi̱ ra̱ häi ngue ja yø 'ui̱ni̱ p'ʉ bi zo yø hmu̱dä. Guehya yø ja̱'i̱ bi 'yøde hanja ra̱ hya̱ ya. Pɛ nu̱'a̱ te yø 'bɛfi i ja n'na pa ngu̱ n'na pa, høndyø 'bɛfi ni̱ ma yø mmʉi yø ja̱'i̱. Di ja ndu̱mmʉi honi̱ ha di̱ mmɛ̱mmɛti. Nu̱'a̱ te yø pähäsɛ, gue'a̱ nne da̱ 'yøt'a̱. Ya hi̱n tema̱ nhotho bi 'yørpa̱bi̱ na̱ ra̱ hya̱ bi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pɛ mi̱'da yø ja̱'i̱, gui̱ nhyɛjpi ngue ra̱ hoga̱ häi p'ʉ bi zo yø hmu̱dä. Guehya yø ja̱'i̱ ngue yø mmʉi ga̱ 'yøhra̱ hya̱ ya, 'nɛ̱ ɛ̱t'a̱mmʉi ra̱ hya̱ øde. Hi̱ngui̱ hɛgui, guehya ha̱xra̱ 'yu̱ njua̱ntho ya. ");
INSERT INTO otnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nu̱'mø to di sa̱ca̱ n'na ra̱ nyot'i, hi̱ngui̱ sä ngue da̱ go'mi̱, ogue da̱ hyøt'a̱ 'bit'ots'i. Sinoque da̱ hyøxma̱ya̱, n'namhma̱ ngue nu̱'ʉ cʉt'a̱mbo ra̱ ngu̱ da̱ hyɛ̱tra̱ nyot'i. ");
INSERT INTO otnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Njarbʉtho ya yø hya̱ hi̱ngui̱ fa̱di̱ hanja ya. Zi yohotho yø ja̱'i̱ ti̱nyø mmʉi hanja ra̱ hya̱. Pɛ da̱ 'yɛ̱hra̱ pa ngue gätho yø ja̱'i̱ da̱ ba̱di̱ hanja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ja̱na̱ngue da̱mi̱ 'yɛ̱t'a̱mmʉihʉ teni̱ bønya yø hya̱ dí̱ mma̱ngä. A nu̱ ra̱ ja̱'i̱ da̱ di̱ni̱ xa̱nho rá̱ mmʉi hanja ra̱ hya̱, da̱ mäx Oja̱ ngue ma̱n'na di ba̱hra̱ hya̱. Pɛ nu̱ ra̱ ja̱'i̱ hi̱ngui̱ nne da̱ 'yørpa̱bi̱ ma̱su̱ ra̱ hya̱ dí̱ mma̱, nu̱'a̱ zits'ʉ ra̱ hya̱ pa̱di̱, da̱ tha̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nu̱p'ʉ mi̱ 'bʉhra̱ Jesús, ja bi zømp'ʉ rá̱ mamá, 'nɛ̱hyø n'yohʉ. Pɛ hi̱ngui̱ sä da̱ guat'i ngue di̱ nya̱ui, porque ma̱ndøngu̱ dyø ja̱'i̱ 'bʉp'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hi̱ndi̱ 'bɛdi to bi xihra̱ Jesús, bi 'yɛ̱mbi̱: ―Ni̱ mamá 'nɛ̱hni̱ n'yohʉ 'bäcua thi. I̱ nzo'i ngue gui̱ nya̱ui 'na̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱ntho: ―Nu̱ya 'bʉcua øspa̱bi̱ rá̱ hya̱ Oja̱, nu̱'a̱ ra̱ hya̱ øde gue'a̱ øt'a̱, guehya ɛ̱ntho ma̱ mamá ya, guehya ɛ̱ntho ma̱ n'yohʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","N'na ra̱ pa ra̱ Jesús bi yʉrbʉ ja n'na ra̱ barco conyø xädi. Bi 'yɛ̱mbi̱: ―A nu̱yá, ma ga̱ 'dasʉ ra̱ zabi gdá̱ mähä ma̱n'na nguadi ―bi 'yɛ̱mbi̱. Bi̱ ma p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mɛ̱nte ni̱ 'yop'ʉ ja ra̱ dehe ra̱ barco, bi̱ n'a̱hra̱ Jesús. Ɛ̱̱na̱ ha bi 'yɛ̱ta̱ n'na ra̱ ndønthi̱ bi̱ n'yo. Nu̱'ʉ yø fʉnthe nangui̱, so mbo ra̱ barco. Ya ja ngue da̱ thu̱nt'a̱ mbonthe ra̱ barco. ");
INSERT INTO otnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nu̱'ʉ yø xädi ra̱ Jesús, bá̱ äp'ʉ bi a̱ha̱, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ague grá̱ xännba̱te, ya ja ngue da̱ thu̱nt'a̱ mbonthe ra̱ barco. Ya ga̱ tu̱hʉ ―bi 'yɛ̱mbi̱. Mi̱ nangra̱ Jesús, bi hɛjpa̱bi̱ ra̱ nda̱hi̱ 'nɛ̱hyø fʉnthe. Ngu̱ i hɛjpi, 'bexpi̱ nsäya. M'mɛfa ya hi̱n tema̱ di 'ya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bi 'yɛ̱mbyø xädi p'ʉya: ―¿Hanja ngue hi̱nguí̱ ɛ̱c'ɛ̱i̱ ngue ga̱ fäxa̱hʉ? ―bi 'yɛ̱mbi̱. Nu̱'ʉ yø xädi di 'yøtho hanja'a̱ te bi̱ nu̱, 'nɛ̱ bi̱ nsu̱. Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na p'ʉya: ―¿Te'o ni̱ n'yohʉ na̱ n'yø? Nu̱'mø bi zohra̱ nda̱hi̱ 'nɛ̱hra̱ dehe, i ɛ̱c'ɛ̱i̱ ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mi̱ zønna̱ barco p'ʉ ja ra̱ häi Gadara, ma̱n'na nguadi ra̱ zabi ha di̱ nhyandui ra̱ häi Galilea. ");
INSERT INTO otnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mi̱ bømp'ʉ ja ra̱ barco ra̱ Jesús, bi guat'a̱ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱ngu̱ p'ʉ. Ya rá̱ ya'atho yø pa mi̱ n'youi yø ts'onthi̱ na̱ ra̱ n'yohʉ. Ni̱ xi̱ngra̱ u̱lu di he. Ni̱ xi̱ngui̱ 'bʉp'ʉ ja rá̱ ngu̱, sinoque guep'ʉ ja ra̱ camposanto bí 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ngu̱ i̱ nu̱ ra̱ Jesús, bi̱ nda̱ntyøhmu̱ p'ʉ ha 'bäi. Ra̱ ndøts'ɛdi i zofo, bi 'yɛ̱mbi̱: ―Ague Jesús, rá̱ Ts'ʉnt'ʉ'i Oja̱ nu̱na̱ jasɛ rá̱ ts'ɛdi. ¿Hanja ngue ga̱di̱ nthi̱nt'ua dí 'bʉi? Dí ä'i ra̱ ma̱te ngue 'yo ga̱di ʉngui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ngu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ n'yohʉ, porque ya xi xihra̱ ts'onthi̱ ra̱ Jesús ngue da̱ hyɛp'ʉ ra̱ n'yohʉ n'youi. Xa̱ngu̱ yø nni̱di̱ ngue ɛ̱mmɛ̱i̱ di ʉm'mø bi gʉ. Yø ja̱'i̱ p'ʉya tu̱rpa̱ yø 'yɛ 'nɛ̱hyø gua conyø cadena, pɛ di c'ʉqui. Ra̱ ts'onthi̱ p'ʉya di japra̱ n'yohʉ ngue 'dagui, ni̱ ma da̱po. ");
INSERT INTO otnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ra̱ Jesús bi 'yänni̱, bi 'yɛ̱mbi̱: ―¿Teni̱ hu̱'i̱? Ra̱ n'yohʉ p'ʉya bi 'yɛ̱na̱: ―Nná̱ hu̱gä ngue yø mmu̱ndotho gähe ―bi 'yɛ̱na̱. Bi̱ ma̱nna̱ tengu̱ na̱ porque xa̱ngu̱ yø ts'onthi̱ mi̱ n'youi ra̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nu̱'ʉ yø ts'onthi̱ p'ʉya, bi xihra̱ Jesús ngue hi̱nda̱ 'yɛrbʉ ha ja ngue da̱ jot'i. ");
INSERT INTO otnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ja mi̱ 'yorbʉtho n'na 'bʉi yø ts'ʉdi ma̱'yoni̱ p'ʉ ja ra̱ nguani̱ p'ʉya. Yø ts'onthi̱ p'ʉya, bi 'yädi ngue da̱ yʉrbʉ ja yø mmʉi yø ts'ʉdi. A nu̱na̱ ra̱ Jesús bi u̱nna̱ nt'ɛ̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ja̱na̱ngue yø ts'onthi̱ bi hyɛp'ʉ ra̱ n'yohʉ mi̱ n'youi, bi yʉrbʉ ja yø mmʉi yø ts'ʉdi. Nu̱ya yø ts'ʉdi p'ʉya, bi gʉ ra̱ 'dihi, bi̱ nhyørbʉ ja ra̱ zabi. Gä ja bi ja̱rbʉ ra̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nu̱'ʉ yø n'yohʉ mi̱ fähyø ts'ʉdi, mi̱ nu̱ te bi̱ nja. Bi gʉ ra̱ 'dihi bi̱ ma bá̱ ma̱mp'ʉ bí ja ra̱ hni̱ni̱. Da̱ gue'ʉ yø ja̱'i̱ 'da'a̱ n'nanni̱ ha 'bʉi, gä bá̱ xifi. ");
INSERT INTO otnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mi̱ 'yøhyø ja̱'i̱'a̱ te bi̱ nja, ma̱ndøngu̱ dyø ja̱'i̱ bá̱ ɛ̱hɛ̱ da̱ nu̱. Mi̱ zønyø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús, 'dap'ʉ 'bʉhmi̱'a̱ ra̱ n'yohʉ mi̱ n'youi yø ts'onthi̱. Ya xi di̱ts'i̱. Ya hi̱nte di ja, ya he yø u̱lu. Pɛ bi zu̱ yø ja̱'i̱'a̱ te xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nu̱ya yø ja̱'i̱ xi̱ nu̱sɛ'a̱ te xi tho ra̱ n'yohʉ mi̱ n'youi yø ts'onthi̱, gä xihyø ja̱'i̱ nu̱'ʉ ja søhø. ");
INSERT INTO otnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nu̱na̱ ra̱ hya̱ bi̱ nja, ngu̱ya yø mmɛ̱ngu̱ Gadara, ngu̱ya yø ja̱'i̱ ndap'ʉ bi zä bi 'yɛ̱'a̱ ra̱ xɛqui'a̱, 'da ga̱ xityø ja̱'i̱ ra̱ Jesús ngue da̱ ma. Porque ɛ̱mmɛ̱i̱ su̱ yø ja̱'i̱ te bi 'yøt'e. Ja̱na̱ngue hømbi̱ yʉrbʉ ja ra̱ barco ra̱ Jesús ngue bi̱ mengui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nu̱'a̱ ra̱ n'yohʉ mi̱ n'youi yø ts'onthi̱ bi xifi ngue xta̱ mmɛ ra̱ Jesús. Pɛ ra̱ Jesús hi̱mbi̱ nepe, sinoque bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ma̱n'na xa̱nho ni̱ ma ni̱ ngu̱, n'namhma̱ gui xihyø ja̱'i̱'a̱ te gä bi 'yøt'a̱'i̱ Oja̱ ―bi 'yɛ̱mbi̱. Bi̱ ma ra̱ n'yohʉ p'ʉya, bi xifi gätho yø ja̱'i̱ p'ʉ ja ra̱ hni̱ni̱'a̱ te xi 'yørpa̱bi̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mi̱ zøm ma̱n'na nguadi ra̱ zabi ra̱ Jesús. Mi̱ nu̱ yø ja̱'i̱ ya ma̱mbi 'bʉp'ʉ, ra̱ ndi johya. Porque ya mi̱ ndø'ma̱te gätho yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bi zø'a̱ n'na ra̱ n'yohʉ 'bɛt'o ngue di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱ p'ʉya, ni̱ hu̱ ngue ra̱ Jairo. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús. Bi 'yäpra̱ ma̱te ngue da̱ map'ʉ bí ja rá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Porque ya ja ngue da̱ du̱ n'na rá̱ t'i̱xu̱ mi̱ si. Ya n'nɛ'ma̱ yonjɛya mi̱ 'bʉi, pɛ hønt'a̱ rá̱ 'dant'i̱xu̱ mi̱ si'a̱. Mi̱ ma ra̱ Jesús. Xa̱ngu̱ yø ja̱'i̱ bi dɛnni̱ asta̱ di̱ ntørbʉ ja ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nu̱'ʉ yø ja̱'i̱ ni̱ dɛnna̱ Jesús, n'youi p'ʉ n'na ra̱ xisu ngue ya n'nɛ'ma̱ yonjɛya mi̱ hɛ̱mbra̱ m'mäcji. Nu̱na̱ ra̱ xisu ma̱di̱ hyɛ̱nni̱, xa̱ndøngu̱ rá̱ mɛ̱nyu̱ xi ʉni̱ ngue mi̱ honyø 'yøthe da̱ 'yøthe. Pɛ xi̱nga̱ n'na'ʉ yø 'yøthe xta̱ nzä da̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nu̱na̱ ra̱ xisu, bi̱ m'mɛfa p'ʉ ni̱ ma ra̱ Jesús, bi guarbʉ ja rá̱ xʉtha, bi därpa̱ rá̱ nya̱ni̱ rá̱ he. Ngu̱'i därpa̱ rá̱ he p'ʉya, 'bexpi̱ nsäya ra̱ ji mi̱ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bi 'yɛ̱nna̱ Jesús: ―¿Te'o bi därca̱gui̱ ma̱ he? ―bi 'yɛ̱mbyø ja̱'i̱. Gätho yø ja̱'i̱ p'ʉya, i̱ mma̱ ngue hi̱njo'o. Pɛ ra̱ Bɛdu 'nɛ̱'ʉ mi̱'da yø n'yohʉ bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, guí änni̱ to bi dät'a̱ ni̱ he. Conque guí̱ nnu̱ ngue di̱ ntøtyø ja̱'i̱, 'nɛ̱ tøn'na̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pɛ ra̱ Jesús bi 'yɛ̱na̱: ―Hi̱n'na̱. 'Bʉi to bi därca̱ ma̱ he. Porque da̱di̱ u̱nna̱ güɛnda ngue bi zä n'na nc'ɛ̱i̱ comma̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bi̱ nu̱ ra̱ xisu p'ʉya, ngue fa̱tho te bi 'yøt'e. Ni̱ hua̱qui̱ mmap'ʉ. Bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús. Yø hmi̱ yø dä yø ja̱'i̱ p'ʉ bi xi'a̱ njua̱ni̱ te nnepe ngue bi dädi. 'Nɛ̱ bi xifi ngue 'bexpi zä ra̱ ji mi̱ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague t'i̱xu̱, ya bi zä'i ngue gá̱ 'yɛ̱c'ɛ̱i̱ ngue di zä'i comma̱ ts'ɛdigä. Da̱ hyu̱ ni̱ mmʉi ya, ni̱ ma ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nu̱na̱ ra̱ Jesús, mɛ̱nte ya̱ui ra̱ xisu ma̱di̱ hyɛ̱nni̱, bi zø hma̱n'na nc'ɛ̱i̱ bá̱ nɛ̱xpʉ ja rá̱ ngu̱ ra̱ Jairo. Bi 'yɛ̱mbra̱ Jairo: ―Ya bi du̱ ni̱ t'i̱xu̱ n'yø, 'yoni̱ mantho gui sixra̱ xännba̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pɛ ra̱ Jesús, mi̱ 'yø'a̱ te si ra̱ Jairo, bi 'yɛ̱mbi̱: ―'Yo sä guí su̱'a̱ si'i ngue bi du̱ ni̱ t'i̱xu̱. Sinoque da̱mi̱ 'yɛ̱c'ɛ̱i̱gui̱ ngue da̱ zä ga̱ øthegä ni̱ t'i̱xu̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mi̱ zømp'ʉ ja ra̱ ngu̱ p'ʉya, hi̱njondi̱ japi ngue 'da xti yʉt'ui mbo. Høndra̱ Bɛdu, ra̱ Jacobo, ra̱ Xuua, 'nɛ̱hrá̱ papá 'nɛ̱hrá̱ mamá ra̱ hmu̱te bi japi bi yʉt'a̱mbo. ");
INSERT INTO otnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Gä zonyø ja̱'i̱, i ya̱ du̱mmʉi yø ja̱'i̱ conná̱ ngue'a̱ bi du̱. Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―'Yo gui zomhmʉ. Nu̱na̱ ra̱ hmu̱te hi̱ngui̱ tu̱ na̱, i a̱tho na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pɛ nu̱ya yø ja̱'i̱ ya̱ui ra̱ Jesús i thentho, porque pa̱di̱ ngue ya xi du̱ ra̱ hmu̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nu̱na̱ ra̱ Jesús bi bɛnnba̱ rá̱ 'yɛ ra̱ du̱, nts'ɛdi bi 'yɛ̱mbi̱: ―Ague grá̱ hmu̱te, da̱mi̱ nangui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nu̱na̱ ra̱ hmu̱te p'ʉya, ma̱hømbi̱ nja rá̱ te. Bi̱ nangui̱ 'bexque'a̱. Bi̱ ma̱nda ra̱ Jesús ngue di t'u̱nna̱ hmɛ̱ da̱ zi ra̱ hmu̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nu̱na̱ rá̱ papá 'nɛ̱hra̱ mamá ra̱ hmu̱te di 'yøtho te bi̱ nja. Pɛ ra̱ Jesús bi̱ ma̱nda ngue hi̱njonda̱ sifi te bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nu̱na̱ ra̱ Jesús, mi̱ pɛti gätho'ʉ 'dɛ'ma̱ yoho yø xädi ya xi huanhni̱. Bi u̱nna̱ nt'ɛ̱di̱ ngue da̱ hya̱ ra̱ ts'ɛdi da̱ 'yøthe gätho yø ja̱'i̱ n'youi yø ts'onthi̱, da̱ 'yøthe yø ja̱'i̱ hɛ̱mbi̱ 'dama̱ 'dan'yo ma̱n'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bi̱ mɛnhni̱ ngue da̱ xihra̱ hya̱ yø ja̱'i̱ ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱. 'Nɛ̱ da̱ 'yøthe yø därquɛ̱hi̱ p'ʉ di̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bi 'yɛ̱mbi̱: ―'Yo te gui ha̱x'mø gá̱ mähä, ni̱ xi̱ngra̱ tøhø, ni̱ xi̱ngra̱ bolsa, ni̱ xi̱ngra̱ thu̱hmɛ̱, ni̱ xi̱ngra̱ mɛ̱nyu̱. 'Yo gui ca̱x ma̱n'na ni̱ pahni̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nu̱p'ʉ ja ra̱ ngu̱ di̱ n'na'a̱hʉ ra̱ ts'äya, ja gui̱ n'oxhʉ p'ʉ, asta̱ gue'mø guá̱ ɛ̱hmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A nu̱p'ʉ hi̱ndi̱ n'na'a̱hʉ ra̱ ts'äya, gui pømhmʉ p'ʉ ja ra̱ hni̱ni̱. Pɛ da̱mi̱ hua̱mhra̱ fonthäi di̱ n'youi ni̱ mbonguahʉ, gue'a̱ ra̱ hmɛ̱ya'a̱ ngue ya da̱ thɛp'ʉ ya yø ja̱'i̱ hi̱mbi̱ 'yøt'a̱hʉ ma̱su̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bi̱ ma'ʉ bi t'ɛt'i, i̱ mpa p'ʉ ja yø hni̱ni̱. Bi xihyø ja̱'i̱ ra̱ hoga̱ 'da'yo hya̱, 'nɛ̱ bi 'yøthe yø därquɛ̱hi̱ p'ʉ ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mi̱ 'yøhra̱ da̱st'abi Herodes te mma̱nyø ja̱'i̱ ngue xa̱ngu̱ yø milagro øtra̱ Jesús. Di 'yøtho'a̱ te øde, porque ɛ̱n'i'da yø ja̱'i̱ ngue nu̱na̱ ra̱ Jesús, guehna̱ ra̱ Xuua xi bɛ̱nna̱te p'ʉ bí̱ nt'ägui. ");
INSERT INTO otnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mi̱'da yø ja̱'i̱ p'ʉya, ɛ̱mbi̱ ngue ya 'yop'ʉ ra̱ Elías. Mi̱'da p'ʉya, ɛ̱mbi̱ ngue 'bʉi toni̱ nyogui pønga̱hya̱ Oja̱ xpi bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pɛ ra̱ Herodes bi 'yɛ̱na̱: ―Nu̱'a̱ ra̱ Xuua dá̱ ma̱ndagä bi t'øjpa̱bi̱ rá̱ ya̱'a̱, hi̱nga̱ gue'a̱ 'yop'ʉ'a̱. ¿Pɛ te'o ni̱ n'yohʉ na̱ dí øcä ngue xa̱ngu̱ yø cosa øt'e? Ya hi̱ngui̱ nnu̱ ra̱ pa ra̱ Herodes ngue da̱ nu̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma̱mbá̱ pengyø xädi ra̱ Jesús ngue bá̱ ma̱nna̱ hya̱ p'ʉ ja yø hni̱ni̱, bi däpra̱ güɛnda te xi 'yøt'e. Nu̱na̱ ra̱ Jesús bi zixyø xädi ngue bi̱ ma da̱po, jonna̱ hni̱ni̱ Betsaida. ");
INSERT INTO otnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pɛ nu̱'mø mi̱ ba̱hyø ja̱'i̱ hapʉ bí 'bʉhra̱ Jesús, bi̱ map'ʉ bí 'bʉi. Di säyabi yø ja̱'i̱ sømp'ʉ 'bʉi. I xihyø ja̱'i̱ ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱. Xquet'a̱ bi 'yøthe yø därquɛ̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nu̱'mø ya ni̱ ma di̱ nde p'ʉya, bi guat'ʉ 'dɛ'ma̱ yoho yø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'yɛ̱hyø ja̱'i̱, n'namhma̱ da̱ hyoni̱ ha di̱ n'oxi, ja da̱ dämp'ʉ ra̱ hmɛ̱ da̱ zi. Porque nu̱ua dí 'bʉhmʉ, ra̱ da̱po ua. ");
INSERT INTO otnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Da̱mi̱ u̱nhnʉ ra̱ hmɛ̱ da̱ zi yø ja̱'i̱ ―bi 'yɛ̱mbi̱. Nu̱'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Pɛ høndi cʉt'a yø thu̱hmɛ̱ dí ha̱gähe, 'nɛ̱ yoho yø hua̱. Rá̱ nzɛgui ga̱ mmäcähe 'mø, ga̱ ma tämhme ra̱ hmɛ̱ da̱ zi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yø ja̱'i̱ p'ʉya, comma̱ cʉt'a ma̱hua̱hi̱ ma̱'yohʉ. Pɛ ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Da̱mi̱ xihmʉ yø ja̱'i̱ da̱ mi̱. Da̱ 'yøtyø zimundo ngue dyø yote ma̱'dɛt'a nja̱'i̱ p'ʉ da̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Gue'a̱ bi 'yøt'a̱ p'ʉya. Bi̱ mi̱ gätho yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ra̱ Jesús bi hya̱n'ʉ cʉt'a yø thu̱hmɛ̱ 'nɛ̱'ʉ yoho yø hua̱. Bi hyanma̱ hɛ̱ts'i̱ p'ʉya, bi ja ma̱mma̱di̱ Oja̱. Bi xɛnyø thu̱hmɛ̱ p'ʉya, bi u̱nyø xädi ngue di 'darpa̱ yø ja̱'i̱ da̱ zi. Da̱ guehyø hua̱ bi 'dat'i. ");
INSERT INTO otnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bi̱ nsi̱hmɛ̱ xa̱nho yø ja̱'i̱, gä bi̱ nni̱ya̱. M'mɛfa p'ʉya, bi̱ ma ma̱pɛti yø thu̱hmɛ̱ bi bongui̱, bi zʉ'i 'dɛ'ma̱yo canasta bi bongui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","N'na ndi̱ ya, bi̱ ma n'nanni̱ ra̱ Jesús ngue bá̱ mat'Oja̱, n'youi yø xädi. Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Te'ogä p'ʉ ga̱ mbɛ̱nyø ja̱'i̱ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mi̱ da̱hyø xädi p'ʉya, bi 'yɛ̱mbi̱: ―'Bʉ i'da yø ja̱'i̱ ɛ̱mbi̱ ngue gue'e grá̱ Xuua gmi̱ øtra̱ nxixya̱. Mi̱'da yø ja̱'i̱ p'ʉya, ɛ̱mbi̱ ngue gue'e grá̱ Elías. Mi̱'da yø ja̱'i̱ p'ʉya, ɛ̱mbi̱ ngue gue'e n'na'ʉ yø nyogui pønga̱hya̱ Oja̱ xpi bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ra̱ Jesús ma̱hømbi 'yɛ̱mbyø xädi: ―Xi'a̱hʉ p'ʉya, ¿te'ogä p'ʉ gni̱ bɛ̱mhmʉ ngue guecä? Ra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱'i̱, gue'e grá̱ Cristo ba̱ ɛ̱xa̱'i̱ Oja̱ ngue gui̱ nda̱st'abi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ra̱ Jesús ma̱hømbi 'yɛ̱mbi̱: ―A nu̱yá, 'yo to gui xifi te'ogä ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Bi xihyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, da̱ 'yɛ̱mmɛ̱i̱ da̱ ma ma̱'ʉni̱. Nu̱'ʉ yø ja̱'i̱ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱ da̱ zʉi, da̱ guehyø hmu̱ yø mmäcja̱, 'nɛ̱hyø xännba̱te ngue ra̱ ley, gä da̱ zʉi 'nɛ̱ da̱ hyo. Pɛ rá̱ hyu̱ pa p'ʉya di bɛ̱nna̱te ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","M'mɛfa p'ʉya, bi̱ 'yɛ̱mbi̱ gätho yø ja̱'i̱: ―Nu̱ to nne da̱ dɛnngui̱, hi̱ngui̱ sä ngue da̱ zänsɛ te da̱ n'yo. Hangu̱ ra̱ pa, hi̱nha di gohrá̱ mmʉi, ma̱da̱gue'a̱ da̱ thop'ʉ ja ra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nu̱ ra̱ ja̱'i̱ da̱ 'uegue ngue su̱ da̱ tho, guehna̱ ra̱ ja̱'i̱ di̱ m'mɛhrá̱ te na̱. Pɛ nu̱ ra̱ ja̱'i̱ hi̱ngui̱ cohrá̱ mmʉi'a̱ ga̱ 'yɛ̱c'ɛ̱i̱gui̱, ma̱da̱ tho conná̱ ngueque, guehna̱ ra̱ ja̱'i̱ di̱ nya̱nná̱ te na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Porque hi̱nte da̱ da̱hra̱ ja̱'i̱, ma̱da̱gue'a̱ da̱ 'yøt'e ngue rá̱ mmɛti gä ra̱ xi̱mhäi, 'nɛ̱ di̱ m'mɛhrá̱ te. ");
INSERT INTO otnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","A nu̱yá, nu̱ ra̱ ja̱'i̱ ngue pɛsrá̱ sä conná̱ ngueque, ogue i pɛsrá̱ sä conná̱ nguehra̱ hya̱ dí xännba̱te, xquet'a̱ da̱ 'yɛ̱hra̱ pa ngue nu̱gui̱ drá̱ N'yohʉ dá̱ ɛ̱ ma̱hɛ̱ts'i̱, xquet'a̱ ga̱ pɛs'ma̱ sä conná̱ ngue'ʉ to di jagbʉ. Guehna̱ ra̱ pa ga̱ ma pengui ngue ga̱ nda̱st'abi, conná̱ ts'ɛdi Oja̱ ga̱ ma n'yo'be yø ma̱ca̱ anxɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue nu̱ya 'da 'bʉcua ya, hi̱nda̱ du̱, asta̱ gue'mø da̱ nu̱ ngue da̱ hya̱ ra̱ ts'ɛdi Oja̱ di̱ ma̱nda ua. ");
INSERT INTO otnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ya rá̱ hya̱to ma̱ pa xi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, bi̱ map'ʉ bí ja n'na ra̱ nyu̱ni̱ ra̱ Jesús ngue bá̱ mat'Oja̱. Bi zixra̱ Bɛdu, ra̱ Jacobo, ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mɛ̱nte mmat'Oja̱ ra̱ Jesús, bi̱ mpä'a̱ gui̱ nɛ̱qui̱ rá̱ hmi̱. Rá̱ he p'ʉya, asta̱ di yoxni̱'a̱ ga̱ nt'axi. ");
INSERT INTO otnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bi hnu̱ p'ʉya, ngue 'bäp'ʉ yoho yø n'yohʉ ya̱ui. Nu̱ya p'ʉya, guehna̱ ra̱ Moisés 'nɛ̱hra̱ Elías. ");
INSERT INTO otnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","'Nɛ̱hya xquet'a̱ di yoxni̱ p'ʉ i̱ nɛ̱qui̱ ya. Nu̱p'ʉ ha bi̱ nya̱ui ra̱ Jesús, bi c'a̱'a̱ ra̱ nda̱te ja ngue da̱ni̱ nthop'ʉ Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pɛ ra̱ Bɛdu co 'nɛ̱'ʉ mi̱'da yø n'yohʉ, bi̱ n'a̱ha̱ ngue netha̱. Nu̱'mø mi̱ nnu̱hu̱, bi̱ nu̱ p'ʉya ngue di yoxni̱ p'ʉ 'bähra̱ Jesús, co 'nɛ̱'ʉ mi̱yoho yø n'yohʉ 'dap'ʉ 'bähmi̱ di yoxni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nu̱na̱ ra̱ Moisés 'nɛ̱hra̱ Elías, ya ja ngue da̱ zop'ʉ ra̱ Jesús. Pɛ ra̱ Bɛdu bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, ya xa̱nho ngue dí 'bʉhmʉ ua. Ma ga̱ hocähe hyu̱ yø t'ʉnni̱gu̱, n'na'i, n'na ra̱ Moisés, n'na ra̱ Elías ―bi 'yɛ̱mbi̱. Pɛ ra̱ Bɛdu hi̱ngui̱ pa̱di̱ te mma̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mɛ̱nte bi̱ ma̱nna̱ ra̱ hya̱ na̱, bi̱ nja n'na ra̱ gu̱i̱ ngue bi go'mi̱. Ɛ̱̱mmɛ̱i̱ bi̱ nsu̱ 'mø mi̱ go'mra̱ gu̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bi 'yø p'ʉya ngue bá̱ nya̱ Oja̱ p'ʉ ja ra̱ gu̱i̱, bi 'yɛ̱na̱: ―Nu̱na̱ 'bʉcua ya, guehna̱ ma̱ Ts'ʉnt'ʉ da̱di̱ ma̱di̱. Nu̱ya yø hya̱ da̱ ma̱nna̱ ya, da̱mi̱ 'yɛ̱t'a̱mmʉihʉ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mi̱ juadi bá̱ nya̱'a̱ ya̱ p'ʉya, bi̱ nu̱ ngue 'bäsɛ p'ʉ ra̱ Jesús. Pɛ hi̱njombi̱ xi'a̱ te bi̱ nu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mi̱ hyaxpʉya, bá̱ ɛ̱p'ʉ ja ra̱ nyu̱ni̱ ma̱mbi̱ 'bʉi. Pɛ xa̱ngu̱ yø ja̱'i̱ bi̱ ma di c'at'ui ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nu̱p'ʉ 'bʉhyø ja̱'i̱ p'ʉya, nts'ɛdi bá̱ nya̱ n'na nc'ɛ̱i̱, bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, da̱mi̱ nu̱rquits'ʉ ma̱ ts'ʉnt'ʉ 'bʉcua, porque hønna̱ dí si na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nu̱'mø bi gʉ ra̱ ts'onthi̱ n'youi, di japi ngue mafi. I hua̱qui̱ 'nɛ̱ sohyø fʉgui. Hi̱ngui̱ nne da̱ hyɛgui, ɛ̱mmɛ̱i̱ di ʉni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya xtá̱ xihni̱ xädi ngue xta̱ 'yøthe ts'ʉ, pɛ hi̱nxa̱ nzä xa̱ 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Asta̱ nja̱m'mø da̱ zønna̱ pa gui 'yɛ̱c'ɛ̱i̱ga̱hʉ? ¿Ua guí ɛ̱na̱ ngue hangu̱ ra̱ pa ga̱ sɛt'a̱hʉ? Bi t'ɛ̱mbrá̱ papá ra̱ därquɛ̱hi̱ p'ʉya: ―Bá̱ si ua ni̱ ts'ʉnt'ʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pɛ nu̱'mø ni̱ ma da̱ guatra̱ ts'ʉnt'ʉ p'ʉ 'bähra̱ Jesús, asta̱ ra̱ hua̱qui̱ bi 'yɛn'a̱ häi ra̱ ts'onthi̱. Ra̱ Jesús bi xihra̱ ts'onthi̱ n'youi ra̱ ts'ʉnt'ʉ ngue bi hyɛp'ʉ. Mi̱ zä'a̱ te mi̱ hɛ̱mbra̱ ts'ʉnt'ʉ, bi̱ ndäprá̱ papá p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Gä di 'yødyø ja̱'i̱ te bi̱ nja. Bi ba̱hyø ja̱'i̱ ngue ma̱ da̱tho ja rá̱ ts'ɛdi Oja̱. Mɛ̱nte di 'yøtho gätho yø ja̱'i̱'a̱ te bi 'yøtra̱ Jesús, bi 'yɛ̱mbyø xädi p'ʉya: ");
INSERT INTO otnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Da̱mi̱ 'yøhmʉ xa̱nho na̱ ra̱ hya̱ ga̱ xi'a̱hʉ ya. Ma̱mi̱ pu̱mbɛ̱ni̱hʉ ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ di̱ ndäpyø ts'oc'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pɛ nu̱'ʉ yø xädi hi̱mbi̱ di̱nyø mmʉi na̱ ra̱ hya̱ xifi, porque tobe hi̱ngui̱ xojpa̱bi̱ Oja̱ yø mmʉi ngue da̱ ba̱'a̱ xifi. I su̱ yø xädi da̱ 'yänni̱ te ga̱ mbøn'a̱ ra̱ hya̱ mma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nu̱'ʉ yø xädi ra̱ Jesús di̱ nju̱n'ma̱hya̱ n'na ngu̱ n'na, porque n'na ngu̱ n'na nne ngue ma̱ da̱tho da̱ hnu̱ ma̱nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pɛ bi ba̱hra̱ Jesús te mbɛ̱mp'ʉ ja yø mmʉi yø xädi. Bi zonhna̱ n'na ra̱ ba̱si̱, bi 'bämbʉ ha 'bäi. ");
INSERT INTO otnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bi 'yɛ̱mbʉya: ―Nu̱ ra̱ ja̱'i̱ di ja mma̱nsu̱ na̱ ra̱ ba̱si̱ 'bʉcua ya, ngu̱na̱ da̱ 'yøt'e porque pa̱hra̱ ja̱'i̱ ngue nu̱ te øt'e, gue'a̱ dí̱ nnu̱ ma̱nho ngue da̱ 'yøt'a̱, ɛ̱ntho go di ja mma̱nsu̱ gra̱ ja̱'i̱. Nu̱ ra̱ ja̱'i̱ di ja ma̱nsu̱gui̱, ɛ̱ntho go di ja mma̱nsu̱'a̱ to bá̱ pɛnngui̱. Gätho'a̱hʉ ya, nu̱'a̱ da̱ t'ɛ̱mbi̱ ngue hi̱nte di̱ mu̱ui ya, gue'a̱ ma̱ da̱'a̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ra̱ Xuua bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, xtá̱ nu̱gähe n'na nc'ɛ̱i̱ ngue nnøn'na̱ ni̱ thu̱hu̱ ha ga̱ 'yøthe yø ja̱'i̱ n'youi yø ts'onthi̱. Pɛ xtá̱ hɛjpa̱he, porque hi̱ndi̱ n'yohʉ p'ʉ nná̱ mähä. ");
INSERT INTO otnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ra̱ Jesús bi 'yɛ̱mbi̱: ―'Yo ga̱di hɛjpa̱hʉ yø ja̱'i̱ nnønnga̱gui̱ ma̱ thu̱hu̱, porque nu̱ya hi̱ngui̱ sʉcjʉ, ma̱ n'yohʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ma̱n'na, ma̱n'na ni̱ guatra̱ pa ngue da̱ ma ma̱hɛ̱ts'i̱ ra̱ Jesús. Bi hya̱ ra̱ ts'ɛdi p'ʉya ngue di̱ ma Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bi 'bɛt'o 'da yø amigo ngue xta̱ni̱ 'yähra̱ nt'ɛ̱di̱ ha da̱ni̱ nsäya. Mi̱ zømp'ʉ ja n'na ra̱ hni̱ni̱ jap'ʉ ja ra̱ häi Samaria, bi̱ ne ngue ja xta̱ni̱ 'yäp'ʉ ra̱ nt'ɛ̱di̱ xti̱ n'oxi. ");
INSERT INTO otnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pɛ yø mmɛ̱ngu̱ Samaria hi̱mbi̱ nepe xti̱ n'oxi, porque pa̱di̱ ngue da̱ thotho di̱ ma Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nu̱'ʉ yø xädi ra̱ Jesús, ra̱ Jacobo 'nɛ̱hra̱ Xuua, mi̱ nu̱ ngue ya hi̱mbi t'u̱nna̱ ts'äya. Bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿ua guí̱ nne ga̱ ähmʉ ngue da̱ tähyø sibi ma̱hɛ̱ts'i̱ ngue di juadi, tengu̱tho bi 'yøtra̱ pønga̱hya̱ Elías? ");
INSERT INTO otnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bi hyɛ̱t'ʉ ya̱ui ra̱ Jesús, bi hɛjpi, bi 'yɛ̱mbi̱: ―Nu̱'a̱ui hi̱nguí̱ pa̱hmi̱ ngue hi̱ngui̱ ho na̱ ra̱ hya̱ guí̱ mma̱mmi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Porque ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, hi̱mbi̱ 'yɛ̱hɛ̱ ngue di juahyø ja̱'i̱, sinoque bí 'yɛ̱hɛ̱ ngue da̱ ya̱ni̱. I̱ ma ma̱n'na ra̱ hni̱ni̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mɛ̱nte ni̱ 'yop'ʉ ja ra̱ 'yu̱ p'ʉya, n'na ra̱ n'yohʉ bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ hmu̱, nu̱gä dí̱ nne ga̱ mmɛ hapʉ gdi̱ ma ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ra̱ Jesús bi 'yɛ̱mp'a̱ ya̱ui: ―Nu̱ yø haho ja yø 'bido ngue säya. Yø ts'ints'ʉ ja yø 'bafi ngue säya. Pɛ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ hi̱n'yʉ rá̱ ngu̱ ha di̱ n'oxi. ");
INSERT INTO otnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bi 'yɛ̱mba̱ n'na nc'ɛ̱i̱ ra̱ Jesús: ―Ma ga̱ mmɛp'ʉ nná̱ magä ―bi 'yɛ̱mbi̱. Pɛ nu̱'a̱ ts'o p'ʉya, bi 'yɛ̱na̱: ―Ague grá̱ hmu̱, da̱mi̱ 'dacra̱ nt'ɛ̱di̱ ngue 'be da̱ du̱ ma̱ papá ga̱ ägui. Ya da̱ zä ga̱ mmɛ p'ʉya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ra̱ Jesús bi 'yɛ̱mp'a̱ ya̱ui: ―Nu̱'ʉ yø ja̱'i̱ ɛ̱ntho ya xa̱ ndu̱ ngue hi̱ngui̱ pa̱ Oja̱, gue'ʉ da̱ 'yähyø mmi̱ndu̱ui'ʉ. Pɛ nu̱'i̱, ma ga̱ mmɛhma̱, n'namhma̱ gui xihyø ja̱'i̱ ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma̱hømbi 'yɛ̱n ma̱n'na nc'ɛ̱i̱ p'ʉya: ―Ague grá̱ hmu̱, nu̱gä dí̱ nne ga̱ mmɛ, pɛ da̱mi̱ 'dacra̱ nt'ɛ̱di̱ ngue 'be ga̱ ma ɛ̱'ʉ bí 'bʉp'ʉ ja ma̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱'a̱ bi bɛntra̱ t'abi nda̱ni̱ ngue di̱ nua̱fani̱, 'nɛ̱ cohrá̱ mmʉi m'mɛfa, gue'a̱ ya hi̱ngrá̱ nzäui da̱ ma̱ ha di̱ njap'ʉ di̱ zo rá̱ 'yɛ Oja̱ yø ja̱'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","M'mɛfa p'ʉya, nu̱na̱ ra̱ Hmu̱, bi huanhni̱ hya̱te ma̱'dɛt'a nja̱'i̱, bi̱ mɛnhni̱ di̱ m'mɛt'o p'ʉ di̱ ma. Yø yonc'ɛ̱i̱ p'ʉ da̱ ma n'na ngu̱ n'na, i̱ map'ʉ ja yø hni̱ni̱ ja ngue da̱ni̱ nthohra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bi 'yɛ̱mbʉya: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue ra̱ 'bɛfi xa̱ngu̱ i ja, pɛ yø mɛfi zi yohotho 'bʉi. Ja̱na̱ngue nu̱yá, da̱mi̱ 'yäphʉ na̱ Oja̱ rá̱ mmɛti ra̱ 'bɛfi, ngue da̱ mɛnhyø mɛfi p'ʉ ja rá̱ 'bɛfi. ");
INSERT INTO otnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nu̱ya gui̱ mmähä ya. Pɛ da̱mi̱ mfähmʉ, porque gui cʉthʉ p'ʉ 'bʉhyø ja̱'i̱ ngue yø ndu̱c'ɛ̱i̱, tengu̱tho yø dɛ'yo 'mø 'yop'ʉ ha 'bʉhyø zate, gui̱ njathʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'Yo tema̱ bolsa gui ca̱xʉ, 'yo tema̱ njʉmɛ̱nyu̱ gui ca̱xʉ. 'Yo gui cʉx hmi̱'da ni̱ thi̱xfani̱hʉ. 'Yo to di ot'a̱hʉ 'mø gá̱ nzɛnguahʉ p'ʉ ja ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nu̱'mø gá̱ sømp'ʉ ja n'na ra̱ ngu̱, gui zɛnguate 'mø gá̱ cʉthʉ mbo. Gui 'yɛ̱na̱: “Oja̱ di ja̱pra̱ ngu̱ ja ua ya”. ");
INSERT INTO otnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nu̱'mø 'bʉp'ʉ yø ja̱'i̱ ngue nneprá̱ nja̱pi̱ Oja̱, nu̱'a̱ ra̱ nzɛngua ga̱di̱ u̱ni̱ ngue Oja̱ di ja̱pyø ja̱'i̱, da̱ gohmi̱ ra̱ nzɛngua. Pɛ nu̱'mø hi̱ngui̱ nne yø ja̱'i̱, ya hi̱n'na̱ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Da̱mi̱ nsäya p'ʉ ja ra̱ ngu̱ gui sømhmʉ. Da̱mi̱ sihʉ'a̱ te si yø ja̱'i̱ 'bʉp'ʉ. Porque ni̱ 'yu̱p'ʉ ngue di t'u̱nná̱ nzäbi ra̱ mɛfi. 'Yo høntho gui pøn'a̱ n'na ra̱ ngu̱, gni̱ mpa ma̱n'na ra̱ ngu̱. Nu̱'a̱, hi̱n'na̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nu̱'mø bi̱ n'na'a̱hʉ ra̱ ts'äya p'ʉ ja ra̱ hni̱ni̱ gui sømhmʉ, da̱mi̱ si'a̱ te di̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gui 'yøthehʉ yø därquɛ̱hi̱ di 'bʉp'ʉ. Gui 'yɛ̱mhmʉ: “Nu̱yá, ya guep'ʉ gui pa̱hmʉ ha gdi sohʉ rá̱ 'yɛ Oja̱ ya”. ");
INSERT INTO otnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pɛ nu̱'mø hi̱mbi̱ n'na'a̱hʉ ra̱ ts'äya p'ʉ ja ra̱ hni̱ni̱ gui sømhmʉ, gui 'yɛ̱m'mø ga̱ thohmʉ p'ʉ ja yø caye: ");
INSERT INTO otnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Dá̱ hua̱mbʉ ja ra̱ hni̱ni̱ yø fonthäi bá̱ n'youi ma̱ mbonguahe. Gue'a̱ ra̱ hmɛ̱ya'a̱ ngue ya dá̱ thɛc'a̱hʉ p'ʉ. Pɛ da̱mi̱ pa̱hmʉ ngue ya mi̱ ja ngue xta̱ si'a̱hʉ ha gdi sohʉ rá̱ 'yɛ Oja̱”, gui 'yɛ̱mphʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dí xi'a̱hʉ ngue nu̱'mø ra̱ pa da̱ni̱ tha̱xra̱ güɛnda, ma̱n'na xa̱n'ʉ ra̱ castigo da̱ thohya yø ja̱'i̱ hi̱mbi̱ u̱nna̱ ts'äya, ngue'a̱ ra̱ castigo da̱ tho'ʉ yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Sodoma. ");
INSERT INTO otnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hague ngu̱ ra̱ castigo da̱ thohyø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Corazín. Hague ngu̱ ra̱ castigo da̱ thohyø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Betsaida. Porque hi̱mbi̱ 'yɛ̱c'ɛ̱i̱gui̱ 'mø mi̱ nu̱ yø milagro dá̱ ørbʉ 'bʉi. A nu̱'mø xta̱ nnu̱ yø milagro yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ nyogui hni̱ni̱ Tiro, 'nɛ̱p'ʉ ja ra̱ hni̱ni̱ Sidón, n'nahma̱ntho xta̱ hyɛp'ʉ ra̱ nts'o ma̱ni̱ n'yo yø ja̱'i̱. Xti̱ n'yʉxyø 'bospi, 'nɛ̱ xta̱ hye yø he yø ja̱'i̱ nu̱'a̱ xti̱ nɛ̱qui̱ ngue 'bʉ ndu̱mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pɛ nu̱'mø ra̱ pa da̱ni̱ tha̱xra̱ güɛnda, ma̱n'na xa̱ngu̱ ra̱ castigo da̱ thohyø ja̱'i̱ fɛsta̱ ra̱ hya̱ ya, ngue'a̱ ra̱ castigo da̱ thohyø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Tiro 'nɛ̱p'ʉ ja ra̱ hni̱ni̱ Sidón. ");
INSERT INTO otnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A nu̱'ʉ yø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Capernaum, rá̱ nzɛgui ɛ̱na̱ ngue da̱ t'ɛ̱spa̱bi̱ p'ʉ ma̱hɛ̱ts'i̱, 'nɛ̱cua ja ra̱ häi da̱ t'ɛ̱spi̱. Pɛ gue di̱ map'ʉ ja ra̱ ni̱du̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bi 'yɛ̱mbyø xädi ra̱ Jesús: ―Nu̱'ʉ yø ja̱'i̱ da̱ ne da̱ 'yøhra̱ hya̱ gui xihmʉ, tengu̱tho 'mø go da̱ 'yørca̱sɛ ma̱ hya̱gä'ʉ. Nu̱ te'o hi̱nda̱ nu̱ ma̱nho'a̱hʉ, tengu̱tho 'mø ngue go hi̱ngui̱ nnu̱ ma̱nho gra̱ ja̱'i̱. Nu̱'a̱ to hi̱ngui̱ nnu̱ ma̱nhogui, tengu̱tho 'mø ngue go hi̱ngui̱ nnu̱ ma̱nho'a̱ to bá̱ pɛngui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma̱mbá̱ penc'ʉ hya̱te ma̱'dɛt'a nja̱'i̱ bi 'bɛnhni̱, ɛ̱mmɛ̱i̱ di johya. I ɛ̱na̱: ―Ague grá̱ Hmu̱, nu̱'mø dá̱ nøngähe ni̱ thu̱hu̱, asta̱ 'nɛ̱hyø ts'onthi̱ n'youi yø ja̱'i̱ hɛp'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Gue'a̱ guí̱ mma̱mmi̱. Dá̱ nu̱gä ra̱ Satanás ngue gá̱ ta̱phʉ, bi̱ ma häi tengu̱tho ra̱ huɛi 'mø ni̱ ga̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nu̱gä dá̱ 'da'a̱hʉ ra̱ ts'ɛdi ngue ma̱da̱gue'a̱ gui̱ nnɛ̱shʉ yø c'ɛ̱ya̱ 'nɛ̱ gui nnɛ̱shʉ yø ixtehe, pɛ hi̱nte da̱ ja'a̱hʉ. 'Nɛ̱ gui ta̱phʉ gätho rá̱ ts'ɛdi na̱ ra̱ zithu̱ ma̱ nsʉihʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pɛ 'yo ga̱di johyahʉ ngue høntho gui̱ nnønnga̱hʉ ma̱ thu̱hu̱gä, 'bexi hɛp'ʉ yø ts'onthi̱ n'youi yø ja̱'i̱. Sinoque nu̱'a̱ gdi johyahʉ, ngue bi̱ nt'ot'i ni̱ thu̱hu̱hʉ p'ʉ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, ra̱ Espíritu Santo bi japi ngue ɛ̱mmɛ̱i̱ di johya ra̱ Jesús. Bi 'yɛ̱na̱: ―Ma̱ Papá'i, da̱di ja ma̱mma̱di̱'i̱ grá̱ Hmu̱ p'ʉ ma̱hɛ̱ts'i̱, grá̱ Hmu̱ ua ja ra̱ xi̱mhäi. Porque yø ja̱'i̱ ɛ̱na̱ ngue yø ba̱mhya̱, i ɛ̱na̱ ngue ti̱ni̱ xa̱nho yø mmʉi hanja ra̱ hya̱, pɛ gá̱ 'ya̱jpa̱bi̱ ya yø hya̱ ya. Gá̱ japi ngue go bi ba̱hya yø ja̱'i̱ ngue yø 'yøde tengu̱tho yø ba̱si̱ ngue yø 'yøde. Ngu̱na̱ gá̱ 'yøt'e ma̱ Papá'i, porque gue'a̱ guá̱ sänni̱ ngue di̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ma̱ Papágä bi däqui gätho yø cosa ngue ga̱ ma̱nda. Hi̱njongui̱ pøni̱ ngue da̱di̱ mpa̱hmi̱ xa̱nho'a̱ rá̱ Ts'ʉnt'ʉ Oja̱, sinoque hønsɛ'a̱ rá̱ Papá di̱ mpa̱hmi̱. Hi̱njongui̱ pøni̱ ngue da̱di̱ mpa̱hmi̱'a̱ ra̱ Papá, sinoque hønsɛ'a̱ rá̱ Ts'ʉnt'ʉ di̱ mpa̱hmi̱. Nu̱ ra̱ ja̱'i̱ da̱ neprá̱ Ts'ʉnt'ʉ Oja̱ ngue da̱ ba̱di̱ te'o na̱ ra̱ Papá, ya da̱ zä da̱ ba̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bi hyɛ̱tyø xädi p'ʉya, bi 'yɛ̱msɛbi: ―Bi toca'a̱hʉ ra̱ mmɛ̱nthi̱ ngue gá̱ nu̱sɛ conni̱ dähʉ'a̱ te guí̱ nnu̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Porque dí xi'a̱hʉ ngue yø pa xa̱ thogui, xa̱ngu̱ yø pønga̱hya̱ Oja̱ xa̱ m'mʉi, 'nɛ̱hyø da̱st'abi xa̱ m'mʉi, bi ne xta̱ nnu̱'a̱ te guí̱ nnu̱hʉ ya, pɛ hi̱mbi zä bi̱ nu̱. Bi̱ ne xta̱ 'yø'a̱ ra̱ hya̱ guí øhmʉ ya, pɛ hi̱mbi zä bi 'yøde. ");
INSERT INTO otnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nu̱'a̱ n'na ra̱ xännba̱te ngue ra̱ ley p'ʉya, bi guat'i ngue thämma̱hya̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ¿te 'bɛ'a̱ ja ngue ga̱ øt'e para ngue ga̱ ti̱nna̱ te para za̱ntho? ");
INSERT INTO otnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Teni̱ 'bɛ'a̱ nt'ot'i p'ʉ ja rá̱ ley Oja̱? ¿Tema̱ hya̱ guí ti̱m'mø ga̱di xädi? ");
INSERT INTO otnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nu̱'a̱ ra̱ xännba̱te ngue ra̱ ley p'ʉya, bi 'yɛ̱na̱: ―Nu̱na̱ ra̱ hya̱ na̱, guehna̱ ɛ̱na̱: “Da̱mi̱ ja ndu̱mmʉi ngue ma̱thoguitho gui̱ ma̱hmʉ Oja̱ co gätho ni̱ mmʉihʉ. Ha̱ngu̱ ra̱ pa hønt'a̱ gui̱ mbɛ̱mhmʉ'a̱. 'Nɛ̱ da̱mi̱ ma̱hni̱ mmi̱c'ɛ̱i̱ui tengu̱tho gni̱ ne ngue di̱ ma ma̱ma̱di̱'i̱”, i ɛ̱nna̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xa̱nho te guí̱ mma̱. Da̱mi̱ 'yøt'e tengu̱tho ra̱ hya̱ guí̱ mma̱nya n'namhma̱ ngue gui ti̱nna̱ te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pɛ nu̱na̱ ra̱ xännba̱te ngue ra̱ ley, i ɛ̱na̱ ngue ya gue'a̱ te øt'e ngue hi̱nga̱ gätho yø ja̱'i̱ 'da gui̱ ma̱tho. Ja̱na̱ngue bi 'yɛ̱mbra̱ Jesús: ―Pɛ, ¿ndana̱ gue'a̱ ma̱ mmi̱c'ɛ̱i̱'be p'ʉya? ");
INSERT INTO otnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―N'na ra̱ n'yohʉ bá̱ hya̱ ra̱ 'yu̱ xpi 'yɛ̱'a̱ Jerusalén, ni̱ map'ʉ ja ra̱ hni̱ni̱ Jericó. Bi̱ nthɛui yø bɛ̱, bi hya̱nnba̱bi̱'a̱ te mi̱ ha̱, asta̱ bi̱ møjpe. Bi ʉni̱, bi zop'ʉ p'ʉya. Ya sä ra̱ nda̱te 'mø mi̱ zop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi thop'ʉ ja ra̱ 'yu̱ n'na ra̱ mmäcja̱. Bi̱ nu̱ ngue 'bɛmp'ʉ ra̱ n'yohʉ sä ra̱ n'ʉ. Bi̱ mäqui, i gäta̱ n'na nguadi, bi thogui. ");
INSERT INTO otnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Xquet'a̱ bi thop'ʉ n'na ra̱ n'yohʉ mi̱ ja rá̱ 'bɛfi p'ʉ ja ra̱ ni̱ja̱. Nu̱'mø mi̱ nu̱'a̱ sä ra̱ n'ʉ, bi̱ mäqui, bi thogui. ");
INSERT INTO otnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pɛ nu̱na̱ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ häi Samaria, bi thop'ʉ ja ra̱ 'yu̱. Mi̱ nu̱ ngue 'bɛmp'ʉ na̱ xi̱ ma ma̱'ʉni̱, bi huɛ̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bi guarbʉ bɛnna̱ n'yohʉ p'ʉya, bi gospa̱bi̱ ra̱ aceite, 'nɛ̱hra̱ vino bi gospa̱ p'ʉ xi ts'ɛrpi. Bi du̱rpa̱bi̱ rá̱ ts'ɛt'i. Bi 'yɛ̱xpʉ ja rá̱ fani̱ p'ʉya, bi zits'i ngue da̱ hyonnbi̱ ha di̱ nsäya. Bi̱ mädi. ");
INSERT INTO otnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mi̱ hyaxpʉya, nu̱na̱ ra̱ mmɛ̱ngu̱ Samaria 'mø ya ja ngue da̱ ma, bi hya̱'i yoho yø mɛ̱nyu̱ nu̱ya di̱ nthɛui n'na pa ra̱ nzäbi n'na mmɛ̱nyu̱. Bi u̱nna̱ mmɛ̱nni̱gu̱, bi 'yɛ̱mbi̱: “Da̱mi̱ färquits'ʉ na̱ ra̱ n'yohʉ 'bʉcua. Nu̱'mø hi̱ndi̱ gua'i na̱ ra̱ mɛ̱nyu̱ ja ua, ma̱n'na xa̱ngu̱ gui ʉni̱, ga̱ ju̱t'a̱'i̱ 'mø dá̱ pengui̱ te gui ʉni̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Xiya, ¿ndana̱ gue'a̱ ya hyu̱ nc'ɛ̱i̱ di̱ nɛ̱qui̱ ngue rá̱ mmi̱c'ɛ̱i̱ui na̱ ra̱ n'yohʉ bi ʉnyø bɛ̱ ya? ");
INSERT INTO otnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nu̱'a̱ ra̱ xännba̱te ngue ra̱ ley p'ʉya bi 'yɛ̱na̱: ―Nu̱'a̱ bi huɛ̱qui̱, gue'a̱ rá̱ mmi̱c'ɛ̱i̱ui'a̱. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ni̱ ma ya, da̱mi̱ 'yøt'e tengu̱tho na̱ ra̱ hya̱ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bi thop'ʉ ma̱ni̱ ma ra̱ Jesús, bi zømp'ʉ ja n'na ra̱ hni̱ni̱. Nu̱p'ʉ ja ra̱ hni̱ni̱ bi zøni̱, 'bʉp'ʉ n'na ra̱ xisu ni̱ hu̱ ngue ra̱ Marta. Nu̱p'ʉ ja rá̱ ngu̱ na̱, bi säyabi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nu̱na̱ ra̱ Marta, 'bʉ'a̱ n'na rá̱ ju̱huɛ ni̱ hu̱ ngue ra̱ Ma̱ya. Nu̱na̱ ra̱ Ma̱ya bi̱ mi̱p'ʉ ni̱ hyandra̱ Jesús ngue øxra̱ hya̱ xihyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pɛ ra̱ Marta hu̱mbi̱ di̱ mpɛtho. Bi guarbʉ hu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿ua xa̱nho te ør'ma̱ ju̱huɛ ngue hi̱ndi̱ zɛqui? Da̱mi̱ xifi ngue da̱ mäxqui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbra̱ Marta: ―Ague Marta, ague Marta, hi̱nguí̱ pa̱di̱ te gui 'yøt'e. Ja̱njua̱ni̱ gui ho ni̱ mmʉi'a̱ te gä ja ngue gui 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pɛ hønda̱ n'na ra̱ hya̱ ja ngue ma̱ da̱tho di̱ mporta. Nu̱na̱ ra̱ Ma̱ya xa̱ huanhna̱ hya̱ nu̱'a̱ ma̱ da̱tho di̱ mporta 'nɛ̱ hi̱njonda̱ hya̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ma̱n'na ra̱ ora p'ʉya, nu̱na̱ ra̱ Jesús mi̱ mmat'Oja̱ p'ʉ ja n'na ra̱ xɛqui. Mi̱ juadi bi̱ mat'Oja̱ p'ʉya, nu̱'a̱ n'na'ʉ yø xädi bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, da̱mi̱ xännga̱he ra̱ mhmat'Oja̱, tengu̱tho ra̱ Xuua bi xännbi̱ da̱ mat'Oja̱ yø xädi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'mø guí̱ mmat'Oja̱hʉ, gui 'yɛ̱mhmʉ: “Ma̱ Papá'a̱he guí 'bʉ ma̱hɛ̱ts'i̱, da̱mi̱ 'yøt'e ngue da̱ hnu̱ ma̱nsu̱'i̱. Bá̱ ɛ̱hɛ̱ gui̱ ma̱nda ua. Di̱ nja'a̱ te ni̱ pähä ua ja ra̱ xi̱mhäi tengu̱tho bí ja ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Da̱mi̱ 'dacje ra̱ hmɛ̱ n'na pa ngu̱ n'na pa. ");
INSERT INTO otnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Nɛ̱ da̱mi̱ pu̱nnga̱ ma̱ ts'oquihe, tengu̱tho gähe xquet'a̱ da̱di pu̱nnba̱he to hi̱ngui̱ ho te ørca̱he. Da̱mi̱ fäxca̱he ngue hi̱nga̱ øt'ähe ra̱ nts'o. Da̱mi̱ ya̱nje ngue ra̱ nts'o”. ");
INSERT INTO otnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ra̱ Jesús bi sigue bi 'yɛ̱mbi̱: ―Xi'mø ngue n'na ra̱ n'yohʉ ga̱di̱ n'amigo n'na'a̱hʉ ya. Nu̱'mø ma̱de ra̱ xu̱i̱ p'ʉya, da̱ zømp'ʉ ja rá̱ ngu̱ rá̱ amigo, da̱ 'yɛ̱mbi̱: “Ague ma̱ amigo'i, da̱mi̱ hmi̱qui hyu̱ yø thu̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Porque n'na ma̱ amigo bi zøp'ʉ ja ma̱ ngu̱, jap'ʉ xpi 'yɛ̱hɛ̱. Pɛ hi̱n'yʉ te ga̱ u̱nni̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nu̱'a̱ ts'o p'ʉya, da̱ 'yɛ̱ntho 'mø bá̱ tha̱'a̱ mbo rá̱ ngu̱: “'Yo ga̱di xu̱na̱nyagui. Ya n'nøt'e ma̱ goxthi. Ma̱ ba̱si̱ ya xa̱ 'yoi. Ya hi̱nda̱ zä ga̱ nnangui̱ ga̱ 'da'i'a̱ guí ädi”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma̱da̱gue'a̱ ngue rá̱ amigo, pɛ hi̱ngui̱ nne da̱ nangui̱ ngue di u̱nni̱ te honi̱. Pɛ nu̱gä dí xi'a̱hʉ ngue da̱ nanghma̱, di u̱nni̱ te gä honi̱, n'namhma̱ ngue ya hi̱nni̱ mantho di xu̱na̱nya. ");
INSERT INTO otnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ja̱na̱ngue nu̱gä dí xi'a̱hʉ, nu̱na̱ Oja̱ di 'da'i te guí homhmʉ. Da̱mi̱ 'yäpi te guí̱ nnehʉ. Nu̱ te gui honi̱, gui ti̱ni̱. Nu̱'mø gá̱ jätra̱ goxthi ngue gui̱ nzohmʉ Oja̱, da̱ xoc'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porque nu̱ ra̱ ja̱'i̱ ädi te nne, ma̱ t'u̱nni̱. Nu̱'a̱ honi̱, i ti̱ni̱. Nu̱'a̱ di jätra̱ goxthi, i sojpi. ");
INSERT INTO otnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Conque nu̱ ra̱ ja̱'i̱ 'bʉhrá̱ ba̱si̱, nu̱'mø bi 'yäpra̱ thu̱hmɛ̱, hi̱ngui̱ sä rá̱ mmʉi ra̱ ja̱'i̱ ngue ra̱ do di u̱nná̱ ba̱si̱. Ogue ra̱ hua̱ da̱ 'yäprá̱ ba̱si̱, hi̱ngra̱ c'ɛ̱ya̱ di u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ogue ra̱ do'ni̱ da̱ 'yäprá̱ ba̱si̱, hi̱ngra̱ ixtehe di u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A nu̱yá, i ja ni̱ ts'oquihʉ, pɛ guí pa̱di̱ gui u̱nna̱ cosa xa̱nho ni̱ ba̱si̱hʉ. Nu̱'a̱ ni̱ Papáhʉ bí 'bʉ ma̱hɛ̱ts'i̱ ya, ma̱n'natho'a̱, nu̱'mø te'o da̱ 'yäpra̱ Espíritu Santo, da̱ pɛnnba̱bi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nu̱na̱ ra̱ Jesús bi 'yøthe n'na ra̱ n'yohʉ ma̱di gonebi ra̱ ts'onthi̱ mi̱ n'youi. Nu̱'mø mi̱ hyɛp'ʉ ra̱ ts'onthi̱ mi̱ n'youi ra̱ n'yohʉ, bi̱ nya̱ p'ʉya. Yø ja̱'i̱ p'ʉya di 'yøtho. ");
INSERT INTO otnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pɛ ɛ̱n'i'da yø ja̱'i̱: ―Nu̱na̱ ra̱ n'yohʉ na̱, øthe yø ja̱'i̱ n'youi yø ts'onthi̱, pɛ gue gue'a̱ ra̱ zithu̱ rá̱ hmu̱ yø ts'onthi̱ fäts'i ngue jap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mi̱'da yø ja̱'i̱ p'ʉya, bi xifi ngue nu̱nʉ ma̱hɛ̱ts'i̱ xta̱bá̱ 'yøtyø hmɛ̱ya hi̱njongui̱ sä da̱ 'yøt'e, para ngue da̱ ba̱hyø ja̱'i̱ ngue Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ di u̱nna̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pɛ ra̱ Jesús gä pa̱tho te mbɛ̱nyø ja̱'i̱, bi 'yɛ̱mbi̱: ―Xip'ʉ di̱ ma̱nda n'na ra̱ da̱st'abi, nu̱'mø di̱ ndu̱nhyø ja̱'i̱, hi̱nja̱m'mø da̱ zä da̱ zɛhyø hya̱. Xip'ʉ ja n'na ra̱ ngu̱ ya, nu̱'mø di̱ nsʉsɛ yø ja̱'i̱ 'bʉp'ʉ, da̱ 'yɛ̱hra̱ pa di̱ n'uɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Njarbʉtho na̱ ra̱ hya̱ dí xi'a̱hʉ ya. Xi'mø ngue di hɛjpa̱sɛ yø mɛfi ra̱ zithu̱, ya rá̱ 'bɛfisɛ di ts'oni̱. Dí̱ mma̱ngä na̱ ra̱ hya̱ na̱ ngue guí ɛ̱njʉ ngue ra̱ zithu̱ fäxca̱'mø dí øthegä yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A nu̱'mø ngue ngu̱'a̱, xi ni̱ mmi̱judíohʉ tɛnna̱ hya̱ guí xännba̱tehʉ, ¿ua ra̱ zithu̱ fäx'mø øthe yø ja̱'i̱ n'youi yø ts'onthi̱? Nu̱yá, ja di̱ nɛ̱qui̱ p'ʉya ngue guí ya̱ xädähʉ, hi̱nguí̱ pa̱di̱ te guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pɛ xi'mø ngue di 'dacra̱ ts'ɛdi Oja̱ ngue ga̱ øthegä yø ja̱'i̱ n'youi yø ts'onthi̱, ja di̱ nɛ̱qui̱ p'ʉya, ngue ya di̱ ma̱nda ua Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Hi̱ngra̱ zithu̱ øthe yø ja̱'i̱ n'youi yø ts'onthi̱. Xi'mø ngue n'na ra̱ n'yohʉ xa̱nzaqui, cʉ yø juai gui̱ mfäp'ʉ ja rá̱ ngu̱, hi̱nte da̱ ja'a̱ te fädi. ");
INSERT INTO otnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pɛ nu̱'mø bá̱ ɛ̱p'ʉ ma̱n'na ra̱ n'yohʉ ngue ma̱n'na xta̱ nzaqui, da̱ da̱pi̱, da̱ gʉnnba̱bi̱ yø juai gui̱ mfädi. Ya rá̱ mmɛti'a̱ te da̱ hya̱nnbi̱. Di̱ njadä p'ʉya, ta̱te xa̱ nzaquigui ngue ra̱ zithu̱, ja̱na̱ngue sä dí øthe yø ja̱'i̱ n'youi yø ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nu̱ ra̱ ja̱'i̱ hi̱ngui̱ nne ngue ma̱ n'yo'be, guehna̱ ra̱ ja̱'i̱ rá̱ n'youi ma̱ nsʉi'be na̱. Nu̱ ra̱ ja̱'i̱ hi̱ngui̱ fäxqui ngue ga̱ ør'be ra̱ 'bɛfi, guehna̱ ra̱ ja̱'i̱ di ts'onga̱tho ma̱ 'bɛfi na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nu'mø bi hyɛp'ʉ ra̱ ts'onthi̱ n'youi ra̱ ja̱'i̱, nu̱p'ʉ ja ra̱ xɛqui ma̱thoguitho xa̱ 'yot'i, ja bí 'yop'ʉ ra̱ ts'onthi̱, honi̱ ha di̱ nsäya. Pɛ nu̱'mø hi̱mbi̱ di̱ni̱ ha di̱ nsäya, di̱ n'yomfɛ̱ni̱ p'ʉya, i ɛ̱na̱: “Ga̱ pengä p'ʉ ja ma̱ ngu̱ dá̱ pøni̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nu̱'mø bá̱ pengbʉya, da̱ di̱nnba̱bi̱ rá̱ mmʉi ra̱ ja̱'i̱ ngue hi̱njongui̱ 'bʉp'ʉ, tengu̱tho n'na ra̱ ngu̱ ngue ma̱hoqui xa̱nho, i̱ njoqui. ");
INSERT INTO otnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Da̱ mengbʉya, da̱ si mi̱ yoto yø ts'onthi̱ ma̱n'na xa̱nts'o ngue'a̱ ra̱ ts'onthi̱ rá̱ mʉdi. Gä da̱ yʉrbʉ ja rá̱ mmʉi ra̱ ja̱'i̱ ngue di̱ m'mʉp'ʉ. M'mɛfa p'ʉya, ma̱n'na di̱ m'mʉ ma̱n'ʉ ra̱ ja̱'i̱ ngue'a̱ te ra̱ n'ʉ mi̱ sä m'mɛt'o. ");
INSERT INTO otnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nu̱na̱ ra̱ Jesús, mɛ̱nte mma̱nya yø hya̱ ya, nu̱p'ʉ ha 'bʉhyø ja̱'i̱, bá̱ tha̱'a̱ n'na ra̱ xisu, bi 'yɛ̱mbi̱: ―Ra̱ mmɛ̱nthi̱ bi̱ nthɛui ra̱ xisu bi øn'a̱'i̱, 'nɛ̱ bi sʉt'a̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ɛ̱m'mø mi̱ da̱hra̱ Jesús: ―Ma̱ da̱tho ra̱ mmɛ̱nthi̱ bi̱ nthɛui ya yø ja̱'i̱ di ho da̱ 'yøxra̱ hya̱ mma̱n'Oja̱, nu̱'a̱ te ra̱ hya̱ øde, gue'a̱ øt'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma̱n'na ni̱ mpɛtitho yø ja̱'i̱ p'ʉ 'bähra̱ Jesús. Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱ yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya, yø ts'oc'ɛ̱i̱. 'Bet'o äcyø milagro da̱ nu̱, ja da̱ 'yɛ̱c'ɛ̱i̱gui̱. Pɛ hi̱n tema̱ milagro ga̱ øt'e ngue da̱ nu̱ yø ja̱'i̱. Nu̱'a̱ da̱ nøpa̱ hmɛ̱ya yø ja̱'i̱ ya, gue'a̱ te bi thohra̱ pønga̱hya̱ Jonás. ");
INSERT INTO otnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Porque tengu̱tho ra̱ Jonás, nu̱'a̱ te bi tho'a̱, gue'a̱ bi nøpa̱ hmɛ̱ya yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Nínive'a̱. Njarbʉtho ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ya, nu̱'a̱ te da̱ tho'a̱, gue'a̱ da̱ nøpa̱ hmɛ̱ya yø ja̱'i̱ 'bʉhra̱ pa jap'ʉ'a̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nu̱'mø ra̱ pa ngue da̱ni̱ hya̱xra̱ güɛnda Oja̱ p'ʉya, nu̱'a̱ n'na ra̱ xisu mi̱ nda̱st'abi p'ʉ sur, da̱ nangui̱ ngue di ya̱pya yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya. Porque nu̱na̱ ra̱ xisu na̱, ndø yap'ʉtho rá̱ häi bi 'yɛ̱hɛ̱ ngue bi 'yøxra̱ hya̱ mi̱ pa̱hra̱ Salomón. Conque ma̱n'na dí ta̱tegä ya ngue ra̱ Salomón, pɛ hi̱nguí̱ nne gui 'yøhmʉ ra̱ hya̱ dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Da̱ gue'ʉ yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Nínive da̱ nang'mø ra̱ pa da̱ni̱ hya̱xra̱ güɛnda Oja̱, di ya̱pya yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya. Porque nu̱'ʉ yø ja̱'i̱ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱ Nínive, bi 'bätyø mmʉi 'mø mi̱ 'yø'a̱ ra̱ hya̱ bi̱ ma̱nna̱ Jonás. Conque ma̱n'na dí ta̱tegä ya ngue ra̱ Jonás, pɛ hi̱nguí̱ nne gui 'yøhmʉ ra̱ hya̱ dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hi̱ngui̱ sä ngue to di sa̱cra̱ nyot'i 'nɛ̱ da̱ 'ya̱qui̱, ogue da̱ go'mi̱ con n'na ra̱ huada. Sinoque da̱ hyøxma̱ya̱, n'namhma̱ ngue da̱ nu̱ ra̱ nyot'i yø ja̱'i̱ da̱ yʉt'a̱mbo. ");
INSERT INTO otnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nu̱'mø bi xogui xa̱nho ni̱ dähʉ ya, ya guí hɛ̱thʉ xa̱nho ra̱ nyot'i i ja. Njarbʉtho ni̱ n'yomfɛ̱ni̱hʉ ya, nu̱'mø bi xogui xa̱nho, ya gui pa̱hmʉ ndana̱ ra̱ nho gdi̱ n'yohʉ 'mø. Pɛ nu̱mø hi̱ngui̱ xogui xa̱nho ni̱ n'yomfɛ̱ni̱hʉ, ya hi̱mma̱ jua̱ni̱ guí pa̱hmʉ ndana̱ ra̱ nho gdi̱ n'yohʉ 'mø. Ya nsʉtho 'mø ngue ra̱ ts'a'bɛxu̱i̱ p'ʉ gni̱ mähä. ");
INSERT INTO otnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Njarbʉtho ya, da̱mi̱ ne ngue da̱ xohni̱ n'yomfɛ̱ni̱hʉ, n'namhma̱ ngue da̱ zä gui ti̱mhmʉ ra̱ 'yu̱ xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tengu̱tho n'na ra̱ ja̱'i̱ 'mø ha̱ ra̱ nyot'i, hɛ̱tra̱ 'yu̱ ha ni̱ ma, gui̱ njathʉ p'ʉya. Nu̱'mø ti̱nni̱ mmʉihʉ ndana̱ ra̱ nho, ya gui hyɛhmʉ p'ʉ ra̱ nts'o ngue gui̱ n'yo ma̱nhohʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nu̱'mø mi̱ juadi bi̱ nya̱ ra̱ Jesús, nu̱na̱ n'na ra̱ fariseo bi zits'i ngue da̱ nsi̱hmɛ̱ui p'ʉ ja rá̱ ngu̱. Mi̱ yʉt'a̱mbo ra̱ ngu̱ ra̱ Jesús, bi̱ mi̱p'ʉ ja ra̱ mɛ̱xa. ");
INSERT INTO otnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nu̱na̱ ra̱ fariseo p'ʉya, di 'yøtho hanja'a̱ bi 'yøtra̱ Jesús ngue hi̱mbi̱ nxʉ'yɛ 'mø mi̱ nsi̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague gyø fariseohʉ, guí pecjʉ ma̱xøts'e ra̱ vaso 'nɛ̱ ma̱xøts'e ra̱ mohi. Pɛ ma̱xøts'etho di̱ nɛ̱qui̱ ngue gyø hoja̱'i̱hʉ. Nu̱ mbo ni̱ mmʉihʉ, gyø bɛ̱hʉ, ngue hønt'a̱ te pɛs'yø ja̱'i̱ so ni̱ mmʉi gui hya̱nnba̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hi̱nguí̱ pa̱di̱ te guí̱ mma̱mhmʉ. ¿Ua hi̱nguí̱ pa̱hmʉ ngue ma̱xøts'e ma̱ do'yohʉ, Oja̱ bi hoqui, xquet'a̱ 'nɛ̱ mbo ma̱ mmʉihʉ bi hoqui? ");
INSERT INTO otnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pɛ da̱mi̱ fäxyø hyoya co nu̱'a̱ te guí pɛts'i. Ya gä da̱ gomma̱nho p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ague gyø fariseohʉ, hague ngu̱ ra̱ n'ʉ gui thohmʉ. Nu̱'a̱ ra̱ diezmo ga̱di̱ u̱nhnʉ Oja̱, ga̱di̱ u̱nni̱ te gä guí ti̱mhmʉ, asta̱ ra̱ xa̱c'a̱ndehe ga̱di̱ u̱nhnʉ ra̱ diezmo Oja̱. Da̱ gue'ʉ gätho mi̱'da yø c'ani̱ ga̱di̱ u̱nhnʉ ra̱ diezmo Oja̱. Ya xa̱nho ngue ngu̱na̱ guí øthʉ, pɛ nu̱ te ra̱ nho ja ngue gui 'yøthʉ, 'nɛ̱'a̱ gdi̱ ma̱hmʉ Oja̱, hi̱nguí̱ øthʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ague gyø fariseohʉ, hague ngu̱ ra̱ n'ʉ gui thohmʉ. Porque guí huanthohʉ yø nthu̱ts'i̱ ta̱te xa̱nho p'ʉ ja yø ni̱ja̱. 'Nɛ̱ guí̱ nnehʉ ngue con n'na ra̱ respeto di zɛngua'a̱hʉ yø ja̱'i̱ p'ʉ ja yø 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ague gyø xännba̱tehʉ ngue ra̱ ley, conyø fariseo, hague ngu̱ ra̱ n'ʉ gui thohmʉ. Porque ma̱xøts'etho di̱ nɛ̱qui̱ ngue xa̱nho'a̱hʉ, hi̱mma̱ jua̱ni̱ ngue xa̱nho ni̱ mmʉihʉ. Nu̱'a̱hʉ, tengu̱tho p'ʉ o ra̱ ánima hi̱ndi̱ nɛ̱qui̱, thohyø ja̱'i̱ ma̱xøts'e, pɛ hi̱ngui̱ pa̱di̱ te ja mbo ra̱ häi. ");
INSERT INTO otnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mi̱ da̱'a̱ n'na nc'ɛ̱i̱'ʉ yø xännba̱te ngue ra̱ ley p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ngue guí̱ mma̱nna̱ ra̱ hya̱ na̱ya, xquet'a̱ 'nɛ̱cähe guí sʉcje ya 'mø ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xquet'a̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley, hague ngu̱ ra̱ n'ʉ gui thohmʉ. Porque nu̱na̱ ra̱ ley gui xännba̱hʉ yø ja̱'i̱ ngue da̱ 'yøt'e, hi̱njongui̱ hät'i da̱ 'yøt'e. Ɛ̱̱ntho ra̱ nda̱te 'bɛni̱ ga̱di du̱thʉ yø ja̱'i̱. Yø ja̱'i̱ p'ʉya, hi̱ngui̱ hät'i da̱ du̱ts'i̱. Pɛ nu̱'a̱hʉ, ni̱ xi̱nga̱ gue'a̱ n'na ni̱ saha guí̱ nne gdi tøxhʉ'a̱ ra̱ 'bɛni̱ guí høspa̱hʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hague ngu̱ ra̱ n'ʉ gui thohmʉ. Porque guí hømba̱hʉ yø panteo'ʉ yø pønga̱hya̱ Oja̱ xa̱ hyo ni̱ mboxitahʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ja di̱ nɛ̱qui̱ p'ʉya ngue ga̱di thɛhʉ'ʉ ni̱ mboxitahʉ bi hyopyø ponga̱hya̱ Oja̱. Ma̱hønguí̱ nne gui̱ njathʉ p'ʉya, ma̱da̱gue'a̱ ga̱di hojpa̱hʉ yø panteo'ʉ yø pønga̱hya̱ ya xa̱ndu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ja̱na̱ngue ya pa̱tho Oja̱ te di̱ nja. Bi 'yɛ̱na̱: “Ga̱ pɛnhnä ma̱ pønga̱hya̱ 'nɛ̱ mi̱'da yø m'mɛnhni̱. Nu̱ 'da'ʉ p'ʉya, da̱ tho. Mi̱'da p'ʉya, da̱ ju̱i̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pɛ nu̱ya yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya, gä ja da̱ ma̱ ma̱pɛnnbi̱ p'ʉ'a̱ ra̱ castigo ja ngue di̱ nja, ngue yø pønga̱hya̱ xa̱ tho asta̱ gue'mø ma̱mbá̱ fʉ'a̱ nxi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Da̱ fʉp'ʉ bá̱ tu̱ ra̱ Abel, asta̱ guep'ʉ i̱ ntu̱ ra̱ Zacarías nu̱na̱ bi thop'ʉ ha gui̱ nhyacui ra̱ ni̱ja̱ ra̱ altar. Guehna̱ dí xi'a̱hʉ na̱ya, da̱ hya̱spa̱bi̱ ra̱ güɛnda Oja̱ ya yø ja̱'i̱ 'bʉhya, ngue'a̱ te i du̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ague gyø xännba̱tehʉ ngue ra̱ ley, hague ngu̱ ra̱ n'ʉ gui thohmʉ. Porque go guí ha̱hʉ ra̱ nsogui ngue ra̱ mfa̱di̱. Pɛ ni̱ xi̱nga̱ gue'a̱hʉ gdi pa̱hmʉ, ni̱ xi̱nga̱ di japhʉ da̱ ba̱'ʉ yø ja̱'i̱ nne da̱ ba̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nu̱na̱ ra̱ Jesús, høntho bi juadi bi̱ ma̱nya yø hya̱ ya, ma̱thoguitho bi̱ mbøcuɛ yø xännba̱te ngue ra̱ ley 'nɛ̱hyø fariseo. Bi guarbʉya ngue bi 'yørpe xa̱ngu̱ yø nt'änni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Honi̱ ha di zʉdi ngue tema̱ hya̱ da̱ ma̱nna̱ Jesús ngue hi̱nda̱ gue'a̱, para ngue da̱ zä di ya̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nu̱'a̱ ra̱ ora'a̱, yø ma̱hua̱hi̱tho yø ja̱'i̱ bi̱ mpɛti, asta̱ di̱ ntøtyø ja̱'i̱. Ra̱ Jesús bi̱ mʉdi bi 'yɛ̱mbyø xädi: ―'Yo gni̱ 'yohʉ tengu̱tho ga̱ 'yo yø fariseo. Porque ma̱xøts'etho di̱ nɛ̱qui̱ ngue xa̱nho te ga̱ 'yo, hi̱mma̱ jua̱ni̱ ngue xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hi̱n'yʉ n'na ra̱ hya̱ da̱ bɛ̱mp'ʉ ja rá̱ mmʉi ra̱ ja̱'i̱ ngue hi̱nda̱ fa̱di̱. Ma̱da̱gue'a̱ da̱ 'yɛ̱na̱ da̱ go'mi̱, pɛ gä fa̱tho. ");
INSERT INTO otnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A nu̱yá, nu̱'a̱ te gäma̱ hya̱ nt'a̱gui̱tho ga̱di̱ nxihmʉ ngue hi̱ngui̱ nnephʉ da̱ fa̱di̱, hi̱nga̱ nt'a̱gui̱'a̱, i fa̱di̱ xa̱ndønho. Nu̱'a̱ ra̱ hya̱ ga̱di̱ nhyʉrpa̱tho ni̱ gu̱hʉ, ogue n'nøt'e ra̱ ngu̱ p'ʉ gui ya̱hʉ, i̱ nt'øde gätho ra̱ hni̱ni̱'a̱ te guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ague ma̱ amigo'a̱hʉ, dí xi'a̱hʉ ngue 'yo guí su̱hʉ'ʉ da̱ ne da̱ hyo'a̱hʉ. Porque nu̱'mø bi hyo'a̱hʉ, ya hi̱nda̱ zä te da̱ japra̱ te. ");
INSERT INTO otnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nu̱gä ga̱ xi'a̱hʉ ndana̱ ja ngue gui su̱hʉ. Da̱mi̱ su̱hʉ Oja̱, ngue nu̱'mø bi hya̱c'a̱ ni̱ tehʉ, ja rá̱ ts'ɛdi ngue da̱ mɛn'na̱hʉ ra̱ ni̱du̱. Nu̱na̱ ya, guehna̱ da̱mi̱ su̱hʉ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Xi'mø bi 'bä cʉt'a yø ts'ints'ʉ, ua̱ngui̱ høndi yoho yø zixani̱ ma̱ t'u̱ni̱. Pɛ nu̱na̱ Oja̱, hi̱nga̱ n'na di pu̱mbɛ̱ni̱'ʉ yø ts'ints'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ja̱njua̱ni̱ ngue fäxa̱hʉ Oja̱. Conque asta̱ ni̱ xta̱hʉ m'mede n'na ngu̱ n'na. Ja̱na̱ngue 'yo guí su̱hʉ yø ja̱'i̱. Porque ma̱n'na xa̱mma̱di̱'a̱hʉ ngue yø ts'ints'ʉ, ma̱da̱gue'a̱ yø mmu̱ndotho'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Dí xi'a̱hʉ ngue nu̱ to gätho da̱ ma̱mp'ʉ 'bʉhyø ja̱'i̱ ngue ɛ̱c'ɛ̱i̱gui̱, xquet'a̱ ga̱ mma̱ngä p'ʉ 'bʉhyø anxɛ Oja̱ ngue da̱di̱ n'amigo'be ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pɛ nu̱ te'o da̱ gøngä p'ʉ 'bʉhyø ja̱'i̱, da̱ ma̱ ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱gui̱, xquet'a̱ ga̱ mma̱ngä p'ʉ 'bʉhyø anxɛ Oja̱ ngue hi̱n da̱di̱ n'amigo'be ra̱ ja̱'i̱ da̱ gøngui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nu̱ to bi zä da̱ nømma̱n'ʉ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, i sä ngue di̱ mpu̱nnbi̱. Pɛ nu̱ ra̱ ja̱'i̱ da̱ nømma̱n'ʉ ra̱ Espíritu Santo, ya hi̱ndi̱ mpu̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nu̱'mø bi ts'ixa̱hʉ p'ʉ ja yø ni̱ja̱, ogue da̱ ts'ixa̱hʉ p'ʉ ja ra̱ ts'ʉt'abi, 'yo sä di tu̱ ni̱ mmʉihʉ na̱ ra̱ hya̱ ja ngue gdi tha̱hmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porque nu̱'mø bi zønna̱ ora gui̱ nya̱hʉ, guesɛ ra̱ Espíritu Santo di bɛ̱n'na̱hʉ ra̱ hya̱ gui̱ mma̱mhmʉ'a̱ ra̱ ora'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ma̱mbá̱ nya̱ n'na nc'ɛ̱i̱ p'ʉ 'bʉhyø ja̱'i̱, bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, da̱mi̱ xihma̱ n'yohʉgä ngue di 'dajma̱ parte ngue ra̱ erensia. ");
INSERT INTO otnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague n'yø, ¿te'o bi 'yɛ̱xqui̱ ngue ga̱ nts'ʉt'abi ngue ga̱ hec'a̱hʉ te guí pɛshʉ? ");
INSERT INTO otnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma̱hømbi 'yɛ̱mbi̱: ―Da̱mi̱ mfähmʉ, 'yo sä guí ɛ̱mhmʉ ngue gue'a̱ ra̱ mɛ̱nyu̱ ma̱ da̱tho di̱ mu̱ui. Porque ra̱ ja̱'i̱ nne ngue di̱ m'mʉ ma̱nho, hi̱nga̱ gue'a̱ rá̱ mɛ̱nyu̱ xta̱ngu̱ di pɛts'i di̱ m'mʉ ma̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bi hyɛjpa̱bi̱ na̱ ra̱ hya̱ ja ua p'ʉya, bi 'yɛ̱mbi̱: ―Mi̱ 'bʉ'a̱ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱mmɛti. Ɛ̱̱mmɛ̱i̱ bi̱ nja yø hua̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nu̱na̱ ra̱ mmɛ̱mmɛti p'ʉya, ngu̱na̱ bi bɛ̱ni̱, bi 'yɛ̱na̱: “¿Teni̱ 'bɛ'a̱ ga̱ øt'e? Hi̱n'yʉ hapʉ ga̱ pɛts'a̱ te jap'ʉ xtá̱ pɛfi”. ");
INSERT INTO otnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ya ɛ̱mp'ʉya: “Ya dí pa̱di̱ te ga̱ øt'e. Nu̱ya ga̱ xotma̱ t'u̱, ma̱n'na xta̱nnoho ga̱ hoqui. Ja ga̱ pɛspʉ'a̱ te gä ga̱ xoqui, 'nɛ̱'a̱ te gä dí pɛts'i. ");
INSERT INTO otnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ga̱ ɛ̱ngä p'ʉya, Nu̱ya, xa̱ngu̱ te jap'ʉ gdá̱ si xa̱ngu̱ yø jɛya. Di̱ nja ga̱mpähä ya. Ma ga̱ nsäya, ma ga̱ si te ga̱ ti̱ni̱”, da̱ 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pɛ Oja̱ p'ʉya, da̱ 'yɛ̱mbi̱: “Ague n'yø, hi̱nguí̱ pa̱di̱ te guí̱ mma̱. Nu̱ya gui tu̱'a̱ di̱ nxu̱i̱ ya. Xi'a̱ te xcá̱ pɛts'i, ¿to da̱ gohmi̱'a̱?” ");
INSERT INTO otnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Njarbʉtho ra̱ ja̱'i̱ nu̱'a̱ nne ngue xta̱ngu̱ te da̱ mɛts'i, hi̱nte di̱ mu̱ui p'ʉ ja rá̱ hmi̱ rá̱ dä Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bi 'yɛ̱mba̱ m'mɛfa yø xädi ra̱ Jesús: ―Nu̱gä dí̱ mma̱, nu̱'a̱ te ja ngue gui sihʉ, ogue te ja ngue gui hyehʉ, 'yo gue'a̱ ma̱thoguitho ga̱ ndu̱ ni̱ mmʉihʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A nu̱yá, nu̱ rá̱ te ra̱ ja̱'i̱ ma̱n'natho di̱ mu̱ui ngue'a̱ te da̱ zi. Nu̱ rá̱ do'yo ra̱ ja̱'i̱ ma̱n'natho di̱ mu̱ui ngue'a̱ te da̱ hye. ");
INSERT INTO otnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ya guí̱ nnu̱hʉ yø ca ngue hi̱ngui̱ ua̱hi̱, 'nɛ̱ hi̱ngui̱ xofo ngue te da̱ mɛts'i. Pɛ Oja̱ di u̱nni̱ te si yø ts'ints'ʉ. Goma̱ gue'a̱hʉ ya, ngue hi̱nda̱ mäxa̱hʉ Oja̱, porque ma̱n'na xa̱mma̱di̱'a̱hʉ ngue yø ts'ints'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Xiya, xi ra̱ ja̱'i̱ tu̱ rá̱ mmʉi ngue hi̱ngui̱ hɛ̱ts'i̱, ¿ua da̱ zä di̱ nte ma̱n'na doyʉni̱ ngue'a̱ ga̱ nhɛ̱ts'i̱? ");
INSERT INTO otnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nu̱'mø hi̱nda̱ zä ngue ma̱n'na gui̱ ntehʉ mi̱ts'ʉ, ¿hanja ngue tu̱ ni̱ mmʉihʉ mi̱'da yø cosa 'mø? ");
INSERT INTO otnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ya guí̱ nnu̱hʉ yø døni̱ bí ja da̱po ngue hi̱ndi̱ mpɛfi, ni̱ xi̱ngui̱ mpe, pɛ ma̱hotho gui̱ nɛ̱qui̱. Dí xi'a̱hʉ ngue tengu̱ ra̱ da̱st'abi Salomón, ma̱ndønho drá̱ he bi hye, pɛ hi̱nha da̱ zʉdi tengu̱ ga̱ nho yø døni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Porque guesɛ Oja̱ øt'e ngue ma̱zihotho gui̱ nɛ̱qui̱ yø døni̱ bí ja da̱po. Bí ja da̱po ya, pɛ ni̱xu̱di̱ p'ʉya, di̱ nzøp'ʉ ja ra̱ orno. ¿Goma̱ gue'a̱hʉ ngue hi̱ndi̱ he'a̱hʉ Oja̱? Pɛ hi̱ngá̱ ɛgui̱ ɛ̱c'ɛ̱i̱hʉ xa̱nho ngue fäxa̱hʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nu̱ya 'yo ma̱thoguitho di tu̱ ni̱ mmʉi ha gdi hyoni̱ te gui sihʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porque yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi, hønt'a̱ te da̱ zi ni̱ ma yø mmʉi honi̱. Pɛ nu̱'a̱hʉ, 'bʉhni̱ Papáhʉ, 'nɛ̱ ya pa̱di̱ ngue guí homhmʉ gätho ya yø cosa ya. ");
INSERT INTO otnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ja̱na̱ngue da̱mi̱ ja ndu̱mmʉi gui 'yøthʉ'a̱ te di̱ ma̱nda Oja̱. Gue'a̱ di 'da'i te gäma̱ cosa guí homhmʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma̱da̱gue'a̱ ziyohotho'a̱hʉ, pɛ 'yo guí su̱hʉ. Nu̱gä ga̱ fä'a̱hʉ tengu̱tho ra̱ mändɛ'yo 'mø fähyø dɛ'yo. Nu̱na̱ Oja̱ ni̱ Papáhʉ i ja mpähä ngue gui̱ m'mʉhmʉ p'ʉ ha di̱ ma̱nda. ");
INSERT INTO otnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Da̱mi̱ pä te gä guí pɛshʉ, gui u̱nhnʉ ra̱ mɛ̱nyu̱ yø hyoha. Da̱mi̱ nehʉ ra̱ buxa hi̱nja̱m'mø di̱ nts'oni̱. Porque nu̱'mø bí ja ni̱ mmɛtihʉ ma̱hɛ̱ts'i̱, hi̱nha rá̱ nzɛgui da̱ bøhø. Nu̱p'ʉ hi̱nda̱ zønna̱ bɛ̱, 'nɛ̱ hi̱nda̱ zi ra̱ zu̱'ɛ̱'a̱ te guí pɛts'i. ");
INSERT INTO otnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nu̱'mø guí ɛ̱mhmʉ ngue bí ja ma̱hɛ̱ts'i̱'a̱ ra̱ nho ta̱te di̱ mu̱ui, hønnbʉ da̱ zo ni̱ mmʉihʉ p'ʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ya xqui̱ nsähʉ 'mø bi zøhni̱ Hmu̱hʉ. Ma̱dra̱ xu̱i̱ da̱ zøhø, ya di zø ni̱ nyot'ihʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gui 'yøthʉ tengu̱tho yø hmi̱qui̱ n'na ra̱ hmu̱ 'mø tø'mi̱ ngue da̱ pengbʉ da̱ nu̱ ra̱ ntha̱ti̱. Ngu̱ di zøhø di jätra̱ goxthi̱, 'bexta̱ xojpi. ");
INSERT INTO otnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ra̱ mmɛnthi̱ di̱ nthɛui ra̱ hmi̱qui̱ nu̱na̱ di̱nná̱ hmu̱ 'mø bi zøhø ngue di̱ ndø'ma̱te. Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱'a̱ rá̱ hmu̱, di̱ nsä ngue da̱ 'yɛ̱p'ʉ ja ra̱ mɛ̱xa yø hmi̱qui̱ ngue da̱ 'ui̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ma̱da̱gue'a̱ ma̱de nxu̱i̱ da̱ zøhø, ogue tobe hi̱ndi̱ hats'i da̱ zøhø, pɛ ra̱ mmɛ̱nthi̱ bi̱ nthɛui yø hmi̱qui̱ da̱ thi̱ni̱ ngue di̱ ndø'ma̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Da̱mi̱ pa̱hmʉ na̱ ra̱ hya̱ ja ua. Ngue n'na ra̱ mmɛ̱nni̱gu̱, nu̱'mø da̱ ba̱di̱ tema̱ ora da̱ zøhra̱ bɛ̱ p'ʉ ja rá̱ ngu̱, di̱ mfädi xa̱nho, hi̱ndi̱ n'u̱ni̱ da̱ sojpa̱ rá̱ ngu̱ ngue da̱ fɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Xquet'a̱ da̱mi̱ njathʉ p'ʉya, da̱mi̱ ndø'ma̱tehʉ. Porque nu̱'a̱ ra̱ ora hi̱nte di so ni̱ mmʉihʉ, xi'mø gue'a̱ ra̱ ora da̱ zøhra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ra̱ Bɛdu bi 'yänna̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿høngtho gähe guí xicje na̱ ra̱ hya̱ ga̱di hyɛcya, ua gue gätho yø ja̱'i̱ guí xifi? ");
INSERT INTO otnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ hya̱ dí̱ mma̱ngä, gue'a̱ ra̱ hmi̱qui̱ 'bɛt'o bá̱ di̱nna̱ hya̱ dí xicä na̱, nu̱'mø da̱ 'yøt'e te dí xifi. Guehna̱ tengu̱tho n'na ra̱ hmi̱qui̱ da̱ ma ma̱fäti'ʉ to 'bʉp'ʉ ja rá̱ ngu̱ rá̱ hmu̱. Nu̱'mø bi zønna̱ ora di̱ nsi̱hmɛ̱ yø ja̱'i̱ ma̱fäti, da̱ 'ui̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ra̱ mmɛ̱nthi̱ di̱ nthɛui ra̱ hmi̱qui̱ da̱ 'yøt'e te di 'bɛprá̱ hmu̱. Nu̱'mø bi zøhrá̱ hmu̱, da̱ di̱ni̱ ngue da̱di̱ mpɛfi. ");
INSERT INTO otnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱ te gä pɛsrá̱ hmu̱, gä di fätrá̱ hmi̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pɛ nu̱na̱ ra̱ hmi̱qui̱ da̱ 'yɛ̱mp'ʉ ja rá̱ mmʉi ngue hi̱m'be da̱ zøhrá̱ hmu̱, da̱ mʉdi da̱ mʉtyø mmi̱hmi̱qui̱ui conyø xisu. Da̱ mi̱ di̱ nsi̱hmɛ̱, ogue di̱ n'i̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nu̱'a̱ rá̱ hmu̱ ra̱ hmi̱qui̱ p'ʉya, nu̱'a̱ ra̱ pa ra̱ ora ngue hi̱ngui̱ tø'mrá̱ hmu̱, gue'a̱ ra̱ ora da̱ zø'a̱. Nu̱'a̱ rá̱ hmu̱ p'ʉya, ma̱thoguitho da̱ mɛi, pɛts'i ngue da̱ xɛni̱. Di 'yɛmp'ʉ ni̱ gohyø ja̱'i̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱ ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nu̱na̱ ra̱ hmi̱qui̱ bi ba̱di̱ xa̱nho hanja na̱ ra̱ hya̱ nneprá̱ hmu̱ da̱ 'yøt'e, pɛ hi̱mbi̱ 'yørpa̱bi̱'a̱ te rá̱ pähä rá̱ hmu̱, da̱ 'yɛ̱mmɛ̱i̱ da̱ ma m'mɛi. ");
INSERT INTO otnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pɛ nu̱'a̱ ra̱ hmi̱qui̱ hi̱mbi̱ ba̱di̱ xa̱nho'a̱ te rá̱ pähä rá̱ hmu̱, da̱ 'yøtyø cosa ní̱ n'yu̱p'ʉ ngue di 'bɛi, ts'ʉtho da̱ ma m'mɛi, porque hi̱ngui̱ pa̱di̱ te øt'e. Nu̱ te'o bi ba̱di̱ xa̱nho ra̱ hya̱, jatho ngue da̱ 'yøt'e te sifi. Nu̱ te'o ma̱n'na xa̱ngu̱ ra̱ hya̱ ma̱fäti, ma̱n'natho xa̱ngu̱ ja ngue da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nugä ra̱ sibi dá̱ ɛ̱hɛ̱ ga̱ u̱cä ua ja ra̱ xi̱mhäi. Dí̱ nnegä ngue di̱ nzø na̱ ra̱ sibi na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xquet'a̱ ja ngue ga̱ thocä n'na ra̱ n'ʉ, pɛ dí xønni̱ ngue di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ua guí ɛ̱mhmʉ ngue dá̱ ɛ̱cä ua ja ra̱ xi̱mhäi ngue hi̱n tema̱ n'ʉ gui sähʉ? Nu̱'a̱, hi̱n'na̱'a̱. Sinoque di̱ nja ra̱ sʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Porque ra̱ pa di̱ ma p'ʉya, cʉt'a nja̱'i̱ 'dat'a̱ ra̱ ngu̱ di 'bʉi, gä di̱ nsʉi. Hyu̱ nc'ɛ̱i̱ di̱ nsʉhmi̱'ʉ yo nc'ɛ̱i̱ di ɛ̱c'ɛ̱i̱gui̱. Ogue yo nc'ɛ̱i̱ di̱ nsʉhmi̱'ʉ hyu̱ nc'ɛ̱i̱ di ɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nu̱ ra̱ papá hi̱nda̱ nu̱ ma̱nho rá̱ ts'ʉnt'ʉ di ɛ̱c'ɛ̱i̱gui̱. Nu̱ ra̱ ts'ʉnt'ʉ hi̱nda̱ nu̱ ma̱nho rá̱ papá di ɛ̱c'ɛ̱i̱gui̱. Nu̱ ra̱ mamá hi̱nda̱ nu̱ ma̱nho rá̱ t'i̱xu̱ di ɛ̱c'ɛ̱i̱gui̱. Nu̱ ra̱ t'i̱xu̱ hi̱nda̱ nu̱ ma̱nho rá̱ mamá di ɛ̱c'ɛ̱i̱gui̱. Nu̱ ra̱ cä hi̱nda̱ nu̱ ma̱nho rá̱ ts'i̱huɛ̱ di ɛ̱c'ɛ̱i̱gui̱. Nu̱ ra̱ ts'i̱huɛ̱ hi̱nda̱ nu̱ ma̱nho rá̱ cä di ɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nuna̱ ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱'mø gá̱ nu̱hʉ ngue bá̱ nangyø 'bogu̱i̱, guí ɛ̱mhmʉ p'ʉya ngue di̱ n'ye. 'Nɛ̱ gue'a̱ di̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nu̱'mø 'yo ra̱ nda̱hi̱ ni̱ 'yɛ̱'a̱ sur, guí ɛ̱mhmʉ p'ʉya: “Xta̱ mpa ya”. 'Nɛ̱ gue'a̱ di̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ɛ̱na̱ xø gä guí pa̱hmʉ p'ʉ gni̱ bɛ̱mhmʉ, pɛ hi̱n'na̱. Nu̱'a̱hʉ guí pa̱hmʉ te nne da̱ ma̱nna̱ tiempo 'mø guí hanthʉ yø gu̱i̱ bí ja ma̱ya̱, 'nɛ̱cua ja ra̱ häi guí pa̱hmʉ te di̱ nja'mø 'yo ra̱ nda̱hi̱. ¿Hanja ya'mø ngue hi̱nguí̱ pa̱hmʉ te ga̱ mbøn'a̱ te gäma̱ hya̱ guí̱ nnu̱hʉ yø pa dí 'bʉhmʉ ya? ");
INSERT INTO otnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Hanja ngue hi̱nguí̱ ha̱csɛhʉ ra̱ güɛnda ndana̱ gue'a̱ xa̱nho? ");
INSERT INTO otnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu̱'mø bi̱ nya̱p'a̱hʉ, nu̱'a̱ di ya̱p'a̱hʉ da̱mi̱ nhojpa̱hʉ p'ʉ ja ra̱ 'yu̱, n'namhma̱ ngue hi̱ndi̱ dä'a̱hʉ p'ʉ ja ra̱ ts'ʉt'abi. Porque nu̱'mø ya bi̱ ndä'a̱hʉ p'ʉ ja ra̱ ts'ʉt'abi, ra̱ ts'ʉt'abi di dä'a̱hʉ ra̱ policía. Ra̱ policía p'ʉya, da̱ zixa̱hʉ fädi. ");
INSERT INTO otnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Dí xi'a̱hʉ ngue nu̱p'ʉ ja ra̱ fädi, ya hi̱nda̱ zä guá̱ pønthohʉ p'ʉ, guá̱ pømhmʉ asta̱ gue'mø guá̱ ju̱t'i̱ gätho ra̱ mɛ̱nyu̱ da̱ ts'än'na̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi guat'i 'da yø ja̱'i̱ p'ʉ 'bähra̱ Jesús, bi xifi te xi 'yøtra̱ Pilato ngue xi hyo 'da yø ja̱'i̱ ngue yø mmɛ̱ngu̱ Galilea. 'Nɛ̱ ja xi thop'ʉ ha thohyø zu̱'ɛ̱ nu̱'ʉ tho ngue ra̱ 'bøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱'a̱ te ra̱ n'ʉ bi thohya yø mmɛ̱ngu̱ Galilea bi tho, ¿ua guí ɛ̱mhmʉ ngue ma̱n'na mi̱ ja yø ts'oqui ya ngue mi̱'da yø mmɛ̱ngu̱hʉ? ");
INSERT INTO otnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dí xi'a̱hʉ ngue hi̱n'na̱. Nu̱'mø hi̱ngui̱ hyɛhmʉ p'ʉ ra̱ nts'o gni̱ 'yohʉ, xquet'a̱ 'nɛ̱'a̱hʉ 'da gdi̱ m'mɛhmʉ'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Xi'ʉ 'dɛ'ma̱ hya̱to nja̱'i̱ bi hyo ra̱ torre Siloé 'mø mi̱ dägui, ¿ua guí ɛ̱mhmʉ ngue ma̱n'na mi̱ ja yø ts'oqui ya bi du̱ ngue gätho mi̱'da yø mmɛ̱ngu̱ Jerusalén? ");
INSERT INTO otnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nu̱gä dí xi'a̱hʉ ngue hi̱n'na̱. Nu̱'mø hi̱ngui̱ hyɛhmʉ p'ʉ ra̱ nts'o gni̱ 'yohʉ, 'nɛ̱'a̱hʉ 'da gni̱ m'mɛhmʉ'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bi hyoni̱ te gui hyɛjpa̱ ra̱ hya̱ bi xihyø ja̱'i̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―N'na ra̱ n'yohʉ bi 'yɛ̱t'a̱ n'na nza ra̱ igo p'ʉ ja rá̱ häi. Bi̱ ma da̱ nu̱ p'ʉya ngue'mø zʉdi. Pɛ hi̱n tema̱ igo bá̱ ti̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bi 'yɛ̱mbrá̱ mɛfi mi̱ fähra̱ häi p'ʉya: “Ague n'yø, ya rá̱ hyu̱ jɛya dí ɛ̱hɛ̱ dí hongä yø ndät'ä ua ja ra̱ za ja ua. Pɛ hi̱nte dí ti̱ni̱. Da̱mi̱ 'yɛts'i ma̱n'na xa̱nho, porque cot'ua ja ra̱ häi”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pɛ nu̱'a̱ fähra̱ häi p'ʉya bi 'yɛ̱na̱: “Ague n'yø, da̱mi̱ tø'mra̱ jɛya ja ua ya. Ma ga̱ cu̱nnba̱gä ra̱ häi 'nɛ̱ ga̱ pojpa̱ ra̱ 'yai. ");
INSERT INTO otnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xa̱mhma̱tho di̱ nzʉdi ngue ga̱ jap'ʉ. Nu̱'mø ya hi̱mbi̱ nzʉdi, ya ga̱ ɛxpʉya”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ma̱n'na ra̱ pa ngue ra̱ ts'äya, mi̱ xännba̱te p'ʉ ja n'na ra̱ ni̱ja̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nu̱p'ʉ ja ra̱ ni̱ja̱, mi̱ 'bʉp'ʉ n'na ra̱ xisu ngue ya n'nɛ'ma̱ hya̱to njɛya ma̱di̱ hyɛ̱nni̱. Nu̱'a̱ ra̱ ts'onthi̱ mi̱ n'youi, di japi ngue mo'mi̱. Hi̱nja̱m'mø di sä di jua̱nná̱ xʉtha. ");
INSERT INTO otnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nu̱'mø mi̱ nu̱ ra̱ Jesús, bi zonnbʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xisu, ya da̱ zä ra̱ n'ʉ guí hɛ̱mbya. ");
INSERT INTO otnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bi japyø 'yɛ p'ʉ ja rá̱ ya̱ p'ʉya. Pɛ 'bexpi zä'a̱ ra̱ ora'a̱, bi̱ njua̱nná̱ xʉtha ra̱ xisu. Nu̱na̱ p'ʉya, bi ja ma̱mma̱di Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pɛ nu̱'a̱ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱ p'ʉya, bi̱ mbøcuɛ ngue ra̱ ts'äya'a̱ ra̱ pa bi̱ n'øthe ra̱ Jesús. Bi 'yɛ̱mbyø ja̱'i̱ p'ʉya: ―N'nato ma̱ pa ja ngue di̱ nja ra̱ 'bɛfi. Gue'ʉ yø pa guá̱ ɛ̱hɛ̱ da̱ t'øthe'a̱hʉ 'mø. Pɛ hi̱nga̱ gue'mø ra̱ pa ngue ra̱ ts'äya da̱ t'øthe'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Ya gä gue'a̱ guí̱ mma̱mp'ʉ gni̱ bɛ̱mhmʉ ya 'mø. Xi'mø guí si n'na ni̱ nda̱ni̱, ogue n'na ni̱ burru, ¿ua hi̱nguí̱ xoc'mø ra̱ pa ngue ra̱ ts'äya ngue da̱ ma da̱ nsithe? ");
INSERT INTO otnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Xina̱ ra̱ xisu, rá̱ mbom'mɛto ra̱ Abraham, ya n'nɛ'ma̱ hya̱to njɛya di ʉnna̱ zithu̱ ngue'a̱ te hɛ̱mbi̱. ¿Ua hi̱nda̱ zä da̱ t'øthe 'mø ra̱ pa ngue ra̱ ts'äya na̱'mø? ");
INSERT INTO otnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, ma̱mbi̱ mɛsta̱ yø sä'ʉ nnu̱ ma̱n'ʉ ra̱ Jesús. Pɛ gä di johya yø ja̱'i̱, porque hi̱njonda̱ zä da̱ 'yøt'e te nnu̱rpi̱ øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―¿Ha di̱ njap'ʉ gdí pa̱hmʉ ngue ha di̱ nxa̱ndyø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱? ¿Tegue gdá̱ hyɛjpa̱ ra̱ hya̱? ");
INSERT INTO otnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tengu̱tho n'na zihmu̱dä ra̱ mostasa, zitchʉ 'mø bi thu̱p'ʉ ja ra̱ hua̱hi̱. Pɛ di̱ nte asta̱ gue'mø di̱ nda̱t'o. Xta̱ nhɛ̱ts'i̱ da̱ gohi, da̱ 'yøtyø 'bafi yø ts'ints'ʉ p'ʉ ja yø 'yɛt'o. ");
INSERT INTO otnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma̱hømbi 'yɛ̱nna̱ Jesús: ―Nu̱'a̱ di̱ nxa̱ndyø ja̱'i̱ da̱ zo rá̱ 'yɛ Oja̱, gui̱ nhyɛjpa̱bi̱ ");
INSERT INTO otnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ra̱ íxi 'mø bi japi hyu̱ t'ɛ̱ni̱ ra̱ hojʉni̱ n'na ra̱ xisu, asta̱ gue'mø di ixqui gä ra̱ jʉni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bi sigue bi̱ n'yo ra̱ Jesús ni̱ ma Jerusalén, xännba̱bi̱ ra̱ hya̱ yø ja̱'i̱ p'ʉ ja yø hni̱ni̱ thogui. ");
INSERT INTO otnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bi 'yɛ̱mba̱ n'na nc'ɛ̱i̱ p'ʉya: ―Ague grá̱ hmu̱, ¿ua ziyohotho yø ja̱'i̱ di̱ nya̱ni̱? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Da̱mi̱ ja ndu̱mmʉi gdi cʉthʉ p'ʉ ja ra̱ goxthi hi̱ngui̱ uant'i̱. Porque dí xi'a̱hʉ ngue xa̱ngu̱ to da̱ ne da̱ yʉt'i, pɛ hi̱nda̱ zä da̱ yʉt'i. ");
INSERT INTO otnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Porque nu̱'mø bi̱ nangra̱ mmɛ̱nni̱gu̱ da̱ nøtra̱ goxthi, nu̱'ʉ da̱ go'a̱thi di jätra̱ goxthi, da̱ 'yɛ̱mbi̱: “Ague grá̱ Hmu̱, da̱mi̱ xoga̱he ra̱ goxthi”, da̱ 'yɛ̱mbi̱. Pɛ da̱ 'yɛ̱nna̱ Hmʉ 'mø bi da̱di̱: “Hi̱n'na̱. Hi̱mma̱ amigo'a̱hʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Da̱ 'yɛ̱n'ʉ di 'bä'a̱thi p'ʉya: “Pɛ 'nɛ̱ 'dap'ʉ dá̱ nsi̱hmɛ̱hʉ. Nu̱p'ʉ ja ma̱ hni̱ni̱gähe ja gá̱ xännga̱he p'ʉ ni̱ hya̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Da̱ 'yɛ̱nna̱ Hmu̱ 'mø bi da̱di̱: “Ya dí xi'a̱hʉ ngue hi̱mma̱ amigo'a̱hʉ. Da̱mi̱ 'uehmʉ ua dí 'bʉi, porque xa̱nts'o te xcá̱ 'yøthʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja di̱ nzonp'ʉ'ʉ di 'bä'a̱thi p'ʉya, di gu̱xtyø ts'i 'mø bi̱ nu̱ ra̱ Abraham, ra̱ Isaac, ra̱ Jacob, co gätho mi̱'da yø pønga̱hya̱ Oja̱ di 'bʉp'ʉ di̱ ma̱nda Oja̱. Nu̱'ʉ di 'bä'a̱thi, da̱ gop'ʉ'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Porque di bønyø ja̱'i̱ p'ʉ ni̱ hyʉhra̱ hyadi, da̱ guep'ʉ ni̱ bøxyadi, norte, 'nɛ̱ sur di bønyø ja̱'i̱ da̱ mi̱p'ʉ ja ra̱ mɛ̱xa ngue di̱ nsi̱hmɛ̱ p'ʉ di̱ ma̱nda Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A nu̱yá, 'bʉ i'da ngue 'bɛfa ua ya, gue'ʉ da̱ni̱ m'mɛt'o p'ʉ'ʉ. 'Bʉ i'da ngue 'bɛt'o ua ya, gue'ʉ da̱ni̱ m'mɛfa p'ʉ'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, bi zø i'da yø fariseo, bi 'yɛ̱mbra̱ Jesús: ―Da̱mi̱ pøngua ni̱ ma, porque nne da̱ hyo'i ra̱ Herodes ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Ha̱ntho ɛ̱na̱ da̱ hyäcä na̱ ra̱ Herodes. Ni̱ mähä ya bá̱ xihmʉ ngue nu̱ya 'nɛ̱ ni̱xu̱di̱, ga̱ øthegä yø ja̱'i̱ n'youi yø ts'onthi̱. Ga̱ øthe yø ja̱'i̱ hɛ̱mbi̱ 'dama̱ 'dan'yo ma̱n'ʉ. Ni̱ma̱ni̱ p'ʉya, ga̱ juadi te dí pɛfi. ");
INSERT INTO otnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pɛ jatho ngue ga̱ thogui hapʉ nná̱ ma. Ni̱xu̱di̱ 'nɛ̱ ni̱ma̱ni̱ ga̱ n'yo asta̱ gue'mø ga̱ søn'a̱ Jerusalén. Nu̱ua hi̱mma̱ jua̱ni̱ ngue da̱ thogä ua, nu̱p'ʉ Jerusalén hi̱mma̱ pu̱nnbi̱ yø pønga̱hya̱ sømp'ʉ, gä i tho. ");
INSERT INTO otnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ague gyø mmɛ̱ngu̱hʉ Jerusalén, gue'e gui hophʉ yø pønga̱hya̱ Oja̱, da̱ gue'ʉ yø ma̱mhya̱ Oja̱ bi 'bɛn'na̱hʉ, gä gui pʉndothohʉ. Xa̱ngu̱ yø nni̱di̱ dá̱ ne ngue ga̱ pɛn'na̱hʉ tengu̱tho ra̱ øni̱ 'mø di pɛtyø ba̱si̱ ngue di huits'i conyø zahua, da̱di ja'a̱hʉ p'ʉ. Pɛ hi̱ngá̱ nehʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A nu̱yá, da̱ hyɛc'a̱hʉ p'ʉ Oja̱ ya. Dí xi'a̱hʉ ngue ya hi̱nni̱ mantho gui̱ nnu̱jʉ, asta̱ gue'mø da̱ 'yɛ̱hra̱ pa gui 'yɛ̱mhmʉ: “Di ja̱prá̱ m'mɛnhni̱ Oja̱ bá̱ pɛnhua”, gui 'yɛ̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","N'na ra̱ pa ngue ra̱ ts'äya, nu̱na̱ ra̱ Jesús bi̱ ma da̱ nsi̱hmɛ̱ p'ʉ ja rá̱ ngu̱ n'na ra̱ n'yohʉ 'bɛt'o ngue yø fariseo. Nu̱ya p'ʉya, fätho te øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nu̱p'ʉ hu̱di̱, 'bʉp'ʉ n'na ra̱ n'yohʉ ngue neni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nu̱na̱ ra̱ Jesús, bi 'yørpa̱ ra̱ nt'änni̱ yø xännba̱te ngue ra̱ ley 'nɛ̱hyø fariseo, bi 'yɛ̱mbi̱: ―¿Ua da̱ zä ngue da̱ t'øthe n'na ra̱ därquɛ̱hi̱ 'mø ra̱ pa ngue ra̱ ts'äya, uague hi̱n'na̱? ");
INSERT INTO otnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nu̱'ʉ nzofo hi̱mbi̱ da̱di̱. Bi bɛntra̱ därquɛ̱hi̱ ra̱ Jesús, bi 'yøthe. Bi xifi ngue da̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bi t'ɛ̱mbyø fariseo p'ʉya: ―A nu̱yá, xi'mø gdi sihʉ n'na ra̱ burru ogue n'na ra̱ nda̱ni̱, da̱ zop'ʉ ja n'na ra̱ ots'i 'mø ra̱ pa ngue ra̱ ts'äya, ua̱ngui̱ guá̱ jʉts'i 'bexque'a̱, ma̱dra̱ ts'äya'a̱ ra̱ pa da̱ zop'ʉ ja ra̱ ots'i. ");
INSERT INTO otnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hi̱nte ga̱ nda̱tho'ʉ yø ja̱'i̱ nzofo. ");
INSERT INTO otnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nu̱'ʉ yø ja̱'i̱ xi ts'ofo, hɛ̱tho ra̱ Jesús ha ga̱ huanyø nthu̱ts'i̱ 'mø bi̱ mi̱p'ʉ ja ra̱ mɛ̱xa. Bi 'yɛ̱mbʉya: ");
INSERT INTO otnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nu̱'mø to bi zo'i ngue gui̱ nnu̱hʉ ra̱ ntha̱ti̱, 'yogui huanthohʉ yø nthu̱ts'i̱ ta̱te xa̱nho ngue ja gui̱ mmi̱hmʉ p'ʉ. Ntha̱mbɛni̱tho da̱ zø hma̱n'na nc'ɛ̱i̱, nu̱'a̱ ta̱te hnu̱ ma̱nsu̱ ngue nu̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nu̱'a̱ xa̱ nzo'i p'ʉya, ntha̱mbɛ̱ni̱tho da̱ 'yɛ̱n'i: “Da̱mi̱ u̱nna̱ nthu̱ts'i̱ na̱ 'bʉcua n'yø”. Ya gui pɛs'ni̱ sä p'ʉya ngue gni̱ mmi̱p'ʉ ja ra̱ nthu̱ts'i̱ hi̱nga̱ njua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nu̱'mø bi ts'o'i, da̱mi̱ mi̱p'ʉ ja ra̱ nthu̱ts'i̱ bí ja nya̱ni̱, n'namhma̱ ngue nu̱'mø bi zø'a̱ xa̱ nzo'i, da̱ 'yɛ̱n'i p'ʉya: “'Dɛ gui̱ mmi̱cua ja ra̱ nthu̱ts'i̱ xanho n'yø”. Xquet'a̱ 'nɛ̱'ʉ 'dap'ʉ gdi hu̱hmʉ p'ʉ ja ra̱ mɛ̱xa da̱ nu̱ ma̱nsu̱'i̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porque nu̱'a̱ nne ngue ma̱n'na di hnu̱ ma̱nsu̱, gue'a̱ ma̱n'na ts'ʉtho hnu̱ ma̱nsu̱'a̱. Pɛ nu̱'a̱ øt'e ngue hi̱ngui̱ hnu̱ ma̱nsu̱ p'ʉ ga̱ mbɛ̱ni̱, gue'a̱ ma̱n'natho hnu̱ ma̱nsu̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ra̱ Jesús bi 'yɛ̱mbra̱ n'yohʉ xi zixpʉ ja rá̱ ngu̱: ―Nu̱'mø guí øt'a̱ n'na ra̱ nts'i̱hmɛ̱, ogui̱ nzohni̱ amigo, ni̱ xi̱nga̱ gue'ʉ ni̱ n'yohʉ, ni̱ xi̱nga̱ gue'ʉ ni̱ mɛ̱ni̱, ni̱ xi̱nga̱ gue'ʉ ni̱ besino ngue ja te da̱ zi. Porque nu̱'ʉ́, xquet'a̱ da̱ 'yɛ̱hra̱ ora da̱ zo'i ngue gui̱ nsi̱hmɛ̱ui. Ya bi̱ ma ma̱ cots'i'a̱ ra̱ ma̱te xcá̱ 'yørbʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","A nu̱yá, nu̱'mø guí øtra̱ nts'i̱hmɛ̱, da̱mi̱ zo'ʉ yø hyoya di̱ nsi̱hmɛ̱, da̱mi̱ zo'ʉ yø do'yɛ, da̱mi̱ zo'ʉ yø dogua, da̱mi̱ zo'ʉ yø xädä ngue gui 'ui̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ja̱na̱ngue di toca̱'i̱ ra̱ mmɛ̱nthi̱ p'ʉya, porque hi̱nda̱ zä da̱ gu̱t'a̱'i̱ te gui 'yørpe. Pɛ nu̱'mø ra̱ pa da̱ni̱ bɛ̱nna̱te yø hoja̱'i̱ p'ʉya, da̱ gu̱t'a̱'i̱ Oja̱ te xcá̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nu̱'a̱ n'na nc'ɛ̱i̱ mi̱ hu̱p'ʉ ja ra̱ mɛ̱xa p'ʉya, bi 'yøde te mma̱nna̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue ra̱ mmɛ̱nthi̱ di tocabi'a̱ to si̱hmɛ̱ p'ʉ ha di̱ ma̱nda Oja̱ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―N'na ra̱ n'yohʉ, bi 'yøt'a̱ n'na ra̱ da̱nts'i̱hmɛ̱ ngue ra̱ nde. Bi̱ ma̱nda p'ʉya ngue bá̱ ts'ofo xa̱ngu̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nu̱'a̱ ra̱ nde ja ngue di̱ nja ra̱ nts'i̱hmɛ̱ p'ʉya, bi̱ mɛnhná̱ hmi̱qui̱ ra̱ mmɛ̱nni̱gu̱ ngue bá̱ si'ʉ to ya xi ts'ofo. Bi 'yɛ̱mbi̱: “Ma ga̱ mmähä ya, porque ya bi̱ nho'a̱ te da̱ ts'i”. ");
INSERT INTO otnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nu̱'ʉ bá̱ ts'i p'ʉya, ɛ̱na̱ ngue hi̱ngui̱ pongui̱. Nu̱'a̱ rá̱ mʉdi bá̱ ts'ofo bi 'yɛ̱na̱: “Ja dá̱ tän'a̱ n'na ra̱ häi, jatho ngue ga̱ ma nu̱ ya. Da̱mi̱ pu̱nngui̱, nu̱gä hi̱ngui̱ pongui̱ ga̱ mmagä p'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nu̱'a̱ ma̱n'na p'ʉya bi 'yɛ̱na̱: “Ja dí tän'i cʉt'a nt'ɛi yø nda̱ni̱. Nu̱ya dí̱ nne ga̱ sä ya. Da̱mi̱ pu̱nngui̱, nu̱gä hi̱ngui̱ pongui̱ ga̱ mmagä p'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma̱n'na p'ʉya bi 'yɛ̱na̱: “Ja ɛda̱di̱ ntha̱ti̱, ja̱na̱ngue hi̱nda̱ zä ga̱ mmap'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nu̱'mø ma̱mbá̱ pengra̱ hmi̱qui̱, bi xihrá̱ hmu̱ te bá̱ sifi. Bi̱ mbøcuɛ ra̱ hmu̱ p'ʉya. Bi 'yɛ̱mbrá̱ hmi̱qui̱: “Ni̱ ma n'nahma̱ntho p'ʉ ja ra̱ täi ya, 'nɛ̱p'ʉ ja yø caye ua ja ra̱ hni̱ni̱. Bá̱ si ua yø hyoya. Bá̱ si ua yø do'yɛ, bá̱ si ua yø dogua 'nɛ̱hyø xädä”. ");
INSERT INTO otnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ma̱mbá̱ pengra̱ hmi̱qui̱ p'ʉya, bi 'yɛ̱na̱: “Ague grá̱ hmu̱, ya dá̱ øt'e te gá̱ 'bɛjpa̱gui̱ ya. Pɛ tobe mbongui̱tho yø nthu̱ts'i̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bi 'yɛ̱nna̱ hmu̱ p'ʉya: “Nu̱ya ni̱ ma ma̱høn'a̱ p'ʉ ja yø caye 'nɛ̱p'ʉ ja yø 'yu̱ ya. Bí ja ts'ɛdi ngue da̱ ɛ̱cua yø ja̱'i̱ n'namhma̱ ngue da̱ yu̱hma̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porque dí xi'a̱hʉ ngue nu̱'ʉ yø n'yohʉ dá̱ zocä m'mɛt'o, ya hi̱nda̱ zä da̱ ɛ̱hɛ̱ di̱ nsi̱hmɛ̱ua'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xa̱ngu̱ yø ja̱'i̱ ni̱ 'bɛfa p'ʉ ni̱ ma ra̱ Jesús. Bi 'bärbʉya, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Nu̱ te'o tɛnngui̱ 'nɛ̱ zits'ʉtho di̱ ma̱qui̱ ngue'a̱ te gui̱ ma̱hrá̱ papá, ogue rá̱ mamá, ogue rá̱ xisu, ogue yø ba̱si̱, ogue yø n'yohʉ, ogue yø nju̱, ogue su̱ da̱ tho conná̱ ngueque, nu̱ná̱, guehna̱ hi̱mma̱ xädigä na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nu̱ ra̱ ja̱'i̱ hi̱ngui̱ nne da̱ dɛnngui̱ ngue su̱ da̱ tho, guehna̱ ra̱ ja̱'i̱ hi̱mma̱ jua̱ni̱ ma̱ xädigä na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","A nu̱'a̱hʉ ya, xi'mø to da̱ ne da̱ hyø'a̱ n'na ra̱ torre, ua̱ngui̱ 'bet'o da̱ 'yøtrá̱ güɛnda, da̱ nu̱ 'mø ngue ja te di ʉni̱ para ngue da̱ hyätra̱ 'bɛfi, ogue hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Porque nu̱'mø sä di dʉ'mi̱, 'nɛ̱ hi̱nda̱ hyät'a̱ m'mɛfa, da̱ denni̱ to da̱ nu̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Da̱ 'yɛ̱na̱: “Nu̱na̱ ra̱ n'yohʉ 'bʉcua bi dʉ'mrá̱ 'bɛfi, pɛ hi̱ngui̱ sä da̱ hyät'i”, da̱ 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xi'mø ngue n'na ra̱ da̱st'abi ja ngue da̱ 'yørpa̱bi̱ ra̱ tu̱nhni̱ ma̱n'na rá̱ mmi̱da̱st'abiui, ua̱ngui̱ da̱ mi̱ di̱ n'yomfɛ̱ni̱, da̱ zänni̱ ngue'mø da̱ zä di jʉui 'dɛt'a ma̱hua̱hi̱ yø soldado 'mø bá̱ ɛ̱p'ʉ 'däte ma̱hua̱hi̱ ngue ne tu̱nhni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pɛ nu̱'mø hi̱nda̱ zä p'ʉya, nu̱'mø tobe yap'ʉtho bá̱ ɛ̱hrá̱ nsʉiui, da̱ mɛnnba̱ ra̱ hya̱ rá̱ mmi̱nst'abiui p'ʉya ngue di̱ nhojpa̱ui. ");
INSERT INTO otnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Gui̱ njathʉ p'ʉya, ngue gui hya̱cjʉ ra̱ güɛnda, porque ra̱ ja̱'i̱ ngue ta̱te di ma̱'a̱ te pɛts'i, a nu̱gä p'ʉya, zi ts'ʉtho di̱ ma̱qui̱, guehna̱ ra̱ ja̱'i̱ himma̱ xädigä na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Conque ra̱ u̱, xa̱nho'a̱. Pɛ nu̱'mø ya hi̱ngui̱ u̱, ya hi̱nte di̱ mu̱ui. ");
INSERT INTO otnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ni̱ xi̱ngra̱ 'yai ra̱ häi da̱ zä, sinoque da̱ t'ɛntho. A nu̱yá, di̱ nja ni̱ gu̱ ngue gui 'yøhmʉ na̱ ra̱ hya̱ dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gätho yø ngʉthäi 'nɛ̱'ʉ mi̱'da yø ja̱'i̱ t'ɛ̱mbi̱ ngue ja yø ts'oqui bi guarbʉ 'bähra̱ Jesús ngue øts'e te mma̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Gue'a̱ ga̱ nnemhya̱ yø fariseo'a̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley, bi 'yɛ̱na̱: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, guehya yø ja̱'i̱ ja yø ts'oqui nne di̱ nya̱ui 'nɛ̱ 'dap'ʉ si̱hmɛ̱ui na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ja̱na̱ngue ra̱ Jesús bi hyɛca̱ n'na ra̱ hya̱ bi xifi, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Nu̱'a̱hʉ ya, xi'mø di 'bʉi to di si n'na ciento yø dɛ'yo, da̱ 'ue'a̱ n'na ndɛ'yo p'ʉya, ua̱ngui̱ da̱ zop'ʉ'ʉ goho 'däte ma̱'dɛ'ma̱ gʉto ndɛ'yo p'ʉ ja ra̱ da̱po. Da̱ ma da̱ honna̱ n'na ndɛ'yo xa̱ 'uegue asta̱ gue'mø bá̱ ti̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nu̱'mø bá̱ ti̱mp'ʉya, da̱di johya, da̱ hu̱xrá̱ xi̱xi̱, da̱ ɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nu̱'mø bi zøp'ʉ ja rá̱ ngu̱, di pɛtyø amigo 'nɛ̱hyø besino, da̱ 'yɛ̱mbi̱: “Bá̱ ɛ̱hmʉ ya, 'da gda̱ johyathohʉ, porque ya dá̱ ti̱ngä ma̱ dɛ'yo xi̱ m'mɛdi”, da̱ 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Njarbʉtho na̱ dí xi'a̱hʉ ya, ngue'mø bi hyɛp'ʉ ra̱ nts'o ga̱ 'yo n'na ra̱ ja̱'i̱ ja rá̱ ts'oqui. Ma̱n'na ra̱ ndøpähä bí ja ma̱hɛ̱ts'i̱, hi̱nda̱ gue'ʉ goho 'däte ma̱'dɛ'ma̱ gʉto nja̱'i̱ ɛ̱na̱ ngue yø hoja̱'i̱, hi̱n'yʉ yø ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Xi n'na ra̱ xisu 'mø cʉ 'dɛt'a yø mɛ̱nyu̱, di 'bɛ'a̱ n'na p'ʉya, ua̱ngui̱ di sa̱cra̱ nyot'i da̱ gocrá̱ ngu̱, ma̱hotho di hyoni̱ asta̱ gue'mø bi di̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nu̱'mø bi di̱mp'ʉya, di pɛtyø amigo 'nɛ̱ mi̱'da yø besino, da̱ 'yɛ̱mbi̱: “Ma 'da gdá̱ johyathohʉ ya, porque dá̱ ti̱ngä ma̱ mɛ̱nyu̱ dá̱ 'bɛdi”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Njarbʉtho na̱ ra̱ hya̱ dí xi'a̱hʉ ya, ngue bí ja ra̱ johya p'ʉ bí 'bʉhyø anxɛ Oja̱ ngue n'na ra̱ ja̱'i̱ ja rá̱ ts'oqui, da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo. ");
INSERT INTO otnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Mi̱ si yoho yø ts'ʉnt'ʉ n'na ra̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nu̱na̱ ra̱ ts'ʉnt'ʉ cohi bi 'yɛ̱mbrá̱ papá: “Ague papá, da̱mi̱ 'dac'a̱ te ma̱ mmɛti di tocagui̱”, bi 'yɛ̱mbi̱. Nu̱na̱ rá̱ papá p'ʉya, bi u̱nni̱ n'na ngu̱ n'na yø ts'ʉnt'ʉ'a̱ te di tocabi. ");
INSERT INTO otnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hi̱mma̱ ya'atho yø pa p'ʉya, nu̱na̱ ra̱ ts'ʉnt'ʉ cohi, bi pɛti gätho'a̱ te rá̱ mmɛti, bi hya̱ts'i̱, bi̱ ma ma̱n'na ra̱ häi yap'ʉtho. Ja bi ʉmma̱ ʉni̱tho p'ʉ rá̱ mɛ̱nyu̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pɛ nu̱'mø mi̱ hyäti gä bi ʉnná̱ mɛ̱nyu̱, nu̱p'ʉ ja ra̱ häi 'bʉi, bi̱ nja n'na ra̱ thu̱hu̱. Ya hi̱n'yʉ te da̱ zi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bi̱ map'ʉ 'bʉ'a̱ n'na ra̱ n'yohʉ ngue bi 'yänna̱ 'bɛfi p'ʉya. Nu̱na̱ ra̱ n'yohʉ p'ʉya, bi 'bɛpi ngue da̱ märpa̱ yø ts'ʉdi p'ʉ bí ja rá̱ häi. ");
INSERT INTO otnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I̱ nne da̱ za'ʉ yø jʉza sa yø ts'ʉdi p'ʉya, pɛ hi̱njondi̱ u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ya ɛ̱mp'ʉya: “Nu̱p'ʉ ja rá̱ ngu̱ ma̱ papágä, xa̱ngu̱ yø hmi̱qui̱ di̱ mpɛp'ʉ, pɛ mbongui̱tho te da̱ zi. Nu̱gä p'ʉya, dí tu̱gä ra̱ thu̱hu̱ ua. ");
INSERT INTO otnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma ga̱ pengä p'ʉ bí 'bʉhma̱ papá ya. Ga̱ ɛ̱mbi̱: Ague papá, ra̱ ts'oqui dá̱ øt'a̱'i̱, xquet'a̱ ra̱ ts'oqui dá̱ ørpa̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya hi̱nni̱ 'yu̱p'ʉ gui 'yɛ̱na̱ ngue ni̱ ba̱si̱gui̱ ya. Gui 'yø'ni̱ güɛnda ngue nu̱gä tengu̱tho'ʉ ni̱ mɛfi guí si, di̱ njarbʉtho p'ʉ gdi bɛ̱ngui̱, ga̱ ɛ̱mbi̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bi hya̱ ra̱ 'yu̱ p'ʉya bi̱ mengui̱, i̱ ma rá̱ ngu̱ rá̱ papá. Nu̱'mø tobe yap'ʉtho bá̱ ɛ̱ p'ʉya, bi hyandrá̱ papá, bi huɛ̱qui̱. Bi̱ ma p'ʉya ngue di c'at'ui, asta̱ hʉfi 'nɛ̱ di u̱nna̱ beso. ");
INSERT INTO otnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nu̱na̱ ra̱ ts'ʉnt'ʉ p'ʉya, bi 'yɛ̱mbrá̱ papá: “Ague papá, ra̱ ts'oqui dá̱ øt'a̱'i̱, xquet'a̱ ra̱ ts'oqui dá̱ ørpa̱bi̱ Oja̱. Ya hi̱nni̱ 'yu̱p'ʉ gui 'yɛ̱ngui̱ ngue ni̱ ba̱si̱gui̱ ya”. ");
INSERT INTO otnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nu̱'a̱ rá̱ papá p'ʉya, ɛ̱mbyø hmi̱qui̱: “N'nahma̱ntho bá̱ ca̱hmi̱ ra̱ u̱lu ta̱te xa̱nho, da̱mi̱ hetui. Da̱mi̱ hyu̱rpa̱ui n'na ra̱ mfo'yɛ rá̱ 'yɛ. Da̱mi̱ u̱nnui yø 'boxthi̱ da̱ di̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bá̱ siui n'na ra̱ nda̱ni̱ xa̱noqui ga̱ hohʉ. Ma ga̱ n'øt'a̱ ngohʉ, ga̱ nsi̱hmɛ̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porque nu̱na̱ ma̱ ts'ʉnt'ʉgä 'bʉcua, tengu̱tho 'mø xi du̱ na̱, a nu̱yá, tengu̱tho 'mø ma̱'da'yo bi̱ m'mʉi. Ya xi̱ m'mɛdi, pɛ ma̱høndá̱ nu̱hʉ ya”. Bi̱ mʉdi bi̱ n'øt'a̱ngo p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ma̱mbí 'yo ra̱ 'bɛfi'a̱ rá̱ ts'ʉnt'ʉ ma̱ da̱p'ʉya. Nu̱'mø ni̱ ma da̱ zøp'ʉ ja ra̱ ngu̱'a̱ ra̱ ts'ʉnt'ʉ ma̱mbí 'yo ra̱ 'bɛfi p'ʉya, bi 'yøde ngue ja yø 'bida, 'bʉhyø nɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bi zonhna̱ n'na'ʉ yø hmi̱qui̱ p'ʉya, bi 'yänni̱ te 'bɛ'a̱ ma̱ ngo i ja. ");
INSERT INTO otnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nu̱'a̱ ra̱ hmi̱qui̱ p'ʉya bi 'yɛ̱mbi̱: “Ni̱ papá'a̱ øt'a̱ngo ngue ni̱ n'yohʉ xa̱ nzøhø. Xa̱ ma̱nda ngue xa̱ tho n'na ra̱ nda̱ni̱ ya xi̱ noqui, porque nnu̱ rá̱ ts'ʉnt'ʉ ngue hi̱nte di ja”. ");
INSERT INTO otnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bi̱ mbøcuɛ p'ʉya, hi̱ngui̱ nne da̱ yʉt'a̱mbo. Bá̱ pønna̱ papá p'ʉya, bi xifi ngue da̱ yʉt'a̱mbo. ");
INSERT INTO otnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pɛ nu̱'mø mi̱ da̱ p'ʉya, bi 'yɛ̱mbrá̱ papá: “Ya xa̱ mma yø jɛya dí øt'a̱ ni̱ 'bɛfi, nu̱gä hi̱nja̱m'mø xtá̱ fɛts'i te guí̱ mma̱. Pɛ hi̱nja̱m'mø xcá̱ 'daca̱ n'na ra̱ zichivo ngue ga̱ nsänni̱go'be ma̱ amigo. ");
INSERT INTO otnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pɛ nu̱yá, nu̱'mø mi̱ zøhna̱ ni̱ ts'ʉnt'ʉ bi ʉn'na̱ ni̱ mɛ̱nyu̱ ngue yø 'uɛsi, go xcá̱ hyopra̱ nda̱ni̱ na̱ya”. ");
INSERT INTO otnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nu̱na̱ rá̱ papá p'ʉya, bi 'yɛ̱mbrá̱ ts'ʉnt'ʉ: “Ague ts'ʉnt'ʉ, nu̱'i̱ ya 'daua dí 'bʉhmi̱. Nu̱'a̱ te gä dí pɛts'ä, gä ni̱ mmɛti. ");
INSERT INTO otnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pɛ nu̱yá, xa̱nhotho ngue di̱ njajʉ mpähä, ga̱ øthʉ ra̱ ngo. Porque nu̱na̱ ni̱ n'yohʉ, tengu̱tho 'mø ya xi du̱ na̱, ma̱'da'yo ngue bi̱ m'mʉi. Ya xi̱ m'mɛdi, pɛ ma̱høndá̱ nu̱hʉ ya”. ");
INSERT INTO otnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Mi̱ 'bʉ'a̱ n'na ra̱ mmɛ̱mmɛti ngue si n'na rá̱ hmi̱qui̱ di̱ ma̱ndabi̱ yø mɛfi. Nu̱na̱ ra̱ mmɛ̱mmɛti p'ʉya, bi sifi ngue di ʉnnba̱tho rá̱ mɛ̱nyu̱ na̱ rá̱ hmi̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ra̱ mmɛ̱mmɛti p'ʉya, bi 'yɛ̱mbi̱: “Ague n'yø, ¿hanja na̱ ra̱ hya̱ dí øcä si'i̱? Da̱mi̱ däcra̱ güɛnda'a̱ ra̱ 'bɛfi guí øt'e, porque ya hi̱nni̱ mantho gui̱ ma̱ndagui̱ ma̱ hmi̱qui̱gä”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","A nu̱na̱ ra̱ hmi̱qui̱ di̱ ma̱nda yø mɛfi p'ʉya, i ɛ̱nsɛ: “¿Teni̱ 'bɛ'a̱ ga̱ øt'ä 'mø ya hi̱ndi̱ 'dacä ra̱ 'bɛfi ma̱ hmu̱ ya'mø? Nu̱gä ya hi̱ngui̱ sä ga̱ mpɛfi. Nu̱'mø ga̱ ha̱xra̱ limosna, dí pɛs'ma̱ sä. ");
INSERT INTO otnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A nu̱yá, ya dí pa̱di̱ te ga̱ øtya para ngue ya di 'bʉi to bi 'dacra̱ ts'äya p'ʉ ja yø ngu̱ 'mø bi tha̱ga̱ ma̱ 'bɛfi”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bi̱ mʉdi bi zonhni̱ 'da mi̱'da'ʉ to tu̱prá̱ hmu̱ p'ʉya. Nu̱na̱ rá̱ mʉdi bi zonhni̱, bi 'yɛ̱mbi̱: “¿Hangu̱ guí tu̱hma̱ hmu̱gä?” ");
INSERT INTO otnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ra̱ n'yohʉ p'ʉya bi 'yɛ̱na̱: “Dí tu̱pa̱ n'na ciento barre ra̱ aceite”. Nu̱na̱ ra̱ hmi̱qui̱ p'ʉya bi 'yɛ̱mbi̱: “Ja ua ra̱ sʉcua̱ n'youi ni̱ güɛnda 'mø. Pɛ da̱mi̱ mi̱ ya, gui 'yør'ma̱n'na, gui cuati ngue yote ma̱'dɛt'a barre guí̱ ndu̱pa̱te”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","M'mɛfa p'ʉya, bi 'yän ma̱n'na nc'ɛ̱i̱, bi 'yɛ̱mbi̱: “Xi'i, ¿hangu̱ guí tu̱hma̱ hmu̱gä?” Bi 'yɛ̱n'a̱ ts'o p'ʉya: “N'na ciento t'ɛni̱ ra̱ trigo”. Bi 'yɛ̱mbʉya: “Ja ua ra̱ sʉcua̱ n'youi ni̱ güɛnda 'mø. Pɛ da̱mi̱ 'yør'ma̱n'na ya, ngue høndi goho 'däte t'ɛni̱ gui cuati ngue guí̱ ndu̱pa̱te”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nu̱'a̱ ra̱ hmu̱, i ɛ̱spa̱'a̱ ra̱ ts'omɛfi ngue pa̱di̱ ha di japi da̱ hyätyø amigo. Yø ja̱'i̱ 'bʉ'a̱ nxi̱mhäi ja̱njua̱ni̱ ga̱ mba̱di̱ ha di hyätyø amigo, a nu̱ yø ja̱'i̱ ngue yø 'yɛ̱c'ɛ̱i̱ hi̱ngui̱ njap'ʉ'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nu̱gä dí xi'a̱hʉ, da̱mi̱ usahʉ ra̱ mɛ̱nyu̱ nu̱'a̱ di usa yø ts'oc'ɛ̱i̱ ua ja ra̱ xi̱mhäi ngue gdí hyonni̱ amigohʉ. A nu̱'mø gá̱ hyä'ni̱ mɛ̱nyu̱hʉ p'ʉya, ya di 'bʉi to di 'da'a̱hʉ ra̱ ts'äya p'ʉ ha gui̱ m'mʉhmʉ para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nu̱'a̱ da̱ bømma̱nho, ma̱da̱gue'a̱ ts'ʉtho da̱ ma ma̱fäti, ma̱n'natho da̱ bømma̱nho 'mø da̱ ma ma̱fäti xa̱ngu̱. A nu̱'a̱ hi̱nda̱ bømma̱nho, 'nɛ̱ ts'ʉtho da̱ ma ma̱fäti, ma̱ xtá̱ngu̱ da̱ ma ma̱fäti, pɛ hi̱nda̱ bømma̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Xi'mø hi̱ngui̱ pømma̱nhohʉ 'mø ma̱fäti'a̱hʉ ra̱ mɛ̱nyu̱ ja ua ja ra̱ xi̱mhäi, ¿te'o guí ɛ̱na̱ di fät'a̱hʉ'a̱ ma̱jua̱ni̱ ngue xa̱nho 'mø? ");
INSERT INTO otnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Xi'mø ngue hi̱ngui̱ pømma̱nhohʉ 'mø ma̱fäti'a̱hʉ ra̱ mɛ̱nyu̱ ndan'yo to rá̱ mmɛti, ¿te'o guí ɛ̱na̱ di 'da'a̱hʉ'a̱ ja ngue da̱ zo ni̱ 'yɛhʉ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hi̱nga̱ n'na ra̱ hmi̱qui̱ da̱ zä ngue yoho yø hmu̱ di̱ m'mʉi. A nu̱'mø ngue yoho yø hmu̱ di̱ m'mʉi, n'na'a̱ di̱ ma̱di̱, n'na'a̱ hi̱ndi̱ ma̱di̱. N'na rá̱ hmu̱ da̱ 'yørpe te di̱ ma̱nda, ma̱n'na rá̱ hmu̱ hi̱nda̱ 'yørpe te di̱ ma̱nda. Gui̱ njathʉ p'ʉya, hi̱ngui̱ sä ngue mbø yoho p'ʉ di̱ ma ni̱ mmʉihʉ. Di̱ ma ni̱ mmʉihʉ Oja̱, xi̱ndi̱ ma ni̱ mmʉihʉ ra̱ mɛ̱nyu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nu̱'ʉ yø fariseo, ngue høndra̱ mɛ̱nyu̱ nne, gä bi 'yøxtho na̱ ra̱ hya̱ mma̱nna̱ Jesús. Pɛ thentho'a̱ te øde hma̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ra̱ Jesús bi 'yɛ̱mbi̱: ―A nu̱yá, gui härpa̱hʉ yø dä yø ja̱'i̱, porque xøgue ɛ̱na̱ ma̱jua̱ni̱ ngue gyø hoja̱'i̱hʉ p'ʉ gui̱ nɛ̱qui̱. Pɛ nu̱na̱ Oja̱ hi̱nda̱ zä gui hyäthʉ na̱, i pa̱di̱ te ja mbo ni̱ mmʉihʉ na̱. Porque nu̱'a̱ ngue yø ja̱'i̱tho nnu̱ ma̱nho te øt'e, hi̱nga̱ gue'a̱ nnu̱ ma̱nho Oja̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nu̱'ʉ yø pa bá̱ m'mʉhra̱ Xuua, ya mi̱ hma̱nna̱ ley bi 'yotra̱ Moisés, ya mi̱ hma̱n'a̱ te ra̱ hya̱ bi̱ nxännba̱te yø pønga̱hya̱ Oja̱. Asta̱ gue'ʉ yø pa'ʉ ya, i sihra̱ hoga̱ 'da'yo hya̱ yø ja̱'i̱ ha di zo rá̱ 'yɛ Oja̱. Gätho yø ja̱'i̱ di ja ndu̱mmʉi ngue da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pɛ ma̱n'na hi̱ngui̱ hɛ̱nni̱ ngue da̱ guahra̱ c'ama̱hɛ̱ts'i̱ 'nɛ̱hra̱ häi, hi̱nda̱ gue'a̱ ngue da̱ t'ɛ̱mbi̱ hi̱ngui̱ ja ts'ɛdi'a̱ te nt'ot'i p'ʉ ja rá̱ ley Oja̱, ma̱da̱gue'a̱ ts'ʉtho. ");
INSERT INTO otnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nu̱'ʉ yø n'yohʉ di̱ nxu̱mmi̱ yø xisu, nu̱'mø hømbi̱ ntha̱tra̱ n'yohʉ, da̱ mɛ ma̱n'na ra̱ xisu, ya ra̱ ts'oqui øtra̱ n'yohʉ. Nu̱'mø bi̱ ntha̱tra̱ xisu bi t'ɛi, ya ra̱ ts'oqui øt'ui ra̱ n'yohʉ bi̱ mɛ. ");
INSERT INTO otnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mi̱ 'bʉ'a̱ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱mmɛti. Mi̱ he yø u̱lu ta̱te xa̱nho. N'na pa ngu̱ n'na pa, ɛ̱ntho øt'a̱ngo ngue di yoxni̱ p'ʉ si̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Xquet'a̱ mi̱ 'bʉ'a̱ n'na ra̱ hyoya ni̱ hu̱ ngue ra̱ Lázaro. Xi guahyø sa̱si̱ na̱ ra̱ Lázaro, hu̱p'ʉ ja rá̱ goxthi ra̱ mmɛ̱mmɛti. ");
INSERT INTO otnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nu̱na̱ ra̱ hyoya na̱, i̱ nnehma̱ da̱ zi'ʉ yø xɛmhmɛ̱ täp'ʉ ja rá̱ mɛ̱xa ra̱ mmɛ̱mmɛti, pɛ hi̱ndi̱ u̱nni̱. Nu̱'mø bi thop'ʉ yø fo'yo, tespa̱bi̱ yø sa̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pɛ bi zønna̱ pa bi du̱ na̱ ra̱ Lázaro. Yø anxɛ Oja̱ p'ʉya, bi zixpʉ 'bʉhra̱ Abraham. Xquet'a̱ bi du̱ ra̱ mmɛ̱mmɛti p'ʉya, bá̱ t'ägui. ");
INSERT INTO otnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nu̱p'ʉ ja ra̱ ni̱du̱ sä ra̱ n'ʉ p'ʉya, bi̱ nhanni̱, bi hyannbʉ yap'ʉtho p'ʉya, ngue bí 'bʉp'ʉ ra̱ Abraham, 'dap'ʉ 'bʉhmi̱ ra̱ Lázaro. ");
INSERT INTO otnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ra̱ mmɛ̱mmɛti bi 'yɛ̱na̱: “Ague ma̱ papá'i Abraham, da̱mi̱ huɛ̱ga̱gui̱. Bá̱ pɛnhna̱ Lázaro di po rá̱ saha conna̱ dehe. Da̱ ɛ̱hɛ̱ di pogba̱gui̱ ma̱ ja̱ni̱. Porque dí sägä ra̱ n'ʉ ua ja yø sibi”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ra̱ Abraham bi 'yɛ̱mbi̱: “Ague ts'ʉnt'ʉ'i, da̱mi̱ bɛ̱ni̱ ngue gá̱ m'mʉmma̱nho mɛ̱nte ra̱ pa gá̱ m'mʉi. A nu̱na̱ ra̱ Lázaro bi zä ra̱ n'ʉ na̱. A nu̱yá, go 'bʉmma̱ pähä ua na̱ya, go guí sä ra̱ n'ʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","I ja ma̱n'na ra̱ hya̱ ya. Xa̱ndønhɛ̱ ua hapʉ nná̱ nhyacjʉ. Ja̱na̱ngue nu̱ to da̱ ne di̱ map'ʉ, hi̱nda̱ zä da̱ thogui. A nu̱'ʉ ni̱ gop'ʉ, hi̱nda̱ zä dí 'yɛ̱cua'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bi 'yɛ̱nna̱ mmɛ̱mmɛti p'ʉya: “Pɛ dí ä'i ra̱ ma̱te ma̱ papá'i Abraham, ngue gui pɛnhna̱ Lázaro p'ʉ ja rá̱ ngu̱ ma̱ papágä. ");
INSERT INTO otnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Porque 'bʉp'ʉ mi̱cʉt'a ma̱ n'yohʉ. Da̱ zä da̱ xifi te dí thocä ua, n'namhma̱ hi̱nda̱ ɛ̱cua ha dí sägä ra̱ n'ʉ 'mø bi du̱'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ra̱ Abraham bi 'yɛ̱mbi̱: “Nu̱ya guí̱ mma̱, da̱ zä di xä'ʉ yø hya̱ bi 'yotra̱ Moisés, da̱ gue'ʉ bi 'yotyø pønga̱hya̱ Oja̱. Da̱ 'yørpa̱ ma̱su̱'a̱ ra̱ hya̱ hma̱mp'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ɛ̱nna̱ mmɛ̱mmɛti p'ʉya: “a̱há̱ ma̱ papá'i Abraham, gue'a̱ guí̱ mma̱. Pɛ nu̱'mø da̱ ma n'na ra̱ ánima da̱ xifi te ja ua, da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo'ʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ra̱ Abraham bi 'yɛ̱mbi̱: “Nu̱'mø hi̱ngui̱ t'ɛ̱c'ɛ̱i̱'a̱ te ra̱ hya̱ bi 'yotra̱ Moisés 'nɛ̱'a̱ te bi 'yotyø pønga̱hya̱ Oja̱, ma̱da̱gue'a̱ di bɛ̱nna̱te n'na ra̱ ánima da̱ ma da̱ nya̱ui, xquet'a̱ ngu̱tho hi̱nda̱ 'yɛ̱c'ɛ̱i̱ ra̱ hya̱ da̱ sifi”. ");
INSERT INTO otnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Nu̱yá, hi̱ndi̱ 'bɛdi tema̱ cosa ga̱ 'yøtra̱ ts'oqui yø ja̱'i̱. Pɛ hague ngu̱ ra̱ castigo da̱ thohra̱ ja̱'i̱ da̱ japi da̱ 'yøtra̱ ts'oqui rá̱ mmi̱c'ɛ̱i̱ui. ");
INSERT INTO otnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma̱n'na xa̱nho ngue da̱ thørbʉ ja ra̱ ja̱the di̱ ntha̱rpa̱ n'na ra̱ jʉni̱ p'ʉ ja rá̱ 'yʉga ngue da̱ gʉ'mi̱, hi̱nda̱ gue'a̱ ngue da̱ japi da̱ 'yøtra̱ ts'oqui ya yø ja̱'i̱ zits'ʉtho ɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Da̱mi̱ mfähmʉ ma̱mi̱ njahʉ p'ʉ. Nu̱'mø hi̱nguí̱ nnu̱ ma̱nho te bi 'yøt'a̱'i̱ ni̱ cu̱, da̱mi̱ hɛjpi. Nu̱'mø bi hyɛp'ʉ ra̱ nts'o øt'e, da̱mi̱ pu̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma̱da̱gue'a̱ nyoto nni̱di̱ n'na pa da̱ 'yøt'a̱'i̱'a̱ hi̱ngui̱ nnu̱ ma̱nho, 'nɛ̱ nyoto nni̱di̱ da̱ 'yɛ̱n'i̱: “Da̱mi̱ pu̱nngui̱”, da̱ 'yɛ̱n'i̱, da̱mi̱ pu̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bi 'yɛ̱mbyø xädi ra̱ Jesús: ―Ague grá̱ Hmu̱, nu̱'mø te nt'äpi Oja̱, da̱mi̱ 'yøt'e ngue ga̱ ɛ̱c'ɛ̱i̱he xa̱nho ngue di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱'mø di ja zits'ʉ ni̱ nt'ɛ̱c'ɛ̱i̱hʉ, ma̱da̱gue'a̱ da̱ngu̱ ga̱ nnoho n'na zihmu̱dä ra̱ mostasa, nu̱nʉ n'na nza ra̱ sicómoro 'bähnʉ, da̱ zä gui 'yɛ̱mphʉ: “Da̱mi̱ 'uecua guí 'bäi, i̱ m'map'ʉ ja ra̱ ja̱the”, gui 'yɛ̱mphʉ. Nu̱na̱ ra̱ za, di̱ map'ʉ gui xihmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nu̱'a̱hʉ ya, xi'mø di 'bʉ'a̱ n'na nc'ɛ̱i̱ ngue di si n'na rá̱ hmi̱qui̱, nu̱'mø bi zøhra̱ 'bɛfi ra̱ hmi̱qui̱ ngue xpa̱ nua̱fani̱ ogue fändɛ'yo, ¿ua da̱ 'yɛ̱mbrá̱ hmi̱qui̱: “Da̱mi̱ mi̱hya gui̱ nsi̱hmɛ̱”? ");
INSERT INTO otnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ua̱ngui̱ hi̱n'na̱. Sinoque da̱ 'yɛ̱mbrá̱ hmi̱qui̱: “Da̱mi̱ hoga̱gui̱ te ga̱ si. Da̱mi̱ nsä gui 'daqui te ga̱ si mɛ̱nte ga̱ nsi̱hmɛ̱gä. Nu̱'mø dá̱ juategä ra̱ nts'i̱hmɛ̱ p'ʉya, ja gui̱ nsi̱hmɛ̱”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ua di ja ma̱mma̱di̱ rá̱ hmi̱qui̱ ngue bi 'yøt'e te bi 'bɛpi? Conque hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Xquet'a̱ gui̱ njathʉ p'ʉya, nu̱'mø gá̱ juadi gá̱ 'yøthʉ'a̱ ra̱ 'bɛfi di 'bɛp'a̱hʉ Oja̱, gui 'yɛ̱mhmʉ p'ʉya: “Hi̱n'yʉ te dí hnu̱ ma̱nhogähe, porque nu̱'a̱ ra̱ 'bɛfi bi̱ m'mɛjpa̱he ga̱ øthe, hønt'a̱ dá̱ øthe'a̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nu̱na̱ ra̱ Jesús, bi thogui i̱ ma Jerusalén. I̱ nthop'ʉ ja ra̱ hyodi di̱ ntøt'ui ra̱ häi Samaria'a̱ ra̱ häi Galilea. ");
INSERT INTO otnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mi̱ zømp'ʉ ja n'na ra̱ hni̱ni̱ p'ʉya, ma̱mbá̱ ɛ̱p'ʉ 'dɛt'a nja̱'i̱ yø därquɛ̱hi̱ mi̱ hɛ̱mbra̱ ts'o'ya. Yap'ʉtho bá̱ ɛ̱hyø därquɛ̱hi̱ 'mø mi̱ hyandi̱, pɛ 'bexpá̱ m'mäi. ");
INSERT INTO otnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bi̱ marpʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te Jesús, huɛ̱ga̱he, da̱mi̱ 'yøthega̱he. ");
INSERT INTO otnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mi̱ hyandyø därquɛ̱hi̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ya da̱mi̱ sømhmʉ p'ʉ 'bʉhyø mmäcja̱ ya, gui xifi ngue ya bi zä'a̱hʉ. Mɛ̱nte ni̱ 'yo yø därquɛ̱hi̱ ngue ni̱ map'ʉ 'bʉhyø mmäcja̱ p'ʉya, bi zä ra̱ n'ʉ mi̱ hɛ̱mbi̱ n'na ngu̱ n'na. ");
INSERT INTO otnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nu̱'a̱ n'na nc'ɛ̱i̱'ʉ mi̱ ʉ p'ʉya, mi̱ nu̱ ngue ya bi zä ra̱ n'ʉ mi̱ hɛ̱mbi̱, bi̱ mengbʉya. Pɛ ja̱njua̱ni̱ ngue nts'ɛdi guí ja ma̱mma̱di̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bi nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús, asta̱ di søt'a̱häi rá̱ hmi̱ ha gui ja ma̱mma̱di̱. Nu̱na̱ ra̱ n'yohʉ na̱, ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ häi Samaria. ");
INSERT INTO otnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Bi 'yɛ̱nna̱ Jesús: ―¿Ua̱ngui̱ 'dɛt'a nja̱'i̱ bi zä ra̱ n'ʉ mi̱ hɛ̱mbi̱? ¿Hapʉ 'bʉ'ʉ mi̱ gʉto ya? ");
INSERT INTO otnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hi̱njo mma̱n'na xta̱bá̱ mmengui̱ ngue di ja ma̱mma̱di̱ Oja̱, hi̱nda̱ hønna̱ n'na nc'ɛ̱i̱ hi̱ngra̱ judío bá̱ pengui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ra̱ Jesús bi 'yɛ̱mbra̱ n'yohʉ ma̱rá̱ därquɛ̱hi̱: ―Da̱mi̱ nangui̱, ni̱ ma. Ya bi zä'i ngue gá̱ 'yɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yø fariseo bi 'yänna̱ Jesús ngue nja̱m'mø da̱ zøcua Oja̱ ngue di̱ ma̱nda ua. Bi 'yɛ̱mbʉya: ―Nu̱'mø bi zøcua Oja̱ ngue di̱ ma̱nda ua, hi̱ngra̱ cosa di̱ nɛ̱qui̱ ngue da̱ hnu̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Porque hi̱nda̱ zä da̱ 'yɛ̱nyø ja̱'i̱: “Nu̱ua, ja bí ja ua”, ogue “Nu̱nʉ, ja bí ja nʉ”. Porque Oja̱ ya di̱ ma̱nda ua guí 'bʉhmʉ'a̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bi 'yɛ̱mbyø xädi p'ʉya: ―Da̱ 'yɛ̱hra̱ pa guí̱ nne gui̱ nnu̱hʉ'a̱ ra̱ pa da̱ zøhra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱, pɛ hi̱ngui̱ nnu̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Da̱ 'yɛ̱n'a̱hʉ yø ja̱'i̱'a̱ ra̱ pa'a̱: “Ma nu̱hʉ ni̱nguehnʉ”, ogue “Ma̱ nu̱hʉ ni̱nguecua”, da̱ 'yɛ̱n'a̱hʉ. 'Yo sä gui tɛnhnʉ hapʉ di̱ ma yø ja̱'i̱ ngue guá̱ honjʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porque nu̱'mø bi zønna̱ pa da̱ ɛ̱hra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱, gätho yø ja̱'i̱ da̱ hyandi̱. Tengu̱tho 'mø bi yotra̱ huɛi, to bi zä handi̱, di̱ njarbʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pɛ nuyá, jatho ngue 'be ga̱ sägä xa̱ngu̱ ra̱ n'ʉ, ngue hi̱nda̱ nu̱ ma̱nhogä yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tengu̱tho bá̱ nja'mø yø pa ma̱mbá̱ m'mʉhra̱ Noé, xquet'a̱ ngu̱'a̱ di̱ nja'a̱ ra̱ pa da̱ ɛ̱hra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Porque nu̱'a̱ ra̱ pa'a̱, mi̱ si̱hmɛ̱ yø ja̱'i̱, ma̱di̱ ntha̱ti̱ 'da, ja t'äpyø t'i̱xu̱ 'da. Pɛ hi̱mbi̱ u̱nna̱ güɛnda yø ja̱'i̱ te ja ngue di̱ nja, asta̱ ja gue'mø ra̱ pa mi̱ yʉtra̱ Noé p'ʉ ja ra̱ barco. Mi̱ nja ra̱ nda̱te 'ye p'ʉya, bi juadi gätho yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Njarbʉtho'a̱ te bi̱ nja'mø yø pa mi̱ m'mʉhra̱ Lot. Mi̱ si̱hmɛ̱ yø ja̱'i̱, te'o di̱ ntäi, te'o i̱ mpä, te'o tu̱hyø hua̱hi̱, mi̱ hønni̱gu̱ 'da. ");
INSERT INTO otnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pɛ nu̱'a̱ ra̱ pa bi sihra̱ Lot ngue bi bømp'ʉ ja ra̱ hni̱ni̱ Sodoma, bá̱ høhma̱ya̱ yø asufre ngue da̱nzø, bi juadi gätho'ʉ mi̱ 'bʉp'ʉ ja ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ma̱høndi̱ njarbʉtho yø ja̱'i̱ 'mø bá̱ ɛ̱hra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nu̱'a̱ ra̱ pa'a̱, nu̱ ra̱ ja̱'i̱ dí tøhma̱ xøts'e rá̱ ngu̱, 'yo di ɛ̱na̱ ngue di̱ ma mbo rá̱ ngu̱ ngue te da̱ ha̱, sinoque da̱ 'dagui. Nu̱ ra̱ ja̱'i̱ dí 'yo ra̱ 'bɛfi, hi̱ndi̱ ma rá̱ ngu̱ ngue te da̱ ha̱, sinoque da̱ 'dagui n'nahma̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Da̱mi̱ bɛ̱mhmʉ'a̱ te bi thohrá̱ xisu ra̱ Lot. ");
INSERT INTO otnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nu̱'a̱ te'o nne di̱ mpommi̱ ra̱ nda̱te, gue'a̱ di̱ m'mɛ'a̱. Pɛ nu̱'a̱ te'o da̱ 'yɛnná̱ te conná̱ nguecä, gue'a̱ di̱ nya̱n'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Dí xi'a̱hʉ ngue nu̱'a̱ ra̱ xu̱i̱'a̱, yo nc'ɛ̱i̱ di oxpʉ ja rá̱ t'ots'i. N'na nc'ɛ̱i̱ da̱ ts'its'i, n'na nc'ɛ̱i̱ da̱ gohi. ");
INSERT INTO otnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yoho yø xisu 'dap'ʉ di̱ ncʉni̱. N'na nc'ɛ̱i̱ da̱ ts'its'i, n'na nc'ɛ̱i̱ da̱ gohi. ");
INSERT INTO otnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yoho yø n'yohʉ 'dap'ʉ da̱di̱ mpɛfi. N'na nc'ɛ̱i̱ da̱ ts'its'i, n'na nc'ɛ̱i̱ da̱ gohi. ");
INSERT INTO otnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mi̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ na̱, ɛ̱nyø ja̱'i̱ p'ʉya: ―¿Pɛ hapʉ di̱ nja na̱ ra̱ hya̱ guí̱ mma̱mp'ʉya grá̱ hmu̱? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱p'ʉ dí 'bʉhyø ja̱'i̱ ni̱ 'yu̱p'ʉ da̱ tha̱spa̱ ra̱ güɛnda, ja di̱ njap'ʉ ra̱ castigo. ");
INSERT INTO otnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bi hyɛcra̱ hya̱ bi xihyø ja̱'i̱ ra̱ Jesús. Bi xännba̱ yø ja̱'i̱ ngue jatho za̱nt'a̱ da̱ mat'Oja̱, hi̱nha di gohyø mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Bi 'yɛ̱mbʉya: ―Nu̱p'ʉ ja n'na ra̱ hni̱ni̱, mi̱ 'bʉp'ʉ n'na ra̱ ts'ʉt'abi ngue hi̱ngui̱ su̱ rá̱ mmi̱c'ɛ̱i̱ui, ni̱ xi̱nga̱ gue Oja̱ di su̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nu̱'a̱ ra̱ hni̱ni̱'a̱ p'ʉya, xquet'a̱ mi̱ 'bʉp'ʉ n'na ra̱ 'danxu̱ ngue njandyatho pap'ʉ 'bʉhra̱ ts'ʉt'abi ngue äpra̱ ts'ʉt'abi rá̱ nsʉiui. ");
INSERT INTO otnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nu̱na̱ ra̱ ts'ʉt'abi, bi̱ ma njammi̱ pa ngue hi̱ngui̱ ørpa̱ ma̱su̱ na̱ ra̱ 'danxu̱. Pɛ m'mɛfa p'ʉya, bi 'yɛ̱na̱: “Nu̱gä hi̱ndí̱ su̱gä Oja̱, ni̱ xi̱nga̱ guehma̱ mmi̱c'ɛ̱i̱'be dí su̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","A nu̱yá, para ngue hi̱nni̱ mantho di xu̱na̱nyagä ua na̱ ra̱ 'dansu̱, ma ga̱ ørpa̱ ra̱ ts'ʉt'abi, n'namhma̱ ngue ya hi̱nni̱ mantho da̱ ɛ̱hɛ̱ di xu̱na̱nyagui”. ");
INSERT INTO otnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bi sigue bi 'yɛ̱nna̱ Jesús: ―Guehna̱ ra̱ hya̱ bi̱ ma̱nna̱ ts'ʉt'abi ngue ra̱ ts'oc'ɛ̱i̱ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xi Oja̱ ya, ¿ua hi̱nda̱ 'yørpa̱bi̱ ra̱ ts'ʉt'abi ya yø ja̱'i̱ xa̱ huanhni̱, i̱ nzofo ra̱ pa ra̱ xu̱i̱? Xi'mø bi zofo, ¿ua hi̱nga̱ 'be xta̱ mäts'i? ");
INSERT INTO otnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dí xi'a̱hʉ ngue n'na zihma̱ntho da̱ mäts'i. Nu̱'mø bi zøhra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱, ¿ua da̱ di̱nyø ja̱'i̱ di ɛ̱c'ɛ̱i̱ ua ja ra̱ xi̱mhäi? ");
INSERT INTO otnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma̱hømbi̱ hyɛj ma̱n'na ra̱ hya̱ bi xihyø ja̱'i̱ ra̱ Jesús, porque 'bʉhyø ja̱'i̱ ɛ̱na̱ ngue ma̱n'na xa̱nho ngue mi̱'da yø mmi̱c'ɛ̱i̱ui. Bi 'yɛ̱mbyø ja̱'i̱ p'ʉya: ");
INSERT INTO otnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Yoho yø n'yohʉ bi̱ ma bá̱ mat'Oja̱ p'ʉ ja ra̱ ni̱ja̱. Nu̱'a̱ n'na nc'ɛ̱i̱, ra̱ fariseo'a̱. Nu̱'a̱ ma̱n'na nc'ɛ̱i̱ p'ʉya, ra̱ ngʉthäi'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nu̱'a̱ ra̱ fariseo 'bäi ha ga̱ mmat'Oja̱, i ɛ̱na̱: “Ma̱ Oja̱'i̱, da̱di ja ma̱mma̱di̱'i̱ ngue nu̱gä hi̱ndí̱ øt'ä tengu̱tho ør'mi̱'da yø ja̱'i̱ ngue yø bɛ̱, yø ts'oc'ɛ̱i̱, yø 'yots'om'mäi. Ni̱ xi̱nga̱ gue'a̱ te ø'na̱ ra̱ ngʉthäi 'bäcua dí øt'ä. ");
INSERT INTO otnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nu̱gä nyondi̱ n'na semana dí ɛt'ä ma̱ mmʉi. Nu̱'a̱ te dí ta̱ha̱, dí ha̱cra̱ diezmo da̱di u̱ni̱”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pɛ nu̱'a̱ ra̱ ngʉthäi p'ʉya, yap'ʉtho bá̱ m'mäi. Ni̱ xi̱nga̱ gue'a̱ di̱ nnøsma̱ya̱, sinoque mɛ̱nte pʉnná̱ ti̱ya̱ mɛ̱nte ɛ̱na̱: “Ma̱ Oja̱'i̱, da̱mi̱ huɛ̱ga̱gui̱. Nu̱gä ja ma̱ ts'oqui”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Dí xi'a̱hʉ, ngue nu̱'a̱ ra̱ ngʉthäi bá̱ ɛ̱hrá̱ ngu̱, pɛ ya bi hojpa̱bi̱ Oja̱. A nu̱na̱ ma̱n'na p'ʉya, hi̱n'na̱ na̱. Porque nu̱'a̱ nne ngue ma̱n'na di hnu̱ ma̱nsu̱, gue'a̱ ma̱n'na ts'ʉtho hnu̱ ma̱nsu̱'a̱. Pɛ nu̱'a̱ øt'e ngue hi̱ngui̱ hnu̱ ma̱nsu̱ p'ʉ ga̱ mbɛ̱ni̱, gue'a̱ ma̱n'natho hnu̱ ma̱nsu̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bi zixyø ba̱si̱ yø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús. I̱ nnepyø ja̱'i̱ ngue da̱ dospa̱ yø ya̱ yø ba̱si̱, 'nɛ̱ da̱ xi Oja̱ ngue di ja̱pyø ba̱si̱. Pɛ nu̱'mø mi̱ nu̱ ya yø xädi ra̱ Jesús, bi hɛjpa̱ yø ja̱'i̱ bá̱ zi yø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pɛ nu̱na̱ ra̱ Jesús bi zonhyø ba̱si̱, bi 'yɛ̱mbi̱: ―Da̱mi̱ hyɛhmʉ yø ba̱si̱ da̱ thocua dí 'bʉi. Porque tengu̱tho yø ja̱'i̱ ya o rá̱ 'yɛ Oja̱, xquet'a̱ njarbʉtho ya yø ba̱si̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue n'na ra̱ ja̱'i̱ hi̱ngra̱ 'yøde tengu̱tho n'na ra̱ ba̱si̱ ngue ra̱ 'yøde, hi̱nda̱ zä da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nu̱na̱ n'na ra̱ n'yohʉ 'bɛt'o ngue yø judío bi 'yørpa̱ ra̱ nt'änni̱ ra̱ Jesús. Bi 'yɛ̱mbi̱: ―Ague grá̱ hoga̱ xännba̱te, ¿te 'bɛ'a̱ ja ngue ga̱ øt'e n'namhma̱ ngue Oja̱ di 'dacra̱ 'da'yo te para za̱ntho? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua guí pa̱di̱ te guí̱ mma̱nya, ngue guí ɛ̱ngui̱ xa̱nhogä? Porque hønsɛ Oja̱ xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ua hi̱nguí̱ pa̱di̱ hanja'ʉ yø hya̱ di̱ ma̱nda Oja̱ ngue ɛ̱na̱: “'Yo grá̱ 'yots'om'mäi. 'Yo grá̱ hyote. 'Yo grá̱ bɛ̱. 'Yo to guí sännba̱ ra̱ fɛhni̱. Da̱mi̱ su̱ ni̱ papá, da̱mi̱ su̱ ni̱ mamá” ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nu̱'a̱ ra̱ n'yohʉ p'ʉya, bi 'yɛ̱na̱: ―Nu̱ya yø hya̱ guí xicya, ya gä xtá̱ øt'e asta̱ gue'mø ma̱rá̱ ngüɛgui. ");
INSERT INTO otnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nu̱na̱ ra̱ hya̱ bi̱ ma̱mp'ʉya, mi̱ 'yøhra̱ Jesús, bi 'yɛ̱mbi̱: ―Di 'bɛhma̱n'na ra̱ hya̱ ja ngue gui 'yøt'e. Da̱mi̱ pä te gä guí pɛts'i, gui u̱nna̱ mɛ̱nyu̱ yø hyoya. Nu̱'mø gá̱ 'yøt'a̱ya, ya bí ja ni̱ mmɛti ma̱hɛ̱ts'i̱ p'ʉya. Bá̱ ɛ̱ p'ʉya, ga̱ mmɛp'ʉ nná̱ magä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nu̱na̱ ra̱ n'yohʉ, nu̱'mø mi̱ 'yøhna̱ ra̱ hya̱ sifi, ma̱mbi du̱drá̱ mmʉi, porque ma̱rá̱ ndømmɛ̱mmɛti. ");
INSERT INTO otnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mi̱ nu̱ ra̱ Jesús ngue bi du̱ rá̱ mmʉi ra̱ mmɛ̱mmɛti, bi 'yɛ̱mbyø xädi p'ʉya: ―Xa̱ndøn hɛ̱nni̱tho ha di̱ n'u̱nyø mmɛ̱mmɛti ngue da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ya fa̱di̱ ngue ra̱ cameyo, hi̱nja̱m'mø da̱ zä da̱ thop'ʉ ja rá̱ xa̱gu̱ n'na ra̱ 'yofani̱. Pɛ ma̱n'na xa̱ndøn hɛ̱nni̱tho ngue n'na ra̱ mmɛ̱mmɛti di̱ n'u̱ni̱ da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mi̱ 'yøhyø xädi na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, di̱ n'yɛ̱mbi̱: ―Rá̱ nzɛgui ya hi̱njonni̱ ja̱'i̱ da̱ zä di̱ nya̱nná̱ te ya'mø ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ra̱ Jesús bi sigue bi 'yɛ̱mbi̱: ―Nu̱'a̱ ngue yø ja̱'i̱tho, hi̱nda̱ zä te da̱ 'yøt'e. Pɛ Oja̱, hi̱nte hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nu̱na̱ ra̱ Bɛdu bi 'yɛ̱mbi̱: ―Nu̱gähe, ya xtá̱ sohme p'ʉ te gä dí pɛshe ngue dí tɛn'na̱he. ");
INSERT INTO otnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue nu̱ to gä xpá̱ nzohyø ngu̱, xpá̱ nzohrá̱ papá 'nɛ̱hrá̱ mamá, xpá̱ nzohyø n'yohʉ, xpá̱ nzohyø xisu, xpá̱ nzohyø ba̱si̱, ngue ørpa̱ rá̱ 'bɛfi Oja̱, ");
INSERT INTO otnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","pɛ mɛ̱nte 'bʉcua ja ra̱ xi̱mhäi ra̱ ja̱'i̱, nu̱'a̱ ga̱ ngu̱'a̱ te xpá̱ nzogui, ma̱n'natho xa̱ngu̱'a̱ te da̱ di̱ni̱. Ra̱ pa di 'yɛ̱p'ʉ p'ʉya, di t'u̱nna̱ te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bi zica̱ n'nanni̱'ʉ 'dɛ'ma̱ yoho yø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―A nu̱yá, ya nná̱ mähä Jerusalén. Nu̱p'ʉ, ja da̱ni̱ njap'ʉ'a̱ te gä bi 'yotyø pønga̱hya̱ Oja̱, ngue te da̱ thohra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Di̱ ndäpyø ts'oc'ɛ̱i̱, ngue da̱ n'yɛmma̱hya̱, da̱ zʉi, da̱ zots'i. ");
INSERT INTO otnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Di ʉni̱, m'mɛfa p'ʉya, da̱ hyo. Pɛ rá̱ hyu̱ pa di bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nu̱'ʉ yø xädi hi̱mbi̱ di̱ni̱ hanja na̱ ra̱ hya̱ xifi. 'Be xi̱mbi̱ n'yo yø mmʉi'a̱ te ra̱ hya̱ bi xifi, porque nu̱ya yø hya̱ ya, xa̱nhɛ̱nni̱tho ha di fa̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nu̱'mø ni̱ ma da̱ zømp'ʉ ja ra̱ hni̱ni̱ Jericó ra̱ Jesús, mi̱ hu̱p'ʉ ja ra̱ 'yu̱ n'na ra̱ xädä ngue äpra̱ mɛ̱nyu̱ yø ja̱'i̱ thop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mi̱ 'yøde ngue thogui xa̱ngu̱ yø ja̱'i̱, nu̱'a̱ ra̱ xädä p'ʉya bi 'yänni̱ hanja ngue thohyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bi si p'ʉya, ngue nu̱na̱ ja ngue da̱ thop'ʉ hu̱di̱, guehna̱ ra̱ Jesús ra̱ mmɛ̱ngu̱ Nazaret. ");
INSERT INTO otnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Bi̱ mʉhra̱ mafi p'ʉya, bi 'yɛ̱mbi̱: ―Da̱mi̱ huɛ̱ga̱gui̱ ague Jesús, rá̱ mbom'mɛto'i ra̱ David ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nu̱'ʉ yø ja̱'i̱ ni̱ 'bɛt'o p'ʉya, di hɛjpi ngue hi̱ndi̱ mmafi. Pɛ ra̱ xädä, ɛ̱na̱ ma̱n'na nts'ɛdi ga̱ mafi, bi 'yɛ̱mbi̱: ―Da̱mi̱ huɛ̱ga̱gui̱ ague rá̱ mbom'mɛto'i ra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bi̱ m'mähra̱ Jesús, bi̱ ma̱nda bá̱ ts'i ra̱ xädä. Nu̱'mø ni̱ ma da̱ zøp'ʉ 'bä p'ʉya, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Te guí̱ nne di̱ nja'i? Ra̱ xädä p'ʉya, bi 'yɛ̱na̱: ―Ague grá̱ Hmu̱, dí̱ nne ngue di̱ nzø ma̱ dä. ");
INSERT INTO otnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ra̱ Jesús bi 'yɛ̱mbra̱ xädä: ―Di̱ nzø ni̱ dä 'mø. Bi zä'i̱ ya ngue guí ɛ̱c'ɛ̱i̱gui̱ ngue jagä ra̱ ts'ɛdi ga̱ øthe'i. ");
INSERT INTO otnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, 'bexpi̱ nzø yø dä ra̱ xädä. Bi̱ mɛp'ʉ ni̱ ma ra̱ Jesús, pɛ di ja ma̱mma̱di̱ Oja̱. Nu̱ya gätho yø ja̱'i̱ bi̱ nu̱ te bi̱ nja, gä ɛ̱spa̱bi̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mi̱ yʉrbʉ ja ra̱ hni̱ni̱ Jericó ra̱ Jesús, ya ni̱ 'yop'ʉ ja ra̱ hni̱ni̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nu̱'a̱ ra̱ hni̱ni̱'a̱, mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱mmɛti ni̱ hu̱ ngue ra̱ Zaqueo, rá̱ hmu̱'ʉ to jʉhra̱ mɛ̱nyu̱ njʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nu̱na̱ ra̱ Zaqueo p'ʉya, i̱ nne da̱ nu̱ ra̱ Jesús ngue da̱ ba̱di̱ te'o. Pɛ hi̱ngui̱ sä da̱ hyannbʉya, porque xa̱ngu̱ yø ja̱'i̱ n'youi ra̱ Jesús, 'nɛ̱ hi̱ngui̱ hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","I̱ nne ngue da̱ nu̱ xa̱nho. Bi̱ nti p'ʉya, ni̱ 'bɛt'o. Bi̱ nexa̱ n'na ra̱ za ngue ra̱ sicómoro 'bäp'ʉ ja ngue da̱ni̱ nthohra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mi̱ thop'ʉ ja ra̱ za tøhra̱ Zaqueo na̱ ra̱ Jesús, bi̱ nøs'ma̱ya̱, bi 'yɛ̱mbi̱: ―Ague Zaqueo, bá̱ ca̱i̱ n'na zihma̱ntho, porque nu̱ya ja ngue ga̱ nsäyagä p'ʉ ja ni̱ ngu̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nu̱na̱ ra̱ Zaqueo, n'nahma̱ntho bá̱ ca̱i̱. Nu̱p'ʉ ja rá̱ ngu̱, ja bi säyabi̱ p'ʉ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yø ja̱'i̱ p'ʉya, hi̱mbi̱ nu̱ ma̱nho te øtra̱ Jesús, ɛ̱mbi̱ ngue guep'ʉ ja rá̱ ngu̱ ra̱ ja̱'i̱ ja rá̱ ts'oqui ja säya p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ra̱ Zaqueo p'ʉya, bi̱ m'mäi, bi 'yɛ̱mbra̱ Jesús: ―Nu̱ya grá̱ Hmu̱, nu̱'a̱ te dí pɛts'i, ga̱ u̱nnä ma̱de yø hyoya. Nu̱'mø 'bʉi te'o ma̱n'na xa̱ngu̱ xtá̱ ha̱nnbi̱ ngue'a̱ hi̱nni̱ 'yu̱p'ʉ ga̱ ha̱nnbi̱, pɛ ga̱ cospa̱bi̱ ngoho parte'a̱ te xtá̱ ha̱nnbi̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mi̱ nya ra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱ ra̱ ora ja p'ʉya, ya di̱ nya̱nna̱ to 'bʉhra̱ ngu̱ jaua ya. Porque xquet'a̱ 'nɛ̱hna̱ rá̱ mbom'mɛto ra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Porque ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, bi 'yɛ̱hɛ̱ da̱ hyonyø ja̱'i̱ xa̱ m'mɛdi, ngue da̱ ya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mɛ̱nte øxyø ja̱'i̱ ra̱ hya̱ mma̱nna̱ Jesús, bi hyɛcra̱ hya̱ bi xi p'ʉya. Porque ya xma̱nguerpʉ da̱ zøn'a̱ Jerusalén. Nu̱p'ʉ ga̱ mbɛ̱nyø ja̱'i̱ p'ʉya, ɛ̱mbi̱ ngue 'bexti̱ nɛ̱qui̱'a̱ ra̱ ora'a̱ ngue di̱ ma̱nda ua Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bi 'yɛ̱mbyø ja̱'i̱ p'ʉya: ―Mi̱ 'bʉ'a̱ n'na ra̱ n'yohʉ ngue mi̱ nnu̱ ma̱nsu̱ yø ja̱'i̱. Ya ja ngue da̱ ma n'na ra̱ häi yap'ʉtho, ja di t'u̱nnbʉ rá̱ cargo ngue di̱ nda̱st'abi p'ʉ ja rá̱ häi 'bʉi, da̱ ɛ̱hrá̱ ngu̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pɛ hante ngue da̱ ma ra̱ n'yohʉ, bi zonhni̱ 'dɛt'a yø hmi̱qui̱. N'na ngu̱ n'na yø hmi̱qui̱, bi däpa̱ n'na ra̱ mɛ̱nyu̱ xa̱ndøngu̱ rá̱ mu̱ui. Bi 'yɛ̱mbʉya: “Nu̱na̱ ra̱ mɛ̱nyu̱ dá̱ 'da'a̱hʉ ya, da̱mi̱ 'yørpa̱hʉ rá̱ 'bɛfi asta̱ gue'mø dá̱ pengä”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pɛ nu̱ya yø mmɛ̱ngu̱hʉ ra̱ n'yohʉ, mi̱ nnu̱ ma̱n'ʉ p'ʉya. Bi̱ mɛnhyø m'mɛnhni̱ ngue da̱ ma̱mp'ʉ ha bi zønna̱ n'yohʉ, bi 'yɛ̱na̱: “Hi̱ndí̱ nnegähe na̱ ra̱ n'yohʉ ngue di̱ nda̱st'abi di̱ ma̱ndaga̱he”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pɛ siempre bá̱ t'ɛ̱ts'i̱ ngue bi̱ nda̱st'abi na̱ ra̱ n'yohʉ. Mi̱ zøp'ʉ ja rá̱ häi p'ʉya, bi̱ ma̱nda bá̱ ts'i'ʉ yø hmi̱qui̱ xi u̱nná̱ mɛ̱nyu̱. I̱ nne da̱ ba̱di̱ hangu̱ xa̱ nda̱ha̱ n'na ngu̱ n'na. ");
INSERT INTO otnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nu̱'a̱ rá̱ mʉdi bi zøp'ʉya, bi 'yɛ̱na̱: “Nu̱ ni̱ mɛ̱nyu̱ gá̱ däqui, ya jap'ʉ 'dɛt'a yø mɛ̱nyu̱ xa̱ nda̱ha̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ra̱ da̱st'abi p'ʉya, bi 'yɛ̱na̱: “Ya xa̱nho 'mø, grá̱ hoga̱ mɛfi. Ma̱da̱gue'a̱ zits'ʉtho bi̱ ma ma̱fäti'i, pɛ gá̱ pøngma̱nho. A nu̱yá, dí ɛ̱xa̱'i̱ ya ngue gui̱ ma̱nda 'dɛt'a yø da̱ni̱hni̱ ya”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bi zøhma̱n'na p'ʉya, bi 'yɛ̱na̱: “Ague grá̱ hmu̱, nu̱'a̱ ni̱ mɛ̱nyu̱ gá̱ däqui, ya jap'ʉ cʉt'a yø mɛ̱nyu̱ xa̱ nda̱ha̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bi t'ɛ̱mbʉya: “Nu̱'i̱ ya, dí ɛ̱xa̱'i̱ ngue gui̱ ma̱nda cʉt'a yø hni̱ni̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mi̱ zøhma̱n'na p'ʉya, bi 'yɛ̱na̱: “Ague grá̱ hmu̱, ja ua ni̱ mɛ̱nyu̱ gá̱ däqui. Nu̱gä dá̱ 'uɛ ra̱ bayu dá̱ pɛts'i. ");
INSERT INTO otnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Porque dí su̱'i̱ ngue guí ya̱ ma̱nzaqui, guí ä'a̱ te hi̱nxcá̱ ta̱ha̱. Guí xoc'a̱ te hi̱nxcá̱ pɛfi”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bi 'yɛ̱nna̱ da̱st'abi p'ʉya: “Hi̱ngrá̱ hoga̱ mɛfi n'yø. Nu̱'a̱ ra̱ hya̱ guí̱ mma̱nya, gue'a̱ gdá̱ ha̱ts'a̱'i̱ ra̱ güɛnda'a̱ ya. Porque guí ɛ̱ngui̱ ngue dí ya̱ ma̱nzaquigä. Guí ɛ̱ngui̱ ngue dí ha̱ngä'a̱ te hi̱nxtá̱ n'ʉni̱, ogue dí äcä'a̱ te hi̱nxtá̱ pɛfi. ");
INSERT INTO otnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Hanja ngue hi̱ngá̱ dä ma̱ mɛ̱nyu̱gä p'ʉ ja ra̱ banco, n'namhma̱ ngue nu̱'mø dá̱ søcua ja ma̱ ngu̱, xti̱ ndäcä'a̱ te rá̱ nzäbi ma̱ mɛ̱nyu̱?” ");
INSERT INTO otnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bi t'ɛ̱mp'ʉ 'bäp'ʉ p'ʉya: “Hya̱nnba̱ui ra̱ mɛ̱nyu̱ na̱, n'yø. Da̱mi̱ u̱nui'a̱ ha̱ 'dɛt'a yø mɛ̱nyu̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nu̱'ʉ ts'o p'ʉya, bi 'yɛ̱na̱: “Ague grá̱ hmu̱, pɛ ya ha̱ 'dɛt'a yø mɛ̱nyu̱ na̱”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bi 'yɛ̱nna̱ da̱st'abi p'ʉya: “Nu̱gä dí xi'a̱hʉ ngue nu̱'a̱ ya ha̱ xa̱ngu̱, gue'a̱ ma̱n'na di t'u̱n'na̱. Pɛ nu̱'a̱ zits'ʉtho ha̱, da̱ tha̱nnba̱bi̱'a̱ zits'ʉ ha̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A nu̱yá, nu̱'ʉ ma̱ nsʉigä'be hi̱ngui̱ nneque xca̱ nda̱st'abigä, bá̱ siui ua ya. Ga̱ nnu̱gä ha gdi hyohʉ”. ");
INSERT INTO otnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱, ra̱ Jesús bi thogui, i̱ ma Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mi̱ zømp'ʉ ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos, ja jarbʉtho ra̱ hni̱ni̱ Betfagé 'nɛ̱hra̱ hni̱ni̱ Betania. Bi 'yɛt'i yoho yø xädi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Bi 'yɛ̱mbi̱: ―Ni̱ mɛ nʉ ja ra̱ hni̱ni̱ bí janʉ ya. Nu̱'mø gá̱ cʉt'ui ra̱ hni̱ni̱, gui ti̱mmi̱ p'ʉ da̱ ntha̱t'i̱ n'na ra̱ burru ma̱'da'yotho, hi̱njongui̱ sä. Bá̱ xoqui guá̱ siui ua. ");
INSERT INTO otnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nu̱'mø to da̱ 'yɛ̱n'a̱ui, hanja ngue guí xocui ra̱ burru, guí xihmi̱ p'ʉya ngue honna̱ Hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nu̱'ʉ yø xädi p'ʉya, bi̱ ma. Nu̱p'ʉ bi zømp'ʉya, bi di̱mp'ʉ ntha̱t'i̱ ra̱ burru, tengu̱tho xi̱ ma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mi̱ xojpʉya, nu̱'ʉ yø mmɛ̱mburru bi 'yɛ̱mbi̱: ―¿Hanja ngue guí xocui ra̱ burru? ");
INSERT INTO otnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bi 'yɛ̱mbʉya: ―Porque honna̱ Hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bi ts'ispa̱bi̱ ra̱ burru ra̱ Jesús. Nu̱'ʉ yø xädi p'ʉya, bi ga̱spa̱ ra̱ burru yø tu̱hu̱ yø ja̱'i̱ ngue bi̱ nøpa̱ nts'ʉt'i. Bi hyu̱xra̱ burru ra̱ Jesús, bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Xa̱ngu̱ yø ja̱'i̱ di tʉnsyø tu̱hu̱ ngue pøp'ʉ ja ra̱ 'yu̱ ja ngue da̱ thohra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nu̱'mø ya xma̱nguerpʉ da̱ zøn'a̱ Jerusalén, ya 'yop'ʉ ja ra̱ nga̱i̱ ja ra̱ mbonza ja yø olivos. Bi̱ mʉhra̱ hmafi gätho yø xädi p'ʉya ngue di johya. I ɛ̱spa̱bi̱ Oja̱ ngue yø milagro xi̱ nu̱rpi̱ øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Di̱ n'yɛ̱mbi̱: ―Oja̱ di ja̱pra̱ da̱st'abi bá̱ 'bɛnhni̱ ngue bi zøcua. Ya bi̱ nhojpa̱ui yø ja̱'i̱ na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱. Nu̱ya ma̱guesɛ na̱ Oja̱ bí 'bʉ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bi 'yɛ̱n'i'da yø fariseo n'youi yø ja̱'i̱ p'ʉya: ―Ague grá̱ xännba̱te, da̱mi̱ hɛjpa̱ ni̱ xädi. 'Yo di̱ mma̱nna̱ ra̱ hya̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Dí xi'a̱hʉ ngue nu̱'mø da̱ ma ma̱hɛjpi ya yø ja̱'i̱ ɛ̱sca̱gui̱ ya, di̱ nya̱ yø do ja ua ngue da̱ 'yɛ̱sca̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mi̱ zøn'a̱ neni̱hni̱ ra̱ Jesús, bi hyandra̱ hni̱ni̱ Jerusalén. Bi̱ nzomp'ʉya, ngue pa̱di̱ te da̱ tho'a̱ m'mɛfa yø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Bi 'yɛ̱mbra̱ mɛ̱hni̱ni̱ p'ʉya: ―Nu̱ ra̱ pa ja p'ʉya, dí̱ nnehma̱gä ngue gui pa̱hmʉ hanja na̱ ra̱ hya̱ da̱ 'yøt'a̱hʉ ra̱ nho. Pɛ njot'i ni̱ n'yomfɛ̱ni̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Da̱ 'yɛ̱hra̱ pa ngue gui̱ m'mʉ mma̱n'ʉhʉ, di̱ mäts'a̱ ni̱ nsʉihʉ, ma̱thɛ̱t'i̱ ra̱ hni̱ni̱ da̱ 'yøtyø nju̱di̱. Di̱ nexpʉ di̱ nexyø soldado da̱ 'yøt'a̱hʉ ra̱ tu̱nhni̱, da̱ 'yɛ̱'a̱hʉ ma̱de. ");
INSERT INTO otnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Da̱ t'ɛn'a̱hʉ häi p'ʉya, ngue da̱ tho yø ja̱'i̱ 'bʉcua ja ra̱ hni̱ni̱. Da̱ ma nsʉdi yø ngu̱. Ngu̱na̱ di̱ nja, porque hi̱mbi̱ n'yo ni̱ mmʉihʉ'a̱ ra̱ pa bi zøcua rá̱ m'mɛnhni̱ Oja̱ ngue xi'i ha gdi̱ nya̱mhmʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bi̱ map'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús. Gä bi 'yɛtyø ja̱'i̱ mi̱ mpäp'ʉ thi̱nni̱ja̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱p'ʉ ja ra̱ Ma̱ca̱ Libro, nt'ot'i p'ʉ ra̱ hya̱ ngue Oja̱ i ɛ̱na̱: “Nu̱na̱ ma̱ ngu̱ngä, ni̱ hu̱ ngue ra̱ ngu̱nga̱ mhmat'Oja̱ na̱”. Pɛ nu̱'a̱hʉ, guí øthʉ ngue ja di̱ mpɛti ua yø bɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","N'na pa ngu̱ n'na pa bi xännba̱te p'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús. Pɛ nu̱'ʉ yø hmu̱ yø mmäcja̱ p'ʉya, 'nɛ̱'ʉ yø xännba̱te ngue ra̱ ley, 'nɛ̱'ʉ yø n'yohʉ di̱ ma̱nda p'ʉ ja ra̱ hni̱ni̱, gä honna̱ forma ha di hyo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pɛ hi̱ngui̱ ti̱ni̱ ha di japi ngue di̱ nja'a̱ te mbɛ̱ni̱, porque gä 'bʉtyø ja̱'i̱ ngue øxra̱ hya̱ mma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","N'na ra̱ pa ya, nu̱na̱ ra̱ Jesús bi xännba̱ ra̱ hya̱ yø ja̱'i̱ p'ʉ ja ra̱ ni̱ja̱, xihyø ja̱'i̱ ra̱ hoga̱ 'da'yo hya̱. Bi zøhyø hmu̱ yø mmäcja̱ p'ʉya, 'nɛ̱hyø xännba̱te ngue ra̱ ley, bá̱ 'yohʉ'ʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bi 'yɛ̱mbra̱ Jesús: ―Ague n'yø, ¿hanja'a̱ te guí øt'e? To bi 'da'i ra̱ nt'ɛ̱di̱'a̱ te guí øt'e? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱gä xquet'a̱ ga̱ øt'a̱hʉ n'na ra̱ nt'änni̱ ya. Pɛ da̱mi̱ xicjʉ hanja'a̱ ra̱ hya̱ ga̱ än'na̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Te'o bi u̱nna̱ nt'ɛ̱di̱ ra̱ Xuua bi xixya̱bi̱ yø ja̱'i̱? ¿Ua Oja̱ bi u̱nna̱ nt'ɛ̱di̱, uague yø ja̱'i̱tho rá̱ nt'ɛ̱di̱'a̱ te bi 'yøt'e? ");
INSERT INTO otnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yø ja̱'i̱ p'ʉya, di̱ n'yänni̱ te di da̱di̱. Di̱ n'yɛ̱mbi̱: ―¿Teni̱ 'bɛ'a̱ ga̱ xihmʉ ya 'mø? Nu̱'mø ga̱ xihmʉ ngue Oja̱ bi u̱nna̱ nt'ɛ̱di̱ te bi 'yøtra̱ Xuua, da̱ 'yɛ̱njʉ p'ʉya: “Xina̱ ra̱ hya̱ bi̱ ma̱nna̱ Xuua conná̱ ngueque, ¿hanja ngue hi̱ngá̱ 'yɛ̱c'ɛ̱i̱hʉ 'mø?”, da̱ 'yɛ̱njʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A nu̱'mø ga̱ xihmʉ ngue yø ja̱'i̱tho bi u̱nna̱ nt'ɛ̱di̱ te bi 'yøtra̱ Xuua, di hyojthoga̱hʉ yø ja̱'i̱ ngue da̱ mʉndoga̱hʉ. Porque gä ɛ̱c'ɛ̱i̱ yø ja̱'i̱ ngue rá̱ pønga̱hya̱ Oja̱ na̱ ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mi̱ da̱hyø ja̱'i̱ p'ʉya, bi 'yɛ̱mbra̱ Jesús: ―Hi̱ndí̱ pa̱cähe to bi u̱nna̱ nt'ɛ̱di̱'a̱ te bi 'yøtra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Ya hi̱ngá̱ xicjʉ na̱ ra̱ hya̱ dí än'na̱hʉ, ni̱ xi̱nga̱ guecä ga̱ xi'a̱hʉ to di 'dacra̱ nt'ɛ̱di̱ te dí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nu̱na̱ ra̱ Jesús, bi hyoni̱ te gui hyɛjpa̱ yø hya̱ bi̱ xihyø ja̱'i̱. Bi 'yɛ̱mbi̱: ―Mi̱ 'bʉ'a̱ n'na ra̱ n'yohʉ ngue bi 'yøt'a̱ n'na rá̱ nua̱'uva. M'mɛfa p'ʉya, bi hyoni̱ to da̱ gonhui rá̱ hua̱hi̱, n'namhma̱ ngue nu̱'mø bi̱ nja yø uva, di̱ t'u̱nna̱ mmɛ̱hui̱'a̱ te di tocabi. Bi̱ ma p'ʉya, ya'atho yø pa i̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mi̱ zønna̱ pa da̱ thu̱cyø uva p'ʉya, nu̱na̱ ra̱ mmɛ̱hui̱ bi̱ mɛnhna̱ n'na rá̱ hmi̱qui̱ ngue da̱ tu̱ yø uva di tocabi. Pɛ nu̱'ʉ yø mɛfi ma̱mbi̱ 'bʉp'ʉ ja rá̱ hua̱hi̱, bi ʉnna̱ hmi̱qui̱, bá̱ ɛrbʉya. Pɛ hi̱nte bi u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ra̱ mmɛ̱hui̱ p'ʉya, ma̱hømbi̱ mɛnhma̱n'na rá̱ hmi̱qui̱ p'ʉ bí ja rá̱ hua̱hi̱. Pɛ xquet'a̱ ngu̱t'a̱tho bá̱ ts'ʉi. Bi̱ ma ma̱'ʉni̱, hi̱nte bi t'u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ra̱ mmɛ̱hui̱ p'ʉya, ma̱hømbi̱ mɛnhma̱n'na rá̱ hmi̱qui̱. Yø mɛfi p'ʉya, ma̱hømbi̱ ʉntho, bá̱ ɛt'i. ");
INSERT INTO otnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","M'mɛfa p'ʉya, ɛ̱nna̱ mmɛ̱hui̱: “¿Teni̱ 'bɛ'a̱ ga̱ øt'ä 'mø? Nu̱na̱ ma̱ ts'ʉnt'ʉ da̱di̱ ma̱di̱, ma ga̱ pɛnnbi̱. Xa̱mhma̱tho da̱ nu̱ ma̱nsu̱ 'mø bi̱ nu̱na̱”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pɛ nu̱'mø mi̱ zømp'ʉ 'bʉhyø mɛfi na̱ rá̱ ts'ʉnt'ʉ ra̱ mmɛ̱hui̱, di̱ n'yɛ̱mbyø mɛfi: “Nu̱na̱ ya, guehna̱ ra̱ ts'ʉnt'ʉ ja ngue da̱ gohmi̱ ra̱ hua̱hi̱ na̱ya. Ma ga̱ hohʉ ya, n'namhma̱ ngue ya ma̱ mmɛtihʉ ra̱ hua̱hi̱”, di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bi bɛnnba̱bi̱ rá̱ ts'ʉnt'ʉ ra̱ mmɛ̱hui̱ p'ʉya, bi gʉjma̱xøts'e ra̱ hua̱hi̱, ja bá̱ hop'ʉ. Ra̱ Jesús bi 'yänyø ja̱'i̱ p'ʉya, bi 'yɛ̱mbi̱: ―Xi'mø ya gä bi̱ nja ya yø hya̱ dí xi'a̱hʉ ya, ¿teni̱ 'bɛ'a̱ da̱ 'yøtra̱ mmɛ̱hui̱? ");
INSERT INTO otnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Siempre da̱ ma ra̱ mmɛ̱hui̱, da̱ ho yø mɛfi conhui rá̱ hua̱hi̱. N'nan'yo mi̱'da yø ja̱'i̱ di fätrá̱ hua̱hi̱ p'ʉya. Nu̱'mø mi̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ na̱ p'ʉya, di̱ n'yɛ̱mbi̱: ―'Yo da̱ ne Oja̱ ngue da̱ ngu̱'a̱ di̱ nja ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pɛ ra̱ Jesús bi hyɛ̱tyø ja̱'i̱, bi 'yɛ̱mbi̱: ―Te 'bɛ'a̱ ga̱ mbøn'a̱ ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Nu̱na̱ ra̱ do hi̱mbi̱ nu̱ ma̱nho yø hyønni̱gu̱, guehna̱ ra̱ do brá̱ 'bɛbo p'ʉ brá̱ fʉhra̱ ja̱do na̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nu̱'mø da̱ zoxra̱ ja̱'i̱ ma̱xøts'e ra̱ do, da̱ føhra̱ ja̱'i̱. A nu̱'mø da̱ dähra̱ do ngue da̱ zoxra̱ ja̱'i̱, da̱ xɛni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nu̱'ʉ yø hmu̱ yø mmäcja̱ 'nɛ̱'ʉ yø xännba̱te ngue ra̱ ley, bi̱ ne xti bɛntra̱ Jesús ngue xta̱ ngot'i. Porque pa̱hyø ja̱'i̱ ngue go xihya yø hya̱ bi hyɛcra̱ Jesús. Pɛ hi̱mbi̱ zä xti bɛnt'i̱, porque su̱pi̱ di̱ mbøcuɛ mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yø fariseo p'ʉya, bi̱ mɛ̱nhni̱ to da̱ jʉjpa̱tho häi te ga̱ ya̱ ra̱ Jesús. Nu̱ya bi 'bɛnhni̱ xøgue ya̱ ma̱nhotho, tengu̱tho 'mø ngue nma̱jua̱ni̱ yø hoja̱'i̱. I̱ nnepe ngue di̱ nja tema̱ hya̱ da̱ di̱nnba̱ ra̱ Jesús ngue hi̱nda̱ gue'a̱ da̱ ma̱, para ngue da̱ zäp'ʉ di ya̱pa̱ m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja̱na̱ngue bi t'ørpa̱ ra̱ nt'änni̱ na̱ ra̱ hya̱ ja ua, bi t'ɛ̱mbi̱: ―Ague grá̱ xännba̱te, dí pa̱cähe ngue gä xa̱nho te guí̱ mma̱, 'nɛ̱ gä gue'a̱ ra̱ hya̱ njua̱ntho guí xännba̱te. 'Nɛ̱ hi̱ngui̱ su̱'a̱ te mbɛ̱n'na̱'i̱ yø ja̱'i̱. Sinoque ma̱jua̱ni̱ guí xännba̱te'a̱ ra̱ hya̱ nne Oja̱ ngue gdá̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Da̱mi̱ xicje ya, ¿ua xa̱nho ngue di̱ nju̱tra̱ mɛ̱nyu̱ ähra̱ da̱st'abi, uague hi̱n'na̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pɛ ra̱ Jesús, ya pa̱di̱ te mbɛ̱nnba̱bi̱ yø ja̱'i̱ ngue'a̱ ra̱ nt'änni̱ ørpe, bi 'yɛ̱mbʉya: ―¿Hanja ngue guí sämhya̱ga̱hʉ? ");
INSERT INTO otnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Da̱mi̱ 'yu̱rca̱hʉ ra̱ mɛ̱nyu̱ ―bi 'yɛ̱mbi̱―. ¿To rá̱ hmi̱ na̱ n'youi ra̱ mɛ̱nyu̱ ja ua ya? ¿To rá̱ thu̱hu̱ na̱ ra̱ thu̱hu̱ n'youi na̱ ra̱ mɛ̱nyu̱? ―bi 'yɛ̱mbi̱. Mi̱ da̱hya ya̱ui ra̱ Jesús, bi 'yɛ̱mbi̱: ―Guehna̱ ra̱ da̱st'abi na̱ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱ ya̱ui: ―Nu̱'a̱ ja ngue gui 'yøthʉ ya, da̱mi̱ u̱nhnʉ ra̱ mɛ̱nyu̱ di tocabi ra̱ da̱st'abi. Da̱ gue Oja̱ p'ʉya, da̱mi̱ u̱nhnʉ'a̱ te di tocabi ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ya hi̱mbi̱ zä xta̱ ndi̱ni̱ ha xti gʉjpa̱ häi'a̱ ra̱ hya̱ ännbʉya. Hante gue di 'yøtho'a̱ ra̱ hya̱ i da̱hra̱ Jesús. Ya hi̱nte ma̱mbi̱ ma̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","M'mɛfa p'ʉya, bi̱ ma 'da yø saduceo, nu̱ya ɛ̱mbi̱ ngue hi̱ndi̱ bɛ̱nna̱te yø ánima. Bi 'yɛ̱mbra̱ Jesús: ");
INSERT INTO otnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Ague grá̱ xännba̱te, nu̱p'ʉ ja ra̱ ley bi 'yotra̱ Moisés, nt'ot'i p'ʉ ra̱ hya̱ ngue ɛ̱na̱: nu̱'mø bi du̱ n'na ra̱ n'yohʉ, 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱, nu̱ rá̱ xisu ra̱ ánima da̱ zogui, nu̱'a̱ rá̱ n'yohʉ ra̱ ánima gue'a̱ di̱ ntha̱tui ra̱ 'danxu̱'a̱, n'namhma̱ ngue di̱ m'mʉhyø ba̱si̱ tengu̱tho 'mø xti̱ m'mʉhyø ba̱si̱ ra̱ ánima. ");
INSERT INTO otnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A nu̱yá, xi'mø di 'bʉ'i yoto ma̱'yohʉ ngue ɛda̱di̱ ncu̱ ya. Nu̱'a̱ ra̱ n'yohʉ ma̱ da̱, di̱ ntha̱ti̱. Pɛ da̱ 'yɛ̱hra̱ pa da̱ du̱, 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ja̱na̱ngue nu̱'a̱ rá̱ n'yohʉ ra̱ ánima m'mɛfa bi̱ m'mʉi, go di̱ ntha̱tui ra̱ 'danxu̱'a̱. Pɛ xquet'a̱ da̱ du̱ ra̱ n'yohʉ, 'nɛ̱ hi̱ndi̱ m'mʉhyø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nu̱'a̱ rá̱ hyu̱ rá̱ n'yohʉ p'ʉya, høndi̱ ntha̱tui ra̱ 'danxu̱ 'mø bi du̱ rá̱ n'yohʉ. Di siguetho di̱ ntha̱tra̱ xisu 'mø bi du̱ rá̱ ndø, asta̱ gue'mø bi du̱ gä yoto ma̱'yohʉ. Gä di̱ ntha̱tui ra̱ xisu, 'nɛ̱ gä bi du̱ yø n'yohʉ. Pɛ hi̱mbi̱ m'mʉhyø ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Rá̱ nzɛgui p'ʉya, bi du̱ ra̱ xisu. ");
INSERT INTO otnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A nu̱yá, xi'mø ra̱ pa da̱ni̱ bɛ̱nna̱te yø ánima ya, ¿ndana̱ gue'a̱ ya yoto ma̱'yohʉ rá̱ mmɛti ra̱ xisu? Porque gä bi̱ m'mʉhmi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ua ja ra̱ xi̱mhäi, di̱ ntha̱tui yø xisu yø n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pɛ nu̱ to di tocabi ra̱ mmɛ̱nthi̱ ngue di̱ ma ma̱hɛ̱ts'i̱ 'mø bi bɛ̱nna̱te yø ánima, ya hi̱n da̱ni̱ ntha̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Porque ya hi̱njonda̱ du̱, da̱ gohi tengu̱tho yø anxɛ. Ya yø ba̱si̱ Oja̱, porque da̱ 'yøt'Oja̱ ngue ma̱'da'yo høndi̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nu̱p'ʉ ja ra̱ hya̱ bi 'yotra̱ Moisés, ja di̱ nɛ̱qui̱ p'ʉ ngue di bɛ̱nna̱te yø ánima. Porque nt'ot'i p'ʉ ra̱ hya̱ bi̱ ma̱n'Oja̱ 'mø mi̱ nya̱ p'ʉ bi̱ nzø ra̱ ndʉt'o, ngue bi 'yɛ̱na̱: “Guecä drá̱ Oja̱gä ngue ra̱ Abraham. Drá̱ Oja̱gä ngue ra̱ Isaac. Drá̱ Oja̱gä ngue ra̱ Jacob”, bi 'yɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ja di̱ nɛ̱qui̱ p'ʉya ngue nu̱p'ʉ 'bʉ Oja̱, hi̱ngui̱ tu̱ yø te yø ánima. Nu̱p'ʉ 'bʉ Oja̱, hi̱njongui̱ tu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bi 'yɛ̱n'i'da yø xännba̱te ngue ra̱ ley p'ʉya: ―Ma̱jua̱ni̱'a̱ guí̱ mma̱, grá̱ xännba̱te ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pɛ ya bi zu̱ xti sigue xta̱ 'yørpa̱ mi̱'da yø nt'änni̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱'a̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi, i̱ mma̱nyø ja̱'i̱ ngue da̱ gue'a̱ n'na'ʉ yø mbom'mɛto ra̱ David. Nu̱gä ga̱ xi'a̱hʉ hanja ya, ma̱da̱gue'a̱ ngue rá̱ mbom'mɛto ra̱ David, pɛ nu̱na̱ ra̱ Cristo hi̱ngra̱ ja̱'i̱tho na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porque ra̱ David, ɛ̱nna̱ hya̱ bi 'yorpʉ ja ra̱ Salmo: “Nu̱na̱ Oja̱, nu̱'mø mi̱ zojba̱gui̱ ma̱ Hmu̱, ngu̱na̱ ra̱ hya̱ bi xifi, bi 'yɛ̱mbi̱: Da̱mi̱ mi̱cua ja ma̱ n'yɛigä ya, ");
INSERT INTO otnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta̱ gue'mø ga̱ øt'e ngue guí̱ ma̱nda gätho'ʉ ni̱ nsʉiui”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ja di̱ nɛ̱qui̱ p'ʉya, ngue ra̱ David, nu̱'mø nnønna̱ Cristo, ni̱ hu̱ti̱ ngue rá̱ Hmu̱. Ja̱na̱ngue ra̱ Cristo di̱ nɛ̱qui̱ ngue hi̱ngra̱ ja̱'i̱tho, ma̱da̱gue'a̱ ngue rá̱ mbom'mɛto ra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Gä bi 'yøhyø ja̱'i̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús ngue ɛ̱mbyø xädi: ");
INSERT INTO otnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Da̱mi̱ mfähmʉ xa̱nho ya, 'yo di hä'a̱hʉ yø xännba̱te ngue ra̱ ley. 'Yo guí øthʉ tengu̱tho ga̱ 'yo'ʉ. Nu̱ya yø n'yohʉ ya, di ho ngue søt'a̱ häi yø he. Di ho ngue di respeta yø ja̱'i̱ ha gui zɛngua p'ʉ ja ra̱ täi. Nu̱p'ʉ ja yø ni̱ja̱ p'ʉya, huantho yø nthu̱ts'i̱ ta̱te xa̱nho ngue ja hu̱p'ʉ. Nu̱p'ʉ øt'a̱ ngo yø ja̱'i̱ p'ʉya, xquet'a̱ nne ngue ta̱te xta̱nho p'ʉ da̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","'Nɛ̱ tu̱nnba̱ yø ngu̱ yø 'danxu̱, i häti, ɛ̱mbi̱ ngue di xa̱nnbi̱ te pɛts'i. Nu̱na̱ ra̱ hya̱ ga̱ ngorpa̱ yø dä yø ja̱'i̱ p'ʉya, nu̱'mø mmat'Oja̱, ndø ya'atho mmat'Oja̱. I̱ nne da̱ 'yɛ̱mbyø ja̱'i̱ ngue yø ndøhoga̱ n'yohʉ. Pɛ nu̱yá, guehya ma̱thoguitho ra̱ castigo da̱ thohya ngue gätho mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nu̱p'ʉ ja ra̱ ni̱ja̱, hɛ̱tho ra̱ Jesús ha ga̱ yʉtyø mɛ̱nyu̱ yø mmɛ̱mmɛti p'ʉ ja ra̱ huada cʉ ra̱ mɛ̱nyu̱ ngue ra̱ ofrenda. ");
INSERT INTO otnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bi̱ nu̱ n'na ra̱ 'danxu̱ ngue ra̱ zibøhyoya, xquet'a̱ bi gät'i yoho yø zi xani̱ p'ʉ ja ra̱ njʉmɛ̱nyu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bi 'yɛ̱nna̱ Jesús: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue ra̱ zibøhyoya na̱ ra̱ 'danxu̱ bi u̱nná̱ mɛ̱nyu̱ ya, pɛ ma̱n'natho nnu̱ ma̱nho Oja̱'a̱ rá̱ mɛ̱nyu̱ bi u̱nna̱, hi̱nda̱ gue'ʉ yø mɛ̱nyu̱ mi̱'da yø ja̱'i̱ di u̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porque nu̱ya mi̱'da yø ja̱'i̱, yø mmɛ̱mmɛti ya, pɛ gue'a̱ rá̱ mɛ̱nyu̱ xa̱ pongui̱ di u̱ni̱. A nu̱na̱ ra̱ 'danxu̱, zits'ʉ drá̱ mɛ̱nyu̱ mi̱ ha̱. Mi̱ ja ngue xta̱ nzi rá̱ mɛ̱nyu̱ bi u̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Di c'a̱ 'da yø ja̱'i̱ te ja ra̱ ni̱ja̱. I̱ mma̱nyø ja̱'i̱ ngue ma̱zihotho gui̱ nɛ̱qui̱ ra̱ ni̱ja̱. Ma̱zihotho gui̱ nɛ̱qui̱ yø hmi̱ yø do n'youi. Gui̱ nhohra̱ ni̱ja̱'a̱ tema̱ cosa di u̱nyø ja̱'i̱ ngue nnøpa̱ ofrenda. Ra̱ Jesús bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ya guí̱ nnu̱hʉ te ja ra̱ ni̱ja̱ ya. Pɛ nu̱na̱ ra̱ ni̱ja̱ na̱ya, bá̱ ɛ̱p'ʉ ra̱ pa da̱ xotyø ja̱'i̱ na̱. Xøgue di̱ nxʉdi, hi̱n hapʉ nmi̱ nɛ̱qui̱ ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bi t'ännbʉya, bi t'ɛ̱mbi̱: ―Ague grá̱ xännba̱te, ¿nja̱m'mø di̱ nja ya yø hya̱ guí̱ mma̱nya, ngue da̱ xotra̱ ni̱ja̱ yø ja̱'i̱? ¿Tema̱ hmɛ̱ya di̱ nja'mø ya ni̱ ma da̱ zønna̱ pa di̱ nja'a̱ te guí̱ mma̱nya? ");
INSERT INTO otnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø xädi: ―Da̱mi̱ mfähmʉ xa̱ndønho, 'yo guí̱ nne ngue to da̱ hyä'a̱hʉ. Porque xa̱ngu̱ yø ja̱'i̱ di̱ n'yo ngue da̱ 'yɛ̱mbyø ja̱'i̱: “Go guecä drá̱ Cristogä ya”, da̱ 'yɛ̱mbi̱. Xquet'a̱ da̱ 'yɛ̱na̱: “Nu̱ya, ya da̱ guehra̱ ora jap'ʉ da̱ gua'a̱ nxi̱mhäi ya”, da̱ 'yɛ̱na̱. Pɛ 'yo sä guí ɛ̱c'ɛ̱i̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nu̱'mø gá̱ 'yøhmʉ ngue ya ja yø da̱tu̱nhni̱, ya di̱ ndu̱nhyø ja̱'i̱, 'yo sä guí su̱hʉ. Porque jatho ngue ya ngu̱'a̱ ja ngue di̱ nja. Pɛ hi̱nga̱ gue'ʉ yø hmɛ̱ya'ʉ ngue rá̱ nzɛqui. ");
INSERT INTO otnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bi sigue bi 'yɛ̱mbʉya: ―Da̱ nangyø nación ngue da̱ 'yørpa̱ ra̱ tu̱nhni̱ mi̱'da yø nación. Da̱ nangyø da̱st'abi ngue da̱ 'yørpa̱ ra̱ tu̱nhni̱ mi̱'da yø da̱st'abi. ");
INSERT INTO otnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ja̱njua̱ni̱ ngue di 'ya̱n'a̱häi. Di̱ nja yø thu̱hu̱, di̱ nja yø guɛ̱hi̱. Di̱ nsu̱ yø ja̱'i̱ 'mø bi̱ nu̱ yø hmɛ̱ya dá̱ nja ma̱ya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pɛ hante ngue di̱ nja ya yø hya̱ dí xi'a̱hʉ ya, da̱ gu̱'a̱hʉ yø ja̱'i̱ ngue di bɛnt'a̱hʉ, di dä'a̱hʉ p'ʉ ja yø ni̱ja̱, da̱ jo'a̱hʉ. Di̱ ndä'a̱hʉ p'ʉ 'bʉhyø da̱st'abi. Di ja'a̱hʉ p'ʉ yø ja̱'i̱ ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngue ngu̱'a̱ di̱ nja'a̱hʉ, nu̱'mø ya gdi̱ ya̱hʉ yø ts'ʉt'abi, ja gui xihmʉ p'ʉ ra̱ hoga̱ 'da'yo hya̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nu̱'mø bi̱ ma ma̱ bɛnt'i̱'a̱hʉ, 'yo sä di tu̱ ni̱ mmʉihʉ'a̱ ra̱ hya̱ ja ngue gui xihmʉ ra̱ ts'ʉt'abi. ");
INSERT INTO otnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porque ga̱ 'da'a̱hʉ ra̱ hya̱, ngue gui pa̱di̱ te gui̱ mma̱mhmʉ p'ʉ 'bʉ'ʉ di sʉ'a̱hʉ. Hi̱njonda̱ zä da̱ däcra̱ hya̱ ga̱ 'da'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A nu̱yá, asta̱ ni̱ papásɛ di dä'a̱hʉ. Ni̱ n'yohʉsɛ di dä'a̱hʉ. Ni̱ mɛ̱ni̱sɛ di dä'a̱hʉ, ni̱ amigosɛ di dä'a̱hʉ. Pɛ di̱ m'mʉ'i'da da̱ tho'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Da̱ zʉ'a̱hʉ yø ja̱'i̱ ndap'ʉ bi zä ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pɛ ni̱ xi̱nga̱ n'na ni̱ xta̱hʉ di̱ m'mɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nu̱'mø hi̱ngui̱ hyɛga̱hʉ, gue'a̱ di̱ n'na'a̱hʉ ra̱ 'da'yo te'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nu̱'mø gá̱ nu̱hʉ ngue ya di̱ mäs'yø soldado ra̱ hni̱ni̱ Jerusalén, gui pa̱hmʉ p'ʉya ngue n'na zihma̱ntho da̱ ma ma̱juadi ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nu̱'ʉ yø mmɛ̱ngu̱ p'ʉ ja ra̱ häi Judea, da̱ 'dagui, di̱ map'ʉ ja yø xa̱nthø. Nu̱'ʉ di 'bʉp'ʉ ja ra̱ hni̱ni̱ Jerusalén, da̱ 'dagui. A nu̱'ʉ dí 'yo ra̱ 'bɛfi, ya hi̱ndi̱ map'ʉ ja rá̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porque ya bi zøhra̱ pa di̱ nja ra̱ castigo. Nu̱ te gä nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, da̱ gue'a̱ ra̱ ora'a̱ ngue di̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Huɛ̱ca̱te yø xisu di ha̱dyø ba̱si̱'a̱ ra̱ pa'a̱, ogue di sʉdyø ba̱si̱. Porque ra̱ nda̱te di̱ nja ua ja ra̱ häi. Ra̱ ndu̱ssu̱tho ra̱ castigo da̱ thohyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Da̱ tho yø ja̱'i̱ conyø juai. Mi̱'da p'ʉya, da̱ ts'ixa̱ fädi, di̱ ma ra̱ fädi ndø yap'ʉtho n'nanni̱ yø häi. 'Nɛ̱ nu̱'ʉ yø ja̱'i̱ hi̱ngyø judío p'ʉya, da̱ nɛ̱'a̱häi yø mmɛ̱ngu̱ Jerusalén asta̱ gue'mø da̱ ne Oja̱ di̱ m'mɛhyø hya̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Di̱ nja yø hmɛ̱ya p'ʉ ja ra̱ hyadi, 'nɛ̱p'ʉ ja ra̱ za̱na̱, 'nɛ̱p'ʉ ja yø sø. Nu̱ua ja ra̱ xi̱mhäi p'ʉya, hi̱nda̱ ba̱di̱ te da̱ 'yøtyø ja̱'i̱ 'bʉp'ʉ ja yø nación. Di̱ nsu̱ yø ja̱'i̱ ngue'a̱ gui thoni̱ yø fʉnthe di ja ra̱ ja̱the. ");
INSERT INTO otnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nu̱'mø bi zo yø mmʉi yø ja̱'i̱'a̱ te ja ngue di̱ nja ua ja ra̱ xi̱mhäi, asta̱ da̱ güentyø ja̱'i̱ ngue ra̱ ts'u̱. Nu̱ te gä bí ja ma̱ya̱, gä di pädi hapʉ thogui. ");
INSERT INTO otnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Da̱ thandra̱ N'yohʉ di 'yɛ̱ mɛ̱hɛ̱ts'i̱ ngue da̱ n'youi ra̱ gu̱i̱. Da̱ hnu̱ ngue ma̱guesɛ, porque ma̱thoguitho ja rá̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu̱'mø ya bi̱ mʉdi di̱ nja ya yø hya̱ ya, da̱mi̱ hya̱ ra̱ ts'ɛdi gui jʉxni̱ ya̱hʉ, gui hyanthʉ ma̱yá̱. Porque ya xma̱ nguerpʉtho da̱ ɛ̱hni̱ Nya̱tehʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma̱hømbi̱ hyɛj hma̱n'na ra̱ hya̱ bi xihyø ja̱'i̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Guí̱ nnu̱hʉ n'na ra̱ za ra̱ igo, ogue ndana̱ bi zä ma̱ za. ");
INSERT INTO otnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu̱'mø ya bi c'ammi̱ ngue bi 'dogui, guí pa̱hmʉ p'ʉya ngue ya ni̱ ma di pat'i xa̱nho häi. ");
INSERT INTO otnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngu̱na̱ ra̱ hya̱ ja ngue di̱ nja ya. Nu̱'mø gá̱ nu̱hʉ ngue ya bi̱ nja ya yø hya̱ dí xi'a̱hʉ, da̱mi̱ pa̱hmʉ ngue ya xma̱ nguepʉtho di̱ ma̱nda Oja̱ ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nu̱ya yø hmɛ̱ya dí xi'a̱hʉ ya, da̱mi̱ pa̱hmʉ ngue guehya di̱ nja ya, hante ngue da̱ du̱ yø ja̱'i̱ 'bʉhra̱ pa ja p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nu̱ te bí ja ma̱ya̱, 'nɛ̱cua ja ra̱ häi, hi̱ngui̱ za̱i̱. Pɛ nu̱na̱ ra̱ hya̱ dí̱ mma̱ngä, ja para za̱ntho na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Da̱mi̱ mfähmʉ xa̱nho, 'yo da̱di̱ mbɛntui ra̱ nts'o ni̱ mmʉihʉ. Ma̱nma̱ thä'i ngue gui̱ n'i̱ti̱hʉ, ogue høndra̱ mɛ̱nyu̱ gui ja ndu̱mmʉi ha gdi ti̱mhmʉ. Porque nu̱'mø bi zønna̱ pa rá̱ nzɛgui, ja̱ gui tha̱mbɛ̱ni̱hʉ, ya di jap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tengu̱tho 'mø te bi zo ra̱ 'dihi, di̱ njarbʉtho'a̱ te da̱ thogui gätho yø ja̱'i̱ 'bʉi rá̱ ngʉni̱ nxi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gue'a̱ ngue gdi̱ mfähmʉ xa̱ndønho'a̱. Da̱mi̱ mat'Oja̱hʉ hangu̱ ra̱ pa, n'namhma̱ ngue gui̱ mpomhmʉ ra̱ nda̱te ja ngue di̱ nja. Ja̱na̱ngue da̱ zä guí sømhmʉ p'ʉ di 'bʉhra̱ N'yohʉ di 'yɛ̱ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nu̱'mø ra̱ pa, i xännba̱te p'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús. Ra̱ xu̱i̱ p'ʉya, pa bi op'ʉ bí ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos. ");
INSERT INTO otnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Gätho yø ja̱'i̱, xu̱di̱ xu̱di̱ pap'ʉ ja ra̱ ni̱ja̱ ngue øxra̱ hya̱ mma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ya mi̱ ts'ʉdra̱ ngo ngue ra̱ pascua, guehna̱ ra̱ pa ts'i ra̱ thu̱hmɛ̱ hi̱ngui̱ n'youi ra̱ íxi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nu̱'ʉ yø hmu̱ yø mmäcja̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley, guehya ya rá̱ ya'atho yø pa honi̱ ha di hyo ra̱ Jesús. Pɛ su̱pi̱ di̱ mbøcuɛ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ra̱ zithu̱ p'ʉya bi yʉrbʉ ja rá̱ mmʉi ra̱ Judas Iscariote, guehna̱ n'na nc'ɛ̱i̱'ʉ 'dɛ'ma̱ yoho yø xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nu̱na̱ ra̱ Judas, bi̱ ma bá̱ nya̱ui yø hmu̱ yø mmäcja̱, 'nɛ̱hyø n'yohʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱. Bá̱ nhɛca̱ hya̱ui yø mmäcja̱ ha di japi di däpra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ra̱ ndijohya ya yø mmäcja̱ 'mø di̱ni̱ ha di zʉdi. Bi xihna̱ ra̱ Judas ngue di u̱nna̱ mɛ̱nyu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bi̱ nu̱ ma̱nho te bi sihna̱ ra̱ Judas ngue di t'u̱nna̱ mɛ̱nyu̱. Bi hyoni̱ ha di japi ngue di däpyø mmäcja̱ ra̱ Jesús, pɛ da̱ gue'a̱ ra̱ ora ngue 'bʉsɛ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ya fʉhra̱ ngo nguehya yø pa ts'i ra̱ thu̱hmɛ̱ hi̱ngui̱ n'youi ra̱ íxi. Guehna̱ ra̱ pa hodɛ'yo yø ja̱'i̱ ngue sänni̱go, ngue di̱ nzibde ngue ra̱ pascua. ");
INSERT INTO otnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nu̱na̱ ra̱ Jesús bi 'yɛtra̱ Bɛdu 'nɛ̱hra̱ Xuua, bi 'yɛ̱mbi̱: ―Ni̱ mɛ ya, bí hocui'a̱ te gdá̱ nzibdehʉ, ga̱ nsänni̱gohʉ ngue ra̱ pascua ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bi 'yɛ̱n'ʉ yø xädi p'ʉya: ―¿Hapʉ guí̱ nne ga̱ ma hocä'be'a̱ te ga̱ sihʉ p'ʉya? ");
INSERT INTO otnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'mø gá̱ cʉt'ui mbo ra̱ hni̱ni̱, gui̱ nthɛui n'na ra̱ n'yohʉ ni̱ ma rá̱ ngu̱, di tu̱ n'na xøni̱ ra̱ dehe. Da̱mi̱ tɛnnui hapʉ da̱ zøni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Gui 'yɛ̱nui ra̱ mmɛ̱nni̱gu̱ p'ʉya: “Ra̱ xännba̱te i ɛ̱na̱: ¿Hapʉ ja ra̱ cuarto ga̱ nzibdehe ma̱ xädi, ja ga̱ sähe p'ʉ ra̱ ngo ngue ra̱ pascua?” gui 'yɛ̱nui. ");
INSERT INTO otnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ra̱ mmɛ̱nni̱gu̱ p'ʉya da̱ 'yu̱t'a̱ui n'na ra̱ da̱cuarto bí ja ma̱ya̱ ra̱ tøca̱ngu̱. Ja da̱mi̱ hocui p'ʉ'a̱ te ja ngue gdá̱ nzibdehʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bi̱ ma'ʉ yoho yø xädi mi̱ ya̱ui ra̱ Jesús. Mi̱ zømp'ʉ ja ra̱ hni̱ni̱, tengu̱tho ra̱ hya̱ xi̱ ma̱nna̱ Jesús, gue'a̱ bi̱ nja'a̱. Bi di̱nna̱ ngu̱ tengu̱tho xi xifi, ja bi hojpʉ ra̱ nzibde ngue ra̱ pascua p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nu̱'mø mi̱ zønna̱ ora di̱ nsi̱hmɛ̱ p'ʉya, nu̱na̱ ra̱ Jesús, gätho'ʉ 'dɛ'ma̱ yoho yø xädi, gä 'bʉp'ʉ ja ra̱ mɛ̱xa. ");
INSERT INTO otnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ra̱ Jesús bi 'yɛ̱na̱: ―Hante ngue da̱ thogui, ja̱njua̱ni̱ ngue sixa̱ mpähä ma̱ mmʉi ngue 'daua ga̱ nsi̱hmɛ̱hʉ na̱ ra̱ ngo ngue ra̱ pascua. ");
INSERT INTO otnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porque dí xi'a̱hʉ ngue ya hi̱nni̱ mantho ga̱ nsänni̱gohʉ, asta̱ gue'mø di̱ nja'a̱ te ja ngue di̱ nja, ya gdi 'bʉhmʉ p'ʉ ha di̱ ma̱nda Oja̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bi dɛcra̱ vaso p'ʉya ngue di ja ma̱mma̱di̱ Oja̱. Bi 'yɛ̱mbyø xädi p'ʉya: ―Da̱mi̱ ndarpa̱hʉ na̱ya, sihʉ 'da'its'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porque dí xi'a̱hʉ ngue ya hi̱nni̱ mantho ga̱ sigä rá̱ ngui ra̱ uva, asta̱ gue'mø bi zønna̱ pa di̱ ma̱nda Oja̱ ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","M'mɛfa p'ʉya, bi hya̱jma̱n'na ra̱ thu̱hmɛ̱. Mi̱ ja ma̱mma̱di̱ Oja̱ p'ʉya, bi xɛnna̱ thu̱hmɛ̱, bi u̱nyø xädi ngue da̱ zi. Bi 'yɛ̱mbi̱: ―Nu̱na̱ ya, guehna̱ ma̱ do'yogä na̱ya. Nu̱'mø gá̱ sihʉ yø pa di̱ map'ʉ na̱ya, gue'a̱ gdí bɛ̱njʉ'a̱ ngue da̱di dä ma̱ do'yo ngue dá̱ du̱ conná̱ ngue'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mi̱ juadi bi̱ nsi̱hmɛ̱ p'ʉya, bi dɛcra̱ vaso, bi 'yɛ̱na̱: ―Nu̱na̱ po ra̱ vaso ja ua ya, guehna̱ ra̱ hmɛ̱ya na̱ya ngue nu̱'mø dá̱ tu̱, di̱ nja rá̱ ts'ɛdi ra̱ 'da'yo cohi øt'a̱hʉ Oja̱. Porque di̱ mfämma̱ ji conná̱ ngue'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nu̱ua ja ra̱ mɛ̱xa dí si̱hmɛ̱hʉ ya, 'bʉcua n'na nc'ɛ̱i̱ ngue jʉga̱tho häi, ya xa̱ hyoni̱ ha di japi ngue di dägui. ");
INSERT INTO otnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ja ngue da̱ tho. Nu̱ te xpa̱ ts'ännbi̱ ngue da̱ thogui, da̱ thomhma̱'a̱. Pɛ hague ngu̱ ra̱ castigo da̱ thohna̱ ra̱ n'yohʉ di dägui. ");
INSERT INTO otnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bi̱ mʉdi di̱ n'yänni̱ n'na ngu̱ n'na p'ʉya te'o'a̱ ja ngue di dä ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bi̱ mʉdi bi̱ nju̱n'ma̱hya̱ yø xädi ra̱ Jesús ngue nne di̱ m'mɛt'o n'na ngu̱ n'na. ");
INSERT INTO otnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱p'ʉ ja yø nación, i 'bʉhyø da̱st'abi ngue di̱ ma̱nda p'ʉ ja yø häi. Nu̱'a̱ ra̱ ts'ʉt'abi di̱ ma̱nda yø ja̱'i̱ p'ʉya, i ɛ̱nyø ja̱'i̱ ngue xa̱nho te ørpa̱bi̱ ra̱ ts'ʉt'abi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pɛ nu̱'a̱hʉ, 'yo guí̱ nne guí̱ ma̱ndathohʉ yø ja̱'i̱. Nu̱ ra̱ ja̱'i̱ nne ngue xta̱ nhɛ̱ts'i̱ rá̱ cargo da̱ mɛfi, guehna̱ ra̱ ja̱'i̱ jatho ngue di̱ mpɛfi da̱ mäxyø mmi̱c'ɛ̱i̱ui na̱. Nu̱'a̱ da̱ ne di̱ m'mɛt'o ngue gätho yø amigo, guehna̱ jatho da̱ gohi ngue ni̱ mɛfithohʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Porque nu̱yá, ¿ndana̱ gue'a̱ nt'ɛ̱mbi̱ ma̱ da̱ya, gue'a̱ hu̱p'ʉ ja ra̱ mɛ̱xa ma̱ da̱, ua gue gue'a̱ 'ui̱te ma̱ da̱? Ua̱ngui̱ hu̱p'ʉ ja ra̱ mɛ̱xa'a̱ ma̱ da̱. A nu̱yá, dí 'bʉcä ua ha guí 'bʉhmʉ ya, pɛ hi̱n da̱di̱ ma̱ndathogä. Sinoque da̱di̱ mpɛfi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","A nu̱yá, gue'a̱hʉ xtá̱ n'yohʉ mɛ̱nte yø pa xtá̱ sägä ra̱ n'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ma̱ Papá bá̱ ɛ̱xqui̱ ngue ga̱ ma̱nda gätho yø ja̱'i̱. Nu̱gä xquet'a̱ dí ɛ̱xa̱hʉ ya ngue ");
INSERT INTO otnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nu̱p'ʉ da̱di̱ ma̱ndagä, 'dap'ʉ ga̱ mmi̱hmʉ p'ʉ ja ra̱ mɛ̱xa ga̱ nsi̱hmɛ̱hʉ. Guí̱ mmi̱hmʉ p'ʉ ja yø nthu̱ts'i̱ ngue gui̱ ma̱ndahʉ'ʉ 'dɛ'ma̱ yo'bʉi yø ja̱'i̱ Israel. ");
INSERT INTO otnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nu̱na̱ ra̱ Jesús bi 'yɛ̱mbra̱ Bɛdu: ―Ague Bɛdu, nu̱'a̱ ra̱ zithu̱, äpra̱ nt'ɛ̱di̱ Oja̱ ngue da̱ hyoni̱ ha di japi ngue gui hyɛga̱hʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pɛ xquet'a̱ dí äpra̱ ma̱te Oja̱ conná̱ ngue'e ngue hi̱ngui̱ 'bɛhni̱ nt'ɛ̱c'ɛ̱i̱. Pɛ nu̱'i̱ 'mø bi̱ n'yo ni̱ mmʉi'a̱ te guí øt'e, da̱mi̱ ha̱tra̱ ts'ɛdi ni̱ cu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, nu̱gä xquet'a̱ dí 'bʉi ma̱da̱gue'a̱ 'da gdá̱ mɛ fädi, ogue asta̱ 'dap'ʉ ga̱ tu̱ui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbra̱ Bɛdu: ―Ague Bɛdu, nu̱gä dí xi'i, nu̱'mø tobe hi̱ndi̱ mahra̱ øni̱, ya xqui cønga̱ nhyu̱ndi̱, guí̱ mma̱ ngue hi̱nguí̱ pa̱qui̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bi 'yänyø xädi ra̱ Jesús, bi 'yɛ̱mbi̱: ―Xi'mø ma̱ xi'a̱hʉ ngue hi̱nte gui hya̱xhʉ p'ʉ gá̱ mähä, xi̱ngra̱ bʉxa, ni̱ xi̱ngra̱ njʉmɛ̱nyu̱, 'nɛ̱ hi̱ngui̱ cʉx mi̱'da ni̱ thi̱xfani̱hʉ, ¿ua ja tema̱ cosa gá̱ 'bɛhmʉ? Bi 'yɛ̱mbyø xädi p'ʉya: ―Hi̱n'na̱, hi̱nte bi̱ m'mɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―A nu̱yá, nu̱ to ja rá̱ bʉxa, da̱ ga̱ts'i̱. Da̱ ga̱xrá̱ njʉmɛ̱nyu̱. Nu̱ to hi̱n'yʉ rá̱ juai, da̱ mä rá̱ pahni̱ ngue da̱ dän'a̱ n'na ra̱ juai. ");
INSERT INTO otnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porque dí xi'a̱hʉ ngue jatho ngue ga̱ thocä'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Da̱ tho tengu̱tho n'na ra̱ ts'oc'ɛ̱i̱”, i ɛ̱na̱. Porque nu̱'a̱ te nt'ot'i ngue ga̱ thocä, jatho ngue di̱ njahma̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nu̱'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ja ua yoho yø juai. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Co nu̱'a̱ 'mø ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nu̱p'ʉ bí ja ra̱ nyu̱ni̱ ma̱mbi̱ o'a̱ m'mɛt'o ra̱ Jesús ja ra̱ mbonza ja yø olivos, ja i̱ map'ʉ ra̱ Jesús, bi̱ mähä yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mi̱ zømp'ʉ ha ja ngue da̱ zømp'ʉya, bi 'yɛ̱mbyø xädi: ―Da̱mi̱ mat'Oja̱hʉ ya. Nu̱'mø hi̱ngá̱ mat'Oja̱hʉ, ntha̱mbɛ̱ni̱tho hi̱nda̱ gue'a̱ gui 'yøthʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bi thohmi̱ts'ʉ ní̱ nguep'ʉ ra̱ Jesús. Nu̱p'ʉ bi zøni̱, tengu̱ ga̱ yap'ʉ da̱ zøn'a̱ n'na ra̱ do 'mø bi t'ɛi. Bi̱ nda̱ntyøhmu̱ p'ʉya ngue da̱ mat'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Bi 'yɛ̱na̱: ―Ague ma̱ Papá'i, nu̱'mø guí̱ nnu̱ ma̱nho, da̱mi̱ ya̱ngui̱ ngue'a̱ ra̱ nda̱te ja ngue ga̱ thocä. Pɛ hi̱nga̱ nu̱'a̱ go ga̱ sännä gue'a̱ di̱ nja'a̱, sinoque nu̱ te guí sänni̱, gue'a̱ di̱ nja'a̱ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bi̱ nu̱ p'ʉya ngue bi zø'a̱ n'na ra̱ anxɛ bí 'yɛ̱ ma̱hɛ̱ts'i̱, di ha̱tra̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nu̱'a̱ ga̱ ndär'ma̱ n'ʉ rá̱ mmʉi'a̱ te ja ngue da̱ thogui, ma̱n'na ngue rá̱ mmʉi ga̱ mmat'Oja̱. Nu̱'ʉ yø xänthe i ja, i 'yu̱gui̱ so häi, tengu̱tho 'mø pønna̱ ji p'ʉ ja n'na ra̱ ts'ɛt'i. ");
INSERT INTO otnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mi̱ juadi bi̱ mat'Oja̱ p'ʉya, bi̱ nangui̱, bi̱ map'ʉ bí 'bʉhyø xädi. Nu̱'ʉ yø xädi p'ʉya, ya mi̱ a̱ha̱, bi da̱pra̱ t'a̱ha̱ ngue ra̱ du̱mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Bi 'yɛ̱mbʉya: ―¿Hanja ngue guí a̱hmi̱? Da̱mi̱ nangui̱, gui̱ mmat'Oja̱hʉ. Nu̱'mø hi̱ngá̱ mat'Oja̱hʉ, ntha̱mbɛni̱tho hi̱nda̱ gue'a̱ gui 'yøthʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mɛ̱nte ya̱ui yø xädi ra̱ Jesús, bi zøhna̱ ra̱ Judas ni̱ zi xa̱ngu̱ yø ja̱'i̱. Guehna̱ n'na nc'ɛ̱i̱ ya 'dɛ'ma̱ yoho yø xädi ra̱ Jesús. Bi guat'i ngue bi zɛngua p'ʉ 'bähra̱ Jesús, bi zʉrpa̱ rá̱ hmi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nu̱na̱ ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague Judas, con n'na ra̱ beso guí dä ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ya'mø. ");
INSERT INTO otnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yø amigo ra̱ Jesús mi̱ nu̱ te bi̱ nja, bi 'yɛ̱mbʉya: ―Ague grá̱ Hmu̱, ¿ua guí̱ nne ga̱ japhʉ ra̱ juai? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bi gʉxrá̱ juai n'na nc'ɛ̱i̱ rá̱ xädi ra̱ Jesús. Bi zɛnnba̱bi̱ rá̱ 'yɛ̱hɛ̱ ra̱ 'bɛt'o mmäcja̱, bi hyɛjpa̱ rá̱ gu̱ ngue rá̱ n'yɛi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Da̱mi̱ hyɛgui, 'yo ga̱di japhʉ ―bi 'yɛ̱mbi̱. Nu̱na̱ ra̱ Jesús bi därpa̱ rá̱ gu̱ na̱ bi thɛjpa̱ rá̱ gu̱ ngue bi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nu̱ya yø hmu̱ yø mmäcja̱, 'nɛ̱hyø policía fähra̱ ni̱ja̱, 'nɛ̱hyø n'yohʉ 'bɛt'o p'ʉ ja ra̱ ni̱ja̱, gä ní̱ 'yɛ̱hra̱ nzite. Ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Ua guí ɛ̱mhmʉ ngue drá̱ bɛ̱gä, ngue guí cʉhʉ yø juai 'nɛ̱ guí cʉhʉ yø za ngue gui bɛnnga̱hʉ? ");
INSERT INTO otnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Conque n'na pa ngu̱ n'na pa nmi̱ xännbä ra̱ hya̱ yø ja̱'i̱ p'ʉ ja ra̱ ni̱ja̱. Ua̱ngui̱ xta̱ nzä ja xqui bɛnnga̱hʉ p'ʉ. Pɛ ya guehna̱ ra̱ ora guí 'yohʉ na̱ya, ngue nu̱'mø ra̱ 'bɛxu̱i̱ i ja rá̱ pähä ra̱ zithu̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ya bi bɛntyø ja̱'i̱ ra̱ Jesús. Bi zixpʉ ja rá̱ ngu̱ ra̱ 'bɛt'o mmäcja̱. Pɛ ra̱ Bɛdu, ni̱ 'bɛfa ya'atho p'ʉ ni̱ ma yø ja̱'i̱ ni̱ zi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nu̱p'ʉ ma̱de ra̱ da̱thi, bi t'u̱'a̱ n'na ra̱ sibi ngue bi̱ mi̱hyø ja̱'i̱ di̱ nhat'i. Xquet'a̱ 'nɛ̱hra̱ Bɛdu bi̱ mi̱ ngue di̱ nhat'i. ");
INSERT INTO otnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nu̱na̱ n'na ra̱ xisu ngue ra̱ gʉni̱ p'ʉ ja ra̱ ngu̱, mi̱ nu̱ ra̱ Bɛdu ngue hu̱p'ʉ ja ra̱ sibi. Bi za di hɛ̱ti̱ p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, xquet'a̱ rá̱ n'youi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pɛ mi̱ da̱hra̱ Bɛdu, bi 'yɛ̱na̱: ―Hi̱n'na̱ cuø, hi̱ndí̱ pa̱cä na̱ ra̱ n'yohʉ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mi̱ tho ma̱n'na ts'ʉquits'ʉ p'ʉya, hømbi̱ nu̱ ma̱n'na nc'ɛ̱i̱ p'ʉ mi̱ hu̱hra̱ Bɛdu, bi 'yɛ̱mbi̱: ―Nu̱'i̱, xquet'a̱ ni̱ n'youi'ʉ tɛnna̱ Jesús. Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱na̱: ―Hi̱n'na̱ n'yø, hi̱nga̱ 'nɛ̱cä. ");
INSERT INTO otnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mi̱ tho hma̱n'na ora m'mɛfa p'ʉya, ma̱n'na̱ nc'ɛ̱i̱ ngu̱t'a̱ bi̱ ma̱, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ ngue nu̱na̱ ra̱ n'yohʉ 'bʉcua, rá̱ n'youi ra̱ Jesús, porque di̱ nɛ̱qui̱ ngue ra̱ mmɛ̱ngu̱ Galilea na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱na̱: ―Ague n'yø, hi̱ndí̱ pa̱cä tema̱ hya̱ guí̱ nne gui xicya. Nu̱'a̱ ra̱ ora'a̱ p'ʉya, tobe hi̱n ma̱ni̱ juadi mma̱nna̱ Bɛdu'a̱ te mma̱, bi̱ mmahra̱ øni̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bi 'bätra̱ Jesús ngue bi hyannbʉ bi hu̱hra̱ Bɛdu. Ra̱ Bɛdu p'ʉya, bi zo rá̱ mmʉi na̱ ra̱ hya̱ xi xihra̱ Jesús ngue xi 'yɛ̱mbi̱: “Tobe hi̱ndi̱ mahra̱ øni̱, ya xqui cønga̱ nhyu̱ndi̱, guí̱ mma̱ ngue hi̱nguí̱ pa̱qui̱”, xi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ra̱ Bɛdu p'ʉya, asta̱ ra̱ zondu̱mmʉi bi bøn'a̱thi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nu̱'ʉ yø n'yohʉ fähra̱ Jesús, i thenni̱ 'nɛ̱ i pɛ'mi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bi gorpa̱ yø dä conna̱ u̱lu, bi mɛ'mi̱, bi 'yɛ̱mbi̱: ―Da̱mi̱ pa̱hya te'o bi̱ mɛp'a̱'i̱ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Xa̱ngu̱ mi̱'da yø hya̱ xifi ngue ga̱ ndenni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mi̱ nɛ̱ca̱häi p'ʉya, bi̱ mpɛti gätho yø n'yohʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱, conyø hmu̱ yø mmäcja̱, conyø xännba̱te ngue ra̱ ley. Ra̱ da̱junta bi̱ nja, ja bi ts'ixpʉ ra̱ Jesús ngue da̱ t'ørpa̱ ra̱ nt'änni̱, bi t'ɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Da̱mi̱ xicje ya ngue'mø gue'e grá̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi, ogue hi̱n'na̱. ¿Te guí̱ mma̱nna̱ ra̱ hya̱ na̱ya? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'mø ga̱ xi'a̱hʉ ngue guecä, hi̱ngui̱ 'yɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nu̱'mø xi̱nga̱ øt'a̱hʉ n'na ra̱ nt'änni̱ p'ʉya, xquet'a̱ hi̱ngui̱ nne gui̱ mma̱mhmʉ'a̱ te ga̱ än'na̱hʉ. 'Nɛ̱ hi̱ngui̱ nne gui thøga̱hʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ya ni̱ ma da̱ zønna̱ ora ya, ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ni̱ mmi̱p'ʉ ja rá̱ n'yɛi Oja̱ nu̱na̱ jasɛ rá̱ ts'ɛdi. ");
INSERT INTO otnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gätho yø ja̱'i̱ p'ʉya bi 'yɛ̱mbi̱: ―¿Ua guí ɛ̱na̱ ngue gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱ 'mø? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―A̱há̱, go guecä tengu̱tho guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Di̱ n'yɛ̱mbyø ja̱'i̱ p'ʉya: ―¿Teni̱ 'bɛ'a̱ ma̱n'na ma̱ testigo ga̱ nnehʉ ya'mø? Ya dá̱ øsɛhʉ ra̱ hya̱ pønná̱ ne ya. ");
INSERT INTO otnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Gä bi̱ nangyø ja̱'i̱ p'ʉya, bi zixpʉ 'bʉhra̱ Pilato ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bi̱ mʉhyø ja̱'i̱ ngue di ya̱pra̱ Jesús, ɛ̱nyø ja̱'i̱: ―Dí ti̱nnbähe n'na ra̱ hya̱ na̱ ra̱ n'yohʉ 'bʉcua, ngue di ts'onnba̱ yø mmʉi yø ja̱'i̱. I ɛ̱mbi̱ ngue hi̱ngui̱ ja ngue di u̱nyø ja̱'i̱'a̱ ra̱ mɛ̱nyu̱ ähra̱ da̱st'abi 'bʉ'a̱ Roma. Xquet'a̱ i̱ mma̱ ngue guehna̱ ra̱ Cristo na̱, i̱ nne da̱ ma̱ ngue n'na ra̱ da̱st'abi. ");
INSERT INTO otnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ra̱ Pilato bi 'yänna̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua gue'e rá̱ da̱st'abi'i yø judío? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―A̱há̱, go guecä tengu̱tho ra̱ hya̱ guí̱ mma̱nya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ra̱ Pilato bi 'yɛ̱mbyø hmu̱ yø mmäcja̱, da̱ guehmi̱'da yø ja̱'i̱: ―Hi̱n tema̱ ts'oqui dí ti̱nnbä na̱ ra̱ n'yohʉ 'bʉcua ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pɛ yø ja̱'i̱ ma̱hømbi 'yɛ̱na̱: ―Nu̱na̱ ra̱ hya̱ xännba̱te p'ʉ ja ra̱ häi Judea na̱, di ts'onyø ja̱'i̱ na̱ ra̱ hya̱ na̱. Bi fʉ'a̱ Galilea xännba̱te ra̱ hya̱, asta̱ søcua ya. ");
INSERT INTO otnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mi̱ 'yøhra̱ Pilato na̱ ra̱ hya̱ mma̱nyø ja̱'i̱, bi 'yännbʉya ngue'mø ra̱ mmɛ̱ngu̱ p'ʉ Galilea na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nu̱'mø mi̱ xi p'ʉya ngue ja ra̱ mmɛ̱ngu̱ p'ʉ, bi̱ mɛnnba̱ na̱ ra̱ Herodes mi̱ nda̱st'abi p'ʉ Galilea. Porque ra̱ Herodes, nu̱'ʉ yø pa'ʉ, mi̱ 'bʉp'ʉ Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ra̱ Herodes, nu̱'mø mi̱ nu̱ ra̱ Jesús, ɛ̱mmɛ̱i̱ di johya. Porque ya rá̱ ya'atho yø pa i̱ nne da̱ nu̱, ngue øde te mma̱nyø ja̱'i̱ t'ɛ̱mbi̱ øtra̱ Jesús. Mi̱ tø'mi̱ ngue da̱ nu̱rpi̱ tema̱ milagro da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Xa̱ngu̱ yø nt'änni̱ bi 'yørpe, pɛ ra̱ Jesús hi̱nte ga̱ nda̱tho. ");
INSERT INTO otnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Xquet'a̱ 'bʉp'ʉ yø hmu̱ yø mmäcja̱ 'nɛ̱hyø xännba̱te ngue ra̱ ley. Di ya̱pi̱ hi̱n'yʉ p'ʉ rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nu̱na̱ ra̱ Herodes co 'nɛ̱hyø soldado xquet'a̱ hi̱mbi̱ nu̱ ma̱nho ra̱ Jesús. I thentho, bi heta̱ n'na rá̱ he ma̱zihotho tengu̱tho rá̱ he n'na ra̱ da̱st'abi. Ra̱ Herodes ma̱hømbi̱ mɛnhna̱ Jesús, i̱ map'ʉ 'bʉhra̱ Pilato. ");
INSERT INTO otnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma̱da̱gue'a̱ ma̱di̱ nsʉhmi̱ m'mɛt'o ra̱ Pilato ra̱ Herodes, pɛ bi̱ n'amigo m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nu̱na̱ ra̱ Pilato bi pɛti gätho yø hmu̱ yø mmäcja̱, gätho yø ts'ʉt'abi, gätho mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bi 'yɛ̱mbi̱: ―Ya guá̱ singa̱hʉ ua na̱ ra̱ n'yohʉ 'bʉcua. Guí ɛ̱mhmʉ ngue di ts'onyø ja̱'i̱. Pɛ ni̱ hmi̱ ni̱ dähʉ hapʉ dí änni̱, 'nɛ̱ guí̱ nnu̱hʉ ngue hi̱n tema̱ ts'oqui dí ti̱nnba̱bi̱ ngue'a̱ te gni̱ ya̱phʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni̱ xi̱nga̱ guehra̱ Herodes ngue xta̱bá̱ ndi̱nnba̱ rá̱ ts'oqui, porque bi costho hømbi 'yɛ̱cua. Ja guí̱ nnu̱hʉ p'ʉya ngue hi̱n tema̱ hya̱ di̱ nɛ̱qui̱ para ngue da̱ t'ɛ̱mbi̱ ja te rá̱ngue'a̱ ngue da̱ tho. ");
INSERT INTO otnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nu̱gä ga̱ ma̱nda ngue da̱ 'bɛi, pɛ ga̱ thøgue. ");
INSERT INTO otnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ra̱ Pilato i ja ngue da̱ 'yøt'e te ra̱ costumbre ja yø ja̱'i̱, nu̱'mø ra̱ ngo ngue ra̱ pascua, pa ma̱thøgue n'na ra̱ ofädi. ");
INSERT INTO otnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gätho yø ja̱'i̱ p'ʉya, bi̱ mʉhra̱ mafi, i ɛ̱na̱: ―Nu̱na̱ ra̱ Jesús da̱ tho na̱. Go da̱mi̱ thøhra̱ Barrabás. ");
INSERT INTO otnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Pɛ nu̱na̱ ra̱ Barrabás, guehna̱ n'na nc'ɛ̱i̱ mi̱ ofädi ngue ra̱ 'yøt'i sʉi, 'nɛ̱ ra̱ hyote p'ʉ ja ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ra̱ Pilato hømbi̱ xihyø ja̱'i̱ ngue da̱ zä di thøhra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pɛ yø ja̱'i̱ p'ʉya, ma̱n'na nts'ɛdi ga̱ mafi, i ɛ̱na̱: ―Da̱ guatra̱ pont'i̱. Da̱ guatra̱ pont'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Rá̱ hyu̱ ndi̱ p'ʉya, bi 'yɛ̱nna̱ Pilato: ―¿Pɛ tema̱ nts'o xa̱ 'yø'na̱ p'ʉya? Nu̱gä hi̱n tema̱ ts'oqui di ti̱nnbi̱ ngue da̱ t'ɛ̱mbi̱ da̱ tho. Nu̱gä ga̱ ma̱nda da̱ 'bɛi, pɛ ga̱ thøgue. ");
INSERT INTO otnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pɛ yø ja̱'i̱ hi̱ngui̱ säya ngue mafi, ädi ngue da̱ ma ma̱cuati ra̱ pont'i̱ ra̱ Jesús. Nu̱'a̱ ga̱ ma̱hyø ja̱'i̱ co 'nɛ̱'ʉ yø hmu̱ yø mmäcja̱, bi̱ nja'a̱ te ädi. ");
INSERT INTO otnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ra̱ Pilato p'ʉya bi zänni̱ ngue di̱ nja'a̱ te mma̱nyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bi̱ ma ma̱thøgue na̱ ra̱ Barrabás xi̱ ma̱nyø ja̱'i̱ ngue di̱ nthøgue. Guehna̱ xi jot'i ngue ra̱ 'yøt'i sʉi 'nɛ̱hra̱ hyote na̱. Go bi̱ ndä na̱ ra̱ Jesús, i hnepe ngue da̱ tho p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nu̱'mø mi̱ ts'ixra̱ Jesús ngue da̱ tho, bi̱ nthɛui p'ʉ ja ra̱ 'yu̱ n'na ra̱ n'yohʉ xpi 'yɛ̱hra̱ 'bɛfi ni̱ hu̱ ngue ra̱ Simu̱, ra̱ mmɛ̱ngu̱ Cirene. Go bi̱ njapi bi du̱xra̱ pont'i̱ na̱ p'ʉya, ni̱ 'bɛfatho p'ʉ ni̱ ma ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pɛ xa̱ngu̱ yø ja̱'i̱ bi dɛnni̱. I̱ ma'a̱ nts'oni̱ yø xisu, tu̱ yø mmʉi ngue te da̱ thohra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pɛ bi hyɛ̱tyø ja̱'i̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague gyø xisu guí 'bʉhmʉ ua Jerusalén, 'yo guí zomhmʉ conná̱ ngueque. Sinoque da̱mi̱ nzoni̱ ngue conná̱ ngue'a̱hʉ 'nɛ̱ conná̱ nguehni̱ ba̱si̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque da̱ 'yɛ̱hyø pa gui 'yɛ̱mhmʉ: Xa̱nho 'bʉi te'o hi̱njo'o yø ba̱si̱, ogue hi̱mbi̱ hya̱ yø ba̱si̱, ogue hi̱mbi̱ sʉta̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yø ja̱'i̱ p'ʉya da̱ 'yɛ̱mbyø t'øhø: “Bá̱ tägui, gui soxca̱he”. Da̱ 'yɛ̱mbyø nyu̱ni̱: “Da̱mi̱ cogba̱he”, da̱ 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","A nu̱ya ngue hi̱nte ga̱di ʉphʉ'a̱ ga̱di ʉmhmʉ ya, hague ngu̱ ra̱ n'ʉ da̱ tho'a̱ ja rá̱ ts'oqui 'mø. ");
INSERT INTO otnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xquet'a̱ ni̱ ts'i yoho yø ts'oc'ɛ̱i̱ ngue 'dap'ʉ da̱ du̱ui ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mi̱ zømp'ʉ ja ra̱ nyu̱ni̱ gui hu̱tyø ja̱'i̱ ngue ra̱ Njʉya̱xhmu̱, ja bi̱ ma ma̱cuati p'ʉ ra̱ pont'i̱ ra̱ Jesús. 'Nɛ̱'ʉ yoho yø ts'oc'ɛ̱i̱ bi̱ ma ma̱cuati ra̱ pont'i̱, n'na rá̱ n'yɛi, n'na rá̱ ga̱ha̱ i gohi. ");
INSERT INTO otnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nu̱'mø ɛma̱ cuati ra̱ pont'i̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Ma̱ Papá'i, da̱mi̱ pu̱nnba̱ yø ja̱'i̱ 'bʉcua, porque nu̱ya hi̱ngui̱ pa̱di̱ te øtya ―bi 'yɛ̱na̱. Yø soldado p'ʉya bi̱ ma ra̱ ta̱ha̱ ngue to xta̱ ra̱ ta̱ha̱, gue'a̱ da̱ ga̱ca̱ n'na xɛqui rá̱ he ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yø ja̱'i̱ 'bäp'ʉ p'ʉya, i hɛ̱tho. Nu̱'ʉ yø judío 'bɛt'o, i thentho'ʉ, i ɛ̱na̱: ―Mi̱ mma̱nnʉ ra̱ n'yohʉ ngue da̱ ya̱nyø ja̱'i̱. Pɛ di̱ nya̱nsɛ ya, ngue'mø ma̱jua̱ni̱ ngue guehna̱ rá̱ thanhni̱ Oja̱ nu̱na̱ t'ɛ̱mbi̱ ra̱ Cristo. ");
INSERT INTO otnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Yø soldado p'ʉya, xquet'a̱ thenni̱. Bi guat'i ngue bi u̱nna̱ vino xa̱ n'ixi da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bi t'ɛ̱mbʉya: ―Nu̱'mø gue'e rá̱ da̱st'abi'i yø judío, da̱mi̱ nya̱nsɛ ya'mø. ");
INSERT INTO otnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nu̱p'ʉ ja rá̱ ya̱ ra̱ pont'i̱, bi t'ot'a̱ n'na ra̱ letrero ngue ɛ̱na̱: “Nu̱na̱ ra̱ n'yohʉ 'bʉcua, guehna̱ rá̱ da̱st'abi yø judío na̱”. Ra̱ letrero p'ʉya, nt'ot'i conna̱ hya̱ ngue ra̱ griego, ra̱ latín, ra̱ ebreo. ");
INSERT INTO otnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nu̱na̱ n'na ra̱ ts'oc'ɛ̱i̱ ya cuarbʉ ja ra̱ pont'i̱ p'ʉya, xquet'a̱ thenni̱, bi 'yɛ̱mbi̱: ―Nu̱'mø gue'e grá̱ Cristo, da̱mi̱ nya̱nsɛ ya'mø. 'Nɛ̱cä'be gui̱ nya̱n'be p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nu̱'a̱ ma̱n'na nc'ɛ̱i̱ ra̱ ts'oc'ɛ̱i̱ bi 'yɛ̱mbrá̱ amigo di ya̱hni̱: ―Nu̱'i̱ ni̱ xi̱ngui̱ su̱ Oja̱, conque ya guí tu̱p'ʉ ja ra̱ pont'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu̱güi ja te rá̱ngue'a̱ ngue dí säui ra̱ n'ʉ, porque di ju̱tui'a̱ te xtá̱ øt'ui. Ya ni̱ 'yu̱p'ʉ'a̱ te dí thohmi̱. Pɛ nu̱na̱ ra̱ n'yohʉ 'bʉcua, hi̱n tema̱ nts'o xa̱ 'yø'na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bi 'yɛ̱n'a̱ m'mɛfa p'ʉya: ―Ague Jesús, nu̱'mø ra̱ pa gui søhø ngue gui̱ ma̱nda ua, gui̱ mbɛ̱ngui̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ dí xi'i, nu̱ya ya ga̱ m'mʉhmi̱ p'ʉ ma̱hɛ̱ts'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Comma̱ hu̱xyadi, bi̱ mʉdi bi̱ m'mɛxu̱i̱ gä ra̱ xi̱mhäi asta̱ hyu̱ nde. ");
INSERT INTO otnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ra̱ hyadi bi̱ m'mɛxu̱i̱. Nu̱'a̱ ra̱ u̱lu mi̱ zʉp'ʉ ja ra̱ goxthi ni̱ja̱ bi hyehma̱de i ga̱i̱ ngue bi xɛt'i. ");
INSERT INTO otnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Bi 'yɛn'a̱ n'na rá̱ hmafi ra̱ Jesús, bi 'yɛ̱na̱: ―Ague ma̱ Papá'i, da̱di fät'a̱'i̱ ma̱ tegä ya ―bi 'yɛ̱na̱. Høntho bi̱ ma̱n'a̱ p'ʉya, 'bexpi du̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","N'na ra̱ capita ngue ra̱ mmɛ̱ngu̱ Roma bi̱ nu̱ te bi̱ nja, bi 'yɛ̱spa̱bi̱ Oja̱ p'ʉya, bi 'yɛ̱na̱: ―Ma̱jua̱ni̱ ngue nu̱na̱ ra̱ n'yohʉ 'bʉcua, hi̱n'yʉ rá̱ ts'oqui na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gä bi̱ nu̱ yø ja̱'i̱ mi̱ 'bäp'ʉ te bi̱ nja. Bi̱ ma yø ja̱'i̱ p'ʉya, pɛ pʉtyø ti̱ya̱ ngue tu̱ yø mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gätho'ʉ yø mpa̱di̱ui ra̱ Jesús, conyø xisu bá̱ nɛ̱xa̱ Galilea ngue tɛnni̱ ha ni̱ ma, yap'ʉtho bi 'bäi, gä hantho te bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mi̱ 'bʉ'a̱ n'na ra̱ hoga̱ n'yohʉ ni̱ hu̱ ngue ra̱ José, mi̱ øt'e te gä mma̱mp'ʉ ja ra̱ ley, ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ hni̱ni̱ Arimatea ja ra̱ häi Judea. 'Nɛ̱hna̱ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Xquet'a̱ 'nɛ̱hna̱ mi̱ tø'mi̱ ngue di̱ ma̱nda ua Oja̱. Ja̱na̱ngue hi̱ngui̱ 'bʉi ngue ra̱ acuerdo'a̱ te ra̱ hya̱ bi ts'ännbʉ ha bi̱ mpɛti yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nu̱na̱ ra̱ n'yohʉ na̱, bi̱ ma bá̱ nya̱ui ra̱ Pilato, bi 'yäpra̱ nt'ɛ̱di̱ ngue da̱ hya̱jpʉ ja ra̱ pont'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mi̱ hya̱jpʉ ja ra̱ pont'i̱ p'ʉya, bi 'uɛnnba̱bi̱ rá̱ do'yo ra̱ Jesús co n'na ra̱ sábana ngue ra̱ hoga̱ u̱lu. Bi hyaxpʉ ja ra̱ panteón xi̱ ma nt'a'mi̱ p'ʉ bí ja n'na ra̱ 'bido ngue bá̱ ägui. Nu̱na̱ ra̱ panteón, hi̱njongui̱ o. ");
INSERT INTO otnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nde mbɛ̱hi̱'a̱ ra̱ pa'a̱, ya da̱ yʉtra̱ pa ngue ra̱ ts'äya. ");
INSERT INTO otnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nu̱'ʉ yø xisu bá̱ nɛ̱xa̱ Galilea ngue bá̱ n'youi ra̱ Jesús, bi̱ ma bá̱ nu̱ ra̱ n'yägui. Bi̱ nu̱ ha bi t'ägui. ");
INSERT INTO otnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mi̱ zøp'ʉ ja ra̱ ngu̱ ya yø xisu, bi hocyø 'yɛ̱thi̱ ma̱zihotho ga̱ yʉni̱ ngue da̱ goxra̱ ánima. Bi̱ nsäya'a̱ ra̱ pa ngue ra̱ ts'äya p'ʉya, porque gue'a̱ di̱ ma̱nda rá̱ ley Oja̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mi̱ hyaxa̱ ra̱ pa ndomingo, zi xu̱di̱tho bi̱ ma ma̱høn'a̱ yø xisu p'ʉ bí o ra̱ Jesús. Bi hya̱xyø 'yɛ̱thi̱ xi hoqui. Bi̱ mähä mi̱'da yø xisu. ");
INSERT INTO otnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mi̱ zømp'ʉya, bi di̱ni̱ ngue ya n'nanni̱ 'bɛnna̱ do mi̱ nnøpa̱ nju̱'mi̱ ra̱ panteón. ");
INSERT INTO otnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bi yʉt'a̱mbo p'ʉya, pɛ ya hi̱mbi̱ di̱mp'ʉ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bi̱ nsu̱ p'ʉya, hi̱ngui̱ pa̱di̱ te da̱ 'yøt'e. Mi̱ nu̱ p'ʉya, 'bäp'ʉ yoho yø anxɛ di yoxni̱ yø he. ");
INSERT INTO otnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","I hɛ̱mtho häi'ʉ yø xisu ngue ɛ̱mmɛ̱i̱ su̱. Yø anxɛ p'ʉya, bi 'yɛ̱mbi̱: ―¿Hanja ngue guí homhmʉ ua ma̱nt'ägui'a̱ ya 'bʉi? ");
INSERT INTO otnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ya hi̱njo'o ua, ya xa̱ bɛ̱nna̱te. Da̱mi̱ bɛ̱mhmʉ ra̱ hya̱ bi xi'a̱hʉ 'mø tobe ma̱mbi 'bʉta̱ Galilea. ");
INSERT INTO otnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Conque bi̱ ma̱ ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, mi̱ ja ngue da̱ ma ma̱däpi yø ja̱'i̱ ja yø ts'oqui ngue di cuatra̱ pont'i̱. Rá̱ hyu̱ pa p'ʉya, di bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nu̱'ʉ yø xisu p'ʉya, bi zo yø mmʉi na̱ ra̱ hya̱ xi ma̱n'a̱ m'mɛt'o ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nu̱ya yø xisu 'mø ma̱mbá̱ pengbʉ ja ra̱ panteón, nu̱'a̱ te bá̱ nu̱, bi xi'ʉ 'dɛ'ma̱'da nc'ɛ̱i̱ yø xädi ra̱ Jesús. Bi xifi gätho mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nu̱ya yø xisu bi hya̱spa̱bi̱ ra̱ hya̱ ya yø xädi ra̱ Jesús, guehna̱ ra̱ Ma̱ya Magdalena, 'nɛ̱hra̱ Juana, 'nɛ̱hra̱ Ma̱ya rá̱ mamá ra̱ Jacobo, 'nɛ̱ hmi̱'da yø xisu p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pɛ nu̱ya bi tha̱spa̱ ra̱ hya̱ p'ʉya, hi̱ngui̱ ɛ̱c'ɛ̱i̱tho te mma̱nya yø xisu. Sinoque ɛ̱ntho: “Ha̱ntho loco ya yø xisu”, gue ɛmma̱ ɛ̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pɛ ra̱ Bɛdu bi bøn'a̱thi, bi̱ ma n'nahma̱ntho p'ʉ bí ja ra̱ panteón. Mi̱ zømp'ʉya, bi hyɛ̱t'a̱mbo. Bi̱ nu̱ ngue ya n'nanni̱ 'bønna̱ u̱lu ma̱nt'ɛ ra̱ Jesús. Bi̱ mengbʉ ha säya p'ʉya, pɛ di 'yøtho hanja'a̱ te xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, yoho yø xädi ra̱ Jesús ma̱ni̱ map'ʉ ja ra̱ hni̱ni̱ Emaús. Nu̱na̱ ra̱ hni̱ni̱ na̱, di̱ nsocui Jerusalén como 'dɛ'ma̱'da kilómetro. ");
INSERT INTO otnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mɛ̱nte 'yo, mɛ̱nte di c'a̱'a̱ te xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nu̱na̱ ra̱ Jesús mi̱ zä mi̱ zʉdi, ya 'dap'ʉ ni̱ n'yo. ");
INSERT INTO otnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma̱da̱gue'a̱ ngue hɛ̱ti̱, pɛ ɛ̱na̱ te corpa̱tho yø dä ngue hi̱nda̱ ba̱di̱ te'o na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ra̱ Jesús bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Teni̱ 'bɛ'a̱ ma̱ hya̱ ga̱di̱ nxihmi̱ mɛ̱nte guí 'youi ua ja ra̱ 'yu̱ n'yø? Nu̱p'ʉ nná̱ bɛ̱ngä, ɛ̱na̱ gue tu̱ ni̱ mmʉiui. ");
INSERT INTO otnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nu̱na̱ n'na nc'ɛ̱i̱ ni̱ hu̱ ngue ra̱ Cleofas bi 'yɛ̱mbi̱: ―Gätho yø ja̱'i̱ bá̱ 'yo Jerusalén, gä pa̱di̱ te bi̱ nja ma̱ntenni̱ pa. 'Nɛ̱ go gui 'yɛ̱na̱ ngue hi̱ngui̱ pa̱hya. ");
INSERT INTO otnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mp'ʉ ya̱ui: ―¿Tema̱ hya̱ n'yø? Nu̱'ʉ ts'o p'ʉya, bi 'yɛ̱na̱: ―Xigue ra̱ Jesús nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret. Guehna̱ n'na ra̱ n'yohʉ ngue rá̱ pønga̱hya̱ Oja̱, di̱ nɛ̱qui̱ ngue ja rá̱ ts'ɛdi ngue bi 'yøtyø milagro, 'nɛ̱ ja rá̱ ts'ɛdi ngue ra̱ hya̱ bi̱ ma̱. Porque bi̱ nu̱ ma̱nho Oja̱ te bi 'yøt'e, da̱ guehyø ja̱'i̱ bi̱ nu̱ ma̱nho te bi 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Dí̱ mma̱ngä'be ngue nu̱'ʉ yø hmu̱ yø mmäcja̱, da̱ gue'ʉ ma̱ hmu̱hʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱, bi dä ra̱ Jesús. Bi zixpʉ ja ra̱ ts'ʉt'abi, ja bá̱ ts'ännbʉ ngue da̱ du̱p'ʉ ja ra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pɛ nu̱gähe nmi̱ ɛ̱ngähe ngue nu̱na̱ ra̱ n'yohʉ na̱, guehna̱ xta̱ nya̱nyø judío na̱. A nu̱yá, ya ma̱ngʉnde bi̱ nja na̱ ra̱ hya̱ dí xi'a̱'be ya. ");
INSERT INTO otnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nu̱'ʉ 'da yø xisu 'da'igu̱ ma̱ nt'ɛ̱c'ɛ̱i̱he, xa̱ pijthogähe. Porque xa̱ mma mxu̱di̱tho p'ʉ ma̱mbí o ra̱ ánima. ");
INSERT INTO otnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pɛ ya hi̱njonxpa̱ ndi̱ni̱ ngue di op'ʉ. Xpa̱ mmengbʉya, xa̱ xicje ngue xi̱ nu̱ yø anxɛ. A nu̱'ʉ yø anxɛ p'ʉya, i̱ mma̱ ngue ya 'bʉhna̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","'Bexque'a̱ p'ʉya, nu̱'ʉ 'da ma̱ n'yohe xa̱ mmap'ʉ ma̱mbí̱ o ra̱ ánima, pɛ xa̱ ndi̱ni̱ tengu̱tho ra̱ hya̱ xa̱ mma̱nyø xisu. Pɛ ra̱ Jesús ya hi̱nxa̱ hnu̱ na̱ 'na̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nu̱na̱ ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Ua hi̱ngui̱ ts'ʉ di 'yo ni̱ mmʉihʉ'a̱ te ra̱ hya̱ i ja? ¿Ua hi̱nja̱m'mø guí øhmʉ para ngue gui 'yɛ̱c'ɛ̱i̱hʉ'a̱ te gä ra̱ hya̱ bi̱ ma̱nyø pønga̱hya̱ Oja̱? ");
INSERT INTO otnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ua hi̱nguí̱ pa̱hmʉ ngue ra̱ Cristo mi̱ ja ngue da̱ zä ra̱ n'ʉ hante ngue di̱ nda̱st'abi ngue di̱ ma̱nda̱ ua? ");
INSERT INTO otnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ya bi dʉ'mi̱ bi xifi gätho'ʉ yø hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue'a̱ te gui c'a̱ ra̱ Jesús. Bi du̱nnba̱bi̱'a̱ te mma̱mp'ʉ ja yø libro bi 'yotra̱ Moisés. Bi sigue bi xi mi̱'da yø hya̱ te gä nt'ot'i p'ʉ ja yø libro bi 'yotyø pønga̱hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nu̱'mø mi̱ zømp'ʉ ja ra̱ hni̱ni̱ ma̱ni̱ ma p'ʉya, ra̱ Jesús bi 'yøt'e ngue ɛ̱na̱ xø nne da̱ thogui. ");
INSERT INTO otnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pɛ nu̱'ʉ yø n'yohʉ p'ʉya, bi japi ngue di̱ nsäya, bi 'yɛ̱mbi̱: ―Ma 'daua ga̱ nsäyahʉ. Guí̱ nnu̱ ngue ya bi̱ nde. Ya ni̱ ma da̱ dähra̱ nxu̱i̱. Bi yʉt'a̱mbo ra̱ ngu̱ ra̱ Jesús ngue di̱ nsäya. ");
INSERT INTO otnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mi̱ mi̱p'ʉ ja ra̱ mɛ̱xa p'ʉya ngue di̱ nsi̱hmɛ̱. Bi hya̱cra̱ thu̱hmɛ̱, bi ja ma̱mma̱di̱ Oja̱. Bi xɛmp'ʉya, bi u̱n'nʉ hu̱p'ʉ ja ra̱ mɛ̱xa. ");
INSERT INTO otnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi xohyø n'yomfɛ̱ni̱ ngue bi ba̱di̱ te'o. Pɛ 'bexpi̱ m'mɛrpʉtho ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na p'ʉya: ―Pɛ ua̱ngui̱ hu̱rca̱ ma̱ mmʉiui mɛ̱nte da̱rá̱ ya̱hʉ gä ra̱ 'yu̱, 'nɛ̱ bi xicui tema̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro. ");
INSERT INTO otnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ya hi̱nte ma̱mbi̱ dø'mi̱. Bi̱ mengui 'bexque'a̱, i̱ ma Jerusalén. Bi di̱ni̱ ngue ya xi̱ mpɛti'ʉ 'dɛ'ma̱'da yø xädi ra̱ Jesús co 'nɛ̱'ʉ mi̱'da yø n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","A nu̱ya xi̱ mpɛti p'ʉya, bi 'yɛ̱mbya ja bi zøhø: ―Ma̱jua̱ni̱ xa̱ bɛ̱nna̱te ra̱ Hmu̱ n'yø. Ya xa̱ nnu̱ ra̱ Bɛdu. ");
INSERT INTO otnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A nu̱ya ja bi zø p'ʉya, xquet'a̱ bi̱ ma̱ te xi thop'ʉ ja ra̱ 'yu̱. Bi̱ ma̱ ngue hi̱ngui̱ pa̱di̱ te'o na̱ ra̱ Jesús mɛ̱nte ya̱ui, bi ba̱di̱, ja gue'mø mi̱ xɛnna̱ thu̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mɛ̱nte tobe di ya̱hni̱tho'ʉ yo nc'ɛ̱i̱, ngue mma̱ te xi̱ nu̱, mi̱ da̱mbɛni̱ p'ʉya, ya 'bäp'ʉ ma̱de ra̱ Jesús. Bi zɛngua p'ʉya, bi 'yɛ̱mbi̱: ―Da̱ hyu̱ ni̱ mmʉihʉ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","A nu̱'ʉ yø xädi p'ʉya, di fɛtyø mmʉi ngue su̱. I ɛ̱na̱ ngue ra̱ 'yø'a̱ hɛ̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Hanja ngue guí su̱hʉ? ¿Hanja ngue guí ɛ̱mhmʉ ngue hi̱mma̱ jua̱ni̱ dí 'bʉcä ua? ");
INSERT INTO otnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Da̱mi̱ nu̱rca̱hʉ ma̱ 'yɛ 'nɛ̱hma̱ gua. Gui̱ nnu̱hʉ ngue xquecthocä. Da̱mi̱ thänjʉ n'namhma̱ guí̱ nnu̱hʉ ngue guecä. A nu̱'a̱ ra̱ 'yø, ra̱ nda̱hi̱tho'a̱, hi̱n'yʉ rá̱ do'yo'a̱. Pɛ nu̱gä guí̱ nnu̱hʉ ngue drá̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mi̱ juadi bi xi'a̱ ngu̱'a̱ p'ʉya, bi 'yu̱tyø 'yɛ 'nɛ̱hyø gua ha bi̱ mɛ yø clavo. ");
INSERT INTO otnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pɛ nu̱'ʉ yø xädi hi̱nga̱ ɛ'ɛ̱c'ɛ̱i̱ xa̱nho, ngue'a̱ gui johya 'nɛ̱ ɛ̱na̱ su̱dyø n'yomfɛ̱ni̱. Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Ua hi̱ngui̱ ts'ʉ ua te ga̱ sigä ts'ʉ? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bi u̱nna̱ n'na xɛqui ra̱ hua̱ ngue ntha̱xi̱ p'ʉya, 'nɛ̱ bi u̱nna̱ n'na mhmɛ̱ ra̱ t'afi t'asa. ");
INSERT INTO otnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bi hya̱mp'ʉya, yø hmi̱ yø dä yø xädi p'ʉ ha bi zi. ");
INSERT INTO otnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bi 'yɛ̱mbʉya: ―Nu̱na̱ te dá̱ thocä ya, guehna̱ ra̱ hya̱ ya xtá̱ xi'a̱hʉ m'mɛt'o na̱. Ya xtá̱ xi'a̱hʉ ngue mi̱ jatho di̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro. Porque ra̱ Moisés co 'nɛ̱'ʉ mi̱'da yø pønga̱hya̱ Oja̱, bi 'yot'a̱ te ja ngue ga̱ thocä, xquet'a̱ ngu̱'a̱ mma̱mp'ʉ ja yø Salmo. ");
INSERT INTO otnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bi xojpa̱ yø n'yomfɛ̱ni̱ p'ʉya, ngue da̱ di̱ni̱ te mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro. ");
INSERT INTO otnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bi 'yɛ̱mbʉya: ―Ya ngu̱'a̱ nt'ot'i ngue ra̱ Cristo i ja ngue da̱ tho. Rá̱ hyu̱ pa p'ʉya, di bɛ̱nna̱te p'ʉ da̱ nt'ägui. ");
INSERT INTO otnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Guehna̱ ra̱ hya̱ da̱ tha̱spa̱bi̱ yø ja̱'i̱ 'bʉi ndap'ʉ bi zä yø nación, conná̱ nt'ɛ̱di̱ ra̱ Jesús, nu̱ to da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo, di pu̱nnba̱bi̱ yø ts'oqui. Pɛ rá̱ mʉditho da̱ ma̱nna̱ hya̱ p'ʉ Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nu̱yá, go gui xihmʉ yø ja̱'i̱ na̱ te gá̱ nu̱hʉ dá̱ thocä ya. ");
INSERT INTO otnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nu̱na̱ ra̱ hya̱ bi ya̱t'a̱hʉ ma̱ Papágä, ga̱ ma pɛnhnä na̱ya. Pɛ 'yogui 'uehmʉ ua ja ra̱ hni̱ni̱ Jerusalén asta̱ gue'mø bi̱ n'na'a̱hʉ ra̱ ts'ɛdi di 'yɛ̱ ma̱hɛ̱ts'i̱, ya gui̱ mmähä p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bi gʉjpʉ mi̱ 'bʉhyø xädi ra̱ Jesús, i̱ map'ʉ jonna̱ hni̱ni̱ Betania. Bi̱ macyø 'yɛ p'ʉya ngue di ja̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mɛ̱nte di ja̱pʉya, hɛ̱tho ha i̱ nangui̱, bi̱ ma ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mi̱ juadi bi da̱nne'ʉ yø xädi, bi̱ mengui̱, i̱ ma Jerusalén. Ja̱njua̱ni̱ ngue di johya. ");
INSERT INTO otnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","N'na pa ngu̱ n'na pa, i pa ni̱ja̱ ngue ba̱di̱ ja ma̱mma̱di̱ Oja̱.");
INSERT INTO otnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nu̱na̱ rá̱ Ts'ʉnt'ʉ Oja̱ guehna̱ øt'e ngue fa̱di̱ hanja Oja̱ na̱. Ya mi̱ 'bʉ'mø mi̱ nhohra̱ xi̱mhäi. 'Dap'ʉ 'bʉhmi̱ Oja̱, pɛ 'nɛ̱hna̱ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hante ngue di̱ nhohra̱ xi̱mhäi, ya rá̱ n'youi Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Go bi hoqui gätho yø cosa ja na̱, tengu̱tho bá̱ ne Oja̱ ngue bi̱ nja. Nu̱ hangu̱ yø cosa ja ya, hi̱n'yʉ n'na ra̱ cosa ngue hi̱nxti hoqui. ");
INSERT INTO otnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nu̱na̱ go bá̱di̱ u̱nna̱ 'da'yo te na̱. Guehna̱ xojpa̱ yø mmʉi yø ja̱'i̱ ngue da̱ ba̱di̱ ndana̱ ma̱jua̱ni̱. Nu̱na̱ bá̱di̱ u̱nna̱ 'da'yo te, tengu̱tho n'na ra̱ nyot'i ngue xojpa̱ yø mmʉi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nu̱ ra̱ nyot'i di yorbʉ ja ra̱ 'bɛxu̱i̱, pɛ hi̱ngui̱ hätra̱ 'bɛxu̱i̱ di 'bɛrpa̱bi̱'a̱ gui yot'i. ");
INSERT INTO otnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nu̱na̱ Oja̱, bi̱ mɛnhna̱ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bi̱ mɛnhni̱ ngue da̱ xihyø ja̱'i̱ te'o na̱ da̱ xojpa̱ yø mmʉi yø ja̱'i̱. I̱ nnepe ngue guehna̱ da̱ 'yɛ̱c'ɛ̱i̱ gätho yø ja̱'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nu̱na̱ ra̱ Xuua, hi̱nga̱ guehna̱ ja ngue da̱ xojpa̱ yø mmʉi yø ja̱'i̱ na̱. Sinoque bi 'bɛnhni̱ ngue da̱ xihyø ja̱'i̱ ndana̱ da̱ xojpa̱ yø mmʉi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nu̱na̱ bi zøcua ja ra̱ xi̱mhäi, guehna̱ ma̱jua̱ni̱ ngue xojpa̱ yø mmʉi gätho yø ja̱'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nu̱na̱ rá̱ Ts'ʉnt'ʉ Oja̱ bi̱ m'mʉcua ja ra̱ xi̱mhäi. Ma̱da̱gue'a̱ ngue go bi hocra̱ xi̱mhäi na̱, pɛ hi̱mbi̱ ba̱hyø ja̱'i̱ te'o na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bi̱ m'mʉp'ʉ ja rá̱ häi, pɛ hi̱mbi̱ nu̱ ma̱nho yø mmɛ̱ngu̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pɛ nu̱ya to gä bi nu̱ ma̱nho, 'nɛ̱ bi 'yɛ̱c'ɛ̱i̱ ngue guehna̱ ra̱ Ya̱nte na̱, guehya bi u̱nna̱ nt'ɛ̱di̱ bi gohi ngue yø ba̱si̱ Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nu̱'a̱ i gohi ngue yø ba̱si̱ Oja̱ yø ja̱'i̱, hi̱mma̱ 'da'yo 'bʉi tengu̱tho ga̱ 'bʉhyø ba̱si̱ yø ja̱'i̱, ogue dra̱ ja̱'i̱tho xta̱ nnepe ngue bi̱ njap'ʉ. Sinoque guesɛ Oja̱ bi̱ ne bi 'yøt'e ngue yø ba̱si̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nu̱na̱ øt'e ngue fa̱di̱ hanja Oja̱ ya, bi̱ nja̱'i̱ na̱. Bi̱ m'mʉcua dí 'bʉhmʉ. Pɛ dá̱ nu̱he ngue ma̱guesɛ. Ma̱guesɛ porque rá̱ 'dants'ʉnt'ʉ Oja̱. Gä ma̱jua̱ni̱ te bi̱ ma̱, 'nɛ̱ hi̱nha rá̱ nzɛgui di̱ ma̱hyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nu̱na̱ ra̱ Xuua, bi xihyø ja̱'i̱ te'o na̱, bi 'yɛ̱mbi̱: ―Nu̱na̱ ya, guehna̱ nmi̱ mma̱ngä m'mɛt'o na̱ya. Porque ya xtá̱ ma̱ngä ngue dí ɛ̱na̱: “Nu̱na̱ da̱ ɛ̱p'ʉ m'mɛfa, ma̱n'na ta̱te na̱ ngue nu̱gä, porque hante ngue ga̱ m'mʉcä, ya mi̱ 'bʉhna̱”. ");
INSERT INTO otnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nu̱'a̱ te gä ba̱di̱ u̱ni̱, gä di tocaga̱hʉ. Ba̱di̱ thi̱jpa̱tho rá̱ ma̱te ba̱di̱ u̱ni̱ hi̱nha rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Conná̱ nguehra̱ Moisés bi fa̱hrá̱ ley Oja̱. Pɛ conná̱ nguehra̱ Jesucristo bi fa̱hrá̱ ma̱te Oja̱, 'nɛ̱ bi fa̱hna̱ ra̱ hya̱ ma̱jua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nu̱na̱ Oja̱ hi̱nja̱m'mø to di̱ nnu̱ na̱. Hønt'a̱ rá̱ 'dants'ʉnt'ʉ Oja̱ bí 'bʉp'ʉ bí 'bʉhrá̱ Papá, go bi̱ ma̱ hanja Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nu̱'ʉ yø judío 'bɛt'o p'ʉ Jerusalén bi̱ mɛnhyø mmäcja̱ bi̱ mɛ yø n'yohʉ ja yø 'bɛfi p'ʉ ja ra̱ ni̱ja̱. Bi̱ map'ʉ 'bʉhra̱ Xuua ngue bá̱ änni̱ te'o. ");
INSERT INTO otnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ra̱ Xuua p'ʉya, njua̱ntho bi̱ ma̱, bi 'yɛ̱na̱: ―Hi̱nga̱ guecä na̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma̱hømbi̱ 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Pɛ te'o'i p'ʉya? ¿Ua gue gue'e na̱ ra̱ pønga̱hya̱ Elías? Mi̱ da̱hra̱ Xuua p'ʉya, bi 'yɛ̱mbi̱: ―Hi̱nga̱ guecä. Bi 'yänni̱ ma̱høn'a̱ p'ʉya, bi 'yɛ̱mbi̱: ―Masque gue'e na̱ ra̱ pønga̱hya̱ ja ngue da̱ ɛ̱cua 'mø ―bi 'yɛ̱mbi̱. Bi 'yɛ̱na̱ ma̱høn'a̱ p'ʉya: ―Hi̱n'na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bi t'ɛ̱mbʉya: ―Pɛ ¿te'o'i p'ʉya? Da̱mi̱ xicje n'namhma̱ ga̱ ha̱spa̱he ra̱ hya̱'ʉ to xpa̱ mɛnnga̱he. Da̱mi̱ ma̱ te'o'i. ");
INSERT INTO otnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mi̱ da̱hra̱ Xuua, bi 'yɛ̱na̱: ―Go guecä na̱ bi̱ mma̱nna̱ pønga̱hya̱ Isaías ngue bi 'yɛ̱na̱: “Di̱ m'mʉ'a̱ n'na nc'ɛ̱i̱ ngue nts'ɛdi di̱ ma̱nna̱ hya̱ p'ʉ ja ra̱ da̱po. Da̱ 'yɛ̱na̱: Da̱mi̱ nsähʉ ya, porque ya ni̱ ma da̱ ɛ̱p'ʉ ra̱ Hmu̱”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nu̱ya yø n'yohʉ bi̱ ma bá̱ nya̱ui ra̱ Xuua, guehya yø m'mɛnhni̱ yø fariseo ya. ");
INSERT INTO otnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ma̱hømbi̱ 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Pɛ hanja ngue guí øtra̱ nxixya̱ 'mø ngue hi̱nga̱ gue'e na̱ ra̱ Cristo, ni̱ xi̱ngrá̱ Elías, ni̱ xi̱ngrá̱ pønga̱hya̱ dí xi'i? ");
INSERT INTO otnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mi̱ da̱hra̱ Xuua, bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱gä dí øtra̱ nxixya̱ conna̱ dehe. Pɛ nu̱ua dí 'bʉhmʉ, 'yo ua n'na nc'ɛ̱i̱ ngue hi̱ngui̱ fa̱di̱ te'o. ");
INSERT INTO otnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nu̱gä dá̱ 'bɛt'o, pɛ nu̱na̱ dí xi'a̱hʉ da̱ ɛ̱p'ʉ m'mɛfa na̱. Ma̱n'na ta̱te na̱ ngue nu̱gä. ¿Hapʉ gue ga̱ sʉcä tengu̱ na̱? ");
INSERT INTO otnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gä guehya yø hya̱ ja ua bi̱ ma̱nna̱ Xuua p'ʉ ja ra̱ hni̱ni̱ Betábara, ma̱n'na nguadi ra̱ da̱the Jordán ma̱mbi̱ øtra̱ nxixya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mi̱ hyaxpʉya, bi̱ nu̱ ra̱ Xuua ngue mmap'ʉ ra̱ Jesús da̱ zømp'ʉ ha 'bäi. Bi xihyø ja̱'i̱ p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ n'yohʉ bá̱ ɛ̱cua ya, guehna̱ da̱ hnøpa̱ 'bøt'e na̱ya. Tengu̱tho ra̱ dɛ'yo thop'ʉ ja ra̱ ni̱ja̱ ngue pa m'møt'e, di̱ njarbʉ na̱. Porque guehna̱ bá̱ pɛn'Oja̱ na̱, ngue di hojpa̱ yø ts'oqui yø ja̱'i̱ 'bʉi gä rá̱ ngʉni̱ nxi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Guehna̱ dá̱ mma̱ngä 'mø dí xi'a̱hʉ na̱ya ngue dí ɛ̱na̱: “Nu̱gä dá̱ 'bɛt'o, pɛ bá̱ ɛ̱p'ʉ ma̱n'na ra̱ n'yohʉ ta̱te ngue nu̱gä. Porque hante ngue ga̱ m'mʉcä, ya mi̱ 'bʉhna̱”. ");
INSERT INTO otnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nu̱gä xquet'a̱ hi̱nmi̱ pa̱cä te'o na̱ t'ɛ̱mbi̱ ra̱ Cristo, pɛ bá̱ 'bɛnngui̱ ngue ga̱ xixya̱bi̱ yø ja̱'i̱, 'nɛ̱ ga̱ japi gätho yø judío ngue da̱ ba̱di̱ te'o na̱ ra̱ Cristo. ");
INSERT INTO otnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma̱hømbi̱ 'yɛ̱nna̱ Xuua: ―Dá̱ nu̱gä ra̱ Espíritu Santo bí 'yɛ̱ ma̱hɛ̱ts'i̱ tengu̱tho n'na ra̱ paloma ngue bi zøp'ʉ 'bähra̱ Jesús ngue di̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nu̱gä tobe hi̱nmi̱ pa̱cä te'o na̱ ra̱ Cristo, pɛ nu̱'mø ma̱mbá̱ 'bɛnngui̱ ngue ga̱ xixya̱bi̱ yø ja̱'i̱ conna̱ dehe, Oja̱ bi 'yɛ̱ngui̱: “Nu̱na̱ ra̱ n'yohʉ gui̱ nnu̱rpi̱ ngue da̱ zøhra̱ Espíritu Santo p'ʉ ja rá̱ ya̱, guehna̱ da̱ japyø ja̱'i̱ ngue di ha̱tra̱ ts'ɛdi ra̱ Espíritu Santo na̱”, bi 'yɛ̱ngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngu̱na̱ dá̱ nu̱gä ya, ja̱na̱ngue da̱di jagä ma̱jua̱ni̱ ngue guehna̱ rá̱ Ts'ʉnt'ʉ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mi̱ hyaxpʉya, ma̱høn'a̱ 'bʉp'ʉ ra̱ Xuua n'youi yoho yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nu̱'mø mi̱ nu̱ ngue bi thop'ʉ ra̱ Jesús, ra̱ Xuua bi 'yɛ̱na̱: ―Nu̱na̱ bá̱ ɛ̱cua ya, guehna̱ bá̱ pɛn'Oja̱ ngue da̱ nøpa̱ 'bøt'e yø ja̱'i̱ na̱, tengu̱tho ra̱ dɛ'yo thop'ʉ ja ra̱ ni̱ja̱ ngue pa m'møt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Xuua, mi̱ zä mi̱ 'yø'ʉ yoho yø xädi, bi dɛnna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ra̱ Jesús bi̱ nyɛ̱gui̱, bi̱ nu̱ ngue ni̱ thɛnni̱. Bi 'yɛ̱mbya ni̱ dɛnni̱: ―¿Te guí hommi̱ ya? Nu̱'ʉ ni̱ dɛnni̱ bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ¿hapʉ guí säya? ");
INSERT INTO otnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma ga̱ mmähä, ga̱ u̱t'a̱ui. Bi̱ mɛ p'ʉya, bi 'yu̱ti̱ hapʉ säya. Nu̱'a̱ ra̱ ora'a̱, ya mmap'ʉ 'dɛt'a xu̱di̱. Pɛ ja bá̱ thɛ'i̱nde p'ʉ bi zøni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nu̱na̱ n'na nc'ɛ̱i̱ bi 'yøde te mma̱nna̱ Xuua, bi dɛnna̱ Jesús, guehna̱ ra̱ Andre rá̱ n'yohʉ ra̱ Bɛdu na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nu̱na̱ ra̱ Andre 'bexpi̱ ma bá̱ honná̱ n'yohʉ Bɛdu. Bi 'yɛ̱mbi̱: ―Dá̱ ti̱ngä'be ra̱ Mesías ―bi 'yɛ̱mbi̱. Nu̱na̱ ra̱ Mesías i̱ nne da̱ ma̱ ngue guehna̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi. ");
INSERT INTO otnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nu̱na̱ ra̱ Andre p'ʉya, bi zixrá̱ n'yohʉ p'ʉ 'bʉhra̱ Jesús. Pɛ mi̱ nu̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Gue'e grá̱ Simu̱, rá̱ ts'ʉnt'ʉ'i ra̱ Jonás. Nu̱ya gdi hu̱ ngue grá̱ Cefas, 'nɛ̱ gdi Bɛdu ya. ");
INSERT INTO otnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mi̱ hyaxpʉya, bi̱ map'ʉ ja ra̱ häi Galilea ra̱ Jesús. Hante ngue da̱ ma, bi̱ nthɛui ra̱ Lipe, bi 'yɛ̱mbi̱: ―Ma ga̱ mmɛp'ʉ ga̱ mmagä ague Lipe. ");
INSERT INTO otnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nu̱na̱ ra̱ Lipe, ra̱ mmɛ̱ngu̱ p'ʉ ja ra̱ hni̱ni̱ Betsaida. Xquet'a̱ ra̱ mmɛ̱ngu̱ p'ʉ na̱ ra̱ Andre 'nɛ̱hra̱ Bɛdu. ");
INSERT INTO otnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nu̱na̱ ra̱ Lipe bi̱ ma bá̱ honna̱ Natanael. Bi 'yɛ̱mbi̱: ―Dá̱ ti̱ngä'be na̱ ra̱ n'yohʉ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro bi 'yotra̱ Moisés da̱ gue'ʉ mi̱'da yø pønga̱hya̱. Guehna̱ rá̱ ts'ʉnt'ʉ ra̱ José, nu̱na̱ ra̱ Jesús ra̱ mmɛ̱ngu̱ Nazaret. ");
INSERT INTO otnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mi̱ da̱hra̱ Natanael, bi 'yɛ̱na̱: ―Xip'ʉ Nazaret, ¿ua da̱ zä da̱ pømp'ʉ n'na nc'ɛ̱i̱ ngue xta̱nho? Bi 'yɛ̱nna̱ Lipe p'ʉya: ―Gue mmɛxa̱ gui̱ nnu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mi̱ nu̱ ra̱ Jesús ngue mmap'ʉ ra̱ Natanael da̱ guarbʉ 'bʉi, bi 'yɛ̱mbʉya: ―Ya guí̱ nnu̱hʉ ya, bá̱ ɛ̱cua n'na ra̱ judío ngue ma̱jua̱ni̱ xa̱nho te ga̱ 'yo, 'nɛ̱ hi̱ngra̱ fɛhni̱tho. ");
INSERT INTO otnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ra̱ Natanael bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Hague go gni̱ pa̱qui̱? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Conque nu̱'mø tobe hi̱mma̱ni̱ zo'i̱ ra̱ Lipe ya, dí̱ nnu̱'i̱ 'mø guí 'bʉp'ʉ 'bähra̱ za ngue ra̱ igo. ");
INSERT INTO otnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Bi 'yɛ̱nna̱ Natanael: ―Ague grá̱ xännba̱te, gue'e rá̱ Ts'ʉnt'ʉ'i Oja̱. Gue'e rá̱ da̱st'abi'i yø judío. ");
INSERT INTO otnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Hønt'a̱ guí 'yɛ̱c'ɛ̱i̱gui̱'a̱ ya, ngue dí xi'i ngue dí̱ nnu̱'i̱ 'mø guí 'bʉp'ʉ 'bähra̱ igo ya. A nu̱yá, ma̱n'na xa̱nhɛ̱nni̱ yø cosa gui̱ nnu̱ ya, para ngue ma̱n'na gdi pa̱di̱ xa̱nho te'ogä. ");
INSERT INTO otnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma̱hømbi̱ 'yɛ̱nna̱ Jesús: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, guí̱ nnu̱hʉ ngue da̱ xohra̱ c'ama̱hɛ̱ts'i̱ ya. Yø anxɛ Oja̱ p'ʉya, ni̱ ma ni̱ 'yɛ̱p'ʉ 'bähra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rá̱ hyu̱ pa p'ʉya, bi̱ nja n'na ra̱ ntha̱ti̱ p'ʉ ja ra̱ hni̱ni̱ Caná ngue ra̱ häi Galilea. Xquet'a̱ bi̱ m'mʉp'ʉ ja ra̱ ntha̱ti̱ rá̱ mamá ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Xquet'a̱ bi̱ ma ma̱mbita ra̱ Jesús conyø xädi, ngue bi̱ map'ʉ ha bi̱ nja ra̱ ntha̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mi̱ guahra̱ vino p'ʉya, bi 'yɛ̱mbrá̱ mamá ra̱ Jesús: ―Bi guahra̱ vino ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ra̱ Jesús bi 'yɛ̱na̱: ―Ague mamá, ¿hanja ngue go guí xic'a̱ ya? Porque tobe hi̱ngui̱ sønna̱ ora ngue tema̱ hmɛ̱ya ga̱ øt'ä. ");
INSERT INTO otnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pɛ rá̱ mamá ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱ nu̱'ʉ 'ui̱te: ―Da̱mi̱ 'yøt'e te gä da̱ xi'a̱hʉ nʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mi̱ jap'ʉ 'dato yø mamohi ngue yø do. Gue'ʉ di usa yø judío'ʉ ngue po ra̱ dehe ga̱ nxʉ'yɛ yø ja̱'i̱. N'na ngu̱ n'na'ʉ p'ʉya häti goho 'däte ogue n'na ciento litro ra̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ra̱ Jesús bi 'yɛ̱mbyø 'ui̱te: ―Da̱mi̱ 'yu̱shʉ ra̱ dehe ya yø mamohi ja ua ―bi 'yɛ̱mbi̱. Bi yu̱spʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ra̱ Jesús bi 'yɛ̱mbi̱ ma̱høn'a̱: ―A nu̱yá, hya̱spa̱ui zits'ʉ ra̱ mmɛ̱nni̱gu̱ ya, ngue da̱ zä. Bi hya̱spa̱bi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ra̱ mmɛ̱nni̱gu̱ p'ʉya, bi zä ra̱ dehe ya xi gohi ngue ra̱ vino. Pɛ hi̱ngui̱ pa̱di̱ ha bá̱ tha̱ ra̱ vino. Nu̱'ʉ to bá̱ ha̱ ra̱ dehe go pa̱di̱ hanja'ʉ. Ra̱ mmɛ̱nni̱gu̱ p'ʉya bi zonhna̱ novio. ");
INSERT INTO otnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Bi 'yɛ̱mbi̱: ―Gätho yø ja̱'i̱, rá̱ mʉditho di u̱n'a̱ ra̱ vino xa̱nho. Pɛ nu̱'ʉ to si ra̱ vino 'mø ya bi zi xa̱ngu̱, ya di u̱n'na̱ ra̱ vino hi̱nga̱ njua̱ni̱ p'ʉya. Pɛ nu̱'i̱, ma̱n'na gue go xcá̱ pɛstho ra̱ hoga̱ vino ngue rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nu̱na̱ ya guehna̱ rá̱ mʉdi ra̱ milagro bá̱ ørbʉ ja ra̱ hni̱ni̱ Caná ngue ra̱ häi Galilea ra̱ Jesús. Ja bi̱ nɛ̱qui̱ p'ʉ ngue ma̱guesɛ ra̱ Jesús. Nu̱'ʉ yø xädi p'ʉya, ma̱n'na bi 'yɛ̱c'ɛ̱i̱ ngue guehna̱ ra̱ Cristo na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","M'mɛfa p'ʉya, bi̱ map'ʉ ja ra̱ hni̱ni̱ Capernaum, ni̱ n'youi rá̱ mamá, co 'nɛ̱hyø n'yohʉ, conyø xädi. Ja bá̱ m'mʉp'ʉ njammi̱ pa p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ya xma̱nguerpʉtho di̱ nsänni̱go yø judío ngue ra̱ pascua. Ra̱ Jesús bi̱ ma Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nu̱p'ʉ thi̱nni̱ja̱ p'ʉya, bi di̱mp'ʉ'ʉ mi̱ pä yø nda̱ni̱ 'nɛ̱hyø dɛ'yo, 'nɛ̱hyø paloma. Hu̱p'ʉ ja yø nthu̱ts'i̱'ʉ di pøspa̱ yø mɛ̱nyu̱ yø ja̱'i̱ yap'ʉ ni̱ 'yɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mi̱ nu̱ te jap'ʉ, bi fʉt'a̱ n'na ra̱ ntha̱hi̱ ra̱ Jesús ngue bi hyøn'a̱thi gätho'ʉ mi̱ mpä p'ʉ thi̱nni̱ja̱. 'Da i̱ mɛ yø dɛ'yo 'nɛ̱hyø nda̱ni̱. Nu̱'ʉ ma̱di pähyø mɛ̱nyu̱ p'ʉya, bi c'uaspa̱bi̱ yø mɛ̱nyu̱, bi 'yennba̱ yø mɛ̱xa. ");
INSERT INTO otnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nu̱'ʉ yø mäpaloma p'ʉya, bi 'yɛ̱mbi̱: ―Da̱mi̱ jʉcui ya te ja ua. 'Yo gui̱ nnøpa̱ täihʉ ua ja rá̱ ngu̱ ma̱ Papágä. ");
INSERT INTO otnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nu̱'ʉ yø xädi p'ʉya, bi zo yø mmʉi'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Ma̱ ga̱ 'bɛcä ma̱ te ngue dí̱ nnu̱ ma̱nsu̱gä ni̱ ngu̱”. ");
INSERT INTO otnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nu̱'ʉ yø hmu̱ yø judío p'ʉya, bi 'yørpa̱ ra̱ nt'änni̱, bi 'yɛ̱mbi̱: ―¿Tema̱ milagro gui 'yu̱rca̱he n'namhma̱ ga̱ pa̱cähe ngue'mø ma̱jua̱ni̱ Oja̱ di 'da'i ra̱ nt'ɛ̱di̱'a̱ te guí øt'e? ");
INSERT INTO otnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Da̱mi̱ hyømhmʉ häi ra̱ ni̱ja̱ ja ua, 'nɛ̱ nhyu̱ patho gda̱ høcä ma̱høn'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nu̱'ʉ yø hmu̱ yø judío p'ʉya, bi 'yɛ̱mbi̱: ―Nyote ma̱'dato njɛya i̱ nangra̱ ni̱ja̱ ja ua, 'nɛ̱ go gui 'yɛ̱na̱ ngue nhyu̱ patho gdi hoqui ma̱høn'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pɛ nu̱'a̱ ra̱ ni̱ja̱ bi̱ ma̱nna̱ ra̱ Jesús, gue'a̱ rá̱ do'yo bi̱ ma̱ ngue da̱ thømmi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ja̱na̱ngue nu̱'mø mi̱ bɛ̱nna̱te p'ʉ bi̱ ma nt'ägui ra̱ Jesús, bi zo yø mmʉi yø xädi'a̱ te xi xifi. Bi ba̱di̱ ngue ma̱jua̱ni̱ na̱ ra̱ hya̱ mma̱nna̱ Ma̱ca̱ Libro p'ʉya, 'nɛ̱'a̱ te xi̱ ma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nu̱na̱ ra̱ Jesús ya 'bʉp'ʉ Jerusalén gä i̱ nja ra̱ ngo ngue ra̱ pascua. Xa̱ngu̱ yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱ ngue guehna̱ ra̱ Cristo na̱, porque nnu̱ yø ja̱'i̱ ngue hi̱njonda̱ zä da̱ 'yøtyø milagro øtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pɛ nu̱na̱ ra̱ Jesús hi̱ndi̱ u̱nna̱ mmʉi ya yø ja̱'i̱ ya, porque gä pa̱tho te mbɛ̱nyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hi̱mma̱ hyoni̱ to da̱ xifi te ja rá̱ n'yomfɛ̱ni̱ ra̱ ja̱'i̱, porque pa̱sɛ te ja rá̱ n'yomfɛ̱ni̱ n'na ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bi̱ m'mʉ'a̱ n'na ra̱ n'yohʉ ngue ra̱ fariseo ni̱ hu̱ ngue ra̱ Nicodemo. Guehna̱ n'na rá̱ hmu̱ yø judío na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bi̱ ma n'na xu̱i̱ na̱ ra̱ Nicodemo bá̱ nya̱ui ra̱ Jesús. Bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, dí pa̱cähe ngue bá̱ pɛn'na̱'i̱ Oja̱ ngue gui̱ nxännga̱he. Porque hi̱njonda̱ zä da̱ 'yøtyø milagro guí øt'e ngue'mø hi̱ngui̱ n'youi Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ dí xi'i, ngue ra̱ ja̱'i̱ hi̱mma̱ 'da'yo di̱ m'mʉi, hi̱nda̱ zä da̱ zo rá̱ 'yɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ra̱ Nicodemo bi 'yänni̱ ha rá̱nja ra̱ hya̱, bi 'yɛ̱mbi̱: ―Pɛ xina ra̱ hya̱ guí̱ mma̱, ¿ha di̱ njapi? ¿Ua da̱ zä ngue ma̱'da'yo høndi̱ m'mʉ'a̱ n'na ra̱ da̱ja̱'i̱? ¿Ua da̱ zä hønda̱ yʉrbʉ ja rá̱ mmʉi rá̱ mamá ngue ma̱'da'yo da̱ mi̱? ");
INSERT INTO otnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ dí xi'i, jatho ngue da̱ ma ma̱xixya̱bi̱ ra̱ ja̱'i̱ conna̱ dehe 'nɛ̱hra̱ Espíritu Santo di u̱nna̱ 'da'yo te, ja̱na̱ngue da̱ zo rá̱ 'yɛ Oja̱ ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nu̱mø ja bi̱ mi̱hra̱ ba̱si̱ ra̱ ja̱'i̱tho rá̱ papá, xquetho ngue ra̱ ja̱'i̱tho ra̱ ba̱si̱. Pɛ para ngue ma̱'da'yo di̱ m'mʉhra̱ ja̱'i̱, høndra̱ Espíritu Santo da̱ zä da̱ 'yøt'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'Yo ga̱di 'yøtho na̱ ra̱ hya̱ dí xi'i. Gätho yø ja̱'i̱ ja ngue ma̱'da'yo di̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Guí pa̱di̱ ngue ndap'ʉ bi zä 'yo ra̱ nda̱hi̱, nu̱p'ʉ go nne di̱ ma. Guí øde ngue di hi̱, pɛ hi̱nguí̱ pa̱di̱ ha ni̱ 'yɛ̱hɛ̱, ni̱ xi̱nguí̱ pa̱di̱ ha ni̱ ma. Njarbʉtho na̱ ra̱ Espíritu Santo di u̱nna̱ 'da'yo te ra̱ ja̱'i̱ ya, hi̱ndi̱ nɛ̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mi̱ da̱hra̱ Nicodemo, bi 'yɛ̱mbi̱: ―Hi̱ndí̱ pa̱cä hanja na̱ ra̱ hya̱ guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Go grá̱ xännba̱te p'ʉ 'bʉhyø judío, 'nɛ̱ hi̱nguí̱ pa̱hna̱ ra̱ hya̱ dí xi'i ya. ");
INSERT INTO otnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ma̱jua̱ni̱ dí xi'i, dí̱ mma̱ngähe'a̱ te dí pa̱hme. Nu̱na̱ te dí̱ nnu̱he, guehna̱ da̱di jahe ma̱jua̱ni̱ na̱. Pɛ hi̱nguí̱ ɛ̱c'ɛ̱i̱hʉ te dí̱ mma̱ngähe. ");
INSERT INTO otnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Xi'mø ngue dí̱ mma̱ngä ya yø hya̱ ja ngue di̱ nja ua ja ra̱ xi̱mhäi, 'nɛ̱ hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ, ¿goma̱ gue'mø ga̱ xi'a̱hʉ'a̱ te bí ja ma̱hɛ̱ts'i̱ gui 'yɛ̱c'ɛ̱i̱ga̱hʉ? ");
INSERT INTO otnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hi̱njon xpa̱ mmengbʉ ma̱hɛ̱ts'i̱, hi̱nda̱ høndra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ da̱ zä da̱ ma̱ te bí jap'ʉ, porque ja rá̱ ngu̱mp'ʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nu̱p'ʉ ja ra̱ da̱po, ra̱ Moisés bi hoca̱ n'na ra̱ c'ɛ̱ya̱ ngue ra̱ t'ɛgui, bi 'bä'ma̱ n'na ra̱ za bi 'yɛ̱ts'i̱. Di̱ njarbʉtho ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ya, i ja ngue da̱ ma ma̱'bä'mi̱ ra̱ pont'i̱ di̱ ncuat'i. ");
INSERT INTO otnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ja da̱ thop'ʉ, n'namhma̱ ngue nu̱ te'o gätho da̱ 'yɛ̱c'ɛ̱i̱, hi̱ndi̱ m'mɛdi, sinoque di̱ nja ra̱ 'da'yo te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ja̱njua̱ni̱ ngue di̱ ma̱ Oja̱ yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi. Ja̱na̱ngue bá̱ pɛnhua rá̱ 'dants'ʉnt'ʉ ngue da̱ du̱, n'namhma̱ ngue nu̱ to gä da̱ 'yɛ̱c'ɛ̱i̱ na̱, hi̱ndi̱ m'mɛdi, sinoque di̱ nja ra̱ 'da'yo te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nu̱na̱ Oja̱, hi̱mbi̱ bɛnhná̱ Ts'ʉnt'ʉ ua ja ra̱ xi̱mhäi ngue da̱ mɛnhna̱ castigo yø ja̱'i̱. Sinoque bá̱ pɛnhua ja ra̱ xi̱mhäi ngue da̱ ya̱nyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nu̱ to gä ɛ̱c'ɛ̱i̱bi̱ rá̱ Ts'ʉnt'ʉ Oja̱, ya hi̱nda̱ ma ra̱ castigo. Pɛ nu̱ya yø ja̱'i̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱, ya da̱ ma ra̱ castigo ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱bi̱ rá̱ 'dants'ʉnt'ʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Porque rá̱ Ts'ʉnt'ʉ Oja̱ bá̱ ɛ̱cua ja ra̱ xi̱mhäi, a nu̱ya yø ja̱'i̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱ ya, gue'a̱ di̱ ma ma̱sentencia yø ja̱'i̱'a̱. Tengu̱tho n'na ra̱ nyot'i di̱ nɛ̱qui̱ gätho yø cosa, njarbʉtho na̱ya, bi japi bi ba̱hyø ja̱'i̱ ngue ja yø ts'oqui. Pɛ hi̱ngui̱ nnu̱ ma̱nho yø ja̱'i̱ nu̱ya sifi ngue ja yø ts'oqui, porque xa̱nts'o te øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nu̱ to gä øtra̱ nts'o hi̱ngui̱ nnepe da̱ fa̱di̱ te øt'e. Ja̱na̱ngue hi̱ngui̱ nnu̱ ma̱nho brá̱ Ts'ʉnt'ʉ Oja̱, 'nɛ̱ hi̱ngui̱ nne da̱ guarbʉ ha ya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pɛ nu̱ya yø ja̱'i̱ 'yo ma̱nho, cuarbʉ ha ya̱ rá̱ Ts'ʉnt'ʉ Oja̱. Porque nnepe da̱ fa̱di̱ ngue gue'a̱ rá̱ pähä Oja̱ ørpa̱bi̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","M'mɛfa p'ʉya, bi̱ mähä yø xädi ra̱ Jesús, i̱ mpa p'ʉ ja ra̱ häi Judea. Ja bá̱ m'mʉp'ʉ njammi̱ pa, ja bi̱ ma ma̱xixya̱bi̱ p'ʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nu̱na̱ ra̱ Xuua xquet'a̱ mi̱ øtra̱ nxixya̱ p'ʉ ja ra̱ häi Enón, ha di̱ ntøt'ui ra̱ häi Salim, porque xa̱ngu̱ yø dehe pop'ʉ. Ja bí ɛ̱p'ʉ yø ja̱'i̱ ngue di xixya̱bi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tobe hi̱m ma̱ni̱ ma fädi ra̱ Xuua 'mø mi̱ nja na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nu̱ 'da yø xädi ra̱ Xuua, bi̱ nju̱n'ma̱hya̱ui 'da yø judío ngue ndana̱ ma̱n'na xa̱nho ra̱ nxixya̱ øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bi̱ ma da̱ xihra̱ Xuua p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, nu̱na̱ ra̱ n'yohʉ gá̱ ma̱n'a̱ m'mɛt'o, guehna̱ gá̱ nya̱ui nʉ ma̱n'na nguadi ra̱ da̱the Jordán, nu̱ya gä ni̱ map'ʉ yø ja̱'i̱ ba̱di xixya̱bi̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Bi 'yɛ̱nna̱ Xuua p'ʉya: ―Nu̱na̱ Oja̱, ya xpá̱ nzännbi̱ n'na ngu̱ n'na ndana̱ gue'a̱ ta̱te ngue mi̱'da. ");
INSERT INTO otnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ya gá̱ 'yøsɛhʉ te dá̱ ma̱ngä m'mɛt'o, ngue hi̱nga̱ guecä drá̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi. Sinoque bí̱ ma ma̱'bɛt'ogä hante ngue da̱ ɛ̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xi'mø ja ngue di̱ ntha̱ta̱ n'na ra̱ n'yohʉ, da̱ ma ra̱ hmu̱te p'ʉ 'bʉhrá̱ ndø. Nu̱'a̱ rá̱ amigo ra̱ n'yohʉ p'ʉya, 'bäp'ʉ ngue øde te mma̱, di johya ngue ya da̱ mɛ rá̱ ndø ra̱ hmu̱te. Di̱ njadä p'ʉya, da̱di johya ngue dí̱ ma yø ja̱'i̱ p'ʉ 'bʉhra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A nu̱ná̱, ma̱n'na di ba̱hyø ja̱'i̱ ngue ta̱te na̱, nu̱gä ma̱n'na gdá̱ cocä häi. ");
INSERT INTO otnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nu̱na̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ta̱te na̱ ngue gätho. A nu̱ ra̱ ja̱'i̱ ngue ra̱ mmɛ̱ngu̱ ua ja ra̱ xi̱mhäi, ya ra̱ mmɛ̱ngu̱ ua'a̱, 'nɛ̱ mma̱nyø cosa ja ua ja ra̱ xi̱mhäi. Pɛ nu̱'a̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ta̱te'a̱ ngue gätho. ");
INSERT INTO otnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","'Nɛ̱ i̱ mma̱ te bi̱ nnu̱p'ʉ ma̱hɛ̱ts'i̱. Nu̱'a̱ ra̱ hya̱ bi øde, gue'a̱ mma̱n'a̱. Pɛ hi̱njongui̱ ɛ̱c'ɛ̱i̱ na̱ ra̱ hya̱ i̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pɛ nu̱ya yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱ na̱ ra̱ hya̱ na̱, guehya ha̱xa̱ njua̱ni̱ ngue ma̱jua̱ni̱ te bi̱ ma̱n'Oja̱ conná̱ nguehna̱ ra̱ hya̱ øde i hma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nu̱na̱ ra̱ Jesús bá̱ pɛn'Oja̱, rá̱ hya̱ Oja̱ mma̱nna̱. Hi̱nha rá̱ nzɛgui di ha̱tra̱ ts'ɛdi ra̱ Espíritu Santo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nu̱na̱ ra̱ Papá di̱ ma̱hrá̱ Ts'ʉnt'ʉ, 'nɛ̱ bi u̱nná̱ ts'ɛdi ngue di̱ ma̱nda'a̱ te gä ja ya. ");
INSERT INTO otnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu̱ ra̱ ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱bi̱ rá̱ Ts'ʉnt'ʉ Oja̱ ja ra̱ 'da'yo te para za̱ntho. Pɛ nu̱'a̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱bi̱ rá̱ Ts'ʉnt'ʉ Oja̱, hi̱ndi̱ nthɛui ra̱ 'da'yo te ra̱ ja̱'i̱, sinoque gue'a̱ ra̱ castigo da̱ ja Oja̱ da̱ zäui. ");
INSERT INTO otnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Bi ba̱hyø fariseo ngue xa̱ngu̱ yø xädi di pɛtra̱ Jesús, 'nɛ̱ ma̱n'na xa̱ngu̱ yø ja̱'i̱ di xixya̱bi̱ ngue ra̱ Xuua. ");
INSERT INTO otnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pɛ hi̱ngo di jasɛ ra̱ nxixya̱ ra̱ Jesús, sinoque gue'ʉ yø xädi di xixya̱bi̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mi̱ ba̱hra̱ Jesús ngue ya fa̱di̱ te øt'e, bá̱ ɛ̱p'ʉ Judea ngue i̱ ma Galilea. ");
INSERT INTO otnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mi̱ ma p'ʉya, ja ngue da̱ni̱ nthop'ʉ ja ra̱ häi Samaria. ");
INSERT INTO otnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ni̱ ma da̱ zømp'ʉ ja ra̱ hni̱ni̱ Sicar ngue ra̱ häi Samaria, ja orbʉ n'na rá̱ häi ra̱ Jacob, nu̱na̱ bi u̱nná̱ ts'ʉnt'ʉ José. ");
INSERT INTO otnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nu̱na̱ ra̱ xɛqui na̱, jap'ʉ n'na ra̱ poso ngue t'ɛ̱mbi̱ bi hocra̱ Jacob. Ra̱ Jesús ya xpí yäp'ʉ ja ra̱ 'yu̱, bi̱ mi̱p'ʉ ja ra̱ poso. Ya 'dato nde'a̱ ra̱ ora'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ya mi̱ hu̱p'ʉ 'mø mi̱ zø'a̱ n'na ra̱ xisu ngue ra̱ mmɛ̱ngu̱ Samaria, ni̱ 'yɛ̱hra̱ 'yai. Ra̱ Jesús bi 'yɛ̱mbi̱: ―'Daqui ts'ʉ ra̱ dehe ga̱ si ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ya xi̱ map'ʉ bí ja ra̱ hni̱ni̱ yø xädi ra̱ Jesús ngue da̱ tänna̱ hmɛ̱ da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nu̱'ʉ yø judío di̱ nnu̱ ma̱n'ʉui yø mmɛ̱ngu̱ Samaria, ja̱na̱ngue nu̱'mø mi̱ 'yähra̱ dehe ra̱ Jesús, ra̱ xisu bi 'yɛ̱mbi̱: ―¿Hanja? Nu̱'i̱ grá̱ judío, 'nɛ̱ guí äcra̱ dehe guí si. A nu̱gä p'ʉya drá̱ mmɛ̱ngu̱gä Samaria. ");
INSERT INTO otnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'mø ngue gdi pa̱di̱ te di u̱n'Oja̱ ya, ogue gdi pa̱di̱ te'o na̱ ä'i ra̱ dehe da̱ zi, nu̱'i̱ p'ʉya gui 'yäcra̱ dehe gui si. A nu̱gä p'ʉya ga̱ 'da'i ra̱ dehe di u̱nna̱ 'da'yo te. ");
INSERT INTO otnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mi̱ da̱hra̱ xisu, bi 'yɛ̱mbi̱: ―Ague zi'ue, pɛ hi̱n'yʉ te gdi 'yähra̱ dehe ngue xa̱nhyɛ̱ ra̱ poso. ¿Ha gui hya̱'a̱ ra̱ dehe di u̱nna̱ 'da'yo te gui 'daqui? ");
INSERT INTO otnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nu̱na̱ ma̱ mboxitahʉ ra̱ Jacob, bi zoga̱he na̱ ra̱ poso ja ua. Ja mi̱ tu̱xua ra̱ dehe mi̱ si'a̱. Bi zi yø ba̱si̱ co 'nɛ̱'ʉ yø mbo'øni̱ mi̱ si, bi zi ra̱ dehe. ¿Ua ma̱ da̱'i̱ ngue nu̱'a̱ ya? ");
INSERT INTO otnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱ gätho yø ja̱'i̱ da̱ zi ra̱ dehe ja ua, ma̱høndi̱ ntu̱the. ");
INSERT INTO otnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pɛ nu̱ ra̱ ja̱'i̱ da̱ zi ra̱ dehe ga̱ u̱ngä, hi̱nja̱m'mø di̱ ntu̱the. Porque ra̱ dehe da̱di̱ u̱ngä, tengu̱tho 'mø dí pøhra̱ dehe mbo rá̱ mmʉi ra̱ ja̱'i̱ da̱ zi ngue di u̱nna̱ 'da'yo te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mi̱ da̱hra̱ xisu p'ʉya, bi 'yɛ̱mbi̱: ―Ague zi'ue, da̱mi̱ 'dajna̱ ra̱ dehe guí̱ mma̱, n'namhma̱ ngue ya hi̱nni̱ mantho ga̱ ntu̱thegä. 'Nɛ̱ ya hi̱nni̱ mantho ga̱ ma ɛ̱cä ra̱ 'yai ua ja ra̱ poso ja ua. ");
INSERT INTO otnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ga̱ 'yo, bá̱ si ni̱ da̱mme, bá̱ ɛ̱cua p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mi̱ da̱hra̱ xisu p'ʉya, bi 'yɛ̱na̱: ―Hi̱njo'o ma̱ da̱mme. Ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱'a̱ guí̱ mma̱nya, ma̱jua̱ni̱'a̱ ngue hi̱njo'o ni̱ da̱mme. ");
INSERT INTO otnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porque ya rá̱ cʉt'a ni̱ da̱mme xcá̱ m'mʉhmi̱. A nu̱'a̱ guí 'bʉhmi̱ ya, hi̱ngni̱ ndø'a̱. Ja di̱ nɛ̱qui̱ p'ʉya ngue ma̱jua̱ni̱ guí̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bi 'yɛ̱nna̱ xisu 'mø mi̱ 'yøde te sifi: ―Ague zi'ue, nu̱p'ʉ nná̱ bɛ̱ngä, ɛ̱na̱ gue gue'e n'na rá̱ pønga̱hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu̱ya ma̱ mboxitagähe yø mmɛ̱ngu̱ Samaria, mi̱ tha̱nne Oja̱ ua ja ra̱ nyu̱ni̱ ja ua. Pɛ nu̱'a̱hʉ ngue gyø judíohʉ, guí ɛ̱mhmʉ ngue nu̱p'ʉ Jerusalén, gue'a̱ ra̱ xɛqui ja ngue di̱ ntha̱nne Oja̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'yɛ̱c'ɛ̱i̱gui̱ grá̱ xisu, porque da̱ 'yɛ̱hra̱ ora ngue gui tha̱nnehʉ ra̱ Papá, pɛ hi̱mma̱ hyoni̱ guá̱ ɛ̱mhmʉ ua ja ra̱ nyu̱ni̱ ja ua, ni̱ xi̱nga̱ guep'ʉ Jerusalén di ja ngue 'be gui̱ mmähä. ");
INSERT INTO otnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nu̱'ʉ yø mmɛ̱ngu̱ Samaria hi̱ngui̱ pa̱ Oja̱ i tha̱nne'ʉ. Pɛ yø judío i pa̱ Oja̱ i tha̱nne. Porque Oja̱ bi zänni̱ ngue da̱ pøn'a̱ n'na nc'ɛ̱i̱ ra̱ judío ngue dra̱ ya̱nte. ");
INSERT INTO otnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pɛ da̱ 'yɛ̱hra̱ pa, 'nɛ̱ ya guehra̱ ora ja p'ʉya, ngue nu̱'ʉ ma̱jua̱ni̱ da̱ da̱nne ra̱ Papá, pɛ gue ma̱jua̱ni̱ ngue yø mmʉi da̱ nda̱nne. Guehna̱ nnepra̱ Papá da̱ 'yøt'e te'o ngue da̱ da̱nne na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nu̱na̱ Oja̱, hi̱ndi̱ nɛ̱qui̱ na̱ ngue hi̱n'yʉ rá̱ do'yo. A nu̱'ʉ yø ja̱'i̱ tha̱nne Oja̱, pɛ gue ma̱jua̱ni̱ ngue yø mmʉi da̱ nda̱nne. ");
INSERT INTO otnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mi̱ da̱hra̱ xisu p'ʉya, bi 'yɛ̱na̱: ―Nu̱gä dí pa̱di̱ ngue ja ngue da̱ ɛ̱hra̱ Cristo di̱ nda̱st'abi ua. Nu̱'mø bá̱ ɛ̱hna̱ p'ʉya, go da̱ ma̱ xa̱nho hanja gätho na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱'a̱ ra̱ Cristo guí̱ mma̱nya, go guecä'a̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mɛ̱nte mma̱n'a̱ p'ʉya, bi zøhyø xädi. Di 'yøtho'ʉ p'ʉya ngue bi di̱mp'ʉ mi̱ ya̱ui n'na ra̱ xisu ra̱ Jesús. Pɛ hi̱njombi̱ 'yänni̱ hanja te'bɛ'a̱ ma̱di̱ nxifi. ");
INSERT INTO otnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nu̱na̱ ra̱ xisu p'ʉya, bi zop'ʉ rá̱ ts'øye, bi̱ map'ʉ ja rá̱ hni̱ni̱. Bá̱ xihyø mmɛ̱ngu̱hʉ, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Mmähä ga̱ ma nu̱hʉ n'na ra̱ ja̱'i̱ bi xiqui te gätho xtá̱ øt'e. Ntha̱mbɛ̱ni̱tho ngue guehna̱ ra̱ Cristo na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bi̱ nɛ̱xyø ja̱'i̱ p'ʉ ja ra̱ hni̱ni̱ bi zømp'ʉ bi 'bʉhra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A nu̱'ʉ yø xädi ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, da̱mi̱ nsi̱hmɛ̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pɛ ra̱ Jesús bi 'yɛ̱na̱: ―Nu̱gä jaga̱ n'na ra̱ cosa ga̱ si. Nu̱na̱ ra̱ cosa na̱, hi̱nguí̱ pa̱hmʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","A nu̱'ʉ yø xädi p'ʉya di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na: ―Rá̱ nzɛgui 'bʉi to ya xa̱ 'ui̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pɛ ra̱ Jesús bi 'yɛ̱mbyø xädi: ―Ɛ̱ntho dí si̱hmɛ̱gä 'mø dí ørpa̱bi̱ rá̱ pähä'a̱ bá̱ pɛngui̱, 'nɛ̱ ga̱ juarpa̱bi̱ rá̱ 'bɛfi bi 'daqui. ");
INSERT INTO otnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Guí ɛ̱mhmʉ ngue ma̱ngoho za̱na̱ di 'bɛdi di̱ nja ra̱ nsofo. Pɛ nu̱gä dí xi'a̱hʉ, da̱mi̱ hyanthʉ yø ja̱'i̱ bá̱ ɛ̱cua. Hi̱nni̱ mantho ga̱ hu̱xhʉ ra̱ pa, ya da̱ 'yɛ̱c'ɛ̱i̱gä yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nu̱'a̱ xofo da̱ hya̱nná̱ nzäbi. Di̱ njarbʉtho ra̱ ja̱'i̱ di ha̱tra̱ ts'ɛdi yø ja̱'i̱ ngue da̱ 'yɛ̱c'ɛ̱i̱gä ya, xquet'a̱ da̱ hya̱nná̱ nzäbi. A nu̱'ʉ yø ja̱'i̱ ɛ̱c'ɛ̱i̱gä di̱ nja ra̱ 'da'yo te para za̱ntho. Ja̱na̱ngue nu̱'a̱ to di dʉ'mra̱ hya̱, 'nɛ̱'a̱ to di ha̱tra̱ ts'ɛdi yø ja̱'i̱ ngue da̱ 'yɛ̱c'ɛ̱i̱gä, 'da gui johyatho. ");
INSERT INTO otnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","I t'ɛn'a̱ ra̱ hma̱: “N'nan'yo'a̱ tu̱hu̱, n'nan'yo'a̱ xoqui”. ");
INSERT INTO otnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nu̱gä dí ɛ'a̱hʉ ngue güí ha̱thʉ ra̱ ts'ɛdi yø ja̱'i̱ ngue da̱ 'yɛ̱c'ɛ̱i̱gä. Pɛ gdi̱ mähä p'ʉ hapʉ ya xa̱ tho'a̱ n'na ra̱ ma̱mhya̱. Nu̱'a̱ ra̱ hya̱ bi dʉ'mi̱ bi̱ ma̱n'ʉ, go güí ha̱thʉ ra̱ ts'ɛdi yø ja̱'i̱ na̱ ra̱ hya̱ bi xifi. ");
INSERT INTO otnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Co nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ xisu, xa̱ngu̱ yø mmɛ̱ngu̱ Sicar ngue ra̱ häi Samaria bi 'yɛ̱c'ɛ̱i̱ ra̱ Jesús. Porque bi 'yɛ̱nna̱ xisu: “Bi xiqui te gätho xtá̱ øt'e”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mi̱ zøhya yø mmɛ̱ngu̱ p'ʉ ja ra̱ häi Samaria, bi xihra̱ Jesús ngue di̱ n'oxpʉ ha bí 'bʉi. Ja̱na̱ngue bi̱ m'mʉp'ʉ nyo pa ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Xa̱ngu̱ mi̱'da yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱ 'mø mi 'yø'a̱ ra̱ hya̱ pønná̱ ne ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ya t'ɛ̱mbra̱ xisu p'ʉya: ―A nu̱ya dí ɛ̱c'ɛ̱i̱gähe ya, pɛ hi̱nga̱ hønt'a̱ ra̱ hya̱ gá̱ xicje nná̱ ɛ̱c'ɛ̱i̱gähe ya, sinoque ya dí øsɛhe ra̱ hya̱ mma̱nya. 'Nɛ̱ dí pa̱hme njua̱ni̱ ngue guehna̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi na̱, 'nɛ̱ guehna̱ ra̱ ya̱nte ua ja ra̱ xi̱mhäi na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mi̱ tho'a̱ nyopa p'ʉya, bi thop'ʉ Samaria ra̱ Jesús, i̱ mpa p'ʉ ja ra̱ häi Galilea. ");
INSERT INTO otnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Porque ya xi̱ ma̱nsɛ ra̱ Jesús ngue n'na rá̱ pønga̱hya̱ Oja̱ hi̱ngui̱ hnu̱ ma̱nsu̱ p'ʉ ja rá̱ xɛqui bi̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nu̱'mø mi̱ zømp'ʉ Galilea, bi̱ nu̱ ma̱nho yø mmɛ̱ngu̱ p'ʉ, porque 'nɛ̱hya ya xi̱ ma ra̱ ts'ännigo ngue ra̱ pascua bá̱ njap'ʉ Jerusalén. Ya xi̱ nu̱rpi̱ te xi 'yørbʉ ja ra̱ ngo. ");
INSERT INTO otnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bi̱ mengra̱ Jesús, i̱ map'ʉ ja ra̱ hni̱ni̱ Caná ngue ra̱ häi Galilea, nu̱p'ʉ bá̱ øt'e ngue bi gohi ngue ra̱ vino ra̱ dehe. Nu̱na̱ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱ngu̱ Capernaum i ja rá̱ 'bɛfi xa̱nhɛ̱ts'i̱, di̱ mpɛhmi̱ ra̱ gobierno. I si n'na rá̱ ts'ʉnt'ʉ ma̱di̱ hyɛ̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nu̱na̱ ra̱ n'yohʉ p'ʉya bi 'yøde ngue ya bi zøp'ʉ Galilea ra̱ Jesús, xpí 'yɛ̱'a̱ Judea. Bi̱ ma bá̱ nu̱ p'ʉya, bá̱ äpra̱ ma̱te ngue da̱ ɛ̱p'ʉ ja rá̱ ngu̱ da̱ 'yøthebi rá̱ ts'ʉnt'ʉ, porque ya ja ngue da̱ du̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ra̱ Jesús bi 'yɛ̱na̱: ―Nu̱'mø ngue hi̱ngdi̱ nnu̱hʉ yø milagro dí øt'ä, ya hi̱ngui̱ 'yɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nu̱na̱ ra̱ n'yohʉ p'ʉya bi 'yɛ̱mbra̱ Jesús: ―Ague n'yø, 'yørca̱ ra̱ ma̱te mmɛ nts'ɛdi, 'nɛ̱ da̱ du̱ ma̱ ts'ʉnt'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ni̱ ma ni̱ ngu̱ ya. Nu̱ ni̱ ts'ʉnt'ʉ guí̱ mma̱, ya bi zä ya. Nu̱na̱ ra̱ n'yohʉ p'ʉya bi 'yɛ̱c'ɛ̱i̱ te bi̱ ma̱nna̱ Jesús. Bi̱ ma rá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nu̱'mø ni̱ ma da̱ zønná̱ ngu̱ ra̱ n'yohʉ p'ʉya, bi̱ ma yø hmi̱qui̱ di c'at'ui, bi 'yɛ̱mbi̱: ―Ya bi zä ni̱ ts'ʉnt'ʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nu̱na̱ ra̱ n'yohʉ p'ʉya bi 'yänni̱ tema̱ ora bi zä. Bi t'ɛ̱mbʉya: ―Comma̱ yoto nde ma̱nde bi bønna̱ pa mi̱ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bi bɛ̱n'a̱ ra̱ n'yohʉ p'ʉya ngue gue'a̱ ra̱ ora bi̱ ma̱nna̱ Jesús ngue ya bi zä na̱ rá̱ ts'ʉnt'ʉ mi̱ ʉ. Gätho'ʉ to 'bʉp'ʉ ja rá̱ ngu̱ p'ʉya, gä bi 'yɛ̱c'ɛ̱i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ngu̱na̱ bi 'yør'mø ma̱mbá̱ pengbʉ Judea ra̱ Jesús. Ya rá̱ yondi̱ na̱ ra̱ hmɛ̱ya bi 'yørbʉ ja ra̱ häi Galilea p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","M'mɛfa p'ʉya, bi̱ nsänni̱go yø judío. Ja̱na̱ngue nu̱na̱ ra̱ Jesús bi̱ ma Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nu̱p'ʉ Jerusalén pop'ʉ n'na ra̱ dehe gui̱ nhu̱ti̱ conna̱ hya̱ ngue ra̱ ebreo “Betesda”. Pop'ʉ jonna̱ goxthi gui̱ nhu̱ti̱ ngue rá̱ Goxthi yø Dɛ'yo. Ja jap'ʉ cʉt'a yø 'døscua̱ngu̱ di thɛ̱sra̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nu̱p'ʉ ja yø 'døscua̱ngu̱ ja 'bomp'ʉ xa̱ngu̱ yø därquɛ̱hi̱. 'Bomp'ʉ yø xädä, 'bomp'ʉ'ʉ xa̱nnu̱nts'i̱, 'bomp'ʉ'ʉ tu̱dyø gua. I tø'mi̱ ngue di 'ya̱nna̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porque njandyatho mi̱ sø'a̱ n'na ra̱ anxɛ ngue a̱nna̱ dehe p'ʉ po. Nu̱'a̱ ra̱ därquɛ̱hi̱ rá̱ mʉdi da̱ yʉrbʉ ja ra̱ dehe 'mø bi 'ya̱ni̱, da̱ zä ndana̱ bi zä ma̱n'ʉ di hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mi̱ 'bɛmp'ʉ n'na ra̱ n'yohʉ ngue ya n'näte ma̱'dɛ'ma̱ hya̱to njɛya ma̱di hyɛ̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nu̱'mø mi̱ nu̱ ra̱ Jesús ngue 'bɛmp'ʉ, bi ba̱di̱ ngue ya rá̱ ya'atho yø pa ma̱di hyɛ̱nni̱. Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Ua guí̱ nne da̱ zä'i n'yø? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mi̱ da̱hra̱ därquɛ̱hi̱ p'ʉya, bi 'yɛ̱na̱: ―Ague n'yø, hi̱njo'o to di cʉjhnʉ ja ra̱ dehe 'mø bi 'ya̱ni̱. N'na ndi̱ ngu̱ n'na ndi̱ dí ɛ̱na̱ ngue ga̱ cʉnhnʉ ja ra̱ dehe 'mø bi 'ya̱ni̱, n'nan'yo'a̱ ni̱ 'bɛt'o. ");
INSERT INTO otnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Bi 'yɛ̱mbra̱ därquɛ̱hi̱ ra̱ Jesús: ―Da̱mi̱ nangui̱. Ca̱xni̱ fi̱di̱, ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","'Bexque'a̱ ra̱ ora'a̱ p'ʉya, bi zä ra̱ därquɛ̱hi̱. Bi ga̱xrá̱ fi̱di̱, bi̱ ma. Pɛ ra̱ pa ngue ra̱ ts'äya'a̱ ra̱ pa bi̱ n'øthe ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nu̱ya yø hmu̱ yø judío p'ʉya, bi 'yɛ̱mbra̱ n'yohʉ mi̱'ʉ: ―Hi̱nda̱ zä guí ca̱xni̱ fi̱di̱ ya, porque ra̱ ts'äya ra̱ pa ja p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bi 'yɛ̱nna̱ n'yohʉ p'ʉya: ―Nu̱'a̱ ra̱ n'yohʉ bi 'yøthegui, gue'a̱ bi xiqui ngue ga̱ ca̱xma̱ fi̱di̱, ga̱ mma. ");
INSERT INTO otnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bi t'ännbʉya, t'ɛ̱mbi̱: ―¿Te'o na̱ ɛ̱n'i̱ guí̱ ca̱xni̱ fi̱di̱, gui̱ mma? ");
INSERT INTO otnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pɛ nu̱na̱ ra̱ n'yohʉ p'ʉya, hi̱ngui̱ pa̱di̱ te'o na̱ xi 'yøthe, porque xa̱ngu̱ yø ja̱'i̱ 'yop'ʉ, 'nɛ̱ ya xi̱ ma ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","M'mɛfa p'ʉya, nu̱na̱ ra̱ n'yohʉ xi 'yøthe ra̱ Jesús bi̱ nthɛui p'ʉ ja ra̱ ni̱ja̱. Bi 'yɛ̱mbʉya: ―Ya bi zä'i n'yø. Pɛ 'yo ni̱mantho guí øtra̱ ts'oqui, n'namhma̱ ngue hi̱m ma̱n'na gui̱ mma ma̱n'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nu̱'mø mi̱ 'yø'a̱ te bi sihna̱ ra̱ n'yohʉ xi t'øthe, bi̱ ma bá̱ xipyø hmu̱ yø judío ngue guehna̱ ra̱ Jesús xi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ja̱na̱ngue bi̱ mʉdi honnba̱bi̱ rá̱ gua ra̱ Jesús, porque t'ɛ̱mbi̱ ngue di̱ mpɛtho 'mø ra̱ pa ngue ra̱ ts'äya. ");
INSERT INTO otnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pɛ ra̱ Jesús bi 'yɛ̱na̱: ―Da̱ guehma̱ Papágä di̱ mpɛtho asta̱ guehya, da̱ guecä p'ʉya da̱di̱ mpɛfi. ");
INSERT INTO otnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nu̱na̱ ra̱ hya̱ na̱ p'ʉya, guehna̱ ga̱ nne yø hmu̱ yø judío ngue da̱ hyo. Porque t'ɛ̱mbi̱ ngue hi̱nga̱ høndra̱ pa ngue ra̱ ts'äya hi̱ngui̱ su̱pi̱, sinoque di ʉpi ngue i̱ mma̱ ngue 'da'igu̱ui Oja̱, ngue mma̱ ngue Oja̱ rá̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue rá̱ Ts'ʉnt'ʉ Oja̱ hi̱nda̱ zä te da̱ jasɛ. Tengu̱tho nnu̱rpi̱ øtrá̱ Papá, gue'a̱ øt'a̱. Ja̱na̱ngue nu̱'a̱ te øtrá̱ Papá, xquet'a̱ gue'a̱ øtrá̱ Ts'ʉnt'ʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nu̱na̱ ra̱ Papá di̱ ma̱hrá̱ Ts'ʉnt'ʉ 'nɛ̱ u̱ti̱ te gä øt'e. A nu̱yá, ma̱n'na xta̱ nhɛ̱nni̱ mi̱'da da̱ 'yu̱di̱, asta̱ ga̱di 'yøthohʉ 'mø gá̱ nu̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nu̱na̱ ra̱ Papá, øt'e ngue di bɛ̱nna̱te yø ánima. Njarbʉtho rá̱ Ts'ʉnt'ʉ Oja̱ ya, nu̱ to da̱ nepe di bɛ̱nna̱te, da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nu̱na̱ ra̱ Papá hi̱njonni̱ ja̱'i̱ di sentencia na̱. Nu̱'a̱ rá̱ Ts'ʉnt'ʉ go bi u̱nná̱ ts'ɛdi ngue go da̱ zänna̱ sentencia'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Porque nnepe ngue go da̱ hnu̱ ma̱nsu̱ na̱ rá̱ Ts'ʉnt'ʉ, tengu̱tho ga̱ hnu̱ ma̱nsu̱ rá̱ Papá. Nu̱'a̱ hi̱ngui̱ nnu̱ ma̱nsu̱ brá̱ Ts'ʉnt'ʉ Oja̱, ya hi̱mma̱ jua̱ni̱ ngue nnu̱ ma̱nsu̱ brá̱ Papá bá̱ pɛnhni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱ ra̱ ja̱'i̱ ørpa̱bi̱ ma̱su̱ ra̱ hya̱ dí̱ mma̱ngä, 'nɛ̱ ɛ̱c'ɛ̱i̱'a̱ to bá̱ pɛnngui̱, ya ja ra̱ 'da'yo te para za̱ntho ra̱ ja̱'i̱. Ya hi̱nda̱ ma ra̱ castigo. Ya bi̱ mpommi̱ ra̱ sentencia mi̱ ja, ya ja ra̱ 'da'yo te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ma̱jua̱ni̱ dí xi'a̱hʉ, da̱ 'yɛ̱hra̱ ora di̱ nja te dí̱ mma̱, 'nɛ̱ ya da̱ guehra̱ ora ja p'ʉya. Nu̱ yø ja̱'i̱ 'bʉhya tengu̱tho 'mø ya xa̱ndu̱, pɛ nu̱'mø bi 'yøhra̱ hya̱ mma̱nná̱ Ts'ʉnt'ʉ Oja̱ 'nɛ̱ da̱ 'yɛ̱c'ɛ̱i̱, ya di t'u̱nna̱ 'da'yo te. ");
INSERT INTO otnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","I ja rá̱ ts'ɛdi ra̱ Papá ngue di u̱nna̱ 'da'yo te yø ja̱'i̱. Njarbʉtho rá̱ Ts'ʉnt'ʉ ya, bi u̱nná̱ ts'ɛdi ngue di u̱nna̱ 'da'yo te yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","'Nɛ̱ bi u̱nná̱ ts'ɛdi ngue go da̱ zänna̱ castigo'a̱, porque gue'a̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","'Yo ga̱di 'yøtho na̱ ra̱ hya̱ dí xi'a̱hʉ. Porque da̱ 'yɛ̱hra̱ ora ngue nu̱'ʉ xa̱ndu̱, da̱ 'yø'mø bi zo'a̱ rá̱ Ts'ʉnt'ʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Da̱ pømp'ʉ da̱ nt'ägui. Nu̱'ʉ xa̱ n'yo ma̱nho, di bɛ̱nna̱te ngue ma̱'da'yo di̱ m'mʉi. A nu̱'ʉ xa̱ n'yo ma̱nts'o, di bɛ̱nna̱te ngue da̱ ma ra̱ castigo. ");
INSERT INTO otnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nu̱gä hi̱nda̱ zä ga̱ sänsɛ te ga̱ øt'e. Ga̱ øt'ä ra̱ ts'ʉt'abi, pɛ gue ma̱'bɛjpa̱gui̱. Nu̱ te ga̱ sännä di̱ nja, gue'a̱ di̱ nja'a̱, pɛ gue da̱ gue'a̱ ni̱ 'yu̱p'ʉ. Hi̱nda̱ zä ga̱ sänsɛ te ga̱ øt'e. Nu̱'a̱ te nnu̱ma̱nho ma̱ Papá bá̱ pɛnngui̱, gue'a̱ ga̱ øt'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nu̱'mø da̱di jasɛ ma̱jua̱ni̱ te dí̱ mma̱ngä, 'yogui 'yɛ̱c'ɛ̱i̱ga̱hʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pɛ 'bʉ hma̱n'na di ja ma̱jua̱ni̱ te'ogä. 'Nɛ̱ dí pa̱cä ngue ma̱jua̱ni̱ te gä mma̱nna̱ conná̱ ngueque. ");
INSERT INTO otnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Conque gá̱ 'yɛthʉ to bá̱ ørpa̱ ra̱ nt'änni̱ ra̱ Xuua. Nu̱na̱ p'ʉya, nu̱'a̱ te ra̱ hya̱ bá̱ ma̱, gä ma̱jua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pɛ nu̱gä hi̱mma̱ hyoni̱ ngue toni̱ ja̱'i̱ di ja ma̱jua̱ni̱ te dí̱ mma̱ngä. Nu̱'a̱ ra̱ hya̱ bi̱ ma̱nna̱ Xuua conná̱ ngueque, gue'a̱ da̱di bɛ̱n'na̱hʉ'a̱ ya, n'namhma̱ ngue gui 'yɛ̱c'ɛ̱i̱hʉ na̱ ra̱ hya̱ na̱, 'nɛ̱ guehna̱ gdi̱ nya̱mhmʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Xuua, tengu̱tho n'na ra̱ nyot'i ngue di pɛtyø 'uɛ̱, ja gá̱ mpɛtihʉ p'ʉ bi̱ nya̱'a̱. Gá̱ johyahʉ n'na ts'ʉquits'ʉ ngue te bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pɛ nu̱gä, nu̱ya yø hmɛ̱ya dí øt'e ngue hi̱njonda̱ zä da̱ 'yøt'e, guehya di ja ma̱jua̱ni̱ te dí̱ mma̱ngä ya. Nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Xuua, zits'ʉtho na̱. Nu̱ya yø hmɛ̱ya dí øt'ä, ma̱ Papá di 'bɛjpi ngue ngu̱'a̱ ga̱ øt'e. Ja di̱ nɛ̱qui̱ p'ʉya ngue ma̱jua̱ni̱ bá̱ pɛnnga̱gui̱ ma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nu̱na̱ ma̱ Papá bá̱ pɛnngui̱, go di ja ma̱jua̱ni̱ te dí̱ mma̱ngä na̱. 'Nɛ̱ hi̱nga̱ como quiera guí ørpa̱hʉ ra̱ hya̱ na̱. Porque hi̱nja̱m'mø guí̱ nnu̱hʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pɛ nu̱na̱ rá̱ hya̱ bá̱ pɛnhni̱, hi̱nguí̱ nne gui 'yøhmʉ. Porque hi̱nguí̱ nne gui 'yɛ̱c'ɛ̱i̱ te dí xi'a̱hʉ, 'nɛ̱ nu̱gä rá̱ m'mɛnhni̱gä ra̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nu̱'a̱hʉ ga̱di ja ndu̱mmʉi ga̱di xähmʉ ra̱ Ma̱ca̱ Libro guí ca̱hʉ, porque ja guí̱ nne gui ti̱mhmʉ p'ʉ hanja ngue ja na̱ ra̱ 'da'yo te para za̱ntho i ja. Conque nu̱na̱ ra̱ Ma̱ca̱ Libro ga̱di xähmʉ, nu̱'a̱ to mma̱nna̱ hya̱ nt'ot'i p'ʉ, go guecä'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","'Nɛ̱ hi̱nguí̱ nne gui 'yɛ̱c'ɛ̱i̱ga̱hʉ, n'namhma̱ ngue di̱ nja'a̱hʉ ra̱ 'da'yo te. ");
INSERT INTO otnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nu̱gä hi̱ndí̱ honi̱ to da̱ 'yɛ̱squi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nu̱gä dí pa̱di̱ ngue hi̱n ga̱di̱ ma̱hmʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nu̱gä, ma̱ Papá bá̱ pɛnngui̱, pɛ hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ. Nu̱'mø toni̱ n'yohʉ da̱ ɛ̱hɛ̱ ngue rá̱ hya̱sɛ da̱ ma̱, ma̱n'na go guí ɛ̱c'ɛ̱i̱hʉ'a̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hague da̱ nzä gui 'yɛ̱c'ɛ̱i̱ga̱hʉ ngue'mø ga̱di̱ nnu̱ ma̱nhosɛ n'na ngu̱ n'na'a̱hʉ, 'nɛ̱ hi̱nguí̱ honi̱ ha dí nu̱ ma̱nho'a̱hʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'Yo guí ɛ̱na̱ ngue go ga̱ ya̱p'a̱hʉ p'ʉ ha 'bʉhma̱ Papá. Nu̱'a̱, hi̱n'na̱'a̱. Nu̱'a̱ di ya̱p'a̱hʉ, gue'a̱ ra̱ Moisés guí ɛ̱na̱ ngue guí̱ nnøxʉ'a̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","A nu̱'mø gdi ɛ̱c'ɛ̱i̱hʉ na̱ ra̱ hya̱ bi̱ ma̱nna̱ Moisés, xquet'a̱ 'nɛ̱cä gui 'yɛ̱c'ɛ̱i̱ga̱hʉ 'mø. Porque bi 'yotra̱ hya̱ p'ʉ ja ra̱ libro ra̱ Moisés ngue i̱ mma̱ te'ogä. ");
INSERT INTO otnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pɛ nu̱'mø hi̱nguí̱ ɛ̱c'ɛ̱i̱hʉ na̱ ra̱ hya̱ bi 'yotra̱ Moisés, ¿hague da̱ nzä gui 'yɛ̱c'ɛ̱i̱ te dí xi'a̱hʉ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","M'mɛfa p'ʉya, nu̱na̱ ra̱ Jesús bi 'dasra̱ zabi Galilea, nu̱na̱ ja ma̱n'na rá̱ thu̱hu̱, ni̱ hu̱ ngue Tiberias. ");
INSERT INTO otnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Xa̱ndøngu̱ yø ja̱'i̱ bi dɛnni̱, porque nnu̱ yø ja̱'i̱ ngue øthe yø därquɛ̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bi̱ map'ʉ bí ja n'na ra̱ nyu̱ni̱ ra̱ Jesús, ja i̱ mmi̱hmi̱ p'ʉ yø xädi. ");
INSERT INTO otnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ya xma̱ nguerpʉtho di̱ nsännigo yø judío ngue ra̱ pascua. ");
INSERT INTO otnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mi̱ nu̱ ra̱ Jesús ngue xa̱ndøngu̱ yø ja̱'i̱ mmap'ʉ ni̱ dɛnni̱, bi 'yɛ̱mbra̱ Lipe p'ʉya: ―¿Hapʉ ga̱ tämhmʉ ra̱ thu̱hmɛ̱ da̱ zi ya yø ja̱'i̱ bá̱ ɛ̱cua ya? ");
INSERT INTO otnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ngu̱na̱ bi xifi, porque nne da̱ nu̱ te da̱ ma̱nna̱ Lipe. A nu̱na̱ ra̱ Jesús ya pa̱di̱ te ja ngue da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pɛ ra̱ Lipe bi 'yɛ̱na̱: ―Nu̱'mø ngue da̱ thänna̱ thu̱hmɛ̱'a̱ te di̱ mporta yo ciento ma̱ pa ra̱ nzäbi, hi̱ndi̱ zʉdi ngue da̱ zi 'da'i zits'ʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nu̱na̱ n'na nc'ɛ̱i̱ yø xädi ra̱ Jesús, guehna̱ ra̱ Andre rá̱ n'yohʉ ra̱ Bɛdu. Bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―'Bʉcua n'na ra̱ ts'ʉnt'ʉ ha̱ cʉt'a yø thu̱hmɛ̱ 'nɛ̱ yoho yø hua̱. Pɛ hapʉ gue da̱ goxna̱, xa̱ndøngu̱ yø ja̱'i̱ 'bʉcua ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Da̱mi̱ xihmʉ yø ja̱'i̱ ngue gä da̱ mi̱. Comma̱ cʉt'a ma̱hua̱hi̱ yø ja̱'i̱ bi̱ mi̱p'ʉ ja ra̱ 'batha. ");
INSERT INTO otnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nu̱na̱ ra̱ Jesús bi hya̱n'ʉ cʉt'a yø thu̱hmɛ̱, bí ja ma̱mma̱di̱ Oja̱. M'mɛfa p'ʉya, bi u̱nyø xädi ngue di darpi̱ gätho yø ja̱'i̱ da̱ zi p'ʉ hu̱di̱. Xquet'a̱ ngu̱t'a̱tho yø hua̱ bi darpa̱bi̱ yø ja̱'i̱ da za. Bi̱ nsahua̱ yø ja̱'i̱ hønt'a̱ hangu̱ bi̱ ne bi za. ");
INSERT INTO otnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nu̱'mø mi̱ nni̱ya̱ yø ja̱'i̱, bi 'yɛ̱mbyø xädi ra̱ Jesús: ―Da̱mi̱ pɛthʉ yø thu̱hmɛ̱ bi bongui̱, n'namhma̱ ngue hi̱nte di̱ n'ʉntho. ");
INSERT INTO otnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Cʉt'a nthu̱hmɛ̱ bi̱ ma nsɛni̱ ngue bi zi yø ja̱'i̱. Nu̱'ʉ bi bongui̱, 'dɛ'ma̱ yo canasta yø thu̱hmɛ̱ bi bongui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mi̱ nu̱ yø ja̱'i̱ ra̱ milagro bi 'yøtra̱ Jesús, bi 'yɛ̱nyø ja̱'i̱ p'ʉya: ―Ma̱jua̱ni̱ ngue guehna̱ rá̱ pønga̱hya̱ Oja̱ mí̱ ja ngue da̱ ɛ̱cua ja ra̱ xi̱mhäi na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bi zänyø ja̱'i̱ p'ʉya ngue xta̱ nzixra̱ Jesús, xtí japa̱ nts'ɛdi ngue di̱ nda̱st'abi. Pɛ nu̱'mø mi̱ ba̱di̱ te sänyø ja̱'i̱ p'uya, bi zop'ʉ yø ja̱'i̱ ra̱ Jesús, bi̱ ma ma̱yá̱ ra̱ nyu̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nu̱'mø mi̱ dähra̱ nde, nu̱'ʉ yø xädi ra̱ Jesús bi̱ map'ʉ brá̱ ja ra̱ zabi. ");
INSERT INTO otnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pɛ ra̱ Jesús hi̱nni̱ zorpʉ 'bʉhyø xädi, 'nɛ̱ ya bi̱ nxu̱i̱. Nu̱'ʉ yø xädi p'ʉya, bi yʉt'a̱ n'na ra̱ barco, bi̱ ma ngue di 'dasra̱ dehe da̱ zømp'ʉ ja ra̱ hni̱ni̱ Capernaum. ");
INSERT INTO otnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bi̱ mʉdi bi̱ n'yo n'na ra̱ ndønthi̱ p'uya, bi̱ nangyø fʉnthe. ");
INSERT INTO otnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nu̱'mø mi̱ n'yo'a̱ cʉt'a o 'dato kilómetro p'ʉ ja ra̱ dehe, bi̱ nu̱ p'ʉya ngue mmap'ʉ ra̱ Jesús da̱ guatra̱ barco, ní̱ 'yo ma̱xøts'e ra̱ dehe. Bi̱ nsu̱'ʉ yø xädi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Go guecä. Oguí̱ su̱hʉ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nu̱'ʉ yø xädi p'ʉya, ra̱ ndi johya ngue ya mmap'ʉ ra̱ Jesús, da̱ zømp'ʉ ja ra̱ barco. N'na zihmantho bi zøn'a̱ nnengui̱ hapʉ ma̱ni̱ ma p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mi̱ hyaxpʉya, nu̱ya yø ja̱'i̱ xpí gop'ʉ ma̱n'na nguadi ra̱ dehe ya pa̱di̱ ngue hønda̱ n'na ra̱ barco mi̱ jap'ʉ, gue'a̱ bi 'yo yø xädi ra̱ Jesús. Pɛ ra̱ Jesús bá̱ cohi. ");
INSERT INTO otnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ya hi̱mma̱ ya'atho p'ʉya, bi zø hmi̱'da yø barco bá̱ nɛ̱xpʉ ja ra̱ hni̱ni̱ Tiberias, bi zøp'ʉ ja ra̱ xɛqui bi ja ma̱mma̱di̱ Oja̱ 'mø bi 'ui̱nyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nu̱ya yø ja̱'i̱ ya, mi̱ nu̱ ngue hi̱njo'o p'ʉ ra̱ Jesús, ni̱ xi̱nga̱ guehyø xädi di 'bʉp'ʉ. Bi 'yo'ʉ yø barco bi zø p'ʉya, bi̱ ma da̱ homp'ʉ Capernaum. ");
INSERT INTO otnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mi̱ zøm ma̱n'na nguadi ra̱ zabi yø ja̱'i̱ p'ʉya, ja ni̱ di̱mp'ʉ ra̱ Jesús. Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ¿ha bi̱ nja guí søcua ya? ");
INSERT INTO otnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, guí honjʉ ya, porque ngue gá̱ nsi̱hmɛ̱ 'nɛ̱ gá̱ nni̱ya̱hʉ. Hi̱ngue masque gni̱ hyonjʉ ngue di ti̱nni̱ mmʉihʉ hanja ya yø hmɛ̱ya dí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","'Yo 'be go ga̱di ja ndu̱mmʉi ha gdi ti̱mhmʉ'a̱ ra̱ hmɛ̱ da̱ thogui. Sinoque da̱mi̱ ja ndu̱mmʉi ha gdi ti̱mhmʉ'a̱ ra̱ hmɛ̱ di̱ nja para za̱ntho, nu̱na̱ guehna̱ di 'da'a̱hʉ ra̱ 'da'yo te na̱. Nu̱na̱ guehna̱ ra̱ hmɛ̱ di 'da'a̱hʉ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ na̱. Porque nu̱na̱ Oja̱ ra̱ Papá, guehna̱ bi 'dacä ra̱ ts'ɛdi ngue ngu̱'a̱ ga̱ øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bi t'ännbʉya, bi t'ɛ̱mbi̱: ―¿Te 'bɛ'a̱ ja ngue ga̱ øt'ähe p'ʉya para ngue da̱ nu̱ma̱nho Oja̱ ya yø hya̱ nneque ga̱ øt'ähe? ");
INSERT INTO otnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱'a̱ ra̱ hya̱ nne Oja̱ gui 'yøthʉ, gue'a̱ ngue gui 'yɛ̱c'ɛ̱i̱hʉ'a̱ to bá̱ pɛnhni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bi t'ɛ̱mbʉya: ―¿Tema̱ hmɛ̱ya gui 'yøt'e ga̱ nnu̱gähe, n'namhma̱ ja ga̱ ɛ̱c'ɛ̱i̱'a̱he p'ʉya? ¿Te 'bɛ'a̱ da̱ zä gui 'yøt'e? ");
INSERT INTO otnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Conque ma̱ mboxitahʉ, bá̱ nsi̱hmɛ̱ p'ʉ bí ja ra̱ da̱po, tengu̱tho nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Nu̱na̱ ra̱ Moisés bi u̱nyø ja̱'i̱ ra̱ hmɛ̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱”, i ɛ̱nna̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱na̱ ra̱ Moisés hi̱ngo bi u̱nna̱ hmɛ̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱ na̱, sinoque guehna̱ ma̱ Papágä bi u̱n'a̱. 'Nɛ̱ guehna̱ ma̱jua̱ni̱ ngue di 'da'a̱hʉ ra̱ hmɛ̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porque nu̱'a̱ ra̱ hmɛ̱ di u̱n'Oja̱, gue'a̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱'a̱, guehna̱ di u̱nna̱ 'da'yo te yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bi t'ɛ̱mbʉya: ―Ague grá̱ hmu̱, za̱nt'a̱ gui 'dacje na̱ ra̱ hmɛ̱ guí̱ mma̱m'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱gä guecä'a̱ ra̱ hmɛ̱ di u̱nna̱ 'da'yo te. Nu̱ ra̱ ja̱'i̱ da̱ dɛnnga̱gui̱, hi̱nja̱m'mø di̱ ntu̱ma̱ nthu̱hu̱. Nu̱'a̱ da̱ 'yɛ̱c'ɛ̱i̱gui̱, hi̱nja̱m'mø di̱ ntu̱the. ");
INSERT INTO otnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pɛ ya dí xi'a̱hʉ ngue hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ, ma̱da̱gue'a̱ guí̱ nnu̱hʉ te dí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nu̱'ʉ yø ja̱'i̱ bi däcä ra̱ Papá tɛnngä'ʉ. Nu̱'ʉ to tɛnngui̱, hi̱njonda̱ 'yɛ̱mbi̱: “'Yo gui tɛnngui̱”. ");
INSERT INTO otnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porque hi̱mbi̱ 'bɛnngä ma̱hɛ̱ts'i̱ ngue da̱ gue'a̱ te ma̱ pähäsɛ ga̱ øt'e, sinoque dá̱ ɛ̱hɛ̱ ngue ga̱ ørpa̱bi̱ rá̱ pähä'a̱ to bá̱ pɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Pɛ nu̱'a̱ te rá̱ pähä ma̱ Papá bá̱ pɛnngui̱, i̱ nne'a̱ ngue nu̱'ʉ yø ja̱'i̱ bi däqui, hi̱njondi̱ m'mɛdi, sinoque ga̱ øt'e ngue di bɛ̱nna̱te 'mø ra̱ pa rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nu̱'a̱ te rá̱ pähä'a̱ to bá̱ pɛnngui̱, guehna̱ ngue di̱ nja ra̱ 'da'yo te para za̱ntho te'o gä da̱ ba̱di̱ te'o'a̱ rá̱ Ts'ʉnt'ʉ Oja̱ 'nɛ̱ da̱ 'yɛ̱c'ɛ̱i̱. Nu̱gä ga̱ øt'e ngue di bɛ̱nna̱te 'mø ra̱ pa rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Gue'a̱ ga̱ nzʉhyø judío na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, di ʉpi ngue bi 'yɛ̱na̱: “Go guecä'a̱ ra̱ hmɛ̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱”. ");
INSERT INTO otnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Di̱ n'yɛ̱mbʉya: ―¿Ua hi̱nga̱ guehna̱ ra̱ Jesús, rá̱ ts'ʉnt'ʉ ra̱ José na̱? A nu̱jʉ p'ʉya, dí pa̱hmʉ rá̱ papá 'nɛ̱hra̱ mamá na̱. ¿Hanja ngue ɛ̱na̱ ngue bí 'yɛ̱ ma̱hɛ̱ts'i̱ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―'Yo ni̱mantho guí̱ nemhya̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nu̱'mø hi̱nna̱ ngue hra̱ Papá bá̱ pɛnngui̱ da̱ 'yøt'e ngue di̱ ntɛtyø ja̱'i̱, ya hi̱njonda̱ dɛnngui̱. Pɛ nu̱'ʉ tɛnngui̱, nu̱gä ga̱ øt'e ngue di bɛ̱nna̱te 'mø ra̱ pa rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nu̱na̱ ra̱ hya̱ nt'ot'i p'ʉ ja yø libro bi 'yotyø pønga̱hya̱ Oja̱, i ɛ̱na̱: “Nu̱na̱ Oja̱, da̱ 'yøt'e ngue da̱ ba̱hyø ja̱'i̱ hanja na̱”. Ja̱na̱ngue nu̱yá, nu̱ to gä øde te mma̱nna̱ Papá, 'nɛ̱ da̱ 'yɛ̱t'a̱ mmʉi ra̱ hya̱ xännba̱bi̱, gue'ʉ tɛnngä'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hi̱ngue masque to ya xpá̱ nnu̱'a̱ ra̱ Papá. Sinoque nu̱'a̱ bí 'yɛ̱p'ʉ 'bʉ Oja̱, gue'a̱ go pa̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue nu̱ya yø ja̱'i̱ ɛ̱c'ɛ̱i̱gä ya, ya ja ra̱ 'da'yo te para za̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Go guecä'a̱ ra̱ hmɛ̱ di u̱nna̱ 'da'yo te. ");
INSERT INTO otnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Conque nu̱ ma̱ mboxitahʉ p'ʉ ja ra̱ da̱po, bi zi n'na ra̱ hmɛ̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱. Pɛ hi̱mbi̱ m'mʉi para za̱ntho, sinoque bi du̱ da̱m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pɛ nu̱na̱ ra̱ hmɛ̱ dí̱ mma̱ngä, guehna̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱ na̱. Nu̱ to da̱ zi na̱ ra̱ hmɛ̱ na̱ya, ya hi̱nda̱ du̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nu̱gä guecä'a̱ ra̱ hmɛ̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ma̱da̱gue'a̱ drá̱ ja̱'i̱gä. Nu̱ to da̱ zi na̱ ra̱ hmɛ̱ na̱, di̱ m'mʉi para za̱ntho. Nu̱'a̱ ra̱ hmɛ̱ ga̱ u̱ngä p'ʉya, guehna̱ ma̱ do'yogä na̱. Da̱di̱ u̱ngä ma̱ do'yo para ngue di̱ nja ra̱ 'da'yo te yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Di̱ nju̱n'ma̱hya̱sɛ yø judío p'ʉya, di̱ n'yɛ̱mbi̱: ―¿Pɛ ua da̱ zä di 'dacjʉ rá̱ ngø 'mø ngue ga̱ sahʉ? ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, jatho ngue gui saphʉ rá̱ ngø ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, 'nɛ̱ gui siphʉ rá̱ ji, n'namhma̱ ngue di̱ nja'a̱hʉ ra̱ 'da'yo te. ");
INSERT INTO otnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nu̱'a̱ da̱ zacä ma̱ ngø 'nɛ̱ da̱ zicä ma̱ ji, ya ja ra̱ 'da'yo te para za̱ntho ra̱ ja̱'i̱. 'Nɛ̱ ga̱ øt'e ngue di bɛ̱nna̱te 'mø ra̱ pa rá̱ nzɛgui. ");
INSERT INTO otnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porque ma̱ ngøgä, ma̱jua̱ni̱ ngue guehna̱ nnøpa̱ nts'i̱hmɛ̱ yø ja̱'i̱ na̱. Ma̱ jigä p'ʉya, gue'a̱ gui thocra̱ du̱the yø ja̱'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu̱ ra̱ ja̱'i̱ da̱ zacä ma̱ ngø 'nɛ̱ da̱ zicä ma̱ ji, guehna̱ dí̱ n'yogä'be na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nu̱'a̱ ma̱ Papá i 'bʉi, 'nɛ̱ dí 'bʉcä conná̱ ngue'a̱. Nu̱na̱ ma̱ Papá bá̱ pɛnngui̱ para ngue ga̱ japi di̱ m'mʉi te'o da̱ zacä ma̱ ngø. ");
INSERT INTO otnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja̱na̱ngue ja n'na ra̱ hmɛ̱ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ngue di u̱nna̱ 'da'yo te para za̱ntho. Nu̱na̱ ra̱ hmɛ̱ na̱, hi̱nga̱ ngu̱'a̱ ra̱ hmɛ̱ bi zi'ʉ ma̱ mboxitahʉ 'nɛ̱ siempre bi du̱ da̱m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nu̱na̱ ra̱ Jesús, ngu̱na̱ ra̱ hya̱ bi xännba̱ yø ja̱'i̱ bi̱ mpɛti p'ʉ ja ra̱ ni̱ja̱ Capernaum. ");
INSERT INTO otnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nu̱'mø mi̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ bi̱ nxännba̱te ra̱ Jesús, nu̱'ʉ yø ja̱'i̱ tɛnnbʉ ni̱ ma, xa̱ngu̱ bi 'yɛ̱na̱: ―Nu̱na̱ ra̱ hya̱ mma̱nya, xa̱nhɛ̱nni̱tho di fa̱hna̱. ¿Hague da̱ mba̱'a̱ n'na'a̱ te mma̱nnʉ? ");
INSERT INTO otnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bi ba̱hra̱ Jesús ngue di̱ nju̱n'ma̱hya̱ yø ja̱'i̱ co nu̱na̱ ra̱ hya̱ bi̱ ma̱. Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Ua guí̱ mbøcuɛhʉ nguehna̱ ra̱ hya̱ na̱ya? ");
INSERT INTO otnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tegue ngu̱ guí̱ mbɛ̱mhmʉ 'mø gui̱ nnu̱hʉ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ ngue hønda̱ mengui̱ di̱ map'ʉ bí 'yɛ̱hɛ̱? ");
INSERT INTO otnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hønsɛ ra̱ Espíritu Santo di u̱nna̱ 'da'yo te. Nu̱na̱ ra̱ hya̱ dí xi'a̱hʉ ya, i̱ nne da̱ ma̱ ngue gui 'yɛ̱c'ɛ̱i̱ga̱hʉ, hi̱ngue dí ɛ̱n'a̱hʉ ngue gui sajʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pɛ nu̱ya 'bʉ i'da ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱ga̱hʉ. Bi̱ ma̱nna̱ ngu̱na̱ ra̱ Jesús, ngue ya m'mɛt'o mi̱ pa̱di̱ ndana̱ gue'a̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱, 'nɛ̱ pa̱di̱ te'o ja ngue di dä. ");
INSERT INTO otnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Bi 'yɛ̱mbʉya: ―Ja̱na̱ngue ya xtá̱ xi'a̱hʉ m'mɛt'o ngue nu̱'mø hi̱nna̱ ngue hra̱ Papá da̱ 'yøt'e ngue di̱ ntɛtyø ja̱'i̱, ya hi̱njonda̱ dɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","'Bexpi̱ mʉdi bi go'a̱ nxʉtha xa̱ngu̱ yø ja̱'i̱ mi̱ tɛnna̱ Jesús. Bi zop'ʉ p'ʉya, ya hi̱nga̱ 'dap'ʉ n'youi. ");
INSERT INTO otnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nu̱na̱ ra̱ Jesús bi 'yänya 'dɛ'ma̱ yoho yø xädi, bi 'yɛ̱mbi̱: ―¿Ua xquet'a̱ guí̱ nne gui 'yøthʉ tengu̱tho øtyø ja̱'i̱ ngue hɛgä p'ʉ? ");
INSERT INTO otnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bi da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, hi̱njon ma̱n'na da̱ zä ga̱ tɛnnähe. Nu̱na̱ ra̱ hya̱ guí̱ mma̱, ra̱ hya̱ ngue ra̱ 'da'yo te para za̱ntho na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A nu̱gähe p'ʉya, dí ɛ̱c'ɛ̱i̱gähe 'nɛ̱ dí pa̱hme ngue rá̱ Ts'ʉnt'ʉ'i Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø xädi: ―Nu̱gä go dá̱ huan'na̱hʉ 'dɛ'ma̱ yo nc'ɛ̱i̱. A nu̱na̱ n'na nc'ɛ̱i̱ ngue'a̱hʉ ya, rá̱ pähä ra̱ zithu̱ ørpe. ");
INSERT INTO otnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ra̱ Jesús bi̱ ma̱nna̱ ra̱ hya̱ na̱, pɛ nu̱na̱ bi̱ ma̱, guehna̱ ra̱ Judas Iscariote rá̱ ts'ʉnt'ʉ ra̱ Simu̱ na̱. Porque ra̱ Judas guehna̱ ja ngue di dä ra̱ Jesús, 'nɛ̱ guehna̱ n'na nc'ɛ̱i̱'ʉ 'dɛ'ma̱ yoho yø xädi na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","M'mɛfa na̱ ra̱ hya̱ na̱ p'ʉya, bi̱ n'yop'ʉ ja yø xɛqui ngue ra̱ häi Galilea ra̱ Jesús. Pɛ hi̱ngui̱ nne da̱ n'yop'ʉ ja ra̱ häi Judea porque nne di̱ nhote yø hmu̱ yø judío. ");
INSERT INTO otnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ya xma̱ nguerpʉtho di̱ nsännigo yø judío nguehna̱ ra̱ ngo ma̱hoqui yø ngu̱mpaxi. ");
INSERT INTO otnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nu̱'ʉ yø cu̱ ra̱ Jesús bi 'yɛ̱mbi̱: ―¿Hanja ngue n'nadua guí 'bʉi? Da̱mi̱ pøngua ni̱ ma Judea, n'namhma̱ ngue 'nɛ̱'ʉ yø ja̱'i̱ ɛ̱c'ɛ̱i̱'i̱ p'ʉ, da̱ nu̱ te guí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nu̱ ra̱ ja̱'i̱ nne ngue da̱ fa̱di̱ te ga̱ 'yo, hi̱nga̱ nt'a̱gui̱tho da̱ 'yøt'a̱ te øt'e. Ya guí øtya tengu̱ ya, pɛ gue da̱ ba̱di̱ gätho yø ja̱'i̱ na̱ te guí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ngu̱na̱ bi xifi porque ni̱ xi̱nga̱ gue'ʉ yø cu̱ di ɛ̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Tobe hi̱ngui̱ sønna̱ ora ga̱ mmagä p'ʉ guí xicui. Pɛ nu̱'a̱hʉ, hønt'a̱ goma̱ ora sä ngue guí̱ mmähä. ");
INSERT INTO otnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nu̱'a̱hʉ, hi̱ngui̱ nnu̱ ma̱n'ʉ'a̱hʉ yø ja̱'i̱. Pɛ nu̱gä nnu̱ ma̱n'ʉgä yø ja̱'i̱, porque da̱di jagä ma̱jua̱ni̱ ngue xa̱nts'o te ga̱ 'yo yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ni̱ mähä ra̱ ngo ya. Nu̱gä hi̱nga̱ mma porque tobe hi̱ngui̱ sønna̱ ora ga̱ mmagä p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mi̱ juadi bi xihyø ja̱'i̱ na̱ ra̱ hya̱ na̱ p'ʉya, bá̱ cop'ʉ Galilea ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mi̱ juadi bi̱ ma ra̱ ts'änni̱go yø cu̱ ra̱ Jesús, xquet'a̱ 'nɛ̱sɛ ra̱ Jesús bi̱ ma ra̱ ts'änni̱go. Bi 'yøt'e ngue hi̱ngui̱ pa̱hyø ja̱'i̱ ngue 'yop'ʉ, ya mmɛ nt'a̱gui̱tho ga̱ 'yo. ");
INSERT INTO otnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nu̱ya yø hmu̱ yø judío homp'ʉ ja ra̱ ngo ngue'mø di 'yop'ʉ ra̱ Jesús. Di̱ n'yɛ̱mbi̱: ―¿Hapʉ 'bʉ'a̱ ra̱ n'yohʉ'a̱? ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nu̱p'ʉ ha 'bʉhyø ja̱'i̱, xa̱ngu̱ to di c'a̱ na̱ ra̱ Jesús. 'Bʉ i'da ɛ̱na̱: “Ra̱ hoga̱ n'yohʉ'a̱ n'yø”. Pɛ mi̱'da p'ʉya i ɛ̱na̱: “¿Tegue dra̱ hoga̱ n'yohʉ na̱ 'mø, hante gue hätyø ja̱'i̱”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pɛ nu̱ya yø ja̱'i̱ nnu̱ ma̱nho ra̱ Jesús, hi̱ngui̱ nnepe da̱ fa̱di̱ ngue nnu̱ ma̱nho, porque su̱pyø hmu̱ yø judío. ");
INSERT INTO otnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Comma̱ ɛma̱de ra̱ ngo 'mø mi̱ yʉrbʉ ja ra̱ ni̱ja̱ ra̱ Jesús ngue bi̱ nxännba̱te. ");
INSERT INTO otnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nu̱'ʉ yø judío, di 'yøtho'a̱ te ra̱ hya̱ mma̱nna̱ Jesús, di̱ n'yɛ̱mbi̱: ―¿Hapʉ go bá̱ ha̱'a̱ ra̱ hya̱ mma̱nna̱? 'Nɛ̱ hi̱ndí̱ nnu̱hʉ ngue xta̱ mma ra̱ xädi. ");
INSERT INTO otnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ hya̱ dí xännba̱tegä, hi̱mma̱ hya̱sɛgä na̱. Nu̱'a̱ bá̱ pɛnngui̱, go rá̱ hya̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nu̱'mø to da̱ ne da̱ 'yørpa̱bi̱ rá̱ pähä Oja̱, guehna̱ da̱ ba̱hna̱ ngue'mø ní̱ 'yɛ̱p'ʉ 'bʉ Oja̱ na̱ ra̱ hya̱ dí xännba̱te, ogue ma̱ hya̱sɛ dí̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nu̱ ra̱ ja̱'i̱ ngue rá̱ hya̱sɛ mma̱, ga̱ 'yøt'e ngue da̱ nu̱ ma̱nhosɛ yø ja̱'i̱. Pɛ nu̱'a̱ di ja ndu̱mmʉi ngue da̱ hnu̱ ma̱nho'a̱ to bá̱ pɛnhni̱, guehna̱ ma̱jua̱ni̱ ra̱ hya̱ mma̱nna̱. 'Nɛ̱ hi̱n tema̱ fɛhni̱ da̱ thi̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Ua hi̱mma̱ jua̱ni̱ ngue bi 'da'a̱hʉ ra̱ ley ra̱ Moisés? Conque nu̱'a̱ ra̱ ley'a̱, hi̱njongui̱ pøni̱ ngue gdi ɛ̱c'ɛ̱i̱hʉ'ʉ ya yø hya̱ mma̱n'a̱. ¿Hanja ngue guí̱ nne gui hyojʉ, guí ɛ̱njʉ ngue hi̱ndí̱ ɛ̱c'ɛ̱i̱gä te mma̱mp'ʉ ja ra̱ ley? ");
INSERT INTO otnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mi̱ da̱hyø ja̱'i̱ p'ʉya, bi 'yɛ̱mbi̱: ―Ra̱ ts'onthi̱ guí̱ n'youi ya. ¿Te'o guí ɛ̱na̱ ngue nne da̱ hyo'i? ");
INSERT INTO otnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Hønda̱ n'na ra̱ hya̱ dá̱ øt'ä 'mø ra̱ pa ngue ra̱ ts'äya, 'nɛ̱ gä ga̱di 'yøthohʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nu̱na̱ ra̱ Moisés, bi zoc'a̱hʉ n'na ra̱ hmɛ̱pya, ni̱ hu̱ ngue ra̱ circuncisión, ma̱da̱gue'a̱ hi̱ngo bi fʉt'a̱, sinoque gue'ʉ yø mboxita bi fʉti. Ja̱na̱ngue njap'ʉ gui̱ mmɛ̱pyahʉ yø ts'ʉnt'ʉ 'mø bi̱ m'mʉi, ma̱da̱gue'a̱ di tocabi ra̱ pa ngue ra̱ ts'äya, pɛ ngu̱tho gui̱ mmɛ̱pyahʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","A nu̱yá, para ngue hi̱ngui̱ 'dasthohʉ'a̱ te mma̱nna̱ ley bi 'yotra̱ Moisés, guí̱ mmɛ̱pyahʉ n'na ra̱ ts'ʉnt'ʉ 'mø bi̱ m'mʉi, ma̱da̱gue'a̱ ra̱ pa ngue ra̱ ts'äya. ¿Hanja ngue guí sʉcjʉ ngue dá̱ øthegä n'na ra̱ n'yohʉ 'mø ra̱ pa ngue ra̱ ts'äya 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","'Yo høntho guí̱ nnu̱hʉ n'na ra̱ cosa sä 'bexqui ha̱xhʉ ra̱ güɛnda. Nu̱'mø guí̱ nne gui hya̱xhʉ ra̱ güɛnda, pɛ 'bet'o nma̱jua̱ni̱ gdi pa̱di̱ hanja'a̱ te guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bi̱ mʉdi di̱ n'yänni̱ 'da'ʉ yø mmɛ̱ngu̱ Jerusalén, di̱ n'yɛ̱mbi̱: ―¿Ua hi̱nga̱ guehna̱ nthoni̱ ngue da̱ tho na̱ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pɛ ya 'bʉhnʉ ya, ya ya̱hʉ yø ja̱'i̱ 'nɛ̱ hi̱nte xifi. ¿Ua di ɛ̱c'ɛ̱i̱ yø ts'ʉt'abi ngue da̱ guehna̱ ra̱ Cristo na̱ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pɛ dí pa̱hmʉ hapʉ ra̱ mmɛ̱ngu̱ na̱. A nu̱'mø bá̱ ɛ̱'a̱ ra̱ Cristo, hi̱njonda̱ ba̱di̱ ha di 'yɛ̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nu̱p'ʉ ja ra̱ ni̱ja̱ mi̱ xännba̱te ra̱ Jesús, mi̱ 'yøde te mma̱nyø ja̱'i̱. Bi ts'ɛdi bi 'yɛ̱mbi̱: ―Ya guí ɛ̱na̱ ngue guí pa̱hmʉ ha dá̱ ɛ̱cä. Pɛ hi̱mma̱ partesɛ ngue dá̱ ɛ̱cä. Sinoque dá̱ ɛ̱cä ngue nu̱na̱ ma̱jua̱ni̱ Oja̱ i 'bʉi, guehna̱ bá̱ pɛnngä na̱. Pɛ hi̱nguí̱ pa̱hmʉ te'o na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nu̱gä go dí pa̱cä te'o na̱, porque ja dá̱ ɛ̱cä p'ʉ bí 'bʉ'a̱, 'nɛ̱ go bá̱ pɛnngä'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Co nu̱na̱ ra̱ hya̱ na̱ p'ʉya, bi̱ ne xtí bɛntyø ja̱'i̱ ra̱ Jesús ngue xta̱ ngot'i. Pɛ hi̱njombi̱ bɛnt'i̱ porque hi̱m ma̱ni̱ zøhrá̱ ora. ");
INSERT INTO otnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Xa̱ngu̱ yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱ ra̱ Jesús ngue guehna̱ ra̱ Cristo na̱. Di̱ n'yɛ̱mbi̱: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, ya øtyø hmɛ̱ya tengu̱tho t'ɛ̱mbi̱ da̱ 'yøtra̱ Cristo 'mø bá̱ ɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nu̱ya yø fariseo bi 'yøde te mma̱nyø ja̱'i̱ ngue ɛ̱mbi̱ guehna̱ ra̱ Cristo na̱ ra̱ Jesús. Yø fariseo p'ʉya, conyø hmu̱ yø mmäcja̱ bi̱ mɛnhyø policía di bɛntra̱ Jesús ngue da̱ got'i. ");
INSERT INTO otnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mi̱ nya̱ ra̱ Jesús, bi 'yɛmbyø ja̱'i̱: ―Zits'ʉrbʉ guí̱ nnu̱jʉ ua guí 'bʉhmʉ. Ya hi̱mma̱ ya'atho ga̱ mmagä p'ʉ bí 'bʉ'a̱ to bá̱ pɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gui hyonjʉ p'ʉya, pɛ ya hi̱nha gui ti̱njʉ, porque hi̱nda̱ zä guí thohmʉ p'ʉ ha ga̱ m'mʉcä. ");
INSERT INTO otnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Di̱ n'yänsɛ yø judío p'ʉya, di̱ n'yɛ̱mbi̱: ―¿Hapʉ go di̱ ma na̱ p'ʉya, ngue ɛ̱na̱ hi̱nga̱ ti̱mhmʉ ha di̱ ma? ¿Ua da̱ni̱ mpa ma̱n'na nguadi yø häi yap'ʉtho ngue da̱ xännba̱ ra̱ hya̱ yø judío da̱ ti̱mp'ʉ? ¿Ua gue gue'ʉ yø mmɛ̱ngu̱hʉ da̱ ma da̱ xännbi̱? ");
INSERT INTO otnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Mbe te nne da̱ ma̱nna̱ ra̱ hya̱ xicjʉ na̱, ngue ɛ̱na̱: “Guí hyonjʉ, pɛ ya hi̱nha gui ti̱njʉ, porque ya hi̱nda̱ zä guí thohmʉ p'ʉ ha ga̱ m'mʉcä”? ");
INSERT INTO otnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nu̱na̱ rá̱ nzɛgui ra̱ pa ngue ra̱ ngo, guehna̱ ra̱ pa ɛ̱mbyø ja̱'i̱ ngue ta̱te ra̱ da̱nni̱go na̱. Nu̱na̱ ra̱ pa na̱ p'ʉya, bi̱ nangra̱ Jesús, bi ts'ɛdi bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱'mø te'o tu̱the ya, dá̱ ɛ̱cua di̱ nsithe. ");
INSERT INTO otnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nu̱ ra̱ ja̱'i̱ ɛ̱c'ɛ̱i̱gä ya, nu̱p'ʉ ja rá̱ mmʉi ra̱ ja̱'i̱ tengu̱tho 'mø di pøhra̱ dehe ngue di u̱nna̱ 'da'yo te. Porque ngu̱'a̱ mma̱nna̱ Ma̱ca̱ Libro. ");
INSERT INTO otnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nu̱na̱ ra̱ hya̱ na̱, bi̱ ne bi̱ ma̱ ngue nu̱ to da̱ 'yɛ̱c'ɛ̱i̱, ya di̱ n'youi ra̱ Espíritu Santo. Porque tobe hi̱m ma̱ni̱ ma ma̱hɛ̱ts'i̱ ra̱ Jesús ngue da̱ pɛnnba̱bi̱ ra̱ Espíritu Santo yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mi̱ t'øhna̱ ra̱ hya̱ mma̱nna̱ Jesús, bi 'yɛ̱n'i̱'da yø ja̱'i̱ p'ʉya: ―Ma̱jua̱ni̱ ngue nu̱na̱ ra̱ n'yohʉ na̱, guehna̱ rá̱ pønga̱hya̱ Oja̱ mí̱ ja ngue da̱ ɛ̱cua ja ra̱ xi̱mhäi na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mi̱'da yø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Nu̱na̱ ya, guehna̱ ra̱ Cristo na̱ya ―bi 'yɛ̱na̱. Pɛ mi̱'da yø ja̱'i̱ di̱ n'yɛ̱mbi̱: ―Hi̱mma̱ jua̱ni̱'a̱. Porque ra̱ Cristo hi̱nga̱ Galilea di 'yɛ̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","I̱ mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro ngue nu̱na̱ ra̱ Cristo, da̱ guehna̱ n'na rá̱ mbom'mɛto ra̱ da̱st'abi David. 'Nɛ̱ drá̱ mmɛ̱ngu̱ Belén nu̱p'ʉ ja ra̱ mmɛ̱ngu̱ ra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ya hi̱nga̱ n'nat'a̱ mma̱nyø ja̱'i̱ ngue di̱ nxifi te'o na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bi̱ ne 'da yø ja̱'i̱ xtí bɛntra̱ Jesús ngue xta̱ ngot'i, pɛ hi̱njombi̱ bɛnt'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nu̱'ʉ yø policía bá̱ nɛ̱xpʉ ja ra̱ ni̱ja̱, bi̱ mengui̱ bi zømp'ʉ 'bʉhyø fariseo conyø hmu̱ yø mmäcja̱ xi̱ mɛnhni̱. Bi t'ɛ̱mbʉya: ―¿Hanja ngue hi̱nguá̱ sihʉ p'ʉya? ");
INSERT INTO otnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mi̱ da̱hyø policía, bi 'yɛ̱na̱: ―Pɛ hi̱nja̱m'mø ha di t'øde da̱ ma̱n'a̱ n'na ra̱ ja̱'i̱ tengu̱ mma̱nna̱ ra̱ n'yohʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yø fariseo p'ʉya bi 'yɛ̱mbyø policía: ―Xquet'a̱ 'nɛ̱'a̱hʉ ya bá̱ thä'a̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ya guí̱ nnu̱hʉ ngue hi̱njongui̱ pøni̱ ngue di ɛ̱c'ɛ̱i̱'ʉ ma̱ hmu̱hʉ na̱ ra̱ n'yohʉ na̱, ni̱ xi̱nga̱ gue'ʉ yø fariseo di ɛ̱c'ɛ̱i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pɛ nu̱ya yø ja̱'i̱ ɛ̱c'ɛ̱i̱ na̱ ra̱ n'yohʉ na̱, guehya hi̱ngui̱ pa̱hra̱ ley ya, 'nɛ̱ guehya yø ja̱'i̱ da̱ ma ra̱ castigo ya. ");
INSERT INTO otnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nu̱na̱ ra̱ Nicodemo, guehna̱ bi̱ ma n'na xu̱i̱ bá̱ nya̱ui ra̱ Jesús, xquet'a̱ yø n'yohʉ yø fariseo na̱. Bi 'yɛ̱nna̱ p'ʉya: ");
INSERT INTO otnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Nu̱p'ʉ ja ra̱ ley dí ca̱hʉ, mma̱mp'ʉ ja ra̱ ley ngue hi̱nga̱ sä da̱ ma ma̱sentencia n'na ra̱ ja̱'i̱, mɛ̱nte tobe hi̱ngui̱ ja ra̱ ts'ʉt'abi ngue da̱ t'øde tema̱ hya̱ da̱ ma̱n'a̱ ma̱ ya̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bi t'ɛ̱mbra̱ Nicodemo p'ʉya: ―¿Xquet'a̱ 'nɛ̱'i̱ grá̱ mmɛ̱ngu̱ Galilea 'mø? Da̱mi̱ xädi te mma̱nna̱ Ma̱ca̱ Libro. Ja guí̱ nnu̱p'ʉ p'ʉya ngue hi̱nga̱ n'na rá̱ pønga̱hya̱ Oja̱ ni̱ bøn'a̱ Galilea. ");
INSERT INTO otnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bi̱ ma yø ngu̱ n'na ngu̱ n'na yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pɛ ra̱ Jesús bi̱ map'ʉ bí ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos. ");
INSERT INTO otnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mi̱ hyaxpʉya, ya nɛ̱ca̱häi, bá̱ pengui̱, bi zøp'ʉ ja ra̱ ni̱ja̱. Bi guat'i gätho yø ja̱'i̱ p'ʉ ha 'bʉi. Bi̱ mi̱hra̱ Jesús ngue bi xännba̱ ra̱ hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A nu̱'ʉ yø xännba̱te ngue ra̱ ley conyø fariseo, bi zispa̱bi̱ n'na ra̱ xisu xi̱ ma ma̱bɛnt'i̱, ngue xi thi̱nnba̱bi̱ n'na ra̱ n'yohʉ hi̱ngra̱ ndø. Bi̱ ma ma̱'bä'mi̱ p'ʉ ma̱de na̱ ra̱ xisu p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bi t'ɛ̱mbra̱ Jesús: ―Ague grá̱ xännba̱te, nu̱na̱ ra̱ xisu 'bʉcua, bi̱ ma ma̱bɛnt'i̱ 'mø mi̱ thi̱nnba̱bi̱ n'na ra̱ n'yohʉ ngue hi̱ngra̱ ndø. ");
INSERT INTO otnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A nu̱p'ʉ ja ra̱ ley bi 'yotra̱ Moisés, ja mma̱mp'ʉ ngue da̱ tho ya yø xisu njap'ʉ, ngue da̱ 'bʉndo. Xi'i, ¿te guí̱ mma̱nna̱ ra̱ hya̱ na̱ya? ");
INSERT INTO otnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bi xihna̱ ra̱ hya̱ na̱, porque nne da̱ nu̱rpi̱ ngue'mø hi̱nga̱ gue'a̱ ra̱ hya̱ da̱ ma̱nna̱ Jesús, para ngue da̱ zä di ya̱pi̱. Nu̱na̱ ra̱ Jesús bi̱ ndoqui, ot'a̱ häi conná̱ saha. ");
INSERT INTO otnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pɛ hi̱ngui̱ säya'ʉ ya̱ui ngue änni̱ tema̱ hya̱ da̱ ma̱. Bi̱ m'mä p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱ua guí 'bʉhmʉ ya, nu̱'mø 'bʉcua n'na nc'ɛ̱i̱ ngue hi̱nja̱m'mø di øtra̱ ts'oqui, gue'a̱ rá̱ mʉdi da̱ mʉndo ra̱ xisu'a̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bi̱ ndojtho ma̱høn'a̱ p'ʉya, ngue ot'a̱ häi conná̱ saha. ");
INSERT INTO otnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pɛ mi̱ 'yø'a̱ ra̱ hya̱ sihyø ja̱'i̱ p'ʉya, bi där'ma̱n'ʉ yø mmʉi yø ja'i̱ porque pa̱di̱ ngue gä ja yø ts'oqui. Bi bøni̱ 'da mi̱'da p'ʉya. Rá̱ mʉdi bi bønyø da̱ja̱'i̱. Nu̱'mø mi̱ bøni̱ gätho p'ʉya, bi gosɛ p'ʉ ra̱ Jesús co 'nɛ̱hra̱ xisu ma̱ ya̱pi̱ bi gosɛui p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mi̱ gʉxrá̱ ya̱ ra̱ Jesús, bi̱ nu̱ ngue hi̱njongui̱ 'bʉp'ʉ, ya ma̱høndra̱ xisu 'bʉp'ʉ. Bi 'yɛ̱mbʉya: ―Ague grá̱ xisu, ¿hapʉ 'bʉ'ʉ ma̱di̱ ya̱p'a̱'i̱ ya? Ya hi̱njombi̱ zänni̱ ngue da̱ tho'i ya 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mi̱ da̱hra̱ xisu, bi 'yɛ̱na̱: ―Ya hi̱n'na̱ ya, grá̱ hmu̱. Bi 'yɛ̱mbra̱ xisu ma̱høn'a̱ ra̱ Jesús: ―Ni̱ xi̱nga̱ guecä ga̱ sänni̱ ngue da̱ tho'i ya. Ni̱ ma ya, pɛ 'yoni̱ mantho hønguí̱ øtra̱ ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nu̱na̱ ra̱ Jesús, ma̱hømbi̱ zohyø ja̱'i̱, bi 'yɛ̱mbi̱: ―Nu̱gä ga̱ øt'e ngue da̱ xohyø mmʉi yø ja̱'i̱. Nu̱ ra̱ ja̱'i̱ da̱ dɛnngui̱, guehna̱ ra̱ ja̱'i̱ di̱ nja ra̱ 'da'yo te na̱, pɛ ya hi̱nni̱ mantho di̱ n'yo ma̱nts'o ra̱ ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yø fariseo bi 'yɛ̱mbra̱ Jesús: ―Nu̱'i̱ ga̱di jasɛ ma̱jua̱ni̱ ra̱ hya̱ guí̱ mma̱. Hi̱nte di̱ mu̱ui ra̱ hya̱ guí̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ hya̱ dí̱ mma̱ngä, di̱ mu̱ui na̱, ma̱da̱gue'a̱ da̱di jasɛ ma̱jua̱ni̱ ra̱ hya̱ dí̱ mma̱. Pɛ nu̱gä dí pa̱di̱ ha dá̱ ɛ̱hɛ̱, 'nɛ̱ dí pa̱di̱ ha nná̱ ma. Pɛ nu̱'a̱hʉ hi̱nguí̱ pa̱hmʉ ha dá̱ ɛ̱cä, ni̱ xi̱nguí̱ pa̱hmʉ ha nná̱ magä. ");
INSERT INTO otnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nu̱'a̱hʉ guí ha̱xhʉ ra̱ güɛnda tengu̱tho ga̱ hya̱xra̱ güɛnda yø ja̱'i̱ ua ja ra̱ xi̱mhäi. Nu̱gä hi̱njondí̱ ha̱spa̱ ra̱ güɛnda. ");
INSERT INTO otnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A nu̱'mø xi̱nga̱ ha̱xä ra̱ güɛnda, nu̱ te ga̱ sännä ngue di̱ nja, pɛgue dra̱ hya̱ njua̱ntho ga̱ sänni̱. Porque hi̱ndi̱ 'dasɛ ga̱ ha̱xä ra̱ güɛnda. Nu̱na̱ ra̱ Papá bá̱ pɛnnga̱gui̱, guehna̱ 'da gda̱ ha̱xä'be ra̱ güɛnda na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nu̱p'ʉ ja ra̱ ley guí ca̱hʉ, nt'ot'i p'ʉ ra̱ hya̱ ngue nu̱'mø yoho yø testigo 'da'igu̱ mma̱, jatho ngue da̱ t'ɛ̱c'ɛ̱i̱ te mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A nu̱yá, guecä da̱di jasɛ ma̱jua̱ni̱ ra̱ hya̱ dí̱ mma̱ngä. Nu̱na̱ ra̱ Papá bá̱ pɛnngui̱, 'nɛ̱hna̱ di ja ma̱jua̱ni̱ ra̱ hya̱ dí̱ mma̱ngä na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bi t'ɛ̱mbʉya: ―¿Hapʉ go 'bʉhni̱ Papá? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱'a̱hʉ hi̱nguí̱ pa̱cjʉ, ni̱ xi̱nga̱ guehna̱ ma̱ Papágä guí pa̱hmʉ. Nu̱'mø ngue gdi pa̱cjʉ, xquet'a̱ 'nɛ̱hma̱ Papágä gdi pa̱hmʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nu̱'mø mi̱ xännba̱ ra̱ hya̱ yø ja̱'i̱ p'ʉ ja ra̱ ni̱ja̱ ra̱ Jesús, guehya yø hya̱ ja ua bi xifi. Bi̱ m'mä p'ʉ ja yø njʉmɛ̱nyu̱ ngue ra̱ ofrenda. Pɛ hi̱njombi̱ bɛnt'i̱ ngue xta̱ ngot'i, porque tobe hi̱m ma̱ni̱ zønna̱ ora. ");
INSERT INTO otnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ma̱hømbi̱ 'yɛ̱mbyø ja̱'i̱ ra̱ Jesús: ―Ga̱ mmagä, 'nɛ̱ gui hyonjʉ. Gui tu̱hʉ, pɛ hi̱mma̱ hoquitho ni̱ ts'oquihʉ. Nu̱p'ʉ ha gda̱ magä, hi̱nda̱ zä guí tɛnnga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yø judío p'ʉya, di̱ n'yɛ̱mbi̱: ―¿Ua da̱ zä di̱ nhyosɛ nʉ, ngue hi̱nda̱ zä ga̱ tɛnhnʉ ha di̱ ma? ");
INSERT INTO otnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mi̱ nya̱ ra̱ Jesús, ma̱hømbi̱ 'yɛ̱mbi̱: ―Nu̱'a̱hʉ, gyø mmɛ̱ngu̱hʉ ua ja ra̱ xi̱mhäi. Pɛ nu̱gä drá̱ mmɛ̱ngu̱gä ma̱hɛ̱ts'i̱. Nu̱'a̱hʉ gyø mmɛ̱ngu̱hʉ ua ja ra̱ häi, pɛ nu̱gä hi̱ndrá̱ mmɛ̱ngu̱gä ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ja̱na̱ngue nu̱gä dí xi'a̱hʉ ngue guí tu̱hʉ 'nɛ̱ hi̱mma̱ hoquitho ni̱ ts'oquihʉ. Guehna̱ hi̱ngui̱ nhohni̱ ts'oquihʉ na̱ ngue hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ ngue dí̱ mma̱ te'ogui. ");
INSERT INTO otnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bi t'ännbʉya, bi t'ɛ̱mbi̱: ―¿Pɛ te'o'i p'ʉya? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ya xtá̱ xi'a̱hʉ m'mɛt'o te'ogä. ");
INSERT INTO otnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Xa̱ngu̱ mi̱'da yø hya̱ da̱ zä ga̱ xi'a̱hʉ, 'nɛ̱ da̱ zä ga̱ ha̱ts'a̱hʉ ra̱ güɛnda. Pɛ nu̱na̱ ra̱ hya̱ dí xicä yø ja̱'i̱ ua ja ra̱ xi̱mhäi, guehna̱ ra̱ hya̱ dí øde mma̱n'a̱ to bá̱ pɛnngui̱, pɛ gue ma̱jua̱ni̱ ra̱ hya̱ mma̱n'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pɛ hi̱mbi̱ di̱nyø mmʉi yø ja̱'i̱ ngue guehna̱ rá̱ Papá i̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ja̱na̱ngue bi 'yɛ̱mbi̱: ―Nu̱'mø gá̱ cuathʉ ra̱ pont'i̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, guí pa̱hmʉ te'ogä p'ʉya. Hi̱nda̱ zä ga̱ sänsɛ ra̱ hya̱ ga̱ mma̱. Nu̱na̱ ra̱ hya̱ xännga̱gui̱ ra̱ Papá, guehna̱ dí̱ mma̱ngä na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Porque dí̱ n'yogä'be'a̱ to bá̱ pɛnngui̱. Nu̱gä hi̱ngui̱ hɛga̱sɛ ma̱ Papá, porque nu̱ te nnu̱ ma̱nho, que'a̱ za̱nt'a̱ dí øt'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, xa̱ngu̱ yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ra̱ Jesús bi 'yɛ̱mbyø judío xi 'yɛ̱c'ɛ̱i̱: ―Nu̱'mø hi̱ngui̱ hyɛhmʉ na̱ ra̱ hya̱ dí xi'a̱hʉ ya, ma̱jua̱ni̱ ngue gue'a̱hʉ ma̱ xädi'a̱hʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'Nɛ̱ gui pa̱hmʉ xa̱nho na̱ ra̱ hya̱ ma̱jua̱ni̱. Nu̱na̱ ra̱ hya̱ ma̱jua̱ni̱ p'ʉya, guehna̱ da̱ ya̱n'a̱hʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mi̱ da̱hyø ja̱'i̱, bi 'yɛ̱mbi̱: ―Nu̱gähe yø mbom'mɛto gähe ra̱ Abraham. 'Nɛ̱ hi̱nja̱m'mø to xtá̱ øt'e ngue ma̱ hmu̱he. ¿Hanja'a̱ guí̱ mma̱ ngue guí ɛ̱na̱ da̱ ma nhya̱ni̱gähe? ");
INSERT INTO otnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nu̱na̱ ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱ to gä øtra̱ ts'oqui, guehya ya xa̱ mbɛnt'ui ra̱ ts'oqui ya. ");
INSERT INTO otnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nu̱ ra̱ ja̱'i̱ ngue ra̱ hmi̱qui̱tho, 'bʉp'ʉ ja rá̱ ngu̱ rá̱ hmu̱, hi̱ngui̱ za̱mp'ʉ ja ra̱ ngu̱ na̱ ra̱ hmi̱qui̱. Pɛ nu̱'a̱ ngue rá̱ ts'ʉnt'ʉ ra̱ hmu̱, za̱mp'ʉ ja rá̱ ngu̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ja̱na̱ngue nu̱yá, nu̱'mø ngue da̱ ya̱n'a̱hʉ rá̱ Ts'ʉnt'ʉ Oja̱, ya ma̱jua̱ni̱ gá̱ nya̱mhmʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nu̱gä dí pa̱di̱ ngue yø mbom'mɛto'a̱hʉ ra̱ Abraham. Pɛ guí̱ nne gui hyojʉ, porque hi̱nguí̱ nnu̱ ma̱nhohʉ ra̱ hya̱ dí̱ mma̱ngä. ");
INSERT INTO otnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ya dá̱ xi'a̱hʉ te gä dí̱ nnu̱gä p'ʉ bí 'bʉhma̱ Papá. Pɛ nu̱'a̱hʉ ga̱di siguetho guí øthʉ'a̱ te xi'a̱ ni̱ papáhʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mi̱ da̱hyø ja̱'i̱ p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱'a̱ ma̱ papágähe gue'a̱ ra̱ Abraham. Ma̱hømbi̱ 'yɛ̱nna̱ Jesús: ―Nu̱'mø ngue dyø ba̱si̱'a̱hʉ ra̱ Abraham, da̱gue'a̱ te bi 'yøtra̱ Abraham gui 'yøthʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pɛ nu̱ya guí̱ nne gui hyojʉ. Conque dí xi'a̱hʉ ra̱ hya̱ ma̱jua̱ni̱, nu̱na̱ ra̱ hya̱ dí øcä mma̱n'Oja̱, guehna̱ dí xi'a̱hʉ na̱. Pɛ nu̱'a̱ guí̱ nne gui 'yøthʉ ya, hi̱nga̱ ngu̱'a̱ bi 'yøtra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nu̱'a̱hʉ guí øthʉ tengu̱tho ø'ni̱ papáhʉ. Ma̱hømbi̱ 'yɛ̱nyø ja̱'i̱ p'ʉya: ―Nu̱gähe, hi̱ndyø thi̱mba̱si̱tho gähe. N'nat'a ma̱ papágähe 'bʉi, gue'a̱ Oja̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma̱hømbi̱ 'yɛ̱nna̱ Jesús: ―Nu̱'mø ngue nma̱jua̱ni̱ ngue guehna̱ Oja̱ ni̱ papáhʉ, ga̱di̱ ma̱cjʉ 'mø. Porque nu̱gä dá̱ ɛ̱cä p'ʉ 'bʉ Oja̱, 'nɛ̱ ya dí 'bʉcua ya. Hi̱ndá̱ sänsɛ ngue dá̱ ɛ̱cua, sinoque Oja̱ bá̱ bɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Hanja ngue hi̱ngui̱ sä gui ti̱mhmʉ na̱ ra̱ hya̱ dí̱ mma̱ngä? Hi̱ngui̱ ti̱mhmʉ hanja ra̱ hya̱, porque hi̱nguí̱ nne gui 'yøhmʉ na̱ ra̱ hya̱ dí xän'na̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nu̱'a̱ gui̱ nnøpa̱ papáhʉ, gue'a̱ ra̱ zithu̱'a̱. Nu̱'a̱ ra̱ hya̱ nnu̱ ma̱nho na̱ p'ʉya, guehna̱ guí̱ nne gui 'yøthʉ na̱. Nu̱na̱ ra̱ zithu̱, guehna̱ ra̱ hyote na̱ asta̱ guep'ʉ bá̱ fʉdi. Hi̱nja̱m'mø di̱ mma̱n'a̱ te ma̱jua̱ni̱. Nu̱'mø ya̱, gä ra̱ fɛhni̱ ga̱ ya̱. Gä rá̱ hya̱sɛ ga̱ ya̱ porque ra̱ fɛhni̱. 'Nɛ̱ guehna̱ nnøpa̱ papá'ʉ to mma̱nna̱ fɛhni̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pɛ nu̱gä ngue ma̱jua̱ni̱ na̱ ra̱ hya̱ dí xi'a̱hʉ, hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Gätho'a̱hʉ ya, hi̱njonda̱ bøni̱ da 'yɛ̱ngui̱ ngue ja ma̱ ts'oqui. Xi'mø ngue ma̱jua̱ni̱ ra̱ hya̱ dí xi'a̱hʉ, ¿hanja ngue hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nu̱'a̱ rá̱ ba̱si̱ Oja̱ ya, gue'a̱ di ho da̱ 'yøde te mma̱n'Oja̱'a̱. Pɛ nu̱'a̱hʉ ngue hi̱ngyø ba̱si̱'a̱hʉ Oja̱, ja̱na̱ngue hi̱nguí̱ nne gui 'yøhmʉ ra̱ hya̱ mma̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mi̱ da̱hyø judío p'ʉya, bi 'yɛ̱mbra̱ Jesús: ―Ni̱ 'yu̱p'ʉ te dí̱ mma̱ngähe ngue grá̱ mmɛ̱ngu̱ p'ʉ ja ra̱ häi Samaria, nu̱'i̱ guí̱ n'youi ra̱ ts'onthi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Hi̱n teni̱ ts'oqui dí̱ n'yogä'be. Nu̱'a̱ te dí øt'ä, dí̱ nnu̱ ma̱nsu̱gä ma̱ Papá. Pɛ nu̱'a̱hʉ hi̱nguí̱ nnu̱ ma̱nsu̱jʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nu̱gä hi̱ndí̱ honi̱ ha di̱ nu̱ ma̱nsu̱gyø ja̱'i̱. Nu̱na̱ Oja̱ go honngui̱ ha di̱ nu̱ ma̱nsu̱gä yø ja̱'i̱ na̱. 'Nɛ̱ ha̱xta̱ ra̱ güɛnda Oja̱ ya, te'o ngue hi̱ngui̱ su̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nu̱gä ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱ to ørpa̱ ma̱su̱ ra̱ hya̱ dí̱ mma̱ngä, guehna̱ ra̱ ja̱'i̱ hi̱nja̱m'mø da̱ du̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mi̱ da̱hyø judío p'ʉya, bi 'yɛ̱mbi̱: ―A nu̱yá, da̱di seguragähe ya ngue guí̱ n'youi ra̱ ts'onthi̱. Xi ra̱ Abraham 'nɛ̱ gätho mi̱'da yø pønga̱hya̱ xa̱ m'mʉi, gä xa̱ ndu̱. Nu̱'i̱ p'ʉya guí ɛ̱na̱: “Nu̱'a̱ to da̱ 'yørpa̱ ma̱su̱ ra̱ hya̱ dí̱ mma̱ngä, guehna̱ ra̱ ja̱'i̱ hi̱nja̱m'mø da̱ du̱ na̱”, guí ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ua ma̱n'na go ma̱ da̱'i̱ ngue'a̱ ma̱ papágähe Abraham? A nu̱na̱ bi du̱. 'Nɛ̱hyø pønga̱hya̱ xa̱ m'mʉi gä xa̱ ndu̱. ¿Te'o guí ɛ̱na̱ ngue gue'e 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱'mø ngue go gdi honi̱ ha di̱ nu̱ ma̱nsu̱gä yø ja̱'i̱, hi̱nte di̱ mu̱ui 'mø ɛ̱scä yø ja̱'i̱ 'mø. Pɛ nu̱'a̱ honi̱ ha di hnu̱ ma̱nsu̱gä, guehna̱ ma̱ Papágä na̱. Nu̱ná̱ guí ɛ̱na̱ ngue ni̱ Oja̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pɛ hi̱nguí̱ pa̱hmʉ na̱ p'ʉya. Nu̱gä go dí pa̱cä na̱. Nu̱'mø ga̱ ɛ̱na̱ ngue hi̱ndí̱ pa̱cä Oja̱, xquet'a̱ dí fɛhni̱gä 'mø tengu̱tho'a̱hʉ ngue gyø fɛhni̱hʉ. Pɛ nu̱gä ma̱jua̱ni̱ dí pa̱cä na̱, 'nɛ̱ dí ørpa̱ ma̱su̱ te xiqui. ");
INSERT INTO otnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A nu̱na̱ ma̱ mboxitahʉ ra̱ Abraham, bi johya na̱ ngue ma̱mbá̱ ɛ̱p'ʉ ra̱ pa ga̱ søcä ua. Bi ba̱di̱ hanja, ja̱na̱ngue ɛ̱mmɛ̱i̱ bi johya. ");
INSERT INTO otnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mi̱ da̱hyø judío p'ʉya, bi 'yɛ̱mbra̱ Jesús: ―Tobe hi̱nguí̱ 'bʉ'a̱ nyote ma̱'dɛt'a njɛya, 'nɛ̱ go gui 'yɛ̱na̱ gá̱ nu̱ ra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ngue ya nmi̱ 'bʉcä hante di̱ m'mʉhra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bi gʉxyø do yø ja̱'i̱ p'ʉya, ngue da̱ mʉndo ra̱ Jesús. Pɛ ra̱ Jesús bi thop'ʉ ma̱de ha 'bʉhyø ja̱'i̱, bi bømp'ʉ ja ra̱ ni̱ja̱, bi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nu̱p'ʉ ni̱ nthohra̱ Jesús, bi̱ nu̱ n'na ra̱ n'yohʉ ngue ra̱ xädä asta̱ gue'mø ma̱mba̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bi 'yänya yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, ¿hanja ngue ya ra̱ xädä 'mø ma̱mbá̱ mi̱hna̱ ra̱ n'yohʉ na̱? ¿Ndana̱ gue'a̱ ja rá̱ ts'oqui, guehna̱ ra̱ n'yohʉ, ua rá̱ papá, ua gue rá̱ mamá ja rá̱ ts'oqui ngue bi̱ njap'ʉ? ");
INSERT INTO otnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Hi̱n'i̱ nxädä na̱ ra̱ n'yohʉ ngue conná̱ ts'oquisɛ, ogue rá̱ ts'oqui rá̱ papá ogue rá̱ mamá. Sinoque bi̱ nxädä para ngue conná̱ nguehnʉ da̱ fa̱di̱ ngue ja rá̱ ts'ɛdi Oja̱ ngue te da̱ 'yørpe. ");
INSERT INTO otnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mɛ̱nte jap'ʉ ra̱ tiempo ya, jatho ngue ga̱ ørpa̱bi̱ rá̱ 'bɛfi'a̱ to bá̱ pɛnngui̱. Porque da̱ 'yɛ̱hra̱ pa ngue ya hi̱mma̱ nzä te ga̱ pɛfi. ");
INSERT INTO otnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mɛ̱nte dí 'bʉcua ja ra̱ xi̱mhäi, ma ga̱ øt'e ngue da̱ xohyø mmʉi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱, bi zo'a̱ häi rá̱ ji̱ni̱ ra̱ Jesús. Bi 'yøtra̱ bøhäi conná̱ ji̱ni̱, bi gospa̱ ma̱xøts'e yø dä ra̱ xädä. ");
INSERT INTO otnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bi 'yɛ̱mbʉya: ―Ní̱ ma ya, bá̱ nxʉdä p'ʉ ja ra̱ dehe Siloé ―bi 'yɛ̱mbi̱. Nu̱na̱ ra̱ Siloé ga̱ mbøni̱ ngue “Bi 'bɛnhni̱”. Nu̱na̱ ra̱ xädä bi̱ ma bá̱ nxʉdä. Ma̱mbá̱ pengui̱, ya zø yø dä. ");
INSERT INTO otnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A nu̱'ʉ yø besino p'ʉya, 'nɛ̱ hmi̱'da yø ja̱'i̱ ya mi̱ pa̱di̱ ngue ma̱rá̱ xädä, gä di̱ n'yɛ̱mbi̱: ―¿Ua hi̱nga̱ guehna̱ ra̱ nhya̱xa̱ limosna na̱? ");
INSERT INTO otnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mi̱'da yø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Guehnʉ. Pɛ mi̱'da yø ja̱'i̱ bi 'yɛ̱na̱: ―Guehnʉ p'ʉ gui̱ nɛ̱qui̱, pɛ gue hi̱nga̱ guehnʉ. Pɛ nu̱sɛ na̱ ma̱rá̱ xädä p'ʉya, bi 'yɛ̱na̱: ―A̱há̱, go guecä ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ya bi t'ännbʉya, bi t'ɛ̱mbi̱: ―¿Hanja ngue ya zø ni̱ dä ya 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Bi 'yɛ̱nna̱ ma̱rá̱ xädä p'ʉya: ―Nu̱na̱ ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Jesús bi 'yøtra̱ bøhäi. Bi gosca̱gui̱ ma̱ dä. Bi 'yɛ̱ngui̱: “Ni̱ map'ʉ ja ra̱ dehe Siloé, bá̱ nxʉdä”, bi 'yɛ̱ngui̱. Dá̱ magä p'ʉya ngue dá̱ nxʉdä, pɛ 'bexpi̱ nzø ma̱ dä 'mø ma̱ nxʉdä. ");
INSERT INTO otnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bi t'ännbʉya, t'ɛ̱mbi̱: ―¿Hapʉ 'bʉhna̱ ra̱ n'yohʉ guí̱ mma̱nya? Bi 'yɛ̱mbʉya: ―Hi̱ndí̱ pa̱cä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bi ts'ixpʉ 'bʉhyø fariseo na̱ ma̱rá̱ xädä p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ra̱ pa ngue ra̱ ts'äya 'mø mi̱ 'yøtra̱ bøhäi ra̱ Jesús ngue bi xojpa yø dä ra̱ xädä. ");
INSERT INTO otnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nu̱ya yø fariseo p'ʉya, xquet'a̱ bi 'yän'na̱ ma̱rá̱ xädä ngue ha bi̱ nja ngue ya zø yø dä. Bi 'yɛ̱mbʉya: ―Bi gosca̱ ra̱ bøhäi ma̱xøts'e ma̱ dä. Dá̱ ma da̱ nxʉdä p'ʉya. A nu̱yá, ya zø ma̱ dä ya. ");
INSERT INTO otnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bi 'yɛ̱n'ida yø fariseo p'ʉya: ―Nu̱na̱ ra̱ n'yohʉ bi 'yø'na̱ ra̱ hya̱ na̱, hi̱ngrá̱ m'mɛnhni̱ Oja̱ na̱, porque hi̱nguí̱ su̱pra̱ pa ngue ra̱ ts'äya. Mi̱'da p'ʉya, bi 'yɛ̱na̱: ―A nu̱'mø di ja rá̱ ts'oqui na̱ ra̱ n'yohʉ na̱, hi̱nda̱ zä da̱ 'yøtya yø milagro ør'mø. Ya di̱ nju̱n'ma̱hya̱sɛ p'ʉ yø ja̱'i̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma̱hømbi̱ t'än'na̱ ma̱rá̱ xädä p'ʉya, bi t'ɛ̱mbi̱: ―Xi'i n'yø, ¿te guí̱ mma̱ nguehna̱ ra̱ n'yohʉ bi xoc'a̱ ni̱ dä? Nu̱na̱ ma̱rá̱ xädä p'ʉya, bi 'yɛ̱na̱: ―Nu̱gä dí ɛ̱na̱ ngue rá̱ pønga̱hya̱ Oja̱ na̱ ra̱ n'yohʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pɛ yø hmu̱ yø judío, hi̱ngui̱ ɛ̱c'ɛ̱i̱ ngue ma̱rá̱ xädä na̱ ra̱ n'yohʉ ya̱ui. Bi 'yɛ̱c'ɛ̱i̱, ja gue'mø mi̱ zonnba̱bi̱ rá̱ papá 'nɛ̱hra̱ mamá na̱ ma̱rá̱ xädä. ");
INSERT INTO otnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Ua guehna̱ ni̱ ts'ʉnt'ʉui na̱ 'bʉcua, nu̱na̱ t'ɛ̱mbi̱ ngue ya ra̱ xädä 'mø ma̱mbá̱ mi̱? ¿Hanja ngue ya zø yø dä ya 'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bi 'yɛ̱n'a̱ rá̱ papá 'nɛ̱hrá̱ mamá p'ʉya: ―Dí pa̱di̱ ngue guehna̱ ma̱ ts'ʉnt'ʉ'be na̱. 'Nɛ̱ ya ra̱ xädä 'mø ma̱mbá̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pɛ nu̱yá, hi̱ndí̱ pa̱'be hanja ngue ya zø yø dä ya. Ni̱ xi̱ndí̱ pa̱'be to bi 'yøthebi yø dä. Da̱mi̱ 'yänsɛhʉ. Ya ra̱ da̱n'yohʉ, da̱ xi'a̱sɛhʉ hanja. ");
INSERT INTO otnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nu̱na̱ rá̱ papá 'nɛ̱hrá̱ mamá na̱ ma̱rá̱ xädä, bi̱ ma̱nna̱ tengu̱ na̱ ngue su̱pyø hmu̱ yø judío. Porque ya xi̱ nhɛca̱ hya̱ ngue da̱ du̱jpa̱bi̱ rá̱ thu̱hu̱ p'ʉ ja ra̱ ni̱ja̱'a̱ to da̱ ma̱ ngue ra̱ Jesús gue'a̱ ra̱ Cristo'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ja̱na̱ngue ngu̱na̱ bi̱ ma̱n'ʉ yø da̱ja̱'i̱ p'ʉya, ngue bi 'yɛ̱na̱: “'Yänsɛhʉ, ya ra̱ da̱n'yohʉ, da̱ xi'a̱sɛhʉ hanja”. ");
INSERT INTO otnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nu̱'ʉ yø hmu̱ yø judío, ma̱hømbi̱ zon'na̱ ra̱ n'yohʉ ma̱rá̱ xädä. Bi 'yɛ̱mbi̱: ―Hønt'a̱ Oja̱ gui 'yɛ̱spa̱bi̱ ngue bi̱ nzø ni̱ dä. Nu̱gähe dí pa̱hme ngue ja rá̱ ts'oqui na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bi 'yɛ̱n'mø mi̱ da̱ p'ʉya: ―Nu̱gä hi̱ndí̱ pa̱di̱ ngue'mø ja rá̱ ts'oqui ogue hi̱n'na̱. Hønt'a̱ dí pa̱di̱ ngue nu̱gä nma̱rá̱ xädä, 'nɛ̱ ya zø ma̱ dä ya. ");
INSERT INTO otnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma̱hømbi̱ t'ännbʉya, bi t'ɛ̱mbi̱: ―¿Te 'bɛ'a̱ bi ja'i? ¿Te bi 'yøt'e para ngue bi̱ nzø ni̱ dä? ");
INSERT INTO otnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mi̱ da̱ p'ʉya, bi 'yɛ̱na̱: ―Ya xtá̱ xi'a̱hʉ, 'nɛ̱ hi̱nguí̱ ørca̱hʉ ma̱su̱. ¿Hanja ngue ma̱høn'a̱ guí̱ nne ga̱ xi'a̱hʉ ya? ¿Uague guí̱ nne ngue 'nɛ̱'a̱hʉ dyø xädi'a̱hʉ na̱ ra̱ n'yohʉ na̱? ");
INSERT INTO otnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bi zʉ p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱'i̱ go rá̱ xädi'i na̱ ra̱ n'yohʉ na̱. Pɛ nu̱gähe yø xädigähe ra̱ Moisés. ");
INSERT INTO otnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nu̱gähe dí pa̱hme ngue bi̱ nya̱ui Oja̱ ra̱ Moisés. Pɛ nu̱na̱ ra̱ n'yohʉ na̱, hi̱njongui̱ pa̱di̱ hapʉ ra̱ mmɛ̱ngu̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bi 'yɛ̱n'a̱ ra̱ n'yohʉ p'ʉya: ―Xquet'a̱ guehna̱ ngue nná̱ 'yøthogä na̱ya, ngue hi̱nguí̱ pa̱hmʉ hapʉ ra̱ mmɛ̱ngu̱ na̱, pɛ bi xoga̱gui̱ ma̱ dä. ");
INSERT INTO otnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Conque dí pa̱hmʉ ngue nu̱na̱ Oja̱, hi̱ngui̱ ø'mø nzo'ʉ yø ja̱'i̱ ja yø ts'oqui na̱. Pɛ nu̱'mø nzo'ʉ yø ja̱'i̱ tha̱nne 'nɛ̱ ørpa̱bi̱ rá̱ pähä, i øde. ");
INSERT INTO otnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Asta̱ guehyø pa xa̱ thogui hi̱ngui̱ t'øde ngue da̱ bøn'a̱ n'na ra̱ n'yohʉ da̱ xojpa̱ yø dä n'na ra̱ xädä asta̱ gue'mø ma̱mbá̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ngue'mø hi̱ndrá̱ m'mɛnhni̱ Oja̱ na̱ ra̱ n'yohʉ na̱, hi̱nda̱ zä te da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ya bi t'ɛ̱mbʉya: ―Nu̱'i̱ gä ra̱ ts'oqui gni̱ 'bʉi asta̱ gue'mø ga̱mbá̱ mi̱, 'nɛ̱ go gui 'yɛ̱na̱ gui xännga̱he ―bi t'ɛ̱mbi̱. Bi hyøn'a̱ thi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bi ba̱hra̱ Jesús ngue ya bá̱ thøn'a̱ thi p'ʉ ja ra̱ ni̱ja̱ na̱ ma̱rá̱ xädä. Mi̱ nthɛui p'ʉya, bi 'yɛ̱mbi̱: ―¿Ua guí ɛ̱c'ɛ̱i̱bi̱ rá̱ Ts'ʉnt'ʉ Oja̱ n'yø? ");
INSERT INTO otnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bi 'yɛ̱nna̱ n'yohʉ p'ʉya: ―Te'o'a̱ p'ʉya grá̱ hmu̱, n'namhma̱ ga̱ ɛ̱c'ɛ̱i̱gä ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ya guí̱ nnu̱gya. Go guecä dí̱ nya̱ui ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nu̱na̱ ra̱ n'yohʉ p'ʉya bi̱ nda̱ntyøhmu̱ p'ʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ya grá̱ hmu̱, dí ɛ̱c'ɛ̱i̱'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Dá̱ ɛ̱cä ua ja ra̱ xi̱mhäi, n'namhma̱ ngue nu̱'ʉ yø xädä di̱ nzø yø dä. A nu̱'ʉ ɛ̱na̱ ngue zø yø dä p'ʉya, tengu̱tho 'mø di xädä'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nu̱'ʉ 'da yø fariseo mi̱ 'bäp'ʉ p'ʉya, mi̱ 'yøde te mma̱nna̱ Jesús. Bi 'yɛ̱mbi̱: ―¿Ua guí ɛ̱na̱ ngue 'nɛ̱cähe dyø xädägähe? ");
INSERT INTO otnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'mø ngue gyø xädähʉ, hi̱ndi̱ ja ni̱ ts'oquihʉ 'mø. Pɛ nu̱ya ngue guí ɛ̱na̱ ngue zø ni̱ dähʉ, ya guí pa̱di̱ ngue ja ni̱ ts'oquihʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱'a̱ hi̱nni̱ yʉrbʉ ja rá̱ goxthi føt'e yø dɛ'yo, sinoque ni̱ nexma̱n'na nguadi, guehna̱ ra̱ bɛ̱dɛ'yo na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pɛ nu̱'a̱ ni̱ yʉrbʉ ja ra̱ goxthi føt'e, gue'a̱ ra̱ mändɛ'yo'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nu̱'mø bi zøhø, da̱ xojpa̱ ra̱ mängoxthi da̱ yʉt'a̱mbo. Nu̱'ʉ yø dɛ'yo p'ʉya, pa̱rpa̱bi̱ rá̱ hya̱. I̱ nzohyø dɛ'yo conyø thu̱hu̱, da̱ gʉcathi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu̱'mø bá̱ jʉjma̱ xøts'e ra̱ føt'e gätho'ʉ yø dɛ'yo p'ʉya, ní̱ 'bɛt'o p'ʉ ni̱ ma yø dɛ'yo. Yø dɛ'yo p'ʉya tɛnni̱ porque pa̱rpa̱bi̱ rá̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pɛ nu̱'a̱ hi̱ngui̱ pa̱rpa̱bi̱ rá̱ hya̱, hi̱ngui̱ tɛn'na̱. Hante 'da 'mø bi̱ nu̱, porque hi̱ngui̱ pa̱rpa̱bi̱ rá̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Bi hyoni̱ te gui hyɛjpa̱ ra̱ hya̱ bi xihyø ja̱'i̱ ra̱ Jesús. Pɛ nu̱'ʉ nzofo hi̱mbi̱ di̱nyø mmʉi te ni̱ bønna̱ hya̱ bi xifi. ");
INSERT INTO otnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bi sigue bi zohyø ja̱'i̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ, guecä tengu̱tho n'na ra̱ goxthi ni̱ yʉtyø dɛ'yo. ");
INSERT INTO otnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gätho'ʉ yø mädi bi̱ m'mʉ'a̱ m'mɛt'o hante ngue ga̱ ma ɛ̱cä, hi̱nni̱ yʉrbʉ ja ra̱ goxthi, gue'ʉ yø bɛ̱dɛ'yo'ʉ. Ja̱na̱ngue hi̱mbi̱ 'yørpa̱ ma̱ su̱ yø dɛ'yo 'mø nzofo. ");
INSERT INTO otnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Go guecä tengu̱tho n'na ra̱ goxthi. Nu̱'a̱ ga̱ japä da̱ thogui, gue'a̱ di̱ nya̱n'a̱. 'Nɛ̱ da̱ 'yøt'e tengu̱tho n'na ra̱ dɛ'yo ngue ni̱ yʉt'i, ni̱ bømp'ʉ ja rá̱ føt'e, 'nɛ̱ ti̱ni̱ te si. ");
INSERT INTO otnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A nu̱'a̱ ra̱ bɛ̱, høndrá̱ mfɛ̱ ga̱ 'yo'a̱, di ʉmma̱ho dyø dɛ'yo. Pɛ nu̱gä dá̱ ɛ̱hɛ̱ para ngue di̱ nja'a̱hʉ ra̱ 'da'yo te, 'nɛ̱ gui̱ m'mʉmma̱ pähähʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nu̱gä guecä tengu̱tho n'na ra̱ hoga̱ mändɛ'yo. Nu̱'a̱ ra̱ hoga̱ mändɛ'yo ɛnná̱ te ngue nya̱nyø dɛ'yo. ");
INSERT INTO otnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pɛ nu̱'a̱ ra̱ mädi ngue ra̱ hmi̱qui̱tho, hi̱nga̱ gue'a̱ ra̱ mädi ngue yø dɛ'yo'a̱. Porque hi̱ngrá̱ mmɛti. Nu̱'mø bi̱ nu̱ ngue bá̱ ɛ̱p'ʉ ra̱ zate, da̱ zop'ʉ yø dɛ'yo, da̱ 'dagui. Ra̱ zate p'ʉya, di bɛntyø dɛ'yo, di̱ n'uɛn'ʉ hi̱ndi̱ bɛnt'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nu̱na̱ ra̱ n'yohʉ na̱, 'dagui porque ngue ra̱ hmi̱qui̱tho. Hi̱ngui̱ tu̱ rá̱ mmʉi 'mø te da̱ ja yø dɛ'yo. ");
INSERT INTO otnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nu̱gä guecä tengu̱tho n'na ra̱ hoga̱ mändɛ'yo. Nu̱na̱ ma̱ Papágä pa̱cä na̱, nu̱gä xquet'a̱ dí pa̱cä na̱ ma̱ Papá. Njarbʉtho ya, dí pa̱cä gätho'ʉ ma̱ dɛ'yo. Da̱ gue'ʉ p'ʉya, xquet'a̱ pa̱qui̱. 'Nɛ̱ dí ɛngä ma̱ te ngue di̱ nya̱ngä'ʉ ma̱ dɛ'yo. ");
INSERT INTO otnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Xquet'a̱ 'bʉp'ʉ mi̱'da ma̱ dɛ'yo ngue hi̱ngyø n'youi ya 'bʉcua. Xquet'a̱ jatho ngue ga̱ mma si, 'nɛ̱ da̱ 'yø'mø da̱ zofo. Ya n'na 'bʉitho di̱ nja p'ʉya, 'nɛ̱ n'na dra̱ mändɛ'yo di̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nu̱na̱ ma̱ Papá di̱ ma̱cä na̱, porque dí ɛngä ma̱ te conná̱ nguehma̱ dɛ'yo. A nu̱gä da̱ zä ngue ma̱hønga̱ m'mʉi. ");
INSERT INTO otnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pɛ nu̱'mø ga̱ nnegä, hi̱njonda̱ hyogui, pɛ dí̱ nnesɛ ngue dí ɛngä ma̱ te. I ja gra̱ ts'ɛdi ngue da̱di̱ u̱ngä ma̱ te, 'nɛ̱ ja gra̱ ts'ɛdi ngue ma̱hønga̱ m'mʉi. Nu̱na̱ ya, guehna̱ ra̱ hya̱ bi xicä ma̱ Papá na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nu̱'mø mi̱ 'yøhyø judío na̱ ra̱ hya̱ na̱ p'ʉya, ya hi̱nga̱ 'da'igu̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xa̱ngu̱ yø judío bi 'yɛ̱na̱: ―¿Hanja ngue guí ørpa̱hʉ ma̱su̱ te mma̱nna̱? Nu̱na̱ di locobi ra̱ ts'onthi̱ n'youi na̱ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mi̱'da yø judío p'ʉya, bi 'yɛ̱na̱: ―Pɛ nu̱'mø ngue di̱ n'youi ra̱ ts'onthi̱, hi̱nda̱ zä da̱ ma̱ tengu̱ na̱ ra̱ hya̱ na̱ 'mø. A nu̱'a̱ n'youi ra̱ ts'onthi̱, hi̱nda̱ zä da̱ 'yøt'e ngue di̱ nzø yø dä yø xädä'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mi̱ ja yø sɛ'ye'a̱ ra̱ ora'a̱. Ya di̱ nsä yø ja̱'i̱ p'ʉ Jerusalén ngue di̱ nsänni̱go p'ʉ ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nu̱na̱ ra̱ Jesús, nu̱p'ʉ ja ra̱ ngu̱n'yu̱ ni̱ja̱ ni̱ hu̱ ngue ra̱ Salomón, ja 'yop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nu̱'ʉ yø judío bi̱ mäsra̱ Jesús, bi 'yɛ̱mbi̱: ―¿Ua guí̱ nnepe ngue xøgue gä ra̱ tiempo di 'yot'itho ma̱ mmʉigähe? Nu̱'mø ngue gue'e grá̱ Cristo, n'na ndi̱tho da̱mi̱ xicje njua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Ya dí xi'a̱hʉ, pɛ hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ. Nu̱ te gä guí̱ nnu̱hʉ dí øt'ä conná̱ nguehra̱ ts'ɛdi di 'dacä ma̱ Papá, ja di̱ nɛ̱qui̱ p'ʉ na̱ ra̱ hya̱ dí xi'a̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pɛ hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ, porque hi̱nga̱ gue'e ma̱ dɛ'yo'a̱hʉ, tengu̱tho ra̱ hya̱ ya xtá̱ xi'a̱hʉ m'mɛt'o. ");
INSERT INTO otnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nu̱'ʉ ma̱ dɛ'yogä, xa̱ mba̱rca̱tho ma̱ hya̱gä'ʉ. A nu̱gä p'ʉya, xquet'a̱ dí pa̱thogä ndana̱ gue'a̱ ya ma̱ dɛ'yo. Nu̱'mø bi̱ nu̱gä ma̱ dɛ'yo, tɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nu̱gä ga̱ u̱nnä ra̱ 'da'yo te para za̱ntho'ʉ ma̱ dɛ'yo, 'nɛ̱ hi̱nja̱m'mø di̱ m'mɛdi. Porque hi̱njonda̱ guasca̱ p'ʉ ja ma̱ 'yɛ. ");
INSERT INTO otnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nu̱'a̱ ma̱ Papá bi 'dacä'ʉ. Hi̱njo mma̱n'na tengu̱ na̱, 'nɛ̱ hi̱njonda̱ guaspa̱bi̱ p'ʉ ja rá̱ 'yɛ ma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tengu̱tho ma̱ Papágä, xquet'a̱ di̱ njadä p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yø judío p'ʉya, ma̱hømbi̱ go yø do ngue da̱ mʉndo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pɛ mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Ni̱ hmi̱ ni̱ dähʉ hapʉ dí øt'ä xa̱ngu̱ yø cosa xa̱nho conná̱ nguehra̱ ts'ɛdi di 'dacä ma̱ Papá. ¿Ndana̱ gue'a̱ ya yø hya̱ ya ngue gdi pʉndoga̱hʉ ya? ");
INSERT INTO otnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mi̱ da̱hyø judío p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱'ʉ yø cosa xa̱nho guí øt'e, hi̱nga̱ gue'a̱ gdá̱ pʉndo'a̱he'a̱. Sinoque gdá̱ pʉndo'a̱he ngue hi̱nguí̱ su̱pra̱ xu̱di̱ Oja̱, co nu̱na̱ ra̱ hya̱ guí̱ mma̱. Conque nu̱'i̱ grá̱ ja̱'i̱tho tengu̱tho gähe, 'nɛ̱ sä guí ɛ̱na̱ ngue go 'da'igu̱'a̱ui Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―I̱ nt'ot'i p'ʉ ja ra̱ ley guí ca̱hʉ ngue bi 'yɛ̱n'Oja̱: “Nu̱'a̱hʉ, ɛ̱ntho Oja̱'a̱hʉ”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","'Nɛ̱ guí pa̱hmʉ'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, hi̱njonda̱ zä da̱ gøn'a̱ te mma̱mp'ʉ. A nu̱na̱ Oja̱, bi̱ ma̱ ngue nu̱'ʉ yø ja̱'i̱ di fätrá̱ hya̱, tengu̱tho Oja̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Xi'mø ngue bá̱ ɛ̱xcä Oja̱ ngue bá̱ pɛnngä ua ja ra̱ xi̱mhäi, ¿ua da̱ zä gui 'yɛ̱mhmʉ ngue hi̱ndí̱ su̱pä rá̱ xu̱di̱ Oja̱ ngue'mø dí̱ mma̱ ngue rá̱ ts'ʉnt'ʉgui Oja̱? ");
INSERT INTO otnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","A nu̱'mø hi̱ndi̱ sä ga̱ øt'ä yø cosa tengu̱tho ør'ma̱ Papá, 'yo guí ɛ̱c'ɛ̱i̱ga̱hʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pɛ nu̱'mø ngue sä dí øt'e tengu̱tho øt'a̱, ma̱da̱gue'a̱ hi̱nguí̱ ɛ̱c'ɛ̱i̱ga̱hʉ, pɛ da̱mi̱ 'yɛ̱c'ɛ̱i̱ga̱hʉ co nu̱'a̱ te dí øt'e. Ja guí pa̱hmʉ p'ʉ, 'nɛ̱ ja da̱ di̱mp'ʉ ni̱ mmʉihʉ ngue ma̱ Papá dí̱ n'yo'be. ");
INSERT INTO otnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Co nu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, ma̱hømbi̱ ne yø ja̱'i̱ xtí bɛnt'i̱ ngue xta̱ ngot'i, pɛ hi̱mbi̱ zä, porque 'bexpi̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma̱hømbi̱ mengra̱ Jesús ngue i̱ ma ma̱n'na nguadi ra̱ da̱the Jordán, ha ma̱mbi̱ øtra̱ nxixya̱ m'mɛt'o ra̱ Xuua. Ja bá̱ n'yop'ʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Xa̱ndøngu̱ yø ja̱'i̱ bi̱ ma bá̱ nu̱ ra̱ Jesús. Di̱ n'yɛ̱mbyø ja̱'i̱: ―Ma̱jua̱ni̱ ngue ra̱ Xuua hi̱n tema̱ milagro bi 'yøt'e, pɛ nu̱'a̱ te gäma̱ hya̱ bi̱ ma̱nna̱ Xuua conná̱ nguehra̱ Jesús, gä ma̱jua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ja bi 'yɛ̱c'ɛ̱i̱ p'ʉ xa̱ngu̱ yø ja̱'i̱ ra̱ Jesús ngue ma̱jua̱ni̱ guehna̱ ra̱ Cristo na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mi̱ 'bʉ'a̱ n'na ra̱ n'yohʉ ma̱di̱ hyɛ̱nni̱ ni̱ hu̱ ngue ra̱ Lázaro ra̱ mmɛ̱ngu̱ Betania, ja ra̱ hni̱ni̱ mi̱ 'bʉhra̱ Ma̱ya conná̱ ju̱huɛ Marta. ");
INSERT INTO otnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nu̱na̱ ra̱ Ma̱ya, rá̱ nju̱ na̱ ra̱ Lázaro ma̱di̱ hyɛ̱nni̱. Guehna̱ bi du̱xra̱ aceite ma̱zihotho ga̱ yʉni̱ ngue bi gospa̱ yø gua ra̱ Hmu̱ Jesús. 'Nɛ̱ bi du̱jpi̱ conyø xta̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nu̱ya yø nju̱ ra̱ Lázaro, bi̱ mɛnnba̱ ra̱ hya̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, xa̱n'ʉ ni̱ amigo ga̱di̱ nsixui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mi̱ 'yøhna̱ ra̱ hya̱ bi 'bɛnnba̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Pɛ hi̱nga̱ hyɛ̱mbra̱ n'ʉ na̱ ra̱ Lázaro ngue da̱ hyo. Sinoque ja da̱ ba̱p'ʉ yø ja̱'i̱ ngue ma̱guesɛ Oja̱. 'Nɛ̱ da̱ ba̱hyø ja̱'i̱ ngue xquet'a̱ ma̱guesɛ rá̱ Ts'ʉnt'ʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nu̱na̱ ra̱ Lázaro, conna̱ Marta, conna̱ Ma̱ya, n'na ngu̱ n'na, ɛ̱mmɛ̱i̱ ma̱di̱ ma̱hra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma̱da̱gue'a̱ bi 'yøde ngue ma̱di̱ hyɛ̱nni̱, pɛ bá̱ m'mʉhma̱ nyopa p'ʉ ha ma̱mbi̱ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","M'mɛfa p'ʉya, bi 'yɛ̱mbyø xädi: ―Ma ga̱ mmähä ma̱høn'a̱ Judea ya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nu̱'ʉ yø xädi p'ʉya bi 'yɛ̱mbi̱: ―Ague grá̱ xännba̱te, conque ja xma̱ nguehya nne da̱ hyo'i yø hmu̱ yø judío ngue xta̱bá̱ mmʉndo'i, 'nɛ̱ ma̱hønguí̱ nne gdí̱ ma p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Bi hyɛcra̱ hya̱ bi xihyø xädi ra̱ Jesús, ngue tobe hi̱m ma̱ni̱ zønna̱ ora p'ʉ da̱ du̱. Bi 'yɛ̱mbi̱: ―¿Ua hi̱mma̱ jua̱ni̱ ngue 'dɛ'ma̱ yo ora ja ra̱ nyot'i 'mø ma̱ pa? A nu̱'a̱ 'yo ngue ra̱ pa, hi̱nha di fets'e, porque ga̱ 'yo ra̱ nyot'i di yot'ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pɛ nu̱'mø to 'yo xu̱i̱, di fesrá̱ gua, porque hi̱n'yʉ ra̱ nyot'i p'ʉ ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","M'mɛfa p'ʉya, bi 'yɛ̱nna̱ Jesús: ―Nu̱na̱ ma̱ amigohʉ ra̱ Lázaro bí a̱ha̱. Pɛ ga̱ ma ägä ya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nu̱'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, nu̱'mø ngue bi a̱ha̱, ya hi̱nte da̱ ja 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Bi̱ ne xta̱ mma̱nna̱ Jesús ngue ya xi du̱ ra̱ Lázaro, pɛ nu̱p'ʉ i bɛ̱nyø xädi, bi 'yɛ̱mbi̱ ngue mma̱ ngue bi a̱tho. ");
INSERT INTO otnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pɛ njua̱ntho bi̱ ma̱n'a̱ m'mɛfa te nne xta̱ mma̱nna̱ Jesús. Bi 'yɛ̱mbi̱: ―Ya bi du̱ ra̱ Lázaro ya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Para ngue nu̱'a̱hʉ ya, ya xa̱nho ngue hi̱n da̱bi 'bʉcä p'ʉ 'mø mi̱ du̱ ra̱ Lázaro, porque nu̱ya ma̱n'natho gui 'yɛ̱c'ɛ̱i̱ga̱hʉ ya. Nu̱ya ga̱ ma nu̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nu̱na̱ ra̱ Toma t'ɛ̱mbi̱ ngue ra̱ cuate p'ʉya, bi 'yɛ̱mbyø mmi̱xädihʉ: ―Ma 'da gda̱ mmähä ya, n'namhma̱ ngue 'dap'ʉ da̱ni̱ thojʉ nʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bi zøn'a̱ Betania ra̱ Jesús, pɛ ya rá̱ gʉpa xi̱ ma nt'ägui ra̱ Lázaro. ");
INSERT INTO otnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nu̱p'ʉ ja ra̱ hni̱ni̱ Betania, como yo kilómetro ma̱de gui̱ nhyacui Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Xa̱ngu̱ yø judío xi̱ ma ngue ba̱di zɛngua ra̱ Marta conna̱ Ma̱ya, di hojpa̱ yø mmʉi ngue rá̱ i̱da̱ bi du̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nu̱na̱ ra̱ Marta 'mø bi ba̱di̱ ngue ya mmap'ʉ ra̱ Jesús, bi̱ ma bí c'at'ui. Pɛ ra̱ Ma̱ya bi gop'ʉ ja rá̱ ngu̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ra̱ Marta bi 'yɛ̱mbra̱ Jesús: ―Ague grá̱ Hmu̱, nu̱'mø gdi 'bʉcua, hi̱nxta̱ ndu̱ ma̱ i̱da̱gä 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pɛ nu̱gä dí pa̱di̱ ngue di 'da'i Oja̱ te gä gui 'yäpi. ");
INSERT INTO otnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱ ni̱ i̱da̱ di bɛ̱nna̱te'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Bi 'yɛ̱nna̱ Marta p'ʉya: ―A̱há̱, dí pa̱di̱ ngue nu̱'mø ra̱ pa rá̱ nzɛgui, ma̱høndi̱ bɛ̱nna̱te yø ánima. ");
INSERT INTO otnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ra̱ Jesús bi 'yɛ̱na̱: ―Go ga̱ øt'ä ngue di bɛ̱nna̱te yø ánima, 'nɛ̱ ga̱ u̱nna̱ 'da'yo te. Nu̱'a̱ da̱ 'yɛ̱c'ɛ̱i̱gä, ma̱da̱gue'a̱ xta̱ ndu̱, pɛ høndi̱ bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A nu̱yá, nu̱'ʉ yø ja̱'i̱ 'bʉhya 'nɛ̱ ɛ̱c'ɛ̱i̱gui̱, ya hi̱nja̱m'mø da̱ du̱, ya ja ra̱ 'da'yo te yø ja̱'i̱. ¿Ua guí ɛ̱c'ɛ̱i̱ na̱ dí xi'i ya? ");
INSERT INTO otnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ra̱ Marta p'ʉya bi 'yɛ̱na̱: ―A̱há̱, grá̱ Hmu̱, dí ɛ̱c'ɛ̱i̱gä ngue gue'e grá̱ Cristo, rá̱ Ts'ʉnt'ʉ'i Oja̱ nu̱'a̱ mi̱ ja ngue da̱ ɛ̱cua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, nu̱na̱ ra̱ Marta bi̱ ma bá̱ zo rá̱ ju̱huɛ Ma̱ya. Bi xifi njana̱te, bi 'yɛ̱mbi̱: ―Bá̱ ɛ̱p'ʉ ra̱ xännba̱te. Bá̱ pɛn'na̱ ra̱ hya̱ ngue bi̱ nzo'i 'na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nu̱'mø mi̱ 'yøhra̱ Ma̱ya ngue bi ts'ofo, bi̱ nangui̱, bi̱ ma bá̱ nu̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nu̱na̱ ra̱ Jesús, tobe hi̱n ma̱ni̱ yʉt'a̱mbo ra̱ hni̱ni̱, bí 'bärpʉ ha bi̱ nthɛui ra̱ Marta. ");
INSERT INTO otnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mi̱ nu̱ yø ja̱'i̱ ngue bi̱ nangra̱ Ma̱ya, bi bøni̱ n'nahma̱ntho, bi̱ ma. Ja̱na̱ngue xquet'a̱ bi̱ ntɛtyø ja̱'i̱ p'ʉya, ɛ̱mbi̱ ngue bi̱ ma dá̱ nzomp'ʉ bí o ra̱ ánima. ");
INSERT INTO otnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bi̱ ma ra̱ Ma̱ya p'ʉ ma̱mbi̱ 'bähra̱ Jesús. Bi̱ nda̱ntyøhmu̱ p'ʉ ha 'bäi, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, nu̱'mø ngue gdi 'bʉcua, hi̱nxta̱ ndu̱ ma̱ i̱da̱gä 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nu̱'mø mi̱ nu̱ ra̱ Jesús ngue zonna̱ Ma̱ya co 'nɛ̱'ʉ yø judío ni̱ n'youi, bi där'ma̱n'ʉ rá̱ mmʉi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Hapʉ nt'ägui ya? ―bi 'yɛ̱mbi̱. Mi̱ da̱ p'ʉya, bi 'yɛ̱na̱: ―Ague grá̱ Hmu̱, bá̱ ɛ̱hɛ̱ guí̱ nnu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Xquet'a̱ bi̱ nzonna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Di̱ n'yɛ̱mbyø judío p'ʉya: ―Ya guí̱ nnu̱hʉ te øtya. Ja di̱ nɛ̱qui̱ p'ʉya ngue ja̱njua̱ni̱ ngue ma̱di̱ ma̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bi 'yɛ̱n'i 'da yø judío p'ʉya: ―A nu̱ná̱, ngue bi zä bi xojpa̱ yø dä ra̱ xädä, rá̱ nzɛgui xta̱ nzä xta̱ 'yøt'e ngue hi̱nxtá̱ ndu̱ ra̱ Lázaro. ");
INSERT INTO otnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ma̱hømbi̱ där'ma̱n'ʉ rá̱ mmʉi ra̱ Jesús. Bi guarbʉ ja ra̱ 'bido o ra̱ ánima p'ʉya ngue da̱ hya̱jpa̱ ra̱ ndødo nnøpa̱ njo'mi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Bi 'yɛ̱nna̱ Jesús: ―Da̱mi̱ hya̱cjʉ ra̱ do ―bi 'yɛ̱na̱. Bi 'yɛ̱nna̱ Marta nu̱na̱ rá̱ nju̱ ra̱ ánima p'ʉya: ―Ague grá̱ Hmu̱, rá̱ nzɛgui ya yʉnya, porque ya rá̱ gʉpa nt'ägui ya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ua̱ngui̱ dí xi'i ngue nu̱'mø gui 'yɛ̱c'ɛ̱i̱gui̱, guí pa̱ p'ʉya ngue ma̱guesɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mi̱ ma ntha̱qui̱ ra̱ do p'ʉya. Bi̱ nøs'ma̱ya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Ma̱ Papá'i, da̱di ja ma̱mma̱di'i ngue guí ø'mø di̱ nzo'i. ");
INSERT INTO otnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nu̱gä dí pa̱di̱ ngue za̱nt'a̱ guí ø'mø di̱ nzo'i, pɛ dá̱ ma̱ngä na̱ ra̱ hya̱ na̱ n'namhma̱ ngue nu̱ya yø ja̱'i̱ 'bʉcua, da̱ 'yɛ̱c'ɛ̱i̱ ngue go guá̱ pɛnnga̱gui̱ ua. ");
INSERT INTO otnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, bi̱ matra̱ ánima, bi 'yɛ̱mbi̱: ―Ague Lázaro, bá̱ pømp'ʉ guí o ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Bá̱ nangra̱ ánima p'ʉya, bá̱ ɛ̱p'ʉ, bá̱ m'mät'i yø u̱lu yø 'yɛ conyø gua. Rá̱ hmi̱ p'ʉya bá̱ n'youi rá̱ njo'mi̱. Ra̱ Jesús bi 'yɛ̱mbyø ja̱'i̱: ―Da̱mi̱ xʉhmi̱ ya, thøhmi̱ p'ʉya, da̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nu̱ya yø judío mi̱ 'bʉp'ʉ ja rá̱ ngu̱ ra̱ Ma̱ya mi̱ nu̱ te bi 'yøtra̱ Jesús, gue'a̱ i 'yɛ̱c'ɛ̱i̱'a̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pɛ mi̱'da yø judío, bi̱ ma bá̱ xihyø fariseo te bi 'yøtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nu̱ya yø fariseo p'ʉya conyø hmu̱ yø mmäcja̱, co 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o ngue yø judío, bi 'yøtra̱ da̱junta. Di̱ n'yɛ̱mbi̱: ―¿Te 'bɛ'a̱ ja ngue ga̱ øthʉ? Nu̱na̱ ra̱ n'yohʉ na̱, xa̱ndøngu̱ yø milagro øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu̱'mø ngue ga̱ hɛhmʉ p'ʉ, gä yø ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱ te mma̱nna̱. A nu̱'ʉ yø ts'ʉt'abi Roma p'ʉya, da̱ pɛnhyø soldado ngue da̱ dɛ̱mhra̱ ma̱ca̱ ni̱ja̱ ja ua, 'nɛ̱ da̱ 'yøtra̱ sʉi ua ja ma̱ häihʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bi da̱'a̱ n'na nc'ɛ̱i̱ ni̱ hu̱ ngue ra̱ Caifás, guehna̱ ra̱ hmu̱ yø mmäcja̱'a̱ ra̱ jɛya'a̱. Bi 'yɛ̱mbyø ja̱'i̱: ―¿Ua hi̱nguí̱ pa̱hmʉ ha di̱ nja te ga̱ øthʉ ya? ");
INSERT INTO otnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Ua hi̱n ga̱di̱ u̱mhmʉ ra̱ güɛnda hanja? Ma̱n'na xa̱nho ngue n'na nc'ɛ̱i̱tho da̱ du̱ conná̱ nguehyø ja̱'i̱, hi̱nda̱ gue'a̱ ngue di̱ m'mɛdi gätho yø ja̱'i̱ 'bʉcua ja ma̱ häihʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pɛ nu̱na̱ ra̱ Caifás hi̱ngrá̱ hya̱sɛ na̱ ra̱ hya̱ bi̱ ma̱, sinoque Oja̱ bi bɛ̱nnbi̱ ngue ngu̱'a̱ bi̱ ma̱. Porque guehna̱ ra̱ jɛya ngue bi̱ nøpa̱ hmu̱ yø mmäcja̱. Bi̱ ma̱ ngue ra̱ Jesús guehna̱ ja ngue da̱ du̱ conná̱ nguehyø judío na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'Nɛ̱ hi̱nga̱ hønt'ʉ yø judío p'ʉya, sinoque da̱ du̱ conná̱ nguehyø ja̱'i̱ 'bʉi ndap'ʉ bi zä. Porque nne Oja̱ ngue ndap'ʉ bi zä di̱ m'mʉhyø ja̱'i̱ ngue dyø ba̱si̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gue'a̱ ra̱ hya̱ bi̱ nja'a̱ p'ʉya, nu̱'ʉ yø judío mi̱ nts'ʉt'abi, bi̱ mʉdi bi̱ nhɛca̱ hya̱ ngue da̱ hyo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ja̱na̱ngue ya hi̱m ma̱mbi̱ zøp'ʉ ha 'bʉhyø judío ra̱ Jesús, sinoque bi̱ ma n'nanni̱ n'na ra̱ xɛqui ja ra̱ häi Judea. Ya mmɛ ra̱ nenda̱po, ja n'na ra̱ hni̱ni̱ ni̱ hu̱ ngue Efraín. Ja bá̱ m'mʉhmʉ p'ʉ p'ʉya co 'nɛ̱hyø xädi. ");
INSERT INTO otnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ya xmá̱ nguerp'ʉtho ra̱ pa ngue ra̱ ngo øtyø judío, nu̱na̱ ɛ̱mbi̱ ra̱ pascua. Xa̱ngu̱ yø ja̱'i̱ bi̱ ma Jerusalén ngue dí hocyø ts'oqui p'ʉ ja ra̱ ni̱ja̱ hante di̱ nja ra̱ ngo. ");
INSERT INTO otnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","I 'yo yø ja̱'i̱ p'ʉya, ngue honna̱ Jesús. Nu̱'mø bi zømp'ʉ ni̱ja̱ di̱ n'yänni̱ n'na ngu̱ n'na, i ɛ̱na̱: ―¿Tep'ʉ gni̱ bɛ̱mhmʉ? ¿Ua da̱ ɛ̱cua ja ra̱ ngo ra̱ Jesús, ua gue hi̱n'na̱? ");
INSERT INTO otnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nu̱'ʉ yø fariseo p'ʉya, co 'nɛ̱'ʉ yø hmu̱ yø mmäcja̱, ya xi xihyø ja̱'i̱ ya p'ʉya, ngue nu̱'mø to da̱ ba̱di̱ ha bí 'bʉhra̱ Jesús, da̱ ma̱. Porque bi̱ ne di 'bɛntra̱ Jesús ngue da̱ got'i. ");
INSERT INTO otnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ma̱n'nato ma̱ patho di̱ nja ra̱ ngo ngue ra̱ pascua. Bi̱ ma ra̱ Jesús bá̱ søn'a̱ Betania rá̱ ngu̱ ra̱ Lázaro. Guehna̱ ra̱ Lázaro bi 'yøtra̱ Jesús ngue bi bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ja bá̱ t'ørpa̱ p'ʉ ra̱ nts'i̱hmɛ̱ ra̱ Jesús, bi̱ n'ui̱te ra̱ Marta. Conna̱ Lázaro 'dap'ʉ hu̱hmi̱ p'ʉ ja ra̱ mɛ̱xa ngue si̱hmɛ̱ui. ");
INSERT INTO otnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nu̱na̱ ra̱ Ma̱ya p'ʉya bá̱ ha̱ ma̱de litro ra̱ aceite ma̱hotho ga̱ yʉni̱, pɛ xa̱ndømma̱di̱ rá̱ mu̱ui. Bi gospa̱bi̱ yø gua ra̱ Jesús, bi du̱jpi̱ conyø xta̱. Bi yu̱'a̱mbo ra̱ ngu̱'a̱ ga̱ yʉnna̱ aceite. ");
INSERT INTO otnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mi̱ 'bʉp'ʉ ra̱ Judas Iscariote rá̱ ts'ʉnt'ʉ ra̱ Simu̱. Guehna̱ n'na nc'ɛ̱i̱ yø xädi ra̱ Jesús, 'nɛ̱ guehna̱ bi dä na̱. Nu̱na̱ ra̱ Judas bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Hanja ngue hi̱mbi̱ 'bä ra̱ aceite, ngue xtí t'u̱nna̱ mɛ̱nyʉ yø hyoya? Porque xtí 'bä ra̱ aceite'a̱ te pøxi hyu̱ ciento ma̱ pa ra̱ nzäbi. ");
INSERT INTO otnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pɛ nu̱na̱ ra̱ Judas hi̱n'i̱ mma̱nna̱ ra̱ hya̱ na̱ ngue di tu̱ rá̱ mmʉi da̱ mäxyø hyoya. Sinoque bi̱ ma̱nna̱ ra̱ hya̱ na̱ ngue ra̱ bɛ̱. Porque go ma̱fäti ra̱ buxa cʉ ra̱ mɛ̱nyu̱ na̱. I pɛ̱ ra̱ mɛ̱nyu̱ njäti p'ʉ ja ra̱ buxa. ");
INSERT INTO otnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Da̱mi̱ hyɛ̱mhma̱, 'yo te guí̱ mma̱. Porque nu̱na̱ ra̱ xisu guí sʉi, ya mi̱ pɛsra̱ aceite xta̱ ngosca̱ ma̱ do'yo 'mø dá̱ n'yägui. ");
INSERT INTO otnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A nu̱ya yø hyoya guí̱ mma̱, jap'ʉ ra̱ pa gui fäxhʉ ya, porque 'daua guí 'bʉhmʉ ya yø hyoya. Pɛ nu̱gä ya hi̱mma̱ ya'atho ra̱ pa dí̱ n'yohʉ ua. ");
INSERT INTO otnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Xa̱ngu̱ yø judío bi̱ ba̱di̱ ngue bí 'bʉp'ʉ Betania ra̱ Jesús. Bi̱ ma yø ja̱'i̱ bá̱ nu̱. Pɛ hi̱nga̱ høntho nne yø ja̱'i̱ ngue da̱ nu̱ ra̱ Jesús, sinoque xquet'a̱ nne da̱ nu̱ ra̱ Lázaro nu̱na̱ xi japi xi bɛ̱nna̱te p'ʉ ma̱nt'ägui. ");
INSERT INTO otnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ja̱na̱ngue bi̱ nhɛca̱hya̱ yø hmu̱ yø mmäcja̱ ngue xta̱ hyo ra̱ Lázaro conna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porque nu̱'a̱ i bɛ̱nna̱te ra̱ Lázaro, ya hɛp'ʉ yø mmi̱judíoui yø judío p'ʉya ngue go ɛ̱c'ɛ̱i̱ ra̱ hya̱ mma̱nna̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nu̱p'ʉ ja ra̱ hni̱ni̱ Jerusalén, xa̱ndøngu̱ yø ja̱'i̱ bi̱ ma da̱ nsänni̱go ngue ra̱ pascua. Ja bi ba̱hyø ja̱'i̱ 'mø mi̱ hyats'i, ngue ya ja ngue da̱ zøp'ʉ ja ra̱ hni̱ni̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yø ja̱'i̱ p'ʉya, bi dʉjpa̱ yø xi yø palma, bi̱ ma di c'at'ui ra̱ Jesús. Bi̱ mʉhra̱ hmafi yø ja̱'i̱ p'ʉya, i ɛ̱na̱: ―Nu̱na̱ rá̱ m'mɛnhni̱ Oja̱ 'bʉcua, guehna̱ ta̱te na̱. Oja̱ di ja̱phna̱ rá̱ da̱st'abi yø judío bá̱ 'bɛnhni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Bi di̱n'a̱ n'na ra̱ burru bi hyu̱xra̱ Jesús. Ya bi̱ nja tengu̱tho nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ague gyø mmɛ̱ngu̱hʉ p'ʉ ja ra̱ hni̱ni̱ Sión, 'yogui su̱hʉ. Gui̱ nnu̱ ngue bá̱ ɛ̱p'ʉ ni̱ da̱st'abihʉ, bá̱ hyu̱xa̱ n'na ra̱ burru”. ");
INSERT INTO otnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nu̱p'ʉ rá̱ mʉdi hi̱ngui̱ pa̱hyø xädi ra̱ Jesús hanja'a̱ te øt'e. Pɛ nu̱'mø mi̱ ma ma̱hɛ̱ts'i̱ ra̱ Jesús, ja bi zo yø mmʉi p'ʉya, ngue nu̱'a̱ te gäma̱ hya̱ xi̱ nja, ya ma̱nt'ot'i ngue ngu̱'a̱ ja ngue di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nu̱ya yø ja̱'i̱ n'youi ra̱ Jesús, guehya bi̱ nu̱p'ʉ bi japi bi bɛ̱nna̱te ra̱ Lázaro, gä mma̱nyø ja̱'i̱ te gä xi̱ nu̱rpi̱ ngue øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ja̱na̱ngue bi̱ ma yø ja̱'i̱ ngue di c'at'ui ra̱ Jesús, porque pa̱hyø ja̱'i̱ ngue nu̱'a̱ ra̱ milagro xi 'yøt'e, hi̱njonda̱ zä da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yø fariseo p'ʉya, di̱ n'yɛ̱msɛbi̱: ―Ya guí̱ nnu̱hʉ ya, ya hi̱ngui̱ sä te ga̱ øthʉ. Guí̱ nnu̱hʉ ngue gä ni̱ mɛ yø ja̱'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nu̱ya yø ja̱'i̱ bi̱ ma Jerusalén ngue da̱ tha̱nne Oja̱ 'mø bi̱ nja ra̱ ngo, n'youi p'ʉ 'da yø mmɛ̱ngu̱ Grecia. ");
INSERT INTO otnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nu̱ya p'ʉya bi guarbʉ 'bähra̱ Lipe nu̱na̱ ra̱ mmɛ̱ngu̱ Betsaida ngue ra̱ häi Galilea. Bi 'yäpra̱ ma̱te p'ʉya, bi 'yɛ̱mbi̱: ―Ague n'yø, dí̱ nne ga̱ nya̱gähe ts'ʉ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nu̱na̱ ra̱ Lipe p'ʉya, bi xihra̱ Andre'a̱ te sifi. Nu̱na̱ ra̱ hya̱ bi sifi, 'da i̱ matho gä yoho ngue bá̱ xihra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nu̱na̱ ra̱ Jesús bi 'yɛ̱ntho 'mø mi̱ da̱di̱: ―Nu̱ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, ya ni̱ ma da̱ zønna̱ pa p'ʉ da̱ hnu̱ ngue ma̱guesɛ. ");
INSERT INTO otnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue nu̱gä, ja ngue da̱ thogui, n'namhma̱ ngue xa̱ngu̱ yø ja̱'i̱ da̱ di̱nna̱ 'da'yo te. Tengu̱tho n'na zihmu̱dä ra̱ trigo, mɛ̱nte hi̱nga̱ nthu̱hu̱ ra̱ hmu̱dä, xquetho n'na mhmu̱dä tho i ja. Pɛ nu̱'mø ya bi thu̱hu̱, da̱ bøxra̱ hmu̱dä, pɛ ya xa̱ngu̱ yø trigo da̱ ma ma̱ pɛti 'mø bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nu̱ ra̱ ja̱'i̱ honi̱ ha di̱ mpommi̱ ra̱ nda̱te, guehna̱ di 'bɛhrá̱ te na̱. Pɛ nu̱ ra̱ ja̱'i̱ ɛnná̱ te ua ja ra̱ xi̱mhäi, guehna̱ di t'u̱nna̱ 'da'yo te para za̱ntho na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nu̱ ra̱ ja̱'i̱ nne da̱ 'yørca̱gui̱ ma̱ pähä, da̱ dɛnngui̱. Nu̱p'ʉ ha ga̱ m'mʉcä, ja di̱ m'mʉp'ʉ. Nu̱ ra̱ ja̱'i̱ da̱ 'yørca̱gui̱ ma̱ pähä, guehna̱ nnu̱ ma̱nho ma̱ Papágä na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","A nu̱yá, hi̱ndí̱ pa̱di̱ te ga̱ øtya. ¿Teni̱ 'bɛ'a̱ ja ngue ga̱ mma̱? Ya hi̱ngui̱ sä ngue ga̱ ɛ̱na̱: “Ma̱ Papá'i, da̱mi̱ ya̱ngui̱ ngue'a̱ te ja ngue ga̱ thogui”, ga̱ ɛ̱na̱. Porque ya dá̱ ɛ̱cä'a̱, ngue nu̱'a̱ te ja ngue ga̱ thogui, ga̱ thomhma̱gä'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bi 'yɛ̱mp'ʉya: ―Ague ma̱ Papá'i, da̱ fa̱di̱ ngue ma̱gue'a̱sɛ'i ya. Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi t'øde ngue bá̱ nya̱ Oja̱ ma̱ya̱, bi 'yɛ̱na̱: ―Ya xa̱ nja'a̱ te di fa̱di̱ ngue ma̱guecsɛgui. Pɛ ma̱hønga̱ øt'e ngue da̱ fa̱di̱ ngue ma̱guecsɛgui ya. ");
INSERT INTO otnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nu̱'ʉ yø ja̱'i̱ mi̱ 'bäp'ʉ, bi 'yøde ngue bá̱ nya̱ Oja̱ ma̱ya̱, pɛ ɛ̱mthobi ngue ra̱ ngäni̱'a̱ øde. Mi̱'da yø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Rá̱ anxɛ Oja̱ i̱ nzohnʉ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱mbyø ja̱'i̱: ―Nu̱na̱ ra̱ hya̱ bi t'øhya, hi̱mma̱ partegä p'ʉ ngue bi t'øhna̱ ya, sinoque ni̱ partehʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ya ni̱ ma da̱ zønna̱ ora da̱ tha̱xra̱ güɛnda ua ja ra̱ xi̱mhäi ya. Da̱ thɛjpa̱ rá̱ hya ra̱ zithu̱ di̱ ma̱nda ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nu̱'mø bi̱ ma ma̱'bä'mi̱ ra̱ pont'i̱ da̱ n'nø'mi̱gä, ndap'ʉ bi zä, da̱ dɛnyø ja̱'i̱ ma̱ hya̱gä. ");
INSERT INTO otnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Bi̱ ma̱nna̱ ra̱ hya̱ na̱, ngue di opa̱n'yu̱ yø ja̱'i̱ tema̱ forma di du̱ 'mø bi tho. ");
INSERT INTO otnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bi 'yɛ̱nyø ja̱'i̱ p'ʉya: ―Ya xtá̱ øcähe te nt'ot'i p'ʉ ja ra̱ libro ngue ra̱ ley, ngue ra̱ Cristo i 'bʉi para za̱ntho. 'Nɛ̱ nu̱'i̱ guí ɛ̱na̱ ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, i ja ngue da̱ ma ma̱cuati ra̱ pont'i̱. ¿Ndana̱ gue'a̱'a̱ ra̱ n'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ guí̱ mma̱m'mø? ");
INSERT INTO otnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱yá, ya mi̱ts'ʉ dra̱ pa gui hɛ̱thʉ ua'a̱ ja ngue da̱ xoc'a̱ ni̱ mmʉihʉ ya. Nu̱'mø bi di̱ni̱ xa̱nho ni̱ mmʉihʉ na̱ ra̱ hya̱ dí xi'a̱hʉ ya, guehna̱ ra̱ hya̱ gdi̱ n'yohʉ na̱. Pɛ nu̱na̱ ra̱ ja̱'i̱ hi̱nda̱ ne da̱ 'yøt'e te dí̱ mma̱ngä, guehna̱ ra̱ ja̱'i̱ hi̱ngui̱ pa̱di̱ te ga̱ 'yo na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Da̱mi̱ 'yɛ̱c'ɛ̱i̱hʉ na̱ ra̱ hya̱ da̱ xoc'a̱ ni̱ mmʉihʉ mɛ̱nte da̱ zä ga̱ xi'a̱hʉ ha di xohni̱ mmʉihʉ. 'Nɛ̱ ma̱jua̱ni̱ da̱ xoc'a̱ ni̱ mmʉihʉ na̱ ra̱ hya̱ na̱. Mi̱ juadi bi̱ ma̱nya yø hya̱ ya p'ʉya, bi̱ ma ra̱ Jesús, hi̱ngui̱ fa̱di̱ ha i̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ma̱da̱gue'a̱ xa̱ngu̱ yø milagro bi̱ nu̱ yø ja̱'i̱ bi 'yøtra̱ Jesús, pɛ hi̱ngui̱ ɛ̱c'ɛ̱i̱ te xifi. ");
INSERT INTO otnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pɛ ya ja ngue da̱ ngu̱'a̱ di̱ nja, tengu̱tho ra̱ hya̱ bi 'yotra̱ pønga̱hya̱ Isaías ngue bi 'yɛ̱na̱: “Ague grá̱ Hmu̱, ¿ndana̱ gue'a̱ bi bøni̱ ngue bi 'yɛ̱c'ɛ̱i̱ na̱ ra̱ hya̱ dá̱ xicähe ya? ¿Ndana̱ gue'a̱ pøni̱ ngue da̱ ba̱di̱ ngue ya u̱hrá̱ ts'ɛdi Oja̱ ya?” ");
INSERT INTO otnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ra̱ Isaías xquet'a̱ bi 'yot'i hanja ra̱ hya̱ ngue hi̱mbi̱ 'yɛ̱c'ɛ̱i̱ ra̱ hya̱ yø ja̱'i̱, bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nu̱na̱ Oja̱ bi gorpa̱bi̱ yø nthandi̱ yø ja̱'i̱, n'namhma̱ ngue hi̱nda̱ hyɛ̱ti̱ conyø dä. 'Nɛ̱ bi gorpa̱bi̱ yø mmʉi, n'namhma̱ ngue hi̱nda̱ di̱mp'ʉ ja yø mmʉi hanja ra̱ hya̱. 'Nɛ̱ hi̱ndi̱ 'bätyø mmʉi ngue da̱ dɛn'Oja̱ para ngue hi̱ndi̱ pu̱nnbi̱”. ");
INSERT INTO otnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ra̱ Isaías bi̱ ma̱nna̱ ra̱ hya̱ na̱, ngue pa̱rpi ngue ma̱guesɛ ra̱ Jesús, ja̱na̱ngue bi̱ ma̱ hanja'a̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Co ngu̱'a̱ xa̱ngu̱ yø judío ja yø cargo bi 'yɛ̱c'ɛ̱i̱ ra̱ Jesús. Nja hi̱ngui̱ xihyø ja̱'i̱ ngue ɛ̱c'ɛ̱i̱, porque su̱ yø fariseo, i̱ nne ngue hi̱nda̱ du̱jpa̱ yø thu̱hu̱ p'ʉ ja ra̱ ni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","I ɛ̱na̱ ngue ma̱n'na xa̱nho ngue da̱ nu̱ ma̱nho yø ja̱'i̱, hi̱nda̱ gue'a̱ ngue Oja̱ da̱ 'yɛ̱mbi̱ ngue xa̱nho te øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nu̱na̱ ra̱ Jesús bi ts'ɛdi bi̱ nya̱, bi 'yɛ̱na̱: ―Nu̱ ra̱ ja̱'i̱ ɛ̱c'ɛ̱i̱gä ya, hi̱nga̱ høngthogui ɛ̱c'ɛ̱i̱gui̱ ra̱ ja̱'i̱, sinoque xquet'a̱ ɛ̱c'ɛ̱i̱'a̱ ma̱ Papá bá̱ pɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nu̱ ra̱ ja̱'i̱ hɛ̱rcä ya, tengu̱tho 'mø go di hɛ̱t'a̱ to bá̱ pɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nu̱gä guecä ga̱ xoc'a̱ ni̱ mmʉihʉ. Dá̱ ɛ̱cä ua ja ra̱ xi̱mhäi, n'namhma̱ ngue nu̱'a̱ da̱ 'yɛ̱cɛ̱i̱gä, hi̱ndi̱ m'mʉi tengu̱tho ga̱ 'bʉhyø ja̱'i̱ 'yo ma̱nts'o. ");
INSERT INTO otnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","A nu̱yá, i 'bʉi to øhra̱ hya̱ dí̱ mma̱ngä ya, pɛ hi̱ngui̱ ørpa̱ ma̱su̱. Ya hi̱mma̱ partegä p'ʉ da̱ ma ra̱ castigo ra̱ ja̱'i̱. Porque hi̱ndá̱ ɛ̱cä ngue 'bexca̱ sänni̱ da̱ ma ra̱ castigo yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi, sinoque dá̱ ɛ̱hɛ̱ ngue ga̱ nya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","A nu̱yá, nu̱ ra̱ ja̱'i̱ hi̱ngui̱ ørca̱ ma̱su̱, 'nɛ̱ hi̱ngui̱ ørpa̱ ma̱su̱ na̱ ra̱ hya̱ dí̱ mma̱ngä, guehna̱ ra̱ ja̱'i̱ da̱ ma ra̱ castigo na̱. Nu̱na̱ ra̱ hya̱ dí̱ mma̱ngä ya, guehna̱ di ts'ännba̱bi̱ ra̱ castigo yø ja̱'i̱ 'mø ra̱ pa rá̱ nzɛgui na̱, ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱ yø ja̱'i̱ te dí̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porque hi̱mma̱ hya̱sɛ dí̱ mma̱. Nu̱'a̱ ma̱ Papá bá̱ pɛnngui̱, nu̱na̱ ra̱ hya̱ di 'bɛjpi ga̱ mma̱, guehna̱ ra̱ hya̱ dí xän'na̱hʉ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Pɛ dí pa̱cä p'ʉya, ngue nu̱ to da̱ 'yɛ̱c'ɛ̱i̱ na̱ ra̱ hya̱ di 'bɛjpa̱gui̱ ma̱ Papá ga̱ mma̱, di̱ nja ra̱ 'da'yo te ra̱ ja̱'i̱. Nu̱na̱ ra̱ hya̱ xijma̱ Papá ga̱ mma̱, guehna̱ ra̱ hya̱ dí̱ mma̱ngä na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hante di̱ nja ra̱ ngo ngue ra̱ pascua, nu̱na̱ ra̱ Jesús ya pa̱di̱ ngue ya bi zønna̱ ora da̱ bøngua ja ra̱ xi̱mhäi, di̱ ma ma̱hɛ̱ts'i̱ bí 'bʉhrá̱ Papá. Nu̱na̱ ra̱ Jesús hi̱nha rá̱ nzɛgui di̱ ma̱'ʉ yø xädi 'bʉcua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Ra̱ zithu̱ ya xi bɛnnba̱ rá̱ mmʉi ra̱ Judas Iscariote nu̱na̱ rá̱ ts'ʉnt'ʉ ra̱ Simu̱ ngue di dä ra̱ Jesús. Nu̱na̱ ra̱ Jesús, ya pa̱di̱ ngue bi 'yɛ̱p'ʉ bí 'bʉ Oja̱, 'nɛ̱ ma̱høndi̱ map'ʉ bí 'bʉ Oja̱. 'Nɛ̱ pa̱di̱ ngue nu̱'a̱ rá̱ Papá, di u̱nna̱ ts'ɛdi ngue di̱ ma̱nda gätho yø cosa i ja. ");
INSERT INTO otnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mɛ̱nte si̱hmɛ̱ p'ʉya, bi̱ nangbʉ ja ra̱ mɛ̱xa mi̱ hu̱di̱, bi̱ møhrá̱ tu̱hu̱, bi̱ ngʉt'a̱ n'na ra̱ toaya p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bi xitra̱ dehe p'ʉ ja n'na ra̱ bandeja, bi̱ merpa̱ yø gua yø xädi. I du̱jpa̱ ra̱ dehe conna̱ toaya di̱ ngʉt'i. ");
INSERT INTO otnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nu̱'mø ya mmap'ʉ da̱ merpa̱ yø gua ra̱ Bɛdu p'ʉya, ra̱ Bɛdu bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿ua 'nɛ̱cä gui perca̱gui̱ ma̱ guagä? ");
INSERT INTO otnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―A nu̱yá, hi̱nguí̱ pa̱di̱ te ga̱ mbøn'a̱ te dí øt'ä ya, pɛ gui pa̱'a̱ m'mɛfa te ga̱ mbøni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―A nu̱gä hi̱nda̱ zä gui perca̱ ma̱ gua. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbra̱ Bɛdu: ―Nu̱'mø ngue hi̱nga̱ pet'a̱ ni̱ gua, ya hi̱mma̱ n'youi 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Bi 'yɛ̱nna̱ Bɛdu p'ʉya: ―Ague grá̱ Hmu̱, hi̱nga̱ hørma̱ gua gui perca̱gui̱ 'mø, gui pega̱gui̱ ma̱ 'yɛ 'nɛ̱ gui hiqui. ");
INSERT INTO otnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Nu̱ ra̱ ja̱'i̱ ya m'met'e, ya bi bo gä rá̱ do'yo. Ya hi̱nda̱ høndyø gua ja ngue da̱ 'berpa̱bi̱ ra̱ ja̱'i̱. Ya gä m'meque'a̱hʉ ngue ra̱ nts'o, hi̱nda̱ hønda̱ n'na'a̱hʉ ngue hi̱nga̱ m'meque. ");
INSERT INTO otnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bi̱ ma̱nna̱ ra̱ hya̱ na̱ ngue hi̱nga̱ gätho m'mequebi yø mmʉi yø xädi ngue ra̱ nts'o, porque pa̱di̱ ndana̱ gue'a̱ ja ngue di dä. ");
INSERT INTO otnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mi̱ juadi bi̱ mejpa̱ yø gua yø xädi p'ʉya, ma̱hømbi̱ hye rá̱ tu̱hu̱ ra̱ Jesús. Bi̱ mi̱p'ʉ ja ra̱ mɛ̱xa ma̱høn'a̱ p'ʉya. Bi 'yɛ̱mbi̱: ―¿Ua guí pa̱di̱ te dá̱ øt'a̱hʉ ya? ");
INSERT INTO otnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nu̱'a̱hʉ guí ɛ̱njʉ ngue drá̱ xännba̱tegä, 'nɛ̱ drá̱ hmu̱gä. Pɛ gue ni̱ 'yu̱p'ʉ te guí xicjʉ, porque go guecä drá̱ xännba̱tegä 'nɛ̱ drá̱ hmu̱gä. ");
INSERT INTO otnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A nu̱'mø ngue drá̱ xännba̱tegä 'nɛ̱ drá̱ hmu̱gä, 'nɛ̱ dí pet'a̱ ni̱ guahʉ, xquet'a̱ nne ngue guí̱ njahʉ p'ʉya. Guí̱ mpejpa̱ ni̱ gua n'na ngu̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nu̱gä, ya dá̱ u̱t'a̱hʉ te ja ngue gui 'yøthʉ, n'namhma̱ ngue tengu̱tho dá̱ øt'a̱hʉ ya, da̱ ngu̱'a̱ gui̱ n'yørpe n'na ngu̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ma̱jua̱ni̱ dí xi'a̱hʉ, ngue n'na ra̱ mɛfitho, 'yo di ɛ̱na̱ ngue hi̱nda̱ zä da̱ 'yøt'e tengu̱ øtrá̱ hmu̱. Nu̱'a̱ n'na ra̱ m'mɛnhni̱, 'yo di ɛ̱na̱ ngue hi̱nda̱ zä da̱ 'yøt'e tengu̱ øt'a̱ to pɛnhni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nu̱'mø ngue ti̱nni̱ mmʉihʉ ya yø hya̱ dí xi'a̱hʉ gui 'yɛ̱t'a̱ mmʉihʉ ya, ra̱ mmɛ̱nthi̱ gá̱ nthɛhʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nu̱ te dí̱ mma̱ngä ya, hi̱nga̱ gätho di toca'a̱hʉ na̱ ra̱ mmɛ̱nthi̱ na̱. Porque dí pa̱di̱ te'o ya xta̱ huanhni̱, gue'ʉ di tocabi'ʉ. Pɛ jatho ngue di̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Nu̱na̱ 'daua dí si̱hmɛ̱gä'be ya, guehna̱ 'bʉi ngue ma̱ nsʉigä'be na̱”. ");
INSERT INTO otnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Dí xi'a̱hʉ na̱ ra̱ hya̱ na̱ hante ngue di̱ nja, n'namhma̱ ngue nu̱'mø bi̱ nja p'ʉya, gui 'yɛ̱c'ɛ̱i̱hʉ ngue go guecä. ");
INSERT INTO otnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue nu̱ ra̱ ja̱'i̱ di u̱nna̱ säya'a̱ to dí pɛnhnä, tengu̱tho 'mø go da̱di 'dacra̱ ts'äya ra̱ ja̱'i̱. Nu̱ to di 'dacä ra̱ ts'äya p'ʉya, tengu̱tho 'mø go da̱di̱ u̱nna̱ ts'äya'a̱ to bá̱ pɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, bi zä ngue tär'ma̱n'ʉ rá̱ mmʉi ra̱ Jesús. Bi̱ ma̱ njua̱ntho p'ʉya, bi 'yɛ̱na̱: ―Ma̱jua̱ni̱ dí xi'a̱hʉ ya, ngue 'bʉcua n'na nc'ɛ̱i̱ jʉga̱tho häi, ya honi̱ ha di japi ngue di dägui. ");
INSERT INTO otnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nu̱'ʉ yø xädi p'ʉya bi̱ mʉdi di̱ nhyɛ̱ti̱ n'na ngu̱ n'na, hi̱ngui̱ fa̱di̱ te'o sihna̱ ra̱ hya̱ i hma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nu̱'a̱ n'na nc'ɛ̱i̱ 'dap'ʉ hu̱hmi̱ ngue si̱hmɛ̱ui ra̱ Jesús, guehna̱ rá̱ xädi ɛ̱mmɛ̱i̱ di̱ ma̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ra̱ Bɛdu p'ʉya, bi 'yørpa̱ ra̱ senya'a̱ 'dap'ʉ hu̱hmi̱ ra̱ Jesús ngue da̱ 'yänni̱ te'o na̱ i̱ mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nu̱'a̱ bi t'ørpa̱ ra̱ senya p'ʉya, ma̱n'na bi guarbʉ hu̱ ra̱ Jesús ngue bi 'yänni̱, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿te'o na̱ guí̱ mma̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Ma ga̱ pocä n'na xɛqui ra̱ thu̱hmɛ̱ ya. Nu̱na̱ ga̱ u̱nnä p'ʉya, guehna̱ dí̱ mma̱ngä na̱. Bi po'a̱ n'na xɛqui ra̱ thu̱hmɛ̱ p'ʉya, bi u̱nna̱ Judas Iscariote rá̱ ts'ʉnt'ʉ ra̱ Simu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nu̱na̱ ra̱ Judas, ngu̱ i hya̱nna̱ ra̱ thu̱hmɛ̱, bi yʉtra̱ zithu̱ p'ʉ ja rá̱ mmʉi. Ra̱ Jesús bi 'yɛ̱mbʉya: ―Nu̱'a̱ te ja ngue gui 'yøt'e, 'yøt'e n'nahma̱ntho. ");
INSERT INTO otnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pɛ nu̱'ʉ 'dap'ʉ hu̱hmʉ p'ʉ ja ra̱ mɛ̱xa ngue si̱hmɛ̱, hi̱njombi̱ n'yo yø mmʉi hanja na̱ ra̱ hya̱ bi sihna̱ ts'ofo. ");
INSERT INTO otnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","A nu̱na̱ ra̱ Judas ngue ma̱ fäti ra̱ buxa njʉmɛ̱nyu̱, bi 'yɛ̱mp'ʉ i bɛ̱n'i̱'da, ngue nu̱na̱ ra̱ Jesús bi xifi ngue da̱ däi tema̱ hyoni̱ ngue ra̱ ngo, ogue di u̱nni̱ zi algo yø hyoya. ");
INSERT INTO otnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Høntho bi zi ra̱ thu̱hmɛ̱ bi t'u̱nna̱ Judas, bi bøni̱, bi̱ ma. Pɛ ya nxu̱i̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mi̱ bønna Judas, bi 'yɛ̱nna̱ Jesús: ―A nu̱ya ja di̱ nɛ̱qui̱ p'ʉya ngue ma̱guesɛ ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱. 'Nɛ̱ conná̱ ngue'a̱ te øt'e, ja di̱ nɛ̱qui̱ p'ʉ ngue ma̱guesɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xi'mø ngue ra̱ N'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱, nu̱ te øt'e, gue'a̱ gui̱ nɛ̱qui̱ ngue ma̱guesɛ Oja̱'a̱, nu̱na̱ Oja̱ ya, xquet'a̱ da̱ 'yu̱di̱ ngue ma̱guesɛ'a̱ rá̱ Ts'ʉnt'ʉ ya. 'Nɛ̱ ya mi̱ ts'ʉdyø pa di̱ nja na̱ dí xi'a̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ague ma̱ ba̱si̱'a̱hʉ, ya mi̱ ts'ʉdra̱ ora dí 'bʉhmʉ ua ya. Tengu̱tho ra̱ hya̱ xtá̱ xicä yø judío, xquet'a̱ ngu̱t'a̱tho ra̱ hya̱ dí xi'a̱hʉ ya. Gui hyonjʉ, pɛ hi̱nda̱ zä gui tɛnnga̱hʉ hapʉ gdá̱ magä. ");
INSERT INTO otnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma̱'da'yo høn da̱di 'bɛp'a̱hʉ ya, ngue gui̱ mma̱hmʉ n'na ngu̱ n'na'a̱hʉ. Tengu̱tho nná̱ ma̱'a̱hʉ, guí̱ njathʉ p'ʉya ngue guí̱ mma̱hmʉ n'na ngu̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nu̱'mø ngue guí̱ mma̱hmʉ n'na ngu̱ n'na'a̱hʉ, di u̱nna̱ güɛnda gätho yø ja̱'i̱ ngue gue'e ma̱ xädi'a̱hʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ra̱ Bɛdu bi 'yørpa̱ ra̱ nt'änni̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿hapʉ gue gdi̱ ma p'ʉya? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱p'ʉ ha gdá̱ magä, ya hi̱nda̱ zä gui tɛnnga̱hʉ. Pɛ da̱ zä gui tɛnnga̱hʉ m'mɛfa. ");
INSERT INTO otnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿hanja ngue guí ɛ̱na̱ ngue hi̱nda̱ zä ga̱ tɛn'na̱'i̱ ya? Nu̱gä dí ɛmma̱ te conná̱ ngue'e. ");
INSERT INTO otnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Guí ɛ̱na̱ ngue gui ɛnni̱ te conná̱ nguecä. Pɛ ma̱jua̱ni̱ dí xi'i ngue hante di̱ mmahra̱ øni̱, ya xquí cønga̱ nhyu̱ ndi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","'Yo di tu̱ ni̱ mmʉihʉ. Guí hya̱hni̱ mmʉi gui 'yɛ̱c'ɛ̱i̱hʉ Oja̱, da̱ guecä da̱mi̱ 'yɛ̱c'ɛ̱i̱ga̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nu̱p'ʉ ja rá̱ ngu̱ ma̱ Papágä, xa̱ngu̱ yø ts'äya bí jap'ʉ. Nu̱'mø da̱ hi̱n'yʉ p'ʉ yø ts'äya, hi̱nte ga̱ sänni̱ ga̱ xi'a̱hʉ 'mø. Pɛ nu̱yá, ga̱ mmagä ya ngue güí̱ nsägä ha gui̱ nsäyahʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nu̱'mø dá̱ magä p'ʉya ngue güí̱ nsägä ha gui̱ nsäyahʉ, ga̱ ma ɛ̱cä ma̱høn'a̱ p'ʉya ga̱ sixa̱hʉ, n'namhma̱ ngue 'dap'ʉ ga̱ m'mʉhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Guí pa̱hmʉ p'ʉya hapʉ gda̱ magä, 'nɛ̱ guí pa̱hmʉ ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mi̱ da̱hra̱ Toma p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, hi̱ndí̱ pa̱cähe ha gdi̱ ma, ¿ha da̱ nzä ga̱ pa̱cähe ra̱ 'yu̱ gdi̱ ma? ");
INSERT INTO otnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Conná̱ nguecä da̱ zä guí sømhmʉ p'ʉ 'bʉ Oja̱. 'Nɛ̱ conná̱ nguecä guí pa̱hmʉ ndana̱ ma̱jua̱ni̱. Go da̱di̱ u̱ngä ra̱ 'da'yo te. Nu̱ to gä da̱ 'yɛ̱c'ɛ̱i̱gui̱, gue'ʉ da̱ zømp'ʉ 'bʉhma̱ Papá'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngue hi̱ngmi̱ pa̱hmʉ te'ogä ma̱ m'mɛt'o, ja̱na̱ngue hi̱ngmi̱ pa̱hmʉ te'o na̱ ra̱ Papá. A nu̱yá, ya guí pa̱hmʉ ya, porque ya guí̱ nnu̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Bi 'yɛ̱mbra̱ Lipe p'ʉya: ―Ague grá̱ Hmu̱, 'yøt'e ngue da̱ zä ga̱ nnu̱gähe ra̱ Papá 'mø. Co nu̱'a̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague Lipe, ya xa̱ mma yø pa dí̱ n'yohʉ, ¿'nɛ̱ tobe hi̱nguí̱ pa̱qui̱? Nu̱'a̱ to bi̱ nu̱gä, ya bi̱ nu̱ ra̱ Papá'a̱. ¿Hanja'a̱ guí xiqui ngue guí ɛ̱ngui̱ ga̱ øt'ä ngue gui̱ nnu̱ ra̱ Papá? ");
INSERT INTO otnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ua hi̱nguí̱ ɛ̱c'ɛ̱i̱gui̱ ngue tengu̱thogä ya, njarbʉtho ma̱ Papá? Tengu̱tho ma̱ Papágä p'ʉya, xquet'a̱ di̱ njadä p'ʉ. Nu̱na̱ ra̱ hya̱ ya xtá̱ xi'a̱hʉ, hi̱ngo dí̱ mma̱nsɛgä na̱. Nu̱'a̱ ra̱ Papá dí̱ n'yo'be, go øt'a̱ te dí øt'ä'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Da̱mi̱ 'yɛ̱c'ɛ̱i̱ga̱hʉ ngue tengu̱thogä ya, njarbʉtho ma̱ Papá. Tengu̱tho ma̱ Papágä ya, xquet'a̱ di̱ njadä p'ʉ. A nu̱'mø hi̱nguí̱ ɛ̱c'ɛ̱i̱hʉ na̱ ra̱ hya̱tho, da̱mi̱ 'yɛ̱c'ɛ̱i̱ga̱hʉ 'mø gá̱ nu̱hʉ'a̱ te dí øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱ ra̱ ja̱'i̱ ngue rá̱ mmʉi ga̱ 'yɛ̱c'ɛ̱i̱gui̱, xquet'a̱ da̱ zä da̱ 'yøtra̱ ja̱'i̱ tengu̱tho dí øt'e. Ma̱n'na xa̱ngu̱ da̱ 'yør'mø ngue da̱ zä, porque nu̱gä ga̱ mmagä p'ʉ bí 'bʉhma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Rá̱ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ, nu̱'mø gá̱ mat'Oja̱hʉ, gui hya̱ ra̱ ts'ɛdi gui 'yädi te guí̱ nnehʉ. Nu̱gä ga̱ 'da'a̱hʉ'a̱ te gä gui 'yähmʉ, n'namhma̱ da̱ fa̱di̱ ngue ma̱guesɛ na̱ ma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Rá̱ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ, nu̱'mø gui hya̱ ra̱ ts'ɛdi gui 'yädi te guí̱ nnehʉ, nu̱gä ga̱ 'da'i ndana̱ bi zä ma̱cosa gui 'yähmʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nu̱'mø ga̱di̱ ma̱cjʉ, da̱mi̱ 'yøt'e te da̱di 'bɛp'a̱hʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ga̱ äpa̱ ra̱ ma̱te ma̱ Papá ngue da̱ pɛnhni̱ te'o da̱ mäxa̱hʉ, 'nɛ̱ di hoc'a̱ ni̱ mmʉihʉ, tengu̱tho dí øt'a̱hʉ ya. Nu̱na̱ da̱ 'bɛnhni̱, guehna̱ ra̱ Espíritu Santo da̱ gäp'a̱hʉ ra̱ 'yu̱ ma̱jua̱ni̱. 'Nɛ̱ guehna̱ guí̱ n'yohʉ para za̱ntho na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nu̱ yø ja̱'i̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱ Oja̱, hi̱ngui̱ sä di̱ n'youi ra̱ Espíritu Santo, porque hi̱ngui̱ hɛ̱ti̱ 'nɛ̱ hi̱ngui̱ pa̱di̱ te'o. Pɛ nu̱'a̱hʉ, ya guí pa̱hmʉ te'o na̱, porque ra̱ Espíritu Santo ya 'bʉcua guí 'bʉhmʉ, 'nɛ̱ guí̱ n'yohʉ para za̱ntho na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nu̱gä hi̱nga̱ soc'a̱sɛhʉ ua, ga̱ ma pengä ngue ga̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ya mi̱ ts'ʉtho ya, ya hi̱nni̱ mantho da̱ nu̱gä yø ja̱'i̱. Pɛ nu̱'a̱hʉ guí̱ nnu̱jʉ ma̱høn'a̱. 'Nɛ̱ di̱ nja'a̱hʉ ra̱ 'da'yo te, ngue ma̱høngdí 'bʉcä. ");
INSERT INTO otnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, guí u̱mhmʉ ra̱ güɛnda ngue dí̱ n'yogä'be ma̱ Papá. Da̱ gue'a̱hʉ p'ʉya, dí̱ n'yohʉ p'ʉ guí 'bʉhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nu̱ ra̱ ja̱'i̱ da̱ 'yøt'e te da̱di 'bɛpi, guehna̱ di̱ nɛ̱qui̱ ngue ma̱jua̱ni̱ di̱ ma̱qui̱. Ma̱ Papágä p'ʉya, xquet'a̱ di̱ ma̱di̱ gätho ya yø ja̱'i̱ di̱ ma̱qui̱. Nu̱gä p'ʉya xquet'a̱ da̱di̱ ma̱di̱, 'nɛ̱ ga̱ øt'e ngue da̱ fa̱di̱ ngue dí̱ n'yo'be ra̱ ja̱'i̱ di̱ ma̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Bi 'yɛ̱nna̱ Judas, nu̱na̱ hi̱ngra̱ Iscariote: ―Ague grá̱ Hmu̱, ¿hanja ngue hønjthogähe gui 'yu̱di̱ ngue dí̱ n'yohʉ, 'nɛ̱ hi̱nga̱ gätho mi̱'da yø ja̱'i̱ da̱ ba̱di̱? ");
INSERT INTO otnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―Nu̱ ra̱ ja̱'i̱ di̱ ma̱qui̱, guehna̱ da̱ 'yørpa̱bi̱ ma̱su̱ te dí xifi, 'nɛ̱ guehna̱ di̱ ma̱hma̱ Papágä na̱. Nu̱gä ya, co 'nɛ̱hma̱ Papá, ya dí̱ n'yohe ra̱ ja̱'i̱ di̱ ma̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","A nu̱ ra̱ ja̱'i̱ hi̱ndi̱ ma̱qui̱, guehna̱ hi̱ngui̱ ørca̱tho ma̱su̱ te dí xännbi̱. Nu̱na̱ ra̱ hya̱ dí xi'a̱hʉ ya, hi̱mma̱ hya̱sɛgä na̱, go rá̱ hya̱'a̱ ma̱ Papá bá̱ pɛnngui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Dí xi'a̱hʉ gätho ya yø hya̱ ya, mɛ̱nte tobe 'daua dí 'bʉhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A nu̱gä ga̱ äpra̱ ma̱te ra̱ Papá ngue da̱ pɛnhna̱ Espíritu Santo, n'namhma̱ da̱ mäxa̱hʉ 'nɛ̱ di hoc'a̱ ni̱ mmʉihʉ. Gue'a̱ go da̱ xän'na̱hʉ gätho'a̱ p'ʉya, 'nɛ̱ gä di bɛ̱n'na̱hʉ ya yø hya̱ ya xtá̱ xi'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ya ga̱ soc'a̱hʉ ya, pɛ di hu̱t'a̱ ni̱ mmʉihʉ. Nu̱gä ga̱ øt'e ngue da̱ hyu̱ ni̱ mmʉihʉ, hi̱nga̱ tengu̱ ra̱ hya̱ mma̱nyø ja̱'i̱ ngue ɛ̱mbi̱ nthu̱mmʉi. 'Yo sä di tu̱ ni̱ mmʉihʉ 'nɛ̱ 'yo guí su̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya guí øde te xtá̱ xi'a̱hʉ ngue ga̱ mmagä p'ʉ bí 'bʉhra̱ Papá, 'nɛ̱ hønga̱ ma ɛ̱cä ngue 'dap'ʉ ga̱ n'yohʉ. Nu̱'mø ma̱jua̱ni̱ ga̱di̱ ma̱cjʉ, da̱mi̱ johyahʉ ngue ga̱ mmagä. Porque nu̱na̱ ra̱ Papá, ta̱te na̱ ngue nu̱gä. ");
INSERT INTO otnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dí xi'a̱hʉ na̱ ra̱ hya̱ na̱ hante ngue di̱ nja, n'namhma̱ ngue nu̱'mø bi̱ nja, ya gui 'yɛ̱c'ɛ̱i̱hʉ na̱ ra̱ hya̱ ya xtá̱ xi'a̱hʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ya hi̱nga̱ ya'atho ga̱ nya̱hʉ ya, porque ya bá̱ ɛ̱p'ʉ ra̱ zithu̱ nu̱'a̱ di̱ ma̱nda yø ja̱'i̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱gä. Pɛ cohrá̱ ts'ɛdi na̱, hi̱nda̱ zä da̱ da̱jpi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pɛ ya jatho ngue ngu̱'a̱ di̱ nja, para ngue da̱ ba̱hyø ja̱'i̱ ngue da̱di̱ ma̱cä ma̱ Papá. 'Nɛ̱ dí øt'e te di 'bɛjpi ga̱ øt'e. Nanjʉ ya, ma ga̱ 'uehmʉ ua. ");
INSERT INTO otnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Go guecä tengu̱tho n'na 'bäi ra̱ uva, 'nɛ̱ hi̱njom ma̱n'na tengu̱gä. Ma̱ Papágä p'ʉya, tengu̱tho n'na ra̱ mɛfi ngue fähra̱ nua̱'uva. ");
INSERT INTO otnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sa̱jpa̱ yø 'yɛt'o hi̱ngui̱ nne di̱ nzʉdi. Pɛ nu̱'ʉ yø 'yɛt'o zʉdi, fädi 'nɛ̱ øjpa̱ yø 'yont'o, n'namhma̱ ngue ma̱n'na di̱ nzʉdi xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","A nu̱'a̱hʉ, tengu̱tho yø 'yɛt'o ngue zʉdi, porque guí ørpa̱hʉ ma̱su̱ te dí xän'na̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","'Yo gui hɛga̱hʉ p'ʉ, tengu̱tho gä hi̱ndi̱ hɛc'a̱hʉ p'ʉ. Xi n'na ra̱ 'yɛt'o ya, nu̱ hi̱nda̱ zä di̱ nzʉhrá̱ ndät'ä 'mø 'yosɛ, ya hi̱mbi̱ thɛp'ʉ ja ra̱ da̱'yʉ. Guí̱ njathʉ p'ʉya, hi̱nda̱ zä guí̱ n'yo ma̱nhohʉ 'mø gui hyɛga̱hʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nu̱gä tengu̱tho n'na ra̱ da̱'yʉ. A nu̱'a̱hʉ p'ʉya, tengu̱tho yø 'yɛt'o. Nu̱'a̱ hi̱ngui̱ hɛga̱gui̱ ya, ma̱n'na di̱ n'yo ma̱nho, porque dí̱ n'yo'be. A nu̱'mø gui hyɛga̱hʉ p'ʉ, ya hi̱nda̱ zä te gui 'yøthʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A nu̱ ra̱ ja̱'i̱ hɛp'ʉ ma̱ hya̱gä, di̱ njapi tengu̱tho ra̱ 'yɛt'o hi̱ngui̱ zʉdi. I̱ nthɛqui ngue ma̱'ot'i. Nu̱'mø bi 'yot'i, da̱ ma ma̱pɛti ngue da̱ t'u̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nu̱'mø hi̱ngui̱ hyɛga̱hʉ p'ʉ, gui 'yɛ̱t'a̱ mmʉi te dí xän'na̱hʉ, da̱mi̱ 'yädi te guí̱ nne gui 'yähmʉ, guí̱ nnu̱ gue di̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu̱na̱ ma̱ Papágä, da̱ hnu̱ ma̱nsu̱ 'mø ngue gui̱ n'yo ma̱nhohʉ na̱. Gue'a̱ di̱ nɛ̱qui̱'a̱ p'ʉya ngue ma̱jua̱ni̱ ma̱ xädi'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tengu̱tho guí̱ ma̱cä ma̱ Papá, njarbʉtho nná̱ ma̱'a̱hʉ ya. Nu̱ te dí̱ nnu̱ ma̱nhogä, gue'a̱ gui 'yøthʉ'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu̱'mø gui 'yøt'e te da̱di 'bɛp'a̱hʉ, ya ni̱ mantho ga̱ ma̱'a̱hʉ 'mø. Nu̱gä dí øt'e te di 'bɛjpa̱gui̱ ma̱ Papá, ja̱na̱ngue di̱ ma̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Dí xi'a̱hʉ na̱ ra̱ hya̱ na̱, n'namhma̱ ngue tengu̱tho nná̱ johyagä, ngu̱'a̱ gdi johyahʉ. 'Nɛ̱ hangu̱ ra̱ pa guí johyahʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nu̱na̱ ra̱ hya̱ na̱ya, da̱di 'bɛp'a̱hʉ ngue tengu̱tho nná̱ ma̱'a̱hʉ ya, da̱ ngu̱t'a̱ gdí̱ mma̱hmʉ n'na ngu̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nu̱'a̱ ma̱ da̱tho ja ngue da̱ 'yøt'a̱ n'na ngue'mø di̱ ma̱hrá̱ amigo, da̱ 'yɛnná̱ te conná̱ nguehrá̱ amigo. ");
INSERT INTO otnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nu̱'a̱hʉ, ya ma̱ amigo'a̱hʉ ngue'mø gui 'yøt'e te da̱di 'bɛp'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nu̱yá, ya hi̱nga̱ ɛ̱n'a̱hʉ ngue gyø mɛfithohʉ ya, porque nu̱'a̱ ra̱ mɛfitho hi̱ngui̱ pa̱di̱ te øtrá̱ hmu̱'a̱. Nu̱ya dí̱ mma̱ ngue ma̱ amigo'a̱hʉ, porque ya dá̱ o'a̱hʉ n'yu̱ te gäma̱ hya̱ xicä ma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hi̱ngo gá̱ huannga̱hʉ, nu̱gä go dá̱ huan'na̱hʉ. A nu̱yá, ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ, dí̱ nne ngue za̱nt'a̱ gui̱ n'yo ma̱nhohʉ, n'namhma̱ ngue di̱ n'na'a̱hʉ'a̱ te gä gui 'yäphʉ ra̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nu̱na̱ ra̱ hya̱ na̱ya, da̱di 'bɛp'a̱hʉ ngue guí̱ mma̱di̱ n'na ngu̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nu̱'mø ngue nnu̱ ma̱n'ʉ'a̱hʉ yø ja̱'i̱, ya guí pa̱hmʉ ngue ya ma̱m'mɛt'o xa̱ hnu̱ ma̱n'ʉgui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu̱'mø ngue ga̱di̱ n'amigohʉ yø ja̱'i̱ hi̱ngui̱ ɛ̱c'ɛ̱i̱gä, da̱di̱ ma̱'a̱hʉ yø ja̱'i̱ 'mø tengu̱tho gui̱ ma̱hyø amigo. Pɛ nu̱gä, go dá̱ huan'na̱hʉ p'ʉ 'bʉhyø ja̱'i̱ ua ja ra̱ xi̱mhäi. A nu̱yá, ya hi̱n ga̱di̱ n'amigohʉ yø ja̱'i̱ ya. Ja̱na̱ngue nnu̱ ma̱n'ʉ'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Da̱mi̱ bɛ̱nna̱ hya̱ ya xtá̱ xi'a̱hʉ m'mɛt'o. Hi̱njo'o n'na ra̱ mɛfitho da̱ 'yɛ̱na̱ ngue hi̱nda̱ thogui tengu̱tho thohrá̱ hmu̱. Nu̱'mø ngue bi̱ nu̱ ma̱n'ʉgä yø ja̱'i̱, xquet'a̱ guí̱ njathʉ p'ʉya, da̱ nu̱ ma̱n'ʉ'a̱hʉ yø ja̱'i̱. Nu̱'mø ngue hi̱ngui̱ t'ɛ̱c'ɛ̱i̱'a̱ te dí xännba̱tegä, ni̱ xi̱nga̱ gue'a̱hʉ da̱ t'ɛ̱c'ɛ̱i̱'a̱hʉ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nu̱ te gä dí xi'a̱hʉ ya, da̱ ja'a̱hʉ yø ja̱'i̱, porque ngue ma̱ xädi'a̱hʉ. Nu̱na̱ Oja̱ bá̱ pɛnngui̱, hi̱ngui̱ pa̱hyø ja̱'i̱ te'o na̱, ja̱na̱ngue di ja'a̱hʉ p'ʉ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nu̱'mø hi̱n xca̱bá̱ ɛ̱hɛ̱ ga̱ nzohyø ja̱'i̱, ya hi̱ndi̱ jasɛ yø ja̱'i̱ p'ʉ da̱ ma ra̱ castigo 'mø. Pɛ nu̱yá, di jasɛ p'ʉ da̱ ma ra̱ castigo ya ngue hi̱ngui̱ ɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","A nu̱yá, nu̱'a̱ ga̱ nnu̱ ma̱n'ʉgä yø ja̱'i̱ ya, xquet'a̱ 'nɛ̱'a̱ ma̱ Papágä nnu̱ ma̱n'ʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hi̱n tema̱ castigo di̱ nja 'mø ngue hi̱n tema̱ hmɛ̱ya xcá̱ øt'ä p'ʉ ha 'bʉhyø ja̱'i̱. 'Nɛ̱ nu̱'a̱ te gä dí øt'e, hi̱njongui̱ pøni̱ ngue di sä da̱ 'yøt'e. Ma̱da̱gue'a̱ bi̱ nu̱ yø ja̱'i̱ te gä dí øt'e, pɛ co ngu̱'a̱ nnu̱ ma̱n'ʉ gyø ja̱'i̱, co 'nɛ̱'a̱ ma̱ Papá i hnu̱ ma̱n'ʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nu̱ya yø hya̱ dí̱ mma̱ngä, di̱ nja ya, porque jatho ngue di̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ra̱ ley ca̱ yø ja̱'i̱, i ɛ̱na̱: “Hi̱ngui̱ ja te rá̱ngue'a̱ i hnu̱ ma̱n'ʉgui”. ");
INSERT INTO otnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ga̱ xicä ma̱ Papá ngue da̱ pɛnhna̱ Espíritu Santo da̱ mäxa̱hʉ 'nɛ̱ di hoc'a̱ ni̱ mmʉihʉ. A nu̱'á̱, go di ja ma̱jua̱ni̱ te'ogä'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Xquet'a̱ 'nɛ̱'a̱hʉ da̱mi̱ jahʉ ma̱jua̱ni̱ te'ogä, porque dí̱ n'yohʉ asta̱ guep'ʉ bá̱ fʉhra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Dí xi'a̱hʉ ya yø hya̱ ya, n'namhma̱ hi̱nguí̱ nyobɛ̱ni̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","'Nɛ̱ da̱ ma nthu̱qui̱ ni̱ thu̱hu̱ p'ʉ ja yø ni̱ja̱ yø judío. Da̱ 'yɛ̱hra̱ ora ngue di̱ m'mʉ i'da da̱ hyo'a̱hʉ, da̱ 'yɛ̱na̱ ngue ørpa̱ rá̱ 'bɛfi Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ngu̱na̱ ra̱ hya̱ da̱ ja'a̱hʉ yø ja̱'i̱, porque hi̱nja̱m'mø di̱ nne da̱ ba̱'a̱ ma̱ Papá, ni̱ xi̱nga̱ gueque di pa̱cyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dí xi'a̱hʉ na̱ ra̱ hya̱ na̱, n'namhma̱ ngue nu̱'mø bi zønna̱ ora di̱ nja, da̱ zo ni̱ mmʉihʉ na̱ ra̱ hya̱ ya xtá̱ xi'a̱hʉ. Ma̱m'mɛt'o hi̱nte dí xi'a̱hʉ na̱ ra̱ hya̱ na̱, porque 'daua dí 'bʉhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","A nu̱yá, ya ga̱ mmagä ya, ga̱ni̱ m'mʉp'ʉ bí 'bʉhma̱ Papá bá̱ pɛnngui̱. A nu̱'a̱hʉ ya, ya hi̱njonda̱ bøni̱ da̱ 'yɛ̱ngui̱: “¿Hapʉ gni̱ ma ya?” ");
INSERT INTO otnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pɛ nu̱ya ngue dá̱ xi'a̱hʉ na̱ ra̱ hya̱ na̱, bi du̱ ni̱ mmʉihʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pɛ ma̱jua̱ni̱ te dí xi'a̱hʉ, go ni̱ nhohʉ ngue ga̱ mmagä. Porque nu̱'mø hi̱nga̱ mmagä, ¿hague di 'yɛ̱'a̱ ra̱ Espíritu Santo da̱ mäxa̱hʉ 'nɛ̱ di hoc'a̱ ni̱ mmʉihʉ 'mø? Pɛ nu̱'mø ga̱ mmagä, ya ga̱ ma pɛnhnä p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nu̱'mø bá̱ ɛ̱'a̱ p'ʉya, go da̱ 'yøt'a̱ ngue da̱ ba̱hyø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi ngue ja yø ts'oqui, 'nɛ̱ da̱ ba̱di̱ hanja na̱ ra̱ 'yu̱ njua̱ntho. 'Nɛ̱ da̱ ba̱hyø ja̱'i̱ ngue da̱ zønna̱ pa da̱ japra̱ castigo Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Da̱ ba̱di̱ ngue ra̱ ts'oqui øtyø ja̱'i̱ hi̱mbi̱ 'yɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A nu̱gä ngue njua̱ntho dá̱ n'yogä, ya ga̱ mmagä p'ʉ bí 'bʉhma̱ Papá. 'Nɛ̱ ya hi̱nni̱ mantho guí̱ nnu̱jʉ ua. Ja̱na̱ngue da̱ hya̱xa̱ njua̱ni̱ yø ja̱'i̱ p'ʉya ndana̱ gue'a̱ ra̱ 'yu̱ njua̱ntho ja ngue da̱ n'yo. ");
INSERT INTO otnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Da̱ hya̱xa̱ njua̱ni̱ yø ja̱'i̱ p'ʉya hanja na̱ ra̱ hya̱ xa̱ nzän'Oja̱. Porque ya da̱ ts'ännbi̱ ngue da̱ ma ra̱ castigo na̱ ra̱ zithu̱ di̱ ma̱nda ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Xa̱ngu̱ mi̱'da yø hya̱ jap'ʉ dí̱ nne ga̱ xi'a̱hʉ, pɛ tobe hi̱ngui̱ sønna̱ ora p'ʉ da̱ zä gui ti̱mhmʉ te ga̱ mbøn'a̱ te dí xi'a̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nu̱'mø bá̱ ɛ̱hra̱ Espíritu Santo ya, go di o'a̱hʉ n'yu̱ hanja'a̱ te ma̱jua̱ni̱'a̱. 'Nɛ̱ gä ma̱jua̱ni̱'a̱ te da̱ xän'na̱hʉ'a̱, porque hi̱ngrá̱ hya̱sɛ da̱ ma̱, a nu̱na̱ tengu̱tho ra̱ hya̱ da̱ sifi, da̱ ngu̱'a̱ da̱ ma̱. Da̱ 'yøt'e ngue gui ti̱mhmʉ hanja'a̱ te ja ngue di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nu̱'a̱ go da̱ 'yøt'e ngue da̱ hnu̱ ma̱nsu̱gä'a̱, porque da̱ ha̱'a̱ ra̱ hya̱ ga̱ xifi, 'nɛ̱ da̱ 'yøt'e ngue gui pa̱hmʉ hanja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nu̱ te gäma̱ hya̱ mma̱nna̱ Papá, gä gue'a̱ ra̱ hya̱ dí̱ mma̱ngä'a̱. Ja̱na̱ngue dí xi'a̱hʉ ngue ra̱ Espíritu Santo da̱ ha̱nnga̱gui̱ ma̱ hya̱, 'nɛ̱ di ja'a̱hʉ ngue gui pa̱hmʉ hanja ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ya mi̱ ts'ʉdra̱ ora ngue hi̱n hapʉ gui̱ nnu̱jʉ ya. M'mɛfa p'ʉya, ya hi̱nda̱ ya'atho gui̱ nnu̱jʉ ma̱høn'a̱, porque ga̱ mmagä ma̱hɛ̱ts'i̱ bí 'bʉhma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nu̱ya 'da yø xädi p'ʉya, di̱ n'yänni̱ n'na ngu̱ n'na, di̱ n'yɛ̱mbi̱: ―¿Te ga̱ mbøn'a̱ xicjʉ na̱? ngue ɛ̱na̱ ya mi̱ ts'ʉdra̱ ora ya, ya hi̱n hapʉ ga̱ nnu̱hʉ. Xi̱mmi̱ ts'ʉdra̱ ora ngue ga̱ nnu̱hʉ ma̱høn'a̱ p'ʉya, xi̱mmi̱ mma̱mp'ʉya ngue da̱ ma ma̱hɛ̱ts'i̱ bí 'bʉhrá̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Teni̱ 'bɛ'a̱ ga̱ mbøn'a̱ mma̱nna̱? ngue ɛ̱mbi̱ ya mi̱ ts'ʉtho. Hi̱ndí̱ pa̱hmʉ tema̱ hya̱ mma̱nna̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bi ba̱hra̱ Jesús ngue nne da̱ 'yänyø xädi na̱ ra̱ hya̱ bi̱ ma̱, bi 'yɛ̱mbʉya: ―Nu̱gä dí xi'a̱hʉ, ya hi̱nda̱ ya'atho hi̱n hapʉ gui̱ nnu̱jʉ. M'mɛfa p'ʉya, ya hi̱nda̱ ya'atho gui̱ nnu̱jʉ. ¿Ua guehna̱ ra̱ hya̱ ga̱di̱ n'yänhnʉ na̱ya? ");
INSERT INTO otnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ma̱jua̱ni̱ dí xi'a̱hʉ ngue gui̱ nzomhmʉ 'nɛ̱ da̱ du̱ ni̱ mmʉihʉ. Nu̱'mø bi̱ nu̱'a̱hʉ yø ja̱'i̱ 'bʉ'a̱ nxi̱mhäi p'ʉya, da̱di johya. Pɛ hi̱nte ja'a̱. Nu̱ ni̱ du̱mmʉihʉ da̱ gohi ngue ra̱ johya'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Conque nu̱'mø ja ngue di̱ m'mʉhrá̱ ba̱si̱ n'na ra̱ xisu, tu̱ rá̱ mmʉi porque ya bi zønna̱ ora da̱ zä ra̱ n'ʉ. Pɛ nu̱'mø ya bi̱ m'mʉhrá̱ ba̱si̱ p'ʉya, ya hi̱nni̱ mantho mbɛ̱n'a̱ ra̱ n'ʉ mi̱ sä. Porque di johya ngue ya bi̱ m'mʉhrá̱ ba̱si̱ ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Xquet'a̱ gui̱ njathʉ p'ʉya. Bá̱ ɛ̱p'ʉ ra̱ ora da̱ du̱ ni̱ mmʉihʉ. Pɛ nu̱gä ga̱ ma pengui̱ ga̱ nnu̱'a̱hʉ. Gä ra̱ johya di̱ nja ni̱ mmʉihʉ p'ʉya. Gue'a̱ n'na ra̱ johya hi̱njonda̱ zä da̱ hya̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, ya hi̱mma̱ hyoni̱ te gui 'yännga̱hʉ. Nu̱gä ma̱jua̱ni̱ dí xi'a̱hʉ, nu̱'mø gá̱ mat'Oja̱hʉ rá̱ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ, da̱mi̱ hya̱ ra̱ ts'ɛdi gui 'yädi te guí̱ nnehʉ. Ma̱ Papágä p'ʉya di 'da'i te gui 'yäphʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta̱ guehya tobe hi̱nte guí äphʉ Oja̱ di 'da'a̱hʉ rá̱ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. Da̱mi̱ 'yähmʉ n'namhma̱ di̱ n'na'a̱hʉ. Ja̱njua̱ni̱ ngue gä ra̱ johya di̱ nja'a̱hʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nu̱ya yø hya̱ ya xtá̱ xi'a̱hʉ, dá̱ honi̱ te nná̱ hyɛjpa̱bi̱ ra̱ hya̱ dá̱ ma̱. Pɛ da̱ 'yɛ̱hra̱ ora ngue nu̱ya yø hya̱ dí xi'a̱hʉ, ya hi̱nga̱ honi̱ te gda̱ hyɛjpi. Sinoque ga̱ xi'a̱hʉ njua̱ntho ha di̱ njap'ʉ gdi̱ pa̱hmʉ ra̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nu̱ ra̱ pa ja p'ʉya, ya da̱ zä gui 'yäphʉ ra̱ Papá'a̱ te guí̱ nnehʉ rá̱ngue guí ɛ̱c'ɛ̱i̱ga̱hʉ. Ya hi̱mma̱ hyoni̱ ngue 'bet'o ga̱ äpä ra̱ ma̱te ma̱ Papá conná̱ ngue'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Porque di̱ ma̱'a̱sɛhʉ ra̱ Papá. Di̱ ma̱'a̱hʉ, porque ga̱di̱ ma̱cjʉ, 'nɛ̱ gá̱ 'yɛ̱c'ɛ̱i̱hʉ ngue dá̱ ɛ̱cä p'ʉ bí 'bʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bí̱ nɛ̱xcä ma̱ Papá 'mø da̱mbá̱ ɛ̱cua ja ra̱ xi̱mhäi. A nu̱yá, ga̱ pøngä ua ja ra̱ xi̱mhäi ya, ga̱ mma ma̱hɛ̱ts'i̱ bí 'bʉhma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mi̱ da̱hyø xädi p'ʉya, bi 'yɛ̱na̱: ―A nu̱yá, njua̱ntho guí xicje ya. Hi̱n tema̱ hya̱ gni̱ hyɛjpi te guí̱ mma̱nya. ");
INSERT INTO otnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","A nu̱yá, ja dí ti̱ngähe p'ʉya ngue gä guí pa̱rpa̱bi̱ yø n'yomfɛ̱ni̱ yø ja̱'i̱. Hi̱mma̱ hyoni̱ ngue 'bet'o da̱ t'øt'a̱'i̱ ra̱ nt'änni̱. Guehna̱ nná̱ ɛ̱c'ɛ̱i̱gähe na̱ya ngue güí 'yɛ̱p'ʉ ma̱hɛ̱ts'i̱ bí 'bʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ra̱ Jesús bi 'yɛ̱na̱: ―A nu̱yá, ya guí ɛ̱c'ɛ̱i̱hʉ ra̱ hya̱ dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya mmɛ 'bexque'a̱ ya, ya ni̱ ma da̱ zønna̱ ora ga̱ nhyɛhmʉ, 'da'a̱ n'nani̱ gdí̱ mähä. Ya gui soga̱sɛhʉ p'ʉya. Pɛ nu̱gä hi̱ndí̱ 'dasɛgä, porque dí̱ n'yogä'be ma̱ Papá. ");
INSERT INTO otnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nu̱'mø ngue gui u̱nni̱ mmʉihʉ ya yø hya̱ dí xi'a̱hʉ ya, guehya yø hya̱ da̱ hyu̱t'a̱ ni̱ mmʉihʉ ya. Nu̱ua ja ra̱ xi̱mhäi guí sähʉ ra̱ n'ʉ ua. Pɛ da̱mi̱ hya̱hʉ ra̱ ts'ɛdi, ya xtá̱ ta̱pä'a̱ sɛcua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mi̱ juadi bi̱ ma̱nya yø hya̱ ya p'ʉya, bi hyanma̱ hɛ̱ts'i̱ ra̱ Jesús, bi 'yɛ̱na̱: ―Ma̱ Papá'i, ya bi zønna̱ ora ya. Da̱ ba̱hyø ja̱'i̱ ya ngue ma̱guesɛ'a̱ ni̱ Ts'ʉnt'ʉ, n'namhma̱ ngue xquet'a̱ 'nɛ̱hni̱ Ts'ʉnt'ʉ da̱ 'yøt'e ngue da̱ ba̱hyø ja̱'i̱ ngue ma̱gue'a̱sɛ'i. ");
INSERT INTO otnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nu̱'i̱ gá̱ u̱nna̱ ts'ɛdi ni̱ Ts'ʉnt'ʉ ngue nu̱'ʉ to gä gá̱ däpi, di u̱nna̱ 'da'yo te para za̱ntho. 'Nɛ̱ gá̱ u̱nna̱ nt'ɛ̱di̱ ngue nu̱'a̱ te da̱ zänni̱ gue'a̱ di̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nu̱'a̱ ra̱ 'da'yo te para za̱ntho, gue'a̱ di di̱nna̱ ja̱'i̱ da̱ ba̱'i̱'a̱, 'nɛ̱ da̱ ba̱qui̱. 'Nɛ̱ høn'a̱tho'i ngue ma̱jua̱ni̱ grá̱ Oja̱. A nu̱gä p'ʉya, guecä drá̱ Jesucristo guá̱ pɛnhua. ");
INSERT INTO otnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nu̱gä dá̱ øt'e ngue bi ba̱hyø ja̱'i̱ ua ja ra̱ xi̱mhäi ngue ma̱gue'a̱sɛ'i. Dá̱ juacä ra̱ 'bɛfi gá̱ 'bɛjpi ga̱ øt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A nu̱ya ma̱ Papá'i, da̱mi̱ 'daqui ngue nu̱p'ʉ ja ni̱ hmi̱ ni̱ dä, ma̱guecsɛga̱ui tengu̱tho nmi̱ jaui m'mɛt'o hante di̱ nhohra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nu̱ya yø ja̱'i̱ gá̱ huanhua ja ra̱ xi̱mhäi ngue gá̱ däqui, dá̱ japi bi ba̱di̱ te'o'i. Mi̱ o ni̱ 'yɛ yø ja̱'i̱, pɛ go gá̱ däqui, 'nɛ̱ bi 'yɛ̱c'ɛ̱i̱ na̱ ni̱ hya̱ guá̱ pɛnnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","A nu̱yá, ya pa̱hyø ja̱'i̱ ya ngue go guí xiqui te gäma̱ hya̱ dí̱ mma̱ngä. ");
INSERT INTO otnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Dá̱ u̱nnä na̱ ni̱ hya̱ gá̱ xiqui ga̱ xifi. Yø ja̱'i̱ p'ʉya, bi 'yɛ̱c'ɛ̱i̱. 'Nɛ̱ ha̱xa̱ njua̱ni̱ yø ja̱'i̱ ya ngue ma̱jua̱ni̱ dá̱ ɛ̱cä p'ʉ güí 'bʉi, 'nɛ̱ ɛ̱c'ɛ̱i̱ ngue go guá̱ pɛnnga̱gui̱ ua. ");
INSERT INTO otnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Dí ä'i ra̱ ma̱te ya ngue gui fähyø ja̱'i̱. Nu̱na̱ ra̱ ma̱te dí ä'i, hi̱n da̱di tɛrpä p'ʉ gätho yø ja̱'i̱ 'bʉ'a̱ nxi̱mhäi. Nu̱'ʉ yø ja̱'i̱ gá̱ däqui, gue'ʉ dí xi'i guí fä'ʉ, porque o ni̱ 'yɛ. ");
INSERT INTO otnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nu̱'ʉ to gä o ma̱ 'yɛgä, gä o ni̱ 'yɛ'ʉ. Nu̱'ʉ to o ni̱ 'yɛ p'ʉya, o ma̱ 'yɛgä'ʉ. 'Nɛ̱ da̱ hnu̱ ma̱nsu̱gä conná̱ ngue'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nu̱gä ya hi̱nni̱ mantho ga̱ m'mʉc'ɛ̱i̱ ua ja ra̱ xi̱mhäi. Nu̱gä ga̱ mmagä p'ʉ guí 'bʉi, ja ga̱ m'mʉcä p'ʉ. Pɛ nu̱ya da̱ gocua ja ra̱ xi̱mhäi, guehya dí xi'i gui fähya. Ma̱ Papá'i, xa̱ndʉxqui'i. Conni̱ ts'ɛdi da̱mi̱ fädi te'o gá̱ däqui, n'namhma̱ ngue xøgue n'na hya̱tho da̱ gohi, tengu̱thogüi, n'na hya̱tho dí jaui. ");
INSERT INTO otnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mɛ̱nte ra̱ pa 'daua dá̱ m'mʉhme ua ja ra̱ xi̱mhäi ya gá̱ däqui, conni̱ ts'ɛdi nma̱rá̱ fädi. Hi̱njombi̱ m'mɛdi, hi̱nda̱ hønda̱ n'na nc'ɛ̱i̱, nu̱na̱ ya bá̱ nt'ot'i ngue di̱ m'mɛdi, para ngue di̱ nja na̱ ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro. ");
INSERT INTO otnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","A nu̱yá, ga̱ mmagä p'ʉ guí 'bʉhya. Pɛ mɛ̱nte tobe dí 'bʉtä ua ja ra̱ xi̱mhäi, dí̱ mma̱ngä ya yø hya̱ ya, n'namhma̱ ngue nu̱ya ma̱ ja̱'i̱ui, gä ra̱ johya di̱ nja, tengu̱tho nná̱ johyagä. ");
INSERT INTO otnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nu̱na̱ ra̱ hya̱ guá̱ pɛnnba̱ yø ja̱'i̱ ngue ga̱ xännbi̱, bi̱ nu̱ ma̱nho ra̱ hya̱. Pɛ nu̱ya yø ja̱'i̱ hi̱mbi̱ nu̱ ma̱nho ni̱ hya̱ p'ʉya, bi̱ nu̱ ma̱n'ʉ ya yø ja̱'i̱ bi̱ nu̱ ma̱nho ni̱ hya̱. Porque ya hi̱nni̱ mantho øtra̱ nts'o ga̱ 'yo yø ja̱'i̱, tengu̱thogä ngue hi̱ndá̱ øt'ä ra̱ nts'o ga̱ 'yo yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hi̱nna̱ ä'i ra̱ ma̱te ngue guí jʉcua ja ra̱ xi̱mhäi ya yø ja̱'i̱ dí xi'i. Sinoque dí ä'i ra̱ ma̱te ngue gui fädi ngue ra̱ zithu̱ hi̱ndi̱ ts'onnba̱ yø nt'ɛ̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tengu̱tho gä hi̱ndá̱ øt'ä ra̱ nts'o øtyø ja̱'i̱, da̱ guehya ma̱ ja̱'i̱ui, xquet'a̱ hi̱ngui̱ øtra̱ nts'o ga̱ 'yo yø ja̱'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Da̱mi̱ 'yøt'e ngue da̱ hyo yø mmʉi conná̱ ngue'e, da̱ hyonna̱ nho da̱ n'yo conná̱ nguehni̱ hya̱. Porque nu̱na̱ ni̱ hya̱, guehna̱ ma̱jua̱ni̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tengu̱tho güí pɛnnga̱gui̱ ua ja ra̱ xi̱mhäi, xquet'a̱ di̱ njadä p'ʉya, dá̱ ɛt'ä ya ma̱ ja̱'i̱ui ngue da̱ ma da̱ ma̱nna̱ hya̱ p'ʉ ha 'bʉhyø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Dí ɛngä ma̱ te conná̱ nguehma̱ ja̱'i̱ui, n'namhma̱ ngue xquet'a̱ 'nɛ̱'ʉ da̱ hyo yø mmʉi ngue xtá̱ nho te da̱ n'yo conná̱ nguehna̱ ra̱ hya̱ ma̱jua̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pɛ hi̱nga̱ hønt'ʉ dí ä'i ra̱ ma̱te guí fä'ʉ, sinoque 'nɛ̱'ʉ yø ja̱'i̱ da̱ 'yɛ̱c'ɛ̱i̱gä m'mɛfa conná̱ nguehra̱ hya̱ da̱ ma̱nya ma̱ ja̱'i̱ui, xquet'a̱ dí xi'i ngue gui fädi. ");
INSERT INTO otnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Gätho ya dí xi'i ya, dí ä'i ngue xøgue n'na hya̱tho da̱ gohi tengu̱thogüi, ngue n'na hya̱tho di jaui. Ga̱ njathʉ p'ʉya, n'na hya̱tho ga̱ cohmʉ ya ma̱ ja̱'i̱ui, ma̱ Papá'i, gue'a̱ di ba̱di̱ gätho yø ja̱'i̱'a̱ ngue guá̱ pɛnnga̱gui̱ ua ja ra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nu̱gä dá̱ ja̱pä ya ma̱ ja̱'i̱ui tengu̱tho guí ja̱jpa̱gui̱ m'mɛt'o, n'namhma̱ ngue gue'a̱ di gohi ngue xøgue n'na hya̱tho di jahʉ'a̱ p'ʉya, tengu̱tho'i co 'nɛ̱cä n'na hya̱tho di jaui. ");
INSERT INTO otnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nu̱gä dí̱ n'yogä'be ya ma̱ ja̱'i̱ui. Nu̱'i̱ p'ʉya dí̱ n'youi. Gue'a̱ di gohi ngue xøgue n'na hya̱tho di jahʉ'a̱. 'Nɛ̱ gue'a̱ di ba̱ hmi̱'da yø ja̱'i̱'a̱ ngue nu̱'i̱ go guá̱ pɛnnga̱gui̱ ua, 'nɛ̱ ga̱di̱ ma̱'ʉ ma̱ ja̱'i̱ui, tengu̱thogä, ga̱di̱ ma̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ma̱ Papá'i, nu̱ya ma̱ ja̱'i̱ui gá̱ däqui, dí̱ nnegä ngue 'nɛ̱hya di̱ m'mʉp'ʉ ha ga̱ m'mʉcä ya, n'namhma̱ ngue da̱ nu̱ te guí ørca̱gui̱, ngue gui øt'e ngue 'nɛ̱cä dí ta̱tegä hapʉ guí 'bʉi. Porque nu̱'i̱ ga̱di̱ ma̱qui̱ hante di̱ nhohra̱ xi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ma̱ Papá'i, gä ra̱ nho guí øt'e. Nu̱ya yø ja̱'i̱ 'bʉcua ja ra̱ xi̱mhäi, hi̱ngui̱ pa̱'i̱ ya. Pɛ nu̱gä dí pa̱'i̱. A nu̱ya ma̱ ja̱'i̱ui p'ʉya, ya pa̱di̱ ngue go guá̱ pɛnnga̱gui̱ ua. ");
INSERT INTO otnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Nɛ̱ dá̱ xifi hanja ra̱ hya̱ ngue te'o'i. 'Nɛ̱ tobe ni̱ mantho dí xifi te'o'i ya, n'namhma̱ ngue tengu̱'i̱ ngue ga̱di̱ ma̱qui̱, da̱ ngu̱'a̱ da̱ 'yøt'e. A nu̱gä p'ʉya, dí̱ n'yogä'be ya yø ja̱'i̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mi̱ juadi bi̱ ma̱nya yø hya̱ ya, bi̱ ma ra̱ Jesús, bi̱ mɛ yø xädi, bi̱ ma ma̱n'na nguadi ra̱ 'yu̱the Cedrón. Nu̱p'ʉ ja n'na ra̱ nua̱za p'ʉya, ja bi yʉrbʉ ra̱ Jesús conyø xädi. ");
INSERT INTO otnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Xquet'a̱ 'nɛ̱hna̱ ra̱ Judas bi dä ra̱ Jesús, ya mi̱ pa̱'a̱ ra̱ xɛqui'a̱, porque xa̱ngu̱ yø nni̱di̱ ja ma̱di̱ pɛrpʉ yø xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nu̱na̱ ra̱ Judas bi zømp'ʉ 'bʉhra̱ Jesús. Ní̱ n'youi n'na 'bʉi yø soldado co 'nɛ̱hyø policía yø m'mɛnhni̱ yø mmäcja̱ conyø fariseo. Ni̱ gʉ yø juai, 'nɛ̱ ha̱ yø lámpara gui̱ nyot'i. Mi̱'da yø ja̱'i̱, ni̱ gʉ yø za tøhra̱ sibi yø nya̱ ngue gui̱ nyot'i. ");
INSERT INTO otnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pɛ ra̱ Jesús ya gä pa̱di̱ te ja ngue da̱ thogui. Bi̱ ma di c'at'ui ngue bi 'yänni̱, bi 'yɛ̱mbi̱: ―¿Te'o guí homhmʉ? ");
INSERT INTO otnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nu̱'ʉ yø ja̱'i̱ p'ʉya, bi 'yɛ̱mbi̱: ―Dí hongähe ra̱ Jesús nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Go guecä masque guí honjʉ. Ni̱ n'youi yø ja̱'i̱ na̱ ra̱ Judas bi dä ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nu̱'mø mi̱ 'yɛ̱mbyø ja̱'i̱ ra̱ Jesús: “Go guecä”, i gohyø xʉtha yø ja̱'i̱, bi t'ʉnga̱ häi. ");
INSERT INTO otnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nu̱na̱ ra̱ Jesús ma̱hømbi̱ 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Te'o guí homhmʉ? Nu̱'ʉ yø nzite p'ʉya, bi 'yɛ̱mbi̱: ―Dí hongähe ra̱ Jesús nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret. ");
INSERT INTO otnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mi̱ da̱hra̱ Jesús, ma̱hømbi̱ 'yɛ̱mbi̱: ―Ya dí xi'a̱hʉ ngue go guecä. Nu̱'mø go guí honjʉ, pɛ da̱mi̱ thøhmʉ ya 'bʉcua, da̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ngu̱na̱ bi̱ ma̱, para ngue di̱ nja'a̱ te ra̱ hya̱ xi̱ ma̱nna̱ Jesús ngue xi 'yɛ̱na̱: “Ma̱ Papá'i, nu̱'ʉ gá̱ däqui, hi̱njombi̱ m'mɛdi”, xi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ra̱ Bɛdu p'ʉya bi gʉxrá̱ juai mi̱ ha̱, bi hyɛjpa̱ rá̱ gu̱ ngue rá̱ n'yɛi'a̱ n'na nc'ɛ̱i̱ ni̱ hu̱ ngue ra̱ Malco, nu̱na̱ rá̱ 'yɛ̱hɛ̱ ra̱ 'bɛt'o mmäcja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pɛ ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague Bɛdu, da̱mi̱ fos'ni̱ juai. ¿Ua guí ɛ̱na̱ ngue ya hi̱ndi̱ nja'a̱ te ra̱ n'ʉ xpá̱ nzänma̱ Papá ga̱ thogui? ");
INSERT INTO otnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ni̱ n'youi n'na rá̱ hmu̱ ya yø soldado conyø policía yø m'mɛnhni̱ yø hmu̱ yø judío, bi bɛntra̱ Jesús, bi du̱t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bi zixpʉ ja rá̱ ngu̱ ra̱ Anás. Nu̱na̱ ra̱ Anás ma̱rá̱ ndøhya̱ ra̱ Caifás nu̱na̱ ma̱di̱ ma̱nda yø mmäcja̱'a̱ ra̱ jɛya'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nu̱na̱ ra̱ Caifás xi 'yɛ̱mbyø hmu̱ yø judío ngue ma̱n'na xa̱nho ngue n'na nc'ɛ̱i̱tho da̱ tho conná̱ngue gätho yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nu̱p'ʉ ja rá̱ ngu̱ na̱ rá̱ hmu̱ yø mmäcja̱, nu̱'a̱ ra̱ da̱thi ja mbo, ja i ts'ixpʉ ra̱ Jesús. Nu̱na̱ ra̱ Bɛdu co 'nɛ̱hna̱ ma̱n'na nc'ɛ̱i̱ rá̱ xädi, bi dɛnna̱ Jesús. Nu̱na̱ n'na nc'ɛ̱i̱ rá̱ xädi na̱, ma̱di̱ mpa̱hmi̱ ra̱ mmäcja̱. Ja̱na̱ngue bi tho'a̱mbo 'mø mi̱ yʉt'a̱mbo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pɛ nu̱na̱ ra̱ Bɛdu bi gohma̱xøts'e ra̱ goxthi na̱. Ja̱na̱ngue bá̱ pøn'a̱ ra̱ xädi ma̱rá̱ mpa̱di̱ui ra̱ mmäcja̱ ngue bi̱ nya̱ui na̱ ra̱ xisu fähra̱ goxthi ngue da̱ tho'a̱mbo ra̱ Bɛdu. ");
INSERT INTO otnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nu̱'a̱ ra̱ xisu fähra̱ goxthi p'ʉya, bi 'yänna̱ Bɛdu, bi 'yɛ̱mbi̱: ―¿Ua hi̱nga̱ 'nɛ̱'i̱ rá̱ xädi'i na̱ ra̱ n'yohʉ na̱? Mi̱ da̱hra̱ Bɛdu, bi 'yɛ̱na̱: ―Hi̱n'na̱, hi̱nga̱ 'nɛ̱cä. ");
INSERT INTO otnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nu̱'a̱ ra̱ ora'a̱ mi̱ sɛ, ja̱na̱ngue nu̱'ʉ yø hmi̱qui̱ 'bʉp'ʉ, conyø policía, xi 'yu̱hra̱ sibi p'ʉ 'bäi ngue di̱ nhat'i. Ra̱ Bɛdu p'ʉya xquet'a̱ 'nɛ̱'a̱ 'dap'ʉ 'bähmʉ'a̱ ngue di̱ nhat'i. ");
INSERT INTO otnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nu̱na̱ rá̱ hmu̱ yø mmäcja̱ bi dʉ'mi̱ bi 'yänna̱ Jesús ndana̱ gue'a̱ yø xädi, änni̱ te 'bɛ'a̱ ma̱ hya̱ xännbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱na̱ ra̱ hya̱ ya xtá̱ ma̱ngä, yø hmi̱ yø dä yø ja̱'i̱ xtá̱ ma̱ngä na̱ ra̱ hya̱ na̱. Xtá̱ nxännba̱tegä p'ʉ ja yø t'ʉni̱ja̱, da̱ guep'ʉ ja ra̱ da̱ni̱ja̱ di̱ mpɛti gätho yø judío. Hi̱n tema̱ hya̱ xtá̱ ma̱ngä ngue da̱ nt'a̱gui̱tho. ");
INSERT INTO otnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Hanja ngue ja guí änngui̱ tema̱ hya̱ xtá̱ ma̱ngä ya? Da̱mi̱ 'yänhnʉ yø ja̱'i̱ ya, go da̱ xi'a̱hʉ hanja ra̱ hya̱ xtá̱ ma̱ngä'ʉ. Nu̱'ʉ go pa̱'ʉ tema̱ hya̱ xtá̱ ma̱ngä. ");
INSERT INTO otnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Høntho bi̱ ma̱nna̱ ngu̱na̱ ra̱ Jesús, mi̱ 'bäp'ʉ n'na ra̱ policía di̱ mpɛp'ʉ ja ra̱ da̱ni̱ja̱, bi̱ mɛmba̱ rá̱ hmi̱, bi 'yɛ̱mbi̱: ―¿Ua ya ngu̱'a̱ gdi tha̱'mø guí ya̱ui rá̱ hmu̱ yø mmäcja̱ ya? ");
INSERT INTO otnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'mø ja ma̱ n'ʉ te dá̱ ma̱ngä, da̱mi̱ ma̱ te gui sä ma̱n'ʉ 'mø. Pɛ nu̱'mø ngue njua̱ntho dí ya̱gä, ¿hanja ngue guí pɛgba̱gui̱ ma̱ hmi̱? ");
INSERT INTO otnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ra̱ Anás bi du̱tra̱ Jesús, bi̱ mɛnnba̱bi̱ na̱ ra̱ Caifás rá̱ hmu̱ yø mmäcja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mɛ̱nte di sigue 'bäp'ʉ ja ra̱ sibi ra̱ Bɛdu ngue di̱ nhat'i, bi t'ɛ̱mbʉya: ―¿Ua hi̱nga̱ 'nɛ̱'i̱ rá̱ xädi'i na̱ ra̱ n'yohʉ na̱? ―t'ɛ̱mbi̱. Mi̱ da̱hra̱ Bɛdu p'ʉya, hømbi̱ ncøni̱, bi 'yɛ̱na̱: ―Hi̱n'na̱, hi̱nga̱ 'nɛ̱cä. ");
INSERT INTO otnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mi̱ 'bʉp'ʉ n'na rá̱ hmi̱qui̱ na̱ rá̱ hmu̱ yø mmäcja̱. Nu̱na̱ ra̱ hmi̱qui̱ p'ʉya, di̱ mmɛ̱ni̱ui na̱ ra̱ n'yohʉ xi zɛnna̱ Bɛdu xi hyɛjpa̱ ra̱ gu̱ ngue rá̱ n'yɛi. Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―Pɛ, ua̱ngui̱ gue'e xtá̱ nu̱'i̱ p'ʉ ja ra̱ nua̱za ngue guí̱ n'youi ra̱ Jesús ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ra̱ Bɛdu p'ʉya ma̱hømbi̱ ncøni̱. Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi̱ mmahra̱ øni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nu̱p'ʉ ja rá̱ ngu̱ ra̱ Caifás, bá̱ njʉcra̱ Jesús ngue i̱ map'ʉ ja ra̱ palacio 'bʉhra̱ gobernador. Pɛ ya 'yo haxpʉya. Nu̱'ʉ yø judío p'ʉya, hi̱mbi̱ yʉrbʉ ja ra̱ palacio'ʉ. I ja yø costumbre, i ɛ̱na̱ ngue nu̱'mø ja ngue di̱ nsänni̱go, hi̱ngui̱ sä di̱ ntøt'ui yø ja̱'i̱ hi̱ngyø judío. Nu̱'mø xta̱ nyʉt'i, ɛ̱na̱ ngue ya hi̱nda̱ zä di̱ nsi̱hmɛ̱ p'ʉ ja ra̱ ngo ngue ra̱ pascua. ");
INSERT INTO otnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ja̱na̱ngue bá̱ pønna̱ Pilato ngue bi̱ nya̱ui yø judío. Bi 'yɛ̱mbi̱: ―¿Te 'bɛ'a̱ ma̱ hya̱ gni̱ ya̱phʉ na̱ ra̱ n'yohʉ 'bʉcua? ");
INSERT INTO otnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bi 'yɛ̱nyø hmu̱ yø judío p'ʉya: ―Nu̱'mø ngue hi̱ndra̱ ts'oc'ɛ̱i̱ nʉ, hi̱nxca̱ dägähe ua 'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bi 'yɛ̱nna̱ Pilato p'ʉya: ―Ua̱ngui̱ guí ca̱hʉ ra̱ ley p'ʉya, da̱ zä gui sixhʉ gui 'yøsɛhʉ ra̱ ts'ʉt'abi. Yø judío p'ʉya bi 'yɛ̱na̱: ―Pɛ nu̱gähe ngue yø judío, hi̱n'yʉgähe ra̱ nt'ɛ̱di̱ ngue sä ga̱ hogähe n'na ra̱ ja̱'i̱. Nu̱'i̱ go nnetho gui sänni̱ te di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ja bi bømp'ʉ'a̱ te xi̱ ma̱n'a̱ m'mɛt'o ra̱ Jesús, ngue ya xi̱ ma̱ ngue da̱ thop'ʉ ja ra̱ pont'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nu̱'mø mi̱ yʉt'a̱mbo ra̱ palacio ra̱ Pilato, bi̱ ma̱nda bá̱ ts'ohra̱ Jesús ngue da̱ 'yørpa̱ ra̱ nt'änni̱. Bi 'yɛ̱mbi̱: ―¿Ua gue'e rá̱ da̱st'abi'i yø judío? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Xi'a̱ ra̱ hya̱ guí̱ mma̱nya, go guí änsɛ, ¿ua gue 'bʉi to xa̱ xi'i ngue guecä? ");
INSERT INTO otnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mi̱ da̱hra̱ Pilato p'ʉya, bi 'yɛ̱mbi̱: ―¿Ua go ma̱ mmi̱judíohʉ p'ʉya? Nu̱'ʉ ni̱ mmi̱judíohʉ 'nɛ̱'ʉ yø hmu̱ yø mmäcja̱ go xa̱ dä'i ua dí 'bʉcä'ʉ. ¿Teni̱ 'bɛ'a̱ gá̱ 'yøt'e? ");
INSERT INTO otnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱p'ʉ da̱di̱ ma̱ndagä, hi̱nga̱ guecua ja ra̱ xi̱mhäi jaua p'ʉ. Nu̱'mø ngue ja ga̱di̱ ma̱ndagä ua, gdi sigä to da̱ 'yøtra̱ sʉi 'mø, ngue hi̱nxta̱ mma ma̱dägä p'ʉ 'bʉhyø judío. Pɛ nu̱p'ʉ da̱di̱ ma̱ndagä, hi̱nga̱ guecua p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ra̱ Pilato bi 'yɛ̱mbi̱: ―¿Ja̱na̱ngue gue'e grá̱ da̱st'abi 'mø? Mi̱ da̱hra̱ Jesús, bi 'yɛ̱na̱: ―A̱há̱, go guecä tengu̱tho ra̱ hya̱ guí̱ mma̱. Gue'a̱ dá̱ ɛ̱cä ua ja ra̱ xi̱mhäi'a̱, ngue ga̱ m'mʉi para ngue ga̱ mma̱ngä na̱ ra̱ hya̱ ma̱jua̱ni̱. Nu̱ to gätho nne da̱ ba̱di̱ hanja na̱ ra̱ hya̱ ma̱jua̱ni̱, da̱ 'yøde te dí̱ mma̱ngä ya. ");
INSERT INTO otnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ra̱ Pilato p'ʉya bi 'yɛ̱mbi̱: ―¿To go da̱ bøni̱ ngue da̱ ba̱di̱ hanja'a̱ ra̱ hya̱ ma̱jua̱ni̱ p'ʉya? Mi̱ juadi bi 'yørpa̱ ra̱ nt'änni̱ p'ʉya, bi bøn'a̱thi ra̱ Pilato ngue bi̱ nya̱ui yø judío. Bi 'yɛ̱mbi̱: ―Hi̱n tema̱ ts'oqui dí ti̱nnbä na̱ ra̱ n'yohʉ 'bʉcua. ");
INSERT INTO otnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pɛ ja'a̱hʉ ra̱ costumbre ngue pa ma̱thøgue n'na ra̱ ofädi 'mø ja ra̱ ngo ngue ra̱ pascua. ¿Ua guí̱ nnehʉ ngue ga̱ thøcä na̱ rá̱ da̱st'abi yø judío? ");
INSERT INTO otnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bi̱ mʉhra̱ hmafi gätho yø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Nu̱'a̱, hi̱n'na̱'a̱. Go da̱mi̱ thøhra̱ Barrabás. Pɛ nu̱na̱ ra̱ Barrabás, guehna̱ n'na ra̱ bɛ̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nu̱na̱ ra̱ Pilato, bi̱ ma̱nda ngue bi̱ ma m'mɛi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nu̱'ʉ yø soldado, ya xi̱ me n'na ra̱ corona ngue yø 'ui̱ni̱, bi gäspa̱ rá̱ ya̱ ra̱ Jesús. 'Nɛ̱ bi heta̱ n'na ra̱ he ngue ra̱ 'bojʉpoi. ");
INSERT INTO otnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bi guarbʉ 'bähra̱ Jesús, bi 'yɛ̱mbi̱: ―Guí ta̱te ague rá̱ da̱st'abi'i yø judío ―bi 'yɛ̱mbi̱. Mɛ̱nte pɛmba̱ rá̱ hmi̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ra̱ Pilato p'ʉya, ma̱hømbi̱ bøn'a̱thi, bi 'yɛ̱mbyø judío: ―Para ngue guí u̱mhmʉ ra̱ güɛnda ngue hi̱n tema̱ ts'oqui dí ti̱nnbä na̱ ra̱ n'yohʉ na̱, gui̱ nnu̱hʉ ngue ga̱ ma jʉcä ua ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ma̱mbá̱ pønna̱ Jesús, bá̱ oxrá̱ ya̱ n'na ra̱ corona ngue yø 'ui̱ni̱. 'Nɛ̱ he ra̱ 'bojʉpoi xi̱ ma ma̱hete. Ra̱ Pilato p'ʉya, bi 'yɛ̱mbyø ja̱'i̱: ―'Bʉcua na̱ ra̱ n'yohʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nu̱'ʉ yø hmu̱ yø mmäcja̱ 'mø mi̱ nu̱ p'ʉya, co 'nɛ̱'ʉ yø policía, bi̱ mʉhra̱ hmafi, bi 'yɛ̱na̱: ―Da̱ guatra̱ pont'i̱. Da̱ guatra̱ pont'i̱. Bi 'yɛ̱nna̱ Pilato p'ʉya: ―Pɛ da̱mi̱ sisɛhʉ 'mø, bí cuathʉ ra̱ pont'i̱, porque nu̱gä ya hi̱n tema̱ ts'oqui dí ti̱nnbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nu̱'ʉ yø hmu̱ yø judío p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱gähe dí ca̱he n'na ra̱ ley. Conforme ra̱ ley dí ca̱gähe, jatho ngue da̱ tho, porque mma̱ ngue rá̱ Ts'ʉnt'ʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nu̱na̱ ra̱ Pilato 'mø mi̱ 'yøhna̱ ra̱ hya̱ na̱ p'ʉya, ma̱n'natho bi̱ nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hømbi̱ yʉt'a̱mbo ra̱ palacio p'ʉya, bi 'yänna̱ Jesús, bi 'yɛ̱mbi̱: ―¿Hapʉ grá̱ mmɛ̱ngu̱ n'yø? Pɛ ra̱ Jesús hi̱nte ga̱ nda̱tho. ");
INSERT INTO otnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ra̱ Pilato p'ʉya, bi 'yɛ̱mbi̱: ―Hi̱nguí̱ nne gui tha̱ 'mø di̱ nzo'i 'mø. ¿Ua hi̱nguí̱ pa̱di̱ ngue jagä ra̱ ts'ɛdi ga̱ cuat'a̱'i̱ ra̱ pont'i̱? 'Nɛ̱ xquet'a̱ jagä ra̱ ts'ɛdi ngue ga̱ thøc'a̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Hi̱n tema̱ ts'ʉt'abi da̱ zä gui 'yøt'e, ngue'mø hi̱n ná̱ngue Oja̱ xtí 'da'i ni̱ cargo. Ja̱na̱ngue nu̱'a̱ bi dägä ua guí 'bʉi, ma̱ da̱tho ja rá̱ ts'oqui'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi hyonna̱ forma ra̱ Pilato ngue xtí thøhra̱ Jesús. Pɛ ja̱njua̱ni̱ uɛ yø judío ngue bi 'yɛ̱mbi̱: ―Nu̱'mø ngue gui thøhna̱ ra̱ n'yohʉ na̱, ya hi̱nni̱ amigo ra̱ da̱st'abi Roma 'mø. Nu̱ to bi zä da̱ 'yɛ̱na̱ ngue ra̱ da̱st'abi ya, ya rá̱ nsʉiui ra̱ da̱st'abi Roma. ");
INSERT INTO otnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nu̱'mø mi̱ 'yøhra̱ Pilato na̱ ra̱ hya̱ na̱ p'ʉya, bi̱ ma da̱ni̱ mmi̱p'ʉ ja rá̱ nhu̱di̱ nhøt'a̱ hya̱ 'mø bi̱ nya̱. Bi̱ ma̱nda p'ʉ hu̱di̱ ngue bá̱ ts'i̱nnba̱bi̱ ra̱ Jesús. Guehna̱ ra̱ xɛqui ni̱ hu̱ conna̱ hya̱ ebreo, “Gabata”. I̱ nne da̱ ma̱ ngue “Ma̱ts'ʉxti xa̱nho p'ʉ bi t'ʉdo”. ");
INSERT INTO otnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tobe jadyø ngo ngue ra̱ pascua'a̱ ra̱ ora'a̱, ya mmɛ 'dato xu̱di̱. Gue'a̱ ra̱ pa di̱ nsä yø ja̱'i̱ hante ra̱ pa ngue ra̱ ts'äya. Nu̱na̱ ra̱ Pilato, bi 'yɛ̱mbyø judío: ―'Bʉcua ni̱ da̱st'abihʉ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bi̱ mʉhra̱ hmafi yø judío p'ʉya, bi 'yɛ̱na̱: ―Da̱ tho na̱ya, da̱ tho na̱ya. Da̱ guatra̱ pont'i̱. Ra̱ Pilato p'ʉya, bi 'yɛ̱mbyø ja̱'i̱: ―¿Ga̱ cuatä ra̱ pont'i̱ ni̱ da̱st'abihʉ 'mø? Bi 'yɛ̱n'ʉ yø hmu̱ yø mmäcja̱ p'ʉya: ―Nu̱'a̱ ma̱ da̱st'abihʉ, gue'a̱ ra̱ da̱st'abi Roma'a̱, 'nɛ̱ hi̱njom ma̱n'na. ");
INSERT INTO otnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mi̱ ma̱nyø ja̱'i̱ na̱ ra̱ hya̱ na̱ p'ʉya, ra̱ Pilato bi däpyø ja̱'i̱ ra̱ Jesús ngue da̱ ma di cuatra̱ pont'i̱. Bi zixyø judío na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bi̱ ma ra̱ Jesús ni̱ hya̱ rá̱ pont'i̱. I̱ map'ʉ ja ra̱ xɛqui ni̱ hu̱ ngue ra̱ Njʉya̱xhmu̱. Nu̱na̱ ra̱ hya̱ ngue ra̱ ebreo, ni̱ hu̱ ngue ra̱ Gólgota. ");
INSERT INTO otnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja bi̱ ma ma̱cuati p'ʉ ja ra̱ pont'i̱ ra̱ Jesús. 'Da i̱ ma ma̱cuatiui ra̱ pont'i̱ mi̱ yonc'ɛ̱i̱. 'Da'a̱ n'na nguadi rá̱ hyo i gohi n'na ngu̱ n'na. Nu̱na̱ ra̱ Jesús, bi gohma̱de na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bi̱ ma̱nda ra̱ Pilato ngue bi̱ ma ma̱cuati p'ʉ ja rá̱ ya̱ ra̱ pont'i̱ n'na ra̱ letrero, i ɛ̱na̱: “Guehna̱ ra̱ Jesús, ra̱ mmɛ̱ngu̱ Nazaret ngue rá̱ da̱st'abi yø judío na̱ya”. ");
INSERT INTO otnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Xa̱ngu̱ yø judío bi̱ nu̱ na̱ ra̱ letrero, porque nu̱p'ʉ bi̱ ma ma̱cuati ra̱ pont'i̱ ra̱ Jesús, guerp'ʉtho ra̱ da̱ni̱hni̱. Nu̱na̱ ra̱ letrero, nt'ot'i conna̱ hya̱ ngue ra̱ ebreo, conna̱ hya̱ ngue ra̱ griego, 'nɛ̱ nt'ot'i conna̱ hya̱ ngue ra̱ latín. ");
INSERT INTO otnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ja̱na̱ngue bi 'yɛ̱mbra̱ Pilato'ʉ yø hmu̱ yø mmäcja̱: ―'Yo guí ot'i ngue da̱ 'yɛ̱na̱: “Rá̱ da̱st'abi yø judío”. Sinoque da̱mi̱ 'yot'i ngue da̱ 'yɛ̱na̱: “Nu̱'a̱ t'ɛ̱mbi̱ rá̱ da̱st'abi yø judío”. ");
INSERT INTO otnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mi̱ da̱hra̱ Pilato p'ʉya, bi 'yɛ̱na̱: ―Ya di̱ nja p'ʉ'a̱ te nt'ot'i ya ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mi̱ juadi bi cuatra̱ pont'i̱ ra̱ Jesús, nu̱ya goho yø soldado bi ga̱jpa̱ rá̱ he ra̱ Jesús ngue di̱ nda̱rpi̱ n'na ngu̱ n'na. Bi ga̱jpa̱ rá̱ pahni̱ p'ʉya. Nu̱na̱ ra̱ pahni̱ hi̱nha nt'ɛti, n'na thoguitho bi̱ mɛ rá̱ 'be gä rá̱ do'yo ra̱ pahni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Di̱ n'yɛ̱mbyø soldado p'ʉya: ―Hi̱nga̱ xɛ̱mhmʉ na̱ya. Ma̱n'na xa̱nho ga̱ mmähä ra̱ ta̱ha̱. Nu̱'a̱ da̱ da̱ha̱, gue'a̱ da̱ ga̱nna̱ pahni̱'a̱. Ya bi̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue ɛ̱na̱: “Bi̱ nda̱rpa̱bi̱ n'na ngu̱ n'na'ʉ ma̱ he. Bi̱ ma ra̱ ta̱ha̱ ngue to da̱ ga̱ni̱”. Ngu̱na̱ ra̱ hya̱ bi 'yøtyø soldado. ");
INSERT INTO otnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nu̱p'ʉ bi̱ ma ma̱cuati ra̱ pont'i̱ ra̱ Jesús, ja 'bärp'ʉtho rá̱ mamá co 'nɛ̱'a̱ rá̱ ju̱huɛ'a̱ rá̱ mamá, conna̱ Ma̱ya rá̱ xisu ra̱ Cleofas, co 'nɛ̱hra̱ Ma̱ya Magdalena 'bäp'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nu̱na̱ ra̱ Jesús mi̱ hyɛ̱trá̱ mamá ngue 'bäp'ʉ, 'dap'ʉ 'bähmi̱ n'na rá̱ xädi ɛ̱mmɛ̱i̱ di̱ ma̱hra̱ Jesús. Bi 'yɛ̱mbrá̱ mamá p'ʉya: ―Ague mamá, gui 'yøt'e ngue ni̱ ba̱si̱ na̱ ma̱ xädigä ya. ");
INSERT INTO otnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma̱hømbi̱ 'yɛ̱mbrá̱ xädi p'ʉya: ―Gui 'yøt'e ngue ni̱ mamá na̱ ma̱ mamágä ya ―bi 'yɛ̱mbi̱. 'Bexque'a̱ ra̱ ora'a̱ p'ʉya, nu̱'a̱ rá̱ xädi ra̱ Jesús bi zixra̱ Ma̱ya p'ʉ ja rá̱ ngu̱ ngue di jamma̱nsu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mi̱ thohna̱ ra̱ hya̱ na̱ p'ʉya, ya pa̱hra̱ Jesús ngue ya bi̱ nja gätho'a̱ te ja ngue di̱ nja. Para ngue di̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, bi 'yɛ̱nna̱ Jesús: ―Dí tu̱thegä ya. ");
INSERT INTO otnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mi̱ jap'ʉ n'na ra̱ xano yu̱hra̱ vino xa̱n'ixi. Bi̱ ma ma̱pobo p'ʉ ja ra̱ vino n'na ra̱ esponja xa̱nthu̱ti̱. Bi̱ nøta̱ n'na ra̱ 'yɛt'o ngue ra̱ isopo. Bi cuarpa̱ rá̱ ne ngue da̱ zʉts'i. ");
INSERT INTO otnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nu̱na̱ ra̱ Jesús mi̱juadi bi zi ra̱ vino xa̱n'ixi, bi 'yɛ̱mp'ʉya: ―Ya gä bi̱ nja'a̱ te ja ngue di̱ nja ya. Mi̱ ma̱n'a̱ p'ʉya, bi̱ mɛngrá̱ ya̱ ngue bi du̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mi̱ hyats'i, ya ra̱ pa ngue ra̱ ts'äya. Nu̱'ʉ yø judío, hi̱ngui̱ nnepe ngue di cuatho p'ʉ ja ra̱ pont'i̱ yø ánima 'mø ra̱ pa ngue ra̱ ts'äya, porque gue'a̱ ra̱ pa ngue ra̱ nga̱xa̱ngo ngue ra̱ pascua'a̱. Ja̱na̱ngue nu̱'ʉ yø hmu̱ yø judío bi xihra̱ Pilato ngue di̱ ma̱nda da̱ ma nthɛ̱mhmi̱ yø gua'ʉ mi̱ cuatra̱ pont'i̱, n'namhma̱ ngue da̱ du̱ nts'ɛdi. Ja̱na̱ngue da̱ tha̱cyø ánima p'ʉ ja ra̱ pont'i̱ 'mø bi du̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bi̱ ma yø soldado p'ʉya ngue bá̱ tɛ̱nnba̱bi̱ yø gua'a̱ n'na nc'ɛ̱i̱. Ja bi̱ map'ʉ'a̱ ma̱n'na ni̱ guatrá̱ hyo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mi̱ map'ʉ cuatra̱ Jesús, bi̱ nu̱ p'ʉya ngue ya xi du̱. Ja̱na̱ngue ya hi̱mbi̱ dɛ̱nnba̱ yø gua na̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pɛ nu̱'a̱ n'na ra̱ soldado siempre bi hyɛ̱spi̱ conna̱ lansa rá̱ hyo ra̱ Jesús. Nu̱p'ʉ bi thɛ̱xpʉya, bi bønna̱ ji 'nɛ̱hra̱ dehe. ");
INSERT INTO otnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nu̱gä go dá̱ ot'ä ra̱ sʉcua̱ ja ua, dá̱ cuati te dá̱ nu̱. Ma̱jua̱ni̱ te dí̱ mma̱. Dí pa̱di̱ ngue ma̱jua̱ni̱ te di̱ mma̱ n'namhma̱ ngue xquet'a̱ gui 'yɛ̱c'ɛ̱i̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Porque nu̱ya yø hya̱ ya, bi̱ nja para ngue di̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ngue i ɛ̱na̱: “Hi̱nda̱ thɛ̱nnba̱bi̱ yø do'yo”, i ɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma̱n'na parte nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro, i ɛ̱na̱: “Da̱ hnu̱ ngue da̱ thɛ̱spa̱ rá̱ do'yo”. ");
INSERT INTO otnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","M'mɛfa p'ʉya, nu̱na̱ n'na ra̱ mmɛ̱ngu̱ Arimatea ni̱ hu̱ ngue ra̱ José, bi̱ ma bá̱ äpra̱ nt'ɛ̱di̱ ra̱ Pilato ngue da̱ hya̱jpʉ ja ra̱ pont'i̱ ra̱ Jesús ngue da̱ 'yägui. Xquet'a̱ 'nɛ̱hna̱ ra̱ José mi̱ tɛnna̱ hya̱ mi̱ mma̱nna̱ Jesús. Pɛ hi̱ngui̱ nnepe da̱ ba̱'ʉ yø mmi̱judíoui, porque su̱. Ra̱ Pilato p'ʉya bi u̱nna̱ nt'ɛ̱di̱. Bi̱ ma ra̱ José ngue bá̱ ha̱jpʉ ja ra̱ pont'i̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Xquet'a̱ bi zømp'ʉ na̱ ra̱ Nicodemo nu̱na̱ bi̱ ma n'na xu̱i̱ bá̱ nya̱ui ra̱ Jesús. Ní̱ hya̱ 'däte ma̱'dɛt'a kilo yø 'yɛ̱thi̱ ma̱ua̱nts'i̱, i̱ n'youi'a̱ ni̱ hu̱ ngue ra̱ mirra, 'nɛ̱'a̱ ra̱ 'yɛ̱thi̱ ni̱ hu̱ ngue ra̱ áloes. ");
INSERT INTO otnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nu̱na̱ ra̱ José conna̱ Nicodemo bi hya̱jpa̱ rá̱ do'yo ra̱ Jesús. Bi 'uɛ conna̱ u̱lu ma̱ njots'i ra̱ 'yɛ̱thi̱ ma̱ua̱nts'i̱. Gue'a̱ yø costumbre yø judío ør'mø ähra̱ ánima'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nu̱p'ʉ bi̱ ma ma̱cuati ra̱ pont'i̱ ra̱ Jesús, guerpʉ mi̱ ja n'na zant'i̱ yø za, ja jarbʉ n'na ra̱ 'bido ngue hi̱njom mi̱ o, ya xi̱ ma ma̱hoqui ngue to da̱ 'yop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nu̱na̱ ra̱ 'bido na̱, ja bi järbʉ ra̱ Jesús, porque ja mi̱ jarbʉtho, 'nɛ̱ ya bi zønna̱ ora da̱ yʉtra̱ pa säya yø judío. ");
INSERT INTO otnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mi̱ hyaxa̱ ra̱ pa ndomingo p'ʉya, zixu̱di̱tho bi̱ ma ra̱ Ma̱ya Magdalena p'ʉ ma̱mbi̱ o ra̱ Jesús. Tobe 'bøndra̱ 'bɛxu̱i̱. Bi̱ nu̱ p'ʉya ngue ya hi̱nte juaxpʉ ra̱ do mi̱ cotra̱ 'bido. ");
INSERT INTO otnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bi gʉ ra̱ 'dihi p'ʉya, bi̱ map'ʉ bí 'bʉhra̱ Bɛdu co 'nɛ̱'a̱ ma̱n'na ra̱ xädi ɛ̱mmɛ̱i̱ ma̱di̱ ma̱hra̱ Jesús. Bi 'yɛ̱mbʉya: ―Ya xa̱ tha̱xpʉ ha mi̱ o ra̱ Hmu̱ 'na̱, pɛ hi̱ndí̱ pa̱hme hapʉ xa̱ jätya. ");
INSERT INTO otnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ra̱ Bɛdu p'ʉya, co 'nɛ̱'a̱ ma̱n'na ra̱ xädi, bi̱ map'ʉ ma̱mbí̱ o ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","'Dap'ʉ bi̱ nɛ̱ts'i gä yoho ngue ni̱ tihi. Pɛ nu̱'a̱ ma̱n'na nc'ɛ̱i̱, ma̱n'na bi̱ nti'a̱ ngue ra̱ Bɛdu. Rá̱ mʉdi bi zømp'ʉ mi̱ o ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Bi̱ ndojpʉya ngue c'a̱t'a̱mbo. Bi̱ nu̱ ngue 'bømp'ʉ yø u̱lu bi 'bännba̱bi̱ ra̱ Jesús. Pɛ hi̱mbi̱ yʉt'a̱mbo. ");
INSERT INTO otnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","'Bexque'a̱ mmarbʉtho ra̱ Bɛdu p'ʉya, go bi yʉt'a̱mbo ra̱ 'bido na̱. Xquet'a̱ bi̱ nu̱ ngue 'bønnbʉtho yø u̱lu ma̱m'mant'i. ");
INSERT INTO otnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Da̱ gue'a̱ ra̱ u̱lu bi jomba̱ rá̱ ya̱ ra̱ Jesús bi̱ nu̱ ngue 'bømp'ʉ, pɛ hi̱nga̱ 'dap'ʉ 'bømhmʉ'ʉ yø u̱lu ma̱m'mänhni̱ ra̱ Jesús. Ma̱ nu̱nni̱'ʉ 'bøn'a̱ n'nani̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Xquet'a̱ bi yʉt'a̱mbo na̱ ra̱ xädi m'mɛt'o bi zømp'ʉ ja ra̱ 'bido p'ʉya. Bi̱ nu̱ te jap'ʉ mi̱ o ra̱ Jesús. Bi 'yɛ̱c'ɛ̱i̱ p'ʉya ngue ya 'bʉi ma̱høn'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ja bi di̱mp'ʉ'a̱ te ra̱ hya̱ nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro p'ʉya, ngue ra̱ Jesús mi̱ jatho ngue di bɛ̱nna̱te p'ʉ da̱ nt'ägui. ");
INSERT INTO otnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bá̱ penc'ʉ yø xädi p'ʉya, bí 'yɛ̱p'ʉ ja ra̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pɛ nu̱na̱ ra̱ Ma̱ya, 'bärma̱ xøts'e ra̱ 'bido ngue zoni̱. Mɛ̱nte zomp'ʉya, bi̱ ndoqui ngue hɛ̱t'a̱mbo ra̱ 'bido. ");
INSERT INTO otnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bi̱ nu̱ ngue 'bʉp'ʉ yoho yø anxɛ p'ʉya, he yø t'axca̱he, ngue hu̱p'ʉ mi̱ o ra̱ Jesús. Nu̱na̱ n'na ra̱ anxɛ hu̱p'ʉ ma̱ni̱ go rá̱ ya̱. Ma̱n'na p'ʉya, hu̱p'ʉ ma̱ni̱ go yø gua. ");
INSERT INTO otnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nu̱ya yø anxɛ p'ʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xisu, ¿hanja ngue guí zoni̱? Mi̱ da̱hra̱ xisu p'ʉya, bi 'yɛ̱na̱: ―Dí zoni̱ tha̱, porque xa̱ tha̱sca̱gui̱ ma̱ Hmu̱. A nu̱yá, hi̱ndí̱ pa̱di̱ hapʉ xa̱ jätya. ");
INSERT INTO otnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mi̱ ma̱nna̱ ra̱ hya̱ na̱ p'ʉya, bi 'bät'i, bi̱ nu̱ p'ʉya ngue 'bäp'ʉ ra̱ Jesús, pɛ hi̱ngui̱ pa̱di̱ ngue gue'a̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","A nu̱na̱ ra̱ Jesús bi 'yännbʉya, bi 'yɛ̱mbi̱: ―Ague grá̱ xisu, ¿hanja ngue guí zoni̱? ¿Te'o guí honi̱? Nu̱na̱ ra̱ xisu p'ʉya, ɛ̱mbi̱ ngue gue'a̱ ra̱ mädi p'ʉ'a̱ 'bäp'ʉ, bi 'yɛ̱mbʉya: ―Ague grá̱ ja̱'i̱, nu̱'mø ngue go xcá̱ hya̱ts'i̱, da̱mi̱ xiqui hapʉ xcuá̱ pɛgui, n'namhma̱ ngue ga̱ ma ha̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mi̱ da̱hra̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague Ma̱ya ―bi 'yɛ̱mbi̱. Ra̱ Ma̱ya p'ʉya, bi 'bät'i, bi zofo conna̱ hya̱ ngue ra̱ ebreo p'ʉya, bi 'yɛ̱mbi̱: ―Raboni̱. Nu̱na̱ ra̱ Raboni̱, i̱ nne da̱ ma̱ “Ague grá̱ xännba̱te”. ");
INSERT INTO otnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱mbi̱: ―O ga̱di bɛnngui̱, porque ja ngue ga̱ mmagä p'ʉ bí 'bʉhma̱ Papá. A nu̱yá, ni̱ ma ya, bá̱ xi'ʉ ma̱ cu̱gä ngue ya ga̱ mmagä p'ʉ bí 'bʉhma̱ Papá, nu̱'a̱ ni̱ Papáhʉ. Ga̱ mmagä p'ʉ bí 'bʉhma̱ Oja̱, nu̱'a̱ ni̱ Oja̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","A nu̱na̱ ra̱ Ma̱ya Magdalena p'ʉya, bi̱ ma bá̱ xipyø xädi ra̱ Jesús. Bá̱ xifi ngue ya xi̱ nu̱'a̱ ra̱ Hmu̱, 'nɛ̱ bá̱ xifi te gäma̱ hya̱ xi xifi. ");
INSERT INTO otnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mi̱ dähra̱ nde'a̱ ndomingo rá̱ mʉdi ra̱ pa ngue ra̱ semana p'ʉya, bi̱ mpɛti yø xädi ra̱ Jesús. Pɛ n'nøt'e xa̱nho yø goxthi p'ʉ ha 'bʉi ngue su̱ yø judío. Mi̱ hnu̱ p'ʉya, ya 'bäp'ʉ ra̱ Jesús, bi̱ m'mäp'ʉ ma̱de ha 'bʉhyø xädi. Bi zɛngua p'ʉya, bi 'yɛ̱mbi̱: ―A nu̱yá, da̱ hyu̱ ni̱ mmʉihʉ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mi̱ juadi bi xihna̱ ra̱ hya̱ na̱ p'ʉya, bi 'yu̱tyø 'yɛ ha bi̱ mfoxyø clavo 'mø mi̱ 'dø'mi̱, 'nɛ̱ bi 'yu̱trá̱ hyo bi̱ mɛ ra̱ lansa. Ja̱njua̱ni̱ ra̱ ndi̱johya'ʉ yø xädi 'mø mi̱ nu̱ yø Hmu̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nu̱na̱ ra̱ Jesús ma̱hømbi̱ 'yɛ̱mbi̱: ―Da̱ hyu̱ ni̱ mmʉihʉ ya. Nu̱gä, tengu̱tho bi̱ mɛngä ua ma̱ Papá, gui̱ njathʉ p'ʉya, xquet'a̱ dí pɛn'na̱hʉ ngue guá̱ ma̱mhmʉ ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bi japrá̱ hya̱ne p'ʉ 'bʉ'ʉ yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―A nu̱yá, guí̱ n'yohʉ ra̱ Espíritu Santo ya. ");
INSERT INTO otnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nu̱'ʉ yø ja̱'i̱ guí pu̱nnba̱hʉ yø ts'oqui, gue'ʉ ya bi pu̱nnba̱bi̱ Oja̱'ʉ. A nu̱'ʉ hi̱ngui̱ pu̱nnba̱hʉ yø ts'oqui, gue'ʉ yø ja̱'i̱ hi̱mbi̱ pu̱nnba̱bi̱ Oja̱'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nu̱na̱ ra̱ Toma, guehna̱ n'na nc'ɛ̱i̱'ʉ yø xädi t'ɛ̱mbi̱ ngue ra̱ cuate. Hi̱njo'o p'ʉ 'mø mi̱ zø'a̱ m'mɛt'o ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nu̱'ʉ mi̱'da yø xädi p'ʉya, bi 'yɛ̱mbi̱: ―Ya xtá̱ nu̱gähe ra̱ Hmu̱. Mi̱ da̱hra̱ Toma p'ʉya, bi 'yɛ̱na̱: ―Mɛ̱nte hi̱ndí̱ nnu̱sɛ, 'nɛ̱ ga̱ nnu̱rpa̱ yø 'yɛ ha bi̱ mfoxyø clavo, hi̱ndí̱ ɛ̱c'ɛ̱i̱ ngue 'bʉi. Nu̱'mø ngue ga̱ thädi conma̱ saha p'ʉ ha bi yʉhyø clavo, 'nɛ̱ ga̱ thännba̱ rá̱ hyo bi̱ mɛ ra̱ lansa, ya ga̱ ɛ̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mi̱ dätra̱ hya̱to ma̱ pa p'ʉya, ma̱hømbi̱ mpɛti p'ʉ ja n'na ra̱ ngu̱'ʉ yø xädi. Mi̱ 'bʉp'ʉ ra̱ Toma'a̱ ra̱ ora'a̱ p'ʉya. Ma̱ nnøt'e xa̱nho yø goxthi, pɛ ja̱ mi̱ hnu̱ ya 'bäp'ʉ ra̱ Jesús. Bi zɛngua p'ʉya, bi 'yɛ̱mbi̱: ―A nu̱yá, da̱ hyu̱ ni̱ mmʉihʉ ya ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bi 'yɛ̱mbra̱ Toma p'ʉya: ―Da̱mi̱ thäni̱ conni̱ saha ya, da̱mi̱ nu̱ yø mɛdi n'youi ma̱ 'yɛ. 'Nɛ̱ da̱mi̱ cʉ'ni̱ 'yɛ ngue gui thängua ja ma̱ hyo bi̱ mɛ ra̱ lansa. 'Yodi yobɛ̱ni̱ ni̱ mmʉi, da̱mi̱ 'yɛ̱c'ɛ̱i̱gui̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Bi 'yɛ̱nna̱ Toma p'ʉya: ―Ague grá̱ Hmu̱, ma̱ Oja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ra̱ Jesús bi 'yɛ̱mbi̱: ―Ague Toma, nu̱ya guí ɛ̱c'ɛ̱i̱gui̱ ya ngue gá̱ nu̱sɛ hanja. Pɛ ra̱ mmɛ̱nthi̱ di̱ nthɛui te'o hi̱mbi̱ nu̱gui̱, 'nɛ̱ bi 'yɛ̱c'ɛ̱i̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nu̱na̱ ra̱ Jesús, yø hmi̱ yø dä yø xädi p'ʉ bi 'yøt'e xa̱ngu̱ yø milagro. Pɛ hi̱nga̱ gä nt'ot'i ua ja ra̱ libro ja ua'ʉ yø milagro bi 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pɛ nu̱ya yø hya̱ ja ua, bi̱ ma nt'ot'i para ngue gui 'yɛ̱c'ɛ̱i̱hʉ ngue nu̱na̱ ra̱ Jesús, guehna̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi na̱, 'nɛ̱ guehna̱ rá̱ Ts'ʉnt'ʉ Oja̱ na̱. Nu̱'mø ngue gá̱ 'yɛ̱c'ɛ̱i̱hʉ na̱ p'ʉya, ya di̱ nja'a̱hʉ ra̱ 'da'yo te. ");
INSERT INTO otnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma̱n'na ra̱ pa p'ʉya, nu̱p'ʉ ja ra̱ nenzabi Tiberias, ja ma̱hømbi̱ nya̱ui p'ʉ yø xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ja ua yø thu̱hu̱ ya 'dap'ʉ mi̱ 'yo: Ra̱ Bɛdu, ra̱ Toma nu̱na̱ t'ɛ̱mbi̱ ra̱ cuate, ra̱ Natanael nu̱na̱ ra̱ mmɛ̱ngu̱ Caná ngue Galilea, 'nɛ̱'ʉ yø ts'ʉnt'ʉ ra̱ Zebedeo, 'nɛ̱ ma̱mi̱ yoho yø xädi ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nu̱na̱ ra̱ Bɛdu bi 'yɛ̱mbyø amigo: ―Nu̱gä ga̱ mma ra̱ 'bahua̱ ―bi 'yɛ̱mbi̱. Nu̱'ʉ nzo p'ʉya, bi 'yɛ̱na̱: ―'Nɛ̱cähe ga̱ mmähä 'mø. Bi yʉt'a̱ n'na ra̱ barco p'ʉya, bi̱ ma. Pɛ nu̱'a̱ ra̱ xu̱i̱'a̱ p'ʉya, hi̱n teni̱ hua̱ bi di̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mi̱ nɛ̱ca̱häi p'ʉya, bi hnu̱ ra̱ Jesús ngue 'bäp'ʉ ja ra̱ nenthe. Pɛ hi̱ngui̱ pa̱'ʉ yø xädi ngue gue'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Bi 'yɛ̱nna̱ Jesús: ―Ague n'yø'a̱hʉ, ¿ua hi̱n teni̱ hua̱ guí thɛui ya? Nu̱'ʉ yø mahua̱ p'ʉya bi 'yɛ̱mbi̱: ―Hi̱ngui̱ ts'ʉ cuø. ");
INSERT INTO otnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'yɛntra̱ xit'a̱ p'ʉ ja rá̱ hyo ra̱ barco ngue n'yɛi ya'mø, guí thɛui yø hua̱ p'ʉya. Bi 'yɛntra̱ xit'a̱ p'ʉya. M'mɛfa, asta̱ hi̱ngui̱ hät'i da̱ jʉxra̱ xit'a̱ p'ʉ ja ra̱ dehe, ngue xa̱ngu̱ yø hua̱ bá̱ cʉp'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nu̱'a̱ ra̱ xädi ɛ̱mmɛ̱i̱ di̱ ma̱hra̱ Jesús bi 'yɛ̱mbra̱ Bɛdu'a̱ p'ʉya: ―Guehna̱ ma̱ Hmu̱hʉ na̱ n'yø. Høntho bi 'yøhra̱ Bɛdu ngue t'ɛ̱mbi̱ gue'a̱ ra̱ Hmu̱'a̱ 'bäp'ʉ, bi hye rá̱ pahni̱ p'ʉya, porque xi̱ mmøgue. Mi̱ hye p'ʉya, bi̱ nhyørbʉ ja ra̱ dehe ngue bi zøn'a̱ nts'ɛdi p'ʉ bi 'bäi. ");
INSERT INTO otnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma̱n'na ciento metro ma̱di̱ 'bɛdi ngue da̱ zøn'a̱ nenthe ra̱ barco. Nu̱'ʉ mi̱'da yø xädi p'ʉya, bi 'yonna̱ barco bi zøn'a̱ nnengui, ní̱ gʉtra̱ xit'a̱ cʉ yø hua̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mi̱ zøn'a̱ nenthe p'ʉya, ya mi̱ zø ra̱ sibi, oxpʉ 'da yø hua̱ ngue ntha̱xi̱. Jap'ʉ ra̱ thu̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nu̱na̱ ra̱ Jesús bi 'yɛ̱mbi̱: ―Bá̱ cʉui ua yø hua̱ ja gui thɛui ya. ");
INSERT INTO otnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Bi̱ nexpʉ ja ra̱ barco ra̱ Bɛdu p'ʉya, ngue bá̱ jʉnna̱ xit'a̱, bi zøp'ʉ hi̱ngui̱ hɛ̱ ra̱ dehe. Pɛ bá̱ yu̱hyø ndøhua̱ ra̱ xit'a̱, n'na ciento 'nɛ̱ yote ma̱'dɛ'ma̱ hyu̱ yø hua̱ bá̱ cʉp'ʉ. Xa̱ndøngu̱, pɛ hi̱mbi̱ xɛtra̱ xit'a̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Bi 'yɛ̱mbyø xädi ra̱ Jesús: ―'Dɛ gui̱ nzimxu̱di̱ui ya. Nu̱'ʉ yø xädi p'ʉya, hi̱njombi̱ 'yänni̱ te'o na̱ ra̱ Jesús, porque ya pa̱di̱ te'o. ");
INSERT INTO otnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","'Bexpi guatra̱ Jesús, mi̱ hya̱cra̱ thu̱hmɛ̱, bi u̱nni̱ da̱ zi. Bi hya̱cra̱ hua̱ p'ʉya, bi u̱nni̱ da̱ za. ");
INSERT INTO otnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ya rá̱ hyu̱ ndi̱ na̱ ra̱ ora na̱, ngue ma̱hømbi̱ nya̱ui yø xädi 'mø mi̱ bɛ̱nna̱te ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mi̱ juadi bi̱ nsi̱hmɛ̱ p'ʉya, nu̱na̱ ra̱ Jesús bi 'yänna̱ Bɛdu, bi 'yɛ̱mbi̱: ―Ague Bɛdu, rá̱ ts'ʉnt'ʉ'i ra̱ Jonás. ¿Ua ma̱n'na ga̱di̱ ma̱qui̱ ngue tengu̱ gui ma̱cä ya mi̱'da? Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―A̱há̱, grá̱ Hmu̱. Nu̱'i̱ guí pa̱di̱ ngue da̱di̱ ma̱'i̱. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbʉya: ―Da̱mi̱ fähyø ja̱'i̱ nu̱'ʉ ɛ̱c'ɛ̱i̱gä ya'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Rá̱ yondi̱ p'ʉya, ma̱hømbi̱ 'yɛ̱mbi̱: ―Ague Bɛdu, rá̱ ts'ʉnt'ʉ'i ra̱ Jonás. ¿Ua ga̱di̱ ma̱qui̱? Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―A̱há̱, grá̱ Hmu̱. Guí pa̱di̱ ngue da̱di̱ ma̱'i̱. Mi̱ nya̱ ra̱ Jesús, bi 'yɛ̱mbʉya: ―Da̱mi̱ fähyø ja̱'i̱ nu̱'ʉ ɛ̱c'ɛ̱i̱gä ya'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Rá̱ hyu̱ ndi̱ p'ʉya, ma̱hømbi̱ 'yɛ̱mbi̱: ―Ague Bɛdu, rá̱ ts'ʉnt'ʉ'i ra̱ Jonás. ¿Ua ga̱di̱ ma̱qui̱? Nu̱na̱ ra̱ Bɛdu p'ʉya, bi du̱ rá̱ mmʉi porque ya rá̱ hyu̱ ndi̱ bi 'yänni̱ ngue'mø di̱ ma̱di̱. Bi 'yɛ̱nna̱ Bɛdu p'ʉya: ―Ague grá̱ Hmu̱, nu̱'i̱ gätho guí pa̱di̱. 'Nɛ̱ guí pa̱di̱ ngue da̱di̱ ma̱'i̱. Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbʉya: ―Nu̱'mø ngue ga̱di̱ ma̱qui̱, da̱mi̱ fähyø ja̱'i̱ nu̱'ʉ ɛ̱c'ɛ̱i̱gä ya'mø. ");
INSERT INTO otnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ma̱jua̱ni̱ dí xi'i ngue nu̱'mø ma̱rá̱ ngüɛ'i, bi zä gá̱ dʉtni̱ ngʉt'i, gui pa hapʉ guí̱ nne gui̱ mma. Pɛ da̱ zønna̱ pa ngue gui̱ nda̱c'ɛ̱i̱, gui̱ majni̱ 'yɛ p'ʉya ngue n'nan'yo ra̱ ja̱'i̱ di dʉt'a̱'i̱, nu̱p'ʉ hapʉ hi̱nguí̱ nne gui̱ mma, ja di zixa̱'i̱ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ngu̱na̱ ra̱ hya̱ bi̱ ma̱nna̱ Jesús, di opa̱n'yu̱ ra̱ Bɛdu te ra̱ forma ja ngue di tho, gue'a̱ di 'yɛ̱spa̱bi̱ Oja̱'a̱ di du̱. M'mɛfa p'ʉya bi 'yɛ̱mbi̱: ―Ogui hɛga̱gui̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bi̱ nyɛ̱hra̱ Bɛdu p'ʉya, bi̱ nu̱ ngue mmap'ʉ'a̱ ma̱n'na rá̱ xädi ɛ̱mmɛ̱i̱ di̱ ma̱hra̱ Jesús. Guehna̱ rá̱ xädi bi 'yørpa̱ ra̱ nt'änni̱'a̱ ra̱ ora 'dap'ʉ mi̱ si̱hmɛ̱ui yø xädi ra̱ Jesús. Bi 'yɛ̱mbi̱: “Ague grá̱ Hmu̱, ¿te'o'a̱ ja ngue di dä'i?” bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mi̱ nu̱ ra̱ Bɛdu na̱ p'ʉya, bi 'yänna̱ Jesús, bi 'yɛ̱mbi̱: ―Xina̱ 'bʉcua, ¿te 'bɛ'a̱ da̱ tho na̱? ");
INSERT INTO otnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'mø ga̱ nnegä ngue di̱ m'mʉcua nʉ asta̱ gue'mø dá̱ pengui̱, ya di̱ njatho. Xi'i, ¿te go di̱ mporta'i̱? Nu̱'i̱ 'yo gui hɛga̱gui̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ya bi̱ n'yo ra̱ hya̱ p'ʉ ha 'bʉ hmi̱'da yø 'yɛ̱c'ɛ̱i̱ p'ʉya, ngue t'ɛ̱mbi̱ ya hi̱nda̱ du̱ na̱ ra̱ xädi na̱. Pɛ nu̱na̱ ra̱ Jesús hi̱ngue masque bi̱ ma̱ ngue hi̱nda̱ du̱. Sinoque bi 'yɛ̱na̱: “Nu̱'mø ngue ga̱ nnegä di̱ m'mʉcua nʉ asta̱ gue'mø dá̱ pengui̱, xi'i, ¿te go di̱ mporta'i?” bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nu̱na̱ ra̱ xädi na̱ya, guehna̱ ra̱ xädi di ja ma̱jua̱ni̱ na̱ ra̱ hya̱ na̱ya, 'nɛ̱ bi 'yot'ua ja ra̱ sʉcua̱ na̱ ra̱ hya̱ mma̱. Pɛ dí pa̱hmʉ ngue ma̱jua̱ni̱ te mma̱. ");
INSERT INTO otnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Xa̱ngu̱ te gä bi 'yøtra̱ Jesús. Pɛ nu̱'mø ngue xta̱ mma nt'ot'i ua ja ra̱ sʉcua̱ n'na ngu̱ n'na'ʉ yø hya̱ ya, rá̱ nzɛgui hi̱nxti 'yɛngua ja ra̱ xi̱mhäi yø libro xta̱ mma nt'ot'i 'mø. Da̱ ngu̱t'a̱tho.");
INSERT INTO otnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ague Teófilo, nu̱na̱ rá̱ mʉdi ra̱ libro dá̱ ot'i, gä dá̱ cuatra̱ sʉcua̱ te gä bá̱ ørbʉ bá̱ fʉdi bi̱ nxännba̱te ra̱ Jesús, ");
INSERT INTO otnNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta̱ gue'mø mi̱ ma ma̱hɛ̱ts'i̱. Pɛ hante da̱ ma ma̱ya̱, nu̱ya yø xädi xi huanhni̱ ngue yø representante, bi xifi te nnepra̱ Espíritu Santo da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Porque nu̱'mø mi̱ bɛ̱nna̱te p'ʉ bi t'ägui, søp'ʉ 'bʉhyø xädi ra̱ Jesús ngue ya̱ui. Mɛ̱nte gue'a̱ nyote ma̱ pa, njandyatho bi̱ hnu̱ ra̱ Jesús. Ja̱na̱ngue bi fa̱di̱ ngue ma̱jua̱ni̱ 'bʉi ma̱høn'a̱. Bi opa̱n'yu̱ yø xädi ra̱ Jesús ngue ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nu̱'mø tobe 'dap'ʉ 'bʉhmʉ yø xädi ra̱ Jesús, bi xifi ngue hi̱nda̱ bømp'ʉ ja ra̱ hni̱ni̱ Jerusalén. Bi 'yɛ̱mbi̱: ―Da̱mi̱ tømhmʉ na̱ ra̱ hya̱ ya xtá̱ xi'a̱hʉ ngue di ya̱t'a̱hʉ ma̱ Papágä. ");
INSERT INTO otnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ma̱jua̱ni̱ ngue bi 'yøtra̱ nxixya̱ ra̱ Xuua conna̱ dehe, pɛ ya hi̱mma̱ ya'atho yø pa di ha̱'a̱hʉ ra̱ ts'ɛdi ra̱ Espíritu Santo ya. ");
INSERT INTO otnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma̱hømbi̱ nya̱ui yø xädi ra̱ Jesús. Pɛ bi 'yørpa̱ ra̱ nt'änni̱ ya yø xädi, bi 'yɛ̱mbi̱: ―Ague grá̱ Hmu̱, ¿ua guehyø pa ja ua gui 'yøt'e ngue di̱ mma̱ndasɛ yø ja̱'i̱ ua ja ra̱ häi Israel? ");
INSERT INTO otnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Nu̱'a̱ ra̱ hya̱ xa̱ nzänna̱ Papá da̱ 'yøt'e, hi̱ngui̱ ja ngue go guí pa̱hmʉ tema̱ pa, ogue tema̱ ora da̱ni̱ nja'a̱. ");
INSERT INTO otnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pɛ di ha̱'a̱hʉ ra̱ ts'ɛdi ra̱ Espíritu Santo ngue gui japhʉ ma̱jua̱ni̱ yø ja̱'i̱ te'ogä. Ngu̱na̱ ra̱ hya̱ gui xihmʉ yø ja̱'i̱ 'bʉp'ʉ Jerusalén, gätho mi̱'da yø ja̱'i̱ 'bʉp'ʉ ja ra̱ häi Judea, da̱ guep'ʉ ja ra̱ häi Samaria, asta̱ gue'mø gá̱ täthʉ rá̱ ngʉni̱ nxi̱mhäi. ");
INSERT INTO otnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mi̱ juadi bi̱ ma̱nna̱ ra̱ hya̱ bi̱ ma̱mp'ʉya, hɛ̱tho yø xädi ha i̱ ma ma̱ya̱ ra̱ Jesús. Bi yʉrbʉ ja n'na ra̱ gu̱i̱ p'ʉya, ya hi̱nni̱ mantho bi hyandi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hi̱ngui̱ hɛgui hantho ma̱hɛ̱ts'i̱ ha i̱ mpa. Mi̱ nu̱ p'ʉya, 'bäp'ʉ yoho yø anxɛ, he yø t'axca̱he. ");
INSERT INTO otnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bi 'yɛ̱mbʉya: ―Ague gyø mmɛ̱ngu̱hʉ Galilea, ¿hanja ngue guí hanthʉ ma̱ya̱? Ya gá̱ nu̱hʉ ngue bi̱ ma ma̱hɛ̱ts'i̱ ra̱ Jesús, pɛ ma̱hønda̱ ɛ̱p'ʉ tengu̱tho guí̱ nu̱hʉ ngue i̱ ma ya. ");
INSERT INTO otnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nu̱ya yø xädi ma̱mbi̱ 'bʉp'ʉ ja ra̱ nyu̱ni̱ ja ra̱ mbonza ja yø olivos, bá̱ ɛ̱hɛ̱, bi zø'a̱ Jerusalén. Nu̱na̱ ra̱ nyu̱ni̱ na̱, guerpʉtho ngue Jerusalén, comma̱ n'na kilómetro. ");
INSERT INTO otnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mi̱ zømp'ʉ ja ra̱ hni̱ni̱ p'ʉya, bi̱ nexpʉ ja ra̱ tøca̱ngu̱ mi̱ nsäya. Nu̱ya yø xädi, guehna̱ ra̱ Bɛdu, ra̱ Jacobo, ra̱ Xuua, ra̱ Andre, ra̱ Lipe, ra̱ Toma, ra̱ Bartolomé, ra̱ Mateo, ra̱ Jacobo nu̱na̱ rá̱ ts'ʉnt'ʉ ra̱ Alfeo, ra̱ Simu̱ nu̱na̱ n'yohʉ ra̱ partido ngue ra̱ zelote, ra̱ Judas nu̱na̱ rá̱ n'yohʉ ra̱ Jacobo. ");
INSERT INTO otnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gätho ya p'ʉya, 'dap'ʉ bi̱ mpɛti ngue mmat'Oja̱. Mi̱ 'bʉp'ʉ mi̱'da yø xisu, 'nɛ̱hra̱ Ma̱ya rá̱ mamá ra̱ Jesús, 'nɛ̱'ʉ yø cu̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","N'na ra̱ pa p'ʉya, xi̱ mpɛti comma̱ n'na ciento 'nɛ̱ 'däte nja̱'i̱. Bi̱ nangra̱ Bɛdu p'ʉya, bi̱ m'mäp'ʉ ma̱de 'bʉhyø 'yɛ̱c'ɛ̱i̱. Bi 'yɛ̱mbʉya: ");
INSERT INTO otnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Ague ma̱ zi cu̱'a̱hʉ, jatho ngue di̱ nja'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro. Porque ra̱ David, ra̱ Espíritu Santo bi bɛ̱nnba̱bi̱ na̱ ra̱ hya̱ bi 'yot'i ngue bi̱ ma̱ te da̱ thohra̱ Judas. A nu̱na̱ ra̱ Judas, guehna̱ bi̱ m'mɛt'o ngue bi̱ zixyø ja̱'i̱ bi bɛntra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ma̱ma̱ n'yogähe na̱ ra̱ Judas, porque xquet'a̱ bi tocabi ra̱ 'bɛfi ngue rá̱ representante ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","A nu̱na̱ p'ʉya, nu̱'a̱ rá̱ nzäbi bi da̱ha̱ ngue bi dä ra̱ Jesús, bi thän'a̱ n'na ra̱ häi. Nu̱na̱ ra̱ häi na̱, ja bi du̱p'ʉ ra̱ Judas ngue bi dägui, i̱ m'mänya̱. Bi bøni̱ gätho yø xɛ̱fo ngue bi føgue. ");
INSERT INTO otnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nu̱'mø mi̱ 'yøhyø mmɛ̱ngu̱ Jerusalén te bi̱ nja, i hu̱tra̱ häi ngue ra̱ Acéldama, gue'a̱ ra̱ hya̱ ga̱ ya̱ yø ja̱'i̱'a̱. I̱ nne da̱ ma̱, ni̱ hu̱ ra̱ häi ngue ra̱ ji. ");
INSERT INTO otnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ngu̱na̱ ra̱ hya̱ bi cuarpʉ ja ra̱ libro ngue yø Salmo ra̱ David, bi 'yɛ̱na̱: “Da̱ du̱ ra̱ mmɛ̱nni̱gu̱, ya hi̱njondi̱ m'mʉp'ʉ ja rá̱ ngu̱”, bi 'yɛ̱na̱. Xquet'a̱ bi 'yɛ̱na̱: “Ndan'yo to di thojpa̱ rá̱ 'bɛfi”. ");
INSERT INTO otnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","A nu̱ua dí 'bʉhmʉ ya, 'bʉcua 'da yø n'yohʉ ngue hi̱ngui̱ hɛga̱he mɛ̱nte yø pa dá̱ n'yohe ra̱ Hmu̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bi̱ nu̱p'ʉ bi xixya̱bi̱ ra̱ Xuua, 'nɛ̱ bi̱ nu̱ 'mø mi̱ ma ma̱hɛ̱ts'i̱. A nu̱yá, jatho ngue da̱ guehya 'da yø n'yohʉ ya, da̱ t'ɛ̱ts'i̱ ngue 'dap'ʉ ga̱ n'yohe ngue di ja ma̱jua̱ni̱ p'ʉ bi bɛ̱nna̱te ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bi thanhni̱ yo nc'ɛ̱i̱ p'ʉya, ra̱ Matías 'nɛ̱hra̱ José. Nu̱na̱ ra̱ José p'ʉya, ja mi̱'da yø thu̱hu̱ ngue i Barsabás 'nɛ̱ i Justo. ");
INSERT INTO otnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mi̱ mat'Oja̱ yø ja̱'i̱ p'ʉya, bi 'yɛ̱na̱: ―Ma̱ Oja̱'i̱, nu̱'i̱ guí pa̱rpa̱bi̱ yø n'yomfɛ̱ni̱ yø ja̱'i̱. Da̱mi̱ 'yu̱hya ndana̱ guí huanhya yo nc'ɛ̱i̱ 'bʉcua ya. ");
INSERT INTO otnNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nu̱na̱ ra̱ n'yohʉ guí huanhni̱, di thocra̱ 'bɛfi, ngue ra̱ representante mi̱ pɛhra̱ Judas, nu̱na̱ bi hyɛp'ʉ rá̱ 'bɛfi 'mø mi̱ 'yøtra̱ ts'oqui, nu̱p'ʉ ni̱ 'yu̱p'ʉ di̱ ma, ja i̱ map'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bi gʉcra̱ suerte yø ja̱'i̱ p'ʉya. Nu̱na̱ ra̱ suerte, bi̱ nthɛui ra̱ Matías. 'Bexque'a̱ ra̱ ora'a̱ p'ʉya, 'dap'ʉ bi̱ n'yohʉ'ʉ 'dɛ'ma̱'da nc'ɛ̱i̱ yø representante na̱ ra̱ Matías. ");
INSERT INTO otnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nu̱'mø mi̱ zøhra̱ pa ngue ra̱ ngo Pentecostés, gä xi̱ mpɛti yø 'yɛ̱c'ɛ̱i̱ p'ʉ ja n'na ra̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xøgue ntha̱mbɛ̱ni̱tho bí 'yɛ̱hma̱ya̱, ɛ̱na̱ n'na ra̱ ndønthi̱ ra̱ ndi fʉt'a̱mbo ra̱ ngu̱. Gä bi 'yu̱p'ʉ ja ra̱ ngu̱ xi̱ mi̱hyø 'yɛ̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bi hnu̱ p'ʉya ngue ɛ̱na̱ yø ja̱ni̱ yø sibi di̱ nxa̱mp'ʉ hu̱di̱ n'na ngu̱ n'na. ");
INSERT INTO otnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Guehna̱ ra̱ Espíritu Santo di ha̱tra̱ ts'ɛdi yø ja̱'i̱. Nu̱na̱ ra̱ Espíritu Santo, bi japyø ja̱'i̱ ngue ga̱ ya̱ yø 'dan'yo hya̱ hi̱ngui̱ pa̱di̱. N'na ngu̱ n'na yø ja̱'i̱, gue'a̱ ra̱ Espíritu Santo xännbi̱ tema̱ hya̱ da̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nu̱'a̱ ra̱ pa'a̱ p'ʉya, nu̱p'ʉ Jerusalén mi̱ 'bʉp'ʉ 'da yø judío xpí 'yɛ̱hɛ̱ 'dama̱ 'dan'yo yø häi ngue da̱ nu̱ ra̱ da̱nni̱go. ");
INSERT INTO otnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Guehya xi̱ mpɛti 'mø mi̱ 'yøde ngue ɛ̱na̱ 'yo ra̱ ndønthi̱ ya. Mi̱ 'yøde ngue di ya̱hni̱ yø 'yɛ̱c'ɛ̱i̱ p'ʉya, hi̱ngui̱ pa̱di̱ hanja ngue ga̱ ya̱ yø 'yɛ̱c'ɛ̱i̱'a̱ te yø hya̱. Porque øhyø ja̱'i̱ ngue ga̱ ya̱ yø 'yɛ̱c'ɛ̱i̱'a̱ te yø hya̱ ga̱ ya̱p'ʉ ja yø häi xpí 'yɛ̱hɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gä di 'yødyø ja̱'i̱, hi̱ngui̱ pa̱di̱ te da̱ 'yøt'e. Di̱ n'yɛ̱mbi̱ n'na ngu̱ n'na: ―Nu̱ya yø n'yohʉ di ya̱hni̱ ua, gä yø mmɛ̱ngu̱ Galilea ya. ");
INSERT INTO otnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pɛ ¿hague nja ngue dí øhmʉ ga̱ ya̱'a̱ te ma̱ hya̱hʉ n'na ngu̱ n'najʉ? ");
INSERT INTO otnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A nu̱yá, 'bʉcua yø mmɛ̱ngu̱ Partia, yø mmɛ̱ngu̱ Media, yø mmɛ̱ngu̱ Elam, yø mmɛ̱ngu̱ Mesopotamia, yø mmɛ̱ngu̱ Judea, yø mmɛ̱ngu̱ Capadocia, yø mmɛ̱ngu̱ Ponto, yø mmɛ̱ngu̱ Asia, ");
INSERT INTO otnNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","yø mmɛ̱ngu̱ Frigia, yø mmɛ̱ngu̱ Panfilia, yø mmɛ̱ngu̱ Egipto, yø mmɛ̱ngu̱ Africa nu̱ya rá̱ m'mʉp'ʉ ma̱n'na rá̱ nguep'ʉ ngue ra̱ hni̱ni̱ Cirene. Xquet'a̱ 'bʉcua yø mmɛ̱ngu̱ Roma. Nu̱ 'da'ʉ p'ʉya, yø judío p'ʉ bá̱ mi̱, mi̱'da p'ʉya, ya xa̱ bɛnnba̱bi̱ yø nt'ɛ̱c'ɛ̱i̱ yø judío. ");
INSERT INTO otnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Xquet'a̱ 'bʉcua yø mmɛ̱ngu̱ Creta, yø mmɛ̱ngu̱ Arabia. 'Nɛ̱ dí øhmʉ ngue ɛ̱spa̱bi̱ Oja̱ yø ja̱'i̱, 'nɛ̱ ga̱ ya̱'a̱ te ma̱ hya̱hʉ n'na ngu̱ n'najʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gä di 'yødyø ja̱'i̱, hi̱ngui̱ pa̱di̱ hanja ngue ga̱ ya̱ yø 'yɛ̱c'ɛ̱i̱'a̱ te yø hya̱ ga̱ ya̱. Di̱ n'yänni̱ n'na ngu̱ n'na p'ʉya, di̱ n'yɛ̱mbi̱: ―¿Hanja'a̱ te hma̱ngua? ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pɛ thentho mi̱'da yø ja̱'i̱, i ɛ̱mbi̱ ngue i̱ti̱'ʉ di ya̱hni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nu̱na̱ ra̱ Bɛdu mi̱ 'bäp'ʉ p'ʉya, 'dap'ʉ 'bähmʉ'ʉ 'dɛ'ma̱'da yø representante ra̱ Jesús. Bi ts'ɛdi bi 'yɛ̱mbyø ja̱'i̱: ―Ague gyø judío guí søthʉ ua, da̱ guehyø mmɛ̱ngu̱ ua Jerusalén, da̱mi̱ pa̱hmʉ hanja na̱ ra̱ hya̱ jap'ʉ ya. Da̱mi̱ 'yøhmʉ xa̱nho ra̱ hya̱ ga̱ xi'a̱hʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nu̱ya yø n'yohʉ 'bʉcua, hi̱ngui̱ i̱ti̱ ya tengu̱tho guí̱ mbɛ̱mhmʉ. Porque hi̱njongui̱ i̱ti̱'a̱ gʉto xu̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nu̱na̱ te bi̱ nja ya, guehna̱ ra̱ hya̱ bi̱ ma̱nna̱ pønga̱hya̱ Joel ngue bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ga̱ xi'a̱hʉ ra̱ hya̱ mma̱n'Oja̱. Bi yɛ̱na̱: Da̱ 'yɛ̱hra̱ pa ga̱ pɛnnba̱bi̱ ra̱ Espíritu Santo gätho yø ja̱'i̱ 'bʉi rá̱ ngʉni̱ nxi̱mhäi. Guehna̱ di bɛ̱nnba̱bi̱ ra̱ hya̱ da̱ ma̱nni̱ ts'ʉnt'ʉhʉ 'nɛ̱hni̱ t'i̱xu̱hʉ na̱. Yø ts'ʉnt'ʉ da̱ nu̱ yø cosa hi̱ngui̱ nnu̱ mi̱'da yø ja̱'i̱. Yø da̱c'ɛ̱i̱ da̱ 'ui̱ yø t'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nu̱'ʉ yø pa'ʉ, ga̱ pɛnnba̱bi̱ ra̱ Espíritu Santo ma̱ mɛfi ngue yø n'yohʉ 'nɛ̱hyø xisu. Guehna̱ di bɛ̱nnba̱bi̱ ra̱ hya̱ da̱ ma̱nna̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ga̱ øt'ä yø milagro nʉ ma̱ya̱. Nu̱ua ja ra̱ häi p'ʉya, di̱ nja yø hmɛ̱ya ngue ra̱ ji, 'nɛ̱hra̱ sibi, da̱ nangra̱ 'bifi. ");
INSERT INTO otnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ya hi̱ndi̱ yotra̱ hyadi. Xtá̱ nthɛni̱ ra̱ za̱na̱ tengu̱tho ra̱ ji. Guehna̱ di̱ nja na̱ya hante ngue da̱ zønna̱ pa dá̱ ɛ̱p'ʉ ra̱ Hmu̱. Guehna̱ ra̱ pa di̱ nɛ̱qui̱ rá̱ ts'ɛdi Oja̱ ma̱guesɛ. ");
INSERT INTO otnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nu̱ te'o gä nzo Oja̱, gue'ʉ di̱ nya̱nyø te'ʉ”, i ɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ra̱ Bɛdu p'ʉya, bi sigue bi 'yɛ̱mbyø ja̱'i̱: ―Ague gyø judíohʉ, da̱mi̱ 'yøhmʉ ra̱ hya̱ ga̱ mma̱ngä. Bi ne Oja̱ ngue bi 'yøtyø milagro p'ʉ guí 'bʉhmʉ conná̱ nguehna̱ ra̱ Jesús ra̱ mmɛ̱ngu̱ Nazaret. Ja̱na̱ngue guí pa̱hmʉ ngue guesɛ Oja̱ bi ha̱tra̱ ts'ɛdi'a̱ te bi 'yøtra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pɛ gá̱ däphʉ yø ts'oc'ɛ̱i̱ ra̱ Jesús ngue bi cuatra̱ pont'i̱, bi hyo. Pɛ ya ma̱nja̱m'mø xpá̱ nzän'Oja̱ ngue bi zo ni̱ 'yɛhʉ ra̱ Jesús ngue gá̱ jahʉ p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pɛ nu̱yá, Oja̱ bi japi ngue bi bɛ̱nna̱te ra̱ Jesús. Bi gʉjpʉ ja ra̱ nda̱te mi̱ o, porque hi̱ngui̱ sä ngue da̱ cop'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ja bi bømp'ʉ'a̱ te bi̱ ma̱nna̱ David conná̱ nguehra̱ Jesús ngue bi 'yɛ̱na̱: “Za̱nt'a̱ ga̱ n'yo'be Oja̱. Oja̱ 'bʉp'ʉ ja ma̱ n'yɛi, n'namhma̱ ngue hi̱njonda̱ 'ya̱ngui̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ja̱na̱ngue da̱di johya, ga̱ mma̱ hanja ngue ja gra̱ pähä. 'Nɛ̱ hu̱ ma̱ mmʉi ngue te da̱ thohma̱ do'yo 'mø dá̱ tu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porque hi̱nguá̱ soga̱gui̱ ma̱ tegä p'ʉ ha o yø ánima. Hi̱ngui̱ jaqui da̱ 'ya ma̱ do'yo, porque ni̱ mɛfigui ga̱di̱ ma̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nu̱'i̱ gá̱ xoga̱gui̱ ma̱ mmʉi ngue dá̱ pa̱di̱ ngue ja gra̱ te para za̱ntho. Ya ma̱n'natho di̱ njaga̱ mpähä 'mø ga̱ nnu̱'i̱”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ague n'yø'a̱hʉ, dí̱ nne ga̱ xi'a̱hʉ te bi thohna̱ ma̱ mboxitahʉ ra̱ David. Bi du̱ na̱, 'nɛ̱ bi t'ägui. A nu̱'a̱ rá̱ panteón, i jatho asta̱ guehra̱ pa jap'ʉ'a̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pɛ nu̱na̱ ra̱ David ma̱rá̱ pønga̱hya̱ Oja̱ na̱. Mi̱ pa̱di̱ te xi ya̱rpa̱bi̱ Oja̱, ngue nu̱na̱ n'na'ʉ yø mbom'mɛto, guehna̱ ra̱ Cristo na̱ya. Go di ponnba̱bi̱'a̱ ra̱ nda̱st'abi mi̱ pɛhra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nu̱na̱ ra̱ David, ya mi̱ pa̱'a̱ m'mɛt'o ngue di bɛ̱nna̱te ra̱ Cristo na̱. Ja̱na̱ngue bi̱ ma̱mp'ʉya ngue rá̱ te ra̱ Cristo, hi̱nda̱ ts'ojpa̱bi̱ p'ʉ ha o yø ánima. Bi̱ ma̱ ngue hi̱nda̱ 'ya rá̱ do'yo. ");
INSERT INTO otnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Oja̱ bi japi ngue bi bɛ̱nna̱te ra̱ Jesús. Gäthogähe ya, gä da̱di jahe ma̱jua̱ni̱ ngue bi bɛ̱nna̱te na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nu̱na̱ Oja̱ nnepe ngue da̱ hnu̱ ma̱nsu̱ ra̱ Jesús, bi zixpʉ bí ja rá̱ n'yɛi. Nu̱na̱ ra̱ Espíritu Santo ya xi ya̱t'Oja̱ ngue da̱ pɛnhni̱, bi japra̱ Jesús ngue bá̱ pɛnhni̱, bi zøcua dí 'bʉhmʉ. A nu̱yá, guehna̱ ra̱ Espíritu Santo go øt'a̱ te guí̱ nnu̱hʉ ya, 'nɛ̱'a̱ ra̱ hya̱ guí øhmʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A nu̱na̱ ra̱ David, hi̱mbi̱ ts'ixma̱te p'ʉ ja rá̱ n'yɛi Oja̱ na̱. Sinoque bi 'yɛ̱na̱: “Nu̱na̱ Oja̱, nu̱'mø mi̱ zojpa̱gui̱ ma̱ Hmu̱, ngu̱na̱ ra̱ hya̱ bi xifi, bi 'yɛ̱mbi̱: Da̱mi̱ mi̱cua ja ma̱ n'yɛigä ya, ");
INSERT INTO otnNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta̱ gue'mø ga̱ øt'e ngue guí̱ ma̱nda gätho'ʉ ni̱ nsʉiui”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Gätho yø judío rá̱ m'mʉp'ʉ ja ra̱ häi Israel, jatho ngue da̱ ba̱'a̱ njua̱ni̱ te'o na̱ ra̱ Jesús. Guehna̱ ra̱ Cristo bá̱ ɛ̱x Oja̱ ngue di̱ nda̱st'abi na̱. Pɛ nu̱'a̱hʉ, gá̱ cuathʉ ra̱ pont'i̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Gä bi där'ma̱n'ʉ yø mmʉi yø ja̱'i̱ 'mø mi̱ 'yøhna̱ ra̱ hya̱ bi̱ ma̱nna̱ Bɛdu p'ʉya. Bi 'yørpa̱ ra̱ nt'änni̱ ra̱ Bɛdu p'ʉya co 'nɛ̱'ʉ mi̱'da yø representante ra̱ Jesús, bi 'yɛ̱mbi̱: ―Ague n'yø'a̱hʉ, ¿te 'bɛ'a̱ ja ngue ga̱ øt'ähe p'ʉya? ");
INSERT INTO otnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱mbyø ja̱'i̱: ―Da̱mi̱ hyɛhmʉ p'ʉ ra̱ nts'o n'na ngu̱ n'na'a̱hʉ. Jatho ngue gui̱ nxixya̱hʉ, gue'a̱ di fa̱di̱ ngue guí ɛ̱c'ɛ̱i̱hʉ ra̱ Jesucristo'a̱. Nu̱na̱ Oja̱ p'ʉya, di pu̱n'na̱ ni̱ ts'oquihʉ, 'nɛ̱ da̱ pɛn'na̱hʉ ra̱ Espíritu Santo. ");
INSERT INTO otnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Porque go di toca'a̱hʉ na̱ ra̱ hya̱ ya xa̱ mma ma̱ya̱t'i̱, 'nɛ̱ ni̱ ba̱si̱hʉ, 'nɛ̱'ʉ to gä rá̱ m'mʉp'ʉ 'yapʉtho. Nu̱na̱ Oja̱ ma̱ Hmu̱hʉ, i̱ nzohni̱ hangu̱ yø ja̱'i̱ nne prá̱ mmʉi da̱ zofo. ");
INSERT INTO otnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ra̱ Bɛdu p'ʉya, xa̱ngu̱ mi̱'da yø hya̱ bi xihyø ja̱'i̱. Bi consejo yø ja̱'i̱, bi 'yɛ̱mbi̱: ―Da̱mi̱ hyɛhmʉ p'ʉ'a̱ te gäma̱ nts'o ga̱ 'yo yø ja̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nu̱ya yø ja̱'i̱ bi̱ nu̱ ma̱nho ra̱ hya̱ mma̱nna̱ Bɛdu, bi̱ ma ma̱xixya̱bi̱. Nu̱ya ja ma̱'da'yo bi 'yɛ̱c'ɛ̱i̱ ra̱ hya̱'a̱ ra̱ pa'a̱ p'ʉya, comma̱ hyu̱ ma̱hua̱hi̱ nja̱'i̱ bi zʉdi. ");
INSERT INTO otnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Gätho ya yø ja̱'i̱ ya, hi̱ngui̱ nne da̱ hyɛ'a̱ ra̱ hya̱ xännba̱te yø representante ra̱ Jesús. 'Da'igu̱ mma̱ n'na ngu̱ n'na, 'nɛ̱ 'dap'ʉ mmat'Oja̱. 'Dap'ʉ xɛnna̱ thu̱hmɛ̱ da̱ zi, tengu̱tho ra̱ hya̱ bi zohra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gä bi̱ nsu̱ yø ja̱'i̱ ngue xa̱ngu̱ yø milagro bi 'yøtyø representante ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nu̱'ʉ ya xi 'yɛ̱c'ɛ̱i̱ ra̱ hya̱ p'ʉya, gä 'dap'ʉ di̱ mpɛti. Nu̱'a̱ te gä pɛts'i, 'da gui̱ mmɛtitho. ");
INSERT INTO otnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bi̱ mä yø häi yø ja̱'i̱, nu̱'ʉ ja mi̱'da te mi̱ pɛts'i, gä bi̱ mä. Di̱ ndarpi n'na ngu̱ n'na'a̱ te honi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","N'na pa ngu̱ n'na pa di̱ mpɛti p'ʉ ja ra̱ ni̱ja̱. Nu̱p'ʉ ja yø ngu̱ yø ja̱'i̱, gä 'dap'ʉ di̱ mpɛti ngue si̱hmɛ̱. Gä 'dagui johyatho yø ja̱'i̱ ngue 'dap'ʉ si̱hmɛ̱ 'nɛ̱ hi̱njondi̱ 'yɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gä ɛ̱spa̱bi̱ Oja̱. Nu̱ya yø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱, gätho nnu̱ ma̱nho ya yø 'yɛ̱c'ɛ̱i̱. N'na pa ngu̱ n'na pa, nu̱na̱ Oja̱ øt'e ngue ma̱n'na ni̱ hyu̱xta̱ yø 'yɛ̱c'ɛ̱i̱ di̱ nya̱nyø te. ");
INSERT INTO otnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","N'na ra̱ pa, nu̱na̱ ra̱ Bɛdu 'nɛ̱hra̱ Xuua, 'da i̱ marbʉ bí ja ra̱ ni̱ja̱ di̱ mpɛti yø judío. Comma̱ hyu̱ nde bi̱ ma, gue'a̱ ra̱ ora pa ra̱ mhmat'Oja̱ yø ja̱'i̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mi̱ zømp'ʉ ja ra̱ goxthi ni̱ja̱ ni̱ hu̱ ngue ra̱ Goxthi Ma̱hotho. Mi̱ hu̱p'ʉ n'na ra̱ n'yohʉ ngue tu̱dyø gua asta̱ gue'mø ma̱mba̱ mi̱. I t'ɛ̱p'ʉ ngue hnepe da̱ 'yäpra̱ limosna'ʉ yø ja̱'i̱ cʉt'a̱mbo nni̱ja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nu̱'mø mi̱ nu̱ ra̱ Bɛdu 'nɛ̱hra̱ Xuua ngue mmap'ʉ da̱ yʉrbʉ ja ra̱ ni̱ja̱, nu̱na̱ ra̱ dogua p'ʉya bi 'yäpra̱ limosna. ");
INSERT INTO otnNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ra̱ Bɛdu p'ʉya 'nɛ̱hra̱ Xuua bi hyɛ̱ti̱. Bi 'yɛ̱mbra̱ dogua na̱ ra̱ Bɛdu p'ʉya: ―Da̱mi̱ hyɛ̱rca̱'be ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nu̱na̱ ra̱ dogua p'ʉya, bi hyɛ̱ti̱. I tø'mi̱ ngue te xti u̱nni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pɛ ra̱ Bɛdu bi 'yɛ̱mbi̱: ―Hi̱n tema̱ mɛ̱nyu̱ nna̱ ha̱gä ngue ga̱ 'da'i. Pɛ nu̱ te da̱ zä ga̱ 'da'i, ga̱ 'da'i. Conná̱ ts'ɛdi ra̱ Jesucristo nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret, dí xi'i ya, da̱mi̱ nangui̱, gui̱ n'yo. ");
INSERT INTO otnNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nu̱na̱ ra̱ Bɛdu p'ʉya, bi bɛnnba̱ rá̱ 'yɛ ngue rá̱ n'yɛi, bi gʉts'i. 'Bexque'a̱ ra̱ ora'a̱ p'ʉya, bi hyʉ xa̱nho yø hyu̱ndo'yo ngue yø dägua. Bi zä bi̱ m'mäi xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nu̱na̱ ra̱ dogua p'ʉya, xøgue ra̱ n'nas'mø mi̱ nangui̱ ngue bi̱ n'yo. 'Da i yʉrbʉ ja ra̱ ni̱ja̱ p'ʉya. Ya ni̱ 'yo, 'nɛ̱ ni̱ sägui mɛ̱nte di ja ma̱mma̱di̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Gätho yø ja̱'i̱ mi̱ 'bʉ'a̱mbo nni̱ja̱, bi̱ nu̱ ngue mɛ̱nte ni̱ 'yo na̱ ma̱rá̱ dogua, mɛ̱nte di ja ma̱mma̱di̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nu̱ya yø ja̱'i̱, i pa̱di̱ ngue gue'a̱ ra̱ dogua xi t'ɛ̱p'ʉ ja ra̱ goxthi ni̱ja̱ ni̱ hu̱ ngue ra̱ Goxthi Ma̱hotho'a̱. Gue'a̱ ra̱ n'yohʉ mi̱ äpra̱ limosna yø ja̱'i̱'a̱. Yø ja̱'i̱ p'ʉya, di 'yøtho 'nɛ̱ i su̱ ngue nnu̱ yø ja̱'i̱ ngue ya bi zä na̱ ma̱rá̱ dogua. ");
INSERT INTO otnNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nu̱na̱ ma̱rá̱ dogua 'mø mi̱ zä, asta̱ hi̱ngui̱ nne di thøhra̱ Bɛdu 'nɛ̱hra̱ Xuua, i sa̱mmi̱. Gätho yø ja̱'i̱ p'ʉya, gä di fɛtyø n'yomfɛ̱ni̱ ngue su̱. Bi̱ map'ʉ bi 'bähra̱ Bɛdu ja ra̱ ngu̱n'yu̱ ni̱ hu̱ ngue ra̱ Salomón. ");
INSERT INTO otnNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mi̱ nu̱ ra̱ Bɛdu p'ʉya ngue xa̱ngu̱ yø ja̱'i̱ 'bʉp'ʉ, bi 'yɛ̱mbʉya: ―Ague gyø judíohʉ, ¿hanja ngue ga̱di 'yøthohʉ'a̱ te bi̱ nja? ¿Hanja ngue guí ɛ̱mhmʉ ngue comma̱ ts'ɛdisɛ'be, ogue ngue dí su̱gä'be Oja̱, dá̱ japä'be bi̱ n'yo na̱ ra̱ n'yohʉ 'bʉcua? ");
INSERT INTO otnNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sinoque nu̱'a̱ ma̱ Oja̱hʉ mi̱ tha̱nne ma̱ mboxitahʉ ra̱ Abraham 'nɛ̱hra̱ Isaac 'nɛ̱hra̱ Jacob, gue'a̱ bi̱ n'øthe'a̱ ya, para ngue da̱ t'ɛ̱spa̱bi̱'a̱ rá̱ Ts'ʉnt'ʉ Jesús. Pɛ nu̱na̱ ra̱ Jesús, guehna̱ gá̱ dähʉ p'ʉ 'bʉhyø ts'ʉt'abi na̱. Nu̱'mø mi̱ ne xtí thøhra̱ Pilato, pɛ nu̱'a̱hʉ hi̱ngá̱ nehʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pɛ nu̱na̱ ra̱ Jesús hi̱n tema̱ nts'o bi 'yøt'e, gä ra̱ nho ma̱ni̱ n'yo. A nu̱'a̱hʉ p'ʉya, hi̱ngá̱ nehʉ ngue xtá̱ ma ma̱thøgue na̱, sinoque go gá̱ 'yähmʉ ngue bi̱ ma ma̱thøgue n'na ra̱ hyote. ");
INSERT INTO otnNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Go gá̱ hyohʉ na̱ bá̱di̱ u̱nna̱ te. Pɛ Oja̱ bi japi ngue bi bɛ̱nna̱te p'ʉ ha bi t'ägui. A nu̱gä'be ya, go da̱di jagä'be ma̱jua̱ni̱ ngue bi bɛ̱nna̱te ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A nu̱na̱ ra̱ n'yohʉ 'bʉcua ya, guí pa̱hmʉ ngue mi̱ dogua na̱. Pɛ ni̱ hmi̱ ni̱ dähʉ ngue bi zä na̱ ra̱ n'yohʉ na̱. Rá̱ngue bi 'yɛ̱c'ɛ̱i̱ ngue ra̱ Jesús da̱ zä da̱ 'yøthe, ja̱na̱ngue bi zä xa̱ndønho ya. ");
INSERT INTO otnNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ague n'yø'a̱hʉ, nu̱gä dí pa̱di̱ ngue hi̱nguí̱ pa̱di̱ te ga̱ mbøn'a̱ gá̱ 'yøthʉ. Xquet'a̱ njarbʉtho ni̱ hmu̱hʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱ ya, a̱ha̱ bi hyo ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pɛ nu̱na̱ Oja̱, bi japi ngue bi̱ nja'a̱ te gä bi 'yotyø pønga̱hya̱ 'mø yø pa xa̱thogui. Nu̱'ʉ yø pønga̱hya̱, bi̱ ma̱ ngue ra̱ Cristo i ja ngue da̱ zä ra̱ n'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ja̱na̱ngue nu̱yá, da̱mi̱ hyɛhmʉ p'ʉ'a̱ te gni̱ 'yohʉ. Da̱mi̱ 'yɛ̱c'ɛ̱i̱hʉ Oja̱, n'namhma̱ ngue di̱ mpu̱n'na̱ ni̱ ts'oquihʉ. Ja da̱ hyu̱t'a̱ ni̱ mmʉihʉ Oja̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","A nu̱na̱ Oja̱ da̱ pɛnhna̱ Jesús, porque guehna̱ ra̱ Cristo ya xpa̱ t'ɛ̱ts'i̱ ngue di̱ ma̱nda ua na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","A nu̱yá, ra̱ Jesucristo jatho ngue da̱ m'mʉp'ʉ ma̱hɛ̱ts'i̱ asta̱ gue'mø da̱ 'yøt'Oja̱ ngue da̱ gom'na'yo gätho yø cosa i ja. Ngu̱na̱ ra̱ hya̱ bi̱ ma̱n'ʉ yø ma̱ca̱ pønga̱hya̱ Oja̱ xa̱ m'mʉ'mø ya ma̱ndønja̱m'mø tho. ");
INSERT INTO otnNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nu̱'mø mi̱ zohyø nyogui ja̱'i̱ ra̱ Moisés, bi 'yɛ̱mbi̱: “Nu̱na̱ Oja̱ ma̱ Hmu̱hʉ, nu̱'ʉ yø judío, da̱ bøn'a̱ n'na nc'ɛ̱i̱ ngue di̱ mpønga̱hya̱ tengu̱tho bi jacä. Nu̱'a̱ ra̱ pønga̱hya̱'a̱ p'ʉya, da̱mi̱ 'yøhmʉ te gäma̱ hya̱ da̱ xi'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nu̱ ra̱ ja̱'i̱ hi̱nda̱ 'yɛ̱c'ɛ̱i̱ na̱ ra̱ pønga̱hya̱ na̱, da̱ ts'ijpʉ ha 'bʉhyø judío ngue da̱ tho”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bá̱ fʉdi asta̱ ra̱ Samuel, gätho'ʉ mi̱'da yø pønga̱hya̱ xa̱ m'mʉi, gä bi̱ ma̱ ngue di̱ nja'a̱ te gä dí̱ nnu̱hʉ ra̱ pa ja p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nu̱na̱ ra̱ hya̱ ya xa̱ ya̱rpa̱bi̱ Oja̱ yø ja̱'i̱ ngue di̱ nja, tengu̱tho ra̱ hya̱ bi bɛ̱nnba̱bi̱ yø pønga̱hya̱ ngue bi xihyø ja̱'i̱, nu̱na̱ ra̱ hya̱ na̱, da̱ 'yøt'a̱hʉ ra̱ nho na̱. Oja̱ bi 'yøt'ui n'na ra̱ cohi ma̱ mboxitahʉ Abraham, bi 'yɛ̱mbi̱: “Conná̱ nguehna̱ n'na ni̱ mbom'mɛto di̱ m'mʉi, da̱ ma ma̱ja̱pi̱ gätho yø ja̱'i̱ 'bʉ'a̱ nxi̱mhäi”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nu̱na̱ Oja̱ bi u̱nná̱ cargo na̱ rá̱ Ts'ʉnt'ʉ, rá̱ mʉdi i̱ mɛnnbʉ guí 'bʉhmʉ ngue di ja̱p'a̱hʉ. I̱ nnepe ngue gui hyɛhmʉ p'ʉ ra̱ nts'o gni̱ n'yo n'na ngu̱ n'na'a̱hʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mɛ̱nte ya̱hʉ yø ja̱'i̱ ra̱ Bɛdu 'nɛ̱hra̱ Xuua, bi zøhyø mmäcja̱ p'ʉya, bá̱ n'youi ra̱ 'bɛt'o asminyo co 'nɛ̱'ʉ yø saduceo. ");
INSERT INTO otnNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","I̱ mbøcuɛ'ʉ p'ʉya, ngue ra̱ Bɛdu 'nɛ̱hra̱ Xuua xännba̱ ra̱ hya̱ yø ja̱'i̱, i xifi ngue nu̱'ʉ xa̱ ndu̱ i ja ngue di bɛ̱nna̱te, porque bi bɛ̱nna̱te ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bi bɛnt'i̱ bi got'a̱ fädi, ja gue'mø mi̱ hyats'i xtí̱ nja ra̱ hya̱. Porque ya bi̱ nde bi got'i. ");
INSERT INTO otnNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pɛ nu̱'ʉ yø ja̱'i̱ bi 'yøhra̱ hya̱ i hma̱, xa̱ndøngu̱ bi 'yɛ̱c'ɛ̱i̱ ra̱ hya̱. Nu̱'a̱ ga̱ngu̱ yø 'yɛ̱c'ɛ̱i̱ p'ʉya, bi t'øtra̱ güɛnda ngue hønsɛ yø n'yohʉ, ya ni̱ ma da̱ zʉ'i cʉt'a ma̱hua̱hi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mi̱ hyaxpʉya, bi̱ mpɛti yø hmu̱ yø mmäcja̱ p'ʉ Jerusalén, co 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o ngue yø judío, ni̱ n'yohʉ yø xännba̱te ngue ra̱ ley. ");
INSERT INTO otnNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ni̱ n'yohʉ na̱ ra̱ Anás rá̱ hmu̱ mmäcja̱. Ni̱ n'yohʉ ra̱ Caifás, 'nɛ̱hra̱ Xuua 'nɛ̱hra̱ Alejandro. 'Nɛ̱ gätho yø mɛ̱ni̱ ya yø hmu̱ mmäcja̱ ni̱ n'yohʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A nu̱ya p'ʉya, bi̱ ma̱nda ngue bá̱ ts'i ra̱ Bɛdu 'nɛ̱hra̱ Xuua, bi̱ ma ma̱'bä'mi̱ p'ʉ ma̱de ngue da̱ t'ørpa̱ ra̱ nt'änni̱. Mi̱ 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Te'o bi 'da'a̱ui ra̱ nt'ɛ̱di̱'a̱ te guí øt'ui n'yø, ogue te'o bi 'da'a̱ui ra̱ ts'ɛdi ngue gui øt'ui tengu̱ na̱ ra̱ hya̱ na̱? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nu̱na̱ ra̱ Bɛdu ts'o p'ʉya, ra̱ Espíritu Santo di ha̱tra̱ ts'ɛdi bi 'yɛ̱mbya ya̱ui p'ʉya: ―Ague n'yø'a̱hʉ, nu̱ya yø n'yohʉ di̱ ma̱nda ua ja ra̱ hni̱ni̱, da̱ guehyø n'yohʉ 'bɛt'o ngue yø judío. ");
INSERT INTO otnNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Guí ännga̱'be ha bi̱ nja'a̱ ra̱ nho dá̱ ørpä'be na̱ ra̱ n'yohʉ mi̱'ʉ, ngue ha bi̱ njap'ʉ i ya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","A nu̱yá, ga̱ xi'a̱hʉ ha bi̱ nja, n'namhma̱ ngue da̱ ba̱di̱ gätho yø judío. Nu̱na̱ ra̱ n'yohʉ 'bʉcua bi ya̱ni̱ conná̱ ts'ɛdi ra̱ Jesucristo nu̱na̱ ra̱ mmɛ̱ngu̱ Nazaret. Guehna̱ ra̱ Jesucristo gá̱ cuathʉ ra̱ pont'i̱ ngue bi tho na̱. Pɛ Oja̱ bi japi bi bɛ̱nna̱te p'ʉ bi t'ägui. Conná̱ nguehna̱ ya, ni̱ hmi̱ ni̱ dähʉ p'ʉ bi ya̱nna̱ ra̱ n'yohʉ 'bʉcua. ");
INSERT INTO otnNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gá̱ 'yøthʉ tengu̱tho yø ga̱do 'mø bi 'yɛn'a̱ n'na nguadi n'na ra̱ do, ɛ̱mbi̱ ngue hi̱ngui̱ ho. Pɛ m'mɛfa p'ʉya, guehna̱ da̱ gohi ngue brá̱ 'bɛbo p'ʉ brá̱ fʉhra̱ ja̱do na̱. Guí̱ njathʉ p'ʉya, hi̱ngá̱ nu̱ ma̱nho ra̱ Jesús. Pɛ guehna̱ rá̱ thanhni̱ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hi̱njom ma̱n'na da̱ zä gdá̱ nya̱mhmʉ. Porque bá̱ sän'Oja̱ ngue nu̱ua ja ra̱ xi̱mhäi, høndra̱ Jesús ja rá̱ ts'ɛdi da̱ ya̱njʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nu̱'ʉ yø n'yohʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱ p'ʉya, bi̱ nu̱ te øtra̱ Bɛdu 'nɛ̱hra̱ Xuua ngue ya̱ ma̱nzaqui. 'Nɛ̱ pa̱hyø ja̱'i̱ ngue nu̱ya yø n'yohʉ ya, hi̱mbi̱ ma ra̱ xädi, i ɛ̱mbyø ja̱'i̱ ngue hi̱nte pa̱di̱. Ja̱na̱ngue di 'yøtho. Pɛ pa̱hyø ja̱'i̱ ngue mi̱ n'youi ma̱m'mɛt'o ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","I̱ nnu̱ yø ja̱'i̱ p'ʉya, ngue 'dap'ʉ 'bähmʉ na̱ ra̱ n'yohʉ ma̱rá̱ dogua ya xi zä. Ya hi̱ngui̱ säp'ʉ da̱ 'yɛ̱mbyø ja̱'i̱ ngue ra̱ fɛhni̱'a̱ te bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bi xi p'ʉya ngue bi̱ ma bá̱ m'mä'athi, mɛ̱nte bi̱ nhɛca̱hya̱, bi zänni̱ te da̱ japi. ");
INSERT INTO otnNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Di̱ n'yɛ̱mbi̱: ―¿Te 'bɛ'a̱ ga̱ japhʉ ya yø n'yohʉ 'youa dí 'bʉhmʉ? Porque gätho yø mmɛ̱ngu̱ Jerusalén, ya pa̱di̱ ngue hi̱njonda̱ zä da̱ 'yøt'a̱ te bi 'yøt'e. Ya hi̱ngui̱ sä ga̱ ɛ̱mhmʉ ngue hi̱mma̱ jua̱ni̱'a̱ te bi 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","A nu̱yá, ma ga̱ pihmʉ ya, n'namhma̱ ngue hi̱nni̱ mantho da̱ ma̱nna̱ hya̱ p'ʉ ha 'bʉhyø ja̱'i̱. Ma ga̱ xihmʉ ya ngue ra̱ pa di̱ map'ʉ, ya hi̱nni̱ mantho da̱ xihyø ja̱'i̱ hanja na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mi̱ juadi bi̱ nhɛca̱hya̱ yø ja̱'i̱ p'ʉya, bi zonhni̱ ngue bi 'yɛ̱mbi̱: ―A nu̱yá n'yø'a̱ui, 'yo høngui̱ xihmʉ ra̱ hya̱ yø ja̱'i̱ ya. 'Yoni̱ mantho høngui̱ xännba̱hʉ yø ja̱'i̱ rá̱ hya̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mi̱ da̱hra̱ Bɛdu 'nɛ̱hra̱ Xuua, bi 'yɛ̱mbi̱: ―Da̱mi̱ hya̱cjʉ xa̱nho ra̱ güɛnda ya. ¿Ua guí ha̱xʉ njua̱ni̱ ngue da̱ nu̱ ma̱nho Oja̱ ngue go di̱ nja'a̱ te guí̱ mma̱mhmʉ ya'mø, hi̱ngo di̱ nja'a̱ te mma̱n'Oja̱ 'mø? ");
INSERT INTO otnNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nu̱na̱ ra̱ Jesús, jatho ngue ga̱ mma̱mhma̱gä'be'a̱ te dá̱ nu̱'be bi 'yøt'e, 'nɛ̱'a̱ te dá̱ ø'be bi̱ ma̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Høntho juadi bi pidi, bi thø p'ʉya. Porque ya hi̱mbi̱ di̱ni̱ ha xtí japi ngue xta̱ ngot'i. Porque su̱pi̱ di̱ mbøcuɛ ya yø ja̱'i̱ ɛ̱spa̱bi̱ Oja̱ ngue te xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A nu̱na̱ ra̱ dogua xi t'øthe conná̱ ts'ɛdi Oja̱, i tho'a̱ nyote njɛya 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nu̱'mø mi̱ ma ma̱thøgue ra̱ Bɛdu 'nɛ̱hra̱ Xuua, bi̱ map'ʉ 'bʉhyø amigo. Bi xifi gätho'a̱ te xi̱ ma̱nyø hmu̱ yø mmäcja̱, 'nɛ̱'ʉ yø n'yohʉ 'bɛt'o ngue yø judío. ");
INSERT INTO otnNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nu̱'mø mi̱ 'yø'a̱ te si p'ʉya, 'da i̱ mmat'Oja̱tho, bi 'yɛ̱na̱: ―Ma̱ Oja̱'i̱, gue'e grá̱ Oja̱ gá̱ hoqui te gä bí ja ma̱ya̱, gá̱ hocra̱ häi, gá̱ hocra̱ ja̱the, gá̱ hoqui gätho yø cosa i ja. ");
INSERT INTO otnNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nu̱'i̱ ma̱ Oja̱'i̱, conna̱ Espíritu Santo gá̱ japni̱ mɛfi ra̱ David ngue bi̱ ma̱n'a̱ te guí̱ nne guí̱ mma̱, porque ra̱ David bi 'yɛ̱na̱: “¿Hanja ngue mbøcuɛ yø ja̱'i̱ 'bʉp'ʉ ja yø nación? 'Nɛ̱ hi̱ndi̱ nja'a̱ te sänni̱ di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Di̱ mpɛti yø da̱st'abi p'ʉ ja yø nación. Da̱ guehyø ts'ʉt'abi 'bʉp'ʉ ja yø hni̱ni̱ 'da'igu̱ sänni̱. I sʉ Oja̱ 'nɛ̱ sʉmba̱bi̱'a̱ ra̱ Cristo bá̱ ɛ̱ts'i̱”, bi 'yɛ̱nna̱ David. ");
INSERT INTO otnNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Porque ma̱jua̱ni̱ ngue nu̱ua ja ra̱ hni̱ni̱ Jerusalén, nu̱na̱ ra̱ da̱st'abi Herodes conna̱ Poncio Pilato, conyø judío, conyø ja̱'i̱ hi̱ngyø judío, gä bi̱ mpɛti, bi̱ nhɛca̱hya̱ ngue sʉ'a̱ ni̱ ma̱ca̱ Ts'ʉnt'ʉ Jesús guá̱ ɛ̱ts'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pɛ nu̱na̱ ra̱ hya̱ bi 'yøtyø da̱st'abi, ya ma̱nja̱m'møtho xcá̱ ma̱nna̱ ra̱ hya̱ mi̱ ja ngue di̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A nu̱ya grá̱ Hmu̱, ya guí̱ nnu̱ te gui pite yø ja̱'i̱ ya. Da̱mi̱ ha̱cje ra̱ ts'ɛdi ya, n'namhma̱ ngue hi̱ndi̱ nsu̱ ni̱ mɛfi da̱ ma̱mp'a̱'i̱ ni̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Conni̱ ts'ɛdi da̱mi̱ 'yøt'e ngue da̱ zä'ʉ to xa̱n'ʉ. Da̱mi̱ 'yu̱hyø hmɛ̱ya, ngue di̱ nja yø milagro 'mø ts'o'a̱ ni̱ ma̱ca̱ Ts'ʉnt'ʉ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Høntho bi juadi bi̱ mat'Oja̱ yø ja̱'i̱ p'ʉya, bi 'ya̱n'a̱ häi p'ʉ xi̱ mpɛti yø ja̱'i̱. Gä bi zä yø ja̱'i̱ ngue di ha̱tra̱ ts'ɛdi ra̱ Espíritu Santo. Ya hi̱ngui̱ su̱ da̱ ma̱mbrá̱ hya̱ Oja̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Gätho yø 'yɛ̱c'ɛ̱i̱, 'bʉi tengu̱tho 'mø ngue da̱ n'na nc'ɛ̱i̱tho. 'Da'igu̱ øt'e, 'da'igu̱ mbɛ̱ni̱. Ni̱ xi̱nga̱ n'na nc'ɛ̱i̱ ngue da̱ 'yɛ̱na̱ jasɛ rá̱ mmɛti. Nu̱ te gä pɛts'i, gä comhmi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A nu̱ya yø representante p'ʉya, gä ha̱ ra̱ ts'ɛdi di ja ma̱jua̱ni̱ ngue bi bɛ̱nna̱te ra̱ Hmu̱ Jesús. Nu̱na̱ Oja̱, ma̱n'na bi u̱nná̱ nja̱pi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yø 'yɛ̱c'ɛ̱i̱ p'ʉya, hi̱njo'o ngue da̱ hi̱n'yʉ te da̱ hyoni̱. Porque nu̱ to gä ja yø häi, ogue yø ngu̱, i pä ngue di u̱nna̱ mɛ̱nyu̱ ngue ma̱ darpi yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nu̱'mø bi zøp'ʉ 'bʉhyø representante ra̱ Cristo, di däpra̱ mɛ̱nyu̱. Go di darpa̱bi̱ yø ja̱'i̱ ya p'ʉya, n'na ngu̱ n'na yø ja̱'i̱ ma̱ t'u̱nni̱'a̱ te honi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ José. Guehna̱ n'na ra̱ levita na̱ ngue ra̱ mmɛ̱ngu̱ Chipre. A nu̱'ʉ yø representante ra̱ Cristo p'ʉya, gui hu̱ti̱ ngue ra̱ Bernabé. I̱ nne da̱ ma̱ ngue n'na ra̱ n'yohʉ di hojpa̱ yø mmʉi yø mmi̱c'ɛ̱i̱ui. ");
INSERT INTO otnNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nu̱na̱ ra̱ José p'ʉya, bi̱ mä n'na rá̱ häi mi̱ ja. Bi däpra̱ mɛ̱nyu̱ yø representante ngue di dat'i. ");
INSERT INTO otnNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nu̱na̱ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Ananías conna̱ Safira rá̱ xisu, bi̱ mä n'na rá̱ häi ya p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pɛ bi hya̱ca̱ n'na parte ra̱ mɛ̱nyu̱ i̱ mä rá̱ häi, co 'nɛ̱hrá̱ xisu bi ba̱di̱. Nu̱na̱ ma̱n'na parte p'ʉya, bi däpyø representante ra̱ Cristo, tengu̱tho 'mø ngue hi̱nte xta̱ hya̱qui̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ra̱ Bɛdu p'ʉya bi 'yɛ̱mbi̱: ―Ague Ananías, ¿hanja ngue di cʉnts'a̱ ni̱ n'yomfɛ̱ni̱ ra̱ zithu̱ ngue guí̱ nne gui hyätra̱ Espíritu Santo? Porque gá̱ hya̱cra̱ mɛ̱nyu̱ guí pä ni̱ häi. ");
INSERT INTO otnNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Xina̱ ra̱ häi, ¿ua̱ngui̱ ni̱ mmɛti na̱? Ya gá̱ pä, 'nɛ̱ mi̱ o ni̱ 'yɛ ra̱ mɛ̱nyu̱, ua̱ngui̱ xquí 'yøt'e te guí̱ nne. ¿Hanja ngue gá̱ bɛ̱ni̱ gui̱ mma̱nna̱ fɛhni̱? Hi̱ngyø ja̱'i̱'ʉ guí̱ nne gui hyäti, sinoque Oja̱ guí̱ nne gui hyäti ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ngu̱ i 'yøhna̱ ra̱ hya̱ bi sihra̱ Ananías, 'bexpi du̱, bi dä p'ʉya. Gä bi 'yɛ̱mmɛ̱i̱ bi̱ nsu̱ ya yø ja̱'i̱ bi ba̱di̱ te bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bi̱ nangui̱ 'da yø n'yohʉ mi̱ 'bʉp'ʉ, bi 'uɛnnba̱bi̱ rá̱ do'yo ra̱ ánima, bi hya̱ts'i bá̱ ägui. ");
INSERT INTO otnNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mi̱ thogui comma̱ nhyu̱ ora p'ʉya, bi yʉt'a̱mbo na̱ ra̱ Safira rá̱ xisu ra̱ ánima. Pɛ hi̱ngui̱ pa̱di̱ te xi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Da̱mi̱ xiqui, ¿ua gue'a̱ guí pä ni̱ häiui'a̱ ra̱ hya̱ xa̱ hma̱ngua ma̱hɛ̱'mø, uague hi̱n'na̱? Mi̱ da̱hra̱ Safira, bi 'yɛ̱na̱: ―A̱há̱, gue'a̱ dá̱ pä'be'a̱ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ra̱ Bɛdu p'ʉya bi 'yɛ̱mbra̱ xisu: ―¿Hanja ngue ya xcuá̱ nhɛca̱hya̱ ngue guí hyär'ma̱hya̱ui ra̱ Espíritu Santo? 'Bäp'ʉ goxthi'ʉ to xpá̱ 'yäc'a̱'i̱ ni̱ da̱mme. 'Nɛ̱ ma̱hønda̱ hya̱xa̱'i̱ ya ngue guá̱ n'yägui ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","'Bexque'a̱ ra̱ ora'a̱ p'ʉya, bi dähra̱ xisu p'ʉ mi̱ ya̱ui ra̱ Bɛdu, ngue bi du̱. Mi̱ yʉt'a̱mbo yø 'yäte p'ʉya, ma̱hømbi̱ di̱ni̱ ngue ya xi du̱ ra̱ xisu. Bá̱ jʉjpʉya, bi̱ ma bá̱ ägui 'dap'ʉ bi 'youi rá̱ da̱mme. ");
INSERT INTO otnNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gä bi̱ nsu̱ yø 'yɛ̱c'ɛ̱i̱. Xi̱mma̱ngu̱'ʉ hi̱ngyø 'yɛ̱c'ɛ̱i̱ p'ʉya, xquet'a̱ bi̱ nsu̱ mø mi̱ 'yø'a̱ te bi̱ nja. ");
INSERT INTO otnNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nu̱p'ʉ ja ra̱ ngu̱n'yu̱ ni̱ hu̱ ngue ra̱ Salomón, ja bi̱ mpɛti p'ʉ xa̱ngu̱ yø 'yɛ̱c'ɛ̱i̱. Nu̱ya yø representante ra̱ Cristo p'ʉya, 'dama̱ 'dan'yo yø hmɛ̱ya bi 'yu̱tyø ja̱'i̱, porque hi̱njongui̱ sä da̱ 'yøtyø milagro bi 'yørbʉ bi̱ mpɛti yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma̱da̱gue'a̱ hi̱ngui̱ cuarbʉ 'bʉhyø 'yɛ̱c'ɛ̱i̱ ya yø ja̱'i̱ hi̱ngyø 'yɛ̱c'ɛ̱i̱, pɛ nnu̱ ma̱nho yø 'yɛ̱c'ɛ̱i̱, hi̱ngui̱ sʉi. ");
INSERT INTO otnNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma̱n'na ma̱n'na ni̱ hyu̱xta̱ yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱ ra̱ Jesús. Yø n'yohʉ, yø xisu bi 'yɛ̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Asta̱ bi jʉcyø därquɛ̱hi̱ yø ja̱'i̱ ngue pop'ʉ ja yø caye. 'Bʉ'o bá̱ oxyø t'ots'i, 'bʉ'o bá̱ oxyø fi̱di̱, i nnepyø ja̱'i̱ ngue nu̱'mø bi thop'ʉ ra̱ Bɛdu, ma̱drá̱ xahatho di̱ nthɛui ra̱ därquɛ̱hi̱, 'bexi sä ra̱ n'ʉ hɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nu̱'ʉ yø hni̱ni̱ guerpʉtho bí ja, bá̱ ɛ̱hyø ja̱'i̱ bi zø'a̱ Jerusalén. Bá̱ du̱ yø därquɛ̱hi̱, bá̱ du̱ yø ndu̱nthi̱. Pɛ gä bi t'øthe. ");
INSERT INTO otnNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nu̱na̱ rá̱ hmu̱ yø mmäcja̱ p'ʉya, gätho ya mi̱'da yø n'yohʉ, nu̱ya ja yø nt'ɛ̱c'ɛ̱i̱ ni̱ hu̱ ngue yø saduceo, gä bi̱ nsɛya 'mø mi̱ nu̱ ngue xa̱ndøngu̱ yø ja̱'i̱ n'youi ya yø representante ra̱ Cristo. ");
INSERT INTO otnNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bi̱ ma ma̱bɛnt'i̱ ya yø representante p'ʉya, bi jot'i. ");
INSERT INTO otnNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pɛ rá̱ anxɛ Oja̱ p'ʉya, bi xocra̱ goxthi fädi 'mø mi̱nxu̱i̱ ngue bá̱ jʉqui. Bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Ni̱ mɛ ya, ni̱ m'mähmi̱ p'ʉ ja rá̱ ni̱ja̱ di̱ mpɛti yø judío. Da̱mi̱ xihmi̱ yø ja̱'i̱ hanja na̱ ra̱ hya̱ ngue ra̱ 'da'yo te. ");
INSERT INTO otnNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nu̱'ʉ yø representante ra̱ Cristo 'mø mi̱ 'yøhna̱ ra̱ hya̱ bi xihra̱ anxɛ, bi̱ ma mxu̱di̱tho p'ʉ ja ra̱ ni̱ja̱ ngue bi xännba̱ ra̱ hya̱ yø ja̱'i̱. Nu̱'a̱ ra̱ ora ɛbí̱ mma̱nna̱ hya̱ p'ʉ ja ra̱ ni̱ja̱ p'ʉya, ja bi øt'a̱ junta'ʉ yø hmu̱ yø mmäcja̱. Bi pɛtyø n'yohʉ di̱ ma̱nda p'ʉ ja ra̱ ni̱ja̱. Ja bi̱ ma̱nda ngue da̱ njʉcyø ofädi p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pɛ nu̱'mø mi̱ zøp'ʉ ja ra̱ fädi'ʉ yø policía, ya hi̱mbi̱ di̱mp'ʉ yø ofädi. Bá̱ pennbʉya, bi̱ ma̱ ngue ya hi̱njo'o p'ʉ yø ofädi. ");
INSERT INTO otnNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Bi 'yɛ̱na̱: ―Dá̱ ti̱ngähe ngue n'nøt'e xa̱nho ra̱ fädi, 'bäp'ʉ yø mädi p'ʉ ja ra̱ goxthi. Pɛ nu̱'mø ma̱ xocähe ra̱ goxthi p'ʉya, ya hi̱ndá̱ ti̱ngähe p'ʉ mbo yø ofädi. ");
INSERT INTO otnNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mi̱ 'yøhyø hmu̱ yø mmäcja̱ na̱ te xi̱ nja p'ʉya, 'nɛ̱'a̱ rá̱ hmu̱'ʉ yø n'yohʉ ja yø 'bɛfi p'ʉ ja ra̱ ni̱ja̱, ngue hi̱njo'o p'ʉ yø ofädi, di̱ n'yɛ̱mbʉya: ―¿Xø hague xpí bøn'ʉ p'ʉya? ―di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nu̱'a̱ ra̱ ora'a̱ p'ʉya, bi zø'a̱ n'na nc'ɛ̱i̱, bi 'yɛ̱mbi̱: ―Nu̱'ʉ yø n'yohʉ gá̱ cothʉ fädi 'mø mi̱nde, ya bí 'bʉp'ʉ ja ra̱ ni̱ja̱. Bi xännba̱ ra̱ hya̱ yø ja̱'i̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nu̱'a̱ rá̱ hmu̱ yø policía p'ʉya, bi̱ mähä'ʉ yø mmi̱policíaui ngue da̱ si'ʉ yø representante ra̱ Cristo. Pɛ hi̱mbi̱ ʉni̱, porque su̱ da̱ mʉndo yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nu̱'mø ma̱mba̱ ts'i'ʉ yø representante ra̱ Cristo p'ʉya, bi̱ ma ma̱'bä'mi̱ p'ʉ ja ra̱ junta. Nu̱'a̱ ra̱ hmu̱ mmäcja̱ bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Ua hi̱nguí̱ øhmʉ ra̱ hya̱, ua̱ngui̱ dá̱ hɛc'a̱he ngue nu̱'a̱ rá̱ hya̱ ra̱ Jesús, ya hi̱nni̱ mantho guí xännba̱hʉ yø ja̱'i̱? A nu̱ya gätho ra̱ hni̱ni̱ Jerusalén, ya xcá̱ si̱nnba̱hʉ'a̱ ra̱ hya̱ guí xännba̱tehʉ ya. 'Nɛ̱ guí ɛ̱mhmʉ ngue go ma̱ ts'oquigähe p'ʉ bi du̱ na̱ ra̱ n'yohʉ guí̱ mma̱mhmʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mi̱ da̱hra̱ Bɛdu p'ʉya, co 'nɛ̱'ʉ mi̱'da yø representante, bi 'yɛ̱na̱: ―Nu̱gähe dí̱ ɛ̱mhme ngue jatho da̱ t'ɛ̱c'ɛ̱i̱ te mma̱n'Oja̱, hi̱nda̱ gue'a̱ ngue yø ja̱'i̱tho da̱ t'ɛ̱c'ɛ̱i̱bi̱ yø hya̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nu̱na̱ ra̱ Jesús dí̱ mma̱ngähe ya, guehna̱ gá̱ cuathʉ ra̱ pont'i̱ ngue bi du̱ na̱. Pɛ nu̱na̱ Oja̱ mi̱ tha̱nne ma̱ mboxitahʉ, bi japi ngue bi bɛ̱nna̱te. ");
INSERT INTO otnNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Oja̱ p'ʉya, bi zixpʉ bí ja rá̱ n'yɛi na̱ ra̱ Jesús, guehna̱ bi 'yɛ̱ts'i̱ ngue di̱ nda̱st'abi ngue da̱ ya̱nyø ja̱'i̱ na̱. A nu̱yá, nu̱ya yø judío, ma̱t'u̱nni̱ ra̱ tiempo ngue da̱ hyɛp'ʉ ra̱ nts'o ga̱ 'yo, n'namhma̱ ngue di̱ mpu̱nnba̱ yø ts'oqui. ");
INSERT INTO otnNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Guesɛ ra̱ Espíritu Santo di ja ma̱jua̱ni̱ na̱ ra̱ hya̱ na̱. Da̱ guecähe p'ʉya, xquet'a̱ da̱di jahe ma̱jua̱ni̱ na̱ ra̱ hya̱ na̱. Nu̱na̱ ra̱ Espíritu Santo p'ʉya, guehna̱ bá̱ pɛnnba̱bi̱ Oja̱'ʉ yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱bi̱ rá̱ hya̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mi̱ 'yøhna̱ ra̱ hya̱ bi si p'ʉya, ja̱njua̱ni̱ ngue bi̱ mbøcuɛ. Bi̱ ne ngue xta̱ hyopyø representante ra̱ Cristo. ");
INSERT INTO otnNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nu̱p'ʉ 'bʉhyø mmäcja̱, n'youi p'ʉ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Gamaliel, ja rá̱ nt'ɛ̱c'ɛ̱i̱ ngue ra̱ fariseo 'nɛ̱ ra̱ xännba̱te ngue ra̱ ley. 'Nɛ̱ gä nnu̱ ma̱nsu̱ yø ja̱'i̱ na̱ ra̱ Gamaliel. Bi̱ m'mä p'ʉya, bi̱ ma̱nda ngue bi̱ njʉca̱thi n'na ts'ʉquits'ʉ ya yø representante ra̱ Cristo. ");
INSERT INTO otnNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bi 'yɛ̱mbyø ja̱'i̱ na̱ ra̱ Gamaliel: ―Ague gyø judíohʉ, da̱mi̱ n'yomfɛ̱ni̱ te guí̱ nne guí 'yørpa̱hʉ ya yø n'yohʉ 'bʉcua. ");
INSERT INTO otnNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Da̱mi̱ bɛ̱mhmʉ te bi̱ nja 'mø yø pa xa̱ thogui ngue mi̱ 'yonna̱ hya̱ ra̱ Teudas. Bi 'yɛ̱na̱ ngue ma̱guesɛ, 'nɛ̱ bi dɛnni̱ comma̱ goho ciento nja̱'i̱. Mi̱ zä mi̱ tho p'ʉya, gä bi̱ n'uɛn'ʉ mi̱ tɛnni̱. Bi̱ m'mɛp'ʉ ra̱ hya̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","M'mɛfa p'ʉya, nu̱'mø mi̱ nja ra̱ censo, ma̱hømbi̱ 'yonna̱ hya̱ ra̱ Judas nu̱'a̱ ra̱ mmɛ̱ngu̱ Galilea. Xquet'a̱ xa̱ngu̱ to bi dɛnnba̱ rá̱ hya̱. A nu̱'mø mi̱ tho, gä bi̱ n'uɛni̱ to mi̱ tɛnni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ja̱na̱ngue da̱mi̱ hyɛhmʉ p'ʉya yø n'yohʉ 'bʉcua. 'Yo ga̱di̱ nthi̱nt'i̱ ngue guí sʉhmʉ. Porque nu̱'mø yø hya̱sɛ'a̱ ra̱ hya̱ i̱ mma̱, di̱ m'mɛhyø hya̱ 'mø. ");
INSERT INTO otnNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pɛ nu̱'mø ngue rá̱ hya̱ Oja̱ i̱ mma̱mp'ʉya, hi̱nda̱ zä guí hɛjpa̱hʉ te mma̱m'mø. Ma̱n'na n'yo mi̱ 'yøthʉ ngue go ga̱ cohmʉ ngue ma̱ nsʉihʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gä bi̱ nu̱ ma̱nho yø ja̱'i̱ te bi̱ ma̱nna̱ Gamaliel. Bi̱ ma ma̱cʉt'i mbo ya yø representante ra̱ Cristo p'ʉya ngue bi 'bɛi. Bi xi p'ʉya ngue ya hi̱nni̱ mantho da̱ xihyø ja̱'i̱ hanja na̱ rá̱ hya̱ ra̱ Jesús. Bi thø p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mi̱ bømp'ʉ ja ra̱ junta'ʉ yø representante ra̱ Cristo p'ʉya, di johya ngue ya bi zä ra̱ n'ʉ conná̱ nguehra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","N'na pa ngu̱ n'na pa hi̱ngui̱ säya bi xännba̱te p'ʉ ja ra̱ ni̱ja̱ di̱ mpɛti yø judío, 'nɛ̱p'ʉ ja yø ngu̱ i̱ mma̱nna̱ Jesucristo p'ʉ ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nu̱'ʉ yø pa'ʉ p'ʉya, ma̱n'na ma̱n'na ni̱ hyu̱xtho'a̱ ga̱ngu̱ yø 'yɛ̱c'ɛ̱i̱. Nu̱'ʉ ga̱ ya̱ ra̱ hya̱ ngue ra̱ griego p'ʉya, bi̱ mʉdi bi zʉ'ʉ yø judío ga̱ ya̱ ra̱ hya̱ ngue ra̱ ebreo. I ɛ̱na̱ ngue hi̱ngui̱ t'ørpa̱bi̱ ma̱su̱ xa̱nho'ʉ yø 'danxu̱ 'mø ma̱ dat'i ra̱ hmɛ̱ n'na pa ngu̱ n'na pa. ");
INSERT INTO otnNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ja̱na̱ngue nu̱'ʉ 'dɛma̱ yoho yø representante ra̱ Cristo p'ʉya, bi pɛti gätho'ʉ yø 'yɛ̱c'ɛ̱i̱, bi 'yɛ̱mbi̱: ―Hi̱nda̱ zä'a̱ ngue go ga̱ hɛcähe p'ʉ'a̱ nná̱ ma̱ngähe rá̱ hya̱ Oja̱, ngue gui 'yɛ̱mhmʉ ngue 'bet'o go ga̱ ørpa̱he ma̱su̱ p'ʉ ja ra̱ nts'i̱hmɛ̱. ");
INSERT INTO otnNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ja̱na̱ngue nu̱ya ma̱ zi cu̱'a̱hʉ, nu̱ua ha dí 'bʉhmʉ ya, da̱mi̱ hyomhmʉ yoto yø n'yohʉ da̱ ma ma̱fäti na̱ ra̱ 'bɛfi na̱. Pɛ gue da̱ gue'ʉ yø n'yohʉ bá̱ di̱nna̱ hya̱, 'nɛ̱ nnu̱ ma̱nsu̱ gätho yø ja̱'i̱, 'nɛ̱ da̱di̱ nɛ̱qui̱ ngue n'youi ra̱ Espíritu Santo. ");
INSERT INTO otnNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A nu̱gähe p'ʉya, ga̱ siguegähe ra̱ mhmat'Oja̱, 'nɛ̱ ga̱ nxännba̱he yø ja̱'i̱ rá̱ hya̱ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gä 'da'igu̱ bi̱ ma̱mp'ʉya. Bi than'na̱ ra̱ Teba p'ʉya, ngue da̱ t'ɛ̱ts'i̱. Guehna̱ n'na ra̱ n'yohʉ xa̱nzaqui rá̱ nt'ɛ̱c'ɛ̱i̱, 'nɛ̱ n'youi ra̱ Espíritu Santo. Conna̱ Lipe bi thanhni̱, ra̱ Prócoro, ra̱ Nicanor, ra̱ Timón, ra̱ Parmenas, ra̱ Nicolás nu̱na̱ ra̱ mmɛ̱ngu̱ Antioquía, guehna̱ ya xi 'yɛ̱c'ɛ̱i̱bi̱ m'mɛt'o yø nt'ɛ̱c'ɛ̱i̱ yø judío na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nu̱ya yø n'yohʉ bi thannbʉya, bi ts'ixpʉ 'bähyø representante ra̱ Cristo ngue bi̱ marpa̱bi̱ Oja̱. Nu̱ya yoto nja̱'i̱ bi t'u̱nyø cargo, bi japyø 'yɛ p'ʉ ja yø ya̱. ");
INSERT INTO otnNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Rá̱ hya̱ Oja̱ p'ʉya, ma̱n'na ni̱ ma ma̱'yoni̱tho. Ma̱n'na ni̱ 'yɛ̱c'ɛ̱i̱tho yø ja̱'i̱ p'ʉ ja ra̱ hni̱ni̱ Jerusalén. Xquet'a̱ xa̱ngu̱ yø mmäcja̱ bi̱ nu̱ ma̱nho ra̱ hya̱, 'nɛ̱ bi 'yɛ̱c'ɛ̱i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Xa̱ndøngu̱ rá̱ nja̱pi̱ Oja̱ bi u̱nna̱ Teba, ngue yø hmɛ̱ya bi 'yørbʉ 'bʉhyø ja̱'i̱. Nu̱ya yø milagro bi 'yøt'e, hi̱njongui̱ sä da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bi̱ mʉdi bi̱ nju̱ntui ra̱ Teba ya yø n'yohʉ pap'ʉ ja rá̱ ni̱ja̱ yø judío ni̱ hu̱ ngue ra̱ Libertos, 'nɛ̱hya yø judío ngue yø mmɛ̱ngu̱ Cirene, 'nɛ̱hya yø mmɛ̱ngu̱ Alejandría, 'nɛ̱hya yø mmɛ̱ngu̱ Cilicia, 'nɛ̱hya yø mmɛ̱ngu̱ Asia, gä tønhma̱hya̱ ra̱ Teba. ");
INSERT INTO otnNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pɛ hi̱mbi̱ zä xtá̱ ndäjpa̱ rá̱ hya̱, porque ra̱ Espíritu Santo di bɛ̱nnba̱bi̱ ra̱ hya̱ mma̱nna̱ Teba. ");
INSERT INTO otnNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Asta̱ bi̱ da̱hra̱ mɛ̱nyu̱ 'da p'ʉya, sifi ngue da̱ ma̱ ngue xi 'yøde ngue ya̱ ma̱nts'o ra̱ Teba ngue sʉhra̱ Moisés, 'nɛ̱ sʉ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ja̱na̱ngue bi yʉns'yø ja̱'i̱ p'ʉya, bi̱ mpɛti yø n'yohʉ 'bɛt'o ngue yø judío, 'nɛ̱hyø xännba̱te ngue ra̱ ley. Bi bɛnt'i̱, bi zixpʉ bi̱ nja ra̱ junta. ");
INSERT INTO otnNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bi t'ɛ̱xyø ja̱'i̱ da̱ ma̱nyø fɛhni̱ p'ʉya, bi 'yɛ̱na̱: ―Nu̱na̱ ra̱ n'yohʉ 'bʉcua, hi̱ngui̱ säya ngue nnømma̱n'ʉ ra̱ ma̱ca̱ ni̱ja̱ ja ua, 'nɛ̱ nnømma̱n'ʉbi rá̱ ley Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ya xtá̱ øcähe te mma̱nna̱ ngue nu̱na̱ ra̱ Jesús ra̱ mmɛ̱ngu̱ Nazaret, ɛ̱mbi̱ ngue da̱ dɛ̱mhra̱ ni̱ja̱ 'na̱. 'Nɛ̱ ɛ̱mbi̱ ngue di pähyø costumbre bi zoga̱hʉ ra̱ Moisés. ");
INSERT INTO otnNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nu̱ to gä mi̱ hu̱p'ʉ ja ra̱ junta p'ʉya, hɛ̱rpa̱bi̱ rá̱ hmi̱ ra̱ Teba ngue ɛ̱ntho rá̱ hmi̱ n'na rá̱ anxɛ Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nu̱'a̱ rá̱ hmu̱ yø mmäcja̱ p'ʉya bi 'yɛ̱mbi̱: ―¿Ua ma̱jua̱ni̱'a̱ si'a̱'i̱ ya n'yø? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mi̱ da̱hra̱ Teba p'ʉya, bi 'yɛ̱na̱: ―Ague n'yø'a̱hʉ, da̱mi̱ 'yøhmʉ na̱ ra̱ hya̱ ga̱ mma̱ngä ya. Nu̱na̱ ma̱ mboxitahʉ ra̱ Abraham, nu̱'mø mi̱ m'mʉ p'ʉ ja ra̱ häi Mesopotamia, tobe hi̱mma̱ni̱ map'ʉ ja ra̱ häi Harán, bi̱ nthɛui na̱ Oja̱ ma̱guesɛ. ");
INSERT INTO otnNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Oja̱ bi 'yɛ̱mbi̱: “Da̱mi̱ sop'ʉ ni̱ häi ya, gätho'ʉ ni̱ mɛ̱ni̱ da̱ gop'ʉ. Guí̱ mmap'ʉ ja ra̱ häi ga̱ xi'i”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nu̱na̱ ra̱ Abraham, bá̱ pømp'ʉ ja rá̱ häi ni̱ hu̱ ngue Caldea mi̱ 'bʉi. Bi̱ ma, i̱ m'mʉ p'ʉ Harán. M'mɛfa p'ʉya, bi du̱ rá̱ papá. Oja̱ p'ʉya, bi xihra̱ Abraham ngue bá̱ ɛ̱cua ja ra̱ häi dí 'bʉhmʉ ya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pɛ nu̱'mø ma̱mba̱ ɛ̱hɛ̱, ni̱ xi̱nga̱ n'na xɛqui xtí u̱nna̱ ra̱ häi ja ua. Ni̱ xi̱nga̱ guep'ʉ di 'bämrá̱ gua xtí u̱nni̱. Pɛ ma̱da̱gue'a̱, nu̱na̱ Oja̱ bi ya̱rpi̱ ngue di u̱nni̱ gätho na̱ ra̱ häi ja ua. A nu̱'mø bi du̱ p'ʉya, da̱ gohmi̱ yø ba̱si̱. Nu̱'ʉ yø pa'ʉ p'ʉya, tobe hi̱m ma̱ni̱ m'mʉhyø ba̱si̱ ra̱ Abraham. ");
INSERT INTO otnNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nu̱na̱ Oja̱ bi 'yɛ̱mbra̱ Abraham, “Nu̱'ʉ ni̱ mbom'mɛto, goho ciento njɛya da̱ni̱ m'mʉp'ʉ ja n'na ra̱ 'dan'yo häi. Ja da̱ ma ma̱'ʉni̱ p'ʉ, porque jatho da̱ 'yøtra̱ 'bɛfi di̱ ma̱nda yø hmu̱”. ");
INSERT INTO otnNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pɛ Oja̱ bi 'yɛ̱mbi̱: “Ga̱ ha̱spa̱gä ra̱ güɛnda ya yø ja̱'i̱ da̱ 'yøt'e ngue yø hmu̱. M'mɛfa p'ʉya, da̱ ɛ̱cua ya ma̱ ja̱'i̱ ngue da̱ da̱nnegui”, bi 'yɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nu̱na̱ Oja̱ bi gohmi̱ n'na ra̱ cohi ra̱ Abraham, bi xifi ngue da̱ thɛjpa̱ n'na xɛqui ra̱ xifani̱ rá̱ do'yo yø ts'ʉnt'ʉ 'mø bi̱ m'mʉi. Gue'a̱ ni̱ hu̱ ngue ra̱ circuncisión, guehna̱ da̱ nøpa̱ hmɛ̱ya na̱ ngue'a̱ ra̱ cohi bi 'yøt'e. Ja̱na̱ngue nu̱'mø mi̱ m'mʉhra̱ Isaac, bi̱ mɛ̱pya 'mø mi̱ gua'a̱ nhya̱to ma̱ pa. Nu̱na̱ ra̱ Isaac xquet'a̱ ngu̱'a̱ bi 'yør'mø mi̱ m'mʉhrá̱ ts'ʉnt'ʉ ni̱ hu̱ ngue ra̱ Jacob. Nu̱na̱ ra̱ Jacob xquet'a̱ ngu̱'a̱ bi japya 'dɛ'ma̱ yoho yø ts'ʉnt'ʉ bi̱ m'mʉ'a̱ m'mɛfa, guehya yø xita ya ngue yø judío. ");
INSERT INTO otnNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nu̱ya yø ts'ʉnt'ʉ ra̱ Jacob, gä bi sɛyabi na̱ ra̱ José yø n'yohʉ. Ja̱na̱ngue bi̱ 'bä na̱ ra̱ José p'ʉya, bi dänyø ja̱'i̱ ma̱ni̱ ma Egipto. Pɛ ra̱ José, bi̱ mäx Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nu̱ hangu̱ ra̱ n'ʉ bi zä ra̱ José, bi ya̱n'Oja̱. 'Nɛ̱ bi u̱nná̱ n'yomfɛ̱ni̱ xa̱nho. Bi 'yøt'Oja̱ ngue bi̱ nu̱ ma̱nho ra̱ José na̱ ra̱ Faraón. Nu̱na̱ ra̱ Faraón ma̱rá̱ da̱st'abi p'ʉ ja ra̱ häi Egipto, guehna̱ bi 'yɛ̱xra̱ José ngue di̱ ma̱nda p'ʉ Egipto na̱, 'nɛ̱ bi 'yɛ̱ts'i̱ ngue bi̱ ma̱ndabi p'ʉ ja rá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","N'na ra̱ pa p'ʉya, bi̱ nja ra̱ ot'i p'ʉ ja ra̱ häi Egipto, 'nɛ̱p'ʉ ja ra̱ häi Canaán bi̱ nja ra̱ ot'i. Ndu̱mmʉitho te bi̱ nja. A nu̱'ʉ ma̱ mboxitahʉ p'ʉya, hi̱nha ti̱ni̱ te da̱ zi. ");
INSERT INTO otnNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ngu̱ i 'yøde ngue bí ja te da̱ ts'i p'ʉ ja ra̱ häi Egipto, bi̱ mɛnhyø ts'ʉnt'ʉ ngue da̱ tu̱ ra̱ trigo. Ya rá̱ mʉditho na̱ ra̱ 'yogui na̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Rá̱ yondi̱ bi̱ ma p'ʉya, ya bá̱ mpa̱te'ʉ yø n'yohʉ ra̱ José p'ʉya. Ya bá̱ mmɛ̱ya ra̱ Faraón ngue te'o yø mɛ̱ni̱ ra̱ José p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Bi̱ ma̱nda na̱ ra̱ José ngue bá̱ ts'i̱nnba̱bi̱ rá̱ papá Jacob, gätho'ʉ mi̱'da yø mɛ̱ni̱ bá̱ ts'i, hya̱te ma̱'dɛ'ma̱ cʉt'a nja̱'i̱ mi̱ sʉdi ngue gätho. ");
INSERT INTO otnNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ja̱na̱ngue bi̱ njap'ʉ ngue i̱ mpa Egipto ra̱ Jacob. Ja bá̱ tu̱p'ʉ p'ʉya. Xquet'a̱ 'nɛ̱'ʉ 'dɛ'ma̱ yoho yø ts'ʉnt'ʉ bá̱ tu̱p'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pɛ hi̱mbá̱ t'äp'ʉ Egipto 'mø mi̱ du̱, porque nu̱ya yø ts'ʉnt'ʉ ra̱ Hamor ngue yø mmɛ̱ngu̱ Siquem, ya xi̱ mä n'na ra̱ panteón ngue xi dänna̱ Abraham, ja i thu̱xpʉ ngue bá̱ t'ägui. ");
INSERT INTO otnNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Pɛ ɛ̱na̱ bi ba̱'mø ni̱ ma da̱ zønna̱ pa di̱ nja'a̱ ra̱ hya̱ xi ya̱rpa̱bi̱ Oja̱ ra̱ Abraham, ma̱thoguitho bi̱ nxa̱ndyø judío p'ʉ Egipto. ");
INSERT INTO otnNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nu̱p'ʉ Egipto, bi̱ m'mʉ'a̱ m'mɛfa n'na ra̱ da̱st'abi ngue hi̱mbi̱ ba̱di̱ te'o na̱ ra̱ José. ");
INSERT INTO otnNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nu̱na̱ ra̱ da̱st'abi na̱, bi̱ nu̱ ma̱n'ʉ ya ma̱ mboxitahʉ. Bi japi ngue da̱ 'yɛnyø ba̱si̱ 'mø bi̱ m'mʉi, n'namhma̱ da̱ du̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Gue'ʉ yø pa'ʉ p'ʉya, ngue bi̱ mi̱hra̱ Moisés. Guehna̱ n'na ra̱ zits'ʉnt'ʉ bi̱ nu̱ ma̱nho Oja̱. Pɛ hønda̱ nhyu̱shna̱ bi zi rá̱ ma̱má p'ʉ ja rá̱ ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nu̱'mø mi̱ 'yɛmp'ʉya, nu̱na̱ rá̱ t'i̱xu̱ ra̱ Faraón guesɛ na̱ bi hya̱xra̱ 'uɛne ngue bi tede tengu̱tho 'mø drá̱ ba̱si̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nu̱na̱ ra̱ Moisés, gä bi ba̱rpa̱bi̱ yø mfa̱di̱ yø mmɛ̱ngu̱ Egipto. 'Nɛ̱ bi 'yɛ̱hra̱ pa ngue bi zɛdi te bi̱ ma̱. 'Nɛ̱ pa̱di̱ xa̱nho ha di japi te da̱ 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nu̱'mø mi̱ gua'a̱ nyote njɛya 'bʉhra̱ Moisés, bi zo rá̱ mmʉi ngue da̱ ma di zɛngua ya yø judío ngue yø mɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mi̱ zømp'ʉ 'bʉhyø mɛ̱ni̱ p'ʉya, bi̱ nu̱ n'na ra̱ mmɛ̱ngu̱ Egipto ngue di ʉnnba̱bi̱ n'na rá̱ mɛ̱ni̱. Bi cospa̱bi̱'a̱ te mi̱ ørbʉya, pɛ bi hyo'a̱ ra̱ mmɛ̱ngu̱ Egipto. ");
INSERT INTO otnNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nu̱na̱ ra̱ Moisés bi 'yɛ̱na̱ ngue di̱ mmɛ̱ya'ʉ yø mɛ̱ni̱ ngue bi̱ mɛnnba̱bi̱ Oja̱ ngue da̱ ya̱ni̱ para ngue da̱ ma ma̱thøgue p'ʉ sä ra̱ n'ʉ. Pɛ hi̱mbi̱ mmɛ̱ya yø judío te t'ørpa̱bi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mi̱ hyaxpʉya, nu̱na̱ ra̱ Moisés bi di̱mmi̱ yo nc'ɛ̱i̱ yø judío ngue di̱ ndu̱nsɛ. Bi hejpa̱ p'ʉya, i̱ nnepe ngue di̱ nhyɛgui, bi 'yɛ̱mbi̱: “Ague n'yø'a̱ui, ga̱di̱ mmɛ̱ni̱ui. ¿Hanja ngue ga̱di̱ ndu̱nsɛui?” bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nu̱'a̱ mi̱ pʉte p'ʉya, bi nønhna̱ Moisés, bi 'yɛ̱mbi̱: “¿Te'o bi 'yɛ̱xa̱'i̱ ngue gui̱ nts'ʉt'abi, ngue gui hya̱sca̱'be ra̱ güɛnda? ");
INSERT INTO otnNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ua guí̱ nne gui hyogui tengu̱tho gá̱ japa̱ n'na nc'ɛ̱i̱ ra̱ mmɛ̱ngu̱ ua Egipto ma̱nde?” bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mi̱ 'yøhra̱ Moisés ngue t'ɛ̱mbi̱ xi̱ nhote, bi 'dagui, i̱ map'ʉ ja ra̱ häi Madián. Ja i̱ m'mʉp'ʉ p'ʉya, 'nɛ̱ ja bá̱ mi̱p'ʉ yoho yø ts'ʉnt'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nu̱na̱ ra̱ Moisés, mi̱ gua'a̱ nyote njɛya ngue 'bʉp'ʉ Madián. Nu̱p'ʉ ja ra̱ da̱po jonna̱ t'øhø Sinaí, bi̱ nu̱ n'na ra̱ ndʉt'o ngue tøhra̱ sibi. Ja bá̱ nya̱p'ʉ rá̱ anxɛ Oja̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nu̱'mø mi̱ hyɛ̱tra̱ sibi ra̱ Moisés, di 'yøtho hanja'a̱ te bi̱ nu̱. Bi guarbʉya ngue da̱ nu̱ xa̱nho. Bá̱ nya̱ Oja̱ p'ʉya, bi 'yɛ̱mbi̱: ");
INSERT INTO otnNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Guecä drá̱ Oja̱ mi̱ tha̱nnegä ni̱ mboxita Abraham. Drá̱ Oja̱gä ngue ra̱ Isaac, drá̱ Oja̱gä ngue ra̱ Jacob”, bi 'yɛ̱n'Oja̱. Pɛ asta̱ hua̱cra̱ Moisés ngue bi̱ nsu̱. Ya hi̱ngui̱ ha̱ nza̱mmʉi ngue da̱ hyɛ̱ti̱ xa̱nho. ");
INSERT INTO otnNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bi 'yɛ̱n'Oja p'ʉya: “Da̱mi̱ c'ojhni̱ thi̱xfani̱, porque nu̱ua guí 'bäi, ra̱ ndʉxca̱häi ua. ");
INSERT INTO otnNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Dí̱ nnu̱gä ra̱ n'ʉ i thohma̱ ja̱'i̱gä rá̱ m'mʉ'a̱ Egipto. Dí ø'mø da̱nts'i̱. Dá̱ ɛ̱cä ya ngue ga̱ nya̱ni̱ n'namhma̱ ngue da̱ ma ma̱thøgue. Ague Moisés, dí̱ nne ga̱ pɛn'na̱'i̱ Egipto ya” ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ma̱da̱gue'a̱ hi̱mbi̱ nu̱ ma̱nho m'mɛt'o yø judío na̱ ra̱ Moisés ngue xi 'yɛ̱mbi̱: “¿Te'o xpá̱ 'yɛ̱xa̱'i̱ ngue guí̱ nts'ʉt'abi, ngue guí hya̱sca̱'be ra̱ güɛnda?” xi 'yɛ̱mbi̱, pɛ guehna̱ bi 'yɛ̱x Oja̱ ngue dyø hmu̱ yø ja̱'i̱ nu̱ya da̱ jʉqui. Ngu̱na̱ bi xihra̱ anxɛ bi̱ nu̱p'ʉ ja ra̱ ndʉt'o mi̱ da̱nzø. ");
INSERT INTO otnNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nu̱na̱ ra̱ Moisés, guehna̱ bá̱ jʉjpʉ ja ra̱ häi Egipto ma̱ mboxitahʉ na̱. Ja bá̱ u̱p'ʉ yø hmɛ̱ya ngue yø milagro bi 'yøt'e, tengu̱tho bi 'yørbʉ ja ra̱ Thɛnga̱ Ja̱the. Bi 'yøtyø milagro mɛ̱nte bi̱ n'yo da̱po nyote njɛya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nu̱na̱ ra̱ Moisés bi xihyø ja̱'i̱, bi 'yɛ̱mbi̱: “Nu̱na̱ Oja̱, da̱ 'yɛ̱xa̱ n'na ra̱ pønga̱hya̱ ngue yø judío tengu̱tho bi jacä. Nu̱na̱ ra̱ pønga̱hya̱ na̱ p'ʉya, da̱mi̱ 'yøhmʉ te gäma̱ hya̱ da̱ xi'a̱hʉ”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Guehna̱ 'dap'ʉ bi̱ n'yohʉ yø ja̱'i̱ p'ʉ ja ra̱ da̱po na̱ ra̱ Moisés. 'Nɛ̱ bi̱ map'ʉ ja ra̱ t'øhø Sinaí ngue bá̱ nya̱ui rá̱ anxɛ Oja̱. Ja bá̱ sip'ʉ rá̱ hya̱ Oja̱ p'ʉya. Bá̱ ɛ̱p'ʉ 'bʉhma̱ mboxitahʉ ngue di thojpa̱bi̱ na̱ ra̱ hya̱ bá̱ sifi, guehna̱ ra̱ hya̱ bi t'u̱nni̱ ngue di thoga̱hʉ na̱ya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pɛ ma̱ mboxitahʉ hi̱mbi̱ 'yɛ̱c'ɛ̱i̱ na̱ ra̱ hya̱ bi̱ ma̱nna̱ Moisés. Bi̱ mɛspa̱tho te bi̱ ma̱, sinoque bi̱ ne xta̱bá̱ mmenga̱ Egipto ma̱høn'a̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bi 'yɛ̱mbyø ja̱'i̱ ra̱ Aarón: “Ague Aarón, dí̱ nnegähe ngue gui hocyø da̱hmu̱ di̱ m'mɛt'o p'ʉ gdá̱ mähä. Porque nu̱na̱ ra̱ Moisés bá̱ jʉga̱hʉ p'ʉ ja ra̱ häi Egipto, hi̱ndí̱ pa̱hmʉ te bá̱ jana̱”, bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bi hoca̱ n'na ra̱ da̱hmu̱ ngue ra̱ t'ʉnda̱ni̱ p'ʉya. 'Nɛ̱ bi hyo yø mbo'øni̱ ngue bi 'yørpa̱ ra̱ 'bøt'e ra̱ da̱hmu̱. Di johya yø ja̱'i̱ ngue ya bi hocra̱ da̱hmu̱ da̱ da̱nne. ");
INSERT INTO otnNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nu̱na̱ Oja̱ p'ʉya, bi hyɛp'ʉ yø ja̱'i̱. Bi u̱nna̱ 'yu̱ yø ja̱'i̱ ngue yø sø bí ja̱ ma̱ya̱, gä ørpa̱ yø da̱hmu̱ ngue tha̱nne. Ngu̱'a̱ nt'ot'i p'ʉ ja ra̱ libro bi 'yotyø pønga̱hya̱ Oja̱ ngue ɛ̱na̱: “Ague gyø judíohʉ, mɛ̱nte gá̱ n'yo da̱pohʉ nyote njɛya, ¿ua gá̱ hyocjʉ yø mbo'øni̱ ngue gá̱ 'yø'ni̱ 'bøt'ehʉ? Nu̱'á̱, hi̱n'na̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hante gue nu̱p'ʉ gni̱ mähä, ga̱di 'yonnba̱hʉ rá̱ ngu̱ ra̱ da̱hmu̱ Moloc, 'nɛ̱ gui tu̱hʉ n'na ra̱ da̱hmu̱ ngue ra̱ sø ni̱ hu̱ ngue ra̱ Renfán. Guehya yø da̱hmu̱ ga̱di hocsɛ guí tha̱nnehʉ. Ja̱na̱ngue nu̱yá, ga̱ høn'a̱hʉ thip'ʉ ja ra̱ häi guí 'bʉhmʉ ya, gdá̱ pɛn'na̱hʉ ma̱n'na rá̱ nguep'ʉ ngue ra̱ häi Babilonia”, bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bi sigue bi̱ nya̱ ra̱ Teba p'ʉya, bi 'yɛ̱na̱: ―Nu̱p'ʉ ja ra̱ da̱po, nu̱ya ma̱ mboxitahʉ mi̱ ja n'na ra̱ ngu̱n'u̱lu ngue mi̱ nnøpa̱ ni̱ja̱ yø ja̱'i̱. Ja pɛspʉ yø xindo nt'ot'i rá̱ ley Oja̱. Nu̱na̱ ra̱ ngu̱n'u̱lu p'ʉya, bi xi Oja̱ ra̱ Moisés ngue da̱ 'yøt'e tengu̱tho ra̱ forma xi 'yu̱ti̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nu̱na̱ ra̱ ngu̱n'u̱lu di pont'a̱ cohmi̱. Nu̱'mø ma̱mba̱ ɛ̱hra̱ Josué bá̱ n'youi ma̱ mboxitahʉ, go bi søcua ra̱ ngu̱n'u̱lu ua dí 'bʉhmʉ'ʉ ya. Mi̱ zøhø bi hya̱nnba̱ yø häi yø 'dan'yo ja̱'i̱ mi̱ 'bʉcua. Guehna̱ Oja̱ bi hyøn'a̱thi yø mmɛ̱häi. Bi̱ nja ra̱ ngu̱n'u̱lu asta̱ gue'mø mi̱ m'mʉhra̱ da̱st'abi David. ");
INSERT INTO otnNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nu̱na̱ ra̱ David, xa̱ngu̱ rá̱ ma̱te Oja̱ bi di̱nnbi̱. Bi̱ ne ngue xta̱ hyø'a̱ n'na ra̱ ni̱ja̱, ngue rá̱ ngu̱ na̱ rá̱ Oja̱ mi̱ tha̱nne ra̱ Jacob. ");
INSERT INTO otnNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pɛ go bi hyøhra̱ ni̱ja̱ na̱ ra̱ Salomón rá̱ ts'ʉnt'ʉ ra̱ David. ");
INSERT INTO otnNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","A nu̱na̱ Oja̱ ma̱guesɛ, hi̱ngui̱ 'bʉp'ʉ ja yø ni̱ja̱ di hocyø ja̱'i̱ na̱. Porque rá̱ pønga̱hya̱ Oja̱ bi 'yotra̱ hya̱ bi̱ ma̱n'Oja̱ ngue bi 'yɛ̱na̱: ");
INSERT INTO otnNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Dí hu̱cä p'ʉ ma̱hɛ̱ts'i̱ ngue da̱di̱ ma̱nda. Nu̱ua ja ra̱ xi̱mhäi p'ʉya, di̱ nnøpa̱ nhnɛ̱ts'i. ¿Te 'bɛ'a̱ ma̱ngu̱ guí ɛ̱na̱ gui hoga̱hʉ? Ogue ¿hapʉ guí ɛ̱mhmʉ ngue ga̱ nsäyagä? ");
INSERT INTO otnNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ua hi̱ndá̱ hocä ya te gäma̱ cosa i ja?” bi 'yɛ̱n'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Bi sigue bi zohyø ja̱'i̱ ra̱ Teba, bi 'yɛ̱mbi̱: ―Xa̱ndø nna̱xi ni̱ mmʉihʉ. Ni̱ gu̱hʉ xa̱ncot'i, za̱nt'a̱ guí fɛsthohʉ te mma̱nna̱ Espíritu Santo. Tengu̱tho bi 'yør'ma̱ mboxitahʉ, guí̱ njathʉ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nu̱ya ma̱ mboxitahʉ, gätho yø pønga̱hya̱ Oja̱ xa̱ m'mʉi, gä xa̱ nzʉi. 'Nɛ̱ bi hyo'ʉ yø pønga̱hya̱ bi xihyø ja̱'i̱ ngue da̱ ɛ̱p'ʉ n'na nc'ɛ̱i̱ ngue gä ra̱ nho da̱ n'yo. A nu̱yá, ya bá̱ ɛ̱'a̱ to bi̱ ma̱n'ʉ yø pønga̱hya̱'ʉ. Pɛ gá̱ dähʉ ngue bi tho. ");
INSERT INTO otnNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ma̱da̱gue'a̱ bá̱ pɛnsɛ yø anxɛ Oja̱ ngue bi 'da'a̱hʉ ra̱ ley, pɛ hi̱nguí̱ ɛ̱c'ɛ̱i̱hʉ ra̱ hya̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nu̱'mø mi̱ 'yøhyø ja̱'i̱ na̱ ra̱ hya̱ bi si p'ʉya, bi̱ nda̱nzø yø mmʉi ngue ra̱ cuɛ, pɛts'i da̱ zadra̱ Teba. ");
INSERT INTO otnNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nu̱na̱ ra̱ Teba p'ʉya, di ha̱tra̱ ts'ɛdi ra̱ Espíritu Santo. Bi hyanma̱ hɛ̱ts'i̱ p'ʉya, bi hyandi̱ ngue di yoxni̱ Oja̱, 'nɛ̱ bi hyandi̱ ngue nu̱p'ʉ ja rá̱ n'yɛi Oja̱ ja 'bʉp'ʉ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Bi 'yɛ̱nna̱ Teba p'ʉya: ―Dí handä ngue bi xohra̱ c'amma̱hɛ̱ts'i̱. Nu̱nʉ ra̱ n'yohʉ bí 'yɛ̱ ma̱hɛ̱ts'i̱ p'ʉya, ya 'bʉhnʉ ja rá̱ n'yɛi Oja̱ nʉ ―bi 'yɛ̱na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bi̱ mʉhra̱ hmafi yø judío p'ʉya, bi gotyø gu̱, porque hi̱ngui̱ nne da̱ 'yøhna̱ ra̱ hya̱ mma̱nna̱ Teba. Bi̱ nyu̱ntyø ja̱'i̱ p'ʉya ngue bi bɛnt'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bi gʉjma̱ xøts'e ra̱ hni̱ni̱ ngue bá̱ pʉndo. Nu̱'ʉ yø testigo xi̱ ma̱nna̱ fɛhni̱ p'ʉya, bi ga̱cyø tu̱hu̱ ngue bi̱ møp'ʉ 'bä'a̱ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Saulo. Bi̱ mʉndo ra̱ Teba p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mɛ̱nte 'bʉndo ra̱ Teba p'ʉya, bi zo Oja̱, bi 'yɛ̱mbi̱: ―Ague ma̱ Hmu̱'i̱ Jesús, da̱di dä'i ma̱ te ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bi̱ nda̱ntyøhmu̱ p'ʉya, ra̱ ndøts'ɛdi bi 'yɛ̱na̱: ―Ague ma̱ Hmu̱'i̱ Jesús, 'yogui mbɛ̱nnba̱bi̱'a̱ te ra̱ ts'oqui øtya yø ja̱'i̱ 'bʉcua. Høntho bi̱ ma̱n'a̱ p'ʉya, bi du̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","'Da'igu̱ bi̱ ma̱mmi̱ ra̱ Saulo'ʉ to bi hyo ra̱ Teba. Nu̱'a̱ ra̱ pa'a̱ p'ʉya, bi̱ nanga̱ n'na ra̱ da̱sʉi p'ʉ Jerusalén ngue bi ts'ʉhyø 'yɛ̱c'ɛ̱i̱. Gä bi̱ n'uɛ̱nyø 'yɛ̱c'ɛ̱i̱, i̱ mpa mi̱'da yø hni̱ni̱ rá̱ njap'ʉ ja ra̱ häi Judea. I̱ mpa 'da asta̱ ra̱ häi Samaria. Pɛ nu̱ya yø representante ra̱ Cristo hi̱mbi 'dahya. ");
INSERT INTO otnNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nu̱ya yø n'yohʉ su̱prá̱ xu̱di̱ Oja̱, guehya bi 'yähra̱ Teba ya. Ja̱njua̱ni̱ zoni̱ ngue mbɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pɛ di sigue ngue sʉhyø 'yɛ̱c'ɛ̱i̱ na̱ ra̱ Saulo. I huaxtyø ngu̱, bi jʉcyø n'yohʉ 'nɛ̱hyø xisu ngue cot'i. ");
INSERT INTO otnNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nu̱ya yø ja̱'i̱ bi 'dap'ʉ Jerusalén, ndap'ʉ bi zä i̱ mpa yø ja̱'i̱, pɛ gä mma̱nna̱ hoga̱ 'da'yo hya̱ p'ʉ ni̱ ma. ");
INSERT INTO otnNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nu̱'a̱ ra̱ Lipe guehna̱ n'na nc'ɛ̱i̱ ra̱ 'dagui na̱, i̱ mpa p'ʉ ja n'na ra̱ hni̱ni̱ ngue ra̱ häi Samaria. Bi̱ mʉdi bi xihyø ja̱'i̱ ra̱ Cristo p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bi̱ mpɛti gätho yø ja̱'i̱ ngue øxra̱ hya̱ mma̱nna̱ Lipe. Mi̱ nu̱ yø ja̱'i̱ yø milagro bi 'yøtra̱ Lipe p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mi̱ 'bʉp'ʉ xa̱ngu̱ yø ja̱'i̱ ngue yø ndu̱nthi̱, pɛ gä bi t'øthe. Nu̱'mø xihyø ts'onthi̱ ngue da̱ hyɛp'ʉ yø ja̱'i̱ n'youi, asta̱ mafi. Xa̱ngu̱ yø dogua bi 'yøthe, xa̱ngu̱ yø ja̱'i̱ tu̱dyø gua bi 'yøthe. ");
INSERT INTO otnNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ja̱na̱ngue gä di johya yø ja̱'i̱ 'bʉp'ʉ ja ra̱ hni̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nu̱p'ʉ ja ra̱ hni̱ni̱, mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Simu̱. Mi̱ hyätyø ja̱'i̱ p'ʉ ja ra̱ häi Samaria conná̱ mfa̱di̱ ngue ra̱ magia, mi̱ ɛ̱na̱ ngue ma̱guesɛ. ");
INSERT INTO otnNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","A nu̱ná̱, di̱ngüɛ di̱nnoho mi̱ ørpa̱ ma̱su̱. Di̱ n'yɛ̱mbyø ja̱'i̱: “Nu̱na̱ ra̱ Simu̱, ja̱njua̱ni̱ ngue n'youi rá̱ ts'ɛdi Oja̱ na̱”, di̱ n'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mi̱ t'ørpa̱bi̱ ma̱su̱, porque ya rá̱ ya'atho yø pa mi̱ hätyø ja̱'i̱ conná̱ mfa̱di̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pɛ ra̱ Lipe bi xihra̱ hoga̱ 'da'yo hya̱ yø ja̱'i̱. Bi xihyø ja̱'i̱ ha di̱ njap'ʉ di zo rá̱ 'yɛ Oja̱. 'Nɛ̱ xifi hanja na̱ ra̱ Jesucristo. Nu̱'mø mi̱ t'ɛ̱c'ɛ̱i̱'a̱ te bi̱ ma̱nna̱ Lipe p'ʉya, yø n'yohʉ yø xisu bi̱ nxixya̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xquet'a̱ 'nɛ̱hra̱ Simu̱ bi 'yɛ̱c'ɛ̱i̱ ra̱ hya̱ 'nɛ̱ bi̱ nxixya̱. Asta̱ ya hi̱ngui̱ nne da̱ hyɛhra̱ Lipe na̱ ra̱ Simu̱. Di 'yøtho 'mø bi̱ nu̱ yø milagro øtra̱ Lipe. ");
INSERT INTO otnNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mi̱ 'yøhyø representante ra̱ Cristo mi̱ 'bʉ'a̱ Jerusalén ngue ya 'nɛ̱p'ʉ Samaria xi t'ɛ̱c'ɛ̱i̱ rá̱ hya̱ Oja̱. Ja i 'bɛnnbʉ ra̱ Bɛdu 'nɛ̱hra̱ Xuua p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nu̱'mø mi̱ zømp'ʉ Samaria'ʉ bi 'bɛnhni̱, bi̱ marpa̱bi̱ Oja̱ yø 'yɛ̱c'ɛ̱i̱ ngue nnepe di̱ n'youi ra̱ Espíritu Santo. ");
INSERT INTO otnNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porque tobe hi̱nga̱ n'na nc'ɛ̱i̱ mi̱ n'youi ra̱ Espíritu Santo. Sinoque høntho xi̱ nxixya̱ para ngue da̱ fa̱di̱ ngue ɛ̱c'ɛ̱i̱ ra̱ Hmu̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ra̱ Bɛdu 'nɛ̱hra̱ Xuua, nu̱'mø mi̱ japyø 'yɛ p'ʉ ja yø ya̱ yø 'yɛ̱c'ɛ̱i̱, yø 'yɛ̱c'ɛ̱i̱ p'ʉya bi̱ n'youi ra̱ Espíritu Santo. ");
INSERT INTO otnNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mi̱ nu̱ ra̱ Simu̱'a̱ te øtyø representante ra̱ Cristo, ngue nu̱'a̱ gui japyø 'yɛ p'ʉ ja yø ya̱ yø 'yɛ̱c'ɛ̱i̱, 'be xi̱ n'youi ra̱ Espíritu Santo yø 'yɛ̱c'ɛ̱i̱. Ra̱ Simu̱ p'ʉya, bi̱ ne xta̱ ngu̱tra̱ mɛ̱nyu̱ ngue di̱ njap'ʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Bi 'yɛ̱mbi̱: ―Da̱mi̱ 'dacui na̱ ra̱ ts'ɛdi ja'a̱ui, n'namhma̱ ngue nu̱ to bi zä ga̱ japä ma̱ 'yɛ p'ʉ ja rá̱ ya̱, di̱ n'youi ra̱ Espíritu Santo ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mi̱ da̱hra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱'a̱ ni̱ mɛ̱nyu̱ 'da gdi̱ m'mɛhmi̱'a̱. ¿Ha̱nto guí ɛ̱na̱ ngue nu̱'a̱ bá̱di̱ u̱n'Oja̱, ra̱ mɛ̱nyu̱ gdí ti̱n'a̱? ");
INSERT INTO otnNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nu̱'i̱ hi̱n'yʉ ni̱ mmɛ̱nthi̱ ngue guí̱ nthɛui na̱ ra̱ 'bɛfi na̱. Porque nu̱p'ʉ ja rá̱ hmi̱ rá̱ dä Oja̱, hi̱nga̱ njua̱ni̱tho ni̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Da̱mi̱ hyɛp'ʉ ra̱ nts'o ja ni̱ mmʉi. Da̱mi̱ 'yäprá̱ ma̱te Oja̱, xa̱mhma̱tho di pu̱n'na̱'i̱ te guí̱ mbɛ̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porque dí̱ nnu̱gä ngue grá̱ zɛya, 'nɛ̱ gä ra̱ nts'o xa̱ mbɛnt'ui ni̱ mmʉi. ");
INSERT INTO otnNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Bi 'yɛ̱nna̱ Simu̱ 'mø mi̱ da̱ p'ʉya: ―Da̱mi̱ marca̱uits'ʉ Oja̱ n'namhma̱ ngue hi̱nga̱ thocä'a̱ te guí̱ xicui. ");
INSERT INTO otnNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","M'mɛfa p'ʉya, nu̱ya yø representante ra̱ Cristo, nu̱'mø mi̱ juadi bi xihyø ja̱'i̱ ngue ma̱jua̱ni̱ na̱ rá̱ hya̱ Oja̱, bá̱ pengbʉya, bí 'yɛ̱'a̱ Jerusalén. Nu̱p'ʉ ja yø hni̱ni̱ ja'a̱ ra̱ häi Samaria bá̱ thogui, gä bi xihra̱ hoga̱ 'da'yo hya̱ yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","M'mɛfa p'ʉya, n'na rá̱ anxɛ Oja̱ bi xihra̱ Lipe, bi 'yɛ̱mbi̱: ―Nu̱yá, ja ngue gui̱ mma gdi̱ ma Sur. Gui hya̱xra̱ 'yu̱ bá̱ nɛ̱xa̱ Jerusalén, i̱ ntho'a̱ Gaza ―bi 'yɛ̱mbi̱. Nu̱p'ʉ i̱ nthohna̱ ra̱ 'yu̱ na̱, hi̱njongui̱ 'bʉi. ");
INSERT INTO otnNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bi̱ map'ʉ sihna̱ ra̱ Lipe. Bi̱ nthɛui p'ʉ ja ra̱ 'yu̱ n'na ra̱ n'yohʉ ngue ra̱ mmɛ̱ngu̱ Etiopía, ngue xpí 'yɛ̱hra̱ nda̱nne Jerusalén. Rá̱ 'bɛt'o mɛfi na̱ n'na ra̱ xisu ni̱ hu̱ ngue ra̱ Candase mi̱ nda̱st'abi p'ʉ Etiopía, mi̱ ja rá̱ cargo ngue ra̱ tesorero. ");
INSERT INTO otnNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ni̱ hu̱xrá̱ carro jʉtyø fani̱ ni̱ ma rá̱ häi Etiopía. Mɛ̱nte ni̱ 'yo p'ʉya, di xähra̱ libro bi 'yotra̱ pønga̱hya̱ Isaías. ");
INSERT INTO otnNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pɛ ra̱ Espíritu Santo bi 'yɛ̱mbra̱ Lipe: ―Da̱mi̱ cuatra̱ n'yohʉ ni̱ hu̱xrá̱ carro mma nʉ. ");
INSERT INTO otnNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ra̱ Lipe p'ʉya bi guarbʉ ja ra̱ carro. Bi 'yøde ngue nu̱na̱ ra̱ n'yohʉ di xäp'ʉ ja ra̱ libro bi 'yotra̱ Isaías. Bi 'yɛ̱mbʉya: ―¿Ua guí pa̱di̱ te ga̱di xähya? ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mi̱ da̱hna̱ ra̱ n'yohʉ p'ʉya, bi 'yɛ̱na̱: ―Pɛ ¿hague gdá̱ pa̱cä p'ʉya, 'nɛ̱ hi̱njo'o to da̱ xiqui hanja ra̱ hya̱? ―bi 'yɛ̱mbi̱. Bi xihra̱ Lipe p'ʉya ngue bi̱ nexpʉ ja ra̱ carro, 'dap'ʉ bi̱ mi̱hmi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nu̱'a̱ ra̱ parte nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro di xä p'ʉya, guehna̱ ra̱ hya̱ ngue ɛ̱na̱: “Tengu̱tho n'na ra̱ dɛ'yo 'mø ni̱ ma da̱ tho, di̱ mmu̱ti̱. Ogue nt'a̱xi̱ n'na ra̱ dɛ'yo hi̱ndi 'ya̱ni̱. Di̱ njarbʉtho na̱ ra̱ n'yohʉ 'mø ni̱ ma da̱ tho ya, hi̱ndi 'ya̱ni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Da̱ ma ma̱'bɛrpi̱ rá̱ sä ngue hi̱nda̱ ma m'mäts'i. ¿To go da̱ ba̱di̱ hague ngu̱ ra̱ nts'o da̱ 'yøtyø ja̱'i̱ di 'bʉ'a̱ ra̱ pa'a̱? Porque da̱ tha̱jpa̱bi̱ rá̱ te ua ja ra̱ xi̱mhäi”. ");
INSERT INTO otnNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nu̱na̱ ra̱ n'yohʉ p'ʉya, bi 'yänna̱ Lipe, bi 'yɛ̱mbi̱: ―Da̱mi̱ 'yørca̱ ra̱ ma̱te xiqui te'o na̱ mma̱nna̱ ra̱ pønga̱hya̱ na̱ya. ¿Uague nu̱sɛ, uague 'bʉi te'o ma̱n'na mma̱nna̱? ");
INSERT INTO otnNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mi̱ da̱hra̱ Lipe p'ʉya, i dʉmba̱tho'a̱ te nt'ot'i p'ʉ ja ra̱ Ma̱ca̱ Libro ma̱di xädi, bi xihra̱ hoga̱ 'da'yo hya̱ ngue ha bi̱ nja ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nu̱'mø mi̱ thop'ʉ po n'na ra̱ dehe p'ʉya, bi 'yɛ̱n'a̱ ra̱ n'yohʉ ya̱ui ra̱ Lipe: ―I poua ra̱ dehe ya, ¿ua hi̱nda̱ zä ga̱ nxixya̱gä 'mø? ");
INSERT INTO otnNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mi̱ da̱hra̱ Lipe p'ʉya, bi 'yɛ̱mbi̱: ―Nu̱'mø guí ha̱hni̱ mmʉi guí ɛ̱c'ɛ̱i̱ ra̱ hya̱, da̱ zä nja̱m'mø da̱ hi̱n'na̱. Mi̱ da̱hra̱ n'yohʉ p'ʉya, bi 'yɛ̱mbi̱: ―Dí ɛ̱c'ɛ̱i̱gä ngue ra̱ Jesucristo guehna̱ rá̱ Ts'ʉnt'ʉ Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Bi̱ ma̱nda ra̱ n'yohʉ ngue bi̱ ma ma̱'bä'mi̱ ra̱ carro p'ʉya. Bi̱ mɛp'ʉ ja ra̱ dehe ngue bi xixya̱bi̱ ra̱ n'yohʉ na̱ ra̱ Lipe. ");
INSERT INTO otnNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nu̱'mø mi̱ bøn'a̱ nenthe p'ʉya, bi gʉs'ra̱ Espíritu Santo ra̱ Lipe. Nu̱na̱ ra̱ n'yohʉ bi̱ nxixya̱ p'ʉya, ya hi̱nha ma̱mbi̱ nu̱ ra̱ Lipe. Bi sigue bi̱ n'yo p'ʉya, pɛ di johya gä ra̱ 'yu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mi̱ da̱mbɛ̱ni̱ ra̱ Lipe p'ʉya, ya 'bʉp'ʉ ja ra̱ hni̱ni̱ Azoto. Bi̱ n'yo ngue bi hya̱ 'da yø hni̱ni̱ ngue bi̱ ma̱nna̱ hoga̱ 'da'yo hya̱, asta̱ gue'mø mi̱ zømp'ʉ ja ra̱ hni̱ni̱ Cesarea. ");
INSERT INTO otnNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nu̱na̱ ra̱ Saulo, hi̱ngui̱ säya di pihyø ja̱'i̱ ngue nne da̱ hyo'ʉ ɛ̱c'ɛ̱i̱ ra̱ Hmu̱ Jesús. Bi̱ map'ʉ 'bʉhrá̱ hmu̱ yø mmäcja̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Bi 'yäpra̱ sʉcua̱ da̱ ga̱ts'i̱, di̱ map'ʉ ja yø ni̱ja̱ p'ʉ ja ra̱ hni̱ni̱ Damasco, ni̱ hya̱ ra̱ ts'ɛdi ngue da̱ si'ʉ to ɛ̱c'ɛ̱i̱ ra̱ hoga̱ 'da'yo hya̱. Nu̱'mø yø n'yohʉ ogue yø xisu da̱ ti̱ni̱, da̱ tu̱t'i̱ da̱ sip'ʉ Jerusalén ngue di̱ n'ofädi. ");
INSERT INTO otnNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pɛ nu̱'mø ni̱ ma da̱ zøt'a̱ Damasco p'ʉya, ntha̱mbɛ̱ni̱tho bi yot'a̱ n'na ra̱ nyot'i ma̱ya̱ ngue bi̱ nthɛui. ");
INSERT INTO otnNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Bi dä'a̱ häi ra̱ Saulo p'ʉya. Bi 'yø p'ʉya ngue ts'ofo, bi t'ɛ̱mbi̱: ―Ague Saulo. Ague Saulo. ¿Hanja ngue ɛ̱mmɛ̱i̱ guí̱ sʉqui? ");
INSERT INTO otnNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mi̱ da̱hra̱ Saulo p'ʉya, bi 'yɛ̱mbi̱: ―¿Te'o'i p'ʉya, grá̱ Hmu̱? Nu̱'a̱ nzo p'ʉya, bi 'yɛ̱mbi̱: ―Go guecä drá̱ Jesús ngue ɛ̱mmɛ̱i̱ guí sʉqui. Pɛ ga̱di̱ n'ʉnsɛ, tengu̱tho ra̱ nda̱ni̱ 'mø ɛmbra̱ nhnɛt'i̱ ra̱ za ma̱ sʉni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Asta̱ hua̱cra̱ Saulo ngue bi̱ nsu̱. Bi 'yɛ̱mbʉya: ―Ague grá̱ Hmu̱, ¿teni̱ 'bɛ'a̱ guí̱ nneque ga̱ øt'ä p'ʉya? Mi̱ da̱hra̱ Hmu̱ Jesús, bi 'yɛ̱mbi̱: ―Da̱mi̱ nangui̱, ni̱ manʉ bí ja ra̱ hni̱ni̱. Ja da̱ni̱ si'i̱ nʉ te ja ngue gui 'yøt'e. ");
INSERT INTO otnNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɛ̱mmɛ̱i̱ di 'yødya yø n'yohʉ mi̱ n'youi ra̱ Saulo, porque bi 'yøde ngue bi ya̱ ma̱ya̱'a̱ nzohra̱ Saulo, pɛ hi̱njombi̱ nu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nu̱'mø mi̱ nanga̱ häi ra̱ Saulo p'ʉya, i̱ nne di̱ nhanni̱, pɛ bi̱ nxädä. Ja̱na̱ngue bi̱ ma ma̱cʉnhni̱, bi zøn'a̱ Damasco. ");
INSERT INTO otnNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Bi̱ m'mʉp'ʉ nhyu̱ pa, pɛ hi̱nha hɛ̱ti̱. Xi̱ngra̱ hmɛ̱, ni̱ xi̱ngra̱ dehe xta̱ nzi. ");
INSERT INTO otnNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nu̱p'ʉ Damasco, mi̱ 'bʉp'ʉ n'na ra̱ 'yɛ̱c'ɛ̱i̱ ni̱ hu̱ ngue ra̱ Ananías. Nu̱na̱ ra̱ Hmu̱ Jesús bi zohra̱ Ananías, bi 'yɛ̱mbi̱: ―Ague Ananías ―bi 'yɛ̱mbi̱. Mi̱ da̱ p'ʉya, bi 'yɛ̱na̱: ―Dí 'bʉcua grá̱ Hmu̱. ¿Tema̱ hya̱? ");
INSERT INTO otnNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mi̱ da̱hra̱ Jesús, bi 'yɛ̱mbi̱: ―Ga̱ 'yo, ni̱ map'ʉ ja ra̱ caye ni̱ hu̱ ngue Njua̱ntho. Cʉrbʉ ja rá̱ ngu̱ ra̱ Judas. Da̱mi̱ 'yännbʉ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Saulo, ra̱ mmɛ̱ngu̱ Tarso. Nu̱ya, ɛxa̱ bi̱ mmat'Oja̱ ya. ");
INSERT INTO otnNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mɛ̱nte mmat'Oja̱ ra̱ Saulo p'ʉya, nu̱p'ʉ i̱ nu̱, bi zøn'a̱ n'na ra̱ n'yohʉ p'ʉ ha 'bʉi ni̱ hu̱ ngue ra̱ Ananías. Bi̱ nu̱ ngue bi yʉt'a̱mbo, bi japrá̱ 'yɛ p'ʉ ja rá̱ ya̱ para ngue di̱ nzø yø dä. ");
INSERT INTO otnNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nu̱'mø mi̱ 'yø'a̱ ra̱ hya̱ sihra̱ Ananías, bi 'yɛ̱na̱: ―Ague grá̱ Hmu̱, xa̱ngu̱ ra̱ nts'o dí øcä xa̱ 'yø'na̱ ra̱ Saulo ngue di ʉnyø ja̱'i̱ nu̱'ʉ ɛ̱c'ɛ̱i̱'i̱ p'ʉ Jerusalén. ");
INSERT INTO otnNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A nu̱yá, bá̱ äpra̱ sʉcua̱ yø hmu̱ yø mmäcja̱ ya, ngue bá̱ ɛ̱cua ngue nu̱'ʉ yø ja̱'i̱ nzo'i, gä da̱ du̱t'i̱ da̱ zits'i. ");
INSERT INTO otnNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pɛ ra̱ Hmu̱ Jesús bi 'yɛ̱mbra̱ Ananías: ―Ni̱ mahma̱. Porque nu̱na̱ ra̱ n'yohʉ na̱, ya xtá̱ huanhnä na̱ ngue da̱ xihyø ja̱'i̱ te'ogui. Da̱ xihyø ja̱'i̱ rá̱ m'mʉ'a̱ n'nanni̱ yø nación, 'nɛ̱p'ʉ ha 'bʉhyø da̱st'abi da̱ ma̱ te'ogui, 'nɛ̱p'ʉ 'bʉhyø judío da̱ xifi te'ogui. ");
INSERT INTO otnNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nu̱gä ga̱ u̱ti̱ hague ngu̱ ga̱ngu̱ ra̱ n'ʉ da̱ thogui conná̱ ngueque. ");
INSERT INTO otnNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nu̱na̱ ra̱ Ananías bi̱ map'ʉ ja ra̱ ngu̱ ma̱mbí 'bʉhra̱ Saulo. Mi̱ yʉt'a̱mbo p'ʉya, bi japrá̱ 'yɛ p'ʉ ja rá̱ ya̱ ra̱ Saulo, bi 'yɛ̱mbi̱: ―Ague ma̱ zi cu̱'i̱ Saulo, nu̱na̱ ra̱ Hmu̱ Jesús bá̱ zo'i p'ʉ ja ra̱ 'yu̱, xpá̱ mmɛnngä ya ngue da̱ zä di̱ nzø ni̱ dä, 'nɛ̱ gui̱ n'youi ra̱ Espíritu Santo ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","'Bexque'a̱ bi̱ nzø yø dä ra̱ Saulo p'ʉya. Bi hyø'ʉ ɛ̱na̱ yø xihua̱ mi̱ ja yø dä. Bi̱ nxixya̱ p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mi̱ nsi̱hmɛ̱ p'ʉya, ma̱hømbi hya̱ ra̱ ts'ɛdi. Bá̱ m'mʉhma̱ njammi̱ pa p'ʉ 'bʉhyø 'yɛ̱c'ɛ̱i̱ p'ʉ Damasco. ");
INSERT INTO otnNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bi dʉ'mi̱ bi̱ ma̱nna̱ hya̱ ra̱ Saulo p'ʉ ja yø ni̱ja̱ di̱ mpɛti yø judío p'ʉya. I xihyø ja̱'i̱ ngue ra̱ Jesús, gue'a̱ rá̱ Ts'ʉnt'ʉ Oja̱'a̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nu̱ya gätho yø ja̱'i̱ øde te mma̱mp'ʉya, di 'yøtho, di̱ n'yɛ̱mbi̱: ―¿Ua hi̱nga̱ guehna̱ ra̱ n'yohʉ 'bʉ'a̱ Jerusalén, nu̱na̱ t'ɛ̱mbi̱ sʉhyø ja̱'i̱ ɛ̱c'ɛ̱i̱ ra̱ Jesús? Hua̱ngui̱ gue'a̱ ni̱ 'yɛ̱cua'a̱ ya ngue da̱ du̱t'ʉ to da̱ di̱ni̱, da̱ zispa̱bi̱ yø hmu̱ yø mmäcja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pɛ ma̱n'na ni̱ hya̱dra̱ ts'ɛdi ra̱ Saulo ngue mma̱nna̱ hya̱. I u̱tyø ja̱'i̱ te mma̱mp'ʉ ja ra̱ Ma̱ca̱ Libro, ngue ra̱ Jesús guehna̱ ra̱ Cristo xa̱ 'yɛ̱x'Oja̱ ngue di̱ nda̱st'abi na̱. Asta̱ hi̱ngui̱ pa̱di̱ te da̱ 'yøtyø judío mi̱ 'bʉ'a̱ Damasco. ");
INSERT INTO otnNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mi̱ ma ya'atho yø pa p'ʉya, bi̱ nhɛca̱hya̱ yø judío ngue xta̱ hyo ra̱ Saulo. ");
INSERT INTO otnNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nu̱'ʉ yø hyote, i fähyø goxthi ngue ra̱ neni̱hni̱ ngue da̱ hyo 'mø bi thop'ʉ. Pɛ mi̱ mmɛ̱ya'a̱ te fɛnnba̱bi̱ ra̱ Saulo. ");
INSERT INTO otnNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nu̱'mø mi̱nxu̱i̱ p'ʉya, nu̱ya yø 'yɛ̱c'ɛ̱i̱ bi 'yɛ̱t'a̱ n'na ra̱ canasta na̱ ra̱ Saulo. I ca̱mbʉ ja ra̱ ja̱do di thɛsra̱ neni̱hni̱. Bi bømp'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nu̱na̱ ra̱ Saulo, mi̱ zøn'a̱ Jerusalén, bi̱ ne xtí̱ mpɛnhui'ʉ yø 'yɛ̱c'ɛ̱i̱ mi̱ 'bʉp'ʉ. Pɛ gä su̱ 'mø mi̱ nu̱, porque ɛ̱mbi̱ ngue hi̱mma̱ jua̱ni̱ ra̱ 'yɛ̱c'ɛ̱i̱ na̱ ra̱ Saulo. ");
INSERT INTO otnNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nu̱na̱ ra̱ Bernabé go bi zixra̱ Saulo p'ʉ 'bʉhyø representante ra̱ Cristo na̱. Go bi̱ ma̱nna̱ p'ʉya ha bi̱ njap'ʉ i̱ nu̱ ra̱ Saulo p'ʉ ja ra̱ 'yu̱ na̱ ra̱ Hmu̱ Jesús. Bi̱ ma̱ ha bi̱ nja ngue bi zofo. Gue'a̱ i hya̱ ra̱ ts'ɛdi ra̱ Saulo ngue bi̱ ma̱mp'ʉ Damasco hanja na̱ ra̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nu̱p'ʉ ja ra̱ hni̱ni̱ Jerusalén, 'dap'ʉ 'yohʉ'ʉ yø representante na̱ ra̱ Saulo. Nu̱p'ʉ ni̱ ma yø representante, ja ni̱ map'ʉ ra̱ Saulo. ");
INSERT INTO otnNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nu̱na̱ ra̱ Saulo bi hya̱ ra̱ ts'ɛdi ngue mma̱ hanja na̱ ra̱ Hmu̱ Jesús. Di̱ nju̱'ma̱hya̱ 'mø ya̱ui ya yø judío ga̱ ya̱ ra̱ hya̱ ngue ra̱ griego. Pɛ nu̱ya̱ yø judío ya, i̱ nne da̱ hyo ra̱ Saulo. ");
INSERT INTO otnNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mi̱ mmɛ̱ya yø 'yɛ̱c'ɛ̱i̱ p'ʉya ngue nne da̱ tho ra̱ Saulo. Bi zixpʉya, i̱ ma Cesarea ja bi thøp'ʉ. Ya bi̱ masɛ p'ʉ ja ra̱ hni̱ni̱ Tarso na̱ ra̱ Saulo p'ʉya. ");
INSERT INTO otnNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ya 'bʉmma̱nho gätho yø 'yɛ̱c'ɛ̱i̱ rá̱ m'mʉp'ʉ ja ra̱ häi Judea, da̱ guep'ʉ Galilea, da̱ guep'ʉ Samaria. Ma̱n'na ni̱ hya̱dra̱ ts'ɛdi'ʉ rá̱ m'mʉp'ʉ. I 'bʉi ngue su̱prá̱ xu̱di̱ Oja̱, 'nɛ̱ fäxra̱ Espíritu Santo. Ma̱n'na ma̱ni̱ 'yɛ̱c'ɛ̱i̱tho mi̱'da yø ja̱'i̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bi̱ n'yo ra̱ Bɛdu ngue bi zɛngua yø cu̱. Xquet'a̱ bi̱ ma bí zɛngua'ʉ yø 'yɛ̱c'ɛ̱i̱ rá̱ m'mʉp'ʉ ja ra̱ hni̱ni̱ Lida. ");
INSERT INTO otnNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nu̱'a̱ ra̱ hni̱ni̱'a̱ p'ʉya, bi di̱mp'ʉ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Eneas. Ya nhya̱to jɛya mi̱ oxrá̱ t'ots'i, porque mi̱ tu̱dyø gua. ");
INSERT INTO otnNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nu̱na̱ ra̱ Bɛdu bi 'yɛ̱mbi̱: ―Ague Eneas, da̱ 'yøthe'i ra̱ Jesucristo ya. Da̱mi̱ nangui̱, pɛs'ni̱ fi̱di̱. Nu̱na̱ ra̱ därquɛ̱hi̱ 'bexpi̱ nangui̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nu̱'ʉ yø mmɛ̱ngu̱ Lida 'nɛ̱'ʉ yø mmɛ̱ngu̱ Sarón mi̱ nu̱ ngue bi zä ra̱ Eneas. Bi hyɛp'ʉ yø nyogui nt'ɛ̱c'ɛ̱i̱ p'ʉya, bi 'yɛ̱c'ɛ̱i̱ ra̱ Hmu̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nu̱p'ʉ ja ra̱ hni̱ni̱ Jope mi̱ 'bʉp'ʉ n'na ra̱ 'yɛ̱c'ɛ̱i̱ ngue ra̱ xisu ma̱ni̱ hu̱ ngue ra̱ Tabita. Ra̱ hya̱ ngue ra̱ griego p'ʉya, gui hu̱ti̱ ngue ra̱ Dorcas. Nu̱na̱ ra̱ xisu na̱, mɛ̱nte ra̱ pa bi̱ m'mʉi bi 'yøtra̱ nho, i fäxyø ja̱'i̱ hi̱n'yʉ te da̱ hyoni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mi̱ 'yɛ̱'a̱ n'na ra̱ pa p'ʉya, nu̱na̱ ra̱ Dorcas bi hyɛ̱nni̱, pɛ bi du̱ p'ʉya. Nu̱'mø mi̱ 'betra̱ ánima, bi 'bɛp'ʉ ja n'na ra̱ cuarto bí ja ma̱yá̱ ra̱ tøca̱ngu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nu̱p'ʉ ja ra̱ hni̱ni̱ Lida ja mi̱ du̱p'ʉ ra̱ Dorcas, querpʉtho bí ja ra̱ hni̱ni̱ Jope ma̱mbi 'bʉhra̱ Bɛdu. Nu̱'mø mi̱ ba̱hyø 'yɛ̱c'ɛ̱i̱ p'ʉya ngue bí 'bʉp'ʉ Jope ra̱ Bɛdu, n'na zihma̱ntho bi̱ mɛnhni̱ yo nc'ɛ̱i̱ ngue bá̱ si ra̱ Bɛdu. ");
INSERT INTO otnNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nu̱'mø mi̱ zømp'ʉ bí 'bʉhra̱ Bɛdu'ʉ yø nzite p'ʉya, 'bexpa̱ ɛ̱hra̱ Bɛdu. Mi̱ zøp'ʉ ja ra̱ ngu̱ ra̱ Bɛdu p'ʉya, bi ts'ixpʉ ja ra̱ cuarto ma̱ya̱ bí 'bɛnna̱ ánima. Xøgue di̱ mäs'yø 'danxu̱ p'ʉ 'bɛni̱ ngue zoni̱. Bi t'u̱tra̱ Bɛdu'ʉ yø tu̱hu̱ 'nɛ̱hyø vestido mi̱ ør'mø mi̱ 'bʉhra̱ Dorcas. ");
INSERT INTO otnNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nu̱na̱ ra̱ Bɛdu p'ʉya, bi xihyø ja̱'i̱ ngue gä da̱ bøn'a̱thi. Bi̱ nda̱ntyøhmu̱ p'ʉya, bi̱ mat'Oja̱. Mɛ̱nte hɛ̱tra̱ ánima na̱ ra̱ Bɛdu p'ʉya, bi 'yɛ̱mbi̱: ―Ague Tabita, da̱mi̱ nangui̱ ―bi 'yɛ̱mbi̱. Bi̱ nzø yø dä ra̱ ánima p'ʉya, bi hyɛ̱tra̱ Bɛdu, bi̱ nangui̱ bi̱ mi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nu̱na̱ ra̱ Bɛdu, bi bɛnnba̱ rá̱ 'yɛ ra̱ Dorcas ngue bi xots'i. Mi̱ xoxpʉya, bi̱ ma ma̱cʉt'i mbo yø 'yɛ̱c'ɛ̱i̱ conyø 'danxu̱ ngue bi däpi, pɛ ya i te. ");
INSERT INTO otnNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bi fa̱di̱ gä ra̱ hni̱ni̱ Jope na̱ ra̱ hya̱ na̱ p'ʉya. Ja̱na̱ngue xa̱ngu̱ yø ja̱'i̱ bi 'yɛ̱c'ɛ̱i̱ ra̱ Hmu̱ Jesús. ");
INSERT INTO otnNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nu̱na̱ ra̱ Bɛdu p'ʉya, ya'atho yø pa bá̱ m'mʉp'ʉ Jope ja rá̱ ngu̱ n'na ra̱ hyu̱xfani̱ xquet'a̱ ni̱ hu̱ ngue ra̱ Simu̱. ");
INSERT INTO otnNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nu̱p'ʉ ja ra̱ hni̱ni̱ Cesarea, mi̱ 'bʉp'ʉ n'na ra̱ n'yohʉ ni̱ hu̱ ngue ra̱ Nɛyo. Ma̱rá̱ capita na̱ ra̱ n'yohʉ na̱, rá̱ hmu̱ n'na 'bʉi yø soldado ni̱ hu̱ ngue ra̱ Italiano. ");
INSERT INTO otnNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nu̱na̱ ra̱ n'yohʉ na̱, gä tha̱nne Oja̱'ʉ 'bʉp'ʉ ja rá̱ ngu̱, 'nɛ̱ gä su̱prá̱ xu̱di̱ Oja̱. Xquet'a̱ xa̱ngu̱ ra̱ mɛ̱nyu̱ ma̱di̱ u̱ni̱ ngue fäxyø judío. 'Nɛ̱ za̱nt'a̱ mmat'Oja̱. ");
INSERT INTO otnNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","N'na ra̱ pa p'ʉya comma̱ hyu̱ nde, bi̱ mpä rá̱ nthandi̱ ra̱ Nɛyo tengu̱tho 'mø di 'ui̱. Bi̱ nu̱ xa̱nho ngue n'na rá̱ anxɛ Oja̱ bi yʉrbʉ ha 'bʉi, bi 'yɛ̱mbi̱: ―Ague Nɛyo ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Bi hyɛ̱tra̱ anxɛ ra̱ Nɛyo p'ʉya, pɛ bi̱ nsu̱. Bi 'yännbʉya, bi 'yɛ̱mbi̱: ―¿Tema̱ hya̱, grá̱ Hmu̱? Mi̱ da̱hra̱ anxɛ p'ʉya, bi 'yɛ̱mbi̱: ―I̱ nnu̱ ma̱nho Oja̱ ngue guí̱ mmat'Oja̱ 'nɛ̱ nnu̱ ma̱nho te guí øt'e ngue guí fäxyø ja̱'i̱ hi̱n'yʉ te da̱ hyoni̱. ");
INSERT INTO otnNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","A nu̱yá, da̱mi̱ 'yɛt'i to da̱ si ra̱ Simu̱ bí 'bʉ'a̱ Jope, nu̱na̱ ga̱ ts'ofo ngue i Bɛdu. ");
INSERT INTO otnNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nu̱na̱ ra̱ Bɛdu, 'bʉp'ʉ ja rá̱ ngu̱ ra̱ hyu̱xfani̱ nu̱na̱ xquet'a̱ i Simu̱. I ja rá̱ ngu̱ p'ʉ ja rá̱ nnengui ra̱ ja̱the. Nu̱na̱ go da̱ xi'i te 'bɛ'a̱ ja ngue guí 'yø'na̱ ―bi 'yɛ̱mbi̱. ");
INSERT INTO otnNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mi̱ ma ra̱ anxɛ p'ʉya, nu̱na̱ ra̱ Nɛyo bi zonhni̱ yoho yø mɛfi 'nɛ̱ n'na ra̱ soldado. Nu̱na̱ ra̱ soldado, rá̱ n'youi ra̱ Nɛyo ngue xquet'a̱ 'nɛ̱hna̱ mi̱ tha̱nne Oja̱ na̱. ");
INSERT INTO otnNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bi xifi te xi̱ nu̱ p'ʉya. M'mɛfa p'ʉya, bi̱ mɛnhyø nzite p'ʉ ja ra̱ hni̱ni̱ Jope. ");
INSERT INTO otnNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mi̱ hyaxpʉya, ya ni̱ 'yo ra̱ 'yu̱ yø nzite, ni̱ ma da̱ zømp'ʉ ja ra̱ hni̱ni̱. Comma̱ hu̱xyadi p'ʉya. Nu̱na̱ ra̱ Bɛdu bi̱ nexma̱ xøts'e ra̱ ngu̱ ngue da̱ m