﻿USE sofia;
DROP TABLE IF EXISTS sofia.otmNT_vpl;
CREATE TABLE otmNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES otmNT_vpl WRITE;
INSERT INTO otmNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Guehna n'da ra søcuą i ja ua im ma to'o yʉ́ ngʉrpa bøta ra Jesucristo. Nu'a n'da ra Abraham nɛ man'da ra David nɛ xʉn ngu mi'da gätho yʉ́ ngʉrpa bombøta ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nu ra Abraham bim 'bʉ a n'da rá ts'ʉnt'ʉ ngue ra Isaac. Nu ra Isaac xø bim 'bʉh rá ts'ʉnt'ʉ, ra Jacob a. Nɛ nu ra Jacob xø bim 'bʉh yʉ́ ts'ʉnt'ʉ. Nu'a n'da ra Judá a nɛ'ʉ yʉ́n 'yohʉ. Nɛ gue'ʉ bi xąndgahe ʉ dyʉ ją'i israelgähe, dyʉ judíohe. ");
INSERT INTO otmNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nɛ nu ra Judá bim 'bʉ i yoho yʉ́ ts'ʉnt'ʉ. N'dam'bʉi thoho yoho. Nu'a n'da ra Fares. Nu'a man'da ra Zara. Nɛ nu'a rá mbe ʉ rá thuhu ra Tamar a. Nɛ nu ra Fares bim 'bʉ a n'da rá ts'ʉnt'ʉ ngue ra Esrom. Nɛ nu ra Esrom, xø bim 'bʉh rá ts'ʉnt'ʉ, ra Aram a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Nɛ nu ra Aram bim 'bʉ a n'da rá ts'ʉnt'ʉ ngue ra Aminadab. Nɛ nu ra Aminadab, xø bim 'bʉ a n'da rá ts'ʉnt'ʉ, ra Naason a. Nɛ nu ra Naason, xø bim 'bʉh rá ts'ʉnt'ʉ, ra Salmón a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nu ra Salmón xø bim 'bʉh rá ts'ʉnt'ʉ, ra Booz a. Nɛ nu ra Booz, rá mbe a ra Rahab. Nɛ nu ra Booz xø bim 'bʉh rá ts'ʉnt'ʉ, ra Obed a. Nɛ nu rá mbe ra Obed, ra Rut a. Nɛ nu ra Obed xø bim 'bʉh rá ts'ʉnt'ʉ, ra Isaí a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nɛ nu ra Isaí xø bim 'bʉh rá ts'ʉnt'ʉ, ra David a. Nɛ nu ra David gue'a bin ts'ʉt'abi a. Nɛ nu ra David xø bim 'bʉh rá ts'ʉnt'ʉ, ra Salomón a. Nɛ nu rá mbe ra Salomón, gue'a xí du rá ndø rá thuhu Urías. ");
INSERT INTO otmNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Nɛ nu ra Salomón xø bim 'bʉh rá ts'ʉnt'ʉ, ra Roboam a. Nɛ nu ra Roboam xø bim 'bʉh rá ts'ʉnt'ʉ, ra Abías a. Nɛ nu ra Abías xø bim 'bʉh rá ts'ʉnt'ʉ, ra Asa a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nɛ nu ra Asa xø bim 'bʉh rá ts'ʉnt'ʉ, ra Josafat a. Nɛ nu ra Josafat xø bim 'bʉh rá ts'ʉnt'ʉ, ra Joram a. Nɛ nu ra Joram xø bim 'bʉh rá ts'ʉnt'ʉ, ra Uzías a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Nɛ nu ra Uzías xø bim 'bʉh rá ts'ʉnt'ʉ, ra Jotam a. Nɛ nu ra Jotam xø bim 'bʉh rá ts'ʉnt'ʉ, ra Acaz a. Nɛ nu ra Acaz, xø bim 'bʉh rá ts'ʉnt'ʉ, ra Ezequías a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Nɛ nu ra Ezequías xø bim 'bʉh rá ts'ʉnt'ʉ, ra Manasés a. Nɛ nu ra Manasés, xø bim 'bʉh rá ts'ʉnt'ʉ, ra Amón a. Nɛ nu ra Amón, xø bim 'bʉh rá ts'ʉnt'ʉ, ra Josías a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nɛ nu ra Josías, xø bim 'bʉh rá ts'ʉnt'ʉ ra Jeconías a, nɛ'ʉ yʉ́n 'yohʉ. Nɛ gue'ʉ yʉ pa bi ts'ix ʉ ma mi israelhe dyʉ judíohe bʉ ja ra häi Babilonia. Bi zix yʉ́n sʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nɛ nubʉya nu ra Jeconías bin xąnd bʉ ra häi Babilonia a, nɛ'a rá ts'ʉnt'ʉ ngue ra Salatiel. Nu ra Salatiel xø bim 'bʉh rá ts'ʉnt'ʉ, ra Zorobabel a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nɛ nu ra Zorobabel xø bim 'bʉh rá ts'ʉnt'ʉ ra Abiud a. Nɛ nu ra Abiud xø bim 'bʉh rá ts'ʉnt'ʉ, ra Eliaquim a. Nɛ nu ra Eliaquim xø bim 'bʉh rá ts'ʉnt'ʉ, ra Azor a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Nɛ nu ra Azor xø bim 'bʉh rá ts'ʉnt'ʉ, ra Sadoc a. Nɛ nu ra Sadoc xø bim 'bʉh rá ts'ʉnt'ʉ, ra Aquim a. Nɛ nu ra Aquim xø bim 'bʉh rá ts'ʉnt'ʉ, ra Eliud a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Nɛ nu ra Eliud xø bim 'bʉh rá ts'ʉnt'ʉ, ra Eleazar a. Nɛ nu ra Eleazar xø bim 'bʉh rá ts'ʉnt'ʉ, ra Matán a. Nɛ nu ra Matán xø bim 'bʉh rá ts'ʉnt'ʉ, ra Jacob a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nɛ nu ra Jacob xø bim 'bʉh rá ts'ʉnt'ʉ, ra José a. Gue'a rá ndø ra María a. Nɛ gue'a rá mbe ra Jesús a, ngue ra Cristo a bʉya, rá thahni Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nɛ gue'ʉ gätho yʉ́m bombøta ra Jesucristo ʉ. Mbʉdi tho ra Abraham, ná 'dɛ'magoho a ra David. Nɛ xø bim 'bʉh mi 'dɛ'magoho yʉ́m bombøta nɛ gue'ʉ yʉ pa bi ts'ix pʉ Babilonia. Nɛ xø bim 'bʉh mi 'dɛ'magoho, ná 'dɛ'magoho a ra Cristo bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nɛ nu'bʉ mim 'bʉh ra Jesucristo, nu'a rá mbe ngue ra María bi 'yän'na ra José, nɛ ya in nde din thąt'ui, pɛ nu'bʉ hin ním 'bʉhmi, ya bi hnu ngue in hąt'ʉhni ra María, pɛgue bi nɛqui zɛhɛ rá t'ʉhni nangue rá Hogandąhi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nɛ nu ra José bʉya bi bɛ̨ni hanja bin hąt'ʉhni a ra María. Pɛgue ra hocją'i a ra José nɛ him mi nde di yąp'a ra María bʉ 'bʉh ra zɛ'mi pɛgue bi bɛ̨ni da hyɛtho. ");
INSERT INTO otmNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nɛ nu ra José, nu'bʉ ngubʉ mim bɛ̨ni, bi 'uį n'da ra t'į 'bʉ min ąpʉ rán ngunsɛ, bi nu rám 'bɛhni Oją bi 'yɛ̨mbi: ―Nu'i, hague José, rám bom'bɛto i ra David, xʉn ho 'bʉ gam 'bʉhmi a ra xisu, nguetho nu ra 'uɛre dim 'bʉi, dim 'bʉi nangue rá Hogandąhi Oją a. ");
INSERT INTO otmNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nɛ dim 'bʉ a n'da rá ts'ʉnt'ʉ ra María, gui xip rá thuhu ra Jesús. Nu'a ra Jesús nam bøni ngue da yąni gätho yʉ́ mijudíohʉ, yʉ israel, nangue yʉ́ ts'oqui ʉ, bi 'yɛ̨mp'a rám 'bɛhni Oją a ra José 'bʉ min ąha. ");
INSERT INTO otmNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nguetho maya'bʉ thoho bi zän Oją a ra María 'bʉ mi man'a ra pøngahyą ngue bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","N'da ra hmute ngue hin jąm'bʉ n'dandį bi zo a n'da ran 'yohʉ, nɛ din hąt'ʉhni. Nɛ nu'a rá t'ʉhni dim 'bʉi da t'ɛ̨mbi ra Emanuel, bi 'yɛ̨n'a ra pøngahyą maya'bʉ. Nɛ nu'a ra Emanuel in nde da ma: “Dí 'bʉhmbʉ Oją.” ");
INSERT INTO otmNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Janangue'a nu'bʉ mi hyax bʉya a ra José, bi 'yøt'e 'bɛ'a bi xi a rám 'bɛhni Oją, nɛ 'bex bi zin'a ra María. ");
INSERT INTO otmNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pɛ him 'bexque njuąntho bim 'bʉhmi, ja gue'bʉ bim 'bʉh rá ts'ʉnt'ʉ ra María. Nɛ nu ra José bʉya bi xih rá thuhu ra Jesús a ra t'ʉhni bim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nɛ nu ra Jesús bám 'bʉpʉ ra hnini Belén guepʉ ra häi Judea. Nɛ min ts'ʉt'abi bʉ ja a ra xɛqui a ra Herodes, nɛ mí ząm bʉ ra dąhnini Jerusalén. Nɛ bi zøm bʉ Jerusalén 'da yʉn 'yohʉ ngue yʉ́ 'bɛfi mí hand yʉ sø. Nɛ nu'ʉ bí nɛxpʉ mbɛ ní bøx ra hyadi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nɛ nu'bʉ mi zøm bʉ Jerusalén bi 'yän'dʉ 'bʉpʉ: ―Hapʉ i 'bʉcua a rá hmuts'ʉt'abi yʉ judío ja bim 'bʉi, bi 'yɛ̨n'ʉ. Nguetho dán nuhe n'da ra sø njąm'bʉ dá nuhe n'dandį. Nɛ gue'a ra hmɛpya bi 'yurcahe ngue ya bim 'bʉi, nɛ bá ɛ̨hmbe ya ga thąndehe a, bi 'yɛ̨n'ʉ bi nu ra sø. ");
INSERT INTO otmNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nɛ nu ra ts'ʉt'abi Herodes, nu'bʉ mi sifi 'bɛ'a bi man'ʉ yʉn 'yohʉ bi zøm bʉ, bi hyonya thoho nangue a ram hma ngue bim 'bʉh man'da ra ts'ʉt'abi. Nɛ gätho 'bʉpʉ Jerusalén bin su nguetho im bɛ̨ni: “Masque i ja 'bɛ'a din ja ya,” ɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nɛ nu'a ra ts'ʉt'abi Herodes bʉya bi zon'dʉ yʉ hmumbäją nɛ'ʉ yʉ xänbate niją, bi 'yänni hapʉ im man yʉ́ søcuą yʉ pøngahyą dim 'bʉ a rá hmuts'ʉt'abi yʉ judío, ngue ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nɛ nu'ʉ bi 'yɛ̨mbi: ―Guepʉ Belén ra häi Judea dim 'bʉi, nguetho gue'a bi man ra pøngahyą 'bʉ maya'bʉ 'bʉ mi hma ngue, ");
INSERT INTO otmNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nu ra hnini Belén bʉ ra häi Judea, ra t'ʉhnini a, pɛgue din ja tengu n'da ra dąhnini nguetho guepʉ dim 'bʉpʉ ra Hmu di jamansu ma t'ʉhni yʉ ją'i israel, i ɛ̨n Oją, bi 'yɛ̨n'a ra pøngahyą maya'bʉ, bi 'yɛ̨n ʉ yʉ mbäją. ");
INSERT INTO otmNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nu'bʉ mi mbenc'ʉ yʉ mbäją nɛ yʉ xänbate niją, nu ra Herodes bi zon'dʉ bi nu ra sø, pɛ njon mi ndepe da nu 'bʉ mam bá ts'i. Nɛ nu'bʉ mam bá ts'i bʉ 'bʉh ra Herodes, bi 'yänni: ―Ma njąm'bʉ bi nɛqui a ra sø, bi t'ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nɛ nu'bʉ mi xifi, nu ra Herodes bʉya bi 'yɛ̨mp'ʉ bi nu ra sø: ―Ní mbähä bʉ Belén, gui hyomhbʉ hapʉ bim 'bʉ a ra 'uɛre, nɛ nu'bʉ gá tįmhbʉ hapʉ i 'bʉi, gua ɛ̨hmbʉ gui xijʉ, nɛcä ga mba ga thąnde a, bi t'ɛ̨mp'ʉ bi nu ra sø. Pɛ hinga gue'a mim bɛ̨n a. ");
INSERT INTO otmNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nɛ nu'ʉ yʉn 'yohʉ bʉya bi mba da hyoni hapʉ bim 'bʉ a ra 'uɛre, nɛ xø bi nɛqui mahøn'a a ra sø xpí nu bʉ yʉ́ häi. Nɛ i 'bɛt'o a. Nɛ nu'bʉ mi zøm bʉ Belén, bin säya a ra sø bʉ din 'yɛ̨'t'ui a ra ngu nubʉ mí 'bʉ a ra 'uɛre. ");
INSERT INTO otmNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nɛ nu'ʉ yʉn 'yohʉ 'bʉ mí nu bin säya a ra sø, bin johya yʉ́ mbʉi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nɛ bi yʉt'ambo, bi nu a ra 'uɛre nɛ ra María rá mbe. Nɛ bin dąnyahmu, bi dąnde a ra 'uɛre. Nɛ 'bexque bi xo't' yʉ́ 'bɛni bá tu, nɛ bi un yʉn t'unni a ra 'uɛre ngue ɛ̨mmɛ xʉn ngu di muui. Bi unna n'da ra oro, nɛ rá ndɛga ra za bi unni, nɛ n'da ra 'yɛ̨thi yʉman'u. ");
INSERT INTO otmNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nɛ nu'bʉ min ą ʉ yʉn 'yohʉ ngue bi nu ra sø, Oją bi 'yut'a n'da ra t'į ngue nu'bʉ bi mbengui hin dí mba bʉ bí 'bʉh ra Herodes. Janangue'a n'danni n'da ra 'yu bi hyąx 'bʉ mi mbeng bʉ yʉ́ häi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nɛ nu'bʉ mí mba ʉ yʉn 'yohʉ bʉya, n'da rám 'bɛhni Oją bi xi a ra José 'bʉ min ąha: ―Dami ndants'i. Dami six'a ra 'uɛre nɛ a rá mbe. Gui' dahmbʉ, ni mbähä bʉ ra häi Egipto nɛ gam 'bʉhmbʉ bʉ 'da yʉ pa. Nɛ him 'bex gua pengüi, jague'bʉ dá xi'aui gua pengüi. Nguetho nu ra Herodes da hyon'a ra 'uɛre, nɛ nu'bʉ da dįni da hyo, bi 'yɛ̨mp'a rám 'bɛhni Oją a ra José. ");
INSERT INTO otmNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nɛ 'bex bi ndanc'a ra José a ra xui a. Bi zix a ra María nɛ rá t'ʉhni, nɛ bi mba bʉ ra häi Egipto. Him bi dø'mi 'bɛ da hyats'i. ");
INSERT INTO otmNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nɛ bám 'bʉpʉ Egipto jague'bʉ mi du ra Herodes, ja bá penc'ʉ bʉya. Nɛ bin ja 'bɛ'a bi man Oją maya'bʉ, bi 'yɛ̨na: “Gan zohn'na ma t'ʉhni bʉ Egipto,” i ɛ̨n Oją, bi 'yɛ̨n'a rá pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nɛ nu ra Herodes ɛ̨mmɛ bin cuɛ ngue ya bi thät'i, nguetho nu'ʉ yʉn 'yohʉ bi nu ra sø hin í mbeng bʉ 'bʉ mi dįn'a ra t'ʉhni. Janangue'a bi mbɛn'ndʉ yʉ́ dofʉi ngue da hyo yʉ 'uɛre bʉ Belén nɛ yʉ hnini i hänbʉ. Nɛ gätho ʉ yʉ t'ʉhni hinga na pɛ'ts'a nyojɛya gätho bi hyo. Nguetho bi man ʉ yʉn 'yohʉ, ya mbɛ má nyojɛya ya bi nɛqui a ra sø. ");
INSERT INTO otmNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nɛ nu'a bin ja, maya'bʉ thoho bi man a ra pøngahyą ra Jeremías ngue ngubʉ din ja 'bʉ mi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bin ja n'da ran ts'oni bʉ ra hnini Ramá, nts'ɛdi bi mbah yʉ́ xisu yʉ judío, bin zoni nɛ him bi 'yø a bi xi ʉ bi hyurpa yʉ́ mbʉi, nguetho ɛ̨mmɛ im bɛ̨n'ʉ yʉ́ t'ʉhni bi thopi, bi 'yɛ̨n'a ra Jeremías 'bʉ maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nɛ nu'bʉ mi du ra Herodes bʉya bi 'uį man'da rám 'bɛhni Oją a ra José 'bʉ min xui, bʉ ra häi Egipto. ");
INSERT INTO otmNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Dami ndants'i. Dami six a ra t'ʉhni nɛ a rá mbe. Dami penjʉ bʉ ra häi Israel, nguetho ya bi du ʉ mí nde xtá hyo a ra t'ʉhni, bi t'ɛ̨mp'a ra José. ");
INSERT INTO otmNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nɛ nu ra José bʉya bi hyąx ra 'yu ní mba bʉ ra häi Israel 'bʉ mi hyats'i, nɛ bi zix a ra t'ʉhni nɛ'a rá mbe ra t'ʉhni bi zits'i, ɛ̨na xtán zøm bʉ ra xɛqui Judea. ");
INSERT INTO otmNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pɛ nu'bʉ mí 'yø a ra José ngue in ts'ʉt'abi bʉ ra Arquelao, bi zu da zøm bʉ mahøn'a, nguetho nu ra Arquelao rá ts'ʉnt'ʉ ra Herodes a. Nɛ'a xí 'uį xø bi bɛ̨m bʉya, ngue'a hin da mba bʉ Judea. Janangue'a í mba bʉ ra xɛqui Galilea bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nɛ bi mba dim 'bʉpʉ ra hnini Nazaret. Janangue'a bin ja 'bɛ'a xmán t'o't'i bʉ ja yʉ́ søcuą yʉ́ pøngahyą Oją, gue nu ra Jesús da t'ɛ̨mbi ra mɛngu Nazaret. ");
INSERT INTO otmNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Nɛ nubʉya nu ra Xuua Nxixyą bi dʉ'mi bi xih yʉ ją'i nɛ bi 'yɛ̨na: ―Dami päh nin 'yomfɛ̨nihʉ nguetho ya mi ts'ʉtho di manda ua rá ts'ɛdi Oją, bi t'ɛ̨mb yʉ ją'i. Nɛ mí 'bʉpʉ ja ra dąpo bʉ ra xɛqui Judea 'bʉ min yąhʉ yʉ ją'i a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nɛ nu a ra Xuua gue'a bi man ra pøngahyą Isaías maya'bʉ ngue bi ma ba ɛ̨hɛ, 'bʉ mi 'yɛ̨na: N'da ra ją'i din yą bʉ ja ra dąpo nɛ da 'yɛ̨na: “Damin sähʉ ga simhbʉ ra Hmu mi ts'ʉtho da zøcua, dami hoc ni mbʉihʉ ga tømhbʉ xʉn ho,” da 'yɛ̨na, bi 'yɛ̨n a ra Isaías maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nu yʉ́ he ra Xuua ám 'be yʉ́ xingu yʉ camello, nɛ midín gʉt'ʉ yʉ xifani, nɛ mi sa yʉ t'ąxi nɛ mi si yʉ t'afi t'asa dąpo. ");
INSERT INTO otmNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nɛ nu'bʉ mi dʉ'mi bi man rám hman a ra Xuua, bi mba ʉ yʉ mɛngu bʉ Jerusalén, bi zøm bʉ 'bʉh ra Xuua, nɛ yʉ mɛngu bʉ ra xɛqui Judea, nɛ'ʉ mi 'bʉpʉ hänbʉ ra dąthe Jordán, ngue nde da 'yøde 'bɛ'a da man'a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nɛ nu ra Xuua bi xixyąba ʉ to'o bi 'yømanho 'bɛ'a bi ma, nɛ bin juąnni nangue yʉ́ ts'oqui. Nɛ xʉn ngu bi xixyąba bʉ ja ra dąthe Jordán. ");
INSERT INTO otmNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nɛ xʉn ngu ma ngʉrpihe dyʉ israelhe, dyʉ judíohe, bi zøm bʉ mí 'bäh ra Xuua ɛ̨na din xixyą ʉ. Nu'ʉ 'da yʉ fariseo ʉ, nɛ ʉ 'da yʉ saduceo ʉ. Nɛ nu ra Xuua bʉya bi 'yɛ̨mp'ʉ: ―Nu'ahʉ tengu'bʉ ni mɛnihʉ yʉ pozʉ nguetho gyʉ tontohʉ. To'o bi xi ahʉ gua ɛ̨hmbʉ ua ngue gua 'dahmbʉ bʉ ja ran ʉnbi xʉn ʉ tho, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ha guím bɛ̨mhbʉ da zä gan yąmhbʉ 'bʉ hin gui 'yøthʉ a rán säui ʉ to'o bi päh yʉ́ mbʉi, bi t'ɛ̨mp'ʉ ma ngʉrpihe. ");
INSERT INTO otmNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pɛ hin din ja ran 'yɛ̨ts'i ni mbʉihʉ ngue gui 'yɛ̨mhbʉ: “Nugähe yʉ́ t'ʉhnigähe ra Abraham, ya hin gan nuhe ran ʉnbi,” hingui sä gui 'yɛ̨mhbʉ, nguetho nɛhya yʉ do i 'bongua da zä din ją'i ngue da 'yɛ̨mbi yʉ́ t'ʉhni ra Abraham 'bʉ gue'a da nde Oją da 'yøt'e, bi 'yɛ̨n'a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nɛ nu'a ra aza ya mahoqui xʉn ho ngue da 'yɛx ʉ yʉ za hingui ho yʉ́n dät'ä, nɛ da thøspʉ ja ra sibi din zø. Nɛ nu'ahʉ tengu'bʉ gyʉ zahʉ ngue hingui ho yʉ́n dät'ä, bi t'ɛ̨mp'ʉ yʉ fariseo nɛ yʉ saduceo. ");
INSERT INTO otmNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nɛ xø bi xi ʉ mi'da: ―Nugä dí xixyą ahʉ nangue ra dehe 'bʉ ya gá päh ni mbʉihʉ, pɛ nu'a man'da ba ɛ̨hɛ, di hoc'ahʉ nangue rá Hogandąhi Oją tengu'bʉ n'da ra sibi. Nɛ nu'a, man'da i ja rá ts'ɛdi xinda guecä. Hin dí sʉcä tengu a, i ɛ̨n a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nɛ da 'yøt' ran juąnbi, tengutho 'bʉ i pa ma hoqui yʉ jʉ, ngue n'danni i pa m'bɛ'ts'i ʉ yʉ jʉ nɛ n'danni da t'ɛn ʉ yʉ́ häi. Nɛ nu ʉ yʉ́ häi da t'upʉ ja ra sibi njąm'bʉ i huɛ̨t'i, bi 'yɛ̨mb yʉ ją'i a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nɛ nubʉya bi nɛxpʉ ra häi Galilea ra Jesús, bi zøm bʉ ja ra dąthe Jordán guepʉ ja ra dąpo bí 'bʉh ra Xuua. Bi zøm bʉ ngue bi nde din xixyą a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pɛ nu ra Xuua him mi ndehma di xixyąbi ra Jesús, nɛ bi 'yɛ̨mbi: ―Pɛ nu'i guí ɛ̨na ga xixyą i, pɛ go man sä'be go gui xixyągui, bi 'yɛ̨n'a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","―Pɛ nuya xʉn ho 'bʉ gui xixyągui, nguetho i jatho ga øthʉ 'bɛ'a bi man Oją, bi 'yɛ̨n'a ra Jesús. ―Da nde 'bʉ, bi 'yɛ̨n'a ra Xuua bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nɛ nu'bʉ mi gua a bin xixyą ra Jesús nɛ bi bøx bʉ ja ra dehe, 'bex bi nu ngue bi xoh mahɛ̨ts'i, nɛ bi nu bá cąh rá Hogandąhi Oją tengu n'da ra t'azʉ, bi zøpʉ mí 'bä a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nɛ 'bex bi t'ø a n'da ra nde bí 'yɛ̨h mahɛ̨ts'i, bi 'yɛ̨na: ―Nuna guehna ma Ts'ʉnt'ʉgä na, ngue ɛ̨mmɛ dídi huɛ̨cä nɛ dí numanho, bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nɛ nu rá Hogandąhi Oją bʉya 'bex bi zixpʉ ja ra dąpo, in ndepe da mba nts'ä a ra Jesús nangue ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nɛ nyote pa nɛ nyote nxui bim 'bʉpʉ ja ra dąpo, nɛ him bin sihmɛ, nɛ ɛ̨mmɛ bin tumanthuhu maha. ");
INSERT INTO otmNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nɛ nubʉya, bi zøm bʉ a ra zįthu ngue da zäp rá mbʉi ra Jesús. Nɛ bi 'yɛ̨mbi: ―Nu'bʉ majuąni rá Ts'ʉnt'ʉ i Oją, dami japi dim hmɛ yʉ do i 'bongua nɛ gui si, bi 'yɛ̨n'a ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nu ra Jesús bi dąti: ―Hin ga øt'ä a, bi 'yɛ̨na. Nguetho mán t'o't'i bʉ ja rám hman Oją, hinga hønt'a ra hmɛ dám 'bʉh yʉ ją'i pɛ nɛ a gätho i ma Oją, bi t'ɛ̨mp'a ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nu ra zįthu xø bi zixpʉ Jerusalén a ra Jesús, nɛ bi 'yɛ̨xpʉ magąts'i rá 'bet'e ra dąniją. ");
INSERT INTO otmNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nɛ bi 'yɛ̨mbi: ―Nu'bʉ majuąni gue'e rá Ts'ʉnt'ʉ i Oją, damin säqui nɛ gui so nʉ häi, Nɛ Oją ba pɛhn yʉ́m 'bɛhni mahɛ̨ts'i ngue da mbäx'i'i nɛ da bɛnt'i i, nɛ hin hapʉ gui 'uaqui nangue yʉ do, tengutho im mam bʉ ja rám hman Oją, bi 'yɛ̨n'a ra zįthu, bi t'ɛ̨mp'a ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nu ra Jesús bi 'yɛ̨na: ―Hąha, gue'a i hmam bʉ, pɛ nɛ a i hmam bʉ, ngue “Nu Oją ma Hmuhʉ njongui sä da zä a ngue da bą 'bʉ majuąni da 'yøt'a im man'a,” bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nɛ xø man'dandį bʉya, bi zix mahøn'a ra zįthu a ra Jesús bʉ rá nyą n'da ra t'øhø xʉn hɛ̨ts'i, nɛ bi 'yuti gätho na ndoho ra ximhäi nɛ gätho 'bɛ'a xʉn ho i ja bʉ ja yʉ hnini. ");
INSERT INTO otmNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nɛ bi 'yɛ̨mbi: ―Gätho ga 'da a ya 'bɛ'a dá ut'i i 'bʉ gan dąnyahmu gui thąndegui, bi t'ɛ̨mp'a ra Jesús, bi 'yɛ̨n'a ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nɛ bi dąh mahøn'a ra Jesús, bi 'yɛ̨mbi: ―Nu'i grá zįthu, dami 'dagui nanguecä, nguetho nu rám hman Oją i ɛ̨na: “Hønt'a Oją ra Hmu ga thąndehʉ nɛ ga ørpahʉ rá 'bɛfi a,” bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nɛ nubʉya bi 'da'a ra zįthu bʉ 'bʉh ra Jesús, nɛ bá ɛ̨h yʉ́m 'bɛhni Oją bi zøpʉ mí 'bʉ a ra Jesús bʉ dąpo nɛ bi 'uįn a. ");
INSERT INTO otmNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nɛ bi bøm bʉ ja ra dąpo a ra Jesús bʉya. Nɛ nu'bʉ mí bøm bʉ, bi 'yøde ngue bi jot'a fädi ra Xuua nxixyą. Janangue'a bi mbengda bʉ ra häi Galilea. Guepʉ ra hnini Nazaret bim 'bʉpʉ mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pɛ hinga nya'a bim 'bʉpʉ nɛ bi mba bʉ ra hnini Capernaum, nubʉ ra ndendądehe guepʉ ra xɛqui yʉ́ häi mam bombøtahe ra Zabulón nɛ mam bombøtahe ra Neftalí. ");
INSERT INTO otmNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","15","Nu'bʉ mi zøm bʉ a ra Jesús bin ja 'bɛ'a bi 'yo't'a ra pøngahyą Isaías maya'bʉ ngue din ja bʉ ra häi Zabulón nɛ ra häi Neftalí, i hänbʉ ra dądehe, 'danguadi ra dąthe Jordán, ngue nɛ a i t'ɛ̨mbi Galilea, guepʉ 'bʉ ʉ i thąnde yʉ́ ojązɛhɛ. Nɛ bi 'yɛ̨n'a ra pøngahyą ngue: ");
INSERT INTO otmNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nu yʉ ją'i mi 'bʉpʉ tengu'bʉ i bʉpʉ ja ra 'bɛxui, nɛ i ja bʉ ran dąte, pɛ nuya bi nɛqui n'da ran nɛqui ngue di yot'i, bi 'yɛ̨n'a ra Isaías 'bʉ maya'bʉ. Nɛ gue'a bin ja 'bʉ mi zøm bʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nɛ nu ra Jesús bi dʉ'mi bi mam bʉ rám hma nɛ bi 'yɛ̨na: ―Dami päh nin 'yomfɛ̨nihʉ nangue yʉ ts'oqui, ngue da zä di manda ua rá ts'ɛdi Oją bi zøcua guí 'bʉhmbʉ, bi 'yɛ̨mb yʉ ją'i a ra Jesús 'bʉ mim 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nɛ n'da ra pa mí 'yo bʉ ja ra ndendądehe a ra Jesús nubʉ ra häi Galilea, nɛ bi nu yoho yʉn 'yohʉ din 'yohʉ zɛhɛ ʉ. Nu'a n'da ra Simón, gue'a ra Pedro a. Nɛ nu man'da ra Andrés. Nɛ nu'ʉ yʉ mbahuą ʉ, nɛ mi ɛnxit'ą bʉ ja ra dądehe. ");
INSERT INTO otmNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Ba tɛngaui, gui xihmbʉ yʉ ją'i da 'yɛ̨c'yɛigui, tengu thoho bʉ gní thɛui yʉ huą guí øt'ui, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nɛ 'bex bi hyɛpʉ yʉ́ xit'ą nɛ bi dɛn'na ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nɛ bi thopʉya bin 'yo mi ts'ʉ a ra Jesús, nɛ bi nu mi yoho yʉn 'yohʉ din 'yohʉ zɛhɛ ʉ, nɛ nu n'da ra Jacobo, nɛ nu man'da ra Xuua, gätho yoho yʉ́ ts'ʉnt'ʉ ra Zebedeo ʉ. Nɛ mín 'yohʉ a rá ta mi hu bʉ 'bɛn yʉ́ mbosa, mí 'uɛt yʉ́ xit'ą. Nɛ xø bi xi ʉ da dɛnni mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nɛ 'bex bi zopʉ rá ta nɛ'ʉ yʉ́ mbosa, 'bex bi dɛn'na ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nɛ nu ra Jesús mí 'yo gätho ra häi Galilea nɛ mí xänba ʉ yʉ ją'i bʉ ja yʉ niją nɛ bi ma 'bɛpʉ dí manda ua rá ts'ɛdi Oją. Nɛ midí hoc yʉ hyɛ̨nni ngue 'bɛ'a gä ní gɛ̨hɛ mí hɛ̨mp'a n'da ngu n'da. ");
INSERT INTO otmNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nɛ gätho yʉ ją'i bʉ ra xɛqui Siria bi 'yøde 'bɛ'a øt ra Jesús, nɛ bá thunba ʉ yʉ hyɛ̨nni ngue 'dahma 'dan'yo yʉn ʉ mí hɛ̨mbi nɛ'ʉ mín 'yohʉ yʉ zįthu, nɛ'ʉ ząnt'a mi sändąte 'da yʉ ora, nɛ'ʉ xí ts'a rá ją'i, nɛ gätho bi hoc'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nɛ xʉn ngu yʉ ją'i bi dɛn'na ra Jesús. Mín numanho da dɛnthoho yʉ ją'i nangue 'bɛ'a bi 'yøt'e. Nu'ʉ 'da yʉ mɛngu bʉ ra xɛqui Galilea, nɛ ʉ 'da yʉ mɛngu bʉ ra xɛqui Decápolis, nɛ'ʉ 'da mí 'bʉpʉ Judea, nɛ'ʉ 'da mí 'bʉpʉ 'danguadi ra dąthe Jordán, nɛ'ʉ 'da mí 'bʉpʉ ra hnini Jerusalén. Gätho bi zøm bʉ mi 'bʉ a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nɛ nu ra Jesús 'bʉ mi nu yʉ ją'i ɛ̨mmɛ xʉn ngu bi zøpʉ, nɛ bi ndex bʉ ja ra nyuni nɛ mi hupʉ. Nɛ'ʉ yʉ́ xädi bʉya bi zøm bʉ mí hudi, 'darpʉ mi huhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nɛ bi xänba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nɛ bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús: ―Nu'ʉ to'o pąsɛ hingui ho yʉ́ mbʉi bʉ na nu Oją nɛ da hyon Oją di zɛdi, nu Oją da zimanho bʉ di manda rá ts'ɛdi, janangue'a mająpi ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nɛ nu'ʉ tu yʉ́ mbʉi, Oją da hyurpa yʉ́ mbʉi, janangue'a mająpi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nɛ nu'ʉ im bɛ̨ni i cosɛ häi, da hyąn a ra hogahäi bi man Oją di unni, janangue'a mająpi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nɛ nu'ʉ i humbi da 'yøt' ran ho, Oją di japi da 'yøt'e xʉn ho, janangue'a mająpi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nɛ nu'ʉ di huɛ̨c yʉ́ miją'ihʉ, xin di huɛ̨c Oją ʉ, janangue'a mająpi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nɛ nu'ʉ n'dat'a im bɛ̨ni, dim 'bʉhmbʉ Oją ʉ, janangue'a mająpi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nɛ nu'ʉ øt' ran hocpate, nu Oją da 'yɛ̨mbi yʉ́ t'ʉhni ʉ, janangue'a mająpi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nɛ nu'ʉ i nu ran ʉnbi nangue ran ho i øt'e, da yʉrpʉ di manda rá ts'ɛdi Oją ʉ, janangue'a mająpi ʉ, i ɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nɛ gan johyahʉ 'bʉ i ʉ'ts'ahʉ yʉ ją'i nɛ i then'nahʉ nɛ i xi ahʉ yʉ fɛhni 'bʉ guí tɛngahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nɛ da hyu ni mbʉihʉ, gan johyahʉ, guim bɛ̨mhbʉ ngue 'dat'a ran ʉnbi guín nuhʉ ʉ yʉ pøngahyą mam 'bɛt'o, nɛ i ja 'bɛ'a din 'da ahʉ ngue am 'bɛ'ts'i mahɛ̨ts'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","―Nu'ahʉ gyʉ ųhʉ hapʉ 'bʉh yʉ ją'i, nguetho nu'a ra ų di hoqui 'bɛ'a i pa njapi, nɛ ngutho ahʉ guídí hojʉ yʉ ją'i, i ɛ̨n a ra Jesús. Pɛ nu'bʉ bi 'bɛh rá ts'ɛdi ra ų, ya hin'yʉ 'bɛ'a sä dí hoqui, janangue da mba ma bʉnt'i thoho bʉ häi. Dami jamansuhʉ hin din ja bʉ gui 'yøthʉ tengu a, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nɛ bi 'yɛ̨n'a ra Jesús: ―Nu ahʉ gyʉn nɛquihʉ bʉ 'bʉh yʉ ją'i, bi 'yɛ̨mp'ʉ yʉ́ xädi. Dami jafʉ da hnu a ran nɛqui. Tengu n'da ra hnini i ja bʉ ja rá nyą ra t'øhø, am 'batho xʉn ho ngue hin'yʉ 'bɛ'a i juti. ");
INSERT INTO otmNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ngutho n'da ra sibi, hingui sä da mba ma cʉ't'i bʉ ja ra huada 'bʉ da mba ma søque, i jatho da t'ɛ̨xpʉ m'batho, janangue'a di yot'i gätho 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nɛ ngutho gui 'yøthʉ ngue tengu'bʉ gyʉ sibihʉ ɛ̨mmɛ di hyärpʉ i 'bʉh yʉ ją'i. Janangue'a da hnut'ahʉ xʉn ho nin t'øt'ehʉ, nɛ ʉ da 'yɛ̨spa Oją ma Tahʉ 'bʉpʉ mahɛ̨ts'i ʉ bʉya, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―O guím bɛ̨mhbʉ ngue ga 'bɛcä yʉn t'ɛ̨di bi man ra Moisés nɛ 'bɛ'a bin xänbate ʉ yʉ pøngahyą, pɛ bá ɛ̨cä ngue ga ut'ahʉ 'bɛ'a majuąni nam bøn ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Majuąni dí xi ahʉ, gätho 'bɛ'a nt'o't'i bʉ, nɛ xínga n'da ʉ ngue hin din ja, 'bʉ guexta'a i jatho ra ximhäi nɛ mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Janangue'a madí ts'ʉtho maha a ram hma ngue hingui nde da 'yʉrpa ra güɛnda n'da, nɛ i xi ʉ mi'da ngue din jabʉ da 'yøt'e, pɛ zi ts'ʉtho rá ts'ɛdi di nɛqui bʉ bí ja rá ts'ɛdi Oją bʉ mahɛ̨ts'i 'bʉ. Pɛ nu'ʉ di ją'ts'i gätho ʉ mam bʉ ja rám hma Oją, nɛ i xi ʉ mi'da ngue din ja bʉ da 'yøt'e, nɛ man'da xʉn ngu rá ts'ɛdi di nɛqui bʉ bí ja rá ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nɛ gue'a dí xi ahʉ a, nde'bʉ man'da xʉn ho gui 'yøthʉ xinda gue ma ngʉrpihʉ yʉ fariseo nɛ yʉ xänbate niją. Nguetho nu'bʉ hin gui 'yøthʉ xʉn ho, njąm'bʉ da zä gui cʉthʉ hapʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Gue'bʉ go maya'bʉ bi sih mam bombøtahʉ ran t'ɛ̨di ngue im ma: “O guí hącpahʉ rá te ni miją'ihʉ, nɛ nu to'o da hyącpa rá te rá miją'iui, i jatho da ts'änba rá muui a bi 'yøt'e,” bi t'ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pɛ i jagä man'da ga xi ahʉ, ngue nu'bʉ 'bo'o di cuɛp rá miją'iui nangue'a bi 'yørpe, ngue im bɛ̨ni di co'ts'i, guehma da nu ran ts'ɛmbi. Nɛ nu'a to'o da xih ra ts'ore bʉ ja rá hmi rá miją'iui, da ts'ixpʉ 'bʉh yʉ ngʉrpi da ts'ɛmbi. Nɛ nu to'o ɛ̨mmɛ then rá miją'iui dí mba bʉ ja ran ts'ɛmbi ngue ra sibi njąm'bʉ i huɛ̨t'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Janangue'a nu'bʉ guí pähä bʉ ja ra niją ngue guí ɛ̨na gui thąndehʉ Oją, pɛ nu'bʉ gá sømhbʉ bʉ nɛ 'bex gá bɛ̨mhbʉ 'bɛ'a xquín xihmi ni miją'ihʉ, ");
INSERT INTO otmNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","gua peng thohʉ nɛ 'bɛ gui mba bʉ i 'bʉ a ni miją'iui gam punbaui, ja da zä gui thąndehʉ Oją bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nɛ nu'bʉ guí pąhmbʉ ja 'bɛ'a guidín xihmbʉ n'da ni miją'ihʉ, pɛ gan hocpa zɛhɛhʉ, nɛ hin gui tømhbʉ da ts'ix ahʉ bʉ 'bʉh yʉ ts'ʉt'abi. Nguetho nu'bʉ gui sømhbʉ bʉ, ");
INSERT INTO otmNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","guehma da jo ahʉ nɛ hin da hyɛc'a thohohʉ ra zɛ'mi jague'bʉ gui unhdʉ ra mbɛti hangu da 'yä ahʉ, nɛ xínga n'da centavo da nde gui 'yɛspahʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nɛ man'da bi xih yʉ́ xädi ra Jesús: ―Nu man'da ran t'ɛ̨di maya'bʉ i ɛ̨na: “O guí øthʉ ran 'yomt'ɛ̨ni.” ");
INSERT INTO otmNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pɛ i jagä man'da ga xi ahʉ, ngue nu'bʉ n'da ran 'yohʉ da hyant'a n'da ra xisu, nɛ im bɛ̨n'a n'da ran 'yomfɛ̨ni xʉn ts'o nangue a, madague'bʉ bi bɛ̨ntho, tengu'bʉ ya bi 'yøt' ran 'yomt'ɛ̨ni bʉ rá mbʉi a bʉya, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Janangue nu'bʉ i ja a i ut'ahʉ ra ts'oqui, pɛ gui sąmzɛhɛ ni mbʉihʉ madague'bʉ guím bɛ̨mhbʉ ɛ̨mmɛ xʉn ʉ 'bʉ gui 'yɛshʉ. Tengu'bʉ xquí hyą'a n'da ni dähʉ nɛ xquí 'yɛmhbʉ bʉ ma'ueni nɛ xquí n'dadä thohohʉ, uague tengu'bʉ xquí hyɛc'a nin 'yɛihʉ nɛ xquí 'yɛmhbʉ bʉ ma'ueni nɛ xquí n'da'yɛ thohohʉ. Pɛ man'da xʉn ho guin nuhʉ nangue gá 'bɛhmbʉ yʉ ts'oqui, xinda gue'bʉ xquí 'yøthʉ yʉ ts'oqui nɛ xquí 'bɛhmbʉ ran ho maząi bʉ ja ra sibi. ");
INSERT INTO otmNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nɛ a bi mam 'bʉ maya'bʉ gue: “Nu'bʉ n'da ran 'yohʉ in nde da hyɛh rá xisu, i jatho da 'yøt'a n'da ra søcuą din xummi.” ");
INSERT INTO otmNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pɛ i jagä man'da ga xi ahʉ, ngue hingui sä da hyɛh rá xisu n'da ran 'yohʉ gue'bʉ hingui øt' ran 'yomt'ɛ̨ni a ra xisu. Nguetho nu'bʉ bi hyɛh rá xisu n'da ran 'yohʉ, di japi da 'yøt' ran 'yomt'ɛ̨ni a ra xisu 'bʉ bi hyɛgui nɛ dim 'bʉhmi man'da ran' yohʉ. Nɛ 'bʉ n'da ran 'yohʉ dim 'bʉhmi n'da ra xisu bi thɛgui, ra 'yomt'ɛ̨ni a, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","―Nɛ guí pąhmbʉ ran t'ɛ̨di mí hmam 'bʉ maya'bʉ ngue i ɛ̨na: “Pɛ nu'bʉ gá ndønbahʉ rá thuhu Oją, guehma gui ją'ts'a gá mamhbʉ.” ");
INSERT INTO otmNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pɛ nuya i jagä man'da ga xi ahʉ, bi 'yɛ̨n'a ra Jesús. Hin'yʉ 'bɛ'a i sä gui ndønbahʉ rá thuhu 'bʉ ja a guí xihmbʉ ni miją'ihʉ ngue guín ndefʉ da 'yɛ̨c'yɛi a guí xihmbʉ. Hingui sä gui ndømhbʉ Oją, pɛ ngutho hingui sä gui ndømhbʉ mahɛ̨ts'i, nguetho nu bʉ mahɛ̨ts'i bí ja bʉ rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nɛ xíngui sä gui ndømhbʉ ra ximhäi, nguetho nɛcua i ja ua rá ts'ɛdi Oją. Nɛ xíngui sä gui ndømhbʉ ra hnini Jerusalén, nguetho rá hnini rá Thahni Oją a. ");
INSERT INTO otmNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nɛ xíngui sä gui ndømhbʉ ni yąhʉ, nguetho 'dat'a Oją bi zän'na, nɛ xínga n'da ni xtąhʉ sä gui sänzɛhɛhʉ gue'bʉ xʉn t'axi o gue xʉm pothi da gohi. ");
INSERT INTO otmNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pɛ nu'bʉ ja a guí xihmbʉ ni miją'ihʉ, “da zä,” ga ɛ̨mhbʉ 'bʉ da zä, “hin da zä,” ga ɛ̨nthohʉ 'bʉ hin da zä. Pɛ gätho mi'da yʉm hma bí nɛxpʉ ja rán 'yomfɛ̨ni ra zįthu, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Nu'ahʉ gá 'yøhmbʉ 'bɛ'a bi sih mam bombøtahʉ ngue: “Nu'bʉ n'da ra ją'i di ts'onba rá dä rá miją'iui, pɛ nɛ a da mba ma ts'onbi rá dä. Nɛ nu'bʉ rá ts'i da 'yøcpe, ngutho nɛ'a xin da t'øcpa rá ts'i.” ");
INSERT INTO otmNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pɛ nuya i jagä man'da ga xi ahʉ ya, ngue nu'bʉ 'bʉ a n'da in nde di ʉn'nahʉ, pɛ o guí sʉhmbʉ a. Nɛ nu'bʉ 'bo'o da mbɛp'ahʉ 'danguadi ni hmihʉ, gui unhdʉ man'da nguadi da mbɛp'ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nɛ nu'bʉ 'bo'o da zix ahʉ bʉ 'bʉh ra zɛ'mi ngue da gąn'na ni pahnihʉ, pɛ nɛ a ni cotohʉ gui unhdʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nɛ nu'bʉ i si ahʉ gui tuspahʉ rá 'bɛni n'da ra ją'i n'da ora, xʉn ho 'bʉ nyo ora gui tuxhʉ a rá 'bɛni. ");
INSERT INTO otmNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nɛ hønt'a go to'o da 'yä ahʉ 'bɛ'a i honi, dami unhdʉ. Nɛ nu'bʉ 'bo'o da mip'ahʉ 'bʉ ja a guí pɛs'hʉ, pɛ xʉn ho 'bʉ gui unhdʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","―Nɛ a n'da ram hma maya'bʉ i ɛ̨na: “Dami huɛ̨c ni amigohʉ nɛ gui ʉcpa nin sʉihʉ,” mí t'ɛ̨n'ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pɛ i ja man'da ga xi ahʉ, ngue gui huɛ̨c nin sʉihʉ, gan yąmanhohʉ ʉ man yʉ ts'ore nangue ahʉ, nɛ gui 'yørpahʉ ran ho to'o di ʉc'ahʉ. Nɛ dami 'yäfʉ rá mate Oją ʉ to'o i numan'ʉ ahʉ nɛ ʉ di ʉn'nahʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nɛ nu'bʉ ngubʉ gui 'yøthʉ, 'da'angu gá 'yøthʉ a ma Tahʉ 'bʉpʉ mahɛ̨ts'i ngue bá pɛnh ra 'ye nɛ ra hyadi. Pɛ hinga hønbʉ 'bʉ ʉ yʉ hocją'i gue i so ra 'ye nɛ ra hyadi, pɛ nɛpʉ i 'bʉh yʉ ts'om'bäi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pɛ nu'bʉ hønt'ʉ to'o di huɛ̨c'ahʉ guidí huɛ̨jʉ, 'bɛ'a gue gá tąhmbʉ 'bʉ ngubʉ gá 'yøthʉ. Pɛ nɛ n'dat'a gá 'yøthʉ ʉ yʉ ziyate hyącahäi. ");
INSERT INTO otmNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pɛ ha guí ɛ̨mhbʉ xʉn ho guí øthʉ 'bʉ hønt'ʉ ni cuhʉ guidí zɛnguahʉ. Nu'bʉ guin jahʉ bʉ, 'da'angu guí øthʉ ʉ i thąnde yʉ́ oją zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pɛ nde'bʉ xʉn hotho gui 'yøthʉ, nguetho xʉn hotho Oją ma Tahʉ bí 'bʉpʉ mahɛ̨ts'i, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nɛ man'da bi man ra Jesús, bi 'yɛ̨mp'ʉ mi 'bʉpʉ: ―Pɛ nu'bʉ guí øthʉ rá 'bɛfi Oją, hin gui 'yøthʉ da 'yɛ̨s'a ni miją'ihʉ, nguetho hin te di 'da ahʉ ma Tahʉ 'bʉpʉ mahɛ̨ts'i 'bʉ din jabʉ gui 'yøthʉ, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nɛ nu'bʉ guín nde gui fäxhʉ n'da ra hyoya, hin gui 'yøthʉ ngue da nu ahʉ yʉ ją'i, tengu øt'ʉ di yorpa a im bɛ̨ni 'bʉ di un'na n'da ran t'unni yʉ hyoya, ngue di um bʉ ja yʉ niją o guepʉ ja yʉ 'yu ngue in nde da 'yɛ̨spa yʉ ją'i 'bɛ'a i øt'e. Majuąni dí xi ahʉ, ya hønt'a ran 'yɛ̨ts'i bi dąha 'bʉ ngubʉ i øt'e, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pɛ nu'bʉ i ja a guí nde gui unhdʉ n'da zi hyoya, nde'bʉ hin gui xihmbʉ ʉ mi'da 'bɛ'a gá 'yøthʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nɛ man'da xʉn ho 'bʉ hin njon da nu 'bɛ'a guídí unhdʉ, pɛ go da nu Oją ma Tahʉ, nɛ i ja 'bɛ'a din 'da ahʉ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nɛ man'da dí xi ahʉ: ―Nu'bʉ guí yąhʉ Oją, o guí øthʉ tengu i øt'ʉ di yorpa a im bɛ̨ni, bi 'yɛ̨n'a ra Jesús. Nu'ʉ, i 'bäpʉ ja yʉ niją nɛpʉ ja yʉ xo'yu, ɛ̨na i yąhʉ Oją pɛ hønt'a ran 'yɛ̨ts'i im bɛ̨ni. Majuąni dí xi ahʉ, hønt'a ran 'yɛ̨ts'i bi dąha nangue 'bɛ'a i øt'e. ");
INSERT INTO otmNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nɛ nu'bʉ guí yąhʉ Oją gui mbähä bʉ njon da nu ahʉ, pɛ Oją ma Tahʉ go i nu ahʉ nɛ di 'da ahʉ 'bɛ'a guí äfʉ a, i ɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pɛ hinga guexta'a ram hma gui mamhbʉ ngue nte ní mba tho 'bʉ guí yąhʉ Oją, tengu i øt'ʉ tɛn yʉ́ oją zɛhɛ. Nɛ sä im bɛ̨ni i ø'a Oją 'bɛ'a im ma 'bʉ xʉn ngu i xifi. ");
INSERT INTO otmNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nɛ o guí øthʉ tengu i øt'ʉ, nguetho nu Oją ma Tahʉ ya i pądi 'bɛ'a gätho guí homhbʉ gue'bʉ hinga ná äfʉ, i ɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pɛ guim bɛ̨mhbʉ 'bʉ guí yąhʉ Oją 'da yʉm hma tengu dí xi ahʉ ngue: Nuya ma Ta ahe guí 'bʉpʉ mahɛ̨ts'i. Da hnumansu ni thuhu. ");
INSERT INTO otmNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nɛ dín ndehe din ja ua n'dihi ni ts'ɛdi ngue di manda ua. Nɛ da t'øt' ua ni pähä ua ja ra häi tengu tho i t'ørpʉ mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nɛ dami 'daje ran ts'ihmɛ dí homhbe ra pa i jabʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Dami punga ma ts'oquihe, tengu thoho bʉ na punbahe ʉ i ørcahe ran ts'o. ");
INSERT INTO otmNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nɛ o guí hɛgahe da dąje ran ts'o, pɛ dami yąnje nangue ran ts'o. Nguetho nu'i gra hmuts'ʉt'abi, gä di manda ua ja ra häi ni ts'ɛdi, nɛ i ja ni ts'ɛdi mixte njąm'bʉ da guadi gätho yʉ pa maząi. Nɛ hønt'a dí xi'ahe ya. ");
INSERT INTO otmNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nguetho nu'bʉ gadí punbahʉ yʉ́ ts'oqui ni miją'ihʉ, ngutho da 'yøt'ahʉ Oją ma Tahʉ 'bʉpʉ mahɛ̨ts'i, di pun'na ni ts'oquihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pɛ nu'bʉ hin gadí punbahʉ ni miją'ihʉ, nɛ ahʉ hin di pun'nahʉ Oją ma Tahʉ 'bʉpʉ mahɛ̨ts'i 'bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","―Nɛ nu'ahʉ, nu'bʉ guí nde gui 'yɛt' nin sihmɛhʉ n'da ora ngue guim bɛ̨mhbʉ Oją, o guí øthʉ tengu øt'ʉ di yorpa a im bɛ̨ni. Nu'ʉ i ut yʉ ją'i 'bɛ'a øt'e, nde'a dí hnumanho, pɛ hønt'a ran 'yɛ̨ts'i bi dąha nangue 'bɛ'a bi 'yøzɛhɛ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pɛ nu ahʉ, 'bʉ guí ɛt' nin sihmɛhʉ ngue guím bɛ̨mhbʉ Oją, pɛ gan 'yomanhohʉ tengu'bʉ ya gán sihmɛhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","N'dahma njon da bądi 'bɛ'a gá 'yøthʉ gue gá 'yɛt' nin sihmɛhʉ, nɛ hønt'a Oją ma Tahʉ i nu ahʉ 'bɛ'a gá 'yøthʉ, nɛ i ja 'bɛ'a di 'da ahʉ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Hin gui muns'hʉ 'bɛ'a gdám mɛmbɛtihʉ ua ja ra ximhäi, nguetho nuua i 'bʉh yʉ zu'uɛ̨ ngue di ts'oni 'bɛ'a gätho guí pɛs'hʉ, nɛ ja'bʉ da boxjua, nɛ ja'bʉ da bɛ̨ ahʉ yʉ bɛ̨. ");
INSERT INTO otmNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pɛgue gui hyoni gui xąnthʉ 'bɛ'a dí hnumanho ahʉ bʉ mahɛ̨ts'i. Nguetho hin te dim 'bɛpʉ, hin da yʉrpʉ yʉ bɛ̨ ngue da bɛ̨ ahʉ 'bɛ'a guí pɛs'hʉ bʉ, nɛ hin da boxjua, nɛ njo'o bʉ yʉ zu'uɛ̨ ngue di ts'oni. ");
INSERT INTO otmNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nguetho hønbʉ i ja ním pɛ'ts'i n'da im bɛ̨n rá mbʉi n'da. Nu'bʉ guecua ja ra ximhäi i ja 'bɛ'a i pɛ'ts'a n'da, hønt'ua im bɛ̨n a n'da, nɛ nu'bʉ guepʉ mahɛ̨ts'i, guepʉ im bɛ̨n a n'da 'bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nɛ xø bi 'yɛ̨na: ―Nɛ nu'bʉ hønt'a xʉn ho guím bɛ̨mhbʉ nɛ guí øthʉ, din ja ahʉ tengutho 'bʉ n'da ra ją'i xʉn ho rá dä, i handi xʉn ho ran nɛqui, din jabʉ ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pɛ nu'bʉ hinga gue'a guím bɛ̨mhbʉ, sä guí ɛ̨mhbʉ i ja ahʉ ran nɛqui, pɛgue xʉm 'bɛxui thoho ni mbʉihʉ, tengutho 'bʉ n'da ra ją'i ngue hingui ho rá dä, nɛ xʉm 'bɛxui thoho bʉ i handi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nɛ xø bi 'yɛ̨na: ―Nɛ hingui sä dim 'bʉ i yoho yʉ́ hmu n'da ra 'yɛ̨hɛ. Nguetho nu'bʉ yoho yʉ́ hmu i 'bʉ a n'da, nu'a n'da da numanho, nɛ nu'a man'da hin da numanho. Uague nu'a n'da da hyumbi dim pɛhmi a, pɛ nu'a man'da da zocpa thoho rá 'bɛfi a. Janangue'a hingui sä yoho yʉ́ hmu da dɛn'na n'da. Hingui sä da 'yɛ̨mp Oją rá Hmu 'bʉ i numanho ʉ yʉ mbɛti, nguetho tengu'bʉ rá hmu a ra mbɛti, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","―Janangue'a dí xi ahʉ, hin go guim bɛ̨nsɛhʉ 'bɛ'a gui sihʉ ngue gdám 'bʉhmbʉ, nɛ xín guim bɛ̨mhbʉ 'bɛ'a gui hyehʉ. Pɛ guim bɛ̨mhbʉ ngue man'da di muui ni tehʉ xinda gue ʉ nin ts'ihmɛhʉ, nɛ man'da di muui ni ją'ihʉ xinda gue ʉ ni hehʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Dami nuhʉ yʉ doja i 'yo hønbʉ go hapʉ, nɛ hin'yʉ yʉ́ huąhi, nɛ xín te i pɛ'ts'i, pɛ dí xi ahʉ, nu Oją ma Tahʉ bí 'bʉpʉ mahɛ̨ts'i gätho i 'uįn ʉ. Nɛ nu ahʉ, man'da di mu ahʉ xinda gue ʉ yʉ doja, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nɛ ha guím bɛ̨mhbʉ man'da nya'a gam 'bʉhmbʉ ua ja ra ximhäi 'bʉ ɛ̨mmɛ guím bɛ̨ndumbʉihʉ 'bɛ'a gätho guidí 'bɛhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nɛ hanja ɛ̨mmɛ go guím bɛ̨nsɛhʉ nangue ni hehʉ. Xøgue ts'ʉtho guí ɛ̨c'yɛihʉ, bi 'yɛ̨n'a ra Jesús. Pɛ dami nuhʉ yʉ døni i ja bʉ dąpo, nɛ nu'ʉ hingui dim pɛfi nɛ xíngui di hoc yʉ́ he. ");
INSERT INTO otmNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pɛ dí xi ahʉ, man'da mahotho yʉ døni xínda gue a rá he ra ts'ʉt'abi Salomón ngue mí he 'bʉ mi ja rá ts'ɛdi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nɛ ngubʉ bi 'yøt'a Oją nangue yʉ døni, mahotho nám pa ya, nɛ nixudi da mba nts'ɛqui nɛ da t'udi. Janangue'a guim bɛ̨mhbʉ, man'da xʉn ho da 'yøt'ahʉ Oją xinda gue ʉ yʉ døni, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Janangue o guí ɛ̨mhbʉ: “'Bɛ'a hmaha ga sihʉ.” Uague: “'Bɛ'a hmaha ga hehʉ.” ");
INSERT INTO otmNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nguetho nu'ʉ i thąnde yʉ́ oją zɛhɛ, gue'a ząi i hon'ʉ, pɛ nu'ahʉ i 'bʉpʉ ni Tahʉ bʉ mahɛ̨ts'i, nɛ i pądi 'bɛ'a gä guidí 'bɛhmbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Janague'a nu ahʉ, m'bɛt'o thoho gan umhbʉ di manda ahʉ rá ts'ɛdi Oją, nɛ gui hyomhbʉ n'da ra hogambʉi nangue rá pähä Oją, nɛ nubʉya di 'da ahʉ 'bɛ'a gätho gui hyomhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","O guím bɛ̨ndumbʉihʉ, o guí ɛ̨mhbʉ: “'Bɛ'a da zä ga øthʉ 'bʉ nixudi.” Pɛgue gui tømhbʉ, 'bɛ nixudi ja gui pąhmbʉ bʉya 'bɛ'a da zä gui 'yøthʉ. N'da pa ngu n'da pa i ja 'bɛ'a din ja, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","―“Nuna bi 'yøt' yʉ ts'oqui,” hin gui 'yɛ̨mhbʉ, n'dahma hinga gue'a dí ts'ɛp'ahʉ a, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pɛ nu'bʉ guídi yąfʉ ʉ mi'da ngue guím bɛ̨mhbʉ hønsɛ ahʉ xʉn ho ahʉ, pɛ Oją hin da numanho ahʉ 'bʉ. Nɛ 'da'ingu da 'yøt'ahʉ Oją tengu gá 'yørpahʉ ʉ gá yąfʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hanja bi zä gá nurpahʉ ra zi häi i o rá dä ni miją'ihʉ, nɛ hin go guí pąhmbʉ i o ra xɛcza ni dähʉ. In jabʉ ní nɛqui ni ts'oquihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nɛ ha da zä gui xihmbʉ ni miją'ihʉ: “Mba ga hąp'a ra häi o ni dä,” sä gui 'yɛ̨mfʉ, nɛ go man'da xʉn ndoho ra xɛcza i o ni dähʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɛ̨mmɛ guidí yorpahʉ a guí øthʉ. Pɛ nde'bʉ m'bɛt'o gan hojʉ nangue yʉ ts'oqui guídi hosɛhʉ, janangue'a da zä gui hyąmp'ahʉ ra häi o rá dä ni miją'ihʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","O guidí unhdʉ a xʉn ho ʉ yʉ fo'yo, ndetho da za ahʉ. O gue'bʉ guidí unhdʉ a di muui ʉ yʉ ts'ʉdi, ndetho da nɛm bʉ häi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nɛ xø bi 'yɛ̨mp'ʉ: ―Dami 'yäfʉ Oją 'bɛ'a guí homhbʉ, nɛ nu'a di 'da ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nguetho nu'a to'o da 'yädi, Oją di un'na bi 'yäpi. Nɛ nu'a to'o ja a i honi, di und Oją a i honi. Nɛ nu'a to'o da hyoni da socpa n'da ra goxthi njut'i thoho, Oją da xocpa a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","11","Pɛ nu'ahʉ madague'bʉ gyʉ́ ts'om'bäihʉ, xínga n'da ahʉ guidí unhdʉ ra do ni t'ʉhnihʉ 'bʉ i ä'ahʉ ra hmɛ, nɛ xíng ra c'ɛ̨yą guidí unhdʉ 'bʉ i ä ahʉ ra huą, pɛ hønt'a xʉn ho guidí unhdʉ ni t'ʉhnihʉ. Ha maguet'a Oją ma Tahʉ 'bʉpʉ mahɛ̨ts'i ngue hin di 'da ahʉ xʉn ho 'bʉ ja a guí äfʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nɛ nu'bʉ guí nde da 'yøt'ahʉ ran ho ni miją'ihʉ, nde'bʉ gui 'yørpahʉ ran ho. Gue'a nam bøn'a rán t'ɛ̨di ra Moisés nɛ rám hma yʉ pøngahyą maya'bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nu'a ní yʉt'a n'da bʉ ja ra te maząi, tengu'bʉ n'da ra goxthi xʉn ts'įt'i, uague n'da ra t'ʉ'yu, nɛ hingui ngu yʉ ją'i i numanho da thopʉ. Pɛ dami hyomhbʉ gui cʉthʉ bʉ. Nguetho nu'a ra goxthi xʉn ndoho nɛ ra dą'yu ní zix a n'da bʉ ja ran ʉnbi maząi, nɛ xʉn ngu ʉ yʉ ją'i i numanho da thopʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","―Pɛ gam fähmbʉ nangue yʉ hyäte pøngahyą. Nu'bʉ i søm bʉ guí 'bʉhmbʉ, sä øt'e tengu'bʉ yʉ dɛ'yo ngue xʉn ho, pɛ nu yʉ́ mbʉi tengu'bʉ n'da ra zate. ");
INSERT INTO otmNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nɛ da zä gui pąhmbʉ yʉ hyäte pøngahyą nangue yʉ́n t'øt'e i øt'e, tengu thoho yʉ za da bą a n'da nangue yʉ́n dät'ä i zʉpʉ. Nguetho hin din zʉpʉ ja n'da ra za n'da ran dät'ä 'bʉ hinga gue'a rá za a. ");
INSERT INTO otmNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pɛ nu ra za xʉn ho i zʉh yʉ́n dät'ä xʉn ho, nɛ ngutho ra za hingui ho i zʉh yʉ́n dät'ä hingui ho. ");
INSERT INTO otmNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nguetho nu'a ra za xʉn ho hin da zä din zʉpʉ yʉ́n dät'ä ngue hingui ho, nɛ ngutho a ra za hingui ho hin njąm'bʉ da zä din zʉpʉ yʉ́n dät'ä xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nɛ nu yʉ za hingui ho ʉ yʉ́n dät'ä, da mba nt'ɛts'i nɛ da t'udi. ");
INSERT INTO otmNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Janangue'a da zä gui pąhmbʉ ʉ yʉ hyäte pøngahyą nangue 'bɛ'a da 'yøt'e, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Nɛ sä ɛ̨na yʉ́ hmujʉ ʉ 'da, pɛ hin da yʉrpʉ di manda rá ts'ɛdi Oją ʉ. Pɛ hønt'ʉ majuąni i øt' rá pähä ma Ta mahɛ̨ts'i da yʉrpʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nɛ nu'bʉ bi zøn ra pa ran juąnbi 'bʉ rán zɛgui, xʉn ngu da mbarqui da 'yɛ̨ngui: “Ma Hmu, nugähe dá mamhbe a nim hma, nɛ nangue ni thuhu dá hømhbe thi yʉ zįthu, nɛ nangue ni thuhu xʉn ngu yʉn t'øt'e mixte dá øthe,” da 'yɛ̨ngui. ");
INSERT INTO otmNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pɛ nugä ga ɛ̨mp'ʉ: “Njąm'bʉ dá pą ahʉ. Dami 'uehmbʉ ua ja ma hmigä, gyʉ ts'om'bäihʉ,” ga ɛ̨mbi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","―Pɛ nu'a to'o i øh ma nde nɛ i øt'a ma pähägä, i øt'e tengu bi 'yøt'a n'da ran 'yohʉ ngue mí ja rán 'yomfɛ̨ni nɛ bi hyø a n'da rá ngu bʉ ja n'da ra dongu xʉn juąni. ");
INSERT INTO otmNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nɛ bin ja n'da ra dą'ye, nɛ ɛ̨mmɛ xʉn ngu yʉ dehe bi 'yugui, nɛ bá ɛ̨h ran dąhi xʉn ndoho mí nde xtí yøt'a ra ngu. Pɛ him bi yøt'a, nguetho nu'a ra ngu mí høpʉ ja ra dongu xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pɛ nu'a to'o i ø'a dí ma nɛ hingui ʉrpa ra güɛnda a, i øt'e tengu bi 'yøt'a n'da ran 'yohʉ ngue ra 'yąmbʉi, nɛ bi hyøh rá ngu bʉ mi ja n'da ra 'bomu. ");
INSERT INTO otmNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nɛ bin ja n'da ra dą'ye ngue bi 'yuh yʉ dehe, nɛ ran dąhi xʉn ndoho, nɛ bi yøt'a rá ngu. Nɛ ɛ̨mmɛ nts'utho bin ja bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Nɛ nu'bʉ mi gua a bi ma ra Jesús 'bʉ mí hyupʉ ja ra nyuni, nu yʉ ją'i mi huhmbʉ bʉ bi hyonya ʉ. ―Haguen ja i xänbi xʉn ho, nɛ hinga ngubʉ i xängahʉ ma xänbatehʉ bʉ ja ra niją, bi 'yɛ̨n'ʉ yʉ ją'i. Nguetho nu'bʉ mi xänba ra Jesús, bi 'yuti ngue mi ja rá ts'ɛdi xʉn ho a. ");
INSERT INTO otmNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nɛ nu'bʉ mi gua a bi man ra Jesús, nɛ bi gąpʉ ja ra nyuni bʉya, nɛ ɛ̨mmɛ xʉn ngu yʉ ją'i mí numanho da dɛnthoho mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nɛ bá ɛ̨'a n'da ran 'yohʉ ngue mi hɛ̨mb ra t'axca'ya. Bin dąnyahmu bʉ mí 'bäh ra Jesús, nɛ bi 'yɛ̨mbi: ―Gra Hmu, nu'bʉ ni pähä, da zä gui 'uec'i ts'ʉ ran ʉ dí hɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nɛ nu ra Jesús bʉya bi uąt rá 'yɛ bi dädi nɛ bi 'yɛ̨mbi: ―I jagä ra pähä ngue 'bex da zä i. Dami yą́ni. Nɛ nu'bʉ mí 'yɛ̨mbi, 'bexgue bi yąn'a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nɛ nu ra Jesús bʉya bi hɛcpa a ran 'yohʉ njon da xifi to'o a bi japi bi yąni, nɛ bi 'yɛ̨mbi: ―Ní mba bʉ 'bʉh yʉ mbäją da nu i ngue ya bi yąn i, nɛ gui un'na n'da ra 'bøts'e tengu i man yʉ́n t'ɛ̨di ra Moisés, bi 'yɛ̨n'a ra Jesús. Nɛ ja bi thopʉ ra hnini Capernaum bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nɛ nu'bʉ mí zøm bʉ ra hnini Capernaum a ra Jesús, 'bex bá ɛ̨ a n'da ra hmudofʉi ra mɛngu bʉ Roma, nɛ bin c'at'ui nɛ bi 'yäp ra mate, ");
INSERT INTO otmNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","bi 'yɛ̨mbi: ―Nu'i grá Hmu, nu n'da ma 'yɛ̨hɛ i 'bɛm bʉ ja ma ngu, i ts'a rá ją'i, hingui sä di 'yąni, ɛ̨mmɛ xʉn 'doni, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nɛ nu ra Jesús bi 'yɛ̨mp'a: ―Ga mba bʉ ga hoqui. ");
INSERT INTO otmNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Pɛ nu ra hmudofʉi bʉya bi 'yɛ̨mbi: ―Hingui jatho gui mba bʉ ja ma ngu, grá Hmu, nugä hin dí sʉcä tengu e nɛ hin drá judíogä. Pɛ dí pądi ngue i ja ni ts'ɛdi zɛhɛ, ngue nu'bʉ guim ma da yąni, nɛ 'bexgue da yąni, bi 'yɛ̨na. Tengu thohogä bin 'dac'i ts'ʉ man t'ɛ̨di, nɛ nu'bʉ i ja 'bɛ'a dí xi ʉ ma dofʉi nɛ'ʉ ma 'yɛ̨hɛ, 'bexgue 'dahmantho in ja. Nɛ ngutho i, da zä guim mantho ua nɛ 'bexgue da yąm bʉya, bi 'yɛ̨n'a ra hmudofʉi. ");
INSERT INTO otmNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nu'bʉ mí 'yøh ra Jesús 'bɛ'a bi man a ra hmudofʉi, bi hyonya thoho nɛ bi xi ʉ min 'yohʉ: ―Majuąni dí xi ahʉ, njąm'bʉ xtá tįngä n'da ma mɛnguhʉ yʉ ją'i israel dyʉ judíohʉ ngue xtám bądi i ja ma ts'ɛdi xʉn ho tengu na ran 'yohʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Guim bɛ̨mhbʉ a dí xi ahʉ, xʉn ngu yʉ ją'i ngue gätho na ndoho ra ximhäi, ngue him ma mijudíohʉ, da 'yɛ̨c'yɛigui nɛ da yʉrpʉ di manda rá ts'ɛdi Oją, 'darbʉ dim 'bʉhmbʉ ma ngʉrpa bombøtahʉ ra Abraham, nɛ ra Isaac nɛ ra Jacob. ");
INSERT INTO otmNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pɛ xʉn ngu ma mijudíohʉ ngue yʉ́n sähʉ xtán yʉrpʉ, pɛ man'da go da t'ɛntpʉ ja ra 'bɛxui ʉ, nɛ din zom bʉ nɛ din guxpʉ yʉ́ ts'i, bi t'ɛ̨mp'ʉ yʉ ją'i 'bʉ mi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nɛ nubʉya bi t'ɛ̨mp'a ra hmudofʉi: ―Ní mba ni ngu, ya bin ja a gám ma nguetho gá 'yɛ̨c'yɛi i ja ma ts'ɛdi, bi 'yɛ̨n'a ra Jesús. Nɛ 'bexgue bi yąn a rá 'yɛ̨hɛ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nɛ nu'bʉ mí mbenc'a ra hmudofʉi bʉya, xø bi tho a ra Jesús, bi zøm bʉ rá ngu ra Pedro. Nɛ bi nu 'bɛm bʉ rá oi a rá suto ra Pedro, mi hɛ̨mb ra pa. ");
INSERT INTO otmNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nɛ nu ra Jesús bʉya bi bɛndba rá 'yɛ, nɛ 'bex bi bøn a ra pa mi hɛ̨mbi. Nɛ bi ndanc'a ra xisu bʉya, bi hyonba ra hmɛ a ra Jesús nɛ ʉ mín 'yohʉ, nguetho ya bi yąn'a ra xisu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nɛ nu'bʉ min xui bʉya xʉn ngu yʉ ją'i bá ts'i bʉ mi 'bʉh ra Jesús ngue min 'yohʉ yʉ zįthu. Nɛ hønt'a n'dare bi man ra Jesús, 'bexgue gätho bi hyøn a thi ʉ yʉ zįthu, nɛ bi hoc'ʉ yʉ hyɛ̨nni. ");
INSERT INTO otmNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gätho bin ja 'bɛ'a bi man a ra pøngahyą Isaías maya'bʉ ngue din ja 'bʉ mi 'yɛ̨na: “Da du zɛhɛ 'bɛ'a gätho xʉn hɛ̨i dín nuhʉ, nɛ da nusɛ 'bɛ'a gä man ʉ dí hɛ̨mfʉ,” bi 'yɛ̨n'a ra Isaías 'bʉ maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nɛ nu'bʉ mín nu ra Jesús ngue ɛ̨mmɛ xʉn ngu yʉ ją'i mi 'bäpʉ, bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Masque xʉn ho 'bʉ ga thohmbʉ 'danguadi ra dądehe, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nɛ nu n'da ra xänbate niją bi 'yɛ̨mbi: ―Xänbate i, dín nde ga tɛn'ni i hønbʉ go hapʉ gui mba, bi 'yɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nɛ bi dą a ra Jesús nɛ bi 'yɛ̨mbi: ―Pɛ nu yʉ haho i ja yʉ́ ngu nɛ yʉ doja i ja hapʉ da 'yoi. Pɛ nugä ngue dán ją'igä ua ja ra ximhäi, hin'yʉ ma ngungä ua, bi 'yɛ̨mthoho ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nɛ xø bi 'yɛ̨n'a man'da ra ją'i min 'yohʉ bʉya: ―Ma Hmu, dami tøcpi ts'ʉ, 'bɛ ga äcä ts'ʉ ma ta nɛ ga tɛn'na bʉya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bi dą'a ra Jesús, bi 'yɛ̨mbi: ―Tɛnga maha, nu'ʉ xʉn du da 'yä ʉ 'bʉpʉ, tengu'bʉ nɛ ʉ xʉn du ʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nɛ nu'bʉ mi gua'a man ra Jesús bʉya, 'bex bi hyu bʉ ja ra mbosa nɛ bi mbähä yʉ́ xädi, dí mba bʉ 'danguadi ra dądehe. ");
INSERT INTO otmNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nɛ bi mbʉ'a n'da ran dąhi ts'ɛdi bi 'yɛn ra dehe, nɛ ɛ̨mmɛ di thoni yʉ t'øthe, bi dons i ts'ʉ ra dehe a ra mbosa. Pɛ nu ra Jesús mí ąha, him bi 'yʉrpa ra güɛnda 'bɛ'a midí ja ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nɛ bi 'yä ʉ yʉ́ xädi nɛ bi 'yɛ̨mbi: ―Gra Hmu, dami nuhu, guin yąnje, nguetho ya in nde ga tonthʉ mbo ra dehe, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nɛ nu ra Jesús bi dądi: ―Hanja, ha ɛ̨mmɛ zi ts'ʉtho guí ɛ̨c'yɛigahʉ ngue i ja ma ts'ɛdi, nɛ guín suhʉ. Nɛ nubʉya bi ndanc'a ra Jesús nɛ bi xi a ran dąhi ngue din hɛ̨ nɛ ra dehe, nɛ 'bexgue bin hɛ̨ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nɛ nu'ʉ yʉn 'yohʉ bʉya bi hyonya thoho 'bɛ'a bi 'yøt'a ra Jesús. ―'Bɛ'a di 'yɛ̨t'ui na ran 'yohʉ, nguetho nɛ ran dąhi i ø'a i xifi, nɛ ra dehe i ø'a i xifi, bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nɛ nubʉya bi zøm bʉ 'danguadi ra dądehe bʉya, nguepʉ ra xɛqui Gadara. Nɛ 'bex bá ɛ̨pʉ yoho yʉn 'yohʉ ngue min 'yohʉ yʉ zįthu, nɛ mán ts'utho ʉ, tengutho ʉ yʉ zate. Mí 'bʉpʉ ja yʉn 'yägui ʉ, janangue'a nu yʉ ją'i i su da thopʉ hänbʉ ja ran 'yägui. Nɛ 'bex bá ɛ̨'ʉ yʉn 'yohʉ bin c'athʉ a ra Jesús, nɛ bi mbafi: ");
INSERT INTO otmNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","―'Bɛ'a gní 'yɛ̨cua gra Jesús, rá Ts'ʉnt'ʉ i Oją. Ha cpí 'yɛ̨hɛ gui ʉngahe, nɛ hinga na søn ra pa gui ʉngahe, bi 'yɛ̨n yʉ zįthu min 'yohʉ ʉ yʉn 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nɛ hinga yatho bʉ mi 'bʉ i 'da yʉ ts'ʉdi. ");
INSERT INTO otmNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nɛ nu'ʉ yʉ zįthu bʉya bi 'yɛ̨mp'a ra Jesús: ―Nu'bʉ guín nde gui hyønje thi, dami 'daje ran t'ɛ̨di ga cʉthe nʉ 'yo yʉ ts'ʉdi, bi 'yɛ̨n'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Ni mbähä, dami cʉthʉ nʉ, bi 'yɛ̨n'a ra Jesús. Nɛ nu yʉ zįthu bʉya bi bøm bʉ ja rá mbʉi ʉ yʉn 'yohʉ, nɛ 'bexgue bi yʉrpʉ 'bʉh yʉ ts'ʉdi. Nɛ nu yʉ ts'ʉdi bʉya bin tihi nɛ bi gąpʉ ja ra nguani, him bi zä bin säya, nin uɛ̨m bʉ ja ra dehe, bim 'bɛpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nɛ nu'ʉ mi fä ʉ yʉ ts'ʉdi bʉya, 'bexgue bi mba n'dihi bʉ ja ra hnini, nɛ nu'bʉ mi zøm bʉ, bi mam bʉya ngue 'bɛ'a bin ja nangue ʉ yʉn 'yohʉ min 'yohʉ yʉ zįthu, nɛ nangue ʉ yʉ ts'ʉdi. ");
INSERT INTO otmNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nɛ bá ɛ̨h yʉ mɛngu bʉ ra hnini bʉya, bi zøpʉ 'bäh ra Jesús, nɛ nts'ɛdi bi 'yäp ra mate ngue da mbengui, nguetho him bi numanho 'bɛ'a bi 'yøt'a. ");
INSERT INTO otmNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nɛ nu ra Jesús bʉya, xø bá hu mahøn'a ra mbosa, bá peng bʉ 'danguadi ra dądehe. Bi zøm bʉ ra hnini mi 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nɛ bá thunba bʉ man'da ra hyɛ̨nni mahøn'a, ngue n'da ran 'yohʉ bá 'yox ra 'beza nguetho midí ts'a rá ją'i. Nɛ 'bexgue mí pą a ra Jesús mí ɛ̨c'yɛi ʉ ngue i jasɛ rá ts'ɛdi, janangue'a bi 'yɛ̨mp'a ra hyɛ̨nni: ―O te guím bɛ̨ni n'yø, nguetho ya dá pun'na ni ts'oqui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nɛ nu'ʉ 'da yʉ xänbate niją bʉya, nu'bʉ mi 'yøde 'bɛ'a bi man ra Jesús, 'bex bi bɛ̨n ʉ: ―Nuna ran 'yohʉ hingui ho i øt' na, ha hinga hønt'a Oją sä di punba n'da, mi ɛ̨nsɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pɛ nu ra Jesús 'bex bi bądi 'bɛ'a mim bɛ̨n'ʉ yʉ xänbate niją, nɛ bi 'yɛ̨mp'ʉ: ―Hingui ho guím bɛ̨mhbʉ mbo ni mbʉihʉ, ngue guí ɛ̨mhbʉ hingui ho 'bɛ'a dá øt'ä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Ha guím bɛ̨mhbʉ nte ní mbatho dá xicä ran 'yohʉ, ngue rá ts'oqui ya dá punbi. Ha guím bɛ̨mhbʉ man'da xquí pąhmbʉ i ja ma ts'ɛdi 'bʉ ga xifi da ndants'i, din 'yo. Pɛ nuya ga ut'ahʉ ngue i ja man t'ɛ̨digä ua ja ra häi ga punba yʉ́ ts'oqui yʉ ją'i, nugä ngue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨mp'ʉ. Nɛ xø bi 'yɛ̨mp'a ran 'yohʉ i ts'a rá ją'i bʉya: ―Dami ndants'i, cąx ni fįdi, ní mba ni ngu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Bex bi ndanc'a ran 'yohʉ mi ts'a rá ją'i, bi mba rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nɛ nu'bʉ mín nu yʉ ją'i 'bɛ'a bi 'yøt'a ra Jesús, bin su nɛ bi 'yɛ̨spa Oją nangue a n'da ra ją'i bin t'un'na ran t'ɛ̨di ngue di punba yʉ́ ts'oqui yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nɛ nu'bʉ mi bøm bʉ ra Jesús, bi thopʉ mi hucä bʉ dí hącä ra renta, drá hyącahäigä ngue drá Mateo, nɛ bi 'yɛ̨ngui: ―Dami tɛngui. Nɛ nubʉya dá ndangui nɛ dá tɛnni. ");
INSERT INTO otmNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nɛ nubʉya 'darbʉ dán sihmɛgähe ra Jesús yʉ́ xädigähe a ya. Nɛ bi zøm bʉ xʉn ngu yʉ ziyate hyącahäi nɛ yʉ ts'om'bäi, 'darbʉ dá huhmbe bʉ dán sihmɛhe. ");
INSERT INTO otmNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nɛ nu yʉ fariseo bʉya, ngue im bɛ̨ni hønsɛ xʉn ho, 'bʉ mi nu 'bɛ'a bi 'yøt'a ra Jesús, bi 'yängähe ngue yʉ́ xädigähe bʉya: ―Hanja in jabʉ ni xänbatehʉ 'darbʉ i sihmɛhʉ yʉ ziyate hyącahäi nɛ yʉ ts'om'bäi, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nu'bʉ mí 'yø'a ra Jesús 'bɛ'a bi man ʉ, bi 'yɛ̨mp'ʉ: ―Hingui honi to'o da mbäx ʉ im bɛ̨nsɛ xʉn zaqui tengu ahʉ, pɛ hønt'ʉ i pąsɛ xʉm bøca i honi to'o da mbäx ʉ tengu ya i nde da dɛngui, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ní mbähä bán xähmbʉ bʉ ja ni søcuąhʉ 'bɛ'a nam bøn'a rám hma Oją ngue i ɛ̨na: “Pɛ nugä man'da dí numanho 'bʉ gui 'yøthʉ ran huɛ̨cate xinda gue ʉ yʉ 'bøts'e guidí 'dajʉ,” i ɛ̨n Oją, i ɛ̨m bʉ ja yʉ́ søcuą Oją, bi 'yɛ̨n'a ra Jesús. Nɛ nugä him bá ɛ̨cä gan zon'dʉ im bɛ̨nsɛ xʉn ho, pɛ bá ɛ̨cä gan zon'dʉ i pądi hingui ho, janangue da zä di päh yʉ́n 'yomfɛ̨ni, bi 'yɛ̨n'a ra Jesús, bi 'yɛ̨mp'ʉ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nɛ n'da ra pa bʉya bi zøm bʉ 'bʉh ra Jesús yʉ́ xädi ra Xuua Nxixyą, nɛ bi 'yänni: ―Hanja dí ɛ't'ähe man ts'ihmɛ, nɛ yʉ fariseo, pɛ nu ni xädi hingui ɛ't' yʉ́n ts'ihmɛ ʉ, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ra Jesús bi man'a n'da ran t'uti 'bʉ mi dądi, bi 'yɛ̨mbi: ―Pɛ nu'ʉ i 'bʉpʉ ja ran thąti hin da du yʉ́ mbʉi, nguetho 'bʉpʉ a ran 'yohʉ din thąti. Pɛ da zøn ra ora da ts'ispa a ran 'yohʉ, nɛ ja da 'yɛ't' yʉ́n ts'ihmɛ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pɛ nu'a din xä ʉ ma xädigä hin da bømanho 'bʉ nɛ'a ram hma maya'bʉ da dɛn ya, bi 'yɛ̨na. Tengutho'bʉ n'da ra 'ya'bø't'e 'bʉ dí 'bø't'a ra 'bø't'e ma'da'yo, hin da bømanho, nɛ nu'a ra 'bø't'e ma'da'yo di ts'on a ra 'ya'bø't'e. ");
INSERT INTO otmNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nɛ tengutho i øt' yʉ ją'i 'bʉ da xit' ra gui'uva ma'da'yo bʉ ja ra 'yambot'asɛ̨i, da fø'a nɛ dim fäni. Janangue i xit'a ra gui'uva ma'da'yo bʉ ja ra mbot'asɛ̨i ma'da'yo, nɛ hin da føgue nɛ hin dim fäni, bi 'yɛ̨n'a ra Jesús, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nɛ nu'bʉ mí yąhʉ ʉ, 'bexgue bi zøm bʉ n'da ra ngʉrpi bʉ ja ra niją, nɛ bin dąnyahmu bʉ mí 'bäh ra Jesús nɛ bi 'yɛ̨mbi: ―Bi du n'da ma t'įxu, 'yørqui ts'ʉ ra mate ga mbɛ gui cäx ni 'yɛ, nɛ da dąmbɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","'Bex bi mba a ra Jesús, bi dɛn'na bi du rá t'ʉhni. Nɛ gätho dá mbäcähe dyʉ xädigähe. ");
INSERT INTO otmNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nɛ nu'bʉ má mbähmbe bʉ 'yu, hin da ná sømhbe bʉ ja rá ngu a ra ngʉrpi, bi zʉje n'da ra xisu ngue ná 'dɛ'mayo njɛya min 'youi ra mbäji. Bi hyän bʉ rá xʉtha ra Jesús nɛ bi därpa rá nyąni rá pahni. ");
INSERT INTO otmNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nguetho mí ɛ̨nsɛ ra xisu: “Go høntho ga thärpa rá pahni, ya da yąngui.” ");
INSERT INTO otmNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nɛ nu'bʉ mi därpa rá pahni ra Jesús a ra xisu, 'bex bi nyɛ̨ a ra Jesús, bi nu a ra xisu nɛ bi 'yɛ̨mbi: ―Damin johya gra xisu, ya bi yąn i nguetho gá 'yɛ̨c'yɛi i ja ma ts'ɛdi, bi 'yɛ̨mbi. 'Bexgue gue'a ra ora bi yąn'a ra xisu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nɛ bi tho a ra Jesús bʉya, dá søngähe bʉ rá ngun'a ra ngʉrpi, nɛ mí 'bʉpʉ yʉ mbɛ'bida nɛ xʉn ngu yʉ ją'i mi 'bʉpʉ ngue mí ɛ̨na xtá 'yäh ra hmute xí du. ");
INSERT INTO otmNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nɛ bi 'yɛ̨n'a ra Jesús: ―Dami pømhbʉ thi, nguetho nuna ra hmute him bi du, nɛ i ątho, bi 'yɛ̨mbi. Pɛ bin thetho ʉ yʉ ją'i 'bʉ mi 'yø a bi xifi, nguetho mi pą ʉ ya xí du ra hmute. ");
INSERT INTO otmNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nɛ nu'bʉ mi bøn'ʉ yʉ ją'i bʉya, bi thopʉ mbo mi 'bɛn a ra hmute ra Jesús, nɛ bi bɛndba rá 'yɛ 'bex bi ndanc'a n'dihi ra hmute. ");
INSERT INTO otmNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nɛ gätho na ndoho ra xɛqui bʉ bi 'yø ʉ yʉ ją'i 'bɛ'a bin ja. ");
INSERT INTO otmNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nɛ bi bøm bʉ rá ngu ra ngʉrpi a ra Jesús. Nɛ bi dɛnni yoho yʉ xädä, nɛ i mba't' bʉ ní mba: ―Dami huɛ̨gä'be, gram bom'bɛto i ra David, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nɛ bi zøm bʉ ja ra ngu a ra Jesús, bi dɛn'ndʉ yʉ xädä. Nu ra Jesús bi 'yänni: ―Ha guí ɛ̨c'yɛiui i ja ma ts'ɛdigä ngue ga xoc'a ni däui, bi 'yɛ̨n a ra Jesús. ―Dí ɛ̨c'yɛi'be ngue i ja ni ts'ɛdi, gra Hmu, bi 'yɛ̨n ʉ yʉ xädä. ");
INSERT INTO otmNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nu ra Jesús bʉya bi därpa yʉ́ dä nɛ bi 'yɛ̨mbi: ―Din ja tengu a gá 'yɛ̨c'yɛiui, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nɛ 'bex bi xo ʉ yʉ́ dä. Nɛ nu ra Jesús bʉya bi hɛcpa ʉ yʉn 'yohʉ, bi 'yɛ̨mbi: ―Njon gui xihmi 'bɛ'a dá øt'aui. ");
INSERT INTO otmNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pɛ høntho bi bøm bʉ yʉ xädä, 'bex bi xih yʉ ją'i 'bɛ'a bi 'yørpa ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nu'bʉ mi bøn ʉ yʉ xädä, xø bá ts'inba man'da ran 'yohʉ a ra Jesús. Midí goreba n'da ra zįthu min 'youi. ");
INSERT INTO otmNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nu ra Jesús bʉya bi hyønba thi ra zįthu min 'youi a ra gore, 'bex bi nyą a bʉya. Nu yʉ ją'i bʉya bi hyonya thoho 'bʉ mi nu a bin ja, nɛ bi 'yɛ̨na: ―Hinjąm'bʉ xtá nuhʉ ua ja ma häihʉ ra Israel tengu dí nuhʉ ya, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pɛ nu ʉ yʉ fariseo sä i ɛ̨na: ―Nuna ran 'yohʉ i høn a thi yʉ zįthu nangue rán t'ɛ̨di bi un'na rá hmu yʉ zįthu, sä i ɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nɛ nu ra Jesús nząi mi pa bʉ ja yʉ hnini nɛ min xänbate bʉ ja yʉ niją, nɛ mim mam bʉ ran ho ma'da'yo ngue 'bɛpʉ ní manda rá ts'ɛdi Oją. Nɛ midí hoqui hønt'a go man ʉ mi hɛ̨mb yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nɛ bi huɛ̨c'ʉ yʉ ją'i a ra Jesús nguetho mi 'bʉi tengu'bʉ yʉ dɛ'yo 'bʉ njon midí jamansu, i 'yodumbʉi thoho. ");
INSERT INTO otmNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Nɛ bi 'yɛ̨ngähe ngue yʉ́ xädigähe: ―Majuąni dí xi ahʉ, xʉn ngu yʉ ją'i i 'bʉi ngue di däp rá mbʉi Oją 'bʉ 'bo'o da xifi nangue'a, pɛ hingui ngu i 'bʉi ngue da xifi. Nde'bʉ gui 'yäfʉ Oją di un ra 'bɛfi mi'da da mbäx'a rá 'bɛfi. Tengu'bʉ i ja n'da ra huąhi xʉ 'yot'i, nɛ hingui ngu yʉ mbɛfi, nɛ da 'yäp'a ra mɛhuąhi mi'da yʉ mbɛfi 'dahma da xoc'a n'dihi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nɛ nu ra Jesús bʉya bi zängahe dí 'dɛ'mayoho gähe yʉ́ xädigähe, nɛ bi 'daje rán t'ɛ̨di ga hømhbe thi yʉ zįthu nɛ ga hoje 'bɛ'a gä nín ʉ i hɛ̨mb yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nɛ nugähe 'dɛ'mayoho bi zängahe, m'bɛt'o ra Simón, gue'a ra Pedro, nɛ'a ra Andrés rán 'yohʉ a ra Pedro. Nɛ ra Jacobo nɛ a ra Xuua rán 'yohʉ a ra Jacobo, ngue gätho yoho yʉ́ ts'ʉnt'ʉ ra Zebedeo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nɛ ra Felipe, nɛ ra Bartolomé, nɛ ra Tomás, nɛcä dra Mateogä ngue min hącahäigä, nɛ ra Jacobo rá ts'ʉnt'ʉ ra Alfeo, nɛ ra Lebeo ngue gue'a rá thuhu ra Tadeo; ");
INSERT INTO otmNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nɛ ra Simón t'ɛ̨mbi ra cananista; nɛ ra Judas Iscariote, gue'a xí dä a ra Jesús. Nɛ guecähe 'dɛ'mayoho bi huangähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nɛ nu'bʉ mí zängahe dí 'dɛ'ma yohogähe bi 'yɛ̨nje: ―Nuya hin gui mbähä bʉ i 'bʉ ʉ him ma mijudíohʉ, dyʉ israelhʉ. Xínga guepʉ ra xɛqui Samaria gui mbähä. ");
INSERT INTO otmNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pɛ nuya gui mbähä bʉ 'bʉ ʉ ma mɛnguhʉ yʉ israel. Nu'ʉ i 'bʉi tengu yʉ dɛ'yo bi 'bɛh ra 'yu in nde xtán donspʉ ja ran dąte. ");
INSERT INTO otmNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nɛ nubʉ hapʉ gui mbähä gui 'yɛ̨mfʉ: “Damin umhbʉ ya ngue di manda ahʉ rá ts'ɛdi Oją,” bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gui hojʉ ʉ i hɛ̨mp'a ra t'axca'ya, nɛ hønt'a go man ʉ i hɛ̨mb yʉ ją'i, nɛ gui xoxhʉ ʉ xøn du, nɛ gui hyømhbʉ thi yʉ zįthu in 'yohʉ 'da yʉ ją'i. Nɛ nu'bʉ gui 'yøthʉ ʉ, hin gui 'yäh nin zäbihʉ, nguetho hin dá pä ahʉ a ma ts'ɛdigä, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nɛ hin te ma mbɛti gui hyąxhʉ 'bʉ gá mbähä, bi 'yɛ̨ngähe. ");
INSERT INTO otmNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nɛ xín ni tu'døzą gui tuxhʉ, nɛ hønt'a ni he guí hehʉ nɛ hønt'a ni thįxfani gui 'yʉthʉ, nɛ hin'yʉ 'bɛ'a gui hyąxhʉ, nguetho nubʉ gui sømhbʉ i ja nin t'ɛ̨di ngue da zimanho ahʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nɛ nu'bʉ gá sømhbʉ bʉ ja yʉ́ hnini ma mi israelhʉ gui 'yänhdʉ hapʉ 'bʉ a n'da ran 'yohʉ ngue ra hocją'i nɛ nu'a gätho yʉ ją'i i numansu a. Nɛ guepʉ gam 'bʉhmbʉ bʉ, jague'bʉ gui thohmbʉ bʉ man'da ra hnini mahøn'a, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu'bʉ gá sømhbʉ bʉ ja rá ngu, gui zɛnguahʉ, gui 'yäfʉ rán jąpi Oją nangue'a. ");
INSERT INTO otmNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nɛ nu'bʉ rán säui a da 'yøt'ahʉ ʉ yʉ mɛngu bʉ hapʉ gui sømhbʉ, Oją di un rán jąpi gá 'yäfʉ bʉya. Pɛ nu'bʉ hin'na, tengutho 'bʉ nte gamí 'yäfʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nɛ nubʉ hapʉ gui sømhbʉ, nu'bʉ hin da zimanho ahʉ nɛ hingui nde da 'yømanho a guí xihmbʉ, dami pømhbʉ bʉ nɛ gui huąjʉ yʉ bøhäi ni guahʉ. Nu'a nam bøn'a gui sohmbʉ bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nɛ majuąni dí xi ahʉ, nu yʉ mɛngu bʉ i ja n'da ra hnini hin da zimanho ahʉ, pɛ nu'bʉ bin ja ra pa ran juąnbi, man'da ɛ̨mmɛ xʉn ʉ tho da nu, xinda gue'ʉ mí 'bʉpʉ maya'bʉ bʉ ja ra hnini Sodoma nɛ ra hnini Gomorra, bi 'yɛ̨nje a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nɛ xø bi 'yɛ̨na: ―Nuya hønbʉ go hapʉ ga pɛn'nahʉ, ɛ̨mmɛ di ʉn'nahʉ ʉ 'bʉpʉ, tenguthoho yʉ zate di ʉnba yʉ dɛ'yo. Damim fähmbʉ tengu yʉ c'ɛ̨ya nɛ gui 'yøthʉ tengu øt' yʉ t'azʉ, hønt'a ran ho gui 'yøthʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nɛ gam fähmbʉ, nguetho nu yʉ ją'i di dä ahʉ bʉ 'bʉh yʉ ngʉrpi bʉ ja yʉ niją, nɛ da mbɛp'ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nɛ da zix'ahʉ bʉ 'bʉh yʉ zɛ'mi nɛ yʉ ts'ʉt'abi, nguetho guí ɛ̨c'yɛigahʉ, pɛ hinga ndetho da zix ahʉ bʉ. Nguetho nu'bʉ da zix ahʉ bʉ, da zä gui xihmbʉ yʉ zɛ'mi nɛ yʉ ts'ʉt'abi nangue ma thuhugä, n'dahma nɛ ʉ yʉ judío nɛ ʉ i thąnde yʉ́ oją zɛhɛ da 'yøde nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nɛ nu'bʉ da ts'ix ahʉ bʉ 'bʉh yʉ ts'ʉt'abi, o guí hądumbʉihʉ 'bɛ'a guim mamhbʉ o gue'bʉ da zä gan yąhʉ uague hin'na, nguetho Oją di 'da ahʉ ran 'yomfɛ̨ni 'bɛ'a gui mamhbʉ 'bʉ bi mba ma juąn'ni ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nguetho hinga guesɛ ahʉ gan yąhʉ 'bʉ bi mba ma juąn'ni ahʉ, pɛ gue'a rá Hogandąhi Oją ma Tahʉ din yą, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nɛ dim 'bʉ i 'da di däsɛ yʉ́n 'yohʉ da mba ntho. Nɛ nu'ʉ 'da di däsɛ yʉ́ ts'ʉnt'ʉ bʉ 'bʉh ra zɛ'mi da tho. Nɛ dim 'bʉ i 'da yʉ ts'ʉnt'ʉ di yąp zɛhɛ yʉ́ ta ngue da tho. Nɛ din jabʉ da t'ørpa ʉ i ɛ̨c'yɛigui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nɛ gätho na ndoho ra ximhäi da ts'an ahʉ nangue guí tɛngahʉ, pɛ nu'bʉ gui hyäthʉ gue'bʉ go ran zɛgui, gui tąha gan yąmhbʉ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nɛ nu'bʉ n'da ra hnini di ʉc'ahʉ, dami 'dahmbʉ bʉ, nɛ gui mbähä bʉ man'da ra hnini bʉya. Nɛ majuąni dí xi ahʉ, hin gní täthʉ gätho yʉ hnini Israel gui xihmbʉ rám hma Oją nɛ gui 'dahmbʉ, 'bʉ bá pengä. ");
INSERT INTO otmNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Nɛ tengu thoho n'da ra xädi hin da t'ɛ̨mbi xʉn ho 'bʉ him bi t'ɛ̨mbi xʉn ho rá xänbate; nɛ hin da hnumanho n'da ra 'yɛ̨hɛ 'bʉ him bi hnumanho rá hmu. Nɛ din jabʉ da 'yøt'ahʉ, hin da numanho ahʉ yʉ ją'i, tengu thohogui him bi hnumanhogui, nɛ i t'ɛ̨ngui drá zįthu, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","―Janangue'a hin gui suhʉ 'bɛ'a da 'yøt'ahʉ yʉ ją'i, guehma gui mamhbʉ a dí xi ahʉ. Hin gui cømhbʉ a. ");
INSERT INTO otmNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nu'a dí xi ahʉ ua njonguin nu, dami mamhbʉ bʉ 'bʉh yʉ ją'i, nɛ nu'a dí xi ahʉ njongui øde, dami mbahmbʉ bʉ ja yʉ hnini, da t'øpʉ 'bɛ'a gätho dá xi ahʉ ya, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nɛ o guí suhʉ ʉ in nde da hyo ahʉ, hin'yʉ yʉ́ ts'ɛdi nɛ'a ni mbʉihʉ di juat'ahʉ. Man'da xʉn ho 'bʉ gui suhʉ a Oją, nɛ hønt'a i sä di ʉn'na ni ją'ihʉ nɛ ni mbʉihʉ bʉ ja ran ʉnbi maząi, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Janangue 'yo guí hądumbʉihʉ, guim bɛ̨mhbʉ yʉ doja i 'bä bʉ ja yʉ täi, hingui ngu di muui, pɛ nu'ʉ xínga n'da da du 'bʉ hin rá pähä Oją da du. Janangue'a guim bɛ̨mhbʉ, hin'yʉ 'bɛ'a din ja ahʉ 'bʉ hin rá pähä Oją din ja. Nguetho man'da di mu ahʉ bʉ na nu Oją xinda gue ʉ yʉ doja, nɛ i pądi gätho nangue ahʉ. Janangue'a hin gan suhʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","―Nɛ gätho to'o da mam bʉ 'bʉh yʉ ją'i ngue i tɛngä, nɛcä gam ma bʉ 'bʉh ma Ta nubʉ mahɛ̨ts'i nangue ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pɛ nu'a to'o din cøm bʉ i 'bʉh yʉ ją'i nanguecä, nɛcä xin ga cøm bʉ bí 'bʉh ma Ta bʉ mahɛ̨ts'i, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","―Nɛ hin guim bɛ̨mhbʉ ngue bá ɛ̨cä da zɛh yʉ sʉi, pɛ man'da din ja yʉ sʉi nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Nu yʉ 'yɛ̨c'yɛi da ts'ʉpʉ ja rá ngusɛ, nu'bʉ hing yʉ 'yɛ̨c'yɛi 'bʉpʉ. Nu yʉn 'yohʉ din sʉhmbʉ yʉ́ ta, nɛ nu yʉ xisu bʉya din sʉhmbʉ yʉ́ mbe nɛ ʉ yʉ́ cä, nangue ʉ hingui ɛ̨c'yɛigui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pɛ nu'bʉ n'da ra ją'i man'da im bɛ̨n'a rá ta nɛ rá mbe xínda guecä, hin ga ɛ̨mbi ngue rá hmugui. Nɛ nu'bʉ n'da ra ją'i man'da im bɛ̨n'a rá ts'ʉnt'ʉ nɛ rá t'įxu xínda guecä, ngutho ʉ hin da zä ga ɛ̨mbi ngue rá hmugui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pɛ nu'bʉ 'bo'o ɛ̨na i tɛngui nɛ hingui hät' yʉn ʉnbi da t'ørpe, nɛcä xín ga ɛ̨mbi rá hmugui. ");
INSERT INTO otmNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nɛ nu'a to'o da zu da thącpa rá te nanguecä, da mba ma ʉnbi bʉ ja ran dąte rá te a, pɛ nu to'o hin da zu da thącpa rá te nanguecä, hin da mba ma ʉnbi bʉ ja ran dąte a, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Nu'a to'o da zimanho ahʉ, nɛcä xin bi zimanhogui, nɛ'a bá pɛngä xim bi zimanho a. ");
INSERT INTO otmNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nɛ nu'a to'o da zimanho n'da rá pøngahyą Oją nangue a ra 'bɛfi i øt'e, 'da'angu ran ho din t'unui a ra pøngahyą. Nɛ nu'bʉ 'bo'o da zimanho n'da ra hocją'i nangue a ran hocją'i i øt'e, 'da'angu ran ho din t'unui a. ");
INSERT INTO otmNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nɛ nu'bʉ n'da ra ją'i i ja 'bɛ'a di un'na n'da ma xädigä ngue'a i tɛngui, madague'bʉ hønt'i ts'ʉ ra dehe di unni, pɛ nɛ a i ja 'bɛ'a din t'unni ngue man'da xʉn ho, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nu'bʉ mi gua a man ra Jesús bʉya, bi mbɛngähe dí 'dɛ'mayohogähe. Nɛ n'danni bi mbasɛ ra Jesús bʉya. Bi mba bin xänbate bʉ mi'da yʉ hnini bʉ ra häi Galilea. ");
INSERT INTO otmNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nɛ mi ofädi ra Xuua Nxixyą, nɛ bi sifi 'bɛ'a gätho bi 'yøt'a ra Cristo, janangue'a bi mbɛn'ndʉ yoho yʉ́ xädi a ra Xuua. Nɛ nu'bʉ mi zøm bʉ 'bʉh ra Jesús, ");
INSERT INTO otmNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bi 'yänni: ―Ha gue'e gra Cristo, gra Thahni i Oją, ngue mi hma ba ɛ̨hɛ, uague ga thoqui ga tømhbʉ, bi 'yɛ̨n'ʉ yʉ́ xädi ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Nu ra Jesús bʉya bi 'yɛ̨mp'ʉ yʉ́ xädi ra Xuua: ―Ni mbɛ bʉ, gui xihmi a ra Xuua 'bɛ'a gätho guí øhmi, bi 'yɛ̨mbi. Dami xihmi 'bɛ'a guín nuui, ngue nu yʉ xädä bin zø yʉ́ dä ya, nɛ'ʉ yʉ dogua i 'yo, nɛ'ʉ mi hɛ̨mb ra t'axca'ya ya bi yąn ʉ, nɛ'ʉ yʉ gogu ya i øhnahyą ya, nɛ'ʉ 'da xøn du i pa nsots'i, nɛ yʉ hyoya i si a ram hma ngue 'bɛpʉ dím pø ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mająpi ʉ to'o hin di ʉ't' yʉ́ mbʉi nanguecä, bi 'yɛ̨n'a ra Jesús 'bʉ mi 'yɛ̨mp'ʉ yʉ́ xädi ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nɛ nu'bʉ mi mbenc'ʉ yʉ́ xädi ra Xuua, nu ra Jesús bi xih yʉ ją'i 'bɛ'a øt' ra Xuua, nɛ bi 'yɛ̨mbi: ―'Bɛ'a guí mbähä guin nuhʉ bʉ ja ra dąpo 'bʉ mi 'bʉpʉ ra Xuua. Ha gá mbähä gbá nuhʉ n'da tengu ra xithi i ɛn ran dąhi. ");
INSERT INTO otmNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Uague gá mbähä gbá nuhʉ n'da ran 'yohʉ mahotho rá he mí he. Pɛ guí pąhmbʉ to'o mahotho yʉ́ he i 'bʉpʉ ja yʉ ngunts'ʉt'abi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Uague gá mbähä gbá nuhʉ n'da rá pøngahyą Oją. Majuąni ngue gán nuhʉ n'da rá pøngahyą Oją, nɛ nu'a, man'da xʉn hɛ̨ts'i rá ts'ɛdi a xínda gue'ʉ gä mi'da yʉ pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nguetho gue'a ra Xuua a mí hmam bʉ ja rám hman Oją maya'bʉ 'bʉ mí 'yɛ̨na: M'bɛt'o ga pɛhna n'da ran 'yohʉ ngue mam 'bɛhni da xih yʉ ją'i ngue da døp'e'e xʉn ho, bi 'yɛ̨n Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Majuąni dí xi ahʉ, njon mí 'bʉh man'da ran 'yohʉ man'da xʉn hɛ̨ts'i nangue a rá 'bɛfi bin t'unni xínda gue a ra Xuua. Pɛ hønt'a go to'o din uni ngue di manda rá ts'ɛdi Oją, madague'a hingui hɛ̨ts'i rá 'bɛfi din t'unni, pɛ man'da xtán hɛ̨ts'i bʉ dí nɛqui, xinda guepʉ ni nɛqui a ra Xuua ya, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Asta gue'bʉ mi dʉmp' rá 'bɛfi ra Xuua nɛ guehya, i honi da yʉrpʉ di manda rá ts'ɛdi Oją yʉ ją'i. Nɛ nu'ʉ i humbi i honi, da dąha da yʉrpʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nɛ gue'a bi man ʉ yʉ pøngahyą maya'bʉ ʉ bin ja, nɛ mí ɛ̨m bʉ ja yʉ́n t'ɛ̨di Oją, nɛ gue'ʉ mí man ʉ 'bʉ hín nim 'bʉh ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nɛ nu'bʉ guí ɛ̨c'yɛi a dí xi ahʉ, gui pąhmbʉ ngue tengu'bʉ da gue a ra Elías a ra Xuua, ngue gue'a ra Elías guí tømhbʉ ngue mí 'bʉh maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nɛ nu'bʉ 'bo'o i ja rá zagu di jamansu a dím mangä ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ga xi ahʉ 'bɛ'a guí øthʉ ya, ngue nte guí ʉrpahʉ ra güɛnda. Guí øthʉ tengu i øt' yʉ t'ʉhni 'bʉ in ɛ̨ni. Din sʉsɛ ʉ, nɛ i xih yʉ́ mit'ʉhnihʉ: ");
INSERT INTO otmNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Dá pixt' mam 'bixt'i pɛ hin gá 'yʉrpahʉ ra güɛnda, nɛ hin gán nɛ̨hmbʉ,” i ɛ̨n'ʉ 'da. “Pɛ nugähe dá pɛ'be n'da ra 'bɛi ngue tengu'bʉ xøn du n'da, pɛ nte gá bɛ̨mhbʉ nɛ hin gán zomhbʉ,” i ɛ̨n'ʉ mi'da yʉ t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nɛ ngutho guí øthʉ, hin gá 'yʉrpahʉ ra güɛnda a ra Xuua, ngue him mi ho yʉ́n sihmɛ nɛ him bi zi ra vino, pɛ gá 'yɛ̨mdahʉ in 'youi ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pɛ nugä, dán ją'igä ua ja ra ximhäi, xʉn ho man ts'ihmɛ 'bʉ n'dandį nɛ ma ts'ithegä, pɛ xínga guecä guí ʉrcahʉ ra güɛnda. Pɛ guí xijʉ yʉ fɛhni, guí ɛ̨njʉ: “Nuna ran 'yohʉ ran zäthu nɛ ra mihni na, nɛ yʉ́ amigo yʉ ts'om'bäi nɛ yʉ ziyate hyącahäi,” guí ɛ̨njʉ. Pɛ Oją i pądi 'bɛ'a xʉn ho da 'yøt'e ngue bi zänga'be, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nɛ man'da ram hma bi man ra Jesús nangue yʉ hnini bʉ bi 'yøt'e xʉn ngu yʉ́n t'øt'e mixte. Nguetho nu yʉ ją'i bʉ, njąm'bʉ bi nde bi päh yʉ́ mbʉi, madague'a bi nu yʉ́n t'øt'e mixte. Nɛ bi 'yɛ̨n'a ra Jesús: ");
INSERT INTO otmNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Huɛ̨hi maha ahʉ gyʉ mɛnguhʉ bʉ ra hnini Corazín nɛ ra hnini Betsaida, nguetho nu'bʉ xcá øt'ä yʉn t'øt'e xcá ut'ahʉ bʉ ja ra hnini Tiro nɛ ra hnini Sidón, xtán du yʉ́ mbʉi nangue ran ts'o mí øt'ʉ nɛ xtí päh yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Janangue'a nu'bʉ bi zøn ra pa din ja ran juąnbi, man'da xʉn ʉ tho ran ʉnbi gui nuhʉ xinda gue ʉ 'bʉpʉ Tiro nɛpʉ Sidón, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ngutho ahʉ gyʉ mɛnguhʉ ra hnini Capernaum. Masque guí ɛ̨mhbʉ man'da xʉn hɛ̨ts'i rá ts'ɛdi ni hninihʉ xínda gue ʉ mi'da. Pɛgue hin'na, guehma da mba ma juadi ahʉ. Nguetho nu'bʉ xcá øt'ä yʉn t'øt'e mixte bʉ ra hnini Sodoma tengu dá ørpʉ ja ni hninihʉ, hin xtán guadi nangue ra sibi, nguetho xtím päh yʉ́n 'yomfɛ̨ni yʉ mɛngu bʉ, nɛ guexta'a di jat'a ra hnini ya. ");
INSERT INTO otmNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pɛ guehma majuąni dí xi ahʉ, 'bʉ bin ja ran juąnbi, man'da xʉn ʉ tho ran ʉnbi gui nuhʉ, xínda gue a da nu yʉ mɛngu bʉ ra hnini Sodoma, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nɛ nubʉya nu ra Jesús bin yąui Oją nɛ bi 'yɛ̨na: ―Ma Ta i, gra Hmu mahɛ̨ts'i, nɛ gra Hmu ua ja ra häi, jamadi ya ngue gá japi him bi bą'a ram hma nangue ni ts'ɛdi ʉ im bɛ̨nsɛ ja yʉ́n 'yomfɛ̨nisɛ, pɛ gá japi bi bądi nangue'e ʉ i hon'a'i, tengu yʉ t'ʉhni ngue hin te i pądi. ");
INSERT INTO otmNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nɛ gue'a gá 'yøt'e ma Ta i, ngue gue'a gá numanhosɛ guí øt'e, bi 'yɛ̨n'a ra Jesús 'bʉ min yąui Oją rá Ta. ");
INSERT INTO otmNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nɛ xø bi 'yɛ̨mp'ʉ yʉ ją'i bʉya: ―Gätho 'bɛ'a i ja, bi 'dacä ma Ta. Nɛ njon da bąqui xʉn ho, hinda hønt'a ma Ta i pąqui. Nɛ njon da bądi xʉn ho ma Ta, hinda høngdä ngue rá Ts'ʉnt'ʉgui dí pącä a, nɛ ʉ ngue ma pähä ga japi da bądi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","Nɛ nu'bʉ gá yähmbʉ nɛ gán xømbʉihʉ nangue 'bɛ'a gätho guí øthʉ, ba ɛ̨hmbʉ gui tɛngahʉ, nɛ nugä ga hut'a ni mbʉihʉ. Nɛ nu'a ra 'bɛfi dí 'da ahʉ hingui hɛ̨i a, tengu'bʉ dí huthʉ ran thuyą dín hyanbahʉ ya. Nɛ nugä dí sɛt ma mbʉi nɛ hin'yʉ ran 'yɛ̨ts'i ma mbʉi, nɛ ga xän'nahʉ ngue njabʉ gui 'yøthʉ, nɛ ga hut'a ni mbʉihʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nɛ nu'a n'da ra pa mi 'yo a ra Jesús bʉ ja yʉ huąhi. Nɛcähe dá mbähmbe yʉ́ xädigähe a, 'bʉ ra pa ran ts'äya. Dá ndehmɛhe nɛ dá tʉje 'da yʉ trigo. Dá tɛ̨nt' ma 'yɛhe ʉ yʉ trigo nɛ dá sahe. ");
INSERT INTO otmNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nu yʉ fariseo bi nu 'bɛ'a dá øthe nɛ bi 'yɛ̨mp'a ra Jesús: ―Nu ni xädi bi 'yøt'a hin xtá 'yøt'e, nguetho bi 'yøt'a n'da ra 'bɛfi ra pa ran ts'äya, 'bʉ mi dʉc yʉ trigo. ");
INSERT INTO otmNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nɛ bi dą'a ra Jesús, bi 'yɛ̨mbi: ―Ha hin gán nuhʉ bʉ ja ni søcuąhʉ, ngue nɛ a ra David bi mbɛsta a rán t'ɛ̨di Oją 'bʉ mi mbähä ʉ 'da, nɛ bin tumanthuhu, má hin'yʉ 'bɛ'a da zi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Janangue'a bi yʉrpʉ ja rá ngu Oją, bi zi ʉ yʉ 'bøxthuhmɛ him mi sä da zi ʉ, pɛ hønt'ʉ yʉ mbäją mi si ʉ. Pɛ hin guí ɛ̨mhbʉ bi 'yøt' ra ts'oqui ra David, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Uague hin guím bɛ̨mhbʉ 'bɛ'a mam bʉ ja rán t'ɛ̨di ra Moisés nangue yʉ mbäją 'bʉpʉ ja ra niją, ngue nɛ'bʉ ra pa ran ts'äya i øt' yʉ́ 'bɛfi. Pɛ hing ra ts'oqui a i øt'e, nguetho guepʉ ja ra niją dim pɛfi. ");
INSERT INTO otmNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nɛ nugä dí xi ahʉ, man'da xʉn hɛ̨ts'i ma ts'ɛdigä xínda gue ra niją, hanja guí ɛ̨mhbʉ bi 'yøt' ra ts'oqui ma xädigä, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pɛ nu ahʉ hin guí pąhmbʉ 'bɛ'a nam bøn'a im ma bʉ ja rám hman Oją ngue i ɛ̨na: “Nugä man'da dí nde din ja nin huɛ̨catehʉ, xinda gue gui hyohʉ yʉ zu'uɛ̨ ngue gui pøscahʉ,” i ɛ̨n Oją, bi 'yɛ̨n'a ra Jesús. Nu'bʉ xquí pąhmbʉ 'bɛ'a nam bøn'a, hin xcami yąfʉ ʉ hin'yʉ yʉ́ ts'oqui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nɛ nugä guecä dán ją'igä ua ja ra ximhäi, drá hmu, nɛ i ja man t'ɛ̨di ga mangä 'bɛ'a da 'yøt' yʉ ją'i ra pa ran ts'äya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nɛ bi thoh pʉya nɛ bi yʉrpʉ ja ra niją. ");
INSERT INTO otmNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nɛ nu yʉ́n sʉihʉ a ra Jesús mi nde xtán dįnba n'da ra ts'oqui ngue mi sä xtí yąpi, nɛ bi t'ɛ̨mp'a ra Jesús: ―Ha da zä da mba ma hoqui a ra pa ran ts'äya n'da ra hyɛ̨nni, uague hin'na, bi 'yɛ̨n'ʉ. Nguetho mí 'bʉpʉ n'da ran 'yohʉ ngue ra mbɛdi rá 'yɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nɛ bi dą'a ra Jesús: ―Ha i 'bʉ a n'da ahʉ ngue nu'bʉ ni dɛ'yohʉ da däpʉ ja ra hyąhäi gue'bʉ ra pa ran ts'äya, ha hin gui jʉxhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ha má guet'a n'da ra ją'i ngue hin da zä da t'ørpa ran ho 'bʉ ra pa ran ts'äya. Nɛ nu'a, man'da di muui xinda gue yʉ dɛ'yo, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nɛ nubʉya, bi 'yɛ̨n'a ra Jesús: ―Dami juąn ni 'yɛ, bi t'ɛ̨mp'a ran 'yohʉ. Nɛ bi juąn bʉya. Nɛ 'bex bi gohi xʉn ho tengu man'da rá 'yɛ xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nɛ nu yʉ fariseo ɛ̨mmɛ bin cuɛ bʉya. Bi bøm bʉ ja ra niją, bi nyąsɛ ʉ 'bɛ'a dí zä da hyo ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nɛ nu'bʉ mi bɛ̨n'a ra Jesús 'bɛ'a mi nde xtá 'yørpa ʉ yʉ fariseo, bi bøm bʉ bʉya, bi mba n'danni, nɛ ɛ̨mmɛ xʉn ngu yʉ ją'i bi numanho da dɛnthoho. Nɛ gätho midín hyɛ̨nni bi hoc'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nɛ bi xi ʉ njon da xifi to'o a bi hoqui. ");
INSERT INTO otmNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nɛ nu'a bi 'yøt'a ra Jesús ngue njon bi ndepe da xifi, bin thɛui a mi hma maya'bʉ 'bʉ mi 'yɛ̨n'a ra pøngahyą Isaías: ");
INSERT INTO otmNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nuna guehna ma 'yɛ̨hɛgä dá huahni ngue ɛ̨mmɛ didí huɛ̨cä nɛ i hurca ma mbʉi, ga un ma Hogandąhi ngue da xi ʉ i thąnde yʉ́ oją zɛhɛ, nangue ran juąnbi ga øt'ä 'bʉ ran zɛgui ra pa. ");
INSERT INTO otmNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nɛ hin din sʉte a nɛ xín dim mbatho, nɛ hingan ts'ɛdi din yą hapʉ din 'yo. ");
INSERT INTO otmNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nɛ nu'ʉ in ja tengu'bʉ ra xithi bi domp' ran dąhi, da xots'i mahøn'a. Ngutho ʉ in ja tengu n'da ra sibi mi ts'ʉtho da huɛ̨zɛhɛ, di japi ngue da dɛ xʉn ho mahøn'a, asta gue'bʉ bi zøni dim hmu xʉn ho ua ja ra ximhäi, nɛ din jabʉ da 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nɛ gätho yʉ ją'i 'dahma 'dan'yo bʉ na yą da dømp' ran ho da 'yørpa ʉ, i ɛ̨n Oją, bi 'yɛ̨n'a ra Isaías maya'bʉ. Gue'a bi ma nangue ra Cristo rá Thahni Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nɛ n'da ran 'yohʉ min 'youi ra zįthu nɛ mi xädä nɛ mi gore, bi ts'ixpʉ 'bʉ a ra Jesús, ngue di hoqui. Nɛ 'bexgue bin zø yʉ́ dä, nɛ bi nyą bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nu'ʉ gätho bi nu 'bɛ'a bi 'yøt'e bi hyonya thoho ʉ, nɛ bi 'yɛ̨na: ―Masque guehna mi man ʉ yʉ pøngahyą, ngue rám bom'bɛto ra David, ngue rá Thahni Oją, bi 'yɛ̨n'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nɛ nu yʉ fariseo 'bʉ mi 'yøde 'bɛ'a i man yʉ ją'i, bin cuɛ ʉ, bi 'yɛ̨na: ―Nuna ran 'yohʉ na i høn a thi yʉ zįthu nguetho in 'youi rá ts'ɛdi a yʉ́ hmu, sä ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Nɛ 'bex bi bą'a ra Jesús 'bɛ'a mim bɛ̨n'ʉ yʉ fariseo nɛ bi 'yɛ̨mp'ʉ: ―Pɛ him majuąni guí mamhbʉ, nguetho nu ra zįthu hin da zä din sʉsɛhʉ yʉ́m fäts'ihʉ. Nu'bʉ din sʉsɛ din juasɛ yʉ́ ts'ɛdi ʉ 'bʉ, tenguthoho 'bʉ n'da ra ts'ʉt'abi din heque nɛ din tunhdʉ ʉ yʉ́m fäts'ihʉ, di 'bɛsɛ yʉ́ ts'ɛdi 'bʉ. Nɛ ngutho n'da ra hnini o gue n'da ra ngu 'bʉ din heque, pɛ gä dim 'bɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nu'ahʉ guí ɛ̨mhbʉ dín 'yo'be rá ts'ɛdi ra zįthu, janangue'a i sä dí høn a thi yʉ zįthu, sä guí ɛ̨mhbʉ. Pɛ xi'bʉ da gue'a dí øt'ä, ha in jabʉ ʉ guí xänbahʉ 'bʉ i høn a thi yʉ zįthu ʉ. Nɛ guesɛ ʉ i ut'ahʉ ngue him majuąni a guí mamhbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pɛgue rá Hogandąhi Oją dá høn a thi yʉ zįthu nɛ dá ut'ahʉ ngue ya di manda rá ts'ɛdi Oją ua guí 'bʉhmbʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nɛ tenguthoho n'da ran 'yohʉ 'bʉ i 'bʉpʉ ja rá ngu, hin njongui sä da yʉrpʉ 'bʉ hinga m'bɛt'o da mba nthurpi yʉ́ 'yɛ, nɛ nuya sä da yʉrpʉ nɛ da hyąspi 'bɛ'a gätho i ja bʉ. Dín jagä bʉ, him mí sä xcá mispa yʉ zįthu 'bʉ hin xcá tąpä ʉ yʉ́ hmu, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nɛ nu'a to'o hingui numansugui, man sʉi'be a. Nɛ nu'a to'o hingui øt' ma 'bɛfi i di japi dim 'bɛ ʉ mi'da, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Janangue'a dí xi ahʉ, hønt'a go má ts'oqui nɛ hønt'a go má ts'ore da man a n'da, i sä da mba ma punbi, pɛ nu'bʉ i man ra ts'ore nangue rá Hogandąhi Oją n'da, ya hin da zä da mba ma punbi n'da 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pɛ dí xi ahʉ, nu'bʉ 'bo'o da man ra ts'ore nanguecä, dán ją'igä ua ja ra ximhäi, pɛ i sä da mba ma punbi a. Pɛ nu'a da man ra ts'ore nangue rá Hogandąhi Oją, pɛ hin jąm'bʉ da mba ma punbi a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","―Pɛ nu'bʉ xʉn ho ran t'øt'e ngue dá høn a thi ʉ yʉ zįthu, nde'bʉ gui numanhojʉ 'bʉ, nguetho gui 'yɛ̨mfʉ xʉn ho ra za gue'bʉ xʉn ho rán dät'ä. Pɛ nu'bʉ hingui ho yʉ́n dät'ä gui 'yɛ̨mfʉ hingui ho ra za 'bʉ. Nguetho nu yʉ́n dät'ä i zʉpʉ da bą a n'da nda'a ní za a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nu ahʉ, tengu'bʉ yʉ́ mɛni ahʉ yʉ pozʉ. Hague dán zä gui mamhbʉ n'da ra nde xʉn ho 'bʉ xʉn ts'otho ahʉ. Nguetho nu'a i yupʉ rá mbʉi n'da, gue'a i pøn rá nde n'da, bi t'ɛ̨mp'ʉ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nu'a ran 'yohʉ i yuh ran ho rá mbʉi, hønt'a xʉn ho im ma, pɛ nu'a ran 'yohʉ xʉn ts'o, hønt'a im ma, nguetho xʉn yuh ran ts'o rá mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nɛ dí xi ahʉ ngue nu'a ra pa din ja ran juąnbi, gätho yʉ ją'i da mba ma juąnbi nangue a him bin 'yomfɛ̨ni 'bɛ'a í mba a bi man ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nɛ nangue yʉm hma gá mamhbʉ dí ts'än'nahʉ ran ʉnbi 'da ahʉ nɛ dí mba ma thøgue 'da ahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nɛ nubʉya, bi t'ɛ̨mp'a ra Jesús, bi 'yɛ̨mp'ʉ 'da ma ngʉrpihe yʉ fariseo nɛ yʉ xänbate niją: ―Gra xänbate, dami 'yurcahe n'da ra hmɛpya ngue'bʉ majuąni Oją bi 'da'a ni ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bi dą'a ra Jesús: ―Nu'ʉ xø 'uegue nangue Oją nɛ xʉn ts'o yʉ́ mbʉi, gue'ʉ i äh yʉ hmɛpya ʉ. Pɛ hin da t'ut yʉ hmɛpya ʉ, pɛ hønt'a n'da ra hmɛpya da t'uti, tengu bi 'yøt'a ra Jonás. ");
INSERT INTO otmNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngue tengu thoho ra Jonás, hyu pa nɛ hyu xui bi 'yo bʉ mbo rá foho n'da ra dąhuą, nɛ ngutho din jacä guecä dán ją'igä ua ja ra ximhäi, hyupa nɛ hyu xui ga o bʉ 'bʉ ʉ xʉn du, bi 'yɛ̨n'a ra Jesús 'bʉ mi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nɛ dí xi ahʉ, nu'ʉ mí 'bʉpʉ ra dąhnini Nínive 'darbʉ gam 'bähmbʉ ʉ 'bʉ bin ja ran juąnbi 'bʉ ran zɛgui, nɛ da 'yut'ahʉ i ja ni ts'oquihʉ. Nguetho nu'ʉ 'bex bi päh yʉ́ mbʉi 'bʉ mí 'yø a bi man a ra Jonás, pɛ nu ahʉ xø hin guín nde gui päh ni mbʉihʉ nangue'a dí mangä. Nɛ nugä, man'da xʉn hɛ̨ts'i ma ts'ɛdi xinda gue ra Jonás, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nɛ'a ra xisu min ts'ʉt'abi bʉ Sur, 'darbʉ gam 'bähmbʉ a 'bʉ bin ja ran juąnbi 'bʉ ran zɛgui. Nɛ da 'yut'ahʉ ngue i ja ni ts'oquihʉ. Nguetho nu'a yatho bá ɛ̨hɛ ngue mi nde da 'yø a 'bɛ'a bi man a ra ts'ʉt'abi Salomón nangue ran 'yomfɛ̨ni bi un Oją, pɛ nu'ahʉ hin guí nde gui 'yøhmbʉ a dím mangä. Pɛ nugä man'da i ja rá ts'ɛdi mam hmangä xinda gue ra Salomón, bi 'yɛ̨mp'ʉ yʉ fariseo a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","―Pɛ nu'a ran ts'o guidí hohʉ, din ja ahʉ tengu bi 'yøt'a n'da ra ją'i min 'youi n'da ra zįthu. Nɛ bi bøn a ra zįthu, bin 'yo bʉ ja ra 'yonhäi, mí honi hapʉ din säya pɛ him bi dįni hapʉ din säya. Nɛ bi mbeng bʉ ja rá mbʉi ra ją'i bʉ bá nɛts'i. ");
INSERT INTO otmNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Man'da xʉn ho 'bʉ ga peng bʉ bá nɛts'i,” bi 'yɛ̨nsɛ a ra zįthu. Nɛ nu'bʉ mi mbeng bʉya, bi zøm bʉ ja rá mbʉi a ra ją'i mahøn'a, nɛ bi nu tengu'bʉ n'da ra ngu ngue mán joqui bʉ rá mbʉi, nɛ njom mí 'bʉpʉ nguetho him bin ząm bʉ rám hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nɛ xø bi mba bʉya bá si mí yoto yʉ́ minzįthuhʉ ngue man'da ɛ̨mmɛ xʉn ts'o i øt'e, nɛ bi yʉrpʉ, bin säya bʉ rá mbʉi a ra ją'i. Nɛ man'da ɛ̨mmɛ xʉn ts'o bi 'yøt'a ra ją'i bʉya. Nɛ gan jahʉ bʉ, bi 'yɛ̨mp'ʉ yʉ ją'i a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nɛ nu ra Jesús mi yąhʉ yʉ ją'i 'bʉ mi zøm bʉ a rá mbe nɛ yʉ́n 'yohʉ. Bi zøm bʉ ja ra ngu mí 'bʉi. Pɛ him bi yʉrpʉ, bim 'bätho bʉ thi, mi nde xtín yąui a rá ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɛ nu'ʉ 'da bʉya bi xi a ra Jesús: ―I 'bäcua thi ni mbe nɛ nin 'yohʉ, nɛ in nde gan yąhʉ 'na, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nɛ bi dą a ra Jesús: ―Ga xi ahʉ to'o a ma mbe nɛ to'o ʉ man 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nɛ bi 'yut'ʉ yʉ́ xädi bʉya: ―I 'bʉcua ya ma mbe nɛ ma cu, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nguetho hønt'a go to'o i øt' rá pähä ma Ta bí 'bʉpʉ mahɛ̨ts'i, gue ʉ man 'yohʉ ʉ, nɛ gue'ʉ man ju ʉ, nɛ gue'ʉ ma mbe ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nɛ nubʉya bi bøn'a ra Jesús bʉ ja ra ngu mí 'bʉi, nɛ bi mba nín hupʉ ja ra ndendeją. ");
INSERT INTO otmNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nɛ ɛ̨mmɛ bim pɛti bʉ yʉ ją'i, janangue'a nu ra Jesús bi ndexpʉ ja n'da ra mbosa nɛ bi hyu bʉ. Pɛ hingui 'yo a ra mbosa, bá copʉ ndenthe. ");
INSERT INTO otmNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nɛ bi xänba ʉ yʉ ją'i, bi xi i 'da yʉn t'uti. Nɛ nu'a n'da ran t'uti bi mam bʉ, bi 'yɛ̨na: ―N'da ra mbomhmudä bi mba bʉ huąhi. ");
INSERT INTO otmNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nɛ nu'bʉ mi mbon yʉ hmudä, nu'ʉ 'da bi zo bʉ ja ra 'yu, nɛ bá ɛ̨h yʉ doja bi za ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nɛ nu mi'da yʉ hmudä bi zo bʉ ja yʉ 'bodo, 'bexgue bi bøts'e nguetho hingui pidi ra häi. ");
INSERT INTO otmNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pɛ nu'bʉ mambá pøx ra hyadi 'bexgue bi 'yot'ʉ nguetho him mi ja yʉ 'yʉ xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nɛ nu mi'da yʉ hmudä bʉya bi zo bʉ ja yʉ 'bo'uįni, nɛ bi bøx'ʉ yʉ hmudä. Pɛ nu'bʉ min te yʉ 'uįni bʉya bi go'mi, nɛ bim 'bɛdi. ");
INSERT INTO otmNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pɛ nu'ʉ 'da bi zo bʉ ja ra hogahäi, nɛ bin ja xʉn ho ʉ. Nu 'da bi ndø'a n'da ciɛnto, nɛ nu'ʉ 'da bi ndø'i hyąte, nɛ 'däte ma 'dɛt'a bi ndø ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pɛ nu'bʉ i ja ni zaguhʉ, dami jamansu 'bɛ'a dí xi ahʉ, bi 'yɛ̨mp'ʉ yʉ ją'i a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nɛ dá xihmbe ra Jesús bʉya, dá ɛ̨mfe: ―Hanja gní xänba yʉn t'uti yʉ ją'i, nɛ hingui pą ʉ 'bɛ'a nam bøn ʉ, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nɛ nu ra Jesús bi dąrcahe bʉya, nɛ bi 'yɛ̨nje: ―Nu ahʉ bin ja ahʉ gá pąhmbʉ a njom mi pąh mam'bɛt'o 'bɛpʉ ní manda rá ts'ɛdi Oją, pɛ nu'ʉ mi'da, him bin japi da bądi, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nɛ tengu thoho a ram hma i ɛ̨na: “Nu'a i ja, man'da xʉn ngu din t'unni, nɛ nu'a zi ts'ʉtho i ja, nɛ'a i ja da thąnba a,” gan jahʉ bʉ. Nu'ʉ i honi da bądi, man'da xʉn ngu da bądi. Pɛ nangue ʉ hingui honi da bądi, nɛ a zi ts'ʉ mi pądi da thąnba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Janangue'a yʉn t'uti thoho dí xi ʉ, nguetho i øde pɛ ɛ̨na gue'bʉ him bi 'yøde, nɛ i nu pɛ tengutho 'bʉ hin te xtá nu; him bi yʉt' yʉ́ mbʉi a dá xifi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nɛ majuąni i man'a ra pøngahyą Isaías nangue ʉ 'bʉ mi 'yɛ̨n'a: Gui 'yøhmbʉ pɛ hin gui pąhmbʉ 'bɛ'a gá 'yøhmbʉ. Nɛ gui nuhʉ pɛ hin gui pąhmbʉ 'bɛ'a nám bøn'a guin nuhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nguetho nu ni mbʉihʉ ɛ̨mmɛ xʉm mɛ̨tho, nɛ njąm'bʉ gui 'yøhmbʉ, tengu'bʉ njot'i ni guhʉ, nɛ njąm'bʉ gui nuhʉ, tengu'bʉ guidí ts'ąnt' ni dähʉ, nɛ hin jąm'bʉ i sä da bɛ̨n ni mbʉihʉ ngue dim pädi nangue ran ts'o, ngue ga nyąn ahʉ, i ɛ̨n Oją, bi 'yɛ̨n'a ra pøngahyą Isaías 'bʉ maya'bʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pɛ nu'ahʉ mająpi ahʉ nguetho i nu ni dähʉ nɛ i øh ni guhʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Majuąni dí xi ahʉ ɛ̨mmɛ xʉn ngu yʉ́ pøngahyą Oją nɛ xʉn ngu yʉ ją'i ngue 'dat' Oją mim bɛ̨ni, mí nde xtá nuna gätho guí nuhʉ ya, pɛ him bi zä bi nu; nɛ ɛ̨mmɛ mí nde xtá 'yøhna guí øhmbʉ ya, pɛ him bi zä bi 'yøde, nguetho him mí zøn ra ora xtám bądi, bi 'yɛ̨ngähe dyʉ xädigähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","―Nɛ nuya ga xi ahʉ 'bɛ'a nam bøn'a rán t'uti a ra mbomhmudä, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nɛ nu'a to'o bi sih ram hma ngue di manda ua rá ts'ɛdi Oją, nɛ him bi bądi 'bɛ'a nam bøn'a, in ja tengu ʉ yʉ hmudä bi zo bʉ ja ra 'yu, nɛ 'bex bá ɛ̨'a ra zįthu bi hyąx a ra hmudä bi thupʉ ja yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nɛ nu'ʉ yʉ hmudä bi zo bʉ ja yʉ do, tengu'bʉ n'da ra ją'i ɛ̨mmɛ di johya 'bʉ ja bi 'yø a ram hma, pɛ maxøts'e thoho. ");
INSERT INTO otmNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nɛ hinga gätho mbo yʉ́ mbʉi, nguetho hin'yʉ yʉ́ 'yʉ xʉn ho, nɛ go zi ts'ʉ din ʉnbi nangue a ram hma, 'bexgue da 'uegue. ");
INSERT INTO otmNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nɛ nu'a ra hmudä dá xi ahʉ bi zo bʉ ja yʉ 'uįni, nam bøni tengu n'da ra ją'i bi 'yø a ram hma, pɛ hønt'a ɛ̨mmɛ im bɛ̨n ra ximhäi nɛ ra mbɛti ngue i hät'i, janangue'a bi japi bim 'bɛ a nɛ hin te bin ja rá 'bɛfi Oją nangue'a ra ją'i tengu a. ");
INSERT INTO otmNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pɛ nu'a ra hmudä dá ma ngue bi zo bʉ ja ra hogahäi, nam bøni tengu ʉ i ømanho a ram hma nɛ i pądi 'bɛ'a yʉ́n thɛhʉ a, nɛ din te xʉn ho ʉ nɛ da ndøgue tengutho yʉ hmudä, ngue nu'ʉ 'da bi ndø'a n'da ciɛnto, nɛ'ʉ 'da bi ndø a hyąte, nɛ ʉ 'da bi ndø a 'däte ma 'dɛt'a. ");
INSERT INTO otmNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nɛ nu ra Jesús bʉya bi xih mi'da yʉn t'uti ʉ yʉ ją'i, nɛ bi 'yɛ̨mbi: ―Nu'bʉ bi 'yøt' ran ts'ʉt'abi Oją, in ja tengutho 'bʉ n'da ra ją'i bi du a n'da yʉ hmudä xʉn ho bʉ ja rá huąhi. ");
INSERT INTO otmNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pɛ nu'bʉ mín xui nɛ gätho bin ąha, bi mba a rán sʉiui nɛ 'darbʉ bi duhmi a n'da yʉ hmudä hingui ho bʉ ja rá huąhi, nɛ bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nɛ nu'bʉ mí bøx bʉya, bi bøx'ʉ xʉn ho nɛ ʉ hingui ho, 'darbʉ bi bøts'e. ");
INSERT INTO otmNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nɛ nu'ʉ yʉ́ 'yɛ̨hɛ bʉya bi mba bi xi ʉ yʉ́ hmu: “Nu yʉ hmudä gá tupʉ ja ra huąhi, xʉn ho 'bʉ gmi tuhu, hapʉ bi nɛqui ʉ yʉ hmudä hingui ho,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nɛ nu ʉ yʉ́ hmu bʉya bi 'yɛ̨mbi: “Nɛ masque n'da man sʉi'be bá ɛ̨hɛ bi ts'onga ma huąhi,” bi 'yɛ̨na. “Ha ga xathʉ ʉ yʉ paxi hingui ho,” bi 'yɛ̨n'ʉ yʉ́ 'yɛ̨hɛ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nɛ nu yʉ́ hmu bi 'yɛ̨mbi: “Hin'na, hin da zä gui mbähä gui xathʉ ʉ yʉ paxi hingui ho, nguetho xøhma ts'ʉrpʉ thoho nɛ ʉ xʉn ho gui xathʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Man'da xʉn ho gui hyɛthohʉ 'darpʉ din te, ja gue'bʉ bin ja ran sofo. Nɛ nubʉya ga xi ʉ yʉ mbɛfi ngue nu'ʉ hingui ho di pɛti nɛ da 'yudi, nɛ nu ʉ xʉn ho bʉya da mbɛ'ts' bʉ ja ma ngu,” bi 'yɛ̨n ʉ yʉ́ hmu, bi 'yɛ̨n'a ra Jesús. Nɛ guehna man'da ran t'uti bi mam 'bʉ mi xi ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nɛ man'da ran t'uti bi man'a ra Jesús nɛ bi 'yɛ̨na: ―Nɛ tengu n'da rá hmudä ra mostaza bi dupʉ ja rá huąhi n'da ra ją'i. Nɛ zi ts'ʉtho a, ɛ̨mmɛ man'da zi ts'ʉ xínda gue ʉ mi'da yʉ hmudä. ");
INSERT INTO otmNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pɛ nu'bʉ bin te nɛ man'da xʉn ndoho bʉ ni nɛqui, madague'bʉ ra c'ani thoho, pɛ i te tengu'bʉ n'da ra za guepʉ da zä da 'yøt' yʉ́ 'bafi yʉ doja bʉ ja yʉ́ 'yɛ. In jabʉ rá ts'ɛdi Oją bʉ ni nɛqui ngue di manda ua, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nɛ man'da ran t'uti bi ma ra Jesús nɛ bi 'yɛ̨na: ―Nɛ tengu ra íxi 'bʉ din jap'a ra hocjʉni, nɛ gätho bi nden a ra jʉni bʉya. In jabʉ rá ts'ɛdi Oją bʉ ni nɛqui ngue di manda ua, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nɛ ngubʉ bi 'yøt'a ra Jesús, hønt'ʉ yʉn t'uti bi 'yut'ʉ yʉ ją'i 'bʉ mi xänbi. ");
INSERT INTO otmNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nɛ gue'a bi man'a ra pøngahyą maya'bʉ ngue din ja 'bʉ mi 'yɛ̨na: Ga utä yʉ ją'i yʉn t'uti, Ga xänba a njon mi pądi asta gue'bʉ go mi mbʉh ra ximhäi, i ɛ̨n Oją, bi 'yɛ̨n'a ra Isaías 'bʉ mim pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nɛ nubʉya bi xi ʉ yʉ ją'i a ra Jesús ngue da mbengui. Nɛ nu'bʉ gätho mí mba ʉ, bi mba ra Jesús bʉ ja ra ngu. Nɛ dá tɛndähe bʉya. Nɛ nu'bʉ mí hyupʉ ja a ra ngu, dá änhde: ―Dami xije ts'ʉ 'bɛ'a nam bøn'a ran t'uti gá ma nangue ra hmudä hingui ho bi dupʉ rá huąhi a ran 'yohʉ, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nɛ bi 'yɛ̨ngähe ra Jesús bʉya: ―Nu'a nam bøni ngue yʉ hmudä xʉn ho ʉ dí tucä, guecä dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nɛ nu a ra huąhi nam bøni gue'a ra ximhäi. Nɛ nu'a ra hogahmudä nam bøni gue'ʉ di manda rá ts'ɛdi Oją ʉ. Nɛ nu'a ra hmudä hingui ho nam bøni yʉ ją'i ngue rá mbɛti ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nɛ nu a rán sʉiui a rá mbɛti ra huąhi ngue bi dupʉ yʉ hmudä hingui ho, gue'a ra zįthu a. Nɛ nu'a ran sofo nam bøni rán zɛgui ra pa. Nɛ nu'ʉ yʉ mbɛfi da xoqui nam bøni ngue yʉ́m 'bɛhni Oją mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nɛ tengu thoho ʉ yʉ hmudä bi bøts'e ngue hingui ho nɛ bi mba ma munts'i nɛ bi mba nt'udi, din ja bʉ 'bʉ ran zɛgui ra pa. ");
INSERT INTO otmNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nugä ngue dán ją'igä ua ja ra ximhäi, 'bʉ rán zɛgui ra pa ga pɛn'dʉ mam 'bɛhni di pɛti gätho nangu yʉ ją'i ra ximhäi. Nɛ gätho ʉ bi 'yøt' ran ts'o da thøn a thi, nɛ ʉ gätho midí parpa yʉ́ miją'ihʉ da 'yøt' yʉ ts'oqui. ");
INSERT INTO otmNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nɛ da thøspʉ ja ra sibi njąm'bʉ i huɛ̨t'i, guepʉ din zoni nɛ din guxt' yʉ́ ts'i bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nɛ nubʉya, nu'ʉ to'o i øt' rá pähä Oją, di nɛc thoho tengu ra hyadi bʉ di manda rá ts'ɛdi ma Tahʉ mahɛ̨ts'i. To'o gätho ja yʉ́ zagu, di jamansu a dím mangä ya, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nɛ man'da ran t'uti bi man'a ra Jesús, bi 'yɛ̨na: ―Nu n'da ran 'yohʉ bi dįn'a n'da ra mbɛti bʉ mbo ra häi ngue ɛ̨mmɛ di muui a. Nɛ bi gärpʉ mahøn'a. Nɛ midí johya, nɛ bi mba bʉya da mbä 'bɛ'a gätho mi pɛ'ts'i guepʉ bi zä bi dän'a ra xɛqui a guepʉ bi dįn'a di muui, ngue mi pądi man'da da dąpi bʉ. Nɛ din jabʉ gui 'yøthʉ ngue ɛ̨mmɛ gui hyomhbʉ ngue di manda rá ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nɛ xø bi 'yɛ̨na: ―Nu n'da ra pøhø ngue mi honi da dän yʉ do i thįm bʉ mbo ra dehe xʉm hmadi di muui. ");
INSERT INTO otmNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nɛ nu'bʉ mí dįn a n'da man'da mahotho xinda gue'ʉ gä min nu mam'bɛt'o, bi mbä 'bɛ'a gätho mí pɛ'ts'i nɛ bi dän'a ɛ̨mmɛ mahotho bʉya. Nɛ din jabʉ gui 'yøthʉ ngue ɛ̨mmɛ gui hyomhbʉ ngue di manda rá ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nɛ man'da bi man'a ra Jesús, bi 'yɛ̨na: ―Nu'a ní 'yøt' ran ts'ʉt'abi Oją, in ja tengu n'da ra xit'ą ngue i pa nt'ɛi bʉ ja ra dądądehe, nɛ i thɛ hønt'a go ní huą i 'bʉpʉ mbo ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nɛ nu'bʉ ya bi yu'a yʉ́ xit'ą yʉ mbahuą, da gʉx bʉya, da mba nín hupʉ ja ra ndenthe nɛ da huan'dʉ yʉ huą xʉn ho da 'yʉrpʉ ja yʉ́ 'bøts'e nɛ nu'ʉ hingui ho bʉya di bʉnt'i. ");
INSERT INTO otmNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Nɛ din jabʉ 'bʉ rán zɛgui ra pa, 'darbʉ dim 'bähmbʉ ʉ yʉ ts'om'bäi ʉ xʉn ho bi 'yøt'e. Nɛ nu yʉ́m 'bɛhni Oją mahɛ̨ts'i da huan'dʉ yʉ ts'om'bäi nɛ da 'yɛntpʉ ja ra sibi njąm'bʉ i huɛ̨t'i, nguepʉ din zom bʉ ʉ nɛ din guxt pʉ yʉ́ ts'i, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nɛ nu'a ra Jesús bʉya bi 'yɛ̨ngähe yʉ́ xädigähe: ―Ha guí pąhmbʉ a dí xi ahʉ ya. ―Hąha, ma Hmu, ya dí pąhmbe a guím ma, dá ɛ̨mbähe a. ");
INSERT INTO otmNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nɛ xø bi 'yɛ̨ngähe bʉya: ―Nu'ʉ midín xäh ram hma maya'bʉ, nɛ a ram hma ma'da'yo da hyumbi din xädi, ngue 'bɛpʉ ní manda rá ts'ɛdi Oją, hin te di 'bɛh rán xädi ʉ bʉya, nɛ da zä da xänba ʉ mi'da. Din ja tengu'bʉ n'da ra ją'i i ja 'bɛ'a i pɛ'ts'i ngue gä mahyoni. Nɛ'a bi zocpa yʉ́m bombøta nɛ'a bi dįnsɛ. Janangue'a hin te di 'bɛ ʉ 'bʉpʉ ja rá ngu, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nɛ nu'bʉ mi gua'a bi man ra Jesús bʉya bi bøm bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nɛ bi mba bʉ rá hnini zɛhɛ ngue Nazaret. Nɛ bin xäpʉ ja ra niją, nɛ nu yʉ ją'i bʉya bi hyonya thoho 'bɛ'a bi 'yøt'a, nɛ bi 'yɛ̨na: ―Hapʉ bí hyą rán 'yomfɛ̨ni na, ngue da zä da 'yøt'a i øt'e. ");
INSERT INTO otmNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ha hinga guehna rá ts'ʉnt'ʉ ra yaxi na, ngue i 'bʉcua rá mbe í María. Nɛ nu yʉ́n 'yohʉ ra Jacobo nɛ ra José nɛ ra Simón nɛ ra Judas. ");
INSERT INTO otmNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nɛ ʉ yʉ́n ju dí 'bʉhmbʉ ua. Pɛ hapʉ bí hyą a ran 'yomfɛ̨ni na, bi 'yɛ̨n ʉ yʉ́ mɛnguhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nɛ him bi numanho a ra Jesús. Pɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Gätho yʉ ją'i in jabʉ. Nubʉ ja yʉ́ hnini zɛhɛ hin da hnumanho n'da rá pøngahyą Oją, xínga gue'ʉ i 'bʉpʉ rá ngu da numanho, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Janangue'a hingui ngu yʉn t'øt'e mixte bi 'yørpʉ, ngue him bi 'yɛ̨c'yɛi ʉ 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nɛ min ts'ʉt'abi bʉ ra xɛqui Galilea a ra Herodes. Nɛ nu'bʉ mi sifi 'bɛ'a gä bi 'yøt'a ra Jesús 'bʉ min 'yo bʉ, bi 'yɛ̨n'a: ");
INSERT INTO otmNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","―Masque ra Xuua Nxixyą a, bi dąmbɛ̨ni bʉ 'bʉ ʉ xʉn du, janangue'a i ja rá ts'ɛdi xʉn ho i øt' yʉn t'øt'e mixte, bi 'yɛ̨m bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Nguetho guesɛ a ra Herodes bi hyo a ra Xuua Nxixyą. Bin cuɛ a ra Herodes 'bʉ mi sifi ngue hingui ho a bi 'yøt'e ngue bi zinsɛ a rá 'bɛpo, nu'a ra xisu mi 'bʉhmi a ra Felipe 'bʉ mi sin'a ra Herodes. Nɛ nu'a ra xisu, ra Herodías a. Nɛ bi 'yɛ̨n'a ra Xuua: “Hingui ho gá 'yøt'e ngue gá sinba rá xisu a nin 'yohʉ,” bi t'ɛ̨mp'a ra Herodes. Bin cuɛtho ra Herodes bʉya bi got'a fädi a ra Xuua nɛ bi manda dí tu't'i con yʉ cadena. Nɛ mim bɛ̨ni xta hyo a ra Xuua, pɛ him bi hyo nguetho mi su din cuɛ yʉ ją'i, ngue nu yʉ ją'i mi pądi rá pøngahyą Oją a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pɛ nu'bʉ mi zøn ra pa bin ja rá ngopa a ra Herodes 'bʉ mi dät ra jɛya mahøn'a, bi 'yøt'a n'da ran ts'ihmɛ nɛ bin nɛ a rá t'įxu a ra Herodías. Nɛ bi numanho a ra Herodes a ran hnɛi bi 'yøt' bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nɛ bi 'yɛ̨mp'a ra hmute: “Dami 'yädi 'bɛ'a gätho guí nde gui 'yäqui. Majuąni dí xi i, ga 'da i 'bɛ'a gätho gui 'yäqui,” bi 'yɛ̨n'a ra Herodes. ");
INSERT INTO otmNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nɛ nu'a ra hmute bʉya bi 'yä a rá yą ra Xuua Nxixyą ngue di o ra mbohi, nguetho gue'a xí xi a rá mbe a da 'yäp'a. ");
INSERT INTO otmNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nɛ bi du rá mbʉi a ra Herodes bʉya, him mi ndehma da hyo a ra Xuua, pɛ hin'yʉ 'bɛ'a sä da 'yøt'e nguetho ya xí xifi di unni 'bɛ'a gä da 'yäpi, nɛ ya xí 'yøh yʉ ją'i di unni 'bɛ'a gätho da 'yäpi. ");
INSERT INTO otmNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nɛ bi manda bʉya ngue da mba ba thɛcpa rá yą ra Xuua Nxixyą bʉ ja ra fädi, nɛ ba jät'a n'da ra mbohi din t'un'na ra hmute. ");
INSERT INTO otmNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nɛ nu'bʉ min t'unni bi dɛn a ra mbohi bi un'na rá mbe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nɛ nu yʉ́ xädi ra Xuua bʉya, bá tunba a rá ngøc'yɛi bʉ ja ra fädi, bi 'yägui. Nɛ bi mba bʉya bá xi a ra Jesús ngue ya bi du ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nɛ nu ra Jesús 'bʉ mí 'yøde bi du ra Xuua, 'bex dá mbähmbe dá huhe bʉ ja ra mbosa mí nde xcá sømhbe bʉ 'danguadi, mi ɛ̨na xcám 'bʉsɛhe n'da zi ora. Pɛ nu'bʉ mi pą ʉ yʉ ją'i ngue dá mbähmbe bʉ a ra Jesús, nɛ ʉ bá nɛxpʉ ja yʉ́ hnini bi dɛngähe, bin 'yogua thoho gätho bʉ ja rá nyąni a ra dądehe. ");
INSERT INTO otmNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nɛ nu'bʉ má cąhmbe bʉ ja ra mbosa a ra Jesús, xʉn ngu ʉ yʉ ją'i xí zøm bʉ. Nɛ ɛ̨mmɛ bi huɛ̨c'ʉ bʉya nɛ bi hoqui hønt'a go to'o mí ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nɛ nu'bʉ min de bʉya dá ɛ̨mbähe a ra Hmu: ―Ya bin de ya, nɛ njongui 'bʉcua ja ra xɛqui ua, dami xih yʉ ją'i da mba bʉ ja yʉ hnini nɛ da däm bʉ 'bɛ'a da zi, dá ɛ̨mbähe a. ");
INSERT INTO otmNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nɛ bi 'yɛ̨n'a ra Jesús: ―Pɛ hingui jatho da mba, pɛ guesɛ ahʉ dami 'uįmhbʉ, bi 'yɛ̨ngähe. ");
INSERT INTO otmNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nɛ dá thąhmbe bʉya: ―Pɛ hin'yʉ 'bɛ'a da zi, nɛ hønt'i cʉt'a yʉ hmɛ i ja ua nɛ yoho yʉ huą, dá ɛ̨mfe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","―Bá cʉhʉ ua, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nɛ bi xih yʉ ją'i ngue din säya bʉ ja yʉ t'ɛi, nɛ bi hyąn ʉ cʉt'a yʉ hmɛ nɛ yoho yʉ huą. Bi ndøs' mahɛ̨ts'i nɛ bi 'yäp rán jąpi Oją, nɛ bi xɛm bʉya nɛ bi 'dacähe dá darpähe yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gätho bin sihmɛ ʉ yʉ ją'i nɛ bin niyą nɛ bi bong mi'da yʉ xɛqui bi yu'i 'dɛ'ma yoho yʉ 'bøts'e. ");
INSERT INTO otmNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nɛ nu'ʉ gätho bin sihmɛ í jua'i cʉt'a mahuąhi ʉ yʉn 'yohʉ, nɛ hin njon bi mbeh yʉ xisu xinga gue yʉ t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nɛ nubʉya, bi xije ga mbähmbe ngue ga 'daxhe ra dądehe mahøn'a. Dá huhe a ra mbosa dá mbähmbe bʉya. Go bi gosɛ bʉ a ra Jesús, bin 'yɛ̨hmbʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nɛ nu'bʉ mi mba ʉ yʉ ją'i bi ndezɛhɛ bʉ ja ra nyuni nɛ bi nyąui bʉ Oją. Bá hazɛhɛ bʉ a. ");
INSERT INTO otmNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nɛ nu'bʉ má mbähmbe ngue dá huhe ra mbosa, 'bʉ mi zøm made ra dehe, bi zɛh ran dąhi nɛ ɛ̨mmɛ bin ja yʉ t'øthe, nɛ ts'ɛdi midí cos'a ra mbosa. ");
INSERT INTO otmNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nɛ nu'bʉ ya mbɛ mí ts'ʉtho da hyats'i, nɛ 'yo a ra Jesús bʉ maxøts'e ra dehe ngue da zʉ'a ra mbosa. ");
INSERT INTO otmNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nɛ nu'bʉ mambá ɛ̨pʉ ra Jesús, nɛ i 'yo bʉ maxøts'e ra dehe dá handähe bʉya, ba ɛ̨pʉ nɛ hin dí pąhmbe ngue gue'a. Ɛ̨mmɛ dán suhe nɛ dá mbahmbe: ―Ba ɛ̨hnʉ n'da ra ánima, dá ɛ̨mhbe. ");
INSERT INTO otmNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nɛ bi dąrcähe a ra Jesús: ―Dami hyuthʉ nzambʉi, o guín suhʉ, guecä, bi 'yɛ̨ngähe. ");
INSERT INTO otmNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nɛ bi dąt'a ra Pedro bʉya: ―Nu'bʉ gue'e ma Hmu i, dami jaqui nɛcä dan 'yo maxøts'e ra dehe nɛ ga søm bʉ guí 'bäi, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Ba ɛ̨cua, bi 'yɛ̨n'a ra Jesús, bi t'ɛ̨mp'a ra Pedro bʉya. Nɛ nu'a ra Pedro bʉya bi gąpʉ ja ra mbosa nɛ bi dʉ'mi bin 'yo maxøts'e ra dehe ngue in nde da zøm bʉ bí 'bä a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pɛ bi nu ngue ɛ̨mmɛ nts'ɛdi ran dąhi nɛ 'bex bin su bʉya, nɛ bi dʉ'mi bi dont'a mbonthe. Nɛ nts'ɛdi bi mbah pʉya: ―Ma Hmu, dami yąngui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nɛ 'bex bi bɛndba rá 'yɛ a ra Jesús bʉya. ―Hanja ts'ʉtho guí ɛ̨c'yɛi ngue i ja ma ts'ɛdi nɛ 'bexgue gá su 'bɛ'a gán nu, bi 'yɛ̨mp'a rá hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nɛ nu'bʉ mi hyu ra mbosa a ra Pedro nɛ ra Jesús bʉya, 'bex bin hɛ̨ a ran dąhi. ");
INSERT INTO otmNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nɛ nugähe mí huhmbe bʉ mbo ra mbosa dán dąnyahmuhe bʉ mí 'bä a ra Jesús nɛ dá ɛ̨mfe: ―Majuąni maha, gue'e rá Ts'ʉnt'ʉ i Oją, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nɛ dá thohmbe bʉya dá sømhbe bʉ 'danguadi ra dehe bʉ mi ja ra xɛqui Genesaret. ");
INSERT INTO otmNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nɛ nu'ʉ yʉ ją'i mi 'bʉpʉ, 'bʉ mi nu bi zøm bʉ ra Jesús, 'bexgue bi mbɛnh ra nde hønbʉ go hapʉ ja yʉ hnini ngue ya mí 'bʉpʉ ra Jesús. Nɛ bá ts'inbi gätho yʉ hyɛ̨nni bʉ mi 'bʉcähe a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nɛ bi 'yäh ra mate ʉ ngue bi därpa rá nyąni rá pahni ra Jesús, nɛ 'bex bi yąn ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nɛ nubʉya bá ɛ̨ i 'da ma ngʉrpihe ngue yʉ fariseo nɛ yʉ xänbate niją. Bá nɛxpʉ Jerusalén ʉ, nɛ bi 'yän'na ra Jesús: ");
INSERT INTO otmNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Hanja ʉ ni xädi hingui tɛn yʉ́n t'øt'e mam bombøtahʉ nɛ him 'bɛ i xʉt'yɛ 'bʉ i sihmɛ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bi dą a ra Jesús nɛ bi 'yɛ̨mbi: ―Pɛ nɛ ahʉ guí fɛsthohohʉ rán t'ɛ̨di Oją 'bʉ guí homhbʉ gui 'yøt' nin t'øt'e zɛhɛhʉ, bi t'ɛ̨mp'ʉ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nguetho i mam bʉ ja rám hman Oją: “Gui numansu ni ta nɛ ni mbe.” Nɛ a i mam bʉ ngue: “Nu'a to'o san rá ta nɛ rá mbe i jatho da tho,” bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pɛ nu ahʉ, 'dan'yo thoho guí mamhbʉ, ngue guí ɛ̨mhbʉ xʉn ho 'bʉ di yąrpa Oją a mi ja ngue xtá mbäx'a rá mbe o gue rá ta n'da ran 'yohʉ. Nɛ hin gá xihmbʉ ngue him bi numansu rá ta 'bʉ ngubʉ bi 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Gá 'yɛ̨mhbʉ nte ní mba tho yʉ́n t'ɛ̨di Oją 'bʉ guím bɛ̨nsɛ nin t'ɛ̨dihʉ, bi 'yɛ̨n'a ra Jesús, bi t'ɛ̨mp'ʉ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pɛ ɛ̨mmɛ guidí yorpahʉ a guím bɛ̨mhbʉ, bi 'yɛ̨mp'a ra Jesús. Majuąni bi man Oją bʉ ja rá søcuą ra Isaías 'bɛ'a guí øthʉ ngue bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nuya yʉ ją'i ya i ɛ̨squi nangue yʉ́ nde, pɛ maxøts'e thoho nɛ hinga gätho yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nɛ säti thoho 'bʉ i thąndegui, nguetho hønt'ʉ yʉ́n t'ɛ̨di zɛhɛ i xänba ʉ mi'da, i ɛ̨n Oją, bi 'yɛ̨n'a ra Isaías 'bʉ maya'bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nɛ nubʉya, nu ra Jesús bi zon'dʉ yʉ ją'i: ―Dami 'yøhmbʉ 'bɛ'a dí xi ahʉ janangue'a gui pąhmbʉ 'bɛ'a nam bøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hinga gue'a i ts'i di ts'onba rá mbʉi n'da, pɛ gue'a ní bøm bʉ rá nde n'da, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nɛ dá mbähmbe bʉ mi 'bäh ra Jesús. ―Nu'ʉ yʉ fariseo bi bɛ̨man'ʉ a gám ma, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nɛ bi dąh ra Jesús, bi 'yɛ̨na: ―Hønt'a go 'bɛ'a ma paxi him bi 'yɛ̨zɛhɛ ma Ta, i jatho da mba nsat'i. ");
INSERT INTO otmNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nte guim bɛ̨mhbʉ nangue ʉ nguetho tengu'bʉ i xädä ʉ, nɛ ɛ̨na da 'yut' ra 'yu yʉ́ mixädähʉ. Nɛ nu'bʉ n'da ra xädä i six'a rá mixädäui, thąmbɛ̨ni tho gätho yoho da zo bʉ ja n'da ra hyąhäi, bi 'yɛ̨ngähe ra Jesús 'bʉ má ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nu ra Pedro bʉya bi xi a ra Jesús: ―Dami xije nangue a ran t'uti gá ma mahɛ̨'bʉ, 'bɛ'a nam bøn'a, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nɛ bi dą'a ra Jesús: ―Ha nɛ ahʉ xíngui ts'ʉ guí pąhmbʉ 'bɛ'a nam bøn'a dí xi ahʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ha hin guí pąhmbʉ nu 'bɛ'a da zi n'da, da yʉrpʉ ja rá nde nɛ da mba bʉ ja rá foho, nɛ hingui ząm bʉ, bi 'yɛ̨ngähe. ");
INSERT INTO otmNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pɛ nu 'bɛ'a gätho da bøn bʉ ja rá nde n'da í nɛxpʉ rá mbʉi nɛ gue'a di ts'on'a n'da. ");
INSERT INTO otmNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nguetho guepʉ mbo rá mbʉi n'da ni nɛx'ʉ yʉ ts'on'yomfɛ̨ni, ran thodu, ran 'yomt'ɛ̨ni madague'bʉ bin thąt'a n'da o hin gana din thąti, nɛ yʉm fɛ̨, nɛ yʉ fɛhni, nɛ yʉn ts'ante, nɛ gue'ʉ gätho ní nɛxpʉ rá mbʉi n'da ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nɛ gätho ʉ gue'ʉ ní ts'om'bäi n'da ra ją'i ʉ. Pɛ nu'bʉ bin sihmɛ nɛ him bi 'yøt'a ran t'øt'e ngue din xʉt'yɛ, hinga gue'a dán ts'on'a, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nɛ nubʉya dá pømhbe bʉ a ra Jesús dá mbähmbe bʉ ja rá xɛqui ra hnini Tiro nɛ ra hnini Sidón. ");
INSERT INTO otmNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nɛ dán c'athe n'da ra xisu ra mɛngu Canaan, hing ra israel a. Nɛ ts'ɛdi bi mbafi, bi 'yɛ̨mp'a ra Jesús: ―Gra Hmu, rám bom'bɛto i ra David, din ja nin huɛ̨cate nangue ma t'įxu in 'youi n'da ra zįthu ngue ɛ̨mmɛ di ʉnbi. ");
INSERT INTO otmNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nu ra Jesús bi thotho, tengu'bʉ him bi 'yø a bi xifi. Nugähe bʉya dá xihmbe ra Jesús: ―Dami 'yørpa ra mate a ra xisu, janangue'a da mbengui, nɛ i mbafi i tɛngahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nu ra Jesús bʉya bi 'yɛ̨na: ―Nu Oją bá pɛngui ga ørpa rá 'bɛfi ngue hønt'ʉ ma mɛnguhʉ yʉ israel ga jamansu, nguetho i 'bʉi tengu yʉ dɛ'yo bi 'bɛh ra 'yu, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pɛ nu ra xisu bi zøm bʉ 'bäh ra Jesús bin dąnyahmu nɛ bi 'yɛ̨mbi: ―Gra Hmu, dami zɛqui. ");
INSERT INTO otmNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pɛ nu ra Jesús bi 'yɛ̨mbi: ―Hingui ho 'bʉ n'da ran 'yohʉ da hyąnba rá hmɛ yʉ́ t'ʉhni, go di un'dʉ yʉ t'ʉ'yo, bi 'yɛ̨mbi. Ngubʉ bi xifi nguetho hing ra israel a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bi 'yɛ̨n'a ra xisu bʉya: ―Majuąni guím ma gra Hmu, pɛ nɛ'ʉ yʉ t'ʉ'yo i si yʉ xɛca hmɛ 'bom bʉ ja ra 'bimɛxa ngue i hɛ ʉ yʉ́ hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ra Jesús bʉya bi 'yɛ̨mp'a ra xisu: ―Gra xisu, ɛ̨mmɛ guí ɛ̨c'yɛi xʉn ho a ma mate. Janangue'a din ja a gá 'yädi, bi 'yɛ̨mbi. Nɛ 'bexgue gue'a ra ora bi yąn'a rá t'įxu. ");
INSERT INTO otmNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nɛ nubʉya nu ra Jesús bi bøm bʉ. Dá mbähmbe bʉ ja ra ndendądehe bʉ Galilea nɛ dá texhe bʉ ja ra nyuni, nɛ bi hyupʉ a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nɛ xʉn ngu yʉ ją'i bi zøm bʉ mi hudi, nɛ bá ts'inba yʉ dogua, nɛ yʉ xädä, nɛ yʉ gore, nɛ yʉ do'yɛ, nɛ xʉn ngu mi'da yʉ mbɛdi nɛ yʉ hyɛ̨nni bá ts'inba bʉ mi hu'a ra Jesús. Nɛ nu ra Jesús bʉya gätho bi hoc'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nɛ nu yʉ ją'i bi hyonya thoho 'bʉ mi nu bin yą yʉ gore nɛ bin 'yo ʉ mí dogua nɛ bi yąn'ʉ mi do'yɛ, nɛ bin zø yʉ́ dä ʉ mi xädä. Nɛ nu'bʉ mi nu 'bɛ'a bi 'yøt'a ra Jesús, bi 'yɛ̨spa Oją, ngue ma Ojąhe dyʉ israelhe. Nɛ hyu pa dán degähe bʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nɛ nu ra Jesús bi zongahe bi 'yɛ̨ngähe: ―Ɛ̨mmɛ dím bɛ̨ngä yʉ ją'i i 'bʉcua nguetho ya ná hyupa i 'bʉcua nɛ hin'yʉ 'bɛ'a da zi yʉ. Nɛ nu'bʉ ga xifi da mba bʉ yʉ́ ngu, masque hin da hyät'i da zøm bʉ ja yʉ́ ngu, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nɛ dá ɛ̨mhbe bʉya: ―Pɛ hin hapʉ ga tįmhbʉ ra hmɛ ga unhndʉ yʉ ją'i, nguetho ɛ̨mmɛ xʉn ngu i 'bʉcua, nɛ njongui 'bʉcua ngue ga tämfʉ ra hmɛ, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","―Hangu guí hąhʉ ra hmɛ thą, bi 'yɛ̨n'a ra Jesús. ―Yoto thoho yʉ hmɛ nɛ zi yoho yʉ t'ʉhuą, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nɛ nu ra Jesús bi xih yʉ ją'i din säya bʉ häi. ");
INSERT INTO otmNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nɛ bi hyąn'ʉ yʉ hmɛ a ra Jesús nɛ yʉ huą, nɛ bi 'yäp rán jąpi Oją nangue ʉ bi hyąni. Nubʉya, nu ra Jesús bi xɛn yʉ hmɛ nɛ yʉ huą nɛ bi dargähe ngue ga unhde yʉ ją'i bʉ mí hudi. ");
INSERT INTO otmNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nɛ gätho ʉ mí 'bʉpʉ bin sihmɛ ʉ nɛ bin niyą, nɛ bi bongui yoto yʉ 'bøts'e 'bʉ mi niyą. ");
INSERT INTO otmNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nɛ goho mahuąhi ʉ yʉn 'yohʉ bin sihmɛ, nɛ njom bi mbeh yʉ xisu nɛ yʉ t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nɛ nu ra Jesús bʉya bi xih yʉ ją'i da mbeng yʉ́ ngu. Nɛ nu'bʉ mi mbeng yʉ ją'i bʉya dá mbähmbe mahøn'a a ra Jesús, dá huhe ra mbosa mahøn'a ngue ga sømhbe bʉ ra xɛqui Magdala. ");
INSERT INTO otmNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nɛ nu'bʉ ma sømhbe bʉ, bi zøm bʉ 'da ma ngʉrpihe ngue yʉ fariseo nɛ yʉ saduceo, in nde da zäp rá mbʉi a ra Jesús, bi 'yɛ̨mbi: ―'Yurcahe n'da ra hmɛpya ngue ga pąhmbe majuąni Oją bá pɛn'ni i, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","―Pɛ nu'ehʉ, bi 'yɛ̨n'a ra Jesús, guí nuhʉ xʉn thɛni yʉ güi 'bʉ xøn de nɛ guí ɛ̨mhbʉ bʉya ngue din hyadi 'bʉ bi hyats'i. ");
INSERT INTO otmNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nɛ nu'bʉ guí nuhʉ ts'ʉtho xʉn thɛni yʉ güi 'bʉ xudi, guí ɛ̨mhbʉ din dą'ye bʉya. Ɛ̨mmɛ guidí yorpahʉ a guím bɛ̨mhbʉ. Hanja ngue guí pąhmbʉ 'bɛ'a nam bøn'ʉ yʉ güi guí nuhʉ nɛ hin go guí pąhmbʉ 'bɛ'a nam bøn yʉ hmɛpya guí nuhʉ ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nu ahʉ guí 'bʉhmbʉ ya, gue ahʉ gyʉ ts'om'bäihʉ, xcá 'uehmbʉ bʉ rá 'yu Oją, nɛ sä guí ähmbʉ ra hmɛpya ya pɛ hin da t'ut'ahʉ ra hmɛpya. Pɛ hønt'a ra hmɛpya da t'ut'ahʉ tengu bi 'yøt'a ra Jonás maya'bʉ, bi 'yɛ̨n'a ra Jesús bi 'yɛ̨mp'ʉ yʉ fariseo. Nɛ xø dá mbäcähe a ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nɛ nubʉya dá penje mahøn'a 'danguadi ra dądehe a ra Jesús. Nɛ dá pumbɛ̨nihe a ra hmɛ nząi mí sihe ngue min 'youi ra íxi. ");
INSERT INTO otmNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nu ra Jesús bʉya bi 'yɛ̨ngähe: ―Damim fähmbʉ nangue yʉ́ íxi yʉ fariseo nɛ yʉ saduceo, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nɛ dá ɛ̨nsɛhe: ―I man na ya ngue him bá hąhʉ ra hmɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nɛ nu ra Jesús bi bądi 'bɛ'a dá bɛ̨mhbe nɛ bi 'yɛ̨nje: ―Hanja guí ɛ̨mhbʉ: “Hin'yʉ ra hmɛ ga sihʉ.” Pɛ ts'ʉtho guí ɛ̨c'yɛihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ha gá pumbɛ̨nihʉ 'bʉ má 'uįngä goho mahuąhi yʉn 'yohʉ ngue hønt'i yoto yʉ hmɛ nɛ yoho yʉ t'ʉhuą, nɛ bi bong thoho yoto yʉ 'bøts'e yʉ hmɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nɛ'bʉ má 'uįn'i cʉt'a mahuąhi yʉn 'yohʉ ngue hønt'i cʉt'a yʉ hmɛ mi ja, nɛ xʉn ngu yʉ 'bøts'e bi yu 'bʉ mi bongui. ");
INSERT INTO otmNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hanja hin gá pąhmbʉ 'bʉ má xi ahʉ nangue yʉ́ íxi yʉ fariseo nɛ yʉ saduceo, pɛ hin nangue ʉ yʉ hmɛ dá xi ahʉ, bi 'yɛ̨ngähe. ");
INSERT INTO otmNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ja dá pąhmbe bʉya 'bɛ'a nam bøn'a bi xije ra Jesús. Dá pąhmbe ngue gue'a yʉ́n xädi yʉ fariseo nɛ yʉ saduceo, nɛ hinga gue'a njuąntho ra íxi bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nɛ nubʉya dá mbähmbe ra Jesús bʉ ra xɛqui Cesarea, guepʉ min ts'ʉt'abi ra Felipe. Nɛ bi 'yängahe dyʉ xädigähe ra Jesús: ―'Bɛ'a im bɛ̨n'ʉ yʉ ją'i ngue to'ogä, ngue guecä dán ją'igä ua ja ra ximhäi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dá thąthe bʉya: ―Nu'ʉ 'da yʉ ją'i im bɛ̨ni gue'e gra Xuua Nxixyą, nɛ nu'ʉ 'da im bɛ̨ni ngue gue'e gra Elías mi 'bʉh maya'bʉ. Nɛ nu'ʉ 'da im bɛ̨ni gue'e grá Jeremías ngue maya'bʉ xøn du, uague man'da rá pøngahyą Oją, i ɛ̨n'ʉ, dá ɛ̨mfe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nu ra Jesús bʉya bi 'yängähe: ―Xi'ahʉ, 'bɛ'a guím bɛ̨mhbʉ ngue to'ogä. ");
INSERT INTO otmNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ra Simón Pedro bʉya bi dąti: ―Gue'e rá thahni i Oją ngue ra Cristo, rá Ts'ʉnt'ʉ i Oją i 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ra Jesús bi 'yɛ̨mbi: ―Mająpi i gra Simón, rá ts'ʉnt'ʉ i ra Jonás, nguetho nu'a gá ma hinga n'da ra ją'i bi bɛ̨n'ni i, pɛgue Oją ma Ta bí 'bʉh mahɛ̨ts'i bi bɛ̨n'ni i. ");
INSERT INTO otmNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pɛ nɛ'a dí xi i, nu'i gra Pedro, nu'a ni thuhu nam bøni gue ra do. Nguetho tengu 'bʉ da gue'e gra dongu guepʉ dí mbʉh rán ngu Oją, nangue'e ga dʉ'mä ga pɛt'ʉ da 'yɛ̨c'yɛigui. Nɛ hin'yʉ 'bɛ'a da zä di jua ʉ, xíng ran dąte, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nɛ ga 'da a n'da nin t'ɛ̨di ngue gui xih yʉ ją'i 'bɛpʉ dí yʉt'a n'da bʉ di manda Oją. Tengu'bʉ ga 'da a n'da ran sogui ngue gui xocpʉ di manda rá ts'ɛdi Oją. Nɛ nu'a gui 'yɛ̨mbi hingui ho ua ja ra ximhäi, nɛpʉ mahɛ̨ts'i da t'ɛ̨mbi hingui ho a. Nɛ ngutho a gui 'yɛ̨mbi xʉn ho, nɛpʉ mahɛ̨ts'i da t'ɛ̨mbi xʉn ho a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pɛ nubʉya, nu ra Jesús bi hɛgähe hin ga mamhbe bʉ 'bʉh yʉ ją'i ngue guesɛ a rá Thahni Oją, ngue ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nɛ nu'a ra pa a, bi dʉ'mi bi xije jatho da mba bʉ Jerusalén di ʉnba bʉ ʉ ma ngʉrpihe, ngue yʉ dąc'yɛi nɛ yʉ mbäją nɛ yʉ xänbate niją. Nɛ bi xije da tho nɛ da dąmbɛ̨ni 'bʉ ná hyupa. ");
INSERT INTO otmNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nɛ nubʉya bi zixpʉ ma'ueni a ra Pedro nɛ bi zʉi, bi 'yɛ̨mbi: ―O guidí japi da bɛnt'i i, damin yąni, bi t'ɛ̨mp'a ra Jesús, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nɛ bi dą'a ra Jesús: ―Dami pøni gra zįthu. Ní mba, nguetho guí ɛ̨ngui hin ga øt'ä a bi zän Oją. Hin'yʉ nin 'yomfɛ̨ni tengu im bɛ̨n Oją, pɛ hønt'a im bɛ̨n yʉ ją'i guím bɛ̨ni, bi 'yɛ̨n'a ra Jesús, bi t'ɛ̨mp'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nɛ nubʉya, bi 'yɛ̨ngähe: ―Pɛ to'o gätho in nde da dɛngui i jatho hin da bɛ̨n'a rá pähä zɛhɛ nɛ da hyät yʉn ʉnbi madague'bʉ da tho. ");
INSERT INTO otmNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nguetho nu'a to'o di huɛ̨czɛhɛ rá te, da mba ma ʉnbi rá te bʉ ja ran dąte, pɛ nu'a to'o hingui su da thącpa rá te nanguecä, da dįn'a ra te maząi a. ");
INSERT INTO otmNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pɛ nu'bʉ n'da ra ją'i, madague da 'yøt'e rá mbɛti 'bɛ'a gätho i ja ua ja ra ximhäi, pɛ nte ní mbatho 'bʉ him bi pøh rá te. Nguetho njo'o n'da ra ją'i da zä da guzɛhɛ rá te, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nguetho nugä ngue dán ją'igä ua ja ra ximhäi, nɛ din jagä rá ts'ɛdi ma Ta bʉ mahɛ̨ts'i 'bʉ bá pengä mahøn'a, nɛ gätho yʉ́m 'bɛhni ban 'yohe 'bʉ bá ɛ̨cä. Nɛ i ja 'bɛ'a ga undä nangue 'bɛ'a bi 'yøt'a n'da ngu n'da yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Majuąni dí xi ahʉ, hinga gä gní tuhʉ 'bʉ bi dʉ'mi di manda ma ts'ɛdi ua, guecä dán ją'igä ua ja ra ximhäi, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nɛ nu'bʉ mi tho i 'dato pa nu ra Jesús bi zix ra Pedro nɛ ra Jacobo nɛ ra Xuua, rán 'yohʉ ra Jacobo, nɛ bi mbähä bʉ ja ra t'øhø. ");
INSERT INTO otmNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nɛ nu'bʉ mí zøm bʉ, bim pä'a ra Jesús. Nu rá hmi bi hyät'i tengu'bʉ ra hyadi, nɛ nu rá he bi t'axqui tengu'bʉ ran nɛqui. ");
INSERT INTO otmNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nɛ nu'ʉ ma mixädihe min 'yohʉ, bi nu bi zøm bʉ ra Elías nɛ ra Moisés, bin yąhʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nɛ nu ra Pedro bʉya bi 'yɛ̨mp'a ra Jesús: ―Gra Hmu, xʉn ho ngue dí 'bʉhmbe ua, nɛ ga høcähe hyu yʉ t'ʉngu. Nu n'da gam 'bʉsɛ, nu n'da dim 'bʉh ra Moisés, nɛ nu'a man'da dim 'bʉh ra Elías, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pɛ nu'bʉ mí yą ra Pedro, bi nɛqui n'da ra güi di fɛxni, ngue bi go'bʉ, nɛ bi 'yø'a n'da ra nde bin yą bʉ ja ra güi: “Guehna ma Ts'ʉnt'ʉgä na, ɛ̨mmɛ dídi huɛ̨cä na nɛ dí numanho. Dami 'yøhmbʉ 'bɛ'a i xi ahʉ.” Gue'a bi man'a ra nde bi 'yøpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nɛ nu'bʉ mí 'yø a ra nde ʉ ma mixädihe 'bex bin dąnyahmu bʉ häi nɛ bi nyetho nguetho bin su ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nɛ nu ra Jesús bʉya bi mba bʉ mín dąnyahmu ʉ nɛ bi 'yɛ̨mbi: ―Dami ndanjʉ, o guín suhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nɛ nu'bʉ mi ndøx'ʉ bʉya njom bi nu, pɛ hønt'a ra Jesús mí 'bäpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nɛ nu'bʉ mam bá ɛ̨pʉ 'yu bʉ ja ra t'øhø bʉya, bi 'yɛ̨n'a ra Jesús: ―Nuya njon gui xihmbʉ 'bɛ'a gá nuhʉ bʉ, jague'bʉ dá thąmbɛ̨nigä bʉ 'bʉ ʉ xøn du, nugä ngue dán ją'igä ua ja ra ximhäi, bi t'ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nɛ nu ma mixädihe bʉya bi 'yänni: ―Hanja i ɛ̨n'ʉ yʉ xänbate niją ngue m'bɛt'o thoho ba penc'a ra Elías, nɛ ja ba ɛ̨'a rá Thahni Oją ngue ra Cristo bʉya, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","―Majuąni im ma ngue m'bɛt'o ba ɛ̨h ra Elías di hoqui gätho. ");
INSERT INTO otmNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pɛ dí xi ahʉ, ya bi zøh ra Elías nɛ njon bi bądi ngue gue'a. Pɛgue bi mba ma ʉnbi nɛ bi mba ma ʉcpi, nɛ ngutho da t'ørcä ya, nugä ngue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ja bi bą ʉ ma mixädihe bʉya gue tengu'bʉ ra Elías a ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nɛ nu'bʉ mi zøm bʉ 'bʉh yʉ ją'i, bi zøm bʉ n'da ran 'yohʉ bʉ mí 'bäh ra Jesús, nɛ bi 'yɛ̨mbi: ");
INSERT INTO otmNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Gra Hmu, dami 'yørqui ts'ʉ ran huɛ̨cate a ma ts'ʉnt'ʉ, jant'a thoho i sändąte nɛ hønbʉ go i so 'bʉ xø 'yagui. Ja'bʉ i so bʉ ja ra sibi, nɛ ja'bʉ i so bʉ ja ra dehe, hønbʉ go hapʉ 'yo 'bʉ xøn zändąte. ");
INSERT INTO otmNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɛ bá sigä bʉ mi 'bʉ ʉ ni xädi, pɛ him bi zä bi hyącpa a ran ʉ in 'youi, bi 'yɛ̨n'a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nɛ bi 'yɛ̨n'a ra Jesús: ―Gyʉ ts'om'bäihʉ, hin guí ɛ̨c'yɛihʉ Oją xʉn ho. Hangu yʉ pa ga tøp'a thoho ahʉ ngue gui 'yɛ̨c'yɛigahʉ, bi 'yɛ̨n'a ra Jesús. Bá si ni ts'ʉnt'ʉ guím ma, bi t'ɛ̨mp'a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nu'bʉ mi zøpʉ bʉya, nu'a ra Jesús bi zʉ a ra zįthu min 'youi, nɛ bi xifi da bøni. 'Bex bi yąn'a ra ts'ʉnt'ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","M'bɛjua bʉya bin yąhʉ ʉ ma mixädihe a ra Jesús nubʉ dám 'bʉsɛhe. ―Hanja him bi zä dá høngähe thi a ra zįthu min 'youi a ra ts'ʉnt'ʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Bi dą a ra Jesús nɛ bi 'yɛ̨na: ―Him bi zä gá hyømhbʉ thi ra zįthu, nguetho ts'ʉtho guí ɛ̨c'yɛihʉ. Man'da zi ts'ʉtho ni t'ɛ̨c'yɛihʉ xinda gue n'da rá hmudä ra c'u ngue ɛ̨mmɛ zicuɛ. Nɛ nu'bʉ da zøni gui 'yɛ̨c'yɛihʉ tengu n'da rá hmudä ra c'u, da zä gui xihmbʉ n'da ra t'øhø: “Dami 'uegue gui thąn nʉ n'danni,” gui 'yɛ̨mfʉ, nɛ da 'uegue. Hin te gui hyɛ̨mfʉ 'bʉ majuąni gui 'yɛ̨c'yɛihʉ. Gätho xʉn hɛ̨i i sä gui 'yøthʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pɛ nu'ʉ 'da'ʉ yʉ zįthu tengu min 'youi a ra ts'ʉnt'ʉ, xʉn hɛ̨i da hyøn a thi ʉ, pɛ hønt'bʉ ɛ̨mmɛ hąh rá mbʉi din yąui Oją nɛ da 'yɛ't' ran ts'ihmɛ n'da, da zä da hyøn a thi ʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Nɛ nu'bʉ mán 'yohe bʉ ra häi Galilea, bi 'yɛ̨nje mahøn'a a ra Jesús: ―Nugä ngue dán ją'igä ua ja ra ximhäi, dan dägä bʉ 'bʉh yʉ ją'i ngue da thogä. Pɛ ga thąmbɛ̨ni 'bʉ ná hyu pa, bi 'yɛ̨n'a ra Jesús. Nɛ ɛ̨mmɛ bi du ma mbʉigähe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nɛ nu'bʉ má sømhbe bʉ ra hnini Capernaum a ra Jesús, bi t'ɛ̨mp'a ra Pedro: ―Xi ni xänbatehʉ, ha hingui jut'a ra mbɛti dí hąxähe nangue ra niją, bi t'ɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bi dą a ra Pedro bʉya: ―Hąhą i jut'i, bi 'yɛ̨mp'ʉ. Nɛ nubʉya nu'bʉ mi yʉrpʉ ja ra ngu xín säya a ra Jesús, 'bex bi t'än'na ra Pedro: ―'Bɛ'a guím bɛ̨ni gra Simón, ha nɛ'ʉ yʉ́ t'ʉhni yʉ ts'ʉt'abi i jut'a ra mbɛti ua ja ma häihʉ, uague hønt'ʉ yʉ ją'i thoho, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bi dą a ra Pedro: ―Nu'ʉ yʉ ją'i thoho. ―Janangue'a hin mán zähma'be ga jut'ä 'bʉ hingui jut'ʉ yʉ́ t'ʉhni yʉ ts'ʉt'abi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","―Pɛ ni mba bʉ ja ra dądehe, gui hyʉ'ts'a n'da ra huą, nɛ gui xemba rá nde. Gui tįm bʉ n'da ra mbɛti, ngue'a xøt'a ga jut'ui a ra cota a ra niją, n'dahma hin da bɛ̨man'ʉ ʉ i hąx ra mbɛti, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nɛ xø dá änhde a ra Jesús: ―Xiya, to'o man'da xʉn hɛ̨ts'i rán t'ɛ̨di bʉ na hnu bʉ di manda rá ts'ɛdi Oją, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nu ra Jesús bʉya bi zohna n'da ra t'ʉhni nɛ bi gʉts'i bi mbämp'ʉ made, ");
INSERT INTO otmNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nɛ bi 'yɛ̨nje: ―Majuąni dí xi ahʉ, nde'bʉ gui päh ni mbʉihʉ gui cohmbʉ tengu'bʉ gyʉ t'ʉhnihʉ, nu'bʉ hin'na hin gui sä gui cʉthʉ bʉ di manda rá ts'ɛdi Oją 'bʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nɛ nu'a to'o da gohi tengu'bʉ ra t'ʉhni nɛ da 'yøt'e ngue hin'yʉ rá ts'ɛdi, gue'a xtán hɛ̨ts'i rán t'ɛ̨di bʉ na hnu bʉ di manda rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nɛ nu'a to'o da numanho n'da ra t'ʉhni nangue ma thuhugä, nam bøni bi zingä bʉya, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","―Pɛ nu'bʉ 'bo'o di japi da 'ue a n'da ra t'ʉhni ngue i ɛ̨c'yɛigui, xʉn ʉtho ran ʉnbi da nu. Man'da xʉn ʉ xinda gue'bʉ da t'ɛrpa ra dojʉni rá 'yʉga nɛ da thørpʉ ja ra dądehe, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","―Nhuɛ̨cate ahʉ nangue yʉm 'bɛpate xʉn ngu da t'øt'ahʉ. Guehma gui nuhʉ ʉ, pɛ í huɛ̨hi maha to'o di 'bɛp'ahʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pɛ nu'bʉ guí ɛ̨mhbʉ gue'a ni 'yɛhʉ o gue ni guahʉ di 'bɛp'ahʉ gui 'yøthʉ ra ts'oqui, pɛ xʉn ho 'bʉ gui hyɛjʉ gui 'yɛmhbʉ bʉ yatho. Nguetho man'da xʉn ho 'bʉ dan 'datho ni guahʉ o gue dan 'datho ni 'yɛhʉ 'bʉ gá mba bʉ ja ra te maząi, xinda gue'bʉ di yoho ni 'yɛ o gue di yoho ni gua nɛ gui mba bʉ ja ra sibi njąm'bʉ da huɛ̨t'i. ");
INSERT INTO otmNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nɛ ngutho 'bʉ guí ɛ̨mhbʉ gue'a n'da ni dähʉ di 'bɛp'ahʉ gui 'yøthʉ ra ts'oqui, pɛ xʉn ho 'bʉ gui hyąhmbʉ gui 'yɛmhbʉ bʉ yatho. Nguetho man'da xʉn ho 'bʉ dan 'datho ni dähʉ 'bʉ gui cʉthʉ bʉ ja ra te maząi xinda gue'bʉ di yoho ni dähʉ nɛ gui mba bʉ ja ra sibi njąm'bʉ da huɛ̨t'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","―Dami jamansuhʉ a guí øthʉ. Hin gui 'yøthʉ tengu'bʉ nte di muui ʉ zicuɛ, nguetho dí xi ahʉ nu yʉ́m 'bɛhni Oją di jamansu ʉ, nɛ ząi i 'bʉpʉ ja rá hmi ma Ta bʉ mahɛ̨tsi ʉ yʉ́m 'bɛhni. ");
INSERT INTO otmNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nguetho nugä, ngue dán ją'igä ua ja ra ximhäi, bá ɛ̨cä ngue ga nyąnba yʉ́ te ʉ xøm 'bɛdi nangue yʉ ts'oqui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","13","―'Bɛ'a guím bɛ̨mhbʉ bi 'yøt'a n'da ran 'yohʉ ngue mí si n'da ciɛnto yʉ́ dɛ'yo. Nɛ bim 'bɛ a n'da. Ha him bi hyon'a bim 'bɛdi. Pɛ bi zopʉ ʉ goho 'däte ma 'dɛ'ma gʉto bʉ mi sapaxi ʉ, bi mba bi hyon'a bim 'bɛdi. Nɛ nu'bʉ mi dįni, man'da bin johya nangue'a, xinda gue'ʉ mi'da ngue him bim 'bɛdi. ");
INSERT INTO otmNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","In jabʉ ma Tahʉ bí 'bʉpʉ mahɛ̨ts'i, in ndepe xinga n'da dim 'bɛdi, madague'a hin te di muui bʉ na hnu, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nɛ man'da ram hma bi man ra Jesús, bi 'yɛ̨ngähe: ―Nu'bʉ n'da ni cuhʉ bʉ ja ram pɛti, 'bʉ hinga gue'a da 'yøt'e e, gui xi 'bʉ guí 'bʉsɛui, janangue'a da bądi hingui ho a bi 'yøt'e e, bi 'yɛ̨ngähe ra Jesús. Nɛ nu'bʉ bi 'yømanho a gui xifi, ya gá tąha gá hocpa rá mbʉi a ni cu. ");
INSERT INTO otmNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pɛ nu'bʉ hingui ʉrpa ra güɛnda a gá xifi, gui six man'da o gue mí yoho yʉ cu din testigo nangue'a guí mammi. ");
INSERT INTO otmNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pɛ nu'bʉ guexta'a him bi 'yʉrpathoho ra güɛnda a guí mammi mahøn'a, gui mam bʉ ja ram pɛti bʉya. Nɛ nu'bʉ him bi 'yʉrpa ra güɛnda a 'bɛ'a gá xihmbʉ bʉ, pɛgue gui 'yøthʉ tengu'bʉ hin ni cuhʉ a bʉya, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","―Majuąni dí xi ahʉ, nu 'bɛ'a guí ɛ̨mhbʉ hingui ho ua ja ra ximhäi, nɛpʉ mahɛ̨ts'i i t'ɛ̨mbi hingui ho a. Nɛ ngutho a guí ɛ̨mfʉ xʉn ho, nɛpʉ mahɛ̨ts'i i t'ɛ̨mbi xʉn ho a, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","―Nɛ nu'bʉ guí yohmi 'bʉ n'dat'a guím bɛ̨mmi 'bʉ ja a guí ähui ma Tahʉ 'bʉpʉ mahɛ̨ts'i, nu'a di 'da aui a gá 'yähui. ");
INSERT INTO otmNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nguetho nu'bʉ dim pɛti nangue ma thuhugä 'da, madague'bʉ yoho o gue hyu, pɛgue dí 'bä i nde bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nɛ bi 'yän'na ra Pedro: ―Gra Hmu, xi'bʉ ja 'bɛ'a da 'yørca n'da ra ją'i, hangu yʉ nidi ga punbi. Ha xøt'a yoto nidi, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Bi dą a ra Jesús: ―Hinga hønt'i yoto nidi, pɛ nde'bʉ thocpa tho gui punbahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","―Janangue'a dí xi ahʉ, nu'a nán ts'ʉt'abi Oją, i øt'e tengu bi 'yøt'a n'da ra ts'ʉt'abi 'bʉ mi 'yʉrpa ra güɛnda hangu in dupate yʉ́m fäts'ihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nɛ nu'bʉ mi nu rá søcuą, 'bexgue bi manda ba ts'i a n'da ngue min dupate yʉ millone thoho. ");
INSERT INTO otmNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pɛ nu'a ra ją'i, hin'yʉ 'bɛ'a mi ja ngue xtán zä xtán gut'a min dupate. Nɛ nu ra ts'ʉt'abi bʉya, mi nde xtá mbä a, nɛ yʉ́ t'ʉhni, nɛ rá xisu mí 'bʉpʉ ja rá ngu, nɛ 'bɛ'a gä mi pɛ'ts'i, ngue da gut'a ndupate. ");
INSERT INTO otmNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nɛ nu'a ran 'yohʉ bʉya bin dąnyahmu nɛ nts'ɛdi bi 'yäp ra mate a rá hmu: “Gra hmu, tøcpi ts'ʉ, jante tho ga jut'i i.” ");
INSERT INTO otmNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nu rá hmu bʉya bi huɛ̨c'a, nɛ bi punba a rán dupate nɛ bi thøh pʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pɛ nu'bʉ mi nɛxpʉ, bin c'at'ui n'da rá mimbɛfiui xí hmit'i ts'ʉ ra mbɛti. Nu'a xí mba ma thøgue bʉya, 'bexgue bim bɛnt'ąte, bi bɛndba rá 'yʉga a bin c'at'ui, nɛ bi 'yɛ̨mbi: “Curca a ma mbɛti guí tuc ya,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nɛ nu'a rá mimbɛfiui bʉya bin dąnyahmu nɛ nts'ɛdi bi 'yäp rá mate, bi 'yɛ̨mbi: “Tøcpi ts'ʉ, jante tho ga jut'i i,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pɛ nu'a xí mba ma punbi him bi dø'mi, bi got'a fädi, ɛ̨mbi din ofädi jague'bʉ da gut'a in dupate. ");
INSERT INTO otmNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nɛ nu yʉ́ mimbɛfiui bʉya ɛ̨mmɛ bi bɛ̨ndumbʉi 'bɛ'a bi 'yøt'a xí mba ma punbi, nɛ bi mba bi xi a rá hmu 'bɛ'a bi 'yøt'a. ");
INSERT INTO otmNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nu yʉ́ hmu bʉya bi manda bá ts'i a ran 'yohʉ mahøn'a nɛ bi 'yɛ̨mbi: “Gra ts'om'bäi, nugä dá pun'ni i 'bʉ gmí 'yäc ra mate, madague'a xʉn ngu guí tuqui. ");
INSERT INTO otmNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nde'bʉ nɛ'e xquí huɛ̨c'a ni mimbɛfiui,” bi 'yɛ̨n'a rá hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɛ̨mmɛ bin cuɛ a rá hmu, bi manda da jot'i gue'bʉ go bi gut'a gätho yʉ millone min dupatesɛ, bi 'yɛ̨n'a ra Jesús, 'bʉ mi man a ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Din jabʉ da 'yøt'ahʉ ma Tahʉ 'bʉpʉ mahɛ̨ts'i 'bʉ hin gui punbahʉ ni miją'ihʉ ngue gätho ni mbʉihʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nɛ nu'bʉ mi gua'a man ra Jesús, bi bøm bʉ Galilea, bi hyąx ra 'yu ni mba bʉ ra xɛqui Judea, 'danguadi ra dąthe Jordán. ");
INSERT INTO otmNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nɛ xʉn ngu yʉ ją'i bi dɛnthoho nɛ bi hoqui xʉn ngu yʉ hyɛ̨nni. ");
INSERT INTO otmNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nɛ nubʉya, bi zøm bʉ'da ma ngʉrpihe ngue yʉ fariseo, bʉ mi 'bäh ra Jesús. Mí honi 'bɛ'a dí yąpi, nɛ bi 'yɛ̨mbi: ―Ha sä da hyɛh rá xisu n'da 'bʉ madí ts'ʉtho 'bɛ'a da 'yøt'e, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nu ra Jesús bi dąti: ―Ha hin gá nuhʉ bʉ ja rám hman Oją, ngue'bʉ rá mbʉdi thoho ra ximhäi bi zän Oją n'da ran 'yohʉ nɛ n'da rá xisu. ");
INSERT INTO otmNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nɛ i mam bʉ: “Nu n'da ran 'yohʉ him man da dɛn'na rá ta o rá mbe 'bʉ dim 'bʉhmi rá xisu, pɛ dim 'bʉhmi da gohi tengu'bʉ n'dan ją'itho,” i ɛ̨m bʉ ja rám hma Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Janangue'a nu'bʉ n'da ran 'yohʉ i 'bʉhmi rá xisu, pɛ hingui yonją'i bʉ na hnu, n'datho. Nɛ nu'a bi zän Oją, dim 'bʉi tengu'bʉ n'dan ją'itho, pɛ hin njon da bɛ̨ni din hyɛgui, bi 'yɛ̨n'a ra Jesús, bi t'ɛ̨mp'ʉ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","―Hanja gní 'yɛ̨nje, nɛ nu ra Moisés bi ma da t'øt'a n'da rá søcuą ran xuni 'bʉ da hyɛh rá xisu n'da ran 'yohʉ, bi 'yɛ̨n'ʉ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Xø bi 'yɛ̨n'a ra Jesús bʉya: ―Gue'a bi 'yo't'a ra Moisés, nguetho ɛ̨mmɛ xʉm mɛ ni mbʉihʉ. Pɛ nu'bʉ rá mbʉdi ra ximhäi him mín jabʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nɛ dí xi ahʉ, nu'bʉ n'da ran 'yohʉ bi hyɛh rá xisu nɛ him mi 'yomt'ɛ̨ni a rá xisu, pɛ nu'bʉ bin thąt'ui man'da ra xisu a ran 'yohʉ, ya i 'yomt'ɛ̨ni a bʉya. Nɛ ngutho 'bʉ n'da ran 'yohʉ din thąt'ui n'da ra xisu bi thɛgui, nɛ a ra 'yomt'ɛ̨ni a bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nɛ nubʉya, dá ɛ̨mbähe ra Jesús: ―Nu'bʉ hingui sä da hyɛh rá xisu n'da, man'da xʉn ho 'bʉ hin din thąt'a n'da 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ra Jesús bi 'yɛ̨na: ―Pɛ hinga gätho da zä din jabʉ, pɛ hønt'ʉ bi zän Oją din jabʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nguetho i 'bʉ i 'da ngue him bim 'bʉh rá xisu nguetho yʉ mbɛdi gue'bʉ go mim 'bʉi. Nɛ nu'ʉ mi'da yʉn 'yohʉ him bim 'bʉh yʉ́ xisu nguetho bi mbocpa ʉ yʉ́ hmu. Nɛ nu'ʉ mi'da, yʉ́ pähä zɛhɛ him bim 'bʉh rá xisu nguetho gue'a í ts'änni ngue hin dim 'bʉh rá xisu, ngue nte di hɛ̨ni nangue rá 'bɛfi Oją mahɛ̨ts'i da 'yøt'e. Nu'a to'o da bɛ̨n'na ram hma na, gue'a da bą a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nɛ nubʉya bá ts'inba 'da yʉ t'ʉhni bʉ mi 'bʉh ra Jesús, ngue'a mi hndepe da dospa yʉ́ yą yʉ t'ʉhni, nɛ da 'yäp rán jąpi Oją nangue ʉ yʉ t'ʉhni. Nugähe bʉya, dá hɛcpähe ʉ yʉ́ ta ʉ yʉ t'ʉhni ngue hin da thopʉ 'bä a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pɛ nu ra Jesús bi 'yɛ̨nje: ―O guí hɛcpahʉ yʉ t'ʉhni ngue him ba thocua, pɛ dami jafʉ ba thocua, nguetho nu'ʉ to'o di manda rá ts'ɛdi Oją, tengu'bʉ yʉ t'ʉhni ʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nɛ bi dospa yʉ́ yą yʉ t'ʉhni bʉya nɛ bi 'yäp rá mfäts'i Oją. Nɛ nu'bʉ mi jua a bi 'yøt'a ra Jesús, dá pøngähe bʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nɛ man'da ra ts'ʉnt'ʉ bi mba bʉ 'bä a ra Jesús nɛ bi 'yɛ̨na: ―Hoga xänbate i, 'bɛ'a nin ho da zä ga øt'ä ngue ga tįngä ra te, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ra Jesús bi 'yɛ̨mp'a: ―Ha guím bɛ̨ni 'bɛ'a guí ma ngue guí ɛ̨ngui xʉn hogui, nguetho hønt'a xʉn ho a Oją. Pɛ nu'bʉ guín nde gui tįn ra te, dami ją'ts'ʉ yʉn t'ɛ̨di. ");
INSERT INTO otmNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","―Nda'a nín t'ɛ̨di, bi 'yɛ̨n'a ra ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bi dą'a ra Jesús: ―O guí hącpa rá te ni miją'iui, o guí 'yomt'ɛ̨ni, nɛ o guím pɛ̨, nɛ o guí man yʉ fɛhni, nɛ gui numansu ni ta nɛ ni mbe, nɛ gui huɛ̨c ni miją'iui tengu'bʉ da guesɛ i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","―Gätho ʉ xtá ją'ts'i gue'bʉ go mán t'ʉhni, 'bɛ'a man'da di 'bɛdi ga øt'e, bi 'yɛ̨n'a ra ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nu ra Jesús bi 'yɛ̨mp'a: ―Nu'bʉ guí nde gui tįn ra te, ní mba bá pä 'bɛ'a gätho i ja i, nɛ gui darpa yʉ hyoya a rá muui 'bɛ'a gätho gá pä, nɛ din ja'a man'da di muui bʉ mahɛ̨ts'i bʉya, nɛ nubʉya ba ɛ̨hɛ gui tɛngui. ");
INSERT INTO otmNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pɛ nu ra ts'ʉnt'ʉ 'bʉ mí 'yø a bi xifi, ɛ̨mmɛ bi du rá mbʉi, nguetho ɛ̨mmɛ xʉn ngu 'bɛ'a gä mi ja, nɛ bi mbeng thoho bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nɛ nu a ra Jesús bʉya: ―Majuąni dí xi ahʉ, bi 'yɛ̨na, xʉn hɛ̨i da yʉrpʉ di manda rá ts'ɛdi Oją n'da ra mɛmbɛti. ");
INSERT INTO otmNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dami 'yøhmbʉ mahøn'a. Man'da hingui hɛ̨i da yʉt'a ra camello bʉ ja rá gu ra 'yofani, xinda gue'a n'da ra mɛmbɛti da yʉrpʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nɛ dá hyonya thohohe 'bʉ má øhmbe bi ma ra Jesús. “To'o maha da zä din yąni,” dán 'yɛ̨m zɛhɛhe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bi hyɛ̨rcähe ra Jesús nɛ bi 'yɛ̨nje: ―Hin da zä da 'yøzɛhɛ yʉ ją'i, pɛ nu'a Oją hingui hɛ̨mp'a da 'yørpa ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nu ra Pedro bʉya bi 'yɛ̨mp'a ra Jesús: ―Gra Hmu, nugähe dá socähe gätho 'bɛ'a mí pɛts'ähe nɛ dá tɛn'nahe, 'bɛ'a maha ga tįmhbe ya. ");
INSERT INTO otmNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ra Jesús bʉya bi 'yɛ̨nje: ―Majuąni dí xi ahʉ, 'bʉ bin ja ma'da'yo mahɛ̨ts'i nɛ ma'da'yo ra ximhäi, din ja ma ts'ɛdi mixte, ga hupʉ ja ma mɛxa ga øt' ran ts'ʉt'abi, nugä ngue dán ją'igä ua ja ra ximhäi. Nɛ ahʉ guí 'dɛ'mayoho ahʉ, 'darbʉ ga huhmbʉ, ga comhbʉ ma ts'ɛdigä, nɛ'ahʉ ga juąnbahʉ ma mi israelhʉ dyʉ judíohʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nu'a to'o bi zoh rá ngu, o gue rán 'yohʉ o gue rán ju, o gue rá ta o gue rá mbe, o gue rá xisu o gue yʉ́ t'ʉhni bi zogui ngue bi dɛngui, o gue rá huąhi, da dąha man'da xʉn ngu xinda guet'a n'da ciɛnto nidi, nɛ a ra te maząi da hyąni, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pɛgue nu'ʉ im bɛ̨ni i 'bɛt'o dim 'bɛjua ʉ. Pɛ nu'ʉ t'ɛ̨mbi i 'bɛjua, dim 'bɛt'o ʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nɛ man'da ran t'uti bi man ra Jesús, bi 'yɛ̨na: ―Nu'bʉ bi 'yøt' ran ts'ʉt'abi Oją, din ja tengu bi 'yøt'a n'da ran 'yohʉ mí ja ra dąhuąhi. Midi 'yonba yʉ mbɛfi 'bʉ xudi thoho. ");
INSERT INTO otmNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nɛ 'bex bi xifi hangu da gu't'i, nɛ bi mba bʉ ja rá huąhi ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nu'bʉ mbɛ gʉto xudi, xø i 'yo bʉ hnini a ra mɛ'bɛfi mahøn'a, nɛ bi nu 'da yʉn 'yohʉ mi 'yotho bʉ nɛ bi mbɛn bʉ ja rá huąhi. ");
INSERT INTO otmNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Ní mbähä, gam pɛhmbʉ, ga jut'ahʉ hangu dí nde ahʉ gui tąhmbʉ,” bi 'yɛ̨mbi. Nɛ bi mba ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nɛ nu'bʉ mi hyuxyadi, xø 'yo bʉ ja ra hnini mahøn'a ra mɛ'bɛfi nɛ bi mbɛnh mi'da bʉ rá huąhi. Nɛ'bʉ mi zøn'a hyu nde, xø bi mbɛnh mi'da. ");
INSERT INTO otmNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nɛ'bʉ mi zøn a cʉt'a nde, xø 'yo bʉ mahøn'a nɛ bi nu bʉ mi'da yʉ ją'i: “Hanja ngue xcán dethohʉ,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nguetho njon bi xije ra ' bɛfi,” bi 'yɛ̨n'ʉ. Nɛ bi 'yɛ̨mp'ʉ: “Ní mbähä bʉ ja ma 'bɛfigä gam pɛhmbʉ bʉ, ga jut'ahʉ hangu dín ndegä ga jut'ahʉ,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nu'bʉ min de bʉya nu ra mɛ'bɛfi bi xi a rá ngʉrpa mbɛfi: “Dami zon'dʉ yʉ mbɛfi, m'bɛt'o gui jut'ʉ m'bɛjua bi zøni,” bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nɛ nu'bʉ mi mba nju't'i ʉ xi zøm bʉ ja ra huąhi 'bʉ cʉt'a nde, bin ju't'i tengu'bʉ gä ra pa xtím pɛfi. ");
INSERT INTO otmNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nɛ nu'bʉ min ju't'ʉ bi mbʉmxudi ra 'bɛfi, bi bɛ̨ni ngue man'da xtán dąha xʉn ho xinda gue'ʉ n'da ora tho bim pɛfi. Pɛgue 'da'angu bi dąha. ");
INSERT INTO otmNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Janangue'a bin cuɛ ʉ 'da ");
INSERT INTO otmNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nɛ bi 'yɛ̨mp'a ra mɛ'bɛfi: “Hanja ngue 'da angu gá jurcahe ʉ m'bɛjua bi zøhø, nɛ ts'ʉtho bim pɛ ʉ. Pɛ nugähe, gätho ra pa dám pɛhmbe, madague'a xʉm pa ra hyadi,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pɛ bi dąti, bi 'yɛ̨mp'a n'da mí 'bäpʉ: “Xi'e n'yø, nte man ts'o dá øt'e e. Ha hinga gue'a dá xi i dá jut'i i. ");
INSERT INTO otmNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dami hyąn'a nin zäbi, ní mba. Nugä, i ja ma pähä 'da angu ga jut'ahʉ ʉ rán zɛgui bi zøhø. ");
INSERT INTO otmNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ha hin'yʉ man t'ɛ̨di ga øt'ä a dín nde ga øt'ä nangue ma mbɛti, uague guí sɛya nguetho dá ørpa ran hocją'i n'da,” bi 'yɛ̨n'a ra mɛ'bɛfi bʉya, bi 'yɛ̨n'a ra Jesús 'bʉ mi man a ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nɛ ngubʉ din ja 'bʉ bin ts'ʉt'abi Oją. Nu'ʉ m'bɛjua dim 'bɛt'o ʉ, nɛ nu'ʉ 'bɛt'o dim 'bɛjua ʉ. Xʉn ngu bi zonhd Oją, pɛ hinga gätho bi huahni, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nɛ nu'bʉ mi ts'ʉtho ga sømhbe bʉ Jerusalén, dí 'yohe bʉ ja ra nguani. Nɛ bi gʉgähe bʉ ma'ueni ts'ʉ a ra Jesús, dí 'dɛ'mayohohe, nɛ bi 'yɛ̨nje: ");
INSERT INTO otmNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Nuya ga mbähä bʉ Jerusalén. Nu'bʉ dá sømhbʉ bʉ, da mba ma dägä bʉ 'bʉh yʉ hmumbäją nɛ yʉ xänbate niją, ngue da hyogä, guecä dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nɛ di dägä bʉ 'bʉ ʉ him ma mijudíohʉ, nɛ din thengui nɛ da thɛxcä nɛ di cuarcä bʉ ja ra za, ga tu bʉ, nɛ da t'ägui. Pɛ nu'bʉ ná hyupa ga thąmbɛ̨nigä, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nɛ nu'a rá mbe ra Jacobo nɛ ra Xuua, ngue yʉ́ ts'ʉnt'ʉ ra Zebedeo ʉ, bin dąnyahmu bʉ ja a rá gua ra Jesús, in nde 'bɛ'a da 'yäpi. ");
INSERT INTO otmNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nɛ nu ra Jesús bi 'yɛ̨mbi: ―'Bɛ'a guí nde ga øt'e e, bi 'yɛ̨mbi. ―Dami 'yørca ra mate ngue nu'bʉ gui 'yøt' ran ts'ʉt'abi, 'da xtí hyut'ʉ ma t'ʉhni, bi 'yɛ̨n'a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bi dą a ra Jesús: ―Pɛ hin guí pądi 'bɛ'a nam bøn'a gá 'yäqui. Nɛ bi 'yän'na ra Jacobo nɛ ra Xuua: ―Ha guí ɛ̨na nɛ'aui gui hyät'ui gui nuui ran ʉnbi tengu gan nugä, bi 'yɛ̨n'a ra Jesús. Nɛ bi dą ʉ bʉya: ―Hąha, ga hät'be. ");
INSERT INTO otmNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","―Majuąni maha, nɛ'aui gui nuui ran ʉnbi tengu gan nugä, pɛ hingui sä ga 'da'a ran t'ɛ̨di guí ähmi. Pɛ gue'a ma Ta di un rán t'ɛ̨di to'o in ndepe 'da xtí hyutho 'bʉ dán ts'ʉt'abigä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nɛ nugähe dí 'dɛt'agähe bʉya dán cuɛ 'bʉ má øhmbe a 'bɛ'a bi man ʉ yoho. ");
INSERT INTO otmNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nɛ gä bi zongahe ra Jesús dí 'dɛ'mayohohe, nɛ bi 'yɛ̨nje: ―Nu'ʉ yʉ ts'ʉt'abi ua ja ra ximhäi i øt' yʉ́ 'yɛ̨hɛ to'o gätho di manda, nɛ tengu'bʉ maguesɛ yʉ́ ts'ɛdi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pɛ nu'ahʉ hinga gue'a gui 'yøthʉ a. Pɛgue gan 'yɛ̨hɛ thohohʉ nangue ʉ mi'da 'bʉ guí nde din ja ni ts'ɛdihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","28","Nɛ nu'ahʉ 'bʉ guín nde gam 'bɛt'ohʉ, gui 'yøthʉ ngue hin'yʉ ni ts'ɛdihʉ nɛ gan 'yɛ̨hɛ thohohʉ, tengu thohogä ngue dán ją'igä ua ja ra ximhäi, him bá ɛ̨cä dam hmugä, pɛ bá ɛ̨cä dan 'yɛ̨hɛgä nɛ ga dä ma te gan yąnba yʉ́ te yʉ ją'i, bi 'yɛ̨nje ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nɛ nu'bʉ xø má nɛxhe bʉ ra hnini Jericó, xʉn ngu yʉ ją'i bi dɛntho na ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nɛ mí hupʉ yoho yʉ xädä bʉ ja ra nden'yu. Nu'bʉ mí 'yøde mba bʉ ra Jesús, bi mbafi: ―Grá Hmu, rám bom'bɛto i ra David, dami huɛ̨gä'be, bi 'yɛ̨n'ʉ yʉ xädä. ");
INSERT INTO otmNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nɛ nu yʉ ją'i min 'yohʉ ra Jesús bi hɛcpa ʉ yʉ xädä. Pɛ man'da bi mba ʉ, bi 'yɛ̨m mahøn'a: ―Grá Hmu, rám bom'bɛto i ra David, dami huɛ̨gä'be, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nu ra Jesús bʉya 'bʉ mí 'yø a man ʉ yʉ xädä, bi 'yänni: ―'Bɛ'a guín nde ga øt'aui, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nu'ʉ bi dąti: ―Grá Hmu, xoga ma dä'be, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɛ̨mmɛ bi huɛ̨c'a ra Jesús ʉ, bi därpa thoho yʉ́ dä, 'bex bi xoh yʉ́ dä nɛ bi dɛn'na ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nɛ bi zøm bʉ ja ra ndehnini Betfagé, nubʉ ja ra nyuni Olivos, nɛ him ma yabʉ ra hnini Jerusalén. Nu ra Jesús bʉya bi mbɛn'ndʉ yoho ma mixädihe, ");
INSERT INTO otmNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nɛ bi 'yɛ̨mbi: ―Ní mbɛ nʉ ja ra t'ʉhnini, guehnʉ gua tįmmi n'da ra buru in 'youi rá bąsi. Bá xocui, nɛ bá siui ua ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu'bʉ da t'ɛ̨n'aui 'bɛ'a gui jahui, “Nu'a ra hmu da hyon'i ts'ʉ nɛ 'bexgue ba sin'a thoho'be,” gui 'yɛ̨m thohoui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nɛ guehna bi man ra pøngahyą maya'bʉ ngue din ja 'bʉ mi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gui 'yɛ̨mfʉ yʉ mɛngu bʉ Jerusalén: “Dami nuhʉ ya ba ɛ̨cua ni hmuts'ʉt'abihʉ, nɛ hin din 'yɛ̨ts'i, ba hyux'a n'da zi buru thoho bán 'youi rá bąsi,” gui 'yɛ̨mfʉ, bi 'yɛ̨n'a ra pøngahyą maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nu ma mixädihe bʉya bi mba nɛ bi 'yøt'a bi xih ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nɛ bá si ra buru nɛ'a rá bąsi, nɛ bi gąspa yʉ́ coto nɛ bi hyux'a ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɛ nu yʉ ją'i ɛ̨mmɛ xʉn ngu ʉ bi dɛnni nɛ bi mbøh yʉ́ coto bʉ ja ra 'yu nɛ yʉ́ pahni, nɛ yʉ́ paxi yʉ za bi mbøcpa bʉ ngue da thopʉ ra Jesús. Nɛ bi 'yɛ̨t'inde ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nɛ nu'ʉ i 'bɛt'o nɛ'ʉ bim 'bɛjua bi mbʉh na thuhu bʉya, bi 'yɛ̨na: ―Mixte thoho rá ts'ɛdi rám bom'bɛto ra David. Nɛ xʉn ngu rán jąpi in 'youi, nguetho bá ɛ̨hɛ nangue rá thuhu Oją, ra Hmu. Mixte thoho Oją mahɛ̨ts'i, bi 'yɛ̨n'ʉ yʉ ją'i bʉ ní mba. ");
INSERT INTO otmNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nɛ nu'bʉ bi yʉrpʉ Jerusalén ra Jesús, gätho mi 'bʉpʉ ja ra hnini bi hyonya thoho, nɛ bi 'yän'ndʉ mín 'yohʉ ra Jesús: ―To'o nín 'yohʉ na, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","―Guehna ra pøngahyą, ra Jesús, ra mɛngu Nazaret bʉ ra häi Galilea, bi 'yɛ̨n'ʉ bi t'änni. ");
INSERT INTO otmNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nɛ nu'bʉ mi zøm bʉ Jerusalén a ra Jesús bi yʉrpʉ ja rá dąniją Oją, bi hyøn a thi gätho ʉ mím pä bʉ nɛ'ʉ mín täi bʉ. Nɛ bi ndønpa yʉ́ mɛxa ʉ midí päh yʉ mbɛti, nɛ bi bʉntpa yʉ́n thuts'i ʉ mi pä yʉ ts'ąha, nɛ bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Í thø a ma ngu ngue da mba nthąndegä bʉ,” i ɛ̨n Oją, i ɛ̨m bʉ ja rám hma. Pɛ nu'ahʉ gá 'yørpadahʉ tengu'bʉ ra hyądo guepʉ nín 'yąn'ʉ yʉ bɛ̨, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nɛ nu'bʉ mí 'bʉpʉ ja ra dąniją, xø bi zøm bʉ mi'da yʉ xädä, nɛ'ʉ mi dogua. Nu ra Jesús bi hoc'ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pɛ nu yʉ hmumbäją nɛ yʉ xänbate niją him bi numanho yʉ́n t'øt'e bi 'yøt'a ra Jesús bʉ. Nɛ bin cuɛ 'bʉ mí 'yø a bi man'ʉ yʉ t'ʉhni 'bʉ mí 'yɛ̨na: “Mająpi rám bom'bɛto ra David,” bi t'ɛ̨mp'a ra Jesús: ");
INSERT INTO otmNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","―Ha hin guí ø'a 'bɛ'a man yʉ t'ʉhni ngue i ɛ̨'ts'i i, bi t'ɛ̨mp'a ra Jesús. ―Dí øcä a i man'ʉ, bi 'yɛ̨n'a. Pɛ xi ahʉ ha hin guím bɛ̨mhbʉ a i mam bʉ ja rám hma Oją ngue i ɛ̨na: Gá japi bi bømanho a i man ʉ yʉ t'ʉhni 'bʉ i ɛ̨'ts'i i, bi t'ɛ̨mp'a Oją 'bʉ mi t'ɛ̨mbi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nɛ bi zotpʉ ʉ yʉ hmumbäją nɛ yʉ xänbate, dá mbäcähe a ra Jesús, bán oxähe bʉ ja ra hnini Betania. ");
INSERT INTO otmNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nɛ nu'bʉ mí hyax bʉya, xø dá pengähe a ra Jesús bʉ Jerusalén. Nɛ bin tumanthuhu bʉ 'yu. ");
INSERT INTO otmNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nɛ bi nu n'da ra za bʉ ja ra nden'yu, bi mba ɛ̨na da dʉcpa n'da rán dät'ä. Pɛ hønt'ʉ yʉ́ paxi mi ja. Nɛ bi 'yɛ̨n'a ra Jesús: ―Nuya, njąm'bʉ din zʉh nin dät'ä ya. Nɛ 'bexgue bi 'yot'a ra za bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nu'bʉ mán nuhe bi 'yot'a ra za, dá hyonya thohohe nɛ dá änhde ra Jesús: ―Hanja í 'yot'a n'dihi ra za, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bi dą'a ra Jesús: ―Majuąni dí xi ahʉ, nu'bʉ gui 'yɛ̨c'yɛigahʉ xʉn ho, nɛ n'dat'a guim bɛ̨mhbʉ a rá ts'ɛdi Oją, hinga hønt'a dá øt'ä sä gui 'yøthʉ, pɛ sä gui 'yøthʉ man'da xʉn hɛ̨i. Sä gui xihmbʉ nʉ ra t'øhø: “Dami 'uegue guin hyøzɛhɛ bʉ ja ra deją,” gui 'yɛ̨mfʉ, nɛ da 'ueh pʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nɛ nu Oją di 'da ahʉ 'bɛ'a gä guí äfʉ 'bʉ n'dat'a guím bɛ̨mhbʉ a rá ts'ɛdi Oją, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nɛ nu'bʉ má sømhbe bʉ Jerusalén, xø bin xänbate bʉ ja ra dąniją a ra Jesús. Nɛ xø bi mba bʉ yʉ hmumbäją nɛ mi'da ma ngʉrpihe, nɛ bi 'yän mahøn'a: ―Hanja gní 'yøt'a njabʉ. To'o bi 'da'a nin t'ɛ̨di, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Bi 'yɛ̨n'a ra Jesús bʉya: ―Nɛcä ga än'nahʉ to'o bi un rán t'ɛ̨di ra Xuua ngue bi 'yøt' ran xixyą. Hague Oją uague yʉ ją'i. Nu'bʉ gui xijʉ, nɛcä ga xi ahʉ to'o bi 'dacä man t'ɛ̨di bʉya, bi 'yɛ̨n'a ra Jesús. Nɛ bin 'yɛ̨mzɛhɛ ʉ yʉ hmumbäją nɛ yʉ xänbate niją: ―“Bɛ'a gue ga xihmbʉ, nguetho nu'bʉ ga ɛ̨mfʉ, “Oją bi un rán t'ɛ̨di a ra Xuua,” nɛ da 'yɛ̨na: “Hanja hin gá 'yɛ̨c'yɛihʉ thą.” ");
INSERT INTO otmNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nɛ nu'bʉ ga ɛ̨mfʉ, “yʉ ją'i thoho bi un rán t'ɛ̨di ra Xuua,” pɛ da zʉjʉ yʉ ją'i 'bʉ, nguetho im bɛ̨n ʉ ngue rá pøngahyą Oją a ra Xuua, bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Janangue'a bi 'yɛ̨mp'a ra Jesús: ―Hin dí pąhmbe, bi 'yɛ̨ntho ʉ. Nu ra Jesús bʉya bi 'yɛ̨na: ―Xínga guecä ga xi ahʉ to'o bi 'dacä man t'ɛ̨di ga øt'ä a dí øt'ä, bi t'ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nu n'da ran 'yohʉ mí 'bʉ i yoho yʉ́ ts'ʉnt'ʉ. Nɛ bi 'yɛ̨mp'a n'da rá ts'ʉnt'ʉ: “Ní mba bʉ huąhi, bám pɛfi,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nɛ bi dą'a rá ts'ʉnt'ʉ: “Hin'na, hin ga mba,” bi 'yɛ̨ntho. Pɛ m'bɛjua bin 'yomfɛ̨ni ts'ʉ nɛ bi mba bim pɛfi. ");
INSERT INTO otmNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nɛ'a man'da rá ts'ʉnt'ʉ bi xifi da mba mahøn'a. “Hąha, ga mba,” bi 'yɛ̨na. Pɛ him bi mba, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nɛ xø bi 'yän'ndʉ yʉ xänbate niją: ―Nuya, dami xiqui nangue ran t'uti dá xi ahʉ, nda'a ní ts'ʉnt'ʉ ngue njuąntho bi 'yøt'a rá pähä rá ta, bi 'yɛ̨n'a ra Jesús. Nu'ʉ bi dąti: ―Masque nu'a ra ts'ʉnt'ʉ him mi nde da mba 'bʉ ra mbʉdi, gue'a njuąntho bi 'yøt'a rá pähä rá ta, bi 'yɛ̨n'ʉ. Nɛ nubʉya bi 'yɛ̨n'a ra Jesús: ―Guehma majuąni dí xi ahʉ, nu yʉ ziyate hyącahäi nɛ yʉ xisu 'yomt'ɛ̨ni, man'da da yʉrpʉ di manda rá ts'ɛdi Oją, pɛ nu ahʉ hin gui cʉthʉ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nguetho nu'bʉ mi xi'ahʉ a ra Xuua Nxixyą, bi xän'nahʉ a ra 'yu xʉn ho, nɛ nu ahʉ hin gá 'yɛ̨c'yɛihʉ. Pɛ nu yʉ hyącahäi nɛ yʉ xisu i 'yomt'ɛ̨ni, man'da go bi 'yɛ̨c'yɛi ʉ nɛ bi päh yʉ́ mbʉi. Nɛ nu'bʉ gmí nuhʉ ʉ, nɛ guexta'a hin gá nde gá päh ni mbʉihʉ, bi t'ɛ̨mp'ʉ yʉ hmumbäją nɛ yʉ xänbate niją. ");
INSERT INTO otmNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nɛ bi 'yɛ̨m mahøn'a ra Jesús: ―'Yøhmbʉ ts'ʉ man'da ran t'uti ga xi ahʉ. Mí 'bʉ a n'da ran 'yohʉ mi ja rán uąndät'ä, nɛ bi fø't'e, nɛ bi hyø a n'da ra ngu guepʉ da thɛmp' yʉ guindät'ä. Nɛ bi mbä'ma n'da ra jądo xʉn hɛ̨ts'i, da ndex'ʉ da nu rá häi. Nɛ nubʉya bi hmit yʉ́ häi ʉ 'da yʉ mbɛfi, nɛ bi nde bi mba n'danni a ran 'yohʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nɛ nu'bʉ mi ts'ʉtho din ja yʉn dät'ä, bá pɛhn'i 'da yʉ́ 'yɛ̨hɛ da duspa ʉ yʉ́n dät'ä, nguetho gue'a án yąhʉ a, ngue di un'ni ts'ʉ 'bɛ'a da bøm bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pɛ nu'ʉ yʉ mbɛfi bi bɛnt'ʉ yʉ́m 'bɛhni a ra hmu. Nu'a n'da bi mbɛmthoho. Nu'a man'da bi hyotho. Nɛ nu'a man'da, bi hyøta dotho a. ");
INSERT INTO otmNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nɛ xø mahøn'a, bá pɛhn mi'da xʉn ngu yʉ́ 'yɛ̨hɛ ngue xtan duspa yʉ́n dät'ä a rá mbɛti ran uąndät'ä. Pɛ nu'ʉ yʉ mbɛfi xø bi bɛnt mahøn'a 'bʉ mi zøpʉ ʉ, nɛ 'da'angu bi t'ørpe tengu bi t'ørpa ʉ mbʉdi bi zøpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nɛ nubʉya bá pɛn'na rá ts'ʉnt'ʉ zɛhɛ a rá mbɛti ra huąhi. Bi bɛ̨ni: “Masque da numansu na ma ts'ʉnt'ʉ.” ");
INSERT INTO otmNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pɛ nu'bʉ mí nu ba ɛ̨pʉ rá ts'ʉnt'ʉ, nu yʉ mbɛfi xø bi bɛ̨n'ʉ: “Nuna, rá ts'ʉnt'ʉ zɛhɛ, da gohmi ra häi na 'bʉ bi du rá ta. Pɛ mbähä ga hohʉ, janangue ga cosɛhʉ ra häi bʉya.” ");
INSERT INTO otmNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nɛ bi bɛnt bʉya, bi zixpʉ ma'ueni nɛ bi hyo, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nu ra Jesús bi 'yän'ndʉ mí 'bäpʉ: ―Xi'bʉ da mbasɛ na ra hmu, 'bɛ'a da jap'ʉ yʉ́ mbɛfi 'bʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bi dą ʉ bʉya: ―Masque da hyo ʉ yʉ́ mbɛfi, nguetho ɛ̨mmɛ yʉ ts'om'bäi ʉ, nɛ nu rá häi bʉya di hmit'ʉ i pądi da gu't'a ra renta 'bʉ bi zøn ra pa da gu't'i, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nɛ xø bi 'yɛ̨m bʉya: ―Ha njąm'bʉ gá nuhʉ bʉ ja rám hma Oją a ram hma i ɛ̨na: Nu'a ra do bi bʉnt'ʉ yʉ gądo 'bʉ mi hyøh ra ngu, gue'a ra do man'da mahyoni, tengu thoho yʉ guangu. Gue'a bi zän Oją a, nɛ gui hyonya thohohʉ, i ɛ̨m bʉ rám hma Oją, bi 'yɛ̨n'a ra Jesús. Nɛ gue'a i mam bʉ nangue a rá Thahni Oją ngue ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Janangue'a dí xi ahʉ, Oją him bi numanho a gá 'yøthʉ nɛ da thąn'nahʉ a ra 'bɛfi bʉ di manda rá ts'ɛdi Oją, din t'un'dʉ mi'da ngue da 'yøt'manho a ra 'bɛfi gmí øthʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nɛ nu'a ra do bi mba ma bʉnt'i, tengu'bʉ n'da ra xįndo i ti bʉ ja ra 'yu. Nɛ hønt'a go to'o da dąng bʉ ja ra do, din tʉni, nɛ hønt'a go to'o da zɛ'ma ra do, 'bexgue da 'yɛt'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nu'bʉ mi 'yø'a bi man a ra Jesús, bi bą ʉ yʉ fariseo nɛ yʉ hmumbäją, gue guesɛ ʉ bi 'yøt'ʉ bi sifi. ");
INSERT INTO otmNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nɛ mí nde 'bexgue xtám bɛnt'a ra Jesús, pɛ him bi bɛnt'i, nguetho mi su ʉ yʉ ją'i, ngue mi ɛ̨n'ʉ, rá pøngahyą Oją a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nɛ xø bi thoqui bi xänba yʉ ją'i nangue yʉn t'uti thoho bi man a ra Jesús, nɛ bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nu'a ní manda rá ts'ɛdi Oją, i t'øt'e tengu bi 'yøt'a n'da ra ts'ʉt'abi. Nu'a ra ts'ʉt'abi bi zän'na n'da ra ngo 'bʉ min thąta n'da rá ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nɛ bi mbɛn'dʉ yʉ́m 'bɛhni ngue ba sinba yʉ́ amigo, pɛ him bi nde bá ɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nɛ xø bi mbɛhn mi'da, bi 'yɛ̨mbi: “Dami xihmbʉ ma amigo ba ɛ̨hɛ, nguetho ya dá hoc ran ts'ihmɛ. Dá manda bi tho 'da man dąni xʉn zaqui nɛ ya gätho mahoqui, i ɛ̨n'a ra hmu, gui 'yɛ̨mfʉ.” Nɛ gue'a bi man ʉ yʉ́m 'bɛhni. ");
INSERT INTO otmNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pɛ him bi 'yʉrpatho ra güɛnda ʉ yʉ́ amigo, nɛ bi mba da huąhi a n'da, nu man'da bi mba bám pätho, ");
INSERT INTO otmNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","nɛ nu'ʉ mi'da bi bɛnt thoho yʉ́m 'bɛhni nɛ i thenthoho nɛ bi hyo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nu'bʉ mí 'yø a bin ja, ɛ̨mmɛ bin cuɛ ra ts'ʉt'abi bʉya, bi mbɛnh yʉ́ dofʉi bá ho ʉ yʉ hyote nɛ bi 'yump'a yʉ́ hnini. ");
INSERT INTO otmNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nɛ bi xih mahøn'a ʉ yʉ́m 'bɛhni: “Nuya him bá ɛ̨'ʉ ma amigo nguetho hing yʉ́n sähʉ ba ɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ní mbähä bʉ ja yʉ 'yu nɛ gbá sihʉ ua hønt'a go má ją'i gba tįmhbʉ bʉ, nguetho ya ma hoqui 'bɛ'a da zi ua ja ran thąti.” ");
INSERT INTO otmNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nu yʉ́m 'bɛhni bʉya bi mba bʉ ja yʉ 'yu nɛ bá pɛn bʉ ja ran thąti to'o gätho bin c'athʉ bʉ, pɛ hinga mfądi 'bʉ yʉ ts'om'bäi o gue yʉ hocją'i 'da. Nɛ bi yupʉ ja rá ngu ra ts'ʉt'abi yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nɛ nu ra ts'ʉt'abi bʉya bi yʉrpʉ mbo da nu ʉ yʉ ją'i bi zøm bʉ. Nɛ bi nu n'da ran 'yohʉ ngue him mi he ʉ yʉ́ he i the 'bʉ in ja n'da ran thąti. ");
INSERT INTO otmNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nɛ bi 'yɛ̨n'a ra ts'ʉt'abi bʉya: “Xi'i grán 'yohʉ, hanja gá cʉt'ua nɛ hin guí he yʉ́n säui da the ua ja ran thąti,” bi 'yɛ̨mbi. Pɛ nu ran 'yohʉ him bi zä bi dąti. ");
INSERT INTO otmNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nɛ bi 'yɛ̨mp'ʉ yʉ́ 'yɛ̨hɛ ra ts'ʉt'abi: “Dami turpahʉ yʉ́ gua na ran 'yohʉ nɛ yʉ́ 'yɛ, nɛ gui 'yɛnthʉ bʉ ja ra 'bɛxui. Din zom bʉ nɛ din guxpʉ yʉ́ ts'i ʉ,” bi 'yɛ̨n'a ra ts'ʉt'abi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nguetho xʉn ngu i ts'ohni pɛ hinga gä yʉ́n sähʉ ngue da yʉrpʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nɛ nubʉya bi mba ʉ yʉ fariseo. N'danni bá nyąsɛ ʉ, bi hyoni 'bɛ'a dí ʉcpa ra Jesús ngue di yąpi. ");
INSERT INTO otmNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Janangue bi 'bɛhn pʉ 'bʉh ra Jesús ʉ mi'da yʉ́ mifariseohʉ, nɛ mi'da ma ngʉrpihe mi tɛn'na ra ts'ʉt'abi Herodes. Nu'bʉ mi zøm bʉ, bi 'yɛ̨n'ʉ: ―Grá xänbate, dí pąhmbe gätho majuąni guím ma, bi 'yɛ̨mp'a ra Jesús ʉ. Nɛ guí u a majuąni rá 'yu Oją, nɛ hin guí su 'bʉ da hnumanho i ogue hin'na, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pɛ dín ndehe gui xije ts'ʉ 'bɛ'a guím bɛ̨ni. Ha din thɛui yʉ́n t'ɛ̨di Oją ngue dí juthe ra renta a ra ts'ʉt'abi Roma in ts'ʉt'abi ua, uague hin'na. ");
INSERT INTO otmNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pɛ nu ra Jesús bi bądi 'bɛ'a mim bɛ̨n'ʉ ngue in nde da dįni 'bɛ'a dí yąpi. Janangue'a bi 'yɛ̨mbi: ―Ɛ̨mmɛ guidí yorpahʉ a guím bɛ̨mhbʉ. Høntho guí nde gui sägdahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xi ni mbɛti gní jut ni rentahʉ, ga nugä, bi 'yɛ̨n'a ra Jesús. Bi un'na ra mbɛti bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nɛ nu'bʉ mi nu a ra mbɛti, bi 'yɛ̨n'a ra Jesús: ―To'o rá hmi na i cuat na ra mbɛti, nɛ to'o rá thuhu mán t'o't'i ua, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","―Rá hmi ra ts'ʉt'abi Roma nɛ rá thuhu a, bi 'yɛ̨n'ʉ. Nu ra Jesús bʉya bi 'yɛ̨mp'ʉ: ―Nu'a rá mbɛti ra ts'ʉt'abi gui unhdʉ a. Nu'a xin rá mbɛti Oją, gui unhdʉ Oją a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nɛ nu'bʉ mí 'yø a bi man ra Jesús, bi hyonya thoho ʉ ngue mi nde xtí yąpi. Nɛ xø bi mbatho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nɛ m'bɛjua bʉya xø bi zøm bʉ 'da ma ngʉrpihe ngue yʉ saduceo. Nu'ʉ him mi ɛ̨c'yɛi ngue da dąmbɛ̨ni ʉ xøn du, nguetho mi ɛ̨n'ʉ, nu rá mbʉi n'da, ma zä dim 'bɛ 'bʉ bi du. Nɛ nu'ʉ bi 'yän'na ra Jesús, bi 'yɛ̨mbi: ");
INSERT INTO otmNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Xänbate i, dím bɛ̨nthohe ran t'ɛ̨di bi man ra Moisés, ngue nu'bʉ da du n'da ran 'yohʉ, 'bʉ 'bʉh rá xisu, nɛ hin ním 'bʉ a n'da rá t'ʉhni 'bʉ mi du, nu'a rán 'yohʉ din thątui a rá xisu a ra du, nɛ nu'bʉ dim 'bʉh rá mbʉdi t'ʉhni, da t'ɛ̨mbi rá t'ʉhni a xí du. ");
INSERT INTO otmNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pɛ mí 'bʉcua yoto yʉn 'yohʉ midín 'yohʉzɛhɛ ʉ. Nu'a ra mbʉdi n'yohʉ bin thątui n'da ra xisu, pɛgue bi du n'dihi a ran 'yohʉ. Nɛ hin ním 'bʉh yʉ́ t'ʉhni 'bʉ mi du, janangue'a bi zinba rá xisu a rán 'yohʉzɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pɛ nɛ'a guexta'a bi du n'dihi, nɛ hin ní dįntho rá t'ʉhni a ra xisu 'bʉ mi du. Janangue'a xø bim 'bʉhmi a man'da rá mbegue. Nɛ bin ja gue'bʉ go mi dät'i bim 'bʉhmi gätho ʉ yʉ́ mbegue a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","M'bɛjua bʉya nɛsɛ ra xisu bi du, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nuya, dami xije 'bɛ'a din ja 'bʉ majuąni da dąmbɛ̨ni ʉ xøn du, ngue guí mamhbʉ. Nda'a nín 'yohʉ da 'yɛ̨mbi rá xisu a ra xisu, nguetho gätho yoto bim 'bʉhmi, bi 'yɛ̨mp'a ra Jesús 'bʉ mi denthoho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Bi dąt'a ra Jesús: ―Nu ahʉ guídí 'bɛthohʉ, nguetho hin guím bɛ̨mhbʉ 'bɛ'a mam bʉ ja rá t'ohni Oją, nɛ xín guí pąhmbʉ rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nu'bʉ bi dąmbɛ̨ni ʉ xøn du, ya him man ja ran thąti, pɛgue dim 'bʉtho tengu yʉ́m 'bɛhni Oją mahɛ̨ts'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Nɛ nangue'a ram hma ngue da dąmbɛ̨ni ʉ xøn du. Ha hin gá nuhʉ bʉ ja rá t'ohni Oją 'bɛ'a bi ma nangue ʉ ma ndu mbombøtahʉ 'bʉ mi 'yɛ̨na: “Nugä drá Ojągä, nu ra Abraham nɛ ra Isaac nɛ ra Jacob, i ɛ̨c'yɛigui,” bi 'yɛ̨n Oją. Ngubʉ im ma nguetho guexta'a i 'bʉh yʉ́ mbʉi ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nɛ nu'ʉ yʉ ją'i 'bʉ mí 'yø a bi man ra Jesús, bi hyonya thoho a bi xifi 'bʉ mi xänbi. ");
INSERT INTO otmNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nɛ nu mi'da ma ngʉrpihe ngue yʉ fariseo, 'bʉ mi nu hin'yʉ man'da sä da man'ʉ yʉ saduceo, bin 'yänzɛhɛ 'bɛ'a mí sä ngue dí yąp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nu'a n'da ra xänbate nangue ʉ yʉ fariseo bʉya, bi 'yän'na ra Jesús: ");
INSERT INTO otmNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Xänbate i, bi 'yɛ̨na, nda'a rán t'ɛ̨di Oją hnɛhi thoho ga øt'ähe. ");
INSERT INTO otmNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Bi dą a ra Jesús bʉya: ―Nu'a ran t'ɛ̨di i ɛ̨na: “Gam bɛ̨mhbʉ Oją ngue gätho ma mbʉihʉ, nɛ gätho ma ją'ihʉ, nɛ gätho man 'yomfɛ̨nihʉ.” ");
INSERT INTO otmNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Guehna ran t'ɛ̨di i 'bɛt'o na, nangue ʉ gä mi'da yʉn t'ɛ̨di. ");
INSERT INTO otmNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nɛ'a ɛ̨na: “Dami huɛ̨c ni miją'ihʉ tengu bʉ gní huɛ̨czɛhɛ ni ją'ihʉ.” Guehna ná yoho ran t'ɛ̨di guexta'a mahyoni na. ");
INSERT INTO otmNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nɛ nu'bʉ gá 'yøthʉ ya yoho yʉn t'ɛ̨di, tengu'bʉ gá jąshʉ gätho yʉ́n t'ɛ̨di ra Moisés nɛ yʉ́m hman yʉ́ pøngahyą Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nɛ guexta'a mi 'bäpʉ yʉ fariseo, ");
INSERT INTO otmNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","nɛ bi t'ɛ̨mp'ʉ bʉya: ―'Bɛ'a guím bɛ̨mhbʉ, to'o rá 'yʉ a ra Cristo, rá Thahni Oją, bi 'yɛ̨mp'ʉ, bi 'yɛ̨n'a ra Jesús. Bi dą ʉ yʉ fariseo bʉya: ―Nu rá Thahni Oją, rám bom'bɛto ra David a, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Pɛ nɛ guesɛ ra David bi 'yɛ̨mbi rá hmu a ra Cristo 'bʉ hin ním 'bʉi, nguetho bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nu Oją bi 'yɛ̨mp'a ma Hmu: “Hyucua ja man 'yɛi ga conhui ma ts'ɛdi gue'bʉ go dá tąpä gätho ʉ man sʉihʉ ngue gui manda ʉ bʉya,” bi t'ɛ̨mp'a ma Hmu, bi 'yɛ̨n'a ra David, 'bʉ mi bɛ̨nba rá Hogandąhi Oją 'bɛ'a bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hanja i ɛ̨mbi rá hmu nɛ xin rám bom'bɛto a rá Thahni Oją, ngue ra Cristo, bi 'yɛ̨n'a ra Jesús, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nɛ hin'yʉ 'bɛ'a bi zä dí dąti, janangue'a him man'dandį bi zä da 'yän'ndʉ yʉ fariseo bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nɛ nu ra Jesús bi xi ʉ yʉ ją'i, nɛcähe bʉya: ");
INSERT INTO otmNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―I ja yʉ́n t'ɛ̨di da xän'nahʉ ʉ yʉ́n t'ɛ̨di ra Moisés ʉ yʉ xänbate niją nɛ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dami 'yøhmbʉ 'bʉ i xän'nahʉ ʉ, pɛ hin gui 'yøthʉ tengu yʉ́n t'øt'e i sänzɛhɛ, nguetho 'dan'yo thoho gä mi'da i øt'e. ");
INSERT INTO otmNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nɛ xʉn hɛ̨i i xi ahʉ gui 'yøthʉ, tengu'bʉ n'da ra 'bɛni xʉn hyʉ i xi ahʉ gui tuxhʉ, pɛ nusɛ'ʉ xíngui ts'ʉ in nde da 'yøt'a i sän zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nɛ hønt'a i honi da hnumanho yʉ́n t'øt'e i ørpʉ 'bʉh yʉ ją'i. Janangue'a di cuat yʉ́ dɛ̨ yʉ́n t'ɛ̨di Oją ngue xʉn ndoho nɛ i pät' yʉ́ 'yɛ, nɛ ɛ̨mmɛ di ho di hoc yʉ́n zʉdi yʉ́ nyąmpahni. ");
INSERT INTO otmNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nɛ ɛ̨mmɛ di ho rá mbʉdi din sihmɛ bʉ i t'øt' yʉn ts'ihmɛ; nɛ di ho da mipʉ ja ran thuts'i mahoqui bʉ ja ra niją. ");
INSERT INTO otmNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nɛ ɛ̨mmɛ di ho da t'ɛ̨spa 'bʉ din zɛnguate. Nɛ i honi da t'ɛ̨mbi yʉ́ xänbate ʉ. Høntho in nde da hnumansu. ");
INSERT INTO otmNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pɛ nu ahʉ o guí ndehʉ da t'ɛ̨n ahʉ gyʉ xänbatehʉ, nguetho høngdä ni Xänbatejʉ ngue drá Thahnigä, nɛ nu'ahʉ guidín cuhʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nɛ hin gui 'yɛ̨mfʉ ni tahʉ 'da ʉ i 'bʉcua ja ra häi, nguetho nu'a ni Tahʉ bí 'bʉpʉ mahɛ̨ts'i a. ");
INSERT INTO otmNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɛ xín gui ndehʉ ngue da t'ɛ̨n ahʉ gyʉ hmuhʉ, nguetho guecä drá Thahni Oją ngue ra Cristo, ni Hmujʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nu'a to'o din 'yɛ̨hɛ thoho nangue yʉ́ miją'ihʉ, pɛ gue'a man'da xtán hɛ̨ts'i bʉ dá nu Oją a. ");
INSERT INTO otmNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nguetho nu'a i øt'e ngue xʉn hɛ̨ts'i, man'da zi cuɛ bʉ dá nu Oją a, pɛ nu'a i øt'e ngue hingui hɛ̨ts'i, pɛ man'da xtán hɛ̨ts'i bʉ dá nu Oją a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nɛ nubʉya bi 'yɛ̨mp'ʉ yʉ xänbate niją nɛ yʉ fariseo: ―Huɛ̨hi maha ahʉ, gyʉ xänbatehʉ bʉ ja ra niją, nɛ gyʉ fariseohʉ, ɛ̨mmɛ guidí yorpahʉ a guím bɛ̨mhbʉ, nguetho gá xihmbʉ ʉ mín nde xtán yʉrpʉ di manda rá ts'ɛdi Oją, ngue xquí 'yuthʉ ra 'yu, pɛ nɛ tengu'bʉ gá corpa zɛhɛhʉ ra goxthi, nguetho 'dan'yo thoho gá xänbahʉ. Nɛsɛ ahʉ hin da zä gui cʉthʉ bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Huɛ̨hi maha ahʉ, gyʉ xänbatehʉ nɛ gyʉ fariseohʉ, ɛ̨mmɛ guidí yorpahʉ a guí øthʉ. Sä nya'a guí yąhʉ Oją bʉ ja yʉ́ ngun yʉ xisu xøn du yʉ́ ndø, ngue guí ɛ̨mhbʉ guí äfʉ rám fäts'i Oją ʉ, pɛ nɛ guí hąspahʉ 'bɛ'a bi zopa yʉ́ ndø. Janangue'a man'da xʉn ʉtho ran ʉnbi gui nuhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Huɛ̨hi maha ahʉ, gyʉ xänbatehʉ nɛ gyʉ fariseohʉ, ɛ̨mmɛ guidí yorpahʉ a guí øthʉ. Säti thoho gán 'yohʉ hønbʉ go hapʉ nɛ yatho gá mbähä, ngue gá sømhbʉ bʉ 'bʉ ʉ i thąnde yʉ́ oją zɛhɛ, ngue gá xihmbʉ da dɛn'na nin xädihʉ. Pɛ nu'a to'o bi dɛn'nahʉ man'da gá jafʉ bim 'bɛdi, nɛ 'da gdí mbähä bʉ ja ran ʉnbi maząi, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Huɛ̨hi maha ahʉ, gyʉ ngʉrpihʉ, pɛgue tengu'bʉ gyʉ xädähʉ nɛ guí xihmbʉ ʉ guí xänbahʉ: “Nu'bʉ ja 'bɛ'a bi ma n'da ra ją'i, nɛ bi ndønba rá thuhu ra niją, hingui jatho di ją'ts'a,” guí ɛ̨mfʉ. “Pɛ nu'bʉ bi ndønba a rá oro i ja bʉ ja ra niją, i jatho di ją'ts'a bi ma,” guí ɛ̨mhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gyʉ 'yąmbʉihʉ nɛ gyʉ xädähʉ. Guí ɛ̨mhbʉ man'da di muui ra oro xinda gue ra niją, pɛgue hin'na maha nguetho gue'a ra niją ní t'ɛ̨mbi xʉn ho a ra oro i ja bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nɛ guí ɛ̨mhbʉ: “Nu'bʉ ja 'bɛ'a bi man a n'da ra ją'i, nɛ bi ndønba rá thuhu ran ts'äya bʉ ja ra niją, guí ɛ̨mhbʉ hingui jatho di ją'ts'i. Pɛ nu'bʉ bi ndønba rá thuhu ran t'unni i høxpʉ ja ran ts'äya, ya ra ts'oqui a bʉya 'bʉ him bi ją'ts'i,” guí ɛ̨mhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gyʉ 'yąmbʉihʉ, tengu'bʉ gyʉ xädähʉ. Guí ɛ̨mhbʉ man'da di muui ʉ yʉ 'bøts'e i ja bʉ xinda gue ran ts'äya. Pɛgue hin'na maha, gue'a ran ts'äya ní t'ɛ̨mbi xʉn ho ʉ yʉ 'bøts'e bí ja bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nguetho nu'a bi ndønba rá thuhu ran ts'äya bʉ ja ra niją, hinga hønt'a ran ts'äya, pɛ gätho í ndønba rá thuhu 'bɛ'a gätho høxpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nɛ nu'a to'o bi ndønba rá thuhu ra niją, hinga hønt'a ra niją bi ndønba rá thuhu, pɛ nɛ a rá thuhu Oją bi ndønbi, nguetho rá ngu Oją a ra niją. ");
INSERT INTO otmNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nɛ'bʉ n'da bi ndønba rá thuhu mahɛ̨ts'i, pɛ hinga høn bʉ mahɛ̨ts'i bi ndøni, pɛ nɛ a rá thuhu Oją bi ndønbi, nguetho bí 'bʉpʉ Oją bʉ mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Huɛ̨hi maha ahʉ gyʉ xänbatehʉ nɛ gyʉ fariseohʉ, ɛ̨mmɛ guidí yorpahʉ a guí øthʉ. Hin njąm'bʉ gá pumbɛ̨nihʉ gá hyąxhʉ bʉ ja ra niją a ná 'dɛt'a yʉ́ 'yɛ̨thi yʉ tʉhʉ bi bøxpʉ ja ni huąhihʉ, tengu bi man ra Moisés, pɛ gá pumbɛ̨nihʉ ʉ yʉn t'ɛ̨di man'da mahyoni, ngue i ɛ̨na: “'Da gdí numanhohʉ ni miją'ihʉ, nɛ din ja nin huɛ̨catehʉ, nɛ gui 'yɛ̨c'yɛihʉ Oją.” Guehya nde'bʉ man'da gan ɛ̨hya gui 'yøthʉ, madague'bʉ gui thoqui gui 'yøthʉ ʉ mi'da. ");
INSERT INTO otmNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pɛ gá 'yøthʉ tengu'bʉ gám fähmbʉ ngue xínga n'da ra 'uɛ̨ i sä di uąshʉ 'bʉ ja a guí sihʉ, pɛ nu'a go ra fani nɛ man'da go hin gá nuhʉ 'bʉ gmí tuthʉ a, nguetho hin guí pąhmbʉ nda'a nín t'ɛ̨di man'da xʉn ndoho. ");
INSERT INTO otmNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Huɛ̨hi maha ahʉ gyʉ xänbatehʉ nɛ gyʉ fariseohʉ, ɛ̨mmɛ guidí yorpahʉ a guím bɛ̨mhbʉ. Gá 'yɛ̨mhbʉ xʉn hotho ahʉ, pɛ gá 'yøthʉ tengu'bʉ n'da ra baso bi mba m'berpe bʉ maxøts'e, pɛ hinga nɛpʉ mbo. Nɛ tengu'bʉ n'da ra mbohi høn bʉ ní ndi a häi bi 'berpe, nɛ guín jahʉ bʉ nguetho ɛ̨mmɛ i yuh ni mbʉihʉ nangue ram fɛ̨ nɛ ran ts'iyate. ");
INSERT INTO otmNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gyʉ xädähʉ, nde'bʉ gui 'yøthʉ tengu'bʉ nɛpʉ mbo bin sʉt'i n'da ra mbohi, nɛ majuąni xtán ho ahʉ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Huɛ̨hi maha ahʉ gyʉ xänbatehʉ nɛ gyʉ fariseohʉ, ɛ̨mmɛ guidí yorpahʉ a guím bɛ̨mhbʉ. Nɛ guín jahʉ tengu'bʉ ra jądo bʉ ja ran 'yägui ngue xʉn t'axi maxøts'e, nɛ mahotho, pɛ nubʉ mbo, yupʉ yʉ do'yodu nɛ gä mi'da xʉn xątho. ");
INSERT INTO otmNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Guín jahʉ bʉ. Nubʉ na nu ahʉ yʉ ją'i, ɛ̨na xʉn ho ahʉ. Ɛ̨mmɛ guidí yorpahʉ a guím bɛ̨mhbʉ nɛ ɛ̨mmɛ yuh ran ts'o ni mbʉihʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Pɛ í huɛ̨hi maha ahʉ gyʉ xänbatehʉ nɛ gyʉ fariseohʉ. Guidí yorpahʉ a guí øthʉ. Gá hocpahʉ yʉ́ jądon'yägui ʉ yʉ́ pøngahyą Oją maya'bʉ bi hyo nim bombøtahʉ, nɛ'ʉ yʉ́ jądon'yägui ʉ guí ɛ̨mfʉ yʉ hocją'i gá hocpahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nɛ sä guí ɛ̨mhbʉ: “Nu'bʉ di 'bʉhmbʉ ʉ 'bʉ mi hyo yʉ́ pøngahyą Oją ʉ mam bombøtahʉ, nɛ xcá uthʉ ngue hingui ho a bi 'yøt'e, nɛ xcá 'uethohʉ,” guidín 'yɛ̨mfʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Janangue'a gadín juąnzɛhɛhʉ ya ngue yʉ́ 'yʉ ahʉ yʉ hyote. ");
INSERT INTO otmNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dami juahmbʉ a ra 'bɛfi bi 'yut'ahʉ nim bombøtahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tengu'bʉ gyʉ pozʉhʉ. Hin da zä gui 'dahmbʉ bʉ ja ra sibi njąm'bʉ i huɛ̨t'i. ");
INSERT INTO otmNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nguetho, nu'bʉ ba pɛn'nahʉ ma pøngahyą nɛ ma xänbate, hin gui simanhohʉ ʉ, gui hyohʉ ʉ 'da, nɛ gui cuathʉ bʉ ja ra za ʉ 'da, nɛ gui fɛhmbʉ ʉ 'da bʉ ja ni nijąhʉ. Nɛ ɛ̨mmɛ gui ʉcpadahʉ ʉ 'da 'bʉ i 'yo bʉ ja ni hninihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nɛ nangue a gui 'yøthʉ, tengu'bʉ gá hyosɛhʉ ʉ gä yʉn hocją'i bi tho gue'bʉ go rá mbʉdi ra ximhäi, 'bʉ mí tho ra Abel ngue man ra hocją'i nɛ asta gue'bʉ mi tho a ra Zacarías, rá ts'ʉnt'ʉ ra Berequías, gá hyohʉ bʉ ja rá goxthi ra niją. ");
INSERT INTO otmNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Majuąni dí xi ahʉ, tengu'bʉ ni ts'oqui zɛhɛhʉ ʉ gä yʉn thote i jatho ya, nɛ da ts'än'nahʉ ran ʉnbi nangue ʉ, bi 'yɛ̨n'a ra Jesús, bi t'ɛ̨mp'ʉ yʉ xänbate niją nɛ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nɛ nubʉya bi xi a n'da ram hma ʉ yʉ mɛngu bʉ Jerusalén, bi 'yɛ̨mbi: ―Ɛ̨mmɛ dím bɛ̨n ahʉ gyʉ mɛnguhʉ Jerusalén. Nząi guí hohʉ yʉ pøngahyą, nɛ guidí bat'adohʉ ʉ mi'da ba pɛn'nahʉ Oją. Nɛ xʉn ngu yʉ nidi dím bɛ̨ngä xcá pɛt'ahʉ xcá jamansu ahʉ, tengu'bʉ n'da ra sumfø di pɛt yʉ́ t'ʉhni nɛ i comp' rá hua, pɛ nu'ahʉ, hin gá ndehʉ xcá ja ahʉ bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dami nuhʉ ya, nu ni hninihʉ tengu'bʉ ya njongui 'bʉpʉ ya, ");
INSERT INTO otmNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","nguetho hin gui nujʉ mahøn'a jaque'bʉ bi zøn ra ora ba pengä ua nɛ gui 'yɛ̨scahʉ. “Mająpi a ba ɛ̨hɛ nangue rá thuhu ma Hmuhʉ Oją,” gui 'yɛ̨njʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nɛ nubʉya, nu ra Jesús 'bʉ mi bøm bʉ ja ra dąniją, dá utähe 'bɛ'a gä mí ja bʉ ja ra ngu. ―Mahotho ua, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pɛ nu ra Jesús bi 'yɛ̨nje: ―Guí nuhʉ ngue mahotho i ja ua, pɛ gätho da mba nso't'i, nɛ xínga n'da ra do din tøcua ngue hin da mba ma juadi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nɛ dá nɛxähe dá mbähmbe bʉ ja ra nyuni Olivos. Nɛ ní mipʉ ra Jesús dá ändähe 'bʉ njom mí øde, yʉ́ xädigähe: ―Dín ndehe gui xije nda'a ní pa din ja a gám mam bʉ ja ra niją. 'Bɛ'a ní hmɛpya din ja 'bʉ guá pengui mahøn'a nɛ'bʉ ran zɛgui ra pa, dá ɛ̨mfe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nɛ bi 'yɛ̨ngähe ra Jesús: ―Damim fähmbʉ 'dahma njon da hyä ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nguetho xʉn ngu yʉ hyäte ba ɛ̨hɛ da 'yɛ̨na: “Nugä, guecä, rá thahnigä Oją, drá Cristogä,” da 'yɛ̨n ahʉ. Nɛ xʉn ngu da hyät'ʉ nangue ra fɛhni da man ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɛ nu'bʉ gui 'yøhmbʉ ngue din ja yʉ sʉi, o gue'bʉ gui 'yøhmbʉ i ja bʉ ja 'da yʉ hnini ya, pɛ o guín suhʉ, nguetho jatho din ja ʉ. Nɛ nu'bʉ bin ja ʉ, xínga gue'bʉ rán zɛgui'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nguetho da ndants'ʉ 'da yʉ ts'ʉt'abi din sʉhmbʉ ʉ yʉ́ mi ts'ʉt'abihʉ, nɛ da ndanc'ʉ 'da yʉ hnini din sʉhmbʉ mi'da yʉ hnini. Nɛ xʉn ngu yʉ nidį din ja ra thuhu, nɛ ra dągɛ̨hɛ̨, nɛ din ja yʉ 'yąmhäi bʉ ja yʉ xɛqui ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pɛ nu'ʉ, yʉ́ mbʉdi thoho yʉn ʉnbi din ja ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nɛ da mba ma dä ahʉ nɛ da ts'ix ahʉ ngue din ʉn'nahʉ, nɛ da tho ahʉ 'da ahʉ. Nɛ gätho yʉ ją'i da zan ahʉ nguetho guí tɛngahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nɛ nu'ʉ 'da mí ɛ̨c'yɛigui, m'bɛjua da 'uesɛ. Nɛ guesɛ ʉ di dä ʉ ma 'yɛ̨c'yɛi da mba ma ʉnbi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nɛ dim 'bʉi xʉn ngu yʉ hyäte pøngahyą nɛ xʉn ngu yʉ ją'i da hyät'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nɛ nangue a ran ts'o xtá ngu, him ma din ja yʉ́n huɛ̨cate ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pɛ nu'a da hyät'i gue'bʉ go ran zɛgui, da dąha dim pø a. ");
INSERT INTO otmNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nɛ gätho na ndoho ra ximhäi da hma 'bɛ'a da zä dí yʉrpʉ di manda rá ts'ɛdi Oją n'da. Nɛ gätho yʉ ją'i 'dahma 'dan'yo bʉ na yą da sifi, nɛ nubʉya, gue'a ra pa ran zɛgui a bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Nu ra pøngahyą Daniel maya'bʉ bi ma ngue din ja n'da ran ts'o di ts'oni gätho. Janangue'a nu'bʉ gá nuhʉ da mbʉdi din ja bʉ ja ra dąniją a, dami 'dahmbʉ bʉ ra xɛqui Judea, ní mbähä bʉ ja yʉ dąpo. Nguetho nts'utho ran ʉnbi din jabʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","'Bex gui mbähä. Nu'bʉ gdi tøhmbʉ bʉ maxøts'e ra tøcangu, hin gui cʉthʉ mbo ra ngu ngue gui hyąxhʉ 'bɛ'a di ja bʉ. Dami 'dathohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nɛ nu'bʉ gdi 'bähmbʉ bʉ ja ni huąhihʉ, hin 'bɛ gui mbähä bʉ ni ngumhbʉ ngue gba cą ni xi'yohʉ. Dami 'dathohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Huɛ̨cate ʉ yʉ xisu in hąt'ʉhni ʉ yʉ pa ʉ, nɛ'ʉ i 'bʉh yʉ́ 'uɛre, nguetho xʉn hɛ̨i thoho da 'da ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","'Yäfʉ rá mate Oją hinga gue'ʉ yʉ pa xtan sɛ din ja ahʉ ran 'dagui, nɛ xínga gue'bʉ ra pa ran ts'äya, nguetho i man ʉ yʉn t'ɛ̨di hinga yatho gan 'yohʉ a ra pa ran ts'äya. ");
INSERT INTO otmNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dami 'yäfʉ rá mate Oją, nguetho nu'a ran ʉnbi din ja, hin jąm'bʉ n'dandį xøn ja gue'bʉ go rá mbʉdi ra ximhäi. Nɛ nu'bʉ ya bin ja, hin man'dandį din ja a ran ʉnbi tengu a. ");
INSERT INTO otmNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nɛ nu Oją da zänba thoho ʉ yʉn ʉnbi din ja nangue a di huɛ̨c'ʉ xí huahni. Nu'bʉ hin'na, njon da bongui. ");
INSERT INTO otmNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nu'ʉ yʉ pa ʉ, “Dami nuhʉ ua, i 'bäcua ra Cristo,” da 'yɛ̨n ahʉ. Nɛ nu'ʉ mi'da da 'yɛ̨n ahʉ: “Dami nuhʉ i 'bähnʉ ra Cristo.” Pɛ o guí ɛ̨c'yɛihʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nguetho xʉn ngu yʉ hyäte dim 'bʉi, sä da 'yɛ̨n'ʉ: “Guecä, rá thahni Oją, drá Cristogä,” sä da 'yɛ̨n'ʉ. Nɛ xʉn ngu da 'yɛ̨na ngue dim pøngahyą nangue Oją, nɛ da 'yøt' yʉ hyonya nt'øt'e nɛ yʉ hmɛpya ngue da nde da hyät yʉ ją'i. Nɛ da hyoni 'bɛ'a da zä dí hyät'ʉ xí huahn Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nuya gätho dá xi ahʉ guepʉ da zä gui pąhmbʉ 'bɛ'a din ja. ");
INSERT INTO otmNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Janangue nu'bʉ da 'yɛ̨n ahʉ: “Ní mbähä, bí 'bäpʉ ma'ueni a ra Cristo,” da 'yɛ̨n'ahʉ, pɛ o guí pähä. O gue da 'yɛ̨n'ahʉ: “Bá cʉthʉ ua, i 'bäcua ra Cristo,” da 'yɛ̨n'ahʉ, pɛ o guí cʉthʉ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nguetho nu'bʉ bá pengä ua mahøn'a, nugä ngue dán ją'igä ua ja ra ximhäi, dan jagä tengu rán nɛqui ra huɛi ngue dam 'bathogä gätho ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nɛ tengu i øt' yʉ pada, ɛ̨mmɛ di pɛti bʉ 'bɛn ʉ xʉn du, din jabʉ a ran ts'ɛmbi din ja bʉ 'bʉ ʉ yʉ ts'om'bäi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nɛ xø bi thoqui bi man ra Jesús nɛ bi 'yɛ̨na: ―Nu'bʉ bin ja a ran ʉnbi bʉya, him man di nɛc ra hyadi nɛ ra ząna, nu'ʉ yʉ sø 'bʉpʉ mahɛ̨ts'i da dägui. Gätho bí ja bʉ mahɛ̨ts'i gä di 'bɛh yʉ́ ts'ɛdi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nɛ nubʉya di nɛqui bʉ mahɛ̨ts'i ra hmɛpya nanguecä ngue dán ją'igä ua ja ra ximhäi, nɛ gätho yʉ hnini ua ja ra ximhäi din su. Nɛ da nugui ba ɛ̨cä bʉ ja yʉ güi, dan 'yo'be ma ts'ɛdi tąte thoho, mixte thoho, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nɛ nts'ɛdi din yą ra thʉxi. Nɛ ba pɛnhdä yʉ́m 'bɛhni Oją di pɛti gätho ʉ bi huahn Oją, gä na ndoho ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Guim bɛ̨mhbʉ 'bɛ'a dí øthʉ ua ma häihʉ dyʉ israelhʉ, ngue nu'bʉ dí nuhʉ bi mbʉdi dim pʉh yʉ́ mbʉi 'da yʉ za, ya dí pąhmbʉ mi ts'ʉtho ba ɛ̨pʉ yʉ́ pa ra pa'ye. ");
INSERT INTO otmNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nɛ ngutho 'bʉ guín nuhʉ bin ja gätho ya yʉn ʉnbi dí xi ahʉ, gui pąhmbʉ bʉya ngue mbɛ rán zɛgui. ");
INSERT INTO otmNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nɛ majuąni dí xi ahʉ, di 'bʉtho ua 'da ahʉ 'bʉ bi mbʉdi din ja. ");
INSERT INTO otmNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nu ra ximhäi nɛ mahɛ̨ts'i da zøni da gua ʉ, pɛ nu'a mam hmangä njąm'bʉ da gua a. ");
INSERT INTO otmNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pɛ njongui pądi nda'a ní pa din ja a dím mangä ya, xínga gue'ʉ yʉ́m 'bɛhni Oją mahɛ̨ts'i nɛ xínga guengä rá Ts'ʉnt'ʉgä Oją dí pądi, pɛ hønt'a Oją ma Ta i pą a ra ora din ja. ");
INSERT INTO otmNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nɛ tengu thoho bin ja 'bʉ mí 'bʉh ra Noé, ngutho din ja 'bʉ bá pengä mahøn'a, nugä ngue dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nu yʉ pa ʉ ngue'bʉ mi ts'ʉtho din ja ra dąmbʉnt'i, nu yʉ ją'i mi 'bʉhmbʉ ra Noé hønt'a ran ts'ihmɛ mim bɛ̨ni nɛ hønt'a ran thąti mí honi, gue'bʉ go mí yʉrpʉ ja ra mbosa ra Noé. ");
INSERT INTO otmNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nɛ him bi 'yʉrpa ra güɛnda a bi sifi ngue din ja ra 'ye, jague'bʉ mi mbʉh ra 'ye, nɛ bi yuh ra dehe ua ja ra häi nɛ gätho bi gua ʉ. Nɛ din jabʉ 'bʉ bá pengä mahøn'a, guecä dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nɛ dim 'bʉ i yoho yʉn 'yohʉ bʉ ja a ra huąhi, nu'a n'da da mba nts'its'i nɛ man'da da ts'opʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nɛ'bʉ di cʉm bʉ ja n'da ra ngu yoho yʉ xisu, nu'a n'da da mba nts'its'i nɛ nu man'da da ts'opʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Janangue'a dí xi ahʉ, o guí tonspahʉ ra t'ąha, nguetho hin guí pąhmbʉ 'bɛ'a ní ora ba ɛ̨ a ni hmuhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nu'bʉ n'da ran 'yohʉ xtám bądi nda'a ní xui xtán yʉrpʉ yʉ bɛ̨ bʉ ja rá ngu, xtín äthą, xtán dø'mi, nɛ hin xtá japi xtá nyʉrpʉ ja rá ngu ngue da bɛ̨pi 'bɛ'a i ja bʉ. Pɛ hingui pądi 'bɛ'a ní pa, janangue'a i tø'mi gätho yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Janangue'a dí xi ahʉ, damin sähʉ nguetho ts'ʉrpʉ thoho ga søcä, guecä dán ją'igä ua ja ra ximhäi, ngue ra ora njongui tøcpä ga søcä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","Nɛ xø bi 'yɛ̨na: ―Dami 'yøthʉ tengu'bʉ gyʉ hogambɛfihʉ. Nu'a ra ngʉrpambɛfi 'bʉ xʉn ho i øt'e, nɛ nu'bʉ da mba n'danni rá hmu da zopʉ ja rá ngu, da 'yøt'e tengu'bʉ i 'bʉsɛ bʉ rá hmu. Nɛ nu'bʉ bá penc'a rá hmu, bi nu bi jamansu rá 'bɛfi, nɛ xʉn ngu ran jąpi da nu a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Majuąni dí xi ahʉ, nu'a ra ngʉrpambɛfi, man'da din t'un ra ts'ɛdi, nɛ 'bɛ'a gätho i pɛ'ts'a rá hmu di jamansu a. ");
INSERT INTO otmNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pɛ nu'bʉ ra ts'om'bäi a ra ngʉrpambɛfi, nɛ im bɛ̨ni ngue him 'be ba penc'a rá hmu, ");
INSERT INTO otmNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nɛ di ʉnba yʉ́ 'yɛ̨hɛ nɛ i tɛnthoho yʉ mihni, ");
INSERT INTO otmNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ts'ʉrpʉ thoho ba penc'a rá hmu n'da ra pa ngue hingui pą a ra ngʉrpambɛfi. ");
INSERT INTO otmNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nɛ nubʉya din t'un'na n'da ran ʉnbi xʉn ʉtho, nɛ n'dat'a ran ʉnbi da nuhʉ ʉ di yorpa a im bɛ̨ni. Nɛ din zom bʉya nɛ din guxtpʉ yʉ́ ts'i bʉ ja ran ʉnbi maząi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nɛ xø bi 'yɛ̨na: ―Nu'bʉ bi 'yøt' ran ts'ʉt'abi Oją, din ja tengu bin ja 'bʉ min ja n'da ran thąti. Nu'a to'o gä bin sä, bi thopʉ mbo, pɛ nu'ʉ him bin sä, bi gopʉ thi ʉ. Nu'bʉ min ja ran thąti, 'dɛt'a yʉ hmute bi mba, ɛ̨na xtín hyʉmhbʉ ʉ din thąti. Nɛ bá thɛ yʉ́ bombilla mi tøm'ma ran 'yohʉ din thąti. ");
INSERT INTO otmNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pɛ nu'ʉ cʉt'a yʉ hmute yʉ 'yąmbʉi ʉ, nɛ nu'ʉ mi cʉt'a bin 'yomfɛ̨ni ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɛ nu'ʉ yʉ 'yąmbʉi him bi dux man'da ra sibi ngue xta xirpa yʉ́ bombilla 'bʉ bin the a po bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pɛ nu'ʉ bin 'yomfɛ̨ni, bi dux yʉ́ sibi ngue da xirba rá bombilla 'bʉ bin the a po bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nɛ nu'a ran 'yohʉ him 'be bi zøm bʉ. Nɛ nu yʉ dø'mate bi zʉh ra t'ąha ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nu'bʉ made ra xui bi 'yø a n'da ra nde bi 'yɛ̨na: “Ya ba ɛ̨cua ran 'yohʉ, ndanshʉ, ba thąhmbʉ,” bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gätho bi ndang bʉya nɛ bi hoc yʉ́ sibi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pɛ nu'ʉ yʉ 'yąmbʉi, bi 'yɛ̨mp'ʉ bin 'yomfɛ̨ni: “'Daje ts'ʉ ni sibihʉ nguetho i nde da huɛ̨t ma bombillahe,” bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pɛ bi dą ʉ bi dux yʉ́ sibi: “Hin da zä, nguetho nu'bʉ ga 'da ahe go da huɛ̨t' ma sibihʉ 'bʉ. Pɛ xʉn ho 'bʉ gui mbähä gba tämhbʉ.” ");
INSERT INTO otmNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pɛ nu'bʉ mi mba ba tän ra sibi, 'bexgue bi zøm bʉ a ran 'yohʉ din thąti. Nɛ nu'ʉ yʉ hmute bi dux yʉ́ sibi bi yʉrpʉ mbo ngue da nu ra ngo ran thąti, nɛ 'bex bi mba njut'i ra goxthi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nɛ nu'bʉ mi zøm bʉ ʉ xí mba bá tän ra sibi, bi nu ngue njut'i tho ra goxthi, nɛ bi mba ʉ, bi 'yɛ̨n'ʉ: “Gra hmu, grá hmu, dami xoqui,” bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pɛ nu'a ra hmu bi dąt'ʉ: “Hin dí padi to'o ahʉ,” bi 'yɛ̨mbi, nɛ him bi xocpi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nɛ bi 'yɛ̨nje ra Jesús bʉya: ―Gue'a dí xi ahʉ, nde'bʉ gan äthąhʉ nguetho hin guí pąhmbʉ a ra pa ba pengä ua, guecä dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús 'bʉ mí 'yɛ̨ngähe. ");
INSERT INTO otmNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nɛ man'da ran t'uti bi man ra Jesús, nɛ bi 'yɛ̨na: ―Nu'bʉ bi 'yøt' ran ts'ʉt'abi Oją, da 'yøt'e tengu bi 'yøt'a n'da ran 'yohʉ 'bʉ mi zon'ndʉ yʉ́ 'yɛ̨hɛ, bi 'yän'na rá mbɛti xí zocpi. Nguetho nu'bʉ mí mba n'danni n'da ra häi, bi zon'ndʉ yʉ́ 'yɛ̨hɛ da zocpa rá mbɛti. ");
INSERT INTO otmNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nu n'da rá 'yɛ̨hɛ bi zocpa cʉt'a mahuąhi ngue di pɛpi; nɛ nu man'da, yo mahuąhi bi zocpa a; nɛ nu man'da bi zocpa n'da mahuąhi. Bi unni hangu xøt'a di pɛpi n'da ngu n'da. Nɛ bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nɛ nu'a bi unni cʉt'a mahuąhi, bi pɛpi nɛ bi dąh mi cʉt'a mahuąhi. ");
INSERT INTO otmNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nɛ'a bi unni yomahuąhi, yomahuąhi xø bi dąpi. ");
INSERT INTO otmNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pɛ nu'a bi un'na n'da mahuąhi, bi mba bá cät'a häi a rá mbɛti xi un'na rá hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nɛ him 'be bá penc rá hmu. Pɛ nu'bʉ mi zøhø bi zon'ndʉ yʉ́ 'yɛ̨hɛ mahøn'a ngue da nu 'bɛ'a xí 'yøt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","M'bɛt'o bi zøn'a xín t'unni cʉt'a mahuąhi, nɛ bi däp'a rá hmu cʉt'a mahuąhi ngue rá mbɛti zɛhɛ rá hmu. Nɛ xø bi un'na xí dąha ngue mi cʉt'a mahuąhi, nɛ bi 'yɛ̨mbi: “Grá hmu, i ja ua ni mbɛti, nɛhna cʉt'a mahuąhi dá tąha,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Xʉn ho,” bi 'yɛ̨n'a rá hmu. “Nu'i grá hogambɛfi,” bi t'ɛ̨m bʉya. “Xʉn ho gá 'yørpa a ts'ʉtho dá 'da i, janangue'a ga 'da i man'da xʉn ngu ya. Bá thocua mbo 'dat'ua dan johyaui,” bi 'yɛ̨n'a rá hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nɛ xø bi zøm bʉ man'da xí unni yo mahuąhi, nɛ bi 'yɛ̨na: “Grá hmu, i ja ua ra mbɛti gá 'daqui, nɛhna mi yomahuąhi dá tąha i ja ua,” bi 'yɛ̨mp'a rá hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nɛ nu'a rá hmu bʉya bi 'yɛ̨mbi: “Xʉn ho, grá hogambɛfi, xʉn ho gá 'yøt'e, madague'bʉ hingui ngu dá 'da i, nuya man'da xʉn ngu ga 'da i. Bá thocua mbo 'dat'ua dan johyaui,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pɛ nu'bʉ mí zøm bʉ a xi hyąn'a n'da mahuąhi, bi 'yɛ̨mp'a rá hmu: “Grá hmu, mí pącä ngue hin'yʉ nin huɛ̨cate nɛ nząi guí honi 'bɛpʉ gdí hyąnba rá mbɛti yʉ ją'i nɛ gui hyąnba yʉ́ huąhi ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Janangue'a dá pɛs' thoho a gá 'daqui, dí su gui sʉqui 'bʉ xcá 'bɛtho, nɛ i ja ua ni mbɛti gá 'dac ya,” bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nɛ nu'a rá hmu bʉya bi 'yɛ̨mbi: “Gra ndødąnhyɛ̨i, hingui ho gá 'yøt'e ngue hin gá pɛp'a ra mbɛti. ");
INSERT INTO otmNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nu'bʉ guí pądi ngue dí numanhogä ga tącä, sä xquí hmi a ra mbɛti nɛ xtán dąh rán zäbi, nɛ hin xtím 'bɛh pʉya,” bi 'yɛ̨n'a rá hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nɛ bi 'yɛ̨mp'ʉ mi'da yʉ́ 'yɛ̨hɛ mí 'bäpʉ: “Hyąnba na ra mbɛti, dami un'na bin t'unni 'dɛt'a mahuąhi. ");
INSERT INTO otmNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nguetho nu'a bim pɛfi xʉn ho, man'da xʉn ngu din t'unni. Pɛ nu'a him bim pɛfi, pɛ da thąnba a zi ts'ʉ mí pɛ'ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nɛ nuna ra ts'om'bäi mbɛfi na, bá høthʉ bʉ ja ra 'bɛxui guepʉ din zom bʉ nɛ din guxtpʉ yʉ́ ts'i,” bi 'yɛ̨n'a ra hmu bʉya, bi 'yɛ̨n'a ra Jesús 'bʉ mi man na ran t'uti. Nɛ njabʉ din ja 'bʉ bi 'yøt'a ran ts'ʉt'abi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nɛ bi 'yɛ̨m mahøn'a ra Jesús: ―Nu'bʉ bá pengä, nugä ngue dán ją'igä ua ja ra ximhäi, dam mixtegä, dan ts'ʉt'abigä; dan 'yohe yʉ́m 'bɛhni Oją nɛ ga hupʉ ja ma mɛxa ngue din ja ma ts'ɛdi xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nɛ dim pɛti gätho yʉ ją'i gä na ndoho ra ximhäi bʉ ga hucä. Nɛ gätho ga huan'dʉ tengu øt'a n'da ra mbändɛ'yo, ngue n'danni ga fä'bʉ yʉ dɛ'yo nɛ n'danni ga fä'bʉ yʉ dɛnzu. ");
INSERT INTO otmNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nɛ nu yʉ dɛ'yo ga fämp'ʉ ja man 'yɛi nɛ nu yʉ dɛnzu ga fämp'ʉ ja ma gąha. ");
INSERT INTO otmNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nɛ ga ɛ̨mp'ʉ dim 'bäpʉ man 'yɛi: “Ba ɛ̨hmbʉ ua, bi jąp'ahʉ Oją. Ga 'da ahʉ ra ts'ɛdi án ts'änni ngue gui hyąmhbʉ gue'bʉ go rá mbʉdi ra ximhäi,” ga ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Nguetho gá 'dajʉ ra hmɛ 'bʉ mán tumanthuhu; nɛ gá 'dajʉ ra dehe 'bʉ mán tuthe; nɛ gá säyagahʉ 'da ahʉ 'bʉ mán 'yo bʉ n'danni ni hninihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nɛ gá 'dajʉ ma he 'bʉ gmí nuhʉ hin'yʉ ma hegä; nɛ gá nuc 'bʉ mán hyɛ̨nni, nɛ gá zɛnguagahʉ 'bʉ mán ofädi,” ga ɛ̨mp'ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nɛ da 'yɛ̨nc'ʉ: “Grá Hmu, 'bɛ'a ní pa dá øt'ahe a guím ma. Hin dím bɛ̨mhbe ngue gán tumanthuhu n'dandį nɛ gamá 'uįn ahe. Nɛ hin dím bɛ̨mhbe ngue gán tuthe nɛ xcá 'da ahe ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nɛ hin dím bɛ̨mhbe 'bʉ xcamá säya ahe, nɛ xcá 'da ahe ni he. ");
INSERT INTO otmNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nɛ hin dím bɛ̨mhbe 'bʉ gamán hyɛ̨nni o gue gamán ofädi ngue xcá nu ahe,” da 'yɛ̨ngui. ");
INSERT INTO otmNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nɛ nugä drá hmuts'ʉt'abigä, ga ɛ̨mbä ʉ bʉya: “Majuąni dí xi ahʉ, nu'a ran ho gá 'yørpahʉ n'da ma cuhʉ, madague'a nte di muui bʉ na hnu, pɛ guecä gá 'yørcä a,” ga ɛ̨mp'ʉ bʉya, bi 'yɛn'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","―Nɛ nubʉya, nugä drá hmuts'ʉt'abigä, ga ɛ̨mp'ʉ 'bäpʉ ja ma gąha: “Dami 'uehmbʉ ua ja ma hmi, ní mbähä bʉ ja ra sibi njąm'bʉ da huɛ̨t'i, nguepʉ dá sänni din zø a ra zįthu nɛ ʉ yʉ́ mizįthuhʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nguetho dán tumanthuhu nɛ hin gá 'uįnjʉ, nɛ dán tuthe, nɛ hin gá sithegahʉ, ");
INSERT INTO otmNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nɛ hin gá säyagahʉ 'bʉ mán 'yo bʉ n'danni, nɛ hin te má he gá 'dajʉ 'bʉ gmín nuhʉ hin'yʉ ma hegä; nɛ hin gá nugui 'bʉ mán hyɛ̨nni, nɛ hin gbán nujʉ 'bʉ mán ofädi,” ga ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nɛ nu'ʉ da 'yɛ̨ngui: “Grá hmu, 'bɛ'a ní pa dá nu ahe ngue gán tumanthuhu o gue gán tuthe o gue gán 'yo bʉ n'danni ra hnini. Nɛ 'bɛ'a ní pa dá nuhe hin mí he ni he; o gue xquín hyɛ̨nni o gue xcamín ofädi,” da 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pɛ nugä drá hmuts'ʉt'abigä, ga ɛ̨mp'ʉ bʉya: “Majuąni dí xi ahʉ, n'da ma cu madague'a nte di muui bʉ na hnu, 'bʉ hin gá 'yørpahʉ ran ho, nɛcä hin gá 'yørcahʉ ran ho,” ga ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nɛ nu ʉ bʉya da nu ran ʉnbi maząi. Pɛ nu'ʉ bi 'yøt' ran ho din ja ra te maząi ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nɛ nu'bʉ mi gua a bi man ra Jesús, bi 'yɛ̨ngähe: ");
INSERT INTO otmNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Nuya man yopa thoho di 'bɛdi ngue din ja ra dąmpɛti a ran dąbaxjua, nɛ nubʉya da mba ma dägä ngue da mba ma cuatigä bʉ ja ra za, guecä dán ją'igä ua ja ra ximhäi, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pɛ nu'ʉ ma ngʉrpihe ngue yʉ hmumbäją, nɛ yʉ xänbate niją, nɛ yʉ dąc'yɛi, bim pɛti bʉ mbo rá mbä't'i rá ngu ra Caifás, nu'a mi hmumbäją a ra jɛya a. ");
INSERT INTO otmNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nɛ bi nyąsɛ ʉ, bi ma nda'a ní fɛhni da xi a ra Jesús ngue da bɛnt'i da hyo. ");
INSERT INTO otmNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nɛ bi ma, 'bɛ da gua a ra dąmpɛti, ja da tho a. Nguetho bi zu din junthʉ yʉ ją'i mi 'yo bʉ ja ram pɛti. ");
INSERT INTO otmNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nɛ nu'bʉ mi mbeng bʉ ra hnini Betania a ra Jesús, bi zøm bʉ ja rá ngu a ra Simón mí hɛ̨mb ra t'axca'ya mam'bɛt'o. ");
INSERT INTO otmNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nɛ bi hyupʉ mi ja a rá mɛxa a, ɛ̨na din sihmɛ. Bi zøm bʉ n'da ra xisu mí tu n'da ra xaro xʉm hmadi, án t'øt'e ra do ra alabastro. Nɛ mi po bʉ ra 'yɛ̨thi yʉman'u, nɛ'a ɛ̨mmɛ di muui a. Nɛ nu'bʉ mi zøm bʉ a ra xisu bʉ i hudi, bi xo'ts'a rá 'yɛ̨thi bi xispa rá yą ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nɛ dán cuɛhe 'bʉ mán nuhe 'bɛ'a bi t'ørpa ra Jesús, nɛ dá ɛ̨mhbe: ―Ndetho bi xispa ra 'yɛ̨thi, ");
INSERT INTO otmNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","xʉn ho 'bʉ xta 'bä, xtá mba ma darpi yʉ hyoya a ra mbɛti, dá ɛ̨mhbe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nɛ bi bą'a ra Jesús 'bɛ'a dá bɛ̨mhbe, nɛ bi 'yɛ̨nje: ―Hanja gní ʉnbahʉ rá mbʉi na ra xisu, nɛ xʉn ho 'bɛ'a bi 'yørque. ");
INSERT INTO otmNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nu yʉ hyoya nząi gam'bʉhmbʉ ua ʉ, nɛ hønt'a go má pa da zä gui fäxhʉ ʉ. Pɛ nugä hin dan ząngä ua, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nuna ra xisu bi hoga ma ngøc'yɛi 'bʉ mi xiscä ra 'yɛ̨thi, ngue da mba nt'äguigä bʉ ja ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nɛ majuąni dí xi ahʉ, hønbʉ go hapʉ da hman a rán ho ma'da'yo Oją, nɛhna da hman na bi 'yørcä na ra xisu, n'dahma hønbʉ go hapʉ da fɛ̨n'a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nɛ nubʉya, nu'a ma mixädihe ra Judas Iscariote, bi mba bi nyąhʉ yʉ hmumbäją ");
INSERT INTO otmNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nɛ bi 'yɛ̨mbi: ―Hangu gui 'dajʉ ngue ga dä ahʉ ra Jesús, bi 'yɛ̨mp'ʉ. Nɛ 'bexgue bi unni 'däte ma 'dɛt'a yʉ mbɛti ngue ra t'axi bʉya. Nɛ xø bi mbeng bʉ 'bʉ a ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pɛ ɛ̨mmɛ mí honi 'bɛ'a ní ora da zä dí dä a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nɛ nu'a rá mbʉdi pa ra dąmpɛti nangue ran dąbaxjua 'bʉ ząi dí sihe a ra hmɛ hinguin 'youi ra íxi, ngue dyʉ judíohe, dyʉ israelhe, dá änhde ra Jesús yʉ́ xädigähe: ―Hapʉ guín nde ga hoje a rán ts'ihmɛ ram baxjua ga sihʉ ya, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nɛ bi xi ʉ yoho ma mixädihe a ra Jesús, nɛ bi 'yɛ̨mp'ʉ: ―Ní mbɛ bʉ ja ra hnini Jerusalén nɛ gui xihmi a ran 'yohʉ, gui 'yɛ̨nui: “Nugä, ya mi ts'ʉtho da zøn ma ora, nɛ dí nde ga si rán sihmɛ ram baxjua bʉ ja ni ngu, nɛ ʉ ma xädigä, i ɛ̨n'a bá pɛngähe,” gui 'yɛ̨nui. ");
INSERT INTO otmNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nɛ bi 'yøt'a bi xi ʉ bʉya, nɛ bi hoc'a rán zibde a ram baxjua ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Nu'bʉ mín de bʉya, dá sømhbe bʉ Jerusalén, 'darpʉ dán sihmɛhe bʉ ja ra mɛxa ra Jesús, nɛ bi 'yɛ̨nje: ―Majuąni dí xi ahʉ, i 'bʉ a n'da ahʉ ngue gui däjʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nɛ ɛ̨mmɛ bi du ma mbʉihe, nɛ n'da ngu n'dagähe dá ɛ̨mfe: ―Grá hmu, ha guengä ga dä i, dá ɛ̨mfe n'da ngu n'daje. ");
INSERT INTO otmNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nɛ bi dą a ra Jesús: ―Gue'a dí com'be ma mbohi ua dí sihmɛhʉ, gue'a di dägä a, bi 'yɛ̨m bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Guecä ngue dán ją'igä ua ja ra ximhäi, da t'ørcä 'bɛ'a gätho i mam bʉ ja rám hma Oją ya, pɛ í huɛ̨hi maha a ran 'yohʉ ngue nu'a di dägä. Man'da xʉn ho 'bʉ hin xtím 'bʉ a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nɛ bi dą'a ra Judas bʉya: ―Xänbate i, ha guecä. ―Hąha, gue'e, bi 'yɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nɛ nubʉya bi hyąc'a ra hmɛ ra Jesús nɛ bi 'yäp rán jąpi Oją, bi xɛm bʉya, bi darcähe a. ―Dami sihʉ na, guehna nim bøni ma ngøc'yɛi na, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nɛ bi dɛc'a ra vaso mi po rán gui ra uva bʉya, bi un ra jamadi Oją mahøn'a, nɛ bi 'daje a ra vaso, bi 'yɛ̨nje: ―Gätho dami sihʉ, ");
INSERT INTO otmNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","guehna nam bøni, ma jigä ngue bi hoc'a ra 'da'yo 'yu bi 'yøt'ahʉ Oją na. Nɛ dim fäni dí punba yʉ́ ts'oqui yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nɛ dí xi ahʉ, him man'dandį ga sigä ra guindät'ä jague'bʉ bi zøn ra pa ga sihʉ ma'da'yo bʉ di manda rá ts'ɛdi ma Ta, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nɛ dán tuhmbe a ra thuhu nɛ dá mbähmbe bʉ ja ra nyuni Olivos bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nɛ bi 'yɛ̨ngähe ra Jesús mahøn'a: ―Dí pądi, nu'bʉ ni xui, gätho gui soga thohohʉ, bi 'yɛ̨ngähe ra Jesús. Nɛ gue'a nt'o't'i bʉ ja rám hman Oją, i ɛ̨na: “Ga ho ra mbändɛ'yo nɛ din 'uɛ̨xt'ʉ yʉ́ dɛ'yo bʉya,” i ɛ̨n Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pɛ nu'bʉ dá thąmbɛ̨nigä, ga mbagä bʉ Galilea ní tįn ahʉ bʉ, bi 'yɛ̨ngähe ngue yʉ́ xädigähe. ");
INSERT INTO otmNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nɛ bi 'yɛ̨n'a ra Pedro: ―Madague'bʉ gätho da 'uegue pɛ nugä, hin'nagä, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bi dą a ra Jesús: ―Majuąni dí xi i, guet'a ra xui i jabʉya ná hyundį xquí cønc 'bʉ bi mbah ra øni. ");
INSERT INTO otmNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nu ra Pedro bi dąti mahøn'a: ―Madague'bʉ 'darpʉ ga tuui, pɛ njąm'bʉ ga cøn'i, bi 'yɛ̨na. Nɛ n'dat'a gätho dá mamhbe ngue hin ga 'uehmbe ʉ ma mixädihe. ");
INSERT INTO otmNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nɛ nu'bʉ má sømhbe bʉ ra nyuni Olivos, dá cʉthe a ra Jesús bʉ ja ra nuąndät'ä mí ɛ̨mbi Getsemaní. ―Dami huhmbʉ ua ya, ga mbagä ua njongua ts'ʉ, da nyą'be Oją ma Ta, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nɛ hyu ʉ ma mixädihe bi zits'i, bi zix'a ra Pedro nɛ'ʉ yoho yʉ́ ts'ʉnt'ʉ ra Zebedeo. Nɛ ɛ̨mmɛ man'da bi du rá mbʉi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nɛ bi 'yɛ̨mp'ʉ ma mixädihe min 'yohʉ: ―Ɛ̨na da føh ma mbʉi a ra dumbʉi, ɛ̨na ga tugä. Dami tøcpahʉ, 'dat'a dan äthąhʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nɛ xø bi dąm mi ts'ʉ ra Jesús bʉ mi huhmbʉ ʉ, nɛ bin dąnyahmu bʉ, bi nye'ma häi, bi nyąui Oją, bi 'yɛ̨mbi: ―Ma Ta i, nu'bʉ da zä, dami japi hin gan nugä a ra mbohi xcá sänni; pɛ hin dín nde ma pähä zɛhɛ pɛ hønt'a go ni pähä zɛhɛ gui 'yøt'e, bi 'yɛ̨mp'a Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nɛ bá peng bʉ mí hu ʉ xí zopʉ bʉya, nɛ mí ą ʉ. Nɛ bi 'yɛ̨mp'a ra Pedro: ―Ha xínga n'da zi ora xquí sɛthʉ a ra t'ąha, ngue 'bɛ xcán hyʉmhbʉ ts'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Damin äthąhʉ nɛ gui nyąhʉ Oją, guepʉ da zä hin hapʉ gui tąnjʉ 'bʉ bi ts'ä ahʉ ya, nguetho nu ní mbʉi n'da i ja ra pähä nangue Oją, pɛ nu ní ngøc'yɛi n'da xʉn güent'i thoho. ");
INSERT INTO otmNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nɛ ná yondį bʉya bi mba bi nyąui Oją mahøn'a: ―Ma Ta i, nu'bʉ ya hin da zä ga socä a xcá sänni, pɛ hønt'a ni pähä zɛhɛ gui 'yøt'e, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nɛ xø bi mbeng bʉ mi 'bʉ ʉ ma mixädihe. Xø mí ątho 'bʉ xø mi zøm bʉ mahøn'a, nguetho ɛ̨mmɛ mí nde t'ąha ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nɛ xø bi zopʉ ʉ mahøn'a, ya ná hyundį bʉya bi mbengui di nyąui Oją, nɛ guexta'a bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nɛ xø bi mbeng bʉ mí 'bʉh ma mixädihe mahøn'a, nɛ bi 'yɛ̨mbi: ―Nuya, 'da'angutho 'bʉ gán ąhmbʉ ya o hin'na, nguetho ya bi zøn ra ora da mba ma dägä bʉ 'bʉh yʉ ts'om'bäi, guecä dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dami ndanshʉ, ga mbähä ba nuhʉ ya ba ɛ̨cua ngue di dägä, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nɛ guexta'a mí yąhʉ ʉ ma mixädihe 'bʉ mi zøm bʉ a ra Judas, n'da ma mixädihe dí 'dɛ'mayoho gähe. Nɛ bán 'yohʉ xʉn ngu yʉ ją'i ba hyą yʉ́ juai nɛ yʉ ts'ąza. Nɛ gue'ʉ yʉ́m 'bɛhni yʉ hmumbäją nɛ yʉ dąc'yɛi, ma ngʉrpa judíohe. ");
INSERT INTO otmNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nɛ nu'a di dä ra Jesús bi xi a n'da ran t'uti da 'yøt' 'bʉ bi zøm bʉ: “Nu'a ga sʉs 'bʉ dán zɛngua'be, gue'a guim bɛnthʉ a,” bi 'yɛ̨n'a ra Judas. ");
INSERT INTO otmNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Janangue'a nu'bʉ mí zøm bʉ 'bä a ra Jesús, bi 'yɛ̨mbi: ―Xʉde ya 'bʉ, grá xänbate, bi 'yɛ̨mbi. Nɛ bi zʉspa rá 'yogu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nɛ bi dą'a ra Jesús bʉya: ―Xi'e n'yø, ha gue'a gní 'yɛ̨ a. Nɛ nu'ʉ mi'da bʉya bi hyäm bʉ 'bä a ra Jesús nɛ bi bɛnt'i. ");
INSERT INTO otmNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nɛ nu'a n'da ma mixädihe min 'yohʉ ra Jesús, bi c'os' rá juai nɛ bi zɛcpa rá gu a rá 'yɛ̨hɛ ra hmumbäją. ");
INSERT INTO otmNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nɛ bi 'yɛ̨n'a ra Jesús bʉya: ―Dami pɛ'ts'a ni juai bʉ ja rán t'o. Nu'ʉ din tuhni nangue ra juai, nɛ'ʉ dí du ra juai ʉ, bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ha guí ɛ̨na hin xtan zä ga äp'a rám fäts'i Oją ma Ta nɛ ba pɛnhua 'dɛ'mayo munts'i yʉ́m 'bɛhni da yąngui, bi 'yɛ̨mp'a n'da ma mixädihe. ");
INSERT INTO otmNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pɛ nu'bʉ da gue'a xcá mangä a, hague dán zä ga ją'ts'ä a bi man rá t'ohni Oją, ngue 'bɛ'a i jatho din ja, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nɛ bi 'yɛ̨mp'ʉ yʉ ją'i bʉya: ―'Bɛ'a guí homhbʉ ua ngue guí hą ni juaihʉ nɛ ni zahʉ. Ha guí ɛ̨mhbʉ drá bɛ̨gä, nɛ nya'a thoho dá xän'nahʉ bʉ ja ra dąniją nɛ njąm'bʉ gá bɛndgahʉ bʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pɛ gue'a din ja a tengu bi man'ʉ yʉ́ pøngahyą Oją 'bʉ maya'bʉ, bi 'yɛ̨n'a ra Jesús. Nɛ nugähe bʉya dyʉ xädigähe, 'bexgue dá 'dahmbe, dá sohmbe bʉ ra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nɛ bi bɛnt'a ra Jesús, bá si bʉ 'bʉh ra Caifás, ngue ra ngʉrpa mbäją. Nɛ ya xím pɛti gätho ma xänbate nijąhe nɛ yʉ dąc'yɛi, ma ngʉrpihe dyʉ judíohe. ");
INSERT INTO otmNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nɛ bi dɛn'na ra Pedro bʉya pɛgue a ná 'bɛjua thoho, bi zøm bʉ ja rá ngun'yu a ra hmumbäją bʉ hapʉ xí zøn'a ra Jesús. Nɛ 'darbʉ bi hyuhmbʉ ʉ yʉ asmayo, ngue in nde da nu a da t'ørpa a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nɛ nu'ʉ yʉ hmumbäją nɛ yʉ dąc'yɛi nɛ gä mi'da ma ngʉrpihe dyʉ judíohe, dyʉ israelhe, mi hon'a n'da ra fɛhni ngue da zä dí yąp'a nɛ da hyo. ");
INSERT INTO otmNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pɛ guehma nte bi dįnbi, madague'bʉ xʉn ngu ʉ bin juąnni, bi 'yɛ̨mbi majuąni ʉ yʉ́ fɛhni. Nɛ m'bɛjua bʉya, bi zøm bʉ yoho yʉn 'yohʉ din testigo, ");
INSERT INTO otmNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nɛ bi 'yɛ̨n'ʉ: ―Nuna ran 'yohʉ na bi 'yɛ̨na: “Nugä da zä ga xo't'ra dąniją nɛ man hyupa thoho da zä ga høe mahøn'a,” bi 'yɛ̨na, bi 'yɛ̨n'ʉ bin juąn bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nɛ bi ndanc'a ra hmumbäją bʉya bim 'bäi, bi t'ɛ̨mp'a ra Jesús: ―Hanja hin guí thąti 'bɛ'a i man ya yʉn 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pɛ nu ra Jesús bin hɛ̨tho. Nɛ bi 'yɛ̨n'a ra hmumbäją bʉya: ―Nangue rá thuhu Oją mahɛ̨ts'i, dami xije 'bʉ majuąni gue'e grá Thahni, grá Cristo, rá Ts'ʉnt'ʉ i Oją, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Bi dą a ra Jesús bʉya: ―Gue'a gám ma. Nɛ dí xi ahʉ, guin nujʉ, guecä dán ją'igä ua ja ra ximhäi, dam mixtegä ga com'be rá ts'ɛdi Oją tąte thoho rá ts'ɛdi. Nɛ guin nujʉ 'bʉ bá cącä mahɛ̨ts'i mahøn'a, ba ɛ̨cä bʉ ja yʉ güi, bi t'ɛ̨mp'a ra hmumbäją. ");
INSERT INTO otmNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nɛ nu ra hmumbäją bʉya, bi dʉnsɛ rá pahni. Nam bøni ɛ̨mbi hingui ɛ̨spa Oją ra Jesús nangue'a bi ma. Nɛ bi 'yɛ̨na: ―Nuna ran 'yohʉ na, bi man ra ts'ore nangue Oją. Him man ga homhbʉ yʉ testigo. Nɛ gätho gahʉ dá øhmbʉ a bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","'Bɛ'a guí ndehʉ ga øthʉ ya, bi t'ɛ̨mp'ʉ yʉ́ mingʉrpihʉ. Bi dą ʉ: ―Nuna i ja rá ts'oqui, i jatho da du, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nɛ nubʉya, 'dahma 'dan'yo bi t'ørpa ra Jesús. Bi zox ʉ 'da, bi mbɛ'mi ʉ mi'da, bi mbɛnpa rá hmi ʉ mi'da, ");
INSERT INTO otmNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","bi 'yɛ̨mbi: ―Nu'bʉ majuąni grá Thahni i Oją, ngue ra Cristo, dami xije to'o bi mbɛp'i i. Nɛ ɛ̨mmɛ bi denthoho. ");
INSERT INTO otmNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nɛ nu ra Pedro mi hupʉ thi bʉ ja ra ngun'yu, nɛ nu n'da ra xisu rá 'yɛ̨hɛ ra hmumbäją, bi mba bʉ hu a ra Pedro, bi 'yɛ̨mbi: ―Ɛ̨na nɛ'e gmín 'yohʉ na ra Jesús ra mɛngu Galilea, bi 'yɛ̨mp'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nɛ bi dą'a ra Pedro, bin cøni: ―Hin dí pądi, bi 'yɛ̨n'a. Nɛ gätho ʉ mi 'bʉpʉ bi 'yø a bi man ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nɛ nu'bʉ mi nde da bøn'a ra Pedro, bi nu man'da ra xisu bʉya nɛ bi 'yɛ̨mp'ʉ mí 'bʉpʉ: ―Nuna ran 'yohʉ na min 'youi ra Jesús, ra mɛngu bʉ Nazaret, bi 'yɛ̨n'a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nɛ xø bin cøn'a ra Pedro: ―Majuąni dím mangä ngue hin dí pącä a ran 'yohʉ guím ma, bi 'yɛ̨mp'a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","M'bɛjua bʉya nu ʉ 'da mi 'yo bʉ, bi mba bʉ 'bäh ra Pedro, nɛ bi 'yɛ̨mbi: ―Majuąni maha, nɛ'e gmín 'yohʉ a, mfądi thoho ni ndehʉ nɛ 'da'angu bʉ gna yąhʉ a, bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nɛ nts'ɛdi bi mam bʉya nɛ bin juąnni, bi 'yɛ̨na: ―Oją i pądi majuąni hin dí pącä a ran 'yohʉ guí mamhbʉ, bi 'yɛ̨n'a ra Pedro. Nɛ 'bexgue bi mbah ra tamfø bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nɛ nu ra Pedro bʉya, ja bi bɛ̨n'a xí man a ra Jesús 'bʉ mi 'yɛ̨mbi: “Dí pądi hin ní mbah ra tamfø 'bʉ na hyundį xquí cøngui.” Nɛ bi nɛxpʉ bʉya nɛ ɛ̨mmɛ bin zoni, xʉn ʉ bi bɛ̨ni nangue a bi 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nɛ nu'bʉ mi hyax bʉya, gätho yʉ hmumbäją nɛ yʉ dąc'yɛi, ma ngʉrpihe dyʉ judíohe, dyʉ israelhe, 'da'angu bi bɛ̨ni ngue di dä ra Jesús bʉ 'bʉ a ra ts'ʉt'abi, ngue da hyo. ");
INSERT INTO otmNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nɛ án thu't'i 'bʉ mi mba ma dä bʉ 'bʉ a ra Poncio Pilato, ra ts'ʉt'abi bʉ a. ");
INSERT INTO otmNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nɛ nu'a ra Judas xí dä a ra Jesús, 'bʉ mi 'yøde 'bɛ'a bi man ʉ ma ngʉrpihe ngue da hyo a ra Jesús, bi mba bʉya bi cospa a 'däte ma 'dɛt'a yʉ mbɛti ngue ra t'axi xí un'ndʉ yʉ hmumbäją, bi bɛ̨ni 'bɛ'a bi 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nɛ bi 'yɛ̨n'a ra Judas: ―Hingui ho hma a dá øt'e. Dá fänba rá ji n'da ran 'yohʉ hin'yʉ rá ts'oqui, bi 'yɛ̨mp'ʉ yʉ hmumbäją. Pɛ nu'ʉ bi dąti: ―Him ma güɛndagähe 'bɛ'a gá 'yøt'e. Ya guí pą'a guím bɛ̨nsɛ bʉ, bi 'yɛ̨n'ʉ yʉ hmumbäją. ");
INSERT INTO otmNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bá ɛn bʉ ra mbɛti bʉ ja ra niją a ra Judas bʉya, nɛ bi mba bá sʉt rá 'yʉga bʉ ja ra ndehnini. ");
INSERT INTO otmNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nɛ nu'ʉ yʉ hmumbäją bi hyąx'a ra mbɛti nɛ bi 'yɛ̨na: ―Hingui sä ga pɛs'hʉ ua na ra mbɛti ngue dim pɛcua mahøn'a, nguetho rán jut'iui ra ji na, bi 'yɛ̨n'ʉ, nɛ gue'a i mam bʉ ja man t'ɛ̨dihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nɛ bin 'yänni 'bɛ'a di jap'a ra mbɛti. Nɛ bi bɛ̨ni da dämba n'da xɛqui rá häi a ra 'yøt'ats'øe, guepʉ da t'äh yʉ 'damhnini 'bʉ da du bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nɛ asta guetya ní huti “rá häi ra ji” a ra xɛqui bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nɛ nu'a bin ja, maya'bʉ bi man'a ra pøngahyą Jeremías ngue din ja 'bʉ mí 'yɛ̨na ngue: “Da thąx i 'däte ma 'dɛt'a yʉ mbɛti ngue ra t'axi, rá muui a ra ją'i. Gue'a bi man ʉ yʉ mɛngu israel ngue di muui. ");
INSERT INTO otmNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nɛ bi dänba rá häi a ra 'yøt'ats'øe, ngubʉ bi xicä ra Hmu,” bi 'yɛ̨n'a ra Jeremías 'bʉ maya'bʉ 'bʉ mí ma. ");
INSERT INTO otmNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nu'bʉ mim 'bäpʉ ja rá hmi ra ts'ʉt'abi Pilato, bi 'yɛ̨mp'a ra Jesús: ―Ha gue'e grá hmuts'ʉt'abi yʉ judío, bi t'ɛ̨mbi. Bi dą a ra Jesús: ―Gue'a guím ma. ");
INSERT INTO otmNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nɛ nu'bʉ mi yąp'ʉ yʉ hmumbäją nɛ mi'da ma ngʉrpihe a ra Jesús, pɛ hin te i tątho a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nu ra Pilato bi 'yɛ̨mp'a ra Jesús: ―Ha hin guí ø'a i man'ʉ di yąp'i i, nɛ hin guí thąti. ");
INSERT INTO otmNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pɛ nu ra Jesús guexta'a hin te bi ma. Nɛ ɛ̨mmɛ bi hyonya thoho ra ts'ʉt'abi, him mi pądi 'bɛ'a sä da bɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nɛ nu ra ts'ʉt'abi nząi midi thø a n'da ra ofädi 'bʉ ra pa ra dąmpɛti ran dąbaxjua. Midi thø'a to'o bi huan'ndʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nɛ mi o bʉ n'da ran 'yohʉ í Barrabás, gätho mi fąpʉ 'bɛ'a mí øt'a. ");
INSERT INTO otmNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nu ra Pilato bʉya bi 'yän'ndʉ bim pɛti bʉ: ―To'o guí ndehʉ ga xocpahʉ ya. Ha gue ra Barrabás uague ra Jesús ngue nu'a ɛ̨mbi ra Cristo, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngubʉ bi ma nguetho mi pądi yʉ zɛya ʉ yʉ yąpate. ");
INSERT INTO otmNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nɛ nu'bʉ mi hupʉ ja ran ts'ɛmbate ra Pilato, bi mbɛnpa ra nde a rá xisu bi 'yɛ̨mbi: “Hin te gui 'yørpa a ra hogan'yohʉ, nguetho má xui dá 'uį n'da ra t'į nts'utho nangue a,” bi 'yɛ̨mp'a ra nde bi mbɛnbi. ");
INSERT INTO otmNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pɛ nu yʉ hmumbäją nɛ ʉ yʉ dąc'yɛi, bi 'bɛp'ʉ yʉ ją'i da 'yäpi go da mba ma thøgue a ra Barrabás, nɛ go da mba ntho a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nɛ bi 'yän mahøn'a a ra ts'ʉt'abi: ―Nda'a guín ndehʉ ga thøcä, bi 'yɛ̨mp'ʉ yʉ ją'i. Nɛ bi dą ʉ bʉya: ―Gue'a ra Barrabás gui thøgue, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nɛ bi dą a ra Pilato bʉya: ―Xi'a ra Jesús ɛ̨mbi ra Cristo, 'bɛ'a ga ørpä a thą. Gätho bi 'yɛ̨n'ʉ 'bʉpʉ: ―Dami cuatpʉ ja ra pont'i a. ");
INSERT INTO otmNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","―Pɛ hin te mán ts'o dá tįnba na, bi 'yɛ̨n'a ra Pilato. Pɛ nts'ɛdi bi dą ʉ: ―Dami cuatpʉ ja ra pont'i. ");
INSERT INTO otmNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Min nu ra Pilato bʉya ngue hingui sä dim päh yʉ́ mbʉi yʉ ją'i, pɛ man'da bin junthʉ ʉ. Janangue'a bi manda bá thunba ra dehe bʉya, bin xʉt'yɛ bʉ yʉ́ hmi yʉ ją'i, nɛ bi 'yɛ̨m bʉya: ―Nɛ nugä hin ma ts'oquigä rán dąte da nu na ran 'yohʉ hin te in dupate, pɛ go ni ts'oqui zɛhɛhʉ, bi t'ɛ̨mp'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nɛ bi dą ʉ yʉ ją'i bʉya: ―Hąha, madague'a i 'yosɛ ma güɛndahe a rán dąte na ran 'yohʉ, nɛcähe nɛ mam bom'bɛtohe dim 'bʉ 'bʉ niya'bʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nu ra Pilato bʉya bi xocpa a ra Barrabás, nɛ bi manda dí fɛi a ra Jesús bʉya. Nɛ bi manda da mba ma cuati bʉ ja ra pont'i. ");
INSERT INTO otmNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nɛ nu yʉ dofʉi bʉya bi zix'a ra Jesús bʉ mí ja yʉ́ ngun'ʉ yʉ dofʉi bʉ ja ra ngunts'ʉt'abi. Nɛ gätho yʉ dofʉi mí 'bʉpʉ bim pɛti, midi fäts'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nɛ bi mbøcpa rá he bʉya nɛ bi het'a n'da ra he xʉn jʉpoi tengu mi he yʉ ts'ʉt'abi. ");
INSERT INTO otmNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nɛ nts'ɛdi bi huspa n'da ra corona tengu mí hu'ts' yʉ ts'ʉt'abi, pɛgue ran thenni thoho bi 'yørpe, janangue'a ám 'be ra 'yʉ'uįni a ra corona. Nɛ bi un'na n'da ra tøhø rán 'yɛi tengu mí hą yʉ ts'ʉt'abi. Nɛ bin dąnyahmu bʉ ja rá hmi nɛ bi 'yɛ̨mbi: “Grá hmuts'ʉt'abi yʉ judío.” Nɛ bi 'yɛns' yʉ biba, pɛgue ran thenni thoho bi 'yørpe. ");
INSERT INTO otmNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nɛ bi ts'ots'i, nɛ bi hyąnba a rá tøhø nɛ bi mbärpa rá yą. ");
INSERT INTO otmNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nɛ nu'bʉ mi gua'a bi 'yʉspi bi mbøcpa a ra he xí het pʉya, bi het'ʉ yʉ́ hesɛ mahøn'a. Nɛ bi zix bʉya ngue di cuatpʉ ja ra pont'i bʉ ndehnini. ");
INSERT INTO otmNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nɛ nu'bʉ mi ts'ʉtho da bøm bʉ ja ra hnini, bin c'athʉ bʉ n'da ran 'yohʉ ra mɛngu bʉ Cirene, í Simón a. Nɛ bi t'ørpa ra ts'ɛdi da duspa rá pont'i ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nɛ bi zøm bʉ ja ra nyuni ɛ̨mbi Gólgota bʉya. Nu'a ra Gólgota in nde da ma “ra t'øhø nyąxmu” a. ");
INSERT INTO otmNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nɛ nubʉya bi un'na n'da ra vino mauąspi ra 'yɛ̨thi xʉn ju. Nu'bʉ ya mí zä a ra Jesús, him bi nde bi zi. ");
INSERT INTO otmNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nɛ nu'bʉ mi jua a bi cuatpʉ ja ra pont'i bʉya, nu'ʉ yʉ dofʉi bi 'yøt'a n'da ran tąha nangue rá he ra Jesús. Gue'a bi man'a ra pøngahyą maya'bʉ ngue din ja 'bʉ mi 'yɛ̨na: “Da mba ma dat'i a ma he nangue n'da ran tąha da 'yøt'e.” ");
INSERT INTO otmNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nɛ mi hupʉ yʉ dofʉi mi fädi. ");
INSERT INTO otmNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nɛ nubʉ rá yą a ra pont'i bi mba nt'o't'i bʉ ram hma bi ma 'bɛ'a í ts'ɛmba a ra Jesús, bi 'yɛ̨n'a ra t'ohni: “Nuna ra Jesús na, rá hmuts'ʉt'abi yʉ judío na.” ");
INSERT INTO otmNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nɛ bi mba ma cuatihʉ ra Jesús yoho yʉ bɛ̨, 'da a n'da yʉ́ pont'i. Nɛ bi 'bämp'ʉ ja rán 'yɛi a n'da nɛ bi 'bämp'ʉ ja rá gąha a man'da. ");
INSERT INTO otmNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nɛ nu yʉ ją'i mi thopʉ, bi zani, ");
INSERT INTO otmNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nɛ bi 'yɛ̨mbi: ―Nu'i guí ɛ̨na gui xo't' ra dąniją nɛ xø man hyupa thoho gui hyøh mahøn'a, 'bɛ'a guí øt' ya thą. Nu'bʉ majuąni gue'e rá Ts'ʉnt'ʉ i Oją, dami cąpʉ ja ra pont'i, gan yąnsɛ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nɛ'ʉ yʉ hmumbäją bi 'yʉspi nɛ yʉ xänbate niją, nɛ yʉ fariseo, nɛ yʉ dąc'yɛi, gätho ma ngʉrpihe, din 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Bi yąnba yʉ́ te ʉ 'da, pɛ hingui sä din yąnsɛ ya. Pɛ nu'bʉ majuąni da guehna ma hmuts'ʉt'abihʉ, dyʉ israelhʉ, sä xtán gąsɛ bʉ ja ra pont'i nɛ xcá ɛ̨c'yɛihʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bi ma, i ɛ̨na i tøp'ma rám fäts'i Oją, da zä da yąn a Oją ya 'bʉ, nguetho ya bi ma, guesɛ rá ts'ʉnt'ʉ Oją na, bi 'yɛ̨n'ʉ 'bʉ mi 'yʉspi. ");
INSERT INTO otmNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nɛ'ʉ yʉ bɛ̨ 'darbʉ bi guat'ʉ bi zan a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nɛ nu'bʉ mi hyuxadi bʉya bim 'bɛxui ra häi, nɛ jague'bʉ hyunde bi nɛqui mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nu'bʉ mi ts'ʉtho da zøn a hyunde, nts'ɛdi bi mbah ra Jesús, bi 'yɛ̨na: ―Elí, Elí, lama sabactani, bi 'yɛ̨na ngue ra nde ra arameo. Nu'a nam bøni: “Ma Oją i, ma Oją i, hanja gá hyɛga thoho,” bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nu'bʉ mi 'yø'a bi man ra Jesús 'da yʉ ją'i mi 'bäpʉ, bi 'yɛ̨na: ―Nuna ran 'yohʉ na, i mba't'a ra pøngahyą Elías, mí 'bʉ 'bʉ maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nɛ nu'a n'da mí 'bäpʉ 'bex bi mba bá hą n'da ɛ̨na ra fʉnjo, bi dʉrpʉ ja ra vino nɛ bi ndøcta n'da ra xithi, nɛ bi 'uąspa a ra Jesús, ɛ̨mbi da zi. ");
INSERT INTO otmNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nɛ bi 'yɛ̨n'ʉ mi'da mí 'bäpʉ: ―Dami hyɛhmbʉ. O te guidí unhdʉ. 'Bɛ gan nuhʉ 'bʉ ba ɛ̨h ra Elías da yąni, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nɛ xø bi mbafi nts'ɛdi mahøn'a ra Jesús, nɛ 'bex bi du bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nɛ nu'a ra ora a bʉya, nu'a ra 'bø't'e mi ndam bʉ man'da mbo ra dąniją bá fʉpʉ magąts'i bi xɛt'i nɛ 'bexgue bi zøt'a häi. Nɛ bi 'yąn ra häi bʉya, nɛ bi fø'i 'da yʉ do hønbʉ go hapʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nɛpʉ ja yʉn 'yägui bi føh yʉ jądo. Nɛ nu'bʉ mi dąmbɛ̨ni ra Jesús, bi bøx ʉ 'da yʉ 'yɛ̨c'yɛi xi du, bi dąmbɛ̨ni bʉ ja yʉ́n 'yägui ʉ, ");
INSERT INTO otmNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","bi mba bʉ ra hnini Jerusalén ʉ nɛ bi nu ʉ 'da yʉ ją'i ʉ xi du. Pɛ hinga gätho yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nɛ nu'bʉ mi du ra Jesús, nɛ nu'a ra hmudofʉi mí fä a ra Jesús, nɛ'ʉ mi'da min 'yohʉ, 'bʉ mi nu di 'yąn ra häi, nɛ'ʉ gä mi'da bin ja, ɛ̨mmɛ bin su ʉ, nɛ bi 'yɛ̨n'ʉ: ―Majuąni maha, rá Ts'ʉnt'ʉ Oją na ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nɛ mí 'bäpʉ njombʉ ts'ʉ 'da yʉ xisu ngue man yʉ́m fäts'ihʉ a ra Jesús 'bʉ mán 'yohe bʉ ja ra 'yu, 'bʉ mambá nɛxhe bʉ Galilea. Mi 'bäpʉ ʉ, nguetho mi nde da nu 'bɛ'a da t'ørpa ra Jesús. Nɛ nu'ʉ bi nu 'bɛ'a gä bin ja. ");
INSERT INTO otmNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nɛ nu'a n'da mi 'bäpʉ, ra María Magdalena a; nɛ'a man'da ra María mi 'bäpʉ, ngue rá mbe ra Jacobo nɛ ra José; nɛ nu man'da ra xisu mi 'bäpʉ, gue'a rá mbe ra Jacobo nɛ ra Xuua, yʉ́ ts'ʉnt'ʉ ra Zebedeo ʉ; nɛ'ʉ mi'da yʉ xisu mi 'bäpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Nɛ nu'a ra José, n'da ra mɛmbɛti bʉ ra hnini Arimatea, bi mba bʉ 'bʉh ra Pilato 'bʉ mi ts'ʉtho da yʉh ra hyadi. Bi 'yädi da 'yäcpa rá ngøc'yɛi ra Jesús, nguetho mi ɛ̨c'yɛi a. Nɛ bi manda ra Pilato bʉya din t'unni. ");
INSERT INTO otmNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nu ra José bʉya bi duspa rá ngøc'yɛi a ra Jesús nɛ bi mbärpa n'da ra 'bø't'e xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nɛ bi gärpʉ ja rán 'yägui zɛhɛ a ra José. N'da ra hyądo xí manda xí mba nthɛ̨qui. Nu'bʉ mi gua'a bi gärpʉ, bi juaspʉ n'da ra xįndo xʉn hyʉ bʉ ja rá goxthi ra hyądo, nɛ bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nɛ mi hupʉ ra María Magdalena, nɛ man'da ra María mi hupʉ ja rá goxthi ra hyądo. ");
INSERT INTO otmNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nɛ nu'bʉ mi hyax a ra pa ran ts'äya bʉya, xudi thoho bi mba ʉ yʉ hmumbäją nɛ yʉ fariseo, bá nu ra Pilato, ");
INSERT INTO otmNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nɛ sä bi 'yɛ̨mbi: ―Ma ts'ʉt'abi ahe, dá bɛ̨mhbe man'da bi man'a ra hyäte 'bʉ him maní du, bi 'yɛ̨na: “Nu'bʉ ná hyupa ga thąmbɛ̨ni bʉ 'bʉ ʉ xøn du,” bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Janangue'a xʉn ho 'bʉ gui pɛhni to'o da mbäh ran 'yägui an hyupa, xøhma ba ɛ̨ ʉ yʉ́ xädi 'bʉ bin xui da gʉcpa a rá ngøc'yɛi, nɛ da 'yɛ̨na bi dąmbɛ̨ni bʉya. Man'da xʉn ts'o ra fɛhni tengu a, xinda gue a bi mansɛ 'bʉ mi 'bʉi, sä bi 'yɛ̨n'ʉ yʉ hmumbäją nɛ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bi dą a ra Pilato bʉya, bi 'yɛ̨mbi: ―Sixhʉ ʉ n'dan nɛ'ts'i ni dofʉi dá 'da'ahʉ. Dami cothʉ xʉn ho bʉ ja rá goxthi a ra hyądo, nɛ njon da zä da xo't'i. ");
INSERT INTO otmNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nɛ bi mbähä ʉ yʉ mbäją nɛ yʉ fariseo, bi got'i xʉn ho a ra hyądo nɛ bi mɛpya, nɛ bá peng bʉya, bá copʉ yʉ dofʉi ngue da mbädi. ");
INSERT INTO otmNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nɛ nu'bʉ ya mi thoh ra pa ran ts'äya, xø rá mbʉdi ra semana, bi mba mxudi thoho ʉ yoho yʉ xisu. Nu'a n'da ra María Magdalena nɛ'a man'da ra María. Nu'bʉ mí nɛts'i ní mba bʉ bí ja a ra hyądo. ");
INSERT INTO otmNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nɛ nu'bʉ mí mba ʉ, 'bexgue nts'ɛdi bi 'yąn ra häi mahøn'a. Nguetho bi 'yøt'a rám 'bɛhni Oją xí zøpʉ 'bʉ mí 'uec'a ra do mi juaxpʉ ja rá goxthi ra hyądo. ");
INSERT INTO otmNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","5","Nɛ nu'a rám 'bɛhni Oją di fɛxni tengu n'da ra huɛi. Nɛ nu rá he bʉya, xʉn t'axi tengu n'da ran nɛqui. Nɛ nu'ʉ yʉ dofʉi 'bʉ mín nu a rám 'bɛhni Oją ɛ̨mmɛ bin su, bi fɛt'i, nɛ nte sä da 'yøt'e, tengu'bʉ xi du. Nu'a rám 'bɛhni Oją, mi hupʉ ja a ra do xí 'ueque, nɛ bi 'yɛ̨mp'ʉ yʉ xisu 'bʉ mi zøm bʉ: ―O guín suui. Dí pądi ngue guí hommi a ra Jesús xí cuatpʉ ja ra pont'i ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pɛ njo'o ua, bi mba nsots'i tengu mi ma. Ba thohmi gui nuui ua mí 'bɛni, bi 'yɛ̨n'a rám 'bɛhni Oją 'bʉ mi 'yɛ̨mp'ʉ yʉ xisu. ");
INSERT INTO otmNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nuya, ní mbɛ 'dahmantho, gui xihmi yʉ́ xädi: “Bi dąmbɛ̨ni bʉ 'bʉ ʉ xøn du ya,” gui 'yɛ̨nui. Nɛ nde'bʉ gätho ahʉ gui mbähä bʉ Galilea nɛ guepʉ guin c'athʉ bʉ. Nɛ gue'a bá ɛ̨cä ua ngue ga xi aui, bi 'yɛ̨mp'a rám 'bɛhni Oją mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nɛ bi bøm bʉ ja ra hyądo ʉ yʉ xisu, bin su nɛ xim midi johya. Bin tihi, bi mba bá xi ʉ yʉ́ xädi ra Jesús 'bɛ'a bi sifi. ");
INSERT INTO otmNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nɛ bi zʉpʉ 'yu a ra Jesús ʉ yʉ xisu. ―Xíhats'i, bi 'yɛ̨mp'ʉ. Nu yʉ xisu bʉya bin dąnyahmu nɛ bi hyʉp'ʉ yʉ́ gua, bi dąnde bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nɛ bi 'yɛ̨n'a ra Jesús: ―O guín suui, ni mbɛ ba xihmi ʉ ma cuhʉ, ní mbähä bʉ Galilea, ja nín tįmhbʉ bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nɛ nu'bʉ mí mbenc'ʉ yʉ xisu, nɛ'ʉ yʉ dofʉi mí fäh ran 'yägui bi mba bá xi ʉ yʉ hmumbäją 'bɛ'a gätho bin ja. ");
INSERT INTO otmNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bim pɛti yʉ hmumbäją bʉya, nɛ yʉ dąc'yɛi. Bi ma 'bɛ'a da zä da 'yøt'e. Nɛ nubʉya xʉn ngu ra mbɛti bi un'ndʉ yʉ dofʉi ");
INSERT INTO otmNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nɛ bi 'yɛ̨mp'ʉ: ―Gui 'yɛ̨mhbʉ: “Bá ɛ̨ ʉ yʉ́ xädi 'bʉ min xui 'bʉ mán ąhmbe, bi bɛ̨p'a rá ngøc'yɛi,” gui 'yɛ̨mhbʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nɛ nu'bʉ da 'yø'a ra ts'ʉt'abi ngue gán ąhmbʉ, nɛ da 'yɛ̨na da zʉ ahʉ, nugähe dan yąhe ga fäx ahe, bi 'yɛ̨n yʉ hmumbäją 'bʉ mi 'yɛ̨mp'ʉ yʉ dofʉi. ");
INSERT INTO otmNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nɛ bi hyąn a ra mbɛti ʉ yʉ dofʉi bʉya. Bi mba da 'yøt'a bi sifi. Nɛ nu'a ra fɛhni bi man ʉ, xʉn ngu bi 'yɛ̨c'yɛi ʉ ma mijudíohe dyʉ israelhe. Nɛ guexta'a ra fɛhni i man ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nɛ dá mbähmbe bʉ ra häi Galilea bʉya, dí 'dɛ'ma'da gähe, yʉ́ xädigähe ra Jesús. Nɛ dá sømhbe bʉ ja ra nyuni xí xije ra Jesús dan c'athe bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nɛ nu'bʉ má nuhe, dá ɛ̨spahe a, pɛ nu'ʉ 'da him mi ɛ̨c'yɛi gue gue'a. ");
INSERT INTO otmNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nɛ bi hyäm bʉ dí 'bähmbe a ra Jesús nɛ bi 'yɛ̨nje: ―Gätho ra ts'ɛdi bin 'dacä ga manda gätho ra ximhäi nɛ mahɛ̨ts'i, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Janangue'a ní mbähä ya hønbʉ go hapʉ 'bʉh yʉ ją'i gä na ndoho ra ximhäi, gui xihmbʉ da 'yɛ̨c'yɛigui. Nɛ nu'ʉ to'o di däcä yʉ́ mbʉi, gui xixyąbahʉ nangue rá thuhu ma Ta, nɛ nangue rá thuhu rá Ts'ʉnt'ʉ, nɛ rá thuhu rá Hogandąhi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nɛ gui xänbahʉ da 'yøt'e 'bɛ'a gätho dá xi ahʉ. Nɛ guim bɛ̨mhbʉ dín 'yohʉ gätho yʉ pa asta gue'bʉ da guah ra ximhäi, bi 'yɛ̨ngähe ra Jesús bʉya.");
INSERT INTO otmNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ja ua rá mbʉdi ran ho ma'da'yo nangue'a ra Jesucristo, rá Ts'ʉnt'ʉ Oją. ");
INSERT INTO otmNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bin ja a mán t'o't'i 'bʉ maya'bʉ bʉ ja rá søcuą Oją 'bʉ mí 'yɛ̨na: Nugä ga pɛhn'na n'da mam 'bɛhni dim 'bɛt'o bʉ gni mba. Nu'a da xih yʉ ją'i da døp'e'e, bi 'yɛ̨mp'a rá Ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nɛ'a ra pøngahyą Isaías bi ma nguehna rám 'bɛhni 'bʉ mi 'yɛ̨na ngue: N'da ra ja'i din yą nts'ɛdi bʉ ja ra dąpo ngue da 'yɛ̨na: “Damin sähʉ ga simhbʉ ra hmu mi ts'ʉtho da zøcua, Dami hoc ni mbʉihʉ ga tømhbʉ xʉn ho,” da 'yɛ̨n a mam 'bɛhni, i ɛ̨n Oją, bi 'yɛ̨n'a ra Isaías. ");
INSERT INTO otmNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nɛ gue'a ra Xuua bi 'yøt' ran xixyą bʉ ja ra dąpo bi man Oją maya'bʉ. Nu ra Xuua bi xih yʉ ją'i din xixyą to'o di päh yʉ́n 'yomfɛ̨ni nɛ da mba ma punbi yʉ́ ts'oqui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gätho yʉ ją'i mi 'bʉpʉ ra xɛqui Judea, nɛpʉ ra dąhnihni Jerusalén, bi zøm bʉ i øt' ran xixyą ra Xuua. Nɛ nu'ʉ 'da bi päh yʉ́n 'yomfɛ̨ni nɛ bi mam bʉya ngue hingui ho 'bɛ'a xí 'yøt'e. Nɛ bi mba ma xixyąba bʉ ja ra dąthe Jordán ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nu ra Xuua mí he n'da ra mbapahni án t'øt'e ngue yʉ́ xingu yʉ camello nɛ mi ja rán gʉt'i ra xifani. Nɛ hønt'ʉ yʉ t'ąxi nán sihmɛ nɛ ra t'afi t'asa dąpo. ");
INSERT INTO otmNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nɛ bi 'yɛ̨na: ―Ba ɛ̨pʉ n'da man'da ja rá ts'ɛdi xinda guecä, hin dí sʉcä tengu a. ");
INSERT INTO otmNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nugä xtá xixyą ahʉ nangue ra dehe thoho, pɛ nu'a di 'da'ahʉ rá Hogandąhi Oją, bi 'yɛ̨mb yʉ ją'i a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nɛ nu yʉ pa bi 'yøt' ran xixyą ra Xuua, bi nɛxpʉ ra hnini Nazaret ra Jesús, ngue ra xɛqui Galilea. Nɛ bi zøm bʉ ra Jesús bin xixyą'a bʉya bʉ ja ra dąthe Jordán. Gue'a ra Xuua bi 'yøt' ran xixyą. ");
INSERT INTO otmNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nɛ nu'bʉ mí bøxpʉ ja ra dehe bʉya 'bex bi nu bi xoh mahɛ̨ts'i nɛ bá cąh rá Hogandąhi Oją, tengu n'da ra t'azʉ, bi zøpʉ 'bäh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nɛ bi t'ø a n'da ra nde mahɛ̨ts'i bi 'yɛ̨na: ―Ma Ts'ʉnt'ʉ i, dadí huɛ̨c'i i nɛ dín numanho i, bi 'yɛ̨n a ra nde. ");
INSERT INTO otmNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nɛ nubʉya nu rá Hogandąhi Oją 'bex bi bɛ̨nbi da mba bʉ ma'ueni a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nɛ nyote pa bim 'bʉpʉ nɛ nyote xui. Nɛ nu ra zįthu ra Satanás bi zäp rá mbʉi a ra Jesús gätho yʉ pa bim 'bʉpʉ, nɛ mí 'bʉhmbʉ bʉ yʉ zate. Pɛ bi mbäx'ʉ yʉ́m 'bɛhni Oją mahɛ̨ts'i a ra Jesús 'bɛ'a gä bi nu bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ya xí jot'a fädi ra Xuua Nxixyą 'bʉ mi bøm bʉ ra Jesús bʉ ra xɛqui Judea, bi mba bʉ Galilea. Nɛ bi mam bʉ ran ho ma'da'yo ngue 'bɛpʉ dí manda rá ts'ɛdi Oją n'da. ");
INSERT INTO otmNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nɛ bi 'yɛ̨mb yʉ ją'i: ―Mi ts'ʉtho da zøn ra pa di manda ua rá ts'ɛdi Oją, dami päh nin 'yomfɛ̨nihʉ, damin unsɛhʉ di manda ahʉ Oją 'dahma din ja ahʉ ra te ma'da'yo. Gue'a bi man a ra Jesús 'bʉ mí 'yɛ̨mp'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","N'da ra pa mi 'yo bʉ a ra Jesús bʉ ndendądehe t'ɛ̨mbi Galilea. Nɛ nubʉya bi nu a ra Simón n'youi rán 'yohʉ i Andrés a, mi ɛnxit'ą bʉ ja ra dądehe ʉ, ngue yʉ́ 'bɛfi yʉ mbahuą ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ra Jesús bi 'yɛ̨mp'ʉ: ―Ba tɛngaui ga ja aui gui xihmi yʉ ją'i da 'yɛ̨c'yɛigui tengu thoho bʉ gní thɛui yʉ huą ngubʉ guí øt'ui, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","'Bex bi hyɛpʉ yʉ́ xit'ą bʉya nɛ bi dɛnni. ");
INSERT INTO otmNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nɛ xø bi thogui bin 'yo mi ts'ʉ nɛ bi nu a ra Jacobo n'youi rán 'yohʉ i Xuua a, gätho ʉ yoho yʉ́ ts'ʉnt'ʉ ra Zebedeo ʉ. Mi hubʉ ja yʉ́ mbosa ʉ, midi hoc yʉ́ xit'ą. ");
INSERT INTO otmNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nɛ xø bi xifi da dɛn'dʉ. 'Bex bi dɛn'dʉ bʉya bi zopʉ rá ta bʉ ja ra mbosa ʉ bʉya nɛ yʉ́ mbɛfi. ");
INSERT INTO otmNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nɛ nubʉya nu ra Jesús bi yʉthʉ bʉ ja ra hnini Capernaum ʉ xí tɛnni. Nu ra pa ran säya mí cʉrpʉ ja ra niją nɛ mi xänba bʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nɛ nu'ʉ bʉya, ɛ̨mmɛ bi hyonya thoho 'bʉ mí 'yø a bi man ra Jesús, nguetho bi xänbi xʉn ho nɛ hinga ngubʉ mí man ʉ ma xänbate sɛhe ngue dyʉ israelhe, dyʉ́ judíohe. 'Bex gue bi bądi ja rán t'ɛ̨di ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nɛ mi 'bʉpʉ n'da ran 'yohʉ n'youi ra zįthu nɛ nts'ɛdi bi mbah pʉya, bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―'Bɛ'a guí nde gui 'yørcahe grá Jesús, grá mɛngu Nazaret. Ha gui juaje ya. Dí pądi gue'e rá Thahni i Oją gue xʉn hotho, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pɛ nu ra Jesús bi dąmhyą ra zįthu, bi 'yɛ̨mbi: ―Daman hɛ̨, dami pøm bʉ ja rá mbʉi na ran 'yohʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nu ra zįthu bʉya nts'ɛdi bi huą'ts'a ran 'yohʉ, nts'ɛdi bi mbafi, nɛ bi bøm bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gätho bi hyonya thoho ʉ 'bʉpʉ nɛ bin 'yɛ̨mzɛhɛ ʉ: ―'Bɛ'a nam bøn'a dí nuhʉ ya. 'Bɛ'a ni 'da'yonxädi na, nguetho i ja rán t'ɛ̨di na i sʉh yʉ zįthu nɛ i su ʉ, bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nɛ 'bexque 'dahmantho bi hmam bʉ gätho ra häi Galilea 'bɛ'a bi 'yøt'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nu'bʉ mi bøm bʉ ja ra niją a ra Jesús bi mbähä ra Simón, nɛ ra Andrés, nɛ ra Jacobo, nɛ ra Xuua. Bi zømhbʉ bʉ rá ngu ra Simón. ");
INSERT INTO otmNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nɛ nu'a rá suto ra Simón 'bɛm bʉ rá oi, i hɛ̨mb ra pa. Nɛ bi si a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nɛ bi nu bʉ i 'bɛn'a ra xisu bʉya, bi bɛnba rá 'yɛ nɛ bi xots'i. 'Bex bi bøn a ra pa, hin hapʉ xʉn'ʉ, nɛ 'bex bi zä bi hoc yʉ́n sihmɛ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nɛ nu'bʉ mí yʉh ra hyadi gätho ʉ mi ʉ bá ts'inba a ra Jesús bʉ mi 'bʉi, nɛ ʉ min 'yohʉ ra zįthu bá ts'inbi. ");
INSERT INTO otmNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bim pɛti bʉ ja ra goxthi gätho yʉ ją'i 'bʉpʉ ja ra hnini. ");
INSERT INTO otmNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Gätho na ngu yʉ hyɛ̨nni bi hoqui, nɛ bi hyønba thi yʉ zįthu min 'yohʉ ʉ 'da. Nɛ nu yʉ zįthu, ɛ̨mmɛ mi ndehma da ma to'o a ra Jesús, pɛ nu ra Jesús him bi japi din yą ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nɛ nu'bʉ mi ts'ʉtho da hyax bʉya, bi ndants'a ra Jesús bi bøm bʉ ja ra hnini, bi mba bʉ ma'ueni bin yąui Oją. ");
INSERT INTO otmNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nɛ nu'bʉ mi hyats'i xʉn ho bʉya, bi mba ra Simón da hyoni, nɛ'ʉ mi'da mi 'bʉhmbʉ bi mbähä da hyomhbʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pɛ nu'bʉ mí dįm bʉya, bi 'yɛ̨mbi: ―Mbähä bʉ ja ra ngu nguetho gätho yʉ ją'i hon'a bʉ mahøn'a, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","―Hin'na, pɛ man'da xʉn ho 'bʉ ga mbähä bʉ ja mi'da yʉ hnini, nɛpʉ ga mangä bʉ mam hmam bʉ, nguetho gue'a bá ɛ̨cä ua a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'Bex bi mbähä bʉya, bin 'yo gätho ra häi Galilea, bi man rám hman Oją bʉ ja yʉ niją nɛ bi hyøn'a thi yʉ zįthu mín 'yohʉ 'da yʉ ją'i bʉ bi thogui. ");
INSERT INTO otmNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nɛ bi zøm bʉ n'da ran 'yohʉ bʉ 'bäh ra Jesús, i hɛ̨mb ra t'axca'ya. Bin dąnyahmu, bi 'yäp ra mate, bi 'yɛ̨na: ―Nu'bʉ ni pähä da zä gui hogui ts'ʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bin yeh rá mbʉi ra Jesús, bi dä'a ra hyɛ̨nni, nɛ bi 'yɛ̨mb bʉya: ―I jagä ra pähä da yąn'a ya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","'Bex bim 'bɛ'ʉ yʉ 'ya mi hɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nu ra Jesús bʉya, nts'ɛdi bi hɛcpi nɛ bi 'yɛ̨mbi: ―Nuya, njon gui xifi 'bɛ'a dá øt'e'e. Ni mba, bán 'yupʉ 'bʉh ra mbäją, gui un bʉ n'da ra 'bøts'e i man rán t'ɛ̨di ra Moisés da hyąxpʉ n'da 'bʉ ya bi yąn ra t'axca'ya, nɛ da fąh bʉya ngue bi zä i, bi 'yɛ̨mbi. Nɛ bi xifi da mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pɛ nu ran 'yohʉ 'bʉ mi bøm bʉ bi mbʉdi ɛ̨mmɛ mma. Nɛ bi xih yʉ ją'i 'bɛ'a xí t'ørpe. Jannangue'a nu ra Jesús ya him bi zä da yʉrpʉ ja yʉ hnini nɛ 'yotho bʉ ma'ueni nguetho ɛ̨mmɛ bi muns yʉ ją'i 'bʉ i cʉrpʉ ja ra hnini. Pɛ guehma xʉn ngu yʉ ją'i mi zøm bʉ hapʉ mi 'yo ngue høn bʉ go hapʉ ní nɛts'i. ");
INSERT INTO otmNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nu'bʉ mi tho i ts'ʉ 'da yʉ pa bi yʉt mahøn'a bʉ Capernaum ra Jesús. Nu'bʉ mí 'yøh yʉ ją'i ngue 'bʉpʉ ja ra ngu, ");
INSERT INTO otmNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'bexque xʉn ngu bi zøm bʉ yʉ ją'i gue'bʉ go mi yupʉ mbo ra ngu nɛpʉ thi. Nu ra Jesús bʉya, bi xih rám hman Oja ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nɛ nubʉya, bi zøm bʉ 'da yʉn 'yohʉ i tu n'da ra hyɛ̨nni ngue mí ts'a rá ją'i. Goho ma 'yohʉ ʉ yʉn dute. ");
INSERT INTO otmNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nɛ hingui sä da thopʉ 'bʉh ra Jesús nguetho mi dʉ bʉ yʉ ją'i. Janangue'a bi xø'ts'a n'da xɛqui ra 'bet'e, bi cąmp'ʉ a ra hyɛ̨nni con rá 'beza. ");
INSERT INTO otmNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","'Bex bi bąh ra Jesús ngue mi pą ʉ ngue i jasɛ rá ts'ɛdi, nɛ bi 'yɛ̨mp'a ra hyɛ̨nni bʉya: ―Nu'i, n'yø, ni ts'oqui ya xʉm pun'ni i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nɛ nu'ʉ 'da yʉ xänbate niją, mi hupʉ. Nɛ nu'bʉ mí 'yø'a 'bɛ'a i man ra Jesús, ");
INSERT INTO otmNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","bi 'yɛ̨nsɛ mbo yʉ́ mbʉi n'da ngu n'da: “Xina, hanja ni man na tengu na. Pɛ hingui numansu Oją na, njo'o n'da ra ją'i da zä di punba yʉ́ ts'oqui n'da, hinda hønt'a Oją,” bi 'yɛ̨nsɛ yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pɛ nu ra Jesús 'bexque bi bątho 'bɛ'a mbɛ̨n ʉ, nɛ bi 'yɛ̨mp'ʉ: ―Hanja ngubʉ guím bɛ̨mhbʉ mbo ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ha guím bɛ̨mhbʉ ngue nte ni mba tho a dá xicä na ran 'yohʉ ngue rá ts'oqui ya xʉm punbi. Ha guím bɛ̨mhbʉ man'da xquí pąhmbʉ ngue i ja ma ts'ɛdi 'bʉ ga xifi da ndants'i, da gąx rá fįdi din 'yo. ");
INSERT INTO otmNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pɛ nugä ngue dán ją'igä ua ja ra ximhäi, ga ut'ahʉ ya i ja man t'ɛ̨di ua ja ra häi ngue ga punba yʉ́ ts'oqui n'da ra ją'i, jannangue'a ga japi din 'yo na ran 'yohʉ ya, bi 'yɛ̨n a ra Jesús. Nɛ nubʉya, bi 'yɛ̨mp'a mí ts'a rá ją'i: ");
INSERT INTO otmNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Nu'i, dí xi i, ndants'i, cąx ni fįdi, ni mba ni ngu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nubʉya, 'bex bi ndants'i, bi gąx rá fįdi, bi bøm bʉ i ja ra ngu. Nɛ bi nu ʉ gätho mi 'bʉpʉ. Nɛ bi hyonya thoho ʉ. Jannangue a bi 'yɛ̨spa Oją ʉ bʉya nɛ bi 'yɛ̨n ʉ: ―Njąm'bʉ xtá nuhʉ tengu a bin ja ya, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","M'bɛjua bʉya xø bi mba mahøn'a bʉ ja ra ndendądehe a ra Jesús. Nɛ mi søm bʉ yʉ ją'i nɛ mi xänba bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nu'bʉ mi thopʉ 'bʉ a ra Leví, i hupʉ ja rá mɛxa gue'a ra hyącahäi a. Nu'a ra Leví rá ts'ʉnt'ʉ ra Alfeo a. Nu ra Jesús bʉya bi 'yɛ̨mbi: ―Ba tɛngui. 'Bex bi ndants'a ra Leví bʉya, bi dɛnni. ");
INSERT INTO otmNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nɛ bin sihmɛhʉ ra Jesús nɛ yʉ́ xädi bʉ ja rá ngu a ra Leví. 'Darpʉ bin sihmɛhʉ 'da yʉ ziyate hyącahäi nɛ mi'da yʉ ts'om'bäi. Xʉn ngu mi 'bʉpʉ nguetho xʉn ngu ʉ ya xí 'yɛ̨c'yɛi a. ");
INSERT INTO otmNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nɛ nu'ʉ 'da ma xänbatehe bʉ niją, yʉ fariseo ʉ, nɛ nu'bʉ mi nu ra Jesús nɛ yʉ́ xädi sihmɛhʉ ʉ yʉ ziyate hyącahäi nɛ yʉ ts'om'bäi nɛ bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús: ―Hanja ngubʉ øt' ni Hmuhʉ. Hingui ho øt'a ngue i sihmɛhʉ yʉ ziyate hyącahäi nɛ yʉ ts'om'bäi, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nu'bʉ mí 'yøh ra Jesús 'bɛ'a bi man ʉ, bi 'yɛ̨mp'ʉ: ―Nu'ʉ im bɛ̨nsɛ xʉn zaqui hingui honi to'o da mbäts'i, hinda hønt'ʉ i pąsɛ in zäman'ʉ i honi to'o da mbäx ʉ. Nɛ nugä bá ɛ̨cä ga fäx ʉ i pądi ja yʉ́ ts'oqui, him bá ɛ̨cä ga fäx ʉ im bɛ̨nsɛ yʉ hocją'i, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nu'ʉ yʉ́ xädi ra Xuua Nxixyą nɛ yʉ́ xädi yʉ fariseo mí ɛ't' yʉ́n sihmɛ ʉ. Nɛ bi zøm bʉ ʉ 'da bʉ mí 'bʉh ra Jesús ngue bi 'yänni nɛ bi 'yɛ̨mbi: ―Hanja hingui ɛ't' yʉ́n sihmɛ ʉ ni xädi nɛ i ɛ't' yʉ́n sihmɛ ʉ yʉ́ xädi ra Xuua nɛ yʉ́ xädi yʉ fariseo, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ra Jesús bi xi'a n'da ran t'uti ngue ran thąti 'bʉ mi dąt'ʉ, bi 'yɛ̨mbi: ―Pɛ nu'ʉ i 'bʉpʉ ja ran thąti hin da du yʉ́ mbʉi nguetho 'bʉpʉ a ran 'yohʉ din thąti. Hin da 'yɛ̨na ngue hin din sihmɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pɛ da zøn ra ora da ts'ispa a ran 'yohʉ nɛ ja da 'yɛ't' yʉ́n sihmɛ bʉya, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nɛ nu'a din xä ʉ ma xädigä hin da bømanho 'bʉ nɛ'a ra nyomhma da dɛn ya, tengu thoho ra naxca 'bø't'e hin da zä di 'bø't'a ra 'ya'bø't'e nguetho da xɛ thoho mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nɛ ngutho a ra vino ma'da'yo hin da zä da sirpʉ ja ra 'yambot'asɛ̨i nguetho nu'a ra vino ma'da'yo da dʉn 'bʉ da sirpʉ nɛ dim fän a ra vino bʉya, gätho 'da dín ts'ontho bʉya. Nu'a ra vino ma'da'yo i pa nsi't'i bʉ ja yʉ mbot'asɛ̨i ma'da'yo, pi 'yɛ̨n'a ra Jesús 'bʉ mí dądi. ");
INSERT INTO otmNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nɛ nu'a ra pa ran ts'äya bi mbähä yʉ́ xädi ra Jesús, bi thopʉ ja n'da rá huąhi yʉ trigo. Nu yʉ́ xädi bʉya i toc yʉ trigo bʉ bi thogui. ");
INSERT INTO otmNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nu yʉ fariseo bi nu 'bɛ'a bi 'yøt'ʉ yʉ́ xädi ra Jesús nɛ bi t'ɛ̨mp'a ra Jesús bʉya: ―Hanja ngubʉ i øt'ʉ ni xädihʉ ya nɛ i ma man t'ɛ̨dihʉ hin dam pɛhmbʉ a ra pa ran ts'äya, bi 'yɛ̨n'ʉ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Ha hin guí nu bʉ ni søcuąhʉ ngue nɛ ra David bi mbɛsta rán t'ɛ̨di Oją 'bʉ n'dandį 'bʉ min tumanthuhu bʉ bin 'yo nɛ ʉ min 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Janangue'a bi yʉrpʉ ja rá ngu Oją nɛ bi zihʉ bʉ yʉ 'bøxthuhmɛ. Pɛ him mi sä xtán zi ʉ nɛ hønt'ʉ yʉ mbäją i sä da zi ʉ. Nɛ nu ra Abiatar, ra hmumbäją bʉ a, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nɛ xø bi 'yɛ̨na: ―Í ts'än'na ra pa ran ts'äya nguetho bi ndep yʉ ją'i hin ɛ din ʉnbi, hin í ts'änni ngue da mba nts'upi. ");
INSERT INTO otmNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nɛ nugä ngue dán ją'igä ua ja ra ximhäi, drá hmugä nɛ i ja man t'ɛ̨di gam mangä 'bɛ'a da 'yøt' yʉ ją'i ra pa ran ts'äya, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nɛ nu ra Jesús bʉya bi yʉrpʉ ja ra niją mahøn'a. Nɛ mí 'bʉpʉ n'da ran 'yohʉ him mi sä di juąn rá 'yɛ. ");
INSERT INTO otmNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nɛ mi 'bʉpʉ 'da di ąxtho ra Jesús 'bʉ di hocpa rá 'yɛ ran 'yohʉ. Nɛ nu'bʉ da nu di hocpi di yąp pʉya nguetho ra pa ran ts'äya a. ");
INSERT INTO otmNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pɛ nu ra Jesús bi 'yɛ̨mp'a ran 'yohʉ: ―Ndants'i, gam 'bähnʉ made i 'bʉh yʉ ją'i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nɛ nubʉya, bi 'yän'dʉ 'bʉpʉ nɛ bi 'yɛ̨mp'ʉ: ―Dami xijʉ ya 'bɛ'a xʉn ho da t'øt' 'bʉ ra pa ran ts'äya. Ha da t'øt'a n'da ran ho uague da t'øt'a n'da ran ts'o. Ha xʉn ho 'bʉ da yąnba rá te rá miją'iui n'da, uague xʉn ho 'bʉ da hyącpa rá te rá miją'iui n'da. Pɛ nu'ʉ hin'yʉ 'bɛ'a sä dí dąti. ");
INSERT INTO otmNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nu ra Jesús bi hyanman'ʉ yʉ ją'i bʉya nɛ bi zøt rá mbʉi nguetho hin'yʉ ran hocją'i ʉ. Nubʉya bi 'yɛ̨mp'a mi ʉ rá 'yɛ: ―Dami juąn ni 'yɛ. Nɛ 'bex bi juąn rá 'yɛ bʉya, bi gomanho. ");
INSERT INTO otmNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bi bøn yʉ fariseo bʉya nɛ in cuɛ. Bin yąhʉ mahøn'a ʉ yʉ́n sʉihʉ ngue mi tɛn ra Herodes, nɛ mí hon ʉ 'bɛpʉ dí hyo a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nu ra Jesús bi 'uegue bi mbähä yʉ́ xädi bʉ ja ra dądehe nɛ xʉn ngu yʉ ją'i mi 'bʉpʉ ra häi Galilea bi dɛnthoho. ");
INSERT INTO otmNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nɛ ʉ yʉ mɛngu bʉ ja ra häi Judea, nɛpʉ ra hnini Jerusalén, nɛpʉ ra häi Idumea, nɛpʉ 'danguadi ra Jordán, nɛpʉ ra xɛqui Tiro nɛ Sidón, bi 'yø ʉ 'bɛ'a gätho bi 'yøt'a ra Jesús. Janangue a gätho bi zøm bʉ mi 'bʉ a. ");
INSERT INTO otmNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Damin sähʉ, gui jomhbʉ n'da ra t'ʉmbosa nʉ ja ra dehe, bi 'yɛ̨mp'ʉ. Ngubʉ bi xifi nguetho i nu man'da man'da ní zøntho yʉ ją'i nɛ nu'bʉ bin dʉ bʉ yʉ ją'i da hyuxpʉ ja ra mbosa ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nguetho ya xí hoqui xʉn ngu yʉ hyɛ̨nni, janangue a din tønthoho ʉ yʉn zäman'ʉ in nde da bɛnba rá pahni ra Jesús ngue mi pą ʉ, høntho ga thärpa thoho rá pahni 'bex gue da yąngui, mi ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nɛ nu'ʉ min 'yohʉ ra zįthu bin dąnyahmu bʉ 'bʉh ra Jesús nɛ mbafi, ɛ̨n ʉ: ―Nu'i gue'e rá Ts'ʉnt'ʉ i Oją, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pɛ nu ra Jesús nts'ɛdi bi hɛcpa ʉ nguetho hingui ndepe gue'ʉ yʉ zįthu dí bą ʉ yʉ ją'i gue gue'a rá Ts'ʉnt'ʉ Oją a. ");
INSERT INTO otmNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","M'bɛjua bʉya bi guam bʉ ja ra nyuni a ra Jesús. Nubʉya bi zohn'dʉ 'da yʉ́ xädi nɛ nu'ʉ bi mba bʉ 'bʉh ra Jesús ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nɛ nubʉya bi huahn'dʉ 'dɛ'mayoho, bi zänni din 'yohʉ ngue da zä da mbɛhni da xih yʉ ją'i rám hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nɛ bi un yʉ́ ts'ɛdi di hoc yʉ hyɛ̨nni nɛ da hyøn a thi yʉ zįthu n'yohʉ 'da yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bi zänna ra Simón, nɛ bi zänbi dí huti ra Pedro a. ");
INSERT INTO otmNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nɛ ra Jacobo nɛ'a ra Xuua rán 'yohʉ na ra Jacobo. Gätho yoho yʉ́ ts'ʉnt'ʉ ra Zebedeo ya. Nɛ bi zänba yʉ́n sospathuhu Boanerges, i nde da ma tengu n'da ra ngäni. ");
INSERT INTO otmNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nɛ'a ra Andrés bi zänni, nɛ ra Felipe, nɛ ra Bartolomé, nɛ ra Mateo, nɛ ra Tomás, nɛ man'da ra Jacobo ngue rá ts'ʉnt'ʉ ra Alfeo, nɛ ra Tadeo, nɛ man'da ra Simón, t'ɛ̨mbi ra cananista. ");
INSERT INTO otmNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nɛ ra Judas Iscariote gue'a di dä a ra Jesús. Nɛ nu'bʉ mí gua'a bi un yʉ́ ts'ɛdi ʉ, bá ɛ̨h yʉ́ ngu. ");
INSERT INTO otmNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nɛ xø bi zøm bʉ xʉn ngu yʉ ją'i mahøn'a xø him mi pongui din sihmɛ ts'ʉ ra Jesús nɛ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nu'bʉ mí 'yø ʉ yʉ́ mɛni ra Jesús 'bɛ'a gätho i øt'a, ɛ̨mbi in gąt'i, nɛ bá ɛ̨ ʉ bi zøm bʉ 'bʉh ra Jesús i nde da zits'i. ");
INSERT INTO otmNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nɛ nu yʉ xänbate niją xpí 'yɛ̨ a Jerusalén, sä ɛ̨n ʉ n'youi ra zįthu ra Jesús, nɛ ɛ̨n ʉ nangue rá ts'ɛdi yʉ́ hmu ra zįthu gue'a ní zä i høn a thi yʉ zįthu ra Jesús, sä bi 'yɛ̨n ʉ yʉ xänbate niją. ");
INSERT INTO otmNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nu'bʉ mí bąh ra Jesús 'bɛ'a bi man ʉ, bi zon'dʉ bʉya nɛ bi xih yʉn t'uti da bądi hinga gue'a man ʉ. Bi 'yɛ̨mp'ʉ: ―Hin da zä a ra zįthu din sʉsɛhʉ yʉ́ minzįthuhʉ, nɛ xtí 'bɛtho rá ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tengu n'da ra ts'ʉt'abi bʉ ja ra hnini hingui sä da hyą rá ts'ɛdi 'bʉ din sʉsɛhʉ ʉ yʉ́ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nɛ ngutho n'da ra ngu 'darpʉ 'bʉhmbʉ yʉ́ ts'ʉnt'ʉ n'da ran 'yohʉ da guasɛ ʉ 'bʉ hinga 'dat'a im bɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngutho ʉ yʉ zįthu 'bʉ xtín sʉsɛhʉ yʉ́ hmu, xtan guasɛ ʉ 'bʉ hinga 'dat'a im bɛ̨n'ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nɛ xø bi xih man'da ran t'uti nangue 'bɛ'a bi 'yørpa ra zįthu, bi 'yɛ̨mbi: ―Njon da zä da yʉrpʉ ja rá ngu n'da ran 'yohʉ i ja rá ts'ɛdi gue'bʉ hinga m'bɛt'o da thu't'i. Pɛ nu'bʉ ya bi thu't'i, hingui hɛ̨i da thąspi 'bɛ'a gätho i pɛs' pʉya, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Pɛ majuąni dí xi ahʉ hønt'a go ma ts'oqui bi 'yøt' yʉ ją'i da mba ma punbi 'bʉ da hyon ra punbi, nɛ hønt'a go ma ts'ore bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pɛ nu'ʉ to'o im man ra ts'ore nangue rá Hogandąhi Oją njąm'bʉ da zä da mba ma punbi ʉ, da nu ran ʉnbi gätho yʉ pa maząi, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ngubʉ bi xih yʉ xänbate niją ra Jesús nguetho bi 'yɛ̨n'ʉ hinga gue'a rá ts'ɛdi rá Hogandąhi Oją in 'youi ra Jesús, ngue mi høn a thi yʉ zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nɛ nubʉya bá ɛ̨sɛ rá mbe ra Jesús nɛ yʉ́n 'yohʉ. Pɛ mí 'bätho bʉ thi nguetho him bi zä bi yʉt'a mbo. Nɛ bi xi ʉ 'bäpʉ mbo: ―Xihmi ts'ʉ ra Jesús ngue dín zohndähe ua thi, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nɛ nu'ʉ 'darpʉ mí huhmbʉ ra Jesús bi 'yɛ̨mp'ʉ bʉya: ―'Bäpʉ thi ni mbe nɛ nin 'yohʉ, i hon a i 'na. ");
INSERT INTO otmNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nu ra Jesús bʉya bi dąt'ʉ: ―Ga xi ahʉ te'o a ma mbe nɛ man 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Nɛ bi hyant'ʉ 'darpʉ huhmbʉ bʉya, nɛ bi 'yɛ̨na: ―'Bʉcua ya ma mbe, nɛ man 'yohʉ, nguetho hønt'a go te'o da 'yørpa rá pähä Oją, gue'a man 'yohʉ a, nɛ gue'a man ju a, nɛ gue a ma mbe a, bi 'yɛ̨mp 'bʉ mi dądi. ");
INSERT INTO otmNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nɛ xø bi xänba yʉ ją'i mahøn'a bʉ ja ra ndendądehe a ra Jesús. Nɛ ɛ̨mmɛ xʉn ngu yʉ ją'i bim pɛtihʉ bʉ. Janangue'a bi yʉrbʉ ja ra t'ʉmbosa bi dąn i ts'ʉ bʉ ja ra ndenthe. Nu yʉ ją'i bi gopʉ ndenthe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nu ra Jesús bʉya xʉn ngu yʉn t'uti bi xih yʉ ją'i 'bʉ mí xänbi, nɛ bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―'Yøhmbʉ ts'ʉ ran t'uti ga xi ahʉ ya. Nu'a n'da ra uąhi bi mba bá pon yʉ hmudä. ");
INSERT INTO otmNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nɛ bi zo 'da bʉ 'yu. Nubʉya bá ɛ̨h yʉ doja bi jua'a nts'a yʉ hmudä xí zo bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nu'ʉ mi'da yʉ hmudä bi zo bʉ ja yʉ ndaxnado nɛ ts'ʉtho ra häi bʉ. Janangue'a 'bex bi bøxa n'dihi. ");
INSERT INTO otmNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pɛ nu'bʉ mam bá pøx ra hyadi 'bex bi 'yot'ʉ nguetho hin hapʉ sä da mba yʉ́ 'yʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nu'ʉ mi'da bi zo bʉ ja yʉ dąpo, bi bøts'e pɛgue bi gom' yʉ dąpo, nɛ nte bi ndø'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pɛ nu'ʉ mi'da bʉya bi zo bʉ ja ra häi xʉn ho. Bi bøts'e nɛ bin te, nɛ bi ndøgue. Nu'ʉ 'da 'däte ma'dɛt'a bi ndøgue, nu'ʉ 'da hyąte, nu'ʉ 'da n'da ciɛnto bi ndøgue ngue n'da 'bäi, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nɛ xø bi 'yɛ̨mp'ʉ yʉ ją'i: ―Hønt'a go to'o ja yʉ́ zagu bi 'yø a dá ma, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nu'bʉ mi 'bʉsɛhʉ 'dɛ'ma yoho yʉ́ xädi ra Jesús nɛ'ʉ mi'da yʉ́ 'yɛ̨c'yɛi, bi xifi da xi ʉ 'bɛ'a na mbøn a ran t'uti bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nu ra Jesús bi 'yɛ̨mp'ʉ bʉya: ―Gue'ahʉ bi ja ahʉ gui pąhmbʉ a him mam fądi mam 'bɛt'o ngue 'bɛpʉ ní manda rá ts'ɛdi Oją. Pɛ nu'ʉ yʉ ją'i thoho gue'ʉ da sänba yʉn t'uti, ");
INSERT INTO otmNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","madague da nu pɛ hin da 'yørpa masu 'bɛ'a da nu, nɛ madague da 'yøde pɛ hin da bądi 'bɛ'a ní mba a, nɛ hin da bɛ̨ni di päh yʉ́ mbʉi ngue da hyon ra punbi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nɛ xø bi 'yɛ̨mp'ʉ mahøn'a: ―Nu'bʉ hin guí pąhmbʉ 'bɛ'a na mbøn'a ran t'uti dá mangä, ha da zä gui pąhmbʉ gätho mi'da ga xi ahʉ 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nu'a na mbøn'a dá mangä, nu'a ra uąhi que'a bá man rám hman Oją hønbʉ go hapʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Guehya bi zo bʉ ja ra 'yu na mbøni bi 'yømanho rám hman Oją ya. Pɛ nu ra zįthu 'bex bi japi bi pumbɛ̨ni a ram hma bi sifi. ");
INSERT INTO otmNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ximangutya bi zo bʉ ja yʉ ndaxnado na mbøni bi 'yøh ram hma nɛ bin johya. ");
INSERT INTO otmNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pɛgue hinga gätho rá mbʉi bi bɛ̨ni. Janangue'a nu'bʉ bi nu yʉn ʉcpi nɛ yʉn ʉnbi nangue rám hman Oją him bi hyät'i, 'bex gue bi zu nɛ bi 'uegue. ");
INSERT INTO otmNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nɛ nuya bi zo bʉ ja ra dąpo na mbøni bi 'yømanho ram hma ");
INSERT INTO otmNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pɛ ɛ̨mmɛ di ho ra ximhäi nɛ ra mbɛti i hät'i, nɛ di ho da 'yøt' yʉ́ pähä zɛhɛ. Tengu'bʉ bi gomba ram hma, nɛ hin di japi din te yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pɛ nuya bi zo bʉ ja ra häi xʉn ho, na mbøni bi 'yømanho rám hman Oją, bi hyąni, nɛ bin te yʉ́ mbʉi xʉn ho, nɛ bi xąnt'a ram hma xʉn ho, tengutho yʉ hmudä, gue bi ndø'a 'däte ma'dɛt'a ʉ 'da, nɛ hyąte ʉ 'da, nɛ n'da ciɛnto ʉ 'da, bi 'yɛ̨mp'ʉ yʉ́ xädi 'bʉ mi xifi 'bɛ'a na mbøn'a ran t'uti bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Nu'a mam hmangä nts'änni gätho yʉ ją'i da 'yøde, tengu n'da ra nyot'i nts'änni di yot'i gätho bʉ mbo ra ngu, hingan ts'änni da mba ma cʉ't'i bʉ ja ra 'bihuanza o ra 'bit'ots'i. ");
INSERT INTO otmNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nguetho gätho 'bɛ'a him mam fądi da zøni da fądi, nɛ gätho 'bɛ'a him midí nɛqui da zøni da hnu. ");
INSERT INTO otmNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hønt'a go to'o ja yʉ́ zagu bi 'yø a dá ma. ");
INSERT INTO otmNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nɛ nu'a di jamansu a i øde da bądi xʉn ho nɛ Oją di japi man'da xʉn ngu da zøni da bądi. Pɛ nu'a hin ɛ di jamansu a i øde, pɛ nɛ'a zi ts'ʉ mi pądi dim 'bɛdi, nɛ tengu ni t'ɛni gnán ɛmhbʉ gue'a dí t'ɛn'nahʉ, nɛ man'da mbongui thoho din 'da ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Din ja ahʉ tengu ram hma i ɛ̨na: “Nu'a xʉn ngu i ja man'da xʉn ngu din t'unni pɛ nu'a ts'ʉtho i ja man'da da thąnba a.” ");
INSERT INTO otmNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Nu ra Jesús bi 'yɛ̨mp'ʉ mahøn'a: ―Nuya di manda ua rá ts'ɛdi Oją madague'bʉ hin di nɛqui, tengu thoho n'da ra hmudä 'bʉ bi du a n'da ran 'yohʉ, madague'bʉ hingui nu hague ám bøts'e pɛgue i pądi da bøts'e, nte im bɛ̨ntho. ");
INSERT INTO otmNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nguetho nu'a ra häi dí tesɛ yʉ thuhu a. Nu'bʉ bi mbʉdi bi bøts'e, yʉ paxi thoho, m'bɛjua bʉya da ndøh yʉ́ dąxi, nɛ nubʉya din thą ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nɛ nu ran 'yohʉ bʉya da xoqui nguetho bi zøn ra ora da 'bɛ'ts'i, bi 'yɛ̨n a ra Jesús. In jabʉ rá ts'ɛdi Oją ngue di manda ua nɛ njongui nu hague na te. ");
INSERT INTO otmNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nɛ man'da ran t'uti bi xih yʉ́ xädi ra Jesús mahøn'a, nɛ bi 'yɛ̨mp'ʉ: ―'Bɛpʉ dá bɛ̨mhbʉ hague di manda ua rá ts'ɛdi Oją. Ga xi ahʉ n'da ran t'uti nangue'a. ");
INSERT INTO otmNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","In ja tengu n'da rá hmudä ra mostaza i pa m'boni, nɛ ɛ̨mmɛ zicuɛ tho, ɛ̨mmɛ man'da zicuɛ xinda gue mi'da yʉ hmudä, pɛ man'da i te xʉn ngu yʉ́ 'yɛ, xinda gue gä mi'da yʉ paxi nɛ xøgue sä da 'yøt' yʉ́ 'bafi yʉ doja bʉ ja yʉ́ xaha. Njabʉ rá ts'ɛdi Oją bʉ ni nɛqui ngue di manda ua, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nɛ xʉn ngu mi'da yʉn t'uti bi xänba yʉ ją'i a ra Jesús 'bʉ mi xänbi tengu ya i hmangua, pɛ hønt'ʉ hingui hɛ̨i bʉ dá fądi bi xifi. ");
INSERT INTO otmNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nɛ nte bi xih mi'da yʉm hma, hønt'ʉ yʉn t'uti bi xifi. Pɛ nu'bʉ mi 'bʉsɛhʉ yʉ́ xädi bi xih pʉya 'bɛ'a na mbøn'ʉ yʉn t'uti bi mam bʉ 'bʉh yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nu'bʉ mín de bʉya nu ra Jesús bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Nuya ga thohmbʉ nʉ 'danguadi ra dądehe, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nɛ nubʉya bi xih yʉ ją'i da mbeng bʉ yʉ́ ngu. Nu yʉ́ xädi bʉya bi 'yon a ra mbosa mi huhʉ ra Jesús, bi mbähä bʉya. Nɛ xʉn ngu mi'da yʉ ją'i bi dɛnni ngue bi hyusɛ yʉ́ mbosa ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nɛ nu'bʉ ya i 'yo bʉ ja ra dehe nɛ nts'ɛdi ran dąhi bin ja, nɛ bi donts' ra dehe ra mbosa nɛ mi ts'ʉtho xtán yudi. ");
INSERT INTO otmNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pɛ nu ra Jesús mi hunh ra huhni, nɛ mi ąpʉ ja ra mbosa. Nu yʉ́ xädi bi 'yä ra Jesús nɛ bi 'yɛ̨mbi: ―Xänbate i, ha nte guím bɛ̨ni nɛ nde ga tuhʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bi ndants'a ra Jesús bʉya nɛ bi 'yɛ̨mp'a ran dąhi nɛ a ra dehe: ―Daman hɛ̨, bi 'yɛ̨mbi. 'Bex gue bin hɛ̨ ran dąhi nɛ ra dehe bʉya him mam bi 'yąni. ");
INSERT INTO otmNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nubʉya, bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Guín suhʉ nguetho ts'ʉtho guí ɛ̨c'yɛigahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nu yʉ́ xädi bʉya bi zu a ra hmu, nɛ bi hyonya thoho a bin ja. Bin 'yɛ̨mzɛhɛ n'da ngu n'da ʉ: ―'Bɛ'a di 'yɛ̨t'ui na ran 'yohʉ, nɛ ya 'bex gue in hɛ̨ a ran dąhi nɛ ra dehe di hɛcpi. ");
INSERT INTO otmNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nubʉya nu ra Jesús nɛ yʉ́ xädi bi zøm bʉ 'danguadi ra dądehe nubʉ ja ra häi Gadara. ");
INSERT INTO otmNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Nɛ mi 'bʉpʉ n'da ran 'yohʉ min 'youi yʉ zįthu. Nu'a mi ząm bʉ ja ran 'yägui, nɛ njo'o to'o mi sä da ząmmi nguetho gä i xɛcthoho yʉ cadena mi pa nthąt'i. Xʉn ngu yʉ nįdi bi thurpa yʉ́ 'yɛ nɛ yʉ́ gua nangue yʉ cadena, pɛ gätho i xɛcthoho. Njon mi sä di hɛcpi. Gätho ra pa nɛ ra xui mi mbapʉ ja ra dąpo o guepʉ ja ran 'yägui, nɛ midi ʉnba zɛhɛ nguetho mi hɛzɛhɛ rá ją'i nangue yʉ do. Nu'bʉ mí bøm bʉ ja ra mbosa a ra Jesús nɛ yʉ́ xädi, 'bex bá ɛ̨ a ran 'yohʉ bin c'athʉ, bí 'yɛ̨pʉ ja ran 'yägui, bin dąnyahmu bʉ 'bäh ra Jesús, bi dąnde, ");
INSERT INTO otmNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","nɛ nts'ɛdi mbafi, bi 'yɛ̨na: ―'Bɛ'a guí nde gui 'yørcahe grá Jesús, rá Ts'ʉnt'ʉ i Oją mahɛ̨ts'i. Nuya dí ä a ra mate hin gui ʉngahe, ");
INSERT INTO otmNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","bi 'yɛ̨n'ʉ yʉ zįthu 'bʉ mi sifi da bøm bʉ rá mbʉi ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nɛ nubʉya nu ra Jesús bi 'yän'nʉ yʉ zįthu: ―'Bɛ'a ní thuhu, bi 'yɛ̨mbi. ―Ma thuhu “N'dan nɛts'igähe” nɛ ɛ̨mmɛ xʉn ngu gähe, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","12","Nɛ nts'ɛdi dí ä a ra mate gue'bʉ ga pømhbe hin gui pɛngahe bʉ n'danni i ja yʉ häi, dami 'yørcahe ra mate gui pɛngahe nʉ 'bʉh yʉ ts'ʉdi ga cʉthe nʉ, bi 'yɛ̨n'ʉ. Nguetho hinga yatho mí 'yo ʉ yʉ ts'ʉdi xʉn ngu, mi sapaxi bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nu ra Jesús ya bi un ran t'ɛ̨di da yʉrpʉ 'bʉh yʉ ts'ʉdi. Nu'bʉ mí yʉrpʉ ya 'bex bán tih yʉ ts'ʉdi bá cąpʉ ja ra nguani ʉ 'bex bi yʉpʉ ja ra dehe ʉ, nɛ gä bi du bʉ ʉ bʉya. Mbɛ yo mahuąhi i jua ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nu ʉ yʉn 'yohʉ midi jamansu yʉ ts'ʉdi, 'bex bi 'da 'bʉ min nu 'bɛ'a bi 'yøt'ʉ yʉ ts'ʉdi. Bi mba bá mam bʉ ja ra hnini nɛpʉ huąhi a bin ja. 'Bex bi mba yʉ ją'i bʉya da nusɛ ʉ 'bɛ'a bi man ʉ yʉ́ mbädi yʉ ts'ʉdi. ");
INSERT INTO otmNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nu'bʉ mí zøm bʉ, bi nu i hupʉ a ran 'yohʉ madí ʉnba ra zįthu, ya xí zä nɛ i he rá zi pahni. Ɛ̨mmɛ bi mbidi yʉ ją'i bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nu'ʉ xí nu yʉ ts'ʉdi, xø bi xifi xʉn ho yʉ ją'i mahøn'a 'bɛ'a xín ja. ");
INSERT INTO otmNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nɛ nubʉya, nu yʉ mɛngu bʉ ɛ̨mmɛ bi 'yäp ra mate ngue 'bex gue da bøn a ra Jesús bʉ ja yʉ́ häi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bi mba da ndex ra mbosa a ra Jesús bʉya. Nɛ nu'a ran 'yohʉ xí ʉnba ra zįthu ɛ̨mmɛ i nde da dɛn'na ra Jesús gue 'darpʉ din 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pɛ nu ra Jesús him bi un ran t'ɛ̨di nɛ bi hɛcpi. ―Ni mba bʉ ni ngu, nɛ gui xi ʉ nim 'bʉihʉ ran ho bi 'yøt'a Oją ra Hmu ngue bi huɛ̨c'a i, bi 'yɛ̨mp'a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nu'a min 'youi ra zįthu bʉya, bi mba rá ngu. Bi dʉ'mi bi mam bʉ gätho ra xɛqui Decápolis 'bɛ'a xí 'yørpa ra Jesús. Nɛ gätho ʉ bi xifi bi hyonya thoho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nɛ nu'bʉ ya mi zøn ra Jesús bʉ ná 'danguadi ra dądehe, ɛ̨mmɛ xʉn ngu yʉ ją'i bim pɛti bʉ ndenthe mahøn'a guepʉ bin säya ra mbosa. ");
INSERT INTO otmNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bi zø'a n'da rá ngʉrbi ra niją i Jairo a, bin dąnyahmu bʉ ja rá gua ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nɛ ɛ̨mmɛ bi 'yäp ra mate, bi 'yɛ̨mbi: ―'Yørqui ts'ʉ ra mate ga mbähä ba cäx ni 'yɛ ma t'įxu nguetho ɛ̨mmɛi, janangue'a da yąni nɛ hin da du, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nu ra Jesús bi mbɛ bʉya, nɛ xʉn ngu yʉ ją'i bi dɛn'ndʉ, xøgue bin dʉ bʉ ni mba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nɛ bi zʉpʉ 'yu n'da ra xisu ná 'dɛ'mayon jɛya mi hɛ̨mb ra mbɛji. ");
INSERT INTO otmNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɛ̨mmɛ xí nu ran ʉnbi nangue xʉn ngu yʉ 'yøthebate xí 'yøthe. Xi juadi gätho rá mbɛti mi ja, nɛ xingui ts'ʉ bi dįts'i, xøgue man'da ɛ̨mmɛi. ");
INSERT INTO otmNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pɛ nuya i hon a ra Jesús nguetho xí 'yø'am man yʉ ją'i ngue di hoqui hønt'a go 'bɛ'a man ʉ. Janangue nu'bʉ mi zʉdi 'bex bi yʉt'i nde bʉ ní mba ʉ, bi därpa rá xʉthapahni ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nguetho mí ɛ̨nsɛ ra xisu, “Høntho ga thärpa rá pahni, ya da yąngui,” mi ɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nɛ nu'bʉ mi därpa rá pahni ra Jesús 'bex bin hɛ̨ a rá mbɛji mí hɛ̨mb bʉya. 'Bex bi bą a ra xisu ngue ya bi zä xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","'Bex bi bąh ra Jesús ngue bi hoc'a n'da ra ją'i rá ts'ɛdi 'bʉ mí därpa rá pahni. Janangue bi nyɛ̨'a ra Jesús, bi hyɛ̨t'ʉ yʉ ją'i min 'yohʉ nɛ bi 'yɛ̨na: ―To'o bi därca ma pahni, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nu yʉ́ xädi bʉya bi 'yɛ̨mbi: ―Guín nuhma ɛ̨mmɛ dʉ ua yʉ ją'i, “To'o bi därca ma pahni,” nɛ guí ɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nu ra Jesús i tø'mi da mansɛ to'o xí därpa rá pahni. ");
INSERT INTO otmNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nɛ nu ra xisu bʉya, bin su nɛ di fɛt'i nguetho pą a xí t'ørpe. Nɛ bi mba bʉ 'bäh ra Jesús bin dąnyahmu bʉ ja rá hmi nɛ bi xifi gätho 'bɛ'a xí 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nu ra Jesús bʉya bi 'yɛ̨mbi: ―Nu'i grá zi xisu, bi zä i nguetho gá 'yɛ̨c'yɛigui. Ni mba da hyu ni mbʉi, him man di ʉn'a a gmi hɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Gätho na yąui a ra xisu 'bex bi zøpʉ mi'da yʉ ją'i bí 'yɛ̨pʉ ja rá ngu a ra Jairo, bi t'ɛ̨mp'a ra Jairo: ―Nu'a ni t'įxu ya bi du. Säti thoho man'da gadi pah na ra xänbate. ");
INSERT INTO otmNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pɛ nu ra Jesús 'bʉ mí 'yø a bi man'ʉ, bi 'yɛ̨mp'a ra Jairo bʉya: ―O di tu ni mbʉi, høntho gui 'yɛc'yɛi ngue majuąni i ja ma ts'ɛdi, bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Guehma bi thoh pʉya nɛ njom bi japi da dɛnni. Hønt'a ra Pedro, nɛ ra Jacobo nɛ ra Xuua rán 'yohʉ ra Jacobo, bi xifi da mbähä bʉ rá ngu ra Jairo. ");
INSERT INTO otmNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nu'bʉ mi zøm bʉ ja rá ngun a ra Jairo bʉya, bi nu ngue i zon'ʉ yʉ ją'i 'bʉpʉ, nɛ ɛ̨mmɛ di mbahni na ts'oni. ");
INSERT INTO otmNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bi yʉrpʉ mbo ra Jesús bʉya, bi 'yɛ̨mp'ʉ 'bʉpʉ: ―Hanja ɛ̨mmɛ gadi hįhʉ na ts'oni. Nuna ra hmute hingui tu pɛgue i ąha. ");
INSERT INTO otmNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nu'bʉ mi 'yøh yʉ ją'i 'bɛ'a bi man a, bi den thoho bʉya. Nu ra Jesús bʉya, bi 'yɛ̨mp'ʉ yʉ ją'i: ―Dami pømhbʉ thi, bi 'yɛ̨mbi. Hønt'a rá ta nɛ'a rá mbe ra hmute xí du nɛ yʉ́ xädi, bi yʉthʉ ra Jesús bʉ 'bɛn a ra hmute. ");
INSERT INTO otmNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nu'a ra Jesús bʉya bi bɛnba rá 'yɛ a ra hmute nɛ bi 'yɛ̨mbi: ―Talita cumi, bi 'yɛ̨mbi. I nde da ma: “Nu'i grá hmute dí xi i, dami ndants'i.” ");
INSERT INTO otmNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nu'a ra hmute bʉya 'bex bi ndants'i nɛ bin 'yo. 'Dɛ'mayon jɛya mi pɛ'ts'a. Nu'ʉ bi yʉthʉ mbo bi hyonya thoho. ");
INSERT INTO otmNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nu'a ra Jesús bʉya nts'ɛdi bi 'yɛ̨mp'ʉ: ―Njon gui xihmbʉ 'bɛ'a dá øt'ä, bi 'yɛ̨mp'ʉ. Nɛ nubʉya bi 'yɛ̨mp'a ra Jairo: ―Dami 'uįn na ni t'įxu ya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bi bøm bʉ ra Jesús bʉya, bi mba bʉ ja rá hnini zɛhɛ Nazaret. Bi mbähä yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nɛ nu'a ra pa ran ts'äya, bi mbähä yʉ́ xädi bʉ ja ra niją. Nu ra Jesús bʉya bi xänba bʉ yʉ ją'i. Nu'bʉ mi 'yøh yʉ ją'i a bi man'a ra Jesús, bi hyonya thoho nɛ din 'yɛ̨mzɛhɛ ʉ: ―'Bɛ'a nin xädi im man na. 'Bɛ'a ni ts'ɛdi i ja na, ngue i sä i øt' yʉn t'øt'e mixte na. ");
INSERT INTO otmNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ha hinga guehna ra yaxi na, rá ts'ʉnt'ʉ ra María. Nɛ yʉ́n 'yohʉ ra Jacobo, nɛ ra José, nɛ ra Judas, nɛ ra Simón, nɛ ʉ yʉ́n ju dí 'bʉhmbʉ ua, bi 'yɛ̨n ʉ. Nɛ bi ʉ't' yʉ́ mbʉi zɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Janangue'a nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Gätho yʉ́ pøngahyą Oją i hnumansu, pɛ hønbʉ ja rá häizɛhɛ nɛpʉ 'bʉh yʉ́ mɛni, nɛpʉ ja rá ngusɛ hingui hnumansu bʉ, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nɛ hingui ngu yʉn t'øt'e bi 'yørpʉ ngue xtá 'yut rá ts'ɛdi. Hønt'ʉ zi yoho yʉn zäman'ʉ bi gäx rá 'yɛ bi japi bi yąn'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nɛ bi hyonya thoho a ra Jesús nguetho him bi 'yɛ̨c'yɛi ʉ ngue i ja rá ts'ɛdi ʉ yʉ́ mɛnguhʉ. Nɛ nubʉya bi mba bʉ ja yʉ t'ʉhnihni jombʉ Nazaret, nɛ bi xänba bʉ ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","M'bɛjua bʉya bi xi ʉ 'dɛ'mayoho yʉ́ xädi ngue da mba bʉ ja yʉ hnini. Nɛ 'da i yoho bi zänni, nɛ bi un yʉ́ ts'ɛdi da hyøn'a thi yʉ zįthu in 'yohʉ ʉ 'da yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Nɛ bi xi ʉ nte da hyąx 'bʉ bi mba ʉ. Hønt'a n'da ra tøhø da hyąts'i n'da ngu n'da ʉ. Nɛ hønt'ʉ yʉ thįxfani da 'yʉt'i. Xíng yʉn ju'døzą, xíng yʉn zɛdi da hyąts'i, xing ra mbɛti, nɛ xín da gąx ʉ yojo'ts'i yʉ́ pahni. ");
INSERT INTO otmNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nɛ man'da bi 'yɛ̨mp'ʉ: ―Hønbʉ go hapʉ da mba ma säya ahʉ 'bʉ gá sømhbʉ bʉ ja yʉ hnini, gam 'bʉhmbʉ bʉ gue'bʉ go gá nɛxhʉ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nɛ nubʉ hapʉ gui sømhbʉ ngue hin da zin ahʉ nɛ hin da 'yømanho a guí mamhbʉ, dami pømhbʉ bʉ, dami huąjʉ ra häi ja ni xįnguahʉ, ra hmɛpya ngue gui sohmbʉ bʉ ʉ. Nɛ majuąni dí xi ahʉ, nu'a ra hnini hin da zin ahʉ, man'da xʉn ngu ran ʉnbi da nu a 'bʉ bi zøn ra pa ran juąnbi, xinda gue'a ra hnini Sodoma nɛ ra hnini Gomorra, bi 'yɛ̨mp'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nɛ bi bøm bʉ 'dɛ'mayoho bʉya, bi mba. Hønbʉ go hapʉ bin 'yo bi xih yʉ ją'i di päh yʉ́n 'yomfɛ̨ni nangue yʉ ts'oqui bi 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nɛ bi hyøn a thi xʉn ngu yʉ zįthu mín 'yohʉ 'da yʉ ją'i nɛ xʉn ngu yʉn zäman'ʉ bi gox ra aceite nɛ bi japi bi zä ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mí ø a ra ts'ʉt'abi Herodes ngue mí man yʉ ją'i 'bɛ'a mí øt'a ra Jesús bʉ mí 'yo, nɛ bi 'yɛ̨mb bʉya: ―Masque gue'a ra Xuua Nxixyą a bi dąmbɛ̨ni, janangue'a i øt yʉn t'øt'e ngue i uh rá ts'ɛdi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pɛ nu'ʉ 'da yʉ ją'i, mi ɛ̨na: ―Ra Elías a ra Jesús. Nɛ nu'ʉ 'da i ɛ̨na: ―Ra pøngahyą tengu mi 'bʉh maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pɛ nu ra Herodes 'dat'a im ma, bi 'yɛ̨na: ―Gue'a ra Xuua Nxixyą a ngue dá manda da ts'ɛcpa rá 'yʉga, masque bi dąmbɛ̨ni, bi 'yɛ̨n a ra Herodes. ");
INSERT INTO otmNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nguetho guesɛ ra Herodes bi mbɛnh'dʉ bá bɛnt ra Xuua, bi du't'i nɛ bi got'a fädi. Nguetho in cuɛ ra Herodes 'bʉ mí t'ɛ̨mbi hingui ho a bi 'yøt'e ngue xí zin a rá 'bɛpo. Nɛ nu'bʉ mí zin'a ra xisu, mi 'bʉhmi a ra Felipe. Nɛ nu'a ra Felipe, rán 'yohʉ zɛhɛ a ra Herodes. Nɛ nu ra xisu i Herodías a. Nɛ gue'a ra Xuua Nxixyą bin yąui ra Herodes, bi xifi hingui ho a bi 'yøt'e. Him bi 'yømanho ra Herodes bʉya, janangue bi manda dí cot'a fädi ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nɛ a ra Herodías bin cuɛ nɛ ɛ̨mmɛ honi 'bɛpʉ dí hyo a ra Xuua. Pɛ him 'bex bi zä bi hyo. ");
INSERT INTO otmNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nguetho nu ra Herodes mi pądi ra hocją'i a ra Xuua, nɛ bi xi ʉ yʉ mbängoxthi njon da japi da yʉrpʉ ngue di ʉnba ra Xuua. Nɛ nu ra Herodes, ja'bʉ di manda bá ts'inba ra Xuua ngue i nde da 'yø i ts'ʉ rám hman ra Xuua. Nɛ bi 'yømanho tho madague'bʉ hinga gätho i pądi 'bɛ'a nam bøn'a i man ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nu'bʉ mi zøn ra pa rá ngopa ra Herodes, nu ra Herodías bʉya bi dįni 'bɛpʉ dí hyo ra Xuua bʉya. Bi 'yøt'a n'da ra dąnsihmɛ ra Herodes bá si yʉ́m fäts'ihʉ, nɛ yʉ́ hmudofʉi nɛ'ʉ yʉ ngʉrpi bʉ ja ra häi Galilea. ");
INSERT INTO otmNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nu'bʉ min sihmɛ ʉ bi yʉrpʉ rá t'įxu ra Herodías, bin nɛsɛ a ra hmute. Nu ra Herodes nɛ ʉ gä mi huhmbʉ bʉ ɛ̨mmɛ bi numanhop rán hnɛi ra hmute. ―Nuya gui 'yäqui 'bɛ'a guí nde gui 'yäqui, nugä ga 'da i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nɛ xø bi 'yɛ̨mbi: ―'Yɛ̨c'yɛi Oją majuąni ga 'da i 'bɛ'a gui 'yäqui madague a gui 'yäc made gätho 'bɛ'a dí pɛ'ts'ä, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nu'a ra hmute bʉya bi bøni nɛ bi 'yän'na rá mbe ngue ra Herodías, bi 'yɛ̨mbi: ―'Bɛ'a sä ga äpi, mbe. Nu'a rá mbe bʉya bi 'yɛ̨mbi: ―'Yäp'a rá yą ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bi mbenga n'dihi ra hmute bʉya bi 'yɛ̨mp'a ra Herodes: ―Dí nde 'bexque guehya gui 'dac'a rá yą ra Xuua Nxixyą, gui cärca ra mbohi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nu ra Herodes bʉya bi du rá mbʉi 'bʉ mi 'yø a bi man a ra hmute, pɛ hingui sä 'bɛ'a da mam bʉya nguetho hupʉ ja ran sihmɛ ʉ xí 'yøde 'bɛ'a bim ma ngue ya xi ma majuąni di unni 'bɛ'a da t'äpi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Janangue a guehma bi mbɛnhna n'da ra dofʉi bá hąnba rá yą ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nu'a ra dofʉi bʉya bi mba bá sɛcpa rá yą ra Xuua nubʉ ja ra fädi nɛ bá cät'a n'da ra mbohi, bi unna ra hmute bʉya. Nu ra hmute bʉya, bi unna rá mbe a rá yą ra Xuua. Nɛ gue'a bin ja 'bʉ mi du ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nu'bʉ mí 'yøh yʉ́ xädi ra Xuua ngue bi ts'ɛcpa rá yą, bá ɛ̨ ʉ, bi duspa rá ngøc'yɛi nɛ bi mba bi 'yäpʉ ja ran 'yägui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nu'bʉ jam bá penc ʉ yʉ́ xädi a ra Jesús, bi xifi 'bɛ'a gätho xi 'yørpʉ bin 'yo, nɛ bi ma 'bɛ'a gätho bi mam bʉ 'bʉh yʉ ją'i 'bʉ mi xih rám hman Oją ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nu ra Jesús bi 'yɛ̨mp'ʉ: ―Ga mbähä ts'ʉ nʉ n'danni ngue dan säyahʉ ts'ʉ nʉ, xøhma guí yähmbʉ, bi 'yɛ̨mp'ʉ. Nguetho xʉn ngu yʉ ją'i i søm bʉ, ní mba nɛ ní 'yɛ̨hɛ, nɛ xíngui ts'ʉ im bongui din sihmɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Janangue a bi hyu ra mbosa ʉ im bɛ̨ni da zøm bʉ ma'ueni ʉ guepʉ da zä dim 'bʉsɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pɛ xʉn ngu mi'da yʉ ją'i bi hyant'a ra mbosa bʉ ni mba nɛ bi bądi i hu bʉ ra Jesús. Nɛ bá nɛxpʉ ja yʉ́ hnini ʉ, nɛ ɛ̨mmɛ bin ti ʉ nɛ 'yogua thoho nɛ m'bɛt'o bi zøm bʉ da zøn'a ra mbosa. ");
INSERT INTO otmNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nu'bʉ mi gąh ra mbosa ra Jesús nɛ yʉ́ xädi, bi nu xʉn ngu yʉ ją'i ya xí zøm bʉ, nɛ bi huɛ̨c'ʉ ngue in ja tengu yʉ dɛ'yo njo'o di jamansu. Nɛ 'bex bi dʉ'mi bi xih yʉ ją'i rám hman ra Jesús mahøn'a asta gue'bʉ go mín de. ");
INSERT INTO otmNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Nu'bʉ mín de bʉya bi t'ɛ̨mp'a ra Jesús: ―Ɛ̨mmɛ bin de ya, nɛ hinga nan sihmɛ yʉ ją'i, dami pɛnpʉ ja yʉ t'ʉhnini ya da dän yʉ hmɛ bʉ nguetho ma'ueni ua nɛ hin'yʉ 'bɛ'a da zi, bi 'yɛ̨n'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pɛ nu'a ra Jesús bi 'yɛ̨na: ―Gue'ahʉ gui 'uįmhbʉ yʉ ją'i, bi 'yɛ̨mbi. Nɛ bi 'yɛ̨n'ʉ yʉ́ xädi: ―Pɛ ha guí ɛ̨nje gua tämhbe yociɛnto ra hmɛ ngue ga unhde yʉ ją'i da zi, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nu ra Jesús bʉya bi 'yɛ̨mp'ʉ: ―Bá nuhʉ bʉ hangu yʉ hmɛ ja bʉ. Nu'bʉ mí bądi, bi 'yɛ̨mbi: ―Cʉt'a mhmɛ nɛ yoho yʉ huą ja ua, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nɛ bi xih pʉya: ―Dami xihmbʉ yʉ ją'i din säya nʉ i ja yʉ 'bot'ɛi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nɛ 'darpʉ bi hyu ʉ n'da ciento, nɛ 'darpʉ bi hyu ʉ mi yote ma 'dɛt'a, nɛ njabʉ bi 'yøt'e gätho ʉ mi'da. ");
INSERT INTO otmNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nu'bʉ mi gʉn'ʉ cʉt'a yʉ hmɛ nɛ ʉ yoho yʉ huą ra Jesús, bi ndøs mahɛ̨ts'i, bi 'yäp rán jąpi Oją nɛ bi xɛn'ʉ yʉ hmɛ. Nɛ ʉ yʉ huą bʉya. Nubʉya bi un'dʉ yʉ́ xädi di darpa yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gätho bin sihmɛ ʉ 'bʉpʉ nɛ bin niyą xʉn ho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nɛ nu'bʉ mi jua'a bi pɛt'ʉ bi bongui, 'dɛ'mayo 'bøts'e bi yudi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nɛ nu'ʉ bin sihmɛ cʉt'a mahuąhi ma 'yohʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Nu ra Jesús bʉya bi xih yʉ́ xädi m'bɛt'o da mba ʉ da zøm bʉ ra hnini Betsaida, nɛ bi yʉt'a n'dihi bʉ ja ra mbosa ʉ bʉya. Nu ra Jesús him 'bex gue bi mba nɛ nu'bʉ min 'yɛ̨hmbʉ gätho yʉ ją'i, bi ndexpʉ ja ra nyuni bin yąui Oją bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nu'bʉ min xui, ya i 'yo bʉ ra mbosa bʉ made ra dehe. Nu ra Jesús mi 'bʉtho bʉ bán ts'ogui. ");
INSERT INTO otmNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nɛ nu'bʉ mí hyant'ʉ 'bɛ'a øt'ʉ yʉ́ xädi, bi nu ngue xʉn hɛ̨i bʉ ni 'yon yʉ́ mbosa nguetho di costa'a ran dąhi a ra mbosa. Nɛ nu'bʉ maguembʉ da hyax pʉya bá ɛ̨h ra Jesús bʉ ní mba yʉ́ xädi, ba 'yo maxøts'e ra dehe. Nɛ nu'bʉ mi zʉdi ɛ̨na da mi'ts'a ra mbosa. ");
INSERT INTO otmNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nu'ʉ yʉ́ xädi 'bʉ mi nu bi bɛ̨n ʉ: “N'da ra du i mba bʉ,” ɛ̨n'ʉ. Nɛ ɛ̨mmɛ bi mba ʉ nguetho bin su. Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Guecä o te guím bɛ̨mhbʉ. Damin johyahʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nɛ bi ndexpʉ ja ra mbosa bʉya. 'Bex bin hɛ̨ ran dąhi, nɛ ɛ̨mmɛ bi hyonya thoho yʉ́ xädi 'bʉ mi nu 'yo maxøts'e ra dehe ra Jesús, nɛ bin hɛ̨ n'dihi ran dąhi. ");
INSERT INTO otmNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bi hyonya thoho nguetho him bi bɛ̨ni 'bɛ'a bi nu 'bʉ mi 'uįn'i cʉt'a mahuąhi yʉn 'yohʉ bʉ ndenthe, nguetho hingana pądi xʉn ho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nɛ bi zøm bʉ 'danguadi ra dądehe bʉya, nubʉ ra häi Genesaret, bi zopʉ yʉ́ mbosa. ");
INSERT INTO otmNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nu'bʉ mi gąpʉ ja ra mbosa, gätho yʉ ją'i bi bądi gue gue'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nɛ nu yʉ ją'i bʉya 'bex bi mba bá si yʉ hyɛ̨nni, bi zixpʉ da thoh ra Jesús. Mi oxpʉ ja yʉ́ 'beza 'da, hønbʉ go hapʉ ní nɛts'i. Nɛ nu'bʉ mi thopʉ ra Jesús bʉ ja yʉ́ häi ʉ, ");
INSERT INTO otmNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","hønbʉ go hapʉ bi thogui, o gue yʉ t'ʉhnini o gue yʉ dąhnini, o guepʉ ma'ueni yʉ hnini, ya xí 'bom bʉ yʉn zäman'ʉ. Nɛ gätho bʉ bi thogui bi si a ra Jesús: “Mada hønt'a ni pahni ga thät'i i,” bi t'ɛ̨mbi. Nɛ hønt'a go to'o bi därpa rá nyąmpahni 'bex bi zä bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nɛ bi nɛxpʉ Jerusalén 'da yʉ fariseo nɛ yʉ xänbate niją, bi zøm bʉ mi 'bʉh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nɛ bi nu ʉ 'da yʉ́ xädi ra Jesús i sihmɛ nɛ hin nin xʉ'yɛ tengu rán sʉ'yɛ bi zänzɛhɛ yʉ́n t'ɛ̨tizɛhɛ ʉ. Nɛ bi 'yɛ̨mbi øt ra ts'oqui ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nguetho nu'ʉ yʉ fariseo nɛ gätho mi'da ma mijudíohe ɛ̨mmɛ i tɛnda'ʉ yʉ́n t'ɛ̨di yʉ dąc'yɛi. Nɛ nu'bʉ hin nin xʉ'yɛ tengu man yʉ́n t'ɛ̨di, ya hin din sihmɛ 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nɛ ngutho 'bʉ xpá mbenga täi, him 'bex gue i sihmɛ, 'bɛ din xʉ'yɛ xʉn ho tengu yʉ́n t'ɛ̨dizɛhɛ i tɛn'dʉ. Nɛ man'da xʉn ngu yʉn sʉt'i i tɛn'dʉ, tengu yʉ́n t'ɛ̨di yʉ dąc'yɛi. Yʉ́n sʉt'i ngue yʉ tasa, nɛ yʉ xaro, nɛ yʉ t'ɛgui, nɛ yʉ́m 'be't'e yʉ t'ots'i. ");
INSERT INTO otmNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Janangue nu yʉ fariseo nɛ yʉ xänbate niją bi 'yänna ra Jesús: ―Hanja ʉ ni xädi hingui tɛn yʉ́n t'ɛ̨di yʉ dąc'yɛi nɛ i sihmɛ nɛ hin nin xʉ'yɛ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bi dąh ra Jesús, bi 'yɛ̨mp'ʉ: ―Nu'ahʉ yoho nin 'yomfɛ̨nihʉ, bi 'yɛ̨mp'ʉ. Nɛ majuąni bi man ra Isaías nangueehʉ 'bʉ mim pøngahyą, bi 'yɛ̨na: Nuya yʉ ją'i nangue yʉ́ nde i ɛ̨scagui, pɛ maxøts'e thoho, hinga gätho mbo yʉ́ mbʉi im bɛ̨ngui. ");
INSERT INTO otmNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Säti thoho i ɛ̨scagui nguetho hønt'ʉ yʉ́n t'ɛ̨di zɛhɛ i xänba ʉ mi'da, i ɛ̨n Oją, bi 'yɛ̨n a ra Isaías, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gue'a gá 'yøthʉ a nguetho gá hyɛhmbʉ yʉ́n t'ɛ̨di Oją nɛ gá tɛnhdʉ yʉ́n nt'ɛ̨di zɛhɛ yʉ ją'i nangue yʉ́n sʉt'i yʉ xaro, nɛ yʉ tasa nɛ xʉn ngu mi'da guí øthʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nɛ man'da bi xi ʉ, bi 'yɛ̨mp'ʉ: ―Nɛ hønt'a ram fɛ'ts'i guí øthʉ nangue yʉ́n t'ɛ̨di Oją, tengu 'bʉ nte di muui, nguetho hønt'ʉ nin t'ɛ̨di zɛhɛhʉ guí nde gui tɛnhdʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gue'a gní fɛstahʉ rán t'ɛ̨di Oją bi xi a ra Moisés a guí øthʉ, nguetho nu a ra Moisés bi 'yɛ̨na: “Gui numansu ni tahʉ nɛ ni mbehʉ” Nɛ man'da ram hma bi ma: “Nu'a to'o da zan rá ta o gue rá mbe, jatho da tho a.” ");
INSERT INTO otmNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Pɛ nu'ahʉ 'dan'yo thoho guí mamhbʉ ngue guí ɛ̨mhbʉ hing ra ts'oqui 'bʉ bi yąrba Oją a mi ja ngue xtá mbäx a rá mbe o gue rá ta n'da ran 'yohʉ. Nɛ hin gá xihmbʉ ngue him bi numansu yʉ́ ta 'bʉ ngubʉ bi 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gue'a gní combahʉ rám hman Oją a, nangue ni t'ɛ̨c'yɛi zɛhɛhʉ guí xänbahʉ mi'da yʉ ją'i. Nɛ xʉn ngu mi'da guí øthʉ, bi 'yɛ̨mp'ʉ yʉ fariseo a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nɛ nubʉya bi zohni gätho yʉ ją'i bi 'yɛ̨mp'ʉ: ―Dami 'yøhmbʉ, gätho ahʉ, nɛ dami pąhmbʉ na ga xi ahʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hin'yʉ 'bɛ'a da yʉrpʉ mbo rá mbʉi n'da, gue di ts'onba bʉ, pɛgue nu'a ní bøm bʉ ja rá mbʉi n'da gue a dí ts'onba rá ją'i n'da a. ");
INSERT INTO otmNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hønt'a go to'o ja yʉ́ zagu bi 'yø a dím mangä, bi 'yɛ̨mp'ʉ yʉ ją'i a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nɛ bi 'uepʉ 'bʉh yʉ ją'i a ra Jesús, bi mbähä yʉ́ xädi bʉ ja ra ngu. Nɛ nubʉya bi 'yän'dʉ yʉ́ xädi: ―'Bɛ'a gue na mbøn'a ran t'uti gá ma. ");
INSERT INTO otmNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nɛ bi 'yɛ̨mp'ʉ yʉ́ xädi bʉya: ―Ha nɛ ahʉ hin guí pąhmbʉ a dá mangä. Ha hin guí pąhmbʉ hin'yʉ 'bɛ'a da yʉrpʉ mbo rá mbʉi n'da, gue hinga gue'a dí ts'onba bʉ a. ");
INSERT INTO otmNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nguetho nu'a 'bɛ'a gätho i si n'da, hin din ząm bʉ rá mbʉi n'da, pɛ da mba bʉ rá foho n'da nɛ da thotho a, bi 'yɛ̨n a ra Jesús. Ngubʉ bi man ra Jesús i ndepe da fądi ngue xʉn ho 'bɛ'a gätho i ja ua ngue da zi n'da. ");
INSERT INTO otmNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nɛ mi ɛ̨n'a ra Jesús: ―Nu'a ní bøm bʉ rá mbʉi n'da ra ją'i, gue a dí ts'on'a n'da a. ");
INSERT INTO otmNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nguetho nubʉ ja yʉ́ mbʉi yʉ ją'i ní bøm bʉ gätho yʉ ts'on'yomfɛ̨ni, nɛ'bʉ i 'yomt'ɛ̨ni thoho n'da, nɛ'bʉ di 'yomt'ɛ̨niba n'da ra xisu nɛ i 'bʉh rá xisu, nɛ'bʉ i hącpa rá te rá miją'iui. ");
INSERT INTO otmNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nɛ'bʉ øt' ram fɛ̨, nɛ'bʉ øt' ran ts'iyate, nɛ'bʉ nząi øt ran ts'o, nɛ'bʉ i häte, nɛ'bʉ ra 'yąsä o gue ran ts'ɛya, o gue yʉn c'ąte, o gue yʉn 'yɛ̨ts'i, o gue'bʉ i øt'e tengu 'bʉ hin'yʉ rán 'yomfɛ̨ni n'da. ");
INSERT INTO otmNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gue'ʉ gätho ní bøm bʉ yʉ́ mbʉi yʉ ją'i nɛ gue'ʉ ní ts'onba yʉ́ mbʉi yʉ ją'i ʉ, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nu'bʉ mi jua a bin yąhʉ yʉ́ xädi a ra Jesús, bi mbähä bʉ ra xɛqui yʉ hnini Tiro nɛ Sidón. Nɛ nu'bʉ mi dįni hapʉ din säya bi nde ngue njon da bądi, pɛ njąm'bʉ bi zä bin 'yągui. ");
INSERT INTO otmNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nguetho 'bex bi zøm bʉ n'da ra xisu mi 'bʉ a n'da rá t'įxu min 'youi ra zįthu. Bi zøm bʉ ngue ya xí 'yøde nangue rá ts'ɛdi ra Jesús. Nu ra xisu, hin ma mijudíohe a, ra mɛngu bʉ ra xɛqui Sirofenicia. Bin dąnyahmu bʉ ja rá gua ra Jesús nɛ nts'ɛdi bi 'yäp ra mate ngue da hyønba thi a ra zįthu in 'youi a rá t'įxu. ");
INSERT INTO otmNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nu'a ra Jesús bi 'yɛ̨mbi: ―Hin nin säui ga øt'a a guím ma nguetho him ma mɛnguhʉ. Tenguthoho bʉ ja n'da ra ngu hin rán sähʉ rá mbʉdi da t'įn ʉ yʉ t'ʉ'yo, yʉ́ mbʉdi ʉ go yʉ t'ʉhni, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bi dą a ra xisu bʉya: ―Majuąni guím ma, gra Hmu, pɛ nɛ'ʉ yʉ t'ʉ'yo i sip yʉ́ xɛni yʉ ts'ʉnt'ʉ i hɛpʉ 'bimɛxa. ");
INSERT INTO otmNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nu'a ra Jesús bi 'yɛ̨mp'a: ―Xʉn ho ngue ngubʉ gá bɛ̨ni, janangue nu ra zįthu min 'youi ni t'įxu ya bi bøni. Ni mba ya. ");
INSERT INTO otmNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nu'bʉ mi zøm bʉ rá ngu bi nu a rá t'įxu 'bɛm bʉ ja rá oi, ya xí 'ue a ra zįthu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nɛ bi bøm bʉ ra häi Tiro a ra Jesús bi thotho bʉ ra hnini Sidón, nɛpʉ yʉ hnini ra häi Decápolis, nɛ bi zøm bʉ ja ra dądehe Galilea mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bá ts'inba n'da ra gogu nɛ i 'bare, bi t'äp ra mate ra Jesús da dospa rá yą a. ");
INSERT INTO otmNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nu'a ra Jesús bi zixa ra gogu bʉ ma'ueni ts'ʉ nguepʉ njongui 'bʉh yʉ ją'i, nɛ bi dįmba rá saha bʉ ja yʉ́ zagu, nɛ nu rá jįni bi gospa rá jąni. ");
INSERT INTO otmNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nɛ nubʉya, bi ndøts' mahɛ̨ts'i a ra Jesús nɛ bin gą'ts'i nɛ bi 'yɛ̨na: ―Efata, bi 'yɛ̨n a ra Jesús. Nu'a i nde da ma: “Dami xoqui.” ");
INSERT INTO otmNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nɛ 'bex bi xoh yʉ́ zagu, nɛ bi xoh rá nde nɛ bin yą xʉn ho bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nu ra Jesús bʉya nts'ɛdi bi xifi njon da xifi 'bɛ'a bi 'yørpe. Pɛ nu'bʉ mi sifi hin da ma pɛ man'da bi ma. ");
INSERT INTO otmNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nɛ gätho ʉ bi xifi ɛ̨mmɛ bi hyonya thoho ʉ, nɛ bi 'yɛ̨n'ʉ: ―Xøgue xʉn ho tho gätho i øt'a ra Jesús. Di jap yʉ gogu da 'yøhnahyą nɛ di japi din yą yʉ gore, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nu'ʉ yʉ pa ʉ, xʉn ngu yʉ ją'i bim pɛti mahøn'a bʉ ma'ueni mi 'bʉh ra Jesús, nɛ nte mi ja bʉ 'bɛ'a da zi, nguetho ma'ueni bʉ. Janangue a bi zohn'dʉ yʉ́ xädi ra Jesús nɛ bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nhuɛ̨cate tho yʉ ją'i nguetho ná hyupa dí 'bʉhmbʉ ua ya, nɛ hin'yʉ da zi. ");
INSERT INTO otmNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nɛ nu'bʉ ga pɛnpʉ yʉ́ ngu yʉ ją'i ngue ban sihmɛ bʉ masque da güent ra thuhu bʉ 'yu nguetho nu'ʉ 'da yabʉ bá nɛts'i, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bi dą ʉ yʉ́ xädi bʉya: ―Ma'ueni ua, hapʉ da zä da thįn a da zi ya 'bʉcua. ");
INSERT INTO otmNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nu ra Jesús bi 'yän'dʉ: ―Hangu yʉ hmɛ guí cʉhʉ, bi 'yɛ̨mp'ʉ. ―Yotomhmɛ, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nu ra Jesús bʉya bi xifi da hyupʉ häi yʉ ją'i. Nɛ bi hyąn ʉ yotomhmɛ bi 'yäp ra jamadi Oją nɛ bi xɛm bʉya, bi un'dʉ yʉ́ xädi di darpa ʉ yʉ ją'i i hupʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nɛ yʉ t'ʉhuą mi cʉ ʉ, bi jąpi nɛ bi un'dʉ yʉ́ xädi bʉya bi darpa yʉ ją'i hupʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gätho bin sihmɛ ʉ nɛ bin niyą xʉn ho. Nɛ nu'bʉ mi mba ma pɛti ʉ bi bongui, bin ja yoto 'bøts'e. ");
INSERT INTO otmNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nɛ nu'ʉ bin sihmɛ mi jua'i goho mahuąhi. Nɛ nubʉya, bi xih yʉ ją'i da mba yʉ́ ngu. ");
INSERT INTO otmNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nɛ bi yʉrpʉ ja ra mbosa ra Jesús bʉya nɛ yʉ́ xädi, bi zøm bʉ ra häi Dalmanuta. ");
INSERT INTO otmNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","'Bex bi zøm bʉ yʉ fariseo bʉya bi zä ra Jesús 'bʉ majuąni Oją bi un rá ts'ɛdi nɛ bi 'yäp yʉ hmɛpya mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pɛ nu ra Jesús bin gą'ts'i, bi du rá mbʉi nguetho guexta'a hingui ɛ̨c'yɛi gue ja rá ts'ɛdi, nɛ bi 'yɛ̨mp'ʉ: ―Hanja ngue guexta'a guí äjʉ yʉ hmɛpya. Majuąni dí xi ahʉ hin te ma hmɛpya ga ut'ahʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nɛ bi zopʉ ʉ bʉya, bi mba bi yʉrpʉ ja ra mbosa mahøn'a ʉ, bi mba bʉ 'danguadi. ");
INSERT INTO otmNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pɛ nu yʉ́ xädi ra Jesús bi pumbɛ̨ni him bi hyąx ra hmɛ. Nɛ hønt'a zi n'dam hmɛ mi o bʉ ja ra mbosa. ");
INSERT INTO otmNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","N'da ran t'uti bi xih yʉ́ xädi ra Jesús nɛ bi 'yɛ̨mbi: ―Dami jamansuhʉ nangue rá íxi yʉ fariseo nɛ rá íxi ra Herodes, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pɛ yʉ́ xädi bʉya sä bin 'yɛ̨mzɛhɛ n'da ngu n'da ʉ: ―Masque i xijʉ nguetho him bá hąhʉ ra hmɛ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pɛ nu ra Jesús 'bex bi bądi ngue him mi pą ʉ ngue gue'ʉ yʉ́n t'øt'e yʉ fariseo nɛ'ʉ mi tɛn ra Herodes bi xifi, nɛ bi 'yɛmp'ʉ: ―Ha gue'a gnín 'yänhdʉ a, ngue nte bá hąhʉ ra hmɛ. Hin gadin 'yomfɛ̨nihʉ, xʉm mɛ tho ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ja ni dähʉ nɛ hin guím bɛ̨mhbʉ 'bɛ'a gá nuhʉ, ja ni zaguhʉ nɛ hin guím bɛ̨mhbʉ a gá 'yøhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nɛ nu'bʉ má xɛngä cʉt'a yʉ hmɛ dá japi bin xąndi janague bin niyą xʉn ho cʉt'a mahuąhi dá 'uįngä, ha'mi 'bøts'e yʉ xɛqui gá pɛthʉ thą. Nɛ bi 'yɛ̨n ʉ: ―'Dɛ'mayo 'bøts'e. ");
INSERT INTO otmNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nɛ nu'bʉ má xɛngä yoto yʉ hmɛ dá japi bin xąndi janangue a bin niyą xʉn ho goho mahuąhi dá 'uįngä, ha'mi 'bøts'e gá pɛthʉ yʉ xɛqui thą. Nɛ bi 'yɛ̨n'ʉ: ―Yoto 'bøts'e. ");
INSERT INTO otmNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","―Ha guexta'a hin guí pąhmbʉ a dím mangä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nu'bʉ mi zøm bʉ ra hnini Betsaida ra Jesús nɛ yʉ́ xädi, 'bex bá ts'inba n'da ra xädä, nɛ bi t'äp ra mate da dädi. ");
INSERT INTO otmNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nu ra Jesús bʉya bi bɛnba rá 'yɛ ra xädä nɛ bi zix bʉ ma'ueni ts'ʉ ra hnini. Bi zorpa yʉ́ dä nɛ bi därpa yʉ́ xidä, nɛ nubʉya bi 'yän 'bʉ in nu ts'ʉ ran nɛqui. ");
INSERT INTO otmNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nɛ nu'bʉ min hanni ra xädä bi 'yɛ̨na: ―Dín nugä yʉ ją'i ya, ɛ̨na yʉ za, pɛ i 'yo, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nɛ bi därpa yʉ́ dä mahøn'a nɛ bi japi bi nu xʉn ho ran nɛqui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nɛ nu ra Jesús bʉya bi mbɛnpʉ rá ngu bi 'yɛ̨mbi: ―Hin gui mba bʉ hnini nɛ njo'o to gui xifi nangue a dá øt'e'e, bi 'yɛ̨mp'a mí xädä. ");
INSERT INTO otmNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nɛ nu'bʉ mi bøm bʉ ra hnini Betsaida a ra Jesús nɛ yʉ́ xädi, bi mbähä bʉ ja yʉ hnini ra xɛqui Cesarea Filipo. Nu'bʉ mi mba bʉ 'yu bi 'yän'ndʉ yʉ́ xädi nɛ bi 'yɛ̨mp'ʉ: ―'Bɛ'a i man yʉ ją'i nanguecä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nɛ nu'ʉ bi dąti: ―Ɛ̨n ʉ 'da yʉ ją'i gue'e grá Xuua Nxixyą. Nɛ nu'ʉ mi'da i ɛ̨n ʉ gue'e grá Elías. Nɛ mi'da i ɛ̨n ʉ, gue'e 'da ʉ yʉ pøngahyą mi 'bʉh maya'bʉ, bi 'yɛ̨n ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nu ra Jesús bi 'yänzɛhɛ yʉ́ xädi mahøn'a: ―Xi ahʉ, 'bɛ'a guí mamhbʉ nanguecä. 'Bex bi dą a ra Pedro, bi 'yɛ̨mbi: ―Nu'i gue'e grá Cristo, rá Thahni i Oją, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nɛ nu'a ra Jesús bi hɛcua yʉ́ xädi ngue hin da ma to'o a. ");
INSERT INTO otmNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nu ra Jesús bi dʉ'mi bi xi ʉ yʉ́ xädi 'bɛ'a da t'ørpe ngue gue'a bin ją'i ua ja ra ximhäi a, nɛ bi xi'ʉ ngue hin da numanho ma ngʉrbihe yʉ dąc'yɛi, nɛ yʉ ngʉrba mbäją nɛ yʉ xänbate niją, nɛ bi xi ʉ jatho da nu xʉn ngu ran ʉnbi nɛ da tho, nɛ da dąmbɛ̨ni 'bʉ ná hyupa. ");
INSERT INTO otmNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nɛ bi xifi xʉn ho 'bɛ'a da t'ørpe, hin'yʉ 'bɛ'a bi gøn'dʉ. Pɛ nu ra Pedro bi zixmanhɛ̨ nɛ bi hɛcpi, bi 'yɛ̨mbi: ―Njon gui japi da bɛnt'i i, damin yąni, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nu ra Jesús bi hyand bʉ mi 'bäh mi'da yʉ́ xädi 'bʉ mi 'yɛ̨mp'a ra Pedro: ―Dami 'uegue nangue ma hmigä grá zįthu Satanás. Nu'i hingui sä guim bɛ̨ni tengu im bɛ̨n Oją, hønt'a guím bɛ̨n a guín nu ua ja ra ximhäi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nu'a ra Jesús bʉya bi zohn'dʉ yʉ ją'i nɛ yʉ́ xädi nɛ bi 'yɛ̨mp'ʉ: Hønt'a go to'o i nde da dɛngui, hin da zän zɛhɛ 'bɛ'a da 'yøt'e nɛ da hyät yʉn ʉnbi madague da tho, nɛ da bɛ̨ni tengu dím bɛngä. ");
INSERT INTO otmNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nguetho nu'ʉ to'o i su da du nanguecä, pɛ gätho yʉ pa da nu ran ʉnbi maząi ʉ, pɛ nu'ʉ hingui su da du nanguecä nɛ nangue mam hmangä, gätho yʉ pa maząi dim 'bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hin'yʉ 'bɛ'a xʉn ho da nu ʉ yʉ ją'i 'bʉ xtí pɛti gätho 'bɛ'a i ja ua ja ra ximhäi, nɛ hønt'a ran ʉnbi maząi da nu ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hin'yʉ 'bɛ'a sä da 'yøt'a n'da ra ją'i ngue da 'yɛ̨na di pøsɛ rá te, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nɛ xø bi 'yɛ̨na: ―Nɛ nu'a to'o i pɛ'ts' rá sä nanguecä nɛ nangue mam hmangä bʉ 'bʉ ʉ hingui ɛ̨c'yɛi Oją, nɛcä ngue dán ją'igä ua ja ra ximhäi, xín ga ɛ̨mbi ma t'ʉhni 'bʉ rán zɛgui ra pa a, 'bʉ bá pengä mahøn'a. Nɛ din jagä rá ts'ɛdi ma Ta bʉ mahɛ̨ts'i nɛ gätho yʉ́m 'bɛhni ban 'yohe 'bʉ bá ɛ̨cä mahøn'a, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nɛ man'da bi xi ʉ, bi 'yɛ̨mbi: ―Majuąni dí xi ahʉ, 'bʉ i 'da ahʉ ngue hin gni tuhʉ 'bʉ bi dʉ'mi di manda ua rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nu'bʉ mi tho'a n'dato pa xím man ra Jesús na, bi zixa ra Pedro nɛ'a ra Jacobo nɛ ra Xuua bʉ ma'ueni bʉ bí ja n'da ra t'øhø xʉn hɛ̨ts'i. Nu'bʉ mí zøm bʉ, bi nu yʉ́ xädi bim pä'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nɛ rá pahni bim pädi bi fɛxni, nɛ ɛ̨mmɛ bi t'axqui xinda gue'ʉ gätho mi'da t'ɛ̨mbi xʉn t'axi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nɛ bi nɛqui bʉ ra Elías n'youi ra Moisés, bin yąhʉ ra Jesús, mi 'bʉh maya'bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nu ra Pedro bʉya bi xih ra Jesús: ―Ma xänbate i, xʉn ho ngue gätho dí 'bʉhmbʉ ua ya, bi 'yɛ̨na. Ga høhmbe hyu yʉ t'ʉngu. N'da'e nɛ n'da Moisés, nɛ n'da Elías, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ngubʉ bi ma nguetho him mi pądi 'bɛ'a bi ma nguetho ɛ̨mmɛ bi mbidi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nɛ nubʉya, bá ɛ̨h yʉ güi bi gomp'ʉ mi 'bä ʉ nɛ bi 'yø a n'da ra nde ʉ ngue bin yą bʉ ja yʉ güi, bi 'yɛ̨na: ―Guehna ma Ts'ʉnt'ʉ ɛ̨mmɛ dadí huɛ̨qui, dami 'yømanhohʉ 'bɛ'a da man na, bi 'yɛ̨n a ra nde bin yą. ");
INSERT INTO otmNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nɛ nu'bʉ min hanni ʉ yʉ́ xädi ra Jesús, njon mam bi nu, hønt'a ra Jesús bi nu i 'bäpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nɛ nu'bʉ mi gąpʉ ja ra t'øhø, bi 'yɛ̨mp'ʉ yʉ́ xädi ngue njo'o to da xifi 'bɛ'a xi nu bʉ, jague'bʉ bi dąmbɛ̨nisɛ a ra Jesús gue nu'a bin ją'i ua ja ra ximhäi a. ");
INSERT INTO otmNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Janangue a bi bɛ̨ntho a ram hma bi sifi nɛ him bi ma. Nɛ bin 'yänzɛhɛ nɛ bin 'yɛ̨mp'ʉ: ―Bɛ'a ní mba a ram hma bi ma ra Jesús ngue da dąmbɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nɛ bi 'yän'na ra Jesús ʉ bʉya: ―'Bɛ'a ní mba a i man yʉ xänbate niją ngue jatho duam 'bɛt'o ra Elías nɛ m'bɛjua ra Cristo, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mi dą a ra Jesús, bi 'yɛ̨mp'ʉ: ―Majuąni im man ʉ, bam 'bɛt'o ra Elías di hoqui gätho 'bɛ'a ja ua. Nɛ ha guím bɛ̨mhbʉ 'bɛ'a man rám hman Oją ngue din ja bʉya, ngue da zøh man'da din ją'i ua ja ra ximhäi, da nu xʉn ngu ran ʉnbi nɛ da t'ɛ̨mbi nte di muui. ");
INSERT INTO otmNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pɛ dí xi ahʉ ngue bi zøcua a gue bi thocpa rá 'bɛfi ra Elías, nɛ bi 'yørpe gätho mí ndesɛ yʉ ją'i da 'yørpe, tengu nt'o't'i nangue a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nɛ nu'bʉ mi zøpʉ 'bʉh mi'da yʉ́ xädi bi nu n'da munts'i yʉ ją'i ngue madi thɛ̨'ts'ʉ. Nɛ nu'ʉ 'da yʉ xänbate niją ngue madin junthʉ yʉ́ xädizɛhɛ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gätho yʉ ją'i mi 'bʉpʉ bi hyonya thoho 'bʉ min nu ba ɛ̨pʉ ra Jesús nɛ bin 'yɛ̨mp'ʉ: “Bɛ'a din ja ya.” Nɛ 'bex bin tihi bi mba bí zɛngua. ");
INSERT INTO otmNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nɛ nu ra Jesús bi 'yän'dʉ nɛ bi 'yɛ̨mp'ʉ: ―'Bɛ'a gue gnín junthʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Bex bi dą a n'da ran 'yohʉ mín 'yohʉ yʉ ją'i: ―Xänbate i, nugä bá sigä ua n'da ma ts'ʉnt'ʉ ngue in 'youi ra zįthu di japi i gore. ");
INSERT INTO otmNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nɛ hønbʉ go hapʉ i sits'i, nɛ i huą'ts'i, nɛ i pøn yʉ fʉgui rá nde bʉya. Nɛ di cuxt' yʉ́ ts'i nɛ di bøcabi. Nɛ dá xi ʉ ni xädi bʉya gue da hyønba thi ra zįthu pɛ him bi zä, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nu'a ra Jesús bi 'yɛ̨mp'a: ―Nu'ehʉ guexta a hin guí ɛ̨c'yɛihʉ 'bɛ'a dí xi ahʉ. Ha'mi pa ngue ga tøp'a thoho ahʉ ngue gui 'yɛ̨c'yɛigahʉ. Nu'a ni ts'ʉnt'ʉ ba singa ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bá ts'i bʉya. Nu'a ra zįthu 'bʉ mi nu ra Jesús 'bex bi dɛxa häi ra ts'ʉnt'ʉ min 'youi. Nɛ nu'bʉ mi zo bʉ häi din dąn bʉya, nɛ i pøn yʉ fʉgui rá nde. ");
INSERT INTO otmNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nu ra Jesús bi 'yän'na rá ta ra ts'ʉnt'ʉ: ―Man jąm'bʉ bi mbʉdi. Bi dą a rá ta ra ts'ʉnt'ʉ bʉya: ―Bi mbʉ 'bʉ min t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nɛ xʉn ngu yʉ nįdi di japi i apʉ ja ra sibi nɛpʉ po ra dehe 'bʉ i 'yo bʉ, i nde dí du a. Nu'bʉ da zä, dami zɛc'be gui huɛ̨ga'be, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nu ra Jesús bi dądi: ―Hąhą, nu'bʉ guí ɛ̨c'yɛi gue i ja ma ts'ɛdi. Gätho din ja a da nde n'da ra ją'i 'bʉ i ɛ̨c'yɛi i ja rá ts'ɛdi Oją, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nu'a rá ta ra t'ʉhni 'bex bi dąti nts'ɛdi: ―Majuąni dí ɛ̨c'yɛi pɛ dami jaqui man'da ga ɛ̨c'yɛi xʉn ho, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nɛ min nu ra Jesús, man'da ni zøtho yʉ ją'i, janangue a 'bex bi hyøn a thi ra zįthu min 'youi ra ts'ʉnt'ʉ, bi 'yɛ̨mbi: ―Grá gore zįthu nɛ grá gogu, dami pøm bʉ nɛ him man gui cʉrpʉ rá mbʉi na ra ts'ʉnt'ʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nɛ nu'a ra zįthu bi mbafi nɛ nts'ɛdi bi huąspa rá ją'i ra t'ʉhni, nɛ bi bøm bʉya. Nu'a ra t'ʉhni bi gohi tengu 'bʉ xi du. Nɛ xʉn ngu ʉ ɛ̨na: “Bi du.” ");
INSERT INTO otmNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pɛ nu'a ra Jesús bi bɛnba rá 'yɛ, nɛ bi xots'i, nɛ bim 'bäh ra t'ʉhni bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nɛ bi mbähä yʉ́ xädi ra Jesús bʉ ja ra ngu bʉya. Nu'bʉ mi zøm bʉ bi 'yän bʉ ma'ueni ts'ʉ: ―Hanja him bi zä dá hømhbe thi ra zįthu min 'youi ra t'ʉhni, bi 'yɛ̨n'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nuna ra zįthu tengu na, hin da zä gui hyømhbʉ thi 'bʉ hinga m'bɛt'o gui 'yɛ't' nin sihmɛhʉ nɛ ɛ̨mmɛ gan yąhʉ Oją, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nu'bʉ mi bøm bʉ ra Jesús nɛ yʉ́ xädi, bi mbähä bʉ Galilea, nɛ nu ra Jesús njom bi ndepe da bądi ngue i 'yo bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nguetho mí xänba yʉ́ xädi nɛ mí ɛ̨mbi: ―Nugä nque dán ją'igä ua ja ra ximhäi, da mba ma dägä bʉ ja yʉ́ 'yɛ yʉn 'yohʉ nɛ da thogä. Nɛ nu'bʉ dá tu, ga thąmbɛ̨nigä 'bʉ na hyupa. ");
INSERT INTO otmNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pɛ nu yʉ́ xädi him bi bądi 'bɛ'a nam bøn'a bi ma nɛ mí su da 'yänni. ");
INSERT INTO otmNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nɛ bi zøm bʉ Capernaum bʉya. Nɛ nu'bʉ mi zøm bʉ ja yʉ́ ngu, nu ra Jesús bi 'yän 'dʉ yʉ́ xädi: ―'Bɛ'a gnín junthʉ bʉ 'yu. ");
INSERT INTO otmNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nɛ him bi dą ʉ nguetho xin junt pʉ 'yu, xin 'yänni nangue'a to'o dim 'bɛt'o. ");
INSERT INTO otmNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nu'bʉ min säya ra Jesús, ―Bá thąmhbʉ ua, bi 'yɛ̨mp'ʉ 'dɛ'mayoho yʉ́ xädi. Nɛ nubʉya bi 'yɛ̨mp'ʉ: ―To'o nde di ngʉrbi da 'yøt'e ngue dim 'bɛjua thoho nɛ din 'yɛ̨hɛ nangue gätho ʉ mi'da, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nɛ nubʉya bi japi dim 'bä inde n'da ra t'ʉhni, nɛ bi dospa rá xįxi nɛ bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nu'a te'o i simanho n'da ra t'ʉhni nangue ma thuhugä, nɛcä i simanhogui. Nɛ nu'a to'o i simanhogui, hinga høngdä i simanhogä a pɛ nɛ'a Oją bá pɛngä ua i simanho a, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nu ra Xuua bi 'yɛ̨mp'a ra Jesús: ―Xänbate i, xtán nuhe n'da ran 'yohʉ i ndøn'na ni thuhu 'bʉ i høn a thi yʉ zįthu in 'youi 'da yʉ ją'i, nɛ dá hɛcpahe, nguetho hin dín 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nde'bʉ hin xqui hɛcpahʉ nguetho hin di c'ąman'ʉgä to'o øt' yʉn t'øt'e mixte nangue ma ts'ɛtigä. ");
INSERT INTO otmNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nɛ nu'ʉ to'o i 'bʉi ngue him man sʉihʉ, gue'ʉ mam fäts'ihʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Hønt'a go te'o di 'da ahʉ ts'ʉ ra dehe ngue i pądi guí tɛngahʉ, majuąni dí xi ahʉ i ja 'bɛ'a di un Oją a nangue ran ho bi 'yøt'ahʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Hønt'a te'o di 'bɛpi da 'yøt' ran ts'o n'da ra t'ʉhni i ɛ̨c'yɛigui, xʉn ʉtho ran ts'ɛmbi da nu a. Man'da xʉn ʉ xinda gue'bʉ da thurpi rá 'yʉga bʉ ja ra do ngue ra jʉni xʉn hyʉ, nɛ da t'ɛn bʉ mbonthe ja ra deją. ");
INSERT INTO otmNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nu'bʉ ni 'yɛhʉ di ja ahʉ gui 'yøthʉ ran ts'o, xʉn ho 'bʉ gui 'yøthʉ tengu 'bʉ gui hyɛjʉ. Madague gan do'yɛhʉ pɛgue gui tįmhbʉ ra te maząi, xinda gue'bʉ di ja yoho ni 'yɛhʉ nɛ gui nuhʉ ran ʉnbi maząi guepʉ ja ra sibi njąm'bʉ i huɛ̨t'i. ");
INSERT INTO otmNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Xʉn ʉtho guin nuhʉ bʉ 'bʉ, tengu tho 'bʉ i sa a ni ngøhʉ yʉ zu'uɛ̨, nɛ njąm'bʉ din hɛ̨ a dí zapi gätho yʉ pa, nɛ tengu 'bʉ n'da ra sibi njąm'bʉ da huɛ̨t'i. ");
INSERT INTO otmNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","O nu'bʉ ni guahʉ di ja ahʉ gui 'yøthʉ ran ts'o, xʉn ho 'bʉ gui 'yøthʉ tengu 'bʉ gui hyɛjʉ. Madague gan doguahʉ pɛgue gui tįmhbʉ ra te maząi xinda gue'bʉ di ja yoho ni guahʉ nɛ gui nuhʉ ran ʉnbi maząi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Xʉn ʉ tho guin nuhʉ bʉ 'bʉ, tengu tho n'da ra du ngue 'bʉh yʉ́ zu'uɛ̨ sap yʉ́ ngø nɛ njąm'bʉ din hɛ̨ a ni zapi gätho yʉ pa, nɛ tengu 'bʉ n'da ra sibi njąm'bʉ da huɛ̨t'i. ");
INSERT INTO otmNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","O nu'bʉ ni dähʉ di ja ahʉ gui 'yøthʉ ran ts'o, xʉn ho 'bʉ gui 'yøthʉ tengu 'bʉ gui hyąhmbʉ. Madague gan 'dadä thohohʉ, pɛgue gui cʉthʉ bʉ di manda rá ts'ɛdi Oją, xinda gue'bʉ di ja yoho ni dähʉ nɛ gui nuhʉ ran ʉnbi maząi. ");
INSERT INTO otmNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Xʉn ʉ tho guin nuhʉ bʉ 'bʉ, tengu tho n'da ra du ngue 'bʉh yʉ́ zu'uɛ̨ sap yʉ́ ngø nɛ njąm'bʉ din hɛ̨ a ni zapi gätho yʉ pa, nɛ tengu 'bʉ n'da ra sibi njąm'bʉ da huɛ̨t'i. ");
INSERT INTO otmNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gätho ahʉ din ja ahʉ yʉn ʉnbi 'dahma gui pømanhohʉ, tengu tho ʉ yʉ 'bøts'e din t'un Oją i pa ma japi ra ų ngue da bømanho. ");
INSERT INTO otmNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nu ra ų xʉn ho. Pɛ nu'bʉ bi 'bɛh rá ts'ɛdi ya hin'yʉ 'bɛ'a sä dín hoqui. Nɛ ngutho ahʉ o guidi jafʉ gui 'bɛhmbʉ ran ho i ja ahʉ. Pɛ guim 'bʉmanhohʉ ni mija'ihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nu'bʉ mam bá ɛ̨pʉ Capernaum ra Jesús bi zøm bʉ ra xɛqui Judea, nɛ bin 'yo bʉ rá nyąni ra häi Judea nɛpʉ 'danguadi ra dąthe Jordán. Bi mbʉh yʉ ją'i bim pɛti mahøn'a bʉ mi 'bäh ra Jesús, nɛ bi xänbi mahøn'a tengu nząi mi øt'e. ");
INSERT INTO otmNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nɛ nu'bʉ mi zøm bʉ yʉ fariseo, bi 'yän 'bʉ da zä da hyɛh rá xisu n'da ran'yohʉ, nguetho i nde da dįnbi 'bɛ'a dí yąp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nu'bʉ mi dą a ra Jesús: ―'Bɛ'a mam bʉ ja rán t'ɛ̨di ra Moisés nangue ran hyɛgui. ");
INSERT INTO otmNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bi dą'ʉ yʉ fariseo bʉya: ―Nu ra Moisés bi ma ngue nu'bʉ n'da ran 'yohʉ in nde da hyɛh rá xisu, da t'ørpa ra søcuą ngue ran xuni. ");
INSERT INTO otmNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nu'bʉ mi dą a ra Jesús bi 'yɛ̨mp'ʉ: ―Nangue'a xʉm mɛ ni mbʉihʉ janangue a gue a ran t'ɛ̨di bi man ra Moisés a. ");
INSERT INTO otmNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pɛ nu'bʉ rá mbʉdi ra ximhäi, Oją bi zänna n'da ran 'yohʉ nɛ rá xisu. ");
INSERT INTO otmNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Janangue a nu'bʉ n'da ran 'yohʉ da zin a n'da ra xisu him man i 'yo rá güɛnda rá ta o gue rá mbe, ");
INSERT INTO otmNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pɛgue dim 'bʉhmi rá xisu nɛ din ja tengu 'bʉ n'dan ją'itho. Nu mam 'bɛt'o mí yonją'i, pɛ nu'bʉ bi zini din ja tengu 'bʉ n'dan ją'itho. ");
INSERT INTO otmNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nɛ nu'ʉ di pɛnba Oją ʉ, njon da zä di xunba ʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","M'bɛjua bi zøm bʉ ja n'da ra ngu nɛ bi 'yän'dʉ yʉ́ xädi: ―'Bɛ'a nam bøn a gám ma, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nu ra Jesús bi 'yɛ̨mp'ʉ: ―Gätho te'o da hyɛh rá xisu nɛ da zim man'da, nu'a øt' ra 'yomt'ɛ̨ni a. ");
INSERT INTO otmNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nɛ ngutho n'da ra xisu 'bʉ da hyɛh rá ndø nɛ da zim man'da ran 'yohʉ nɛ'a øt' ra 'yomt'ɛ̨ni a, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nu'ʉ 'da yʉ ją'i bi zix yʉ́ t'ʉhni bʉ 'bʉh ra Jesús, i ndepe da dospa yʉ́ yą. Pɛ nu yʉ́ xädi bi hɛcpa ʉ ngue hin da zix yʉ t'ʉhni bʉ 'bʉh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nu'bʉ mi nu ra Jesús 'bɛ'a bi 'yøt' yʉ́ xädi bin cuɛ bʉya, nɛ bi 'yɛ̨na: ―Dami jafʉ yʉ t'ʉhni ba thocua, 'yo gui corpahʉ bʉ, nguetho hønt'ʉ to'o da gohi tengu n'da ra t'ʉhni ngue din unsɛ di manda rá ts'ɛdi Oją, da yʉrpʉ di manda rá ts'ɛdi Oją ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Majuąni dí xi ahʉ, nu'bʉ hin gui cohmbʉ tengu n'da ra t'ʉhni hin da zä gui cʉthʉ bʉ di manda rá ts'ɛdi Oją 'bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nɛ nubʉya i thɛx'ʉ yʉ t'ʉhni nɛ bi dospa yʉ́ yą nɛ bi 'yäp rám fäts'i Oją nangue ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nu'bʉ mi bøn'a ra Jesús bʉ mí 'bʉi, 'bex bá ɛ̨ a n'dihi n'da ra ts'ʉnt'ʉ. Bi zʉpʉ 'yu, bin dąnyahmu bʉ ja rá gua ra Jesús nɛ bi 'yɛ̨mbi: ―Hoga xänbate i, 'bɛ'a ga øt'ä ngue din jagä ra te maząi, bi 'yɛ̨n a. ");
INSERT INTO otmNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","―Ha guím bɛ̨ni 'bɛ'a guím ma ngue guí ɛ̨ngui xʉn hogui. Nguetho hønt'a Oją xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ha guí pą ʉ yʉ́n t'ɛ̨di Oją ngue i ɛ̨na: “O guí 'yomt'ɛ̨ni, o guí hącpa rá te ni miją'iui, o guím pɛ̨, o guí man yʉ fɛhni, hin gan siyate, nɛ gui numansu ni ta nɛ ni mbe, nɛ gue'a man yʉn t'ɛ̨di a,” bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nɛ bi dą a ra ts'ʉnt'ʉ bʉya: ―Xänbate i, gätho yʉn t'ɛ̨di dá øt'ä gue'bʉ go man t'ʉhnigä. ");
INSERT INTO otmNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nu ra Jesús ɛ̨mmɛ bi huɛ̨c 'bʉ min hyɛ̨tui nɛ bi 'yɛ̨mbi: ―I ja a man'da di 'bɛdi gui 'yøt'e. Ni mba, bá pä 'bɛ'a gätho i ja i, nɛ gui darpa yʉ hyoya ni mbɛti bʉya. Nɛ din ja a 'bɛ'a m'bɛ'ts'i bʉ mahɛ̨ts'i gue di muui. Nɛ nubʉya ba ɛ̨hɛ gui tɛngui, nɛ gui hyät' yʉn ʉnbi madague gui tu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pɛ nu ra ts'ʉnt'ʉ bi du rá mbʉi 'bʉ mi 'yø a bi man a ra Jesús nguetho ɛ̨mmɛ ra mɛmbɛti a. Janangue a bi 'uetho. ");
INSERT INTO otmNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nu ra Jesús bi hyant'ʉ gätho mi 'bäpʉ nɛ bi xih yʉ́ xädi bʉya: ―Ɛ̨mmɛ xʉn hɛ̨i n'da ra mɛmbɛti da yʉrpʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nɛ nu yʉ́ xädi bi hyonya thoho a bi man ra Jesús. Pɛ nu ra Jesús xø bi 'yɛ̨mp'ʉ yʉ́ xädi mahøn'a: ―Ma zʉ t'ʉhni ahʉ, xʉn hɛ̨i da yʉrpʉ di manda rá ts'ɛdi Oją n'da 'bʉ i hu rá mbʉi nangue ra mbɛti. ");
INSERT INTO otmNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Man'da hingui hɛ̨i ra camello da yʉrpʉ ja rá zagu ra 'yofani, xinda gue n'da ra mɛmbɛti da yʉrpʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nɛ xø man'da bi hyonya tho ʉ yʉ́ xädi nɛ bin 'yɛ̨mzɛhɛ ʉ: ―To'o maha da zä da dįn a ra te maząi 'bʉ, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nu ra Jesús bin hyɛ̨thʉ yʉ́ xädi nɛ bi 'yɛ̨mp'ʉ: ―Hingui sä da dįnsɛ ra te maząi n'da ra ją'i pɛ nu Oją gätho da zä da 'yøt'e, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nu ra Pedro bʉya bi 'yɛ̨mp'a ra Jesús: ―Nugähe, gätho 'bɛ'a mi jaje xtá sohmbe nɛ dá tɛn'nahe. ");
INSERT INTO otmNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","―Majuąni, ɛ̨n a ra Jesús, nɛ dí xi ahʉ ya, hønt'a go to'o bi zoh rá ngu, o gue yʉ́ cu, o gue rá ta, o gue rá mbe, o gue rá xisu, o gue yʉ́ t'ʉhni, o gue yʉ́ häi, ngue da dɛngui, pɛ ɛ̨mmɛ man'da xʉn ngu din ja ngue yʉ́ ngu, o gue yʉ́n 'yohʉ, o gue yʉ́n ju, o gue yʉ́ mbe, o gue yʉ́ t'ʉhni, o gue yʉ́ häi, xinda gue ʉ gätho mi ja mam 'bɛt'o, pɛ nɛ'ʉ yʉn ʉnbi da nu, nɛ da nu ran ho gätho yʉ pa maząi 'bʉ rán zɛgui ra pa. ");
INSERT INTO otmNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nɛ xʉn ngu ʉ mi 'bɛt'o dim 'bɛjua nɛ nu'ʉ mi 'bɛjua dim 'bɛt'o ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nu'bʉ mi mba bʉ 'yu Jerusalén ra Jesús, xʉn ngu yʉ ją'i bi dɛnni. Nu ra Jesús mi 'bɛt'o, min 'yohʉ yʉ́ xädi, nɛ mí 'bɛjua yʉ ją'i. Nɛ min su ʉ yʉ́ xädi, midi hyonya thoho ʉ ngue nde da mba bʉ Jerusalén ra Jesús. Nɛ nu ra Jesús bi zix bʉ ma'ueni ts'ʉ yʉ́ xädi nde da xifi 'bɛ'a da t'ørpe. ");
INSERT INTO otmNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nɛ bi 'yɛ̨mp'ʉ: ―Nuya ná mbähä bʉ Jerusalén. Nɛ nugä ngue dán ją'igä ua ja ra ximhäi, da mba ma dägä bʉ 'bʉh yʉ ngʉrpa mbäją nɛ'ʉ yʉ xänbate niją, nɛ da 'yørcä ran juąnbi ʉ ngue ga tu, nɛ di dägä bʉ 'bʉ ʉ him ma mijudíohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nɛ da mba nthengui nɛ da mba m'bɛ'migui, nɛ da mba nts'ots'igä, nɛ da thogui. Pɛ nu'bʉ ná hyupa ga thąmbɛ̨nigä, bi 'yɛ̨mp'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nu ra Jacobo nɛ ra Xuua, yʉ́ ts'ʉnt'ʉ ra Zebedeo, man'da bi hyäm bʉ mí 'bäh ra Jesús nɛ bi 'yɛ̨mbi: ―N'da ra mate dí nde ga ä'a'be. ");
INSERT INTO otmNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―'Bɛ'a guí nde ga øt'aui. ");
INSERT INTO otmNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nɛ bi 'yɛ̨mp'ʉ bʉya: ―Dí nde'be 'darpʉ ga huhmbʉ ngue 'da xtá hutho'be bʉ ja ni mɛxa 'bʉ gán ts'ʉt'abi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'aui, hin guí pąhmi 'bɛ'a nam bøn'a guí ähmi. Ha da zä nɛ'aui gui säui ran ʉnbi ga sägä. Ha da zä nɛ aui gui hyät'ui ra dumbʉi ga hät'ä. ");
INSERT INTO otmNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Da zä, bi 'yɛ̨n ʉ. Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Majuąni, nu ran ʉnbi ga sägä gui säui a, nɛ nu a ra dumbʉi ga hät'ä nɛ aui gui hyät'ui a. ");
INSERT INTO otmNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pɛ hinga gue'a man t'ɛ̨digä gam mangä to'o dan hyuhmbe bʉ ja ma mɛxa. Pɛgue gue'a Oją di un ran t'ɛ̨di to'o xan zänni, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nu'bʉ mi 'yø ʉ yʉ́ mixädihʉ 'bɛ'a bi man ra Jacobo nɛ ra Xuua, bi mbʉdi bin cuɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Janangue'a nu ra Jesús bi 'yɛ̨mp'ʉ gätho 'dɛ'mayoho yʉ́ xädi bʉya: ―Nu'ʉ i ja yʉ́ ts'ɛdi ua ja ra häi ɛ̨mmɛ xʉn hɛ̨i i ørpa ʉ to'o di manda ʉ, nɛ ɛ̨mmɛ din 'yɛ̨x'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pɛ nu'ahʉ hinga ngubʉ gui 'yøthʉ. Pɛ hønt'a go to'o da nde din ja rán t'ɛ̨di xʉn ho, pɛgue jatho din 'yɛ̨hɛ ngue gätho mi'da. ");
INSERT INTO otmNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nɛ nu'bʉ 'bʉ a n'da ahʉ ngue i nde dim 'bɛt'o, pɛgue din 'yɛ̨hɛ thoho ngue gätho mi'da. ");
INSERT INTO otmNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tengu thohogä, ngue dán ją'igä ua ja ra ximhäi, him bá ɛ̨cä ngue dam hmugä, pɛ bá ɛ̨cä ngue dan 'yɛ̨hɛ thohogä, nɛ ga dä ma te gan yąnba yʉ́ te yʉ ją'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nɛ mi thopʉ ja ra hnini Jericó ra Jesús nɛ yʉ́ xädi, n'yohʉ xʉn ngu yʉ ją'i. Nɛ mi hupʉ nden'yu n'da ra xädä rá thuhu ra Bartimeo, rá ts'ʉnt'ʉ ra Timeo. Mí äh ra mbɛti a. ");
INSERT INTO otmNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nɛ nu'bʉ mi 'yøde ngue gue'a ra Jesús ra mɛngu Nazaret ní mba bʉ, bi mba't'i, bi 'yɛ̨mbi: ―Hague Jesús, rám bom'bɛto i ra David, dami huɛ̨gui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pɛ nu yʉ ją'i bi hɛcpi, bi xifi din hɛ̨. Pɛ nu'a ra xädä man'da nts'ɛdi mbafi: ―Rám bom'bɛto i ra David, dín ja a nin huɛ̨cate nanguecä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nu ra Jesús bim 'bäh pʉya, bi zonhna ra xädä. Nu yʉ ją'i mí 'bɛjua bi xi a ra xädä: ―Dami ndants'i, gan johya, nguetho in zon'na i ra Jesús, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bi tonts'a rá coto ra xädä bʉya, bi ndants'i nɛ bi mba bʉ mi 'bäh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nu'a ra Jesús bi 'yɛ̨mp'a: ―'Bɛ'a guí nde ga øt'a i. Nɛ nu ra xädä bi 'yɛ̨mbi: ―Xänbate i, dí nde gui xoga ma dä. ");
INSERT INTO otmNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nɛ nu ra Jesús bi 'yɛ̨mbi: ―Ni mba, bi zä i nguetho gá 'yɛ̨c'yɛigui, bi 'yɛ̨na. Nɛ 'bex bin zø yʉ́ dä nɛ 'bex bi dɛn bʉ ni mba ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nɛ mi ts'ʉtho da zøm bʉ Jerusalén ra Jesús nɛ ʉ mín 'yohʉ. Bin 'yo bʉ hämbʉ ra hnini Betfagé nɛ ra hnini Betania, hɛ̨rpʉ ja ra nyuni Olivos. Nɛ nubʉya bi mbɛhn'dʉ yoho yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Ni mbɛ nʉ njon nʉ bí ja ra hnini nɛ nu'bʉ gá sømmi, gui tįmmi bʉ n'da ra buru nthąt'i ngue njo'o to xí hyux'a n'dandį, nɛ gua xoc pʉya nɛ gua siui ua. ");
INSERT INTO otmNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɛ nu'bʉ da t'ɛ̨n'aui: “Hanja ngubʉ guí øt'ui,” 'bʉ da t'ɛ̨n aui, gui 'yɛ̨nui: “Nu'a ra Hmu i honi nɛ xø ba si'be ua mahøn'a,” gui 'yɛ̨nui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nɛ bi mba bʉya, nɛ bi dįm bʉ a ra buru, nthąt'i bʉ ja ra goxthi nguepʉ i thoh ra 'yu. Nɛ bi xoc'ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nu'ʉ mi 'bʉpʉ bi 'yɛ̨n'ʉ: ―'Bɛ'a guí øt'ui bʉ, hanja guí xocui ra buru. ");
INSERT INTO otmNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nu'ʉ yʉ xädi bi dąt'ʉ nɛ bi xifi tengu xi xih ra Jesús. ―Dami sixui 'bʉ, bi t'ɛ̨mp'ʉ yʉ xädi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bá ts'inba a ra buru a ra Jesús bʉya nɛ bi mbøh yʉ́ coto ʉ bá si ra buru, ngue bi gąspi nɛ bi hyuxa ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nɛ'ʉ yʉ ją'i bi mbøh yʉ́m 'bɛxøts'e pahni bi xįmba bʉ 'yu, nɛ nu'ʉ mi'da yʉ ją'i bi xɛc yʉ paxi nɛ bi mbøcpa bʉ ja ra 'yu. ");
INSERT INTO otmNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nu'ʉ mi 'bɛt'o bʉ ní mba a ra Jesús, nɛ ʉ mi 'bɛjua, gätho í mba ʉ bi 'yɛ̨n'ʉ: ―Mająpi a bá pɛnhd Oją, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Din ts'ʉt'abi a tengu tho ma mbombøtahe ra David. Mixte rá ts'ɛdi Oją, bi 'yɛ̨m bʉ ní mba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bi yʉthʉ bʉ Jerusalén ra Jesús bʉya. Nɛ bi yʉrpʉ ja ra dąniją, nɛ bi nu 'bɛ'a gätho i t'ørpʉ nɛ bi bøm bʉya nguetho ya bin de. Bi mba bʉ ra hnini Betania nɛ ʉ 'dɛ'mayoho yʉ́ xädi bi mbähä. ");
INSERT INTO otmNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nu'bʉ mi hyax bʉya bi bøm bʉ Betania ra Jesús, bi mbeng bʉ Jerusalén. Nɛ bin tumanthuhu bʉ 'yu a. ");
INSERT INTO otmNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nɛ mi hant'a n'da ra za ja yʉ́ paxi, bi mba da nu 'bʉ i zʉpʉ yʉ́ ndät'o. Pɛ nu'bʉ mi zøm bʉ, nte bi dįm bʉ, hønt'ʉ yʉ́ xi nguetho hinga gue'ʉ yʉ pa i zʉh yʉ́ ndät'o, nɛ säti tho ja yʉ́ xi. ");
INSERT INTO otmNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nu ra Jesús bʉya bi 'yɛ̨mp'a ra za: ―Njąm'bʉ to da zi mahøn'a ʉ ni ndät'o, bi 'yɛ̨mbi. Nɛ bi 'yøh yʉ́ xädi a bi man ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nɛ bi thopʉ Jerusalén ra Jesús nɛ yʉ́ xädi. Nɛ bi yʉrpʉ ja ra dąniją mahøn'a. Nɛ bi hyøn a thi gätho yʉ mbä nɛ yʉ däi mi 'bʉpʉ. Nɛ bi ndønba yʉ́ mɛxa yʉm pämbɛti nɛ yʉ́n thuts'i yʉ mbät'azʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nɛ njon di japi da thopʉ niją 'bʉ i tu yʉ́ 'bɛni. ");
INSERT INTO otmNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nɛ bi 'yɛ̨mp'ʉ yʉ ją'i bʉya: ―Ha hinga nt'o't'i bʉ ja rá søcuą Oją ngue bi 'yɛ̨na: “Í thø a ma ngu nguepʉ da dąndegui gätho yʉ ją'i 'bʉcua ja ra ximhäi,” i ɛ̨n Oją, bi 'yɛ̨n a ra Jesús. Pɛ nu'ahʉ, xcá 'yørpahʉ tengu 'bʉ rá hyądo nguepʉ nin yąn ʉ yʉ bɛ̨, bi 'yɛ̨mp'ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bi 'yø ʉ yʉ xänbate niją nɛ yʉ ngʉrpa mbäją 'bɛ'a xí man'a ra Jesús, nɛ i honi hague dán zä da hyo, nguetho bin su 'bʉ mi nu gätho yʉ ją'i madi hyonya thoho nangue a 'bɛ'a bi xänba ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nu'bʉ mín de bi bøm bʉ a ra Jesús bʉ ja ra dąhnihni Jerusalén nɛ yʉ́ xädi. Bi mbähä bʉ ra hnini Betania mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nu'bʉ mi hyax bʉya bi thoh mahøn'a bʉ 'bä a ra za ngue mi ɛ̨na xtán zip yʉ́n dät'o ra Jesús. Nu'bʉ mi nu'ʉ, ya xí 'yot'i gätho yʉ́ 'yʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nu ra Pedro bʉya bi bɛ̨n a xí man ra Jesús nɛ bi 'yɛ̨mbi: ―Xänbate i, nɛ nunʉ ra za gá 'yɛ̨mbi him man'dandį da ts'ip yʉ́n dät'o nɛ ya xø 'yot' ya, bi 'yɛ̨n a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nɛ nu'bʉ mi dąh ra Jesús, bi 'yɛ̨mp'ʉ: ―Dami 'yɛ̨c'yɛihʉ ngue gätho da zä da 'yøt' Oją a xʉn hɛ̨i. ");
INSERT INTO otmNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Janangue'a nu'bʉ ya gá xihmbʉ n'da ra t'øhø da 'uegue din hyøzɛhɛ bʉ ja ra deją, din ja a gá mamhbʉ 'bʉ hingui yoho guím bɛ̨mhbʉ, nɛ guí pąhmbʉ majuąni gätho sä da 'yøt' Oją a xʉn hɛ̨i. ");
INSERT INTO otmNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Janangue'a dí xi ahʉ ngue nu'bʉ ja a guí äfʉ Oją, dami 'yɛ̨c'yɛihʉ ngue di 'da ahʉ a guí äfʉ nɛ din ja a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nɛ nu'bʉ guí yąhʉ Oją him man guim bɛ̨mhbʉ a bi 'yøt'ahʉ ni miją'ihʉ, gam punbahʉ ʉ nɛ'a Oją di pun'nahʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nguetho nu'bʉ hin gadim punbahʉ ni miją'ihʉ xinga gue'a ni Tahʉ bí 'bʉpʉ mahɛ̨ts'i di pun'nahʉ, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bi zøm bʉ Jerusalén ra Jesús nɛ yʉ́ xädi, nɛ xø bi zøm bʉ ja ra dąniją. Nɛ nu yʉ ngʉrpa mbäją bi zøm bʉ mi 'bäh ra Jesús, n'yohʉ yʉ xänbate niją nɛ yʉ dąc'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nu'ʉ bi 'yän'na ra Jesús: ―To'o bi 'da a ran t'ɛ̨di gui 'yøt'a guí øt'e. ");
INSERT INTO otmNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Nɛ nu ra Jesús 'bʉ mi dądi bi 'yɛ̨na: ―Nɛcä ga än'nahʉ to'o bi un rán t'ɛ̨di ra Xuua Nxixyą, hague Oją uague yʉ ją'ithoho. Nɛ nu'bʉ gá xijʉ, nɛcä ga xi ahʉ to'o bi 'dacä man t'ɛ̨di bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nu'ʉ bin 'yɛ̨mzɛhɛ ʉ bʉya: ―Xi'bʉ ga xihmbʉ ngue gue'a Oją bi un rán t'ɛ̨di, nɛ da 'yɛ̨njʉ: “Hanja hin gá 'yɛ̨c'yɛihʉ thą,” da 'yɛ̨njʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nɛ nu'bʉ ga ɛ̨mhbʉ yʉ ją'i thoho bi un ran t'ɛ̨di ra Xuua, pɛ hingui sä ga xihmbʉ tengu a, bi 'yɛ̨n ʉ, nguetho gätho yʉ ją'i mi ɛ̨spa ra Xuua nɛ bi 'yɛ̨c'yɛi ngue rá pøngahyą Oją a. ");
INSERT INTO otmNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nɛ nu'bʉ mi dą ʉ yʉ xänbate niją nɛ ʉ gätho min 'yohʉ, ―Hin dí pąhmbe, bi 'yɛ̨ntho ʉ. Nu ra Jesús bi 'yɛ̨mp'ʉ: ―Xinga guecä ga xi ahʉ to'o bi 'dacä man t'ɛ̨di, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nu ra Jesús 'bex bi dʉ'mi bi xi a n'da ran t'uti nɛ bi 'yɛ̨mp'ʉ: ―Nu n'da ran 'yohʉ bi 'yøt'a n'da ra nuąndät'o, nɛ bi fø't'e nɛ bi 'ya'ma n'da ra hyąhäi guepʉ da 'yøt'a n'da ran thɛ'ma guindät'o, nɛ bi hyø a n'da ra jądo xʉn hɛ̨ts'i da ndex ʉ da nu rá häi. Nɛ bi hmit'ʉ yʉ mbɛfi a rá häi ngue dim pɛpʉ, nɛ bi mba n'danni a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nu'bʉ bi zøn ra pa din ja ʉ yʉn dät'o, bá pɛhna n'da rá 'yɛ̨hɛ ba tu a xí mamhbʉ di unni. ");
INSERT INTO otmNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pɛ nu'ʉ yʉ mbɛfi bi bɛnt'a ra 'yɛ̨hɛ, nɛ bi mbɛ'mi nɛ bi mbɛnthoho bʉya nɛ nte bi unni. ");
INSERT INTO otmNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nu rá mbɛti ra nuąndät'ä bá pɛhn man'da rá 'yɛ̨hɛ bʉya. Pɛ nɛ'a bi mba ma bat'a do a, nɛ bi mba ma ʉnba rá yą, nɛ bi zantho, nɛ xø bi mbɛnthoho bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nɛ bá pɛhn man'da, nɛ xø bá tho a. Nɛ xʉn ngu mi'da bí 'bɛhni. Nu'ʉ 'da bi ʉnba thoho nɛ nu mi'da bi hyo. ");
INSERT INTO otmNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mi 'bʉ a n'da rá ts'ʉnt'ʉ a rá mbɛti ra nuąndät'o nɛ ɛ̨mmɛ di huɛ̨c'a. “Nu yʉ mbɛfi masque da numansu ma ts'ʉnt'ʉ,” bi 'yɛ̨nsɛ, nɛ bá pɛn'na bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pɛ nu ʉ yʉ mbɛfi 'bʉ mi nurpa a rá ts'ʉnt'ʉ, bin 'yɛ̨mzɛhɛ ʉ: “Nuna, guehna da gohmi ra häi 'bʉ bi du rá ta. Mbähä ga hohʉ nɛ nubʉya ma mbɛti zɛhɛhʉ ra nuąndät'o,” bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nɛ bi bɛnt'i nɛ bi hyo nɛ bi 'yɛm bʉ ma'ueni bʉ ja ra nuąndät'o, bi 'yɛ̨n'a ra Jesús 'bʉ mi man a ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","―Nuya guim bɛ̨mhbʉ 'bɛ'a da 'yøt'a rá mbɛti ra nuąndät'o, bi 'yɛ̨mp'ʉ. Guehma ba ɛ̨sɛ nɛ da hyo ʉ xí hmit'a rá nuąndät'o nɛ di un ra nuąndät'o ʉ mi'da, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ha hin gán xähmbʉ rá t'ohni Oją ngue i ɛ̨na: Nu'a ra do bi bʉnt'ʉ yʉ gądo, gue'a man'da mahyoni tengutho bʉ ná thon yʉ guangu. ");
INSERT INTO otmNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gue'a bi zänd Oją, hanja gní hyonya thohohʉ, ɛ̨m bʉ rám hman Oją, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nu yʉ ngʉrba mbäją nɛ'ʉ min 'yohʉ, bi nde da bɛnt'a ra Jesús nguetho bi bądi ngue go yʉ́n t'uti ʉ nangue a bi man ra Jesús, pɛgue bi zutho din cuɛ yʉ ją'i, janangue him bi bɛnt'i. Bi mbatho ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nɛ bi 'bɛnpʉ 'bʉh ra Jesús ʉ mi'da yʉ fariseo nɛ ʉ 'da ma ngʉrpihe mi tɛn'na ra ts'ʉt'abi Herodes. Bi 'bɛhni ngue da 'yän'na n'da ran t'änni nɛ nu'bʉ hinga gue a da ma, 'bex gue di yąpi. ");
INSERT INTO otmNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nu'bʉ mi zøm bʉ bi 'yɛ̨n ʉ: ―Xänbate i, dí pąhmbe gätho majuąni guím ma nɛ njon guí su, nguetho hin guí ørpa masu a man yʉ ją'i nɛ guí xänba a majuąni rám hman Oją ʉ yʉ ją'i. Dín nde gui xije, ha din thɛui yʉ́n t'ɛ̨di Oją 'bʉ dí øthʉ ngue dí juthʉ ra renta im man ra ts'ʉt'abi bʉ Roma in ts'ʉt'abi ua, uague hin'na. Ha xʉn ho 'bʉ ga thoqui ga juthʉ uague hin'na, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pɛ nu'a ra Jesús mi pądi høntho i nde da dįnbi 'bɛ'a dí yąp'a, janangue a bi 'yɛ̨mp'ʉ: ―Hanja gní 'yängahʉ, xi'a ni mbɛti gní juthʉ ra renta im man ra ts'ʉt'abi, gan nugä. ");
INSERT INTO otmNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nɛ bi un bʉya. ―To'o rá pøte nɛ rá thuhu i cuat na ra mbɛti, bi 'yɛn a ra Jesús. Nɛ nu'ʉ bi 'yɛ̨n ʉ: ―Rá pøte nɛ rá thuhu ra ts'ʉt'abi Roma i cuat na. ");
INSERT INTO otmNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mí dąh ra Jesús nɛ bi 'yɛ̨mp'ʉ: ―Nu'a rá mbɛti ra ts'ʉt'abi Roma, gui un'na. Nu'a xin rá mbɛti Oją gui un'na Oją a, bi 'yɛ̨mp'ʉ. Nɛ nu'ʉ bi hyonya thoho nangue a bi man'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nɛ bá ɛ̨ ʉ 'da yʉ saduceo bʉya ngue mi ɛ̨n ʉ njo'o to da dąmbɛ̨ni. Nɛ bi 'yän'na ra Jesús, bi 'yɛ̨mbi: ");
INSERT INTO otmNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Xänbate i, nu'a n'da ran t'ɛ̨di bi man'a ra Moisés i ɛ̨na, ngue nu'bʉ da du n'da ran 'yohʉ nɛ njo'o rá t'ʉhni 'bʉ bi du, nɛ nu'a rán 'yohʉ zɛhɛ da zinba a rá xisu a rán 'yohʉ bi du. Nɛ nu'a rá t'ʉhni dim 'bʉi da t'ɛ̨mbi rá t'ʉhni a xí du. ");
INSERT INTO otmNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nɛ mi 'bʉ i yoto yʉn 'yohʉ i din 'yohʉ zɛhɛ ʉ. Nɛ nu'a ra 'bɛt'o n'yohʉ bi zin'a n'da ra xisu, nɛ nu'bʉ mi du njo'o yʉ́ t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Janangue'a nu a rán 'yohʉ a bi du bi zin a ra xisu mahøn'a. Nɛ'a bi du a, nɛ xinga gue a bim 'bʉh yʉ́ t'ʉhni a. Nɛ ná hyu ngutho. ");
INSERT INTO otmNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nɛ gätho ʉ yoto ma 'yohʉ nɛ 'dat'a ra xisu bi zini, nɛ xinga n'da mím 'bʉh yʉ́ t'ʉhni 'bʉ bi du ʉ. Nɛ nzɛgui nɛsɛ ra xisu bi du. ");
INSERT INTO otmNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nuya dami xije nu'bʉ majuąni da dąmbɛ̨ni yʉ ją'i, nda'a nin 'yohʉ dim 'bʉhmi ra xisu, nguetho gätho yoto bim 'bʉhmi, bi 'yɛ̨n ʉ yʉ saduceo. ");
INSERT INTO otmNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mi dąh ra Jesús nɛ bi 'yɛ̨mp'ʉ: ―Nu'ahʉ 'dan'yo thoho guí mamhbʉ nguetho hin guím bɛ̨mhbʉ 'bɛ'a mam bʉ ja rá t'ohni Oją xín rá ts'ɛdi Oją guí pąhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nu'bʉ bi dąmbɛ̨ni ʉ xʉn du him man ja ran sini bʉ pɛgue dim 'bʉtho yʉ ją'i tengu yʉ́m 'bɛhni Oją 'bʉpʉ mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nɛ nu'a ram hma ngue da dąmbɛ̨ni ʉ xʉn du, majuąni a nɛ guin nuhʉ bʉ ja rám hman Oją ngue nu'bʉ min yąui Oją ra Moisés bʉ ja ra t'ʉza bi 'yɛ̨mbi: “Nugä drá Ojągä, nu ra Abraham nɛ ra Isaac nɛ ra Jacob ngue nim bombøtahʉ, i ɛ̨c'yɛigui,” bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ngubʉ bi ma nguetho guexta'a i 'bʉh yʉ́ mbʉi ʉ. Pɛ hin guím bɛ̨mhbʉ, nguetho 'dan'yo thoho guí mamhbʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nu'bʉ min yąhʉ yʉ saduceo ra Jesús, mi 'bʉpʉ n'da ra xänbate niją bi 'yøde 'bɛ'a bi man ra Jesús nɛ bi bądi ngue xʉn ho a bi ma. Janangue'a bi 'yänni: ―Nda'a rán t'ɛ̨di Oją ngue man'da ja ts'ɛditho ga øthʉ, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Bi dą'a ra Jesús: ―Nu'a rán t'ɛ̨di Oją man'da jats'ɛditho ga øthʉ, gue'a ran t'ɛ̨di ngue i ɛ̨na: “Dami 'yøhmbʉ gyʉ́ ją'i israelhʉ, nu'a Oją ra Hmu, n'datho a. Nɛ guim bɛ̨mhbʉ a nangue gätho ni mbʉihʉ, nɛ gätho ni tehʉ, nɛ gätho nin 'yomfɛ̨nihʉ, nɛ gätho ni ts'ɛdihʉ,” i ɛ̨n rá t'ohni Oją. Pɛ guehna ran t'ɛ̨di man'da ja ts'ɛdi tho ga øthʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nɛ 'da'angutho ui ná yoho ran t'ɛ̨di ga øthʉ i ɛ̨na: “Gui huɛ̨c ni miją'ihʉ tengu bʉ gnin huɛ̨c zɛhɛhʉ,” i ɛ̨n rá t'ohni Oją. Guehya yʉn t'ɛ̨di man'da ja ts'ɛditho ga øthʉ xinda gue ʉ mi'da, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nɛ nu'a ra xänbate niją, bi 'yɛ̨m bʉya: ―Xänbate i, majuąni xʉn ho guím ma, ngue hønt'a n'da Oją i 'bʉi nɛ njo'o man'da tengu a. Nɛ ja ts'ɛdi tho da bɛ̨n Oją n'da ngue gätho rá mbʉi, nɛ gätho rá te, nɛ gätho rán 'yomfɛ̨ni, nɛ gätho rá ts'ɛdi, ");
INSERT INTO otmNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","nɛ di huɛ̨c rá miją'iui tengu bʉ nin huɛ̨czɛhɛ n'da. Man'da ja ts'ɛditho da 'yøt'a n'da ʉ xinda gue ʉ gätho yʉ 'bøts'e nɛ yʉn t'unni dí mbøspa Oją n'da, bi 'yɛ̨n a ra xänbate niją. ");
INSERT INTO otmNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nɛ nu ra Jesús 'bʉ mí 'yø a bi man ra xänbate niją bi bądi ngue n'dat'a Oją im bɛ̨ni janangue a bi 'yɛ̨mbi: ―Nu'i ts'ʉtho di 'bɛ i ngue da zä gui cʉrpʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨mp'a. Nɛ nubʉya njom man'da bi zäpi da 'yän mi'da yʉn t'änni. ");
INSERT INTO otmNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","36","Nɛ mí xänba yʉ ją'i a ra Jesús bʉ ja ra dąnija, nɛ bi 'yɛ̨mp'ʉ: ―Hanja ɛ̨n ʉ yʉ xänbate niją ngue nu ra Cristo rám bom'bɛto ra David a, nɛ xim mi ɛ̨mbi rá Hmu 'bʉ hin ním 'bʉi, nguetho mi ɛ̨n'a ra David: Nu'a Oją bi 'yɛ̨mp'a ma Hmu: “'Dat'ua ga huhmi ga conhui ma ts'ɛdi gue'bʉ go dá tąpä nin sʉihʉ ua ja ra ximhäi nɛ gui manda ʉ bʉya,” bi t'ɛ̨mp'a ma Hmu, bi 'yɛ̨n a ra David 'bʉ mí bɛ̨nba rá Hogandąhi Oją nangue 'bɛ'a da 'yøt' ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Guesɛ ra David bi 'yɛ̨mbi rá Hmu a ra Cristo. Hague nja pɛ nɛ rám bom'bɛto a, bi 'yɛ̨n a ra Jesús. Pɛ nu yʉ ją'i, bi 'yømanho gätho a bi man ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nɛ bi thoqui bi xänba yʉ ją'i a ra Jesús bi 'yɛ̨mp'ʉ: ―Gam fähmbʉ nangue a i xi ahʉ yʉ xänbate niją, nguetho hønt'a ran 'yɛ̨ts'i i øt'ʉ nɛ di ho da hye yʉ pahni xʉ mba guepʉ i 'yo, nɛ di ho da mba ma zɛngua bʉ ja yʉ täi, ");
INSERT INTO otmNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","nɛ di ho da hyux bʉ ja yʉn thuts'i xʉn ho bʉ ja yʉ niją, nɛ di ho yʉ́ mbʉdi din sihmɛ bʉ ja yʉn sihmɛ ʉ, ");
INSERT INTO otmNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","nɛ i hąspi 'bɛ'a gätho bi ts'ocpa ʉ yʉ xisu xøn du yʉ́ ndø, nɛ sä nya'a thoho in yąhʉ Oją ngue i nde da t'ɛ̨mbi xʉn ho tho yʉ́ mbʉi. Man'da xʉn ngu ran ʉnbi da nu ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nɛ mi hupʉ ra Jesús bʉ mí ja ra huada guepʉ i pa njät'i ra mbɛti rán t'unni Oją. Nɛ in nu bʉ i cät' ra mbɛti ʉ yʉ ją'i bʉ ja ra huada. Nɛ bi nu xʉn ngu yʉ mɛmbɛti bi thopʉ ngue xʉn ngu ra mbɛti bi gärpʉ ja ra huada n'da ngu n'da ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nɛ bi zøm bʉ n'da ra hyoya xisu xi du rá ndø, nɛ bi gät'i yocentavo thoho. ");
INSERT INTO otmNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nɛ nu'bʉ mi nu a bi 'yøt'a ra xisu bʉya nɛ bi 'yɛ̨mp'ʉ: ―Majuąni dí xi ahʉ nuna zʉ hyoya xisu man'da xʉn ngu di muui a bi gärpʉ ja ra huada xinda gue'ʉ gätho mi'da. ");
INSERT INTO otmNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nguetho gätho ʉ mi'da bi gät'a i pongui, pɛ nuna ra xisu madague i hyoya na, pɛ bi gät'i gätho mi pɛ'ts'i, bi 'yɛ̨mp'ʉ yʉ́ xädi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nu'bʉ mi bøm bʉ ja ra dąnija ra Jesús nɛ yʉ́ xädi, nu'a n'da bi 'yɛ̨n'a: ―Xänbate i, hyandi ts'ʉ nʉ ra niją, ɛ̨mmɛ xʉ ndoho yʉ do n'yohʉ nɛ ɛ̨mmɛ mahotho. ");
INSERT INTO otmNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mi dąh ra Jesús nɛ bi 'yɛ̨mp'ʉ: ―Guín nuhʉ ngue mahotho nɛ ɛ̨mmɛ ndoho yʉ do, pɛgue da zøn ra pa da so't'i, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nɛ nu'bʉ mi zøm bʉ ja ra nyuni Olivos, bi hyupʉ ra Jesús, hɛ̨'t ra dąnija. Nɛ hønt'ʉ yʉ́ xädi mi 'bʉhmbʉ bʉ. Nɛ nubʉya ra Pedro nɛ ra Jacobo nɛ ra Xuua nɛ ra Andrés: ");
INSERT INTO otmNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Nda'a ní pa da mba nso't'i ra niją gá xije, bi 'yɛ̨n ʉ. Nda'a ni hmɛpya da hnu 'bʉ din ja a guím ma, t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mi dą a ra Jesús nɛ bi 'yɛ̨mp'ʉ: ―Gam fähmbʉ njon da hyä ahʉ, ");
INSERT INTO otmNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","nguetho xʉn ngu ba ɛ̨hɛ ngue sä da 'yɛ̨na: “Nugä, guecä drá Cristogä,” da 'yɛ̨n'ʉ. Nɛ xʉn ngu ʉ da hyät'i. ");
INSERT INTO otmNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nɛ nu'bʉ gui 'yøhmbʉ yʉ sʉi nɛ'bʉ da hma ngue din ja yʉ sʉi, o guin suhʉ nguetho jatho din ja ʉ. Pɛ nu'bʉ din ja ʉ xinga gue'bʉ ran zɛgui 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nguetho nu yʉ ją'i bʉ 'da yʉ häi din sʉhmi yʉ́ miją'ihʉ. Nɛ nu 'da yʉ ts'ʉt'abi din sʉhmbʉ yʉ́ mits'ʉt'abihʉ, nɛ din ja yʉ 'yąnhäi, nɛ xʉn ngu yʉ nįdi din ja ra thuhu nɛ yʉn 'yo'ts'i. Nɛ guehya yʉ́ mbʉdi yʉn ʉnbi ya, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nɛ xø bi 'yɛ̨n'a: ―Nɛ gam fähmbʉ njon di 'uec'ahʉ bʉ ja rá 'yu Oją, nguetho da mba ma dä ahʉ bʉ ja ran juąnbate, nɛpʉ ja yʉ́ niją ma mijudíohʉ da 'bɛp'ahʉ, nɛ nangue guí ɛ̨c'yɛigahʉ da ts'on'nahʉ bʉ 'bʉh yʉ ts'ʉt'abi, nɛpʉ 'bʉh yʉ dąts'ʉt'abi ngue da ts'ɛp'ahʉ. Nɛ xʉn ho 'bʉ din jabʉ nɛ gue'a dí zä gui xihmbʉ mam hmangä ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pɛ m'bɛt'o thoho da mba nsifi gätho yʉ ją'i 'bʉcua ja ra ximhäi ran ho ma'da'yo dí pø ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nɛ nu'bʉ da zix ahʉ di dä ahʉ bʉ 'bʉh ra ts'ʉt'abi, pɛ him 'bɛ gui hyonsɛhʉ 'bɛ'a gui mamhbʉ 'bʉ da mba ma juąn'ni ahʉ, nguetho nu'bʉ bi zøn ra ora da t'än'nahʉ, hønt'a rá Hogandąhi Oją da zä di bɛ̨n'nahʉ 'bɛ'a gui mamhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nɛ nu n'da ran 'yohʉ di manda da tho rán 'yohʉ, nɛ nu'a rá ta di manda da tho rá ts'ʉnt'ʉ. Nɛ da ndants'ʉ yʉ́ ts'ʉnt'ʉ din tunhdʉ ʉ yʉ́ ta nɛ yʉ́ mbe nɛ di manda da tho rá ta nɛ rá mbe 'da yʉ ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nɛ gätho yʉ ją'i da zan ahʉ nangue a guí ɛ̨c'yɛigahʉ. Nɛ nu'ʉ to'o gätho da hyät yʉn ʉnbi gue'bʉ go rán zɛgui, gue ʉ dim pø ʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nɛ bi thoqui bi xi ʉ: ―Ba ɛ̨ a n'da ra ts'ɛdi xʉn ts'o ngue di ts'oni gätho. Ngubʉ bi man ra Daniel gue rá pøngahyą Oją. Nɛ nu'bʉ gá nuhʉ dim 'bäpʉ guepʉ hin rán säui dim 'bäi, dami 'dahmbʉ gyʉ́ mɛnguhʉ bʉ Judea, gui mbähä bʉ ja yʉ t'øhø guin 'yąmhbʉ bʉ. Nu a to'o da nu ra søcuą i ja ua, da 'yɛ̨'t'ambʉi na. ");
INSERT INTO otmNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nɛ nu'bʉ bin ja a, to'o i 'bäpʉ goxthi hin da yʉrpʉ mbo rá ngu, hin da bɛ̨ni ja 'bɛ'a 'bɛ da hyąts'i, 'bex gue da 'dagui. ");
INSERT INTO otmNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nɛ nu'a to'o 'bäpʉ ja yʉ́ huąhi hin da mbeng bʉ ja yʉ́ ngu ngue ba cą yʉ́ coto, 'bex gue da 'datho bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Huɛ̨cate ʉ yʉ xisu in hąt'ʉhni nɛ ʉ 'bʉh yʉ́ 'uɛre yʉ pa ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","'Yäfʉ rá mate Oją ngue hin din ja ahʉ ran 'dagui 'bʉ yʉ pa xʉn sɛ xøhma hin da zä gui 'dahmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nɛ nu'ʉ yʉ pa ʉ, din ja xʉn ngu yʉn ʉnbi hin jąm'bʉ n'dandį xøn ja gue'bʉ go rá mbʉdi ra ximhäi. Nɛ nu'bʉ ya bin ja, him man'dandį din ja yʉn ʉnbi tengu ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pɛ nangue ʉ yʉ́ 'yɛ̨c'yɛi, Oją di japi hingui ngu yʉ pa din ja yʉn ʉnbi, nu'bʉ hin'na njon xtam bongui, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nɛ bi thoqui bi ma, bi 'yɛ̨na: ―Nɛ nu'bʉ da si ahʉ: “Dami hyanthʉ, 'bʉcua ra Cristo ya, rá Thahni Oją,” da t'ɛ̨n ahʉ. O gue da t'ɛ̨n'ahʉ: “Ba nuhʉ 'bʉpʉ ra Cristo ya, rá Thahni Oją,” da t'ɛ̨n ahʉ, pɛ o guí ɛ̨c'yɛihʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nguetho xʉn ngu dim 'bʉ ʉ yʉ hyäte Cristo nɛ yʉ hyäte pøngahyą da 'yøt' yʉ hyonya nt'øt'e nguetho i nde da hyät yʉ 'yɛ̨c'yɛi gue bi huanh Oja, 'bʉ da zä da hyät'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pɛ nde'bʉ gam fäsɛhʉ nguetho ya dá xi ahʉ 'bɛ'a gätho din ja m'bɛjua, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nɛ xø bi 'yɛ̨mp'ʉ yʉ́ xädi a ra Jesús: ―Nɛ nu'bʉ ya bi guah yʉn ʉnbi, nu a ra hyadi di 'bɛh rá ts'ɛdi nɛ ra ząna him man ja rán nɛqui. ");
INSERT INTO otmNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nɛ nu yʉ sø da dägui. Nɛ gätho mi'da di 'bɛh yʉ́ ts'ɛdi ʉ gä bí ja bʉ mahɛ̨ts'i, di 'yąni. ");
INSERT INTO otmNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nɛ nubʉya da hnugui ba ɛ̨cä ua ngue dán ją'igä ua ja ra ximhäi, ba ogä bʉ ja yʉ güi, dan 'yo'be xʉn ngu ma ts'ɛdi nɛ dam mixte xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ga pɛn'dʉ yʉ́m 'bɛhni Oją mahɛ̨ts'i bʉya, di pɛt'ʉ gätho xtá huahni guecua gätho na ngʉni ra ximhäi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nuya da zä gui pąhmbʉ 'bɛ'a gue nin t'uti i ut'ahʉ 'da yʉ za. Nu'bʉ bi bøx yʉ́ 'dogui ʉ yʉ́ 'yɛ guí pąhmbʉ mi ts'ʉtho din ja ra hyethe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ngutho 'bʉ ya bin ja gätho ʉ dá xi ahʉ, gui pąhmbʉ ngue mi ts'ʉtho ba pengä ua mahøn'a bʉya, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Majuąni dí xi ahʉ di 'bʉtho ua 'da ahʉ 'bʉ bi mbʉdi din ja a dí xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mahɛ̨ts'i da guadi, nɛcua ja ra häi, pɛ nu'a mam hmangä hin jąm'bʉ da gua a. ");
INSERT INTO otmNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pɛ nu'a ra pa a, njongui pądi 'bɛ'a ní ora din ja a dím mangä, xinga gue ʉ yʉ́m 'bɛhni Oją 'bʉpʉ mahɛ̨ts'i, xinga guecä ngue dán ją'igä ua ja ra ximhäi dí pądi. Hønt'a Oją ma Ta i pądi, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nɛ xø bi 'yɛ̨na: ―Thocpa thoho gan nuhmbʉ tengu'bʉ hin gui tonspahʉ ra t'ąha. Nɛ xinga n'da zi ora gui pumbɛ̨nihʉ Oją nɛ thocpa thoho gan yąhʉ a, nguetho hin guí pąhmbʉ nda'a ni pa ba pengä mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tengu n'da ran 'yohʉ bi mba yatho bi zoh rá ngu, bi un yʉ́n t'ɛ̨di yʉ́ 'yɛ̨hɛ ngue di jamansu bʉ, n'da ngu n'da bi xi a da 'yøt'e. Nɛ bi xi a ra mbängoxthi ngue hin di tonspa ra t'ąha. ");
INSERT INTO otmNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nɛ ngutho dí xi ahʉ, dami tømhbʉ tengu 'bʉ gan äthąhʉ nguetho hin guí pąhmbʉ 'bɛ'a ní pa ba pengä ua, o gue'bʉ bin de, o gue'bʉ made ra xui, o gue'bʉ bi mbah yʉ øni, o gue'bʉ bi hyats'i. ");
INSERT INTO otmNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nguetho hin guí pąhmbʉ nda'a ni ora ba ɛ̨cä, xi'bʉ ba ɛ̨cä nɛ ga tįn ahʉ bʉ gdi ąhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nɛ nu'a dí xi ahʉ, ngutho dí xicä gätho mi'da: “Dami tømhbʉ,” bi 'yɛmp'ʉ yʉ́ xädi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nɛ man yopa da dät ra pa 'bʉ mi bɛ̨n a xí 'yøt' ma mbombøtahe bʉ Egipto dyʉ judíohe. Nu yʉ ngʉrpa mbäją bʉya nɛ yʉ xänbate niją bi bɛ̨ni 'bɛ'a ni fɛhni da xi a ra Jesús guepʉ da zä da bɛnt'i ngue da hyo. ");
INSERT INTO otmNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nɛ bin 'yɛ̨mzɛhɛ ʉ: ―Hinga gue a ra pa ra dąmpɛti gam bɛnthʉ nɛ xøhma din cuɛ yʉ ją'i, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nɛ mi 'bʉpʉ ra Jesús bʉ ja rá ngu ra Simón bʉ ja ra hnini Betania. Gue'a ra Simón mi hɛ̨mb ra t'axca'ya 'bʉ mam 'bɛt'o. Nɛ nu'bʉ mi sihmɛ bʉ ra Jesús bi zøpʉ n'da ra xisu i tu n'da ra xito nt'øt'e ngue ra do'yaxi, mi po ra 'yɛ̨thi ɛ̨mmɛ yʉman'u a, nɛ xʉn ngu di muui a. Bi xɛcpa rá nde bʉya nɛ bi naspa rá yą ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nu'ʉ 'da mí 'bʉpʉ, bin cuɛ ʉ bʉya nɛ bi 'yɛ̨n ʉ: ―Hanja bim 'bɛtho ra 'yɛ̨thi nɛ xʉm hmadi di muui. ");
INSERT INTO otmNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mi sä xtá 'bä xtin t'un yʉ hyoya a hyu ciɛnto rá muui a ra 'yɛ̨thi, bi 'yɛ̨n ʉ. Nɛ bi numan'ʉ ra xisu ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Hanja guín jahʉ bʉ, o guidi pahmbʉ ra xisu nguetho xʉn ho bi 'yørcä na. ");
INSERT INTO otmNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nu'ahʉ thocpa thoho gam 'bʉhmbʉ yʉ hyoya nɛ hønt'a go ma pa da zä gui fäxhʉ ʉ. Pɛ nugä hinga thocpa thoho dam 'bʉhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bi 'yørca ra xisu a mi sä da 'yøt'e, bi hoga ma ngøc'yɛ̨i ngue da t'ägä bʉ ja ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Majuąni dí xi ahʉ gue hønbʉ go hapʉ da hman ran ho ma'da'yo gätho na ndoho ra ximhäi, nɛhna bi 'yørca ra xisu da hman na, 'dahma nɛ'a da fɛ̨n a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nu'a ra Judas Iscariote bʉya, ngue'a n'da yʉ́ xädi ra Jesús, bi mba bʉ 'bʉh yʉ ngʉrpa mbäją bi xifi di däp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nɛ bi hyu yʉ́ mbʉi ʉ yʉ ngʉrpa mbäją nɛ bi xifi di un ra mbɛti. Nɛ bi mbenc'a ra Judas bʉya mi honi jąm'bʉ di dä a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nu rá mbʉdi ra pa ra dąmpɛti ngue ran dąbaxjua i ts'i ra thuhmɛ hin'yʉ rá ixi, nɛ i ho ra t'ʉdɛ'yo. Nɛ nu yʉ́ xädi ra Jesús bi 'yɛ̨mbi: ―Hapʉ guí ndeje ga hoje ran ts'ihmɛ ra mbaxjua ga sihʉ, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nɛ nubʉya bi xi ʉ yoho yʉ́ xädi: ―Ni mbɛ bʉ ja ra dąhnihni Jerusalén, nɛ nu'bʉ gá nuui bʉ n'da ran 'yohʉ i tu n'daxaro ra dehe gui tɛnui bʉ da zøni. ");
INSERT INTO otmNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nɛ nu'bʉ gá sømhbʉ gui 'yɛ̨nui a ra mɛngu bʉ: “Nu'a ra Hmu bá pɛngähe ngue ga än'nahe hapʉ i ja a ra cuarto ngue ga sihe ran ts'ihmɛ ra mbaxjua,” gui 'yɛ̨nui. ");
INSERT INTO otmNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nɛ nu'a bʉya da 'yut'aui n'da ra cuarto i ja bʉ magąts'i xʉn ndoho nɛ mahoqui. Guepʉ ja gui hocui bʉ a ran sihmɛ ga sihʉ, bi 'yɛn'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bi mba yʉ́ xädi bʉya nɛ bi zøm bʉ ja ra dąhnihni Jerusalén nɛ bi dįm bʉ gätho 'bɛ'a xi sifi. Gätho bi hocpʉ 'bɛ'a da zi bʉ 'bʉ bin de, nɛ bi mbeng bʉ 'bʉh ra Jesús bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nu'bʉ min de ts'ʉ, bi mbähä ra Jesús 'dɛ'mayoho yʉ́ xädi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Gätho bin sihmɛ ʉ. Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Majuąni dí xi ahʉ, dí sihmɛhʉ ua n'da gue di dägä, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nu yʉ́ xädi bʉya bi du yʉ́ mbʉi, n'da ngu n'da bi 'yänni: ―Ha guecä, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nɛ nu'a ra Jesús bi dąt'ʉ: ―Go gue'a n'da gue gue'ahʉ guí 'dɛ'mayoho ahʉ gue dí comh ma mbohi'be. ");
INSERT INTO otmNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Majuąni nugä ngue dán ją'igä ua ja ra ximhäi, ga tugä tengu nt'o't'i nanguecä. Pɛ í huɛ̨hi maha a ran 'yohʉ ngue di dägä. Man'da xʉn ho 'bʉ hin xtim 'bʉ a, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Gätho na sihmɛ ʉ bi hyąc man'da ra hmɛ ra Jesús, bi un ra jamadi Oją, bi xɛni nɛ bi darpa yʉ́ xädi bʉya. ―Dami sihʉ na. Guehna nam bøn'a ma ngøc'yɛigä na, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nɛ bi dɛc'a ra vaso mi po a nząi mi si ʉ. Bi un ra jąmadi Oją nɛ bi un'dʉ bʉya, bi zi n'da ngu n'da ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","―Guehna tengu 'bʉ ma jigä na, i øt' ra 'da'yo nhogui, dim fäni dí yąnba yʉ́ te yʉ ją'i 'bʉcua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Majuąni dí xi ahʉ, hin ga si man'da ra gui uva ja gue'bʉ bi zøn ra pa ga si ma'da'yo bʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nɛ bin tu a n'da rá thuhu Oją ʉ bʉya. Bi bøm bʉ mi sihmɛ ʉ nɛ bi mba bʉ ja ra nyuni Olivos. ");
INSERT INTO otmNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Nu'ahʉ dí pącä ngue gui 'dahmbʉ, gui sogahʉ nán xui ya, tengu nt'o't'i bʉ ja rám hman Oją i ɛ̨na: “Ga ho ra mbändɛ'yo nɛ din 'uɛ̨xt'ʉ yʉ́ dɛ'yo,” i ɛ̨m bʉ ja rá t'ohni, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pɛ nu'bʉ dá thąmbɛ̨nigä dan tįmhbʉ bʉ Galilea, bi 'yɛ̨mp'ʉ yʉ́ xädi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nu'a ra Pedro bi 'yɛ̨n'a: ―Madague a gätho da 'dah ya 'da, pɛ nugä hin ga soc'i'i. ");
INSERT INTO otmNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nu ra Jesús bi dą'a bʉya: ―Hąha, dí pacä 'bɛ'a gui 'yøt'a ra xui jabʉya, ná hyundį xqui cøngä 'bʉ bi mbah ná yondį ra øni, bi 'yɛ̨n a. ");
INSERT INTO otmNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pɛ nu'a ra Pedro man'da nts'ɛdi bi 'yɛ̨n'a: ―Nugä hin ga cøn'a i madague'bʉ 'darpʉ ga tuui, bi 'yɛ̨mbi. Nɛ 'da'angu bi ma gätho ʉ mi'da yʉ́ xädi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nɛ bi yʉrpʉ ja ra nuądøni Getsemaní guepʉ ja ra nyuni Olivos. Nu ra Jesús bʉya bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Hyuhmbʉ ua gätho ahʉ, 'bɛ dán yągä'be Oją ua nan jongua ts'ʉ, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nɛ nubʉya bi zixa ra Pedro, nɛ ra Jacobo, nɛ ra Xuua. Nɛ nu ra Jesús ɛ̨mmɛ bi hyundumbʉi nɛ bin su. ");
INSERT INTO otmNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nɛ bi 'yɛ̨mp'ʉ: ―Ɛ̨mmɛ tu ma mbʉi, ɛ̨na da hyog ra dumbʉi. Gui cohmbʉ ua nɛ gan äthąhʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nɛ bi mba bʉ njom bʉ ts'ʉ. Bin dąnyahmu bʉ ja ra häi bin yąui Oją, gue'bʉ da zä hin da nu ran ʉnbi a da nu. ");
INSERT INTO otmNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nɛ bi 'yɛ̨na: ―Ma Ta i, hin te guí hɛ̨mbi, gätho da zä gui 'yøt'e. Dami 'uegä a ran ʉnbi. Pɛ hin dín nde gue gue'a ma pähä zɛhɛ ga øt'ä pɛ gue'a go guí nde da t'øt'e, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nɛ bi mbeng bʉ xi go ʉ hyu nɛ bi 'yɛ̨mp'a ra Pedro: ―Hague grá Simón, ha guí ąha. Ha hingui sä xquin äthą n'da ora. ");
INSERT INTO otmNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Damin äthąhʉ nɛ gui 'yäfʉ Oją ngue gui sɛrbahʉ 'bɛ'a di bɛ̨n'nahʉ ra zįthu. Nu rá mbʉi n'da ja ra pähä nangue ran ho, pɛ nu rá ngøc'yɛi n'da xʉn güent'i a, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nɛ bi mbeng mahøn'a ra Jesús bin yąui Oją nɛ guexta'a bi xifi. ");
INSERT INTO otmNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nɛ nubʉya bi mbeng bʉ bá co ʉ hyu nɛ bi dįm bʉ i ąha nguetho ɛ̨mmɛ mí ndet'ąha ʉ. Janangue nu'bʉ mi zo ʉ hingui pądi 'bɛ'a dí dą ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ná hyųndį bán yąui Oją, 'bʉ mam bá pengbʉ bá co ʉ hyu, nɛ bi 'yɛ̨mp'ʉ: ―Ąhmahʉ ya, damin säyahʉ ya, bi 'yɛ̨n'a. Nuya bi zøn ra ora ngue da mba ma dägä bʉ 'bʉh yʉ ts'om'bäi, nugä ngue dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dami ndanshʉ, ga mbähä dan c'athʉ a di dägä, ya häntua, bi 'yɛ̨mp'ʉ yʉ́ xädi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gätho ná yąhʉ yʉ́ xädi 'bex bi zøm bʉ ra Judas, gue'a n'da rá xädi. Nɛ xʉn ngu yʉ ją'i bi zix'a, mi hą yʉ́ juai nɛ yʉ ts'ąt'ɛgui. Nɛ gue'ʉ yʉ́m 'bɛhni yʉ ngʉrpa mbäją nɛ yʉ xänbate niją nɛ yʉ dąc'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nɛ nu'a ra Judas ya xí xi ʉ: “Nu'a ga sʉspa rá 'yogu gue a ra Jesús a, 'bex guim bɛnthʉ bʉya nɛ gui sixhʉ, nɛ hin gui thøhmbʉ,” xi 'yɛ̨mp'ʉ min 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Janangue a nu'bʉ mi zøpʉ mi 'bäh ra Jesús: ―Xänbate i, xänbate i, bi 'yɛ̨mbi. Nɛ bi zʉspa rá 'yogu. ");
INSERT INTO otmNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","'Bex bi bɛnt pʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nɛ 'bex bi c'o'ts' rá juai a n'da min 'yohʉ ra Jesús nɛ bi zɛcpa rá zagu rá 'yɛ̨hɛ ra dąmbäją. ");
INSERT INTO otmNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ bi bɛnt'i: ―Ha guí ɛ̨mhbʉ drá bɛ̨gä ngue guá hąhʉ ni juaihʉ nɛ ni zahʉ ngue gui bɛntcahʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gätho yʉ pa dám 'bʉhmbʉ, dá xän'nahʉ bʉ ja ra dąnija nɛ hin gá bɛntcahʉ bʉ. Pɛ ja xi jabʉ thoho, ngue din ja a nt'o't'i bʉ ja rám hman Oją ngue mi hma din ja, bi t'ɛ̨mp'ʉ yʉ́m 'bɛhni yʉ mbäją. ");
INSERT INTO otmNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pɛ nu'ʉ yʉ́ xädi bʉya gätho bi 'dagui, bi zopʉ a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hønt'a n'da ra ts'ʉnt'ʉ bi dɛn'na 'bʉ mi ts'ix a ra Jesús, dim pät'a ra the'bø't'e, nɛ mí ɛ̨n ʉ nɛ'a xtám bɛnt'a. ");
INSERT INTO otmNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pɛ nu'a hønt'a ra the'bø't'e bi bɛntpa a, nɛ bi 'dah pʉya nɛ bin 'yo mánxi bʉ ní mba. ");
INSERT INTO otmNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nu'bʉ mi mba ma dä bʉ 'bʉh ra dąmbäją, bim pɛti ʉ ma ngurbihe ngue yʉ ngʉrpambäją nɛ yʉ dąc'yɛi nɛ yʉ xänbate niją. ");
INSERT INTO otmNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nɛ nu ra Pedro bin tɛt'i, i 'bɛjua thoho bʉ ni mba, gue'bʉ go mi zøm bʉ mbo rá mbä't'i rá ngu ra dąmbäją, nɛ bi hyuhmbʉ bʉ ʉ yʉ asmayo niją, bin tąspihʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nu yʉ ngʉrba mbäją nɛ gätho ʉ mi'da i øt' ran juąnbate, mi honi to'o da ma xʉn ho 'bɛpʉ dí yąp'a ra Jesús ngue da hyo, nɛ madague'a xʉn ngu ʉ bin yą pɛ xinga n'da ʉ bi ma njuąntho. ");
INSERT INTO otmNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Xʉn ngu bi man yʉ fɛhni pɛ him bin tįn yʉ́m hma. ");
INSERT INTO otmNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Xø bi ndants'ʉ 'da mahøn'a bi zänba man'da ra fɛhni ʉ, nɛ bi 'yɛ̨n ʉ: ");
INSERT INTO otmNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nuna ran 'yohʉ bi ma nɛ bi 'yɛ̨na, “Nugä ga yø't' ra niją ua, nt'øt'e yʉ́ 'yɛ yʉ ją'i, nɛ nu'bʉ ná hyupa ga høcä n'da ngue hinga nt'øt'e yʉ́ 'yɛ yʉ ją'i,” bi 'yɛ̨nna ran 'yohʉ, nɛ nugähe dá øhmbe 'bʉ mí 'yɛ̨nna, bi 'yɛ̨m bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pɛ xinga gue'ʉ bin tįn ʉ yʉ́m hman ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pɛ nu ra Jesús bin hɛ̨tho. Njo'o to bi dąti. ");
INSERT INTO otmNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nu'a ra ngʉrpa mbäją bi 'yän mahøn'a: ―Ha gue'e grá Cristo. Ha gue'e rá Ts'ʉnt'ʉ i Oją nuįxte rá ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nu ra Jesús bi dąti: ―Guecä, nɛ guin nujʉ, nugä ngue dán ją'igä ua ja ra ximhäi, ga com'be rá ts'ɛdi Oją madą rá ts'ɛdi. Nɛ guin nujʉ 'bʉ bá pengä, ba ɛ̨cä bʉ ja yʉ güi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pɛ nu'a ra dąmbäją bi dʉnsɛ rá pahni, ɛ̨mbi hingui ɛ̨spa Oją ra Jesús nangue a bi ma. Nɛ bi 'yɛ̨m bʉya: ―Ya hin ga homhbʉ mi'da yʉ testigo, ");
INSERT INTO otmNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","nɛ dá øhmbʉ ya ngue hingui ɛ̨spa Oją na ran 'yohʉ. 'Bɛ'a guí mamhbʉ ga ørpahʉ ya, bi 'yɛ̨n a ra dąmbäją. Nɛ gätho 'da'angu bi man ʉ ngue di un ran ts'ɛmbi ngue da hyo. ");
INSERT INTO otmNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nu'ʉ 'da bʉya bi zox'a ra Jesús, nɛ bi gorpa rá dä, nɛ bi mbɛ'mi nɛ bi 'yɛ̨mbi, “Grá pøngahyą, man ya, to'o bi mbɛp'a'i,” bi 'yɛ̨n ʉ. Nɛ nu yʉ asmayo bʉ niją ɛ̨mmɛ bi mbɛmp'a rá hmi. ");
INSERT INTO otmNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nu'bʉ mim 'bäpʉ ra Pedro bʉ mbo ra mbä't'i, bi thopʉ n'da ra xisu ngue rá 'yɛ̨hɛ ra dąmbäją. ");
INSERT INTO otmNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nɛ bi nu'a ra Pedro din tąspi, bi hyɛ̨'t'i nɛ bi 'yɛ̨mbi: ―Ɛ̨na nɛ'e gmín 'yohʉ ra Jesús ra mɛngu bʉ Nazaret, bi 'yɛ̨mp'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pɛ nu'a ra Pedro bin cøni. ―Hin dí pądi 'bɛ'a nam bøn'a guím ma, bi 'yɛ̨n a ra Pedro. Nɛ bi 'uegue bi mba bʉ hänt ra goxthi. Nɛ bi mbah ra tamfø bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ná ya'a ts'ʉ bʉya xø bi thopʉ ra 'yɛ̨hɛxisu bʉ 'bäh ra Pedro, nɛ bi 'yɛ̨mp'ʉ 'bʉpʉ: ―Nuna ran 'yohʉ, min 'yohʉ ʉ mi tɛn'na ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pɛ nu'a ra Pedro bin cøni mahøn'a. Ná ya'a ts'ʉ bʉya, guesɛ ʉ mí 'bʉpʉ mi 'bäh ra Pedro bi 'yɛ̨n ʉ: ―Majuąni guín 'yohʉ ʉ nguetho grá mɛngu Galilea nɛ 'da igu bʉ gná yąhʉ ʉ, bi t'ɛ̨mp'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nu'a ra Pedro bʉya bi 'yɛ̨mp'ʉ: ―Nu'bʉ him majuąni dí xi ahʉ, Oją da zɛgbä, janangue dí xi ahʉ, hin dí pącä a ran 'yohʉ guí mamhbʉ, bi 'yɛ̨n a. ");
INSERT INTO otmNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","'Bex bi mbah ná yondį ra tamfø bʉya. 'Bex bi bɛ̨n a ra Pedro 'bɛ'a xí xih ra Jesús ngue xí 'yɛ̨mbi: “Dí pącä ngue ná hyundį xqui cøngä 'bʉ bi mbah ná yondį ra øni,” xí 'yɛ̨mp'a ra Jesús. Nɛ nu'bʉ mi bɛ̨n a xí 'yøt'e, bi du rá mbʉi ra Pedro nɛ 'bex bin zoni. ");
INSERT INTO otmNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nu'bʉ t'ʉxudi tho, nu yʉ ngʉrba mbäją nɛ yʉ dąc'yɛi nɛ yʉ xänbate niją nɛ gätho ʉ mi'da ma ngʉrbihe dyʉ́ judíohe, bin yąsɛ ʉ. Nɛ nubʉya bi zix a ra Jesús ngue di däp'a ra Pilato. Bin thą't' 'bʉ mi zits'i. ");
INSERT INTO otmNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nɛ nu ra Pilato bi 'yän'na ra Jesús: ―Ha gue e grá hmuts'ʉt'abi yʉ judío, bi 'yɛ̨mp'a. Bi dą a ra Jesús: ―Gue'a guím ma, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nɛ nu yʉ ngʉrpa mbäją ɛ̨mmɛ bi yąpi. ");
INSERT INTO otmNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Janangue a nu ra Pilato bi 'yän'na ra Jesús mahøn'a, bi 'yɛ̨mbi: ―Hanja hin ni thątya i di yąpi'i. Nɛ xʉn ngu 'bɛ'a gätho i xi'i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pɛ nu ra Jesús guexta'a him bi dąt'a ra Pilato. Janangue'a nu ra Pilato bi hyonya thoho. ");
INSERT INTO otmNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nu'a ra pa ram pɛti ra mbaxjua, ząi di thø a n'da ra ofädi ra Pilato hønt'a go nda'a da man yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nɛ min ofädi n'da ran 'yohʉ i Barrabás, 'darpʉ mi ofädihʉ ʉ 'da'ingu bi 'yøthʉ ngue bin hote ʉ, bi dʉm'ma n'da ra sʉi. ");
INSERT INTO otmNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nu'bʉ mi zøh yʉ ją'i xʉn ngu bʉ mi 'bʉh ra Pilato, nu'ʉ bi xih ra Pilato di thøcpa n'da ra ofädi tengu nząi bi 'yøt' 'bʉ ra pa ram pɛti. ");
INSERT INTO otmNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Janangue a nu ra Pilato bi 'yɛ̨mp'ʉ: ―Ha gue'a ni hmuts'ʉt'abihʉ gyʉ́ israelhʉ, gyʉ́ judíohʉ, ga thøc'ahʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nguetho mi pąh ra Pilato di sɛya thohoba ra Jesús yʉ ngʉrpa mbäją 'bʉ mi däp'a. ");
INSERT INTO otmNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pɛ nu yʉ ngʉrpa mbäją bi parpa yʉ ją'i gue'a ra Barrabás da 'yäh yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nu ra Pilato xø bi 'yɛ̨mp'ʉ mahøn'a: ―Xina ni hmuts'ʉt'abihʉ, gyʉ́ israelhʉ, gyʉ́ judíohʉ, 'bɛ'a ga ørpä na bʉya, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nu yʉ ją'i bʉya nts'ɛdi bi 'yɛ̨n ʉ: ―Go gui cuarpʉ ja ra pont'i na ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pɛ nu ra Pilato bi 'yɛ̨mp'ʉ: ―'Bɛ'a gue man ts'o xʉ 'yøt'na, bi 'yɛ̨mp'ʉ. Nɛ nu'ʉ yʉ ją'i man'da nts'ɛdi bi 'yɛ̨n ʉ: ―Go cuarpʉ ja ra pont'i na, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nu ra Pilato bi nde da 'yørpa rá pähä yʉ ją'i, janangue guehma go bi thøcpa a ra Barrabás. Nɛ bi manda da mba m'bɛi a ra Jesús nɛ da mba ma cuati bʉ ja ra pont'i. ");
INSERT INTO otmNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nu yʉ dofʉi bʉya, bi zixa ra Jesús bʉ mbo guepʉ ja yʉ́n säya yʉ dofʉi, nɛ bi zo ʉ gätho yʉ́ mindofʉihʉ 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nɛ bi mba ma hete n'da ra pahni xʉn jʉpoi a ra Jesús ngue tengu he yʉ ts'ʉt'abi, nɛ nts'ɛdi bi mba ma huspi n'da ra corona á m'be yʉ 'yʉ'uįni nguetho bi den thoho. ");
INSERT INTO otmNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nɛ bi zɛngua ʉ nɛ bi 'yɛnspa yʉ́ biba ʉ: “Damim 'bʉmanho gra hmuts'ʉt'abi yʉ judío,” bi 'yɛ̨mp 'bʉ mi denthoho. ");
INSERT INTO otmNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nɛ bi dɛspa rá yą yʉ za nɛ bi zots'i, nɛ bin dąnyahmu, ɛ̨na i thąnde pɛgue bi denthoho. ");
INSERT INTO otmNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nu'bʉ mi jua'a bi denni bi tonspa a ra pahni xʉn jʉpoi nɛ bi het'a rá pahni zɛhɛ. Bi gʉc pʉya ngue bi zits'i da 'døm'pʉ ja ra pont'i. ");
INSERT INTO otmNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nɛ nu'bʉ mi mba bʉ 'yu, bin c'athʉ ra Simón, ra mɛngu bʉ Cirene, rá ta ra Alejandro nɛ ra Rufo, bí 'yɛ̨ a huąhi a. Nɛ nu yʉ dofʉi bʉya bi 'yørpa ra ts'ɛdi a ra Simón da duspa rá pont'i a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nɛ guepʉ ja ra nyuni Gólgota ní ts'ixa ra Jesús. Nu'a Gólgota in nde da ma “ra Nyuni Yąxmu.” ");
INSERT INTO otmNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nɛ nu'bʉ mi zøm bʉ, bin t'un ra vino ngue ma uąnts'i n'da ra 'yɛ̨thi xʉn ju a ra Jesús. Pɛ nu'a him bi zi a. ");
INSERT INTO otmNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nɛ nu'bʉ mi 'døm'pʉ ja ra pont'i bʉya, nu yʉ dofʉi bi 'yøt'a n'da ran tąha ʉ nangue yʉ́ he ra Jesús ngue i nde da bądi nda'a ní 'bø't'e da gąxa n'da ngu n'da. ");
INSERT INTO otmNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gʉto xudi 'bʉ mi mba n'dø'mi bʉ ja ra pont'i a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nɛ mán t'o't'i bʉ ja ra pont'i a í yąp'a bi 'yɛ̨na, “Rá hmuts'ʉt'abi yʉ judío na,” ɛ̨m bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nɛ bi mba ma cuatihʉ ra Jesús yoho yʉ bɛ̨. 'Da a n'da yʉ pont'i. Nɛ bi 'bäm'pʉ ja rán 'yɛi a n'da nɛ bi 'bäm'pʉ ja rá gąha a man'da. ");
INSERT INTO otmNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nɛ nuna bin ja, mi mam bʉ ja rá t'ohni Oją maya'bʉ, bi 'yɛ̨na: “Da t'ɛ̨mbi ngue 'da'anguui ʉ yʉ dądits'oqui a.” ");
INSERT INTO otmNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nɛ nu yʉ ją'i bi thopʉ, bi ʉcpi nɛ bi denthoho, bi 'yɛ̨mbi: ―Ha hinga gue e gá ma ngue gui xo't' ma nijąhʉ nɛ hyupa tho gui hyøh mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sä gui cąpʉ ja ra pont'i ya 'bʉ, nɛ gan yąnsɛ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nɛ ximangutho bi man ʉ yʉ ngʉrba mbäją bin 'yɛ̨mp'ʉ: ―Nuna, bi yąnba yʉ́ te ʉ 'da, pɛ hingui sä din yąnsɛ ya. ");
INSERT INTO otmNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Gan nuhʉ ra Cristo, rá hmuts'ʉt'abi yʉ judío 'bʉ ba cąpʉ ja ra pont'i, gan nugähʉ, nɛ ga ɛ̨c'yɛihʉ bʉya, bi 'yɛ̨m 'bʉ mi denthoho. Nɛ ʉ mi cuathʉ bʉ, bi ʉcpa ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nu'bʉ mi zøn a huxhyadi bʉya bim 'bɛxui gätho ra häi, ja gue'bʉ mi zøn a hyunde bin nɛqui mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nɛ nu'a ra ora a ɛ xø i huxhyadi, nts'ɛdi bi mbah ra Jesús, bi 'yɛ̨na: ―Eloi, Eloi, lama sabactani, bi 'yɛ̨na. Nde da ma: “Ma Oją i, ma Oją i, hanja xcá hyɛga thoho.” ");
INSERT INTO otmNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nu'bʉ mi 'yø ʉ 'da 'bʉpʉ, bin 'yɛ̨mp'ʉ: ―Nuna, nzo a ra Elías, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nɛ bán ti a n'da mí hą n'da tengu ra fʉnjo xí 'yot'i, bi fospʉ ja ra vino xʉn ju, nɛ bi ndøct'a n'da ra xithi. Pi uąspa ra Jesús ɛ̨mbi da zi, nɛ bi 'yɛ̨mp'ʉ min 'yohʉ: ―Pɛ 'bɛ ga undä na, ga nuhʉ 'bʉ da zøh ra Elías di tongui, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pɛ nu'a ra Jesús nts'ɛdi bi mbafi nɛ 'bex bi du. ");
INSERT INTO otmNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nɛ nubʉ mbo ra dąniją 'bex gue bin xɛngui nde ra 'bø't'e mi ndam bʉ. Bá fʉh magąts'i nɛ bi zøtahäi a bin xɛni. ");
INSERT INTO otmNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nɛ nu'a rá hmu yʉ dofʉi, mi hɛ̨t'a ra Jesús bi mba 'bʉ mi du, nɛ bi 'yɛ̨na: ―Majuąni nuna ran 'yohʉ na, rá Ts'ʉnt'ʉ Oją na, bi 'yɛ̨n a ra hmudofʉi. ");
INSERT INTO otmNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nɛ mi 'bʉpʉ 'da yʉ xisu bʉ ma'ueni ts'ʉ, mi hant'a ra Jesús. Nu'a n'da ra Salomé a, nɛ nu'a man'da ra María, ra mɛngu Magdala, nɛ nu'a man'da ra María, rá mbe ra Jacobo nɛ ra José. ");
INSERT INTO otmNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Guehya yʉ xisu mi tɛn ra Jesús 'bʉ mi 'bʉpʉ Galilea nɛ mi fäts'i. Nɛ ʉ mi'da yʉ xisu bi dɛn 'bʉ mi mba bʉ Jerusalén, mi 'bäpʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nɛ ya bin de, nɛ mim bɛ̨ni da 'yäcpa n'dihi rá ngøc'yɛi ra Jesús nguetho mi ts'ʉtho da dʉ'ma ra pa ran ts'äya, nɛ nu ra pa ran ts'äya njongui sä da t'ä a. Janangue a nu ra José ra mɛngu Arimatea, bi hyut'anzambʉi bi mba bán yąui ra Pilato, bi 'yäp a rá ngøc'yɛi ra Jesús. Nu ra José n'da rá ngʉrbi yʉ ją'i israel, pɛ gue'a n'da majuąni mi ɛ̨c'yɛ̨i Oją nɛ mi tøm'ma ra pa di manda ua rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nu ra Pilato bi hyonya thoho 'bʉ mi sifi bi du ra Jesús. Nɛ nubʉya bi mbɛhna n'da ba si a rá hmu yʉ dofʉi ngue da 'yän 'bʉ majuąni ya bi du. ");
INSERT INTO otmNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nɛ nu'bʉ mi man a rá hmu yʉ dofʉi gue bi du, nu ra Pilato bi 'yɛ̨mp'a ra José: ―Da zä gui tuxa rá ngøc'yɛi ra Jesús 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nu a ra José bʉya, bi dän a n'da ra 'bø't'e nɛ bi mba bi tongba rá ngøc'yɛi ra Jesús, nɛ bi mbant'a ra 'bø't'e xi däi nɛ bi cʉ't' pʉ ja n'da ra hyądo gue ran 'yägui xí mba nthɛ̨qui bʉ ja n'da ra t'ʉmba'ye. Nɛ bi juaspa n'da ra xįndo xʉn ndoho bʉ ja rá goxthi ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nɛ nu'a ra María, ra mɛngu bʉ Magdala, nɛ man'da ra María ngue rá mbe a man'da ra José, bi nu hapʉ bi jät'i. ");
INSERT INTO otmNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nu'bʉ mi thoh ra pa ran ts'äya, nu'a ra María ra mɛngu bʉ Magdala, nɛ ra María rá mbe a man'da ra José, nɛ man'da ra xisu ngue ra Salomé, bi dän yʉ 'yɛ̨thi ngue yʉman'u ngue da mba bʉ ja ran 'yägui da gospa rá ngøc'yɛi ra Jesús, tengu man t'øt'ehe dyʉ́ judíohe. ");
INSERT INTO otmNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nɛ nt'ʉxudi dą ndomingo 'bʉ mi bøx ra hyadi bi mba bʉ ja ran 'yägui ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nɛ bin 'yɛ̨mzɛhɛ ʉ: ―To'o da zä di 'uec'a ra do bí juaxpʉ ja ra hyądo, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nɛ nu'bʉ mi zøm bʉ bi nu bʉya, ya ma 'ueque a ra do, ngue xʉn ndoho. ");
INSERT INTO otmNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nɛ nu'bʉ mi yʉrpʉ ja ra hyądo bʉya, bi nu n'da ran 'yohʉ mi hupʉ rá hyo ngue rán 'yɛi ra hyądo, mi he n'da ra pahni xʉn t'axi. Nɛ nu'ʉ yʉ xisu bin su 'bʉ mi nu. ");
INSERT INTO otmNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pɛ nu'a, bi 'yɛ̨mp'ʉ: ―O guín suhʉ. Dí pącä guí homhbʉ ra Jesús ra mɛngu Nazaret, ngue bi 'døm'pʉ ja ra pont'i, pɛ bi dąmbɛ̨ni a, njo'o ua ya. Dami nuhʉ ua mí 'bɛni, bi t'ɛ̨mp'ʉ yʉ xisu. ");
INSERT INTO otmNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nɛ xø bi 'yɛ̨na: ―Pɛ nuya ni mbähä gui xihmbʉ ra Pedro nɛ'ʉ mi'da yʉ́ xädi nɛ gui 'yɛ̨mfʉ gui tįmhbʉ bʉ Galilea a ra Jesús tengu tho bi xi ahʉ,” bi t'ɛ̨mp'ʉ yʉ xisu. ");
INSERT INTO otmNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nɛ nu'ʉ yʉ xisu bʉya 'bex bi bøn'a n'dihi bʉ ja ran 'yägui nɛ bá ɛ̨ ʉ, ɛ̨mmɛ di fɛt'ʉ nguetho bin su, nɛ njo'o to min nde din yąhʉ ngue bin su. ");
INSERT INTO otmNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nu'a ra Jesús bi dąmbɛ̨ni 'bʉ xudi thoho ndomingo. M'bɛt'o thoho bin tįmmi ra María ra mɛ̨ngu bʉ Magdala, ngue gue'a xí hyønba thi yoto yʉ zįthu. ");
INSERT INTO otmNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nɛ nubʉya bi mba a ra María, bá xip'ʉ yʉ́ xädi ngue bi dąmbɛ̨ni a ra Jesús, nɛ mí zon'ʉ ngue tu yʉ́ mbʉi, ngue bi du ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nɛ nu'bʉ mi 'yøde ngue bi dąmbɛ̨ni nɛ bi man a ra María ngue bi nusɛ, pɛ him bi 'yɛ̨c'yɛi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nubʉya bin tįmhbʉ mi yoho yʉ́ xädi a ra Jesús bʉ 'yu, 'dan'yo ts'ʉ bʉ án nu ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nɛ nu'ʉ, bi mba ʉ bʉya, bá xi ʉ mi'da ngue xø bi nu mahøn'a, pɛ ngutho him bi 'yɛ̨c'yɛ̨i a bi man ʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Rán zɛgui thoho bin tįmhbʉ gätho 'dɛ'ma'da yʉ́ xädi ra Jesús. Mi hupʉ ja ra mɛxa ʉ. Nɛ bi zʉ ʉ nguetho him bi 'yɛ̨c'yɛi a xi sifi ngue bi dąmbɛ̨ni a. ");
INSERT INTO otmNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nɛ nubʉya bi 'yɛ̨mp'ʉ: ―Ni mbähä gätho na ngʉni ra ximhäi, gui mamhbʉ ran ho ma'da'yo. Hønbʉ go hapʉ i 'bʉh yʉ ją'i gui xihmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu'a to'o da 'yɛ̨c'yɛi nɛ din xixyą, gan yąnba rá te a. Pɛ nu'a hin da 'yɛ̨c'yɛi, da nu ran ʉnbi gätho yʉ pa maząi a. ");
INSERT INTO otmNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nɛ nu'ʉ to'o da 'yɛ̨c'yɛigui xʉn ngu yʉ hmɛpya ga japi da 'yøt'ʉ. Nangue ma ts'ɛdigä da hyøn a thi yʉ zįthu in 'yohʉ 'da yʉ ją'i, nɛ din yą 'dahma 'dan'yo yʉ nde, ");
INSERT INTO otmNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nɛ nu'bʉ da bɛnt'ʉ yʉ pozʉ nte da ja ʉ, ngutho 'bʉ da zi ra 'yɛ̨thi ngue ran dąte, nte da ja ʉ. Nɛ di japi da yąn ʉ yʉn zäman'ʉ 'bʉ da gäspa yʉ́ 'yɛ, bi 'yɛ̨mp'ʉ yʉ́ xädi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nɛ nu'bʉ mi gua a bi xih yʉ́ xädi, bi ts'ix bʉ mahɛ̨ts'i a ra Hmu, nɛ 'darpʉ ní conhui rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nu'ʉ yʉ́ xädi bi mba bʉya bi man rám hman Oją hønbʉ go hapʉ bi mba. Nɛ nu ra Hmu bi japi da zä da ma xʉn ho nɛ bi japi da 'yøt' yʉ hmɛpya 'dahma da 'yɛ̨c'yɛi yʉ ją'i yʉ́m hman ʉ. Nɛ hønt'a dí xi ahʉ ya.");
INSERT INTO otmNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dí pącä xʉn ngu yʉ ją'i bi 'yo't' yʉ søcuą ngue i man'a bin ja 'bʉ mím 'bʉcua ja ra ximhäi ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nu'ʉ bi 'yo't'ʉ, tengu thoho bi xängahʉ ʉ bi nusɛ 'bʉ mi 'yøt' rá 'bɛfi ra Cristo, nɛ tengu thoho bi man'ʉ hønbʉ go hapʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nɛcä dra Lucasgä dí o't'na ra søcuą ngue im man'a bin ja, nɛ dí pɛn'na i, hague Teófilo, ma amigo i xʉn ho. Nɛ dá änzɛhɛ yʉ ją'i to'o bi nu 'bɛ'a gä bin ja. Nɛ ɛ̨mmɛ dá hongä 'bɛ'a nt'o't'i gä mi'da yʉ søcuą, janangue'a da bømanho 'bɛ'a dí o't'ä. ");
INSERT INTO otmNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nguetho dín nde gui pądi xʉn ho ngue majuąni a bi sän'na i. ");
INSERT INTO otmNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nu'ʉ yʉ pa min ts'ʉt'abi ra Herodes bʉ ja ra xɛqui Judea, mi 'bʉpʉ n'da rá mbäją yʉ judío, ra Zacarías a. Madim pɛhmbʉ n'dan nɛts'i yʉ mbäją bi dʉm'ma ra mbäją Abías. Nu'a ra Elisabet, rá xisu ra Zacarías, gue'a n'da rám bom'bɛto ra Aarón a, ngue ra hmumbäją maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nu'a ra Zacarías nɛ ra Elisabet, gätho yonją'i, Oją bi numanho ʉ, nguetho xʉn ho yʉ́ mbʉi, nɛ mi øt'e gätho yʉ́n t'ɛ̨di Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nu ra Elisabet nɛ ra Zacarías, xʉn dąc'yɛi ʉ nɛ xínga n'dandį mi 'bʉh rá t'ʉhni a ra Elisabet. ");
INSERT INTO otmNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Nɛ nu'bʉ xøn zøn ra pa dim pɛpʉ ja ra dąniją ʉ n'dan nɛts'i yʉ mbäją bi dʉ'ma ra Abías, janangue'a madim pɛpʉ ra Zacarías. Nɛ ząi mi thahna n'da ra mbäją, ngue da yʉrpʉ man'da mbo ra dąniją da 'yuh yʉ xiza yʉmanho. Nɛ gue'a ra Zacarías bi mba nthahni ngue da yʉrpʉ mbo. ");
INSERT INTO otmNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nɛ xʉn ngu yʉ ją'i mi 'bäpʉ thi mi yąhʉ Oją 'bʉ ra ora bi 'yuh ra xiza ra Zacarías. ");
INSERT INTO otmNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nɛ 'bex bi zø a n'da rám 'bɛhni Oją bʉ mi 'bäh ra Zacarías. Nɛ mi 'bäpʉ rá hyo rán 'yɛi ra mɛxa guepʉ mí uh yʉ xiza. ");
INSERT INTO otmNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nu'bʉ mi nu a bʉya, ɛ̨mmɛ bin su nɛ hingui pądi 'bɛ'a da bɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nɛ nu'a rám 'bɛhni Oją bi 'yɛ̨mbi: ―O guín su Zacarías, nguetho bi 'yø Oją 'bɛ'a guí äpi, nangue ni xisu ra Elisabet din hąt'ʉhni nɛ dim 'bʉ a n'da rá ts'ʉnt'ʉ, nɛ gui xip rá thuhu dí Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nɛ gan johya nɛ ɛ̨mmɛ da hyu ni mbʉi, nɛ xʉn ngu yʉ ją'i din johya 'bʉ bim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nguetho Oją di un ra 'bɛfi nuįxte a. Nɛ nu'a, hin da zi ra vino xínga gue'a ra sɛ̨i, nɛ din 'youi rá Hogandąhi Oją gue'bʉ go bim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nɛ nu'a rá 'bɛfi da 'yøt'e, gue'a dí japi xʉn ngu yʉ ją'i israel di päh yʉ́n 'yomfɛ̨ni nɛ da 'yɛ̨c'yɛi Oją ra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nɛ nu'a ni t'ʉhni bam 'bɛt'o a 'bʉ bá ɛ̨h ra Hmu mahɛ̨ts'i, nɛ din ja rá ts'ɛdi tenguthoho ra pøngahyą Elías, nɛ di japi din hocpahʉ yʉ́ t'ʉhni ʉ yʉ ją'i. Nɛ nu'ʉ nząi hingui øde 'bɛ'a pa nsifi, di japi da 'yøde. Nɛ nangue rám hman ra Xuua di päh yʉ́n 'yomfɛ̨ni yʉ ją'i n'dahma da zä da zimanho ra Hmu 'bʉ bá ɛ̨hɛ, bi t'ɛ̨mp'a ra Zacarías 'bʉ min yąui rám 'bɛhni Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nu ra Zacarías bʉya: ―Hague dán zä ga pącä a guí xiqui nguetho xtán dąc'yɛigä nɛ'a ma xisu, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nu rám 'bɛhni Oją bi 'yɛ̨mp'a bʉya: ―Nugä dí Gabriel nɛ dí 'bäcä bʉ ja rá hmi Oją, nɛ Oją bá pɛngä gue ga xi a ran ho din ja ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pɛ nuya, gan gore ya, nguetho hin guí ɛ̨c'yɛi a dí xi i. Nuya hin da zä gan yą astague'bʉ go bin ja a dá xi a i, nguetho gätho din ja a dá xi a i, bi 'yɛ̨n'a rám 'bɛhni Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nu yʉ ją'i mi 'bäpʉ thi, mi tø'ma ra Zacarías, nɛ him mi pą'ʉ hanja him 'bexque pøni. ");
INSERT INTO otmNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nɛ nu'bʉ mi bøm bʉ ra Zacarías hingui sä din yą, hønt'a bi uąnda rá 'yɛ. Nu yʉ ją'i bi bąh pʉya ngue bi nu n'da ran t'uti bʉ mbo. ");
INSERT INTO otmNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nɛ nu'bʉ mi guah yʉ pa dim pɛpʉ ra Zacarías bi mba rá ngu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nɛ bin hąt'ʉhni ra Elisabet, nɛ nubʉya hin hapʉ í mba an cʉt'a ząna, bim 'bʉtho bʉ rá ngu. Nɛ bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Xʉn ngu rá mate bi 'yørcä Oją, nuya him man da zangä yʉ ją'i nguetho dim 'bʉ'a n'da ma t'ʉhni ya,” bi 'yɛ̨nsɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nu'bʉ mi tho i cʉt'a ząna, nu'a Oją bi mbɛhn mahøn'a a rám 'bɛhni ngue í Gabriel. Bi mbɛhn pʉ ra hnini Nazaret bʉ ra xɛqui Galilea. ");
INSERT INTO otmNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nu'a, bi zøm bʉ mi 'bʉ a ra María. Nu ra María xínga n'dandį bin yąui n'da ran 'yohʉ, pɛ ya mi än'na ra José, n'da rám bom 'bɛto ra ts'ʉt'abi David a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nu rám 'bɛhni Oją bi zɛngua, bi 'yɛ̨mbi: ―Nu'i María ya bi 'yøt'a n'da rá mate Oją nɛ guín 'youi a. Pɛ man'da bi jąp'a Oją xinda gue'ʉ gätho mi'da yʉ xisu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nu'a ra María 'bʉ mi nu rám 'bɛhni Oją, bin su nɛ bin 'yomfɛ̨ni 'bɛ'a ním bøn'a bi sifi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nu rám 'bɛhni Oją bi 'yɛ̨mp'a bʉya: ―O guín su María nguetho guín 'youi rá mate Oją, ");
INSERT INTO otmNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","nɛ dim 'bʉ'a n'da ni Ts'ʉnt'ʉ nɛ gui xip rá thuhu ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nɛ nu'a, din ja rá ts'ɛdi nɛ da fądi ngue rá Ts'ʉnt'ʉ Oją tąte thoho rá ts'ɛdi. Nɛ nu'a Oją di japi din ts'ʉt'abi tengu rám bombøta ngue ra David. ");
INSERT INTO otmNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nɛ di manda yʉ ją'i israel gätho yʉ pa nɛ hin jąm'bʉ da guah rá ts'ɛdi a, bi 'yɛ̨n'a rám 'bɛhni Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nu ra María bi 'yɛ̨n'a: ―Hague dán zä din jabʉ nɛ hin jąm'bʉ dán yą'be n'da ran 'yohʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Pɛ nu rám 'bɛhni Oją bi 'yɛ̨mp'a: ―Nu rá ts'ɛdi rá Hogandąhi Oją di ja i gui tįn ni t'ʉhni, nɛ nu'a dim 'bʉi, rá Ts'ʉnt'ʉ Oją a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nɛ'a ni mɛni ra Elisabet xʉn dąc'yɛi a, pɛ dim 'bʉ a n'da rá ts'ʉnt'ʉ. N'dato ząna ya i hą'a rá t'ʉhni nɛ mi ɛ̨n yʉ ją'i ngue hin jąm'bʉ da dįn rá t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nu Oją gätho sä da 'yøt'a, hin'yʉ 'bɛ'a gue hingui sä da 'yøt'e, bi 'yɛ̨n'a rám 'bɛhni Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nu'a ra María bi 'yɛ̨n'a: ―Nugä rá 'yɛ̨hɛgä Oją, nu'bʉ gue'a in nde Oją, da 'yørque gätho guím ma, bi 'yɛ̨na. 'Bex bi mbeng mahɛ̨ts'i rám 'bɛhni Oją bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Nu'a ra María bʉya, 'bex bi mba bí zɛngua yʉ́ mɛni mí 'bʉpʉ ja yʉ nyuni bʉ ra xɛqui Judea, gue'a ra Zacarías nɛ rá xisu ra Elisabet. ");
INSERT INTO otmNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nɛ nu'bʉ mi mba ma zɛngua ra Elisabet, 'bexque bi 'yąn'a rá t'ʉhni mí o rá mbʉi. 'Bex bin 'youi rá Hogandąhi Oją ra Elisabet bʉya, ");
INSERT INTO otmNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nɛ bi 'yɛ̨na: ―Oją man'da bi jąp'i i María, xinda gue'ʉ mi'da yʉ xisu. Nɛ nu'a ni ts'ʉnt'ʉ dim 'bʉi, mająpi a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pɛ xʉn ngu ra mate gá 'yørque ngue gá zɛnguagui, nguetho gue'e rá mbe a ma Hmu. ");
INSERT INTO otmNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nɛ dí pądi gue'e rá mbe a ma Hmu nguetho nu'bʉ má øcä nin zɛngua, 'bex bin johya a ra t'ʉhni o ma mbʉi nɛ bi 'yąni. ");
INSERT INTO otmNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bi jąp'a Oją nguetho gá 'yɛ̨c'yɛ̨i a bi xi i, nɛ majuąni da 'yøt' Oją a bi xi i, bi 'yɛ̨n'a ra Elisabet, bi 'yɛ̨mp'a ra María. ");
INSERT INTO otmNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nu ra María bʉya bi 'yɛ̨spa Oją nɛ bi 'yɛ̨na: Ɛ̨mmɛ dí ɛ̨spa Oją ma Hmu, ");
INSERT INTO otmNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nɛ din johya ma mbʉi nangue Oją mam pørpate. ");
INSERT INTO otmNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nguetho Oją bi bɛ̨ngä ngue dra hyoya 'yɛ̨hɛgä, nɛ gätho yʉ ją'i da 'yɛ̨ngui dá tįngä rá mate Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Xʉn ngu ran ho bi 'yørca Oją madą rá ts'ɛdi, nɛ xʉn hotho a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nɛ da nu rá yembʉi to'o gätho da numansu a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nu Oją nuįxte tho yʉ́n t'øt'e, bi 'bɛrpa yʉ́ ts'ɛdi ʉ din yɛ̨zɛhɛ ngue im bɛ̨ni jasɛ yʉ́ ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nɛ bi 'bɛrba yʉ́ ts'ɛdi yʉ ts'ʉt'abi, nɛ go bi un yʉ́ ts'ɛdi yʉ ją'i thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nɛ bi japi da bą ʉ to'o i honi da bądi, pɛ nu'ʉ to'o him bi hyoni da bądi bi japi di 'bɛ'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nɛ nu Oją bi mbäxcahʉ ya ngue dyʉ ją'i israelgähʉ, ngue bi 'yɛ̨njʉ yʉ́ t'ʉhnigahʉ a, nɛ him bi pumbɛ̨ni a ran ho bi ma da 'yørcahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Pɛ bi 'yøt'e tenguthoho bi si a ra Abraham ta t'ørcahʉ, yʉ́m bom'bɛtojʉ, gätho yʉ pa maząi, bi 'yɛ̨n'a ra María 'bʉ mi 'yɛ̨spa Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nɛ nu'a ra María hyuzna bi gopʉ rá ngu ra Elisabet, m'bɛjua bi mbeng bʉ rá ngusɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nɛ bi zøn ra pa dim 'bʉ a rá ts'ʉnt'ʉ ra Elisabet. ");
INSERT INTO otmNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nɛ gätho yʉ́ mɛni nɛ yʉ́ mɛnguhʉ bin johya 'bɛ'a bi 'yørpa Oją a ra Elisabet, nɛ bi zøm bʉ rá ngu bi zɛngua a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nu'bʉ mi gua'an hyąto pa xím 'bʉ a ra t'ʉhni, bi mba nts'its'i da thɛcua rá xifani. Nɛ gätho ʉ mi 'bʉpʉ, bi ma da hyąnba rá thuhu rá ta ngue dí Zacarías. ");
INSERT INTO otmNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pɛ nu rá mbe bi ma ngue hin da zä, pɛgue jatho da hyux rá thuhu ngue dí Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nɛ gätho mi 'bʉpʉ bi 'yɛ̨na: ―Pɛ njo'o n'da ni mɛnihʉ í Xuua, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɛ nu'ʉ, bi uąn yʉ́ 'yɛ, bi 'yän'na rá ta: “'Bɛ'a rá thuhu a ni t'ʉhni,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nu rá ta bʉya bi 'yäh ra søcuą nɛ bi 'yo't'a n'da ram hma ngue bi 'yɛ̨na: “Dí Xuua a ma t'ʉhni.” ");
INSERT INTO otmNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Bex bi zä bin yą mahøn'a ra Zacarías bʉya, nɛ bi 'yɛ̨spa Oją a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nɛ bi hyonya thoho gätho mi 'bʉpʉ. Nɛ gätho yʉ ją'i mi 'bʉpʉ ja yʉ nyuni a ra xɛqui Judea bi 'yø a bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nɛ gätho bin 'yomfɛ̨nisɛ 'bɛ'a da 'yøt'a ra t'ʉhni, nguetho Oją bi jąpi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nɛ bin 'youi rá Hogandąhi Oją ra Zacarías, nɛ bim pøngahyą a, bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ɛ̨mmɛ dí ɛ̨spa Oją ra Hmu nguetho bi bɛ̨njʉ dyʉ ją'i israelgähʉ, dyʉ judíohʉ, ngue da yąnjʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nɛ nanguehna ma t'ʉhni bim 'bʉi, janangue'a dí pądi him ma ya'a ba pɛnga mam pørpatehʉ i ja rá ts'ɛdi, rám bom'bɛto ra ts'ʉt'abi David a. ");
INSERT INTO otmNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gue'a bi bɛ̨nba Oją ʉ yʉ́ pøngahyą maya'bʉ thoho, ");
INSERT INTO otmNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ngue bi ma da yąnjʉ nangue man sʉihʉ, nɛ nangue gätho ʉ i numan'ʉjʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pɛ nu Oją bi huɛ̨c'ʉ mam bombøtahʉ, nɛ him bi pumbɛ̨ni ran ho mi ɛ̨na da 'yørcahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nɛ majuąni da 'yøt' Oją a bi xih mam bombøtahʉ ra Abraham, ");
INSERT INTO otmNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ngue bi xifi da yąnjʉ nangue ʉ man sʉihʉ, nɛ hin ga su ga thąndehʉ a Oją bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Janangue da gohi xʉn ho ma mbʉihʉ bʉ dá nu a Oją, nɛ ga øthʉ ra hogam'bʉi bʉ ja rá hmi. ");
INSERT INTO otmNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nɛ nuna ma t'ʉhni, da 'yɛ̨mb yʉ ją'i rá pøngahyą Oją mahɛ̨ts'i, nɛ da xih yʉ ją'i di päh yʉ́n 'yomfɛ̨ni, da dø'ma ra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nɛ da xi ʉ da mba ma punbi yʉ́ ts'oqui, nɛ da mba nhyąni. ");
INSERT INTO otmNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gätho da 'yøt' Oją nguetho di huɛ̨gahʉ nɛ ba pɛngahʉ ra Hmu ngue guesɛ rán nɛqui ma mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nɛ gue'a di yorpa yʉ́ mbʉi ʉ i 'bʉpʉ ja ra 'bɛxui nɛ i 'yo bʉ ja rá 'yu ran dąte, nɛ da zixpʉ ja ran nɛqui, bi 'yɛ̨n'a ra Zacarías 'bʉ mim pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nɛ nu rá t'ʉhni, ngue ra Xuua, bin te mán zaqui nɛ bin te rá mbʉi nangue Oją. Nɛ nu'bʉ min te, bim 'bʉpʉ ja ra dąpo asta gue'bʉ go bi zøn ra pa bi dʉmp' rá 'bɛfi bi xi Oją, guepʉ 'bʉh yʉ́ mi'israelhʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nu'bʉ mím 'bʉh ra Jesús, gue'ʉ yʉ pa bin ja ra dąpede bi 'yøt'a ra hmuts'ʉt'abi ngue ra Augusto César. ");
INSERT INTO otmNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nɛ gue'ʉ yʉ pa bin ts'ʉt'abi ra Cirenio bʉ ja ra xɛqui Siria, nɛ gue'ʉ yʉ pa ja bi dʉ'mi bi 'yøt' ra pede ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gätho yʉ ją'i bi mba bʉ ja rá hnini zɛhɛ yʉ́m bombøta ngue da thuspa bʉ yʉ́ thuhu. ");
INSERT INTO otmNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Janangue nu ra José bi nɛxpʉ ja ra hnini Nazaret ngue ra xɛqui Galilea, nɛ bi mba bʉ ja ra hnini Belén ngue ra xɛqui Judea, nguetho guepʉ rá hnini a rám bombøta a ra José, ngue ra David. ");
INSERT INTO otmNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nɛ bi mba da thuspa bʉ rá thuhu. Bi mbɛ a ra María rá xisu. Pɛ nu'a ra María ya min hąt'ʉhni a. ");
INSERT INTO otmNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nɛ nu'bʉ mi zøm bʉ ja ra hnini Belén, bi zøn ra pa dim 'bʉh rá t'ʉhni bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nɛ bim 'bʉ a rá mbʉdi ts'ʉnt'ʉ a ra María ngue ra Jesús. Nɛ bi mbant yʉ bazu, nɛ bi cärpʉ ja rán ts'adɛthą yʉ fani bʉ ja ra ngumfani, nguetho hin'yʉ bʉ din säya bʉ ja n'da ra ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nu'a ra xui a bʉya, mi 'bʉpʉ häntho ra hnini Belén 'da yʉ mbändɛ'yo, madí jamansu yʉ́ dɛ'yo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Bex bi nu n'da rám 'bɛhni Oją ʉ, nɛ bi yorpʉ rán nɛqui Oją bʉ 'bʉi, nɛ ɛ̨mmɛ bin su'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pɛ nu'a rám 'bɛhni Oją bi 'yɛ̨mp'ʉ: ―O guín suhʉ, nguetho bá ɛ̨cä ga xi ahʉ n'da ram hma gue di ja ahʉ gan johyahʉ gyʉ́ ją'ihʉ ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nu bʉ ra hnini Belén, ngue rá hnini ra David, ja bim 'bʉ'a nim pørpatehʉ, gue'a ra Cristo ra Hmu bi ma ba pɛn'nahʉ Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nɛ nu'bʉ gá tįmhbʉ n'da ra 'uɛre xí järpʉ ja rá yänza yʉ fani m'bant'i yʉm 'bahni, gue'a gdí pąhmbʉ a bʉya, bi 'yɛ̨n'a rám 'bɛhni Oją 'bʉ mi 'yɛ̨mp'ʉ yʉ mbändɛ'yo. ");
INSERT INTO otmNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","'Bex bi nɛqui n'dan nɛts'i yʉ́m 'bɛhni Oją, bi 'yɛ̨spa Oją ngue bin tuhu, nɛ bi 'yɛ̨n'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nuįxte rá ts'ɛdi Oją mahɛ̨ts'i. Oją da hyurpa yʉ́ mbʉi gätho ʉ i 'bʉcua ja ra häi, hønt'a go to'o da hyąn'a rá mate, bi 'yɛ̨m 'bʉ min tuhu. ");
INSERT INTO otmNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nɛ bi mbeng mahɛ̨ts'i yʉ́m 'bɛhni Oją bʉya. Nɛ nu'ʉ yʉ mbändɛ'yo bin 'yɛ̨mp'ʉ bʉya: ―Ga mbähä bʉ ja ra hnini Belén, ga nuhʉ a bin ja ngue bi jajʉ ra Hmu ga pąhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bi mba n'dihi ʉ bʉya, nɛ bi dįm bʉ a ra María nɛ ra José nɛ ra 'uɛre. Nɛ nu'a ra uɛre mi o bʉ ja rá yänza ra fani. ");
INSERT INTO otmNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nɛ nu'bʉ mi nu'ʉ yʉ mbändɛ'yo bʉya, bi mam bʉ a xí xih rám 'bɛhni Oją nangue ra t'ʉhni bim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nɛ gätho ʉ bi 'yø'a bi man'ʉ yʉ mbändɛ'yo, bi hyonya thoho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pɛ nu'a ra María, bi bɛ̨m bʉ mbo rá mbʉi 'bɛ'a gätho bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nɛ nu yʉ mbändɛ'yo bi mbeng bʉya, nɛ bi 'yɛ̨spa Oją, ngue gätho bin ja'ʉ 'bɛ'a gätho bi sifi, nɛ xí nu. ");
INSERT INTO otmNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nu'bʉ mi gua'an hyąto pa xím 'bʉi, bi thɛcua rá xifani ra 'uɛre, nɛ bi thuspa rá thuhu dí Jesús, nɛ ngue'a xí xih rám 'bɛhni 0ją a ra María 'bʉ hin ní hyą rá t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nɛ nu'bʉ mí gua'a ra pa nts'änni da dø'ma ra María, tengu bi man yʉ́n t'ɛ̨di ra Moisés, ya i sä da mba bʉ ja ra dąniją bʉ Jerusalén. Nɛ bi zixa rá t'ʉhni ʉ ngue di däp Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","In ja bʉ bi 'yøt'e nguetho nɛ'a i mam bʉ ja rán t'ɛ̨di ra Moisés, ngue: “Gätho yʉ mbʉdi ts'ʉnt'ʉ da mba ma däpi Oją,” i ɛ̨m bʉ ja yʉn t'ɛ̨di. ");
INSERT INTO otmNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nɛ bi hyąxa n'da ra 'bøts'e bʉ ja ra dąniją tengu bi mam bʉ ja rán t'ɛ̨di ra Moisés ngue i ɛ̨na: “Yoho yʉ t'azʉ uague yoho yʉ ts'ąha ngue da hyo bʉ ja niją to'o im 'bʉh yʉ́ t'ʉhni.” ");
INSERT INTO otmNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nɛ mi 'bʉpʉ Jerusalén n'da ran 'yohʉ i Simeón, ra hocją'i a, mi numansu Oją nɛ mi tø'ma ra pa ngue da mba nhyąni ʉ yʉ ją'i israel, nɛ min 'youi rá Hogandąhi Oją a. ");
INSERT INTO otmNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nu rá Hogandąhi Oją bi bɛ̨nba ra Simeón gue hin da du asta gue'bʉ go da nu'a rá Thahni Oją ba pɛhni ngue ra Cristo a. ");
INSERT INTO otmNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nɛ nu'a rá Hogandąhi Oją bi bɛ̨nbi da zøm bʉ a ra Simeón bʉ ja ra dąniją 'bʉ mi zøm bʉ rá ta nɛ rá mbe di dä'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nu ra Simeón bi dɛxa ra 'uɛre nɛ bi 'yɛ̨spa Oją bʉya, bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ma Hmu i, pɛ hin te dím bɛ̨ngä 'bʉ ga tugä ya, nguetho dá nugä na gá xiqui ngue ga nugä, ni 'yɛ̨hɛgä. ");
INSERT INTO otmNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nuya dá nusɛgä mam pørpatehe, ");
INSERT INTO otmNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ngue gá sänni ngue da yąnba yʉ́ te ʉ to'o da bąh na. ");
INSERT INTO otmNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nuna di japi da nu ran nɛqui ʉ hing yʉ judío, nɛ gue'a dí t'ɛ̨scahe dyʉ ją'i israelgähe, dyʉ judíohe, bi 'yɛ̨n'a ra Simeón 'bʉ mi dɛxa ra 'uɛre Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nu ra José nɛ rá mbe ra Jesús bi hyonya thoho 'bɛ'a bi man ra Simeón nangue'a ra 'uɛre. ");
INSERT INTO otmNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Nu ra Simeón bʉya, bi 'yäp Oją da 'yɛnspa rán jąpi ra José nɛ ra María, nɛ bi 'yɛ̨na: ―Nuna ra t'ʉhni 'bʉ din dąn'yohʉ nts'änni xʉn ngu ʉ yʉ́ mi'israelhʉ dim 'bɛdi 'bʉ hin da numanho. Pɛ nu'ʉ to'o da numanho da yąn'a. Guehna dí fądi 'bɛ'a im bɛ̨m bʉ mbo yʉ́ mbʉi n'da ngu n'da yʉ ją'i. Nɛ nu'i María, gui nu ra dumbʉi xʉn ʉ tho ngue 'bɛ'a da t'ørpa na ni ts'ʉnt'ʉ, bi 'yɛ̨n'a ra Simeón. ");
INSERT INTO otmNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nɛ'a n'da ra dąc'yɛi xisu ngue í Ana mi 'bʉpʉ ja ra dąniją, nɛ'a xin rá pøngahyą Oją a. Nu'a, rá t'įxu ra Fanuel a, rám bom'bɛto ra Aser ngue n'da rá ts'ʉnt'ʉ ra Israel. Nu ra Ana, nu'a nyoto jɛya bim 'bʉhmi rá ndø nɛ 'bex bi du. ");
INSERT INTO otmNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nɛ bim 'bʉsɛ goho 'däte ma goho njɛya, ya xʉn dąc'yɛi a. Nɛ nu ra Ana, mi ząm bʉ ja ra dąniją a. Min yąui Oją ra pa nɛ ra xui, nɛ ja yʉ pa him mi sihmɛ 'bʉ i thąnde Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nu'bʉ min yąhʉ ra Simeón ra María nɛ ra José, bi zøm bʉ ra Ana, nɛ 'bex bi xi Oją jamadi 'bʉ mi nu'a ra 'uɛre, nguetho bi bądi gue yʉ́ yąnte ʉ. Janangue'a bi 'yɛ̨mp'ʉ to'o mi tømp' yʉ́ yąnte ngue ya bi zøh ya. ");
INSERT INTO otmNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nu'bʉ mi 'yøt'ʉ gätho mi man rán t'ɛ̨di Oją ngue da 'yøt'e, nu ra José nɛ ra María bi mbeng bʉ ja ra hnini Nazaret bʉ ja ra xɛqui Galilea. ");
INSERT INTO otmNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nɛ nu'a ra t'ʉhni bin te mán zaqui a, nɛ mi ja rán 'yomfɛ̨ni xʉn ho. Nɛ ɛ̨mmɛ bi jąp Oją a. ");
INSERT INTO otmNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nu ra José nɛ ra María ząi n'dandį n'da jɛya i pa bʉ ja ra hnini Jerusalén da nu ra dąmpɛti ngue ran dąbaxjua. ");
INSERT INTO otmNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nɛ nu'bʉ mi mbɛ'ts'a 'dɛ'mayon jɛya ra Jesús, bi mbähä bʉ ja ra hnini Jerusalén ngue da nu ra dąmpɛti bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nu'bʉ mi gua'a ram pɛti, bi mbeng bʉ yʉ́ ngu yʉ ją'i. Nɛ nu'bʉ mi mba bʉ 'yu ra José nɛ ra María, him mi pą'ʉ ngue bá copʉ a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pɛ mim bɛ̨ni min 'yohʉ yʉ́ amigo. Nɛ n'dapa bin 'yo bʉ ja ra 'yu. Nɛ nu'bʉ mín de bin säya bʉya, nɛ njo'o bʉ ra Jesús. Nɛ nu rá mbe nɛ rá ta bi 'yän'dʉ yʉ́ amigo: “Ha gbán 'yohʉ a ra Jesús,” nɛ'ʉ yʉ́ mɛni bi 'yänni. ");
INSERT INTO otmNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pɛ him bi dįni, janangue'a bi mbeng bʉ Jerusalén, bi hyom bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nɛ ná hyupa bʉya ja bi dįm bʉ ja ra dąniją. Mi 'bʉhmbʉ bʉ yʉ xänbate niją. Nɛ nu'a ra Jesús mi øde 'bɛ'a mi man'ʉ nɛ bi 'yän yʉn t'änni 'bɛ'a bi 'yøde. ");
INSERT INTO otmNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nu yʉ xänbate niją bʉya bi hyonya thoho nangue gätho 'bɛ'a mi pą'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nɛ nu'a rá mbe nɛ ra José, bi hyonya thoho 'bʉ mi nu i yąhʉ yʉ xänbate. Nu'a rá mbe bi 'yɛ̨mbi: ―Ts'ʉnt 'ʉ, hanja in jabʉ gá 'yørca'be, nguetho nu'a ni ta nɛcä ɛ̨mmɛ dá hon'a'be nɛ mi tu ma mbʉi'be. ");
INSERT INTO otmNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nu ra Jesús bi dądi: ―Pɛ nde'bʉ hin xquí hyongüi, nguetho guí pąhmi ngue jatho ga øt'ä rá 'bɛfi ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pɛ nu'ʉ, him bi bądi 'bɛ'a nam bøn'a bi man'a. ");
INSERT INTO otmNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pɛ nu'a ra Jesús 'bex bi mbähä bʉ ja rá ngu bʉ ra hnini Nazaret, nɛ nząi mi øt'a i pa nsifi. Pɛ nu'a rá mbe mim bɛ̨ntho bʉ ja rá mbʉi 'bɛ'a gätho bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nu ra Jesús, in te rá ją'i nɛ in te rán 'yomfɛ̨ni. Nɛ gätho yʉ ją'i mi numanho a nɛ'a Oją mi numanho a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Nu'bʉ ná 'dɛ'ma cʉt'a njɛya in ts'ʉt'abi ra hmuts'ʉt'abi Tiberio, nɛ bin yąui Oją ra Xuua bʉ ja ra dąpo mi 'bʉi, bi xifi di dʉmp'a rá 'bɛfi. Nɛ gue'a ra Xuua rá ts'ʉnt'ʉ ra Zacarías a. Nɛ guet'a ra jɛya bin ts'ʉt'abi ra Poncio Pilato bʉ ja ra xɛqui Galilea, nɛ n'dat'a ra jɛya bin ts'ʉt'abi a ra Felipe bʉ ja ra xɛqui Iturea nɛ ra xɛqui Traconite. Nu'a ra Felipe ngue rán 'yohʉ ra Poncio Pilato. Nɛ guet'a ra jɛya a bin ts'ʉt'abi ra Lisanias bʉ ja ra xɛqui Abilinia. Nɛ 'dat'a ra jɛya mi ngʉrpa mbäją ra Anás nɛ ra Caifás bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nɛ nubʉya, bi dʉmp' rá 'bɛfi ra Xuua Nxixyą, bin 'yo bʉ n'danguadi ra dąthe Jordán nɛ bi xih yʉ ją'i di päh yʉ́n 'yomfɛ̨ni nangue yʉ́ ts'oqui, n'dahma da mba ma punbi. Nɛ bi xifi din xixyą bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nɛ guehna ra Xuua bi man'a ra Isaías 'bʉ mi 'yɛ̨na: N'da ra ją'i din yą bʉ ja ra dąpo nɛ da 'yɛ̨na: “Dami päh nin 'yomfɛ̨nihʉ, ga simhbʉ ra Hmu mi ts'ʉtho da zøcua. Dami hoc ni mbʉihʉ, ga tømhbʉ xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tengu yʉ mbothäi nɛ yʉ t'øhø din juąni tengu n'da ra 'yu i pa ma hoqui, hingui ndaxni, i uɛ̨ntho, din ja bʉ ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nɛ gätho yʉ ją'i da nu'a ram pørpate ba pɛnd Oją,” da 'yɛ̨na, bi 'yɛ̨n'a ra Isaías. ");
INSERT INTO otmNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɛ bi zøm bʉ yʉ ją'i bʉ 'bʉh ra Xuua ngue in nde din xixyą ʉ. Nɛ nu ra Xuua bi 'yɛ̨mp'ʉ: ―Nu'ahʉ tengu thoho 'bʉ gyʉ́ pozʉhʉ, nɛ guí ɛ̨nsɛhʉ hin guin nuhʉ rá muui ni ts'oquihʉ 'bʉ gan xixyąhʉ, nɛ hin gui hoc ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pɛ nte di muui 'bʉ guí ɛ̨mhbʉ gán yąmhbʉ ngue ya nim bombøtahʉ ra Abraham. Pɛ nɛhya yʉ do i 'bongua mi sä xtá 'yɛ̨na yʉ́ t'ʉhni ra Abraham gue'bʉ gue'a xtán nde Oją a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nɛ nu'a to'o gätho him bi päh yʉ́n 'yomfɛ̨ni nangue yʉ́ ts'oqui, tengu'bʉ yʉ za ngue hingui ho yʉ́n dät'o. Nɛ nu rán ts'onza Oją ya mahoqui xʉn ho ngue da 'yɛx'ʉ yʉ za hingui ho yʉ́n dät'o, nɛ da thøspʉ ja ra sibi din zø, bi 'yɛ̨n a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nu yʉ ją'i bʉya, bi 'yɛ̨n'ʉ: ―'Bɛ'a sä ga øt'ähe 'bʉ, bi 'yɛ̨mp'a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nu ra Xuua bi dąti: ―Nu'a to'o i ja yoho yʉ́ pahni, di un'na n'da to'o hin'yʉ rá pahni. Nɛ nu'a to'o i ja 'bɛ'a da zi, di unni ts'ʉ a to'o hin'yʉ da zi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nɛ'ʉ 'da yʉ hyącahäi xí zøm bʉ ngue in nde da mba ma xixyąbi, bi 'yän'dʉ: ―Xänbate i, 'bɛ'a sä ga øt'ähe. ");
INSERT INTO otmNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nu ra Xuua bi dąti: ―'Yo guí huspahʉ man'da ra renta, pɛ hønt'a i man rán t'ɛ̨di ra häi gui hyąjʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nɛ'ʉ 'da yʉ dofʉi bi 'yänni: ―Nɛcähe, 'bɛ'a sä ga øt'ähe, bi 'yɛ̨n'ʉ. Nu ra Xuua bi dąti: ―O guí hącuahʉ ra mbɛti yʉ ją'i nangue ni ts'ɛdizɛhɛhʉ. Nɛ o gadí yąfʉ n'da ra ją'i 'bʉ guí pąhmbʉ him majuąni a guí mamhbʉ. Nɛ hin guim bɛ̨mhbʉ ngue man'da ɛ̨mmɛ xʉn ngu gui tąhmbʉ, pɛ hønt'a nin zäbi gui tąhmbʉ, bi 'yɛ̨n'a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nɛ xʉn ngu ʉ ngue mi tø'ma ra Cristo mim bɛ̨nsɛ ʉ ngue ɛ̨mbi ra Cristo a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pɛ nu'a ra Xuua bi 'yɛ̨mp'ʉ: ―Nugä dí xixyą ahʉ ngue ra dehe thoho, pɛ ba ɛ̨'a n'da ja rá ts'ɛdi xinda guecä, hin dí sʉcä tengu a. Nu'a di hoc'ahʉ nangue rá Hogandąhi Oją tengu'bʉ xtí hoc'ahʉ ra sibi. ");
INSERT INTO otmNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nɛ da huahn'dʉ yʉ ją'i tengu 'bʉ i pa nt'ɛi yʉ trigo. Nu rá xi di 'uec ran dąhi, nɛ nu yʉ trigo da mba m'bɛ'ts'i, pɛ nu yʉ́ xi da t'upʉ ja ra sibi njąm'bʉ i huɛ̨t'i, in jabʉ da 'yøt' 'bʉ bi huahn yʉ ją'i a ra Cristo, bi 'yɛ̨n a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nɛ xʉn ngu mi'da yʉm hma bi xi ʉ yʉ ją'i nangue ran ho ma'da'yo. ");
INSERT INTO otmNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pɛ nu ra Xuua bi dąmhyą ra ts'ʉt'abi Herodes nguetho nu ra Herodes bi zin'a rá 'bɛpozɛhɛ, ngue rá xisu ra Felipe, í Herodías a ra xisu. Nɛ hinga hønt'a pɛ xʉn ngu mi'da yʉn ts'o bi 'yøt'a, janangue bi dąmhyą. ");
INSERT INTO otmNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pɛ nu ra Herodes man'da xʉn ngu rá ts'oqui bi 'yøt'e nguetho bi got'a fädi a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nu'bʉ mi xixyąba yʉ ją'i a ra Xuua, nɛ'a ra Jesús bi mba bʉ, bin xixyą. ");
INSERT INTO otmNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nɛ nu ra Jesús 'bʉ mi yąui Oją, 'bex bá xoh mahɛ̨ts'i nɛ bá cą a rá Hogandąhi Oją tengu n'da ra t'azʉ, nɛ bi zoxpʉ ja rá ją'i ra Jesús. Nɛ bi t'ø'a n'da ra nde mahɛ̨ts'i bi 'yɛ̨na: ―Nu'i ma Ts'ʉnt'ʉ i, ɛ̨mmɛ dadí huɛ̨c'i i, nɛ dí numanho i, bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nu ra Jesús mi pɛ'ts'a n'däte ma'dɛt'a njɛya 'bʉ mi dʉmp' rá 'bɛfi ua ja ra häi. Nu yʉ ją'i mim bɛ̨ni rá ts'ʉnt'ʉ ra José a ra Jesús. Nɛ nu ra José rá ts'ʉnt'ʉ ra Elí a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nu ra Elí, nu'a rá ta, gue'a ra Matat a. Nu ra Matat, nu'a rá ta gue'a ra Leví a. Nu ra Leví, nu'a rá ta gue'a ra Melqui a. Nu ra Melqui, nu'a rá ta gue'a ra Jana a. Nu ra Jana, nu'a rá ta gue'a ra José a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Nu ra José, nu'a rá ta ra Matatías a. Nu ra Matatías, nu'a rá ta ra Amós a. Nu ra Amós, nu'a rá ta ra Nahum a. Nu ra Nahum, nu'a rá ta ra Esli a. Nu ra Esli, nu'a rá ta ra Nagai a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nu ra Nagai, nu'a rá ta ra Maat a. Nu ra Maat, nu'a rá ta, ra Matatías a. Nu ra Matatías, nu'a rá ta ra Semei a. Nu ra Semei, nu'a rá ta ra José a. Nu ra José, nu'a rá ta ra Judá a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nu ra Judá, nu'a rá ta ra Joana a. Nu ra Joana, nu'a rá ta ra Resa a. Nu ra Resa, nu'a rá ta ra Zorobabel a. Nu ra Zorobabel, nu'a rá ta ra Salatiel a. Nu'a ra Salatiel, nu'a rá ta ra Neri a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nu ra Neri, nu'a rá ta ra Melqui a. Nu ra Melqui, nu'a rá ta ra Adi a. Nu ra Adi, nu'a rá ta ra Cosam a. Nu ra Cosam, nu'a rá ta ra Elmodam a. Nu ra Elmodam, nu'a rá ta, ra Er a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nu ra Er nu'a rá ta ra Josué a. Nu ra Josué, nu'a rá ta ra Eliezer a. Nu ra Eliezer, nu'a rá ta ra Jorim a. Nu ra Jorim, nu'a rá ta ra Matat a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nu ra Matat, nu'a rá ta ra Leví a. Nu ra Leví, nu'a rá ta ra Simeón a. Nu ra Simeón, nu'a rá ta ra Judá a. Nu ra Judá, nu'a rá ta ra José a. Nu ra José, nu'a rá ta ra Jonán a. Nu ra Jonán, nu'a rá ta ra Eliaquim a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Nu ra Eliaquim, nu'a rá ta, ra Melea a. Nu ra Melea, nu'a rá ta, ra Mainán a. Nu ra Mainán, nu'a rá ta ra Matata a. Nu ra Matata, nu'a rá ta, ra Natán a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nu ra Natán, nu'a rá ta, ra David a. Nu ra David, nu'a rá ta, ra Isaí a. Nu ra Isaí, nu'a rá ta, ra Obed a. Nu ra Obed, nu'a rá ta, ra Booz a. Nu ra Booz, nu'a rá ta ra Salmón a. Nu ra Salmón, nu'a rá ta, ra Naasón a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nu ra Naasón, nu'a rá ta ra Aminadab a. Nu ra Aminadab, nu'a rá ta ra Aram a. Nu ra Aram, nu'a rá ta ra Esrom a. Nu ra Esrom, nu'a rá ta ra Fares a. Nu ra Fares, nu'a rá ta ra Judá a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Nu ra Judá, nu'a rá ta ra Jacob a. Nu ra Jacob, nu'a rá ta ra Isaac a. Nu ra Isaac, nu'a rá ta ra Abraham a. Nu ra Abraham, nu'a rá ta, ra Taré a. Nu ra Taré, nu'a rá ta ra Nacor a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nu ra Nacor, nu'a rá ta ra Serug a. Nu ra Serug, nu'a rá ta ra Ragau a. Nu ra Ragau, nu'a rá ta, ra Peleg a. Nu ra Peleg, nu'a rá ta, ra Heber a. Nu ra Heber, nu'a rá ta, ra Sala a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Nu ra Sala, nu'a rá ta, ra Cainán a. Nu ra Cainán, nu'a rá ta ra Arfaxad a. Nu ra Arfaxad, nu'a rá ta, ra Sem a. Nu ra Sem, nu'a rá ta, ra Noé a. Nu ra Noé, nu'a rá ta, ra Lamec a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nu ra Lamec, nu'a rá ta, ra Matusalén a. Nu ra Matusalén, nu'a rá ta, ra Enoc a. Nu ra Enoc, nu'a rá ta, ra Jared a. Nu ra Jared, nu'a rá ta, ra Mahalaleel a. Nu ra Mahalaleel, nu'a rá ta ra Cainán a. ");
INSERT INTO otmNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Nu ra Cainán, nu'a rá ta ra Enós a. Nu ra Enós, nu'a rá ta ra Set a. Nu ra Set, nu'a rá ta ra Adán a. Nɛ nu ra Adán, bi zänd Oją a. ");
INSERT INTO otmNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nu ra Jesús bi nɛxpʉ ja ra dąthe Jordán nɛ min 'youi rá Hogandąhi Oją. Nɛ nu'a rá Hogandąhi Oją bi bɛ̨nbi da mba bʉ ma'ueni bʉ ja ra dąpo. ");
INSERT INTO otmNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nɛ nyote pa nɛ nyote xui bim 'bʉpʉ ja ra dąpo ra Jesús. Nɛ bi ts'äp rá mbʉi, bi zä'a ra zįthu. Nɛ xíngui ts'ʉ bin sihmɛ gätho yʉ pa bim 'bʉpʉ, nɛ bin tumanthuhu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nɛ bi 'yɛ̨n'a ra zįthu: ―Nu'bʉ majuąni gue'e rá ts'ʉnt'ʉ Oją, dami japi dim hmɛ ra do 'bɛngua, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nu ra Jesús bi dąti: ―Nt'o't'i bʉ ja rám hman Oją: “Hinga hønt'a ra hmɛ dím 'bʉh yʉ ją'i pɛ nɛ'a gätho i man Oją,” bi t'ɛ̨mp'a ra zįthu. Nɛ him bi 'yøt'a bi sifi. ");
INSERT INTO otmNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pɛ nubʉya, nu ra zįthu bi zix a ra Jesús bʉ ja n'da ra t'øhø xʉn hɛ̨ts'i, nɛ bi 'yuti hapʉ gätho 'bʉ'ʉ ja yʉ́ ts'ɛdi yʉ ts'ʉt'abi ua ja ra häi, ");
INSERT INTO otmNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nɛ bi 'yɛ̨mbi: ―Gätho guí nu ya ga 'da'a'i, nguetho ma mbɛtigä. Ya bin'daqui nɛ sä ga unni to'o gätho dín nde ga unni. ");
INSERT INTO otmNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nɛ nu'bʉ gan dąnyahmu bʉ ja ma gua nɛ gui thąndegui, ga 'da a i gätho guín nu ya, i ɛ̨n'a ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nu ra Jesús bi dąti: ―“Hønt'a Oją, ra Hmu, ga thąndehʉ nɛ ga ørpahʉ rá 'bɛfi a,” i ɛ̨m bʉ ja rám hman Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nubʉya, nu ra zįthu bi zix mahøn'a a ra Jesús bʉ ra hnini Jerusalén, nɛ bin tøpʉ magąts'i thoho ra dąniją. Nɛ bi 'yɛ̨mbi: ―Nu'bʉ majuąni gue'e rá ts'ʉnt'ʉ i Oją, damin säqui, gui sonʉ häi, nɛ hin hapʉ gui 'uaqui, ");
INSERT INTO otmNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","nguetho nt'o't'i bʉ ja rám hman Oją: Nu'a Oją ba pɛn'dʉ yʉ́m 'bɛhni da mbäx'i i. ");
INSERT INTO otmNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nɛ da bɛnt'i i nɛ hin hapʉ gui 'uaqui, i ɛ̨m bʉ ja rá t'ohni Oją, bi 'yɛ̨n'a ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nu ra Jesús bi dąti: ―Pɛ nɛ'a i mam bʉ ngue: “Nu Oją ma Hmuhʉ njongui sä da zä'a ngue da bą 'bʉ majuąni da 'yøt'a im man'a,” i ɛ̨m bʉ ja rá t'ohni Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nu'bʉ mi gua'a bi man yʉ́n ts'äte ra zįthu, bi 'uepʉya, bi zo'a ra Jesús 'da yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nu ra Jesús bi mbeng bʉ ja ra häi Galilea, min 'youi rá Hogandąhi Oją. Nɛ gätho yʉ ją'i mi 'bʉpʉ bi 'yø'a i øt' ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nɛ bi xänba yʉ ją'i bʉ ja yʉ niją, nɛ gätho bi numanho a. ");
INSERT INTO otmNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nu ra Jesús bʉya bi mba bʉ ja ra hnini Nazaret, guepʉ bin te. Nu ra pa ran säya bi mba bʉ ja ra niją tengu ząi mi ørpʉ hapʉ mí 'yo. Nɛ bim 'bäi ngue da nɛh rám hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nɛ bin t'un'na rá søcuą bi 'yo't'a ra pøngahyą Isaías, nɛ bi tʉnts'a ra søcuą guepʉ i ɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nu'a Oją bi 'yɛnscä rá Hogandąhi nguetho bi huangä nɛ bá pɛngä ga xih yʉ hyoya ran ho ma'da'yo. Bá pɛngä ngue ga hurpa yʉ́ mbʉi to'o i ja yʉ dumbʉi. Nɛ ga xocua ʉ to'o xí bɛnt'a ra zįthu tengu'bʉ i ofädi ʉ. Ga xocpa yʉ́n 'yomfɛ̨ni yʉ ją'i nɛ da bą'a majuąni rá 'yu Oją ʉ. Nɛ ga japi him man zä ran ʉ ʉ di ʉnba yʉ́ hmu. ");
INSERT INTO otmNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nɛ ga xih yʉ ją'i ngue bi zøn ra ora da 'yørpa rá mate Oją ʉ, i ɛ̨m bʉ ja rá søcuą ra Isaías guepʉ bi nɛh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nu ra Jesús 'bʉ mi gua'a bi nɛh ra søcuą, bi mbants'i, bi uni da 'bɛs' mahøn'a ra søcuą. Nɛ bi hyuh pʉya ngue da xi ʉ 'bɛ'a mí mam bʉ. Nɛ gätho yʉ ją'i mi 'bʉpʉ ja ra niją bi hyɛ̨t'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nu'a bi 'yɛ̨na: ―Nu'a dá nɛcä ya, mi mam bʉ ja rá søcuą ra Isaías ngue mi ma din ja, nɛ bin ja a ya, nguetho dí 'bʉcä ua, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nɛ gätho yʉ ją'i bin yąmanho nangue ra Jesús nɛ bi hyonya thoho nguetho mahotho a bi man ra Jesús bʉ ja ra niją. Nɛ ɛ̨n'ʉ: ―Hanja ngubʉ i øt'e, ɛ̨n'ʉ nguetho im bɛ̨ni gue ra Jesús rá ts'ʉnt'ʉ ra José. ");
INSERT INTO otmNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nu ra Jesús bʉya bi 'yɛ̨mp'ʉ: ―Masque guí nde gui xijʉ a ram hma i ɛ̨na: “Grá 'yøthebate, damin hoczɛhɛ,” masque guí nde gui xijʉ a, nguetho guím bɛ̨nsɛhʉ, hin dí øt'ua ja ma hnini zɛhɛ ʉ yʉn t'øt'e nuįxte tengu dá øt'ä bʉ ja ra hnini Capernaum, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Majuąni dí xi ahʉ, n'da rá pøngahyą Oją hingui hnumansu bʉ ja rá häizɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Njabʉ bi 'yøt' ra pøngahyą Elías 'bʉ maya'bʉ. Xʉn ngu yʉ xisu xí du yʉ́ ndø mi 'bʉi ngue yʉ́ mijudíohʉ, gue'bʉ him bin 'ye hyu jɛya made, nɛ bin ja ra thuhu bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pɛ him bi mbäx'a n'da ra xisu xí du rá ndø bʉ ja rá häizɛhɛ, pɛgue bi 'bɛn bʉ ra hnini Sarepta guepʉ ra häi Sidón, da mbäx a n'da ra xisu mi 'bʉpʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nɛ ngutho bi 'yøt' ra pøngahyą Eliseo, guexta'a xʉn ngu yʉ́ mijudíohʉ mi hɛ̨mb ra t'axca'ya, pɛ xínga n'da bi hoc'a ra pøngahyą ngue yʉ́ mɛnguzɛhɛhʉ, hønt'a ra hmudofʉi Naamán, ra mɛngu bʉ ra häi Siria, bi hoqui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nɛ nu'bʉ mi man'a ra Jesús a bi ma, nu yʉ ją'i mi 'bʉpʉ ja ra niją ɛ̨mmɛ bin cuɛ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nɛ bi ndants'ʉ bi bɛnt'a ra Jesús nɛ bi zixpʉ mayą ra nyuni, im bɛ̨ni da hyøm bʉ ja ra mba'ye. ");
INSERT INTO otmNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pɛ nu'a ra Jesús bi tho in de bʉ 'bʉh yʉ ją'i, nɛ bi zopʉ ʉ, nɛ hin te bin jap'a. ");
INSERT INTO otmNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nɛ nu'a ra Jesús bi mbeng bʉ ja ra hnini Capernaum bʉ ja ra häi Galilea, nɛ i xänba yʉ ją'i 'bʉ ra pa ran säya. ");
INSERT INTO otmNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nɛ gätho yʉ ją'i bi hyonya thoho nangue rán xädi a, nguetho ra Jesús bi 'yuti xʉn ho ngue mi ja rán t'ɛ̨di gue'bʉ mi xänbi. ");
INSERT INTO otmNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nu n'da ra pa mi 'bʉpʉ ra Jesús bʉ ja ra dąniją nɛ mi 'bʉpʉ n'da ran 'yohʉ min 'youi ra zįthu, nɛ ɛ̨mmɛ nts'ɛdi bi mbafi, nɛ bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Gra Jesús, ra mɛngu Nazaret, 'bɛ'a guí nde gui 'yørcahe, ha gui juaje ya. Nugä dí pącä to'o i, rá Hogam 'bɛhni Oją i. ");
INSERT INTO otmNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nɛ nu ra Jesús bi 'yɛ̨mbi: ―Damin hɛ̨ nɛ gui pøm bʉ ja rá mbʉi na ran 'yohʉ. Nɛ nu'a ra zįthu nts'ɛdi bi hyømma häi ran 'yohʉ bʉ 'bäh yʉ ją'i nɛ bi bøm bʉ rá mbʉi ran 'yohʉ bʉya, pɛ hin hapʉ bi ʉnba ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nɛ bi hyonya thoho yʉ ją'i 'bɛ'a bin ja na ran 'yohʉ. Nɛ bin 'yɛ̨mzɛhɛ n'da ngu n'da: “'Bɛ'a ní ts'ɛdi i ja na ran 'yohʉ nɛ i sä i høn'a thi yʉ zįthu,” bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nɛ bi t'øde gätho ra xɛqui bʉ 'bɛ'a bi 'yøt'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nu ra Jesús bʉya bi bøm bʉ ja ra niją, bi mba bʉ ja rá ngu ra Simón Pedro. Nɛ nu'a rá suto ra Simón Pedro, xʉn ʉ, nts'ɛdi ra pa mi ja. Nɛ bi si a ra Jesús ngue xʉn ʉ a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nu ra Jesús bim 'bäpʉ mi 'bɛn'a ra hyɛ̨nni, nɛ bi ma ngue da bøn'a ra pa. 'Bex bi bøn'a ra pa, hin hapʉ xʉn ʉ bʉya. 'Bex bi ndants'a ra xisu nɛ bi hoc ran sihmɛ, bi 'uįn'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nɛ nu'bʉ mí yʉh ra hyadi, gätho yʉ hyɛ̨nni bi ts'ixpʉ 'bʉh ra Jesús. Nɛ 'bex bi yąn'ʉ yʉ hyɛ̨nni 'bʉ mi mba nthädi n'da ngu n'da ʉ, bi dä'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nɛ yʉ zįthu min 'yohʉ 'da yʉ ją'i bi japi da bøn'ʉ. Nɛ nts'ɛdi i mba'ʉ, i ɛ̨n'ʉ: ―Nu'i, rá Ts'ʉnt'ʉ i Oją, bi t'ɛ̨mp'a ra Jesús. Pɛ nu ra Jesús him bi japi din yą nguetho mi pą'ʉ gue ra Cristo a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nɛ nu'bʉ mi hyax bʉya, t'ʉxuditho bi mbasɛ bʉ ma'ueni ra Jesús. Nu yʉ ją'i bi hyoni gue'bʉ go mi dįni, nɛ him min nde'ʉ da mba ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Nugä jatho ga mbagä mi'da yʉ hnini, ga mam bʉ ran ho ma'da'yo, ga xih yʉ ją'i 'bɛpʉ ní manda rá ts'ɛdi Oją ua, jananjabʉ bá pɛngä Oją, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nɛ bi thopʉ ja mi'da yʉ hnini ja ra xɛqui Galilea bʉya, nɛ bi mam bʉ rám hma bʉ ja yʉ niją. ");
INSERT INTO otmNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nɛ man'da ra pa, ra Jesús mi 'bäpʉ ja ndendądehe Genesaret. Nɛ ɛ̨mmɛ mi dʉ bʉ yʉ ją'i in nde da 'yøh rám hman Oją, nɛ hingui sä bʉ dim 'bä'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nɛ bi nu, i høpʉ yoho yʉ mbosa hin te i ja bʉ mbo. Nɛ bi zo'ʉ yʉ́ mbɛti bʉ ndenthe gue'bʉ mi mben yʉ́ xit'ą. ");
INSERT INTO otmNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nu'a n'da, rá mbɛti ra Simón Pedro, nɛ bi hyu'a ra Jesús. Nɛ bi xi'a ra Simón da gon'i ts'ʉ ra mbosa. Nɛ nu yʉ ją'i bim 'bäpʉ ndenthe ʉ. Nu ra Jesús bi xänba ʉ yʉ ją'i bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nɛ nu'bʉ mi gua'a bi man ra Jesús bi 'yɛ̨mp'a ra Simón: ―Dami thąm bʉ xʉn hɛ̨ ra dehe, nɛ gui 'yɛm bʉ ni xit'ą. Guepʉ da zä gui thɛ yʉ huą. ");
INSERT INTO otmNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pɛ bi 'yɛ̨n'a ra Simón: ―Xänbate, gätho ra xui dám pɛhmbe nɛ hin te dá thɛhe yʉ huą, pɛ nu'bʉ guím ma, ga ɛmhbe mahøn'a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nɛ bi 'yɛm bʉya, nɛ xʉn ngu bi dɛ yʉ huą gue'bʉ go mi mbʉdi bin tʉn yʉ́ xit'ą. ");
INSERT INTO otmNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nɛ bi xi'ʉ yʉ́ mimbahuąhʉ di zɛ'i ts'ʉ. Nɛ bi yuts'i gätho yoho yʉ́ mbosa, nɛ in nde da dom bʉ mbo ra dehe yʉ mbosa nangue nán hyʉ yʉ huą. ");
INSERT INTO otmNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nɛ nu'bʉ mi nu ra Simón Pedro 'bɛ'a bin ja, bin dąnyahmu bʉ ja rá gua ra Jesús, nɛ bi 'yɛ̨mbi: ―Dami 'ue'i ts'ʉ nanguecä nguetho nugä drá dądits'oquigä, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ngubʉ bi ma nguetho bi hyonya thoho ngue xʉn ngu yʉ huą bi dɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nɛ'a ra Jacobo nɛ ra Xuua ngue yʉ́ ts'ʉnt'ʉ ra Zebedeo, bi hyonya thoho ʉ. Nɛ nu'ʉ mi comhbʉ rá 'bɛfi a ra Pedro. Pɛ nu ra Jesús bi 'yɛ̨mp'a ra Simón: ―O guín su nɛ nuya gui dʉ'mi gui hyon yʉ ją'i to'o da 'yɛ̨c'yɛigui, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nɛ nu'bʉ mí zøm bʉ ndenthe ʉ yʉ́ mbosa bʉya, bi dɛn'na ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nu n'da ra pa mi 'bʉpʉ ja n'da ra hnini ra Jesús. Nɛ'a n'da ran 'yohʉ mi 'bʉpʉ, mi hɛ̨mb ra t'axca'ya gätho rá ją'i. Nɛ nu'a ran 'yohʉ 'bʉ mi nu a ra Jesús, 'bex bim 'bɛmfo bʉ ja rá gua ra Jesús, nɛ bi 'yäp ra mate ran 'yohʉ ngue in nde da yąni, bi 'yɛ̨mbi: ―Ma Hmu i nu'bʉ guín nde, da zä gui jaqui da yąngä. ");
INSERT INTO otmNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nu ra Jesús bi dąti nɛ bi 'yɛ̨mbi: ―Nugä, dín nde ngue 'bex da zä i. Nuya bi yąn'a ya, bi 'yɛ̨mbi. 'Bex bi zä'a ran 'yohʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nɛ nu ra Jesús bi hɛcua a ran 'yohʉ gue hin da mam bʉ 'bʉh yʉ ją'i, pɛ da mam bʉ 'bʉh yʉ mbäją. Nɛ bi 'yɛ̨mbi: ―Ní mba bʉ 'bʉh yʉ mbäją, gui 'yøt'a rán t'ɛ̨di ra Moisés ngue da 'yøt'a n'da 'bʉ bi yąn'a ra t'axca'ya, n'dahma da bąh yʉ ją'i ngue majuąni bi yąn'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pɛ nu'ʉ yʉ ją'i guemhma mi ma hønbʉ go hapʉ ja yʉ hnini 'bɛ'a gätho øt'a ra Jesús, nɛ man'da xʉn ngu bi mba bʉ mi 'bʉi ngue da 'yøsɛ ʉ 'bɛ'a i man'a, ngue in nde din hocpa yʉ́n ʉ i hɛ̨mp'i 'da'ʉ. Nɛ xʉn ngu bi hoc'a ra Jesús, madague'a hønt'a go mán ʉ mi hɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nu'a ra Jesús bʉya mi pa bʉ ma'ueni guepʉ hingui 'bʉh yʉ ją'i, din yąui Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nu n'da ra pa bi xänba yʉ ją'i ra Jesús. Nɛ mi 'bʉpʉ 'da yʉ fariseo nɛ 'da yʉ xänbate niją, xpí 'yɛ̨'ʉ hønbʉ go hapʉ i ja yʉ hnini bʉ ra xɛqui Galilea nɛ ra xɛqui Judea, nɛpʉ ra dąhnini Jerusalén. Nɛ nu'a ra Jesús bi 'yut'ʉ ngue min 'youi xʉn ngu rá ts'ɛdi Oją 'bʉ mi hoc yʉn zäman'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nɛ bi zøm bʉ 'da yʉn 'yohʉ, bá tu n'da ran 'yohʉ xʉn ʉ, mi ts'a rá ją'i a, ox ra 'beza. Nɛ min nde xtán yʉrpʉ mbo 'bʉh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pɛ ɛ̨mmɛ dʉ yʉ ją'i bʉ ja ra goxthi, nɛ hin hapʉ sä dí yʉt'i. Janangue'a bi zix ra därgɛ̨hɛ bʉ maxøts'e ra ngu, nɛ bi xospa rá 'bet'e nɛ bi cą'ma ran 'yohʉ bʉ made i 'bä'a ra Jesús. Nɛ ox ra 'beza 'bʉ mi cąmp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bi bąh ra Jesús bʉya gue i ɛ̨c'yɛi xʉn ho ʉ yʉn 'yohʉ gue i ja rá ts'ɛdi a, 'bʉ mi nu'a bi 'yøt'ʉ. Janangue'a bi 'yɛ̨mp'a ra därgɛ̨hɛ: ―Amigo, ya ma punbi ni ts'oqui, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pɛ nu'ʉ yʉ fariseo nɛ yʉ xänbate niją bin 'yɛ̨mzɛhɛ ʉ: “Hanja na ran 'yohʉ ngue ɛ̨na da 'yøt'a i øt' Oją, nɛ ya ɛ̨na sä di punba rá ts'oqui n'da ra ją'i. Hingui numansu Oją na,” bi 'yɛ̨mp'ʉ yʉ xänbate nɛ yʉ fariseo. ");
INSERT INTO otmNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pɛ nu'a ra Jesús i pądi 'bɛ'a im bɛ̨n'ʉ, nɛ bi 'yɛ̨mp'ʉ: ―Hanja in jabʉ guím bɛ̨mhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ha guím bɛ̨mhbʉ ngue nte ní mbatho dá xicä ran 'yohʉ, ngue rá ts'oqui ya xʉm punbi. Ha guím bɛ̨mhbʉ man'da xquí pąhmbʉ ngue i ja ma ts'ɛdi 'bʉ ga xifi da ndants'i, din 'yo. ");
INSERT INTO otmNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pɛ ga ut'ahʉ ngue i ja man t'ɛ̨di ua ja ra häi ga punba yʉ́ ts'oqui n'da ra ją'i, ngue ga japi din 'yo na ran 'yohʉ, guecä gue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús. Nɛ nubʉya bi 'yɛ̨mp'a mí ts'a rá ją'i: ―Dami ndants'i, gui cąx ni fįdi nɛ gui mba ni ngu, bi t'ɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Bex bi ndants'a ran 'yohʉ bi gąx rá fįdi nɛ bi mba rá ngu, nɛ bi 'yɛ̨spa Oją bʉ ní mba. Nɛ gätho yʉ ją'i mi 'bʉpʉ bi nu 'bɛ'a bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nɛ gätho bi hyonya thoho ʉ, nɛ bin su, bi 'yɛ̨spa Oją nɛ bi 'yɛ̨n'ʉ: ―N'da ran t'øt'e nuįxte dá nuhʉ ra pa jabʉ ya, bi 'yɛ̨n'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","M'bɛjua bʉya, bi bøm bʉ ja ra ngu ra Jesús, nɛ bi thopʉ mi hu'a ra Leví, guepʉ mí hąc rán ju't'i ra häi, nguetho ra hyącahäi a. Nɛ nu'a ra Jesús bi 'yɛ̨na: ―Dami tɛngui, bi t'ɛ̨mp'a ra Leví. ");
INSERT INTO otmNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nu ra Leví bʉya, 'bex bi ndants'a, bi zopʉ gätho mi ja nɛ bi dɛn'na ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nɛ nu'a ra Leví bʉya, bi 'yøt'a n'da ran sihmɛ xʉn ndoho bʉ ja rá ngu, ngue bin sihmɛ bʉ ra Jesús. Nɛ bi zøm bʉ ja ran sihmɛ xʉn ngu yʉ hyącahäi nɛ xʉn ngu mi'da yʉ ją'i, 'darpʉ bin sihmɛhʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pɛ nu'ʉ yʉ fariseo nɛ yʉ xänbate niją bi 'yɛ̨na: ―Hanja gní sihmɛhʉ yʉ dądits'oqui nɛ yʉ ziyate hyącahäi, bi t'ɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nu ra Jesús bi xi a n'da ran t'uti 'bʉ mi dąt'ʉ: ―To'o i 'bʉh mán zaqui hingui hon'a to'o da 'yøthe, pɛ hønt'a to'o xʉn ʉ i hon'a da 'yøthe. ");
INSERT INTO otmNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nugä ma 'bɛfigä ngue ga xih yʉ dądits'oqui di päh yʉ́n 'yomfɛ̨ni. Pɛ nu'ʉ to'o ɛ̨nsɛ mahoqui yʉ́ mbʉi, nɛ hingui sä ga zɛ'ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nɛ bi t'ɛ̨mp'a ra Jesús: ―Nu yʉ́ xädi ra Xuua Nxixyą nząi ɛ't' yʉ́n sihmɛ 'bʉ i yąui Oją, nɛ'ʉ yʉ́ xädi yʉ fariseo, pɛ nu ni xädi hin jąm'bʉ ɛ't' yʉ́n sihmɛ. Hanja ngue in jabʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nu ra Jesús bi dąti: ―Pɛ nu'ʉ i 'bʉpʉ ja ran thąti, hin da du yʉ́ mbʉi nguetho 'bʉpʉ a ran 'yohʉ din thąti. Hin da 'yɛ̨na ngue hin din sihmɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pɛ da zøn ra ora da ts'ispa a ran 'yohʉ, nɛ ja da 'yɛ't' yʉ́n sihmɛ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nɛ xø bi xih man'da ran t'uti, ngue da 'yuti hingui sä yʉ́ xädizɛhɛ ra Jesús da dɛn'na ran yonxädi, nɛ bi 'yɛ̨mp'ʉ: ―Njo'o n'da ra ją'i da xɛn ma'da'yo rá pahni ngue da mbørba rá 'yapahni, nguetho nu'bʉ da mbørba a, hin da bømanho nɛ di ts'ontho a ma'da'yo. ");
INSERT INTO otmNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nɛ njo'o to da xirpʉ ra 'yaxfani mbot'asɛ̨i ra vino ma'da'yo, nguetho nu'bʉ bin hogui, da føh ra 'yaxfani bʉya. Nɛ dim fän ra vino nɛ di ts'on'a ra 'yaxfani, gätho dim 'bɛdi. ");
INSERT INTO otmNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nu'a ra vino ma'da'yo da sirpʉ ma'da'yo ra xifani, ngue hin dim 'bɛh ra vino, nɛ xín din ts'on'a ra xifani. ");
INSERT INTO otmNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɛ to'o in ząi i si ra nyomvino, pɛ hingui nde a ra vino ma'da'yo, nguetho man'da xʉ cʉhi ra nyomvino, ɛ̨n'ʉ. Guín jahʉ bʉ ngue hin guí numanhohʉ man xädigä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nu n'da ra pa ran säya, nu ra Jesús nɛ yʉ́ xädi bi thopʉ ja n'da ran uątrigo. Nu ʉ yʉ́ xädi bi dʉc'i 'da yʉ trigo. Bi dɛ̨nt yʉ́ 'yɛ'ʉ yʉ trigo, bi za bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nɛ nu'ʉ 'da yʉ fariseo bi 'yɛ̨mp'ʉ: ―Hanja in jabʉ guí øthʉ, nguetho i mam bʉ ja man t'ɛ̨dihʉ hingui sä gui 'yøthʉ ra 'bɛfi a ra pa ran säya, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nu ra Jesús bi dąti: ―Ha hin guí pąhmbʉ 'bɛ'a mam bʉ ja rá søcuą Oją ngue nɛ'a ra David bi mbɛsta man'da rán t'ɛ̨di Oją, nɛ'ʉ min 'yohʉ, nu'bʉ mi tumanthuhu. ");
INSERT INTO otmNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nu'a ra David bi yʉrpʉ ja rá ngu Oją nɛ bi zi yʉ thuhmɛ rán t'unni Oją oxpʉ ja ra mɛxa, nɛ bi un'dʉ min 'yohʉ. Nɛ hønsɛ yʉ mbäją i sä da zi ʉ. Pɛ hin guím bɛ̨mhbʉ ra ts'oqui bi 'yøt'a ra David nɛ yʉn 'yohʉ nguetho xʉn ho bi 'yøt'ʉ, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nɛ man'da bi man'a ra Jesús, bi 'yɛ̨na: ―Nɛ nugä ngue dán ją'igä ua ja ra ximhäi, dra Hmugä, nɛ ja man t'ɛ̨di ga mangä 'bɛ'a da 'yøt' yʉ ją'i ra pa ran säya. ");
INSERT INTO otmNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nɛ xø man'da ra pa ran säya, nu ra Jesús bi xänba yʉ ją'i bʉ ja ra niją. Nɛ mi 'bʉpʉ n'da ran 'yohʉ ra mbɛdi rán 'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nɛ'ʉ 'da yʉ xänbate niją nɛ 'da yʉ fariseo mi 'bʉpʉ, mi tømthoho, in nde da nu 'bɛ'a da 'yøt'a ra Jesús ra pa ran säya, nguetho in nde di yąp'a. ");
INSERT INTO otmNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pɛ nu ra Jesús i pądi 'bɛ'a im bɛ̨n'ʉ. Nɛ bi xi'a ran 'yohʉ mi ja rá mbɛdi'yɛ: ―Ba ɛ̨cua, damim 'bäcua da nu'a yʉ ją'i, bi 'yɛ̨mbi. Nɛ 'bex bi mba bʉ ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nu ra Jesús bi 'yɛ̨mp'ʉ bʉya: ―'Bɛ'a i mam bʉ ja man t'ɛ̨dihʉ, nda'a xʉn ho ga øthʉ. Ha i mam bʉ ga øthʉ ran ho uague ran ts'o ga øthʉ ra pa ran säya. Uague i man bʉ gan yąnbahʉ rá te n'da uague i mam bʉ ga jafʉ da du n'da a ra pa ran säya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nubʉya, nu ra Jesús bi hyɛ̨t'ʉ yʉ ją'i, nɛ bi 'yɛ̨mp'a ran 'yohʉ: ―Dami juąn ni 'yɛ. Nu'a ran 'yohʉ bi juąn rá 'yɛ, nɛ bin hogui xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pɛ nu yʉ fariseo nɛ yʉ xänbate niją ɛ̨mmɛ bin cuɛ'ʉ nɛ bi hyoni 'bɛ'a sä da 'yørpa ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","M'bɛjua bʉya bi mba bʉ ja n'da ra nyuni ra Jesús, haxa ín yąui Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nu'bʉ mi hyats'i bi zohn'dʉ yʉ́ xädi ngue i ja a da xifi mahøn'a. Nɛ bi huahni 'dɛ'mayoho din 'yohʉ ngue yʉ́ 'bäihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nɛ nu'ʉ bi huahni, gue'a ra Simón t'ɛ̨mbi ra Pedro, gue'a rá thuhu bi xih ra Jesús a. Nɛ'a ra Andrés, rán 'yohʉ a ra Simón, nɛ ra Jacobo, nɛ ra Xuua, nɛ ra Felipe, nɛ ra Bartolomé. ");
INSERT INTO otmNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Nɛ ra Mateo, nɛ ra Tomás, nɛ man'da ra Jacobo rá ts'ʉnt'ʉ ra Alfeo, nɛ ra Simón Zelotes, ");
INSERT INTO otmNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nɛ ra Judas rán 'yohʉ ra Jacobo, nɛ ra Judas Iscariote, gue'a xí dä'a ra Jesús 'bʉ m'bɛjua. Nɛ gue'ʉ bi huan'na ra Jesús ʉ ngue yʉ́ 'bäihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nubʉya, nu ra Jesús nɛ yʉ́ xädi bi gąpʉ ja ra nyuni nɛ bin thɛhʉ xʉn ngu yʉ ją'i bʉ xʉn juąni, bí nɛxpʉ yʉ hnini ra xɛqui Judea, nɛpʉ ra dąhnini Jerusalén, nɛpʉ ndendądehe, guepʉ i ja ra hnini Tiro nɛ ra hnini Sidón. Nɛ nu'ʉ, bi zøm bʉ ngue in nde da 'yøde 'bɛ'a man ra Jesús, nɛ nu'ʉ mi'da bʉya, in nde da mba ma hoqui ʉ. Nɛ nu ra Jesús bi hoc'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nɛ xʉn ngu ʉ min 'yohʉ ra zįthu bi zøm bʉ, nɛ nu'a ra Jesús bi hyøn'a thi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nɛ gätho ʉ min nde da därpa rá ją'i ra Jesús, nguetho gätho yʉ hyɛ̨nni bi hoc'a nangue rá ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nɛ nubʉya, nu ra Jesús bi hyɛ̨t'ʉ yʉ́ xädi nɛ bi 'yɛ̨mp'ʉ: ―Guí hyoyahʉ, pɛ ya gá cʉthʉ bʉ di manda rá ts'ɛdi Oją janangue'a mająpi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nɛ guí tumanthuhuhʉ, pɛ Oją di ja ahʉ gui tįmhbʉ a guí homhbʉ, janangue'a mająpi ahʉ. Nɛ guí sähʉ ra dumbʉi ya, pɛ Oją da hyut'a ni mbʉihʉ, janangue'a mająpi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nɛ ngutho 'bʉ i san ahʉ yʉ ją'i, nɛ'bʉ i 'uegue nangue ahʉ, nɛ'bʉ di c'ąman'ʉ ahʉ, nɛ'bʉ da ndøm mants'o ni thuhuhʉ ngue guí tɛngahʉ, guecä ngue dán ją'igä ua ja ra ximhäi, guemhma mająpi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gan johyahʉ, da hyu ni mbʉihʉ 'bʉ din jabʉ da 'yøt'ahʉ yʉ ją'i, nguetho ngutho bi t'ørpa ʉ yʉ pøngahyą mam'bɛt'o, nɛ i ja 'bɛ'a din 'da ahʉ ngue am 'bɛ'ts'i mahɛ̨ts'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nɛ xø bi 'yɛ̨mp'ʉ: ―Pɛ í huɛ̨hi maha ahʉ gyʉ mɛmbɛtihʉ ngue hønt'a ni mbɛti guím bɛ̨mhbʉ, nguetho ya hin guin nuhʉ man'da ran johya njąm'bʉ da guadi. ");
INSERT INTO otmNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nɛ í huɛ̨hi maha ahʉ, ngue guí ɛ̨mhbʉ hin te gadí 'bɛhmbʉ, pɛgue gan tumanthuhuhʉ. Í huɛ̨hi maha ahʉ, ngue ja nin johya zɛhɛhʉ, nguetho m'bɛjua da du ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Í huɛ̨hi maha ahʉ ngue gätho i mamanho nangue ahʉ yʉ ją'i. Bin jabʉ yʉ hyäte pøngahyą bi numanho gätho yʉ ją'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pɛ dami 'yøhmbʉ na ga xi ahʉ ya, bi 'yɛ̨n'a ra Jesús: ―Gui huɛ̨c nin sʉihʉ nɛ gui 'yørpa ran ho ʉ to'o i numan'ʉ ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nɛ dami 'yäp Oją da mbäx'ʉ di c'ąman'ʉ ahʉ, nɛ gui 'yäp Oją da 'yɛ̨nspa rán jąpi ʉ di ʉn'nahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nɛ nu'bʉ n'da da mbɛp'a ni 'yoguhʉ, gui 'bät ni hmihʉ da mbɛp'a man'da nguadi ni 'yoguhʉ. Nɛ nu'bʉ n'da da gąn'na ni cotohʉ, nɛ'a ni pahni gui unhdʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dami unhdʉ 'bɛ'a gätho da 'yä ahʉ, nɛ nu'a da thąn'nahʉ hingui 'yähmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nu'bʉ guí ndehʉ da 'yøt'ahʉ ran ho ni miją'ihʉ nde'bʉ gui 'yørpahʉ ran ho. ");
INSERT INTO otmNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Pɛ nu'bʉ hønt'ʉ di huɛ̨c'ahʉ gui huɛ̨jʉ, hin te di muui a 'bʉ, 'da'angu gá 'yøthʉ ʉ him mahoqui yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nɛ nu'bʉ hønt'ʉ bi 'yøt'ahʉ ran ho guí ørpahʉ ran ho, hin te di muui 'bʉ, nguetho in jabʉ øt'ʉ him mahoqui yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nɛ nu'bʉ hønt'ʉ guí pąhmbʉ i jut'i guí hmit ni mbɛtihʉ, hin te di muui 'bʉ, nguetho gue'a i øt' yʉ ts'om'bäi, di hmit yʉ́ mits'om'bäihʉ ngue im bɛ̨ni da mba ma cospi rá mbɛti. ");
INSERT INTO otmNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pɛ dí xi ahʉ, dami huɛ̨c nin sʉihʉ, nɛ gui 'yørpahʉ ran ho ʉ, nɛ gui hmithʉ madague'a guí pądi hin di cos'ahʉ. Nu'bʉ ngubʉ gui 'yøthʉ, gue'a nám fądi gue yʉ́ t'ʉhni ahʉ Oją. Nɛ i ja 'bɛ'a di 'da ahʉ Oją bʉya. Nguetho gue'a i øt' Oją, gätho i ørpa ran ho madague'a hin da 'yɛ̨n'ʉ: “Jamadi Oją.” Nɛ gätho i ørpa ran ho madague yʉ ts'om'bäi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dami huɛ̨c ni miją'ihʉ tengutho bʉ í huɛ̨c'ahʉ Oją ma Tahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nɛ man'da bi man'a ra Jesús, bi 'yɛ̨na: ―“Nuna bi 'yøt' yʉ ts'oqui,” hin gui 'yɛ̨mhbʉ, nɛ hin da t'ɛ̨n'ahʉ gá 'yøthʉ yʉ ts'oqui 'bʉ. Nɛ 'yo gadí yąfʉ ni miją'ihʉ nɛ hin da zɛp'ahʉ Oją, pɛ gam punbahʉ nɛ Oją di pun'nahʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dami un'dʉ 'bɛ'a i hon ni miją'ihʉ, nɛ Oją man'da xʉn ngu di co'ts'ahʉ nɛ dim fons thoho a di 'da ahʉ xinda gue'a gadí un ni miją'ihʉ. Nguetho da 'yøt'ahʉ Oją tengu guí ørpahʉ ni miją'ihʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nɛ xø bi xi'a n'da ran t'uti, bi 'yɛ̨na: ―Hingui sä n'da ra xädä da 'yut ra 'yu rá mixädäui, ts'ʉrpʉ thoho da däpʉ ja ra hyɛ̨ ʉ. Nɛ ngutho n'da ra ją'i hingui sä da 'yut ran ho rá miją'iui 'bʉ hingui pąsɛ ran ho. ");
INSERT INTO otmNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nɛ ngutho n'da ra xädi, man'da hingui ngu pądi xinda gue'a rá xänbate, nɛ nu'bʉ bi juah rán xädi, 'da'ingu i pąhmi a. Nu'bʉ ts'ʉtho i pą'a ra xänbate nɛ ts'ʉtho i pą'a rá xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nɛ hingui sä gui mamhbʉ nangue to'o i ja zʉ ts'ʉ ran ts'o 'bʉ xʉn ts'o ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hanja gní 'yɛ̨mhbʉ gui zɛhmbʉ ʉ mi'da yʉ ją'i di hoc yʉ́ mbʉi, nɛ ɛ̨mmɛ go xʉn ts'o ni mbʉizɛhɛhʉ. Jatho 'bɛ gui hoczɛhɛ ni mbʉihʉ, ja da zä gui zɛhmbʉ ʉ mi'da, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nɛ man'da bi man'a ra Jesús ngue bi 'yɛ̨na: ―Nu n'da ra hogaza hingui sä din zʉh yʉ́n dät'o ngue hingui ho. Nɛ ngutho a n'da ra za hingui ho, hingui sä din zʉh yʉ́n dät'o xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nu yʉ́n dät'o i zʉpʉ, gue'a ctí pąhmbʉ 'bɛ'a ní za a ra za, nguetho hingui sä din zʉh yʉ́n dät'o ngue yʉ higo bʉ ja ra 'uįnza. Nɛ xín din zʉh yʉn dät'o ngue yʉ uva bʉ ja yʉ t'ax'uįni. ");
INSERT INTO otmNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ngutho n'da ra ją'i xʉn ho rá mbʉi, i øt' ran ho tengu i ja bʉ mbo rá mbʉi. Nɛ ngutho n'da ra ts'om'bäi i øt' ran ts'o tengu i ja bʉ mbo rá mbʉi, nguetho gätho a i ja bʉ mbo rá mbʉi n'da, gue'a ní bøn rá nde n'da a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Hanja gní 'yɛ̨njʉ ni hmujʉ nɛ hin guí øthʉ 'bɛ'a dí xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ga xi ahʉ rán t'uti ʉ i øt'a dí mangä. ");
INSERT INTO otmNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nu'ʉ, i øt'e tengu bi 'yøt'a n'da ran 'yohʉ bi hyø'a n'da rá ngu, nɛ xʉn hɛ̨ bi 'yamp' ra häi ngue da mbämp'ʉ yʉ jądo. Nɛ nu'bʉ mam bá ɛ̨h ra mboxthe, nte bi jap'a ra ngu, nguetho mbo bim foxa ra jądo. ");
INSERT INTO otmNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pɛ nu'ʉ i øh ma nde nɛ hingui øt'a dí mangä, rán t'uti ʉ tengu n'da ran 'yohʉ bi hyøh rá ngu nɛ bi 'yɛ̨x maxøts'e yʉ jądo, nɛ nu'bʉ mambá ɛ̨'a n'da ra mboxthe, 'bex bi yøt rán ngu bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nɛ nu'bʉ mi gua'a man'a ra Jesús, bi mba mahøn'a bʉ ja ra hnini Capernaum. ");
INSERT INTO otmNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nɛ mi 'bʉpʉ n'da ra hmudofʉi, ra mɛngu bʉ Roma a. Nɛ xʉn'ʉ n'da rá 'yɛ̨hɛ, nde da du. Nɛ nu'a ra hmudofʉi ɛ̨mmɛ madi huɛ̨c'a rá 'yɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nɛ nu'bʉ mi 'yøde 'bʉpʉ ra Jesús bá pɛhni 'da yʉ ngʉrbi bʉ ja ra hnini ngue da zix'a ra Jesús di hocpa rá 'yɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nɛ nu'bʉ mi zøm bʉ 'bʉh ra Jesús, bi 'yäp ra mate da mba, nɛ bi 'yɛ̨mbi: ―Dín nde gui 'yørcahe ra mate gui mba, nguetho nu'a ra hmudofʉi ra hocją'i a, ");
INSERT INTO otmNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nɛ ɛ̨mmɛ di huɛ̨gahʉ ngue dyʉ judíohʉ. Nɛ nu'a bi guzɛhɛ a í thøh ma nijąhʉ, madague hing ra judío a, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nu ra Jesús bi mbähä, nɛ nu'bʉ mi ts'ʉtho da zøm bʉ ja rá ngu a ra hmudofʉi, pɛ nu'a ra hmudofʉi bá pɛhni 'da yʉ́ amigo mahøn'a, din c'athʉ a ra Jesús, da 'yɛ̨mbi: ―Hingui jatho gui søm bʉ ja ma ngu, nguetho nugä hin dí sucä tengu i, ");
INSERT INTO otmNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","xíngui sä ga ɛ̨na ga mba gan yąui, nɛ hin drá judíogä. Pɛ dí pądi ngue i ja ni ts'ɛdizɛhɛ, ngue nu'bʉ guim ma da yąni, nɛ 'bex gue da yąni. ");
INSERT INTO otmNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tengu thohogä bin 'dac'i ts'ʉ man t'ɛ̨di, nɛ nu'bʉ i ja 'bɛ'a dí xi ʉ ma dofʉi, nɛ'ʉ ma 'yɛ̨hɛ, 'bexgue 'dahmantho in ja. Nɛ ngutho i, sä guim mantho bʉ guí 'bäi nɛ 'bexgue da yąn bʉya, bi 'yɛ̨n'a ra nde bá pɛhna ra hmudofʉi ngue bi man'ʉ yʉ́ amigo. ");
INSERT INTO otmNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nu ra Jesús bi hyonya thoho 'bʉ mi 'yø'a bi man'ʉ yʉn 'yohʉ ngue bá pɛhna ra hmudofʉi, nɛ bin yɛ̨gui bi xi'ʉ mí tɛnni, nɛ bi 'yɛ̨na: ―Xínga n'da ma mijudíohʉ dá tįngä ngue i ɛ̨c'yɛi i ja ma ts'ɛdi tengu a ran 'yohʉ, bi 'yɛ̨n'a ra Jesús. Nuya bin ja a bi 'yäqui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nɛ bi mbeng bʉ ja ra ngu ʉ yʉ́ amigo a ra hmudofʉi bʉya, nɛ bi nu'a rá 'yɛ̨hɛ ra hmudofʉi ngue ya xí zä. ");
INSERT INTO otmNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Man'da ra pa bʉya, ra Jesús bi mbähä yʉ́ xädi bʉ ja ra hnini Naín. Nɛ xʉn ngu yʉ ją'i mi tɛnni. ");
INSERT INTO otmNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nɛ nu'bʉ mi zøm bʉ ndehnini, ba ɛ̨pʉ yʉ 'yägui, ba tu rá ts'ʉnt'ʉ n'da ra xisu xí du rá ndø. Nɛ njo'o man'da rá ts'ʉnt'ʉ. Nɛ xʉn ngu yʉ ją'i min 'yohʉ yʉ 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nɛ nu ra Jesús 'bʉ mi nu a ra xisu bʉya, bi huɛ̨c'a nɛ bi 'yɛ̨mbi: ―O guí zoni, ɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nɛ nubʉya, bi dä'a ra huada mi o ra du a ra Jesús nɛ bim 'bä'ʉ yʉn dute. Nu ra Jesús bi 'yɛ̨mp'a ra du bʉya: ―Grá ts'ʉnt'ʉ, dami ndants'i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nɛ nu'a xí du 'bex bi ndants pʉ ja rá huada nɛ bin yą. Nu ra Jesús bʉya, bi xi'a rá mbe da zits'i. ");
INSERT INTO otmNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nɛ gätho yʉ ją'i mi 'bäpʉ bin su, nɛ bi 'yɛ̨spa Oją ʉ. ―Nuya, n'da ra pøngahyą nuįxte dí 'bʉhmbʉ ua, nɛ Oją da yąnjʉ ya, yʉ́ ją'igähʉ Oją ya, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nɛ gätho yʉ ją'i mi 'bʉpʉ, nɛpʉ ra xɛqui Judea, bi ma 'bɛ'a bi 'yøt'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nɛ bi si'a ra Xuua Nxixyą 'bɛ'a bi 'yøt'a ra Jesús, bi man ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Janangue'a nu ra Xuua bi zon'dʉ yoho yʉ́ xädi ngue da mbɛn bʉ 'bʉh ra Jesús nɛ da 'yänni: “Ha gue'e ra Cristo mi hma ba ɛ̨hɛ, uague ga thoqui ga tømhbe,” gui 'yɛ̨nui, bi 'yɛ̨n'a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nɛ nu'bʉ mi dįn'a ra Jesús ʉ yʉ́m 'bɛhni ra Xuua, bi 'yɛ̨mbi: ―Nu'a ra Xuua Nxixyą bá pɛngä'be nguetho in nde da bądi gue'bʉ gue'e ra Cristo i hma ba ɛ̨hɛ, uague ga thoqui ga tømhbe, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nɛ 'bex bi hoc'ʉ 'da yʉ hyɛ̨nni a ra Jesús bʉya, nɛ bi hyøn'a thi yʉ zįthu ngue mín 'yohʉ 'da yʉ ją'i, nɛ bi xocpa yʉ́ dä yʉ xädä. ");
INSERT INTO otmNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nɛ nubʉya, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Xuua: ―Ní mbɛ ya, gui xihmi ra Xuua 'bɛ'a gá nuui ua, nɛ 'bɛ'a gá 'yøhmi ya. Gui 'yɛ̨nui: “Nu yʉ xädä i nu ran nɛqui ya, nɛ yʉ dogua i sä i 'yo ya, nɛ nu'ʉ mi hɛ̨mb ra t'axca'ya bi yąn'ʉ ya, nɛ yʉ gogu i øhnahyą ya, nɛ'ʉ xí du bi ndants'i, nɛ yʉ hyoya i ø'a ran ho ma'da'yo ya. ");
INSERT INTO otmNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Din johya ʉ to'o i ɛ̨c'yɛi xʉn ho, nɛ hin di ʉ't' yʉ́ mbʉi ʉ,” gui 'yɛ̨nui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nɛ nu'bʉ mi mbenc'ʉ yʉ́m 'bɛhni ra Xuua bʉya, nu ra Jesús bi ma 'bɛ'a øt' ra Xuua, nɛ bi 'yɛ̨mp'ʉ yʉ ją'i: ―Nu'bʉ gá mbähä bʉ ma'ueni ngue gá nuhʉ ra Xuua, 'bɛ'a gá bɛ̨mhbʉ ngue gua nuhʉ bʉ. Ha guá nuhʉ n'da ran 'yohʉ xʉn güent'i tengu n'da ra xithi i ɛn ran dąhi. ");
INSERT INTO otmNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Uague gá nuhʉ n'da ran 'yohʉ mi he ra pahni xʉm hmadi. Pɛ nu'ʉ, 'bʉpʉ ja ra ngunts'ʉt'abi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Uague guá nuhʉ n'da rá pøngahyą Oją. Majuąni a gá nuhʉ, nɛ hinga hønt'a n'da rá pøngahyą Oją, pɛ nu'a, xʉn hɛ̨ts'i rá ts'ɛdi xinda gue'ʉ mi'da yʉ pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gue'a ra Xuua i hmam bʉ ja rá søcuą Oją, gue i ɛ̨na: Nugä, ga pɛhn'na n'da mam 'bɛhni dim 'bɛt'o bʉ gní mba, da xih yʉ ją'i da døp'e xʉn ho, i ɛ̨m bʉ ja rám hman Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Xínga n'da ra ją'i mi 'bʉi ngue nuįxte rá 'bɛfi tengu ra Xuua. Pɛ nu'a to'o dim 'bʉpʉ di manda rá ts'ɛdi Oją, nu rá 'bɛfi da 'yørpʉ madague'a ts'ʉtho, pɛ man'da nuįxte a xinda gue'a ra 'bɛfi i øt' ra Xuua ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nɛ nu yʉ hyącahäi nɛ mi'da yʉ ją'i xí xixyąba ra Xuua Nxixyą, 'bʉ mi 'yø a bi man ra Jesús, bi bą'ʉ xʉn ho i øt' Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pɛ nu yʉ fariseo nɛ yʉ xänbate niją, ngue him bi nde'a ran xixyą bi 'yøt' ra Xuua, him bi numanho'a bi nde Oją da 'yørpa'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―'Bɛ'a nín t'uti ga xi ahʉ ngue gui pąhmbʉ 'bɛ'a guí øthʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Guí øthʉ tengu øt' yʉ t'ʉhni 'bʉ in ɛ̨ni nɛ i ɛ̨mp'ʉ yʉ́ mit'ʉhnihʉ: “Nugähe, dá pɛhmbe ra 'bida pɛ nu'ahʉ hin gán nɛhmbʉ,” ɛ̨n'ʉ 'da. Nɛ xø ɛ̨n'ʉ mi'da bʉya: “Pɛ nugähe, dá pɛhmbe yʉ thuhu tengu'bʉ xʉn du n'da, nɛ nu ahʉ hin gán zomhbʉ,” ɛ̨n'ʉ mi'da. ");
INSERT INTO otmNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nɛ ngutho guí øthʉ tengu øt' yʉ t'ʉhni, ngue nu ra Xuua Nxixyą bi zøcua, nɛ him bin sihmɛhʉ yʉ ją'i nɛ xím bi zi ra vino. Pɛ nu ahʉ gá 'yɛ̨mdahʉ in 'youi ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pɛ nugä, ngue dán ją'igä ua ja ra ximhäi, nɛ bá ɛ̨cä nɛ dí sihmɛhe yʉ ją'i, nɛ nu ahʉ sä guí ɛ̨njʉ drá hyʉgugä nɛ drá mihnigä, nɛ guí ɛ̨njʉ dín amigogähe yʉ ziyate hyącahäi nɛ yʉ ts'om'bäi. ");
INSERT INTO otmNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pɛ nu'bʉ majuąni i ja rán 'yomfɛ̨ni n'da, da bądi to'o ʉ ngue majuąni bi un rán 'yomfɛ̨ni Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nɛ n'da ran 'yohʉ mí tɛn rán xädi yʉ fariseo, bi xi'a ra Jesús din sihmɛ bʉ ja rá ngu. Nɛ bi mbähä ra Jesús bʉya, din sihmɛ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nɛ nu'a n'da ra xisu ra 'yomt'ɛ̨ni a, nɛ nu'bʉ mi 'yøde 'bʉpʉ ra Jesús, bi yʉrpʉ mi hu a ra Jesús, i tu n'da ra xito án t'øt'e ra do alabastro, mi po ra 'yɛ̨thi yʉmanho, xʉm hmadi di muui. ");
INSERT INTO otmNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nɛ nu'a ra xisu mi hupʉ ja rá gua ra Jesús, nɛ mi zoni. Janangue bi mboxpʉ ja rá gua ra Jesús a rá guidä, nɛ bi ducua rá gua yʉ́ xtą, nɛ ɛ̨mmɛ zʉspa rá gua ra Jesús, nɛ bi xispa rá gua ra 'yɛ̨thi yʉmanho. ");
INSERT INTO otmNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nɛ nu'a ra mɛngu bʉ, 'bʉ mi nu 'bɛ'a i øt'a ra xisu, bi bɛ̨nsɛ: “Him majuąni rá pøngahyą Oją a ra Jesús,” nguetho ɛ̨mbi hingui pądi ra 'yomt'ɛ̨ni a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nu ra Jesús bʉya, bi 'yɛ̨mp'a: ―Nu'i grá Simón i ja'a ga xi'i. Nu ra Simón bi 'yɛ̨na: ―Gra xänbate, dami xic 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nu ra Jesús bʉya, bi xih ra Simón n'da ran t'uti, nɛ bi 'yɛ̨mbi: ―Mi 'bʉ a n'da ran 'yohʉ ząi di hmih ra mbɛti. Nɛ mi 'bʉ'a n'da ran 'yohʉ bi hmiti cʉt'a ciɛnto, nɛ man'da bʉya bi hmiti yote ma'dɛt'a thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nɛ nu'ʉ gätho yoho hin'yʉ 'bɛ'a dí co'ts'a ra mbɛti xí mba ma hmiti. Janangue nu'a xí hmih ra mbɛti bʉya, bi punba thoho ʉ. Dami xic ya, Simón, nda'a man'da da bɛ̨n'a ra mate bi t'ørpe, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nu ra Simón bi dąh pʉya, nɛ bi 'yɛ̨na: ―Masque gue'a ran 'yohʉ min dupate xʉn ngu, man'da da bɛ̨n'a ra mate bi t'ørpe, bi 'yɛ̨na. ―Majuąni a guím bɛ̨ni, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nu ra Jesús bʉya, bi hyɛ̨t'a ra xisu nɛ bi 'yɛ̨mp'a ra Simón: ―Guí nu na ra xisu 'bʉcua, nu'bʉ má cʉt'ua ja ni ngu xíngui ts'ʉ gá 'dac ra dehe gue xcá pe't'ä ma gua, pɛ nu ra xisu i hucua, rá guidä í mbercä ma gua nɛ yʉ́ xtą í dugä ma gua. ");
INSERT INTO otmNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pɛ nu'i, hin gá sʉsca ma 'yogu ngue xquí zɛnguagui, pɛ nuna ra xisu him bin hɛ̨ a ní zʉsca ma gua. ");
INSERT INTO otmNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nɛ nu'i, hin gá cosca ma yą ra aceite, pɛ nuna ra xisu i hucua, bi xisca ma gua ra 'yɛ̨thi yʉman'u. ");
INSERT INTO otmNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Guehna dí xi a i na, xʉn ngu rá ts'oqui na ra xisu nɛ xʉn ngu rá punbi ya, janangue ɛ̨mmɛ im bɛ̨ngä na. Pɛ nu'ʉ im bɛ̨nsɛ ts'ʉtho ra punbi i honi, man'da ts'ʉtho im bɛ̨ngä ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nɛ nubʉya, bi 'yɛ̨mp'a ra xisu: ―Ya ma punbi ni ts'oqui ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nɛ nu'ʉ i sihmɛ bʉ bin 'yɛ̨mzɛhɛ ʉ: ―To'o nín 'yohʉ na, gue i ɛ̨na sä di punba yʉ́ ts'oqui n'da, bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pɛ nu ra Jesús bi 'yɛ̨mp'a ra xisu: ―Gá 'yɛ̨c'yɛigui, janangue ya ma punbi ni ts'oqui ya. Ní mba ya nɛ gan johya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nu'bʉ mi tho'i 'da yʉ pa, nu ra Jesús bi mbähä 'dɛ'mayoho yʉ́ xädi bʉ ja yʉ hnini, nɛ bi mam bʉ 'bɛpʉ ní manda rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nɛ bi mbähä a ra Jesús 'da yʉ xisu xí hoc 'bʉ mí ʉ, nɛ'ʉ 'da xí hyønba thi yʉ zįthu min 'yohʉ, nɛ'a ra María ra mɛngu bʉ ra hnini Magdala, gue mín 'yohʉ yoto yʉ zįthu 'bʉ mi hoc'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nɛ'a ra Juana, rá xisu ra Chuza, n'da ran 'yohʉ im hmu bʉ ja rá ngu ra ts'ʉt'abi Herodes. Nɛ'a ra Susana, nɛ xʉn ngu mi'da yʉ xisu bi mbähä, mi fäx'a ra Jesús nɛ yʉ́ xädi nangue yʉ́ mbɛti zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nɛ xʉn ngu yʉ ją'i bi nɛxpʉ i ja mi'da yʉ hnini, nɛ bim pɛti bʉ 'bʉh ra Jesús. Nɛ nu'a ra Jesús bi xi'a n'da ran t'uti, bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Nu n'da ran 'yohʉ bi mba bʉ ja rá huąhi bá pom bʉ yʉ hmudä. Nu'ʉ 'da yʉ hmudä bi zo bʉ ja ra 'yu, nɛ nu yʉ ją'i bi nɛ̨m bʉya nɛ yʉ doja bi za. ");
INSERT INTO otmNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nɛ 'da'ʉ yʉ hmudä bi zo bʉ ja yʉ ndaxnado, nɛ nu'bʉ mi bøts'e 'bex bi hmanc'a n'dihi, nguetho hin'yʉ ra dehe bʉ ja yʉ do. ");
INSERT INTO otmNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nu'ʉ mi'da yʉ hmudä bi zo bʉ ja yʉ 'uįni, nɛ nu'bʉ mi bøts'e, bi gom' yʉ 'uįni ʉ, nɛ him bin te. ");
INSERT INTO otmNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nɛ'ʉ 'da yʉ hmudä bi zo bʉ ja ra hogahäi nɛ bin te xʉn ho bʉ, nɛ bin xąndi, xʉn ngu bin ja, bi 'yɛ̨m 'bʉ mi man ran t'uti. Nu'ʉ i ja yʉ́ zagu, bi 'yø'a dá ma, bi 'yɛ̨mp'ʉ yʉ ją'i ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nu'ʉ yʉ́ xädi, bi 'yän'na ra Jesús: ―'Bɛ'a nam bøn'a ran t'uti gá ma. ");
INSERT INTO otmNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'ahʉ, Oją bi ja ahʉ gui pąhmbʉ 'bɛpʉ ní manda rá ts'ɛdi. Pɛ nu'ʉ mi'da, dí xih yʉn t'uti ʉ, nguetho in nu yʉ́ dä pɛ hingui pądi 'bɛ'a in nu, nɛ i ja yʉ́ zagu, pɛ hingui pądi 'bɛ'a i øde, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","―Nuya, ga xi ahʉ 'bɛ'a nim bøn'a ran t'uti dá mangä. Nu'ʉ yʉ hmudä, ra hmɛpya rám hman Oją ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nu'ʉ bi zo bʉ ja ra 'yu, ra hmɛpya ʉ to'o bi 'yøh rám hman Oją, pɛ nu ra zįthu bi japi 'bex bi pumbɛ̨ni, nɛ him bi zä bi 'yɛ̨c'yɛi ngue da mba nhyąni. ");
INSERT INTO otmNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nɛ nu yʉ hmudä bi zo bʉ ja yʉ do, ra hmɛpya ʉ to'o bi 'yøh rám hman Oją nɛ bin johya 'da yʉ pa. Pɛ him bi gopʉ mbo yʉ́ mbʉi rá hman Oją nɛ nu'bʉ bi zä ra zįthu ʉ, 'bex bi 'ueh pʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nɛ nu'ʉ yʉ hmudä bi zo bʉ ja yʉ 'uįni, ra hmɛpya ʉ to'o bi 'yøh rám hman Oją, pɛ hønt'a bi bɛ̨ni 'bɛ'a dí hyusɛ yʉ́ mbʉi, nɛ 'bɛ'a i ja ua, nɛ 'bɛ 'a bi numanhosɛ, hinga xøt'a din te bʉ yoho yʉ hmudä, nɛ nte bin ja a ra hoga hmudä. ");
INSERT INTO otmNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nɛ nu'ʉ yʉ hmudä bi zo bʉ ja ra hogahäi, ra hmɛpya ʉ to'o bi 'yøh rám hman Oją, nɛ bi mbɛs'pʉ mbo rá mbʉi, nɛ bi xi'ʉ mi'da yʉ ją'i, nɛ xʉn ngu mi'da bi 'yɛ̨c'yɛi nangue'ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nɛ man'da ran t'uti bi ma ra Jesús, bi 'yɛ̨na: ―Xínga n'da ra ją'i di søc yʉ bombilla ngue da go'mi, o gue da mbøxpʉ 'bit'ots'i, pɛ da 'yɛ̨xpʉ m'batho ngue di nɛc bʉ mbo ra ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ngutho mam hmangä. 'Bɛ'a gätho dí xi a zɛhɛhʉ, pɛ jatho gui xihmbʉ mi'da yʉ ją'i, janangue'a din ja ran nɛqui yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dami jamansuhʉ xʉn ho 'bʉ guí øhmbʉ mam hmangä, nguetho nu'bʉ guí øhmbʉ xʉn ho, sä gui pąhmbʉ xʉn ho a mam hmangä. Pɛ nu'ʉ to'o hingui øde xʉn ho, di pumbɛ̨ni a zʉ ts'ʉ bi 'yøde, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","N'da ra pa bi mba bʉ rá mbe nɛ'ʉ yʉ́ cu ngue da nu'a ra Jesús. Pɛ him bi zä da nu nguetho ɛ̨mmɛ dʉ yʉ ją'i bʉ mi 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nɛ bi si'a ra Jesús i 'bäpʉ thi rá mbe nɛ yʉ́ cu, in nde da nu a. ");
INSERT INTO otmNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nu ra Jesús bi dąti, bi 'yɛ̨na: ―Nu ma mbe nɛ ma cu, gue'ʉ to'o i øh rám hman Oją, nɛ øt'a i mam bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nu'a ra Jesús n'da ra pa bi hyu n'da ra mbosa, bi mbähä yʉ́ xädi, nɛ bi 'yɛ̨mp'ʉ: ―Ga mbähä bʉ 'danguadi ra dądehe, bi 'yɛ̨na. Nɛ 'bex bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pɛ nu'bʉ i 'yo'a ra mbosa bʉ ja ra dehe, bin ą'a ra Jesús. Nɛ ɛ̨mmɛ nts'ɛdi ran dąhi bi 'yɛn'a ra dehe, gue'bʉ go mi mbo ra dehe bʉ mbo ra mbosa, nts'utho a bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pɛ nu'ʉ yʉ́ xädi, bi 'yents'a ra Jesús: ―Xänbate i, xänbate i, nde da goguahʉ ra dehe, bi 'yɛ̨mbi. Bi ndants'a ra Jesús, bi hɛcua ran dąhi nɛ ra dehe, bin hɛ̨'ʉ bʉya, nɛ xʉn ho ra dehe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nu ra Jesús bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Hanja, ha zʉ ts'ʉtho guí ɛ̨c'yɛigahʉ. Pɛ nu'ʉ yʉ́ xädi bin su, nɛ bi hyonya thoho. Nɛ bin 'yɛ̨mzɛhɛ ʉ: ―'Bɛ'a din 'yɛ̨t'ui na ran 'yohʉ, nɛ ya 'bexque in hɛ̨'a ran dąhi nɛ ra dehe di hɛcpi, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nɛ nu'bʉ min hɛ̨ ran dąhi, bi thopʉya, bi zøm bʉ ja ra häi Gadara, din hyant'ui bʉ 'danguadi ra häi Galilea. ");
INSERT INTO otmNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nɛ nu'bʉ mi gą'a ra Jesús bʉ ja ra mbosa, bin c'at'ui n'da ran 'yohʉ ra mɛngu bʉ, min 'yohʉ yʉ zįthu a. Nɛ nu'a ran 'yohʉ, him mí he rá he, nɛ him mi 'bʉpʉ ja rá ngu, pɛ mi 'bʉpʉ ja yʉn 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nɛ nu'bʉ mi nu'a ra Jesús bʉya, 'bex bin dąnyahmu bʉ ja rá gua nɛ nts'ɛdi bi mba'a ra zįthu: ―Nu'i Jesús, rá ts'ʉnt'ʉ i Oją nuįxte, 'bɛ'a gui 'yørcähe ya. 'Yørcähe ts'ʉ ra mate, o gadí ʉngahe, ");
INSERT INTO otmNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","bi 'yɛ̨n'a ra zįthu 'bʉ mi xifi da bøm bʉ rá mbʉi ran 'yohʉ. Nguetho na ya'a thoho bi ʉnba ran 'yohʉ nɛ i xɛcta yʉ cadena i pa thu't'i, nangue rá ts'ɛdi ra zįthu, nɛ i sixpʉ ma'ueni mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nu ra Jesús bi 'yänba rá thuhu a ran 'yohʉ. ―Dí n'dan nɛts'igähe, bi 'yɛ̨m 'bʉ mi dądi. Nguetho min 'yohʉ xʉn ngu yʉ zįthu. ");
INSERT INTO otmNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nɛ nu'ʉ yʉ zįthu bi 'yäp ra mate ra Jesús hin da 'yɛntpʉ hapʉ bí nɛts'i, nguepʉ ja ra mba'ye xʉn hɛ̨tho nɛ nts'utho. ");
INSERT INTO otmNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nɛ mi 'bʉpʉ xʉn ngu yʉ ts'ʉdi mi sihmɛ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nɛ nu yʉ zįthu bi bøm bʉ ja rá mbʉi ran 'yohʉ nɛ bi yʉrpʉ 'bʉh yʉ ts'ʉdi. Nɛ gätho yʉ ts'ʉdi 'bex bin tihi, bin gøxpʉ ja ra nguani, gätho bi zo bʉ dehe, bim 'bɛdi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nu'ʉ yʉn 'yohʉ mi fäh yʉ ts'ʉdi, 'bex bi 'dah pʉya 'bʉ mi nu 'bɛ'a bi 'yøt'ʉ yʉ ts'ʉdi. Bi mba bʉ ja ra hnini nɛpʉ ja yʉ huąhi, bi ma 'bɛ'a bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nɛ xʉn ngu bi mba bʉ, ba nusɛ 'bɛ'a bin ja. Nɛ bi nu'a ran 'yohʉ min 'yohʉ yʉ zįthu, mi hupʉ ja rá gua ra Jesús, mi he rá he. Ya xí yąm bʉya. Nɛ gätho yʉ ją'i bin su 'bʉ mi nu 'bɛ'a bi t'ørpa ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nɛ nu'ʉ yʉ ją'i in 'yohʉ a ra Jesús, 'bʉ mi hoc'a ran 'yohʉ, bi xi'ʉ m'bɛjua bi zøm bʉ 'bɛ'a gätho bi 'yøt'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nɛ gätho mi 'bʉpʉ ja ra häi Gadara bi 'yäp ra mate ngue hin din 'yo bʉ ja ra xɛqui a, nguetho ɛ̨mmɛ min su gätho ʉ. Janangue'a nu ra Jesús, bi hyu ra mbosa mahøn'a nɛ bi mbähä yʉ́ xädi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nu'a ran 'yohʉ min 'yohʉ ra zįthu, ɛ̨mmɛ in ndehma da dɛn'na ra Jesús. Pɛ nu'a ra Jesús him bi japi da mba. Pɛ bi 'yɛ̨mbi: ");
INSERT INTO otmNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ní mba ni ngu nɛ gui mam bʉ 'bɛ'a bi 'yøt'a'a Oją. Nɛ nu'a ran 'yohʉ bi mba rá ngu bʉya, nɛ bi mam bʉ rá hnini a ran ho bi 'yørpa ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nu'bʉ mi mbeng bʉ ra Jesús 'danguadi ra dądehe, ɛ̨mmɛ bin johya yʉ ją'i nguetho xʉn ngu mi tømp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nɛ 'bex bi zøm bʉ 'bʉh ra Jesús a ra Jairo, n'da ra ngʉrpi bʉ ja ra niją, nɛ bin dąnyahmu bʉ ja rá gua, nɛ bi 'yäp ra mate da mba ra Jesús bʉ ja rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nguetho hønt'a n'datho rá t'įxu mi 'bʉi, ngue 'dɛ'ma yonjɛya mi pɛ'ts'i, nɛ in nde da du. Nɛ nu'bʉ mi mbähä ra Jesús, ɛ̨mmɛ dʉ bʉ yʉ ją'i bʉ ní mba. ");
INSERT INTO otmNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nɛ nu'bʉ mi mba bʉ 'yu, hin ní zøm bʉ ja rá ngu ra Jairo, bi zʉ'a n'da ra xisu mí hɛ̨mb ra mbäji, ngue 'dɛ'ma yonjɛya mi hɛ̨mp'a ran ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pɛ nu'a ra xisu bʉya bi därpa rá nyąmpahni bʉ ja rá xʉthä ra Jesús, nɛ 'bex bin hɛ̨'a ran ʉ mi hɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Bex bi 'yän'na ra Jesús: ―To'o bi därca ma pahni, bi 'yɛ̨na. Pɛ gätho ʉ mi 'bäpʉ bi 'yɛ̨mbi: “Njom bi dä'i.” Nɛ'a ra Pedro nɛ mi'da yʉ́ xädi bi 'yɛ̨mp'a: ―Hanja gní 'yɛ̨na 'bo'o bi dä'a i, nɛ ɛ̨mmɛ i dʉ yʉ ją'i bʉ gní mba, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Pɛ dí pądi ngue n'da ra ją'i bi däqui nguetho ma ts'ɛdigä ín ho'a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nɛ nu'bʉ mi bą'a ra xisu hingui sä din cøni, ɛ̨mmɛ bin su, nɛ di fɛt'i, nɛ bin dąnyahmu bʉ ja rá gua ra Jesús, nɛ bi xifi 'bɛ'a í dädi. Nɛ bi 'yɛ̨na ngue 'bex bi yąm 'bʉ mi dädi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nu ra Jesús bi 'yɛ̨mthoho: ―Grá xisu, bi zä bi yąn'i nguetho gá 'yɛ̨c'yɛi i ja ma ts'ɛdi. Ní mba ya nɛ da hyu ni mbʉi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nɛ yąui ra xisu a ra Jesús 'bʉ mi zøm bʉ 'da yʉ́ 'yɛ̨hɛ ra Jairo xí nɛxpʉ ja rá ngu, nɛ bi 'yɛ̨mbi: ―Nu ni t'įxu ya bi du'a, säti thoho guí pah na ra Hmu, bi t'ɛ̨mp'a ra Jairo. ");
INSERT INTO otmNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pɛ nu'a ra Jesús mi øde 'bɛ'a bi man'a, nɛ bi 'yɛ̨mp'a ra Jairo bʉya: ―O guín su, pɛ dami 'yɛ̨c'yɛi nɛ din nu'a ni t'įxu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nɛ nu'bʉ mi zøm bʉ ja rá ngu a ra Jairo bʉya, nu ra Jesús him bi japi da tho'a mbo yʉ ją'i bʉ 'bɛn'a ra hmute xí du. Hønt'a ra Pedro nɛ ra Jacobo nɛ ra Xuua, nɛ rá mbe nɛ rá ta ra hmute bi thopʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nɛ mi 'bʉpʉ xʉn ngu yʉ ją'i mi zoni ngue xí du'a ra hmute. Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―O guí zomhbʉ nguetho hingui tu na, i ątho na, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pɛ nu yʉ ją'i bi den'na ra Jesús nguetho mi pądi ya xí du'a ra hmute. ");
INSERT INTO otmNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nu'a ra Jesús bi bɛntpa rá 'yɛ ra hmute nɛ bi 'yɛ̨mbi: ―Nu'i grá hmute, dami ndants'i. ");
INSERT INTO otmNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nɛ 'bex bi ndants' pʉya, bin ja rá te, bim 'bʉi mahøn'a. Nu ra Jesús bi 'yɛ̨na: ―Dami 'uįmmi na ni t'įxuui ya, bi t'ɛ̨mp'a rá ta nɛ rá mbe. ");
INSERT INTO otmNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nu rá ta nɛ rá mbe bi hyonya thoho ngue bi dąmbɛ̨ni rá t'įxu. Pɛ nu'a ra Jesús bi xifi njon da xifi 'bɛ'a bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nu ra Jesús bi zohn'dʉ 'dɛ'mayoho yʉ́ xädi nɛ bi un yʉ́n t'ɛ̨di ngue da hyøn'a thi yʉ zįthu in 'yohʉ 'da yʉ ją'i, nɛ di hocua yʉn ʉ i hɛ̨mb yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nɛ bi mbɛhn'dʉ yʉ́ xädi din 'yo bʉ ja yʉ hnini bʉ, nɛ da mam bʉ 'bɛpʉ ní manda rá ts'ɛdi Oją, nɛ di hoc yʉn zäman'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nɛ bi xi'ʉ hin te da hyąts'i, nɛ hin da hyąx rá tøhø xíng ra mbɛti xínga gue mi'da yʉ́ pahni. Da mbatho. ");
INSERT INTO otmNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nɛ bi 'yɛ̨mp'ʉ: ―Hønt'a to'o rá ngu bʉ guí cʉthʉ, gam 'bʉhmbʉ bʉ gue'bʉ go gá thohmbʉ bʉ ja man'da ra hnini. ");
INSERT INTO otmNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nɛ nu'bʉ gá cʉthʉ bʉ ja 'da yʉ hnini nɛ hin da 'yømanho yʉ ją'i bʉ 'bɛ'a guí mamhbʉ bʉ, nɛ 'bex gui pømhbʉ bʉ ja yʉ hnini nɛ gui huąjʉ rá häi i pät ni mbonguahʉ, ra hmɛpya ngue gui zohmbʉ bʉ ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nu yʉ xädi bʉya bi mba hønbʉ go hapʉ ja yʉ hnini nɛ bi mam bʉ ran ho ma'da'yo. Nɛ bi hoc yʉ hyɛ̨nni. ");
INSERT INTO otmNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nɛ mí ø'a ra ts'ʉt'abi Herodes 'bɛ'a gätho i øt'a ra Jesús, nɛ bi hyonya thoho. Nguetho nu'ʉ 'da yʉ ją'i bi bɛ̨ni gue'a ra Xuua Nxixyą a, gue bi ndants' mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nu'ʉ mi'da bi bɛ̨ni gue gue'a ra Elías a ra Jesús, uague man'da rá pøngahyą Oją ngue bi dąmbɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pɛ nu'a ra Herodes bi 'yɛ̨na: ―Nugä dá manda bi thɛcpa rá 'yʉga ra Xuua Nxixyą, janangue'a dí pądi hinga gue'a ra Xuua a guí mamhbʉ. Pɛ to'o maha a, bi 'yɛ̨n'a ra Herodes. Janangue ɛ̨mmɛ min nde da nusɛ a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nu yʉ́ xädi bʉya bá peng bʉ xí 'bɛhni, nɛ bi xih ra Jesús 'bɛ'a bi 'yørpʉ bin 'yo. Nɛ nu'a ra Jesús bʉya bi mbäsɛhʉ yʉ́ xädi bʉ ja ra hnini Betsaida. ");
INSERT INTO otmNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pɛ nu'bʉ mi bą'ʉ yʉ ją'i hapʉ ní mba a ra Jesús, bi dɛnni. Nɛ nu'a ra Jesús bi zomanho ʉ 'bʉ mi zʉdi, nɛ bi xi'ʉ bʉya 'bɛpʉ ní manda rá ts'ɛdi Oją, nɛ bi hoc'ʉ gätho yʉn zäman'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pɛ nu'bʉ mi ts'ʉtho da yʉh ra hyadi, gätho ʉ 'dɛ'mayoho yʉ́ xädi ra Jesús bi xifi da 'yɛt' yʉ ją'i, da mba bʉ n'danni ja yʉ hnini, din sihmɛ bʉ nɛ bá opʉ 'bʉ bin xui. “Nguetho hin'yʉ 'bɛ'a da zi ua ma'ueni,” ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Pɛ nu'a zɛhɛhʉ gui 'uįmhbʉ. Nu'ʉ yʉ xädi bʉya bi 'yɛ̨mp'a ra Jesús: ―Pɛ hønt'ʉ cʉt'a yʉ hmɛ nɛ yoho yʉ t'ʉhuą i ja ua. Pɛ hinda høn 'bʉ ga tämhbe mi'da yʉ hmɛ, sä ga 'uįmhbe gätho yʉ ją'i i 'bʉcua bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nguetho mbɛ cʉt'a mahuąhi mi 'bʉpʉ yʉn 'yohʉ. Nu'a ra Jesús bʉya bi xi'ʉ yʉ́ xädi di japi 'da n'danni da hyu'i yote ma 'dɛt'a yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nɛ bi hyu pʉ ya gätho tengu xi xifi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nɛ nu'a ra Jesús bi hyąn'a ra hmɛ nɛ yʉ huą, bi ndøs' mahɛ̨ts'i, nɛ bi jąp'ʉ. Nɛ bi xɛni bi un yʉ́ xädi di darpa ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nɛ gätho na ngu yʉ ją'i bin niyą nɛ bi bong thoho, 'dɛ'mayo 'bøts'e bi mbɛs'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","N'da ra pa bin yąsɛui Oją ra Jesús, min 'yohʉ ʉ yʉ́ xädi. Nu'bʉ mi gua'a bin yąui Oją, bi 'yän'dʉ yʉ́ xädi: ―'Bɛ'a man yʉ ją'i nanguecä, 'bɛ'a im bɛ̨n'ʉ to'ogä. ");
INSERT INTO otmNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nu yʉ́ xädi bi 'yɛ̨mp'a: ―Nu'ʉ 'da i ma gue'e grá Xuua Nxixyą. Nɛ nu'ʉ mi'da i ma gue'e gra Elías, nɛ nu'ʉ mi'da i ma gue'e man'da ra pøngahyą mi 'bʉh maya'bʉ ngue bi dąmbɛ̨ni, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nɛ nu'a ra Jesús bi 'yänzɛhɛ yʉ́ xädi: ―Pɛ xi ahʉ, 'bɛ'a guím bɛ̨mhbʉ to'ogä. Nɛ nu'a ra Pedro bi 'yɛ̨mbi: ―Nu'i gra Cristo rá Thahni i Oją, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nɛ nu'a ra Jesús bʉya bi hɛcpa yʉ́ xädi njon da xifi to'o a. ");
INSERT INTO otmNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nɛ bi 'yɛ̨mp'ʉ: ―Nugä ngue dán ją'igä ua ja ra ximhäi, i jatho ga nu ran ʉnbi xʉn ngu. Nu ma ngʉrpihʉ yʉ dąc'yɛi nɛ yʉ ngʉrpa mbäją nɛ yʉ xänbate niją hin da 'yɛ̨c'yɛigui. Nɛ nu'ʉ da hyogä ʉ, pɛ ná hyu pa ga thąmbɛ̨nigä nɛ dam 'bʉi mahøn'a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nɛ man'da bi xi'ʉ yʉ́ xadi, bi 'yɛ̨mp'ʉ: ―To'o gätho in nde da dɛngui da hyɛh rán t'ɛ̨di zɛhɛ nɛ da hyät yʉn ʉnbi n'da pa ngu n'da pa, madague da tho. Nɛ da bɛ̨ni tengu dím bɛ̨ngä. ");
INSERT INTO otmNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pɛ nu'bʉ 'bʉ a n'da im bɛ̨n rá te, nɛ i su da nu yʉn ʉnbi, pɛ da nu ran ʉnbi maząi a. Pɛ nu'a hinguim bɛ̨n rá te madague da tho 'bʉ da dɛngä, di pøh rá te a. ");
INSERT INTO otmNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hin te di muui n'da ran 'yohʉ 'bʉ da 'yøt'e rá mbɛti 'bɛ'a gä i ja ua ja ra ximhäi, 'bʉ hin da dįn'a ra temaząi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nɛ nu'a gätho to'o i pɛs' rá sä nanguecä nɛ nangue mam hmangä, nɛcä hín ga ɛ̨mbi ma t'ʉhni ʉ 'bʉ bá ɛ̨cä ua nɛ gan 'yohe yʉ́ hoga m'bɛhni Oją mahɛ̨ts'i, nɛ din jagä rá ts'ɛdi Oją ma Ta, nugä ngue dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pɛ majuąni dí xi ahʉ, 'bʉcua 'da hin da nu ran dąte asta gue'bʉ go di dʉ'mi di manda rá ts'ɛdi Oją ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mbɛ ná hyąto pa bʉya, ra Jesús bi mbähä bʉ ja n'da ra nyuni ra Pedro, ra Jacobo nɛ ra Xuua, ngue din yąui Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nɛ nu'bʉ min yąui Oją a ra Jesús, 'dan'yo bʉ í nɛqui a rá hmi nɛ nu rá pahni ɛ̨mmɛ xʉn t'axi, di fɛxni a. ");
INSERT INTO otmNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nɛ 'bex bi nɛqui bʉ ra Moisés nɛ ra Elías bin yąhʉ ra Jesús, mi 'bʉh maya'bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nɛ bi hyärpʉ n'da ran nɛqui hapʉ mi 'bä ʉ. Nɛ nu'ʉ bi mamhbʉ 'bɛ'a da t'ørpa 'bʉ bi tho bʉ Jerusalén a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pɛ nu'a ra Pedro nɛ'ʉ min 'yohʉ bi zʉh ra t'ąha ʉ, pɛ nu'bʉ min nuhu bi nu di hyärpʉ n'da ran nɛqui bʉ 'bäh ra Jesús nɛ ra Moisés nɛ ra Elías. ");
INSERT INTO otmNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nɛ nu'bʉ ma guepʉ da mba ra Moisés nɛ ra Elías, nu ra Pedro bi 'yɛ̨na: ―Ma Hmu i, ɛ̨mmɛ xʉn ho ngue dí 'bʉhmbʉ ua ya, ga høcähe hyu yʉ t'ʉngu, 'da'a n'da ni mbɛtihʉ. Nu'i, nɛ ra Moisés nɛ ra Elías, bi 'yɛ̨na. Pɛ him mim bɛ̨n'a mi man'a. ");
INSERT INTO otmNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nɛ nu'bʉ mi 'yɛ̨n'a ra Pedro, 'bex bá cą n'da ra güi bi go'ma ra Moisés nɛ ra Elías, nɛ ɛ̨mmɛ bin su'ʉ yʉ́ xadi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nɛ bi t'øpʉ n'da ra nde bʉ ja ra güi ngue bi 'yɛ̨na: ―Nuna ma ts'ʉnt'ʉ dadí huɛ̨cä na, dami 'yøhmbʉ 'bɛ'a i man na, bi 'yɛ̨n'a ra nde. ");
INSERT INTO otmNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nɛ nu'bʉ mi gua'a bi man'a ra nde bʉ ja ra güi, nu yʉ xädi bi nu 'bäsɛ bʉ ra Jesús. Nɛ nu'ʉ yʉ xädi, njom bi xi'ʉ 'bɛ'a bi nu'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nu'bʉ mi hyax bʉya, bi gąpʉ ja ra nyuni ra Jesús nɛ'ʉ hyu yʉ́ xädi min 'yohʉ. Nɛ xʉn ngu yʉ ją'i bin c'athʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nu n'da ran 'yohʉ nts'ɛdi bi mbafi: ―Xänbate i, nurqui ts'ʉ ma ts'ʉnt'ʉ nguetho hønna zʉ n'datho dí si. ");
INSERT INTO otmNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nɛ ja'bʉ im bɛnt ra zįthu nɛ ɛ̨mmɛ di ʉnba a, i tɛxa hai, nɛ ɛ̨mmɛ mbafi, nɛ di fɛt rá ją'i, nɛ i soh yʉ fʉgui. Nɛ ząi di ja bʉ ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nɛ dá xi'ʉ ni xädi di hoqui, pɛ nu'ʉ him bi zä bi hoqui, bi 'yɛ̨n'a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'ahʉ guexta'a hin guí ɛ̨c'yɛihʉ 'bɛ'a dí xi ahʉ. Ham'mi pa ngue ga tøp'a thohohʉ ngue gui 'yɛ̨c'yɛigahʉ. Nɛ xø bi 'yɛ̨mp'a ran 'yohʉ bʉya: ―Bá si ua ni ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɛ nu'bʉ bá si ra ts'ʉnt'ʉ, bi bɛnt mahøn'a a ra zįthu, bi dɛxa häi nɛ nts'ɛdi bi ʉnbi. Pɛ nu'a ra Jesús bi xi'a ra zįthu da bøni, nɛ bi hoc'a ra ts'ʉnt'ʉ bʉya. Bi xi'a rá ta da zix bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nɛ gätho yʉ ją'i bi hyonya thoho a rá ts'ɛdi Oją. Nɛ guexta'a i yą ʉ yʉ ją'i nɛ i ma 'bɛ'a gätho i øt'a ra Jesús. Nu ra Jesús bʉya, bi 'yɛ̨mp'ʉ yʉ́ xädi: ");
INSERT INTO otmNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Dami 'yøhmbʉ xʉn ho a dí xi ahʉ ya, nugä ngue dán ją'igä ua ja ra ximhäi, da mba ma dägä bʉ 'bʉh yʉ ts'om'bäi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pɛ nu'ʉ yʉ́ xädi him mi pądi 'bɛ'a nam bøn'a i man'a ra Jesús, nguetho Oją hin ní japi da bą'ʉ, nɛ bi zu da 'yän'na ra Jesús 'bɛ'a nam bøn'a bi man'a. ");
INSERT INTO otmNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nu'ʉ yʉ́ xädi bin junzɛhɛ ʉ nangue'a to'o dim 'bɛt'o. ");
INSERT INTO otmNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nɛ nu'a ra Jesús mi pądi 'bɛ'a mim bɛ̨n ʉ, nɛ bá si n'da ra t'ʉhni bi mbämp'ʉ i 'bäi, ");
INSERT INTO otmNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Hønt'a go to'o da zimanho n'da ra t'ʉhni tengu na ngue i ɛ̨c'yɛigui, nɛcä bi zimanhog 'bʉ ya bi ' yøt'a. Nɛ to'o bi zimanhogä nam bøni bi zimanho ma Ta. Nɛ nu'a to'o i øt'e ngue nte di muui, gue'a dim 'bɛt'o a, bi ' yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nu ra Xuua bʉya bi xi'a ra Jesús, bi 'yɛ̨mbi: ―Nugähe dá nuhe n'da ran 'yohʉ bi ndøn'na ni thuhu 'bʉ mi hyøn'a thi yʉ zįthu, nɛ dá hɛcuahe nguetho him man 'yogähe a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pɛ nu'a ra Jesús bi 'yɛ̨mbi: ―Nde'bʉ hin xquí hɛcuahʉ, nguetho nu'ʉ hingui sʉjʉ ma amigohʉ ʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nɛ ya mi ts'ʉtho da zøn ra pa da mba mahɛ̨ts'i ra Jesús. Nɛ bi nde bi mba bʉ Jerusalén, madague i pądi da mba ma ʉnbi bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nu'bʉ mi mba bʉ 'yu, bi xifi da tho'ʉ 'da yʉ́ xädi, da hyonbi hapʉ din säya. Nɛ nu'ʉ yʉ́ xädi bʉya, bi yʉrpʉ ja n'da ra hnini bʉ ra xɛqui Samaria. ");
INSERT INTO otmNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pɛ nu yʉ ją'i bʉ hinguin ndepe din säya bʉ'a ra Jesús, nguetho him bi numanho ngue ní mba ba nu ra dąmpɛti bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nɛ nu ra Jacobo nɛ ra Xuua ɛ̨mmɛ bin cuɛ 'bɛ'a bi man yʉ ją'i bʉ bʉya. Nɛ bi 'yɛ̨mp'a ra Jesús: ―Ha guín nde ngue ga mandagä'be ra sibi ba cąh mahɛ̨ts'i, nɛ din zø'ʉ gätho 'bʉcua, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pɛ nu ra Jesús bi dąmhyą ʉ yʉ́ xädi bʉya, gue hingui ho a im bɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nɛ bi thopʉ man'da ra hnini bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nɛ nu'bʉ mi 'yo bʉ 'yu ra Jesús bi 'yɛ̨n'a n'da ran 'yohʉ: ―Ma Hmu i, nugä ga tɛn'ni i hønbʉ go hapʉ guí mba, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nu ra Jesús bi 'yɛ̨mp'a: ―Nu yʉ haho i ja yʉ́ oi bʉ ja yʉ hyądo, nɛ yʉ doja i ja hapʉ din säya ʉ, pɛ nugä ngue dán ją'igä ua ja ra ximhäi, hin hapʉ i jasɛ ma oigä ua, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nu ra Jesús bʉya, bi 'yɛ̨mp'a man'da ran 'yohʉ: ―Dami tɛngui, bi 'yɛ̨mbi. Pɛ nu'a ran 'yohʉ bi 'yɛ̨m bʉya: ―Grá Hmu, 'bɛ ga äcä ma ta 'bʉ bi du. ");
INSERT INTO otmNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nu ra Jesús bi 'yɛ̨mbi: ―Pɛ gue'ʉ hingui ja ra te ma'da'yo, da 'yä'ʉ xøn du. Pɛ nu'i gui tɛngui, gui xih yʉ ją'i 'bɛpʉ ní manda rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Xø man'da ran 'yohʉ bi 'yɛ̨mp'a ra Jesús: ―Ma Hmu i, dín nde ga tɛn'ni i, pɛ 'bɛ ga mbagä bʉ ma ngu dan 'yɛ̨'be ma ta nɛ ma mbe. ");
INSERT INTO otmNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pɛ nu ra Jesús bi 'yɛ̨mbi: ―Gätho to'o ɛ̨na da dɛngui nɛ im bɛ̨n'a bi zogui, hing yʉ́n sähʉ bʉ di manda rá ts'ɛdi Oją ʉ. Nu'a i øt'ʉ tengu øt'a n'da ran 'yohʉ 'bʉ i hɛnhäi nɛ in yɛ̨h rá xʉthä, hingui uɛ̨ntho yʉ́ the i hɛqui. ");
INSERT INTO otmNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nubʉya nu'a ra Jesús bi huan'dʉ hyąte ma 'dɛt'a yʉ́ xädi nɛ bi mbɛhni 'da'i yoho bʉ ja yʉ hnini guepʉ da thosɛ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nɛ bi 'yɛ̨mbi: ―Tenguthoho 'bʉ ya xø 'yo't'a n'da ra huąhi, pɛ zʉ yonją'i tho ʉ yʉ xofo, xʉn ngu ʉ yʉ ją'i da 'yɛ̨c'yɛi, pɛ go zʉ yoho thoho ʉ da xifi. Dami 'yäfʉ Oją ra Hmu ba pɛnh mi'da yʉ mbɛfi da xih yʉ ją'i da 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","'Bex gui mbähä ya, nɛ nugä dí pɛn'nahʉ tengu'ʉ yʉ dɛ'yo 'bʉ da mba bʉ 'bʉh yʉ zate. ");
INSERT INTO otmNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nɛ o guí hąx ni mbɛtihʉ, xín ni buxahʉ, xín gui cʉxhʉ ná yopare ni thįxfanihʉ, gui mbäthohʉ nɛ hinga nya'a gui zɛnguahʉ yʉ ją'i bʉ 'yu. ");
INSERT INTO otmNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nɛ nu'bʉ guí cʉthʉ bʉ ja n'da ra ngu ngue di säya ahʉ a ra mɛngu bʉ, gui zɛnguahʉ, nɛ gui 'yäfʉ Oją da 'yɛnspa rán jąpi a ra mɛngu bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nɛ nu'bʉ in nde rán jąpi Oją a ra mɛngu bʉ, da gohmi a rán jąpi Oją 'bʉ, pɛ nu'bʉ hinguin nde, nte da gohmi 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nɛ nu'bʉ gá sømhbʉ bʉ ja n'da ra hnini, gam 'bʉhmbʉ bʉ hapʉ rá mbʉdi da mba ma säya ahʉ. Hin gui päpʉ gam 'bʉhmbʉ. Nɛ gui sihʉ 'bɛ'a gätho din 'da ahʉ, nɛ hin gui pɛs' ni sä gui sihʉ nguetho gue'a guí tąhmbʉ a ngue guí xihmbʉ rám hman Oją ʉ. Nɛ njo'o n'da ra mbɛfi ngue hin da mba njut'i. ");
INSERT INTO otmNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nɛ hønt'a go má hnini nguepʉ da ts'in ahʉ, gui sihʉ 'bɛ'a gätho di 'da ahʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nɛ gui hoc'ʉ yʉn zäman'ʉ i 'bʉpʉ, nɛ gui xihmbʉ yʉ ją'i ngue mi ts'ʉtho di manda rá ts'ɛdi Oją ua. ");
INSERT INTO otmNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pɛ hønt'a go nda'a má hnini gui cʉthʉ, nɛ nu'bʉ hin da zin ahʉ yʉ ją'i bʉ, gan 'yohʉ bʉ ja ra hnini, nɛ gui 'yɛ̨mfʉ yʉ ją'i: ");
INSERT INTO otmNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nugähe dí huąc ma guahe ra fonthäi ua ja ni hninihʉ, ra hmɛpya ngue ga sogahe ua. Pɛ gui pąhmbʉ ɛ̨na xtí manda maha ua rá ts'ɛdi Oją,” gui 'yɛ̨mfʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nɛ dí xi ahʉ, nu'bʉ bi zøn ra pa ran juąnbi, man'da xʉn ʉ tho ran ʉnbi da nu'ʉ, xinda gue'ʉ mi 'bʉpʉ ja ra hnini Sodoma, bi 'yɛ̨n'a ra Jesús 'bʉ mi 'yɛ̨mp'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Í huɛ̨hi gätho ahʉ guí 'bʉhmbʉ bʉ ja ra hnini Corazín, nɛ gätho ahʉ guí 'bʉhmbʉ bʉ ja ra hnini Betsaida, nguetho ya gá nuhʉ yʉn t'øt'e nuįxte dá øt'ä nɛ hin gá päh nin 'yomfɛ̨nihʉ. Nu yʉ ją'i mi 'bʉpʉ ja ra hnini Sidón nɛ'ʉ mi 'bʉpʉ ja ra hnini Tiro, nu'bʉ xtá nu'ʉ yʉn t'øt'e nuįxte gá nuhʉ ya, xtí päh yʉ́n 'yomfɛ̨ni ʉ, nɛ xtá hye yʉ pahni tengu yʉ 'døzą nɛ xtá 'yʉx yʉ 'bospi yʉ́ ją'i, ra hmɛpya ngue ɛ̨mmɛ tu yʉ́ mbʉi nangue yʉ́ ts'oqui ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nɛ nu'a ra pa rán juąnbi Oją, nu ahʉ man'da da zän'nahʉ ran ʉnbi xinda gue'ʉ mi 'bʉpʉ ja ra hnini Tiro nɛpʉ ja ra hnini Sidón. ");
INSERT INTO otmNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nɛ ahʉ guí 'bʉhmbʉ bʉ ja ra hnini Capernaum, gnín 'yɛ̨xhʉ a ngue guí ɛ̨mhbʉ gui sømhbʉ bʉ mahɛ̨ts'i, pɛ hin'na, pɛ guepʉ ja ran ʉnbi maząi gui mbähä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nɛ bi 'yɛ̨mp'ʉ yʉ́ xädi bʉya: ―Nu'ʉ i øh ni ndehʉ, tengu'bʉ ma ndesɛgä bi 'yø'ʉ. Nu'ʉ to'o hin da zin ahʉ tengu tho'bʉ him bi zingä'ʉ, nɛ nu'ʉ him bi zingä, xím bi zin'a ma Ta bá pɛngä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nu'bʉ mambá penc'ʉ hyąte ma'dɛt'a yʉ́ xädi a ra Jesús bʉ bi mbɛhni, ɛ̨mmɛ bin johya ʉ. Nɛ bi 'yɛ̨mp'ʉ: ―Grá Hmu, hinga hønt'ʉ yʉn zäman'ʉ dá hoje pɛ nɛ'ʉ yʉ zįthu dá hømhbe thi 'bʉ má ndømhbe ni thuhu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nu ra Jesús bi 'yɛ̨mp'ʉ bʉya: ―Dá nugä rá hmu yʉ zįthu 'bʉ gmí tąfʉ, bi mba häi tengu ra huɛi 'bʉ xʉn gąi, bi 'yɛ̨na, nɛ ya dá 'da ahʉ ra ts'ɛdi gui tąfʉ rá ts'ɛdi man sʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pɛ madague gui nɛs'hʉ yʉ pozʉ bʉ gui thohmbʉ, nɛ yʉ mbozʉ, pɛ nte da ja ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pɛ hin gan johyahʉ ngue bi zä guí hømhbʉ thi yʉ zįthu, pɛ nu'a gdín johyahʉ ngue bi zin ahʉ Oją nɛ bi hyux ni thuhuhʉ bʉ mahɛ̨ts'i, bi 'yɛ̨n'a ra Jesús 'bʉ mi 'yɛ̨mp'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nubʉya nu rá Hogandąhi Oją bi japi ɛ̨mmɛ di johya ra Jesús, nɛ bi 'yɛ̨na: ―Dí ɛ̨'ts'a i nguetho gá japi bi bą'a ni ts'ɛdi ʉ i hon'i, tengu yʉ t'ʉhni ngue hin te i pądi, nɛ hinga gue'ʉ im bɛ̨nsɛ ja yʉ́n 'yomfɛ̨nisɛ gá japi bi bą'ʉ. Nɛ gue'a gá 'yøt'e ma Oją i, ngue gue'a gá numanhosɛ guí øt'e, bi 'yɛ̨mp'a Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Gätho i ja a ma Ta bi 'daqui. Nɛ hønsɛ ma Ta i pącä xʉn ho ngue rá Ts'ʉnt'ʉgä, nɛ hønsɛgä rá Ts'ʉnt'ʉgä dí pącä xʉn ho a ma Ta, nɛ'ʉ to'o ga japi da bą'a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nɛ bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Gan johyahʉ ngue guín nuhʉ a dí øt'ä ya. ");
INSERT INTO otmNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Majuąni dí xi ahʉ, xʉn ngu yʉ́ pøngahyą Oją nɛ xʉn ngu yʉ ts'ʉt'abi mi 'bʉi, mi nde da nu'a guín nuhʉ ya, nɛ da 'yø'a guí øhmbʉ ya, pɛ him bi zä, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nɛ bi zøm bʉ 'bʉh ra Jesús n'da ra xänbate niją, im bɛ̨ni da zä'a ra Jesús, nɛ bi 'yänni: ―Xänbate i, 'bɛ'a sä ga øt'ä n'dahma din jagä ra te maząi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","―Bɛ'a mam bʉ ja yʉ́n t'ɛ̨di ra Moisés, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nu'a ra xänbate niją bi 'yɛ̨na: ―I mam bʉ: “Gam bɛ̨mhbʉ Oją ra Hmu ngue gätho ma mbʉihʉ nɛ gätho ma tehʉ, nɛ gätho ma ts'ɛdihʉ, nɛ gätho man 'yomfɛ̨nihʉ, nɛ ga huɛ̨c ma miją'ihʉ tengu bʉ nan huɛ̨c zɛhɛhʉ,” i ɛ̨n rán t'ɛ̨di Oją, bi 'yɛ̨n'a ra xänbate niją. ");
INSERT INTO otmNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Bi dą'a ra Jesús bʉya: ―Majuąni guí ma. Nuya gui 'yøt'ʉ nɛ din ja'a ra te maząi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nu ra xänbate niją mi pąpʉ mbo rá mbʉi ngue hinga gue'a mí øt'e, nɛ bi 'yɛ̨mthoho: ―Pɛ to'o ma miją'i'be ga huɛ̨cä, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nɛ nu'a ra Jesús bi xi'a n'da ran t'uti nɛ bi 'yɛ̨mbi: ―Nu n'da ran 'yohʉ mi 'yo bʉ ja ra 'yu, bí nɛxpʉ Njerusalén ní mba bʉ Jericó. Nɛ nu'ʉ 'da yʉ bɛ̨ bi gorpa'yu nɛ bi ʉnba'a ran 'yohʉ, nɛ gätho ʉ yʉ́ pahni mi he bi gąspi nɛ'a rá mbɛti. Nɛ bi zopʉ nden'yu a ran 'yohʉ bʉya, ɛ̨na da du. ");
INSERT INTO otmNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nɛ bi thopʉ n'da ra mbäją, nɛ bi nu'a ran 'yohʉ 'bɛm bʉ pɛ bi mbäcthoho. ");
INSERT INTO otmNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nɛ'a man'da ran 'yohʉ, ra mbɛfi bʉ ra niją a, bi thopʉ, bi nu'a ran 'yohʉ 'bɛm bʉ, nɛ'a bi mbäcthoho tengu bi 'yøt' ra mbäją. ");
INSERT INTO otmNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pɛ nu'a n'da ran 'yohʉ, ra mɛngu Samaria, 'bʉ mi thopʉ bʉya, bi nu mi 'bɛm bʉ a ran 'yohʉ, nɛ bi huɛ̨c'a. ");
INSERT INTO otmNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nɛ bi xispa ra aceite nɛ ra vino bʉ xí ts'ɛrbi, nɛ bi mbantpa ra 'bø't'e. Nɛ bi 'yɛ̨xa rá fani bʉya, bi zixpʉ ja n'da ra ngun'oi nɛ bi jamansu'a. ");
INSERT INTO otmNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nɛ nu'bʉ mi hyats'i, bi thopʉ ní mba, nɛ bi zocpi ts'ʉ ra mbɛti a ra mɛngu bʉ, nɛ bi xifi di jamansu'a ran 'yohʉ, nɛ da gurpa rá gasto 'bʉ hin dí gua'a 'bʉ bá peng bʉ ní mba, bi 'yɛ̨n'a ra Jesús 'bʉ mi man ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nubʉya bi 'yän'na ra xänbate niją: ―Xiya, nda'a nín 'yohʉ bi 'yørpa ran huɛ̨cate rá miją'iui. Bi dą'a ra xänbate niją: ");
INSERT INTO otmNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","―Nu'a bi mbäts'i. Nu ra Jesús bi 'yɛ̨mp'a bʉya: ―Ní mba din jabʉ gui 'yørpa ni miją'ihʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ra Jesús nɛ'ʉ yʉ́ xädi mi 'yo bʉ ja ra 'yu ní mba bʉ ja ra hnini Jerusalén, nɛ bi zøm bʉ ja n'da ra hnini guepʉ 'bʉ'a n'da ra xisu í Marta a. Nɛ nu'a ra Marta bi xi'ʉ din säya bʉ ja rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nɛ mi 'bʉpʉ n'da rá juhuɛ í María. Nu'a mi hupʉ i yą ra Jesús, bi 'yø'a bi man'a. ");
INSERT INTO otmNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pɛ nu'a ra Marta, xʉn ngu ra 'bɛfi i øt'e. Nɛ bi 'yɛ̨mp'a ra Jesús: ―Ma Hmu'i, ha hin guí ʉrpa ra güɛnda 'bɛ'a øt' ma cu, nde'bʉ gui xifi di zɛqui, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nu ra Jesús bi dąt'a: ―Ma zʉ Marta, ɛ̨mmɛ guím bɛ̨n'a ni 'bɛfi. ");
INSERT INTO otmNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pɛ n'datho a mahyoni xʉn ho, nɛ gue'a bi huan'na ra María, nɛ njon di 'uecpa'a mam hmangä i øde, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","N'da ra pa bi 'ue'a ra Jesús nɛ bin yąui Oją. Nɛ nu'bʉ mi gua'a bin yąui Oją, n'da rá xädi bi 'yɛ̨mbi: ―Ma Hmu'i, dami xängahe dan yąhe Oją tengu thoho ra Xuua bi xänba yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nu ra Jesús bi 'yɛ̨na: ―Ngubʉ gui mamhbʉ 'bʉ guí yąhʉ Oją: Ma Ta ahe, Da hnumansu ni thuhu Nɛ dín ndehe din ja ua n'dihi ni ts'ɛdi ngue di manda ua. ");
INSERT INTO otmNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nɛ dami 'daje ra hmɛ dí homhbe ra pa i ja bʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Dami punga ma ts'oquihe tengu thoho bʉ na punbahe ʉ i ørcahe ran ts'o. O guí hɛgähe da dąje ran ts'o, pɛ dami yąnje nangue ran ts'o, gui 'yɛ̨mhbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nɛ xø bi xih man'da ran t'uti ʉ, bi 'yɛ̨na: ―Xi'bʉ n'da ran 'yohʉ xtí mba bʉ rá ngu n'da rá amigo, made ra xui, nɛ xtá 'yɛ̨mbi: “Hmiqui ts'ʉ hyun thuhmɛ, ");
INSERT INTO otmNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nguetho nu'a n'da ma amigo ja bi zøm bʉ ja ma ngu, nɛ hin'yʉ 'bɛ'a ga unni da zi,” xtá 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nɛ xi'bʉ xtá 'yɛ̨mp thoho: “'Yo gadí paqui, nguetho ya án thʉ't'i ma ngu nɛ ya dá ohmbe gätho ma t'ʉhni, nɛ hingui sä ga ndants'i ngue ga 'da'i,” xtá 'yɛ̨ntho. ");
INSERT INTO otmNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","'Bɛ'a hmaha xtá 'yøt'a ran 'yohʉ 'bʉ. Nu'bʉ hingui pɛs' rá sä di thoqui da 'yäpi, nɛ guehma da ndants'a rá amigo nɛ di un'na bi 'yädi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","In ja bʉ 'bʉ guí yąhʉ Oją, gui thoqui gui 'yäfʉ nɛ sä thocua thoho gui hyąmhbʉ. Thocua thoho gui hyomhbʉ nɛ thocua thoho da zä gui tįmhbʉ. Thocua thoho guin zohmbʉ nɛ Oją da xoc'ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nguetho gätho to'o da 'yädi da hyąni, nɛ gätho to'o da hyoni, da dįni, nɛ gätho to'o da zofo da xocpi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","13","Nɛ nu ahʉ madague gyʉ́ ts'om'bäihʉ, xínga n'da ahʉ gadí unhdʉ ra pozʉ ni t'ʉhnihʉ 'bʉ i ä ahʉ ra huą, nɛ xíng ra mbozʉ gadí unhdʉ 'bʉ i ä'ahʉ ra do'øni, pɛ hønt'a xʉn ho gadí un ni t'ʉhnihʉ. Ha maguet'a Oją ma Tahʉ 'bʉpʉ mahɛ̨ts'i ngue him ba pɛn'nahʉ rá Hogandąhi 'bʉ guí äfʉ a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nɛ mi 'bʉpʉ n'da ran 'yohʉ hingui sä din yą, nguetho madi goreba ra zįthu. Nɛ nu ra Jesús bi hyøn'a thi ra zįthu nɛ bin yą ran 'yohʉ bʉya. Nu yʉ ją'i ɛ̨mmɛ bi hyonya thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pɛ nu'ʉ 'da bi 'yɛ̨na: ―Nuna ran 'yohʉ sä i høn'a thi yʉ zįthu, nguetho gue'a rá hmu yʉ zįthu bi un rán t'ɛ̨di na, sä ɛ̨n'ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nɛ nu'ʉ mi'da bi zä ra Jesús 'bʉ ya majuąni Oją bi un rá ts'ɛdi, nɛ bi 'yäp ra hmɛpya mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pɛ nu ra Jesús mi pąrpa yʉ́n 'yomfɛ̨ni n'da ngu n'da'ʉ nɛ bi 'yɛ̨mp'ʉ: ―Nu'bʉ din heczɛhɛ yʉ ją'i 'bʉpʉ ja n'da ra hnini, nɛ ba ɛ̨h yʉ́n sʉihʉ, hin da zä din tunhdʉ yʉ́n sʉihʉ 'bʉ. Da mba ma juadi ʉ. Nɛ ngutho ʉ 'bʉpʉ ja n'da ra ngu, 'bʉ din sʉsɛ ʉ dim 'bɛdi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nɛ ngutho rá ts'ɛdi ra zįthu, ha da zä din sʉsɛ ʉ ngue di 'bɛh yʉ́ ts'ɛdi, nɛ sä guí ɛ̨mhbʉ, ngue'a rá ts'ɛdi ra zįthu a ná høn'a thi yʉ zįthu ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'Bɛ'a ni ts'ɛdi guí ɛ̨mhbʉ i ja ni xädihʉ 'bʉ i høn'a thi yʉ zįthu. Guesɛ'ʉ i ut ahʉ ngue him majuąni guím mamhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nugä dí høn'a thi yʉ zįthu nangue rá ts'ɛdi Oją, gue'a ctí pąhmbʉ ngue ya di manda rá ts'ɛdi Oją ua guí 'bʉhmbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nɛ man'da ran t'uti bi ma, nɛ bi 'yɛ̨na: ―Nu'bʉ 'bʉ'a n'da i ja rá ts'ɛdi nɛ i ja 'bɛ'a dám fädi xʉn ho bʉ ja rá ngu, hin te da ja. ");
INSERT INTO otmNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pɛ nu'bʉ da zøm bʉ n'da ngue man'da i ja rá ts'ɛdi nɛ da dąpi, da hyąnba a nám fädi nɛ da duspi 'bɛ'a gätho i ja bʉ ja rá ngu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nu'a to'o hinga 'da'ingu dí mam'be, man sʉi'be a. Nɛ nu'a to'o hingui øt' ma 'bɛfi, di japi dim 'bɛ'ʉ mi'da. ");
INSERT INTO otmNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nɛ man'da ran t'uti bi ma, bi 'yɛ̨na: ―Nu'bʉ bi bøm bʉ ja rá mbʉi n'da ra ją'i ra zįthu, bin 'yo bʉ ja ra 'yonhäi, bi hyoni hapʉ sä dim 'bʉi, nɛ nu'bʉ him bi dįni, bi bɛ̨nsɛ ba peng mahøn'a hapʉ mi 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nɛ nu'bʉ mi zøm bʉ, bi nu njongui 'bʉpʉ, nɛ ma hoqui xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nɛ nubʉya, bi mba bá hom mi yoto yʉ zįthu man'da xʉn ts'o xinda guesɛ'a bin honte, nɛ gätho bim 'bʉhmbʉ bʉ. Nɛ nu'a ra ją'i bʉya, bi gohi man'da xʉn ts'o xinda gue'bʉ mi 'bʉpʉ n'datho ra zįthu, bi 'yɛ̨n'a ra Jesús 'bʉ mi man ran t'uti. Din ja bʉ ʉ hinga gätho rá mbʉi i ɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gätho na yą ra Jesús nɛ bi dą'a n'da ra xisu, bi 'yɛ̨na: ―Mająpi'a ra xisu bi te'e, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pɛ nu ra Jesús bʉya bi 'yɛ̨mp'a: ―Pɛ nɛ'ʉ man'da mająpi gätho to'o i øh rám hman Oją nɛ i øt'a gätho i mam bʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bi munts'ʉ yʉ ją'i bʉ 'bäh ra Jesús, nɛ nu ra Jesús bi xi'ʉ man'da ram hma, nɛ bi 'yɛ̨mp'ʉ: ―Nu'ahʉ guí 'bʉhmbʉ yʉ pa ja bʉ ya, gyʉ́ ts'om'bäihʉ, guí äjʉ ra hmɛpya mahɛ̨ts'i, pɛ hin te ma hmɛpya da t'ut'ahʉ, pɛ hønt'a n'da ra hmɛpya da t'ut'ahʉ tengu bi 'yøt'a ra Jonás. ");
INSERT INTO otmNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nɛ gue'a ra hmɛpya bi 'yøt' ra Jonás, bi bąh yʉ ją'i bʉ ja ra hnini Nínive majuąni Oją bí mbɛhn'na. Ngutho ahʉ, sä gui pąhmbʉ majuąni bá pɛngä Oją 'bʉ gá nuhʉ 'bɛ'a din jacä, nugä ngue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nɛ dí xi ahʉ, nu'a ra xisu min ts'ʉt'abi bʉ Sur, 'dat'a gui ndans'hʉ a 'bʉ bin ja ran juąnbi 'bʉ ran zɛgui. Nɛ da 'yut'ahʉ ngue i ja ni ts'oquihʉ. Nguetho nu'a yatho bá ɛ̨hɛ ngue mín nde da 'yø'a bi man'a ra ts'ʉt'abi Salomón nangue rán 'yomfɛ̨ni bi und Oją, pɛ nu ahʉ, hin guín nde gui 'yøhmbʉ a dí mangä ngue dí 'bʉhmbʉ ua. Pɛ nugä man'da i ja rá ts'ɛdi mam hmangä xinda gue ra Salomón, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nɛ xø bi 'yɛ̨na: ―Nɛ'ʉ mi 'bʉpʉ ja ra hnini Nínive 'dat'a gui ndans'hʉ ʉ 'bʉ bin ja ran juąnbi 'bʉ ran zɛgui, nɛ da 'yut'ahʉ ngue i ja ni ts'oquihʉ, nguetho nu'ʉ 'bex bi päh yʉ́ mbʉi 'bʉ mí 'yø'a bi man'a ra Jonás, pɛ nu ahʉ, xø hin guín nde gui päh ni mbʉihʉ nangue ni ts'oquihʉ. Nɛ nugä, man'da xʉn hɛ̨ts'i mam hmangä xinda gue ra Jonás, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Pɛ njon di søc'a n'da ra sibi ngue da go'mi, uague di cʉ't' pʉ ja ra huada. Pɛ i tixpʉ ja ra mbøxasibi, ndepe di yot'i gätho to'o ba ɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gue'a ni dähʉ di ja ahʉ gui hyanthʉ ran nɛqui. Nu'bʉ xʉn ho ni dähʉ, guí hanthʉ xʉn ho ran nɛqui, nɛ nu'bʉ hingui ho ni dähʉ, xʉm 'bɛxuitho bʉ guí hanthʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɛ ngutho ni mbʉihʉ di ja ahʉ gui pąhmbʉ rán nɛqui Oją. Nu'bʉ i hon ni mbʉihʉ rán ho Oją, i ja ahʉ ran nɛqui 'bʉ, nu'bʉ hin'na, sä guí ɛ̨mhbʉ i ja ahʉ ran nɛqui, pɛ hønt'a ra 'bɛxui i ja ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nguetho hønt'bʉ guín ndehʉ bʉ ni mbʉihʉ, di 'uec'ahʉ ra 'bɛxui a Oją nɛ di 'da ahʉ rán nɛqui, nɛ nubʉya gui 'yøthʉ tengu'bʉ gyʉ́ sibihʉ nɛ gui 'yuthʉ mi'da rá 'yu Oją, tengu ra nyot'i di yorpʉ ní mba n'da, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nɛ nu'bʉ mi gua'a man ra Jesús, n'da ra fariseo bi xih ná ts'ihmɛ a ra Jesús, nɛ bi mba bin sihmɛhʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nɛ nu ra fariseo bi nu him bin xʉ'yɛ ra Jesús, tengu i man yʉ́n t'ɛ̨dizɛhɛ yʉ fariseo, nɛ bi hyonya thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pɛ nu'a ra Jesús bi 'yɛ̨mp'a: ―Nu ahʉ gyʉ́ fariseohʉ, guí pethʉ xʉn ho ni ją'ihʉ, pɛ guexta'a xʉn ts'o ni mbʉihʉ. Hønt'a ran ts'iyate guím bɛ̨mhbʉ, gyʉ́ ts'om'bäi thohohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xøgue, xʉm mɛ tho ni mbʉihʉ. Nu Oją i pądi 'bɛ'a gadí jafʉ ni ją'ihʉ, pɛ nɛ'a ni mbʉihʉ i pądi 'bɛ'a im bɛ̨ni, nguetho Oją gätho bi zän'dʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pɛ nu'bʉ gui huɛ̨c ni miją'ihʉ nɛ gui fäxhʉ, da fąh pʉya mahoqui ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Í huɛ̨hi maha ahʉ, gyʉ fariseohʉ, nguetho guí hąxhʉ bʉ ja ra niją a ná 'dɛt'a yʉ́ 'yɛ̨thi yʉ tʉhʉ bi bøxpʉ ja ni huąhihʉ, pɛ go hin gá 'yøthʉ a man'da in nde Oją ngue 'da xquín numanhohʉ ni miją'ihʉ nɛ xquí huɛ̨jʉ ʉ. Guehya nde'bʉ man'da gui 'yøthʉ, madague'bʉ gui thoqui gui 'yøthʉ ʉ mi'da. ");
INSERT INTO otmNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Huɛ̨hi maha ahʉ, gyʉ́ fariseohʉ, ɛ̨mmɛ guí homhbʉ ngue da hnumansu ahʉ bʉ ja ra niją, nɛ gadí hohʉ yʉn zɛngua 'bʉ guí 'yohʉ bʉ ja ra täi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Í huɛ̨hi maha ahʉ, nu'ahʉ tenguthoho n'da ran 'yägui hingam fądi, nɛ nu'a da thopʉ hin da bądi o bʉ xʉ 'ya. Ngutho ahʉ, im bɛ̨n yʉ ją'i ngue xʉn ho ahʉ, pɛ him majuąni. ");
INSERT INTO otmNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nɛ mi 'bʉpʉ n'da ra xänbate niją, nɛ bi 'yɛ̨na: ―Nu'i grá Jesús, gra xänbate i, ɛ̨mmɛ gadí ʉnga ma mbʉihe a gá ma, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Bi dąt'a ra Jesús: ―Nɛ ahʉ, gyʉ xänbatehʉ, í huɛ̨hi maha ahʉ, nguetho ɛ̨mmɛ xʉn hɛ̨i a gá hyuspahʉ yʉ́n t'ɛ̨di ra Moisés ngue guí xihmbʉ yʉ ją'i da 'yøt'e, pɛ nusɛ ahʉ xíngui ts'ʉ guí øthʉ a guí xihmbʉ da 'yøt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Í huɛ̨hi maha ahʉ, guí hocpahʉ yʉ́ jądon'yägui ʉ yʉ́ pøngahyą Oją bi hyo'ʉ nim bombøtahʉ, ngue guí nde da 'yɛ̨n'ahʉ yʉ ją'i xʉn ho ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pɛ gue'a gní 'yuhmbʉ ngue guín numanhohʉ yʉ́n t'øt'e ʉ nim bombøtahʉ, bi hyo'ʉ yʉ́ pøngahyą Oją nɛ go gadí hocpahʉ yʉ́ jądon'yägui bi 'yo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pɛ nu Oją i pądi 'bɛ'a gätho din ja, janangue'a bi 'yɛ̨na: “Ga pɛhndä ʉ ma pøngahyą, nɛ'ʉ mi'da da mam mam hmangä. Nu'ʉ 'da da tho, nɛ nu'ʉ 'da da t'ɛthoho,” bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Janangue'a gue'a ctí nuhʉ rán ts'ɛmbi Oją nangue gätho yʉ́ pøngahyą Oją nɛ yʉ́m 'bɛhni bi mba ntho gue'bʉ go rá mbʉdi ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nu rá mbʉdi ra Abel bi tho asta gue'bʉ nɛ'a ra Zacarías bi tho bʉ mbo ra dąniją, tengu thoho 'bʉ ni ts'oquihʉ a gätho í tho'ʉ yʉ́ pøngahyą Oją, nɛ gue'a dí ʉn'nahʉ a. ");
INSERT INTO otmNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Í huɛ̨hi maha ahʉ gyʉ́ xänbatehʉ, guí pąhmbʉ 'bɛ'a nam bøn'a rá hman Oją pɛ hinga gue'a guí xänbahʉ yʉ ją'i. Him majuąni guí tɛnhdʉ a nɛ hín gadí jafʉ da dɛn'dʉ in nde da dɛnni, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Nɛ bi bøm bʉ ra Jesús bʉya. Pɛ nu yʉ xänbate niją nɛ yʉ fariseo ɛ̨mmɛ bin cuɛ, nɛ xø bi dʉ'mi ɛ̨mmɛ bi 'yän yʉn t'änni, ngue i honi 'bɛpʉ dí yąp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nɛ bim pɛti bʉ 'bʉh ra Jesús xʉn ngu yʉ ją'i, nɛ ɛ̨mmɛ din tønthoho. Nu ra Jesús bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Gam fähmbʉ nangue yʉ́ ixi yʉ fariseo ngue hin gui tɛnbahʉ yʉ́n t'øt'e, ɛ̨na xʉn ho bʉ na hnu ʉ pɛ n'dan'yo thoho im bɛ̨n yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hin gui 'yøthʉ tengu'ʉ nguetho gätho 'bɛ'a im bɛ̨m bʉ mbo rá mbʉi n'da, da fądi. Madague'bʉ ɛ̨n'ʉ njon da bądi, pɛ guehma din c'ą yʉ́ ts'oqui. ");
INSERT INTO otmNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nɛ gätho a i man'a n'da bʉ njongui øde, da hmam bʉ 'bʉh yʉ ją'i. Nɛ gätho i mam mant'ągui n'da bʉ ja rá ngu, da fąpʉ 'bʉh yʉ ją'i, bi 'yɛ̨mp'ʉ yʉ́ xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nɛ xø bi 'yɛ̨na: ―Nu'ahʉ, ma amigo ahʉ, o guí suhʉ ʉ in nde da hyo ahʉ. Nu'ʉ, sä da hyo'a ni ją'ihʉ pɛ hin'yʉ 'bɛ'a man'da i sä da 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ga xi ahʉ to'o a gui suhʉ. Dami suhʉ Oją nguetho nu'a, i sä da hyo ahʉ nɛ i ja rá ts'ɛdi da 'yɛnt'ahʉ bʉ ja ran ʉnbi maząi. Majuąni dí xi ahʉ, jatho gui suhʉ Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nɛ njom man'da gui suhʉ. Guim bɛ̨mhbʉ yʉ doja, ts'ʉtho di muui, hønt'a zʉ yocentavo di muui ʉ cʉt'a ndoja, pɛ guexta'a i pa mfɛ̨ni ʉ, Oją im bɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nɛ nu ahʉ man'da di mu ahʉ xinda gue yʉ doja bʉ ní bɛ̨n Oją, nɛ asta i pądi hangu na ngu i ja ni xtąhʉ. Janangue'a o guín suhʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Majuąni dí xi ahʉ, gätho to'o hingui su da mangua ja ra häi gue i pąqui, nugä, ngue dán ją'igä ua ja ra ximhäi, ga mam bʉ ja yʉ́ hmi yʉ́m 'bɛhni Oją, gue dí pącä ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pɛ nu'a to'o da gøngä ua ja ra häi, nɛcä ga cøngä bʉ mahɛ̨ts'i a. ");
INSERT INTO otmNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nu'a to'o di c'ąman'ʉgä nguecä ngue dán ją'igä ua ja ra ximhäi, sä da mba ma punbi 'bʉ da bɛ̨n'a bi ma. Pɛ nu'ʉ to'o di c'ąman'ʉ rá Hogandąhi Oją, hin'yʉ rá punbi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nu'bʉ pa ma yąpi'ahʉ nɛ da ts'ix ahʉ bʉ 'bʉh yʉ ngʉrpi ja ra niją o guepʉ 'bʉh yʉ zɛ'mi nɛ yʉ ts'ʉt'abi, pɛ o ɛ̨mmɛ guím bɛ̨mhbʉ 'bɛ'a sä gui mamhbʉ 'bʉ da mba ma juąnni ahʉ, ");
INSERT INTO otmNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","nguetho nu'bʉ gám 'bähmbʉ bʉ ja rá hmi ʉ, nu'a rá Hogandąhi Oją 'bex di bɛ̨n'nahʉ gui mamhbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nɛ nu'bʉ min yą'a ra Jesús, mi 'bä inde bʉ 'bʉh yʉ ją'i n'da ran 'yohʉ, nɛ bi 'yɛ̨mbi: ―Xänbate i, dami xih man 'yohʉ da xɛgäts'ʉ ra häi bi zoh ma ta'be. ");
INSERT INTO otmNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nu ra Jesús bi 'yɛ̨na: ―Nu'i, grán 'yohʉ, hin dra zɛ'migä ngue ga øt'ä a guí ma, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nɛ xø bi 'yɛ̨mp'ʉ 'bʉpʉ: ―Dami jamansu ni mbʉihʉ hin din ja ahʉ ran 'yʉya. Nguetho hinga gue'a i ja n'da dám 'bʉ'a n'da, madague'a xʉn ngu i ja. ");
INSERT INTO otmNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nɛ nubʉya, bi xi'a n'da ran t'uti, nɛ bi 'yɛ̨mp'ʉ: ―Mi 'bʉ'a n'da ran 'yohʉ ra mɛmbɛti. Nɛ nu'a rá häi ɛ̨mmɛ xʉn ho, nɛ xʉn ngu 'bɛ'a gätho bin ja bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nɛ nu'ʉ yʉ́ ngumpɛ'ts'i, ɛ̨mmɛ bi yudi nɛ bi bongthoho 'bɛ'a mi ja bʉ ja rá huąhi. Nɛ nu'a ran 'yohʉ bʉya, bi bɛ̨ni 'bɛ'a sä da 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nɛ bi bɛ̨nsɛ: “Nuya, ga xo't' ma ngumpɛ'ts'i nɛ ga høh mi'da xʉn ndoho, n'dahma din ja hapʉ ga pɛ'ts'ä 'bɛ'a gätho i jagä. ");
INSERT INTO otmNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɛ nubʉya, dam 'bʉtho, hønt'a dí hyu ma mbʉi ga øt'ä,” bi 'yɛ̨nsɛ ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pɛ nu'a Oją bi 'yɛ̨mp'a: “Nu'i, hin guí pądi 'bɛ'a guím ma, nguetho nán xui ya gui tu. Nɛ to'o hmaha da gohmi 'bɛ'a gätho guím bɛ̨ni gui hyonsɛ,” bi 'yɛ̨mbi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ngubʉ din ja gätho yʉ 'yʉya, ngue'a hønt'a i ja ua ja ra ximhäi im bɛ̨ni, pɛ hinga gue'a rá mbɛti dí yąnba yʉ́ te ʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nɛ nubʉya, bi 'yɛ̨mp'ʉ yʉ́ xädi: ―'Yo ɛ̨mmɛ gui hyądumbʉihʉ 'bɛ'a gui sihʉ nɛ 'bɛ'a gui hyehʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nɛ man'da xʉn ho guim bɛ̨mhbʉ ni tehʉ xinda gue nin sihmɛhʉ, nguetho man'da di muui ni tehʉ, nɛ'a ni ją'ihʉ man'da di muui xinda gue ni hehʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Damin 'yomfɛ̨nihʉ ts'ʉ 'bɛ'a i øt' yʉ ca. Nu'ʉ, hingui øt' yʉ́ huąhi nɛ hin te i pɛ'ts'i 'bɛ'a i honi, pɛ nu Oją di jamansu'ʉ. Pɛ man'da di jamansu ahʉ Oją xinda gue yʉ doja, nguetho man'da di mu ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nte sä gui tįnsɛhʉ, xinga gue nin sihmɛhʉ, xinga gue ni hehʉ, xinga gue ni tehʉ, gue gam 'bʉhmbʉ ua nya'a thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Janangue'a hin gui hyądumbʉihʉ ʉ nte di muui. ");
INSERT INTO otmNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Dami nuhʉ yʉ døni. Hin te má 'bɛfi i øt'e, pɛ guehma i te. Nɛ nu'a ra ts'ʉt'abi Salomón mi he rá pahni mahotho nɛ xʉm hmadi. Pɛ nu yʉ døni man'da mahotho xinda gue rá pahni mi he ra Salomón. ");
INSERT INTO otmNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nu'a Oją di jamansu yʉ døni nɛ di japi din te, madague n'da pa thoho i døni. Xi ahʉ, ha hin guím bɛ̨mhbʉ ngue man'da xʉn ho di 'da ahʉ Oją. Xøgue ts'ʉtho guí ɛ̨c'yɛihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Janangue o guí hądumbʉihʉ 'bɛ'a gui sihʉ n'da pa ngu n'da pa, ");
INSERT INTO otmNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","nguetho nu'ʉ hingui ɛ̨c'yɛi Oją, gue'a i øt'ʉ. Pɛ nu'ahʉ ni Tahʉ 'bʉpʉ mahɛ̨ts'i i pądi 'bɛ'a gätho guí homhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","M'bɛt'o thoho guin unsɛhʉ di manda ahʉ rá ts'ɛdi Oją, nɛ nubʉya di 'da ahʉ Oją 'bɛ'a gätho guí homhbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Xø bi 'yɛ̨n'a ra Jesús: ―O guín suhʉ, madague'a hingui ngu ahʉ, nguetho i hu rá mbʉi Oją ngue ya guí 'bʉhmbʉ bʉ di manda rá ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dami pähʉ 'bɛ'a i ja ahʉ, gui unhdʉ yʉ hyoya, nɛ din ja ahʉ xʉn ngu bʉ mahɛ̨ts'i. Nubʉ, nte dim 'bɛpʉ nɛ njąm'bʉ din thegue, hingui sä n'da ra bɛ̨ da yʉrpʉ, xinga gue'ʉ yʉ zu'uɛ̨. ");
INSERT INTO otmNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nu'bʉ guecua ja ra ximhäi i ja 'bɛ'a pɛ'ts'a n'da, hønt'ua im bɛ̨n'a n'da, nɛ nu'bʉ guepʉ mahɛ̨ts'i, guepʉ im bɛ̨n'a n'da bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Dami tøgbahʉ nɛ gan sähʉ tengu'bʉ i sø ni sibihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tengu i øt' yʉ 'yɛ̨hɛ 'bʉ i tøm'bʉ yʉ́ hmu da mbeng bʉ xín sihmɛ bʉ ja ran thąti, n'dahma 'bex da xocpa n'dihi 'bʉ bi zofo. ");
INSERT INTO otmNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ɛ̨mmɛ din johya ʉ bi dø'mi, nguetho da xi'ʉ da hyupʉ ja rá mɛxa, go guesɛ'a ra hmu din 'yɛ̨hɛ bʉya, ngue da 'uįn'ʉ yʉ́ 'yɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Din johya ʉ bi dø'mi madague'a made nxui uague t'ʉxuditho 'bʉ bi zøh ra hmu. ");
INSERT INTO otmNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nu n'da ran 'yohʉ 'bʉ xtám bądi 'bɛ'a ní pa da yʉrpʉ ra bɛ̨ bʉ ja rá ngu, xtán dø'mi, hin di japi da fɛ̨pi 'bɛ'a pɛ'ts'i. Pɛ hingui pądi 'bɛ'a ní pa da yʉrpʉ ra bɛ̨, janangue i tø'mi gätho yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ngutho ahʉ gui tøgbahʉ nguetho hin guí pąhmbʉ 'bɛ'a ní ora ba pengä, nugä ngue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nu'a ra Pedro bʉya, bi 'yänni 'bɛ'a bi man ra Jesús, bi 'yɛ̨mbi: ―Ma Hmu i, ha høngdähe guí xije ran t'uti, uague gätho ʉ mi'da guí xifi. ");
INSERT INTO otmNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nu ra Jesús bi dąti: ―Nu'a ra 'yɛ̨hɛ xʉn ho, nząi i øt' rá 'bɛfi xʉn ho, nɛ di manda bʉ ja rá ngu rá hmu, nɛ di darpa yʉ́ mi'yɛ̨hɛhʉ. Nɛ nu'bʉ bi zøn ra ora din sihmɛ ts'ʉ yʉ́ mi'yɛ̨hɛhʉ, i 'uįni xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nɛ nu'a ra 'yɛ̨hɛ, da dįn'a rá hmu bʉ dim pɛh 'bʉ bi zøhø, da nu ran johya a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nguetho majuąni dí xi ahʉ, nu rá hmu di un man'da ra 'bɛfi ngue di manda bʉya 'bɛ'a gätho i pɛ'ts'i. ");
INSERT INTO otmNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pɛ nu'bʉ n'da ra 'yɛ̨hɛ im bɛ̨nsɛ him ba ɛ̨'a n'dihi rá hmu, nɛ di dʉ'mi di ʉnba yʉ́ mí'yɛ̨hɛhʉ, madague yʉ xisu o gue yʉn 'yohʉ, nɛ i sihmɛzɛhɛ nɛ i mihni, ");
INSERT INTO otmNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ts'ʉrpʉ thoho ba ɛ̨h rá hmu nɛ bi dįn'a rá 'yɛ̨hɛ bʉ hin di jamansu rá 'bɛfi, nɛ da zʉ'a rá 'yɛ̨hɛ bʉya. Nɛ da hyøn'a thi, nɛ da 'yɛ̨mbi nte rán jaui a. Nɛ da mbɛnpʉ ba nu ran ʉnbi bʉ 'bʉh mi'da guexta'a him bi 'yøt'a xí sifi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nɛ man'da ran t'uti bi xi'ʉ, nɛ bi 'yɛ̨mp'ʉ: ―Nu n'da ra 'yɛ̨hɛ 'bʉ mi bądi 'bɛ'a in nde rá hmu, nɛ him bi 'yøt'e, pɛ xʉn ʉ tho ram fɛi din jap'a. ");
INSERT INTO otmNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pɛ nu'a n'da ra 'yɛ̨hɛ 'bʉ hingui pądi 'bɛ'a in nde rá hmu, nɛ him bi 'yøt'a i numanho rá hmu, pɛ ts'ʉtho ram fɛi din jap'a. Nu'a to'o bin japi da bądi xʉn ngu, jatho da 'yøt'e xʉn ngu. I jatho da 'yøt'e n'da ngu n'da hangu na ngu bin japi da bądi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Nugä bá ɛ̨cä, pɛ hinga gätho yʉ ją'i da numanhogui, janangue din sʉ'ʉ 'da. Pɛ guexta'a hinga nan ja xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","M'bɛt'o ga nu xʉn ngu yʉn ʉnbi, nɛ nu'bʉ bi zøn ra pa din ja'a dím ma, n'da ran ʉnbi xʉn ʉtho ga nugä bʉya. Nɛ xʉn ho 'bʉ ga nu n'dihi. ");
INSERT INTO otmNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pɛ o guí ɛ̨mhbʉ din hɛ̨ yʉ sʉi ngue bá ɛ̨cä ua, pɛ man'da din ja yʉ sʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nuya din hec yʉ́n 'yomfɛ̨ni ʉ 'bʉpʉ ja n'da ra ngu. Tengu'bʉ hyu'ʉ 'bʉpʉ da dɛngui, yoho ʉ hin da dɛngui. ");
INSERT INTO otmNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nɛ din hec yʉ́n 'yomfɛ̨ni yʉn 'yohʉ nɛ din sʉhmbʉ yʉ́ ts'ʉnt'ʉ nanguecä. Nɛ yʉ xisu din sʉhmbʉ yʉ́ t'įxu nɛ din sʉhmbʉ yʉ́ ts'įhuɛ, hinga 'da'angu da bɛ̨mhbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Nu'bʉ guí nuhʉ n'da ra güi ní bøxpʉ ní yʉh ra hyadi, guí ɛ̨mhbʉ din 'ye, nɛ din 'ye bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nɛ nu'bʉ guí nuhʉ ba ɛ̨h ran dąhi bʉ sur, guí ɛ̨mhbʉ xtám pa ra pa bʉya, nɛ xtám pa bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Maxøts'e tho guím mamhbʉ, guí pąhmbʉ 'bɛ'a din ja ra pa, pɛ nɛ hin guí pąhmbʉ 'bɛ'a ní hmɛpya guí nuhʉ ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","―Hanja ngue hingui sä gan 'yomfɛ̨ni 'bɛ'a xʉn ho gui 'yøthʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu'bʉ 'bʉ'a n'da da zix ahʉ bʉ 'bʉh ra zɛ'mi in nde di yąp'ahʉ, nu'bʉ gá mbɛ bʉ 'yu, gan hocuazɛhɛhʉ bʉ 'yu. Nu'bʉ hin'na, guehma gui sømmi bʉ 'bʉh ra zɛ'mi, nɛ di manda da jo ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nɛ hin da zä gui pømhbʉ bʉ asta gue'bʉ go gá juthʉ gätho bi zänni gui juthʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nɛ bi si'a ra Jesús 'bɛ'a xí t'ørpa 'da yʉ mɛngu bʉ Galilea nɛ bi t'ɛ̨mbi: ―Nu'a ra Pilato bi manda dí ho'ʉ 'da nu'bʉ mim bøx yʉ́ 'bøts'e bʉ ja ra dąniją Njerusalén, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Ha guím bɛ̨mhbʉ man'da i ja yʉ́ ts'oqui ʉ to'o bi mba ntho xinda gue'ʉ mi'da yʉ́ mɛnguhʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pɛ hin'na maha. Pɛ dí xi ahʉ, ngubʉ dín ʉn'nahʉ. Gui nuhʉ ran ts'ɛmbi maząi 'bʉ hin gui päh nin 'yomfɛ̨nihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nɛ'ʉ 'dɛ'ma hyąto bi du bʉ Siloé 'bʉ mi yøt' ra jądo, ha guí ɛ̨mhbʉ man'da mi ja yʉ́ ts'oqui ʉ xinda gue'ʉ mi'da 'bʉpʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hin'na maha, nɛ ngutho ahʉ guin nuhʉ ran ʉnbi 'bʉ hin gui päh nin 'yomfɛ̨nihʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nɛ nubʉya, bi xi'a n'da ran t'uti, bi 'yɛ̨na: ―Mi 'bʉ'a n'da ran 'yohʉ mi ja n'da rá huąhi. Nɛ bi 'yɛ̨t'a n'danza ra higo. Nɛ mi pa ran 'yohʉ da nu 'bʉ di zʉpʉ yʉ́n dät'o, pɛ xínga n'dandį bin zʉh yʉ́n dät'o ra higo. ");
INSERT INTO otmNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Janangue bi zon'na rá mbɛfi bʉ ja rá huąhi nɛ bi xifi da 'yɛxa ra za: “Nuya, ná hyu jɛya ya ngue dí tø'mi din ja yʉ́n dät'o na ra za, pɛ hin te i zʉdi. Dami 'yɛx ya, ndetho í sʉnba yʉ́ dehe ra häi a ra za,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pɛ nu'a rá mbɛfi bi 'yɛ̨na: “Dím 'bäpʉ man'da jɛya, ga zʉnspa ra häi bʉ rán dʉi, nɛ ga ponbä xʉn ho yʉ häi. ");
INSERT INTO otmNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xøhma din zʉh yʉ́n dät'o bʉya. Pɛ nu'bʉ hin din zʉdi, ga ɛxä 'bʉ,” bi 'yɛ̨n'a ra mbɛfi bʉya, bi 'yɛ̨n'a ra Jesús 'bʉ mi man'a ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","N'da ra pa ran säya bʉya, min xänbate bʉ ja ra niją ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nɛ mi 'bäpʉ n'da ra xisu ngue ná 'dɛ'ma hyąto jɛya madí ʉnba ra zįthu, him madi japi di juąn rá ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nɛ nu'bʉ mi nu'a ra Jesús, bi 'yɛ̨mbi: ―Grá xisu, ya bi zä ni ją'i ya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nɛ bi mba nthädi ra xisu bʉya, bi dä'a ra Jesús, 'bex bi juąn rá ją'i a bʉya. Nɛ nu'a ra xisu bi 'yɛ̨spa Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pɛ nu'a ra ngʉrpi bʉ ja ra niją ɛ̨mmɛ bin cuɛ nguetho bi nu ra Jesús bi hoc'a n'da ra ją'i ra pa ran säya. Nɛ bi 'yɛ̨mp'ʉ mi 'bʉpʉ: ―Nts'änni 'dato pa gam pɛhmbʉ n'da semana, nɛ gue'ʉ yʉ pa gua ɛ̨hmbʉ ngue din hoc'ahʉ ua, pɛ hinga gue ra pa ran säya gua ɛ̨hmbʉ da mba ma hoc'ihʉ ua, bi 'yɛ̨n'a ra ngʉrpi bʉ ja ra niją. ");
INSERT INTO otmNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nu ra Jesús bi 'yɛ̨na: ―Xi ahʉ, ha hin guí xojʉ nin dąnihʉ nɛ guí sixhʉ bʉ ja ra dehe madague ra pa ran säya. ");
INSERT INTO otmNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nɛ mi 'bäcua n'da ra xisu rám bom'bɛto ra Abraham, ná 'dɛ'mahyąto njɛya madi ʉnba ra zįthu tengu'bʉ án thu't'i, nɛ guí ɛ̨mhbʉ hingui ho ngue dá xocpä a nangue rá ts'ɛdi ra zįthu, nguetho ra pa ran säya ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bin hɛ̨tho ʉ yʉ́n sʉihʉ ra Jesús bʉya, nɛ bi mbɛs' yʉ́ sä. Pɛ nu'ʉ yʉ ją'i bin johya 'bʉ mi nu yʉn t'øt'e nuįxte bi 'yøt'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nɛ xø bi 'yɛ̨n'a: ―'Bɛ'a ní hmɛpya sä ga xi ahʉ ngue ga ut'ahʉ 'bɛpʉ ní manda rá ts'ɛdi Oją ua. ");
INSERT INTO otmNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nu'a, tengu rá hmudä ra mostaza. Zʉ ts'ʉ 'bʉ xʉ 'boni, pɛ nu'bʉ xʉm bøts'e, i te tengu n'da ra za, nɛ yʉ doja i øt' yʉ́ 'bafi bʉ ja yʉ́ 'yɛ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nɛ xø bi 'yɛ̨na: ―'Bɛ'a man'da ra hmɛpya sä ga xi ahʉ ngue ga ut'ahʉ 'bɛpʉ ní manda rá ts'ɛdi Oją ua. ");
INSERT INTO otmNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nu'a, tengu ra íxi 'bʉ din jap'a ra jʉni, nɛ gätho bi nden'a ra jʉni bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nu ra Jesús i 'yo ra 'yu ní mba bʉ Jerusalén, nɛ bi xänba yʉ ją'i bʉ ja yʉ hnini bi thogui. ");
INSERT INTO otmNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nɛ nu'ʉ 'da yʉ ją'i bi 'yänni: ―Ha hin ɛ ngu'ʉ yʉ ją'i dim pøhø, gue da mba nhyąni, ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nu'a ra Jesús bi dąti: ―Nu'a ní yʉt'a n'da bʉ mahɛ̨ts'i, tengu n'da ra goxthi xʉn ts'įt'i. Dami hyomhbʉ gui cʉthʉ bʉ, nguetho dí xi ahʉ, da zøn ra ora xʉn ngu da nde da yʉrpʉ, pɛ ya him man zä. ");
INSERT INTO otmNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nguetho da zøn ra ora da gut ra goxthi ra Hmu, nɛ dim 'bäpʉ thi ʉ 'da da zo'a, da 'yɛ̨mbi: “Ma Hmu i, dami xogahe.” Pɛ nu'a ra Hmu da 'yɛ̨mda'ʉ: “Hin dí pą ahʉ,” da 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nɛ nu'ʉ da 'yɛ̨n'ʉ: “Pɛ dán sihmɛhʉ, nɛ gá xängahe bʉ ja ma hninihe,” da 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pɛ nu'a ra Hmu da 'yɛ̨na: “Pɛ dí xi ahʉ, hin dí pą ahʉ, ní mbähä bʉ, hin da zä gui cʉthʉ ua, gyʉ́ ts'om'bäihʉ,” da 'yɛ̨mthoho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nɛ ɛ̨mmɛ da bɛ̨ndumbʉi ʉ 'bʉ dim 'bäpʉ thi bʉ di manda rá ts'ɛdi Oją. Nɛ din zom bʉ di cuxt' pʉ yʉ́ ts'i ʉ nangue ran ʉnbi da nu bʉ. Nɛ da hyant'a ra Abraham 'bʉpʉ mbo, nɛ ra Isaac, nɛ ra Jacob, nɛ gätho mi'da yʉ́ pøngahyą Oją, ");
INSERT INTO otmNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","nɛ da hnu ʉ xʉn ngu mi'da yʉ ją'i ngue bi nɛxpʉ gä na ngʉni ra ximhäi i hupʉ di manda rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nɛ dí xi ahʉ, to'o ɛ̨na i 'bɛt'o ua, dim 'bɛjua bʉ ʉ, nɛ nu'ʉ t'ɛ̨mbi i 'bɛjua ua, dim 'bɛt'o bʉ ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nu'bʉ mi man'a ra Jesús, bi zø'i 'da yʉ fariseo nɛ bi 'yɛ̨n'ʉ: ―Nde'bʉ gui pøn'a n'dihi ua di manda rá ts'ɛdi ra Herodes, nɛ in nde da hyo'a i. ");
INSERT INTO otmNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bi dą'a ra Jesús: ―Nu ra Herodes ra hyäte a. Ní mbähä gui xihmbʉ ngue nuya nɛ nixudi ga thoqui ga øt' ma 'bɛfi, ga høn'a thi yʉ zįthu, nɛ ga hoc yʉ hyɛ̨nni bʉ ga thogui. Nimani bʉya ga juacä ma 'bɛfi, gui 'yɛ̨mfʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nuya, nɛ nixudi, nɛ nimani dan 'yogä, i jatho ga søm bʉ Jerusalén, nguetho guepʉ i tho bʉ yʉ́ pøngahyą Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nɛ ɛ̨mmɛ bi du rá mbʉi ra Jesús nangue'ʉ i 'bʉpʉ Jerusalén, nɛ bi 'yɛ̨na: ―Nu ahʉ gyʉ mɛnguhʉ Jerusalén, guí hohʉ yʉ́ pøngahyą Oją, nɛ gadí bat'adohʉ ʉ bí pɛn'nahʉ Oją. Hangu yʉ pa dá nde ga jamansu ahʉ tengutho n'da ra c'ʉ'øni i comp' yʉ́ bąsi 'bʉ xʉn de, pɛ nu ahʉ hin gá ndehʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nuya njon da mbäh ni hninihʉ nɛ hin din ja ahʉ rán jąpi Oją. Nɛ dí xi ahʉ, hin gui nujʉ mahøn'a jague'bʉ bá ɛ̨cä mahøn'a. Nɛ nu'bʉ gá nujʉ, gui 'yɛ̨njʉ: “Mająpi a bá ɛ̨hɛ nangue rá thuhu ra Hmu,” gui 'yɛ̨njʉ, bi 'yɛ̨n'a ra Jesús 'bʉ mi 'yɛ̨mp'ʉ yʉ mɛngu bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nu n'da ra pa ran säya, bi mba bán sihmɛ bʉ rá ngu n'da ra ngʉrpa fariseo a ra Jesús. Nɛ gätho i 'bʉpʉ ja ran sihmɛ ɛ̨mmɛ bi dø'mi da nu 'bɛ'a da 'yøt'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nguetho mi 'bʉpʉ n'da ran 'yohʉ xʉ nden rá ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nɛ nu'a ra Jesús bi 'yän'dʉ yʉ fariseo nɛ yʉ xänbate niją bʉya: ―Ha din thɛui yʉn t'ɛ̨di 'bʉ di hoc'a n'da ra hyɛ̨nni 'bʉ ra pa ran säya, ɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pɛ xínga n'da'ʉ bi dąt'a. Nu ra Jesús bʉya, bi hoc'a ran 'yohʉ nɛ bin 'yɛ̨hmi. ");
INSERT INTO otmNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nɛ nubʉya, bi 'yɛ̨mp'ʉ yʉ fariseo nɛ yʉ xänbate niją: ―Xi'bʉ n'da ahʉ, 'bʉ xtan däh nin dąnihʉ ogue ni buruhʉ bʉ ja ra hyąhäi a ra pa ran säya, ha hin guí jʉxhʉ madague ra pa ran säya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pɛ xínga n'da bi zä bi dądi. ");
INSERT INTO otmNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nu ra Jesús bʉya, bi nu'ʉ 'da i hon yʉ́n thuts'i, in nde 'darpʉ da hyuhmbʉ ʉ i pa nt'ɛ̨spi bʉ ja ran sihmɛ, nɛ bi 'yɛna: ");
INSERT INTO otmNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","―O guí homhbʉ ngue 'darpʉ gui hyuhmbʉ ʉ ja yʉ́ ts'ɛdi, nguetho nu'bʉ 'darpʉ guí huhmbʉ ʉ, xi'bʉ da zøm bʉ n'da ngue man'da da t'ɛ̨spi, nɛ da xi ahʉ ra mɛngu bʉ, “Gui ndanjʉ nguetho rán säui da hyupʉ na,” da 'yɛ̨n'ahʉ. “Bá huhnʉ,” da 'yɛ̨n'ahʉ, nɛ ɛ̨mmɛ gui pɛs' ni sähʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Man'da xʉn ho gui hyuxhʉ bʉ ma'ueni ts'ʉ 'bʉ gá cʉthʉ bʉ ja ran sihmɛ, nɛ nu'bʉ bi nu ahʉ ra mɛngu bʉ, da xi ahʉ: “Amigo ahʉ, ba ɛ̨hmbʉ ua, gui hyuxhʉ ua man'da xʉn ho,” da 'yɛ̨n'ahʉ. Nɛ gätho'ʉ 'bʉpʉ da numanho ahʉ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nguetho gätho'ʉ din 'yɛ̨zɛhɛ, da zøn ra pa da go'ahäi. Pɛ gätho to'o hin din 'yɛ̨zɛhɛ, da zøn ra pa da t'ɛ̨spi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nɛ xø bi 'yɛ̨n'a ra Jesús, bi 'yɛ̨mp'a ra mɛngu bʉ: ―Nu'bʉ gui 'yøt'a n'da ran sihmɛ, o guí zon'dʉ ni amigo, xínga gue'ʉ ni cu, xínga gue'ʉ ni mɛni, xínga gue'ʉ yʉ mɛmbɛti guin tøt'am'bʉihʉ, nu'ʉ, m'bɛjua da zix'i i gan sihmɛ, tengu gá 'yørpe. ");
INSERT INTO otmNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pɛ nu'bʉ gui 'yøt'a n'da ran sihmɛ, dami zon'dʉ yʉ hyoya, nɛ yʉ mbɛdi, nɛ yʉ dogua, nɛ yʉ xädä, ");
INSERT INTO otmNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nɛ di jąp'ahʉ Oją bʉya. Nguetho nu'ʉ, hin da zä di co'ts'a'i 'bɛ'a gá 'yørpa ʉ. Pɛ Oją di co'ts'a 'bʉ bi zøn ra pa da xox'ʉ yʉ́ 'yɛ̨c'yɛi xʉn du, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","N'da ran 'yohʉ mi sihmɛhʉ bʉ, 'bʉ mi 'yø'a bi man ra Jesús, bi 'yɛ̨na: ―Mająpi gätho to'o din sihmɛ bʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨n'a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nɛ nu'a ra Jesús bi xi'a n'da ran t'uti nangue'ʉ to'o njuąntho din sihmɛ bʉ di manda rá ts'ɛdi Oją, nɛ bi 'yɛ̨mp'ʉ: ―Mi 'bʉ'a n'da ran 'yohʉ bi 'yøt'a n'da ra dąnsihmɛ, nɛ ɛ̨mmɛ xʉn ngu ʉ bi xifi din sihmɛ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nɛ nu'bʉ mi gua'a bi hoc ran sihmɛ, bi mbɛn'na rá 'yɛ̨hɛ da xi'ʉ 'bex ba ɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pɛ gätho ʉ bi ma hingui sä da mba. Nu n'da ran 'yohʉ bi 'yɛ̨na: “Nugä ja dá tängä n'da ma huąhi, jatho ga mba ba nugä. Dami pungagui, hingui sä ga mba,” bi 'yɛ̨n'a n'da. ");
INSERT INTO otmNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nɛ nu'a man'da ran 'yohʉ xø bi 'yɛ̨na: “Nugä ja dá tängä cʉt'a pare yʉ mbʉndąni, jatho ga säpi ga pɛpi, dami pungagui, hingui sä ga mba,” bi 'yɛ̨n'a man'da. ");
INSERT INTO otmNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nɛ xø man'da bʉya bi 'yɛ̨na: “Ja dá singä n'da ma xisu nɛ hingui sä ga mba bʉ,” bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nu'a ra 'yɛ̨hɛ bʉya, bi mbengbʉ ja rá ngu'a rá hmu, nɛ bi xifi 'bɛ'a gätho bi man'ʉ yʉn 'yohʉ. 'Bex bin cuɛ'a rá hmu bʉya, nɛ xø bi mbɛnh mahøn'a ngue da mba n'dihi bʉ ja yʉ́ 'yu ra hnini, nɛ ba si'ʉ yʉ hyoya, yʉ mbɛdi, nɛ yʉ xädä, nɛ yʉ dogua da dįm bʉ, ba ɛ̨hɛ din sihmɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nubʉya, nu ra 'yɛ̨hɛ bi 'yɛ̨mp'a rá hmu: “'Bʉcua ya bá sigä ya, pɛ him bi yuh ni ngu.” ");
INSERT INTO otmNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nu rá hmu bʉya, bi 'yɛ̨mbi: “Ní mba bʉ ma'ueni ts'ʉ ra hnini, nɛ dami 'yørpa ts'ɛdi ba ɛ̨'ʉ hønt'a go to'o gui tįm bʉ 'yu, da yuh ma ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pɛ xínga n'da ran 'yohʉ rá mbʉdi dá zohndä da zi na man sihmɛgä,” bi 'yɛ̨n'a rá hmu, bi 'yɛ̨n'a ra Jesús 'bʉ mi man na ran t'uti. Bi ma nangue'ʉ t'ɛ̨mbi hin yʉ́n sähʉ, pɛ man'da go da yʉrpʉ di manda rá ts'ɛdi Oją ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nɛ xʉn ngu yʉ ją'i mi tɛn bʉ 'yu ra Jesús. Nu ra Jesús bʉya, bi nyɛ̨gui nɛ bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―To'o gätho in nde da dɛngui, jatho man'da xʉn ngu da bɛ̨ngä xinda guepʉ nam bɛ̨n'a rá ta o gue rá mbe, ogue rá xisu, ogue yʉ́ t'ʉhni, o gue yʉ́ cu. Jatho man'da da bɛ̨ngä xinda guepʉ nín huɛ̨czɛhɛ. Nu'bʉ hin'na, hin da zä da dɛngui. ");
INSERT INTO otmNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nɛ to'o gätho hin da hyät yʉn ʉnbi, ngue i su da tho 'bʉ da dɛngui, hin da zä da dɛngä ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nɛ 'bɛ gan 'yomfɛ̨nihʉ ts'ʉ 'bʉ gui hyäthʉ gui tɛngahʉ, tenguthoho n'da ran 'yohʉ 'bʉ da 'yɛ̨na da hyøh rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","M'bɛt'o din 'yomfɛ̨ni 'bɛ'a da 'yøt'e, nu'bʉ hin'na, ts'ʉrpʉ thoho hinga xøt'a dí jua'a rá ngu. Nu yʉ ją'i bʉya da denthoho, ");
INSERT INTO otmNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nɛ da 'yɛ̨n'ʉ: “Nuna ran 'yohʉ bi dʉ'ma rá ngu, pɛ hinga xøt'a bi juadi,” da 'yɛ̨n'ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nɛ ngutho n'da ra ts'ʉt'abi 'bʉ i 'bʉ'i 'dɛt'a mahuąhi yʉ́ dofʉi, pɛ m'bɛt'o din 'yomfɛ̨ni 'bʉ da zä din tunhui a man'da ra ts'ʉt'abi 'bʉ'i 'däte mahuąhi yʉ́ dofʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nɛ nu'bʉ im bɛ̨ni hingui sä da dąpi, pɛ da mbɛhna n'da rám 'bɛhni da 'yän 'bʉ da zä din hocpadahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nɛ ngutho ahʉ, pɛ jatho 'bɛ gan 'yomfɛ̨nihʉ 'bʉ da zä gui 'yɛ'ts' ni pähä zɛhɛhʉ, nɛ him man guim bɛ̨mhbʉ 'bɛ'a i ja ahʉ, janangue da zä gui tɛngahʉ bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nu ra ų mahyoni a, pɛ nu'bʉ di 'bɛh rán ho, hin'yʉ 'bɛ'a din hogui. ");
INSERT INTO otmNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nɛ nte da mbɛfi, xínga gue ra häi sä di hoqui, nɛ da mba ma bʉnt'i thoho. Guín jahʉ bʉ 'bʉ hin'yʉ nin hohʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","N'da ra pa, xʉn ngu yʉ hyącahäi nɛ mi'da yʉ ts'om'bäi bim pɛti bʉ, da 'yøde 'bɛ'a i man'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Janangue'a nu'ʉ yʉ fariseo nɛ yʉ xänbate niją bi c'ąman'ʉ ra Jesús, nɛ bi 'yɛ̨n'ʉ: ―Hingui ho øt'na ran 'yohʉ, nguetho i yąhʉ nɛ i sihmɛhʉ yʉ ts'om'bäi, sä bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nɛ nu'a ra Jesús bi xi'a n'da ran t'uti, nɛ bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Xi'bʉ n'da ran 'yohʉ i 'bʉ'a n'da ciɛnto yʉ́ dɛ'yo, nɛ xtim 'bɛ'a n'da, nɛ hønt'ʉ goho 'däte ma'dɛ'ma gʉto di 'bʉpʉ, 'bɛ'a da 'yøt'a. Ha hin da zopʉ goho 'däte ma'dɛ'ma gʉto, ngue da mba ba hon'a bim 'bɛdi gue'bʉ go bi dįni. ");
INSERT INTO otmNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nɛ nu'bʉ bi dįni, da gäx rá xįxi, din johya bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Da duxpʉ ja rá ngu, da zon'dʉ yʉ́ amigo, nɛ'ʉ din tøt'am'bʉihʉ, nɛ da 'yɛ̨mp'ʉ: “Dan johyahʉ ya, nguetho dá tįngä na ma dɛ'yo bim 'bɛdi,” da 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngutho bʉ mahɛ̨ts'i, ɛ̨mmɛ di johya ʉ bí 'bʉpʉ 'bʉ bi päh rán 'yomfɛ̨ni n'da ra dądits'oqui ua ja ra ximhäi. Man'da di johya nangue'a, xinda gue'ʉ mbɛ̨ni hingui dim 'bɛdi, ngue ɛ̨na hin'yʉ yʉ́ ts'oqui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nɛ man'da ran t'uti bi man ra Jesús, bi 'yɛ̨na: ―Nɛ ximangutho n'da ra xisu mi ja 'dɛt'a yʉ́ mbɛti nɛ bi 'bɛ a n'da, pɛ 'bɛ'a hmaha da 'yøt' ra xisu bʉya. Ha hin di søc rá sibi nɛ da goc rá ngu, da hyoni gue'bʉ go bi dįni. ");
INSERT INTO otmNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nɛ nu'bʉ bi dįm bʉya, da zon'dʉ yʉ́ amigo nɛ'ʉ din tøt'am'bʉihʉ, nɛ da 'yɛ̨mbi: “Dan johyahʉ nguetho dá tįngä ma mbɛti dá 'bɛcä,” da 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngutho ʉ yʉ́m 'bɛhni Oją bí 'bʉpʉ mahɛ̨ts'i, ɛ̨mmɛ di johya 'bʉ bi päh rá mbʉi n'da ra ją'i ua, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ra Jesús bi ma man'da ran t'uti 'bɛpʉ ní huɛ̨gahʉ Oją nɛ bi 'yɛ̨na: ―Mi 'bʉ'a n'da ran 'yohʉ yoho yʉ́ ts'ʉnt'ʉ mi 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nu'a ná yoho rá ts'ʉnt'ʉ bi 'yɛ̨mp'a rá ta: “Dami 'dac ya 'bɛ'a guím bɛ̨ni gui soga 'bʉ gá tu,” bi 'yɛ̨mbi. Janangue nu'a ran 'yohʉ bʉya, bi unni 'bɛ'a gätho in ndepe da gohmi'ʉ yʉ́ ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mi tho'i ts'ʉ yʉ pa bʉya, bi hyąxa bin t'un'na to'o xí 'yäh ra erencia, nɛ bi mba. Bi mba n'danni ra häi, yatho, nɛ 'bexque 'dahmantho bi jua'a bi hyąts'i, nguetho bi 'yøt'e 'bɛ'a bi numanhosɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Gätho bi juadi, xíngui ts'ʉ nte bi 'yɛgui. Nɛ guepʉ ra häi xí zøni bin ja n'da ra dąthu, nɛ xíngui ts'ʉ 'bɛ'a da zi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pɛ nubʉya bi hyon ra 'bɛfi ra ts'ʉnt'ʉ. Nɛ nu n'da ran 'yohʉ, ra mɛngu bʉ, bi xifi di jamansup yʉ́ ts'ʉdi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pɛ njon bi 'uįn'a ra ts'ʉnt'ʉ nɛ in nde da zi'a mi si yʉ ts'ʉdi, nguetho ɛ̨mmɛ tumanthuhu. ");
INSERT INTO otmNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nɛ nu'bʉ mi thoh yʉ pa, bin 'yomfɛ̨ni bʉya, bi bɛ̨ni: “Nubʉ ja rá ngu ma ta, mbongui thoho 'bɛ'a da zi yʉ́ 'yɛ̨hɛ, nɛ nugä dí sägä ran ʉnbi ngue hin'yʉ ga sigä ua. ");
INSERT INTO otmNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pɛ man'da xʉn ho 'bʉ ga pengä nɛ ga xi'a ma ta: “Nu'i ma ta'i, nugä dá øt'ä ram fɛ'ts'i nangue'e nɛ nangue Oją, ");
INSERT INTO otmNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","nɛ him man sä'be gui 'yɛ̨ngui ni ts'ʉnt'ʉgä ya. Gui 'yɛ̨ngui ni 'yɛ̨hɛthohogä ya, ga ɛ̨mbi,” bi 'yɛ̨nsɛ a ra ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","'Bex bi mba bʉya bi hyąx ra 'yu í mba bʉ 'bʉh rá ta. Pɛ nu'bʉ mi ts'ʉtho da zøn rá ngu, 'bex bi hyant'a rá ta ngue ba ɛ̨pʉ, nɛ ɛ̨mmɛ bin johya, bi huɛ̨c'a rá ts'ʉnt'ʉ. Bin ti'a rá ta, bin c'at'ui bʉ 'yu, bi hyʉfi nɛ bi zʉspa rá 'yogu. ");
INSERT INTO otmNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pɛ nu'a ra ts'ʉnt'ʉ bi xi'a rá ta: “Nugä, dá øt'ä ram fɛ'ts'i nangue'e nɛ nangue Oją. Nɛ him man sä'be gui 'yɛ̨ngui ni ts'ʉnt'ʉgä ya,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pɛ nu'a rá ta, bi xih yʉ́ 'yɛ̨hɛ: “Dami hethʉ ra pahni man'da xʉn ho, nɛ dami cärpahʉ n'da ram fo'yɛ rá xä, nɛ gui 'yʉrpahʉ yʉ́ zapato. ");
INSERT INTO otmNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nɛ ba sihʉ ra t'ʉndąni xʉn zaqui nɛ gui hyohʉ, gui hojʉ ran sihmɛ nɛ dan johyahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nguetho nuna ma ts'ʉnt'ʉ tengu'bʉ bi du, pɛ nuya, tengu'bʉ bim 'bʉi mahøn'a. Bim 'bɛdi pɛ nuya dá tįn ya,” bi 'yɛ̨n'a rá ta. Nɛ 'bex bin ja ran sihmɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pɛ nu'a ra 'bɛt'o ts'ʉnt'ʉ mi 'yo bʉ huąhi, nɛ nu'bʉ mi mba bʉ ja rá ngu, i øh ra 'bida nɛ ran johya mi ja bʉ ja rá ngu rá ta. ");
INSERT INTO otmNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nɛ nu'a, bi zohn'na n'da rá 'yɛ̨hɛ bi 'yänni: “'Bɛ'a i ja bʉ ja rá ngu ma ta,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nɛ nu ra 'yɛ̨hɛ bi 'yɛ̨mbi: “Nu'a nin 'yohʉ bi zøhø, nɛ ni ta bi hyo ran dąni xʉn zaqui, bi 'yøt'a n'da ran sihmɛ xʉn ndoho. Nguetho bin johya ngue ya bá penc'a nin 'yohʉ,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pɛ nu'a rá mbʉdi ts'ʉnt'ʉ bin cuɛ nɛ him bi nde bi yʉrpʉ mbo ra ngu. Nɛ nu'a rá ta bi bøni, bi 'yørpa ts'ɛdi da yʉrpʉ mbo. ");
INSERT INTO otmNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pɛ nu rá ts'ʉnt'ʉ bi 'yɛ̨mp'a: “Ɛ̨mmɛ xʉn ngu yʉ jɛya dá øt'ä ni 'bɛfi nɛ xínga n'dandį dá fɛsthoho a gá xiqui. Nɛ hin jąm'bʉ xcá 'dac'a n'da ra t'ʉchibo ngue dan sihmɛhe ma amigo. ");
INSERT INTO otmNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pɛ nu'bʉ go mi zø'a ni ts'ʉnt'ʉ bi juat'a ni mbɛti nɛ xʉn ts'o bi 'yøt'e, 'bex gá hyo ra t'ʉndąni xʉn zaqui,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pɛ nu'a rá ta bi 'yɛ̨mbi: “Pɛ ma zʉ ts'ʉnt'ʉ i, thocua thoho dí 'bʉhmi ua, nɛ gätho 'bɛ'a i jagä, gätho ni mbɛti. ");
INSERT INTO otmNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pɛ xʉn ho 'bɛ'a dá øt'ä nguetho nu nin 'yohʉ tengu'bʉ ya xí du nɛ i 'bʉi mahøn'a, nu'a bim 'bɛdi pɛ ya dá tįmhbʉ,” bi 'yɛ̨n'a rá ta, bi 'yɛ̨n'a rá Jesús 'bʉ mi man ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nɛ xø bi ma man'da ran t'uti a ra Jesús, nɛ bi 'yɛ̨na: ―Mi 'bʉ'a n'da ra mɛmbɛti, nɛ mi si n'da rá ngʉrpa 'yɛ̨hɛ bi xifi di manda 'bɛ'a gätho i pɛ'ts'i. Pɛ bi si'a ra mɛmbɛti hingui ho øt' rá ngʉrpa 'yɛ̨hɛ nguetho i hączɛhɛ 'bɛ'a i ndesɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Janangue'a bi zon'na rá 'yɛ̨hɛ nɛ bi 'yɛ̨mbi: “Dá øcä hingui ho'a guí øt'e. Nuya, dami däqui hangu din thɛui ma 'bɛfi nguetho ya him man gam pɛcua,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nu'a ra 'yɛ̨hɛ bi bɛ̨m bʉya 'bɛ'a da 'yøt'e. Bi 'yɛ̨nsɛ: “Nuya him man zä dam pɛcua ya, nɛ hingui sä dam pɛh na huąhi, nɛ dí pɛ'ts' ma sä ga ätho ra mbɛti, 'bɛ'a hmaha ga øt'ya,” bi 'yɛ̨nsɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bi bɛ̨m bʉya 'bɛ'a da 'yøt'e n'dahma dim 'bʉh yʉ́ amigo di zɛ 'bʉ hin'yʉ rá 'bɛfi. ");
INSERT INTO otmNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nɛ nu ra ngʉrpa 'yɛ̨hɛ bi zon'dʉ to'o i tup'a rá hmu. Nɛ bi 'yän'na n'da hangu in dupate. ");
INSERT INTO otmNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nɛ bi dąti, bi 'yɛ̨na: “N'da ciɛnto dąmbot'ɛgui ra aceite dí tupi.” Nɛ nu'a ra 'yɛ̨hɛ bi 'yɛ̨mbi: “Dami ts'on ni søcuą nɛ gui 'yo't' ma'da'yo gui hyuxpʉ ngue hønt'a yote ma'dɛt'a yʉ dąmbot'ɛgui guí tupa ma hmu,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nɛ xø bi 'yän'na man'da ran 'yohʉ hangu xø in dupate a. Nu'a bi dąti: “N'da ciɛnto t'ɛni ra trigo dí tupi.” Nɛ nu'a ra 'yɛ̨hɛ bi 'yɛ̨mbi: “Dami päh ni søcuą, nɛ dami hyuxpʉ goho 'däte t'ɛni thoho guí tupi.” ");
INSERT INTO otmNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nɛ nu'bʉ mi pą'a rá hmu 'bɛ'a bi 'yøt' rá 'yɛ̨hɛ, bi 'yɛ̨mbi: “Ɛ̨mmɛ guí pądi 'bɛ'a sä gui 'yøt'e ngue din jasɛ 'bɛ'a gätho gui hyoni,” bi 'yɛ̨n'a rá hmu. Nu yʉ ją'i 'bʉh ya, ɛ̨mmɛ i pądi da hyät' yʉ́ miją'ihʉ n'dahma da dąsɛ. Pɛ nu'ʉ i 'yo bʉ ja ran nɛqui, hingui pądi da 'yøt'e tengu na, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nɛ dí xi ahʉ ngue nu ra mbɛti di ts'onba rán 'yomfɛ̨ni ʉ 'da, pɛ da zøn ra pa ngue hin te di muui a, pɛ nu ni mbɛtihʉ xʉn ho 'bʉ gui fäxhʉ yʉ ją'i, nɛ dim 'bʉh ni amigohʉ ngue 'darpʉ gním 'bʉhmbʉ bʉ mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","'Bʉ'i 'da zʉ ts'ʉtho i ja da 'yøt'e, pɛ i pądi di jamansu a, janangue'a mfądi da bądi di jamansu 'bʉ di ja xʉn ngu 'bɛ'a da 'yøt'e. Pɛ 'bʉi 'da zʉ ts'ʉtho i ja da 'yøt'e, nɛ hingui pądi di jamansu a, janangue mfądi ngue hin da bądi di jamansu 'bʉ di ja xʉn ngu 'bɛ'a da 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nu'bʉ hingui pądi di jamansu 'bɛ'a i ja ua ja ra ximhäi, nɛ xín da bądi di jamansu rá 'bɛfi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nɛ nu'bʉ hingui pądi di jamansu a hin rá mbɛti zɛhɛ, njon da zä di un'na njuąntho rá mbɛti 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Njo'o n'da ra ją'i sä dim 'bʉ'i yoho yʉ́ hmu, nguetho nu'a n'da ra hmu hin da numanho a, nɛ nu man'da di huɛ̨c'a. Uague da 'yørpa rá 'bɛfi a n'da nɛ da zocpada bʉ rá 'bɛfi a man'da rá hmu. Ngutho n'da ra ją'i hingui sä da 'yɛ̨mbi rá hmu a Oją 'bʉ ɛ̨mmɛ di ho ra mbɛti, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nu yʉ fariseo ɛ̨mmɛ di ho ra mbɛti ʉ, nɛ nu'bʉ mi 'yø'a bi man ra Jesús, bi denthoho. ");
INSERT INTO otmNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Nu ahʉ gyʉ́ fariseohʉ, guí øthʉ 'bɛ'a ní numansu ahʉ yʉ ją'i, pɛ nu Oją i pądi 'bɛ'a i ja bʉ mbo ni mbʉihʉ. Nɛ nu'ʉ gätho im bɛ̨nsɛ yʉ ją'i ngue di muui, pɛ hin te di muui bʉ na nu Oją ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","―Nu mam 'bɛt'o gán xähmbʉ yʉ́n t'ɛ̨di ra Moisés, nɛ gán xähmbʉ 'bɛ'a bi 'yo't' yʉ pøngahyą maya'bʉ, bi 'yɛ̨mp'ʉ. Pɛ nu ra Xuua Nxixyą bi dʉ'mi bi man ran ho ma'da'yo nɛ bi ma 'bɛpʉ ní manda rá ts'ɛdi Oją. Nɛ xʉn ngu yʉ ją'i ya i øt'ra ts'ɛdi da yʉrpʉ di manda rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pɛ madague'a, pɛ xínga n'dant'ohni dim 'bɛ'ʉ yʉn t'ɛ̨di. Nu ra ximhäi nɛ mahɛ̨ts'i da guadi, pɛ hin dim 'bɛ'ʉ yʉn t'ɛ̨di, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","―Nɛ nu'a to'o da hyɛh rá xisu nɛ da zim man'da, ra 'yomt'ɛ̨ni a. Nɛ nu'a to'o da zin'a ra xisu bi thɛgui, nɛ gue'a dín 'yomt'ɛ̨ni a bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nɛ bi ma man'da ran t'uti ra Jesús, bi 'yɛ̨na: ―Mi 'bʉ'a n'da ra mɛmbɛti nɛ mahotho rá pahni xʉm hmadi a mi he, nɛ ɛ̨mmɛ mi 'bʉmanho bʉ ja rá ngu, tengu thoho 'bʉ i ja ra ngo. ");
INSERT INTO otmNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nɛ i 'bʉ'a n'da ra hyoya, ɛ̨mmɛ mi sä ran ʉnbi, í Lázaro a. Nɛ gätho rá ją'i mi ja yʉ 'ya. Nɛ mi hupʉ ja rá goxthi ra mɛmbɛti, ");
INSERT INTO otmNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ngue mim bɛ̨ni da zi 'bɛ'a da hyɛpʉ ja rá mɛxa a ra mɛmbɛti. Nɛ nu'ʉ yʉ xą'yo bi decpa yʉ́ 'ya bʉ i hudi. ");
INSERT INTO otmNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bi zøn ra pa bi du'a ra hyoya. Nɛ nu yʉ́m 'bɛhni Oją bi zixpʉ mahɛ̨ts'i nguepʉ 'bʉ'a ra Abraham. Mbɛjua bʉya bi du'a ra mɛmbɛti. ");
INSERT INTO otmNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nɛ nu'bʉ mi du'a ra mɛmbɛti bʉya, ɛ̨mmɛ bi nu ran ʉnbi bʉ bi mba. Nɛ bi ndøts'e, bi nu yabʉ bí 'bʉ'a ra Abraham nɛ ra Lázaro 'darpʉ bí 'bʉhmi. ");
INSERT INTO otmNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nu ra mɛmbɛti bi mbafi, bi 'yɛ̨mp'a ra Abraham: “Nu'i mam bombøta i Abraham, dami huɛ̨gui ts'ʉ, ba pɛnhua ra Lázaro da dʉt'ra dehe rá xä, da därca ma jąni, nguetho ɛ̨mmɛ di ʉng na ra sibi i ja ua.” ");
INSERT INTO otmNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pɛ nu ra Abraham bi 'yɛ̨mp'a: “Nu'i, mam bom'bɛto i, dami bɛ̨n'i ts'ʉ 'bɛ'a gá 'yøt'e 'bʉ gmi 'bʉpʉ ja ra ximhäi. Gätho xʉn ho 'bɛ'a mi ja i, pɛ nu'a ra Lázaro hønt'a ran ʉnbi bi nu bʉ. Pɛ nuya din johya ua ra Lázaro ya, pɛ go hønt'a ran ʉnbi guí nu ya. ");
INSERT INTO otmNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nɛ man'da dí xi'i, hingui sä n'da da nɛxua da zørpʉ guí 'bʉi, nguetho i ja inde n'da ra mba'ye xʉn ndoho. Nɛ nu'i hingui sä gua nɛxpʉ guí 'bʉi gui søcua, nguetho i cot'a ra mba'ye bʉ,” bi 'yɛ̨n'a ra Abraham. ");
INSERT INTO otmNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nu ra mɛmbɛti xø mahøn'a bi xi'a ra Abraham: “Pɛ nu'bʉ hin da zä ba pɛnhua, pɛ gui pɛn'na ra Lázaro bʉ ja rá ngu ma ta da xi'ʉ 'bʉpʉ 'bɛ'a dí sägä. ");
INSERT INTO otmNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nguetho i 'bʉpʉ cʉt'a man 'yohʉ, nɛ dí ndepe nɛ'ʉ da zøm bʉ guí 'bʉhmi 'bʉ bi du, nɛ him ba ɛ̨cua ja ran ʉnbi,” bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pɛ nu ra Abraham bi 'yɛ̨mp'a: “Nubʉ 'bʉh nin 'yohʉ, i ja bʉ rám hman ra Moisés nɛ yʉ́ pøngahyą Oją, i sä da 'yøxʉ 'bɛ'a i man'ʉ.” ");
INSERT INTO otmNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pɛ nu ra mɛmbɛti bi 'yɛ̨n'a: “Pɛ nu'i ma ta Abraham, hinga xøt'a rám hman ra Moisés ngue da 'yø'ʉ man 'yohʉ, pɛ nu'bʉ da ndants'a n'da xʉn du ngue da xifi, da 'yø 'bʉ.” ");
INSERT INTO otmNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pɛ nu ra Abraham bi 'yɛ̨mbi: “Nu'bʉ hin da 'yʉrpa ra güɛnda 'bɛ'a i man ra Moisés nɛ yʉ́ pøngahyą Oją, xín da 'yʉrpa ra güɛnda 'bʉ da ndants'a n'da xʉn du,” bi 'yɛ̨n'a ra Abraham, bi 'yɛ̨n'a ra Jesús 'bʉ mi man ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nu'a ra Jesús bi xih yʉ́ xädi, bi 'yɛ̨mp'ʉ: ―Hin'yʉ n'da ra pa hin da ts'ä a ni mbʉihʉ gue i nde di 'bɛp ahʉ gui 'yøthʉ ra ts'oqui. Pɛ ndumbʉitho da nu'a to'o di japi da 'yøt' yʉ ts'oqui rá miją'iui. ");
INSERT INTO otmNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dí xi ahʉ, to'o di japi da 'yøt' ran ts'o n'da hinga na te rá mbʉi, man'da xʉn ho 'bʉ xtín thąrpa n'da ra dojʉni rá 'yʉga nɛ xtá t'ɛntpʉ ja ra deją, xinda gue'bʉ xtí japi xta 'yøt' ran ts'o a n'da hinga na te rá mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dami jamansu 'bɛ'a guí øthʉ. Nu'bʉ 'bʉ'a n'da ni miją'ihʉ bi 'yøt'ahʉ ran ts'o, dami xihmbʉ hingui ho'a bi 'yøt'ahʉ. Nɛ nu'bʉ da 'yømanho a guí xihmbʉ, damim punbahʉ 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nɛ nu'bʉ yoto nidi n'dapa da 'yøt'ahʉ ran ts'o, nɛ n'dandį ngu n'dandį da 'yä ahʉ ra punbi, dami punbahʉ gätho, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nu'ʉ yʉ xädi bi 'yɛ̨m bʉya: ―Grá Hmu, dami jaje ga ɛ̨c'yɛihe xʉn ho, bi 'yɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Madague'a ɛ̨mmɛ zʉ ts'ʉtho gui 'yɛ̨c'yɛigahʉ, tengu bʉ ni nɛqui rá hmudä ra c'u, sä gui xihmbʉ ra za 'bäcua da 'uegue dím 'bäpʉ ja ra deją nɛ da 'ueh pʉya. Hin'yʉ 'bɛ'a xʉn hɛ̨i 'bʉ gui 'yɛ̨c'yɛigahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","―Nu'bʉ n'da ran 'yohʉ 'bʉh rá 'yɛ̨hɛ di jamansup yʉ́ dɛ'yo uague dim pɛpʉ rá huąhi, nɛ nu'bʉ bin de bá ɛ̨pʉ ja rá ngu bʉya, ha da sifi din sihmɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pɛ hin'na, pɛ da sifi di hocpa rán sihmɛ rá hmu, nɛ nu'bʉ bi niyą, ja din sihmɛ ra 'yɛ̨hɛ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nu'a ra 'yɛ̨hɛ 'bʉ bi 'yøt' rá 'bɛfi bi xih rá hmu, hingui t'ɛ̨mbi “jamadi gá 'yørca ma 'bɛfi,” hingui t'ɛ̨mbi, ngue ya ra 'yɛ̨hɛ thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nɛ ngutho ahʉ 'bʉ gá 'yøthʉ rá 'bɛfi Oją, gui 'yɛ̨nthohʉ bʉya: “Hin nte dá øthe ngue dí hnumanhoje, nguetho hønt'a bi xije Oją dá øthe,” gui 'yɛ̨mhbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nu'a ra Jesús 'bʉ mi 'yo bʉ ja ra 'yu ní mba Jerusalén, bi tho inde bʉ ja yʉ́n yąni yʉ xɛqui Samaria nɛ Galilea. ");
INSERT INTO otmNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nɛ nu'bʉ mi ts'ʉtho da yʉt'a n'da ra hnini, ba ɛ̨pʉ 'dɛt'a yʉn 'yohʉ i nde din c'athʉ ra Jesús. Gätho mi hɛ̨mb ra t'axca'ya ʉ. Nɛ nu'ʉ yʉn 'yohʉ yabʉ ts'ʉ bim 'bäi nɛ nts'ɛdi bi mbafi, bi 'yɛ̨n'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","―Nu'i Jesús, grá xänbate i, dami huɛ̨gahe ts'ʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nu ra Jesús 'bʉ mi nu'ʉ bʉya, bi xi'ʉ da 'yut yʉ́ ją'i ʉ yʉ mbäją. Nɛ nu'bʉ mi mba ʉ, nu'a ra Jesús bi japi bin hoc yʉ́ ją'i bʉ ní mba. ");
INSERT INTO otmNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nɛ nu n'da, 'bʉ mi bądi bi zä rá ją'i, 'bex bá peng bʉ 'bäh ra Jesús nɛ nts'ɛdi bi 'yɛ̨spa Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bin dąnyahmu bʉ ja rá gua ra Jesús, bi 'yäp ra jamadi nguetho bi yąn'a. Nɛ nu'a, ra mɛngu Samaria a, hing rá mijudíohʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pɛ nu ra Jesús bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","―Ha hinga gue'ʉ 'dɛt'a dá hoqui. Hapʉ i 'bʉ'ʉ mi gʉto. Ha hingui sä ba ɛ̨'ʉ 'da xtí un ra jamadi Oją. Pɛ hønna n'da ran'yohʉ hing ra judío bi bɛ̨n'a ra mate bi 'yørpa Oją, nɛ im bɛ̨nsɛ ʉ mi'da ngue ɛ̨na i pą Oją ʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nɛ xø bi 'yɛ̨mp'a ran 'yohʉ: ―Damim 'bäi, ní mba ya. Bin yąn'a ya nguetho gá 'yɛ̨c'yɛi gue i ja ma ts'ɛdi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nu'ʉ 'da yʉ fariseo bi 'yän'na ra Jesús: ―'Bɛ'a ní pa di manda ua rá ts'ɛdi Oją, bi 'yɛ̨n'ʉ. Nu ra Jesús bi 'yɛ̨mp'ʉ: ―Hin da fą 'bʉ bi manda rá ts'ɛdi Oją ua. ");
INSERT INTO otmNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hingui sä n'da da 'yɛ̨na: “Guecua di manda ua rá ts'ɛdi Oją,” xíngui sä n'da da 'yɛ̨na: “Guembʉ di manda rá ts'ɛdi Oją bʉ,” njon da zä da 'yɛ̨na, nguetho guepʉ ja ní mbʉi n'da di manda rá ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nɛ nubʉya, bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Da zøn ra pa ɛ̨mmɛ guin ndehʉ ba pengä, nugä ngue dán ją'igä ua ja ra ximhäi. Pɛ di 'bɛtho yʉ pa ba pengä. ");
INSERT INTO otmNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pɛ nu'ʉ 'da da 'yɛ̨n'ahʉ: “Guecua i 'bʉcua ya,” da 'yɛ̨n'ahʉ. Nɛ nu'ʉ mi'da da 'yɛ̨n'ahʉ: “Guembʉ i 'bʉpʉ a.” Pɛ 'yo guí øhmbʉ 'bɛ'a da man'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nguetho nu'bʉ bá pengä, nugä ngue dán ją'igä ua ja ra ximhäi, di nɛqui tengu ra huɛi ngue di hyät'i gätho na ngʉni ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pɛ m'bɛt'o thoho ga nugä xʉn ngu ran ʉnbi, nguetho yʉ ją'i 'bʉcua ya, hin da 'yɛ̨c'yɛigui. ");
INSERT INTO otmNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nu'a ra pa ba pengä, nugä ngue dán ją'igä ua ja ra ximhäi, nu yʉ ją'i dim 'bʉi da 'yøt'ʉ tengu bi 'yøt' yʉ ją'i mi 'bʉhmbʉ a ra Noé. ");
INSERT INTO otmNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nu'ʉ yʉ pa mi 'bʉ'a ra Noé, gätho yʉ ją'i mi øt'e 'bɛ'a mi numanhosɛ, mi sihmɛ, mi mihni, nɛ mi sin yʉ́ xisu, nɛ gue'a mi øt'ʉ gätho yʉ pa gue'bʉ go mi zøn ra pa bi yʉt ra dąmbosa ra Noé. Nɛ bin dą'ye bʉya, bi go'mi gätho ra häi a ra dehe, bi du gätho ʉ yʉ ją'i mi 'bʉi. Din jabʉ da 'yøt' yʉ ją'i 'bʉ bá pengä. ");
INSERT INTO otmNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nɛ tengu bi 'yøt' yʉ ją'i yʉ pa mi 'bʉ'a ra Lot, nɛ ngutho da 'yøt' yʉ ją'i dim 'bʉ 'bʉ bá pengä. Gätho yʉ ją'i bi 'yøt'e 'bɛ'a mi numanhosɛ da 'yøt'e, bin sihmɛ, bim mihni, bim pä, nɛ bin täi, bi 'yøt' yʉ́ huąhi, bi hyøh yʉ́ ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Gue'bʉ go mi zøn ra pa bi bøn ra Lot bʉ ja ra hnini Sodoma, nɛ bá cąh mahɛ̨ts'i ra sibi ma uąnspi ra azufre, bi juah ra hnini, nɛ gätho mi 'bʉpʉ bi du bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nɛ din jabʉ da 'yøt' yʉ ją'i 'bʉ bi zøn ra pa gua pengä. ");
INSERT INTO otmNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nɛ to'o i 'bäpʉ maxøts'e ra zɛts'ąngu, hin da yʉrpʉ mbo rá ngu ngue da hyąts'i 'bɛ'a ja bʉ, da mba tho. Nɛ gätho to'o dim pɛpʉ ja rá huąhi, hin ba peng bʉ ja rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dami bɛ̨mhbʉ ts'ʉ 'bɛ'a bi 'yøt'a rá xisu ra Lot 'bʉ mi sifi da 'da'ʉ, nɛ man'da bi bɛ̨nsɛ rá ngu, nɛ gue'a í du'a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nɛ gätho to'o in nde da yąnsɛ rá te, da nu ran ʉnbi maząi a. Pɛ gätho to'o hin da bɛ̨ni da yąnsɛ rá te, din ja ra te maząi a. ");
INSERT INTO otmNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nu'bʉ bi zøn ra ora gua pengä, di ąpʉ yoho bʉ ja rá oi, nu'a n'da da ts'ix'a, nɛ nu'a n'da da gopʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nɛ nu'bʉ yoho yʉ xisu 'darpʉ i jʉni, nu'a n'da da ts'ix'a, nɛ nu'a man'da da gopʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nɛ nu'bʉ yoho yʉn 'yohʉ i 'yo bʉ ja yʉ́ huąhi, nu'a n'da da ts'ixa, nɛ nu'a man'da da gopʉ, nɛ hønt'a to'o da 'yɛ̨c'yɛi, da ts'its'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","―Grá Hmu, hapʉ din ja'a guím ma, bi 'yɛ̨mp'ʉ yʉ́ xädi. ―Nubʉ hapʉ di pɛti yʉ pada, gui pąhmbʉ gue di 'bom bʉ xʉn du, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","N'da ra pa, bi xi'a n'da ran t'uti yʉ́ xädi ra Jesús, ra hmɛpya jatho thocua thoho din yąui Oją nɛ hin din xømbʉi da 'yädi gue'bʉ go din ja 'bɛ'a ädi. ");
INSERT INTO otmNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nɛ bi 'yɛ̨na: ―Mi 'bʉ a n'da ra zɛ'mi bʉ ja n'da ra hnini, him bi numansu Oją xínga gue yʉ́ miją'ihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nɛ mi 'bʉpʉ n'da ra xisu xí du rá ndø. Nɛ thocua thoho mi søm bʉ nɛ mi äpi da mbäts'i nangue rán sʉiui i 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nɛ him 'be bi 'yʉrpa ra güɛnda 'bɛ'a bi man ra xisu a ra zɛ'mi. Jague'bʉ min xømbʉi nɛ bi 'yɛ̨nsɛ: “Nugä, hin dí numansu Oją, xínga gue'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pɛ ɛ̨mmɛ di pac na ra xisu, masque ga øt'ä 'bɛ'a in nde n'dahma hin di thoqui da zøcua ngue di xuhnanyagui,” bi 'yɛ̨nsɛ ra zɛ'mi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nubʉya, bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Dami bɛ̨mhbʉ 'bɛ'a bi 'yøt'a ra zɛ'mi. Madague ra ts'om'bäi. ");
INSERT INTO otmNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dí xi ahʉ, man'da da 'yø'a Oją 'bʉ gui hyumbi gui 'yäfʉ rám fäts'i ngue yʉ́ t'ʉhni ahʉ a. Nu'a Oją hingui tø'mi 'bɛ din xømbʉizɛhɛ a. ");
INSERT INTO otmNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pɛ dí xi ahʉ, 'bexque da mbäx ahʉ 'bʉ guí äfʉ rám fäts'i. Janangue'a gui 'yäfʉ Oją di zɛt'a ni mbʉihʉ, nɛ hin da du ni mbʉihʉ ngue him 'be ba pengä ua. Nɛ nu'bʉ bá pengä nugä ngue dán ją'igä ua ja ra ximhäi, ga tįn ahʉ bʉ guí ɛ̨c'yɛigahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nɛ xø bi xih man'da ran t'uti ʉ im bɛ̨ni xʉn hosɛ, nɛ i numan'ʉ ʉ yʉ́ miją'ihʉ. Nɛ bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Yoho yʉn 'yohʉ bi mba bʉ ja ra dąniją, din yąui Oją. Nu'a n'da ra fariseo, nɛ nu'a man'da ra hyącahäi. ");
INSERT INTO otmNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nu'a ra fariseo, bim 'bäi nɛ bin yą, bi 'yɛ̨na: “Jamadi Oją, nguetho nugä xíngui ts'ʉ xʉn ts'o ma mbʉi, nugä hin drá siyategä, nɛ hin drá hyätegä, nɛ hin drá 'yomt'ɛ̨nigä tengu'ʉ gätho mi'da. Jamadi ngue nugä hin dí øt'ä tengu øt'na ra hyącahäi i 'bäcua. ");
INSERT INTO otmNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nugä ząi dí ɛ't' man sihmɛ yondį n'da semana, nɛ dí un'a ná 'dɛt'a a dí tąh pʉ ja ra niją,” sä bi 'yɛ̨n'a ra fariseo 'bʉ min yąui Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pɛ nu'a ra hyącahäi, n'danni ts'ʉ mi 'bäi, nɛ i su da ndøts' mahɛ̨ts'i, bi hyɛ̨'mahäi, nɛ ɛ̨mmɛ tu rá mbʉi. Nɛ bi 'yɛ̨mp'a Oją: “Ma Oją i, dín yeh ni mbʉi, nguetho drá dądits'oquigä,” bi 'yɛ̨n'a ra hyącahäi. ");
INSERT INTO otmNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Pɛ dí xi ahʉ, nu'a ra hyącahäi ya xí punba Oją 'bʉ mi mbeng bʉ ja rá ngu. Pɛ hin'na a ra fariseo, guexta'a xʉn ts'o rá mbʉi 'bʉ mi bøm bʉ. Nguetho to'o din 'yɛ̨ts'i, gue'a dín ʉnba ʉ. Pɛ gätho to'o hin din 'yɛ̨ts'i, gue'a dí t'ɛ̨spa ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","N'da ra pa, nu 'da yʉ ją'i bá si yʉ́ t'ʉhni bʉ 'bʉh ra Jesús ngue da mba nthädi ʉ yʉ́ t'ʉhni. Pɛ nu'bʉ mi nu'ʉ yʉ́ xädi 'bɛ'a øt' yʉ ją'i, him bi japi da ts'ix ʉ yʉ t'ʉhni bʉ 'bä'a ra hmu, bi dąmyhą thoho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pɛ nu'a ra Jesús bi zon'dʉ yʉ t'ʉhni nɛ bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Dami jafʉ ba thocua ya yʉ t'ʉhni, o gadí hɛcuahʉ, nguetho gätho to'o da yʉrpʉ di manda rá ts'ɛdi Oją, jatho 'bɛ da gohi tengu n'da ra t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dami 'yøhmbʉ 'bɛ'a dí xi ahʉ: Jatho gui 'yøthʉ tengu'bʉ gyʉ́ t'ʉhnihʉ 'bʉ guí ɛ̨c'yɛihʉ. Nu'bʉ hin'na, hin gui cʉthʉ bʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nɛ nu'a n'da rá ngʉrpi yʉ judío, bi 'yän'na ra Jesús: ―Grá hogaxänbate, 'bɛ'a sä ga øt'ä ngue din jagä ra te maząi. ");
INSERT INTO otmNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Bi dąh ra Jesús: ―Ha guím bɛ̨ni 'bɛ'a guím ma ngue guí ɛ̨ngui xʉn hogui, nguetho hønt'a Oją xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Guí pądi 'bɛ'a i mam bʉ ja yʉn t'ɛ̨di ngue i ɛ̨m bʉ: “O guí 'yomt'ɛ̨ni, o guí hodu, o guím pɛ̨, o guí man ra fɛhni, nɛ gui numansu ni ta nɛ ni mbe,” i mam bʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nu ran 'yohʉ bi dąti: ―Gätho dí øt'ä ʉ gue'bʉ go mán t'ʉhnigä, bi 'yɛ̨n'a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nɛ nu'a ra Jesús'bʉ mi 'yøde 'bɛ'a bi ma, bi 'yɛ̨mp'a: ―Gadí 'bɛ'i ts'ʉ. Ní mba, gui pä gätho 'bɛ'a i ja i, nɛ gui darpa yʉ hyoya. Gua ɛ̨h pʉya, gui tɛngui. Nɛ nubʉya, xʉn ngu din ja i bʉ mahɛ̨ts'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pɛ nu'a ran 'yohʉ 'bʉ mi 'yø'a bi man ra Jesús, ɛ̨mmɛ bi du rá mbʉi, nguetho ɛ̨mmɛ ra mɛmbɛti a. ");
INSERT INTO otmNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nu'a ra Jesús 'bʉ mi nu bi du rá mbʉi a ran 'yohʉ, bi 'yɛ̨na: ―Xʉn hɛ̨i yʉ mɛmbɛti da yʉrpʉ di manda rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Man'da hingui hɛ̨i n'da ra camello da yʉrpʉ ja rá gu ra 'yofani, xinda gue'ʉ yʉ mɛmbɛti da yʉrpʉ di manda rá ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nɛ nu'ʉ yʉ ją'i 'bäpʉ bi 'yɛ̨n'ʉ: ―Pɛ nu'bʉ in jabʉ, to'o maha da zä dim pøhø 'bʉ, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nu'a ra Jesús bi dąt'ʉ: ―Nu'a Oją sä da 'yøt'a hingui sä da 'yøzɛhɛ yʉ ją'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nu'a ra Pedro bʉya, bi 'yɛ̨mbi: ―Nugähe, gätho a mi jaje dá sohmbe nɛ dá tɛn'nahe. ");
INSERT INTO otmNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Nu ra Jesús bi 'yɛ̨na: ―Guehma dí xi ahʉ, gätho to'o bi zoh rá ngu, ogue rá xisu, ogue yʉ́ cu, ogue rá ta, ogue rá mbe, ogue yʉ́ t'ʉhni, ngue bin unsɛ di manda rá ts'ɛdi Oją ʉ, Oją di unni man'da xʉn ngu xinda gue'a mí ja. Pɛ nɛ'a ra te maząi bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nu ra Jesús, bi zixpʉ ma'ueni gätho 'dɛ'mayoho yʉ́ xädi, nɛ bi 'yɛ̨mp'ʉ: ―Dami 'yøhmbʉ ya. Ga mbähä bʉ Jerusalén, nɛ din ja bʉ 'bɛ'a gätho bi man yʉ pøngahyą maya'bʉ nanguecä, ngue dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nu yʉ ją'i di dägä bʉ ja rá ts'ɛdi ʉ hing yʉ judío, nɛ nu'ʉ da dengui, nɛ di c'ąman'ʉgui, nɛ da zoxqui. ");
INSERT INTO otmNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nɛ da mbɛgbä, nɛ da hyogä. Pɛ ná hyu pa bʉya ga ndants'i mahøn'a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pɛ nu'ʉ yʉ́ xädi, him bi bądi 'bɛ'a nam bøn'a bi man ra Jesús. Nguetho njo'mitho yʉ́n 'yomfɛ̨ni ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nɛ mi 'yo bʉ häntho bʉ ja ra hnini Jericó a ra Jesús, nɛ mi hupʉ nden'yu n'da zʉ xädä mi hąxta'a mí si. ");
INSERT INTO otmNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nɛ nu'bʉ mi 'yø'a ra xädä ngue xʉn ngu yʉ ją'i mba bʉ, bi 'yänni 'bɛ'a øt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nɛ bi sifi mba bʉ ra Jesús ra mɛngu Nazaret. ");
INSERT INTO otmNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nɛ nu'a ra xädä bʉya, nts'ɛdi bi mbafi, bi 'yɛ̨na: ―Nu'i gra Jesús, rám bom'bɛto i ra David, dami huɛ̨gui ts'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nɛ nu'ʉ yʉ ją'i mi 'bäpʉ, bi xifi din hɛ̨. Pɛ madague him mi ndepe din yą, pɛ man'da nts'ɛdi bi mbafi, bi 'yɛ̨na: ―Gra Jesús, rám bom'bɛto i ra David, dami huɛ̨gui ts'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nu'a ra Jesús bim 'bäh pʉya nɛ bi manda ba ts'inba a ra xädä. Nɛ nu'bʉ mim 'bähmi ra Jesús a ra xädä, bi 'yän'na ra Jesús bʉya: ");
INSERT INTO otmNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―'Bɛ'a guí nde ga øt'a'i, bi 'yɛ̨mbi. Nɛ nu ra xädä bi dąti: ―Dín nde ga nu ran nɛqui. ");
INSERT INTO otmNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","―Sä guin nu ya, bi zä ni dä nguetho gá 'yɛ̨c'yɛi i ja ma ts'ɛdi, bi 'yɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Bex bi zä bi nu ran nɛqui rá dä bʉya. Nɛ bi dɛn'na ra Jesús. Bi 'yɛ̨spa Oją bʉ ní mba. Nɛ'ʉ gätho yʉ ją'i mi 'bʉpʉ, bi 'yɛ̨spa Oją bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nu'a ra Jesús bi yʉrpʉ ja ra hnini Jericó, mi 'yo bʉ, ɛ̨na da thogui. ");
INSERT INTO otmNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nɛ mi 'bʉpʉ n'da ra ngʉrpa hyącahäi, ɛ̨mmɛ ra mɛmbɛti a, í Zaqueo a. ");
INSERT INTO otmNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nɛ nu'a ra Zaqueo, ɛ̨mmɛ min ndehma da nu'a ra Jesús, pɛ him mi sä nguetho hingui hɛ̨ts'i, nɛ ɛ̨mmɛ dʉ yʉ ją'i bʉ mi 'yo'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Janangue'a, bin tihi bi ndexa n'da ra za ra sicómoro, ngue da zä da nu ra Jesús 'bʉ bi thopʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nɛ nu'bʉ mi zøn'a ra Jesús bʉ 'bä'a ra za mi huxa ra Zaqueo, bi ndøts'e nɛ bi 'yɛ̨mbi: ―Zaqueo, bá cą n'dihi nguetho ga søm bʉ ja ni ngu ra pa ya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nɛ nu'a ra Zaqueo bin johya, 'dahmantho bi gąi, bi mba rá ngu nɛ bi zimanho a ra Jesús 'bʉ mi zøm bʉ rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pɛ nu'ʉ yʉ ją'i him bi numanho nguetho bin säya bʉ ra Jesús bʉ ja rá ngu n'da ra ziyate. ");
INSERT INTO otmNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nɛ nu'a ra Zaqueo bim 'bäi bi 'yɛ̨mp'a ra Jesús: ―Ma Hmu i, nuya ga undä yʉ hyoya made 'bɛ'a gätho i jagä. Nɛ nu'bʉ mi siyagä n'da ra ją'i ngue hin rá 'yu 'bɛ'a mi øt'ä, goho nidi ga cospa a dá siyabi, bi 'yɛ̨n'a ra Zaqueo. ");
INSERT INTO otmNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nɛ nu'a ra Jesús bi 'yɛ̨mbi: ―Gá päh nin 'yomfɛ̨ni nɛ i ja ra punbi ni ts'oqui ya, nɛ gätho i 'bʉcua ja ni ngu, gra Zaqueo, rám bom'bɛto i ra Abraham. ");
INSERT INTO otmNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nɛ gue'a ná ɛ̨cä, ngue guecä dán ją'igä ua ja ra ximhäi, ngue gan yąnba yʉ́ te'ʉ i pądi ja yʉ́ ts'oqui, nɛ hin da nu ran ʉnbi maząi, pɛgue din ja ra te maząi ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nu ra Jesús bi xih man'da ran t'uti ʉ yʉ ją'i, nguetho bi bɛ̨n'ʉ yʉ ją'i ngue nu'bʉ da zøm bʉ Jerusalén ra Jesús, 'bex di japi di manda bʉ rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nɛ bi 'yɛ̨mp'ʉ: ―Mi 'bʉ'a n'da ran 'yohʉ, ra ts'ʉt'abi rá ta. Nɛ bi mba bʉ n'danni n'da ra hnini ngue bin nde bín t'un bʉ rá 'bɛfi ngue din ts'ʉt'abi bʉ rá häizɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pɛ nu'bʉ mi nɛts'i, bi zon'dʉ 'dɛt'a yʉ́ 'yɛ̨hɛ, 'da'a n'da bi un ra mbɛti ngue ra oro xʉn ngu di muui. Nɛ bi 'yɛ̨mp'ʉ: “Gui hyomhbʉ 'bɛ'a da zä gui 'yøthʉ ngue di xąnd ma mbɛti,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nɛ nu'ʉ yʉ ją'i mi 'bʉpʉ ja rá häi, him mi numanho a ran 'yohʉ. Janangue bi mbɛhni 'da yʉ́m 'bɛhni ngue m'bɛt'o da zøni da ma ngue hin din t'un rá ts'ɛdi a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pɛ nu'a ran 'yohʉ, bin t'un ran t'ɛ̨di din ts'ʉt'abi nɛ bi mbeng bʉ rá häi bʉya. Nu'bʉ mi zøm bʉya, bi zon'dʉ yʉ́ 'yɛ̨hɛ xí un ra mbɛti, nde da bądi hangu bi hyuxa rá mbɛti xí un'na n'da ngu n'da ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nu ra mbʉdi 'yɛ̨hɛ bi 'yɛ̨mp'a: “Nuya bin ja 'dɛt'a a ni mbɛti,” bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bi 'yɛ̨mp'a rá hmu bʉya: “Xʉn ho gá 'yøt'e, gra 'yɛ̨hɛ̨ xʉn ho, gá xąnda zʉ ts'ʉ dá 'da'i, pɛ nɛ ga 'da'a nin t'ɛ̨di ngue gui manda 'dɛt'a yʉ hnini,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nu ná yoho ra 'yɛ̨hɛ bi 'yɛ̨mp'a: “Nuya bin ja cʉt'a a ni mbɛti gá 'daqui ga xąndä,” bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nu'i, ga 'da'a nin t'ɛ̨di ngue gui manda cʉt'a yʉ hnini 'bʉ,” bi 'yɛ̨mp'a rá hmu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nɛ xø man'da ra 'yɛ̨hɛ bi 'yɛ̨mp'a rá hmu bʉya: “I ja ua ni mbɛti gá 'daqui. Dá pɛ'ts'ä xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nguetho dí pącä 'bɛ'a nim 'bäi, ngue ya hin'yʉ nin huɛ̨cate. Guí honi 'bɛpʉ gdí hyąnba rá mbɛti yʉ ją'i. Nɛ guí hąnba yʉ́ huąhi, janangue dá pɛ'ts'ä ni mbɛti ngue dí su ga 'bɛdi,” bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nu'a rá hmu bi 'yɛ̨mbi: “Nu'a gá ma i udi ngue grá ts'om'bäi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Hanja hin gá hmi'a ma mbɛti n'dahma xtí hyux'i ts'ʉ,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nɛ bi 'yɛ̨mp'ʉ mi 'bäpʉ: “Dami hyąnbahʉ rá mbɛti na ran 'yohʉ nɛ gui unhdʉ a ra mbʉdi 'yɛ̨hɛ, nu'a to'o bi dąha xʉn ngu,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pɛ nu'ʉ mi 'bäpʉ, him bi nde da 'yøt'e 'bɛ'a bi man yʉ́ hmu, nguetho xʉn ngu i ja a ra mbʉdi 'yɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pɛ nu'a ra hmu bi 'yɛ̨mp'ʉ: “Nu'a to'o i humbi i øt' ma 'bɛfi, hinga hønt'a rán zäbi da dąha, pɛ man'da xʉn ngu ga unni. Pɛ nu'a hingui nde da 'yøt' ma 'bɛfi, hin te da dąha, nɛ ga hąnba'a dá unni,” bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Nɛ nu'ʉ him mi ndeje dan ts'ʉt'abi ua, ba sihʉ, gui sɛcpahʉ yʉ́ 'yʉga ua,” bi 'yɛ̨n'a ra hmu bʉya, bi 'yɛ̨n'a ra Jesús 'bʉ mi man ran t'uti. ");
INSERT INTO otmNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nɛ nu'bʉ mi gua'a bi man ra Jesús, bi thopʉya, ní mba bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nɛ nu'bʉ mi ts'ʉtho da zøm bʉ ja ra nyuni guepʉ i ja ra hnini Betfagé nɛ ra hnini Betania, ");
INSERT INTO otmNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","bi mbɛhni yoho yʉ́ xädi, bi 'yɛ̨mbi: ―Ní mbɛ bʉ nán jombʉ ja ra hnini. Nɛ gui tįmmi bʉ n'da ra t'ʉburu án thąt'i bʉ ja ra nden'yu, nɛ xínga n'da ra ją'i ní hyuts'i. Bá xocui nɛ ba siui ua. ");
INSERT INTO otmNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nɛ nu'bʉ 'bo'o da 'yän'naui: “Hanja gní xocui ra buru,” gui 'yɛ̨nui: “Nu'a ra hmu i hon'a ra buru,” gui 'yɛ̨nui, bi 'yɛ̨mp'ʉ yoho yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nɛ bi mba bʉya, nɛ bi dįn'a 'bɛ'a xí xi'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nɛ nu'bʉ mi xoc ra buru, bi 'yän'na rá mbɛti: ―Hanja gní xocui na ra buru, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bi dąh yʉ xädi bʉya: ―Nu'a ra Hmu i honi, bi 'yɛ̨n'ʉ. Nɛ bi ndepe da zix bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nɛ nu'ʉ yʉ xädi bá si ra buru bʉya, nɛ bi gąspa yʉ́ coto bʉ ja rá xʉthä ra buru nɛ bi hyuxa ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nɛ nu'bʉ mi mba bʉ 'yu ra Jesús, nu'ʉ yʉ ją'i 'bex bi mbøcua yʉ́ pahni bʉ ja ra 'yu ngue da thopʉ a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nɛ nu'bʉ mi gąpʉ ja ra nyuni ní mba bʉ Jerusalén, gätho ʉ min 'yohʉ nts'ɛdi i mbafi, bin johya nɛ bi 'yɛ̨spa Oją nangue yʉn t'øt'e nuįxte bi nu. ");
INSERT INTO otmNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bi 'yɛ̨n'ʉ: ―Mająpi ra ts'ʉt'abi bá ɛ̨hɛ nangue rá thuhu ra Hmu. Nɛ din ja rán johya Oją yʉ́ mbʉi yʉ ją'i. Nuįxtetho rá ts'ɛdi Oją, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nɛ nu 'da'ʉ yʉ fariseo bi 'yɛ̨mp'a ra Jesús: ―Dami hɛcua ni xädi din hɛ̨. ");
INSERT INTO otmNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'bʉ ga hɛcpä yʉ ngue i ɛ̨spa Oją, pɛ go da 'yɛ̨spa Oją ya yʉ do bongua, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nɛ nu'bʉ mi hyän bʉ ra hnini Jerusalén a ra Jesús, bin zoni. ");
INSERT INTO otmNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nɛ bi 'yɛ̨n'a: ―Min ndegä ngue xquí pąhmbʉ a dí yąn'ahʉ bʉ ja ran ʉnbi maząi, pɛ hin gán nde gá pąhmbʉ, pɛ nuya him man zä, nguetho tengu'bʉ njo'mi ni dähʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nɛ da zøn ra pa ba ɛ̨h nin sʉihʉ di mbät'a ni hninihʉ nɛ njon da zä da bøni ngue din yąni, nɛ gan tunhdʉ ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nɛ gätho ahʉ ngue guí 'bʉhmbʉ nʉ, da hyo ahʉ nɛ da guah ni hninihʉ. Nɛ da mba nso't'i, nɛ xínga n'da ra jądo da gopʉ. Nguetho nu ahʉ xíngui ts'ʉ gá pąhmbʉ a ra pa xtí pø ahʉ Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nɛ nu'a ra Jesús bʉya, bi mba bʉ ja ra dąniją nɛ bi hyøn'a thi gätho yʉ mbä mi 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―I mam bʉ ja rám hman Oją: “Í thø'a ma ngu ngue da mba nthąndegä bʉ,” i ɛ̨n Oją. Pɛ nu ahʉ gá 'yørpadahʉ tengu'bʉ ra hyądo guepʉ nín 'yąn'ʉ yʉ bɛ̨, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nu'a ra Jesús thocua thoho min xänbate bʉ ja ra dąniją. Pɛ nu'ʉ yʉ ngʉrpa mbäją, nɛ yʉ xänbate niją, nɛ yʉ dąc'yɛi, min nde da hyo'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pɛ hin'yʉ 'bɛ'a da 'yøt'e ngue da hyo. Nguetho gätho yʉ ją'i bi 'yʉrpa ra güɛnda 'bɛ'a bi man ra Jesús. Njon bin nde bi ʉ't' yʉ́ mbʉi ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nɛ nu ra Jesús n'da ra pa bi xänba yʉ ją'i bʉ ja ra dąniją nangue ran ho ma'da'yo. Nɛ'ʉ yʉ ngʉrpa mbäją nɛ yʉ xänbate niją, nɛ yʉ dąc'yɛi, gätho bi zøm bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nɛ bi t'än'na ra Jesús: ―Hanja sä guí øt'e 'bɛ'a guí øt'e. To'o bi 'da'a nin t'ɛ̨di, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pɛ nu ra Jesús bi dąti: ―Nɛcä, ga än'nahʉ, ");
INSERT INTO otmNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","to'o bi un rán t'ɛ̨di ra Xuua ngue bi 'yøt' ran xixyą, hague Oją uague yʉ ją'i, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pɛ nu'ʉ bin 'yänzɛhɛ ʉ 'bɛ'a dí dąti. Nɛ bi 'yɛ̨nsɛ: ―Nu'bʉ ga ɛ̨mfʉ ngue Oją bi un'na rán t'ɛ̨di a ra Xuua, nɛ da 'yɛ̨njʉ bʉya: “Hanja hin gá 'yɛ̨c'yɛihʉ 'bʉ.” ");
INSERT INTO otmNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pɛ nu'bʉ ga ɛ̨mfʉ, yʉ ją'i thoho bi un rán t'ɛ̨di, dí bat'adojʉ yʉ ją'i nguetho xʉn ngu yʉ ją'i ɛ̨c'yɛi rá pøngahyą Oją ra Xuua, bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Janangue'a bi t'ɛ̨mp'a ra Jesús: ―Hin dí pąhmbe to'o bi un rán t'ɛ̨di ra Xuua, bi 'yɛ̨ntho. ");
INSERT INTO otmNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɛcä hin ga xi ahʉ to'o bi 'dacä ran t'ɛ̨di ga øt'ä 'bɛ'a dí øt'ä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nɛ bi xih man'da ran t'uti a ra Jesús, bi 'yɛ̨na: ―Mi 'bʉ'a n'da ran 'yohʉ bi 'yøt'a n'da ra nuąndät'o, nɛ bi hmit'i 'da yʉ mbɛfi. Nu'a rá mbɛti bi mba n'danni bʉya, nɛ nya'atho bám 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nɛ nu'bʉ mi zøn yʉ pa da thʉc yʉn dät'o, nu'a rá mbɛti bá pɛhna n'da rá 'yɛ̨hɛ da duspa 'da yʉ́n dät'o, ngue'a án yąhʉ a. Pɛ nu'ʉ bi zocpa a ra nuąndät'o, bi mbɛmba thoho ra 'yɛ̨hɛ nɛ bi 'yɛt'i, xín te bi unni. ");
INSERT INTO otmNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nɛ ná yoho rá 'yɛ̨hɛ bá pɛhna rá mbɛti ra nuąndät'o, pɛ ngutho bi 'yørpa ra 'yɛ̨hɛ, nɛ'a bi mbɛmba thoho mahøn'a, bi 'yɛr bʉya nɛ nte bi unni. ");
INSERT INTO otmNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nɛ ná hyu rá 'yɛ̨hɛ xø bi mbɛhni mahøn'a a ran 'yohʉ, ngutho bi t'ørpe, bi ʉnba yʉ mbɛfi nɛ bi 'yɛt'i, xíngui ts'ʉ bi unni. ");
INSERT INTO otmNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nɛ nubʉya, nu ra mɛndät'o bi bɛ̨ni 'bɛ'a da 'yøt'e. Nɛ bi 'yɛ̨na: “Masque ga pɛhn'na ma ts'ʉnt'ʉ, dadí huɛ̨qui, xøhma da numansu na,” bi 'yɛ̨nsɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pɛ nu'bʉ mi nurpa rá ts'ʉnt'ʉ ʉ yʉ mbɛfi, bi mam bʉya ngue da hyo, bi 'yɛ̨n'ʉ: “Mbähä ga hohʉ rá ts'ʉnt'ʉ, janangue da zä ga cosɛhʉ ra nuąndät'o,” bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Janangue'a bi zix pʉ ma'ueni, bi hyøn'a thi ra ts'ʉnt'ʉ, nɛ bi hyo bʉ, bi 'yɛ̨n'a ra Jesús. Nɛ xø bi 'yän'dʉ yʉ ją'i mi 'bäpʉ: ―'Bɛ'a guím bɛ̨mhbʉ da 'yøt'a rá mbɛti ra nuąndät'o ya, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pɛ dí xi ahʉ, ba ɛ̨sɛ nɛ da hyo'ʉ, nɛ n'dan'yo di un'na rá nuąndät'o bʉya, bi 'yɛ̨n'a ra Jesús. Nɛ nu'bʉ mi 'yø'ʉ yʉ ją'i 'bɛ'a bi man ra Jesús, nu'ʉ bi 'yɛ̨n'ʉ: ―Oją da 'yøt'e hin din ja a guím ma, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pɛ nu'a ra Jesús bi hyɛ̨t'ʉ, nɛ bi 'yɛ̨mbi: ―Pɛ 'bɛ'a nam bøn'a rám hman Oją nt'o't'i maya'bʉ 'bʉ, ngue i ɛ̨na: Nu'a ra do bi bʉnt'ʉ yʉ gądo 'bʉ mi hyøh ra ngu, gue'a ra do man'da mahyoni, tengu thoho yʉ guangu, i ɛ̨m bʉ ja rám hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nɛ tengu'bʉ da guesɛgä a ra do i hmam bʉ. Hønt'a go to'o hingui ɛ̨c'yɛigui, din ʉnbazɛhɛ, tengu'bʉ da dąng bʉ ja ra do din tʉni, nɛ go ga sɛmpä a tengu'bʉ ra do da zɛ'mi nɛ da 'yɛt'i, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nu yʉ ngʉrpa mbäją nɛ yʉ xänbate niją 'bʉ mi 'yø'a ran t'uti bi man ra Jesús nangue'ʉ yʉ hyote mbɛfi, min nde da got'a fädi ra Jesús, nguetho bi bądi tengu'bʉ guesɛ ʉ yʉ hyote mbɛfi ʉ yʉ mbäją nɛ yʉ xänbate niją. Pɛ him bi got'i nguetho bi zutho yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Janangue bi bɛ̨m mahøn'a bʉya nɛ bi mbɛhni 'da yʉn 'yohʉ ngue da 'yän yʉn t'änni a ra Jesús, n'dahma din ja 'bɛ'a sä dí fɛnt'a ra Jesús ngue di dä bʉ 'bʉh ra ts'ʉt'abi. ");
INSERT INTO otmNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nɛ nu'ʉ yʉn 'yohʉ bi xi a ra Jesús: ―Xänbate i, dí pąhmbe hønt'a majuąni guí ma. Nɛ dí pąhmbe guí xänbi xʉn ho hønt'a go to'o má ją'i nɛ hin guí huahni to'o guí xänbi, pɛ guí xifi xʉn ho nangue Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dami xije ya, ha din thɛui man t'ɛ̨dihʉ bi 'dajʉ Oją 'bʉ ga juthʉ ra renta a ra ts'ʉt'abi Roma, uague hin'na, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pɛ nu'a ra Jesús mi pądi i ts'ämhyą thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Nɛ bi 'yɛ̨mp'ʉ: ―Hanja gní 'yängui, xi ni mbɛti gní juthʉ ra renta ra ts'ʉt'abi, gan nugä, bi 'yɛ̨na. Nɛ bi un bʉya. ―To'o rá pøte nɛ rá thuhu i cuat na ra mbɛti, bi 'yɛ̨n'a ra Jesús. Nɛ nu'ʉ bi 'yɛ̨n'ʉ: ―Rá pøte nɛ rá thuhu ra ts'ʉt'abi Roma i cuat na. ");
INSERT INTO otmNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bi dąh ra Jesús bʉya nɛ bi 'yɛ̨mp'ʉ: ―Nu'a rá mbɛti ra ts'ʉt'abi Roma, gui un'na. Nu'a xin rá mbɛti Oją, gui un'na Oją a, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Janangue nu yʉn 'yohʉ him bi zä xtá hyät'a ra Jesús, pɛ bi hyonya thoho ʉ 'bɛ'a bi man'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nɛ nu'ʉ 'da yʉ saduceo, bi zøm bʉ 'bʉh ra Jesús, gue'ʉ hingui ɛ̨c'yɛi da ndants'ʉ xøn du. Nu'ʉ bi 'yɛ̨mp'a ra Jesús: ");
INSERT INTO otmNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Nu'a ra Moisés bi 'dajʉ n'da man t'ɛ̨dihʉ nɛ bi 'yɛ̨na: “Nu'bʉ bi du n'da ran 'yohʉ ngue mi 'bʉh rá xisu nɛ njo'o yʉ́ t'ʉhni, nu'a rán 'yohʉ da zinba a rá xisu. Nɛ nu'a rá mbʉdi t'ʉhni dim 'bʉi, da thuspa rá thuhu a ran 'yohʉ bi du nɛ da'yɛ̨mbi rá ta a,” bi man ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pɛ gue'a ga än'nahe. Bim 'bʉ'i yoto yʉn 'yohʉ din 'yohʉ zɛhɛ. Nu'a ra mbʉdi n'yohʉ bi zin'a n'da ra xisu, nɛ m'bɛjua bʉya bi du a ran 'yohʉ nɛ him bim 'bʉh rá t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nɛ nu'bʉ mi du ran 'yohʉ bʉya, ná yoho rán 'yohʉ bi zin'a ra xisu mahøn'a, nɛ xø bi du a. ");
INSERT INTO otmNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nɛ xø bi zin'a man'da rán 'yohʉ bʉya, 'da'ingu bi 'yøt'ʉ gätho yoto yʉn 'yohʉ, gätho bi du nɛ xínga n'da bim 'bʉh yʉ́ t'ʉhni. ");
INSERT INTO otmNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mbɛjua bʉya, bi dusɛ ra xisu, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nuya, dami xije 'bɛ'a din ja a ra pa da ndants'ʉ xʉn du. To'o da 'yɛ̨mbi rá xisu a ra xisu, nguetho gätho yoto bim 'bʉhmbʉ ra xisu ua ja ra häi, bi 'yɛ̨n'ʉ yʉ saduceo. ");
INSERT INTO otmNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nɛ nu'a ra Jesús bi dąti: ―Hønt'ua ja ra häi din thąt'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nɛ gätho to'o yʉ́n sähʉ da mba bʉ mahɛ̨ts'i 'bʉ bi ndants'ʉ xʉn du, nɛ him man ja ran thąti bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nguetho da gohi tengu tho yʉ́m 'bɛhni Oją ʉ, nɛ him man da du bʉ. Nɛ ma'da'yo da gohi 'bʉ bi xoxa Oją ʉ ngue yʉ́ t' ʉhnisɛ Oją ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pɛ nɛ'a ra Moisés bi ma da ndants'ʉ xʉn du 'bʉ mi 'yo't'i 'bɛ'a bin ja, nu'bʉ mi nu mí zø ra za 'bʉ maya'bʉ. Nɛ i mam bʉ ngue nu Oją rá Oją ra Abraham nɛ ra Isaac nɛ ra Jacob, nɛ nu'ʉ, ná ya'a thoho xí du ʉ 'bʉ mi 'yɛ̨mp'a Oją ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ngubʉ bi ma nguetho guexta'a i 'bʉh yʉ́ mbʉi. Nubʉ na nu Oją 'da'ingutho 'bʉ i 'bʉ'a n'da ogue xʉn du n'da. Guexta'a i jatho yʉ́ te ʉ xʉn du, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nɛ nu'ʉ 'da yʉ xänbate niją, bi 'yɛ̨mp'a ra Jesús: ―Ɛ̨mmɛ xʉn ho a gá ma, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nɛ nu'ʉ yʉ saduceo ya him mi sä da 'yän mi'da yʉn t'änni. ");
INSERT INTO otmNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nɛ nubʉya, bi 'yɛ̨n'a ra Jesús: ―Hague nán zä guí ɛ̨mfʉ ra Cristo rám bom'bɛto ra David a. ");
INSERT INTO otmNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nguetho bi mansɛ ra David bʉ ja ra søcuą bi 'yo't'a: Nu'a Oją bi 'yɛ̨mp'a ma Hmu: “Hyucua ga conhui ma ts'ɛdi, ");
INSERT INTO otmNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","gue'bʉ go dá tąpä gätho ʉ nin sʉihʉ,” i ɛ̨n Oją, bi 'yɛ̨n'a ra David 'bʉ mi ma nangue ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hanja i ɛ̨mbi rá Hmu, nɛ rám bom'bɛto a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nu'a ra Jesús bʉya, ní jat'a nyąhʉ yʉ́ xädi, gätho mi 'bäpʉ mi øde 'bɛ'a bi man ra Jesús. Bi 'yɛ̨mp' ʉ bʉya: ");
INSERT INTO otmNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―O guí ʉrpahʉ masu 'bɛ'a da man'ʉ yʉ xänbate niją, nguetho i he yʉ́ mbapahni xʉm hmadi ngue da t'ɛ̨spi, nɛ ɛ̨mmɛ di ho da mba ma zɛngua ngue da 'yɛ̨spa yʉ ją'i. Nɛ ɛ̨mmɛ i honi da hyupʉ ja yʉn thuts'i xʉn ho bʉ ja yʉ niją, nɛpʉ ja yʉn sihmɛ. ");
INSERT INTO otmNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nɛ i siyabi 'bɛ'a i pɛ'ts' yʉ xisu xʉn du yʉ́n ndø, nɛ i tunba yʉ́ ngu, nɛ ní jat'i nya'a thoho i yąhʉ Oją bʉ ja yʉ niją. Pɛ nu'ʉ, man'da xʉn ʉtho ran ʉnbi da nu, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nu'a ra Jesús mi 'bäpʉ ja ra dąniją nɛ bi nu yʉ mɛmbɛti i cät yʉ́ mbɛti bʉ ja ra huada, ngue rán t'unni Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nɛ bi nu n'da zʉ hyoya xisu bi gärpʉ yoho yʉ t'ʉc'axt'i. ");
INSERT INTO otmNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nu ra Jesús bi 'yɛ̨mp'ʉ mi 'bäpʉ bʉya: ―Majuąni dí xi ahʉ, nuna ra hyoya xisu man'da di muui bi uni xinda gue'ʉ gätho mi'da. ");
INSERT INTO otmNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nguetho gätho yʉ mɛmbɛti 'bʉ ya bi gät'a n'da ra mbɛti ja ra huada, pɛ ya mbongui thoho yʉ́ mbɛti, pɛ nu'a zʉ hyoya xisu, bi uni gätho mi ja, xíngui ts'ʉ bi bongui 'bɛ'a da hyonsɛ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nu'a ra Jesús mi ø'a man yʉ ją'i: “Mahotho ra dąniją, nɛ mahotho yʉn t'unni i zʉpʉ.” Pɛ ra Jesús bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Nuna gätho guín nuhʉ ya, da zøn ra pa hin te din ja ua, xíngui ts'ʉ da bonga n'da zʉ xɛqui ngue hin da yøt'e, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nɛ nu'ʉ 'da yʉ ją'i mi ø'a bi man ra Jesús, nɛ bi 'yänni: ―Gra xänbate i, nda'a ní pa din ja a guím ma, 'bɛ'a ní hmɛpya din ja sä ga pąhmbe. ");
INSERT INTO otmNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Dami jamansu 'bɛ'a guí ɛ̨c'yɛihʉ. Nguetho da zøn ra pa ba ɛ̨h yʉ hyäte da hyä ahʉ: “Nugä drá Cristogä,” da 'yɛ̨n'ahʉ. Nɛ da 'yɛ̨n'ʉ: “Ya bi zøn ra pa ran zɛgui,” da 'yɛ̨n'ʉ. Pɛ o guí ɛ̨c'yɛihʉ 'bɛ'a da man'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ga xi ahʉ 'bɛ'a gätho din ja ua ja ra häi gue'bʉ go ba ɛ̨cä mahøn'a. O guí suhʉ 'bɛ'a gui 'yøhmbʉ, nguetho din ja yʉ dąsʉi, nɛ yʉ ją'i hinga 'da'angu da bɛ̨ni. Pɛ hinga gue'bʉ ran zɛgui din ja ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nɛ xø bi 'yɛ̨na: ―Nɛ 'da'a n'danni yʉ häi din ja yʉ sʉi. Nɛ din sʉsɛ n'da ngu n'da yʉ ts'ʉt'abi. ");
INSERT INTO otmNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nɛ din ja yʉ 'yąmhäi nts'utho, nɛ din ja ra dąthu, nɛ ra dągɛ̨hɛ, nɛ din ja yʉ hmɛpya nts'utho bʉ mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pɛ hin nín ja a dím mangä 'bʉ bim fɛnt'ahʉ nɛ da mba ma ʉn'ni ahʉ. Nɛ da ts'ix ahʉ bʉ ja yʉ niją, di ʉn'nahʉ bʉ. Nɛ da mba ma dä ahʉ bʉ 'bʉh yʉ ts'ʉt'abi nɛpʉ 'bʉ'ʉ ja yʉ́ ts'ɛdi. Gätho ngubʉ da t'øt'ahʉ ngue guí tɛngahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pɛ nu'bʉ da ts'ix ahʉ bʉ, da zä gui mamhbʉ bʉ ran ho ma'da'yo. ");
INSERT INTO otmNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nɛ 'yo gadín 'yomfɛ̨nihʉ 'bɛ'a gui mamhbʉ 'bʉ bi mba ma juąn'ni ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nguetho nugä, ga bɛ̨n'nahʉ 'bɛ'a da zä gui mamhbʉ ra ora gam 'bähmbʉ bʉ. Nɛ nu'a ga bɛ̨n'nahʉ, xínga n'da nin sʉihʉ da zä da dąti 'bɛ'a gui mamhbʉ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nɛ madague'bʉ, ni tahʉ ogue ni mbehʉ, ogue ni cuhʉ, ogue ni mɛnihʉ, ogue ni amigohʉ, pɛ guemhma di dä ahʉ bʉ 'bʉh yʉ ts'ʉt'abi. Nɛ 'da'ahʉ da tho ahʉ ngue guí ɛ̨c'yɛigahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nɛ gätho da ts'an ahʉ nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pɛ o guín suhʉ nguetho xínga n'da ni xtąhʉ dim 'bɛpʉ ja ni yąhʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pɛ nu'bʉ gui hyäthʉ yʉn ʉnbi, Oją di 'da ahʉ ra te maząi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nu'bʉ guin nuhʉ xí mbät ra hnini Jerusalén yʉ dofʉi, gui pąhmbʉ mi ts'ʉtho da guah ra hnini. ");
INSERT INTO otmNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nɛ nu'bʉ bin ja bʉ Njerusalén, gätho ʉ 'bʉpʉ ja ra xɛqui Judea xʉn ho 'bʉ da 'dagui da mba bʉ dąpo bʉ ja yʉ nyuni. Nɛ'ʉ i 'bʉpʉ ja ra hnini, xʉn ho 'bʉ da bøni, nɛ gätho i 'bʉpʉ dąpo hin da 'yɛ̨na da mba bʉ ja ra hnini. ");
INSERT INTO otmNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nguetho gue'a ra pa di un rán ʉnbi Oją ʉ, nɛ gätho din ja tengu tho i mam bʉ ja rá hman Oją din ja. ");
INSERT INTO otmNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nɛ nu'bʉ bin ja a, huɛ̨cate ʉ in hąt'ʉhni, nɛ'ʉ gätho ʉ 'bʉh yʉ́ 'uɛre. Nguetho ndumbʉitho rán ts'ɛmbi Oją din ja ua ja ra häi nɛ xʉn ngu yʉn ʉnbi da nu yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nɛ nu'ʉ 'da'ʉ dí mba ntho ra juai, nɛ nu'ʉ mi'da da ts'ixpʉ n'danni yʉ häi nɛ da gohi tengu'bʉ i ofädi. Gue'ʉ hing yʉ judío di ts'on na ra dąhnini nɛ di manda ua, gue'bʉ go da zøn ra pa da hyąnba yʉ́ ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nu Oją da 'yøt' yʉ hmɛpya bʉ ja ra hyadi, nɛpʉ ja ra ząna nɛpʉ ja yʉ sø. Nɛ yʉ ją'i 'bʉcua ja ra häi ɛ̨mmɛ din su'ʉ 'bʉ da 'yøde nts'ɛdi da 'yɛn ran dąhi yʉ deją. ");
INSERT INTO otmNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nɛ ɛ̨mmɛ da güent yʉ́ mbʉi nangue ra mbidi din ja. 'Nɛ da zu 'bʉ da bɛ̨ni 'bɛ'a din ja gätho ua ja ra ximhäi. Nɛ gätho 'bɛ'a bí ja bʉ mahɛ̨ts'i di 'yąni. ");
INSERT INTO otmNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nɛ nu'bʉ bin ja a dí xi ahʉ, 'bex gua ɛ̨cä, ngue dán ją'igä ua ja ra ximhäi, ba ɛ̨cä bʉ ja yʉ güi, ban 'yo'be ma ts'ɛdi xʉn ngu ngue dán nuįxtegä. ");
INSERT INTO otmNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nɛ nu'bʉ gán nuhʉ da mbʉdi din ja, dami hyuthʉ nząmbʉi nɛ gui ndøs'hʉ mahɛ̨ts'i, nguetho ba ɛ̨h ni pørpatehʉ da yąn ahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nɛ man'da bi man ra Jesús ngue bi man'a n'da ran t'uti, bi 'yɛ̨na: ―Gan 'yomfɛ̨nihʉ ts'ʉ 'bɛ'a di ja ra za ra higo nɛ'ʉ mi'da yʉ za. ");
INSERT INTO otmNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu'bʉ guín nuhʉ i pøx yʉ́ paxi yʉ za, guí pąhmbʉ 'bex ba ɛ̨h yʉ pa xʉm pa. ");
INSERT INTO otmNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngutho 'bʉ bi mbʉ'a dí xi ahʉ, gui pąhmbʉ mi ts'ʉtho di manda rá ts'ɛdi Oją ua bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Majuąni dí xi ahʉ, nu yʉ ją'i 'bʉcua ya, hinga gätho xtí du 'bʉ bi mbʉdi din ja a dí xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nu bʉ mahɛ̨ts'i nɛ ra ximhäi da guadi, pɛ nu'a mam hmangä hin da gua'a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Janangue dami jamansu 'bɛ'a guí øthʉ, o guín nde gui 'yøthʉ ni pähä zɛhɛhʉ, nɛ hinga hønt'a guim bɛ̨mhbʉ nin sihmɛhʉ. Dami jamansu a gui 'yøthʉ, hin ga tįn'nahʉ ngue gdí øthʉ a 'bʉ bá pengä. ");
INSERT INTO otmNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nguetho njon da bą'a ra ora ba ɛ̨cä, pɛ gätho yʉ ją'i 'bʉcua ja ra ximhäi da nu. ");
INSERT INTO otmNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dami tøm thohohʉ nɛ thocua thoho gan yąhʉ Oją, n'dahma din ja ni ts'ɛdihʉ gui hyäthʉ yʉn ʉnbi din ja. Nu'bʉ ngubʉ gui 'yøthʉ, hin gui pɛs' ni sähʉ 'bʉ gá 'bähmbʉ bʉ ja ma hmigä, nugä ngue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús 'bʉ mi xih yʉ́ xädi 'bɛ'a gätho din ja. ");
INSERT INTO otmNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nɛ nu'a ra Jesús 'bʉ mi 'bʉpʉ Jerusalén, gätho yʉ pa mi xänba ʉ yʉ ją'i bʉ ja ra dąniją. Pɛ nu'bʉ ra xui bʉya, mi pa bʉ ja ra nyuni Olivos. ");
INSERT INTO otmNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nɛ gätho yʉ xudi mi pa bʉ yʉ ją'i bʉ ja ra dąniją, da 'yø'a i man ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nuya mi ts'ʉtho da zøn ra pa da ts'i ra hmɛ hin'yʉ rá íxi. Gue'ʉ yʉ pa ra dąmpɛti ran dąbaxjua. ");
INSERT INTO otmNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nu'ʉ yʉ ngʉrpa mbäją nɛ yʉ xänbate niją, mi honi 'bɛ'a dí hyo ra Jesús. Pɛ mi su'ʉ 'bɛ'a da 'yøt' yʉ ją'i 'bʉ da hyo'a. ");
INSERT INTO otmNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nɛ nu'a ra zįthu bi yʉt' rá mbʉi ra Judas Iscariote, gue'a n'da rá xädi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nu'a ra Judas bi mba, bin yąhʉ yʉ ngʉrpa mbäją nɛ yʉ hmu dofʉi, nɛ bi xifi 'bɛ'a da 'yøt 'bʉ di dä'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nu'ʉ bi hyu yʉ́ mbʉi 'bʉ mi man'a ra Judas 'bɛ'a da 'yøt'e. Nɛ bi xifi da gut rán zäbi ra Judas. ");
INSERT INTO otmNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nɛ nu ra Judas bʉya, bi dø'ma ra ora 'bʉ njongui 'bʉpʉ yʉ ją'i ngue di dä'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nɛ mi søn ra pa bin ja ra dąnts'ihmɛ i ts'i ra hmɛ hin'yʉ rá íxi, nɛ i ho ra t'ʉdɛ'yo. ");
INSERT INTO otmNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nɛ nu'a ra Jesús bi mbɛn'na ra Pedro nɛ ra Xuua nɛ bi xifi di hoc ran sihmɛ ran dąbaxjua, da zi 'bʉ bin de. ");
INSERT INTO otmNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nu ra Pedro nɛ ra Xuua bʉya: ―Hapʉ guín nde ga hoc'be, ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'bʉ gán 'youi bʉ ja ra ndenhnini nɛ gui nuui n'da ran 'yohʉ i tu n'da ra xaro ra dehe, dami tɛndui a ran 'yohʉ, nɛ gui cʉt'ui bʉ ja ra ngu da yʉt'a. ");
INSERT INTO otmNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nɛ gui xihmi a ra mɛngu bʉ: “Nu'a ra xänbate bá pɛnga'be ngue gui xic'be hapʉ i ja ra cuarto ngue ga sägähe ra dąnsihmɛ,” gui 'yɛ̨nui. ");
INSERT INTO otmNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nɛ nu'a ran 'yohʉ da zix aui bʉ magąts'i hapʉ i ja ra cuarto xʉn ndoho. Guepʉ gui hocui rán sihmɛ ran dąbaxjua, bi 'yɛ̨mp'ʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nu ra Pedro nɛ ra Xuua bʉya bi mba bi dįni tengutho bi man'a ra Jesús. Nɛ bi hocpʉ ran sihmɛ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nu'bʉ mi zøn ra ora bʉya, nu'a ra Jesús nɛ mi'da yʉ́ xädi bi zøm bʉ nɛ bin sihmɛhʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nu ra Jesús bi 'yɛ̨mp'ʉ yʉ́ xädi: ―Ɛ̨mmɛ dán ndegä ga sihʉ na ran sihmɛ ran dąbaxjua 'bʉ di 'bɛdi ga tugä. ");
INSERT INTO otmNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nɛ dí xi ahʉ, him man'dandį ga sigä na ran sihmɛ jague'bʉ bi zøn ra pa ngue gán yąmhbʉ xʉn ho 'bʉ gám 'bʉhmbʉ bʉ di manda rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nu ra Jesús bʉya bi dɛca n'da baso ra vino nɛ bi un ra jamadi Oją, nɛ bi 'yɛ̨mp'ʉ yʉ́ xädi bʉya: ―Dami comhbʉ na po na ra baso, gui sihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nguetho dí xi ahʉ, hin ga sigä mahøn'a asta gue'bʉ go da zøn ra pa di manda ua rá ts'ɛdi Oją xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nɛ nubʉya, bi hyąc ra hmɛ nɛ nu'bʉ mi gua'a bi un ra jamadi Oją bʉya, bi xɛni nɛ bi darpa ʉ yʉ́ xädi, bi 'yɛ̨na: ―Nuna ra hmɛ na, ma ngøc'yɛigä na, ga ungä nangue ahʉ. Nɛ n'dandį ngu n'dandį 'bʉ guí sihʉ, guim bɛ̨njʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nɛ nu'bʉ mi guadi bin sihmɛ ʉ, nu ra Jesús bi dɛc'a ra baso ra vino nɛ bi un'dʉ yʉ́ xädi nɛ bi 'yɛ̨mp'ʉ: ―Nuna, ran hoqui ma'da'yo, guehna nam bøni ma jigä ngue bi hoc'a ra 'da'yo'yu bi 'yøt'ahʉ Oją na, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pɛ dí huhmbʉ ua n'da di dägä. ");
INSERT INTO otmNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nɛ nugä, ngue dán ją'igä ua ja ra ximhäi, da thogä, ngue gue'a bi zänd Oją, pɛ í huɛ̨hi maha a di dägä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nu yʉ́ xädi, 'bex bin 'yänzɛhɛ to'o di dä'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nɛ man'da ran junt'i bi 'yøt'ʉ yʉ́ xädi ngue to'o dim 'bɛt'o nanguesɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nuua ja ra häi, nu yʉ ts'ʉt'abi nɛ'ʉ i ja yʉ́ ts'ɛdi, xʉn hɛ̨i i ørpa yʉ ją'i 'bʉ di manda ʉ, i øt'e yʉ́ 'yɛ̨hɛ ʉ, nɛ i t'ɛ̨mbi xʉn ho a i øt'e. ");
INSERT INTO otmNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pɛ nu ahʉ, hin gan jahʉ bʉ. Nu'a to'o dim 'bɛt'o, da 'yøt'e dim 'bɛjua thoho. Nɛ nu'a to'o din ngʉrpi, da 'yøt'e din 'yɛ̨hɛ thoho a. ");
INSERT INTO otmNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nu yʉ hmu 'bʉcua ja ra häi, hin dim pɛ'ʉ, pɛ gue i tø'mi da mbɛp'ʉ yʉ́ 'yɛ̨hɛ, pɛ nugä madague dím hmugä, pɛ dí øt'ä ngue ni 'yɛ̨hɛgahʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nɛ man'da bi xifi, bi 'yɛ̨na: ―Pɛ nu'ahʉ, dán hyʉmhbʉ 'bʉ má nugä yʉn ʉnbi ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Janangue ga 'da'a nin t'ɛ̨dihʉ, tengutho bi 'dacä ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nɛ nu'bʉ bi zøn ra pa ga øt' ran ts'ʉt'abi, 'darpʉ dan johyahʉ, nɛ gui comhbʉ ma ts'ɛdi gui juąnbahʉ ma mi'israelhʉ, dyʉ́ judíohʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nɛ bi t'ɛ̨mp'a ra Pedro: ―Ma zʉ Pedro, nu'a ra zįthu bi 'yäh ran t'ɛ̨di ngue da zä'a ni mbʉihʉ, in nde ahʉ gan 'uɛ̨xthʉ tengu'bʉ i 'uɛ̨xt ran dąhi yʉ́ häi ra trigo. ");
INSERT INTO otmNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pɛ nugä, ya dá äp ma Ta him má zä gui pumbɛ̨ni ni t'ɛ̨c'yɛihʉ. Nɛ nu'bʉ gán 'yomfɛ̨ni ts'ʉ, gui 'yɛ̨c'yɛi xʉn ho mahøn'a, nɛ gui zɛrpa yʉ́ mbʉi ni mi'yɛ̨c'yɛihʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nɛ nu'a ra Pedro bi dąh pʉya: ―Nugä, ga tɛn'na i madague dan ofädiui ogue ga tuui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bi dą'a ra Jesús bʉya: ―Gra Pedro, dí xi'i, nu'bʉ hin ní mbah ra øni, ná hyundį xquí cøngui, bi t'ɛ̨mp'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Xø bi 'yɛ̨mp'ʉ yʉ́ xädi bʉya: ―Nu'bʉ ra mbʉdi dá pɛn'nahʉ bʉ gá mamhbʉ ran ho ma'da'yo, nɛ hin te gá hyąxhʉ. 'Bɛ'a gá 'yøthʉ, ha bin ja 'bɛ'a gätho gá hyomhbʉ, uague hin'na. Nɛ gätho yʉ́ xädi bi 'yɛ̨na: ―Hin te dá 'bɛhmbe. ");
INSERT INTO otmNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pɛ nuya n'dan'yo gui 'yøthʉ, gui tux ni buxahʉ, nɛ gui hyąx ni mbɛtihʉ. Nɛ nu'bʉ hin'yʉ ni espadahʉ, gui pä ni pahnihʉ gui tämhbʉ n'da. ");
INSERT INTO otmNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nguetho i jatho din jagä tengu i mam bʉ ja rá hman Oją, i ɛ̨m bʉ: “Yʉ ją'i da 'yɛ̨mbi ra ts'om'bäi a,” i ɛ̨m bʉ ja rám hman Oją nanguecä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nɛ nu'ʉ yʉ́ xädi bi 'yɛ̨mbi: ―Gra Hmu, i jaje yoho yʉ espada, bi 'yɛ̨n'ʉ. ―Dí gua'ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nu'a ra Jesús bʉya, bi bøm bʉ ja ra cuarto mi sihmɛ ʉ, bi mba bʉ ra nyuni Olivos, bi mbähä yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nɛ nu'bʉ mi zøm bʉ, nu ra Jesús bi 'yɛ̨mp'ʉ: ―Dami 'yäfʉ rá ts'ɛdi Oją gue da zä gui hyäthʉ yʉ́n ts'äte ra zįthu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nɛ nu'a ra Jesús bi 'ue'i ts'ʉ bʉ mí 'bäh yʉ́ xädi, nɛ bin dąnyahmu, bin yąui Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nɛ bi 'yɛ̨na: ―Ma Ta'i, nu'bʉ ni pähä, dami japi ngue hin ga sigä a ra mbohi gá sänni ga sigä, pɛ hin dín nde ma pähäzɛhɛ pɛ go ni pähä dín nde ga øt'ä, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","'Bex bi nɛqui bʉ n'da rám 'bɛhni Oją mahɛ̨ts'i ngue bá hąnba a í zɛrpa rá mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pɛ nu'a ra Jesús ɛ̨mmɛ bi du rá mbʉi, nɛ man'da nts'ɛdi bin yąui Oją. Xøgue ra ji a rá xänthe mi täpʉ häi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nɛ bi ndants'a ra Jesús bʉya, bi mba bʉ 'bʉh yʉ́ xädi. Pɛ nu'ʉ, gätho min ąha nguetho bi güent yʉ́ ją'i ʉ nangue ra dumbʉi mim bɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Hanja gnán ąhmbʉ. Dami nuhmbʉ, gan yąhʉ Oją janangue'a da zä gui tąhmbʉ rán ts'äte ra zįthu, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nɛ nu'bʉ min yąhʉ yʉ́ xädi, 'bex bá ɛ̨pʉ n'da nɛts'i yʉ ją'i, nɛ bá 'bɛt'o ra Judas, gue'a n'da rá xädi ra Jesús. Nɛ nu'a bi zøm bʉ 'bʉh ra Jesús nɛ bi zʉspa rá 'yogu 'bʉ mi zɛngua. ");
INSERT INTO otmNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pɛ nu'a ra Jesús bi 'yɛ̨mbi: ―Grá Judas, ha ran ts'ʉ'ts'i guí dägui, nugä ngue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nɛ nu'ʉ mi'da yʉ́ xädi 'bʉ mi nu 'bɛ'a bin ja, bi 'yän'na ra Jesús: ―Ha ga japähe ma espadahe, ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pɛ him bi dø'mi 'bɛ'a da si'a n'da ʉ, 'bex bi zɛcua rán 'yɛizagu rá 'yɛ̨hɛ ra ngʉrpa mbäją. ");
INSERT INTO otmNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pɛ nu'a ra Jesús 'bex bi hɛcua yʉ́ xädi: ―O guí øthʉ a, bi 'yɛ̨mbi. Nɛ 'bex bi hocua mahøn'a a rá zagu a ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nɛ nu'a ra Jesús 'bex bin yąhʉ yʉ ją'i ngue bá ɛ̨hɛ da zits'i. Min 'yohʉ yʉ ngʉrpa mbäją nɛ yʉ ngʉrpa mbädi bʉ ja ra dąniją, nɛ mi'da yʉ́ ngʉrpi yʉ judío. Nɛ bi 'yɛ̨mbi: ―Ha drá bɛ̨gä ngue guá hąhʉ ni espadahʉ nɛ ni zahʉ ngue gui sixcahʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hanja hin gá bɛntcahʉ bʉ ja ra dąniją, nɛ ząnt'a min xänbategä bʉ. Pɛ nuya bi zøn ra ora din ja a bi zänd Oją nɛ n'da ora thoho gui tąjʉ, nɛ'a ra dąmants'o n'da ora thoho da dąqui, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'Bex bi fɛnt'a ra Jesús nɛ bi ts'ixpʉ ja rá ngu ra hmumbäją. Nɛ nu'a ra Pedro bi dɛnni a na 'bɛjua thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nɛ mi zø bʉ n'da ra sibi bʉ mbo rá mbä't'i rá ngu ra hmumbäją. Nɛ nu ra Pedro madin tąspihʉ bʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nɛ mi 'bäpʉ n'da ra hmute ngue ra 'yɛ̨hɛ bʉ. Nɛ nu'bʉ mi nu'a ra Pedro, bi 'yɛ̨na: ―Nuna ran 'yohʉ hucua, min 'yohʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pɛ nu'a ra Pedro bin cøni, nɛ bi 'yɛ̨na: ―Nu'i grá xisu, xøgue hin dí pącä to'o a guí ma, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nu'bʉ mi tho n'da zʉ t'ʉ ora, n'da ran 'yohʉ bi nu'a ra Pedro nɛ bi 'yɛ̨mbi mahøn'a: ―Nu'i grán 'yohʉ, gue'e gmin 'yohʉ ra Jesús. Pɛ nu'a ra Pedro bin cøni: ―Hinga guecä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nɛ nu'bʉ mi thoh man'da ora, xø man'da ran 'yohʉ bi 'yɛ̨mbi: ―Nugä, dí pącä na ran 'yohʉ. Guehna n'da rá xädi ra Jesús. Nɛhna ra mɛngu Galilea na, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pɛ nu'a ra Pedro bi dąti: ―Nu'i grán 'yohʉ, hin dí pącä 'bɛ'a guím ma, bi 'yɛ̨na. Nɛ 'bex bi mbah ra øni bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nu'a ra Jesús 'bex bin yɛ̨gui nɛ bi hyant'a ra Pedro. 'Bex bi bɛ̨n'a ra Pedro xí xi'a rá Hmu, ngue bi 'yɛ̨mbi: “Dí pącä nu'bʉ hin ná mbah ra øni, hyundį xquí cøngui,” ngue xí 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nɛ nu'a ra Pedro bʉya, bi mba bʉ thi nɛ bin zoni, bi bɛ̨nman'ʉ 'bɛ'a bi 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nɛ nu'ʉ yʉn 'yohʉ mi fä'a ra Jesús, bin ʉspate tho'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nɛ bi gorpa rá dä ra Jesús, nɛ bi mbɛmp' pʉya, nɛ bi 'yɛ̨mp'a ra Jesús: ―Grá pøngahyą, xije to'o bi mbɛp'a'i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nɛ ɛ̨mmɛ xʉn ngu ran ts'o bi xi'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nɛ nu'bʉ mi hyax pʉya, bim pɛti bʉ yʉ dąc'yɛi, nɛ yʉ ngʉrpa mbäją, nɛ yʉ xänbate niją. Nɛ nu'ʉ bi zixpʉ madím pɛti gätho yʉ́ ngʉrpi yʉ judío, ngue di juąnba ra Jesús. Nɛ bi 'yɛ̨mp'a: ");
INSERT INTO otmNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Dami xije ya, ha majuąni gue'e grá Cristo, rá Thahni i Oją. Nɛ nu'a ra Jesús bi dąti: ―Madague'a ga xi ahʉ, hin gui 'yɛ̨c'yɛigahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nɛ ngutho'bʉ ga än'nahʉ n'da ran t'änni, hin gui thąhmbʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pɛ nuya, bi zøn ra ora ga com'be rá ts'ɛdi Oją nuįxte thoho, nugä ngue dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nɛ nu'ʉ mi hupʉ bi 'yänni: ―Ha gue'e rá Ts'ʉnt'ʉ e Oją 'bʉ. Nɛ nu'a ra Jesús bi dąti: ―Gue'a guí mamhbʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pɛ nu'ʉ bʉya, 'bex bi 'yɛ̨n'ʉ: ―Hingui jatho ga homhbʉ mi'da yʉ testigo, nguetho ya bin juąnzɛhɛ, nɛ dá øhmbʉ a bi ma, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Janangue'a bi ndants'ʉ, bi zix'a ra Jesús bʉ 'bʉh ra ts'ʉt'abi Pilato. ");
INSERT INTO otmNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nɛ gätho ʉ bi yąp'a ra Jesús. Nɛ bi 'yɛ̨mp'a ra Pilato: ―Nuna ran 'yohʉ i 'bäcua, ɛ̨mmɛ i hät yʉ ją'i, nɛ bi xih yʉ ją'i ngue hin din jut yʉ renta im man ra ts'ʉt'abi Roma, nɛ bi mansɛ ngue guesɛ ra Cristo, ra hmuts'ʉt'abi na, bi 'yɛ̨n'ʉ madí yąp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nɛ nu'a ra Pilato bʉya, bi 'yän'na ra Jesús: ―Ha majuąni gue'e rá hmuts'ʉt'abi yʉ judío. Ra Jesús bi dąti: ―Gue'a gá ma, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nu ra Pilato bʉya bi 'yɛ̨mb yʉ ngʉrpa mbäją nɛ yʉ ją'i mi 'bäpʉ: ―Xínga n'da ra ts'oqui dá tįnbä na ran 'yohʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pɛ ɛ̨mmɛ man'da nts'ɛdi bi man'ʉ yʉ yąpate: ―Nuna ran 'yohʉ bi dʉ'ma n'da ran heque nangue 'bɛ'a bi xänba yʉ ją'i. Gue'a bi 'yørpʉ ja ra häi Galilea, nɛpʉ ra xɛqui Judea, nɛ nuya bi zøcua ja ra hnini Jerusalén, ngue da 'yøt'ua, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nu'bʉ mi 'yøde 'bɛ'a bi man yʉ ją'i, nu ra Pilato bi 'yänni: ―Ha ra mɛngu bʉ Galilea na ran 'yohʉ 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nɛ nu'bʉ mi bądi gue ra mɛngu bʉ Galilea a ra Jesús, bi manda da ts'ixpʉ 'bʉh ra Herodes. Nguetho ra Herodes ra ts'ʉt'abi bʉ ja ra häi Galilea, nɛ gue'a ra pa i 'bʉpʉ ja ra dąhnini Jerusalén a. ");
INSERT INTO otmNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nɛ nu'a ra Herodes, 'bʉ mi nu'a ra Jesús, bin johya, nguetho mi øde 'bɛ'a gätho mi øt' ra Jesús, nɛ in nde da nu n'da ran t'øt'e nuįxte. ");
INSERT INTO otmNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nɛ nu'a ra Herodes, xʉn ngu bi 'yän yʉn t'änni, pɛ nu'a ra Jesús him bi 'yʉrpatho ra güɛnda, xíngui ts'ʉ bi dądi. ");
INSERT INTO otmNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nɛ hinga yatho mi 'bäh yʉ ngʉrpa mbäją, nɛ yʉ xänbate niją, nɛ ɛ̨mmɛ ts'ɛdi bi mbafi, di yąp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pɛ nu'a ra Herodes nɛ yʉ́ dofʉi, ɛ̨mmɛ bi denthoho a ra Jesús, nɛ xíngui ts'ʉ bi numansu'a. Nɛ nu'ʉ yʉ dofʉi bi het'a ra pahni tengu yʉ́ pahni yʉ hmuts'ʉt'abi, nɛ bi mbɛnh mahøn'a bʉ 'bʉh ra Pilato. ");
INSERT INTO otmNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nɛ madín sʉhmi a ra Herodes a ra Pilato, pɛ nu ra pa a, bin amigoui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nɛ nu'a ra Pilato bi zon'dʉ yʉ ngʉrpa mbäją nɛ'ʉ mi'da yʉ́ ngʉrpi yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nɛ bi 'yɛ̨mbi: ―Guá sihʉ na ran 'yohʉ 'bäcua, nɛ gá xijʉ ra hyäte na. Pɛ xʉn ngu yʉn t'änni xtá ändä nɛ xínga n'da ra ts'oqui dá tįnbä na, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nɛ xínga gue'a ra Herodes bi ma xtán dįnba n'da rá ts'oqui, nɛ bá pɛntho ua mahøn'a. Nɛ hin'yʉ 'bɛ'a bi 'yøt'na ran 'yohʉ gue dí nu ran dąte. ");
INSERT INTO otmNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nuya, ga manda da 'bɛi nɛ nubʉya ga thøtho, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nguetho nu ra Pilato nząi di thø'a n'da ra ofädi 'bʉ i ja ram pɛti ran dąbaxjua. ");
INSERT INTO otmNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pɛ nu yʉ ją'i ɛ̨mmɛ bi mbafi nɛ n'dat'a bi man ʉ: ―Dami hyo na ran 'yohʉ, nɛ go gui thø'a ra Barrabás, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nɛ nu'a ra Barrabás, ra hyodu a, nɛ mi ofädi nguetho bi parpa yʉ ją'i din sʉhmbʉ ra ts'ʉt'abi. ");
INSERT INTO otmNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pɛ nu'a ra Pilato, ɛ̨mmɛ min nde di thø'a ra Jesús, nɛ bi zäpi din yąhʉ yʉ ją'i mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pɛ nu'ʉ yʉ ją'i ɛ̨mmɛ i mbafi. Nɛ bi 'yɛ̨n'ʉ: ―Cuarpʉ ja ra pont'i, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nɛ ná hyundį bʉya, bi 'yän'na ra Pilato: ―'Bɛ'a ní ts'oqui bi 'yøt'na ra Jesús, xínga n'da ra ts'oqui xtá tįnbä ngue dí nu ran dąte, pɛ 'bɛ da gua'a m'bɛi ga xocä bʉya, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pɛ man'da nts'ɛdi bi mbah yʉ ją'i, nɛ n'dat'a bi ma ngue di cuarpʉ ja ra pont'i ra Jesús. Nɛ bi dąha 'bɛ'a min nde bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nguetho nu'a ra Pilato bi manda da t'øt'a 'bɛ'a go i nde yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Go bi thø'a ra Barrabás, ngue bi man yʉ ją'i, madague'a ín ofädi a nam parpate nɛ nɛ'a ín hodu. Pɛ nu'a ra Jesús, go bi däp'ʉ yʉ ją'i da 'yørpe tengu mim bɛ̨ni da 'yørpe. ");
INSERT INTO otmNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nɛ nubʉya, bi ts'ixa ra Jesús bʉ ndehnini. Nɛ bin c'athʉ n'da ran 'yohʉ, í Simón, ra mɛngu bʉ ra hnini Cirene, ngue ní mba bʉ ja ra hnini Jerusalén. Nɛ bi fɛnt'i nɛ bin japi da duspa rá pont'i ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nɛ n'dan nɛts'i yʉ ją'i bi dɛn'na ra Jesús. Nɛ nu'ʉ 'da yʉ xisu zom bʉ ní mba, i tu yʉ́ mbʉi 'bɛ'a da t'ørpa ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pɛ nu'a ra Jesús bi hyɛ̨t'ʉ nɛ bi 'yɛ̨mp'ʉ: ―Gyʉ́ zʉ xisuhʉ, ngue gyʉ́ mɛnguhʉ Jerusalén, o guí zomhbʉ ngue ga tugä, pɛ man'da go gui zomhbʉ nangue 'bɛ'a gui nusɛhʉ, gyʉ mɛnguhʉ Jerusalén, nɛ ni t'ʉhnihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nguetho da zøn ra pa xʉn ʉ tho ran ʉnbi guin nuhʉ. Nɛ him man gui samhbʉ ʉ yʉ xisu him bi dįn yʉ́ t'ʉhni, pɛgue guim bɛ̨mhbʉ mająpi ʉ, nguetho ya njo'o yʉ́ t'ʉhni da nu'a ran ʉnbi xʉn ʉ tho tengu da nu ni t'ʉhnihʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nɛ da 'yɛ̨n'i 'da: “Man'da xʉn ho 'bʉ xtan yøt' yʉ t'øhø nɛ yʉ nyuni xtan gogbahʉ, xinda gue'bʉ ga thoqui ga nuhʉ ran ʉnbi xʉn ʉ tho,” da 'yɛ̨n i 'da. ");
INSERT INTO otmNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nɛ gui pąhmbʉ, nu'bʉ xʉn ʉ tho ran ʉnbi bi t'ørpa n'da ngue hin'yʉ rá ts'oqui, man'da xʉn ʉ tho da t'ørpa ʉ ja yʉ́ ts'oqui, bi 'yɛ̨n'a ra Jesús 'bʉ mi xih yʉ xisu i zoni. ");
INSERT INTO otmNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nɛ'ʉ yoho yʉn 'yohʉ bi ts'its'i ngue 'darpʉ da thohʉ a ra Jesús. Pɛ gätho ʉ yoho mi ja yʉ́ ts'oqui ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nɛ gätho bi zøm bʉ ja n'da ra nyuni t'ɛ̨mbi ra yąxmu. Guepʉ bi mba ma cuati bʉ ra Jesús nɛ'ʉ yoho yʉn 'yohʉ. N'da a n'da bi guarpʉ ja yʉ pont'i. ");
INSERT INTO otmNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɛ nu'a ra Jesús bi 'yɛ̨na: ―Ma Ta'i, dami punba a i ørcä ya yʉ ją'i, nguetho hingui pądi 'bɛ'a i øt'e, bi 'yɛ̨n'a ra Jesús. Nɛ nu'ʉ yʉ dofʉi bi 'yøt'a n'da ran tąha to'o da gąxa rá pahni ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nɛ mi hand thoho yʉ ją'i. Nɛ nu yʉ́ ngʉrpi, ɛ̨mmɛ bi den thoho nɛ bi 'yɛ̨na: ―Nunʉ ran 'yohʉ bi pø'i 'da, i sä dim pøsɛ ya gue'bʉ gue'a ra Cristo rá Thahni Oją nʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nɛ'ʉ yʉ dofʉi ɛ̨mmɛ bi denthoho nɛ di säti di un'na ra vino xʉn ju, ɛ̨mbi da zi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nɛ bi 'yɛ̨mbi: ―Nu'bʉ gue'e rá Hmuts'ʉt'abi yʉ judío, damim pøsɛ 'bʉ, bi 'yɛ̨n'ʉ yʉ dofʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nɛ mán t'o't'i n'da ra xithɛ bʉ ja ra pont'i bʉ ja rá yą ra Jesús. Nɛ nt'o't'i bʉ: “Nuna rá Hmuts'ʉt'abi yʉ judío na.” ");
INSERT INTO otmNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nɛ nu'a n'da ran 'yohʉ mi cuat rá pont'i mi 'bäpʉ nán ja rá hyo ra Jesús, bin sante thoho. Nɛ bi 'yɛ̨na: ―Nu'bʉ majuąni gue'e grá Cristo, hanja hin gám pøsɛ, nɛcä'be xquí pøc'be, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pɛ nu'a man'da ran 'yohʉ mi cuarpʉ bʉya, bi hɛcpa a bin sante nɛ bi 'yɛ̨mbi: ―Ha xíngui ts'ʉ guí su Oją, nɛ 'dat'a man ʉnbihʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pɛ nugüi, ran dąte rán säui a dá øt'ui. Pɛ nuna ra Jesús, xíngui ts'ʉ ran ts'o bi 'yøt'na, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pɛ nubʉya, bi 'yɛ̨mp'a ra Jesús: ―Dami bɛ̨nc 'bʉ bin ja ni ts'ɛdi ngue gui manda ua, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nu ra Jesús bi 'yɛ̨mbi: ―Majuąni dí xi'a'i, ga sømmi nám pa ya bʉ mahɛ̨ts'i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pɛ nu'bʉ huxyadi, bim 'bɛxui gätho ra ximhäi, asta gue'bʉ hyunde. ");
INSERT INTO otmNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nɛ nu'bʉ mim 'bɛxui, bin xɛngui nde ra 'bø't'e i ndam bʉ mbo ra dąniją. ");
INSERT INTO otmNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nɛ nu'a ra Jesús nts'ɛdi bi mbafi, nɛ bi 'yɛ̨na: ―Ma Ta i, dadí dä'a ma te ya, bi 'yɛ̨na. Nɛ 'bex bi du bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nɛ nu ra hmudofʉi mi 'bäpʉ, 'bʉ mi nu 'bɛ'a bin ja, bi 'yɛ̨spa Oją, nɛ bi 'yɛ̨nsɛ: ―Majuąni nunʉ ran 'yohʉ hin te mi ja ra ts'oqui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nɛ gätho na ngu yʉ ją'i 'bäpʉ ngue yʉ nute, 'bʉ mi nu 'bɛ'a bin ja, 'bex bi mba yʉ́ ngu, bi bɛ̨ndumbʉi nɛ bi hyonya thoho. ");
INSERT INTO otmNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pɛ nu'ʉ yʉ́ amigo ra Jesús n'danni ts'ʉ mi 'bäi. Nɛ'ʉ 'da yʉ xisu mi tɛn'na ra Jesús 'bʉ mambá nɛxpʉ ja ra häi Galilea, gätho bi nu 'bɛ'a bi t'ørpa ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nɛ mi 'bʉ'a n'da ran 'yohʉ, í José, ra mɛngu bʉ ra hnini Arimatea, n'da rá hnini yʉ judío bʉ ra xɛqui Judea. Nu'a, ra hoc'ją'i a, nɛ mi hnumansu. Nɛ mi tøm' ra pa di manda ua rá ts'ɛdi Oją. N'da rá ngʉrpi yʉ judío a, pɛ hinga 'da'ingu bi bɛ̨mhbʉ ʉ bi juąnba ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nɛ nu'a ra José bi mba bʉ bí 'bʉh ra Pilato nɛ bi 'yäp rá ngøc'yɛi ra Jesús ngue da 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nɛ bi tong bʉ ja ra pont'i a ra Jesús. Nɛ bi mbantpa rá ją'i ra Jesús n'da ra hoc'bø't'e xʉn ho, nɛ bi gärpʉ ja n'da ra hyądo xínga n'dandį bi 'yo n'da ra du. ");
INSERT INTO otmNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nɛ nu'bʉ mi 'yägui, gue'a ra pa din sä yʉ ją'i ngue da nu ra pa ran säya. ");
INSERT INTO otmNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nɛ nu'ʉ yʉ xisu, mi tɛn'na ra Jesús 'bʉ xí nɛxpʉ ja ra häi Galilea, bi dɛn'na ra José nɛ bi nu hapʉ bi jät'a ra Jesús, nɛ mi nu hapʉ án ja rá yą. ");
INSERT INTO otmNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nɛ nu yʉ xisu bi mba bʉya, di hoc ra 'yɛ̨thi i yʉman'u, nɛ ra aceite da gospa rá ją'i ra Jesús. Pɛ nu'bʉ mi mbʉ'a ra pa ran säya, bin säya tengu thoho bi mam bʉ ja yʉ́n t'ɛ̨di. ");
INSERT INTO otmNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nɛ t'ʉxuditho ra pa ndomingo, nu'ʉ yʉ xisu bi dux ra 'yɛ̨thi bi hoqui, nɛ bi mba bʉ ja ran 'yägui ngue ra hyądo guepʉ mi o ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nɛ nu'bʉ mi zøm bʉ, bi nu, ya xí mba njʉnni a ra do mi juaxpʉ ja ra hyądo. ");
INSERT INTO otmNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nɛ 'bex bi yʉrpʉ mbo, pɛ him bi dįm bʉ rá ją'i ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nɛ nu'bʉ mi 'bäpʉ nɛ din 'yomfɛ̨ni 'bɛ'a bin ja, 'bex bim 'bähmbʉ yoho yʉ́m 'bɛhni Oją, mi he yʉ́ pahni di fɛxni. ");
INSERT INTO otmNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nɛ nu'ʉ yʉ xisu, ɛ̨mmɛ bin su nɛ bi hyɛ̨'t'ʉ yʉn 'yohʉ. Nɛ bi 'yɛ̨mp'ʉ: ―Hanja gní hyomhbʉ ua n'da ran 'yohʉ i 'bʉi, guecua ja ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nu'a guí homhbʉ, bi ndants'a, njo'o ua a. Nde'bʉ guim bɛ̨mhbʉ a bi xi ahʉ 'bʉ gám 'bʉhmbʉ bʉ ja ra häi Galilea. ");
INSERT INTO otmNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ngue bi ma jatho da nu ran ʉnbi, nɛ da mba ma dä bʉ 'bʉh yʉ ts'om'bäi, nɛ da du bʉ ja ra pont'i, nɛ nu'bʉ ná hyu pa da dąmbɛ̨ni, bi 'yɛ̨n'ahʉ, bi 'yɛ̨n'ʉ yʉ́m 'bɛhni Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nɛ nu'ʉ yʉ xisu bi bɛ̨m bʉya 'bɛ'a xí man'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nɛ bi nɛxpʉ ja ran 'yägui, bi mba bʉ 'bʉ'ʉ 'dɛ'ma'da yʉ́ xädi ra Jesús nɛ'ʉ gätho mi'da, nɛ bi xi'ʉ 'bɛ'a bin ja bʉ ja ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nɛ nu'ʉ yʉ xisu, ra María Magdalena a n'da, nɛ ra Juana a man'da, nɛ ra María rá mbe ra Jacobo a man'da, nɛ'ʉ mi'da min 'yohʉ gue' ʉ bi xi'ʉ yʉ́ xädi a ra Jesús 'bɛ'a bi nu bʉ ja ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pɛ nu'ʉ yʉ́ xädi, him bi 'yɛ̨c'yɛi 'bɛ'a bi man yʉ xisu, nɛ bi 'yɛ̨mbi bi bɛ̨nsɛ 'bɛ'a bi man'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pɛ nu'a ra Pedro, bi mba n'dihi bʉ ja ran 'yägui nɛ bi nu bʉ mbo. Nɛ bi nu mi 'bøntho bʉ ra 'bø't'e má mbant'i ra Jesús. Nɛ bi mbeng bʉ ja rá ngu bʉya, bi hyonya thoho 'bɛ'a bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nɛ gue'a ra pa bi mba yoho yʉ 'yɛ̨c'yɛi bʉ ja ra hnini Emaús ngue hinga yatho, hyu ora tho ná 'yo. ");
INSERT INTO otmNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nɛ i mam bʉ ní mba 'bɛ'a bin ja bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nɛ gätho ná yą'ʉ, bi zʉpʉ 'yu a ra Jesús nɛ bin 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nɛ nu'ʉ bi nu a, pɛ him bi bądi to'o a. ");
INSERT INTO otmNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nɛ nu'a ra Jesús bi 'yän'dʉ: ―'Bɛ'a guí mammi. Nɛ nu'ʉ yoho bim 'bäpʉ bʉya, nɛ ɛ̨mmɛ tu yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nɛ nu'a n'da í Cleofas bi dąti, bi 'yɛ̨na: ―Masque høn'a zɛhɛ hin guí pądi 'bɛ'a bin ja bʉ Jerusalén yʉ pa i ja bʉya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nu'a ra Jesús bi 'yänni: ―'Bɛ'a bin ja bʉ. Nɛ bi xih pʉya 'bɛ'a bin ja, bi 'yɛ̨mbi: ―Nu ra Jesús, ra mɛngu Nazaret, n'da rá pøngahyą Oją ɛ̨mmɛ mi ja rá ts'ɛdi, bi 'yøt' yʉn t'øt'e nuįxte nɛ bi hoc yʉn zäman'ʉ. Nɛ bi 'yøt' ran ho bʉ na nu Oją, nɛ nu yʉ ją'i bi numansu a. ");
INSERT INTO otmNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nɛ nu'ʉ yʉ ngʉrpa mbäją nɛ mi'da ma ngʉrpihʉ, bi dä'a ra Jesús bʉ 'bʉh ra ts'ʉt'abi ngue da tho. Nɛ bi mba ma cuati bʉ ja ra pont'i bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nɛ nugähe, dá bɛ̨mhbe gue'a da yąnjʉ dyʉ́ ją'i israelgähʉ, nɛ xtín jasɛ ma ts'ɛdi zɛhɛhʉ mahøn'a. Pɛ ya ná hyu pa ya bi tho. ");
INSERT INTO otmNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Pɛ nu'ʉ 'da yʉ xisu ma mi 'yɛ̨c'yɛihe, mán t'ʉxuditho bi mba bʉ ja rán 'yägui, guepʉ bí o ra Jesús, pɛ him bi dįm bʉ a, nɛ bá peng bʉ ja ra ngu bi xije 'bɛ'a bi nu, nɛ bi man'ʉ bi nu 'da yʉ́m 'bɛhni Oją mahɛ̨ts'i, bi xifi i 'bʉ'a ra Jesús. Nɛ ɛ̨mmɛ dadí hyonya thohe. ");
INSERT INTO otmNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pɛ nu'ʉ 'da man 'yohe, bi mba bʉ ja ran 'yägui nɛ ngutho bi man'ʉ ngue hin'yʉ bʉ rá ją'i, bi 'yɛ̨n'ʉ yʉ 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pɛ nubʉya, nu'a ra Jesús bi xi'ʉ min 'yohʉ: ―Nu'aui, guí 'yąmbʉiui nɛ xíngui ts'ʉ guí ɛ̨hya gui 'yɛ̨c'yɛiui 'bɛ'a gätho bi man yʉ́ pøngahyą Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nguetho gätho ʉ bi ma jatho da nu ran ʉnbi ra Cristo, gue'bʉ go bi gonhui rá ts'ɛdi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nɛ nubʉya, bi xi'ʉ 'bɛ'a gätho bi man yʉ pøngahyą ngue din ja, nɛ 'bɛ'a nam bøn'a nt'o't'i bʉ. Bi dʉ'mi bʉ rá mbʉdi rá søcuą ra Moisés nɛ bi xifi gätho ʉ mi'da yʉ́ søcuą Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nɛ nu'bʉ mi ts'ʉtho da zøm bʉ ní mba, nu ra Jesús bi 'yøt'e tengu 'bʉ da thogui. ");
INSERT INTO otmNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pɛ nu'ʉ yoho min 'yohʉ bi ząmmi din oxhʉ bʉ, nguetho bin de. Nɛ nu'a ra Jesús bʉya, bi gohmbʉ bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nɛ nu'bʉ min sihmɛhʉ, nu ra Jesús bi hyąc ra hmɛ, nɛ bi un ra jamadi Oją, bi xɛni, bi un'dʉ mi 'bʉpʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","'Bexgue 'dahmantho bi bądi to'o a ra Jesús tengu'bʉ ja bin zø yʉ́ dä. Pɛ nu'a ra Jesús 'bexque bim 'bɛtho bʉ, him bi nu hapʉ í mba. ");
INSERT INTO otmNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nɛ nu'ʉ yoho bin yąsɛ ʉ, bi 'yɛ̨n'ʉ: ―Pɛ hanja hin dá pąhmi 'bʉ mán c'athʉ bʉ ja ra 'yu. Ha him bin johya ma mbʉiui 'bʉ mí xicui 'bɛ'a nam bøn'a rám hma Oją, bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","'Bex bi ndants'i, bi mbeng bʉ Jerusalén, nɛ bi dįm bʉ ʉ 'dɛ'ma'da ngue madím pɛtihʉ mi'da yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nɛ ɛ̨mmɛ madí johya ʉ, nɛ i ma ngue bi ndants'i mahøn'a ra Hmu nɛ bin yąui ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pɛ nu'ʉ bi zøhø ngue min 'yohʉ ra Jesús bʉ 'yu, bi xi'ʉ mi'da 'bɛ'a bi 'yørpʉ 'yu. Nɛ bi xi'ʉ ngue gue'a í bą'a ngue bi xɛn ra hmɛ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nɛ nu'bʉ gätho na yą'ʉ yʉ xädi, ya xí 'bäpʉ ra Jesús 'bʉ mi nu. Nɛ bi zɛngua ʉ, bi 'yɛ̨mbi: ―Gan johyahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nɛ ɛ̨mmɛ bin su, bi bɛ̨ni gue i nu n'da ran dąhi, ngue him majuąni. ");
INSERT INTO otmNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Hanja ngue in jabʉ nin 'yomfɛ̨nihʉ, nɛ hingui sä gui 'yɛ̨c'yɛigahʉ. ");
INSERT INTO otmNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dami hyɛ̨tcahʉ, nɛ guin nuhʉ ma 'yɛ nɛ ma gua, nɛ gui nuhʉ ngue gueczɛhɛgä. Dami thäqui, janangue da zä gui pąhmbʉ ngue i ja a ma ngøc'yɛi. Pɛ nu'a n'da ran dąhi tengu guím bɛ̨mhbʉ, hinguin 'youi rá ngøc'yɛi a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nɛ nubʉya, bi 'yut'ʉ yʉ́ 'yɛ nɛ yʉ́ gua. ");
INSERT INTO otmNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pɛ guexta'a him 'bexque bi 'yɛ̨c'yɛi nguetho bi hyonya thoho, nɛ xin di johya ʉ. Nu ra Jesús bʉya, bi 'yäpi 'bɛ'a da zi. ");
INSERT INTO otmNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Bex bi un'na n'da xɛqui ra huą. ");
INSERT INTO otmNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bi hyąm bʉya nɛ bi za, nɛ gätho yʉ ją'i mi 'bʉpʉ bi nu. ");
INSERT INTO otmNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nuya bin ja 'bɛ'a gätho dá xi ahʉ 'bʉ mám 'bʉhmbʉ. Ya dá xi ahʉ gue din ja a nt'o't'i bʉ ja yʉ́n t'ɛ̨di ra Moisés, nɛpʉ ja yʉ́ søcuą yʉ pøngahyą, nɛ'a nt'o't'i bʉ ja yʉ thuhu, yʉ salmo, nɛ ya bin ja, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nu ra Jesús bʉya, bi xocpa yʉ́n 'yomfɛ̨ni ngue da zä da bą'ʉ 'bɛ'a nam bøn'a rám Hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nɛ bi 'yɛ̨mp'ʉ: ―Nt'o't'i bʉ ja rám Hman Oją gue da nu ran ʉnbi ra Cristo, nɛ da tho, nɛ ná hyu pa da dąmbɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nɛ nt'o't'i bʉ ngue dí mbʉpʉ Jerusalén da hman ran ho ma'da'yo, nɛ gätho ná ngʉni ra ximhäi, nɛ da sih yʉ ją'i di päh yʉ́n 'yomfɛ̨ni nɛ da mba ma punbi yʉ́ ts'oqui, ngue nangue rá thuhu ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nu ahʉ, sä guim mamhbʉ majuąni ran ho ma'da'yo, nguetho gá nuhʉ 'bɛ'a gätho bin ja. ");
INSERT INTO otmNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nɛ gua pɛn 'nahʉ rá Hogandąhi Oją bi mam ma Ta di 'da ahʉ. Pɛ jatho gui tømhbʉ ua Jerusalén, gue'bʉ go bá ɛ̨h mahɛ̨ts'i rá ts'ɛdi gan 'yohʉ, bi 'yɛn'a ra Jesús, bi 'yɛ̨m'bʉ min yąhʉ yʉ́ xädi. ");
INSERT INTO otmNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nu'bʉ mi gua'a bi man ra Jesús, bi zix ʉ yʉ́ xädi bʉ ja ra 'yu ní mba bʉ Betania, nɛ guepʉ bi 'uą'ts' yʉ́ 'yɛ nɛ bi jąp'ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pɛ nubʉya bi zopʉ ʉ yʉ́ xädi nɛ bi ndex mahɛ̨ts'i. ");
INSERT INTO otmNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nɛ gätho ʉ mi 'bäpʉ bi 'yɛ̨spi nɛ ɛ̨mmɛ bin johya yʉ́ mbʉi ʉ. Nɛ bi mbeng bʉ Jerusalén bʉya. ");
INSERT INTO otmNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nɛ gätho yʉ pa bin de bʉ ja ra dąniją, mi numansu Oją nɛ bi un ra jamadi Oją bʉ. Nɛ hønt'a dí xi'a ya.");
INSERT INTO otmNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nu'a ra Cristo tengu'bʉ ram hma nguetho di jajʉ ga pąhmbʉ Oją a. Nɛ ya xmí 'bʉ 'bʉ hin te mí ja ra ximhäi, nɛ i 'bʉhmi Oją a, nɛ nu'a Oją a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nɛ gue'a mí 'bʉhmi Oją 'bʉ rá mbʉdi thoho. ");
INSERT INTO otmNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gätho bi 'yøt'e 'bɛ'a i ja. Nu'bʉ hin xtá 'yøt'a, hin te di ja 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","I jasɛ rá te, nɛ gue'a ní ja yʉ́ te ʉ yʉ ją'i, ngue di 'yomfɛ̨nip yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Janangue'a nu'a tengu ran nɛqui di yorpʉ ja ra 'bɛxui. Pɛ nu'a ra 'bɛxui hin da zä di huɛ̨'t'a ran nɛqui. ");
INSERT INTO otmNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nu Oją bi huahna n'da ran 'yohʉ gue'a ra Xuua Nxixyą a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nu'a ra Xuua Nxixyą bi thahni da ma nangue'a ran nɛqui majuąni, ndepe gätho da 'yɛ̨c'yɛi ran nɛqui yʉ ją'i, nangue'a bi man'a ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pɛ nu'a ra Xuua Nxixyą hinga gue'a ran nɛqui a, pɛ bi ma nangue'a ran nɛqui. ");
INSERT INTO otmNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nu'a ran nɛqui majuąni, bá ɛ̨cua ja ra ximhäi, ndepe gätho din ja ran nɛqui yʉ́ mbʉi yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nu'a ran nɛqui majuąni bi 'yøt' ra ximhäi, nɛ bim 'bʉcua, pɛ nu yʉ ją'i ua ja ra ximhäi him bi bądi gue gue'a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Í zøcua dí 'bʉhmbe ngue ma mɛngugähe a. Pɛ xʉn ngu ʉ him bi 'yømanho a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pɛ gätho to'o bi zim bʉ mbo yʉ́ mbʉi a ra Cristo, nɛ bi 'yɛ̨c'yɛi gue yʉ́ yąnte a, gue'a í zä bi xąnd mahøn'a Oją ʉ ngue bi 'yøt'e yʉ́ t'ʉhni zɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pɛ nu'bʉ bi xąnd mahøn'a Oją n'da, hinguin ja tengu'bʉ xʉm 'bʉ a n'da ra 'uɛre, ngue bi ndesɛ yʉ ją'i nɛ nangue yʉ́ ją'i zɛhɛ, pɛ bim 'bʉi mahøn'a nangue Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nɛ nu'a tengu'bʉ ram hma bin ją'i a, nɛ mí 'bʉhmbe a. Nɛ dá nuhe rá nuįxte nguetho rá 'dats'ʉnt'ʉ Oją a, hin hapʉ i sɛ a rá mate, nɛ gätho majuąni bi ma. ");
INSERT INTO otmNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nu'a ra Xuua Nxixyą bim pøngahyą nangue'a. Nɛ ts'ɛdi bi ma bi 'yɛ̨na: ―Nuna guehna dá mangä 'bʉ má xi ahʉ, m'bɛjua ba ɛ̨hɛ, pɛ man'da nuįxte xinda guecä, nguetho ya xmí 'bʉ 'bʉ rá mbʉdi thoho, nɛ hin'na gä, mí ɛ̨ngä, bi 'yɛ̨n'a ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nɛ gätho gahʉ dyʉ 'yɛ̨c'yɛihʉ, dá hąmhbʉ rá mate xʉn ndoho, nɛ thocua thoho di 'dajʉ man'da rá mate. ");
INSERT INTO otmNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nu ra Moisés bi xängahʉ yʉ́n t'ɛ̨di Oją. Pɛ nu ra Jesucristo bi 'dajʉ rá mate ngue majuąni dí zingdahʉ Oją a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Njo'o n'da ra ją'i da zä da nu Oją ngue xtám bąsɛ, hinda hønt'a rá 'dats'ʉnt'ʉ dim pąsɛui a rá Ta, nɛ gue'a bi jajʉ dá pąhmbʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nu'ʉ ma ngʉrpihe dyʉ judíohe dyʉ israelhe ngue mí 'bʉpʉ ja ra dąhnini Jerusalén, bi mba ʉ 'da yʉ mbäją nɛ'ʉ 'da yʉ́m fäts'ihʉ, bi zøm bʉ 'bʉh ra Xuua Nxixyą da 'yänni to'o a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nɛ nu'a bin juąnni, him bin cøni, nɛ bi 'yɛ̨na: ―Hinga guecä dra Cristo gue xʉ huand Oją, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nɛ bi t'änni mahøn'a: ―To'o e, ha gue'e gra Elías. ―Hin'na, hinga guecä, bi 'yɛ̨n'a. ―Ha gue'e gra pøngahyą bi man ra Moisés gue ba ɛ̨hɛ. Nɛ bi dąti: ―Hin'na, bi 'yɛ̨ntho. ");
INSERT INTO otmNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nɛ bi t'änni mahøn'a: ―To'o e. Xije. Nu'bʉ gui xije nɛ da zä ga xihmbe ʉ bá pɛngähe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nɛ bi dą'a ra Xuua Nxixyą bʉya: ―Nugä guecä bi man ra pøngahyą Isaías 'bʉ mi ma: “Dim 'bʉ a n'da dim 'bäpʉ ma'ueni ra hnini, nɛ ts'ɛdi da ma di hoc yʉ́ mbʉi yʉ ją'i gue da 'yømanho ra Hmu 'bʉ bi zøhø,” bi 'yɛ̨n'a ra Isaías, bi 'yɛ̨n'a ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nɛ nu'ʉ bi zøm bʉ, yʉ́m 'bɛhni yʉ fariseo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nɛ bi t'ɛ̨mp'a ra Xuua: ―Hanja gní 'yøt' ran xixyą 'bʉ hinga gue'e grá Cristo, xínga gue'e grá Elías, xínga gue'e man'da ra pøngahyą bi man ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nu'a ra Xuua bʉya bi dąt'ʉ, bi 'yɛ̨na: ―Nugä, ra dehe thoho ná xixyąba yʉ ją'i, pɛgue i 'bä inde n'da ran 'yohʉ ua dí 'bähmbʉ, ngue hin guí pąhmbʉ 'bɛ'a di 'yɛ̨t'ui a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nuna guehna dá mangä ngue m'bɛjua di dʉmp' rá 'bɛfi, pɛ man'da nuįxte xinda guecä, janangue'a hin dí sʉcä tengu a, bi 'yɛ̨n'a ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nɛ guehya gätho yʉn t'änni bi hmam bʉ ja ra xɛqui Betábara, n'danguadi ra dąthe Jordán, guepʉ bi 'yøt' ran xixyą ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nu'bʉ mi hyats'i, nu ra Xuua Nxixyą bi nu ba ɛ̨pʉ ra Jesús, nɛ bi 'yɛ̨mp'ʉ mí 'bähmbʉ bʉ: ―Dami hyanthʉ ya, tengu'bʉ ra t'ʉdɛ'yo, nguetho bi zänba Oją dim 'bøts'e zɛhɛ, gue di hocpa yʉ́ ts'oqui yʉ ją'i 'bʉcua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nunʉ guehnʉ mím mangä nʉ 'bʉ má ɛ̨ngä: “Ba ɛ̨ a n'da ran 'yohʉ m'bɛjua, nu'a man'da nuįxte xinda guecä, nguetho ya xmi 'bʉ 'bʉ rá mbʉdi thoho, nɛ hin'nagä.” ");
INSERT INTO otmNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nɛ nugä him mí pącä to'o a t'ɛ̨mbi ra Cristo. Pɛ bi siqui ga xixyą ahʉ nangue ra dehe, ngue gui pąhmbʉ to'o a ni yąntehʉ, ma mi israel ahʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nɛ bi ma majuąni ra Xuua Nxixyą, bi 'yɛ̨na: ―Dá nugä rá Hogandąhi Oją bá cąh mahɛ̨ts'i, tengu n'da ra t'azʉ, nɛ bi gohmi ra Jesús 'bʉ má ørpa ran xixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ja dá pącä bʉya ngue gue'a. Nguetho nu Oją ngue bi xiqui ga øt' ran xixyą nangue ra dehe, nɛ bi xiqui: “Nu'bʉ guin nu ma Hogandąhi da gąi nɛ da gohmi n'da ran 'yohʉ, gui pądi ngue gue'a di un ma Hogandąhi yʉ ją'i,” bi 'yɛ̨ngui. ");
INSERT INTO otmNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nɛ gue'a dá nugä a bʉya, janangue dím mangä: “Guehna rá Ts'ʉnt'ʉ Oją na,” dí ɛ̨ngä, bi 'yɛ̨n'a ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Xø man'dapa bʉya mí yo'be mi 'bähmbe ra Xuua Nxixyą yʉ́ xädigä'be a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nu ra Xuua Nxixyą bʉya bi hyandi ngue 'yo bʉ ra Jesús, nɛ bi 'yɛ̨nc'be: ―Dami nuui ya ra t'ʉdɛ'yo ngue'a rám 'bɛhni Oją, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nu'bʉ má ø'be a bi ma, dá tɛn'be ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nɛ nu'a ra Jesús bin yɛ̨ 'bʉ má tɛn'be nɛ bi 'yänga'be: ―'Bɛ'a guí hommi, bi 'yɛ̨nc'be. Nɛ dá än'be a: ―Rabí, nde da ma, xänbate i, hapʉ guí 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nɛ bi xic'be ra Jesús: ―Ga mbähä gua nuui bʉ dí 'bʉcä. Dá mbähmbe bʉya nɛ dá nu'be hapʉ mi 'bʉi. Nɛ man'da ora dám 'bʉ'be bʉ 'bʉ má sømhbe bʉ, nguetho mbɛ goho nde 'bʉ má sømhbe bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nɛ nu'a man'da gue min 'yohe 'bʉ mi xic'be ra Xuua Nxixyą ga tɛn'be ra Jesús, ra Andrés a, rán 'yohʉ ra Simón Pedro. ");
INSERT INTO otmNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nuna ra Andrés 'bex bi mba bá xi a rán 'yohʉ. ―Ya dá tįm'be ra Mesías, bi 'yɛ̨na. Nu'a nde da ma rá Thahni Oją a, ngue gue'a ra Cristo a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nɛ nu ra Andrés bʉya, bi zix'a ra Simón guepʉ bí 'bä a ra Jesús. Nɛ nu ra Jesús 'bʉ min nu, bi 'yɛ̨mbi: ―Nu'i gra Simón rá ts'ʉnt'ʉ i ra Jonás. Nuya ga xi a man'da ni thuhu ga hut'a ra Cefas, n'dat'a ra Pedro gue nde da ma, ra do. ");
INSERT INTO otmNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Xø man'dapa mahøn'a bʉya bi bɛ̨n a ra Jesús da mba bʉ ra häi Galilea. Nɛ nu'bʉ má mbähmbe bin tįmmi ra Felipe. ―Dami tɛngui, bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nuna ra Felipe ra mɛngu bʉ Betsaida, nɛ ra Andrés, nɛ ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nɛ nu'bʉ mi mba ra Felipe nɛ bi dįn'a ra Natanael, bi 'yɛ̨mbi: ―Ya dá tįngähe a gue mi hmam bʉ ja rá søcuą ra Moisés, nɛpʉ ja yʉ́ søcuą yʉ́ pøngahyą Oją mi hma, nɛ gue'a ra Jesús ra mɛngu Nazaret, rá ts'ʉnt'ʉ ra José, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nu ra Natanael bʉya bi 'yɛ̨na: ―Hague dán zä di nɛqui n'da ra hocją'i bʉ Nazaret. Nu ra Felipe bʉya bi 'yɛ̨mp'a: ―Ga mbɛ gua nusɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nɛ nu'bʉ min nu ra Jesús gue ba ɛ̨pʉ ra Natanael, bi 'yɛ̨nje bʉ mi 'bähmbe: ―Dami nuhʉ nʉ ran 'yohʉ ba ɛ̨hnʉ ya, gue rán säui njuąntho da t'ɛ̨mbi ra israel, nguetho hingui yoho rán 'yomfɛ̨ni, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Bi 'yɛ̨n'a ra Natanael bʉya: ―Hanja guí pądi gue hingui yoho man 'yomfɛ̨nigä nɛ njąm'bʉ gá nugui, bi 'yɛ̨na. Nu ra Jesús bi 'yɛ̨mp'a: ―Nu'bʉ hin ní zo a ra Felipe, dí pądi 'bɛ'a gnám bɛ̨m 'bʉ gmi hupʉ ja ra za, bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nu ra Natanael bʉya bi 'yɛ̨mp'a: ―Ma Hmu i, rá Ts'ʉnt'ʉ i Oją, gue'e bi zän'na Oją gam hmuts'ʉt'abi nanguecähe dyʉ israelhʉ, dyʉ judíohʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nu'a ra Jesús bi 'yɛ̨mp'a: ―Ha gue'a guí 'yɛ̨c'yɛigä a dá xi i, gue'bʉ má xi i: “Dí pądi 'bɛ'a gnám bɛ̨m 'bʉ gmi hupʉ ja ra za.” Pɛ man'da nuįxte guin nu 'bʉ m'bɛjua xinda guehna dá xi i. ");
INSERT INTO otmNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nguetho majuąni dí xi i, guin nuhʉ da xoh mahɛ̨ts'i, ngue guin nuhʉ yʉ́m 'bɛhni Oją ba cąh mahɛ̨ts'i, nɛ da zøpʉ hapʉ gä dan 'yogä, nɛ da ndets'e, gue guecä dán ją'igä ua ja ra ximhäi, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nɛ nu'bʉ mí tho'a nyopa bʉya bin ja n'da ra dąnts'ihmɛ 'bʉ mín thąta n'da ra ts'ʉnt'ʉ bʉ Caná ra häi Galilea. Nɛ bi zøm bʉ rá mbe ra Jesús, bi mbäx'ʉ bi hoc ran ts'ihmɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nɛ ra Jesús nɛcähe yʉ́ xädigähe bi ts'oncahe bʉ ja ran ts'ihmɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nɛ nu'bʉ min theh ra gui'uva dá sihe, bi 'yɛ̨n'a rá mbe ra Jesús: ―Bin the'a ra gui'uva, bi 'yɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Bi dą'a ra Jesús bʉya: ―Ma mbe i, 'bɛ gám bɛ̨nsɛ 'bɛ'a ga øt'ä, nguetho hinga na søn ra ora ga øt'a n'da ran t'øt'e nuįxte, bi 'yɛ̨mp'a rá mbe. ");
INSERT INTO otmNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nɛ nu'a rá mbe ra Jesús bʉya bi xi ʉ yʉ 'yɛ̨hɛ 'bʉpʉ: ―Hønt'a go 'bɛ'a da xi ahʉ ra Jesús, dami 'yøthʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nɛ mí høpʉ 'dato yʉ xaro ngue yʉ do, mbɛ goho 'däte litro i hät'ʉ. Nguetho i ja ran t'ɛ̨di ma mi judíohe gue i jatho din xʉt'yɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nɛ nu'bʉ mí zøn ra ora bi man ra Jesús, bi xi ʉ yʉ 'yɛ̨hɛ 'bʉpʉ: ―Dami yus'hʉ yʉ xaro nangue ra dehe. ―Nɛ bi yus' pʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nɛ bi 'yɛ̨mbi mahøn'a: ―Dami 'yä i ts'ʉ ra dehe nɛ gui un'na ra ngʉrpa 'yɛ̨hɛ, bi 'yɛ̨na. Nɛ bi un bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nɛ nu'bʉ mí zä a ra ngʉrpa 'yɛ̨hɛ gue xín gui'uva a ra dehe, bi zä mancʉhi. Pɛ him bi bądi hapʉ bi nɛqui, pɛ nu yʉ 'yɛ̨hɛ gue bi 'yä a ra dehe mi pą ʉ. Janangue'a nu ra ngʉrpa 'yɛ̨hɛ bi ma bá ts'i a ra ts'ʉnt'ʉ da 'yänni nangue ra gui'uva, gue nu'a ra ts'ʉnt'ʉ go din thąti. ");
INSERT INTO otmNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nɛ bi t'ɛ̨mp'a: ―Pɛ hanja 'bɛ bin niyą ʉ yʉ ją'i, gá un'na ra gui'uva xʉn cʉhi, nɛ hinga gue'a ząi øt' yʉ ją'i a. Pɛ ząi rá mbʉdi thoho di un a xʉn cʉhi bʉ ja n'da ran ts'ihmɛ, nɛ nu'bʉ bin niyą yʉ ją'i din t'un'na hin ɛ ho, bi 'yɛ̨n'a ra ngʉrpa 'yɛ̨hɛ. Nɛ xinga gue'a mí pą a. ");
INSERT INTO otmNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nɛ guehna rá mbʉdi ran t'øt'e nuįxte bi 'yøt' ra Jesús bʉ Caná ra häi Galilea, gue bi 'yuh rá ts'ɛdi. Nɛ man'da dá ɛ̨c'yɛihe bʉya yʉ́ xädigähe a. ");
INSERT INTO otmNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","M'bɛjua bʉya dá mbähmbe ra Jesús bʉ ra hnini Capernaum, nɛ rá mbe nɛ yʉ́n 'yohʉ. Pɛ hinga nya'a dám 'bʉhmbe bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Dá mbähmbe ra Jesús bʉ Jerusalén 'bʉ ma guepʉ da dät' ra pa mahøn'a ran dąbaxjua gue 'bʉ mi hyo ra t'ʉdɛ'yo bʉ Egipto mam bombøtahe. ");
INSERT INTO otmNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nɛ nu'bʉ mí yʉrpʉ mbo má mbä't'i ra dąniją, bi nu ngue 'bʉpʉ yʉ mbändąni nɛ yʉ mbädɛ'yo nɛ yʉ mbäts'ąha mim pä bʉ. Nɛ mí 'bʉpʉ ʉ yʉm pämbɛti øt' yʉ́ 'bɛfi bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nɛ bi 'yøt'a n'da ram fɛi gue ra xąhi gue í dɛx'ʉ yʉ mbä. Nɛ gätho bi hyøn a thi yʉ mbä nɛ yʉ́n dąni nɛ yʉ́ dɛ'yo. Nɛ bi 'uɛ̨nba yʉ́ mbɛti yʉm pämbɛti, bi ndønba yʉ́ mɛxa. ");
INSERT INTO otmNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nɛ bi t'ɛ̨mp'ʉ yʉ mbäts'ąha: ―Ní mbähä, dami six ni dojahʉ. Hingui sä gui 'yøthʉ ra nguntäi ua rá ngu ma Ta, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nɛ 'bex dá bɛ̨mhbe a mán t'o't'i ja rá t'ohni Oją: “Ɛ̨na da guah ma mbʉi nangue ra dumbʉi 'bʉ má nu a ni ngu, nguetho ɛ̨mmɛ dín ndepe xtán hotho bʉ,” bi 'yɛ̨mp a rá Ta ra Cristo, bi 'yɛ̨n rá t'ohni. ");
INSERT INTO otmNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nu'ʉ ma ngʉrpihe dyʉ judíohe bi 'yän bʉya, nɛ bi 'yɛ̨mbi: ―'Bɛ'a ní hmɛpya gui 'yurcahe ya, n'dahma da zä ga pąhmbe 'bʉ i ja nin t'ɛ̨di gui 'yøt'a gá 'yøt' ya, gue gá hyøn a thi yʉ mbä, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nu ra Jesús bi dąt'ʉ: ―Ga xi ahʉ ra hmɛpya gá 'yäjʉ. Nu'bʉ gui xothʉ ra niją ua, nɛ hyupa thoho dá høh mahøn'a, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bi 'yɛ̨n'ʉ ma ngʉrpihe bʉya: ―Pɛ yote ma 'dato njɛya án guahna ra niją, nɛ guí ɛ̨na, nhyupa thoho gdí hyøh mahøn'a, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pɛ nu'a ra niją bi man a ra Jesús, bi ma nangue rá ngøc'yɛ̨i zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nu'bʉ mí zøn ra ora bi du nɛ bi dąmbɛ̨ni, 'bexgue dá bɛ̨mhbe 'bɛ'a xí man'a, nɛ man'da dá pąhmbe majuąni a bi man rá t'ohni Oją nɛ yʉ́m hman ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nɛ nu'bʉ mám 'bʉhmbe bʉ Jerusalén, gue'ʉ yʉ pa ran dąbaxjua, xʉn ngu ɛ̨na bi 'yɛ̨c'yɛi ra Jesús 'bʉ mín nu yʉn t'øt'e nuįxte bi 'yørpʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pɛ nu'a ra Jesús hinga gätho bi xi ʉ 'bɛ'a mím bɛ̨ni, nguetho bi bądi 'bɛ'a di ja yʉ́ mbʉi gätho yʉ ją'i, bi bądi hin da 'yømanho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nɛ hinga hnɛhi tho da sih ra Jesús 'bɛ'a im bɛ̨n yʉ ją'i nguetho ya i pą a ra Jesús 'bɛ'a di ja yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mí 'bʉ a n'da ran 'yohʉ, n'da ra fariseo, gue'ʉ min ɛ̨hya da 'yøt' yʉ́n t'ɛ̨di Oją, í Nicodemo a. Nu'a n'da rá ngʉrpi ma mijudíohe. ");
INSERT INTO otmNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","N'da ra xui bi zøm bʉ 'bʉh ra Jesús, nɛ bi 'yɛ̨mbi: ―Xänbate i, dí pąhmbe Oją bi zän'ni i gui xängahe, nguetho hin xtán zä xquí 'yøt' yʉn t'øt'e nuįxte 'bʉ hin di zɛ a Oją, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nu ra Jesús bi dądi, bi 'yɛ̨mp'a: ―Majuąni dí xi a i, nu'a hin dim 'bʉi ma'da'yo, hin da zä da yʉrpʉ di manda Oją, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nu ra Nicodemo bi 'yɛ̨m bʉya: ―Hague dán zä dim 'bʉi ma'da'yo n'da gue'bʉ xʉn dąc'yɛi n'da. Ha da zä da yʉt' mahøn'a bʉ ja rá mbʉi rá mbe nɛ dim 'bʉi mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nu'a ra Jesús bi 'yɛ̨mp'a: ―Majuąni dí xi a i, gue nu'a to'o him bim 'bʉi ma'da'yo nangue ra dehe nɛ rá Hogandąhi Oją, hin da zä da yʉrpʉ di manda Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nguetho nu'bʉ din xąnd yʉ ją'i, xø yʉ ją'itho yʉ́ t'ʉhni, pɛ nu'ʉ di xąnd rá Hogandąhi Oją, gue'ʉ i ja rá te Oją bʉ ja yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Janangue'a o gadi hyonya thoho a dí xi a i, jatho gam 'bʉi ma'da'yo. ");
INSERT INTO otmNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nɛ tengu ran dąhi i 'yo hønbʉ go hapʉ in nde, nɛ guí øde di hį, pɛ hin guí pądi hapʉ ní 'yɛ̨hɛ o hapʉ ní mba. Njabʉ i øt' rá Hogandąhi Oją 'bʉ bi xąnd mahøn'a n'da, hingam 'batho ha bin ja 'bʉ mí un ra 'da'yote, pɛ mfądi ngue i ja a, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","―Hín dí pądi 'bɛ'a nam bøn a guí man ya, bi 'yɛ̨n'a ra Nicodemo. ");
INSERT INTO otmNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nu ra Jesús bi 'yɛ̨mp'a: ―Nu'i grá xänbate, ząi guí xänba rám Hman Oją ʉ ma mi israelhʉ, hanja hin guí pądi 'bɛ'a dí xi a i. ");
INSERT INTO otmNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Majuąni dí xi i, dím mangä a dí pącä, nɛ dím ma majuąni 'bɛ'a xtá nugä, pɛ hin guí hąmhbʉ mam hmangä. ");
INSERT INTO otmNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dá xi'a rá 'bɛfi Oją i øt' ua ja ra ximhäi, pɛ hin gá 'yɛ̨c'yɛi. Pɛ dami 'yɛ̨c'yɛi a, janangue'a da zä ga xi i 'bɛ'a rán 'yomfɛ̨ni Oją, ngue 'bɛpʉ ní nɛqui rá 'bɛfi i øt' ua. ");
INSERT INTO otmNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nɛ høngdä da zä ga mangä ua a, nguetho drá mɛngugä bʉ mahɛ̨ts'i nɛ bá ɛ̨cä bʉ, guecä ngue dán ją'igä ua ja ra ximhäi. Nɛ njo'o man'da ra ją'i ngue bi yʉt mahɛ̨ts'i nɛ bá pengui ngue da mangua 'bɛ'a øt' Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nɛ tengu thoho bi 'yøt' ra Moisés, gue bi cuarpʉ magąts'i n'da ra pozʉ nt'øt'e ra t'ɛgui, nu'bʉ mín 'yo bʉ ja ra ʉhäi, ngutho jatho din jacä din cuarcä magąts'i, guecä gue dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nɛ nu'bʉ bin jacä tengu a, nɛ hønt'a go to'o da 'yɛ̨c'yɛi 'bɛ'a dá tugä bʉ, hin da nu ran ʉnbi maząi, pɛgue din ja ra 'da'yote maząi a, bi 'yɛ̨n a ra Jesús, bi 'yɛ̨mp'a ra Nicodemo. ");
INSERT INTO otmNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nguetho ɛ̨mmɛ di huɛ̨gahʉ Oją gue dí 'bʉhmbʉ ua ja ra ximhäi. Janangue'a bi 'dajʉ rá 'dats'ʉnt'ʉ ngue ma yąntehʉ, n'damhma hin da nu ran ʉnbi maząi to'o gätho di däp rá mbʉi a, pɛgue din t'un ra 'da'yote maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nguetho in nde Oją da yąnjʉ guejʉ dí 'bʉhmbʉ ua ja ra ximhäi, nɛ hinguin nde di 'dajʉ rá muui ma ts'oquihʉ, nɛ gue'a bí mbɛnhua rá Ts'ʉnt'ʉ ua ja ra ximhäi a. ");
INSERT INTO otmNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nɛ nu'a to'o di däp rá mbʉi a rá Ts'ʉnt'ʉ Oją, hin da nu a rá muui yʉ́ ts'oqui. Pɛ nu'a to'o hin di däp rá mbʉi a, pɛ guehma da nu a xí ts'änbi da nu nangue yʉ́ ts'oqui, nguetho hingui ɛ̨c'yɛi a rá 'dats'ʉnt'ʉ Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nɛ gue'a bí mbɛn Oją ran nɛqui ua ja ra ximhäi, gue ní nɛqui 'bɛ'a di ho yʉ ją'i. Nu'ʉ to di ho ra 'bɛxui hingui søm bʉ ja ran nɛqui, nguetho øt' ran ts'o. Mfądi xʉn ho din ʉnba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nguetho gätho ʉ i øt' ran ts'o hin di ho ran nɛqui, nɛ hingui søm bʉ ja ran nɛqui, ngue i su hin da hnumanho 'bɛ'a øt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pɛ nu yʉ ją'i i honi da 'yøt'a ran ho, i pa bʉ ja ran nɛqui, n'dahma da hnu gue gue'a Oją di zɛ ʉ da 'yøt' ran ho. ");
INSERT INTO otmNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","M'bɛjua dá mbähmbe ra Jesús dyʉ́ xädihe, dá mbähmbe bʉ ja ra häi Judea, nɛ dám 'bʉhmbe bʉ 'da yʉ pa nɛ dá xixyąbahe yʉ ją'i bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nɛ'a ra Xuua Nxixyą mí øt' ran xixyą bʉ Enón 'darpʉ ra xɛqui Salim, nguetho xʉn ngu yʉ mbøthe i pøpʉ, ");
INSERT INTO otmNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ngue'bʉ hin ní jot'a fädi ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bin junthʉ 'da ʉ yʉ́ mijudíohʉ ʉ yʉ́ xädi ra Xuua, gue bi bɛ̨ni man'da di muui rán xixyą i øt'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bi zøm bʉ 'bä'a ra Xuua Nxixyą ʉ yʉ́ xädi bʉya, nɛ bi 'yɛ̨mbi: ―Xänbate i, nu'a ran 'yohʉ gmín 'youi bʉ 'danguadi ra dąthe Jordán, gue gá xije to'o a, pɛ nuya i øt' ran xixyą, nɛ gätho yʉ ją'i i tɛnni. ");
INSERT INTO otmNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nu ra Xuua Nxixyą bʉya bi 'yɛ̨mp'ʉ: ―Guesɛ Oją bi zänni hangu nangu ra 'bɛfi n'da ngu n'da ngue da zä da 'yøt'a n'da. ");
INSERT INTO otmNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nu'ehʉ guí pąhmbʉ 'bɛ'a gätho dám mangä gue dá xi ahʉ, hinga guecä drá Cristo, pɛ nugä bám 'bɛt'ogä, gue dá xih yʉ ją'i din sä da dɛn ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tengu'bʉ n'da ra hmute din thąti, da dɛn'na rá ndø. Nɛ nu'a rá amigo a ran 'yohʉ bin thąti, i 'bäpʉ i ø'a i ma, nɛ di johya gue i tɛn'na rá ndø a ra hmute. Dín jadä bʉya, dadín johyagä 'bʉ dín nu i tɛn yʉ ją'i a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nu'a ra Jesús jatho da dąha gue nugä, pɛ nugä jatho ga 'bɛcä, bi 'yɛ̨n a ra Xuua Nxixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nguetho nu'a ra Jesús bá ɛ̨h mahɛ̨ts'i, man'da nuįxte a xinda gue ʉ gäthogahʉ. Pɛ nujʉ dám 'bʉhmbʉ nangue yʉ ją'i ua ja ra ximhäi, dyʉ mɛnguhʉ ua ja ra ximhäi, nɛ hinga gätho da zä ga pąhmbʉ, hønt'a 'bɛ'a da zä da bą'a n'da ua ja ra ximhäi. Pɛ nu'a bá ɛ̨h mahɛ̨ts'i man'da xʉn ho ngue gätho mi'da, ");
INSERT INTO otmNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","nɛ im ma 'bɛ'a bi nu bʉ nɛ 'bɛ'a bi 'yørpʉ. Pɛ hingui ngu bi hyąnba rám hman a. ");
INSERT INTO otmNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nu'a to'o bi hyąnba rám hma, bi bądi majuąni bi man Oją ngue gue'a rá Ts'ʉnt'ʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nguetho bá pɛnh Oją a, nɛ guesɛ Oją i yą 'bʉ i yą a, nguetho nte di 'bɛh rá Hogandąhi Oją a. ");
INSERT INTO otmNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nu'a ra Ta ɛ̨mmɛ in numanho rá Ts'ʉnt'ʉ, janangue'a bi un ran t'ɛ̨di gätho di manda rá 'bɛfi. ");
INSERT INTO otmNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu'a to'o i ɛ̨c'yɛi rá Ts'ʉnt'ʉ Oją ya i ja ra 'da'yote maząi, pɛ nu'a hingui ɛ̨c'yɛi rá Ts'ʉnt'ʉ Oją, hin da nu ra te pɛ guexta'a da nu rá cuɛ Oją mi ja da nu, nɛ gätho yʉ pa maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nɛ nubʉya nu yʉ fariseo bi 'yø a man yʉ ją'i ngue man'da xʉn ngu i tɛn ra Jesús nɛ man'da xʉn ngu di xixyąbi, xinda gue'a ra Xuua Nxixyaą. ");
INSERT INTO otmNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pɛ nu ra Jesús him bi 'yøzɛhɛ ran xixyą, pɛ høngdähe yʉ́ xädigähe dá øthe ran xixyą. ");
INSERT INTO otmNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nɛ nu'bʉ mi bą'a ra Jesús 'bɛ'a mi 'yø ʉ yʉ fariseo, bi bɛ̨ni da 'uetho, ngue hin da bɛ̨n yʉ fariseo din sʉhmi ra Xuua. Bi bøm bʉ ja ra häi Judea bʉya, nɛ dá mbähmbe mahøn'a bʉ ra häi Galilea. ");
INSERT INTO otmNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pɛ guemhma bá thohmbe bʉ ja ra häi Samaria. ");
INSERT INTO otmNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nɛ nu'bʉ má thohmbe bʉ, dá sømhbe bʉ ja ra hnini Sicar, mbɛ häntho ra xɛqui bi un'a ra Jacob, bi un'na ra José rá ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","I jabʉ n'da ra pozo ra dehe gue bi 'yøt'a ra Jacob maya'bʉ. Nɛ guepʉ bin säya ts'ʉ ra Jesús, nguetho bi yäh ra 'yu. Mbɛ huxhyadi 'bʉ má sømhbe bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nɛ bi zøm bʉ n'da ra xisu ra mɛngu Samaria, da gʉx ra dehe. Bi 'yɛ̨n'a ra Jesús: ―'Daqui ts'ʉ ni dehe, ga sigä ts'ʉ, bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nɛ gätho gähe dyʉ xädigähe xtá sohmbe bʉ ra Jesús, nɛ dá cʉthe bʉ ja ra hnini ga tämhbe 'bɛ'a gätho ga sihe. ");
INSERT INTO otmNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nu'a ra xisu bi 'yɛ̨na: ―Hanja gní zoqui nɛ guí äc ra dehe, nguetho nu'i grá judío, nɛ nugä drá mɛngu Samaria, bi 'yɛ̨mbi. Ngubʉ bi man ra xisu nguetho nu ma mijudíohe hinguin zomanho yʉ mɛngu bʉ Samaria. ");
INSERT INTO otmNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nu ra Jesús bi 'yɛ̨mbi: ―Nu'bʉ xquí pą a rá mate Oją in nde di 'da'i, nɛ'bʉ xquí pąqui to'ogui gue dí ä'a ra dehe, xquí 'yäc ra dehe di un ra te, nɛ nugä xcá 'da'a 'bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nɛ nu ra xisu bi 'yɛ̨na: ―Nu'i grán 'yohʉ, hin'yʉ nin jʉxthe, nɛ xʉn hɛ̨ ua po na ra dehe. Hapʉ ja a ra dehe di un ra te guím ma. ");
INSERT INTO otmNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Pɛ nu mam bombøtahʉ ra Jacob bi zi ra dehe i po ua nɛ ʉ gätho yʉ́ t'ʉhni nɛ yʉ́n dąni. Nɛ bi zogahe ra pozo ja ua. Ha man'da ja ni ts'ɛdi ngue guí ɛ̨na man'da xʉn ho ra dehe gui 'daje, bi 'yɛ̨n'a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nɛ nu ra Jesús bi dąt'a bʉya: ―Hønt'a go to'o i sithe ua, gue'a nám 'bʉ ʉ yʉ pa ja bʉya, pɛ i tuthe mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pɛ hønt'a go to'o da zi ra dehe dadí ungä, njąm'bʉ din tuthe mahøn'a, pɛ din ja tengu n'da ra mbøthe bʉ mbo rá mbʉi njąm'bʉ din thegue, nɛ gue'a nám 'bʉh maząi n'da a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nu'a ra xisu bi 'yɛ̨mbi: ―Grán 'yohʉ, 'daqui ts'ʉ ra dehe guím ma gue hin dan tuthe mahøn'a, nɛ hin gua ɛ̨cä mahøn'a ua ja ra pozo ga jʉx ra dehe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nu'a ra Jesús bi dąt'a: ―Grá xisu, ní mba bá si a ni ndø. ");
INSERT INTO otmNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nu'a ra xisu bi dąt'a: ―Njo'o ma ndø, bi 'yɛ̨ntho. Nu'a ra Jesús bi 'yɛ̨mp'a: ―Majuąni guím ma, njo'o ni ndø. ");
INSERT INTO otmNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nguetho ya hin guí 'bʉhmi 'da ʉ cʉt'a yʉn 'yohʉ xcán thąthʉ, pɛ nu'a guí 'bʉhmi ya hin ni ndøsɛ a. Janangue'a majuąni njo'o ni ndø, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bi dą'a ra xisu bʉya: ―Nu'i grán 'yohʉ, masque grá pøngahyą Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xiqui ts'ʉ 'bɛ'a ga øt'ähe, nguetho nu ma tahe mí thąnde Oją ua ja ra t'øhø, pɛ nu ahʉ gyʉ judío ahʉ guí ɛ̨mhbʉ, jatho da mba n'da bʉ Jerusalén da dąnde Oją bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nu ra Jesús bʉya bi 'yɛ̨mp'a: ―Grá xisu, dami 'yɛ̨c'yɛi a ga xi i, ɛ maguepʉ da zøn ra pa hinga hønt'ua ja ra t'øhø, xínga hønbʉ Jerusalén din thąnde ra Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sä guí ɛ̨na guí thąndehʉ Oją, pɛ hin guí thąndehʉ tengu bi zän zɛhɛ Oją ngue din thąnde. Nugähe dyʉ judíohe dí thąndehe a bi zän Oją nguetho bi zän Oją ma t'ɛ̨c'yɛihe, nɛ'a ra Yąnte bi zän'na Oją ra judío a. ");
INSERT INTO otmNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pɛ bi zän Oją n'da ra xɛqui bʉ din thąnde, guepʉ ja ní mbʉi n'da. Nɛ mi ts'ʉtho da zøn ra ora, pɛ ya bi zøni, ngue da dąnde Oją nangue yʉ́ mbʉi ʉ to majuąni da dąnde, nɛ hin nangue yʉn t'øt'e ua ja ra ximhäi. Nguetho nu'a Oją i honi to'o da dąnde nangue yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nguetho hin di nɛqui Oją. Janangue'a hønt'a go to'o da dąnde Oją, jatho da dąnde nangue rá mbʉi nɛ nangue i tɛn'na ram hma majuąni, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nu'a ra xisu bʉya bi 'yɛ̨mbi: ―Dí pącä ba ɛ̨ a rá Thahni Oją ngue ra Cristo a. Nɛ nu'bʉ bá ɛ̨hɛ da xängahʉ xʉn ho gätho. ");
INSERT INTO otmNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nu'a ra Jesús bi 'yɛ̨mbi: ―Guecä drá Cristogä dín zo'a i ya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nu'bʉ mí gua'a bi man ra Jesús, ɛ xø dí sømhbe bʉ dyʉ xädigähe. Nɛ dá hyonya thohohe gue nu ra Jesús mi yąui a ra xisu. Pɛ xínga n'dagähe gue dá änhde hanja bin yąui o 'bɛ'a bin xifi. ");
INSERT INTO otmNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nu ra xisu bʉya 'bex bi zopʉ rá mbamhmi, nɛ bi mba bʉ hnini bi xih yʉ ją'i: ");
INSERT INTO otmNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Mbähä nɛ gua nuhʉ n'da ran 'yohʉ bi xicä gätho 'bɛ'a xtá øt'ä. Ha hinga gue'a ra Cristo 'bʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bi mba yʉ ją'i bʉya da zøm bʉ 'bä a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pɛ nu'bʉ hin ni zøm bʉ yʉ ją'i, nugähe dá xihmbe ra Jesús: ―Xänbate i, xi'bʉ gan sihmɛ ya, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pɛ bi dą'a ra Jesús, nɛ bi 'yɛ̨nje: ―Ja man'da ní niyą ma mbʉigä, pɛ hinga ná pąhmbʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dán 'yänzɛhɛhe: ―Ha 'bʉi to'o bi 'uįni, dán 'yɛ̨mfe bʉya dyʉ xädigähe. ");
INSERT INTO otmNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nu'a ra Jesús bi 'yɛ̨nje: ―Tengu'bʉ man ts'ihmɛgä a ngue ga øt'ä rá pähä a bá pɛngä nɛ ga juacä rá 'bɛfi a. Nɛ gue'a man'da ní niyą ma mbʉigä a. ");
INSERT INTO otmNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Janangue'a gue'a dí xi ahʉ a ya, nguetho ya ba ɛ̨hnʉ yʉ ją'i. Nɛ ha guí ɛ̨mhbʉ di 'bɛh man goho ząna din ja ran sofo. Pɛ dami hyanthʉ yʉ ba ɛ̨hnʉ, tengu'bʉ n'da ra huąhi ya xʉ 'yot'i gue da mba nsoqui, nguetho 'bexque da zä ga cʉthʉ bʉ di manda Oją yʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nɛ nu'ʉ to i pa ma cʉ't'i bʉ din ząm bʉ hønt'bʉ go njąm'bʉ. Janangue'a nu'ʉ to da xoqui di johya, nɛ nu'ʉ to bi duhu nɛ'ʉ bi xoqui 'da dán johya thoho. ");
INSERT INTO otmNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nguetho majuąni rán thɛui rá 'bɛfi Oją a bi 'yøt'a n'da ra ją'i, “bi zopʉ rá huąhi bi duhu, nɛ n'dan'yo bi xoqui,” ngue i man yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ya xtá xi ahʉ gui xojʉ hapʉ hin gá tuhmbʉ, xín gá uąfʉ, pɛ n'dan'yo bi 'yøt' ra 'bɛfi bʉ, pɛ guehma gui comhbʉ 'bɛ'a da dą ʉ, bi 'yɛ̨ngähe ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nɛ nu'bʉ mí mam bʉ ja ra hnini ra xisu, xʉn ngu yʉ́ mɛnguhʉ bi 'yɛ̨c'yɛi gue ra Cristo a ra Jesús, nguetho bi man'a ra xisu gue xí xi a ra Jesús gätho 'bɛ'a xí 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nu'bʉ mí zøm bʉ yʉ mɛngu Samaria bʉ 'bäh ra Jesús, bi 'yɛ̨n'ʉ: ―Dami 'bʉcua ja ma hninihe, bi t'ɛ̨mp'a ra Jesús. Nɛ dán dehe bʉ nyopa bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nɛ ɛ̨mmɛ man'da xʉn ngu bi 'yɛ̨c'yɛi yʉ ją'i bʉ, nangue rám hmansɛ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bi t'ɛ̨mp'a ra xisu bʉya: ―Ya dí ɛ̨c'yɛihe ya, pɛ hinga hønt'a gá xije ná ɛ̨c'yɛigähe ya, pɛ nɛ'a dá øsɛhe bi man na ra Jesús. Nɛ dí pąhmbe majuąni ra Cristo na, rám pørpate yʉ ją'i 'bʉcua ja ra ximhäi, bi 'yɛ̨n'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nu'bʉ mí gua'a nyopa dá pømhbe bʉ ra hnini Sicar, dá hąxhe ra 'yu mahøn'a ní mba bʉ Galilea. ");
INSERT INTO otmNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nɛ bi mansɛ ra Jesús, nubʉ rá häi zɛhɛ n'da ra pøngahyą hin da hnumansu bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pɛ nu'bʉ má sømhbe bʉ ra häi Galilea, bi numanho ma mɛnguhe bʉ. Nguetho xí nu yʉn t'øt'e nuįxte bi 'yøt'a ra Jesús bʉ Jerusalén 'bʉ mín ja ra dąmpɛti ran dąbaxjua, ngue nɛ'ʉ xí mba bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nɛ dá mbähmbe ra Jesús mahøn'a bʉ ra hnini Caná ra häi Galilea, guepʉ xí päh ra dehe bin gui'uva. Nɛ mí 'bʉpʉ n'da rám fäts'iui ra ts'ʉt'abi xʉn ʉ rá ts'ʉnt'ʉ, nɛ i 'bɛm bʉ ja rán oi nubʉ ja ra hnini Capernaum. ");
INSERT INTO otmNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nu'bʉ mí 'yøde gue bi zøh mahøn'a bʉ ra häi Galilea ra Jesús nɛ i 'bʉpʉ ra hnini Caná, nɛ bá ɛ̨pʉ 'bʉh ra Jesús bʉya, bi 'yørpa ra ts'ɛdi da zixpʉ Capernaum bʉ ná 'bɛn a rá ts'ʉnt'ʉ, da xospi nguetho nde da du a. ");
INSERT INTO otmNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nɛ bi dą a ra Jesús: ―Pɛ ha jatho m'bɛt'o guin nuhʉ yʉ hmɛpya nɛ yʉn t'øt'e nuįxte, ja gui 'yɛ̨c'yɛigahʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pɛ man'da i humbi sits'i, nɛ bi 'yɛ̨mbi: ―Pɛ mbɛhma ts'ʉ cuø, xøhma da du ma t'ʉhnigä. ");
INSERT INTO otmNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nɛ bi dąt'a ra Jesús: ―Ní mba bá nu, nguetho hin da du ni t'ʉhni. Nɛ nubʉya bi 'yɛ̨c'yɛi a rám hman a ra Jesús, nɛ bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nɛ bá thą ʉ 'da yʉ́ 'yɛ̨hɛ 'bʉ mím mba bʉ 'yu bi xifi: ―Bi zä ni ts'ʉnt'ʉ ya, ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nɛ bi 'yänni: ―'Bɛ'a ma ora bi zä. Nɛ bi t'ɛ̨mbi: ―N'dande mande bi bøn ra pa, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nɛ 'bex bi bą'a rá ta gue gue'a ra ora mín yąui ra Jesús 'bʉ mí 'yɛ̨mbi da yąn a rá ts'ʉnt'ʉ. Janangue'a nu'a ran 'yohʉ bi däp rá mbʉi ra Jesús bʉya, nɛ'ʉ gätho mi'da 'bʉpʉ rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Guehna bi 'yøt' ra Jesús 'bʉ mambá penje bʉ Judea dá sømhbe bʉ Galilea. Ya ná yondį ra hmɛpya bi 'yørpʉ ja ra häi Galilea. ");
INSERT INTO otmNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","M'bɛjua bʉya bin ja man'da ra dąmpɛti ma mijudíohe. Nɛ dá mbähmbe ra Jesús bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nubʉ Jerusalén mí po bʉ n'da ra mbothe mbɛ häntho bʉ ja rá goxthi yʉ dɛ'yo, gue ma ndehe dyʉ judíohe dí ɛ̨mfe Betesda. Nɛ jabʉ cʉt'a yʉ 'døzangu midí mbä'ts'a ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nɛ xʉn ngu i 'bom bʉ yʉ mbɛdi, 'da ʉ yʉ xädä nɛ ʉ yʉ dogua nɛ ʉ bi ts'a yʉ́ ją'i. Nɛ gätho ʉ i tø'mi di 'yąn ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nguetho ja'bʉ bí ɛ̨h mahɛ̨ts'i n'da rám 'bɛhni Oją nɛ i ąn ra dehe. Nɛ nu'bʉ xʉn nu di 'yąn ra dehe, nɛ nu'a rá mbʉdi da yʉpʉ ja ra dehe din ho a rá mbɛdi i ja. ");
INSERT INTO otmNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nɛ mí 'bɛm bʉ n'da ran 'yohʉ, ya ná 'däte ma 'dɛ'ma hyąto njɛya madí ts'a rá ją'i, him mi sä din 'yo. ");
INSERT INTO otmNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nɛ nu'bʉ min nu a ra Jesús, nɛ bi bądi nya'a thoho mi hɛ̨mbi, bi 'yɛ̨mbi: ―Ha guín nde xtán ho i, bi 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Bi dąt'a ra mbɛdi: ―Dín ndehma thą, n'yø, pɛ njongui 'bʉcua da zixcä nʉ ja ra dehe. N'dandį ngu n'dandį dí ɛ̨na ga cʉhnʉ ja ra dehe, 'bex go i 'bɛt'o ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Bi 'yɛ̨mp'a ra Jesús bʉya: ―Dami ndants'i jʉx ni fįdi nɛ gan 'yo, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","'Bex bin hoh rá ją'i 'bʉ mí ndants'i, nɛ bi gąx rá fįdi nɛ bin 'yo. Nɛ nu'a gue'a ra pa ran ts'äya a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nu'ʉ 'da ma mijudíohe bi 'yɛ̨mp'a ran 'yohʉ xín hoh rá ją'i: ―Nuya ra pa ran ts'äya ya, hingui sä gui cąx ni fįdi, bi t'ɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bi dą'a ran 'yohʉ: ―Pɛ nu'a bi hoga ma ją'i, gue'a bi xiqui nguetho bi 'yɛ̨ngui: “Dami ndants'i gui cąx ni fįdi nɛ gan 'yo,” bi 'yɛ̨ngui, bi 'yɛ̨n'a mí ts'a rá ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nɛ nu'ʉ 'da ma mijudíohe bi 'yänni: ―To'o nín 'yohʉ bi xi i gui cąx ni fįdi nɛ gan 'yo, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pɛ nu'a him mi pądi to'o xí hocpa rá ją'i, nguetho nu ra Jesús bi yʉt'inde bʉ 'yo yʉ ją'i xʉn ngu. ");
INSERT INTO otmNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","M'bɛjua bi mba ra Jesús bʉ ja ra dąnija. Nɛ nu'bʉ mi dįn'a ran 'yohʉ bʉya, bi 'yɛ̨mbi: ―Bin ho a ya, nde'bʉ hin gmi 'yøt' mi'da yʉ ts'oqui. Man'da ts'ɛdi ran ʉnbi guin nu 'bʉ gui 'yøt' mi'da yʉ ts'oqui, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","'Bex bi mba a ran 'yohʉ bʉya, da xi ʉ ma mijudíohe xí 'yänni, gue gue'a ra Jesús bi hoqui. ");
INSERT INTO otmNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Janangue'a bi dʉp'ʉ ma ngʉrpihe dyʉ judíohe di ʉcpa ra Jesús, nɛ im bɛ̨ni da hyo. Nguetho ɛ̨n'ʉ: “I øt' rá 'bɛfi a ra pa ran ts'äya.” ");
INSERT INTO otmNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nząi dim pɛh ma Ta, janangue'a nɛcä jatho dam pɛcä, bi 'yɛmp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pɛ nanguehna bi man ra Jesús, nu'ʉ ma ngʉrpihe bʉya man'da bi bɛ̨ni da hyo, nguetho hinga hønt'a bim pɛfi ra pa ran ts'äya í ʉcpi, pɛ nɛ'a í ma gue gue'a Oją rá Ta, nam bøni 'da i guui Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Janangue'a nu ra Jesús bi 'yɛ̨na: ―Majuąni dí xi ahʉ, nte sä ga øzɛhɛgä pɛ hønt'a 'bɛ'a dín nu øt' ma Ta. Nɛ gätho 'bɛ'a i øt' ma Ta, gue'a dí øt'ä a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nguetho nu ma Ta ɛ̨mmɛ in numanhogui ngue rá Ts'ʉnt'ʉgä a, nɛ i urqui 'bɛ'a gätho i øt'e. Nɛ da 'yurcä mi'da yʉn t'øt'e man'da nuįxte xinda gue ʉ gán nuhʉ, nɛ gui hyonya thohohʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nguetho tengu ma Ta i xox'ʉ xʉn du nɛ di un ra te mahøn'a, nguthogä, rá Ts'ʉnt'ʉgä a, dadí un ra te mahøn'a ʉ to'o gätho dín nde ga unni. ");
INSERT INTO otmNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nɛ nu ma Ta hingui juąnbatesɛ, pɛ bi 'dacä ra ts'ɛdi go dan juąnbategä rá Ts'ʉnt'ʉgä a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nguetho in nde ma Ta gätho yʉ ją'i da numansugui gue rá Ts'ʉnt'ʉgä a, tengutho ma Ta i hnumansu. Nu'bʉ 'bʉ a n'da hingui numansugui, xinga gue ma Ta i numansu a, gue gue'a bá pɛngä. ");
INSERT INTO otmNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Majuąni dí xi ahʉ, nu'a øh mam hmangä nɛ i ɛ̨c'yɛi ma Ta bá pɛngä, gue'a i ja ra 'da'yote maząi a. Nɛ hin da nu rá muui rá ts'oqui pɛ tengutho 'bʉ xí thąmbɛ̨ni bʉ 'bʉ ʉ xʉn du, nguetho ya i ja ra 'da'yote maząi a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Majuąni dí xi ahʉ, ya bi zøn ra ora da 'yøh mam hmangä ʉ xʉn du nangue yʉ́ mbʉi, pɛgue din t'un ra 'da'yote 'bʉ da 'yømanho mam hmangä rá Ts'ʉnt'ʉ Ojągä. ");
INSERT INTO otmNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nguetho tengu ra Ta i jasɛ ra te rá mbʉi, nɛ bi 'dacä ra ts'ɛdi din jasɛ ra te ma mbʉigä, nɛ gue'a ra 'da'yote dí un yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nɛ bi 'dac ra ts'ɛdi dan juąnbategä, nguetho dán ją'igä ua ja ra ximhäi, dí pądi 'bɛ'a i sä n'da. ");
INSERT INTO otmNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","O gadi hyonya thohohʉ a dá xi ahʉ, nguetho da zøn ra ora gätho yʉ ją'i xʉ t'ägui da 'yøh ma nde 'bʉ dá zohni. ");
INSERT INTO otmNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nɛ da bøx'ʉ bi 'yøt' ran ho, din ja ra 'da'yote maząi. Nɛ da bøx'ʉ bi 'yøt' ran ts'o, da nu ran ʉnbi maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nɛ man'da bi man'a ra Jesús, bi 'yɛ̨na: ―Nugä hin te dím mangä nangue man 'yomfɛ̨nisɛ. Pɛ nu'a i xic ma Ta gue'a dím mangä a. Nɛ'a 'bɛ'a dí sändä, xʉn ho a, nguetho him ma pähä zɛhɛ dí honi ga øt'ä, pɛ hønt'a rá pähä ma Ta bá pɛngä. ");
INSERT INTO otmNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nu'bʉ høngdä xcá däsɛ majuąni gue i ja ma ts'ɛdi, nte di muui a mam hmangä 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pɛ nɛ a ma Ta di dä majuąni ngue rá Ts'ʉnt'ʉgä a, nɛ dí pącä ngue majuąni im ma 'bʉ im ma nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nu ahʉ gá pɛnhdʉ 'da da 'yän'na ra Xuua Nxixyą nanguecä. Nɛ nu'a ra Xuua bi ma majuąni a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nɛ madague'bʉ hin xtí dä majuąni, pɛ guemhma ja ma ts'ɛdigä. Pɛ dadí bɛ̨n'nahʉ a bi man ra Xuua Nxixyą ngue man'da da zä gui 'yɛ̨c'yɛigahʉ nɛ gan yąmhbʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nɛ tengu ra sibi di hyät'i nɛ i fät yʉ zu'uɛ̨, bin ja bʉ ra Xuua Nxixyą, gá numanhohʉ 'da yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nɛ nu'a ra Xuua Nxixyą bi ma nanguecä. Pɛ i ja 'bɛ'a gue man'da i udi nanguecä xinda gue'a rám hman ra Xuua, nɛ gue'a ra 'bɛfi bi 'dacä ma Ta gue ga juacä. Nɛ gue'a ɛ xø i uh majuąni bá pɛngä ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nɛ'a ma Ta gue'a bá pɛngä, di dä majuąni nanguecä, pɛ nu'ahʉ njąm'bʉ gá 'yømanhohʉ 'bʉ mín yą, xín gá 'yørpahʉ ra güɛnda 'bʉ mín 'yusɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mfądi hin gá hyąmhbʉ rám hma bʉ ja ni mbʉihʉ, nguetho nu'bʉ xquí hyąmhbʉ a, xquí 'yɛ̨c'yɛigahʉ gue bá pɛngä a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nu ahʉ thocpa thoho guidín xähmbʉ yʉ́ søcuą Oją, nguetho guí ɛ̨mhbʉ gue'a gní tįmhbʉ ra te maząi a. Pɛ nu'ʉ gätho yʉ søcuą guidín xähmbʉ gätho im ma nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nu ahʉ hin guín nde gui xijʉ gan yąn'na ni tehʉ, pɛ hinda hønt'bʉ gui xijʉ gan yąn ahʉ din ja ahʉ ra te maząi 'bʉ, bi 'yɛ̨n a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nɛ xø bi 'yɛ̨na: ―Pɛ madague'bʉ njon da numansugui, pɛ guexta'a rá Ts'ʉnt'ʉgä Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pɛ dí pądi hanja hin guí pąjʉ, nguetho hín guín numansuhʉ Oją nangue ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bá ɛ̨cä nangue rá thuhu ma Ta, pɛ nu'ehʉ hin guín numanhojʉ. Pɛ nu'bʉ ba ɛ̨ a n'da nangue rá thuhu zɛhɛ, man'da guín numanhohʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Njąm'bʉ da zä gui 'yɛ̨c'yɛigahʉ, nguetho guí homhbʉ da numanho ahʉ yʉ ją'i, nɛ hin guí homhbʉ da numanho ahʉ Oją ngue hønt'a i 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ha guí ɛ̨mhbʉ guecä ga yąp'ahʉ bʉ 'bʉh ma Ta. Pɛ dí xi ahʉ gue gue'ʉ yʉ́m hman ra Moisés gue'ʉ dí nɛqui i ja ni ts'oquihʉ ʉ, pɛ sä guím bɛ̨mhbʉ gue'ʉ dí yąn'ahʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pɛ nu'bʉ xquí 'yɛ̨c'yɛihʉ yʉm hma bi 'yo't' ra Moisés, xquí 'yɛ̨c'yɛigahʉ ya, nguetho bi ma nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pɛ hin guí ɛ̨c'yɛihʉ 'bɛ'a bi 'yo't' ra Moisés, janangue'a xín guí ɛ̨c'yɛihʉ 'bɛ'a dí mangä ya, bi 'yɛ̨n'a ra Jesús 'bʉ min yąhʉ ma ngʉrpihe dyʉ judíohe. ");
INSERT INTO otmNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nɛ nu'bʉ mí tho i 'da yʉ pa, m'bɛjua bʉya, dá mbähmbe ra Jesús bʉ 'danguadi ra dądehe Galilea, n'dat'a ra dądehe Tiberias. ");
INSERT INTO otmNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nɛ xʉn ngu yʉ ją'i bi dɛngähe nguetho bi nu yʉn t'øt'e nuįxte bi 'yøt'a ra Jesús nangue ʉ mín zäman'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nɛ dá mbähmbe ra Jesús bʉ ja n'da ra nyuni, nɛ dá huhmbe bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nɛ nu'ʉ yʉ pa ʉ mí ts'ʉtho da zøn ra pa ga øt'ähe ra dąmpɛti ran dąbaxjua, dyʉ judíohe. ");
INSERT INTO otmNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nɛ nu'a ra Jesús bin hanni nɛ bi hyandi xʉn ngu yʉ ją'i ba ɛ̨pʉ. Nu'a ra Jesús bi 'yɛ̨mp'a ra Felipe bʉya: ―'Bɛpʉ dí zä ga tämhbʉ 'bɛ'a da zi yʉ ba ɛ̨hnʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Gue'a bi man ra Jesús nguetho in nde da bądi 'bɛ'a dí dąt'a a ra Felipe. Pɛ nu ra Jesús mí pąsɛ 'bɛ'a da 'yøzɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nɛ bi dąt'a ra Felipe: ―Pɛ hin dí gua'ʉ yʉ mahuąhi tho dá tämhbʉ a da zi yʉ ba ɛ̨hnʉ 'bʉ di ja, madague'bʉ zʉ ts'ʉtho din t'unni n'da ngu n'da, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Nɛ nubʉya nu'a man'da ma mixädihe ra Andrés, rán 'yohʉ ra Simón Pedro, bi xi a ra Jesús: ―'Bʉcua n'da ra ts'ʉnt'ʉ i hą zʉ ts'ʉ rán zɛdi, gue cʉt'a yʉ hmɛ ra cebada, nɛ yoho yʉ t'ʉhuą. Pɛ hin dí gua'ʉ yʉ ją'i nguetho xʉn ngu ʉ, bi 'yɛ̨n'a ra Andrés. ");
INSERT INTO otmNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nɛ bi 'yɛ̨ngdahe ra Jesús: ―Jafʉ din säya yʉ ją'i, bi 'yɛ̨na. Nguetho mi ja bʉ ra 'bot'ɛi. Nɛ bi hyupʉ häi bʉya, nɛ mí jua i cʉt'a mahuąhi ʉ yʉn 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nɛ nu'a ra Jesús bi hyąn'a ra hmɛ, nɛ bi 'yäp rán jąpi Oją nangue ra hmɛ nɛ bi 'daje yʉ́ xädigähe. Nɛ nugähe dá darpähe ʉ yʉ ją'i bʉya, nɛ ʉ yʉ huą, nɛ bin niyą gätho yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nɛ nu'bʉ mín niya yʉ ją'i, nu ra Jesús bi xicähe: ―Pɛthʉ ʉ gätho 'bɛ'a bi bongui, gue nte dim 'bɛdi, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nɛ nu'bʉ má pɛthe bʉya bi yu ʉ gätho 'dɛ'ma yoho ma 'bøts'ehe yʉ xɛqui, 'bʉ mín niyą yʉ ją'i nangue cʉt'a yʉ hmɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nu'bʉ mín nu ran t'øt'e nuįxte ʉ gue bi 'yøt'a ra Jesús, bi 'yɛ̨n'ʉ bʉya: ―Masque majuąni guehna ra pøngahyą mí hma da zøcua ja ra ximhäi, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pɛ nu'a ra Jesús bi bądi 'bɛ'a mbɛ̨n ʉ yʉ ją'i ngue nde da bɛnt'i, im bɛ̨nbi din ts'ʉt'abi. Janangue'a bi zoh yʉ ją'i bʉya, bi mbasɛ, nɛ man'da bi guam bʉ ja ra dąpo. ");
INSERT INTO otmNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nu'bʉ mín de bʉya dá mbäsɛhe bʉ ja ra dądehe. ");
INSERT INTO otmNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nɛ dá hux ma mbosahe, gue ga sømhbe bʉ ja ra hnini Capernaum. Nɛ hin ná nuthe ra Jesús 'bʉ mí zʉje ra 'bɛxui. ");
INSERT INTO otmNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nɛ nts'ɛdi bi 'yɛn ran dąhi a ra dehe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nu'bʉ mí dąn i ts'ʉ ra mbosa mí huxhe nɛ dá sømhbe made ra dądehe, dá nuhe ba ɛ̨pʉ ra Jesús, ba 'yo maxøts'e ra dehe, ní 'yɛ̨pʉ ja a ra mbosa mí huxhe. Nɛ ɛ̨mmɛ dá suhe nguetho him min nuhe xʉn ho, him mi pąhmbe ngue gue'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nu ra Jesús bi 'yɛ̨nje: ―Guecä, o guín suhʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nɛ bi hyu ma mbʉihe, nɛ dá xihmbe a ra Jesús da hyuxpʉ ja ra mbosa. Nɛ ɛ̨na ya xmí 'bähmbe bʉ ndenthe ná mbähmbe bʉya nubʉ ra hnini Capernaum. ");
INSERT INTO otmNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nu'bʉ mí nɛc pʉya, nu'ʉ yʉ ją'i 'bʉpʉ hapʉ xí 'uįn a ra Jesús, bi bɛ̨m bʉya gue hønt'a n'da ra mbosa mí høpʉ a ran de dán sihmɛhe, nɛ hin dá mbähmbe ra Jesús 'bʉ má huhe ra mbosa, pɛ dá mbäsɛhe. ");
INSERT INTO otmNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pɛgue m'bɛjua thoho bi zøm bʉ mi'da yʉ mbosa bí nɛxpʉ Tiberias, nɛ bi zøm bʉ jom bʉ dán sihmɛhe 'bʉ mí 'yäp rán jąpi Oją ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nɛ nu'ʉ yʉ ją'i 'bʉ mí hyon'a ra Jesús nɛ him bi dįm bʉ, xínga guecähe, bi hyux'ʉ mi'da yʉ mbosa bʉya nɛ bi zøm bʉ ja ra hnini Capernaum, i hon a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nɛ nu'ʉ yʉ ją'i 'bʉ mí dįm bʉ ra Jesús bʉ 'danguadi ra dądehe, bi 'yänni: ―Mán jąm'bʉ gá søcua, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Majuąni dí xi ahʉ, hin gní hyonjʉ gue gui pąhmbʉ a ran t'uti dá ut'ahʉ, pɛ nu'a guín niyąhʉ 'bʉ gmín sihmɛhʉ gue'a gní hyonjʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pɛ dami 'yɛs'hʉ ngue hønt'a gní hyomhbʉ ra hmɛ nám 'bʉhmbʉ yʉ pa ja bʉya. Pɛ m'bɛt'o thoho dami hyomhbʉ a ra hmɛ nám 'bʉh maząi n'da a gue ga 'da ahʉ, guecä dán ją'igä ua ja ra ximhäi. Nguetho gue'a ran t'ɛ̨di bi 'dac Oją ma Ta, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nu yʉ ją'i bʉya bi 'yän'na ra Jesús nɛ bi 'yɛ̨mbi: ―'Bɛ'a sä ga øt'ähe gue ga tįmhbe a guím ma, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nu'a ra Jesús bi dądi: ―Nu'a in nde Oją gui 'yøthʉ gui sinjʉ bʉ ni mbʉihʉ, guecä bá pɛngä Oją, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nɛ bi t'ɛ̨mp'a ra Jesús: ―'Bɛ'a ní hmɛpya gui 'yurcähe, ngue da zä ga sin ahe bʉ ma mbʉihe. Ha da zä gui 'yøt'e tengu bi 'yøt'a ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nguetho nu'ʉ mam bombøtahʉ bi zi ra maná 'bʉ mí 'yo bʉ ja ra ʉhäi, tengu mán t'o't'i bʉ ja rá søcuą Oją, i ɛ̨na: “Nu'a ra Moisés, bi un yʉ ją'i ra hmɛ bí 'yɛ̨h mahɛ̨ts'i,” i ɛ̨na, bi 'yɛ̨n'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Majuąni dí xi ahʉ, hinga gue'a ra Moisés bi un'a ra hmɛ bí 'yɛ̨h mahɛ̨ts'i, pɛ Oją bi un a. Nɛ hinga gue'a ra hmɛ nám 'bʉh maząi n'da a ra maná mi si ʉ. Pɛ nuya, nu ma Ta di un a njuąntho ra hmɛ mahɛ̨ts'i gue nám 'bʉh maząi n'da a. ");
INSERT INTO otmNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nɛ nu'a njuąntho ra hmɛ di un Oją, bí 'yɛ̨h mahɛ̨ts'i a, gue dám 'bʉh maząi ʉ yʉ ją'i 'bʉcua ja ra ximhäi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nɛ bi 'yɛ̨n'ʉ: ―'Daje thocpa thoho a ra hmɛ guím ma, n'yø. ");
INSERT INTO otmNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Guecä drá hmɛ dám'bʉh maząi n'da a. Nu'a to'o da zingä bʉ ja yʉ́ mbʉi tengu'bʉ i sihmɛ, nɛ njąm'bʉ din tumanthuhu yʉ́ mbʉi nɛ xín din tuthe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pɛ tengu dá xi ahʉ, hin guí ɛ̨c'yɛigahʉ, madague'bʉ gá nuhʉ 'bɛ'a dá øt'ä. ");
INSERT INTO otmNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pɛ nu'ʉ to'o bi 'dacä ma Ta, gue'ʉ di däcä yʉ́ mbʉi ʉ. Nɛ nu'ʉ di däc yʉ́ mbʉi, njon ga ɛ̨mbi hin da zä ga sini. ");
INSERT INTO otmNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nguetho bá ɛ̨cä mahɛ̨ts'i ngue ga øt' rá pähä a bá pɛngä, nɛ him bá ɛ̨cä ga øt' ma pähä zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nu'a rá pähä ma Ta bá pɛngä, gue'a nte ga 'bɛcä gätho bi 'dacä, pɛ ga xoxä ʉ 'bʉ rán zɛgui ra pa, nɛ dim 'bʉi maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nu rá pähä ma Ta, gue hønt'a go to'o da bądi rá Ts'ʉnt'ʉgä Oją, nɛ da 'yɛ̨c'yɛigui, din ja ra te maząi ʉ. Janangue'a ga xoxä ʉ 'bʉ rán zɛgui ra pa, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nɛ bi mbʉdi bi ʉcpa a ra Jesús ʉ ma mijudíohe 'bʉ mí 'yø a bi ma, gue bi 'yɛ̨na: “Nugä drá hmɛ majuąni gue bá cąh mahɛ̨ts'i.” ");
INSERT INTO otmNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nɛ bin 'yɛ̨mzɛhɛ ʉ: ―Ha hinga guehna ra Jesús, rá ts'ʉnt'ʉ ra José na, rá ta nɛ rá mbe dí pąhmbʉ. Hanja ní 'yɛ̨na bí 'yɛ̨h mahɛ̨ts'i, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ bʉya: ―O gadí c'ąman'ʉjʉ n'da ngu n'da ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xínga n'da sä da dɛngui 'bʉ hin di un ra pähä a ma Ta, gue'a bá pɛngä, nɛ ga xoxä 'bʉ rán zɛgui ra pa ʉ, ga undä ra te maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tengu mán t'o't'i bʉ ja yʉ́ søcuą yʉ́ pøngahyą Oją, bi 'yɛ̨na: “Gätho yʉ ją'i da xänba Oją,” bi 'yɛ̨n'ʉ. Janangue'a nu'ʉ to'o gätho bi hyąni xʉn ho a bi xänba Oją, nɛ gue'ʉ di däc yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pɛ hin dí ɛ̨na 'bo'o xʉn nu Oją, hinda høngdä gue bá nɛxä bʉ, dín nugä a. ");
INSERT INTO otmNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Majuąni dí xi ahʉ, nu'a to'o ɛ̨c'yɛigui i ja ra 'da'yote maząi a. ");
INSERT INTO otmNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nugä drá hmɛ majuąni gue nám 'bʉh maząi n'da. ");
INSERT INTO otmNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nu'ʉ mam bombøtahʉ bi zi ra maná bí 'yɛ̨h mahɛ̨ts'i 'bʉ min 'yo bʉ ja ra ʉhäi, pɛ guehma bi du ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pɛ nugä drá hmɛ majuąni, bá nɛxä bʉ mahɛ̨ts'i, gue sä da zin'a n'da tengu'bʉ i sihmɛ, nɛ njąm'bʉ da du. ");
INSERT INTO otmNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nugä drá hmɛ majuąni, bá ɛ̨cä mahɛ̨ts'i, tengu ra hmɛ i si n'da i ja rán zaqui yʉ pa i ja bʉ ya. Pɛ nu'a ra hmɛ dím mangä, din ja ran zaqui maząi to da zi. Nɛ gue'a ma ją'igä a gue ga uni, ngue din ja ra 'da'yote ʉ 'bʉcua ja ra ximhäi, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bin junzɛhɛ ʉ ma mijudíohe bʉya, bin 'yɛ̨mzɛhɛ ʉ: ―Hague nja ran 'yohʉ sä di 'dajʉ rá ją'i ga sahʉ, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nɛ nu ra Jesús bi dąt'ʉ: ―Majuąni dí xi ahʉ, nu'bʉ hin gui sihʉ ma ngøc'yɛ̨i nɛ ma ji, guecä dán ją'igä ua ja ra ximhäi, hin'yʉ mbo ni mbʉihʉ ra 'da'yote maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nu'a to'o da za ma ngøc'yɛ̨i nɛ da zi ma ji, i ja ra 'da'yote maząi, nɛ ga xox 'bʉ rán zɛgui ra pa. ");
INSERT INTO otmNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nguetho nu ma ngøc'yɛ̨i nɛ ma ji njuąntho ran ts'ihmɛ ngue dám 'bʉh maząi n'da. ");
INSERT INTO otmNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu'a to'o da za ma ngøc'yɛ̨i nɛ da zi ma ji dí ząm bʉ ja yʉ́ mbʉi, nɛ i ja ra te nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tengu thoho dí øt'be ma Ta, nu'a i jasɛ rá te, nɛ i jagä ra te nangue'a bʉya. Nɛ bá pɛngä gue ga thocpa a ra te ʉ to da zingä, tengu'bʉ i sagä. ");
INSERT INTO otmNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nuna ra hmɛ dí xi ahʉ gue bá cąh mahɛ̨ts'i, hinga ngu a bi zi mam bombøtahʉ, nguetho bi du ʉ. Pɛ nu'a to'o da zi ra hmɛ dím mangä ya, gue'a dím 'bʉh maząi a, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nɛ guehna ram hma bi man'a ra Jesús 'bʉ mín xänbate bʉ ja ra niją bʉ Capernaum. ");
INSERT INTO otmNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nu'bʉ mí gua'a bi man ra Jesús, bi 'yɛ̨n'ʉ mí tɛnni: ―Hingui ho a bi xijʉ nʉ ya, to'o da hyät'i da 'yøde, xʉn ngu ʉ bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nu ra Jesús bi bądi 'bɛ'a bi bɛ̨n'ʉ yʉ ją'i, gue him bi numanho rám hma, nɛ bi 'yɛ̨mp'ʉ: ―Ha guím bɛ̨mhbʉ hingui ho a dá xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Bɛ'a guim bɛ̨mhbʉ 'bʉ gá nujʉ ga texä bʉ mahɛ̨ts'i guepʉ bá nɛxä, guecä dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pɛ nu'a nam bøn'ʉ yʉm hma dá xi ahʉ, hingan juąntho gui sajʉ, pɛ gui 'yɛ̨c'yɛihʉ ngue ga un ma te nangue ahʉ, nɛ din ja ahʉ ra te bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pɛ 'bʉ i 'da ahʉ hin guí ɛ̨c'yɛigahʉ, bi 'yɛ̨n'a ra Jesús. Nguetho xmí pądi to'o hin da 'yɛ̨c'yɛi, nɛ xmí pądi to'o di dä a. ");
INSERT INTO otmNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nɛ bi 'yɛ̨mp'ʉ mahøn'a: ―Janangue'a dá xi ahʉ, hingui sä n'da ra ją'i ba ɛ̨hɛ da dɛngui 'bʉ him bi jap'a ma Ta bi däc rá mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nu'bʉ mí 'yøh mahøn'a ʉ mí tɛnni, xʉn ngu bi 'ue ʉ nɛ him bin 'yohʉ mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Janangue'a nu ra Jesús bi 'yängahe dí 'dɛ'mayohogähe: ―Ha nɛ ahʉ gui sogahʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nu ra Simón Pedro bi dąt'a: ―Ma Hmu i, pɛ njo'o man'da da zä ga tɛnhde nguetho nu'i ja nim hma di un ra 'da'yote maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nɛ nugähe dí ɛ̨c'yɛi ahe nɛ dí pąhmbe gue gue'e grá Cristo rá Ts'ʉnt'ʉ i Oją i 'bʉi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Bi dą'a ra Jesús: ―Nugä xtá huan'nahʉ guí 'dɛ'mayohohʉ, pɛ nu'a n'da ahʉ i tɛn ra zįthu, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pɛ nu'a bi man ra Jesús, gue'a ra Judas a, rá ts'ʉnt'ʉ ra Simón Iscariote, nguetho gue'a di dä a. Nɛ gue'a n'da mín 'yohe a, mí 'dɛ'mayohogähe. ");
INSERT INTO otmNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","M'bɛjua bʉya, bin 'yo bʉ mi'da yʉ hnini bʉ Galilea. Him bi nde bi mba bʉ ja ra xɛqui Judea, nguetho nu ma ngʉrpihe dyʉ judíohe, dyʉ israelhe, nde xtá hyo bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nɛ ma guepʉ da dät ra pa ngue ząi dim pɛti ma mijudíohe, 'bʉ xʉ hyøh yʉ t'ʉngu, im bɛ̨ni 'bɛ'a bi 'yørpa Oją ʉ mam bombøtahe 'bʉ min 'yo bʉ ja ra ʉhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nu yʉ́n 'yohʉ a ra Jesús bi 'yɛ̨mbi: ―Nde'bʉ gui pøngua ní mba bʉ ja ra xɛqui Judea, ba nu a bʉ i tɛn'ni i nangue'a guí øt'e. ");
INSERT INTO otmNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nguetho njo'o to da 'yąh rá 'bɛfi 'bʉ in nde da t'ɛ̨spi. Nu'bʉ majuąni guí øt' yʉn t'øt'e nuįxte bá ut yʉ ją'i, nɛ gätho ra ximhäi da bą'a i, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ngubʉ bi xih yʉ́n 'yohʉ nguetho him mi ɛ̨c'yɛi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nu a ra Jesús bi 'yɛ̨mp'ʉ bʉya: ―Hinga na søn ra ora bi ts'ängä ga mbagä bʉ, pɛ nu'ahʉ hønt'a go 'bɛ'a má ora da zä gui mbähä bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nu'ʉ 'bʉcua ja ra ximhäi hin di ʉc'ahʉ nguetho 'da i gu guí øthʉ ʉ, pɛ go di ʉgä ʉ nguetho dím mangä gue hingui ho øt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ní mbäsɛhʉ 'bʉ guín ndehʉ, nugä hin ga mba ya nguetho hinga na søn ra ora ga mba bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nu'bʉ mí gua'a bi man bʉya bim 'bʉt pʉ mi'da yʉ pa bʉ ra xɛqui Galilea. ");
INSERT INTO otmNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nu'bʉ mí mba bʉ Jerusalén ʉ yʉ́n 'yohʉ, m'bɛjua bi mba bʉ ra Jesús. Mbɛ bin 'yąntho nguetho bi nde him 'bexque da hnu. ");
INSERT INTO otmNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nɛ nu ma ngʉrpihe dyʉ judíohe i 'bʉpʉ, bi hyon'a ra Jesús bʉ ja ram pɛti. Nɛ bin 'yɛ̨m zɛhɛ ʉ: ―Hapʉ i 'bʉi 'bʉ, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nɛ xʉn ngu yʉ ją'i bin yąnjo'dre nangue'a ra Jesús, nu'ʉ 'da im ma ngue xʉn ho a, nɛ nu'ʉ 'da i ɛ̨na: “Häte a.” ");
INSERT INTO otmNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pɛ xinga n'da bin yą ts'ɛdi nangue'a ra Jesús nguetho i su ma ngʉrpihe 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nu'bʉ mí tho'i ts'ʉ yʉ pa, ya bi zo i nde yʉm pɛti i t'ørpʉ, ja bi mba bʉ ja ra dąniją ra Jesús bʉya nɛ bin xänbate bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nɛ nu ma ngʉrpihe bʉ ja ra niją bi hyonya thoho nɛ bi 'yɛ̨n'ʉ: ―Hague nja i sä da ma xʉn ho rám hman Oją na ran 'yohʉ, nɛ him bi zʉ'a man xädihʉ, bin 'yɛ̨m zɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Bi dą a ra Jesús: ―Nu'a man xädigä him mam hmansɛgä a pɛgue rám hman a to bá pɛngä. ");
INSERT INTO otmNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nu'bʉ 'bʉ a n'da gue nde da 'yøt' rá pähä Oją, da bą 'bʉ rán xädi Oją, o gue da bą 'bʉ mam hmansɛgä. ");
INSERT INTO otmNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nu'bʉ 'bʉ a n'da im ma 'bɛ'a mbɛ̨nsɛ, i honi da hnumansusɛ. Pɛ nu'bʉ 'bʉ a n'da i honi da t'ɛ̨spa rá hmu, im ma majuąni a nɛ hingui häte a. ");
INSERT INTO otmNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nɛ xø bi 'yɛ̨na: ―Bi 'dajʉ yʉn t'ɛ̨di ra Moisés, pɛ xínga n'da ahʉ guí øthʉ nguetho bi ma njon din hote, nɛ guín nde gui hyojʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nɛ bi dą'ʉ yʉ ją'i thoho: ―Masque bi bɛ̨n'na ra zįthu a gám ma, njo'o to in nde da hyo i, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nu ra Jesús bi dąt'ʉ: ―Nugä dá øt'a n'da ra 'bɛfi 'bʉ ra pa ran ts'äya, nɛ gätho ahʉ gá hyonya thohohʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Pɛ nɛ'ahʉ, nu'bʉ din tįn i yoho yʉn t'ɛ̨di bi man ra Moisés, nu'a n'da bi ma gue gui hyɛcpahʉ yʉ́ ją'i yʉ 'uɛre, nɛ nu man'da bʉya ra pa ran ts'äya, guí huanhdʉ nda'a guí øthʉ, gue guí hɛcpahʉ yʉ́ ją'i yʉ 'uɛre. Nguetho hin guín nde gui fɛstahʉ a rán t'ɛ̨di ra Moisés. Nɛ hinga hønt'a ra Moisés bi ma da thɛcpa yʉ́ ją'i yʉ 'uɛre, pɛ nɛ'ʉ mam bombøtahʉ bi ma. Nɛ ngutho dá øt' 'bʉ má hoc'a n'da ra hyɛ̨nni 'bʉ ra pa ran ts'äya. Hanja gní sʉjʉ nɛ gue'a n'youi bʉ rán t'ɛ̨di ra Moisés dá øt'ä. ");
INSERT INTO otmNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pɛ damin 'yomfɛ̨nihʉ xʉn ho 'bʉ guí ɛ̨na gui juąnbahʉ n'da ra ją'i. Jatho 'bɛ gui pąhmbʉ 'bɛ'a nam bøn'a i øt'a n'da, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nɛ nu'ʉ 'da yʉ mɛngu bʉ Jerusalén bin 'yɛ̨mp'ʉ: ―Ha hinga guehna ran 'yohʉ im ma ma ngʉrpihʉ da hyo. ");
INSERT INTO otmNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pɛ hague in ja, in xänbate ua bim pɛti gätho yʉ ją'i nɛ nte i xih ya. Uague bi bɛ̨n'ʉ ma ngʉrpihʉ gue majuąni ra Cristo na ra Jesús, gue bi huand Oją dim Hmu ua. ");
INSERT INTO otmNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pɛ nuna ran 'yohʉ, dí pąhmbʉ hapʉ bá nɛxna, pɛ nu'bʉ bá ɛ̨ a majuąni ra Cristo, njo'o to da bądi hapʉ dí nɛx'a, bin 'yɛ̨m zɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nu'bʉ mín xänbate ra Jesús bʉ ja ra dąniją, nts'ɛdi bi 'yɛ̨na: ―Guím bɛ̨mhbʉ guí pąjʉ nɛ guím bɛ̨mhbʉ guí pąhmbʉ hapʉ bá nɛxä. Pɛ hin bá ɛ̨cä nanguesɛgä, pɛgue bá pɛngä a majuąni i ja rá ts'ɛdi. Nu'ehʉ hin guí pąhmbʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nugä dí pącä a nguetho bá nɛxä bʉ i 'bʉ a, nɛ gue'a bá pɛngä a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nɛ 'bexque nde da bɛnt pʉya, pɛ njom bi zä bi bɛnt'i nguetho hin ní zøn ra ora da bɛnt'i. ");
INSERT INTO otmNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nɛ xʉn ngu yʉ ją'i bi 'yɛ̨c'yɛi gue majuąni ra Cristo a. Nɛ bi 'yɛ̨n'ʉ: ―Guehma majuąni ra Cristo na ra Jesús gue mí hma ba ɛ̨hɛ, nguetho njon da zä da 'yøt' yʉn t'øt'e man'da nuįxte, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nu'bʉ mí 'yøh yʉ fariseo nɛ yʉ dąmbäją 'bɛ'a bi man yʉ ją'i nangue'a ra Jesús, bi xi ʉ 'da yʉ asmayo bʉya da bɛnt'a ra Jesús ngue da got'i. ");
INSERT INTO otmNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nu'a ra Jesús 'bʉ mí thoqui bin xänbate, bi 'yɛ̨na: ―Mi ts'ʉtho dí 'bʉhmbʉ ua nguetho ga mba bʉ bí 'bʉ a bá pɛngä. ");
INSERT INTO otmNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɛ nu'ahʉ bʉya gui hyonjʉ pɛ hin da zä gui tįnjʉ, nɛ hin da zä gui sømhbʉ bʉ hapʉ dam 'bʉcä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nɛ bin 'yɛ̨mzɛhɛ ma ngʉrpihe: ―Hapʉ da mba gue hin da zä ga tįmhbʉ. Ha da mba bʉ n'danni 'bʉ ʉ ma mijudíohʉ, nɛ da xänba ʉ, nɛ'ʉ n'dan'yo yʉ ją'i gue yʉ griego. ");
INSERT INTO otmNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","'Bɛ'a ním bøn'a man'a: “Gui hyonjʉ nɛ hin gui tįnjʉ, nɛ hin da zä gui sømhbʉ hapʉ ga mba,” ɛ̨njʉ, bin 'yɛ̨mzɛhɛ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nu rán zɛgui ra pa nangue yʉm pɛti mí øt'ʉ, gue'a ra pa ɛ̨mb yʉ ją'i man'da xʉn ndʉxqui a. Nɛ 'bäpʉ ra Jesús nɛ nts'ɛdi im man'a: ―Nu'a to'o di 'bɛ a man'da mahyoni thoho rá mbʉi, tengu'bʉ i tuthe, ba ɛ̨hɛ ga un'na mahyoni thoho, tengu'bʉ da zi ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nɛ nu'a to'o da zi ra dehe dím mangä, din ja tengu n'da ra dąthe da nɛxpʉ rá mbʉi gue di un mahøn'a ra 'da'yote, tengu xí man rá t'ohni Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nɛ gue'a bi ma nangue rá Hogandąhi Oją da hyąni to'o gätho da 'yɛ̨c'yɛi. Pɛ hin ní zøh rá Hogandąhi Oją 'bʉ mím ma nguetho hin ní ndex mahɛ̨ts'i ra Jesús gue tpa pɛngahʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nu'bʉ mí 'yøh yʉ ją'i 'bɛ'a bi man ra Jesús, bi 'yɛ̨n i 'da: ―Masque majuąni rá pøngahyą Oją mí hma ba ɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nɛ nu mi'da bi 'yɛ̨na: ―Nu'a, ra Cristo gue rá Thahni Oją a. Pɛ nu mi'da bi 'yɛ̨na: ―Pɛ ha dí 'yɛ̨pʉ Galilea ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nguetho bi man rá t'ohni Oją, gue ra Cristo ba ɛ̨hɛ nangue rá 'yʉ ra David, nɛ di nɛqui bʉ ra hnini Belén guepʉ mí 'bʉh ra David, ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","'Bex bin hec yʉ ją'i nangue'a bi man'ʉ, nɛ 'dahma 'dan'yo 'bɛ'a mím bɛ̨ni ngue to'o a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nɛ 'da ʉ nde da bɛnt'i ngue da got'i, pɛ xínga n'da bi zä bi bɛnt'i. ");
INSERT INTO otmNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nu'bʉ mbenc'ʉ yʉ asmayo bʉ 'bʉ ʉ yʉ dąmbäją nɛ yʉ fariseo, nu'ʉ bi 'yänni: ―Hanja hin guá sihʉ a dá xi ahʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nɛ nu yʉ asmayo bʉya bi dądi: ―Pɛ him mí 'bʉ a n'da im ma tengu man'a ra Jesús, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nɛ bi dą ʉ yʉ fariseo bʉya: ―Ha nɛ ahʉ bi hyä ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pɛ xínga n'dagähe dyʉ fariseohe dí ɛ̨c'yɛihe a, xínga gue'ʉ mi'da ma mingʉrpihe. ");
INSERT INTO otmNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pɛ nu ʉ yʉ ją'i thoho gue hingui pąh yʉn t'ɛ̨di, hønt'ʉ i ɛ̨c'yɛi a ran 'yohʉ ʉ, pɛ da nu ran ʉnbi maząi ʉ, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nɛ nubʉya nu ra Nicodemo, gue'a xí zøm bʉ 'bʉh ra Jesús 'bʉ n'da ra xui, bi 'yɛ̨mp'ʉ yʉ́ mifariseohʉ: ");
INSERT INTO otmNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Nu'a man t'ɛ̨dihʉ, hingui sä ga juąnbahʉ n'da ra ją'i 'bʉ hin dá øhmbʉ 'bɛ'a da mansɛ, nɛ'bʉ hin dí pąhmbʉ majuąni 'bɛ'a i øt'e, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nɛ bi dą ʉ, bi 'yɛ̨mbi: ―Nu'i tengu'bʉ nɛ'i guí 'yɛ̨pʉ Galilea, nguetho nɛ'i guím ma tengu im man yʉ 'yąmbʉi. Pɛ dami hyomhbʉ ja rá søcuą Oją gue'bʉ di nɛqui bʉ Galilea n'da rá pøngahyą Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nɛ n'da ngu n'da bi mba yʉ́ ngu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pɛ nu ra Jesús bi mba bʉ ja ra nyuni Olivos. ");
INSERT INTO otmNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nɛ nu'bʉ t'ʉxudi tho bi mbeng bʉ ja ra dąniją mahøn'a nɛ bi hyupʉ. Nɛ gätho nan ngu yʉ ją'i bá ɛ̨hɛ nangue'a nɛ bi xänba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ya xí yą bʉ ra Jesús 'bʉ mí zøm bʉ yʉ fariseo nɛ yʉ xänbate niją, bi zispa n'da ra xisu gue bi nu 'bʉ mín yąui n'da ran 'yohʉ hing rá ndø. Nɛ bi mbä'minde bʉ 'bʉh yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bi 'yɛ̨mp'a ra Jesús: ―Xänbate, nuna ra xisu dá tįmhbe bʉ i øt' ran 'yomt'ɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nɛ nu ran t'ɛ̨di bi xijʉ ra Moisés, tengu na bi 'yøt' ra xisu ya, nɛ i jatho da mba ma bat'ado gue da du. Xi'e, 'bɛ go guí xije ya, bi 'yɛ̨n'ʉ yʉ fariseo nɛ yʉ xänbate niją. ");
INSERT INTO otmNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pɛ guehna bi man ʉ nguetho i sätho ra Jesús, i honi 'bɛpʉ dí yąpi. Nɛ 'bex bi mbom thoho a ra Jesús nɛ bi 'yo't' rá saha bʉ häi tengu'bʉ hin xtá 'yø'a bi man'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pɛ man'da bi thoqui bi 'yänni, nu ra Jesús bim 'bäh pʉya nɛ bi 'yɛ̨mp'ʉ: ―Nu'bʉ 'bʉ a n'da ahʉ hin'yʉ ni ts'oquihʉ, gue'a di dʉ'mi da 'yɛmba ra do ra xisu a. ");
INSERT INTO otmNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nɛ bi mbo'mi mahøn'a bʉ häi nɛ bi 'yo't' rá saha bʉ ja ra häi. ");
INSERT INTO otmNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nɛ nu'bʉ mí 'yø'ʉ 'bɛ'a bi man ra Jesús, bi dʉ'mi 'dahmi 'datho bi mba, m'bɛt'o bi mba a man'da xín dąc'yɛi asta gue'bʉ go mín the ʉ yʉ yąpate, nguetho bi bąsɛ mbo yʉ́ mbʉi i ja yʉ́ ts'oqui. Nɛ hønt'a ra Jesús bi gohmbʉ bʉ ʉ mí xänbi, nɛ'a ra xisu. ");
INSERT INTO otmNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nɛ nu'bʉ mím 'bä'a ra Jesús nɛ bi nu njo'o bʉ yʉ yąpate, pɛ hønt'a ra xisu bi gopʉ, bi 'yɛ̨mbi: ―Grá xisu, hapʉ bi mba ʉ bi yąp'i i. Ha njo'o ua ʉ in nde xtí 'da'a rá muui ni ts'oqui. ");
INSERT INTO otmNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nɛ bi dą'a ra xisu: ―Grá Hmu, xínga n'da. Nɛ nu ra Jesús bi 'yɛ̨mbi: ―Nɛcä, xínga guecä ga 'da'a rá muui ni ts'oqui. Ní mba ya, pɛ hin gui 'yøt' mi'da yʉ ts'oqui. ");
INSERT INTO otmNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nu ra Jesús bi thoqui bi xänba yʉ ją'i mahøn'a, bi 'yɛ̨na: ―Nugä, drá nyot'i yʉ́ mbʉi yʉ ją'i 'bʉcua ja ra ximhäi. Nu'a to'o da dɛngui him man 'yo bʉ ja ra 'bɛxui, pɛ din ja ran nɛqui yʉ́ mbʉi gue ra 'da'yote maząi, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Janangue'a nu'bʉ mi dą ʉ 'da yʉ fariseo mi 'bʉpʉ, bi 'yɛ̨mbi: ―Pɛ nu'i guím mansɛ 'bɛ'a guí øzɛhɛ, janangue'a säti thoho a guím ma, sä bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nu'a ra Jesús bʉya bi dąt'ʉ nɛ bi 'yɛ̨mp'ʉ: ―Madague'bʉ dím mansɛ nanguesɛgä, pɛ di muui a, nguetho dí pącä hapʉ bá nɛxä nɛ hapʉ ná mbagä. Pɛ nu ahʉ hin guí pąhmbʉ hapʉ bá nɛxä o hapʉ ná mbagä. ");
INSERT INTO otmNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nu'ehʉ sä gadí juąnbahʉ n'da 'bʉ hin guí pąhmbʉ xʉn ho 'bɛ'a øt'a n'da. Pɛ nugä madague'bʉ dí pądi 'bɛ'a øt'a n'da, pɛ njon dadí juąnbä ya. ");
INSERT INTO otmNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pɛ nu'bʉ dím mangä 'bɛ'a øt'a n'da, majuąni dím ma, nguetho hin dí 'dasɛ pɛ n'dat'a dím mam'be ma Ta gue bá pɛngä ua. ");
INSERT INTO otmNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nt'o't'i bʉ ja yʉn t'ɛ̨di ząi guidín xähmbʉ, gue nu'bʉ yoho yʉn 'yohʉ 'da'angu da ma 'bʉ xʉn juąnni, mfądi gue ya majuąni a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nugä dí xi ahʉ to'ogä, n'dahma gui pąjʉ, nɛ'a ma Ta bá pɛngä di jaqui da fąqui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'Bex bi 'yɛ̨n'ʉ: ―Hapʉ 'bʉh ni ta, bi 'yɛ̨mbi. Nɛ nu ra Jesús bi dąt'ʉ: ―Hin guí pąjʉ, xínga gue'a ma Ta guí pąhmbʉ. Nu'bʉ xquí pąjʉ, nɛ'a ma Ta xquí pąhmbʉ 'bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nɛ guehna bi man ra Jesús 'bʉ mín xänbate bʉ ja ra dąniją guepʉ i pa m'bɛ'ts'i ra mbɛti. Nɛ njom bi bɛnt'i gue xtan got'i nguetho hin ní zøn ra ora dim fɛnt'i. ");
INSERT INTO otmNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nu ra Jesús bi thoqui bi xih mahøn'a ʉ: ―Nugä ga mbagä, nɛ m'bɛjua gui hyonjʉ, nɛ gui tuhʉ 'bʉ hin nín hotho ni ts'oquihʉ. Nubʉ hapʉ ga mbagä hin da zä gui mbähä bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nɛ bi 'yɛ̨n ʉ ma ngʉrpihe: ―Ha din hyosɛ nanguesɛ nguetho bi ma: “Nubʉ ga mbagä, hin da zä gui mbähä bʉ,” bi 'yɛ̨njʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'ahʉ i ja ahʉ rán 'yomfɛ̨ni ra ximhäi nguetho gyʉ mɛnguhʉ ua ja ra ximhäi. Pɛ nugä 'da'angu dím bɛ̨m'be Oją, nguetho hin dra mɛngugä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Janangue'a dí xi ahʉ, nu'bʉ hin gui 'yɛ̨c'yɛihʉ 'bɛ'a dím mansɛ gue to'ogä, gui tuhʉ nɛ njąm'bʉ din hoh ni ts'oquihʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nɛ bi 'yän'ndʉ bʉya: ―To'o i, bi 'yɛ̨n'ʉ. Nu'a ra Jesús bʉya bi 'yɛ̨mp'ʉ: ―Ya xtá xi ahʉ to'ogä nɛ guexta thohogä. ");
INSERT INTO otmNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I ja man'da xʉn ngu ga xi ahʉ 'bɛpʉ nín ja ni ts'oquihʉ. Pɛ majuąni a dím ma nguetho majuąni a bá pɛngä. Nɛ nu'ʉ yʉm hma di bɛ̨ngä a, gue'ʉ dím mangä ua ja ra ximhäi ʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pɛ nu'ʉ ma ngʉrpihe 'bʉ mí xi ʉ, him bi bą ʉ gue'a bi ma ra Jesús gue Oją bá pɛnhua. ");
INSERT INTO otmNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Janangue'a xø bi 'yɛ̨n'a ra Jesús: ―Nu'bʉ gá cuarcahʉ bʉ magąts'i, guecä dán ją'igä ua ja ra ximhäi, m'bɛjua bʉya ja gui pąhmbʉ to'ogä. Nɛ ja gui pąhmbʉ bʉya nte dím mansɛ, pɛ gätho xtá ma bi xänga ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nu a ma Ta gue bá pɛngä ua, n'dat'a dím bɛ̨m'be, nɛ njąm'bʉ i sogä a nguetho ząi gätho dí øt'ä a in numanho, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nu'bʉ mí man na, xʉn ngu ʉ mi'da bi 'yɛ̨c'yɛi mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ 'da ma mijudíohe ngue ɛ̨na bi 'yɛ̨c'yɛi a: ―Nu'bʉ gui thoqui gui tɛnhdʉ mam hmangä, majuąni ma 'yɛ̨c'yɛi ahʉ 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nɛ da zä gui pąhmbʉ 'bɛ'a nam bøn'ʉ yʉm hma majuąni, nɛ gue'a dí yąn ahʉ gue da zin ahʉ Oją, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nɛ bi dą ʉ: ―Pɛ nugähe, dyʉm bom'bɛtoje ra Abraham janangue'a ya yʉ́ t'ʉhnigähe Oją. Nɛ njąm'bʉ midí mandagähe man'da ra hmu. Hanja gní xije da mba nhyąnigähe gue da zinje Oją, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Majuąni dí xi ahʉ, nu'a to'o øt' ra ts'oqui, rá hmu ra ts'oqui a. ");
INSERT INTO otmNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nɛhna man'da guim bɛ̨mhbʉ, hin gui sä gui comhbʉ ran ho ra Abraham, pɛ tengu'bʉ yʉ́ 'yɛ̨hɛ thoho ahʉ a. Pɛ hønt'ʉ njuąntho yʉ́ t'ʉhni da gomhbʉ ran ho maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nugä njuąntho rá Ts'ʉnt'ʉ Ojągä. Nɛ nu'bʉ guecä ga jʉc'ahʉ bʉ ja yʉ ts'oqui, majuąni da zin ahʉ ma Ta nɛ yʉ́ t'ʉhni ahʉ a 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nɛ madague'bʉ bi xąnt'ahʉ ra Abraham, tengugä, pɛ guín nde gui hyojʉ, nguetho hin hapʉ da zä da yʉt' mam hma bʉ ja ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Hønt'a bi 'yurcä ma Ta dím mangä. Ngutho ahʉ, hønt'a bi 'yut'a ni tahʉ guí øthʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nɛ bi dą ʉ ma mijudíohe mí 'bäpʉ: ―Ra Abraham ma tahe. Nɛ nu ra Jesús xø bi 'yɛ̨mp'ʉ: ―Nu'bʉ majuąni yʉ́ t'ʉhni ahʉ ra Abraham xquí comhbʉ ran 'yomfɛ̨ni ra Abraham 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pɛ nuya guín nde gui hyojʉ, guecä dí xi ahʉ a majuąni gue'a bi xänga ma Ta. Pɛ hinga ngubʉ bi 'yøt' ra Abraham tengu guín nde gui 'yørcahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Janangue'a dí xi ahʉ, guí øthʉ rá 'bɛfi man'da ni tahʉ, bi 'yɛ̨na. Nɛ 'bex bi 'yɛ̨n'ʉ: ―Hin dyʉ 'bɛtat'ʉhni gähe, pɛgue n'datho ma tahe 'bʉi, Oją a, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nu'a ra Jesús bi dąt'ʉ: ―Nu'bʉ da gue'a Oją ni tahʉ, xquí numanhojʉ 'bʉ, nguetho bá ɛ̨cä bʉ bí 'bʉ Oją. Nɛ hin bá ɛ̨cä nangue ma ts'ɛdi zɛhɛ pɛ gue'a Oją bá pɛngä ua. ");
INSERT INTO otmNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hanja hingui sä gui pąhmbʉ 'bɛ'a dím mangä. Nguetho hin guín nde gui pąhmbʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nguetho ra zįthu ni tahʉ, nɛ guí honi gui 'yøthʉ rá pähä a. Nɛ nu'a, rá mbʉdi thoho bi dʉ'mi bin hote, nɛ guet'ʉ yʉ pa i ja bʉ ya i øthoho. Nɛ nu'a, him bin ząmmi a majuąni nguetho him bi numanho a. Nɛ hønt yʉ fɛhni man'a nguetho rám 'bäi a. Nɛ in ta nangue gätho yʉ fɛhni. ");
INSERT INTO otmNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pɛ nugä dím ma majuąni, janangue'a hin guí ɛ̨c'yɛigahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","To'o ahʉ da ma majuąni dí øt' ran ts'o o gue dím man ra fɛhni. Pɛ nu'bʉ gätho majuąni a dí xi ahʉ, hanja hingui sä gui 'yɛ̨c'yɛihʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nu'a to'o bim 'bʉi nangue Oją, i ømanho rám hman Oją a, pɛ nu'ahʉ hin guí ømanho rám hman a nguetho hin gám 'bʉhmbʉ nangue Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'Bex bi dą'ʉ ma mijudíohe bʉya: ―Ha him majuąni dím mamhbe, gue nu'i grá mɛngu bʉ Samaria, gue him majuąni grá mbom'bɛto ra Abraham. Nɛ guí 'bʉhmi n'da ra zįthu, sä bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nu ra Jesús bi dąt'ʉ: ―Nugä hin dí 'bʉ'be n'da ra zįthu pɛ dí numansu ma Ta. Nu'ahʉ hin guí numansujʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nɛ hin dí honi gue da hnumansugui pɛ i 'bʉ a n'da gue i honi da hnumansugui, nɛ di ʉnbi to'o hingui numansugui. ");
INSERT INTO otmNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Majuąni dí xi ahʉ, nu'a to'o da 'yɛ̨c'yɛi a dím mangä hin da nu ran dąte a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","'Bex bi dą'ʉ ma mijudíohe: ―Nuya dí pąhmbe go gue'e guí 'bʉhmi a ra zįthu, nguetho bi du ra Abraham nɛ gätho yʉ́ pøngahyą Oją, pɛ sä guí ɛ̨na, hin da du to'o da 'yɛ̨c'yɛi i. ");
INSERT INTO otmNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ha guí ɛ̨na man'da guín nuįxte xinda gue'a ma tahe ra Abraham nɛ ʉ yʉ pøngahyą, nɛ maya'bʉ xʉn du ʉ. To'o guí ɛ̨na gue gue'e 'bʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nu'a ra Jesús bi dąt'ʉ: ―Nu'bʉ xcá honi dan nuįxte zɛhɛgä, säti thoho 'bʉ. Pɛ nangue a rá ts'ɛdi ma Ta, gue'a nán nuįxtegä a, gue'a guí ɛ̨mfʉ ni Ojąhʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pɛ njąm'bʉ gá pąhmbʉ a. Pɛ nugä dí pącä a, nɛ nu'bʉ xcá mangä hin dí pącä a, xcám fɛhnigä 'bʉ, tengu ahʉ. Pɛ majuąni dí pącä a nɛ dí øt'a im man a. ");
INSERT INTO otmNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nu a ra Abraham, ząi guí ɛ̨mfʉ ni tahʉ, pɛ bin johya 'bʉ mi bądi da zøn ra pa ba ɛ̨cä ua. Nɛ bi t'uti gue ga søcä ua, nɛ bin johya 'bʉ mi nugui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nɛ sä 'bex bi 'yɛ̨mp'ʉ ma mijudíohe: ―Hin guí pɛ'ts'i yote ma 'dɛt'a njɛya nɛ guí ɛ̨na gá nu ra Abraham, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Majuąni dí xi ahʉ, nu'bʉ hin ním 'bʉh ra Abraham, xmí 'bʉcä, nguetho ząi dí 'bʉi, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","'Bex bi gʉx yʉ do ʉ, ɛ̨na di bat'i, pɛ nu ra Jesús 'bex bi yʉt'i nde bʉ 'bʉh yʉ ją'i, bin 'yąni nɛ bi bøm bʉ ja ra dąniją bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nu'bʉ má mbähmbe bʉ 'yu ra Jesús, dá nuhe n'da ran 'yohʉ, ra xädä gue'bʉ go mim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nɛ nugähe dyʉ xädihe dá änhde: ―Xänbate i, to'o bi 'yøt' ra ts'oqui, ha gue'a rá ta o gue rá mbe, uague rá ts'oqui zɛhɛ gue bin xädä, dí ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nu'a ra Jesús bi 'yɛ̨ngähe: ―Xínga guehna ran 'yohʉ nɛ xinga gue'a rá ta nɛ xínga gue'a rá mbe, pɛ hønt'a ran t'øt'e nuįxte da 'yørpa Oją gue da nu yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nujʉ i jatho ga humbi ga ørpahʉ rá 'bɛfi Oją ya tengu'bʉ ma patho ya, nguetho da zøn ra pa ga tuhʉ, nɛ hin man da zä ga øthʉ ra 'bɛfi ua ja ra ximhäi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nu'bʉ dí 'bʉcua ja ra ximhäi dí xänba yʉ ją'i, tengu'bʉ dí xocpa yʉ́ dä da nu ran nɛqui, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nu'bʉ mí jua'a bi ma, bi zoh rá jįni bʉ häi, nɛ í 'yøt' ra bøhäi rá jįni nɛ gue'a í gospa rá dä ra xädä a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nɛ bi 'yɛ̨mp'a ra xädä: ―Ní mba bán xʉdä nʉ ja ra mbothe Siloé. Bi mba nɛ bán xʉdä. Nɛ nu'bʉ mam bá pengui in nu ran nɛqui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nɛ nu'ʉ din tøt'am'bʉihʉ nɛ'ʉ mi'da yʉ ją'i gue ząi mín nu 'bʉ mín xädä, nu'bʉ mín nu ʉ, bin 'yɛ̨mp'ʉ: ―Ha hinga guehnʉ ra xädä nʉ mí hąxta'a 'bɛ'a mí si. ");
INSERT INTO otmNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","'Da'ʉ bi ma: ―Guehnʉ. Nɛ nu'ʉ mi'da bi 'yɛ̨na: ―Ɛ̨na ngunʉ a pɛ hinga guehnʉ. Pɛ nu ra xädä bi dądi: ―Guecä, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nɛ bi 'yän'dʉ bʉya: ―Hague nja bi xoh ni dä. ");
INSERT INTO otmNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nɛ nu ra xädä bi dądi: ―Nu'a ran 'yohʉ rá thuhu ra Jesús bi 'yøt' ra bøhäi nɛ bi gosca ma dä. Nɛ bi 'yɛ̨ngä: “Ní mba bʉ ja ra mbothe Siloé nɛ guan xʉdä bʉ,” bi 'yɛ̨ngä a. Nɛ dá mba dán xʉdä, nɛ bi zä dá nu ran nɛqui ma dä bʉya, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nɛ bi t'ɛ̨mp'a: ―Hapʉ i 'bʉ a. Nɛ bi dąh pʉya: ―Hin dí pądi, bi 'yɛ̨ntho. ");
INSERT INTO otmNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nɛ bi zix bʉ 'bʉh yʉ fariseo bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nu'a ra pa bi 'yøt' ra bøhäi ra Jesús nɛ bi xocpa rá dä ra xädä, ra pa ran ts'äya a. ");
INSERT INTO otmNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nu yʉ fariseo bi 'yänni mahøn'a: ―Hague nja bi nu ran nɛqui ni dä. Nɛ bi 'yɛ̨mp'ʉ: ―Bi gosca ra bøhäi ma dä, nɛ bán xʉdä, nɛ nuya dín nu ran nɛqui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Janangue'a bi 'yɛ̨n'ʉ 'da yʉ fariseo: ―Nu'a ran 'yohʉ guím ma, hingui numansu Oją nguetho hingui numansu ra pa ran ts'äya, sä bi 'yɛ̨n'ʉ. Pɛ nu'ʉ mi'da ʉ bi 'yɛ̨na: ―Pɛ nu'bʉ ra ts'om'bäi hin xtán zä da 'yøt' yʉn t'øt'e nuįxte gue i øt'a. 'Bex bin hec'ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nɛ bi t'än'na ra xädä: ―'Bɛ'a guím ma nangue'a bi xoc'a ni dä. Nɛ bi 'yɛ̨na: ―Nu'a, n'da rá pøngahyą Oją a, bi 'yɛ̨na, nɛ bi bøm bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pɛ nu'ʉ him bi 'yɛ̨c'yɛi gue gue'a mí xädä, jague'bʉ mí zonpa a rá ta nɛ rá mbe. ");
INSERT INTO otmNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nɛ bi 'yän'dʉ: ―Ha gue'a ni ts'ʉnt'ʉui gue mí xädä a. Hague nja in nu ran nɛqui ya, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bi dą'a rá mbe nɛ rá ta: ―Dí pą'be gue gue'a ma ts'ʉnt'ʉ'be gue mí xädä 'bʉ mim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pɛ hin dí pą'be hague in ja in nu ran nɛqui ya, hin dí pą'be to'o bi xocpa rá dä. Nu'a xʉn dąn'yohʉ ya, dami 'yänhdʉ, da mansɛ to'o. ");
INSERT INTO otmNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ngubʉ bi man rá ta nɛ rá mbe nguetho i su ma ngʉrpihe dyʉ judíohe. Gue bi zän'na n'da ra nde, gue da hyøn'a thi bʉ ja ra niją ʉ to'o da ma bá pɛnh Oją a ra Jesús, nɛ ma zä hin da hnumanho bʉ ja yʉ́ hnini. ");
INSERT INTO otmNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Janangue'a bi 'yɛ̨ntho rá ta nɛ rá mbe: “Xʉn dąn'yohʉ ya, dami 'yänhdʉ,” bi 'yɛ̨ntho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Janangue'a bi zonh mahøn'a ran 'yohʉ mí xädä, nɛ bi 'yɛ̨mp'a: ―Pɛ dami ma majuąni gue gue'a Oją bi xoc'a ni dä. Pɛ nu'a ran 'yohʉ gá ma, dí pąhmbe ra ts'om'bäi a, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nɛ nu'a mí xädä bi dądi: ―Hin dí pącä 'bʉ ra ts'om'bäi a, o gue hin'na, pɛ hønt'a dí pądi mí xädägä, nɛ dín nu ran nɛqui ya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nɛ bi 'yɛ̨mbi mahøn'a: ―'Bɛ'a bi 'yøt'a'i 'bʉ mí xoc'a ni dä. ");
INSERT INTO otmNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nɛ bi dą'a: ―Nugä ya xtá xi ahʉ nɛ hin gá 'yɛ̨c'yɛihʉ. Ha gui 'yɛ̨c'yɛihʉ 'bʉ ga xi ahʉ mahøn'a. Ha nɛ ahʉ guín nde gui tɛnhdʉ a 'bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","'Bex bin sante thoho ʉ 'bʉ mí 'yɛ̨mp'a: ―Nu'i rá xädi i a ra ts'om'bäi. Pɛ nugähe yʉ́ xädigähe a ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dí pąhmbe Oją bin yąui ra Moisés, pɛ nu'a ran 'yohʉ guí ɛ̨spi hin dí pąhmbe hapʉ bi nɛx'a rán t'ɛ̨di a, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bi dą'a mín xädä bʉya: ―Nugä dadí hyonya thoho nangue'a gá mamhbʉ, gue hin guí pąhmbʉ hapʉ bí 'yɛ̨ a rán t'ɛ̨di, nɛ ya bi xoga ma dą a. ");
INSERT INTO otmNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nɛ dí pąhmbʉ hin da 'yømanho Oją 'bʉ da 'yäp rá ts'ɛdi n'da ra ts'om'bäi, pɛ nu'bʉ 'bʉ a n'da i thąnde Oją nɛ ørpa rá pähä, i ø Oją 'bʉ i äp rá ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nɛ gätho yʉ jɛya xʉ thogui njąm'bʉ bim 'bʉ a n'da bi xocpa rá dä n'da mi xädä 'bʉ mím 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu'a ran 'yohʉ dím ma, nu'bʉ hin di fäx Oją a, hin te sä da 'yøt yʉ nuįxte 'bʉ, bi 'yɛ̨n'a mí xädä. ");
INSERT INTO otmNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nɛ bi t'ɛ̨mp' mahøn'a: ―Nu'i grá dądits'oqui, janangue'a guí xädä 'bʉ gmím 'bʉi. Ha go gui xängahe, bi 'yɛ̨n ʉ. Nɛ bi hyøn a thi gue ma zä hin da numanho ma mijudíohe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nu'bʉ mí 'yø'a ra Jesús gue bi thøn'a thi ra xädä, bi dįni nɛ bi 'yänni: ―Ha guí ɛ̨c'yɛi rá ts'ʉnt'ʉ Oją, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nɛ bi dąt'a: ―Ma Hmu, to'o a guím ma. Dami xiqui ts'ʉ, ga ɛ̨c'yɛi a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nɛ nu ra Jesús bi 'yɛ̨mp'a: ―Guecä guín nug ya, nɛ dí yąui ya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nɛ bi 'yɛ̨mbi: ―Ma Hmu i, dí ɛ̨c'yɛi a ya. Nɛ bin dąnyahmu bʉ ja rá hmi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nɛ nu ra Jesús bi 'yɛ̨na: ―Janangue'a dám 'bʉcä ua ja ra ximhäi, gue ga japi di nɛqui 'bɛ'a mbɛ̨ni n'da ngu n'da. Nɛ nu'ʉ i xädä da nu ran nɛqui, nɛ nu'ʉ in nu ran nɛqui din xädä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nɛ nu'ʉ 'da yʉ fariseo bi 'yøh rám hman a, bi 'yɛ̨n'ʉ: ―Ha nɛcähe dí xädähe, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'bʉ xquí pąhmbʉ gue guí xädähʉ, xtán zä xtím pun'nahʉ 'bʉ nɛ njon xtá xi ahʉ gue ja ni ts'oquihʉ bʉya. Pɛ guí ɛ̨nsɛhʉ guín nuhʉ ran nɛqui, janangue'a hin dim pun'na ni ts'oquihʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","―Majuąni dí xi ahʉ, bi 'yɛ̨n'a ra Jesús, nu'ʉ hin dí yʉrpʉ ja rá goxthi a rá mbä't'i yʉ dɛ'yo, nɛ dí dons pʉ ja ra mbä't'i, yʉ bɛ̨ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pɛ nu'ʉ dí yʉrpʉ ja ra goxthi, njuąntho yʉ mbändɛ'yo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nɛ da xocpa a ra mbängoxthi nɛ da yʉt'ambo ra mbändɛ'yo bʉya. Nɛ nu'ʉ yʉ́ dɛ'yo i ørpa rá nde a rá mbädi nɛ i øt'a i xifi. Nɛ i ndønba yʉ́ thuhu nguetho i pą ʉ yʉ́ mbɛti a. Nɛ i sixpʉ ja yʉ 'bot'ɛi. ");
INSERT INTO otmNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nɛ nu'bʉ mí gʉc pʉ thi gätho ʉ yʉ́ dɛ'yo, di 'bɛt'o 'bʉ i sits'i, nɛ nu'ʉ yʉ́ dɛ'yo i tɛnni nguetho i pąrpa rá nde 'bʉ im mba't'i. ");
INSERT INTO otmNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hingui tɛnna n'dan'yo n'da ra ją'i, pɛ i 'dagui, nguetho hingui pąrpa rá nde a n'dan'yo, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nu'a ran t'uti bi man'a ra Jesús, pɛ hingui pą ʉ 'bɛ'a nam bøn'a bi si ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Janangue'a 'bex bi 'yɛ̨mbi mahøn'a: ―Majuąni dí xi ahʉ, nugä drá goxthigä a ra mbä't'i guepʉ i 'bʉh yʉ dɛ'yo. ");
INSERT INTO otmNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pɛ gätho ʉ im bɛ̨ni dim 'bɛt'o zɛhɛ xinda guecä, nɛ gue'ʉ yʉ bɛ̨ ʉ. Pɛ nu'ʉ yʉ dɛ'yo hingui ørpa yʉ́ nde ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nugä drá goxthigä, nu'a to'o da yʉt'i nanguecä, ma zä da ts'imanho bʉ. Nɛ da bądi gue rá ngu bʉ, janangue i 'yo nɛ da dįni 'bɛ'a dí zɛrpa yʉ́ mbʉi, tengutho ra dɛ'yo i tįn yʉ t'ɛi. ");
INSERT INTO otmNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nu'ʉ yʉ bɛ̨ ní 'yɛ̨hɛ dim pɛ̨ nɛ din hodu nɛ di ts'onbi gätho rá 'bɛfi Oją. Pɛ nugä ná ɛ̨hɛ gue dí tįn ra te n'da nɛ din ja ra te i juadi xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nugä drá hogambändɛ'yo nɛ ga 'bɛh ma te gue gan yąn ʉ ma dɛ'yo. ");
INSERT INTO otmNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pɛ nu'ʉ 'da yʉ mbɛfi, hønt'ʉ yʉ́n zäbi nde da dąha, nɛ him majuąni yʉ mbändɛ'yo, gue hin yʉ́ mbɛti ʉ yʉ dɛ'yo. Janangue'a nu'bʉ in nu ba ɛ̨pʉ n'da ra zate, i sopʉ yʉ dɛ'yo nɛ i 'dagui. Nɛ nu ra zate bʉya im bɛnt'ʉ yʉ dɛ'yo nɛ im maxt'i. ");
INSERT INTO otmNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nu'ʉ yʉ mbɛfi i 'dagui nguetho hin'yʉ yʉ́n huɛ̨cate nangue yʉ dɛ'yo, nɛ hønt'ʉ yʉ́n zäbi ní hyu yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nugä drá hogambändɛ'yo, nɛ dí pąh ma dɛ'yo nɛ nu'ʉ i pąqui. ");
INSERT INTO otmNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tengu thoho dí øt'be ma Ta, i pąqui nɛ dí pącä a. Nɛ ga ungä ma te ngue gan yąn ʉ ma dɛ'yo. ");
INSERT INTO otmNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","I 'bʉh mi'da ma dɛ'yo gue hinga guecua i 'bʉcua. Nɛ'ʉ jatho gua sigä. Nɛ da 'yø 'bʉ dá mba't'i. Janangue'a 'darpʉ din 'yo gätho ma dɛ'yo. Nɛ gätho ga fäh pʉya nguetho høngdä drá mbändɛ'yogä. ");
INSERT INTO otmNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ɛ̨mmɛ numanho ma Ta 'bɛ'a ga øt'ä gue ga ungä ma te nangue ma dɛ'yo. Pɛ ga thąmbɛ̨nigä mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Xínga n'da ra ją'i da zä da hyogui, pɛ nugä ga unsɛ ma te. Ja ma ts'ɛdi ga uni nɛ ja ma ts'ɛdi ga thąmbɛ̨ni, nguetho gue'a bi xic ma Ta, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nangue'a bi man ra Jesús, bin hec ma mijudíohe mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xʉn ngu ʉ bi 'yɛ̨na: ―Nuna 'bʉhmi ra zįthu nɛ ran gąt'i na. Hanja gní 'yøhmbʉ 'bɛ'a man na, bi 'yɛ̨n'ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pɛ nu'ʉ mi'da bi 'yɛ̨na: ―Pɛ hinguin jabʉ rám hman a in 'youi ra zįthu. Nɛ mfądi hin'yʉ rá ts'ɛdi ra zįthu da xocpa yʉ́ dä yʉ xädä, bi 'yɛ̨n'ʉ mi'da. ");
INSERT INTO otmNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nu yʉ pa xʉn sɛ bin ja ran ts'ihmɛ bʉ Jerusalén ngue ra dąmpɛti bi 'yøt' ma mijudíohe. ");
INSERT INTO otmNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nu ra Jesús mí 'yo bʉ ja rá ngun'yu ra dąniją ní hu ra Salomón. ");
INSERT INTO otmNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nu'ʉ 'da ma mijudíohe bʉya bi mbä'ts'a ra Jesús, nɛ bi 'yɛ̨mp'a: ―Hanja gní jacthohohe dan 'yänhde nangue'e, pɛ dami xije njuąntho 'bʉ gue'e grá Cristo, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nɛ nu ra Jesús bi dąt'ʉ: ―Ya xtá xi ahʉ pɛ hin gá 'yɛ̨c'yɛigahʉ. Nɛ'a ra 'bɛfi dí øt'ä nangue rán t 'ɛ̨di ma Ta, i udi to'ogä. ");
INSERT INTO otmNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pɛ nu ahʉ hin guí ɛ̨c'yɛihʉ nguetho him ma dɛ'yo ahʉ, tengu xtá xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nu'ʉ ma dɛ'yo i ømanho ma nde, nɛ dí pąrpa yʉ́ mbʉi ʉ nɛ i tɛngui. ");
INSERT INTO otmNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nɛ dí un ra 'da'yote maząi ʉ nɛ njąm'bʉ dim 'bɛdi. Nɛ njo'o to'o da zä da huą'ts'ʉ i o ma 'yɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nu a ma Ta bi 'dacä ʉ, man'da nuįxte a, nɛ njo'o man'da tengu a. Nɛ njo'o to da zä da huą'ts'ʉ i o rá 'yɛ ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nugä nɛ ma Ta n'datho dí com'be, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","'Bex bi gʉx yʉ do mahøn'a ɛ̨na di bat'i ngue da hyo. ");
INSERT INTO otmNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Xʉn ngu yʉ 'bɛfi xʉn ho xtá ut'ahʉ ngue bi xic ma Ta. Nda'a ní 'bɛfi guín nde gdí bajʉ yʉ do, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nɛ bi 'yɛ̨mp'ʉ yʉ judío: ―Hin nangue yʉ 'bɛfi xʉn ho dí ɛ̨na ga ba ahe, pɛ nangue hin guí ɛ̨spa Oją gue gá 'yɛ̨na, n'datho guí cohmi Oją, nɛ grá ją'i thoho, bi t'ɛ̨mp'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nu ra Jesús bi dąt'ʉ: ―Ha hinga nt'o't'i bʉ ja yʉn t'ɛ̨di gadín xähmbʉ, gue bi 'yɛ̨n Oją: “Nu ahʉ tengu'bʉ gyʉ́ ojąhʉ,” i ɛ̨m bʉ ja ra t'ohni. ");
INSERT INTO otmNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Gue bi 'yɛ̨mbi tengu'bʉ yʉ oją ʉ bi un rán t'ɛ̨di Oją. Nɛ hingui sä dim 'bɛh rá T'ohni Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Pɛ hanja gní 'yɛ̨njʉ hin dín numansugä Oją 'bʉ dím mangä, rá Ts'ʉnt'ʉ Ojągä, guecä gue bi huangä ma Ta nɛ bá pɛngä ua. ");
INSERT INTO otmNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nu'bʉ hin dí øt'ä tengu øt'a ma Ta, hin gui 'yɛ̨c'yɛigahʉ 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pɛ nu'bʉ dí øt'ä tengu øt'a ma Ta, dami pąhmbʉ ngue hønt'a Oją sä i øt'ʉ yʉ nuįxte dí øt'ä. Janangue'a da zä gui 'yɛ̨c'yɛihʉ gue n'datho ran 'yomfɛ̨ni dí com'be ma Ta, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Janangue'a bi 'yɛ̨na da bɛnt'i mahøn'a ʉ ma mijudíohe mí 'bäpʉ. Pɛ nu ra Jesús bi 'uegue. ");
INSERT INTO otmNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nɛ bi mbeng mahøn'a bʉ 'danguadi ra dąthe Jordán, guepʉ rá mbʉdi mí øt' ran xixyą ra Xuua, nɛ bim 'bʉpʉ 'da yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nɛ xʉn ngu yʉ ją'i bá ɛ̨pʉ 'bʉh ra Jesús. Nɛ bi man ʉ: ―Madague'bʉ nte man t'øt'e nuįxte bi 'yøt' ra Xuua Nxixyą, pɛgue gätho majuąni a bi mam 'bʉ mi xijʉ nanguehna ra Jesús, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nɛ xʉn ngu ʉ bi mba bʉ, bi 'yɛ̨c'yɛi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mí 'bʉpʉ Betania n'da ran 'yohʉ in zäman'ʉ, í Lázaro. Nɛ mí 'bʉhmbʉ yoho yʉ́n ju, ra María nɛ ra Marta. ");
INSERT INTO otmNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nɛ nuna ra María, guehna bi xispa ra 'yɛ̨thi rá gua ra Jesús ɛ̨mmɛ yʉman'u nɛ bi 'yonbi nangue yʉ́ xtą. Guehna rán ju ra Lázaro na, gue xʉn ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Janangue'a nu'ʉ yʉ́n ju bi mbɛhna n'da ra nde bʉ 'bʉh ra Jesús nɛ bi 'yɛ̨mp'a: ―Ma Hmu a'be, xiya 'bɛ'a ga øthʉ ya, xʉn ʉ a guidí huɛ̨qui, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nɛ nu'bʉ mí 'yøh ra Jesús, bi 'yɛ̨na: ―Nu'a ran ʉ hing ran dąte a pɛ hønt'a gue da hnu rá ts'ɛdi Oją nuįxte thoho, nɛcä rá Ts'ʉnt'ʉ Ojągä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nu ra Jesús ɛ̨mmɛ madi huɛ̨c'a ra Marta nɛ rá juhuɛ nɛ'a ra Lázaro. ");
INSERT INTO otmNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pɛ nu'bʉ mí 'yøde xʉn ʉ ra Lázaro, him 'bex bi nde da mba, 'bɛ bi døm' man yopa guepʉ mí 'bʉhmbe. ");
INSERT INTO otmNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","M'bɛjua bʉya bi xije dyʉ xädigähe a: ―Ga mbähä bʉ Judea mahøn'a, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pɛ dá ɛ̨mfe bʉya: ―Xänbate i, ha gui mba bʉ mahøn'a, nguetho nu ma mijudíohʉ 'bʉpʉ him maya'bʉ gue nde di bat'a do i, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nu ra Jesús bi xije n'da ran t'uti bʉya: ―Ha hinga gue'a 'dɛ'mayo ora n'da pa. Nu'bʉ ma pa i 'yo n'da ra ją'i, hin di fet rá gua nguetho in nu hapʉ i pa. ");
INSERT INTO otmNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pɛ nu'bʉ 'yoxui n'da, di fet rá gua nguetho hinguin nu hapʉ i pa. Nu'a bi ma gue hingana søn ra ora da du. ");
INSERT INTO otmNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nɛ m'bɛjua bi 'yɛ̨nje mahøn'a: ―Nu'a ma amigohʉ ra Lázaro i ąha. Nɛ ga mbähä ga ents'ä a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","'Bex dá ɛ̨mbähe a bʉya: ―Ma Hmu ahe, nu'bʉ i ąha da yąm 'bʉ, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pɛ nu ra Jesús bi ma gue bi du 'bʉ mí ma i ąha. Pɛ dá bɛ̨mhbe gue i ątho. ");
INSERT INTO otmNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'Bexque njuąntho bi man ra Jesús: ―Ya bi du ra Lázaro. ");
INSERT INTO otmNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pɛ nangue ahʉ, xʉn ho gue hin dá nugä 'bʉ mín hyɛ̨n'na, gue man'da gui 'yɛ̨c'yɛigahʉ 'bʉ guin nuhʉ 'bɛ'a ga øt'ä ya. Nuya ga mbähä ba nuhʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pɛ nu'a ra Tomás nɛ i t'ɛ̨mbi ra Go, ma mixädihe, bi 'yɛ̨nje: ―Mbähmahʉ 'bʉ, madague'a 'darpʉ ga tuhʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nu'bʉ má sømhbe bʉ ra Jesús bʉya, ya ná goho pa xí t'ä a ra Lázaro. ");
INSERT INTO otmNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nu bʉ Betania hinga ya bʉ Jerusalén, mbɛ made ora na 'yo. ");
INSERT INTO otmNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Janangue'a xʉn ngu ma mijudíohe bi mba bʉ rá ngu ra Marta nɛ ra María gue da hyurpa yʉ́ mbʉi ʉ, nangue'a rá įda bi du. ");
INSERT INTO otmNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nu'bʉ mí 'yøh ra Marta gue ba ɛ̨pʉ ra Jesús, bi mba nɛ bin c'at'ui bʉ 'yu. Pɛ nu ra María bi gotpʉ ja rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nɛ nu'a ra Marta bi 'yɛ̨mp'a ra Jesús: ―Ma Hmu i, nu'bʉ xquím 'bʉque ua, hin xtán du ma įda. ");
INSERT INTO otmNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pɛ madague'bʉ ya bi du ya, pɛ dí pącä di 'da'a Oją hønt'a go 'bɛ'a gui 'yäpi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nu a ra Jesús bi dąt'a: ―Nu'a ni įda da ndants' mahøn'a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nu ra Marta bi 'yɛ̨na: ―Dí pącä da ndants'a rán zɛgui ra pa a, nɛ ʉ gätho xʉn du, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nɛ nu ra Jesús bi 'yɛ̨mp'a: ―Nugä guecä dadí un ra te ʉ xʉn du. Nu'a to'o da 'yɛ̨c'yɛigui, madague'a da du, pɛ ga japi da ndants'i nɛ din ja ra 'da'yote maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nɛ nu'a to'o 'bʉi nanguecä nɛ ɛ̨c'yɛigui, njąm'bʉ da du a. Ha guí ɛ̨c'yɛi a dí xi i, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nɛ bi 'yɛ̨mp'a: ―Hąha ma Hmu i, dí ɛ̨c'yɛi gue gue'e grá Cristo, rá Ts'ʉnt'ʉ i Oją, gue'e mí hma gua ɛ̨cua ja ra ximhäi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nɛ nu'bʉ mí gua'a bin yąui ra Marta a ra Jesús, bi mbeng bʉ rá ngu nɛ bin yąjodreui a rá juhuɛ ra María, nɛ bi xi a: ―Bí 'bäpʉ ra xänbate nɛ in zon'na i, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nɛ nu'bʉ mí 'yø a 'bɛ'a bi sifi, bi ndants'a nɛ bi mba n'dihi guepʉ 'bäh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nu ra Jesús him 'bex bi zøm bʉ ja ra hnini, pɛ bim 'bätho bʉ ndehnini guepʉ xín yąui ra Marta. ");
INSERT INTO otmNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nu ma mijudíohe mí hupʉ mbo rá ngu ra María gue i hurpa rá mbʉi, nu'bʉ mí nu bi ndants'a ra María nɛ bi mba n'dihi, bi dɛn'dʉ ma mijudíohe bʉya, nɛ bi 'yɛ̨n ʉ: “Masque ní mba ban zom bʉ ja ran 'yägui na.” ");
INSERT INTO otmNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nu'bʉ mí zøm bʉ ra María bʉ bí 'bäh ra Jesús, bin dąnyahmu bʉ ja rá gua, nɛ bi 'yɛ̨mp'a: ―Nu'bʉ xquím 'bʉque ua, hin xtán du ma įda 'bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nu'bʉ mín nu ra Jesús gue i zon'a ra María, nɛ ʉ ma mijudíohe zoni gue'ʉ bi dɛnni, bin gąs' pʉya nɛ bi hyundumbʉi. ");
INSERT INTO otmNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nɛ nu ra Jesús bi 'yänni: ―Hapʉ bi t'ä a ra Lázaro. Nɛ bi t'ɛ̨m bʉya: ―Ma Hmu ahe, ga mbähä gua nu, bi t'ɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nɛ a ra Jesús bin zom bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","'Bex bin 'yɛ̨m zɛhɛ ma mijudíohe bʉya: ―Nunʉ ya mfądi ɛ̨mmɛ madi huɛ̨c'a, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nɛ nu'ʉ 'da bi 'yɛ̨n'ʉ: ―Nuna guehna bi xocua yʉ́ dä ra xädä. Ha hin xtán zä xtí japi hin xtán du ra Lázaro 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nu'bʉ mí zøm bʉ ja ran 'yägui ra Jesús, bin gą'ts' mahøn'a. Nu ran 'yägui n'da ra hyądo a nɛ bi juaspa n'da ra xįndo. ");
INSERT INTO otmNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nɛ nu ra Jesús bi 'yɛ̨mp'ʉ: ―Dami 'uejʉ ts'ʉ na ra xįndo. Pɛ nu ra Marta, rán ju a xí du, bi 'yɛ̨mbi: ―Ma Hmu i, masque xʉn xą ya nguetho má goho ma pa ya bi du, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nu ra Jesús bi 'yɛ̨mp'a: ―Pɛ dí xi i mahøn'a, nu'bʉ gui 'yɛ̨c'yɛi gue i ja ma ts'ɛdi, guin nu rá ts'ɛdi Oją nuįxte, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","'Bex bi mba ma 'ueque ra do bʉya. Nɛ nu ra Jesús bi ndøts'e nɛ bi 'yɛ̨na: ―Ma Ta i, dadí 'da a ra jamadi, nguetho gá 'yøh ma nde 'bʉ má äp'i'i nanguehna ra Lázaro. ");
INSERT INTO otmNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nɛ dí pądi thocpa thoho guí øh ma nde. Pɛ nu'a dí xi a ya, ngue dí ndepe da 'yøh ya i 'bäcua ya, n'dahma da 'yɛ̨c'yɛi gue gue'e bá pɛngä ua. ");
INSERT INTO otmNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nɛ nu'bʉ mí jua'a bin yąui Oją bin yą nts'ɛdi: ―Lázaro, bá pøni. ");
INSERT INTO otmNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nɛ nu'a xí du bá pøm bʉ ja rán 'yägui bʉya, nsøt'e thoho ra 'bø't'e rá 'yɛ nɛ rá gua, nɛ nu rá yą n'dan'yo ra 'bø't'e mán søt'e. Nu ra Jesús bi 'yɛ̨mp'ʉ: ―Xothʉ, da zä din 'yo bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nɛ xʉn ngu ma mijudíohe ngue xí dɛn'na ra María, bi 'yɛ̨c'yɛi ra Jesús 'bʉ mí nu a bi 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pɛ nu mi'da bi mba bá xih yʉ fariseo 'bɛ'a bi 'yøt' ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Janangue'a bi man yʉ dąmbäją nɛ yʉ fariseo ngue 'darpʉ dim pɛtihʉ ʉ yʉ́ mi ngʉrpihʉ, nɛ bin 'yɛ̨m zɛhɛ ʉ: ―'Bɛ'a sä ga øthʉ, nguetho nu'a ran 'yohʉ i øt'e xʉn ngu yʉn t'øt'e nuįxte. ");
INSERT INTO otmNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu'bʉ hin ga hɛcpahʉ, gätho yʉ ją'i da 'yɛ̨mbi yʉ́ ngʉrpi. Nɛ nubʉya nu yʉ romano da zʉjʉ ngue da bɛ̨ni ya dá tɛnhdʉ man'da ra Hmu, nɛ hinga hønt'ʉ dí tɛnhdʉ ʉ, nɛ di juarca ma dʉxca nijąhʉ nɛ di juajʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nɛ nu'a n'da í Caifás, ra dąmbäją a ra jɛya a, bi 'yɛ̨na: ―Ha hin guí pąhmbʉ 'bɛ'a da zä ga øthʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ha hin guí pąhmbʉ man'da xʉn ho 'bʉ n'datho da du n'dahma hinga gätho na ngujʉ ga juahmbʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pɛ him bi bɛ̨nsɛ a bi ma, pɛ nangue'a ra dąmbäją a ra jɛya a, janangue'a bi jap Oją da ma 'bɛ'a da t'ørpa ra Jesús, gue da du da yąnje dyʉ judíohe. ");
INSERT INTO otmNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pɛ nu ra Jesús 'bʉ mí du, hinga høngdähe in nde da yąnje, pɛ nɛ ʉ gätho mi'da i 'bʉi hønbʉ go bi zä gätho na ndoho ra ximhäi, 'darpʉ dam 'bʉhmbʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nɛ nangue'a xí man ra Caifás, 'da'angu bi bɛ̨n ʉ gätho ma ngʉrpihe bʉya. Nɛ gue'a ra pa bi ma njuąntho da hyo ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Janangue'a m'bɛt'o bi 'uetho ts'ʉ bʉ 'bʉh ma ngʉrpihe, nɛ bi mba bʉ ja rá nyąni n'da ra ʉhäi, nɛ dám 'bʉhmbe bʉ 'da yʉ pa bʉ ja ra hnini Efraín. ");
INSERT INTO otmNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nɛ mi ts'ʉtho da zøn ra pa ran dąbaxjua, n'da ra dąnts'ihmɛ bi zängahe Oją maya'bʉ dyʉ judíohe. Janangue'a xʉn ngu yʉ ją'i 'da'a n'danni bi nɛts'i bi mba bʉ Jerusalén. Nguetho bi sije m'bɛt'o thoho ga hoc ma ją'ihe bʉ, nangue ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nɛ nu'bʉ mí zøm bʉ ja ra dąniją ʉ 'da ma mijudíohe, bi hyom bʉ a ra Jesús nɛ bin 'yän'dʉ n'da ngu n'da ʉ: ―'Bɛ'a guím mamhbʉ, ha ba ɛ̨h ra Jesús da nu ram pɛti ua uague hin'na, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nu yʉ dąmbäją nɛ yʉ fariseo bi 'yɛ̨n'ʉ: ―Nu'bʉ 'bʉi to i pądi hapʉ i 'bʉi, jatho da ma, n'dahma da zä gam bɛnthe, bi 'yɛ̨mp'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Di 'bɛh man 'dato pa din ja ra dąnts'ihmɛ bʉ Jerusalén nangue ran dąbaxjua, nɛ bi mba mahøn'a bʉ Betania a ra Jesús, nguepʉ rá ngu a ra Lázaro, gue'a xí jap ra Jesús bi dąmbɛ̨ni bʉ ja rán 'yägui ngue xí du. ");
INSERT INTO otmNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nu'bʉ mín de, nu ra Marta bi 'yørpa n'da ran ts'ihmɛ ra Jesús. Nɛ'a ra Lázaro 'darpʉ bin sihmɛhʉ bʉ ja ra mɛxa. ");
INSERT INTO otmNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nɛ bi mba ra María bʉ mí huh ra Jesús, bi xispa rá gua made litro ra 'yɛ̨thi ɛ̨mmɛ yʉman'u nɛ xʉm hmadi, nɛ í 'yonba ra 'yɛ̨thi nangue rá xtą. Nɛ gätho ra ngu bi yʉn'a ra 'yɛ̨thi. ");
INSERT INTO otmNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nɛ mí 'bʉpʉ rá ts'ʉnt'ʉ ra Simón, ra Judas Iscariote a, n'da ma mixädihe a, nɛ gue'a bi dä a ra Jesús. Nɛ nu'bʉ mín nu a bi 'yøt'a ra María, bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Hanja him bi 'bä a ra 'yɛ̨thi, yʉ mahuąhi thoho xtín ja rá muui gue xtín t'un yʉ hyoya, sä bi 'yɛ̨n a ra Judas. ");
INSERT INTO otmNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ngubʉ bi man a nguetho ra bɛ̨ a, nɛ him majuąni di huɛ̨c yʉ hyoya. Pɛ rá 'bɛfi a gue ní mbɛsca ma mbɛtihe dyʉ xädihe nɛ'a rá mbɛti ra Jesús. Nɛ nząi hąc zɛhɛ ra mbɛti 'bʉ in nde. ");
INSERT INTO otmNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'Bex bi 'yɛ̨n'a ra Jesús: ―O guidí hɛcpa na ra xisu, nguetho bi 'yørca a rán säui da 'yørque, nguetho mi ts'ʉtho ga tu ngue da t'ägagui. Janangue'a mí pɛsta'a ra 'yɛ̨thi na, xtí jacä ma ją'i 'bʉ dá tu. ");
INSERT INTO otmNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pɛ thocpa thoho gam 'bʉhmbʉ yʉ hyoya, pɛ nugä hinga thocpa thoho dam 'bʉhmbʉ ua, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nu'bʉ mi 'yøde xʉn ngu ma mijudíohe, gue 'bʉpʉ ja rán ngu ra María a ra Jesús, bi mba bá nu, pɛ hinga hønt'a ra Jesús in nde da nu, pɛ nɛ'a ra Lázaro gue xí xox ra Jesús bʉ ja ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Janangue'a nu yʉ dąmbäją bi bɛ̨ni nɛ'a ra Lázaro da hyo. ");
INSERT INTO otmNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nguetho gue'a ra Lázaro í japi man'da xʉn ngu bi 'yɛ̨c'yɛi a ra Jesús ʉ ma mijudíohe. ");
INSERT INTO otmNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nu'bʉ mi hyax bʉya dá mbähmbe ra Jesús bʉ Jerusalén. Nɛ nu'ʉ yʉ ją'i xʉn ngu xí zøm bʉ Jerusalén gue in nu ra dąmpɛti, bi 'yøde da mba bʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Janangue'a bi gąx yʉ́ xi yʉ jąxiza nɛ bi mba bá thąpʉ 'yu. Nɛ nts'ɛdi bi 'yɛ̨n'ʉ: ―Nuįxte tho rá ts'ɛdi Oją di jąp na ma Hmuts'ʉt'abihʉ dyʉ israelhʉ, dyʉ judíohʉ, bi zøcua ya nangue rá thuhu Oją, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nu'a ra Jesús i hux'a n'da ra t'ʉburu xí dįni, tengu mán t'o't'i bʉ ja rám hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Gue mán t'o't'i: Him man gan suhʉ ya gyʉ mɛnguhʉ ua Sión, nguetho ba ɛ̨h ni hmuts'ʉt'abihʉ, da hyux'a n'da ra t'ʉburu, mí ɛ̨n rá t'ohni maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pɛ nuje dyʉ xädihe him 'bexque dá pąhmbe 'bɛ'a nám bøn na bin ja, pɛ nu'bʉ mí mbeng mahɛ̨ts'i ra Jesús dá bɛ̨mhbe bʉya gue guehna bi t'ørpa ra Jesús gätho mán t'o't'i maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nu'ʉ yʉ ją'i mí 'bʉhmbʉ ra Jesús 'bʉ mi xox'a ra Lázaro, xí ma gue xí xox'a ra Lázaro. ");
INSERT INTO otmNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Janangue xʉn ngu yʉ ją'i bi mba bá thą a ra Jesús, nguetho bi 'yø a xin ja. ");
INSERT INTO otmNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Janangue'a nu yʉ fariseo bin 'yɛ̨mzɛhɛ ʉ: ―Nte ts'ʉ ní mbatho 'bʉ dadí hɛcpahʉ yʉ ją'i. Ha hin guín nuhʉ ya gätho ra ximhäi i tɛnnʉ ra Jesús, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nɛ nu'ʉ 'da bi mba bʉ Jerusalén da nu ram pɛti bʉ, yʉ mɛngu bʉ ja ra häi Grecia ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nɛ bin tįmhbʉ ra Felipe ʉ 'bʉ mám 'bʉhmbe bʉ Jerusalén. Nɛ nu ra Felipe, ma mixädihe a, ra mɛngu bʉ Betsaida ra xɛqui Galilea. Nɛ nu yʉ mɛngu bʉ Grecia bi 'yɛ̨n'ʉ: ―Hague n'yø, dín nde dan yąhe ts'ʉ ra Jesús, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nu'a ra Felipe bʉya bi xi a ra Andrés, nɛ nu'ʉ bʉya bi xi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nɛ nu ra Jesús bi dąt'ʉ: ―Ya mi ts'ʉtho da zøn ra pa dan uįxtegä 'bʉ dá tu, guecä dán ją'igä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Majuąni dí xi ahʉ, tengu n'da ra hmudä, nu'bʉ hin da thupʉ ja ra häi ngue dim 'bɛpʉ, hin din xąndi. Pɛ nu'bʉ da thuhu, da zä din xąndi xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nu'a to'o i su din ʉnba 'bʉ da dɛngui, da mba ma ʉnbi rá te a, pɛ nu'a hingui su din ʉnba 'bʉ da dɛngui guecua ja ra ximhäi, din ja ra te maząi a. ");
INSERT INTO otmNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nguetho nu'bʉ 'bʉ a n'da in nde din 'yɛ̨hɛ nanguecä, jatho da bɛ̨ni tengu dím bɛ̨ngä, nɛ ga com'be ma ts'ɛdi bʉ mahɛ̨ts'i bʉya. Nu'bʉ 'bʉ a n'da din 'yɛ̨hɛ nanguecä, nu'a ma Ta da numanho a. ");
INSERT INTO otmNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","―Pɛ nuya ɛ̨mmɛ tu ma mbʉi, bi 'yɛ̨n'a ra Jesús. 'Bɛ'a sä ga xih ma Ta. Ha sä ga äpi di 'uegä 'bɛ'a din jacä ya. Pɛ hingui sä, nguetho gue'a bá ɛ̨cä ngue gan nu'a i jatho gan nugä ya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nɛ nubʉya bin yąui rá Ta: ―Ma Ta a i, dami jaqui gan nugä hønt'a go nda'a dí t'ɛ̨s'i i, bi 'yɛ̨mbi. 'Bexque bi t'ø'a n'da ra nde bʉ mahɛ̨ts'i, bi 'yɛ̨na: ―Pɛ ya dí ja'i guín nu, nɛ guin nu mahøn'a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nɛ nu'ʉ yʉ ją'i mí 'bähmbʉ bʉ, bi 'yøh rá nde Oją nɛ bi 'yɛ̨n'ʉ 'da: ―Bin gäni. Nɛ nu'ʉ mi'da: ―Masque n'da rám 'bɛhni Oją mahɛ̨ts'i bi zofo, bi 'yɛ̨n ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pɛ nu'a ra Jesús bi 'yɛ̨mp'ʉ: ―Nu'a ra nde gá 'yøhmbʉ, nts'ɛdi bi zocä Oją, hin nangue ga pącä bi 'yøh ma nde, pɛ guepʉ gui pąhmbʉ ya i øh ma ndegä a. ");
INSERT INTO otmNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nuya mi ts'ʉtho ga øt'ä a dí fądi nda'ʉ da mba ma ʉnbi, nɛ nda'ʉ hin da mba ma ʉnbi. Nɛ mi ts'ʉtho ga tąp ra zįthu, gue in ts'ʉt'abi ua ja ra ximhäi a, nɛ da ts'änba ya da t'ɛrbʉ ja ran ʉnbi. ");
INSERT INTO otmNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nu'bʉ dá cuat'ä bʉ ja ra pont'i, gue'a dá zohn'dʉ gätho yʉ́ mbʉi yʉ ją'i ga xifi di däc yʉ́ mbʉi gan yąn'ʉ, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nɛ guehna mi man na, ngue mi ndepe xtám bąh yʉ ją'i 'bɛ'a nín dąte dí tho a. ");
INSERT INTO otmNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nɛ nu yʉ ją'i bʉya bi dąt'a: ―Nugähe ya dá øhmbe im mam bʉ ja rán t'ɛ̨di Oją, i 'bʉi mazą̈i a ra Cristo. Nɛ guí ɛ̨nsɛ jatho gui tu bʉ ja ra pont'i, gán ją'i ua ja ra ximhäi. To'o e ngue guí ɛ̨nsɛ gán ją'i ua ja ra ximhäi. Masque hinga gue'e gra Cristo 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nu ra Jesús 'bex bi 'yɛ̨mp'ʉ: ―Him min ngu yʉ pa ga xän'nahʉ ya, ngue drán nɛquigä. Nde'bʉ gan 'yohʉ bʉ ja ran nɛqui ya, nɛ hin da zʉ ahʉ ra 'bɛxui. Nguetho nu'a to'o i 'yo bʉ ja ra 'bɛxui hingui pądi hapʉ i 'yo. ");
INSERT INTO otmNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dami hyąmhbʉ ran nɛqui ya, janya i ja ya, nɛ din ja ran nɛqui ni mbʉihʉ bʉya, bi 'yɛ̨mp'ʉ. Nɛ nu'bʉ mí jua a bi man ra Jesús bi mba, bin 'yąnsɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pɛ guexta'a him bi 'yɛ̨c'yɛi xʉn ngu ma mijudíohe, madague'a xʉn ngu yʉn t'øt'e nuįxte bi nu bi 'yøt' ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pɛgue bin ja tengu thoho bi man ra pøngahyą Isaías 'bʉ mí ma 'bɛ'a din ja, bi 'yɛ̨na: Ma Hmu i, to'o maha bi 'yɛ̨c'yɛi a dá mamhbe nɛ to'o bi bą 'bʉ gmí 'yuh ni ts'ɛdi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Him bi zä bi 'yɛ̨c'yɛi ʉ 'da nguetho nu'bʉ him mín nde ʉ, bi mba njapi tengu bi man ra Isaías 'bʉ mí ma mahøn'a: ");
INSERT INTO otmNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nu'a Oją bi gomba yʉ́ dä ʉ nɛ bi mɛp yʉ́ mbʉi ʉ, gue din ja tengu'bʉ din xädä, nɛ hin din ja yʉ́n 'yomfɛ̨ni yʉ́ mbʉi, nɛ hin da zä di päh yʉ́ mbʉi gue xtí punba Oją ʉ, bi 'yɛ̨n a ra Isaías. ");
INSERT INTO otmNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Guehna bi man ra Isaías 'bʉ mí 'yut Oją din ja rá ts'ɛdi nuįxte ra Cristo, nɛ bi mam bʉya 'bɛ'a da 'yøt'a ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pɛ xʉn ngu ma ngʉrpihe mim bɛ̨nsɛ ngue ɛ̨c'yɛi ra Jesús. Pɛ him bi ma gue ɛ̨c'yɛi ʉ, nguetho i su xtá hyøn a thi yʉ fariseo bʉ ja yʉ́ niją, gue má zä da zan'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nguetho man'da bi bɛ̨ni 'bɛ'a da man yʉ́ miją'ihʉ, gue da 'yɛ̨mbi xʉn ho ʉ, xinda gue'bʉ go xtá 'yɛ̨mp Oją xʉn ho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pɛ nu ra Jesús nts'ɛdi bi ma: ―Nu'a to'o i ɛ̨c'yɛigui, i ɛ̨c'yɛi a bá pɛngui. ");
INSERT INTO otmNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nguetho nu'ʉ to'o i pąqui, i pą a bá pɛngä. ");
INSERT INTO otmNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nu'a bá ɛ̨cä gue ga yorba yʉ́ mbʉi ʉ 'bʉcua ja ra ximhäi. Nu'a to'o da dɛngui hin din 'yo bʉ ja ra 'bɛxui a. ");
INSERT INTO otmNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nu'a to'o da 'yøh mam hmangä nɛ hingui ɛ̨c'yɛi, pɛ hinga guecä ga juąnbä a, nguetho hin ná ɛ̨cä ga øt' ran juąnbate, pɛ ná ɛ̨cä ua gan yąn ʉ 'bʉcua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nu'a to'o hin da 'yɛ̨c'yɛigui nɛ hin da 'yø a dím mangä ya, nu'a mam hma dá mangä ya, gue'a dí juąnba ʉ 'bʉ rán zɛgui ra pa. ");
INSERT INTO otmNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nguetho him mam hmansɛ a dá ma, pɛ nu'a ra Ta gue bá pɛngä bi xiqui 'bɛ'a dá mangä nɛ 'bɛpʉ ná xänba yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nɛ dí pącä da dįn ra te maząi ʉ to'o da hyąn rám hma ma Ta. Nɛ gue'a i xicä a nɛ dí mangä a bʉya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nu'bʉ mi ts'ʉtho da mbʉh ra dąmpɛti nangue ran dąbaxjua, nɛ mí pąh ra Jesús ya mi ts'ʉtho da zøn ra ora da bøngua ja ra ximhäi, da mbeng bʉ bí 'bʉh rá Ta. Nɛ gätho yʉ pa mi 'bʉcua, midí huɛ̨c'ʉ to gätho bi 'yɛ̨c'yɛi a, nɛ nuya man'da di huɛ̨c'ʉ di huɛ̨qui. ");
INSERT INTO otmNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nɛ nu'bʉ mán sihmɛhe ra Jesús 'bʉ bin de, nu'a ra zįthu bʉya bi bɛ̨nba ra Judas rá ts'ʉnt'ʉ ra Simón Iscariote gue di dä a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nu ra Jesús i pądi bí nɛxpʉ 'bʉh rá Ta nɛ da mbeng bʉ mahøn'a, nɛ i pądi gue rá Ta bi unni gätho 'bɛ'a i ja gue di manda zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pɛ guehma bin 'yɛ̨hɛ nanguecähe. Nguetho bi ndants' 'bʉ mín sihmɛ nɛ bi mbø'a n'da rá pahni, in nde nte di hɛ̨ni. Nɛ bi dut' rá foho n'da ran thu'yɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nɛ nu'bʉ mí xit' ra dehe ra ximbo, bi dʉ'mi bi mberca ma guahe nɛ bi dugahe nangue'a ran thu'yɛ mim bongui bʉ rá foho. ");
INSERT INTO otmNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nɛ nu'bʉ mí zøm bʉ huh ra Simón Pedro, nu ra Pedro bi 'yɛ̨mp'a bʉya: ―Ma Hmu i, ha gui perca ma gua, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nu ra Jesús bi dąti nɛ bi 'yɛ̨mbi: ―Majuąni hingui sä gui pąh ya 'bɛ'a nam bøn'a dí øt'ä, pɛ m'bɛjua da zä gui pądi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nu ra Pedro xø bi 'yɛ̨mp'a: ―Njąm'bʉ dan uni gui perca ma gua. Pɛ nu ra Jesús bi dąt'a: ―Nu'bʉ hin ga pe't'ä ni gua, nte man jaui 'bʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nu ra Simón Pedro bʉya bi 'yɛ̨mp'a: ―Ma Hmu i, hinga hønt'a ma gua 'bʉ, nɛ'a ma 'yɛ nɛ'a ma yą, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nu ra Jesús bi 'yɛ̨mp'a: ―Pɛ ya ma zä bi bo ahʉ nangue ni ts'oquihʉ, nguetho nu'a to'o bin hi ya bi bo rá ją'i. Pɛ hønt'ʉ ni guahʉ ząi da 'be't'e ngue pärpʉ yʉ fonthäi hapʉ guí 'yohʉ. Pɛ nu n'da ahʉ him bin hi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ngubʉ bi ma nguetho bi bądi i hupʉ a di dä a. Janangue'a bi ma hinga gätho dán hihe. ");
INSERT INTO otmNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nu'bʉ mí jua a bi xʉguagahe, bi hye mahøn'a rá pahni nɛ bin säya. Bi 'yɛ̨nje bʉya: ―Ha guí pąhmbʉ 'bɛ'a nam bøn'a dá øt'ahʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nu ahʉ guí ɛ̨njʉ drá xänbategä nɛ guí ɛ̨njʉ drá Hmugä. Xʉn ho guím mamhbʉ nguetho gue'a dí øt'ä a. ");
INSERT INTO otmNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Dá pe't'ä ni guahʉ, guecä ni xänbatejʉ nɛ ni Hmujʉ. Janangue'a nɛ ahʉ gam perpa ni guahʉ n'da ngu n'da ahʉ, ngue gui 'yøthʉ gui cohmbʉ häi nɛ 'da gdám fäxtahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nuya dá ut'ahʉ 'bɛ'a gui 'yøthʉ nguetho dín nde ahʉ gui 'yøthʉ tengu dá øt'ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Majuąni dí xi ahʉ, man'da nuįxte n'da ra Hmu xinda gue'ʉ yʉ́ mbɛfi, man'da nuįxte a i pɛhnate xinda gue'a ram 'bɛhni. ");
INSERT INTO otmNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nu'bʉ guí pąhmbʉ a dím mangä ya nɛ thocpa thoho gui 'yøthʉ a, gan johyahʉ nangue Oją 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pɛ hín dím mangä gätho ahʉ da zä gan johyahʉ nangue Oją, nguetho dí pąt'a ni mbʉihʉ n'da ngu n'da ahʉ gue dá huan'nahʉ. Pɛ guehma dá huahni gätho ahʉ, n'dahma din ja 'bɛ'a bi man rá t'ohni Oją ngue bi 'yɛ̨na: “Nu'a n'da dí sihmɛ'be, gue'a di dägä a.” ");
INSERT INTO otmNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","M'bɛt'o dí xi ahʉ 'bɛ'a da t'ørcä, janangue'a da zä gui thoqui gui 'yɛ̨c'yɛigahʉ gue drá Cristogä 'bʉ ya bin ja. ");
INSERT INTO otmNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Majuąni dí xi ahʉ, nu'a to'o da 'yømanho a im man a n'da mam 'bɛhnigä, i simanhogä a nɛ i simanho a bá pɛngä, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nu'bʉ mí jua a bi man ra Jesús, bi du rá mbʉi, nɛ bi xije mahøn'a: ―Majuąni dí xi ahʉ, i 'bʉ a n'da ahʉ di dägä, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nugähe bʉya dyʉ xädigähe, dán hyɛ̨the n'da ngu n'daje nɛ dán 'yänhde: “To'ogahʉ di dä 'bʉ,” dán 'yɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nɛ nugä 'darpʉ mi hu'be ra Jesús nguetho ɛ̨mmɛ midí huɛ̨gä. ");
INSERT INTO otmNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nu ra Simón Pedro bʉya bi uąnga rá 'yɛ, ndeque ga änni nda'a di dä a. ");
INSERT INTO otmNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nugä bʉya gue 'darpʉ mí hu'be ra Jesús, dá änni: ―Ma Hmu i, to'o a guím ma, dá ɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Bi 'yɛ̨ngä a ra Jesús bʉya: ―Nu'a ga cärpa a ra hmɛ ra tʉhʉ gue ga unni, gue'a di dägä a, bi 'yɛ̨ngä a bʉya. Nɛ 'bex bi un'na ra hmɛ a ra Judas Iscariote rá ts'ʉnt'ʉ ra Simón. ");
INSERT INTO otmNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nɛ nu'bʉ mí zi ra hmɛ, 'bex bi yʉt' ra zįthu rá mbʉi. Nɛ nu ra Jesús bi 'yɛ̨mbi: ―Nu'a guí nde gui 'yøt'e dami 'yøt'a n'dihi ya, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nɛ xínga n'dagähe mi huhmbe bʉ ja ra mɛxa gue dá pąhmbe 'bɛ'a nám bøn a bi xifi. ");
INSERT INTO otmNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pɛ 'dagähe dím bɛ̨mhbe gue gue'a bi xih ra Judas da mba da däi 'bɛ'a ga homhbe 'bʉ bin ja ra dąnts'ihmɛ. Nɛ nu mi'da gähe dím bɛ̨mhbe gue bi xih ra Judas da mba di unni ts'ʉ ra mbɛti yʉ hyoya, nguetho mí hą ra buxa i o ma mbɛtihe. ");
INSERT INTO otmNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nɛ nu'bʉ ya xí zi ra hmɛ, 'bex bi mba n'dihi. Ya bin xui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nu'bʉ ya xí mba ra Judas, nu ra Jesús bi 'yɛ̨ngähe: ―Nuya di nɛqui dan uįxtegä guecä dán ją'igä ua ja ra ximhäi. Nɛ nu'a ga øt'ä ya, gue'a man'da dí nɛqui gue xʉn hotho Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ga udi nuįxte xʉn hotho Oją, nɛ nu Oją da 'yudi gue nuįxte xʉn hogä guecä ngue dán ją'i ua ja ra ximhäi. Nɛ mi ts'ʉtho ya din ja a dím mangä. ");
INSERT INTO otmNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ma zʉ t'ʉhni ahʉ, man'da zʉ ora dam 'bʉhmbʉ ya. Nɛ m'bɛjua guim bɛ̨njʉ. Nɛ ga xi ahʉ ya tengu dá xi ʉ ma ngʉrpihʉ, hingui sä 'darbʉ ga mbähä hapʉ ga mbagä. ");
INSERT INTO otmNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nuya ga xi ahʉ n'da ran t'ɛ̨di ma'da'yo, gue 'da xtín huɛ̨ctahʉ n'da ngu n'da ahʉ. Tengu thoho bʉ dá huɛ̨c'ahʉ, ngubʉ gan 'yørpahʉ n'da ngu n'da ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nangue 'da gdín huɛ̨ctahʉ n'da ngu n'da ahʉ, gätho yʉ ją'i da bądi guí tɛngahʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nu ra Simón Pedro bi 'yɛ̨mp'a: ―Ma Hmu i, hapʉ gui mba. Nu ra Jesús bi dąt'a: ―Hingui sä 'bex gui tɛngä ya hapʉ ga mba. Pɛ m'bɛjua da zä gui mba bʉ ga mbagä. ");
INSERT INTO otmNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Janangue'a nu ra Pedro bi 'yɛ̨mp'a: ―Hanja hingui sä 'darpʉ ga mbɛ ya, madague'a nɛcä da thogä nangue'a ga tɛn'ni i, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nu ra Jesús bi dąt'a: ―Ha majuąni gui tɛngui madague'bʉ da tho i, nguetho ná hyundį xquí cøng 'bʉ bi mbah ra tamfø, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","―Pɛ o di tu ni mbʉihʉ. Guí ɛ̨c'yɛihʉ Oją janangue'a nɛcä dami 'yɛ̨c'yɛigahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nubʉ rá ngu ma Ta bí ja bʉ xʉn ngu yʉ ngu mahotho. Nu'bʉ hin te di ja bʉ, xcá xi ahʉ 'bʉ. Pɛgue i ja bʉ, janangue'a nu'bʉ dá mbagä gua hoc'ahʉ hapʉ dam 'bʉhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɛ nu'bʉ dá mbagä ba hoc'ahʉ bʉ dam 'bʉhmbʉ, nɛ ba pengä mahøn'a ga six ahʉ bʉ ngue 'darpʉ dam 'bʉhmbʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nubʉ ga mbagä guí pąhmbʉ nɛ guí pąhmbʉ ra 'yu, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Pɛ nu'a ra Tomás bi 'yɛ̨mp'a: ―Ma Hmu i, hin dí pąhmbe hapʉ gui mba, xín dí pąhmbe a ra 'yu, bi ' yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nu ra Jesús bi 'yɛ̨mp'a: ―Nugä drá 'yugä nɛ guecä ní fą a majuąni nɛ dadí ungä ra 'da'yote maząi. Njon da zä da zøm bʉ 'bʉh ma Ta hinda hønt'bʉ da 'yɛ̨c'yɛigui. ");
INSERT INTO otmNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu'bʉ majuąni xquí pąjʉ nɛ'a ma Ta xquí pąhmbʉ 'bʉ. Pɛ ja gá pąhmbʉ ya nguetho ya guín nuhʉ a ya, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pɛ nu ra Felipe bi 'yɛ̨mp'a: ―Ma Hmu i, pɛ hin dín nuhe a ni Ta, dami jaje gan nuhe nɛ nte ga 'bɛhmbe, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nu ra Jesús bi dąt'a: ―Ha guexta'a hin guí pąqui nɛ nya'a tho xtám 'bʉhmbʉ. Nu'a to'o xʉn nugui, ya xʉn nu ma Ta. Hanja gní 'yɛ̨ngui: “'Yurcahe ni Ta.” ");
INSERT INTO otmNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ha hin guí ɛ̨c'yɛi gue n'datho dí com'be ma Ta. Nu'ʉ yʉm hma dí xi ahʉ him mam hmansɛgä ʉ, pɛ yʉ́m hman a ma Ta i 'bʉcua ja ma mbʉigä, nɛ gue'a di jacä ga øt'ä a dí øt'ä. ");
INSERT INTO otmNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dami 'yɛ̨c'yɛigahʉ gue n'datho dí com'be ma Ta. Pɛ nu'bʉ xʉn hɛ̨i gui pąhmbʉ, dami pąhmbʉ gue hønt'a Oją sä i øt'ʉ yʉ nuįxte dí øt'ä. Janangue'a da zä gui 'yɛ̨c'yɛihʉ gue n'dat'a dí com'be ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Majuąni dí xi ahʉ, nu'bʉ gui 'yɛ̨c'yɛigahʉ, nu ra 'bɛfi dí øt'ä, nɛ ahʉ da zä gui 'yøthʉ 'bʉ. Nɛ man'da nuįxte yʉ 'bɛfi da zä gui 'yøthʉ nguetho ga mba bʉ bí 'bʉh ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nguetho hønt'a go 'bɛ'a gui 'yähmbʉ 'bʉ 'da angu dím bɛ̨mhbʉ, ga øt'ä, janangue'a da t'ɛ̨spa ma Ta nangue a ga øt'ä, rá Ts'ʉnt'ʉgä a. ");
INSERT INTO otmNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hønt'a go 'bɛ'a gui 'yäqui 'bʉ n'dat'a dím bɛ̨mhbʉ, ga øt'ä. ");
INSERT INTO otmNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nɛ man'da bi man ra Jesús, bi 'yɛ̨na: ―Nu'bʉ majuąni høngdä guín numanhojʉ, dami pɛs'hʉ 'bɛ'a gätho dí xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɛ ga äp ma Ta ba pɛn'nahʉ man'da nim fäts'ihʉ da mbäx ahʉ tengu dá øt'ahʉ, nɛ gam 'bʉhmbʉ maząi a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Gue'a rá Hogandąhi Oją a, nɛ di ja ahʉ gui pąhmbʉ a majuąni. Pɛ nu'ʉ di ho ra ximhäi hin da zä da zini, nguetho hin'yʉ 'bɛ'a dí bą a, xíngui pądi 'bɛ'a rá 'bɛfi a. Pɛ nu ahʉ guí pąhmbʉ a nguetho dí 'bʉhmbʉ a, nɛ da zøn ra pa din ząm bʉ mbo ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Hin gan jahʉ tengu yʉ hyoya t'ʉhni 'bʉ dá mbagä, nguetho ba pengä dam 'bʉcä bʉ mbo ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mi ts'ʉtho ya him man da nuc'ʉ di ho ra ximhäi. Pɛ nu ahʉ da zä guin nujʉ nangue ni mbʉihʉ, nɛ ząi gam 'bʉhmbʉ nguetho ząi dí 'bʉcä. ");
INSERT INTO otmNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nɛ nu a ra pa da zøh rá Hogandąhi Oją, da zä gui pąhmbʉ gue dam 'bʉpʉ mbo ni mbʉihʉ, nɛ gam 'bʉhmbʉ bʉ ja ma mbʉigä bʉya. Nɛ da zä gui pąhmbʉ dí 'bʉi nangue ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Hønt'a go to'o i øt' man t'ɛ̨digä nɛ pɛ'ts'a mam hmangä, gue'a majuąni høngdä i numanhogä a. Nɛ nu'a ma Ta nɛcä ga huɛ̨c'be a, nɛ ga japi da bądi xʉn ho ma ts'ɛdi, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nu'a ra Judas, pɛ hinga gue'a ra Judas Iscariote, bi 'yän'na bʉya: ―Haguen ja høngdähe gui jaje ga pąhmbe xʉn ho ni ts'ɛdi, nɛ hin'na ʉ di ho ra ximhäi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nu ra Jesús bi dąt'a: ―Nu'bʉ i 'bʉ a n'da ahʉ majuąni høngdä i numanhogui, da mbɛsca mam hmangä a 'bʉ. Nɛ di huɛ̨c'a ma Ta bʉya, nɛ ba ɛ̨'be, nɛ dan ząm'be bʉ mbo rá mbʉi a. ");
INSERT INTO otmNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pɛ nu'a to'o hingui numanhogui, hingui pɛ'ts' mam hmangä a. Nɛ nu'a mam hmangä, him mam hmansɛgä pɛ rám hma ma Ta gue'a bá pɛngä ua, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nɛ xø bi 'yɛ̨na: ―Nuya yʉm hma dá xi ahʉ gätho yʉ pa dám 'bʉhmbʉ ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pɛ nu'a nim fäts'ihʉ rá Hogandąhi Oją gue ba pɛnh'nahʉ ma Ta, tengu'bʉ da guecsɛgä a, nu'a di bɛ̨n'nahʉ yʉm hma xtá xi ahʉ, nɛ da xän'nahʉ 'bɛ'a gätho mi'da. ");
INSERT INTO otmNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Dadín 'yɛ̨hmbʉ ya, dami hyąmhbʉ ran t'unni ngue ran johya dadí 'da ahʉ ya, nɛ thocpa thoho din ja ahʉ. Hinguin ja tengu rán johya ra ximhäi. O di tu ni mbʉihʉ nɛ hin din su ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nɛ nu'bʉ majuąni guín numanhojʉ, din johya ni mbʉihʉ nanguehna dí xi ahʉ: “Ga mba bʉ bí 'bʉh ma Ta.” Nɛ man'da ja rá ts'ɛdi xinda guecä. ");
INSERT INTO otmNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nugä xtá xi ahʉ 'bɛ'a gätho din ja guepʉ da zä man'da gui 'yɛ̨c'yɛigahʉ 'bʉ ya bin ja. ");
INSERT INTO otmNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nuya him ma nya'a dan yąhʉ ya, nguetho ba ɛ̨pʉ rá ngʉrpi ra ximhäi. Pɛ njąm'bʉ bi dącpä a, janangue hin'yʉ rá ts'ɛdi da dącpä a ya. ");
INSERT INTO otmNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pɛ jatho ga øt'ä a ma 'bɛfi ga øt'ä ya, n'dahma da bą ʉ 'bʉcua ja ra ximhäi hønt'a ma Ta dín numanhogä, nɛ ząi dí øt'a i xiqui. Janangue'a ga ndanshʉ ya ga mbähä, bi 'yɛ̨nje ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nu ra Jesús bi 'yɛ̨na: ―Nugä drá za majuąni, ngue i zʉh yʉ́n dät'o. Nɛ nu'a ma Ta di jamansu a. ");
INSERT INTO otmNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nɛ nu'ʉ yʉ́ 'yɛ hingui ja yʉ́n dät'o, nu'a ma Ta da hyɛqui, nɛ da mbøgue. Pɛ nu'ʉ yʉ 'yɛ i ja yʉ́n dät'o, di hoqui gue din ja mi'da yʉ́n dät'o. ");
INSERT INTO otmNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nu'ahʉ ya mahoqui ahʉ nangue mam hmangä dá xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dami thojʉ ngue thocpa thoho dam 'bʉhmbʉ. Nguetho hingui sä gui 'yøthʉ rá 'bɛfi Oją 'bʉ hin gui thoqui gui hyąmhbʉ ma tegä, tengu n'da rá 'yɛ ra za hingui sä din jasɛ yʉ́n dät'o 'bʉ hin da nɛxpʉ rá te a rá za. ");
INSERT INTO otmNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nugä tengu'bʉ drá za, nu ahʉ tengu'bʉ yʉ́ 'yɛ ahʉ ra za i zʉh yʉ́n dät'o. Nu'a to'o da guat'i nanguecä, da hyąnga ma ts'ɛdi nɛ din zʉdi xʉn ngu yʉ́n dät'o. Pɛ nu'a hin da guat'i nanguecä nte din ja. ");
INSERT INTO otmNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu a to'o da hyɛgä din ja tengu n'da ra 'yɛza 'bʉ bi däsɛ, da 'yot'i, da mba ma bʉnt'i nɛ i pa ma pɛti da t'upʉ ja ra sibi. ");
INSERT INTO otmNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nu'bʉ gui thoqui gui cuathʉ nanguecä nɛ'bʉ din ząm bʉ ja ni mbʉihʉ mam hmangä, dami 'yähmbʉ 'bɛ'a guín nde gui 'yähmbʉ nɛ din ja bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɛ nu'bʉ din ja xʉn ngu nin dät'ohʉ, gue'a dí 'yu a rá nuįxte ma Tahʉ a, nɛ gue'a dí fądi majuąni ma 'yɛ̨c'yɛi ahʉ a. ");
INSERT INTO otmNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tengu thoho bʉ ni huɛ̨gä ma Ta, ngubʉ na huɛ̨c'ahʉ. Dami thoqui guin ndehʉ man huɛ̨cate. ");
INSERT INTO otmNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu'bʉ gui pɛspʉ ni mbʉihʉ gätho dí xi ahʉ nɛ gui 'yøthʉ a, da zä thocpa thoho gui pąhmbʉ man huɛ̨cate 'bʉ. Tengu bʉ na pɛ'ts'ä rám hma ma Ta, janangue'a thocpa thoho dí pąh rán huɛ̨cate. ");
INSERT INTO otmNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gätho ya dí xi ahʉ n'dahma ga comhbʉ a man johyagä, nɛ da yupʉ ni mbʉihʉ nɛ da bonts' thoho bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nu'a man t'ɛ̨di dí xi ahʉ, gan huɛ̨jʉ n'da ngu n'da ahʉ, tengu bʉ na huɛ̨c'ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nu'a ran huɛ̨cate man'da xʉn ho, gue di un rá te n'da nangue ʉ yʉ́ amigo da yąni. ");
INSERT INTO otmNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nu ahʉ ma amigo ahʉ 'bʉ guí øthʉ 'bɛ'a gätho dí xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Him ma xi ahʉ ma 'yɛ̨hɛ ahʉ, nguetho nu a ra 'yɛ̨hɛ hingui pądi 'bɛ'a i øt' rá hmu. Pɛ nuya dí xi ahʉ ma amigo ahʉ, nguetho ya dá xi ahʉ gätho bi xicä ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nu'ahʉ hin gá huangahʉ, pɛ go dá huan'nahʉ nɛ dá sän'nahʉ din zʉh nin dät'ohʉ, nangue gui 'yøthʉ ma 'bɛfigä nɛ da hyät' maząi. Janangue'a hønt'a go 'bɛ'a gui 'yähmbʉ ma Ta nangue n'dat'a dím bɛ̨mhbʉ, din ja bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nuna man t'ɛ̨digä dí xi ahʉ, gan huɛ̨jʉ n'da ngu n'da ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nɛ xø bi 'yɛ̨n'a ra Jesús: ―Nu'bʉ di ʉc'ahʉ ʉ di ho ra ximhäi, dami pąhmbʉ m'bɛt'o thoho bi ʉgä. ");
INSERT INTO otmNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu'bʉ da 'da angu guí øthʉ ʉ di ho ra ximhäi, nu'ʉ da numanho ahʉ ʉ 'bʉ. Pɛ hin guí øthʉ tengu øt'ʉ nguetho dá huan'nahʉ. Janangue'a di ʉc'ahʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pɛ guim bɛ̨mhbʉ a ram hma dá xi ahʉ: “Pɛ man'da rán säui da hnumanho n'da ra Hmu xinda gue'ʉ yʉ́ mbɛfi.” Nɛ nugä hingui hnumanhogui, janangue'a ha ma gue'adahʉ, da hnumanho ahʉ. Nɛ him bi t'ømanho a dá ma, janangue'a ngutho hin da t'ømanho a guim mamhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nɛ din ja bʉ da t'øt'ahʉ nangue guí tɛngahʉ. Nguetho nu'ʉ di ho ra ximhäi hingui pą a bá pɛngä. ");
INSERT INTO otmNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nu'bʉ hin xcá søcä ua gue xcá zofo, hin xtám bądi gue ja yʉ́ ts'oqui 'bʉ. Pɛ nuya hingui sä da gøn yʉ́ ts'oqui ʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu'a to i pøh rá cuɛ nanguecä, nɛ a ma Ta i numan'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nu'bʉ hin xcá øt' yʉn t'øt'e njo'o sä da 'yøt'e, hin xtám bądi gue ja yʉ́ ts'oqui 'bʉ. Pɛ nuya ya bi nu man t'øt'e nuįxte. Pɛ bi cuɛcthohogä ʉ. Pɛ nu'ʉ bi ʉgä gue'a ma Ta bi ʉp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pɛ gue'a mán t'o't'i bʉ ja rán t'ɛ̨di Oją maya'bʉ, bi 'yɛ̨na: “Din ja ra cuɛ nanguecä, pɛ hin'yʉ 'bɛ'a dín cuɛ ʉ,” mí ɛ̨n ra t'ohni ząi din xä ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pɛgue ga xicä ma Ta ba pɛn'nahʉ rá Hogandąhi, nɛ da mbäx ahʉ di ja ahʉ gui pąhmbʉ a majuąni nɛ da xi ahʉ nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nɛ ahʉ da zä guim mamhbʉ majuąni nanguecä, nguetho gätho yʉ pa xtám'bʉhmbʉ gue'bʉ go má tʉm' ra 'bɛfi nɛ guehya, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nɛ man'da bi man ra Jesús bi 'yɛ̨na: ―Guehya dí xi ahʉ n'dahma hin gui hyɛgahʉ 'bʉ gá nuhʉ yʉn ʉnbi. ");
INSERT INTO otmNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nguetho da hyøn ahʉ thi bʉ ja yʉ́ niją ma mijudíohʉ, nɛ da zøn ra pa da hyo ahʉ nɛ da bɛ̨ni gue'a ní 'yørpa rá 'bɛfi Oją a. ");
INSERT INTO otmNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nɛ din ja bʉ da 'yøt'ahʉ, nguetho him bi bącä, xínga gue'a ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pɛ nuna dí xi ahʉ, janangue'a nu'bʉ bin ja, guim bɛ̨mhbʉ bʉya gue gue'a xtá xi ahʉ. Nɛ nuna dí xi ahʉ ya, hin dá xi ahʉ mám'bɛt'o, nguetho hin ní zøn ra ora ga mba. ");
INSERT INTO otmNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","―Nuya ga mbagä bʉ bí 'bʉ a bá pɛngä. Nɛ xínga n'da ahʉ guí ängahʉ ya hapʉ ga mbagä. ");
INSERT INTO otmNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nguetho i tu ni mbʉihʉ ngue dá xi ahʉ ga mbagä. ");
INSERT INTO otmNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pɛ guehma majuąni dí xi ahʉ, man'da xʉn ho nangue ahʉ ngue ga mbagä. Nguetho nu'bʉ hin ga mbagä, hin da zä ba ɛ̨h nim fäts'ihʉ 'bʉ. Pɛ nu'bʉ dá mbagä, ba pɛn'nahʉ nim fäts'ihʉ gue rá Hogandąhi Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nɛ nu'bʉ bi zøcua ja ra ximhäi rá Hogandąhi Oją, di jap yʉ ją'i ua ja ra ximhäi da bądi i ja yʉ́ ts'oqui, nɛ di japi da bądi drá 'yugä nangue ran ho, nɛ di japi da bądi din ja rá muui ran ts'o. ");
INSERT INTO otmNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nu rá Hogandąhi Oją di bɛ̨nba yʉ ją'i gue i jatho yʉ́ ts'oqui nguetho him bi xiqui gan yąnba yʉ́ te. ");
INSERT INTO otmNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nɛ di bɛ̨nba yʉ ją'i gue drá 'yugä nangue ran ho. Da fądi nguetho ga thąmbɛ̨ni nɛ da zingä ma Ta bʉ bí 'bʉi, nɛ hin da hnugä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nɛ nu rá Hogandąhi Oją di bɛ̨nba yʉ ją'i ngue din ja ran ʉnbi rá muui ran ts'o, nguetho da ts'änba rá muui a rá 'bɛfi ra zįthu gue nu'a rá ngʉrpi ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Guexta'a i jagä xʉn ngu dín nde ga xi ahʉ, pɛ hin gui hyäthʉ gui 'yøhmbʉ mi'da 'bʉ ga xi ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pɛ nu'bʉ bi zøcua rá Hogandąhi Oją, da xän'nahʉ gätho a majuąni. Nɛ nte da mansɛ nanguesɛ, pɛ hønt'a 'bɛ'a da xi Oją, gue'a da xi ahʉ a. Nɛ da xän'nahʉ 'bɛpʉ gdí 'yøthʉ rá 'bɛfi Oją, nɛ da xi ahʉ 'bɛ'a gätho man'da din ja. ");
INSERT INTO otmNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nɛ di japi da fądi i ja ma ts'ɛdi xʉn ho, nguetho ga un mam hma da xän'nahʉ nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nu'a nam bøni n'dat'a ra ts'ɛdi i jac'be ma Ta, janangue'a dá xi ahʉ, ga un mam hma da xän'nahʉ nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","―Nɛ hin guin nujʉ man'da pa o gue manyopa, pɛ sä guin nujʉ mahøn'a mi'da yʉ pa, nɛ m'bɛjua ga mba bʉ bí 'bʉh ma Ta, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Bex bin 'yän'dʉ 'da ma mixädihe: ―'Bɛ'a ní mba bi ma, nɛ ɛ̨na: “Hin guin nujʉ man'da pa o gue manyopa, pɛ sä guin nujʉ mahøn'a 'da yʉ pa, nɛ m'bɛjua ga mba bʉ bí 'bʉh ma Ta,” bi 'yɛ̨njʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","'Bɛ'a ní mba gue bi xijʉ na, 'bɛ'a da 'yøt'e 'da yʉ pa. Hingui sä ga pąhmbʉ 'bɛ'a man na, bin 'yɛ̨mzɛhɛ ma mixädihe. ");
INSERT INTO otmNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nu ra Jesús mi pądi 'bɛ'a nde da 'yänni, gue 'bɛ'a nam bøn'a xí man a, nɛ bi 'yɛ̨nje: ―Ha gadín 'yänzɛhɛhʉ 'bɛ'a nám bøn'a dám mangä 'bʉ má xi ahʉ: “Hin guin nujʉ man'dapa o manyopa, pɛ sä guin nujʉ mahøn'a mi'da yʉ pa,” gue dá ɛ̨ngä. ");
INSERT INTO otmNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Majuąni dí xi ahʉ, da du ni mbʉihʉ nɛ gan zomhbʉ, pɛ nu'ʉ yʉ ją'i i tɛn ra ximhäi din johya ʉ. Pɛ m'bɛjua bʉya nu ni dumbʉihʉ dim pommi ran johya. ");
INSERT INTO otmNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tengu n'da ra xisu 'bʉ bi zøn ra ora dim 'bʉh rá t'ʉhni, i tu rá mbʉi nguetho in nu ran ʉnbi, pɛ m'bɛjua din johya 'bʉ bim 'bʉh rá t'ʉhni bʉya, nɛ him mam bɛ̨n a ran ʉnbi mín nu. ");
INSERT INTO otmNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nɛ ngutho ahʉ i tu ni mbʉihʉ ya. Pɛ gan nu ahʉ mahøn'a nɛ da hyu ni mbʉihʉ, nɛ njon da zä da hyąc'a nin johyahʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nɛ nu'bʉ bi zøn ra ora a dím mangä ya, nte gui 'yängahʉ. Pɛ majuąni dí xi ahʉ, hønt'a go 'bɛ'a gui 'yäfʉ ma Ta 'bʉ 'dat'a dím bɛ̨mhbʉ, nɛ din ja bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nte ganá äfʉ ma Ta nangue ma thuhugä, pɛ nuya dami 'yäfʉ ya nɛ din ja ahʉ, janangue'a da yuh ni mbʉihʉ ran johya. ");
INSERT INTO otmNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","―Nuya yʉm hma dá xi ahʉ, yʉn t'uti ʉ, bi 'yɛ̨n'a ra Jesús. Pɛ da zøn ra ora hin ga xi ahʉ mi'da yʉn t'uti, pɛ njuąntho ga xi ahʉ xʉn ho nangue Oją. ");
INSERT INTO otmNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nɛ nu'bʉ bi zøn'a ra pa dím mangä, da zä gui 'yäpzɛhɛhʉ ma Ta nangue ya guí pąjʉ, nɛ him man ga thocpä a guí äfʉ ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nguetho guesɛ ma Ta di huɛ̨c'ahʉ nangue guín numanhojʉ, nɛ gá 'yɛ̨c'yɛihʉ gue guepʉ bí 'bʉh ma Ta bá nɛxä. ");
INSERT INTO otmNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nugä bá nɛxä bʉ 'bʉh ma Ta, nɛ dá søcua ja ra häi. Nɛ ga pøngä mahøn'a ua ja ra häi, ga mba bʉ bí 'bʉh ma Ta, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","―Nuya mfądi 'bɛ'a guí xije ya, nguetho hin guí xije n'da ran t'uti ya, dá ɛ̨mfe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nuya dí pąhmbe nte guídí 'bɛdi gui pądi, nguetho m'bɛt'o thoho guí pądi 'bɛ'a dím bɛ̨mhbe 'bʉ ya ja a dín nde ga än'nahe. Nɛ gue'a ná pąhmbe gue guepʉ bí 'bʉ Oją gbí 'yɛ̨que, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nu ra Jesús bi 'yɛ̨nje mahøn'a: ―Ha majuąni guí ɛ̨c'yɛigahʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pɛ nuya bi zøn ra ora gan 'uɛ̨xthʉ, gui 'dahmbʉ, n'da an 'danni gui mbähä. Nɛ gätho ahʉ gui sogahʉ. Pɛ hin dan 'dasɛ nguetho dí 'bʉ'be ma Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nuya yʉm hma dá xi ahʉ, n'dahma guexta'a gan johyahʉ nanguecä, madague'bʉ guin nuhʉ ran ʉnbi nangue ra ximhäi. Pɛ o di tu ni mbʉihʉ, pɛ guim bɛ̨mhbʉ dá tąpä ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nu'bʉ mí jua a man ra Jesús, bi ndøts'e, nɛ bin yąui rá Ta: ―Ma Ta a i, ya bi zøm ma oragä din ja a gá sängui. Dami jap ya ɛ̨mmɛ da bømanho 'bɛ'a ga øt'ä ya, ni ts'ʉnt'ʉgui, nɛ gue'a dí fądi nuįxte xʉn ho i bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nguetho ya xcá 'dac ra ts'ɛdi ga unni 'bɛ'a xcá sänba ʉ gätho i 'bʉcua ja ra ximhäi, janangue'a ga un ra 'da'yote maząi ʉ gätho gá 'daqui. ");
INSERT INTO otmNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nɛ nu'a to'o i ja ra 'da'yote maząi, majuąni dím pąhmbʉ ʉ, gue gue'e høn'a thoho i majuąni grá Oją, nɛ nugä drá Jesucristogä gue guá pɛngä dan yąntegä ua. ");
INSERT INTO otmNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ya ní mba bʉ ga juacä ra 'bɛfi gá 'daqui, guepʉ da bąh yʉ ją'i ua ja ra ximhäi ɛ̨mmɛ xʉn hotho i. ");
INSERT INTO otmNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ma Ta i, nu'bʉ ya dá juacä, dami jaqui ga conhui ni nuįxte bʉ guí 'bʉi, tengu tho mín jaui 'bʉ má hin'yʉ ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nuya dá xih yʉ ją'i nangue e, gue nu'ʉ gá huanhua ja ra ximhäi. Ni mbɛti ʉ, nɛ gá 'daqui, nɛ bi mbɛ'ts'a nim hma dá xänba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nɛ i pą ʉ ya gue gue'e gá 'dac ra ts'ɛdi dá øt' ra 'bɛfi dá øt'e, nɛ ʉ yʉm hma dá mangä. ");
INSERT INTO otmNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nguetho bi hyąn'a ram hma gá xiqui dá xifi. Janangue'a i pądi majuąni bá nɛxä bʉ guí 'bʉi, nɛ bi 'yɛ̨c'yɛi gue gue'e guá pɛngä dan yąntegä ua. ");
INSERT INTO otmNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nugä dí äp'a ya gui fäx'i ts'ʉ ʉ, nɛ hin dí ä a nim fäts'i nangue ʉ i tɛn ra ximhäi. Pɛ hønt'ʉ gue gá 'daqui nguetho ni mbɛti ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nɛ nu'ʉ gätho ma mbɛti ni mbɛti ʉ, nɛ nu'ʉ gätho ni mbɛti ma mbɛti ʉ. Nɛ gue'ʉ i udi nuixte xʉn hogä ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nuya him man dam 'bʉcua ja ra ximhäi. Ga mbagä bʉ guí 'bʉi. Pɛ nu'ʉ go di thoqui dim 'bʉcua ʉ. Janangue'a, ma Hogata i, dami jamansu ʉ gätho gá 'daqui nangue ni ts'ɛdi zɛhɛ, gue da gohi tengu'bʉ n'danją'itho tengu gaui. ");
INSERT INTO otmNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Gätho yʉ pa dám 'bʉhmbe ʉ gá 'daqui, dá jamansu ʉ nangue ni ts'ɛdi gá 'daqui. Nɛ xinga n'da bim 'bɛdi, hønt'a n'da nts'änni dim 'bɛdi, tengu mán t'o't'i bʉ ja ni søcuą maya'bʉ ngue ngubʉ din ja. ");
INSERT INTO otmNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nɛ nuya mi ts'ʉtho ga mba bʉ guí 'bʉi, pɛ nuna dím mangä ya ngue dí 'bʉcua ja ra ximhäi, janangue'a da yuh yʉ́ mbʉi ʉ i øh ya nangue man johyagä. ");
INSERT INTO otmNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nugä dá un'na nim hma nɛ bi hyąm bʉya. Janangue'a di ʉcpa ra ximhäi ʉ, nguetho hing yʉ́ mɛngu ua ja ra ximhäi ʉ, tengugä hind rá mɛngugä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hin dí ä'a i gue gui 'uec'ʉ nanguecua ja ra ximhäi ʉ, pɛ dí ä'a i gui jamansup yʉ́ mbʉi hin da dąp ra zįthu ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nu'ʉ hing yʉ mɛngu ua ja ra ximhäi ʉ, tengu thohogä. ");
INSERT INTO otmNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Dami xänbi xʉn ho a nim hma majuąni, janangue'a da 'uegue xʉn ho nangue yʉn ts'o i ja ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tengu tho bʉ guí 'dac ra 'bɛfi dá jap yʉ ją'i ua ja ra ximhäi da bą i, nguthogä dí un ra 'bɛfi ʉ, di jap yʉ ją'i ua ja ra ximhäi da bą'a i. ");
INSERT INTO otmNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Dan unsɛ janangue'a nɛ'ʉ tengu'bʉ da du nangue yʉ́ nyombʉi, nɛ da zä da dɛn'na ram hma majuąni. ");
INSERT INTO otmNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nɛ nu'bʉ bi mam mam hmammi ʉ i ɛ̨c'yɛigä ya, nɛ nu'bʉ bi 'yɛ̨c'yɛigä ʉ da sifi, nɛ'ʉ dí äp'a nim fäts'i nangue gätho ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Janangue'a gätho da gohi tengu'bʉ n'danją'itho, tengu thohogaui ma Ta i, n'datho dí conhui. Dami japi n'dat'a da bɛ̨n ʉ, nguetho n'dat'a man 'yomfɛ̨niui dá unui gätho ʉ. Janangue'a da 'yɛ̨c'yɛi ʉ i tɛn ra ximhäi, gue gue'e guá pɛngä dan yąntegä ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nu ra ts'ɛdi gá 'daqui dá undä ʉ, gue da zä da gohi tengu'bʉ n'danją'itho, tengu gaui. ");
INSERT INTO otmNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nugä dí 'bʉhmbe ʉ, nɛ'e dí 'bʉhmi, janangue'a majuąni da zä gätho 'dat'a gam bɛ̨mhbʉ. Nɛ da nu ʉ i tɛn ra ximhäi, da bądi gue gue'e guá pɛngä dan yąntegä ua ja ra ximhäi, nɛ da bą ʉ i tɛn ra ximhäi gue ɛ̨mmɛ guidí huɛ̨c'ʉ tengu bʉ gní huɛ̨gagui. ");
INSERT INTO otmNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ma Ta i, dín nde 'darpʉ dan ząmhbʉ ʉ gá 'daqui, gue da nu maząi a ran ho tąte thoho gá 'daqui. Nguetho ząi guidí huɛ̨gä nɛ gue'bʉ go má hin'yʉ ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ma Hogata a i, nu ra ximhäi hingui pą'a i. Pɛ nugä dí pą'a i, nɛ'ʉ 'da gá 'daqui i pądi gue gue'e guá pɛngä. ");
INSERT INTO otmNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nugä dá japi bi bą'a i, nɛ man'da man'da ga japi da bądi gätho nin ho, gue da zä din ja xʉn ho nin huɛ̨cate bʉ mbo yʉ́ mbʉi ʉ, tengu tho bʉ nan jagä nin huɛ̨cate. Nɛ dan ząm bʉ ja yʉ́ mbʉi ʉ, bi 'yɛ̨mp'a rá Ta. ");
INSERT INTO otmNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nu'bʉ mí jua'a bin yąui rá Ta, dá mbähmbe ra Jesús bʉya dyʉ xädihe, dá 'daxhe n'da ra t'ʉhyɛ̨ gue ra Cedrón, nɛ dá cʉthe bʉ ja n'da ra nuąndät'o. ");
INSERT INTO otmNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nu'a ra Judas, gue'a di dä a ra Jesús, mí pąpʉ ja ra nuąndät'o nguetho ząi mí pähmbe bʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nu yʉ fariseo nɛ yʉ dąmbäją bá pɛhn'dʉ 'da yʉ dofʉi nɛ mi'da yʉn 'yohʉ gue bán 'yohʉ ra Judas. Gätho i hą yʉ sibi nɛ yʉ́ juai. ");
INSERT INTO otmNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nu ra Jesús i pądi gätho 'bɛ'a din ja ngue da t'ørpe. Janangue'a bi mba bin c'athʉ, nɛ bi 'yän'dʉ: ―To'o guí homhbʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nɛ bi dą ʉ: ―Dí homhbe ra Jesús ra mɛngu bʉ Nazaret, bi 'yɛ̨n'ʉ. ―Guecä, bi 'yɛ̨n'a ra Jesús bʉya. Nɛ i 'bähmbʉ bʉ ra Judas gue di dä. ");
INSERT INTO otmNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Guecä,” 'bʉ mí 'yɛ̨n'a ra Jesús, 'bex bi goh yʉ́ xʉtha ʉ yʉn hyonte nɛ bi 'ya ʉ bʉya nangue ra mbidi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nu ra Jesús bi ma mahøn'a: ―To'o guí homhbʉ. Nɛ bi dą ʉ: ―Dí homhbe ra Jesús ra mɛngu bʉ Nazaret, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nu ra Jesús bi dąt'ʉ bʉya: ―Ya dá xi ahʉ, guecä. Pɛ nu'bʉ høngdä guí honjʉ, hinga nɛhya ma xädi gui sixhʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nɛ guehna bi man na ra Jesús bin thɛui a bi xih rá Ta 'bʉ mín yąui, ngue xí 'yɛ̨mbi: “Gätho gá 'daqui xínga n'da ga 'bɛdi,” xí 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nu ra Simón Pedro bʉya bi gʉx a rá juai mí hą nɛ bi 'yespa rán 'yɛizagu a rá 'yɛ̨hɛ ra dąmbäją, rá thuhu Malco a. ");
INSERT INTO otmNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pɛ nu'a ra Jesús bi 'yɛ̨mp'a ra Pedro: ―Fo'ts' ni juai a nin t'ojuai. Nuna ra mbohi xʉn zänga ma Ta ha hin ga sigä na, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","'Bex bi bɛnt'ʉ yʉ dofʉi nɛ'ʉ yʉ́ hmu nɛ yʉ policía bi mbɛn ma mijudíohe, nɛ bi du't'i. ");
INSERT INTO otmNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","M'bɛt'o bi zixpʉ 'bʉh ra Anás rá ndøhyą a ra Caifás, nɛ nu'a ra Caifás, ra dąmbäją a ra jɛya a. ");
INSERT INTO otmNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Guehna ra Caifás ngue xí xi ʉ yʉ́ mi ngʉrpihʉ, gue man'da xʉn ho 'bʉ n'datho da du, xinda gue'bʉ gätho ga juahmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nu ra Simón Pedro, nɛcä bʉya, dá tɛn'be ra Jesús. Nɛ madím pą'be a ra dąmbäją, janangue'a bi zä dá cʉt'ä bʉ bi mba ma cʉ't'i a ra Jesús bʉ mbo rá mbä't'i a rá ngu ra dąmbäją. ");
INSERT INTO otmNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pɛ nu ra Pedro mí 'bäpʉ thi bʉ ja ra goxthi. Pɛ dá pøngä bʉya gue dá äp ra mate a ra mbängoxthi, janangue'a bi zä bi yʉt'ambo ra Pedro bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nu'a ra mbängoxthi bʉya, gue n'da ra xisu, bi 'yɛ̨mp'a ra Pedro: ―Nu'i ha hinga gue'e rá xädi'i nʉ ran 'yohʉ, bi 'yɛ̨mbi. Nu ra Pedro bi dąt'a: ―Hin'na, hinga guecä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Madín tąspihʉ ʉ yʉ́ 'yɛ̨hɛ ra dąmbäją nɛ yʉ policía a ra Pedro, nubʉ ja ra sibi xí 'yudi, nguetho xʉn sɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nu ra dąmbäją bi 'yänna ra Jesús to'o gätho i tɛnni, nɛ bi 'yänni 'bɛ'a ním hma im ma 'bʉ in xänbate. ");
INSERT INTO otmNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nu ra Jesús bi dą'a: ―Nugä ząi dá mam bʉ ja ma nijąhʉ nɛpʉ ja ra dąniją, guepʉ ząi dim pɛti gätho ma mijudíohʉ. Njąm'bʉ dá mangä bʉ njongui 'bʉh yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nɛ ndetho guí ängui 'bɛ'a dá mam 'bʉ mán xänbate. Nde'bʉ gui 'yän'dʉ bi 'yøh mam hmangä. Nu'ʉ i pądi 'bɛ'a dá mangä ʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nɛ nu'a ra Jesús 'bʉ mí dąt'a ra dąmbäją, nɛ nu'a n'da ra ngʉrpa dofʉi bi mbɛmp'a rá hmi, bi 'yɛ̨mbi: ―Hanja ngubʉ gá xih ra dąmbäją, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nu ra Jesús bi 'yɛ̨mp'a: ―Nu'bʉ ja 'bɛ'a dá mangä gue hingui ho, dami ma. Pɛ nu'bʉ nte dá mangä, hanja gní pɛgbi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nu ra Anás bʉya bi mbɛnhna ra Jesús bʉ 'bʉh ra Caifás, rá mi dąmbäjąui. ");
INSERT INTO otmNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nɛ mí 'bäpʉ ra Simón Pedro madín tąspi a. Nɛ än'dʉ i 'bähmbʉ: ―Ha nɛ'e rá xädi'i nʉ. 'Bex bin cøni: ―Hinga guecä, ɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nu'a n'da rá 'yɛ̨hɛ ra dąmbäją bʉya, gue dim mɛniui a ra 'yɛ̨hɛ xí 'yespa rá zagu ra Pedro 'bʉ mí 'yɛ̨na da yąn'a rá Hmu, bi 'yɛ̨mbi: ―Ɛ̨na gue'e dá nu a bʉ ja ra nuąndät'o, bi t'ɛ̨mp'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nɛ bin cøm mahøn'a ra Pedro. 'Bex bi mbah ra tamfø. ");
INSERT INTO otmNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","T'ʉxuditho bá ts'i bʉ ja rá ngu ra Caifás a ra Jesús, nɛ bi ts'ix bʉ ja ra nguts'ʉt'abi. Pɛ nu ma ngʉrpihe dyʉ judíohe dyʉ israelhe, him bi yʉzɛhɛ bʉ mbo nguetho ɛ̨n yʉ́n t'ɛ̨di din ts'on yʉ́ ją'i 'bʉ da yʉrpʉ ja yʉ́ ngu ʉ hing yʉ judío, nɛ hin da zä da zi ran ts'ihmɛ nangue ran dąbaxjua 'bʉ xtán yʉrpʉ mbo. ");
INSERT INTO otmNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Janangue'a nu ra ts'ʉt'abi Pilato, bi mba bʉ thi gue da zo ʉ yʉ yąpate, nɛ bi 'yän'dʉ: ―'Bɛ'a gní yąfʉ a ran 'yohʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nɛ bi dą ʉ ma ngʉrpihe: ―Nu'bʉ hin gra ts'om'bäi, hin xcá dä ahʉ 'bʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nɛ nu ra Pilato bi 'yɛ̨mp'ʉ: ―Dami sixhʉ 'bʉ, nɛ gui juąnbahʉ nangue nin t'ɛ̨di zɛhɛhʉ, bi 'yɛ̨na. Nɛ nu ma ngʉrpihe bi dąt'a: ―Pɛ hin'yʉ man t'ɛ̨dizɛhɛhe gue'a ga hohe n'da, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nu'a bi man'ʉ bin thɛui a bi man a ra Jesús 'bʉ mí ma 'bɛ'a mán dąte dí du a, gue da mba ma cuati bʉ ja ra pont'i. ");
INSERT INTO otmNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nu ra Pilato bi mbeng mahøn'a bʉ ja ran ts'ɛmbate nɛ bi 'yänna ra Jesús: ―Nu'i ha gue'e grá hmuts'ʉt'abi yʉ judío, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nu ra Jesús bi dąt'a: ―Ha guím bɛ̨nsɛ 'bɛ'a guím ma, uague n'dan'yo bi xi i nanguecä, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nu ra Pilato bi 'yɛ̨m bʉya: ―Hin drá judíogä. 'Bɛ'a gá 'yøt'e thą, ngue bi dä'a ua ni mijudíohʉ nɛ ni dąmbäjąhʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nu ra Jesús bi dąt'a: ―Hin dám hmuts'ʉt'abigä ua ja ra ximhäi. Nu'bʉ xcám hmuts'ʉt'abigä ua, xtín tunhdʉ ʉ ma ją'igä ʉ bi bɛndgui 'bʉ, nɛ hin xtí dägä ua 'bʉ. Pɛ nu ma ts'ɛdigä him bi nɛqui ua ja ra ximhäi a, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nu ra Pilato bi 'yɛ̨mbi mahøn'a: ―Ha majuąni grá hmuts'ʉt'abi 'bʉ, bi 'yɛ̨mbi. Nu ra Jesús bi dąt'a: ―Majuąni guím ma gue drá hmuts'ʉt'abigä nɛ gue'a dám 'bʉcä ua ja ra ximhäi, nɛ gue'a ná ɛ̨cä ua gue ga u'a majuąni. Nu'ʉ to'o in nde da bą'a majuąni, da 'yømanho a dím mangä ʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nu ra Pilato i ɛ̨na: ―'Bɛ'a maha a majuąni, njon da zä da bądi nda'a a majuąni, bi 'yɛ̨mthoho. Nɛ nu'bʉ mí jua'a bi man ra Pilato, bi mba bʉ thi din yąhʉ ʉ yʉ́ yąpate mahøn'a, nɛ bi 'yɛ̨mp'ʉ: ―Nte mán ts'o dá tįnbi. ");
INSERT INTO otmNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pɛ nu'ahʉ ząi guí xijʉ ga thøc'ahʉ n'da ra ofädi 'bʉ bi dät' ra pa ran dąbaxjua. Ha guín ndehʉ ga thøc'ahʉ ni hmuts'ʉt'abihʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nɛ bi mbʉdi bi mbafi nts'ɛdi ʉ, bi 'yɛ̨n'ʉ: ―Hin'na, hinga gue'a, pɛ nu'a ra Barrabás, gue'a gui thøgahe a, bi 'yɛ̨n'ʉ ma ngʉrpihe. Nu ra Barrabás, n'da ra hyote a. ");
INSERT INTO otmNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nu ra Pilato bi manda dí fɛi a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nu yʉ dofʉi bʉya bi 'yørpa n'da ra corona gue yʉ 'yʉ'uįni, nɛ nts'ɛdi bi huspa rá yą ra Jesús. Nɛ bim pärba n'da ra 'bø't'e xʉn jʉpoi tengu dim pät' yʉ hmuts'ʉt'abi. ");
INSERT INTO otmNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nɛ bi den bʉya nɛ bi 'yɛnspa yʉ́ biba, bi 'yɛ̨mbi: ―Biba, grá hmuts'ʉt'abi yʉ judío, bi 'yɛ̨mbi. Nɛ bi mbɛ'mi bʉya ngue yʉ́ 'yɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bi mba bʉ thi mahøn'a a ra Pilato, bin yąhʉ ma ngʉrpihe: ―Nuya ga dä ahʉ na ran 'yohʉ, dami pąhmbʉ nte dá tįnba n'da ran ts'o gue xʉ 'yøt' na, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bi ts'ix bʉ thi ra Jesús bʉya, ya i hu'ts' ra corona ngue nt'øt'e yʉ 'yʉ'uįni, nɛ he ra 'bø't'e xʉn jʉpoi. ―I 'bäcua na ran 'yohʉ ya, bi 'yɛ̨n'a ra Pilato. ");
INSERT INTO otmNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nu'ʉ yʉ dąmbäją nɛ ma ngʉrpihe 'bʉ mín nu a ra Jesús, nts'ɛdi bi mbafi, nɛ xʉn ngu yʉ nidi bi 'yɛ̨na: ―Dá du, dá 'døm'pʉ ja ra pont'i. Nu ra Pilato bi 'yɛ̨mp'ʉ bʉya: ―Dami sizɛhɛhʉ 'bʉ guín nde gui cuathʉ bʉ ja ra pont'i, nguetho nugä hin te dá tįnbä n'da ran ts'o xʉ 'yøt' na, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nu'ʉ ma ngʉrpihe bi dąpʉya: ―Nugähe i jaje n'da man t'ɛ̨dihe gue da du n'da im ma tengu im ma na, nguetho bi mansɛ guesɛ rá Ts'ʉnt'ʉ Oją, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nu'bʉ mí 'yø a ra Pilato mí ɛ̨n'a ra Jesús gue rá Ts'ʉnt'ʉ Oją a, man'da bi zu a. ");
INSERT INTO otmNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nɛ bi zix pʉ mbo ja ran ts'ɛmbate mahøn'a a ra Jesús, bi 'yänni: ―Hapʉ ɛ majuąni guí nɛts'i. Pɛ nu ra Jesús him bi dąti. ");
INSERT INTO otmNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nu ra Pilato bi 'yɛ̨mp'a: ―Hanja hin gní thąrcagui. Ha hin guí pądi ja ma ts'ɛdi ga cuat'a bʉ ja ra pont'i, nɛ ja ma ts'ɛdi ga xoc'a bʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nu ra Jesús bi dądi: ―Hin xtín ja ni ts'ɛdi nɛ nte sä gui 'yørque 'bʉ hin xtán zän Oją 'bɛ'a gui 'yørque. Pɛ nu'ʉ bi dägä ua, man'da ja yʉ́ ts'oqui ʉ xinda gue'e, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nɛ nubʉya nu ra Pilato ɛ̨mmɛ bi hyoni 'bɛpʉ dí hyɛtho a ra Jesús. Pɛ nu ma ngʉrpihe nts'ɛdi bi mbafi, bi 'yɛ̨n'ʉ: ―Nu'bʉ gui hyɛt na, nin sʉiui a ma hmuts'ʉt'abihʉ ra César 'bʉ. Nguetho nu'bʉ 'bo'o da ma gue im hmuts'ʉt'abi zɛhɛ din sʉhmi a ra César 'bʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nu'bʉ mí 'yøhna ra Pilato, bá si bʉ thi mahøn'a a ra Jesús bʉ ja rá ngun'yu ran juąnbate magąts'i, dí ɛ̨mfe ma ndehe Gabata. Nɛ bi hyux ra Pilato bʉ ja rá mɛxa ran juąnbate. ");
INSERT INTO otmNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nu'a ra pa a, i pa ma hoqui yʉn ts'ihmɛ da ts'i 'bʉ bi hyats'i, nangue ran dąbaxjua. Nɛ di 'bɛh mits'ʉ da zøn i huxhyadi. Nɛ nu ra Pilato bi 'yɛ̨mp'ʉ ma ngʉrpihe: ―Nuya 'bäcua na ni hmuts'ʉt'abihʉ, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pɛ nts'ɛdi bi mba ʉ: ―Dá du, dá duhma, dá 'døm'pʉ ja ra pont'i, bi 'yɛ̨n'ʉ. Nɛ nu ra Pilato bi 'yɛ̨mp'ʉ: ―Hanja gní 'yɛ̨njʉ gam ma da 'døm'pʉ ja ra pont'i ni hmuts'ʉt'abihʉ, bi 'yɛ̨mbi. Pɛ nu yʉ dąmbäją bi dądi: ―Njongui 'bʉcua man'da ma hmuts'ʉt'abihe, hønt'a ma hmuts'ʉt'abihʉ bʉ Roma ngue ra César, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nu ra Pilato bʉya bi 'yøt'a bi nde yʉ mbäją, bi manda dí cuati bʉ ja ra pont'i ra Jesús. Nɛ bi ts'ix bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nɛ bi zix yʉ dofʉi a ra Jesús bʉya, nɛ i tuzɛhɛ rá pont'i bʉ ní mba, da zøm bʉ ja n'da ra nyuni t'ɛ̨mbi Gólgota, nde da ma ra Nyuni nyąxmu. ");
INSERT INTO otmNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nɛ nu'bʉ mí zøm bʉ, bi mba n'dø'mi ra Jesús bʉ ja ra pont'i. Bim 'bä inde rá pont'i, nɛ n'da an 'danguadi bim 'bä ʉ mi'da yʉ pont'i, bi guarpʉ ʉ mi yoho. ");
INSERT INTO otmNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nu ra Pilato, bi 'yo't'a n'da ram hma bi 'yɛ̨na: “Nuna ra Jesús ra mɛngu bʉ Nazaret, rá hmuts'ʉt'abi yʉ judío na,” bi 'yo't'i. Nɛ nu'a ra t'ohni bi mba n'dø'mi bʉ ja ra pont'i. ");
INSERT INTO otmNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Xʉn ngu ma mijudíohe dyʉ israelhe bi nu bʉya 'bɛ'a nt'o't'i bʉ, nguetho mbɛ ndehnini tho bʉ. Nɛ nt'o't'i nangue ma ndesɛhe ra hebreo, nɛ yʉ́ nde yʉ mɛngu bʉ Grecia gue ra griego, nɛ yʉ́ nde yʉ mɛngu bʉ Roma gue ra latín. ");
INSERT INTO otmNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nu'ʉ yʉ dąmbäją bʉya bi 'yɛ̨mp'a ra Pilato: ―Hanja gá 'yo't'i gue ma hmuts'ʉt'abihe. Pɛ dami hoqui da ma: “Bi mansɛ: Nugä drá hmuts'ʉt'abi yʉ judío,” da 'yɛ̨na, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pɛ nu ra Pilato bi dąt'ʉ: ―Ya nt'o't'i 'bɛ'a dá o't'ä, dá guet'a, bi 'yɛ̨mthoho. ");
INSERT INTO otmNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nu'bʉ mí cuar bʉ ja ra pont'i ra Jesús, nu yʉ dofʉi bʉya bi gąspa yʉ́ he, goho munts'i bin ja yʉ́ he, n'da ngu n'da yʉ dofʉi n'da n'da munts'i bi gąx'ʉ. Pɛ nu rá pahni rám 'bɛxøts'e hin hapʉ ma zøte a. ");
INSERT INTO otmNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Janangue'a bin 'yɛ̨mzɛhɛ ʉ: ―Nde'bʉ ga øthʉ n'da ran tąha to'o da bøni din thɛui rá pahni na. Nɛ nu'a bi man'ʉ bin thɛui a mán t'o't'i bʉ ja rá t'ohni Oją gue njabʉ da 'yøt'ʉ, mi ɛ̨na: “Bi mba ma darqui ma he, n'da a n'da munts'i bi gąx'ʉ 'da. Pɛ nu'a mam 'bɛxøts'e bi t'øt'a n'da ran tąha to'o da gąts'i,” mí ɛ̨n rá t'ohni. Gue'a bi 'yøt' yʉ dofʉi a. ");
INSERT INTO otmNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nuya mí 'bäpʉ ja ra pont'i rá mbe ra Jesús nɛ a rá juhuɛ, nɛ'a ra María rá bømbe a ra Cleofas, nɛ'a ra María ra mɛngu bʉ Magdala a. ");
INSERT INTO otmNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nɛ nu'a ra Jesús 'bʉ mín nu a rá mbe, nɛcä gue madí huɛ̨gä, bi xi a rá mbe bʉya: ―Ma mbe i, dami 'yɛ̨mbi ni ts'ʉnt'ʉ nʉ ma xädi guí 'bähmi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nɛ bi 'yɛ̨ngä ra Jesús bʉya: ―Dami bɛ̨ni tengu'bʉ ni mbe nʉ ma mbegä, bi 'yɛ̨ngui. Nɛ 'bex dá sixä bʉ ja ma ngu bʉya, nɛ dá jamansu a. ");
INSERT INTO otmNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nɛ nu'bʉ mí man a ra Jesús bi bąh pʉya gue bi juah rá 'bɛfi mí mam bʉ ja rá T'ohni Oją gue din ja. Nɛ bi 'yɛ̨m bʉya: ―Dí tuthe, bi 'yɛ̨na. Nɛ'a bin thɛui a mán t'o't'i a bi ma. ");
INSERT INTO otmNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nɛ mí høpʉ n'da ra t'ʉxaro i po ra guindät'o xʉn ju. Nu'ʉ mí 'bäpʉ bʉya bi gärpʉ ja ra guindät'o a n'da ɛ̨na ra fʉnjo gue bi zinni, bi fospa rá yą ra xithi bʉya nɛ bi hyurpa rá nde ra Jesús da zʉ'ts'i. ");
INSERT INTO otmNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nu'bʉ mí zʉ'ts'a ra Jesús: ―Ya bi guah ma 'bɛfi, bi 'yɛ̨na. 'Bex bin ye'mahäi rá yą, nɛ bi unsɛ rá te bi du bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nu ma ngʉrpihe hingui ndepe da guathoho bʉ ja yʉ pont'i ʉ yʉ ją'i 'bʉ ya xʉ hyats'i, nguetho gue'a ra pa a ya man'da tąte nangue ra dąmpɛti. Janangue'a bi t'äp ra mate ra Pilato da mba n'uacpi yʉ́ juąngua gue da du n'dihi ʉ, nɛ da mba ma tongui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Bex bi mba ʉ yʉ dofʉi, nɛ bi 'uacpa yʉ́ juąngua ʉ yoho mí cuarpʉ ja yʉ́ pont'i guepʉ mí 'bäh rá pont'i ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pɛ nu'bʉ mi zøm bʉ cuat'a ra Jesús, bi nu gue ya xí du, janangue'a him bi 'uacpa yʉ́ juąngua a. ");
INSERT INTO otmNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pɛ nu'a n'da ra dofʉi bi sʉnba rá 'bi'bøts'e ra Jesús a ra ts'ąt'ɛgui. 'Bex bi bøn ra ji nɛ ra dehe. ");
INSERT INTO otmNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nɛ nugä gätho dá nusɛ 'bɛ'a bi t'ørpa ra Jesús. Janangue'a majuąni na dí o't'ä ya. Nɛ guehna dí o't'ä na n'dahma da zä gui 'yɛ̨c'yɛihʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nɛ nu 'bɛ'a gätho bin ja, bin thɛui a mán t'o't'i bʉ ja rá søcuą Oją gue din ja. Nɛ man t'o't'i: “Xínga n'da rá do'yo da mba n'uacpi,” mi ɛ̨n ra t'ohni. ");
INSERT INTO otmNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nɛ man'da bi hmam bʉ ja rá T'ohni Oją, bi 'yɛ̨na: “Nu'ʉ di ʉcpi da nu gue gue'a bi mba ma sʉnbi ra ts'ąt'ɛgui rá 'bøts'e,” mí man'a ra T'ohni. ");
INSERT INTO otmNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nɛ nubʉya nu ra José ra mɛngu bʉ Arimatea, nu'a n'da rá 'yɛ̨c'yɛi ra Jesús, pɛ him mi ma gue mí ɛ̨c'yɛi nguetho mí su ma ngʉrpihe, pɛ nuya bi 'yäp ran t'ɛ̨di ra Pilato di tongba rá ngøc'yɛ̨i ra Jesús bʉ ja ra pont'i da 'yägui. Nɛ nu'bʉ min t'un ran t'ɛ̨di ra José, bi mba bʉya nɛ bi tongba rá ngøc'yɛi ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nɛ bá ɛ̨h ra Nicodemo bʉya, gue gue'a xí zøm bʉ mí 'bʉh ra Jesús n'da ra xui. Nɛ i tu ra 'yɛ̨thi ɛ̨mmɛ i yʉman'u, mbɛ 'däte ma 'dɛt'a kilo nan hyʉ, ma thąspi ra mirra a ra áloes. ");
INSERT INTO otmNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nu'bʉ mi mbantpa rá ngøc'yɛi ra Jesús ra hoc'bø't'e xʉn ho, nɛ bi 'yʉrpa ra 'yɛ̨thi guepʉ ním fįx ra 'bø't'e, tengu ząi dí øthe dyʉ judíohe 'bʉ dí ähmbe n'da ra du. ");
INSERT INTO otmNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nɛ i ja bʉ n'da ra mba'ye jombʉ ja ra pont'i xí 'døm'ma ra Jesús, nɛ nubʉ häi oqui bʉ n'da ra hyądo ngue ran 'yägui, mahoqui pɛ njon ní 'yo bʉ n'da ra du. Nɛ jabʉ n'da ra nuąndät'o bʉ rá goxthi a ra hyądo gue ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nɛ nu'a ra pa man'da tąte thoho nangue ran dąbaxjua ɛ ma guepʉ da mbʉdi. Janangue'a bi cʉ't'a n'dihi bʉ ja ra hyądo a rá ngøc'yɛi ra Jesús, nguetho hinga yatho bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","T'ʉxuditho domingo hin ní nɛc ra häi nu ra María ra mɛngu bʉ Magdala bi zøm bʉ ja ran 'yägui. Bi nu gue xí mba njʉnni a ra xįndo mi juax bʉ ja rá goxthi ran 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bá pengui nɛ bán tihi, bi zøm bʉ mí 'bʉ'be ra Simón Pedro nɛ bi 'yɛ̨nc'be: ―Bin jʉc ma Hmuhʉ. Nɛ hin dí pądi hapʉ bi thux ya, bi 'yɛ̨nc'be. ");
INSERT INTO otmNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dá mbɛ'be bʉ ja ran 'yägui bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɛ̨mmɛ dán ti'be, bin ts'ogui ts'ʉ ra Pedro, nɛ m'bɛt'o go dá søngä bʉ ja ra hyądo. ");
INSERT INTO otmNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dá c'ą't'ä bʉ mbo dá nu hønt'ʉ yʉ 'bø't'e cąx bʉ ngue xí 'bant'i. Pɛ him 'bex dá cʉt'ä mbo. ");
INSERT INTO otmNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nɛ nu'bʉ mí zøm bʉ ra Simón Pedro, 'bex bi uɛ̨ntho bʉ mbo, nɛ'a bi nu cąx bʉ yʉ 'bø't'e. ");
INSERT INTO otmNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nɛ nu'a n'da ra 'bø't'e xí 'banba rá yą ra Jesús n'danni mí cąts'i, ma do'mi a. ");
INSERT INTO otmNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nɛcä dá cʉt'ä mbo bʉya, madague'bʉ m'bɛt'o dá søngä bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nɛ nu'bʉ má nu 'bɛ'a di ja bʉ, dá ɛ̨c'yɛigä gue majuąni bi dąmbɛ̨ni a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dá peng'be bʉ ma ngu'be bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pɛ nu'a ra María bi gotho bʉ ja rá goxthi ra hyądo nɛ i zoni nɛ di c'ąrpʉ mbo. ");
INSERT INTO otmNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nɛ bi nu yoho yʉ́m 'bɛhni Oją mahɛ̨ts'i i he yʉ t'axcahe. I hupʉ n'da bʉ mí ja rá yą ra Jesús nɛ hupʉ man'da bʉ mí ja yʉ́ gua. ");
INSERT INTO otmNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nɛ bi xi a ra María: ―Grá xisu, hanja gná zoni, bi 'yɛ̨mp'a. Nɛ nu ra María bi dąt'ʉ: ―Nguetho bin jʉc'a ma Hmu nɛ hin dí pądi hapʉ bi thuts'i, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nɛ nu'bʉ mín hanni ra María, bi nu ra Jesús i 'bäpʉ. Pɛ him mi pądi gue gue'a. ");
INSERT INTO otmNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nu'a ra Jesús bi 'yɛ̨mp'a: ―Grá xisu, hanja gná zoni, to'o guí honi, bi 'yɛ̨mbi. Pɛ nu ra María mím bɛ̨ni gue gue'a ran 'yohʉ di jamansu ra nuąndät'o. Janangue'a bi 'yɛ̨mbi: ―Nu'bʉ gue'e gá jʉga ma Hmu, dami 'yurqui ts'ʉ hapʉ gá pɛgui nɛ ga tuxä, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nɛ nu ra Jesús bi ndønba rá thuhu: ―María, bi 'yɛ̨mbi. Nu ra María 'bex bi 'bä't'i xʉn ho bʉya, bi nu nɛ bi 'yɛ̨na: ―Raboni, nde da ma, “Xänbate i,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nɛ nu ra Jesús bi 'yɛ̨mbi: ―Pɛ hingui sä 'bexque gui thäcä ya nguetho di 'bɛh mi ts'ʉ ga mba bʉ bí 'bʉh ma Ta. Janangue'a 'bɛ ní mbahma bá xi ʉ ma cuui ga pengbʉ bí 'bʉh ma Tagä, nɛ ahʉ ni Tahʉ a, nu'a ma Ojągä a, nɛ ahʉ ni Ojąhʉ a, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nu'a ra María ra mɛngu bʉ Magdala bi mba bʉya, nɛ bi xije dyʉ xädihe gue bi nu ra Hmu nɛ bi xije 'bɛ'a bi man'a. ");
INSERT INTO otmNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nɛ nu'bʉ mín de guet'a ra pa domingo, nthʉ't'i yʉ́ jut'i ra ngu bʉ dám 'bʉhmbe nguetho dá su ma ngʉrpihe, nɛ nu'bʉ má nuhe, 'bä inde bʉ dí 'bʉhmbe ra Jesús. Nɛ bi 'yɛ̨na: ―Daman johyahʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nɛ nubʉya bi 'yurcahe yʉ́ 'yɛ guepʉ xí 'dømbi, nɛ rán zʉ'bøts'e guepʉ xín sʉnba ra ts'ąt'ɛgui. Nɛ nu'bʉ má nuhe, dá pąhmbe majuąni ma Hmuhe a, nɛ ɛ̨mmɛ dán johyahe bʉya. ");
INSERT INTO otmNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nɛ bi ma mahøn'a ra Jesús: ―Daman johyahʉ. Nɛ tengu tho bʉ í 'dac ra 'bɛfi ma Ta dá jap yʉ ją'i ua ja ra ximhäi da bądi, nguthogä dí 'da ahʉ ra 'bɛfi gui jafʉ yʉ ją'i ua ja ra ximhäi da bądi, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nɛ nu'bʉ mí jua a bi man na, bi huigähe ran dąhi n'da ngu n'dagähe bʉya. ―Dami hyąmhbʉ rá Hogandąhi Oją, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nu'a to'o di päh yʉ́ mbʉi nangue yʉ́ ts'oqui, i ja nin t'ɛ̨dihʉ gui xihmbʉ ma punbi a. Pɛ nu'a hin di päh yʉ́ mbʉi nangue yʉ́ ts'oqui, i ja nin t'ɛ̨dihʉ gui xihmbʉ him ma punbi a, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pɛ nu ra Tomás gue'a i t'ɛ̨mbi ra Go a, n'da ma mixädihe, njo'o bʉ 'bʉ mí nɛqui ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","M'bɛjua bʉya dá xihmbe ra Tomás: ―Nugähe dá nuhe ra Hmu. Pɛ nu ra Tomás bi 'yɛ̨na: ―Pɛ nugä dí ɛ̨na him majuąni a guí xijʉ hinda hønt'bʉ gan nusɛ hapʉ bim fospa yʉ clavo yʉ́ 'yɛ, nɛ ga fospa ma saha hapʉ bim fox yʉ clavo nɛ ga fot ma 'yɛ bʉ ja rá 'bi'bøts'e, sä ga ɛ̨c'yɛi 'bʉ, bi 'yɛ̨nje. ");
INSERT INTO otmNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nu'bʉ mí dät'an hyąto pa bʉya dám pɛtihe mahøn'a. Nɛ'a ra Tomás. Nɛ nthʉ't'i yʉ jut'i tengu mam'bɛt'o, pɛ xø bi nɛqui bʉ ra Jesús mahøn'a, bim 'bä inde bʉ dí 'bʉhmbe. ―Daman johyahʉ, bi 'yɛ̨nje mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nu'a ra Jesús bʉya bi xi a ra Tomás: ―Dami fos' ni saha ua bim foscä yʉ clavo nɛ guin nu ma 'yɛ, nɛ bá 'uąt ni 'yɛ gui fo'ts'ua ja ma 'bøts'e. O guí ɛ̨na him majuąni pɛ dami 'yɛ̨c'yɛi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nu ra Tomás bi 'yɛ̨mp'a: ―Ma Hmu i, ma Oją i, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nu'a ra Jesús bi 'yɛ̨mp'a: ―Tomás, guí ɛ̨c'yɛi ya nguetho ya gá nugui. Pɛ nu'ʉ to da 'yɛ̨c'yɛigui 'bʉ nte ní nu, man'da di jąp Oją ʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pɛ nu'ʉ yʉ hyonya nt'øt'e dá nuhe bi 'yøt' ra Jesús, hinga gätho dá o't'ä ua ja ra søcuą. ");
INSERT INTO otmNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pɛ hønt'ʉ 'da dá o't'ä dí ja ahʉ gui 'yɛ̨c'yɛihʉ gue majuąni ra Cristo a ra Jesús rá Ts'ʉnt'ʉ Oją a. Nɛ nu'bʉ gue'a gui 'yɛ̨c'yɛihʉ din 'da ahʉ ra 'da'yote maząi. ");
INSERT INTO otmNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","M'bɛjua bʉya dá nuhe ra Jesús mahøn'a, bi jaje dá pąhmbe man'da xʉn ho bʉ ja ra dądehe Tiberias, n'dat'a ra dądehe Galilea. Nɛ ga xi ahʉ gätho bin ja. ");
INSERT INTO otmNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Mín 'yohe ra Simón Pedro nɛ ra Tomás i t'ɛ̨mbi ra Go, nɛ ra Natanael ra mɛngu bʉ Caná ra xɛqui Galilea, nɛ man 'yohʉgä yʉ́ ts'ʉnt'ʉ gä'be ra Zebedeo, nɛ mí yoho ma mixädihe. ");
INSERT INTO otmNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nɛ nubʉya bi 'yɛ̨nje ra Simón Pedro: ―Nugä ga mba na 'bahuą, bi 'yɛ̨nje. ―Ga mbähä 'bʉ, dá ɛ̨mfe. Dá mbähmbe bʉya 'bex dá huhe n'da ma mbosahe. Pɛ gätho ra xui nte dá thɛhe yʉ huą. ");
INSERT INTO otmNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nɛ nu'bʉ mí hyax bʉya mí 'bäpʉ ndenthe a ra Jesús. Pɛ nugähe him 'bexque dá pąhmbe gue gue'a. ");
INSERT INTO otmNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Bi 'yɛ̨nje ra Jesús: ―Gyʉ ts'ʉnt'ʉhʉ, ha nte gá thɛhʉ yʉ huą. ―Hin'na, dá ɛ̨mfe. ");
INSERT INTO otmNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nu ra Jesús bi 'yɛ̨nje bʉya: ―Pɛ dami 'yɛnt ni xit'ąhʉ bʉ ja rán 'yɛi ra mbosa, nɛ 'bex gui thɛhʉ bʉya. Dá øthe a bi xije ra Jesús, nɛ ɛ̨mmɛ xʉn ngu dá thɛhe yʉ huą, him mí sä ga jʉxhe ra xit'ą. ");
INSERT INTO otmNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nɛ nugä gue madi huɛ̨gä ra Jesús, dá ɛ̨mp'a ra Pedro: ―Guehnʉ ma Hmuhʉ nʉ. Nu'bʉ mí 'yøh ra Simón Pedro gue gue'a ra Hmu a, 'bex bi hye rá he nguetho xí mbøgue. Nɛ bin säcpʉ ja ra mbosa gue bi zøn'a n'dihi bʉ i 'bäh ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pɛ nuje dá cohmbe bʉ ja ra mbosa, zʉn jante dá sømhbe bʉ ndenthe nguetho dí jʉt'ähe ra xit'ą nɛ yupʉ yʉ huą. Nɛ hinga yatho ndenthe, mbɛ n'da ciɛnto metro. ");
INSERT INTO otmNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nɛ nu'bʉ mí zøm bʉ ndenthe ra mbosa mí huhe, dá nuhe n'da ra sibi i zø bʉ, nɛ n'da ra huą i oxpʉ ja yʉ dɛspi, nɛ mí oxpʉ ra hmɛ. ");
INSERT INTO otmNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nɛ nu ra Jesús bi 'yɛ̨nje: ―Bá cʉ 'da ni huąhʉ xcá thɛhʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nu ra Simón Pedro bʉya, bi mba bá jʉt'a ra xit'ą bʉ ja ra häi i yuh yʉ huą, n'da ciɛnto nɛ yote ma 'dɛ'ma hyu yʉ huą xʉn ndoho. Pɛ hin hapʉ bi xɛt'a ra xit'ą. ");
INSERT INTO otmNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nu ra Jesús bi xije: ―Ba ɛ̨hmbʉ dan sihmɛhʉ, bi 'yɛ̨nje. Pɛ xínga n'daje xcá änhde to'o a, nguetho dá pąhmbe gue gue'a ma Hmuhe. ");
INSERT INTO otmNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nɛ bi mba bʉ zø ra sibi a ra Jesús bi hyąc ra hmɛ, nɛ bi 'daje, nɛ ra huą. ");
INSERT INTO otmNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nɛ ná hyundį dá nuhe ra Jesús bʉya gue bin 'yusɛ, gue'bʉ go mí dąmbɛ̨ni bʉ ja rán 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nu'bʉ mán niyąhe, nu ra Jesús bi 'yɛ̨mp'a ra Simón Pedro: ―Simón rá ts'ʉnt'ʉ i ra Jonás, ha man'da guí numanhogui xinda guehya 'da. Nu ra Pedro bi 'yɛ̨mp'a: ―Hąha ma Hmu i, guí pądi gue dí numanho i. Nu ra Jesús bi 'yɛ̨mb bʉya: ―Dami 'uįn ʉ ma t'ʉdɛ'yo, nangue mam hmangä gui xänba yʉ ją'i i ɛ̨c'yɛigui. ");
INSERT INTO otmNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ná yondį xø bi 'yɛ̨mp'a: ―Simón rá ts'ʉnt'ʉ i ra Jonás, ha majuąni guí numanhogui. ―Hąha ma Hmu i, guí pądi gue dí numanho i, bi 'yɛ̨mbi. Nɛ nu ra Jesús bi 'yɛ̨mp'a: ―Dami fäh ma dɛ'yo 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nɛ ná hyundį bʉya bi 'yɛ̨mbi: ―Simón rá ts'ʉnt'ʉ i ra Jonás, ha guí numanhogui, bi 'yɛ̨mbi. Nɛ bi du rá mbʉi ra Pedro, nguetho ya ná hyundį bi 'yän 'bʉ i numanho. Nɛ bi dąti: ―Ma Hmu i, gätho guí pądi, guí pądi dí numanho i. Nɛ nu ra Jesús bi 'yɛ̨mbi mahøn'a: ―Dami 'uįn'ʉ ma zʉ dɛ'yo dadí huɛ̨cä. ");
INSERT INTO otmNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nu'bʉ gmín ts'ʉnt'ʉ ząi gán 'yosɛ hønbʉ go hapʉ guín nde gui mba, nɛ guí tuzɛhɛ rá ngʉt'i ni foho. Pɛ nu'bʉ gán dąc'yɛi gui įng ni 'yɛ nɛ n'dan'yo da tut'i i, nɛ da zix'i i hapʉ hin guín nde gui mba, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Guehna bi man ra Jesús, gue da bąh ra Pedro 'bɛ'a nín dąte da nu a, nɛ gue'a dí 'yudi xʉn hotho Oją a. Nɛ nu ra Jesús bi 'yɛ̨mp'a ra Pedro mahøn'a: ―Dami tɛngui gui thoc'a ma 'bɛfigä, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nɛ nu'bʉ mí dʉ'mi bi dɛn bʉya bi nyɛ̨gui, bi nugä gue nɛqui dí tɛt'i, guecä madí huɛ̨gä ra Jesús, ngue 'darpʉ xtá hu'be bʉ ja ra mɛxa 'bʉ mán sihmɛhe gue'bʉ má änni to'o di dä a. ");
INSERT INTO otmNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nɛ nu'a ra Pedro 'bʉ mín nugui dí tɛt'i, bi 'yän'na ra Jesús: ―Ma Hmu i, 'bɛ'a nín dąte xin da nu na ra Xuua, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nu ra Jesús bi dąti: ―Nu'bʉ ma pähä di 'bʉtho ua gue'bʉ go dá søcä mahøn'a, hin ni 'bɛfi gui 'yängui. Pɛ nu'a ni 'bɛfi gui tɛngui gui thoc'a ma 'bɛfi, bi t'ɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pɛ janangue'a mi mansɛ yʉ 'yɛ̨c'yɛi gue njąm'bʉ ga tugä. Pɛ hinga ngubʉ bi man ra Jesús, pɛ bi 'yɛ̨na: “Nu'bʉ ma pähä di 'bʉtho ua gue'bʉ go dá søcä mahøn'a, hin ni 'bɛfi gui 'yängui,” xí 'yɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Guecä rá xädigä gue bi man ra Jesús, nɛ guecä xin dí o't' na ra søcuą 'bɛ'a dá nu gue majuąni bin ja. Nɛ dí pąhmbe majuąni na dí o't'ä ya. ");
INSERT INTO otmNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nɛ xʉn ngu mi'da yʉn t'øt'e bi 'yøt'a ra Jesús. Pɛ nu'bʉ gätho xcá o't'ä, hinga xøt'a gätho xtín ja ua ja ra ximhäi 'bʉ. Nɛ hønt'a dí xi ahʉ ya.");
INSERT INTO otmNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nu'i Teófilo, rá mbʉdi ra søcuą dá o't'a'i mám'bɛt'o, dá xi'i gätho bi 'yøt' ra Jesús nu'bʉ mi dʉmp' rá 'bɛfi. Nɛ dá xi'a'i gätho ngue bi ma 'bʉ mín xänbate. ");
INSERT INTO otmNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nɛ dá xi'a'i gätho bi 'yøt'a ra Jesús asta gue'bʉ mi mba mahɛ̨ts'i. Nɛ nu'bʉ mi 'bʉcua ja ra häi, nu rá Hogandąhi Oją bi xih ra Jesús 'bɛ'a da xih yʉ́ 'bäihʉ gue da 'yøt'e. Nu'ʉ yʉ́ 'bäihʉ, gue'ʉ yʉn 'yohʉ bi huanh ra Jesús ngue man yʉ́ xädi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nu ra Jesús bi nu ran ʉnbi nɛ bi du. Nɛ gätho nyote pa 'bʉ mí ndants'i mahøn'a, bin 'yusɛ bʉ 'bʉh yʉ́ 'bäihʉ, ja'bʉ bi hnu, ja'bʉ hin'na. Nɛ bi 'yuti xʉn ngu yʉn t'øt'e guepʉ bi nde da fądi gue i 'bʉi. Nɛ bi xi'ʉ nangue rá 'bɛfi i øt' Oją ua ja ra ximhäi, nɛ 'bɛpʉ dí manda Oją ʉ gätho dim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nu'bʉ mím 'bʉhmbʉ yʉ́ 'bäihʉ mahøn'a a ra Jesús, nɛ bin sihmɛhʉ, bi xi'ʉ da dømp'ʉ Jerusalén 'bɛ'a bi ma majuąni rá Ta gue ba ɛ̨hɛ. Nɛ ɛ̨n'a ra Jesús: ―Ya xcá 'yøhmbʉ dá mangä mam'bɛt'o ngue ba pɛnh Oją rá Hogandąhi. ");
INSERT INTO otmNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nu'a ra Xuua bi 'yøt'ahʉ ran xixyą nangue ra dehe thoho, pɛ mi ts'ʉtho ya ga 'da ahʉ rá Hogandąhi Oją, bi 'yɛ̨n'a ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nu'bʉ mim pɛti ʉ, bi 'yänni: ―Ma Hmu ahe, hague guehya yʉ pa jabʉya gui 'yøt'e din ja ma ts'ɛdi zɛhɛhʉ mahøn'a, dyʉ israelhʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Bi dą'a ra Jesús: ―Hingui sä gui pąhmbʉ nda'a ní pa xʉn zän ma Tahʉ da 'yøt'a 'bɛ'a gätho da 'yøzɛhɛ. Hin ni 'bɛfihʉ gui pąhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pɛ nu'bʉ bá ɛ̨h rá Hogandąhi Oją, nɛ gam 'bʉhmbʉ, din ja ni ts'ɛdihʉ. Nɛ nu'bʉ bin ja, gui xihmbʉ yʉ ją'i ua ra dąhnini Jerusalén nanguecä, nɛ gätho ua ra häi Judea, nɛpʉ ra häi Samaria, nɛ gätho na ngʉni ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nu'bʉ mi gua'a man ra Jesús bi mba mahɛ̨ts'i. Nu yʉ́ 'bäihʉ bi nu nu'bʉ mi ndex mahɛ̨ts'i. Nɛ n'da ra güi bi go'mi nɛ him bi nu yʉ́ 'bäihʉ mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nɛ mi 'bäpʉ, mi ndø'ts' mahɛ̨ts'i, 'bex mi 'bähmbʉ yoho yʉ́m 'bɛhni Oją mahɛ̨ts'i, i he yʉ t'axca pahni. ");
INSERT INTO otmNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nɛ bi 'yɛ̨mbi: ―Nu'ahʉ gyʉ mɛnguhʉ Galilea, hanja gní 'bähmbʉ ua ya nɛ gni ndøs'hʉ mahɛ̨ts'i. Nu ra Jesús bi ndex ua guí 'bähmbʉ, nɛ tengutho bʉ á ndets'e, ngutho 'bʉ bá cąh mahøn'a, nɛ guet'a ra Jesús a. ");
INSERT INTO otmNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nu yʉ́ 'bäihʉ ra Jesús bi nɛxpʉ ja ra nyuni Olivos bʉya, bi mba bʉ ra hnini Jerusalén, nɛ hinga yatho, ndehnini. ");
INSERT INTO otmNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nɛ nu'bʉ mi yʉrpʉ ja ra hnini bi ndexpʉ n'da ra cuarto magąts'i guepʉ i 'bʉ'ʉ. Gue'ʉ i 'bʉpʉ ʉ, ra Pedro, nɛ ra Xuua, nɛ ra Jacobo, nɛ ra Andrés, nɛ ra Felipe, nɛ ra Tomás, nɛ ra Bartolomé, nɛ ra Mateo, nɛ ra Jacobo rá ts'ʉnt'ʉ ra Alfeo, nɛ ra Simón gue t'ɛ̨mbi ra Zelote, nɛ ra Judas rán 'yohʉ ra Jacobo. ");
INSERT INTO otmNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gätho ya 'darpʉ bim pɛti nɛ ząi min yąhʉ Oją. Nɛ bi zøpʉ 'da yʉ xisu nɛ ra María rá mbe ra Jesús, nɛ'ʉ yʉ́n 'yohʉ ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","'Darpʉ madím pɛti ʉ n'da ciɛnto nɛ 'däte nją'i. Nɛ nu'ʉ yʉ pa'ʉ bi ndants'a ra Pedro nɛ bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Ma cu ahʉ nangue ra Cristo, nu rá Hogandąhi Oją maya'bʉ bi jap'a ra David da 'yo't' ra søcuą, nɛ bi ma 'bɛ'a da 'yøt' ra Judas, nguetho mí pą Oją 'bɛ'a da 'yøt'a. Gue'a ra Judas ngue bi dä'a ra Jesús nu'bʉ mi fɛnt'i. Nɛ gue'a bin ja nguetho gätho 'bɛ'a mán t'o't'i bʉ rám hman Oją din ja. ");
INSERT INTO otmNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","'Dat'a ra 'bɛfi dá øthe ra Judas nguetho ra Jesús bi huahn'na ra Judas tengu bʉ á huancähe. ");
INSERT INTO otmNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nɛ bi thän'a n'da ra häi nangue'a í mbä'a ra Jesús. Nu'bʉ mi zohäi ra Judas, bi nyepʉ häi, nɛ bi føh rá foho, nɛ bi bøni gätho yʉ́ xɛ̨fo. ");
INSERT INTO otmNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Gätho yʉ ją'i mi 'bʉpʉ Jerusalén bi 'yøde 'bɛ'a bin ja. Jananjabʉ bi mba ma huti ra häi ngue yʉ́ nde'ʉ, Acéldama, gue nde da ma bim fäm bʉ ra ji. ");
INSERT INTO otmNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nguetho nt'o't'i bʉ ja rá søcuą ra Salmos: Din häitho ra häi nɛ njon dim 'bʉpʉ, nɛ nt'o't'i ngue n'dan'yo da hyąn rá 'bɛfi mi ja xtá 'yøt'a. ");
INSERT INTO otmNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Janangue'a jatho ga huahndʉ a dam pɛhmbe. Jatho ga huahndʉ n'da rám poniui ra Judas, gue'a n'da madí hyʉnje gätho yʉ pa mí 'bʉhmbe ra Hmu, ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nɛ ga huahndʉ n'da bi nu 'bʉ mi xixyąba ra Jesús a ra Xuua, nɛ madí hyʉnje gätho yʉ pa dám 'bʉhmbe ra Jesús, gue'bʉ go mí mba mahɛ̨ts'i, bi nu, nguetho n'dat'a ga mamhbe ngue bi ndants' mahøn'a ra Jesús 'bʉ mi du, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nɛ nubʉya bi ndønba yʉ́ thuhu to'o da thahni, gue yoho yʉn 'yohʉ bi hndøni. Nu'a n'da ra José Barsabás nɛ í Justo, nɛ nu'a man'da ra Matías. ");
INSERT INTO otmNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nɛ nu'ʉ yʉ ją'i bin yąhʉ ra Hmu bʉya, nɛ bi 'yɛ̨na: ―Ma Hmu ahe, guí pąrpa yʉ́ mbʉi gätho, dami 'yurcahe ya yoho nda'a xcá huahni. ");
INSERT INTO otmNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nu'a ga comhbe ra 'bɛfi ngue ma 'bäigähe ra Jesucristo, ngue'a xtá 'yøt'a ra Judas. Nguetho xí 'uepʉ ja rá 'bɛfi nangue rá ts'oqui, bi mba da nu'a rán säui da nu, bi 'yɛ̨m 'bʉ min yąhʉ Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nu yʉ 'yɛ̨c'yɛi bʉya bi 'yøt'e tengu'bʉ n'da ran tąha, ngue nde da bą'ʉ nda'a bi nde Oją. Bi bøni gue gue'a ra Matías. Nɛ nu yʉ 'yɛ̨c'yɛi bʉya bi huanh ra Matías, nɛ bi gomhbʉ yʉ́ 'bɛfi ʉ 'dɛ'ma'da yʉ́ 'bäihʉ ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pɛ guexta'a di thoqui dim pɛti gätho yʉ 'yɛ̨c'yɛi, din ja'a mí tø'mi, gue bá pɛnh Oją a rá Hogandąhi, nɛ bin thɛui n'da ra dąmpɛti mí sänba Oją ʉ yʉ israel, t'ɛ̨mbi Pentecostés. ");
INSERT INTO otmNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","'Dahmantho bi zøpʉ di hį, tengu'bʉ n'da ra ndønthį gue bí 'yɛ̨h mahɛ̨ts'i a. Nɛ nu'a ní hį bʉ, bi yus'pʉ ja ra ngu guepʉ mi hu'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bi nɛqui tengu yʉ t'ʉsibi nɛ 'da'i ts'ʉ bi zox yʉ́ yą yʉ ją'i n'da ngu n'da ʉ mi 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ngue n'da ngu n'da mi 'bʉpʉ, gätho bin t'un rá Hogandąhi Oją, nɛ bi hąt ra ts'ɛdi xʉn ho ʉ. Nɛ bi mbʉdi 'dahma 'dan'yo bʉ án yą'ʉ n'da ngu n'da'ʉ nangue rá ts'ɛdi rá Hogandąhi Oją in 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nɛ nu'ʉ yʉ pa'ʉ bi zøm bʉ Jerusalén ʉ yʉ judío, da 'yøt'a ra dąmpɛti mí xi Oją maya'bʉ, ngue bá nɛxpʉ gätho yʉ häi ua ja ra ximhäi. ");
INSERT INTO otmNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nɛ nu'bʉ mi 'yø'a di hį ʉ yʉ ją'i, bim pɛti bʉ, nɛ n'da ngu n'da ʉ bi zo'ʉ yʉ 'yɛ̨c'yɛi nangue yʉ́ ndesɛ, nɛ him bi zä bi bɛ̨ni ha bin ja. ");
INSERT INTO otmNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nɛ bi hyonya thoho nɛ him bi bądi 'bɛ'a nam bøni, nɛ bin 'yɛ̨mb zɛhɛ ʉ: ―Hague án zä bin ja bʉ, bin 'yɛmp'ʉ. Ha hinga gue'ʉ yʉ mɛngu bʉ Galilea gätho i yą ua ya. ");
INSERT INTO otmNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hanja sä i sijʉ ma ndesɛhʉ n'da ngu n'dajʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nɛ nujʉ n'da'a n'danni bá nɛxhʉ, nɛ 'dajʉ, 'bʉ'i 'da bá nɛxpʉ Partia, nɛpʉ Media, nɛpʉ Elam, nɛpʉ Mesopotamia, nɛpʉ Judea, nɛpʉ Capadocia, nɛpʉ Ponto, nɛpʉ ra häi Asia. ");
INSERT INTO otmNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Nɛpʉ Frigia, nɛpʉ Panfilia, nɛpʉ ra häi Egipto, nɛpʉ ra häi Africa jom bʉ Cirene. Nɛ nu'ʉ mi'da yʉ romanos ʉ, madague'bʉ gätho yʉ judío ʉ, nɛ nu mi'da ʉ gue ɛ̨c'yɛi tengugahʉ dyʉ judíohʉ, nɛ 'bʉh mi'da bá nɛxpʉ Creta, nɛpʉ Arabia. ");
INSERT INTO otmNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nɛ dí øhmbʉ i mam ma ndehʉ nangue yʉ́n t'øt'e gue i øt' rá ts'ɛdi Oją, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nɛ gätho madi hyonya thoho, nɛ hingui pądi 'bɛ'a da bɛ̨ni. Nɛ n'da ngu n'da bi mansɛ ʉ: ―'Bɛ'a ní mba na in ja ya. ");
INSERT INTO otmNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pɛ nu'ʉ mi'da bi ma: ―Įti ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nɛ nu ra Pedro bʉya 'darpʉ mí 'bähmbʉ ʉ mi 'dɛ'ma'da yʉ́ 'bäihʉ ra Cristo, nɛ nts'ɛdi bin yą, bi 'yɛ̨na: ―N'yohʉ ahʉ dyʉ judíohʉ nɛ gätho ahʉ guí 'bʉhmbʉ ua Jerusalén, dami 'yøhmbʉ xʉn ho 'bɛ'a ga xi ahʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nuje hin dí įtihe tengu guím bɛ̨mhbʉ, nguetho ja gʉto ya. ");
INSERT INTO otmNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pɛ nuna guehna gue bin ja ya, gue'a bi man ra Joel rá pøngahyą Oją, bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Din ja bʉ n'da ra pa ba ɛ̨hɛ, ɛ̨n Oją, gue ga pɛn'nahʉ ma Hogandąhi gätho nangu yʉ ją'i 'bʉcua ja ra ximhäi. Nɛ nu'ʉ ni ts'ʉnt'ʉhʉ nɛ ni t'įxuhʉ dim pøngahyą. Nɛ ni ts'ʉnt'ʉhʉ da nu'ʉ yʉn t'uti tengu yʉ t'į nɛ ni dąc'yɛihʉ da 'uį yʉ t'į. ");
INSERT INTO otmNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nu'bʉ bin ja, nu'ʉ ma 'yɛ̨hɛ, yʉn 'yohʉ nɛ yʉ xisu, ga pɛnpä ma Hogandąhi ʉ, nɛ dim pøngahyą nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nɛ ga uh yʉ hmɛpya bʉ magąts'i, nɛpʉ ja ra häi, yʉ hmɛpya ra ji, nɛ ra sibi nɛ ra 'bifi. ");
INSERT INTO otmNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nɛ nu'a ra hyadi ya hin din ja rán nɛqui, nɛ ra ząna xtan thɛni tengu ra ji. M'bɛt'o nja bʉ din ja, m'bɛjua da zøn ra pa dua ɛ̨h ra Hmu mahɛ̨ts'i, nɛ nu'a ra pa a, nuįxte thoho nɛ nts'utho 'bɛ'a din ja. ");
INSERT INTO otmNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nɛ nu'a ra pa dua ɛ̨hɛ, din ja gue hønt'a to'o xí mba't'a ra Hmu da yąn Oją a. Ngubʉ bi 'yo't'a ra Joel 'bʉ maya'bʉ, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nu ra Pedro xø bi 'yɛ̨mp'ʉ mahøn'a: ―N'yohʉ ahʉ dyʉ israelhʉ, dami 'yøhmbʉ ma nde. Dím mangä nangue ra Jesús ra mɛngu Nazaret. Oją bi japi ngue bi 'yøt' yʉn t'øt'e nuįxte nangue rá ts'ɛdi Oją, nɛ yʉ hyonya nt'øt'e, nɛ yʉ hmɛpya, guepʉ da zä gui pąhmbʉ ngue Oją bi zɛ'a. ");
INSERT INTO otmNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nɛ maya'bʉ Oją mi pądi 'bɛ'a gá 'yørpahʉ rá Ts'ʉnt'ʉ. Nɛ Oją mi sänni gue gá cuathʉ bʉ ja n'da ra pont'i nangue yʉ́ 'yɛ yʉ tonto, nɛ gá hyohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pɛ nu'a Oją bi xox 'bʉ mí du, nɛ bi hyącua ran dąte, nguetho hin'yʉ rá ts'ɛdi ran dąte xtán zä xtán ząm'ma ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nguetho bi man ra David gue 'bɛ'a da nu ra Jesús, 'bʉ mí 'yɛ̨na: Nugä thocua thoho dí nugä Oją bʉ ja ma hmi. Nɛ di 'dac ra ts'ɛdi, janangue'a njon da zä di 'uegagui. ");
INSERT INTO otmNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Janangue'a i hu ma mbʉi, nɛ dadín johya 'bʉ dím mangä nangue'a. Nɛ nu'bʉ din sʉnya ma ją'i bʉ ja ran 'yägui, dí tøp'ma ran ho da t'ørcagui. ");
INSERT INTO otmNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nguetho hin gui hyɛgä ma te da gopʉ guepʉ o'ʉ xʉn du, Nɛ hin gui japi da 'ya ma ngøc'yɛi, guecä, ni Hoga t'ʉhnigui. ");
INSERT INTO otmNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nɛ gá 'yurqui 'bɛpʉ dám 'bʉhmi maząi mahøn'a, nɛ nu'i gui jaqui ngue din ja ran johya ma mbʉi nu'bʉ dá nut'a ni hmi, bi 'yɛ̨n ra Pedro tengu bi man ra David. ");
INSERT INTO otmNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nɛ xø bi 'yɛ̨n'a ra Pedro: ―N'yohʉ ahʉ, da zä ga xi ahʉ majuąni nangue ma ngʉrpa mbombøtahʉ ra David mi 'bʉi maya'bʉ, him bi mansɛ nanguesɛ 'bɛ'a da t'ørpe, nguetho bi du, nɛ guexta'a i o bʉ rán 'yägui i ja ua dí 'bʉhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pɛ nu ra David bim pøngahyą 'bʉ mí man na, nɛ mí pądi majuąni 'bɛ'a bi xi'a Oją, gue n'da rám bom'bɛto ra David din ts'ʉt'abi nangue yʉ israel tengu ra David, nɛ guehna ra Cristo na. ");
INSERT INTO otmNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nɛ mi pąh ra David 'bɛ'a din ja, janangue'a bi ma nangue da ndants' mahøn'a ra Cristo, nɛ hin da ts'opʉ nidu rá te, nɛ xín da 'ya rá ngøc'yɛi a. ");
INSERT INTO otmNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nguehna ra Jesús, Oją bi xox 'bʉ mi du, nɛ nu'a dí pąhmbe majuąni gätho gahe, nɛ dí mamhbe nguetho dá nuhe 'bɛ'a bi t'ørpe. ");
INSERT INTO otmNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Oją bi xots'i nɛ bi zixpʉ ja rá ts'ɛdi, nɛ bi un'na rá Hogandąhi tengu xí man Oją, janangue'a bi 'dacähe bʉya. Gue'a rá Hogandąhi i øt'e 'bɛ'a gätho guín nuhʉ ya, nɛ guí øhmbʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nguetho ra David him bi ndex mahɛ̨ts'i, pɛ gue'a im mansɛ a: Nu'a ra Hmu bi xi'a ma Hmu: “Dami hyucua ja ma ts'ɛdi, ");
INSERT INTO otmNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta gue'bʉ ga tąhui man sʉiui,” bi 'yɛ̨n'a ra David, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nɛ xø bi 'yɛ̨na: ―Gätho ahʉ ma mi israel ahʉ, gui pąhmbʉ ya majuąni bi jap Oją dim hmu a gá cuathʉ bʉ ja ra pont'i, nɛ guehna ra Jesús, nɛ gui pąhmbʉ gue bi huan Oją a, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nu'bʉ mi 'yøh yʉ ją'i 'bɛ'a bi man'a ra Pedro, ɛ̨mmɛ bi du yʉ́ mbʉi, 'bʉ mí 'yøde gue rá Ts'ʉnt'ʉ Oją a xí hyo. Nɛ bi t'än'na ra Pedro nɛ yʉ́n 'yohʉ: ―Man 'yohʉ ahʉ, 'bɛ'a da zä ga øthe ya, ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nu ra Pedro bi dąti: ―Gui päh nin 'yomfɛ̨nihʉ nangue ran ts'o, nɛ gan xixyąhʉ n'da ngu n'da ahʉ nangue rá thuhu ra Jesucristo. Nɛ din ja ra punbi ni ts'oquihʉ, nɛ di 'da ahʉ rá Hogandąhi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nguetho bi man Oją di 'da ahʉ ran t'unni gue'a rá Hogandąhi Oją, nɛ ni t'ʉhnihʉ din t'unni, nɛ gätho ʉ hønbʉ go hapʉ i 'bʉi din t'unni, gue hønt'a go to'o da zohn'na Oją ra Hmu, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nɛ nu ra Pedro man'da xʉn ngu bi xifi nɛ bi hɛcui, nɛ bi 'yɛ̨mbi: ―Damin yąmhbʉ nangue'a ran ʉnbi da nu'ʉ yʉ ts'om'bäi i 'bʉcua ya, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nɛ gätho to'o bi 'yømanho a bi man ra Pedro bi mba ma xixyąbi. Nu ra pa gue bi man ra Pedro, mbɛ hyu mahuąhi yʉ ją'i bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nɛ nu'ʉ bi thocta'a bi xänba yʉ́ 'bäihʉ ra Cristo ʉ, nɛ bi hyu yʉ́ mbʉi nguetho 'da'angu im bɛ̨ni. Nɛ thocua thoho bim pɛti gue din yąhʉ Oją, nɛ da zi ra xɛcahmɛ, ngue bi bɛ̨n rán dąte ra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gätho yʉ ją'i bi numansu Oją nɛ ɛ̨mmɛ bi hyonya thoho 'bɛ'a bin ja nangue yʉn t'øt'e nuįxte nɛ yʉ hmɛpya bi 'yøt' yʉ́ 'bäihʉ ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nɛ gätho gue bi 'yɛ̨c'yɛi n'dat'a in numanho n'da ngu n'da, nɛ nu'a 'bɛ'a mí pɛ'ts'i n'da ngu n'da, 'da nan gomthoho. ");
INSERT INTO otmNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nɛ nu'bʉ n'da mí honi 'bɛ'a madí 'bɛdi, nu'a man'da bʉya bi mbä 'bɛ'a mí pɛ'ts'i, bi un'na bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nɛ mpa 'bʉ mpa 'bʉ madím pɛti bʉ ja ra dąniją. Nɛ nu'bʉ xʉn sihmɛ, bin sänbi bi mba bʉ ja yʉ́ ngu yʉ́ mi'yɛ̨c'yɛihʉ, nɛ bin johya yʉ́ mbʉi, nɛ 'dat'a im bɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nɛ bi 'yɛ̨spa Oją, nɛ bi hnumansu ʉ nangue gätho yʉ ją'i. Nɛ nu Oją bi japi n'dapa ngu n'dapa i cʉrpʉ ja rá ts'ɛdi mi'da yʉ ją'i, gue bi zin'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","N'da ra pa 'bʉ hyunde, gue'a ra ora 'bʉ nząi mí yąhʉ Oją yʉ ją'i, bi mba bʉ ra dąniją ra Pedro nɛ ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mi 'bʉpʉ n'da ran 'yohʉ ra dogua gue'bʉ go mim 'bʉi. Nɛ nząi bi thuxpʉ ja rá goxthi ra dąniją. Nu ra goxthi t'ɛ̨mbi mahotho. Nu ran 'yohʉ da 'yäp yʉn t'unni yʉ ją'i i thopʉ mbo. ");
INSERT INTO otmNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nuna, nu'bʉ min nu ra Pedro nɛ'a ra Xuua ní mba bʉ ja ra dąniją, bi 'yäp ran t'unni. ");
INSERT INTO otmNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nu ra Pedro n'youi ra Xuua, nu'bʉ min nu i hupʉ, bi 'yɛ̨mbi: ―Hyandgä'be. ");
INSERT INTO otmNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nu ra dogua bi hyant'ʉ, mi tø'mi da hyąni 'bɛ'a di un'dʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pɛ nu ra Pedro bi 'yɛ̨mbi: ―Xíng ra t'axi xíng ra c'axt'i dí hągä, pɛ nu'a i jagui dadí 'da'a'i. Nangue rá ts'ɛdi ra Jesucristo mɛngu bʉ Nazaret, damí ndants'i nɛ gan 'yo, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nu ra Pedro bi bɛntpa rán 'yɛi, bi xots'i. 'Bex bin hąts'ɛdi rá gua, nɛ rá hyudi xįngua. ");
INSERT INTO otmNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nɛ n'da sägui thoho bi 'yøt' 'bʉ mi ndants'i nɛ bin 'yo. Nɛ'a bi yʉthʉ bʉ ja ra dąniją, sägui nɛ 'yo, nɛ ɛ̨spa Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Gätho yʉ ją'i bi nu ran 'yohʉ ngue bin 'yo nɛ bi 'yɛ̨spa Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nɛ mi pądi gue nu'a mi hupʉ ja ra goxthi mahotho bʉ ja ra dąniją mi äh ra mbɛti. Nɛ gätho bi hyonya thoho 'bɛ'a bin ja ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nu'a mi dogua hingui nde da hyɛ'a ra Pedro nɛ ra Xuua, nɛ bá ɛ̨pʉ xʉn ngu yʉ ją'i guepʉ ja ra ngun'yu mi 'bä ʉ, t'ɛ̨mbi Salomón, nɛ madí hyonya tho'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nu'bʉ mí hyant'ʉ yʉ ją'i a ra Pedro, bi 'yɛ̨mbi: ―N'yohʉ ahʉ dyʉ israelhʉ, hanja gadí hyonya thohʉ nanguehna ra dogua, nɛ hanja gní hyandga'be. Ha guí ɛ̨mhbʉ gue ma ts'ɛdisɛ'be nɛ man hosɛ'be gue xtá jap'be bin 'yo na. ");
INSERT INTO otmNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Hin'na maha, pɛ ga xi ahʉ hague bin ja. N'dat'a Oją gue mí ɛ̨spa mam bombøtahʉ ra Abraham nɛ ra Isaac nɛ ra Jacob, bi zixpʉ mahɛ̨ts'i a rá Ts'ʉnt'ʉ, nɛ bi un rá ts'ɛdi. N'dat'a ra Jesús gue gá dähʉ bʉ ja rá hmi ra Pilato nɛ gá cømhbʉ bʉ. Nu ra Pilato mim ma xtá mba nthɛgui. ");
INSERT INTO otmNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pɛ nu'ehʉ gá cømhbʉ n'da xʉn ho, nɛ gue'a rá Thahni Oją a. Nɛ gá 'yähmbʉ n'da ra hyodu da soc'ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nɛ gá mamhbʉ gue da mba ntho ra Hmu gue di un ra te. Pɛ Oją bi xoxpʉ 'bʉ'ʉ xʉn du, gue'a dá nuhe nɛ dadín juąnhde. ");
INSERT INTO otmNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bi zä na ran 'yohʉ nguetho bi 'yɛ̨c'yɛi ra Jesús. Nɛ guehna ran 'yohʉ guín nuhʉ ya, nɛ guí pąhmbʉ to'o na. ");
INSERT INTO otmNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pɛ nuya, n'yohʉ ahʉ, dí pącä ngue hin gmí pąhmbʉ 'bɛ'a xcá 'yøthʉ 'bʉ gmí hyohʉ ra Jesús, nɛ ximangutho ni ngʉrpihʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pɛ Oją bi japi bin ja 'bɛ'a gätho bi ma maya'bʉ, gue bi man yʉ pøngahyą nangue ran ʉnbi bi nu ra Cristo rá Thahni Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Janangue'a nuya, damí päh nin 'yomfɛ̨nihʉ nɛ gui däp ni mbʉihʉ Oją. Nɛ nu Oją bʉya da zä da duc'a ni ts'oquihʉ nɛ di 'da ahʉ ran johya ni mbʉihʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nɛ nu Oją ba pɛnhua mahøn'a ra Jesús nɛ gue'a ra Cristo xa ts'änni di jącuahʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nu ra Jesús jatho da gopʉ mahɛ̨ts'i jague'bʉ da zøn ra pa da mba ma hoqui gätho ua ja ra ximhäi, tengu bi man Oją maya'bʉ, nangue yʉ́ nde yʉ́ hoga pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pɛ bi 'yɛ̨nsɛ a ra Moisés: “Nu'a ra Hmu ma Ojąhʉ, da zänna n'da rám 'bɛhni ngue gue'a nin 'yohʉhʉ tengugä. Damí 'yøhmbʉ 'bɛ'a gätho da man'a. ");
INSERT INTO otmNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nɛ din ja, hønt'a go to'o má ją'i hin da 'yømanho a, da mba ma 'ueque nangue yʉ́ t'ʉhni Oją, nɛ da mba ma 'bɛpi rá te,” bi 'yɛ̨n'a ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nɛ majuąni, gätho bi man yʉ́ pøngahyą Oją gue'bʉ mí man ra Samuel nɛ gätho mi'da yʉ pøngahyą m'bɛjua mí 'bʉi, gätho bi ma 'bɛ'a gätho da 'yøt' Oją, nɛ gue'ʉ dí nuhʉ yʉ pa jabʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Guejʉ dyʉm bom'bɛtojʉ yʉ́ pøngahyą Oją, nɛ ndejʉ Oją ga comhbʉ rán hogui bi 'yørpa ma ngʉrpa bøtahʉ nu'bʉ mi t'ɛ̨mp'a ra Abraham: “Nangue n'da nim bom'bɛto dim 'bʉh niya'bʉ, dí mba ma jąpi gätho yʉ ją 'i guecua ja ra häi,” bi t'ɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Janangue'a nu'bʉ mi xoxa Oją a rá Ts'ʉnt'ʉ gue bi du, m'bɛt'o thoho bá pɛnhua dí 'bʉhmbʉ, ngue nde di 'uegahʉ n'da ngu n'dajʉ nangue ma ts'oquihʉ, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nu'bʉ mi xänba yʉ ją'i ra Pedro nɛ ra Xuua, bá ɛ̨h yʉ mbäją nɛ'ʉ yʉ hmu bʉ ja rá dąniją yʉ judío, nɛ yʉ saduceos. ");
INSERT INTO otmNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nu'ʉ ɛ̨mmɛ bin cuɛ ʉ, nguetho bi xänba yʉ ją'i gue bi ndants'a ra Jesús bʉ 'bʉ'ʉ xʉn du. ");
INSERT INTO otmNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nu'ʉ bi bɛnt'a ra Pedro nɛ ra Xuua, nɛ bi got'a fädi, jague'bʉ mi hyats'i bi juąnbi, nguetho xʉn de 'bʉ mi got'i. ");
INSERT INTO otmNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pɛ xʉn ngu ʉ xí 'yøh ram hma bi ma, bi 'yɛ̨c'yɛi. Mbɛ í jua'i cʉt'a mahuąhi yʉn 'yohʉ ngue bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nu'bʉ mi hyats'i bim pɛti bʉ Jerusalén yʉ ngʉrpa mbäją nɛ yʉ dąc'yɛi nɛ yʉ xänbate niją. ");
INSERT INTO otmNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mi 'bʉpʉ ra Anás ra dąmbäją a, nɛ ra Caifás, nɛ ra Xuua, nɛ ra Alejandro, nɛ gätho mi'da yʉ́ mɛni ra dąmbäją, bim pɛti ngue di juąnba ra Pedro nɛ ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nɛ bi manda da ts'ispa ra Pedro nɛ ra Xuua, nɛ bim 'bäpʉ ja yʉ́ hmi nɛ bi 'yänni: ―'Bɛ'a má ts'ɛdi o gue to'o rán t'ɛ̨di ngue xcá 'yøt'ui na. ");
INSERT INTO otmNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nu ra Pedro bʉya n'youi xʉn ngu rá ts'ɛdi rá Hogandąhi Oją, bi 'yɛ̨mbi: ―Gyʉ́ ngʉrpihʉ yʉ ją'i nɛ gyʉ dąc'yɛihʉ dyʉ ją'i israelhʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ha guí ängahe nam pa ya nangue ran ho bi t'ørpa na ran 'yohʉ, nɛ hague nja bi zä na ran 'yohʉ ngue mi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nu'bʉ majuąni guí ängahe, gui 'yøhmbʉ ya, nɛ gätho ma mi'israelhʉ, ngue nangue rá ts'ɛdi ra Jesucristo, gue'a í zä ín 'yo na ran 'yohʉ ya. Gue'a ra Jesús ra mɛngu bʉ Nazaret, gue gá cuathʉ bʉ ja ra pont'i, nɛ nu Oją bi xoxpʉ 'bʉ'ʉ xʉn du. ");
INSERT INTO otmNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Guehna ra Jesús hin gá nde gá pąhmbʉ, ngue tengu'bʉ gyʉ gądohʉ gá samhbʉ n'da ra do. Pɛ nuya Oją bi japi ngue tengu'bʉ n'da ra do man'da mahyonidą bʉ pa nthøe ra ngujądo. ");
INSERT INTO otmNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Njo'o man'da da zä di pø'a n'da hinda hønt'a ra Jesús. Nguetho him bi zän Oją man'da ra ts'ɛdi ua ja ra ximhäi gue da zä di pøjʉ, hinda hønt'a ra Jesús, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nɛ madi hyonya thoho ʉ yʉ juąnbate 'bʉ mí bądi him bi zu din yąhʉ ra Pedro nɛ ra Xuua, gue mí pądi him bin xädi. Pɛ bi bɛ̨m bʉya, bin 'yohʉ ra Jesús ra Pedro nɛ ra Xuua. ");
INSERT INTO otmNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nɛ nu'bʉ min nu ran 'yohʉ xí zä gue mi 'bʉhmbʉ ʉ, hin'yʉ 'bɛ'a man'da sä da xifi. ");
INSERT INTO otmNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nɛ bi mbɛhn bʉ thi ʉ yoho n'da zʉ ora, ngue nde din 'yän'dʉ 'bɛ'a da zä da 'yørpe. ");
INSERT INTO otmNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nɛ bin 'yän'dʉ: ―'Bɛ'a sä ga øthʉ nangue yʉn 'yohʉ, nguetho majuąni n'da ran t'øt'e nuįxte bi 'yøt'ʉ. Nɛ gätho 'bʉcua Jerusalén i pądi, hingui sä ga cømhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pɛ guehma nde'bʉ ga sʉhmbʉ n'dahma njon da xifi nangue ra Jesús, gue him man'da di thoc ram hma bʉ 'bʉh yʉ ją'i, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bi zohn mahøn'a ʉ, bi xih pʉya, gue him man'dandį da ma, xín da xänba yʉ ją'i nangue ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bi dąh ra Pedro nɛ ra Xuua, bi 'yɛ̨mbi: ―'Bɛ'a go guím bɛ̨nsɛhʉ ngue i nde Oją ga øt'be, ha gue'a guím mamhbʉ o gue'a man Oją a ga øt'be. ");
INSERT INTO otmNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nguetho jatho ga mamhbe 'bɛ'a xtá nuhe nɛ 'bɛ'a xtá øhmbe, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nu'bʉ man'da mi dąmhyą ʉ, bi hyɛgui nguetho him mi tįni 'bɛ'a dí ʉnba ʉ. Nu'ʉ i supi din cuɛ yʉ ją'i 'bʉ xtí ʉnba ra Pedro nɛ ra Xuua, nguetho gätho yʉ ją'i mí ɛ̨spa Oją nangue'a xín ja. ");
INSERT INTO otmNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nguetho nu ran 'yohʉ mi ponga nyote njɛya mi pɛ'ts'i, ngue bi t'ørpa ran t'øt'e nuįxte, gue bi zä. ");
INSERT INTO otmNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nu'bʉ mi thɛh ra Pedro nɛ ra Xuua, bá ɛ̨pʉ guepʉ mi 'bʉh yʉ 'yɛ̨c'yɛi. Nɛ bi xifi gätho xí xi'ʉ yʉ mbäją nɛ yʉ dąc'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nu'ʉ, nu'bʉ mí 'yøde, bi zo Oją, n'dat'a im bɛ̨ni, nɛ bi 'yɛ̨n'ʉ: ―Ma Oją ahe, gue gra Hmu, gá 'yøt' mahɛ̨ts'i nɛcua ja ra häi nɛ ra deją nɛ gätho ʉ i jabʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nɛ nu ní Hogandąhi bi bɛ̨nba mam bombøtahe ra David, ni 'yɛ̨hɛ, 'bʉ mí 'yɛ̨na: Hanja nín 'yo'ts'ʉ yʉ ją'i gue hingui tɛn'na Oją, nɛ im bɛ̨n'ʉ gue him majuąni. ");
INSERT INTO otmNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yʉ́ hmuts'ʉt'abi yʉ häi ya bi dʉ'mi bi zä bi dʉmp' ra sʉi. Nɛ yʉ ts'ʉt'abi bim pɛti din sʉhmbʉ ra Hmu Oją nɛ ra Cristo rá Thahni Oją, bi 'yɛ̨n'a ra David. ");
INSERT INTO otmNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nguetho majuąni bim pɛti ua ja ra hnini ra Herodes, nɛ ra Poncio Pilato, nɛ yʉ ją'i ngue hing yʉ judío, nɛ ma mi'israelhe, nɛ bi zʉh ni hoga Ts'ʉnt'ʉ Jesús, gue'a gá huahni. ");
INSERT INTO otmNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nu'ʉ bi 'yøt'ʉ gätho 'bɛ'a xcá sän mam'bɛt'o gue bin ja. ");
INSERT INTO otmNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nuya ma Hmu ahe, damí nu'ʉ gue nde di ʉnje, nɛ damí 'daje ni ts'ɛdi, ni 'yɛ̨hɛgähe, ga huthe ran zambʉi ga mamhbe nim hma. ");
INSERT INTO otmNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nɛ ga uthe yʉ ją'i ni ts'ɛdi gue da zä'ʉ yʉn zäman'ʉ. Nɛ gui 'yut yʉn t'øt'e nuįxte nɛ yʉ hmɛpya nangue ni Hoga ts'ʉnt'ʉ ra Jesús, bi 'yɛ̨m 'bʉ min yąhʉ Oją ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nɛ nu'bʉ mí jua'a bin yąhʉ Oją, nu ra ngu guepʉ xím pɛti bin huąni, nɛ gätho ʉ man'da bi hyą yʉ́ ts'ɛdi nangue rá Hogandąhi Oją. Nɛ gätho yʉ 'yɛ̨c'yɛi bi hyut'an zambʉi, bi mamp'a rám hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Gätho yʉ 'yɛ̨c'yɛi i 'bʉi tengu n'danją'i tho, 'dat'a i øt'e, 'dat'a im bɛ̨ni. Xínga n'da bi ma gue jasɛ yʉ́ mbɛti, nɛ gätho 'bɛ'a mi ja mi cohmi. ");
INSERT INTO otmNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nɛ nu yʉ́ 'bäihʉ ra Cristo, nu'bʉ mí thoqui bi ma gue bi ndants'a ra Hmu Jesús 'bʉ mi du, nɛ bi jap Oją bin ja rá ts'ɛdi yʉ́m hma, nɛ xʉn ngu rá mate Oją bin t'un'ndʉ n'da ngu n'da ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gätho yʉ 'yɛ̨c'yɛi nte madi 'bɛdi 'bɛ'a gätho mi honi, nguetho xʉn ngu bi mbä yʉ́ häi o gue yʉ́ ngu mí ja, nɛ bi un ra mbɛti yʉ́ 'bäihʉ ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nɛ nu'ʉ bi darpa ʉ to'o di 'bɛ a da hyoni. ");
INSERT INTO otmNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nɛ gue'a bi 'yøt'a n'da ra 'yɛ̨c'yɛi, ra José na, ra mɛngu Chipre, rá 'yʉ ra Leví, pɛ nu'ʉ yʉ́ 'bäihʉ ra Cristo bi zänba man'da rá thuhu gue dí Bernabé, nde da ma i hurpa rá mbʉi n'da. ");
INSERT INTO otmNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nɛ gue'a bi 'yøt'e, bi mbä n'da rá huąhi mi ja, nɛ bá hą ra mbɛti, nɛ bi dä bʉ 'bʉh yʉ́ 'bäihʉ ra Cristo, ngue di un'dʉ nte mi ja. ");
INSERT INTO otmNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pɛ nu'a man'da ra 'yɛ̨c'yɛi í Ananías mi 'bʉpʉ, nɛ rá xisu, bi mbä yʉ́ häi. Nu'a rá xisu ra Safira a. ");
INSERT INTO otmNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nɛ bi gøn'i ts'ʉ ra mbɛti nɛ 'dat'a bi bɛ̨ mmi rá xisu. Nɛ bá hąc made ra mbɛti, bi gäpʉ 'bʉ'ʉ yʉ́ 'bäihʉ ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pɛ nu ra Pedro bi 'yɛ̨mp'a: ―Nu'i grá Ananías, hanja guí cʉ't' ni mbʉi ra zįthu, ra Satanás, gue di 'bɛp'i'i gui xih ra fɛhni rá Hogandąhi Oją, ngue gá hyąc'i ts'ʉ ra mbɛti guí pä ni häi. ");
INSERT INTO otmNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nu'bʉ hin xquí pä ni häi, ha hin xquí cohmi gue ni mbɛti zɛhɛ. Nɛ nu'i gá pä ni häi, ha hinga gue ni 'bɛfizɛhɛ xquí 'yøt'e nangue ni mbɛti. Hanja ngubʉ guím bɛ̨ni. Hinga gue'ʉ yʉn 'yohʉ gá xih ra fɛhni, pɛgue Oją gá xih ra fɛhni, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nɛ nu'bʉ mí 'yø'a ra Ananías 'bɛ'a bi man'a ra Pedro, 'bex bi du. Nɛ gätho to'o bi 'yøde nangue'a ɛ̨mmɛ bin ja ra mbidi yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nu'ʉ yʉn 'yohʉ mi 'bʉpʉ bi ndants'i, bi mbant'a ra ánima Ananías, bi duts'i, bi 'yägui. ");
INSERT INTO otmNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nɛ nu'bʉ mi tho'i ts'ʉ nhyu ora, bi zøh ra Safira, rá xisu ra Ananías, nɛ him mi pądi 'bɛ'a bi thogui. ");
INSERT INTO otmNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nu ra Pedro bi 'yän'na ra xisu: ―Xiqui hangu guí päui ni häi, tengu man ni ndø, bi 'yɛ̨n'a ra Pedro. ―Hąha ngubʉ rá muui, bi 'yɛ̨ntho ra Safira. ");
INSERT INTO otmNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nu ra Pedro bi 'yɛ̨mp'a bʉya: ―Hanja 'dat'a gá bɛ̨mmi, hanja sä gá cøn rá Hogandąhi Oją. Nuya 'bäcua ja ra goxthi ʉ gue bá äc'a ni ndø, nɛ'e da dux'a ya, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nɛ 'bex bi yørpʉ ja rá gua ra Pedro, nɛ bi du. Bi yʉt'ʉ yʉn 'yohʉ, bi nu, ya xí du, nɛ bi duts'i, nɛ bi 'yägui, 'darpʉ thoho bi 'youi rá ndø. ");
INSERT INTO otmNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nɛ ɛ̨mmɛ bi mbidi gätho ʉ yʉ 'yɛ̨c'yɛi, nɛ'ʉ gätho mi'da bi 'yøde bi mbidi. ");
INSERT INTO otmNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Xʉn ngu yʉ hmɛpya, nɛ yʉn t'øt'e nuįxte bi 'yøt' yʉ́ 'bäihʉ ra Cristo bʉ 'bʉh yʉ ją'i. Nɛ gätho madim pɛti bʉ ja ra dąniją guepʉ t'ɛ̨mbi rá ngun'yu ra Salomón, nɛ 'dat'a im bɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nɛ nu'ʉ mi'da ʉ gue hingui ɛ̨c'yɛi, bi zu din uąns'hʉ yʉ 'yɛ̨c'yɛi, nɛ bi hnumansu yʉ 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pɛ man'da man'da xʉn ngu bi 'yɛ̨c'yɛi ra Hmu, yʉn 'yohʉ nɛ yʉ xisu. ");
INSERT INTO otmNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nɛ nangue bi 'yøt' yʉn t'øt'e nuįxte yʉ́ 'bäihʉ ra Cristo, jananjabʉ i ts'opʉ ja 'yu yʉ hyɛ̨nni guepʉ da tho'ʉ, i oxpʉ ja yʉ́ t'ots'i nɛ yʉ́ fįdi. Nɛ nu'bʉ da thopʉ rá xudi ra Pedro da yąni. ");
INSERT INTO otmNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nɛ xʉn ngu bi bøm bʉ ja yʉ hnini guepʉ hän bʉ Jerusalén, bi mba bʉ Jerusalén, bi zix'ʉ yʉn zäman'ʉ, nɛ'ʉ min 'yohʉ yʉ zįthu. Gätho bi zä. ");
INSERT INTO otmNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Janangue'a yʉ dąmbäją nɛ gätho min 'yohʉ, nu'ʉ ɛ̨mbi yʉ saduceos, ɛ̨mmɛ bin ja yʉn ts'ɛya yʉ́ mbʉi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Janangue'a bi bɛnt'ʉ yʉ́ 'bäihʉ ra Cristo nɛ bi got'a fädi. ");
INSERT INTO otmNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pɛ nu'a n'da ram 'bɛhni bí 'yɛ̨h mahɛ̨ts'i 'bʉ min xui, bi xocua ra jut'i yʉ ofädi nɛ bi zixpʉ thi. Nɛ bi xifi: ");
INSERT INTO otmNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Ní mba, damam 'bähmbʉ bʉ ja ra dąniją, dami xihmbʉ yʉ ją'i gätho nangue ram 'bʉi ma'da'yo, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nu'ʉ, nu'bʉ mí 'yøh na, bi yʉrpʉ ja ra dąniją 'bʉ mi t'ʉxuditho, nɛ bi xänba yʉ ją'i. Nɛ nu'bʉ mí pɛti yʉ hmumbäją bʉ ja n'da ra ngu, nɛ'ʉ min 'yohʉ, nɛ madin zohni yʉ ngʉrpi nɛ yʉ́ dąc'yɛi yʉ israel, nɛ sä bi mbɛnpʉ fädi yʉ asmayo gue ba si yʉ́ 'bäihʉ ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pɛ nu'bʉ mi zøm bʉ ja ra fädi yʉ asmayo, njom bi dįm bʉ ʉ. Bi mbeng mahøn'a bʉ bí 'bʉh yʉ hmumbäją, ");
INSERT INTO otmNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","nɛ bi 'yɛ̨mbi: ―Dá tįm'be ra goxthi xø man thʉ't'i thoho nɛ yʉ mbädi mi 'bäpʉ thi ja ra goxthi. Nɛ nu'bʉ ma xoc'be, njo'o to'o dá tįm'be bʉ mbo, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nɛ nu'bʉ mi 'yø'a rá hmu yʉ mbädi bʉ ja ra dąniją, nɛ yʉ hmumbäją, bi hyonya thoho. Ɛ̨mmɛ bi du yʉ́ mbʉi: “Hapʉ maha nín sɛ'a øt'ʉ,” din 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","'Bex bi zøn'a n'da, bi xifi: ―Nu'ʉ yʉn 'yohʉ gá cothʉ fädi bí 'bäpʉ ja ra dąniją ya, nɛ i xänba ʉ yʉ ją'i, bi t'ɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nɛ bi mba rá hmu yʉ mbädi bʉya, nɛ in 'yohʉ yʉ mbädi. Nɛ xø bá si yʉ́ 'bäihʉ ra Cristo, nɛ him bi ʉnbi, nguetho mí su xtí mba ma bat'ado. ");
INSERT INTO otmNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nɛ nu'bʉ bá ts'i bʉ ja ra junta, bi 'yän yʉn t'änni a ra hmumbäją. Bi 'yɛ̨mp'ʉ: ");
INSERT INTO otmNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Ha hin dá hɛc'ahʉ gue hin gui xänbahʉ yʉ ją'i nangue ra Jesús. Pɛ hin guí øhmbʉ 'bɛ'a dá mangähe. Nuya gätho yʉ ją'i 'bʉcua Jerusalén i pąh ram hma guí mamhbʉ. Ha guí ɛ̨nje go ma ts'oquihe bi du ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nu'a ra Pedro nɛ'ʉ mi'da yʉ́n 'yohʉ bi dąti: ―Jatho ga øthe 'bɛ'a i xije Oją xinda gue i xije yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nu Oją gue bi dąnde ma ngʉrpa bøtahʉ, bi xox'a ra Jesús, nu'a gue'a gá hyohʉ 'bʉ gmí cuathʉ bʉ ja ra za. ");
INSERT INTO otmNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pɛ Oją bi zixpʉ bi gonhui rá ts'ɛdi, ngue dim hmu nɛ dim pørpate. Nɛ da japi di päh yʉ́ mbʉi yʉ ją'i israel nɛ di punba yʉ́ ts'oqui. ");
INSERT INTO otmNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nɛ nugähe dí mamhbe majuąni nanguehna. Nɛ'a rá Hogandąhi Oją im ma majuąni nanguehna. Nɛ nu Oją bi un rá Hogandąhi to'o gätho bi 'yɛ̨c'yɛi, gue da bąsɛ gue majuąni a, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nɛ nu'bʉ mí 'yø'ʉ hupʉ, ɛ̨ mmɛ bi dɛ ra cuɛ, nɛ min nde xtá hyo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pɛ bi ndants'a n'da ran 'yohʉ mi hupʉ ja ra junta, nuna n'da ra fariseo rá thuhu ra Gamaliel. Gue'a n'da ra xänbate yʉ́n t'ɛ̨di yʉ judío. Nɛ gätho yʉ ją'i in numansu a. Nu'a bi manda da ts'ixpʉ thi n'da zʉ ora ʉ i pa ma juąnbi. ");
INSERT INTO otmNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nɛ bi 'yɛ̨na: ―N'yohʉ ahʉ, dyʉ israelhʉ, dami jamansu 'bɛ'a guí ørpahʉ ya yʉn 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nguetho hin ɛ huą maya'bʉ bi ndants'a n'da ran 'yohʉ ra Teudas, mi ɛ̨na mi jasɛ rá ts'ɛdi. Nɛ xʉn ngu yʉ ją'i bi dɛnni, mbɛ goho ciɛnto. Nɛ nte dá ørpahʉ pɛ bi tho, nɛ gätho mi tɛnni bin 'uɛ̨xt'i 'da'a n'danni bi mba. ");
INSERT INTO otmNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","M'bɛjua bʉya, bi ndants' ra Judas ra mɛngu ra häi Galilea. Nu yʉ pa bin ja ra pede bin tɛt'i 'da yʉ ją'i. Pɛ nɛ'a bi mba ntho, nɛ gätho mi tɛnni bin 'uɛ̨xt'i. ");
INSERT INTO otmNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Janangue'a dí xi ahʉ, dami hyɛhmbʉ ya yʉn 'yohʉ, nguetho nu'bʉ rá ts'ɛdi zɛhɛ gue ra 'bɛfi i øt'e, da mba ma juadi 'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pɛ nu'bʉ rá 'bɛfi Oją i øt'e, hingui sä gui hɛcpahʉ. Nu'bʉ guí ɛ̨na gui hɛcpahʉ, gan sʉhmbʉ Oją 'bʉ, bi 'yɛ̨n'a ra Gamaliel. ");
INSERT INTO otmNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nu'ʉ, bi 'yømanho 'bɛ'a bi man ra Gamaliel, nɛ nu'bʉ mí xifi da yʉt'a mbo mahøn'a yʉ́ 'bäihʉ ra Cristo, bi mba m'bɛi, nɛ bi xi'ʉ hin din xänbate nangue ra Jesús, nɛ bi hyɛtho bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nu'bʉ mí bøm bʉ ja ra junta ʉ, bin johya yʉ́ mbʉi, nguetho ya bi nu ran ʉnbi nangue ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nɛ xínga n'da ra pa mi ɛ't'i gue him mi mamp'a ra hogam hma nangue ra Jesucristo, nɛ bi xänba yʉ ją'i nubʉ ja rá dąniją yʉ judío, nɛpʉ ja yʉ ngu. ");
INSERT INTO otmNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nu'ʉ yʉ pa ʉ man'da xʉn ngu bi 'yɛ̨c'yɛi. Nu'ʉ 'da bʉya gue i yą ra griego, bi dʉ'mi bi zʉ'ʉ i yą ra hebreo, i ɛ̨na hingui pa ma pɛti xʉn ho ʉ 'da yʉ́ mɛnguhʉ, gue yʉ xisu xʉn du yʉ́ ndø, gue'bʉ pa ma dat'i yʉn ts'ihmɛ n'da pa ngu n'da pa. ");
INSERT INTO otmNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nu'ʉ 'dɛ'mayoho yʉ́ 'bäihʉ ra Cristo bi ma gue dim pɛti yʉ 'yɛ̨c'yɛi bʉya, nɛ bi xifi: ―Hingui sä yoho ga øt'ähe, hingui sä ga thoqui ga unhde yʉn ts'ihmɛ yʉ ją'i, nguetho jatho ga mamhbe rám Hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Janangue'a ma zʉ cu ahʉ nangue ra Cristo, dami huahndʉ 'da gue gue'ahʉ yoto yʉ hogan'yohʉ gue i hą ra ts'ɛdi xʉn ho nangue rá Hogandąhi Oją in 'yohʉ, nɛ xʉn ho yʉ́n ' yomfɛ̨ni, di darpa yʉ́n ts'ihmɛ yʉ ją'i ngue nte i ja. ");
INSERT INTO otmNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pɛ nugähe ga thoje dan yąhe Oją nɛ ga mamhbe rám Hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nɛ gätho ʉ gue madi pɛti bʉ, bi 'yømanho ʉ 'bɛ'a bi man'ʉ yʉ́ 'bäihʉ ra Cristo. Nɛ bi than'na ra Esteban, n'da ran 'yohʉ ɛ̨mmɛ ɛ̨c'yɛi xʉn ho nɛ in 'youi xʉn ho rá Hogandąhi Oją. Nɛ bi than'na ra Felipe, nɛ ra Prócoro, nɛ ra Nicanor, nɛ ra Timón, nɛ ra Parmenas, nɛ ra Nicolás, nu'a mí tɛnba yʉ́ t'ɛ̨c'yɛi yʉ judío 'bʉ hin ní 'yɛ̨c'yɛi ra Cristo, nu'a bá nɛxpʉ ja ra hnini Antioquía. ");
INSERT INTO otmNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nɛ gätho bi ts'ixpʉ 'bʉh yʉ́ 'bäihʉ ra Cristo. Nɛ nu'ʉ bi gäspa yʉ́ 'yɛ yʉ́ yą ʉ bʉya, nɛ bin yąhʉ Oją ngue da mbäx'ʉ nangue ra 'bɛfi bin t'un'dʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nɛ man'da man'da bi hman rám hman Oją, janangue'a man'da xʉn ngu yʉ ją'i bʉ Jerusalén bi 'yɛ̨c'yɛi. Nɛ'ʉ yʉ mbäją bʉ ja yʉ́ niją yʉ judío, xʉn ngu bi 'yɛ̨c'yɛi nɛ bi dɛnni. ");
INSERT INTO otmNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nuna ra Esteban, xʉn ngu rám fäts'i Oją bi unni nɛ rá ts'ɛdi, nɛ bi 'yøt' yʉn t'øt'e nuįxte nɛ yʉ hmɛpya nangue rá ts'ɛdi Oją bʉ 'bʉh yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pɛ nu'ʉ 'da yʉn 'yohʉ bi dʉ'mi bin junthʉ ra Esteban, gue'ʉ i pa bʉ ja n'da rá niją yʉ judío guepʉ i pa yʉ ją'i min 'yɛ̨hɛ, nɛ'ʉ 'da yʉ mɛngu bʉ ra häi Cirene, nɛpʉ ja ra hnini Alejandría, nɛpʉ ja ra häi Cilicia, nɛ 'da yʉ mɛngu bʉ ra häi Asia, gätho bin junthʉ ra Esteban. ");
INSERT INTO otmNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pɛ him bi zä bi dąp'a ra Esteban, nguetho xʉn ngu rán 'yomfɛ̨ni mi ja, ngue mi yą con rá ts'ɛdi rá Hogandąhi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Janangue'a nt'ągui thoho bi 'bɛp'i 'da da man ra fɛhni, da 'yɛ̨na: “Dá øhmbe a bi ma, bi c'ąman'ʉ ra Moisés gue bi 'dac man t'ɛ̨dihʉ, nɛ bi c'ąman'ʉ Oją,” bi t'ɛ̨mp'ʉ 'da. ");
INSERT INTO otmNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bi parpa yʉ ją'i bʉya, nɛ yʉ dąc'yɛi, nɛ yʉ xänbate niją, bi fɛnt'a ra Esteban nɛ bi ts'ixpʉ bí ja ra junta nguepʉ i ja rán juąnbate yʉ hmumbäją. ");
INSERT INTO otmNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nɛ bi mba nthoni 'da da man yʉ fɛhni, nɛ bi 'yɛ̨na: ―Hingui ɛ'ts'a ní c'ąman'ʉ na ra dąniją nɛ'ʉ yʉ́n t'ɛ̨di ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nguetho dá øhmbe bi man na ran 'yohʉ, bi 'yɛ̨na: “Nu ra Jesús ra mɛngu Nazaret da xo't' ra dąniją nɛ di päh yʉn t'øt'e gue bi xijʉ ra Moisés,” bi 'yɛ̨n na ra Esteban, sä bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Gätho mi hupʉ ja ra junta bi hyand ra Esteban, nɛ bi nu ngue majuąni in 'youi xʉn ngu rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nu'a ra dąmbäją bi 'yän'na ra Esteban: ―Ha majuąni 'bɛ'a si'a ya. ");
INSERT INTO otmNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nu ra Esteban bi dądi: ―N'yohʉ ahʉ, gyʉ ta ahʉ, dami 'yøhmbʉ ya 'bʉ majuąni guecä dí øt'ä a i sicä. Nu'a Oją nuįxte thoho bin yąui ma ngʉrpa bøtahʉ ra Abraham, nu'bʉ mí 'bʉpʉ Mesopotamia, nɛ hin ní mba bʉ ra häi Harán. ");
INSERT INTO otmNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Oją bi xifi: “Dami pøngua ni häi, nɛ gui socua ni mɛni, nɛ gua ɛ̨pʉ n'da ra häi ga ut'a'i,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Janangue'a bi bøm bʉ ra häi Mesopotamia, nɛ i t'ɛ̨mbi Caldea, nɛ bim 'bʉpʉ ra häi Harán. Nu'bʉ ya bi du rá ta, bi nɛxpʉ Harán nɛ Oją bá si ua ja ra häi dí 'bʉhmbʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pɛ nu ra Abraham hinga gue'a ra ora bi xi Oją di un'na ra häi, xínga n'da xɛqui da ma gue rá häi zɛhɛ. Pɛ majuąni bi xifi di un ra häi gue da gomhbʉ yʉ́m bom'bɛto. Nu'bʉ mi xifi, mán jo'o yʉ́ t'ʉhni ra Abraham. ");
INSERT INTO otmNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nu'a Oją bi 'yɛ̨mbi: “Nu nim bom'bɛto ban 'yɛ̨hɛ bʉ n'danni ra häi, nɛ da mba ma ʉnbi goho ciɛnto njɛya.” ");
INSERT INTO otmNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nɛ xø bi 'yɛ̨mbi: “Nugä ga ʉnbä ʉ yʉ ją'i 'bʉpʉ ja ra häi guepʉ din 'yɛ̨hɛ, nɛ m'bɛjua bʉya nu'ʉ ba pøm bʉ guepʉ min 'yɛ̨hɛ, nɛ ba ɛ̨cua ja ra häi, nɛ guecua da dąndegui,” bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Oją bi 'yøt'ui ran hoqui ra Abraham, nu rá hmɛpya a gue da mba nthɛqui rá xifani, nɛ'ʉ yʉ́ xifani yʉ́ ts'ʉnt'ʉ. Bin jabʉ 'bʉ mim 'bʉh ra Isaac rá ts'ʉnt'ʉ ra Abraham, ná hyąto pa bi mba nthɛqui rá xifani. Nɛ nu'bʉ mín dąn'yohʉ ra Isaac, bim 'bʉh ra Jacob rá ts'ʉnt'ʉ, nɛ nu'bʉ min te ra Jacob bim 'bʉ'i 'dɛ'mayoho yʉ́ ts'ʉnt'ʉ, nu'ʉ gue'ʉ ma ngʉrpa bøtahʉ ʉ, bi 'yɛ̨n'a ra Esteban. ");
INSERT INTO otmNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nɛ xø bi 'yɛ̨na: ―Nu'a n'da rá ts'ʉnt'ʉ ra Jacob, ra José a. Nɛ nu yʉ́n 'yohʉ ra José bi sɛyabi, nɛ bi mbä. Nɛ nu'a to'o bi däi bi zixpʉ ja ra häi Egipto. Pɛ Oją min 'youi ra José. ");
INSERT INTO otmNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nu Oją bi zɛh ra José nangue gätho yʉn ʉnbi bi nu, nɛ bi un rám fäts'i nɛ bi un rán 'yomfɛ̨ni xʉn ho. Nɛ nu'a ra Faraón, ra hmuts'ʉt'abi bʉ ja ra häi Egipto, bi numanho a ra José, nɛ bi japi di manda gätho ra häi bʉ nɛpʉ ja rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nɛ bin ja n'da ra dąthu bʉ gätho ra häi Egipto, nɛpʉ ra häi Canaán, nɛ nu yʉ ją'i bi nu ran ʉnbi nguetho xø ma hin'yʉ 'bɛ'a da zi ma bøtahʉ bʉ mí 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nɛ nu'bʉ mi 'yøh ra Jacob gue mi pa m'bɛ'ts'i bʉ 'bɛ'a da ts'i bʉ ja ra häi Egipto, bi mbɛn'dʉ 'da yʉ́ ts'ʉnt'ʉ, gue'ʉ ma bøtahʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nɛ nu'bʉ mi mba mahøn'a yʉ́n 'yohʉ, guexta'a him mi pą'a ra José. Nu ra José bi 'yɛ̨mp'ʉ: “Dadín 'yohʉhʉ.” Nɛ nu'a ra José bi xi'a ra Faraón gue gue'ʉ yʉ́n 'yohʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nu ra José bʉya bi ma din zohni rá ta, ra Jacob, nɛ gätho ná ngu mi 'bʉpʉ ja rá ngu, gue í jua'i hyąte ma'dɛ'ma cʉt'anją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Janangue'a nu ra Jacob bi mba bʉ ja ra häi Egipto nɛ bi du bʉ. Nɛ'ʉ yʉ́ ts'ʉnt'ʉ mam bombøtahʉ bá tu bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pɛ nu'ʉ, him bá t'äpʉ, pɛ bi thuxpʉ Siquem nubʉ ra häi mí 'bʉi, nɛ bi t'äpʉ ja n'da ra jądo. Nu ra jądo gue'a bi dän'a ra Abraham gue bi mbä yʉ́ ts'ʉnt'ʉ ra Hamor, ra mɛngu Siquem. ");
INSERT INTO otmNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nu'bʉ mi ts'ʉtho da hyän yʉ pa tengu bi xi Oją ra Abraham, gue di un rá häi yʉ́m bom'bɛto, ɛ̨mmɛ bin xąnd yʉ ją'i bʉya, gue ma mi'israelhʉ, nubʉ ja ra häi Egipto. ");
INSERT INTO otmNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nɛ nubʉya bi ndants' man'da ra Faraón bʉ Egipto, nguetho gätho ní huti yʉ Faraón yʉ ts'ʉt'abi Egipto. Nɛ nuna man'da ra Faraón him mí pąh ra José. ");
INSERT INTO otmNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Janangue'a bi ʉcpi nɛ bi ʉnba ʉ mam bombøtahʉ. Nɛ bi manda da mba ma bʉnbi gätho yʉ́ ts'ʉnt'ʉ a ra pa dim 'bʉi, gue da du, nguetho in ndepe him man'da din xąnd yʉ ją'i israel. ");
INSERT INTO otmNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nu'ʉ yʉ pa'ʉ bim 'bʉ'a ra Moisés. Nu'a, n'da ra t'ʉhni madi nɛqui din hocją'i, nɛ mi numanho Oją. Nhyuzna bi jamansu rá ta nɛ rá mbe bʉ ja yʉ́ ngusɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pɛ nu'bʉ mi thøn'a thi ra 'uɛre Moisés, nu rá t'įxu ra Faraón bi dįni. Nɛ bi zini nɛ bi tede tengu'bʉ ɛ rá t'ʉhni zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nu'a ra Moisés bʉya gätho mi sänbi 'bɛ'a mí pąh yʉ mɛngu Egipto. Nɛ gätho i pømanho 'bɛ'a mi ma, nɛ xʉn ngu mi sä da 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nɛ nu'bʉ mi mbɛ'ts'a nyote njɛya, bi bɛ̨ni da mba bí zɛngua hapʉ madím pɛh yʉ́ mɛnguhʉ gue yʉ ją'i israel. ");
INSERT INTO otmNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nu'a n'da ʉ, bi nu ran ʉnbi ngue bi ʉnba n'da ra ją'i egipto. Nu'bʉ mi nu'a ra Moisés, bi yąni, bi cospa ra pengui bi hyo ngue bi du ra ją'i egipto. ");
INSERT INTO otmNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nu ra Moisés mim bɛ̨ni gue mi pą'ʉ yʉ ją'i israel 'bɛ'a da 'yøt' Oją, gue ra Moisés da yąn'ʉ, di japi him man da nu ran ʉnbi. Pɛ him mi pą'ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Man'da pa bʉya bi nu mahøn'a ra Moisés gue bin tuhni yoho yʉn 'yohʉ israel, nɛ nu ra Moisés bi zä bi hocua yʉ́ mbʉi, bi 'yɛ̨mbi: “N'yohʉ aui gadín cuui, 'bɛ'a guí ɛ̨nui a guí øt'ui gadín sʉhmi,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pɛ nu'a gue mi ja rá ts'oqui bin cuɛ, nɛ bi ndøn'na ra Moisés, bi 'yɛ̨mp'a: “Ha i ja nin t'ɛ̨di gui hegä'be, to'o bi xi'i gan ts'ʉt'abi ngue gui hogä'be. ");
INSERT INTO otmNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ha guí ɛ̨na gui hyogui tengu'bʉ gmí hyo ra mɛngu Egipto mán de,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nu ra Moisés nu'bʉ mi 'yøde 'bɛ'a bi man'a ran 'yohʉ, bi 'dagui, bi mba bʉ 'danguadi ra häi Madián. Nɛ mí 'bʉpʉ tengu bʉ nam 'bʉ'ʉ yʉ 'dan'yo ją'i, nɛ guepʉ ja bim 'bʉpʉ yoho yʉ́ ts'ʉnt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nɛ nu'bʉ mi tho'a nyote njɛya ngue mi 'bʉpʉ, bi nɛqui n'da rám 'bɛhni Oją mahɛ̨ts'i bʉ ja ra t'ʉza mi zø ra sibi, nubʉ ja ra ʉhäi, jombʉ ra t'øhø t'ɛ̨mbi Sinaí. ");
INSERT INTO otmNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nu'bʉ mín nu ra Moisés, madi hyonya thoho, bi mba bi hyän'i ts'ʉ bʉ ja ra t'ʉza ɛ̨na da nu 'bɛ'a i ja bʉ. Bi 'yørpa rá nde ra Hmu mahɛ̨ts'i bʉya, ");
INSERT INTO otmNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","bi 'yɛ̨mbi: “Nugä drá Oją gue i thąnde ni ngʉrpa mbombøtahʉ. Nugä dra Oją gue i thąnde ra Abraham, nɛ ra Isaac, nɛ ra Jacob,” bi 'yɛ̨mbi. Pɛ nu ra Moisés bi fɛt'i nɛ bin su, him bi hyąnzambʉi gue xpi hyandi. ");
INSERT INTO otmNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nu'a ra Hmu bi 'yɛ̨mbi: “Dami c'oc ni thįxfani nguetho nuua guí 'bäi, xʉn ho ua, ngue ya dí 'bäcä ua,” bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nɛ xø bi 'yɛ̨n Oją: “Dá nu ma t'ʉhni 'bʉpʉ ra häi Egipto ngue i pa ma ʉnbi. Nɛ dá øcä yʉ́ hmbafi ʉ. Bá ɛ̨cä ya gue ga japi da thɛgui. Nɛ nuya gui mba bʉ Egipto,” bi 'yɛ̨n Oją, bi t'ɛ̨mp'a ra Moisés, bi 'yɛ̨n'a ra Esteban. ");
INSERT INTO otmNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Nu ra Esteban xø bi xi'ʉ yʉ juąnbate mahøn'a, bi 'yɛ̨na: ―Guehna ra Moisés bi ts'ʉ 'bʉ mí 'yɛ̨na xtí hecua yoho yʉn 'yohʉ ma mi'israelhʉ, nɛ bi t'ɛ̨mbi: “Ha i ja nin t'ɛ̨di gui hegä'be, to'o bi xi'i gan ts'ʉt'abi.” Guehna ra Moisés, Oją bi mbɛnpʉ ngue din ts'ʉt'abi nangue yʉ ją'i israel, nɛ bi japi bi mba nthɛgui. Nɛ nu'a 'bɛ'a bi 'yøt'a ra Moisés, bi 'yøt'e nangue rám 'bɛhni Oją mahɛ̨ts'i bi nɛqui bʉ, nu'bʉ mi dɛ ra t'ʉza. ");
INSERT INTO otmNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nuna ra Moisés bi 'yøt' yʉn t'øt'e nuįxte nɛ yʉ hmɛpya nubʉ ja ra häi Egipto. M'bɛjua bʉya bi gʉcpʉ thi yʉ ją'i bʉ ja ra häi Egipto, nɛpʉ ja ra thɛnga deją bi 'yøt'a n'da ran t'øt'e nuįxte, nɛpʉ ma'ueni nguepʉ bin 'yo yote njɛya yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Guehna ra Moisés bi xih yʉ ją'i israel: “Oją da huan'nahʉ n'da ra pøngahyą guepʉ 'bʉh nin 'yohʉhʉ, tengutho bʉ bi huancä. Nu'a jatho gui 'yøhmbʉ 'bɛ'a da man'a,” bi 'yɛ̨na, bi 'yɛ̨n'a ra Esteban. ");
INSERT INTO otmNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nu ra Moisés gue'a bin 'yohʉ yʉ ją'i bʉ ma'ueni. Nɛ nubʉ ja rá yą ra t'øhø Sinaí bin yąui rám 'bɛhni Oją mahɛ̨ts'i, 'bʉ mi gopʉ ja rán dʉi ra t'øhø mam bombøtahʉ. Nɛ bi hyąnba rám hman Oją ra Moisés gue njąm'bʉ da guadi, nɛ gue'a bi thogahʉ a ya. ");
INSERT INTO otmNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pɛ nu'ʉ mam bombøtahʉ him bi nde bi 'yɛ̨c'yɛi a ra Moisés, him bi nde bi dɛnni xʉn ho, pɛ bi numan'ʉtho nɛ bi goh yʉ́ mbʉi, mím bɛ̨m bʉ Egipto. ");
INSERT INTO otmNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nu'ʉ bi 'yɛ̨mp'a ra Aarón, ra hmumbäją: “Dami 'yørcahe 'da yʉ oją da zixcahʉ. Nguetho hin dí pąhmbe 'bɛ'a bi ja a ra Moisés gue bá jʉgähe bʉ ja ra häi Egipto,” bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nu'ʉ bi 'yøt'a n'da ra t'ʉndąni bʉya, ɛ̨mbi yʉ́ oją, nɛ bi hyo yʉn dąni nɛ bi mbøx yʉ́ 'bøts'e. Nɛ madín johya a bi 'yøt'e nangue yʉ́ 'yɛsɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pɛ nu Oją bi 'uegue nangue'ʉ, nɛ bi hyɛgui da dąnde ra hyadi, ra ząna, nɛ yʉ sø, nguetho nt'o't'i bʉ ja rá søcuą yʉ pøngahyą: Pɛ hanja hinga guecä gá pøscahʉ 'bʉ gmí hyohʉ yʉn dąni 'bʉ gmí 'bʉhmbʉ nyote njɛya bʉ ma'ueni, i ɛ̨n Oją, bi 'yɛ̨n'ʉ yʉ pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pɛ hinga guecä gá thąndegahʉ pɛ guá tuhʉ n'da ra ngu'bø't'e guepʉ gá thąndehʉ a gá sänba zɛhɛ rá thuhu, gá ɛ̨mfʉ ra Moloc. Nɛ guá tuhʉ n'da rá hmite ra sø gá 'yɛ̨mb zɛhɛhʉ ra oją Renfán, ngue gá nde gá thąnde zɛhɛhʉ. Janangue'a ga ʉn'nahʉ nɛ ga pɛn'nahʉ man'da yatho xínda guepʉ ra häi Babilonia, i ɛ̨n Oją, bi 'yɛ̨n'ʉ yʉ pøngahyą. ");
INSERT INTO otmNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Pɛ guehma mi tu n'da ra ngu'bø't'e gue mí sänba Oją ʉ ma ngʉrpa bombøtahʉ 'bʉ mín 'yo bʉ ma'ueni, guepʉ da dąnde Oją ʉ, bi 'yøt'e tengu xí xi Oją ra Moisés, nu'bʉ min yąui bʉ ja ra t'øhø. Bi xifi da 'yøt'e tengu ra hmɛpya xí nu. ");
INSERT INTO otmNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","M'bɛjua bʉya, nu'bʉ mí ngʉrpi ra Josué, pɛ guexta'a ra ngu'bø't'e bá tu'ʉ ma ngʉrpa bombøtahʉ 'bʉ mí zøm bʉ ja ra häi xí xi Oją. Nɛ mí 'bʉpʉ mi'da yʉ ją'i gue hing yʉ israel. Nu Oją bʉya bi hyøn'a thi yʉ 'dan'yo ją'i nɛ bim 'bʉpʉ yʉ israel bʉya. Nɛ guexta'a mí jatho ra ngu'bø't'e nu'bʉ min ts'ʉt'abi ra David. ");
INSERT INTO otmNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nu'a Oją ɛ̨mmɛ mí numanho ra David, gue 'dat'a Oją mí thąnde ra Jacob. Nu'a ra David bi 'yäp rán t'ɛ̨di Oją da hyømba rá ngu gue rám poniui ra ngu'bø't'e. ");
INSERT INTO otmNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pɛ nu ra Salomón rá ts'ʉnt'ʉ ra David a, gue'a bi hyømba rá ngu Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pɛ nu'a Oją nuįxte thoho hingui 'bʉpʉ ja yʉ ngu nt'øt'e ngue yʉ́ 'yɛ yʉn 'yohʉ. Ngubʉ bi man ra pøngahyą 'bʉ mi thocpa rám hma ra Hmu mahɛ̨ts'i, nɛ bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nuua mahɛ̨ts'i i ja ma ts'ɛdi, nɛcua ja ra ximhäi ja ma ts'ɛdi, 'bɛ'a ní ngu guín nde gui hyøguahʉ, o hapʉ guí ɛ̨mhbʉ ja ma säya. ");
INSERT INTO otmNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ha hinga guesɛgä dá øt'ä gätho ja ua ya, ɛ̨n Oją, bi 'yɛ̨n'a ra pøngahyą, bi 'yɛ̨n'a ra Esteban. ");
INSERT INTO otmNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nɛ bi thoc'a ra Esteban bi xi'ʉ yʉ mbäją i ørpa ran juąnbi: ―Nu'ahʉ xíngui ts'ʉ guí øhmbʉ 'bʉ ja'a si ahʉ, nɛ xʉm mɛ ni mbʉihʉ, xíngui ts'ʉ di cʉ't' ni zaguhʉ. Thocua thoho guí säman'ʉhʉ rá Hogandąhi Oją tengutho mam bombøtahʉ, guín jahʉ bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Xínga n'da rá pøngahyą Oją gue him bi hyo mam bombøtahʉ, n'dat'ʉ yʉ pøngahyą gue bi ma dua ɛ̨h ra Hoga Cristo, gue'a gá dähʉ nɛ gá yąfʉ nɛ xin gá hyohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nu'ʉ yʉ́m 'bɛhni Oją mahɛ̨ts'i bi 'dajʉ rán t'ɛ̨di Oją, pɛ hin guí ʉrpahʉ ra güɛnda a 'bɛ'a bi ma, bi 'yɛ̨n'a ra Esteban 'bʉ mi 'yɛ̨mp'ʉ yʉ ngʉrpi. ");
INSERT INTO otmNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nɛ nu'bʉ mí 'yøh ya 'bɛ'a bi ma ra Esteban, bi dɛ ra cuɛ yʉ́ mbʉi nɛ bi yɛ̨xpa yʉ́ ts'i. ");
INSERT INTO otmNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pɛ nu ra Esteban mí hą ra ts'ɛdi xʉn ho rá mbʉi nangue rá Hogandąhi Oją in 'youi, nɛ bi ndøs' mahɛ̨ts'i nɛ di nɛc thoho hapʉ 'bʉ Oją. Nɛ bi nu ra Jesús 'darpʉ 'bʉhmi Oją nɛ i ja rá ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nɛ bi 'yɛ̨na: ―Pɛ dami ndøs'hʉ nʉ dín nugä, n'yø, nsoqui mahɛ̨ts'i nɛ dín nugä a bin ją'i ua ja ra ximhäi, i 'bʉhnʉ ja rán 'yɛi Oją, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pɛ nu'ʉ bʉya man'da bi got yʉ́ zagu, nɛ bi mbafi nangue yʉ́ cuɛ, gätho bi muxpʉ 'bäh ra Esteban. ");
INSERT INTO otmNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nɛ bi gʉcpʉ ja ra hnini nɛ bi bat'ado bʉ ma'ueni. Nɛ nu'ʉ gue bim bate, bi mbøh yʉ́ coto nguetho in nde nte di hɛ̨n'ʉ. Bi mbøpʉ ja rá gua n'da ran 'yohʉ ní huti ra Saulo, nɛ bi 'yɛ̨n'ʉ: ―Gui jamansu ts'ʉ ma cotogähe, bi t'ɛ̨mp'a. ");
INSERT INTO otmNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nɛ nu'bʉ gätho ní mba ma bat'ado ra Esteban, bi zo'a Oją, bi 'yɛ̨mbi: ―Nu'i ma Hmu Jesús, dami hyąnga ma te ya. ");
INSERT INTO otmNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nɛ bin dąnyahmu, nts'ɛdi bi mbafi, bi 'yɛ̨na: ―Ma Hmu i, o guí ʉrpa ra güɛnda nanguehna ra ts'oqui bin ja ya. Nɛ nu'bʉ mi man na, bi du bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Nɛ nu'a ra Saulo 'da'angu bi mamhbʉ ʉ bi hyo'a ra Esteban. Janangue'a nu ra pa ngue bi nu ran ʉnbi ra Esteban, nu yʉ 'yɛ̨c'yɛi mi 'bʉpʉ Jerusalén bi mba ma ʉcpi. Nɛ xʉn ngu ʉ bi mba bʉ mi'da yʉ hnini bʉ ra häi Judea, nɛpʉ ra häi Samaria, pɛ bi gopʉ ʉ 'dɛ'mayoho yʉ́ 'bäihʉ ra Cristo. Nɛ 'da'ʉ yʉ 'yɛ̨c'yɛi bi 'yäh ra Esteban, nɛ ɛ̨mmɛ bin zoni nangue'a. Nu ra Saulo ɛ̨mmɛ madi ʉcpa yʉ 'yɛ̨c'yɛi, nɛ mi cʉrpʉ ja yʉ ngu mi six yʉn 'yohʉ nɛ yʉ xisu, nɛ bi got'a fädi. ");
INSERT INTO otmNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pɛ nu'ʉ bi 'dagui, bi mamp'a rán ho ma'da'yo ra Cristo bʉ n'danni ním pa. ");
INSERT INTO otmNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nu'a ra Felipe bi mba bʉ ja n'da ra hnini ra häi Samaria, nɛ bi xih yʉ ją'i nangue ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Gätho yʉ ją'i bi 'yømanho 'bɛ'a bi man na ra Felipe 'bʉ mi nu yʉn t'øt'e nuįxte bi 'yøt'a. ");
INSERT INTO otmNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nguetho xʉn ngu yʉ ją'i bi hyønba thi yʉ zįthu, nɛ nts'ɛdi bi mba 'bʉ mí bøn'ʉ. Nɛ nu'ʉ mí 'uɛ'ts' yʉ́ ją'i nɛ'ʉ yʉ dogua gätho bi zä. ");
INSERT INTO otmNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Janangue'a ɛ̨mmɛ bin ja ran johya bʉ ja ra hnini. ");
INSERT INTO otmNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nɛ mí 'bʉpʉ n'da ran 'yohʉ í Simón, mi øt' ran thäte, nɛ nu'ʉ yʉ mɛngu Samaria madi hyonya thoho. Nu ra Simón min ndep yʉ ją'i da bɛ̨ni jasɛ rá ts'ɛdi. ");
INSERT INTO otmNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nɛ gätho na ngu'ʉ, yʉ t'ʉhni nɛ yʉ dąc'yɛi, nu'bʉ mi 'yø'ʉ 'bɛ'a bi man a, bi 'yɛ̨na: ―Nuna ran 'yohʉ na, ja ra ts'ɛdi tengu Oją, ɛ̨n yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nu'ʉ mi numansu ra Simón nguetho nya'a thoho mi häte. Nɛ bi hyonya thoho ʉ 'bɛ'a bi 'yøt'a. ");
INSERT INTO otmNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pɛ nu yʉ ją'i bi 'yɛ̨c'yɛi 'bɛ'a bi man'a ra Felipe nu'bʉ mí ma ra Hogamhma 'bɛpʉ ní manda rá ts'ɛdi Oją, ngue bi ma nangue ra Jesús. Nɛ bi mba ma xixyąbi yʉn 'yohʉ nɛ yʉ xisu. ");
INSERT INTO otmNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nɛ'a ra Simón ɛ̨na bi 'yɛ̨c'yɛi, nɛ nu'bʉ mín xixyą, bi dɛn'na ra Felipe. Nɛ nu'bʉ mín nu yʉ hmɛpya nɛ yʉn t'øt'e nuįxte bi 'yøt' ra Felipe, bi hyonya thoho ra Simón. ");
INSERT INTO otmNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nɛ nu'bʉ mi 'yø'ʉ yʉ́ 'bäihʉ ra Cristo 'bʉpʉ Jerusalén gue bi 'yɛ̨c'yɛi yʉ mɛngu Samaria, bi mbɛnpʉ ra Pedro nɛ ra Xuua ʉ mi'da yʉ́ 'bäihʉ ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nu'bʉ mi zøm bʉ bʉya, bin yąhʉ Oją, bi 'yäp rá ts'ɛdi ngue da hyąn rá Hogandąhi Oją yʉ 'yɛ̨c'yɛi 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nguetho hin ní zøh rá Hogandąhi Oją bʉ ja yʉ́ mbʉi ʉ, pɛ hønt'a nangue rá thuhu ra Hmu Jesús bin xixyą ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nu ra Pedro nɛ ra Xuua bʉya, bi gäspa yʉ́ 'yɛ yʉ́ yą yʉ 'yɛ̨c'yɛi, nɛ bi hyąn rá Hogandąhi Oją bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pɛ nu ra Simón, nu'bʉ mi nu bi hyąn rá Hogandąhi Oją ʉ bi gäx yʉ́ 'yɛ yʉ́ 'bäihʉ ra Cristo, bi 'yut ra mbɛti bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Bi 'yɛ̨mbi: ―Dami 'dac ma ts'ɛdi gue hønt'a to'o ga cäx ma 'yɛ da hyąn rá Hogandąhi Oją tengu guí øt'ui, ma gá jut'aui, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pɛ nu ra Pedro bi 'yɛ̨mbi: ―Di jua Oją ni mbɛti, nɛ'e, nguetho guím bɛ̨ni nangue ra mbɛti sä gui tän'a 'bɛ'a di un Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nguetho hinga gue'e ga comhbʉ na ra 'bɛfi, mfądi ya him mahoqui ni mbʉi bʉ ja rá hmi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dami päh ni mbʉi nangue ran ts'o. Dami 'yäp rá punbi ra Hmu, nɛ da zä di pun'na'i nangue ran ts'o gá bɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nguetho dí pądi ɛ̨mmɛ ja ran ts'ɛya ni mbʉi, nɛ ɛ̨mmɛ xʉn ngu ran ts'o ja ni mbʉi guím bɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nu ra Simón bi dąti: ―Nu'aui gui 'yähmi ts'ʉ rá ts'ɛdi ra Hmu nanguecä, ngue hin gan nugä a guí mammi, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nu'bʉ mim 'bʉ'i ts'ʉ bʉ ra Xuua nɛ ra Pedro, nɛ xí mamp'a rám hma ra Hmu mahɛ̨ts'i, bi mbeng bʉ Jerusalén. Pɛ him 'bex bi zøm bʉ, nɛ m'bɛt'o gätho ná ngu ra häi Samaria bi man'a ran ho ma'da'yo bʉ bi thogui. ");
INSERT INTO otmNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nu'a n'da rám 'bɛhni Oją mahɛ̨ts'i bi zøm bʉ bí 'bʉ'a ra Felipe, nɛ bi 'yɛ̨mbi: ―Ní mba 'danguadi guepʉ bí thoh ra 'yu ní mba Gaza, gue ní bøm bʉ Jerusalén. Nuna ra 'yu ní mba bʉ ra huɛnhäi na, bi 'yɛ̨mp'a rám 'bɛhni Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bi ndants'a ra Felipe 'bex bi mba bʉ. Bi nu, i 'yo bʉ 'yu n'da ran 'yohʉ xʉn hɛ̨ts'i rá 'bɛfi, di jamansup rá mbɛti ra xuts'ʉt'abi Candace bʉ ra häi Etiopía. Janangue'a i t'ɛ̨mbi ra eunuco, ngue nde da ma, m'boqui. ");
INSERT INTO otmNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nu'a xpí mbeng bʉ Jerusalén guepʉ bá thąnde Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nu rá Hogandąhi Oją bi 'yɛ̨mp'a ra Felipe: ―Gui mba gui sʉ'a ran 'yohʉ i hux ra carro. ");
INSERT INTO otmNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nu ra Felipe bin tih pʉya nɛ bi zʉdi. Nu'bʉ mí zøm bʉ, bi 'yøde gue mi nɛh ra søcuą ran 'yohʉ, gue rá søcuą ra Isaías rá pøngahyą Oją. Ra Felipe bi 'yän bʉya: ―Ha guí pądi 'bɛ'a nam bøn'a ra søcuą gadín xäh ya. ");
INSERT INTO otmNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Bi dą'a ran 'yohʉ: ―Hague dán zä ga pącä nu'bʉ njon da xängui. Nɛ bi xih ra Felipe da ndets'e din hyʉmmi bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nɛ nu'a ra søcuą madin xäh ran 'yohʉ mim ma gue: I ts'ix'a n'da ran 'yohʉ tengu n'da ra dɛ'yo i ts'its'i ngue da hyo. Nɛ tengu n'da ra t'ʉdɛ'yo nu'bʉ i ąxpa rá xįngu, hin di c'uɛ̨hɛ, nɛ ngutho a ran 'yohʉ hin din yą. ");
INSERT INTO otmNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nɛ nu'bʉ mín nu ran ʉnbi, njom bi yąni, njom bi mbäts'i. Nɛ njon da zä da ma hangu da dɛnni, nguetho bi thącua rá te ua ja ra ximhäi. Gue'a bi man ra søcuą bi nu ran 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nu ran 'yohʉ bʉya bi 'yän'na ra Felipe: ―Dami xiqui ts'ʉ to'o nín 'yohʉ na da nu ran ʉnbi, uague guesɛ na ra pøngahyą bi nu, uague n'dan'yo, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nu'a ra Felipe bʉya, bi dʉ'mi bi ma 'bɛ'a nam bøn'a ra søcuą nubʉ madín xäh na ran 'yohʉ, nɛ bi xifi nangue ra Jesús bi t'ørpa na im man ra søcuą, nɛ bi thoqui bi xifi xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nɛ nu'bʉ mí zøm bʉ po ra dehe, nu'a ran 'yohʉ bi 'yɛ̨mp'a ra Felipe: ―Ha hin da zä dan xixyągä 'bʉ, nɛ po ua ra dehe ya, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Bi dą'a ra Felipe: ―Da zä, nu'bʉ guí ɛ̨c'yɛi a dí xi'i nangue ra Jesús, gue gätho ni mbʉi. Bi dą'a ran 'yohʉ: ―Dí ɛ̨c'yɛi gue gue'a ra Jesucristo rá Ts'ʉnt'ʉ Oją a. ");
INSERT INTO otmNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nɛ bi säyabi rá carro bʉya. Nɛ bi gąpʉ ja ra carro nɛ bi mba bʉ mi po ra dehe. Nu ra Felipe bʉya bi 'yørpa ran xixyą a ran'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nɛ nu'bʉ mi bøxpʉ mí po ra dehe, 'dahmantho bi 'bɛrpʉ ra Felipe gue bi zix rá Hogandąhi Oją. Nɛ nu ra mɛngu Etiopía him man'dandį bi nu'a. Nɛ nu'bʉ mí thogui, bin johya rá mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pɛ nu ra Felipe ní nɛqui mahøn'a bʉ ra hnini Azoto. Nɛ nu'bʉ mambá thopʉ ja yʉ hnini, bi mam bʉ ran ho ma'da'yo asta gue'bʉ mi zøm bʉ ja ra hnini Cesarea. ");
INSERT INTO otmNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pɛ nu'a ra Saulo mim man yʉn ʉcuate, nɛ ran dąte nangue yʉ 'yɛ̨c'yɛi, gätho ná 'yøt'a bi 'yøt' ra Felipe. Nɛ bi mba bʉ bí 'bʉh ra hmumbäją. ");
INSERT INTO otmNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Nɛ bi 'yäp ra søcuą ngue ran t'ɛ̨di da mba bʉ ja yʉ́ niją yʉ judío nubʉ ra hnini Damasco. Nɛ nu'bʉ 'bo'o da dįm bʉ gue i tɛn ra Cristo, ogue ran 'yohʉ ogue ra xisu, da bɛnt'i nɛ da zixpʉ Jerusalén nthu't'i din ofädi bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nɛ nu'bʉ mí mba bʉ 'yu, mí ts'ʉtho da zøm bʉ Damasco, 'bex bí 'yɛ̨h mahɛ̨ts'i n'da ra nyot'i ɛ̨mmɛ bi hyärpʉ i 'bä'a ra Saulo. ");
INSERT INTO otmNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Bi dąng bʉ häi ra Saulo bʉya, nɛ bi 'yø'a n'da ra nde bi 'yɛ̨na: ―Saulo, Saulo, hanja gní ʉngui. ");
INSERT INTO otmNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Bi dą'a ra Saulo: ―To'o i, gra Hmu. Nu ra Hmu bi dąt'a: ―Nugä dra Jesús, guecä gadí ʉngui, nɛ xʉn hɛ̨i guí øt'e tengu n'da ra mbʉndąni i pa ma sʉni ra t'o ndepe dim pɛfi xʉn ho, nɛ i nɛte thoho. ");
INSERT INTO otmNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nu'a ra Saulo ɛ̨mmɛ bin su nɛ bi fɛt'i, bi 'yɛ̨na: ―Ma Hmu, 'bɛ'a guín nde ga øt'ä. Nu ra Hmu bi 'yɛ̨mbi: ―Dami ndants'i gui mba bʉ ja ra hnini, nubʉ, da si'i 'bɛ'a gui 'yøt'e, bi t'ɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nɛ nu'ʉ gätho mín 'yohʉ him mi sä din yą nguetho bin su. Nu'ʉ mí øh ra nde pɛ him min nu to'o min yą. ");
INSERT INTO otmNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nu'bʉ mi ndants'a ra Saulo bi zøt' rá dä pɛ him mi nu, mi xädä thoho. Nu'ʉ mín 'yohʉ bi bɛntpa rá 'yɛ bi zixpʉ Damasco. ");
INSERT INTO otmNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nɛ hyupa bám 'bʉpʉ, nɛ mi xädä, nɛ him mi sihmɛ, xing ra dehe mi si. ");
INSERT INTO otmNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nɛ mi 'bʉpʉ Damasco n'da ra 'yɛ̨c'yɛi rá thuhu ra Ananías. Nu ra Hmu mahɛ̨ts'i bin 'yusɛ bʉ nɛ bi zofo tengu'bʉ bin 'uį. ―Ananías, bi 'yɛ̨mbi. Nu ra Ananías bi dądi: ―Dí 'bʉcä ua gra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nu ra Hmu bi 'yɛ̨mp'a: ―Dami ndants'i gui mba bʉ ja ra 'yu t'ɛ̨mbi xʉn juąni, nɛ gui hyom bʉ n'da ran 'yohʉ ra Saulo, ra mɛngu Tarso, i 'bʉpʉ ja rá ngu ra Judas. Nuya in zocä ya. ");
INSERT INTO otmNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nɛ'a ra Saulo in nu tengu'bʉ ra t'į ngue guí mba bʉ nɛ guí cäx ni 'yɛ, nɛ da nu ran nɛqui mahøn'a, bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Bi dąt'a ra Ananías: ―Ma Hmu i, xʉn ngu yʉ ją'i bi xiqui 'bɛ'a øt'na ra Saulo, xʉn ngu yʉn ts'o xʉ 'yørpa yʉ 'yɛ̨c'yɛi 'bʉpʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nɛ nuna bá äp rán t'ɛ̨di yʉ hmumbäją da bɛnt'i nɛ da got'a fädi gätho to'o da ndøn'na ni thuhu, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pɛ nu'a ra Hmu bi xi'a ra Ananías: ―Ní mbahma nguetho dá huahndä da ma nanguecä bʉ 'bʉ'ʉ hing yʉ judío, nɛ yʉ hmuts'ʉt'abi, nɛ yʉ ją'i israel ngue yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nɛ ga xifi xʉn ngu yʉn ʉnbi da nu nanguecä, go bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bi mba ra Ananías bʉya, nɛ nu'bʉ mi yʉrpʉ ja ra ngu, bi gäx rá 'yɛ rá yą ra Saulo nɛ bi 'yɛ̨mbi: ―Ma cu'i Saulo, nu ra Hmu Jesús, nu'a gue gá nu bʉ 'yu 'bʉ guá ɛ̨hɛ, bá pɛncä ua ya gue di ja i da xoh ni dä. Nɛ di ja i gui hyą ra ts'ɛdi xʉn ho nangue rá Hogandąhi Oją gan 'youi, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nɛ 'bex bi hyø'ʉ mi comba yʉ́ dä tengu ra xihuą. Nɛ 'bex bi hyand ran nɛqui yʉ́ dä ra Saulo, 'bex bi ndants' pʉya nɛ bin xixyą. ");
INSERT INTO otmNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nɛ nubʉya, bin sihmɛ nɛ bi zac mahøn'a rá ją'i. Nɛ bám 'bʉ'i ts'ʉ bʉ bí 'bʉ'i 'da yʉ 'yɛ̨c'yɛi bʉ ra hnini Damasco. ");
INSERT INTO otmNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nɛ nu ra Saulo bʉya 'bex bi dʉ'mi bá mam bʉ rám Hman Oją bʉ ja yʉ́ niją yʉ judío. Nɛ bi xifi gue nu ra Jesús rá Ts'ʉnt'ʉ Oją a. ");
INSERT INTO otmNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Gätho mi øde bi hyonya thoho nɛ bi 'yɛ̨na: ―Ha hinga guehna ran 'yohʉ na mi cot'a fädi gätho mi ndønba rá thuhu ra Jesús bʉ Jerusalén. Nɛ ha him bá ɛ̨cua ngubʉ da 'yøt'e, nɛ da zits'i nthu't'i bʉ 'bʉh yʉ hmumbäją, bin 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pɛ nu ra Saulo man'da bi hyą ra ts'ɛdi bi ma xʉn ho. Nɛ nu yʉ judío 'bʉpʉ Damasco nte mi sä da ma, nguetho bi xifi, nu 'bɛ'a gätho mán ts'änni da'yøt'a rá Thahni Oją gue ra Cristo, pɛ gue'a bi 'yøt'a ra Jesús, guepʉ bi 'yuti n'dat'a. ");
INSERT INTO otmNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nɛ nu ra Saulo 'bʉ mím 'bʉpʉ nya'a ts'ʉ yʉ pa, n'dat'a mí man'ʉ yʉ judío hing yʉ 'yɛ̨c'yɛi, ngue da hyo. ");
INSERT INTO otmNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pɛ nu ra Saulo mi øde 'bɛ'a mbɛ̨n'ʉ yʉ judío. Nu'ʉ mí fäh yʉ́ goxthi bʉ ja ra ndehnini, guepʉ ma mbä't'i ra jądo. Ma pa nɛ ra xui mí fäh yʉ goxthi ngue nde da hyo. ");
INSERT INTO otmNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pɛ nu yʉ 'yɛ̨c'yɛi bi zix ra Saulo gue ra xui, í cą'ma n'da ra 'bøts'e bʉ thi bʉ ja ra jądo ngue ma fø't'e ra hnini. Gue'a í 'da'a. ");
INSERT INTO otmNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nu'bʉ mí zøm bʉ Jerusalén ra Saulo, mim bɛ̨ni gue xtín 'yohʉ yʉ 'yɛ̨c'yɛi. Pɛ nu'ʉ mín su'ʉ nɛ him mi ɛ̨c'yɛi gue ra 'yɛ̨c'yɛi ra Saulo. ");
INSERT INTO otmNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pɛ nu ra Bernabé bi zix'a ra Saulo guepʉ 'bʉh yʉ́ 'bäihʉ ra Cristo. Nɛ bi xifi ngue bi nu ra Hmu bʉ 'yu, nɛ bin yąui ra Hmu. Nɛ bi xifi bi hyut' ran zambʉi bʉ Damasco nu'bʉ mím ma nangue ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nu yʉ 'yɛ̨c'yɛi bi zim bʉya, nɛ bin 'yohʉ bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nɛ nu ra Saulo bi hyut' ran zambʉi bi mamp'a rám Hman Oją nangue ra Jesús. Pɛ nu'ʉ 'da yʉ́ mijudíohʉ gue i yą ra nde ra griego, madin junthʉ ra Saulo, nɛ'ʉ nde da hyo'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nu'bʉ mí 'yøh yʉ 'yɛ̨c'yɛi gue nde da tho ra Saulo, bi zixpʉ Cesarea nɛ bi mbɛnpʉ Tarso. ");
INSERT INTO otmNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nuya bin hɛ̨ yʉ́n ʉnbi yʉ 'yɛ̨c'yɛi gätho ra häi Judea, nɛ ra häi Galilea nɛ ra häi Samaria. Nɛ bin te yʉ́ mbʉi nangue Oją. Bi numansu ra Hmu nɛ bi nu rám fäts'i rá Hogandąhi Oją. Nɛ man'da xʉn ngu bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nu'a ra Pedro mí 'yo mi nu ʉ yʉ 'yɛ̨c'yɛi 'bʉpʉ ja yʉ hnini, nɛ bi zøm bʉ ja ra hnini Lida gue da nu yʉ 'yɛ̨c'yɛi 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nɛ bi dįm bʉ n'da ran 'yohʉ ní hu Eneas, nhyąto njɛya xí 'yoi gue xʉn ʉ, xín t'ɛ'ts' rá ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nu ra Pedro bi 'yɛ̨mp'a: ―Eneas, da zä'i nangue ra Jesús, dami ndants'i pants' ni fįdi, bi 'yɛ̨mbi. 'Bex bi ndants'a ra Eneas bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nɛ gätho ngue 'bʉpʉ Lida nɛpʉ Sarón bi 'yɛ̨c'yɛi ra Hmu 'bʉ mín nu'a bin ja, nɛ bi hyɛsɛ yʉ́ t'ɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nɛ nu'ʉ yʉ pa ʉ, mí 'bʉpʉ ja ra hnini Jope n'da ra xisu gue ra 'yɛ̨c'yɛi, í Tabita, nɛ í Dorcas ngue rá nde yʉ griego. Nuna ra xisu ɛ̨mmɛ xʉn ngu ran huɛ̨cate mí ørpa yʉ́ miją'ihʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pɛ nuya bin zäman'ʉ, nɛ bi du. Nu'bʉ mi 'berpa rá ją'i, bi jäxpʉ bí ja n'da ra t'ots'i magąts'i. ");
INSERT INTO otmNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nu ra hnini Lida mí hän bʉ Jope. Nu'bʉ mí 'yøh yʉ 'yɛ̨c'yɛi, gue 'bʉpʉ Lida ra Pedro, bi mbɛhn'dʉ yoho yʉn 'yohʉ gue ba ørpa ra ts'ɛdi ba ɛ̨hɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nu ra Pedro bʉya 'bex bán 'yohʉ ʉ. Nu'bʉ mí zøhø, 'bex bi ts'ixpʉ magąts'i ja a ra cuarto guepʉ mí 'bä'ʉ yʉ hyoya xisu mí zoni. Nɛ bi 'yut yʉ́ he xí t'ørpabi, gue bi 'yørpa ra Dorcas 'bʉ mi 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pɛ nu ra Pedro bi xifi: ―Dami pømhbʉ ts'ʉ n'da zʉ ora gätho ahʉ. Nɛ bin dąnyahmu nɛ bin yąui Oją. Nɛ bi hyant'a gue bi du, bi 'yɛ̨mbi: ―Tabita dami ndants'i, bi 'yɛ̨mbi. 'Bex bi zøt' rá dä, nɛ nu'bʉ mín nu ra Pedro, bi hyudi. ");
INSERT INTO otmNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nu ra Pedro bʉya bi bɛntpa rá 'yɛ nɛ bi xots'i, bim 'bäi. 'Bex bi zohn'dʉ yʉ 'yɛ̨c'yɛi nɛ yʉ hyoya xisu bʉya: ―Dami nuhʉ na xí du, nɛ bi dąmbɛ̨ni ya, bi 'yɛ̨mp'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nu'bʉ mí 'yø'ʉ gätho ra hnini Jope, xʉn ngu bi 'yɛ̨c'yɛi ra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nɛ nu ra Pedro xʉn ngu ts'ʉ yʉ pa bá copʉ Jope, bám 'bʉpʉ rá ngu ra Simón. Nu ra Simón ra hoca xindąni a. ");
INSERT INTO otmNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mí 'bʉpʉ n'da ran 'yohʉ í Cornelio, nubʉ ra hnini Cesarea. Gue nuna ran 'yohʉ im hmu nangue'ʉ n'da munts'i yʉ dofʉi gue'a ní t'ɛ̨mbi Italiano ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nuna ra Cornelio madague'bʉ hing ra judío a, pɛ nu'a nɛ gätho 'bʉpʉ rá ngu mi thąnde Oją nɛ mí numansu a. Nząi mi un yʉn t'unni yʉ hyoya nɛ nząi min yąhʉ Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","N'da ra pa mbɛ hyunde, tengu'bʉ bi 'uį 'bʉ mí nu n'da rám 'bɛhni Oją mahɛ̨ts'i, bi yʉrpʉ ja ra cuarto mí 'bäi, bi zofo: ―Cornelio, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nɛ nu'bʉ mí hyandi, bin su nɛ bi dądi: ―'Bɛ'a ma Hmu. Nu ram 'bɛhni bi 'yɛ̨mbi: ―Nu'a Oją im bɛ̨n'i, nɛ i ø'bʉ guí yąui, nɛ in nu Oją 'bʉ gdí un yʉn t'unni yʉ hyoya. ");
INSERT INTO otmNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nuya, gui pɛhn'dʉ 'da yʉn 'yohʉ bʉ Jope da dįm bʉ n'da gue ra Simón, nɛ guet'a ra Pedro a, nɛ gua pɛnhua. ");
INSERT INTO otmNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nu'a ra Pedro i 'bʉhmbʉ n'da ran 'yohʉ í Simón gue ra hoca xindąni a, nɛ i 'bʉpʉ ndendeją. Nu'a da xi'a'i 'bɛ'a gui 'yøt'e, bi 'yɛ̨n'a rám 'bɛhni Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nu'bʉ mí gua'a im ma, 'bex bi mbeng mahɛ̨ts'i ram 'bɛhni. Nu ra Cornelio bʉya bi zohni yoho yʉ́ 'yɛ̨hɛ nɛ n'da ra dofʉi ngue i numansu Oją, ngue rá 'yɛ̨hɛ a. ");
INSERT INTO otmNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nɛ nu'bʉ mi xifi gätho 'bɛ'a bi xih rám 'bɛhni Oją mahɛ̨ts'i, bi mbɛnpʉ Jope ʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Man'da pa bʉya mbɛ huxyadi nu'bʉ bá ɛ̨pʉ 'yu yʉ́m 'bɛhni ra Cornelio, häntho Jope, nu ra Pedro bi ndexpʉ thi bʉ ja ra zɛ'ts'angu bʉ mí 'bʉi, guepʉ din yąui Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nu'a ra Pedro ɛ̨mmɛ bin tumanthuhu, nɛ gätho ní mba mahoqui ran ts'ihmɛ, nu ra Pedro bʉya bi nu n'da ran t'uti, tengu'bʉ bi 'uį. ");
INSERT INTO otmNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nɛ bi nu nsoqui mahɛ̨ts'i, nɛ bá cąi tengu n'da ra the'bø't'e xʉn ndoho gue mfɛnt'i yʉ́ ts'ąt'i. ");
INSERT INTO otmNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nɛ ba 'yo bʉ ja ra 'bø't'e hønt'a go 'bɛ'a má zu'uɛ̨ i ja goho yʉ́ gua, nɛ yʉ zate, nɛ yʉ pozʉ, nɛ yʉ doja. ");
INSERT INTO otmNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nu ra Pedro bi 'yø'a n'da ra nde, bi t'ɛ̨mbi: ―Dami ndants'i gui hyo gue gui sa. ");
INSERT INTO otmNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bi dą'a ra Pedro: ―Hin'na ma Hmu, nguetho njąm'bʉ xtá sagä xʉn ts'o, gue'a i man nin t'ɛ̨di hingui ho 'bʉ ga sa. ");
INSERT INTO otmNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nɛ bi 'yɛ̨mbi mahøn'a: ―'Yo guí ɛ̨na hingui ho 'bɛ'a dá sändä da ts'a, ngue gätho dí hocä ʉ, bi 'yɛ̨mp'a ra nde. ");
INSERT INTO otmNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ná hyundį bi sifi, bi ndex mahøn'a mahɛ̨ts'i ra 'bø't'e. ");
INSERT INTO otmNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nu ra Pedro, nu'bʉ gätho madí hyonya thoho nɛ im bɛ̨ni 'bɛ'a ní mba'a xí nu tengu ra t'į, 'bex bi zøh yʉ́m 'bɛhni ra Cornelio. Nɛ mí 'bäpʉ thi ja ra goxthi rá ngu ra Simón, nɛ xí 'yänni hapʉ ja'a ra ngu. ");
INSERT INTO otmNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nu'bʉ mí zøm bʉ, bi 'yänni: ―Ha 'bʉcua ra Simón Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nɛ gätho nín 'yomfɛ̨ni ra Pedro 'bɛ'a ní mba a xí nu, nu'a rá Hogandąhi Oją bi 'yɛ̨mbi: ―'Bʉpʉ hyu yʉn 'yohʉ i hon'i. ");
INSERT INTO otmNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dami ndants'i, gui cąi nɛ gui mbähä ʉ yʉn 'yohʉ, gui tɛnni nɛ hin gan su, nguetho nugä bá pɛnhdä ʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nu ra Pedro bʉya bi gąpʉ mi 'bäh yʉn 'yohʉ gue bá pɛnh ra Cornelio, nɛ bi xifi: ―Nugä guecä guí hongui. 'Bɛ'a gní hyonjʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bi dą'ʉ: ―Nu ra Cornelio ra ngʉrpa dofʉi bá pɛncähe. Nu ra Cornelio n'da ra hocją'i gue i numansu Oją. Nɛ gätho yʉ judío i ndømanho nangue'a. Nɛ n'da ram 'bɛhni mahɛ̨ts'i bi xi'a da zonh'na'i, gue gui mba bʉ rá ngu, nɛ da t'ømanho 'bɛ'a gätho gui xifi, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nu ra Pedro bi xifi da yʉrpʉ mbo ra ngu, bin oxpʉ bʉya. Nu'bʉ mi hyats'i bi mbähä ra Pedro. Nɛ'ʉ 'da yʉ 'yɛ̨c'yɛi mí 'bʉpʉ Jope bi mbähä. ");
INSERT INTO otmNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Man'da pa bʉya bi zøm bʉ ra hnini Cesarea. Nu ra Cornelio xí zohni gätho 'bʉpʉ ja rá ngu nɛ yʉ́ amigo, ngue dim pɛti bʉ ja rá ngu. Gätho i tøm'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nu'bʉ mí zøm bʉ ja ra goxthi ra Pedro, bá pøn ra Cornelio, bi dądi nɛ bin dąnyahmu bi dąnde. ");
INSERT INTO otmNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pɛ nu ra Pedro bi gʉ'ts'i nɛ bi 'yɛ̨mbi: ―Dami ndants'i nguetho nugä dran 'yohʉ thohogä tengutho i, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nɛ i yąui gätho án yʉt'a mbo rá ngu. Nɛ bi nu xʉn ngu xím pɛti bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nu ra Pedro bi 'yɛ̨mp'ʉ bʉya: ―Guí pąhmbʉ hin 'yʉ man t'ɛ̨dihe dyʉ judíohe gue dan uąns'hʉ o gue ga cʉthe bʉ ja ni ngumhbʉ, nguetho hin gyʉ judío ahʉ. Pɛ Oją xʉ 'yurcagui gue xínga n'da yʉ ją'i ga ɛ̨mhbe hin da zä dan yąmanhohe, ogue ga ɛ̨mfe hingui ho. ");
INSERT INTO otmNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Janangue'a nu'bʉ gmí zoncagui, bá ɛ̨cä nɛ nte mán t'änni dá änni. Nuya dín nde ga pądi hanja gá zoncagui, bi 'yɛ̨n'a. ");
INSERT INTO otmNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nu ra Cornelio bi 'yɛ̨m bʉya: ―Ná goho pa tengu ra ora jabʉya, dá ɛ't' man ts'ihmɛ 'bʉ mán yągä'be Oją, 'bex bi zø'a n'da ran 'yohʉ ua dí 'bʉi, mí he ra pahni di fɛxni. ");
INSERT INTO otmNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nɛ bi 'yɛ̨ngui: “Cornelio, Oją bi 'yøde 'bɛ'a gám ma nɛ bi nu yʉn t'unni gá un yʉ hyoya, nɛ im bɛ̨n'a'i. ");
INSERT INTO otmNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nuya guin zohna ra Simón Pedro 'bʉpʉ Jope bʉ ja rá ngu ra Simón ra hoca xindąni a, nɛ i ja rá ngu bʉ ndendeją. Nɛ nu'bʉ da zøcua gan yąui,” ɛ̨n'a ram 'bɛhni mahɛ̨ts'i 'bʉ min zoqui. ");
INSERT INTO otmNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jananjabʉ dá zonh'na 'i nɛ xʉn ho guá ɛ̨hɛ. Nuya gäthogähe dí 'bʉhmbe ua ngue da nuje Oją, ga øhmbe 'bɛ'a gätho da xije Oją, gue gui xije, ɛ̨n'a ra Cornelio. ");
INSERT INTO otmNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nu ra Pedro bi 'yɛ̨mp'ʉ: ―Nugä dí pącä ya hingui huahna Oją to'o da numanho gue'bʉ ra judío o hing ra judío. ");
INSERT INTO otmNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nu Oją da zini hønt'a go nda'a ní nde i yą, ngue to'o gätho da numansu'a, nɛ to'o i øt' ran ho. ");
INSERT INTO otmNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Guí pąhmbʉ ram hma bá pɛncähe Oją dyʉ israelgähe, dyʉ judíogähe, bi ma nangue ra Jesucristo, gue nu'a di hocpa ní mbʉi n'da, guehna rá Hmu ʉ gätho hønt'a go 'bɛ'a ní nde i yą. ");
INSERT INTO otmNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nɛ guí pąhmbʉ ram hma nangue ra Jesucristo bi hmam bʉ gätho ra häi Judea, bí mbʉpʉ Galilea, gue'bʉ ya xí juah rá 'bɛfi ra Xuua Nxixyą gue bi ma di xixyąba yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nɛ guí pąhmbʉ Oją bi un rá ts'ɛdi rá Hogandąhi Oją ra Jesús, ra mɛngu bʉ Nazaret. Nu ra Jesús hønbʉ go hapʉ bin 'yo mí øt' ran ho, nɛ gätho ʉ mín 'yohʉ ra zįthu bi hyønba thi ra zįthu. Gätho bi 'yøt'ʉ nguetho min 'youi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nɛ nugähe ma 'bäigähe a ra Jesús, dí mamhbe majuąni, nguetho dá nuhe 'bɛ'a gätho bi 'yøt' ra Jesús nubʉ ma häihe dyʉ judíohe, nɛpʉ ma ngʉrpa hninihe Jerusalén. Nɛ m'bɛjua bi tho, bi guarpʉ ja ra pont'i. ");
INSERT INTO otmNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pɛ Oją bi xox'a ná hyupa, nɛ bi japi dá nugähe xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pɛ njom mi'da bi nu, høngdähe gue xí huancähe Oją. Janangue dí mamhbe majuąni, gue ya majuąni dán sihmɛgähe ra Jesús 'bʉ mi ndants' 'bʉ mi du. ");
INSERT INTO otmNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nɛ nu'a bi mbɛncähe gue ga xihmbe yʉ ją'i nɛ ga mamhbe, gue gue'a bi huahn'na Oją da 'yørpa ran juąnbi yʉ ją'i 'bʉi nɛ'ʉ xʉn du. ");
INSERT INTO otmNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nɛ guehna mím man'ʉ gätho yʉ́ pøngahyą Oją, gue gätho to'o da 'yɛ̨c'yɛi nangue ra Jesús, da hyąn ra punbi nangue yʉ́ ts'oqui, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nɛ i yą ra Pedro, 'bex bá ɛ̨h rá Hogandąhi Oją, gätho bi gohmbʉ yʉ ją'i i øh rám hma ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nɛ nu'ʉ yʉ judío min 'yohʉ ra Pedro madí hyonya thoho 'bʉ mí bądi bin t'un rá Hogandąhi Oją ʉ hing yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nguetho bi 'yøde bin yą 'da yʉ nde hing yʉ́ ndesɛ ʉ, gue bi 'yɛ̨spa Oją 'bʉ mí yą. ");
INSERT INTO otmNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nɛ bi 'yɛ̨n'a ra Pedro, bi 'yänni: ―Ha sä da mba ma hɛcpi ya 'bʉcua gue hin din xixyą, nɛ ya xʉ hyąn rá Hogandąhi Oją tengugahʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nɛ bi ma di xixyąbi nangue rá thuhu ra Jesucristo. M'bɛjua bʉya bi 'yäp ra mate ra Pedro da gohmbʉ bʉ mi'da yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nɛ nu'ʉ mi'da yʉ́ 'bäihʉ ra Cristo nɛ yʉ 'yɛ̨c'yɛi bʉ ra häi Judea mí øde gue yʉ ją'i hing yʉ judío bi hyąn rám hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pɛ nu'bʉ mí mbeng bʉ Judea ra Pedro, nɛ bi zøm bʉ Jerusalén, nu'ʉ 'da yʉ judío yʉ 'yɛ̨c'yɛi bʉ, bi zʉ'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nu'ʉ bi xi'a ra Pedro, bi 'yɛ̨mbi: ―Hanja gá mba bʉ yʉ́ ngu yʉ ją'i ngue hing yʉ judío, nɛ gán sihmɛhʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nu ra Pedro bʉya bi xifi 'bɛ'a gätho xín ja, gue'bʉ mí dʉ'mi bi xi Oją gue da zøm bʉ rá ngu ra Cornelio. Bi 'yɛ̨na: ");
INSERT INTO otmNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Mí 'bʉcä bʉ ra hnini Jope, nɛ mí yągä'be Oją. Dá nugä tengu'bʉ dá 'uį, bá cąh mahɛ̨ts'i tengu n'da ra the'bø't'e. Nɛ bá cąi mfɛnt'i goho yʉ́ ts'ąt'i, nɛ bi zøpʉ dí 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nu'bʉ má handi dá nu hønt'a go 'bɛ'a má zu'uɛ̨ 'bʉcua ja ra häi. Dá nu'ʉ ja goho yʉ́ gua, yʉ zu'uɛ̨ nɛ yʉ zate nɛ mi'da. Nɛ dá nu yʉ pozʉ nɛ yʉ doja. ");
INSERT INTO otmNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nɛ dá ø'a n'da ra nde bi xiqui: “Pedro, dami ndants'i gui hyo gue gui sa,” bi 'yɛ̨ngui. ");
INSERT INTO otmNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Hin'na ma Hmu,” dá ɛ̨mbi, “nguetho njąm'bʉ dá sagä a man nin t'ɛ̨di ngue hin ga sahe.” ");
INSERT INTO otmNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pɛ nu ra nde mahɛ̨ts'i bi xiqui mahøn'a: “Pɛ 'yo guí ɛ̨na hingui ho 'bɛ'a dí sändä da ts'a, ngue gätho dá hocä yʉ,” bi 'yɛ̨ngä a ra nde. ");
INSERT INTO otmNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nhyundį bi 'yøt'e njabʉ, bi mba ra 'bø't'e bʉ mahɛ̨ts'i bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nɛ 'bexque gue'a ra pa bi zøpʉ hyu yʉn 'yohʉ bʉ ja ra goxthi guepʉ dám 'bʉcä, gue yʉm 'bɛhni bá nɛxpʉ Cesarea, nɛ bi hyongui. ");
INSERT INTO otmNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nɛ nu'a rá Hogandąhi Oją bi xiqui ga tɛnni, nɛ nte mán t'änni ga änni. Nɛ 'bäcua ya 'dato yʉ 'yɛ̨c'yɛi ngue dá mbähmbe. Nɛ dá cʉthe bʉ ja rá ngu n'da ran 'yohʉ í Cornelio. ");
INSERT INTO otmNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nɛ nu'a bi xije gue bi nu n'da rám 'bɛhni Oją mahɛ̨ts'i mí 'bäpʉ ja rá ngu, gue bi xifi da mbɛnpʉ ja ra hnini Jope 'da yʉn 'yohʉ, da 'yänni nanguecä. ");
INSERT INTO otmNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nɛ bi xifi gue ga xifi hague dán zä dim pøhø, nɛ'ʉ 'bʉpʉ rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nɛ nu'bʉ mí jua'a bi xic ra Cornelio, dá dʉ'mi dá zocä bʉya. Nɛ nu'bʉ má dʉ'mi dá mangä, nu rá Hogandąhi Oją bá ɛ̨hɛ nɛ bi gohmbʉ ʉ mí 'bʉpʉ bʉya, tengutho bi 'yørcahʉ rá mbʉdi thoho. ");
INSERT INTO otmNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nɛ nubʉya dá bɛ̨ngä rám hma ra Hmu Jesús nu'bʉ mim ma: “Nu ra Xuua bi xixyą ahʉ ra dehe, pɛ nugä ga 'da ahʉ rá Hogandąhi Oją,” bi 'yɛ̨ngähe ra Jesús, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nɛ xø bi 'yɛ̨na: ―Nu'bʉ n'dat'a ran t'unni bi un Oją ʉ, tengutho bi 'dajʉ 'bʉ ya xtá ɛ̨c'yɛihʉ ra Hmu Jesucristo, ha da zä ga sɛrpä a in nde da 'yøt' Oją, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nu'bʉ mí 'yø'ʉ yʉ 'yɛ̨c'yɛi 'bʉpʉ Jerusalén 'bɛ'a bi man ra Pedro, him mam bi zʉi pɛ bi 'yɛ̨spa Oją, nɛ bi 'yɛ̨n'ʉ: ―A, njabʉ øt Oją 'bʉ, gue nɛ'ʉ yʉ ją'i hing yʉ judío di japi di päh yʉ́n 'yomfɛ̨ni nangue yʉ́ ts'oqui, ngue nɛ'ʉ din ja ra temaząi ʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nu'ʉ 'da yʉ 'yɛ̨c'yɛi ngue bi nu ran ʉnbi bʉ Jerusalén 'bʉ mí mba ntho ra Esteban, bin 'uɛ̨xt'ʉ. Nu'ʉ 'da bi mba bʉ n'danni yʉ häi Fenicia nɛpʉ Chipre nɛpʉ ja ra hnini Antioquía. Bi man rán ho ma'da'yo ra Cristo bʉ bim 'bʉi, pɛ hønt'ʉ yʉ́ mijudíohʉ bi xifi. ");
INSERT INTO otmNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pɛ nu'bʉ mí zøm bʉ Antioquía 'da yʉ mɛngu bʉ Chipre nɛpʉ Cirene, bi zo'ʉ hing yʉ judío, gue nɛ'ʉ bi xifi nangue ra Hmu Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nu'ʉ mí ja ra ts'ɛdi xʉn ho nangue Oją ʉ, janangue'a xʉn ngu yʉ ją'i hing yʉ judío bi 'yɛ̨c'yɛi, bi hyɛsɛ yʉ́ t'ɛ̨c'yɛi, nɛ bi dɛn'na ra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nɛ bi 'yø'ʉ yʉ 'yɛ̨c'yɛi 'bʉpʉ Jerusalén gue bi 'yɛ̨c'yɛi ʉ 'da hing yʉ judío bʉ Antioquía. Janangue'a bi mbɛnpʉ a ra Bernabé. ");
INSERT INTO otmNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nɛ nu'bʉ mí zøm bʉ, bi nu ngue i nu rá mate Oją yʉ ją'i i 'bʉpʉ. Bin johya rá mbʉi ra Bernabé bʉya, nɛ bi zofo, bi xifi hin da hyɛgui, pɛ din 'yomanho bʉ ja rá 'yu Oją, nɛ da 'yørpa rá 'bɛfi Oją ngue gätho yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nuna ra Bernabé n'da ra hocją'i na, nɛ mí hą rá ts'ɛdi xʉn ho rá mbʉi nangue rá Hogandąhi Oją in 'youi, nɛ mí ɛ̨c'yɛi xʉn ho. Janangue'a xʉn ngu mi'da yʉ ją'i bi 'yɛ̨c'yɛi ra Hmu. ");
INSERT INTO otmNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nubʉya, bá pøm bʉ ra Bernabé, bi mba bʉ Tarso bi hyom bʉ ra Saulo. Nɛ nu'bʉ mi dįni, bi zixpʉ Antioquía. ");
INSERT INTO otmNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nɛ n'dajɛya bám 'bʉhmi bʉ, nɛ mi pa bʉ ja ram pɛti nɛ bi xänbi xʉn ngu yʉ ją'i. Guepʉ ra mbʉdi bi t'ɛ̨mbi yʉ cristiano ʉ yʉ 'yɛ̨c'yɛi, gue mí nde da ma, i tɛn ra Cristo ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nu'ʉ yʉ pa ʉ, bá nɛxpʉ Jerusalén 'da yʉ pøngahyą, bi mba bʉ Antioquía. ");
INSERT INTO otmNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nu'a n'da í Agabo, bi ndants'i bim 'bäpʉ madím pɛti yʉ 'yɛ̨c'yɛi, nɛ bi ma con rá ts'ɛdi rá Hogandąhi Oją. Bi ma gue din ja ra thuhu gätho ra ximhäi. Nɛ nuna bin ja 'bʉ mim hmuts'ʉt'abi bʉ Roma a ra Claudio. ");
INSERT INTO otmNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nɛ nu'bʉ mín ja ra thuhu, nu'ʉ yʉ 'yɛ̨c'yɛi bʉ Antioquía bi zänni hangu na ngu ts'ʉ ra mbɛti da bądi n'da ngu n'da, gue da 'bɛnpa ʉ yʉ́ mi 'yɛ̨c'yɛihʉ 'bʉpʉ ra häi Judea, ngue da mbäx'i ts'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nɛ ngubʉ bi 'yøt'e, bi mbɛnpa ra mbɛti ʉ yʉ́ ngʉrpi yʉ 'yɛ̨c'yɛi bʉ Judea, bi hyąx'a ra Bernabé nɛ ra Saulo. ");
INSERT INTO otmNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nu'ʉ yʉ pa ʉ, nu ra ts'ʉt'abi Herodes bi manda da mba mfɛnt'i yʉ 'yɛ̨c'yɛi, bi dʉ'mi di ʉnba ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nɛ bi manda ngue bi tho ra Jacobo rán 'yohʉ ra Xuua, ra juai í tho a. ");
INSERT INTO otmNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nu'bʉ mi bąh ra Herodes gue i numanho yʉ judío hing yʉ 'yɛ̨c'yɛi gue bi hyo ra Jacobo, bi bɛnt'a ra Pedro, nɛ bin thɛui n'da ra dąmpɛti mí sänba Oją ʉ yʉ israel, t'ɛ̨mbi dąbaxjua. ");
INSERT INTO otmNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Janangue'a him 'bex bi tho ra Pedro, pɛ bi jot'a fädi. Nɛ bi manda 'dɛ'ma 'dato yʉ́ dofʉi ra Herodes di jamansu ra goxthi, 'da'i goho n'da cʉt'i. Mím bɛ̨n'a ra Herodes xtán zixpʉ 'bʉh yʉ ją'i, mí ɛ̨na xtá hyo bʉ 'bʉ mí gua'a ram pɛti ran dąbaxjua. ");
INSERT INTO otmNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nu ra Pedro guexta'a mí pa m'bädi xʉn ho bʉ ja ra fädi, pɛ nu yʉ́ mi 'yɛ̨c'yɛihʉ bim pɛti, nɛ ɛ̨mmɛ bin yąhʉ Oją nangue ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nu ra xui a gue mi ɛ̨n'a ra Herodes xtán gʉc 'bʉ mí hyats'i, nu ra Pedro mi cät'inde yoho yʉ dofʉi, nɛ nu'a, nthu't'i yoho yʉ cadena, nɛ bin ąha. Nɛ xø mí 'bäpʉ mi'da yʉ dofʉi bʉ ja rá goxthi ra fädi. ");
INSERT INTO otmNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","N'dahmantho bi zøpʉ 'bʉh ra Pedro n'da rám 'bɛhni ra Hmu mahɛ̨ts'i. Nɛ bi nɛcpʉ mbo ra fädi. Nu ram 'bɛhni bi 'yąnba rá hyo ra Pedro, bi 'yä'a, nɛ bi 'yɛ̨mbi: ―Ndants'a n'dihi, bi 'yɛ̨mbi. Nu yʉ cadena bi xosɛ gue'a mán thu't'i rá 'yɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nɛ nu ram 'bɛhni bi 'yɛ̨mp'a mahøn'a: ―Dami tʉ't' ni ngʉ't'i nɛ gui 'yʉ't' ni thįxfani. Nu ra Pedro bi 'yøt'e tengu bi si'a. Nɛ xø bi 'yɛ̨mbi: ―Hye ni dąpahni nɛ gui tɛngui. ");
INSERT INTO otmNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nu ra Pedro bi dɛn'na ram 'bɛhni, bi bøm bʉya. Pɛ him mí pą 'bʉ majuąni gue'a rám 'bɛhni Oją bi zits'i, uague tengu'bʉ bi 'uįtho. ");
INSERT INTO otmNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nɛ nu'bʉ mi thopʉ bí 'bäh rá mbʉdi yʉ mbädi, nɛ bi thopʉ ná yoho 'bäh yʉ mbädi, bi zøm bʉ bí ja ra jut'it'ɛgui bʉ ja ra 'yu ní mba bʉ hnini. Bi xosɛ ra jut'i nɛ bi bøm bʉya. Nɛ nu'bʉ min 'yo bʉ 'yu, bi 'ue'a rám 'bɛhni Oją, bi ts'o'a ra Pedro bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nu'a ra Pedro, nu'bʉ mi bądi 'bɛ'a gätho bin ja, ngue majuąni nɛ hing ra t'į, bi 'yɛ̨nsɛ: ―Dí pąsɛgä ya gue ra Hmu mahɛ̨ts'i bá pɛhna n'da rám 'bɛhni, nɛ bá jʉgä bʉ ja rá ts'ɛdi ra ts'ʉt'abi Herodes, nɛ bi yąngä nangue 'bɛ'a nde xtá 'yørcä ma mijudíohe, bi' yɛ̨nsɛ ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nɛ nu'bʉ mín 'yomfɛ̨ni ts'ʉ, bi mba bʉ ja rá ngu ra María, rá mbe ra Xuua Marcos, nɛ xʉn ngu madím pɛti bʉ, i yąhʉ Oją nangue ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nɛ nu'bʉ madí jät ra jut'i bʉ thi ja ra mbä't'i, bi mba bʉ n'da ra hmute, ra 'yɛ̨hɛ, í Rode, gue da bądi to'o i 'bäpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nɛ nu'bʉ mí 'yørpa rá nde ra Pedro, bi bądi to'o, nɛ ɛ̨mmɛ madí johya. Pɛ him 'bex bi xocuabi nguetho in nde m'bɛt'o bi xi'a n'dihi yʉ ją'i 'bʉpʉ, gue 'bäpʉ ra Pedro bʉ ja ra goxthi. ");
INSERT INTO otmNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nu yʉ ją'i bi 'yɛ̨mbi: ―Guí häte. Pɛ nu'a ra hmute guexta'a mi ma gue gue'a ra Pedro. Nɛ nu'ʉ bi ma: ―Gue'a rán dąhi a. ");
INSERT INTO otmNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pɛ nu ra Pedro bi thoc thoho di jät ra jut'i, nɛ nu'bʉ mi xocpi nɛ bi nu gue gue'a ra Pedro, bi hyonya thoho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pɛ nu'a ra Pedro bi uąnba rá 'yɛ, ndepe din hɛ̨. Nɛ bi xifi ha án zä bi gʉcpʉ ja ra fädi ra Hmu. Nɛ bi 'yɛ̨mp'ʉ yʉ ją'i: ―Dami xihmbʉ a man'da ra Jacobo, gue ra Santiago a, nɛ'ʉ mi'da yʉ 'yɛ̨c'yɛi 'bɛ'a bin ja, bi 'yɛ̨na. Nɛ bi bøn'a ra Pedro bi mba n'danni. ");
INSERT INTO otmNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nu'bʉ mi hyats'i, ɛ̨mmɛ bin ja ran cui, gue'da xnin 'yänthoho yʉ dofʉi, nguetho him bi bądi 'bɛ'a bin ja ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nɛ nu ra Herodes bi manda dí honi pɛ him bá thįni. Nɛ nubʉya bi 'yän'dʉ yʉ mbängoxthi hague bin ja, nɛ bi manda ngue da tho'ʉ bʉya. M'bɛjua bi bøn'a ra Herodes ra häi Judea, bi mba bʉ ja ra hnini Cesarea, nɛ bám 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nɛ nu ra Herodes ɛ̨mmɛ mí numan'ʉ yʉ ją'i 'bʉpʉ ra hnini Tiro nɛpʉ Sidón. Pɛ nu yʉ ją'i bim pɛti, pɛ m'bɛt'o bin amigohʉ ra Blasto, rám fäts'iui ra ts'ʉt'abi Herodes. Nɛ bi sih ra Blasto din hocpahʉ a ra Herodes, nguetho jatho dí nɛxpʉ 'bɛ'a da zi yʉ ją'i bʉ bí ja rá häi ra Herodes. ");
INSERT INTO otmNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Janangue'a bi zän man'da ra pa bʉya, nu yʉ ją'i bim pɛti. Nu ra Herodes bi hye rá pahni ɛ̨mmɛ xʉn ho, nɛ bi hyupʉ ja rá mɛxa, nɛ bin høt'ahyą. ");
INSERT INTO otmNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nɛ ɛ̨mmɛ bi mbahni yʉ ją'i nɛ bi 'yɛ̨n'ʉ: ―Hing rá nde n'da ran 'yohʉ bʉ na yą nʉ, pɛgue rá nde n'da ra oją, sä ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","'Dahmantho n'da rám 'bɛhni Oją mahɛ̨ts'i bi japi 'bex bin zäman'ʉ ra Herodes, nguetho him bi ma ngue hinga gue'a Oją a, him bi 'yɛ̨spa Oją. 'Bex bi nɛqui yʉ zu'uɛ̨ mbo rá foho, bi du bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pɛ nu rám Hman Oją bi thoqui bi hma, gätho bʉ n'danni bi 'yøh rám Hman Oją yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nu ra Bernabé nɛ ra Saulo, nu'bʉ mi guah yʉ́ 'bɛfi, gue bi sifi da hyąx ra mbɛti bʉ Jerusalén, bá peng bʉya, bán 'yohʉ ra Xuua Marcos, bi zøpʉ Antioquía mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nubʉ ra hnini Antioquía mi 'bʉpʉ yʉ 'yɛ̨c'yɛi ngue nząi dim pɛti. 'Da'ʉ yʉ pøngahyą, nɛ 'da'ʉ yʉ xänbate. Mí 'bʉpʉ ra Bernabé, nɛ Simón t'ɛ̨mbi Negro, nɛ ra Lucio ra mɛngu bʉ Cirene. Nɛ mí 'bʉpʉ ra Manaén, nu'a 'darpʉ bi mba ma tedeui ra Herodes rá ts'ʉt'abi ra häi Galilea, nɛ mí 'bʉpʉ ra Saulo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","N'da ra pa nu'bʉ mí 'yøt' ram pɛti ʉ, nɛ mí ɛ't' yʉ́n ts'ihmɛ, nɛ nu'a rá Hogandąhi Oją bi 'yɛ̨mp'ʉ: ―Dami 'uejʉ ya yoho yʉn 'yohʉ, ra Bernabé nɛ ra Saulo, nguetho xtá huanhdä ʉ da 'yøt' ra 'bɛfi dá xifi, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nu'bʉ mí 'yɛ't' yʉ́n ts'ihmɛ mahøn'a, bi 'yäp rám fäts'i Oją 'bʉ mí dospa rá yą ra Bernabé nɛ ra Saulo. Bin 'yɛ̨hmbʉ bʉya: ―Oją da zix ahʉ, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nubʉya nu rá Hogandąhi Oją bi zix'a ra Bernabé nɛ ra Saulo, bi mba bʉ ra hnini Seleucia. Nu'bʉ mí nɛxpʉ, bi hyu ra barco, bi mba bʉ ra häi Chipre, ra t'ʉhäi i ja bʉ made ra deją. ");
INSERT INTO otmNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nɛ nu'bʉ mi zøm bʉ ra hnini Salamina, bi mam bʉ rám Hman Oją bʉ ja yʉ́ niją yʉ judío. Nɛ ra Xuua Marcos mín 'yohʉ nɛ bim fäxpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nu'bʉ mi thopʉ gätho ra häi Chipre, bi zøm bʉ ja yʉ́ hyodi ra hnini Pafos. Nɛ bin tįmhbʉ n'da ra judío gue ra bądi, ɛ̨na rá pøngahyą Oją pɛgue ra hyäte a, nu rá thuhu í Barjesús. ");
INSERT INTO otmNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nu'a mín 'youi bʉ ja rá 'bɛfi ra Sergio Paulo, rá ts'ʉt'abi ra häi bʉ. Nu'a ra Sergio Paulo n'da ran 'yohʉ ɛ̨mmɛ mí ja rán 'yomfɛ̨ni xʉn ho. Nu'a bi zohna ra Bernabé nɛ ra Saulo nguetho nde da 'yøh rám Hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pɛ nu ra bądi Barjesús, n'dat'a ra Elimas, bi 'yʉ't'a ra ts'ʉt'abi, nguetho hingui ndepe da 'yɛ̨c'yɛi a i sifi, nɛ bin junthʉ a ra Bernabé nɛ ra Saulo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nu ra Saulo, n'dat'a ra Pablo a, n'youi xʉn ngu ra ts'ɛdi nangue rá Hogandąhi Oją a, ɛ̨mmɛ bi hyɛ̨t'a ran 'yohʉ ngue ra bądi. ");
INSERT INTO otmNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Nɛ bi 'yɛ̨mp'a: ―Nu'i gra ndøhyäte ɛ̨mmɛ guín 'youi gätho 'bɛ'a xʉn ts'o. Nu'i gra ts'ʉnt'ʉ i ra dąmants'o. Nu'i gadí ʉcua 'ʉ gätho xʉn ho. Ha njąm'bʉ gui 'yɛ'ts'a gní xih yʉ ją'i hingui ho 'bʉ da dɛn Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nuya da 'yøt'a'i ran ʉnbi ra Hmu mahɛ̨ts'i. Gan xädä gue hin da zä gui nu ran nɛqui 'da yʉ pa, bi 'yɛ̨mp'a ra Pablo. 'Bex bin xädä, bi gą 'bɛxui rá dä, nɛ bi hyoni to'o da gʉrpa rá 'yɛ'a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nu'bʉ mí nu'a ra ts'ʉt'abi 'bɛ'a bin ja, bi hyonya thoho, 'bex bi 'yɛ̨c'yɛi bʉya, nguetho ya bi bądi majuąni a rán xädi ra Hmu mahɛ̨ts'i ngue mím man'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nu ra Pablo nɛ'ʉ mín 'yohʉ bi hyu ra barco, bi nɛxpʉ Pafos nɛ bi zøm bʉ Perge bʉ ja ra häi Panfilia. Pɛ nu ra Xuua Marcos bá ɛ̨'a, bá sotho ʉ mín 'yohʉ, nɛ bá peng mahøn'a bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nu ra Pablo nɛ'a ra Bernabé mín 'youi, bi nɛxpʉ Perge bi mba bʉ man'da ra hnini Antioquía bʉ ra häi Pisidia. Nɛ nu'bʉ mi zøn ra pa ran säya, bi yʉrpʉ ja rá niją yʉ judío nɛ bi hyupʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nu'bʉ mi gua'a man'ʉ 'bʉpʉ, ngue rá søcuą yʉ́n t'ɛ̨di yʉ judío nɛ rá søcuą yʉ pøngahyą, nu'ʉ di jamansu bʉ ja ra niją bi xi'a ra Pablo nɛ ra Bernabé: ―N'yohʉ aui, nu'bʉ ja aui ts'ʉ n'da ran zofo, dami xije ts'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bi ndants'a ra Pablo bʉya, bim 'bäi, bi uąn rá 'yɛ ngue ndepe da 'yøh yʉ ją'i, nɛ bi 'yɛ̨mbi: ―N'yohʉ ahʉ ma mi'israelhʉ, nɛ gätho ahʉ guín numansuhʉ Oją, dami 'yøhmbʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nu'a Oją gue dí tɛnhdʉ dyʉ israelhʉ, bi huan'dʉ mam bombøtahʉ nɛ bi japi bin xąndi xʉn ngu nu'bʉ mí 'bʉpʉ ra häi Egipto, nɛ mí 'bʉpʉ tengu yʉ n'dan'yo ją'i. Nɛ nu Oją bʉya bá jʉc'ʉ nangue rá ts'ɛdi bʉ mi 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nɛ madague'a him madí däp Oją yʉ́ mbʉi ʉ 'bʉ min 'yo mbɛ nyote njɛya bʉ ma'ueni ʉ, pɛ guehma bin ja rá yembʉi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nɛ bi un'na ra häi Canaán ʉ ma mi'israelhʉ gue di manda zɛhɛ, 'bʉ mí jua'a bi hyo'ʉ yoto yʉ nde xmí 'bʉpʉ. Nɛ bin ząm bʉ ma mi'israelhʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nu Oją bʉya bi japi bim 'bʉh yʉ́ zɛ'mi, nɛ goho ciɛnto nɛ yote ma'dɛt'a njɛya madí manda ma mi'israelhʉ, asta gue'bʉ go mím 'bʉh ra pøngahyą Samuel. ");
INSERT INTO otmNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","M'bɛjua bi ndesɛ yʉ ją'i n'da ra hmuts'ʉt'abi di manda ʉ. Nɛ bi jap Oją a ra Saúl dim hmuts'ʉt'abi bʉya. Nu ra Saúl, rá ta a ra Cis, gue rám bombøta ra Benjamín mí 'bʉh maya'bʉ. Nɛ nu'a ra Saúl bim hmuts'ʉt'abi yote njɛya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nu'bʉ mi 'uec Oją ra Saúl bʉya, bi japi bim hmuts'ʉt'abi ra David. Nɛ mi man Oją, bi 'yɛ̨na: “Nuna ra David, rá ts'ʉnt'ʉ a ra Isaí, ɛ̨mmɛ dín numanho, nguetho da 'yørca a ma pähä nɛ 'bɛ'a gätho dín nde,” bi 'yɛ̨n Oją, bi 'yɛ̨n'a ra Pablo 'bʉ mín zo'ʉ yʉ́ mijudíohʉ bʉ ra hnini Antioquía, ra häi Pisidia. ");
INSERT INTO otmNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nɛ bi thoqui bi man ra Pablo, bi 'yɛ̨na: ―Nɛ gue'a ra David rám bom'bɛto na ra Jesús gue bá pɛncahʉ Oją, ma pørpatehʉ dyʉ israelhʉ, dyʉ judíohʉ, tengu mí man Oją maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ya ma guepʉ di dʉmp'rá 'bɛfi ra Jesús, nu ra Xuua mí xih ma mi'israelhʉ gue din xixyą to'o gätho bi päh yʉ́ mbʉi nangue yʉ́ ts'oqui. ");
INSERT INTO otmNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nu'bʉ mi ts'ʉtho da du a ra Xuua, nu'a mí mam buya: “Nu'a gá bɛ̨mhbʉ gue guecä pɛ hinga guecä. Pɛ m'bɛjua ba ɛ̨hɛ, nɛ hin dí sʉcä tengu a, nguetho ɛ̨mmɛ xʉn hɛ̨ts'i rá ts'ɛdi a,” mí ɛ̨n'a ra Xuua, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nɛ bi thoqui bi man ra Pablo, bi 'yɛ̨na: ―Man 'yohʉ ahʉ, yʉ́m bom'bɛtojʉ ra Abraham, nɛ mi'da ahʉ gue nɛ'ahʉ guí numansuhʉ Oją, guejʉ bá pɛncahʉ na rám hma Oją, nɛ i ma hague dán zä di pøjʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pɛ nu ma mɛnguhʉ mí 'bʉpʉ Jerusalén, nɛ yʉ́ ngʉrpi ʉ, him mi pądi gue gue'a ra Jesús mí o't' yʉ pøngahyą, madague'bʉ i hmam bʉ ja ma nijąhʉ gätho yʉ́ pa ran säya. Janangue'a bi 'yørpa ra Jesús tengu mán t'o't'i 'bʉ mí yąpi gue da hyo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nu ra Jesús nte min dupate, pɛ bi si'a ra Pilato gue di manda da tho. ");
INSERT INTO otmNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nɛ nu'bʉ mí 'yørpe 'bɛ'a gätho mán t'o't'i bʉ ja rám hman Oją, nɛ m'bɛjua bʉya bi mba ma cą'mi bʉ ja ra pont'i, nɛ bi t'ägui. ");
INSERT INTO otmNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pɛ nu Oją m'bɛjua ts'ʉ bi xoxpʉ 'bʉ'ʉ xʉn du. ");
INSERT INTO otmNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nɛ nu yʉn 'yohʉ mín 'yohʉ mam'bɛt'o a ra Jesús 'bʉ mí nɛxpʉ ra häi Galilea, nɛ bi mba bʉ ra dąhnini Jerusalén, nɛ guet'ʉ i xih yʉ ją'i ʉ ya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nɛcä'be dí xi ahʉ ya nangue ra Jesús, ran ho ma'da'yo gue'a mí xi Oją ʉ ma bøtahʉ 'bʉ mí ma gue 'bɛ'a majuąni din ja. ");
INSERT INTO otmNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nɛ gue'a bin ja a ya. Gue bi jącuahʉ 'bʉ mí xox'a ra Jesús, gue guejʉ dyʉm bom'bɛtojʉ ʉ bi xi Oją majuąni. Tengu mán t'o't'i bʉ ja rám Hman Oją, ná yoho ra Salmo, i ɛ̨na: “Nuya nam pa ya, dí ɛ̨'ts'i'i, da nu'ʉ yʉ ją'i ya gue majuąni ma Ts'ʉnt'ʉ i,” mí ɛ̨n Oją 'bʉ mi 'yɛ̨na, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nɛ xø bi 'yɛ̨n'a ra Pablo: ―Nɛ bi xox Oją a ra Jesús 'bʉ mí du, nɛ hin da du mahøn'a. Nɛ gue'a bi man Oją, 'bʉ mi 'yɛ̨na: “'Dat'a ra hoganjąpi ga 'da'i tengu dá xih majuąni ra David,” bi 'yɛ̨n Oją, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nɛ xø bi 'yɛ̨na: ―Nɛ gue'a bi mam bʉ man'da ra Salmo gue bi 'yo't'a ra David, bi xi Oją: “Hin gui jap'a ni Hoga Ts'ʉnt'ʉ da 'ya a rá ngøc'yɛi,” bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pɛ nu ra David nu'bʉ mí jua'a rá 'bɛfi ngue bi 'yørpa rá pähä Oją gätho mí 'bʉcua ja ra häi, bi du. Nɛ 'darpʉ yʉ́n 'yägui yʉ́ bøta bi t'ägui, nɛ bi 'ya bʉ rá ngøc'yɛi a bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pɛ nu'a rá ngøc'yɛi ra Jesús, bi xox Oją a, him bi 'ya a. ");
INSERT INTO otmNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ma cu ahʉ, dín nde ahʉ gui pąhmbʉ, nangue ra Jesús i jajʉ ra punbi nangue ma ts'oquihʉ, nɛ gue'a dí xi ahʉ a ya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Hønt'a go to'o gahʉ ga däp ma mbʉihʉ a ra Jesús, din jajʉ ra punbi gätho ma ts'oquihʉ. Nɛ madague'a dí øthʉ yʉ́n t'ɛ̨di ra Moisés bi xi Oją, pɛ hinga gue'ʉ dí punga ma ts'oquihʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Dami 'yɛ̨c'yɛihʉ ra Cristo ya, janangue'a hin gui nuhʉ 'bɛ'a bi man yʉ pøngahyą bʉ ja rám Hman Oją, nu'bʉ mí ma: ");
INSERT INTO otmNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Damin 'yomfɛ̨nihʉ ts'ʉ a gnán thennate thohʉ, nguetho dí øt'ä n'da ra 'bɛfi nuįxte yʉ pa jabʉya guí 'bʉhmbʉ. Pɛ nu'bʉ hin gui 'yɛ̨c'yɛihʉ 'bʉ 'bo'o i xi ahʉ, gui hyonya thohohʉ 'bʉ bi mba ma ʉn'ni ahʉ, nɛ gui tuhʉ bʉya. Gue'a mí man yʉ pøngahyą 'bʉ mí 'yɛ̨n Oją, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nɛ nu'bʉ mí bøm bʉ ja ra niją ra Pablo nɛ'a mín 'youi, nɛ nu'ʉ 'da gue madim pɛti bʉ bi 'yäp ra mate gue da xih mahøn'a 'bʉ ni yoto ʉ, tengu xí xih ya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nɛ nu'bʉ mí gua'a ram pɛti bʉ ja ra niją, xʉn ngu yʉ́ mijudíohʉ nɛ'ʉ i ɛ̨c'yɛi tengu yʉ judío, bi dɛn'na ra Pablo nɛ ra Bernabé. Nu ra Pablo nɛ ra Bernabé bi xifi ngue di thoqui da 'yɛ̨c'yɛi ra Jesús, gue dí 'dajʉ rá mate Oją a. ");
INSERT INTO otmNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Janangue'a nu'bʉ mí zøn'a hyąto pa bʉya, ngue ra pa ran säya, mbɛ gätho na ngu yʉ ją'i 'bʉpʉ ja ra hnini bim pɛti bʉ, ngue da 'yøh rám Hman Oją mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pɛ nu'bʉ mi nu'ʉ yʉ judío ngue ní mba bʉ ja yʉ́ niją gätho yʉ ją'i, nɛ bin sɛya ʉ bʉya. Nɛ bin junthʉ ra Pablo nɛ mí ɛ̨n'ʉ him majuąni a bi ma, nɛ bi c'ąman'ʉ a. ");
INSERT INTO otmNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nu ra Pablo nɛ ra Bernabé bi hyut'ran zambʉi nɛ nts'ɛdi bi ma: ―Bi zän Oją m'bɛt'o thoho bi sijʉ rám Hman Oją dyʉ judíohʉ, nɛ hin gá hyąmhbʉ. Janangue'a hin nin sähʉ gui hyąmhbʉ ra temaząi. Pɛ ga mbähmbe ga xihmbe yʉ ją'i hing yʉ judío ya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nguetho ra Hmu mahɛ̨ts'i bi mbɛncähe nɛ mi ma: Ya dá pɛnh'nahʉ gui xihmbʉ yʉ ją'i hing yʉ judío, din ja ran nɛqui yʉ́ mbʉi. Nɛ gätho ra ximhäi gui mamhbʉ hague dán zä ga yąnba yʉ́ te yʉ ją'i, nɛ gue'a bi xije ra Hmu a, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nɛ nu'bʉ mí 'yøh yʉ ją'i ngue hing yʉ judío 'bɛ'a bi man ra Pablo, bin johya yʉ́ mbʉi, nɛ bi 'yɛ̨na: ―Xʉn ho rám Hman Oją, bi 'yɛ̨n'ʉ. Nɛ bi 'yɛ̨c'yɛi to'o gätho mán thahni gue din t'un'na ra temaząi. ");
INSERT INTO otmNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nɛ nu rám Hman Oją, ya gätho bʉ ja ra häi Pisidia bi hma. ");
INSERT INTO otmNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pɛ nu'ʉ 'da yʉ judío bi parpa ʉ 'da yʉ xisu, gue'ʉ 'da mí søm bʉ ja yʉ́ niją nɛ mí pa nt'ɛ̨spi bʉ ja ra hnini, nɛ'ʉ mi'da yʉn 'yohʉ gue yʉ ngʉrpi bʉ ja ra hnini. Nɛ nu'ʉ bi ʉcpa ra Pablo nɛ ra Bernabé bʉya, nɛ bi xifi da bøm bʉ ja yʉ́ häi. ");
INSERT INTO otmNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Janangue'a nu ra Pablo nɛ ra Bernabé bi huąc yʉ́ gua yʉ fonthäi, ngue n'da ra hmɛpya nde da ma, da nu rán thɛui a bi 'yøt'ʉ. Nɛ bi mba bʉ ja ra hnini Iconio bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pɛ nu yʉ 'yɛ̨c'yɛi bʉ Pisidia ɛ̨mmɛ bin johya, nɛ bi hyą ra ts'ɛdi xʉn ho nangue rá Hogandąhi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nubʉ Iconio, bi yʉrpʉ ra Pablo nɛ ra Bernabé bʉ ja yʉ́ niją yʉ judío, nɛ bi mam bʉ a rám Hman Oją. Nɛ bi ma xʉn ho, janangue'a xʉn ngu yʉ́ mijudíohʉ bi 'yɛ̨c'yɛi, nɛ'ʉ yʉ ją'i gue hing yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pɛ nu'ʉ 'da yʉ judío ngue him bi 'yɛ̨c'yɛi ɛ̨mmɛ madin 'yʉthʉ ʉ hing yʉ judío, bim parbi da zʉ'ʉ yʉ 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɛ nu ra Pablo nɛ ra Bernabé nya'a bim 'bʉpʉ, nguetho xʉn ngu bi 'yɛ̨c'yɛi bʉ, nɛ bi hyut' ran zambʉi bi ma nangue ra Hmu mahɛ̨ts'i. Nu ra Hmu bi un yʉ́ ts'ɛdi ʉ ngue da 'yøt' yʉ hmɛpya nɛ yʉn t'øt'e nuįxte, guepʉ da bąh yʉ ją'i, Oją in 'yohʉ ra Pablo nɛ ra Bernabé. ");
INSERT INTO otmNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pɛ nu yʉ ją'i bʉ ja ra hnini bin heque. 'Da'ʉ bi dɛn yʉ judío hing yʉ 'yɛ̨c'yɛi, nɛ 'da'ʉ bi dɛn ra Pablo nɛ ra Bernabé. ");
INSERT INTO otmNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Janangue'a, nu yʉ ngʉrpi bʉ ja ra hnini bi un ran t'ɛ̨di ʉ hing yʉ 'yɛ̨c'yɛi, yʉ judío ʉ'da, hing yʉ judío ʉ 'da, gue da zʉ'ʉ, nɛ di bat'ado ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pɛ nu ra Pablo nɛ ra Bernabé, 'bʉ mí bądi 'bɛ'a nde da 'yørpe, bi 'dagui, bi mba bʉ ja ra hnini Listra, nɛpʉ ra hnini Derbe nubʉ ra häi Licaonia. Nɛ bin 'yo gätho ra xɛqui bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nɛpʉ bá mam bʉ rán ho ma'da'yo ra Cristo bʉ ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nubʉ ja ra hnini Listra mí 'bʉpʉ n'da ran 'yohʉ, ra dogua, ngue ya xín jabʉ 'bʉ mim 'bʉi. Nɛ mí hurpʉ nguetho hin jąm'bʉ bin 'yo. ");
INSERT INTO otmNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nu ran 'yohʉ i øde 'bɛ'a bi man ra Pablo. Nu'bʉ mí hyɛ̨t a ra Pablo, mí pądi 'bɛ'a mím bɛ̨n'a zʉ dogua, ngue ya i ɛ̨c'yɛi gue dí hocpa rá gua ya. ");
INSERT INTO otmNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Janangue'a nu ra Pablo nts'ɛdi bi ma: ―Ndants'i gam 'bäi. Nu ran 'yohʉ bʉya 'bex bi zägui bin 'yo. ");
INSERT INTO otmNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nɛ nu'ʉ yʉ ją'i, nu'bʉ mín nu 'bɛ'a bi 'yøt'a ra Pablo, nts'ɛdi bi mbafi, nɛ bin yą yʉ́ nde 'ʉ licaonia, bi 'yɛ̨na: ―Nuya yʉ oją ya, pɛ bi nɛqui tengu'bʉ yʉn 'yohʉ, bi zøcua ja ra häi dí 'bʉhmbʉ, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nu ra Bernabé bi 'yɛ̨mbi tengu rá thuhu yʉ́ oją zɛhɛ ra Júpiter, ximangutho a ra Pablo bi 'yɛ̨mbi tengu rá thuhu yʉ́ oją zɛhɛ ra Mercurio. Nguetho man'da mi yą'a ra Pablo, nɛ i ɛ̨mbi rá pøngahyą ra Júpiter a ra Mercurio. ");
INSERT INTO otmNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nu'a ra mbäją bʉya, ngue mí pɛp'a yʉ́ oją Júpiter, mí ja bʉ n'da ra ngu bʉ ndehnini, guepʉ mí thąnde ra Júpiter yʉ ją'i. Nu'a ra mbäją nɛ'ʉ 'da yʉ ją'i bá si yʉn dąni guepʉ 'bʉh ra Pablo nɛ ra Bernabé, ɛ̨mbi ra Mercurio nɛ ra Júpiter, gue da hyo yʉn dąni da mbøspe. Nɛ bá cą yʉ døni, gätho da mbøspe. ");
INSERT INTO otmNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pɛ nu'bʉ mí bąh ra Bernabé nɛ ra Pablo 'bɛ'a i nde da 'yøt'ʉ yʉ ją'i, bi yʉrpʉ 'bʉh yʉ ją'i, bi dʉn yʉ́ pahni, ndepe da bąh yʉ ją'i hingui numanho 'bɛ'a nde da 'yøt'ʉ, nɛ bi 'yɛ̨mbi: ");
INSERT INTO otmNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―N'yohʉ ahʉ hanja ngubʉ gní 'yøthʉ. Nguetho dyʉ́n 'yohʉ thoho'be, pɛ bá ɛ̨'be ua gue dín nde ga xi a'be gui 'yɛs'hʉ 'bɛ'a guí øthʉ, nguetho säti thoho 'bɛ'a guím bɛ̨mhbʉ. Nde'bʉ gui 'yɛs'hʉ gní thąndehʉ ʉ guí ɛ̨mfʉ yʉ oją ua ja ra häi, nɛ gui thąndehʉ majuąni Oją. Nguetho gue'a bi 'yøt' mahɛ̨ts'i nɛcua ja ra häi nɛ ra deją nɛ gätho i ja ua. ");
INSERT INTO otmNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nu'ʉ yʉ pa bi thogui, Oją bi hyɛtho yʉ ją'i da 'yøzɛhɛ yʉ́ pähä zɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pɛ nu Oją bʉya ząi i urcahʉ rá hogan 'yomfɛ̨ni i ørcahʉ, gue bí pɛnh ra 'ye nɛ di japi din ja ma huąhihʉ, nɛ di 'dajʉ 'bɛ'a dí sihʉ nɛ di 'dajʉ ran johya ma mbʉihʉ, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Madague'bʉ ngubʉ mí man ra Pablo, pɛ xʉn hɛ̨i bʉ í hɛcpa yʉ ją'i gue hin da mbøspe. ");
INSERT INTO otmNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pɛ bi zøm bʉ 'da yʉ judío bá nɛxpʉ ra hnini Antioquía bʉ ja ra häi Pisidia, nɛpʉ Iconio, nɛ nu'ʉ bi parba yʉ ją'i da zʉh ra Pablo nɛ ra Bernabé. Nu yʉ ją'i bʉya bi bat'ado ra Pablo nɛ bi gʉrpʉ häi, bi hyøn'a thi bʉ ja ra hnini, nɛ ɛ̨mbi gue ya bi du. ");
INSERT INTO otmNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pɛ nu'bʉ mí zøh yʉ 'yɛ̨c'yɛi bʉ 'bɛn'a ra Pablo, bi ndants' pʉya, nɛ bi mba mahøn'a bʉ ja ra hnini. Nu'bʉ mí hyax bʉya bi mbɛ ra Bernabé bʉ ja ra hnini Derbe. ");
INSERT INTO otmNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nubʉ ja ra hnini Derbe bi mamp'a rán ho ma'da'yo ra Cristo, nɛ xʉn ngu bi 'yɛ̨c'yɛi. Nɛ nubʉya, nu ra Pablo nɛ ra Bernabé bá nɛxpʉ, bi thoh mahøn'a bʉ ja yʉ hnini Listra nɛ Iconio nɛpʉ Antioquía bʉ ra häi Pisidia. ");
INSERT INTO otmNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Guepʉ bi thoqui bi hąt ra ts'ɛdi yʉ́ mbʉi yʉ 'yɛ̨c'yɛi, nɛ bi xifi di thocta a dí 'yɛ̨c'yɛi, nguetho gätho to'o da yʉrpʉ di manda rá ts'ɛdi Oją, jatho da nu xʉn ngu yʉn ʉnbi. ");
INSERT INTO otmNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nɛ nubʉya nu ra Pablo nɛ ra Bernabé bi 'yɛ't' yʉ́n ts'ihmɛ 'bʉ mí huan'dʉ din ngʉrpi n'da ngu n'da bʉ ja yʉm pɛti. Nɛ bi 'yäp Oją ngue da mbäx'ʉ yʉ ngʉrpi. Nɛ bi däp'a Oją ʉ gätho na ngu ʉ yʉ 'yɛ̨c'yɛi gue di jamansu, nguetho bi 'yɛ̨c'yɛi Oją ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nɛ nubʉya ra Pablo nɛ ra Bernabé bi thopʉ ra häi Pisidia nɛ bi zøm bʉ ra hnini Perge nubʉ ra häi Panfilia. ");
INSERT INTO otmNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nɛ guepʉ bi mamp'a rán ho ma'da'yo ra Cristo. M'bɛjua bʉya bi mba bʉ ra hnini Atalia. ");
INSERT INTO otmNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Guepʉ bi hyu ra barco bi mba bʉ Antioquía bʉ ra häi Siria, guepʉ ra mbʉdi xí un Oją yʉ́ 'bɛfi ʉ, nɛ xí t'äp rám fäts'i Oją ʉ. Nɛ nuya bi juah ya. ");
INSERT INTO otmNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nu'bʉ mi zøm bʉ, bi ma dim pɛti yʉ 'yɛ̨c'yɛi, nɛ bi xifi gätho bi 'yøt'e ngue bi zɛ'a Oją, nɛ bi xifi nɛ'ʉ hing yʉ judío bi jap Oją bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nɛ nu ra Pablo nɛ ra Bernabé, nya'a bim 'bʉhmbʉ yʉ 'yɛ̨c'yɛi bʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nu'ʉ yʉ pa ʉ bi zøm bʉ Antioquía 'da yʉn 'yohʉ bi nɛxpʉ ra häi Judea. Nɛ sä bi xi'ʉ yʉ 'yɛ̨c'yɛi hing yʉ judío ngue hingui sä dim pø'a n'da 'bʉ hinga nthɛqui yʉ́ xifani, tengu bi xänba ra Moisés ʉ yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nu ra Pablo nɛ ra Bernabé nts'ɛdi bin junthʉ ʉ, janangue'a bi t'ɛ̨mbi da mba bʉ Jerusalén, nɛ'ʉ mi'da yʉ 'yɛ̨c'yɛi, din yąhʉ bʉ yʉ́ 'bäihʉ ra Cristo nɛ'ʉ mi'da yʉ ngʉrpi bʉ, nangue 'bɛ'a bi man'ʉ yʉn 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Janangue'a nu'ʉ yʉ 'yɛ̨c'yɛi bʉ Antioquía bin 'yɛ̨hmbʉ bʉya, bi mbɛnpʉ ja ra 'yu ʉ. Nɛ nu'bʉ mi hyąx ra 'yu ní mba Jerusalén, bi thopʉ ja ra häi Fenicia nɛpʉ ra häi Samaria. Nɛ nubʉ bi thogui, bi xih yʉ 'yɛ̨c'yɛi ngue bi hyɛ'ʉ yʉ́ t'ɛ̨c'yɛi zɛhɛ ʉ hing yʉ judío, nɛ bi dɛn ra Cristo. Nɛ nu'bʉ mí 'yø'ʉ yʉ cu nangue ra Cristo 'bɛ'a bi man ra Pablo, bin johya bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nu ra Pablo nɛ ra Bernabé nɛ'ʉ mín 'yohʉ bʉya, bi zøm bʉ Jerusalén. Nɛ nu yʉ́ 'bäihʉ ra Cristo nɛ'ʉ mi'da yʉ ngʉrpi mi 'bʉpʉ, nɛ gätho mi'da yʉ 'yɛ̨c'yɛi, bin johya 'bʉ mín nu'ʉ, nɛ bim pɛtihʉ. Nɛ nu ra Pablo nɛ ra Bernabé bi ma gätho 'bɛ'a bi 'yøt'e, ngue bi zɛ'a Oją 'bʉ mí xi'ʉ hing yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pɛ 'da'ʉ yʉ judío, yʉ fariseo ʉ ngue mí ɛ̨c'yɛi, bim 'bäi nɛ bi 'yɛ̨na: ―Jatho da mba nthɛqui yʉ́ xifani yʉ 'yɛ̨c'yɛi gue hing yʉ judío, nɛ da sifi da 'yøt' yʉ́n t'ɛ̨di ra Moisés, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nu'ʉ yʉ́ 'bäihʉ ra Cristo bʉya, nɛ'ʉ mi'da yʉ ngʉrpi, bim pɛti ngue bin 'yän'dʉ 'bɛ'a man'da xʉn ho da 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nɛ nu'bʉ nya'a thoho madín 'yomfɛ̨ni ʉ, bim 'bä'a ra Pedro, nɛ bi 'yɛ̨na: ―N'yohʉ ahʉ, guí pąhmbʉ gue maya'bʉ ts'ʉ bi xicä Oją n'dandį gue ga xi'ʉ 'da yʉ ją'i hing yʉ judío ran ho ma'da'yo. Nɛ nangue dá mangä, bi zä bi 'yøde nɛ bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nu Oją gue i pąrpa yʉ́ mbʉi yʉ ją'i, bi jajʉ ga pąhmbʉ i sin'ʉ hing yʉ judío, nguetho bi un rá Hogandąhi Oją ʉ, tengu bi 'dajʉ dyʉ judíohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nu Oją him bi 'yøt'a n'da ran heque nanguejʉ dyʉ judíohʉ nɛ'ʉ hing yʉ judío, pɛ nɛ'ʉ bi japi bi bo yʉ́ mbʉi ngue bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nuya hanja guí ɛ̨mhbʉ hin da zin Oją ʉ gue him bi 'yøt' yʉ́n t'ɛ̨di ra Moisés, pɛ ya bi zin Oją ʉ. Nguetho guí ɛ̨mhbʉ i jatho da 'yøt'ʉ yʉn t'ɛ̨di, tengu'bʉ gui hyøspahʉ n'da ra 'bɛni, gue hin dá häthʉ, xínga gue'ʉ mam bombøtahʉ xtá hyät'i, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nɛ xø bi 'yɛ̨na: ―Pɛ nujʉ dí ɛ̨c'yɛihʉ ngue da mba ma pøhøgähʉ nangue rá mate ra Hmu Jesús, ngutho'ʉ hing yʉ judío, bi 'yɛ̨n'a ra Pedro. ");
INSERT INTO otmNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nɛ nubʉya bi yą ra Bernabé nɛ ra Pablo, nɛ bi xi'ʉ 'bɛ'a gätho bi 'yøt'e nangue rá ts'ɛdi Oją, yʉ hmɛpya nɛ yʉn t'øt'e nuįxte ngue bi 'yørpʉ 'bʉh yʉ ją'i hing yʉ judío. Nɛ gätho ná yą'ʉ njom bin yą. ");
INSERT INTO otmNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nu'bʉ mí gua'a bi ma ra Pablo nɛ ra Bernabé, nu ra Jacobo Santiago bi 'yɛ̨mp'ʉ madim pɛti bʉ: ―N'yohʉ ahʉ gui 'yøhmbʉ ya 'bɛ'a dí mangä. ");
INSERT INTO otmNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nu ra Simón Pedro ya bi xijʉ ha ín ja Oją ra mbʉdi bi huahn'ni 'da yʉ ją'i hing yʉ judío ngue da 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nɛ ngutho bi man yʉ pøngahyą 'bʉ maya'bʉ, 'bʉ mi 'yo't'i 'bɛ'a bi man Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bi 'yɛ̨na: M'bɛjua gua pengä mahøn'a, nɛ ga japi din thąndegui mahøn'a tengu mi thąndegui nu'bʉ mí 'bʉh ra David. Tengutho 'bʉ di hoc mahøn'a n'da ra niją gue xʉn yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nɛ gätho mi'da yʉ ją'i da hyongui, guecä dra Hmu mahɛ̨ts'i. Gätho to'o yʉ ją'i hing yʉ judío ngue ma mbɛti ʉ, da hyongui. ");
INSERT INTO otmNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Njabʉ bi man Oją maya'bʉ nɛ bi japi bi fąhya gue'bʉ go maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Janangue'a dí xi ahʉ ya, ɛ̨n'a ra Jacobo, nde'bʉ hin te ga xihmbʉ da 'yøt'a xʉn hɛ̨i ʉ hing yʉ judío, gue nu'ʉ xí hyɛsɛ yʉ́ t'ɛ̨c'yɛi nɛ i tɛn'na Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pɛ ga othʉ n'da ra søcuą, nɛ ga xihmbʉ ʉ da hyɛgui gätho yʉ́n t'øt'e yʉ hmite, nɛ hin da 'yøt' yʉn 'yomt'ɛ̨ni, nɛ hin da za ra ngø gue him bi bøn rá ji 'bʉ mí tho, nɛ hin da zi ra ji. ");
INSERT INTO otmNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Janangue'a hin di ʉnba yʉ́ mbʉi to i tɛn yʉ́n t'ɛ̨di ra Moisés, nguetho xʉn ngu yʉ jɛya xí thogui i hmam bʉ ja yʉ́ niją yʉ judío yʉ́n t'ɛ̨di ra Moisés, gätho yʉ hnini i hma 'bʉ ra pa ran ts'äya, bi 'yɛ̨n'a ra Jacobo. ");
INSERT INTO otmNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Gätho yʉ 'yɛ̨c'yɛi nɛ yʉ́ 'bäihʉ ra Cristo nɛ mi'da yʉ ngʉrpi bi numanho 'bɛ'a bi man'a ra Jacobo. Nɛ mi ɛ̨n'ʉ gue da thanh'ni 'da da 'bɛhni da mbähä ra Pablo nɛ ra Bernabé bʉ Antioquía. Nɛ bi thanh'na ra Judas t'ɛ̨mbi Barsabás nɛ ra Silas, nɛ gue'ʉ 'da yʉ́ ngʉrpi yʉ 'yɛ̨c'yɛi ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nɛ nu ra søcuą ngue bi gąts'i bi ma: “Nugähe, ma 'bäigähe a ra Jesucristo, nɛ mi'da gähe gue dyʉ́ ngʉrpigähe, nɛ gätho ni cuje nangue ra Cristo, dí pɛn'nahʉ ra søcuą, ma cu ahʉ, nɛ dadí zɛngua ahe. Dadín cuhʉ nangue ra Cristo gyʉ ją'ihʉ ngue hin gyʉ judíohʉ guí 'bʉhmbʉ bʉ Antioquía, nɛpʉ gätho ra häi Siria nɛpʉ ra häi Cilicia. ");
INSERT INTO otmNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nugähe dá øhmbe ngue 'da yʉn 'yohʉ bi nɛxua bi mba bʉ, nɛ bi pat'ahʉ nɛ bi xi ahʉ ngue jatho da mba nthɛqui ni xifanihʉ nɛ gui 'yøthʉ rán t'ɛ̨di ra Moisés. Pɛ nu'ʉ hin dá pɛnhdähe ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nugähe dám pɛtihe nɛ dá sänhde 'da yʉn 'yohʉ da mbähä ra Pablo nɛ ra Bernabé. ");
INSERT INTO otmNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nu ra Pablo nɛ ra Bernabé ɛ̨mmɛ dí numanhohe, nguetho hingui su din 'yo bʉ hapʉ ɛ̨na da tho, ngue da ma nangue ma Hmuhʉ ra Jesucristo. ");
INSERT INTO otmNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nɛ dá pɛnhde ra Judas nɛ ra Silas da xi'asɛhʉ 'bɛ'a dá othe. ");
INSERT INTO otmNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nguetho rá Hogandąhi Oją bi xije, nɛ dá numanhohe, ngue hin ga 'da ahʉ mi'da yʉn t'ɛ̨di xʉn hɛ̨i gui 'yøthʉ nangue yʉ́n t'ɛ̨di ra Moisés. Hønt' ya zʉ ts'ʉ yʉn t'ɛ̨di dá ot'ahe. ");
INSERT INTO otmNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nuya dí xi ahe ya, ngue hin gui sihʉ 'bɛ'a bi 'bøspa yʉ hmite, xínga gue ra ji gui sihʉ, xínga gue gui sahʉ ra ngø gue him bi bøn ra ji 'bʉ mi tho. Nɛ hin gui 'yøthʉ yʉn 'yomt'ɛ̨ni. Nu'bʉ gui hyɛhmbʉ gätho 'bɛ'a dí xi ahe, xʉn ho 'bʉ. Oją da mbäx ahʉ. Nɛ hønt'a dí xi ahe ya,” bi 'yɛ̨n'a ra søcuą bi 'yo't'a ra Jacobo Santiago 'bʉ mi ja ram pɛti bʉ Jerusalén, bi gąx ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nɛ nubʉya, bi mbähä ra Pablo, ra Bernabé, nɛ ra Judas, nɛ ra Silas bʉ ja ra hnini Antioquía. Nu'bʉ mí zøm bʉ, bi ma dí pɛti yʉ 'yɛ̨c'yɛi nɛ bi dä ra søcuą bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nɛ nu'bʉ mí nu'ʉ 'bɛ'a mí mam bʉ ja ra søcuą, bin johya yʉ́ mbʉi nangue ran zofo bi sifi, ngue bi hyurpa yʉ́ mbʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nu ra Judas nɛ ra Silas, nɛ'ʉ, yʉ pøngahyą ʉ. Nɛ nangue rán zofo ʉ bi hyurpa yʉ́ mbʉi yʉ 'yɛ̨c'yɛi. Nɛ bi mbäts'i da 'yɛ̨c'yɛi xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nu ra Judas nɛ ra Silas bim 'bʉpʉ Antioquía 'da yʉ pa. M'bɛjua bin 'yɛ̨te yʉ 'yɛ̨c'yɛi, bi mbɛhni da mbeng bʉ 'bʉ'ʉ ngue bá pɛnh'dʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nɛ m'bɛjua him bi nde bi mbeng bʉ ra Silas, nɛ bá copʉ Antioquía. ");
INSERT INTO otmNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nɛ ra Pablo nɛ ra Bernabé bi gopʉ Antioquía. Nu'ʉ nɛ'ʉ gätho mi'da yʉ xänbate bin xänbate bʉ, nɛ bi mamp'a rám Hman ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nu'bʉ mí tho'i 'da yʉ pa, ra Pablo bi 'yɛ̨mp'a ra Bernabé: ―Ga mbɛ bʉ ja n'da ngu n'da yʉ hnini xtán 'youi xtám mammi rám Hman Oją. Ga nuui ma cuhʉ nangue ra Cristo 'bɛ'a di ja'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nu ra Bernabé bi nde da zix'a ra Xuua Marcos. ");
INSERT INTO otmNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pɛ nu ra Pablo him mi nde da zix'a, nguetho nu'a bi 'dapʉ Panfilia, nɛ him bi thoc rá 'bɛfi bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nɛ hinga 'da'angu bi bɛ̨mmi nɛ bin heque. Nu ra Bernabé bi zix'a ra Marcos bi hyu ra barco í mba bʉ ra t'ʉhäi Chipre. ");
INSERT INTO otmNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nu ra Pablo bi huanh'na ra Silas ngue da mbɛ. Nɛ nu yʉ 'yɛ̨c'yɛi bʉ Antioquía bin yąhʉ Oją, bi 'yäp rá mate Oją nangue'ʉ. Bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nɛ nu'ʉ bi thopʉ ra häi Siria nɛpʉ Cilicia, nɛ nya'a ts'ʉ bim 'bʉpʉ hapʉ bi thogui, gue bi hąt ra ts'ɛdi xʉn ho yʉ 'yɛ̨c'yɛi bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nu ra Pablo nɛ ra Silas bi mba bʉ ra hnini Derbe nɛpʉ Listra. Nɛ bin tįmhbʉ bʉ n'da ra 'yɛ̨c'yɛi, ra Timoteo na. Nu rá mbe ra judío, nɛ ra 'yɛ̨c'yɛi a, pɛ nu rá ta, ra mɛngu bʉ Grecia a. ");
INSERT INTO otmNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nu yʉ 'yɛ̨c'yɛi bʉ Listra nɛpʉ Iconio bi mamanho nangue ra Timoteo. ");
INSERT INTO otmNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Nɛ nu ra Pablo bi nde din 'youi a, janangue'a bi hyɛcpa rá xifani, gue hin di ʉ't' yʉ́ mbʉi yʉ judío. Nguetho gätho yʉ judío 'bʉpʉ i pądi ngue rá ta ra mɛngu bʉ Grecia a. ");
INSERT INTO otmNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nɛ gätho yʉ hnini bʉ bi thogui bi xih yʉ 'yɛ̨c'yɛi da 'yøt'e 'bɛ'a bi man ra Jacobo nɛ yʉ́ 'bäihʉ ra Cristo nɛ yʉ́ ngʉrpi yʉ 'yɛ̨c'yɛi bʉ Jerusalén, ngue 'bɛ'a xʉn ho da 'yøt'ʉ hing yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nɛ gätho yʉ 'yɛ̨c'yɛi bi thoctatho bin te yʉ́ mbʉi nangue 'bɛ'a bi 'yɛ̨c'yɛi. Nɛ mpa 'bʉ mpa 'bʉ man'da i hux'a ná ngu yʉ 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nu'ʉ bi thocpʉ ra häi Frigia nɛpʉ ra häi Galacia bʉya, nguetho him bi jap'a rá Hogandąhi Oją xtá man ram hma bʉ ra häi Asia. ");
INSERT INTO otmNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nu'bʉ mi zøm bʉ ra häi Misia ɛ̨na xtá mba bʉ ra häi Bitinia, pɛ nu rá Hogandąhi Oją xínga guepʉ bi japi da mba bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bi thorpʉ ja ra häi Misia bʉya, bi mba bʉ ra hnini Troas bʉ ndendeją. ");
INSERT INTO otmNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nɛ nubʉya nu ra Pablo bi nu n'da ran t'uti 'bʉ mín xui, tengu'bʉ ra t'į, ɛ̨na gue'bʉ n'da ran 'yohʉ ra mɛngu Macedonia mí 'bäpʉ ja rá hmi, nɛ bi 'yɛ̨mbi: “Ba ɛ̨cua ja ra häi Macedonia nɛ gui zɛje ts'ʉ,” bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nɛ nugä dra Lucas, dí o't'ä ra søcuą i ja ua, dín nde ga mbähmbe bʉ ra Pablo. Nɛ nangue'a bi t'ut'a ra Pablo, janangue'a 'bex dán sähe ga mbähmbe bʉ ja ra häi Macedonia, nguetho dá hąxhe njuąni ngue'a Oją bi zoncähe bʉ, in ndeje ga mamhbe bʉ ran ho ma'da'yo dí yąnjʉ a. ");
INSERT INTO otmNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nu'bʉ má pømhbe bʉ Troas dá huhe n'da ra barco nɛ njuąntho dá uɛ̨nthe bʉ ja ra t'ʉhäi Samotracia gue i jabʉ made ra deją. Nu'bʉ mi hyats'i dá thohmbe bʉ Neápolis. ");
INSERT INTO otmNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Dá nɛxhe bʉ Neápolis bʉya nɛ dá sømhbe bʉ ra dąhnini Filipos, rán guat'i ra häi Roma. Nu ra hnini Filipos man'da ja rá ts'ɛdi xinda gue mi'da yʉ hnini bʉ ra häi Macedonia. Nɛ dám 'bʉhmbe bʉ 'da yʉ pa. ");
INSERT INTO otmNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nɛ nu'bʉ ra pa ran säya dá pømhbe bʉ ja ra hnini, dá mbähmbe bʉ ja ra ndendąthe guepʉ ząnt'a min yąhʉ Oją yʉ ją'i. Nɛ dá huhmbe bʉ, dá xihmbe rám Hman Oją ʉ yʉ xisu ngue madím pɛti bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nɛ nu n'da ra xisu í Lidia ra mɛngu bʉ Tiatira, bi 'yøde 'bɛ'a dá mamhbe. Nu'a ra Lidia ra mbä'bø't'e na, i pä ra 'bø't'e xʉn jʉpoi ngue xʉn ho. Nu'a i ɛ̨c'yɛi nɛ mi numansu Oją, janangue'a bi xocua rá mbʉi da 'yøde xʉn ho 'bɛ'a bi man'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nu ra Lidia bin xixyą bʉya nɛ gätho 'bʉpʉ rá ngu. M'bɛjua bi xicähe: ―Nu'bʉ guí ɛ̨na majuąni dí ɛ̨c'yɛi ra Hmu mahɛ̨ts'i, ba ɛ̨hmbʉ ua ja ma ngu gam 'bʉhmbʉ ua 'da yʉ pa, bi 'yɛ̨nje. Nɛ bi 'yørcahe ts'ɛdi janangue'a dá mbähmbe. ");
INSERT INTO otmNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","N'da ra pa nu'bʉ má mbähmbe bʉ ząi bi yąhʉ Oją yʉ ją'i, dán c'athe n'da ra hmute ra 'yɛ̨hɛ. Nu'a man ra 'yøde nangue ra zįthu min 'youi, nɛ mí tąha xʉn ngu ra mbɛti di un'dʉ yʉ́ hmu. ");
INSERT INTO otmNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nu'a ra hmute mi tɛn'na ra Pablo nɛcähe. Bi mbafi bi 'yɛ̨na: ―Nuya yʉn 'yohʉ, yʉ́ mbɛfi Oją nuįxte thoho, i xängahʉ hague dán zä dam pøhmbʉ, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nɛ xʉn ngu yʉ pa ngubʉ mi øt' ra hmute. Madí xømbʉi ra Pablo nɛ bi xi'a ra zįthu min 'youi ra hmute: ―Nangue rá thuhu ra Jesucristo dami pøm bʉ rá mbʉi na ra hmute, bi 'yɛ̨mbi. 'Bexque bi bøn ra zįthu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nu'bʉ mí pąh yʉ́ hmu ra hmute gue him man zä da dąp rán zäbi, bi bɛnt'a ra Pablo nɛ ra Silas, nɛ bi zixpʉ ja ra täi guepʉ 'bʉh yʉ zɛ'mi. ");
INSERT INTO otmNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nɛ nu'bʉ mi dä bʉ 'bʉh yʉ zɛ'mi, bi 'yɛ̨n'ʉ: ―Nuya yʉn 'yohʉ 'bʉcua, yʉ judío ya. Nɛ in nde di ts'on yʉ ją'i 'bʉcua ja ma hninihʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nɛ i man yʉn t'øt'e gue hingui sä ga øthʉ, nguetho nujʉ dyʉ romanohʉ. Nɛ hin'yʉ man t'ɛ̨di ga øthʉ a i xijʉ, sä bi 'yɛ̨n'ʉ yʉ yąpate. ");
INSERT INTO otmNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nɛ bi munts' yʉ ją'i ngue nde da zʉ'ʉ. Nu yʉ zɛ'mi bʉya, bi manda da 'bøcua yʉ́ pahni, da mba m'bɛi ra Pablo nɛ ra Silas. ");
INSERT INTO otmNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nɛ nu'bʉ mi juadi ngue ɛ̨mmɛ xí 'bɛi, bi mba njot'i bʉ ja ra fädi. Nɛ bi sih ra mbängoxthi da mbädi xʉn ho. ");
INSERT INTO otmNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nu'bʉ min t'un ran t'ɛ̨di ra mbädi bi zixpʉ man'da mbo. Nɛ bi zɛmba yʉ́ gua bʉ ja ra fädiza. ");
INSERT INTO otmNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nu'bʉ mi zøm made ra xui bʉya, nu ra Pablo nɛ ra Silas min yąhʉ Oją nɛ bin tuh yʉ́ thuhu Oją. Nɛ gätho mi'da yʉ ofädi mi øde. ");
INSERT INTO otmNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nɛ 'dahmantho 'bʉ mi mbʉdi bin ja n'da ra 'yąnhäi, gue'bʉ go mi guhni yʉ́ guangu ra fädi. Gätho yʉ jut'i bin xozɛhɛ nɛ gätho yʉ t'ɛgui man thąt'i yʉ ofädi bin xozɛhɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nɛ nu'bʉ mi nuh rá mbängoxthi ra fädi, bi nu gätho nsoqui yʉ goxthi, bi gʉx rá juai bʉya gue nde xtín hyosɛ, nguetho mim bɛ̨ni ngue ɛ̨mbi gätho xí 'da'ʉ yʉ ofädi. ");
INSERT INTO otmNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pɛ nu ra Pablo nts'ɛdi bi mba't'i, bi 'yɛ̨mbi: ―O gadín ʉnba zɛhɛ nguetho gätho dí 'bʉcähe ua. ");
INSERT INTO otmNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nɛ nu'a ra mbängoxthi bʉya bi 'yä'a n'da ra sibi, bi yʉrpʉ mbo, nɛ ɛ̨mmɛ di fɛt'i nguetho min su. Nɛ bi yørpʉ ja rá gua ra Pablo nɛ ra Silas. ");
INSERT INTO otmNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nɛ bi gʉcpʉ thi ʉ, nɛ bi 'yänni: ―N'yohʉ aui 'bɛ'a sä ga øt'ä nguepʉ da zä dam pøcä, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nu ra Pablo nɛ ra Silas bi 'yɛ̨mbi: ―Dami däp ni mbʉi ra Hmu, ra Jesucristo, di pun'na ni ts'oqui, nɛ da zimanho i, nɛ'ʉ gätho 'bʉpʉ ni ngu, 'bʉ di däp yʉ́ mbʉi a, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nubʉya bi xih rán ho ma'da'yo ra Cristo nɛ gätho 'bʉpʉ rá ngu. ");
INSERT INTO otmNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nɛ nu'a ra mbängoxthi nɛ gätho 'bʉpʉ ja rá ngu bin xixyą a ra xui a. ");
INSERT INTO otmNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nu'a ra mbängoxthi bʉya bi zix'a ra Pablo nɛ ra Silas bʉ ja rá ngu, nɛ bi 'uįni. Nɛ'a, nɛ gätho 'bʉpʉ ja rá ngu ɛ̨mmɛ bin johya nguetho bi 'yɛ̨c'yɛi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nu'bʉ mí hyats'i, nu'ʉ yʉ zɛ'mi bi mbɛnh'dʉ yʉ asmayo da xih ra mbängoxthi da bøm bʉ ja ra fädi ra Pablo nɛ ra Silas. ");
INSERT INTO otmNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nɛ nu'a ra mbängoxthi bi xi'a ra Pablo bʉya: ―Nu yʉ zɛ'mi bá pɛnh ra nde ga xoc'aui. Nuya sä gui pømmi nɛ nte gui jaui, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pɛ nu ra Pablo bi 'yɛ̨mbi: ―Nugä'be dí cą'be ran t'ɛ̨di bi bøm bʉ Roma, pɛ guehma bi 'bɛnzagä'be bʉ 'bʉh yʉ ją'i, nɛ him 'bɛ bi juąngä'be pɛ bi goctä'be. Nuya ha ɛ̨n'ʉ gui jʉgä'be ngue njon da nu. Hin'na, hingui sä. Bá xifi ba ɛ̨sɛ da xogä'be, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nu yʉ asmayo bʉya bi mba bi xih yʉ zɛ'mi 'bɛ'a bi ma ra Pablo. Nu yʉ zɛ'mi nu'bʉ mi 'yøde ngue i cą yʉn t'ɛ̨di bʉ Roma a ra Pablo nɛ ra Silas bʉya, ɛ̨mmɛ bin su. ");
INSERT INTO otmNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nɛ nu'bʉ bá ɛ̨h yʉ zɛ'mi bʉya, bi xocuabi nɛ bi 'yäp ra punbi, nɛ bi xi'ʉ: ―'Yørcahe ra mate gui pømmi ua ja ra hnini, bi 'yɛ̨mbi. ");
INSERT INTO otmNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɛ nu ra Pablo nɛ ra Silas 'bʉ mí bøm bʉ ja ra fädi, bi mba bʉ ja rá ngu ra Lidia. Nɛ nu'bʉ mi nu yʉ cu nangue ra Cristo, bi hąt ra ts'ɛdi yʉ́ mbʉi ʉ, nɛ bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nu'a ra Pablo nɛ ra Silas bi thopʉ ja ra hnini Anfípolis nɛpʉ Apolonia nɛ bi zøm bʉ ja ra hnini Tesalónica. Guepʉ Tesalónica bí ja bʉ n'da rá niją yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nɛ nhyu semana bim 'bʉpʉ, nɛ nu'bʉ xʉn dät yʉ pa ran säya, bi mam bʉ rám Hman Oją a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nɛ jante thoho bi xifi xʉn ho nangue ram hma mán t'o't'i maya'bʉ, gue gue'a ra Cristo jatho da nu ran ʉnbi nɛ da du, nɛ m'bɛjua da ndants' mahøn'a bʉ 'bʉ'ʉ xʉn du. ―Nɛ gue'a bi nu ra Jesús a mán t'o't'i tengu dí xi ahʉ, janangue'a ga pąhmbʉ gue gue'a ra Cristo rá Thahni Oją a, bi 'yɛ̨m 'bʉ mi xänbi. ");
INSERT INTO otmNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nɛ nu'ʉ 'da yʉ judío bi däp yʉ́ mbʉi ra Cristo, nɛ bi dɛn'na ra Pablo nɛ ra Silas. Nɛ ɛ̨mmɛ xʉn ngu yʉ mɛngu bʉ Grecia ngue mi numansu Oją bi 'yɛ̨c'yɛi. Nɛ xʉn ngu yʉ xisu yʉ mɛngu bʉ grecia gue mí hnumansu, bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pɛ 'da yʉ judío ngue him mí ɛ̨c'yɛi bin sɛya, nɛ bi zonh'nʉ yʉ ts'om'bäi bi xifi di parba yʉ ją'i, asta gue'bʉ gätho ra hnini bi parbi. Nɛ nu'ʉ bi mba bʉ rá ngu ra Jasón, bi 'uɛ̨xpa bʉ rá ngu, i hon'a ra Pablo nɛ ra Silas, ɛ̨na da gʉqui gue di dä bʉ 'bʉh yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nɛ nu'bʉ him mi dįn ra Pablo nɛ ra Silas, bi zix'a ra Jasón, nts'ɛdi bi gʉts'i, nɛ mi'da yʉ 'yɛ̨c'yɛi, bi zixpʉ 'bʉh yʉ zɛ'mi bʉ ja ra hnini. Bi mbafi nɛ bi 'yɛ̨na: ―Guehna n'dat'a mbɛ̨mhbʉ ʉ yʉn 'yohʉ gue ya bi ts'oni gätho ra ximhäi, nɛ bi zøcua ya. ");
INSERT INTO otmNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Nɛ nuna ra Jasón bi säyaba bʉ rá ngu. Nɛ nu'ʉ hingui numansu rán t'ɛ̨di ma ts'ʉt'abihʉ bʉ Roma, nguetho ɛ̨n'ʉ i 'bʉh man'da ra ts'ʉt'abi guehna ra Jesús, bi 'yɛ̨n'ʉ yʉ ts'om'bäi. ");
INSERT INTO otmNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nu yʉ ją'i nɛ yʉ zɛ'mi bin cuɛ 'bʉ mí 'yøde 'bɛ'a bi man'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nɛ nubʉya nu ra Jasón nɛ'ʉ mi'da bi thącua ra mbɛti gue da bøm bʉ ja ra hnini ra Pablo nɛ ra Silas, nɛ bi mba ma thøgue bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","'Bexque guet'a ra xui a bin 'yɛ̨hmbʉ yʉ 'yɛ̨c'yɛi a ra Pablo nɛ ra Silas. Bi mba bʉ ja ra hnini Berea. Nɛ nu'bʉ mí zøm bʉ, bi mba bʉ ja rá niją yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nu yʉ judío gue 'bʉpʉ, man'da xʉn ho yʉ́ mbʉi xinda gue'ʉ 'bʉpʉ Tesalónica. Nguetho 'bexque bi xoc yʉ́ mbʉi, mí ja ra pähä ngue da hyąn a bi man ra Pablo. Nɛ gätho yʉ pa bi nɛh yʉ́ søcuą Oją maya'bʉ, ngue nde bʉ da bądi 'bʉ din thɛui ʉ i man'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nɛ xʉn ngu ʉ bi 'yɛ̨c'yɛi. Nɛ yʉ xisu, yʉ mɛngu bʉ grecia, ngue mi hnumansu, xʉn ngu bi 'yɛ̨c'yɛi, ximangut yʉn 'yohʉ bi 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nɛ nu yʉ judío bʉ Tesalónica nu'bʉ mi bądi gue i man ran ho ma'da'yo bʉ Berea a ra Pablo, bi mba bʉ bʉya ngue di parba yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pɛ nu yʉ 'yɛ̨c'yɛi 'bex bi zix'a ra Pablo bʉ ndendeją. Pɛ nu ra Silas nɛ ra Timoteo bi gopʉ Berea. ");
INSERT INTO otmNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nu'ʉ min 'yohʉ ra Pablo bi zixpʉ ja ra hnini Atenas bʉya. Nɛ bi mbeng bʉ, nɛ bi xi'a ra Silas nɛ ra Timoteo gue ra Pablo ndepe da mba bʉ n'dihi bʉ 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nɛ nu'bʉ min dø'mate ra Pablo bʉ Atenas, ɛ̨mmɛ bi du rá mbʉi 'bʉ mín nu gätho ra hnini xí muns' yʉ nyogui. ");
INSERT INTO otmNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Janangue'a nu ra Pablo bin yąhʉ yʉ judío bʉ ja ra niją, nɛ'ʉ mi'da ngue mi thąnde Oją. Nɛ gätho yʉ pa mi yąhʉ yʉ ją'i ngue gätho mi tįm bʉ ja ra täi. ");
INSERT INTO otmNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nɛ'ʉ 'da yʉn 'yohʉ gue i tɛnba yʉ́ t'ɛ̨c'yɛi zɛhɛ yʉ Epicúreos, nɛ mi'da i tɛnba yʉ́ t'ɛ̨c'yɛi zɛhɛ yʉ Estoicos, bin yąhʉ ra Pablo. Nu'ʉ 'da bi ma: ―'Bɛ'a ní mba i man na ra ndemhyą n'yohʉ. Nɛ'ʉ mi'da bi ma, bi 'yɛ̨na: ―Masque im ma ngue 'bʉh mi'da yʉ oją, bi 'yɛ̨n'ʉ. Ngubʉ bi ma nguetho bi man ra Pablo nangue ra Jesús, nɛ bi ma ngue bi ndants' 'bʉ mi du. ");
INSERT INTO otmNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nu'ʉ bi zix'a ra Pablo bʉ ja ra nyuni t'ɛ̨mbi Areópago bʉ ja ra hnini guepʉ ząi i hman yʉn zofo. Nɛ bi xi'a ra Pablo: ―'Bɛ'a ním hma guín nde gui xije, dín nde ga pąhmbe. ");
INSERT INTO otmNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nguetho guí xije 'dan'yo yʉm hma ngue hin dí pąhmbe, nɛ dín nde ga pąhmbe 'bɛ'a nám bøn'a, bi 'yɛn'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nguetho yʉ mɛngu bʉ Atenas nɛ'ʉ mi'da yʉ 'damhnini mí 'bʉpʉ, hønt'a numanho da 'yøt'a, gue da 'yøde 'bɛ'a gue ma' da'yo, nɛ da ma. ");
INSERT INTO otmNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nɛ nu ra Pablo bi 'bä'inde bʉ ja ra junta guepʉ Areópago. Nɛ bi xi'ʉ: ―N'yohʉ ahʉ gyʉ mɛnguhʉ ua Atenas, dá nugä ɛ̨mmɛ guí thąndehʉ yʉ oją. ");
INSERT INTO otmNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nu'bʉ mán 'yogä bʉ ja ni hninihʉ dá nugä 'bɛ'a guí thąndehʉ. Nɛ dá nugä n'da ra mɛxado guepʉ guí thąndehʉ man'da ra Oją, nɛ man t'o't'i bʉ: “Ra Oją ngue njongui pądi to'o a.” Nuya ga xi ahʉ ya nangue ra Oją guí thąndehʉ pɛ hin guí pąhmbʉ to'o. ");
INSERT INTO otmNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nu'a Oją ngue bi 'yøt' ra ximhäi nɛ gätho 'bɛ'a i ja ua, nu'a gue'a ra Hmu mahɛ̨ts'i nɛcua ja ra häi. Nu'a hingui 'bʉpʉ ja yʉ ngu i høh yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nɛ nte di 'bɛdi, hingui jatho da hyąni 'bɛ'a da 'yørpa yʉ ją'i nguetho gue'a di un ra te nɛ di un ran zaqui gätho to'o i 'bʉi. Nɛ gätho mi'da mahyoni di uni. ");
INSERT INTO otmNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nɛ 'dat'a ra ji bi 'yøt' Oją gätho yʉ ją'i ngue gätho yʉ nde, ndepe dim 'bʉi gätho na ngʉni ra ximhäi, nɛ bi zänba yʉ pa dim 'bʉcua ja ra häi, nɛ bi zänbi hapʉ dim 'bʉi. ");
INSERT INTO otmNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Njabʉ bi 'yøt' Oją, ndepe gätho yʉ ją'i da hyon'a Oją nguepʉ da dįni. Pɛ majuąni hinga yatho i 'bʉ Oją 'bʉ ga homhbʉ ga pąhmbʉ a. ");
INSERT INTO otmNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nguetho nu Oją bi jajʉ dám 'bʉhmbʉ, nɛ bi jajʉ dí 'yohʉ, nɛ dadí 'yąmhbʉ. Tengu bi man'i 'da ni 'yosøcuąhʉ nu'bʉ i ɛ̨na: “Nujʉ yʉ́ ją'igähʉ Oją nguetho bi zänni dám 'bʉhmbʉ ua,” bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nu'bʉ gue'a Oją di 'dajʉ ma tehʉ, hanja gní 'yɛ̨mfʉ Oją a ra hmite ra c'axt'i o gue ra t'axi o gue ra do nt'øt'e ngue yʉ́ 'yɛ yʉn 'yohʉ, nangue yʉ́n 'yomfɛ̨nisɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pɛ nu Oją him bi 'yʉrpa ra güɛnda 'bɛ'a mim bɛ̨nsɛ ʉ yʉ ją'i 'bʉ him mi bą Oją mam'bɛt'o. Pɛ nuya Oją bi ma ngue gätho yʉ ją'i di päh yʉ́n 'yomfɛ̨ni. ");
INSERT INTO otmNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nguetho xʉn zän Oją n'da ra pa din ja ran t'änni nangue ra ximhäi. Da 'yøt'ran t'änni xʉn ho n'da ran 'yohʉ ngue bi huanh Oją. Nuna ran 'yohʉ, Oją bi xox 'bʉ mi du, janangue'a da bąh yʉ ją'i hingui hɛ̨i da 'yøt' ran juąnbi, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nɛ nu'bʉ mí 'yø'ʉ yʉ ją'i 'bɛ'a mí man'a ra Pablo, gue bi ndans' 'bʉ mi du, 'da'ʉ bin thennate nɛ 'da'ʉ mí ɛ̨na: ―Ga øhmbʉ mahøn'a nanguehna bi ndants'i. ");
INSERT INTO otmNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nu ra Pablo bi 'uepʉ bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pɛ nu'ʉ 'da bi dɛn'na ra Pablo nɛ bi 'yɛ̨c'yɛi. Nuna n'da, ra Dionisio na, gue n'da ra zɛ'mi bʉ guepʉ madím pɛti yʉ ją'i bʉ Areópago. Nɛ n'da ra xisu, ra Dámaris, nɛ'ʉ mi'da bi dɛn'na ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","M'bɛjua bʉya nu ra Pablo bi bøm bʉ Atenas, bi mba bʉ ra hnini Corinto. ");
INSERT INTO otmNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nɛ bin tįmmi bʉ n'da ra judío í Aquila, ra mɛngu ponto. Ja ní søhø bí 'yɛ̨pʉ Roma bʉ ra häi Italia ra Aquila nɛ rá xisu Priscila, nguetho nu ra hmuts'ʉt'abi Claudio bá høn'a thi gätho yʉ judío bʉ ra dąhnini Roma. Nu ra Pablo bi mba bá nu'a ra Aquila nɛ ra Priscila bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nɛ bin ząm bʉ yʉ́ ngu, nguetho 'dat'a ra 'bɛfi i øt'e, i øt' yʉ ngu'bø't'e. ");
INSERT INTO otmNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nɛ gätho yʉ́ pa yʉn säya mí pa bʉ rá niją yʉ judío a ra Pablo, nɛ bi mam bʉ rám Hman Oją nɛ bi hyoni 'bɛpʉ dí 'yɛ̨c'yɛi yʉ judío nɛ'ʉ hing yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nu'bʉ bá ɛ̨pʉ ra häi Macedonia ra Silas nɛ ra Timoteo, bi nu ra Pablo gue gätho yʉ pa ɛ̨mmɛ mi mam rám Hman Oją. Mí xänba yʉ judío ngue gue'a ra Jesús majuąni ra Cristo mí tø'bʉ yʉ judío ngue din yąnte a. ");
INSERT INTO otmNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pɛ nu yʉ judío bi dʉ'mi bi ʉcpa a, nɛ bi man yʉ ts'ore nangue ra Pablo. Nɛ nu ra Pablo bʉya bi huąc rá pahni, n'da ra hmɛpya gue hingui numanho 'bɛ'a i øt'ʉ. Bi 'yɛ̨mbi: ―Ya ni ts'oqui zɛhɛhʉ ngue hin gá hyąn ra te maząi, tengu'bʉ gán hyosɛhʉ. Nuya hingui pa ma güɛndagä, nguetho ya dá xi ahʉ. Pɛ nuya ga mbagä ga xih yʉ ją'i hing yʉ judío, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nɛ má zä bi bøm bʉ ja rá niją yʉ judío a ra Pablo, bi mba bʉ ja rá ngu ra Justo. Nu'a, n'da ran 'yohʉ ngue i thąnde Oją, nɛ nu rá ngu, 'darpʉ jaui rá niją yʉ judío, nɛ guepʉ din xänbate bʉ mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nu ra Crispo, n'da ra ngʉrpi bʉ ja rá niją yʉ judío, bi 'yɛ̨c'yɛi nɛ gätho 'bʉpʉ rá ngu. Nɛ xʉn ngu yʉ mɛngu corinto mi øh ran ho ma'da'yo, nɛ bi 'yɛ̨c'yɛi, nɛ bi mba ma xixyąbi. ");
INSERT INTO otmNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nu ra Hmu mahɛ̨ts'i bi zo'a ra Pablo bʉya, nu'bʉ min xui, tengu'bʉ bi 'uį n'da ra t'į. Nɛ bi xifi: ―O guín su, pɛ dami thoqui gan yą, hin gan hɛ̨tho, ");
INSERT INTO otmNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nguetho dadí hyʉn'a'i, nɛ njon da zä di ʉn'na'i, nɛ xʉn ngu i 'bʉcua ja ra hnini da 'yɛ̨c'yɛigui, bi 'yɛ̨n Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nubʉya nu ra Pablo bi gopʉ ja ra hnini Corinto n'da jɛya made, nɛ bi xänba rám Hman Oją ʉ yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pɛ nu'bʉ mín ts'ʉt'abi ra Galión nubʉ ra häi Acaya, nu 'da'ʉ yʉ judío bim pɛti ngue nde da zʉ'a ra Pablo. Nɛ bi zix'a ra Pablo bʉ 'bʉh ra ts'ʉt'abi. ");
INSERT INTO otmNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bi 'yɛ̨mbi: ―Nuna ran 'yohʉ na bi xänba yʉ ją'i ngue da dąnde Oją, pɛ n'dan'yo im ma, hinga gue'a tengu man t'ɛ̨dihʉ, ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nɛ nu ra Pablo in nde din yą, pɛ nu ra ts'ʉt'abi ra Galión 'bex bi 'yɛ̨mp'ʉ yʉ judío: ―Nu'bʉ xcuá sihʉ na ran 'yohʉ nangue n'da ran ts'o xtá 'yøt na, xcá øcä a guim mamhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pɛ guín cuɛhʉ nangue rá t'ɛ̨c'yɛi na, ngue nde da xi ahʉ to'o gui thąndehʉ, nɛ nangue nin t'ɛ̨di zɛhɛhʉ. Hin dí nde dan juąnbate nangue nin t'ɛ̨di zɛhɛhʉ, janangue'a dami hocpa zɛhɛhʉ, bi 'yɛ̨n'a ra Galión. ");
INSERT INTO otmNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Bi 'yɛt'i, bi hyøn'a thi bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nubʉya gätho yʉ mɛngu bʉ ja ra hnini gue hing yʉ judío bi bɛnt'a ra Sóstenes, ra ngʉrpi bʉ ja rá niją yʉ judío, nɛ bi 'bɛnza bʉ ja rá hmi ra ts'ʉt'abi. Pɛ nu ra ts'ʉt'abi ra Galión him bi 'yørpamasu. ");
INSERT INTO otmNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nu ra Pablo bʉya bi thoqui bim 'bʉpʉ nya'a ts'ʉ yʉ pa mahøn'a bʉ Corinto. M'bɛjua bí 'yɛ̨'ʉ yʉ 'yɛ̨c'yɛi, bin 'yohʉ ra Aquila nɛ ra Priscila, nɛ bi hyu ra barco bi mba ra häi Siria. Nɛ nu'bʉ mí jua'a ra hmɛpya gue bi te rá xtą, bi 'yąx rá yą bʉya, gue'a bi 'yørpʉ Cencrea. N'da ra hmɛpya nangue ram hma xí man ra Pablo gue bi xi Oją di ją'ts'i. ");
INSERT INTO otmNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nu'bʉ mi zøm bʉ ra hnini Éfeso ra Pablo, bi zopʉ ra Priscila nɛ ra Aquila nɛ bi mba bʉ rá niją yʉ judío. Nɛ bi xih yʉ judío bʉ rán ho ma'da'yo ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nu yʉ judío mi ndepe xtán gopʉ 'da yʉ pa, pɛ nu ra Pablo him bi nde. ");
INSERT INTO otmNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bin 'yɛ̨te nɛ bi 'yɛ̨mbi: ―Jatho ga mba bʉ Jerusalén ga nu bʉ ra dąmpɛti da 'yøt' ma mijudíohʉ. Pɛ nu'bʉ rá pähä Oją gua pengä mahøn'a, bi 'yɛ̨na. Bi nɛxpʉ, bi hyu n'da ra barco bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nubʉ Cesarea bi gąpʉ ra Pablo bʉ ja ra barco, nɛ bi mba bʉ Jerusalén, bi zɛngua yʉ 'yɛ̨c'yɛi bʉ ja ra niją, nɛ 'bex bi mba bʉ Antioquía. ");
INSERT INTO otmNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nu'bʉ mim 'bʉpʉ 'da yʉ pa, bi mba bʉ ja n'da ngu n'da yʉ hnini bʉ ja ra häi Galacia nɛpʉ Frigia, bi hąt ra ts'ɛdi yʉ́ mbʉi yʉ 'yɛ̨c'yɛi 'bʉpʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nu'ʉ yʉ pa ʉ bi zøm bʉ Éfeso n'da ra judío, rá thuhu Apolos, ra mɛngu bʉ ra hnini Alejandría. Nu'a bi bądi xʉn ho rám Hman Oją maya'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nɛ bi sänbi zʉ ts'ʉ nangue ra Hmu, ra Jesucristo. Nɛ ɛ̨mmɛ bin johya nɛ nts'ɛdi bi ma xʉn ho 'bʉ min xänbate, bi ma majuąni nangue ra Jesús. Pɛ hønt'a rám hma ra Xuua Nxixyą mí pądi, nɛ rán xixyą. ");
INSERT INTO otmNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nɛ nu ra Apolos bi hyut'an zambʉi him bi zu bi mam bʉ ja rá niją yʉ judío. Pɛ nu'bʉ mí 'yøh ra Priscila nɛ ra Aquila 'bɛ'a man'a, n'danni bi zits'i nɛ bi xänbi man'da xʉn ho ngue rá 'yu Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nɛ nu'bʉ mí nde da mba ra Apolos ra häi Acaya, guepʉ Corinto, nu yʉ cu nangue ra Cristo bi xifi ngue xʉn ho da mba. Bi 'yørpa n'da ra søcuą da gąts'i, bi xih yʉ 'yɛ̨c'yɛi bʉ ngue da zini. Nɛ nu'bʉ mi zøm bʉ, bi hąt ra ts'ɛdi yʉ́ mbʉi yʉ 'yɛ̨c'yɛi bʉ, nɛ bi mbäts'i gätho bi 'yɛ̨c'yɛi rá mate ra Cristo. ");
INSERT INTO otmNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nguetho nu'bʉ min yąhʉ yʉ judío gue hing yʉ 'yɛ̨c'yɛi, bi dąha, ngue ya mí yą con rá ts'ɛdi Oją. Bi 'yuti nangue rám Hman Oją maya'bʉ, gue gue'a ra Jesús ra Cristo mí hmam bʉ, gue mí tø'bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nu'bʉ mí 'bʉpʉ Corinto ra Apolos, nɛ nu ra Pablo bʉya i 'yo gätho yʉ hnini maxøts'e, nɛ bi zøm bʉ ra hnini Éfeso. Nɛ bin tįmhbʉ bʉ 'da yʉ 'yɛ̨c'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Nu ra Pablo bi 'yän bʉya: ―Ha bin 'da ahʉ rá Hogandąhi Oją nu'bʉ gmí 'yɛ̨c'yɛihʉ, bi 'yɛ̨na. Nu'ʉ bi dąti: ―Hin'na, njąm'bʉ dá øhmbe gue i 'bʉh rá Hogandąhi Oją, bi 'yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nubʉya bi 'yän'na ra Pablo: ―'Bɛ'a ním hma gá hyąmhbʉ 'bʉ gmín xixyąhʉ, bi 'yɛ̨mp'ʉ. Nɛ bi 'yɛ̨n'ʉ bʉya: ―Tengu thoho bi man ra Xuua Nxixyą, bi yɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nɛ nu ra Pablo bi 'yɛ̨mbi: ―Guim bɛ̨mhbʉ 'bɛ'a bi man ra Xuua, nguetho nu'a ra Xuua bi xixyą yʉ ją'i to'o bi päh yʉ́n 'yomfɛ̨ni nangue yʉ́ ts'oqui, nɛ bi xih yʉ ją'i da 'yɛ̨c'yɛi n'da ba ɛ̨hɛ m'bɛjua, gue ra Jesús ra Cristo na, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nɛ nu'bʉ mí 'yøh rám hman ra Pablo, nu'ʉ bi mba ma xixyąbi nangue rá thuhu ra Hmu Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nɛ nu'bʉ mí dospa yʉ́ yą yʉ ją'i ra Pablo, bi hyąn rá Hogandąhi Oją ʉ. Nɛ n'dan'yo yʉ nde bin yą'ʉ bʉya, nɛ bim pøngahyą bi man rám Hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nɛ nu'ʉ yʉ ją'i gue bi 'yɛ̨c'yɛi, í jua'i 'dɛ'mayoho ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nu ra Pablo bim 'bʉpʉ nhyuzna bʉ Éfeso bʉya. Bi hyut'an zambʉi bin yą bʉ ja rá niją yʉ judío, bi xih yʉ ją'i hague dán zä di manda Oją bʉ ja yʉ́ mbʉi, nɛ bi hyoni 'bɛpʉ dí 'yɛ̨c'yɛi yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pɛ nu'ʉ 'da bi ʉ't' yʉ́ mbʉi, hingui nde da 'yɛ̨c'yɛi, nɛ bi man ra ts'ore nangue rá 'yu Oją, guepʉ madím pɛti yʉ ją'i. Janangue'a bi 'ue'a ra Pablo bʉya nɛ bi mbähä yʉ 'yɛ̨c'yɛi bʉ ja n'da ra nguxädi, nu'a ra Tiranno ra xänbate bʉ. Nu'bʉ xʉm pøn yʉ́ xädi, i cʉt'a ra Pablo bʉya nɛ gätho yʉ pa mín xänbate bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nyo jɛya njabʉ bi 'yøt'a ra Pablo. Nɛ gätho yʉ ją'i 'bʉpʉ ja ra häi Asia, yʉ judío nɛ'ʉ hing yʉ judío mí øh ran ho ma'da'yo nangue ra Hmu, ra Jesús. ");
INSERT INTO otmNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nɛ xʉn ngu yʉn t'øt'e nuįxte bi 'yøt'a ra Pablo, ngue bi 'yøt' Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nguetho bi dä'ʉ yʉ bayu o gue yʉ 'bø't'e a ra Pablo, gue'ʉ bi mbɛnpa ʉ yʉn zäman'ʉ bʉya, nɛ gätho bi zä, nɛ bi bøn'ʉ yʉ zįthu min 'yohʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Nubʉya 'da yʉ judío ngue ząi yʉ mbonni, ɛ̨na pądi da hyøn'a thi yʉ zįthu, nɛ sä i ndønpa rá thuhu ra Jesús. Bi dʉ'mi bi xih yʉ zįthu: ―Dami pøni nangue rá thuhu ra Jesús, gue'a ra Jesús i man ra Pablo, sä ɛ̨n'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nɛ nuya guehya yoto, yʉ́ ts'ʉnt'ʉ n'da ra judío, ra Esceva, ra hmumbäją a. Nɛ nu'ʉ yʉ́ ts'ʉnt'ʉ ɛ̨na da hyøn'a thi n'da ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pɛ nu ra zįthu bi dądi: ―Nu ra Jesús dí pącä ngue ja rá ts'ɛdi, nɛ ra Pablo dí pącä ngue ja rá ts'ɛdi, pɛ nu'ehʉ, to'o ehʉ, bi 'yɛ̨n'a ra zįthu. ");
INSERT INTO otmNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nɛ nuna ran 'yohʉ min 'youi ra zįthu, bi zäspa maxøts'e guepʉ mi 'bä'ʉ yoto má 'yohʉ, bi dąha bin tunhdʉ nɛ bi ʉnbi, gätho di dʉnba yʉ́ pahni. Nɛ bi bøm bʉ thi yʉn 'yohʉ, ya xí ʉnbi gätho, nte he yʉ́ he. ");
INSERT INTO otmNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nɛ nu'a bin ja, gätho bi t'øpʉ ja ra hnini Éfeso. Gätho yʉ judío nɛ'ʉ hing yʉ judío bi 'yøde nɛ gätho mí ja ra mbidi. Nɛ gätho bi 'yɛ̨spa ra Jesús, ra Hmu bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nɛ xʉn ngu ʉ gue mí ɛ̨c'yɛi, bi zøm bʉ, bi nde da gomanho yʉ́ mbʉi, nɛ bi dä ra güɛnda a xí 'yøt'e. ");
INSERT INTO otmNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nɛ'ʉ 'da mím bądi bá cą yʉ́ søcuą, ngue yʉ libro yʉ́n xädi yʉ bądi, nɛ bi hyøspʉ ja ra sibi, gätho da nu'ʉ mí 'bʉpʉ. Nɛ nu'bʉ mi mbede hangu gätho di muui, mbɛ mí jua'a yote ma 'dɛt'a mahuąhi yʉ mbɛti gue ra t'axi. ");
INSERT INTO otmNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nɛ man'da xʉn ngu bi 'yɛ̨c'yɛi rám hman Oją yʉ ją'i bʉ Éfeso, man'da bi fądi ja rá ts'ɛdi Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","M'bɛjua bʉya bi bɛ̨n'a ra Pablo da mba bʉ Jerusalén, pɛ m'bɛt'o da zøm bʉ ra häi Macedonia, nɛpʉ ra häi Acaya. Nɛ bi 'yɛ̨na: ―Dam 'bʉcä ts'ʉ bʉ Jerusalén, m'bɛjua ga mbagä bʉ ja ra dąhnini Roma, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nɛ bi mbɛnpʉ Macedonia ʉ yoho yʉ́m fäts'ihʉ, ra Timoteo nɛ ra Erasto, pɛ guesɛ ra Pablo bim 'bʉpʉ mi'da yʉ pa bʉ Éfeso gue ra häi Asia. ");
INSERT INTO otmNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nu yʉ pa ʉ, xʉn ngu bi ndesʉi nangue rá 'yu Oją bʉ Éfeso, ");
INSERT INTO otmNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nguetho nu'a n'da ran 'yohʉ í Demetrio, rá 'bɛfi da 'yøt' yʉ zʉ t'ʉngu ngue ra t'axi, ngue yʉ́ pøte ra dąniją guepʉ i pa nthąnde ra oją Diana. Nu'a, nɛ'ʉ madím pɛhmbʉ, xʉn ngu bi dąha nangue ra 'bɛfi i øt'ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nu ra Demetrio bʉya bi zonh'dʉ 'da'angu ra 'bɛfi mí øthʉ, nɛ bi xifi: ―N'yohʉ ahʉ guí pąhmbʉ nangue ma 'bɛfihʉ xʉn ngu ra mbɛti dí tąhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Dí nuhʉ nɛ dí øhmbʉ hinga hønt'ua ra hnini Éfeso pɛ gätho ra häi Asia, 'bɛ'a øt' na ra Pablo, i xih yʉ ją'i gue nu'ʉ yʉ oją nt'øt'e yʉ́ 'yɛ yʉn 'yohʉ ɛ̨mbi ngue hing yʉ oją ʉ. Nɛ xʉn ngu yʉ ją'i bi päh yʉ́n 'yomfɛ̨ni nɛ bi 'yɛ̨c'yɛi a bi man ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nuya dán thɛhʉ n'da ra 'yąnthį, ngue nu ma pøte dí øthʉ njon da däi. Nɛ dim 'bɛh rá ts'ɛdi rá ngu ra oją Diana, ngue i nuįxte. Nɛ da t'ɛ̨mbi nte di muui. Pɛ nu'a ra Diana gue'a oją a, nɛ gätho yʉ ją'i 'bʉcua ja ra häi Asia nɛ gätho ra ximhäi i thąnde a, sä bi 'yɛ̨n'a ra Demetrio. ");
INSERT INTO otmNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nɛ nu'bʉ mí 'yø'ʉ, ɛ̨mmɛ bi dɛ ra cuɛ. Nɛ nts'ɛdi i mbafi: ―Xʉn ngu rá ts'ɛdi ra Diana gue ma ojąhʉ dyʉ mɛnguhʉ ua Éfeso. ");
INSERT INTO otmNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nɛ gätho bi yʉntonto gue 'bʉpʉ ja ra hnini. Nɛ gätho bin tihi 'darpʉ ní muxpʉ ja n'da ra ngu xʉn ndoho, nɛ bá bɛnt' ra Gayo nɛ ra Aristarco, bi zixpʉ, nɛ nu ra Gayo nɛ ra Aristarco, yʉ mɛngu bʉ Macedonia min 'yohʉ ra Pablo bʉ 'yu. ");
INSERT INTO otmNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nɛ'a ra Pablo nde xtá mba bʉ 'bʉh yʉ ją'i, pɛ nu yʉ 'yɛ̨c'yɛi bi japi hin da mba. ");
INSERT INTO otmNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nɛ 'da'ʉ gue mi ja yʉ́ ts'ɛdi bʉ ja ra häi Asia madin amigohʉ ra Pablo, bi mbɛnpa ra nde gue hin da mba bʉ bí mux yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nɛ 'dahma 'dan'yo bi man'ʉ n'da ngu n'da nguetho gätho bi yʉntonto. Nɛ xʉn ngu ʉ hingui pądi hanja bim pɛti bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nu ra Alejandro mi 'bä'inde bʉ 'bʉh yʉ ją'i, bi mba njʉqui bʉ ja yʉ́ hmi yʉ ją'i bʉya, nguetho ndep'ʉ yʉ́ mijudíohʉ din yą. Nu'a ra Alejandro bʉya bi uąnba rá 'yɛ ndepe din hɛ̨ yʉ ją'i, nguetho nde da xifi nte mán ts'o mí øt' yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pɛ nu'bʉ mi nu yʉ ją'i ngue ra judío ra Alejandro, mbɛ ma nyo ora bi mbafi, nɛ 'da'ingu bi ma: ―Xʉn ngu rá ts'ɛdi ra Diana ma ojąhʉ dyʉ mɛnguhʉ ua Éfeso. ");
INSERT INTO otmNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nu ra secretario bʉ ja ra hnini bʉya, bi japi ngue bin hɛ̨ yʉ ją'i, bi xifi: ―Dyʉn 'yohʉhʉ, dyʉ mɛ'efesohʉ, hingui 'bʉcua n'da ran yohʉ gue hingui pądi dí jamansuhʉ ra oją Diana, guejʉ dyʉ mɛ'efesohʉ, nɛ gätho dí ɛ̨spahʉ ra do bi däh mahɛ̨ts'i, gue rá pøte ra Diana. ");
INSERT INTO otmNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nɛ nuna njo'o da zä da gøni. Janangue'a daman 'yomfɛ̨nihʉ ts'ʉ nɛ hin gui 'yøthʉ a hin da bømanho. ");
INSERT INTO otmNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nu yʉn 'yohʉ ngue guá sihʉ ua, him bim pɛ̨ bʉ ja rá niją ra oją Diana. Nɛ him bi man ra ts'ore nangue'a ma ojąhʉ ra Diana, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nɛ xø bi 'yɛ̨n'a ra secretario: ―Nuna ra Demetrio nɛ'ʉ mi'da gue dim pɛhmbʉ, nu'bʉ i ja 'bɛ'a i nde dí yąpa n'da, nde'bʉ gue din yąui bʉ ja ra dąngu n'dahma n'da ngu n'da da zä din yąsɛ. ");
INSERT INTO otmNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nɛ nu'bʉ ja man'da guí nde gui 'yøthʉ, dami xihmbʉ ra zɛ'mi da 'yøt'a n'da ra junta, guepʉ da mba ma hoqui. ");
INSERT INTO otmNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nguetho dí su da hnɛrcahʉ häi 'bʉ da t'ängahʉ nangue ra mbahni dá øthʉ ra pa jabʉya, nguetho hin'yʉ 'bɛ'a sä ga mamhbʉ nangue'a dá øthʉ ya, bi 'yɛ̨na. ");
INSERT INTO otmNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nɛ nu'bʉ mi gua'a im ma, bi 'yɛt' yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nɛ nu'bʉ min hɛ̨ nín 'yo'ts'mahyą bʉ ra hnini Éfeso, nu ra Pablo bi zonh'dʉ yʉ 'yɛ̨c'yɛi. Nɛ nu'bʉ mí un ran zofo, bin 'yɛ̨te bʉya, bi mba bʉ Macedonia. ");
INSERT INTO otmNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nɛ gätho bi zɛngua yʉ'yɛ̨c'yɛi gätho ra häi Macedonia, bi hąt ra ts'ɛdi yʉ́ mbʉi nangue rám hman Oją bi xi'ʉ. Nɛ m'bɛjua bi zøm bʉ ja ra häi Grecia mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Hyuzna bim 'bʉpʉ, ɛ̨na xtá hyu ra barco, gue xtá mba bʉ ra häi Siria, pɛ nu'ʉ 'da yʉ judío ɛ̨na xtán däqui. Nɛ nu'bʉ mí bądi 'bɛ'a nde xtá t'ørpe, bin 'yomfɛ̨ni nɛ bá peng bʉ ja ra häi Macedonia. ");
INSERT INTO otmNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nɛ min 'yohʉ ra Pablo ra Sópater ra mɛngu berea a, nɛ'a ra Aristarco nɛ ra Segundo, yʉ mɛngu tesalónica ʉ, nɛ nu ra Gayo ra mɛngu derbe a, nɛ nu'a ra Timoteo nɛ ra Tíquico nɛ ra Trófimo, yʉ mɛngu asia ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nu'ʉ bim 'bɛt'o bi mba ní tøguahe bʉ ra hnini Troas, nɛ nugä dra Lucascä, dí o't' ra søcuą jaua, dín hyʉnbahe ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nu'bʉ mí guah yʉm pɛti nangue ran dąbaxjua, dá huhe ra barco dá nɛxhe bʉ ra hnini Filipos, ncʉt'a pa dán 'yohe dá sømhbe bʉ Troas guepʉ i tøguahe ʉ mi'da. Nɛ nyoto pa dám 'bʉhmbe bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nu'a ra pa domingo dám pɛtihe yʉ 'yɛ̨c'yɛi bʉ ja ra hnini Troas, dá sihe ra xɛcahmɛ, gue dá bɛ̨mhbe rán dąte ra Hmu. Nɛ nu'a ra Pablo bi man rám Hman Oją. Nɛ nya'athoho bin yą gue'bʉ go mi zøm made ra xui, nguetho da mba 'bʉ bi hyats'i. ");
INSERT INTO otmNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nɛ ɛ̨mmɛ xʉn ngu ra sibi mí zø bʉ ja ra cuarto magąts'i guepʉ bim pɛti yʉ ją'i. ");
INSERT INTO otmNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nɛ huxpʉ ja n'da ra ventana n'da ra ts'ʉnt'ʉ í Eutico, nɛ ɛ̨mmɛ bi ndet'ąha, nguetho ra Pablo nya'a bin yą. Nu ra ts'ʉnt'ʉ bi dop ra t'ąha, bi dägui, ná hyu tøque ra ngu bʉ bi dägui. Ya xí du 'bʉ mi thąts'i. ");
INSERT INTO otmNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nɛ bi gąh ra Pablo, ní nyexpʉ 'bɛn'a ra ts'ʉnt'ʉ nɛ bi hyʉfi, nɛ bi xi'ʉ bʉya: ―O di tu ni mbʉihʉ, ya bi dąmbɛ̨ni na. ");
INSERT INTO otmNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nu ra Pablo bi ndex mahøn'a bʉ ja ra cuarto bʉya, nɛ dán sihmɛhe. Nɛ nya'a thoho bin yą ra Pablo mahøn'a, gue'bʉ go mi bøx ra hyadi, ja bi mba bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nɛ nu'bʉ mí ts'ix'a ra ts'ʉnt'ʉ gue bi dägui, nɛ i te 'bʉ mí zøm bʉ rá ngu, gätho bin johya ʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nugähe dá hugähe ra barco nɛ dá mbähmbe bʉ ra hnini Asón nguetho nubʉ dan c'athe ra Pablo, ngubʉ bi xije mam'bɛt'o, gue xí 'yɛ̨n ra Pablo din 'yogua thoho. ");
INSERT INTO otmNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nɛ nu'bʉ mán tįmhbe bʉ Asón a ra Pablo, dá sixhe dá huhe ra barco nɛ dá sømhbe bʉ ja ra hnini Mitilene. ");
INSERT INTO otmNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nɛ dá nɛxhe bʉ, nɛ man'da pa dá sømhbe bʉ ní hɛ̨'t'a ra t'ʉhäi Quío gue i jabʉ made ra deją. Nɛ man'da pa bʉya dá sømhbe bʉ ra t'ʉhäi Samos gue i jabʉ made ra deją. Nɛ dán säyahe ts'ʉ bʉ ra hnini Trogilio, nɛ man'da pa bʉya dá sømhbe bʉ ra hnini Mileto. ");
INSERT INTO otmNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nguetho nu ra Pablo bi nde bi thoctho bʉ ra hnini Éfeso, hingui nde din säya bʉ ra häi Asia. Nguetho di xøni da zøn'a n'dihi bʉ Jerusalén, ya dí 'bʉpʉ 'bʉ ra pa ra dąmpɛti t'ɛ̨mbi Pentecostés. ");
INSERT INTO otmNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nɛ nu'bʉ má sømhbe bʉ Mileto, ra Pablo bi ma dín zonh'dʉ yʉ dąc'yɛi, ngue yʉ́ ngʉrpi yʉ 'yɛ̨c'yɛi dim pɛti bʉ ra hnini Éfeso. ");
INSERT INTO otmNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nɛ nu'bʉ mi zøpʉ ʉ, bi 'yɛ̨mp'a ra Pablo: ―Nu'ehʉ guí pąhmbʉ 'bɛ'a gätho mam 'bʉi dá øt'ä ua ra häi Asia, asta gue'bʉ go rá mbʉdi dá søcä ua. ");
INSERT INTO otmNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Gätho yʉ pa dám 'bʉcä ua dá ørpa rá 'bɛfi ra Hmu mahɛ̨ts'i, nɛ hin dadín 'yɛ̨ts'i. Nɛ xʉn ngu ma guidä dá fäni gue'bʉ má hąh ma mbʉi dá äp Oją nangue ahʉ. Nɛ xʉn ngu ran ʉnbi dá nu ngue bi 'yørcä yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pɛ nugä hin te dá cøn'nahʉ pɛ dá xi ahʉ gätho 'bɛ'a da mbäx ahʉ. Nɛ dá xän'nahʉ bʉ dim pɛti yʉ ją'i, nɛ dá xän'nahʉ bʉ ja ni ngumhbʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nɛ dá xifi xʉn ho yʉ judío nɛ'ʉ hing yʉ judío, ngue di päh yʉ́n 'yomfɛ̨ni nangue Oją, gue da 'yɛ̨c'yɛi ma Hmuhʉ ra Jesucristo. ");
INSERT INTO otmNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Pɛ nuya, rá Hogandąhi Oją i ørca ra ts'ɛdi ga mbagä bʉ Jerusalén, nɛ hin dí pądi 'bɛ'a gua thocä bʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Pɛ hønt'a dí pącä gue dan ofädi bʉ Jerusalén, nɛ ga nugä xʉn ngu yʉn ʉnbi, nguetho guesɛ rá Hogandąhi Oją bi xiqui hønbʉ go hapʉ dá thocä bʉ ja yʉ hnini. ");
INSERT INTO otmNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pɛ hinga guet'a dím bɛ̨n'a, hin te di muui ma tesɛgä nanguec zɛhɛgui. Hønt'a ran johya dí nde ga nu 'bʉ dá juah ra 'bɛfi bi 'dacä ma Hmuhʉ ra Jesús, gue'a ga mangä ran ho ma'da'yo nangue rá mate Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nɛ gätho ahʉ dá xi ahʉ rám Hman Oją gue 'bɛpʉ ní mandagahʉ Oją, nɛ dí pącä xínga n'da ahʉ gui nurcahʉ ma hmi mahøn'a. ");
INSERT INTO otmNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nuya nam pa ya dí xi ahʉ, hingui pa ma güɛndagä 'bʉ gui 'bɛhmbʉ rán ho Oją ya. ");
INSERT INTO otmNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nguetho hin te dá cøn'nahʉ, gätho dá xi ahʉ 'bɛ'a nde Oją gui pąhmbʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nuya gui jamansu 'bɛ'a gui 'yøthʉ, nɛ da zä bʉ gui jamansufʉ yʉ́ mbʉi ni mi 'yɛ̨c'yɛihʉ bʉya. Nɛ gue'a ra 'bɛfi bi 'da ahʉ rá Hogandąhi Oją, gue gui jamansufʉ yʉ́ 'yɛ̨c'yɛi ra Hmu, gätho ná ngu'ʉ i 'bʉhmbʉ ra Cristo, nguetho rá jisɛ ra Cristo í gurpa yʉ́ ts'oqui 'bʉ mí du. ");
INSERT INTO otmNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Pɛ nu'bʉ dá mbagä, dí pącä m'bɛjua ba ɛ̨'i 'da tengu yʉ zate, nde da za'ʉ yʉ dɛ'yo, din jabʉ da 'yøt'ahʉ gue di ʉn'na ni mbʉihʉ gyʉ 'yɛ̨c'yɛihʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nɛ 'da'ʉ gue guesɛ ahʉ da ndants'i, nɛ hinga njuąntho da man rám Hman Oją, gue da ndep'a dí tɛn'dʉ mi'da. ");
INSERT INTO otmNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Janangue'a gui jamansu ni mbʉihʉ ngue hin da hyä ahʉ ʉ. Nɛ guim bɛ̨mhbʉ gue nhyu jɛya, ma pa nɛ ra xui, dá xän'nahʉ n'da ngu n'da ahʉ, nɛ ɛ̨mmɛ dán zoni nangue ahʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nuya dadí dä ahʉ Oją. Nɛ ga soc'ahʉ rám Hman Oją, nu'a i ma nangue rá mate Oją, gue'a ram hma di zɛt'a ni mbʉihʉ, nɛ gue'a dín ja ahʉ gätho i ja Oją, tengu tho ʉ gätho mi'da i pa nthahni. ");
INSERT INTO otmNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nugä hin dá nde a ni mbɛtihʉ, xínga gue ni pahnihʉ. ");
INSERT INTO otmNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Pɛ guí pąhmbʉ dám pɛpzɛhɛ nɛ dá undä 'bɛ'a gätho mí hon'ʉ dán 'yogähe. ");
INSERT INTO otmNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Dá øt'ä gue dá honsɛ man ts'ihmɛ, dá ut'ahʉ gue dam pɛhmbʉ nɛ ga fäxhʉ ʉ hin 'yʉ 'bɛ'a da hyoni. Nɛ gam bɛ̨mhbʉ 'bɛ'a bi ma ma Hmuhʉ ra Jesús 'bʉ mí 'yɛ̨na: “Man'da di johya ní mbʉi n'da 'bʉ di uni, xinda gue'bʉ din t'unna n'da,” ngubʉ bi man ra Hmu, bi 'yɛ̨n'a ra Pablo. ");
INSERT INTO otmNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nɛ nu'bʉ mi gua'a rám hma ra Pablo, bin dąnyahmu gätho mí 'bʉpʉ, nɛ bin yąhʉ Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nɛ nu'ʉ gätho bin zoni, nɛ bi hyʉ'a ra Pablo nɛ bi zʉspa rá 'yogu. ");
INSERT INTO otmNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nu'ʉ ɛ̨mmɛ bi du yʉ́ mbʉi, nguetho ra Pablo bi xi'ʉ him man'dandį da nu mahøn'a. Nɛ nu'ʉ bi zix'a ra Pablo bʉ ja ra barco bʉya. ");
INSERT INTO otmNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nɛ nu'bʉ mán hyɛhmbe yʉ 'yɛ̨c' yɛi, dá huhe ra barco, nɛ njuąntho 'bex dá sømhbe bʉ ja ra t'ʉhäi Cos ngue i ja bʉ made ra deją. Nɛ man'da pa bʉya dá thohmbe bʉ ja ra hnini Pátara. ");
INSERT INTO otmNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nubʉ, dá tįmhbe n'da ra barco ní mba bʉ ra häi Fenicia, dá huhe bʉya dá mbähmbe. ");
INSERT INTO otmNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nɛ nu'bʉ má thohmbe nthandi thoho ra t'ʉhäi Chipre i ja bʉ made ra deją, ngąha dá mbähmbe dá sømhbe bʉ ra häi Siria nubʉ ra hnini Tiro, guepʉ da zoh rá 'bɛni ra barco. Nɛ dá cąhmbe bʉya, dá mbähmbe bʉ ja ra hnini. ");
INSERT INTO otmNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nu'bʉ má tįmhbe bʉ yʉ 'yɛ̨c'yɛi bʉya, dám 'bʉhmbe nyoto pa. Nɛ nu rá Hogandąhi Oją bi bɛ̨nba yʉ 'yɛ̨c'yɛi 'bɛ'a da thoh ra Pablo 'bʉ da mba bʉ Jerusalén. Janangue'a bi xifi hin da mba. ");
INSERT INTO otmNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nɛ nu'bʉ mí gua'a nyoto pa, dá pømhbe bʉ. Nɛ gätho yʉ 'yɛ̨c'yɛi, yʉn 'yohʉ nɛ yʉ xisu nɛ yʉ t'ʉhni, dá mbähmbe asta gue dá pømhbe bʉ ja ra hnini. Dán dąnyahmuhe bʉ ja ra ndendeją bʉya, nɛ dán yąhe Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nubʉya dán 'yɛ̨hmbe nɛ nugähe dá huhe ra barco, pɛ nu'ʉ bi mbeng bʉ ja yʉ́ ngu. ");
INSERT INTO otmNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bá nɛxhe bʉ Tiro, dá mbähmbe nɛ dá cąhmbe 'bʉ má sømhbe bʉ Tolemaida. Nu'bʉ má zɛnguahe yʉ cu, dán tehe bʉ n'da pa. ");
INSERT INTO otmNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nu'bʉ mi hyats'i, gätho gahe ngue dín 'yohe ra Pablo dá thohmbe bʉ ra dąhnini Cesarea. Nɛ dán säyahe bʉ ja rá ngu ra Felipe. Nu'a ra Felipe ząi mi mam bʉ rán ho ma'da'yo Oją. Nu'a, n'da gue'ʉ yoto má 'yohʉ nthahni mín 'yohʉ ra Esteban. ");
INSERT INTO otmNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nɛ nu ra Felipe mi 'bʉi goho yʉ́ t'įxu him bin thąti, nɛ nu'ʉ, yʉ pøngahyą ʉ, bi man rám Hman Oją. ");
INSERT INTO otmNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nɛ nu'bʉ mám 'bʉhmbe bʉ 'da yʉ pa bi zø'a n'da rá pøngahyą Oją í Agabo, bá nɛxpʉ ra häi Judea. ");
INSERT INTO otmNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nu'bʉ mi zøm bʉ dí 'bʉhmbe a, bi gąspa a rá ngʉt'i ra Pablo nɛ bi duzɛhɛ yʉ́ gua nɛ yʉ́ 'yɛ ra Agabo, nɛ bi ma: ―Nu rá Hogandąhi Oją bi bɛ̨ngä ngue ngubʉ da 'yørpa yʉ judío a rá mbɛti na ra ngʉt'i bʉ Jerusalén, nɛ din dä bʉ 'bʉh yʉ ją'i ngue hing yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nu'bʉ má øhmbe 'bɛ'a bi man ra Agabo, gätho gahe nɛ yʉ mɛngu bʉ, dá ørpahe ra ts'ɛdi hin xtá mba ra Pablo bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nu ra Pablo bi 'yɛ̨m bʉya: ―'Bɛ'a guí øthʉ guí zomhbʉ. O gadí ʉngahʉ ma mbʉi. Nugä dadín sägä hønt'a go 'bɛ'a da t'ørcagui, o gue da thurqui o gue da thog bʉ Jerusalén nangue ra Jesús, ma Hmu. ");
INSERT INTO otmNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nɛ him bi zä dá sąmhbe, dá hɛthe bʉya nɛ dá ɛ̨mhbe: ―Nu'a rá pähä Oją da t'øt'e. ");
INSERT INTO otmNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nɛ m'bɛjua bʉya dán sähe nɛ dá mbähmbe ra Pablo bʉ Jerusalén. ");
INSERT INTO otmNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nɛ 'da'ʉ yʉ 'yɛ̨c'yɛi bʉ Cesarea dá mbähmbe. Nɛ nu'bʉ má sømhbe bʉ Jerusalén, nu'ʉ bi zixcähe bʉ rá ngu ra Mnasón, ra mɛngu chipre. Nɛ maya'bʉ thoho mí ɛ̨c'yɛi ra Mnasón. Guepʉ rá ngu dán säyahe. ");
INSERT INTO otmNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nu'bʉ má sømhbe bʉ Jerusalén, nu yʉ cu nangue ra Cristo bʉ, bi hyu yʉ́ mbʉi 'bʉ mi nuje, nɛ bi zimanhoje. ");
INSERT INTO otmNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Man'da pa bʉya dá mbähmbe ra Pablo dá nuhe ra Jacobo Santiago, nɛ'ʉ gätho mí 'bʉpʉ, yʉ́ mingʉrpihʉ, yʉ dąc'yɛi. ");
INSERT INTO otmNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nu ra Pablo bi zɛngua ʉ nɛ 'bex bi dʉ'mi 'dahmi'datho bi ma 'bɛ'a gätho bi 'yøt' Oją nangue rá 'bɛfi ra Pablo, nubʉ 'bʉh yʉ ją'i ngue hing yʉ judío. ");
INSERT INTO otmNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nɛ nu'bʉ mi 'yø'ʉ 'bɛ'a bi man ra Pablo gue bi 'yømanho 'bʉ mí sih rám Hman Oją, ɛ̨mmɛ bin johya nɛ bi 'yɛ̨spa Oją. Pɛ nu'ʉ, bi 'yɛ̨mbi: ―Pɛ guí pądi, ma zʉ cu'i Pablo gue yʉ mahuąhi thoho yʉ judío i ɛ̨c'yɛi ya, nɛ gätho i ɛ̨na jatho da 'yøt' yʉ́n t'ɛ̨di ra Moisés. ");
INSERT INTO otmNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nɛ nu'ʉ bi sifi 'bɛ'a gätho gá 'yøt'e. Nɛ sä ɛ̨n'ʉ gá xänbi gue gätho da hyɛh yʉ́n t'ɛ̨di ra Moisés ʉ yʉ judío gue 'bʉpʉ 'bʉh yʉ ją'i hing yʉ judío, nɛ gá xifi ngue hin da mba nthɛqui yʉ́ xifani, nɛ hin da 'yøt' yʉ́n t'øt'e