﻿USE sofia;
DROP TABLE IF EXISTS sofia.oteNT_vpl;
CREATE TABLE oteNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES oteNT_vpl WRITE;
INSERT INTO oteNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nurá mʉdi nuna tꞌofona̱ ma da ma̱ toꞌo gueꞌʉ yá mbøxita ra Jesucristo. ꞌNa de gueꞌʉ ndu ra Davi ne ndu ra Abrá. ");
INSERT INTO oteNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ra Abrá bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Isaac, y ra Isaac bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Cobo, y ra Cobo bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Judá co maꞌra yá cu. ");
INSERT INTO oteNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ra Judá co rá ꞌbɛhña̱ rá thuhu ra Tamar bi mɛꞌtsa yoho yá tꞌʉ yá thuhu ra Fare ne ra Sara. Y ra Fare bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Esrom, y ra Esrom bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Aram. ");
INSERT INTO oteNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Y ra Aram bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Aminadab, y ra Aminadab bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Naasón, y ra Naasón bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Salmón. ");
INSERT INTO oteNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Y ra Salmón co rá ꞌbɛhña̱ rá thuhu ra Raab bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Boos, y ra Boos co rá ꞌbɛhña̱ rá thuhu ra Rut bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Obed, y ra Obed bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Isaí. ");
INSERT INTO oteNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y ra Isaí bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Davi núꞌa̱ bi nda̱ de ya me Israel. Y ra nda̱ Davi bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Salomó, y nurá na̱na̱ ra Salomó go gueꞌa̱ mrá ꞌbɛhña̱ hma̱ha̱ ndu ra Uría. ");
INSERT INTO oteNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Y ra Salomó bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Roboam, y ra Roboam bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Abías, y ra Abías bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Asa. ");
INSERT INTO oteNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Y ra Asa bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Josafa, y ra Josafa bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Joram, y ra Joram bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Usía. ");
INSERT INTO oteNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Y ra Usía bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Jotam, y ra Jotam bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Acás, y ra Acás bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Esequía. ");
INSERT INTO oteNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Y ra Esequía bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Manase, y ra Manase bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Amón, y ra Amón bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Josía. ");
INSERT INTO oteNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Y ra Josía bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Jeconía co maꞌra yá cu. Y nuya paꞌʉ mi tsꞌixa ntsꞌa̱hni ya me Israel pa ja ra hnini Babilonia. ");
INSERT INTO oteNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ha nuya paꞌʉ ra Jeconía bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Salatiel, y ra Salatiel bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Sorobabel. ");
INSERT INTO oteNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Y ra Sorobabel bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Abiu, y ra Abiu bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Eliaquim, y ra Eliaquim bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Asor. ");
INSERT INTO oteNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Y ra Asor bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Sadoc, y ra Sadoc bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Aquim, y ra Aquim bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Eliud. ");
INSERT INTO oteNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Y ra Eliud bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Eleasar, y ra Eleasar bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Matán, y ra Matán bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Cobo. ");
INSERT INTO oteNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y ra Cobo bi mɛꞌtsa ꞌnará tꞌʉ rá thuhu ra Jose núꞌa̱ toꞌo rá da̱me ra Maria. Y ra Maria go gueꞌa̱ rá na̱na̱ ra Jesu núꞌa̱ bi thuꞌmbabi nehe ra Cristo núꞌa̱ rá ꞌmɛhni Ajua̱ pa e da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Y de gatho yá mbøxita, yá da̱nga xita ne yá xitaꞌa̱, desde ra Abrá asta ra Davi mi ꞌrɛtꞌamagohoꞌʉ. Nepʉ yá mbøxita, yá da̱nga xita ne yá xitaꞌa̱, desde ra Davi asta nu mi tsꞌixa ntsꞌa̱hni ya me Israel pa ja ra hnini Babilonia mi ꞌrɛtꞌamagoho ya xita. Y yá mbøxita, yá da̱nga xita ne yá xitaꞌa̱, desde mi tsꞌixa ntsꞌa̱hni asta bi ꞌmʉi ra Jesucristo mi ꞌrɛtꞌamagoho ya xita. ");
INSERT INTO oteNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Y nunabya go guehna ra ꞌbede de rá ꞌbʉi ra Jesucristo: Ra Maria xqui tꞌadi pa da ntha̱tui ra Jose, pe himbi ꞌmʉhui ꞌbestho. Nepʉ nuꞌá̱ bi ndaꞌthi co rá tsꞌɛdi rá Ma̱ca Nda̱hi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pe ra Jose mrá hoja̱ꞌi hangue himbi ne da ꞌbɛtua rá tsa ra Maria co ya ja̱ꞌi, mi ne da hyɛpʉ mantꞌa̱guitho pa ya hinxa ntha̱tuihma̱. ");
INSERT INTO oteNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nuꞌá̱ bi beni gue ya hinda ntha̱tui ngueꞌa̱ bi ba̱di gue ya mi daꞌthiꞌa̱. Pe Ajua̱ bi mɛhna ꞌnará ɛnxɛ pa bi zofo dega tꞌi ne bi ꞌñembabi: ―Nuꞌi nugue Jose rá tꞌʉꞌi ra nda̱ Davi, oguí beni gui hyɛpʉ. Oguí tsu gui ntha̱tui ra Maria, ngueꞌa̱ nuꞌá̱ daꞌthi pe co rá tsꞌɛdi ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nuꞌá̱ ma da mɛꞌtsa ꞌnara zi ba̱tsi, y nura zi ba̱tsiꞌa̱ gui hñuꞌmbabi drá thuhu ra JESU, ngueꞌa̱ go gueꞌa̱ ma da pøhø yá ja̱ꞌi de yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bi njabʉ pa bi nja ngu núꞌa̱ xqui ma̱nga ꞌna de nuyá ꞌmɛhni Ajua̱ mayaꞌbʉ gue bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ꞌNara nxutsi ma da ndaꞌthi da ꞌmʉ rá ba̱tsi ne da thuꞌmbabi rá thuhu Emanuel. Núꞌa̱ ra thuhuꞌa̱ rí bøni da ꞌñena, Ajua̱ ꞌbʉi con guecjʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nepʉ bi nuhu ra Jose, ne bi ntha̱tui ra Maria ngu núꞌa̱ xqui xipa rá ɛnxɛ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pe himbi hñuxui asta himbi ꞌmʉi rá mʉdi tꞌʉ, ne bi hñuꞌmbabi rá thuhu ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Núꞌʉ ya pa mrá nda̱ ra Erode, gueꞌbʉ bi ꞌmʉi ra Jesu ja ra hnini Belé de ra hai Judea. Ne de nuya paꞌʉ ꞌraya hoga ba̱di bi ꞌñehe de yabʉ ya hai ngue mbøxhyadi. Bi ꞌñeheꞌʉ ne bi zøhø ja ra hnini Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nepʉ bi ꞌñaniꞌʉ bi ꞌñena: ―¿Habʉ de guecua di ꞌbʉi rá nda̱ ya xodyo núꞌa̱ ja guehya xa ꞌmʉi? Ngueꞌa̱ stá hanthe ꞌnara tsø de bøxhyadi y dí pa̱he gue go gueꞌa̱ ꞌnara ntꞌudi gue xa ꞌmʉi ꞌnara nda̱, hangue stá ehehe pa ga nsundaheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Y nu mi ꞌyøde ra nda̱ Erode njabʉ, xi bi ntsu ne bi du rá mʉi, ne gatho ya me Jerusale bi ntsu nehe, ne bi du yá mʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ra nda̱ Erode ꞌbestho bi zohna ya nda̱ gá macja̱ ne ya xahnate de rá ley ra Moise pa bi ꞌyambabiꞌʉ te mi ma̱nga yá hɛꞌmi, habʉ dí ꞌmʉi ra Cristo núꞌa̱ ma da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Y nuꞌʉ́ bi ꞌñembi: ―Ma da ꞌmʉi Belé de ra hai Judea, ngueꞌa̱ njabʉ bi ꞌyofo rá ꞌmɛhni Ajua̱ gue bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Núꞌahʉ gyá menguhʉ Belé de ra hai Judá, maꞌna xa tꞌeꞌtsꞌa ri nsuhʉ de gatho maꞌra ya hnini de ra hai Judá, ngueꞌa̱ de gueꞌahʉ ma da bønga ꞌnara nda̱ núꞌa̱ da supa rá hnini Ajua̱ núꞌa̱ rá thuhu Israel. ");
INSERT INTO oteNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nuꞌbʉ́ ra Erode bi ña̱sɛui ꞌramatsꞌʉ ya ba̱di ne bi ꞌyambabiꞌʉ haꞌmʉ xqui hyanda ra tsø. ");
INSERT INTO oteNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nepʉ bi ꞌñembi: ―Rí maha Belé, ꞌyohʉ gui ꞌñanihʉ xá hño habʉ di ꞌbʉi ra ba̱tsi, y nu xcrí tsʉhʉ güi penjʉ gui xicaguihʉ pa ga ma ga nsundaga nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Y nu mi ꞌyøde núꞌa̱ bi ma̱nga ra nda̱, nuꞌʉ́ bi ma. Nepʉ núꞌa̱ ra tsø xqui hyantꞌʉ mbøxhyadi mi ꞌbɛtꞌo de gueꞌʉ mi utua ra ꞌñu asta himbi tsøni habʉ mi ꞌbʉi ra zi ba̱tsi ja bi ꞌmaini ra tsø. ");
INSERT INTO oteNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nepʉ ya ba̱di bi hyanda ra tsø bi ꞌmai ja ꞌnara zi ngu, ne xi bi johyaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Y bi yʉtꞌiꞌʉ ja ra ngu ne bi hyanda ra zi ba̱tsi co ra Maria nurá na̱na̱ꞌa̱, ne bi ndandiña̱hmuꞌʉ pa bi nsunda ra zi ba̱tsi, ne bi xoꞌtsa yá ꞌmɛꞌtsi mi hña̱, ne bi umba ya ꞌbaha dega oro ne ra tꞌutsꞌi ne ꞌnara ñʉni mi yʉni xá cʉhi mrá thuhu ra mirra. ");
INSERT INTO oteNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ha nuya ba̱di bi xipabi Ajua̱ dega tꞌi gue hinda menguiꞌʉ pa da xipabi ra Erode habʉ xqui zʉdi ra zi ba̱tsi. Hangue nuꞌʉ́ bi pacua ra ꞌñu pa bi mengui ja yá hai. ");
INSERT INTO oteNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nu mi menga ya ba̱di, Ajua̱ bi mɛhna ꞌnará ɛnxɛ pa bi zofo ra Jose dega tꞌi ne bi ꞌñembi: ―Nangui ne tsixa ra zi ba̱tsi co rá na̱na̱, pøñhʉ yabʉ de guecua. Rí maha ja ra hai Egipto gui ꞌbaꞌtuahʉ ra nda̱ Erode ngueꞌa̱ nuꞌá̱ ma da hyonga ra zi ba̱tsi pa da hyo, y ja bá ꞌbʉhʉni asta hinga xiꞌaꞌi güi penjʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nuꞌbʉ́ ra Jose bi nangui ꞌbestho ra xuuiꞌa̱ ne bi zixa ra zi ba̱tsi co rá na̱na̱ pa bi ma Egipto. ");
INSERT INTO oteNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Y ja bá ꞌbʉhniꞌʉ asta himbi du ra Erode. Hangue bi nja ngu núꞌa̱ xqui ma̱nga rá ꞌmɛhni Ajua̱ gue Ajua̱ bi ꞌñena: “Dá pɛnpa ra noya ma Tꞌʉ pa da bøni de Egipto.” ");
INSERT INTO oteNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nepʉ ra Erode xi bi bø rá cuɛ ntsꞌɛdi ngueꞌa̱ xqui hyatꞌa ya ba̱di. Hangue bi manda da tho gatho ya zi ba̱tsi núꞌʉ mi ꞌbʉi gatho rá ngʉni Belé, núꞌʉ mi pɛꞌtsa yo njɛya pa rí ga̱i, ngueꞌa̱ xqui xipa ya ba̱di gue ya mi pɛꞌtsa ngu yo njɛya de xqui hyanda ra tsø. ");
INSERT INTO oteNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Y bi njabʉ ngu núꞌa̱ xqui ma̱nga ra Jeremía rá ꞌmɛhni Ajua̱ ne bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bi ntꞌøde ya da̱nga tsꞌoni ja ra hai de Ramá ne ya hmafi, ngueꞌa̱ ra Raque xqui thopabi gatho yá zi ba̱tsi, hangue mi zoni ne himbi za to bi hyoꞌti. ");
INSERT INTO oteNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nepʉ ya de bi du ra Erode, nuꞌbʉ́ Ajua̱ bi mɛhna maꞌnaꞌqui ꞌnará ɛnxɛ pa bi zofo ra Jose dega tꞌi nuni Egipto, ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Nangui ne tsixa ra zi ba̱tsi co rá na̱na̱ ne rí maha ja ri haihʉ Israel ngueꞌa̱ ya xa du núꞌa̱ toꞌo mi honga ra zi ba̱tsi pa xa hyo hma̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nuꞌbʉ́ nuꞌá̱ bi nangui bi zixa ra zi ba̱tsi co rá na̱na̱ y bi mengui pa ja yá hai Israel. ");
INSERT INTO oteNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pe ra Jose bi ꞌyøde gue ra Arquelao rá tꞌʉ ra Erode go mrá mpøte de rá ꞌbɛfi rá dada ne bi nda̱ ja ra hai Judea, hangue mi tsu da zøni ja núꞌa̱ ra haiꞌa̱. Nuꞌbʉ́ Ajua̱ bi xipi dega tꞌi gue da ma ja ra hai Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Y bi zøniꞌʉ bi ꞌmʉhni ja ꞌnara hnini rá thuhu Nasare, pa bi njabʉ ngu núꞌa̱ xqui ma̱nga ꞌrayá ꞌmɛhni Ajua̱ gue ra Jesu ma da tꞌembabi gue ra me Nasare. ");
INSERT INTO oteNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ꞌMɛfa bi mʉdi ra Xuua Xiꞌtsate bi zofo ya ja̱ꞌi ja ꞌnara mbonthi nuni Judea. ");
INSERT INTO oteNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ne mi xipa ya ja̱ꞌi mi ena: ―Ntsøꞌmhʉ ne ñobrihʉ ngueꞌa̱ ra nda̱ de mahetsꞌi ya ꞌbestho xa ꞌñepʉ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nura Xuua go gueꞌa̱ ra ja̱ꞌi xqui ma̱nga ra ba̱di Isaía mayaꞌbʉ gue ma da ꞌñehe, ne bi ꞌñena: ꞌNara ja̱ꞌi ma da ña̱ ntsꞌɛdi ja ra mbonthi ne ma da ꞌñena: “Hocuahʉ xá hño rá ꞌñu ra zi Hmu, jua̱nhʉ gatho ya tsꞌacaꞌñu.” ");
INSERT INTO oteNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Y nuꞌa̱ mrá he ra Xuua, mri hñe dega xicameyo, ne mri ngʉtꞌa ꞌnara ngʉtꞌi dega xifri. Y numrá hñuniꞌa̱, mi tsi ya hoga ncꞌoto ne ya tꞌafi dega sefi. ");
INSERT INTO oteNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y xi mi tsøni ndunthi ya ja̱ꞌi habʉ mi ꞌbʉꞌa̱ pa da ꞌyøde núꞌa̱ mi ma̱ñꞌa̱, nuya me Jerusale ne gatho ya me Judea, ne gatho nuya ja̱ꞌi mi ꞌbʉi ja rá nthetsꞌi ra da̱the Jordá. ");
INSERT INTO oteNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nepʉ ra Xuua mi xiꞌtsa ya ja̱ꞌi ja ra da̱the Jordá núꞌʉ mi njua̱ni de yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Y ndunthi ya fariseo ne ya saduceo mi tsøni habʉ mi xiꞌtsate ra Xuua. Nuꞌʉ́ mi tꞌembi gue ya fariseo ne ya saduceo po núꞌa̱ ra jamfri mi pɛꞌtsiꞌʉ. Ora bi hyanda ra Xuua mi tsøniniꞌʉ bi ꞌñembabi: ―¡Núꞌahʉ gyá tsꞌoꞌmʉihʉ guí njahʉ ngu ya zate quꞌeña̱! ¿Hanja xcá ehehʉua? ¿Ha guí ne gui ꞌbaꞌtuabihʉ hma̱ha̱ rá cuɛ Ajua̱ xa ꞌñepʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mahyoni gui ꞌyøthʉ núꞌa̱ xá hño pa da hnequi gue xi majua̱ni ya xcá ntsøꞌmhʉ de ri tsꞌoquihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ogrí ꞌñetsꞌihʉ gui ꞌñeñhʉ gue ngueꞌa̱ yá tꞌʉꞌaꞌihʉ ra Abrá hinda ma da zʉꞌahʉ rá cuɛ Ajua̱. Ngueꞌa̱ nuga dí xiꞌahʉ gue Ajua̱ tsa da ꞌyøtꞌe asta nuya ya do nehe da nja̱ꞌi y da ntꞌʉ de ra Abrá. ");
INSERT INTO oteNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Y dí xiꞌahʉ gue nubya ya ꞌbʉi ꞌna toꞌo ha̱ ra tꞌɛ́gui pa da zɛcua yá ꞌyʉ ya za. Gatho núꞌʉ ya za hingui unga yá hoga fruta da tsꞌɛqui pa da thøtꞌa ja ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nuga dí xiꞌtsꞌaꞌihʉ co ra dehe ngueꞌa̱ ya gá ntsøꞌmhʉ de ri tsꞌoquihʉ, pe xa ꞌñepʉ maꞌna bra ꞌbɛfa de gueque núꞌa̱ toꞌo ma da xiꞌtsꞌaꞌihʉ co ra Ma̱ca Nda̱hi núꞌa̱ ma da ꞌmʉi ja ri corasohʉ ne xi di ja rá tsꞌɛdi ngu ra tsibi. Núꞌa̱ bra ꞌbɛfa de guecagui xi maꞌna ja rá tsꞌɛdi y hindí ꞌñepcagui nixi ga ha̱ꞌtsuabi yá thiza. ");
INSERT INTO oteNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Y nuꞌá̱ ha̱, go gueꞌa̱ tsa da mica ra trigo ne da muntsꞌa núꞌa̱ xá hño pa da mɛꞌtsi, y nura paha da ꞌueque pa da tsa̱tꞌa ja ra tsibi núꞌa̱ hinhyaꞌmʉ ma da huetꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ꞌMɛfa ra Jesu xqui ꞌñehe de Galilea pa mri ma ja ra da̱the Jordá habʉ mi ꞌbʉ ra Xuua pa da nxisteheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pe ra Xuua himi ne da xiꞌtsa ra Jesu, ne bi ꞌñembi: ―¿Ha xcá ehe pa go ga xiꞌtsꞌaꞌi? Nuꞌi go rí ꞌñepi gui xiscagui. ");
INSERT INTO oteNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nepʉ ra Jesu bi da̱di bi ꞌñembi: ―Go da xiscaguigue pa njabʉ ga øꞌtuabihʉ gatho yá hmanda Ajua̱. Nuꞌbʉ́ ra Xuua bi xiꞌtsa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Y nu mi uadi bi nxistehe, bi bøtsꞌe de ja ra dehe, nepʉ bi xogui mahetsꞌi ne bi hyanda rá Ma̱ca Nda̱hi Ajua̱ bá ca̱i ngu ꞌnara zi domitsu ne bi ꞌñe bi zøhø ja gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y bi ntꞌøde ꞌnara noya de mahetsꞌi ne bi ꞌñena: ―Nuni go guehni ma hma̱ca Tꞌʉ, ne xi dí hopa rá ꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nepʉ rá Ma̱ca Nda̱hi Ajua̱ bi zixa ra Jesu ja ra ꞌyoꞌmtha pa ja da nthɛuini ra tsꞌonda̱hi pa da japi hma̱ha̱ da ꞌyøtꞌa ꞌnara tsꞌotꞌøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nuni ja bi beheni ra Jesu hinte bi zi ñote ma pa ne ñote xuui, ne ꞌmɛfa bi zʉ ra thuhu. ");
INSERT INTO oteNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nepʉ de gueꞌa̱ bi zøni ra tsꞌonda̱hi há mi ꞌbʉiꞌa̱, ne bi mʉdi bi xaxi ne bi ꞌñembabi: ―ꞌBʉ go gueꞌe rá Tꞌʉꞌi Ajua̱, japa nuya ya do da nthuhme xa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pe nuꞌá̱ bi da̱ti ne bi ꞌñembabi: ―Xa ntꞌofo ja ra Ma̱ca Tꞌofo gue ra ja̱ꞌi hingue hønsɛ po ra thuhme da ꞌmʉi, gatho núꞌa̱ ma̱ Ajua̱ go gueꞌa̱ umba rá te ra ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nepʉ ra tsꞌonda̱hi bi zixa ra Jesu ja ra ma̱ca hnini Jerusale, ne bi pøꞌtsa maña̱ ja ra nda̱nija̱. ");
INSERT INTO oteNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne bi ꞌñembabi: ―ꞌBʉ xi majua̱ni rá Tꞌʉꞌi Ajua̱, ꞌyɛnga ra sagui pa njaꞌti, ngueꞌa̱ xa ntꞌofo ja ra Ma̱ca Tꞌofo ne ena njaua: Ajua̱ da pɛhna yá ɛnxɛ pa da suꞌaꞌi ne da mipꞌa ri ꞌyɛ pa njabʉ hingui tsamaꞌñʉ ri ua nu xcrí tsønga ja ra hai. ");
INSERT INTO oteNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nepʉ ra Jesu bi ꞌñembabiꞌa̱: ―Xa ntꞌofo nehe ja ra Ma̱ca Tꞌofo: “Oguí xaxa Ajua̱ ri Hmu pa gui ꞌñena gue da maxꞌaꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nepʉ maꞌnaꞌqui ra tsꞌonda̱hi bi zixa ra Jesu ja ꞌnara tꞌøhø xi mrá hñetsꞌi pa bi yopa xaxi, ne bi ꞌñutuabi gatho ya hnini de rá ngʉni ra ximhai con gatho yá hño núꞌa̱ mi ja. ");
INSERT INTO oteNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y bi ꞌñembi: ―Gatho nuyʉ ya hnini guí handi ga ꞌraꞌi ꞌbʉ gui ndandiña̱hmu ne gui nsundagui. ");
INSERT INTO oteNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nepʉ ra Jesu bi ꞌñembi: ―ꞌUegue de gueque Satá. Xa ntꞌofo ja ra Ma̱ca Tꞌofo gue Ajua̱ ri Hmu go gueꞌa̱ gui nsunda, ne hønsɛꞌa̱ gui pɛpabi. ");
INSERT INTO oteNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nepʉ ra tsꞌonda̱hi ꞌbestho bi ꞌuegue de ra Jesu, ne bi zø yá ɛnxɛ Ajua̱ bi umbabi te da zi. ");
INSERT INTO oteNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ꞌMɛfa bi ꞌyøde ra Jesu gue ra Xuua Xiꞌtsate mi ofadi. Nuꞌbʉ́ nuꞌá̱ ꞌbestho bi mengui pa ja ra hai Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Y ja bá ꞌbʉhni ja ra hnini Nasare. Nepʉ de guehni bi ma bá ꞌbʉ Ncapernau guetbʉ ja rá ña̱ni ra ndehe habʉ mi ja yá hai ra Sabuló ne ra Neftalí. ");
INSERT INTO oteNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Y bi njabʉ ngu núꞌa̱ xqui ma̱nga ra ba̱di Isaía de núꞌa̱ ra haiꞌa̱ ne bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","De yʉhyadi de ra da̱the Jordá ja jani rá hai ra Sabuló ne rá hai ra Neftalí, ja thohnitho ra ꞌñu rí ma pa ja ra ndehe, ja guehni ra hai Galilea habʉ ꞌbʉi ndunthi ya ja̱ꞌi núꞌʉ hingyá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Y nuya mengu de núꞌa̱ ra haiꞌa̱ xqui ꞌmɛdi hma̱ha̱ ja ꞌnara da̱nga ꞌbɛxuui, pe nubyá ha̱, ya bi nja ra hyatsꞌi ja núꞌa̱ ra haiꞌa̱. Njabʉ gueꞌa̱ xqui ma̱nga ra ba̱di Isaía. ");
INSERT INTO oteNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Desde ya paꞌʉ ra Jesu bi mʉdi bi zofo ya ja̱ꞌi ne bi ꞌñembabi: ―Ntsøꞌmhʉ ne ñobrihʉ ngueꞌa̱ ya xa zøhø ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Y ra Jesu mi ꞌyo ja ra ña̱nga ndehe Galilea y bi hyandi mi ꞌyoni yoho ya ꞌñøhø mri ncu, ꞌna de gueꞌʉ rá thuhu ra Simu núꞌa̱ bi thuꞌmbabi nehe ra Pedro, ha nuꞌa̱ maꞌna rá thuhu ra Andre, núꞌʉ́ mi ɛntꞌa yá xitꞌa̱ ja ra ndehe ngueꞌa̱ myá mɛhua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nepʉ ra Jesu bi zofoꞌʉ ne bi ꞌñembi: ―Bá ehʉ tɛngaguihʉ y ga uꞌtꞌaꞌihʉ gui mpɛhua̱hʉ dega ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nuꞌbʉ́ ꞌbestho nuꞌʉ́ bi zopʉ yá xitꞌa̱ nepʉ bi dɛni. ");
INSERT INTO oteNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Y bi ꞌño ꞌna tʉiꞌʉ nepʉ bi hyandi mi ꞌyoni má yoho ya ꞌñøhø mri ncu, ꞌna rá thuhu ra Cobo y nu maꞌna rá thuhu ra Xuua yá tꞌʉ ra Sebedeo, mi o mbo ra motsa co yá dada mi pøꞌta yá xitꞌa̱. De guehni ra Jesu bi zofoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nepʉ ꞌbestho bi zohniꞌʉ yá motsa ne yá dada ne bi dɛna ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nuꞌbʉ́ ra Jesu bi ma bá gatꞌi gatho rá ngʉni Galilea y mi cʉtꞌa ja yá nija̱ ya mengu de guehni pa mi xahni, y mi ha̱cuabi gatho nuꞌa̱raza ra hñeni mi pɛꞌtsiꞌʉ, y mi ꞌyo mi zofoꞌʉ mi embi gue ya xqui zøhø ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Y bi ntʉnga ra noya gatho ja ra hai Siria, y bá tsꞌimpabi gatho ya daꞌthi núꞌʉ mi pɛꞌtsa nuꞌa̱raza ra hñeni ne núꞌʉ mi pɛꞌtsa ya tsꞌonda̱hi ne núꞌʉ xqui ꞌbɛ yá mfeni ne núꞌʉ mi doua, y gatho mi øtheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y ndunthi ya ja̱ꞌi bi dɛna ra Jesu, ya me Galilea, ya me Decapoli, ya me Jerusale, ya me Judea, ne ya me riꞌnandi ra da̱the Jordá. ");
INSERT INTO oteNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ha nu mi hyanda ra Jesu gue ndunthi ya ja̱ꞌi mi ꞌñoui, nuꞌbʉ́ nuꞌá̱ bi ꞌuegue de gueꞌʉ ne bi bøxa ja ꞌnara tꞌøhø ne ja bá hudiniꞌa̱. Nepʉ bi zønga yá nxadi ne ja bi muntsꞌiuini. ");
INSERT INTO oteNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y ra Jesu bi mʉdi bi xahniꞌʉ ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Nja̱pi núꞌʉ toꞌo hingui ꞌñetsꞌi ja yá mfeni; núꞌʉ́ go gueꞌʉ ma da ꞌmʉi habʉ ri manda Ajua̱, ne da hña̱niꞌʉ gatho ya ja̱pi núꞌʉ yá mɛti Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nja̱pi núꞌʉ toꞌo tu yá mʉi; núꞌʉ́ go gueꞌʉ ma da thuꞌmba yá mʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nja̱pi núꞌʉ toꞌo tsɛtatho gatho núꞌa̱ te epabi; núꞌʉ́ go gueꞌʉ ma da tꞌumbabi ra ximhai pa go dyá mɛtiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nja̱pi núꞌʉ toꞌo ne da ꞌyøtꞌe núꞌa̱ xá hño con gatho yá mʉi; núꞌʉ́ go gueꞌʉ da umba Ajua̱ ngu núꞌa̱ neꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nja̱pi núꞌʉ toꞌo ja yá nthecate; núꞌʉ́ ma da zʉtua rá nthecate Ajua̱ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nja̱pi núꞌʉ toꞌo xá ntꞌaxi yá mfeni; núꞌʉ́ ma da hyanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nja̱pi núꞌʉ toꞌo utua yá miquꞌeiui hanja da ꞌmʉi te rá entho; núꞌʉ́ go gueꞌʉ ma da thuꞌmbabi dyá ba̱tsi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nja̱pi núꞌʉ toꞌo thogui ya ntꞌʉtsate ngueꞌa̱ øtꞌe núꞌa̱ xá hño; núꞌʉ́ go gueꞌʉ ma da ꞌmʉi habʉ ri manda Ajua̱, ne da hña̱niꞌʉ gatho ya ja̱pi núꞌʉ yá mɛti Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ha nuꞌahʉ́ Ajua̱ da ja̱pꞌaꞌihʉ ora tsañꞌahʉ ya ja̱ꞌi ne ʉtsaꞌihʉ ne jʉꞌtsꞌahʉ ya ncꞌuamba ngueꞌa̱ guí tɛngaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xi da johyahʉ ngueꞌa̱ Ajua̱ ma da ꞌraꞌahʉ ꞌnara da̱nga tha̱ha̱ nuni mahetsꞌi. Njabʉ nehe bi tꞌʉtsa yá ꞌmɛhni Ajua̱ núꞌʉ mi ꞌbʉi ante de gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nuꞌahʉ guí njahʉ ngu ra u ri cʉqui habʉ tꞌʉꞌtsi, ngueꞌa̱ guí utuahʉ ra hoga ntꞌudi ri miquꞌeihʉ. Ha nuꞌbʉ ra u di otho rá ꞌñu, nuꞌbʉ́ ¿hanja strá cʉhi ꞌbʉ? Nuꞌa̱ ga øthʉ, ga føthʉbʉ pa da netꞌa ya ja̱ꞌi ngueꞌa̱ hinte ri muui. ");
INSERT INTO oteNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nuꞌahʉ guí njahʉ ngu ꞌnara ñotꞌi grí yoꞌtuahʉ ri miquꞌeihʉ. Nja ngu ꞌnara hnini bí tø maña̱ de ꞌnara tꞌøhø hinda za da tꞌa̱gui, njabʉ nuꞌahʉ nehe, hinda za gui ꞌña̱guihʉ ra hogaꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nehe ꞌbʉ ga tsøguehʉ ꞌnara ñotꞌi ne ga coꞌmhʉ co ꞌnara caho, nuꞌbʉ́ hinte da yotꞌi. Pe nuꞌbʉ ga tøtehʉ habʉ ga tøtehʉ, nuꞌbʉ́ ha̱, da yotꞌi gatho mbo ra ngu. ");
INSERT INTO oteNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nehe njahʉbʉ gui udihʉ ꞌnara hogaꞌmʉi ja yá thandi ri miquꞌeihʉ pa da hyantꞌa ri hogaꞌmʉihʉ, ne njabʉ nuꞌʉ́ da nsunda Ajua̱ ra Dada núꞌa̱ bí ꞌbʉi mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Oguí beñhʉ gue stá ehe pa ga huata ra ley núꞌa̱ bi zogui ra Moise, nixi pa ga huata núꞌa̱ bi ꞌyofo maꞌra yá ꞌmɛhni Ajua̱ ma Dada. Nuga stá ehe pa ga øtꞌe gatho núꞌa̱ bi ꞌyofoꞌʉ, ne pa ga xiꞌahʉ te rí bønga núꞌa̱ bi ꞌyofoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Xi majua̱ni dí xiꞌahʉ gue hinda nhuata mahetsꞌi ni ra ximhai asta gueꞌbʉ hinda tꞌøtꞌe gatho núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo, ni ꞌnara noya ni ꞌnara letra hinda ma da gotho. ");
INSERT INTO oteNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nuꞌa̱ tóꞌo hinda ꞌyøtꞌa gatho nuya hmanda ma̱nga ra Ma̱ca Tꞌofo, masque núꞌʉ xi ya tꞌʉca hmanda, ne njabʉ nehe da ꞌñutua maꞌra ya ja̱ꞌi pa hinda ꞌyøtꞌe, núꞌa̱ ra ja̱ꞌiꞌa̱ hinte ma da muui ja rá hmanda Ajua̱. Pe nuꞌa̱ tóꞌo da ꞌyøtꞌa gatho nuya ya hmanda ne njabʉ da ꞌñutua maꞌra ya ja̱ꞌi pa da ꞌyøtꞌe, núꞌa̱ ra ja̱ꞌiꞌa̱ ma da muui ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dí xiꞌahʉ, oxqui ma gui øthʉ ngu øtꞌa ya fariseo ne ya xahnate de ra ley, núꞌʉ́ hu yá mʉi gue øtꞌa gatho núꞌa̱ ma̱nga ra ley pe ya yohmi, ngueꞌa̱ njabʉ hinda za gui ꞌbʉhʉ ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ya xa tꞌuꞌtꞌahʉ ngu núꞌa̱ xqui tꞌutuabi ndu ri xitahʉ mayaꞌbʉ, gue oxqui hñotehʉ, ngueꞌa̱ nuꞌa̱ tóꞌo hote ma da duxa ra tsꞌoqui ne pɛꞌtsi te da da̱di. ");
INSERT INTO oteNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pe nuga dí xiꞌahʉ gue nuꞌa̱ tóꞌo da bø rá cuɛ co rá miquꞌeiui, núꞌá̱ ya bi duxa ra tsꞌoqui ne pɛꞌtsi te da da̱di. Ne nuꞌa̱ tóꞌo da zanga rá miquꞌeiui ne da ꞌñembi gue ra ꞌbɛmfeni, núꞌá̱ ya bi duxa ra tsꞌoqui ne pɛꞌtsi te da da̱di ja ra tsꞌʉtbi. Y nuꞌa̱ tóꞌo ri ʉtsa rá miquꞌeiui ne ni pa dí hyandi ne da ꞌñembi gue hinte rá fa̱di, núꞌá̱ ma dí gutꞌi ja ra nidu habʉ bí zø ra tsibi pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ꞌBʉ ꞌna de gueꞌahʉ gui ha̱mpahʉ ꞌnara ꞌbaha Ajua̱ ja ra nija̱ ne ja gui beñhʉni gue xcá tsøꞌtuahʉ rá mʉi ꞌnari miquꞌeihʉ, ");
INSERT INTO oteNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ja da tsohʉni hma̱ha̱ ri ꞌbahahʉ ne penjʉ rí maha gui ꞌyaphʉ ra pumbate ri miquꞌeihʉ, ne nuꞌbʉ́ ha̱, bá e gui umfʉ ri ꞌbahahʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nuꞌbʉ ꞌnari ncontrahʉ da ña̱pꞌahʉ ne da zixꞌahʉ ja ra tsꞌʉtbi, cohʉ ꞌnara cohi ja ra ꞌñu pa ya hingui tsøñhʉ ja ra nzaya, ngueꞌa̱ nuꞌbʉ gui tsøñhʉni da mandaꞌa̱ da joꞌahʉ fadi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Majua̱ni dí xiꞌahʉ gue hinda za gui pøñhʉ de ra fadi asta hingui juthʉ gatho ra thai núꞌa̱ guí tuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ya xa tꞌuꞌtꞌahʉ ngu núꞌa̱ xqui tꞌutuabi ndu ri xitahʉ mayaꞌbʉ, gue oxqui nzinga medintha̱tihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pe nuga dí xiꞌahʉ gue nuꞌa̱ tóꞌo da hyanda ꞌnara ꞌbɛhña̱ ne da hyøque, ya bi duxa ra tsꞌoqui, ja ra uɛnda ya bi zinga ꞌnara medintha̱ti masque hønsɛ te bi beni de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ꞌBʉ nuri dahʉ ra ꞌñɛi da jaꞌahʉ gui ꞌyøthʉ ꞌnara tsꞌoqui, maꞌna xá hño gui hña̱ihʉ ne gui føthʉbʉ pa hingui ꞌyøthʉ ꞌnara tsꞌoqui. Ngueꞌa̱ maꞌna xá hño da ꞌmɛdi ꞌna xɛni de ri ndoꞌyohʉ que da tꞌɛntꞌa gatho ri ndoꞌyohʉ ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ꞌBʉ nuri ꞌyɛhʉ ra ꞌñɛi da jaꞌahʉ gui ꞌyøthʉ ꞌnara tsꞌoqui, maꞌna xá hño gui hyɛcjʉ ne gui føthʉbʉ pa hingui ꞌyøthʉ ꞌnara tsꞌoqui. Ngueꞌa̱ maꞌna xá hño da ꞌmɛdi ꞌna xɛni de ri ndoꞌyohʉ que da tꞌɛntꞌa gatho ri ndoꞌyohʉ ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ya xa tꞌuꞌtꞌahʉ ngu núꞌa̱ xqui tꞌutua ndu ri xitahʉ mayaꞌbʉ, gue nuꞌa̱ tóꞌo da hyɛpʉ rá ꞌbɛhña̱ mahyoni da hoca ꞌnara hɛꞌmi dega nxuni. ");
INSERT INTO oteNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pe nuga dí xiꞌahʉ gue nuꞌa̱ tóꞌo da hyɛpʉ rá ꞌbɛhña̱ ne hinxa dimba ꞌnara tsꞌoqui xa ꞌyøtꞌe co maꞌna ra ja̱ꞌi, nuꞌbʉ́ nurá da̱meꞌa̱ ri japi da ꞌyøtꞌa ꞌnara tsꞌoqui ꞌbʉ da hñuxui maꞌna ra ꞌñøhø. Nehe nura ꞌñøhø toꞌo da ntha̱tui nura ꞌbɛhña̱ꞌa̱, ya ra zinga medintha̱ti. ");
INSERT INTO oteNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nehe ya xa tꞌuꞌtꞌahʉ ngu núꞌa̱ xqui tꞌutua ndu ri xitahʉ mayaꞌbʉ, gue oxqui jurahʉ núꞌa̱ hingo majua̱ni, ngueꞌa̱ núꞌa̱ guí jurahʉ ja rá thandi Ajua̱ pɛꞌtsi te gui ꞌyøthʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pe nuga dí xiꞌahʉ, oxqui jurahʉ de ꞌna ni de maꞌna, nixi por mahetsꞌi ngueꞌa̱ ja bí ꞌbʉhni Ajua̱, ");
INSERT INTO oteNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nixi po ra ximhai ngueꞌa̱ ja guecua netꞌa Ajua̱, nixi por Jerusale ngueꞌa̱ go gueꞌa̱ rá ma̱ca hnini ra Nda̱ de mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nixi gui jurahʉ po ri ña̱xuhʉ, ngueꞌa̱ hinda za gui japhʉ ni ꞌnari sta̱hʉ da tꞌaxqui o da poꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hingue mahyoni gui jurahʉ. ꞌBʉ gui ma̱ñhʉ ra hña̱ ha̱, nuꞌbʉ hina hina, ngueꞌa̱ ꞌbʉ gui jurahʉ go bí ehe de ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ya xa tꞌuꞌtꞌahʉ ngu núꞌa̱ xqui tꞌutua ndu ri xitahʉ mayaꞌbʉ, gue nuꞌa̱ tóꞌo da zɛmba rá da ꞌna, neheꞌa̱ da tsꞌɛmba rá da, y nuꞌa̱ tóꞌo da doꞌtua ꞌnará tsꞌi ꞌna, neheꞌa̱ da thoꞌtua ꞌnará tsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pe nuga dí xiꞌahʉ, oxqui nøꞌtuabihʉ ya tsꞌoꞌmʉi. Nuꞌbʉ da mɛꞌtꞌahʉ ri hmihʉ ra ꞌñɛi, umfʉ nehe ra nga̱ha̱ da mɛꞌtꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ꞌBʉ ꞌnara ja̱ꞌi da ne da ña̱pꞌaꞌi pa da hña̱nꞌa ri pahnihʉ, umfʉ ri patꞌihʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ꞌBʉ ꞌnara ja̱ꞌi da ne da tuꞌtꞌahʉ ꞌnara ꞌbatsꞌi pa gui ꞌyohʉ ꞌna kilometro, hña̱ꞌtsuahʉ maꞌna kilometro. ");
INSERT INTO oteNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ꞌBʉ ꞌnara ja̱ꞌi te da ꞌyaꞌahʉ, umfʉ, ne ꞌbʉ ꞌnara ja̱ꞌi da ne te gui hmiphʉ, oxqui cømbahʉ, hmiphʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ya xa tꞌuꞌtꞌahʉ ngu núꞌa̱ xqui tꞌutua ndu ri xitahʉ mayaꞌbʉ, gue gui ma̱dihʉ ri miquꞌeihʉ ne gui ʉtsahʉ núꞌʉ toꞌo ri ʉtsaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pe nuga dí xiꞌahʉ gue gui ma̱dihʉ núꞌʉ toꞌo ri ʉtsaꞌihʉ. ꞌYaphʉ Ajua̱ da ja̱pi núꞌʉ toꞌo tsañꞌahʉ. ꞌYøꞌtuahʉ ra hño núꞌʉ toꞌo ʉtsaꞌihʉ, ne ꞌyapabihʉ Ajua̱ po núꞌʉ toꞌo nøñꞌahʉ ne ɛcꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ngueꞌa̱ nuꞌbʉ gui øthʉ njabʉ, nuꞌbʉ́ ha̱, grí hña̱tsꞌihʉ Ajua̱ ra Dada bí ꞌbʉi mahetsꞌi núꞌa̱ toꞌo ri japi da bøxa ra hyadi pa ya hoja̱ꞌi ne pa ya tsꞌoꞌmʉi, ne ri japi da ꞌua̱i pa ya hoja̱ꞌi ne pa ya tsꞌoꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ꞌBʉ grí ma̱dihʉ hønsɛ núꞌʉ toꞌo ri ma̱ꞌahʉ, ne nu maꞌra ya ja̱ꞌi hingrí ma̱dihʉ, hinte ma tha̱ha̱ ma gui hña̱nihʉ. ¿Ha gue hingui øtꞌa njabʉ ya tsꞌoꞌmʉi gá ja̱ꞌi nehe? ");
INSERT INTO oteNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ꞌBʉ hønsɛ ri cuhʉ guí zɛnguahʉ ne nu maꞌra ya ja̱ꞌi hingui umfʉ ra nzɛngua, ¿te ma hño guí øthʉ ꞌbʉ? ¿Ha gue hingui øtꞌa njabʉ nehe núꞌʉ hingyá gamfri? ");
INSERT INTO oteNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mahyoni gui hñoja̱ꞌihʉ con gatho ri miquꞌeihʉ, ngu Ajua̱ ra Dada bí ꞌbʉi mahetsꞌi ra hoja̱ꞌi con gathoguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ꞌYøthʉ ya hoga ꞌbɛfi, pe oguí øthʉ pa gui pønga ri hmihʉ, ngueꞌa̱ ꞌbʉ gui øthʉ njabʉ, hinte ma tha̱ha̱ da ꞌraꞌahʉ Ajua̱ ra Dada núꞌa̱ bí ꞌbʉi mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hangue ora guí uñhʉ ꞌnara mfatsꞌi pa ya hyoya, oguí xiphʉ maꞌra te xcá øthʉ ngu øtꞌa ya ꞌñetsꞌi. Núꞌʉ́ ne dra zʉntꞌua ra trompeta ja yá thandi, ja ya nija̱ ne ja ya tai pa da pønga yá hmi. Xi majua̱ni dí xiꞌahʉ gue nuꞌʉ øtꞌa njabʉ ya bi hña̱nga yá tha̱ha̱, hangue ya hinte ma tha̱ha̱ tøꞌmi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pe nuꞌahʉ́, ꞌbʉ gui uñhʉ ꞌnara mfatsꞌi pa ya hyoya, osti pa̱di ri ꞌyɛhʉ ra nga̱ha̱ te pɛ ri ꞌñɛihʉ. Pa̱sɛhɛhʉ, oto xqui petuahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ha masque mantꞌa̱gui gui unga ri mfatsꞌihʉ, pa̱hʉ gue Ajua̱ ra Dada handi te xcá øtꞌehʉ mantꞌa̱gui, y nuꞌá̱ ma da guꞌtꞌahʉ, pe hinda guꞌtꞌahʉ mantꞌa̱gui. ");
INSERT INTO oteNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ora guí aphʉ Ajua̱, oxqui ꞌyaphʉ ja yá thandi ya ja̱ꞌi ngu øtꞌa ya ꞌñetsꞌi pa da pønga yá hmi. Nuꞌʉ́ ri ho da ꞌyapa Ajua̱ má ꞌbai ja ya nija̱ ne ja ya tai. Xi majua̱ni dí xiꞌahʉ, ya bi hña̱nga yá tha̱ha̱, hangue ya hinte ma tha̱ha̱ tøꞌmi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pe nuꞌahʉ́, ora guí aphʉ Ajua̱, cʉthʉ mbo ri nguhʉ ne gui cotꞌa ri gosthihʉ, ne njabʉ ha̱, gui ꞌyaphʉ Ajua̱ ra Dada núꞌa̱ ꞌbʉi habʉ hindi hnequi. Y nuꞌá̱ da ꞌyøde núꞌa̱ guí aphʉ mantꞌa̱gui, ne ma da guꞌtꞌahʉ, pe hinda ma da guꞌtꞌahʉ mantꞌa̱gui. ");
INSERT INTO oteNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ora guí aphʉ Ajua̱, oxi xqui yoptahʉ ya noya ngu øtꞌa núꞌʉ maꞌra ya ja̱ꞌi hingyá gamfri, ngueꞌa̱ nuꞌʉ́ hu yá mʉi gue ꞌbʉ da ꞌyøtꞌa njabʉ, Ajua̱ da ꞌyøde ne da umbabi núꞌa̱ adiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pe nuꞌahʉ́ oxqui ma gui njahʉbʉ ngu øtꞌeꞌʉ, ngueꞌa̱ Ajua̱ ra Dada ya pa̱di te øꞌtꞌahʉ ra ꞌbɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nuꞌahʉ́ ꞌyaphʉ Ajua̱ njaua: Ma zi Dadaꞌihe guí ꞌbʉi mahetsꞌi, drá nsunda ri ma̱ca thuhu. ");
INSERT INTO oteNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bá ehe gui nda̱, ne dá tꞌøtꞌa ri paha nuua ja ra ximhai ngu bí tꞌøtꞌe nubʉ mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ꞌRacje te ga tsihe nubya rapaya. ");
INSERT INTO oteNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ne pungaguihe ma thaihe ngu dí pumbahe nehe núꞌʉ toꞌo tucje. ");
INSERT INTO oteNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne oxqui hocje ga øthe ya tsꞌoqui. Ña̱ngaguihe de ra ntsꞌo, ngueꞌa̱ go gueꞌe grá nda̱, ne ja ri tsꞌɛdi ne ri nsunda pa nza̱ntho. Njabʉ gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nuꞌbʉ gui pumbahʉ núꞌʉ toꞌo øꞌtꞌahʉ ra ntsꞌoꞌmʉi, Ajua̱ ra Dada bí ꞌbʉi mahetsꞌi nehe ma da punꞌa ri tsꞌoquihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pe ꞌbʉ hingui pumbahʉ núꞌʉ toꞌo øꞌtꞌahʉ ra ntsꞌoꞌmʉi, nuꞌbʉ́ nixi Ajua̱ ra Dada hinda punꞌaꞌihʉ ri tsꞌoquihʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ora grí ayunahʉ, oguí øtꞌehʉ co ra dumʉi ngu øtꞌa ya ꞌñetsꞌi pa da fa̱di gue ri ayuna. Majua̱ni dí xiꞌahʉ gue ya bi hña̱nga yá tha̱ha̱, hangue ya hinte ma tha̱ha̱ tøꞌmi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pe nuꞌahʉ́, ora grí ayunahʉ, eca ri ña̱xuhʉ ne xʉca ri hmihʉ ngu xcá nza̱ihʉ, ");
INSERT INTO oteNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pa hinda fa̱di ua grí ayunahʉ. Hønsɛ Ajua̱ ra Dada núꞌa̱ ꞌbʉi habʉ hindi hnequi, go gueꞌa̱ da ba̱di núꞌa̱ guí øtꞌasɛhɛhʉ. Nuꞌá̱ go handi núꞌa̱ guí øthʉ mantꞌa̱gui, y ma da guꞌtꞌahʉ, pe hinda ma da guꞌtꞌahʉ mantꞌa̱gui. ");
INSERT INTO oteNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Oguí nehʉ gui pɛꞌtshʉ ndunthi ya hño nuua ja ra ximhai habʉ da zipꞌahʉ ya zuꞌue ne da decꞌahʉ ra mboxcua ne da bepꞌahʉ ya be. ");
INSERT INTO oteNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pɛꞌtsa ri hñohʉ nuni mahetsꞌi habʉ bí joꞌo ya zuꞌue, ne otho ra mboxcua, nixi ya be hinda za da yʉtꞌini da bepꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngueꞌa̱ habʉ guí pɛꞌtsa ri hñohʉ, ja guehni oda ri mfenihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nuri dahʉ go gueꞌʉ di yotꞌa gatho ri ndoꞌyohʉ. Hangue nuꞌbʉ ri dahʉ ꞌbʉi xá hño, nuꞌbʉ́ di yotꞌa xá hño gatho ri ndoꞌyohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pe nuꞌbʉ ri dahʉ hingui ꞌbʉi xá hño, nuꞌbʉ́ gatho ri ndoꞌyohʉ ꞌbʉi ja ra ꞌbɛxuui. Nehe guí njahʉbʉ guí ꞌbʉhʉ ja ra ꞌbɛxuui ꞌbʉ hinguí huxa ri thandihʉ xá hño ja Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hinda za gui pɛphʉ yoho ya hmu, ngueꞌa̱ njabʉ ꞌna grí ʉtsahʉ ha nu maꞌna guí ma̱dihʉ, y ꞌna de gueꞌʉ guí pɛphʉ xá hño ha nu maꞌna hina. Njabʉ nehe hinda za gui pɛphʉ Ajua̱ ꞌbʉ hønsɛ oda ri mfenihʉ ya hño de ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Hangue dí xiꞌahʉ oguí tu ri mʉihʉ ꞌbʉ otho te gui tsihʉ ne ꞌbʉ otho te gui hyehʉ, ngueꞌa̱ maꞌna ri muui da ꞌyoda ri mfenihʉ Ajua̱ que da ꞌyoda ri mfenihʉ núꞌa̱ te gui tsihʉ ne núꞌa̱ te gui hyehʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hyanthma̱hʉ ya zi tsꞌintsꞌʉ, nuꞌʉ́ hingui potꞌi nixi xofo ni pɛꞌtsa yá ꞌmɛꞌtsi, pe Ajua̱ ra Dada go gueꞌa̱ umbi te da ziꞌʉ. Xihma̱ꞌihʉ, ¿ha gue hingue maꞌna gyá hma̱dihʉ que gueꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Toꞌo ꞌna de gueꞌahʉ tsa gui japhʉ maꞌna strá hñetsꞌi ri ndoꞌyohʉ co ri mfenisɛhɛhʉ? Joꞌo ni ꞌna. ");
INSERT INTO oteNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nuꞌbʉ́, ¿hanja guí tu ri mʉihʉ ꞌbʉ otho te gui hyehʉ? Hyanthʉ hanja gra nhye ya zi døni ꞌbai ja ra mbonthi y joꞌo toꞌo ri jamasu. Nuꞌʉ́ hindi mpɛfi nixi tu yá mʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dí xiꞌahʉ gue nixi ra nda̱ Salomó masque mi he ya hoga he ne xi mi jababi, pe hintsꞌʉ mi hnequi mahothoꞌa̱ ngu ya zi døni. ");
INSERT INTO oteNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ꞌBʉ Ajua̱ heta ya døni de ra mbonthi núꞌʉ xá ncꞌamibya pe dixudi ya da ꞌyotꞌi nepʉ da tsꞌa̱tꞌi, xi nuꞌahʉ, ¿hanja hinguí camfrihʉ gue Ajua̱ maꞌna da jamasuꞌihʉ que ya døni? ");
INSERT INTO oteNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hangue odi tu ri mʉihʉ gui ꞌñeñhʉ: “¿Te ga tsihʉbya? o ¿te ga hehʉbya?” ");
INSERT INTO oteNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ngueꞌa̱ nuya ꞌña̱gamfri nza̱ntho tu yá mʉi ꞌbʉ othobi te da zi ne te da hye. Pe nuꞌahʉ odi tu ri mʉihʉ, ngueꞌa̱ Ajua̱ ra Dada bí ꞌbʉ mahetsꞌi ya go pa̱ꞌa̱ te gatho øꞌtꞌahʉ ra ꞌbɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hyoñhʉ ꞌmɛtꞌo hanja da za gui ꞌbʉhʉ xá hño ja rá hmanda Ajua̱ ne gui ꞌyohʉ ngu núꞌa̱ ri hoꞌa̱, y njabʉ Ajua̱ hinda ꞌbɛꞌtꞌahʉ gatho núꞌa̱ te guí hoñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hangue oguí tu ri mʉihʉ de núꞌa̱ te da ꞌñeꞌahʉ dixudi, nguetho nuꞌbʉ gui pa̱hma̱hʉ te ꞌbɛ gui thohʉ dixudi, nuꞌbʉ́ maꞌna da du ri mʉihʉ, ngueꞌa̱ hyastho dí thohʉ te dí thohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Oguí ꞌyøhʉ ri miquꞌeihʉ pa njabʉ hinto da ꞌyøꞌaꞌihʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngueꞌa̱ ꞌbʉ guí ꞌyøhʉ ri miquꞌeihʉ, nuꞌbʉ́ Ajua̱ ma da hña̱pꞌahʉ nguɛnda de gatho núꞌa̱ ri ꞌñøtehʉ ne hinda yo rá mʉiꞌa̱ de gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nuꞌahʉ́ guí ꞌyøhʉ de núꞌa̱ øtꞌa ri miquꞌeihʉ, ¿hanja hingo guí jamasuhʉ núꞌa̱ te guí øtquꞌehʉ? Nuꞌahʉ́ go guí hanthʉ nura tꞌʉca paxi o ja rá da ri miquꞌeihʉ, ¿hanja hingo guí hanthʉ núꞌa̱ ra xɛca za o ja ri dahʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Hanja da za gui ꞌñemfʉ ri miquꞌeihʉ: “Hoqui ga ha̱pꞌa ra paxi o ja ri da,” ꞌbʉ hingo xcá ha̱hʉ ꞌmɛtꞌo núꞌa̱ ra xɛca za o ja ri dahʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nuꞌahʉ gyá ꞌñetsꞌihʉ, go da hña̱ihʉ ꞌmɛtꞌo núꞌa̱ ra xɛca za o ja ri dahʉ, pa njabʉ maꞌna gui hyanthʉ xá hño pa gui hña̱mfʉ núꞌa̱ ra paxi o ja rá da ri miquꞌeihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Oxqui umfʉ ra ma̱ca noya núꞌʉ ya ja̱ꞌi hingui pa̱ da su, ngueꞌa̱ nuꞌʉ́ nja ngu ya zate tsatꞌyo ne da ꞌyøꞌtꞌahʉ ra ntsꞌoꞌmʉi, nehe nja ngu ya tsꞌʉdi tsꞌontho núꞌa̱ tꞌumbi. ");
INSERT INTO oteNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ꞌYadihʉ ne da tꞌaꞌahʉ. Hyonihʉ ne gui tsʉdihʉ. Oxqui tsaya gui ꞌyapabihʉ Ajua̱ y nuꞌá̱ ma da ꞌyøde ri ntꞌadihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngueꞌa̱ nuꞌa̱ tóꞌo adi da tꞌumbabi, ne nuꞌa̱ tóꞌo honi da zʉdi, y nuꞌa̱ tóꞌo apabi Ajua̱ da ꞌyøtua rá ntꞌadi. ");
INSERT INTO oteNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Toꞌo ꞌna de gueꞌahʉ núꞌahʉ gyá dadahʉ ꞌbʉ ri ba̱tsihʉ da ꞌyaꞌahʉ ꞌnara thuhme y go gui umfʉ ꞌnara do? Joꞌo. ");
INSERT INTO oteNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O ꞌbʉ da ꞌyaꞌahʉ ꞌnara hua̱ y go gui umfʉ ꞌnara quꞌeña̱? Hina ¿ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tsatho nuꞌahʉ́ xi gyá tsꞌoꞌmʉihʉ pe guí pa̱hʉ gui umfʉ te da zi xá hño ri ba̱tsihʉ, xihma̱ Ajua̱ ra Dada bí ꞌbʉi mahetsꞌi, ¿ha gue hinda ꞌraꞌahʉ gatho núꞌa̱ xá hño ꞌbʉ gui apabihʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nuꞌa̱ guí nehʉ da ꞌyøꞌtꞌahʉ ya ja̱ꞌi, ꞌyøꞌtuahʉ njabʉ neheꞌʉ. Guehna ma̱nga njabʉ núꞌa̱ bi ꞌyofo ra Moise ne núꞌa̱ bi ꞌyofo núꞌʉ maꞌra yá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Cʉthʉ ja ra gosthi núꞌa̱ xá ntsꞌiꞌmi pa grí maha habʉ ja ra te pa nza̱ntho. Ngueꞌa̱ nuꞌʉ tóꞌo cʉtꞌa ja ra gosthi xá ngʉni gueꞌʉ rí ma ja ra nidu, y nura ꞌñu de núꞌa̱ ra gosthiꞌa̱ xi rá ngʉni, y ndunthi toꞌo cʉtꞌa ja nura gosthiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pe xi rá ntsꞌiꞌmi nura gosthi habʉ cʉtꞌi núꞌʉ toꞌo rí ma ja ra te, y nura ꞌñu de núꞌa̱ ra gosthiꞌa̱ xi rá ntsꞌiꞌmi, ha tsꞌʉtho núꞌʉ toꞌo cʉtꞌa ja nura gosthiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jamasuhʉ hinda tsꞌocꞌa ri mfenihʉ núꞌʉ ri ꞌñetꞌa mɛfi de Ajua̱, núꞌʉ ma da ꞌñepʉ pa da ne da hyaꞌahʉ, ngueꞌa̱ nuꞌʉ́ ri ꞌñetꞌa hoja̱ꞌi ne ri ꞌyo ngu ya zi dɛti, pe de mbo yá mfeni nja ngu ra dumanthuhu gá miꞌño. ");
INSERT INTO oteNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nuꞌahʉ ma gui pa̱hʉ toꞌoꞌʉ ngueꞌa̱ da hnequi ja yá tsꞌoꞌbɛfi øtꞌeꞌʉ. Ngueꞌa̱ nuya tsꞌoꞌmʉi hingui tsa da ꞌñudi ya hoga ꞌbɛfi, nja ngu ya xinꞌmini hingui tsa da unga ya obxi, ne ya ꞌbintꞌo hingui tsa da unga ya igo. ");
INSERT INTO oteNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gatho ya hoga ꞌbai gá za unga ya hoga fruta, pe nuya tsꞌo ꞌbai gá za hingui tsa da unga ya hoga fruta. ");
INSERT INTO oteNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Y ꞌnara hoga ꞌbai gá za hingui tsa da unga núꞌa̱ hingrá hoga fruta, nixi núꞌa̱ hingrá hoga ꞌbai gá za hingui tsa da unga ya hoga fruta. ");
INSERT INTO oteNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y gatho nuya ꞌbai gá za hingui unga ya hoga fruta ma da tsꞌɛtꞌi ne da tsꞌa̱tꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Y njabʉ ma gui pa̱hʉ toꞌo gueꞌʉ ri ꞌñetꞌa mɛfi de Ajua̱ co nuyá tsꞌoꞌbɛfi di øtꞌeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ꞌBʉi ndunthi toꞌo engagui: “Ma zi Hmuꞌi, ma zi Hmuꞌi”, pe nuꞌʉ́ hinda za da yʉtꞌa mahetsꞌi habʉ bí manda Ajua̱ ma Dada ꞌbʉ hinda ꞌyøꞌtua rá pahaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nu sta zø rá nga̱tsꞌi ra pa ndunthi ma da ꞌñengagui: “Ma zi Hmuꞌihe, ma zi Hmuꞌihe, nuje dá xañhe ri noya, ne co ri tsꞌɛdigue dá ɛñhe ya tsꞌonda̱hi, ne co ri tsꞌɛdigue dá øthe ndunthi ya da̱nga ntꞌudi.” ");
INSERT INTO oteNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pe nuga ma ga tha̱tuabiꞌʉ ne ga embabi: “Hinstá pa̱ꞌagahʉ, ꞌuehʉ de gueque núꞌahʉ gyá tsꞌoja̱ꞌihʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nuꞌa̱ tóꞌo da ꞌyøde nuya ya noya dí xiꞌahʉ ne da ꞌyøtꞌe njabʉ, núꞌá̱ ri nhyɛcuaui ꞌnara ja̱ꞌi xi bi nja rá mfeni bi hyoca rá ngu ja ra medo. ");
INSERT INTO oteNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ne ꞌmɛfa bi da ndunthi ya da̱ꞌye, bi zø ya nzøthe, bi nja ndunthi ya bʉnthi, pe nurá nguꞌa̱ himbi yøtꞌe ngueꞌa̱ xqui hyoca ja ra medo. ");
INSERT INTO oteNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pe nuꞌa̱ tóꞌo da ꞌyøde nuya ya noya ne hinda ꞌyøtꞌe, núꞌá̱ ri nhyɛcuaui ꞌnara ja̱ꞌi núꞌa̱ bi ꞌñotho rá mfeni bi hyoca rá ngu ja ra ꞌbomu. ");
INSERT INTO oteNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ne ꞌmɛfa bi da ndunthi ya da̱ꞌye, bi zø ya nzøthe, bi nja ndunthi ya bʉnthi, nepʉ nurá nguꞌa̱ bi yøtꞌe ne bi ꞌmɛdi gatho. ");
INSERT INTO oteNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ha nu mi uadi ra Jesu bi ma̱nga nuya ya noya, nuya ja̱ꞌi xi bi ꞌyø ntsꞌɛdi de núꞌa̱ xqui xipabiꞌʉ, ");
INSERT INTO oteNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ngueꞌa̱ mi zofoꞌʉ co rá tsꞌɛdi Ajua̱, hingue ngu mi øtꞌa ya xahnate de ra ley. ");
INSERT INTO oteNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nu mi ga̱i ra Jesu de ja ra tꞌøhø habʉ mi utuate, xi bi dɛna ndunthi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne bi nthɛui ꞌnara ja̱ꞌi mi tsʉ ꞌnara hñeni rá thuhu ra lepra núꞌa̱ tsitꞌatho ra ngø. Nura ja̱ꞌiꞌa̱ bi ndandiña̱hmu ja rá ua ra Jesu ne bi ꞌñembi: ―Ndada, ꞌbʉ gui nehma̱, da za gui ꞌyøthegui. ");
INSERT INTO oteNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nuꞌbʉ́ ra Jesu bi hñuxa rá ꞌyɛ ne bi ꞌñembi: ―Ha̱ha̱ dí ne ga øtheꞌi, y ya gá ña̱ni. Y ngu bi uadi bi ma̱nga njabʉ, ꞌbestho bi ña̱ni ra daꞌthi. ");
INSERT INTO oteNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nepʉ ra Jesu bi ꞌñembi: ―Oto xqui ma gui xipi. Rí ma ja ra nija̱ ha̱, pa da hyantꞌa ra macja̱, ne gui unga ri ꞌbaha núꞌa̱ bi ma̱nga ra Moise, pa njabʉ da ba̱di ya ja̱ꞌi gue ya xcá ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nepʉ ra Jesu bi yʉtꞌi ja ra hnini Ncapernau y ja bi nthɛuini ꞌnara nda̱ gá soldado de ra hai Nroma. ");
INSERT INTO oteNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Y nura nda̱ꞌa̱ bi ba̱ntebi ra Jesu ne bi ꞌñembi: ―Ndada, ꞌnama ꞌbɛgo bi ntsꞌonate ne hingui tsa da ꞌña̱ni, ne xi tsiꞌti. ");
INSERT INTO oteNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nuꞌbʉ́ ra Jesu bi da̱tuabi ne bi ꞌñembi: ―Maha, ma ga øthe. ");
INSERT INTO oteNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nuꞌbʉ́ nura nda̱ gá soldado bi da̱tui ne bi ꞌñembi: ―Hina, hiní ꞌñepcagui gui cʉtꞌa mbo ma ngu. Nugui nuꞌa̱ dí pa̱di gue hønsɛ co ri noya gui ma̱, numa ꞌbɛgo da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngueꞌa̱ nugui ꞌbʉi toꞌo ri mandagui nehe, pe nequi drí manda. Dí pɛꞌtsa ya soldado ja ma hmanda, y ꞌbʉ ga emba ꞌna de gueꞌʉ: “Rí mani”, da ma, o ꞌbʉ ga emba maꞌna: “Bá ehe”, nuꞌá̱ da ꞌñehe. Ha nuꞌbʉ ma ꞌbɛgo ga embi: “Pɛ nuna ꞌbɛfina̱”, nuꞌá̱ da mɛfi. ");
INSERT INTO oteNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mi ꞌyøde njabʉ ra Jesu xi bi ꞌyø ndunthi ne bi ꞌñembabi núꞌʉ mri dɛni: ―Majua̱ni dí xiꞌahʉ, nugui hinstá tsʉdi ni ꞌnara me Israel núꞌa̱ xi di ja rá jamfri ngu nura jamfri pɛꞌtsa nuna ꞌñøhøni. ");
INSERT INTO oteNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Dí xiꞌahʉ gue ndunthi ya ja̱ꞌi maxøgue ra ximhai núꞌʉ hingyá me Israel ma da yʉtꞌa mahetsꞌi habʉ bí manda Ajua̱ ne da hñu ja ra mexa mahyɛgui co ra Abrá, co ra Isaac, ne co ra Cobo. ");
INSERT INTO oteNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pe ya me Israel núꞌʉ rí ꞌñepa hma̱ha̱ da hñu ja ra mexa, Ajua̱ hinda ma da hopi da yʉtꞌa mahetsꞌi. Nuꞌa̱ ma da nja, ma da mɛhniꞌʉ ja ra ꞌbɛxuui, y nuni ja di zohma̱ni ne ja di gusthma̱ni yá tsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nepʉ ra Jesu bi ꞌñemba ra nda̱ gá soldado: ―Rí ma ri ngu ngueꞌa̱ nuri jamfri xa muui ndunthi, ne xa njabʉ ngu xcá ne. Y nurá ꞌbɛgo ra nda̱ gá soldado ꞌbestho bi ña̱ni nura oraꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ꞌMɛfa de gueꞌa̱ ra Jesu bi ma ja rá ngu ra Pedro, y ja mi ꞌbɛnini rá to ra Pedro mi umba ra nzø. ");
INSERT INTO oteNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nepʉ ra Jesu bi hñuꞌtsua rá ꞌyɛ y ꞌbestho bi tsaya ra nzø mi tsʉdi. Nepʉ ꞌbestho bi nangui ra ꞌbɛhña̱ ne bi hyocui te bi ziꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ya de mi putꞌa nde ra Jesu bá tsꞌimpabi ndunthi ya daꞌthi, ꞌra mi pɛꞌtsa ya tsꞌonda̱hi. Y co ꞌnada ra noya bi ma̱ bi ꞌyɛnga núꞌʉ ya tsꞌonda̱hi mi pɛꞌtsiꞌʉ, ne bi ꞌyøthe gatho núꞌʉ toꞌo mi hñeni. ");
INSERT INTO oteNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gatho nuya bi ꞌyøtꞌa ra Jesu pa bi nja ngu núꞌa̱ xqui ma̱nga mayaꞌbʉ ra ba̱di Isaía ja ra Ma̱ca Tꞌofo bi ꞌñena: “Nuꞌá̱ go gueꞌa̱ bi hña̱ga ma hñenihʉ, ne bi hña̱sca gatho ma ʉguihʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ne ꞌmɛfa bi hyanda ra Jesu ndunthi ya ja̱ꞌi xqui theꞌtsiꞌa̱. Nuꞌbʉ́ nuꞌá̱ bi ꞌñemba yá nxadi: ―Maha riꞌnandi ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y ante da maꞌʉ, ꞌnara xahnate de ra ley bi joni habʉ mi ꞌbai ra Jesu ne bi ꞌñembabi: ―Xahnate, nugui dí ne ga tɛnꞌaꞌi pa habʉ gatho gui ma ga ma nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ra Jesu bi da̱tui bi ꞌñembi: ―Ya haho ja yá hña̱do, ne ya tsꞌintsꞌʉ ja yá ꞌbafi, pe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi otho ni habʉ da mɛ rá ña̱xu. ");
INSERT INTO oteNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nepʉ ꞌna de yá nxadi ra Jesu bi ꞌñembi: ―Ma zi Hmuꞌi, ꞌraca nsɛqui ga ma ga agui ma dada, nepʉ ga pengui ga tɛnꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ra Jesu bi da̱tui bi ꞌñembi: ―Bá ehe tɛngagui, tsopʉ núꞌʉ xa du go dá ꞌyagui núꞌʉ yá miꞌña̱gamfriui. ");
INSERT INTO oteNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nepʉ de gueꞌa̱ ra Jesu bi bøxa ja ra motsa co yá nxadi pa bi ma riꞌnandi ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ne de mi ꞌyoꞌʉ ja ra ndehe mi da̱mfriꞌʉ bi nja ꞌnara da̱nga bʉnthi xi ntsꞌɛdi asta mi ne da pʉntsꞌa ra motsa ne mi tontsꞌa ra dehe pa mbo. Ha nura Jesu mi a̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nuꞌbʉ́ yá nxadi ꞌbestho bi ma bá atsꞌi ne bi ꞌñembi: ―Ma zi Hmuꞌihe, ña̱ngaguihe ngueꞌa̱ ya ma da mpʉntsꞌa ra motsa mbo ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Y nuꞌá̱ bi ꞌñembabiꞌʉ: ―¿Pa te guí tsuhʉ? ¿Ha gue otho ri jamfrihʉ? Nuꞌbʉ́ ra Jesu bi ꞌmai pa bi zʉi ra bʉnthi ne ra ndehe. Y ꞌbestho ra oraꞌa̱ bi ntsaya. ");
INSERT INTO oteNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nu mi hyanda njabʉ yá nxadi xi bi ꞌyø ne mi ꞌñémbiꞌʉ: ―¡Te ma tsꞌɛdi ha̱ní gue asta ra nda̱hi ne ra dehe øtua rá noya! ");
INSERT INTO oteNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nepʉ bi zønga ra Jesu riꞌnandi ra ndehe co yá nxadi ja ꞌnara hai rá thuhu Gadara, y ja bi nthɛuini yoho ya ꞌñøhø bi bønga habʉ mi ja ya ntꞌagui. Núꞌʉ ya ꞌñøhøꞌʉ mi pɛꞌtsa ya tsꞌonda̱hi xi xmá ntsꞌo, ha xi mi pite ndunthi, nixi mi tsa to da ꞌranga núꞌa̱ ra ꞌñuꞌa̱ habʉ mi ꞌbʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nuya ꞌñøhøꞌʉ bi ña̱ ntsꞌɛdi ne bi ꞌñemba ra Jesu: ―¿Te guí hongua habʉ dí ꞌbʉhe núꞌi Jesu rá Tꞌʉꞌi Ajua̱? Hingui tsøta ra ora pa gui huatcahe, nuꞌbʉ́ ¿hanja xcá ehe gui xaxcahe? ");
INSERT INTO oteNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Guetbʉ de guehni mi ꞌyoni ꞌna taxꞌo ya tsꞌʉdi mi ñuni. ");
INSERT INTO oteNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Y ya tsꞌonda̱hi bi ꞌyapa nsɛqui ra Jesu ne bi ꞌñembi: ―ꞌBʉ ma gui ꞌyɛnje de guecua, ꞌracje nsɛqui ga cʉthe ja nuyʉ ya tsꞌʉdi bí ꞌyoni. ");
INSERT INTO oteNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nuꞌbʉ́ ra Jesu bi ꞌñembi: ―Ha̱ha̱, rí maha, ja da bá cʉthʉni. Nuꞌbʉ́ ꞌbestho ya tsꞌonda̱hi bi bøni de núꞌʉ yoho ya ꞌñøhø ne bi ma bá cʉtꞌa ja ya tsꞌʉdi. Nepʉ nura oraꞌa̱ gatho ya tsꞌʉdi bi nestꞌihi bi hñøtꞌa ja ꞌnara maꞌye pa bi ma bá zo ja ra ndehe y gatho bi ja̱tꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Y nuya maptsꞌʉdi bi nestꞌihi co ra ntsu asta bi zønga ja ra hnini ne bi xipa ya ja̱ꞌi te bi ꞌyøꞌtua ra Jesu núꞌʉ yoho ya ꞌñøhø xqui ꞌyɛmbabiꞌʉ ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nuꞌbʉ́ gatho ya mengu de núꞌa̱ ra hniniꞌa̱ bi ma bá cꞌa̱ꞌtsa ra Jesu pa bi ꞌyapa ra favo da ma de guehni pa da ma maꞌna ra hnini. ");
INSERT INTO oteNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nuꞌbʉ́ ra Jesu bi yopa bøxa ja ra motsa ne bi ꞌraxa riꞌnandi ra ndehe pa bi yopa menga ja rá hai. ");
INSERT INTO oteNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mi zønga rá hai bi tsꞌiꞌtsua ꞌnara ꞌñøhø mrá tsꞌonate himi tsa da ꞌña̱ni ne xqui tꞌɛntsꞌa ja ꞌnara ꞌbebo. Y nu mi hyanda ra Jesu gue xi mi ja yá jamfri núꞌʉ ya ja̱ꞌi toꞌo mi ndude ra daꞌthi, nuꞌbʉ́ bi ꞌñembabi ra daꞌthi: ―Ma zi tꞌʉꞌi, johyabya ngueꞌa̱ ya stá punꞌaꞌi ri tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nuꞌbʉ́ nu ꞌraya xahnate de ra ley mi ꞌbʉhni bi mʉdi bi benga ya tsꞌomfeni ne mi ꞌñémbi ꞌna ngu maꞌna: “Nuna ꞌñøhøni ri ꞌñetꞌa Ajua̱.” ");
INSERT INTO oteNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ra Jesu bi ba̱tho núꞌa̱ mi beñꞌʉ y bi ꞌñembabi: ―¿Hanja guí beñhʉ núꞌʉ ya tsꞌomfeni de guequi? ");
INSERT INTO oteNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pa guequi hinte rá hñei ga pumba yá tsꞌoqui nuna ꞌñøhø nixi pa ga embi: “Nangui ne ꞌño”. ");
INSERT INTO oteNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pe pa gui pa̱hʉ gue Núꞌa̱ Toꞌo e bi Nja̱ꞌi ja rá tsꞌɛdi nuua ja ra ximhai pa da pumba yá tsꞌoqui ya ja̱ꞌi, ma ga øtꞌa njaua pa gui pa̱hʉ. Nepʉ bi ꞌñemba núꞌa̱ ra daꞌthi: ―Nangui, jʉxa ri mfidi rí ma ri ngu. ");
INSERT INTO oteNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nuꞌbʉ́ ra daꞌthi ꞌbestho bi nangui bi ma rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Y mi hyanda ya ja̱ꞌi núꞌa̱ bi nja, nuꞌʉ́ xi bi ꞌyø, ne bi xøcambeni Ajua̱ ngueꞌa̱ núꞌá̱ xqui umba ra tsꞌɛdi ꞌnara ja̱ꞌi pa bi ꞌyøtꞌe njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nepʉ ra Jesu bi ma de guehni y bi hyanda ꞌnara ꞌñøhø rá thuhu ra Teo mrá ngʉxboja̱ mi hudi ja rá mexa. Y ra Jesu bi ꞌñembabi: ―Bá ehe tɛngagui. Nepʉ ra Teo ꞌbestho bi ꞌmai ne bi dɛniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nepʉ ra Jesu bi ma ja rá ngu ra Teo ne ja bi hñudini bi ñuniui yá nxadi co maꞌra ya ꞌña̱tsa ngʉxboja̱ ne maꞌra ya tsꞌoja̱ꞌi xqui zønini. ");
INSERT INTO oteNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Y mi hyanda ya fariseo gue ra Jesu bi hñuhui bi ñuniui ya tsꞌoja̱ꞌi, nuꞌbʉ́ nuya fariseoꞌʉ bi ꞌyambabi yá nxadi ra Jesu ne bi ꞌñembabi: ―Xi ri xahnatehʉ ¿hanja ri ñuniui gatho nuyʉ ya tsꞌoja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nu mi ꞌyøde ra Jesu bi ma̱nga njabʉ ya fariseo, nuꞌbʉ́ bi ꞌñembabi: ―Nura ja̱ꞌi hinte ma hñeni pɛꞌtsi hingui øtꞌa ra thoni pa ra ꞌñethi, pe nuꞌʉ tóꞌo ri hñeni ha̱, honga ra ꞌñethi. ");
INSERT INTO oteNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Rí ma gui nxadihʉ pa gui pa̱hʉ te ma̱nga ja ra Ma̱ca Tꞌofo nu habʉ bi ꞌñena Ajua̱: “Nugui maꞌna dí ne gui mpɛꞌtsuahʉ ra nthecate ꞌna ngu ꞌna que gui tsincahʉ ya mboꞌni pa gui hyohʉ gui ꞌbahaguihʉ.” Nugui hinstuá ehe pa ga zofo ya hoja̱ꞌi, nugui stuá ehe pa ga zofo ya ꞌyøtꞌatsꞌoqui pa da ñobriꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nepʉ de gueꞌa̱ yá nxadi ra Xuua Xiꞌtsate bi ꞌñehe bi ꞌyambabi ra Jesu ne bi ꞌñembabi: ―¿Hanja nuje ne ya fariseo dí ayunahe ndunthi ya iꞌqui, ha nuri nxadigue hinhyaꞌmʉ ri ayunaꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Y ra Jesu bi ꞌñembi: ―ꞌBʉ da nja ꞌnara ntha̱ti ne ra na̱vio da mbitabi yá amigo, nuyá amigo rí ꞌñepi da johyaui ra na̱vio ne hinda du yá mʉi. Nehe numa nxadi nja ngu nuyá amigo ra na̱vio. Pe sta zø ra pa ga ma de guecua, nuꞌbʉ́ ha̱, da za da ayuna ma amigo co ya dumʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hinxá hño da ꞌbøꞌta ꞌnara zɛdutu co ꞌnara ꞌraꞌyo dutu, ngueꞌa̱ ꞌmɛfa da nuntsꞌa ra ꞌraꞌyo dutu ne da gʉtꞌa ra zɛdutu, nepʉ njabʉ maꞌna da ntʉnga ra zɛdutu. ");
INSERT INTO oteNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nehe hinxá hño da sitꞌa ra vinu ja ꞌnara zɛbota, ngueꞌa̱ nuꞌbʉ di tsɛdi ra vinu, nuꞌbʉ́ da ntʉ́nga ra zɛbota ne núꞌa̱ te di po da mfani ne maꞌna da tsꞌoca ra zɛbota. Hangue mahyoni da sitꞌa ra vinu ja ꞌnara ꞌraꞌyo bota pa njabʉ masque xi di ja rá tsꞌɛdi ra vinu, hinda ntʉ́nga ra bota. ");
INSERT INTO oteNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ngu bi uadi bi ma̱nga njabʉ ra Jesu, bi zøhø habʉ mi ꞌbʉiꞌa̱ ꞌnara nda̱ de ja yá nija̱ ya xodyo, ne bi ndandiña̱hmu ne bi ꞌñembi: ―Dá e ga xiꞌi gue ja tsꞌʉ rí du ma tꞌixu. Hangue dí ba̱nteꞌi gui ma gui hñuꞌtsua tsꞌʉ ri ꞌyɛ pa da yopa nte. ");
INSERT INTO oteNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nuꞌbʉ́ ra Jesu ꞌbestho bi ma co yá nxadi ne bi mɛui núꞌa̱ ra nda̱ꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Y de mi ꞌyoꞌʉ ja ra ꞌñu mi pani ꞌnara ꞌbɛhña̱ mi hena ꞌnara hñeni mi xoꞌtua ya ji y ya mi pɛꞌtsa ꞌrɛtꞌamayoho njɛya mi njabʉ. Nuꞌá̱ bi joni ja rá xʉtha ra Jesu pa bi dʉnbabi rá he. ");
INSERT INTO oteNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngueꞌa̱ mi bensɛ ja rá mfeni nura ꞌbɛhña̱ꞌa̱ ne mi ena: “Dí camfri gue ꞌbʉ hønsɛ ga thʉnbabi rá ña̱ni rá he ga ña̱ni ꞌbestho de ma hñeni.” ");
INSERT INTO oteNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ha ra Jesu bi mpʉntsꞌi bi hyandi ne bi ꞌñembi: ―Ma zi tꞌixuꞌi, johyabya ngueꞌa̱ co ri jamfri xcá ña̱ni. Y nura ꞌbɛhña̱ ꞌbestho bi ña̱ni ra oraꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nepʉ bi zønga ra Jesu co yá nxadi ja rá ngu núꞌa̱ ra nda̱ ja xqui du rá tꞌixu. Y mi ꞌbʉhni ya mɛꞌmda mi pɛꞌmda, ne ndunthi ya ja̱ꞌi xi mi zoni. ");
INSERT INTO oteNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Y ra Jesu bi ꞌñemba ya ja̱ꞌi: ―Pøñhʉ tsꞌʉ pa thi. Nura nxutsi a̱ha̱, hingue xa du. Pe ya ja̱ꞌi mi thentho ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pe ngu bi bøniꞌʉ pa thi, ra Jesu bi yʉtꞌi habʉ mi ꞌbɛnga ra nxutsi ne bi mipa rá ꞌyɛ, nepʉ nuꞌá̱ ꞌbestho bi nangui. ");
INSERT INTO oteNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Y gatho núꞌa̱ ra hai de guehni bi ntʉnga ra noya de núꞌa̱ ra nxutsi xqui yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nepʉ nu mi ma ra Jesu de guehni, yoho ya goda bi dɛniꞌa̱ ne bi ña̱ ntsꞌɛdiꞌʉ bi ꞌñena: ―¡Núꞌi rá Tꞌʉꞌi ra nda̱ Davi, pɛscahe ra nthecate! ");
INSERT INTO oteNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pe ra Jesu bi thotho ne bi ma bá cʉtꞌa ja ꞌnara ngu, ha nuya goda bi dɛniꞌa̱ y bi yʉtꞌiꞌʉ nehe. Nepʉ ra Jesu bi ꞌñembabiꞌʉ: ―¿Ha guí camfrihʉ gue da za ga øtheꞌihʉ? Nuꞌʉ́ bi ꞌñembi: ―Ha̱ha̱, Ndada, da za. ");
INSERT INTO oteNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nuꞌbʉ́ ra Jesu bi hñuꞌtsua rá ꞌyɛ ja yá daꞌʉ ne bi ꞌñembi: ―Dá njabʉ ngu núꞌa̱ xcá camfrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y ꞌbestho ra oraꞌa̱ bi xogui yá daꞌʉ. Nepʉ ra Jesu bi hñuꞌmba ra hña̱ ne bi ꞌñembi: ―Oxqui ma gui ma̱ñhʉ toꞌo bi ꞌyøtheꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pe nu mi bøni de guehniꞌʉ bi xipa gatho nuya mengu de guehni gue go ra Jesu xqui ꞌyøtheꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Y ngu bi bønga ya goda de guehni, bá tsꞌimpa ra Jesu ꞌnara gone mi pɛꞌtsa ꞌnara tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nepʉ ra Jesu bi ꞌyɛmba núꞌa̱ ra tsꞌonda̱hi mi pɛꞌtsa nura gone, ne nuꞌá̱ ꞌbestho bi za bi ña̱. Nuya ja̱ꞌi xi bi ꞌyø, ne mi ꞌñémbiꞌʉ ꞌna ngu maꞌna: ―Masque nújʉ go guecjʉ rá hniniguihʉ Ajua̱, pe hinhyaꞌmʉ stá hanthʉ ꞌnara ntꞌudi xi ra da̱ngui ngu núꞌa̱ stá hanthʉbya. ");
INSERT INTO oteNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pe nuya fariseo bi ꞌñenaꞌʉ: ―Nuní ha̱npa rá tsꞌɛdi ra nda̱ de ya tsꞌonda̱hi pa ɛnga ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nura Jesu mi ꞌyo gatho ja ya da̱nga hnini ne ya tꞌʉca hnini, ne mi cʉtꞌa ja ya nija̱ pa ja mi utuateni, ne mi øthe gatho ya daꞌthi, ne mi zofo ya ja̱ꞌi mi embi gue ya xqui zøhø ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y mi hyanda ra Jesu gatho nuya ja̱ꞌi, xi bi huequiꞌʉ ngueꞌa̱ ꞌñena ya zi dɛti joꞌo toꞌo da su y mi tu yá mʉi ngueꞌa̱ himi pa̱di toꞌo da dɛniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nuꞌbʉ́ ra Jesu bi ꞌñembabi yá nxadi: ―Majua̱ni dí xiꞌahʉ, nuua xi ja ndunthi ra sofo pe joꞌo ya mɛfi. ");
INSERT INTO oteNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hangue ꞌyapabihʉ Ajua̱ núꞌa̱ toꞌo rá mɛti nuna ra ꞌbɛfi pa da mɛhna ya mɛfi da gʉxa nuna sofona̱. ");
INSERT INTO oteNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nuꞌbʉ́ ra Jesu bi zohna núꞌʉ ꞌrɛtꞌamayoho yá nxadi xqui huahni, ne bi umba ra tsꞌɛdiꞌʉ pa da ꞌyɛnga ya tsꞌonda̱hi ne da ꞌyøthe gatho ya hñeni. ");
INSERT INTO oteNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nuya guehya yá thuhu núꞌʉ ꞌrɛtꞌamayoho yá apostol xqui hñutsꞌi: rá mʉdi ra Simu núꞌa̱ bi hñuꞌmbabi drá thuhu ra Pedro, ne ra Andre rá cu, ne ra Cobo, ne ra Xuua rá cu, di yohoꞌʉ yá tꞌʉ ra Sebedeo. ");
INSERT INTO oteNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nepʉ ra Lipe, ne ra Tolo, ra Toma, ne ra Teo núꞌa̱ mrá ngʉxboja̱, ne núꞌa̱ maꞌna ra Cobo rá tꞌʉ ra Alfeo, ne ra Lebeo núꞌa̱ bi thuꞌmbabi nehe ra Tadeo. ");
INSERT INTO oteNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nepʉ núꞌa̱ maꞌna ra Simu núꞌa̱ xqui ꞌñoui ya cananista, ne ra Juda Iscariote núꞌa̱ toꞌo bi da ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nuꞌbʉ́ gatho núꞌʉ ꞌrɛtꞌamayoho yá nxadi ra Jesu bi mɛhni ne bi ꞌñembiꞌʉ: ―Nubyá oxqui ma gui zohʉ núꞌʉ hingyá me Israel, nixi ya me Nsamaria. ");
INSERT INTO oteNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Rí maha go da bá zohʉ ya me Israel núꞌʉ go gueꞌʉ rá hnini Ajua̱ xa ꞌmɛdi ngu ya zi dɛti. ");
INSERT INTO oteNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Rí maha gui umfʉ ntꞌøde gue ya xa zøhø ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ꞌYøthehʉ núꞌʉ toꞌo di tsʉ ra lepra, ne núꞌʉ di pɛꞌtsa maꞌra ya hñeni, ne japhʉ da nte maꞌnaꞌqui núꞌʉ xa du, ne ꞌyɛmbahʉ ya tsꞌonda̱hi núꞌʉ toꞌo di pɛꞌtsi. Ngu stá ꞌraꞌathohʉ nuna tsꞌɛdina̱, njabʉ nehe ma gui fatsꞌithohohʉ ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Oxqui ma gui ha̱xhʉ ra boja̱ pa ja ra ꞌñu, nixi ra tꞌaxi nixi ra oro nixi ra cobre. ");
INSERT INTO oteNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ne oxqui ha̱xhʉ ni ꞌnara ꞌbatsꞌi, ni ri mponga dutuhʉ ni ri mponga zɛxthihʉ nixi ri bordohʉ, ngueꞌa̱ ra mɛfi rí ꞌñepi da tꞌumbabi núꞌa̱ te øꞌtua ra ꞌbɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ne nu xcrí tsøñhʉ ja ꞌnara da̱nga hnini o ꞌnara tꞌʉca hnini, gui hyoñhʉ ꞌnara ja̱ꞌi núꞌa̱ dra hoja̱ꞌi, ne ja gui ꞌbʉhʉni ja rá nguꞌa̱ asta hingui pøñhʉ de núꞌa̱ ra hniniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y nu xcrí cʉthʉ ja núꞌa̱ ra nguꞌa̱, gui ꞌyapabihʉ Ajua̱ da ja̱pi nuya mengu de núꞌa̱ ra nguꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ꞌBʉ nuya mengu de nura nguꞌa̱ da ꞌraꞌahʉ ntsaya, nuꞌbʉ́ Ajua̱ ma da ja̱piꞌʉ. Pe nuꞌbʉ hinda ꞌraꞌahʉ ntsaya, Ajua̱ hinda ma da ja̱piꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ꞌBʉ ni ꞌnara mengu de núꞌa̱ ra hniniꞌa̱ hinda gamfri núꞌa̱ gui xiphʉ ne hinda hñuxa ntꞌøde, nuꞌbʉ́ pøñhʉ de núꞌa̱ ra nguꞌa̱ o de núꞌa̱ ra hniniꞌa̱ ne gui fɛꞌma ri uahʉ pa da hyø núꞌa̱ ra hai xa nthuꞌti de núꞌa̱ ra hniniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Majua̱ni dí xiꞌahʉ, ra pa de ra nga̱xhmai núꞌa̱ ra hnini hinda hñuxa ntꞌøde núꞌa̱ gui xiphʉ, maꞌna ma da nda̱ngui yá tsꞌoqui nura hniniꞌa̱ que ra hnini Sodoma ne Gomorra. ");
INSERT INTO oteNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nubyá dí pɛhnꞌaꞌihʉ gui maha gui ꞌyohʉ ngu ya zi dɛti madetho ja ya zate. Hangue xi da nsuhʉ ngu ꞌnara quꞌeña̱, pe oguí øthʉ ra ntsꞌoꞌmʉi, njahʉ ngu ꞌnara zi domitsu hingui øtꞌa ra ntsꞌoꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ne xi da nsuhʉ, ngueꞌa̱ ya ja̱ꞌi ma da zixꞌahʉ ja ya tsꞌʉtbi, ne ma da zixꞌahʉ ja yá nija̱ꞌʉ pa ja dí napꞌaꞌihʉni. ");
INSERT INTO oteNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Núꞌʉ́ ma da zixꞌahʉ ja ya tsꞌʉtbi y asta ja ya da̱nga nda̱ po rá nguecagui. Hangue njabʉ da za gui damajua̱nihʉ de guecagui ja yá thandi ya nda̱ ne núꞌʉ hingyá me Israel. ");
INSERT INTO oteNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nu sta tsꞌixꞌahʉ ntsꞌa̱hni, osta ma da du ri mʉihʉ de núꞌa̱ te ma gui ma̱ñhʉ, nixi gui beñhʉ ꞌmɛtꞌo núꞌa̱ ma gui ma̱ñhʉ, ngueꞌa̱ nura ora ma gui ña̱hʉ, Ajua̱ go da ꞌraꞌahʉ ya noya. ");
INSERT INTO oteNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nuꞌahʉ́ hingo ma gui ña̱sɛhʉ; nurá Ma̱ca Nda̱hi Ajua̱ ra Dada go gueꞌa̱ ma da xiꞌahʉ te ma gui ma̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nuya paꞌʉ nuya ja̱ꞌi ma da ꞌñʉtsasɛui yá cu ne da da pa da tho. Ya dada ma da da yá ba̱tsi y ya ba̱tsi ma da nøꞌtua yá dada, ne da da pa da tho nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gatho ya meximhai ma da ʉtsaꞌihʉ ngueꞌa̱ guí ma̱ñhʉ ma noya. Pe nuꞌa̱ tóꞌo da zɛti asta rá nga̱tsꞌi, núꞌá̱ go gueꞌa̱ da mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nuꞌbʉ da tꞌʉtsaꞌihʉ ja ꞌnara hnini, pøñhʉ de guehni, rí maha maꞌna ra hnini. Majua̱ni dí xiꞌahʉ, hingri juatho gui ꞌyohʉ gatho ya hnini de ra hai Israel ha Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ya da yopa zøhø maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ꞌNara xahnate maꞌna ja rá nsu que rá nxadi; ꞌnara hmu maꞌna ja rá nsu que rá ꞌbɛgo. ");
INSERT INTO oteNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nura nxadi mahyoni da thogui ngu tho rá xahnate, nehe ra ꞌbɛgo mahyoni da thogui ngu tho rá hmu. Nja ngu ꞌnara dada ꞌbʉ da tꞌembabi gue go ra Beelsebú, nuꞌbʉ́ ya mengu rá ngu da tꞌembabiꞌʉ mahyɛgui nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Hangue dí xiꞌahʉ oxqui tsuhʉ núꞌa̱ ma gui thoguihʉ. Masque ꞌbʉ te da tꞌøꞌtꞌaꞌihʉ mantꞌa̱gui, pe rá nga̱tsꞌi ra pa ja ma da hnequini gatho núꞌa̱ te xa tꞌøꞌtꞌahʉ, ngueꞌa̱ gatho núꞌa̱ te tꞌøtꞌe mantꞌa̱gui ma da fa̱di. ");
INSERT INTO oteNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Núꞌa̱ dí uꞌtꞌaꞌihʉ sɛhɛ mantꞌa̱gui ma gui utuahʉ gatho ya ja̱ꞌi. Nehe núꞌa̱ dí xiꞌasɛhʉ zi njante ma gui ma̱ñhʉ ntsꞌɛdi pa da ꞌyøde gatho ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Oxqui tsuhʉ toꞌo da hyoꞌahʉ, ngueꞌa̱ nuri almahʉ hinda za to da hyopꞌahʉ. Nuꞌa̱ tóꞌo mahyoni gui tsuhʉ, nu Ajua̱, ngueꞌa̱ nuꞌá̱ ha̱, tsa da mɛhnꞌa ri almahʉ ne ri ngøquꞌeihʉ ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nuya zi tsꞌintsꞌʉ hintsꞌʉ ri muui asta ꞌba yoho por ñodmi, ne hingui tagui tusɛꞌʉ ꞌbʉ hingo rá paha Ajua̱ ra Dada. ");
INSERT INTO oteNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","¿Xihma̱ꞌihʉ? Nuꞌahʉ maꞌna grí muuihʉ ja rá thandi Ajua̱, ngueꞌa̱ asta nuri sta̱hʉ ꞌmede. ");
INSERT INTO oteNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hangue oxqui ma gui ntsuhʉ, ngueꞌa̱ maꞌna grí muuihʉ que ya zi tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nuꞌa̱ tóꞌo ma da damajua̱ni de guequi ja yá thandi ya ja̱ꞌi, nequi nehe ma ga damajua̱ni de gueꞌa̱ ja rá thandi ma Dada bí ꞌbʉi mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pe nuꞌa̱ tóꞌo da ncøni de guequi ja yá thandi ya ja̱ꞌi, nequi nehe ma ga xipa ma Dada núꞌa̱ bí ꞌbʉi mahetsꞌi gue himbi ne bi gamfrigui. ");
INSERT INTO oteNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Oguí hu ri mʉihʉ gue ngueꞌa̱ stá ehe ya hinda nja ra tuhni ja ra ximhai; nuꞌá̱ ma da nja ngueꞌa̱ stá ehe. ");
INSERT INTO oteNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nuya tꞌʉ da nøꞌtua yá dada, ne ya tꞌixu da nøꞌtua yá na̱na̱, ha nuya tsꞌihuɛ da nøꞌtua yá suegra. ");
INSERT INTO oteNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Y njabʉ nuyá ncontra ya ja̱ꞌi ma da bønsɛ de ja yá nguꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nuꞌa̱ tóꞌo maꞌna go ri ma̱di rá dada o rá na̱na̱ que guecagui, núꞌá̱ hinda za da dɛngagui. Nehe nuꞌa̱ tóꞌo maꞌna go ri ma̱di rá tꞌʉ o rá tꞌixu que guecagui, neꞌa̱ hinda za da dɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nehe nuꞌa̱ tóꞌo hinda ꞌñɛi pa da dɛngagui masque da tho ya ntꞌʉtsate ne ya ꞌbɛtsa, núꞌá̱ hinda za da dɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nuꞌa̱ tóꞌo ri ma̱di rá te nuua ja ra ximhai, ma da ꞌbɛdi rá te pa nza̱ntho, pe nuꞌa̱ tóꞌo da dɛngagui masque da du po rá nguequi, ma da zʉdi rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nuꞌʉ tóꞌo da ꞌraꞌahʉ ntsaya, go guequi ri ꞌraca ntsaya. Ha nuꞌʉ tóꞌo da ꞌraca ntsaya, go ri umba ntsaya ma Dada núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nuꞌa̱ tóꞌo da umba ntsaya ꞌnará ꞌmɛhni Ajua̱, ma da hña̱nga ra tha̱ha̱ nehe ngu ma da hña̱ni ꞌnará ꞌmɛhni Ajua̱. Ha nuꞌa̱ tóꞌo da umba ntsaya ꞌnara ja̱ꞌi ngueꞌa̱ øte Ajua̱, neꞌa̱ ma da hña̱nga ra tha̱ha̱ ngu núꞌa̱ ma da hña̱ni núꞌa̱ øte Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Núꞌahʉ ma nxadiꞌihʉ, ꞌbʉ tóꞌo da ꞌraꞌahʉ ma̱di tsꞌʉ ra dehe gui tsihʉ ngueꞌa̱ ma nxadiꞌihʉ, majua̱ni dí xiꞌahʉ gue nura ja̱ꞌiꞌa̱ hinda ma da ꞌbɛdi rá tha̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nu mi uadi ra Jesu bi xipabi te ma da mɛfi núꞌʉ ꞌrɛtꞌamayoho yá nxadi, núꞌá̱ bi ma ja ya hnini de núꞌa̱ ra haiꞌa̱ pa da ma̱nga ra ma̱ca noya. ");
INSERT INTO oteNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Y de mi ofadi nura Xuua Xiꞌtsate bi ꞌyøde de núꞌa̱ mi øtꞌa ra Jesu. Nuꞌbʉ́ bi mɛhna yoho yá nxadi núꞌʉ mri ꞌñoui pa da ꞌyambabiꞌa̱, ");
INSERT INTO oteNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ne bi ꞌñembi: ―¿Ha go gueꞌi rá ꞌmɛhniꞌi Ajua̱ núꞌa̱ dí tøꞌmhe, o ga tøꞌmhe maꞌna da ꞌñepʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ra Jesu bi da̱di ne bi ꞌñembi: ―Rí maha gui xiphʉ ra Xuua de núꞌa̱ guí ødehʉ ne núꞌa̱ guí hanthʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bá xiphʉ gue ya goda xo yá da, ya doua ri ꞌyo, ya gogu øde, nuꞌʉ tsʉ ra lepra ña̱ni, nuꞌʉ xa du ri yopa nte, ha nuya zi hyoya nehe øde ra ma̱ca noya. ");
INSERT INTO oteNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nja̱pi núꞌa̱ toꞌo camfri gue go guecagui rá ꞌmɛhnigui Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","De mi menga yá nxadi ra Xuua Xiꞌtsate, ra Jesu bi mʉdi bi xipa ya ja̱ꞌi de rá ꞌbɛfi ra Xuua, ne bi ꞌyøꞌtua ya ntꞌani bi ꞌñembabi: ―Xi de gá maha ja ra mbonthi, ¿te rá ꞌbɛ uá hanthʉni? ¿Ha gue uá hanthʉ ꞌnara ꞌñøhø mi otho rá tsꞌɛdi ꞌñena ꞌnara doxꞌo ri ndudetho ra nda̱hi? Hina ¿ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nuꞌbʉ́, ¿te rá ꞌbɛ ma uá hanthʉ? ¿Ha gue uá hanthʉ ꞌnara ꞌñøhø xqui hye ꞌraya dutu mahotho? Hina ¿ngue ha̱? Ngueꞌa̱ nuꞌʉ tóꞌo pɛpa ya nda̱ nuua ja ra ximhai, go gueꞌʉ ꞌbʉi ja yá da̱nga ngu ya nda̱ ne go gueꞌʉ ri nhye xi xá hño. ");
INSERT INTO oteNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nuꞌbʉ́, ¿te rá ꞌbɛ gá ma uá hanthʉ? ¿Ha gue hingue ꞌnará ꞌmɛhni Ajua̱? Ha̱ha̱, ꞌnará ꞌmɛhni Ajua̱. Y hingue hønsɛ gueꞌa̱ rá ꞌbɛfiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nura Xuua Xiꞌtsate go gueꞌa̱ bá ehe bá ꞌbɛtꞌo de guequi, ne gueꞌa̱ xqui ma̱ Ajua̱ ma Dada ja ra Ma̱ca Tꞌofo ne bi ꞌñena: Nugui dí pɛhna ꞌna toꞌo ri ꞌbɛtꞌo de gueꞌi pa da hyocꞌa ri ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Xi majua̱ni dí xiꞌahʉ de gatho nuya ja̱ꞌi xa ꞌmʉiua ja ra ximhai xa njoꞌo ni ꞌna di ja rá nsu ngu ra Xuua Xiꞌtsate, pe nuꞌa̱ tóꞌo xa yʉtꞌa ja rá hmanda Ajua̱, maꞌna xa nja̱pi que ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nu mi mʉdi bi nxiꞌtsate ra Xuua, núꞌá̱ bi da̱ma nupa yá mfeni ya ja̱ꞌi pa da da̱ma ñobri pa da yʉthma̱ꞌʉ ja rá hmanda Ajua̱. Y nuꞌʉ tóꞌo øtꞌa ra tsꞌɛdi pa da yʉtꞌi, cʉtꞌi ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngueꞌa̱ nu mi zøhø ra Xuua, gueꞌbʉ bi nja ngu núꞌa̱ xqui ma̱nga ra Moise ne maꞌra yá ꞌmɛhni Ajua̱ núꞌbʉ mi ma̱ gue da ꞌñehe ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nehe bi ma̱ñꞌʉ gue ra ba̱di Elía mi pɛꞌtsi da yopa mengui, y ya bi njabʉ ngu núꞌa̱ xqui ma̱ñꞌʉ ngueꞌa̱ ra Xuua go gueꞌa̱ rá mpøte ra Elía. Camfrihʉ núꞌa̱ dí xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nuꞌa̱ tóꞌo pɛꞌtsa ra paha da gamfri nuya ya noya dí xiꞌahʉ, dá gamfri. ");
INSERT INTO oteNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Ngu toꞌo ga hyɛcuabihʉ núꞌʉ ya ja̱ꞌi hingui camfrigui? Nuꞌʉ́ ri nhyɛcuaui ya ba̱tsi núꞌʉ hu ja ra tai ꞌñeni ne pɛꞌmda, ne ri ntsʉhui maꞌra yá miba̱tsiui. ");
INSERT INTO oteNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ne embabi: “Nuje dá mpɛꞌmdahe ne hingá ne gá neihʉ. Dá maha ja ra ntꞌagui dá nzonihe, pe nuꞌahʉ nixi himbi du ri mʉihʉ. Nuꞌbʉ́ ¿te guí nehʉ?” Njabʉtho nehe núꞌʉ ya da̱nga ja̱ꞌibya, núꞌʉ́ ni ꞌnara tꞌøtꞌe hingui ho. ");
INSERT INTO oteNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nura Xuua Xiꞌtsate mi tꞌembi gue mi pɛꞌtsa ra tsꞌonda̱hi ngueꞌa̱ hinto mri ñuniui nixi mri ntsiui ya tixfani. ");
INSERT INTO oteNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nepʉ ꞌmɛfa de ra Xuua bi zø Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, nuꞌá̱ ha̱, toꞌoraza ri ñuniui ne ri ntsiui, hangue ya ja̱ꞌi bi ꞌñena: “Ndi, nuni ra ꞌñøhø xi ra tsꞌoꞌyo y ra tixfani, xi ri ñuniui ne xi ri ntsiui ya tixfani ne ya tsꞌoja̱ꞌi.” Pe nugui dí xiꞌahʉ gue nuya ja̱ꞌi beni njabʉ, hinte yá fa̱diꞌʉ, ngueꞌa̱ ri hnequitho núꞌʉ toꞌo pɛꞌtsa ra mfa̱di, ngueꞌa̱ ri hnequitho ja yá ꞌbɛfi. ");
INSERT INTO oteNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nepʉ ra Jesu bi ma̱ nehe de núꞌʉ ya hnini habʉ xqui thogui xqui ꞌyøtꞌa ya da̱nga ntꞌudi. Y bi zʉi núꞌʉ ya ja̱ꞌi de nuya hniniꞌʉ ngueꞌa̱ himbi ntsøꞌmi de yá tsꞌoqui masque bi hyanthma̱ꞌʉ rá tsꞌɛdi Ajua̱. Bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Huecateꞌihʉ núꞌahʉ gyá menguhʉ Corasí ne gyá me Betsaidahʉ! Ma xi dra castigaꞌihʉ ngueꞌa̱ masque xcá hyanduahʉ rá tsꞌɛdi Ajua̱ pe hinxcá ñobrihʉ de ri tsꞌoquihʉ. ꞌBʉ nuya me Tiro ne ya me Sidó xqui hyanthma̱ha̱ꞌʉ gatho núꞌa̱ xcá hyanthʉbya, núꞌʉ́ xa ntsøꞌma hma̱ha̱ de yá tsꞌoqui, ne xa hñehma̱ꞌʉ dega dumʉi ne xa ncoxa ra ꞌbospi. ");
INSERT INTO oteNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hangue dí xiꞌahʉ gue núꞌa̱ ra pa de ra nga̱xhmai maꞌna dya da̱ngui ri tsꞌoquihʉ que ra hnini Tiro ne ra hnini Sidó. ");
INSERT INTO oteNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¡Huecateꞌihʉ núꞌahʉ gyá menguhʉ Ncapernau! Guí hu ri mʉihʉ gue ra da̱ngui ri nsuhʉ, pe hina, ngueꞌa̱ ma gui nhuatihʉ ngueꞌa̱ hinxcá ñobrihʉ de ri tsꞌoquihʉ. ꞌBʉ nuya me Sodoma xqui hyanthma̱ha̱ nuya ya da̱nga ntꞌudi ngu núꞌa̱ xcá hyanthʉbya, nuꞌbʉ́ hinxra huatihma̱, di jatho núꞌa̱ ra hninihma̱. ");
INSERT INTO oteNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hangue dí xiꞌahʉ gue núꞌa̱ ra pa yá nga̱tsꞌi ya pa maꞌna dya da̱ngui ri tsꞌoquihʉ que ra hnini Sodoma. ");
INSERT INTO oteNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nepʉ ra Jesu bi ꞌyapa Ajua̱ rá Dada ne bi ꞌñena: ―Dí xøcambeniꞌi ma Dadaꞌi núꞌi grá Nda̱ de mahetsꞌi ne de ra ximhai. Dí ꞌraꞌa njama̱di ngueꞌa̱ xcá utua ri noya núꞌʉ toꞌo hingyá ba̱mhya̱, y nuꞌʉ tóꞌo ya ba̱mhya̱ ne ya ꞌñetsꞌi himbi zo yá mfeni. ");
INSERT INTO oteNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Y gatho núꞌa̱ xcá øtꞌe go gueꞌa̱ ri paha, ma Dadaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ꞌMɛfa ra Jesu bi ꞌñemba yá nxadi: ―Ma Dada bi ꞌracagui gatho ra mfa̱di. Joꞌo toꞌo pa̱tca ma mfeni, hønsɛ ma Dada bí ꞌbʉi mahetsꞌi, núꞌá̱ ha̱, go gueꞌa̱ pa̱tca ma mfeni. Nehe joꞌo toꞌo xa ba̱tua rá mfeni ma Dada, hønsɛ nuga ha̱, ngueꞌa̱ go gueque rá Tꞌʉgui, nehe núꞌʉ toꞌo stá huahni, neꞌʉ pa̱tuabi rá mfeni ma Dada ngueꞌa̱ go stá utuabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Bá ehʉ gatho núꞌahʉ grí mpɛfihʉ ne xi grí nduhʉ pa ga tsʉcꞌa ri ꞌbatsꞌihʉ pa gui tsayahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngu ꞌnara ntꞌɛi dega nda̱mfri thuꞌtsua ra yugo pa da tꞌɛi, njabʉ nehe nuꞌahʉ gui hña̱ñhʉ núꞌa̱ ra yugo ga huꞌtsꞌahʉ pa da za ga uꞌtꞌahʉ ma hogaꞌmʉi, pa da za gui nhyoja̱ꞌihʉ nehe ngugui, ngueꞌa̱ nuga drá hoja̱ꞌi y hindrá ꞌñetsꞌi, y njabʉ ya hinda zabiꞌihʉ nixi da du ri mʉihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngueꞌa̱ nura yugo dí huꞌtsꞌahʉ hinda ʉñꞌahʉ, y núꞌa̱ ra ꞌbatsꞌi dí tuꞌtꞌahʉ hingui ma gui tsamahñʉhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ꞌNara pa ra Jesu co yá nxadi bi ꞌranga ja ꞌnara ua̱trigo. Y nura paꞌa̱ mi nsabdo, y gueꞌa̱ ra pa dega tsaya. Ne nuya nxadi mi tsʉ ra thuhu hangue bi mʉdi bi docua yá nga̱ha̱ ya trigo pa bi ziꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Y mi hyanda njabʉ ya fariseo bi ꞌñemba ra Jesu: ―¿Hanja øtꞌa njabʉ ri nxadi? Nuyʉ́ hindí ꞌñepi da ꞌyøtꞌa njabʉ núꞌa̱ ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pe ra Jesu bi da̱tuabiꞌʉ bi ꞌñembi: ―¿Ha hinxcá hñeꞌthʉ habʉ ma̱ de núꞌa̱ bi ꞌyøtꞌa ra Davi núꞌbʉ mi tsʉ ra thuhu co núꞌʉ mri ꞌñoui? ");
INSERT INTO oteNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nuꞌá̱ bi yʉtꞌa mbo rá nija̱ Ajua̱ ne bi zi núꞌʉ ya thuhme xqui nja̱pi. Ha núꞌá̱ ne núꞌʉ mri ꞌñoui hingo mri ꞌñepa hma̱ha̱ xa zi nura thuhmeꞌa̱, hønsɛ ya macja̱ ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ha hinxcá hñeꞌtihʉ nehe ja rá ley ra Moise gue nuya macja̱ di mpɛfi ja ra nda̱nija̱ masque ya pa dega tsaya pe hinte ma tsꞌoqui øtꞌe? ");
INSERT INTO oteNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ha nuga dí xiꞌahʉ gue ꞌbʉcua núꞌa̱ toꞌo maꞌna ja rá nsu que ra nda̱nija̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mahyoni gui pa̱hʉ te rí bønga nuya ya noya bi ma̱nga Ajua̱ ma Dada ja ra Ma̱ca Tꞌofo ne bi ꞌñena: “Nuga maꞌna dí ne gui mpɛꞌtsuahʉ ra nthecate ꞌna ngu ꞌna que gui tsincahʉ ya mboꞌoni pa gui hyohʉ gui ꞌbahaguihʉ.” ꞌBʉ gri pa̱hma̱hʉ te rí bønga nuya ya noya, nuꞌbʉ́ hinxcá ña̱pahma̱hʉ núꞌʉ hinte ma tsꞌoqui tu. ");
INSERT INTO oteNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi go gueꞌa̱ pɛꞌtsa ra tsꞌɛdi pa da manda masque ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Y ra Jesu bi thogui de guehni ne bi ma bá cʉtꞌa ja ra nija̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y ja mi ꞌbʉhni ꞌnara ꞌñøhø xqui ꞌyotꞌa ꞌnará ꞌyɛ. Y nuya fariseo mi ꞌbʉhni bi ꞌyamba ra Jesu ne bi ꞌñembi: ―¿Ha gue rí ꞌñepi gui ꞌyøthe ꞌnara ja̱ꞌi nura pa dega tsaya? Nuꞌʉ́ mi ambabi njabʉ pa da ña̱pahma̱ꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pe ra Jesu bi ꞌñembabiꞌʉ: ―¿Toꞌo ꞌna de gueꞌahʉ gri pɛꞌtshʉ ꞌnara zi dɛti, nepʉ da zo ja ꞌnara oꞌtsi ne hingui hña̱ihʉ ngueꞌa̱ ra pa dega tsaya? Pɛꞌtsi gui hña̱ihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ha gue hingue maꞌna di muui ꞌnara ja̱ꞌi que ꞌnara dɛti? Hangue mahyoni ga øthʉ ya hoga ꞌbɛfi masque ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nepʉ ra Jesu bi ꞌñembabi núꞌa̱ ra ꞌñøhø toꞌo xqui ꞌyotꞌa rá ꞌyɛ: ―Ha̱ua ri ꞌyɛ. Nuꞌbʉ́ nuꞌá̱ bi tʉnga rá ꞌyɛ, nepʉ ꞌbestho bi ña̱ni ne bi gohi ngu mi nja núꞌa̱ maꞌna rá ꞌyɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nuꞌbʉ́ ya fariseo bi bøni de guehni pa bi ꞌñʉꞌti hanja da za da hyohma̱ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pe nuꞌá̱ bi ba̱tho te mi beniꞌʉ ne bi ma de guehni y bi dɛna ndunthi ya ja̱ꞌi. Y mi øthebi gatho núꞌʉ toꞌo mi hñeni. ");
INSERT INTO oteNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne bi hñuꞌmba ra hña̱ ya daꞌthi núꞌʉ xqui ꞌyøthe gue hinto da xipabi de núꞌa̱ xqui ꞌyøꞌtuabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bi ma̱nga ra Jesu njabʉ pa bi nja ngu núꞌa̱ xqui ma̱nga ra ba̱di Isaía gue Ajua̱ bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Guehna ma hoga ꞌmɛhni stá pɛhni ne guehna ma hma̱di ne xi dí hopa rá ꞌmʉi. Ga umbabi ma Ma̱ca Nda̱hi pa da zofo gatho ya ja̱ꞌi ꞌbʉ ja rá ngʉni ra ximhai, pa da ba̱diꞌʉ gue ma ga ha̱ꞌmba nguɛnda. ");
INSERT INTO oteNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nuꞌá̱ hinto ma da ntsanoyaui, nixi toꞌo ma da maꞌtiui ja ya ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma hoga ꞌmɛhni ma da nupa yá mfeni núꞌʉ toꞌo hintsꞌʉ tsɛdi yá jamfri, ngu ꞌñena ꞌnara doxꞌo xa dehmi, ne ma da mɛꞌtsua ra nthecate núꞌʉ toꞌo ja xa gamfri, ngu ꞌñena ꞌnara tꞌʉca ñotꞌi hintsꞌʉ di yotꞌatho. Ne ma da ꞌñudi ra hogaꞌmʉi asta hinda ꞌmɛdi ra ntsꞌoꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y ya ja̱ꞌi de gatho rá ngʉni ra ximhai ma da gamfribi rá noyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nepʉ ra Jesu bá tsꞌimpabi ꞌnara ja̱ꞌi mrá gone ne mrá goda ngueꞌa̱ mi pɛꞌtsa ꞌnara tsꞌonda̱hi, y nuꞌá̱ bi ꞌyɛmbabi. Y ꞌbestho ra oraꞌa̱ bi za bi ña̱ ne bi hyandi. ");
INSERT INTO oteNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hangue gatho ya ja̱ꞌi mi ꞌbahni xi bi ꞌyø ne bi ꞌñémbabiꞌʉ ꞌna ngu maꞌna: ―¿Ha go guehni rá tꞌʉ ra nda̱ Davi núꞌa̱ toꞌo xqui mɛhni Ajua̱ pa da nda̱ ꞌbʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Y nu mi ꞌyøde ya fariseo bi ma̱nga ya ja̱ꞌi njabʉ, nuꞌbʉ́ nuꞌʉ́ bi ꞌñémsɛꞌʉ: ―Nuní hingue co rá tsꞌɛdisɛ ɛnga ya tsꞌonda̱hi, nuní ha̱npa rá tsꞌɛdi ra Beelsebú núꞌa̱ ra nda̱ de ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pe ra Jesu bi ba̱tuatho yá mfeniꞌʉ ne bi ꞌñembabi: ―Nuꞌbʉ ꞌnara hnini da hyegue ne da ntunsɛhɛ, nuꞌbʉ́ da ꞌmɛtho núꞌa̱ xa mɛfiꞌʉ. Ha nuꞌbʉ ꞌnara ꞌmʉi da ntunsɛhɛ, hinda za da ꞌmʉi xá hño, da nhuata ra ꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xi ra tsꞌonda̱hi, ¿hanja da za da ꞌyɛnga rá mitsꞌonda̱hiui? Hinda za, ngueꞌa̱ nuꞌbʉ njabʉ da ꞌñotho yá tsꞌɛdi ꞌna ngu ꞌna ne da nhuati gatho. ");
INSERT INTO oteNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Guí eñhʉ gue nuga dí ɛnga ya tsꞌonda̱hi co rá tsꞌɛdi ra nda̱ de ya tsꞌonda̱hi. Xi ri ꞌmɛhnihʉ, ¿con toꞌo rá tsꞌɛdi ɛnga ya tsꞌonda̱hi ꞌbʉ? Go dá xiꞌahʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nuga dí ɛnga ya tsꞌonda̱hi co rá tsꞌɛdi rá Ma̱ca Nda̱hi Ajua̱ ma Dada, hangue njabʉ pa̱hʉ gue ya xa zøhø ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hinda za da yʉtꞌa ꞌnara be ja rá ngu ꞌnara ja̱ꞌi núꞌa̱ xi di o rá tsꞌɛdi ꞌbʉ hingue ꞌmɛtꞌo da mihi ne da duꞌti pa da bepi núꞌa̱ te pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nuꞌʉ tóꞌo hingui ꞌyo con gueque, núꞌʉ́ di ʉtsagui. Nehe nuꞌʉ tóꞌo hingui faxqui ga muntsꞌa ma sofo, núꞌʉ́ go xantho. ");
INSERT INTO oteNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dí xiꞌahʉ gue gatho ya tsꞌoqui øtꞌa ya ja̱ꞌi ne gatho ya tsꞌone ma̱ñꞌʉ, ma dra pumbabiꞌʉ. Pe nuꞌa̱ tóꞌo da zamba rá Ma̱ca Nda̱hi Ajua̱, nura ja̱ꞌiꞌa̱ hindra pumbabi. ");
INSERT INTO oteNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nuꞌa̱ tóꞌo da zani Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, nuꞌá̱ dra pumbabi, pe nuꞌa̱ tóꞌo da zanga ra Ma̱ca Nda̱hi hindra pumbabi nixi nubya ni pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ꞌNara hoga ꞌbai gá za unga ya hoga fruta, ha ꞌnara tsꞌo ꞌbai gá za unga ya tsꞌo fruta. Hangue njabʉ da za gui pa̱dihʉ ndaꞌa̱ ra hoga ꞌbai gá za y ndaꞌa̱ hingrá hoga ꞌbai gá za. ");
INSERT INTO oteNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nuꞌahʉ xi gyá tsꞌoꞌmʉihʉ guí njahʉ ngu ya quꞌeña̱ tsate. ¿Hanja da za gui ma̱ñhʉ ya hoga noya ꞌbʉ guí beñhʉ ya tsꞌomfeni? Ngueꞌa̱ núꞌa̱ guí beñhʉ ja ri mfenihʉ go gueꞌa̱ guí ma̱ñhʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nuꞌa̱ tóꞌo benga ya hoga mfeni ma̱nga ya hoga noya, ha nuꞌa̱ tóꞌo benga ya tsꞌomfeni ma̱nga ya tsꞌonoya. ");
INSERT INTO oteNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nuga dí xiꞌahʉ gue gatho núꞌa̱ te gui ma̱ñhʉ ne hingui jamasuhʉ, pɛꞌtsi te gui tha̱dihʉ nura paꞌa̱ ma da tha̱pꞌahʉ nguɛnda. ");
INSERT INTO oteNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ngueꞌa̱ Ajua̱ go gueꞌa̱ ma da hña̱pꞌahʉ nguɛnda de gatho núꞌa̱ guí ma̱ñhʉ, ne ja ma da hnequini tengu ri hñoja̱ꞌihʉ ne tengu ri ntsꞌoꞌmʉihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nepʉ ꞌraya xahnate de ra ley ne ya fariseo mi ꞌbʉhni bi ꞌñembabi ra Jesu: ―Xahnate, dí nehe gui ꞌñutcahe ꞌraya ntꞌudi pa ga pa̱he ua xi majua̱ni go xpá mɛñꞌaꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nuꞌbʉ́ ra Jesu bi da̱tuabi ne bi ꞌñembi: ―Nuꞌahʉ́ gyá tsꞌoja̱ꞌihʉ ne gyá ꞌña̱gamfrihʉ hangue guí adihʉ ꞌnara ntꞌudi gui hyanthʉ pa gui camfrihʉ. Pe nuga, hinga ma ga uꞌtꞌaꞌihʉ ni ꞌnara ntꞌudi. Hønsɛ ndaꞌa̱ da tꞌuꞌtꞌahʉ, núꞌa̱ ra ntꞌudi de ra Joná rá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nuꞌá̱ bi ꞌyo hñu pa ne hñu xuui mbo rá mʉi ꞌnara da̱nga hua̱. Njabʉ nehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da ꞌmʉi hñu pa ne hñu xuui mbo ra hai. ");
INSERT INTO oteNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ha ꞌmɛfa bi ma ra Joná bá zofo ya ja̱ꞌi de ra hnini Ninive, ha nuꞌʉ́ ꞌbestho bi ntsøꞌmi de yá tsꞌoqui. Ha nubyá ꞌbʉcua ꞌna toꞌo maꞌna xi ja rá nsu que ra Joná, pe nuꞌahʉ hinxcá camfrihʉ. Hangue ja rá nga̱tsꞌi ra pa ma xi da ña̱pꞌaꞌihʉ ya me Ninive, ngueꞌa̱ masque xcá hyanduabihʉ rá tsꞌɛdi Ajua̱ pe hinxcá camfrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nehe núꞌa̱ ra ꞌbɛhña̱ mrá nda̱ de ra hai Arabia mi ꞌyøde gue ra Salomó xi mi ja ndunthi rá mfa̱di. Núꞌá̱ bá ehe bi cꞌa̱ꞌtsiꞌa̱ masque xi ntsꞌɛdi mi yabʉ rá hai, pa da ꞌyøde núꞌa̱ mi ma̱ñꞌa̱. Pe nubyá ꞌbʉcua ꞌna toꞌo maꞌna xi ja rá nsu que ra Salomó, pe nuꞌahʉ hinxcá camfrihʉ. Hangue ja rá nga̱tsꞌi ra pa ma da ña̱pꞌahʉ núꞌa̱ ra ꞌbɛhña̱ꞌa̱ ngueꞌa̱ masque xcá hyanduabihʉ rá tsꞌɛdi Ajua̱ pe hinxcá camfrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nepʉ ra Jesu bi ꞌñena: ―Nuꞌbʉ ꞌnara tsꞌonda̱hi da bønga de ja ꞌnara ja̱ꞌi, nura tsꞌonda̱hiꞌa̱ ꞌyo habʉraza ja ya mbonthi honi hma̱ha̱ habʉ da ꞌmʉi, pe hingui tsʉdi. Nuꞌbʉ́ ma da ma̱nsɛꞌa̱ ne da ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Pøde ma ga pengui habʉ dá pøni pa ja ga yopa ꞌbʉhni.” Ha nu stí menguiꞌa̱ da zʉdi núꞌa̱ ra ꞌñøhø ne guetꞌatho rá mfeni ngu bi zogui ra tsꞌonda̱hi, nuꞌbʉ́ nja ngu ꞌnara ngu xa ꞌbastꞌi ne xá ntꞌaxi pe hinto ꞌbʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nuꞌbʉ́ núꞌa̱ ra tsꞌonda̱hiꞌa̱ da ma da tsi má yoto ya tsꞌonda̱hi núꞌʉ maꞌna xi strá ntsꞌo que gueꞌa̱, nepʉ da yʉtꞌa ja núꞌa̱ ra ꞌñøhø núꞌa̱ mi guetꞌatho rá mfeni. Nuꞌbʉ́ nuꞌá̱ maꞌna strá ntsꞌo rá mfeni que rá mʉdi. Hangue núꞌahʉ gyá tsꞌoja̱ꞌihʉ ma gui njahʉbʉ nehe ꞌbʉ hingui ñobrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Y de mi utuate ra Jesu, bi zøhø rá na̱na̱ ne yá cu mi ꞌbai møte ra ngu habʉ mi utuateꞌa̱ ne mi ne da ña̱uiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nuꞌbʉ́ ꞌnara ja̱ꞌi bi ꞌñemba ra Jesu: ―ꞌBacua møte ri na̱na̱ co ri cu hoñꞌi gui ña̱ui ꞌna̱. ");
INSERT INTO oteNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pe nura Jesu bi da̱tuabi núꞌa̱ toꞌo bi xipabi njabʉ ne bi ꞌñembi: ―¿Toꞌo ma na̱na̱ga, ne toꞌo ma cuga? ");
INSERT INTO oteNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nepʉ co rá ꞌyɛ bi ꞌñudi yá nxadi ne bi ꞌñena: ―Nuya go guehya ma na̱na̱ ne ma cu. ");
INSERT INTO oteNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nuꞌa̱ tóꞌo øꞌtua rá paha ma Dada bí ꞌbʉi mahetsꞌi, go gueꞌa̱ ma cu ne ma nju ne ma na̱na̱. ");
INSERT INTO oteNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nepʉ ra paꞌa̱ ra Jesu bi bøni de núꞌa̱ ra ngu habʉ mi ꞌbʉi, ne bi ma bá hudi ja ra ña̱nga ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nepʉ bi ma ndunthi ya ja̱ꞌi bá cꞌa̱ꞌtsiꞌa̱, nuꞌbʉ́ nuꞌá̱ bi bøxa ja ꞌnara motsa ne ja bi hñudini, ne gatho ya ja̱ꞌi bi gohini ja ra ña̱nga ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nepʉ bi metuabiꞌʉ ꞌraya ꞌbede pa bi ꞌñutuabi. Nurá mʉdi ra ꞌbede bi mede, bi ma̱ de ꞌnara motꞌi ne bi ꞌñena: ―ꞌNara motꞌi bi ma da mpotꞌa ja rá hua̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Y nu mi mʉdi bi mpotꞌi, bi dagui ꞌraya zi nda ja ra ꞌñu. Y nuya ndaꞌʉ bi zi ya tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Y nu maꞌra ya nda bi dagui ja ya ꞌbodo habʉ mi otho ndunthi ra hai, y nuya ndaꞌʉ ꞌbestho bi føtsꞌe ngueꞌa̱ hinxmá pidi ra hai. ");
INSERT INTO oteNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Y nu mi patꞌa ra hyadi bi huixqui ne bi ꞌyotꞌi ngueꞌa̱ mi otho yá ꞌyʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nu maꞌra ya nda bi dagui mbo ja ya ꞌmini, ne mi te ya ꞌmini bi xumi ne bi hyo núꞌa̱ xqui ꞌbotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ha nu maꞌra ya nda bi dagui ja ra hoga hai, y núꞌʉ ya ndaꞌʉ xi bi cꞌontsꞌi xá hño ne bi hogui, ꞌraya ꞌbai bi unga ꞌna nthebe ya nda, nu maꞌra ya ꞌbai bi unga hñuꞌrate, ha nu maꞌra ya ꞌbai bi unga ꞌnatemaꞌrɛtꞌa ya nda. ");
INSERT INTO oteNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nuꞌa̱ tóꞌo pɛꞌtsa ra paha da ꞌyøde nuya ya noya dí ma̱, dá ꞌyøde. ");
INSERT INTO oteNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nepʉ yá nxadi bi joni habʉ mi hudi ra Jesu pa bi ꞌyambabi ne bi ꞌñembabi: ―¿Hanja guí zofo ya ja̱ꞌi njabʉ co núꞌʉ ya ꞌbede? ");
INSERT INTO oteNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ra Jesu bi da̱tuabiꞌʉ ne bi ꞌñembi: ―Nuga dí ma̱nga njabʉ ngueꞌa̱ nuyʉ́ hingui tsa da zo yá mfeni núꞌa̱ dí ma̱ de hanja ri nda̱ Ajua̱, núꞌa̱ hinxqui fa̱di maꞌmɛtꞌo. Ngueꞌa̱ nuyʉ́ hinxa tꞌumba ra mfa̱di pa da ba̱di, pe nuꞌahʉ ha̱, xa tꞌaꞌahʉ ra mfa̱di pa gui pa̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Y nuꞌahʉ maꞌna ma gui pa̱hʉ ngueꞌa̱ xa tꞌaꞌahʉ ra mfa̱di, nja ngu xa hma̱ gue nuꞌa̱ tóꞌo jababi, maꞌna ma da mɛꞌtsi, ha nuꞌa̱ tóꞌo othobi, ma da tha̱cuabi núꞌa̱ tsꞌʉ pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nuyʉ́ dí petuabi njabʉ ngueꞌa̱ ja yá thandi pe hingui handi, ja yá ntꞌøde pe hingui øde, ne ja yá mfeni pe hinte yá fa̱di. ");
INSERT INTO oteNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hangue bi njabʉ ngu núꞌa̱ xqui ma̱nga ra ba̱di Isaía mayaꞌbʉ ne bi ꞌñena: Ma gui ꞌyødehʉ pe hinda zo ri mfenihʉ. Ma gui hyanthʉ pe hingui ma gui pa̱dihʉ te rí bøni núꞌa̱ guí hanthʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ngueꞌa̱ xi xa megui ri mfenihʉ, ne hinguí ne gui hñuxhʉ ntꞌøde núꞌa̱ guí ødehʉ, ne hinguí ne gui pa̱hʉ núꞌa̱ guí hanthʉ. Nuꞌahʉ hinguí ne gui hanthʉ, nixi gui ꞌyødehʉ, nixi gui pa̱hʉ, ngueꞌa̱ hinguí ne gui ntsøꞌmhʉ pa ga punꞌa ri tsꞌoquihʉ. Nuna guehna bi ma̱nga ra ba̱di Isaía de ya ꞌña̱gamfri ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pe nuꞌahʉ xa ja̱pꞌahʉ Ajua̱, ngueꞌa̱ xcá hyanthʉ co ri thandihʉ, ne xcá ꞌyøhʉ co ri ntꞌødehʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Xi majua̱ni dí xiꞌahʉ gue ndunthi yá ꞌmɛhni Ajua̱ núꞌʉ mi ꞌbʉi mayaꞌbʉ ne maꞌra ya hoja̱ꞌi mi nehma̱ꞌʉ xa hyandi ngu núꞌa̱ guí hanthʉbya, pe himbi za bi hyandiꞌʉ. Ne mi nehma̱ da ꞌyøde nuya ya noya guí ødehʉbya, pe himbi za bi ꞌyødeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nubyá ꞌyøhʉ xá hño te rí bønga núꞌa̱ ra ꞌbede stá xiꞌahʉ de ra motꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nuꞌʉ ya nda bi dagui ja ra ꞌñu go gueꞌʉ ngu núꞌʉ toꞌo bi ꞌyøde ra noya de hanja ri nda̱ Ajua̱ ne himbi zo yá mfeni. Nuꞌbʉ́ bi yʉtꞌa ra tsꞌonda̱hi ja yá mfeni pa bi puꞌtua gatho núꞌa̱ xqui ba̱hma̱ꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nuꞌʉ ya nda bi dagui ja ra ꞌbodo go gueꞌʉ ngu núꞌʉ toꞌo bi ꞌyøde ra ma̱ca noya ne ꞌbestho bi gamfrihma̱ co ꞌnara johya, ");
INSERT INTO oteNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pe hinxqui zɛ yá jamfri, hangue nu mi tho ya tsꞌothogui ne ya ntꞌʉtsate po rá ngue ra ma̱ca noya, nuꞌʉ́ ꞌbestho bi ꞌuegue. ");
INSERT INTO oteNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nuꞌʉ ya nda bi dagui ja ya ꞌmini go gueꞌʉ ngu núꞌʉ toꞌo bi ꞌyøde ra ma̱ca noya pe ꞌbestho bi ꞌbɛ yá jamfri ne bi ꞌuegue ngueꞌa̱ nsøctho mi oda yá mfeni ra boja̱ ne maꞌra ya tꞌøtꞌe de ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pe nuꞌʉ ya nda bi dagui ja ra hoga hai go gueꞌʉ ngu núꞌʉ toꞌo bi ꞌyøde ra ma̱ca noya ne bi zo yá mfeni, ne xi bi zɛdi yá jamfri. Nuꞌbʉ́ go gueꞌʉ xi bi unga ra sofo nja ngu ya nda, ꞌra bi unga ꞌna nthebe, ha nu maꞌra bi unga hñuꞌrate, ha nu maꞌra bi unga ꞌnatemaꞌrɛtꞌa. ");
INSERT INTO oteNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nepʉ ra Jesu bi metuabiꞌʉ maꞌna ra ꞌbede ne bi ꞌñembi: ―Nurá hmanda ra Nda̱ de mahetsꞌi nja ngu ꞌnara motꞌi bi motꞌa ra trigo ja rá hua̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pe nu mi ꞌña̱ha̱ yá mɛfi, bi zø ꞌnará ncontraꞌa̱ ne bi moꞌtua ꞌraya tsꞌonda̱po ja rá hua̱hi. Nepʉ de gueꞌa̱ ꞌbestho bi ma. ");
INSERT INTO oteNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ha nu mi føxa ra trigo, nehe bi føxa ya tsꞌonda̱po. ");
INSERT INTO oteNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nepʉ ya ꞌbɛgo bi ma bá ambabi ra mehua̱hi ne bi ꞌñembi: “Ndada, ¿ha gue hingo ra trigo gá potꞌa ja ri hua̱hi? ¿Hanja go bi cꞌontsꞌa nehe ꞌraya tsꞌonda̱po?” ");
INSERT INTO oteNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nuꞌbʉ́ ra mehua̱hi bi da̱tuabi yá ꞌbɛgo bi ꞌñembabi: “Za̱i ꞌnama ncontra toꞌo bi motꞌa núꞌʉ ya tsꞌonda̱po.” Nuꞌbʉ́ ya ꞌbɛgo bi ꞌñemba ra mehua̱hi: “¿Ha guí ne ga ma ga cꞌʉꞌtshe núꞌʉ ya tsꞌonda̱po?” ");
INSERT INTO oteNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nuꞌbʉ́ bi da̱di ra mehua̱hi bi ꞌñena: “Hina, oxqui ma gui cꞌʉꞌtshʉ ya tsꞌonda̱po, ngueꞌa̱ nuꞌbʉ gui cꞌʉꞌtshʉ ya tsꞌonda̱po, ¿xiꞌbʉ gui cꞌʉꞌtshʉ nehe ra trigo? ");
INSERT INTO oteNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hophʉ da te mahyɛgui, cabo gue núꞌa̱ ra pa de ra sofo ga ꞌbɛpa ya xofo da hyɛtsꞌi ꞌmɛtꞌo núꞌʉ ya tsꞌonda̱po, ne da duꞌti pa da tsa̱tꞌi, ha nura trigo da muntsꞌi pa da mɛꞌtsa ja ra troha.” ");
INSERT INTO oteNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nepʉ ra Jesu bi metuabiꞌʉ maꞌna ra ꞌbede ne bi ꞌñembi: ―Rá hmanda Ajua̱ mahetsꞌi nja ngu ꞌnara nda dega mostasa núꞌa̱ bi motꞌa ꞌnara ja̱ꞌi ja rá hua̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Núꞌa̱ ra ndaꞌa̱ maꞌna xi ra zi lotsi de gatho maꞌra yá nda ya nda̱po, pe nu sta nteꞌa̱, maꞌna ra da̱ngui de gatho maꞌra ya nda̱po, ne da nte xi ra da̱ngui ngu ꞌnara ꞌbai gá za, y asta ja da hyocni yá ꞌbafi ya tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nepʉ bi xipa maꞌna ra ꞌbede bi ꞌñembi: ―Nurá hmanda Ajua̱ mahetsꞌi nja ngu ꞌnara ꞌbɛhña̱ bi hyoca ra thuhme ne bi ꞌyɛntsꞌua ra nzoi núꞌa̱ ri japi da netsꞌi ra thuhme, ne mi ngu ꞌnate kilo ra arina bi mantꞌi, ne masque ꞌna zi tʉqui bi japi, pe bi netsꞌi gatho. ");
INSERT INTO oteNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gatho núꞌa̱ mi xipa ya ja̱ꞌi ra Jesu bi xipabi dega ꞌbede. ");
INSERT INTO oteNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hangue bi njabʉ ngu núꞌa̱ xqui ma̱nga ꞌnará ꞌmɛhni Ajua̱ mayaꞌbʉ bi ꞌñena: Ma ga petuabi ꞌraya ꞌbede ya ja̱ꞌi, pa ga utuabi núꞌa̱ hinto xa ba̱di desde bi mʉdi ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nepʉ ra Jesu bi ꞌñedi ya ja̱ꞌi pa da ma ja yá ngu, y neheꞌa̱ bi ma ja núꞌa̱ ra ngu habʉ mi ꞌbʉi. Nepʉ yá nxadi bi ma bá tsʉdi ne bi ꞌñembabi: ―Xi da xicje xá hño te rí bønga núꞌa̱ ra ꞌbede de ya tsꞌonda̱po bi føxa ja ra hua̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Núꞌa̱ ra mehua̱hi bi motꞌa ra trigo ja rá hua̱hi go gueꞌa̱ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ha nura hua̱hi go gueꞌa̱ ra ximhai, ha nura trigo go gueꞌʉ núꞌʉ ꞌbʉi ja rá hmanda Ajua̱, ha nuya tsꞌonda̱po go gueꞌʉ núꞌʉ øtua rá hmanda ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nura ncontra toꞌo bi motꞌa ya tsꞌonda̱po go gueꞌa̱ ra tsꞌonda̱hi. Ha nura pa de ra sofo go gueꞌa̱ rá nga̱tsꞌi ra ximhai, ha nuꞌʉ ya xofo go yá ɛnxɛ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nja ngu ya xofo da ꞌueca ya tsꞌonda̱po pa da tsa̱tꞌi, njabʉ nehe ja rá nga̱tsꞌi ra ximhai ya ɛnxɛ da ꞌueca núꞌʉ ya ja̱ꞌi øtua rá hmanda ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da mɛhna yá ɛnxɛ pa da ꞌueca gatho ya ꞌyøtꞌatsꞌoqui ne gatho ya tsꞌoꞌmʉi gá ja̱ꞌi pa hinda yʉtꞌa mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nuꞌʉ́ ma da tꞌeque pa da thøtꞌa ja ra tsibi núꞌa̱ ma da nzø pa nza̱ntho, y nuni ja di zohma̱ni ne ja di gusthma̱ni yá tsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nepʉ nuꞌʉ tóꞌo ꞌyo xá hño ja rá thandi Ajua̱ ma da yotꞌiꞌʉ ngu ꞌnara da̱nga ñotꞌi nuni mahetsꞌi habʉ bí mandaꞌa̱. Nuꞌa̱ tóꞌo pɛꞌtsa ra paha da ꞌyøde nuya ya noya dí ma̱, dá ꞌyøde. ");
INSERT INTO oteNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Rá hmanda ra Nda̱ de mahetsꞌi nja ngu ra boja̱ xa tꞌagui mbo ja ra hai, y nura boja̱ꞌa̱ bi dini ꞌnara ja̱ꞌi ne bi yopa goꞌmithoni maꞌnaꞌqui. Nuꞌbʉ́ nuꞌá̱ co ra johya bi da̱ma pa gatho núꞌa̱ te mi pɛꞌtsi pa da danga núꞌa̱ ra hai habʉ xqui dinga ra boja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nehe rá hmanda ra Nda̱ de mahetsꞌi nja ngu ꞌnara duqui núꞌa̱ mi tuca ya hoga tꞌaxa do yá thuhu ya perhla. ");
INSERT INTO oteNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nu mi zʉdi ꞌnara hoga perhla xi mi muui ndunthi, nuꞌbʉ́ nuꞌá̱ bi da̱ma pa gatho núꞌa̱ te mi pɛꞌtsi pa bi danga núꞌa̱ ra perhlaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nehe rá hmanda ra Nda̱ de mahetsꞌi nja ngu ꞌnara xitꞌa̱ bi tꞌɛntꞌa ja ra ndehe ne bi gʉ ꞌramaꞌnaꞌño ya hua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Y nu mi ñutsꞌi ra xitꞌa̱, ya mɛhua̱ bi hña̱i pa ja ra ña̱nthe. Ne bi hñudiꞌʉ pa bi huahna ya hoga hua̱ pa bi yʉtꞌa ja ra ꞌbøtsꞌe; ha nuꞌʉ himyá hoga hua̱ bi føtbʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma da njabʉ nehe ja rá nga̱tsꞌi ra ximhai, ma da ꞌñehe ya ɛnxɛ pa da ꞌueca ya tsꞌoꞌmʉi de ja ya hoja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne núꞌʉ ya tsꞌoꞌmʉi ma da thøtꞌa ja ra tsibi núꞌa̱ ma da nzø pa nza̱ntho, y nuni ja di zohma̱ni ne ja di gusthma̱ni yá tsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nuꞌbʉ́ ra Jesu bi ꞌñembabi yá nxadi: ―¿Ha gue xa zo ri mfenihʉ gatho núꞌa̱ stá xiꞌahʉ? Nuꞌbʉ́ nuꞌʉ́ bi da̱tuabi ne bi ꞌñembi: ―Ha̱ha̱, ma zi Hmuꞌihe. ");
INSERT INTO oteNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nuꞌbʉ́ nuꞌá̱ bi ꞌñembabiꞌʉ: ―Xá hño ꞌbʉ. Nubyá da za gui ꞌñudihʉ hingue hønsɛ núꞌa̱ bi ma̱nga ra Moise ne maꞌra yá ꞌmɛhni Ajua̱, pe nehe da za gui ꞌñudihʉ ma ꞌraꞌyo ntꞌutuate dí uꞌtꞌaꞌihʉ de hanja ri nda̱ Ajua̱, gui njahʉ ngu ꞌnara dada de ꞌnara ngu jʉqui nura ora honi gatho núꞌa̱ te xa mɛꞌtsa mayaꞌbʉ ne ja guehya. ");
INSERT INTO oteNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ha nu mi uadi ra Jesu bi ma̱nga nuya ya zi ꞌbede, bi ma de guehni. ");
INSERT INTO oteNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ne bi ma pa ja rá haiꞌa̱, y de mi ꞌbʉhni mi pa ja ra nija̱ de guehni pa mi xahna ya ja̱ꞌi. Y nuꞌʉ́ xi bi ꞌyø ne bi ꞌñena: ―¿Habʉ xuá pa̱di núꞌa̱ ra mfa̱di pa̱hni? ¿Ne há xqui ba̱hni ꞌbʉ nuya ya da̱nga ntꞌudi øtꞌe? ");
INSERT INTO oteNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ha gue hingo guehni rá tꞌʉ núꞌa̱ ra yaxi? ¿Ha gue hingo guehni rá tꞌʉ ra Maria? ¿Ha gue hingo guehni rá cu ra Cobo ne ra Jose, ne ra Simu ne ra Juda? ");
INSERT INTO oteNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ha gue hingyá menguua yá nju nehe? ¿Habʉ xuá ba̱dini gatho núꞌa̱ ma̱ ne gatho núꞌa̱ øtꞌe? ");
INSERT INTO oteNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y ya ja̱ꞌi de guehni mi pø yá cuɛ con gueꞌa̱ ne himbi ne bi gamfri. Hangue nura Jesu bi ꞌñembabiꞌʉ: ―ꞌNará ꞌmɛhni Ajua̱ habʉraza ri ꞌyo ri hnumansu, pe ja rá haisɛ hina, nixi ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hangue ra Jesu himbi ꞌyøtꞌa ndunthi ya da̱nga ntꞌudi de guehni ngueꞌa̱ ya ja̱ꞌi himbi ne bi gamfri. ");
INSERT INTO oteNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ha nuya paꞌʉ ra nda̱ Erode bi ꞌyøde de gatho núꞌa̱ te mi øtꞌa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ne bi ꞌñembabi yá mfatsꞌi: ―Nura ꞌñøhøꞌa̱ go gueꞌa̱ ra Xuua Xiꞌtsate xa yopa nte, hangue pɛꞌtsa ra tsꞌɛdi pa da ꞌyøtꞌa nuya ya ntꞌudi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ra Erode bi benga njabʉ ngueꞌa̱ ꞌnaꞌqui bi gʉ ra Xuua bi duꞌti ne bi gotꞌa fadi ngueꞌa̱ ra Xuua mi ha̱cua hma̱ha̱ ra Erode gue hinda zimba rá ꞌbɛhña̱ rá cu núꞌa̱ rá thuhu ra Lipe, ha nura ꞌbɛhña̱ rá thuhu ra Erodía. ");
INSERT INTO oteNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ngueꞌa̱ ra Xuua xqui ꞌñemba ra Erode: ―Hindí ꞌñepi gui ꞌbʉhui ra Erodía. ");
INSERT INTO oteNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hangue ra Erode bi bø rá cuɛ ne mi nehma̱ da hyo ra Xuua, pe himbi za bi hyoꞌa̱ ngueꞌa̱ mi tsu ya ja̱ꞌi ngueꞌa̱ mi camfriꞌʉ gue ra Xuua go ꞌnara hoga ba̱di. ");
INSERT INTO oteNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pe ꞌnaꞌqui bi tꞌumba rá pa ra Erode, ne nurá tꞌixu ra Erodía bi nei ja yá thandi gatho núꞌʉ mi ꞌbʉhni, y ra Erode xi bi hopa rá hnei. ");
INSERT INTO oteNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hangue bi ña̱tuabi da umbabi gatho núꞌa̱ go da ꞌyadi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nuꞌbʉ́ núꞌa̱ ra nxutsi bi ꞌñembabi ra Erode: ―Dí ne gui ꞌracagui rá ña̱xu ra Xuua Xiꞌtsate ja ꞌnara manza. Gueꞌa̱ bi ꞌyadiꞌa̱ ngueꞌa̱ njabʉ ya xqui xipabi rá na̱na̱ núꞌa̱ ra nxutsi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nuꞌbʉ́ ra Erode xi bi du rá mʉi, pe himbi za bi gømbi ngueꞌa̱ njabʉ xqui ña̱tuabi ne xqui ꞌyøde núꞌʉ mi huhuini ja ra mexa. ");
INSERT INTO oteNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nuꞌbʉ́ bi manda da thɛcua rá ña̱xu ra Xuua núꞌa̱ mi jotꞌa fadi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nepʉ bá tha̱ ra ña̱xu ja ꞌnara manza pa bi tꞌumbabi núꞌa̱ ra nxutsi, ne nuꞌá̱ bi hña̱ꞌtsuabi rá na̱na̱. ");
INSERT INTO oteNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nepʉ yá nxadi ra Xuua bi ma ja ra fadi habʉ mi jotꞌi hma̱ha̱ꞌa̱ pa bi duꞌtsuabi rá ngøquꞌei pa bi ma bá agui. Nepʉ bi maꞌʉ bá xipa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ha nu mi ꞌyøde ra Jesu de núꞌa̱ xqui nja, nuꞌá̱ bi bøxa ja ꞌnara motsa bi ꞌranga ja ra ndehe pa gá ma ja ꞌnara mbonthi habʉ mi joꞌo ra ja̱ꞌi. Pe ya ja̱ꞌi bi ꞌyøde gue xqui ma ra Jesu, hangue nuꞌʉ́ bi ma ꞌñoua desde ja ya hnini pa bi ma bá cꞌa̱ꞌtsiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ha mi zønga ja ra mbonthi ra Jesu bi hyanda xica ja̱ꞌi ya mi ꞌbʉhni, hangue nuꞌá̱ bi huequiꞌʉ ne bi ꞌyøthe gatho núꞌʉ mi hñeni. ");
INSERT INTO oteNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Y nu mi nde bi joni yá nxadi ra Jesu habʉ mi ꞌbaiꞌa̱ ne bi ꞌñembabi: ―Pɛhna nuyʉ ya ja̱ꞌi da ma ja ya hnini pa da dai te da zi, ngueꞌa̱ nuua habʉ dí ꞌbʉhʉ go ra mbonthi, ¿te ga umfʉ da ziyʉ? ne ya ꞌyo rí nde nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nuꞌbʉ́ ra Jesu bi da̱tuabiꞌʉ ne bi ꞌñembi: ―Hingo mahyoni ga pɛhni da dai te da ziyʉ. Go da umfʉ te da zi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nuꞌbʉ́ nuya nxadi bi da̱di ne bi ꞌñena: ―Hønsɛ cʉtꞌa ya thuhme ne yoho ya hua̱ dí ha̱he, hinda uadi pa gathoyʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nuꞌbʉ́ ra Jesu bi ꞌñembiꞌʉ: ―Bá ha̱ncahʉua. ");
INSERT INTO oteNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nepʉ bi japabi ya ja̱ꞌi da hñudi ja ya zi ꞌbotꞌɛi. Ne mri hña̱ núꞌʉ cʉtꞌa ya thuhme ne núꞌʉ yoho ya hua̱, bi nøtsꞌe pa mahetsꞌi bi ꞌyapabi Ajua̱ da ja̱pi. Ne bi hyeca ya thuhme, ne bi umba yá nxadi pa bi hyecua ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gatho ya ja̱ꞌi bi ñuni ne bi niña̱ꞌʉ. Y gatho nuya zi xɛni bi bongui bi hmuntsꞌi ne bi ñuxa ꞌrɛtꞌamayoho ya ꞌbøtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mi ngu cʉtꞌa ꞌmo ya ꞌñøhø núꞌʉ bi ñuni, y nuya ꞌbɛhña̱ ne ya ba̱tsi himbi ma ꞌmede. ");
INSERT INTO oteNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nepʉ ra Jesu bi ꞌbɛpa yá nxadi da yʉtꞌa ja ra motsa pa da ꞌmɛtꞌoꞌʉ pa riꞌnandi, ha nuꞌá̱ bi gohni pa bi ꞌñedi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Y nu mi uadi bi ꞌñehui ya ja̱ꞌi bi bøxa ja ra tꞌøhø pa bá apabi Ajua̱ ꞌnambʉsɛ. Y ya bi nxuui mi ꞌbʉhnitho sɛhɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ha nura motsa habʉ mi pa yá nxadi ya mi pa madetho ra ndehe, ne xi mi fɛtꞌa ntsꞌɛdi ra bʉnthi ja ra ndehe, ne mi ne da mpʉntsꞌiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ne himi hatsꞌitho ra Jesu mi ꞌyo maña̱ ja ra dehe pa bi ma bá tsʉdi yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ne nu mi hyanda ya nxadi ra Jesu mi ꞌyo maña̱ ja ra dehe, nuꞌʉ́ xi bi ntsu ne bi ꞌñena: ―¡Ay! ¡Ndi hyanthʉ ꞌnara pite! ");
INSERT INTO oteNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pe ra Jesu ꞌbestho bi ꞌñembabiꞌʉ: ―Oguí tsuhʉ, go guecagui. ");
INSERT INTO oteNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nuꞌbʉ́ ra Pedro bi da̱di ne bi ꞌñembi: ―Ma zi Hmuꞌi, nuꞌbʉ xi go gueꞌaꞌi, ꞌbɛpcagui ga ꞌyo maña̱ ja ra dehe pa ga mabʉ habʉ guí ꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Bá ehe ꞌbʉ. Ra Pedro bi ga̱i de ra motsa ne bi mʉdi bi ꞌño maña̱ ja ra dehe pa bi ma hma̱ha̱ habʉ mi ꞌyo ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pe nu mi hyanda ra bʉnthi bi ntsu, nepʉ bi mʉdi bi yʉi ja ra dehe, nuꞌbʉ́ bi mafi ne bi ꞌñena: ―Ma zi Hmuꞌi, faxcagui pa hinga ja̱tꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nuꞌbʉ́ ra Jesu ꞌbestho bi mipa rá ꞌyɛ ne bi ꞌñembabi: ―Xi tsꞌʉtho ri jamfri. ¿Pa te gá ntsu? ");
INSERT INTO oteNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nepʉ nuꞌʉ́ bi bøxa ja ra motsa ne ꞌbestho bi tsaya ra bʉnthi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ne de ya mi ꞌbʉi mbo ra motsa, ya nxadi bi nsunda ra Jesu, bi ndandiña̱hmu ne bi ꞌñenaꞌʉ: ―Xi majua̱ni go gueꞌi rá Tꞌʉꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nepʉ bi zøñꞌʉ ja ra hai Genesare riꞌnandi de ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ha nu mi hyanda ya mengu de guehni gue bi zønga ra Jesu ja yá haiꞌʉ, nuꞌbʉ́ nuꞌʉ́ bi da̱ma xanga ra noya pa bi sipa gatho ya ja̱ꞌi de núꞌa̱ ra haiꞌa̱. Nepʉ bá tsꞌimpabi ra Jesu ndunthi ya daꞌthi. ");
INSERT INTO oteNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ne nuya daꞌthi mi adi hønsɛ qué da danbabi rá he, y gatho núꞌʉ toꞌo bi ꞌyøtꞌa njabʉ ꞌbestho bi ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nuꞌbʉ́ ꞌraya xahnate de ra ley ne ꞌraya fariseo xqui ꞌñehe de Jerusale pa da cꞌa̱ꞌtsa ra Jesu, ne bi ꞌyambabi ꞌnara ntꞌani bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Hanja nuyʉ ri nxadi hingui øtꞌe ngu mi øtꞌa ndu ma xitahʉ? Ngueꞌa̱ nuyʉ́ hingui xʉꞌyɛ ꞌmɛtꞌo pa da ñuni. ");
INSERT INTO oteNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Y ra Jesu bi da̱tuabiꞌʉ ne bi ꞌñembi: ―Nequi ma ga anꞌahʉ ꞌnara ntꞌani. ¿Hanja go guí øthʉ núꞌʉ ri nza̱ihʉ ne hingo guí øtuabihʉ yá hmanda Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ngueꞌa̱ Ajua̱ bi manda njaua ne bi ꞌñena: “Umba ra tꞌequꞌei ri dada ne ri na̱na̱ ne suꞌʉ.” Nehe bi ꞌñena: “Nuꞌa̱ tóꞌo da zanga rá dada ne rá na̱na̱, nuꞌá̱ pɛꞌtsi da du.” ");
INSERT INTO oteNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pe nuꞌahʉ́ guí eñhʉ gue xá hño toꞌo da ꞌñemba rá dada o rá na̱na̱: “Ya hinda za ga faxꞌaꞌi, ngueꞌa̱ núꞌa̱ ma stá ꞌraꞌahma̱, ya stá ña̱ꞌtuabi Ajua̱ ga umbi.” ");
INSERT INTO oteNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hangue guí eñhʉ gue njabʉ hinguá hyoni da jamasu rá dada o rá na̱na̱ ꞌna. Hangue hinguí øthʉ núꞌa̱ ri manda Ajua̱, go guí øtꞌasɛhʉ núꞌa̱ go ri nza̱ihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nuꞌahʉ xi gyá yohmihʉ. Hangue majua̱ni núꞌa̱ xqui ma̱nga ra ba̱di Isaía de gueꞌahʉ ne bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nuna ra hninina̱ ri xøcambenigui dega netho, pe nuyá mfeni go bí ꞌyo yabʉ de guequi. ");
INSERT INTO oteNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hinte ri muui yá søcambeni núꞌa̱ øtꞌe, ngueꞌa̱ nuꞌʉ yá ntꞌutuate udiꞌʉ go de yá mfenisɛ, ne ma̱ñꞌʉ gue go stá utuaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nepʉ ra Jesu bi zofo ra hmuntsja̱ꞌi ne bi ꞌñembi: ―Hñuxhʉ ntꞌøde xá hño ne dá zo ri mfenihʉ núꞌa̱ ma ga xiꞌahʉ: ");
INSERT INTO oteNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hingue co núꞌa̱ te cʉtꞌa ja rá ne ra ja̱ꞌi ri ntsꞌoqui, pe co núꞌa̱ te pønga ja rá ne, con gueꞌa̱ ha̱, ri ntsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ꞌMɛfa yá nxadi bi joni habʉ mi ꞌbai ra Jesu ne bi ꞌñembi: ―¿Ha gue hinguí pa̱di gue xi bi bø yá cuɛ ya fariseo co nuya noya gá ma̱? ");
INSERT INTO oteNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pe ra Jesu bi da̱tuabi yá nxadi ne bi ꞌñembi: ―Gatho núꞌʉ ya nda̱po hingo bi motꞌa numa Dada bí ꞌbʉi mahetsꞌi, ma dra cꞌʉꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hyɛhʉbʉ ya fariseo dí ꞌyobʉ co yá ngoda, nuꞌʉ́ ri zi yá migodaui. Nuꞌbʉ ꞌnara goda da gʉhna rá migodaui, da ma ri yohoꞌʉ da zoui mahyɛgui ja ra oꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ra Pedro bi ꞌyambabi ra Jesu ne bi ꞌñembabi: ―Xicje te rí bønga núꞌa̱ ra ꞌbede gá ma̱ de hanja ri ntsꞌoca ꞌna. ");
INSERT INTO oteNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ra Jesu bi da̱di bi ꞌñembi: ―¿Ha gue ni gueꞌahʉ hingui tsoda ri mfenihʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ha hinguí pa̱hʉ gue gatho núꞌa̱ guí tsihʉ rí ma ja ri mʉihʉ ne thoguitho? ");
INSERT INTO oteNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pe nuꞌbʉ guí beñhʉ ya tsꞌomfeni, go gueꞌʉ da bønga ja ri nehʉ, y núꞌa̱ go gueꞌa̱ da jaꞌahʉ gui ntsꞌoquihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngueꞌa̱ ja yá ne ya ja̱ꞌi ja guehni pønga yá tsꞌomfeni, ngu ra nthote, ra nzinga medintha̱ti, ra ntꞌeja̱ꞌi, ra mfe, ra ntꞌeꞌtsate, ra ntsꞌante. ");
INSERT INTO oteNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gatho nuyá ha̱, go guehya ri japi da ntsꞌoca ra ja̱ꞌi. Pe nuꞌa̱ tóꞌo hingui xʉꞌyɛ ꞌmɛtꞌo pa da ñuni, hingo gueꞌa̱ ꞌnara tsꞌoqui øtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nepʉ ra Jesu bi ma de guehni pa ja ra hai guetbʉ ra hnini Tiro ne Sidó. ");
INSERT INTO oteNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ne ja bá nthɛuini ꞌnara ꞌbɛhña̱ mrá me Canaán y himrá me Israel. Mi mafi ne mi ena: ―Huegagui núꞌi Ndada, rá Tꞌʉꞌi ra nda̱ Davi. ꞌNama tꞌixu pɛꞌtsa ꞌnara tsꞌonda̱hi ne xi ntsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pe ra Jesu hinte bi da̱di. Nuꞌbʉ́ ya nxadi bi joni habʉ mi ꞌbai ra Jesu ne bi ba̱ntebi bi ꞌñembi: ―Pɛhni dá ma, ngueꞌa̱ xi mafiua møte ja ma xʉthahe. ");
INSERT INTO oteNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ra Jesu bi da̱di ne bi ꞌñembiꞌʉ: ―Nuga xpá ꞌbɛncagui hønsɛ pa ga muntsꞌa ya me Israel nja ngu ya zi dɛti xa ꞌmɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nepʉ núꞌa̱ ra zi ꞌbɛhña̱ bi ndandiña̱hmu ja yá ua ra Jesu ne bi ꞌñembi: ―Faxcagui, Ndada. ");
INSERT INTO oteNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nuꞌbʉ́ ra Jesu bi da̱tuabi bi ꞌñembi: ―Hindí ꞌñepi da tha̱mba yá thuhme ya ba̱tsi pa go da tꞌumba ya tsatꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nuꞌbʉ́ ra ꞌbɛhña̱ bi da̱di ne bi ꞌñena: ―Majua̱ni guí ma̱, Ndada, pe nuya tsatꞌyo tsi ya xɛca thuhme núꞌʉ tagui de ja yá mexa yá hmu. ");
INSERT INTO oteNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembi: ―Nuꞌi na̱ná̱, xi ra da̱ngui ri jamfri, dá njabʉ ngu núꞌa̱ xcá ꞌyadi. Nuꞌbʉ́ nurá tꞌixu nura ꞌbɛhña̱ꞌa̱ ꞌbestho bi ña̱ni nura oraꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ra Jesu bi ma de guehni ne bi zøni ja rá ña̱ni ra ndehe Galilea. De guehni bi bøxa maña̱ ra tꞌøhø ne ja bá hudiniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y bi mani ndunthi ya ja̱ꞌi mi zi ya doua, ya doꞌyɛ, ya goda, ya gone, ne ndunthi maꞌra ya daꞌthi. Gathoꞌʉ bi tꞌegui ja rá ua ra Jesu ne nuꞌá̱ bi ꞌyøtheꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hangue nura hmuntsja̱ꞌi mi ꞌbʉhni xi bi ꞌyø nu mi ꞌyøde bi ña̱ ya gone, ne mi hyandi bi nxøgue yá ꞌyɛ ya doꞌyɛ, ne bi ꞌño ya doua, y ya goda bi hyandi. Hangue ra hmuntsja̱ꞌi bi xøcambeni Ajua̱ núꞌa̱ xøcambeni ya me Israel. ");
INSERT INTO oteNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nepʉ ra Jesu bi zohna yá nxadi ne bi ꞌñembabi: ―Xi drí hueca nuyʉ ya ja̱ꞌi ngueꞌa̱ pɛꞌtsa hñu pa drí ꞌñohʉ ha hinte xa ziyʉ. Hindí ne da mayʉ co ra thuhu, ngueꞌa̱ xiꞌbʉ da uentꞌa má ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nepʉ yá nxadi bi ꞌñemba ra Jesu: ―Xi nuua ja ra mbonthi ¿habʉ ga tsʉhʉua ra thuhme pa ga ꞌuiñhʉ gatho nuyʉ ya ja̱ꞌi xi ri ndunthi? ");
INSERT INTO oteNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nuꞌbʉ́ ra Jesu bi ꞌyambabiꞌʉ ne bi ꞌñembi: ―¿Hangu ya thuhme guí pɛꞌtshʉ? Nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Hønda yoto ya thuhme dí pɛꞌtshe ne ꞌraya tꞌʉhua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nuꞌbʉ́ ra Jesu bi japa ya ja̱ꞌi da hñudi. ");
INSERT INTO oteNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne mri hña̱ núꞌʉ yoto ya thuhme ne núꞌʉ ya tꞌʉhua̱, nepʉ bi umba njama̱di Ajua̱, nepʉ bi heque bi umba yá nxadi pa da hyecua ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gatho bi ñuni ne bi niña̱, y gatho nuya xɛni bi bongui bi hmuntsꞌi ne bi ñuxa yoto ya ꞌbøtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mi ngu goho ꞌmo ya ꞌñøhø núꞌʉ bi ñuni, y nuya ꞌbɛhña̱ ne ya ba̱tsi himbi ma ꞌmede. ");
INSERT INTO oteNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nepʉ ra Jesu bi ꞌñehui ya ja̱ꞌi, ne bi bøxa ja ra motsa pa bi ma ja ra hai Magdala. ");
INSERT INTO oteNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ya fariseo ne ya saduceo bi maꞌʉ bá honga ra Jesu pa da xaxi. Ha nu mi zʉdi bi xipabi da ꞌñutuabi ꞌnara ntꞌudi pa da gamfriꞌʉ ua xi xqui ꞌñeheꞌa̱ de mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembiꞌʉ: ―Nuꞌahʉ ꞌbʉ guí hanthʉ xa thɛnga mahetsꞌi dega nde, nuꞌbʉ́ guí eñhʉ: “Xudi ma da hñoga pa.” ");
INSERT INTO oteNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y nuꞌbʉ guí hanthʉ dega xudi xa thɛnga ya guui, nuꞌbʉ́ guí eñhʉ gue ma da nja ra bʉnthi ꞌye. ꞌNagyá yohmihʉ, ¿hanja go guí pa̱ gui hyanthʉ mahetsꞌi pa gui pa̱hʉ te ꞌbɛ ma da nja hyastho, y hanja hingo guí huxhʉ nguɛnda de ya ntꞌudi núꞌʉ xqui ꞌñehe de mahetsꞌi pa gui pa̱hʉ gue ra Nda̱ de mahetsꞌi ya xa zøhø? ");
INSERT INTO oteNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nuꞌahʉ́ gyá tsꞌoja̱ꞌihʉ xcá ꞌueguehʉ de Ajua̱, hangue guí adihʉ ꞌnara ntꞌudi gui hyanthʉ pa gui camfrihʉ. Pe nuga hinga ma ga uꞌtꞌaꞌihʉ ꞌnara ntꞌudi ngu núꞌa̱ guí adihʉ. Nura ntꞌudi ma gui hyanthʉ, hønsɛ de ra Joná rá ꞌmɛhni Ajua̱. Ha nu mi uadi ra Jesu bi ma̱nga njabʉ, nuꞌá̱ bi ꞌuegue de gueꞌʉ ne bi ma de guehni. ");
INSERT INTO oteNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nepʉ ra Jesu ne yá nxadi bi ꞌraxa ja ra ndehe pa riꞌnandi, y yá nxadi bi pumfri da hña̱tsꞌi te da ziꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne ra Jesu bi ꞌñembabiꞌʉ: ―Jamasuhʉ de yá nzoi ya fariseo ne ya saduceo. ");
INSERT INTO oteNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nuꞌbʉ́ nuꞌʉ́ bi ꞌñémsɛꞌʉ ꞌna ngu ꞌna: ―Nuní bi ma̱nga njabʉ ngueꞌa̱ hindá ha̱hʉ ra thuhme pa ga tsihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ha nura Jesu bi ba̱di núꞌa̱ mi ma̱ñꞌʉ ne bi ꞌñembabi: ―Nuꞌahʉ xi tsꞌʉtho ri jamfrihʉ. ¿Hanja guí tu ri mʉihʉ de núꞌa̱ te gui tsihʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Hanja hingo tso ri mfenihʉ núꞌa̱ dá xiꞌahʉ? ¿Ha hinguí beñhʉ núꞌʉ cʉtꞌa ya thuhme dá hecuabi núꞌʉ cʉtꞌa ꞌmo ya ꞌñøhø, ne hangu bi bongui xa̱? ");
INSERT INTO oteNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nehe ¿ha gue hinguí beñhʉ núꞌʉ má yoto ya thuhme dá hecuabi núꞌʉ má goho ꞌmo ya ꞌñøhø, ne hangu bi bongui xa̱? ");
INSERT INTO oteNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Hanja hingo bi zo ri mfenihʉ de ra nzoi dá xiꞌahʉ? Hindá xiꞌahʉ de ra thuhme ngu guí beñhʉ. Dá xiꞌahʉ gue gui jamasuhʉ de yá nzoi ya fariseo ne ya saduceo. ");
INSERT INTO oteNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nuꞌbʉ́ ha̱, ja bi zo yá mfeniꞌʉ gue ra Jesu mi xipabi da jamasu de yá ntꞌutuate ya fariseo ne ya saduceo, hingo mi xipabi de yá nzoi ya thuhme. ");
INSERT INTO oteNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mi zøngüi yá nxadi ja ra hai guetbʉ Cesarea de Filipo, ra Jesu bi ꞌyambabiꞌʉ bi ꞌñembi: ―Xi ya ja̱ꞌi ¿te ma̱ de Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, toꞌo gueꞌa̱ ena? ");
INSERT INTO oteNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nuꞌʉ́ bi da̱di bi ꞌñena: ―ꞌRa ena gue go gueꞌaꞌi grá Xuua Xiꞌtsate, maꞌra ena gue go gueꞌaꞌi grá ba̱di Elía, ha nu maꞌra ena gue go gueꞌaꞌi grá Jeremía o ꞌna de gue núꞌʉ maꞌra yá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nepʉ bi yopa ꞌyambabiꞌʉ maꞌnaꞌqui ne bi ꞌñembi: ―Xiꞌahʉ, ¿toꞌo guí beñhʉ go gueque? ");
INSERT INTO oteNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ra Pedro bi da̱di ne bi ꞌñena: ―Nuꞌi go gueꞌaꞌi grá Cristo núꞌi bá pɛñꞌaꞌi Ajua̱ pa gui nda̱, ne go rá Tꞌʉꞌi Ajua̱ núꞌa̱ te. ");
INSERT INTO oteNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Nuꞌi Simu rá tꞌʉꞌi ra Joná, xa ja̱pꞌaꞌi ma Dada bí ꞌbʉi mahetsꞌi, ngueꞌa̱ go bi xiꞌasɛhɛꞌa̱ toꞌogui, hingo bi xiꞌaꞌi ꞌnara ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nubyá dí xiꞌi gue grá Pedro, ne nuri thuhu rí bøni da ꞌñena ꞌnara do. Ne nuꞌi guí nja ngu ra do habʉ ma ga hoca ma nija̱. Y numa nija̱ maꞌna ma da nja rá tsꞌɛdi que ra du. ");
INSERT INTO oteNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nuꞌi go ma ga huxꞌaꞌi ngu grá hña̱nsoqui pa gui xocua ra gosthi toꞌo da yʉtꞌa ja rá hmanda Ajua̱, pa njabʉ nuꞌa̱ gui ꞌyøtꞌa nuua ja ra ximhai, gueꞌa̱ rí tꞌøtꞌe mahetsꞌi, ne nuꞌa̱ gui ma̱ gue hinda tꞌøtꞌe nuua ja ra ximhai, gueꞌa̱ hinda tꞌøtꞌe nehe nuni mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nuꞌbʉ́ nuꞌá̱ bi hñuꞌmba ra hña̱ yá nxadi gue hinda ma̱ñꞌʉ gue go mi gueꞌa̱ ra Cristo núꞌa̱ bá pɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde gueꞌbʉ ra Jesu bi mʉdi bi xipabi yá nxadi gue mi mahyoni da maꞌa̱ pa Jerusale nuni habʉ mi pɛꞌtsi da sufri ja yá ꞌyɛ ya nda̱xjua nda̱ ne ya nda̱ gá macja̱ ne ya xahnate de ra ley. Nehe bi xipꞌʉ gue mi pɛꞌtsi da duꞌa̱, pe rá hñupa mi pɛꞌtsi te da yopa nte. ");
INSERT INTO oteNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nuꞌbʉ́ ra Pedro bi njʉquiui ra Jesu ꞌnambʉ, ne bi mʉdi bi zʉi ne bi ꞌñembi: ―Hina, ma zi Hmuꞌi, Ajua̱ hinda ne gui thogui njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nuꞌbʉ́ ra Jesu bi mpʉntsꞌi ne bi ꞌñemba ra Pedro: ―¡ꞌUegue de gueque nuꞌi Satá! Ngueꞌa̱ nuꞌi guí ne gui hña̱gagui ga øꞌtua rá paha ma Dada. Nura mfeni guí beni go yá mɛti ya ja̱ꞌi, hingo rá mɛti Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nuꞌbʉ́ ra Jesu bi ꞌñembabi yá nxadi: ―Nuꞌa̱ tóꞌo ne da dɛngui pa dua nxadi, hingui tsa da ꞌyøtꞌa rá paha sɛhɛ. Núꞌá̱ mahyoni da ꞌñɛi pa da dɛngagui masque da tho ya ntꞌʉtsate ne ya ꞌbɛtsa. ");
INSERT INTO oteNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngueꞌa̱ nuꞌa̱ tóꞌo ma̱di rá te ne hinda zɛta ya ntꞌʉtsate, núꞌá̱ da ꞌbɛdi rá te pa nza̱ntho, ha nuꞌa̱ tóꞌo da zɛta ya ntꞌʉtsate po rá ngueque, nuꞌá̱ ma da zʉdi rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ne te di muui ꞌnara ja̱ꞌi ꞌbʉ drá mɛti gatho núꞌa̱ te ja ja ra ximhai ne nuꞌá̱ go da ꞌmɛdi? Ngueꞌa̱ ni ꞌna de nuya hñoꞌʉ hinda za da pøhøbi rá te. ");
INSERT INTO oteNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nuꞌa̱ Tóꞌo bi e bi Nja̱ꞌi ma da yopa ꞌñehe co rá nsunda rá Dada, ne ma da tsi yá ɛnxɛ. Y núꞌa̱ ra paꞌa̱ ma da guꞌtuabi ꞌna ngu ꞌna ngu tengu núꞌa̱ xa ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Xi majua̱ni dí xiꞌahʉ gue ꞌra de gueꞌahʉ hingui ma gui tuhʉ asta hingui hyanduahʉ rá nsunda ra Nda̱ de mahetsꞌi Núꞌa̱ bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nurá ꞌrato ma pa ra Jesu bi zixa ra Pedro, ra Cobo, ne ra Xuua rá cu, ne bi ma ja ꞌnara tꞌøhø xá hñetsꞌi pa da ꞌmʉsɛuini. ");
INSERT INTO oteNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nuꞌbʉ́ nuꞌʉ́ bi hyanda ra Jesu bi mpadi, nurá hmiꞌa̱ xi bi yotꞌi ngu ra hyadi y rá he xi xmá ntꞌaxi ngu ꞌnara ñotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne ꞌbestho ra oraꞌa̱ ya nxadi bi hyandi bi zøhø ndu ra Moise ne ndu ra Elía núꞌʉ myá ꞌmɛhni Ajua̱ ne bi ña̱ui ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nuꞌbʉ́ ra Pedro bi ꞌñembabi ra Jesu: ―Ma zi Hmuꞌi, xi xá hño ga ꞌbʉhʉua. ꞌBʉ gui nehma̱, ga hoca hñu ya zi ja̱ꞌtsi, ꞌna pa gueꞌe, ꞌna pa ra Moise, ha nu maꞌna pa ra Elía. ");
INSERT INTO oteNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Y de mi ña̱ ra Pedro bi goꞌmiꞌʉ ꞌnara tꞌaxaguui mri huɛxqui, y nu ja ra guuiꞌa̱ bi ntꞌøde ꞌnara noya bi ꞌñena: ―Nuni go guehni ma hma̱ca Tꞌʉ, ne xi dí hopa rá ꞌmʉi. ꞌYødehʉ núꞌa̱ da ma̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y nu mi ꞌyøde ya nxadi nuna noyana̱ xi bi ntsu, ne co ra ntsu bi dagui maꞌmɛmfo. ");
INSERT INTO oteNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nuꞌbʉ́ ra Jesu bi joni pa bi daniꞌʉ ne bi ꞌñembi: ―Nanjʉ, oguí tsuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Y nu mi gʉxa yá da ya nxadi, ya hønsɛ ra Jesu bi hyandi mi ꞌbahni sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ha nu mi ga̱iꞌʉ de ja ra tꞌøhø ra Jesu bi hñuꞌmba ra hña̱ yá nxadi bi ꞌñembi: ―Oto ma gui xiphʉ de núꞌa̱ gá hyanthʉ bi nja, asta núꞌa̱ ra pa da yopa nte Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, nuꞌbʉ́ ha̱, gueꞌbʉ gui ma̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nuꞌbʉ́ yá nxadi bi ꞌyambabi ne bi ꞌñembi: ―¿Hanja enga ya xahnate de ra ley gue ꞌmɛtꞌo ma da ꞌñehe ra Elía ne ꞌmɛfa da ꞌñehe Núꞌa̱ Toꞌo ma da ꞌñe da Nja̱ꞌiua? ");
INSERT INTO oteNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nuꞌbʉ́ ra Jesu bi da̱di: ―Xi majua̱ni ra Elía ma da ꞌñehe pa da hyocua yá mfeni ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pe nubyá dí xiꞌahʉ gue ra Elía ya bi ꞌñehe, pe himbi gamfri ya ja̱ꞌi ua go mi gueꞌa̱, y nuꞌá̱ bi ꞌyøꞌtuabi gatho núꞌa̱ go bi ne ya ja̱ꞌi. Nehe ya ja̱ꞌi ma da jabʉ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, ngueꞌa̱ nuꞌʉ́ ma da ꞌyøꞌtuabi ra ꞌñʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nuꞌbʉ́ ya nxadi bi ba̱di gue mi xipabi de ra Xuua Xiꞌtsate. ");
INSERT INTO oteNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nepʉ mi zønga ra Jesu co yá nxadi habʉ mi ꞌbʉ ra hmuntsja̱ꞌi, bá ehe ꞌnara ꞌñøhø bi ndandiña̱hmu habʉ mi ꞌbʉ ra Jesu ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Ndada, huega ma tꞌʉ ngueꞌa̱ ra ndusɛhɛ ne xi ntsꞌɛdi. Ndunthi ya ꞌmiꞌqui tso ja ra tsibi ne tso ja ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Hangue por gueꞌa̱ stá tsimpabi ri nxadi pa da ꞌyøthe hma̱ha̱, pe nuyʉ́ hinxa za xa ꞌyøthe. ");
INSERT INTO oteNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―¡Nuꞌahʉ ꞌnagyá ꞌña̱gamfrihʉ ne ꞌnagyá tsꞌoja̱ꞌihʉ! ¡Asta haꞌmʉ gui camfrihʉ! ¡Asta haꞌmʉ ma ga tsɛꞌtꞌaꞌihʉ ri ꞌmʉihʉ! Bá tsincahʉua xa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nuꞌbʉ́ ra Jesu bi zʉi ra tsꞌonda̱hi, ne ꞌbestho bi bøni de núꞌa̱ ra tsꞌʉntꞌʉꞌa̱, ne nuꞌá̱ bi ña̱ni ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ꞌMɛfa ya nxadi bi ña̱sɛui ra Jesu ꞌnambʉ ne bi ꞌñembi: ―¿Hanja nuje himbi za dá ɛñhe núꞌa̱ ra tsꞌonda̱hi? ");
INSERT INTO oteNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ra Jesu bi da̱di bi ꞌñembi: ―Ngueꞌa̱ ꞌna tʉqui ri jamfrihʉ. Xi majua̱ni dí xiꞌahʉ gue nuꞌbʉ gri pɛꞌtshma̱hʉ ri jamfrihʉ masque ngu drá nda̱ngui ꞌnara zi nda gá mostasa, nuꞌbʉ́ asta da za gui ꞌñembahma̱hʉ nuna tꞌøhø da mponi de guecua pa rí ma maꞌna lado, y ꞌbestho da mponi de habʉ ja. ꞌBʉ di ja ri jamfrihʉ, da za gui ꞌyøthʉ gatho núꞌa̱ go gui nehʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pe pa da bønga ya tsꞌonda̱hi ngu núꞌa̱ dá ɛni, mahyoni gui ꞌyaphʉ Ajua̱ ne gui ayunahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ne de ya mi ꞌbʉhni ra Jesu nuni Galilea bi ꞌñemba yá nxadi: ―Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da tꞌɛntꞌua ja yá ꞌyɛ ya ja̱ꞌi, ");
INSERT INTO oteNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nepʉ nuꞌʉ́ ma da hyo. Pe rá hñupaꞌa̱ ma da yopa nte. Pe mi ꞌyøpyaꞌʉ xi bi du yá mʉi ntsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nu mi zønga ra Jesu co yá nxadi ja ra hnini Ncapernau, núꞌʉ toꞌo mi cobra ra boja̱ de ra nija̱ bi ꞌñe bi ꞌyamba ra Pedro bi ꞌñembi: ―Xi ri xahnatehʉ, ¿ha gue hingui jutꞌa ra boja̱ pa ra nija̱? ");
INSERT INTO oteNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ra Pedro bi da̱di ne bi ꞌñembi: ―Ha̱ha̱, jutꞌi. Nepʉ ra Jesu co yá nxadi bi yʉtꞌa mbo ra ngu habʉ mi nza̱i mi oxiꞌʉ. Y ra Jesu bi ꞌyambabi ra Pedro bi ꞌñembi: ―Nuꞌi Pedro, xi núꞌa̱ ra boja̱ ri cobra núꞌʉ ya nda̱ de ya hnini, ¿ha gue go ri cobrabi núꞌʉ ja te yá njaui o núꞌʉ hinte yá njaui? ");
INSERT INTO oteNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ra Pedro bi ꞌñembabi ra Jesu: ―Núꞌʉ hinte yá njaui go gueꞌʉ ri cobrabi. Nuꞌbʉ́ ra Jesu bi ꞌñembabi ra Pedro: ―Nuꞌbʉ́ núꞌʉ ja te yá njaui ya nda̱ hingui jutꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pe pa hinda bø yá cuɛ núꞌʉ toꞌo cobra ra boja̱, grí ma ja ra ndehe, hña̱xa ri ansuelo ne ꞌyɛntꞌa ja ra dehe, y nurá mʉdi ra hua̱ gui jʉ, xocua rá ne, y ja gui hña̱hni núꞌa̱ ra boja̱ rí ꞌñepi ga juthʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ha nuya paꞌʉ yá nxadi bi ꞌyambabi ra Jesu ne bi ꞌñembi: ―¿Toꞌo ma dra da̱ngui nuni mahetsꞌi habʉ bí manda Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nuꞌbʉ́ ra Jesu bi maꞌta ꞌnara zi ba̱tsi ne bi ꞌbaꞌma madetho de gueꞌʉ, ");
INSERT INTO oteNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ne bi ꞌñembabi yá nxadi: ―ꞌBʉ hingui pata ri ꞌmʉihʉ ne gui njahʉ ngu nuna ra zi ba̱tsi, nuꞌbʉ́ hinda za gui cʉthʉ mahetsꞌi habʉ bí manda Ajua̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nuꞌa̱ tóꞌo ne dra da̱ngui nuni mahetsꞌi habʉ bí manda Ajua̱, mahyoni da ntꞌʉqui ngu nuna ra zi ba̱tsi hingrá ꞌñetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ha nuꞌa̱ tóꞌo da umba ntsaya ꞌna ngu nuna ra zi ba̱tsi de ma thuhuga, ja ra uɛnda go guecagui ri ꞌraca ntsaya. ");
INSERT INTO oteNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nuꞌa̱ tóꞌo da ꞌyʉꞌta ꞌna de gue nuya ya zi ba̱tsi camfrigui, nura ja̱ꞌiꞌa̱ maꞌna xá hño dra tsꞌʉtua ꞌnara do strá hñʉ ja rá ꞌyʉga ne da thøtꞌa ja ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Huecate ra meximhai ngueꞌa̱ xi ja ya ntꞌʉꞌtate! Nza̱ntho ma da nja ya ntꞌʉꞌtate, pe ¡huecate ya ꞌyʉꞌtate! ");
INSERT INTO oteNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Hangue nuꞌbʉ ꞌnari ua o ꞌnari ꞌyɛ da jaꞌi gui ꞌyøtꞌa ꞌnara tsꞌoqui, maꞌna xá hño hyɛqui ne ꞌyɛmbʉ. Ngueꞌa̱ maꞌna xá hño gri doua o gri doꞌyɛ gui tsønga mahetsꞌi habʉ bí ja ra te pa nza̱ntho que dri xøgue gatho ri ndoꞌyo ne da tꞌɛntꞌaꞌi ja ra nidu habʉ zø ra tsibi núꞌa̱ hinhyaꞌmʉ da huetꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nehe nuꞌbʉ ꞌnari da da jaꞌi gui ꞌyøtꞌa ꞌnara tsꞌoqui, maꞌna xá hño hña̱i ne ꞌyɛmbʉ. Ngueꞌa̱ maꞌna xá hño dri ꞌbɛdi ꞌnari da gui tsønga mahetsꞌi habʉ bí ja ra te pa nza̱ntho que dri xøgue ri da ne da tꞌɛntꞌaꞌi ja ra nidu habʉ zø ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jamasuhʉ hingui ʉtsahʉ nuyʉ ya zi ba̱tsi, ngueꞌa̱ nza̱ntho ꞌbʉi yá ɛnxɛyʉ ja rá thandi ma Dada bí ꞌbʉ mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi bá ehe pa da pøhø núꞌʉ xa ꞌmɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Te guí beñhʉ ꞌbʉ ꞌnara maꞌyo pɛꞌtsa ꞌna nthebe ya dɛti ne da ꞌmɛdi ꞌna de gueꞌʉ, ¿ha gue hingue da zohma̱ni ja ra tꞌøhø núꞌʉ gohoꞌrate ne ꞌrɛtꞌamagʉto ya dɛti pa da ma da hyonga núꞌa̱ maꞌna xa ꞌmɛdi? ");
INSERT INTO oteNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y nu sta zʉdi, nuꞌbʉ́ núꞌa̱ ra maꞌyo xi da johya ngueꞌa̱ bi zʉdi núꞌa̱ ꞌnará dɛti xqui ꞌmɛdi, y nixi hingui oda rá mfeni núꞌʉ gohoꞌrate ne ꞌrɛtꞌamagʉto hinxa ꞌmɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Njabʉ nehe nuri Dadahʉ bí ꞌbʉi mahetsꞌi hingui ne da ꞌmɛdi ni ꞌna de gue nuya ya zi ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nubyá ma ga xiꞌahʉ, nuꞌbʉ ꞌnari cu da ꞌyøꞌtꞌaꞌi ꞌnara tsꞌocate, grí ma gui cꞌa̱ꞌtsi ne gui ña̱sɛui. ꞌBʉ da ꞌyøde núꞌa̱ gui xipi, nuꞌbʉ́ ya xcá yopa má̱hui ri cu. ");
INSERT INTO oteNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pe nuꞌbʉ hinda ꞌyøꞌtꞌaꞌi, nuꞌbʉ́ tsixa yoho o hñu ya cu pa da ꞌyøde núꞌa̱ ma gui ma̱ñhʉ, pa njabʉ núꞌʉ́ go gueꞌʉ da za da damajua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ha nuꞌbʉ núꞌa̱ ra cuꞌa̱ hinda ꞌyøte núꞌʉ yoho o hñu gui tsitsꞌi, nuꞌbʉ́ xipabi gatho ya gamfri ja ra nija̱. Y nuꞌbʉ nixi con gueꞌʉ hinda ꞌyøteꞌa̱, nuꞌbʉ́ dá tꞌøtꞌa ra uɛnda gue ya hingrá gamfri ne dá thandi ngu ꞌnara da̱ga ꞌyøtꞌatsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Xi majua̱ni dí xiꞌahʉ gue nuꞌa̱ gui ꞌyøthʉ nuua ja ra ximhai, gueꞌa̱ rí tꞌøtꞌe mahetsꞌi, ne nuꞌa̱ gui ma̱ñhʉ gue hinda tꞌøtꞌe nuua ja ra ximhai, gueꞌa̱ hinda tꞌøtꞌe nehe nuni mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nehe ma ga xiꞌahʉ gue nuꞌbʉ yoho de gueꞌahʉ gui ꞌyøthʉ ꞌnara cohi nuua ja ra ximhai de núꞌa̱ ma gui ꞌyadihʉ, nuꞌbʉ́ da ꞌraꞌahʉ ma Dada bí ꞌbʉi mahetsꞌi núꞌa̱ gui ꞌyadihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngueꞌa̱ nu habʉ di ꞌbʉ yoho o hñu di xøcambenigui, nuni ja dí ꞌbʉhni madetho de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nuꞌbʉ́ ra Pedro bi joni habʉ mi ꞌbai ra Jesu ne bi ꞌñembabi: ―Ma zi Hmuꞌi, ¿hangu ya ꞌmiꞌqui mahyoni ga pumbabi ꞌnama miquꞌeiꞌbe ꞌbʉ da ꞌyøtca ꞌnara tsꞌocate? ¿Ha gue asta rá yoto ꞌmiꞌqui? ");
INSERT INTO oteNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ra Jesu bi da̱di ne bi ꞌñembi: ―Hindí eñꞌi gue hønsɛ yoto ꞌmiꞌqui gui pumba ri miquꞌeiui, nuga dí eñꞌi gue asta hñuꞌrate ma ꞌrɛtꞌa ꞌmiꞌqui ya yoto pɛꞌtsi gui pumbi, ne ya nixi gui ꞌyøthʉ ra uɛnda rá ndunthi ya ꞌmiꞌqui gui mpumbahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nubyá ma ga xiꞌahʉ ꞌnara ꞌbede. Nura Nda̱ de mahetsꞌi nja ngu ꞌnara hmu bi ꞌñʉtꞌuɛndaui yá ꞌbɛgo. ");
INSERT INTO oteNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Y nu mi mʉdi ra hmu da ꞌyøtꞌa ra uɛnda, bi zønga ꞌnará ꞌbɛgo xi mi tupabi ndunthi ra boja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ha nura ꞌbɛgoꞌa̱ himi tsa da guꞌtuabi núꞌa̱ mi tupabi rá hmu, hangue ra hmu bi manda da ꞌba nura ꞌbɛgo co rá ꞌbɛhña̱ ne yá ba̱tsi ne gatho núꞌa̱ te mi pɛꞌtsi pa dra joꞌtsuabi rá boja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nuꞌbʉ́ nura ꞌbɛgoꞌa̱ bi ndandiña̱hmu ja rá ua rá hmu ne bi ba̱ntebi bi ꞌñembi: “ꞌYøtca ra ma̱te gui tøbgagui ne ga juꞌtꞌaꞌi gatho núꞌa̱ dí tuꞌaꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nuꞌbʉ́ ra hmu bi yo rá mʉi de rá ꞌbɛgo, bi pumba gatho núꞌa̱ mi tupi, ne bi hyɛgui bi ma. ");
INSERT INTO oteNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ha nu mi ma de guehni nura ꞌbɛgoꞌa̱ bi nthɛui ꞌnará miꞌbɛgoui núꞌa̱ mi tupa ꞌna zi tʉquitho ra boja̱. Bi da̱ma mihi ne bi mʉdi bi miꞌtua rá ꞌyʉga ne bi ꞌñembi: “Nubyá ma gui jutqui gatho núꞌa̱ guí tuqui.” ");
INSERT INTO oteNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nuꞌbʉ́ núꞌa̱ rá miꞌbɛgoui mi tupabi, bi ndandiña̱hmu ja rá uaꞌa̱ ne bi ba̱ntebi bi ꞌñembi: “ꞌYøtca ra ma̱te gui tøbgagui ne ga juꞌtꞌaꞌi gatho núꞌa̱ dí tuꞌaꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pe nuꞌá̱ himbi ne, bi zixa fadi asta himbi guꞌtua gatho rá boja̱ núꞌa̱ mi tupi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nuꞌbʉ́ nu mi hyanda maꞌra yá miꞌbɛgoui xi bi ʉ yá mfeniꞌʉ ne bi ma bá xipabi yá hmu de gatho núꞌa̱ xqui hyandiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nuꞌbʉ́ ra hmu bi zohna núꞌa̱ ra nduthai xqui pumbabi ne bi ꞌñembi: “Nuꞌi, ꞌna xi grá tsꞌoja̱ꞌi. Gatho núꞌa̱ ra boja̱ nguí tucagui go dá punꞌaꞌi ngueꞌa̱ gá ba̱ntegui ga tøpꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ha gue himri ꞌñepꞌaꞌi nehe xcá yo ri mʉi co ri miꞌbɛgoui ngu dá yo ma mʉiga con gueꞌe?” ");
INSERT INTO oteNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nuꞌbʉ́ nura hmu co rá cuɛ bi manda da tsꞌixa fadi núꞌa̱ ra tsꞌoꞌmʉi gá ꞌbɛgo pa da hnaꞌmbabi asta hinda guꞌtua gatho núꞌa̱ mi tupa rá hmu. ");
INSERT INTO oteNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nehe njabʉ ma Dada bí ꞌbʉ mahetsꞌi ma da ꞌyøtꞌe con gueꞌahʉ ꞌbʉ hingui pumbabihʉ nuri miquꞌeihʉ ꞌbʉ da ꞌyøꞌtꞌaꞌihʉ ꞌnara tsꞌocate. ");
INSERT INTO oteNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nu mi uadi ra Jesu bi ma̱nga nuya noyaya, bi bøni de guehni Galilea ne bi ma riꞌnandi ra da̱the Jordá pa habʉ mi o ꞌna xɛni rá hai Judea. ");
INSERT INTO oteNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne xi bi dɛni ndunthi ya ja̱ꞌi ne ja bá øtheni ndunthi ya daꞌthi. ");
INSERT INTO oteNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nepʉ ya fariseo bi ma bá cꞌa̱ꞌtsa ra Jesu pa da xaxi ne bi ꞌñembabi: ―¿Ha gue po nuꞌa̱raza ra tꞌøtꞌe da za da nxungüi rá ꞌbɛhña̱ ꞌnara ꞌñøhø? ");
INSERT INTO oteNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ne ra Jesu bi da̱tuabi ne bi ꞌñembi: ―¿Ha gue hinxcá hñeꞌthʉ ja ri leyhʉ gue Ajua̱ go gueꞌa̱ bi hyoca ra ꞌñøhø ne ra ꞌbɛhña̱ desde rá mʉdi? ");
INSERT INTO oteNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nehe ma̱ gue ra ꞌñøhø da ꞌuegue de rá dada ne rá na̱na̱ pa go da ꞌmʉhui rá ꞌbɛhña̱, y de ri yohoꞌʉ da ꞌnatho. ");
INSERT INTO oteNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hangue dí xiꞌahʉ gue nuꞌʉ́ di ꞌnatho, hingue di yoho. Hangue nuꞌa̱ da pɛhna Ajua̱, hinda za go da ꞌueca ꞌnara ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ya fariseo bi ꞌñembabi ra Jesu: ―Nuꞌbʉ́ ¿hanja ra Moise bi manda da thoca ꞌnara tꞌofo dega nxuni pa da za da hyɛpʉ rá ꞌbɛhña̱ ꞌnara ꞌñøhø? ");
INSERT INTO oteNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Ra Moise bi unga nsɛqui da njabʉ ngueꞌa̱ xi xá me ri corasohʉ, pe Ajua̱ desde rá mʉdi hingá njabʉ mi neꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nuga dí xiꞌahʉ gue nuꞌa̱ tóꞌo da nxungüi rá ꞌbɛhña̱ ne hinxa dimba ꞌnara tsꞌoqui xa ꞌyøtꞌe co maꞌna ra ja̱ꞌi, nuꞌbʉ́ nurá da̱me núꞌa̱ ra ꞌbɛhña̱ ꞌbʉ da ntha̱tui maꞌna ra ꞌbɛhña̱, nuꞌbʉ́ ya bi ꞌyøtꞌa ꞌnara tsꞌoqui. Nehe núꞌa̱ toꞌo da ntha̱tui núꞌa̱ ra ꞌbɛhña̱ xa thɛpʉ, núꞌa̱ ra ꞌñøhø ya ra zinga medintha̱ti. ");
INSERT INTO oteNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nuꞌbʉ́ yá nxadi bi ꞌñembabi ra Jesu: ―Nuꞌbʉ njabʉ, maꞌna xá hño hinda ntha̱ta ꞌna ꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bi da̱di ra Jesu ne bi ꞌñembabi: ―Pe hinda za gatho da ꞌyøtꞌa njabʉ, hønsɛ núꞌʉ toꞌo xa ꞌmʉi pa hinda ntha̱ti. ");
INSERT INTO oteNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ꞌBʉi ꞌraya ꞌñøhø hingui tsa da ntha̱ti ngueꞌa̱ desde bi ꞌmʉi ya mi njabʉ. Nehe ꞌbʉi maꞌra ya ꞌñøhø hingui tsa da ntha̱ti ngueꞌa̱ nuꞌʉ́ ꞌmɛfa ja xa njabʉ. Ne ꞌbʉi maꞌra ya ꞌñøhø hingui ntha̱ti ngueꞌa̱ maꞌna ri ho da mɛpabi Ajua̱ toꞌo ra Nda̱ de mahetsꞌi. Nuꞌa̱ tóꞌo tsa da hña̱ni nuna tsꞌofona̱, dá hña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nepʉ bá tsꞌimpabi ꞌraya zi ba̱tsi ra Jesu pa da hñuxa yá ꞌyɛ ja gueꞌʉ ne da ꞌyapa Ajua̱ da ja̱pꞌʉ. Pe nuyá nxadi bi zʉi núꞌʉ toꞌo mri zi ya zi ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nuꞌbʉ́ ra Jesu bi ꞌñembabi yá nxadi: ―Hophʉ da ꞌñehe ya zi ba̱tsi, oguí ha̱cuabihʉ da ꞌñe da zʉcagui, ngueꞌa̱ gatho núꞌʉ toꞌo ꞌbʉi ja rá hmanda Ajua̱ go gueꞌʉ nja ngu nuya ya zi ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y nu mi uadi ra Jesu bi hñuxa yá ꞌyɛ ja ya zi ba̱tsi, nuꞌá̱ bi ma de guehni. ");
INSERT INTO oteNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ꞌMɛfa bi ꞌñe ꞌnara ba̱sja̱ꞌi pa da ꞌyøꞌtua ꞌnara ntꞌani ra Jesu ne bi ꞌñembi: ―Nuꞌi Xahnate, ꞌnagrá hoja̱ꞌi, ¿te ꞌbɛ da za ga øtꞌe pa da za ga pɛꞌtsa ra te pa nza̱ntho? ");
INSERT INTO oteNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bi da̱di ra Jesu ne bi ꞌñembi: ―¿Hanja guí engui gue drá hoja̱ꞌi? Hønsɛ Ajua̱ go gueꞌa̱ ra hoja̱ꞌi. Pe nuꞌbʉ guí ne gui pɛꞌtsa ra te pa nza̱ntho, ꞌyøtꞌa gatho núꞌa̱ ri manda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bi da̱di ra ba̱sja̱ꞌi ne bi ꞌñena: ―¿Te ma hmandaꞌʉ? Ra Jesu bi ꞌñembi: ―Oxqui hñote, oxqui nzinga medintha̱ti, oxqui mpe, oxqui jʉxa ya ncꞌuamba. ");
INSERT INTO oteNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Umba ra tꞌequꞌei ri dada ne ri na̱na̱ ne suꞌʉ, ma̱di ri miquꞌeiui ne gui su ngu grí nsu sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bi da̱di ra ba̱sja̱ꞌi ne bi ꞌñembi: ―Desde stá mba̱tsi stá øtꞌa gatho núya guí xiqui. Xibya, ¿te maꞌna ri ꞌbɛdi ga øtꞌebya? ");
INSERT INTO oteNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nepʉ ra Jesu bi ꞌñembabi: ―Nuꞌbʉ guí ne gui ꞌbʉi xá hño, grí ma bá pa gatho núꞌa̱ guí pɛꞌtsi ne hecua ya hyoya, pa njabʉ da za gui hña̱nga ꞌnari da̱nga tha̱ha̱ nuni mahetsꞌi. Nepʉ bá ehe gui tɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nu mi ꞌyøde njabʉ núꞌa̱ ra ba̱sja̱ꞌi bi ma xi mi tu rá mʉi ngueꞌa̱ xi mrá rico. ");
INSERT INTO oteNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nuꞌbʉ́ ra Jesu bi ꞌñembabi yá nxadi: ―Xi majua̱ni xi xá hñei da yʉtꞌa ꞌnara rico ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Xi majua̱ni dí xiꞌahʉ gue maꞌna xá hñei da yʉtꞌa ꞌnara rico ja rá hmanda Ajua̱ que da thogui ꞌnara cameyo ja rá gu ꞌnara ꞌyofri. ");
INSERT INTO oteNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Y nu mi ꞌyøde njabʉ ya nxadi xi bi ꞌyø ne bi ꞌñena: ―Nuꞌbʉ njabʉ, ¿toꞌo ja da za da mpøhø? ");
INSERT INTO oteNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ha ra Jesu bi nhyandui yá nxadi ne bi ꞌñembabi: ―Co yá mfenisɛ ya ja̱ꞌi hingui tsa da mpøhø, pe co rá tsꞌɛdi Ajua̱ ha̱, hinte rá hñei. ");
INSERT INTO oteNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nepʉ ra Pedro bi ꞌñembi: ―Nuꞌi guí pa̱di gue nuje stá tsoguihe gatho núꞌa̱ te ndí pɛꞌtshe pa ga tɛnꞌahe. Nuꞌbʉ́ ¿te ma tha̱ha̱ ma ga ha̱ñhe ꞌmɛfa? ");
INSERT INTO oteNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Xi majua̱ni dí xiꞌahʉ gue nurá ñoho ra ꞌmʉi nu sta yopa ꞌñehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi pa da manda co rá nsunda, nuꞌbʉ́ gueꞌbʉ núꞌahʉ xcá tɛngaguihʉ ma da thuxꞌahʉ gui mandahʉ nehe núꞌʉ ꞌrɛtꞌamayoho ya ꞌmʉi de Israel. ");
INSERT INTO oteNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y gatho núꞌʉ toꞌo xa zogui yá ngu o yá cu o yá nju o yá dada o yá na̱na̱ o yá ꞌbɛhña̱ o yá ba̱tsi o yá hai po rá nguecagui, nuꞌʉ́ ma da hña̱nga maꞌna nthebe rá ndunthi de núꞌa̱ xa zogui, ne ma da ꞌmʉi pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ha nuꞌʉ tóꞌo ya da̱nguibya, nura paꞌa̱ ma da notsiꞌʉ, ha nuꞌʉ tóꞌo ya notsibya, nura paꞌa̱ ma da nda̱nguiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nurá hmanda Ajua̱ ma ga hyɛcuahʉ ngu ꞌnara me ua̱ꞌobxi. Nura me ua̱ꞌobxiꞌa̱ xi mi pɛꞌtsa ndunthi ya ua̱ꞌobxi. Ne ꞌnara pa xi ꞌnitho bi ma bi hyonga ꞌraya mɛfi. ");
INSERT INTO oteNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Y bi gohui ra cohi nuya mɛfi gue da guꞌtuabi núꞌa̱ ta̱ha̱ ꞌnara mɛmapa. Nepʉ bi mɛhni da mpɛfi ja yá ua̱ꞌobxi. ");
INSERT INTO oteNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Y mi nzʉnga gʉto bi ma maꞌnaꞌqui bá honga maꞌra ya mɛfi ne bi zʉdi ꞌraya ja̱ꞌi mi ꞌbahni ja ra tai mi otho yá ꞌbɛfi. ");
INSERT INTO oteNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne bi ꞌñembabi: “¿Ha hinguí ne gui faxcahʉ ra ꞌbɛfi ne ga juꞌtꞌahʉ núꞌa̱ rí ꞌñepi gui ta̱hʉ?” Nepʉ nuꞌʉ́ bi mɛui ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nepʉ mi nde ma pa nura ꞌñøhø bi ma maꞌnaꞌqui bá honga maꞌra ya mɛfi, nepʉ ngu nzʉnga hñu bi yopa ma maꞌnaꞌqui bá tsi maꞌra ya mɛfi ne bi ncohui da guꞌtui núꞌa̱ rí ꞌñepi. ");
INSERT INTO oteNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ngu nzʉnga cʉtꞌa bi ma maꞌnaꞌqui ne bi nthɛui maꞌra ya ja̱ꞌi mi otho yá ꞌbɛfi ne bi ꞌñembabi: “¿Hanja guí ꞌbathʉua gatho ra pa? ¿Ha gue otho ri ꞌbɛfihʉ?” ");
INSERT INTO oteNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nuꞌʉ́ bi da̱di ne bi ꞌñembi: “Ngueꞌa̱ hinto xa ꞌracje ra ꞌbɛfi.” Nura hmu bi ꞌñembabi: “Nuꞌbʉ́ faxcahʉ ra ꞌbɛfi nepʉ ga juꞌtꞌahʉ núꞌa̱ rí ꞌñepi gui ta̱hʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ha nu mi yʉ ra hyadi nura hmu bi ꞌñemba ra ꞌbɛtri: “Zohna gatho ya mɛfi, ne gatho gui juꞌtuabi maxøgue ꞌna pa. Juꞌtuabi ꞌmɛtꞌo núꞌʉ bi yʉtꞌa ꞌmɛfa, nepʉ ꞌmɛfa gui juꞌtuabi núꞌʉ bi yʉtꞌa rá mʉdi.” ");
INSERT INTO oteNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ha nu mi zøhø núꞌʉ xqui yʉtꞌa ra ꞌbɛfi nzʉnga cʉtꞌa nde, nuꞌʉ́ bri juꞌtuabi maxøgue ꞌna pa. ");
INSERT INTO oteNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ne mi zøhø núꞌʉ xqui yʉtꞌa ra ꞌbɛfi desde mi xudi, nuꞌʉ́ mi hu yá mʉi gue ma xa da̱ha̱ maꞌna ndunthi, pe nuꞌʉ́ bri juꞌtuabi mahyɛgui ngu núꞌʉ xqui yʉtꞌa mi nde. ");
INSERT INTO oteNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Y nu mi hña̱nga yá tha̱ha̱, xi bi bø yá cuɛ co ra hmu, ");
INSERT INTO oteNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ne bi ꞌñembi: “Núyʉ́ bi yʉtꞌa ꞌmɛfa ne hønsɛ ꞌna ora bi mpɛfi ne gá juꞌtuabi ngu núꞌa̱ dí ta̱he, ha nuje xi stá mpɛhe gatho ra pa co ra pahyadi.” ");
INSERT INTO oteNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nuꞌbʉ́ ra hmu bi ꞌñembabi ꞌna de gueꞌʉ: “Xiꞌague, ¿ha gue dí øꞌtꞌa ꞌnara ntsꞌoꞌmʉi? ¿Ha gue hindá cohʉ ra cohi gue ga juꞌtꞌa núꞌa̱ ta̱ha̱ ꞌnara mɛmapa? ");
INSERT INTO oteNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hña̱xa núꞌa̱ rí ꞌñeꞌaꞌi y grí ma. Nuga dá juꞌtuabi núyʉ bi yʉtꞌa ꞌmɛfa ngu núꞌa̱ gá ta̱ha̱ ngueꞌa̱ dá ne dá øtꞌe njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ha go ma gui hña̱gaguigue núꞌa̱ ga ne ga øtꞌe co ma boja̱? ¿Hanja grí hyøcuabi rá tha̱ha̱ ri mimɛfiui ngueꞌa̱ nuga drá hoja̱ꞌi con guehyʉ?” ");
INSERT INTO oteNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ngueꞌa̱ nuꞌʉ dri ꞌbɛfa go gueꞌʉ dya mʉdi, y nuꞌʉ ya mʉdi go gueꞌʉ da ꞌmɛfa. Ndunthi da tsꞌofo, pe tsꞌʉtho núꞌʉ xa thahni. ");
INSERT INTO oteNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nepʉ ra Jesu bi ma pa Jerusale, ne de má ꞌñu bi ꞌueque ꞌnambʉ núꞌʉ ꞌrɛtꞌamayoho yá nxadi pa bi umba ntꞌøde ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Pa̱hʉ gue nu xcrá tsøñhʉ Jerusale, ja ma dra jʉni Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, ne dra tꞌɛntꞌua ja yá ꞌyɛ ya nda̱ gá macja̱ ne ya xahnate de ra ley, ne nuꞌʉ́ ma da hyøxa ra thai pa da tho. ");
INSERT INTO oteNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nepʉ ma da ꞌyɛntꞌua ja yá ꞌyɛ nuya ja̱ꞌi hingyá xodyo pa da ꞌyøꞌtua ra ntꞌeni ne da ꞌnaꞌmbi, ne da pontꞌi, ne ja da duni, pe rá hñupa ma da yopa nteꞌa̱ maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nepʉ rá na̱na̱ ra Cobo ne ra Xuua yá tꞌʉ ra Sebedeo, bá ꞌñoui yá tꞌʉ habʉ mi ꞌbai ra Jesu ne bi ndandiña̱hmu pa da ꞌyadi núꞌa̱ mi beni da ꞌyadi núꞌa̱ ra ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nuꞌbʉ́ ra Jesu bi ꞌñemba nura ꞌbɛhña̱: ―¿Te rá ꞌbɛ guí ne gui ꞌyadi? Nepʉ ra ꞌbɛhña̱ bi da̱di bi ꞌñena: ―Dí ne gue nuya yoho ma tꞌʉ da hñudi con gueꞌe nu xcrí nda̱, ꞌna da hñudi ja ri ꞌñɛi ha nu maꞌna ja ri nga̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nuꞌbʉ́ ra Jesu bi da̱tuabi núꞌa̱ ra ꞌbɛhña̱ ne bi ꞌñemba ra Cobo ne ra Xuua: ―Nixi guí pa̱hʉ núꞌa̱ guí ahʉ. ¿Ha guí hanthʉ gui tsɛthʉ ya tsꞌothogui ngu núꞌa̱ ma ga tsɛtiga? Nuꞌʉ́ bi da̱di: ―Ha̱ha̱, da za ga tsɛthe nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Xi majua̱ni ma gui thohʉ nehe ya tsꞌothogui ngu núꞌʉ ma ga thoguiga, pe nuꞌa̱ guí nehʉ gue gui hñudihʉ ja ma ꞌñɛi ne ja ma nga̱ha̱, hingo tsa ga ma̱ngá. Numa Dada ha̱, go gueꞌa̱ tsa da ma̱ ne pa̱di toꞌo ma da umbabi nuya hudiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu mi ba̱di núꞌʉ má ꞌrɛtꞌa ya nxadi de núꞌa̱ te xqui ꞌyadi núꞌʉ má yoho ya nxadi mri ncu, nuꞌbʉ́ bi bø yá cuɛꞌʉ co núꞌʉ yoho mri ncu. ");
INSERT INTO oteNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nepʉ ra Jesu bi zofo yá nxadi ne bi ꞌñembi: ―Guí pa̱hʉ gue nuya nda̱ de ja ya hnini, nuꞌʉ́ go ri da̱ma ꞌñexasɛ pa da manda gatho ya ja̱ꞌi, nehe nuyá mfatsꞌiꞌʉ øtꞌe njabʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pe nuꞌahʉ oxqui njahʉbʉ. Ngueꞌa̱ ꞌbʉ ꞌna de gueꞌahʉ gui nehʉ gui nda̱nguihʉ, mahyoni gui ꞌmɛgohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ha nuꞌa̱ tóꞌo ne gue go dra mʉdi de gueꞌahʉ, nuꞌá̱ go gueꞌa̱ mahyoni da ꞌmɛgo. ");
INSERT INTO oteNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Gui njahʉ ngu Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, núꞌá̱ himbá ehe pa da ꞌñe ya ꞌbɛgo, nuꞌá̱ bá ehe pa go bi ꞌmɛgo, ne pa da unga rá te pa da pumba yá tsꞌoqui ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Y de mi bønga de Jericó ra Jesu co yá nxadi, xi ndunthi ya ja̱ꞌi bi dɛniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Y de má ꞌñu mi huhni yoho ya zi goda. Ha nu mi ꞌyødeꞌʉ gue mi pani ra Jesu, bi mafi ne bi ꞌñembabi: ―Nuꞌi Ndada, rá Tꞌʉꞌi ra nda̱ Davi, huegaguihe. ");
INSERT INTO oteNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ya ja̱ꞌi bi goꞌtuabi yá ne pa ya hinda sigui da mafi hma̱ha̱. Pe nuꞌʉ́ maꞌna xi mi mafi ne mi ena: ―Nuꞌi Ndada, rá Tꞌʉꞌi ra nda̱ Davi, huegaguihe. ");
INSERT INTO oteNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nuꞌbʉ́ ra Jesu bi ꞌmai ne bi ꞌñembabi: ―¿Te ꞌbɛ guí ne ga øꞌtꞌahʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Dí ne gui xoga ma dahe, Ndada. ");
INSERT INTO oteNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nuꞌbʉ́ ra Jesu xi bi huequiꞌʉ, ne bi hñuꞌtsua yá ꞌyɛ ja yá da, ne nuꞌʉ́ ꞌbestho bi xo yá da ne bi hyandi. Nepʉ nuꞌʉ́ bi dɛniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nu mi zøni ra Jesu co yá nxadi nuni Betfagué ja rá ua ra tꞌøhø ꞌbo Olivo ya mi guetbʉ pa Jerusale, núꞌá̱ bi mɛhna yoho yá nxadi da ꞌmɛtꞌo, ");
INSERT INTO oteNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ne bi ꞌñembabiꞌʉ: ―Rí maha pa nuna tꞌʉca hnini bí jani. Ha nu xcrí tsøñhʉni ma gui tsʉhʉni ꞌnara zi burru di tha̱tni ne dri zi rá ba̱tsi. Xcrí tsʉhʉ güi xoꞌthʉ ne güi tsincahʉ gatho yoho. ");
INSERT INTO oteNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ꞌBʉ di ꞌbʉpʉ ꞌna, ne da nja te da xiꞌahʉ, ꞌñembabihʉ njaua: “Ra zi Hmu bí honi.” Nuꞌbʉ́ nura ja̱ꞌi ꞌbestho da hoꞌahʉ güi tsincahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gatho bi njabʉ pa bi nja ngu xqui ma̱nga rá ꞌmɛhni Ajua̱ bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Rí maha Jerusale núꞌa̱ ra hnini thuꞌmbabi nehe gue rá thuhu Sion, ne xiphʉ ya mengu de guehni: “Ndi hyanthʉ bra ꞌñehni ri Nda̱hʉ, e da zʉꞌahʉ, ne hingrá ꞌñetsꞌi ngueꞌa̱ bra tøgue ꞌnara zi tꞌʉbru rá ba̱tsi ꞌnara burru núꞌa̱ ya pa̱ ra ndu.” ");
INSERT INTO oteNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nuꞌbʉ́ yá nxadi bi ma ne bi ꞌyøtꞌa núꞌa̱ xqui ꞌbɛpabi. ");
INSERT INTO oteNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nepʉ bá tsimpabi núꞌa̱ ra zi burru mri ꞌñoui rá ba̱tsi. De guehni ya nxadi bi xiꞌtsua yá patꞌiꞌʉ, nepʉ ra Jesu bi tøgue. ");
INSERT INTO oteNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y nura hmuntsja̱ꞌi, ꞌra mi ha̱nca yá patꞌi pa mi pøgue ja ra ꞌñu, ha nu maꞌra mi totꞌa ya ꞌyɛza pa mi pøgue nehe ja ra ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ne ndunthi mri ꞌbɛtꞌo ne ndunthi mi ꞌbɛfa, mi mafiꞌʉ ne mi ena: ―¡Xá nsunda rá ꞌñehe rá Tꞌʉ ra nda̱ Davi! ¡Ajua̱ da ja̱pi núni xpá mɛhni pa da nda̱ ja guecjʉ! ¡Xá nsunda Ajua̱ bí ꞌbʉi mahetsꞌi! ");
INSERT INTO oteNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Y ngu bi yʉtꞌa ja ra hnini Jerusale xi bi nthøxni ya ja̱ꞌi ne mri ꞌñémbabiꞌʉ ꞌna ngu ꞌna: ―¿Toꞌoni ꞌbʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nuꞌbʉ́ núꞌʉ toꞌo mi dɛni, bi da̱di ne bi ꞌñena: ―Nuni go guehni ra Jesu rá ꞌmɛhni Ajua̱ ne ra me Nasare de Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nepʉ ra Jesu bi yʉtꞌa ja ra nda̱nija̱, ne bi ꞌyɛni gatho núꞌʉ toꞌo mri mpa ne mri ntai, ne bi pʉntsꞌua yá mexa ya mpataboja̱, ne bi pʉntsꞌua yá thuhni ya ma domitsu. ");
INSERT INTO oteNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Y bi ꞌñembabi: ―Xa ntꞌofo gue ma ngu ra ngu dega søcambeni, pe nuꞌahʉ́ xcá ꞌyøtꞌathohʉ ra ngu dega mfe. ");
INSERT INTO oteNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ne mi ꞌbʉhni ꞌraya goda ne ya doua ja ra nda̱nija̱. Núꞌʉ́ bi joni habʉ mi ꞌbai ra Jesu, y nuꞌá̱ bi ꞌyøtheꞌʉ, ne bi ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ha nuya nda̱ gá macja̱ ne ya xahnate de ra ley bi hyanda nuya da̱nga tꞌøtꞌe bi ꞌyøtꞌa ra Jesu. Ne bi ꞌyøde nuya ba̱tsi mi mafi ja ra nda̱nija̱ ne mi eñꞌʉ: “¡Xá nsunda rá ꞌñehe rá Tꞌʉ ra nda̱ Davi!” Nuꞌbʉ́ nuya nda̱ gá macja̱ ne ya xahnate de ra ley xi bi bø yá cuɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ne bi xipabi ra Jesu bi ꞌñembi: ―¿Ha gue hinguí øde núꞌa̱ te ma̱nga nuyʉ ya ba̱tsi? Nuꞌbʉ́ ra Jesu bi da̱tuabiꞌʉ ne bi ꞌñembi: ―Ha̱ha̱, dí øde. Xi nuꞌahʉ ¿ha gue hinxcá hñeꞌthʉ ja ra Ma̱ca Tꞌofo habʉ ena njaua?: Asta ya ba̱tsi ne ya ꞌuɛne núꞌʉ tsʉtho, Ajua̱ bi ꞌyøtꞌe pa bi xøcambeniꞌa̱ xi xá hño. ");
INSERT INTO oteNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nuꞌbʉ́ ra Jesu bi zoguini ya nda̱ gá macja̱ ne ya xahnate de ra ley, ne bi ma Betania pa ja bá oxini. ");
INSERT INTO oteNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Rá hyaxꞌa̱ bi menga pa Jerusale, ne de má ꞌñu bi zʉ ra thuhu. ");
INSERT INTO oteNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y ja rá hyo ra ꞌñu bi hyandi mi ꞌbahni ꞌnara ꞌbai gá igo, ne bi ma pa habʉ mi ꞌbai pa bi hyonga ꞌraya igo pa da zihma̱, pe hinte mi tøgue ni ꞌna, hønsɛ yá xi mi cꞌamtho. Nuꞌbʉ́ bi ꞌñembabi ra ꞌbai gá igo: ―Hinhyaꞌmʉ ma da nøgue ri igo. Y ꞌbestho nura oraꞌa̱ bi ꞌyotꞌa núꞌa̱ ra ꞌbai gá igo. ");
INSERT INTO oteNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Y nu mi hyanda ya nxadi núꞌa̱ xqui nja, xi bi ꞌyø ne bi ꞌñemba ra Jesu: ―¿Hanja ꞌbestho bi ꞌyotꞌa nuna ꞌbai gá igo? ");
INSERT INTO oteNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ra Jesu bi da̱tuabi ne bi ꞌñembi: ―Xi majua̱ni dí xiꞌahʉ, ꞌbʉ xi gri pɛꞌtshʉ ndunthi ra jamfri ne hingri dʉhʉhʉ, nuꞌbʉ́ da za gui ꞌyøthʉ ya tꞌøtꞌe ngu núna dá øtꞌe. Nehe da za gui ꞌñemfʉ nuna ra tꞌøhø da mponi rí ma pa ja ra ndehe, ne da mponi. ");
INSERT INTO oteNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gatho núꞌa̱ gui ꞌyadihʉ ne guí camfrihʉ, gatho da za gui hña̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nepʉ ra Jesu bi yʉtꞌa maꞌnaꞌqui ja ra nda̱nija̱ Jerusale, ne bi nxahnate. Y nura ora mi xahnate, bi joni habʉ mi ꞌbaiꞌa̱ yá nda̱xjua nda̱ ya xodyo ne ya nda̱ gá macja̱, ne bi ꞌyambabi: ―¿Toꞌo rá ꞌmɛhniꞌi pa gui ꞌyøtꞌa nuya ya tꞌøtꞌeya? ¿Toꞌo bi ꞌraꞌa nsɛqui pa gui ꞌyøtꞌa njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Nequi ma ga øꞌtꞌahʉ ꞌnara ntꞌani. Nuꞌbʉ gui xicjʉ, nequi ga xiꞌahʉ toꞌo rá ꞌmɛhnigui pa dí øtꞌa njaua. ");
INSERT INTO oteNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xi núꞌa̱ ra sistehe mi øtꞌa ra Xuua Xiꞌtsate, xiꞌa̱ ¿toꞌo go bá pɛhnꞌa̱, Ajua̱ o ya ja̱ꞌi? Nuꞌbʉ́ nuꞌʉ́ bi mʉdi bi ꞌñámbasɛꞌʉ ne mri ꞌñémbabi: ―¿Te ga tha̱tuahʉbya? Nuꞌbʉ ga emfʉ gue Ajua̱ go bá pɛhni, nuꞌbʉ́ nuꞌá̱ da ꞌñengaguihʉ: “Nuꞌbʉ́ ¿hanja hingá camfrihʉ núꞌa̱ mi ma̱ñꞌa̱?” ");
INSERT INTO oteNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ha nuꞌbʉ xi ga emfʉ gue ra Xuua go bá pɛhna ya ja̱ꞌi, nuꞌbʉ́ nuꞌʉ́ da nja te da ꞌyøtcahʉ, ngueꞌa̱ gathoꞌʉ beni gue ra Xuua go mrá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nuꞌbʉ́ ya nda̱ gá macja̱ ne ya nda̱xjua nda̱ bi da̱tuabi ra Jesu ne bi ꞌñembi: ―Hindí pa̱he. Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Nequi hinga xiꞌahʉ toꞌo bá pɛncagui pa dí øtꞌa nuya ya tꞌøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nepʉ ra Jesu bi yopa ꞌñembabi ya nda̱ gá macja̱: ―¿Te guí nuhma̱guehʉ? ꞌNara ꞌñøhø mi pɛꞌtsa yoho yá tꞌʉ, ne bi ꞌñemba ꞌna de gueꞌʉ: “Rí ma ra ꞌbɛfibya ja ra ua̱ꞌobxi.” ");
INSERT INTO oteNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nuꞌbʉ́ nura tꞌʉꞌa̱ bi da̱di ne bi ꞌñena: “Hina, papá, hinga ma.” Pe ꞌmɛfa bi ntsøꞌmsɛ ne bi ma ra ꞌbɛfi. ");
INSERT INTO oteNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nepʉ ra dada bi ꞌñembabi núꞌa̱ maꞌna rá tꞌʉ: “Rí ma ra ꞌbɛfibya ja ra ua̱ꞌobxi.” “Ha̱ha̱, papá, ga ma”, bi ꞌñembi. Pe nixi himbi ma. ");
INSERT INTO oteNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hangue de ri yoho ya tꞌʉ, ¿ndaꞌa̱ gueꞌa̱ bi ꞌyøtua núꞌa̱ bi ꞌbɛpabi rá dada? Bi da̱di ya nda̱ gá macja̱ ne bi ꞌñena: ―Núꞌa̱ ra tꞌʉ bi mɛhna rá mʉdi. Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ gue ya da̱ga ꞌyøtꞌatsꞌoqui ne ya tsꞌoja̱ꞌi go gueꞌʉ ri ꞌbɛtꞌo que gueꞌahʉ pa da yʉtꞌa ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngueꞌa̱ ra Xuua Xiꞌtsate bi ꞌñehe bi ꞌñuꞌtꞌahʉ ra hñoja̱ꞌi, pe nuꞌahʉ́ hingá ne gá camfrihʉ núꞌa̱ bi ma̱ñꞌa̱. Pe nuya da̱ga ꞌyøtꞌatsꞌoqui ne ya tsꞌoja̱ꞌi, nuꞌʉ́ ha̱, bi gamfri núꞌa̱ bi ma̱nga ra Xuua ne bi ñobriꞌʉ. Pe nuꞌahʉ́ masque gá hyanthʉ bi ñobriꞌʉ, pe hingá ne gá ñobrihʉ y nixi gá camfrihʉ núꞌa̱ bi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nepʉ ra Jesu bi yopa ꞌñemba ya nda̱ gá macja̱: ―ꞌYøhʉ maꞌna ra ꞌbede ma ga xiꞌahʉ: Mi ꞌbʉ ꞌnara ꞌñøhø xi mi pɛꞌtsa ndunthi ya hai, y nuya haiꞌʉ ja bi ga̱xni ndunthi ya obxi ne bi gutsꞌi. Nepʉ ja bi hyocni yoho ya ngu, ꞌna pa habʉ da thɛꞌma ra ngui gá obxi, ha nuꞌa̱ maꞌna pa ra døꞌma hua̱hi. Y nepʉ bi umba hñandi yá ua̱ꞌobxi ꞌrayá mɛfi. Nepʉ nuꞌá̱ bi ma yabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ha nu mi nja ra nthʉqui, nura me ua̱ꞌobxi bi mɛhna ꞌrayá ꞌbɛgo pa da cꞌa̱ꞌtsa ya hyanthua̱hi pa da hña̱nga núꞌa̱ made mri ꞌñepabi. ");
INSERT INTO oteNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pe núꞌʉ ya hyanthua̱hi bi gʉmpa yá ꞌbɛgo ra me ua̱ꞌobxi, ꞌna bi naꞌmbabi, nu maꞌna bi hyo, ha nu maꞌna bi tɛdo. ");
INSERT INTO oteNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nepʉ rá ñoꞌqui, ra me ua̱ꞌobxi bi mɛhna maꞌna ndunthi yá ꞌbɛgo, pe neheꞌʉ bri jabʉ ngu bi tꞌøꞌtuabi núꞌʉ yá mʉdi. ");
INSERT INTO oteNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Rá nga̱tsꞌi ra me ua̱ꞌobxi bi mɛhnasɛ rá tꞌʉ ne bi ꞌñena: “Numa tꞌʉ ha̱, ma da tꞌøte.” ");
INSERT INTO oteNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pe nu mi hyanda ya hyanthua̱hi nura tꞌʉ, nuꞌʉ́ bi ꞌñémbi ꞌna ngu ꞌna: “Nuni go guehni ma da tsꞌocuabi ya hai. Maha ga hohʉ pa go ga cohʉ nuya hai.” ");
INSERT INTO oteNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nuꞌbʉ́ ya hyanthua̱hi bi gʉ ra tꞌʉ ne bi gʉqui de ra ua̱ꞌobxi, ne bi hyo. ");
INSERT INTO oteNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Xi nura me ua̱ꞌobxi, ¿te ma da ꞌyøꞌtuabi núꞌʉ ya hyanthua̱hi nu sta yopa mengui ja rá hai? ");
INSERT INTO oteNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nuꞌbʉ́ ya nda̱ gá macja̱ bi da̱di ne bi ꞌñena: ―Ra me ua̱ꞌobxi hinda hueca nuya tsꞌoja̱ꞌi. Ma da hyoꞌʉ, y nuya ua̱ꞌobxi ma da umba hñandi maꞌra yá mɛfi. Ne nuꞌʉ́ ha̱, ma da umba ra me ua̱ꞌobxi made núꞌa̱ rí ꞌñepabi. ");
INSERT INTO oteNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nuꞌbʉ́ ra Jesu bi ꞌñembabi ya nda̱ gá macja̱: ―Ha gue hinxcá hñeꞌthʉ ja ra Ma̱ca Tꞌofo núꞌa̱ mi ma̱nga rá ꞌmɛhni Ajua̱ maꞌmɛtꞌo ne bi ꞌñena: Núꞌa̱ ra do bi føthma̱bʉ ꞌna lado nuya hyøngu, nubya gueꞌa̱ ra mʉdi do de rá nija̱ Ajua̱. Y nusɛꞌa̱ go bi mɛgui nura doꞌa̱ pa da hyø rá nija̱, ne dí hanthʉ gue xi rá nsunda núꞌa̱ bi ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hangue dí xiꞌahʉ gue ma da tha̱nꞌahʉ núꞌa̱ ra tsꞌɛdi guí pɛꞌtshʉ pa gui cʉthma̱hʉ ja rá hmanda Ajua̱, ne ma go da tꞌumbabi maꞌra ya ja̱ꞌi núꞌʉ toꞌo ma da ꞌyøꞌtua núꞌa̱ da ꞌbɛpabi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nuꞌa̱ tóꞌo da feꞌtsa nura doꞌa̱ da cuentꞌua yá ndoꞌyo, y nuꞌa̱ tóꞌo da zɛꞌmi da quꞌɛꞌti. ");
INSERT INTO oteNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Y nu mi ꞌyøde ya nda̱ gá macja̱ ne ya fariseo nuya ya noyaya, nuꞌʉ́ bi unga nguɛnda gue go mi sipabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hangue nuꞌʉ́ mi ne da gʉhma̱ ra Jesu, pe mi tsu ya ja̱ꞌi ngueꞌa̱ nuya ja̱ꞌi mi beni gue ra Jesu go ꞌnará ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ra Jesu bi yopa zofo ya nda̱ gá macja̱ ne ya nda̱xjua nda̱, ne bi xipa maꞌna ra ꞌbede, ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ra Nda̱ de mahetsꞌi ma ga hyɛcuahʉ ngu ꞌnara nda̱ bi ꞌyøtꞌa ꞌnara ngo ngueꞌa̱ bi ntha̱ta rá tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bi mɛhna yá ꞌbɛgo pa da tsi núꞌʉ mi thøꞌmi da ꞌmʉ ja ra ngo. Pe nuꞌʉ́ himbi ne bi ꞌmʉhni. ");
INSERT INTO oteNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nepʉ núꞌa̱ ra nda̱ bi mɛhna maꞌnaꞌqui maꞌra yá ꞌbɛgo ne bi ꞌñembi: “Bá xiphʉ núꞌʉ toꞌo dí tøꞌmhe gue ya stá hñocje, ne ya stá hohe ya nda̱mfri ne maꞌra ya hnoca mboꞌoni. Ya gatho xa nthoqui, ꞌñemfʉ da ꞌñehe ra ngo.” ");
INSERT INTO oteNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pe núꞌʉ toꞌo mi thøꞌmi hingo bi jamasu núꞌa̱ bi xipa nuya ꞌmɛhni, ꞌna bi mada ra ꞌbɛfi ja yá hua̱hi, ha nu maꞌna bi ma da nu rá ꞌbɛfi ja ra hnini, ");
INSERT INTO oteNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ha nu maꞌra bi gʉmpa yá ꞌmɛhni ra nda̱, bi naꞌmbi nepʉ bi hyo. ");
INSERT INTO oteNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ha nu mi ba̱di ra nda̱ núꞌa̱ te xqui tꞌøꞌtuabi yá ꞌmɛhni, xi bi bø rá cuɛ. Hangue nuꞌá̱ bi mɛhna yá soldado pa bi hyo núꞌʉ ya hyote, nepʉ bi tsꞌa̱ꞌtuabi yá hniniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nepʉ ra nda̱ bi ꞌñembabi yá ꞌbɛgo: “Ya ja gatho pa ra ngo, pe núꞌʉ toꞌo ndí tøꞌmi himbi ne bi ꞌñehe, bi ntsꞌocꞌbaha. ");
INSERT INTO oteNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hangue nubyá grí maha ja ya da̱ꞌñu, ne bá tsihʉ gatho núꞌʉ gui tsʉhʉbʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nuꞌbʉ́ bi ma ya ꞌbɛgo bá muntsꞌa gatho núꞌʉ bi zʉdi ja ya ꞌñu, ya tsꞌoꞌmʉi ne ya hoja̱ꞌi. Njabʉ bi ñuxa nura da̱nga ngu habʉ bi nja ra ngo. ");
INSERT INTO oteNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nuꞌbʉ́ ra nda̱ bi yʉtꞌa mbo habʉ mi ja ra ngo pa bi zɛngua núꞌʉ xqui zøhø. Ne bi hyanda ꞌna mi ꞌbʉhni núꞌa̱ hinxqui hye ra he dega ngo. ");
INSERT INTO oteNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hangue nuꞌá̱ bi ꞌñembabi: “Amigo, ¿hanja gá cʉtꞌiua hingá he núꞌa̱ ra he dega ngo?” Pe nuꞌá̱ hinte bi da̱di. ");
INSERT INTO oteNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nuꞌbʉ́ ra nda̱ bi ꞌñembabi yá ꞌbɛgo: “Tha̱ꞌtuahʉ yá ua ne yá ꞌyɛ nuna ja̱ꞌi, ne bá føthʉbʉ møte ja ra ꞌbɛxuui pa ja dí nzonini ne ja dí gustri yá tsꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nu mi uadi ra Jesu bi metuabi ra ꞌbedeꞌʉ bi ꞌñembi: ―Ngueꞌa̱ ndunthi da tsꞌofo, pe tsꞌʉtho núꞌʉ xa thahni. ");
INSERT INTO oteNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nuꞌbʉ́ nu mi ꞌyøde ya fariseo nuya noyaya, nuꞌʉ́ bi njʉqui pa bi ma̱mbi hanja da za da xaxa ra Jesu dega noya. ");
INSERT INTO oteNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nuꞌbʉ́ bi mɛhna yá mfatsꞌiꞌʉ mahyɛgui co ꞌrayá mfatsꞌi ra nda̱ Erode pa bá øꞌtua ꞌnara ntꞌani ne bi ꞌñembi: ―Xahnate, dí pa̱he gue nuꞌi guí ma̱nga núꞌa̱ majua̱ni, ne guí udi xi xá hño rá noya Ajua̱, ne hinto guí tsu, nixi guí huahna ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hangue dá e ga anꞌahe te guí xicje, ¿ha gue xá hño ga juthe núꞌa̱ ra boja̱ adi ra nda̱ Cesa, o hina? ");
INSERT INTO oteNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pe ra Jesu bi ba̱tuatho yá tsꞌomfeniꞌʉ, hangue bi ꞌñembi: ―Nuꞌahʉ́ ꞌnagyá yohmihʉ, ¿pa te guí xaxcahʉ? ");
INSERT INTO oteNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ꞌÑutcahʉua núꞌa̱ ra boja̱ adi ra nda̱ Cesa. Nuꞌbʉ́ nuꞌʉ́ bi ꞌñutuabi núꞌa̱ ra boja̱ mi adi. ");
INSERT INTO oteNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ha ra Jesu bi hyandi bi ꞌñembabi: ―¿Toꞌo rá cꞌoi núna huxcua ja ra boja̱, ne te rá ꞌbɛ ma̱ngua? ");
INSERT INTO oteNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ha nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Rá cꞌoi ra nda̱ Cesa. Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Umfʉ ra nda̱ Cesa núꞌa̱ rí ꞌñepabiꞌa̱, y nehe umfʉ Ajua̱ núꞌa̱ rí ꞌñepabi. ");
INSERT INTO oteNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nu mi ꞌyøde njabʉꞌʉ, xi bi ꞌyø ntsꞌɛdi. Nepʉ bi zohni ra Jesu, bi maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Núꞌa̱ ra paꞌa̱, bi zøhø habʉ mi ꞌbʉ ra Jesu ꞌraya saduceo núꞌʉ mi camfri gue hinda yopa nte núꞌʉ xa du. Nuꞌʉ́ bi ꞌyambabi ra Jesu ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Xahnate, ra Moise bi ma̱ gue ꞌbʉ ꞌnara ꞌñøhø da du ne hinda zogui ni ꞌnará ba̱tsi, nuꞌbʉ́ ꞌna de gue núꞌʉ yá cu núꞌa̱ ra ꞌñøhø bi du da ntha̱tui núꞌa̱ ra ꞌbɛhña̱ bi gohi sɛhɛ pa da pøtua rá ꞌbai ndu rá cu, ne da mɛꞌtsua ya ba̱tsi pa da thuꞌmbabi rá thuhu ndu rá cu. ");
INSERT INTO oteNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nuje dá pa̱he yoto ya ꞌñøhø mri ncu, nuꞌa̱ rá mʉdi bi ntha̱ti pe ꞌmɛfa bi du, ne himbi zocuabi ni ꞌnara ba̱tsi. Nepʉ ꞌmɛfa nurá ꞌbɛhña̱ bi ntha̱tui ꞌnará cu ndu rá da̱me. ");
INSERT INTO oteNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nehe bi du núꞌa̱ rá ñoho ra ꞌñøhø, nehe núꞌa̱ rá hñu, ne bi njabʉ gatho núꞌʉ yoto ya ꞌñøhø bi ntha̱tui ꞌnadra ꞌbɛhña̱, ne ꞌmɛfa bi uadi bi du ꞌramaꞌna gatho núꞌʉ yoto. ");
INSERT INTO oteNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y rá nga̱tsꞌi bi du ra ꞌbɛhña̱ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nuꞌbʉ́ xi sta yopa nte gatho núꞌʉ xa du, ¿toꞌo xi majua̱ni drá ꞌbɛhña̱ núꞌa̱ ra ꞌbɛhña̱ bi ntha̱tui gatho núꞌʉ yoto ya ꞌñøhø mri ncu? ");
INSERT INTO oteNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nuꞌbʉ́ ra Jesu bi da̱tuabi ne bi ꞌñembi: ―Xi xá ntsꞌo ri mfenihʉ ngueꞌa̱ hinguí pa̱hʉ ra Ma̱ca Tꞌofo nixi rá tsꞌɛdi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngueꞌa̱ nura pa da yopa nte núꞌʉ xa du, ya hinda ma da ntha̱ti ya ja̱ꞌi, ngueꞌa̱ nuꞌʉ́ ma da nja ngu ya ɛnxɛ núꞌʉ bí ꞌbʉi mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pe de núꞌa̱ rá ñoho ra ꞌmʉi, ¿ha gue hinxcá hñeꞌthʉ núꞌa̱ bi ma̱nga Ajua̱ ne bi ꞌñena?: ");
INSERT INTO oteNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nuga go rá Ajua̱gui ra Abrá, ne ra Isaac, ne ra Cobo.” Ajua̱ go gueꞌa̱ ra Ajua̱ de núꞌʉ te, hingue de núꞌʉ xa du. Hangue ra Abrá ne ra Isaac ne ra Cobo bí te ja rá thandi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ne nu mi ꞌyøde ya ja̱ꞌi nurá ntꞌutuate ra Jesu, xi bi ꞌyø. ");
INSERT INTO oteNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nu mi ba̱di ya fariseo gue ra Jesu xqui goꞌtua yá ne ya saduceo, nuꞌbʉ́ bi muntsꞌiꞌʉ pa da nu te da ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nepʉ ꞌna de gueꞌʉ mrá xahnate de ra ley bi ma bá xaxa ra Jesu, bi ꞌyøꞌtua ꞌnara ntꞌani ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Xahnate, ¿ndaꞌa̱ gueꞌa̱ ra hmanda maꞌna ra da̱ngui de gatho núꞌʉ ya hmanda huxa ja ra ley? ");
INSERT INTO oteNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ha ra Jesu bi da̱di ne bi ꞌñembi: ―“Ma̱di Ajua̱ ri Hmu con gatho ri mʉi, con gatho ri tsꞌɛdi, ne con gatho ri mfeni.” ");
INSERT INTO oteNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nuna go guehna xi ra da̱ngui ne ra mʉdi hmanda. ");
INSERT INTO oteNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y nurá ñoho ra hmanda ngutꞌatho, núꞌa̱ ena gui ma̱di ri miquꞌeiui ne gui su ngu grí nsu sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ne gatho núꞌa̱ bi ma̱nga ra Moise ja ra ley, ne núꞌa̱ bi ma̱nga maꞌra yá ꞌmɛhni Ajua̱, ne nuya yoho ya da̱nga hmanda, go ri ꞌnatho. ");
INSERT INTO oteNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","De mi ꞌbʉhnitho ya fariseo, ra Jesu bi ꞌyøꞌtuabi ꞌnara ntꞌani nehe, ");
INSERT INTO oteNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ne bi ꞌñembabi: ―Xiꞌahʉ, ¿te xi guí ma̱ñhʉ de ra Cristo rá ꞌmɛhni Ajua̱ núꞌa̱ ma da nda̱? ¿Toꞌo guí emfʉ gue rá tꞌʉꞌa̱? Ya fariseo bi da̱di ne bi ꞌñena: ―Rá tꞌʉ ra nda̱ Davi. ");
INSERT INTO oteNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nepʉ ra Jesu bi ꞌñembabiꞌʉ: ―Nuꞌbʉ́ ¿hanja ra Davi po rá tsꞌɛdi ra Ma̱ca Nda̱hi bi ma̱ gue ra Cristo go gueꞌa̱ rá Hmu? Ngueꞌa̱ ra Davi bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ajua̱ ra Dada bi ꞌñembabi ma zi Hmu: “Bá ehe gui hñudiua ja ma ꞌñɛi asta hinga tsiñꞌaꞌi gatho ri ncontra pa da gohiꞌʉ de njaꞌti ri ua.” ");
INSERT INTO oteNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ha nuꞌbʉ go drá tꞌʉhma̱ ra Davi nura Cristo, nuꞌbʉ́ ¿hanja bi ꞌñenga ra Davi gue go rá Hmu? ");
INSERT INTO oteNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nuꞌbʉ́ ya fariseo himbi za te bi da̱di, y desde ra paꞌa̱ ya ni ꞌna de gueꞌʉ himbi za bi ꞌyøꞌtua maꞌra ya ntꞌani ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nepʉ ra Jesu bi zofo yá nxadi ne ra hmuntsja̱ꞌi ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Nubya ya fariseo ne ya xahnate de ra ley uꞌtꞌaꞌihʉ te rí bøni da ma̱nga ra ley núꞌa̱ bi ꞌyofo ra Moise. ");
INSERT INTO oteNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hangue gatho núꞌa̱ da xiꞌahʉꞌʉ ꞌyøtꞌehʉ, ne ostí ma da zabiꞌihʉ gui ꞌyøthʉ. Pe nehe oxqui tɛnbahʉ yá tsꞌoꞌbɛfiꞌʉ. Nuꞌa̱ udiꞌʉ gueꞌa̱ xá hño, pe nuꞌʉ́ hingo øtꞌe núꞌa̱ udiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nuꞌʉ́ tutua ya ja̱ꞌi ya ꞌbatsꞌi xi xá hñʉ, pe nuꞌʉ́ ni tsꞌʉ yá mfatsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nuꞌʉ́ øtꞌa yá ꞌbɛfi ja yá thandi ya ja̱ꞌi pa da pønga yá hmi, asta cueta ya tꞌofo ja yá de ne tsʉta ya pantsꞌa xifri ja yá ꞌyɛ y ja xa ntꞌofoni ꞌraya xɛni de ra Ma̱ca Tꞌofo, ne nuyá he maꞌna xá ma de yá he maꞌra ya ja̱ꞌi pe yá ntꞌetsꞌitho. ");
INSERT INTO oteNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nuꞌʉ́ de ja ꞌnara ngo ri ho da hñudi ja ya mʉdi hudi pa da ñuni, ne ri ho da hñudi ja ya hoga hudi nuni ja yá nija̱ pa da tꞌeꞌtsua yá nsu. ");
INSERT INTO oteNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nuꞌʉ́ ri ho dra zɛnjua ja ra tai co ndunthi ra tꞌequꞌei, ne ri ho da tꞌembabi gue go gueꞌʉ xi ya hoga xahnate. ");
INSERT INTO oteNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pe nuꞌahʉ́ oxqui hohʉ toꞌo da ꞌñeꞌtsꞌa ri nsuhʉ da ꞌñeñꞌahʉ gue go gyá xahnatehʉ, ngueꞌa̱ gathoꞌihʉ grí ncuhʉ, ne ꞌnatho ri xahnatehʉ ꞌbʉi, y núꞌá̱ go gueꞌa̱ ra Cristo núꞌa̱ toꞌo bá pɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Y nixi núꞌʉ toꞌo xahnꞌaꞌihʉ nuua ja ra ximhai, oxqui emfʉ gue go gueꞌʉ ri dadahʉ, ngueꞌa̱ ꞌnatho ri Dadahʉ ꞌbʉi, y núꞌá̱ go gueꞌa̱ bí ꞌbʉi mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Y nixi oxqui ma gui hohʉ da tꞌeñꞌahʉ gue go gyá nda̱hʉ, ngueꞌa̱ ꞌnatho ri nda̱hʉ ꞌbʉi, y núꞌá̱ go gueꞌa̱ ra Cristo núꞌa̱ toꞌo bá pɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ꞌBʉ ꞌna de gueꞌahʉ da ne toꞌo da nda̱ngui, mahyoni go gueꞌa̱ dri ꞌbɛgohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngueꞌa̱ nuꞌa̱ tóꞌo ri ꞌñexasɛbya, ꞌmɛfa da ua rá ntꞌetsꞌi, pe nuꞌa̱ tóꞌo hingrá ꞌñetsꞌibya, ꞌmɛfa go ma da tꞌeꞌtsua rá nsu ja rá thandi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Núꞌahʉ xahnatehʉ de ra ley ne núꞌahʉ gyá fariseohʉ, ꞌnagyá yohmihʉ, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Xcá coꞌthʉ ra gosthi pa hinto da yʉtꞌa ja rá hmanda Ajua̱, nixi guí cʉthʉ, ha nixi guí hophʉ toꞌo da yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Núꞌahʉ xahnatehʉ de ra ley ne núꞌahʉ gyá fariseohʉ, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Xi grí xadihma̱hʉ ja ri nija̱hʉ ja yá thandi ya ja̱ꞌi ꞌñena hinte guí øthʉ, pe ꞌnagyá yohmihʉ ngueꞌa̱ guí ha̱nbahʉ yá ngu ya ꞌbɛnte viuda, hangue Ajua̱ maꞌna ma da castigaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Núꞌahʉ xahnatehʉ de ra ley ne núꞌahʉ gyá fariseohʉ, ꞌnagyá yohmihʉ, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Nuꞌahʉ grí mahʉua grí mahʉni guí hoñhʉ ya ja̱ꞌi pa gui ꞌñutuabihʉ núꞌa̱ ri jamfrihʉ, y nuꞌbʉ ya bi gamfriꞌihʉ, nuꞌbʉ́ maꞌna guí tsꞌocuahʉ yá mfeni, ne maꞌna ya gá ꞌyɛnthʉ ja ra nidu ngu núꞌa̱ habʉ grí maha nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Nuꞌahʉ́ guí ne gui ꞌñuhma̱hʉ ra ꞌñu, pe nixi guí pa̱hʉ habʉ grí maha nehe, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Ngueꞌa̱ guí eñhʉ gue ꞌbʉ ꞌnara ja̱ꞌi da jura po ra nija̱, hinte ri muui núꞌa̱ bi jura. Pe ꞌbʉ da jura po ra oro núꞌa̱ ja mbo ra nija̱, nuꞌbʉ́ ha̱, guí eñhʉ gue ri muui núꞌa̱ bi jura. ");
INSERT INTO oteNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡ꞌNagyá ꞌbɛmfenihʉ, ya xcá ꞌbɛhʉ ra ꞌñu! ¿Ndaꞌa̱ maꞌna ri muui, ra nija̱ o núꞌa̱ ra oro ja mbo ra nija̱? Ra nija̱ gueꞌa̱ maꞌna ri muui, ngueꞌa̱ ja xra ja̱pini ra oro. ");
INSERT INTO oteNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nehe guí eñhʉ gue ꞌbʉ toꞌo da jura po ra ata hinte ri muui núꞌa̱ bi jura. Pe nuꞌbʉ da jura por núꞌa̱ ra ꞌbaha xa thuxa ja ra ata, nuꞌbʉ́ ha̱ guí eñhʉ gue ri muui núꞌa̱ bi jura. ");
INSERT INTO oteNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡ꞌNagyá ꞌbɛmfenihʉ, ya maꞌna xcá ꞌbɛhʉ ra ꞌñu! ¿Ndaꞌa̱ maꞌna ri muui, ra ata o núꞌa̱ ra ꞌbaha xa thuxni ja ra ata? Ra ata gueꞌa̱ maꞌna ri muui ngueꞌa̱ ja bri ja̱pini núꞌa̱ ra ꞌbahaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hangue nuꞌa̱ tóꞌo ri jura po ra ata, hingue hønsɛ po ra ata ri jura, nehe ri jura po gatho núꞌa̱ ra ꞌbaha xa thuxni nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne nuꞌa̱ tóꞌo ri jura po ra nija̱, hingue hønsɛ po ra nija̱ ri jura, nehe ri jura po Ajua̱ ngueꞌa̱ nuꞌá̱ ja ꞌbʉhniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nuꞌa̱ tóꞌo ri jura po mahetsꞌi, hingue hønsɛ po mahetsꞌi ri jura, nehe ri jura po rá hudi Ajua̱ ne por guesɛ Ajua̱ ngueꞌa̱ go gueꞌa̱ rá hudiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Núꞌahʉ xahnatehʉ de ra ley ne núꞌahʉ gyá fariseohʉ, ꞌnagyá yohmihʉ, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Nuꞌahʉ́ guí ꞌuecjʉ ꞌrɛtꞌa de ra bɛxo pa Ajua̱ de núꞌa̱ guí ta̱hʉ ꞌbʉ guí pahʉ ra zi xa̱cꞌri, o ra zi ani, o ra zi cominu. Pe hingo guí øthʉ núꞌa̱ maꞌna mahyoni ngu ma̱nga ra ley, hinguí udihʉ ra hogaꞌmʉi, nixi otho ri nthecatehʉ, ne hinguí øthʉ núꞌa̱ guí ma̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nuꞌahʉ́ guí ne gui ꞌñuhma̱hʉ ra ꞌñu, pe nixi guí pa̱hʉ habʉ grí maha nehe. Nuꞌahʉ́ guí njahʉ ngu ꞌnara ja̱ꞌi núꞌa̱ faxa ra tꞌafi pa hinda tho ya tꞌʉca zuꞌue, pe sta zi, tutꞌatho ya da̱nga zuꞌue, y nixi bi za te ꞌbɛ bi dutꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Núꞌahʉ xahnatehʉ de ra ley ne núꞌahʉ gyá fariseohʉ, ꞌnagyá yohmihʉ, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Guí njahʉ ngu ra xʉtꞌa vaso ne ra xʉtꞌa manza, xʉqui hønsɛ de thi ha nu de mbo xi rá ntsꞌo. Njabʉ mbo ri mfenihʉ nehe hinxá ntꞌaxi ngueꞌa̱ gyá ndustehʉ ne gyá tsꞌoꞌyohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ꞌNagyá godahʉ. Hyɛhʉbʉ ꞌmɛtꞌo ya tsꞌomfeni pa njabʉ strá ntꞌaxiꞌihʉ ne pa da za gui ꞌyøthʉ núꞌa̱ xá hño. ");
INSERT INTO oteNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Núꞌahʉ xahnatehʉ de ra ley ne núꞌahʉ gyá fariseohʉ, ꞌnagyá yohmihʉ, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Guí njahʉ ngu ya pantyo xi xá ntꞌaxi de thi ne ri hnequi mahotho, pe mbo xi rá da̱ma ntsꞌo. ");
INSERT INTO oteNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hangue nuꞌahʉ́ guí njahʉbʉ nehe ngueꞌa̱ guí ꞌñetꞌa hoja̱ꞌihʉ pe guí beñhʉ ya tsꞌomfeni ne gyá yohmihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Núꞌahʉ xahnatehʉ de ra ley ne núꞌahʉ gyá fariseohʉ, ꞌnagyá yohmihʉ, huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Guí jamasubihʉ yá pantyo núꞌʉ yá ꞌmɛhni Ajua̱ xa du, ne guí ca̱thʉ mahotho nuyá pantyo nu maꞌra ya hoja̱ꞌi xa du. ");
INSERT INTO oteNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne guí eñhʉ: “Nuꞌbʉ ya gra ꞌbʉhma̱he nuya paꞌʉ, nuꞌbʉ́ hinstá faxhe ndu ma xitahe pa xa hyopa núꞌʉ yá ꞌmɛhni Ajua̱.” ");
INSERT INTO oteNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hangue nuꞌahʉ́ guí ma̱nsɛhʉ gue go gueꞌaꞌihʉ gyá tꞌʉhʉ de núꞌʉ toꞌo bi hyopa yá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hangue núꞌa̱ hingo bi juata ndu ri xitahʉ, ma go gui juadi gui ꞌyøthʉbya. ");
INSERT INTO oteNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Nuꞌahʉ́ guí njahʉ ngu ya quꞌeña̱, hingui ma gui cꞌothʉ de ya da̱nga ʉgui núꞌʉ ma gui thohʉ ja ra nidu! ");
INSERT INTO oteNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ma ga pɛhnꞌahʉ maꞌra ya ꞌmɛhni ne maꞌra ya ba̱mhya̱ ne maꞌra ya xahnate. ꞌRa de gueꞌʉ ma gui hyohʉ, nu maꞌra ma gui tsʉthʉ ja ra pontꞌi, ha nu maꞌra ma gui naꞌmbabihʉ ja ri nija̱hʉ, ne hinhyabʉ ma gui hophʉ da ꞌmʉiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Y njabʉ ma go gui juthʉ nehe de núꞌʉ ya hoja̱ꞌi xa tho, bi mʉdi co ra Abé asta ra Sacaría núꞌa̱ mrá tꞌʉ ra Berequía. Nura Sacaría go gueꞌa̱ gá hyohʉ mbo ri nija̱hʉ guetbʉ ja ra ata. ");
INSERT INTO oteNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Xi majua̱ni dí xiꞌahʉ gue nuꞌahʉ́ ma go gui tuxhʉ gatho nuya thaiya. ");
INSERT INTO oteNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nuꞌahʉ me Jerusale, guí tɛdohʉ ne guí hophʉ yá ꞌmɛhni Ajua̱ núꞌʉ bí pɛhnꞌahʉ. ¡Hangu ya iꞌqui dá ne ga muntsꞌahma̱ꞌihʉ ngu ꞌnara zi øni huixa yá zi tꞌʉꞌni, pe nuꞌahʉ́ hingá nehʉ! ");
INSERT INTO oteNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nuꞌbʉ́ nuri nguhʉ ma da gosɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngueꞌa̱ dí xiꞌahʉ gue ya hingui ma gui yopa hyandgaguihʉ asta hinga yopa pengui. Nuꞌbʉ́ ha̱, nuꞌahʉ́ ma gui ꞌñeñhʉ: “Xá nsunda núꞌa̱ toꞌo bá pɛhna Ajua̱ pa da nda̱ ja guecjʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nepʉ ra Jesu bi bøni de ra nda̱nija̱, ne ya mi ꞌbaꞌñuꞌa̱ yá nxadi bi e bi zʉdi pa bi ꞌñutuabi gatho nuya ngu de ra nda̱nija̱. ");
INSERT INTO oteNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ, gatho nuya nguyʉ ma da nhuati ne hinda ma da gohi ni ꞌnara do maña̱ co maꞌna rá midoui. ");
INSERT INTO oteNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","De guehni bi ma ra Jesu co yá nxadi pa ja ra tꞌøhø ꞌbo Olivo, ne ja bá huhni ra Jesu. Nepʉ bi joni yá nxadi pa bi ꞌyamba sɛhɛꞌa̱ ne bi ꞌñembi: ―Dí ne xi gui xicje haꞌmʉ ma da nja núꞌa̱ gá ma̱, ne te ma ntꞌudi ma ga hanthe pa ga pa̱he gue ya ma gui yopa penguiua maꞌnaꞌqui, ne pa ga pa̱he haꞌmʉ rá uadi ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nuꞌbʉ́ ra Jesu bi da̱tuabi ne bi ꞌñembi: ―Jamasuhʉ oto sti ma da hyaꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngueꞌa̱ ma da ꞌñehe ndunthi núꞌʉ toꞌo di ña̱ de ma thuhu ne di eñꞌʉ: “Nugui go drá Cristo bá pɛncagui Ajua̱ pa ga nda̱.” Y njabʉ ma da hyatꞌa ndunthi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nehe ma gui ꞌyødehʉ da hma̱ de ya tuhni núꞌʉ ya ja, ne núꞌʉ hingui jatho. Pe nuꞌahʉ́ osti ma da du ri mʉihʉ, ngueꞌa̱ pɛꞌtsi te da njabʉ. Pe hingo gueꞌa̱ rá uadi ra ximhai ngueꞌa̱ ri ꞌbɛtho maꞌra te da nja. ");
INSERT INTO oteNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngueꞌa̱ ma da ntuhna ya hnini co maꞌra ya hnini. Ma da nja ra da̱nga thuhu ne ya da̱nga hñeni, ne ma da nja ya mbimhai habʉraza. ");
INSERT INTO oteNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Y gatho nuya dumʉiya, guehya ya mʉdi ʉgui. ");
INSERT INTO oteNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Núꞌʉ hingyá gamfri ma da gʉꞌahʉ da napꞌahʉ o da hyoꞌahʉ, ne toraza da ʉtsaꞌihʉ ngueꞌa̱ xcá camfriguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ha nuya paꞌʉ ndunthi ma da ꞌbɛdi yá jamfri, ne ma da ꞌñʉtsa ꞌna ngu maꞌna, ne ndunthi ma da da yá miquꞌeiui. ");
INSERT INTO oteNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y ma da ꞌmʉ ndunthi ya hyate ba̱di, da ꞌñena gue go xuá mɛhna Ajua̱, ne ma da hyatꞌa ndunthi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndunthi ya ja̱ꞌi ma da ꞌbɛdi ra hma̱te ngueꞌa̱ maꞌna xi ma da nda̱ngui ra tsꞌoqui gatho ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pe nuꞌa̱ tóꞌo hinda ꞌuegue de Ajua̱, núꞌá̱ go gueꞌa̱ ma da mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma da ntꞌøde ra noya gue ra Nda̱ de mahetsꞌi ma da ꞌñehe pa da nda̱. Nuná ma da ntꞌøde ja gatho rá ngʉni ra ximhai pa njabʉ da ꞌyøde gatho ya ja̱ꞌi de gatho ya hnini. Nepʉ de gueꞌa̱ ja dí uadi ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ra Dañe núꞌa̱ mrá ꞌmɛhni Ajua̱ bi ꞌyofo de núꞌa̱ ra tsꞌotꞌøtꞌe ma da nja mbo ja ra nda̱nija̱ de Jerusale pa da ntsꞌonga ra nda̱nija̱. ―Nuꞌa̱ tóꞌo da hñeꞌta nuna tꞌofona̱ mahyoni da ba̱di xá hño te ma̱.― Ha nu xcrí hyanthʉ da tꞌøtꞌa njabʉ mbo ra nda̱nija̱, nuꞌbʉ́ njabʉ gui pa̱hʉ gue ya bi zø ra ora. ");
INSERT INTO oteNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nuꞌbʉ́ nuꞌahʉ me Judeahʉ, ma gui ꞌbathʉ grí maha ja ya tꞌøhø. ");
INSERT INTO oteNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Y ꞌbʉ gri ꞌyohʉ ja rá patio ri nguhʉ, oxqui ma gui cʉthʉ ꞌmɛtꞌo pa te gui hña̱xhʉ, ngueꞌa̱ mahyoni gui da̱ma maha. ");
INSERT INTO oteNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ꞌBʉ gri ꞌyohʉ ra ꞌbɛfi ja ya hua̱hi, oxqui penjʉ ja ri nguhʉ pa gui hña̱xa ri hehʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Huecazite núꞌʉ ya ꞌbɛhña̱ di daꞌthi ne dya nzʉ nuya paꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ꞌYaphʉ Ajua̱ gue núꞌa̱ ra pa xcrí ꞌbathʉ, hindi ta ya tsɛ nixi dra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngueꞌa̱ nuya paꞌʉ ma da nja ndunthi ya tsꞌothogui núꞌʉ hinhyaꞌmʉ xa hnequi desde bi mʉdi ra ximhai, ne nixi hinda ma da yopa nja maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ajua̱ ma da ꞌyøtꞌe pa hinda njabʉ ndunthi ya pa, ngueꞌa̱ nuꞌbʉ da njabʉ ndunthi ya pa, nuꞌbʉ́ da du gatho. Pe po rá ngue ya gamfri, Ajua̱ ma da ꞌyøtꞌe pa da thogui ꞌbestho núꞌʉ ya pa dega tsꞌothogui. ");
INSERT INTO oteNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nuꞌbʉ ꞌna toꞌo da ꞌñeñꞌahʉ gue nuua ja ꞌbʉcua ra Cristo núꞌa̱ bá pɛhna Ajua̱ pa da nda̱, o bí ꞌbʉi ringuehni, oxqui ma gui camfribihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngueꞌa̱ ma da ꞌmʉi ꞌraya ja̱ꞌi da ꞌñena gue go di gueꞌʉ ra Cristo núꞌa̱ bá pɛhna Ajua̱ pa da nda̱, ne ma da ꞌmʉ maꞌra ya hyate ba̱di. Núꞌʉ́ ma da ꞌñudi ndunthi ya da̱nga ntꞌudi ne da ꞌyøtꞌa ya tꞌøtꞌe ꞌñena xi majua̱ni pa da hyatꞌa ya ja̱ꞌi, ne da nehma̱ꞌʉ da hyatꞌa ya gamfri nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ya stá ꞌbɛtꞌoꞌihʉ ra noya de núꞌa̱ ma da nja, hangue ostí ma da thaꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Hangue ꞌbʉ da tꞌeñꞌahʉ gue ra Cristo bí ꞌbʉi ja ra mbonthi, oxqui ma gui mahani. O ꞌbʉ da tꞌeñꞌahʉ: “Ndi bá ehʉ ja ꞌbʉcua mbo ra ngu”, oxqui ma gui camfribihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngueꞌa̱ nurá yoꞌñehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi xcrá tha̱mfrihʉ da da̱ma zøhø ne da hnequi gatho ja ra ximhai nja ngu ꞌnara huɛi ri yotꞌa mbøxhyadi ne asta yʉhyadi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nuya paꞌʉ ma da nja ngu ya pada ri muntsꞌi habʉ ꞌbɛni núꞌa̱ te xa du. ");
INSERT INTO oteNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ngu da thogui nuya paꞌʉ dega tsꞌothogui, ꞌbestho ma da ꞌmɛxuui ra hyadi, ne ra za̱na̱ hinda ma da yotꞌi. Ya tsø ma da dagui de mahetsꞌi, y mahetsꞌi ma da hua̱tꞌi ntsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nepʉ ma da hnequi ꞌnara ntꞌudi nuni mahetsꞌi de rá yoꞌñehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, ne gatho ya ja̱ꞌi de ra ximhai ma da nzoni nu stí hyandi da zøhø, nu sta ꞌñehe ja ꞌnara guui con gatho rá tsꞌɛdi ne co rá nsunda pa da e da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma da ntꞌøde ꞌnara trompeta, nepʉ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da mɛhna yá ɛnxɛ gatho ja rá ngʉni ra ximhai pa da muntsꞌa gatho núꞌʉ xa huahniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ꞌYøhʉ nuna ra ꞌbede de ra igo: Nu xcrí hyanthʉ gue ya ja yá ꞌroho ne ya ja yá xi, nuꞌbʉ́ gui pa̱hʉ gue ya ma da zøhø ya pa dega pahyadi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hangue nu xcrí hyanthʉ da nja gatho ngu núꞌa̱ dí xiꞌahʉ, pa̱hʉ gue Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ya ma dua yopa pengui. ");
INSERT INTO oteNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Xi majua̱ni dí xiꞌahʉ gue gatho nuya ma da mʉdi da nja ante da du nuya ja̱ꞌi ꞌbʉibya ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mahetsꞌi ne ra ximhai ma da uadi da thogui, pe numa noya hinhyaꞌmʉ da uadi, ma da nja pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ni ꞌna hinto pa̱di ra pa nixi ra ora nurá yoꞌñehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, nixi núꞌá̱, nixi ya ɛnxɛ bí ꞌbʉ mahetsꞌi hingui pa̱di, hønsɛ ma Dada ha̱, go pa̱di haꞌmʉ da ꞌñehe. ");
INSERT INTO oteNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ha nu sta yopa ꞌñehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, ma da nja ngu núꞌʉ ya pa de ra Noé. ");
INSERT INTO oteNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nuya paꞌʉ ante da ñuxa ra dehe ja ra ximhai, ya ja̱ꞌi mi ñuni mi tsithe ne mi øtꞌantha̱ti ngu xi yá nza̱i. Mi øtꞌa njabʉ asta núꞌa̱ ra pa bi yʉtꞌa ra Noé ja ra da̱nga motsa núꞌa̱ xqui hyoqui. ");
INSERT INTO oteNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nepʉ mi da̱mfriꞌʉ bi ñuxa ra dehe ja ra ximhai ne bi ja̱tꞌi gatho núꞌʉ ya tsꞌoja̱ꞌi. Ma da njabʉ nehe núꞌa̱ ra pa rá yoꞌñehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nuya paꞌʉ, ꞌbʉ yoho ya ꞌñøhø di ꞌyo ra ꞌbɛfi ꞌnadbʉ ja ra hua̱hi, sta da̱mfri da tsꞌixa ꞌna de gueꞌʉ, ha nu maꞌna da gohni. ");
INSERT INTO oteNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ꞌBʉ yoho ya gʉni di ꞌbʉ ꞌnadbʉ, sta da̱mfri da tsꞌixa ꞌna de gueꞌʉ, ha nu maꞌna da gohni. ");
INSERT INTO oteNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hangue ndøꞌmhʉ, ngueꞌa̱ hinguí pa̱hʉ haꞌmʉ ma da zøhø ri Hmuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ya guí pa̱hʉ, ꞌbʉ ꞌnara me ngu di pa̱hma̱ te ma ora da zøhø ꞌnara be, nuꞌbʉ́ hinda ꞌña̱ha̱ꞌa̱ pa hinda hopa ra be da xocua rá ngu pa da bepabi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hangue neꞌahʉ xi da ndøꞌmhʉ, ngueꞌa̱ xcrí tha̱mfrihʉ da zøhø Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nuꞌa̱ tóꞌo ra hoga ꞌbɛgo ne xi ra hoja̱ꞌi tsa da tꞌɛntꞌua rá ꞌyɛ rá ngu rá hmu, nehe da tꞌɛntꞌua rá ꞌyɛ ya ꞌbɛgo núꞌʉ hoqui te da tsꞌi ora mahyoni. ");
INSERT INTO oteNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nuꞌbʉ́ xi da johya núꞌa̱ ra hoga ꞌbɛgo nu sta zøhø rá hmu da zʉdi di øtꞌa ngu núꞌa̱ rí ꞌñehe. ");
INSERT INTO oteNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Xi majua̱ni dí xiꞌahʉ, nura hmuꞌa̱ ma da hñuxa dega ꞌbɛtri núꞌa̱ ra ꞌbɛgo pa da supa gatho núꞌa̱ te pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pe xiꞌbʉ nura ꞌbɛgoꞌa̱ da bøni dra tsꞌoꞌmʉi y da beni gue rá hmu hinga ꞌbestho da da̱ma mengui, ");
INSERT INTO oteNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nepʉ nuꞌá̱ da mʉdi da naꞌmba yá miꞌbɛgoui, ne da ma da ñuniui ne da ntsiui ya tixfani. ");
INSERT INTO oteNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ha sta da̱mfri da zøhø rá hmu núꞌa̱ ra ora hindi tøꞌmi. ");
INSERT INTO oteNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nuꞌbʉ́ nura hmuꞌa̱ ma xi da ncuɛ co nurá ꞌbɛgoꞌa̱, hangue da umba ꞌnara da̱nga castigo, ne da mɛhna habʉ ꞌbʉ ya yohmi pa ja dí nzonini ne ja dí gustri yá tsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nurá yoꞌñehe ra Nda̱ de mahetsꞌi ma ga hyɛcuahʉ ngu ra ꞌbede de ꞌnara ntha̱ti bi nja. ꞌRɛtꞌa ya nxutsi bi hña̱xa yá ñotꞌi dega aceite pa bi ma bá tha̱di núꞌa̱ ra ꞌñøhø mi ma da ntha̱ti. ");
INSERT INTO oteNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ha de núꞌʉ ꞌrɛtꞌa ya nxutsi, cʉtꞌa xqui hñoqui co yá ñotꞌi, pe núꞌʉ má cʉtꞌa hinxqui hñoqui. ");
INSERT INTO oteNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ha núꞌʉ cʉtꞌa hinxqui hñoqui, himbi hña̱xa ndunthi ra aceite pa da xitꞌa ja yá ñotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pe nuꞌʉ má cʉtꞌa xqui hñoqui ha̱, bi ñuꞌtsa yá ñotꞌi co ra aceite, nehe bi hña̱xa ꞌnara xito mi ñutsꞌi pa sta thegue núꞌa̱ mi po ja ra ñotꞌi da xitꞌa maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hinga ꞌme bi zøhø núꞌa̱ mi ma da ntha̱ti, hangue gatho núꞌʉ ꞌrɛtꞌa ya nxutsi bi zʉ ra tꞌa̱ha̱ ne bi ꞌña̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Y ngu made ra xuui bi ntꞌøde ꞌnara hmafi ne bi tꞌemba ya nxutsi: “¡Ya xa ꞌñecua núni ma da ntha̱ti, bá ehʉ gui tha̱dihʉ!” ");
INSERT INTO oteNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nuꞌbʉ́ ꞌbestho bi nuhu gatho núꞌʉ ꞌrɛtꞌa ya nxutsi ne bi mʉdi bi tsøgue yá ñotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ha núꞌʉ cʉtꞌa hinxqui hñoqui, ꞌbestho bi ꞌñembabi núꞌʉ má cʉtꞌa xqui hñoqui: “Xɛcje tsꞌʉ ri zi aceitehʉ ngueꞌa̱ ya huetꞌatho ma ñotꞌihe.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ne núꞌʉ ya nxutsi xqui hñoqui bi da̱tuabi núꞌʉ má cʉtꞌa ne bi ꞌñembi: “Hina, hinga xɛꞌahe, xiꞌbʉ ga njahebʉ nguꞌahʉ. Maꞌna xá hño grí maha gui tañhʉ habʉ bí ꞌba. Bá tañhʉ pa gueꞌahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pe de bi maꞌʉ da danga ra aceite, nura oraꞌa̱ bi zøhø núꞌa̱ mi ma da ntha̱ti. Nuꞌbʉ́ núꞌʉ cʉtꞌa ya nxutsi xqui hñoqui bi mɛui ne bi yʉtꞌuiꞌʉ mbo habʉ mi ma da nja ra ngo dega ntha̱ti. Nepʉ ꞌbestho bi jotꞌa ra gosthi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ha ꞌmɛfa bi zøhø núꞌʉ maꞌra ya nxutsi ne bi ꞌñeñꞌʉ: “¡Xogaguihe ra gosthi, zi Hmu, xogaguihe!” ");
INSERT INTO oteNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pe núꞌa̱ toꞌo mi ma da ntha̱ti bi da̱tuabiꞌʉ ne bi ꞌñembi: “Xi majua̱ni dí xiꞌahʉ gue hindí pa̱ꞌahʉ toꞌoꞌihʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nuꞌbʉ́ ra Jesu bi ꞌñena: ―Hangue nuꞌahʉ hñocjʉ ne xi da ndøꞌmhʉ, ngueꞌa̱ hinguí pa̱hʉ te ma pa ni te ma ora ma da zøhø Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nehe rá yoꞌñehe ra Nda̱ de mahetsꞌi ma ga hyɛcuahʉ ngu rá ꞌbede ꞌnara hmu co yá ꞌbɛgo. Núꞌa̱ ra hmu ya mi ꞌbaꞌñu da ma ja maꞌna ra hai yabʉ, ne bi zohna ꞌrayá nza̱i ꞌbɛgo pa bi zocuabi rá boja̱ pa da xu de da pengui. ");
INSERT INTO oteNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ꞌNa de gueꞌʉ bi zocuabi cʉtꞌa ꞌmo, maꞌna bi zocuabi yo ꞌmo, ha nuꞌa̱ maꞌna bi zocuabi ꞌna ꞌmo. Ngu rá nda̱ngui rá mfa̱di cada ꞌna, gueꞌa̱ rá ndunthi ra boja̱ bi tsꞌocuabi. nepʉ ra hmu bi gʉ rá ꞌñu bi ma. ");
INSERT INTO oteNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Núꞌa̱ ra ꞌbɛgo xqui tsꞌocuabi cʉtꞌa ꞌmo, nuꞌá̱ bi ma bi pʉntsꞌa nura boja̱ꞌa̱ ne bi da̱ha̱ má cʉtꞌa ꞌmo. ");
INSERT INTO oteNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ha nuꞌa̱ tóꞌo xqui tsꞌocua yo ꞌmo mbɛxo, bi pʉntsꞌa núꞌa̱ ra boja̱ꞌa̱, ne bi da̱ha̱ má yo ꞌmo. ");
INSERT INTO oteNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pe nuꞌa̱ tóꞌo xqui tsꞌocua ꞌna ꞌmo mbɛxo, nuꞌá̱ bi ma bá xei ꞌnara oꞌtsi ne bi ꞌyagui núꞌa̱ ra boja̱ xqui zocuabi rá hmu. ");
INSERT INTO oteNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bi thogui ndunthi ya pa, nepʉ bi zøhø ra hmu bi ꞌñʉtꞌuɛndaui yá ꞌbɛgo. ");
INSERT INTO oteNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bi zøhø ꞌmɛtꞌo núꞌa̱ xqui tsꞌocua cʉtꞌa ꞌmo, ne bi umba rá hmu núꞌa̱ má cʉtꞌa ꞌmo xqui da̱ha̱ de núꞌa̱ xqui tsꞌocuabi, ne bi ꞌñembabi: “Gá tsogagui cʉtꞌa ꞌmo, pe nubyá jaua nuna má cʉtꞌa ꞌmo stá ta̱ha̱ de núꞌa̱ gá tsogagui.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nuꞌbʉ́ ra hmu bi da̱di ne bi ꞌñena: “Xi xá hño ri ꞌbɛfi. Nuꞌi xi ꞌnagrá hoga ꞌbɛgo. Nubyá ma ga tsocꞌaꞌi maꞌna ndunthi ra boja̱ pa gui japi da xu, ngueꞌa̱ xi xcá pa̱di xcá japi da xu núꞌa̱ ꞌna tʉi dá tsocꞌaꞌi. Nubyá bá ehe pa ga johyahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ꞌMɛfa bi zøhø núꞌa̱ toꞌo xqui tsꞌocua yo ꞌmo, ne bi ꞌñemba rá hmu: “Gá tsogagui yo ꞌmo, pe nubyá jaua nuna má yo ꞌmo stá ta̱ha̱ de núꞌa̱ yo ꞌmo gá tsogagui.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nuꞌbʉ́ ra hmu bi da̱di ne bi ꞌñembabi: “Xi xá hño ri ꞌbɛfi. Nuꞌi xi ꞌnagrá hoga ꞌbɛgo. Nubyá ma ga tsocꞌaꞌi maꞌna ndunthi ra boja̱ pa gui japi da xu, ngueꞌa̱ xi xcá pa̱di xcá japi da xu núꞌa̱ ꞌna tʉi dá tsocꞌaꞌi. Nubyá bá ehe pa ga johyahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pe nu mi zøhø núꞌa̱ ra ꞌbɛgo xqui tsꞌocua ꞌna ꞌmo, nuꞌá̱ bi ꞌñembabi rá hmu: “Nuga dí pa̱di gue xi grí japa ri ꞌbɛgo da mpɛfi ntsꞌɛdi ne guí xofo habʉ hingo xcá potꞌi, ne guí muntsꞌa ra trigo habʉ hingo xcá piqui. ");
INSERT INTO oteNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hangue nuga dá tsuꞌi, xiꞌbʉ ga tuxa ra thai, hangue dá ma dá agui ri boja̱ ja ra hai. Pe nubyá jaua núna gá tsogagui.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bi da̱di ra hmu ne bi ꞌñembabi: “Nuꞌi ꞌnagrá tsꞌoꞌmʉi ne ꞌnagrá da̱hñe ꞌbɛgo, ꞌbʉ guí beni gue dí xofo habʉ hingo stá potꞌi ne dí muntsꞌi habʉ hingo stá piqui, ");
INSERT INTO oteNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nuꞌbʉ́ ¿ha gue himi tsa xcá nu te xcá ꞌyøtꞌe pa xa xu ma boja̱ dá tsocꞌaꞌi pa xa tꞌacagui rá tha̱ha̱ ma boja̱ núbya dá tsøhø?” ");
INSERT INTO oteNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nepʉ ra hmu bi ꞌñembabi núꞌʉ toꞌo mi ꞌñoui: “Hña̱mbabihʉ núꞌa̱ ra boja̱ dá tsocuabi nuni ra da̱hñe ꞌbɛgo, ne umfʉ núꞌa̱ toꞌo pɛꞌtsa ꞌrɛtꞌa ꞌmo. ");
INSERT INTO oteNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngueꞌa̱ nuꞌa̱ tóꞌo pɛꞌtsi, maꞌna ma da tꞌumbabi pa asta da bonguabi. Pe nuꞌa̱ tóꞌo tsꞌʉtho pɛꞌtsi, nuꞌá̱ da tha̱mbabi núꞌa̱ tsꞌʉ pɛꞌtsi pa ya hinte da mɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hangue núꞌa̱ ra ꞌbɛgo hinte rá ꞌbɛfi, maꞌna xá hño jʉhʉ ne ꞌyɛnthʉ ja ra ꞌbɛxuui pa ja dí nzonini ne ja dí gustri yá tsꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nu sta ꞌñehe pa da nda̱ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, ma da ꞌñoui gatho yá ɛnxɛ, ne ma da hñudi ja rá ma̱ca hudi con gatho rá nsunda. ");
INSERT INTO oteNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nuni ja ma da muntsꞌini gatho ya ja̱ꞌi de gatho rá ngʉni ra ximhai, y nura Nda̱ ma da ꞌueca ꞌna ngu ꞌna, ngu øtꞌa ya maꞌyo co ya zi dɛti ne ya tꞌa̱xi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nuꞌá̱ ma da ꞌbaꞌma ja rá ꞌñɛi gatho ya zi dɛti, ne nu ja rá nga̱ha̱ ja ma da ꞌbamꞌni gatho ya tꞌa̱xi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nuꞌbʉ́ ma da ꞌñembabi núꞌʉ di ꞌbai ja rá ꞌñɛi: “Bá ehʉ nuꞌahʉ xa ja̱pꞌahʉ ma Dada. Ma gui cʉthʉbya nuni mahetsꞌi habʉ bí manda ma Dada nuni habʉ xqui thoqui pa gueꞌahʉ de ante da thoca ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Dí ꞌñepi gui cʉthʉni ngueꞌa̱ núꞌbʉ mi tsʉca ra thuhu, go gueꞌahʉ gá ꞌracjʉ te dá tsi. Ne núꞌbʉ mi tsʉca ra nduthe, go gueꞌahʉ gá ꞌracjʉ ra dehe dá tsi. Ne núꞌbʉ ndí neꞌñu, go gueꞌahʉ gá ꞌracjʉ ntsaya dá oxi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne núꞌbʉ mi otho te ga he, go gueꞌahʉ gá ꞌracjʉ te dá he. Ne núꞌbʉ ndrí hñeni ne dá ofadi, go gueꞌahʉ gá ma gá cꞌa̱scahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nuꞌbʉ́ núꞌʉ toꞌo xa ꞌyøtꞌe xá hño ma da da̱di ne da ꞌñena: “Ma zi Hmuꞌihe, ¿haꞌmʉ dá hantꞌahe gue mi tsʉꞌa ra thuhu nepʉ dá ꞌraꞌahe te gá tsi? O ¿haꞌmʉ dá hantꞌahe gue mi tsʉꞌa ra nduthe nepʉ dá ꞌraꞌahe ra dehe? ");
INSERT INTO oteNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O ¿haꞌmʉ dá hantꞌahe gue ngrí neꞌñu nepʉ dá ꞌraꞌahe ntsaya gá oxi? O ¿haꞌmʉ dá hantꞌahe gue mi otho te gui hye, nepʉ dá ꞌraꞌahe te gui hye? ");
INSERT INTO oteNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O ¿haꞌmʉ dá hantꞌahe ngrí hñeni o nguí ofadi nepʉ dá ma dá cꞌa̱ꞌtsꞌahe?” ");
INSERT INTO oteNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nuꞌbʉ́ ra Nda̱ da da̱tuabi ne da ꞌñena: “Xi majua̱ni dí xiꞌahʉ gue nuꞌbʉ gá faxhʉ ꞌna de guehyʉ ma cu hinte mri muui ja yá thandi ya ja̱ꞌi, pa̱hʉ gue go guecagui gá faxcahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nepʉ ra Nda̱ da ꞌñembabi núꞌʉ di ꞌbai ja rá nga̱ha̱: “Nuꞌahʉ ꞌuehʉ de gueque. Nuꞌahʉ xa zʉꞌahʉ rá cuɛ Ajua̱, grí maha pa ja ra nidu habʉ zø ra tsibi pa nza̱ntho, nuni habʉ xa thoqui pa ra tsꞌonda̱hi ne yá tsꞌoꞌɛnxɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngueꞌa̱ mi tsʉca ra thuhu pe nuꞌahʉ́ hingá ꞌracjʉ te dá tsi. Ne mi tsʉca ra nduthe pe nuꞌahʉ́ hingá ꞌracjʉ ra dehe dá tsi. ");
INSERT INTO oteNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne núꞌbʉ ndí neꞌñu, nuꞌahʉ́ hingá ꞌracjʉ ntsaya dá oxi. Ne mi otho te ga he pe nuꞌahʉ́ hingá ꞌracjʉ te dá he. Ne núꞌbʉ ndí hñeni ne ndí ofadi, nuꞌahʉ́ hingá ma gá cꞌa̱scahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nuꞌbʉ́ núꞌʉ ya tsꞌoja̱ꞌi ma da da̱di ne ma da ꞌñena: “Ma zi Hmuꞌi, ¿haꞌmʉ dá hantꞌahe mi tsʉꞌa ra thuhu o ra nduthe, o ngrá neꞌñu, o bi ꞌñotho te gui hye o gá hñeni o gá ofadi, nepʉ hindá faxꞌahe?” ");
INSERT INTO oteNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nepʉ ra Nda̱ da da̱tuabi ne da ꞌñembi: “Xi majua̱ni dí xiꞌahʉ, nuꞌbʉ hingá faxhʉ ꞌna de nuyʉ ma zi cu hinte mri muui pa ja ri thandihʉ, pa̱hʉ gue go guecagui hingo gá faxcahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nuꞌbʉ́ nuya tsꞌoja̱ꞌi ma da ma pa ja ra nidu habʉ da ꞌmʉi pa nza̱ntho. Ha nuꞌʉ tóꞌo xa ꞌyøtꞌe xá hño ma da yʉtꞌa mahetsꞌi habʉ bí ja ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nu mi uadi ra Jesu bi ma̱nga gatho nuya noyaya, bi ꞌñembabi yá nxadi: ");
INSERT INTO oteNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ngu guí pa̱hʉ gue hønsɛ yo pa ri ꞌbɛdi pa da tꞌøtꞌa ra ngo dega pascua, ne nuya paꞌʉ gueꞌbʉ ma dra da Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi pa dra pontꞌi ne da tho. ");
INSERT INTO oteNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ne nura paꞌa̱ bi ma̱nga njabʉ ra Jesu, nuyá nda̱xjua nda̱ ya xodyo ne ya nda̱ gá macja̱ ne ya xahnate de ra ley, bi muntsꞌiꞌʉ ja rá ngu ra Caifá núꞌa̱ toꞌo xi mrá da̱nga nda̱ gá macja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nuni ja guehni bi ꞌñʉꞌtiꞌʉ pa hanja da za da hyatꞌa ra Jesu pa da za da gʉ ne da hyo. ");
INSERT INTO oteNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ne bi bensɛꞌʉ bi ꞌñémbiꞌʉ: ―Nubyá hinga ma ga øthʉ núna dí beñhʉ ga øthʉ ngueꞌa̱ ra ngo, pa hinda ñʉntsꞌa ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ha nura Jesu mi ꞌbʉhni ja ra tꞌʉca hnini Betania ja rá ngu ra Simu núꞌa̱ toꞌo xqui ña̱ni de ra lepra núꞌa̱ ra hñeni tsitꞌatho ra ngø. ");
INSERT INTO oteNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ha ra Jesu mi hudi ja ra mexa, ne de gueꞌa̱ bi zønga ꞌnara ꞌbɛhña̱ mi ha̱ ꞌna ngu ra zi xito xqui thoqui de ꞌnara hoga do rá thuhu ra alabastro, mi po ꞌnara dehe xi mi yʉni xá cʉhi ne xi mri muui ndunthi, ne bi goꞌtsua ja rá ña̱xu ra Jesu núꞌa̱ ra deheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ha nu mi hyanda ya nxadi núꞌa̱ mi øtꞌa núꞌa̱ ra ꞌbɛhña̱ꞌa̱, bi bø yá cuɛ ne bi ꞌñena: ―¿Hanja bri fantho nuna dehe xi rá ma̱di? ");
INSERT INTO oteNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nuna deheni xa za xa ꞌba hma̱ha̱, ngueꞌa̱ ri muui ndunthi ra boja̱, ne xa tꞌumba hma̱ha̱ ꞌnara mfatsꞌi ya hyoya. ");
INSERT INTO oteNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nuꞌbʉ́ ra Jesu bi ꞌyøde núꞌa̱ mi ma̱ñꞌʉ ne bi ꞌñembabi: ―¿Hanja guí ma̱ñhʉ njabʉ de núꞌa̱ bi ꞌyøtꞌa nuni ra zi ꞌbɛhña̱? Nuní xa ꞌyøtꞌa ꞌnara hño pa guequi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Oguí hyøcjʉ núꞌa̱ xa goxcagui, ngueꞌa̱ nuya hyoya ma gui ꞌbʉhʉ nza̱ntho con gueꞌʉ, pe nugui hingá nza̱ntho ma ga ꞌbʉi con gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nuní bi goxcagui núꞌa̱ ra dehe yʉni xá cʉhi pa nu xcrá ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Xi majua̱ni dí xiꞌahʉ gue habʉraza de ra ximhai da hma̱nga ma noya, nehe da hma̱ de núꞌa̱ xa ꞌyøtcagui nuni ra zi ꞌbɛhña̱ pa ꞌnara feni de guehni. ");
INSERT INTO oteNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nepʉ ꞌna de gue núꞌʉ ꞌrɛtꞌamayoho ya nxadi mrá thuhu ra Juda Iscariote bi ma bá cꞌa̱ꞌtsa ya nda̱ gá macja̱, ");
INSERT INTO oteNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","y nuꞌá̱ bi ꞌñembabiꞌʉ: ―¿Hangu guí ꞌracjʉ pa ga daꞌaꞌihʉ ja ri ꞌyɛhʉ ra Jesu? Nuꞌbʉ́ ꞌbestho ra oraꞌa̱ bi gohuiꞌʉ ꞌnara cohi, ne ya nda̱ gá macja̱ bi umbabi ra Juda Iscariote ꞌnatemaꞌrɛtꞌa ya tꞌaxboja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y desde ra paꞌa̱ ra Juda mi honi hanja da za da da ra Jesu ja yá ꞌyɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nepʉ bi datꞌa ya pa de ꞌnayá ngo ya xodyo, gueꞌa̱ ra ngo de ya thuhme nsi ra nzoi. Y núꞌa̱ ra mʉdi pa de ra ngo, yá nxadi ra Jesu bi ma bá tsʉdi pa bi ꞌyambabi ne bi ꞌñembi: ―¿Habʉ guí ne ga hocje ra hñuni dega pascua? ");
INSERT INTO oteNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ha ra Jesu bi da̱tuabi ne bi ꞌñembabi: ―Rí maha ja ra hnini bá cꞌa̱ꞌtshʉ ꞌnara ꞌñøhø ne gui ꞌñembabihʉ: “Bá pɛncahe ra Xahnate gue ga xiꞌahe njaua ngu núꞌa̱ bá ma̱: Ya ma da datꞌa ma ora, ne pɛꞌtsi te ga øthe ra hñuni dega pascua co ma nxadi ja ri ngu.” ");
INSERT INTO oteNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nuꞌbʉ́ ya nxadi bi ꞌyøtꞌe ngu núꞌa̱ xqui ꞌbɛpabi ra Jesu, hangue nuꞌʉ́ ja bá hocni ra hñuni dega pascua. ");
INSERT INTO oteNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nu mi nxuui ra Jesu bi hñudi ja ra mexa con gatho núꞌʉ ꞌrɛtꞌamayoho yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ha de mri ñuñꞌʉ, ra Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ gue ꞌna de gueꞌahʉ ma gui dagaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nuꞌbʉ́ gatho yá nxadi bi du yá mʉi, ne nuꞌʉ́ ꞌna ngu ꞌna bi ꞌyambabi ra Jesu ne bi ꞌñembi: ―Ma zi Hmuꞌi, ¿ha gue go guecagui? ");
INSERT INTO oteNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y ra Jesu bi da̱tuabiꞌʉ ne bi ꞌñembabi: ―Núꞌa̱ toꞌo drí ñuꞌmebya ja ꞌnadra manza, núꞌá̱ go gueꞌa̱ ma da dagagui. ");
INSERT INTO oteNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ya ꞌyo ra ꞌñu pa da tꞌøtꞌe ngu núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo, pe huecate núꞌa̱ ra ja̱ꞌi toꞌo ma da daꞌa̱. Maꞌna xá hño hinxa ꞌmʉhma̱ núꞌa̱ ra ja̱ꞌiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nepʉ ra Juda núꞌa̱ toꞌo mi ma da da ra Jesu bi ꞌyambabi ne bi ꞌñembi: ―Xahnate, ¿ha gue go guecagui? Ra Jesu bi da̱tuabi ne bi ꞌñembi: ―Ha̱ha̱, go nuꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nura ora mri ñuniꞌʉ, ra Jesu bi gʉ ra thuhme, bi ꞌyapa Ajua̱ rá Dada da ja̱pi, ne bi heque, nepʉ bi umbabi yá nxadi, ne bi ꞌñembabi: ―Tsihʉ nuna thuhme, nuna go guehna ma ndoꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nepʉ bi gʉ ra vaso núꞌa̱ mi po ra vinu, ne bi umba njama̱di Ajua̱ rá Dada, nepʉ bi umba yá nxadi ne bi ꞌñembi: ―Tsihʉ nuna vinu grí gathohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nuna go guehna ma ji ma da mfani pa da putꞌa yá tsꞌoqui gatho ya ja̱ꞌi. Nehe go guehna ra seña de ra ꞌraꞌyo cohi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pe dí xiꞌahʉ gue ya hinga ma ga yopa tsi maꞌnaꞌqui nuna ra vinu dega obxi con gueꞌahʉ nuua ja ra ximhai. Ma ga yopa tsi maꞌna ra ꞌraꞌyo vinu con gueꞌahʉ, pe nuni mahetsꞌi habʉ bí manda ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ha nu mi uadi bi duta ꞌnara ja̱hña̱, bi maꞌʉ pa ja ra tꞌøhø ꞌbo Olivo. ");
INSERT INTO oteNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Nura nxuuibya gathoꞌihʉ ma da du ri mʉihʉ ne ma gui tsogasɛhʉua. Ngueꞌa̱ Ajua̱ ma Dada ma̱nga njaua ja ra Ma̱ca Tꞌofo: “Ma ga ho ra maꞌyo, y nuyá dɛti ri suꞌa̱ ma da nxani habʉraza,” njabʉ ena. ");
INSERT INTO oteNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Hangue nugui ma da thogagui, pe nu xcrá yopa nte, ma ga ꞌbɛtꞌo de gueꞌahʉ pa Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nuꞌbʉ́ ra Pedro bi da̱tuabi ne bi ꞌñembi: ―Masque gatho maꞌra da ꞌuegue de gueꞌaꞌi, pe nugui hinhyaꞌmʉ ga ꞌuegue de gueꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ra Jesu bi ꞌñembabi ra Pedro: ―Xi majua̱ni dí xiꞌaꞌi gue núbya dí nxuui ma gui cøngagui hñuꞌqui ante da mafi ra meꞌnja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nuꞌbʉ́ ra Pedro bi da̱di ne bi ꞌñena: ―Masque ga tuui mahyɛgui pe hinhyaꞌmʉ ga cøñꞌaꞌi. Y gatho maꞌra ya nxadi bi ma̱ njabʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nepʉ ra Jesu bi zøhøni co yá nxadi ja núꞌa̱ ra luga rá thuhu Getsemani, ne bi ꞌñembabiꞌʉ: ―Cohʉua, nugui ma ga thogui má tsꞌʉ ringuehni pa ga apabi Ajua̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nuꞌbʉ́ nuꞌá̱ bi zixa hñu yá nxadi, ra Pedro ne núꞌʉ yoho yá tꞌʉ ra Sebedeo, bi thogui má tsꞌʉ ringuehni. De guehni ra Jesu bi mʉdi bi ntsøꞌmi ne xi bi du rá mʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne bi ꞌñembabi núꞌʉ hñu yá nxadi: ―Xi tu ma mʉiga asta dí ne ga tu co ra dumʉi. Cohʉua, oxqui a̱ha̱hʉ, ma ga aphʉ Ajua̱ mahyɛgui. ");
INSERT INTO oteNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Y ra Jesu bi thogui má tsꞌʉ de habʉ bi gohi yá nxadi, nepʉ bi mɛ rá hmi ja ra hai, ne bi ꞌyapa Ajua̱ rá Dada ne bi ꞌñembi: ―Ma Dadaꞌi, nuꞌbʉ da zahma̱, dá thoguitho nuna tsꞌothogui ma ga thogui, pe nuꞌbʉ hina, ꞌyøtꞌe núꞌa̱ go ri pahague, hingo núꞌa̱ go ga nega. ");
INSERT INTO oteNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nuꞌbʉ́ ra Jesu bi mengui pa habʉ xqui gohi núꞌʉ hñu yá nxadi, ne nuꞌʉ́ bi zʉdi mi a̱ha̱, hangue ra Jesu bi ꞌñembabi ra Pedro: ―¿Ha gue hinxa za xcá tsɛthʉ ra tꞌa̱ha̱ ma̱di ꞌna ora mahyɛgui con guequi? ");
INSERT INTO oteNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nuhuhʉ ne ꞌyaphʉ Ajua̱ pa gui tsɛthʉ ya tsꞌothogui. Xi majua̱ni dí xiꞌahʉ gue ri mfenihʉ ja rá tsꞌɛdi, pe nuri ndoꞌyohʉ otho rá tsꞌɛdi pa gui tsɛthʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ra Jesu bi menga maꞌnaꞌqui habʉ xqui ꞌyapa Ajua̱ rá mʉdi, ne bi ꞌñena maꞌnaꞌqui njaua: ―Ma Dadaꞌi, ꞌbʉ hinda za da thoguitho núꞌʉ ya tsꞌothogui ma ga thogui, nuꞌbʉ́ ꞌyøtꞌe núꞌa̱ go ri pahague. ");
INSERT INTO oteNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nepʉ ra Jesu bi yopa mengui maꞌnaꞌqui habʉ xqui zogui núꞌʉ hñu yá nxadi, ne bi zʉdi mi a̱ha̱ ne nixi mi tsa da zøtꞌa yá da ngueꞌa̱ xi mi tsɛdi ra tꞌa̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nuꞌbʉ́ ra Jesu bi zoguiniꞌʉ maꞌnaꞌqui, ne nuꞌá̱ bi yopa menga rá hñuꞌqui pa habʉ mi apabi Ajua̱, ne guetꞌa̱tho ya noya bi ma̱ ngu núꞌʉ xqui ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nepʉ bi yopa menga maꞌnaꞌqui pa habʉ xqui zogui núꞌʉ hñu yá nxadi ne bi ꞌñembabiꞌʉ: ―Nubyá ha̱, dá zʉ ri tꞌa̱ha̱hʉ ne tsayahʉ xá hño. Ya bi zø ra ora gue ya ma dra da ja yá ꞌyɛ ya ꞌyøtꞌatsꞌoqui Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nanjʉ maha, ngueꞌa̱ ya xa ꞌñepʉ núꞌa̱ toꞌo ma da dagagui. ");
INSERT INTO oteNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tsꞌa ra ora mi ma̱nga njabʉ ra Jesu, bi zøhø ra Juda ꞌna de núꞌʉ ꞌrɛtꞌamayoho ya nxadi, mbra ꞌñoui ndunthi ya ja̱ꞌi, ꞌra mbra hña̱ ya huai ha nu maꞌra mbra hña̱ ya za. Nuya ja̱ꞌiꞌʉ bá pɛhna yá nda̱xjua nda̱ ya xodyo ne ya nda̱ gá macja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ra Juda núꞌa̱ toꞌo xqui pa ra Jesu ya xqui umba ꞌnara seña nuya ja̱ꞌi ne xqui ꞌñembabi: ―Núꞌa̱ gui hyanthʉ ga tsʉꞌtsuabi rá hmi, núꞌá̱ go di gueꞌa̱, ne gui da̱ma jʉhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nuꞌbʉ́ ra Juda bi ma bá tsʉdi ra Jesu. Nepʉ bi zɛnjua ne bi ꞌñembi: ―¡Ajua̱ da ja̱pꞌaꞌi, Xahnate! Ne ꞌbestho bi zʉꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nuꞌbʉ́ ra Jesu bi da̱tuabi ne bi ꞌñembi: ―Xiꞌague, ¿te rá ꞌbɛ xqui ꞌñeque? Nuꞌbʉ́ ya ja̱ꞌi ꞌbestho bi gʉ ra Jesu pa bi zixa ntsꞌa̱hni. ");
INSERT INTO oteNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y ngu bri jʉ ra Jesu, ꞌna de gue núꞌʉ mri ꞌñouiꞌa̱ bi cꞌoꞌtsa rá mahuai ne bi hyɛcua ꞌnará gu ꞌnará ꞌbɛgo ra nda̱ gá macja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nuꞌbʉ́ ra Jesu bi ꞌñembabi núꞌa̱ mi ha̱ ra mahuai: ―Pɛꞌtsa ri huai ja rá ntꞌo, ngueꞌa̱ gatho núꞌʉ toꞌo hote co ra huai, co ra huai dí tho nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nugui da zahma̱ ga apa ma Dada dua pɛncagui ya ꞌmotho gá ɛnxɛ, y nuꞌá̱ dua pɛncahma̱ ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pe nuꞌbʉ́, ya hinda za da nja ngu núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo núꞌa̱ ena gue mahyoni ga thogui ngu núꞌa̱ dí thoguibya. ");
INSERT INTO oteNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nuꞌbʉ́ ra Jesu bi ꞌñembabi ya ja̱ꞌi: ―¿Sague drá be pa e gui jʉgaguihʉ co ya huai ne ya za? Hyastho ndí ꞌbʉi ja ra nija̱ pa ndí xahnꞌaꞌihʉ ne hinhyaꞌmʉ gá jʉgaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pe pɛꞌtsi gatho da njabʉ pa da nja ngu núꞌa̱ bi ma̱nga yá ꞌmɛhni Ajua̱ ja ra Ma̱ca Tꞌofo. Nuꞌbʉ́ gatho yá nxadi bi hyɛhni ra Jesu ne bi ꞌbatꞌiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nuꞌbʉ́ núꞌʉ toꞌo xqui gʉ ra Jesu bi zitsꞌi pa habʉ mi ꞌbʉi ra da̱nga nda̱ gá macja̱ núꞌa̱ mrá thuhu ra Caifá, nehe ja xqui muntsꞌini nuya xahnate de ra ley ne ya nda̱xjua nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ha nura Pedro mi ꞌbɛfatho zi yabʉ mri dɛna ra Jesu, bi zøni asta ja rá patio rá ngu ra da̱nga nda̱ gá macja̱. Nuni ja bi gohniꞌa̱ habʉ mi ꞌbʉi ya gʉntsꞌa̱hni pa da hyandiꞌa̱ te da tꞌøꞌtua ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ha nuya nda̱ gá macja̱ ne ya nda̱xjua nda̱ mahyɛgui con gatho maꞌra ya nda̱ gá xodyo mi honi toꞌo da ma̱nbabi ra Jesu masque dega ncꞌuamba, pa da za da tho. ");
INSERT INTO oteNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pe himbi za te bi tsꞌʉtuabi, masque ndunthi ya ja̱ꞌi bi gʉꞌtsua ya ncꞌuamba. ");
INSERT INTO oteNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Pe ꞌmɛfa bi ꞌmʉhni yoho ya cꞌuamba ja̱ꞌi bi ꞌñena: ―Nuna ꞌñøhøni bi ꞌñena gue da za da yøꞌtuabi rá nija̱ Ajua̱ ne rá hñupa da za da yopa ꞌbaꞌma maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nuꞌbʉ́ nura da̱nga nda̱ gá macja̱ bi ꞌmai ne bi ꞌñemba ra Jesu: ―¿Ha gue hinte gui tha̱di? ¿Ha gue majua̱ni núꞌa̱ hma̱ de gueꞌi? ");
INSERT INTO oteNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pe ra Jesu hinte bi da̱di. Nuꞌbʉ́ nura da̱nga nda̱ gá macja̱ bi ꞌñembabi: ―De rá thuhu Ajua̱ núꞌa̱ te, xi da xicje, ¿ha gue go gueꞌi grá Cristo rá Tꞌʉꞌi Ajua̱ bá pɛhnꞌaꞌi pa gui nda̱? ");
INSERT INTO oteNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nuꞌbʉ́ ra Jesu bi da̱tuabi ne bi ꞌñena: ―Ha̱ha̱ go guecagui, ngu núꞌa̱ gá ma̱. Nehe dí xiꞌahʉ gue nuya pa xa ꞌñepʉ ma gui hyanthʉ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da hñudi ja rá ꞌñɛi Ajua̱ núꞌa̱ ja rá tsꞌɛdi. Y nehe ma gui hyanthʉ dua ehe ja ya guui. ");
INSERT INTO oteNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nuꞌbʉ́ nura da̱nga nda̱ gá macja̱ bi dʉnga yá he ngueꞌa̱ bi beni gue ra Jesu xqui ña̱maꞌñʉ de Ajua̱, ne bi ꞌñena: ―Nuna ꞌñøhøni ri ꞌñetꞌa Ajua̱. ¿Te ga ꞌbɛphʉ maꞌra toꞌo da xicjʉ de guehni? Ya gá ꞌyøsɛhʉ núꞌa̱ te bi ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Te guí ma̱ñhʉ? Ha nuꞌʉ maꞌra bi da̱di ne bi ꞌñena: ―Nuní go ꞌnara da̱nga nduthai, hangue rí ꞌñepi da tho. ");
INSERT INTO oteNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nuꞌbʉ́ ꞌra de gueꞌʉ bi zoꞌtsuabi rá hmi ne bi naꞌmbi, ha nu maꞌra bi mɛꞌti, ");
INSERT INTO oteNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ne bi ꞌñembabi: ―Nuꞌi guí ena gue go gueꞌi grá Cristo xuá mɛhnꞌaꞌi Ajua̱ pa gui nda̱. Nuꞌbʉ́, ꞌbʉ grá ba̱di, xicje xa̱, ¿toꞌo núꞌa̱ bi napꞌaꞌi? ");
INSERT INTO oteNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nura oraꞌa̱, ra Pedro mi huhnitho ja ra patio, nepʉ ꞌnara nxutsi mrá ꞌbɛgo bi ma bá tsʉdiꞌa̱ ne bi ꞌñembabi: ―Neꞌi go gueꞌi nguí ꞌñoui ra Jesu núꞌa̱ ra me Galilea, ¿ha ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ha nura Pedro bi ncøni de ja yá thandi gatho ya ja̱ꞌi mi ꞌbʉhni ne bi ꞌñena: ―Nixi dí pa̱di núꞌa̱ guí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nepʉ nuꞌá̱ ya mi pa ja ra gosthi, ne maꞌna ra nxutsi mrá ꞌbɛgo bi hyandiꞌa̱ ne bi ꞌñembabi núꞌʉ maꞌra ya ja̱ꞌi mi ꞌbahni: ―Nuna da̱meni mri ꞌñoui ra Jesu me Nasare nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nepʉ ra Pedro bi yopa ncøni maꞌnaꞌqui, ne bi jura bi ꞌñena: ―Nixi stá pa̱di núꞌa̱ ra ꞌñøhø guí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ꞌMɛfa bi joni ya ja̱ꞌi habʉ mi ꞌbaiꞌa̱ ne bi ꞌñembabi: ―Xi majua̱ni neꞌaꞌi go gueꞌi ꞌna de gueꞌʉ, ngueꞌa̱ mfa̱ta ri noya gri ña̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nuꞌbʉ́ ra Pedro bi mʉdi bi jura ne bi ntsante ne bi ꞌñena: ―Hindí pa̱ núꞌa̱ ra ꞌñøhø guí ma̱ñhʉ. Y ꞌbestho nura oraꞌa̱ bi mafi ra menja̱. ");
INSERT INTO oteNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nuꞌbʉ́ ra Pedro bi zo rá mfeni de núꞌa̱ xqui xipa ra Jesu ne xqui ꞌñembi: “Nuꞌi ma gui cøngagui hñuꞌqui ante da mafi ra menja̱.” Nuꞌbʉ́ ra Pedro bi bøni pa thi ne xi bi nzoni con gatho rá mʉi. ");
INSERT INTO oteNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nurá hyaxꞌa̱ gatho yá nda̱xjua nda̱ ya xodyo ne ya nda̱ gá macja̱ bi gohi ꞌnara cohi pa hanja da za da hyo ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nepʉ bi duꞌtiꞌʉ pa bi zitsꞌi bá ɛntꞌua ja rá ꞌyɛ ra Poncio Pilato núꞌa̱ toꞌo mrá nda̱ de Judea. ");
INSERT INTO oteNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ra Juda núꞌa̱ toꞌo xqui da ra Jesu, nu mi hyandiꞌa̱ gue ma da tho ra Jesu, xi bi du rá mʉi ne bi ma bá coꞌtsua yá boja̱ nuya nda̱ gá macja̱ ne ya nda̱xjua nda̱, núꞌa̱ ꞌnatemaꞌrɛtꞌa ya tꞌaxboja̱ xqui tꞌumbi. ");
INSERT INTO oteNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne bi ꞌñena: ―Nugui stá øtꞌa ꞌnara da̱nga tsꞌoqui, ngueꞌa̱ stá da ꞌnara ꞌñøhø núꞌa̱ hinte tu, ma da tho, da manga rá ji. Nepʉ nuꞌʉ́ bi da̱di ne bi ꞌñembi: ―¿Nuꞌá̱ te go tsa ga pa̱cahe de gueꞌa̱? Nuꞌá̱ go rí ma ri uɛndague. ");
INSERT INTO oteNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nuꞌbʉ́ ra Juda bi føta núꞌa̱ ra boja̱ mbo ra nija̱, nepʉ bi ma bá nzʉdisɛ dega ꞌyʉga pa bi nhyo sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nuꞌbʉ́ nuya nda̱ gá macja̱ bi muntsꞌa núꞌa̱ ra boja̱ꞌa̱ ne bi ꞌñeñꞌʉ: ―Nuna boja̱na̱ hingui tsa ga ʉthʉ ja ra ꞌmɛꞌtsboja̱ de ra nija̱, ngueꞌa̱ guehna ꞌnara njutꞌi de rá ji ꞌnara ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nepʉ bi go ꞌnara cohi gue con gue nura boja̱ꞌa̱ da dañꞌʉ ꞌnara hai rá thuhu ra Hai dega Hyoca Traste, pa ja da tꞌaguini ya nzøhøja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hangue asta mapaya nura haiꞌa̱ rá thuhu ra Hai dega Ji. ");
INSERT INTO oteNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Njabʉ bi nja ngu núꞌa̱ xqui ma̱nga ra ba̱di Jeremía bi ꞌñena: “Bri jʉ núꞌa̱ ꞌnatemaꞌrɛtꞌa ya tꞌaxboja̱ pa bi thanga ꞌnara hai núꞌa̱ mrá mɛti ꞌnara hyoca traste. Njabʉ bi ꞌbɛpcagui Ajua̱ ga øtꞌe. Ngueꞌa̱ ya me Israel bi ꞌñena gue núꞌa̱ ra ja̱ꞌiꞌa̱ da ꞌba po ꞌnatemaꞌrɛtꞌa ya tꞌaxboja̱.” ");
INSERT INTO oteNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ra Jesu ya mi ꞌbahni ja rá thandi ra Pilato núꞌa̱ toꞌo mrá nda̱ de Judea. Ha ra Pilato bi ꞌñani, bi ꞌñembabi: ―¿Ha go gueꞌi grá da̱nga Nda̱ de ya xodyo? Ha ra Jesu bi da̱tuabi: ―Ha̱ha̱ go guecagui, ngu núꞌa̱ gá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nepʉ ya nda̱ gá macja̱ ne ya nda̱xjua nda̱ bi ña̱pabi ra Jesu, pe nuꞌá̱ hinte bi da̱di. ");
INSERT INTO oteNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nuꞌbʉ́ ra Pilato bi ꞌñembabi ra Jesu: ―¿Ha hinguí øde gatho núꞌa̱ te hma̱ de gueꞌi? ");
INSERT INTO oteNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pe ra Jesu hinte bi da̱tuabi. Por guehna ra Pilato xi bi ꞌyø. ");
INSERT INTO oteNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Núꞌa̱ ra nza̱i de Judea gue ra nda̱ pɛꞌtsi da hyɛgui ꞌnara ꞌyofadi núꞌʉ go da huahna ya ja̱ꞌi núꞌʉ ya pa de rá ngo ra pascua. ");
INSERT INTO oteNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ha nuya paꞌʉ mi ofadi ꞌnara ꞌñøhø mrá thuhu ra Barraba núꞌa̱ xqui tꞌøde ndunthi de gueꞌa̱ ngueꞌa̱ xi mrá tsꞌoja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y nuꞌbʉ́ nura ora bi muntsꞌa ya ja̱ꞌi, ra Pilato bi ꞌyambabiꞌʉ ne bi ꞌñembi: ―¿Toꞌo guí nehʉ ga hɛgui, ra Barraba o nuni ra Jesu tꞌembi ra Cristo ra nda̱? ");
INSERT INTO oteNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngueꞌa̱ ra Pilato mi pa̱di hanja ya nda̱ gá xodyo xqui ziꞌtsuabi ra Jesu ngueꞌa̱ mi tsu da hña̱nbabiꞌa̱ yá nsu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ha nu de mi huhni ra Pilato ja rá hudi, nurá ꞌbɛhña̱ bá pɛnpa ra noya ne bi ꞌñembi: “Ote xqui ma gui hñøtꞌe de gue núꞌa̱ ra hoga ja̱ꞌiꞌa̱, ngueꞌa̱ manxuui dá ꞌuipa ꞌnará tꞌi xi xá ntsꞌo.” ");
INSERT INTO oteNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pe ya nda̱ gá macja̱ ne ya nda̱xjua nda̱ bi ꞌyʉꞌta gatho ya ja̱ꞌi pa da ꞌyadiꞌʉ gue go da thɛgui ra Barraba, ne go da tho ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nuꞌbʉ́ ra Pilato bi ꞌyambabi maꞌnaꞌqui ya ja̱ꞌi ne bi ꞌñembi: ―¿Ndaꞌa̱ de ri yoho guí nehʉ ga hɛgui? Nuꞌbʉ́ ya ja̱ꞌi bi da̱di ne bi ꞌñena: ―Nura Barraba. ");
INSERT INTO oteNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hangue ra Pilato bi yopa ꞌyambabiꞌʉ ne bi ꞌñembi: ―Nuꞌbʉ́ ¿te ga øtꞌe co nuni ra Jesu xa thuꞌmbi ra Cristo ra nda̱? Nuꞌbʉ́ ya ja̱ꞌi bi da̱di ne bi ꞌñena: ―¡Manda da tho ja ra pontꞌi! ");
INSERT INTO oteNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nuꞌbʉ́ ra Pilato bi ꞌñembabiꞌʉ: ―¿Pe te ma tsꞌoqui xa ꞌyøtꞌni? Pe nuꞌʉ́ maꞌna xi mi mafi ntsꞌɛdi mi ena: ―¡Manda da tho ja ra pontꞌi! ");
INSERT INTO oteNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nu mi hyanda ra Pilato gue maꞌna ꞌyo mri ñʉntsꞌi ya ja̱ꞌi ne himi tsa te da ꞌyøtꞌeꞌa̱, nuꞌbʉ́ bi manda da tha̱mpa tsꞌʉ ra dehe, ne bi nxʉꞌyɛ ja yá thandi gatho ya ja̱ꞌi, ne bi ꞌñena: ―Nugui hingo ma ga tha̱di de nurá ji ma da manga nuna ra hoga ꞌñøhø nu stí du. Nuꞌahʉ ya go guí pa̱hʉ te ma gui tha̱dihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nuꞌbʉ́ bi da̱di gatho ya ja̱ꞌi ne bi ꞌñena: ―¡Nuje ne gatho ma ba̱tsihe ma go ga tha̱dihe de núꞌa̱ ra ji ma da mfani! ");
INSERT INTO oteNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nuꞌbʉ́ ra Pilato bi hyɛgui ra Barraba, ne bi manda bri fɛtꞌa ra Jesu, nepʉ bi ꞌyɛntꞌuabiꞌa̱ ja yá ꞌyɛ yá soldado pa da hyoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nuꞌbʉ́ ya soldado bi zixa ra Jesu pa habʉ mi ꞌbʉi ra da̱nga tsꞌʉtbi, ne ja bá cotꞌathoni gatho ya soldado. ");
INSERT INTO oteNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nepʉ bi møqueꞌʉ ne bi hyetuabi ꞌnara thɛnga he. ");
INSERT INTO oteNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne bi hñuꞌtsuabi ja rá ña̱xu ꞌnara corona dega ꞌmini xqui ꞌbetꞌe, ne bi ꞌyɛntꞌua ja rá ꞌyɛ ra ꞌñɛi ꞌnara tsꞌʉtꞌo. Nepʉ bi ndandiña̱hmuꞌʉ ja rá thandiꞌa̱, ne mi øꞌtuatho ra ntꞌeni mi embi: ―¡ꞌBʉi pa nza̱ntho, nuꞌi ri tꞌequꞌei rá Nda̱ꞌi ya xodyo! ");
INSERT INTO oteNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nepʉ bi zotsꞌiꞌʉ ne bi hña̱mba núꞌa̱ ra tsꞌʉtꞌo mi o ja rá ꞌyɛ ne con gueꞌa̱ bi naꞌmba ja rá ña̱xu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nepʉ de mi uadiꞌʉ bi ꞌyøꞌtua ra ntꞌeni ra Jesu, bi møcuabi núꞌa̱ ra thɛnga he xqui hyetuabi, nepʉ bi yopa hyetua núꞌʉ yá dutu xi mi he. Nepʉ bi zitsꞌiꞌʉ pa da pontꞌi ja ra pontꞌi pa ja dí duni. ");
INSERT INTO oteNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ne de má ꞌñu bi nthɛuiꞌʉ ꞌnara ꞌñøhø mrá thuhu ra Simu mrá me Cirene. Nepʉ núꞌa̱ ra ꞌñøhøꞌa̱ bri japi bi duxa núꞌa̱ ra pontꞌi habʉ mi ma da tsꞌʉta ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Njabʉ bi zøni ja ra luga rá thuhu Golgota núꞌa̱ rí bøni da ꞌñena Ña̱xmadu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nuni ja bá tꞌumbabini ra Jesu ra vinu xqui ntha̱ntsꞌi co ꞌnara nda̱po xi xmá nju, pe mi za gue xmá nju himbi ne bi zi. ");
INSERT INTO oteNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nu mi uadi ya soldado bi pontꞌa ra Jesu, nuꞌbʉ́ nuꞌʉ́ bi rifabi yá dutu pa bi hñegueꞌʉ. Njabʉ bi nja ngu núꞌa̱ xqui ma̱nga rá ꞌmɛhni Ajua̱ núꞌa̱ bi ꞌñena: “Núꞌʉ́ bi rifagui ma dutu pa bi hñegueꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nepʉ ya soldado ja bi hñudini pa bi su ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y xqui tꞌofo ja ra pontꞌi maña̱ de ja rá ña̱xu ndaꞌa̱ ra tsꞌoqui xqui ꞌyøtꞌe ngu mi ma̱ñꞌʉ pa ja bi duni. Y núꞌa̱ xqui tꞌofoni mi ma̱ gue nuꞌá̱ go ra Nda̱ de ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nehe bri pontꞌa yoho ya be habʉ bri pontꞌa ra Jesu, ꞌna ja rá ꞌñɛi, ne núꞌa̱ maꞌna ja rá nga̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Y núꞌʉ toꞌo mi thoguini mi bʉtꞌa yá ña̱xu ne mi xaxi, ");
INSERT INTO oteNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mi embabi: ―Núꞌi xcá ma̱ gue gui yøꞌta ra nija̱, nepʉ rá hñupa gui yopa ꞌbaꞌmi, mpøhø de gueꞌasɛ, ne ca̱i de ra pontꞌi ꞌbʉ xi majua̱ni go gueꞌi rá Tꞌʉꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nehe ya nda̱ gá macja̱ ne ya xahnate de ra ley, co ya fariseo ne ya nda̱xjua nda̱ mi nønga ra Jesu ne mi ꞌñémsɛꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Maꞌra ha̱, bi za bi pøhø, pe nubyani hinda za da mpøhø sɛhɛ. Nuꞌbʉ go xi guehma̱ni yá Nda̱ ya me Israel, dá ga̱ibya de ra pontꞌi pa ga camfrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nuni xa hñuxa rá jamfri ja Ajua̱, hangue dá ña̱mbya Ajua̱ ꞌbʉ gue xi majua̱ni Ajua̱ ri ma̱di, cabo xa xicsɛhʉni ne xa ꞌñena gue go guehni rá Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nehe núꞌʉ yoho ya be xcrí pontꞌi mahyɛgui co ra Jesu bi xaxiꞌʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Y ngu mi ꞌnɛtꞌyoho ra hyadi, bi mʉdi bi ꞌmɛxuui gatho ra ximhai ne asta mi nzʉnga hñu nde ja bi yopa hnequi maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ne nura oraꞌa̱ ra Jesu bi ña̱ ntsꞌɛdi ne bi ꞌñena: ―Elí, Elí, ¿lama sabactani? ―Rí bøni da ꞌñena, ma Dadaꞌi, ma Dadaꞌi, ¿hanja xcá hyɛgasɛua? ");
INSERT INTO oteNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nuꞌbʉ́ ꞌra de gue núꞌʉ mi ꞌbʉhni bi ꞌyøde ne bi ꞌñenaꞌʉ: ―Nuni ra ꞌñøhø maꞌta ndu ra ba̱di Elía. ");
INSERT INTO oteNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nuꞌbʉ́ ꞌna de gue núꞌʉ mi ꞌbʉhni ꞌbestho bi nestꞌihi bá ha̱ ꞌnara zi sponja ne bi pobo co ra juꞌtsa vinu. De guehni bi tøta ja ꞌnara tsꞌʉtꞌo, nepʉ bi goꞌtsuabi ja rá ne. ");
INSERT INTO oteNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pe nu maꞌra bi ꞌñena: ―Tsopʉ, ma ga nuhʉ ua da zø ra Elía pa da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nuꞌbʉ́ bi yopa ña̱ ntsꞌɛdi maꞌnaꞌqui ra Jesu, nepʉ ra oraꞌa̱ ꞌbestho bi du. ");
INSERT INTO oteNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nura oraꞌa̱ bi xø núꞌa̱ ra dutu mi naxa mbo ra nda̱nija̱ pa mi cotꞌa habʉ xi xmá nsunda, bi mʉdi de maña̱ pa rí gaꞌti. Ne xi bi nja ꞌnara mbimhai ntsꞌɛdi y asta bi xø ya do. ");
INSERT INTO oteNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","(Nehe bi xoxa ya ntꞌagui ne bi yopa nte ndunthi ya gamfri núꞌʉ ya xqui du. ");
INSERT INTO oteNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ne nu de ya xqui yopa nte ra Jesu, nuꞌbʉ́ núꞌʉ xqui bønga de ja ya ntꞌagui, bi ꞌño ja ra hnini Jerusale habʉ bá handa ndunthi ya ja̱ꞌi.) ");
INSERT INTO oteNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ngu bi du ra Jesu, ra nda̱ gá soldado ne yá mfatsꞌi núꞌʉ mi suꞌa̱ bi zaꞌʉ ra mbimhai ne bi hyanda gatho núꞌʉ te bi nja, hangue xi bi ntsuꞌʉ ne bi ꞌñena: ―Xi majua̱ni nuni ra ꞌñøhø go mi guehni rá Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","De zi yabʉtho mi ꞌbahni ndunthi ya ꞌbɛhña̱ mi handa núꞌa̱ te bi nja. Nuya ꞌbɛhña̱ꞌʉ go gueꞌʉ xqui mɛpabi ra Jesu ne xqui ꞌñoui de Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ꞌRa de gueꞌʉ, ra Maria Magdalena, ne ra Maria nurá na̱na̱ ra Cobo ne ra Jose, ne rá na̱na̱ núꞌʉ yoho yá tꞌʉ ra Sebedeo. ");
INSERT INTO oteNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","De ya mi ma da yʉ ra hyadi ꞌnará nxadi ra Jesu mrá me Arimatea mrá thuhu ra Jose ne xi mrá rico, ");
INSERT INTO oteNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","bi ma bá cꞌa̱ꞌtsa ra Pilato pa bi ꞌyapa nsɛqui da ma da ꞌyacuabi rá ndoꞌyo ra Jesu. Nuꞌbʉ́ ra Pilato bi manda da tꞌumbabi nsɛqui pa da ma da ꞌyagui. ");
INSERT INTO oteNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nuꞌbʉ́ ra Jose bi ma bá tumpa rá ndoꞌyo ra Jesu, ne bi mantꞌi co ꞌnara tꞌaxa dutu. ");
INSERT INTO oteNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nepʉ bi ma bá agui ja ra ntꞌagui núꞌa̱ xqui hyoquiꞌa̱ ja ꞌnara hña̱do pa go xa ntꞌaguini hma̱ha̱ꞌa̱. Nepʉ bi gotꞌa ra ntꞌagui co ꞌnara da̱nga do, ne bi maꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne guetbʉ ja ra ntꞌagui mi huhni ra Maria Magdalena ne núꞌa̱ maꞌna ra Maria. ");
INSERT INTO oteNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Rá hyaxꞌa̱, ya xqui thogui núꞌa̱ ra pa de ra nthoqui, bi ma ya nda̱ gá macja̱ ne ya fariseo bá cꞌa̱ꞌtsa ra Pilato, ");
INSERT INTO oteNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ne bi ꞌñembi: ―Núꞌi ma nda̱ꞌihe, dí beñhe gue núꞌa̱ ra hyate ꞌñøhø núꞌbʉ mi tetho bi ꞌñena gue rá hñupa mi ma da yopa nte. ");
INSERT INTO oteNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hangue dí nehe gui pɛhna toꞌo da su ra ntꞌagui hñu pa, pa hinda ꞌñehe yá nxadi dega xuui ne da be. Nuꞌbʉ́ ha̱, nuya nxadi ma da ꞌñembabi ya ja̱ꞌi gue xa yopa nteꞌa̱, ne maꞌna strá ntsꞌo nuna ncꞌuambana̱ de núꞌa̱ rá mʉdi. ");
INSERT INTO oteNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bi da̱di ra Pilato ne bi ꞌñena: ―Ma ga ꞌraꞌahʉ ya soldado gui tsixhʉ pa gui suhʉ xá hño ra ntꞌagui asta habʉ da za. ");
INSERT INTO oteNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nuꞌbʉ́ nuya nda̱ gá macja̱ co ya fariseo bi ma bá su ra ntꞌagui ne bi hñuꞌtsua ꞌnara seyo ra do, ne bi zohniꞌʉ ya soldado pa bi su. ");
INSERT INTO oteNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Rá hyaxꞌa̱ de ya xqui thogui ra pa dega tsaya ne ya mi fʉdi da hyatsꞌi de ra mʉdi pa de ra semana, ra Maria Magdalena ne maꞌna ra Maria bi ma da cꞌa̱ꞌtsa ra ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Y nura oraꞌa̱ bi nja ꞌnara da̱nga mbimhai, ngueꞌa̱ bá ca̱i ꞌnara ɛnxɛ de mahetsꞌi, ne ngu bi zøhø habʉ xqui tꞌagui ra Jesu, bi ꞌyentꞌa núꞌa̱ ra do xqui jotꞌa ra ntꞌagui, nepʉ bi hñudiꞌa̱ maña̱ de nura doꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nura ɛnxɛꞌa̱ xi mri yotꞌi ngu ꞌnara huɛi, ne nurá he xi xmá ntꞌaxi ngu ra tsɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y nu mi hyanda ya soldado njabʉ, nuꞌʉ́ bi umba ra nhua̱tꞌi co ra ntsu ne bi dagui bi hødu. ");
INSERT INTO oteNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nuꞌbʉ́ ra ɛnxɛ bi zofo núꞌʉ ya ꞌbɛhña̱ ne bi ꞌñembi: ―Oguí tsuhʉ. Nuga dí pa̱di gue guí hoñhʉ ra Jesu núꞌa̱ bi tho ja ra pontꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nuꞌá̱ ya joꞌoua, ngueꞌa̱ ya bi yopa nte ngu núꞌa̱ xqui ma̱ñꞌa̱. Bá ehʉ gui hyanthʉ habʉ mi tꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nepʉ grí maha ꞌbestho bá xiphʉ yá nxadiꞌa̱ gue nuꞌá̱ ya bi yopa nte, ne nubyá ya bi ꞌmɛtꞌoꞌa̱ pa Galilea, nuni ja ma grí hyanthʉni maꞌnaꞌqui. Pa gueꞌa̱ dá ehe ga xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nuꞌbʉ́ bi ma hnestꞌihi núꞌʉ yoho ya Maria, ngu tsꞌʉ mi tsu y ngu tsꞌʉ mi johya. Bi maꞌʉ pa bá xipa ya nxadi núꞌa̱ bi ma̱nga ra ɛnxɛ. ");
INSERT INTO oteNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne nura ora mi ꞌyo ra ꞌñuꞌʉ mi da̱mfri bi nthɛui ra Jesu ne nuꞌá̱ bi zɛnguaꞌʉ. Nuꞌbʉ́ nuꞌʉ́ bi joni habʉ mi ꞌbai pa bi nsundaꞌʉ, ne bi hyʉpabi yá ua. ");
INSERT INTO oteNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Oguí tsuhʉ. Grí maha gui xiphʉ núꞌʉ ma cu da ma pa Galilea ne ja grá nthɛꞌbeniꞌʉ maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","De ya xqui ma núꞌʉ ya ꞌbɛhña̱, ꞌra de gue núꞌʉ ya soldado mri su ra ntꞌagui bi ma pa ja ra hnini pa bá xipa ya nda̱ gá macja̱ de gatho núꞌa̱ te xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nuꞌbʉ́ ya nda̱ gá macja̱ bi ꞌñʉꞌtiui ya nda̱xjua nda̱ pa da umbabiꞌʉ ndunthi ra boja̱ ya soldado pa da ma̱nga ꞌnara ncꞌuamba, ");
INSERT INTO oteNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne bi ꞌñembabiꞌʉ: ―Nuꞌahʉ pɛꞌtsi te gui ma̱ñhʉ gue de mi nxuui gá a̱ha̱hʉ, hangue nura oraꞌa̱ nuyá nxadi ra Jesu bi zøhø ne bi duꞌtsuaꞌʉ rá ndoꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ha nuꞌbʉ da nja ra pa da ba̱di ra nda̱ de núna xa nja, odi tu ri mʉihʉ, ngueꞌa̱ nuje go ma ga ña̱he con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nuꞌbʉ́ ya soldado bi hña̱nga ra boja̱, nepʉ bi maꞌʉ bi ꞌyøtꞌe ngu núꞌa̱ xqui sipabi. Hangue asta mapaya nuya xodyo camfri gue xi bi njabʉ ngu núꞌa̱ ra ncꞌuamba bi ma̱nga ya soldado. ");
INSERT INTO oteNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nuꞌbʉ́ núꞌʉ ꞌrɛtꞌamaꞌra ya nxadi bi ma pa Galilea nuni ja ra tꞌøhø habʉ xqui xipabi ra Jesu da nthɛui. ");
INSERT INTO oteNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y ngu bi hyantꞌʉ ra Jesu xi bi nsunda, masque ꞌra de gueꞌʉ hintsꞌʉ mi camfri. ");
INSERT INTO oteNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nuꞌbʉ́ ra Jesu bi joni pa habʉ mi ꞌbʉiꞌʉ ne bi ꞌñembi: ―Gatho ra tsꞌʉtbi xa tꞌɛndgagui ja ma ꞌyɛ pa ga nda̱ nuni mahetsꞌi ne nuua ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hangue grí maha bá zofohʉ gatho ya ja̱ꞌi núꞌʉ ꞌbʉi ja rá ngʉni ra ximhai pa dua nxadi neheꞌʉ, ne xiꞌtshʉꞌʉ de rá thuhu ra Dada, ne de ra Tꞌʉ, ne de ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nehe ꞌñutuabihʉꞌʉ da ꞌyøtꞌe gatho ngu núꞌa̱ stá ꞌbɛpꞌaꞌihʉ. Y nuga nza̱ntho ma ga ꞌbʉi con gueꞌahʉ asta rá uadi ra ximhai. Njabʉ gueꞌa̱.");
INSERT INTO oteNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Rá ma̱ca hoga tꞌøde ra Jesucristo rá Tꞌʉ Ajua̱ bi mʉdi njaua: ");
INSERT INTO oteNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ra ba̱di Isaía bi ꞌyofo nuya ya noya ya mayaꞌbʉ gue Ajua̱ bi xipabi da ꞌyofo: Ndi, nuga drá Ajua̱ dí pɛhna ma ꞌmɛhni pa da ꞌmɛtꞌo de gueꞌe pa da hyocꞌa ri ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nuna ra ꞌmɛhni go guehna ma da ña̱ ntsꞌɛdi ja ra mbonthi ne da ꞌñembabi ya ja̱ꞌi njaua: “Hyocjʉ ra ꞌñu pa da tho ma Hmuhʉ, ne jua̱ñhʉ ya tsꞌacaꞌñu.” ");
INSERT INTO oteNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Y nu mi ꞌñehe ra Xuua Xiꞌtsate bi njabʉ ngu núꞌa̱ xqui ma̱nga Ajua̱, bi ꞌmʉ ja ra mbonthi ne mi xipa ya ja̱ꞌi mi ena: “Ñobrihʉ ne nxistehehʉ y Ajua̱ da punꞌahʉ ri tsꞌoquihʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ha gatho nuya ja̱ꞌi mi ꞌbʉ ja ra hnini Jerusale ne gatho rá ngʉni de ra hai Judea mi pa habʉ mi ꞌbʉ ra Xuua pa mi ødeꞌʉ nuya noya mi ma̱ñꞌa̱ ne pa mri njua̱ni de yá tsꞌoqui ja rá thandi Ajua̱. Y ra Xuua mi xiꞌtsiꞌʉ ja ra da̱the Jordá. ");
INSERT INTO oteNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Y núꞌá̱ mi nhye dega xicameyo, ne mi ngʉtꞌa ꞌnara ngʉtꞌi dega xifri. Mi tsi ya hoga ncꞌoto ne ra tꞌafi dega sefi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Y mi zofo ya ja̱ꞌi ne mi embabiꞌʉ: ―Ya xa ꞌñepʉ bra ꞌbɛfa de gueque ꞌna toꞌo maꞌna ja rá tsꞌɛdi de gueque núꞌa̱ hindí ꞌñepcagui ngugui ga xoꞌtua yá ntha̱sthi yá thiza. ");
INSERT INTO oteNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Xi majua̱ni nuga dí xiꞌtsꞌaꞌihʉ co ra dehe, pe nuꞌá̱ ma da xiꞌtsꞌaꞌihʉ co ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Y núꞌbʉ mi xiꞌtsate ra Xuua, bi ꞌñehe ra Jesu de ra hnini Nasare de ra hai Galilea ne bi ma ja ra da̱the Jordá, ne ja bá xiꞌtsini ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Y ngu mi bøxa ra Jesu de ja ra dehe habʉ xqui nxistehe, bi hyandi bi xogui mahetsꞌi y bá ca̱i rá Ma̱ca Nda̱hi Ajua̱ ngu ꞌnara zi domitsu, ne bi zøhø ja gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nepʉ bi ntꞌøde ꞌnara noya de mahetsꞌi ne bi ꞌñena: ―Go gueꞌe ma hma̱ca Tꞌʉꞌi, ne xi dí hopꞌa ri ꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nuꞌbʉ́ ꞌbestho ra Ma̱ca Nda̱hi bi zixa ra Jesu ja ra mbonthi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y nuni ja bá ꞌbʉhni ñote ma pa habʉ mi ꞌbʉ ya mba̱nga zuꞌue. Ne ra Satá mi xaxa ra Jesu pa da ntsꞌocjhma̱ha̱. Y nu mi uadi núꞌʉ ñote ma pa, ya ɛnxɛ bá ha̱mpi te da zi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ha núꞌbʉ mi jotꞌa fadi ra Xuua, ra Jesu bi zøhø ja ra hai Galilea, ne mi ma̱nga ra hoga noya gue ya xa zøhø ra Nda̱ de mahetsꞌi xpá e pa da nda̱ de guecua ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ne mi ena: ―Ya bi zø ya pa ne ꞌbestho ma da nda̱ de guecua ra Nda̱ de mahetsꞌi, hangue ñobrihʉ ne camfrihʉ ra ma̱ca noya. ");
INSERT INTO oteNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ꞌNara pa mi ꞌyoni ra Jesu ja ra ña̱nga ndehe Galilea ne ja bá handri ra Simu ne ra Andre rá cu mi ɛntꞌa yá xitꞌa̱ ja ra ndehe pa da mpɛhua̱ ngueꞌa̱ nuꞌʉ́ myá mɛhua̱ꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nuꞌbʉ́ ra Jesu bi ꞌñembiꞌʉ: ―Bá ehʉ, tɛngaguihʉ y nuga ga uꞌtꞌahʉ gui mpɛhua̱hʉ dega ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hangue nuꞌʉ́ ꞌbestho bi zohni yá xitꞌa̱ ne bi dɛna ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nepʉ ra Jesu bi thogui má tsꞌʉ ringuehni ne bi hyanda ra Cobo ne ra Xuua yá tꞌʉ ra Sebedeo mi o mbo ra motsa mi pøꞌta yá xitꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nuꞌbʉ́ bi zofoꞌʉ, y nuꞌʉ́ bi zohni yá dada ja ra motsa co yá ꞌbɛgo ne bi dɛniꞌʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nepʉ bi maꞌʉ ja ra hnini Ncapernau, ne nu mi datꞌa nsabdo ra pa dega tsaya, ra Jesu bi yʉtꞌa ja ra nija̱ ne mi xahna ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ha nuꞌʉ́ bi ꞌyø de núꞌa̱ mi ma̱ ngueꞌa̱ mi xahniꞌʉ ngu ꞌna toꞌo mi ha̱ ra tsꞌɛdi pa da tꞌøtꞌe núꞌa̱ ma̱, y hingue ngu núꞌʉ ya xahnate de yá leyꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ne ja xqui zøhni ja yá nija̱ꞌʉ ꞌnara ꞌñøhø mi pɛꞌtsa ꞌnara tsꞌonda̱hi, ne nuꞌá̱ bi mafi bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Nuꞌi Jesu grá me Nasare, ¿te ma gui ꞌyøtcahe? ¿Ha gue xcá ehe pa gui huatcahe? Dí pa̱he toꞌoꞌi, nuꞌi go gueꞌe rá Ma̱ca Tꞌʉꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nuꞌbʉ́ ra Jesu bi zʉi nura tsꞌonda̱hi ne bi ꞌñembi: ―¡Coꞌta ri ne, pøni de nuna ra ꞌñøhø! ");
INSERT INTO oteNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nepʉ nura tsꞌonda̱hi bi japa núꞌa̱ ra ꞌñøhø da ndusɛ, ne bi mafi ntsꞌɛdi, ne bi bøni de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hangue gatho ya ja̱ꞌi bi ꞌyø ne bi ꞌñémsɛꞌʉ ꞌna ngu maꞌna: ―¿Te rí bønga nuna? ¿Te ma ꞌraꞌyo ntꞌudibyana̱? ¿Te ma tsꞌɛdi ha̱ni? ¡Ngueꞌa̱ nuní ꞌbɛpa ya tsꞌonda̱hi da bøni y nuꞌʉ́ øtuabi! ");
INSERT INTO oteNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hangue habʉraza ja ra hai Galilea xi bi da̱ma ꞌño ra noya de núꞌa̱ xqui ꞌyøtꞌa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Y mi bønga ra Jesu de ra nija̱ bi ma ja rá ngu ra Simu ne ra Andre núꞌʉ mi ꞌñoui, bi mɛuiꞌʉ ra Cobo ne ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ha nurá to ra Simu mi ꞌbɛni mi umba ra nzø, ne nuꞌʉ́ ꞌbestho bi xipa ra Jesu gue mi hñeniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nuꞌbʉ́ ra Jesu bi ma bi gʉtsꞌi de ꞌnará ꞌyɛ, bi ꞌbaꞌmi, ne ꞌbestho ra oraꞌa̱ bi tsayabi ra nzø, nepʉ núꞌa̱ ra ꞌbɛhña̱ bi umbabi te da ziꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ha nura paꞌa̱ de mi nde bá tsꞌimpabi ra Jesu gatho núꞌʉ toꞌo mi hñeni ne nuto mi pɛꞌtsa ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Y gatho ya ja̱ꞌi de ra hnini bi muntsꞌa ja ra gosthingu habʉ mi ꞌbʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y nuꞌá̱ bi ꞌyøthe ndunthi ya ja̱ꞌi toꞌo mi pɛꞌtsa ꞌramaꞌnaꞌño ya hñeni, ne bi ꞌyɛni ndunthi ya tsꞌonda̱hi, ne himi hopi da ña̱ ya tsꞌonda̱hi ngueꞌa̱ nuꞌʉ́ mi pa̱di toꞌoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rá hyaxꞌa̱ ra Jesu bi nangui hamxuditho ne bi bøni bi ma ja ra mbonthi ne ja bá apabini Ajua̱ rá Dada. ");
INSERT INTO oteNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ꞌMɛfa bi ma ra Simu ne núꞌʉ toꞌo mi ꞌñoui, bi ma bá honiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Y nu mi zʉdiꞌa̱ bi ꞌñembi: ―Ndunthi ya ja̱ꞌi hoñꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pe ra Jesu bi ꞌñena: ―Maha ja ya tꞌʉca hnini núꞌʉ ja nthetsꞌi de guecua pa ga zofoꞌʉ nehe, ngueꞌa̱ pa gueꞌa̱ stá ehe. ");
INSERT INTO oteNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nuꞌbʉ́ bi ma gatho ja rá nthetsꞌi ra hai Galilea, ne ra Jesu bi zofo ya ja̱ꞌi ja yá nija̱, ne bi ꞌyɛnga ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ꞌNara ꞌñøhø mi tsʉ ꞌnara hñeni rá thuhu ra lepra núꞌa̱ tsitꞌatho ra ngø, bi ꞌñehe bi ndandiña̱hmu ja rá thandi ra Jesu ne bi ba̱ntebi bi ꞌñembi: ―Nuꞌbʉ gui nehma̱, nuꞌí ja ri tsꞌɛdi pa gui ꞌyøthegui de nuna hñeni tsʉqui. ");
INSERT INTO oteNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nuꞌbʉ́ ra Jesu bi huequi ne bi hñuꞌtsuabi rá ꞌyɛ ne bi ꞌñembabi: ―Ha̱ha̱ dí ne, y ya gá ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ha nu mi ma̱nga ra Jesu njabʉ, nu habʉ xqui ꞌya, ꞌbestho bi ꞌyostho ne bi ꞌmʉi xi xá hño rá ndoꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nuꞌbʉ́ ra Jesu bi hñuꞌmba ra hña̱ ne bi ꞌñembi: ―Jamasu gue ni ꞌna hinto gui xipi. Hønsɛ nuꞌa̱ dí ne, grí ma ja ra nija̱ gui ꞌñudi ja ra macja̱ ne ja guehni ma gui unga ra ꞌbaha núꞌa̱ bi ma̱nga ra Moise da tꞌuni, y njabʉ da fa̱di gue ya xcá ña̱ni de ri hñeni. Nepʉ bi ꞌbɛpa núꞌa̱ ra ꞌñøhø da ma. ");
INSERT INTO oteNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pe nu mi ma núꞌa̱ ra ꞌñøhø bi mʉdi bi xipa gatho ya ja̱ꞌi núꞌa̱ xqui tꞌøꞌtuabi ne xi bi ꞌyonga ra ꞌbede. Hangue ra Jesu ya himi tsa da yʉtꞌa ja ya hnini pa da zofo ya ja̱ꞌi ngueꞌa̱ xi xqui muntsꞌa ndunthi. Ne hangue nuꞌá̱ mi ꞌbʉitho ja ya mbonthi, y nehe mi pani ndunthi ya ja̱ꞌi de habʉraza pa mi cꞌa̱ꞌtsiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ne mi thogui ꞌraya pa ra Jesu bi mengui pa Ncapernau, y ya ja̱ꞌi bi ꞌyøde gue xqui zøniꞌa̱ ja núꞌa̱ ra ngu habʉ xqui mihiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hangue ꞌbestho ndunthi ya ja̱ꞌi bi ma habʉ mi ꞌbʉꞌa̱ y asta himbi ꞌñɛni gatho mbo ja ra ngu. Hangue ꞌra mi ꞌbaitho møte ra gosthi, y ra Jesu mi xipabi ra ma̱ca noya. ");
INSERT INTO oteNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nepʉ bi zøhø ꞌraya ja̱ꞌi y goho de gueꞌʉ mbra ndude ꞌnara tsꞌonate. ");
INSERT INTO oteNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Y himbi za bi yʉtꞌiꞌʉ habʉ mi ꞌbʉ ra Jesu ngueꞌa̱ xqui muntsꞌini ndunthi ya ja̱ꞌi. Hangue bi bøxꞌʉ maña̱, bi xøꞌtsa ꞌnara xɛni de ra xʉngu pa bi ca̱ꞌma ra tsꞌonate co rá ꞌbebo asta habʉ mi ꞌbai ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nuꞌbʉ́ ra Jesu bi ba̱di gue nuꞌʉ́ xi mi ja yá jamfri hangue bi ꞌñemba ra tsꞌonate: ―Ma tꞌʉꞌi, dí punꞌaꞌi gatho ri tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ha mi huhni ꞌraya xahnate de ra ley, ne mi bensɛ njaua ja yá mfeniꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Hanja ma̱nga njabʉni gue ri ꞌñetꞌa Ajua̱? Ngueꞌa̱ hønsɛ Ajua̱ go gueꞌa̱ tsa da punga ya tsꞌoqui, y hinto maꞌna.” ");
INSERT INTO oteNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pe ra Jesu ꞌbestho bi ba̱tho núꞌa̱ mi beñꞌʉ ne bi ꞌñembiꞌʉ: ―¿Hanja guí beñhʉ njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ndaꞌa̱ maꞌna hinxá hñei pa ga xipa ra tsꞌonate: “Dí punꞌaꞌi ri tsꞌoqui”, o ga embabi: “ꞌBai, jʉxa ri mfidi ne ꞌyo”? ");
INSERT INTO oteNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nde, pa gui pa̱hʉ gue Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi pɛꞌtsa ra tsꞌɛdi ja ra ximhai pa da pumba yá tsꞌoqui ya ja̱ꞌi, ma ga øtꞌa njaua: Nuꞌbʉ́ bi ꞌñemba ra tsꞌonate: ");
INSERT INTO oteNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Dí xiꞌaꞌi, ꞌbai, jʉxa ri mfidi ne grí ma ri ngu. ");
INSERT INTO oteNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nuꞌbʉ́ ꞌbestho bi ꞌmai ra tsꞌonate, ne bi gʉxa rá mfidi ne bi bøni ja yá thandi gatho ya ja̱ꞌi. Hangue nuꞌʉ́ xi bi ꞌyø ne bi nsunda Ajua̱ ne bi ꞌñenaꞌʉ: ―Ni ꞌnaꞌqui hinstá hanthʉ ꞌnara tꞌøtꞌe ngu núna stá hanthʉbya. ");
INSERT INTO oteNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nepʉ ra Jesu bi yo mengui ja ra ña̱nga ndehe ne ja bá muntsꞌini ndunthi ya ja̱ꞌi ne ja guehni bi xahniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nepʉ bi ma de guehniꞌa̱, ne ꞌmɛfa bi hyanda ra Leví rá tꞌʉ ra Alfeo mi hudi ja rá mexa mi pɛ rá ꞌbɛfi dega ngʉxboja̱. Ne bi ꞌñembabi: ―Bá ehe tɛngagui. Nuꞌbʉ́ ra Leví bi ꞌmai bi dɛniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ne ꞌnaꞌqui ra Jesu ne yá nxadi mi huhni ja rá ngu ra Leví mi ñungüi ya ꞌña̱tsa ngʉxboja̱ ne maꞌra ya tsꞌoja̱ꞌi toꞌo himi øtꞌe ngu núꞌa̱ ma̱nga rá ley ra Moise. Gatho mi huhuiniꞌʉ ngueꞌa̱ ndunthi de gueꞌʉ xqui dɛniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nuꞌbʉ́ ꞌraya xahnate de ra ley ne ꞌraya fariseo núꞌʉ ya ja̱ꞌi toꞌo ntsꞌɛdi jamasu rá ley ra Moise, bi hyanda ra Jesu mi ñungüi ya ngʉxboja̱ ne núꞌʉ maꞌra ya tsꞌoja̱ꞌi. Hangue nuꞌʉ́ bi ꞌyambabi yá nxadi ra Jesu bi ꞌñembi: ―¿Hanja di ñungüi núyʉ ya ꞌña̱tsa ngʉxboja̱ ne núyʉ maꞌra ya tsꞌoja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pe ra Jesu bi ꞌyøde núꞌa̱ mi ma̱ñꞌʉ ne bi ꞌñembabiꞌʉ: ―Nuꞌʉ tóꞌo ꞌyo má hño hingui honga ra medico, pe nuꞌʉ tóꞌo di hñeni ha̱. Nuga stá ehe pa ga zofo ya ꞌyøtꞌatsꞌoqui pa da ñobri, hingue stá ehe ga zofo núꞌʉ øtꞌe xá hño. ");
INSERT INTO oteNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ꞌNara ꞌmiꞌqui mri ayuna yá nxadi ra Xuua ne yá nxadi ya fariseo, bi ꞌñehe ꞌraya ja̱ꞌi bi cꞌa̱ꞌtsa ra Jesu ne bi ꞌñembabi: ―¿Hanja nuyá nxadi ra Xuua ne yá nxadi ya fariseo di ayunaꞌʉ, pe nuri nxadigue hingui ayuna? ");
INSERT INTO oteNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―¿Ha gue dí ꞌñepi da ayuna nuya ja̱ꞌi toꞌo xa tsꞌohna ja ꞌnara ntha̱ti? Hina. Nuꞌʉ́ da ñuni xá hño ngueꞌa̱ ꞌbʉꞌʉ co núꞌa̱ toꞌo ma da ntha̱tui rá ꞌbɛhña̱. Mientra ꞌbʉꞌʉ co ra na̱vio hindí ꞌñepi da ayuna. ");
INSERT INTO oteNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pe ma da zø ra pa gue sta da̱mfriꞌʉ da tsꞌixa ra na̱vio, nuꞌbʉ́ ha̱, gueꞌbʉ da ayuna núꞌʉ yá amigoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hindí ꞌñepi da ꞌbøꞌta ꞌnara zɛdutu co ꞌnara ꞌraꞌyo dutu, ngueꞌa̱ nura ꞌraꞌyo dutuꞌa̱ da gʉtꞌa nura zɛdutu y maꞌna da ntʉni. ");
INSERT INTO oteNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nixi hingui tsa da sitꞌa ra ꞌraꞌyo vinu ja ꞌnara zɛbota, ngueꞌa̱ ra ꞌraꞌyo vinu da føca ra zɛbota, y njabʉ da tsꞌoca ra bota y da mfanga ra vinu. Maꞌna xá hño da sitꞌa ra ꞌraꞌyo vinu ja ꞌnara ꞌraꞌyo bota pa njabʉ hinte da ja. ");
INSERT INTO oteNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ꞌNara sabdo ra pa dega tsaya ra Jesu bi thogui co yá nxadi ja ꞌraya hua̱hi, y nuyá nxadi bi mʉdi bi doca ya nga̱ha̱ dega trigo. ");
INSERT INTO oteNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hangue ya fariseo bi ꞌñemba ra Jesu: ―Ndi, ri nxadi thoca ya nga̱ha̱ gá trigo, y nubyá go ra pa dega tsaya, y ra ley ma̱ gue hinda tꞌøtꞌe njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―¿Ha hinxcá hñeꞌthʉ núꞌa̱ bi ꞌyøtꞌa ra Davi ne núꞌʉ mi ꞌñoui núꞌbʉ mi zʉ ra thuhu y mi otho te da ziꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nuꞌá̱ bi yʉtꞌa ja rá nija̱ Ajua̱ ne bi zi nuya thuhme xqui thuxni ja rá thandi Ajua̱, ne bi umba núꞌʉ toꞌo mi ꞌñoui pa da ziui. Y nuya thuhmeꞌʉ himrí ꞌñepi toꞌoraza da zi, hønsɛ ya macja̱. Bi tꞌøtꞌa njabʉ nuya paꞌʉ núꞌbʉ mrá nda̱macja̱ ra Abiatar. Y hingrá tsꞌoqui núꞌa̱ bi ꞌyøtꞌa ra Davi. ");
INSERT INTO oteNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nehe ra Jesu bi ꞌñembabiꞌʉ: ―Ra pa dega tsaya bi thutsꞌi pa rá hño ya ja̱ꞌi, hingo bi thoca ya ja̱ꞌi pa da ꞌmʉi ja rá hmanda ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hangue Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ha̱ ra tsꞌɛdi pa da manda masque ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ra Jesu bi yʉtꞌa maꞌnaꞌqui ja ra nija̱, ne xqui zønini ꞌnara ꞌñøhø xqui ꞌyotꞌa ꞌnará ꞌyɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Y ya fariseo mi aca ra Jesu ua da ꞌyøthebi rá ꞌyɛ nura pa dega tsaya, pa da za da ña̱pabi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nuꞌbʉ́ ra Jesu bi ꞌñemba núꞌa̱ ra ꞌñøhø xqui ꞌyotꞌa rá ꞌyɛ: ―Bá ecua, ꞌbai ja yá thandi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nepʉ bi ꞌyamba ya fariseo ne bi ꞌñembi: ―¿Ha dí ꞌñepi ꞌnara ja̱ꞌi da ꞌyøtꞌa ꞌnara hño ra pa dega tsaya, o da ꞌyøtꞌa núꞌa̱ hinxá hño? ¿Ha gue xá hño da ña̱mba rá te ꞌnara ja̱ꞌi, o da hyoꞌa̱? Pe ya fariseo hinte bi da̱tuabi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nuꞌbʉ́ ra Jesu bi bø rá cuɛ, ne bi du rá mʉi ndunthi ngueꞌa̱ nuya fariseoꞌʉ himi ja yá nthecate. Hangue bi ꞌñemba ra daꞌthi: ―Tʉnga ri ꞌyɛ. Y nuꞌá̱ bi ꞌyøtꞌa njabʉ ne ꞌbestho bi ña̱nga rá ꞌyɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nuꞌbʉ́ bi bønga ya fariseo ne bi ma bá cꞌa̱ꞌtsua yá mfatsꞌi ra nda̱ Erode pa bi ꞌñʉꞌtiꞌʉ hanja da za da hyohma̱ꞌʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pe nura Jesu bi ma ja ra ña̱nga ndehe co yá nxadi, ne bi dɛniꞌa̱ ndunthi ya ja̱ꞌi me Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nehe mi dɛniꞌa̱ ya me Judea, ne ya me Jerusale, ne ya me Idumea, ne ya me Tiro, ne ya me Sidó co núꞌʉ ya me riꞌnandi ra da̱the Jordá. Mi ehe da cꞌa̱ꞌtsiꞌa̱ ngueꞌa̱ xqui ꞌyødeꞌʉ de núꞌʉ ya da̱nga ntꞌudi mi øtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ha ra Jesu bi xipa yá nxadi gue da da̱tꞌa ꞌnara motsa guetbʉ ja ra ña̱nga ndehe, ngueꞌa̱ xi xmá ntsꞌiꞌmi ja ra hmuntsꞌi co rá ndunthi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ra Jesu xqui ꞌyøthe ndunthi ya daꞌthi, hangue ringueꞌa̱ gatho núꞌʉ toꞌo mri hñeni mri ꞌñentꞌi pa da zʉdi da daniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y nuꞌʉ tóꞌo mi pɛꞌtsa ya tsꞌonda̱hi, mi hyanda ra Jesu bi ndandiña̱hmuꞌʉ ja rá thandi, ne mi mafi mi enaꞌʉ: ―Nuꞌi go gueꞌe rá Tꞌʉꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nuꞌbʉ́ ra Jesu bi ꞌbɛpabi núꞌʉ ya tsꞌonda̱hi gue hinda xipa ya ja̱ꞌi mi toꞌoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nepʉ ra Jesu bi bøxa ja ꞌnara tꞌøhø ne bi zohna núꞌʉ toꞌo xqui huahni, ne nuꞌʉ́ bi ma bá muntsꞌini con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Y nuꞌá̱ bi hñuxa ꞌrɛtꞌamayoho ya nxadi pa da ꞌñoui, ne pa da mɛhni da zofo ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ne bi umba ra tsꞌɛdi pa da ꞌyøthe ya daꞌthi ne da ꞌyɛnga ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Y nuya guehya yá thuhu núꞌʉ ꞌrɛtꞌamayoho yá nxadi: ra Simu núꞌa̱ ꞌmɛfa bi thuꞌmbabi ra Pedro; ");
INSERT INTO oteNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ra Cobo ne ra Xuua yá tꞌʉ ra Sebedeo núꞌʉ bi thuꞌmbabi ya Boanerge núꞌa̱ ne da ꞌñena xi ja yá tsꞌɛdi ngu ra ngani. ");
INSERT INTO oteNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bi thutsꞌi nehe ra Andre, ra Lipe, ra Tolo, ra Teo, ra Toma, ra Cobo rá tꞌʉ ra Alfeo, ra Tadeo, ne ra Simu núꞌa̱ xqui ꞌñoui núꞌa̱ ra hmuntsꞌi rá thuhu ya cananista, ");
INSERT INTO oteNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne ra Juda Iscariote núꞌa̱ toꞌo bi da ra Jesu. Nu mi ga̱i ja ra tꞌøhø ra Jesu ne yá nxadi bi yʉtꞌiꞌʉ ja núꞌa̱ ra ngu xqui mihi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nuꞌbʉ́ bi yopa muntsꞌa maꞌnaꞌqui ndunthi ya ja̱ꞌi asta himi tsa da ñunga ra Jesu ne yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nepʉ bi ꞌyøde nuya mengu rá ngu ra Jesu gue hinte xqui ziꞌa̱, hangue bi ꞌñeheꞌʉ pa da zitsꞌiꞌa̱ ngueꞌa̱ mi eñꞌʉ gue xqui ꞌbɛ rá mfeni. ");
INSERT INTO oteNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nehe ꞌraya xahnate de ra ley xqui ꞌñehe de Jerusale mi ꞌñémbiꞌʉ: ―Nuni ra Jesu pɛꞌtsa ra Beelsebú núꞌa̱ ra nda̱ de ya tsꞌonda̱hi, ne ha̱mpa rá tsꞌɛdiꞌa̱ pa da ꞌyɛnga núꞌʉ maꞌra yá mitsꞌonda̱hiui. ");
INSERT INTO oteNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hangue ra Jesu bi maꞌta nuya xahnateꞌʉ pa bi xipa ꞌnara ꞌbede ne bi ꞌñembi: ―¿Ha gue da za ra tsꞌonda̱hi da ꞌyɛnga yá mitsꞌonda̱hiui? ");
INSERT INTO oteNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nuꞌbʉ ꞌnara hnini da hegue sɛhɛ, da nhuata gatho ra tsꞌʉtbi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y nuꞌbʉ ꞌnara ꞌmʉi da ꞌñʉtsa ꞌna ngu maꞌna, hinda za da ꞌmʉi ꞌnadbʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y nuꞌbʉ ra tsꞌonda̱hi da ntuhni co yá mitsꞌonda̱hiui, nuꞌbʉ́ da nhuata yá tsꞌʉtbiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nixi hinto da za da yʉtꞌa ja rá ngu ꞌnara ꞌñøhø núꞌa̱ xi o rá tsꞌɛdi, ne da bepabi núꞌa̱ te pɛꞌtsi nuꞌbʉ hingue ꞌmɛtꞌo da duꞌti. Njabʉ ha̱, da za da bepabi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Majua̱ni dí xiꞌahʉ, gatho ya tsꞌoqui ne ya tsꞌone da za dra punbabi ya ja̱ꞌi, ");
INSERT INTO oteNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pe nuꞌa̱ tóꞌo da ña̱maꞌñʉ de núꞌa̱ øtꞌa ra Ma̱ca Nda̱hi, otho rá pumbate, ne da duxa rá tsꞌoqui pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bi ma̱ njabʉ ngueꞌa̱ ya xahnate de ra ley ya mi ña̱maꞌñʉ de rá ꞌbɛfi ra Ma̱ca Nda̱hi, ngueꞌa̱ xqui ma̱ñꞌʉ gue ra Jesu mi pɛꞌtsa ꞌnara tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ne ꞌmɛfa bi zøhø rá na̱na̱ ra Jesu co yá høcu, bi ꞌmaiꞌʉ møte ne bi mɛhni to da tsiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ne ndunthi ya ja̱ꞌi xqui muntsꞌi ja ra ngu ne mi huhni ja rá nthetsꞌi ra Jesu. Nepʉ ra ꞌmɛhni bi xipabi ne bi ꞌñembi: ―ꞌBahni ri na̱na̱ ne ri cu møte bí tøpꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ha nuꞌá̱ bi da̱di: ―¿Toꞌo ma na̱na̱ga, ne toꞌo ma cuga? ");
INSERT INTO oteNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nuꞌbʉ́ bi nhyani ne bi hyanda gatho núꞌʉ mi huhni ja rá nthetsꞌi ne bi ꞌñena: ―Nuyʉ go guehyʉ ma na̱na̱ ne ma cu. ");
INSERT INTO oteNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngueꞌa̱ nuꞌʉ tóꞌo da ꞌyøꞌtua rá paha Ajua̱, go gueꞌʉ ma cu, ma nju ne ma na̱na̱. ");
INSERT INTO oteNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ra Jesu bi yopa mʉdi da xahna ya ja̱ꞌi ja ra ña̱nga ndehe, ne ja bi thetsꞌini ndunthi ya ja̱ꞌi, hangue nuꞌa̱ bi ꞌyøtꞌe, bi bøtsꞌe bi hñudi ja ꞌnara motsa mbo ja ra dehe, ne gatho ra hmuntsja̱ꞌi bi gohi ja ra ña̱nga ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ne mi utua ya ja̱ꞌi ndunthi ya tꞌøtꞌe co ya ꞌbede, ne bi ꞌñembabiꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―ꞌYødehʉ núna ma ga xiꞌahʉ de ꞌnara motꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","De nu mi xanga ya nda, ꞌra bi zo ja ra ꞌñu y ya tsꞌintsꞌʉ bi ꞌñehe bi gondi. ");
INSERT INTO oteNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Maꞌra ya nda bi zo ja ra ꞌbodo habʉ xmá nxini ra hai hangue bi da̱ma føtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pe nu mi nzø ra hyadi bi huixqui ne bi ꞌyotꞌiꞌʉ ngueꞌa̱ mi otho ndunthi yá ꞌyʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Maꞌra ya nda bi zo ja ya ꞌboꞌbini, y ya ꞌbini bi da̱ma nte ne bi xumi núꞌʉ ya nda xqui føtsꞌe, hangue bi ꞌyotꞌi ne himbi hogui. ");
INSERT INTO oteNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pe nu maꞌra ya nda bi zo ja ra hoga hai, bi føtsꞌe ne bi nte, ne bi unga yá sofo, ꞌra bi unga ꞌnatemaꞌrɛtꞌa ya nda, maꞌra bi unga hñuꞌrate, ha nu maꞌra asta bi unga ꞌna nthebe ya nda. ");
INSERT INTO oteNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nuꞌbʉ́ ra Jesu bi ꞌñembiꞌʉ: ―Nuꞌa̱ tóꞌo ja rá ntꞌøde pa da ꞌyøde, dá ꞌyøde núna dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Y nu de ya xqui ma ra hmuntsja̱ꞌi, nuꞌbʉ́ núꞌʉ ꞌrɛtꞌamayoho yá nxadi ne núꞌʉ maꞌra xqui gohi, bi ꞌyambabiꞌʉ ra Jesu bi ꞌñembi: ―¿Te ne da ma̱ núꞌa̱ ra ꞌbede gá xicje? ");
INSERT INTO oteNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y nuꞌá̱ bi ꞌñembiꞌʉ: ―Go rá paha Ajua̱ gui pa̱hʉ núꞌa̱ himi fa̱di mayaꞌbʉ de hanja ri manda Ajua̱, pe nuꞌʉ maꞌra ya ja̱ꞌi núꞌʉ hingui dɛna Ajua̱ ma da ꞌyøde co ya ꞌbedetho. ");
INSERT INTO oteNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ma da nja ngu ma̱nga ra Ma̱ca Tꞌofo, gue masque da hyandiꞌʉ, pe hinda zo yá mfeni, masque xi da ꞌyøde, pe hinda ba̱diꞌʉ, hangue hinda ma da ñobri pa hindra pumbabi yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nehe bi ꞌñembabiꞌʉ: ―¿Ha gue himbi zo ri mfenihʉ nuna ra ꞌbede de ra motꞌi? Nuꞌbʉ́ ¿hanja da za gui pa̱hʉ maꞌra ya ꞌbede núꞌʉ ma ga xiꞌahʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nuꞌa̱ ra motꞌi go gueꞌa̱ toꞌo ma̱nga ra ma̱ca noya. ");
INSERT INTO oteNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Y nuꞌʉ ya nda bi zo ja ra ꞌñu go gueꞌʉ toꞌo bi ꞌyøde ra ma̱ca noya, y ra Satá ꞌbestho bi ꞌñehe bi patua yá mfeni pa da pumfri núꞌa̱ ra ma̱ca noya xqui sipabi. ");
INSERT INTO oteNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ha nuꞌʉ ya nda bi zo ja ra ꞌbodo go gueꞌʉ toꞌo bi ꞌyøde ra ma̱ca noya y ꞌbestho bi da̱ma gamfri y ne xi bi johya. ");
INSERT INTO oteNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pe ngu núꞌʉ bi ꞌñotho yá ꞌyʉ, go gueꞌʉ toꞌo camfri ꞌraya zi patho, ne sta tho ya ntꞌʉtsate o ya tsꞌothogui po rá ngue ra ma̱ca noya, nuꞌbʉ́ ꞌbestho da ꞌuegueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ha nuꞌʉ ya nda bi zo ja ya ꞌboꞌbini go gueꞌʉ toꞌo bi ꞌyøde ra ma̱ca noya, ");
INSERT INTO oteNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pe nuꞌʉ́ ri ho ndunthi ya tsꞌojohya de ra ximhai, ne beni hanja da za da mɛꞌtsa ndunthi ya tꞌøtꞌe ne da da̱ha̱ ndunthi ra boja̱. Hangue nuya ya tsꞌoncꞌatꞌi hingui hopi da te yá jamfri, ne núꞌa̱ bi ꞌyøde da ꞌmɛditho. ");
INSERT INTO oteNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ha nuꞌʉ ya nda bi zo ja ra hoga hai bi unga yá sofo, ꞌra bi unga ꞌnatemaꞌrɛtꞌa ya nda, ne maꞌra bi unga hñuꞌrate, ha nu maꞌra ꞌna nthebe, nuꞌʉ́ go gueꞌʉ toꞌo bi gamfri ra ma̱ca noya ne xi bi hnequi yá hoga ꞌbɛfi. ");
INSERT INTO oteNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ra Jesu bi yopa zofo ra hmuntsja̱ꞌi ne bi ꞌñembabi: ―Hinto da tsøgue ꞌnara ñotꞌi ne da yeꞌmba ꞌnara ꞌbøtsꞌe o da ja njaꞌti de ra fidi. Hina, dra tøte habʉ da nøgue pa da yotꞌi xá hño. ");
INSERT INTO oteNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Njabʉ nehe núꞌa̱ ja mantꞌa̱guibya, ꞌmɛfa ma da hnequi, ne núꞌa̱ hingui tsa da fa̱dibya, ꞌmɛfa ma da fa̱di. ");
INSERT INTO oteNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nuꞌa̱ tóꞌo ja rá ntꞌøde pa da ꞌyøde, dá ꞌyøde núna dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nehe bi ꞌñembiꞌʉ: ―Ngu tꞌena, co nura tꞌɛni guí ɛñhʉ, con guetꞌatho ma da tꞌɛñꞌahʉ, y asta maꞌna da thuꞌtsꞌaꞌihʉ ri tꞌɛnihʉ. Hangue dí xiꞌahʉ, jamasuhʉ hanja gui ꞌyødehʉ núꞌa̱ dí ma̱, ngueꞌa̱ nuꞌbʉ gui jamasuhʉ, ma da zo ri mfenihʉ, pe nuꞌbʉ hingui jamasuhʉ, hinda za gui pa̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ngueꞌa̱ nuꞌa̱ tóꞌo da ba̱di núꞌa̱ dí ma̱, maꞌna da tꞌumbabi ra mfa̱di, pe nuꞌa̱ tóꞌo hinxa ba̱di, núꞌá̱ ma da tha̱cuabi núꞌa̱ ra mfa̱di pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nehe bi xipabiꞌʉ: ―Rá hmanda Ajua̱ nja ngu ꞌnara ꞌñøhø potꞌa ya nda. ");
INSERT INTO oteNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Y núꞌa̱ ra motꞌandaꞌa̱ a̱ha̱ dega xuui ne nangui dega xudi bí cꞌa̱ꞌtsa rá ꞌbotꞌi. Ne núꞌa̱ ra ꞌbotꞌiꞌa̱ da føtsꞌe ne da nte, pe núꞌa̱ ra ꞌñøhø hingui pa̱di hanja xa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ra hai øtꞌe pa da føtsꞌe, da nte, da hneca rá ꞌbai, ne ꞌmɛfa da bø yá da̱xi. ");
INSERT INTO oteNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ne ya sta ña̱tsꞌi, ꞌbestho nura motꞌiꞌa̱ da ma da xofo ngueꞌa̱ ya bi zø ra pa dega sofo. ");
INSERT INTO oteNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nepʉ ra Jesu bi ꞌñena: ―Ma ga xiꞌahʉ maꞌna ra ꞌbede ri nhyɛcuaui rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Rá hmanda Ajua̱ nja ngu ꞌnara nda dega mostasa, núꞌá̱ maꞌna go ra zi notsi de gatho maꞌra ya nda. ");
INSERT INTO oteNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pe nu sta ꞌbotꞌa núꞌa̱ ra nda, maꞌna da nte ne da ntʉngui que gatho maꞌra ya nda̱po, ne da nja yá da̱nga ꞌyɛza asta ya tsꞌintsꞌʉ da za da nøhni. ");
INSERT INTO oteNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ra Jesu mi xipabiꞌʉ ra ma̱ca noya co ndunthi ya ꞌbede asta habʉ bi za bi zo yá mfeniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mi zofo ya hmuntsja̱ꞌi co ya ꞌbedetho núꞌʉ ri nhyɛcuaui rá hmanda Ajua̱, pe nuꞌbʉ mi ꞌbʉsɛui yá nxadi mi xipabiꞌʉ te rí bøni núꞌʉ ya ꞌbede xqui xipabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Y nu mi putꞌa ra nde ra paꞌa̱, ra Jesu bi ꞌñembabi yá nxadi: ―Ma ga ꞌraxhʉ riꞌnandi ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hangue bi ꞌñediꞌa̱ de ra hmuntsja̱ꞌi, ne nuꞌá̱ ne yá nxadi bi gʉ ra motsa habʉ mi oꞌa̱ pa da ꞌraxꞌʉ riꞌnandi, ne maꞌra ya ja̱ꞌi bi dɛniꞌʉ co ya tꞌʉca motsa. ");
INSERT INTO oteNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y ya de mi ꞌyoꞌʉ ja ra ndehe, bi mʉ ꞌnara da̱nga bʉnthi ne mi tontsꞌa ra dehe ja ra motsa asta mi ne xa ñuxhma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ha ra Jesu mi a̱ha̱ ja ra tsꞌa̱tꞌa motsa ne xqui ꞌyɛntsꞌa rá ña̱xu ja ꞌnara nthuhña̱, ne yá nxadi bi ma bá a, ne bi ꞌñembabi: ―¡Xahnate! ꞌMatho hinguí tu ri mʉi gue ma ga cʉihʉ ja ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nuꞌbʉ́ ra Jesu bi nangui ne bi zʉi ra bʉnthi, ne bi ꞌñemba ra ndehe: ―¡ꞌBʉtho! Y ꞌbestho bi tsaya ra bʉnthi ne ya himbi ꞌña̱ni ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―¿Hanja guí tsuhʉ? ¿Ha gue otho ri jamfrihʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nuꞌbʉ́ nuyá nxadiꞌa̱ bi ꞌyøꞌʉ, ne mi ꞌñémsɛꞌʉ ꞌna ngu maꞌna: ―¿Te ma tsꞌɛdi ha̱ni ꞌbʉ? ngueꞌa̱ asta ra nda̱hi ne ra ndehe øtuabi. ");
INSERT INTO oteNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nepʉ ra Jesu ne yá nxadi bi zøni ja ra hai Gadara de riꞌnandi ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y ra Jesu bi ga̱i de ra motsa, y ꞌbestho bi nthɛui ꞌnara ꞌñøhø xqui ꞌñehe de habʉ ja ya ntꞌagui ne mi pɛꞌtsa ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nura ꞌñøhøꞌa̱ ya xi ja mi ꞌbʉhni ja ya ntꞌagui, ne hinto mi tsa da za̱mi masque dra tha̱tꞌi co ya cadena. ");
INSERT INTO oteNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ndunthi ya ꞌmiꞌqui xcrí tha̱tꞌi co ya cadena ja yá ꞌyɛ ne ja yá ua, pe nuꞌá̱ mi cꞌʉctho ne mi øtꞌe ya xɛnitho, ne hinto mi ja rá tsꞌɛdi pa da za̱mi. ");
INSERT INTO oteNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma pa ra xuui mi ꞌyo ja ya tꞌøhø ne ja ya ntꞌagui ne nza̱ntho mi mafi ne mi ntsɛni sɛhɛ co ya do. ");
INSERT INTO oteNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pe núꞌa̱ ra ꞌñøhø mi hyanda ra Jesu de yabʉ, bi nestꞌihi bi ma bá tsʉdi ne bi ndandiña̱hmu. ");
INSERT INTO oteNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nepʉ bi mafi ntsꞌɛdi ne bi ꞌñena: ―Nuꞌi Jesu, rá Tꞌʉꞌi Ajua̱ de mahetsꞌi, ¿te ꞌbɛ guí ne con guecje? Dí ba̱nteꞌihe ja rá thuhu Ajua̱ gue ote xqui ma gui ꞌyøtcahe. ");
INSERT INTO oteNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bi ma̱ njabʉ ngueꞌa̱ ra Jesu ya xqui ꞌñembabi: ―¡Nuꞌahʉ tsꞌonda̱hihʉ, pøñhʉ de nuna ra ꞌñøhø! ");
INSERT INTO oteNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nepʉ ra Jesu bi ꞌyambi: ―¿Te rá huꞌahʉ? Y nuꞌʉ́ bi da̱di bi ꞌñena: ―Xa thuꞌmgahe ya ꞌmotho ngueꞌa̱ xi dí ndunthihe. ");
INSERT INTO oteNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nepʉ nuya tsꞌonda̱hiꞌʉ xi bi ba̱ntebi ra Jesu gue hinda ꞌyɛni de ra hai Gadara. ");
INSERT INTO oteNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ne guetbʉ ja ra tꞌøhø mi ꞌyoni ꞌnara da̱nga taxo ya tsꞌʉdi mi ñuni. ");
INSERT INTO oteNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hangue núꞌʉ ya tsꞌonda̱hi bi ba̱ntebi ra Jesu ne bi ꞌñembi: ―ꞌRacje nsɛqui ga ma ga cʉtheni ja ya tsꞌʉdi. ");
INSERT INTO oteNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nuꞌbʉ́ ra Jesu bi umba nsɛqui bi maꞌʉ pa bi yʉtꞌa ja ya taxo tsꞌʉdi. Y nuya taxo tsꞌʉdiꞌʉ bi nestꞌihi bi nhyøtꞌa ja ra ndehe ne bi ja̱tꞌiꞌʉ. Ne núꞌa̱ ra taxo mi ngu yo ꞌmo. ");
INSERT INTO oteNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nuꞌbʉ́ núꞌʉ ya maptsꞌʉdi bi nestꞌihi bi maꞌʉ pa mbo ra hnini ne gatho rá nthetsꞌi pa mi xipa ya ja̱ꞌi de núꞌa̱ te xqui nja. Nepʉ ndunthi ya ja̱ꞌi bi ꞌñehe pa da hyandi te xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Núꞌʉ́ bi zøhø habʉ mi ꞌbʉi ra Jesu ne mi ꞌbʉhni nehe núꞌa̱ ra ꞌñøhø toꞌo mi pɛꞌtshma̱ ya tsꞌonda̱hi, ne bi hyandiꞌʉ mi huhni, ya mi he rá dutu ne ya mi ja rá mfeni. Nuꞌbʉ́ xi bi ꞌyøꞌʉ ngueꞌa̱ nuꞌʉ́ mi pa̱di gue nura ꞌñøhøꞌa̱ xi mi pɛꞌtsa ndunthi ya tsꞌonda̱hi hma̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nepʉ nuya ja̱ꞌi toꞌo xqui hyandi te bi tho ya tsꞌʉdi ne ra ꞌñøhø toꞌo mi pɛꞌtsa ya tsꞌonda̱hi, bi metuabi maꞌra, ne xi bi ꞌño ra ꞌbede. ");
INSERT INTO oteNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hangue ya me Gadara bi mʉdi bi ba̱ntebi ra Jesu gue da bøni de guehni. ");
INSERT INTO oteNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Y nu mi yopa bøxa ra Jesu ja ra motsa, ra ꞌñøhø núꞌa̱ toꞌo mi pɛꞌtsa ya tsꞌonda̱hi bi ba̱ntebiꞌa̱ gue da hopi da mɛui. ");
INSERT INTO oteNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pe ra Jesu himbi hopi, bi ꞌñembi: ―Grí ma ri ngu ne bá xipa gatho ri ja̱ꞌi de gatho núꞌʉ ya tꞌøtꞌe xa ꞌyøꞌtꞌaꞌi Ajua̱ ngueꞌa̱ bi huecꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hangue bi ma núꞌa̱ ra ꞌñøhø nuni ja ra hai Decápoli ne ja bi ꞌmʉhni bi xipa ya ja̱ꞌi de núꞌa̱ te xqui ꞌyøꞌtuabi ra Jesu, ne gatho toꞌo bi ꞌyøde xi bi ꞌyøꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ra Jesu ne yá nxadi bi yopa ꞌraxa maꞌnaꞌqui pa riꞌnandi ra ndehe, ne ja bi mani ꞌnara hmuntsja̱ꞌi pa bá tsʉdiꞌa̱ ja ra ña̱nga ndehe habʉ bi zøhø. ");
INSERT INTO oteNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nehe bi zønini ꞌnara ꞌñøhø mrá thuhu ra Jairo y mi gueꞌa̱ ꞌna de nuya nda̱ de ja yá nija̱ꞌʉ. Y nu mi hyanda ra Jesu bi ndandiña̱hmu ja yá uaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nepʉ bi ba̱ntebi bi ꞌñembi: ―Ma zi tꞌixu ya ma da du. Maha pa gui hñuꞌtsua ri ꞌyɛ pa nuꞌá̱ da ña̱ni y hinda du. ");
INSERT INTO oteNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hangue ra Jesu bi mɛuiꞌa̱, ne ꞌnara da̱nga hmuntsꞌi bi dɛni ne xi xmá ntsꞌiꞌmi. ");
INSERT INTO oteNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nehe mi pani ꞌnara ꞌbɛhña̱ mi xoꞌtua ya ji, ya mi pɛꞌtsa ꞌrɛtꞌamayoho njɛya mi tsʉ nura hñeniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Xqui degue gatho rá boja̱ ja ya medico y ni tsꞌʉ hinxqui zamahño, maꞌna mi ꞌyo mri zaꞌyɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Núꞌa̱ ra ꞌbɛhña̱ꞌa̱ xqui ꞌyøde núꞌa̱ mi øtꞌa ra Jesu, hangue bi dɛni ja ra hmuntsja̱ꞌi, bi joni ne bi dambabi rá he. ");
INSERT INTO oteNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ngueꞌa̱ mi bensɛꞌa̱ gue masque hønsɛ rá he da dambabi, nuꞌá̱ da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y nu mi dambabi rá he, ꞌbestho bi tsaya ra ji, ne bi za gue ya xqui ña̱ni de rá hñeni. ");
INSERT INTO oteNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Y ra Jesu ꞌbestho bi ba̱tho gue co rá tsꞌɛdi xqui ña̱nga ꞌnara daꞌthi, hangue bi ñegui ne bi ꞌñena: ―¿Toꞌo xa dangagui ma he? ");
INSERT INTO oteNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pe yá nxadi bi ꞌñembabi: ―Guí handi gue ra hmuntsja̱ꞌi ri tsꞌipꞌaꞌi ne guí ena gue to xa dañꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nuꞌbʉ́ ra Jesu bi nhyani ja gatho ra hmuntsja̱ꞌi pa da ba̱di toꞌo xqui dambabi rá he. ");
INSERT INTO oteNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Y nura ꞌbɛhña̱ꞌa̱ ya mi pa̱di te xqui nja, hangue bi joni co ndunthi ra ntsu ne mi hua̱tꞌiꞌa̱, nepʉ bi ndandiña̱hmu ja yá ua ra Jesu ne bi xipabi te xqui jaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nepʉ ra Jesu bi ꞌñembi: ―Ma zi tꞌixuꞌi, ya guí ꞌbʉi xá hño ngueꞌa̱ xi xcá camfrigui. Grí ma te rá ꞌñentho ne ya hinda ma da yopa menga ri hñeni. ");
INSERT INTO oteNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y de mi ña̱ui ra Jesu nura ꞌbɛhña̱, bi zøhø ꞌnara ꞌmɛhni xqui ꞌñehe de rá ngu núꞌa̱ ra nda̱ de ra nija̱, ne bi ꞌñembi: ―Ya bi du ri tꞌixu. ¿Pa te gui xuhña ra xahnate gui tsixa ja ri ngubya? ");
INSERT INTO oteNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pe ra Jesu ngu mi ꞌyøde núꞌʉ ya noya bi ma̱nga ra ꞌmɛhni, bi ꞌñemba ra Jairo: ―Odi tu ri mʉi, hønsɛ xi da camfrigui. ");
INSERT INTO oteNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nepʉ bi zixa ra Pedro, ra Cobo ne ra Xuua rá cu ra Cobo, ne himbi hopa maꞌra ya ja̱ꞌi da dɛni. ");
INSERT INTO oteNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y nu mi zøniꞌʉ ja rá ngu núꞌa̱ ra nda̱, bi hyandi mi ꞌbʉhni ndunthi ya ja̱ꞌi mi mantho ne xi mi zoñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nuꞌbʉ́ ra Jesu bi yʉtꞌa ja ra ngu ne bi ꞌñemba ya ja̱ꞌi: ―¿Hanja guí zoñhʉ ne guí manthohʉ? Nura nxutsi a̱ha̱tho, hingue xa du. ");
INSERT INTO oteNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pe ya ja̱ꞌi bi dentho. Nuꞌbʉ́ ra Jesu bi ꞌbɛpa gatho ya ja̱ꞌi da bøni de ra ngu, nepʉ bi zixa rá na̱na̱ ne rá dada ra nxutsi, ne co núꞌʉ mi ꞌñoui bi yʉtꞌa habʉ mi ꞌbɛni. ");
INSERT INTO oteNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Y bi mipa rá ꞌyɛ, ne bi ꞌñembi: ―Talitha, cumi. ―Nura noyaꞌa̱ ne da ꞌñena: Ma zi tꞌixuꞌi, dí xiꞌaꞌi gui nangui. ");
INSERT INTO oteNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nepʉ ꞌbestho bi nangui ne bi ꞌño. Hangue ya ja̱ꞌi xi bi ꞌyø ntsꞌɛdi. Y núꞌa̱ ra nxutsiꞌa̱ mi pɛꞌtsa ꞌrɛtꞌamayoho njɛya. ");
INSERT INTO oteNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pe ra Jesu bi hñuꞌmba ra hña̱ gatho núꞌʉ mi ꞌbʉhni gue ni ꞌna hinto da xipi de núꞌa̱ xqui ꞌyøtꞌa̱. Nepʉ bi manda gue da tꞌumba te da zi núꞌa̱ ra nxutsi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ra Jesu bi bøni de guehni bi ma ja rá hai, bi mɛui yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ne ja ra pa dega tsaya bi yʉtꞌa ja ra nija̱ pa bi nxahnate, ne ndunthi núꞌʉ toꞌo mi øde, mi ꞌyø ne mi ena: ―¿Habʉ xa ba̱di núꞌa̱ ma̱ni? ¿Toꞌo xa umbabi ra da̱nga mfa̱di? ¿Habʉ xpá hña̱ núꞌa̱ ra tsꞌɛdi pa da ꞌyøtꞌa núꞌʉ ya da̱nga ntꞌudi øtꞌe? ");
INSERT INTO oteNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nuni go guehni ra yaxi, nurá tꞌʉ ra Maria, ne go yá cu ra Cobo, ra Jose, ra Juda ne ra Simu, ne yá nju ꞌbʉcua con guecjʉ. Ne nuꞌʉ́ mri ꞌyøtho, himbi gamfri. ");
INSERT INTO oteNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hangue ra Jesu bi ꞌñembabiꞌʉ: ―ꞌNará ꞌmɛhni Ajua̱ da tꞌumba ra tꞌequꞌei habʉ hingo rá hai, ha nu go rá hai hinto umba ra tꞌequꞌei, nixi ya mengu rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ra Jesu himbi za bi ꞌyøtꞌa ndunthi ya ntꞌudi ja rá hai ngueꞌa̱ hinto mi ne da gamfri. Hønsɛ bi hñuxa yá ꞌyɛ ja tsꞌʉtho ya daꞌthi pa bi ña̱niꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y nuꞌá̱ bi ꞌyø ngueꞌa̱ ni ꞌna tʉqui himbi ne bi gamfri nuya ja̱ꞌi, ne bi bøni de guehni bi ma ja maꞌra ya tꞌʉca hnini pa da xahna ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ꞌMɛfa ra Jesu bi zohna núꞌʉ ꞌrɛtꞌamayoho yá nxadi ne bi umba ra tsꞌɛdi pa da ꞌyɛmba ya tsꞌonda̱hi toꞌo di pɛꞌtsi. Nepʉ bi mɛhniꞌʉ dega yoho. ");
INSERT INTO oteNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne bi xipabiꞌʉ gue hinte da hña̱tsꞌi pa ja ra ꞌñu, nixi yá ꞌrøza̱, nixi núꞌa̱ te da zi, ni ra boja̱, hønsɛ yá bordo ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nehe bi xipi gue da diꞌta yá thiza ne da hña̱xa ꞌnada ra patꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nehe bi ꞌñembabi: ―Nu xcrí tsøñhʉ ja ꞌnara ngu, ja gui ꞌbʉthʉni asta hingui pøñhʉ de núꞌa̱ ra hniniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y nuꞌbʉ gui tsøñhʉ ja ꞌnara hnini ne hinto da ꞌraꞌahʉ ntsaya nixi da ꞌyøde núꞌa̱ gui ma̱ñhʉ, nuꞌbʉ́ pøñhʉ de guehni. Y de xcrí pøñhʉ, gui hua̱tꞌa ri thizahʉ pa hingui hña̱xhʉ nixi ra hai de nura hniniꞌa̱, y njabʉ da ba̱diꞌʉ de núꞌa̱ xa ꞌyøtꞌʉ. Majua̱ni dí xiꞌahʉ gue nu sta zø ra pa da nja ra nsʉca uɛnda, nura paꞌa̱ ya mengu de guehni maꞌna ma da ncastiga que ya mengu de ra tsꞌohnini Sodoma ne Gomorra. ");
INSERT INTO oteNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mi uadi bi ma̱nga ra Jesu njabʉ, yá nxadi bi ma de guehni pa da zo ya ja̱ꞌi pa da ñobriꞌʉ de yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ne mi ɛni ndunthi ya tsꞌonda̱hi, ne mi coꞌtsua ra aceite ya daꞌthi ne mi ña̱niꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ha nuya paꞌʉ habʉraza xi xqui ntꞌøde de núꞌʉ ya da̱nga tꞌøtꞌe mi øtꞌa ra Jesu, asta ra nda̱ Erode bi zo rá gu nehe. Hangue bi ꞌñena: ―Go gueꞌa̱ ra Xuua Xiꞌtsate ya xa yopa nte de ra du, hangue nubyá maꞌna ja rá tsꞌɛdi pa da za da ꞌyøtꞌa nuya da̱nga ntꞌudi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Maꞌra ya ja̱ꞌi mi ena: ―Go gueꞌa̱ ra ba̱di Elía. Y nu maꞌra mi ena: ―Go gueꞌa̱ ꞌnará ꞌmɛhni Ajua̱ ngu núꞌʉ mi ꞌbʉi mayaꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ha nu mi ꞌyøde ra nda̱ Erode njabʉ, bi ꞌñena: ―Gueꞌa̱ ra Xuua núꞌa̱ dá tacua rá ña̱xu ne ya xa yopa nte maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bi beni njabʉ ngueꞌa̱ xqui mɛhni to bi gʉ ra Xuua pa bi gotꞌa fadi, ngueꞌa̱ xqui hña̱cuabi hma̱ha̱ gue hinda ꞌyøtꞌe drá ꞌbɛhña̱ ra Erodía, ngueꞌa̱ ra Erodía mrá ꞌbɛhña̱ ra Lipe núꞌa̱ toꞌo mrá cu ra Erode. ");
INSERT INTO oteNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ra Xuua xqui hña̱cuahma̱ ra Erode ne xqui ꞌñembi: ―Hingui ho gui tsimba rá ꞌbɛhña̱ ri cu. ");
INSERT INTO oteNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hangue ra Erodía xi bi ʉtsa ra Xuua ne mi ne to da gatsꞌi pa da hyo, pe himi tsa, ");
INSERT INTO oteNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ngueꞌa̱ ra Erode mi su ra Xuua pa hinte da tꞌøꞌtuabi, ngueꞌa̱ mi pa̱di gue mrá hoja̱ꞌi ne xmá ntꞌaxi rá mfeni hangue mi pɛꞌtsua ra tꞌequꞌei. Ne mi ho da ꞌyøde núꞌa̱ mi ma̱, pe himi tso rá mfeni núꞌa̱ mi øde hangue himi pa̱di te da beni. ");
INSERT INTO oteNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pe bi zø ra pa bi nja ngu núꞌa̱ mi ne ra Erodía. Nu mi da rá pa ra Erode bi ꞌyøtꞌa ꞌnara ngo ne bi ꞌñehe gatho yá mfatsꞌi ne ya nzaya ne ya tꞌʉca nda̱ toꞌo mi manda ra hai Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nuni ja ra ngo bi yʉtꞌa rá tꞌixu ra Erodía ne bi nei ja yá thandiꞌʉ. Ha ra nda̱ Erode ne núꞌʉ toꞌo mi huhui ja ra mexa bi hopa rá hnei. Hangue ra Erode bi ꞌñemba ra nxutsi: ―ꞌYacagui gatho núꞌa̱ gui ne y ga ꞌraꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne bi jurabi ne bi ña̱ꞌtuabi da umbi asta made de habʉ gatho mri manda ꞌbʉ da ꞌyadi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nepʉ bi bønga ra nxutsi ne bá amba ra Erodía nurá na̱na̱ꞌa̱ ne bi ꞌñembi: ―¿Te ga adi ꞌbʉ? Y rá na̱na̱ bi ꞌñembi: ―Xipi da ꞌraꞌi rá ña̱xu ra Xuua Xiꞌtsate. ");
INSERT INTO oteNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nuꞌbʉ́ nuꞌá̱ bi da̱ma mengui ja ra nda̱ ne bi ꞌñembi: ―Dí ne gui ꞌracagui nubya ꞌbestho rá ña̱xu ra Xuua Xiꞌtsate ja ꞌnara manza. ");
INSERT INTO oteNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nuꞌbʉ́ ra nda̱ bi du rá mʉi ntsꞌɛdi. Pe ya xqui jurabi núꞌa̱ ra nxutsi ne xqui ꞌyøde gatho toꞌo mi huhuini ja ra mexa, hangue mi pɛꞌtsi te da ꞌyøtꞌe núꞌa̱ xqui ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hangue bi da̱ma mɛhna ꞌnara soldado pa da hña̱mpa rá ña̱xu ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nepʉ núꞌa̱ ra soldado bi ma ja ra fadi bá tacua rá ña̱xu ra Xuua, ne bi ꞌyɛntsꞌa ja ꞌnara manza pa bá ha̱mpa ra nxutsi, nepʉ ra nxutsi bi hña̱ꞌtsua rá na̱na̱. ");
INSERT INTO oteNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Y nu mi ꞌyøde yá nxadi ra Xuua bi ma ja ra fadi pa bi duꞌtsua rá ndoꞌyo pa bá aguiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Núꞌʉ ꞌrɛtꞌamayoho yá nxadi ra Jesu xqui mɛhni da ma da zofo ya ja̱ꞌi, ꞌmɛfa bá pengui de habʉ xqui ma, ne bi muntsꞌiꞌʉ habʉ mi ꞌbʉi ra Jesu, ne bi xipi gatho te xqui ꞌyøtꞌeꞌʉ ne núꞌa̱ xqui ꞌñudiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nuꞌbʉ́ ra Jesu bi xipabiꞌʉ: ―Maha ga ꞌueguehʉ ꞌnambʉ sɛhɛ pa ga ntsayahʉ. Mi ma̱nga njabʉ ngueꞌa̱ ndunthi ya ja̱ꞌi mi pa y mi tsøhø habʉ mi ꞌbʉiꞌʉ ne mi otho ra pongui pa da ntsaya nixi pa da ñuni. ");
INSERT INTO oteNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hangue bi maꞌʉ co ꞌnara motsa pa bi ꞌrani riꞌnandi habʉ hinto mi ꞌbʉi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pe ndunthi ya ja̱ꞌi bi hyandi mi maꞌʉ ne bi hyandathoꞌʉ ra Jesu habʉ rí zøni, hangue nuꞌʉ́ ne ndunthi de núꞌʉ mi ꞌbʉ ja ya tꞌʉhnini bi nestꞌihi bá gatꞌi ja rá hyo ra ndehe ne go rá mʉdi bi zøñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Y nu mi zønga ra motsa ja ra ña̱nga ndehe, bi ga̱i ra Jesu ne bi hyanda núꞌa̱ ra hmuntsja̱ꞌi xqui zønini, ne xi bi huequiꞌʉ ngueꞌa̱ mi ngu ya dɛti joꞌo yá maꞌyo, hangue nuꞌá̱ bi mʉdi bi xahniꞌʉ ndunthi ya tꞌøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ha nu de ya mi nde, ya nxadi bi joni habʉ mi ꞌbai ra Jesu ne bi ꞌñembabi: ―Ya bi nde ne nuua habʉ dí ꞌbʉhʉ go ra mbonthi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xipa ya ja̱ꞌi da ma da dai te da zi ja ya ngu ne ja ya hnini núꞌʉ ja guetbʉ de guecua, ngueꞌa̱ otho te da ziuayʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pe ra Jesu bi da̱di: ―Go da umfʉ te da ziyʉ. Nuꞌbʉ́ ya nxadi bi ꞌñembi: ―¿Ha gue ga mahe ga tañhe yo nthebe denario dega thuhme pa ga ꞌuiñheyʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pe ra Jesu bi ꞌyambabiꞌʉ ne bi ꞌñembi: ―¿Hangu ya thuhme guí ha̱hʉ? Nuhʉ xa̱. Y nu mi hyandiꞌʉ bi ꞌñembabi: ―Nsøcta cʉtꞌa ya thuhme ne yoho ya zi hua̱ dí ha̱he. ");
INSERT INTO oteNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nuꞌbʉ́ ra Jesu bi xipa ya ja̱ꞌi da ꞌyøtꞌa ya tꞌʉca hmuntsꞌi ne da hñudiꞌʉ ja ra ꞌbotꞌɛi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hangue bi ꞌyøtꞌa ya tꞌʉca hmuntsꞌi dega nthebe ne dega ndenthebe, ne bi hñudiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nuꞌbʉ́ ra Jesu bi gʉ núꞌʉ cʉtꞌa ya thuhme ne núꞌʉ yoho ya hua̱, ne bi nøtsꞌe mahetsꞌi ne bi umba njama̱di Ajua̱ rá Dada. Nepʉ bi hyeca ya thuhme ne bi hyecua yá nxadi pa da umba ya ja̱ꞌi, ne bi xɛni núꞌʉ yoho ya hua̱ pa bi thecua gatho núꞌʉ ya hmuntsja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Y gatho bi ñuni asta bi niña̱ꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nepʉ bi hmuntsꞌa gatho ya xɛca thuhme ne ya xɛca hua̱ núꞌʉ bi bongui, ne bi ñuxa ꞌrɛtꞌamayoho ya ꞌbøtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ha mi ngu cʉtꞌa ꞌmo ya ꞌñøhø núꞌʉ bi ñuni, y nuya ꞌbɛhña̱ ne ya ba̱tsi himbi ma ꞌmede. ");
INSERT INTO oteNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nepʉ ra Jesu bi xipa yá nxadi gue da ꞌmɛtꞌoꞌʉ co ra motsa pa riꞌnandi pa rí mani ja ra hnini Betsaida, y nuꞌá̱ bi gohini mi edi ya ja̱ꞌi pa da ma ja yá ngu. ");
INSERT INTO oteNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y mi uadi bi ꞌñediꞌa̱, bi bøxa ja ra tꞌøhø pa bá apabi Ajua̱ rá Dada. ");
INSERT INTO oteNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Y ya mi ꞌmɛxuui ra paꞌa̱ ra motsa ya mi ꞌyo madetho ra ndehe, ha nura Jesu mi ꞌbʉtritho ja ra tꞌøhø sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y bi hyanda yá nxadi gue ya xqui zabiꞌʉ de mi ꞌyonga ra motsa ngueꞌa̱ mi tsɛdi ra bʉnthi ne himi hopi da ꞌño. Y nurá hyaxꞌa̱ hamxuditho ra Jesu bi ma pa riꞌnandi mi ꞌyotho maña̱ ja ra dehe, ne mi ma da thoꞌtshma̱ yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pe yá nxadi bi hyandi mi ꞌyo maña̱ ja ra dehe ne xi bi mafiꞌʉ ngueꞌa̱ mi hu yá mʉi gue mi ꞌnara pite. ");
INSERT INTO oteNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ri gathoꞌʉ bi hyandi ne xi mi tsuꞌʉ. Pe ra Jesu ꞌbestho bi zofo ne bi ꞌñembiꞌʉ: ―¡Oguí tsuhʉ, go gueque, oguí tu ri mʉihʉ! ");
INSERT INTO oteNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nepʉ bi bøxa ja ra motsa con gueꞌʉ ne ꞌbestho bi ntsaya ra bʉnthi, hangue yá nxadi xi bi ꞌyø ntsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Himi pa̱diꞌʉ te ma tsꞌɛdi mi ha̱, nixi xqui zoda yá mfeni hanja xqui japi da xu ya thuhme, ngueꞌa̱ xmá me yá corasoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nu mi ꞌratsꞌiꞌʉ pa riꞌnandi bi zøni ja ra hai Genesare ne ja bi da̱tꞌni yá motsa. ");
INSERT INTO oteNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y ngu bi ga̱iꞌʉ de ra motsa, ya ja̱ꞌi ꞌbestho bi ba̱di gue go mi gueꞌa̱ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nepʉ nuꞌʉ́ bi da̱ma ma ja ya ngu gatho rá nthetsꞌi nura haiꞌa̱ pa bá tsi ya daꞌthi co yá ꞌbebo ne bi tsꞌitsꞌi pa habʉ xqui tꞌøde mi ꞌbʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y habʉraza mi paꞌa̱ ja ya da̱nga hnini o ja ya tꞌʉca hnini, ya ja̱ꞌi mi tsi ya daꞌthi mi pɛgui ja ya ꞌñu, ne ora mi thohni ra Jesu mi ba̱ntebi ya ja̱ꞌi gue da hopa ya daꞌthi da dambabi masque hønsɛ rá ña̱ni rá he. Ne toraza mi thambabi, ꞌbestho mi ña̱ni de yá hñeni. ");
INSERT INTO oteNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ꞌRaya fariseo ne ꞌraya xahnate de ra ley núꞌʉ xqui ꞌñehe de Jerusale bi muntsꞌi ne bi ma bá cꞌa̱ꞌtsa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ne bi hyandi gue ꞌrayá nxadi ra Jesu bi ñuni nsinque xqui nxʉꞌyɛ ngu yá nza̱iꞌʉ, hangue bi ña̱maꞌñʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ngueꞌa̱ ya fariseo ne gatho maꞌra ya xodyo xi xqui nza̱i da nxʉꞌyɛ ante da ñuni ngueꞌa̱ njabʉ yá nza̱i ndu yá xita, y nuꞌbʉ hinda nxʉꞌyɛ ngu yá nza̱i hinda ñuni. ");
INSERT INTO oteNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ne ꞌbʉ ora da menga taiꞌʉ, ꞌbʉ hinda nxʉꞌyɛ hinda ñuni. Nehe mi ja maꞌra yá nza̱i núꞌʉ xqui ꞌñutui ndu yá xita: da xʉtꞌa yá ntsi, nuya ꞌbada ne nuya tsꞌøe dega bøja̱, ne da mɛꞌtsa yá mfidi pa da gohi strá ntꞌaxi. Ngueꞌa̱ mi hu yá mʉiꞌʉ gue co núꞌʉ ya tꞌøtꞌe mi øtꞌe da tꞌaxca yá mfeni ja rá thandi Ajua̱.) ");
INSERT INTO oteNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hangue nuya fariseo ne ya xahnate de ra ley bi ꞌyambabi ra Jesu ne bi ꞌñembi: ―¿Hanja nuyʉ ri nxadi hingui øtꞌe ngu yá nza̱i ndu ma xitahʉ mayaꞌbʉ? Nuyʉ́ ri ñuni masque hinxa nxʉꞌyɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nuꞌbʉ́ ra Jesu bi da̱tuabiꞌʉ: ―Nuꞌahʉ gyá yohmihʉ. Ra ba̱di Isaía bi ma̱ de gueꞌahʉ mayaꞌbʉ gue Ajua̱ bi ꞌñena njaua: Nuna hninina̱ ri nsundagui hønsɛ dega noyatho, pe nuyá mfeni go bí ꞌyo yabʉ de gueque. ");
INSERT INTO oteNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nuꞌʉ́ xøcambenigui pe hinte ri muui yá søcambeni, nguetho nuꞌʉ yá hmanda ri mandaꞌʉ go yá hmandasɛ, ne ma̱ñꞌʉ gue go stá ꞌbɛpcaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Xi majua̱ni ngu bi ma̱nga ra Isaía de gueꞌahʉ, ngueꞌa̱ nuꞌahʉ xcá tsocuahʉ yá hmanda Ajua̱ pa go grí dɛnbahʉ yá hmanda ndu ri xitahʉ. Nuꞌahʉ nuꞌa̱ ri ꞌbɛfihʉ, hønsɛ ra nsʉtꞌa ꞌbada ne maꞌra ya ntsi, y maꞌra ya tꞌøtꞌe de ra ntꞌaxqui. ");
INSERT INTO oteNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nehe bi ꞌñembabiꞌʉ: ―Guí hu ri mʉihʉ gue xá hño núꞌa̱ xcá tsocuahʉbʉ yá hmanda Ajua̱ pa go guí øꞌtuahʉ yá nza̱i ndu ri xitahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nura Moise bi ꞌñena: “Umba ra tꞌequꞌei ri dada ne ri na̱na̱ ne gui suꞌʉ”, ne “nuꞌa̱ tóꞌo da zanga rá dada o rá na̱na̱ dá tho.” ");
INSERT INTO oteNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pe nuꞌahʉ guí eñhʉ gue xá hño toꞌo da xipa rá na̱na̱ ne rá dada njaua: “Nuna ra boja̱ ndí ꞌraꞌahʉ hma̱ha̱, nubya go ma ga umba Ajua̱ ngueꞌa̱ ra Corbán.” (Ra Corbán rí bøni da ꞌñena ꞌnara ꞌbaha xa tꞌeque pa Ajua̱.) ");
INSERT INTO oteNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y njabʉ guí emfʉ ya ja̱ꞌi gue ya hinte da umba yá dada ne yá na̱na̱, ne ya hinda suꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Njabʉ guí pumfrithohʉ núꞌa̱ bi ma̱ Ajua̱, ne hønsɛ go guí øꞌtuahʉ yá nza̱i ndu ri xitahʉ, y nehe njabʉ guí utua ri ba̱tsihʉ. Ne ndunthi maꞌra ya tꞌøtꞌe guí øthʉ mahyɛgui ngu nuna. ");
INSERT INTO oteNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nuꞌbʉ́ ra Jesu bi yo zofo ra hmuntsja̱ꞌi maꞌnaꞌqui ne bi ꞌñembiꞌʉ: ―ꞌYødehʉ guí gathohʉ ne dá zo ri mfenihʉ núna ma ga ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nuꞌa̱ cʉtꞌa ja rá ne ra ja̱ꞌi hingo gueꞌa̱ japi da ntsꞌoqui, pe núꞌa̱ pøni de rá mfeni ha̱, go gueꞌa̱ japi da ntsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nuꞌa̱ tóꞌo ja rá tꞌøde pa da ꞌyøde, dá ꞌyøde núna dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nepʉ bi ꞌuegueꞌa̱ de ra hmuntsja̱ꞌi, ne bi yʉtꞌa ja ra ngu núꞌa̱ xqui mihi, y nuni ja bi ꞌyambani sɛhɛ yá nxadi te rí bønga núꞌa̱ xqui xipa ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―¿Ha gue neꞌahʉ hinte ri fa̱dihʉ? ¿Ha hinguí pa̱hʉ gue hingue núꞌa̱ da zi ra ja̱ꞌi go gueꞌa̱ da japi da ntsꞌoqui? ");
INSERT INTO oteNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ngueꞌa̱ núꞌa̱ tsꞌi cʉtꞌatho ja rá mʉi ꞌna, ne pøni ne hingui tsꞌocua rá mfeni. Njabʉ bi ma̱nga ra Jesu gue xá hño da tsꞌi gatho ya nzaqui. ");
INSERT INTO oteNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nepʉ bi ꞌñena: ―Nuꞌa̱ ri japi da ntsꞌoca̱ ra ja̱ꞌi, núꞌʉ ya tsꞌomfeni beni. ");
INSERT INTO oteNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ngueꞌa̱ de ja rá tsꞌomfeni ꞌna, ja bí ehni gatho nuya ya tsꞌotꞌøtꞌe: ra ntsꞌinga medintha̱ti, ra ntꞌeꞌbɛhña̱, ra nthote, ");
INSERT INTO oteNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ra mfe, ra tsꞌoncꞌatꞌi, ra ntsꞌoꞌmʉi, ra nthate, ra ntsꞌoꞌyo, ra ntsꞌante, ra ntꞌetsꞌi, ne núꞌʉ toꞌo ri hyøcua núꞌa̱ te pɛꞌtsa maꞌna, ne núꞌʉ hingui pa̱di ndaꞌa̱ ra hño ndaꞌa̱ ra ꞌñʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gatho nuya ya tsꞌoqui bí ehe de yá tsꞌomfeni ya ja̱ꞌi, ne go guehya japi da ntsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nepʉ ra Jesu bi bøni de guehni ne bi ma ja ra hai guetbʉ ra hnini Tiro ne Sidó. Ne ja bá cʉtꞌini ja ꞌnara ngu, y himi ne to xa ba̱di hma̱ha̱, pe ꞌbestho bi fa̱tho. ");
INSERT INTO oteNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ha guetbʉ de guehni mi ꞌbʉhni ꞌnara ꞌbɛhña̱ núꞌa̱ mi pɛꞌtsa ꞌnará tꞌixu gue mi pɛꞌtsa ꞌnara tsꞌonda̱hi. Ne bi ꞌyøde gue xqui zøhni ra Jesu, hangue nuꞌá̱ ꞌbestho bi ma bá cꞌa̱ꞌtsi ne bi ndandiña̱hmu ja yá uaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nura ꞌbɛhña̱ꞌa̱ himrá me Israel ngueꞌa̱ mrá me Sirofenicia. Nuꞌá̱ bi ba̱ntebi ra Jesu pa da ꞌyɛmba ra tsꞌonda̱hi núꞌa̱ mi pɛꞌtsa rá tꞌixu. ");
INSERT INTO oteNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pe ra Jesu bi ꞌñembabi: ―ꞌMɛtꞌo mahyoni ga øꞌtua ra hño ya me Israel, ngueꞌa̱ nuꞌbʉ ꞌmɛtꞌo ga øꞌtua ra hño ya ꞌraꞌñoja̱ꞌi nguꞌi, nuꞌbʉ́ ga nja ngu núꞌa̱ toꞌo ha̱mba yá hñuni ya ba̱tsi pa da umba ya tsatꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nuꞌbʉ́ núꞌa̱ ra ꞌbɛhña̱ bi da̱tuabi ne bi ꞌñembi: ―Majua̱ni núꞌa̱ guí ma̱ Ndada, pe ya tsatꞌyo tøꞌmtho njaꞌti de ra mexa pa da gʉxa ya hangui núꞌʉ da dagui de habʉ ri ñuni ya ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nuꞌbʉ́ ra Jesu bi da̱tuabi: ―Xcá tha̱di xá hño, hangue pengui, grí ma ri ngu ne bá nu ri tꞌixu gue ya xa bønga ra tsꞌonda̱hi de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y nu mi zønga rá ngu núꞌa̱ ra ꞌbɛhña̱, bi zʉdi rá tꞌixu mi ꞌbɛnga ja rá fidi ne ya xqui bønga ra tsꞌonda̱hi de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nepʉ ra Jesu bi ma de guehni habʉ mi ꞌbʉ guetbʉ ra hnini Tiro, ne bi gatꞌa ja ra hnini Sidó ne bi thogui ja ra hai Decapoli pa bi yo menga ja ra ndehe Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne nuni ja bá tsꞌimpani ꞌnara ꞌñøhø mrá gogu ne mrá ꞌbane, y núꞌʉ toꞌo mri ziꞌa̱ bi ba̱ntebi ra Jesu da hñuxa rá ꞌyɛ ja gueꞌa̱ pa da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nuꞌbʉ́ ra Jesu bi gʉca núꞌa̱ ra daꞌthi ꞌnambʉ de ra hmuntsja̱ꞌi, ne bi dintꞌua yá dedo ja yá gu, nepʉ bi zotsꞌi yá dedo ne bi damba rá ja̱ne núꞌa̱ ra ꞌñøhø. ");
INSERT INTO oteNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nepʉ bi nøtsꞌe pa mahetsꞌi bi ꞌyɛnga rá nga̱ꞌtsi ne bi ꞌñembi: ―¡Efata! ―núꞌá̱ ne da ꞌñena: ¡Dá xogui ri gu ne ri ne! ");
INSERT INTO oteNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y ꞌbestho bi xo yá gu ne bi za bi ꞌyøde xá hño, ne bi tuqui rá ja̱ne ne bi za bi ña̱ xá hño. ");
INSERT INTO oteNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ha ra Jesu bi hñuꞌmba ra hña̱ ya ja̱ꞌi gue hinto da xipi, pe nuꞌʉ́ maꞌna bi ma bá ꞌyonga ra ꞌbede. ");
INSERT INTO oteNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Y maꞌna xi mri ꞌyø ya ja̱ꞌi ne bi ꞌñenaꞌʉ: ―Gatho núꞌa̱ øtꞌe xi xá hño, asta japi ya gogu da ꞌyøde, ne ya gone da ña̱. ");
INSERT INTO oteNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ja nuya paꞌʉ xi bi muntsꞌa ndunthi ya ja̱ꞌi maꞌnaꞌqui, ne mi otho te da ziꞌʉ, hangue ra Jesu bi zofo yá nxadi ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Xi dí hueca nuya ya ja̱ꞌi ngueꞌa̱ ya xa ꞌmʉi hñu pa con gueque ne otho te da zi. ");
INSERT INTO oteNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ꞌBʉ ga pɛhni da ma yá ngu njabʉtho co ra thuhu, xiꞌbʉ rí umba ra hødu má ꞌñu ngueꞌa̱ ꞌra xqui ꞌñehe de yabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pe yá nxadi bi ꞌñembabi: ―¿Hanja da za ga ꞌuiñhʉ nuyʉ ya ja̱ꞌi gue nuua habʉ dí ꞌbʉhʉ go ra mbonthi? ");
INSERT INTO oteNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nuꞌbʉ́ ra Jesu bi ꞌyambabi yá nxadi ne bi ꞌñembi: ―¿Hangu ya thuhme guí ha̱hʉ? Nuꞌʉ́ bi da̱tbi ne bi ꞌñembi: ―Hønsɛ yoto. ");
INSERT INTO oteNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nuꞌbʉ́ ra Jesu bi xipa ya ja̱ꞌi da hñudi. Nepʉ bi gʉ núꞌʉ yoto ya thuhme ne bi umba njama̱di Ajua̱ rá Dada. Nepʉ bi hyeque ne bi umba yá nxadi pa da xɛnbabi ya hmuntsja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nehe mi ha̱ꞌʉ ꞌraya tꞌʉca hua̱ ne bi umba ra Jesu. Nepʉ nuꞌá̱ bi ꞌyapa Ajua̱ da ja̱pi, ne bi xipa yá nxadi da umba ya ja̱ꞌi ya zi xɛca hua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Y gatho ya ja̱ꞌi bi ñuni asta xi bi niña̱. Nepʉ ya nxadi bi muntsꞌa ya xɛni núꞌʉ bi bongui y bi ñuxa yoto ya ꞌbøtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ha mi ngu goho ꞌmo ya ꞌñøhø núꞌʉ bi ñuni, y nuya ꞌbɛhña̱ ne ya ba̱tsi himbi ma ꞌmede. Nepʉ ra Jesu bi ꞌñediꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ne nuꞌá̱ ꞌbestho bi bøxa ja ra motsa co yá nxadi ne bi ꞌratsꞌi bi ma ja ra hai Dalmanuta. ");
INSERT INTO oteNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nepʉ ꞌraya fariseo bi ma bá tsʉdi ra Jesu ne bi mʉdi bi xaxi, ne bi xipi gue da ꞌyøtꞌe pa da hnequi ꞌnara ntꞌudi de mahetsꞌi pa da hyandiꞌʉ ua xi majua̱ni mrá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nuꞌbʉ́ ra Jesu xi bi ꞌyɛnga ꞌnara nga̱ꞌtsi ne bi ꞌñena: ―¿Hanja núꞌahʉ guí ꞌbʉhʉ mapaya guí ahʉ ga øtꞌa ꞌnara ntꞌudi? Xi majua̱ni dí xiꞌahʉ gue nuga hinga uꞌtꞌahʉ ni ꞌnara ntꞌudi. ");
INSERT INTO oteNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nuꞌbʉ́ nuꞌá̱ ꞌbestho bi zohniꞌʉ ne bi yopa bøxa ja ra motsa pa bi ma riꞌnandi ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ha nuyá nxadi xqui pumfri da hña̱xa ꞌraya thuhme, hønsɛ ꞌnatho mi hña̱ꞌʉ ja ra motsa. ");
INSERT INTO oteNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nepʉ ra Jesu bi zofoꞌʉ ne bi ꞌñembi: ―Jamasuhʉ de yá nzoi ya fariseo ne rá nzoi ra Erode. ");
INSERT INTO oteNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nuꞌbʉ́ yá nxadi bi ꞌñémsɛꞌʉ ꞌna ngu ꞌna: ―Nuní xicjʉ njabʉ ngueꞌa̱ hindí ha̱hʉ ra thuhme. ");
INSERT INTO oteNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pe ra Jesu bi ba̱tho te mi beñꞌʉ ne bi ꞌñembabiꞌʉ: ―¿Hanja guí ꞌñémfʉ gue otho ra thuhme? ¿Ha gue nsøcthoꞌa̱ oda ri mfenihʉ? ¿Ha gue hingui tsoda ri mfenihʉ de núꞌa̱ ra tsꞌɛdi dí pɛꞌtsi? Xi xá me ri corasohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ja ri dahʉ pe hinguí hanthʉ, ne ja ri guhʉ pe hinguí øhʉ, nixi guí beñhʉ núꞌa̱ stá øtꞌe co núꞌʉ ya thuhme. ");
INSERT INTO oteNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xi núꞌbʉ ndá xɛni núꞌʉ cʉtꞌa ya thuhme ne dá ꞌuinga cʉtꞌa ꞌmo ya ja̱ꞌi, ¿hangu ya ꞌbøtsꞌe gá xɛca thuhme bi bongui xa̱? Y nuꞌʉ́ bi da̱di bi ꞌñena: ―ꞌRɛtꞌamayoho ꞌbøtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nepʉ bi ꞌñena: ―Nehe xi núꞌbʉ ndá xɛni núꞌʉ yoto ya thuhme ne dá ꞌuinga goho ꞌmo ya ja̱ꞌi, ¿hangu ya ꞌbøtsꞌe gá xɛca thuhme bi bongui xa̱? Y nuꞌʉ́ bi ꞌñena: ―Yoto ꞌbøtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nuꞌbʉ́ ra Jesu bi ꞌñembiꞌʉ: ―¿Y ne njabʉ hinxa zoda ri mfenihʉ de nuna ra tsꞌɛdi dí hña̱? ");
INSERT INTO oteNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nuꞌbʉ́ ra Jesu ne yá nxadi bi zøni ja ra hai Betsaida, ne ja guehni bá tsꞌimpabi ꞌnara goda, y núꞌʉ toꞌo bá tsi bi ba̱ntebi gue da hñuxa rá ꞌyɛ ja gueꞌa̱ pa da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nuꞌbʉ́ ra Jesu bi cʉhna ra goda pa bi gʉca møte de ra hnini, ne bi goꞌtsuabi rá jini ja yá da, ne bi hñuxa yá ꞌyɛ ja gueꞌa̱, ne bi ꞌñembi: ―¿Ha gue ja te guí handi? ");
INSERT INTO oteNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Y nuꞌá̱ bi zøtꞌa yá da ne bi ꞌñena: ―Dí handa ya ja̱ꞌi di ꞌyo pe di hnequi ngu ya za. ");
INSERT INTO oteNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nuꞌbʉ́ ra Jesu bi yopa hñuꞌtsua yá ꞌyɛ ja yá da núꞌa̱ ra goda, ne nuꞌá̱ bi ña̱ni ne xi bi hyandi xá hño gatho. ");
INSERT INTO oteNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nepʉ ra Jesu bi mɛhni da ma rá ngu, ne bi hña̱cuabi gue hinda yʉtꞌa ja ra hnini pa hinda xipa ya ja̱ꞌi de guehni. ");
INSERT INTO oteNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ꞌMɛfa ra Jesu bi ma co yá nxadi ja ya tꞌʉca hnini núꞌʉ mi ja guetbʉ ra da̱hni Cesarea de Filipo. Y de má ꞌñu núꞌá̱ bi ꞌyamba yá nxadi ne bi ꞌñembi: ―¿Ha hingá øhʉ ya ja̱ꞌi ma̱ toꞌoguiga? ");
INSERT INTO oteNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nuꞌbʉ́ nuꞌʉ́ bi da̱di ne bi ꞌñena: ―ꞌRa ena gue go gueꞌe grá Xuua Xiꞌtsate, maꞌra ena grá ba̱di Elía, ha nu maꞌra ena gue go gueꞌe ꞌna de núꞌʉ maꞌra yá ꞌmɛhni Ajua̱ núꞌʉ mi ꞌbʉi mayaꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nuꞌbʉ́ ra Jesu bi ꞌyambiꞌʉ ne bi ꞌñembi: ―Xiꞌahʉ, ¿te guí ma̱ñhʉ de gueque? Y ra Pedro bi da̱di ne bi ꞌñembi: ―Nuꞌi go gueꞌe grá Cristo xpá mɛñꞌaꞌi Ajua̱ pa gui nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nuꞌbʉ́ ra Jesu bi hñuꞌmba ra hña̱ gue hinda xipa maꞌra ya ja̱ꞌi mi toꞌoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nepʉ ra Jesu bi mʉdi bi xipabi yá nxadi núꞌa̱ ma da tꞌøꞌtuabi, ne bi ꞌñembiꞌʉ: ―Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi pɛꞌtsi ma da sufri ndunthi. Ya nda̱xjua nda̱ ne ya nda̱ gá macja̱ ne ya xahnate de ra ley ma da ʉtsa asta da hñu yá mʉi da hyo, pe rá hñupa da yopa nte de rá du. ");
INSERT INTO oteNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Bi xipiꞌʉ co ya noya hinxá hñei, hangue ra Pedro bi gʉqui ꞌnambʉ ne bi mʉdi bi zʉi pa hinda ꞌyøtꞌe njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nuꞌbʉ́ ra Jesu bi mpʉntsꞌi ne bi hyanda gatho yá nxadi ne bi zʉi ra Pedro bi ꞌñembi: ―¡ꞌUegue de gueque, nuꞌi guí ha̱mpa rá tsꞌɛdi ra Satá hangue guí xica njabʉ! Ngueꞌa̱ nuꞌí hinguí ma̱ ngu núꞌa̱ ma̱nga Ajua̱, nuꞌí guí øtꞌa núꞌa̱ go yá paha ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nepʉ bi zohna yá nxadi ne ya ja̱ꞌi ne bi ꞌñembabiꞌʉ: ―Nuꞌa̱ tóꞌo da ne da dɛngagui, hinda za da ꞌyøtꞌe núꞌa̱ go rá paha sɛhɛ. Mahyoni da dɛngagui masque da tho ya ntꞌʉtsate ne ya ꞌbɛtsa asta rá du. ");
INSERT INTO oteNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nuꞌa̱ tóꞌo da ña̱nga rá te por hinda dɛngagui, núꞌá̱ ma da ꞌbɛdi rá te. Pe nuꞌa̱ tóꞌo da ꞌñɛi pa da du po rá ngueque ne po ra ma̱ca noya, núꞌá̱ da zʉ rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Te rá ꞌbɛ da da̱ha̱ ꞌnara ja̱ꞌi ꞌbʉ da mɛꞌtsa gatho ya hño de ra ximhai, y ne da ꞌmɛdi rá te? Otho. ");
INSERT INTO oteNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngueꞌa̱ ni ꞌna de nuya hñoꞌʉ hinda za da pøhøbi rá te. ");
INSERT INTO oteNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nuꞌa̱ tóꞌo da gøngagui ne da ntsa da ma̱nga ma noya ja yá thandi ya ꞌyøtꞌatsꞌoqui gá ja̱ꞌi ne ya ꞌña̱gamfri, ꞌmɛfa necagui ma ga ma̱ gue hindí pa̱diꞌa̱ nehe nu xcrá yopa pengaua. Nura paꞌa̱ ma ga ꞌñoꞌbe ya ɛnxɛ, ne ga hnequi co rá nsunda Ajua̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nehe ra Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ, ꞌra de gueꞌahʉ guí ꞌbʉhʉua gri tethohʉ ma gui hyanduahʉ rá tsꞌɛdi ra Nda̱ de mahetsꞌi sta ꞌñehe. ");
INSERT INTO oteNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Rá ꞌrato ma pa, ra Jesu bi zixa ra Pedro, ra Cobo ne ra Xuua, ne bi ma sɛhɛꞌʉ ja ꞌnara tꞌøhø xá hñetsꞌi. Y ne de guehni ja bi mpadini rá ꞌbai ra Jesu ja yá thandiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nurá he xi bi huɛxqui ne xi bi tꞌaxqui ngu ra tsɛ, y joꞌo ni ꞌnara meni nuua ja ra ximhai da japi da tꞌaxca ꞌnara he nguꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nepʉ de guehni nuyá nxadi bi hyandiꞌʉ gue mi ña̱uiꞌa̱ ndu ra Elía ne ndu ra Moise núꞌʉ myá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hangue nura Pedro bi ꞌñembabi ra Jesu: ―Ma Xahnateꞌi, ¡pøde xá hño ga ꞌbʉhʉua! Xiꞌbʉ ga hocje hñu ya zi ja̱ꞌtsi, ꞌna pa gueꞌe, maꞌna pa ra Moise, ha nu maꞌna pa ra Elía. ");
INSERT INTO oteNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nuya nxadi xi bi ntsu, hangue ra Pedro ngu bi ꞌbɛ rá mfeni ne himi pa̱ núꞌa̱ mi ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nepʉ bi goꞌmiꞌʉ ꞌnara guui, ne de guehni ja ra guui bi ntꞌøde ꞌnara noya bi ꞌñena: ―Nuna guehna ma hma̱ca Tꞌʉ. ꞌYøhʉ núꞌa̱ ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Y ꞌmɛfa ya nxadi bi hyandi gue ya mi joꞌoni núꞌʉ maꞌra, hønsɛ ra Jesu mi ꞌbasɛni. ");
INSERT INTO oteNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Y nu mi ga̱iꞌʉ de ra tꞌøhø, ra Jesu bi hñuꞌmba ra hña̱ núꞌʉ hñu yá nxadi, ne bi ꞌñembi: ―Oto xqui ma gui xiphʉ de núꞌa̱ xcá hyanthʉ asta hinda yopa nte de rá du Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hangue núꞌʉ hñu ya nxadi hinto bi xipabi de núꞌa̱ xqui hyantꞌʉ. Pe nuꞌʉ́ mri ꞌñámbi ꞌna ngu maꞌna, ne mi eñꞌʉ: ―¿Te rí bønga núꞌa̱ ra noya bi ꞌñena gue asta hinda yopa nteꞌa̱ de rá du? ");
INSERT INTO oteNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nuꞌbʉ́ nuꞌʉ́ bi ꞌyambabiꞌa̱ ne bi ꞌñembabi: ―¿Hanja enga ya xahnate de ra ley gue ꞌmɛtꞌo ma da ꞌñehe ra Elía nepʉ ja da ꞌñehe ra Cristo núꞌa̱ rá ꞌmɛhni Ajua̱ pa da e da nda̱? ");
INSERT INTO oteNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nuꞌbʉ́ nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Ha̱ha̱, go rá mʉdi ma da ꞌñehe ra Elía pa da zofo ya ja̱ꞌi da ñobri de yá tsꞌoqui ja rá thandi Ajua̱, nepʉ ja da ꞌñehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ¿Xi te ma̱nga ja ra Ma̱ca Tꞌofo de Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi? Nuꞌa̱ ma̱, ma̱ gue ma da tho ya ʉgui ne da tꞌʉtsa. ");
INSERT INTO oteNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pe de núꞌa̱ gá ꞌyangahʉ de ra Elía, dí xiꞌahʉ gue ya xa zøhøꞌa̱, y nuya ja̱ꞌi bi ꞌyøꞌtuabi núꞌa̱ go bi neꞌʉ, ngu xa ntꞌofo ja ra Ma̱ca Tꞌofo njabʉ bi tꞌøꞌtuabiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nu de ya xqui mencꞌʉ de ja ra tꞌøhø y ya mi ma da zøhø habʉ mi ꞌbʉi núꞌʉ maꞌra ya nxadi, bi hyanda ꞌnara da̱nga hmuntsja̱ꞌi xqui gotꞌatho núꞌʉ maꞌra ya nxadi, ne mi ꞌbahuini ya xahnate de ra ley mri ntsanoyauiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ha nu mi hyanda ya ja̱ꞌi bi zønga ra Jesu, himi pa̱di te da beñꞌʉ, ne bi nestꞌihi bi ma bá zɛngua. ");
INSERT INTO oteNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ha nura Jesu bi ꞌyambabi yá nxadi ne bi ꞌñembi: ―¿Te ma noya nguí ma̱ñhʉ con guehyʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nepʉ ꞌnara ja̱ꞌi núꞌa̱ mi ꞌba ja ra hmuntsja̱ꞌi bi da̱di ne bi ꞌñena: ―Ma Xahnateꞌi, dra zinꞌaua ꞌnama tꞌʉ pɛꞌtsa ꞌnara tsꞌonda̱hi xa japi xa ngone. ");
INSERT INTO oteNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Y nura ora da ꞌñá̱mbabi ri japi da dagui habʉraza, ne asta ri gustꞌa yá tsꞌi ne ɛntsꞌa ra fʉgui ja rá ne, y ya xi xa papa rá mʉi. Ya stá xipa ri nxadi pa da ꞌyɛmbahma̱ nura tsꞌonda̱hiꞌa̱, pe nuyʉ hinxa za xa ꞌyɛmbabi. ");
INSERT INTO oteNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nuꞌbʉ́ nura Jesu bi da̱di ne bi ꞌñena: ―¡Gyá ꞌña̱gamfrihʉ! ¿Asta haꞌmʉ gui camfrihʉ? ¿Asta haꞌmʉ ma ga tsɛꞌtꞌa ri ꞌmʉihʉ? Bá tsincahʉua núꞌa̱ ra tsꞌʉntꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nuꞌbʉ́ nuꞌʉ́ bi ziꞌtsuabi núꞌa̱ ra tsꞌʉntꞌʉ, ha nura tsꞌonda̱hi nu mi hyanda ra Jesu mi ꞌbahni, bi japa núꞌa̱ ra tsꞌʉntꞌʉ bi dagui ne mi ta̱ni ne mi ɛntsꞌa ra fʉgui ja rá ne. ");
INSERT INTO oteNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nuꞌbʉ́ ra Jesu bi ꞌyamba rá dada núꞌa̱ ra tsꞌʉntꞌʉ ne bi ꞌñembi: ―¿Hangu pɛꞌtsi de xa mʉdi njani? Ha nuꞌá̱ bi ꞌñena: ―Desde mi notsi ya mi njani. ");
INSERT INTO oteNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ndunthi ya ꞌmiꞌqui ra tsꞌonda̱hi høtꞌa ja ra tsibi o ja ya mothe pa da hyo hma̱ha̱. Hangue ꞌbʉ da za te gui ꞌyøꞌtuahma̱, huegahe gui faxcahe. ");
INSERT INTO oteNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nepʉ ra Jesu bi ꞌñembabi: ―Nuꞌi guí ena: ꞌBʉ da za. ꞌBʉ ja ri jamfri ha̱, gatho da za. ");
INSERT INTO oteNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nuꞌbʉ́ rá dada núꞌa̱ ra tsꞌʉntꞌʉ bi da̱di ntsꞌɛdi ne bi ꞌñena: ―¡Dí camfri, pe faxcagui pa maꞌna ga camfri! ");
INSERT INTO oteNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nuꞌbʉ́ ra Jesu bi hyandi gue ra hmuntsja̱ꞌi mi ꞌyo rí tsꞌiꞌmiꞌa̱, hangue nuꞌá̱ ꞌbestho bi ꞌñembabi ra tsꞌonda̱hi: ―Núꞌi tsꞌonda̱hi go xcá japi xa ngone ne xa ngogu nuna tsꞌʉntꞌʉ, pe nubyá nuga dí ꞌbɛpꞌaꞌi gui pøni de guehni ne hinhyaꞌmʉ gui yopa cʉtꞌa maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nepʉ núꞌa̱ ra tsꞌonda̱hi bi mafi, ha núꞌa̱ ra tsꞌʉntꞌʉ bi ꞌñá̱mba ra ndusɛ maꞌnaꞌqui, y ra oraꞌa̱ bi bønga ra tsꞌonda̱hi. Ha núꞌa̱ ra tsꞌʉntꞌʉ mi ꞌbɛni ꞌñena xqui du. Ne ndunthi ya ja̱ꞌi bi ꞌñena gue xqui du. ");
INSERT INTO oteNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pe ra Jesu bi mipa rá ꞌyɛ pa bi gʉtsꞌiꞌa̱, nepʉ nura tsꞌʉntꞌʉ ꞌbestho bi ꞌmai. ");
INSERT INTO oteNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Y nu mi yʉtꞌa ra Jesu ja ra ngu núꞌa̱ xqui mihi, yá nxadi bi ꞌyambabi ne bi ꞌñembabi: ―¿Hanja himbi za dá ɛñhe núꞌa̱ ra tsꞌonda̱hi? ");
INSERT INTO oteNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nuꞌbʉ́ nuꞌá̱ bi ꞌñembabiꞌʉ: ―Ya tsꞌonda̱hi ngu núꞌa̱ dá ɛnibya, nuꞌʉ́ da za da ꞌyɛni ꞌna, pe mahyoni da ayuna ꞌna ne da ꞌyapabi Ajua̱ con gatho rá mʉi. ");
INSERT INTO oteNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nepʉ nuꞌʉ́ bi bøni de guehni, bi gatꞌi ja ra hai Galilea, y ra Jesu himi ne to xa ba̱di ua mi ꞌyoni, ");
INSERT INTO oteNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ngueꞌa̱ mi xahna yá nxadi, mi embabiꞌʉ: ―Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da tꞌɛntꞌua ja yá ꞌyɛ ya ja̱ꞌi, ha nuꞌʉ́ ma da hyo, pe rá hñupa ma da yopa nte de rá du. ");
INSERT INTO oteNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pe nuyá nxadi himbi ba̱di te mri bønga nuya noya bi xipabiꞌʉ, ne mi tsu da ꞌyambabi. ");
INSERT INTO oteNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nepʉ bi yopa menguiꞌʉ pa Ncapernau ne bi yʉtꞌi mbo ja ra ngu núꞌa̱ xqui mihi. Nuꞌbʉ́ ra Jesu bi ꞌyambabi yá nxadi ne bi ꞌñembi: ―¿Te rá ꞌbɛ nguí ma̱ñhʉ má ꞌñu? ");
INSERT INTO oteNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pe nuꞌʉ́ hinte bi da̱di, ngueꞌa̱ de má ꞌñu mi ntsanoyasɛꞌʉ ne mri ꞌñámbi toꞌo ꞌna de gueꞌʉ da uaꞌa̱ da ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nuꞌbʉ́ ra Jesu bi hñudi ne bi zofo núꞌʉ ꞌrɛtꞌamayoho yá nxadi ne bi ꞌñembabi: ―Nuꞌa̱ tóꞌo da ne da nda̱ngui, osta ma da ꞌñetsꞌi. Nuꞌa̱ da ꞌyøtꞌe, dá mɛpa núꞌʉ maꞌra. ");
INSERT INTO oteNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nepʉ bi ꞌbaꞌma ꞌnara zi ba̱tsi madetho de yá nxadi, nepʉ bi dɛtsꞌi ne bi ꞌñembabiꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nuꞌa̱ tóꞌo da umba ntsaya de ja ma thuhu ꞌnara zi ba̱tsi ngu núna drí dɛtsꞌi, ja ra uɛnda go ꞌraca ntsaya. Y nuꞌa̱ tóꞌo ꞌraca ntsaya, ja ra uɛnda go umba ntsaya Ajua̱ ma Dada núꞌa̱ toꞌo bá pɛncaguiua. ");
INSERT INTO oteNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nuꞌbʉ́ ra Xuua bi ꞌñembi: ―Ma Xahnateꞌi, stá hanthe ꞌnara ja̱ꞌi gue de ri thuhu mi ɛnga ya tsꞌonda̱hi, y nuje dá ha̱cuahe gue ya hinda ꞌyøtꞌa njabʉ, ngueꞌa̱ nura ja̱ꞌiꞌa̱ hingui ꞌyo ꞌnadbʉ con guecjʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pe ra Jesu bi da̱di: ―Oguí ha̱cuahʉ, ngueꞌa̱ nuꞌa̱ tóꞌo da ꞌyøtꞌa ꞌnara ntꞌudi de ma thuhuga, nuꞌá̱ hinga ꞌbestho ma da pata rá mfeni nixi da ña̱maꞌñʉ de gueque. ");
INSERT INTO oteNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngueꞌa̱ núꞌʉ hingui ʉtsaguihʉ, go gueꞌʉ ꞌbʉi con guecjʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ha nuꞌa̱ tóꞌo da ꞌraꞌahʉ ma̱di tsꞌʉ ra zi dehe de ja ma thuhu ngueꞌa̱ guí tɛngahʉ, nura ja̱ꞌiꞌa̱ ma da hña̱nga rá tha̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nuꞌa̱ tóꞌo da tsꞌocua rá mfeni ꞌna de gue nuya ya zi ba̱tsi xa gamfrigui, núꞌa̱ ra ja̱ꞌiꞌa̱ maꞌna xá hño da tsꞌʉtua ja rá ꞌyʉga ꞌnara do strá hñʉ ne dra thøtꞌa ja ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nuꞌbʉ ꞌnari ꞌyɛ jaꞌaꞌi gui ꞌyøtꞌa ꞌnara tsꞌoqui, maꞌna xá hño hyɛqui, ngueꞌa̱ maꞌna xá hño gui cʉtꞌa habʉ bí ja ra te pa nza̱ntho co ꞌnada ri ꞌyɛ, que di ja yoho ri ꞌyɛ ne gui ma ja ra nidu habʉ hinhyaꞌmʉ ma da huetꞌa ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Y nuni ja bí ꞌbʉhni nehe ya zuꞌue núꞌʉ da zipa yá ngø núꞌʉ toꞌo da zønini, ne bí zø ra tsibi pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ha nuꞌbʉ ꞌnari ua jaꞌaꞌi gui ꞌyøtꞌa ꞌnara tsꞌoqui, maꞌna xá hño hyɛqui, ngueꞌa̱ maꞌna xá hño gui cʉtꞌa habʉ bí ja ra te pa nza̱ntho co ꞌnada ri ua, que di ja yoho ri ua ne gui ma ja ra nidu habʉ hinhyaꞌmʉ ma da huetꞌa ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Y nuni ja bí ꞌbʉhni nehe ya zuꞌue núꞌʉ da zipa yá ngø núꞌʉ toꞌo da zønini, ne bí zø ra tsibi pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ha nuꞌbʉ ꞌnari da jaꞌaꞌi gui ꞌyøtꞌa ꞌnara tsꞌoqui, maꞌna xá hño hña̱i, ngueꞌa̱ maꞌna xá hño gui cʉtꞌa habʉ bí manda Ajua̱ co ꞌnada ri da, que di ja yoho ri da ne gui ma ja ra nidu habʉ hinhyaꞌmʉ ma da huetꞌa ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Y nuni ja bí ꞌbʉhni nehe ya zuꞌue núꞌʉ da zipa yá ngø núꞌʉ toꞌo da zønini, ne bí zø ra tsibi pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ngueꞌa̱ gathoꞌihʉ mahyoni gui tsɛthʉ ya tsꞌothogui ne hingui ꞌyøthʉ núꞌa̱ go ri hnesɛhʉ, pa njabʉ gui pøñhʉ xá hño ja rá thandi Ajua̱. Ma gui njahʉ nehe ngu ya ꞌbaha núꞌʉ tꞌumbabi Ajua̱, núꞌʉ́ pɛꞌtsi da da̱ ja ra tsibi pa da hogui ne tꞌʉꞌtsua ra u. ");
INSERT INTO oteNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Xá hño ra u, pe nuꞌbʉ ya da ꞌbɛ rá hño, ¿hanja da za da cʉqui? Hingui tsa. Nuꞌahʉ njahʉ ngu ra hoga u, ꞌyøthʉ xá hño, ne ꞌbʉhʉ co ꞌnara hogaꞌmʉi ꞌna ngu ꞌna. ");
INSERT INTO oteNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nepʉ ra Jesu bi bønga de Ncapernau, ne bi ꞌño ja ra hai Judea ne ja ra hai riꞌnandi ra da̱the Jordá. Y nehe ja guehni bi muntsꞌni ndunthi ya ja̱ꞌi, ne ra Jesu bi mʉdi bi xahni ngu mrá nza̱iꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nuꞌbʉ́ bi jonga ꞌraya fariseo pa da xaxi, hangue bi ꞌyamba ꞌnara ntꞌani bi ꞌñembabi: ―¿Ha gue ja ra nsɛqui da hyɛpʉ rá ꞌbɛhña̱ ꞌnara ꞌñøhø? ");
INSERT INTO oteNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nuꞌbʉ́ ra Jesu bi ꞌyambabiꞌʉ nehe, ne bi ꞌñembabi: ―Xi ra Moise, ¿te bi xiꞌahʉ de gueꞌa̱? ");
INSERT INTO oteNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y ya fariseo bi da̱di ne bi ꞌñena: ―Nura Moise bi unga nsɛqui gue da thoca ꞌnara tꞌofo dega nxuni, ne njabʉ ha̱, da za da nxungüi rá ꞌbɛhña̱ ꞌnara ꞌñøhø. ");
INSERT INTO oteNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Nura Moise bi unga nsɛqui gue da tꞌøtꞌa njabʉ ngueꞌa̱ nuꞌahʉ́ xi xa megui ri corasohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pe desde rá mʉdi himi njabʉ, ngueꞌa̱ ra Ma̱ca Tꞌofo ena gue Ajua̱ “bi hyoca ra ꞌñøhø ne ra ꞌbɛhña̱”. ");
INSERT INTO oteNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Hangue ꞌnara ꞌñøhø da zopʉ rá dada ne rá na̱na̱ pa go da ꞌmʉhui rá ꞌbɛhña̱, ");
INSERT INTO oteNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y de ri yoho, ya da ꞌnatho.” Njabʉ ma̱nga ra Ma̱ca Tꞌofo. Hangue núꞌa̱ ra ꞌñøhø ne núꞌa̱ ra ꞌbɛhña̱ ya ri ꞌnatho, hingue ri yoho. ");
INSERT INTO oteNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hangue núꞌʉ xa pɛhna Ajua̱, ni ꞌnara ja̱ꞌi hinda za da ꞌuequeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Y nu mi mencꞌʉ pa ja ra ngu habʉ xqui mihi, yá nxadi ra Jesu bi ꞌyambiꞌʉ nehe de ra nxuni. ");
INSERT INTO oteNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hangue nuꞌá̱ bi ꞌñembabiꞌʉ: ―Nuꞌa̱ tóꞌo da hyɛpʉ rá ꞌbɛhña̱ ne da ntha̱tui maꞌna, ya bi ꞌyøtꞌa ꞌnara tsꞌoqui ngueꞌa̱ xa hyɛpʉ núꞌa̱ rá mʉdi ꞌbɛhña̱ xa ntha̱tui. ");
INSERT INTO oteNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ha nuꞌbʉ ꞌnara ꞌbɛhña̱ da hyɛpʉ rá da̱me ne da ntha̱tui maꞌna ra ꞌñøhø, ya bi ꞌyøtꞌa ꞌnara tsꞌoqui ngueꞌa̱ xa hyɛpʉ núꞌa̱ rá mʉdi da̱me xa ntha̱tui. ");
INSERT INTO oteNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ꞌMɛfa, bi tsꞌiꞌtsua ya ba̱tsi ra Jesu pa da hñuxa rá ꞌyɛ ja gueꞌʉ pa da ja̱pi. Pe nuyá nxadi bi mʉdi bi guui núꞌʉ toꞌo mri zi ya ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pe nu mi hyanda ra Jesu gue mi øtꞌa njabʉ yá nxadi, nuꞌá̱ bi bø rá cuɛ ne bi ꞌñembabiꞌʉ: ―Oguí ha̱cuahʉ ya zi ba̱tsi da ꞌñe da zʉcagui, ngueꞌa̱ nuꞌʉ tóꞌo da ꞌmʉi ja rá hmanda Ajua̱, mahyoni da nja ngu nuya ya zi ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Xi majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo hinda nja ngu ꞌnara zi ba̱tsi pa da ꞌmʉi ja rá hmanda Ajua̱, hinda za da yʉtꞌa ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nepʉ ra Jesu bi dɛxa ya zi ba̱tsi ne bi hñuxa yá ꞌyɛ ja gueꞌʉ ne bi ꞌyapabi Ajua̱ rá Dada da ja̱piꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Y de ya mi ꞌbaꞌñu ra Jesu, bi zøhø ꞌnara ꞌñøhø mbra nestꞌihi, ne bi ndandiña̱hmu ja yá uaꞌa̱ ne bi ꞌñembabi: ―Nuꞌi Xahnate, ꞌnagrá hoja̱ꞌi, ¿te ꞌbɛ da za ga øtꞌe pa da za ga tsʉ ra te pa nza̱ntho? ");
INSERT INTO oteNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ha nura Jesu bi ꞌñembabi: ―¿Hanja guí engagui drá hoja̱ꞌi? Hønsɛ ꞌnatho toꞌo ra hoja̱ꞌi, y núꞌá̱ go gueꞌa̱ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ya guí pa̱di ndaꞌʉ gueꞌʉ ya hmanda: “Oxqui ntsinga medintha̱ti, oxqui hñote, oxqui mpe, oxqui jʉꞌtsua ya ncꞌuamba ri miquꞌeiui, oxqui hatꞌa ri miquꞌeiui, umba ra tꞌequꞌei ri dada ne ri na̱na̱ ne suꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nuꞌbʉ́ núꞌa̱ ra ꞌñøhø bi da̱di ne bi ꞌñena: ―Xahnate, gatho nuya hmandaya stá øtꞌe desde stá mba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nuꞌbʉ́ ra Jesu bi hyandi dega hma̱te ne bi ꞌñembabi: ―ꞌNatho núꞌa̱ grí ꞌbɛdi gui ꞌyøtꞌe. Guí ma gui pa gatho núꞌa̱ guí pɛꞌtsi ne gui hyecuabi ya hyoya. Njabʉ ha̱, da za gui hña̱nga ya hoga hño de mahetsꞌi. Nepʉ gui ehe gui tɛngagui ne gui tsɛta gatho núꞌa̱ da ꞌñeꞌaꞌi asta ri du. ");
INSERT INTO oteNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pe nu mi ꞌyødeꞌa̱ núꞌʉ ya noya bi xipa ra Jesu, xi bi du rá mʉi y bi ma njabʉ co ra dumʉi, ngueꞌa̱ xi mrá rico. ");
INSERT INTO oteNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nuꞌbʉ́ ra Jesu bi mpʉntsꞌi ne bi hyanda yá nxadi, nepʉ bi ꞌñembabiꞌʉ: ―¡Xi rá hñei da yʉtꞌa ꞌnara rico ja rá hmanda Ajua̱! ");
INSERT INTO oteNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ha nuyá nxadi himi pa̱di te da beni de núꞌa̱ xqui ma̱ñꞌa̱. Hangue nuꞌá̱ bi yopa xipa maꞌnaꞌqui ne bi ꞌñembi: ―Ma zi tꞌʉꞌihʉ, ¡xi rá hñei da yʉtꞌa ja rá hmanda Ajua̱ núꞌʉ toꞌo hu yá mʉi gue co núꞌa̱ te pɛꞌtsi ma da mpøhø! ");
INSERT INTO oteNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maꞌna hinxá hñei da thogui ꞌnara cameyo ja rá gu ꞌnara ꞌyofri que ꞌnara rico da yʉtꞌa ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hangue nuyá nxadiꞌa̱ maꞌna himi pa̱di te da beni, ne mri ꞌñémbabi ꞌna ngu maꞌna: ―Nuꞌbʉ njabʉ, ¿toꞌo ja da za da mpøhø? ");
INSERT INTO oteNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nuꞌbʉ́ ra Jesu bi nhyanduiꞌʉ ne bi ꞌñembi: ―Ya ja̱ꞌi hingui tsa da mpøhø sɛhɛ, pe co rá mfatsꞌi Ajua̱ ha̱, ngueꞌa̱ pa Ajua̱ hinte rá hñei. ");
INSERT INTO oteNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nepʉ de gueꞌa̱ bi da̱di ra Pedro ne bi ꞌñembabi: ―Nuje stá tsohebʉ gatho núꞌa̱ te ndí pɛꞌtshe pa dá tɛnꞌahe. ");
INSERT INTO oteNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ, nuꞌʉ tóꞌo da zogui yá ngu, yá cu, yá nju, yá dada, yá na̱na̱, yá ba̱tsi, ne yá hai po rá ngueque ne po rá ngue ra ma̱ca noya, ");
INSERT INTO oteNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nuꞌʉ́ ma da hña̱nga núbya mapaya ꞌna nthebe de núꞌa̱ te xa zogui, ngu yá ngu, yá cu, yá nju, yá na̱na̱, yá ba̱tsi, yá hai, masque co ndunthi ra ntꞌʉtsate, y nepʉ rá ñoho ra ꞌmʉi ma da hña̱nga ꞌnara hoga te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pe nuꞌʉ tóꞌo ya da̱nguibya, nura paꞌa̱ ma da notsiꞌʉ, ha nuꞌʉ tóꞌo ya notsibya, nura paꞌa̱ ma da nda̱nguiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nura Jesu bi ne ra ꞌñu co yá nxadi pa bi ma Jerusale. Y núꞌá̱ go bi ꞌmɛtꞌoꞌa̱ de gueꞌʉ, y nuꞌʉ́ himi pa̱di te da beni de gueꞌa̱. Hangue nuꞌʉ́ ngu mi tsu, ne mri ꞌbɛfatho de gueꞌa̱. Nepʉ nura Jesu bi ꞌueca ꞌnambʉ núꞌʉ ꞌrɛtꞌamayoho yá nxadi pa bi yopa xipabi gatho núꞌa̱ mi ma da thoguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ne bi ꞌñembabiꞌʉ: ―Nubya drá maha Jerusale, ne dí ne ga ꞌraꞌahʉ ntꞌøde de Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. Núꞌá̱ ma dra da de guehni ja yá ꞌyɛ ya nda̱ gá macja̱ ne ya xahnate de ra ley, ne nuꞌʉ́ ma da ꞌyɛꞌmbi da hyo, ne ma da ꞌyɛntꞌuabi ja yá ꞌyɛ núꞌʉ hingyá xodyo pa da hyoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nuꞌʉ́ ma da ꞌyøꞌtua ra buhla ne da naꞌmbi ne da zotsꞌi, nepʉ ja da hyoꞌa̱. Pe rá hñupa ma da yopa nte de rá du. ");
INSERT INTO oteNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nepʉ nura Cobo ne ra Xuua núꞌʉ yá tꞌʉ ra Sebedeo bi joni ja ra Jesu ne bi ꞌñembabi: ―Ma zi Xahnateꞌihe, dí ne gui øtcahe ra ma̱te gui ꞌracje núꞌa̱ ma ga aꞌaꞌihe. ");
INSERT INTO oteNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nuꞌbʉ́ nuꞌá̱ bi da̱tuabiꞌʉ ne bi ꞌñembabi: ―¿Te rá ꞌbɛ guí ne ga øꞌtꞌahʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y nuꞌʉ́ bi ꞌñena: ―Dí nehe ga hudihe ꞌna ja ri ꞌñɛi, ꞌna ja ri nga̱ha̱, nu xcrí hñudi ja ri hudi de ri tsꞌʉtbi. ");
INSERT INTO oteNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pe ra Jesu bi ꞌñembabiꞌʉ: ―Nixi hinguí pa̱hʉ núꞌa̱ guí ahʉ. ꞌBʉ guí ahʉ njabʉ, ¿ha guí hanthʉ gui tsɛthʉ ya tsꞌothogui ngu núꞌʉ ma ga thoguiga, ne gui tsɛthʉ ya ʉgui ngu núꞌʉ ma ga tsɛtca? ");
INSERT INTO oteNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ha nuꞌʉ́ bi da̱di ne bi ꞌñembabi: ―Ha̱ha̱, ga tsɛthe. Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Majua̱ni ma gui tsɛthʉ ya tsꞌothogui ne ma gui tsɛthʉ ya ʉgui ngu núꞌʉ ma ga tsɛtca. ");
INSERT INTO oteNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pe nuga hingo ma ga huancá toꞌo ma da hñudi ja ma ꞌñɛi ne ja ma nga̱ha̱. Numa Dada go gueꞌa̱ pa̱di toꞌo ma da hñudini. ");
INSERT INTO oteNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pe nu mi ꞌyøde núꞌʉ má ꞌrɛtꞌa ya nxadi gue ra Cobo ne ra Xuua mi adi da hñuhui ra Jesu, nuꞌʉ́ bi bø yá cuɛ ngueꞌa̱ hanja go mi adi da hñuhniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nuꞌbʉ́ ra Jesu bi zohna yá nxadi ne bi ꞌñembabi: ―Guí pa̱hʉ xá hño gue nuya da̱nga nda̱ de guecua ja ra ximhai ri manda gatho yá hnini, ne núꞌa̱ go da ma̱ñꞌʉ go gueꞌa̱ da tꞌøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pe nuꞌahʉ́ oxqui ma gui ꞌyøthʉ njabʉ. ꞌBʉ ꞌna de gueꞌahʉ guí ne gui nda̱nguihʉ, mahyoni go gui pɛphʉ nuyʉ maꞌra. ");
INSERT INTO oteNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne nuꞌbʉ ꞌna de gueꞌahʉ guí ne gui nda̱hʉ de nuyʉ maꞌra, mahyoni go gui ꞌmɛgohʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, nuꞌá̱ hinxpá ꞌñehe pa go da ꞌbɛpabi, nuꞌá̱ xpá ꞌñehe pa go da ꞌmɛgo ne pa da unga rá te pa da guꞌtua gatho yá tsꞌoqui ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nepʉ ra Jesu bi zønga Jericó co yá nxadi, ne ꞌbestho bi bøni de guehni ne bi dɛni ꞌnara hmuntsja̱ꞌi. Y nuni ja ra ña̱nga ꞌñu mi huhni ꞌnara goda mrá thuhu ra Bartimeo mrá tꞌʉ ra Timeo, mi huhni mi pɛti. ");
INSERT INTO oteNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y nu mi ꞌyøde gue go mi gueꞌa̱ ra Jesu me Nasare núꞌa̱ ya mi ma da thohni, nuꞌbʉ́ nuꞌá̱ bi mʉdi bi mafi ne bi ꞌñena: ―¡Nuꞌi Jesu, rá Tꞌʉꞌi ndu ra nda̱ Davi, huegagui! ");
INSERT INTO oteNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pe ndunthi ya ja̱ꞌi bi zʉi ne bi ꞌñembabi da goꞌta rá ne. Pe nuꞌá̱ maꞌna xi mi mafi ntsꞌɛdi mi ena: ―¡Nuꞌi rá Tꞌʉꞌi ndu ra nda̱ Davi, huegagui! ");
INSERT INTO oteNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mi ꞌyøde ra Jesu ꞌbestho bi ꞌmai, ne bi mɛhni to da tsimpa núꞌa̱ ra goda. Y nuꞌʉ́ bá maꞌtiꞌa̱ ne bi ꞌñembabi: ―ꞌBai bá ehe, oguí tu ri mʉi, bí tøpꞌaꞌi ꞌna̱. ");
INSERT INTO oteNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nuꞌbʉ́ nuꞌá̱ ꞌbestho bi hña̱ca rá patꞌi ne bi da̱ma ꞌmai bi ma bá tsʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Y ra Jesu bi ꞌñembabi: ―¿Te ꞌbɛ guí ne ga øꞌtꞌaꞌi? Ha nura goda bi da̱di ne bi ꞌñembabi: ―Ma Xahnateꞌi, dí ne ga yopa handi maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ha nura Jesu bi ꞌñembabi: ―Grí ma, co ri jamfri ya xcá ña̱ni. Y ꞌbestho ra oraꞌa̱ bi za bi hyandi, ne bi dɛna ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ra Jesu ne yá nxadi ya mi ma da zønga Jerusale, ne mi ꞌyo guetbʉ de Betfage ne Betania, nehe guetbʉ ra tꞌøhø ꞌbo Olivo, hangue ra Jesu bi mɛhna yoho yá nxadi pa da ꞌmɛtꞌo, ");
INSERT INTO oteNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ne bi ꞌñembabiꞌʉ: ―Grí maha ja nuni ra tꞌʉca hnini bí jani, ne nu xcrí tsøñhʉni gui tsʉhʉ ꞌnara zi burru di tha̱tꞌi núꞌa̱ hinto xa tøguetho. Bá xoꞌthʉ ne bá tsincahʉua. ");
INSERT INTO oteNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ha nuꞌbʉ toꞌo da ꞌyañꞌahʉ ne da ꞌñeñꞌahʉ hanja guí øthʉ njabʉ, ꞌñembabihʉ: “Ra zi Hmu bí honi, nepʉ ꞌmɛfa ma ga yopa tsinꞌahe maꞌnaꞌqui,” gui ꞌñembabihʉ njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nuꞌbʉ́ núꞌʉ yoho yá nxadi bi ma ja núꞌa̱ ra tꞌʉca hnini, ne ja bá tsʉhni ꞌnara zi burru mi tha̱tꞌa møte ja ꞌnara gosthi ja rá hyo ra ꞌñu, ne bá xoꞌtiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Y mi ꞌbahni ꞌraya ja̱ꞌi bi ꞌñembabiꞌʉ: ―¿Te gui japhʉ núꞌa̱ ra burru guí xoꞌthʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ha nuya nxadi bi da̱di ngu xqui xipa ra Jesu, hangue núꞌʉ ya ja̱ꞌi bi hyopi bi zitsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nepʉ nuꞌʉ́ bá tsimpa ra Jesu núꞌa̱ ra burru, y bi hña̱ca yá patꞌiꞌʉ pa bi xiꞌtsua ra burru pa bi tøgueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nepʉ ra hmuntsja̱ꞌi bi hña̱ca yá patꞌi pa bi mø ja ra ꞌñu, ha nu maꞌra mi toca ya ꞌyɛza pa mi pøgue nehe ja ra ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Y núꞌʉ toꞌo mri ꞌbɛfa ne mri ꞌbɛtꞌo mi thø ya hmafi mi ena: ―¡Xá nsunda núni xpá mɛncahʉ Ajua̱! ¡Ajua̱ da ja̱pni! ");
INSERT INTO oteNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ajua̱ da ja̱pi núni ma da nda̱! Nuni go guehni ra nda̱ xqui hña̱ꞌtuabi ndu ma dadahʉ ra nda̱ Davi. ¡Xá nsunda Ajua̱ bí ꞌbʉi mahetsꞌi! ");
INSERT INTO oteNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nepʉ ra Jesu bi yʉtꞌa Jerusale ne gá yʉtꞌa ja ra nda̱nija̱, ne bi hyanda xá hño gatho núꞌa̱ mi jani mbo ra nda̱nija̱. Y coñꞌa ya bi nde, nuꞌá̱ bi bøni de guehni bi ma Betania co núꞌʉ ꞌrɛtꞌamayoho yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Y rá hyaxꞌa̱ ra Jesu ne yá nxadi bi bønga de Betania, y de má ꞌñu bi zʉ ra thuhuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ne dega yabʉ bi hyanda ꞌnara ꞌbai gá igo mi cꞌamtho, hangue bi ma bá cꞌa̱ꞌtshma̱ ua mi tø yá igo. Pe nu mi zønini hinte bi zʉdi, mi ꞌraꞌta yá xi ngueꞌa̱ mri ꞌbɛtho da nøgue. ");
INSERT INTO oteNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hangue ra Jesu bi ꞌñembabi ra ꞌbai gá igo: ―Hinhyaꞌmʉ ma da yopa nøgue ri igo. Ha yá nxadi bi ꞌyøde núꞌa̱ bi ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nepʉ bi yopa zøñꞌʉ Jerusale, y ra Jesu bi yopa yʉtꞌa ja ra nda̱nija̱ ne bi mʉdi bi ꞌyɛnga gatho núꞌʉ mi ꞌbʉhni mri mpa ne mri ntai mbo ra nija̱. Bi pʉntsꞌua yá mexa núꞌʉ ya mpatboja̱ ne yá thuhni núꞌʉ toꞌo mi pa ya domitsu. ");
INSERT INTO oteNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne ya himbi hopi to bi thoguini pa da hña̱xa ya tꞌøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nepʉ nuꞌá̱ bi xipabi ya ja̱ꞌi ne bi ꞌñembabi: ―¿Ha hinguí pa̱hʉ gue xa ntꞌofo ja ra Ma̱ca Tꞌofo ne ena: “Numa ngu rá thuhu ra ngu dega nsadi pa gatho ya hnini”? Ha nuꞌahʉ́ go xcá ꞌyøtꞌathohʉ ra ngu dega mfe. ");
INSERT INTO oteNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nuꞌbʉ́ ya xahnate de ra ley ne ya nda̱ gá macja̱ bi ꞌyøde núꞌa̱ bi ma̱nga ra Jesu, hangue nuꞌʉ́ bi ꞌñʉꞌti pa da hyohma̱ꞌa̱, ngueꞌa̱ mi tsuꞌʉ da hña̱nba yá nsu, ngueꞌa̱ gatho ya ja̱ꞌi xi mri ho núꞌʉ ya noya mi udiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ha nu mi putꞌa ra nde, ra Jesu ne yá nxadi bi bønga de guehni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ha nurá hyaxꞌa̱ de mi xudi bi thoguini maꞌnaꞌqui habʉ mi ꞌbai núꞌa̱ ra igo xqui zʉi ra Jesu, ne bi hyandiꞌʉ gue ya xqui ꞌyotꞌi gatho, asta yá ꞌyʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ra oraꞌa̱ ra Pedro bi benga núꞌʉ ya noya xqui ma̱nga ra Jesu, ne bi ꞌñembabiꞌa̱: ―Ma Xahnateꞌi, handi, nuna ꞌbai gá igo gá xipi gue ya hinhyaꞌmʉ ma da yopa nøgue yá igo, ya xa ꞌyotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Camfrihʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Xi majua̱ni dí xiꞌahʉ gue ꞌbʉ toꞌo ja ndunthi rá jamfri ne hinda dʉhʉ, da za da ꞌñembabi nuna ra tꞌøhø gue da mponi dí ma ja ra ndehe, ne da njabʉ ngu núꞌa̱ da ꞌyadi. ");
INSERT INTO oteNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hangue nuga dí xiꞌahʉ gue nuꞌa̱ gatho gui ꞌyaphʉ Ajua̱ ra Dada, camfrihʉ gue nuꞌá̱ xa ꞌyøꞌtꞌahʉ ri tꞌadihʉ, y núꞌa̱ gui ꞌyaphʉ da ꞌraꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pe ora gui ꞌyaphʉꞌa̱, ꞌbʉ to xa ꞌyøꞌtꞌahʉ ꞌnara ntsꞌoꞌmʉi, pumbahʉ, pa njabʉ Ajua̱ ra Dada bí ꞌbʉi mahetsꞌi da punꞌa ri tsꞌoquihʉ nehe núꞌa̱ xcá ꞌyøthʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ngueꞌa̱ nuꞌbʉ hingui pumbahʉ núꞌʉ toꞌo xa ꞌyøꞌtꞌahʉ ꞌnara ntsꞌoꞌmʉi, Ajua̱ ra Dada bí ꞌbʉi mahetsꞌi hinda punꞌa ri tsꞌoquihʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nepʉ bi yopa menguiꞌʉ pa Jerusale, y ra Jesu bi yopa yʉtꞌa ja ra nda̱nija̱, ne bi joni habʉ mi ꞌbaiꞌa̱ ya nda̱ gá macja̱ ne ya xahnate de ra ley ne ya nda̱xjua nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nepʉ nuꞌʉ́ bi ꞌyambabi ne bi ꞌñembabi: ―¿Toꞌo rá hmandaꞌa̱ pa gui ꞌyøtꞌa nuya ya tꞌøtꞌeya? ¿O toꞌo xa ꞌraꞌa nsɛqui? ");
INSERT INTO oteNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ha nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Dí ne ga anꞌahʉ ꞌnara ntꞌani nehe. Nuꞌbʉ gui xicaguihʉ, necagui ga xiꞌahʉ toꞌo rá hmandaꞌa̱ pa dá øtꞌa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Xi toꞌo bi hñuxa ra Xuua pa bi nxiꞌtsate? ¿Ha gue Ajua̱ o ya ja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nuꞌbʉ́ nuꞌʉ́ mri ꞌñémsɛ ꞌna ngu maꞌna: ―Nuꞌbʉ ga emfʉ gue go Ajua̱ bi hñuxa ra Xuua, nuꞌbʉ́ nuní da ꞌñenjʉ gue hanja hindá camfrihʉ núꞌa̱ mi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ha nuꞌbʉ ga emfʉ gue go ya ja̱ꞌi xa hñutsꞌi, xiꞌbʉ da bø rá cuɛ ra hnini. Mi ma̱ñꞌʉ njabʉ ngueꞌa̱ mi tsu ya ja̱ꞌi, ngueꞌa̱ gathoꞌʉ mi ena gue nura Xuua go mi gueꞌa̱ ꞌnará ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hangue nuꞌʉ́ bi da̱di ne bi ꞌñembabi ra Jesu: ―Hina hindí pa̱he. Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―Nuꞌbʉ́ nixi gueque hinga xiꞌahʉ nehe toꞌo rá hmanda pa dá øtꞌa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ra Jesu bi sigui bi ña̱ui ya nda̱ gá macja̱ ne ya xahnate de ra ley ne ya nda̱xjua nda̱, ne bi mʉdi bi xipa ꞌraya ꞌbede, ne bi ꞌñembabi: ―ꞌNara pa ꞌnara ꞌñøhø bi ga̱xa ꞌraya ꞌbai gá obxi, ne bi gutsꞌi xá hño. Ne bi hyoqui habʉ da sitꞌa ra ngui gá obxi núꞌa̱ da thɛꞌmi, ne bi hyoca ꞌnara nthøꞌma ua̱ꞌobxi xi rá hñetsꞌi. Nepʉ núꞌa̱ ra ua̱ꞌobxiꞌa̱ bi umba nhyandi ꞌraya ja̱ꞌi, ha núꞌa̱ ra me ua̱ꞌobxi bi bøni bi ma yabʉ ya hai. ");
INSERT INTO oteNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ha nu mi zøhø ra pa de ya xqui da̱ ya obxi, ra me ua̱ꞌobxi bi mɛhna ꞌnara ꞌbɛgo pa ma da cꞌa̱ꞌtsa núꞌʉ to mi ha̱ nhyandi ra ua̱ꞌobxi pa da hyeca núꞌa̱ ra sofo ya xqui gʉtsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pe núꞌʉ toꞌo mi ha̱ nhyandi ra ua̱ꞌobxi bi gʉ núꞌa̱ ra ꞌbɛgo bi naꞌmbi ne bi coꞌtsi bi mengui, hinte bi umbabi de ra sofo. ");
INSERT INTO oteNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nuꞌbʉ́ nura me ua̱ꞌobxi bi mɛhna maꞌna rá ꞌbɛgo, pe núꞌʉ ya hyanthua̱hi bi mfatsꞌi bi tɛdo núꞌa̱ ra ꞌbɛgo asta bi zɛmba rá ña̱xu, ne bi xipa ndunthi ya tsꞌonoya, ne himbi umba núꞌa̱ mri ꞌñepabi rá hmu. ");
INSERT INTO oteNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nepʉ ra me ua̱ꞌobxi bi yopa mɛhna maꞌna rá ꞌbɛgo, pe núꞌʉ ya hyanthua̱hi bi gʉ núꞌa̱ ra ꞌbɛgo ne bi hyo. Nepʉ ꞌmɛfa ra me ua̱ꞌobxi bi mɛhna má ndunthi ya ꞌbɛgo. Pe ꞌra de gueꞌʉ bi hnaꞌmbabi, ha nu maꞌra bi tho. ");
INSERT INTO oteNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y ya xi rá nga̱tsꞌi bi mɛnsɛ rá hma̱ca ꞌra tꞌʉ, ne bi ꞌñena: “Nuga dí pa̱di gue nuꞌbʉ ga pɛnsɛ ma tꞌʉ, nuya hyanthua̱hi ma da mɛꞌtsua ra tꞌequꞌei.” ");
INSERT INTO oteNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pe nu mi hyanda ya hyanthua̱hi gue bi zønga rá tꞌʉ ra me ua̱ꞌobxi, nuꞌʉ́ bi ꞌñʉꞌti ne bi ꞌñémsɛꞌʉ: “Go guehni ma da gohui yá hai rá dada. Pe ma ga hohʉ pa njabʉ go da gocjʉ ya hai.” ");
INSERT INTO oteNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hangue nuꞌʉ́ bi gʉmpa rá tꞌʉ núꞌa̱ ra me ua̱ꞌobxi bi hyoꞌʉ ne bá føta møte de ra ua̱ꞌobxi. ");
INSERT INTO oteNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Pe te guí beñhʉ ma da ꞌyøtꞌa núꞌa̱ ra me ua̱ꞌobxi co núꞌʉ ya tsꞌo hyanthua̱hi? Nuꞌá̱ ꞌnara pa ma da zøhø ne ma da hyo gatho núꞌʉ ya tsꞌo hyanthua̱hi ne go ma da umba nhyandi maꞌra ya ja̱ꞌi nura ua̱ꞌobxiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ha gue hinxcá hñeꞌthʉ ja ra Ma̱ca Tꞌofo habʉ enga njaua?: Núꞌa̱ ra do bi føtbʉhma̱ ꞌna lado nuya hyøngu, nubya gueꞌa̱ ra mʉdi do de rá nija̱ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Y nusɛꞌa̱ go bi mɛgui nura doꞌa̱ pa da hyø rá nija̱, ne dí hanthʉ gue xi rá nsunda núꞌa̱ bi ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nepʉ nuya nda̱ gá macja̱ ne ya xahnate de ra ley ne ya nda̱xjua nda̱ bi beñꞌʉ gue da gʉhma̱ ra Jesu pa da gotꞌa fadi ngueꞌa̱ bi ba̱diꞌʉ gue nuꞌá̱ mi ña̱ de gueꞌʉ ora mi xipa ra ꞌbede de ya tsꞌo hyanthua̱hi. Pe nuꞌʉ́ mi tsu te da ꞌyøꞌtuabiꞌʉ núꞌʉ ya hmuntsja̱ꞌi mi ꞌbʉhni, hangue bi zohni ra Jesu ne bi maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nepʉ nuꞌʉ́ bá pɛhna ꞌraya fariseo ne ꞌrayá mfatsꞌi ra nda̱ Erode pa da xaxa ra Jesu pa da nu ua te da zʉtuabi pa njabʉ da za da ña̱pabi. ");
INSERT INTO oteNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nepʉ nuya ꞌmɛhni bi zøhø habʉ mi ꞌbʉiꞌa̱ ne bi ꞌñembabi: ―Xahnate, dí pa̱he gue go gueꞌe guí ma̱nga majua̱ni ne hinguí øꞌtua ncaso núꞌa̱ ma̱nga ya ja̱ꞌi ne hinguí pata ri noya pa da ma̱ꞌaꞌi ya ja̱ꞌi, ngueꞌa̱ nuꞌi guí udi xá hño núꞌa̱ ri ho Ajua̱ da tꞌøtꞌe. Dí ne gui xicaguihe, ¿ha gue xá hño ga juꞌtuabihe ra boja̱ ra nda̱ Cesa o hina? ¿Ha gue ga juꞌtuahe o hina? ");
INSERT INTO oteNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pe ra Jesu ꞌbestho bi ba̱tua yá tsꞌomfeni nuya ja̱ꞌiꞌʉ, hangue bi ꞌñembabiꞌʉ: ―Nuga dí pa̱di te rá ꞌbɛ guí beñhʉ con gueque. Bá ha̱ncahʉua ꞌnara boja̱ pa ga handi. ");
INSERT INTO oteNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nuꞌbʉ́ nuꞌʉ́ bá ha̱npabiꞌa̱ núꞌa̱ ra boja̱ mi adi. Y nu mi hyandi núꞌa̱ ra boja̱ bi ꞌyambabiꞌʉ ne bi ꞌñembi: ―¿Toꞌo rá cꞌoi ne toꞌo rá thuhu núna tøcua ja ra boja̱? Y nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Rá cꞌoi ra nda̱ Cesa ne go rá thuhuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nuꞌbʉ́ bi da̱di ra Jesu ne bi ꞌñembabiꞌʉ: ―Nuꞌa̱ rá uɛnda ra nda̱ Cesa gui umbabihʉ ra nda̱ Cesa, ha nuꞌa̱ rá uɛnda Ajua̱ go da umbabihʉ Ajua̱. Y nu mi ꞌyødeꞌʉ gue bi da̱di njabʉ, xi bi ꞌyøꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nepʉ nu mi uadi ra Jesu bi ña̱ui ya fariseo ne yá mfatsꞌi ra nda̱ Erode, bi zøhø ꞌraya saduceo núꞌʉ toꞌo camfri gue hinto ma da yopa nte de ra du. Bi ꞌñehe pa bi ꞌyamba ꞌnara ntꞌaniꞌa̱, ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Xahnate, ra Moise bi zogui ntꞌofo gue ꞌbʉ ꞌnara ꞌñøhø da du ne da zogui rá ꞌbɛhña̱, pe ꞌbʉ ni ꞌnara ba̱tsi hinda zocuabi, nuꞌbʉ́ nurá cu de núꞌa̱ ra ꞌñøhø bi du mahyoni da ntha̱tui rá ꞌbɛpo, pa nuꞌbʉ da mɛꞌtsa ꞌnara ba̱tsi, da thuꞌmbabi rá thuhu ngu rá thuhu núꞌa̱ ndu rá mʉdi da̱me núꞌa̱ ra ꞌbɛhña̱, pa njabʉ hinda ꞌmɛdi rá thuhu núꞌa̱ ra ꞌñøhø xa du. ");
INSERT INTO oteNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nde nuꞌbʉ́, ꞌnaꞌqui mi ꞌbʉi yoto ya ꞌñøhø mri ncu. Nepʉ núꞌa̱ mada̱ bi ntha̱ti, pe bi du ne himbi zocuabi ni ꞌnara ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nepʉ núꞌa̱ rá ñoho ra cu bi ntha̱tui rá ꞌbɛpo, nepʉ neꞌa̱ bi du ha nixi gueꞌa̱ ni ꞌnara ba̱tsi himbi zocuabi nehe. Y rá hñu bi njabʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ne bi njabʉ gatho núꞌʉ yoto ya cu bi du pe ni ꞌna de gueꞌʉ himbi zocuabi ni ꞌnara ba̱tsi. Nepʉ rá nga̱tsꞌi, bi du ra ꞌbɛhña̱ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Xi de stí yopa nte de ra du núꞌʉ yoto ya ꞌñøhø, ndaꞌa̱ de gueꞌʉ xi drá da̱me núꞌa̱ ra ꞌbɛhña̱ꞌa̱? ngueꞌa̱ gatho núꞌʉ yoto bi ntha̱tui de guecua ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ha nura Jesu bi da̱di ne bi ꞌñembiꞌʉ: ―Nixi guí pa̱hʉ núꞌa̱ guí ma̱ñhʉ ngueꞌa̱ hinguí pa̱hʉ núꞌa̱ ma̱nga ja ra Ma̱ca Tꞌofo ne ndaꞌa̱ rá tsꞌɛdi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngueꞌa̱ nu sta yopa nte gatho núꞌʉ ya ja̱ꞌi xa du, ya hinda ma da ntha̱ta ya ꞌñøhø nixi ya ꞌbɛhña̱, ngueꞌa̱ nuni mahetsꞌi gatho ya ja̱ꞌi ma da ꞌmʉ ngu ya ɛnxɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nehe, pa gui camfrihʉ gue ma da yopa nte núꞌʉ xa du, ma ga benꞌahʉ núꞌa̱ bi ꞌyofo ra Moise ja núꞌa̱ ra xɛni habʉ ma̱ de núꞌa̱ ra nda̱po mi zø, ne ja guehni Ajua̱ bi zofo ne bi ꞌñembi: “Nuga go guecagui rá Ajua̱gui ra Abrá, ne ra Isaac, ne ra Cobo.” Njabʉ xa ntꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pe Ajua̱ go gueꞌa̱ ra Ajua̱ de núꞌʉ te, hingo ra Ajua̱ de núꞌʉ xa du. Hangue dí pa̱hʉ gue nura Abrá ne ra Isaac ne ra Cobo masque ya joꞌouaꞌʉ pe bí ja yá teꞌʉ. Hangue nuꞌahʉ hinte ri fa̱dihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nehe xqui zøhni ꞌnara xahnate de ra ley ne bi ꞌyøde mi ña̱ui ra Jesu ya saduceo, ne bi ꞌyøde gue ra Jesu xqui da̱di xá hño núꞌʉ ya ntꞌani xqui tꞌøꞌtuabi. Hangue neꞌa̱ bi uatꞌi pa bi ꞌyamba ꞌnara ntꞌani ne bi ꞌñembabi: ―¿Ndaꞌa̱ ra hmanda maꞌna ra da̱ngui de gatho? ");
INSERT INTO oteNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nuꞌbʉ́ nura Jesu bi da̱tuabi ne bi ꞌñembi: ―Ma ga xiꞌi núꞌa̱ ra hmanda maꞌna ra da̱ngui de gatho ne ena: “Hñuxhʉ ntꞌøde núꞌahʉ me Israelhʉ, Ajua̱ ma Zidadahʉ hønsɛ ꞌnatho. ");
INSERT INTO oteNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Y núꞌá̱ gueꞌa̱ mahyoni gui ma̱dihʉ con gatho ri mʉihʉ ne con gatho ri mfenihʉ ne con gatho ri tsꞌɛdihʉ.” Nuna guehna ra mʉdi hmanda maꞌna ra da̱ngui de gatho. ");
INSERT INTO oteNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ha nuna maꞌna ngúꞌatho ena njaua: “Ma̱di ri miquꞌeiui ne gui su ngu grí nsusɛhɛ.” Otho maꞌra ya hmanda maꞌna ya da̱ngui de núya dí xiꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nepʉ núꞌa̱ ra xahnate de ra ley bi ꞌñena: ―Xahnate, majua̱ni núꞌa̱ gá ma̱ gue Ajua̱ hønsɛ ꞌnatho ne joꞌo maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ha̱ha̱ xá hño to da ma̱di Ajua̱ con gatho rá mʉi, con gatho rá mfeni, con gatho rá tsꞌɛdi, ne da ma̱di rá miquꞌeiui da su ngu ri nsusɛ ꞌna. Gueꞌa̱ maꞌna xá hño que núꞌa̱ da hyo ya mboꞌoni ꞌna ne da tsa̱tꞌi pa da ꞌbahabi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nuꞌbʉ́ ra Jesu bi ꞌyøde gue núꞌa̱ ra ꞌñøhø xqui da̱di co ꞌnara hoga mfeni, hangue bi ꞌñembi: ―Ya tsꞌʉtho grí ꞌbɛdi pa gui cʉtꞌa ja rá hmanda Ajua̱. Y ya hinto bi rezga bi ꞌyøꞌtua maꞌra ya ntꞌani ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ha nu de mi xahnate ra Jesu ja ra nda̱nija̱ bi ꞌñena: ―¿Hanja enga ya xahnate de ra ley gue ra Cristo ma dí ꞌñehe de ja yá ja̱ꞌi ndu ra nda̱ Davi? ");
INSERT INTO oteNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nura Ma̱ca Nda̱hi bi ꞌbɛpa ndu ra nda̱ Davi bi ꞌyofo nuya ya noya ja ra Ma̱ca Tꞌofo habʉ ena njaua: Ajua̱ ra Dada bi ꞌñembabi ma zi Hmu: “Bá ehe gui hñudiua ja ma ꞌñɛi asta hinga tsiñꞌaꞌi gatho ri ncontra pa da gohiꞌʉ de njaꞌti ri ua.” ");
INSERT INTO oteNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ha nuꞌbʉ go drá tꞌʉhma̱ ra Davi nura Cristo, nuꞌbʉ́ ¿hanja bi ꞌñenga ra Davi gue go rá Hmu? Y nura hmuntsja̱ꞌi xi bi ho núꞌa̱ te mi ma̱nga ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ha nu de mi xahna ya ja̱ꞌi ra Jesu bi ꞌñembabi: ―Jamasuhʉ pa hingui ꞌyøthʉ ngu núꞌa̱ øtꞌa ya xahnate de ra ley. Nuꞌʉ́ ri ho da hye yá he xi xá ma, ne ri hoꞌʉ da zɛngua ya ja̱ꞌi co ra tꞌequꞌei ora ꞌyoꞌʉ ja ra tai. ");
INSERT INTO oteNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ha nu ja yá nija̱ꞌʉ ri ho da hñudi ja ya mʉdi hudi, ne ri ho da tꞌini rá mʉdi ja ya ngo. ");
INSERT INTO oteNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nehe xi øtꞌa yá nsadi co ndunthi ya noya, qué pa da hña̱mba yá ngu ya viuda nsinque da zo yá mfeni ya ja̱ꞌi. Nuya xahnateꞌʉ ma da hña̱nga yá castigo maꞌna ra da̱ngui. ");
INSERT INTO oteNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nepʉ ra Jesu bi hñudi habʉ mi ja ya ꞌmɛꞌtsboja̱ ja ra nda̱nija̱ pa mi handa núꞌʉ ya ja̱ꞌi toꞌo mi ɛntꞌini yá ofrenda. Ha mi handa ndunthi ya rico mi unga yá da̱nga ofrenda. ");
INSERT INTO oteNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nepʉ bi zøhø ꞌnara viuda xi mrá zi hyoya, ne bi ꞌyɛntꞌni yoho ya zi boja̱ dega cobre núꞌʉ hintsꞌʉ mri muui. ");
INSERT INTO oteNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hangue nura Jesu bi maꞌta yá nxadi ne bi ꞌñembabi: ―Xi majua̱ni dí xiꞌahʉ gue nuna zi hyoya viuda maꞌna xa unga ꞌnara ofrenda xi ra da̱ngui ja rá thandi Ajua̱ que gatho núꞌʉ toꞌo maꞌna xa ꞌyɛntꞌa ndunthi yá ofrenda ja ya ꞌmɛꞌtsboja̱. ");
INSERT INTO oteNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ngueꞌa̱ gatho núꞌʉ maꞌra toꞌo xa unga yá ofrenda xa uni de núꞌa̱ ya xa bonguabi, pe nuna zi hyoya viuda thogui ꞌnara da̱nga hñoya pe xa unga gatho núꞌa̱ xqui mɛꞌtsi pa da dai te da zi hma̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ha nu mi bønga ra Jesu de ja ra nda̱nija̱, ꞌna de nuyá nxadi bi ꞌñembabi: ―¡Ma zi Xahnateꞌi, hyanthma̱gue hangu rá hño nuyʉ ya da̱nga ngu xa thoqui co nuyʉ ya da̱ta do! ");
INSERT INTO oteNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―Nubya guí hanthʉ hangu yá nda̱ngui nuyʉ ya ngu, pe nuga dí xiꞌahʉ gue ma da zø ra pa da yøtꞌe gatho, ne ni ꞌnara do hinda ma da gohi di ntøque co rá midoui. ");
INSERT INTO oteNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nepʉ ra Jesu bi ma ja ra tꞌøhø ꞌbo Olivo núꞌa̱ ri nhyandui ra nda̱nija̱, ne ja bi hñuhniꞌa̱. Ha nura Pedro ne ra Cobo ne ra Xuua ne ra Andre bi ña̱sɛui ꞌnambʉ ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Dí ne gui xicje haꞌmʉ ma da yøtꞌe nuna nija̱ y te ma ntꞌudi ma da hnequi nu sta nja núꞌa̱ guí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hangue nura Jesu bi mʉdi bi xipabiꞌʉ ne bi ꞌñembabi: ―Jamasuhʉ hinda ma da hyaꞌahʉ ya cꞌuamba ja̱ꞌi de núꞌa̱ ma da xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ngueꞌa̱ ndunthi de gueꞌʉ ma da ꞌñehe y da bepca ma thuhu ne da ꞌñena: “Nuga go gueque drá Cristo xpá mɛncagui Ajua̱ pa ga nda̱.” Njabʉ nuꞌʉ́ ma da hyatꞌa ndunthi ya ja̱ꞌi pa da gamfribiꞌʉ núꞌa̱ da ma̱ñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma gui ꞌyøhʉ nehe de núꞌʉ ya da̱nga tuhni ya di ja, ne de núꞌʉ ma da nja. Pe nuꞌahʉ nu xcrí ꞌyøhʉ, oxqui ma gui tsuhʉ, ngueꞌa̱ mahyoni da njabʉ, pe hingo di gueꞌa̱ ya rá nga̱tsꞌi ra pa. ");
INSERT INTO oteNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ngueꞌa̱ ma da ntuhna ya hnini co maꞌra yá mihniniui, ne ya nda̱ co maꞌra yá minda̱ui, ne ma da nja ya mbimhai habʉraza, ne da nja ra da̱nga thuhu, ne xi da nja ya ñʉntsꞌi. Nuya go guehya ya mʉdi tsꞌothogui ma da nja. ");
INSERT INTO oteNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hangue nsuhʉ, ngueꞌa̱ ma da hnapꞌahʉ mbo ja ya nija̱, ne da tsꞌixꞌahʉ ja ya tsꞌʉtbi ne ja ya gobierhnu ne ja ya da̱nga nda̱ ngueꞌa̱ guí camfriguihʉ. Y ja yá thandiꞌʉ ma gui dahʉ majua̱ni de gueque. ");
INSERT INTO oteNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Y mahyoni da ntꞌøde ma noya gatho ja rá ngʉni ra ximhai, nepʉ ja da nja ra nga̱xhmai. ");
INSERT INTO oteNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pe nu sta zø ra ora da tsꞌixꞌahʉ pa dra daꞌahʉ ja yá ꞌyɛ ya tsꞌʉtbi, oxqui ma gui tu ri mʉihʉ núꞌa̱ te rá ꞌbɛ gui tha̱dihʉ, nixi gui beñhʉ ꞌmɛtꞌo núꞌa̱ te ma gui ma̱ñhʉ, ngueꞌa̱ nura oraꞌa̱ go Ajua̱ ma da xiꞌahʉ hanja gui tha̱hʉ, ne gueꞌa̱ gui ma̱ñhʉ. Ngueꞌa̱ hingo ma gui ña̱sɛhʉ, nura Ma̱ca Nda̱hi ma go da ña̱ꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nuꞌʉ tóꞌo ꞌbʉ yá cu ma da da pa da tho, ha nuya dada ma da da yá ba̱tsi, ha nuya ba̱tsi asta ma da ña̱pa yá dada nehe pa da tho. ");
INSERT INTO oteNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gatho ya ja̱ꞌi ma da ʉtsaꞌihʉ ngueꞌa̱ guí camfriguihʉ. Pe nuꞌʉ tóꞌo da zɛta gatho nuya ya tsꞌothogui asta rá nga̱tsꞌi, go gueꞌʉ da mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ma da njabʉ ngu núꞌa̱ bi ma̱nga mayaꞌbʉ ra Dañe rá ꞌmɛhni Ajua̱. Ma da hnequi núꞌa̱ xi strá ntsꞌo ne dra tsꞌomba rá nda̱nija̱ Ajua̱. (Dá zo ri mfenihʉ núꞌa̱ guí heꞌthʉbya.) Ha nu xcrí hyanthʉ núꞌa̱ ra tsꞌoja̱ꞌi sta ꞌmai habʉ hindí ꞌñepi da ꞌmai, núꞌahʉ gri ꞌbʉhʉ Judea gui ꞌbathʉ ꞌbestho ja ya tꞌøhø. ");
INSERT INTO oteNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nura paꞌa̱ sta njabʉ, nuꞌa̱ tóꞌo di ꞌyo ja rá patio de rá ngu odi cʉtꞌa mbo pa da hña̱xa núꞌa̱ te mahyoni ja ra ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Y nuꞌa̱ tóꞌo di ꞌyo ja rá hua̱hi dri mpɛfi núꞌa̱ ra oraꞌa̱, odi pa ja rá ngu pa da hña̱xa rá patꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Huecate núꞌʉ ya ꞌbɛhña̱ di daꞌthi ne núꞌʉ dya nzʉ nuya paꞌʉ, ngueꞌa̱ pa gueꞌʉ xi strá hñei pa da ꞌbatꞌi! ");
INSERT INTO oteNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ꞌYaphʉ Ajua̱ gue nura paꞌa̱ hindya pa dega tsɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngueꞌa̱ nuya paꞌʉ ma da nja ya da̱nga tsꞌothogui núꞌʉ hinhyaꞌmʉ xa nja desde bi hyoca ra ximhai Ajua̱, ne de gueꞌa̱ ya hinhyaꞌmʉ ma da yopa nja maꞌnaꞌqui ngu núꞌʉ ma da nja ya paꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Hangue Ajua̱ bi beni gue hingá ndunthi ya pa ma da njabʉ, ngueꞌa̱ nuꞌbʉ hina, hinto da zɛti. Pe po rá ngue núꞌʉ xa huahni, nuꞌá̱ bi beni gue maꞌna xá hño tsꞌʉtho ya pa ma da njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ha nuya paꞌʉ ꞌbʉ to da ꞌñeñꞌahʉ: “Bá e gui hyanthʉ ꞌbʉcua ra Cristo bá pɛhna Ajua̱ pa da nda̱”, o ꞌbʉ to da ꞌñeñꞌahʉ: “Maha ringuehni habʉ bí ꞌbʉ ra Cristo”, oxqui camfribihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngueꞌa̱ ma da ꞌmʉi ndunthi ya hyate ja̱ꞌi, ꞌra da ꞌñena gue go di gueꞌʉ dya Cristo bá pɛhna Ajua̱ pa da nda̱, nu maꞌra da ꞌñena gue dyá ꞌmɛhni Ajua̱ pa da ña̱ de gueꞌa̱. Nuꞌʉ́ ma da ꞌyøtꞌa ndunthi ya da̱nga ntꞌudi ne da nehma̱ da hyatꞌa núꞌʉ xa huahna Ajua̱ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pe nuꞌahʉ́ beñhʉ xá hño de núꞌa̱ dí xiꞌahʉ ne nsuhʉ. Oxqui hophʉ to da hyaꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Núꞌʉ ya pa sta thogui nuya ya tsꞌothogui, ra hyadi ma da ꞌmɛxuui, ne ra za̱na̱ ya hinda ma da yotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ya tsø ma da dagui de mahetsꞌi y gatho núꞌa̱ te bí ja mahetsꞌi da mbi. ");
INSERT INTO oteNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nepʉ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da thandi da ꞌñehe xi strá nsunda ja ya guui con gatho rá da̱nga tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nepʉ da mɛhna yá ɛnxɛ pa da muntsꞌa gatho núꞌʉ toꞌo xa thahni núꞌʉ di ꞌbʉi gatho rá ngʉni ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nuꞌahʉ ora guí hanthʉ ra ꞌbai gá igo ya da bøhø yá ꞌroho, nuꞌbʉ́ guí pa̱hʉ gue ya xa ꞌñepʉ ꞌbestho ra pahyadi. ");
INSERT INTO oteNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Njabʉ nehe nu xcrí hyanthʉ sta nja nuya ya tsꞌothogui, pa̱hʉ gue rá nga̱tsꞌi ra ximhai ya ꞌbʉi guetbʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Xi majua̱ni dí xiꞌahʉ, gue nuya ja̱ꞌi ꞌbʉibya hinda ma da du asta hinda mʉdi da nja gatho ngu núꞌa̱ dí xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mahetsꞌi ne ra ximhai da uadi da thogui, pe numa noya hinda uadi da thogui, pɛꞌtsi da njabʉ ngu núꞌa̱ stá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hinto pa̱di ra pa nixi ra ora haꞌmʉ da nja ra nga̱xhmai, nixi ya ɛnxɛ de mahetsꞌi hingui pa̱di, nixi rá Tꞌʉ Ajua̱, hønsɛ Ajua̱ ra Dada go gueꞌa̱ pa̱sɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hangue ndøꞌmhʉ nza̱ntho ne ꞌyaphʉ Ajua̱, ngueꞌa̱ hinguí pa̱hʉ haꞌmʉ da zø ra ora. ");
INSERT INTO oteNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nuga dí nja ngu ꞌnara ꞌñøhø ma da ma yabʉ ya hai, pe ante da ma, da ꞌyɛntꞌua ja yá ꞌyɛ yá ꞌbɛgo gatho núꞌa̱ te pɛꞌtsi, ne cada ꞌna de gueꞌʉ da xipabi te da mɛfi, ha nura nsugosthi da tꞌumbabi ra ꞌbɛfi pa da ndøꞌmi nu sta menguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hangue nuꞌahʉ nza̱ntho ndøꞌmhʉ nehe, ngueꞌa̱ hinguí pa̱hʉ haꞌmʉ ga pengui, ua dega xudi o dega nde o made ra xuui o ꞌna hmafi ra menja̱. ");
INSERT INTO oteNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ngueꞌa̱ xiꞌbʉ xcrí tha̱mfrihʉ ga tsøhø ne ga tsʉꞌahʉ gri a̱ha̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Núna dí xiꞌahʉbya, guehna dí xipabi nehe gatho maꞌra pa da ndøꞌmiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mri ꞌbɛdi nsøca yo pa pa ra ngo núꞌa̱ rá thuhu ra pascua, ne núꞌa̱ ra ngo dega tsꞌithuhme nsinque rá nzoi. Ha ya nda̱ gá macja̱ ne ya xahnate de ra ley ya mi nu hanja da za da hyatꞌa ra Jesu pa da gʉ da hyo. ");
INSERT INTO oteNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ne bi ꞌñémbabiꞌʉ: ―Hinga øthʉ núna dí beñhʉ de ra pa dega ngo, xiꞌbʉ da bø yá cuɛ ya ja̱ꞌi ne da ñʉntsꞌiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ha nuya paꞌʉ ra Jesu bi ꞌmʉhni Betania ja rá ngu ra Simu núꞌa̱ toꞌo xqui ña̱ni de ra lepra núꞌa̱ ra hñeni tsitꞌatho ra ngø. Mi huhni ra Jesu ja ra mexa mri ñuni, nepʉ bi zøhø ꞌnara ꞌbɛhña̱ bra hña̱ ꞌna ngu ra zi xito xqui thoqui de ꞌnara hoga do rá thuhu ra alabastro, mi po ꞌnara hoga ñʉni xi xmá ma̱di mrá thuhu ra nardo. Ha núꞌa̱ ra ꞌbɛhña̱ bi doꞌtsua rá ꞌyʉga núꞌa̱ ngu ra zi xito, ne bi xiꞌtsuabi ja rá ña̱xu ra Jesu núꞌa̱ ra ñʉniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nepʉ ꞌra de núꞌʉ mi ꞌbʉhni bi bø yá cuɛ ne mri ꞌñémbabi ꞌna ngu maꞌna: ―¿Hanja bi ꞌyøtꞌa njabʉ nuna ꞌbɛhña̱ hønsɛ bi manitho nuna hoga ñʉni? ");
INSERT INTO oteNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nuꞌbʉ xa ꞌba hma̱ha̱ xa muui ngu hñu nthebe denario, y núꞌa̱ ra boja̱ꞌa̱ xa za xa thecuahma̱ ya hyoya. Njabʉ bi ma̱nga núꞌʉ toꞌo mi ña̱maꞌñʉ de núꞌa̱ ra ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nuꞌbʉ́ nura Jesu bi ꞌñembabiꞌʉ: ―Ote guí xiphʉ. ¿Pa te guí ña̱maꞌñʉhʉ de guehni? Xá hño núꞌa̱ xa ꞌyøtcagui. ");
INSERT INTO oteNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ngueꞌa̱ nuya hyoya nza̱ntho ma da ꞌmʉi con gueꞌahʉ, ne nuꞌa̱raza ra pa gui ne gui umfʉ ꞌnara mfatsꞌi, da za gui umfʉ. Pe nuga hinga nza̱ntho ma ga ꞌbʉcua con gueꞌahʉ pa gui ꞌyøtcahʉ ra hño. ");
INSERT INTO oteNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nuna zi ꞌbɛhña̱ bi ꞌyøtꞌe núꞌa̱ xa zʉpa rá tsꞌɛdi, xa goscagui ja ma ndoꞌyo nuna ra hoga ñʉni pa ma ntꞌagui. Bi ꞌñenga ra Jesu njabʉ ngueꞌa̱ nuꞌʉ́ ya myá nza̱i mi joꞌtsua nuna hoga ñʉni núꞌʉ xa du. ");
INSERT INTO oteNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nepʉ ra Jesu bi ꞌñena: ―Xi majua̱ni dí xiꞌahʉ, habʉraza da hma̱nga ra ma̱ca noya, da hma̱ de nuna xa ꞌyøtca nuna zi ꞌbɛhña̱ pa ꞌnara feni de guehni. ");
INSERT INTO oteNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nepʉ nura Juda Iscariote ꞌna de núꞌʉ ꞌrɛtꞌamayoho yá nxadi ra Jesu, bi ma bá ña̱ui ya nda̱ gá macja̱ pa da dapabiꞌʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ha nu mi ꞌyøde ya nda̱ gá macja̱ njabʉ, xi bi johyaꞌʉ ne ꞌbestho bi ña̱ꞌtuabi ra boja̱. Hangue nuꞌá̱ xi mi ꞌyo rá mfeni hanja da ꞌyøtꞌeꞌa̱ pa da da ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ra mʉdi pa de ra ngo dega tsꞌithuhme nsi rá nzoi gueꞌbʉ mi tho ya tꞌʉca dɛti pa ra ngo dega pascua. Ha nura paꞌa̱ ya nxadi bi ꞌñembabi ra Jesu: ―¿Habʉ guí ne grá hñocje pa ga tsihʉ ra ntꞌoxi de ra pascua? ");
INSERT INTO oteNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nuꞌbú ra Jesu bi ꞌñembabi yoho yá nxadi: ―Grí maha ja ra hnini ne ja ma grí nthɛhʉni ꞌnara ꞌñøhø di ha̱ ꞌna xøni ra dehe, ne núꞌá̱ go gueꞌa̱ gui tɛñhʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ne nura ngu habʉ da yʉtꞌiꞌa̱, gui ꞌñemfʉ núꞌa̱ ra me ngu: “Bá pɛncahe ra Xahnate ne bi xicje ga xiꞌahe njaua: ¿Habʉ ja ra ngu xcá ꞌuegagui pa ga tsihe ra ntꞌoxi de ra pascua co ma nxadi?” ");
INSERT INTO oteNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y nu ja rá tønguꞌa̱ ma da ꞌñuꞌtꞌahʉ ꞌnara da̱nga ngu. Nuni ja jani gatho núꞌa̱ te ma ga hoñhʉ, ne ja gui hyocjʉni núꞌa̱ te ga tsihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hangue núꞌʉ yoho ya nxadi bi ma de guehni pa ja ra hnini y bi zʉdiꞌʉ ngu xqui xipabi ra Jesu. Y ja bi hyocniꞌʉ ra ntꞌoxi de ra pascua. ");
INSERT INTO oteNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Y ya de mi putꞌa ra nde bi zønga ra Jesu con gatho núꞌʉ ꞌrɛtꞌamayoho yá nxadi ja núꞌa̱ ra tønguꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nepʉ ya de mi huhni mri ñuni mahyɛgui co yá nxadi, bi ꞌñena: ―Majua̱ni dí xiꞌahʉ, núꞌahʉ guí ꞌbʉhʉua guí ntꞌoxihʉ con gueque, ꞌna de gueꞌahʉ ma gui dagaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ha nuyá nxadi xi bi du yá mʉi, ne ꞌramaꞌna de gueꞌʉ mi ambabi ra Jesu ne mi embabi: ―¿Ha gue go guecagui? ");
INSERT INTO oteNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nepʉ ra Jesu bi da̱di ne bi ꞌñembabi: ―ꞌNa de gue núꞌahʉ guí ꞌrɛtꞌamayohohʉ ma nxadiꞌihʉ guí tʉhʉhʉbya habʉ dí tʉhʉga, ꞌna de gueꞌahʉ ma gui dagaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da thogui gatho ngu núꞌa̱ xa tꞌofo ja ra Ma̱ca Tꞌofo, pe ¡huecate núꞌa̱ ra ꞌñøhø toꞌo ma da daꞌa̱! Maꞌna xá hño nixi xa ꞌmʉhma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ha nu de mri ñuniꞌʉ, ra Jesu bi gʉ ra thuhme ne bi umba njama̱di Ajua̱ rá Dada, bi hyeque ne bi umba yá nxadi, ne bi ꞌñembabi: ―Na̱, tsihʉ, nuna go guehna ma ndoꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nepʉ bi gʉ ꞌnara vaso mi po ra vinu, bi umba njama̱di Ajua̱ maꞌnaꞌqui ne bi umbabi yá nxadi pa bi zi gathoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne bi ꞌñembabiꞌʉ. ―Nuna go guehna ma ji ma ga fani pa da mʉdi ra ꞌraꞌyo cohi, núꞌa̱ ma da mfani pa gatho ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Majua̱ni dí xiꞌahʉ gue ya hinga ma ga yopa tsi ra vinu dega obxi de guecua. Nuꞌá̱ ma ga yopa tsi maꞌnaꞌqui asta núꞌa̱ ra pa grá ꞌbʉhʉ nuni habʉ bí manda Ajua̱ ma Dada, gueꞌbʉ grá yopa tsi, pe maꞌnaꞌño. ");
INSERT INTO oteNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nepʉ nuꞌʉ́ bi duta ꞌnara ja̱hña̱, y de guehni bi ma pa ja ra tꞌøhø ꞌbo Olivo. ");
INSERT INTO oteNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nepʉ ra Jesu bi ꞌñembabiꞌʉ: ―Nura nxuuibya gathoꞌihʉ ma da du ri mʉihʉ ne ma gui ꞌuehʉ de gueque. Ma da nja ngu bi ma̱nga Ajua̱ ma Dada ja ra Ma̱ca Tꞌofo habʉ ena: “Ma ga ho ra maꞌyo, y nuyá dɛti da nxani,” njabʉ bi ꞌñena. ");
INSERT INTO oteNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pe nu xcrá yopa nte de ra du, nuga ma ga ꞌbɛtꞌo de gueꞌahʉ pa grá ma Galilea. ");
INSERT INTO oteNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nepʉ ra Pedro bi ꞌñembabi: ―Masque gatho nuyʉ maꞌra da ꞌuegue, pe nuga hinga ꞌuegue de gueꞌe. ");
INSERT INTO oteNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nuꞌbʉ́ ra Jesu bi ꞌñembabi ra Pedro: ―Majua̱ni dí xiꞌaꞌi, nubya dí nxuui ma gui cøngagui hñuꞌqui ante rá yo hmafi ra menja̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nepʉ ra Pedro xi bi nja rá nøtꞌe bi ꞌñena: ―Masque da thogagui, pe nuga hinga cøñꞌaꞌi. Y gatho núꞌʉ maꞌra ya nxadi guetꞌatho mi ma̱ñꞌʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nepʉ bi maꞌʉ ja ꞌnara luga rá thuhu Getsemani, ne ra Jesu bi ꞌñembabi ꞌra de yá nxadi: ―Ja da hñuhʉua, nuga grá maua ga apabi Ajua̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Y bi zixa ra Pedro, ra Cobo ne ra Xuua pa bi mɛui. Nuꞌbʉ́ nuꞌá̱ bi mʉdi xi bi du rá mʉi de núꞌa̱ ma da thogui. ");
INSERT INTO oteNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne bi ꞌñembabi núꞌʉ yá nxadi bi zitsꞌi: ―Xi dí tu ma mʉiga asta dí ne ga tagui ga tu. Ja da tøꞌmhʉua ne oxqui ma gui a̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ha nuꞌá̱ bi thogui má tsꞌʉ de habʉ bi gohiꞌʉ, ne bi ndandiña̱hmu, ne bi mɛgui rá hmi ja ra hai pa bi ꞌyapabi Ajua̱ gue nuꞌbʉ xa zahma̱ hinxa thoguihma̱ nuya ya tsꞌothogui. ");
INSERT INTO oteNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y bi ꞌñena: ―Ma Dadaꞌi, hinte xá hñei pa núꞌa gui ne gui ꞌyøtꞌe. ꞌYøtꞌe pa hinga thogui nuya ya tsꞌothogui. Pe oxqui øtꞌa ngu núꞌa̱ go dí nega, ꞌyøtꞌa ngu núꞌa̱ ri ma̱ca pahague. ");
INSERT INTO oteNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nepʉ mi mengui bi zʉdi núꞌʉ hñu yá nxadi xqui doꞌma ra tꞌa̱ha̱, ne bi ꞌñembabi ra Pedro: ―Nuꞌi nugue Simu, ¿hanja xcá a̱ha̱? ¿Ha gue hinxa za xcá ꞌyapa Ajua̱ ꞌna ora con gueque? ");
INSERT INTO oteNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oxqui a̱ha̱hʉ, ꞌyaphʉ ndunthi Ajua̱ pa stí ꞌñepʉ ya tsꞌothogui gui tsɛthʉ. Ngueꞌa̱ guí behma̱hʉ ne ja ri pahahʉ pe nuri ndoꞌyohʉ otho rá tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nepʉ bi yopa ma maꞌnaꞌqui pa bá apabi Ajua̱ co núꞌʉ ya noya bi ma̱nga ra mʉdi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nepʉ de mi yopa mengui bi zʉdi yá nxadi xqui yopa doꞌma ra tꞌa̱ha̱, ne nixi himi tsa da zøtꞌa yá da, ne ya himi pa̱di te da da̱diꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ha nu mbá penga rá hñuꞌqui bi ꞌñembabi yá nxadi: ―Nubyá ha̱, a̱ha̱hʉ xá hño, ne tsayahʉ, ngueꞌa̱ ya bi zø ra ora gue Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi dra da ja yá ꞌyɛ ya ꞌyøtꞌatsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ya nanjʉ, maha. Ya xa ꞌñepʉ núꞌa̱ toꞌo ma da dagagui. ");
INSERT INTO oteNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tsꞌa ra ora mi ma̱nga njabʉ ra Jesu, ꞌbestho bi zøhø ra Juda, ꞌna de núꞌʉ ꞌrɛtꞌamayoho yá nxadi, ne mbra ꞌñoui ꞌnara hmuntsja̱ꞌi, ꞌra mi ha̱ ya mahuai, ne nu maꞌra mi ha̱ ya za, xqui mɛhna̱ ya nda̱ gá macja̱ ne ya xahnate de ra ley ne ya nda̱xjua nda̱ pa da gʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","De má ꞌñu ra Juda xqui ꞌñembabi núꞌʉ ya ja̱ꞌi mbra ꞌñoui: ―Ma ga ꞌraꞌahʉ ꞌnara seña. Núꞌa̱ ra ꞌñøhø ga tsʉꞌtsua rá hmi go di gueꞌa̱ ra Jesu. ꞌBestho gui jʉhʉ, ne gui tsixhʉ, oxqui thøhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y ngu bi zøhø ra Juda habʉ mi ꞌbai ra Jesu, ꞌbestho bi joni ne bi ꞌñembabi: ―Ma Xahnateꞌi. Y nura oraꞌa̱ bi zʉꞌtsua rá hmi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nepʉ núꞌa̱ ra hmuntsja̱ꞌi ꞌbestho bi gʉ ntsꞌa̱hni ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ra oraꞌa̱ ꞌna de gue núꞌʉ mi ꞌñoui ra Jesu bi gʉca rá mahuai ne bi dacuabi rá gu ꞌnará ꞌbɛgo ra nda̱ gá macja̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nepʉ nura Jesu bi ꞌñembabi núꞌʉ ya ja̱ꞌi toꞌo xqui gʉꞌa̱: ―¿Sague drá be pa e gui jʉgaguihʉ co ya huai ne ya za? ");
INSERT INTO oteNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nuga hyastho ndí ꞌbʉi ja ra nda̱nija̱ con gueꞌahʉ ndí utuate ne hingá jʉgaguihʉ. Pe pa da njabʉ ngu núꞌa̱ xa tꞌofo mayaꞌbʉ ja ra Ma̱ca Tꞌofo hangue gueꞌa̱ guí øthʉ njabʉbya. ");
INSERT INTO oteNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nepʉ gatho yá nxadi bi ma hnestꞌihi bi zopʉsɛ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pe ꞌnara tsꞌʉntꞌʉ xqui tɛ́tꞌatho ꞌnara dutu mi dɛna ra Jesu. Nepʉ ya ja̱ꞌi mi nehma̱ da gʉꞌa̱, pe hina ngueꞌa̱ hønsɛ rá dutu bi mipabi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Hangue nuꞌá̱ bi zopʉ rá dutu ne bi ma hnestꞌihi nsinque rá dutu. ");
INSERT INTO oteNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nepʉ ra Jesu bi tsꞌitsꞌi habʉ mbi ꞌbʉ ra da̱nga nda̱ gá macja̱, ne bá muntsꞌni gatho maꞌra ya nda̱ gá macja̱ ne ya nda̱xjua nda̱ ne ya xahnate de ra ley. ");
INSERT INTO oteNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ha nura Pedro mri dɛna ra Jesu dega yabʉtho, nepʉ bi yʉtꞌiꞌa̱ ja rá patio rá ngu ra da̱nga nda̱ gá macja̱, ne ja bi hñuhni co ya gʉntsꞌa̱hni mi mpaꞌta ja ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ha nuya nda̱ gá macja̱ ne gatho ra hmuntsꞌa nda̱ gá xodyo mi ne da hyo ra Jesu, hangue nuꞌʉ́ mi honga yoho ya testigo núꞌʉ ꞌnatꞌa da ma̱ pa da ña̱pabi pa ya da ꞌyɛꞌmbi da hyo, pe himbi nthɛ yá noya núꞌʉ ya testigo. ");
INSERT INTO oteNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ndunthi ya ja̱ꞌi mi jʉꞌtsua ya ncꞌuamba ra Jesu, pe ꞌramaꞌnaꞌño núꞌa̱ mi ma̱ñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ꞌRa bi ꞌmai ja yá thandi ya nda̱ ne mi ma̱ñꞌʉ ꞌnara ncꞌuamba bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nuje stá øhe xa ma̱nga njaua: “Ma ga yøꞌta nuna ra nda̱nija̱ bi hyoca ya ja̱ꞌi, pe rá hñupa ya stá ꞌbaꞌma maꞌna núꞌa̱ hingá nthoqui co yá ꞌyɛ ya ja̱ꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pe nixi núꞌʉ toꞌo mi ma̱nga njabʉ himbi nthɛ yá noya. ");
INSERT INTO oteNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nuꞌbʉ́ ra da̱nga nda̱ gá macja̱ bi ꞌmai ne bi ꞌyambabi ra Jesu: ―¿Ha hinte guí tha̱di de núꞌa̱ gá øde bi hma̱ de gueꞌe? ¿Ha gue majua̱ni núꞌa̱ bi hma̱? ");
INSERT INTO oteNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pe ra Jesu ni ꞌnara noya hinte bi da̱di. Hangue ra da̱nga nda̱ gá macja̱ bi yopa ꞌyambi bi ꞌñembi: ―¿Ha gue go gueꞌe grá Cristo rá Tꞌʉꞌi Ajua̱ núꞌa̱ xá nsunda xpá mɛñꞌaꞌi pa gui nda̱? ");
INSERT INTO oteNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nuꞌbú ra Jesu bi da̱di ne bi ꞌñena: ―Ha̱ha̱ go gueque. Ne ma gui hyanthʉ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi da hñudi ja rá ꞌñɛi Ajua̱ núꞌa̱ ja rá tsꞌɛdi. Nepʉ ma gui hyanthʉ da yopa menguiua ja ya guui. ");
INSERT INTO oteNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hangue nu mi ꞌyøde njabʉ ra da̱nga nda̱ gá macja̱ bi dʉnga yá he ngueꞌa̱ go gueꞌa̱ ꞌnara seña gue pa gueꞌá̱ ra Jesu xqui ña̱maꞌñʉ de Ajua̱. Nepʉ bi ꞌñena: ―¿Pa te ga ꞌbɛphʉbya maꞌra toꞌo da e da ma̱mbabi? ");
INSERT INTO oteNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nuꞌahʉ́ ya gá ꞌyøhʉ núꞌa̱ bi ma̱ gue nuní ri ꞌñetꞌa Ajua̱. Xibya, ¿te guí beñhʉ de núꞌa̱ xa ma̱ni? Ne gatho núꞌʉ mi ꞌbʉhni bi ꞌñena: ―Rí ꞌñepi da tho. ");
INSERT INTO oteNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nepʉ ꞌra de gueꞌʉ bi mʉdi bi zotsꞌi ra Jesu. Ne bi goꞌmbabi rá hmi ne xi mi naꞌmbi, ne bi ꞌyambabiꞌʉ bi ꞌñembi: ―Núꞌi grá ba̱di, ¡xicjebya toꞌo bi napꞌaꞌi! Nehe ya gʉntsꞌa̱hni mi faste mi naꞌmbabi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ha nura Pedro mi ꞌbʉ njaꞌti ja ra patio. Nepʉ bi zøhø ꞌnara nxutsi mrá ꞌbɛgo ra da̱nga nda̱ gá macja̱, ne bi uatꞌa ja ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nepʉ bi hyandi gue mi ꞌbahni ra Pedro mri mpaꞌti, xi bi nʉꞌti xá hño, nepʉ bi ꞌñembabi: ―A, go gueꞌe nehe nguí ꞌñoui ra Jesu me Nasare, ¿ha ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pe ra Pedro bi ncøni ne bi ꞌñena: ―Hina, nixi dí pa̱di toꞌoꞌa̱, ne nixi dí pa̱di núꞌa̱ guí ma̱. Nepʉ bi bøni bá ꞌba ja ra gosthi. Y nura oraꞌa̱ bi mafi ra menja̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ha núꞌa̱ ra nxutsi bi yopa nʉꞌta maꞌnaꞌqui ra Pedro, nepʉ bi yopa ꞌñemba núꞌʉ ya ja̱ꞌi mi ꞌbahni: ―Nuni ra ꞌñøhø go guehni ꞌna de núꞌʉ mri ꞌñoui ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ra oraꞌa̱ ra Pedro bi yopa ncøni maꞌnaꞌqui. Ne ꞌmɛfa núꞌʉ ya ja̱ꞌi mi ꞌbahni bi ꞌñembabi: ―Xi majua̱ni go gueꞌe ꞌna de núꞌʉ mri ꞌñoui ra Jesu, ngueꞌa̱ neꞌi grá me Galilea ngueꞌa̱ mfa̱tho ora guí ña̱. ");
INSERT INTO oteNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nepʉ ra Pedro bi mʉdi bi ntsante ne bi jura bi ꞌñena: ―Hindí pa̱di toꞌo núꞌa̱ ra ꞌñøhø guí ma̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y ꞌbestho ra oraꞌa̱ bi mafi ra menja̱ rá ñoꞌqui. Nuꞌbʉ́ ra Pedro ꞌbestho bi beni de núꞌa̱ xqui xipabi ra Jesu gue xqui ꞌñembi: “Ante rá yo hmafi ra menja̱, ya xcá cøngagui hñuꞌqui.” Nuꞌbʉ́ ra Pedro xi bi du rá mʉi ne bi nzoni. ");
INSERT INTO oteNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nurá hyaxꞌa̱ xi ꞌnitho ya nda̱ gá macja̱ ne ya nda̱xjua nda̱ ne ya xahnate de ra ley, ne gatho ra hmuntsꞌa nda̱ gá xodyo bi muntsꞌi ꞌnadbʉ pa bi go ꞌnara cohiꞌʉ te da ꞌyøtꞌe co ra Jesu. Nepʉ bi da̱tꞌiꞌʉ bi zitsꞌi bá ɛntꞌua ja rá ꞌyɛ ra nda̱ Pilato. ");
INSERT INTO oteNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nuꞌbʉ́ ra nda̱ Pilato bi ꞌyamba ra Jesu bi ꞌñembi: ―¿Ha go gueꞌe grá Nda̱ de ya xodyo? Ha nura Jesu bi da̱di: ―Ha̱ha̱, gueꞌa̱ ngu núꞌa̱ xcá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ha nuya nda̱ gá macja̱ xi mi ña̱pabiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hangue ra Pilato bi yopa ꞌyambabi ne bi ꞌñembi: ―¿Ha gue hinte guí tha̱di de gatho núꞌa̱ xcá ꞌyøde xa ma̱ñꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pe ra Jesu hinte bi da̱di. Hangue ra Pilato xi bi ꞌyø. ");
INSERT INTO oteNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tatꞌa jɛya ra Pilato mri nza̱i da hyɛgui ꞌnara ꞌyofadi pa núꞌʉ ya pa de ra ngo, y nza̱ntho mi hɛgui núꞌa̱ go da ꞌyadi núꞌʉ ya ja̱ꞌi mi ꞌyo ja ra ngo. ");
INSERT INTO oteNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ha xqui njotꞌa fadi ꞌraya ja̱ꞌi ngueꞌa̱ xqui ꞌñøtꞌatuhni pa da ꞌyɛnga ya nda̱ de ra hnini ne xqui nhyoteꞌʉ. Y ꞌna de gueꞌʉ mrá thuhu ra Barraba. ");
INSERT INTO oteNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nuꞌbʉ́ bi muntsꞌa ya ja̱ꞌi habʉ mi hu ra Pilato pa da ꞌyadi da thøgue ꞌnara ꞌyofadi ngu yá nza̱i. ");
INSERT INTO oteNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nuꞌbʉ́ ra Pilato bi ꞌyambabiꞌʉ ne bi ꞌñembi: ―¿Ha guí ne ga hɛcꞌaꞌihʉ núni tꞌembi ra Nda̱ de ya xodyo? ");
INSERT INTO oteNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bi ꞌñani njabʉ ra Pilato ngueꞌa̱ mi pa̱di gue co yá cuɛ ya nda̱ gá macja̱ bi gʉ ra Jesu ne bi dapabi, ngueꞌa̱ nuꞌá̱ xi ya mi dɛni ndunthi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pe nuya nda̱ gá macja̱ bi ꞌyʉꞌta ya ja̱ꞌi pa bi ꞌyadi dra thɛgui ra Barraba. ");
INSERT INTO oteNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nuꞌbʉ́ nura Pilato bi yopa ꞌyamba ya ja̱ꞌi ne bi ꞌñembabi: ―Nuꞌbʉ́, ¿te ꞌbɛ guí adihʉ ga øꞌtua ra Jesu núni guí emfʉ ra Nda̱ de ya xodyo? ");
INSERT INTO oteNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nuꞌbʉ́ ya ja̱ꞌi ꞌra gá mafitho bi ꞌñena: ―¡Dá ꞌbontꞌi pa ja da duni! ");
INSERT INTO oteNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nuꞌbʉ́ ra Pilato bi yopa ꞌyambabiꞌʉ ne bi ꞌñembabi: ―¿Te ma tsꞌoqui xa ꞌyøtꞌni? Pe nuya ja̱ꞌi maꞌna xi mri mantho ne mi eñꞌʉ: ―¡Dí ahe dra ꞌbontꞌi! ");
INSERT INTO oteNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nuꞌbʉ́ ra Pilato pa da pønga rá hmi co yá ja̱ꞌi, bi hyɛgui ra Barraba, ne bi manda bri fɛtꞌa ra Jesu, nepʉ bi ꞌyɛntꞌua ja yá ꞌyɛ yá soldado pa da zitsꞌi ma da pontꞌa ja ra ponza. ");
INSERT INTO oteNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hangue ya soldado bi zixa ra Jesu ja ra patio de ra tsꞌʉtbi, y ja bi muntsꞌni gatho ya soldado. ");
INSERT INTO oteNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nepʉ nuꞌʉ́ bi hyete ra Jesu co ꞌnara thɛnga he ngu núꞌʉ he ya nda̱, ne bi metꞌa ya ꞌbini pa bi hoca ꞌnara corona, ne bi hñuꞌtsua ja rá ña̱xu. ");
INSERT INTO oteNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ha mi øꞌtua ra ntꞌeniꞌa̱ ne mi zɛngua mi embabi: ―¡ꞌBʉi pa nza̱ntho, núꞌi ri tꞌequꞌei rá Nda̱ꞌi ya xodyo! ");
INSERT INTO oteNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne mi naꞌmbabi rá ña̱xu co ꞌnara tsꞌʉtꞌo ne mi tsotsꞌi. Nepʉ mri ndandiña̱hmu pa mri nda̱neꞌʉ, ꞌñena xi majua̱ni mi numansu. ");
INSERT INTO oteNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nepʉ mi uadi bi ꞌyøꞌtua ra ntꞌeni bi møcuabi ra thɛnga he, ne bi yo hyetuabi núꞌʉ xi myá he. Nepʉ bi zitsꞌiꞌʉ pa da pontꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","De mi bønga de ja ra hnini bi nthɛuiꞌʉ má ꞌñu ꞌnara ꞌñøhø xqui ꞌñe ja ra mbonthi. Nura ꞌñøhøꞌa̱ mrá thuhu ra Simu mrá me Cirene ne go mrá dada ra Jandro ne ra Rufo. Ha nuya soldado bi japa núꞌa̱ ra ꞌñøhø da ndudebi rá ponza ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","De guehni bi tsꞌixa ra Jesu ja ꞌnara luga rá thuhu Golgota núꞌa̱ rí bøni da ꞌñena Ña̱xmadu. ");
INSERT INTO oteNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nepʉ ya soldado bi umbahma̱ ra vinu xqui ntha̱ntsꞌui ra mirra, pe nuꞌá̱ himbi ne bi zi. ");
INSERT INTO oteNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nepʉ nuꞌʉ́ bi pontꞌa ja ra ponza. Nepʉ bi nhyegue ꞌra ꞌna núꞌʉ yá he, ne nu maꞌna rá he bi ma ra ta̱ha̱ toꞌo da da̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ne ngu mi nzʉnga gʉto xudi nura ora bri pontꞌiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nuyá nza̱iꞌʉ, da thøta ꞌnara tꞌofo ja ra ponza de núꞌa̱ xa ꞌyøtꞌa núꞌa̱ ra ja̱ꞌi pa hanja bi tꞌɛꞌmbi bi tho. Hangue ja rá ponza ra Jesu bi thøte gue go ra Nda̱ de ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nehe ja bri pontꞌni mahyɛgui con gueꞌa̱ yoho ya be, ꞌna ja rá ꞌñɛi, nu maꞌna ja rá nga̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hangue bi njabʉ ngu núꞌa̱ xqui tꞌofo ja ra Ma̱ca Tꞌofo habʉ ena: “Nuꞌá̱ bi thandi ngu ꞌnara da̱ga ꞌyøtꞌatsꞌoqui.” ");
INSERT INTO oteNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ha nuya ja̱ꞌi núꞌʉ mi thohni nuꞌa̱raza mi xipa ra Jesu, ne mi bʉtꞌa yá ña̱xu ne mi embi: ―¡Ha̱ha̱! ne gue nuꞌi gá ena gue ma gui yøꞌta ra nda̱nija̱ nepʉ rá hñupa gá ena gue xcá yopa ꞌbaꞌma maꞌnaꞌqui, ");
INSERT INTO oteNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mpøhø sɛhɛ ne ca̱i de núꞌa̱ ra pontꞌi xa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne ya nda̱ gá macja̱ mi øtꞌa buhlatho de ra Jesu mi ꞌñémbiꞌʉ: ―Nuní mi ena gue mi pøhø ya ja̱ꞌi, pe nubyá hingui tsa go da mpøhø sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ꞌBʉ xi majua̱ni go guehni ra Cristo núꞌa̱ go rá Nda̱ ya me Israel, dá ga̱ibya de ra pontꞌi xa̱. Nuꞌbʉ ga hanthe da ga̱i, nuꞌbʉ́ ha̱, ga camfrihʉ núꞌa̱ mi ma̱ni. Ne núꞌʉ xqui mpontꞌuini mahyɛgui mi ña̱maꞌñʉꞌʉ nehe de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nepʉ ngu nde ma pa bi ꞌmɛxuui maxøgue ra ximhai, ne asta ngu nzʉnga hñu nde ja bi yopa hnequi maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y nura oraꞌa̱, ra Jesu bi ña̱ xi ntsꞌɛdi ne bi ꞌñena: ―Eloi, Eloi, ¿lama sabactani? ―núꞌa̱ rí bøni da ꞌñena: Ma Dadaꞌi, ma Dadaꞌi, ¿hanja xcá hyɛgasɛhɛua? ");
INSERT INTO oteNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ne ꞌraya ja̱ꞌi mi ꞌbahni bi ꞌyøde núꞌa̱ mi ma̱, ne bi ꞌñena: ―ꞌYøhʉ, nuní maꞌta ndu ra ba̱di Elía. ");
INSERT INTO oteNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nepʉ ꞌnara ꞌñøhø bi nestꞌihi bi pobo ꞌnara esponja co ra juꞌtsa vinu ne bi tøta ja ꞌnara tsꞌʉtꞌo, ne bi umba ra Jesu pa da zʉtꞌi. Y nura ꞌñøhøꞌa̱ bi ꞌñembabi ya ja̱ꞌi: ―Ga tøꞌmhʉ ga nuhʉ ua da zø ra Elía da ca̱ꞌmi de ja ra pontꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nepʉ ra Jesu bi dø ꞌnara hmafi xi ntsꞌɛdi ne bi du. ");
INSERT INTO oteNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y nura oraꞌa̱ bi xø núꞌa̱ ra da̱nga dutu mi naxa mbo ra nda̱nija̱ pa mi juti núꞌa̱ habʉ maꞌna xi xmá nsunda, ne bi xøgue maña̱ asta bi zønga njaꞌti. ");
INSERT INTO oteNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ha núꞌa̱ ra nda̱ gá soldado mi ꞌbahni guetbʉ habʉ xqui ꞌbontꞌa ra Jesu bi hyanda xá hño hanja bi duꞌa̱, ne bi ꞌñena: ―Xi majua̱ni go mi guehni rá Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ne mi ꞌbahni nehe ꞌraya ꞌbɛhña̱ mi handatho de yabʉ, ꞌra de gueꞌʉ go mi gueꞌa̱ ra Maria Magdalena, ne ra Salomé, ne maꞌna ra Maria rá na̱na̱ ra Jose ne ra Cobo núꞌa̱ mba̱tsi de núꞌa̱ maꞌna ra Cobo. ");
INSERT INTO oteNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Núꞌʉ ya ꞌbɛhña̱ꞌʉ xqui dɛna ra Jesu núꞌbʉ mbi ꞌbʉ Galilea, ne go gueꞌʉ mi pɛpi. Nehe mi ꞌbahni ndunthi maꞌra ya ꞌbɛhña̱ núꞌʉ xqui ꞌñoui ra Jesu pa Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nura paꞌa̱ bri pontꞌa ra Jesu, go mi ꞌnara pa dega nthoqui, ngueꞌa̱ rá hyaxꞌa̱ go ra sabdo ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hangue ꞌbestho nura paꞌa̱, ya mi ma da yʉ ra hyadi, bi ma ra Jose núꞌa̱ mrá me Arimatea bá nu ra nda̱ Pilato, ne bi yʉtꞌi nsinque ra ntsu pa bi ꞌyapa nsɛqui da zʉcua rá ndoꞌyo ra Jesu de ja ra ponza pa da dutsꞌi ma da ꞌyagui. Núꞌa̱ ra ꞌñøhøꞌa̱ mi ja rá nsu ne xi mrá fa̱di ngueꞌa̱ go mrá nda̱ nehe de ra hmuntsꞌa nda̱ gá xodyo. Neꞌa̱ nehe mi tøꞌmtho haꞌmʉ da zøhø rá ꞌmɛhni Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pe ra Pilato mi hu rá mʉi gue hinxqui dutho, hangue nuꞌá̱ bi zohna ra nda̱ gá soldado pa bi ꞌyambi ua ya xqui du. ");
INSERT INTO oteNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Y nu mi xipi gue ya xqui du, nuꞌbʉ́ ra Pilato bi umba nsɛqui ra Jose da dutsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nuꞌbʉ́ ra Jose bi danga ꞌnara hoga tꞌaxa dutu. Nepʉ bi zʉcua rá ndoꞌyo ra Jesu de ja ra ponza, ne bi mantꞌa ja núꞌa̱ ra dutu, ne bi dutsꞌi ma bá agui ja ꞌnara ntꞌagui núꞌa̱ xqui seꞌti ja ꞌnara medo. Nepʉ bi gotꞌi co ꞌnara da̱nga xingdo. ");
INSERT INTO oteNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y ra Maria Magdalena y maꞌna ra Maria rá na̱na̱ ra Jose bi hyandathoꞌʉ habʉ bi tꞌacuabi rá ndoꞌyo ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Y de mi nde núꞌa̱ nsabdo, ya xqui thogui núꞌa̱ ra pa dega tsaya, ra Maria Magdalena ne ra Salomé ne núꞌa̱ maꞌna ra Maria rá na̱na̱ ra Jose bi danga ꞌraya hoga ñʉni pa xa goꞌtsuahma̱ ja rá ndoꞌyo ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Y nurá hyaxꞌa̱ ndomingo xi ꞌnitho núꞌa̱ ra mʉdi pa de ra semana, bi maꞌʉ pa da cꞌa̱ꞌtsa ra ntꞌagui, ne bi zøñꞌʉ pøxhyadi. ");
INSERT INTO oteNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ne de má ꞌñu mri ꞌñámbabi ꞌna ngu maꞌna mi eñꞌʉ: ―¿Ha hindi ꞌbʉhni ꞌbʉ toꞌo da pʉntsꞌa ra do pa da xogahʉ ra gosthi ntꞌagui? ");
INSERT INTO oteNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pe nu mi zøniꞌʉ bi hyandi gue ya xqui tꞌentꞌa núꞌa̱ ra da̱nga do xqui jotꞌa ra gosthi ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nepʉ nuꞌʉ́ bi yʉtꞌa mbo ra ntꞌagui ne bi hyanda ꞌnará ɛnxɛ Ajua̱ mi hnequi ngu ꞌnara ba̱sja̱ꞌi mi huhni ngue yá ꞌñɛiꞌʉ, ne mi he ꞌnara tꞌaxa he xi xmá ma. Nuꞌbʉ́ nuꞌʉ́ xi bi ntsu. ");
INSERT INTO oteNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ha nura ɛnxɛ bi ꞌñembabiꞌʉ: ―Oguí tsuhʉ. Nuga dí pa̱di gue guí hoñhʉ ra Jesu me Nasare núꞌa̱ bri pontꞌi. Xi jaua habʉ bi ꞌbɛgui, pe ya joꞌoua ngueꞌa̱ ya xa yopa nte maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Rí maha bá xipabihʉ ra Pedro ne núꞌʉ maꞌra yá nxadi gue nuꞌá̱ ma da ꞌmɛtꞌo pa Galilea, ne ja ma dí nthɛuiniꞌʉ ngu bi xipi. ");
INSERT INTO oteNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nepʉ núꞌʉ ya ꞌbɛhña̱ bi bøni de guehni ja ra ntꞌagui bi ma hnestꞌihi, ne asta mri hua̱tꞌi co ra ntsu. Ne hinto bi xipabi núꞌa̱ xqui hyandi ngueꞌa̱ xi mi ꞌñouitho ra ntsu. ");
INSERT INTO oteNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Xudiꞌa̱ ndomingo ya xqui yopa nte ra Jesu de ra du, go rá mʉdi bi nthɛui ra Maria Magdalena núꞌa̱ toꞌo xqui ꞌyɛmbabi yoto ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nepʉ nura Maria bi ma bá cꞌa̱ꞌtsa ya nxadi ne bi zʉdi mi tu yá mʉi mi zoni, ne bi xipabiꞌʉ gue ya xqui hyanda ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pe mi ꞌyøde ya nxadi bi ma̱nga ra Maria Magdalena gue ra Jesu ya xqui yopa nte ne ya xqui nthɛui, pe nuꞌʉ́ himbi gamfri. ");
INSERT INTO oteNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nepʉ ꞌmɛfa ra Jesu xqui mpata rá ꞌbai bá nthɛui yoho yá nxadi núꞌʉ mri ma pa ja ra mbonthi. ");
INSERT INTO oteNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nepʉ núꞌʉ yoho ya nxadi bi da̱ma mengui pa bá xipa núꞌʉ maꞌra gue nuꞌʉ́ xqui nthɛui ra Jesu. Pe nixi njabʉ himbi gamfriꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nepʉ ꞌmɛfa ra Jesu bi zøni habʉ mi ꞌbʉi núꞌʉ ꞌrɛtꞌamaꞌra yá nxadi ora mri ñuniꞌʉ. Ne bi zʉiꞌʉ ngueꞌa̱ hinxqui gamfribi núꞌʉ toꞌo xqui xipi gue nuꞌá̱ ya xqui yopa nte ne xqui ña̱uiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nepʉ bi ꞌñembabiꞌʉ: ―Rí maha ja gatho rá ngʉni ra ximhai bá xiphʉ gatho ya ja̱ꞌi nuna ra ma̱ca noya. ");
INSERT INTO oteNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nuꞌa̱ tóꞌo da gamfri ne da nxistehe da mpøhø, pe nuꞌa̱ tóꞌo hinda gamfri hinda mpøhø, da ꞌmɛdi pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Y nu habʉ di ꞌbʉi ya gamfri, ma da ꞌyøtꞌeꞌʉ nuya ya ntꞌudi: De ma thuhu da ꞌyɛnga thi ya tsꞌonda̱hi; ma da ña̱ꞌʉ maꞌra ya ꞌraꞌyo hña̱qui; ");
INSERT INTO oteNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ne nuꞌbʉ da mihi ꞌnara quꞌeña̱, o da zi ꞌnara ꞌñethi núꞌa̱ hote, hinte da jaꞌʉ; nuꞌʉ́ da hñuxa yá ꞌyɛ ja ya daꞌthi ne da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mi uadi bi ña̱ui yá nxadi ra Zidada Jesu, nuꞌá̱ bi tsꞌixa pa mahetsꞌi, ne bá hudiꞌa̱ ja rá ꞌñɛi Ajua̱ rá Dada. ");
INSERT INTO oteNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ha nuyá nxadi bi nxani bi ma habʉraza bi ma̱nga ra ma̱ca noya. Ne ra Zidada Jesu núꞌa̱ xqui ma mahetsꞌi go gueꞌa̱ mi fatsꞌiꞌʉ mi øtꞌa ya da̱nga ntꞌudi pa njabʉ bi jamfri núꞌa̱ ra ma̱ca noya mi ma̱ñꞌʉ. Njabʉ gueꞌa̱.");
INSERT INTO oteNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nuꞌi nda Teofilo, ya guí pa̱di gue ndunthi toꞌo ya xa ꞌyofo de gatho núꞌa̱ te xa nja de guecjʉua. ");
INSERT INTO oteNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Núꞌa̱ bi ꞌyofoꞌʉ ma̱ mahyɛgui ngu núꞌa̱ ma̱nga núꞌʉ toꞌo mi ꞌñoui ra Jesu desde ra mʉdi ne xa xicjʉ de rá ma̱ca noyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hangue necagui dí ofo nehe de núꞌa̱ stá pa̱di. Stá ꞌñani xá hño desde ra mʉdi, ne dí ofo ꞌramatsꞌʉ. Stá beni xá hño ga ofo pa ga pɛhnꞌabʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","pa njabʉ gui pa̱di gue xi majua̱ni núꞌa̱ xa siꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ha nuya paꞌʉ mrá nda̱ ra Erode de ja ra hai Judea, ne ja núꞌa̱ ra haiꞌa̱ mi ꞌbʉhni ꞌnara macja̱ mrá thuhu ra Sacaría núꞌa̱ mi mpɛfi co ya macja̱ núꞌʉ myá thuhu ya Abías ngueꞌa̱ neheꞌa̱ mrá Abías. Ha nurá ꞌbɛhña̱ ra Sacaría mrá thuhu ra Sabe núꞌa̱ xqui ꞌñehe desde yá ja̱ꞌi ndu ra macja̱ núꞌa̱ mrá thuhu ra Aarón. ");
INSERT INTO oteNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nura Sacaría ne rá ꞌbɛhña̱ mi ꞌbʉi xá hño ja rá thandi Ajua̱ ne mi øꞌtua gatho yá hmandaꞌa̱ núꞌʉ hutsꞌi ja ra Ma̱ca Tꞌofo, ne himbi thimbabiꞌʉ ni ꞌnara tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pe ni ꞌnara ba̱tsi hinxqui mɛꞌtsiꞌʉ ngueꞌa̱ ra Sabe himi tsa da mɛꞌtsa ra ba̱tsi, ne ya xi myá da̱quꞌeiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ha nura Sacaría co maꞌra yá mimacja̱ui núꞌʉ mi mpɛhui mahyɛgui, bi datꞌa ra pa da yʉtꞌa ja ra nda̱nija̱ pa da xøcambeni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ne nuꞌʉ́ bi ꞌyøtꞌe ngu yá nza̱i pa da ba̱di toꞌo da zo rá thuhu pa da yʉtꞌa mbo ra nija̱ da tsa̱tꞌa ra tꞌutsꞌi, y nura Sacaría go gueꞌa̱ bi zo rá thuhu. ");
INSERT INTO oteNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ha nura ora mi tsa̱tꞌa ra tꞌutsꞌi mbo ra nija̱, nura hmuntsja̱ꞌi mbi ꞌba thi de ra nija̱ mi apabi Ajua̱ ngueꞌa̱ mi gueꞌa̱ ra ora de ra nsadi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsꞌa mi tsa̱tꞌa ra tꞌutsꞌi ra Sacaría, mi da̱mfri bi hyanda ꞌnara ɛnxɛ mi ꞌbahni ja rá hyo ra ata habʉ tꞌexa ra njʉspi ngue rá nga̱ha̱ ra Sacaría. ");
INSERT INTO oteNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ha nu mi hyandi gue mi ꞌbahni ra ɛnxɛ nixi mi pa̱di te da ꞌyøtꞌe co ra ntsu. ");
INSERT INTO oteNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ha nura ɛnxɛ bi ꞌñembabiꞌa̱: ―Sacaría, oguí tsu, ngueꞌa̱ dá e ga xiꞌi gue nuri nsadi xuá ꞌyøde Ajua̱. Nubyá, nuri ꞌbɛhña̱ ma da mɛꞌtsꞌaꞌi ꞌnari tꞌʉ, y nuꞌá̱ ma gui hñuꞌmbabi rá thuhu dra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ne nuꞌi ma xi gui johya ndunthi de ri tꞌʉ, ne ndunthi ya ja̱ꞌi ma da johya nu sta ꞌmʉiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ngueꞌa̱ nuꞌá̱ ma da nja rá nsu ja rá thandi Ajua̱, y hinhyaꞌmʉ ma da zi ra vinu gá obxi nixi maꞌra ya vinu, ne ante da ꞌmʉi ya di ha̱npa rá tsꞌɛdi ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y nuꞌá̱ ma da zofo ya me Israel pa ndunthi de gueꞌʉ da ñobri de yá tsꞌoqui ne da yopa xøcambeni Ajua̱ maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ne nuꞌá̱ go di gueꞌa̱ ma da ꞌmɛtꞌo de ra Zidada, nehe ma da tꞌumba rá tsꞌɛdi ngu núꞌa̱ bi tꞌumba ra ba̱di Elía, pa da umba ꞌnara tsꞌofo ya dada pa da yopa ma̱hui yá tꞌʉ, ne da zofo ya tsꞌoꞌyøde gá ja̱ꞌi pa da nhyogaꞌyødeꞌʉ. Ne nuꞌá̱ ma da zo ya ja̱ꞌi pa stí ꞌñe ra Zidada da gamfriꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ha nura Sacaría bi ꞌñembabi ra ɛnxɛ: ―¿Hanja da za ga camfri de núꞌa̱ guí xicagui, gue nugui ne ma ꞌbɛhña̱ ya dyá da̱quꞌeiꞌbe? ");
INSERT INTO oteNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ha nura ɛnxɛ bi ꞌñembabi: ―Nugui drá Grabie, duí ꞌbʉi ja rá thandi Ajua̱ pa dí pɛpabi, hangue nuꞌá̱ xuá mɛncagui pa e ga xiꞌaꞌi nuya ya hoga noya ja juadi dá xiꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hangue nubyá dí xiꞌi nehe, ma gui ngone, hinda za gui ña̱ asta hinda ꞌmʉi ri tꞌʉ pa ja da za gui yopa ña̱ maꞌnaꞌqui, ngueꞌa̱ hinxcá camfrigui núꞌa̱ stá xiꞌaꞌi. Pe nuꞌá̱ ma da njabʉ ngu núꞌa̱ stá xiꞌaꞌi, ne núꞌʉ ya paꞌʉ bi ma̱nga Ajua̱, gueꞌa̱ ra pa da njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ha núꞌʉ ya ja̱ꞌi mi ꞌbai thi mi tøꞌmtho da bønga ra Sacaría, ha nuꞌá̱ xqui yaꞌa̱ mbo ra nda̱nija̱, hangue nuꞌʉ́ himi pa̱ te da beni. ");
INSERT INTO oteNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ha nu mi bønga ra Sacaría himi tsa da ña̱ui núꞌʉ mi tøꞌma thi. Nuꞌbʉ́ nuꞌʉ́ bi ba̱tho gue nuꞌá̱ xqui hyandua ꞌnará thedi Ajua̱ nuni mbo ra nija̱. Y nuꞌá̱ mi ña̱ui ya ja̱ꞌi pe dega señatho ngueꞌa̱ xqui ngone. ");
INSERT INTO oteNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ha nu mi uadi núꞌʉ ya pa de rá ꞌbɛfi ra Sacaría ja ra nda̱nija̱, bi maꞌa̱ pa ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ne hintsꞌʉ yaꞌa̱ ya pa ra Sabe bi mʉdi bi ndaꞌthi, y himbi bønga de ja rá ngu cʉtꞌa za̱na̱. Nuꞌá̱ mi benga ja rá mfeni ne mi ena: ");
INSERT INTO oteNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ajua̱ co rá nhyoja̱ꞌi xa ꞌyøtcagui njaua pa ya hinda nøngagui ya ja̱ꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ha de rá ꞌrato za̱na̱ Ajua̱ bá yopa pɛhna ra ɛnxɛ Grabie pa bá ehe ja ra tꞌʉca hnini núꞌa̱ rá thuhu Nasare de ra hai Galilea, ");
INSERT INTO oteNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pa bá cꞌa̱ꞌtsa ꞌnara nxutsi mrá thuhu ra Maria. Núꞌa̱ ra nxutsiꞌa̱ ya xqui tꞌadi pa da ntha̱tui ꞌnara ꞌñøhø mrá thuhu ra Jose núꞌa̱ xqui ꞌñehe desde yá ja̱ꞌi ndu ra nda̱ Davi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ha nura ɛnxɛ bi yʉtꞌa ja rá ngu ra Maria ne bi zɛnjua bi ꞌñembabi: ―¡Ajua̱ xa ma̱ꞌaꞌi ne ꞌbʉi con gueꞌi, ne maꞌna xa ja̱pꞌaꞌi que gatho maꞌra ya ꞌbɛhña̱! ");
INSERT INTO oteNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ha nu mi hyanda ra ɛnxɛꞌa̱ ne mi ꞌyøde bi xipa nuya ya noya, ngu bi ntsu ne himbi ba̱di te mri bønga núꞌa̱ bi xipi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ha nura ɛnxɛ bi ꞌñembabi: ―Maria, oguí tsu, ngueꞌa̱ Ajua̱ xi ri ma̱ꞌaꞌi ne xa huahnꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ne nubyá ma gui ndaꞌthi ma gui pɛꞌtsa ꞌnari tꞌʉ, ne gui hñuꞌmbabi rá thuhu dra JESU. ");
INSERT INTO oteNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Y nuꞌá̱ ma da mɛꞌtsa ꞌnara da̱nga nsu, ngueꞌa̱ nuꞌá̱ go di gueꞌa̱ drá Tꞌʉ Ajua̱ bí ꞌbʉ mahetsꞌi. Y nu Ajua̱ go gueꞌa̱ ma da hñutsꞌi dega nda̱ ja ra hnini Israel ngu bi nda̱ ra Davi núꞌa̱ ꞌna de yá xita mayaꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ne nuꞌá̱ ma da nda̱ ja ra hnini Israel pa nza̱ntho, y hinhyaꞌmʉ da ua rá hmanda. ");
INSERT INTO oteNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nuꞌbʉ́ ra Maria bi ꞌñembabi ra ɛnxɛ: ―¿Hanja da za da njabʉ gue nugui hinstá ntha̱tatho? ");
INSERT INTO oteNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ha nura ɛnxɛ bi ꞌñembabi: ―Ra Ma̱ca Nda̱hi da ꞌñehe da zʉꞌaꞌi ne rá tsꞌɛdi Ajua̱ bí ꞌbʉi mahetsꞌi da ꞌñehe da gopꞌatho ngu ꞌnara guui. Hangue nu sta ꞌmʉi núꞌa̱ ra zi ba̱tsi go di gueꞌa̱ drá ma̱ca Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ne ri prima ra Sabe masque guí handi ya ra da̱quꞌei pe ma da mɛꞌtsa ꞌnará tꞌʉ nehe. Mi hma̱ gue nuꞌá̱ himi tsa da mɛꞌtsa ra ba̱tsi, pe nubyá ya øtꞌa ꞌrato za̱na̱ daꞌthi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngueꞌa̱ pa Ajua̱ otho ni ꞌnara tꞌøtꞌe xá hñei pa gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nepʉ ra Maria bi ꞌñembabi ra ɛnxɛ: ―Rá ꞌbɛgogui Ajua̱, dá ꞌyøtꞌa ngu xcá xicagui. Mi uadi bi ma̱nga ra Maria njabʉ, ra ɛnxɛ bi ma ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","De nuya paꞌʉ mi menga ra ɛnxɛ, bi da̱ma ma ra Maria ja ꞌnara hnini mbi ja ja ra tꞌøhø de ra hai Judea, ");
INSERT INTO oteNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","pa rí zønga ja rá ngu ra Sacaría. Y mi zøni bi yʉtꞌi bi zɛnjua ra Sabe. ");
INSERT INTO oteNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Y nu mi ꞌyøde ra Sabe bi nzɛnjuate ra Maria, ꞌbestho ra oraꞌa̱ bi ꞌña̱nga ra ba̱tsi mbo rá mʉi ra Sabe, y ra Sabe bi hña̱nga ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne bi ña̱ ntsꞌɛdi ne bi ꞌñemba ra Maria: ―Ajua̱ xa ja̱pꞌaꞌi que gatho maꞌra ya ꞌbɛhña̱, nehe xa ja̱pa ri ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nugui hindí ꞌñepcagui e da zøngagui rá na̱na̱ ma Zidadahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngueꞌa̱ nu ndá øde gá nzɛnjuate, numa ba̱tsi co ra johya bi da̱ma ꞌña̱ni mbo ma mʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ajua̱ da ja̱pꞌaꞌi ngueꞌa̱ xcá camfri núꞌa̱ bi xiꞌaꞌi, ngueꞌa̱ ma da njabʉ ngu núꞌa̱ xa xiꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nepʉ bi ꞌñena ra Maria: Nugui xi drí xøcambeni ma zi Hmu con gatho ma mʉi, ");
INSERT INTO oteNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ne xi ri johya ma coraso de núꞌa̱ xa ꞌyøtcagui Ajua̱ ma Pøhøte. ");
INSERT INTO oteNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngueꞌa̱ nugui ꞌnará zi hyoya ꞌbɛgogui Ajua̱, masque njabʉ pe nuꞌá̱ xa huancagui. Desde nubya ya ja̱ꞌi ma da ꞌñengagui gue Ajua̱ xa ja̱pcagui. ");
INSERT INTO oteNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ajua̱ núꞌa̱ xi ja rá tsꞌɛdi xa ꞌyøtca nuya ya da̱nga tꞌøtꞌe, y xi rá nsunda rá thuhuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nuꞌá̱ nza̱ntho ma da nja rá nthecate pa gatho núꞌʉ toꞌo da ꞌyøteꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ne nuꞌá̱ xa ꞌyøtꞌa ya da̱nga ꞌbɛfi co rá da̱nga tsꞌɛdi, ne xa da̱pa gatho núꞌʉ toꞌo mri ꞌñexa sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ne xa hña̱cua yá nsu gatho núꞌʉ toꞌo xi mi ja yá da̱nga nsu, ne go xa gʉxa ya zi hyoya. ");
INSERT INTO oteNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ne gatho núꞌʉ toꞌo mi othobi, bi tꞌumbabi, ha nuꞌʉ tóꞌo mi jabi, bi ꞌñothobi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ne bi maxa ra hnini Israel núꞌʉ pɛpabi, ne himbi pumfri da huequiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Xa ꞌyøtꞌa njabʉ ngu xqui ña̱ꞌtuabi ndu ma dadahʉ ra Abrá ne gatho yá ja̱ꞌi, gue hinhyaꞌmʉ ma da pumfri da huequiꞌʉ. Gueꞌa̱ gatho bi ma̱nga ra Maria. ");
INSERT INTO oteNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ra Maria bi gohuini ra Sabe ngu hñu nza̱na̱ ja rá nguꞌa̱, ne ꞌmɛfa bi menga pa ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nepʉ bi zø ra pa bi ꞌmʉi rá tꞌʉ ra Sabe. ");
INSERT INTO oteNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ne nuꞌbʉ́ gatho yá ꞌnangu ne núꞌʉ mi ja te yá njaui bi ma bá cꞌa̱ꞌtsi pa bi johyaui ngueꞌa̱ bi ꞌyødeꞌʉ gue Ajua̱ xi xqui ja̱piꞌa̱ pa bi ꞌmʉ rá ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ha nurá hña̱to ma pa bi thuꞌtsua ra seña ja rá ndoꞌyo ra ba̱tsi ngu yá nza̱iꞌʉ, ne ja mi ꞌbʉhni maꞌnaꞌqui yá ꞌnangu ne núꞌʉ mi ja te yá njaui. Ne mi beniꞌʉ xa hñuꞌmbabi dra Sacaría nehe ngu rá thuhu rá dada. ");
INSERT INTO oteNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pe nurá na̱na̱ himbi ne, hangue bi ꞌñena: ―Hina, hinga huꞌmbabihʉ njabʉ, ngueꞌa̱ ma da thuꞌmbabi dra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ne bi tꞌembabi ra Sabe: ―¿Hanja ma da thuꞌmbabi njabʉ gue ni ꞌnari ja̱ꞌihʉ hingrá thuhu ra Xuua? ");
INSERT INTO oteNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nepʉ bi tꞌutua ra seña ra Sacaría ndaꞌa̱ ra thuhu mi neꞌa̱ da hñuꞌmbabi ra ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nepʉ nuꞌá̱ ngueꞌa̱ xqui ngone hangue bi ꞌyadi ꞌna xɛni ra xithɛ, ne ja bi ꞌyofoni gue nura ba̱tsi drá thuhu ra Xuua. Y gatho ya ja̱ꞌi xi bi ꞌyø ngueꞌa̱ bi hñuꞌmbabi njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Y ra oraꞌa̱ ꞌbestho bi za bi yopa ña̱ ra Sacaría, ne bi mʉdi bi xøcambeni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y gatho núꞌʉ yá ꞌnangu xi bi ntsu, ne gatho ja ya tꞌøhø de Judea habʉ mi ꞌbʉ ya ja̱ꞌi bi ꞌño ra ꞌbede de núꞌa̱ xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ne gatho núꞌʉ toꞌo mi pa̱di mi ꞌyo yá mfeniꞌʉ ne mri ꞌñámbabi ꞌna ngu maꞌna, ne mi enaꞌʉ: ―¿Te ma nsu ma da tꞌumbabi núꞌa̱ ra ba̱tsiꞌa̱ ꞌbʉ? Mi ma̱nga njabʉꞌʉ ngueꞌa̱ Ajua̱ mi ja̱piꞌa̱ co rá tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nura Sacaría rá dada ra ba̱tsi mi ha̱npa rá tsꞌɛdi ra Ma̱ca Nda̱hi bi ma̱nga ꞌraya noya ngu Ajua̱ bi ꞌñutuabi da ma̱, ne bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Xá nsunda Ajua̱ ma zi Hmuhʉ nújʉ dyá me Israelhʉ, ngueꞌa̱ nuya pabya ma da ꞌñehe ꞌna toꞌo da pøhøguihʉ nújʉ go rá hniniguihʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nuya pabya ma dua pɛncahʉ ꞌnara Pøhøte núꞌa̱ xi ja rá tsꞌɛdi. Nuꞌá̱ ma da ꞌñehe desde yá ja̱ꞌi ndu ra nda̱ Davi núꞌa̱ mrá ꞌbɛgo Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gueꞌa̱ bi ña̱tcaguihʉ Ajua̱ ngu núꞌa̱ bi ma̱nga yá ma̱ca ꞌmɛhniꞌa̱ desde mayaꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bi ña̱tcahʉ gue da ña̱ngaguihʉ de ma ncontrahʉ ne de gatho núꞌʉ toꞌo ri ʉtsaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nehe mi ma̱ gue mi ma da mɛꞌtsua ra nthecate ndu ma xitahʉ, ne hinhyaꞌmʉ mi ma da pumfri núꞌa̱ ra ma̱ca cohi xqui gohuiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Guehna ra cohi bi ꞌyøtꞌa Ajua̱ co ndu ma dadahʉ ra Abrá, ");
INSERT INTO oteNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","gue mi ma da ña̱ngaguihʉ de ma ncontrahʉ pa ga pɛpabihʉꞌa̱ nsinque ꞌnara ntsu, ");
INSERT INTO oteNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ne ga ꞌyohʉ xá hño ne ga ꞌbʉhʉ xá ntꞌaxi ja rá thandiꞌa̱ gatho ya pa de ma tehʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y ra Sacaría bi ꞌñemba rá ba̱tsi: Nuꞌi ma zi tꞌʉꞌi, go gueꞌi ma drá ꞌmɛhniꞌi Ajua̱ bí ꞌbʉ mahetsꞌi, ngueꞌa̱ go ma gui ꞌbɛtꞌo de ra Zidada pa gui hocua rá ꞌñuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nuꞌi go ma gui zopabi rá hnini Ajua̱ pa da ba̱diꞌʉ ra Pøhøte ne da mpøhøꞌʉ, ne da zʉdi ra pumbate de yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ngueꞌa̱ Ajua̱ xa mɛscahʉ ra hma̱te ne ra nthecate, hangue nuꞌá̱ ma da mɛncahʉ ꞌnara hyatsꞌi desde mahetsꞌi pa go gueꞌa̱ da yotca ma mfenihʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nehe pa da yoꞌtua yá mfeni gatho núꞌʉ ꞌbʉ ja ra ꞌbɛxuui ne núꞌʉ rí ma ja ra ꞌñu dega du. Hangue nuꞌá̱ ma da ꞌñehe pa da yotcahʉ ꞌnara ꞌñu xá hño pa grá ꞌbʉhʉ te rá ꞌñentho. Nuna guehna bi ma̱nga ra Sacaría. ");
INSERT INTO oteNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y nura zi Xuua ꞌyo mri teꞌa̱ ne ꞌyo mi umba ra tsꞌɛdi ra Ma̱ca Nda̱hi. Ne bá ꞌbʉi ja ra mbonthi asta bi zø ra pa bi mʉdi bi zofo ya me Israel. ");
INSERT INTO oteNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","De nuya paꞌʉ, nura da̱nga nda̱ Augusto Cesa bi manda da tꞌopabi yá thuhu gatho ya ja̱ꞌi de maxøgue ra hai habʉ mrá nda̱ꞌa̱, pa da ꞌbedeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gueꞌbʉ mrá gobierhnu ra Cirenio ja ra hai Siria núꞌbʉ bi nja nuna ra mʉdi padro. ");
INSERT INTO oteNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gatho ya ja̱ꞌi mi pɛꞌtsi da menga ja yá hnini cada ꞌna habʉ myá mengu, pa da tꞌopabi yá thuhuꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hangue ra Jose bi bønga de ja ra hnini Nasare de ra hai Galilea pa bi ma ja ra hnini Belé de ja ra hai Judea, ngueꞌa̱ ja mrá menguni ndu ra nda̱ Davi, ha nura Jose ja xqui ꞌñehni de ja yá ja̱ꞌi ra Davi. ");
INSERT INTO oteNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bi ma ja ra hnini Belé pa da tꞌopabi yá thuhuꞌʉ, bi mɛui ra Maria núꞌa̱ xqui ꞌyadi pa da ntha̱tui, ha nuꞌá̱ ya mi daꞌthi de rá ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ha de mbi ꞌbʉiꞌʉ ja ra hnini Belé, bi zø ra pa da ꞌmʉi rá ba̱tsi ra Maria. ");
INSERT INTO oteNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ha de guehni bi ꞌmʉ rá mʉdi tꞌʉ, bi mantꞌi co yá ꞌmantꞌi, ne bi mɛgui habʉ mi ja ꞌnara hñunga mboꞌni, ngueꞌa̱ ya mi otho habʉ da tꞌumba ntsayaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ne de guehni guetbʉ de ra hnini Belé mi ꞌbʉhni ꞌraya maꞌyo ja ra mbonthi mi su yá dɛti dega xuui. ");
INSERT INTO oteNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nepʉ nuꞌʉ́ mi da̱mfri bi hyandua ꞌnará ɛnxɛ Ajua̱, ne ꞌnara da̱nga hyatsꞌi bi yotꞌa gatho rá nthetsꞌi habʉ mi ꞌbʉiꞌʉ, y ra oraꞌa̱ xi bi ntsuꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pe nura ɛnxɛ bi ꞌñembabiꞌʉ: ―Oguí tsuhʉ, ngueꞌa̱ drá ꞌñehe ga xiꞌahʉ ꞌraya hoga noya núꞌʉ pa xi gui johyahʉ nuꞌahʉ ne gatho maꞌra ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngueꞌa̱ nubya xa ꞌmʉi ja rá hnini ndu ra nda̱ Davi ꞌnara Pøhøte pa gueꞌahʉ, y núꞌá̱ go gueꞌa̱ ra Cristo ra zi Hmu bá ꞌbɛhni pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Y po má nseña gui tsʉhʉ ra ba̱tsi xa ꞌbantꞌi co yá ꞌmantꞌi ne xa ꞌbɛgui habʉ ja ꞌnara hñunga mboꞌni. ");
INSERT INTO oteNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Y de mi uadi bi ma̱nga njabʉ nura ɛnxɛꞌa̱, mi da̱mfriꞌʉ bi hyanda maꞌra ya ɛnxɛ de mahetsꞌi mi hnequi mahyɛgui con gueꞌa̱, mri xøcambeni Ajua̱ ne mi eñꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Drá nsunda Ajua̱ bí ꞌbʉ mahetsꞌi, ne dá ꞌmʉi co ꞌnara hogaꞌmʉi ya meximhai núꞌʉ xa zʉtua rá hma̱teꞌa̱! ");
INSERT INTO oteNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nepʉ nu mi menga ya ɛnxɛ pa mahetsꞌi ya maꞌyo bi mʉdi bi ꞌñémbabi ꞌna ngu maꞌna: ―Maha Belé, ma ga cꞌa̱ꞌtshʉ te xuá nja de guehni de núꞌa̱ xa xicaguihʉ rá ɛnxɛ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nepʉ nuꞌʉ́ bi ma hnestꞌihi, y bi zøni bi zʉdiꞌʉ ra Jose ne ra Maria co rá ba̱tsi núꞌa̱ mi ꞌbɛni ja ꞌnara hñunga mboꞌni. ");
INSERT INTO oteNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Y núꞌʉ ya maꞌyo mi hyanda ra ba̱tsi, bi mʉdi bi mede gatho núꞌa̱ xqui xipabi ra ɛnxɛ de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ha gatho núꞌʉ bi ꞌyøde xi bi ꞌyø de núꞌa̱ mi ma̱ñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pe nura Maria xi mi pɛꞌtstho ja mbo rá mfeni nuya ya noya pa da bentho. ");
INSERT INTO oteNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nepʉ nuya maꞌyo bi mengui xi mri xøcambeni Ajua̱ por gatho núꞌa̱ xqui ꞌyøde ne xqui hyandi, ngueꞌa̱ nuꞌʉ́ xqui zʉdi ngu núꞌa̱ xqui sipabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ne rá hña̱to ma pa de xqui ꞌmʉ ra ba̱tsi, bi thuꞌtsua ra seña ja rá ndoꞌyo ngu yá nza̱iꞌʉ. Ne bi thuꞌmbabi ra JESU ngueꞌa̱ gueꞌa̱ xqui xipabi ra ɛnxɛ ra Maria desde ante da ndaꞌthi de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y nu mi ua yá pa ra Maria bi ntꞌaxqui pa da yopa yʉtꞌa ja ra nija̱ maꞌnaꞌqui ngu xqui ꞌyofo ra Moise ja ra ley, nepʉ ra Jose ne ra Maria bi zixa ra zi ba̱tsi pa ja ra nda̱nija̱ Jerusale pa dí dapabi ja rá ꞌyɛ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bi ꞌyøtꞌa njabʉꞌʉ ngueꞌa̱ xqui tꞌofo ja rá ley Ajua̱ gue gatho núꞌʉ ya mʉdi ba̱tsi da ꞌmʉi ne ꞌbʉ dya tsꞌʉntꞌʉ gueꞌʉ mahyoni da tꞌeque pa Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nehe bi maꞌʉ ja ra nda̱nija̱ pa bi hña̱ꞌtsuabi ra ꞌbaha Ajua̱, ngueꞌa̱ njabʉ ena ja rá ley Ajua̱ gue ꞌbʉ ꞌnara ꞌbɛhña̱ da ꞌmʉ rá ba̱tsi, mahyoni da zixa yoho ya zi joñꞌo o yoho ya zi domitsu pa ja dí hyopabini Ajua̱ dega ꞌbaha. ");
INSERT INTO oteNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","De nuya paꞌʉ, mi ꞌbʉ ꞌnara ꞌñøhø nuni Jerusale mrá thuhu ra Simiu. Núꞌá̱ xi mi ꞌyo xá hño ja rá thandi Ajua̱, ne mi tøꞌmi da hyanda ra Ña̱nte núꞌa̱ toꞌo ma da ña̱ni ya me Israel, ne nurá Ma̱ca Nda̱hi Ajua̱ mi ꞌbʉi con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ne go gueꞌa̱ xqui xipabi Ajua̱ gue hinda du asta hinda hyanda ra Cristo núꞌa̱ xqui ma̱ Ajua̱ ma dua pɛhni. ");
INSERT INTO oteNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nuꞌá̱ xqui ma ja ra nda̱nija̱ ngueꞌa̱ ra Ma̱ca Nda̱hi xqui tsitsꞌi, y ra oraꞌa̱ mi ꞌbʉhni mbo, bi yʉtꞌa ra Jose nehe co ra Maria mri zi ra zi tꞌʉca Jesu pa e da ꞌyɛntꞌua ja rá ꞌyɛ Ajua̱ ngu xqui ma̱nga rá ley Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nepʉ de guehni ra Simiu bi zinga ra tꞌʉca ꞌuɛne ne bi ꞌyɛntsꞌa ja yá ꞌyɛ ne bi xøcambeni Ajua̱ bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nuꞌi Ajua̱ ma Dadaꞌi, ya da za gui tsixcagui de guecua, ya bi hñu ma mʉi ngueꞌa̱ ya stá handi xa njabʉ ngu núꞌa̱ gá xicagui. ");
INSERT INTO oteNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ya stá handi co ma da ra Pøhøte, ");
INSERT INTO oteNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","núna xcuá pɛhni pa da pøhø gatho ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nuna go guehna ngu ꞌnara ñotꞌi pa da yoꞌtua yá mfeni gatho núꞌʉ hingyá me Israel, y po rá nguehna ma da nja rá nsu ri hnini Israel. ");
INSERT INTO oteNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ha nura Jose ne ra Maria rá na̱na̱ ra Jesu mi ꞌyøde núꞌʉ ya noya mi ma̱nga ra Simiu de ra tꞌʉca ꞌuɛne, núꞌʉ́ xi bi ꞌyøꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nepʉ nura Simiu bi ꞌyapa Ajua̱ da ja̱piꞌʉ. Ne bi ꞌñembabi ra Maria rá na̱na̱ ra Jesu: ―Nuna ꞌuɛne xuá ꞌbɛhni pa da pøhø ndunthi ya me Israel, pe ndunthi de gueꞌʉ ma da ʉtsa ne da ꞌmɛdiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Y njabʉ po rá ngue ri tꞌʉ ma da hnequi gatho núꞌa̱ beni ja yá mfeni cada ꞌnara ja̱ꞌi. Y pa gueꞌi ma gui thogui ꞌnara da̱nga dumʉi ngueꞌa̱ ma da tꞌʉtsaꞌi ri tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ne mi ꞌbʉ ꞌnara ꞌbɛhña̱ mrá thuhu ra Ana núꞌa̱ mi ña̱ co rá tsꞌɛdi rá Ma̱ca Nda̱hi Ajua̱. Y núꞌa̱ ra ꞌbɛhña̱ꞌa̱ mrá tꞌixu ꞌnara ꞌñøhø mrá thuhu ra Fanuel, xqui ꞌñehe desde yá ja̱ꞌi ndu ra Aser. Y nuꞌá̱ ya xi mrá zi da̱quꞌei. Núꞌbʉ xi mrá ba̱tsa nxutsitho bi ntha̱ti, ne nsøcta yoto njɛya bi ꞌmʉhui rá da̱me. ");
INSERT INTO oteNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Y ya mi øtꞌa gohoꞌrate ma goho njɛya xqui mviuda. Nuꞌá̱ himi pøni de ja ra nija̱, ngueꞌa̱ nza̱ntho mi pɛpabi Ajua̱ ma pa ra xuui, mri ayuna ne xi mi apabi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ora mi ꞌbʉhni ra Jose ne ra Maria co ra tꞌʉꞌuɛne mbo ra nda̱nija̱, ra oraꞌa̱ bi yʉtꞌa ra Ana nehe, ne bi umba njama̱di Ajua̱. Nepʉ bi mʉdi bi xipabi de ra zi ba̱tsi núꞌʉ toꞌo gatho mi tøꞌma ra Ña̱nte núꞌa̱ toꞌo da ña̱nga ra hnini Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nepʉ mi uadi ra Jose ne ra Maria bi ꞌyøtꞌa gatho ngu núꞌa̱ xqui manda ja rá ley Ajua̱, bi menga pa ja yá hnini Nasare de ja ra hai Galilea. ");
INSERT INTO oteNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","De guehni ra ba̱tsi mri ꞌyo rá te, ne ꞌyo mri nja rá tsꞌɛdi, ne ꞌyo mri nja rá mfa̱di, y Ajua̱ mi ja̱pabi ndunthiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tatꞌa jɛya mi pa ra Jose ne ra Maria pa da nu ra ngo de ra pascua nuni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Y de mi juata ꞌrɛtꞌamayoho njɛya ra Jesu, bi ma ri hñuꞌʉ pa Jerusale pa da nu ra ngo ngu myá nza̱iꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Y nu mi ua ra ngo, bá penga ra Jose ne ra Maria, ha nura Jesu bá cohi de guehni Jerusale nsinque bi ba̱ rá na̱na̱ ne ra Jose. ");
INSERT INTO oteNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nuꞌʉ́ mi hu yá mʉi gue mbra ꞌñoui maꞌra ya ja̱ꞌi núꞌʉ bá pengüi ja ra ngo. Bi ꞌño maxøgue ꞌna pa ra ꞌñu, asta ja ꞌmɛfa bi ꞌñaniꞌʉ ra ba̱tsi, bi ꞌño bi ꞌyambabi núꞌʉ mi ja te yá njaui ne yá mpa̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pe himbi zʉdiꞌʉ de guehni, hangue bi yopa menguiꞌʉ pa Jerusale pa dua honi. ");
INSERT INTO oteNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nepʉ rá hñupa bi zʉdi mi ꞌbʉhni mbo ja ra nda̱nija̱ mi huhni madetho de ya xahnate de ra ley mi østho núꞌa̱ te mi ma̱ñꞌʉ nepʉ nuꞌá̱ mi øꞌtua ya ntꞌaniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gatho núꞌʉ ya ja̱ꞌi toꞌo mi øde núꞌa̱ mi ma̱ñꞌa̱ xi mri ꞌyø ngueꞌa̱ xi mi ja rá mfa̱diꞌa̱ ne mi tha̱di xá hño núꞌʉ ya ntꞌani mi tꞌøꞌtuabi nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Y nu mi hyanda rá na̱na̱ ne ra Jose gue mi huhni co ya xahnate de ra ley, himi pa̱di te da beñꞌʉ. Y nurá na̱na̱ bi ꞌñembabi: ―Ma zi tꞌʉꞌi, ¿hanja xcá ꞌyøtcahe njabʉ? Nugui ne ri dada go dí hoñꞌahe co ndunthi ra dumʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pe ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―¿Pa te gui jacjʉ guí hongaguihʉ? ¿Ha hinguí pa̱hʉ gue nugui mahyoni ga pɛpa rá ꞌbɛfi ma Dada? ");
INSERT INTO oteNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pe nuꞌʉ́ nixi mi pa̱di te mri bønga núꞌʉ ya noya bi xipabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nepʉ de guehni bi mɛui rá na̱na̱ ne ra Jose bi mencꞌʉ pa ja ra hnini Nasare, ne nuꞌá̱ bi sigui bi ꞌyøtua yá tsꞌofoꞌʉ. Ha nurá na̱na̱ mi pɛꞌstho ja rá mfeni gatho núꞌa̱ te bi nja co rá tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y nura Jesu ꞌyo mri te rá mfa̱di ne rá nda̱ngui, ne Ajua̱ xi bi hopa rá ꞌmʉiꞌa̱, ne ya ja̱ꞌi nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","De ya xqui nda̱ ꞌrɛtꞌamacʉtꞌa njɛya ra da̱nga nda̱ Tiberio Cesa núꞌa̱ mi ꞌbʉ Nroma ne mrá nda̱ ja ndunthi ya hai de ra ximhai, nehe gueꞌbʉ mrá nda̱ ra Poncio Pilato nuni ja ra hai Judea, nehe mrá nda̱ ra Erode nuni ja ra hai Galilea, nehe mrá nda̱ nurá cu ra Erode núꞌa̱ mrá thuhu ra Lipe nuni ja ra hai Iturea ne ja ra hai Traconite, nehe mrá nda̱ ra Lisania nuni ja ra hai Abilinia. ");
INSERT INTO oteNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Gueꞌbʉ myá da̱nga nda̱ gá macja̱ ra Anás ne ra Caifá. Ha de nura jɛyaꞌa̱ Ajua̱ bi umba ya noya ra Xuua núꞌa̱ mrá tꞌʉ ra Sacaría de mbi ꞌbʉ ja ra mbonthi, pa da zo ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nuꞌbʉ́ ra Xuua bi ma gatho rá nthetsꞌi ra da̱the Jordá, ne mi embabi ya ja̱ꞌi gue da ñobri de yá tsꞌoqui ne da nxistehe pa njabʉ Ajua̱ da pumbabi yá tsꞌoquiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Núꞌá̱ njabʉ bi zofo ya ja̱ꞌi gue da hñoquiꞌʉ ja yá mfeni pa nu sta zø ra zi Hmu da gamfriꞌʉ, hangue bi njabʉ ngu núꞌa̱ xqui ꞌyofo ra ba̱di Isaía ja ra Ma̱ca Tꞌofo nu habʉ ena: Ma da ntꞌøde ꞌnara ja̱ꞌi da ña̱ ntsꞌɛdi ja ra mbonthi ne ma da ꞌñena: “Hocuahʉ xá hño rá ꞌñu ra zi Hmu, jua̱nhʉ gatho ya tsꞌacaꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gatho ya hñe dra hñuꞌtsi, ne dra tʉnga ya nda̱ntsꞌi, ne dra yøꞌta ya tꞌøhø, ne dra jua̱na ya nøntsꞌaꞌñu, ne da thoqui gatho habʉ hindi ꞌbʉi xá hño. ");
INSERT INTO oteNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y gatho ya ja̱ꞌi da hyandi te xa ꞌyøtꞌa Ajua̱ pa da mpøhøꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nepʉ mi pa ya ja̱ꞌi mi cꞌa̱ꞌtsa ra Xuua pa da xiꞌtsiꞌʉ, y nuꞌá̱ mi embabiꞌʉ: ―¡Gyá tsꞌoja̱ꞌihʉ ngu ya zate quꞌeña̱! ¿Ha guí hu ri mʉihʉ gue ngueꞌa̱ xcá ehʉua ya xcá ꞌbaꞌtuahʉ rá cuɛ Ajua̱ xa ꞌñepʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mahyoni gui ꞌyohʉ xá hño pa da hnequi gue majua̱ni xcá ñobrihʉ de ri tsꞌoquihʉ. Oxqui ma gui ꞌñexhʉ gui ꞌñeñhʉ: “Nuje ma dadahe ndu ra Abrá, hangue hinte ga jahe.” Ngueꞌa̱ nugui dí xiꞌahʉ gue Ajua̱ da za da japi da nja̱ꞌi nuya ya do pa dyá tꞌʉ ra Abrá. ");
INSERT INTO oteNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dí xiꞌahʉ gue ꞌbʉi guetbʉ Ajua̱, ngu ꞌna toꞌo ha̱ ra tꞌɛ́gui pa da zɛcua yá ꞌyʉ ya za. Gatho núꞌʉ ya za hingui unga yá hoga fruta ma da tsꞌɛtꞌi ne da thøtꞌa ja ra tsibi. Njabʉ Ajua̱ ma da hyøtꞌahʉ ja ra nidu ꞌbʉ hingui ñobrihʉ ne gui ꞌyohʉ xá hño. ");
INSERT INTO oteNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nepʉ nuya ja̱ꞌi bi ꞌyamba ra Xuua ne bi ꞌñembabi: ―Nuꞌbʉ́ ¿te mahyoni ga øthebya? ");
INSERT INTO oteNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nuꞌbʉ́ ra Xuua bi ꞌñembabi: ―Nuꞌa̱ tóꞌo pɛꞌtsa yoho yá pahni, dá umba ꞌna núꞌa̱ toꞌo othobi. Ha nuꞌa̱ tóꞌo pɛꞌtsa te da zi, mahyoni da ñohui núꞌa̱ toꞌo othobi. ");
INSERT INTO oteNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nehe bi ma bá cꞌa̱ꞌtsa ra Xuua ꞌraya ꞌña̱tsa ngʉxboja̱. Núꞌʉ́ bi ma da nxistehe nehe, ne bi ꞌyambabi ra Xuua ne bi ꞌñembabi: ―Xahnate, xi nuje, ¿te mahyoni ga øthe? ");
INSERT INTO oteNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ha nura Xuua bi ꞌñembabi: ―Nuꞌa̱ mahyoni gui ꞌyøthʉ, cobrahʉ ngu núꞌa̱ ma̱nga ra ley, oguí cømbahʉ yá boja̱ ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nehe ꞌraya soldado bi ꞌñembabi ra Xuua: ―Xi nuje, ¿te mahyoni ga øthe? Ha nura Xuua bi ꞌñembabi: ―Oto guí pepabihʉ, ne oguí pihʉ ya ja̱ꞌi co núꞌa̱ ra nsu xa tꞌaꞌahʉ, nixi gui hyøxhʉ ra thai ya ja̱ꞌi. Nuꞌa̱ gui ꞌyøthʉ, johyahʉ co núꞌa̱ guí ta̱ha̱hʉ, oguí nehʉ maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ha nuya ja̱ꞌi himi pa̱di te da beni de ra Xuua, ua go mi gueꞌa̱ ra Cristo núꞌa̱ xqui hma̱ da ꞌbɛhni pa da nda̱, ua hina. ");
INSERT INTO oteNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nepʉ nura Xuua bi ꞌñembabiꞌʉ: ―Nugui dí xiꞌtsꞌaꞌihʉ co ra dehe, pe bra ꞌbɛfa maꞌna núꞌa̱ toꞌo ma da xiꞌtsꞌaꞌihʉ co ra Ma̱ca Nda̱hi ne asta ngu di faspi co rá tsꞌɛdi. Núꞌá̱ maꞌna ja rá tsꞌɛdi de guequi ne hiní ꞌñepcagui ngugui ga xoꞌtuabi yá ntha̱sthi de yá zɛsthi. ");
INSERT INTO oteNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nuꞌá̱ nja ngu ꞌnara mɛfi ya o ja rá ꞌyɛ ra pala pa da mica ra trigo, y nu stí uadi da miquiꞌa̱, da muntsꞌi da mɛꞌtsi, ha nura paha da ga̱tꞌa ja ra tsibi. Njabʉtho nehe núꞌa̱ bra ꞌbɛfa de guequi ma da muntsꞌa núꞌʉ di ꞌyo xá hño pa da ꞌmʉi con gueꞌa̱, ha nuꞌʉ hindi ꞌyo xá hño ma da hyøtꞌa ja ra tsibi. ");
INSERT INTO oteNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Njabʉ ne co maꞌra ya hoga tsꞌofo ra Xuua mi utua ya ja̱ꞌi de ra ma̱ca hoga tꞌøde. ");
INSERT INTO oteNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Y núꞌbʉ́ gueꞌbʉ bi zʉiꞌa̱ ra nda̱ Erode ngueꞌa̱ xqui zimbabi rá ꞌbɛhña̱ rá cu núꞌa̱ mrá thuhu ra Lipe, ne xqui ꞌyøtꞌa maꞌra ya tꞌøtꞌe xá ntsꞌo. ");
INSERT INTO oteNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pe nura Erode himbi ne bi ntsøꞌmi. Nuꞌa̱ bi ꞌyøtꞌe, bi ꞌyøtꞌa maꞌna ra tꞌøtꞌe xi xá ntsꞌo, bi gʉ ra Xuua ne bi gotꞌa fadi. ");
INSERT INTO oteNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pe ante dra jʉ ra Xuua da jotꞌa fadi, bi ma ra Jesu habʉ mi xiꞌtsateꞌa̱ pa da nxisteheꞌa̱ nehe. Ne tsꞌa mi apabi Ajua̱ ra Jesu, bi xogui mahetsꞌi, ");
INSERT INTO oteNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y nurá Ma̱ca Nda̱hi Ajua̱ bá ca̱i ngu ꞌnara domitsu bi zøhø ja gueꞌa̱. Ne bi ntꞌøde ꞌnara noya de mahetsꞌi bi ꞌñena: ―Nuꞌi go gueꞌi ma hma̱ca Tꞌʉꞌi, xi drí johya de gueꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ra Jesu mi pɛꞌtsa ngu ꞌnatemaꞌrɛtꞌa njɛya nu mi mʉta rá ꞌbɛfi. Ne mi tꞌena gue nurá dadaꞌa̱ go mrá Jose. Ha nurá dada ra Jose mrá thuhu ra Elí, ");
INSERT INTO oteNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ha nurá dada ra Elí mrá thuhu ra Matat, ha nurá dada ra Matat mrá thuhu ra Leví, ha nurá dada ra Leví mrá thuhu ra Melqui, ha nurá dada ra Melqui mrá thuhu ra Jana, ha nurá dada ra Jana mrá thuhu ra Jose nehe, ");
INSERT INTO oteNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ha nurá dada núꞌa̱ maꞌna ra Jose mrá thuhu ra Matatía, ha nurá dada ra Matatía mrá thuhu ra Amós, ha nurá dada ra Amós mrá thuhu ra Naum, ha nurá dada ra Naum mrá thuhu ra Esli, ha nurá dada ra Esli mrá thuhu ra Nagai, ");
INSERT INTO oteNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ha nurá dada ra Nagai mrá thuhu ra Maat, ha nurá dada ra Maat mrá thuhu ra Matatía nehe, ha nurá dada núꞌa̱ maꞌna ra Matatía mrá thuhu ra Semei, ha nurá dada ra Semei mrá thuhu ra Jose nehe, ha nurá dada núꞌa̱ maꞌna ra Jose mrá thuhu ra Judá, ");
INSERT INTO oteNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ha nurá dada ra Judá mrá thuhu ra Joana, ha nurá dada ra Joana mrá thuhu ra Resa, ha nurá dada ra Resa mrá thuhu ra Sorobabel, ha nurá dada ra Sorababel mrá thuhu ra Salatiel, ha nurá dada ra Salatiel mrá thuhu ra Neri, ");
INSERT INTO oteNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ha nurá dada ra Neri mrá thuhu ra Melqui nehe, ha nurá dada núꞌa̱ maꞌna ra Melqui mrá thuhu ra Adi, ha nurá dada ra Adi mrá thuhu ra Cosam, ha nurá dada ra Cosam mrá thuhu ra Elmodam, ha nurá dada ra Elmodam mrá thuhu ra Er, ");
INSERT INTO oteNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ha nurá dada ra Er mrá thuhu ra Josué, ha nurá dada ra Josué mrá thuhu ra Elieser, ha nurá dada ra Elieser mrá thuhu ra Jorim, ha nurá dada ra Jorim mrá thuhu ra Matat nehe, ");
INSERT INTO oteNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ha nurá dada núꞌa̱ maꞌna ra Matat mrá thuhu ra Leví nehe, ha nurá dada núꞌa̱ maꞌna ra Leví mrá thuhu ra Simiu, ha nurá dada ra Simiu mrá thuhu ra Judá nehe, ha nurá dada núꞌa̱ maꞌna ra Judá mrá thuhu ra Jose nehe, ha nurá dada núꞌa̱ maꞌna ra Jose mrá thuhu ra Jonán, ha nurá dada ra Jonán mrá thuhu ra Eliaquim, ");
INSERT INTO oteNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ha nurá dada ra Eliaquim mrá thuhu ra Melea, ha nurá dada ra Melea mrá thuhu ra Mainán, ha nurá dada ra Mainán mrá thuhu ra Matata, ha nurá dada ra Matata mrá thuhu ra Natán, ");
INSERT INTO oteNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ha nurá dada ra Natán mrá thuhu ra Davi, ha nurá dada ra Davi mrá thuhu ra Isaí, ha nurá dada ra Isaí mrá thuhu ra Obed, ha nurá dada ra Obed mrá thuhu ra Boos, ha nurá dada ra Boos mrá thuhu ra Salmón, ha nurá dada ra Salmón mrá thuhu ra Naasón, ");
INSERT INTO oteNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ha nurá dada ra Naasón mrá thuhu ra Aminadab, ha nurá dada ra Aminadab mrá thuhu ra Aram, ha nurá dada ra Aram mrá thuhu ra Esrom, ha nurá dada ra Esrom mrá thuhu ra Fare, ha nurá dada ra Fare mrá thuhu ra Judá nehe, ");
INSERT INTO oteNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ha nurá dada núꞌa̱ maꞌna ra Judá mrá thuhu ra Cobo, ha nurá dada ra Cobo mrá thuhu ra Isaac, ha nurá dada ra Isaac mrá thuhu ra Abrá, ha nurá dada ra Abrá mrá thuhu ra Taré, ha nurá dada ra Taré mrá thuhu ra Nacor, ");
INSERT INTO oteNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ha nurá dada ra Nacor mrá thuhu ra Serug, ha nurá dada ra Serug mrá thuhu ra Ragau, ha nurá dada ra Ragau mrá thuhu ra Peleg, ha nurá dada ra Peleg mrá thuhu ra Eber, ha nurá dada ra Eber mrá thuhu ra Sala, ");
INSERT INTO oteNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ha nurá dada ra Sala mrá thuhu ra Cainán, ha nurá dada ra Cainán mrá thuhu ra Arfaxad, ha nurá dada ra Arfaxad mrá thuhu ra Sem, ha nurá dada ra Sem mrá thuhu ra Noé, ha nurá dada ra Noé mrá thuhu ra Lamec, ");
INSERT INTO oteNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ha nurá dada ra Lamec mrá thuhu ra Matusale, ha nurá dada ra Matusale mrá thuhu ra Enoc, ha nurá dada ra Enoc mrá thuhu ra Jared, ha nurá dada ra Jared mrá thuhu ra Maalaleel, ha nurá dada ra Maalaleel mrá thuhu ra Cainán nehe, ");
INSERT INTO oteNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ha nurá dada núꞌa̱ maꞌna ra Cainán mrá thuhu ra Enós, ha nurá dada ra Enós mrá thuhu ra Set, ha nurá dada ra Set mrá thuhu ra Adá, ha nurá Dada ra Adá, go gueꞌa̱ Ajua̱ bí ꞌbʉ mahetsꞌi, ngueꞌa̱ go bi hyoquiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mi uadi bi nxistehe ra Jesu bi ma de guehni ja ra da̱the Jordá mi ha̱npa rá tsꞌɛdi ra Ma̱ca Nda̱hi. Nepʉ ra Ma̱ca Nda̱hi bi zitsꞌi ja ꞌnara mbonthi. ");
INSERT INTO oteNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne ja bá ꞌbʉhni ñote ma pa. Y de guehni bi zø ra tsꞌonda̱hi habʉ mi ꞌbʉiꞌa̱ pa da xaxi pa xa̱ma̱ xa tsꞌocuahma̱ rá mfeniꞌa̱. Ne nura Jesu hinte xqui zi de núꞌʉ ñote ma paꞌʉ, ja ꞌmɛfa bi zʉ ra thuhu. ");
INSERT INTO oteNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nepʉ de mi zʉ ra thuhuꞌa̱, ra tsꞌonda̱hi bi ꞌñembabi: ―ꞌBʉ go gueꞌi rá Tꞌʉꞌi Ajua̱, japabi xa̱ da nthuhme nuna ra do. ");
INSERT INTO oteNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―Xa ntꞌofo ja ra Ma̱ca Tꞌofo habʉ ena njaua: “Hingue hønsɛ po ra thuhme da za da ꞌmʉ ra ja̱ꞌi, gatho núꞌa̱ ma̱ Ajua̱ go gueꞌa̱ umba rá te ra ja̱ꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nepʉ de guehni ra tsꞌonda̱hi bi zixa ra Jesu ja ꞌnara tꞌøhø xi xmá hñetsꞌi pa bi ꞌñutua gatho ya hnini de maxøgue ra ximhai, y ꞌbestho ra oraꞌa̱ bi hnequi gatho ya hnini. ");
INSERT INTO oteNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y nura tsꞌonda̱hi bi ꞌñembi: ―Nugui da za ga ꞌraꞌa gatho ra tsꞌɛdi ne gatho ra da̱nga nsu de nuya ya hnini, ngueꞌa̱ go xa tꞌɛntcꞌa ma ꞌyɛ gathoyʉ, y nugui da za ga umbabi toꞌo go ga nega. ");
INSERT INTO oteNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hønsɛ ꞌbʉ gui ndandiña̱hmu ne gui nsundagui, gatho go da ꞌyo ri ꞌyɛyʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pe nura Jesu bi da̱di ne bi ꞌñembabi: ―ꞌUegue de guequi, nuꞌi Satá. Ngueꞌa̱ xa ntꞌofo ja ra Ma̱ca Tꞌofo gue Ajua̱ ri Hmu go gueꞌa̱ gui nsunda, ne hønsɛꞌa̱ gui pɛpabi. ");
INSERT INTO oteNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nepʉ de guehni ra tsꞌonda̱hi bi zixa ra Jesu ja ra hnini Jerusale ne bi pøꞌtsa asta xi maña̱ ra nda̱nija̱ ne bi ꞌñembabi: ―ꞌBʉ go gueꞌi rá Tꞌʉꞌi Ajua̱, ꞌyɛnga ra sagui pa rí gaꞌti xa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Cabo xa ntꞌofo ja ra Ma̱ca Tꞌofo habʉ ena: Ajua̱ dua pɛhna yá ɛnxɛ pa da suꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ne da mipꞌa ri ꞌyɛ pa njabʉ hingui tsamaꞌñʉ ri ua nu xcrí tsønga ja ra hai. ");
INSERT INTO oteNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―Nehe xa ntꞌofo ja ra Ma̱ca Tꞌofo habʉ ena: “Oguí xaxa Ajua̱ ri Hmu pa gui ꞌñena gue da maxꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y nu mi uadi ra tsꞌonda̱hi bi ꞌyøtꞌa gatho ngu núꞌa̱ xqui ꞌyɛꞌmbi pa xa hyathma̱ ra Jesu, nuꞌá̱ bi ꞌuegue de ra Jesu ꞌraya pa. ");
INSERT INTO oteNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","De guehni ra Jesu bi menga pa ja rá hai Galilea mi ha̱npa rá tsꞌɛdi ra Ma̱ca Nda̱hi, y bi ꞌño rá ꞌbedeꞌa̱ ja gatho rá ngʉni nura haiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y núꞌá̱ mi cʉtꞌa ja ya nija̱ pa mi utuate, ne gatho ya ja̱ꞌi mi eꞌtsua rá nsuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nepʉ nura Jesu bi ma pa Nasare núꞌa̱ ra hnini habʉ xqui nteꞌa̱. Y ra pa dega tsaya bi yʉtꞌa ja ra nija̱ ngu mrá nza̱iꞌa̱, ne ja bi ꞌmaini pa da hñeꞌta ra Ma̱ca Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ne bi tꞌumbabi núꞌa̱ ra tꞌofo xqui ꞌyofo ra ba̱di Isaía, y de mi tʉnguiꞌa̱ bi hyonga núꞌa̱ ra xɛni habʉ ena njaua: ");
INSERT INTO oteNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nurá Ma̱ca Nda̱hi Ajua̱ ꞌbʉi con guequi, ngueꞌa̱ Ajua̱ xa hñuxcagui pa e ga xipa ra hoga ntꞌøde núꞌʉ ya hyoya, ne xuá pɛncagui pa ga huꞌmba yá mʉi núꞌʉ toꞌo tu yá mʉi, ne pa e ga pønga núꞌʉ toꞌo o ntsꞌa̱hni de ja ra tsꞌoqui, ne pa ga japi da xo yá da ya goda, ne pa e ga ña̱nga núꞌʉ ri sufri de núꞌa̱ tꞌøꞌtuabi, ");
INSERT INTO oteNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ne pa e ga ma̱ gue núbya mapaya ya xa zø ra pa pa Ajua̱ da pøhø ya ja̱ꞌi po rá hma̱te. ");
INSERT INTO oteNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nepʉ mi uadi ra Jesu bi hñeꞌta nuya ya noya, bi mantsꞌa ra Ma̱ca Tꞌofo, ne bi umba núꞌa̱ ra maste de ra nija̱. Y bi hñudiꞌa̱, y gatho núꞌʉ xqui muntsꞌni ja ra nija̱ xi mi nʉꞌtiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nepʉ nuꞌá̱ bi mʉdi bi zofoꞌʉ ne bi ꞌñembabiꞌʉ: ―Nubyá ya bi njabʉ ngu núꞌa̱ ja juadi dá heꞌta ja ra Ma̱ca Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Y gatho núꞌʉ mi ꞌbʉhni xi mri ꞌyø de núꞌʉ ya hoga noya mi ma̱nga ra Jesu, ne xi mi ña̱mahñoꞌʉ de gueꞌa̱. Ne mi ꞌñémbabiꞌʉ ꞌna ngu maꞌna: ―¡Conque go guehni rá tꞌʉ ra Jose! ");
INSERT INTO oteNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Dí pa̱di xá hño gue nuꞌahʉ́ ma gui ꞌñengaguihʉ: “ꞌBʉ xi majua̱ni grá medico, ꞌñøthesɛ.” Y nehe ma gui ꞌñengaguihʉ: “ꞌYøtꞌe nehe de guecua ja ma haihʉ ngu núꞌa̱ stá øhe xcá ꞌyøtꞌa Ncapernau.” ");
INSERT INTO oteNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ne de gueꞌa̱ bi sigui bi ña̱ ra Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ gue ni ꞌnará ꞌmɛhni Ajua̱ hingui hma̱di de ja rá haisɛ. ");
INSERT INTO oteNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dí xiꞌahʉ gue nuya paꞌʉ mi ꞌbʉi ra ba̱di Elía mi ꞌbʉ ndunthi ya viuda nehe ja ra hnini de Israel. Y nuya paꞌʉ hinxqui ꞌua̱i hñu njɛya made, hangue xi xqui nja ꞌnara da̱nga thuhu ja gatho nuna ra hai. ");
INSERT INTO oteNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pe nu Ajua̱ himbi mɛhna ra Elía pa da tꞌini ja yá ngu núꞌʉ ya viuda mi ꞌbʉ ja ya hnini de Israel. Ajua̱ bi mɛhniꞌa̱ maꞌnambʉ ja rá ngu ꞌnara viuda núꞌa̱ mi ꞌbʉ ja ra tꞌʉca hnini Sarepta gueta ra da̱nga hnini Sidó. ");
INSERT INTO oteNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nehe de nuya paꞌʉ mi ꞌbʉi ra ba̱di Eliseo, ndunthi ya me Israel mi hena ra lepra, pe ni ꞌna de gueꞌʉ himbi ña̱ni de núꞌa̱ ra hñeniꞌa̱, hønsɛ ra Naamán núꞌa̱ mrá me Siria, nsøcꞌa̱ go gueꞌa̱ bi ña̱ni de ra lepra mi tsʉdi. ");
INSERT INTO oteNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nu mi ꞌyøde nuya ya noya gatho núꞌʉ xqui muntsꞌni mbo ra nija̱ bi bø yá cuɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ne bi ꞌmaiꞌʉ bi gʉca ra Jesu de ja yá hniniꞌʉ, ne bi zitsꞌi ja rá hyo ra hnini habʉ mi ja ꞌnara maꞌye, y de guehni mi nehma̱ꞌʉ xa føte pa rí gaꞌti. ");
INSERT INTO oteNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pe nura Jesu bi ꞌrantho madetho de ra hmuntsja̱ꞌi ne bi ma. ");
INSERT INTO oteNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nepʉ nura Jesu bi ma Ncapernau maꞌna ra hnini de ra hai Galilea, ne ja bá xahnani ya ja̱ꞌi nura pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y gatho ya ja̱ꞌi xi mri ꞌyø de núꞌa̱ mi udiꞌa̱ ngueꞌa̱ mi zote co ꞌraya noya xi mi pɛꞌtsa ndunthi ra tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Y nuni ja ra nija̱ habʉ xqui muntsꞌiꞌʉ xqui zøhø ꞌnara ꞌñøhø mi pɛꞌtsa ꞌnara tsꞌonda̱hi. Nepʉ nuꞌá̱ bi dø ꞌnara hmafi ne bi ña̱ ntsꞌɛdi bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Nuꞌi Jesu grá me Nasare, hyɛgaguiheua. ¿Hanja xcuá ehe pa hønsɛ e gui juatcaguihe? Ngueꞌa̱ nugui dí pa̱di toꞌoꞌi, go gueꞌi rá Ma̱ca Tꞌʉꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nura oraꞌa̱ ra Jesu bi zʉi núꞌa̱ ra tsꞌonda̱hi ne bi ꞌñembi: ―¡Coꞌta ri ne, pøni de nuna ra ꞌñøhø! Nepʉ nura tsꞌonda̱hi bi føma núꞌa̱ ra ꞌñøhø de ja yá thandi ya ja̱ꞌi, nepʉ bi bønga ra tsꞌonda̱hi bi ma nsinque te bi ꞌyøꞌtuabi núꞌa̱ ra ꞌñøhøꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y gatho ya ja̱ꞌi bi ntsu ne mri ꞌñémbabi ꞌna ngu maꞌna: ―¡Xi te ma tsꞌɛdi ha̱ni gue co nuyá noya ri ꞌbɛpa ya tsꞌonda̱hi da bøni, y nuꞌʉ́ øte! ");
INSERT INTO oteNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y gatho rá nthetsꞌi núꞌa̱ ra haiꞌa̱ bi ꞌño ra ꞌbede de núꞌa̱ bi ꞌyøtꞌa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nepʉ ra Jesu bi bøni de guehni ja ra nija̱ ne bi ma ja rá ngu ra Simu. Ne mi ꞌbɛnga rá to ra Simu xi mi umba ra nzø ntsꞌɛdi. Nepʉ bri ba̱ntebi ra Jesu gue da nu nura daꞌthiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nuꞌbú ra Jesu bi ma bá nu, bi ndoqui ne bi japa ra nzø da ntsaya. Y ꞌbestho ra oraꞌa̱ bi tsayabi ra nzø, ne bi nanga núꞌa̱ ra ꞌbɛhña̱ pa bi hyocui te da ziꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ngu bi yʉ ra hyadi núꞌa̱ ra paꞌa̱, gatho toꞌo mi hena nuꞌa̱raza ra hñeni bi tsꞌixa habʉ mbi ꞌbʉ ra Jesu. Nepʉ nuꞌá̱ mi huxa yá ꞌyɛ ja ꞌramaꞌna ya daꞌthi, y gatho mi ña̱ni ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nehe ndunthi ya daꞌthi núꞌʉ mi pɛꞌtsa ya tsꞌonda̱hi mi ɛmbabi, ne asta mi mafiꞌʉ mi ena: ―Nuꞌi go gueꞌi rá Tꞌʉꞌi Ajua̱. Pe nura Jesu mi tsʉi núꞌʉ ya tsꞌonda̱hi ne himi hopi da ña̱, ngueꞌa̱ nuꞌʉ́ mi pa̱di gue go mi gueꞌa̱ ra Cristo núꞌa̱ bá pɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Rá hyaxꞌa̱ ꞌnitho ra Jesu bi bøni de ra hnini Ncapernau bi ma ja ꞌnara mbonthi habʉ hinto mi ꞌbʉi. Pe nuya ja̱ꞌi xi bi ꞌño bi hyoniꞌa̱ asta xi bi zøni habʉ mi ꞌbʉiꞌa̱, ngueꞌa̱ nuꞌʉ́ himi ne da hyɛgui da maꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pe nura Jesu bi ꞌñembabiꞌʉ: ―Mahyoni ga ma ga umba ra hoga ntꞌøde maꞌra ya hnini gue ya xa zø ra Nda̱ de mahetsꞌi pa da nda̱, ngueꞌa̱ pa gueꞌa̱ xuá ꞌbɛncagui pa ga e ga ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Njabʉ mi ꞌyo ra Jesu ne mi cʉtꞌa ja ya nija̱ nuni Galilea pa mi unga ra hoga ntꞌøde. ");
INSERT INTO oteNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ꞌNara pa ra Jesu mi ꞌbʉ ja rá hyo ra ndehe de Genesare, y nuni bi zøni ndunthi ya ja̱ꞌi ne bi muntsꞌi habʉ mi ꞌbʉiꞌa̱, asta mri tsꞌiꞌmiꞌa̱ ngueꞌa̱ nuꞌʉ́ mi ne da ꞌyøtua rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nepʉ nura Jesu bi hyanda yoho ya motsa gueta rá hyo ra ndehe hinto mi oni, ngueꞌa̱ núꞌʉ ya mɛhua̱ mi cʉni xqui bøni de guehni pa da menga yá xitꞌa̱ ja rá hyo ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nepʉ nura Jesu bi yʉtꞌa ja ꞌna de núꞌʉ ya motsa núꞌa̱ mrá mɛti ra Simu, ne bi ꞌyapa ra ma̱te ra Simu da ꞌyɛtꞌa ra motsa má tsꞌʉ mbo ra dehe, ngueꞌa̱ xi mi tsꞌiꞌma ya ja̱ꞌi. Y bi hñudi ra Jesu mbo ra motsa ne desde guehni bi yopa zofo ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Y de mi uadi bi zofo ya ja̱ꞌi bi ꞌñembabi ra Simu: ―ꞌYɛtꞌa ra motsa pa habʉ maꞌna strá hñe ra dehe, ne ja gui ca̱thʉni ri xitꞌa̱hʉ pa gui mpɛhua̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ha nura Simu bi da̱di ne bi ꞌñembabi: ―Ma zi Xahnateꞌi, stá ꞌyoheua gatho ra xuui, stá mpɛhua̱he pe hinte stá jʉhe. Pe nubyá go guí xicje gue ga ca̱the ma xitꞌa̱he ja ra dehe, ma ga ca̱the. ");
INSERT INTO oteNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ha nura Simu ne núꞌʉ maꞌra mi oui mbo ra motsa bi ga̱tꞌa yá xitꞌa̱ mbo ra dehe, y mi hña̱i xi bá ñutsꞌi co ya hua̱ asta bi mʉdi bi ntʉnihma̱ co yá hñʉ ya hua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nepʉ nuꞌʉ́ bi ꞌñutua ra seña núꞌʉ maꞌra yá compa mbi o ja maꞌna ra motsa pa e da matsꞌi. Y nuꞌʉ́ bá ehe ꞌbestho ne bi ñuꞌtsa núꞌʉ yoho ya motsa co ya hua̱, asta mi ne da yʉi ja ra dehe co yá hñʉ ya hua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Y nu mi hyanda ra Simu njabʉ, bi ndandiña̱hmu ja rá ua ra Jesu ne bi ꞌñembabi: ―Hiní ꞌñepqui ga ꞌñoui, ngueꞌa̱ nugui ꞌnadrá ꞌyøtꞌatsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bi ꞌñena njabʉ ngueꞌa̱ ngu xi bi ntsu ngueꞌa̱ bi gʉ ndunthi ya hua̱, ne gatho núꞌʉ maꞌra mi oui mbo ra motsa ngu bi ntsu neheꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ne núꞌʉ maꞌra mri mfaxui ra Simu ja ra ꞌbɛhua̱, go ra Cobo ne ra Xuua núꞌʉ yá tꞌʉ ra Sebedeo, gatho neꞌʉ ngu xi bi ntsu. Pe nura Jesu bi ꞌñembabi ra Simu: ―Oguí tsu, ngueꞌa̱ desde nubya ma ga ꞌraꞌaꞌi maꞌna ri ꞌbɛfi pa gui mpɛhua̱ dega ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nuꞌbʉ́ nuꞌʉ́ bi ꞌyɛtꞌa yá motsa pa asta ja rá ña̱ni ra ndehe ne ja bi zohni yá motsa con gatho yá mpɛfi dega ꞌbɛhua̱, nepʉ nuꞌʉ́ bi dɛna ra Jesu bi mɛui. ");
INSERT INTO oteNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ꞌNara pa mi ꞌyo ra Jesu ja ꞌnara hnini, ne ja mi ꞌbʉhni ꞌnara ꞌñøhø mi hena ra lepra, ne xi mi tsiꞌti. Y nu mi hyanda ra Jesu, bi ma bá tsʉdi ne bi ndandiña̱hmu ne asta bi mɛgui rá hmi ja ra hai, ne bi ꞌñembabi: ―Núꞌi ri tꞌequꞌei Ndada, ꞌbʉ gui nehma̱, da za gui ꞌyøthegui. ");
INSERT INTO oteNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nepʉ nura Jesu bi hñuꞌtsua rá ꞌyɛ, ne bi ꞌñembabi: ―Ha̱ha̱, dí ne ga øtheꞌi. Y nubyá ya xcá ña̱ni. Y nu mi uadi bi ma̱nga njabʉ, ꞌbestho ra oraꞌa̱ bi ña̱ni de núꞌa̱ ra hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ha nura Jesu bi hñuꞌmba ra hña̱ gue hinto da xipabi de núꞌa̱ xqui ꞌyøꞌtuabi, ne bi ꞌñembabi: ―Hønsɛ nuꞌa̱ mahyoni gui ꞌyøtꞌe, rí ma bá ꞌñudi ja ra macja̱ pa da hyandi gue ya xcá ña̱ni. Ne unga ri hña̱ꞌti ngu núꞌa̱ bi manda ra Moise, gueꞌa̱ ꞌnara seña pa da hyanda ya ja̱ꞌi gue ya xcá ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pe maꞌna mri ntʉnga ra ꞌbede de núꞌa̱ mi øtꞌa ra Jesu, ne nza̱ntho mi muntsꞌa ya ja̱ꞌi pa da ꞌyøde núꞌa̱ mi ma̱ñꞌa̱ ne pa da ꞌyøthebi yá hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ha nura Jesu njatꞌa̱ mi ꞌuesɛhɛ habʉ mi joꞌo ya ja̱ꞌi pa mbi apabi Ajua̱ rá Dada. ");
INSERT INTO oteNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ꞌNara pa ra Jesu mi xahna ya ja̱ꞌi, ne mi huhni ꞌraya fariseo ne ꞌraya xahnate de ra ley xqui ꞌñehe de Jerusale ne de habʉraza maꞌra ya hnini de ra hai Judea ne de Galilea. Y ra Jesu mi ha̱npa rá tsꞌɛdi Ajua̱ pa mi øthe gatho ya daꞌthi. ");
INSERT INTO oteNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nepʉ bi zøhø ꞌraya ꞌñøhø mri du ꞌnara daꞌthi xqui ꞌyɛntsꞌa ja ꞌnara ꞌbebo. Núꞌa̱ ra daꞌthiꞌa̱ himi tsa da ꞌña̱ni ngueꞌa̱ mi tuda rá ndoꞌyo. Y núꞌʉ toꞌo mri du mi ne da cʉꞌta mbo ja ra ngu asta habʉ mi ꞌbʉ ra Jesu pa da ꞌyøtheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pe himbi zʉdi habʉ da yʉtꞌiꞌʉ ngueꞌa̱ xi mi ja ra ntsꞌiꞌmi. Hangue bi bøxa maña̱ ra ngu, y bá heca ꞌna xɛni ra techo pa bi za bi ca̱ꞌma ra daꞌthi co rá ꞌbebo pa habʉ mi ꞌbai ra Jesu mbo ra ngu madetho de ra mundo ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ha nu mi hyanda ra Jesu gue nuꞌʉ́ mi ja yá jamfri, bi ꞌñembabi ra daꞌthi: ―ꞌYøde, nuri tsꞌoqui ya stá punꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nepʉ nuya xahnate de ra ley ne ya fariseo núꞌʉ mi huhni bi ꞌñensɛ ja yá mfeniꞌʉ: “¿Hanja nuni ra ꞌñøhø ri ꞌñetꞌa Ajua̱? Ngueꞌa̱ joꞌo maꞌna toꞌo da unga ra pumbate de ya tsꞌoqui, hønsɛ Ajua̱.” ");
INSERT INTO oteNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pe nura Jesu bi ba̱tua yá mfeniꞌʉ, hangue bi ꞌñembabi: ―¿Hanja guí beñhʉ njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ndaꞌa̱ maꞌna hinxá hñei ga embi, ri tsꞌoqui ya stá punꞌaꞌi, o ga embi, nangui rí ma? ");
INSERT INTO oteNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pe pa gui pa̱hʉ gue Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ja rá tsꞌɛdi de guecua ja ra ximhai pa da unga ra pumbate de ya tsꞌoqui, ma ga øtꞌa njaua: Nuꞌbʉ́ bi ꞌñembabi ra daꞌthi: ―Nangui, jʉxa ri ꞌbebo, rí ma ri ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hangue ꞌbestho núꞌa̱ ra oraꞌa̱ ra daꞌthi bi nangui ja yá thandi gatho núꞌʉ mi ꞌbʉhni, ne bi gʉxa rá ꞌbebo ne bi ma rá ngu mri xøcambeni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Y gatho ya ja̱ꞌi xi mri ꞌyø de núꞌa̱ xqui nja y mri xøcambeni Ajua̱ꞌʉ. Ne xi mi tsuꞌʉ de núꞌa̱ xqui hyandi ne mi enaꞌʉ: ―Nubya stá hanthʉ ꞌraya da̱nga tꞌøtꞌe núꞌa̱ hinhyaꞌmʉ stá hanthʉ xa nja. ");
INSERT INTO oteNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ꞌMɛfa de gueꞌa̱ ra Jesu bi bøni ne bi hyanda ꞌnara ngʉxboja̱ rá thuhu ra Leví mi hudi ja rá mexa. Nepʉ bi ꞌñembabi: ―Bá ehe, tɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nuꞌbʉ́ ra Leví bi ꞌmai ꞌbestho ne bi zohni rá ꞌbɛfi, ne bi dɛna ra Jesu bi mɛui. ");
INSERT INTO oteNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ne ꞌmɛfa, ra Leví bi ꞌyøꞌtua ꞌnara da̱nga ngo ra Jesu ja rá ngu, y bi zøhni ndunthi maꞌra ya ngʉxboja̱ nehe, nehe bi zøhni maꞌra ya ja̱ꞌi ne bi hñudi ja ra mexa mahyɛgui con gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nepʉ nuya fariseo ne ꞌraya xahnate de ra ley núꞌʉ myá fariseo nehe, bi mʉdi bi ña̱maꞌñʉ de yá nxadi ra Jesu ne bi ꞌñembabiꞌʉ: ―¿Hanja grí ñuñhʉ ne grí ntsihʉ co nuyʉ ya ꞌña̱tsa ngʉxboja̱ ne maꞌra ya ꞌyøtꞌatsꞌoqui? ");
INSERT INTO oteNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pe nura Jesu bi da̱di ne bi ꞌñembabi: ―Nuꞌʉ tóꞌo ꞌbʉi xá hño ne hindri hñeni, hingui honga ra ꞌñethi, pe nuꞌʉ tóꞌo ri hñeni ha̱, honi toꞌo da ꞌyøthe. ");
INSERT INTO oteNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nugui stuá ehe pa ga zofo ya ꞌyøtꞌatsꞌoqui pa da ñobri de yá tsꞌoqui, hingue stuá ehe pa ga zofo núꞌʉ toꞌo beni gue ꞌbʉi xá hño ja rá thandi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nepʉ nuꞌʉ́ bi ꞌyøꞌtua maꞌna ra ntꞌani ra Jesu ne bi ꞌñembabi: ―¿Hanja ri ayuna ne ri ora ndunthi núꞌʉ yá nxadi ra Xuua ne yá nxadi ya fariseo, ha nuri nxadigue nza̱ntho ri ñuni ne tsithe? ");
INSERT INTO oteNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nepʉ nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―¿Ha gue da za gui japhʉ da ayuna núꞌʉ ꞌbʉ ja ꞌnara ngo dega ntha̱ti ꞌbʉ ꞌbʉhnitho ra na̱vio con gueꞌʉ? Hina, hinda za. ");
INSERT INTO oteNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pe ma da zø ra pa da tsꞌiꞌtsuabi ra na̱vio, ya hinda ꞌmʉi con gueꞌʉ, nuꞌbʉ́ ha̱, gueꞌbʉ ma da ayunaꞌʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nehe bi xipabi maꞌna ra ꞌbede bi ꞌñembabi: ―Ni ꞌnara ja̱ꞌi hingui hɛnga rá ꞌraꞌyo he pa da møꞌta rá zɛhe. Nuꞌbʉ toꞌo da ꞌyøtꞌa njabʉ, nuꞌbʉ́ da tsꞌonga rá ꞌraꞌyo he, y nehe nura xɛca ꞌraꞌyo dutu hinda hogui xá hño ja nura zɛhe. ");
INSERT INTO oteNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nehe nixi hinto xitꞌa ra ꞌraꞌyo vinu ja ꞌnara zɛbota, ngueꞌa̱ nura ꞌraꞌyo vinu da føca ra zɛbota, y njabʉ da tsꞌoca ra bota y da mfanga ra vinu. ");
INSERT INTO oteNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hangue mahyoni da sitꞌa ra ꞌraꞌyo vinu ja ꞌnara ꞌraꞌyo bota pa njabʉ hinte da ja ra vinu nixi ra bota. ");
INSERT INTO oteNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nuꞌa̱ tóꞌo tsi núꞌa̱ ra vinu ya pɛꞌtsa ya pa xa thoqui, hinda ne da zi ra ꞌraꞌyo vinu, ngueꞌa̱ ena gue maꞌna xá cʉhi núꞌa̱ ya pɛꞌtsa ya pa xa thoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ꞌNara pa dega tsaya ra Jesu mi ꞌñoui yá nxadi bi ꞌranga ja ꞌraya hua̱hi habʉ xqui ꞌbotꞌa ra trigo. Ha nuyá nxadi mi tocua yá nga̱ha̱ ne mi ta̱qui mi tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nepʉ ꞌraya fariseo bi hyandi ne bi ꞌyambi bi ꞌñembabi: ―¿Hanja guí øthʉ núꞌa̱ hingui ho da tꞌøtꞌe núbya ra pa dega tsaya? ");
INSERT INTO oteNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ha nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―¿Ha hinxcá hñeꞌthʉ ja ra Ma̱ca Tꞌofo habʉ ma̱ de núꞌa̱ bi ꞌyøtꞌa ndu ra Davi co maꞌra yá compa núꞌbʉ mi zʉ ra thuhuꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ma̱ gue nuꞌá̱ bi yʉtꞌa ja rá nija̱ Ajua̱ pa bi hña̱xa núꞌʉ ya thuhme xqui thuxa ja rá thandi Ajua̱, ne bi ziꞌa̱ ne bi umbi bi zi gatho núꞌʉ maꞌra yá compa mri ꞌñoui. Ha núꞌʉ ya thuhmeꞌʉ hønsɛ ya macja̱ mri ꞌñepi da zihma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nehe ra Jesu bi ꞌñembabiꞌʉ: ―Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ha̱ ra tsꞌɛdi pa da manda masque ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nepʉ maꞌna ra pa dega tsaya ra Jesu bi yʉtꞌa ja ra nija̱ ne bi mʉdi bi nxahnate. Ne mi ꞌbʉhni ꞌnara tsꞌonate xqui ꞌyotꞌa rá ꞌyɛ ra ꞌñɛi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ha nuya xahnate de ra ley ne ya fariseo mi aca ra Jesu pa da hyandi ua da ꞌyøthe núꞌa̱ ra ꞌñøhø ra pa dega tsaya, pa njabʉ xa za hanja xa ña̱pabi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pe nuꞌá̱ bi ba̱tuatho yá mfeniꞌʉ, ne bi ꞌñembabi núꞌa̱ ra ꞌñøhø xqui ꞌyotꞌa rá ꞌyɛ: ―ꞌBai ne bá e gui ꞌba madetho habʉ da hyantꞌaꞌi gatho. Ha núꞌa̱ ra ꞌñøhø ꞌbestho bi ꞌmai ne bi ma bá ꞌba madetho habʉ bi za bi thandi xá hño. ");
INSERT INTO oteNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nepʉ nura Jesu bi ꞌñembabi núꞌʉ ya xahnate de ra ley ne ya fariseo: ―Ma ga øꞌtꞌaꞌihʉ ꞌnara ntꞌani: ¿Ndaꞌa̱ ja ra nsɛqui da tꞌøtꞌe ra pa dega tsaya, ra hñoja̱ꞌi o ra ntsꞌoꞌmʉi? ¿Ha gue da za da tꞌøthe ꞌnara daꞌthi o da thɛpʉtho? ");
INSERT INTO oteNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nepʉ nuꞌá̱ bi nʉꞌta gatho núꞌʉ mi ꞌbahni ne bi ꞌñembabi núꞌa̱ ra ꞌñøhø: ―Tʉnga ri ꞌyɛ. Y núꞌa̱ ra ꞌñøhø bi tʉnga rá ꞌyɛ núꞌa̱ xqui ꞌyotꞌi, ne ꞌbestho ra oraꞌa̱ bi ña̱ni núꞌa̱ rá ꞌyɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nepʉ ya fariseo ne ya xahnate de ra ley mi ꞌbʉhni xi bi bø yá cuɛ ne bi mʉdi bi ꞌñámbi ꞌna ngu maꞌna te da za da ꞌyøꞌtua ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ja nuya paꞌʉ bi bøxa ra Jesu ja ꞌnara tꞌøhø pa bá apabi Ajua̱ rá Dada, y ja guehni bá oraꞌa̱ gatho ra xuui. ");
INSERT INTO oteNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nepʉ rá hyaxꞌa̱ ꞌnitho bi zohna gatho yá nxadi, ne bi huahna ꞌrɛtꞌamayoho de gueꞌʉ pa bi hñutsꞌi dega apostol. ");
INSERT INTO oteNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ha nuya guehya yá thuhuꞌʉ: ra Simu núꞌa̱ bi thuꞌmbabi nehe ra Pedro; ne ra Andre rá cu ra Pedro; ra Cobo ne ra Xuua, ne ra Lipe ne ra Tolo, ");
INSERT INTO oteNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ne ra Teo ne ra Toma, ne núꞌa̱ maꞌna ra Cobo rá tꞌʉ ra Alfeo; ne maꞌna ra Simu núꞌa̱ xqui ꞌñoui ya cananista; ");
INSERT INTO oteNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ra Juda núꞌa̱ rá cu ra Cobo; ne ra Juda Iscariote núꞌa̱ toꞌo ꞌmɛfa bi da ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nepʉ nura Jesu bá ca̱i de ja ra tꞌøhø bra ꞌñoui núꞌʉ ꞌrɛtꞌamayoho yá apostol, ne bi zøhøꞌʉ ja ꞌnara ꞌbatha habʉ xqui muntsꞌa ndunthi maꞌra yá nxadi ne ndunthi ya ja̱ꞌi núꞌʉ myá me Jerusale ne maꞌra ya hnini de ra hai Judea, ha nu maꞌra xqui ꞌñehe de ra hnini Tiro ne de Sidó de ja rá hyo ra ndehe. Nuya ja̱ꞌiꞌʉ bá ehe pa bi ꞌyøde núꞌa̱ mi ma̱nga ra Jesu ne pa bi ꞌyøthebi yá hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ne mi ɛmbabi ya tsꞌonda̱hi núꞌʉ toꞌo mi pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y gatho ya ja̱ꞌi xi mi nehma̱ da dʉnga ra Jesu, ngueꞌa̱ nuꞌá̱ co rá tsꞌɛdi mi ha̱ca gatho ya hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nepʉ nura Jesu bi hyanda yá nxadi ne bi ꞌñembabi: ―Núꞌahʉ gyá hyoyahʉ, xa ja̱pꞌaꞌihʉ Ajua̱ ngueꞌa̱ xa ꞌraꞌahʉ gatho ya ja̱pi núꞌʉ ja habʉ ri mandaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Núꞌahʉ guí thohʉbya ra thuhu, xa ja̱pꞌaꞌihʉ Ajua̱ ngueꞌa̱ hinte ma da ꞌbɛꞌtꞌahʉ. Núꞌahʉ guí tu ri mʉihʉbya, xa ja̱pꞌaꞌihʉ Ajua̱, ngueꞌa̱ ma da hñupꞌa ri mʉihʉ pa xi gui johyahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ajua̱ da ja̱pꞌahʉ nu stí ʉtsaꞌihʉ ya ja̱ꞌi, ne nu stí ꞌyɛñꞌahʉ co ya ntꞌʉtsate, ne stí zañꞌaꞌihʉ asta ni pa dí ꞌyøꞌtꞌa ri thuhuhʉ, ngueꞌa̱ nuꞌʉ́ ma da beni gue xá ntsꞌoꞌahʉ po rá ngue Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Núꞌʉ ya pa xcrí thohʉ njabʉ, xi da johyahʉ ngueꞌa̱ ma gui hña̱ñhʉ ꞌnara tha̱ha̱ xi ra da̱ngui nuni mahetsꞌi. Núꞌʉ ya ja̱ꞌi ma da ꞌyøꞌtꞌaꞌihʉ njabʉ, njabʉ nehe bi ꞌyøtꞌa ndu yá xita co núꞌʉ yá ꞌmɛhni Ajua̱ mi ꞌbʉi mayaꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pe huecate núꞌʉ toꞌo xi ri johyabya co ya hño de guecua ja ra ximhai, pe rá nga̱tsꞌi ya hinda ma da johya co nuya hño pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Huecate núꞌʉ toꞌo hingui tho ra thuhubya, ngueꞌa̱ ꞌmɛfa ha̱, ma da tho ra thuhu. Huecate núꞌʉ toꞌo xi ri johyabya, ngueꞌa̱ ꞌmɛfa ma xi da nzoniꞌʉ co ra dumʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Huecate núꞌʉ toꞌo xi tꞌeꞌtsua yá nsu masque hingui øtꞌe xá hño. Nuꞌʉ tóꞌo eꞌtsua yá nsu, njabʉ nehe bi ꞌyøtꞌa ndu yá xitaꞌʉ co ya hyate ba̱di mayaꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pe núꞌahʉ guí øcaguihʉ, dí xiꞌahʉ gue gui ma̱di ri ncontrahʉ, ne ꞌyøꞌtuahʉ ra hño núꞌʉ toꞌo ri ʉtsaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ꞌYaphʉ Ajua̱ da ja̱pi núꞌʉ toꞌo tsañꞌahʉ, ne ꞌyaphʉ Ajua̱ pa núꞌʉ toꞌo ña̱maꞌñʉ de gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ha nuꞌbʉ toꞌo da ꞌraꞌahʉ ꞌnara mpɛꞌti ja ri hmihʉ, umbahʉ maꞌna lado ri hmihʉ pa da mɛꞌtꞌahʉ nehe, oguí nøꞌtuahʉ. Ha nuꞌbʉ toꞌo da hña̱nꞌa ri patꞌihʉ, pø ri pahnihʉ nehe, gui umfʉ da hña̱tsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ha nuꞌbʉ toꞌo te da ꞌyaꞌaꞌihʉ, umfʉ, o nuꞌbʉ da hña̱nꞌahʉ ꞌnara tꞌøtꞌe dri mɛtihʉ, oxqui ha̱mbabihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nuꞌa̱ guí nehʉ da ꞌyøꞌtꞌahʉ ya ja̱ꞌi, ꞌyøꞌtuahʉ njabʉ neheꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nuꞌbʉ nuꞌahʉ grí ma̱dihʉ hønsɛ toꞌo ri ma̱ꞌaꞌihʉ, hinte ri muui núꞌa̱ guí øthʉ, ngueꞌa̱ asta ya tsꞌoꞌmʉi gá ja̱ꞌi øtꞌa njabʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O nuꞌbʉ guí øꞌtuahʉ ra hño hønsɛ núꞌʉ toꞌo øꞌtꞌahʉ ra hño, nixi gueꞌa̱ hinte ri muui núꞌa̱ guí øthʉ, ngueꞌa̱ asta ya tsꞌoꞌmʉi gá ja̱ꞌi øtꞌa njabʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ha nuꞌbʉ guí hmiphʉ ri boja̱hʉ hønsɛ núꞌʉ toꞌo guí pa̱hʉ da guꞌtꞌaꞌihʉ, hinte ri muui núꞌa̱ guí øthʉ njabʉ, ngueꞌa̱ asta nuya tsꞌoꞌmʉi gá ja̱ꞌi øtꞌa njabʉ nehe, hmipabi yá mitsꞌoꞌmʉiui núꞌʉ toꞌo tøꞌmiꞌʉ da guꞌtuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pe nuꞌahʉ́ ma̱di ri ncontrahʉ, ne gui ꞌyøꞌtuahʉ ra hño, ne gui hmihʉ núꞌa̱ dra miꞌahʉ nsinque gui tøꞌmhʉ dra joꞌtsꞌahʉ. Ngueꞌa̱ ꞌbʉ gui øthʉ njabʉ, nuꞌbʉ́ ha̱, ma gui hña̱nga ꞌnari da̱nga tha̱ha̱hʉ. Y njabʉ ha̱, grí hña̱xhʉ Ajua̱ bí ꞌbʉi mahetsꞌi, ngueꞌa̱ nuꞌá̱ ra hoja̱ꞌi co ya tsꞌoꞌmʉi ne co núꞌʉ otho yá jama̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hangue nuꞌahʉ pɛꞌtsuahʉ ra nthecate gatho ya ja̱ꞌi ngu øtꞌa Ajua̱ ra Dada. ");
INSERT INTO oteNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Oguí ꞌyøhʉ ri miquꞌeihʉ de núꞌa̱ te øtꞌe, ngueꞌa̱ Ajua̱ handatho núꞌa̱ te guí øthʉ nehe. Nixi oguí nønga ri miquꞌeihʉ, ngueꞌa̱ Ajua̱ go gueꞌa̱ ma da hña̱pꞌahʉ nguɛnda de gatho núꞌa̱ te guí øthʉ. Pumbabihʉ de núꞌa̱ øꞌtꞌahʉ ya ja̱ꞌi, y Ajua̱ da punꞌaꞌihʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Øꞌtuahʉ ra hño ri miquꞌeihʉ, ne Ajua̱ da ꞌyøꞌtꞌahʉ ra hño nehe. Co núꞌa̱ ra tꞌɛni xcá ꞌyɛmbahʉ maꞌra, con gueꞌa̱ ra tꞌɛni ma da ꞌyɛnꞌahʉ Ajua̱ nehe. Hangue nuꞌbʉ gui øꞌtua ndunthi ya hño ri miquꞌeihʉ, Ajua̱ ma da coꞌtsꞌahʉ maꞌna ndunthi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nepʉ nuꞌá̱ bi xipabiꞌʉ ꞌnara ꞌbede ne bi ꞌñembabi: ―¿Ha gue da za ꞌnara goda da gʉhna maꞌna rá migodaui? ¿Ha gue hinda daguiui mahyɛgui? ");
INSERT INTO oteNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ne bi ꞌñembabi nehe: ―Ni ꞌnara ja̱ꞌi núꞌa̱ ja ri nxadi, maꞌna di pa̱di que rá xahnate, pe nu sta uadi da nxadi xá hño, nuꞌbʉ́ ha̱, da nja rá mfa̱di ngu rá xahnate nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Hanja guí handua rá tsꞌoqui ri cu, nja ngu ꞌnara zi paxi o ja rá daꞌa̱, ne hanja hingo guí handa núꞌa̱ ra da̱nga tsꞌoqui nja ngu ꞌnara xɛca za o ja ri dague? ");
INSERT INTO oteNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne ¿hanja da za gui ꞌñembabi ri cu: “Hocagui ga ha̱pꞌa ra paxi o ja ri da”, ne hanja hingo guí handa núꞌa̱ ra xɛca za o ja ri dague? ¡Nuꞌi ꞌnagrá yohmi! hña̱i ꞌmɛtꞌo núꞌa̱ ra za o mbo ri da, pa njabʉ da za gui hyanda xá hño ne gui hña̱ꞌmba ra paxi o mbo rá da ri cu. ");
INSERT INTO oteNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ni ꞌnara hoga ꞌbai gá za hingui tsa da unga ya tsꞌo fruta, nixi ꞌnara tsꞌo ꞌbai gá za hingui tsa da unga ya hoga fruta. ");
INSERT INTO oteNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gatho ya ꞌbai gá za fa̱ditho po yá fruta, ndaꞌa̱ xá hño, y ndaꞌa̱ hingui ho. Ngueꞌa̱ nura ꞌbai gá ꞌmini hingui tsa da unga ya igo, nixi ya camꞌyo hingui tsa da unga ya obxi. ");
INSERT INTO oteNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Njabʉ nehe ꞌnara hoja̱ꞌi nza̱ntho øtꞌa núꞌa̱ xá hño, ngueꞌa̱ nza̱ntho benga ya hoga mfeni. Ha nura tsꞌoꞌmʉi gá ja̱ꞌi nza̱ntho øtꞌa núꞌa̱ hinxá hño, ngueꞌa̱ ja rá mfeni nza̱ntho beni xá ntsꞌo. Njabʉ nehe núꞌa̱ ma̱, bí ehe de ja rá mfeni. ");
INSERT INTO oteNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Hanja nza̱ntho guí engaguihʉ: “Ma zi Hmuꞌihe, ma zi Hmuꞌihe”, ne hinguí øthʉ núꞌa̱ dí xiꞌahʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nuꞌa̱ tóꞌo da ꞌñehe da ꞌyøde núꞌa̱ dí ma̱ ne da ꞌyøtꞌe, ma ga xiꞌahʉ toꞌo ri nhyɛcuaui. ");
INSERT INTO oteNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nuꞌá̱ ri nhyɛcuaui ꞌnara ꞌñøhø núꞌa̱ bi xeꞌta habʉ da hyocua rá ua rá ngu asta bi zʉdi ra medo, ne ja bi hyocni rá ngu. Ne nu mi ꞌua̱ ya da̱ꞌye ne bi zø ya nzøthe bi ꞌrani habʉ mi ja rá ngu, pe núꞌa̱ ra nguꞌa̱ himbi hyømi ngueꞌa̱ xqui thocua rá ua ja ra medo. ");
INSERT INTO oteNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pe nuꞌa̱ tóꞌo da ꞌyøde núꞌa̱ dí ma̱ ne hinda ꞌyøtꞌe núꞌa̱ dí ꞌbɛpabi, ri nhyɛcuaui núꞌa̱ ra ꞌñøhø bi tøta rá ngu maña̱ ja ra haitho, himbi ꞌyacua rá ua mbo ra hai, y nu mi zøhø ya nzøthe co rá tsꞌɛdi bi hyøma núꞌa̱ ra nguꞌa̱, y bi nhuati gatho. ");
INSERT INTO oteNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mi uadi ra Jesu bi zofo ya ja̱ꞌi bi yopa ma maꞌnaꞌqui pa ja ra hnini Ncapernau. ");
INSERT INTO oteNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","De guehni mbi ꞌbʉ ꞌnara nda̱ gá soldado me Nroma, mi ꞌbʉhui ꞌnara tsꞌʉntꞌʉ xi mrá hma̱di ꞌbɛgo, y nuꞌá̱ mi tsʉdi ꞌnara hñeni asta mi nedu. ");
INSERT INTO oteNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pe nu mi ꞌyøde núꞌa̱ ra nda̱ gá soldado mi hma̱ de ra Jesu, bi mɛhna ꞌraya nda̱ me Israel pa da ꞌyapa ra ma̱te da ꞌñehe da ꞌyøthebi núꞌa̱ rá ꞌbɛgo mri hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ha nu mi zøniꞌʉ habʉ mi ꞌbʉi ra Jesu bi ba̱ntebi con gatho yá mʉi da mɛuiꞌʉ ne bi ꞌñembabi: ―Núꞌa̱ ra nda̱ gá soldado bá pɛncahe rí ꞌñepi gui fatsꞌi, ");
INSERT INTO oteNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ngueꞌa̱ xi ri ma̱di ndunthi ma ja̱ꞌihʉ y asta bi manda nehe bi thoga ma nija̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hangue nura Jesu bi mɛuiꞌʉ. Pe nu ya de mi ma da zønga ja ra ngu, núꞌa̱ ra nda̱ gá soldado bi mɛhna ꞌrayá amigo ne bi ꞌñembabi: ―Rí maha ua xipabihʉ ra Jesu njaua: Núꞌi ri tꞌequꞌei Ndada, ya ogrí xuhña, ngueꞌa̱ nugui hiní ꞌñepcagui ngugui gui cʉtꞌa ja ma ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hangue nixi dá ne dá masɛbʉ pa ga tsiꞌaꞌi. Nuꞌa̱ dí aꞌaꞌibya, hønsɛ gui ma̱ gue da ña̱nga ma ꞌbɛgo y dí camfri gue da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Dí camfri gue ꞌbestho da njabʉ ngu núꞌa̱ gui ma̱, ngueꞌa̱ nugui dí ꞌbʉi nehe ja yá hmanda ma nda̱, ne dí pɛꞌtsa ma soldado nehe ja ma hmanda. ꞌBʉ ga embabi ꞌna de gueꞌʉ: “Rí ma”, nuꞌá̱ da ma. Ha nuꞌbʉ ga embabi maꞌna: “Bá ecua”, nuꞌá̱ dua ehe. Ha nuꞌbʉ dí ꞌbɛpabi ꞌnara ꞌbɛfi ma ꞌbɛgo, nuꞌá̱ da mɛfi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ha nu mi ꞌyøde njabʉ ra Jesu xi bi ꞌyø núꞌa̱ bi ma̱nga núꞌa̱ ra nda̱ gá soldado. Ne bi mpʉntsꞌi ne bi xipa núꞌa̱ ra hmuntsja̱ꞌi mri ꞌñoui, ne bi ꞌñembabiꞌʉ: ―Xi majua̱ni ni ꞌnara menguua Israel hinstá tsʉdi xi di ja rá jamfri ngu núꞌa̱ ra ꞌñøhøꞌa̱ masque hingrá me Israel. ");
INSERT INTO oteNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ha nu mi menga núꞌʉ ya ꞌmɛhni ja rá ngu ra nda̱ gá soldado, bi zʉdi núꞌa̱ ra ꞌbɛgo ya xqui ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ꞌMɛfa de gueꞌa̱ ra Jesu mri ma ja ꞌnara hnini rá thuhu Naín ne mri ꞌñoui yá nxadi ne ndunthi maꞌra ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pe ante da zønga ja ra hnini bi hyandi mi pani ꞌnara ꞌbɛhña̱ mrá viuda xqui du rá ꞌra tꞌʉ y mri ma ntꞌagui y nehe mi pani con gueꞌa̱ ꞌnara hmuntsja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Y nu mi hyanda ra zi ꞌbɛhña̱ nura Jesu, xi bi huequi ne bi ꞌñembabi: ―Oguí zoni. ");
INSERT INTO oteNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nepʉ bi da̱stꞌiꞌa̱ habʉ mi pa núꞌʉ toꞌo mri du, ne bi hñuxa rá ꞌyɛ ja ra caha, y núꞌʉ toꞌo mri du bi gohi bi ꞌmai. Ha nura Jesu bi ꞌñembabi núꞌa̱ xqui du: ―Tsꞌʉntꞌʉ, nugui dí xiꞌaꞌi: ¡Nangui! ");
INSERT INTO oteNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nepʉ núꞌa̱ xqui du bi nangui ne bi hñudi ne bi mʉdi bi ña̱. Y nura Jesu bi dapabi rá na̱na̱. ");
INSERT INTO oteNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ha nu mi hyanda njabʉ gatho ya ja̱ꞌi, xi bi ntsuꞌʉ, ne bi mʉdi bi nsunda Ajua̱ ne mi enaꞌʉ: ―ꞌNará da̱nga ꞌmɛhni Ajua̱ xa zøhø ja guecaguihʉ. Nehe mi enaꞌʉ: ―Ajua̱ xuá mɛhni pa e da maxa rá hnini. ");
INSERT INTO oteNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y gatho ja ra hai Judea ne gatho maꞌra ya hnini núꞌʉ mi ja ja rá nthetsꞌi, bi fa̱di núꞌa̱ xqui ꞌyøtꞌa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ha de mi ofadi ra Xuua, bi ꞌyøde de gatho núꞌa̱ xqui ꞌyøtꞌa ra Jesu ngueꞌa̱ go xqui xipabi nuyá nxadi sɛhɛꞌa̱. Nepʉ bi zohna yoho de gueꞌʉ ");
INSERT INTO oteNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","pa bi mɛhni pa dua ambabi ra Jesu ua xi majua̱ni go mi gueꞌa̱ ra Cristo xqui mɛhna Ajua̱ pa da nda̱, o mahyoni da døꞌma maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nuꞌbʉ́ nuyá ꞌmɛhni ra Xuua bi ma bá cꞌa̱ꞌtsa ra Jesu ne bi ꞌñembabi: ―Ra Xuua Xiꞌtsate bá pɛncaheua pa ga anꞌahe ua xi go gueꞌi grá Cristo rá ꞌmɛhniꞌi Ajua̱ xcuá ehe pa gui nda̱, o mahyoni ga tøꞌmhe maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Y nura ora mi zønga yá ꞌmɛhni ra Xuua, tsꞌa ra oraꞌa̱ ra Jesu mi øthe ndunthi ya daꞌthi, ne mi ɛnga ya tsꞌonda̱hi, ne mi øthe ndunthi ya goda nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hangue nuꞌá̱ bi da̱di ne bi ꞌñembabiꞌʉ: ―Rí maha ne ua xipabihʉ ra Xuua núꞌa̱ ja juadi gá hyanthʉ ne gá ꞌyøhʉ. Xipabihʉ gue nuya goda xa yopa hyandi, nuya doua xa ꞌño, ha núꞌʉ hena ra lepra xa ña̱ni, ha nuya gogu xa ꞌyøde, ha núꞌʉ xqui du xa yopa nte, ha ya hyoya xa ꞌyøde ra ma̱ca noya núꞌa̱ ma̱ de ra mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nehe xipabihʉ gue xi nja̱pi núꞌa̱ toꞌo hinda ʉ rá mfeni de núꞌa̱ dí øtꞌe, dá gamfri ha̱ gue Ajua̱ go xuá mɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ha nu mi menga núꞌʉ yá ꞌmɛhni ra Xuua, ra Jesu bi mʉdi bi ꞌyambabi ya ja̱ꞌi de ra Xuua ne bi ꞌñembabi: ―¿Toꞌo gá ma uá hanthʉ ja ra mbonthi? ¿Ha gue uá hanthʉ ꞌnara ja̱ꞌi mi otho rá tsꞌɛdi ngu ra xithi mri ndudetho ra nda̱hi? Hina ¿ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nuꞌbʉ́, ¿toꞌo uá hanthʉ? ¿Ha gue ꞌnara ꞌñøhø mi he ꞌraya dutu xi mahotho? Hina, ngueꞌa̱ guí pa̱hʉ gue nuya ꞌñøhø he ya dutu xi mahotho ne pɛꞌtsa ndunthi ya hño, nuꞌʉ́ ꞌbʉ ja yá ngu ya nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nuꞌbʉ́, ¿toꞌo uá hanthʉ? ¿Ha gue ꞌnará ꞌmɛhni Ajua̱? Ha̱ha̱, majua̱ni uá hanthʉ ꞌnará ꞌmɛhni Ajua̱, pe hingue hønsɛ gueꞌa̱ rá ꞌbɛfiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nura Xuua go gueꞌa̱ rá ꞌmɛhni Ajua̱ núꞌa̱ ma̱nga ja ra Ma̱ca Tꞌofo gue mi ma da ꞌñehe ne ena njaua: Dí pɛhna ꞌnama ꞌmɛhni pa da ma̱nga ra ꞌbɛtꞌo noya de gueꞌi, pa da hyocꞌaꞌi ri ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nugui dí xiꞌahʉ gue hinxa ꞌmʉ maꞌna ra ja̱ꞌi maꞌna ra da̱ngui rá nsu que ra Xuua Xiꞌtsate. Pe nuꞌa̱ tóꞌo da yʉtꞌa ja rá hmanda Ajua̱ nuua ja ra ximhai maꞌna ma da nja̱pi que ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nu mi uadi bi ma̱nga ra Jesu njabʉ, nuꞌbʉ́ núꞌʉ toꞌo xqui hña̱nga ra sistehe de ra Xuua, y asta ꞌraya ꞌña̱tsa ngʉxboja̱ nehe, gathoꞌʉ bi ma̱ gue núꞌa̱ øtꞌa Ajua̱ xá hño. ");
INSERT INTO oteNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pe nuya fariseo ne ya xahnate de ra ley mi ɛꞌsta ja yá xʉtha núꞌa̱ mi ne da ꞌyøtꞌa Ajua̱ con gueꞌʉ pa da pumba yá tsꞌoquiꞌʉ, hangue nixi hinxqui ne xqui hña̱nga ra sistehe núꞌa̱ mi øtꞌa ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nepʉ nura Jesu bi ꞌñembabi ya ja̱ꞌi: ―¿Toꞌo ga hyɛcuaga nuya ya ja̱ꞌi himbi ne bi gamfri ra Xuua ha nixi hingui ne da gamfrigui nehe? ");
INSERT INTO oteNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nuyʉ́ rí hña̱tsꞌi núꞌʉ ya ba̱tsi hudi ja ra tai ꞌñeni ne maꞌta yá miba̱tsiui ne embi: “Dá pɛ ma thʉzahe, pe hingá neihʉ. Dá tuthe ya thuhu dega dumʉi, pe nixi gueꞌa̱ hingá nzonihʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hangue núꞌahʉ gyá ꞌña̱gamfrihʉ grí hña̱xhʉ núꞌʉ ya ba̱tsiꞌʉ ngueꞌa̱ pa gueꞌahʉ otho ꞌnara tꞌøtꞌe núꞌa̱ grí hohʉ. Ngueꞌa̱ gá hyanthʉ ra Xuua bi zøhø, ne himi pa mi ñunga ja ya ngo ha nixi himi tsi ra vinu, hangue nuꞌahʉ guí emfʉ gue mi pɛꞌtsa ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nepʉ de ra Xuua bi zøhø Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, xi ri ntsiui toꞌo ri ntsiui, ne xi ri ñungüi toꞌo ri ñungüi, pe nuꞌahʉ guí emfʉ gue xi ra tsꞌoꞌyo ne ra tixfani ne ri ntsiui núꞌʉ ya ꞌña̱tsa ngʉxboja̱ ne maꞌra ya tsꞌoja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pe nugui dí xiꞌahʉ gue nuꞌʉ tóꞌo pɛꞌtsa ra hoga mfa̱di, go gueꞌʉ pa̱di gue gatho xá hño núꞌa̱ øtꞌa Ajua̱ co rá da̱nga mfa̱diꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ꞌNa de ya fariseo bi zohna ra Jesu ja rá ngu pa da ñungüi. Nuꞌbʉ́ ra Jesu bi ma y mi zøniꞌa̱ bi hñudi ja ra mexa. ");
INSERT INTO oteNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y ja núꞌa̱ ra hniniꞌa̱ mi ꞌbʉhni ꞌnara ꞌbɛhña̱ xi mrá ꞌyøtꞌatsꞌoqui, y nu mi ba̱di gue xqui zøhni ra Jesu ja rá ngu núꞌa̱ ra fariseo pa ja da ñunini, bi ma bá cꞌa̱ꞌtsi, ne bi hña̱xa ꞌna ngu ra xito xqui thoqui de ꞌnara hoga tꞌaxa do rá thuhu ra alabastro, mi po ꞌnara ñʉni xi mi yʉni xá cʉhi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nura ꞌbɛhña̱ꞌa̱ bi da̱stꞌa ja yá ua ra Jesu, bi nzoni ne bi xixa yá guida ja yá ua ra Jesu, nepʉ bi oꞌtuabi co yá sta̱, nepʉ bi zʉꞌtsuabi, ne bi goꞌtsuabi núꞌa̱ ra hoga ñʉni mi ha̱. ");
INSERT INTO oteNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y mi hyanda núꞌa̱ ra fariseo xqui zohna ra Jesu ja rá ngu, bi benga ja rá mfenisɛ ne mi ena: “ꞌBʉ xi majua̱ni dra ba̱di nuna ra ꞌñøhø, nuꞌbʉ́ di pa̱hma̱ gue nuni ra ꞌbɛhña̱ thaꞌtua yá ua, guehni ꞌnara tsꞌoꞌbɛhña̱.” ");
INSERT INTO oteNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ha nura oraꞌa̱ ra Jesu bi ꞌñembabi núꞌa̱ ra fariseo: ―Nuꞌi nugue Simu, dí ne ga xiꞌaꞌi ꞌnara noya. Ha nura fariseo bi ꞌñembabi: ―Xicagui, ma Xahnateꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nepʉ nura Jesu bi ꞌñembabi: ―Mi ꞌbʉ yoho ya ꞌñøhø mi tupa ra boja̱ maꞌna ra ꞌñøhø toꞌo mi hmi ra boja̱, y ꞌna de gueꞌʉ mi tupabi cʉtꞌa nthebe ya tꞌaxboja̱, ha nu maꞌna mi tupabi made nthebe. ");
INSERT INTO oteNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ha nuꞌʉ́ himi tsa da guꞌtua rá boja̱ núꞌa̱ toꞌo xqui mipabi. Hangue núꞌa̱ ra ꞌñøhø mri hmi ra boja̱ bi pumbabiꞌʉ, ya himbi cobrabi. Hangue nubyá xicagui, ¿toꞌo ꞌna de gue núꞌʉ yoho ya ꞌñøhø bri pumbabi yá thai maꞌna ma da ma̱di núꞌa̱ toꞌo mi hmi ra boja̱? ");
INSERT INTO oteNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ha nura Simu bi da̱di ne bi ꞌñena: ―Dí enga núꞌa̱ ra ꞌñøhø maꞌna mi tu ndunthi. Y ra Jesu bi ꞌñembabi: ―Majua̱ni núꞌa̱ gá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nepʉ ra Jesu bi hyanda núꞌa̱ ra ꞌbɛhña̱ ne bi ꞌñembabi ra Simu: ―De dá tsøcua ja ri ngu hinxcá ꞌraca ni tsꞌʉ ra dehe pa ga xʉca ma ua, pe ndi, hyanda nuna ꞌbɛhña̱, bi xʉga ma ua co yá guida, ne bi otcagui co yá sta̱. ");
INSERT INTO oteNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nuꞌi hinxcá tsʉsqui, pe nuna ra ꞌbɛhña̱ hingui tsaya tsʉsca ma ua. ");
INSERT INTO oteNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nuꞌi ni ra aceite hinxcá cosca ja ma ña̱xu, pe nuna ra ꞌbɛnte ꞌbɛhña̱ xa goscagui ja ma ua ꞌnara ñʉni yʉni xi xá cʉhi. ");
INSERT INTO oteNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hangue dí xiꞌaꞌibya gue nuna ra ꞌbɛhña̱ ya xra pumbabi gatho núꞌʉ yá tsꞌoqui xi ndunthi xqui ꞌyøtꞌe, y hangue por gueꞌa̱ xi ja ndunthi rá hma̱te. Pe nuꞌa̱ tóꞌo xra pumba yá tsꞌoqui masque beni gue hintsꞌʉ mi tu ndunthi, go gueꞌa̱ otho ndunthi rá hma̱te. ");
INSERT INTO oteNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nepʉ ra oraꞌa̱ ra Jesu bi ꞌñembabi núꞌa̱ ra ꞌbɛhña̱: ―Ya stá punꞌaꞌi gatho ri tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ha gatho núꞌʉ maꞌra ya ja̱ꞌi mi huhni bi mʉdi bi ꞌñémsɛꞌʉ ne mi ena: ―¿Xi toꞌobya nuna ra ꞌñøhø gue asta yá tsꞌoqui ya ja̱ꞌi da za da pumbabi, ena? ");
INSERT INTO oteNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ha nura Jesu bi ꞌñembabi nura ꞌbɛhña̱: ―Co núꞌa̱ ri jamfri guí pɛꞌtsi ya xcá mpøhø, ha nubyá rí ma te rá ꞌñentho. ");
INSERT INTO oteNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ꞌMɛfa de gueꞌa̱ ra Jesu bá ꞌyo ja ndunthi ya da̱nga hnini ne ja ndunthi ya tꞌʉca hnini mi zofo ya ja̱ꞌi ne mi xipabiꞌʉ ra hoga ntꞌøde gue ya xa zø ra Nda̱ de mahetsꞌi pa da nda̱. Ne mri ꞌñoui núꞌʉ ꞌrɛtꞌamayoho yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ne mri ꞌñoui nehe ꞌraya ꞌbɛhña̱ núꞌʉ xqui ꞌyøthebi yá hñeni ne maꞌra núꞌʉ xqui ꞌyɛnba ya tsꞌonda̱hi. ꞌNa de gueꞌʉ mrá thuhu ra Maria Magdalena núꞌa̱ xqui tꞌɛnbabi yoto ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nehe mi ꞌñoui ra Juana núꞌa̱ mrá ꞌbɛhña̱ ꞌnara ꞌñøhø mrá thuhu ra Chusa núꞌa̱ ꞌnamrá da̱nga maste ra nda̱ Erode. Mri ꞌñouiꞌʉ nehe ra Sana ne maꞌra ya ꞌbɛhña̱ núꞌʉ mi faxa ra Jesu ne yá nxadi de núꞌa̱ mi tsʉpa yá tsꞌɛdiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Y ndunthi ya ja̱ꞌi bi bøni de yá hnini pa da ma dua cꞌa̱ꞌtsa ra Jesu. Y nu mi hyandi bi muntsꞌa ndunthi ya ja̱ꞌi bi mʉdi bi xipa ꞌnara ꞌbede ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―ꞌNara pa ꞌnara motꞌi bi ma ja rá hua̱hi pa da mpotꞌi. Y nu mi xanga ya nda, ꞌra bi zo ja ra ꞌñu y bi ꞌrani ya ja̱ꞌi bi netꞌi, ne bi zi ya tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ha nu maꞌra bi zo ja ya ꞌbodo habʉ mi otho ndunthi ra hai. Y nu mi cꞌontsꞌi bi ꞌyotꞌi ꞌbestho ngueꞌa̱ mi otho ra xaha. ");
INSERT INTO oteNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ha nu maꞌra bi zo habʉ mi ja ya ꞌmini, ha nu mi cꞌontsꞌi bi ꞌyotꞌi ngueꞌa̱ bi xumi ya ꞌmini ne bi hña̱cua yá te. ");
INSERT INTO oteNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ha nu maꞌra bi zo habʉ xi xmá hño ra hai, ne nu mi hoguiꞌʉ bi unga ꞌnara hoga sofo, ne cada ꞌnara ꞌbai bi unga asta ꞌna nthebe ya nda. Y nu mi uadi bi ma̱nga ra Jesu njabʉ, bi yopa ña̱ ntsꞌɛdi ne bi ꞌñembabi ya ja̱ꞌi: ―Nuꞌa̱ tóꞌo ja rá tꞌøde pa da ꞌyøde, dá ꞌyøde núna dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nepʉ nuyá nxadi bi ꞌyambabi ra Jesu te mri bønga nuna ꞌbede bi ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ha nuꞌá̱ bi da̱tuabiꞌʉ bi ꞌñembabi: ―Nuꞌahʉ xa ꞌraꞌahʉ Ajua̱ ra hoga mfa̱di pa gui pa̱hʉ núꞌa̱ hinxqui fa̱di maꞌmɛtꞌo de hanja ri mandaꞌa̱. Pe nuyʉ maꞌra ya ja̱ꞌi dí zofo co ya ꞌbede pa da hyandi pe hinda ba̱di te ꞌbɛꞌa̱, y da ꞌyøde pe hinda zo yá mfeni te rí bøni. ");
INSERT INTO oteNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nuna ꞌbede ja juadi dá ma̱ rí bøni da ꞌñena gue nura nda gueꞌa̱ ra ma̱ca noya. ");
INSERT INTO oteNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ha nuꞌʉ ya nda bi zo ja ra ꞌñu go gueꞌa̱ núꞌa̱ toꞌo øde ra ma̱ca noya, ne da ꞌñehe ra tsꞌonda̱hi da puꞌtua rá mfeni pa hinda gamfri y njabʉ hinda za da mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ha nuꞌʉ ya nda bi zo ja ra ꞌbodo go gueꞌa̱ núꞌa̱ toꞌo øde ra ma̱ca noya ne ha̱ni co ꞌnara johya ne ꞌñena xi camfri, pe hingui camfri con gatho rá mʉi, hangue nu sta ꞌñepa ya tsꞌothogui da ꞌuegue. ");
INSERT INTO oteNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ha nuꞌʉ ya nda bi zo ja ya ꞌmini go gueꞌa̱ núꞌa̱ toꞌo øde ra ma̱ca noya, pe da mpumfri po rá ngue yá ꞌbɛfi ne de núꞌa̱ te gatho pɛꞌtsi, ne ngueꞌa̱ di dɛnda ya tꞌøtꞌe de ra ximhai, y njabʉ da ꞌbɛdi núꞌa̱ xqui ꞌyøde, nja ngu núꞌʉ ya nda himbi unga ra sofo. ");
INSERT INTO oteNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ha nuꞌʉ ya nda bi zo ja ra hoga hai go gueꞌa̱ núꞌa̱ toꞌo øde ra ma̱ca noya ne da ꞌyøtꞌe con gatho rá mʉi ngu núꞌa̱ ri ho Ajua̱, ne da zɛ rá jamfri, y go gueꞌa̱ nja ngu núꞌʉ ya nda bi unga ra hoga sofo. ");
INSERT INTO oteNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ra Jesu bi ma̱nga maꞌna ra ꞌbede ne bi ꞌñena: ―Joꞌo ꞌnara ja̱ꞌi da tsøgue ꞌnara ñotꞌi ne da yeꞌmba ꞌnara caha o da hñuxa rí gaꞌti de ra mfidi pa hinda yotꞌi. Nuꞌa̱ da ꞌyøtꞌe, da tsøgue ra ñotꞌi ne da tøte habʉ da tøte pa da yotꞌa gatho mbo ra ngu, ne pa njabʉ handa ya ja̱ꞌi sta yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Njabʉ nehe gatho núꞌa̱ tꞌa̱guibya, ꞌnara pa ma da hnequi ja ra ñotꞌi, ne gatho núꞌa̱ hingui fa̱dibya, ꞌnara pa ma da fa̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hangue jamasuhʉ pa gui ꞌyødehʉ xá hño núꞌa̱ dí xiꞌahʉ, ngueꞌa̱ nuꞌa̱ tóꞌo pɛꞌtsa rá mfa̱di ne da ba̱di da su, nuꞌá̱ maꞌna ma da tꞌumbabi ndunthi, pe nuꞌa̱ tóꞌo hingui su rá mfa̱di, da pumfri núꞌa̱ tsꞌʉ pa̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nepʉ de mi xahna ya ja̱ꞌi ra Jesu, bi zøhø rá na̱na̱ ne yá cu, pe himbi za bi thogui pa habʉ mbi ꞌbʉiꞌa̱ ngueꞌa̱ xi xqui muntsꞌini ndunthi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ne bi tꞌembabi ra Jesu: ―Bi zø ri na̱na̱ ne ri cu y ꞌbahni thi bí tøpꞌaꞌi gui ña̱ui ꞌna̱. ");
INSERT INTO oteNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pe nura Jesu bi da̱di ne bi ꞌñembabi: ―Nuꞌʉ tóꞌo øde ra ma̱ca noya ne da ꞌyøtꞌa núꞌa̱ ma̱, núꞌʉ́ go gueꞌʉ ma na̱na̱ ne ma cu. ");
INSERT INTO oteNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ꞌNara pa ra Jesu bi bøxa ja ꞌnara motsa co yá nxadi ne bi ꞌñembabiꞌʉ: ―Maha pa riꞌnandi ra ndehe. Y bi maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y de mi pa ja ra ndehe bi zʉ ra tꞌa̱ha̱ ra Jesu ne bi ꞌña̱ha̱. Y mi da̱mfriꞌʉ bi nja ꞌnara da̱nga bʉnthi ja ra ndehe, y bi mʉdi bi mo ra dehe ja ra motsa asta mi ne xa yʉiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nepʉ nuyá nxadi bi ma bá a ra Jesu ne bi ꞌñembi: ―¡Ay, ma zi Xahnateꞌihe, ya ma ga cʉihʉ ja ra dehe! Nuꞌbʉ́ ra Jesu ꞌbestho ra oraꞌa̱ bi nangui ne bi zʉi ra bʉnthi ne ra dehe, y ꞌbestho bi ntsaya gatho. ");
INSERT INTO oteNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nepʉ ra Jesu bi ꞌñembabi yá nxadi: ―¿Te bi ja co ri jamfrihʉ? Ha nuꞌʉ́ xi bi ntsu ne bi ꞌyø de núꞌa̱ bi ꞌyøtꞌa ra Jesu, ne mri ꞌñémbabiꞌʉ ꞌna ngu maꞌna: ―¿Te ma tsꞌɛdi ha̱ni ꞌbʉ, gue asta ra bʉnthi ne ra dehe zofo, y nuꞌʉ́ øte? ");
INSERT INTO oteNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nepʉ de gueꞌa̱ bi ꞌratsꞌi de ra ndehe ne bi zønga ja ꞌnara hai ja rá hyo ra ndehe habʉ rá thuhu Gadara núꞌa̱ ri nhyanduitho ra hai Galilea. ");
INSERT INTO oteNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ha nu mi ga̱i ra Jesu de ja ra motsa, ꞌbestho ꞌnara ꞌñøhø mrá menguni e bi zʉdi. Núꞌa̱ ra ꞌñøhøꞌa̱ ya mi øtꞌa ndunthi ya pa mi pɛꞌtsa ꞌraya tsꞌonda̱hi, ne himi he ra dutu, nixi mi ꞌbʉi ja ꞌnara ngu ngueꞌa̱ nza̱ntho mi ꞌbʉi ja ya ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Y nu mi hyanda ra Jesu, bi e bi ndandiña̱hmu ja yá ua ne bi mafi ntsꞌɛdi bi ꞌñena: ―Nuꞌi Jesu, rá Tꞌʉꞌi Ajua̱ bí ꞌbʉ mahetsꞌi, ¿hanja grí nhyøtꞌe con guequi? Dí ba̱nteꞌi gue oxqui ma gui ꞌyɛngagui de guecua. ");
INSERT INTO oteNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Bi ma̱nga njabʉ ngueꞌa̱ ra Jesu ya mi fʉdi mri ꞌbɛpabi ra tsꞌonda̱hi da bøni de núꞌa̱ ra ꞌñøhø. Ndunthi ya ꞌmiꞌqui ra tsꞌonda̱hi xqui gʉ núꞌa̱ ra ꞌñøhø ne mi øꞌtua núꞌa̱ go mi ne. Ha nuya ja̱ꞌi ora mi handa njabʉ, da gʉ ne da da̱tꞌi co ya cadena ja yá ua ne ja yá ꞌyɛ, pe nuꞌá̱ mi cꞌʉcta núꞌʉ ya cadena, y ra tsꞌonda̱hi mi japi da bønga yabʉ ja ya mbonthi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ha ra Jesu bi ꞌyambabi núꞌa̱ ra ꞌñøhø ne bi ꞌñembabi: ―¿Te rá huꞌi? Nuꞌá̱ bi da̱di ne bi ꞌñena: ―Drí ndunthihe. Bi ma̱nga njabʉ ngueꞌa̱ xi mi pɛꞌtsa ndunthi ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ha núꞌʉ ya tsꞌonda̱hi bi ba̱ntebi ra Jesu gue hinda mɛhna ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nu de guehni mi ꞌyoni ꞌna da̱nga taxo ya tsꞌʉdi mri ñuni ja ra tꞌøhø, hangue ya tsꞌonda̱hi bi ba̱ntebi ra Jesu gue da umba nsɛqui da ma da yʉtꞌa ja nuya tsꞌʉdiꞌʉ, y nuꞌá̱ bi umba nsɛquiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ra oraꞌa̱ ya tsꞌonda̱hi bi bøni de núꞌa̱ ra ꞌñøhø ne bi ma gá yʉtꞌa ja ya tsꞌʉdi, ne gatho ya tsꞌʉdi bi nestꞌihi gá ma gá hñøtꞌa ja ra ndehe, ne bi ja̱tꞌiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Y nu mi hyanda njabʉ núꞌʉ toꞌo mi taca ya tsꞌʉdi xi bi ntsuꞌʉ, ne bi ma hnestꞌihi bá ꞌyonga ra ꞌbede ja ra hnini ne habʉraza de núꞌa̱ te xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y gatho ya ja̱ꞌi bi ma da hyanda núꞌa̱ xqui nja. Y nu mi zønga habʉ mi ꞌbʉ ra Jesu, ja bi zʉhniꞌʉ núꞌa̱ ra ꞌñøhø mi pɛꞌtsa ya tsꞌonda̱hi mi huhni ja yá ua ra Jesu, ya mi he yá dutu ne ya xi mi ja rá mfeni. Y gatho ya ja̱ꞌi xi bi ntsu. ");
INSERT INTO oteNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nepʉ núꞌʉ toꞌo xqui hyanda núꞌa̱ xqui nja bi xipabiꞌʉ hanja xqui ꞌbʉi xá hño núꞌa̱ ra ꞌñøhøꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Y nu mi ba̱di njabʉ gatho ya me Gadara bi ba̱ntebi ra Jesu da bøni de guehni ngueꞌa̱ xi xqui ntsuꞌʉ. Hangue nura Jesu bi yopa bøxa ja ra motsa ne bi ma de guehni. ");
INSERT INTO oteNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nepʉ núꞌa̱ ra ꞌñøhø xqui tꞌɛmba ya tsꞌonda̱hi bi ba̱ntebi xa mɛuihma̱ ra Jesu, pe ra Jesu bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Hina, hinga tsixꞌaꞌi, cohiua, pengui rí ma ri ngu, ne xipabi ya ja̱ꞌi núꞌa̱ xa ꞌyøꞌtꞌaꞌi Ajua̱. Hangue nuꞌá̱ bi mengui ne bi mʉdi bi metuabi ya ja̱ꞌi ja gatho núꞌa̱ ra hnini de núꞌa̱ xqui ꞌyøꞌtua ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nu mi yopa menga ra Jesu pa riꞌnandi ra ndehe, ya ja̱ꞌi xi bi johya mi hyandiꞌa̱, ngueꞌa̱ nuꞌʉ́ mi tøꞌmthoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nepʉ bi zøhni ꞌnara ꞌñøhø mrá thuhu ra Jairo mrá nda̱ de ra nija̱ de guehni. Ne bi ndandiña̱hmu ja yá ua ra Jesu ne bi ba̱ntebi gue da mɛui pa ja rá ngu, ");
INSERT INTO oteNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ngueꞌa̱ mi nedu rá tꞌixu. Hønsɛ gueꞌa̱ mrá tꞌixuꞌa̱, ne mi pɛꞌtsa ꞌrɛtꞌamayoho njɛya. Hangue ra Jesu bi mɛui, y nu mi ma, bi dɛna ndunthi ya ja̱ꞌi asta mri tsꞌiꞌmiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Y ja nura hmuntsja̱ꞌiꞌa̱ mi pani nehe ꞌnara ꞌbɛhña̱ ya mi pɛꞌtsa ꞌrɛtꞌamayoho njɛya mi xoꞌtua ya ji, y ya xqui degue gatho núꞌa̱ mi pɛꞌtsi pa mri ꞌñøthehma̱, pe hinxqui za to xqui ꞌyøtheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nura ꞌbɛhña̱ꞌa̱ gá yʉ ja rá xʉtha ra Jesu pa bi dʉnba rá ña̱ni rá he. Y nura oraꞌa̱ ꞌbestho bi ña̱ni, y ya himbi sigui bi xoꞌtua ya ji. ");
INSERT INTO oteNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nepʉ nura Jesu bi ꞌñani ne bi ꞌñena: ―¿Toꞌo núꞌa̱ bi dʉnga ma he? Gatho ya ja̱ꞌi bi da̱di bi ꞌñena: ―Hinto xa dʉñꞌaꞌi. Ha nura Pedro ne núꞌʉ maꞌra yá minxadiui bi ꞌñembabi ra Jesu: ―Ma zi Xahnateꞌihe, guí handi gue ndunthi ya ja̱ꞌi ri tsꞌipꞌaꞌi ne entꞌaꞌi, ha guí ena gue toꞌo bi dʉñꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ha nura Jesu bi ꞌñena: ―Dí pa̱di bri thʉngagui, ngueꞌa̱ dá tsa dá øthe ꞌnara ja̱ꞌi co ma tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nu mi hyanda núꞌa̱ ra ꞌbɛhña̱ gue ra Jesu xqui ba̱tho gue xqui thʉnba rá he, nuꞌbʉ́ nuꞌá̱ bá ehe bi ndandiña̱hmu ja yá uaꞌa̱, ne asta mri hua̱tꞌi co ra ntsu. Ne de ja yá thandi nuya ja̱ꞌi bi ma̱ pa te xqui dʉniꞌa̱, ne bi ma̱ gue ora mi dʉnba rá ña̱ni rá he, ra oraꞌa̱ bi tsayabi núꞌa̱ ra hñeni mi tsʉdi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nuꞌbʉ́ nura Jesu bi ꞌñembabi núꞌa̱ ra ꞌbɛhña̱: ―Ma zi tꞌixuꞌi, co ri jamfri xcá ña̱ni. Y nubyá rí ma te rá ꞌñentho. ");
INSERT INTO oteNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Y de mi ña̱ ra Jesu, bi zøhø ꞌnara ꞌmɛhni xqui ꞌñe ja rá ngu ra Jairo núꞌa̱ mrá nda̱ ja ra nija̱, ne bi ꞌñembabi: ―Ri tꞌixu ya bi du, ya oguí xuhña ra Xahnate. ");
INSERT INTO oteNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Y nu mi ꞌyøde njabʉ ra Jesu bi ꞌñembabi ra Jairo: ―Oguí tu ri mʉi, hønsɛ gui camfrigui y nuri tꞌixu ma ga daꞌaꞌi di ꞌbʉi xá hño. ");
INSERT INTO oteNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Y nu mi zøniꞌʉ ja rá ngu ra Jairo, ndunthi ya ja̱ꞌi ya xqui muntsꞌini mi zoni ne mri mantho ngueꞌa̱ xqui du ra nxutsi. Pe nura Jesu bi ꞌñembabiꞌʉ: ―Oguí zoñhʉ, ngueꞌa̱ nura nxutsi hinxa du, a̱ha̱tho. Pe nuꞌʉ́ himbi gamfri núꞌa̱ bi ma̱nga ra Jesu, bi nthetho. Nepʉ ra Jesu himbi hopa maꞌra toꞌo bi yʉtꞌiui habʉ mi ꞌbɛnga ra nxutsi, hønsɛ ra Pedro ne ra Cobo ne ra Xuua ne rá dada núꞌa̱ ra nxutsi ne rá na̱na̱, go gueꞌʉ bi hopi bi yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nepʉ nura Jesu bi mipa ꞌnará ꞌyɛ núꞌa̱ ra nxutsi ne bi ꞌñembabi ntsꞌɛdi: ―Zi nxutsi, nangui. ");
INSERT INTO oteNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y ꞌbestho ra oraꞌa̱ núꞌa̱ ra nxutsi bi yopa nte ne bi nangui. Nepʉ ra Jesu bi manda gue da tꞌumbabi te da zi. ");
INSERT INTO oteNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ha nurá dada rá na̱na̱ xi bi ꞌyø, y ra Jesu bi hñuꞌmba ra hña̱ gue hinto da xipi de núꞌa̱ xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ra Jesu bi muntsꞌa núꞌʉ ꞌrɛtꞌamayoho yá nxadi pa bi umba ra tsꞌɛdi pa da ꞌyɛmba nuꞌa̱raza ra tsꞌonda̱hi nuya ja̱ꞌi, ne da ꞌyøthebi yá hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","De guehni bi mɛhniꞌʉ pa da ꞌyøthe gatho ya daꞌthi ne da ma̱nga ra hoga ntꞌøde gue ya bi zø ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne bi ꞌñembabiꞌʉ: ―Ote xqui ha̱xhʉ pa ja ra ꞌñu, oxqui ha̱xhʉ ri bordohʉ, nixi ꞌnara buxa, nixi núꞌa̱ te gui tsihʉ, nixi ra boja̱, nixi ri mponga dutuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y nuꞌa̱ ra ngu habʉ da tꞌaꞌahʉ ntsaya, ja gui ꞌbʉhʉni asta núꞌa̱ ra paꞌa̱ gui yopa jʉ ri ꞌñuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y nuꞌa̱ ra hnini habʉ hinda ne da tꞌaꞌahʉ ntsaya, pøñhʉ de guehni, ne hua̱thʉ ra hai núꞌa̱ di tu ri uahʉ, y núꞌá̱ gueꞌa̱ ꞌnara seña gue ya hingo guí tha̱dihʉ de yá tsꞌoquiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Y mi uadi bi xipa ra Jesu te da ꞌyøtꞌeꞌʉ, bi nxaniꞌʉ bi ma habʉraza ya hnini, bi ma̱nga ra hoga ntꞌøde y mi øthebi yá hñeni ya ja̱ꞌi habʉraza mi tsøñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ra nda̱ Erode bi zo rá gu núꞌa̱ mi øtꞌa ra Jesu, ne himi pa̱di te da beniꞌa̱, ngueꞌa̱ ꞌramaꞌnaꞌño mi ma̱nga ya ja̱ꞌi. ꞌRa mi ena gue mi gueꞌa̱ ra Xuua Xiꞌtsate xqui yopa nte de ra du, ");
INSERT INTO oteNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ha nu maꞌra mi ena gue mi gueꞌa̱ ra ba̱di Elía xqui yopa nte maꞌnaꞌqui, ha nu maꞌra mi ena gue mi gueꞌa̱ ꞌna de gue núꞌʉ maꞌra yá ꞌmɛhni Ajua̱ mi ꞌbʉ mayaꞌbʉ xqui yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Y nura nda̱ Erode bi ꞌñena: ―Conque go nucsɛ dá manda bi thɛcua rá ña̱xu ra Xuua. Nuꞌbʉ́ ¿toꞌo núꞌa̱ xi ja ndunthi rá ꞌbede? Y ra nda̱ Erode xi mi ne da hyandiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nu mi menga yá nxadi ra Jesu, bi xipabiꞌa̱ gatho núꞌa̱ xqui ꞌyøtꞌeꞌʉ. Nepʉ ra Jesu bi zitsꞌi bi mɛuiꞌʉ ja ꞌnara luga habʉ mi joꞌo ya ja̱ꞌi gueta ra hnini Betsaida. ");
INSERT INTO oteNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pe mi ba̱di ya ja̱ꞌi gue mi paniꞌa̱, bi dɛniꞌʉ. Pe ra Jesu himbi coꞌtsiꞌʉ, nuꞌa̱ bi ꞌyøtꞌe, bi mʉdi bi xipabi de hanja ri manda Ajua̱, ne mi øthe gatho núꞌʉ mri hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ne de mi nde núꞌa̱ ra paꞌa̱, núꞌʉ ꞌrɛtꞌamayoho yá nxadi bi ma bá tsʉdi ra Jesu ne bi ꞌñembabi: ―Da za gui pɛhna ya ja̱ꞌi da ma ja ya hnini ne ja maꞌra ya luga hinga yabʉ pa dua honi habʉ da ntsaya ne da hyoni te da zi, ngueꞌa̱ nuua habʉ dí ꞌbʉhʉ otho ni ꞌnara ngu y nixi te da tsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pe nura Jesu bi ꞌñembabiꞌʉ: ―Nuꞌahʉ go da umfʉ te da ziyʉ. Nepʉ nuꞌʉ́ bi da̱di ne bi ꞌñembabi: ―Otho te ga umfe, hønsɛ cʉtꞌa ya thuhme drí hña̱he, ne yoho ya zi hua̱, o ga mahe ga tambahe te da zi ri gathoyʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Xi mi ndunthi ya ja̱ꞌi, sɛhɛ ya ꞌñøhø ngu mi cʉtꞌa ꞌmo. Pe nura Jesu bi ꞌñembabi yá nxadi: ―ꞌÑehʉ dá hñudi ya zi hmuntsꞌi ngu dega nde nthebe. ");
INSERT INTO oteNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Njabʉ bi ꞌyøtꞌeꞌʉ, ne bi hñudi gatho. ");
INSERT INTO oteNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ha nura Jesu bi gʉ núꞌʉ cʉtꞌa ya thuhme ne núꞌʉ yoho ya hua̱, ne bi nøtsꞌe pa mahetsꞌi bi ꞌyapa Ajua̱ rá Dada da ja̱pi. Nepʉ bi hyecuabi bi umbabi yá nxadi pa da hyecuabi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gatho ya ja̱ꞌi bi ñuni ne xi bi niña̱. Nepʉ bi hmuntsꞌa ya sɛca thuhme xqui bongui y bi ñuxa ꞌrɛtꞌamayoho ya ꞌbøtsꞌe. ");
INSERT INTO oteNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ꞌNara pa ra Jesu bi ꞌuehuisɛ yá nxadi ne bi ꞌyapabi Ajua̱ꞌa̱. Nepʉ bi ꞌyambabi yá nxadi bi ꞌñembabi: ―¿Te guí øhʉ ma̱nga ya ja̱ꞌi de guequi? ¿Xi toꞌogui, ena? ");
INSERT INTO oteNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ha nuꞌʉ́ bi da̱di ne bi ꞌñembabi: ―ꞌRa ena go gueꞌi grá Xuua Xiꞌtsate, ha nu maꞌra ena go gueꞌi grá ba̱di Elía, ha nu maꞌra ena go gueꞌi ꞌna de núꞌʉ maꞌra yá ꞌmɛhni Ajua̱ mi ꞌbʉ mayaꞌbʉ ne xa yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nepʉ nura Jesu bi ꞌñembabiꞌʉ: ―Pe xi nuꞌahʉ, ¿toꞌo guí ma̱ñhʉ gue go guequi? Nuꞌbʉ́ ra Pedro bi da̱di ne bi ꞌñena: ―Nuꞌi go gueꞌi grá Cristo xuá pɛhnꞌaꞌi Ajua̱ pa gui nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pe nura Jesu bi hñuꞌmba ra hña̱ꞌʉ gue hinto da xipabi mi toꞌoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ne bi ꞌñembabi: ―Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi pɛꞌtsi da thogui ndunthi ya tsꞌothogui, y ya nda̱xjua nda̱ ne ya nda̱ gá macja̱ ne ya xahnate de ra ley ma da ʉtsa ne hinda ma da gamfri, ne ma da hyoꞌʉ. Pe rá hñupa ma da yopa nte maꞌnaꞌqui de ra du. ");
INSERT INTO oteNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nepʉ ꞌmɛfa bi zofo ra hmuntsja̱ꞌi xqui muntsꞌni ne bi ꞌñembabi: ―Nuꞌa̱ tóꞌo da ne da dɛngagui pa dua nxadi, odi øtꞌa núꞌa̱ go rá paha sɛhɛ, mahyoni ꞌnara pa ngu ꞌnara pa da zɛta gatho núꞌa̱ da ꞌñepabi asta rá du, ne dá dɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ngueꞌa̱ nuꞌa̱ tóꞌo ne da su rá te ma da ꞌbɛdi, pe nuꞌa̱ tóꞌo da unga rá te po rá nguequi, núꞌá̱ ma da mɛꞌtsa rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Te ri muui ꞌbʉ ꞌnara ja̱ꞌi drá mɛti gatho ra ximhai y nura ja̱ꞌiꞌa̱ da ꞌmɛdi pa nza̱ntho? ");
INSERT INTO oteNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ngueꞌa̱ nuꞌa̱ tóꞌo da ntsa da ña̱ de guequi ne da ntsa da ma̱nga ma noya, necagui nehe núgui dá e dá nja̱ꞌi, ma ga ma̱ gue hindí pa̱caꞌa̱ nu xcrá yopa pengaua pa ga nda̱ co rá nsunda ma Dada ne de ya ma̱ca ɛnxɛ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Xi majua̱ni dí xiꞌahʉ gue ꞌra de gueꞌahʉ guí ꞌbʉhʉua, hingui ma gui tuhʉ asta hingui hyanduahʉ rá nsunda ra Nda̱ de mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Rá hña̱to ma paꞌa̱ de xqui ma̱nga ra Jesu njabʉ, bi bøxa ja ꞌnara tꞌøhø pa da ꞌyapabi Ajua̱ rá Dada, ne bi zixa ra Pedro, ra Cobo ne ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Y de mri oraꞌa̱, bi mpadi rá hmi, ha nuyá dutu xi bi tꞌaxqui asta mri huɛxqui. ");
INSERT INTO oteNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y de guehni bi hneca yoho ya ꞌñøhø mri ꞌbahni mi ña̱ui, y go mi gueꞌa̱ ndu ra Moise ne ndu ra Elía. ");
INSERT INTO oteNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ne nuꞌʉ́ xqui goꞌma ꞌnara hyatsꞌi habʉ mi ꞌbai, ne mi ña̱ꞌʉ de hanja mi ma da du ra Jesu de guehni ja ra hnini Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nura Pedro ne núꞌʉ mri ꞌñoui xi mi tsʉhma̱ ra tꞌa̱ha̱ꞌʉ, pe bi ma ra tꞌa̱ha̱ nu mi hyanda nura hyatsꞌi mi hnequi ja ra Jesu, ne bi hyandi mi ꞌbahni núꞌʉ yoho ya ꞌñøhø con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Y núꞌʉ yoho ya ꞌñøhø de ya mi ma da edi ra Jesu, nuꞌbʉ́ ra Pedro bi ꞌñembabi: ―Ma zi Xahnateꞌi, ¡xá hño ga ꞌbʉhʉua! Te guí ma̱, ga hocje hñu ya zi ja̱ꞌtsi, ꞌna pa gueꞌi, ꞌna pa ra Moise, ha nuꞌa̱ maꞌna pa ra Elía. Pe nura Pedro himi pa̱di núꞌa̱ mi ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y nura ora tsꞌa mi ma̱nga njabʉꞌa̱, bi zø ꞌnara guui bi goꞌma habʉ mi ꞌbaiꞌʉ. Y nu mi goꞌma ra guuiꞌʉ, xi bi ntsu. ");
INSERT INTO oteNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nepʉ de ja ra guui bi ntꞌøde ꞌnara noya bi ꞌñena njaua: ―Nuni go guehni ma hma̱ca Tꞌʉ. ꞌYøhʉ núꞌa̱ da xiꞌahʉni. ");
INSERT INTO oteNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y nu mi uadi bi ntꞌøde núꞌa̱ ra noya, bi hyandiꞌʉ gue ya hønsɛ ra Jesu mi ꞌbasɛni, y nuꞌʉ́ ya hinte bi ma̱, y nuya paꞌʉ hinto bi xipabi de núꞌa̱ xqui hyandiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Rá hyaxꞌa̱ bá ca̱iꞌʉ de ja ra tꞌøhø, y de guehni bi ma ndunthi ya ja̱ꞌi pa bá cꞌa̱ꞌtsa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nepʉ ꞌnara ꞌñøhø mi pani ja ra hmuntsja̱ꞌi bi ña̱ ntsꞌɛdi ne bi ꞌñembabi ra Jesu: ―Xahnate, ꞌyøtca ra ma̱te e gui nutca tsꞌʉ ma tꞌʉ, ngueꞌa̱ hønsɛna̱ dí pɛꞌtsi, ");
INSERT INTO oteNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","y pɛꞌtsa ꞌnara tsꞌonda̱hi ri japi da mafi, ne da nta̱ni ne da ndu sɛhɛ, ne ri japi asta da ꞌyɛntsꞌa ra fʉgui rá ne. Ntsꞌɛdi xi ri ʉni, y xi xá hñei da døgue. ");
INSERT INTO oteNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya dá xipahma̱ ri nxadi da ꞌyɛmbahma̱, pe hinxa za xa ꞌyɛmbabi. ");
INSERT INTO oteNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nuꞌbʉ́ nura Jesu bi ꞌñena: ―¡Nuꞌahʉ ꞌnagyá ꞌña̱gamfrihʉ ne gyá tsꞌoja̱ꞌihʉ! ¡Asta haꞌmʉ ma ga tsɛꞌtꞌa ri ꞌña̱jamfrihʉ! Nepʉ bi ꞌñembabi núꞌa̱ ra ꞌñøhø: ―Bá tsincaua ri tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pe nu mi tsꞌiꞌtsua ra Jesu núꞌa̱ ra tsꞌʉntꞌʉ, ra tsꞌonda̱hi bi fømi pa ja ra hai ne bi japi bi nta̱ni ne bi ndu sɛhɛ. Pe nura Jesu bi ꞌyɛnga núꞌa̱ ra tsꞌonda̱hi, ne ꞌbestho núꞌa̱ ra oraꞌa̱ bi ña̱ni núꞌa̱ ra tsꞌʉntꞌʉ, ne bi yopa dapa rá dada. ");
INSERT INTO oteNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y gatho ya ja̱ꞌi xi bi ꞌyø de núꞌa̱ rá da̱nga tsꞌɛdi Ajua̱ xqui hnequi. De nuya paꞌʉ xi mri ꞌyø ya ja̱ꞌi de gatho núꞌa̱ xqui ꞌyøtꞌa ra Jesu, nuꞌá̱ bi ꞌñembabi yá nxadi: ");
INSERT INTO oteNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―ꞌYøhʉ xá hño núna ma ga xiꞌahʉ ne oxqui pumfrihʉ: Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma dra da ja yá ꞌyɛ ya ja̱ꞌi pa da ꞌyøꞌtua núꞌa̱ go da neꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pe nuyá nxadi himbi ba̱di te mri bønga núꞌa̱ bi xipabiꞌʉ, ngueꞌa̱ himi tsa da zo yá mfeniꞌʉ. Ne nuꞌʉ́ mi tsu da ꞌyambabi te mri bønga núꞌa̱ xqui xipabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nepʉ nuya nxadi bi mʉdi mri ꞌñámbabi ꞌna ngu maꞌna toꞌo de gueꞌʉ mi ma da uaꞌa̱ da ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pe nura Jesu bi ba̱tho de núꞌa̱ mi beniꞌʉ hangue nuꞌá̱ bi maꞌta ꞌnara zi ba̱tsi bi ꞌbaꞌma ja rá hyoꞌa̱, ");
INSERT INTO oteNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ne bi ꞌñembabiꞌʉ: ―Nuꞌa̱ tóꞌo de ma thuhu da numansu ꞌnara zi ba̱tsi ngu nuna, nugui go ri numansugui, y nuꞌa̱ tóꞌo ri numansugui, go ri numansu núꞌa̱ toꞌo bá pɛncagui. Ngueꞌa̱ nuꞌa̱ tóꞌo hinda ꞌñetsꞌi, núꞌá̱ go gueꞌa̱ da nda̱ngui rá nsu. ");
INSERT INTO oteNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nepʉ nura Xuua bi ꞌñembabiꞌa̱: ―Ma zi Xahnateꞌi, stá hanthe ꞌnara ꞌñøhø de ri thuhu ɛnga ya tsꞌonda̱hi, y nuje stá ha̱cuabihe ngueꞌa̱ nuꞌá̱ hingui ꞌyo con guecjʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pe nura Jesu bi ꞌñembabiꞌa̱: ―Oguí ha̱cuahʉ, ngueꞌa̱ nuꞌʉ tóꞌo hingui ʉtsaguihʉ, go rí maxcaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","De ya mi ma da zø ra pa da yopa mengui ra Jesu pa mahetsꞌi, ꞌna mfenitho bi gʉ ra ꞌñu bi ma pa Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ne bi mɛhna toꞌo bi ꞌmɛtꞌo pa da ma ja ꞌnara hnini de ra hai Nsamaria pa da hyoni habʉ da ꞌñoxiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pe nuya mengu de guehni himbi ne bi umba ntsayaꞌʉ ngueꞌa̱ mri njua̱ꞌñu pa Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pe nu mi ba̱di njabʉ ra Cobo ne ra Xuua núꞌʉ yoho de yá nxadi, bi ꞌñembabi: ―Ma zi Hmuꞌihe, ¿ha hinguí ne ga adihʉ dua ca̱i ya tsibi de mahetsꞌi pa da tsa̱tꞌa nuna hnini ngu núꞌa̱ bi ꞌyøtꞌa ndu ra ba̱di Elía? ");
INSERT INTO oteNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mi ma̱nga njabʉꞌʉ, nura Jesu bi nʉꞌti ne bi zʉi bi ꞌñembabi: ―Nuꞌahʉ́, nixi guí pa̱hʉ te ma nda̱hi guí ha̱npahʉ rá tsꞌɛdi pa guí ma̱ñhʉ njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Núꞌa̱ Toꞌo bá e bi Nja̱ꞌi, himbá ehe pa da hña̱cua yá te ya ja̱ꞌi, núꞌá̱ bá ehe pa da pøhøbi. Nepʉ nuꞌʉ́ bi thogui pa maꞌna ra tꞌʉca hnini. ");
INSERT INTO oteNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Y de guehni má ꞌñu ꞌnara ꞌñøhø bi ꞌñembabi ra Jesu: ―Ma zi Hmuꞌi, dí ne ga tɛnꞌaꞌi habʉraza gui ma. ");
INSERT INTO oteNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ra Jesu bi da̱di ne bi ꞌñembabi: ―Nuya haho ja yá hña̱do, ha nuya tsꞌintsꞌʉ ja yá ꞌbafi, pe Núꞌa̱ Toꞌo bá e bi Nja̱ꞌi otho nixi rá ngu pa habʉ da ntsaya. ");
INSERT INTO oteNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nepʉ bi ꞌñembabi maꞌna ra ꞌñøhø: ―Bá ehe ga mɛ pa dua nxadiꞌi. Ha nuꞌá̱ bi da̱di ne bi ꞌñembabi: ―Ma zi Hmuꞌi, dí ne gui ꞌraca nsɛqui ga ma ga agui ꞌmɛtꞌo ma dada, nepʉ ga pengui ga tɛnꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nuꞌbʉ́ nura Jesu bi da̱di ne bi ꞌñembabi: ―Tsopʉ núꞌʉ xa du da ꞌya yá miꞌña̱gamfriui, pe nuꞌi bá ehe pa gui ma gui ma̱nga ra hoga noya gue ya xa zøhø ra Nda̱ de mahetsꞌi pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nepʉ bi ꞌñembabi ra Jesu maꞌna ra ꞌñøhø: ―Ma zi Hmuꞌi, necagui dí ne ga tɛnꞌaꞌi, pe ꞌraca nsɛqui ꞌmɛtꞌo ma ga edi ya mengu de ja ma ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pe nura Jesu bi ꞌñembabi: ―ꞌBʉ ꞌnara ua̱fri hɛca ꞌnara the ne da ñegui, nurá the ya hinda ma manjua̱ntho. Njabʉ nehe nuꞌa̱ tóꞌo øꞌtua rá ꞌbɛfi Ajua̱ ne da beni gatho núꞌa̱ bi zogui, hinte ri muui pa ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nepʉ ꞌmɛfa ra Jesu bi huahna má hñuꞌrate ne ꞌrɛtꞌa yá nxadi pa bi mɛhni dega yoho da ꞌmɛtꞌoꞌʉ pa ja ya hnini habʉ mi ma da thoguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne bi ꞌñembabi: ―Xi majua̱ni dí xiꞌahʉ, xi ndunthi ra sofo pe tsꞌʉtho ya xofo. Hangue ꞌyaphʉ Ajua̱ núꞌa̱ toꞌo rá mɛti ra sofo dua pɛhna ndunthi ya mɛfi pa da gʉꞌtsua rá sofo. ");
INSERT INTO oteNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y nubyá nuꞌahʉ ma ga pɛhnꞌaꞌihʉ gui maha ngu ya zi dɛti madetho de ya miꞌño, hangue xi da nsuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ne oxqui ha̱xhʉ ni ꞌnari buxahʉ, nixi ri boja̱hʉ, nixi ri ponga zɛsthihʉ. Ne oxqui ꞌbaihʉ gui nzɛnjuatehʉ ꞌmɛtꞌo ja ri ꞌñuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ora gui cʉthʉ ja ꞌnara ngu gui nzɛnjuatehʉ njaua: “Ajua̱ da ja̱pꞌahʉ pa gui ꞌbʉhʉ te rá ꞌñentho.” ");
INSERT INTO oteNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ha nuꞌbʉ ya mengu de nura nguꞌa̱ ne da ꞌmʉ ꞌnara hogaꞌmʉi, nuꞌbʉ́ Ajua̱ da ja̱piꞌʉ ngu gá xiphʉ. Ha nuꞌbʉ hina, Ajua̱ hinda ja̱piꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nu habʉ da tꞌaꞌahʉ ntsaya, ja gui cohʉni ne nuꞌʉ́ da ꞌuiñꞌahʉ, ngueꞌa̱ ꞌnara mɛfi rí ꞌñepi da tꞌumbabi te da zi ne gatho núꞌa̱ te honi. Y ja gui ꞌbʉthʉni, oxqui ꞌyohʉ dega nengu. ");
INSERT INTO oteNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ꞌBʉ gui tsøñhʉ ja ꞌnara hnini ne da tꞌaꞌahʉ ntsaya, tsihʉ gatho núꞌa̱ da tꞌaꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ꞌYøthehʉ ya daꞌthi núꞌʉ di ꞌbʉhni, ne xiphʉ ya mengu de guehni gue ra Nda̱ de mahetsꞌi ya xa ꞌñepʉ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pe nuꞌbʉ gui tsøñhʉ ja ꞌnara hnini ne hinda tꞌaꞌahʉ ntsaya, ꞌbahʉ habʉ da ꞌyødeꞌihʉ ya ja̱ꞌi de guehni ne gui ꞌñemfʉꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ma ga hua̱the ma uahe pa da hyø núꞌa̱ ra hai xa ncueta de nuna ri hninihʉ, ngueꞌa̱ hinxcá camfriguihe núꞌa̱ stá xiꞌahe. Pe pa̱hʉ xá hño gue ra Nda̱ de mahetsꞌi ya xa ꞌñepʉ pa da nda̱, y nuje ya hindí tha̱he de ri tsꞌoquihʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dí xiꞌahʉ gue nura pa de ra ntha̱nguɛnda maꞌna ma da nda̱ngui rá castigo nura hniniꞌa̱ que ra hnini Sodoma núꞌa̱ bi huata Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Huecateꞌihʉ núꞌahʉ gyá menguhʉ Corasí, ne núꞌahʉ gyá me Betsaidahʉ! Ngueꞌa̱ nuꞌbʉ ya mengu de ra hnini Tiro ne de ra hnini Sidó xa hyanthma̱ha̱ nuya milagro xcá hyanthʉbya, núꞌʉ́ xa ñobrihma̱ꞌʉ de yá tsꞌoqui ne xa hñehma̱ co ya he dega dumʉi, ne xa ncoxhma̱ ra ꞌbospi dega ntsøꞌmi. ");
INSERT INTO oteNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pe nura paꞌa̱ sta tha̱pꞌahʉ nguɛnda, maꞌna ma da nda̱ngui ri castigohʉ que ra hnini Tiro ne Sidó. ");
INSERT INTO oteNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ha núꞌahʉ gyá menguhʉ Ncapernau, guí hu ri mʉihʉ gue rí ꞌñepꞌahʉ gui maha mahetsꞌi, pe hina, ngueꞌa̱ nuꞌahʉ ya xa tꞌɛpꞌaꞌihʉ pa gui maha ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nepʉ bi xipabi yá ꞌmɛhni: ―Nuꞌa̱ tóꞌo da ꞌyøde núꞌa̱ gui ma̱ñhʉ, go øtcagui, y nuꞌa̱ tóꞌo hinda ꞌyøde núꞌa̱ gui ma̱ñhʉ, hingo øtcagui, y nuꞌa̱ tóꞌo hingui øtcagui, hingui øta núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nepʉ nu de bá penga núꞌʉ hñuꞌrate ne ꞌrɛtꞌa yá ꞌmɛhni bi zøhø co ndunthi ra johya ne bi ꞌñembabi ra Jesu: ―Ma zi Hmuꞌihe, asta ya tsꞌonda̱hi xa ꞌyøtcahe, ngueꞌa̱ stá ɛñheꞌʉ de ri thuhu. ");
INSERT INTO oteNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ha nura Jesu bi ꞌñembabiꞌʉ: ―Ha̱ha̱, majua̱ni dá handa ra Satá bá tagui de mahetsꞌi ngu ꞌnara huɛi. ");
INSERT INTO oteNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Y nugui stá ꞌraꞌahʉ ra tsꞌɛdi pa gui nethʉ ya quꞌeña̱ ne ya penzʉ, ne pa gui ta̱pabihʉ gatho rá tsꞌɛdi ra tsꞌonda̱hi, nsinque te da ꞌyøꞌtꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pe ogrí johyahʉ ngueꞌa̱ xa ꞌyøꞌtꞌahʉ ya tsꞌonda̱hi, johyahʉ ngueꞌa̱ nuri thuhuhʉ bí ntꞌofo nuni mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ra oraꞌa̱ ra Jesu xi bi johya co rá tsꞌɛdi ra Ma̱ca Nda̱hi ne bi ꞌñena: ―Ma Dadaꞌi, go grá Nda̱ de mahetsꞌi ne de gatho ra ximhai, dí xøcambeniꞌi ngueꞌa̱ xcá utuabi ri noya núyʉ nja ngu ya zi ba̱tsi, y hingo xcá utuabi ya ba̱mhya̱ ne ya nimfeni. Y nuꞌi ma Dadaꞌi, xcá ꞌyøtꞌa njabʉ ngueꞌa̱ gueꞌa̱ ri pahaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mi uadi bi ma̱nga ra Jesu njabʉ bi ꞌñena: ―Ma Dada xa ꞌyɛntcꞌagui gatho ja ma ꞌyɛ. Hinto pa̱tcagui ma ꞌmʉi, hønsɛ Ajua̱ ma Dada go gueꞌa̱ pa̱tca ma ꞌmʉi. Ne hinto pa̱tua rá ꞌmʉi ma Dada, hønsɛgui go dí pa̱di, ne núꞌʉ toꞌo stá huahni pa da ba̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne bi mpʉntsꞌi bi hyanda yá nxadi ne bi ꞌñembi ꞌnambʉ sɛhɛꞌʉ: ―Johyahʉ ngueꞌa̱ guí hanthʉ núꞌa̱ te dí øtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngueꞌa̱ nugui dí xiꞌahʉ gue ndunthi yá ꞌmɛhni Ajua̱ ne ya nda̱ mi ꞌbʉi mayaꞌbʉ mi nehma̱ xa hyanda ngu núꞌa̱ guí hanthʉbya, pe himbi za bi hyantꞌʉ, ne mi nehma̱ xa ꞌyøde ngu núꞌa̱ guí øhʉbya, pe himbi za bi ꞌyødeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nepʉ de gueꞌa̱ ꞌnara xahnate de ra ley bi ma bá cꞌa̱ꞌtsa ra Jesu pa da ꞌyøꞌtua ꞌnara ntꞌani pa da nu te da da̱diꞌa̱, ne bi ꞌyambabi bi ꞌñembi: ―Ma Xahnateꞌi, ¿te mahyoni ga øtꞌe pa ga tsʉdi ra te pa nza̱ntho? ");
INSERT INTO oteNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―¿Te ma̱nga núꞌa̱ xa tꞌofo ja ra ley? ¿Te xcá pa̱di de guí heꞌti? ");
INSERT INTO oteNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nura xahnate de ra ley bi da̱di ne bi ꞌñena: ―Ena njaua: Ma̱di Ajua̱ ri Hmu bí ꞌbʉ mahetsꞌi con gatho ri mfeni, con gatho ri coraso, con gatho ri tsꞌɛdi, ne con gatho ri mʉi, ne ma̱di ri miquꞌeiui ne gui su ngu grí nsu sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nepʉ ra Jesu bi ꞌñembabi: ―Gueꞌa̱ majua̱ni núꞌa̱ xcá ma̱. Nuꞌbʉ gatho gueꞌa̱ guí øtꞌe, nuꞌbʉ́ gui tsʉdi ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pe nura xahnate de ra ley himi ne to da cꞌaꞌtsua rá ntꞌani, hangue bi yopa ꞌyambi ne bi ꞌñembabi: ―¿Toꞌo ma miquꞌeiꞌbe? ");
INSERT INTO oteNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nepʉ ra Jesu bi da̱di ne bi ꞌñembi: ―ꞌNara pa ꞌnara ꞌñøhø mri ne ra ꞌñu, xqui ꞌñe de Jerusale pa mri ma ja ra hnini Jericó, y de má ꞌñu bi daca ꞌraya dacate, ne bi hña̱mbabi gatho núꞌa̱ te mi ha̱, asta yá dutu bi møcuabi, ne xi bi hnaꞌmbabiꞌa̱, ne bi tsꞌohni ya mi nedu. ");
INSERT INTO oteNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nepʉ de gueꞌa̱ bi toca bi ꞌrani ꞌnara macja̱ ja núꞌa̱ ra ꞌñuꞌa̱, ne nu mi hyandi mi ꞌbɛni ja ra nengaꞌñu núꞌa̱ ra ꞌñøhø xqui hnaꞌmbi, nuꞌbʉ́ nuꞌá̱ bá catatho ꞌna lado bi thoguitho. ");
INSERT INTO oteNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nehe bi ꞌrani ꞌnara maste de ra nija̱ núꞌʉ tꞌembi ya levita, neꞌa̱ bi hyandatho núꞌa̱ ra ꞌñøhø mi ꞌbɛni, y nuꞌá̱ bi cata ꞌnambʉ bi thotho nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nepʉ ja núꞌa̱ ra ꞌñuꞌa̱ bi ꞌrani ꞌnara me Nsamaria. Nu mi hyanda núꞌa̱ ra ꞌñøhø mi ꞌbɛni, xi bi huequi. ");
INSERT INTO oteNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nepʉ bi joni bá cꞌa̱ꞌtsi, ne bi goꞌtsuabi ra aceite co ra vinu habʉ xqui tsꞌɛnbabi, ne bi duꞌtuabi. Nepʉ bi ꞌyɛntsꞌa ja rá burru, ne bi zixa asta ja ꞌnara meso, ne ja guehni bi su. ");
INSERT INTO oteNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nepʉ rá hyaxꞌa̱ ante da ma de guehni núꞌa̱ ra me Nsamaria bi hña̱i yoho ya tꞌaxboja̱ ja rá buxa, ne bi umbabi núꞌa̱ ra me meso, ne bi ꞌñembabi: “Dí tsocꞌaua tsꞌʉ nuna ꞌñøhø gui su. Y nuꞌbʉ gá gasta má tsꞌʉ ra boja̱, nu xcrá yopa pengui ga juꞌtꞌaꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nu mi uadi ra Jesu bi ma̱nga njabʉ, bi ꞌyamba ra xahnate de ra ley ne bi ꞌñembi: ―De núꞌʉ hñu ya ꞌñøhø, ¿toꞌo ꞌna de gueꞌʉ mrá miquꞌeiui xi majua̱ni núꞌa̱ ra ꞌñøhø xqui thaqui? ");
INSERT INTO oteNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nepʉ nura xahnate de ra ley bi ꞌñembabi: ―Núꞌa̱ toꞌo bi nja rá nthecate de gueꞌa̱. Nuꞌbʉ́ nura Jesu bi ꞌñembabi: ―Ha̱ha̱, gueꞌa̱ mahyoni gui ꞌyøtꞌe nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","De guehni ra Jesu bi thogui rá ꞌñu, nepʉ bi zønga ja ꞌnara hnini. Y nuni ja mi ꞌbʉhni ꞌnara ꞌbɛhña̱ mrá thuhu ra Marta, y nuꞌá̱ bi umba ntsaya ra Jesu ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ra Marta mi ꞌbʉ ꞌnará cu mrá thuhu ra Maria. Y nuꞌá̱ bi hñudi de rí gaꞌti yá ua ra Jesu pa da ꞌyøde núꞌa̱ mi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pe nura Marta xi mi ja ndunthi te da mɛfi ja ra ngu. Ne bi da̱stꞌi habʉ mi ꞌbʉ ra Jesu ne bi ꞌñembabi: ―Ma zi Hmuꞌi, ¿hinguí handi gue ma cu bi zogasɛ gatho ra ꞌbɛfi? Xipabi tsꞌʉ da e da maxcagui. ");
INSERT INTO oteNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pe nura Jesu bi ꞌñembabi ra Marta: ―Marta, xi guí xøna ri ꞌbɛfi ne guí tu ri mʉi ngueꞌa̱ ndunthi ri ꞌbɛfi, ");
INSERT INTO oteNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pe hønsɛ ꞌnara ꞌbɛfi mahyoni gui ꞌyøtꞌe, ngu nuna hoga ꞌbɛfi xa huahna ra Maria, y hinda za toꞌo da hña̱cuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ꞌNara pa ra Jesu bi ꞌyapabi Ajua̱ rá Dada ja ꞌnara luga, y nu de mi uadiꞌa̱, ꞌnará nxadi bi ꞌñembabi: ―Ma zi Hmuꞌi, dí ne gui ꞌñutcaguihe hanja ga apabihe Ajua̱ ngu mi nja ra Xuua mi utuabi yá nxadi hanja da ꞌyapabi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nura Jesu bi ꞌñembabiꞌʉ: ―Nu de xcrí ꞌyaphʉ Ajua̱ gui ꞌñeñhʉ njaua: Ma zi Dadaꞌihe, guí ꞌbʉi mahetsꞌi, drá nsunda ri ma̱ca thuhu. Bá ehe gui nda̱, ne dá tꞌøtꞌa ri paha nuua ja ra ximhai ngu núꞌa̱ bí tꞌøtꞌe núbʉ mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ꞌRacje te ga tsihe núbya rapaya. ");
INSERT INTO oteNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ne pungaguihe ma tsꞌoquihe, ngueꞌa̱ necje dí pumbabihe núꞌʉ toꞌo xa ꞌyøtcahe ra ntsꞌoꞌmʉi. Ne oxqui hocje ga øthe ya tsꞌoqui, ña̱ngaguihe de ra ntsꞌo. ");
INSERT INTO oteNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nehe ra Jesu bi ꞌñembabi yá nxadi: ―Ma ga ma̱ñhʉ gue ꞌna toꞌo pɛꞌtsa ꞌnará ꞌnangu ne drá amigo, nepʉ ngu made ra xuui da ma ja rá ngu, ne da ꞌñembabi: “Drá ꞌñehe gui ꞌyøtca ra favo gui hmica hñu ya thuhme, ");
INSERT INTO oteNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ngueꞌa̱ ja núbya bi zøhø maꞌna ma amigo xqui ꞌñehe de yabʉ ha othogui te ga umbabi.” ");
INSERT INTO oteNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nepʉ nuꞌá̱ sta da̱di mbo rá ngu da ꞌñena: “Hindí honi gui zocagui, ma gosthi ya stá cotꞌi, ne dí huixa ma ba̱tsi, hangue hingui tsa ga nangui ga ꞌraꞌaꞌi núꞌa̱ guí adi.” ");
INSERT INTO oteNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pe nugui dí xiꞌahʉ gue hinda nangui da umbi ngueꞌa̱ rá amigo, nuꞌá̱ da nangui da umbi, pe ngueꞌa̱ ya pa hinda sigui da ꞌyapa rá tꞌa̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hangue dí xiꞌahʉ, ꞌyaphʉ Ajua̱ núꞌa̱ guí hoñhʉ ne da ꞌraꞌahʉ; hyoñhʉ núꞌa̱ te ri ꞌbɛpꞌahʉ, ne gui tsʉdihʉ; njahʉ ngu ꞌnara ja̱ꞌi bi zøhø ꞌrota ra gosthi ne bi socuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngueꞌa̱ nuꞌa̱ tóꞌo da ꞌyadi, da tꞌumbabi; y nuꞌa̱ tóꞌo da hyoni, da zʉdi; y nuꞌa̱ tóꞌo da ꞌrota ra gosthi, da socuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nuꞌahʉ gyá dadahʉ, ꞌbʉ ri ba̱tsihʉ da ꞌyaꞌahʉ ꞌnara thuhme, ¿ha gue gui umfʉ ꞌnara do? O ꞌbʉ da ꞌyaꞌaꞌihʉ ꞌnara hua̱, ¿ha gue gui umfʉ ꞌnara quꞌeña̱? ");
INSERT INTO oteNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ꞌbʉ da ꞌyaꞌaꞌihʉ ꞌnara ma̱do, ¿ha gue gui umfʉ ꞌnara penzʉ? Hina, ¿ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nuꞌahʉ masque gyá ꞌyøtꞌatsꞌoquihʉ, pe guí pa̱ gui umfʉ ꞌnara hoga tꞌøtꞌe ri ba̱tsihʉ. ¡Xihma̱ ra Dada bí ꞌbʉi mahetsꞌi, núꞌá̱ dua pɛnpabi ra Ma̱ca Nda̱hi toꞌo da ꞌyapabiꞌa̱, ne gatho maꞌra ya hño! ");
INSERT INTO oteNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ꞌNara pa ra Jesu bi ꞌyɛmba ꞌnara tsꞌonda̱hi ꞌnara ꞌñøhø xqui japi da ngone. Ne de mi bønga núꞌa̱ ra tsꞌonda̱hi, ꞌbestho bi za bi ña̱ núꞌa̱ ra ꞌñøhø. Ha nu mi hyanda ya ja̱ꞌi njabʉ xi bi ꞌyøꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pe ꞌra de gueꞌʉ bi ña̱maꞌñʉ ne bi ꞌñena: ―Nuni ra ꞌñøhø ɛnga ya tsꞌonda̱hi co rá tsꞌɛdi ra Beelsebú núꞌa̱ ra nda̱ de ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ha nu maꞌra mi xipabi da ꞌyøtꞌa ꞌnara ntꞌudi de mahetsꞌi, pa da ꞌñudi ua xi majua̱ni mrá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pe nura Jesu bi ba̱tho te mi beniꞌʉ, hangue bi ꞌñembabi: ―ꞌBʉ ꞌnara hnini da hyegue ne da ntuhni sɛhɛ, nuꞌbʉ́ da nhuata núꞌa̱ ra hmanda mi ja. O nuꞌbʉ ꞌnara ngu da ntuhnisɛ ya mengu de ra ngu, hinda za da ꞌmʉ ꞌnadbʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Njabʉtho nehe, nuꞌbʉ ra Satá da ntuhnui yá mitsꞌonda̱hiui, nuꞌbʉ́ da nhuata gatho rá tsꞌɛdiꞌa̱. Nugui dí xiꞌahʉ njabʉ ngueꞌa̱ guí eñhʉ gue nugui dí ɛnga ya tsꞌonda̱hi co rá tsꞌɛdi ra Beelsebú ra nda̱ de ya tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pe nuꞌbʉ gueꞌa̱ gra øtꞌe, nuꞌbʉ́ xi ri ꞌmɛhnihʉ, ¿con te ma tsꞌɛdi ɛnga ya tsꞌonda̱hi? Núꞌʉ́ go dá xiꞌahʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nugui dí ɛnga ya tsꞌonda̱hi pe co rá tsꞌɛdi Ajua̱, hangue pa̱hʉ gue nura Nda̱ de mahetsꞌi ya xa zøhø pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nuꞌbʉ ꞌnara ꞌñøhø xi o rá tsꞌɛdi ne ri hña̱ yá arhma pa ri su rá ngu, nuꞌbʉ́ ꞌbɛꞌtsa xá hño núꞌa̱ te pɛꞌtsa ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pe nuꞌbʉ da zøhø maꞌna ra ꞌñøhø maꞌna di o rá tsꞌɛdi que gueꞌa̱, nuꞌbʉ́ da nta̱te núꞌa̱ bi zøhø ne da hña̱mbabi gatho yá arhma núꞌʉ mi hu rá mʉi da matsꞌi, ne da bepabi gatho núꞌa̱ di pɛꞌtsa ja rá ngu pa da jamɛtiꞌa̱ ne da hyecuabi maꞌra. ");
INSERT INTO oteNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nuꞌa̱ tóꞌo hingui ꞌbʉi con guequi, gueꞌa̱ ri contragui, ne nuꞌa̱ tóꞌo hingui faxqui ga muntsꞌa ya gamfri, go gueꞌa̱ xani. ");
INSERT INTO oteNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nuꞌbʉ ꞌnara tsꞌonda̱hi da bønga de ja ꞌnara ꞌñøhø da ꞌño habʉraza ja ra mbonthi honga ra tsaya, pe nuꞌbʉ de guehni hindua tsʉdi habʉ, nuꞌbʉ́ da beni ne da ꞌñena: “Pøde ga yopa pengui habʉ nduí ꞌbʉi.” ");
INSERT INTO oteNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ha nu stua yopa pengui e da zʉdi núꞌa̱ ra ꞌñøhø habʉ mbi ꞌbʉi, da zʉtua rá mfeni di nja ngu ꞌnara ngu núꞌa̱ xa thoqui xi xá hño, xa ꞌbastꞌi ne xi strá ntꞌaxi da zʉdi, pe hinto di ꞌbʉhni. ");
INSERT INTO oteNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nepʉ núꞌa̱ ra tsꞌonda̱hiꞌa̱ da ma dua tsi má yoto yá mitsꞌonda̱hiui maꞌna strá ntsꞌo que gueꞌa̱, y da zøhø da yʉtꞌa gatho ja rá mfeni núꞌa̱ ra ꞌñøhø y ja da ꞌmʉhni ri gathoꞌʉ, y njabʉ núꞌa̱ ra ꞌñøhøꞌa̱ maꞌna da tsꞌocua rá mfeni que rá mʉdi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tsꞌa mi ña̱ njabʉ ra Jesu, ꞌnara ꞌbɛhña̱ mi ꞌbʉhni bi ña̱ ntsꞌɛdi ne bi ꞌñena: ―¡Xi nja̱pi núꞌa̱ ra ꞌbɛhña̱ de habʉ gá ꞌbʉi, ne bi tedeꞌi! ");
INSERT INTO oteNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pe nura Jesu bi da̱di ne bi ꞌñena: ―¡Maꞌna xa nja̱pi núꞌʉ toꞌo øtuabi rá noya Ajua̱ ne øtꞌe núꞌa̱ ma̱! ");
INSERT INTO oteNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ya ja̱ꞌi ꞌyo mri muntsꞌi gatho ja rá nthetsꞌi ra Jesu, nepʉ nuꞌá̱ bi ꞌñembabiꞌʉ: ―Ya ja̱ꞌi de nuya pabya xi ya tsꞌoja̱ꞌi, hangue adi ꞌnara ntꞌudi ga utuabi pa da ba̱di ua xi xuá pɛncagui Ajua̱. Pe núꞌa̱ ra ntꞌudi adiꞌʉ hinga ma ga utui, hønsɛ ndaꞌa̱ da tꞌutuabi, núꞌa̱ ra ntꞌudi de ra ba̱di Joná. ");
INSERT INTO oteNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngueꞌa̱ núꞌa̱ bi tho ra Joná núꞌbʉ mi dutꞌa ꞌnara da̱hua̱ ne ja bi gohni hñu pa, mi gueꞌa̱ ꞌnara ntꞌudi pa ya me Ninive gue ra Joná go mrá ꞌmɛhni Ajua̱. Njabʉ nehe Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi ma da ꞌmʉi hñu pa mbo ra hai, y núꞌá̱ go gueꞌa̱ ꞌnara ntꞌudi da tꞌutuabi núꞌʉ ya ja̱ꞌi ꞌbʉi mapaya. ");
INSERT INTO oteNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nu stí zø ra pa de ra nsʉca uɛnda, nura paꞌa̱ ra ꞌbɛhña̱ núꞌa̱ mrá nda̱ de ra hai Arabia ma da ꞌmai ja rá thandi núꞌa̱ toꞌo ma da hña̱nga nguɛnda pa da ña̱pabi núꞌʉ ya ja̱ꞌi ꞌbʉi mapaya. Ngueꞌa̱ nura ꞌbɛhña̱ꞌa̱ masque xi mi yabʉ rá hai pe bá ehe e bi ꞌyøde núꞌa̱ ra mfa̱di mi pɛꞌtsa ndu ra Salomó. Pe ꞌbʉcua ꞌna maꞌna ra da̱ngui rá nsu que ra Salomó, pe masque njabʉ hinxa ne toꞌo xa ꞌyøde núꞌa̱ ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nehe nura pa de ra nsʉca uɛnda núꞌʉ ya me Ninive ma da ꞌmai ja rá thandi núꞌa̱ toꞌo da hña̱nga nguɛnda pa da ña̱pabi núꞌʉ ya ja̱ꞌi ꞌbʉi mapaya. Ngueꞌa̱ núꞌʉ ya me Ninive ngu mi ꞌyøde núꞌa̱ bi ma̱nga ra ba̱di Joná de núꞌa̱ xqui ma̱nga Ajua̱, nuꞌbʉ́ nuꞌʉ́ bi da̱ma ñobri ꞌbestho. Pe ꞌbʉcua ꞌna maꞌna ra da̱ngui rá nsu que ra Joná, pe masque njabʉ hinxa ne toꞌo xa ꞌyøde núꞌa̱ ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Joꞌo ꞌnara ja̱ꞌi toꞌo da tsøgue ꞌnara ñotꞌi ne da ꞌña̱gui, o da yeꞌmba ꞌnara caho. Nuꞌa̱ da ꞌyøtꞌe, da tøta habʉ da tøte, pa da yotꞌa gatho mbo ra ngu pa di handi núꞌʉ toꞌo da yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nuri dahʉ gueꞌʉ ngu ꞌraya ñotꞌi de ri ndoꞌyohʉ. Nuꞌbʉ ri dahʉ xá hño, guí hanthʉ habʉ guí ꞌyohʉ, pe nuꞌbʉ ri dahʉ hingui ho, hinguí hanthʉ habʉ guí ꞌyohʉ. Njabʉ ri mfenihʉ nehe, ꞌbʉ ꞌbʉi xá hño, nuꞌbʉ́ da za gui ꞌyohʉ xá hño ja ra ñotꞌi, pe nuꞌbʉ hingui ꞌbʉi xá hño, hinda za gui ꞌyohʉ xá hño ngueꞌa̱ guí ꞌbʉhʉ ja ra ꞌbɛxuui. ");
INSERT INTO oteNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hangue ꞌyøthʉ ꞌnara tsꞌɛdi pa da ꞌmʉi xá hño ri mfenihʉ pa da za gui ꞌyohʉ xá hño ne hingui ꞌbʉhʉ ja ra ꞌbɛxuui. ");
INSERT INTO oteNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nuꞌbʉ ri mfenihʉ ꞌbʉi xá hño, nuꞌbʉ́ guí ꞌyohʉ ja ra hoga ñotꞌi ne guí pa̱hʉ habʉ guí ꞌyohʉ, ngueꞌa̱ ri mfenihʉ nja ngu ꞌnara ñotꞌi ri yotꞌa ri ꞌñuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nu mi uadi bi ma̱nga njabʉ ra Jesu, ꞌnara fariseo bi zitsꞌi pa da ñungüi ja rá ngu. Y nu mi zøni bi yʉtꞌiꞌʉ, ha nura Jesu bi hñudi ꞌbestho ja ra mexa. ");
INSERT INTO oteNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ha nura fariseo xi bi ꞌyø mi hyandi gue ra Jesu himbi nxʉꞌyɛ ꞌmɛtꞌo pa bi ñuni ngu myá nza̱iꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nuꞌbʉ́ nura Jesu bi ꞌñembabiꞌa̱: ―Nuꞌahʉ fariseohʉ guí njahʉ ngu ra xʉtꞌa vaso ne ra xʉtꞌa manza, xʉqui hønsɛ møte ha nu mbo xi rá ntsꞌo. Nuꞌahʉ́ guí ne gui pønga ri hmihʉ ja yá thandi ya ja̱ꞌi, pe oda ri mfenihʉ ra nthate ne ra ntsꞌoꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡ꞌNagyá ꞌbɛmfenihʉ! ¿Ha hinguí pa̱hʉ gue Ajua̱ go gueꞌa̱ bi hyoca maxøgue rá ꞌbai ra ja̱ꞌi, de thi rá ndoꞌyo ne de mbo rá mfeni? ");
INSERT INTO oteNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bá faxhʉ ya hyoya con gatho ri mʉihʉ, y njabʉ ha̱, da hnequi gue xá ntꞌaxi ri mfenihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Huecateꞌihʉ nuꞌahʉ fariseohʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Ngueꞌa̱ guí ꞌuecjʉ ꞌrɛtꞌa de ra bɛxo pa Ajua̱ de núꞌa̱ guí pahʉ de ra xa̱cꞌri ne ra ruda ne gatho maꞌra ya nda̱po núꞌʉ hintsꞌʉ ri muui ndunthi, pe nura hño hinguí øꞌtuahʉ ri miquꞌeihʉ, nixi otho ri hma̱tehʉ co Ajua̱. Xá hño gui umfʉ Ajua̱ núꞌa̱ rí ꞌñepabi de ya tꞌøtꞌe guí pahʉ, pe maꞌna mahyoni hingui pumfrihʉ gui ꞌyøthʉ nza̱ntho ra hño ne gui pɛꞌtshʉ ra hma̱te co Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Huecateꞌihʉ nuꞌahʉ fariseohʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Ngueꞌa̱ nza̱ntho guí ne gui hñuhʉ ja ya hoga hudi dega nsu ja ya nija̱, ne nza̱ntho guí nehʉ dra zɛnjuaꞌihʉ co ndunthi ra tꞌequꞌei ja ya tai. ");
INSERT INTO oteNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Núꞌahʉ gyá xahnatehʉ de ra ley, ne núꞌahʉ gyá fariseohʉ, ꞌnagyá yohmihʉ! ¡Huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Ngueꞌa̱ nuꞌahʉ guí tsꞌocuahʉ yá mfeni ya ja̱ꞌi, guí njahʉ ngu ya ntꞌagui hingui hnequi, ha ꞌrani ya ja̱ꞌi maña̱ de gueꞌʉ pe nixi pa̱diꞌʉ tengu rá ntsꞌo mbo. ");
INSERT INTO oteNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nepʉ bi da̱di ꞌnara xahnate de ra ley ne bi ꞌñembabi ra Jesu: ―Ma Xahnateꞌihe, ora guí ma̱ njabʉ, guí ña̱maꞌñʉ de guecje nehe núje dyá xahnatehe de ra ley. ");
INSERT INTO oteNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pe nura Jesu bi ꞌñembabiꞌʉ: ―¡Huecateꞌihʉ nuꞌahʉ gyá xahnatehʉ de ra ley ngueꞌa̱ ma xi dra castigaꞌihʉ nehe! Ngueꞌa̱ guí japhʉ ya ja̱ꞌi da ꞌyøtꞌa ꞌraya tꞌøtꞌe núꞌʉ hingui tsa da ꞌyøtꞌe, pa guí eñhʉ gue njabʉ da za da dɛnba rá ley Ajua̱, ha nuꞌahʉ́ nixi guí øtuahʉ nurá leyꞌa̱, ja ra uɛnda guí tutuahʉ ya ja̱ꞌi ꞌnara ꞌbatsꞌi xi rá hñʉ y ni tsꞌʉ hinguí faxhʉ da ndude. ");
INSERT INTO oteNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Huecateꞌihʉ ngueꞌa̱ ma xi dra castigaꞌihʉ! Ngueꞌa̱ guí yopa hocuahʉ yá pantyo ndu yá ꞌmɛhni Ajua̱ núꞌʉ bi hyosɛ ndu ri xitahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Njabʉ ri hnequi gue guí tɛnbathohʉ yá ꞌmʉi ndu ri xitahʉ, ngueꞌa̱ núꞌʉ́ go gueꞌʉ bi hyo nuya ꞌmɛhniꞌʉ, ha nuꞌahʉ go guí yopa hocuahʉ yá pantyo, hangue ri hnequi gue ꞌnada ri mfenihʉ co ndu ri xitahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hangue sɛhɛ Ajua̱ go gueꞌa̱ xqui ꞌñena co rá da̱nga mfa̱diꞌa̱: “Núꞌʉ́ ma ga pɛnpa ma ꞌmɛhni núꞌʉ da ma̱nga ma noya, pe ꞌra de gueꞌʉ ma da hyoꞌʉ, ha nu maꞌra ma da ʉtsaꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hangue nuya ja̱ꞌi ꞌbʉibya, Ajua̱ ma da hña̱ꞌmba nguɛndaꞌʉ de gatho yá ma̱ca ji yá ꞌmɛhni Ajua̱ xa mfani desde bi mʉdi ra ximhai, ");
INSERT INTO oteNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde ra Abé asta ra Sacaría núꞌa̱ bi tho mbo ra nda̱nija̱ guetbʉ ja ra ata. Hangue nugui dí xiꞌahʉ gue Ajua̱ ma da ꞌyambabi núꞌʉ ya ja̱ꞌi ꞌbʉi mapaya de núꞌʉ ya hoja̱ꞌi xa tho. ");
INSERT INTO oteNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Huecateꞌihʉ nuꞌahʉ gyá xahnatehʉ de ra ley ngueꞌa̱ ma xi dra castigaꞌihʉ! Ngueꞌa̱ go osɛ ri ꞌyɛhʉ rá mfa̱di de ra ma̱ca noya, pe nuꞌahʉ́ ni guí hophʉ maꞌra toꞌo da nehma̱ da ba̱di, ha ni gueꞌahʉ hinguí ne gui pa̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nu mi uadi bi ma̱nga njabʉ ra Jesu, ya xahnate de ra ley ne ya fariseo xi bi bø yá cuɛ con gueꞌa̱, nepʉ bi mʉdiꞌʉ xi bi ꞌyøꞌtua ndunthi ya ntꞌani, ");
INSERT INTO oteNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ngueꞌa̱ mi ne xa ꞌyødeꞌʉ da ña̱maꞌñʉꞌa̱ pa njabʉ xa za xa ña̱pabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nepʉ de gueꞌa̱ bi muntsꞌa ya ꞌmotho gá ja̱ꞌi, y co yá ndunthiꞌʉ mri netꞌasɛ ꞌna ngu maꞌna. Y nura Jesu bi mʉdi bi zofo ꞌmɛtꞌo sɛhɛ yá nxadi ne bi ꞌñembabi: ―Jamasuhʉ de yá tsꞌo ntꞌutuate ya fariseo, ngueꞌa̱ nuꞌʉ́ xi ya yohmi, ne yá ntꞌutuate nja ngu ra nzoi tsini. ");
INSERT INTO oteNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pe ma da zø ra pa da fa̱tuabi yá ntꞌutuate gue xá ntsꞌo, ngueꞌa̱ gatho núꞌa̱ tꞌa̱guibya, ꞌnara pa ma da hnequi, ne gatho núꞌa̱ tꞌøtꞌe mantꞌa̱guibya, ma da zø ra pa da fa̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hangue nugui dí xiꞌahʉ gue gatho núꞌa̱ guí ma̱ñhʉ mantꞌa̱gui, ꞌmɛfa ma da fa̱di habʉraza, y gatho núꞌa̱ guí ma̱ñhʉ dega njone ꞌnambʉ, nuꞌá̱ ma da hma̱ ntsꞌɛdi pa da ntꞌøde habʉraza. ");
INSERT INTO oteNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nepʉ ra Jesu bi ꞌñembabiꞌʉ: ―Núꞌahʉ guí ꞌyohʉ con guequi, oxqui tsuhʉ núꞌa̱ toꞌo da ne da hña̱cꞌa ri tehʉ ne ꞌmɛfa ya hinda za te da ꞌyøꞌtꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nugui dí xiꞌahʉ, gue nu Ajua̱ hønsɛ go gueꞌa̱ mahyoni gui tsuhʉꞌa̱, ngueꞌa̱ nuꞌá̱ da za da hña̱cꞌa ri tehʉ, ne pɛꞌtsa ra tsꞌɛdi pa da mɛhnꞌahʉ ja ra nidu nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ya zi tsꞌintsꞌʉ hintsꞌʉ ri muui asta ꞌba cʉtꞌa por ngʉdmi, ¿ha ngue ha̱? Masque nuꞌʉ́ hini muui ndunthi, pe Ajua̱ hinhyaꞌmʉ ri pumfri ni ꞌna de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xihma̱ꞌihʉ, gue asta ri sta̱hʉ Ajua̱ pa̱di ri hanguꞌʉ. Hangue oguí tsuhʉ, ngueꞌa̱ maꞌna grí muuihʉ que nuya tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ne dí xiꞌahʉ gue gatho núꞌʉ toꞌo ma da ma̱nga ja yá thandi ya ja̱ꞌi gue xa gamfrigui, necagui ma ga ma̱nga ja yá thandi yá ɛnxɛ Ajua̱ gue majua̱ni xa gamfrigui. ");
INSERT INTO oteNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pe nuꞌʉ tóꞌo tsu ne cøngagui ja yá thandi ya ja̱ꞌi, necagui ma ga ma̱ ja yá thandi yá ɛnxɛ Ajua̱ gue nuꞌʉ́ hinstá pa̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nuꞌa̱ tóꞌo da ña̱maꞌñʉ de Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, Ajua̱ da pumbabi; pe nuꞌa̱ tóꞌo da ña̱maꞌñʉ de ra Ma̱ca Nda̱hi, nuꞌá̱ hinda pumbabiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nu sta tsꞌixꞌahʉ ja yá nija̱ꞌʉ o ja yá thandi ya nzaya o ja maꞌra ya nda̱ de ya hnini, oxqui tu ri mʉihʉ ndaꞌa̱ ma gui tha̱dihʉ, nixi oxqui beñhʉ ꞌmɛtꞌo ndaꞌa̱ ma gui ma̱ñhʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ngueꞌa̱ nura ora gui ña̱hʉ, rá Ma̱ca Nda̱hi Ajua̱ ma da ꞌñuꞌtꞌahʉ ndaꞌa̱ rí ꞌñepi gui ma̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nepʉ ꞌna de núꞌa̱ ra hmuntsja̱ꞌi bi ꞌñembabi ra Jesu: ―Ma Xahnateꞌi, xipa tsꞌʉ ma cu da ꞌracagui núꞌa̱ rí ꞌñepqui de núꞌa̱ bi zogahe ndu ma dadahe. ");
INSERT INTO oteNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pe nura Jesu bi ꞌñembabiꞌa̱: ―Xiꞌaꞌi, ¿pa te guí xiqui njabʉ? ¿Xi toꞌo xa hñuxcaguiga dega nzaya o dega hyeca hai? ");
INSERT INTO oteNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nehe bi ꞌñena: ―Jamasuhʉ pa hingui hyøcuahʉ yá hño ra ximhai ne gui ne gui pɛꞌtshʉꞌʉ, ngueꞌa̱ hingue po ya hño de ra ximhai ma da nja rá te ra ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nepʉ bi xipa ꞌnara ꞌbede núꞌa̱ ra hmuntsja̱ꞌi, ne bi ꞌñembabi: ―Mi ꞌbʉi ꞌnara ꞌñøhø xi mi pɛꞌtsa ndunthi yá hño, y nuyá hai nehe bi unga ꞌnara da̱nga sofo. ");
INSERT INTO oteNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nepʉ núꞌa̱ ra ꞌñøhø bi ꞌño rá mfeni ne bi ꞌñena: “¿Te ga øtbya gue otho habʉ ga pɛꞌtsa gatho ma sofo?” ");
INSERT INTO oteNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y nuꞌá̱ bi beni ne bi ꞌñensɛ: “Ya dí pa̱di te ma ga øtꞌe, ma ga yøꞌta nuyʉ ma troha, ne ma ga hoca maꞌra maꞌna dya da̱ngui, ne ja ga ʉtni gatho ma sofo ne gatho núꞌa̱ maꞌna te dí pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y nu xcrá juadi ga pɛꞌtsni gatho, nuꞌbʉ́ ga embabi ma te: Nubyá ha̱, jani gatho núꞌa̱ te gui hyoni pa ndunthi ya jɛya da ꞌñepʉ. Nubyá da za gui ntsaya, gui ñuni, gui ntsithe, gui johya ndunthi.” ");
INSERT INTO oteNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pe Ajua̱ bi ꞌñembabi núꞌa̱ ra ꞌñøhø: “ꞌNagrá ꞌbɛmfeni, núbya dí nxuui ma gui tu, y gatho núꞌa̱ guí pɛꞌtsi, ma gui tsopʉ nixi guí pa̱di pa toꞌo.” ");
INSERT INTO oteNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Njabʉtho nehe núꞌa̱ toꞌo xa muntsꞌa ndunthi yá hño pa guesɛꞌa̱, pe nu sta du, ma da hñoya ja rá thandi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nepʉ ra Jesu bi ꞌñembabi yá nxadi: ―Nubyá dí xiꞌahʉ, oguí tu ri mʉihʉ de núꞌa̱ te gui tsihʉ nixi núꞌa̱ te gui hyehʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngueꞌa̱ nuri tehʉ maꞌna ri muui que ra hñuni, ha nuri ndoꞌyohʉ maꞌna ri muui que ra he. ");
INSERT INTO oteNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hyanthʉ ya ca, nuꞌʉ́ hingui potꞌi nixi xofo, nixi otho yá troha, pe Ajua̱ go gueꞌa̱ ri ꞌuiniꞌʉ. ¡Pe nuꞌahʉ maꞌna grí muuihʉ que ya ca, ne maꞌna grí muuihʉ que nuꞌa̱raza ya tsꞌintsꞌʉ! ");
INSERT INTO oteNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Toꞌo ꞌna de gueꞌahʉ núꞌa̱ da hñuxa má tsꞌʉ rá hñetsꞌi de rá tsꞌɛdisɛ? Ni ꞌna hinda za da ꞌyøtꞌa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nuꞌbʉ́ ¿hanja guí tu ri mʉihʉ po maꞌra ya tꞌøtꞌe de ri tehʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Hyanthʉ ya døni hanja gra nhye. Nuꞌʉ́ hingui hetꞌi nixi pɛ maꞌna ra ꞌbɛfi, pe maꞌna ri hnequi mahotho que yá hoga he ra nda̱ Salomó masque mri hñe mahothoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ꞌBʉ Ajua̱ heta ya nda̱po núꞌʉ ꞌba ja ra mbonthi da ndømbya, ne rixudi dra cꞌʉꞌtsi ne dra tsꞌa̱tꞌi, xi nuꞌahʉ, ¿hanja hinguí camfrihʉ gue Ajua̱ maꞌna da heꞌtꞌahʉ que gueꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hangue odi oda ri mfenihʉ núꞌa̱ te gui tsihʉ ne núꞌa̱ te gui hyehʉ, ne odi tu ri mʉihʉ núꞌa̱ te ri ꞌbɛꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ngueꞌa̱ gatho núꞌʉ ya ja̱ꞌi hingui camfri, nza̱ntho oda yá mfeni núꞌa̱ te da zi ne te da hye, ne tu yá mʉiꞌʉ ꞌbʉ te ꞌbɛpabi. Pe ri Dadahʉ núꞌa̱ bí ꞌbʉ mahetsꞌi, nuꞌá̱ pa̱di xá hño te gatho øꞌtꞌahʉ ra ꞌbɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nuꞌahʉ, nuꞌa̱ gui ꞌyøthʉ, ꞌmɛtꞌo hyoñhʉ hanja da za gui ꞌbʉhʉ xá hño ja rá hmanda Ajua̱, y nuꞌá̱ da ꞌraꞌahʉ gatho núꞌa̱ te gui hyoñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma zi tꞌʉca taxo dɛtiꞌihʉ, oguí tsuhʉ núꞌa̱ te da ꞌbɛꞌaꞌihʉ, ngueꞌa̱ Ajua̱ ri Dadahʉ go gueꞌa̱ rá paha pa gui ꞌbʉhʉ ja rá hmandaꞌa̱, ne nuꞌá̱ ma da suꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hangue pahʉ gatho núꞌa̱ guí pɛꞌtshʉ, ne hyecuabihʉ ya hyoya, njabʉ gui øtꞌa ri ꞌmɛꞌtsihʉ nuni mahetsꞌi núꞌa̱ hinhyaꞌmʉ da thegue nixi da tsꞌoqui, ne nuni hinda za da yʉtꞌa ya be pa da bepꞌahʉ, nixi ya zuꞌue hinda zipꞌahʉ núꞌa̱ xcá pɛꞌtshʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ngueꞌa̱ habʉ ja ri ꞌmɛꞌtsihʉ, ja guehni oda ri mfenihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Hñocjʉ ne ndøꞌmhʉ. Njahʉ ngu ꞌraya hoga ꞌbɛgo di zø yá ñotꞌi ne tøꞌma yá hmu sta menga ja ꞌnara ngo dega ntha̱ti, ha nu sta gantꞌa ra gosthi, nuꞌʉ́ ꞌbestho da xocuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma da johya ndunthi núꞌʉ ya ꞌbɛgo di nuhu sta zø yá hmu. Nugui dí xiꞌahʉ gue nura hmuꞌa̱ da mø ra mexa ne da ꞌñei da ꞌuini. ");
INSERT INTO oteNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masque ꞌbʉ da zøhø made ra xuui o ante da hyatsꞌi, ma da johya ya ꞌbɛgo núꞌʉ da tsꞌʉdi di nuhu. ");
INSERT INTO oteNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nehe dí xiꞌahʉ, ꞌbʉ ꞌnara ja̱ꞌi di pa̱hma̱ haꞌmʉ da zøhø ra be ja rá ngu, nuꞌbʉ́ nura ja̱ꞌiꞌa̱ hinda ꞌña̱ha̱, di su rá ngu pa hinda hyopabi ra be da yʉtꞌi da bepi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hangue neꞌaꞌihʉ ndøꞌmihʉ, ngueꞌa̱ núꞌa̱ ra pa nixi gri beñhʉ, gueꞌbʉ xcrí tha̱mfrihʉ ma dua yopa pengui Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nepʉ ra Pedro bi ꞌyambi ne bi ꞌñena: ―Ma zi Hmuꞌi, xi nuna ꞌbede ja juadi gá ma̱, ¿ha gue hønsɛ pa guecje, o pa gatho ya ja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nepʉ ra zi Hmu Jesu bi ꞌñena: ―Xi ꞌnara hmu de ꞌnara ngu, ꞌbʉ da bøni da ma, ¿toꞌo da zocuabi rá ꞌbɛfi pa da su ne pa da ꞌuimba gatho yá mɛfi? Da zocuabi ꞌnara hoga ꞌbɛgo núꞌa̱ pa̱ da su gatho, ¿ha ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xi da johya núꞌa̱ ra ꞌbɛgo nu sta zø rá hmu di øtꞌa gatho ngu núꞌa̱ xqui zocuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Majua̱ni dí xiꞌahʉ, gue núꞌa̱ ra hmu ma da hñuxa núꞌa̱ ra hoga ꞌbɛgo pa da supa gatho núꞌa̱ di pɛꞌtsa ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pe nuꞌbʉ núꞌa̱ ra ꞌbɛgo toꞌo bi tsꞌogui pa da supa rá ꞌbɛfi rá hmu, da beni gue hiꞌme dua penga rá hmu, nepʉ nuꞌá̱ da mʉdi da naꞌmbabi yá miꞌbɛgoui ne ya ꞌbɛhña̱ núꞌʉ ri ꞌmɛgo pa da ꞌuinga ya mɛfi, y nuꞌá̱ go xi dri ñuni ne dri nti. ");
INSERT INTO oteNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ha nurá hmu da zøhø núꞌa̱ ra paꞌa̱ hindi tøꞌmi. Nuꞌbʉ́ nura ꞌbɛgoꞌa̱ ma da castiga rá hmu ngu ma da ncastiga núꞌʉ maꞌra ya tsꞌoꞌbɛgo. ");
INSERT INTO oteNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nuꞌa̱ ra ꞌbɛgo pa̱di xá hño núꞌa̱ rá hne rá hmu, ne hinda ꞌyøtꞌe, núꞌá̱ xi dra castiga co ya mfɛi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pe nuꞌa̱ ra ꞌbɛgo hindi pa̱di xá hño tengu rá ꞌbɛfi rá hmu, ne hinda mɛfi xá hño, dra castiga pe hinga ndunthi ngu núꞌa̱ maꞌna. Ngueꞌa̱ nuꞌa̱ tóꞌo da tꞌɛntꞌua rá ꞌyɛ ndunthi ra ꞌbɛfi, go gueꞌa̱ maꞌna ma da tha̱ꞌmba nguɛnda. Ne nuꞌa̱ tóꞌo da tꞌumbabi ndunthi pa da su, gueꞌa̱ nehe ma da tꞌambabi ndunthi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nugui ngueꞌa̱ stuá ehe nuua ja ra ximhai, ma da nja ya ntꞌʉtsate ne ya hegue po rá nguecagui, ne dí ne da njabʉ ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ne nugui pɛꞌtsi ga thogui ndunthi ya ʉgui ne ya tsꞌothogui, ne dí ne da njabʉ ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Guí hu ri mʉihʉ gue ngueꞌa̱ stuá ehe hinda ma da nja ra tuhni ja ra ximhai. Hina, ngueꞌa̱ por guequi ma da nja ya hegue ne ya tuhni. ");
INSERT INTO oteNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Desde núbya pa dí ꞌñepʉ, ꞌbʉ ꞌnara ꞌmʉi di ꞌbʉi cʉtꞌa dya mengu, nuꞌʉ́ ma da ntunsɛ ne da hyegue po rá nguequi; ꞌbʉ di ꞌbʉi hñu núꞌʉ hingui camfrigui, da ʉtsa núꞌʉ má yoho camfrigui, ha nuꞌbʉ di ꞌbʉ yoho núꞌʉ hingui camfrigui, da ʉtsa núꞌʉ má hñu. ");
INSERT INTO oteNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ya dada da ʉtsa yá tꞌʉ, ha nuya tꞌʉ da ʉtsa yá dada. Ya na̱na̱ da ʉtsa yá tꞌixu, ha nuya tꞌixu da ʉtsa yá na̱na̱. Nuya suegra da ʉtsa yá tsꞌihuɛ, ha nuya tsꞌihuɛ da ʉtsa yá suegra. ");
INSERT INTO oteNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nehe ra Jesu bi ꞌñembabi ya ja̱ꞌi: ―Ora gui hyanthʉ da njʉxa ya guui lado yʉhyadi, ꞌbestho guí eñhʉ gue ma da ꞌua̱i, y majua̱ni da ꞌua̱i. ");
INSERT INTO oteNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ora da mʉdi ya panthi, guí eñhʉ gue ya ma da zø ra pahyadi, y majua̱ni ya ma da njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡ꞌNagyá yohmihʉ! ꞌBestho guí huxhʉ nguɛnda núꞌa̱ ma da nja ngueꞌa̱ guí hanthʉ núꞌa̱ ri hnequi ja ra ximhai ne mahetsꞌi, pe ¿hanja hingo guí huxhʉ nguɛnda de núꞌʉ ya ntꞌudi ri hnequibya pa gui pa̱hma̱hʉ toꞌogui? ");
INSERT INTO oteNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Hanja hinguí beñhʉ de sɛhɛꞌihʉ ndaꞌa̱ xá hño gui ꞌyøthʉ y ndaꞌa̱ hina? ");
INSERT INTO oteNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nuꞌbʉ ꞌna toꞌo da zixꞌaꞌi pa ja ra tsꞌʉtbi, nu xcrí ꞌyohʉ ja ra ꞌñu, ꞌramanu gui cohui ꞌnara cohi de grí yosɛhʉ, pa njabʉ ya hinda zixꞌaꞌi ja ra nzaya, ngueꞌa̱ nuꞌbʉ gui tsøñhʉ ja ra nzaya, nuꞌá̱ da ꞌbɛpa ra polecia da zixꞌaꞌi, ha núꞌa̱ ra polecia ma da goꞌa fadi. ");
INSERT INTO oteNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y de guehni hingui pøni asta hingui jutꞌi gatho núꞌa̱ gri tu. ");
INSERT INTO oteNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","De nuya paꞌʉ bi zønga ꞌraya ja̱ꞌi habʉ mi ꞌbʉ ra Jesu pa bi xipabi gue ra Pilato xqui hyo ꞌraya me Galilea. Núꞌʉ ya me Galilea xqui zønga Jerusale pa da hyo ꞌraya mboꞌni dega hña̱ꞌti pa Ajua̱, nepʉ nura Pilato bi manda da thoꞌʉ, y nuyá jiꞌʉ bi ntha̱ntsꞌui yá ji ya mboꞌni. ");
INSERT INTO oteNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Y nura Jesu bi ꞌñembabi: ―¿Ha guí hu ri mʉihʉ bi tꞌøꞌtuabi njabʉ núꞌʉ ya ja̱ꞌi ngueꞌa̱ maꞌna myá ꞌyøtꞌatsꞌoqui que maꞌra ya me Galilea? ");
INSERT INTO oteNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hina. Pe nuꞌbʉ núꞌahʉ nehe hingui ñobri de ri tsꞌoquihʉ, neꞌahʉ ma gui ꞌmɛdihʉ nehe ngu bi ꞌmɛdiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Xi núꞌʉ ꞌrɛtꞌamahña̱to ya ja̱ꞌi bi zɛꞌma ra torre de Siloé, ¿ha guí hu ri mʉihʉ gue maꞌna myá ꞌyøtꞌatsꞌoquiꞌʉ que gatho maꞌra ya me Jerusale? ");
INSERT INTO oteNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hina, pe nuꞌbʉ hingui ñobrihʉ de ri tsꞌoquihʉ, gatho ma gui ꞌmɛdihʉ nehe ngu bi ꞌmɛdiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Y ra Jesu bi xipa ꞌnara ꞌbede ya ja̱ꞌi ne bi ꞌñembabi: ―ꞌNara ꞌñøhø mi pɛꞌtsa ꞌna ꞌbai ra igo ja rá ua̱ꞌobxi, y ꞌnara pa bi ma bá cꞌa̱ꞌtsi ua di tøgue yá fruta, pe hinte bi zʉdi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nepʉ núꞌa̱ ra me ua̱ꞌobxi bi ꞌñembabi núꞌa̱ rá mɛfi mi mpɛ ja ra ua̱ꞌobxi: “Dí ne gui tsɛca nuna ra ꞌbai gá igo, ngueꞌa̱ ya hñu njɛya stá ehe dí handi ua di tøgue yá fruta, pe hinte stá tsʉdi. Hangue ¿pa te hønsɛ xa hña̱nga ndunthi ra hai habʉ ꞌbai, ne hinte ri uni?” ");
INSERT INTO oteNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nepʉ bi ꞌñenga núꞌa̱ ra mɛfi dega ua̱ꞌobxi: “Pøde hina, hinga tsɛcjʉ, ma ga fønba ra hai ne ga ʉꞌti. ");
INSERT INTO oteNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xa̱ma̱ njabʉ da unga yá fruta, pe nuꞌbʉ hinda uni, nuꞌbʉ́ ha̱, ga tsɛcjʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nepʉ ꞌnara pa dega tsaya ra Jesu mi ꞌbʉ ja ꞌnara nija̱ mi xahna ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ne mi ꞌbʉhni ꞌnara zi ꞌbɛhña̱ mi hñeni, ya mi pɛꞌtsa ꞌrɛtꞌamahña̱to njɛya mi njabʉ. ꞌNara tsꞌonda̱hi xqui japi da ncꞌostha, nixi himi tsa da jua̱nga rá ndoꞌyo ni ꞌna tʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nu mi hyandi ra Jesu bi zofo ne bi ꞌñembabi: ―Na̱ná̱, nubyá ya xcá ña̱ni de ri hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nepʉ nuꞌá̱ bi hñuxa yá ꞌyɛ ja ra zi ꞌbɛhña̱, y núꞌa̱ ra oraꞌa̱ ꞌbestho bi za bi jua̱nga rá ndoꞌyo xá hño, ne bi mʉdi bi xøcambeni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pe nura nda̱ de ra nija̱ bi bø rá cuɛ ngueꞌa̱ ra Jesu bi ꞌyøthe núꞌa̱ ra zi ꞌbɛhña̱ ha mrá pa dega tsaya ra paꞌa̱, ne bi ꞌñembabi ya ja̱ꞌi: ―Dí pɛꞌtshʉ ꞌrato ma pa pa ga mpɛfihʉ. Y núꞌʉ ya paꞌʉ ꞌbʉ tsʉꞌahʉ ya hñeni, ua ehʉ pa da tꞌøtheꞌihʉ. Oxqui ma go gui ehʉ núꞌʉ ya pa dega tsaya pa da tꞌøtheꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nepʉ ra Jesu bi da̱di ne bi ꞌñembabi: ―ꞌNagyá yohmihʉ, ¿ha gue hinguí xoꞌthʉ ri nda̱mfrihʉ o ri burruhʉ pa gui tsixhʉ da ntsithe masque ra pa dega tsaya? ");
INSERT INTO oteNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ha nuna zi ꞌbɛhña̱ xqui ꞌñehe desde yá ja̱ꞌi ndu ra Abrá, ha ra Satá xa japi xa hñeni ya øtꞌa ꞌrɛtꞌamahña̱to njɛya, ¿ha gue hiní ꞌñepabini da tꞌɛmbabi núꞌa̱ pɛꞌtsni masque ra pa dega tsaya? ");
INSERT INTO oteNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Y nu mi ma̱nga njabʉ ra Jesu, gatho nuyá ncontra mi ꞌbʉhni bi mɛꞌtsa yá tsa de núꞌa̱ bi ma̱ñꞌa̱. Pe nu maꞌra ya ja̱ꞌi mri xøcambeni Ajua̱ nu mi hyanda ya da̱nga tꞌøtꞌe mi øtꞌa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nehe bi ꞌñena ra Jesu: ―Ma ga xiꞌahʉ ꞌnara ꞌbede ri nhyɛcuaui rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nuꞌá̱ nja ngu ꞌnara zi nda dega mostasa núꞌa̱ da motꞌa ꞌnara ꞌñøhø ja rá hua̱hi. Y nuꞌá̱ da nte xi dra da̱ngui ngu ꞌnara ꞌbai gá za, y asta ja da hyocni yá ꞌbafi ya tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nehe bi ꞌñena ra Jesu: ―Ma ga xiꞌahʉ maꞌna ra ꞌbede ri nhyɛcuaui rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nurá hmanda Ajua̱ ri nhyɛhui ra nzoi núꞌa̱ bi mantꞌa ꞌnara ꞌbɛhña̱ co ngu ꞌnate kilo ra arina pa da hyoca ya thuhme. Bi mantꞌi xá hño asta xi bi ntsini gatho ja ra arina, masque mi ꞌna zi tʉi ra nzoi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ha nura Jesu bi sigui rá ꞌñu pa rí ma Jerusale. Bi thogui ja ꞌraya da̱nga hnini ne ya tꞌʉca hnini pa mi xahna ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y ꞌnara ja̱ꞌi bi ꞌyambabi ne bi ꞌñembi: ―Ndada, ¿ha gue ꞌna tʉi ya ja̱ꞌi núꞌʉ ma da mpøhø? Ha nuꞌá̱ bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―ꞌYøtꞌa ra tsꞌɛdi gui cʉtꞌa ja ra tsꞌiꞌma gosthi núꞌa̱ rí ma pa ja ra te pa nza̱ntho. Nugui dí xiꞌaꞌi, gue ndunthi di nehma̱ da yʉtꞌini, pe ya hinda za. ");
INSERT INTO oteNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nja ngu de stí gotꞌa ra gosthi núꞌa̱ toꞌo rá mɛti ꞌnara ngu, njabʉ nuꞌahʉ ꞌmɛfa ja gri ganthma̱hʉ ne gri eñhʉ: “Ma zi Hmuꞌihe, xogahe ra gosthi.” Pe nuꞌá̱ ma da da̱di ne ma da ꞌñeñꞌahʉ: “Hindí pa̱ꞌaꞌihʉ, nixi dí pa̱di habʉ gyá menguhʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nepʉ nuꞌahʉ ma gui ꞌñembabihʉ: “¿Hanja hinguí pa̱cje? gue ndrí ñuñhʉ ne ndrí ntsithehʉ, ne ja ma hninihe go gueꞌi gá ꞌñutcahe ri noya.” ");
INSERT INTO oteNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pe nuꞌá̱ ma da ꞌñeñꞌahʉ: “Dí xiꞌahʉ gue hindí pa̱ꞌaꞌihʉ, nixi dí pa̱di habʉ xqui ꞌñehʉ. Rí maha de guecua, gatho núꞌahʉ gyá ꞌyøtꞌatsꞌoquihʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y ra oraꞌa̱ ja guehni ma gui nzonihʉ ne ma xi da du ri mʉihʉ ndunthi nu xcrí hyanthʉ ndu ri mʉdi xitahʉ ra Abrá, ne ra Isaac, ne ra Cobo, ne gatho yá ꞌmɛhni Ajua̱ di ꞌbʉhni habʉ bí manda Ajua̱, y nuꞌahʉ hinda ma da thoꞌahʉ gui cʉthʉ, ma gui cohihʉ thi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ne ma dua ehe ya ja̱ꞌi de habʉraza maxøgue de ra ximhai, desde bøxhyadi asta yʉhyadi, ne desde mahuifi asta macꞌangui, y ma da yʉtꞌiꞌʉ nuni habʉ bí manda Ajua̱ ne ma dí hñudiniꞌʉ ja ra mexa pa da ñuni. ");
INSERT INTO oteNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y nura paꞌa̱ nuꞌʉ tóꞌo ya da̱nguibya, ma da notsiꞌʉ, ha nuꞌʉ tóꞌo ya notsibya, ma da nda̱nguiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Y ja núꞌa̱ ra paꞌa̱ bi zø ꞌraya fariseo há mi ꞌbʉ ra Jesu ne bi ꞌñembabiꞌa̱: ―Rí ma de guecua, ngueꞌa̱ nura nda̱ Erode ɛcꞌaꞌi da hyoꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Y nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Rí maha bá xiphʉ núꞌa̱ ra cꞌuamba ja̱ꞌiꞌa̱ gue nugui nubya ne rixudi ma ga sigui ga ɛnga ya tsꞌonda̱hi ne ga øthe ya daꞌthi asta hinga juata ma ꞌbɛfi. ");
INSERT INTO oteNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ne nu xcrá juata ma ꞌbɛfi de guecua ga jʉ ma ꞌñu ga ma pa Jerusale, ngueꞌa̱ ja guehni nza̱ntho xa thopa yá ꞌmɛhni Ajua̱, hangue ja grá mani nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Núꞌahʉ gyá menguhʉ Jerusale, go gueꞌahʉ guí cꞌanhʉ co ya do gatho nuya ꞌmɛhni xuá pɛhnꞌahʉ Ajua̱ y asta guí hohʉ! ¡Hangu ya ꞌmiꞌqui dá ne ga muntsꞌahma̱ gatho ri ba̱tsihʉ, dá nja ngu ꞌnara zi øni muntsꞌa yá ba̱tsi pa da huitsꞌi ja yá hua, pe nuꞌahʉ hinhyaꞌmʉ gá ne gá ꞌyødehʉ! ");
INSERT INTO oteNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pe desde nubya Ajua̱ ma da hyɛcꞌasɛhʉ ri nija̱hʉ. Ne dí xiꞌahʉ gue ya hingui yopi gui hyandgaguihʉ asta hinda zø núꞌa̱ ra pa gui ꞌñeñhʉ: “Xi nja̱pi nuni toꞌo xuá mɛhna Ajua̱ ma Hmuhʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ꞌNara pa dega tsaya bi ma ra Jesu da ñunga ja rá ngu ꞌnara nda̱ gá fariseo, ha nu maꞌra ya fariseo mi sutho de núꞌa̱ mi øtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne ja guehni mi ꞌbʉhni ꞌnara ꞌñøhø xi mi neniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nepʉ nura Jesu bi ꞌyambabi ya fariseo ne ya xahnate de ra ley ne bi ꞌñembabi: ―¿Te ma̱nga ja ra ley, ha gue da za da tꞌøthe ꞌnara daꞌthi ja ra pa dega tsaya, o hina? ");
INSERT INTO oteNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pe nuꞌʉ́ ni ꞌnara noya himbi da̱di, bi hmetho. Nuꞌbʉ́ ra Jesu bi hñuxa rá ꞌyɛ ja núꞌa̱ ra ꞌñøhø mi neni, ne bi ꞌyøthe ne bi mɛhni da ma. ");
INSERT INTO oteNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nepʉ bi ꞌñembabi ya fariseo: ―¿Toꞌo ꞌna de gueꞌahʉ ꞌbʉ da zo ꞌnari burruhʉ o ꞌnari nda̱mfrihʉ ja ꞌnara poso, nepʉ hingui hña̱ihʉ ngueꞌa̱ ra pa dega tsaya? ");
INSERT INTO oteNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y nuꞌʉ́ himbi za te bi da̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ha ra Jesu bi hyandi mi tsøhø núꞌʉ xqui tsꞌohni ja ra hñuni ne mi huahniꞌʉ ya mʉdi hudi pa da hñudi ja ra mexa, nuꞌbʉ́ nuꞌá̱ bi umbabiꞌʉ ꞌnara tsꞌofo ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nuꞌbʉ dra tsꞌohnꞌaꞌi ja ꞌnara ngo dega ntha̱ti, oguí hudi ꞌbestho ja ya mʉdi hudi, xiꞌbʉ da zøhø maꞌna núꞌa̱ xa tsꞌohni ne maꞌna dri tsꞌapa mfeni que gueꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nepʉ núꞌa̱ toꞌo xa zohnꞌaꞌi da ꞌñeñꞌaꞌi: “Tsocuabʉ ra hudi nuni maꞌna.” Y núꞌa̱ ra oraꞌa̱ ꞌnara ꞌbɛtsa pa gueꞌi, y gui ꞌbai ua hudi asta ja ra ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nuꞌa̱ mahyoni gui ꞌyøtꞌe nuꞌbʉ dra tsꞌohnꞌaꞌi ja ꞌnara hñuni, hñudi asta ja ra ña̱ni, pa nu sta hyantꞌaꞌi núꞌa̱ toꞌo xa zohnꞌaꞌi da ꞌñeñꞌaꞌi: “¿Hanja asta ja guí hucua? Thogui rí ma nuni asta ja ya mʉdi hudi.” Y njabʉ ha̱, da hyanda núꞌʉ maꞌra di huhni ja ra mexa gue xi tsꞌapꞌa mfeni neheꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nugui dí xiꞌahʉ, nuꞌa̱ tóꞌo ri ꞌñexasɛ de rá mfeni ma da ꞌbɛ rá tsa, pe nuꞌa̱ tóꞌo hini ꞌñexasɛ, da tꞌeꞌtsua rá nsu. ");
INSERT INTO oteNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y bi ꞌñembabi ra Jesu núꞌa̱ toꞌo xqui zohni: ―Nuꞌbʉ gui beni gui unga ꞌnara hñuni o ꞌnara ntꞌoxi nuua ja ri ngu, oxqui zohni hønsɛ ri amigo, nixi ri cu, nixi hønsɛ núꞌʉ te ri njaui, nixi núꞌʉ ri ꞌnangu ja te pɛꞌtsi, ngueꞌa̱ nuꞌʉ́ ꞌnara pa da zohnꞌaꞌi nehe, y njabʉ da coꞌtsꞌaꞌi ngu núꞌa̱ xcá ꞌyøꞌtuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nuꞌa̱ gui ꞌyøtꞌe, ora guí øtꞌango, zohna ya zi hyoya, ne núꞌʉ ya zi daꞌthi xa nza yá ndoꞌyo hingui tsa da ꞌña̱ni, ne ya zi doua, ne ya zi goda. ");
INSERT INTO oteNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Núꞌʉ ya zi ja̱ꞌiꞌʉ hinda ma da coꞌtsꞌaꞌi de núꞌa̱ gui ꞌyøꞌtuabiꞌʉ, pe ꞌmɛfa de rá ñoho ra ꞌmʉi nu xcrí yopa nte con gatho núꞌʉ maꞌra toꞌo xa ꞌyøtꞌe xá hño, ma gui hña̱nga ri tha̱ha̱ co ndunthi ra johya. ");
INSERT INTO oteNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y nu mi ꞌyøde njabʉ núꞌʉ ya ja̱ꞌi mi huhni ja ra mexa, ꞌna de gueꞌʉ bi ꞌñembabi ra Jesu: ―Tengu da johya núꞌa̱ toꞌo ma da hñudi da ñuni de guehni habʉ bí manda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nepʉ nura Jesu bi ꞌñembabi: ―ꞌNara pa ꞌnara ꞌñøhø bi ꞌñøtꞌango ne bi mɛhna yá ꞌbɛgo pa da zohna ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nepʉ nu mi zø ra ora pa ra ntꞌoxi, bi mɛnpa ra noya co ꞌnara ꞌbɛgo pa bá embabi gatho núꞌʉ xqui mbitabi: “Ya maha ꞌna̱, ya bí jabʉ ra mexa xa nthoqui pa gueꞌahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pe gatho núꞌʉ xqui mbitabi bi mʉdi bi ꞌya ra pumbate ngueꞌa̱ bi ꞌñotho yá luga. Nuꞌa̱ rá mʉdi bi sipi bi ꞌñena: “Gui pungui, pøde hinda za ga ma. Ja núbya dá juadi dá tanga ꞌnara hai, y mahyoni ga ma ga cꞌa̱ꞌtsi.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ha nu maꞌna bi ꞌñena: “Stá tanga cʉtꞌa ntꞌɛi ya nda̱mfri, y dí adi gui pungui, hinda za ga ma, ngueꞌa̱ mahyoni ma ga nu ua da mpɛfi xá hño.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ha nu maꞌna bi ꞌñena: “Ja núbya dá juadi dá ntha̱ti, otho ma luga ga ma.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ha nu mi menga núꞌa̱ ra ꞌbɛgo ja rá hmu, bi xipabi te gá da̱di cada ꞌna núꞌʉ xqui mbitabi. Nuꞌbʉ́ nura hmu xi bi bø rá cuɛ ne bi ꞌñembabi rá ꞌbɛgo: “Rí ma ja ra tai ne ja ya ꞌñu de ra hnini ua tsincaua gatho núꞌʉ gui tsʉpʉ, gatho ya zi hyoya ne núꞌʉ xa nza yá ndoꞌyo ne hingui tsa da ꞌña̱ni, ne ya doua, ne ya goda, pa ga ñuꞌmeꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ne ya ꞌmɛfa nura ꞌbɛgo bi ꞌñembabi rá hmu: “Ya stá øtꞌa núꞌa̱ gá xicagui, pe ponguitho ya hudi de ja ra mexa.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nepʉ nura hmu bi ꞌñembabi rá ꞌbɛgo: “Nubyá rí ma ja ya da̱ꞌñu ne ya tꞌʉca ꞌñu núꞌʉ ꞌranga ja ya mbonthi, y gui ja güi tsi gatho núꞌʉ gui tsʉdi pa da ñuxa nuya hudi ponguitho ja ma mexa. ");
INSERT INTO oteNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngueꞌa̱ nugui dí ma̱ gue núꞌʉ dá mbitabi ra mʉdi, ni ꞌna de gueꞌʉ hinda ñuni con guequi.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndunthi ya ja̱ꞌi mri dɛna ra Jesu, y nuꞌá̱ bi mpʉntsꞌi ne bi ꞌñembabiꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Nuꞌa̱ tóꞌo ne dua nxadi, mahyoni maꞌna da ma̱digui que rá dada, ne rá na̱na̱, ne rá ꞌbɛhña̱, ne yá ba̱tsi, ne yá cu, ne rá tesɛ; pe nuꞌbʉ hina, hinda za. ");
INSERT INTO oteNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ha nuꞌa̱ tóꞌo hinda ꞌñɛi da dɛngagui masque da ꞌbɛdi gatho, hinda za ga øtꞌe ma nxadiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Xiꞌbʉ ꞌnara ja̱ꞌi da beni da hyoca ꞌnara da̱nga ngu, ¿ha gue hinda beni ꞌmɛtꞌo te gatho mahyoni pa da uadi da hyoqui? ");
INSERT INTO oteNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pe nuꞌbʉ hinda beni ꞌmɛtꞌo, ne ꞌbʉ hønsɛ bi fʉtua rá ua rá ngu, nepʉ ya hinda juati, y gatho núꞌʉ toꞌo da hyandi ma da nthede de gueꞌa̱, ");
INSERT INTO oteNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ne da ꞌñena: “Nuna ꞌñøhøni hønsɛ bi mʉta rá ꞌbɛfi, ya himbi za bi juati.” ");
INSERT INTO oteNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O xiꞌbʉ ꞌnara nda̱ beni da ꞌñøtꞌatuhni co maꞌna rá minda̱ui núꞌa̱ pɛꞌtsa ꞌnate ꞌmo ya soldado, ¿ha gue hinda beni ꞌmɛtꞌo ua da za da nta̱te co núꞌʉ ꞌrɛtꞌa ꞌmo yá soldado? ");
INSERT INTO oteNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y nuꞌbʉ da beni ꞌmɛtꞌo gue hinda nta̱te, da mɛnpa ra noya maꞌna rá minda̱ui núꞌa̱ bra ꞌñe yabʉtho, gue ya hinda ntunhui. ");
INSERT INTO oteNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hangue nugui dí xiꞌahʉ, toraza de gueꞌahʉ nuꞌbʉ hingui tsogui gatho núꞌa̱ guí pɛꞌtshʉ, hinda za dua nxadiꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nura u xá hño, pe nuꞌbʉ ya bi ꞌbɛ rá hño, ¿hanja da za da yopa cʉqui? ");
INSERT INTO oteNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ya hingui ho nixi pa dra tha̱ntsꞌa ja ra hai de ya hua̱hi, nixi pa da tꞌʉꞌtua ja yá ua ya nda̱po, nixi pa ni ꞌnara tꞌøtꞌe ya hinxá hño, hangue dra føtbʉ. Nuꞌa̱ tóꞌo ja rá tꞌøde pa da ꞌyøde, dá ꞌyøde núna dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ndunthi ya ꞌña̱tsa ngʉxboja̱ ne ndunthi maꞌra ya tsꞌoja̱ꞌi bi ma bá tsʉdi ra Jesu pa da ꞌyøde núꞌa̱ mi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hangue nuya fariseo ne ya xahnate de ra ley mi ña̱maꞌñʉ de gueꞌa̱, ne mi ena: ―Nuni ra ꞌñøhø nza̱ntho ña̱ui ya tsꞌoja̱ꞌi ne ri ñuni con gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nepʉ ra Jesu bi xipa ꞌnara ꞌbede, ne bi ꞌñembabiꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Xiꞌbʉ ꞌna de gueꞌahʉ ꞌbʉ gri pɛꞌtshʉ ꞌna nthebe ya dɛti pe ꞌbʉ gui ꞌbɛhʉ ꞌna de gueꞌʉ, ¿ha gue hingue gui tsohʉni núꞌʉ gohoꞌrate ne ꞌrɛtꞌamagʉto pa gui maha ja ra mbonthi pa gua hoñhʉ núꞌa̱ xcá ꞌbɛdihʉ asta hingui tsʉhʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y nu xqui tsʉdihʉꞌa̱ gui ꞌyɛntsꞌa ja ri xiꞌnxihʉ co ra johya ne gui tuxhʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nepʉ gui zoñhʉ gatho ri amigohʉ ne ri ꞌnanguhʉ ne gui ꞌñembabihʉ: “Ma ga johyahʉ, ngueꞌa̱ ya stá tsʉdi núꞌa̱ ma dɛti stí ꞌbɛhma̱ha̱.” ");
INSERT INTO oteNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hangue dí xiꞌahʉ, njabʉtho nehe ꞌbʉ ꞌnara ꞌyøtꞌatsꞌoqui da ñobri, da nja ra johya mahetsꞌi, que núꞌʉ gohoꞌrate ne ꞌrɛtꞌamagʉto ya ja̱ꞌi beni gue ꞌbʉi xá hño ne hu yá mʉi gue hinga mahyoni da ñobri. ");
INSERT INTO oteNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O ne ꞌnara ꞌbɛhña̱ pɛꞌtsa ꞌrɛtꞌa ya boja̱ ne da ꞌbɛdi ꞌna, da tsø ra ñotꞌi ne da mpaxi ꞌramatsꞌʉ pa da hyoni asta hinda zʉdi. ");
INSERT INTO oteNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ha nu sta zʉdiꞌa̱, da zohna gatho yá mpa̱di ne yá ꞌnangu ne da ꞌñembabi: “Ma ga johyahʉ, ngueꞌa̱ ya stá tsʉdi núꞌa̱ ra boja̱ stí ꞌbɛhma̱ha̱.” ");
INSERT INTO oteNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hangue nugui dí xiꞌahʉ, njabʉtho nehe ꞌbʉ ꞌnara ꞌyøtꞌatsꞌoqui da ñobri, nuꞌbʉ́ yá ɛnxɛ Ajua̱ bí øtꞌango nuni mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ra Jesu bi ꞌñena nehe: ―ꞌNara ꞌñøhø mi pɛꞌtsa yoho yá tꞌʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","nepʉ núꞌa̱ mba̱tsi bi ꞌñembabi rá dada: “Papá, dí ne gui ꞌracagui núꞌa̱ rí ꞌñepcagui de núꞌa̱ guí pɛꞌtsi.” Nuꞌbʉ́ nura dada bi mʉdi bi hecuabi yá hño, ne bi umbabi yá tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nepʉ de ya xqui thogui ꞌraya pa, núꞌa̱ ra tꞌʉ mba̱tsi bi muntsꞌa gatho núꞌa̱ xqui tꞌumbabi ne bi hña̱tsꞌi, ne bi bøni de guehni, bi gʉ rá ꞌñu bi ma pa maꞌna ra hai yabʉ habʉ bá tegue gatho rá boja̱ ja ꞌnara ꞌmʉi xi xmá ntsꞌo. ");
INSERT INTO oteNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pe nu mi degue gatho núꞌa̱ mi ha̱, bi nja ꞌnara da̱nga thuhu ja núꞌa̱ ra haiꞌa̱, ne nuꞌá̱ bi mʉdi bi sufri co ra thuhu. ");
INSERT INTO oteNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nepʉ de guehni bi ma bá apa ra ꞌbɛfi ꞌnara ꞌñøhø de núꞌa̱ ra haiꞌa̱. Y nura ꞌñøhøꞌa̱ bi umbabi ra ꞌbɛfi ne bi mɛhni da supa yá tsꞌʉdi. ");
INSERT INTO oteNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Y ra ora mi ñunga ya tsꞌʉdi, núꞌá̱ mi nehma̱ da zi núꞌa̱ mi tsiꞌʉ, ngueꞌa̱ xi mi tsʉ ra thuhu, pe hinto mi huequi pa da tꞌumbi te da zi. ");
INSERT INTO oteNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nuꞌbʉ́ nuꞌá̱ bi beni rá ngu ne bi ꞌñena: “Hangu ya mɛfi pɛꞌtsa ma dada ja rá ngu, ne bí ja ndunthi te da tsꞌi, asta pongui. Y nugui, go dí ꞌyoua ya ga tu ra thuhu. ");
INSERT INTO oteNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma ga yopa penga ja rá ngu ma dada, ne ga embabi: Papá, stá øtꞌa ꞌnara tsꞌoqui ja rá thandi Ajua̱ ne ja ri thandigue. ");
INSERT INTO oteNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya hiní ꞌñepcagui gui ꞌñengagui ri tꞌʉgui. ꞌYøtcꞌagui ngu ꞌnadrá ꞌbɛgotho de gueꞌi; ga embabi njabʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nepʉ nuꞌá̱ bi gʉ rá ꞌñu ne bi menga pa ja rá ngu rá dada. Pe ante da zøni, rá dada bi hyandi ne bi huequi, ne bi nestꞌihi bá tsʉdi, y ngu bi nthɛui, bi hyʉfi ne bi zʉꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nepʉ nura tꞌʉ bi ꞌñembabi: “Papá, stá øtꞌa ꞌnara tsꞌoqui ja rá thandi Ajua̱ ne ja ri thandigue. Ya hiní ꞌñepcagui gui ꞌñengagui ri tꞌʉgui.” ");
INSERT INTO oteNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pe nura dada bi ꞌñembabi yá ꞌbɛgo: “Bá ha̱hʉ ꞌraya he núꞌʉ maꞌna strá hño ne hyethʉ, ne hñuꞌtsuahʉ ꞌnara mfoꞌyɛ, ne tiꞌtuahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne bá tsihʉ núꞌa̱ ra nocanda̱mfri ga hohʉ ne ga tsihʉ. ¡Ma ga øthʉ ꞌnara ngo dega johya! ");
INSERT INTO oteNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ngueꞌa̱ nuna ma tꞌʉ ndí hu ma mʉi gue ya xqui duhma̱, pe hina, y nubyá dí ja ra uɛnda gue ya xa yopa nte. Stí ꞌbɛdi, pe nubyá ya dá yopa handi.” Y nuꞌʉ́ bi mʉdi bi ꞌñøtꞌango. ");
INSERT INTO oteNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Hinga yaꞌa̱ bi zøhø núꞌa̱ ra tꞌʉ mada̱, mbi ꞌyo ja ra ꞌbɛfi. Pe nu mi zøhø guetbʉ ja rá ngu, bi ꞌyøde mi ja ya ꞌbɛꞌmda ne ya hnei. ");
INSERT INTO oteNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nepʉ nuꞌá̱ bi maꞌta ꞌna de nuya ꞌbɛgo pa bi ꞌyambabi te mi ja. ");
INSERT INTO oteNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nepʉ nura ꞌbɛgo bi ꞌñembabi: “Ri cu xa zøhø y nuri dada bi manda bi tho ra nocanda̱mfri ngueꞌa̱ bi zøhø te rá ꞌñentho ha hinte xqui ja.” ");
INSERT INTO oteNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pe núꞌa̱ ra cu mada̱ xi bi bø rá cuɛ ne himi ne da yʉtꞌi. Ha nurá dada bi bøni bi ba̱ntebi pa da yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ha nuꞌá̱ bi ꞌñembabi rá dada: “Papá, guí pa̱sɛ hangu ya jɛya stá ꞌbʉhui ne dí pɛpꞌaꞌi, ha hinhyaꞌmʉ stá ntsꞌoꞌyøde de gueꞌi. Pe ni ꞌnaꞌqui hinxcá ꞌraca ma̱di ꞌnara zi tꞌa̱xi pa ga tsiꞌbe ma amigo. ");
INSERT INTO oteNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pe nubyá, núꞌa̱ ri tꞌʉ xa zøhø, xua decꞌaꞌi ri boja̱ co ya tsꞌoꞌbɛhña̱, nuꞌá̱ ha̱, go asta gá hyopabi ra nocanda̱mfri.” ");
INSERT INTO oteNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nepʉ nurá dada bi ꞌñembabi: “Ma zi tꞌʉꞌi, nuꞌí nza̱ntho guí ꞌbʉi con guequi, y gatho núꞌa̱ dí pɛꞌtsi, ri mɛti nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pe nubyá, mahyoni ga johyahʉ ne ga øthʉ ꞌnara ngo, ngueꞌa̱ ri cu ndí hu ma mʉi gue ya xqui duhma̱, pe nubyá pa guequi dí ja ra uɛnda gue ya xa yopa nte. Y stí ꞌbɛhma̱hʉ, pe nubyá ya dá yopa hanthʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nehe ra Jesu bi ꞌñembabi yá nxadi: ―Mi ꞌbʉi ꞌnara ꞌñøhø xi mrá rico ne mi ꞌbʉi ꞌnará ꞌbɛtri. Y ra hmu xqui sipabi gue núꞌa̱ ra ꞌbɛtri mi jʉmpa ndunthi rá boja̱. ");
INSERT INTO oteNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nuꞌbʉ́ nura hmu bi zohna núꞌa̱ ra ꞌbɛtri ne bi ꞌñembabi: “Xa sicagui ꞌraya noya de gueꞌi. Hangue dí ne gui dacagui ra uɛnda de ri ꞌbɛfi, ngueꞌa̱ ya hindí ne gui sigui gui pɛpcagui.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nepʉ núꞌa̱ ra ꞌbɛtri bi bensɛ ja rá mfeni, ne mi ena: “Xibya, ¿te ga øtꞌe? Ma hmu ma da hña̱ga ra ꞌbɛfi, ha otho ma tsꞌɛdi pa ga pɛ ya hai, y ri ꞌraca ra ꞌbɛtsa ꞌbʉ ga mpɛti. ");
INSERT INTO oteNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, nubyá ha̱, ya dá beni te ma ga øtꞌe. Ma ga honga ra modo pa da ma̱cagui núꞌʉ toꞌo tupabi ma hmu, pa da ꞌraca nsɛqui ja yá ngu nura paꞌa̱ da tha̱gagui ra ꞌbɛfi de guecua.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nepʉ nuꞌá̱ bi zohna ꞌramaꞌna núꞌʉ toꞌo mi tupabi rá hmu. Nuꞌa̱ ra mʉdi bi ꞌyambabi ne bi ꞌñembabi: “¿Hangu guí tupabi ma hmu?” ");
INSERT INTO oteNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nuꞌbʉ́ nuꞌá̱ bi da̱tuabi bi ꞌñena: “Dí tupabi ꞌna nthebe barri ra aceite.” Ha nura ꞌbɛtri bi ꞌñembabi: “Jaua ra hɛꞌmi habʉ hutsꞌi hangu guí tupa ma hmu, y da̱ma hyoqui maꞌna habʉ di ma̱ gue hønsɛ nde nthebe barritho gui tu.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nepʉ nuꞌa̱ maꞌna bi ꞌñembabi: “Xiꞌaꞌi, ¿hangu guí tugue?” Nuꞌá̱ bi ꞌñena: “ꞌNa nthebe huada ra trigo.” Nepʉ núꞌa̱ ra ꞌbɛtri bi ꞌñembabi: “Nehe jaua ra hɛꞌmi habʉ hutsꞌi hangu guí tupa ma hmu. Hyoca maꞌna habʉ di ma̱ gue hønsɛ gohoꞌrate gui tu.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nepʉ nura hmu bi ꞌñeꞌtsua rá nsu núꞌa̱ ra tsꞌoꞌbɛtri ngueꞌa̱ bi da̱ma nti rá mfeni pa bi gohi xá hño co núꞌʉ toꞌo mi tu ya thai. Hangue njabʉ nuya meximhai xi ya nimfeni pa da gohi xá hño co yá mimeximhaiui, pe núꞌʉ xa gamfri Ajua̱ hingui øtꞌe njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pe nugui, nuꞌa̱ dí xiꞌahʉ, masque ra boja̱ da za da hyatꞌa ꞌna, pe nehe co núꞌa̱ ra boja̱ꞌa̱ ogyá mitꞌihʉ, faxhʉ núꞌʉ ja te øꞌtua ra ꞌbɛdi, pa njabʉ gui ntsixhʉꞌʉ, pa nu sta uadi ri tehʉ de guecua ja ra ximhai ne sta uadi da thogui ra boja̱, nuꞌbʉ́ ma da tꞌaꞌahʉ ꞌnara hoga ꞌñehe nu xcrí tsøñhʉ mahetsꞌi habʉ bí ja ya hoga ꞌmʉi pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nuꞌa̱ tóꞌo hingui cøni masque ꞌna tʉi ra boja̱ xa tꞌumbi da su, nehe hinda gøni ꞌbʉ da tꞌumba ndunthi ra boja̱ pa da su. Nuꞌa̱ tóꞌo cøni de núꞌa̱ ꞌna tʉi xa tꞌumbi pa da suhma̱, nehe da gøni ꞌbʉ da tꞌumba ndunthi pa da su. ");
INSERT INTO oteNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hangue nugui dí xiꞌahʉ, ꞌbʉ gui cøñhʉ ya hño de nuua ja ra ximhai núꞌʉ xa tꞌaꞌahʉ pa gui suhma̱hʉ, ¿toꞌo da gamfri de gueꞌahʉ pa da ꞌraꞌahʉ ya hño de mahetsꞌi pa gui suhma̱hʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nuꞌbʉ hingui pa̱hʉ gui suhʉ núꞌa̱ hingrí mɛtihʉ, ¿hanja da za da tꞌaꞌahʉ núꞌa̱ rí ꞌñepꞌaꞌihʉ pa gui suhʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni ꞌnara ꞌbɛgo hinda za da mɛpabi yoho ya hmu, ngueꞌa̱ njabʉ da za da ʉtsa ꞌna, ne go da ma̱hui núꞌa̱ maꞌna, o nza̱ntho go di pɛpabi ꞌna, y nu maꞌna hina. Njabʉ nehe hingui tsa gui pɛpabihʉ Ajua̱ ne da ꞌyoda ri mfenihʉ ra boja̱. ");
INSERT INTO oteNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ha nuya fariseo xi mi ho da mɛꞌtsa ndunthi ra boja̱ ne mi ꞌbʉhni mi huxa ntꞌødeꞌʉ núꞌa̱ bi ma̱nga ra Jesu ne xi mi ɛnda yá thedeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ha nura Jesu bi ꞌñembabiꞌʉ: ―Nuꞌahʉ ri hnequi ꞌñena ꞌna xi gyá hoja̱ꞌihʉ, pe hønsɛ pa gui pønga ri hmihʉ ja yá thandi ri miquꞌeihʉ, pe Ajua̱ pa̱tꞌathohʉ ri mfenihʉ te rá ꞌbɛꞌa̱ guí beñhʉ, hangue ꞌbʉ guí ne gui pønga ri hmihʉ ja yá thandi ri miquꞌeihʉ, hingui tsa gui pønga ri hmihʉ ja rá thandi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Desde ante da zøhø ra Xuua Xiꞌtsate ya nguí pɛꞌtsuahʉ rá ley ra Moise ne núꞌa̱ xqui ma̱nga maꞌra yá ꞌmɛhni Ajua̱. Y desde bi zøhø ra Xuua asta nubya xcá ꞌyøhʉ xa siꞌahʉ ya noya dega hoga ntꞌøde de hanja go ri manda Ajua̱, y njabʉ ndunthi xa ꞌyøtꞌa ra tsꞌɛdi da yʉtꞌi nu habʉ ri manda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Masque mahetsꞌi ne ra ximhai hingui hei pa da uadi, pe ni ꞌnara noya núꞌa̱ xa tꞌofo ja rá ley Ajua̱ hinda njabʉtho, pɛꞌtsi da njabʉ ngu núꞌa̱ ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ꞌBʉ ꞌnara ꞌñøhø da nxungüi rá ꞌbɛhña̱ pa go da ntha̱tui maꞌna ra ꞌbɛhña̱, núꞌa̱ ra ꞌñøhøꞌa̱ ya bi ꞌyøtꞌa ꞌnara tsꞌoqui. Y nuꞌa̱ tóꞌo da ntha̱ti co ꞌnara ꞌbɛhña̱ xa nxungüi rá da̱me, neꞌa̱ ya bi ꞌyøtꞌa ꞌnara tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mi ꞌbʉi ꞌnara ꞌñøhø xi mrá rico, ne xi mri hñe xá hño co ꞌraya hoga dutu xi mahotho. Y mi øtꞌango hyastho ja rá ngu co ndunthi ra nthoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne mi ꞌbʉi ꞌnara zi mɛti mrá thuhu ra Lasaro xi mrá hyoya, xqui hñuhni ja rá gosthingu núꞌa̱ ra rico. Ne mi tsʉ ꞌnara hñeni mi ꞌya maxøgue rá ndoꞌyo, ");
INSERT INTO oteNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ne asta ya tsatꞌyo mi teꞌtsuabi habʉ mi ꞌya. Y núꞌa̱ ra zi ꞌñøhøꞌa̱ mi nehma̱ xa zi núꞌa̱ mi tagui de ja rá mexa núꞌa̱ ra rico. ");
INSERT INTO oteNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ꞌNara pa bi du ra zi hyoya, y ya ɛnxɛ de mahetsꞌi bá ehe e bi zitsꞌi pa bá ꞌbʉhui ra Abrá nuni mahetsꞌi. Nepʉ ꞌmɛfa bi du nehe núꞌa̱ ra rico, ne bi tꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Y de mi oni núꞌa̱ ra rico ja ra nidu xi mri sufri ndunthi, nepʉ nuꞌá̱ bi gʉxa yá da ne bi hyandi de yabʉ ra Abrá ya mi ꞌbʉhuini ra Lasaro nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nepʉ nura rico bi maꞌti ne bi ꞌñembabi: “Ma dadaꞌi Abrá, dá nja ri nthecate de guequi, bá pɛhna ra Lasaro da pobo qué yá dedo co ꞌna zi tʉi ra dehe pa e da pobo qué ma ja̱ne, ngueꞌa̱ xi dí sufri ndunthi nuua ja ra tsibi.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ha nura Abrá bi ꞌñembabi: “Amigo, beni gue nuꞌi núꞌbʉ nguí ꞌbʉi ja ra ximhai xi nguí ꞌbʉi xá hño, ha nura Lasaro mi sufri ndunthi ra hñoya. Pe nubyá nuní ꞌbʉi xá hño de guecua, ha nuꞌi go guí sufribya núbʉ habʉ guí ꞌbʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ha nixi da za da mabʉ ra Lasaro, ngueꞌa̱ ja ꞌnara hñe madetho xi xá hñe. Hangue nuꞌʉ ꞌbʉcua hinda za dí mabʉ, ha nuꞌʉ bí ꞌbʉpʉ, hinda za dí ꞌñecua nehe.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nepʉ núꞌa̱ ra rico bi ꞌñena: “Ma dadaꞌi Abrá, nuꞌbʉ́ dí ba̱nteꞌi gui pɛhna tsꞌʉ ra Lasaro ja rá ngu ma dada ");
INSERT INTO oteNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","habʉ bí ꞌbʉi má cʉtꞌa ma cu, pa da zofo pa hinda zøhø de guecua ja ra nidu, e da sufri ngu dí sufriga.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pe nura Abrá bi ꞌñembabiꞌa̱: “Nuꞌʉ́ ya bí pɛꞌtsa núꞌa̱ bi ꞌyofo ra Moise ne núꞌa̱ bi ꞌyofo maꞌra yá ꞌmɛhni Ajua̱. ¡Go dá ꞌyøteꞌʉ!” ");
INSERT INTO oteNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pe nura rico bi ꞌñena: “Ha̱ha̱ majua̱ni guí ma̱, núꞌi ma dadaꞌi Abrá, pe nuꞌbʉ gui pɛhna ꞌna de núꞌʉ xa du, nuꞌʉ́ dí pa̱di da ꞌyøte ne da ñobri.” ");
INSERT INTO oteNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pe nura Abrá bi ꞌñembabi: “ꞌBʉ hingo xa ꞌyøte núꞌa̱ bi ma̱nga ra Moise ne maꞌra yá ꞌmɛhni Ajua̱, nixi da ne da gamfri núꞌa̱ da xipabi núꞌa̱ di yopa nte de ja ra du.” ");
INSERT INTO oteNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ra Jesu bi ꞌñembabi yá nxadi: ―Nza̱ntho da nja ꞌraya tꞌøtꞌe pa da japi da ntsꞌoca ya ja̱ꞌi, pe ¡huecate núꞌa̱ ra ja̱ꞌi toꞌo da japi da ꞌyøtꞌa ꞌnara tsꞌoqui maꞌna! ");
INSERT INTO oteNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maꞌna xá hño núꞌa̱ ra ja̱ꞌiꞌa̱ dra tsꞌʉtuahma̱ ꞌnara do strá hñʉ ja rá ꞌyʉga ne dra føta ja ra ndehe, pa te hønsɛ da japi da ꞌyøtꞌa ra tsꞌoqui maꞌna rá miquꞌeiui núꞌa̱ hinxa zɛditho rá jamfri. ");
INSERT INTO oteNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hangue nugui dí xiꞌahʉ gui nsuhʉ. Nuꞌbʉ ꞌnari cuhʉ da ꞌyøꞌtꞌahʉ ꞌnara ntsꞌoꞌmʉi, zofohʉ, hña̱cuahʉ. Nuꞌbʉ da ñobri, pumbabihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masque da ꞌyøꞌtꞌahʉ ra ntsꞌoꞌmʉi yoto ꞌmiꞌqui de ra pa, ne ꞌbʉ da ꞌñehe da ꞌyaꞌahʉ ra pumbate cada ra ꞌmiꞌqui, pumbabihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ha nuyá apostol ra Jesu bi ꞌñembabi: ―Xupca ma jamfrihe. ");
INSERT INTO oteNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nepʉ ra zi Hmu Jesu bi ꞌñembabi: ―Nuꞌbʉ xi majua̱ni gri pɛꞌtshʉ ra jamfri masque ngu ꞌnara zi nda dega mostasa rá nda̱ngui, nuꞌbʉ́ da za gui ꞌñembabihʉ nuna da̱nga ꞌbai gá za: “Cꞌʉtsꞌi de habʉ guí ꞌbai ne rí ma gui ntꞌʉtꞌa ja ra ndehe,” ha nura zaꞌa̱ da ꞌyøꞌtꞌaꞌihʉ co núꞌa̱ ri jamfrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ra Jesu bi ꞌñembabi neheꞌʉ: ―ꞌBʉ ꞌnara ja̱ꞌi di ꞌbʉ ꞌnará ꞌbɛgo xqui menga ꞌbɛfi ja ra hua̱hi o ra ꞌbaꞌyo, ¿ha gue da tꞌembabi ꞌbestho: “Thogui hñudi gui ñuni”? ");
INSERT INTO oteNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hina. Nuꞌá̱ da tꞌembabi: “ꞌMɛtꞌo gui hoca ra ntꞌoxi, ne hñoquigue pa gui ꞌraqui te ga tsi. Nepʉ ꞌmɛfa gui ñunigue nehe.” ");
INSERT INTO oteNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ha guí beñhʉ da tꞌumba njama̱di ra ꞌbɛgo de núꞌa̱ ꞌbɛpabi da ꞌyøtꞌe? Hina. ");
INSERT INTO oteNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Njabʉ nehe nu xcrí juahʉ gui pɛphʉ rá ꞌbɛfi Ajua̱ xa ꞌbɛpꞌahʉ, rí ꞌñepi gui ꞌñeñhʉ: “Hiní ꞌñepcahe gui ꞌyacje ra jama̱di ngueꞌa̱ ꞌnadyá ꞌbɛgothohe ne hønsɛ stá pɛhe núꞌa̱ mri ꞌñepcaguihe ga pɛhe.” ");
INSERT INTO oteNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","De guehni bi thogui ra Jesu bi sigui rá ꞌñu pa mri ma Jerusale, bi ꞌranga madetho de yoho ya hai, ꞌna rá thuhu Nsamaria, ha nu maꞌna Galilea. ");
INSERT INTO oteNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y ya de mi ma da zønga ja ꞌnara zi hnini, bi bøni pa bá tsʉdiꞌa̱ ꞌrɛtꞌa ya ꞌñøhø mi tsʉdi ra lepra núꞌa̱ mi tsitꞌatho ra ngø, ne nuꞌʉ́ bi gohi zi yabʉtho de gueꞌa̱, ngueꞌa̱ xuá ntsꞌuni yá hñeni. ");
INSERT INTO oteNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nepʉ bi maꞌtiꞌʉ bi ꞌñembi: ―Jesu, ma zi Xahnateꞌihe, dá nja ri nthecate de guecje. ");
INSERT INTO oteNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nepʉ nu mi hyanda ra Jesu bi ꞌñembabiꞌʉ: ―Rí maha ua ꞌñudihʉ ja ya macja̱. Nepʉ nuꞌʉ́ bi ma, ne de má ꞌñu bi ña̱ni de yá hñeniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y ꞌna de gueꞌʉ de mi za gue bi ña̱ni, bi mengui mi xøcambeni Ajua̱ co ya hmafi. ");
INSERT INTO oteNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ne bi ndandiña̱hmu ja rá ua ra Jesu ne bi mɛgui rá hmi asta ja ra hai pa bi umba njama̱di ngueꞌa̱ xqui ꞌyøtheꞌa̱. Y núꞌa̱ ra ꞌñøhøꞌa̱ mrá me Nsamaria. ");
INSERT INTO oteNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Y nura Jesu bi ꞌñani ne bi ꞌñena: ―¿Ha gue hingue mi ꞌrɛtꞌa bi ña̱ni? ¿Habʉ bi ma núꞌʉ má gʉto? ");
INSERT INTO oteNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ha gue hønsɛ núni hingrá me Israel bá pengui ri xøcambeni Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nepʉ ra Jesu bi ꞌñembabi núꞌa̱ ra ꞌñøhø: ―ꞌBai rí ma, ya xcá ña̱ni ngueꞌa̱ xcá camfrigui. ");
INSERT INTO oteNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nepʉ ya fariseo bi ꞌyambabi ra Jesu haꞌmʉ mi ma da zøhø rá hmanda Ajua̱ nuua ja ra ximhai. Nepʉ nuꞌá̱ bi da̱di ne bi ꞌñembabi: ―Nurá hmanda Ajua̱ hinga ꞌnara tꞌøtꞌe pa da hnequi. ");
INSERT INTO oteNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nixi da za da tꞌeñꞌahʉ: “Xi jaua”, o “Bí jani”. Nurá hmanda Ajua̱ ya xa zøhø ne ya ꞌbʉi con gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nepʉ nuꞌá̱ bi ꞌñembabi yá nxadi nehe: ―Ma da zøhø ra pa gui nehma̱hʉ gui hyanthʉ da zøhø ꞌbestho núꞌa̱ ra da̱nga pa, pa gui hyanthʉ da yopa ꞌñehe pa da nda̱ Núꞌa̱ Toꞌo e bi Nja̱ꞌi, pe hindi tatꞌatho ya pa pa gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ne ma da tꞌeñꞌahʉ: “Xi ꞌbʉcua”, o “Xi bí ꞌbʉhni”. Pe oxqui pahʉ ma gui cꞌa̱ꞌtshʉ, ne oxqui tɛnihʉ núꞌʉ toꞌo da xiꞌahʉ njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngueꞌa̱ ngu guí hanthʉ ꞌnara huɛi núꞌa̱ masɛctho da yotꞌi maxøgue mahetsꞌi, ma da njabʉ nehe núꞌa̱ ra paꞌa̱ stua yopa pengui Núꞌa̱ Toꞌo e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pe mahyoni ꞌmɛtꞌo da thogui ndunthi ya tsꞌothogui. Ne ma da ʉtsa gatho ya ja̱ꞌi núꞌʉ ꞌbʉi de nuya pabya. ");
INSERT INTO oteNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ngu núꞌa̱ bi nja de nuya paꞌʉ de mi ꞌbʉi ra Noé, ma da njabʉ nehe nu stua yopa ehe Núꞌa̱ Toꞌo e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nuꞌʉ́ mri ñuni, mi tsithe, ne mi øtꞌa ntha̱ti ngu xi yá nza̱i, ne hinte mi jamasuꞌʉ asta nura paꞌa̱ bi yʉtꞌa ra Noé ja ra arca, ne mi da̱mfriꞌʉ bi ñuxa ra dehe maxøgue ra ximhai, y gatho ya ja̱ꞌi bi ja̱tꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bi njabʉ nehe nuya paꞌʉ mi ꞌbʉ ra Lot. Ya ja̱ꞌi mi øtꞌe ngu xi myá nza̱i, mi ñuni mi tsithe, mi mpa ne mi ntai, mi mpotꞌi ne mi høngu. ");
INSERT INTO oteNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pe nu de mi bønga ra Lot de ra hnini Sodoma, bi ꞌua̱ ya tsibi ne ra asufre, y bi du dega nza̱tꞌi gatho ya ja̱ꞌi de núꞌa̱ ra hniniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ma da njabʉ nehe núꞌa̱ ra paꞌa̱ stua yopa pengui Núꞌa̱ Toꞌo e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","De nura paꞌa̱, ꞌbʉ ꞌna di ꞌba ja ra patio de rá ngu, hinda yʉtꞌa mbo rá ngu pa da hña̱tsꞌi núꞌa̱ te di pɛꞌtsi. Y nuꞌa̱ tóꞌo di ꞌyo ja rá hua̱hi, ya hinda yopa menga ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Benihʉ de hanja bi ndoꞌu rá ꞌbɛhña̱ ra Lot ngueꞌa̱ bi ñegui bi hyanda núꞌa̱ ra hnini bi zopʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nuꞌa̱ tóꞌo ne da su rá te, da ꞌbɛdi, pe nuꞌa̱ tóꞌo da unga rá te po rá nguequi, nuꞌá̱ ma da mɛꞌtsa maꞌna ra hoga te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nehe dí xiꞌahʉ gue núꞌa̱ ra xuuiꞌa̱ ꞌbʉ yoho di ꞌbonga ꞌnadbʉ ja yá a̱ha̱, ꞌna da tsꞌitsꞌi, ha nu maꞌna da tsꞌogui. ");
INSERT INTO oteNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ꞌBʉ yoho ya gʉni di cʉni mahyɛgui, ꞌna da tsꞌitsꞌi, ha nu maꞌna da tsꞌogui. ");
INSERT INTO oteNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ꞌBʉ yoho ya ꞌñøhø di ꞌyo ja yá ꞌbɛfi ꞌnadbʉ ja ra hua̱hi, ꞌna da tsꞌitsꞌi, ha nu maꞌna da tsꞌogui. ");
INSERT INTO oteNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nu mi ꞌyøde njabʉ ya apostol bi ꞌyambabi ra Jesu ne bi ꞌñembi: ―¿Habʉ ma dua nja núꞌa̱ gá ma̱, ma zi Hmuꞌihe? Nepʉ nuꞌá̱ bi da̱di ne bi ꞌñembabiꞌʉ: ―Nuni habʉ di ꞌbɛni núꞌa̱ xa du, ja ma da muntsꞌni ya pada pa da ziꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ra Jesu bi xipa ꞌnara ꞌbede yá nxadi gue mahyoni da ꞌyapabi Ajua̱ nza̱ntho nsinque da zabi. ");
INSERT INTO oteNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ne bi ꞌñembi: ―Mi ꞌbʉi ꞌnara nzaya ja ꞌnara hnini, himi tsu Ajua̱ ne ni ꞌnara ja̱ꞌi himi tsu. ");
INSERT INTO oteNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ne de núꞌa̱ ra hniniꞌa̱ mi ꞌbʉi ꞌnara viuda nehe, nza̱ntho mi pa da cꞌa̱ꞌtsa núꞌa̱ ra nzaya pa da ña̱ni de rá ncontraꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pe bi thogui ndunthi ya pa nura nzaya himbi umba ra mfatsꞌi núꞌa̱ ra viuda. Pe ꞌmɛfa bi ꞌño rá mfenisɛ núꞌa̱ ra nzaya ne bi ꞌñena: “Masque nugui hindí tsu Ajua̱, nixi ꞌnara ja̱ꞌi hindí tsu, ");
INSERT INTO oteNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pe hingo rá ngueꞌa̱ ma ga øta núꞌa̱ xica ra viuda, pa hingue xi stí tsøtcatho ma mʉi.” ");
INSERT INTO oteNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ra zi Hmu Jesu bi ꞌñena: ―Guehna bi ma̱nga núꞌa̱ ra tsꞌo nzaya. ");
INSERT INTO oteNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xihma̱ Ajua̱, ¿ha gue hinda ña̱ni núꞌʉ toꞌo xa huahni, núꞌʉ apabiꞌa̱ ma pa ra xuui? ¿Ha gue hinda matsꞌi ꞌbesthoꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dí xiꞌahʉ gue ha̱, ꞌbestho da matsꞌi. Xi sta yopa mengui Núꞌa̱ Toꞌo e bi Nja̱ꞌi, ¿ha gue da zʉdi ndunthi toꞌo di camfri ꞌbʉ? Ya hina. ");
INSERT INTO oteNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ra Jesu bi ma̱nga maꞌna ra ꞌbede pa núꞌʉ toꞌo ri ꞌñetsꞌi gue ya hoja̱ꞌi ne xi ya denate, ne bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Yoho ya ꞌñøhø bi ma ja ra nija̱ pa da ꞌyapabi Ajua̱, ꞌna mrá fariseo, ha nu maꞌna mrá ꞌña̱tsa ngʉxboja̱. ");
INSERT INTO oteNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ha nura fariseo bi ꞌyapabi Ajua̱ má ꞌbai ne mi ena njaua: “Dí jama̱di ma Zidadaꞌi, ngueꞌa̱ nugui hindí nja ngu ya ꞌyøtꞌatsꞌoqui, ya be, ya tsꞌoꞌmʉi ne ya zinga medintha̱ti, nixi dí nja ngu nuni ra ꞌña̱tsa ngʉxboja̱ ꞌbahni. ");
INSERT INTO oteNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nugui dí ayuna yoꞌqui ra semana, ne nza̱ntho dí ꞌraꞌa ꞌrɛtꞌa centavo cada ra bɛxo núꞌa̱ dí ta̱ha̱,” njabʉ bi ꞌñena. ");
INSERT INTO oteNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pe núꞌa̱ ra ꞌña̱tsa ngʉxboja̱ bi gohi tsꞌʉ zi yabʉ de ra fariseo, ne nixi bi ne bi gʉxa yá da pa mahetsꞌi ngueꞌa̱ mi pa̱di gue xi mrá ndutsꞌoqui, pe xi mi apabi Ajua̱ con gatho rá mʉi ne mi ena: “¡Ma Zidadaꞌi, dá nja ri nthecate de guequi, ngueꞌa̱ xi majua̱ni nugui ꞌnadrá da̱nga ꞌyøtꞌatsꞌoqui!” ");
INSERT INTO oteNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Hangue bi ꞌñenga ra Jesu: ―Dí xiꞌahʉ gue núꞌa̱ ra ꞌña̱tsa ngʉxboja̱ bi zʉdi ra pumbate de yá tsꞌoqui, ne bi menga ja rá ngu ya hinte má tsꞌoqui mi tu. Pe nura fariseo himbi zʉdi ra pumbate de yá tsꞌoqui. Ngueꞌa̱ nuꞌa̱ tóꞌo ri ꞌñexasɛ, núꞌá̱ go gueꞌa̱ ma da ꞌbɛ rá tsa. Ha nuꞌa̱ tóꞌo hini ꞌñexasɛ, núꞌá̱ ꞌmɛfa ma da tꞌeꞌtsua rá nsu. ");
INSERT INTO oteNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bá tsꞌimpabi ya zi ba̱tsi ra Jesu pa da hñuxa yá ꞌyɛ ne da ja̱pabiꞌʉ. Pe nu mi hyanda njabʉ yá nxadi bi zʉi núꞌʉ toꞌo mri zi yá ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ha nura Jesu bi ꞌñembabiꞌʉ: ―Hophʉ ya ba̱tsi da e da zʉcagui, oguí ha̱cuahʉ, ngueꞌa̱ nuꞌʉ tóꞌo da ꞌmʉi ja rá hmanda Ajua̱, mahyoni da nja ngu nuya ya zi ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nehe dí xiꞌahʉ gue nuꞌa̱ tóꞌo hinda nja ngu ꞌnara zi ba̱tsi pa da ꞌmʉi ja rá hmanda Ajua̱, hinda za da yʉtꞌa ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ne de gueꞌa̱ ꞌnara nda̱ de ja ra nija̱ bi ꞌyambabi ra Jesu ne bi ꞌñembi: ―Nuꞌi Xahnate, ꞌnagrá hoja̱ꞌi, ¿te da za ga øtꞌe pa ga tsʉdi ra te pa nza̱ntho? ");
INSERT INTO oteNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ha nura Jesu bi ꞌñembabi: ―¿Hanja guí engagui gue drá hoja̱ꞌi? Joꞌo maꞌna ra hoja̱ꞌi, hønsɛ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nuꞌi guí pa̱di xá hño ya hmanda de ra ley habʉ ena: “Oxqui ntsinga medintha̱ti, oxqui nhyote, oxcrí mpe, ne oxqui jʉꞌtsua ya ncꞌuamba ri miquꞌeiui, ne umba ra tꞌequꞌei ri dada ne ri na̱na̱ ne suꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ha núꞌa̱ ra ꞌñøhø bi ꞌñena: ―Gatho núyá stá øtꞌe desde ndí ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ha nu mi ꞌyøde ra Jesu njabʉ, bi ꞌñembabi: ―Ri ꞌbɛdi gui ꞌyøtꞌa maꞌna. Rí ma gui pa gatho núꞌa̱ guí pɛꞌtsi, ne gui hecuabi ya hyoya. Njabʉ ha̱, ma grí tsʉdi ya hño de mahetsꞌi. Ne bá ehe gui tɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pe nu mi ꞌyøde njabʉ núꞌa̱ ra nda̱ xi bi du rá mʉi ngueꞌa̱ xi mrá da̱nga rico. ");
INSERT INTO oteNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nu mi hyanda ra Jesu gue xi bi du rá mʉi, bi ꞌñena: ―¡Xi xá hñei da yʉtꞌa ꞌnara rico ja rá hmanda Ajua̱! ");
INSERT INTO oteNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maꞌna hingui hei da thogui ꞌnara da̱nga mboꞌni ngu ra cameyo ja rá gu ꞌnara ꞌyofri que ꞌnara rico da yʉtꞌa ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ha núꞌʉ toꞌo bi ꞌyøde nu mi ma̱nga njabʉ, bi ꞌñena: ―Nuꞌbʉ njabʉ, ¿toꞌoꞌa̱ da za da mpøhø? ");
INSERT INTO oteNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nura Jesu bi ꞌñembabi: ―Nuꞌa̱ jʉmpabi xá hñei ya ja̱ꞌi, pa Ajua̱ otho ꞌnara tꞌøtꞌe strá hñei. ");
INSERT INTO oteNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nepʉ nura Pedro bi ꞌñembabi: ―Ma zi Hmuꞌihe, nuje stuá tsoguihe gatho núꞌa̱ ndí pɛꞌtshe pa go stuá tɛnꞌahe. ");
INSERT INTO oteNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nepʉ ra Jesu bi ꞌñembabi: ―Majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo da zogui rá ngu, o rá dada, o rá na̱na̱, o yá cu, o rá ꞌbɛhña̱, o yá ba̱tsi po rá ngue ra ma̱ca noya, ");
INSERT INTO oteNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nuꞌá̱ ma da hña̱ni nuua ja ra ximhai maꞌna ndunthi que núꞌa̱ xa zogui, ne ꞌmɛfa ma da hña̱nga ra te pa nza̱ntho nuni mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y nura Jesu bi ꞌueque ꞌnambʉ núꞌʉ ꞌrɛtꞌamayoho yá nxadi, ne bi ꞌñembabi: ―Nubya grá maha pa Jerusale habʉ ma da nja ngu núꞌa̱ xa ꞌyofo yá ꞌmɛhni Ajua̱ de núꞌa̱ ma da thogui Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ma da tꞌɛntꞌua ja yá ꞌyɛ ya ja̱ꞌi núꞌʉ hingyá me Israel, ne nuꞌʉ́ ma da ꞌyøꞌtua ra ntꞌeni, ne ma da ña̱maꞌñʉ de gueꞌa̱, ne ma da zotsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nuꞌʉ́ ma da naꞌmbi nepʉ da hyo, pe nurá hñupa ma da yopa nte de ra du maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pe nuya nxadi himi tso yá mfeni de núꞌa̱ mi xipabi ra Jesu, nixi himi tsa da ba̱diꞌʉ de núꞌa̱ mi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","De ya mi ma da zønga ra Jesu ja ra hnini Jericó, mi huhni ꞌnara goda ja ra ꞌñu, mi pɛti. ");
INSERT INTO oteNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ha nu mi ꞌyødeꞌa̱ gue mi pani ndunthi ya ja̱ꞌi, nuꞌá̱ bi ꞌñani te rá ꞌbɛꞌa̱ xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nepʉ nuꞌá̱ bi sipabi gue mi pani ra Jesu me Nasare. ");
INSERT INTO oteNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nuꞌbʉ́ nuꞌá̱ bi ña̱ ntsꞌɛdi ne bi ꞌñena: ―¡Nuꞌi Jesu, rá Tꞌʉꞌi ra nda̱ Davi, dá nja ri nthecate de guequi! ");
INSERT INTO oteNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ha nuya ja̱ꞌi mri ꞌbɛtꞌo mi tsʉi ne mi embi gue da goꞌta rá ne, pe nuꞌá̱ maꞌna mri mafi ntsꞌɛdi ne mi ena: ―¡Rá Tꞌʉꞌi ra Davi, huegagui! ");
INSERT INTO oteNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nepʉ ra Jesu bi gohi bi ꞌmai ne bi mɛhni toꞌo bá tsi. Y nu mi zøhø habʉ mi ꞌbaiꞌa̱, bi ꞌyambabi ne bi ꞌñembi: ");
INSERT INTO oteNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Te guí ne ga øꞌtꞌaꞌi? Ha nura goda bi da̱di ne bi ꞌñena: ―Dí ne ga handi, Ndada. ");
INSERT INTO oteNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y ra Jesu bi ꞌñembabi: ―¡Nubya ha̱ xa njabʉ ngu núꞌa̱ guí ne! Xcá ña̱ni ngueꞌa̱ xcá camfrigui. ");
INSERT INTO oteNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ꞌBestho ra oraꞌa̱ ra goda bi za bi hyandi, ne bi dɛna ra Jesu, mi xøcambeni Ajua̱. Y gatho núꞌʉ ya ja̱ꞌi bi hyandi njabʉ, neꞌʉ bi xøcambeni Ajua̱ nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nepʉ nura Jesu bi yʉtꞌa ja ra hnini Jericó ne mri ꞌyo mi thogui made ra hnini. ");
INSERT INTO oteNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ne de guehni mi ꞌbʉ ꞌnara ꞌñøhø xi mrá rico mrá thuhu ra Saqueo, gueꞌa̱ mrá nda̱ de nuya ꞌña̱tsa ngʉxboja̱. ");
INSERT INTO oteNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nura Saqueo mi ne da hyanda ra Jesu pa da ba̱di toꞌoꞌa̱, pe himi tsa ngueꞌa̱ himrá heꞌtsa ja̱ꞌi y mi ꞌñoui ndunthi ya ja̱ꞌi ra Jesu, hangue himi tsa da hyandiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nepʉ nuꞌá̱ bi nestꞌihi bi ꞌmɛtꞌo bi bøxa maña̱ ja ꞌnara da̱nga ꞌbai gá za pa da za da hyanda ra Jesu, ngueꞌa̱ ja ma dí ꞌraniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nu mi thogui ra Jesu de guehni, bi hyandi gue ja mi tøhniꞌa̱. Ne bi ꞌñembabi: ―Nuꞌi Saqueo, bá da̱ma ca̱i, ngueꞌa̱ nubya dí ne ga tsøñꞌaꞌi ja ri ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nepʉ nura Saqueo mantꞌa̱ bi da̱ma ga̱i ne co ndunthi ra johya bi zixa ra Jesu ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ha nu mi hyanda njabʉ ya ja̱ꞌi, bi mʉdi bi nøñꞌʉ ra Jesu ngueꞌa̱ bi ma bá cʉtꞌa ja rá ngu ꞌnara tsꞌoja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nepʉ nura Saqueo bi ꞌñembabi ra Jesu: ―Ma zi Hmuꞌi, ma ga hecua ya hyoya made de numa hño dí pɛꞌtsi, ne ꞌbʉ toꞌo stá hatꞌi, ma ga juꞌtua goho ꞌmiꞌqui de núꞌa̱ stá hatꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ha nura Jesu bi ꞌñembabi: ―Núbya rapaya xa zøhø ra mpøhø nuua ja ri ngu, ngueꞌa̱ neꞌi xqui ꞌñehe desde yá ja̱ꞌi ndu ra Abrá. ");
INSERT INTO oteNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngueꞌa̱ Núꞌa̱ Toꞌo bi e bi Nja̱ꞌi, bá ehe pa da hyoni ne da pøhø núꞌʉ xa ꞌmɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nu mi uadi bi ma̱nga ra Jesu njabʉ, bi mʉdi bi xipabi ya ja̱ꞌi ꞌnara ꞌbede, ngueꞌa̱ ya mi ma da zønga Jerusale y núꞌʉ ya ja̱ꞌi mi hu yá mʉi gue mi ma da hnequi ꞌbestho rá hmanda Ajua̱ nu stí zøni. ");
INSERT INTO oteNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hangue nura Jesu bi ꞌñembabi: ―Mi ꞌbʉi ꞌnara ꞌñøhø mrá tꞌʉ ꞌnara nda̱. Núꞌá̱ bi ma yabʉ ja maꞌna ra hnini pa da thutsꞌi dega nda̱ ja rá hai, nepʉ da yopa mengui pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pe ante da maꞌa̱, bi zohna núꞌʉ ꞌrɛtꞌa yá ꞌbɛgo pa da umbabi ꞌra ꞌnara boja̱, y mahyɛgui rá ndunthi bi umbabi cada ꞌna de gueꞌʉ. Nepʉ bi ꞌñembabi: “ꞌYøthʉ ra thoni co núꞌa̱ dá ꞌraꞌahʉ pa da xu ri boja̱hʉ asta hinga pengui.” Ne bi gʉ rá ꞌñu bi ma. ");
INSERT INTO oteNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pe núꞌʉ ya ja̱ꞌi de rá hai núꞌʉ toꞌo mi ʉtsa, bi mɛhna ꞌraya ꞌmɛhni pa da ma nehe habʉ mri maꞌa̱ pa xa̱ma̱ hinxa thutsꞌi dega nda̱ de yá haiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pe nuꞌá̱ bi tꞌumbabi ra tsꞌɛdi pa da nda̱, ne bi menga ja rá hai. Ha nu mi zøhøꞌa̱ bi manda bi tsꞌohna gatho núꞌʉ toꞌo xqui umbabi ra boja̱, pa da ba̱di hangu xqui da̱ha̱ cada ꞌna de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nuꞌa̱ rá mʉdi bi zøhø bi ꞌñena: “Núꞌi ri tꞌequꞌei Nda̱, nuri boja̱ gá ꞌraqui xa xu má ꞌrɛtꞌa yá ndunthi de núꞌa̱ gá ꞌraqui.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ha nura nda̱ bi ꞌñembabi: “Xá hño, xi grá hoga ꞌbɛgo, xcá japi xa xu núꞌa̱ ꞌna tʉi dá ꞌraꞌi. Nubya ma ga huxꞌaꞌi dega nda̱ pa gui manda ꞌrɛtꞌa ya hnini,” bi ꞌñembi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ha nuꞌa̱ maꞌna ra ꞌbɛgo bi ꞌñena: “Núꞌi ri tꞌequꞌei Nda̱, nuri boja̱ gá ꞌraqui xa xu má cʉtꞌa yá ndunthi de núꞌa̱ gá ꞌraqui.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nuꞌbʉ́ ra nda̱ bi ꞌñembabi nehe: “Neꞌi ma ga huxꞌaꞌi dega nda̱ pa gui manda cʉtꞌa ya hnini.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nepʉ bi zøhø núꞌa̱ maꞌna bi ꞌñembabi: “Núꞌi ri tꞌequꞌei Nda̱, jaua ri boja̱ núna gá ꞌraqui. Dá tuꞌti ne dá pɛꞌtsi xá hño pa hindá ꞌbɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Dá ntsu xa bø ri cuɛ ngueꞌa̱ nuꞌi guí japi da mpɛfi ꞌna ndunthi, ne guí jʉ guí pɛꞌtsi núꞌa̱ hingo xcá pɛfi, ne guí xofo núꞌa̱ hinxcá potꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nepʉ nura nda̱ bi ꞌñembabi: “Nuꞌi ꞌnagrá tsꞌoꞌbɛgo, co núꞌa̱ ri noya gá ma̱ gá ntsꞌoquisɛ. Nuꞌbʉ gá pa̱di gue drí jaꞌahʉ gui mpɛhʉ ntsꞌɛdi ne dí jʉ dí pɛꞌtsi núꞌa̱ hinstá pɛfi, ne dí xofo núꞌa̱ hinstá potꞌi, ");
INSERT INTO oteNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","nuꞌbʉ́ ¿hanja hingá tsogui ma boja̱ ja ra banco pa xa xu rá tha̱ha̱?” ");
INSERT INTO oteNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nepʉ bi ꞌñembabi núꞌʉ maꞌra ya ꞌbɛgo mi ꞌbʉhni: “Hña̱mfʉ núꞌa̱ ra boja̱ ne umbabihʉ núꞌa̱ toꞌo bi xu ꞌrɛtꞌa ꞌmiꞌqui rá ndunthi ra boja̱.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pe nuꞌʉ́ bi ꞌñembabi: “Núꞌi ri tꞌequꞌei Nda̱, pe nuꞌá̱ ya pɛꞌtsa ꞌrɛtꞌa ya boja̱.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ha nura nda̱ bi da̱di ne bi ꞌñena: “Dí xiꞌahʉ gue nuꞌa̱ tóꞌo pa̱di da xu núꞌa̱ tꞌumbi, da tꞌumbabi maꞌna, pe nuꞌa̱ hingui pa̱di da xu núꞌa̱ tꞌumbi, da tha̱mbabi núꞌa̱ tsꞌʉ di pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ha núꞌʉ ma ncontra himi ne gue go ga nda̱, bá tsincahʉua gatho, ne hyohʉ ja ma thandi.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","De mi uadi bi ma̱nga njabʉ ra Jesu, bi thogui gá ma pa Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y de ya mi ma da zønga ja ra hnini Betfage ne ra hnini Betania, gueta ra tꞌøhø rá thuhu ꞌbo Olivo, bi mɛhna yoho yá nxadi, ");
INSERT INTO oteNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ne bi ꞌñembabi: ―Rí maha ja nuni ra hnini bí jani, ne nu xcrí tsøñhʉni ma gui tsʉhʉ ꞌnara zi burru di tha̱tꞌi de guehni, núꞌa̱ hinto xa tøguetho. Gui xoꞌthʉ ne ua tsincahʉua. ");
INSERT INTO oteNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nuꞌbʉ toꞌo da ꞌyanꞌahʉ hanja guí xoꞌthʉ, ꞌñembabihʉ: “Ma zi Hmuhe bí honi.” ");
INSERT INTO oteNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nepʉ núꞌʉ yoho yá nxadi bi ma ne bi zʉdi ngu xqui xipa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Y tsꞌa mi xoꞌtiꞌʉ, núꞌʉ toꞌo myá mɛti bi ꞌñembi: ―¿Te gui japhʉ ra burru guí xoꞌthʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nepʉ nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Ma zi Hmuhe bí honi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nuꞌbʉ́ bi tsꞌiꞌtsuabiꞌa̱ nura zi burru, ne nu mi zøniꞌʉ bi xiꞌtsua yá patꞌiꞌʉ pa bi tøgueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ne de mri ne ra ꞌñu ra Jesu, ya ja̱ꞌi mi ha̱ca yá patꞌi pa mi pøgue ja ra ꞌñu habʉ mi thoguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ne nu mi dontsꞌa ja ra tꞌøhø ꞌbo Olivo pa da ga̱i, gatho núꞌʉ mri dɛniꞌa̱ bi mʉdi bi mafi co ra johya ne mi xøcambeni Ajua̱ ngueꞌa̱ xqui hyantꞌʉ ya da̱nga ntꞌudi núꞌʉ xqui ꞌyøtꞌa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ne mi enaꞌʉ: ―¡Nja̱pi ra da̱nga Nda̱ nuni xuá mɛncahʉ Ajua̱! ¡Xi rá nsunda ra hogaꞌmʉi nuni mahetsꞌi, ne ma da njabʉ de guecua ja ra ximhai nehe! ¡Xi rá nsunda Ajua̱! ");
INSERT INTO oteNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nepʉ ꞌra de nuya fariseo mi pani ja ya ja̱ꞌi bi ꞌñembabi ra Jesu: ―Xahnate, dí nehe gui hña̱cua nuyʉ ya ja̱ꞌi grí ꞌñoui, hinda mafi. ");
INSERT INTO oteNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pe nura Jesu bi da̱di ne bi ꞌñembabi: ―Dí xiꞌahʉ gue nuꞌbʉ núyʉ da goꞌta yá ne, nuꞌbʉ́ da za da mafi asta ya do. ");
INSERT INTO oteNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nu mi zøhø ra Jesu gueta ra hnini Jerusale, bi hyandi ne bi huequi ne bi nzoni, ");
INSERT INTO oteNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","bi ꞌñena: ―¡Nuꞌahʉ me Jerusale, ꞌbʉ di tsohma̱ ri mfenihʉ gue xa zøhø ra pa pa gui mpøhøhma̱hʉ! Pe nubyá hinda za gui pa̱hʉ, ngueꞌa̱ xra tꞌa̱cꞌa ri mfenihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ma da zø ya pa xá ntsꞌo pa gueꞌahʉ, ngueꞌa̱ nuri ncontrahʉ ma da goꞌtꞌathohʉ, ne da theꞌtsꞌathohʉ, ne hingui cꞌothʉ de ja yá ꞌyɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ne da hyoꞌahʉ ne gatho ri ba̱tsihʉ, ne ma da nhuata ri hninihʉ, ne hinda ma da gohi ni ꞌnara do maña̱ de rá midoui. Núꞌá̱ gueꞌa̱ ma gui thoguihʉ ngueꞌa̱ hingá pa̱di gá hña̱ñhʉ nuna ra mpøhø Ajua̱ bá pɛhnꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nepʉ ra Jesu bi yʉtꞌa ja ra nda̱nija̱ ne bi mʉdi bi ꞌyɛnga gatho núꞌʉ toꞌo mi ꞌbʉhni mri mpa ne mri ntai de guehni, ");
INSERT INTO oteNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ne bi ꞌñembabi: ―Ja ra Ma̱ca Tꞌofo Ajua̱ ena njaua: “Numa ngu ra ngu pa da søcambenigui”; pe nuꞌahʉ́ xcá ꞌyøtꞌathohʉ ra ngu dega mfe. ");
INSERT INTO oteNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hyastho ra Jesu mi ꞌbʉhni ja ra nda̱nija̱ ne mi xahna ya ja̱ꞌi, pe nuya nda̱ gá macja̱ ne ya xahnate de ra ley ne gatho ya nda̱ de ra hnini, gathoꞌʉ mi honi hanja da za da hyoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pe himi tsa da ꞌyøtꞌa njabʉꞌʉ ngueꞌa̱ gatho ya ja̱ꞌi mi huxa ntꞌøde de núꞌa̱ mi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ꞌNara pa ra Jesu mi ꞌbʉi ja ra nda̱nija̱ mi zofo ya ja̱ꞌi de ra hoga ntꞌøde. Nepʉ bi zøhø ya nda̱ gá macja̱ ne ya xahnate de ra ley ne ya nda̱xjua nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nepʉ nuꞌʉ́ bi ꞌñembabi: ―Dí ne gui xicje toꞌo xuá mɛhnꞌaꞌi pa gui ꞌyøtꞌa nuya ya tꞌøtꞌeya, ne con te ma nsɛqui guí øtꞌa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nepʉ nura Jesu bi ꞌñembabi: ―Nequi ma ga anꞌahʉ ꞌnara ntꞌani: ");
INSERT INTO oteNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Toꞌo xqui umba ra tsꞌɛdi ra Xuua pa bi ꞌyøtꞌa ra sistehe? ¿Ha gue Ajua̱, o ya ja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nuꞌbʉ́ nuꞌʉ́ bi mʉdi bri ꞌñámbabi ꞌna ngu maꞌna ne bi ꞌñémbi: ―¿Te ga ma̱ñhʉbya? Nuꞌbʉ ga emfʉ gue Ajua̱ bi umba ra tsꞌɛdi, ma da ꞌñengaguihʉ: “Nuꞌbʉ́ ¿hanja hingá camfrihʉ?” ");
INSERT INTO oteNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ha nuꞌbʉ ga emfʉ gue ya ja̱ꞌi, nuꞌbʉ́ nuꞌʉ́ da bø yá cuɛ ne da hyojʉ dega ncꞌahni, ngueꞌa̱ nuꞌʉ́ beni gue ra Xuua xqui mɛhna Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nuꞌbʉ́ nuꞌʉ́ bi ꞌñembabi gue himi pa̱di toꞌo xqui umba ra tsꞌɛdi ra Xuua pa mi øtꞌa ra sistehe. ");
INSERT INTO oteNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hangue nura Jesu bi ꞌñembabiꞌʉ: ―Nixi guequi, hinga xiꞌahʉ con te ma nsɛqui dí øtꞌa njaua. ");
INSERT INTO oteNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nepʉ nura Jesu bi mʉdi bi xipa ya ja̱ꞌi ꞌnara ꞌbede ne bi ꞌñembabi: ―Mi ꞌbʉi ꞌnara ꞌñøhø xqui ga̱xa ndunthi ya ꞌbai gá obxi ja yá hua̱hi. Y de gueꞌa̱ bi umba nhyandi rá ua̱ꞌobxi ꞌraya hyanthua̱hi. Ha nuꞌá̱ bi ma de guehni gá ma ja maꞌna ra hai ndunthi ya pa. ");
INSERT INTO oteNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nu mi zøhø ra pa pa da nja ra sofo de ya obxi, bi mɛhna ꞌnará ꞌbɛgo núꞌa̱ toꞌo mrá me ua̱ꞌobxi pa da ꞌyapabi núꞌa̱ mri ꞌñepabiꞌa̱. Pe ya hyanthua̱hi bi guui dega mfɛi núꞌa̱ ra ꞌbɛgo ne hinte bi umbabi. ");
INSERT INTO oteNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pe nura me ua̱ꞌobxi bi mɛhna maꞌna rá ꞌbɛgo, neheꞌa̱ bi tꞌøꞌtua ya ntsꞌoꞌmʉi ne bi juui dega mfɛi ne hinte bi tꞌumbabi nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nepʉ bi mɛhna maꞌna, pe núꞌʉ ya hyanthua̱hi bi gʉ bi naꞌmbi asta bi zɛni ne bi guuiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nepʉ nura me ua̱ꞌobxi bi bensɛ ja rá mfeni ne bi ꞌñena: “Xibya, ¿te ga øtꞌe? Ma ga pɛhna ma hma̱ca tꞌʉ, xa̱ma̱ nu stí hyandiꞌʉ gue go di gueꞌa̱ ma tꞌʉ, xa̱ma̱ da ꞌyøte.” ");
INSERT INTO oteNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pe núꞌʉ ya tsꞌo hyanthua̱hi mi hyandua rá tꞌʉ ra me ua̱ꞌobxi bi zøhø, bi ꞌñémbabiꞌʉ: “Nuni go guehni ma da gohui yá hai rá dada, pe ma ga jʉhʉ ga hohʉ pa go ga cohʉ gatho ya hai.” ");
INSERT INTO oteNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hangue nuꞌʉ́ bi gʉ núꞌa̱ ra tꞌʉ ne bi pøni de ja ra hua̱hi ne bi hyoꞌʉ. Nuꞌbʉ́ ra Jesu bi ꞌyambabi ya ja̱ꞌi ne bi ꞌñembi: ―¿Te guí beñhʉ ma da ꞌyøtꞌa núꞌa̱ ra me ua̱ꞌobxi co núꞌʉ ya tsꞌo hyanthua̱hi? ");
INSERT INTO oteNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nuꞌá̱ ma da ꞌñehe ne da hyo gathoꞌʉ, ne da umbabi ya hai maꞌra ya hyanthua̱hi. Nu mi ꞌyøde njabʉ gatho ya ja̱ꞌi bi ꞌñena: ―¡Xa̱ma̱ Ajua̱ hinda hopi da njabʉ! ");
INSERT INTO oteNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nepʉ ra Jesu bi hyandiꞌʉ ne bi ꞌñembabi: ―Nuꞌbʉ́, ¿te ne da ma̱ núꞌa̱ huxa ja ra Ma̱ca Tꞌofo habʉ ena njaua?: Núꞌa̱ ra do bi føtbʉ hma̱ha̱ ꞌna lado nuya hyøngu, nubya gueꞌa̱ ra mʉdi do de rá nija̱ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nuꞌa̱ tóꞌo da feꞌtsa nura doꞌa̱, da ꞌuaca yá ndoꞌyo, ha nuꞌa̱ tóꞌo da zɛꞌmi, da quꞌɛꞌti. ");
INSERT INTO oteNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ya nda̱ gá macja̱ ne ya xahnate de ra ley xi mi nehma̱ xa gʉ ra Jesu nura oraꞌa̱, ngueꞌa̱ bi zo yá mfeniꞌʉ gue núꞌa̱ ra ꞌbede xqui ma̱ñꞌa̱, nuꞌá̱ xqui ma̱ pa gueꞌʉ, pe nuꞌʉ́ mi tsu ya ja̱ꞌi da bø yá cuɛ. ");
INSERT INTO oteNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hangue bi mɛhna ꞌraya ꞌyacate núꞌʉ mri ꞌñetꞌa hoja̱ꞌi, pa xa̱ma̱ xa ꞌyøde xa ña̱maꞌñʉ ra Jesu, pa njabʉ xa za xa ña̱pabi co ra gobierhnu. ");
INSERT INTO oteNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hangue nuꞌʉ́ bi ꞌyøꞌtua ꞌnara ntꞌani ne bi ꞌñembabi: ―Ma zi Xahnateꞌihe, dí pa̱he gue nuꞌi guí ma̱ ne guí udi núꞌa̱ xá hño, ne hinguí huahna núꞌa̱ toꞌo guí øꞌtua ra hño, ngueꞌa̱ nuꞌi guí udi rá ꞌñu Ajua̱ núꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dí ne gui xicaguihe, ¿ha gue rí ꞌñepi ga juthe núꞌa̱ ra boja̱ adi ra nda̱ Cesa, o hina? ");
INSERT INTO oteNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pe ra Jesu mi pa̱tuatho yá tsꞌomfeniꞌʉ, bi ꞌñembabi: ―¿Hanja guí ne gui hyacaguihʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ꞌÑutcahʉ ꞌnara boja̱ xa̱. ¿Toꞌo rá cꞌoi núna tøcua, ne toꞌo rá thuhuna̱? Nuꞌbʉ́ nuꞌʉ́ bi da̱di ne bi ꞌñembabi: ―Rá cꞌoi ne rá thuhu ra nda̱ Cesa. ");
INSERT INTO oteNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nuꞌbʉ́ nuꞌá̱ bi ꞌñembabi: ―Umfʉ ra nda̱ Cesa núꞌa̱ rí ꞌñepabi, ne umfʉ Ajua̱ núꞌa̱ rí ꞌñepabiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pe nuꞌʉ́ himbi dinba ni ꞌnara tsꞌonoya ja yá thandi ya ja̱ꞌi ngu núꞌa̱ mi neꞌʉ, asta go bi ꞌyøꞌʉ de núꞌa̱ gá da̱di ra Jesu, ne bi goꞌtatho yá neꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ꞌMɛfa ꞌraya ja̱ꞌi núꞌʉ tꞌembi ya saduceo bi ma bá cꞌa̱ꞌtsa ra Jesu. Núꞌʉ́ ena gue hinda ma da yopa nte núꞌʉ xa du. Ne nuꞌʉ́ bi ꞌñembabi ra Jesu: ");
INSERT INTO oteNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Ma Xahnateꞌihe, ra Moise bi zogui ntꞌofo gue ꞌbʉ ꞌnara ꞌñøhø da du ne da zogui rá ꞌbɛhña̱ ne himbi mɛꞌtsua ni ꞌnara ba̱tsi, nuꞌbʉ́ nurá cu núꞌa̱ ra ꞌñøhø bi du, mahyoni da ntha̱tui núꞌa̱ ra ꞌbɛhña̱ bi gohisɛ, pa ꞌbʉ da mɛꞌtsa ya ba̱tsi da thuꞌmba rá thuhu ngu rá thuhu ndu rá ꞌbɛtꞌo da̱me. ");
INSERT INTO oteNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ꞌNaꞌqui mi ꞌbʉi yoto ya ꞌñøhø mri ncu. Nuꞌa̱ rá mʉdi bi ntha̱ti pe ꞌmɛfa bi du, ne ni ꞌnara ba̱tsi himbi mɛꞌtsua rá ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Y nura ꞌbɛhña̱ꞌa̱ bi ntha̱tui maꞌna rá cu ndu rá da̱me, neꞌa̱ bi du, ne ni ꞌnara ba̱tsi himbi zocuabi. ");
INSERT INTO oteNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nepʉ nurá hñu rá cu ndu rá da̱me bi ntha̱tui nehe núꞌa̱ ra ꞌbɛhña̱. Y bi njabʉ ꞌramaꞌna asta bi du gatho núꞌʉ yoto, ha nu gathoꞌʉ ni ꞌnara ba̱tsi himbi zocuabi núꞌa̱ ra ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ne ꞌmɛfa bi du nehe núꞌa̱ ra ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hangue xi de stí yopa nte de ra duꞌʉ, ¿toꞌo ꞌna de gue núꞌʉ yoto bi ntha̱tui dí ꞌmʉhui mahetsꞌi? ");
INSERT INTO oteNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nepʉ ra Jesu bi ꞌñembabi: ―Nuua ja ra ximhai ya ꞌñøhø ne ya ꞌbɛhña̱ ri ntha̱ti. ");
INSERT INTO oteNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pe nu sta yopa nte de ra du ne stí ꞌmʉhni mahetsꞌi núꞌʉ rí ꞌñepi da ꞌmʉhni, ya hinda ma da ntha̱tiꞌʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ngueꞌa̱ ya hinda ma da du maꞌnaꞌqui. Ne ma da ꞌmʉ ngu ya ɛnxɛ, ne dyá tꞌʉ Ajua̱ ngueꞌa̱ ya da yopa nteꞌʉ de ra du. ");
INSERT INTO oteNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nusɛ ra Moise xicaguihʉ ja ra Ma̱ca Tꞌofo gue ma da yopa nte núꞌʉ xa du, ne ja guehnitho ma̱ de núꞌa̱ ra nda̱po mi zø, gue ja bi ꞌñembabini Ajua̱ gue go gueꞌa̱ rá Ajua̱ ra Abrá, ne de ra Isaac, ne de ra Cobo núꞌʉ ya xqui du. ");
INSERT INTO oteNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pe Ajua̱ hingrá Ajua̱ de núꞌʉ xa du, go rá Ajua̱ de núꞌʉ te. Hangue ra Abrá ne ra Isaac ne ra Cobo bí te ja rá thandi Ajua̱, ne gatho ya ja̱ꞌi te ja rá thandiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nepʉ ꞌraya xahnate de ra ley bi ꞌñembabi: ―Majua̱ni núꞌa̱ gá ma̱, ma Xahnateꞌihe. ");
INSERT INTO oteNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y de guehni ya hinte bi yopa ꞌyamba maꞌnaꞌquiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ra Jesu bi ꞌñembabiꞌʉ: ―¿Hanja guí ma̱ñhʉ gue núꞌa̱ ra Cristo bá pɛhna Ajua̱ pa da nda̱ gue rá tꞌʉ ra Davi? ");
INSERT INTO oteNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Gue nura Davi bi ꞌñena njaua ja ra Ma̱ca Tꞌofo de ya Salmo: Ajua̱ ra Dada bi ꞌñembabi ma zi Hmu: “Bá e gui hñudiua ja ma ꞌñɛi, ");
INSERT INTO oteNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta hinga tsihnꞌaꞌi gatho ri ncontra pa da gohiꞌʉ de rí gaꞌti ri ua.” ");
INSERT INTO oteNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nepʉ ra Jesu bi ꞌñena: ―Nuꞌbʉ ra Cristo go drá tꞌʉhma̱ ra Davi, nuꞌbʉ́ ¿hanja bi ꞌñenga ra Davi gue go rá Hmu? ");
INSERT INTO oteNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nepʉ ra Jesu bi zofo yá nxadi, y gatho ya ja̱ꞌi bi ꞌyøde. Ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Nsuhʉ, oxqui øthʉ ngu núꞌa̱ øtꞌa ya xahnate de ra ley, ri ho da ꞌño co ꞌraya he xá ma pa da numansu ya ja̱ꞌiꞌʉ. Ne ri ho dra zɛnjua co ndunthi ra tꞌequꞌei ja ya tai, ne ri ho da gʉ ya mʉdi hudi ja ya nija̱, ne go gueꞌʉ huahna ya mʉdi hudi habʉ ja ra hñuni. ");
INSERT INTO oteNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ne ha̱nbabi núꞌa̱ pɛꞌtsa ya viuda asta yá ngu nehe, ne pa hinda fa̱tua yá tsꞌotꞌøtꞌeꞌʉ, øtꞌa yá sadi xi xá ma, pe núꞌʉ́ go gueꞌʉ ma da hña̱nga ꞌnara castigo maꞌna ra da̱ngui. ");
INSERT INTO oteNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ha nura Jesu mi ꞌbʉhni ja ra nda̱nija̱ ne mi handa gatho núꞌʉ xi mi ja ndunthi te mi pɛꞌtsi gue mi ʉtꞌa yá boja̱ ja ra ꞌmɛꞌtsboja̱ de ra nija̱. ");
INSERT INTO oteNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nehe bi hyanda ꞌnara viuda xi mrá zi hyoya bi ꞌyɛntꞌni yoho ya zi boja̱ dega cobre. ");
INSERT INTO oteNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nepʉ nura Jesu bi ꞌñena: ―Xi majua̱ni dí xiꞌahʉ, gue nuna zi hyoya viuda xa unga maꞌna ndunthi que núꞌʉ maꞌra, ");
INSERT INTO oteNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ngueꞌa̱ nuꞌʉ́ bi uni pe de núꞌʉ yá mbongui, pe nuní, masque co rá zi nhyoya, bi unga gatho núꞌa̱ mi pɛꞌtsi pa xa zihma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nepʉ bi ꞌyøde ra Jesu gue ꞌra de núꞌʉ mi ꞌbʉhni mri mpede de ra nda̱nija̱, mi ma̱ñꞌʉ gue mri hnequi xi mahotho co ꞌraya hoga do xqui thoqui, ne xica tꞌøtꞌe xqui thuxni dega ꞌbaha. Nepʉ ra Jesu bi ꞌñembabiꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Xi majua̱ni dí xiꞌahʉ, gue ma da zø ra pa gatho núyʉ guí hanthʉ ma da yøtꞌe gatho, ne hinda gohi ꞌnara do maña̱ de rá midoui. ");
INSERT INTO oteNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nepʉ nuꞌʉ́ bi ꞌyambabi ne bi ꞌñembi: ―Ma Xahnateꞌihe, ¿haꞌmʉ ma da nja núꞌa̱ gá ma̱? ¿Te ma seña ma da hnequi nu sta zø ra pa da njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nuꞌbʉ́ ra Jesu bi ꞌñena: ―Nsuhʉ, oxqui hophʉ toꞌo da hyaꞌahʉ, ngueꞌa̱ ma da ꞌñepʉ ndunthi da bepca ma thuhu ne da ꞌñena: “Go guequi drá Cristo, ya xa zø ra pa pa ga nda̱.” Pe oxqui ma gui camfribihʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y nehe nu xcrí ꞌyøhʉ gue di ja ya tuhni habʉraza ne ya tsꞌothogui habʉraza ya hai, oxqui ntsuhʉ, ngueꞌa̱ mahyoni da njabʉ, pe beñhʉ gue tobia hindi gueꞌa̱ rá nga̱tsꞌi ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ne bi sigui bi ꞌñembabiꞌʉ: ―Ma da ntuhna ya hnini co maꞌra yá mihniniui, ne ya hai co maꞌra yá mihaiui. ");
INSERT INTO oteNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne ma da nja ndunthi ya da̱nga mbimhai ne ya da̱nga thuhu, ne ma da nja ndunthi ya tsꞌo hñeni habʉraza. Ha nu maña̱ mahetsꞌi ma da hneca ꞌraya ntꞌudi núꞌʉ asta dri unga ra ntsu. ");
INSERT INTO oteNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pe ante da nja núꞌa̱ dí xiꞌahʉ, ma dra tꞌʉtsaꞌihʉ ne dra jʉꞌahʉ, ma da tsꞌixꞌaꞌihʉ ja ya nija̱, ne ma da joꞌaꞌihʉ fadi, ne ma da tsꞌixꞌahʉ ja ya da̱nga nda̱ ne ja ya gobierhnu po rá nguecagui. ");
INSERT INTO oteNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ne ja guehni ja ma gui ma̱ñhʉni gue majua̱ni xcá camfriguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Oxqui beñhʉ ꞌmɛtꞌo núꞌa̱ te ma gui ma̱ñhʉ, nixi núꞌa̱ ma gui tha̱dihʉ pa gui ña̱nga ri tehʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ngueꞌa̱ nugui go ma ga ꞌraꞌahʉ ya noya gui ma̱ñhʉ, ne ra mfa̱di. Y njabʉ nuri ncontra hinda za da da̱ꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngueꞌa̱ nusɛ ri dadahʉ, ne ri cuhʉ, ne núꞌʉ maꞌra ja te ri njahʉ, ne ri amigohʉ, go gueꞌʉ ma da ña̱pꞌahʉ. ꞌRa de gueꞌahʉ ma da thoꞌahʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ne gatho ya ja̱ꞌi ma da ʉtsaꞌihʉ po rá nguecagui, ");
INSERT INTO oteNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","pe hinda za te da ꞌyøꞌtꞌahʉ, nixi da cꞌʉꞌtsꞌahʉ ni ꞌnari sta̱hʉ ꞌbʉ hingo rá paha Ajua̱ njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Y nuꞌbʉ gui tsɛthʉ núꞌa̱ da tꞌøꞌtꞌahʉ, nuꞌbʉ́ gui tsʉhʉ ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nu xcrí hyanthʉ ra hnini Jerusale di ꞌbʉhni ya soldado gatho ja rá nthetsꞌi, nuꞌbʉ́ gui pa̱hʉ gue ꞌbestho ma dra nhuati. ");
INSERT INTO oteNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ha nuꞌʉ di ꞌbʉi ja ra hai Judea mahyoni ꞌbestho da ꞌbatꞌi ja ya tꞌøhø, ha nuꞌʉ tóꞌo di ꞌbʉi mbo ra hnini Jerusale, mahyoni ꞌbestho da bøni. Ha nuꞌʉ tóꞌo di ꞌyo thi de ra hnini, ostí ma da mengui da yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngueꞌa̱ nuya paꞌʉ ma da hnequi rá cuɛ Ajua̱ ne ma da nja ya tsꞌothogui ngu núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Huecate núꞌʉ ya ꞌbɛhña̱ di daꞌthi ne núꞌʉ dya nzʉ nuya paꞌʉ! Ngueꞌa̱ ma da nja ndunthi ya da̱nga ʉgui, go gueꞌa̱ ꞌnará da̱nga cuɛ Ajua̱ pa núꞌʉ ya me Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ngueꞌa̱ nu ꞌra ma da du ja ra tuhni, ha nu maꞌra ma dra jʉ ne da tsꞌixa ntsꞌa̱hni yabʉ ja maꞌra ya hai. Ne ya nzøhø ja̱ꞌi ma da sigui da manda ra hnini Jerusale, asta hinda uadi núꞌʉ ya pa da umba nsɛqui Ajua̱ da nda̱ꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","De núꞌʉ ya paꞌʉ ma da hneca ya ntꞌudi. Ma da nja te da nja ja ra hyadi ne ja ra za̱na̱ ne ja ya tsø. Y gatho ya ja̱ꞌi de maxøgue ra ximhai ma da mpumfri co ra da̱nga ntsu nu sta ñʉni ra ndehe sta mpʉntsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ha nuya ja̱ꞌi asta di tu yá tsꞌɛdi co ra da̱nga ntsu de gatho núꞌa̱ ma da nja de guecua ja ra ximhai. Ha nu mahetsꞌi asta da mbi nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nepʉ ma da thandi Núꞌa̱ Toꞌo e bi Nja̱ꞌi dua yopa pengui ja ya guui co rá da̱nga tsꞌɛdi Ajua̱ xi strá nsunda. ");
INSERT INTO oteNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu xcrí hyanthʉ da mʉdi da nja núꞌa̱ dí xiꞌahʉ, oxqui ntsuhʉ, jʉxa ri thandihʉ pa mahetsꞌi, ngueꞌa̱ ꞌbestho ja dí ꞌñehni ri Ña̱ntehʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne bi xipabi ꞌnara ꞌbedeꞌʉ ne bi ꞌñembabi: ―Hyanthʉ ra ꞌbai gá igo o maꞌra ya nda̱po, ");
INSERT INTO oteNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ora ya da bøhø yá ꞌroho, guí pa̱hʉ gue ya ma da zøhø ra pahyadi. ");
INSERT INTO oteNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Njabʉ nehe nu xcrí hyanthʉ núya stá xiꞌahʉ, pa̱hʉ gue ra Nda̱ de mahetsꞌi ya ꞌbʉi guetbʉ pa dua yopa ehe ja ra ximhai pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Xi majua̱ni dí xiꞌahʉ, gatho nuya ya tꞌøtꞌeya ma da mʉdi da nja ante da du núꞌʉ ꞌbʉibya ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mahetsꞌi ne ra ximhai ma da uadi da thogui, pe numa noya hinhyaꞌmʉ da uadi, pɛꞌtsi da njabʉ ngu núꞌa̱ dá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nsuhʉ, ne oxqui hophʉ ri mfenihʉ da megui po rá ngue ra ntsꞌoꞌyo ne ra ntixfani ne maꞌra ya tsꞌotꞌøtꞌe, ne oxqui tu ri mʉihʉ de núꞌa̱ te da ꞌyøꞌtꞌahʉ ra ꞌbɛdi. Nsuhʉ pa hingue xcrí tha̱mfrihʉ da zøhø núꞌa̱ ra paꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ngueꞌa̱ ma da njabʉ ndunthi núꞌʉ ꞌbʉi habʉraza rá ngʉni ra ximhai, sta da̱mfri da zøhø ra pa, da nja ngu ꞌnara trampa da da̱ma njotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hangue ndøꞌmhʉ ne ꞌyaphʉ ndunthi Ajua̱ pa da za gui cꞌothʉ de gatho nuya ya tsꞌotꞌøtꞌe ma da nja, ne pa njabʉ da za gui ꞌbʉhʉ xá hño ja rá thandi Núꞌa̱ Toꞌo e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ra Jesu mi xahna ya ja̱ꞌi dega pa ja ra nda̱nija̱, ha nu dega xuui mi pa ja ra tꞌøhø ꞌbo Olivo. ");
INSERT INTO oteNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y gatho ya ja̱ꞌi mi tsøhø hyastho xi ꞌnitho ja ra nda̱nija̱ pa mi øde núꞌa̱ mi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ya mi ma da zøhø ra pa de ra ngo dega pascua núꞌbʉ mi tsꞌi ra thuhme nsi rá nzoi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ya nda̱ gá macja̱ ne ya xahnate de ra ley mri ꞌñʉꞌti pa hanja da za da hyo ra Jesu, pe himi tsa da gʉ ngueꞌa̱ mi tsuꞌʉ ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nepʉ de gueꞌa̱ ra Satá bi yʉtꞌa ja rá mfeni ra Juda núꞌa̱ xqui thuꞌmbabi nehe ra Iscariote, ꞌna de núꞌʉ ꞌrɛtꞌamayoho yá apostol ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Y nuꞌá̱ bi ma bá cꞌa̱ꞌtsa ya nda̱ gá macja̱ ne ya nda̱ de ra nija̱ pa bá ña̱uiꞌʉ hanja da za da ꞌyɛntꞌua ra Jesu ja yá ꞌyɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ha nuꞌʉ́ xi bi johya ne bi hña̱ꞌtuabi ra boja̱ꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hangue nuꞌá̱ ꞌbestho xi mi honi hanja da za da da ra Jesu, ne bi huahna ꞌnara ora mi joꞌo ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ne bi zø ra pa de ra ngo pa da tsꞌi ra thuhme nsi rá nzoi, gueꞌbʉ mi pɛꞌtsi da tho ꞌnara tꞌʉdɛti dega hña̱ꞌti. ");
INSERT INTO oteNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nuꞌbʉ́ ra Jesu bi mɛhna ra Pedro ne ra Xuua ne bi ꞌñembabi: ―Rí maha ꞌbɛtꞌohʉ pa grí hocjʉ ra hñuni de ra pascua ga tsihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nepʉ nuꞌʉ́ bi ꞌyambabi ne bi ꞌñembabi: ―¿Habʉ guí ne ma grá hocjeꞌa̱? ");
INSERT INTO oteNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Nu xcrí cʉthʉ ja ra hnini gui nthɛhʉni ꞌnara ꞌñøhø di ha̱ ꞌna ꞌbada ra dehe. Ne gui tɛnhʉ asta ja núꞌa̱ ra ngu habʉ da yʉtꞌiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ne ꞌñembabihʉ núꞌa̱ toꞌo ra me ngu: “Ra Xahnate bá pɛhnꞌa ra noya ga eñꞌahe njaua: ¿Habʉ ja ra ngu xcá ꞌuegagui pa ga tsihe ra ntꞌoxi dega pascua co ma nxadi?” ");
INSERT INTO oteNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nepʉ nuꞌá̱ ma da ꞌñuꞌtꞌahʉ ꞌnara da̱nga ngu maña̱ ja ra tøngu, ya xa thoqui xá hño, ne ja gui hocjʉni ra ntꞌoxi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nepʉ nuꞌʉ́ bi ma bá nthɛui gatho ngu núꞌa̱ xqui xipa ra Jesu. Ne ja bi hyocniꞌʉ ra ntꞌoxi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Y nu mi zø ra ora da ñuniꞌʉ, ra Jesu co yá apostol bi hñudi mahyɛgui ja ra mexa. ");
INSERT INTO oteNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nepʉ nura Jesu bi ꞌñembabiꞌʉ: ―¡Xi stá ne ga tsihʉ mahyɛgui ra ntꞌoxi de ra pascua ngu dí ꞌbʉihʉbya, ante da zø ra ora ga tu! ");
INSERT INTO oteNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngueꞌa̱ nugui dí xiꞌahʉ gue ya hinga ma ga yopa tsi ra ntꞌoxi de ra pascua maꞌnaꞌqui asta hinda zøhø núꞌa̱ ra pa grá tsihʉ nuni mahetsꞌi habʉ brí manda Ajua̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nepʉ nuꞌá̱ bi gʉ ra vaso ne bi umba njama̱di Ajua̱ ne bi ꞌñembabiꞌʉ: ―Na̱, tsihʉ ꞌra ꞌna tsiqui grí gathohʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nugui dí xiꞌahʉ gue ya hinga ma ga yopa tsi ra vinu dega obxi asta núꞌa̱ ra pa grá ꞌbʉhʉ nuni mahetsꞌi habʉ brí manda Ajua̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nepʉ nuꞌá̱ bi gʉ ra thuhme ne bi umbabi njama̱di Ajua̱ ne bi hecuabiꞌʉ bi umbi, ne bi ꞌñembabi: ―Guehna ma ndoꞌyo ma ga uni po rá ngueꞌahʉ. Ora gui tsihʉ, gueꞌa̱ ꞌnara feni de ma du. ");
INSERT INTO oteNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nepʉ de ya xqui uadi ra ntꞌoxiꞌʉ, nuꞌá̱ bi gʉ ra vaso, ne bi ꞌñembabi: ―Nuna vinu guehna ꞌnara seña de ra ꞌraꞌyo cohi xa tꞌøtꞌe co ma ji núꞌa̱ ma ga fani po rá ngueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Y nubyá ꞌna de gue núꞌahʉ guí ꞌbʉhʉua con guequi ja ra mexa, ma gui dagaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Núꞌa̱ Toꞌo e bi Nja̱ꞌi, ya ri ne nuna ra ꞌñu xa tꞌutuabi pa rí ma ja ra du, pe ¡huecate núꞌa̱ toꞌo ma da daꞌa̱! ");
INSERT INTO oteNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nepʉ nuꞌʉ́ bi mʉdi bi ꞌñámbabi ꞌna ngu ꞌna toꞌo núꞌa̱ mi ma da ꞌyøtꞌa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nepʉ nuꞌʉ́ bi mʉdi bi ꞌñámbabi toꞌo de gueꞌʉ mi ma da uaꞌa̱ da ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pe ra Jesu bi ꞌñembabiꞌʉ: ―Ya nda̱ ri manda yá hnini ngu ya hmu, ha nuya hnini eꞌtsua yá nsu yá nda̱ gue xi øtꞌe xá hño. ");
INSERT INTO oteNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pe nuꞌahʉ́ hingue rí ꞌñepi gui njahʉbʉ. Nuꞌa̱ rí ꞌñepi gui ꞌyøthʉ, nuꞌa̱ da nja rá nsu de gueꞌahʉ, mahyoni da notsi, ha nuꞌa̱ tóꞌo da manda, mahyoni da nja ngu ꞌnara ꞌbɛgo. ");
INSERT INTO oteNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Toꞌo maꞌna tꞌumba ra nsu, ha gue núꞌa̱ toꞌo da hñudi ja ra mexa, o núꞌa̱ toꞌo pɛpabi? ¿Ha hingue núꞌa̱ hudi ja ra mexa? Masque njabʉ, pe nugui drá ꞌbɛgo de gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nuꞌahʉ hinxcá ꞌueguehʉ de guequi masque xcá hyanthʉ ya tsꞌothogui núꞌʉ stá thogui. ");
INSERT INTO oteNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hangue nugui ma ga ꞌraꞌahʉ ri nsuhʉ dega nda̱, ngu ma Dada xa ꞌracagui ra nsu pa ga nda̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ha nu xcrá nda̱, ma gui ꞌbʉhʉni nehe con guequi, ne ga ñuñhʉ. Ne ja ma grá ꞌraꞌahʉni ri hudihʉ nehe dega nda̱ pa gui mandahʉ núꞌʉ ꞌrɛtꞌamayoho ya ꞌmʉi de ya ja̱ꞌi de Israel. ");
INSERT INTO oteNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nehe ra Jesu bi ꞌñembabi ra Simu Pedro: ―Nugue Simu, ra Satá xa ꞌyadi pa da hña̱cꞌa ri jamfrihʉ, ne da ꞌyøꞌtꞌahʉ ngu ra trigo ora ꞌbiqui. ");
INSERT INTO oteNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pe nugui stá apabi Ajua̱ ma Dada por gueꞌi, gue hinda ꞌmɛdi ri jamfri. Ha nu xcrí yopa jʉ ri jamfri, gui japi da zɛdi yá jamfri nehe nuyʉ maꞌra ri cu. ");
INSERT INTO oteNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ha nura Simu bi ꞌñembabi: ―Ma zi Hmuꞌi, nugui dí ꞌbʉcua ꞌbʉ da tsꞌixꞌaꞌi ra fadi, ga ma nehe, ha nuꞌbʉ da thoꞌi, dá thogui nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ha nura Jesu bi ꞌñembabiꞌa̱: ―Nugui dí xiꞌaꞌi nuꞌi Pedro, gue núbya dí nxuui ante da mafi ra menja̱ ma gui ma̱ hñuꞌqui gue hinguí pa̱cagui. ");
INSERT INTO oteNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ra Jesu bi ꞌyambabi yá nxadi ne bi ꞌñembi: ―Xi núꞌbʉ dá pɛhnꞌahʉ hingá hña̱xa ri buxahʉ nixi ri ncʉboja̱hʉ nixi ri mponga zɛsthihʉ, ¿ha gue bi nja te bi ꞌyøꞌtꞌahʉ ra ꞌbɛdi? Nepʉ nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Hina. ");
INSERT INTO oteNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nepʉ nuꞌá̱ bi ꞌñembabi: ―Pe nubyá ha̱, dí xiꞌahʉ gue nuꞌʉ tóꞌo pɛꞌtsa rá buxa ne rá ncʉboja̱, dá hña̱tsꞌi. Ha nuꞌa̱ tóꞌo hingui pɛꞌtsa rá huai, dá pa rá patꞌi pa da dai. ");
INSERT INTO oteNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngueꞌa̱ nugui dí xiꞌahʉ gue mahyoni da njabʉ ngu ma̱nga ra Ma̱ca Tꞌofo de guequi habʉ ena: “Nuꞌá̱ ja ra uɛnda ꞌnara ꞌyøtꞌatsꞌoqui.” Ngueꞌa̱ gatho núꞌa̱ xa ntꞌofo de guequi pɛꞌtsi da njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nepʉ nuꞌʉ́ bi ꞌñembabi: ―Ma zi Hmuꞌihe, jaua yoho ya huai dí pɛꞌtshe. Ha nuꞌá̱ bi da̱di ne bi ꞌñembabi: ―Con sɛhɛꞌʉ yoho. ");
INSERT INTO oteNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nepʉ nura Jesu bi bøni bi ma ngu mrá nza̱i pa ja ra tꞌøhø ꞌbo Olivo. Ne gatho yá nxadi bi dɛniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ha nu mi zøni de guehni, bi ꞌñembabiꞌʉ: ―ꞌYaphʉ ndunthi Ajua̱ pa gui tsɛthʉ ya tsꞌothogui nu stí ꞌñepʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nepʉ ra Jesu bi ꞌuegue de gueꞌʉ tsꞌʉ zi yabʉ pa bá ndandiña̱hmu bá apabi Ajua̱ rá Dada, ");
INSERT INTO oteNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ne bi ꞌñembabi: ―Ma Dadaꞌi, ꞌbʉ gui nehma̱, gui ꞌueca nuna thogui ma ga thogui, pe hindí ne gui ꞌyøtꞌe ngu núꞌa̱ ga nega, go da ꞌyøtꞌa ngu núꞌa̱ ri pahague. ");
INSERT INTO oteNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nepʉ nuni habʉ mi apabi Ajua̱ꞌa̱, bi zøhni ꞌnara ɛnxɛ xqui ꞌñehe de mahetsꞌi pa bi umbabi ra tsꞌɛdi pa da zɛta ra tsꞌothogui. ");
INSERT INTO oteNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nuꞌá̱ xi mi tu rá mʉi ndunthi de mi apabi Ajua̱, pe maꞌna mi apabi co ndunthi ra tsꞌɛdi asta mri xanthe, ne nuyá xanthe ngu myá da̱nga tagui dega ji, mi tʉi ja ra hai. ");
INSERT INTO oteNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nu mi uadi bi ꞌyapabi Ajua̱ꞌa̱, bi mengui pa habʉ xqui zogui yá nxadi, ne bi zʉdi gatho xqui ꞌña̱ha̱ ngueꞌa̱ ya xqui uentꞌiꞌʉ co ra dumʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ha nuꞌá̱ bi ꞌñembabi: ―¿Hanja xcá a̱ha̱hʉ? Nanjʉ, ne ꞌyapabihʉ Ajua̱ pa gui tsɛthʉ ya tsꞌothogui. ");
INSERT INTO oteNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tsꞌa mi ña̱ui yá nxadi ra Jesu, bi zøhø xi ndunthi ya ja̱ꞌi, ne nura Juda ꞌna de núꞌʉ ꞌrɛtꞌamayoho ya nxadi, mbra ꞌbɛtꞌo de ja ya ja̱ꞌi. Ne ꞌbestho bi uatꞌa habʉ mi ꞌba ra Jesu pa bi zʉꞌtsiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nepʉ ra Jesu bi ꞌñembabi: ―Juda, ¿ha gue co ꞌnara ntsʉꞌtsi grí da Núꞌa̱ Toꞌo e bi Nja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ha núꞌʉ mri ꞌñoui ra Jesu mi hyandi te ma da nja bi ꞌñembabi: ―Ma zi Hmuꞌihe, ¿ha guí ne ga xithe co ya huai? ");
INSERT INTO oteNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y ꞌna de gueꞌʉ bi mɛnpa ꞌnara ntsɛqui ꞌnará ꞌbɛgo ra da̱nga nda̱ gá macja̱ ne bi dacua rá gu ra ꞌñɛi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pe ra Jesu bi ꞌñembabiꞌʉ: ―Hyɛhʉbʉ, oguí øthʉ njabʉ. Nepʉ nuꞌá̱ bi hñuxa rá ꞌyɛ ja rá gu núꞌa̱ ra ꞌbɛgo, ne bi ña̱ni ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nepʉ bi zofo nuya nda̱ gá macja̱, ne ya nda̱ de ra nda̱nija̱, ne ya nda̱xjua nda̱, gatho núꞌʉ xqui ꞌñehe pa e da zitsꞌiꞌa̱, ne bi ꞌñembabiꞌʉ: ―¿Ha gue drá be pa e gui jʉgaguihʉ co ya huai ne ya za? ");
INSERT INTO oteNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pe núꞌbʉ ndí ꞌbʉi hyastho con gueꞌahʉ ja ra nda̱nija̱, hinte gá ꞌyøtcahʉ. Pe xibya, go xcuá ehʉ masque dega xuui pa gui jʉgaguihʉ. Ngueꞌa̱ nuya ya orabya go ri orahʉ pa gui nda̱hʉ de guequi, ne ya orabya go ya ora pa da nda̱ ra ꞌbɛxuui. ");
INSERT INTO oteNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nepʉ de guehni bi gʉ ntsꞌa̱hniꞌʉ ra Jesu, ne bi zitsꞌi ja rá ngu ra da̱nga nda̱ gá macja̱, ha nura Pedro mi ꞌbɛfa dega zi yabʉtho, mri dɛni. ");
INSERT INTO oteNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ha nu mi zønga ra Pedro ja rá ngu ra da̱nga nda̱ gá macja̱, xqui tꞌudi ꞌnara faspi ja ra patio, ne ja mi huhni ꞌraya ja̱ꞌi mri mpaꞌti, nehe ra Pedro ja bi hñuhni con gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y de guehni ꞌnara nxutsi rá ꞌbɛgo ra da̱nga nda̱ gá macja̱ nu mi hyandi gue mi huhni ra Pedro ja ra tsibi xi bi nʉꞌtiꞌa̱ ne bi ꞌñena: ―Pøde ne nuni ra da̱me go mri ꞌñoui ra Jesu nehe. ");
INSERT INTO oteNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pe nura Pedro bi gømbabi núꞌa̱ ra nxutsi ne bi ꞌñembi: ―Hina, hindí pa̱di toꞌoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nepʉ hinga yaꞌa̱ bi hyanda maꞌna ne bi ꞌñembabi: ―Pøde neꞌi go ngrí ꞌñoui ra Jesu. Ha nura Pedro bi ꞌñena: ―Hina, hinga majua̱ni ndrí ꞌñoꞌbeꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ꞌMɛfa de xqui thogui ngu ꞌna ora bi ꞌñena maꞌna ra ja̱ꞌi: ―Majua̱ni nuna ꞌñøhøni go mri ꞌñouiꞌa̱, ngueꞌa̱ nehni mfa̱tho gue ra me Galilea. ");
INSERT INTO oteNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nepʉ nura Pedro bi ꞌñena: ―Dí xiꞌaꞌi gue nixi dí pa̱di núꞌa̱ guí ma̱. Y núꞌa̱ ra ora de tsꞌa mi ma̱nga njabʉ, bi mafi ra menja̱. ");
INSERT INTO oteNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Núꞌa̱ ra oraꞌa̱ bi ñegui ra zi Hmu Jesu pa bi hyanda ra Pedro, ha nura Pedro ꞌbestho bi zo rá mfeni de núꞌa̱ xqui xipabi desde rá mʉdi, xqui ꞌñembabi: “Ante da mafi ra menja̱ ma gui cøngagui hñuꞌqui.” ");
INSERT INTO oteNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hangue nura Pedro bi bøni pa thi, xi bá nzoni ntsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ha nuya ja̱ꞌi núꞌʉ toꞌo mri su ra Jesu xi mi øꞌtua ra ntꞌeni ne mi naꞌmbabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Y bi goꞌtua yá da co ꞌnara dutu ne mi umba ya mpɛꞌti, ne mi embabiꞌʉ: ―¡Xicaguihe xa̱ toꞌo núꞌa̱ bi napꞌaꞌi! ");
INSERT INTO oteNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne mi xipabi ndunthi ya tsꞌonoya. ");
INSERT INTO oteNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Rá hyaxꞌa̱ bi muntsꞌa ya nda̱xjua nda̱ ne ya nda̱ gá macja̱ ne ya xahnate de ra ley. Ne bi tsꞌixa ra Jesu pa habʉ mi muntsꞌa núꞌʉ ya da̱nga nda̱ gá xodyo, y de guehni ja bá tꞌambabini ne bi tꞌembabi: ");
INSERT INTO oteNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Xicje, ¿ha gue xi majua̱ni go gueꞌi grá Cristo xuá mɛhnꞌaꞌi Ajua̱ pa gui nda̱? Nepʉ nuꞌá̱ bi da̱di ne bi ꞌñembabiꞌʉ: ―ꞌBʉ ga eñꞌahʉ gue go guequi, hingui camfriguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ha nuꞌbʉ ga øꞌtꞌahʉ ꞌraya ntꞌani, hingui xicaguihʉ, ha nixi gui hyɛgaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pe nuya pa xa ꞌñepʉ, Núꞌa̱ Toꞌo e bi Nja̱ꞌi ma da hñudi ja rá ꞌñɛi Ajua̱ núꞌa̱ toꞌo bí pɛꞌtsa gatho ra tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nepʉ nuꞌʉ́ bi ꞌyambabiꞌa̱ ne bi ꞌñembabi: ―Nuꞌbʉ́, ¿ha gue go gueꞌi rá Tꞌʉꞌi Ajua̱? Ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Ha̱ha̱, go guecagui, ngu xcá ma̱ñhʉbya. ");
INSERT INTO oteNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nepʉ nuꞌʉ́ bi ꞌñena: ―¡Pa te maꞌra ya testigo ga hoñhʉ gue nucsɛhʉ ya dá øhʉ núꞌa̱ bi ma̱! ");
INSERT INTO oteNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Y de guehni gatho nuya nda̱ bi ꞌmaiꞌʉ bi zixa ra Jesu ja ra Pilato. ");
INSERT INTO oteNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y nuni ja bi mʉdini bi ña̱pabiꞌʉ ne bi ꞌñena: ―Ya stá tsʉhe nuna ꞌñøhø mi ꞌyoni mi ʉꞌta ya ja̱ꞌi gue hinda gutꞌa yá njutꞌi ja ra nda̱ Cesa, nehe xa ꞌñensɛ gue go guehni ra Cristo xuá mɛhna Ajua̱ pa da nda̱, ꞌna̱. ");
INSERT INTO oteNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hangue nura Pilato bi ꞌñembabi: ―¿Ha go gueꞌi grá nda̱ de ya xodyo? Ha nura Jesu bi da̱di ne bi ꞌñena: ―Ha̱ha̱, go guequi, ngu gá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ha nura Pilato bi ꞌñembabi ya nda̱ gá macja̱ ne gatho ya ja̱ꞌi: ―Hinte ma tsꞌoqui dí tsʉtuabi nuna ra ꞌñøhø. ");
INSERT INTO oteNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pe nuꞌʉ́ maꞌna mi ña̱te ntsꞌɛdi, ne bi ꞌñena: ―Nuni go guehni xa ꞌño xa ꞌyʉꞌta ya ja̱ꞌi habʉraza de ra hai Judea, bá fʉdi desde Galilea asta bi zøhø de guecua Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nu mi ꞌyøde njabʉ ra Pilato bi ꞌyambabi ya ja̱ꞌi ua mrá me Galilea ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y nuꞌʉ́ bi ꞌñena gue ja mrá menguniꞌa̱, hangue nura Pilato bi mɛhni ꞌbesthoꞌa̱ ja ra Erode, ngueꞌa̱ go gueꞌa̱ mrá nda̱ de ja ra hai Galilea, pe núꞌʉ ya paꞌʉ xqui zøhø ra Erode ne ja mi ꞌbʉhni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nu mi hyanda ra Jesu ra nda̱ Erode, xi bi johyaꞌa̱ ngueꞌa̱ ya mi pɛꞌtsa ndunthi ya pa xi mi ne da hyandiꞌa̱ ngueꞌa̱ xqui ꞌyøde xqui hma̱ ndunthi de gueꞌa̱. Ne mi ne da hyandi da ꞌyøtꞌa ꞌnara milagro. ");
INSERT INTO oteNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y nuꞌá̱ bi ꞌyamba ndunthi ya ntꞌani, pe ra Jesu hinte bi da̱di. ");
INSERT INTO oteNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ja mi ꞌbʉhni nehe ya nda̱ gá macja̱ ne ya xahnate de ra ley, y maꞌna xi mi ña̱teꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nepʉ nura Erode co yá soldado bi nthedetho de gueꞌa̱. Nepʉ bi ꞌyøꞌtua ra ntꞌeni bi hyete ngu ꞌñena ꞌnara nda̱ co ꞌnara hoga he mahotho. Nepʉ nura Erode bi yopa mɛhna ra Jesu maꞌnaꞌqui pa ja ra Pilato. ");
INSERT INTO oteNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ra Pilato ne ra Erode mri ꞌñʉtsahma̱ꞌʉ, pe núꞌa̱ ra paꞌa̱ bi má̱diꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nepʉ nura Pilato bi zohna gatho ya nda̱ gá macja̱ ne gatho ya nda̱ de ra hnini, ne gatho maꞌra ya ja̱ꞌi, ");
INSERT INTO oteNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ne bi ꞌñembabiꞌʉ: ―Nuꞌahʉ go uá tsincahʉua nuna ra ꞌñøhø guí eñhʉ gue ʉꞌta ya ja̱ꞌi, pe nugui stá øꞌtua ya ntꞌani ja ri thandihʉ, y xcá ꞌyøhʉ gue hinstá tsʉtua ni ꞌnara tsꞌoqui de núꞌa̱ guí ma̱ñhʉ xa ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nixi ra nda̱ Erode himbá tsʉtuabi ni ꞌnara tsꞌoqui, hangue bá yopa pɛhna maꞌnaꞌqui pa guecua. Ya nubyá gá pa̱hʉ gue nuní hinte ma tsꞌoqui xa ꞌyøtꞌe pa gui ña̱phʉ gue rí ꞌñepi da tho. ");
INSERT INTO oteNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hangue nugui, hønsɛ ma ga manda dra fɛtꞌi, nepʉ ga hɛgui. ");
INSERT INTO oteNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ra Pilato mi pɛꞌtsi da hyɛgui ꞌnara ꞌyofadi cada ra ngo de ra pascua, ngueꞌa̱ gueꞌa̱ myá nza̱i nuya gobierhnu de Judea. ");
INSERT INTO oteNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pe gatho núꞌʉ ya ja̱ꞌi mi ꞌbʉhni bi mʉdi bi dø ya hmafi ne bi ꞌñena: ―Hindí nehe gui thøgue ra Jesu, go da thøgue ra Barraba. ");
INSERT INTO oteNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nura Barraba xqui jotꞌa fadi ngueꞌa̱ xqui gʉxa ya ja̱ꞌi pa da ꞌñøtꞌatuhni ja ra hnini, ne ngueꞌa̱ xqui hñote. ");
INSERT INTO oteNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pe nura Pilato go mi ne da hyɛgui ra Jesu, hangue bi yopa zofo ya ja̱ꞌi maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pe nuꞌʉ́ bi mafi maꞌna ntsꞌɛdi ne bi ꞌñena: ―¡Nuꞌa̱ dí xiꞌahe, gue gui pontꞌi, gui pontꞌi! ");
INSERT INTO oteNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nurá hñuꞌqui bi ꞌñembabiꞌʉ ra Pilato: ―¿Hanja? ¿Te ma tsꞌoqui xa ꞌyøtꞌni? Nugui hindí tsʉtua ni ꞌnara tsꞌoqui núꞌa̱ rí ꞌñepi da tho. Dí xiꞌahʉ gue ma ga manda dra fɛtꞌi, nepʉ ga hɛgui. ");
INSERT INTO oteNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pe nuꞌʉ́ bi dø ya hmafi maꞌnaꞌqui, ne bi ja bi ꞌyadi gue dra pontꞌiꞌa̱. Ne co yá hmafi núꞌʉ ya nda̱ gá macja̱ ne maꞌra ya ja̱ꞌi, bi zʉ yá tsꞌɛdi ngu mi neꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hangue nura Pilato bi ꞌyøꞌtua núꞌa̱ myá hneꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hangue go bi hyɛgui núꞌa̱ ra ꞌñøhø xqui ꞌyadi ya ja̱ꞌi, núꞌa̱ mrá thuhu Barraba xqui jotꞌa fadi ngueꞌa̱ mrá da̱ga ꞌyøtꞌatuhni ne mrá hyote. Ha nura Jesu bi tꞌɛntꞌua yá ꞌyɛ ya ja̱ꞌi pa da hyo. ");
INSERT INTO oteNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Y de bi tsꞌixa ra Jesu pa dra pontꞌi, de má ꞌñu bi nthɛui ꞌnara ꞌñøhø mrá me Cirene mrá thuhu ra Simu xqui menga ja ra mbonthi, go gueꞌa̱ bri japi bi duxa ra pontꞌi ne bi ꞌmɛfa de ja ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ne mri dɛni ndunthi ya ja̱ꞌi, y ndunthi ya ꞌbɛhña̱ xi mi zoni ne mri manthoꞌʉ por gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pe ra Jesu bi hyandiꞌʉ ne bi ꞌñembi: ―Nuꞌahʉ ꞌbɛhña̱hʉ me Jerusale, oguí zoñhʉ por guequi, nzonihʉ de gueꞌasɛhʉ ne por gatho ri ba̱tsihʉ, ");
INSERT INTO oteNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ngueꞌa̱ ma da zø ra pa da ꞌñena ya ja̱ꞌi: “Rá matꞌa Ajua̱ núꞌʉ toꞌo hinxa mɛꞌtsa ni ꞌnara ba̱tsi nixi xa nzʉ.” ");
INSERT INTO oteNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Y nuya paꞌʉ ya ja̱ꞌi ma da mafi ne da ꞌñembabi ya da̱nga tꞌøhø ne ya tꞌʉca tꞌøhø: “Yøtꞌe pa gui cobgahe pa hinda zʉcaguihe rá cuɛ Ajua̱.” ");
INSERT INTO oteNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xi majua̱ni ma da thoguiꞌʉ ya tsꞌothogui, ngueꞌa̱ nuꞌbʉ nugui dí sufri ha hinte ma tsꞌoqui dí tu, xihma̱ núꞌʉ tu ya tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nehe bi tsꞌixa má yoho ya ꞌñøhø núꞌʉ xqui tꞌɛꞌmbi da tho nehe ngueꞌa̱ ꞌnamyá ndutsꞌoqui. Bi tsꞌitsꞌi pa da tho mahyɛgui co ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ha nu mi zønga ja ꞌnara zi tꞌøhø rá thuhu Ña̱xmadu, ja bri pontꞌini ra Jesu co núꞌʉ má yoho ya ꞌñøhø, ꞌna bri ꞌbaꞌma ja rá ꞌñɛi, ha nuꞌa̱ maꞌna ja rá nga̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y nu de mi zʉhni ra Jesu ja ra pontꞌi, nuꞌá̱ bi ꞌñena: ―Ma Dadaꞌi, pumbabi gatho nuyʉ ya ja̱ꞌi bi ꞌyøtca njaua, ngueꞌa̱ nuyʉ́ hingui pa̱di núꞌa̱ øtꞌe. Ha núꞌʉ ya soldado mi ꞌbʉhni bi ma ra ta̱ha̱ꞌʉ pa da nu toꞌo gueꞌa̱ da da̱ha̱ ꞌna de nuyá he ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y ndunthi ya ja̱ꞌi mi ꞌbahni bi hyandi bri pontꞌa ra Jesu, ne asta ya nda̱ gá xodyo mi øtbuhlatho de gueꞌa̱ ne mi ena: ―Maꞌra ha̱, bi pøhø, pe nuꞌbʉ xi majua̱ni go guehni ra Cristo xuá mɛhna Ajua̱ pa da nda̱, dí ne ga hanthʉbya da mpøhøsɛ. ");
INSERT INTO oteNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nehe nuya soldado mi øtbuhlatho de gueꞌa̱, mi umbabi ra juꞌtsa vinu pa da zi, ");
INSERT INTO oteNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ne mi embabiꞌʉ: ―ꞌBʉ xi majua̱ni go gueꞌi grá Nda̱ de ya xodyo, mpøhøsɛ núbya xa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne xqui thøtua ja rá ña̱ ra pontꞌi ꞌnara tꞌofo xqui tꞌofo dega griego, ne dega lati, ne dega ebreo, mi ena njaua: “Go guehna ra Nda̱ de ya xodyo.” ");
INSERT INTO oteNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nepʉ ꞌna de gue núꞌʉ ya ndutsꞌoqui xqui ꞌbontꞌi nehe mahyɛgui, bi ña̱maꞌñʉ de gueꞌa̱ ne bi ꞌñembabi: ―ꞌBʉ xi majua̱ni go gueꞌi grá Cristo xuá mɛhnꞌaꞌi Ajua̱ pa gui nda̱, mpøhøsɛ ne pøhøguihe. ");
INSERT INTO oteNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pe núꞌa̱ maꞌna ra ndutsꞌoqui xqui ꞌbontꞌi nehe, bi zʉi núꞌa̱ bi ña̱maꞌñʉ, ne bi ꞌñembabi: ―¿Ha hinguí tsu Ajua̱ pa gá ma̱nga njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Guí nu gue dí sufrihʉua mahyɛgui, pe nujʉ́ rí ꞌñepi ga sufrihʉ pa ga juthʉ núꞌa̱ stá øthʉ, pe nuni ra ꞌñøhø hinxa ꞌyøtꞌa ni ꞌnara tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nepʉ nuꞌá̱ bi ꞌñembabi ra Jesu: ―Gui bengagui nu xcrí hudi ja ri hudi dega hmanda. ");
INSERT INTO oteNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ra Jesu bi da̱di ne bi ꞌñembabi: ―Nugui dí xiꞌaꞌi gue núbya ꞌbestho ma gui ꞌbʉi con guecagui nuni mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Y ngu mi nde ma pa bi ꞌmɛxuui maxøgue ra ximhai, pa asta ngu nzʉnga hñu nde, ");
INSERT INTO oteNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ngueꞌa̱ nura hyadi himbi yotꞌi, ha nura da̱nga xʉni dutu mi naxa mbo ra nda̱nija̱ pa mi cotꞌa habʉ maꞌna xmá nsunda, bi xøgue desde maña̱ asta rí gaꞌti. ");
INSERT INTO oteNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nepʉ ra Jesu bi ña̱ ntsꞌɛdi ne bi ꞌñena: ―Ma Dadaꞌi, nubyá dí ɛntꞌaꞌi ma te ja ri ꞌyɛ. Ne mi uadi bi ma̱nga njabʉ, ꞌbestho bi du. ");
INSERT INTO oteNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ha nu mi hyanda njabʉ ra nda̱ gá soldado bi xøcambeni Ajua̱ ne bi ꞌñena: ―Xi majua̱ni nuna ꞌñøhøni hinte ma tsꞌoqui mi tu. ");
INSERT INTO oteNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gatho núꞌʉ ya ja̱ꞌi mi ꞌbʉhni de mi uadi mi hyanda gatho núꞌa̱ xqui nja, bi ma de guehni co ndunthi ra dumʉi. ");
INSERT INTO oteNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pe gatho núꞌʉ ya ja̱ꞌi myá mpa̱di ra Jesu, ne ꞌraya ꞌbɛhña̱ xqui dɛni desde Galilea, bi gohi zi yabʉtho mi handa gatho núꞌa̱ bi nja. ");
INSERT INTO oteNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mi ꞌbʉ ꞌnara ꞌñøhø xi mrá hoja̱ꞌi mrá thuhu ra Jose, mrá mengu de ra hnini Arimatea de ra hai Judea. Nuꞌá̱ mrá nda̱ nehe de ra hmuntsꞌa nda̱ gá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Pe nuꞌá̱ mi tøꞌmi da hyandua rá hmanda Ajua̱, hangue nuꞌá̱ himbi ne bi mfaxui yá minda̱ui ngu núꞌa̱ xqui ncohiꞌʉ ja yá hmuntsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hangue nuꞌá̱ bi ma bá cꞌa̱ꞌtsa ra Pilato pa bá apabi ra nsɛqui da ꞌyacua rá ndoꞌyo ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nepʉ bi ca̱ꞌma ja ra pontꞌi, bi mantꞌa co ꞌnara hoga dutu, ne bá pɛgui ja ꞌnara ꞌraꞌyo ntꞌagui núꞌa̱ xqui thoca ja ꞌnara medo, y ja núꞌa̱ ra ntꞌaguiꞌa̱ hinxqui ntꞌaguini ni ꞌnara ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Y nura paꞌa̱ go mrá pa dega nthoqui, ne ya mi ma da mʉdi ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ha nuya ꞌbɛhña̱ núꞌʉ xqui dɛna ra Jesu desde Galilea bi ma pa bá handa habʉ xqui tꞌagui ra Jesu ne hanja xqui ꞌbɛcuabi rá ndoꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ha nu mi menga ja yá nguꞌʉ, bi hyoca ꞌraya hoga ñʉni ne ꞌraya njotsꞌi. Y bi ntsayaꞌʉ núꞌa̱ nsabdo ngu mi ma̱nga ra ley. ");
INSERT INTO oteNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ra mʉdi pa de ra semana núꞌa̱ ndomingo mi xudi xi ꞌnitho núꞌʉ ya ꞌbɛhña̱ bi ma pa ja ra ntꞌagui ne bi hña̱xa núꞌa̱ ra hoga ñʉni xqui hyoquiꞌʉ, ne bi mɛui maꞌra yá miꞌbɛhña̱ui. ");
INSERT INTO oteNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y nu mi zøniꞌʉ bi zʉdi xqui tꞌentꞌa núꞌa̱ ra do xqui jothma̱ ra ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ne bi yʉtꞌi ja ra ntꞌaguiꞌʉ pe himbi zʉtuani rá ndoꞌyo ra zi Hmu Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ne nuꞌʉ́ xi bi du yá mʉi ne himi pa̱ te da ꞌyøtꞌʉ, ne mi da̱mfriꞌʉ bi hyandi mi ꞌbahni yoho ya ꞌñøhø xqui hñe tꞌaxi asta mri huɛxqui. ");
INSERT INTO oteNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pe nuꞌʉ́ co ra ntsu bi ñeꞌmitho, himbi gʉxa yá da. Ha núꞌʉ ya ꞌñøhø bi ꞌñembabiꞌʉ: ―¿Hanja e guí hoñhʉua ja ya ntꞌagui núꞌa̱ te? ");
INSERT INTO oteNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hinjoꞌoua, ya xa yopa nte. Beñhʉ núꞌa̱ bi xiꞌahʉ núꞌbʉ nguí ꞌbʉhʉ Galilea. ");
INSERT INTO oteNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Bi ꞌñeñꞌahʉ gue Núꞌa̱ Toꞌo e bi Nja̱ꞌi mi pɛꞌtsi da tꞌɛntꞌua ja yá ꞌyɛ ya tsꞌoja̱ꞌi núꞌʉ toꞌo mi ma da pontꞌiꞌa̱, pe rá hñupa mi ma da yopa nteꞌa̱ de ra du. ");
INSERT INTO oteNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hangue nuꞌʉ́ bi beni ꞌbestho de núꞌʉ ya noya xqui xipa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ha nu mi mencꞌʉ de ja ra ntꞌagui bi ma bá xipa gatho núꞌʉ ꞌrɛtꞌamaꞌra ya apostol ne gatho maꞌra núꞌʉ toꞌo mri dɛnhma̱ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Núꞌʉ toꞌo bi hña̱ꞌtsua ra noya ya apostol go ra Maria Magdalena ne ra Juana ne ra Maria rá na̱na̱ ra Cobo, ne núꞌʉ maꞌra ya ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pe nuyá apostol ra Jesu himbi gamfriꞌʉ, ne bi ꞌñembabi núꞌʉ ya ꞌbɛhña̱ gue xqui ꞌbɛ yá mfeni. ");
INSERT INTO oteNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pe ra Pedro bi nestꞌihi bá cꞌa̱ꞌtsa ra ntꞌagui, y nu mi zøniꞌa̱ bi ndoqui bi hyanda mbo ra ntꞌagui gue hønsɛ núꞌa̱ ra dutu xqui ꞌbantꞌa ra Jesu mi ꞌbønga ꞌna lado. Y nuꞌá̱ bi menga habʉ mi ꞌbʉi, ne himi pa̱di te da beni de núꞌa̱ xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Guetꞌa̱ ra paꞌa̱ yoho yá nxadi ra Jesu mri ne ra ꞌñu mri ma pa ja ra hnini Emaú, mi pɛꞌtsa ngu ꞌrɛtꞌamaꞌra kilometro rá ñabʉ de Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","De mri ne ra ꞌñu mi mpetue de gatho núꞌa̱ xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ha de tsꞌa mri mpetue de núꞌa̱ xqui nja, ra Jesu bi zʉdiꞌʉ ne bi ncompaui má ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ne masque mri ꞌñouiꞌʉ pe himbi za bi ba̱diꞌʉ ua go mi gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ha ra Jesu bi ꞌyambabiꞌʉ ne bi ꞌñembi: ―¿Te rá ꞌbɛ guí ꞌyo má ꞌñu guí ma̱ñhʉ? ¿Hanja guí tu ri mʉihʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ꞌNa de gueꞌʉ mrá thuhu ra Cleofa bi da̱di ne bi ꞌñembabi: ―Gatho ya ja̱ꞌi pa̱di núꞌa̱ bi nja nuni Jerusale de nuya pabya. ¿Hanja hinte xcá pa̱digue? ");
INSERT INTO oteNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nepʉ ra Jesu bi ꞌñembabi: ―¿Te ꞌbɛꞌa̱ xa nja? Y nuꞌʉ́ bi ꞌñembabi: ―Ha hinxcá ꞌyøde de ra Jesu me Nasare, gueꞌa̱ mi ꞌnará ꞌmɛhni Ajua̱, ne mi ha̱npa rá tsꞌɛdiꞌa̱ pa mi ña̱ ne pa mi øtꞌa ya da̱nga tꞌøtꞌe ja yá thandi ya ja̱ꞌi ne Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ha nuya nda̱ gá macja̱ ne núꞌʉ ma nda̱hʉ de ma hninihʉ bi gʉ ne bi ꞌyɛntꞌua ja yá ꞌyɛ ra Pilato pa bi manda da thoꞌa̱ ja ꞌnara pontꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuje ndí beñhe ne ndí tøꞌmhe gue go gueꞌa̱ mi ma da ña̱njʉ nújʉ dyá me Israelhʉ, pe xi núbya ya pɛꞌtsa hñu pa xa du. ");
INSERT INTO oteNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ha ꞌraya ꞌbɛhña̱ de guecje bi ma maxudi xi ꞌnitho ja ra ntꞌagui pa bá cꞌa̱ꞌtsi, nepʉ picaguihe ena gue ya himi ꞌbɛni rá ndoꞌyo ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ne ena gue xqui hyanda ꞌraya ɛnxɛ núꞌʉ bi xipi gue ya xqui yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ne de gueꞌa̱ bi ma ꞌrama compahe pa bá cꞌa̱ꞌtsa ra ntꞌagui y eñꞌʉ gue bi zʉdi ngu núꞌa̱ xqui ma̱nga ya ꞌbɛhña̱, ne eñꞌʉ nehe gue nixi gueꞌʉ himbi hyanda ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nepʉ ra Jesu bi ꞌñembabiꞌʉ: ―¿Hanja hinxcá beñhʉ núꞌa̱ xcá hñeꞌthʉ ja ra Ma̱ca Tꞌofo, ne hanja hinxcá camfrihʉ núꞌa̱ bi ma̱nga yá ꞌmɛhni Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ha gue hingue mi mahyoni da thogui njabʉ ra Cristo núꞌa̱ xuá mɛhna Ajua̱ pa da nda̱, nepʉ da yopa menga mahetsꞌi pa da tꞌumba rá hudi dega nsu? ");
INSERT INTO oteNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nepʉ nuꞌá̱ bi mʉdi bi xipabiꞌʉ núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo habʉ ma̱ de ra Cristo núꞌa̱ rá ꞌmɛhni Ajua̱ pa da nda̱, desde ra mʉdi tꞌofo de ra Moise ne gatho núꞌa̱ bi ma̱nga maꞌra yá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ha nu mi zøni núꞌa̱ ra hnini habʉ mri maꞌʉ, ra Jesu bi ꞌyøtꞌe ngu mi ma da thoguitho. ");
INSERT INTO oteNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nepʉ nuꞌʉ́ bi za̱mi da ꞌñoxi con gueꞌʉ ne bi ꞌñembabi: ―Cohi con guecje, ngueꞌa̱ ya bi nde ne ya ma da nxuui. Ha nura Jesu bi yʉtꞌi ja yá nguꞌʉ pa da gohi con gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ne nuꞌʉ́ bi hñudi ja ra mexa pa da ntꞌoxi. Nepʉ ra Jesu bi gʉ ra thuhme ne bi ja̱pabi, ne bi heque pa bi umbabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Núꞌa̱ ra oraꞌa̱ bi ba̱diꞌʉ gue go mi gueꞌa̱ ra Jesu, pe nuꞌá̱ ꞌbestho bi ꞌmɛditho de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne mri ꞌñémbabiꞌʉ: ―¡Ne xi majua̱ni ndí tsahʉ ꞌnara johya ja ma corasohʉ núꞌbʉ mi xicaguihʉ má ꞌñu de ra Ma̱ca Tꞌofo! ");
INSERT INTO oteNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nepʉ nuꞌʉ́ ꞌbestho bi gʉ yá ꞌñu bi menga pa Jerusale. Ne ja bi zʉdini núꞌʉ ꞌrɛtꞌamaꞌra ya apostol xqui muntsꞌi ne maꞌra ya nxadi. ");
INSERT INTO oteNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ne bi tꞌembabi núꞌʉ yoho: ―Xi majua̱ni xa yopa nte ma zi Hmuhʉ, ngueꞌa̱ ra Simu bi hyandi, ne xa xicaguihe. ");
INSERT INTO oteNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nepʉ núꞌʉ yoho bi metuabi núꞌa̱ xqui nja ja ra ꞌñu, ne hanja bi ba̱diꞌʉ ra Jesu nura ora mi hyeca ra thuhme. ");
INSERT INTO oteNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tsꞌa mi ña̱tho de núꞌa̱ xqui hyandiꞌʉ ne núꞌa̱ xqui nja, mi da̱mfriꞌʉ ra Jesu mi ꞌbahni madetho de gueꞌʉ, ne bi ꞌñembabi: ―ꞌBʉhʉ te rá ꞌñentho. ");
INSERT INTO oteNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pe nuꞌʉ́ xi bi ntsu, ne mi hu yá mʉi gue mi handa ꞌnara thedi. ");
INSERT INTO oteNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pe ra Jesu bi ꞌñembabi: ―¿Hanja guí tsuhʉ? ¿Pa te guí beñhʉ ja ri mfenihʉ njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hyandga ma ꞌyɛhʉ ne ma ua, go guecagui drá Jesu. Thangaguihʉ ne hyandgahʉ xá hño, ngueꞌa̱ ꞌnara nda̱hi hingui pɛꞌtsa ra ngø nixi ra ndoꞌyo ngu guí hanthʉ dí pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y nu mi uadi bi ma̱nga njabʉ, bi ꞌñutuabiꞌʉ yá ꞌyɛ ne yá ua. ");
INSERT INTO oteNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pe nuꞌʉ́ himi tsa da gamfri ngueꞌa̱ ngu xqui mpumfriꞌʉ co ra johya, ne himi pa̱di te da beniꞌʉ. Nuꞌbʉ́ nuꞌá̱ bi ꞌñembabiꞌʉ: ―¿Ha gue ja te ga tsihʉ? ");
INSERT INTO oteNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nepʉ nuꞌʉ́ bi umba ꞌna xɛni ra hua̱ xqui hña̱xi, ne ꞌna xɛni ra tꞌafi dega colmena. ");
INSERT INTO oteNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Y nuꞌá̱ bi hña̱ni ne bi zi de ja yá thandiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nepʉ bi ꞌñembabiꞌʉ: ―Ya stá thogui núꞌa̱ dá xiꞌahʉ núꞌbʉ ndí ꞌbʉi con gueꞌahʉ, ngueꞌa̱ mi mahyoni da njabʉ gatho núꞌa̱ xa ntꞌofo ja rá ley ra Moise, ne núꞌa̱ bi ma̱nga maꞌra yá ꞌmɛhni Ajua̱, ne núꞌa̱ ma̱nga ja ya Salmo. ");
INSERT INTO oteNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nepʉ nuꞌá̱ bi xipabiꞌʉ núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo pa bi za bi zo yá mfeni, ");
INSERT INTO oteNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ne bi ꞌñembabi: ―Njaua xa ntꞌofo gue ra Cristo núꞌa̱ xuá mɛhna Ajua̱ pa da nda̱, mi mahyoni da du, ne rá hñupa mi mahyoni da yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Y nehe ena gue co rá tsꞌɛdi de rá thuhuꞌa̱ ma da hma̱ de gueꞌa̱ gatho rá ngʉni ra ximhai, da mʉdi de guecua Jerusale da tsꞌofo ya ja̱ꞌi gue da ñobri pa dra pumba yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Y nuꞌahʉbya, ma gui damajua̱nihʉ de nuya ya tꞌøtꞌe xcá hyanthʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Y nugui ma ga pɛhnꞌaꞌihʉ ra Ma̱ca Nda̱hi núꞌa̱ xa ña̱ꞌtꞌahʉ ma Dada. Pe ja da cohʉua ja ra hnini Jerusale asta hingui hña̱ñhʉ núꞌa̱ ra tsꞌɛdiꞌa̱ ma dua ehe de mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nepʉ ra Jesu bi zixa gatho yá apostol bi bøni de ra hnini Jerusale pa rí maꞌʉ ja ꞌnara zi tꞌʉca hnini rá thuhu Betania, y nuꞌá̱ ja bá jʉxni yá ꞌyɛ pa bi ja̱pabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y nu mi uadi bi ja̱pabiꞌʉ, nuꞌá̱ bi ꞌuegue de gueꞌʉ, bi tsꞌitsꞌi pa mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Y nuꞌʉ́ ꞌmɛfa de xqui xøcambeni ra zi Hmu Jesu, bi menguiꞌʉ pa Jerusale co ndunthi ra johya. ");
INSERT INTO oteNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","De guehni nza̱ntho mi ꞌbʉi ja ra nda̱nija̱ mri xøcambeni Ajua̱. Njabʉ gueꞌa̱.");
INSERT INTO oteNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ante da nja mahetsꞌi ne ra ximhai, núꞌa̱ toꞌo go ra Noya ya mi ꞌbʉi, y nuꞌá̱ mi ꞌbʉhui Ajua̱, ne nuꞌá̱ go guesɛꞌa̱ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Rá mʉdi mi othotho gatho núꞌa̱ te ja, pe núꞌa̱ toꞌo go ra Noya ya mi ꞌbʉhui Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y Ajua̱ bi ꞌyɛntꞌua ja rá ꞌyɛꞌa̱ pa go bi hyoca te gatho ja; y nuꞌbʉ núꞌá̱ hinte xa hyoqui, nuꞌbʉ́ hinte di jahma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ne go gueꞌa̱ toꞌo ri unga ra te pa nza̱ntho, ne go gueꞌa̱ ra ñotꞌi núꞌa̱ ri yoꞌtua yá mfeni ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ha nura ñotꞌiꞌa̱, ri yotꞌa ja ra ꞌbɛxuui, ne nura ꞌbɛxuui hinxa za xa nta̱te. ");
INSERT INTO oteNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mi ꞌbʉi ꞌnara ꞌñøhø mrá thuhu ra Xuua bá pɛhna Ajua̱ pa da zofo ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ne nuꞌá̱ bá ꞌbɛhni pa da damajua̱ni de núꞌa̱ ra ñotꞌi, pa da gamfrihma̱ gatho ya ja̱ꞌi ngueꞌa̱ go mri damajua̱niꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ra Xuua hingo mi gueꞌa̱ ra ñotꞌi, hønsɛ bá ꞌbɛhni pa da damajua̱ni de ra ñotꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Núꞌa̱ toꞌo go ra ñotꞌi xi majua̱ni, bá ehe de guecua ja ra ximhai ne go gueꞌa̱ ri yoꞌtua yá mfeni gatho ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Núꞌa̱ toꞌo bi hyoca ra ximhai, ja bi ꞌñe bi ꞌmʉcua ja ra ximhai, pe nuya ja̱ꞌi himbi ba̱di ua go mi gueꞌa̱ toꞌo bi hyoca ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bá ehma̱ de guecua ja rá ximhaiꞌa̱, pe nuya mengu rá hai himbi numansuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pe nuꞌʉ tóꞌo bi numansu ne bi gamfribi rá thuhuꞌa̱, nuꞌá̱ bi umbabi ra tsꞌɛdi pa bi mba̱tsi de Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ha núꞌʉ toꞌo gatho xa gamfriꞌa̱, ya xa yopa ꞌmʉi maꞌraꞌyo, hingue dega ji, nixi dega ngø, nixi de rá paha ꞌnara ꞌñøhø, hønsɛ Ajua̱ go gueꞌa̱ xa ꞌyøtꞌe pa xa yopa ꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Núꞌa̱ toꞌo ra Noya bá e bi nja̱ꞌi, ne bi ꞌmʉi con guecjʉ, ne xi mrá hoja̱ꞌi, ne nza̱ntho mi ma̱nga núꞌa̱ majua̱ni. Ne dá handuahe rá nsundaꞌa̱, go gueꞌa̱ rá nsunda Ajua̱ ra Dada núꞌa̱ pɛꞌtsa rá ꞌra Tꞌʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hangue nura Xuua bi damajua̱ni de gueꞌa̱ ne bi ña̱ ntsꞌɛdi bi ꞌñena: ―Go gueꞌa̱ núꞌa̱ ndí xiꞌahʉ, gue ꞌmɛfa de gueque mi ma da ꞌñehe maꞌna, núꞌa̱ maꞌna ja rá nsu, ngueꞌa̱ núꞌá̱ ya go mi ꞌbʉi rá mʉdi de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gathoguihʉ stá ha̱ñhʉ de yá hñoꞌa̱, ne hinhyaꞌmʉ ri ꞌbɛtcahʉ rá hñoja̱ꞌiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ha nu Ajua̱ xqui hñuxa ra Moise pa go bi ꞌñutcahʉ tengu rá leyꞌa̱, pe nubyá bá pɛhna ra Jesucristo pa bá ha̱ncahʉ rá hñoja̱ꞌi, ne núꞌá̱ go gueꞌa̱ bi ꞌñudi gatho maxøgue núꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hinhyaꞌmʉ to xa hyanda Ajua̱ ra Dada, pe nurá hma̱ca ꞌra Tꞌʉꞌa̱ bi ꞌñutcahʉ tengu rá ꞌmʉiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ha nuya nda̱ gá xodyo mi ꞌbʉhni Jerusale bi mɛhna ꞌraya macja̱ ne ꞌrayá mfatsꞌiꞌʉ núꞌʉ mi tꞌembi ya levita, pa da cꞌa̱ꞌtsa ra Xuua pa da ꞌyambabi ua go mi gueꞌa̱ ra Cristo núꞌa̱ mi ma da mɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ha nura Xuua bi ma̱nga núꞌa̱ majua̱ni, himbi ncøni ne bi ꞌñena: ―Hina, hingo guecagui drá Cristo. ");
INSERT INTO oteNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nepʉ nuꞌʉ́ bi ꞌñembabi: ―Nuꞌbʉ́ ¿toꞌoꞌi? ¿Ha gue go gueꞌe grá ba̱di Elía? Nuꞌbʉ́ ra Xuua bi ꞌñena: ―Hina, hingo guecagui. Ha nuꞌʉ́ bi yopa ꞌñembabi maꞌnaꞌqui: ―¿Ha gue go gueꞌe rá da̱nga ꞌmɛhniꞌi Ajua̱ núꞌa̱ ma da ꞌñehe? Ha nuꞌá̱ bi da̱di ne bi ꞌñena: ―Hina. ");
INSERT INTO oteNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ha nuꞌʉ́ bi ꞌñembabi: ―Nuꞌbʉ́ ¿toꞌoꞌi ne te ri ꞌbɛfigue? Xi da xicje pa ma ga xiphe nehe núꞌʉ toꞌo bá pɛncahe. ");
INSERT INTO oteNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ha nura Xuua bi ꞌñembabiꞌʉ: ―Nuga, hønsɛ ꞌnadrá ꞌmɛhni pa ga ma̱nga ja ra mbonthi núꞌʉ ya noya bi ma̱nga ra ba̱di Isaía ne bi ꞌñena: “Jua̱ñhʉ rá ꞌñu ra Zidada.” Hangue dí xiꞌahʉ, ntsøꞌmhʉ, ngueꞌa̱ ya xa ꞌñepʉ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ha nuya ja̱ꞌi xqui ꞌbɛhni myá fariseoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hangue nuꞌʉ́ bi ꞌyambabi ra Xuua ne bi ꞌñembabi: ―ꞌBʉ hingo gueꞌe grá Cristo, nixi grá ba̱di Elía, nixi rá da̱nga ꞌmɛhniꞌi Ajua̱ núꞌa̱ ma da ꞌñehe, nuꞌbʉ́ ¿hanja guí xiꞌtsate? ");
INSERT INTO oteNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ha nura Xuua bi da̱di ne bi ꞌñena: ―Nuga bá ꞌbɛncagui pa ga xiꞌtsꞌaꞌihʉ co ra dehe. Pe ꞌbʉi ꞌna con gueꞌahʉ núꞌa̱ nixi guí pa̱tua rá ꞌbɛfi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Go gueꞌa̱ bra ꞌbɛfa de gueque, ne maꞌna ra da̱ngui rá nsu de gueque, nixi dí ꞌñepqui ngugui ga xoꞌtua rá ntha̱sthi de yá thizaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Njabʉ bi ma̱nga ra Xuua nuni riꞌnandi de ja ra da̱the Jordá ja ra hai Betabara habʉ mi xiꞌtsateꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nurá hyaxꞌa̱ ra Xuua bi hyanda ra Jesu mbra e da zʉdi ne bi ꞌñembabi ya ja̱ꞌi: ―Ndi, hyanthʉ núni bá pɛhna Ajua̱, nja ngu ꞌnara zi tꞌʉca dɛti núꞌʉ tho dega hña̱ꞌti, y go guehni puꞌtua yá tsꞌoqui ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ne go guehni ndí xiꞌahʉ mi ma da ꞌñehe ꞌmɛfa de gueque ne maꞌna ra da̱ngui rá nsu, ngueꞌa̱ ya go mi ꞌbʉini rá mʉdi de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nuga hindí pa̱tuahma̱ tengu rá ꞌbɛfini, pe bá ꞌbɛncagui ga xiꞌtsꞌaꞌihʉ co ra dehe pa njabʉ gathoꞌihʉ gyá me Israelhʉ da za gui pa̱hʉ gue go guehni ra Cristo xpá mɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nehe ra Xuua bi ma̱ de núꞌa̱ te xqui nja ne bi ꞌñena: ―Nuga dá handa ra Ma̱ca Nda̱hi bá ca̱i de mahetsꞌi ngu ꞌnara zi domitsu, e bi zʉdini. ");
INSERT INTO oteNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nuga hindí pa̱tuahma̱ tengu rá ꞌbɛfini, pe núꞌa̱ toꞌo bá pɛncagui ga xiꞌtsꞌaꞌihʉ co ra dehe go gueꞌa̱ bi ꞌñengagui: “Ma gui hyanda ra Ma̱ca Nda̱hi dua ca̱i de mahetsꞌi, e da zʉdi ꞌnara zi ꞌñøhø pa da ꞌmʉhui, y nuꞌá̱ go gueꞌa̱ ma da xiꞌtsꞌahʉ dega Ma̱ca Nda̱hi.” ");
INSERT INTO oteNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nuga stá handi hangue drí damajua̱ni gue go guehni rá Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ha nurá hyaxꞌa̱ ra Xuua mi ꞌbahni maꞌnaꞌqui co yoho yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nepʉ bi hyanda ra Jesu mi ꞌyoni ne bi ꞌñena: ―Ndi, hyanthʉ núni bá pɛhna Ajua̱, nja ngu ꞌnara zi tꞌʉca dɛti núꞌʉ tho dega hña̱ꞌti. ");
INSERT INTO oteNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ha núꞌʉ yoho yá nxadi ra Xuua mi ꞌyøde njabʉ, ꞌbestho bi dɛniꞌʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nepʉ nura Jesu bi mpʉntsꞌi ne bi hyandi mri dɛniꞌʉ ne bi ꞌñembabi: ―¿Te ꞌbɛ grí ꞌñehʉ? Ha nuꞌʉ́ bi ꞌyambabi ne bi ꞌñembi: ―Xahnate, ¿habʉ guí ꞌbʉigue? ");
INSERT INTO oteNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nuꞌbʉ́ nuꞌá̱ bi ꞌñembabi: ―Maha pa gui pa̱hʉ habʉ dí ꞌbʉi. Y bi mɛuiꞌʉ pa bi ba̱di habʉ mbi ꞌbʉiꞌa̱. Bi zøni ngu nzʉnga ꞌrɛtꞌa ne bi ꞌmʉhuini gatho ra pa. ");
INSERT INTO oteNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ha núꞌʉ yoho ya nxadi xqui ꞌyøde núꞌa̱ bi ma̱nga ra Xuua ne xqui dɛna ra Jesu, ꞌna de gueꞌʉ mrá thuhu ra Andre ne mrá cu ra Simu Pedro. ");
INSERT INTO oteNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Núꞌa̱ ra Andreꞌa̱ bi ma bá da̱ma cꞌa̱ꞌtsa ra Simu Pedro ne bi ꞌñembabi: ―Stá hanthe ne stá pa̱he ra Cristo núꞌa̱ xpá mɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nepʉ bi zitsꞌiꞌa̱ pa habʉ mbi ꞌbʉ ra Jesu. Ha nura Jesu mi hyanda ra Simu bi ꞌñembabiꞌa̱: ―Nuꞌi grá Simu rá tꞌʉꞌi ra Joná. Nubyá go dí hupꞌaꞌi grá Pedro. ―Núꞌa̱ ra thuhuꞌa̱ rí bøni da ꞌñena ꞌnara do. ");
INSERT INTO oteNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ha nurá hyaxꞌa̱ ra Jesu mi beni da ma pa Galilea, pe ꞌmɛtꞌo bi ma bá cꞌa̱ꞌtsa ra Lipe ne bi ꞌñembabi: ―Bá ehe tɛngagui pa ma nxadiꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ha nura Lipe mrá me Betsaida habʉ mrá mengu ra Andre ne ra Pedro. ");
INSERT INTO oteNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nepʉ nura Lipe bi ma bá cꞌa̱ꞌtsa ra Natanael ne bi ꞌñembabi: ―Stá hanthe ne stá pa̱hebya ra Cristo núꞌa̱ mi ma da mɛhna Ajua̱ pa da nda̱ ngu bi ꞌyofo ra Moise ja ra ley ne ngu bi ꞌyofo maꞌra yá ꞌmɛhni Ajua̱ mayaꞌbʉ, ne go gueꞌa̱ ra Jesu rá tꞌʉ ra Jose ra me Nasare. ");
INSERT INTO oteNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ha nura Natanael bi ꞌñembabi: ―Pøde hinda za da bønga ꞌna xi di ja rá nsu nuni Nasare. Nuꞌbʉ́ ra Lipe bi ꞌñembabi: ―Maha pa gui hyandi ꞌbʉ hingui camfri. ");
INSERT INTO oteNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ha nura Jesu mi hyanda ra Natanael bra e da zʉdi bi ꞌñena: ―Ndi, hyanthʉ go guehni ꞌnara me Israel, nuni xi majua̱ni camfri Ajua̱, y hingrá hyate. ");
INSERT INTO oteNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nuꞌbʉ́ nura Natanael bi ꞌñembabi ra Jesu: ―¿Hanja guí pa̱cagui? Ha nura Jesu bi ꞌñembabiꞌa̱: ―Himi xiꞌatho ra Lipe pa e gui cꞌa̱scagui, dá hantꞌaꞌi nguí ꞌbai ja rá ua ꞌnara ꞌbai gá igo. ");
INSERT INTO oteNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nuꞌbʉ́ ra Natanael bi da̱di ne bi ꞌñembabi: ―Xahnate, nuꞌi go gueꞌe xi majua̱ni rá Tꞌʉꞌi Ajua̱, ne go gueꞌe grá Nda̱ de ya me Israel. ");
INSERT INTO oteNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nepʉ nura Jesu bi da̱di ne bi ꞌñembabi: ―¿Ha gue guí camfrigui hønsɛ ngueꞌa̱ dá xiꞌaꞌi gue dá hantꞌaꞌi ja rá ua ra igo? Ma gui hyanda maꞌra ya tꞌøtꞌe maꞌna dya da̱ngui de núꞌa̱ dá xiꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ gue ma gui hyanthʉ da xogui mahetsꞌi, ne gui hyanduahʉ yá ɛnxɛ Ajua̱ di pøtsꞌe ne di ca̱i nuua habʉ di ꞌbʉi Núꞌa̱ Toꞌo e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rá datꞌma̱ni bi nja ꞌnara ntha̱ti nuni ja ra hnini Ncaná de ra hai Galilea, ne xqui zøni de guehni rá na̱na̱ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nehe ra Jesu bi zøni de guehni co yá nxadi ngueꞌa̱ bi tsꞌohna ja ra ntha̱ti. ");
INSERT INTO oteNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ne de mi ꞌbʉhniꞌa̱, bi thegue ra vinu, ha nurá na̱na̱ ra Jesu bi ꞌñembabiꞌa̱: ―Ya bi thegue ra vinu. ");
INSERT INTO oteNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ha nura Jesu bi ꞌñembabi rá na̱na̱: ―¿Pa te go guí xicagui? Gue nuga ri ꞌbɛta ma ora pa da hneca ma tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nepʉ nurá na̱na̱ꞌa̱ bi ꞌñembabi núꞌʉ to mi faste ja ra ngo: ―ꞌYøthʉ gatho núꞌa̱ da xiꞌahʉni. ");
INSERT INTO oteNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ne mi tihni ꞌrato ya da̱nga mpothe dega do xqui tꞌehni pa mi øtꞌa ra ntꞌaxqui ya xodyo ngu myá nza̱iꞌʉ. Ne cada ꞌna de núꞌʉ ya mpothe mri ꞌñɛnga yoho o hñu xøni ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nepʉ nura Jesu bi ꞌñembabi núꞌʉ toꞌo mi ꞌyoni mi faste: ―Ñuꞌtshʉ ra dehe nuya ya mpothe. Ha nuꞌʉ́ bi xitꞌa ra dehe asta habʉ bi ñutsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nepʉ ra Jesu bi ꞌñembabiꞌʉ: ―Nubyá, ꞌyaꞌtshʉ tsꞌʉ ne hña̱ꞌtsuahʉ ra nda̱ de nuna ra ngo. Nuꞌbʉ́ nuꞌʉ́ bi ꞌyøtꞌa ngu núꞌa̱ bi sipabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ha núꞌa̱ ra nda̱ de ra ngo bi zamacʉhi núꞌa̱ ra dehe xqui tꞌøtꞌe da mvinu, y nuꞌá̱ himi pa̱di habʉ xqui ꞌñehe núꞌa̱ ra vinu, hønsɛ núꞌʉ ya maste xqui ꞌyaꞌtsa ra dehe, go gueꞌʉ mi pa̱di. Hangue nura nda̱ de ra ngo bi zohna núꞌa̱ ra na̱vio mi øtꞌango, ");
INSERT INTO oteNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne bi ꞌñembabi: ―Nza̱ntho núꞌʉ toꞌo øtꞌango, ꞌmɛtꞌo ri unga núꞌa̱ ra vinu xá cʉhi, nepʉ de ya sta niña̱ co ra vinu núꞌʉ toꞌo xa tsꞌohni, ja da tꞌumba núꞌa̱ hingui cʉhi. Pe nuꞌi, xcá pɛꞌtsta ra hoga vinu ne hinxcá untho asta núbya ja gá uni. ");
INSERT INTO oteNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ra Jesu bi ꞌyøtꞌa núꞌa̱ rá mʉdi ra da̱nga ntꞌudi nuni Ncaná de Galilea. Ne njabʉ bi ꞌyøtꞌe pa bi hnequi rá nsunda, ne yá nxadi maꞌna bi gamfri gue go gueꞌa̱ xpá mɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nepʉ nura Jesu bi ma pa Ncapernau, ne bi mɛui rá na̱na̱ ne yá cu ne yá nxadi, ne ja bá ꞌbʉhniꞌʉ ꞌraya pa. ");
INSERT INTO oteNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nepʉ de guehni ra Jesu bi ma pa Jerusale ngueꞌa̱ mi ma da datꞌa ra pa de ra pascua ꞌnará ngo de ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne bi hyanda ꞌraya ma mi ꞌbʉhni ja ra patio de ra nda̱nija̱, ꞌra mi pa ya nda̱mfri, ꞌra mi pa ya dɛti, ha nu maꞌra mi pa ya domitsu; ne mi huhni ꞌra toꞌo mi pata ya boja̱. ");
INSERT INTO oteNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hangue nura Jesu bi metꞌa ꞌnara ntha̱hi pa bi ꞌyɛni co ya mfɛi nuya mboꞌoni de mbo ra nda̱nija̱ mahyɛgui co ya ma, nehe bi xamba yá boja̱ núꞌʉ toꞌo mi pata ya boja̱, ne bi pʉntsꞌua yá mexa, ");
INSERT INTO oteNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ne bi ꞌñembabi núꞌʉ toꞌo mi pa ya domitsu: ―¡Jʉcjʉ pa thi ri domitsuhʉ, oja guí huxhʉua ri ꞌmahʉ mbo rá ngu ma Dada! ");
INSERT INTO oteNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ha nuyá nxadi bi beni gue njabʉ xqui tꞌofo ja ra Ma̱ca Tꞌofo habʉ ena: “Xi dí te ma vida pa ga supꞌaꞌi ri ngu.” Ne nuyá nxadi bi zo yá mfeni gue núꞌʉ ya noya mi ma̱ de ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ha nuya nda̱ gá xodyo bi ꞌñembabi ra Jesu: ―¿Te ma da̱nga ntꞌudi da za gui ꞌñutcahe pa ga pa̱he to rá nsɛquiꞌa̱ pa guí øtꞌa njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―ꞌBʉ gui yøꞌthʉ nuna ra nija̱, nuga co hñupa ga yopa ꞌbaꞌma maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nuꞌbʉ́ nuꞌʉ́ bi ꞌñena: ―Ñotemaꞌrato njɛya pa bri ꞌbaꞌma nuna nija̱na̱, ¿nepʉ nuꞌi guí ena gue co hñupa ma gui yopa ꞌbaꞌma maꞌnaꞌqui? ");
INSERT INTO oteNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pe núꞌa̱ ra nija̱ mi ma̱nga ra Jesu, mi ma̱ de rá ndoꞌyo sɛhɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ha nu de mi nanga ra Jesu de ra du, nuꞌbʉ́ yá nxadi bi beniꞌʉ núꞌʉ ya noya xqui ma̱ñꞌa̱. Hangue bi gamfriꞌʉ gue bi njabʉ ngu núꞌa̱ xqui tꞌofo ja ra Ma̱ca Tꞌofo, ne ngu núꞌa̱ xqui ma̱nsɛꞌa̱ gue ma da yopa nte. ");
INSERT INTO oteNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ha nu de mi ꞌbʉhni ra Jesu nuni Jerusale ja ra ngo de ra pascua, ndunthi ya ja̱ꞌi bi gamfri gue go mi gueꞌa̱ bá pɛhna Ajua̱ pa da nda̱, nguetho nuꞌʉ́ bi hyanda ya da̱nga ntꞌudi mi øtꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pe nura Jesu himi ne da ꞌñouiꞌʉ ngueꞌa̱ mi pa̱tuatho yá mfeniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne himi honiꞌa̱ toꞌo da xipabi tengu yá ꞌmʉi ya ja̱ꞌi, ngueꞌa̱ nuꞌá̱ mi pa̱tuasɛ yá mfeniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ha mi ꞌbʉ ꞌnara ꞌñøhø mrá thuhu ra Nicodemo mrá nda̱ de ra hmuntsꞌa nda̱ gá xodyo, ne mrá fariseo. ");
INSERT INTO oteNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nuꞌá̱ bi ma dega xuui pa bá cꞌa̱ꞌtsa ra Jesu ne bi ꞌñembabi: ―Xahnate, dí pa̱he gue Ajua̱ xpá mɛñꞌaꞌi pa gui xancaguihe, ne guí ꞌbʉi con gueꞌa̱, ngueꞌa̱ ꞌbʉ hingrí ꞌbʉhma̱ con gueꞌa̱ hinda za gui ꞌyøthma̱ nuya da̱nga ntꞌudi guí øtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―Xi majua̱ni dí xiꞌaꞌi, nuꞌa̱ tóꞌo hinda yopa ꞌmʉi maꞌraꞌyo hinda za da ꞌmʉ ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nuꞌbʉ́ ra Nicodemo bi ꞌñembabi: ―¿Hanja da za ꞌnara nda̱xjua ja̱ꞌi da yopa ꞌmʉi maꞌraꞌyo? ¿Ha gue da za da yopa yʉtꞌa ja rá mʉi rá na̱na̱ ne da yopa ꞌmʉi? ");
INSERT INTO oteNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―Xi majua̱ni dí xiꞌaꞌi, nuꞌa̱ tóꞌo hinda ꞌmʉi de ra dehe ne de ra Ma̱ca Nda̱hi, hinda za da yʉtꞌa ja rá hmanda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nuto gatho bi mba̱tsi dega ja̱ꞌi, gueꞌa̱ ꞌnara ja̱ꞌi, ha nuꞌa̱ tóꞌo bi yopa ꞌmʉi maꞌraꞌyo dega Ma̱ca Nda̱hi, gueꞌa̱ ꞌbʉi dega hoga nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Oguí ꞌyø ngueꞌa̱ dí xiꞌaꞌi gue mahyoni gui yopa ꞌbʉhʉ maꞌraꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nura nda̱hi ꞌyo habʉraza, ne guí øde bʉ, pe hinguí pa̱di habʉ brí ꞌñehe nixi habʉ rí ma. Njabʉ nehe ra Ma̱ca Nda̱hi núꞌa̱ ri mpɛfi ja yá mfeni nuto gatho xa ꞌmʉi maꞌraꞌyo de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nuꞌbʉ́ bi da̱di ra Nicodemo ne bi ꞌñembabi: ―¿Pe hanja da za da njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―¡Conque grá xahnate de Israel ne hinguí pa̱di nuya ya tꞌøtꞌe! ");
INSERT INTO oteNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xi majua̱ni dí xiꞌaꞌi, dí ma̱ñhe núꞌa̱ dí pa̱he, ne dí damajua̱nihe de núꞌa̱ stá hanthe, pe nuꞌahʉ́ hinguí ne gui camfrihʉ núꞌa̱ dí damajua̱nihe. ");
INSERT INTO oteNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ꞌBʉ hinguí camfrihʉ núꞌa̱ dí xiꞌahʉ de núꞌa̱ jaua ja ra ximhai, nuꞌbʉ́ ¿hanja da za gui camfrihʉ ꞌbʉ ga xiꞌahʉ ya tꞌøtꞌe de mahetsꞌi? ");
INSERT INTO oteNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni ꞌnara meximhai hinxa ma mahetsꞌi pa bá ha̱ ra noya de ya tꞌøtꞌe de guehni, hønsɛ núꞌa̱ toꞌo bá ca̱i de mahetsꞌi, go gueꞌa̱ Núꞌa̱ Toꞌo e bi Nja̱ꞌi, go gueꞌa̱ ma̱ de ya tꞌøtꞌe de mahetsꞌi ngueꞌa̱ ja ra menguni. ");
INSERT INTO oteNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y Núꞌa̱ Toꞌo e bi Nja̱ꞌi ma da tꞌøꞌtuabi ngu bi ꞌyøtꞌa ra Moise bi pøꞌtsa ra quꞌeña̱ dega bøja̱ maña̱ ja ꞌnara za nu de mi ꞌbʉi ja ra ꞌyoꞌmtha, njabʉ nehe mahyoni dra ꞌbøꞌtse maña̱ ja ꞌnara za Núꞌa̱ Toꞌo e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Pa njabʉ nuto gatho da gamfriꞌa̱ hinda ꞌmɛdi, ma da mɛꞌtsa ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ajua̱ xi bi ma̱di ntsꞌɛdi gatho ya ja̱ꞌi de ra ximhai, hangue bá pɛhna rá ꞌra Tꞌʉ, pa nuto gatho da gamfriꞌa̱ hinda ꞌmɛdi, núꞌʉ́ ma da mɛꞌtsa ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ajua̱ bá pɛhna rá Tꞌʉ pa guecua ja ra ximhai pa da pøhø ya ja̱ꞌi, hingue pa da mɛhniꞌʉ ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nuꞌa̱ tóꞌo camfriꞌa̱ hinda ꞌbɛhna ja ra nidu, pe nuꞌa̱ tóꞌo hingui camfriꞌa̱, gueꞌa̱ ya xa tꞌɛꞌmbi pa dra ꞌbɛhna ja ra nidu, ngueꞌa̱ hinxa gamfribi rá thuhu rá ꞌra Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nuꞌʉ́ ma dra ꞌbɛhna ja ra nidu ngueꞌa̱ ra ñotꞌi bi zøhø ja ra ximhai, pe nuꞌʉ́ maꞌna ri ho da ꞌmʉta ja ra ꞌbɛxuui ngueꞌa̱ hingui ho núꞌa̱ øtꞌeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nuto gatho øtꞌa ya tꞌøtꞌe hingui ho, ri ʉtsa ra ñotꞌi ne hingui cuatꞌa ja ra ñotꞌi ngueꞌa̱ tsu da hnequi yá tsꞌoꞌbɛfi. ");
INSERT INTO oteNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pe nuꞌa̱ tóꞌo øtꞌa ngu núꞌa̱ ma̱nga majua̱ni, gueꞌa̱ cuatꞌa ja ra ñotꞌi pa da hnequi gue núꞌa̱ øtꞌe, øtꞌe co rá tsꞌɛdi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nepʉ ꞌmɛfa ra Jesu bi ma pa ra hai Judea co yá nxadi, ne ja bá ꞌbʉiniꞌʉ ꞌraya pa, ne bá øtꞌa ra sistehe de guehni. ");
INSERT INTO oteNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ne nura Xuua mi øtꞌa ra sistehe nuni Enón gueta Salim, ngueꞌa̱ xi mi ja ndunthi ra dehe de guehni, ne mi pa ya ja̱ꞌi pa mri nxisteheꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ne ra Xuua hinxqui jotꞌatho ja ra fadi. ");
INSERT INTO oteNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ha nuyá nxadi ra Xuua mi ntsanoyaui ꞌrayá mixodyoui de ra sistehe pa ra ntꞌaxqui. ");
INSERT INTO oteNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nepʉ bi ma ya nxadi bá cꞌa̱ꞌtsa ra Xuua ne bi ꞌñembabi: ―Xahnate, nuꞌi gá damajua̱ni de núꞌa̱ ra ꞌñøhø gá nuui riꞌnandi ra da̱the Jordá, ha nubyá bí øtꞌa ra sistehe nehe, y gatho ya ja̱ꞌi pa ja rí mani. ");
INSERT INTO oteNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nuꞌbʉ́ ra Xuua bi da̱di ne bi ꞌñembabiꞌʉ: ―Hinda za te da mɛsɛ ꞌna ꞌbʉ Ajua̱ hingo da ꞌbɛpa ꞌna. ");
INSERT INTO oteNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nuꞌahʉ ya xcá ꞌyøhʉ stá ma̱ gue hingo guecagui drá Cristo núꞌa̱ xpá mɛhna Ajua̱ pa da nda, hønsɛ bá pɛncagui pa go ga ꞌmɛtꞌo de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nja ngu ꞌnara ꞌñøhø toꞌo ri ntha̱tui ꞌnara ꞌbɛhña̱, go gueꞌa̱ rá ꞌbɛhña̱ꞌa̱. Ne nurá amigo núꞌa̱ ra ꞌñøhø ra medintha̱ti di ꞌbahui ne øtsꞌe te ma̱, ne da johyaꞌa̱ nu stí ꞌyøtua rá noya ne sta hyandi da mɛui rá ꞌbɛhña̱. Njabʉ nehe xi drí johya ngueꞌa̱ dí øde de núꞌa̱ bí øtꞌa ra Jesu, ne ngueꞌa̱ dí øde gue ndunthi ri dɛniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngueꞌa̱ nuꞌá̱ mahyoni maꞌna go da nja rá nsuꞌa̱, ha nuga da uadi ma nsu. ");
INSERT INTO oteNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ngueꞌa̱ nuꞌá̱ xqui ꞌñehe de mahetsꞌi, hangue maꞌna ja rá nsu de gatho, pe nu ngugui drá ja̱ꞌitho de ra ximhai, hangue dí pa̱di nsøcta núꞌʉ ya tꞌøtꞌe jaua ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Y núꞌá̱ go gueꞌa̱ ma̱ de núꞌa̱ te xpá hyandi ne de núꞌa̱ te xpá ꞌyøde nuni mahetsꞌi, pe masque njabʉ, hinto camfribi núꞌa̱ ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pe nuꞌa̱ tóꞌo da gamfribi núꞌa̱ ma̱ñꞌa̱, nehe ma̱ gue Ajua̱ ma̱nga majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ngueꞌa̱ nurá Tꞌʉ Ajua̱ xpá mɛhni ma̱nga núꞌʉ ya noya bá xipabi Ajua̱, ngueꞌa̱ nuꞌá̱ xa umba maxøgue rá tsꞌɛdi ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ajua̱ ra Dada xi di ma̱di rá Tꞌʉ, hangue xa ꞌyɛntꞌua gatho ja rá ꞌyɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nuꞌa̱ tóꞌo camfri ra Tꞌʉ, go gueꞌa̱ pɛꞌtsa ra te pa nza̱ntho, pe nuꞌa̱ tóꞌo hingui ne da gamfri ra Tꞌʉ, hinhyaꞌmʉ da zʉ ra te pa nza̱ntho, hønsɛ rá cuɛ Ajua̱ ma da zʉdiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ha nura Jesu bi ba̱di gue nuya fariseo xqui ꞌyødeꞌʉ gue maꞌna mi ndunthi yá nxadiꞌa̱ ne maꞌna mi øtꞌa ra sisteheꞌa̱ que ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Masque ra Jesu hingo mi øtꞌa ra sisteheꞌa̱, pe nuyá nxadi ha̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Y nu mi ꞌyøde ra Jesu gue mi hma̱nga njabʉ, bi bøni de guehni Judea pa bi mengui Galilea. ");
INSERT INTO oteNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne mi pɛꞌtsi da ꞌranda Nsamaria. ");
INSERT INTO oteNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ne bi zønga ja ra tꞌʉca hnini Sicar de Nsamaria guetbʉ habʉ mi o rá hai ndu ra Cobo núꞌa̱ xqui zocua ndu ra Jose rá tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne ja mi jani ꞌnara poso núꞌa̱ bi gohui rá thuhu ra Cobo. Nepʉ nura Jesu ja bi ntsayani ngueꞌa̱ xqui zabi ja ra ꞌñu. Y ya mi ngu nzʉnga ꞌrato nde. ");
INSERT INTO oteNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nepʉ de guehni bi zøhø ꞌnara ꞌbɛhña̱ mrá me Nsamaria, e da ꞌyatꞌa ra dehe ja ra poso. Ha nura Jesu bi ꞌyadi ne bi ꞌñembabi: ―ꞌRaca tsꞌʉ ra zi dehe ga tsi. ");
INSERT INTO oteNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ha nuyá nxadiꞌa̱ xqui ma tai pa da dai te da ziꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Y núꞌa̱ ra ꞌbɛhña̱ me Nsamaria bi ꞌñembabi ra Jesu: ―¿Hanja guí acagui ra dehe, gue nuꞌi grá xodyo ha nuga drá me Nsamaria? (Bi ꞌñembi njabʉ ngueꞌa̱ ya xodyo himi tsa nixi da ña̱ui ya me Nsamaria.) ");
INSERT INTO oteNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembabi: ―Nuꞌbʉ gri pa̱hma̱ núꞌa̱ unga Ajua̱, ne ꞌbʉ gri pa̱hma̱ núꞌa̱ toꞌo aꞌaꞌi ra dehe, nuꞌbʉ́ go xcá ꞌyacagui, ne nuga stá ꞌraꞌaꞌi ra dehe dega te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ha nura ꞌbɛhña̱ bi ꞌñembabi: ―Ndada, hingrí hña̱ con te gui ꞌyatꞌa ra dehe, ha nura poso xá hñe. Nuꞌbʉ́, ¿habʉ ja núꞌa̱ ra dehe dega te guí engagui? ");
INSERT INTO oteNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ha gue maꞌna ja ri nsugue que ndu ma dadahʉ ra Cobo, núꞌa̱ toꞌo bi zogahe nuna poso? Y nuꞌá̱ ja mi tsitheua co yá tꞌʉ ne co yá mboꞌoni. ");
INSERT INTO oteNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nuꞌbʉ́ nura Jesu bi da̱di ne bi ꞌñembabi: ―Nuto gatho da zi nuni ra dehe da yopa zʉ ra nduthe. ");
INSERT INTO oteNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ha nuꞌa̱ tóꞌo da zi núꞌa̱ ra dehe dí ungá, hinhyaꞌmʉ da yopa zʉ ra nduthe, ngueꞌa̱ núꞌa̱ ra dehe ga umbabi, da nja ngu ꞌnara pøthe ja rá coraso, di pøhø pa da umba ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nuꞌbʉ́ nura ꞌbɛhña̱ bi ꞌñembabi: ―Ndada, ꞌraca tsꞌʉ de núꞌa̱ ra zi dehe pa hinhyaꞌmʉ da yopa zʉca ra nduthe, ne pa hinhyaꞌmʉ ga eheua maꞌnaꞌqui ga ꞌñai. ");
INSERT INTO oteNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ha ra Jesu bi ꞌñembabi: ―Gue da rí ma ua tsi ri da̱me. ");
INSERT INTO oteNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nuꞌbʉ́ núꞌa̱ ra ꞌbɛhña̱ bi da̱di ne bi ꞌñembabi: ―Joꞌo ma da̱me. Ha nura Jesu bi ꞌñembabi: ―Majua̱ni núꞌa̱ guí ma̱ gue joꞌo ri da̱me. ");
INSERT INTO oteNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pe xcá pɛꞌtsa cʉtꞌa ri da̱me ne núꞌa̱ ra ꞌñøhø guí ꞌbʉhuibya, hingo ri da̱meꞌa̱. Hangue majua̱ni núꞌa̱ guí ma̱ gue joꞌo ri da̱me. ");
INSERT INTO oteNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nuꞌbʉ́ nura ꞌbɛhña̱ bi ꞌñembabi: ―Ndada, pøde go gueꞌe ꞌnará ꞌmɛhniꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nuꞌbʉ́ te xi guí ma̱ngue de ndu ma dadahʉ bi xøcambeni Ajua̱ nuni ja ra tꞌøhøni, ha nuꞌahʉ gyá xodyohʉ guí ma̱ñhʉ gue mahyoni dra søcambeni Ajua̱ nsøctho de guehni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ha nura Jesu bi ꞌñembabi: ―Na̱ná̱, camfri núꞌa̱ dí xiꞌaꞌi, gue ma da zø ra pa gui xøcambenihʉ Ajua̱ ra Dada pe ya hinga nuni ja ra tꞌøhø, nixi de guehni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nuꞌahʉ hinguí pa̱hʉ núꞌa̱ guí xøcambenihʉ. Pe nuje ha̱, dí pa̱he núꞌa̱ dí xøcambenihe, ngueꞌa̱ ra pøhøte bá ehe de ja ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mi ma da zø ra pa y ya bi zøhø gue nuꞌʉ tóꞌo xi majua̱ni da xøcambeni Ajua̱ ra Dada, ma da xøcambeni dega jamfri ne ngu rí ꞌñehe. Ne Ajua̱ ra Dada ri ho dra søcambeniꞌa̱ njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ajua̱ go gueꞌa̱ dega Nda̱hi ne hingui hnequi, hangue nuꞌa̱ tóꞌo da xøcambeniꞌa̱, mahyoni da xøcambeni dega jamfri ne ngu rí ꞌñehe. ");
INSERT INTO oteNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nuꞌbʉ́ nura ꞌbɛhña̱ bi ꞌñembabi: ―Nuga dí pa̱di gue ma da ꞌñehe ra Mesía go ra Cristo núꞌa̱ ma da mɛhna Ajua̱ pa da nda̱. Ne nu stí zøꞌa̱ gatho go ma da xicjʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ha ra Jesu bi ꞌñembabi: ―Nuga go guecsɛ dí ña̱uibya. ");
INSERT INTO oteNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Y nura oraꞌa̱ bi zøhø yá nxadi, ne nuꞌʉ́ bi ꞌyø ngueꞌa̱ ra Jesu mi ña̱ui ꞌnara ꞌbɛhña̱. Pe nuꞌʉ́ hinte bi ꞌyambabi ra Jesu te mi ambabi nixi hanja mi ña̱uiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nuꞌbʉ́ nura ꞌbɛhña̱ bi zopʉ rá xøni ne bi menga ja ra hnini ne bi ꞌñembabi núꞌʉ mi ꞌbʉhni: ");
INSERT INTO oteNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Maha ma gui hyanthʉ núꞌa̱ toꞌo xa xictho te gatho stá øtꞌe. ¿Ha hingo di gueꞌa̱ ra Cristo ꞌbʉ, núꞌa̱ mi ma da mɛhna Ajua̱ pa da nda̱? ");
INSERT INTO oteNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nepʉ nuya ja̱ꞌiꞌʉ bá ehe pa e da cꞌa̱ꞌtsa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ha nu mi ma núꞌa̱ ra ꞌbɛhña̱, nuyá nxadi ra Jesu bi ba̱ntebi ne bi ꞌñembabi: ―Xahnate, bá e gui ñuni. ");
INSERT INTO oteNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pe nuꞌá̱ bi ꞌñembabiꞌʉ: ―Dí pɛꞌtsa ꞌnara hñuni ma ga tsi, núꞌa̱ nixi guí pa̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ne nuyá nxadi bi ꞌñémbabiꞌʉ ꞌna ngu ꞌna: ―¿Ua to xpá hña̱mpi te da zi ꞌbʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ha ra Jesu bi ꞌñembabiꞌʉ: ―Numa hñuniga gueꞌa̱ ga øꞌtuabi rá paha núꞌa̱ toꞌo bá pɛncagui ne ga pɛpa rá ꞌbɛfi asta hinga juati. ");
INSERT INTO oteNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Guí ma̱ñhʉ gue di ꞌbɛ goho nza̱na̱ pa da nja ra sofo, ¿ha ngue ha̱? Pe nuga dí xiꞌahʉ: Ndi, hyanthʉ ya ꞌbotꞌi ya xa ña̱tsꞌi pa da sofo. ");
INSERT INTO oteNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nuya xofo ha̱ni yá tha̱ha̱ ne jʉtsꞌi ꞌnara hoga sofo. Hangue nuya xofo ma da johyaui ya motꞌi. Njabʉtho nehe núꞌʉ toꞌo da tʉnga ma noya, ma da hña̱nga yá tha̱ha̱ ne da muntsꞌa ya ja̱ꞌi pa da mɛꞌtsa ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nja ngu enga ya ja̱ꞌi: “ꞌNaꞌño toꞌo potꞌi, ꞌnaꞌño toꞌo xofo.” ");
INSERT INTO oteNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Hangue nuga stá pɛñꞌaꞌihʉ pa gui muntshʉ ya ja̱ꞌi, ngu ꞌnara sofo núꞌa̱ hinxcá pɛfihʉ. Maꞌra xa mpɛfi, ha nuꞌahʉ́ guí xopabihʉ yá ꞌbotꞌiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ne ndunthi ya mengu núꞌa̱ ra hniniꞌa̱ de Nsamaria bi gamfri gue ra Jesu go mi gueꞌa̱ xqui mɛhna Ajua̱ pa da nda̱, ngueꞌa̱ nura ꞌbɛhña̱ xqui damajua̱ni ne xqui ꞌñena gue nuꞌá̱ xa xiptho gatho núꞌa̱ te xqui ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hangue nu mi zøhni ya me Nsamaria habʉ mi ꞌbʉ ra Jesu, bi ba̱ntebi gue da ꞌmʉhuiꞌʉ, hangue nuꞌá̱ bi ꞌmʉhuiꞌʉ yo pa. ");
INSERT INTO oteNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ne xi ndunthi maꞌra bi gamfri ra Jesu ngueꞌa̱ go mi zofosɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ha nuꞌʉ́ bi ꞌñembabi núꞌa̱ ra ꞌbɛhña̱: ―Nubyá dí camfrihe hingue hønsɛ ngueꞌa̱ go gá xicje, dí camfrihe ngueꞌa̱ ya stá øsɛhe te xa ma̱, ne dí pa̱he gue xi majua̱ni go guehni ra Pøhøte de ya ja̱ꞌi gatho rá ngʉni ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ha nu mi thogui núꞌʉ yo pa, ra Jesu bi ma pa ja rá hai Galilea. ");
INSERT INTO oteNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ne nuꞌá̱ xqui ma̱nsɛ ne xqui ꞌñena: “Ni ꞌnará ꞌmɛhni Ajua̱ hingui hnumansu ja rá hai.” ");
INSERT INTO oteNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ha nu mi zønga Galileaꞌa̱ nuya mengu de guehni bi umba ntsaya ngueꞌa̱ xqui hyandiꞌʉ gatho ya da̱nga ntꞌudi xqui ꞌyøtꞌeꞌa̱ nuni ja ra ngo Jerusale, ngueꞌa̱ nehe nuya mengu rá hai xqui ma ja núꞌa̱ ra ngoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nepʉ nura Jesu bi yopa zønga maꞌnaꞌqui nuni Ncaná de Galilea habʉ xqui ꞌyøtꞌe da mvinu ra dehe. Y nuni Ncapernau mi ꞌbʉhni ꞌnará da̱nga maste ra nda̱ ne mri hñenga rá tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Y nuꞌá̱ bi ꞌyøde gue ra Jesu xqui menga de Judea ne ya xqui zønga Galilea, hangue bi ma há mi ꞌbʉꞌa̱ pa bá ba̱ntebi da mɛui ja rá ngu pa da ꞌyøthebi rá tꞌʉ ngueꞌa̱ ya mi nedu hma̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Nuꞌbʉ hingui hyanthʉ ya da̱nga ntꞌudi ne ya da̱nga tꞌøtꞌe, hingui camfrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ha nura da̱nga maste bi ꞌñembabi: ―Ndada, maha, pa hinda du ma zi tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Grí ma, ya ꞌbʉi xá hño ri tꞌʉ. Ha nuꞌá̱ bi gamfri núꞌa̱ bi xipa ra Jesu, ne bi gʉ rá ꞌñu bi ma. ");
INSERT INTO oteNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Y de mri ne ra ꞌñu bi ꞌñe yá ꞌbɛgo bi da̱di ne bi ꞌñembabi: ―Ya ꞌbʉi xá hño ri tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hangue nuꞌá̱ bi ꞌyambabiꞌʉ ne bi ꞌñembabi: ―¿Te ma ora bi mʉdi bi tsayabi ra hñeni? Ha nuꞌʉ́ bi ꞌñembabi: ―Mande ngu nzʉnga yoto bi tsayabi ra nzø. ");
INSERT INTO oteNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nuꞌbʉ́ nura dada bi beni gue mi gueꞌa̱ ra ora xqui xipabi ra Jesu gue ya mi ꞌbʉi xá hño rá tꞌʉ. Hangue nuꞌá̱ ne gatho núꞌʉ mi ꞌbʉi ja rá ngu bi gamfri gue ra Jesu go mi gueꞌa̱ xqui mɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Go gueꞌa̱ rá ñoho ra da̱nga ntꞌudi bi ꞌyøtꞌa ra Jesu nuni Galilea ne go bi ꞌyøtꞌeꞌa̱ de bá penga Judea. ");
INSERT INTO oteNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nepʉ ꞌmɛfa bi nja ꞌnará ngo ya xodyo nuni Jerusale, ne ra Jesu bi mani. ");
INSERT INTO oteNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Y de guehni Jerusale mi ja ꞌnara mothe xqui thuꞌmbabi rá thuhu Betesda de ra hña̱qui ebreo, habʉ mi ja cʉtꞌa ya porta, ne mi gueta ra gosthi hnini habʉ mi thuꞌmbabi ra ꞌÑu gá Maꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ha mi ꞌboni ndunthi ya daꞌthi, ya goda, ya doua, ne maꞌra ya tsꞌonate mi tøꞌmi rá nhua̱tꞌi ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ngueꞌa̱ ja ra ora mi ca̱ini ꞌnará ɛnxɛ Ajua̱ ja ra mothe pa mi ua̱ntꞌa ra dehe. Ne nuꞌa̱ tóꞌo rá mʉdi mi cʉtꞌa mbo ra dehe ora dra hua̱ntꞌi, núꞌá̱ go gueꞌa̱ mi ña̱ni de nuꞌa̱raza ra hñeni mi pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ha mi ꞌbʉhni ꞌnara ꞌñøhø ya mi pɛꞌtsa ꞌnatemaꞌrɛtꞌa ma hña̱to njɛya de mri hñeni. ");
INSERT INTO oteNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ha nura Jesu bi hyandi mi ꞌbɛni ne bi ba̱di gue yaꞌbʉ xqui njabʉ, ne bi ꞌñembabi: ―¿Ha guí ne gui ña̱ni? ");
INSERT INTO oteNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ha nura daꞌthi bi da̱di ne bi ꞌñembabi: ―Ndada, joꞌo toꞌo da cʉtcagui mbo ra mothe nura ora sta hua̱tꞌa ra dehe, ha nura ora ga nehma̱ ga cʉtꞌi nu maꞌna da da̱ma ꞌmɛtꞌo de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hangue ra Jesu bi ꞌñembabi: ―Nangui, jʉxa ri mfidi ne ꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nuꞌbʉ́ nura ꞌñøhøꞌa̱ ꞌbestho bi ña̱ni, ha bi gʉxa rá mfidi ne bi ꞌño. Ha nura paꞌa̱ mrá pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hangue ya nda̱ gá xodyo bi ꞌñembabiꞌa̱: ―Núbya rapaña go ra pa dega tsaya, ne ma leyhʉ hingui unga nsɛqui gui hña̱xa ri mfidibya. ");
INSERT INTO oteNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ha núꞌa̱ ra ꞌñøhø xqui ña̱ni bi da̱di ne bi ꞌñembabiꞌʉ: ―Núꞌa̱ toꞌo bi ꞌyøthegui go gueꞌa̱ bi xicagui gue ga jʉxa ma mfidi ne ga ꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nepʉ nuꞌʉ́ bi ꞌyambabi: ―¿Toꞌo bi xiꞌaꞌi gui jʉxa ri mfidi ne gui ꞌyo? ");
INSERT INTO oteNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ha núꞌa̱ ra ꞌñøhø xqui ña̱ni himbi ba̱di toꞌo xqui ꞌyøtheꞌa̱, ngueꞌa̱ mi ꞌbʉhni ndunthi ya ja̱ꞌi y nura Jesu ya xqui ma. ");
INSERT INTO oteNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ꞌMɛfa ra Jesu bi hyonga núꞌa̱ ra daꞌthi mbo ra nda̱nija̱ ne bi nthɛui maꞌnaꞌqui ne bi ꞌñembabi: ―Nuꞌi ya xcá ña̱ni. Ya oxqui ma gui yopa ꞌyøtꞌa ya tsꞌoqui maꞌnaꞌqui, pa hingui thogui maꞌra ya tsꞌothogui maꞌna strá ntsꞌo. ");
INSERT INTO oteNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nepʉ nura ꞌñøhøꞌa̱ bi ma bá xipa ya nda̱ gá xodyo gue go mi gueꞌa̱ ra Jesu xqui ꞌyøtheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hangue por gueꞌa̱ ya nda̱ gá xodyo xi mi ʉtsa ra Jesu, ne xi mi ne da hyohma̱, ngueꞌa̱ nuꞌá̱ mi øtꞌa ya da̱nga ntꞌudi de nuya pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nuꞌbʉ́ ra Jesu bi ꞌñena: ―Ajua̱ ma Dada hingui tsaya di mpɛfi, njabʉthogui nehe hindí tsaya. ");
INSERT INTO oteNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hangue nuya nda̱ gá xodyo maꞌna xi mi ꞌramanu da hyohma̱, ngueꞌa̱ nuꞌá̱ himi øta ra ley núꞌa̱ mi ma̱ de ra pa dega tsaya, ne ngueꞌa̱ mi ma̱ gue Ajua̱ mrá Dadaꞌa̱, y njabʉ mri nhyɛcuaui Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hangue ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ, hinda za te da ꞌyøtꞌasɛ rá Tꞌʉ Ajua̱. Ngueꞌa̱ nuꞌá̱ handi te gatho øtꞌa Ajua̱ rá Dada, y núꞌa̱ handi gueꞌa̱ øtꞌe nehe, ngueꞌa̱ te gatho øtꞌa rá Dada, gueꞌa̱ øtꞌa ra Tꞌʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ajua̱ ra Dada xi ma̱di rá Tꞌʉ, ne utuabi te gatho øtꞌeꞌa̱. Ne ma da ꞌñutuabi yá ꞌbɛfi maꞌna dya da̱ngui que núꞌʉ xcá hyanthʉ, pa xi gui ꞌyøhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ajua̱ ra Dada jʉxa gatho núꞌʉ xa du ne umbabiꞌʉ ra te. Njabʉ nehe rá Tꞌʉꞌa̱ umbabi ra te toꞌoraza núꞌa̱ go da neꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ajua̱ ra Dada hingui ha̱ꞌmba nguɛnda ni ꞌnara ja̱ꞌi, nguetho gatho xa ꞌyɛntꞌua ja rá ꞌyɛ rá Tꞌʉ pa go da hña̱ꞌmba nguɛndaꞌa̱, ");
INSERT INTO oteNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","pa njabʉ gatho ya ja̱ꞌi da numansu ra Tꞌʉ ngu di numansuꞌʉ Ajua̱ rá Dada. ꞌBʉ toꞌo hingui numansu ra Tꞌʉ, nehe hingui numansubi rá Dada núꞌa̱ toꞌo bá pɛhni. ");
INSERT INTO oteNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Xi majua̱ni dí xiꞌahʉ: Nuꞌa̱ tóꞌo huxa ntꞌøde núꞌa̱ dí ma̱ ne camfri Ajua̱ núꞌa̱ bá pɛncagui, pɛꞌtsa ra te pa nza̱ntho, ne hinda ꞌbɛhna ja ra nidu, ngueꞌa̱ nuꞌá̱ ja ra uɛnda ya xa du ne xa yopa nte pa da mɛꞌtsa rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Xi majua̱ni dí xiꞌahʉ, ma da zø ra pa ne majua̱ni nubya ya ja, gue núꞌʉ xa du da ꞌyøde núꞌa̱ ma̱nga rá Tꞌʉ Ajua̱, ha nuꞌʉ tóꞌo da hñuxa ntꞌøde ma da nja yá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngueꞌa̱ Ajua̱ ra Dada ha̱sɛ ra tsꞌɛdi pa da unga ra te pa nza̱ntho. Njabʉ nehe rá Tꞌʉ bi umba ra tsꞌɛdi pa da unga ra te pa nza̱ntho nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne xa ꞌyɛntꞌua ja rá ꞌyɛ rá Tꞌʉ pa go da hña̱ꞌmba nguɛnda gatho ya ja̱ꞌi de ja ra ximhai, ngueꞌa̱ go gueꞌa̱ Núꞌa̱ Toꞌo e bi Nja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Oguí ꞌyøhʉ ngueꞌa̱ dí xiꞌaꞌihʉ njabʉ. Ngueꞌa̱ ma da zø ra pa nuto gatho xa du ma da ꞌyøde sta ña̱ rá Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Y núꞌʉ toꞌo gatho xa ꞌyøtꞌa núꞌa̱ xá hño ma da nangui pa da nja yá te pa nza̱ntho, ha nuꞌʉ tóꞌo xa ꞌyøtꞌa núꞌa̱ hingui ho ma da nangui pa da ꞌbɛhna ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nuga hingui tsa te ga øtꞌasɛ. Núꞌa̱ xicagui ma Dada, gueꞌa̱ dí øtꞌe, ne dí øtꞌa ra tsꞌʉtbi ngu di ꞌbɛpqui, ne nura tsꞌʉtbiꞌa̱ go gueꞌa̱ xá hño ngueꞌa̱ dí øꞌtua rá paha ma Dada núꞌa̱ toꞌo bá pɛncagui, hingo dí øtꞌa núꞌa̱ go ma pahasɛga. ");
INSERT INTO oteNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ꞌBʉ nuga gra ma̱nsɛ toꞌogui, hinte da muui núꞌa̱ ga ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pe ꞌbʉi ꞌna toꞌo damajua̱ni toꞌogui, ne dí pa̱di gue núꞌa̱ ma̱ñꞌa̱ xi di muui. ");
INSERT INTO oteNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nuꞌahʉ xcá pɛnhʉ ya ꞌmɛhni pa da ꞌyambabi ra Xuua de gueque, y nuꞌá̱ bi damajua̱ni toꞌogui ne bi xiꞌahʉ núꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pe pa gueque ni ꞌnara ja̱ꞌi hindí honi toꞌo da da̱di por gueque. Nuga hønsɛ dí benꞌahʉ núꞌa̱ bi ma̱nga ra Xuua, qué pa gui mpøhøhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ra Xuua gueꞌa̱ mi nja ngu ꞌnara ñotꞌi, mi yoꞌtꞌa ri mfenihʉ de núꞌa̱ mi xiꞌahʉ. Ha nuꞌahʉ́, gá ꞌyødehʉ co ra johya núꞌa̱ te mi ma̱, pe hønsɛ ꞌraya zi patho. ");
INSERT INTO oteNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nuga dí pɛ ya ꞌbɛfi ngu xa ꞌracagui Ajua̱ ma Dada ga juadi ga pɛfi, y nuya ꞌbɛfi dí pɛfi go gueꞌʉ damajua̱ni gue go Ajua̱ xpá mɛncagui. Y nuya ꞌbɛfiꞌʉ maꞌna ya da̱ngui pa da fa̱di toꞌogui que núꞌa̱ bi ma̱nga ra Xuua de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Dada toꞌo bá pɛncagui go gueꞌa̱ damajua̱ni toꞌogui, masque hinhyaꞌmʉ xcá ꞌyøhʉ xa ña̱ꞌa̱ nixi xcá hyanthʉ tenguꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ne nurá noyaꞌa̱ hinxa zoda ri mfenihʉ, nguetho nuꞌahʉ hinxcá camfriguihʉ gue nuga go rá ꞌmɛhniguiꞌa̱. ꞌBʉ xcá camfriguihʉhma̱, nuꞌbʉ́ gri pa̱hma̱hʉ te rí bønga ra Ma̱ca Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nuꞌahʉ hinhyaꞌmʉ guí hɛhʉ ra Ma̱ca Tꞌofo, xi guí heꞌthʉ pa xahma̱ ja gui tsʉhma̱hʉni ra te pa nza̱ntho, pe hingui tso ri mfenihʉ de núꞌa̱ guí heꞌthʉ, ngueꞌa̱ ja nura Tꞌofoꞌa̱ ja ma̱ni de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ha nuꞌahʉ́ hinguí ne gui camfriguihʉ pa da za gui tsʉhma̱hʉ núꞌa̱ ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nuga hindí ma̱nga njabʉ pa da ꞌñesca ma nsu ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Dí ma̱nga njabʉ ngueꞌa̱ dí pa̱di gue nuꞌahʉ hingrí ma̱dihʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Masque stá ehma̱ de rá thuhu Ajua̱ ma Dada, pe nuꞌahʉ hinxcá numansuguihʉ. Pe nuꞌbʉ ꞌnara ja̱ꞌi da ꞌñehe de rá thuhusɛ, nuꞌbʉ́ ha̱, go guí numansuhʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hinguí ne gui camfriguihʉ ngueꞌa̱ go ꞌmɛtꞌo guí ꞌñeꞌtsua nsusɛhʉ ꞌna ngu maꞌna, hingo guí hoñhʉ da ꞌñeꞌtsꞌa ri nsuhʉ Ajua̱ núꞌa̱ ꞌnatho. ");
INSERT INTO oteNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Oguí beñhʉ gue go nuga ma ga ña̱pꞌaꞌihʉ ja rá thandi Ajua̱ ma Dada. Nurá ley ra Moise go gueꞌa̱ ma da ña̱pꞌaꞌihʉ, núꞌa̱ tsꞌa guí camfrihʉ da ña̱ñꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ꞌBʉ gri camfrihma̱hʉ núꞌa̱ bi ꞌyofo ra Moise, nuꞌbʉ́ gri camfriguihʉ hma̱ha̱ nehe, ngueꞌa̱ nuꞌá̱ bi ꞌyofo de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ha nuꞌbʉ hinguí camfrihʉ núꞌa̱ bi ꞌyofoꞌa̱, nuꞌbʉ́ ¿hanja da za gui camfrihʉ núꞌa̱ dí ma̱ngá? ");
INSERT INTO oteNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nepʉ de gueꞌa̱ ra Jesu bi ꞌranga riꞌnandi ra ndehe Galilea, núꞌa̱ rá thuhu nehe Tiberia. ");
INSERT INTO oteNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ha mri dɛna ndunthi ya ja̱ꞌi ngueꞌa̱ mi handa ya da̱nga ntꞌudi núꞌʉ mi øꞌtua ya daꞌthi mi ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nuꞌbʉ́ ra Jesu bi bøxa ja ꞌnara tꞌøhø ne ja bá huhuini yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ne ya mi ma da datꞌa ra pa de ra pascua ꞌnará ngo ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nuꞌbʉ́ ra Jesu bi hyanda núꞌʉ ya ja̱ꞌi mi ndunthi xqui dɛniꞌa̱, nepʉ nuꞌá̱ bi ꞌñemba ra Lipe: ―¿Habʉ ga tañhʉ ra thuhme ꞌbʉ, pa ga ꞌuiñhʉ gatho nuya ja̱ꞌiyʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ra Jesu xa bi ne bi ma̱nga njabʉ pa bi nu te xa da̱di hma̱ha̱ ra Lipe, ngueꞌa̱ nuꞌá̱ ya mi pa̱disɛ te mi ma da ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ha nura Lipe bi da̱di ne bi ꞌñembabi: ―Pøde nixi co yo nthebe denario ra thuhme ga tañhʉ, hinda uadi, ua ꞌra ꞌna zi xɛni da ziyʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nepʉ ꞌnará nxadi ra Jesu mrá thuhu ra Andre, go gueꞌa̱ mrá cu ra Simu Pedro, bi ꞌñembabi ra Jesu: ");
INSERT INTO oteNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―ꞌBʉcua ꞌnara tsꞌʉntꞌʉ ha̱ cʉtꞌa ya thuhme dega cebada ne yoho ya zi hua̱, ¿pe te ri ma̱ña? ");
INSERT INTO oteNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nuꞌbʉ́ nura Jesu bi ꞌñembabi yá nxadi: ―Xiphʉ gatho ya ja̱ꞌi da hñudi. Y mi jani ꞌnara ꞌbotꞌɛi, ne ja bi hñuhniꞌʉ, ne ngu mi cʉtꞌa ꞌmo sɛhɛ ya ꞌñøhø. Ya ꞌbɛhña̱ ne ya ba̱tsi himi pa ꞌmede. ");
INSERT INTO oteNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nepʉ nura Jesu bi gʉ núꞌʉ ya thuhme, ne bi umba njama̱di Ajua̱ de núꞌa̱ ra thuhme ma da ziꞌʉ, ne ja ngá umba yá nxadi nepʉ ya nxadi bi umba nuya ja̱ꞌi mi huhni. Ne guetꞌatho bi ꞌyøtꞌe co nuya zi hua̱, ne bi ziꞌʉ asta xi bi niña̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ha nu mi uadiꞌʉ, ra Jesu bi ꞌñembabi yá nxadi: ―Bá muntshʉ gatho ya zi xɛni núꞌʉ bi bongui, pa hinte da ꞌmɛdi. ");
INSERT INTO oteNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ha nuꞌʉ́ bi muntsꞌa gatho ya zi xɛca thuhme xqui ꞌbonguabiꞌʉ de núꞌʉ cʉtꞌa ya thuhme dega cebada. Ne bi ñuxa ꞌrɛtꞌamayoho ya ꞌbøtsꞌe co nuya xɛca thuhme bi bongui. ");
INSERT INTO oteNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ha nu mi hyanda ya ja̱ꞌi núꞌa̱ ra da̱nga ntꞌudi xqui ꞌyøtꞌa ra Jesu, nuꞌʉ́ bi ꞌñena: ―Xi majua̱ni go guehni rá da̱nga ꞌmɛhni Ajua̱ núꞌa̱ mi hma̱ da ꞌñecua ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pe ra Jesu mi pa̱tho gue mi neꞌʉ da zixhma̱ha̱ pa da nda̱hma̱ꞌa̱ de gueꞌʉ, hangue nuꞌa̱ bi ꞌyøtꞌe, bi ma de guehni bi yopa bøxa maꞌnaꞌqui ja núꞌa̱ ra tꞌøhøꞌa̱ ri sɛhɛ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Y de mi nde, yá nxadiꞌa̱ bi ma pa ja ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nepʉ de guehni bi yʉtꞌa ja ꞌnara motsa pa bi maꞌʉ Ncapernau de riꞌnandi ra ndehe. Ha ya xmá ꞌmɛxuui, ha ra Jesu hinxqui mengtho de ja ra tꞌøhø. ");
INSERT INTO oteNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ne bi mʉdi bi ꞌño ꞌnara bʉnthi xi mri a̱nga ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Y ya xqui ꞌño ngu cʉtꞌa o ꞌrato kilometro de ja ra dehe, nepʉ bi hyantꞌʉ ra Jesu mbra ꞌyotho maña̱ de ra dehe pa da e da zʉdiꞌʉ, ne nuꞌʉ́ xi bi ntsu. ");
INSERT INTO oteNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pe nuꞌá̱ bi ꞌñembabiꞌʉ: ―¡Nuga go guecagui, oguí tsuhʉ! ");
INSERT INTO oteNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nepʉ nuꞌʉ́ co ra johya bi pøꞌtsa ja ra motsa ne bi zitsꞌi, ne ꞌbestho bi zøñꞌʉ co ra motsa ja ra hai habʉ mri maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ha nurá hyaxꞌa̱ núꞌʉ ya ja̱ꞌi xqui gohni riꞌnandi ra ndehe ne xqui hyandi gue ꞌnada ra motsa mi ꞌbahni, ne xqui ba̱di gue nuyá nxadi ra Jesu bi masɛꞌʉ ja núꞌa̱ ra motsa, ne ra Jesu himbi mɛuiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ne guetbʉ habʉ xqui zi ra thuhmeꞌʉ nu mi umba njama̱di Ajua̱ nura Jesu, ja bi zøhni maꞌra ya motsa xqui ꞌñehe Tiberia. ");
INSERT INTO oteNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hangue nu mi hyandiꞌʉ gue ya mi joꞌoni ra Jesu nixi yá nxadi, nuꞌbʉ́ nuꞌʉ́ ꞌbestho bi yʉtꞌa ja núꞌʉ ya motsa ne bi ma pa Ncapernau pa da hyonga ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Y ja bá tsʉhniꞌʉ ra Jesu riꞌnandi ra ndehe ne bi ꞌñembabiꞌʉ: ―Xahnate, ¿haꞌmʉ gá tsøhø de guecua, desde manxuui o ja nubya? ");
INSERT INTO oteNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―Xi majua̱ni dí xiꞌahʉ, guí hongaguihʉ ngueꞌa̱ dá ꞌuiñꞌaꞌihʉ ne gá niña̱hʉ, hingue ngueꞌa̱ gá hyanthʉ ya da̱nga ntꞌudi. ");
INSERT INTO oteNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Guí øthʉ ra tsꞌɛdi pa gui tsʉhʉ núꞌa̱ te gui tsihʉ, pe nuꞌá̱ ꞌbestho da thegue. Maꞌna xá hño ꞌyøthʉ ra tsꞌɛdi gui tsʉhʉ núꞌa̱ ra nzaqui unga ra te pa nza̱ntho, y nuꞌá̱ hinhyaꞌmʉ da thegue. Go gueꞌa̱ ra nzaqui da ꞌraꞌahʉ Núꞌa̱ Toꞌo e bi Nja̱ꞌi. Ne Ajua̱ ra Dada xa ꞌñuꞌtꞌaꞌihʉ gue xa umba ra tsꞌɛdiꞌa̱ pa da ꞌraꞌahʉ núꞌa̱ ra nzaquiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ha nuꞌʉ́ bi ꞌñembabi: ―Nuꞌbʉ́ ¿te mahyoni ga øthe pa njabʉ da za ga øthe ngu núꞌa̱ xa ꞌbɛpcahe Ajua̱, pa njabʉ da za ga tsʉhe núꞌa̱ ra nzaqui guí engaguihe? ");
INSERT INTO oteNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nepʉ nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Nuꞌa̱ mahyoni gui ꞌyøthʉ pa da za gui ꞌyøthʉ ngu núꞌa̱ xa ꞌbɛpꞌahʉ Ajua̱, camfrihʉ núꞌa̱ toꞌo xpá mɛhniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ha nuya ja̱ꞌi bi ꞌñembabiꞌa̱: ―Nuꞌbʉ́ ¿te ma da̱nga ntꞌudi da za gui ꞌyøtꞌe pa ga hanthe ne ga camfriꞌihe? ¿Ndaꞌa̱ ra da̱nga tꞌøtꞌe ma gui ꞌyøtꞌegue? ");
INSERT INTO oteNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mayaꞌbʉ ndu ma dadahʉ ra Moise mri zi núꞌʉ maꞌra ndu ma dadahʉ ja ra ꞌyoꞌmtha, y ja bi ziniꞌʉ ra thuhme rá thuhu ra maná, ngu xa tꞌofo ja ra Ma̱ca Tꞌofo habʉ ena: “Nuꞌá̱ bá pɛmpabi ra thuhme de mahetsꞌi pa bi ziꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ha nura Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ: Hingo ra Moise bi umbabiꞌʉ núꞌa̱ ra thuhme bá ehe de mahetsꞌi núꞌa̱ bi ziꞌʉ. Numa Dada go gueꞌa̱ bi mɛmpabiꞌʉ. Y go guetꞌa̱ bá pɛnꞌahʉbya ra thuhme de mahetsꞌi núꞌa̱ unga ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Núꞌa̱ ra thuhme bá pɛnꞌahʉ Ajua̱, go gueꞌa̱ rá Tꞌʉ bá ca̱i de mahetsꞌi, ne go gueꞌa̱ umba ra meximhai ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nuꞌbʉ́ nuya ja̱ꞌi bi ꞌñembabi: ―Ndada, oxqui ma gui ꞌbɛtcahe núꞌa̱ ra thuhmeꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ha nura Jesu bi ꞌñembabiꞌʉ: ―Nuga go guecagui drá thuhme dega te pa nza̱ntho. Nuꞌa̱ tóꞌo da ꞌñe da zʉcagui hinhyaꞌmʉ da zʉ ra thuhu, ha nuꞌa̱ tóꞌo da gamfrigui hinhyaꞌmʉ da zʉ ra nduthe. ");
INSERT INTO oteNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pe nuga ya stá xiꞌahʉ gue masque ya xcá hyandgaguihʉ pe hinguí camfriguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gatho núꞌʉ toꞌo xa ꞌracagui Ajua̱ ma Dada da ꞌñehe da zʉcagui, ha nuꞌa̱ tóꞌo da ꞌñehe da zʉcagui hinga coꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ngueꞌa̱ nuga stá ca̱i de mahetsꞌi pa ga øꞌtua rá paha núꞌa̱ toꞌo bá pɛncagui, hingue núꞌa̱ go ma pahasɛ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nurá paha ma Dada núꞌa̱ toꞌo bá pɛncagui gue núꞌʉ to gatho xa ꞌracagui ni ꞌna de gueꞌʉ hinga ꞌbɛdi, ne nura pa de ra nga̱xhmai, ma ga jʉtsꞌiꞌʉ pa rí nja yá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ne nurá paha núꞌa̱ toꞌo bá pɛncagui gue da nja yá te pa nza̱ntho nuto da ba̱di toꞌogui ne da gamfrigui, ne nura pa de ra nga̱xhmai, ma ga jʉtsꞌiꞌʉ pa rí nja yá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nuꞌbʉ́ nuya xodyo bi nønga ra Jesu ngueꞌa̱ mi ena: “Nuga go guecagui drá thuhme stá ca̱i de mahetsꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne mi eñꞌʉ: ―Go guehni ra Jesu rá tꞌʉ ra Jose, ¿ha ngue ha̱? Nujʉ dí pa̱dihʉ toꞌo rá dada ne rá na̱na̱ni. Nuꞌbʉ́ ¿hanja ena gue bá ca̱i de mahetsꞌi? ");
INSERT INTO oteNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ha ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Oguí nøntehʉ de núꞌa̱ stá xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngueꞌa̱ ni ꞌna hinto tsa da ꞌñe da zʉcagui ꞌbʉ hingo Ajua̱ ma Dada núꞌa̱ toꞌo bá pɛncagui da zopa rá mfeni pa e da zʉcagui, ne go gueꞌʉ ma ga jʉtsꞌi nura pa de ra nga̱xhmai pa rí nja yá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Njaua xa tꞌofo ja yá tꞌofo yá ꞌmɛhni Ajua̱ habʉ ena: “Ajua̱ ma da ꞌñuta gatho ya ja̱ꞌi,” ena njabʉ. Hangue gatho núꞌʉ toꞌo da hñuxa ntꞌøde te ma̱nga ma Dada ne da zo ja yá mfeni, núꞌʉ́ go gueꞌʉ da ꞌñe da zʉcagui. ");
INSERT INTO oteNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hingo dí xiꞌahʉ gue toꞌo xa hyanda Ajua̱ ra Dada, ngueꞌa̱ hønsɛgui stá handiꞌa̱, ngueꞌa̱ stá ehe de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Xi majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo camfrigui pɛꞌtsa ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nuga go guecagui drá thuhme dega te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mayaꞌbʉ núꞌʉ ndu ri dadahʉ bi zi ra maná nu mi ꞌbʉi ja ra ꞌyoꞌmtha, pe nuꞌʉ́ bi duꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pe núꞌa̱ ra thuhme dí ma̱ngá, hingue ngu núꞌa̱ ra thuhme bi zi núꞌʉ bi du. Núꞌa̱ ra thuhme dí ma̱ngá bá ehe de mahetsꞌi pa nutoꞌo da zi hinhyaꞌmʉ da du. ");
INSERT INTO oteNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nuga go guecagui drá thuhme dí te, dá ehe de mahetsꞌi. Nuꞌa̱ tóꞌo da zi núꞌa̱ ra thuhme dí ma̱ngá, da nja rá te pa nza̱ntho. Ha núꞌa̱ ra thuhme dí ma̱ngá, go guehna ma ndoꞌyo núꞌa̱ ma ga da pa da nja yá te pa nza̱ntho ya meximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ha nuya xodyo bi ꞌñémbabiꞌʉ ꞌna ngu maꞌna: ―¿Hanja da za da ꞌracjʉ rá ndoꞌyosɛni pa ga tsihʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ra Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ, ꞌbʉ hingui tsipabihʉ rá ngø ne rá ji Núꞌa̱ Toꞌo e bi Nja̱ꞌi, hinda nja ri tehʉ pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nuꞌa̱ tóꞌo da zicagui ma ngø ne ma ji, gueꞌa̱ da nja rá te pa nza̱ntho, ne nura pa de ra nga̱xhmai nuga ga jʉtsꞌiꞌa̱ pa rí nja rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ngueꞌa̱ ma ngø nja ngu ra nzaqui, ne ma ji nja ngu ra dehe núꞌa̱ tsꞌi pa da nte ꞌna. Pe numa ngø ne ma ji hingue ngu nuya nzaquiꞌʉ, ngueꞌa̱ numa ngø ne ma ji unga ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nuꞌa̱ tóꞌo da zicagui ma ngø ne ma ji, go gueꞌa̱ da ꞌmʉi con gueque, ha nuga ga ꞌbʉi con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ajua̱ ma Dada núꞌa̱ toꞌo bá pɛncagui, nuꞌá̱ te, hangue nuga dí te nehe ngueꞌa̱ nuꞌá̱ teꞌa̱. Njabʉ nehe nuꞌa̱ tóꞌo da zigágui, nuꞌá̱ ma da nja rá te ngueꞌa̱ dí tega. ");
INSERT INTO oteNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nuga go guecagui drá thuhme stá ehe de mahetsꞌi. Pe hingo dí nja ngu núꞌa̱ ra maná núꞌa̱ bi zi ndu ri dadahʉ ne bi du. Ngueꞌa̱ nuꞌa̱ tóꞌo da zigágui núga drá thuhme, da nja rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Njabʉ bi ma̱nga ra Jesu nu mi xahnate ja ra nija̱ nuni Ncapernau. ");
INSERT INTO oteNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ha ndunthi de núꞌʉ toꞌo mi ꞌñouiꞌa̱ ne myá nxadihma̱, mi ꞌyødeꞌʉ bi ma̱nga ra Jesu njabʉ, bi ꞌñenaꞌʉ: ―Xi hindrí hohʉ núꞌa̱ ma̱ni. ¿To ja gueꞌa̱ da gamfribini? ");
INSERT INTO oteNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ha nura Jesu bi ba̱tho gue nuꞌʉ́ mi nønte de núꞌa̱ xqui ma̱ñꞌa̱, hangue nuꞌá̱ bi ꞌñembabiꞌʉ: ―¿Ha gue hingrí hohʉ núꞌa̱ stá ma̱? ");
INSERT INTO oteNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xi te gui beñhʉ núꞌbʉ xcrí hyanthʉ da yo menga pa mahetsꞌi Núꞌa̱ Toꞌo e bi Nja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Núꞌa̱ ra nzaqui dí ma̱, go gueꞌa̱ ra nzaqui pa ri nda̱hihʉ, hingo pa ri ndoꞌyohʉ. Ngueꞌa̱ núꞌa̱ ra nzaqui guí tsihʉ pa ri ndoꞌyohʉ hinte di muui pa gui tsʉhʉ ra te pa nza̱ntho. Y nuya noya stá xiꞌahʉ go gueꞌʉ ra nzaqui pa ri nda̱hihʉ, ne go gueꞌʉ di ꞌraꞌahʉ ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pe ꞌra de gueꞌahʉ hinguí camfrihʉ. Ra Jesu bi ma̱nga njabʉ ngueꞌa̱ desde rá mʉdi ya mi pa̱tho núꞌʉ toꞌo himi camfriꞌa̱, ne ya mi pa̱tho toꞌo mi ma da daꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nehe bi ꞌñena: ―Xa njabʉ ngu núꞌa̱ ya stá xiꞌahʉ gue hinda za to da ꞌñesɛ da zʉqui ꞌbʉ hingo Ajua̱ ma Dada da zopa rá mfeni pa da e da zʉcagui. ");
INSERT INTO oteNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nepʉ ndunthi de núꞌʉ toꞌo mri ꞌñoui ne myá nxadihma̱ bi ꞌuegueꞌʉ, ya himbi dɛniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hangue nura Jesu bi ꞌñembabi núꞌʉ ꞌrɛtꞌamayoho yá nxadi xqui huahni: ―Xiꞌahʉ, ¿ha gue ma gui ꞌueguehʉ nehe? ");
INSERT INTO oteNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ha nura Simu Pedro bi da̱di ne bi ꞌñembabiꞌa̱: ―Ma zi Hmuꞌihe, ¿toꞌo ja ga tɛñhe? gue hønsɛꞌi guí ma̱nga ya noya de ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ha nuje stá camfrihe ne stá pa̱he gue go gueꞌe grá Cristo, rá Tꞌʉꞌi Ajua̱ núꞌa̱ te, xpá mɛnꞌaꞌi pa gui nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nepʉ nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Nuꞌahʉ guí ꞌrɛtꞌamayohohʉ stá huanꞌahʉ, ¿ha ngue ha̱? Pe ꞌyobʉ ꞌna de gueꞌahʉ ri ꞌñoui ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nuꞌá̱ bi ma̱ de ra Juda Iscariote rá tꞌʉ ra Simu, ngueꞌa̱ go mi gueꞌa̱ mi ma da daꞌa̱, masque go mi gueꞌa̱ ꞌna de núꞌʉ ꞌrɛtꞌamayoho ya nxadi. ");
INSERT INTO oteNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ꞌMɛfa ra Jesu bi ꞌñonitho ja ra hai Galilea, himbi ne ma bá ꞌbʉhni Judea ngueꞌa̱ nuya nda̱ gá xodyo de guehni mi honi hanja da za da hyoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ha ya mi ma da datꞌa ꞌnará ngo ya xodyo go mrá ngo dega nthøja̱ꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hangue yá høcu ra Jesu bi ꞌñembabi: ―Grí ma pa Judea, pa nuya ja̱ꞌi mri dɛñꞌaꞌi de guehni da za da hyandiꞌʉ nehe núꞌʉ ya da̱nga ntꞌudi guí øtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ngueꞌa̱ ꞌbʉ ꞌnara ja̱ꞌi ne toꞌo da hyandua rá ꞌbɛfi, nuꞌá̱ hinda ꞌyøtꞌa rá ꞌbɛfi mantꞌa̱gui. Ya gue guí øtꞌa nuya da̱nga tꞌøtꞌe, ꞌyøtꞌeꞌʉ ja yá thandi gatho ya ja̱ꞌi pa da hyanda núꞌa̱ guí øtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nuyá høcuꞌa̱ bi xipabi njabʉ ngueꞌa̱ nixi gueꞌʉ himi camfri ua go mi gueꞌa̱ rá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Pa gueque hinxa zøta ma ora pa ga mani, pe nuꞌahʉ́, otho ri orahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ya ja̱ꞌi hingui tsa da ʉtsaꞌihʉ, pe nuga ha̱, di ʉtsagui, ngueꞌa̱ dí xipabi de yá tsꞌoꞌbɛfiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nuꞌahʉ́, go da rí maha ra ngo. Nuga hinga ma, asta hinda zø ma ora pa ga ma. ");
INSERT INTO oteNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ha nu mi xipabi njabʉ, bi maꞌʉ, ha nura Jesu bi gotritho Galilea. ");
INSERT INTO oteNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nepʉ ra Jesu bi ma nehe ja ra ngo, pe asta ꞌmɛfa. Bi ma pe mantꞌa̱guitho pa hinto da hyandi. ");
INSERT INTO oteNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ha nuya nda̱ gá xodyo núꞌʉ mi ne da hyohma̱ꞌa̱ xi mi honiꞌʉ de guehni ja ra ngo ne mi eñꞌʉ: ―¿Habʉ di ꞌyouaꞌa̱ ꞌbʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ha ndunthi de nuya ja̱ꞌi mi ꞌyoni ja ra ngo xi mi ña̱ de gueꞌa̱. ꞌRa mi ena: “Núꞌa̱ ra ꞌñøhøꞌa̱ xi ra hoja̱ꞌi”; ha nu maꞌra mi ena: “Hinga majua̱ni, hønsɛ hatꞌatho ya ja̱ꞌi.” ");
INSERT INTO oteNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pe nuꞌʉ́ mi ña̱ zi njante pa hinto da ꞌyøde, ngueꞌa̱ mi tsu yá mixodyoui núꞌʉ myá nda̱ de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tsꞌa mi ꞌyo made ra ngo ra Jesu bi yʉtꞌa ja ra nda̱nija̱ pa bi nxahnate. ");
INSERT INTO oteNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ha nuya nda̱ gá xodyo xi bi ꞌyø ne bi ꞌñémsɛꞌʉ: ―¿Hanja nuni ra Jesu ntsꞌɛdi ja rá mfa̱di ha hinxa nxadi? ");
INSERT INTO oteNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ha nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Núꞌa̱ dí udi, hingo dí ma̱nsɛga. Nuꞌá̱ bí ehe de Ajua̱ núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nuꞌa̱ tóꞌo da ne da ꞌyøꞌtuabi rá paha Ajua̱, ma da ba̱di de núꞌa̱ ma ntꞌutuate ua bí ehe de Ajua̱ o ua go dí bensɛga núꞌa̱ dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nuꞌa̱ tóꞌo bensɛ núꞌa̱ ma̱, núꞌá̱ go gueꞌa̱ ne da tꞌeꞌtsua rá nsu. Pe nuꞌa̱ tóꞌo ne da ꞌñeꞌtsuabi rá nsu nuto bá pɛhniꞌa̱, nuꞌá̱ ma̱nga majua̱ni ne hingui hate. ");
INSERT INTO oteNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ra Moise xa ꞌraꞌaꞌihʉ ra ley, pe ni ꞌna de gueꞌahʉ hinxcá ꞌyøtehʉ nura leyꞌa̱. Nuꞌbʉ gri øthma̱hʉ núꞌa̱ ma̱, nuꞌbʉ́ ¿hanja guí beñhʉ gui hyogaguihʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ha nura hmuntsja̱ꞌi bi da̱di ne bi ꞌñena: ―Nuꞌi pø guí ꞌñoui ra tsꞌonda̱hi. ¿Toꞌo xa beni da hyoꞌague? ");
INSERT INTO oteNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Hønsɛ ngueꞌa̱ dá pɛ ꞌnara ꞌbɛfi núꞌa̱ ra pa dega tsaya dá japi bi ña̱ni ꞌnara daꞌthi, hangue por gueꞌa̱ grí ꞌyøhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pe xi nuꞌahʉ nehe, núꞌa̱ ra pa dega tsaya guí huꞌtsuahʉ ra seña ja yá ndoꞌyo ri ba̱tsihʉ ngu bi ꞌyøtꞌa ndu ri dadahʉ, desde rá mʉdi bi hñuxa nura seña ja yá ndoꞌyo, ne ꞌmɛfa ra Moise mi manda da tꞌøtꞌa njabʉ nehe, masque hingo bi mʉti. Hangue ringueꞌa̱ nuꞌahʉbya, ngu da datꞌa rá hña̱to ma pa de xa ꞌmʉi ri tꞌʉba̱tsihʉ guí huꞌtsuahʉ ra seña, masque ra pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ꞌBʉ nuꞌahʉ guí huꞌtsuahʉ ra seña ri ba̱tsihʉ ra pa dega tsaya hønsɛ pa hingui tsꞌocuahʉ rá ley ra Moise, nuꞌbʉ́ xi ¿hanja guí pø ri cuɛhʉ con gueque ngueꞌa̱ stá øthebi maxøgue rá ndoꞌyo ꞌnara ꞌñøhø nura pa dega tsaya? ");
INSERT INTO oteNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Guí beñhʉ gue hinxá hño núꞌa̱ dá øtꞌe, ngueꞌa̱ dá øtꞌe ra pa dega tsaya. Oguí da̱ma beñhʉ ua hingui ho ꞌnara tꞌøtꞌe asta hingo ꞌmɛtꞌo gui pa̱hʉ ua majua̱ni hingui ho o hina, pa njabʉ da za gui beñhʉ ngu rí ꞌñepi núꞌa̱ ra tꞌøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ha nu ꞌraya me Jerusale bi ꞌñena: ―¿Ha hingo guehni thoni pa da tho? ");
INSERT INTO oteNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xini ꞌbahni ña̱ ja yá thandi ya ja̱ꞌi ne hinte sipabi. ¿Ha gue camfri ma nda̱hʉ gue xi majua̱ni go guehni ra Cristo rá ꞌmɛhni Ajua̱ pa e da nda̱? ");
INSERT INTO oteNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pøde hina, ngueꞌa̱ nujʉ dí pa̱hʉ habʉ ra menguni. Ngueꞌa̱ nu stí zø ra Cristo hinto ma da ba̱di habʉ dra menguꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ra Jesu bi ꞌyøde te mi ma̱nga ya ja̱ꞌi, hangue nu mi nxahnateꞌa̱ ja ra nda̱nija̱ bi ña̱ ntsꞌɛdi bi ꞌñena: ―¡Guí pa̱caguihʉ ne guí pa̱hʉ habʉ drá mengu! Nuga hinstá esɛhɛ. Núꞌa̱ toꞌo bá pɛncagui go guesɛꞌa̱ Ajua̱ núꞌa̱ xi majua̱ni, ne nuꞌahʉ́ hinguí pa̱hʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nuga dí pa̱caꞌa̱ ngueꞌa̱ stá ehe de gueꞌa̱, ne go gueꞌa̱ bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hangue nu mi ꞌyøde ya nda̱ gá xodyo bi ma̱nga ra Jesu njabʉ, maꞌna mi neꞌʉ da gʉꞌa̱ pa da zixhma̱ꞌa̱ ntsꞌa̱hni, pe hinto bi gʉ ngueꞌa̱ himi tsøta rá ora. ");
INSERT INTO oteNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pe ndunthi ya ja̱ꞌi de guehni bi gamfriꞌa̱ ne mi eñꞌʉ: ―Xi nu sta zøhø nura Cristo pa da nda̱, ¿ha gue ma da ꞌyøtꞌa maꞌra ya da̱nga ntꞌudi que núꞌa̱ øtꞌni? ");
INSERT INTO oteNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Y nuya fariseo mi ꞌyøde bi ma̱nga njabʉ ya ja̱ꞌi, nuꞌbʉ́ nuꞌʉ́ ne ya nda̱ gá macja̱ bi mɛhna ꞌraya gʉntsꞌa̱hni pa da gʉhma̱ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hangue ra Jesu bi ꞌñena: ―Ya tsꞌʉtho ya pa ma ga ꞌbʉi con gueꞌahʉ, nepʉ ma ga yo pengui habʉ bí ꞌbʉi núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma gui hyongaguihʉ pe hingui ma gui tsʉcaguihʉ, ne hinda za gui mahani habʉ ma ga ꞌbʉca. ");
INSERT INTO oteNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nuꞌbʉ́ ya nda̱ gá xodyo mi ꞌbʉhni bi ꞌñémbabi ꞌna ngu ꞌna: ―¿Habʉ ma dí mani ꞌbʉ pa ena gue ya hinda za ga tsʉhʉ? ¿Ha gue ma da ma pa ja yá hai ya me Grecia habʉ bí ꞌbʉi ma mixodyohʉ núꞌʉ xa nxani, ne ma dí xahna nehe ya me Grecia? ");
INSERT INTO oteNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Te rí bønga nuya noya xa ma̱ni ꞌbʉ, ena: “Ma gui hyongaguihʉ pe hingui ma gui tsʉcaguihʉ, ne hinda za gui mahani habʉ ma ga ꞌbʉca”? ");
INSERT INTO oteNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nurá nga̱tsꞌi ra pa de ra ngo go gueꞌa̱ maꞌna ra da̱ngo núꞌa̱ ra paꞌa̱, ra Jesu bi ꞌmai bi ña̱ ntsꞌɛdi ne bi ꞌñena: ―Nuꞌa̱ tóꞌo tsʉ ra nduthe dá ꞌñehe da zʉcagui pa da ntsithe. ");
INSERT INTO oteNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngu ma̱nga ja ra Ma̱ca Tꞌofo, nuꞌa̱ tóꞌo da gamfrigui ma da bøhø ra dehe dega te ja rá coraso ne da nja ngu ꞌnara da̱the. ");
INSERT INTO oteNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ra Jesu bi ma̱ de ra Ma̱ca Nda̱hi núꞌa̱ mi ma da tꞌumba nuto mi ma da gamfriꞌa̱. Pe nura Ma̱ca Nda̱hi hinxqui ꞌbɛhnitho, ngueꞌa̱ ra Jesu hinxqui menguitho ja rá nsunda nuni mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ha ya ja̱ꞌi mi ꞌyøde nuya ya noya, ꞌra mi ena: ―Xi majua̱ni go guehni rá da̱nga ꞌmɛhni Ajua̱ núꞌa̱ mi hma̱ da ꞌñehe. ");
INSERT INTO oteNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ha nu maꞌra mi ena: ―Go guehni ra Cristo rá ꞌmɛhni Ajua̱ bá e pa da nda̱. Ha nu maꞌra mi ena: ―¿Pe hanja? ¿Ha dra menguni Galilea ra Cristo? ");
INSERT INTO oteNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Hina. Ngueꞌa̱ ja ra Ma̱ca Tꞌofo ma̱ gue nura Cristo ma da ꞌñehe de yá ja̱ꞌi ndu ra Davi, ne ma dra me Belé nuni ja ra tꞌʉhnini habʉ mrá mengu ndu ra Davi. ");
INSERT INTO oteNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ne njabʉ ya ja̱ꞌi ꞌramaꞌnaꞌño mi ma̱ñꞌʉ de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ha nu ꞌra mi ne da zixhma̱ ntsꞌa̱hni, pe hinto bi gʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ha nuya gʉntsꞌa̱hni xqui ꞌbɛhni da gʉhma̱ ra Jesu bi mengui habʉ mi ꞌbʉ ya nda̱ gá macja̱ ne ya fariseo, ne bi tꞌembabi: ―¿Hanja hinguá tsihʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ha nuya gʉntsꞌa̱hni bi da̱di ne bi ꞌñena: ―¡Hindá tsihe ngueꞌa̱ dá ødehe ya hoga noya bi ma̱ núꞌa̱ hinhyaꞌmʉ stá øhe toꞌo xa ma̱ njabʉ! ");
INSERT INTO oteNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nuꞌbʉ́ nuya fariseo bi da̱di ne bi ꞌñembabiꞌʉ: ―¿Ha gue neꞌahʉ ya xa hyaꞌahʉꞌa̱? ");
INSERT INTO oteNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Guí pa̱hʉ gue ni ꞌna de guecje núje dyá nda̱he de ma nija̱hʉ ne dyá fariseohe hinstá camfrihe núꞌa̱ xa ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Núꞌʉ xa gamfriꞌa̱ go gueꞌʉ núꞌʉ hingui pa̱ ra ley, y go gueꞌʉ ya xa tꞌeque pa ra ꞌñʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ha nura Nicodemo mi ꞌbʉhni nehe xqui muntsꞌui yá mifariseoui, ne go gueꞌa̱ xqui ma dega xuui pa bá cꞌa̱ꞌtsa ra Jesu. Nuꞌbʉ́ nuꞌá̱ bi ꞌñembabi gatho núꞌʉ mi ꞌbʉhni: ");
INSERT INTO oteNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Pe numa leyhʉ ma̱ gue hinto tsa ga tsa̱mhʉ ntsꞌa̱hni ꞌbʉ hinda nja ra nthanthya̱ ꞌmɛtꞌo pa ga pa̱hʉ te ꞌbɛꞌa̱ xa ꞌyøtꞌe. ¿Ha gue njabʉ ma̱, o hina? ");
INSERT INTO oteNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nepʉ nuꞌʉ́ bi da̱tuabi ra Nicodemo ne bi ꞌñembabi: ―¿Ha gue neꞌi go grá me Galilea pa guí ne gui camfriꞌa̱? Hñeꞌta ra Ma̱ca Tꞌofo pa gui pa̱di gue joꞌo ni ꞌnará ꞌmɛhni Ajua̱ núꞌa̱ dra me Galilea. ");
INSERT INTO oteNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nepʉ gatho ya ja̱ꞌi bi ma yá nguꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ha ra Jesu bi ma ja ra tꞌøhø ꞌbo Olivo. ");
INSERT INTO oteNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nepʉ rá hyaxꞌa̱ bi menguiꞌa̱ maꞌnaꞌqui pa ja ra nda̱nija̱, ne ja bi muntsꞌuini gatho ya ja̱ꞌi, ne bi hñuhniꞌa̱ pa mi xahniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nepʉ nuya xahnate de ra ley ne ya fariseo bá tsimpabi ꞌnara ꞌbɛhña̱ xqui tsꞌʉdi mri hñuxui ꞌnara medintha̱ti, ne bri ꞌbaꞌma madetho habʉ mi ꞌbʉ ra Jesu co ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nepʉ nuꞌʉ́ bi ꞌñembabi: ―Xahnate, nuna ꞌbɛhña̱ bi tsꞌʉdi mri hñuxui ꞌnara medintha̱ti. ");
INSERT INTO oteNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nura Moise ꞌbɛpcahʉ ja rá ley gue ga hohʉ co ya ncꞌahni nuya ꞌbɛhña̱ ga tsʉhʉ di øtꞌa njabʉ. Xiꞌi, ¿te go xi guí ma̱ngue? ");
INSERT INTO oteNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Núꞌʉ́ bi ma̱nga njabʉ hønsɛ pa xa ꞌyødeꞌʉ te xa da̱di hma̱ha̱ ra Jesu, pa njabʉ xa za xa ña̱pahma̱. Ha nura Jesu bi ndoqui ne bi ꞌyofo ꞌraya noya ja ra hai co rá dedo. ");
INSERT INTO oteNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pe nuꞌʉ́ mi sigui mi ambabiꞌa̱, nuꞌbʉ́ nuꞌá̱ bi ꞌmai ne bi ꞌñembabiꞌʉ: ―Nuꞌa̱ tóꞌo hinxa ꞌyøtꞌa ni ꞌnara tsꞌoqui, dá føtua ꞌnara mʉdi ncꞌahni nuna ra ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ne bi yopa ndoquiꞌa̱ ne bi sigui bi ꞌñofo ja ra hai co rá dedo. ");
INSERT INTO oteNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ha nu mi ꞌyødeꞌʉ núꞌa̱ bi ma̱ñꞌa̱, bi zosɛ yá mfeni de yá tsꞌoquiꞌʉ, ne bi mʉdi bi maꞌʉ ꞌramaꞌna, rá mʉdi bi ma núꞌʉ maꞌna mi tsøxa yá jɛya, nepʉ gatho maꞌra, ne ra Jesu bi gosɛuini núꞌa̱ ra ꞌbɛhña̱ mi ꞌbahni madetho. ");
INSERT INTO oteNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nepʉ nura Jesu bi ꞌmai ne bi hyandi ya mi joꞌoni ni ꞌna, hønsɛ núꞌa̱ ra ꞌbɛhña̱ mi ꞌbʉhni, ne bi ꞌñembabiꞌa̱: ―Na̱ná̱, ¿habʉ ꞌba núꞌʉ toꞌo mi ña̱pꞌaꞌi? ¿Ha gue ya hinto ne da hyoꞌi dega ncꞌahni? ");
INSERT INTO oteNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ha nuꞌá̱ bi da̱di ne bi ꞌñena: ―Ya joꞌo, Ndada. Nuꞌbʉ́ nura Jesu bi ꞌñembabiꞌa̱: ―Nixi gueque hinte ma ga øꞌtꞌaꞌi. Grí ma, ne ya oxqui yopa øtꞌa maꞌra ya tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nepʉ ra Jesu bi yopa zofo ya ja̱ꞌi ne bi ꞌñembabiꞌʉ: ―Nuga go guecagui drá ñotꞌi dí yoꞌtua yá mfeni ya ja̱ꞌi. Nuꞌa̱ tóꞌo da dɛngagui hinda ꞌño ja ra ꞌbɛxuui, nuꞌá̱ da mɛꞌtsa ra ñotꞌi dega te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nepʉ nuya fariseo bi ꞌñembabiꞌa̱: ―Nuꞌi guí ma̱nsɛ gue toꞌoꞌigue, hangue hinga majua̱ni núꞌa̱ guí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―Masque dí ma̱nsɛ toꞌogui, pe gueꞌa̱ majua̱ni núꞌa̱ dí ma̱, ngueꞌa̱ nuga dí pa̱di habʉ stí ꞌñehe ne habʉ grá ma, pe nuꞌahʉ hinguí pa̱hʉ habʉ stí ꞌñehe ni habʉ grá ma. ");
INSERT INTO oteNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nuꞌahʉ gyá meximhaithohʉ, ne guí ha̱ nguɛndahʉ ngu núꞌa̱ guí bensɛhʉ. Pe nuga hinstá ehe pa to ga ha̱ꞌmba nguɛnda. ");
INSERT INTO oteNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pe nuꞌbʉ toꞌo dí ha̱ꞌmba nguɛnda, nuꞌbʉ́ núꞌa̱ dí ma̱ gueꞌa̱ majua̱ni, ngueꞌa̱ hingo dí ha̱nsɛ nguɛnda, go dí ha̱ꞌbe nguɛnda ma Dada núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nehe xa tꞌofo ja ri leyhʉ, nuꞌbʉ yoho ya ja̱ꞌi da damajua̱ni ne ꞌnada núꞌa̱ da ma̱ñꞌʉ, go gueꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nuga dí ma̱nsɛ toꞌogui, ne ma Dada núꞌa̱ toꞌo bá pɛncagui, neꞌa̱ damajua̱ni toꞌogui. ");
INSERT INTO oteNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ha nuꞌʉ́ bi ꞌñembabi: ―¿Habʉ bí ꞌbʉ ri Dada? Ha nura Jesu bi da̱di ne bi ꞌñena: ―Nuꞌahʉ hinguí pa̱cjʉ, hangue nixi ma Dada hinguí pa̱hʉ. ꞌBʉ gri pa̱hma̱hʉ toꞌoguiga, nehe gri pa̱hma̱hʉ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ra Jesu bi ma̱nga njabʉ nu de mi xahna ya ja̱ꞌi mbo ra ꞌmɛꞌtsboja̱ ja ra nda̱nija̱, pe hinto bi gʉ ntsꞌa̱hni ngueꞌa̱ mri ꞌbɛta rá oraꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ha nura Jesu bi yopa ꞌñembabiꞌʉ: ―Nuga ma ga maga, ha nuꞌahʉ ma gui hyongaguihʉ pe ya gra joꞌo, ne ma gui tuhʉ gri nduda ri tsꞌoquihʉ, hangue njabʉ hinda za gui mahani habʉ grá maga. ");
INSERT INTO oteNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ha nuya nda̱ gá xodyo bi ꞌñémsɛꞌʉ: ―¿Ha gue ma da hñosɛ ꞌbʉ? Hanja ena, “Hinda za gui mahani habʉ grá maga.” ");
INSERT INTO oteNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nepʉ nura Jesu bi ꞌñembabiꞌʉ: ―Nuꞌahʉ gyá meximhaihʉ, ha nuga drá mengu mahetsꞌi. Nuꞌahʉ yá mɛtiꞌihʉ nuna ra ximhai, ha nuga hingo rá mɛtigui nuna ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hangue dí xiꞌahʉ gue ma gui tuhʉ gri nduda ri tsꞌoquihʉ. Ngueꞌa̱ ꞌbʉ hingui camfriguihʉ gue go gueque ngu núꞌa̱ stá xiꞌahʉ, ma gui tuhʉ gri nduda ri tsꞌoquihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nepʉ nuꞌʉ́ bi ꞌñembabiꞌa̱: ―Xicje, ¿toꞌoꞌigue? Nepʉ nura Jesu bi ꞌñembabiꞌʉ: ―Ya stá xiꞌahʉ desde rá mʉdi toꞌogui. ");
INSERT INTO oteNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nuga masque jahma̱ maꞌra te ga xiꞌahʉ de ri ꞌmʉihʉ ne de núꞌa̱ xcá øthʉ, pe hønsɛ dí xiꞌahʉ ngu núꞌa̱ bi xicagui núꞌa̱ toꞌo bá pɛncagui, y nuꞌá̱ ma̱nga majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pe núꞌʉ mi øde, himbi ba̱di gue ra Jesu mi ña̱ de Ajua̱ ra Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hangue nura Jesu bi ꞌñembabiꞌʉ: ―Nu xcrí pøꞌtshʉ Núꞌa̱ Toꞌo e bi Nja̱ꞌi pa gui hyohʉ, gueꞌbʉ ma gui pa̱hʉ gue go gueque ngu núꞌa̱ stá xiꞌahʉ, ne ma gui pa̱hʉ gue hingo de ma tsꞌɛdi sɛhɛ núꞌa̱ dí øtꞌe, ngueꞌa̱ ngu núꞌa̱ xa xica ma Dada gueꞌa̱ dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ha numa Dada núꞌa̱ toꞌo bá pɛncagui ꞌbʉi con gueque, hinxa hyɛgasɛ, ngueꞌa̱ nza̱ntho dí øtꞌa núꞌa̱ di hoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nu mi ma̱nga njabʉ ra Jesu, bi gamfribiꞌa̱ ndunthi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ha nura Jesu bi xipabi nuya xodyo xqui gamfriꞌa̱, ne bi ꞌñembabi: ―Nuꞌbʉ gui sigui gui camfrihʉ ma noya, nuꞌbʉ́ xi majua̱ni go ma nxadiꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne ma gui pa̱hʉ núꞌa̱ majua̱ni, ha nuꞌbʉ gui pa̱hʉ núꞌa̱ majua̱ni, ya hingui ma gui ꞌmɛgohʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ha nuꞌʉ́ bi da̱di ne bi ꞌñembabiꞌa̱: ―Nuje go guecje yá ja̱ꞌiguihe ndu ra Abrá, ha hinhyaꞌmʉ stá ꞌmɛgohe. ¿Hanja guí ena gue ya hinga ma ga ꞌmɛgohe? ");
INSERT INTO oteNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nura Jesu bi da̱di ne bi ꞌñena: ―Xi majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo øtꞌa ya tsꞌoqui go gueꞌa̱ rá ꞌbɛgo ra tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ꞌNara tꞌʉ cohi pa nza̱ntho ja rá ngu, pe ꞌnara ꞌbɛgo da nja ra pa da bøni da ma. ");
INSERT INTO oteNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Njabʉtho nehe Núꞌa̱ Toꞌo e bi Nja̱ꞌi, ꞌbʉ da pøñꞌaꞌihʉ de ja rá ꞌyɛ ra tsꞌoqui, nuꞌbʉ́ dyá ba̱tsiꞌihʉ Ajua̱ ne ya hindyá ꞌbɛgoꞌihʉ ra tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nuga dí pa̱di gue nuꞌahʉ yá ja̱ꞌiꞌihʉ ndu ra Abrá. Pe nuꞌahʉ guí ne gui hyogaguihʉ ngueꞌa̱ hingrí hohʉ núꞌa̱ dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nuga dí ma̱nga núꞌa̱ xa xicagui ma Dada, ha nuꞌahʉ guí øthʉ ngu núꞌa̱ xa ma̱nga ri dadahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ha nuꞌʉ́ bi da̱di ne bi ꞌñembabi: ―Pe nuje ma dadahe ndu ra Abrá. Nuꞌbʉ́ nura Jesu bi ꞌñembabiꞌʉ: ―ꞌBʉ xi majua̱ni go dri dadahma̱hʉ ndu ra Abrá, nuꞌbʉ́ gri øthma̱hʉ ngu mi øtꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pe nuꞌahʉ guí ne gui hyogaguihʉ masque nuga go stá xiꞌahʉ núꞌa̱ ra noya xa xicagui Ajua̱. ¡Pe ndu ra Abrá himi øtꞌe ngu guí øthʉbya! ");
INSERT INTO oteNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nuꞌahʉ guí øthʉ ngu núꞌa̱ øtꞌa ri dadahʉ. Nuꞌbʉ́ nuꞌʉ́ bi ꞌñembabi ra Jesu: ―Nuje hingue toꞌoraza ma dadahe, ꞌnada núꞌa̱ ma dadahe, go gueꞌa̱ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ha nura Jesu bi ꞌñembabiꞌʉ: ―ꞌBʉ Ajua̱ go dri dadahma̱hʉꞌa̱, nuꞌbʉ́ gri ma̱cjhma̱hʉ, ngueꞌa̱ stá ehe de habʉ ndí ꞌbʉꞌbeꞌa̱. Ngueꞌa̱ hinstá esɛ, nuꞌá̱ go bá pɛncaguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Hanja hingui tso ri mfenihʉ núꞌa̱ dí xiꞌahʉ? Nuꞌahʉ hingui tso ri mfenihʉ ngueꞌa̱ hinguí ne gui ꞌyøhʉ núꞌa̱ dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ra tsꞌonda̱hi go gueꞌa̱ ri dadahʉ, ha nuꞌahʉ́ go yá ba̱tsiꞌihʉꞌa̱, ne nuꞌahʉ go guí nesɛhʉ gui ꞌyøꞌtuabihʉ núꞌa̱ di hoꞌa̱. Ne nuꞌá̱ go gueꞌa̱ ra hyote desde ra mʉdi. Nuꞌá̱ hønsɛ hatꞌa ya ja̱ꞌi ne hinhyaꞌmʉ xa ma̱nga núꞌa̱ majua̱ni. Nuya ncꞌuamba ma̱ñꞌa̱ go xa zansɛ, ngueꞌa̱ nuꞌá̱ xi ra cꞌuamba ne go gueꞌa̱ ra dada de ya ncꞌuamba. ");
INSERT INTO oteNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nuꞌahʉ hinguí camfriguihʉ ngueꞌa̱ dí ma̱nga núꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Toꞌo ꞌna de gueꞌahʉ da zʉtca ꞌnara tsꞌoqui? Joꞌo. Nuga dí xiꞌahʉ núꞌa̱ majua̱ni. Nuꞌbʉ́ ¿hanja hinguí ne gui camfriguihʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nuꞌa̱ tóꞌo rá mɛti Ajua̱ di ho da ꞌyøde núꞌa̱ ma̱nga Ajua̱. Nuꞌahʉ hingo yá mɛtiꞌihʉ Ajua̱, hangue hingrí hohʉ gui ꞌyøhʉ núꞌa̱ ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nepʉ ya xodyo bi da̱di ne bi ꞌñembabi: ―Nuꞌbʉ́, majua̱ni núꞌa̱ dí ma̱ñhe gue grá me Nsamaria, ne grí ꞌñoui ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―Hindrí ꞌñoꞌbe ra tsꞌonda̱hi. Nuga dí numansu ma Dada, pe nuꞌahʉ hinguí numansuguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pe nuga hindí ma̱nga njabʉ pa gui esca ma nsuhʉ, ngueꞌa̱ ꞌbʉi ꞌna toꞌo esca ma nsu, ne go ha̱ nguɛndaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Xi majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo øtcagui núꞌa̱ dí ma̱, hinhyaꞌmʉ da duꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nuꞌbʉ́ ya xodyo bi ꞌñembabi: ―Nubyá ha̱, dá pa̱he gue xi majua̱ni grí ꞌñoui ra tsꞌonda̱hi, ngueꞌa̱ nuꞌi guí ena gue nuꞌa̱ tóꞌo da ꞌyøꞌtꞌaꞌi núꞌa̱ guí ma̱, hinhyaꞌmʉ da du. Conque ra Abrá ne yá ꞌmɛhni Ajua̱ bi du. ");
INSERT INTO oteNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ha gue go maꞌna ja ri nsugue que ndu ma dadahe ra Abrá ne ndu yá ꞌmɛhni Ajua̱? Xiꞌaꞌigue ¿toꞌo go grí nhyɛcuaui? ");
INSERT INTO oteNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ha nura Jesu bi da̱di ne bi ꞌñena: ―Nuꞌbʉ gra exasɛ ma nsu, nuꞌbʉ́ hinte dri muui. Numa Dada go gueꞌa̱ esca ma nsu, núꞌa̱ guí emfʉ gue go gueꞌa̱ ri Ajua̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pe nuꞌahʉ́ nixi xcá pa̱hʉꞌa̱. Nuga ha̱, dí pa̱caꞌa̱. ꞌBʉ gra ena gue hindí pa̱caꞌa̱, nuꞌbʉ́ gra cꞌuambahma̱ ngu nuꞌahʉ. Nuga dí pa̱caꞌa̱, ne dí øte núꞌa̱ ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ndu ri dadahʉ ra Abrá mi ne co ꞌnara johya da hyandgagui ma ꞌmʉi nuya pa de ga ꞌyoua ja ra ximhai, ne xi bi johya mi hyandgaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ha nuya xodyo bi ꞌñembabiꞌa̱: ―Nixi made nthebe njɛya hinguí pɛꞌtstho, ¿ne guí ena gue gá hyanda ndu ra Abrá? ");
INSERT INTO oteNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ha nura Jesu bi ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ, desde ante da ꞌmʉi ra Abrá, nuga ya ndí ꞌbʉi. ");
INSERT INTO oteNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hangue nuꞌʉ́ bi gʉxa ya do pa da cꞌanhma̱ꞌa̱ ngueꞌa̱ mi nhyɛcuaui Ajua̱. Pe nura Jesu bi ꞌbampiꞌʉ bi ꞌranga madetho de gueꞌʉ ne bi bøni de ra nda̱nija̱ bi maꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ra Jesu mi ꞌyo ja ꞌnara ꞌñu, ne de guehni bi hyanda ꞌnara ꞌñøhø ya mrá goda desde rá ꞌbʉi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ha nuyá nxadi bi ꞌyambabi ne bi ꞌñena: ―Xahnate, ¿toꞌo bi ꞌyøtꞌa ꞌnara tsꞌoqui pa bi ꞌmʉi njani, nuni o rá dada o rá na̱na̱? ");
INSERT INTO oteNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nura Jesu bi da̱di ne bi ꞌñena: ―Hingo xa ꞌyøtꞌa ra tsꞌoquini, ni rá dada nixi rá na̱na̱ pa bi ꞌmʉi njani mrá goda. Xa njabʉ hønsɛ pa da hnequi rá tsꞌɛdi Ajua̱ de núꞌa̱ ma da tꞌøꞌtuabini. ");
INSERT INTO oteNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Núbya ma patho mahyoni ga pɛpa rá ꞌbɛfi núꞌa̱ toꞌo bá pɛncagui, ngueꞌa̱ ma da zø ra xuui, ne nuꞌbʉ́ ya hinda za to da mpɛfi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","De núbya dí ꞌbʉcua ja ra ximhai go guecagui drá ñotꞌi dí yoꞌtua yá mfeni ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nu mi uadi bi ma̱nga njabʉꞌa̱, bi zo rá jihni ja ra hai ne bi mantꞌa tsꞌʉ ra zi hai pa bi goꞌtsuabi ja yá da ra goda. ");
INSERT INTO oteNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ne bi ꞌñembabi: ―Grí ma bá nxʉca ja ra mothe Siloé. ―Nura thuhuꞌa̱ pøni da ꞌñena, xa ꞌbɛhni. Nepʉ nuꞌá̱ bi ma bá nxʉqui, ha nu mi mengui ya mi handi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nepʉ yá ꞌnangu ne núꞌʉ toꞌo xqui hyanda maꞌmɛtꞌo gue mrá godaꞌa̱ bi ꞌñémbabiꞌʉ: ―Go guehni mi hudi mi pɛti, ¿ha ngue ha̱? ");
INSERT INTO oteNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ha ꞌra mi ena: ―Go guehni. Ha nu maꞌra mi ena: ―Hina. Pøde rí hña̱tsꞌi ha̱, pe hingo guehni. Ha nuꞌá̱ bi da̱di ne bi ꞌñena: ―Majua̱ni go guecaguihma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nuꞌbʉ́ nuya ja̱ꞌi bi ꞌyambabi ne bi ꞌñembi: ―¿Hanja tsa guí handbya? ");
INSERT INTO oteNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nuꞌbʉ́ nuꞌá̱ bi da̱di ne bi ꞌñena: ―Núꞌa̱ ra ꞌñøhø rá thuhu ra Jesu go gueꞌa̱ bi gosca ra bøhai ja ma da ne bi ꞌñengagui: “Grí ma bá nxʉca Siloé.” Nepʉ nuga dá ma dá nxʉqui, hangue ꞌbestho ra oraꞌa̱ dá handi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ha nuꞌʉ́ bi ꞌyambabi ne bi ꞌñembi: ―¿Habʉ bí ꞌbʉꞌa̱? Ne nuꞌá̱ bi ꞌñena: ―Hindí pa̱di. ");
INSERT INTO oteNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nepʉ nuya ja̱ꞌiꞌʉ bi ziꞌtsua ya fariseo núꞌa̱ ra ꞌñøhø mrá goda. ");
INSERT INTO oteNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ha núꞌa̱ ra paꞌa̱ ra Jesu bi mantꞌa tsꞌʉ ra hai co rá jihni pa bi goꞌtsua yá da núꞌa̱ ra goda pa bi umba rá thandi, go mrá pa dega tsaya. ");
INSERT INTO oteNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nehe ya fariseo bi ꞌyambabi ra goda hanja xqui nja pa ya mi handi. Ne nuꞌá̱ bi ꞌñembabiꞌʉ: ―Núꞌa̱ ra ꞌñøhø rá thuhu ra Jesu bi gosca ra bøhai ja ma da, ne dá nxʉqui, y hangue dí handbya. ");
INSERT INTO oteNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ha nu ꞌraya fariseo bi ꞌñena: ―Núꞌa̱ ra ꞌñøhøꞌa̱ hinxqui ꞌñehe de Ajua̱ ngueꞌa̱ hingui jamasu ra pa dega tsaya. Pe nu maꞌra mi ena: ―Nuꞌbʉ ꞌnadra ꞌyøtꞌatsꞌoquihma̱, hinda za da ꞌyøtꞌa nuya ya da̱nga ntꞌudi nguna̱. Ne ꞌramaꞌnaꞌño mi ma̱ñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hangue nuꞌʉ́ bi yopa ꞌyøꞌtua ya ntꞌani ra goda ne bi ꞌñembabi: ―Xiꞌaꞌi, ¿te go guí ma̱ngue de núꞌa̱ toꞌo bi xocꞌa ri da? Nuꞌá̱ bi ꞌñena: ―Nuga dí ena gue go gueꞌa̱ ꞌnará ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pe nuya nda̱ gá xodyoꞌʉ himi camfri gue go mi gueꞌa̱ mrá goda ne ya xqui xo yá da, hangue nuꞌʉ́ bi zompa rá dada ne rá na̱na̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nepʉ bi ꞌyambabiꞌʉ ne bi ꞌñena: ―¿Ha go gueꞌa̱ ri tꞌʉhʉ guí ma̱ñhʉ gue ya mrá goda desde mi ꞌmʉi? ¿Hanja handbya ꞌbʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ha nurá dada ne rá na̱na̱ꞌa̱ bi da̱di ne bi ꞌñena: ―Dí pa̱he xá hño gue go gueꞌa̱ ma tꞌʉhe, ne desde mi ꞌmʉi ya mrá goda. ");
INSERT INTO oteNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pe hindí pa̱he hanja xa za xa hyandibya, nixi dí pa̱he toꞌo bi xocua yá da. Ya tsøxa yá jɛyaꞌa̱, go da ꞌyamfʉꞌa̱, nuꞌá̱ da za da xiꞌasɛhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Gueꞌa̱ bi da̱di rá dada ne rá na̱na̱ nguetho mi tsu yá nda̱ꞌʉ, ngueꞌa̱ nuyá nda̱ꞌʉ ya xqui go ꞌnara cohi gue nuꞌa̱ tóꞌo da ma̱ gue ra Jesu go gueꞌa̱ majua̱ni ra Cristo rá ꞌmɛhni Ajua̱ pa e da nda̱, núꞌá̱ da tꞌɛni de ja ra nija̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hangue nurá dada ne rá na̱na̱ xqui ꞌñena: “Ya tsøxa yá jɛyaꞌa̱, ne da za gui ꞌyambasɛhʉ.” ");
INSERT INTO oteNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ha nuya nda̱ gá xodyo bi yopa zohna núꞌa̱ mrá goda ne bi ꞌñembabi: ―Xøcambeni Ajua̱ ne xicje núꞌa̱ majua̱ni. Ngueꞌa̱ nuje dí pa̱he gue núꞌa̱ ra ꞌñøhøꞌa̱ toꞌo xa xocꞌa ri da, go gueꞌa̱ ꞌnara ꞌyøtꞌatsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ha nura goda bi da̱di ne bi ꞌñena: ―Nuga hindí pa̱di ua ra ꞌyøtꞌatsꞌoqui o hina. Hønsɛ núꞌa̱ dí pa̱di, gue ndrá goda, ha nubyá ya dí handi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ha nuꞌʉ́ bi yopa ꞌyambabiꞌa̱ ne bi ꞌñembi: ―¿Te bi ꞌyøꞌtꞌaꞌi núꞌa̱ ra ꞌñøhø mri xocꞌa ri da? ");
INSERT INTO oteNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nuꞌbʉ́ nuꞌá̱ bi da̱di ne bi ꞌñembabiꞌʉ: ―Ya stá xiꞌahʉ ne hinguí ne gui camfrihʉ. ¿Hanja guí ne ga yopa xiꞌahʉ maꞌnaꞌqui? ¿Ha guí nehʉ gue neꞌaꞌihʉ dyá nxadiꞌihʉꞌa̱? ");
INSERT INTO oteNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ha nuꞌʉ́ bi zaniꞌa̱ ne bi ꞌñembabi: ―Nuꞌi go rá nxadiꞌiꞌa̱, ha nuje yá nxadiguihe ra Moise. ");
INSERT INTO oteNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nuje dí pa̱he gue Ajua̱ mi ña̱ui ra Moise, pe nura ꞌñøhøꞌa̱ guí ena, hindí pa̱he habʉ xqui ꞌñeheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ha nura goda bi da̱di ne bi ꞌñembabiꞌʉ: ―¡Tengu gue nuꞌahʉ hinguí pa̱hʉ habʉ xqui ꞌñehe, ha nuꞌá̱ bi xoga ma da! ");
INSERT INTO oteNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ngueꞌa̱ dí pa̱hʉ gue Ajua̱ øtuabi yá tꞌadi núꞌa̱ toꞌo tsuꞌa̱ ne øꞌtuabi rá pahaꞌa̱, pe nuyá tꞌadi ya ꞌyøtꞌatsꞌoqui hingui øtuabi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ngueꞌa̱ hinhyaꞌmʉ stá øhʉ to xa xocua yá da ꞌnara ja̱ꞌi núꞌa̱ ya mrá goda desde mi ꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ꞌBʉ núꞌa̱ ra ꞌñøhøꞌa̱ hinxqui ꞌñehma̱ de Ajua̱, hinda za da ꞌyøthma̱ njabʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ha nuꞌʉ́ bi da̱di ne bi ꞌñembabi: ―Nuꞌi desde ngá ꞌbʉi ya ngrá ꞌyøtꞌatsꞌoqui, y njabʉ ¿xi nguí ne gui xancaguihe? Nepʉ nuꞌʉ́ bi ꞌyɛnga de ja ra nija̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ha nura Jesu bi ꞌyøde gue xqui tꞌɛnga de ja ra nija̱ núꞌa̱ mrá goda, bi hyoni, y nu mi yopa zʉdi bi ꞌñembabi: ―Nuꞌi, ¿ha guí camfribi rá Tꞌʉ Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nuꞌbʉ́ nuꞌá̱ bi da̱di ne bi ꞌñena: ―Ndada, ¿toꞌoꞌa̱ pa da za ga camfri? ");
INSERT INTO oteNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ha nura Jesu bi ꞌñembabiꞌa̱: ―Ya xcá hyandi, ne núꞌa̱ toꞌo guí ña̱uibya go guesɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nuꞌbʉ́ núꞌa̱ mrá goda bi ꞌñena: ―Ma zi Hmuꞌi, dí camfriꞌi. Ne ꞌbestho bi ndandiña̱hmu pa bi nsundaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ne ra Jesu bi ꞌñena: ―Nuga stá eheua ja nuna ra ximhai pa ga øtꞌa ra tsꞌʉtbi, pa nuꞌʉ tóꞌo xa ngoda ja yá mfeni, ga xocua yá mfeni pa da ba̱di, ha nuꞌʉ tóꞌo beni gue ja yá mfa̱di, nja ngu núꞌʉ toꞌo xa xo yá da, ga japi da ngodaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ha ꞌraya fariseo núꞌʉ mi ꞌbahuiniꞌa̱ bi ꞌyøde núꞌa̱ te mi ma̱ñꞌa̱, ne bi ꞌñembabi: ―¿Ha gue necje dyá godahe? ");
INSERT INTO oteNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―ꞌBʉ gri godahma̱ha̱hʉ, nuꞌbʉ́ hingri tuhma̱ ri tsꞌoquihʉ. Pe nuꞌahʉ́ guí eñhʉ gue guí hanthʉ, hangue grí tuhʉ ri tsꞌoquihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Xi majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo hingui cʉtꞌa ja ra gosthi nguꞌño, ne tontsꞌa maꞌna lado pa da yʉtꞌi, go gueꞌa̱ ꞌnara be ne ꞌnara dacate. ");
INSERT INTO oteNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Núꞌa̱ toꞌo taca ya dɛti, go gueꞌa̱ ra maꞌyo, ne go gueꞌa̱ cʉtꞌa po ja ra gosthi. ");
INSERT INTO oteNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nura nsugosthi xoca ra gosthi pa da yʉtꞌa ra maꞌyo, ha nuya dɛti pa̱tuatho rá noya, ha nuꞌá̱ da zopa yá thuhu núꞌʉ yá mɛtiꞌa̱ pa da pøniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ha nu stí pønga gatho nuyá mɛtiꞌa̱, nuꞌá̱ di ꞌbɛtꞌo ne maꞌtiꞌʉ, ne nuyá dɛti di dɛniꞌa̱ ngueꞌa̱ pa̱tuatho rá noya. ");
INSERT INTO oteNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngueꞌa̱ nuya dɛti hingui tɛna maꞌnaꞌño ra maꞌyo, nuꞌʉ́ da neꞌtsua ra ꞌrihi da ma, ngueꞌa̱ hingui pa̱tua rá noyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ra Jesu bi xipabiꞌʉ nuna ra ꞌbede, pe nuꞌʉ́ himbi zo yá mfeni te mri bønga núꞌa̱ bi xipabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nepʉ ra Jesu bi yopa ꞌñembabiꞌʉ: ―Xi majua̱ni dí xiꞌahʉ, nuga go guecagui drá gosthi habʉ thogui ya dɛti. ");
INSERT INTO oteNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gatho núꞌʉ toꞌo bá ꞌbɛtꞌo de gueque go gueꞌʉ myá be ne myá dacate ngueꞌa̱ mi ne da hyatꞌa ma dɛti pa da dɛniꞌʉ. Pe numa dɛti himbi ꞌyøtuabi núꞌa̱ mi ma̱ñꞌʉ, ngueꞌa̱ hingo myá mɛtiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nuga go guecagui drá gosthi. Nuꞌa̱ tóꞌo da yʉtꞌa ja nuna ra gosthina̱ da mpøhø, ne nuꞌá̱ da nja ngu ꞌnara zi dɛti di cʉtꞌi di pøni pa da ñuni. ");
INSERT INTO oteNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ꞌNara be bí ehe hønsɛ pa da mpe, ne pa da hñote, ne pa da huata ra taxo. Pe nuga stá ehe pa ga umba yá te ya ja̱ꞌi, ne nura teꞌa̱ go ꞌnara hoga te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nuga go guecagui drá hoga maꞌyo, ngueꞌa̱ ꞌnara hoga maꞌyo da unga rá te po rá ngue yá dɛti. ");
INSERT INTO oteNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pe ꞌnara maꞌyo ꞌmɛgo núꞌa̱ su ya dɛti hønsɛ pa da hña̱nga rá tha̱ha̱, nuꞌá̱ ꞌbʉ da hyanda ꞌnara miꞌño bra ꞌñehe pa e da za ya dɛti, nuꞌá̱ da neꞌtsua ra ꞌrihi da ma ne da zopʉ ya dɛti ngueꞌa̱ hingo yá mɛti y hingo xi majua̱ni yá maꞌyoꞌʉ. Ha nura miꞌño da pɛntꞌi ꞌraya dɛti, ha nu maꞌra habʉraza da nxaniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Njabʉ núꞌa̱ ra maꞌyo ꞌmɛgo da nestꞌihi da ma ngueꞌa̱ hingui tu rá mʉi de ya dɛti ngueꞌa̱ nuꞌá̱ ꞌnara ꞌbɛgotho. ");
INSERT INTO oteNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nuga go guecagui drá hoga maꞌyo. Ngu pa̱cagui ma Dada ne dí pa̱caꞌa̱, njabʉ nehe dí pa̱di ma dɛti ne nuꞌʉ́ pa̱cagui nehe, ngueꞌa̱ ma mɛtigaꞌʉ, ne ma ga unga ma te po rá ngueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nehe ꞌbʉi maꞌra ma dɛti núꞌʉ hingyá mengu de nuna ra nguꞌño, ne nuꞌʉ́ mahyoni ga tsi nehe. Ne nuꞌʉ́ da ꞌyøscagui nu xcrá zofo, ne da ꞌñeheꞌʉ, ne njabʉ da ꞌnadra taxo ne da ꞌnadra maꞌyo, y nura maꞌyoꞌa̱ go guecsɛgui. ");
INSERT INTO oteNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ajua̱ ma Dada xi ri ma̱cagui ngueꞌa̱ ma ga unga ma te pa ga tu, ha nu xcrá tu, ma ga yopa nte maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pe hinto ma da hña̱ga ma te, ma ga tusɛ. Dí ha̱ ra tsꞌɛdi pa ga tusɛ, ne dí ha̱ ra tsꞌɛdi pa ga yopa nte maꞌnaꞌqui. Njabʉ bá ꞌbɛpcagui ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ha nuya xodyo ꞌramaꞌnaꞌño mi ma̱nga maꞌnaꞌquiꞌʉ ngueꞌa̱ bi ꞌyøde te mi ma̱nga ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ndunthi de gueꞌʉ bi ꞌñena: ―Nuní ꞌñoui ra tsꞌonda̱hi ne xa ꞌbɛ rá mfeni. ¿Hanja guí øxhʉ núꞌa̱ te ma̱? ");
INSERT INTO oteNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ha nu maꞌra mi ena: ―Nuya noya ma̱ni hingyá noya dega tsꞌonda̱hi. ¿Ha gue ra tsꞌonda̱hi da za da xocuahma̱ yá da ꞌnara goda? ");
INSERT INTO oteNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ne nuni Jerusale ja bi tꞌøtꞌni ꞌnara ngo, ne núꞌa̱ ra ngoꞌa̱ gueꞌa̱ ꞌnara feni de núꞌa̱ ra pa bi yopa ꞌnaꞌyo maꞌnaꞌqui ra nda̱nija̱ núꞌa̱ xqui yopa tha̱ni. Ha nuya paꞌʉ myá pa dega tsɛ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ha ra Jesu mi ꞌyoni ja ra porta núꞌa̱ mrá thuhu Salomó, go ꞌnamrá porta núꞌa̱ ra nda̱nija̱ꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ha nuya nda̱ gá xodyo bi ꞌyɛntꞌa madethoꞌa̱ ne bi ꞌyambabi: ―¿Haꞌmʉ ma gui hñubga ma mʉihe? ꞌBʉ xi majua̱ni go gueꞌe grá Cristo rá ꞌmɛhniꞌi Ajua̱ pa gui nda̱, xi da xicje majua̱ni pa ga pa̱he. ");
INSERT INTO oteNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nuꞌbʉ́ ra Jesu bi da̱tuabiꞌʉ ne bi ꞌñembi: ―Ya stá xiꞌaꞌihʉ ne nuꞌahʉ́ hinxcá camfrihʉ. Nuya ꞌbɛfi dí pɛfi de rá thuhu ma Dada, go gueꞌʉ udi toꞌogui. ");
INSERT INTO oteNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pe nuꞌahʉ hinguí camfrihʉ nguetho hingo ma dɛtiꞌihʉ, ngu ya stá xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Numa dɛtiga øde núꞌa̱ dí ma̱, ne nuga dí pa̱caꞌʉ, ne nuꞌʉ́ tɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nuga dí umbabiꞌʉ ra te pa nza̱ntho, ne hinhyaꞌmʉ da ꞌmɛdi, nixi hinto da zingagui de ma ꞌyɛ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Numa Dada núꞌa̱ toꞌo xa ꞌracaguiꞌʉ, maꞌna ja rá tsꞌɛdi de gatho, ne hinda za to da zinbabiꞌʉ de rá ꞌyɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nuga ne ma Dada dí ꞌnathoꞌbe. ");
INSERT INTO oteNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nu mi ña̱ njabʉ nura Jesu, nuya nda̱ gá xodyo bi yopa gʉxa ya do pa xa hyohma̱ dega ncꞌahniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Ndunthi ya hoga ꞌbɛfi stá øtꞌe ja ri thandihʉ núꞌʉ xpá ꞌñehe de ma Dada. ¿Ndaꞌa̱ de gue núꞌʉ ya ꞌbɛfi stá øtꞌe hinxá hño pa guí ne gui cꞌancahʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nuꞌbʉ́ nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Hinga po rá ngue ꞌnara hoga ꞌbɛfi dí ne ga cꞌanꞌahe, hønsɛ ngueꞌa̱ guí ha̱cuabi rá nsu Ajua̱, ngueꞌa̱ nuꞌi ꞌnagrá ꞌñøhø nguje ne grí nhyɛcuaui Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―Xa tꞌofo ja ri leyhʉ gue Ajua̱ bi zofo ya nzaya núꞌʉ xqui hñutsꞌiꞌa̱, ne bi ꞌñembiꞌʉ: “Nuꞌahʉ gyá ajua̱hʉ.” ");
INSERT INTO oteNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Y núꞌa̱ xa tꞌofo ja ra Ma̱ca Tꞌofo hingui tsa to da ma̱ gue hinga majua̱ni. Ya gue Ajua̱ bi ꞌñembabi gue go ya ajua̱ núꞌʉ toꞌo bi hña̱ni rá noyaꞌa̱, ");
INSERT INTO oteNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","xihma̱ núꞌa̱ toꞌo bi hñuxa Ajua̱ ne bá pɛhniua ja ra ximhai, ¿hanja guí ma̱ñhʉ gue ha̱cua rá nsu Ajua̱ ngueꞌa̱ bi ꞌñena gue rá Tꞌʉꞌa̱? ");
INSERT INTO oteNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nuga dí øtꞌa ya tꞌøtꞌe ngu øtꞌa ma Dada. Pe nuꞌbʉ hindí øtꞌa ngu øtꞌa ma Dada, oguí camfriguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pe nuga dí øtꞌa ya tꞌøtꞌe núꞌʉ bí ehe ja ma Dada, hangue masque hingo gui camfriguihʉ gue go gueque ngu núꞌa̱ stá xiꞌahʉ, go da camfrihʉ gue núꞌʉ ya tꞌøtꞌe dí øtꞌe bí ehe de Ajua̱, pa njabʉ nehe xi da hñu ri mʉihʉ gui pa̱hʉ gue Ajua̱ ma Dada ꞌbʉi con gueque ne nuga dí ꞌbʉi con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nuꞌbʉ́ ya nda̱ gá xodyo maꞌnaꞌqui bi ꞌramanu pa xa gʉhma̱ꞌa̱, pe nuꞌá̱ bi maꞌa̱, himbi za te bi ꞌyøꞌtuaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nepʉ nura Jesu bi mengui pa riꞌnandi ra da̱the Jordá habʉ mi øtꞌa ra sistehe ra Xuua maꞌmɛtꞌo, ne ja bá ꞌbʉhniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne ndunthi ya mengu de guehni bi ma bá cꞌa̱ꞌtsi ne mi eñꞌʉ: ―Nura Xuua hinte ma da̱nga ntꞌudi bi ꞌyøtꞌe, pe gatho núꞌa̱ bi xicjʉ de ra Jesu, majua̱ni xa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y ja guehni ndunthi ya ja̱ꞌi bi gamfri gue ra Jesu go mi gueꞌa̱ xpá mɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Y de mi ꞌbʉhni ra Jesu riꞌnandi ra da̱the Jordá, gueꞌbʉ mri hñenga ꞌnara ꞌñøhø mrá thuhu ra Lasaro mrá me Betania nuni habʉ mrá mengu nehe ra Maria ne ra Marta núꞌʉ myá njuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Núꞌa̱ ra Maria mrá nju nura Lasaro go gueꞌa̱ bi goꞌtsuabi ra hoga ñʉni ja yá ua ra Jesu, nepʉ bi oꞌtuabi co yá sta̱ꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Núꞌʉ ya ꞌbɛhña̱ mri ncu bi mɛmpa ra noya ra Jesu gue da tꞌembi: ―Ma zi Hmuꞌi, núꞌa̱ ri hma̱di di hñeni. ");
INSERT INTO oteNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ha nu mi sipabi ra Jesu njabʉ, bi ꞌñenaꞌa̱: ―Núꞌa̱ ra hñeniꞌa̱ hingue xi pa da duꞌa̱. Xa njabʉ pa da hnequi rá nsunda Ajua̱, ne da hnequi rá nsunda rá Tꞌʉ Ajua̱ po rá ngueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ha nura Jesu xi mri ma̱di gatho núꞌʉ hñu mri ncu. ");
INSERT INTO oteNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Masque myá hma̱diꞌʉ ne bi ꞌyøde gue ra Lasaro mri hñeni, pe ra Jesu hinga ꞌbestho bi ma, bá ꞌbʉhnitho má yo pa habʉ mi ꞌbʉiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nepʉ ja ꞌmɛfa nuꞌá̱ bi ꞌñembabi yá nxadi: ―Maha pa Judea maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ha nuyá nxadi bi ꞌñembabi: ―Xahnate, guí nu ya nda̱ gá xodyo de guehni ja mahaꞌmʉ mi ne xa hyoꞌaꞌi dega ncꞌahni. ¿Ha nuꞌi guí ne gui yopa mani maꞌnaꞌqui? ");
INSERT INTO oteNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nepʉ nura Jesu bi da̱di ne bi ꞌñembabiꞌʉ: ―¿Ha hinguí pa̱hʉ pɛꞌtsa ꞌrɛtꞌamayoho ora cada ra pa? Y nuꞌa̱ tóꞌo da ꞌño dega pa hinda hña̱xa ꞌnara mfeꞌtse, ngueꞌa̱ zø ra ñotꞌi ja ra ximhai, go gueꞌa̱ núꞌa̱ toꞌo øꞌtua rá paha Ajua̱ ne hinxa juatatho ra ꞌbɛfi núꞌa̱ bi umbi. ");
INSERT INTO oteNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pe nuꞌa̱ tóꞌo da ꞌño dega xuui da hña̱xa ra mfeꞌtse ngueꞌa̱ otho ra ñotꞌi, go gueꞌa̱ núꞌa̱ toꞌo hingui øꞌtuabi rá paha Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mi uadi bi ma̱nga njabʉ ra Jesu ne bi ꞌñembabiꞌʉ: ―Ma amigohʉ ra Lasaro bí a̱ha̱, pe nuga ma ga mani pa ga a de rá tꞌa̱ha̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ha nuya nxadi bi ꞌñembabi: ―Ma zi Hmuꞌihe, ꞌbʉ a̱ha̱, nuꞌá̱ ma da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pe nura Jesu mi ma̱ gue xqui du ra Lasaro, ha nuꞌʉ́ mi hu yá mʉi gue mi ma̱ de ra tꞌa̱ha̱tho. ");
INSERT INTO oteNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nuꞌbʉ́ ra Jesu bi xipabiꞌʉ de núꞌa̱ xqui nja ne bi ꞌñena: ―Ra Lasaro xa du. ");
INSERT INTO oteNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ne nuga xi drí johya ngueꞌa̱ dá njoꞌoni ora mi hñeni, ngueꞌa̱ go ꞌnara hño pa gueꞌahʉ, ngueꞌa̱ po rá ngueꞌa̱ maꞌna ma gui camfriguihʉ. Maha, ma ga cꞌa̱ꞌtshʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nepʉ nura Toma núꞌa̱ mi tꞌembi ra Go, bi ꞌñemba yá minxadiui: ―Maha nehe pa grá tuhʉ mahyɛgui con guehni. ");
INSERT INTO oteNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ha nu mi zønga ra Jesu ja ra hnini Betania, bi sipabi gue ya mi pɛꞌtsa goho ma pa xqui tꞌagui ra Lasaro. ");
INSERT INTO oteNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ha nura zi hnini Betania mi guetbʉ Jerusale mi pɛꞌtsa ngu hñu kilometro rá ñabʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ha xi ndunthi yá mixodyoui xqui ma da cꞌa̱ꞌtsa ra Marta ne ra Maria pa da hñuꞌmba yá mʉi ngueꞌa̱ xqui du yá cuꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ha nu mi ꞌyøde ra Marta gue ya mi ma da zønga ra Jesu ja yá nguꞌʉ, bi ma bá tha̱di, pe nura Maria bi gotritho ja rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nepʉ ra Marta bi ꞌñembabi ra Jesu: ―Ma zi Hmuꞌi, nuꞌbʉ gri ꞌbʉhma̱ua hinxa duhma̱ ma cu. ");
INSERT INTO oteNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pe masqué, nuga dí pa̱di gue gatho núꞌa̱ te gui apabi Ajua̱, nuꞌá̱ da ꞌraꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ha ra Jesu bi ꞌñembabi: ―Ri cu ma da nangui de rá du. ");
INSERT INTO oteNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nepʉ nura Marta bi ꞌñembabi: ―Dí pa̱di gue ma da nangui de rá du núꞌa̱ ra pa de ra nga̱xhmai stí nanga gatho núꞌʉ maꞌra xa du. ");
INSERT INTO oteNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nura Jesu bi ꞌñembabi: ―Nuga ga jʉxa núꞌʉ xa du ne ga umbabiꞌʉ ra te. Nuꞌa̱ tóꞌo da gamfrigui, masque xa du, nuꞌá̱ ma da nja rá te. ");
INSERT INTO oteNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne nuꞌa̱ tóꞌo ꞌbʉi ne camfrigui, hinhyaꞌmʉ da du. Xiꞌi, ¿ha gue guí camfri njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nepʉ nura Marta bi ꞌñembabi: ―Ha̱ha̱, ma zi Hmuꞌi, nuga dí camfri gue go gueꞌe grá Cristo, rá Tꞌʉꞌi Ajua̱, go gueꞌe ndí tøpꞌaꞌihe pa gui ꞌñehe nuua ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ha ngu mi ma̱nga njabʉ ra Marta, ꞌbestho bi mengui pa bá umba ntꞌøde ra Maria rá cu, ne bi xipi zi njante pa hinto da ꞌyøde maꞌra, ne bi ꞌñembabi: ―Xa zø ra Xahnate bí tøpꞌaꞌi ꞌna̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ha nu mi ꞌyødeꞌa̱ bi da̱ma ꞌmai ne bi ma bá cꞌa̱ꞌtsiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ne nura Jesu hinxqui yʉtꞌatho mbo ra hnini, ja bi gotritho habʉ xqui ma da da̱di hma̱ha̱ ra Marta. ");
INSERT INTO oteNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ha nuya xodyo núꞌʉ mi ꞌbʉhni ja rá ngu ra Maria mi huꞌmba rá mʉi, ngu xi bi hyandiꞌʉ gue ra Maria bi da̱ma ꞌmai ne bi bøni de rá ngu, nuꞌʉ́ bi dɛni ne mri ꞌñémbabiꞌʉ ꞌna ngu ꞌna: ―Nuni rí ma da nzoni habʉ bí tꞌagui rá cu. ");
INSERT INTO oteNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nepʉ ra Maria bi zøni habʉ mi ꞌbʉ ra Jesu, y ngu bi hyandi bi ndandiña̱hmu ja yá uaꞌa̱ ne bi ꞌñembabi: ―Ma zi Hmuꞌi, nuꞌbʉ gri ꞌbʉhma̱ua hinxa duhma̱ ma cu. ");
INSERT INTO oteNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ha nu mi hyanda ra Jesu gue ra Maria xi mi zoni ne núꞌʉ ya xodyo mbra ꞌñoui mi zoniꞌʉ nehe, nuꞌbʉ́ nuꞌá̱ bi ntsøꞌmi ne bi du rá mʉi. ");
INSERT INTO oteNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nepʉ bi ꞌñenaꞌa̱: ―¿Habʉ xcá aguihʉꞌa̱? Ha nuꞌʉ́ bi ꞌñembabi: ―Ma zi Hmuꞌihe, maha ma ga uꞌtꞌahe. ");
INSERT INTO oteNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nepʉ ra Jesu bi nzoni. ");
INSERT INTO oteNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ha nuya xodyo bi ꞌñémsɛꞌʉ: ―A, xi mri ma̱dihma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pe ꞌra de gueꞌʉ bi ꞌñena: ―Nuni go guehni bi xocua yá da núꞌa̱ ra goda. ¿Ha hinxa zahma̱ xa ꞌyøtꞌe nehe pa hinxa duhma̱ ra Lasaro? ");
INSERT INTO oteNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ha nura Jesu bi yopa du rá mʉi, nepʉ bi zøni habʉ xqui tꞌagui ra Lasaro. Xqui thiꞌtsi ja ꞌnara cʉtsꞌi, ne mi jotꞌi co ꞌnara xingdo. ");
INSERT INTO oteNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ha ra Jesu bi ꞌñena: ―Hña̱cjʉ ra do. Ha nura Marta núꞌa̱ mrá cu núꞌa̱ xqui du bi ꞌñembabi: ―Ma zi Hmuꞌi, ya strá nxa̱ ngueꞌa̱ ya pɛꞌtsa goho ma pa de xa du. ");
INSERT INTO oteNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ha ra Jesu bi ꞌñembabi ra Marta: ―¿Ha gue hinstá xiꞌaꞌi gue nuꞌbʉ gui camfri ma gui hyandua rá nsunda Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nepʉ nuya ja̱ꞌi bi hña̱ca núꞌa̱ ra do xqui jotꞌa ra ntꞌagui. Nepʉ nura Jesu bi nøtsꞌe pa mahetsꞌi ne bi ꞌñena: ―Ma Dadaꞌi, dí ꞌraꞌaꞌi ra jama̱di ngueꞌa̱ xcá ꞌyøde núꞌa̱ stá aꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nuga dí pa̱di nza̱ntho guí øde núꞌa̱ dí aꞌaꞌi. Pe dá ma̱nga njabʉ po rá ngue ya ja̱ꞌi ꞌbʉcua con gueque, pa njabʉ da za da gamfriyʉ gue go gueꞌe xcá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ha mi uadi bi ꞌyapa Ajua̱ njabʉ, nepʉ bi ña̱ ntsꞌɛdi bi ꞌñena: ―¡Lasaro, bá pøni! ");
INSERT INTO oteNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ha ra Lasaro ꞌbestho bá pøni mi ꞌbantꞌa yá ꞌyɛ ne yá ua co ꞌraya xʉni dutu, ne mi ꞌbantꞌa rá ña̱xu co maꞌna ra dutu. Ha ra Jesu bi ꞌñembabi ya ja̱ꞌi: ―Xoꞌtuahʉ ya xʉni dutu. ");
INSERT INTO oteNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nuꞌbʉ́ núꞌʉ ya xodyo mri ꞌñoui ra Maria mi hyanda núꞌa̱ bi ꞌyøtꞌa ra Jesu, ndunthi de gueꞌʉ bi gamfriꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pe ꞌra bi ma bá xipabi ya fariseo núꞌa̱ te xqui ꞌyøtꞌeꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nuꞌbʉ́ nuya nda̱ gá macja̱ ne ya fariseo bi ꞌyøtꞌa ꞌnara hmuntsꞌi ne bi ꞌñena: ―¿Te ga øthʉ? Ngueꞌa̱ nura ꞌñøhøꞌa̱ xi øtꞌa ndunthi ya da̱nga ntꞌudi. ");
INSERT INTO oteNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nuꞌbʉ ga hoptahʉ njabʉ, gatho ya ja̱ꞌi da gamfriꞌa̱, ne ꞌmɛfa da ꞌñehe ya me Nroma da hña̱nga ma nija̱hʉ ne da zinga ma ja̱ꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pe ꞌna de gueꞌʉ mrá thuhu ra Caifá mrá da̱nga nda̱ gá macja̱ núꞌa̱ ra jɛyaꞌa̱, nuꞌá̱ bi ꞌñembabiꞌʉ: ―Nuꞌahʉ hinte ri fa̱dihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Ha hinguí pa̱hʉ gue maꞌna xá hño da du ꞌnada ra ꞌñøhø pa hinda du gatho ya ja̱ꞌi, pa njabʉ hinda ꞌmɛdi ya ja̱ꞌi mengu ma haihʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pe núꞌa̱ ra Caifá himbi bensɛ núꞌa̱ bi ma̱. Pe ngueꞌa̱ mrá da̱nga nda̱ gá macja̱ núꞌa̱ ra jɛyaꞌa̱, Ajua̱ bi umbabi nuya ya noya, hangue bi ma̱ gue ra Jesu mi ma da du po rá ngue ya me Judea. ");
INSERT INTO oteNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y hingue hønsɛ po rá ngue ya menguni, pe nehe pa gatho yá ba̱tsi Ajua̱ núꞌʉ xa nxani habʉraza de ra ximhai, pa da ꞌnathoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hangue de gueꞌbʉ bi ꞌñʉꞌtiꞌʉ pa hanja da hyohma̱ꞌʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hangue ra Jesu ya himbi sigui bi ꞌño habʉraza pa bi ña̱ ja yá thandi ya xodyo, ne bi ma de guehni Judea pa ja ꞌnara tꞌʉca hnini rá thuhu Efraí, guetbʉ habʉ ja ꞌnara ꞌyoꞌmtha, ne ja bá ꞌbʉhuini yá nxadi. ");
INSERT INTO oteNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ha ya mi ma da datꞌa ra pa de ra pascua ꞌnará ngo ya xodyo, y ndunthi ya ja̱ꞌi de habʉraza ya zi tꞌʉhnini bi ma Jerusale ante ra ngo pa da ntꞌaxqui ngu myá nza̱iꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ne go gueꞌʉ mi ꞌyo mi honga ra Jesu, y de mi ꞌbʉhni ja ra nda̱nija̱, mri ꞌñémsɛꞌʉ: ―¿Te guí beñhʉ? ¿Ha gue hinda ꞌñecua ja ra ngoꞌa̱ ꞌbʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ha ya nda̱ gá macja̱ ne ya fariseo xqui manda gue nuꞌbʉ toꞌo da ba̱di habʉ di ꞌyoꞌa̱ da xipabiꞌʉ, pa da gʉ ntsꞌa̱hniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Y mri ꞌbɛ ꞌrato ma pa pa da datꞌa ra ngo de ra pascua, nura Jesu bi ma pa Betania habʉ mi ꞌbʉ ra Lasaro núꞌa̱ xqui gʉtsꞌi de rá du. ");
INSERT INTO oteNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y ja bi tꞌøꞌtuani ꞌnara ntꞌoxi ra Jesu. Ra Marta go mrá møxmexa, ne nura Lasaro mi huhuini ra Jesu ja ra mexa co maꞌra ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nepʉ ra Maria mri hña̱ nde litro ra hoga ñʉni mi ꞌraꞌta ra nardo ne xi mri muui ndunthi, ne bi goꞌtsuabi ja yá ua ra Jesu, nepʉ bi oꞌtuabi co yá sta̱, ne bi mfontꞌa núꞌa̱ ra ñʉni gatho mbo ra ngu. ");
INSERT INTO oteNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nuꞌbʉ́ ra Juda Iscariote núꞌa̱ mrá tꞌʉ ra Simu ne ꞌnamrá nxadi ra Jesu, ne go gueꞌa̱ mi ma da daꞌa̱, bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Hanja himbi ꞌba núꞌa̱ ra hoga ñʉniꞌa̱ xi xá ma̱di? Xa za xa ꞌbahma̱ po hñu nthebe denario, ne nura boja̱ꞌa̱ xa thecuahma̱ ya zi hyoya. ");
INSERT INTO oteNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nura Juda bi ma̱ njabʉ ngueꞌa̱ mrá be, ne ngueꞌa̱ go mi pɛꞌtsa ra ncʉboja̱ ne mi jʉ núꞌa̱ go mi ne de ja ra buxa, ne hingue xi majua̱ni mri hueca ya hyoyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pe nura Jesu bi ꞌñembabi ra Juda: ―Ote guí xipabi. Nuní bi goscagui nuna ñʉni ja ma ua pa nura paꞌa̱ de ma ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ngueꞌa̱ nuya hyoya nza̱ntho ma da ꞌmʉi con gueꞌahʉ, pe nuga hinga nza̱ntho ma ga ꞌbʉiua con gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nepʉ xi ndunthi ya xodyo bi sipabi gue ra Jesu mi ꞌbʉhni Betania, ne bi maꞌʉ pa bá cꞌa̱ꞌtsiꞌa̱, y hingue hønsɛ pa da cꞌa̱ꞌtsa ra Jesu, nehe pa bá handa ra Lasaro núꞌa̱ xqui gʉxa ra Jesu de rá du. ");
INSERT INTO oteNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nuꞌbʉ́ nuya nda̱ gá macja̱ bi ꞌñʉꞌti pa da hyohma̱ ra Lasaro nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ngueꞌa̱ po rá ngue ra Lasaro ndunthi ya xodyo xqui ꞌuegue de gueꞌʉ ne bi gamfriꞌʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ha nurá hyaxꞌa̱ gatho ya ja̱ꞌi núꞌʉ xqui ma ra ngo de ra pascua nuni Jerusale bi ꞌyøde gue ra Jesu mi ma da zøni de guehni. ");
INSERT INTO oteNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ne nuꞌʉ́ bi doca ya dɛnthi ne bi ma bá tha̱di ra Jesu ne mi mantaꞌʉ mi ena: ―¡Xá nsunda Ajua̱! ¡Ajua̱ da ja̱pi nuni toꞌo bá ehe de rá thuhuꞌa̱! ¡Ajua̱ da ja̱pi nuni ma Nda̱hʉ nújʉ dyá me Israelhʉ! ");
INSERT INTO oteNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ha nura Jesu bi zʉdi ꞌnara zi tꞌʉbru ne bi tøgueꞌa̱ pa bi nja ngu núꞌa̱ xqui tꞌofo ja ra Ma̱ca Tꞌofo habʉ ena: ");
INSERT INTO oteNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Oxqui ntsuhʉ, núꞌahʉ gyá menguhʉ Sión; ndi, hyanthʉ, xa ꞌñepʉ ri Nda̱hʉ, bra tøgue ꞌnara zi tꞌʉbru. ");
INSERT INTO oteNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ha nuyá nxadi hinga ꞌbestho ra oraꞌa̱ bi zo yá mfeni hanja xqui njabʉ. Pe núꞌbʉ mi yopa nte ra Jesu ne bi yopa menga mahetsꞌi, nuꞌbʉ́ ha̱, bi beni yá nxadi gue xqui tꞌofo njabʉ de gueꞌa̱, ne xqui njabʉ ngu núꞌa̱ xqui tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Núꞌʉ ya ja̱ꞌi mi ꞌbʉhni nura oraꞌa̱ ra Jesu bi xipa ra Lasaro da bøni de ra ntꞌagui ne bi gʉtsꞌi de ra du, nuꞌʉ́ xqui ꞌyonga ra ꞌbede de núꞌa̱ xqui hyantꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hangue ndunthi ya ja̱ꞌi xqui bøni de ra hnini pa bá tha̱di ra Jesu ngueꞌa̱ xqui ꞌyøde de núꞌa̱ ra da̱nga ntꞌudi xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nepʉ ya fariseo mri ꞌñémsɛꞌʉ: ―¡Ha ngue dí xiꞌahʉ gue hinda za te gui ꞌyøthʉ! Ndi, gatho ya ja̱ꞌi di dɛnini, hinda za to da za̱miyʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nehe ꞌraya me Grecia xqui ma Jerusale ja núꞌa̱ ra ngo pa da xøcambeniꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Y núꞌʉ ya me Grecia bi ma bá tsʉdi ra Lipe núꞌa̱ mrá me Betsaida de ra hai Galilea, ne bi ꞌñembabi: ―Ndada, dí nehma̱he ga ña̱he co ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nepʉ bi ma nura Lipe bá xipabi ra Andre, ne ri yohoꞌʉ bi ma bá xipa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ha ra Jesu bi da̱di ne bi ꞌñena: ―Ya bi zø ra ora pa da du Núꞌa̱ Toꞌo e bi Nja̱ꞌi ne da yopa menga pa mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Xi majua̱ni dí xiꞌahʉ, ꞌbʉ ꞌnara nda dega trigo ꞌbɛꞌtsitho ne hinda ꞌbotꞌa ja ra hai, hinda nxa̱ndi. Pe nuꞌbʉ xa ꞌbotꞌi, ma da unga ndunthi ra sofo. ");
INSERT INTO oteNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nuꞌa̱ tóꞌo da ma̱di rá te, ma da ꞌbɛdi, pe nuꞌa̱ tóꞌo hingui ma̱di rá te nuua ja ra ximhai, núꞌá̱ go gueꞌa̱ ma da mɛꞌtsa rá te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nuꞌa̱ tóꞌo da mɛpcagui, mahyoni da dɛngagui, y nu habʉ ga ꞌbʉiga da ꞌmʉhni nehe. Ha nuꞌa̱ tóꞌo da mɛpcagui, ma Dada ma da ꞌñeꞌtsua rá nsu. ");
INSERT INTO oteNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nubyá xi dí tu ma mʉi. ¿Te ma ga apa Ajua̱ ma Dada? ¿Ha ga xipa njaua: “Ma Dadaꞌi, ña̱ngagui de núꞌa̱ ma ga thogui nuna ra orabya”? Pe hinda za ga embi njabʉ, ngueꞌa̱ pa guehna stá ehe. ");
INSERT INTO oteNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ma Dadaꞌi, ꞌyøtꞌe núꞌa̱ go ri paha pa dra nsundaꞌi ri thuhu. ꞌBestho ra oraꞌa̱ bi ntꞌøde ꞌnara noya de mahetsꞌi núꞌa̱ bi ꞌñena: ―Ya stá øtꞌe ne ma ga yopa øtꞌa maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ha nura hmuntsja̱ꞌi mi ꞌbahni ra oraꞌa̱ bi ꞌyøde núꞌa̱ ra noya de mahetsꞌi, ne ꞌra bi ꞌñena gue mi ꞌnara ngani, ha nu maꞌra mi ena gue ꞌnara ɛnxɛ bi zofoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nepʉ nura Jesu bi da̱di ne bi ꞌñena: ―Hingo po rá ngueque xa ntꞌøde núꞌa̱ ra noya, hønsɛ po rá ngueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nubyá núꞌʉ ya meximhai hinda ne da gamfrigui ma dra tꞌɛꞌmbabi pa dra castigaꞌʉ, ne ma dra tha̱cuabi rá tsꞌɛdi ra tsꞌonda̱hi núꞌa̱ ri nda̱ ja nuna ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nuga ma dra tsꞌʉtcagui maña̱ ja ꞌnara ponza pa da thogagui, y nu sta tꞌøtque njabʉ, ma da gamfrigui ndunthi ya ja̱ꞌi po rá ngue ma du. ");
INSERT INTO oteNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nuꞌá̱ bi ma̱nga njabʉ pa da fa̱di te ma du mi ma da duꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nepʉ nuya ja̱ꞌi bi da̱di ne bi ꞌñena: ―Nuꞌi guí ena gue go gueꞌe Núꞌa̱ Toꞌo e bi Nja̱ꞌi, ne nuje ndí hu ma mʉihe gue go guetꞌa̱ ra Cristo núꞌa̱ mi ma da mɛhna Ajua̱ pa da nda̱. Pe nuꞌi guí ena gue mahyoni ma dra tsꞌʉta maña̱ ja ra ponza Núꞌa̱ Toꞌo e bi Nja̱ꞌi. Pe nura ley ma̱ gue ra Cristo ma da ꞌmʉi pa nza̱ntho. Nuꞌbʉ́ ¿te rá ꞌbɛfi Núꞌa̱ Toꞌo e bi Nja̱ꞌi? ¿Ha go gueꞌa̱ núꞌa̱ mi ma da mɛhna Ajua̱ pa da nda̱? ");
INSERT INTO oteNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Nuga drá ñotꞌi dí yoꞌtꞌa ri mfenihʉ. Pe ya tsꞌʉtho ya pa dí ꞌbʉi con gueꞌahʉ. Hangue mientra dí ꞌbʉi con gueꞌahʉ, tɛngaguihʉ, pa hingui njahʉ ngu núꞌa̱ toꞌo bi zʉ ra ꞌbɛxuui, ngueꞌa̱ nuꞌa̱ tóꞌo ꞌyo ja ra ꞌbɛxuui hingui pa̱di habʉ rí ma. ");
INSERT INTO oteNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","De dí ꞌbʉiua pa ga yoꞌtꞌaꞌihʉ, camfriguihʉ, pa njabʉ dyá mɛtiꞌihʉ ra ñotꞌi. Ha nu mi uadi bi ma̱nga njabʉ ra Jesu, bi ꞌuegue de gueꞌʉ bi ma bá ꞌbʉi habʉ hinda ba̱diꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Masque ra Jesu xqui ꞌyøtꞌa ndunthi ya da̱nga ntꞌudi ja yá thandi nuya xodyo, pe nuꞌʉ́ himbi gamfri. ");
INSERT INTO oteNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bi njabʉ ngu núꞌa̱ xqui ꞌyofo ra ba̱di Isaía habʉ ena: Ma zi Hmuꞌi, ¿to ja gueꞌa̱ xa gamfri ma noyahʉ? ¿To ja gueꞌa̱ xa gamfriꞌi ngueꞌa̱ xcá ꞌyøtꞌa ya da̱nga ntꞌudi? ");
INSERT INTO oteNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nuꞌʉ́ himi tsa da gamfri ngueꞌa̱ bi njabʉ ngu núꞌa̱ xqui ꞌyofo ra ba̱di Isaía ja maꞌna ra xɛni habʉ ena: ");
INSERT INTO oteNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ajua̱ bi goꞌtua yá daꞌʉ ne bi japi bi megui yá mfeni, pa himbi hyandi co yá da, nixi bi ba̱di co yá mfeni, pa himbi ñobriꞌʉ ne pa njabʉ nuga himbi za dá pøhøꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ra Isaía bi ma̱nga njabʉ de ra Jesu ngueꞌa̱ xqui hyandua rá nsundaꞌa̱, hangue mi ma̱ de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Masque njabʉ, pe asta ꞌraya nda̱ gá xodyo nehe bi gamfri gue ra Jesu go gueꞌa̱ xpá mɛhna Ajua̱ pa da nda̱, pe nuꞌʉ́ hinto bi xipabi ngueꞌa̱ mi tsu ya fariseo da ꞌyɛniꞌʉ de ra nija̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ngueꞌa̱ nuꞌʉ́ maꞌna mi ne da pønga yá hmi ja yá thandi ya ja̱ꞌi que ja rá thandi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ra Jesu bi ña̱ ntsꞌɛdi ne bi ꞌñena: ―Nuꞌa̱ tóꞌo camfrigui, hingue hønsɛ camfriguiga, nehe camfri núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne nuꞌa̱ tóꞌo handga ma ꞌmʉi, ja ra uɛnda handua rá ꞌmʉi núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nuga go guecagui drá ñotꞌi stá eheua ja ra ximhai pa nuto gatho da gamfrigui ga pøni de ja ra ꞌbɛxuui. ");
INSERT INTO oteNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nuꞌa̱ tóꞌo øde núꞌa̱ dí ma̱, ne hinda ne da ꞌyøtꞌe, nuga hingo ma ga ɛꞌmbi pa da ma ja ra nidu, ngueꞌa̱ nuga stá ehe pa ga pøhø ya ja̱ꞌi, hingue pa ga ɛꞌmbi da ma ja ra nidu. ");
INSERT INTO oteNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nuꞌa̱ tóꞌo hingui numansugui ne hingui ne da gamfri núꞌa̱ dí ma̱, go gueꞌa̱ ma da tꞌɛꞌmbi pa ja ra nidu, ne numa noya go gueꞌa̱ ma da ꞌyɛꞌmbi núꞌa̱ ra pa de ra nga̱xhmai. ");
INSERT INTO oteNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngueꞌa̱ nuga hinstá bensɛ núꞌa̱ dí ma̱. Ma Dada núꞌa̱ toꞌo bá pɛncagui go gueꞌa̱ xa ꞌbɛpcagui pa ga xiꞌahʉ núꞌa̱ bi xiqui. ");
INSERT INTO oteNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne dí pa̱di gue núꞌʉ ya noya xa ꞌbɛpqui ga ma̱ go gueꞌʉ unga ra te pa nza̱ntho. Hangue dí xiꞌahʉ ngu núꞌa̱ xa xicagui ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nura pa ante ra ngo de ra pascua, ra Jesu mi pa̱di gue ya xqui zø ra ora pa da ma de guecua ja ra ximhai pa da yopa mengui habʉ bí ꞌbʉ Ajua̱ rá Dada. Nuꞌá̱ nza̱ntho bi ma̱di núꞌʉ toꞌo yá mɛtiꞌa̱, ne xi ra da̱ngui rá hma̱te bi mɛꞌtsuabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ha ra Jesu bi ntꞌoxiui yá nxadi. Ha ra tsꞌonda̱hi ya xqui yʉtꞌa ja rá mfeni ra Juda Iscariote núꞌa̱ mrá tꞌʉ ra Simu, pa da da ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ha ra Jesu mi pa̱di gue bá ehe de habʉ mi ꞌbʉhui Ajua̱ rá Dada pa da ꞌmʉcua ja ra ximhai, ne mi pa̱di nehe gue ya mi ma da yopa mengui pa da ꞌmʉhuiꞌa̱. Nehe mi pa̱di gue Ajua̱ rá Dada ya gatho xqui ꞌyɛntꞌua ja rá ꞌyɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hangue nuꞌá̱ bi ꞌmai de ja ra mexa habʉ mri ntꞌoxiꞌʉ ne bi hña̱ca rá patꞌi ne bi ngʉtꞌa ꞌnara ntꞌotꞌyɛ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne bi xitꞌa ra dehe ja ꞌnara nsʉꞌyɛ, ne bi mʉdi bi xʉcua yá ua yá nxadi. Nepʉ mi oꞌtuabi co núꞌa̱ ra ntꞌotꞌyɛ mri ngʉtꞌiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ha nu mi ma da xʉcuabi yá ua ra Pedro, ra Pedro bi ꞌñembabi: ―Ma zi Hmuꞌi, ¿ha gue go ma gui xʉga ma uaga? ");
INSERT INTO oteNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―Nubyá hingui tsa da zo ri mfeni núꞌa̱ dí øtꞌe, pe ꞌmɛfa ha̱, ma gui pa̱di. ");
INSERT INTO oteNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nura Pedro bi ꞌñembabi: ―Nuꞌi hinhyaꞌmʉ ma gui xʉga ma uaga. Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―Nuꞌbʉ hinga xʉcꞌa ri ua, hinte guí pɛꞌtsi de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nuꞌbʉ́ ra Pedro bi ꞌñembabi: ―Ma zi Hmuꞌi, nuꞌbʉ́, hingue hønsɛ ma ua gui xʉgagui, xʉga ma ꞌyɛ ne ma ña̱xu nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ha nura Jesu bi ꞌñembabi: ―Núꞌa̱ toꞌo ya xa nxaha, ya hinga mahyoni da yopa ntꞌaxca maꞌnaꞌqui, hønsɛ da sʉcua yá ua, ngueꞌa̱ ya xá ntꞌaxi gatho rá ndoꞌyo. Ha nuꞌahʉ ya xá ntꞌaxiꞌihʉ, masque hinga gathoꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nuꞌá̱ mi pa̱di toꞌo mi ma da daꞌa̱, hangue bi ꞌñena gue hinxmá ntꞌaxi gathoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ha nu mi uadi bi xʉcua yá uaꞌʉ, bi yopa hñuxa rá patꞌi ne bi hñudi maꞌnaꞌqui ja ra mexa ne bi ꞌñembabiꞌʉ: ―¿Ha tso ri mfenihʉ núꞌa̱ stá øꞌtꞌaꞌihʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nuꞌahʉ guí enjʉ go gueque ri Xahnateguihʉ ne ri Hmuguihʉ. Núꞌa̱ guí enjʉ gueꞌa̱ majua̱ni, ngueꞌa̱ ha̱, go guecagui. ");
INSERT INTO oteNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hangue ngueꞌa̱ núga ri Hmuguihʉ ne ri Xahnateguihʉ ne stá xʉcꞌa ri uahʉ, hangue nuꞌahʉ́ nehe rí ꞌñepꞌahʉ gui nxʉcua uahʉ ꞌna ngu maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dí uꞌtꞌaꞌihʉ njabʉ pa neꞌahʉ da za gui ꞌyøthʉ ngu núꞌa̱ stá øꞌtꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Xi majua̱ni dí xiꞌahʉ, ꞌnara ꞌbɛgo hingo maꞌna ri mandaꞌa̱ que rá hmu, nixi ꞌnara ꞌmɛhni hingo ri mandaꞌa̱ que núꞌa̱ toꞌo xa mɛhni. ");
INSERT INTO oteNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nuꞌbʉ gui pa̱hʉ núꞌa̱ dí xiꞌahʉ, ne ꞌbʉ gui ꞌyøthʉ, nuꞌbʉ́ gui nja̱pihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pe hindí ma̱ de gathoꞌihʉ, ngueꞌa̱ dí pa̱ꞌaꞌihʉ núꞌahʉ stá huanꞌaꞌihʉ pa dua nxadiꞌihʉ, ne stá huanꞌahʉ pa da njabʉ ngu núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo habʉ ena: “Xa gʉgui dega ncontra núꞌa̱sɛ toꞌo stá ñuꞌme.” ");
INSERT INTO oteNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ꞌBɛdi da njabʉ ngu núꞌa̱ stá xiꞌahʉ, pe nubyá dí xiꞌahʉ núꞌa̱ te ma da nja, pa nu stí njabʉ, da za gui camfrihʉ gue go gueque ngu núꞌa̱ stá xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Xi majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo da numansu ma ꞌmɛhni, go gueque numansugui; ne nuꞌa̱ tóꞌo da numansugui, go numansu núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ha nu mi ma̱nga njabʉ ra Jesu, bi du rá mʉi, ne bi xipabi yá nxadi te mri bønga núꞌa̱ mi ma̱, ne bi ꞌñena: ―Xi majua̱ni dí xiꞌahʉ, ꞌna de gueꞌahʉ ma da dagagui. ");
INSERT INTO oteNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ha nuya nxadi bi nʉꞌtua daꞌʉ ngueꞌa̱ himi pa̱di toꞌo ꞌna de gueꞌʉ núꞌa̱ mi ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ha ꞌnara nxadi núꞌa̱ xi mrá hma̱di ra Jesu, ja mi huhni ja rá hyoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Y nura Pedro bi ꞌñutua ra seña núꞌa̱ ra hma̱ca nxadi pa da ꞌyambabi ra Jesu toꞌoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nepʉ nuꞌá̱ xqui ncahma guetbʉ ja rá tiña̱ ra Jesu bi ꞌñembabi: ―¿Toꞌo ꞌna de guecje, ma zi Hmuꞌihe? ");
INSERT INTO oteNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ha nura Jesu bi da̱di ne bi ꞌñena: ―Núꞌa̱ toꞌo ga umba ra cꞌathuhme go gueꞌa̱. Nuꞌbʉ́ nuꞌá̱ bi poꞌmba ra thuhme ne bi umbabi ra Juda Iscariote núꞌa̱ mrá tꞌʉ ra Simu. ");
INSERT INTO oteNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ha nura Juda mi hña̱nga núꞌa̱ ra cꞌathuhme gueꞌa̱ ra ora bi yʉtꞌa ra Satá ja rá mfeniꞌa̱ pa da ꞌyøꞌtua rá ꞌbɛfi. Nepʉ nura Jesu bi ꞌñembabi: ―Núꞌa̱ guí beni gui ꞌyøtꞌe, ꞌyøtꞌe ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pe ni ꞌna de gue núꞌʉ mi huhni ja ra mexa himbi zo yá mfeni hanja bi xipabi njabʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ngueꞌa̱ nura Juda go mi pɛꞌtsa ra ncʉboja̱, hangue ꞌra de gueꞌʉ mi hu yá mʉi gue ra Jesu xqui xipabi gue da ma da danga te mahyoni pa ja ra ngo, o pa da umbi te da umba ya hyoya. ");
INSERT INTO oteNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ne ngu xi bi hña̱nga nura cꞌathuhme, ꞌbestho bi bøni. Ne ya xmá ꞌmɛxuui ra oraꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ha nu mi bønga ra Juda, bi ꞌñenga ra Jesu: ―Nubyá ma da hnequi rá nsunda Núꞌa̱ Toꞌo e bi Nja̱ꞌi po núꞌa̱ ma da thogui. Ne po rá ngueꞌa̱ ma dra nsunda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nepʉ Ajua̱ ma da umba rá nsu pa di mahyɛguiui yá nsu, ne ma da ꞌyøtꞌe ꞌbestho. ");
INSERT INTO oteNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ma zi tꞌʉꞌihʉ, ya hinga ma ga ꞌbʉi ndunthi con gueꞌahʉ. Ma gui hyongaguihʉ, ne ngu stá xipa ya nda̱ gá xodyo, njabʉ nehe dí xiꞌahʉbya: Hinda za gui mahani habʉ grá maga. ");
INSERT INTO oteNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nubyá ꞌnara ꞌraꞌyo hmanda dí tsocꞌahʉ: Má̱dihʉ ꞌna ngu maꞌna, nja ngu stá ma̱ꞌaꞌihʉ, njabʉ nehe gui má̱dihʉ ꞌna ngu maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ꞌBʉ gui má̱dihʉ ꞌna ngu maꞌna, nuꞌbʉ́ njabʉ da ba̱di gatho ya ja̱ꞌi gue majua̱ni ma nxadiꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ha nura Pedro bi ꞌñembabi: ―Ma zi Hmuꞌi, ¿habʉ ma gui ma? Ha nura Jesu bi da̱di ne bi ꞌñembabi: ―Hinda za ga mɛuibya habʉ grá maga. ꞌMɛfa ha̱, ma gui mani. ");
INSERT INTO oteNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ha nura Pedro bi ꞌñembabi: ―Ma zi Hmuꞌi, ¿hanja hinda za ga mɛuibya? Nuga masque ga tu por gueꞌe. ");
INSERT INTO oteNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ha nura Jesu bi ꞌñembabi: ―¿Ha gue ma gui tugue po rá nguecagui? Xi majua̱ni dí xiꞌaꞌi, ma gui cøngagui hñuꞌqui ante da mafi ra menja̱. ");
INSERT INTO oteNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ne ra Jesu bi ꞌñembabi yá nxadi: ―Oguí tu ri mʉihʉ. Nuꞌahʉ guí camfrihʉ Ajua̱ ma Dada, hangue camfriguihʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nuni habʉ bí ꞌbʉ Ajua̱ ma Dada xi bí ja ndunthi ya ngu. Nuꞌbʉ di othohma̱, ya stá xiꞌahma̱hʉ. Nuga ma ga ma pa ga hocꞌaꞌihʉ habʉ ma gui ꞌbʉhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne xcrá ma pa ga hocꞌaꞌihʉ habʉ gui ꞌbʉhʉ, ma ga yopa pengui pa ga tsixꞌaꞌihʉ pa gui ꞌbʉhʉ habʉ ma ga ꞌbʉca. ");
INSERT INTO oteNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ne guí pa̱hʉ habʉ ma ga maga, ne guí pa̱hʉ ra ꞌñu. ");
INSERT INTO oteNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nuꞌbʉ́ nura Toma bi ꞌñembabi: ―Ma zi Hmuꞌi, hindí pa̱he habʉ ma gui ma, ¿ne guí enje gue dí pa̱he ra ꞌñu? ");
INSERT INTO oteNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Nuga go guecagui drá ꞌñu, ne drá majua̱ni, ne drá te. Hinda za to da zøni habʉ bí ꞌbʉ ma Dada ꞌbʉ hingo ga tsixca. ");
INSERT INTO oteNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ꞌBʉ xcá pa̱cjhma̱hʉ, xcá pa̱hma̱hʉ ma Dada nehe. Ne desde nubya guí pa̱hʉꞌa̱, ne xcá hyanthʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ha nura Lipe bi ꞌñembabi: ―Ma zi Hmuꞌihe, ꞌñutcahe Ajua̱ ra Dada, ne ya con guetꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―¿Ha hinxcá pa̱caguitho, nugue Lipe? Y ya øtꞌa ndunthi ya pa stá ꞌñohʉ. Nuꞌa̱ tóꞌo xa hyandgagui xa hyanda Ajua̱ ma Dada nehe. Nuꞌbʉ́ ¿hanja guí engaguihʉ gue ga uꞌtꞌaꞌihʉ Ajua̱ ra Dada? ");
INSERT INTO oteNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ha hinguí camfri gue dí ꞌnathoꞌbe Ajua̱ ma Dada? Nuga hinstá bensɛ núꞌa̱ dí xiꞌahʉ, nixi núꞌʉ ya ꞌbɛfi dí pɛfi hingo dí pɛfi de guecsɛ. Numa Dada toꞌo dí ꞌnathoꞌbe go gueꞌa̱ øtꞌe gatho, ne go rá ꞌbɛfisɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Camfrihʉ gue nuga dí ꞌnathoꞌbe Ajua̱ ma Dada. Pe nuꞌbʉ hinguí camfrihʉ núꞌa̱ dí ma̱ gue dí ꞌnathoꞌbeꞌa̱, camfrihʉ po núꞌʉ ya ꞌbɛfi stá pɛfi. ");
INSERT INTO oteNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Xi majua̱ni dí xiꞌahʉ, nuꞌa̱ tóꞌo da gamfrigui, neꞌa̱ ma da mɛ ya ꞌbɛfi ngu núꞌʉ dí pɛfi, ne maꞌna dya da̱ngui ma da mɛfiꞌa̱ nguetho nuga ma ga yopa pengui pa ga ꞌbʉꞌbe ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ne gatho núꞌa̱ te ma gui ꞌyapabihʉ ma Dada de ma thuhuga, ma ga øꞌtꞌa ri ntꞌadihʉ, pa dra nsunda ma Dada po rá ngueque rá Tꞌʉgui. ");
INSERT INTO oteNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hangue nuꞌa̱raza te gui ꞌyadihʉ ja ma thuhu, nuga ga ꞌraꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ꞌBʉ grí ma̱caguihʉ, ꞌyøthʉ nuya hmanda dí ꞌbɛpꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne nuga ma ga apabi Ajua̱ ma Dada da mɛnꞌahʉ maꞌna núꞌa̱ toꞌo da hñupꞌa ri mʉihʉ, ne nuꞌá̱ da mɛnꞌahʉ pa da ꞌmʉi nza̱ntho con gueꞌahʉ, y nuꞌá̱ go gueꞌa̱ ra Ma̱ca Nda̱hi núꞌa̱ toꞌo ma̱nga majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ne ya ja̱ꞌi núꞌʉ hingyá gamfri hingui tsa da hña̱niꞌa̱, ngueꞌa̱ nuꞌʉ́ hingui pa̱di toꞌoꞌa̱, ne hingui tso yá mfeniꞌʉ tenguꞌa̱. Pe nuꞌahʉ́ guí pa̱hʉꞌa̱ ngueꞌa̱ nuꞌá̱ ꞌbʉi con gueꞌahʉ, ne ma da ꞌmʉi ja ri corasohʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Hangue njabʉ nuga hinga ma ga tsocꞌasɛhʉ, ma ga yopa pengui maꞌnaꞌqui pa ga ꞌbʉi con gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ne ꞌbestho ma da zø ra ora ya ja̱ꞌi núꞌʉ hingyá gamfri ya hinda ma da hyandgaua ngueꞌa̱ pa gueꞌʉ ma ga njoꞌo, pe nuꞌahʉ́ ha̱, ma gui hyandgaguihʉ ngueꞌa̱ ma ga ꞌbʉi con gueꞌahʉ. Y nuga ma ga yopa nte, hangue neꞌahʉ ma gui pɛꞌtshʉ ra te pa nza̱ntho ngueꞌa̱ dí tega. ");
INSERT INTO oteNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ha nu xcrá njabʉ, ma gui pa̱hʉ gue dí ꞌbʉꞌbe ma Dada, ne nuꞌahʉ guí ꞌbʉhʉ con gueque, ne nuga dí ꞌbʉi con gueꞌahʉ ja ri corasohʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nuꞌa̱ tóꞌo øtꞌa ya hmanda núꞌʉ dí ma̱, núꞌá̱ go gueꞌa̱ ri ma̱cagui. Ha nuꞌa̱ tóꞌo ri ma̱cagui, ma Dada ri ma̱diꞌa̱, nequi ga ma̱diꞌa̱ ne ga utuabi tengu ma ꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nuꞌbʉ́ ra Juda, pe hingue nura Juda Iscariote, bi ꞌñembabi ra Jesu: ―Ma zi Hmuꞌi, ¿hanja hønsɛguihe ma gui utcaguihe tengu ri ꞌmʉi, ha nu maꞌra ya ja̱ꞌi hina? ");
INSERT INTO oteNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñembabi: ―Nuꞌa̱ tóꞌo ri ma̱cagui ma da ꞌyøtca núꞌa̱ dí ma̱, ne ma Dada da ma̱diꞌa̱, ne nuga co ma Dada ga eꞌbe ne ga ꞌbʉhe ꞌnadbʉ con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nuꞌa̱ tóꞌo hingui ma̱cagui, hingui øtca núꞌa̱ dí ma̱. Y núꞌa̱ guí øhʉ dí ma̱, hindí ma̱nsɛga, numa Dada núꞌa̱ toꞌo bá pɛncagui go gueꞌa̱ ma̱ñꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Dí xiꞌahʉ njabʉ núbya de dí ꞌbʉitho con gueꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pe ra Ma̱ca Nda̱hi núꞌa̱ ma dua pɛhna ma Dada de ja ma thuhu pa da ꞌmʉi con gueꞌahʉ ne da hñupꞌa ri mʉihʉ, nuꞌá̱ ma da ꞌñuꞌtꞌaꞌihʉ gatho, ne ma da benꞌaꞌihʉ gatho ngu núꞌa̱ stá xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Dí ne gui ꞌbʉhʉ te rá entho nsinque ra dumʉi, hangue dí ꞌraꞌahʉ ra humʉi, gueꞌa̱ ngu ꞌnara tsogui dí tsocꞌahʉ. Y núꞌa̱ ra humʉi dí ꞌraꞌahʉ, hingue ngu núꞌa̱ di unga ya meximhai. Hangue oxqui tu ri mʉihʉ, nixi gui ntsuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nuꞌahʉ ya stá xiꞌahʉ gue ma ga ma, ne ma ga yopa pengui pa ga ꞌbʉi con gueꞌahʉ. ꞌBʉ gri ma̱cjhma̱hʉ, nuꞌbʉ́ xcá johyahma̱hʉ nu ndá xiꞌahʉ gue ma ga ma habʉ bí ꞌbʉ ma Dada, ngueꞌa̱ nuꞌá̱ go maꞌna ha̱ ra tsꞌɛdi de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nubyá dí xiꞌahʉ núꞌa̱ di ꞌbɛtho da nja, pa nu stí nja, ma gui beñhʉ, pa njabʉ maꞌna gui camfriguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ya hinga ma ga ꞌbʉi ndunthi con gueꞌahʉ pa ga ña̱hʉ, ngueꞌa̱ xa ꞌñepʉ ra tsꞌonda̱hi núꞌa̱ ri nda̱ de nuna ximhai, pe nuꞌá̱ hingui ha̱ ra tsꞌɛdi pa te da ꞌyøtcagui. ");
INSERT INTO oteNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nuga ma ga hoptho da ꞌyøtque núꞌa̱ te xa ꞌyɛꞌmgagui, pa njabʉ da ba̱di gatho ya ja̱ꞌi gue dí ma̱di ma Dada, ne dí øtꞌe ngu núꞌa̱ xa ꞌbɛpcaguiꞌa̱. ꞌBaihʉ, maha. ");
INSERT INTO oteNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nepʉ ra Jesu bi ꞌñembabi yá nxadi: Nuga dí nja ngu ꞌnara hoga ꞌbai gá obxi, ha numa Dada nja ngu núꞌa̱ toꞌo pɛ ra ua̱ꞌobxi. ");
INSERT INTO oteNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nuꞌʉ tóꞌo ꞌbʉi con gueque go gueꞌʉ nja ngu ya mai de nura hoga ꞌbai gá obxiꞌa̱. Ne gatho ya mai núꞌʉ hingui unga yá fruta, núꞌa̱ toꞌo pɛ ra ua̱ꞌobxi da zɛquiꞌʉ. Pe nuꞌʉ di unga yá fruta, nuꞌá̱ da moquiꞌʉ pa maꞌna da unga yá fruta. ");
INSERT INTO oteNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nuꞌahʉ ya xá ntꞌaxiꞌihʉ po nura noya stá xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ꞌBʉhʉ con gueque, ne nuga ga ꞌbʉi con gueꞌahʉ. Ngu ꞌnara mai hingui tsa da unsɛ yá fruta ꞌbʉ hingui tøgue ja rá ꞌbai, guí njahʉbʉ nehe, hinda za gui uñhʉ ri frutahʉ ꞌbʉ hingui ꞌbʉhʉ con gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nuga go guecagui drá ꞌbai gá obxi, ha nuꞌahʉ go gyá maihʉ. Nuꞌa̱ tóꞌo ꞌbʉi con gueque, ne nuga con gueꞌa̱, go gueꞌa̱ da unga ndunthi ya fruta, ngueꞌa̱ nsinque de gueque hinda za te gui ꞌyøthʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nuꞌʉ tóꞌo ya hingui ꞌbʉi con gueque, nja ngu ya mai xa tsꞌɛqui, da ꞌyotꞌi, nepʉ da hmuntsꞌi gatho pa dra thøtꞌa ja ra tsibi, da nzø. ");
INSERT INTO oteNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ꞌBʉ xi gui ꞌbʉhʉ con gueque, ne ꞌbʉ ma noya da ꞌyoda ja ri mfenihʉ, nuꞌbʉ́ ꞌyaphʉ Ajua̱ gatho núꞌa̱ go gui nehʉ ne nuꞌá̱ da ꞌraꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ꞌBʉ gui uñhʉ ndunthi ra fruta, nuꞌbʉ́ da hnequi rá nsunda ma Dada, ne njabʉ ma go dua nxadiꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngu ma Dada ma̱cagui, njabʉ nehe dí ma̱ꞌaꞌihʉ. Oxqui ꞌueguehʉ de ma hma̱te. ");
INSERT INTO oteNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nuꞌbʉ gui ꞌyøthʉ nuya hmanda dí ꞌbɛpꞌahʉ, nuꞌbʉ́ guí ꞌbʉhʉ ja ma hma̱te, ngu nuga stá øꞌtua yá hmanda ma Dada ne dí ꞌbʉ ja rá hma̱teꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Dí xiꞌahʉ njabʉ pa da nja ma johya ja ri corasohʉ, ne pa hinhyaꞌmʉ da ꞌmɛ ri johyahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nuꞌa̱ ma hmanda dí ꞌbɛpꞌahʉ: Má̱dihʉ ꞌna ngu maꞌna ngu stá ma̱ꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nuꞌa̱ tóꞌo da du po rá ngue yá amigo, go gueꞌa̱ maꞌna ja rá hma̱te ra da̱ngui de gatho. ");
INSERT INTO oteNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ha nuꞌbʉ gui ꞌyøthʉ núꞌa̱ dí ꞌbɛpꞌahʉ, nuꞌbʉ́ go ma amigoꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Hangue ya hindí hantꞌahʉ ngu ꞌnara ꞌbɛgo, ngueꞌa̱ ꞌnara ꞌbɛgo hingui pa̱di te pɛ rá hmu. Y nubyá dí hantꞌahʉ ngu ma amigoꞌihʉ, ngueꞌa̱ stá xiꞌahʉ gatho núꞌa̱ xa xicagui ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nuꞌahʉ hingo xcá huancahʉ, nuga go stá huanꞌaꞌihʉ, ne stá huxꞌaꞌihʉ pa gui maha habʉ ga pɛnꞌaꞌihʉ, ne pa gui uñhʉ ra fruta núꞌa̱ hinhyaꞌmʉ da thegue. Ne núꞌa̱ te gatho gui ꞌyapabihʉ ma Dada de ja ma thuhu, nuꞌá̱ da ꞌraꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hangue nuꞌa̱ dí ꞌbɛpꞌaꞌihʉ, má̱dihʉ ꞌna ngu maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ꞌBʉ da ʉtsaꞌihʉ ya ja̱ꞌi, beñhʉ gue go ꞌmɛtꞌo bi ʉtsaguigaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nuꞌbʉ dyá mɛtiꞌihʉ hma̱ha̱ ra ximhai, nuꞌbʉ́ ya meximhai di ma̱ꞌaꞌihʉ ngu ma̱di yá mimeximhaiui. Pe nuꞌahʉ hingyá mɛtiꞌihʉ ra ximhai ngueꞌa̱ nuga stá huanꞌaꞌihʉ ne stá ꞌuecꞌaꞌihʉ de ya tsꞌotꞌøtꞌe de ra ximhai. Hangue por gueꞌa̱ ya ja̱ꞌi di ʉtsaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Oxqui ma gui pumfrihʉ núꞌa̱ stá xiꞌahʉ, gue ꞌnara ꞌbɛgo hingo maꞌna ja rá nsu que rá hmu. Nuꞌʉ tóꞌo xa ʉtsagui da ʉtsaꞌihʉ nehe, ha nuꞌʉ tóꞌo xa ꞌyøtca núꞌa̱ stá ma̱, nehe da ꞌyøꞌtꞌaꞌihʉ núꞌa̱ gui ma̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pe núꞌʉ toꞌo ma da ʉtsaꞌihʉ ngueꞌa̱ guí camfriguihʉ, nuꞌʉ́ ma da ꞌyøꞌtꞌaꞌihʉ njabʉ ngueꞌa̱ hingui pa̱diꞌʉ núꞌa̱ toꞌo bá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ꞌBʉ hinstá ehehma̱ ne hinstá zofohma̱ ya ja̱ꞌi, nuꞌbʉ́ nuꞌʉ́ hinte ma tsꞌoqui di tuhma̱ꞌʉ. Pe nuga dá ehe, ne dá zofoꞌʉ. Hangue nubyá nuꞌʉ́ tu ya tsꞌoqui ne hinda za te ma da da̱diꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nuꞌa̱ tóꞌo ʉtsagui, ʉtsa ma Dada nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nuga dá øtꞌa ya da̱nga ntꞌudi ja yá thandiꞌʉ, núꞌʉ hinhyaꞌmʉ toꞌo maꞌna xa ꞌyøtꞌe. Pe masque njabʉ nuꞌʉ́ himbi ne bi gamfrigui, hangue nubyá tu yá tsꞌoqui. Ne masque bi hyanda nuya da̱nga ntꞌudiꞌʉ, bi ʉtsagui ne bi ʉtsa ma Dada nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bi njabʉ pa da nja ngu núꞌa̱ xqui tꞌofo ja yá nda̱xjua leyꞌʉ: “Masque hinte ma tsꞌoqui stá øtꞌe, pe nuꞌʉ́ bi ʉtsagui.” ");
INSERT INTO oteNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pe ma ga pɛnꞌaꞌihʉ ra Ma̱ca Nda̱hi pa da ꞌmʉi con gueꞌahʉ ne da hñupꞌa ri mʉihʉ. Nuꞌá̱ ma da ꞌñehe de Ajua̱ ra Dada, ne ma̱nga majua̱ni, ne ma da xiꞌahʉ de gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Neꞌahʉ ma gui xiphʉ maꞌra ya ja̱ꞌi de gueque ngueꞌa̱ desde rá mʉdi xcá ꞌbʉhʉ con gueque. ");
INSERT INTO oteNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Dí xiꞌahʉ njabʉ pa hingui ꞌueguehʉ de gueque nu xcrí thohʉ ya ntꞌʉtsate. ");
INSERT INTO oteNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ma da tꞌɛñꞌaꞌihʉ de ja ya nija̱. Nehe ma da nja ra pa gue ꞌbʉ toꞌo da hyoꞌahʉ da beni gue supa rá ꞌbɛfi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nuꞌʉ́ ma da ꞌyøꞌtꞌahʉ njabʉ ngueꞌa̱ hinxa ba̱caguiꞌʉ nixi xa ba̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dí xiꞌahʉ njabʉ pa nu stí zø ra pa da njabʉ, da za gui beñhʉ gue ya stá xiꞌahʉ. Nurá mʉdi hindá xiꞌahʉ núꞌa̱ te ma da nja ngueꞌa̱ mi ꞌbɛtho pa ga ma. ");
INSERT INTO oteNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pe nubyá ma ga yopa pengui ga ꞌbʉꞌbe núꞌa̱ toꞌo bá pɛncagui, ne ni ꞌna de gueꞌahʉ hinguí angahʉ habʉ drá ma. ");
INSERT INTO oteNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pe go guí tu ri mʉihʉ ngueꞌa̱ dí xiꞌahʉ njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pe dí xiꞌahʉ majua̱ni gue pa gueꞌahʉ maꞌna xá hño ga ma, ngueꞌa̱ ꞌbʉ hinga ma, hinda ꞌñe ra Ma̱ca Nda̱hi pa da ꞌmʉi con gueꞌahʉ ne da hñupꞌa ri mʉihʉ, pe nu xcrá ma, ma ga pɛnꞌahʉuaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ha nu stí zøꞌa̱ ma da zopa yá mfeni ya ja̱ꞌi pa da ba̱diꞌʉ gue xi tu ya tsꞌoqui, ne hanja da za da ꞌmʉ xá hño, nehe da ba̱diꞌʉ gue Ajua̱ ma da ꞌyøtꞌa ra tsꞌʉtbi. ");
INSERT INTO oteNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Núꞌa̱ ra Ma̱ca Nda̱hiꞌa̱ ma da ꞌñutuabiꞌʉ gue xi tu ya tsꞌoqui ngueꞌa̱ hingui camfriguiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nehe nuꞌá̱ ma da ꞌñutuabiꞌʉ hanja da ꞌmʉiꞌʉ xá hño, ngueꞌa̱ nuga ya ma ga ma pa ga ꞌbʉꞌbe ma Dada ne nuꞌahʉ ya hingui ma gui hyandgahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y nuꞌá̱ ma da ꞌñutuabiꞌʉ gue Ajua̱ ma da ꞌyøtꞌa ra tsꞌʉtbi, ngueꞌa̱ nuꞌá̱ ya xa hña̱cua rá tsꞌɛdi ra tsꞌonda̱hi núꞌa̱ di nda̱ ja nuna ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ja maꞌra te ga xiꞌahma̱hʉ, pe nubyá hinga ma ga xiꞌahʉ ngueꞌa̱ hinda za gui pa̱dihʉ gatho. ");
INSERT INTO oteNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pe nu stí zø ra Ma̱ca Nda̱hi, ma da ꞌñuꞌtꞌahʉ pa gui pa̱hʉ gatho núꞌa̱ majua̱ni, nguetho nuꞌá̱ ma̱nga majua̱ni, ne hinda ma da ma̱nsɛ núꞌa̱ da ma̱, nuꞌá̱ ma da xiꞌahʉ gatho núꞌa̱ ma da xipabi Ajua̱ ma Dada, ne ma da xiꞌahʉ núꞌa̱ te ma da nja. ");
INSERT INTO oteNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ne ma da ꞌyøtꞌe pa da hneca ma nsunda, ngueꞌa̱ ma da xiꞌahʉ ngu núꞌa̱ te ga xipabi. ");
INSERT INTO oteNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nuga, nuꞌa̱ dí ma̱, dí ma̱ ngu núꞌa̱ xica ma Dada, hangue dí eñꞌahʉ gue ra Ma̱ca Nda̱hi ma da xiꞌahʉ ngu núꞌa̱ ga xipi. ");
INSERT INTO oteNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ya ma da zø ra ora ya hingui ma gui hyandgahʉ, nepʉ hintsꞌʉ yaꞌa̱ ma gui yopa hyandgahʉ maꞌnaꞌqui, ngueꞌa̱ ma ga yopa pengui habʉ bí ꞌbʉ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nepʉ ꞌrayá nxadi bi ꞌñémsɛꞌʉ ꞌna ngu ꞌna: ―¿Te rí bønga núꞌa̱ bi xicjʉni nu mi ma̱: “Ya ma da zø ra ora ya hingui ma gui hyandgahʉ, nepʉ hintsꞌʉ yaꞌa̱ ma gui yopa hyandgahʉ maꞌnaꞌqui, ngueꞌa̱ ma ga yopa pengui habʉ bí ꞌbʉ ma Dada”? ");
INSERT INTO oteNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ne nuꞌʉ́ mi ꞌñémsɛꞌʉ: ―¿Te rí bønga nuya ya noya xicjʉni: “Ya ma da zø ra ora”, ne “hintsꞌʉ yaꞌa̱”? Hingui tso ma mfenihʉ núꞌa̱ bi ma̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ha nura Jesu bi ba̱tho gue mi neꞌʉ da ꞌyambabi hma̱ha̱, hangue nuꞌá̱ bi ꞌñembabiꞌʉ: ―¿Ha gue grí ꞌñánbahʉ te rí bønga núꞌa̱ stá eñꞌahʉ gue ya ma da zø ra ora ya hingui ma gui hyandgahʉ, nepʉ hintsꞌʉ yaꞌa̱ ma gui yopa hyandgahʉ maꞌnaꞌqui? ");
INSERT INTO oteNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Xi majua̱ni dí xiꞌahʉ, nuꞌahʉ ma gui nzoñhʉ ne ma gui tu ri mʉihʉ, pe ya ja̱ꞌi núꞌʉ hingyá gamfri da johyaꞌʉ. Ma da du ri mʉihʉ, pe nuri dumʉihʉ ma da mpʉnga johya nu xcrí yopa hyandgahʉ maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ma gui njahʉ ngu ꞌnara ꞌbɛhña̱ ma da ꞌmʉ rá ba̱tsi pɛꞌtsa xica ʉgui ngueꞌa̱ ya xa datꞌa rá pa, pe nu stí uadi da ꞌmʉ rá ba̱tsi, nuꞌá̱ ya da pumfri yá ʉgui ne da johyaꞌa̱ ngueꞌa̱ ya bi dá nximhai ꞌnara ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Guí njahʉbʉ nehe, guí tu ri mʉihʉ, pe nuga ma ga yopa pengui ga ꞌbʉi con gueꞌahʉ, ne njabʉ ma xi gui johyahʉ, ne hinto da hña̱cꞌahʉ nura johyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ha nuya paꞌʉ ya hinte ma ntꞌani ma gui ꞌyangahʉ. Xi majua̱ni dí xiꞌahʉ, núꞌa̱ te gatho gui ꞌyapabihʉ ma Dada de ja ma thuhu, nuꞌá̱ ma da ꞌraꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hinte xcá ꞌyapthohʉ Ajua̱ ma Dada de ja ma thuhu. ꞌYaphʉ y nuꞌá̱ da ꞌraꞌahʉ, pa njabʉ nza̱ntho xi da nja ri johyahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Núꞌa̱ stá xiꞌahʉ, stá xiꞌahʉ ngu ꞌnara ꞌbede. Pe ma da zø ra pa gue ya hinga ma ga xiꞌahʉ njabʉ, pe ma ga xiꞌahʉ de ma Dada co ya noya núꞌʉ ꞌbestho da za gui pa̱dihʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ha nuya paꞌʉ ma gui ꞌyaphʉ ma Dada de ja ma thuhu, y hinga mathoni go ga api pa da ꞌraꞌahʉ núꞌa̱ te gui ꞌyaphʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ngueꞌa̱ ma Dada xi ma̱ꞌaꞌihʉ, ngueꞌa̱ guí ma̱caguihʉ ne xcá camfriguihʉ gue stá ehe de habʉ ndí ꞌbʉꞌbeꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ndí ꞌbʉꞌbe ma Dada ne stá ehe pa guecua ja ra ximhai, ne nubyá ma ga ma de guecua ja ra ximhai pa ga yopa pengui maꞌnaꞌqui nuni habʉ bí ꞌbʉ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nuꞌbʉ́ nuyá nxadi bi ꞌñembabi: ―Nubyá ha̱, ya tso ma mfenihe xá hño núꞌa̱ guí ma̱, ngueꞌa̱ ya hinte grí hyɛcuabi núꞌʉ ya noya guí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nubyá ha̱, dí pa̱he gue guí pa̱tho gatho, hangue hinga mahyoni to da ꞌyanꞌaꞌi ꞌnara ntꞌani. Hangue dí camfrihe gue Ajua̱ bá pɛñꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ha nura Jesu bi da̱tuabi ne bi ꞌñembabi: ―¿Ha gue ya guí camfrihʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pa̱hʉ gue ma da zø ra pa ne majua̱ni nubya ya xa zøhø, ma gui nxanihʉ ne ma gui penjʉ ja ri nguhʉ ꞌna ngu ꞌna, ne ma gui hyɛgasɛhʉ, pe nuga hinga ma ga ꞌbʉsɛga, ngueꞌa̱ dí ꞌbʉꞌbe ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Dí xiꞌahʉ njabʉ pa da za gui ꞌbʉhʉ te rá ꞌñentho nsi ra dumʉi ngueꞌa̱ guí camfriguihʉ. Nuua ja ra ximhai ma gui thohʉ ya thogui, pe oxqui tu ri mʉihʉ, dá nja ri tsꞌɛdihʉ pa gui tsɛtihʉ, ngueꞌa̱ nuga ya stá nta̱te de nuna ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mi uadi bi ma̱nga njabʉ ra Jesu, nepʉ bi nøtsꞌe pa mahetsꞌi ne bi ꞌyapa Ajua̱ rá Dada, bi ꞌñena: ―Ma Dadaꞌi, ya bi zø ra ora. ꞌYøtꞌe pa da hnequi ma nsunda núga ri Tꞌʉgui, ne pa njabʉ necá ga øtꞌe pa da hnequi ri nsunda nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngueꞌa̱ nuꞌi xcá ꞌyɛntcꞌa ja ma ꞌyɛ gatho ya ja̱ꞌi de ra ximhai, pa ga umbabi ra te nza̱ntho nuto gatho xcá ꞌraqui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Núꞌʉ toꞌo pɛꞌtsa ra te nza̱ntho go gueꞌʉ pa̱di gue go guesɛꞌi grá ꞌnatꞌa Ajua̱ majua̱ni, ne pa̱cagui núga drá Jesucristo xcá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nuga stá øtꞌe pa bi hnequi ri nsunda nuua ja ra ximhai, ngueꞌa̱ ya stá juaꞌtꞌa ri ꞌbɛfi núꞌa̱ gá ꞌbɛpcagui ga pɛfi. ");
INSERT INTO oteNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nubyá, ma Dadaꞌi, ꞌyøtꞌe pa nu xcrá yopa mabʉ, da yopa hnequi ma nsunda ngu núꞌa̱ ndí pɛꞌtsi núꞌbʉ ndá ꞌbʉhuibʉ núꞌbʉ mi othotho ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Núyʉ toꞌo xcá huahni de ra ximhai ne xcá ꞌracagui, ya stá utuabiyʉ toꞌoꞌigue ne tengu ri ꞌmʉi. Nuyʉ go ri mɛtiyʉ ne xcá ꞌracaguiyʉ, ne nuyʉ́ xa ꞌyøtꞌe ngu ma̱nga ri noya. ");
INSERT INTO oteNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nuyʉ́ ya pa̱di gue gatho núꞌa̱ dí pɛfi ne núꞌa̱ dí ma̱ go xcá ꞌbɛpcagui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngueꞌa̱ stá xipabiyʉ núꞌa̱ xcá xicagui, ne nuyʉ́ xa gamfri, ne xa ba̱di gue xi majua̱ni stá ehe de habʉ ndí ꞌbʉhui, ne xa gamfri gue go gueꞌe xcá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nuga dí aꞌaꞌi gui suyʉ, hingo dí aꞌaꞌi pa gui su núꞌʉ ya ja̱ꞌi hingyá gamfri, hønsɛ dí aꞌaꞌi gui su núyʉ xcá ꞌracagui, ngueꞌa̱ go ri mɛtiyʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ne gatho núꞌa̱ xcá ꞌracagui go ma mɛtiga, ne gatho núꞌa̱ ma mɛtiga go ri mɛti nehe, ne gatho núꞌa̱ ri mɛtigue go ma mɛtiga nehe. Mahyɛgui ma mɛtihʉ. Ne ma nsunda di hnequi ja guehyʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ngu guí pa̱di gue nuga ya hinga ma ga ꞌbʉcua ja ra ximhai, ngueꞌa̱ ma ga mabʉ pa habʉ guí ꞌbʉi. Pe nuyʉ́ ha̱, ma da gohi. Ma ma̱ca Dadaꞌi, jamasu co ri tsꞌɛdi núyʉ toꞌo xcá ꞌracagui, pa njabʉ da ꞌnathoyʉ ngu dí ꞌnathoui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","De stá ꞌbʉcua ja ra ximhai stá jamasugayʉ co ri tsꞌɛdi pa hinxa ꞌuegueyʉ. Stá su núyʉ xcá ꞌracagui, ne hinto maꞌna de guehyʉ xa ꞌmɛdi, nsøctho núꞌa̱ toꞌo dí ꞌñepi da ꞌmɛdi pa da njabʉ ngu ma̱nga ra Ma̱ca Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nubyá ma ga mabʉ habʉ guí ꞌbʉi. Pe de dí ꞌbʉcuatho ja ra ximhai, dí aꞌi go gui subyayʉ, pa njabʉ nuyʉ́ da mɛꞌtsa ra johya ja yá coraso ngu núꞌa̱ dí pɛꞌtsca. ");
INSERT INTO oteNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nuga stá xipabiyʉ ri noya, pe nuya ja̱ꞌi núꞌʉ hingyá gamfri di ʉtsayʉ ngueꞌa̱ nuyʉ́ ya hingyá mɛti ra ximhai, ngugui nehe hingo rá mɛtigui ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hindí aꞌaꞌi pa gui tsitsꞌi de guecua ja ra ximhai, nuꞌa̱ dí aꞌaꞌi, ña̱niyʉ de ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nuyʉ́ ya hingyá mɛti ra ximhai, ngugui nehe hingo rá mɛtigui ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hangue dí aꞌaꞌi gui utuabiyʉ ri noya, pa njabʉ da ꞌuegueyʉ de gatho núꞌa̱ xá ntsꞌo ja ra ximhai, ngueꞌa̱ nuri noya gueꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngu xcá pɛncaguiua ja ra ximhai, njabʉ nehe dí pɛhniyʉ pa da ma gatho ja rá ngʉni ra ximhai pa da ma̱nga ri noya. ");
INSERT INTO oteNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nuga dí hutsꞌi ga unga ma te po rá nguehyʉ ngueꞌa̱ dí øꞌtꞌaꞌi núꞌa̱ go ri paha, pa njabʉ neheyʉ da ꞌyøꞌtꞌaꞌi ri paha ngueꞌa̱ nuyʉ́ pa̱di núꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Hindí aꞌaꞌi pa sɛhɛyʉ, dí aꞌaꞌi nehe pa nuto gatho ma da ꞌyøde núꞌa̱ da ma̱nyʉ, ne da gamfrigui, ");
INSERT INTO oteNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","pa da ꞌnathoꞌʉ ngu dí ꞌnathoui, ngueꞌa̱ nuꞌi ma Dadaꞌi guí ꞌbʉi con gueque ne nuga dí ꞌbʉi con gueꞌe. Ne dí aꞌaꞌi pa núꞌʉ́ ne nujʉ ga ꞌnathohʉ, pa njabʉ gatho ya ja̱ꞌi ja ra ximhai da gamfri gue go gueꞌe xcá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngu xcá ꞌyøtꞌe pa bi hneca ri nsunda ja ma ꞌmʉi nuua ja ra ximhai, njabʉ nehe stá øtꞌe pa da hneca ri nsunda ja yá ꞌmʉiꞌʉ, pa njabʉ da ꞌnathoꞌʉ nehe ngu dí ꞌnathoui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nuga dí ꞌbʉi con gueꞌʉ ne nuꞌi guí ꞌbʉi con gueque, y njabʉ da ꞌnathoꞌʉ, pa njabʉ gatho ya ja̱ꞌi ja ra ximhai da za da ba̱di gue go gueꞌe xcá pɛncagui ne grí ma̱diꞌʉ nehe ngu grí ma̱cagui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ma Dadaꞌi, ya nguí ma̱cagui desde núꞌbʉ mi othotho ra ximhai, ne ꞌnada ra nsunda habʉ ndí ꞌbʉhui. Nubyá núꞌʉ toꞌo xcá ꞌracagui dí ne da mabʉ núbʉ habʉ grá ma, y núbʉ́ ma dí hyanda ma nsunda núꞌa̱ ya ma ga yopa ha̱ni maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ma hoga Dadaꞌi, nuya ja̱ꞌi hingyá gamfri hingui pa̱di toꞌoꞌi, pe nuga ha̱, dí pa̱di toꞌoꞌi, ne núyʉ xcá ꞌracagui pa̱di gue go gueꞌe xcá pɛncagui. ");
INSERT INTO oteNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Stá utuabiyʉ toꞌoꞌigue ne tengu ri ꞌmʉi, ne ga sigui ga utuabi, pa njabʉ ngu grí ma̱cagui, neheyʉ da mɛꞌtsa núꞌa̱ ra hma̱teꞌa̱ ja yá coraso, ne nuga ga ꞌbʉi con guehyʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ha nu mi uadi bi ma̱nga ra Jesu njabʉ, bi ma de guehni co yá nxadi ne bi ꞌrani ja ꞌnara hñe rá thuhu Cedró, pa bi zøniꞌʉ ja ꞌnara ua̱za, nepʉ ja bi yʉtꞌiniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ha nura Juda núꞌa̱ bi da ra Jesu, ya mi pa̱di núꞌa̱ ra ua̱za, ngueꞌa̱ ndunthi ya ꞌmiꞌqui xqui maniꞌa̱ co ra Jesu ne maꞌra yá nxadi, mi muntsꞌiniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nuꞌbʉ́ ra Juda bi zixa ꞌna hmuntsꞌi ya soldado ne ꞌraya gʉntsꞌa̱hni núꞌʉ xqui mɛhna ya nda̱ gá macja̱ ne ya fariseo, ne ja bi maniꞌʉ ja ra ua̱za mri hña̱ ya ñotꞌi ne con te da hñotehma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pe nura Jesu gatho mi pa̱tho núꞌa̱ te mi ma da tꞌøꞌtuabiꞌa̱, hangue bá pøni de ja ra ua̱za pa bi nthɛuiꞌʉ, ne bi ꞌyambabiꞌʉ: ―¿Toꞌo guí hoñhʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ha nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Ra Jesu núꞌa̱ ra me Nasare. Nuꞌbʉ́ nura Jesu bi ꞌñembabiꞌʉ: ―Go guecagui. Ne ra Juda núꞌa̱ toꞌo bi daꞌa̱ mi ꞌbahuini ya soldado ne ya gʉntsꞌa̱hni. ");
INSERT INTO oteNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ha ngu bi uadi bi ma̱nga ra Jesu gue go mi gueꞌa̱, nuꞌbʉ́ nuꞌʉ́ bi mengui dega xʉtha ne bi dagui ja ra hai. ");
INSERT INTO oteNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nepʉ nura Jesu bi yopa ꞌyambabiꞌʉ ne bi ꞌñembabi: ―¿Toꞌo guí hoñhʉ? Ha nuꞌʉ́ bi ꞌñena: ―Ra Jesu núꞌa̱ ra me Nasare. ");
INSERT INTO oteNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ha ra Jesu bi da̱di ne bi ꞌñena: ―Ya stá xiꞌahʉ gue go guecagui. ꞌBʉ go gueque guí hongaguihʉ, oxqui jʉhʉ ni ꞌna de núyʉ drí ꞌñoꞌbe. ");
INSERT INTO oteNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ra Jesu bi ma̱nga njabʉ pa da nja ngu nura noya xqui ma̱ñꞌa̱: “Ni ꞌna hindá ꞌbɛdi de núyʉ xcá ꞌracagui.” ");
INSERT INTO oteNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nuꞌbʉ́ nura Simu Pedro mri hña̱ ꞌnara mahuai, ha bi cꞌoꞌtsi ne bi dacua rá gu de ra ꞌñɛi rá ꞌbɛgo ra da̱nga nda̱ gá macja̱. Y núꞌa̱ ra ꞌbɛgoꞌa̱ mrá thuhu ra Malco. ");
INSERT INTO oteNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nuꞌbʉ́ ra Jesu bi ꞌñembabi ra Pedro: ―Oguí øtꞌa njabʉ, pɛꞌtsa ri huai. Majua̱ni ma ga tho ra thogui, ngueꞌa̱ gueꞌa̱ rá paha Ajua̱ ma Dada. ");
INSERT INTO oteNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nepʉ nuya soldado co yá nda̱ ne co ya gʉntsꞌa̱hni núꞌʉ xqui mɛhna ya nda̱ gá xodyo bi mihiꞌʉ ra Jesu ne bi duꞌti. ");
INSERT INTO oteNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Rá mʉdi bi tsꞌitsꞌiꞌa̱ habʉ mi ꞌbʉ ra Anás, ngueꞌa̱ nuꞌá̱ go mrá ndøhña̱ ra Caifá núꞌa̱ toꞌo mrá da̱nga nda̱ gá macja̱ de núꞌa̱ ra jɛyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nura Caifá go gueꞌa̱ xqui ma̱ ne xqui xipa ya nda̱ gá xodyo gue mri ꞌñepi hønda ꞌna da du po rá ngue ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ha nura Simu Pedro ne maꞌna ra nxadi mri ꞌbɛfa zi yabʉtho mi dɛnga ra Jesu. Núꞌa̱ rá ñoho ra nxadi mrá mpa̱di núꞌa̱ toꞌo mrá da̱nga nda̱ gá macja̱, hangue nuꞌá̱ bi yʉtꞌa ja ra patio de rá nguꞌa̱ habʉ xqui jʉꞌta ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pe nura Pedro bi gohi møte de ra gosthi. Nepʉ núꞌa̱ ra nxadi mrá mpa̱di núꞌa̱ toꞌo mrá da̱nga nda̱ gá macja̱ bi bøni ne bi ña̱ui ra ꞌbɛhña̱ núꞌa̱ mrá nsugosthi pa bi thoca ra Pedro mbo. ");
INSERT INTO oteNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nepʉ núꞌa̱ ra ꞌbɛhña̱ mrá nsugosthi bi ꞌyambabi ra Pedro ne bi ꞌñembi: ―¿Ha hingo gueꞌe gá ꞌñoui dega nxadi nura da̱meꞌa̱? Nepʉ nura Pedro bi da̱di bi ꞌñena: ―Hina, nuga hina. ");
INSERT INTO oteNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ha nuya ꞌbɛgo ne ya gʉntsꞌa̱hni xqui ꞌñu ra tsibi ngueꞌa̱ xmá tsɛ, ne mi ꞌbahni mri mpaꞌti, ha nehe ra Pedro mi ꞌbahuiniꞌʉ mri mpaꞌtiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ha núꞌa̱ ra da̱nga nda̱ gá macja̱ bi ꞌyambabi ra Jesu de yá nxadi ne de rá ntꞌutuate. ");
INSERT INTO oteNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ne nura Jesu bi da̱di ne bi ꞌñena: ―Nuga stá ña̱ ja yá thandi gatho ya ja̱ꞌi, nza̱ntho stá udi ma ntꞌutuate ja ya nija̱ ne ja ra nda̱nija̱ habʉ di muntsꞌa gatho ya xodyo, ne hinstá ña̱ mantꞌa̱gui. ");
INSERT INTO oteNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Hanja go guí angagui? ꞌYambabi toꞌo gatho xa ꞌyøde te stá ma̱. Núꞌʉ́ ha̱, pa̱di xá hño te stá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ha nu mi ma̱nga njabʉ ra Jesu, ꞌnara gʉntsꞌa̱hni mi ꞌbahni bi umba ꞌnara mpɛꞌtiꞌa̱, ne bi ꞌñembabi: ―¿Ha gue njabʉ guí tha̱tuabi ra da̱nga nda̱ gá macja̱? ");
INSERT INTO oteNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nuꞌbʉ́ nura Jesu bi ꞌñembabi: ―Nuꞌbʉ stá ña̱maꞌñʉhma̱, da za gui xiqui te rá ꞌbɛꞌa̱ stá ma̱ xá ntsꞌo. Xiꞌa̱ gue dá ña̱ xá hño, ¿hanja guí nabgagui? ");
INSERT INTO oteNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nepʉ de gueꞌa̱ ra Anás bi mɛhni mi tha̱tꞌitho pa habʉ mi ꞌbʉ ra Caifá núꞌa̱ mrá da̱nga nda̱ gá macja̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ha nura Pedro mi ꞌbahni mri mpaꞌti bi tꞌambabi maꞌnaꞌqui: ―¿Ha hingo gueꞌe gá ꞌñoui dega nxadi núꞌa̱ ra ꞌñøhøꞌa̱? Ha nuꞌá̱ bi ncøni ne bi ꞌñena: ―Hina, nuga hina. ");
INSERT INTO oteNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ha mi ꞌbahni ꞌnará ꞌbɛgo ra da̱nga nda̱ gá macja̱, ne nuꞌá̱ mi ja te mrá njaui núꞌa̱ xqui thacua rá gu, ne nura Pedro go xqui ꞌyøtꞌa njabʉ. Nura ꞌbɛgoꞌa̱ bi ꞌñembabi ra Pedro: ―¿Ha gue hindá hantꞌaꞌini ja ra ua̱za con gueꞌa̱? ");
INSERT INTO oteNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ha nura Pedro bi ncøni maꞌnaꞌqui, ne ꞌbestho nura oraꞌa̱ bi mafi ra menja̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hamxuditho bi tsꞌixa ra Jesu de ja rá ngu ra Caifá pa habʉ mi ja rá tsꞌʉtbi ra Pilato núꞌa̱ mrá gobierhnu, ha nuya xodyo himbi yʉtꞌa mbo ra tsꞌʉtbi pa njabʉ hinda ntsꞌoquiꞌʉ, ne pa njabʉ da za da zi ra hñuni de ra ngo dega pascua. ");
INSERT INTO oteNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nuꞌbʉ́ ra Pilato bi bønga møte habʉ mi ꞌbaiꞌʉ pa bi ꞌyambabiꞌʉ ne bi ꞌñembi: ―¿Te ꞌbɛ guí ne gui ma̱mbabihʉni? ");
INSERT INTO oteNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nuꞌʉ́ bi da̱di ne bi ꞌñembabi: ―ꞌBʉ hinte ma tsꞌoqui xa ꞌyøthma̱, nixi stá tsinꞌahma̱he. ");
INSERT INTO oteNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ha nura Pilato bi ꞌñembabiꞌʉ: ―Tsixhʉ ne go da ꞌyøꞌtuahʉ ra tsꞌʉtbi ngu núꞌa̱ ma̱nga ri leyhʉ. Ha nuya xodyo bi ꞌñena: ―Núje dyá xodyohe hindí pɛꞌtshe ra nsɛqui pa ga hohe ꞌnara ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bi ma̱nga njabʉꞌʉ pa ra Jesu da ꞌyo ja yá ꞌyɛ ya me Nroma, ngueꞌa̱ nuꞌʉ́ ha̱, mi pɛꞌtsa ra nsɛqui pa da nhyoteꞌʉ ja ꞌnara ponza. Hangue bi njabʉ ngu xqui ma̱nga ra Jesu te ma du mi ma da duꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nepʉ nura Pilato bi yopa yʉtꞌi maꞌnaꞌqui habʉ mi ja rá tsꞌʉtbi, ne bi zohna ra Jesu pa bi ꞌyambabi ne bi ꞌñembabi: ―¿Ha go gueꞌe grá Nda̱ de ya xodyo? ");
INSERT INTO oteNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ha ra Jesu bi da̱di ne bi ꞌñena: ―¿Ha gue to xa xiꞌaꞌi, o go guí ma̱nsɛ? ");
INSERT INTO oteNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ha ra Pilato bi ꞌñembabi: ―¿Ha gue drá xodyoga? Nuya mengu ri hai ne ya nda̱ gá macja̱ go gueꞌʉ bá tsiꞌaꞌi de guecua. ¿Te xcá ꞌyøtꞌe? ");
INSERT INTO oteNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nuꞌbʉ́ ra Jesu bi da̱di ne bi ꞌñena: ―Ma nsu dega nda̱ hingo xa ꞌraca ya meximhai. Nuꞌbʉ go xa ꞌracjhma̱ꞌʉ, nuꞌbʉ́ núꞌʉ toꞌo gra manda xa ña̱njhma̱ha̱ de ja yá ꞌyɛ ya nda̱ gá xodyo. Pe numa hmandaga hingo mahyɛgui ngu núꞌʉ jaua ja ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hangue nura Pilato bi ꞌñembabi: ―Nuꞌbʉ́ nuꞌi ꞌnagrá nda̱gueꞌbʉ. Ra Jesu bi da̱di ne bi ꞌñena: ―Ha̱ha̱, drá nda̱ ngu ja juadi gá ma̱. Pa gueꞌa̱ dá e dá ꞌbʉiua ja ra ximhai pa ga xipa ya ja̱ꞌi núꞌa̱ majua̱ni. Nuto gatho camfri núꞌa̱ majua̱ni, go gueꞌʉ øde núꞌa̱ dí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nuꞌbʉ́ ra Pilato bi ꞌñembabi: ―¿To ja gueꞌa̱ pa̱di núꞌa̱ majua̱ni? Ha nu mi ma̱nga njabʉ bi bønga møte pa bá yopa ña̱ui ya xodyo ne bi ꞌñembabiꞌʉ: ―Nuga hinte ma tsꞌoqui dí tsʉtuabi nuna ra ꞌñøhø. ");
INSERT INTO oteNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Numa nza̱ihʉ dí pɛꞌtshʉ dí hɛcꞌahʉ ꞌnara ꞌyofadi núbya de ra ngo dega pascua. Nuꞌbʉ́, ¿ha guí nehʉ ga hɛcꞌahʉ nuni ri Nda̱hʉ núꞌahʉ gyá xodyohʉ? ");
INSERT INTO oteNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ha nuꞌʉ́ bi mʉdi bi mafi gatho ne bi ꞌñena: ―¡Nuní hina, nura Barraba ha̱! Ha núꞌa̱ ra Barraba mrá dacateꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hangue ra Pilato bi manda bri fɛtꞌa ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nepʉ nuya soldado mi ꞌbʉhni bi metꞌa ꞌnara corona dega ꞌbini, ne bi hñuꞌtsuabi ja rá ña̱xu ra Jesu ne bi hyete ꞌnara thɛnga dutu. ");
INSERT INTO oteNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nepʉ bi ꞌñembabiꞌa̱: ―¡ꞌBʉi pa nza̱ntho nuꞌi ri tꞌequꞌei rá Nda̱ꞌi ya xodyo! Nepʉ nuꞌʉ́ mi umba ya mpɛꞌtiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ha nura Pilato bi bønga møte maꞌnaꞌqui ne bi ꞌñembabi ya xodyo: ―Ndi, dra zinꞌaꞌihʉua pa gui pa̱hʉ gue hinte ma tsꞌoqui dí tsʉtuabini. ");
INSERT INTO oteNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ha ra Jesu bi bønga møte mi huꞌtsa núꞌa̱ ra corona dega ꞌbini ne mi he núꞌa̱ ra thɛnga dutu. Nepʉ ra Pilato bi ꞌñemba ya xodyo: ―¡Xi ꞌbacua nuna ꞌñøhø! ");
INSERT INTO oteNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ha nuya nda̱ gá macja̱ ne ya gʉntsꞌa̱hni mi manthoꞌʉ nu mi hyanda ra Jesu, ne mi eñꞌʉ: ―Nuní drá pontꞌi, drá pontꞌi pa da du. Nuꞌbʉ́ ra Pilato bi ꞌñembabiꞌʉ: ―Tsixhʉ, go da bá ponthʉ, ngueꞌa̱ nuga hinte ma tsꞌoqui dí tsʉtuabini. ");
INSERT INTO oteNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nepʉ nuya xodyo bi da̱di ne bi ꞌñena: ―Nuje dí pɛꞌtshe ꞌnara ley, ne nura leyꞌa̱ ma̱ gue nuní dí ꞌñepi da du, ngueꞌa̱ xa ꞌñetꞌa Tꞌʉ de Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ha nu mi ꞌyøde ra Pilato núꞌa̱ mi ma̱ñꞌʉ, maꞌna bi ntsuꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hangue bi zixa ra Jesu maꞌnaꞌqui mbo ja ra tsꞌʉtbi ne bi ꞌyambabi bi ꞌñembi: ―¿Toꞌo rá ꞌmɛhniꞌi? Pe nura Jesu hinte bi da̱di. ");
INSERT INTO oteNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hangue ra Pilato bi ꞌñembabiꞌa̱: ―¿Ha gue hinte guí tha̱di? ¿Ha gue hinguí pa̱di gue dí ha̱ ra tsꞌɛdi pa ga pontꞌaꞌi o pa ga hɛcꞌaꞌi? ");
INSERT INTO oteNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nuꞌbʉ́ nura Jesu bi da̱di ne bi ꞌñena: ―Ni ꞌnara tsꞌɛdi hinguí ha̱ pa da za te gui ꞌyøtcagui ꞌbʉ hingo Ajua̱ da ꞌraꞌa ra tsꞌɛdi. Hangue núꞌa̱ toꞌo xa dagagui ja ri ꞌyɛ, núꞌá̱ go gueꞌa̱ maꞌna tu ra tsꞌoqui que nuꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hangue desde ra oraꞌa̱, ra Pilato mi ne da hyɛguihma̱ꞌa̱, pe nuya xodyo himi tsaya ra hmafi ne mi enaꞌʉ: ―¡Nuꞌbʉ nuꞌi gui hyɛgui núꞌa̱ ra ꞌñøhøꞌa̱, nuꞌbʉ́ hingrí amigo ra da̱nga nda̱ Cesa, ngueꞌa̱ gatho núꞌa̱ toꞌo da ꞌñetꞌa nda̱ gueꞌa̱ rá ncontra ra Cesa! ");
INSERT INTO oteNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ha nu mi ꞌyøde ra Pilato núꞌa̱ mi ma̱ñꞌʉ, nuꞌbʉ́ nuꞌá̱ bi manda da tsꞌixa ra Jesu pa møte, nepʉ neheꞌa̱ bi bøni pa bá hudi ja rá hudi dega tsꞌʉtbi ja ra luga mrá thuhu Gabata dega ebreo, rí bøni da ꞌñena rá thuhu ra Tꞌʉtꞌado. ");
INSERT INTO oteNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Y núꞌa̱ ra paꞌa̱ mrá pa dega nthoqui de ra ngo dega pascua, ne ngu mi nzʉnga ꞌrato xudi. Nepʉ ra Pilato bi ꞌñembabi ya xodyo: ―¡Ndi, ꞌbacua ri Nda̱hʉ! ");
INSERT INTO oteNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pe nuꞌʉ́ bi yopa mafiꞌʉ maꞌnaꞌqui ne bi ꞌñena: ―¡Tsitsꞌi, bá pontꞌi, ne ja dí duni! Nepʉ ra Pilato bi ꞌñembabiꞌʉ: ―¿Ha gue guí nehʉ ga pontꞌa nuna ri Nda̱hʉ? Nepʉ nuya nda̱ gá macja̱ bi da̱di ne bi ꞌñena: ―Nura Cesa hønsɛ go gueꞌa̱ ma nda̱he, y joꞌo maꞌna. ");
INSERT INTO oteNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hangue ra Pilato bi ꞌyɛntꞌua ja yá ꞌyɛ ya xodyo pa dra pontꞌiꞌa̱. Hangue nuꞌʉ́ bi zinga ra Jesu ne bi zitsꞌi pa da pontꞌi ngu mi neꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ne ra Jesu bi bøni mi ndude rá ponza. Ne bi tsꞌitsꞌi pa ja ra tꞌøhø rá thuhu Ña̱xmadu, dega ebreo rá thuhu Golgota. ");
INSERT INTO oteNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ne ja brá pontꞌiniꞌa̱ co má yoho ya ꞌñøhø, ꞌna cada rá hyo, ha ra Jesu bi ꞌyoda madetho de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Y ja ra ponza habʉ bri pontꞌa ra Jesu xqui thøta ꞌnara xithɛ ne mi huxni ꞌraya noya núꞌa̱ bi manda ra Pilato da tꞌofo. Mi ena njabʉ: “Ra Jesu ra me Nasare, rá Nda̱ ya xodyo.” ");
INSERT INTO oteNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ne ndunthi ya xodyo bi hñeꞌta núꞌʉ ya noya, ngueꞌa̱ habʉ bri pontꞌa ra Jesu mi guetbʉ ra hnini Jerusale, y núꞌʉ ya noyaꞌʉ xqui tꞌofo dega ebreo, ne dega griego, ne dega lati. ");
INSERT INTO oteNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ne nuyá nda̱ gá macja̱ ya xodyo bi ma bá embabi ra Pilato: ―¿Hanja gá ofo njabʉ gue go gueꞌa̱ rá Nda̱ ya xodyo? ꞌYofo gue nuꞌá̱ mi ma̱nsɛ gue rá Nda̱ ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ha nura Pilato bi da̱di ne bi ꞌñena: ―Nuꞌa̱ stá ofo, ya stá ofo. ");
INSERT INTO oteNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ha nu mi uadi bi pontꞌa ra Jesu nuya soldado, bi gʉmpa yá dutu ra Jesu núꞌʉ xqui ꞌbøcuabi. Mi goho ya soldado, ne bi hñegue ꞌra ꞌna xɛni nuya dutuꞌʉ. Ne bi gʉmpa rá mahe núꞌa̱ himi pɛꞌtsa ni ꞌnará ntꞌɛdi, mi xøgue ra xʉni. ");
INSERT INTO oteNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nepʉ nuꞌʉ́ bi ꞌñémbabiꞌʉ ꞌna ngu ꞌna: ―Hinga ma ga tʉñhʉ, ma ga rifahʉ pa ga nuhʉ toꞌo drá mɛti. Hangue bi njabʉ ngu ma̱nga ra Ma̱ca Tꞌofo habʉ ena: “Bi nhyegue ꞌra ꞌna xɛni ma dutu, ne bi rifagui núꞌa̱ maꞌna ma he.” Ne gueꞌa̱ bi ꞌyøtꞌa ya soldado. ");
INSERT INTO oteNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Y guetbʉ ja ra ponza mi ꞌbahni rá na̱na̱ ra Jesu, ne ꞌnara ꞌbɛhña̱ núꞌa̱ mrá cu rá na̱na̱ ra Jesu, ne ra Maria rá ꞌbɛhña̱ ra Cleofa, ne ra Maria Magdalena. ");
INSERT INTO oteNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ha nu mi hyanda ra Jesu rá na̱na̱ mi ꞌbahuini núꞌa̱ rá hma̱ca nxadiꞌa̱, nuꞌbʉ́ nuꞌá̱ bi ꞌñembabi rá na̱na̱: ―Nubyá ꞌyøtꞌa ra uɛnda gue núꞌa̱ guí ꞌbahuibʉ go gueꞌa̱ dri tꞌʉbyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nepʉ ra Jesu bi ꞌñembabi nehe núꞌa̱ rá hma̱ca nxadi: ―Neꞌi, ꞌyøtꞌa ra uɛnda gue núꞌa̱ guí ꞌbahuibʉ go gueꞌa̱ dri na̱na̱byaꞌa̱. Y desde gueꞌbʉ, nura hma̱ca nxadi bi zitsꞌiꞌa̱ ja rá ngu pa bi japamasu. ");
INSERT INTO oteNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Y ra Jesu mi pa̱di gue ya bi uadi gatho, nepʉ pa bi nja ngu núꞌa̱ ma̱nga ra Ma̱ca Tꞌofo, nuꞌá̱ bi ꞌñena: ―Tsʉca ra nduthe. ");
INSERT INTO oteNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ha mi jani ꞌnara mohi mi po ra juꞌtsa vinu. Nepʉ bri ꞌboꞌmba ꞌnara sponja co nura juꞌtsa vinu ne bri thøta ja ꞌnara tsꞌʉtꞌo dega isopo, nepʉ bi ꞌbøꞌtse asta ja rá ne ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ha nu mi zi nura juꞌtsa vinu ra Jesu bi ꞌñena: ―Ja xa uadiua gatho núꞌa̱ xra ꞌbɛpcagui. Ne ꞌbestho ra oraꞌa̱ bi ñeꞌmi ne bi du. ");
INSERT INTO oteNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ha mrá pa ra nthoqui de ra ngo dega pascua, hangue nuya nda̱ gá xodyo bi ma bá ba̱ntebi ra Pilato pa da manda dra thempa yá ua núꞌʉ xqui ꞌbontꞌi ne da ja̱ꞌmba yá ndoꞌyo de guehni, pa njabʉ ni ꞌnara anima hinda gohi ja ra ponza nura pa dega tsaya, ngueꞌa̱ núꞌa̱ ra pa dega tsaya gueꞌa̱ ra da̱ngo. ");
INSERT INTO oteNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hangue nuya soldado bi uatꞌi habʉ mi zʉdi ꞌna de núꞌʉ ya be xqui ꞌbontꞌi mahyɛgui co ra Jesu pa bi thempabi yá ua, nepʉ bri jabʉ nehe núꞌa̱ maꞌna ra be. ");
INSERT INTO oteNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pe nu mi uatꞌi habʉ xqui ꞌbontꞌa ra Jesu, nuꞌá̱ ya himbi thempa yá ua ngueꞌa̱ bi hyandiꞌʉ gue ya xqui duꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pe ꞌnara soldado bi umba ꞌnara nsʉni ja rá hyo rá tiña̱ co ꞌnara lansa, nepʉ ꞌbestho bi bønga ra ji ne ra dehe. ");
INSERT INTO oteNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ha núꞌa̱ toꞌo pedena̱, go ꞌna toꞌo bi hyandi, y núna ma̱ go guehna majua̱ni, pa gui camfrihʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bi njabʉ pa bi nja ngu ma̱nga ra Ma̱ca Tꞌofo habʉ ena: “Hindra thempabi ni ꞌnará ndoꞌyoꞌa̱.” ");
INSERT INTO oteNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y nehe bi njabʉ ngu ma̱nga ra Ma̱ca Tꞌofo habʉ ena: “Ya ja̱ꞌi bi hyandi núꞌa̱ bi sʉnsɛꞌʉ.” ");
INSERT INTO oteNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nepʉ ra Jose mrá me Arimatea bi ma bá ba̱ntebi ra Pilato pa da ꞌyapa nsɛqui da ca̱ꞌmba rá zi ndoꞌyo ra Jesu de ja ra ponza ne da dutsꞌiꞌa̱. Ra Jose xqui gamfri ra Jesu, masque mantꞌa̱guitho ngueꞌa̱ mi tsu yá mixodyoui. Ne ra Pilato bi umba nsɛqui, hangue bi ma bá ca̱ꞌmba rá ndoꞌyo ra Jesu de ja ra ponza ne bi dutsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nehe ra Nicodemo núꞌa̱ xqui ma da cꞌa̱ꞌtsa ra Jesu dega xuui, nehe bi mani habʉ xqui ꞌbontꞌiꞌa̱. Nuꞌá̱ mi hña̱ ra mirra mi ntha̱ntsꞌi co ra aloe, mi pɛꞌtsa ꞌnatemaꞌrɛtꞌa kilo rá hñʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nepʉ nuꞌʉ́ bi duꞌtsua rá zi ndoꞌyo ra Jesu, ne bi mantꞌi co ya xʉni dutu núꞌʉ xqui tꞌʉxa núꞌa̱ ra mirra ne ra aloe, ngueꞌa̱ mi njabʉ yá nza̱i yá ntꞌagui ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Y nu habʉ bri pontꞌiꞌa̱, mi jʉmpa guetbʉ ꞌnara ua̱za habʉ mi ja ꞌnara cʉtsꞌi pa ra ntꞌagui, ne hinto xqui ntꞌaguitho ja nura cʉtsꞌiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hangue ja bá aguiniꞌʉ ra Jesu ngueꞌa̱ guehni bi gʉmpa guetbʉꞌʉ de habʉ xqui ꞌbontꞌiꞌa̱, ne ngueꞌa̱ ya mi ma da mʉdi ra pa dega tsaya de ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ꞌNitho núꞌa̱ ndomingo, tobya himi hatsꞌitho, ra Maria Magdalena bi ma habʉ xqui tꞌagui ra Jesu, ne bi hyandi gue xqui tꞌentꞌa ra do núꞌa̱ xqui jotꞌa ra ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hangue nuꞌá̱ bi ma hnestꞌihi pa habʉ mi ꞌbʉi ra Simu Pedro ne núꞌa̱ maꞌna ra nxadi núꞌa̱ xi mrá hma̱di ra Jesu ne bi ꞌñembabiꞌʉ: ―Xa tha̱i ra zi Hmu de habʉ mi tꞌagui ne xa thutsꞌi, y nubyá nixi hindí pa̱he habʉ xá tsꞌoguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nepʉ nura Pedro bi ma ꞌbestho pa da cꞌa̱ꞌtsa ra ntꞌagui co núꞌa̱ maꞌna ra nxadi. ");
INSERT INTO oteNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bi ma hnestꞌihi ri yoho, pe núꞌa̱ maꞌna ra nxadi maꞌna bi ꞌmɛtꞌo de ra Pedro, hangue ꞌmɛtꞌo bi zønga ja ra ntꞌaguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ngu bi zøni bi ndoqui ne bi ncꞌa̱tsꞌi, nepʉ bi hyanda ya xʉni dutu mi ꞌbøni, pe nuꞌá̱ himbi yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nepʉ hinga yaꞌa̱ ꞌbestho bi zønga ra Simu Pedro núꞌa̱ mri ꞌbɛfa, ne nuꞌá̱ ha̱, bi yʉtꞌa mbo ra ntꞌagui ne bi hyanda ya xʉni dutu mi ꞌbøni. ");
INSERT INTO oteNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ne bi hyanda núꞌa̱ ra dutu xqui thuꞌtuahma̱ rá ña̱xu ra Jesu xqui ꞌbantsꞌi ne ꞌnambʉ xqui thutsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nehe núꞌa̱ xqui zønga ra mʉdi, bi yʉtꞌi mbo habʉ bi tꞌagui ra Jesu pa bi hyandi, ne bi gamfri gue ra Jesu xqui yopa nte ngu xqui xipiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nuꞌʉ́ hinxqui zo yá mfeni de núꞌa̱ mi ma̱nga ra Ma̱ca Tꞌofo habʉ ena gue mi pɛꞌtsi da nangui de ja ra du, ne asta nura oraꞌa̱ ja bi zo yá mfeniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nepʉ ri yoho bi mengui pa ja yá nguꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pe nura Maria mi ꞌbahni møte guetbʉ ra ntꞌagui mi zoni, ne ra ora mi zoñꞌa̱ bi ndoqui pa bi ncꞌa̱xa mbo ra ntꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ne bi hyanda yoho ya ɛnxɛ mri hñe tꞌaxi, ꞌna mi hudi habʉ xqui nja rá ña̱xu, ha nuꞌa̱ maꞌna habʉ xqui nja yá ua nuni habʉ xqui ꞌbɛgui hma̱ha̱ rá zi ndoꞌyo ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ha nuꞌʉ́ bi ꞌñembabiꞌa̱: ―Na̱ná̱, ¿hanja guí zoni? Nuꞌá̱ bi ꞌñena: ―Ngueꞌa̱ xa tha̱i ma zi Hmu ne xa thutsꞌi, ne hindí pa̱di habʉ xá tsꞌoguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ne nu mi ma̱nga njabʉꞌa̱, bi ñegui nepʉ bi hyanda ra Jesu mi ꞌbahni, pe nuꞌá̱ himbi ba̱di ua go mi gueꞌa̱ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ha nura Jesu bi ꞌñembabi: ―Na̱ná̱, ¿hanja guí zoni? ¿Toꞌo guí honi? Ha nura Maria mi hu rá mʉi gue go mi gueꞌa̱ ra nsu ua̱za, hangue bi ꞌñembabi: ―Ndada, ꞌbʉ xcá tutsꞌigue, xicagui habʉ xcá tsogui pa ga ma ga tutsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ha nura Jesu bi ꞌñembabi: ―¡Maria! Ra oraꞌa̱ ra Maria bi mpʉntsꞌi ne bi ꞌñembabi dega ebreo: ―¡Raboni! ―Núꞌa̱ ra noyaꞌa̱ rí bøni da ꞌñena Xahnate. ");
INSERT INTO oteNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ha ra Jesu bi ꞌñembabi: ―Oguí thangagui ngueꞌa̱ hinstá matho habʉ bí ꞌbʉ ma Dada, pe rí ma bá xipabi núꞌʉ maꞌra ma cu ne gui ꞌñembabiꞌʉ gue ma ga ma habʉ bí ꞌbʉ ma Dada ne ri Dadahʉ, ma Ajua̱ ne ri Ajua̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nuꞌbʉ́ ra Maria Magdalena bi ma bá xipabi ya nxadi gue xqui hyanda ra zi Hmu, ne bi xipabiꞌʉ ngu núꞌa̱ xqui xipabiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ne nura domingoꞌa̱ de mi nxuui ya nxadi xqui muntsꞌi ne xqui gotꞌa ya gosthi ngueꞌa̱ mi tsu ya nda̱ gá xodyo. Nepʉ bi zønga ra Jesu ne bi ꞌmai madetho de gueꞌʉ ne bi zɛngua bi ꞌñembabiꞌʉ: ―ꞌBʉhʉ te rá ꞌñentho. ");
INSERT INTO oteNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ne nu mi xipabi njabʉꞌʉ, bi ꞌñutuabi yá ꞌyɛ ne rá hyo rá tiña̱. Hangue ya nxadi xi bi johya ngueꞌa̱ bi yopa hyanda ra zi Hmu. ");
INSERT INTO oteNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nuꞌbʉ́ ra Jesu bi yopa ꞌñembabiꞌʉ: ―ꞌBʉhʉ te rá ꞌñentho. Ngu bá pɛncagui Ajua̱ ma Dada, njabʉ nehe dí pɛnꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ne nu mi ma̱nga njabʉ bi huiꞌtiꞌʉ ne bi ꞌñembabi: ―Hña̱ñhʉ ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nuto gatho gui pumbahʉ yá tsꞌoqui, gueꞌʉ dra pumbabi, ne nuto gatho hingui pumbahʉ, gueꞌʉ di tuda yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pe nura ora mi zønga ra Jesu mi joꞌoni ra Toma ꞌna de núꞌʉ ya ꞌrɛtꞌamayoho ya nxadi, núꞌa̱ mi tꞌembi ra Go. ");
INSERT INTO oteNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hangue nu maꞌra ya nxadi bi ꞌñembabi ra Toma: ―Stá hanthe ra zi Hmu. Nepʉ nuꞌá̱ bi ꞌñembabiꞌʉ: ―ꞌBʉ hinga handua yá ꞌyɛ habʉ bi mfoxa ya clavo, ne ꞌbʉ hinga thintꞌa ma dedo habʉ bi mfoxa ya clavo, ne ꞌbʉ hinga thintꞌa ma ꞌyɛ ja rá hyo rá tiña̱, hinga camfri. ");
INSERT INTO oteNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Rá hña̱to ma paꞌa̱ bi yopa muntsꞌa ya nxadi maꞌnaꞌqui, ne nuꞌbʉ́ ha̱, mi ꞌbʉhni nehe ra Toma. Nepʉ bi zønga ra Jesu mi jotꞌa ya gosthi ne bi ꞌmai madetho de gueꞌʉ ne bi zɛngua bi ꞌñembabiꞌʉ: ―ꞌBʉhʉ te rá ꞌñentho. ");
INSERT INTO oteNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nepʉ nuꞌá̱ bi ꞌñembabi ra Toma: ―Ha̱ua ri dedo ne thintꞌa ja ma ꞌyɛ, ne ha̱ua ri ꞌyɛ ne thintꞌa ja rá hyo ma tiña̱. Ográ ꞌña̱gamfri, camfrigui. ");
INSERT INTO oteNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nuꞌbʉ́ ra Toma bi da̱di ne bi ꞌñembabi: ―¡Ma zi Hmuꞌi, ne ma Ajua̱ꞌi! ");
INSERT INTO oteNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nepʉ ra Jesu bi ꞌñembabi: ―¿Ha gue ya xcá camfri ngueꞌa̱ xcá hyandgagui, nugue Toma? Dá nja̱pi nuto gatho camfrigui masque hinxa hyandgagui. ");
INSERT INTO oteNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ndunthi maꞌra ya da̱nga ntꞌudi bi ꞌyøtꞌa ra Jesu ja yá thandi yá nxadi, pe nuꞌʉ́ hinxa tꞌofo ja nuna ra tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pe nuyá bi tꞌofo pa da za gui camfrihʉ gue ma zi Hmuhʉ ra Jesu go gueꞌa̱ ra Cristo rá Tꞌʉ Ajua̱, ne pa ꞌbʉ gui camfrihʉ, da nja ri tehʉ pa nza̱ntho po rá ngueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ꞌMɛfa ra Jesu bi yopa hnequi habʉ mi ꞌbʉi yá nxadi ja ra ndehe rá thuhu Tiberia. Ne bi yopa hnequi njaua: ");
INSERT INTO oteNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ra Simu Pedro mi ꞌbʉhui ꞌnadbʉ ra Toma núꞌa̱ mi tꞌembi ra Go, ne ra Natanael núꞌa̱ ra me Ncaná de Galilea, ne yá tꞌʉ ra Sebedeo, ne má yoho yá nxadi ra Jesu, gathoꞌʉ ꞌnadbʉ mi ꞌbʉi. ");
INSERT INTO oteNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ha ra Simu Pedro bi ꞌñembabiꞌʉ: ―Ma ga ma ra ꞌbɛhua̱. Ha núꞌʉ maꞌra nehe bi ꞌñena: ―Ga maha nehe. Nepʉ bi maꞌʉ ne bi yʉtꞌa ja ꞌnara motsa, pe nura xuuiꞌa̱ hinte bi gʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ha nu mi hyatsꞌi mi ꞌbahni ra Jesu ja rá hyo ra ndehe, pe nuya nxadi himi pa̱di ua go mi gueꞌa̱ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nepʉ nuꞌá̱ bi ꞌñembabiꞌʉ: ―Tsꞌʉntꞌʉhʉ, ¿ha hinte xcá jʉhʉ? Nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Otho. ");
INSERT INTO oteNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ha nuꞌá̱ bi ꞌñembabiꞌʉ: ―Ca̱thʉ ra xitꞌa̱ po ja ra ꞌñɛi de ja ra motsa ne njabʉ da za gui jʉhʉ. Hangue nuꞌʉ́ bi ga̱tꞌa ra xitꞌa̱, ne nu mi gʉtsꞌi xi mi ñuxa ya hua̱ asta himi tsɛdi da pøꞌtseꞌʉ co yá hñʉ ya hua̱ mi cʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nuꞌbʉ́ núꞌa̱ rá hma̱ca nxadi ra Jesu bi ꞌñembabi ra Pedro: ―¡Go guehni ma zi Hmuhʉ! Ha ngu mi ꞌyøde ra Pedro gue go mi gueꞌa̱ ra zi Hmu, nuꞌbʉ́ bi da̱ma hñuxa rá he núꞌa̱ xqui hña̱qui, ne bi hñøtꞌa ja ra ndehe pa bi zønga ja ra ña̱nthe habʉ mi ꞌba ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ne nu maꞌra ya nxadi bi ꞌyɛtꞌa ra motsa pa ja ra ña̱ni, mri gʉtꞌathoꞌʉ ra xitꞌa̱ núꞌa̱ mi ñuxa ya hua̱, ngueꞌa̱ himi yabʉ pa ja ra ña̱ni, ngu mi ꞌna nthebe metro rá yabʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ha nu mi bøniꞌʉ de ra motsa, bi hyanda ꞌraya dɛspi mi zøni, ne ja mi oxni ꞌnara hua̱ mi ntha̱xi, nehe mi jani ꞌraya thuhme. ");
INSERT INTO oteNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nuꞌbʉ́ ra Jesu bi ꞌñembabiꞌʉ: ―Bá ha̱hʉ ꞌraya hua̱ núꞌʉ ja juadi gá jʉhʉ. ");
INSERT INTO oteNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nuꞌbʉ́ ra Simu Pedro bi yʉtꞌa ja ra motsa ne bi pønga ra xitꞌa̱ ja ra ña̱nthe núꞌa̱ mi ñuxa ya da̱nga hua̱, mi ꞌna nthebe made ne hñu yá ndunthiꞌʉ. Y masque mi ndunthi ya hua̱ pe ra xitꞌa̱ himbi ntʉni. ");
INSERT INTO oteNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ha nura Jesu bi ꞌñembabiꞌʉ: ―Bá e gui ntacohʉ. Ha nuya nxadi mri ntsapabi da ꞌyambi toꞌoꞌa̱, ngueꞌa̱ mi pa̱diꞌʉ gue go mi gueꞌa̱ ra zi Hmu. ");
INSERT INTO oteNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nepʉ nura Jesu bi joni ja ra tsibi bi hña̱ca ya thuhme ne bi umbabiꞌʉ; njabʉ nehe bi ꞌyøtꞌe co ra hua̱. ");
INSERT INTO oteNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ya rá hñuꞌquiꞌa̱ xqui ꞌñudi ra Jesu ja yá nxadi nu de ya xqui yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nu mi ua ntacoꞌʉ ra Jesu bi ꞌyambabi ra Simu Pedro ne bi ꞌñembi: ―Nugue Simu, rá tꞌʉꞌi ra Joná, ¿ha gue maꞌna go grí ma̱cagui de guehyʉ maꞌra? Ha nuꞌá̱ bi ꞌñembabi: ―Ha̱ha̱, ma zi Hmuꞌi, nuꞌi guí pa̱di gue drí ma̱ꞌi. Ne nuꞌá̱ bi ꞌñembabi: ―Supca ma zi tꞌʉca dɛti. ");
INSERT INTO oteNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nepʉ rá ñoꞌqui ra Jesu bi ꞌyambabi maꞌnaꞌqui, bi ꞌñembabi: ―Nugue Simu, rá tꞌʉꞌi ra Joná, ¿ha grí ma̱cagui? Ra Pedro bi da̱di ne bi ꞌñembi: ―Ha̱ha̱, ma zi Hmuꞌi, nuꞌi guí pa̱di gue drí ma̱ꞌi. Ne nuꞌá̱ bi ꞌñembabi: ―Supca xá hño ma zi dɛti. ");
INSERT INTO oteNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nepʉ rá hñuꞌqui bi ꞌyambabi maꞌnaꞌqui, ne bi ꞌñembabi: ―Nugue Simu, rá tꞌʉꞌi ra Joná, ¿ha grí ma̱cagui? Ra oraꞌa̱ bi du rá mʉi ra Pedro ngueꞌa̱ ya rá hñuꞌqui bi ꞌyambabi ua mi ma̱diꞌa̱, ne bi ꞌñembabi: ―Ma zi Hmuꞌi, nuꞌi gatho go guí pa̱di, ne guí pa̱di gue xi drí ma̱ꞌi. Nuꞌbʉ́ ra Jesu bi ꞌñembabi: ―Supca xá hño ma zi dɛti. ");
INSERT INTO oteNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Xi majua̱ni dí xiꞌaꞌi, núꞌbʉ nguí ntsꞌʉntꞌʉ nguí hesɛ ri he ne nguí ꞌyo habʉ go nguí ne. Pe nu xcrí nda̱xjua ma gui tʉnga ri ꞌyɛ, ne maꞌna to ma da hyeꞌtꞌaꞌi ri he, ne da zixꞌaꞌi habʉ hingo gui negue. ");
INSERT INTO oteNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Bi ma̱nga njabʉꞌa̱ pa bi xipi te ma du mi ma da du ra Pedro pa da hnequi rá nsunda Ajua̱. Ne nu mi ma̱nga njabʉ bi ꞌñembabi: ―¡Tɛngagui! ");
INSERT INTO oteNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nepʉ nura Pedro bi ñegui ne bi hyandi gue mi dɛna núꞌa̱ rá hma̱ca nxadi ra Jesu, núꞌa̱ xqui hñudi ja rá hyo ra Jesu núꞌbʉ mi ntꞌoxiꞌʉ ne xqui ꞌyambabi toꞌo mi ma da daꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ne nuꞌbʉ́ ra Pedro nu mi hyantꞌa̱ bi ꞌyambabi ra Jesu: ―Ma zi Hmuꞌi, xi nuni, ¿te go ma da jani? ");
INSERT INTO oteNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nuꞌbʉ́ ra Jesu bi da̱di: ―Nuꞌbʉ go ga negá nuni da ꞌmʉi asta ra pa ga pengui, ¿te go grí ꞌñanigue? Nuꞌi go da tɛngagui. ");
INSERT INTO oteNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hangue nuna ra ꞌbedena̱ bi ꞌño ja gatho ya gamfri, ne bi beniꞌʉ gue nura nxadiꞌa̱ himi ma da du. Pe ra Jesu himbi ꞌñena gue himi ma da du, hønsɛ bi ꞌñena: “Nuꞌbʉ go ga negá nuni da ꞌmʉi asta ra pa ga pengui, ¿te go grí ꞌñanigue?” ");
INSERT INTO oteNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Núꞌa̱ ra hma̱ca nxadiꞌa̱ go gueꞌa̱ di damajua̱ni de nuya ya tꞌøtꞌe bi nja, ne bi ꞌyofo ja nuna ra tꞌofo. Ne dí pa̱he gue núꞌa̱ bi ꞌyofo gueꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nehe ja ndunthi maꞌra ya tꞌøtꞌe núꞌʉ bi ꞌyøtꞌa ra Jesu. ꞌBʉ to da ꞌyofo gathoꞌʉ dí beni gue nuya tꞌofoꞌʉ hinda ꞌñɛni gatho maxøgue rá ngʉni ra ximhai. Njabʉ gueꞌa̱.");
INSERT INTO oteNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Núga drá Luca, nura mʉdi tꞌofo dá ofo ne dá pɛhnꞌabʉ, zi cu Teofilo, ja ma̱ni gatho núꞌa̱ te bi ꞌyøtꞌa ma zi Hmuhʉ ra Jesucristo, ne núꞌa̱ bi ꞌñudi desde ra paꞌa̱ bi fʉta rá ꞌbɛfi, ");
INSERT INTO oteNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta ra pa bi yopa mengui pa mahetsꞌi. Pe ante da ma pa mahetsꞌi, bi zofo yá apostol núꞌʉ xqui huahni, ne po ra Ma̱ca Nda̱hi bi xipabi te mi ma da ꞌyøtꞌeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ꞌMɛfa de xqui du ra Jesu ja ra pontꞌi ne de xqui yopa nte, núꞌá̱ bi ꞌmʉcua má ñote ma pa, ne mri ꞌñudi ja yá apostol pa bi gamfriꞌʉ gue ya xqui yopa nte maꞌnaꞌqui, ne pa mi xipabiꞌʉ de hanja ri manda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Y de mi ña̱ui yá apostol ante da maꞌa̱ pa mahetsꞌi, bi ꞌñembiꞌʉ: ―Oxqui ma gui pøñhʉ de guecua Jerusale, ja da ꞌbʉhʉua asta hingui ha̱ñhʉ núꞌa̱ xa ña̱ꞌtꞌahʉ Ajua̱ ra Dada, núꞌa̱ ya stá xiꞌahʉ gue ma gui ha̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ra Xuua mi xiꞌtsate co ra dehe, pe nuꞌahʉ́ ya ꞌbestho ma da zø ra pa gui nxistehehʉ co ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Y de mi ña̱ui yá apostol bi ꞌñaniꞌʉ bi ꞌñembi: ―Ma zi Hmuꞌihe, ¿ha gue nuya pabya ma gui umba maꞌnaꞌqui rá tsꞌɛdi ra hnini Israel pa da nda̱? ");
INSERT INTO oteNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nuꞌbʉ́ ra Zidada Jesu bi da̱tuabiꞌʉ ne bi ꞌñembi: ―Hingo rí ꞌñepꞌahʉ gui pa̱hʉ haꞌmʉ ma da ꞌyøtꞌa Ajua̱ ra Dada núꞌa̱ xa bensɛꞌa̱ da ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nuꞌahʉ, nuꞌa̱ ma da nja, ma gui ha̱ñhʉ rá tsꞌɛdi ra Ma̱ca Nda̱hi sta zøhø, ne ma gui dahʉ majua̱ni de gueque nuua Jerusale, ne gatho rá ngʉni Judea, ne nuni Nsamaria, ne gatho maxøgue rá ngʉni ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nu mi uadi bi ma̱nga njabʉ ra Zidada Jesu bi njʉtsꞌi pa maña̱ ja yá thandi yá apostol. Nepʉ bi hyandiꞌʉ gue bi goꞌma ꞌnara guui, ne ya himbi za bi yopa hyantꞌʉ maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nepʉ de mi nøtsꞌe mi handa ra Jesu bi ma pa mahetsꞌi, mi da̱mfriꞌʉ mi ꞌbahni yoho ya ɛnxɛ con gueꞌʉ, mri hñe dega tꞌaxi. ");
INSERT INTO oteNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Y núꞌʉ ya ɛnxɛꞌʉ bi ꞌñembabi ya apostol: ―Núꞌahʉ gyá me Galileahʉ, ¿te ꞌbɛ guí nøꞌtshʉ nuni mahetsꞌi? Nura Jesu xcá hyanthʉbya xa ma pa mahetsꞌi, go guetꞌatho ma da yopa menguiua ngu xcá hyanthʉ bi ma, njabʉ ma da mengui. ");
INSERT INTO oteNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nepʉ yá apostol ra Jesu bi ga̱i de ja ra tꞌøhø ꞌbo Olivo pa bi ma ja ra hnini Jerusale. Nurá ñabʉ de ra tꞌøhø pa ja ra hnini pɛꞌtsa ngu ꞌna kilometro. ");
INSERT INTO oteNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Y nu de mi zøniꞌʉ mbo ja ra hnini, bi bøxa ja ra tøngu habʉ xqui mihiꞌʉ, ne ja mi ꞌbʉhni ri gathoꞌʉ, ra Pedro, ra Cobo, ra Xuua, ra Andre, ra Lipe, ra Toma, ra Tolo, ra Teo, maꞌna ra Cobo rá tꞌʉ ra Alfeo, ne ra Simu núꞌa̱ mi tꞌembi ra Selote, ne ra Juda rá cu ra Cobo. ");
INSERT INTO oteNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gathoꞌʉ nza̱ntho mi muntsꞌi mi apabi Ajua̱ co ꞌnada ra mfeni, mahyɛgui co yá cu ra Jesu, ne ra Maria rá na̱na̱ꞌa̱, ne maꞌra ya ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ha nuya paꞌʉ bi muntsꞌini ngu ꞌna nthebe ne ꞌnate ya cu, y ꞌnaꞌqui, ra cu Pedro bi ꞌmai madetho de gueꞌʉ ne bi ꞌñembiꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Ma zi cuꞌihʉ, pɛꞌtsi te xi da njabʉ ngu núꞌa̱ xqui ma̱nga ra Davi ne bi ꞌyofo ngu núꞌa̱ xqui xipabi ra Ma̱ca Nda̱hi. Ra Davi bi ma̱ de ra Juda núꞌa̱ toꞌo bi zixa ya ja̱ꞌi pa bá jʉ ma zi Hmuhʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Y nujʉ dí pa̱hʉ gue nuꞌá̱ go gueꞌa̱ nehe mrá nxadi ra Jesu, ne mahyɛgui ndí pɛphʉꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nuꞌá̱ bi pa ma zi Hmuhʉ ra Jesu, y co núꞌa̱ ra boja̱ bi tꞌumbi, bi thanga ꞌnara hai. Nepʉ nuꞌá̱ bi dagui maꞌmɛmfo, ne ꞌbestho bi fø rá mʉi ne bi bønga yá xefo, y bi du. ");
INSERT INTO oteNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Y gatho ya me Jerusale bi ba̱di núꞌa̱ xqui nja, hangue nuꞌʉ́ bi hñuꞌmbabi nura haiꞌa̱ de yá hña̱quiꞌʉ Aceldama, rí bøni da ꞌñena ra Hai dega Ji. ");
INSERT INTO oteNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pɛꞌtsi te da njabʉ ngu núꞌa̱ xa tꞌofo ja ra Ma̱ca Tꞌofo ja ya Salmo ne ena: Dá nhuata rá nguꞌa̱, oto sti ma da ꞌmʉini. Nehe ena: Nuꞌa̱ mrá ꞌbɛfihma̱ꞌa̱, dá mɛ maꞌna ra ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Hangue mahyoni ga huañhʉbya ꞌna de núꞌʉ toꞌo ndí ꞌñohʉ gatho núꞌʉ ya pa ndá ꞌbʉhʉ co ma zi Hmuhʉ ra Jesu, ");
INSERT INTO oteNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde mi xiꞌtsa ra Xuua asta mi ma mahetsꞌi. Nuꞌa̱ tóꞌo ma ga huahnihʉ go gueꞌa̱ ma da maxcahʉ ga dahʉ majua̱ni gue ma zi Hmuhʉ ra Jesu ya xa yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nepʉ bi huahniꞌʉ ꞌnara cu rá thuhu ra Jose núꞌa̱ xqui thuꞌmbabi ra Barsabá ne mi tꞌembi ra Justo, ne bi huahniꞌʉ maꞌna ra cu rá thuhu ra Matía. ");
INSERT INTO oteNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nepʉ bi ꞌyapabiꞌʉ Ajua̱ ne bi ꞌñena: ―Ma zi Dadaꞌihe, go gueꞌe guí pa̱tca gatho ma mfenihe, ꞌñutcahebya de nuya yoho ya cu ꞌbʉcua toꞌo de guehyʉ xcá huahni. ");
INSERT INTO oteNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nuꞌi go guí pa̱di ndaꞌña̱ de guehyʉ xcá huahni pa da mɛpꞌaꞌi ne go di guehni dri apostol pa drá mpøte ra Juda núꞌa̱ toꞌo bi ntsꞌoqui ne bi ꞌuegue bi ma habʉ mri ꞌñepi da ma. ");
INSERT INTO oteNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Y nuꞌʉ́ bi rifa ne bi zo rá thuhu ra Matía, hangue ya bi ma ꞌmede co núꞌʉ ꞌrɛtꞌamaꞌra yá apostol ra Zidada Jesu, pa bi yopa nzøtꞌa núꞌʉ ꞌrɛtꞌamayoho. ");
INSERT INTO oteNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nu mi zøhø ra pa de ra Pentecoste yá ngo ya xodyo, gatho ya gamfri xqui muntsꞌa ꞌnadbʉ co ꞌnada ra mfeni. ");
INSERT INTO oteNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nepʉ mi da̱mfriꞌʉ bi ntꞌøde ꞌnara ñʉni xi ntsꞌɛdi xqui ꞌñe de mahetsꞌi. Bi ntꞌøde gatho mbo ra ngu habʉ xqui muntsꞌiꞌʉ ngu ꞌñena ꞌnara da̱nga bʉnthi xi ntsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne ꞌmɛfa bi hnequi ꞌra ngu ya tꞌʉca faspi maña̱ de ja yá ña̱xu cada ꞌna de nuto gatho mi ꞌbʉhni. ");
INSERT INTO oteNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Y gathoꞌʉ bi hña̱nga ra Ma̱ca Nda̱hi, ne bi mʉdi bi ña̱ ꞌramaꞌnaꞌño ya hña̱qui cada ꞌna de gueꞌʉ ngu mi japabi ra Ma̱ca Nda̱hi da ña̱ꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nuya paꞌʉ mi ꞌbʉhni Jerusale ꞌraya xodyo xqui ꞌñehe de habʉraza ya hai de ra ximhai, ne nuꞌʉ́ xi mi camfri Ajua̱ ngu núꞌa̱ xqui tꞌutuabi. ");
INSERT INTO oteNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Y nu de mi ntꞌøde núꞌa̱ ra da̱nga ñʉni, ndunthi ya ja̱ꞌi xi bi da̱ma muntsꞌi habʉ mi ꞌbʉi ya cu, ne bi ꞌyø ngueꞌa̱ mi øde yá hña̱qui cada ꞌna de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ne himi pa̱ te da beni, bi ꞌyø ne mri ꞌñémbabiꞌʉ: ―¿Ha gue hingo guehyʉ ya me Galilea núyʉ dí øhʉ ña̱? ");
INSERT INTO oteNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nuꞌbʉ́ ¿hanja cada ꞌna de guecjʉ dí ø ma hña̱quihʉ núꞌa̱ dá pa̱hʉ desde dá ꞌbʉhʉ? ");
INSERT INTO oteNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ngueꞌa̱ ꞌra de guecjʉ dyá menguhʉ Partia ne de Media, ne de Elam, ne de Mesopotamia, ne de Judea, ne de Capadocia, ne de Mponto, ne de Asia. ");
INSERT INTO oteNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ne nu maꞌra de guecjʉ ya me Frigia, ne Pamfilia, ne Egipto, ne ꞌraya hnini de Africa gueta Cirene. Ne nu maꞌra de guecjʉ ya me Nroma, ꞌra majua̱ni ya xodyo ha nu maꞌra bi nxodyo hønsɛ ngueꞌa̱ ri dɛnga ma leyhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ne nu maꞌra de guecjʉ ya me Creta ne Arabia. Ha gatho nugaguihʉ dí øhʉ xicjʉ de ma hña̱quihʉ gra ña̱ cada ꞌna de guehyʉ, ne xicjʉ de nuya da̱nga tꞌøtꞌe xa ꞌyøtꞌa Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nepʉ núꞌʉ ya ja̱ꞌiꞌʉ bi ntsøꞌmi ne mi tu yá mʉi mri ꞌñémba ꞌna ngu ꞌna: ―¿Xibya? ¿Te rí bømbyana̱? ");
INSERT INTO oteNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ha nu maꞌra mi øtbuhlatho mi ena: ―Nuyʉ́ xa nti. ");
INSERT INTO oteNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nuꞌbʉ́ ra oraꞌa̱ ra apostol Pedro bi ꞌmai co núꞌʉ má ꞌrɛtꞌamaꞌra ya apostol, nepʉ bi ña̱ ntsꞌɛdiꞌa̱, bi ꞌñena: ―Núꞌahʉ gyá me Judeahʉ ne gatho núꞌahʉ guí ꞌbʉhʉua Jerusale, ꞌyøhʉ núna ma ga ma̱ pa gui pa̱hʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Núyʉ guí øhʉ ña̱, hindi ti ngu guí beñhʉ, ngueꞌa̱ ja nzʉnga gʉto xudi. ");
INSERT INTO oteNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Núna guí hanthʉ, go guehna xqui ma̱nga ra ba̱di Joel gue mi pɛꞌtsi da njabʉ, y nubyá ya gá hyanthʉ bi nja ngu núꞌa̱ bi ma̱ñꞌa̱. Nuꞌá̱ bi ꞌyofo njaua: ");
INSERT INTO oteNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ajua̱ bi ꞌñena: Nuya pa da ꞌñepʉ, ma ga pɛmpa ra Ma̱ca Nda̱hi gatho ya ja̱ꞌi de ra ximhai. Nuri tꞌʉhʉ ne ri tꞌixuhʉ ma da ña̱ co rá tsꞌɛdi ra Ma̱ca Nda̱hi. Nuya ba̱sja̱ꞌi ma da hyanda ꞌraya ntꞌudi, nuya nda̱xjua ma da ꞌui ya tꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ne nuya paꞌʉ gatho núꞌʉ pɛpqui, dra ꞌñøhø que dra ꞌbɛhña̱, ma ga pɛmpabiꞌʉ ra Ma̱ca Nda̱hi pa da umba ra tsꞌɛdi da ña̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ne ma ga uꞌtꞌahʉ ꞌraya da̱nga ntꞌudi nuni mahetsꞌi ne nuua ra ximhai, dega ji, ne dega tsibi, ne dega ꞌbifi. ");
INSERT INTO oteNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma gui hyanthʉ ra hyadi hinda ma da unga ra ñotꞌi, ma da ꞌmɛxuui. Nura za̱na̱ ngu ma da nji. Nepʉ de gueꞌa̱ ja da zøhø núꞌa̱ ra pa de rá ꞌñehe ra Zidada, gueꞌa̱ ra pa ma da hneca rá da̱nga tsꞌɛdiꞌa̱ strá nsunda. ");
INSERT INTO oteNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne gatho núꞌʉ toꞌo da ꞌyapa ra Zidada da mpøhø, da pøhøꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Núꞌahʉ gyá me Israelhʉ, ꞌyødehʉ nuya ya noya ma ga xiꞌahʉ: Nuꞌahʉ́ guí pa̱hʉ gue ra Jesu núꞌa̱ mrá me Nasare bi ꞌyøtꞌa gatho núꞌʉ ya tꞌøtꞌe ne gatho núꞌʉ ya ntꞌudi bi ꞌyøtꞌe con gueꞌahʉ po rá tsꞌɛdi Ajua̱, ngu guí pa̱sɛhʉ, y njabʉ bi hnequi gue Ajua̱ xqui mɛhniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pe nuꞌá̱ bri da ja ri ꞌyɛhʉ, nepʉ nuꞌahʉ gá daphʉ ja yá ꞌyɛ ya ꞌyøtꞌatsꞌoqui pa bi pontꞌa ja ꞌnara pontꞌi asta himbi du. Pe gatho núꞌa̱ bi nja, bi njabʉ ngueꞌa̱ Ajua̱ go bi bensɛ da njabʉ y núꞌá̱ gueꞌa̱ mrá pahaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nuꞌahʉ gá hyohʉ ra Jesu, pe nu Ajua̱ go gueꞌa̱ bi ꞌyøtꞌe pa bi yopa nte maꞌnaꞌqui de ra du, ngueꞌa̱ nura du otho rá tsꞌɛdi pa da za̱miꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ra nda̱ Davi xqui ma̱ de gueꞌa̱ ne xqui ꞌñena: Nuga dí pa̱di gue Ajua̱ nza̱ntho ꞌbʉi con gueque pa da maxcagui ne da ña̱ngagui. ");
INSERT INTO oteNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hangue nuga xi drí johya ne dí ña̱ co nura johya dí pɛꞌtsi. Ne dí tøꞌmi gue nu xcrá tu, ma ga yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ngueꞌa̱ nuꞌi, ma Dadaꞌi, hingui ma gui hopi ja da gohni ma te ja ra du, nixi gui hopi da ꞌya ma ndoꞌyo ja ra hai, ngueꞌa̱ go ri hma̱ca ꞌbɛgogui. ");
INSERT INTO oteNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ngueꞌa̱ nuꞌi xcá ꞌñutca ra ꞌñu dega te, ne ma gui ꞌraca ꞌnara da̱nga johya nu xcrá ꞌbʉpʉ mahetsꞌi con gueꞌe. Guehna bi ma̱nga ra Davi ja ra Ma̱ca Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Núꞌahʉ ma cuꞌihʉ xcá muntsꞌihʉua, xi majua̱ni dí xiꞌahʉ, xa du ma xitahʉ ra nda̱ Davi ne bi ntꞌaguiꞌa̱, ne jaua rá ntꞌagui asta mapaya. ");
INSERT INTO oteNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ra Davi mrá ꞌmɛhni Ajua̱ hangue nuꞌá̱ bi ma̱ núꞌa̱ mri ꞌbɛdi da nja. Ne mi pa̱di gue mi ma da ꞌmʉ ꞌnará tꞌʉ pa drá mpøteꞌa̱, ngueꞌa̱ njabʉ xqui ña̱ꞌtuabi Ajua̱. Y núꞌa̱ ra tꞌʉꞌa̱ go di gueꞌa̱ ra Cristo núꞌa̱ xqui ña̱ꞌtuabi da mɛhni pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hangue nura Davi ꞌñena ya xqui hyanda núꞌa̱ bi nja ꞌmɛfa, ne bi ꞌyofo gue mi pɛꞌtsi da e da yopa nte ra Cristo núꞌa̱ xqui hñutsꞌi Ajua̱ pa da nda̱, ne himi ma ja da gohni rá te ja ra du, nixi rá ndoꞌyo nehe hinda ꞌya ja ra hai. ");
INSERT INTO oteNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Y nuna ra Jesu dí ma̱ñhe, nuje dí dahe majua̱ni gue Ajua̱ bi ꞌyøtꞌe pa bi yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hangue nubya po rá tsꞌɛdi Ajua̱ ra Dada, bi ma pa mahetsꞌi, ne ja bí huhni ja rá ꞌñɛi ra Dada. Ne bá pɛhna ra Ma̱ca Nda̱hi ngu núꞌa̱ xqui ña̱gui Ajua̱ ra Dada. Hangue gatho núꞌa̱ guí hanthʉ ne guí øhʉbya, go ra Ma̱ca Nda̱hi øtꞌa njabʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pe ra nda̱ Davi hingo bi njʉtsꞌi pa mahetsꞌi, pe nuꞌá̱ bi ma̱ñꞌa̱ bi ꞌñena: Ajua̱ ra Dada bi ꞌñemba ma zi Hmu: “Bá ehe gui hñudiua ja ma ꞌñɛi, ");
INSERT INTO oteNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta hinga tsiñꞌaꞌi gatho ri ncontra pa da gohiꞌʉ ja ngaꞌti ri ua.” ");
INSERT INTO oteNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nubyá, mahyoni da ba̱di gatho ya me Israel gue Ajua̱ ra Dada xa hñuxa ra Jesu pa go di gueꞌa̱ dra Hmu ne da nda̱ ngueꞌa̱ go gueꞌa̱ ra Cristo xpá pɛhniꞌa̱. Y go gueꞌa̱ gá ponthʉ ja ra pontꞌi ne asta hingá hyohʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ha nu mi ꞌyøde núꞌa̱ bi ma̱nga ra apostol Pedro, núꞌʉ ya ja̱ꞌi mi ꞌbʉhni xi bi du yá mʉi, ne bi ꞌyambabi ra apostol Pedro ne núꞌʉ maꞌra ya apostol, bi ꞌñembi: ―Zi cuhʉ, nuꞌbʉ́ ¿xi te rá ꞌbɛ mahyoni ga øthebya? ");
INSERT INTO oteNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nepʉ ra apostol Pedro bi ꞌñembabi: ―Ñobrihʉ ne gui nxistehehʉ gathoꞌihʉ de rá thuhu ra Zidada Jesucristo pa njabʉ dra punꞌa ri tsꞌoquihʉ. Ne njabʉ ha̱, Ajua̱ da pɛnꞌaꞌihʉ ra Ma̱ca Nda̱hi pa da ꞌmʉ ja ri corasohʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ngueꞌa̱ nuna hña̱ꞌtina̱ pa gueꞌahʉ ne pa ri ba̱tsihʉ ne pa gatho maꞌra ya ja̱ꞌi ꞌbʉ ja rá ngʉni ra ximhai núꞌʉ da zohna Ajua̱ ma Hmuhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ra apostol Pedro bi sigui bi zofo ya ja̱ꞌi co ndunthi maꞌra ya noya ne bi ꞌñembabi: ―Mpøhøhʉ pa hinda zʉꞌahʉ rá cuɛ Ajua̱ núꞌa̱ ma da zʉdi núꞌʉ hingui ne da mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nepʉ gatho núꞌʉ toꞌo bi hña̱ni núꞌa̱ ra tsꞌofoꞌa̱ bi nxistehe ꞌbestho. Hangue nura paꞌa̱ bi hñuxa ngu má hñu ꞌmo ya gamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Y nuꞌʉ́ bi ꞌyøtꞌa gatho núꞌa̱ bi xipabi ya apostol. Ne mi ꞌbʉꞌʉ co ꞌnadra mfeni, ne nza̱ntho mri muntsꞌa mahyɛgui pa da zi ra Ma̱ca Ntꞌoxi ne pa mi apabi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne gatho ya mengu de guehni xi bi ntsu ngueꞌa̱ xqui hyanda ya apostol mi øtꞌa ndunthi ya da̱nga ntꞌudi ne ya da̱nga tꞌøtꞌe co rá tsꞌɛdi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ne gatho núꞌʉ ya gamfri mi ꞌbʉi ꞌnadbʉ ne mri mfaxꞌʉ ꞌna ngu maꞌna pa hinte da ꞌbɛpiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ne mi pa gatho núꞌa̱ te mi pɛꞌtsiꞌʉ ne mi hecuabi gatho núꞌʉ maꞌra ya zi hyoya cu núꞌʉ mi othobi. ");
INSERT INTO oteNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ne hyastho ꞌnara pa ngu ꞌnara pa mri muntsꞌa ja ra nija̱ co ꞌnadra mfeni. Ne mi tsi ra Ma̱ca Ntꞌoxi ja yá nguꞌʉ, ne mri ñuniꞌʉ mahyɛgui co ndunthi ra johya ne co ꞌnara hoga mfeni. ");
INSERT INTO oteNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ne mri nsunda Ajua̱ mahyɛgui. Ne maꞌra ya ja̱ꞌi mi handi te mi øtꞌeꞌʉ, nuꞌbʉ́ nuya ja̱ꞌiꞌʉ mi numahñoꞌʉ. Ne ꞌnara pa ngu ꞌnara pa mi ꞌyo mi camfri maꞌra ya ja̱ꞌi núꞌʉ mi zofo Ajua̱, ne mri muntsꞌa ꞌnadbʉꞌʉ co núꞌʉ ya mʉdi gamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ꞌNara pa ra apostol Pedro ne ra apostol Xuua mri ma pa ja ra nda̱nija̱ ngu nzʉnga hñu nde, ya mi gueꞌa̱ ra ora pa ra søcambeni ja ra nija̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Y nuni ja ra gosthi nija̱ núꞌa̱ mrá thuhu Mahotho, ja xqui hñudini ꞌnara ꞌñøhø mrá doua desde xqui ꞌmʉi. Mi tsꞌixa hyastho pa ja mi tꞌehni pa mi apabi ra boja̱ gatho núꞌʉ toꞌo mi thohni mi cʉtꞌa mbo ra nda̱nija̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nuꞌbʉ́ nuꞌá̱ bi hyanda ra apostol Pedro ne ra apostol Xuua de mi ma da yʉtꞌa ja ra nda̱nija̱, bi ꞌyapabi ra boja̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nepʉ nura Pedro ne ra Xuua bi gohi bi ꞌmai bi hyanda núꞌa̱ ra zi mɛti, ne ra Pedro bi ꞌñembabi: ―Hyandgahe. ");
INSERT INTO oteNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ne nura zi doua xi bi gohi bi nʉꞌta núꞌʉ yoho ya apostol, mi hu rá mʉi gue mi ma te da umbahma̱ꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nepʉ ra Pedro bi ꞌñembabi: ―Othogui ra tꞌaxi nixi ra oro pa ga ꞌraꞌaꞌi. Núꞌa̱ dí pɛꞌtsi gueꞌa̱ ma ga ꞌraꞌi. De rá thuhu ra Jesucristo núꞌa̱ mrá me Nasare dí xiꞌaꞌi gui ꞌbai gui ꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nepʉ bi mipa rá ꞌyɛ ra ꞌñɛi ne bi ꞌbaꞌmi, ne ꞌbestho bi nja yá tsꞌɛdi yá ua ne yá gutꞌɛgui. ");
INSERT INTO oteNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Y nura oraꞌa̱ ꞌbestho bi ꞌyɛnga ꞌnara sagui ne bi ꞌmai xá hño, nepʉ bi ꞌño, ne bi mɛui ya apostol pa mbo ra nija̱ xi mi ɛnsagui mi xøcambeni Ajua̱ con gatho rá johya. ");
INSERT INTO oteNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Y gatho ya ja̱ꞌi bi hyanda núꞌa̱ mrá doua gue ya mi ꞌyo ne mi xøcambeni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nepʉ nuꞌʉ́ ꞌbestho bi ba̱di gue go mi gueꞌa̱ mrá douahma̱ nza̱ntho mi hudi mi a ra boja̱ ja ra gosthi nija̱ mrá thuhu Mahotho. Ne xi bi ꞌyøꞌʉ de núꞌa̱ xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ꞌMɛfa núꞌa̱ ra ꞌñøhø mrá doua himi ne da ꞌuegue de ra apostol Pedro nixi de ra apostol Xuua. Y gatho nuya ja̱ꞌi mi ꞌyo de guehni xi mri ꞌyø de núꞌa̱ xqui hyandi, hangue bi da̱ma muntsꞌiꞌʉ ja ra porta rá thuhu ra Porta de ra Salomó nuni habʉ mi ꞌbai ra Pedro ne ra Xuua co núꞌa̱ mrá doua. ");
INSERT INTO oteNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Y nu mi hyanda ra Pedro núꞌʉ ya ja̱ꞌi xqui muntsꞌini, bi ꞌñembabi: ―Núꞌahʉ gyá me Israelhʉ, ¿hanja xi grí ꞌyøhʉ, ne hanja xi guí nʉtcahe ꞌñena gue co ma tsꞌɛdisɛhe go stá japhe xa ꞌño nuna ꞌñøhø, o ꞌñena ngueꞌa̱ gue por dí ꞌyohe xá ntꞌaxi gue por gueꞌa̱ stá japhe da ña̱ni? ");
INSERT INTO oteNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Núꞌa̱ ra Ajua̱ mi xøcambeni ra Abrá ne ra Isaac ne ra Cobo ne gatho núꞌʉ maꞌra ndu ma xitahʉ, núꞌá̱ go guetꞌa̱ ra Ajua̱ bi japi bi ꞌño nuna ra ꞌñøhø po rá thuhu ra Jesucristo nurá Tꞌʉꞌa̱, pa njabʉ da hneca rá tsꞌɛdi nura Tꞌʉꞌa̱. Núꞌá̱ go gueꞌa̱ gá daphʉ ya nda̱, ne gá ma̱ñhʉ ja rá thandi ra Pilato gue hinda thɛgui, masque ra Pilato go mi nehma̱ xa hyɛguiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pe nuꞌahʉ́ hingá nehʉ, masque go gueꞌa̱ rá hma̱ca Tꞌʉ Ajua̱ núꞌa̱ hinte ma tsꞌoqui xqui ꞌyøtꞌe. Pe nuꞌahʉ́ gá eñhʉ gue maꞌna xá hño dra thøgue ꞌnara hyote. ");
INSERT INTO oteNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nepʉ nuꞌahʉ gá hyohʉ núꞌa̱ toꞌo ri ꞌracjʉ ra te, pe Ajua̱ bi ꞌyøtꞌe pa da yopa nte de ra du. Nuje go dá hanthe bi yopa nte, hangue dí damajua̱nihe de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nuna ꞌñøhø guí hanthʉ ne guí pa̱hʉ gue mrá douahma̱, go ra Jesu bi ꞌyøthe ngueꞌa̱ dí camfriheꞌa̱. Hangue bi njabʉ ngu guí hanthʉbya. ");
INSERT INTO oteNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nubyá, núꞌahʉ ma cuꞌihe, dí pa̱he xá hño gue gá dahʉ ra Jesu ngueꞌa̱ hinte nguí pa̱hʉ, ngu núꞌʉ ma nda̱hʉ nehe himbi zo yá mfeni nehe núꞌa̱ bi ꞌyøtꞌe, hangue gá mfaxhʉ gá hyohʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pe nu Ajua̱ bi ꞌyøtꞌe da nja ngu núꞌa̱ xqui xipa yá ꞌmɛhni mayaꞌbʉ ne xqui ꞌyofoꞌʉ gue nura Cristo núꞌa̱ rá ꞌmɛhni pa e da nda̱ mi pɛꞌtsi da thogui ndunthi ya ʉgui asta rá duꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hangue nubya mahyoni gui ñobrihʉ ne gui yopa jonihʉ co Ajua̱ pa da punꞌa ri tsꞌoquihʉ, y nuꞌbʉ́ ha̱, nuꞌá̱ da ꞌraꞌaꞌihʉ ꞌnara ꞌraꞌyo mfeni ne ꞌnara hogaꞌmʉi. ");
INSERT INTO oteNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ne da yopa pɛnꞌaꞌihʉ ra Jesu núꞌa̱ toꞌo ra Cristo núꞌa̱ xqui hñutsꞌiꞌa̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ne nuꞌá̱ xi majua̱ni bi yopa mengui mahetsꞌi pa ja dua ꞌbʉhni asta hinda zø ra pa da yopa hoca Ajua̱ gatho, ngu núꞌa̱ xqui xipa mayaꞌbʉ yá ma̱ca ꞌmɛhni da ma̱. ");
INSERT INTO oteNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ngu bi ma̱nga ra Moise bi xipa ndu ma xitahʉ bi ꞌñembi: “Núꞌa̱ Ajua̱ ma zi Hmuhʉ ma da hñuxꞌahʉ ꞌna de gueꞌahʉ pa drá ꞌmɛhniꞌa̱ ngu xa hñuxcagui nehe, y núꞌá̱ ma gui ꞌyøtehʉ núꞌa̱ da xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ne gatho núꞌʉ toꞌo hinda ne da gamfribi rá noya núꞌa̱ ra ꞌmɛhniꞌa̱, nuꞌʉ́ dra huati ne da ꞌmɛdi de ja yá hnini.” ");
INSERT INTO oteNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Gatho núꞌʉ maꞌra yá ꞌmɛhni Ajua̱ desde ra Samue pa xqui ꞌñecua, xqui ma̱ nehe de nuya pabya dí ꞌbʉhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Y núꞌʉ ya hña̱ꞌti bi ma̱nga nuya ꞌmɛhniꞌʉ, gueꞌʉ pa gueꞌahʉ. Y núꞌʉ ya ja̱pi de ra cohi xqui gohui Ajua̱ ndu ma xitahʉ, nehe gueꞌʉ pa ri hñohʉ. Hangue Ajua̱ bi ꞌñembabi ra Abrá: “Po ꞌnari ꞌroho ma da ꞌñehe ꞌmɛfa, ma ga ja̱pi gatho ya ja̱ꞌi de rá ngʉni ra ximhai.” ");
INSERT INTO oteNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Y nuꞌahʉ go yá mʉdiꞌihʉ bá pɛnꞌahʉ rá Tꞌʉ Ajua̱ pa bi zoꞌahʉ gui ñobrihʉ de ri tsꞌoquihʉ pa njabʉ da ja̱pꞌaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ra apostol Pedro ne ra apostol Xuua mi ꞌbʉhnitho ja ra nda̱nija̱ mi zofo ya ja̱ꞌi. Nepʉ bi zøni ꞌraya macja̱ ne ra nda̱ de ya nsunija̱, ne ya saduceo núꞌʉ himi camfri gue da yopa nte núꞌʉ ya xa du. ");
INSERT INTO oteNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nepʉ nuꞌʉ́ bi bø yá cuɛ ngueꞌa̱ ra Pedro ne ra Xuua mi xipabi ya ja̱ꞌi gue ra Zidada Jesu xqui yopa nte de ra du, hangue mi utuabiꞌʉ gue gatho ya ja̱ꞌi ma da yopa nte. ");
INSERT INTO oteNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nuꞌbʉ́ nuya ja̱ꞌiꞌʉ ꞌbestho bi gʉ ntsꞌa̱hni ra Pedro ne ra Xuua, ne bi zitsꞌi pa bá cotꞌa fadi. Y asta rá hyaxꞌa̱ mi ma da nhyanthya̱, ngueꞌa̱ núꞌa̱ ra paꞌa̱ ya bi nde. ");
INSERT INTO oteNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pe ya xi mi ndunthi núꞌʉ toꞌo xqui ꞌyøde ne xqui gamfri núꞌa̱ mi ma̱nga ra Pedro. Ya ngu mi cʉtꞌa ꞌmo ya ꞌñøhø xqui gamfri, y himi pa ꞌmede ya ꞌbɛhña̱ nixi ya ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nurá hyaxꞌa̱ bi muntsꞌa nuni Jerusale nuyá nda̱xjua nda̱ ya xodyo ne ya xahnate de ra ley ne gatho maꞌra ya nda̱ gá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gathoꞌʉ bi muntsꞌa mahyɛgui co ra Anás núꞌa̱ toꞌo mrá da̱nga nda̱ gá macja̱, nehe mi ꞌbʉhni ra Caifá ne ra Xuua ne ra Jandro, ne gatho maꞌra ya ꞌñøhø núꞌʉ mi ja te yá njaui ya da̱nga nda̱ gá macja̱. ");
INSERT INTO oteNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nepʉ nuꞌʉ́ bi manda bá tsꞌi ra apostol Pedro co ra apostol Xuua ne bri ꞌbaꞌma madetho de gueꞌʉ pa bi tꞌambabi, ne bi tꞌembabi: ―¿Toꞌo yá ꞌmɛhniꞌihʉ, ne toꞌo rá tsꞌɛdi guí ha̱mpahʉ pa guí øthʉ njabʉ? ");
INSERT INTO oteNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nuꞌbʉ́ ra Pedro mi ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi pa bi da̱di ne bi ꞌñena: ―Núꞌahʉ gyá nda̱hʉ de ma hninihʉ Israel, ");
INSERT INTO oteNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ya gue guí angahe de núꞌa̱ ra hño bi tꞌøꞌtua nuni ra zi ꞌñøhø mrá doua, ");
INSERT INTO oteNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ma ga xiꞌahe hanja bi za bi ña̱nini, pa gui pa̱hʉ ne gatho núꞌʉ maꞌra ya me Israel. Nuni ra zi ꞌñøhø guí hanthʉ ꞌbahni, nuni bi ña̱ni de rá thuhu ra Jesucristo núꞌa̱ mrá me Nasare núꞌa̱ gá ponthʉ ja ꞌnara pontꞌi, pe nuꞌá̱ bi ꞌyøtꞌe Ajua̱ pa bi yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Núꞌá̱ go gueꞌa̱ gá ʉtsahʉ, nja ngu núꞌʉ ya hyøngu mi ꞌbʉi mayaꞌbʉ bi føthma̱bʉ ra mʉdi do núꞌa̱ mi ma xa hyoca rá nija̱ Ajua̱. Pe nubyá go gueꞌa̱ ra mʉdi do bi mɛgui Ajua̱ pa bi hyø rá nija̱. ");
INSERT INTO oteNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Joꞌo maꞌna toꞌo da za da pøhøguihʉ, hønsɛ ma zi Hmuhʉ ra Jesu, ngueꞌa̱ joꞌo maꞌna toꞌo bá ꞌbɛhni nuua ja ra ximhai pa da pøhøguihʉ, hønsɛ ra Jesu go gueꞌa̱ bá ꞌbɛhni ne go gueꞌa̱ tsa da pøhøguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nuꞌbʉ́ nuya nda̱ mi ꞌbʉhni xi bi ꞌyø ngueꞌa̱ bi hyandi gue ra Pedro ne ra Xuua himi tsu, ne mi pa̱di gue himyá ꞌñøhø dega da̱nga mfa̱di ngueꞌa̱ myá hyoya ja̱ꞌi. Pe bi ba̱diꞌʉ gue mi gueꞌʉ ꞌraya ꞌñøhø xqui ꞌñoui ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pe nuꞌʉ́ himbi za te bi da̱tuabi ra Pedro ngueꞌa̱ bi hyandi mi ꞌbahni con gueꞌʉ núꞌa̱ ra zi doua xqui ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nuꞌbʉ́ núꞌʉ ya nda̱ bi ꞌbɛpabi ra Pedro ne ra Xuua ne núꞌa̱ ra ꞌñøhø mrá doua da bøhma̱ de habʉ xqui muntsꞌiꞌʉ, ne bi ꞌñʉꞌtiꞌʉ ꞌna ngu ꞌna, ");
INSERT INTO oteNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ne bi ꞌñémbi: ―Xibya, ¿te ga øthʉ co nuyʉ ya ꞌñøhøyʉ? Ngueꞌa̱ núꞌa̱ xa ꞌyøꞌtua nuna ꞌñøhø mrá doua, ya pa̱di gatho ya ja̱ꞌi nuua ja ma hninihʉ Jerusale, y hingui tsa ga cønihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ha nujʉ́ ya hindí nehʉ da fa̱di de guehna habʉraza, hangue ma ga høꞌtuahʉ ra hña̱ gue ya hinte da sigui da ma̱, ne ya hinto da zofo de rá thuhu ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nepʉ bi tsꞌohna maꞌnaꞌqui ra Pedro ne ra Xuua ne núꞌa̱ ra ꞌñøhø mrá doua, ne bi tꞌembabiꞌʉ: ―Ya ote ma xqui ma̱ñhʉ, ne ya oxqui ma gui zofohʉ maꞌra ya ja̱ꞌi de rá thuhu ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nuꞌbʉ́ nura Pedro ne ra Xuua bi da̱di ne bi ꞌñena: ―¿Ha gue guí beñhʉ xá hño njabʉ ja rá thandi Ajua̱ gue go rí ꞌñepi ga øꞌtꞌahe ri pahahʉ que rá paha Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ngueꞌa̱ nuje hinda za toꞌo da hña̱gahe ga ma̱ñhe de núꞌa̱ stá hanthe ne núꞌa̱ stá øhe. ");
INSERT INTO oteNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nuꞌbʉ́ núꞌʉ ya nda̱ hinte bi ꞌyøꞌtuabi ra Pedro ne ra Xuua, hønsɛ bi xipabi gue ya hinda sigui da zofo ya ja̱ꞌi, nepʉ bi hyɛguitho. Himbi za te bi ꞌyøꞌtuabi ngueꞌa̱ mi tsu ya ja̱ꞌi xa bø yá cuɛ, ngueꞌa̱ gatho ya ja̱ꞌi xi mi xøcambeni Ajua̱ po rá ngue núꞌa̱ ra ꞌñøhø xqui ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ngueꞌa̱ núꞌa̱ ra ꞌñøhø xqui ña̱ni ya mi pɛꞌtsa thogui ñote njɛya. ");
INSERT INTO oteNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nu mi thɛgui ra apostol Pedro ne ra apostol Xuua bi ma bá cꞌa̱ꞌtsa núꞌʉ maꞌra ya gamfri pa bi metuabi núꞌa̱ xqui xipabi ya nda̱ gá macja̱ ne yá nda̱xjua nda̱ ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ha nu mi ꞌyøde ya gamfri, bi xøcambeni Ajua̱ co ꞌnadra mfeni ne bi ꞌñenaꞌʉ: ―Ma zi Hmuꞌihe, nuꞌi go gueꞌe grá Ajua̱ gá hoca mahetsꞌi ne ra ximhai ne ra ndehe ne gatho núꞌa̱ te ja. ");
INSERT INTO oteNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ne nuꞌi po ra Ma̱ca Nda̱hi gá xipa ri ꞌbɛgo ra Davi da ma̱nga njaua: Ya ja̱ꞌi bi muntsꞌi pa bi ꞌñʉꞌtiꞌʉ da ꞌyøtꞌa ya ntsꞌoꞌmʉi, pe núꞌa̱ ra ntsꞌoꞌmʉi bi beñꞌʉ da ꞌyøtꞌe, hinda za da ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bi muntsꞌa ya nda̱ de gatho ya hnini de ra ximhai pa bi ꞌñʉꞌtiꞌʉ da ʉtsa Ajua̱ ne ra Cristo núꞌa̱ xa hñutsꞌiꞌa̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ngueꞌa̱ xi majua̱ni ja nuna hninina̱ bi muntsꞌa ra nda̱ Erode ne ra Poncio Pilato co ya me Israel ne co núꞌʉ hingyá me Israel, pa bi ʉtsa nuri ma̱ca Tꞌʉ ra Jesu núꞌa̱ xcuá pɛhni pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ne bi ꞌyøtꞌeꞌʉ ngu núꞌa̱ gá beni ne gá ma̱nga mayaꞌbʉ gue mahyoni da nja. ");
INSERT INTO oteNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nubya ma zi Hmuꞌihe, hyanda núna te øtcahe ya ja̱ꞌi, ne faxcahe pa hinga ntsuhe ga ña̱he de ri ma̱ca noya, ngueꞌa̱ go dí pɛpꞌahe. ");
INSERT INTO oteNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne nuꞌi go ma gui hñuxa ri ꞌyɛ ja ya daꞌthi pa da ña̱niꞌʉ ne da hyanda ya ja̱ꞌi. Ne gui ꞌyøtꞌa ndunthi ya ntꞌudi ne ya da̱nga tꞌøtꞌe de rá thuhu ri ma̱ca Tꞌʉ ra Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ngu xi bi uadiꞌʉ bi xøcambeni Ajua̱, bi hma̱nga ra ngu habʉ xqui muntsꞌiꞌʉ, ne gatho núꞌʉ mi ꞌbʉhni bi hña̱nga rá tsꞌɛdi ra Ma̱ca Nda̱hi, ne bi ña̱ ntsꞌɛdiꞌʉ de rá noya Ajua̱, ne ya hinto mi tsu. ");
INSERT INTO oteNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Y gatho núꞌʉ ya xqui gamfri Ajua̱ mi ꞌnada yá mfeni, ne mi ꞌnada yá hma̱teꞌʉ. Ne mi mfaxꞌʉ ꞌna ngu maꞌna núꞌa̱ te mi øꞌtua ra ꞌbɛdi, ngueꞌa̱ gatho núꞌa̱ mi pɛꞌtsiꞌʉ mrá mɛti mahyɛgui, ne ni ꞌnara cu himi pɛꞌtsa ni ꞌnara tꞌøtꞌe núꞌa̱ mrá mɛtisɛ. ");
INSERT INTO oteNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ne co ndunthi ra tsꞌɛdi mi pɛꞌtsa ya apostol bi damajua̱ni gue xqui yopa nte de ra du ma zi Hmuhʉ ra Jesu, ne Ajua̱ xi bi matsꞌiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ha ni ꞌna de gueꞌʉ hinte mi øꞌtua ra ꞌbɛdi, ngueꞌa̱ gatho núꞌʉ toꞌo mi pɛꞌtsa yá hai ne yá ngu bá pa gatho, ne bá ha̱ gatho núꞌa̱ ra boja̱ mi ha̱ni de yá hai ne de yá ngu, ");
INSERT INTO oteNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ne bi umbabi ya apostol. Y nuya apostol go gueꞌʉ mi hecuabi cada ꞌnara gamfri ngu núꞌa̱ te mi øꞌtua ra ꞌbɛdi gueꞌa̱ mi tꞌumbabi nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ne mi ꞌbʉhni ꞌnara cu mrá thuhu ra Jose mrá me Chipre mrá levita. Ne bi hñuꞌmbabi ya apostol dra Berhna, rí bøni da ꞌñena Núꞌa̱ Toꞌo Huꞌmba yá mʉi ya Ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nuꞌá̱ bi pa ꞌnará haiꞌa̱ ne bá ha̱ gatho ra boja̱ pa bi umbabi ya apostol. ");
INSERT INTO oteNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pe mi ꞌbʉ maꞌna ra gamfri mrá thuhu ra Ananía ha nurá ꞌbɛhña̱ mrá thuhu ra Safira. Núꞌʉ́ bi pa ꞌnara hai myá mɛtiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nepʉ bi beñꞌʉ gue hinda unga gatho ra boja̱ de núꞌa̱ xqui pa yá hai, hangue bi za̱ma ꞌna tʉi ra boja̱ ra cu Ananía. Ne mi pa̱sɛ co rá ꞌbɛhña̱ gue xqui za̱ma ra boja̱. Nuꞌbʉ́ ra cu Ananía bi hña̱xa núꞌa̱ ra boja̱ bi hyeque pa bá umbabi ya apostol, ꞌñena gatho ra boja̱ mi ha̱, pe hina. ");
INSERT INTO oteNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nepʉ ra apostol Pedro bi ꞌñembabi: ―Ananía, ¿hanja xcá hopi xa hyaꞌaꞌi ra Satá pa xcá hyathma̱ ra Ma̱ca Nda̱hi? Ngueꞌa̱ hingá unga gatho núꞌa̱ ra boja̱ gá ha̱ni de ri hai gá pa ngu núꞌa̱ gá ma̱ gue mi xøgue ra boja̱. ");
INSERT INTO oteNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ha gue hingo ri mɛtihma̱ ra hai? ¿Ha gue hingo ri mɛtihma̱ ra boja̱ nehe? ¿Hanja gá beni gui ꞌyøtꞌe njabʉ? Ya xcá ncꞌuamba ja rá thandi Ajua̱, hingue hønsɛ con guecje. ");
INSERT INTO oteNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ha nu mi ꞌyøde nuya ya noya ra cu Ananía ꞌbestho ra oraꞌa̱ bi dagui bi du. Y gatho núꞌʉ toꞌo mi ꞌbʉhni ne gatho núꞌʉ maꞌra toꞌo bi ꞌyøde de núꞌa̱ xqui nja, gathoꞌʉ xi bi ntsu. ");
INSERT INTO oteNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nepʉ nuya ba̱tsꞌñøhø mi ꞌbʉhni bi ꞌmai bá jʉtsꞌi ne bi mantꞌi bi dutsꞌiꞌʉ pa bi ma bá agui. ");
INSERT INTO oteNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nepʉ xqui tho ngu hñu ora bi zøhø rá ꞌbɛhña̱ ra cu Ananía nehe habʉ mi ꞌbʉi ya gamfri, pe nuꞌá̱ nixi mi pa̱di te xqui nja. ");
INSERT INTO oteNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nepʉ ra apostol Pedro bi ꞌyambabi de ra boja̱, ne bi ꞌñembabi: ―¿Ha gue gueꞌa̱ bi muui núꞌa̱ ra hai gá pahʉ? Nuꞌbʉ́ núꞌa̱ ra nju bi da̱di ne bi ꞌñena: ―Ha̱ha̱, gueꞌa̱ bi muui. ");
INSERT INTO oteNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nepʉ ra Pedro bi ꞌñembabi: ―¿Hanja gá cohui ꞌnara cohi ri da̱me pa gui hyathma̱hʉ rá Ma̱ca Nda̱hi Ajua̱? Ndi, ꞌbapʉ møte ja ra gosthi núꞌʉ toꞌo ja bá juadi bá acꞌa ri da̱me, y nubyá e da duxꞌaꞌi nehe pa da ꞌyacꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Y ꞌbestho nura oraꞌa̱ ra nju Safira bi dagui bi du ja yá ua ra apostol Pedro. Ha ngu mi yʉtꞌa núꞌʉ ya ba̱tsꞌñøhø bi hyandi gue ya xqui du núꞌa̱ ra nju nehe, ꞌbestho bi dutsꞌiꞌʉ pa bi ma bá agui nehe habʉ xqui ꞌyacuabiꞌʉ rá da̱me. ");
INSERT INTO oteNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nepʉ gatho ya gamfri xi bi hña̱xa ꞌnara da̱nga tsu, nehe gatho núꞌʉ maꞌra toꞌo bi ꞌyøde de núꞌʉ ya tꞌøtꞌeꞌʉ, xi bi ntsuꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nuya apostol bi ꞌyøtꞌa ndunthi ya ntꞌudi ne ndunthi ya da̱nga tꞌøtꞌe ja yá thandi ya ja̱ꞌi. Mri muntsꞌa gatho ya gamfri mahyɛgui ꞌna mfenitho ja ra porta núꞌa̱ rá thuhu ra Porta de ra Salomó. ");
INSERT INTO oteNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gatho núꞌʉ himyá gamfri xi mi tsu da muntsꞌi co ya gamfri, pe nuya ja̱ꞌiꞌʉ mi eꞌtsua yá nsuꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ne ꞌnara pa ngu ꞌnara pa mi ꞌyo mi camfri ndunthi ya ja̱ꞌi, ya ꞌñøhø ne ya ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ne ꞌyo mi fa̱di, hangue asta mi thuxa ya daꞌthi pa mbi ꞌbɛgui co yá mfidi ja yá hyo ya ꞌñu pa nura ora da thohni ra apostol Pedro, hønsɛ co rá xudiꞌa̱ da goꞌma núꞌʉ ya daꞌthi, núꞌʉ́ ꞌbestho da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Gatho núꞌʉ ya hnini mi ja gueta Jerusale mi pa ya ja̱ꞌi pa guehni mi tsixa ya daꞌthi ne núꞌʉ toꞌo mi pɛꞌtsa ya tsꞌonda̱hi, y gatho mi ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nepʉ bi njʉxa ra da̱nga nda̱ gá macja̱ ne ya saduceo núꞌʉ myá mfatsꞌiꞌa̱, ngueꞌa̱ xi bi bø yá cuɛꞌʉ ngueꞌa̱ mi ne da nsɛhɛꞌʉ ne ya ndunthi ya ja̱ꞌi mri dɛna ya apostol. ");
INSERT INTO oteNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nepʉ bi gʉ ntsꞌa̱hni ya apostol ne bi gotꞌa fadi. ");
INSERT INTO oteNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nepʉ núꞌa̱ ra xuuiꞌa̱ ꞌnará ɛnxɛ Ajua̱ bá ehe pa bi xoca ra gosthi fadi, ne bi pønga pa thi ya apostol, ne bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Rí maha ja ra nda̱nija̱ ua zofohʉni ya ja̱ꞌi, ne xipabihʉ ra hoga noya de nuna ra ꞌraꞌyo te. ");
INSERT INTO oteNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nepʉ rá hyaxꞌa̱ xi ꞌnitho, nuꞌʉ́ bi ma pa ja ra nda̱nija̱ ngu núꞌa̱ xqui xipabi rá ɛnxɛ Ajua̱. Y ngu mi zøni bi yʉtꞌa mbo ꞌbestho pa bi zofoni ya ja̱ꞌi. Y de mi zofo ya ja̱ꞌi ya apostol, nura da̱nga nda̱ gá macja̱ ne yá mfatsꞌi bi ꞌyøtꞌa ꞌnara hmuntsꞌi con gatho ya nda̱ de ra hnini Israel. Ne bi mɛhna toꞌo mi ma dua tsi núꞌʉ ya apostol mi jotꞌa fadi. ");
INSERT INTO oteNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ha nu mi zønga núꞌʉ ya nzintsꞌa̱hni ja ra fadi, ya mi joꞌoni ya ꞌyofadi. Nuꞌbʉ́ nuꞌʉ́ bá da̱ma pengui pa bi ma̱ gue ya mi joꞌoniꞌʉ, ");
INSERT INTO oteNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ne bi ꞌñenaꞌʉ: ―Dá tsʉhe ra fadi xi mi jotꞌi xá hño, ne nuya nsufadi ja mi ꞌbahni ja ra gosthi, pe nu ndá xocje ra gosthi hinto dá tsʉheni mbo. ");
INSERT INTO oteNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nu mi ꞌyøde njabʉ nura da̱nga nda̱ gá macja̱ ne ra nda̱ de ya nsunija̱ ne maꞌra ya nda̱ gá macja̱, xi bi du yá mʉi, ne himi pa̱di te da beni, y mri ꞌñémbiꞌʉ: ―Xibya ¿te rí bømbyaꞌa̱? ");
INSERT INTO oteNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nepʉ bi zøhø ꞌnara ja̱ꞌi bi ꞌñembabiꞌʉ: ―Núꞌʉ ya ꞌñøhø gá cothma̱hʉ fadi, ya bí ꞌbʉhni ja ra nda̱nija̱ bí zofo ya ja̱ꞌi maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nuꞌbʉ́ ra nda̱ de ya nsunija̱ bi mɛui ya gʉntsꞌa̱hni pa bá yopa jʉ ya apostol. Bá jʉ pe hinte bi ꞌyøꞌtuabiꞌʉ ngueꞌa̱ mi tsu xa bø yá cuɛ ya ja̱ꞌi y xa hyøxa ncꞌahni. ");
INSERT INTO oteNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nepʉ bi zixa ya apostol ja ra hmuntsꞌa nda̱ gá xodyo, ne ja bi ꞌbaꞌmni ja yá thandiꞌʉ. Nepʉ núꞌa̱ ra da̱nga nda̱ gá macja̱ bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Ha gue hindá xiꞌahe gue ya hinxcá zofohma̱hʉ ya ja̱ꞌi ne ya hinxcá ña̱hma̱hʉ de rá thuhu ra Jesu? Nuꞌbʉ́ ¿hanja hinxcá ꞌyøhʉ? Ya gatho ya ja̱ꞌi de guecua Jerusale xcá zofohʉ de ri noyahʉ. Ne go guí ne gui hyøxcahe ra thaibya de rá du núꞌa̱ ra ꞌñøhøꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nuꞌbʉ́ ra apostol Pedro ne gatho maꞌra ya apostol bi da̱di ne bi ꞌñeñꞌʉ: ―Nuje maꞌna rí ꞌñepi ga øthe Ajua̱ que yá hmanda ya meximhai. ");
INSERT INTO oteNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ajua̱ núꞌa̱ toꞌo mi xøcambeni ndu ma xitahʉ go gueꞌa̱ bi ꞌyøtꞌe pa bi yopa nte ra Jesu de ra du, masque nuꞌahʉ gá ponthʉ ja ꞌnara za asta himbi hñu ri mʉihʉ gá hyohʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Y nubyá Ajua̱ xa ꞌñegui ja rá ꞌñɛi pa da nda̱. Y núꞌá̱ go gueꞌa̱ ra Pøhøte zoꞌahʉ gatho núꞌahʉ gyá me Israelhʉ pa gui ñobrihʉ de ri tsꞌoquihʉ ne da punꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nuje dí dahe majua̱ni de gueꞌa̱, ne ra Ma̱ca Nda̱hi ri damajua̱ni de gueꞌa̱ nehe. Nehe Ajua̱ ri umba ra Ma̱ca Nda̱hi núꞌʉ toꞌo øteꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ha nu mi ꞌyøde njabʉ ya nda̱ xi bi bø yá cuɛ ne asta mi ne xa hyohma̱ ya apostol. ");
INSERT INTO oteNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pe mi ꞌbʉhni ꞌnara ꞌñøhø mrá fariseo mrá thuhu ra Gamalie, núꞌá̱ mi ꞌnara xahnate de ra ley, y gatho ya ja̱ꞌi xi mi numahñoꞌa̱. Nuꞌá̱ bi ꞌmai ne bi manda dra pønga ꞌna zi ora nuya apostol. ");
INSERT INTO oteNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nepʉ nura Gamalie bi ꞌñembabi gatho núꞌʉ ya ja̱ꞌi xqui muntsꞌini: ―Núꞌahʉ compahʉ de Israel, beñhʉ ꞌmɛtꞌo xá hño núꞌa̱ guí ne gui ꞌyøꞌtuahʉ nuya ꞌñøhøꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Beñhʉ gue pɛꞌtsa ꞌraya pa bi nanga ꞌnara ꞌñøhø mrá thuhu ra Teuda mi hu rá mʉi gue mi pɛꞌtsa ꞌnara nsu ne mi ne da nda̱ngui de maꞌra, hangue bi dɛna ngu goho nthebe ya ꞌñøhø. Pe nura Teuda bi tho, ne gatho núꞌʉ toꞌo mri ꞌñoui bi nxani ne bi nhuati gathoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nepʉ ꞌmɛfa de gueꞌa̱ bi ꞌmʉ maꞌna ra ꞌñøhø mrá thuhu ra Juda mrá me Galilea. Ne núꞌʉ ya pa dega nthuxa thuhu, nuꞌá̱ bi ꞌyʉꞌta ndunthi ya ja̱ꞌi pa go bri thɛniꞌa̱. Ne ꞌmɛfa nuꞌá̱ bi tho nehe, ne bi nxanga gatho yá ja̱ꞌi núꞌʉ mri ꞌñoui. ");
INSERT INTO oteNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hangue nuga dí xiꞌahʉ, maꞌna xá hño hyɛhʉ dí ꞌyobʉ nuya ꞌñøhøꞌʉ. Nuꞌbʉ núꞌa̱ øtꞌeꞌʉ go xa bensɛhɛ, pɛꞌtsi ga hanthʉ da nhuati nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pe nuꞌbʉ go rá mɛti Ajua̱ núꞌa̱ øtꞌeꞌʉ, nuꞌbʉ́ hinda za gui hña̱cuahʉ. Ngueꞌa̱ ꞌbʉ gui ꞌyøthʉ njabʉ, ja ra uɛnda go grí ntuñhʉ co Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Y núꞌʉ mi ꞌbʉhni ja ra hmuntsꞌi bi ꞌyøde núꞌa̱ ra tsꞌofoꞌa̱. Hangue bi yopa cʉꞌta mbo ya apostol pa hønsɛ bi naꞌmbabi ne bi yopa hyøꞌtua ra hña̱ gue ya hinda sigui da ña̱ de rá thuhu ra Jesu, nepʉ bi hyɛgui bi maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Y de mi bønga ya apostol de guehni, xi mri johyaꞌʉ ngueꞌa̱ Ajua̱ xqui umba nsɛqui da tho ꞌnara ꞌbɛtsa po rá thuhu ra Zidada Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ha hyastho himi tsayaꞌʉ da zofo ya ja̱ꞌi de ja ra nda̱nija̱, ne mi pa ja ya ngu mi ma̱nga ra hoga ntꞌøde de ra Zidada Jesucristo. ");
INSERT INTO oteNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nuya paꞌʉ mri xu maꞌra ya gamfri. Ne mi ꞌbʉhni ꞌraya cu mi ña̱ griego. Nepʉ nuꞌʉ́ bi ꞌñembabi núꞌʉ ya cu mi ña̱ de yá hña̱qui ya xodyo, ne mi ambi hanja himi tꞌumbabi te da zi xá hño núꞌʉ yá viuda ya griego ra ora mi tꞌumba te da zi ya hyoya ne núꞌʉ maꞌra ya viuda, ngueꞌa̱ nuꞌʉ́ hyastho mi tꞌumbi te da zi. ");
INSERT INTO oteNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nepʉ núꞌʉ ꞌrɛtꞌamayoho ya apostol bi zohna gatho ya cu pa bi muntsꞌi ne bi ꞌñembabiꞌʉ: ―Ma zi cuꞌihe, nuje dí ꞌbʉhe pa ga ma̱ñhe rá noya Ajua̱, ne hingui tsa ga tsayahe ni ꞌna ora pa da za go ga hecuahe núꞌa̱ te da zi núꞌʉ hingui tsʉpabi. ");
INSERT INTO oteNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hangue mahyoni gui huañhʉ yoto ya cu de guecjʉ núꞌʉ xcá hanthʉ ꞌyo xá hño ne ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi ne xi di ja yá mfa̱di. Núꞌʉ́ go gueꞌʉ dyá uɛnda da mɛ nuna ꞌbɛfina̱. ");
INSERT INTO oteNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ha nuje ma ga sigui ga aphe Ajua̱ ne ga ma̱mfe rá noyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ha nu mi ꞌyøde bi sipa njabʉ ya cu, gatho xi bi hoꞌʉ. Rá mʉdi, bri huahna ra cu Teba núꞌa̱ mi pɛꞌtsa ndunthi ra jamfri ne mi ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi. Nepʉ bi huahna ra cu Lipe, ne ra cu Procoro, ne ra cu Nicano, ne ra cu Timu, ne ra cu Parmena, ne ra cu Cula núꞌa̱ ra me Antioquía xqui nxodyo ngueꞌa̱ xqui dɛmba yá leyꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ne bi tsꞌixa pa habʉ mbi ꞌbʉi ya apostol pa bi ꞌyapabi Ajua̱ por gueꞌʉ. Nepʉ ya apostol bi hñuxa yá ꞌyɛ ja núꞌʉ ya cu xqui thahni. ");
INSERT INTO oteNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Y njabʉ maꞌna mri ntʉnga rá noya Ajua̱, ne mri xu ndunthi ya gamfri nuni Jerusale, ne ndunthi ya macja̱ bi gamfri rá noya Ajua̱ nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ha nura cu Teba xi mi ha̱mpa rá tsꞌɛdi Ajua̱ ne mi ja rá mfa̱di pa mi pɛpa rá ꞌbɛfi Ajua̱, mi øtꞌa ya da̱nga tꞌøtꞌe ne ya ntꞌudi de ja yá thandi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Y nuni ja yá nija̱ ya xodyo núꞌa̱ mrá thuhu ya Nza̱i ꞌBɛgo xa Thøgue, ja mi ꞌbʉhni ꞌraya ꞌñøhø núꞌʉ mri ꞌñoui ꞌraya me Cirene, ꞌraya me Alejandría, ꞌraya me Cilicia, ne ꞌraya me Asia, gathoꞌʉ bi mʉdi bi ntsanoyaui ra cu Teba. ");
INSERT INTO oteNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pe nuꞌʉ́ himi tsa te da da̱tuabiꞌa̱ ngueꞌa̱ nuꞌá̱ mi ha̱ ra hoga mfa̱di ne mi ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi pa mi ña̱. ");
INSERT INTO oteNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nepʉ núꞌʉ ya ja̱ꞌiꞌʉ bi ꞌyʉꞌta ꞌraya ꞌñøhø ne bi guꞌtuabi pa da ma̱nga ya ncꞌuamba ne da ꞌñena njaua: “Nuje stá øhe gue nura ꞌñøhøꞌa̱ xa ña̱maꞌñʉ de ra Moise ne de Ajua̱.” ");
INSERT INTO oteNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hangue bi bø yá cuɛ yá nda̱xjua nda̱ ya xodyo ne ya xahnate de ra ley ne gatho ya ja̱ꞌi. Nepʉ bri jʉ ra cu Teba bi tsꞌixa ja ra hmuntsꞌa nda̱ gá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ne bri japabi ꞌraya ja̱ꞌi da hyøxa ra thai ra cu Teba ne bi ꞌñenaꞌʉ: ―Nuna ꞌñøhøni hingui tsaya ña̱maꞌñʉ de nuna ra ma̱ca nija̱ ne de rá ley ra Moise. ");
INSERT INTO oteNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nuje go stá øhe núꞌa̱ xa ma̱ni xa ꞌñena gue núꞌa̱ ra Jesu mrá me Nasare ma da huata nuna nija̱ ne ma da pata ma nza̱ihʉ núꞌʉ bi ꞌñutcahʉ ra Moise ga øthʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nepʉ gatho núꞌʉ toꞌo mi ꞌbʉhni ja ra hmuntsꞌi xi mi heta ra cu Teba ne mi handuabi rá hmi gue mi ngu rá hmi ꞌnará ɛnxɛ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nepʉ de gueꞌa̱ ra da̱nga nda̱ gá macja̱ bi ꞌyambabi ra cu Teba ne bi ꞌñembi: ―¿Ha gue xi majua̱ni xcá ña̱maꞌñʉ de Ajua̱ ne de ra Moise? ");
INSERT INTO oteNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nuꞌbʉ́ ra cu Teba bi da̱di ne bi ꞌñena: ―Núꞌahʉ ma cuꞌihʉ, ne núꞌahʉ ma nda̱ꞌihʉ xcá muntshʉua ꞌnadbʉ, ꞌyøhʉ núna ma ga xiꞌahʉ. Ajua̱ núꞌa̱ xá nsunda bi zofo ndu ma xitahʉ ra Abrá núꞌbʉ hinxqui matho pa ja ra hai Arán ne mi ꞌbʉhnitho Mesopotamia. ");
INSERT INTO oteNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ne bi ꞌñembabi: “Pøni de guecua ri hai, tsopʉ núꞌʉ ja te ri njaui, ne grí ma pa maꞌna ra hai núꞌa̱ ma ga uꞌtꞌaꞌi pa ja gui ꞌbʉhni.” ");
INSERT INTO oteNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nuꞌbʉ́ bi bøni de guehni habʉ mi ꞌbʉi, habʉ myá hai ya Caldeo, ne bi ma pa bá ꞌbʉ ja ra hai Arán. Ha nu mi du rá dada, Ajua̱ bá tsi pa guecua habʉ dí ꞌbʉhʉbya, ja bi ꞌmʉcua neheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pe nu Ajua̱ himbi umbabiua ni ꞌna xɛni ra hai pa drá mɛtiꞌa̱, pe xqui ña̱ꞌtuabi gue nuna hai habʉ dí ꞌbʉhʉbya go drá mɛtiꞌa̱ ꞌmɛfa ne gatho yá ja̱ꞌi de rá jiꞌa̱ núꞌʉ da ꞌmʉi ꞌmɛfa. Pe nuya paꞌʉ ra Abrá hinxqui mɛꞌtstho ni ꞌnara ba̱tsi. ");
INSERT INTO oteNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Y Ajua̱ bi ꞌñembabiꞌa̱: “Nuri ba̱tsi ri ꞌbɛto ne ri mbongꞌbɛto ma da ꞌmʉ ja ꞌnara hai habʉ hindyá mɛtiꞌʉ ngueꞌa̱ dya nzøhøtho de guehni. Ne ja ma da ꞌmʉhniꞌʉ ngu goho nthebe njɛya, ne ma da ꞌmɛgothoꞌʉ, ne ma da tꞌøꞌtua ndunthi ra ntsꞌoꞌmʉi.” ");
INSERT INTO oteNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nehe bi ꞌñembabi Ajua̱: “Nuga go ma ga ha̱ꞌmba nguɛnda ya ja̱ꞌi de núꞌa̱ ra hnini habʉ ma da ꞌmɛgoꞌʉ. Ne ꞌmɛfa ma ga yopa tsi de guehni pa da ꞌñehe da mɛpcagui de guecua.” ");
INSERT INTO oteNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nepʉ Ajua̱ bi gohui ꞌnara cohi ra Abrá, ne bi manda gue gatho yá ba̱tsi yá ꞌbɛto ne yá mbongꞌbɛto da mɛꞌtsa ꞌnara seña ja yá ndoꞌyo de núꞌa̱ ra cohi bi gohi. Hangue nu mi ꞌmʉi rá tꞌʉ ra Abrá núꞌa̱ mrá thuhu ra Isaac, nurá hña̱to ma pa de xqui ꞌmʉi bi ꞌyøꞌtua núꞌa̱ ra seña xqui gohui Ajua̱ da ꞌyøtꞌe. Ne guetꞌa̱ bi ꞌyøtꞌa ra Isaac co rá tꞌʉ núꞌa̱ mrá thuhu ra Cobo, ne guetꞌa̱ bi ꞌyøtꞌa ra Cobo co núꞌʉ ꞌrɛtꞌamayoho yá tꞌʉ, y go gueꞌʉ yá dada núꞌʉ ꞌrɛtꞌamayoho ya ꞌmʉi de Israel. ");
INSERT INTO oteNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nepʉ núꞌʉ yá tꞌʉ ra Cobo xi bi ʉtsa ꞌna de nuyá cu núꞌa̱ mrá thuhu ra Jose. Hangue nuꞌʉ́ bi papabi ya me Egipto núꞌa̱ yá cuꞌʉ, ne bi tsꞌitsꞌi pa guehni. Pe Ajua̱ himbi hyɛsɛꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Hangue xi bi ña̱ni de ja yá tsꞌothogui bi thogui, ne bi umba ndunthi ra mfa̱di ne bi matsꞌi pa njabʉ ra Faraó bi hopa rá ꞌmʉi. Ra Faraó go gueꞌa̱ mrá nda̱ de Egipto. Nepʉ ra Faraó bi umba ꞌnará nsu ra Jose pa bi gohi ngu rá ñoho de gueꞌa̱, ne bi manda maxøgue ja rá ngu ra Faraó. ");
INSERT INTO oteNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ꞌMɛfa bi nja ꞌnara da̱nga thuhu nuni Egipto ne nuni Canaán, ne bi nja ꞌraya da̱nga dumʉi, ne bi ꞌñotho te bi zi ndu ma xitahʉ. Himi tsʉdi habʉ da dai ngueꞌa̱ mi otho te da dañꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nepʉ ra Cobo bi ꞌyøde gue mi ja ra trigo nuni Egipto, hangue bi mɛhna yá tꞌʉ pa guehni. Gueꞌa̱ ra mʉdi ꞌmiꞌqui bi ma pa Egipto. ");
INSERT INTO oteNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nepʉ nurá ñoꞌqui bi maꞌʉ, ra Jose bi xipabiꞌʉ toꞌo mi gueꞌa̱ pa bi ba̱diꞌʉ gue go mi gueꞌa̱ myá cu. Hangue nura Faraó bi ba̱tuabi yá ja̱ꞌi ra Jose. ");
INSERT INTO oteNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nepʉ nura Jose bá pɛmpa ra noya rá dada pa da ma da ꞌmʉ Egipto con gatho maꞌra yá ja̱ꞌi. Nuꞌʉ́ mi hñuꞌrate ne ꞌrɛtꞌamacʉtꞌa. ");
INSERT INTO oteNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nepʉ ꞌbestho bi maꞌʉ pa Egipto. Y nepʉ ja bá tuniꞌa̱, ne ja bá tuni gatho yá tꞌʉ, y núꞌʉ́ go gueꞌʉ ndu ma xitahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ne ꞌmɛfa de ya xqui thogui ndunthi ya jɛya de xqui duꞌʉ, bá tha̱mpa yá ndoꞌyoꞌʉ de guehni pa e bi tꞌacua ja yá hai nuni Siquem ꞌnara hnini de Canaán. Ne bi tꞌacuabi nuyá ndoꞌyo ja ꞌnara ntꞌagui xqui danga ndu ra Abrá xqui damba yá tꞌʉ ra Amor nuni Siquem. ");
INSERT INTO oteNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Y ya xqui nxa̱nda ndunthi yá tꞌʉ yá ꞌbɛto ne yá mbongꞌbɛto ra Cobo nuni Egipto, ne ya mi ma da zø ra pa da hña̱nga núꞌa̱ ra hña̱ꞌti xqui xipabi Ajua̱ ra Abrá. ");
INSERT INTO oteNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nepʉ de núꞌʉ ya paꞌʉ bi ꞌmʉ maꞌna ra nda̱ núꞌa̱ himi pa̱di toꞌo mi gueꞌa̱ ra Jose ne te xqui mɛfiꞌa̱, ngueꞌa̱ ya mi pɛꞌtsa ndunthi ya jɛya xqui duꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Núꞌa̱ ra nda̱ꞌa̱ xi bi ꞌyøꞌtua ra ntsꞌoꞌmʉi núꞌʉ ndu ma xitahʉ. Ne bi manda dra japi da ꞌyɛi gatho yá zi ꞌuɛne núꞌʉ myá tsꞌʉntꞌʉ, pa njabʉ da du gathoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Y gueꞌʉ ya pa bi ꞌmʉ ra Moise, y Ajua̱ xi mri hopa rá ꞌmʉi. Nuꞌá̱ bi tede rá dada ne rá na̱na̱ hñu nza̱na̱ ja yá nguꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nepʉ bi thogui núꞌʉ hñu nza̱na̱, nuꞌʉ́ bi ma bá ɛi ngueꞌa̱ njabʉ xqui manda ra Faraó da tꞌøtꞌe. Pe ꞌnará tꞌixu ra Faraó bá jʉxa ra Moise de habʉ xqui tꞌɛi, núꞌa̱ mrá zi ꞌuɛnetho, pa bi tede, ja ra uɛnda go mrá ba̱tsiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Hangue ra Moise bi te ne bi ba̱tua yá mfa̱di ya me Egipto, ne xi mrá nimfeni, ne mi ha̱ ra tsꞌɛdi pa da ña̱ ne pa te da ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nepʉ de ya mi pɛꞌtsa ñote njɛya ja bi zo rá mfeni da ma da cꞌa̱ꞌtsa ya me Israel nuyá ja̱ꞌi pa bá nu te ngra ꞌmʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nepʉ ngu mi zøni habʉ mi ꞌbʉ yá ja̱ꞌi, bi hyanda ꞌnara me Egipto mi naꞌmbabi ꞌna de gueꞌʉ. Hangue pa bi za bi ña̱nga rá ja̱ꞌi, ra Moise bi hyo núꞌa̱ ra me Egipto. ");
INSERT INTO oteNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nura Moise mi beni yá ja̱ꞌiꞌa̱ xa unga nguɛnda gue Ajua̱ xqui mɛhniꞌa̱ pa da ña̱niꞌʉ, pe nuꞌʉ́ himbi zo yá mfeni ua mrá ꞌmɛhni Ajua̱ ra Moise. ");
INSERT INTO oteNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nepʉ rá hyaxꞌa̱ bi yopa thohni ra Moise, ne bi hyanda yoho ya me Israel mri ntunsɛhɛ. Ne mi ma da hyequeꞌʉ ne bi ꞌñembabi: “Nuꞌahʉ́ gyá me Israelhʉ, ne grí ncuhʉ. ¿Hanja grí ntunsɛhʉ ꞌna ngu maꞌna?” ");
INSERT INTO oteNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nepʉ núꞌa̱ toꞌo mi naꞌmba núꞌa̱ maꞌna, bi umba ꞌnara ntꞌentꞌi ra Moise ne bi ꞌñembabi: “¿Toꞌo xa hñuxꞌague dega nzaya ne dega nda̱ pa go gui hña̱gahe núꞌa̱ dí øthe? ");
INSERT INTO oteNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ua gue guí ne gui hyogagui nehe ngu gá øꞌtua ra me Egipto mande?” ");
INSERT INTO oteNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nu mi ꞌyøde njabʉ ra Moise xi bi ntsu, ne bi ꞌbatꞌi bi ma pa ja ꞌnara hai rá thuhu Madián, y ja bá ꞌbʉhni dega nzøhø, y ja bá ntha̱tini ne bi mɛꞌtsa yoho yá tꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ne ya xqui thogui ñote njɛya de xqui bønga ra Moise de Egipto pa bá ꞌbʉ ja ra hai Madián, nepʉ ꞌnara pa xqui bønga de rá ngu mbi ꞌyo asta ja rá ua ꞌnara tꞌøhø rá thuhu Sinaí. Ne de guehni bi hyanda ꞌnara ꞌbai gá nda̱po mi zø ꞌnara faspi madetho de gueꞌa̱, ne mi ꞌbahni ꞌnará ɛnxɛ Ajua̱ madetho de ra faspi. ");
INSERT INTO oteNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nepʉ nura Moise himbi ba̱di há bi nja, pe bi uatꞌa ja ra faspi pa bi hyandi te rá ꞌbɛꞌa̱, ne bi ꞌyøde bi ña̱ Ajua̱ y bi ꞌñembabi: ");
INSERT INTO oteNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nuga go gueque rá Ajua̱gui ra Abrá, ra Isaac, ra Cobo, ne gatho núꞌʉ maꞌra ndu ri xitahʉ.” Nuꞌbʉ́ ra Moise asta mri hua̱tꞌi co ra ntsu hangue ya himi nehma̱ da sigui da hyanda núꞌa̱ ra faspi mi handi. ");
INSERT INTO oteNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ha nu Ajua̱ bi ꞌñembabi: “Cꞌoꞌta ri zɛsthi ngueꞌa̱ nuua habʉ guí netꞌi guehna ꞌnara ma̱ca hai xá ntꞌaxi. ");
INSERT INTO oteNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Xi majua̱ni stá handa nuya tsꞌothogui thogui ma ja̱ꞌi nuni Egipto, ne stá øtua yá tsꞌoniꞌʉ, ne stá ehe pa ga ña̱ni. Nubya ma ga pɛñꞌaꞌi gui yopa penga Egipto.” Njabʉ bi xipabi Ajua̱ ra Moise. ");
INSERT INTO oteNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Masque nuyá ja̱ꞌi ra Moise xqui ʉtsaꞌa̱ ne xqui ꞌñembi: “¿Toꞌo xa hñuxꞌague dega nzaya ne dega nda̱ pa go gui hña̱gahe núꞌa̱ dí øthe?”, pe xi majua̱ni go Ajua̱ xqui mɛhna ra Moise pa da nda̱ ne pa da zinga núꞌʉ yá ja̱ꞌi mbi o ja yá ꞌyɛ ya me Egipto, ngueꞌa̱ njabʉ xqui xipa rá ɛnxɛ Ajua̱ núꞌa̱ bi hnequi madetho de ꞌnara faspi nuni ja rá ua ra tꞌøhø Sinaí. ");
INSERT INTO oteNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nepʉ ra Moise bá penga pa Egipto pa bá tsinga gatho ya me Israel núꞌʉ mbi ꞌbʉhni. Ne bi ꞌyøtꞌa ndunthi ya da̱nga tꞌøtꞌe ne ya ntꞌudi nuni Egipto ne ja ra Thɛnga Ndehe, nehe bá øtꞌa nuni ja ra mbonthi habʉ bá ꞌyoꞌʉ ñote njɛya. ");
INSERT INTO oteNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Go guetꞌa̱ ra Moise núꞌa̱ bi xipabi yá ja̱ꞌi núꞌʉ myá me Israel bi ꞌñembi: “Ajua̱ ma da hñuxꞌahʉ ꞌna de gueꞌahʉ pa drá ꞌmɛhniꞌa̱ ngu xa hñuxcagui nehe. Y núꞌá̱ ma gui ꞌyøtehʉ núꞌa̱ da xiꞌaꞌihʉ.” Njabʉ bi xipa ra Moise yá ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nura Moise go guetꞌa̱ mi ꞌñoui ya me Israel nuni ja ra mbonthi, ne ja bi muntsꞌiniꞌʉ ja ra tꞌøhø Sinaí. Ne ja bi ña̱uini ra Moise rá ɛnxɛ Ajua̱. Nepʉ ra Moise bi xipa ndu ma xitahʉ ngu núꞌa̱ xqui xipa ra ɛnxɛ. Njabʉ ra Moise bi hña̱nga ra noya dega te pa bi ꞌracjʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pe núꞌʉ ndu ma xitahʉ himbi ne bi ꞌyøta ra Moise, ne himi ne go da nda̱ de gueꞌʉ, ne bi benga ja yá mfeni gue maꞌna xá hño da mengui pa Egipto. ");
INSERT INTO oteNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ha nu mi ma ra Moise bá ña̱ui ra ɛnxɛ, nuꞌbʉ́ nuya ja̱ꞌi bi ꞌñembabi ra Aarón: “Stá beñhe gue xá hño ꞌbʉ ga hocjʉ ꞌrama ajua̱hʉ pa go gueꞌʉ dri ꞌbɛtꞌo de guecjʉ, ngueꞌa̱ nura Moise hønsɛ bá jʉgaguihʉ de Egipto pa e bi hyɛgahʉua ja ra mbonthi, ha nuꞌá̱, hadifa̱ꞌa̱ te xua jaꞌa̱.” ");
INSERT INTO oteNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hangue nuꞌʉ́ bi hyoca ꞌnara tꞌʉntfani dega bøja̱, ne bi thopabi ya mboꞌoni pa bi tꞌumbabiꞌa̱, ne mri nsundaꞌʉ, ne xi mri johya ngueꞌa̱ bi hyandi gue mi mahotho núꞌa̱ ra cꞌoi xqui hyocsɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hangue nu Ajua̱ ꞌbestho bi ꞌuegue de gueꞌʉ, ne bi hyɛpʉ da nsunda ya tsø ne ra za̱na̱ ne ra hyadi. Njabʉ bi ꞌyofo mayaꞌbʉ ꞌna de yá ꞌmɛhni Ajua̱ núꞌa̱ ena njaua: Nuꞌahʉ gyá me Israelhʉ, ¿haꞌmʉ rá ꞌnandi gá hyohʉ ꞌraya mboꞌoni pa gá ña̱tcahʉ de núꞌʉ ñote njɛya gá ꞌyohʉ ja ra mbonthi? ");
INSERT INTO oteNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hinhyaꞌmʉ gá øtcahʉ njabʉ. Nuꞌa̱ nguí øthʉ, ngrí ndudehʉ núꞌʉ ri cꞌoihʉ gá hocjʉ pa gui nsundahʉ, ꞌna nguí huꞌmbabihʉ ra Moloc, ha nuꞌa̱ maꞌna gá hocjʉ ngu ꞌnara tsø, nguí huꞌmbabihʉ ra Renfán. Hangue nubyá ma ga pøñꞌaꞌihʉ de ri haihʉ pa ga pɛñꞌahʉ asta thogui de ra hai Babilonia. Guehna bi xipa Ajua̱ ya me Israel. ");
INSERT INTO oteNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Núꞌa̱ ra mbonthi habʉ bi ꞌranga ndu ma xitahʉ, ja guehni xqui hocniꞌʉ ꞌnara ngu dega dutu habʉ mi ꞌbɛꞌtsa núꞌa̱ ra xingdo habʉ mi ntꞌofo núꞌʉ ꞌrɛtꞌa ya hmanda. Núꞌa̱ ra nguꞌa̱ bi thoqui ngu xqui xipa Ajua̱ ra Moise da hyoqui, ne ngu núꞌa̱ xqui ꞌñutuabi. ");
INSERT INTO oteNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nepʉ ꞌmɛfa núꞌa̱ ra nguꞌa̱ bi gohui ndu ma xitahʉ núꞌʉ mri zi ra Josue. Nepʉ bá ha̱ꞌʉ pa nuua habʉ bi ntuncui ya ja̱ꞌi núꞌʉ himyá me Israel núꞌʉ bi guui Ajua̱ de guecua núꞌbʉ mi zøcua núꞌʉ ndu ma xitahʉ. Y ja nura nguꞌa̱ ja bi nsundaniꞌʉ Ajua̱ asta mi ꞌmʉi ra Davi núꞌa̱ bi nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Y Ajua̱ xi bi hopa rá ꞌmʉiꞌa̱. Y ra Davi mi nehma̱ xa hyoca ꞌnara ngu pa habʉ dra nsunda hma̱ha̱ Ajua̱ núꞌa̱ rá Ajua̱ ndu ma xitahʉ ra Cobo. Pe himbi za bi hyoqui. ");
INSERT INTO oteNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pe nu ꞌnará tꞌʉ ha̱, núꞌa̱ mrá thuhu Salomó, nuꞌá̱ ha̱, go gueꞌa̱ bi hyocua rá ngu Ajua̱ núꞌa̱ mi behma̱ da hyoca rá dada. ");
INSERT INTO oteNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Masque nu Ajua̱ bí ꞌbʉi maña̱ mahetsꞌi, hingui ꞌbʉ ja ꞌnara ngu núꞌa̱ xa thoqui co yá ꞌyɛ ya ja̱ꞌi, ngu bi ꞌñenga ra ba̱di Isaía gue Ajua̱ mi ena njaua: ");
INSERT INTO oteNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nuua mahetsꞌi ja guecua ma hudiga habʉ dí ꞌbʉi dega nda̱, ha nu ja ra ximhai ja guehni dí tøta ma ua. Nehe ena: ¿Te ma ngu núꞌa̱ ra ngu ma da thogaga ꞌbʉ? O ¿habʉ ma ga ꞌbʉca ꞌbʉ? ");
INSERT INTO oteNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ha gue hingue co ma tsꞌɛdi stá hocaga gatho nuya tꞌøtꞌe ja ja ra ximhai? ");
INSERT INTO oteNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Y ra cu Teba bi sigui bi ꞌñembabi ya ja̱ꞌi: Pe nuꞌahʉ́ nza̱ntho xi xcá njahʉbʉ, xi xá me ri mfenihʉ, hinguí ne gui ꞌyøhʉ. Guí njahʉ ngu núꞌʉ ya ja̱ꞌi hingui pa̱ Ajua̱, ngueꞌa̱ nuꞌahʉ́ hinguí ne gui ꞌyøthʉ núꞌa̱ xiꞌahʉ ra Ma̱ca Nda̱hi ngu mi nja ndu ma xitahʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Hangu hma̱ yá ꞌmɛhni Ajua̱ bi tꞌøꞌtua ra ntsꞌoꞌmʉi? Y núꞌʉ ndu ma xitahʉ go gueꞌʉ bi ꞌyøtꞌa njabʉ. Núꞌʉ́ go gueꞌʉ bi hyo núꞌʉ toꞌo mi ma̱ desde rá mʉdi gue mi ma da ꞌñehe núꞌa̱ ra hoja̱ꞌi hinda ma da ꞌyøtꞌa ni ꞌnara tsꞌoqui. Ha nu mi zøhøꞌa̱, go gueꞌahʉ gá dahʉ ne gá hyohʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nuꞌahʉ gá hña̱ñhʉ ya hmanda núꞌa̱ e bi zogahʉ yá ɛnxɛ Ajua̱, pe hinxcá ne xcá ꞌyøthʉ ngu núꞌa̱ bi hmandaꞌihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nepʉ mi ꞌyøde njabʉ nuya ja̱ꞌi nuya noyaꞌʉ, xi bi bø yá cuɛ ntsꞌɛdi co ra cu Teba. ");
INSERT INTO oteNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pe nura cu Teba mi ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi, ne bi nøxa pa mahetsꞌi ne bi hyandua rá nsunda Ajua̱, nehe bi hyanda ma zi Hmuhʉ ra Jesu mi ꞌbahni ja rá ꞌñɛi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nepʉ ra cu Teba bi ꞌñemba ya ja̱ꞌi: ―¡Ndi! Dí handa mahetsꞌi xogui, nehe dí handa Núꞌa̱ Toꞌo e bi Nja̱ꞌi bí ꞌbai ja rá ꞌñɛi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Y nura oraꞌa̱ gatho núꞌʉ ya ja̱ꞌi mi ꞌbahni bi goꞌta yá gu ne bi dø ya hmafi, ne bi nestꞌihi ri gatho bi mfatsꞌi bi mihi ra cu Teba. ");
INSERT INTO oteNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nepʉ de guehni nuya ja̱ꞌiꞌʉ bi pønga ra cu Teba de ra hnini, nepʉ bi cꞌahni. Ne mi ꞌbahni ꞌnara ba̱sja̱ꞌi mrá thuhu ra Saulo, núꞌá̱ nehe go gueꞌa̱ bi hyandua rá du ra cu Teba, nehe go gueꞌa̱ mi supa yá he ya hyote núꞌʉ xqui hña̱qui pa bi za bi hñoteꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Y núꞌa̱ ra ora mi thøxa ya ncꞌahni ra cu Teba, nuꞌá̱ bi ꞌyapabi Ajua̱ ne bi ꞌñena: ―Ma zi Hmuꞌi Jesu, dí aꞌi gui hña̱ni ma te ja ri ma̱ca ꞌyɛbya. ");
INSERT INTO oteNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nuꞌbʉ́ nuꞌá̱ bi ndandiña̱hmu ne bi ꞌñena: ―Ma zi Hmuꞌi, oxqui ha̱ꞌmba nguɛnda nuyʉ ya ja̱ꞌi de núꞌa̱ øtcagui. Y ngu bi uadi bi ma̱nga njabʉ, ꞌbestho bi du. ");
INSERT INTO oteNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ha nura Saulo xqui da̱ rá hña̱ gue da tho ra cu Teba. Nepʉ ꞌbestho núꞌa̱ ra paꞌa̱ bi mʉdi bi nja ꞌnara da̱nga ntꞌʉtsate contra núꞌʉ xqui gamfri Ajua̱ nuni Jerusale. Ne bi nxanga gatho ya gamfri habʉraza maxøgue ra hai Judea ne Nsamaria, hønsɛ ya apostol himbi bønga de Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Y nu ꞌraya cu xi mi ja yá jamfri co Ajua̱, go gueꞌʉ bi ꞌñoni pa bi ꞌyagui ra cu Teba, ne xi bi nzoni ndunthi ngueꞌa̱ xi mri ma̱diꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ha nura Saulo xi bi ꞌyøꞌtua ndunthi ra ntsꞌoꞌmʉi ya gamfri, ne ꞌramaꞌna ra ngu mi cʉtꞌi pa mi jʉca ya ꞌñøhø ne ya ꞌbɛhña̱ pa da zitsꞌi da gotꞌa fadi. ");
INSERT INTO oteNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ha núꞌʉ maꞌra ya gamfri xqui ꞌbatꞌi ne xqui nxani, go gueꞌʉ mi ꞌyo mi ma̱mba rá noya Ajua̱ habʉraza. ");
INSERT INTO oteNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ha ꞌna de gueꞌʉ mrá thuhu ra Lipe bi ma pa ja ꞌnara hnini nuni Nsamaria pa bá xipa ya ja̱ꞌi de ra Zidada Jesucristo. ");
INSERT INTO oteNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Y nuya ja̱ꞌi de guehni mri muntsꞌi pa mi huxa ntꞌøde xá hño de núꞌa̱ mi ma̱nga ra cu Lipe, ne mi handiꞌʉ núꞌʉ ya ntꞌudi mi øtꞌeꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ngueꞌa̱ nuꞌá̱ mi ɛmba ya tsꞌonda̱hi núꞌʉ toꞌo mi pɛꞌtsi, ne nuya tsꞌonda̱hi asta mi mafi da bøni. Ne ndunthi ya tsꞌonate mi øtheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hangue njabʉ bi mɛꞌtsa ꞌnara da̱nga johya núꞌa̱ ra hniniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ne mi ꞌbʉhni ꞌnara ꞌñøhø mrá thuhu ra Simu núꞌa̱ mrá ꞌñete de núꞌa̱ ra hniniꞌa̱. Nura ꞌñeteꞌa̱ xi xqui hyatꞌa ndunthi ya me Nsamaria, ne xi mri ꞌñetsꞌi co núꞌa̱ rá mfa̱di mi pa̱di. ");
INSERT INTO oteNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ne gatho nuya ja̱ꞌi de guehni notsi nda̱ngui xi mi huxa ntꞌøde de núꞌa̱ mi ma̱nga núꞌa̱ ra ꞌñeteꞌa̱, ne mi eñꞌʉ: ―Nura ꞌñøhøꞌa̱ ha̱mpa rá da̱nga tsꞌɛdi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ne gatho ya ja̱ꞌi xi mi huxa ntꞌøde ngueꞌa̱ ya yaꞌmʉ xqui hyatꞌiꞌʉ co rá ntꞌete. ");
INSERT INTO oteNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pe nu mi zønga ra cu Lipe ja núꞌa̱ ra hniniꞌa̱ bi ma̱nga ra hoga ntꞌøde de rá hmanda Ajua̱ ne bi ma̱ de ra Zidada Jesucristo. Nepʉ gatho ya ja̱ꞌi bi gamfri ne bi nxistehe, ya ꞌñøhø ne ya ꞌbɛhña̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nehe núꞌa̱ ra ꞌñete mrá thuhu ra Simu bi gamfribi rá noya Ajua̱ ne bi nxistehe. Ne nza̱ntho bi ꞌñoui ra cu Lipe, mi handa núꞌʉ ya ntꞌudi ne ya da̱nga tꞌøtꞌe mi øtꞌe, ne nuꞌá̱ xi mri ꞌyø de núꞌa̱ mi handi. ");
INSERT INTO oteNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nepʉ mi ba̱di núꞌʉ ya apostol mi ꞌbʉhni Jerusale gue ya me Nsamaria ya xqui hña̱nga rá noya Ajua̱, ꞌbestho bi mɛhna ra apostol Pedro ne ra apostol Xuua pa guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Y ngu mi zøñꞌʉ bi ꞌyapabi Ajua̱ po ya gamfri de guehni Nsamaria pa bi za bi hña̱nga ra Ma̱ca Nda̱hi, ");
INSERT INTO oteNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ngueꞌa̱ ni ꞌna de gueꞌʉ hinxqui hña̱ni thoho ra Ma̱ca Nda̱hi, hønsɛ xqui nxistehe de rá thuhu ma zi Hmuhʉ ra Jesucristo. ");
INSERT INTO oteNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hangue ra Pedro ne ra Xuua bi hñuxa yá ꞌyɛ ja ya gamfri, nepʉ nuꞌʉ́ ꞌbestho ra oraꞌa̱ bi hña̱nga ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ha nu mi hyanda ra Simu núꞌa̱ mrá ꞌñetehma̱ gue xqui hña̱nga ra Ma̱ca Nda̱hi núꞌʉ toꞌo xqui hñuꞌtsua yá ꞌyɛ ra Pedro ne ra Xuua, hangue nuꞌá̱ asta bi ña̱ꞌtuahma̱ ra boja̱ núꞌʉ ya apostol, ");
INSERT INTO oteNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ne bi ꞌñembabi: ―ꞌRacaguihʉ nehe núꞌa̱ ra tsꞌɛdi guí ha̱hʉ, pa njabʉ necagui da za ga huxa ma ꞌyɛ ja ya ja̱ꞌi ne nuꞌʉ́ da hña̱nga ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nepʉ ra Pedro bi da̱di ne bi ꞌñembi: ―Maꞌna xá hño ꞌmɛdiui ri boja̱. ¿Hanja xcá beni gue rá tsꞌɛdi Ajua̱ da za da thai co ra boja̱? ");
INSERT INTO oteNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hinguí pɛꞌtsa ra nsɛqui nixi rí ꞌñepꞌaꞌi gui pɛfi nuna ꞌbɛfina̱, ngueꞌa̱ hingui ho núna xcá beni de ja rá thandi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hangue nuꞌa̱ mahyoni gui ꞌyøtꞌebya, ntsøꞌmi de núꞌa̱ ri tsꞌoqui xcá beni, ne ꞌyapabi Ajua̱ pa xahma̱ da punꞌaꞌi de núꞌa̱ ra tsꞌomfeni xcá beni. ");
INSERT INTO oteNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngueꞌa̱ nuga dí handi gue xi ꞌnagrá tsꞌomfeni ne ꞌnagrá ꞌyøtꞌatsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nepʉ núꞌa̱ ra Simu bi da̱di ne bi ꞌñena: ―ꞌYaphʉ tsꞌʉ Ajua̱ por gueque, pa hinda njabʉ ngu núꞌa̱ xcá ma̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ha núꞌʉ ya apostol ngu bi damajua̱niꞌʉ de ma zi Hmuhʉ ra Jesu ne bi ma̱mba rá noya Ajua̱, bi bøniꞌʉ de núꞌa̱ ra hniniꞌa̱. Ne bi thohni ja maꞌra ya tꞌʉca hnini de Nsamaria mi ma̱nga ra hoga ntꞌøde de ra mpøhø. Nepʉ nuꞌʉ́ bi yopa menga Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ꞌMɛfa de gueꞌa̱ ꞌnará ɛnxɛ Ajua̱ bi zofo ra cu Lipe ne bi ꞌñembabi: ―Lipe, stá ehe ga pɛñꞌaꞌi grí ma grí ca̱i, jʉ núꞌa̱ ra ꞌñu nexa Jerusale pa rí zønga asta ja ra hnini Gasa. Núꞌa̱ ra ꞌñuꞌa̱ thogui ja ꞌnara mbonthi. ");
INSERT INTO oteNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nepʉ ra cu Lipe ꞌbestho bi gʉ ra ꞌñu bi ma. Ne de má ꞌñu bi nthɛui ꞌnara ꞌñøhø mrá me Etiopía. Núꞌá̱ mrá eunuco, ne mi gueꞌa̱ ꞌnamrá da̱nga mfatsꞌi núꞌa̱ ra ꞌbɛhña̱ mrá nda̱ nuni Etiopía ne mrá thuhu ra Candace. Nura ꞌñøhøꞌa̱ go gueꞌa̱ mrá mɛꞌsboja̱ de ja rá tsꞌʉtbi núꞌa̱ ra ꞌbɛhña̱ mrá nda̱. Y nuꞌá̱ xqui mengui xqui xøcambeni Ajua̱ nuni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ne ya mri menga pa ja rá hai ne mri zi rá carro mri gʉtꞌa ya fani. Nuni ja mi huhni mi heꞌta ra Ma̱ca Tꞌofo núꞌa̱ bi ꞌyofo ra ba̱di Isaía. ");
INSERT INTO oteNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nepʉ ra Ma̱ca Nda̱hi bi ꞌñemba ra cu Lipe: ―Rí ma ua tsʉ nuna carro xa mani ne rí mɛui. ");
INSERT INTO oteNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nepʉ nura cu Lipe bi nestꞌihi bi ma bá tsʉ núꞌa̱ ra carro, ne bi ꞌyøde núꞌa̱ ra ꞌñøhø mi heꞌtua rá tꞌofo ra ba̱di Isaía, ne bi ꞌñembabi: ―¿Ha gue guí pa̱di te rí bønga núꞌʉ ya noya guí heꞌti? ");
INSERT INTO oteNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nepʉ nuꞌá̱ bi da̱di ne bi ꞌñena: ―¿Hanja da za ga pa̱di te rí bøni ꞌbʉ hinto da ꞌñutcagui? Ne bi ꞌñemba ra cu Lipe: ―Bá pøxa ja ra carro ne bá e ga huhui. ");
INSERT INTO oteNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Y núꞌa̱ ra xɛni de ra Ma̱ca Tꞌofo mi heꞌtiꞌa̱ nu habʉ ena njaua: Núꞌá̱ bi tsꞌitsꞌi nja ngu ꞌnara zi dɛti pa da tho; ne ꞌbesthó himbi xoxa rá ne nja ngu ꞌnara zi dɛti bi ꞌbɛgui pa da tꞌa̱xi. ");
INSERT INTO oteNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mri ꞌñenda ya ja̱ꞌi, ne hinto bi ña̱ni; ha núꞌʉ yá ja̱ꞌi xi bi ntsꞌoꞌmʉi, ne bi tha̱cua rá te de guecua ja ra ximhai. Njabʉ ma̱nga ra Ma̱ca Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nepʉ núꞌa̱ ra me Etiopía bi ꞌñembabi ra cu Lipe: ―Dí ba̱nteꞌi gui xicagui de núꞌa̱ rá ꞌmɛhni Ajua̱, ¿ha gue mi ma̱ de guesɛꞌa̱, o mi ma̱ de maꞌna ra ja̱ꞌi? ");
INSERT INTO oteNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nepʉ nura cu Lipe bi mʉdi bi ña̱, ne bi xipabi gatho ra hoga ntꞌøde de ma zi Hmuhʉ ra Jesu desde habʉ mi heꞌta ra me Etiopía go gueꞌa̱ ꞌnara xɛni de ra Ma̱ca Tꞌofo núꞌa̱ xqui ꞌyofo ra ba̱di Isaía. ");
INSERT INTO oteNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nepʉ de mi ꞌyoꞌʉ ja ra ꞌñu bi zønga habʉ mi ja ꞌnara mothe, ha bi ꞌñenga núꞌa̱ ra me Etiopía: ―Jani ꞌnara zi mothe po ra dehe. ¿Ha hinda za ja ga nxisteheni? ");
INSERT INTO oteNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ha nura cu Lipe bi ꞌñembabi: ―ꞌBʉ xi guí camfri con gatho ri mfeni da za, hanja hina. Nura me Etiopía bi ꞌñena: ―Ha̱ha̱, dí camfri gue ra Jesucristo go gueꞌa̱ rá Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nuꞌbʉ́ nuꞌá̱ bi ꞌbɛpa rá ꞌbɛgo bi ꞌbaꞌma ra carro, nepʉ bi ga̱i ri yohoꞌʉ, ne bi yʉtꞌa mbo ra dehe. Nepʉ ra cu Lipe bi xiꞌtsa núꞌa̱ ra cu me Etiopía. ");
INSERT INTO oteNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Y nu mi bøxa ra cu Lipe de ja ra dehe, bi ꞌmɛtho ngueꞌa̱ rá Ma̱ca Nda̱hi Ajua̱ bi zitsꞌi. Nepʉ nura cu me Etiopía ya himbi yopa hyanda ra cu Lipe maꞌnaꞌqui. Y ya mri sɛhɛꞌa̱ bi sigui bi ne rá ꞌñu co ndunthi ra johya mi pɛꞌtsi. ");
INSERT INTO oteNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nepʉ nura cu Lipe bi zønga nuni Asoto, ne de mi ꞌrani de guehni bi mʉdi bi ma̱nga ra hoga ntꞌøde asta bi zønga nuni Cesarea. ");
INSERT INTO oteNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ha nuya paꞌʉ ra Saulo mi huꞌtsa ya gamfri da hyo, ne bi ma bá nu ra da̱nga nda̱ gá macja̱. ");
INSERT INTO oteNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Bi ma bá a nsɛqui pa da ma nuni ja yá nija̱ ya xodyo nuni Ndamasco pa da gʉ núꞌʉ ri dɛmba rá jamfri ra Zidada Jesu, gue dra ꞌbɛhña̱ gue dra ꞌñøhø, ne dua tsi pa Jerusale da gotꞌa fadi. ");
INSERT INTO oteNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ne de mri ne ra ꞌñu ya mi ma da zønga Ndamasco, mi da̱mfri bi gotꞌatho ꞌnara ñotꞌi asta mi huɛxqui núꞌa̱ ra hyatsꞌi mri ꞌñehe de mahetsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nepʉ ra oraꞌa̱ ꞌbestho bi dagui maꞌmɛmfo ja ra hai. Ne bi ꞌyøde ꞌnara noya mi ena: ―Saulo, Saulo, ¿hanja guí hongagui pa gui ꞌyøtca ra ntsꞌoꞌmʉi? ");
INSERT INTO oteNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nuꞌbʉ́ ra Saulo bi da̱di ne bi ꞌñena: ―¿Toꞌoꞌi, zi Hmu? Nuꞌá̱ bi da̱di ne bi ꞌñena: ―Nuga go gueque drá Jesu. Ha nuꞌi guí hongui pa gui ꞌyøtcagui ra ntsꞌoꞌmʉi ngueꞌa̱ guí honi pa gui ꞌyøꞌtua ra ntsꞌoꞌmʉi núꞌʉ toꞌo xa gamfrigui. Pe nuꞌi go grí ꞌñʉnsɛ, guí nja ngu núꞌa̱ øtꞌa ra nda̱mfri ora tica ra nsʉmboi. ");
INSERT INTO oteNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Y ra Saulo asta mri hua̱tꞌi co ra ntsu ne bi ꞌñena: ―Ma zi Hmuꞌi, ¿te rá ꞌbɛ guí ne ga øtꞌebya? Nuꞌbʉ́ ra Zidada bi ꞌñembabi: ―Nangui ne rí ma ja ra hnini, nuni ja guehni ma da siꞌaꞌi núꞌa̱ rí ꞌñepꞌaꞌi gui ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Y núꞌʉ ya ꞌñøhø mri ꞌñoui ra Saulo xi bi ntsu ngueꞌa̱ nuꞌʉ́ xqui ꞌyøde nehe núꞌa̱ ra noya pe hinxqui hyandi ua toꞌo mi ꞌbahni. ");
INSERT INTO oteNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nepʉ nura Saulo bi nangui de ja ra hai, ne xi mri zøthma̱ yá da pe himbi za bi hyandi. Hangue bri jʉhni bi tsꞌitsꞌi pa asta ja ra hnini Ndamasco. ");
INSERT INTO oteNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Y nuni ja bá ꞌbʉhni hñu pa ne himi handi. Y núꞌʉ hñu pa ni tsꞌʉ hinte bi zi. ");
INSERT INTO oteNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nuni Ndamasco mi ꞌbʉhni ꞌnara gamfri mrá thuhu ra Ananía, y nura Zidada Jesu bi zofo ngu dega tꞌi ne bi ꞌñembabi: ―¡Nugue Ananía! Nuꞌá̱ bi da̱di: ―¿Teꞌa̱, zi Hmu? ");
INSERT INTO oteNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ha nura Zidada bi ꞌñembabi: ―Rí ma, jʉ núꞌa̱ ra ꞌñu rá thuhu ra Jua̱ꞌñu, ne thogui ja rá ngu ra Juda, ne ja gui ꞌñanini ra Saulo núꞌa̱ ra me Tarso. Nu xcrí tsøni gui tsʉdi di øtꞌa rá søcambeni. ");
INSERT INTO oteNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nuꞌá̱ ya stá xipabi ngu dega tꞌi gue ma da tsøni ꞌnara ꞌñøhø rá thuhu ra Ananía, ne da hñuꞌtsua yá ꞌyɛ pa da yopa hyandi. ");
INSERT INTO oteNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nu mi ꞌyøde njabʉ ra cu Ananía bi da̱di ne bi ꞌñena: ―Zi Hmu, stá øde ndunthi de núꞌa̱ ra ꞌñøhøꞌa̱ gue xi mi øꞌtuabi ndunthi ra ntsꞌoꞌmʉi ya cu nuni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ha xa umba nsɛqui ya nda̱ gá macja̱ pa da za da gʉ gatho núꞌʉ di xøcambeniꞌi ri thuhu de guecua nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nepʉ ra Zidada bi ꞌñemba ra cu Ananía: ―Grí ma gui ꞌyøtꞌa núꞌa̱ dí xiꞌi, ngueꞌa̱ go gueꞌa̱ ra ꞌñøhø stá huahni pa da mɛpcagui ne da ꞌñutua ma thuhu ya me Israel ne gatho núꞌʉ hingyá me Israel ne nuyá nda̱ꞌʉ, pa da ba̱diꞌʉ toꞌogui. ");
INSERT INTO oteNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne nuga go ma ga utuabi gatho núꞌʉ ya tsꞌothogui pɛꞌtsi da thogui po rá ngue ma thuhu. ");
INSERT INTO oteNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nuꞌbʉ́ ra cu Ananía bi ma ne bi yʉtꞌa ja ra ngu habʉ mi ꞌbʉ ra Saulo. Ne bi hñuꞌtsua yá ꞌyɛ, ne bi ꞌñembabi: ―Zi cu Saulo, ra Zidada Jesu núꞌa̱ toꞌo gá handa ja ra ꞌñu núꞌa̱ ngrí nehi pa guecua, go gueꞌa̱ xa mɛncagui pa da yopa xo ri da ne gui hña̱nga ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ne ꞌbestho ra oraꞌa̱ bi dagui núꞌa̱ te mi coꞌtua yá da, ne ꞌbestho bi yopa hyandi. Ne nuꞌá̱ bi ꞌmai bi ma bá nxistehe. ");
INSERT INTO oteNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ne bi ñuni, nepʉ bi yopa nja rá tsꞌɛdi, ne bi ꞌmʉhni ꞌraya pa co ya gamfri nuni Ndamasco. ");
INSERT INTO oteNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nepʉ ꞌbestho bi ma bá damajua̱ni de ma zi Hmuhʉ ra Jesucristo ja yá nija̱ ya xodyo, ne mi ma̱ gue ra Jesu go gueꞌa̱ rá Tꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Y gatho núꞌʉ toꞌo mi øde núꞌa̱ mi ma̱ñꞌa̱ xi mri ꞌyø ne mi eñꞌʉ: ―¿Ha hingo guehni núni xi mi øꞌtua ra ntsꞌoꞌmʉi núꞌʉ toꞌo xøcambenibi rá thuhu ra Jesu nuni Jerusale? ¿Ha hingo guehni xqui ꞌñehe da gʉ ntsꞌa̱hni ya gamfri pa da ziꞌtsua ya nda̱ gá macja̱? ");
INSERT INTO oteNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pe nura cu Saulo maꞌna mi jʉ rá tsꞌɛdi pa da damajua̱ni gue ra Jesu go gueꞌa̱ ra Cristo rá ꞌmɛhni Ajua̱ ne xqui hñutsꞌiꞌa̱ pa da e da nda̱. Y nuya xodyo himbi ba̱di te da beni gatho núꞌʉ mi ꞌbʉhni Ndamasco. ");
INSERT INTO oteNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bi thogui ndunthi ya pa, nepʉ bi mʉdi bi má̱mbi ya xodyo pa da hyohma̱ ra cu Saulo. ");
INSERT INTO oteNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pe núꞌa̱ ra cohi bi gohiꞌʉ, bi tꞌumba ntꞌøde ra cu Saulo gue nuꞌʉ́ ma pa ra xuui mi su gatho ya gosthi de núꞌa̱ ra hniniꞌa̱ pa xa thohma̱ꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pe nu mi ba̱di ya cu njabʉ, bi ꞌyɛntꞌa ra cu Saulo ja ꞌnara da̱nga ꞌbøtsꞌe pa bri tontsꞌa dega xuui pa møte de ra ja̱do núꞌa̱ mi cotꞌa ra hnini, pa bi za bi ꞌbatꞌiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nu mi zønga ra cu Saulo Jerusale mi nehma̱ꞌa̱ da muntsꞌiui ya gamfri, pe nuꞌʉ́ mi tsu ngueꞌa̱ himi camfriꞌʉ gue nuꞌá̱ ya mi ꞌnara gamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pe nura cu Berhna bi zitsꞌi pa habʉ mbi ꞌbʉ ya apostol, ne bi metuabi hanja xqui hyanda ra Zidada Jesu ja rá ꞌñu ra cu Saulo, ne xqui ña̱ui. Ne bi metuabiꞌʉ gue nuꞌá̱ ya xqui ña̱ de rá thuhu ra Zidada Jesu co ndunthi ra tsꞌɛdi nuni Ndamasco. ");
INSERT INTO oteNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Y njabʉ bi za bi ꞌmʉi co ya gamfri nuni Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nuꞌá̱ himi tsu da ma̱ de rá thuhu ra Zidada Jesu, ne mi ntsanoyaui ya xodyo núꞌʉ mi ña̱ca griego, ha nuꞌʉ́ mi ɛcuabi da hyoꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pe nu mi ba̱di njabʉ ya cu bi zixa ra cu Saulo pa nuni Cesarea, nepʉ bi mɛhniꞌʉ pa Tarso. ");
INSERT INTO oteNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ꞌMɛfa gatho ya gamfri bi mɛꞌtsa ꞌnara hogaꞌmʉi nuni Judea ne Galilea ne Nsamaria, ne mi zɛdi yá jamfri, ne mi ꞌyoꞌʉ co ndunthi rá ntsu Ajua̱, ne maꞌna mri xu ya gamfri co rá mfatsꞌi ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ha nura apostol Pedro bi ꞌño bi zønga gatho ya gamfri, ne bi ma bá cꞌa̱ꞌtsa ya cu núꞌʉ mi ꞌbʉhni Lida. ");
INSERT INTO oteNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ne ja bi zʉhni ꞌnara ꞌñøhø rá thuhu ra Enea, ne ya mi øtꞌa hña̱to jɛya xqui ꞌmɛnga ja ra mfidi ngueꞌa̱ mi tsʉ ꞌnara hñeni núꞌa̱ nixi mi tsa da a̱nga rá ndoꞌyo. ");
INSERT INTO oteNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nepʉ ra cu Pedro bi ꞌñembabi: ―Enea, ra Zidada Jesucristo xa ꞌyøtheꞌi. Nangui jʉxa ri mfidi. Nepʉ nuꞌá̱ ꞌbestho bi nangui. ");
INSERT INTO oteNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Y gatho ya mengu de guehni Lida ne ya me Sarón bi zogui yá nda̱xjua jamfri ne bi gamfri ra Zidada Jesu co núꞌa̱ xqui hyandiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nuni Jope mbi ꞌbʉ ꞌnara ꞌbɛhña̱ mrá gamfri núꞌa̱ mrá thuhu ra Tabita, dega griego tꞌembi ra Dorca. Núꞌá̱ nza̱ntho mi øtꞌa ndunthi ra hñoja̱ꞌi ne mi faxa ya hyoya. ");
INSERT INTO oteNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ha nuya paꞌʉ bi zʉ ꞌnara hñeni ne bi du. Nepʉ bi sati ngu myá nza̱iꞌʉ ne bá ꞌbɛgui ja ꞌnara tøngu. ");
INSERT INTO oteNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pe de guehni Jope mi guetbʉ pa ja ra hnini Lida, ne nuya gamfri de guehni xqui ꞌyøde gue ja mbi ꞌbʉhni ra cu Pedro nuni Lida, hangue bi ꞌbɛhna yoho ya ꞌmɛhni pa dua tsi ne da ꞌñembi: ―Dí ba̱nteꞌihe ga maha ꞌbestho pa Jope. ");
INSERT INTO oteNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nepʉ nura cu Pedro ꞌbestho bi mɛuiꞌʉ. Ne nu mi zøni bi tsꞌitsꞌi pa ja ra tøngu habʉ xqui muntsꞌa ndunthi ya viuda mi zoni. Ne bi tꞌutuabi ra cu Pedro nuya pahni ne maꞌra ya he xqui hyoca ra nju Dorca núꞌbʉ mi teꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nuꞌbʉ́ ra cu Pedro bi ꞌbɛpi da bønga pa thi gatho núꞌʉ mi ꞌbʉhni, ne nuꞌá̱ bi ndandiña̱hmu ne bi ꞌyapabi Ajua̱. Nepʉ bi zofo núꞌa̱ xqui du ne bi ꞌñembabi: ―Tabita, nangui. Ne nuꞌá̱ ꞌbestho bi zøtꞌa yá da, ne nu mi hyanda ra cu Pedro bi nangui bi hñudiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ha nura cu Pedro bi mipa ꞌnará ꞌyɛ ne bi ꞌbaꞌmi. Nepʉ bi zohna ya viuda ne maꞌra ya gamfri pa bi ꞌñutuabi gue ya xqui yopa nte. ");
INSERT INTO oteNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Y gatho de guehni Jope bi ntꞌøde de núꞌa̱ xqui nja, ne ndunthi toꞌo bi gamfri ra Zidada Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ha nura cu Pedro bi gohi ndunthi ya pa de guehni Jope ja rá ngu ra cu núꞌa̱ rá thuhu ra Simu dɛxifri. ");
INSERT INTO oteNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mi ꞌbʉ ꞌnara ꞌñøhø nuni Cesarea mrá thuhu ra Neyo núꞌa̱ mrá me Italia ne himrá xodyo, nehe go mrá nda̱ de núꞌʉ ya soldado myá mengu rá haiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Núꞌá̱ xi mrá hoja̱ꞌi ne xi mi tsu Ajua̱, ne gatho núꞌʉ ya mengu rá ngu. Ne mi øtꞌa ndunthi ra hño ngueꞌa̱ mi faxa ya xodyo núꞌʉ xi myá hyoya. Ne nza̱ntho mi xøcambeni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nepʉ ꞌnara pa ngu mi nzʉnga hñu nde bi hyanda ꞌnará ɛnxɛ Ajua̱ ngu dega tꞌi, bi yʉtꞌa habʉ mi ꞌbʉiꞌa̱ ne bi ꞌñembabi: ―¡Neyo! ");
INSERT INTO oteNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nu mi hyandi xi bi nʉꞌti ne xi bi ntsu, ne bi ꞌñena: ―¿Teꞌa̱, zi Hmu? Nura ɛnxɛ bi ꞌñembi: ―Nuri ntꞌadi xa ꞌyøde Ajua̱ ne núꞌʉ ri mfatsꞌi xcá ꞌyøtꞌe xa hyandiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hangue nubya pɛhna ꞌraya ꞌmɛhni pa ja ra hnini Jope pa dua tsi ra Simu núꞌa̱ thuꞌmbabi nehe ra Pedro. ");
INSERT INTO oteNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Núꞌá̱ bí ꞌbʉi ja rá ngu maꞌna ra Simu núꞌa̱ ra dɛxifri, ꞌbʉi guetbʉ ja rá hyo ra ndehe. Y núꞌa̱ ra Pedro go gueꞌa̱ ma da xiꞌaꞌi te rí ꞌñepꞌaꞌi gui ꞌyøtꞌe. ");
INSERT INTO oteNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nu mi ma ra ɛnxɛ núꞌa̱ mi ña̱ui ra Neyo, bi zohna yoho yá ꞌbɛgo ne ꞌnamrá nza̱i soldado núꞌa̱ mi xøcambeni Ajua̱ nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Go gueꞌʉ bi xipabi te ꞌbɛꞌa̱ bi nja, ne bi mɛhni pa ra hnini Jope. ");
INSERT INTO oteNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ha nurá hyaxꞌa̱ de mi ꞌyo yá ꞌñuꞌʉ y ya mi ma da zønga ja ra hnini Jope, nuꞌbʉ́ nura oraꞌa̱ ra cu Pedro bi bøxa ja ꞌnara tøngu pa da ꞌyapabi Ajua̱ nuni ja ra hnini Jope, y mi ngu nde ma pa nura oraꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Y xi mi tsʉ ꞌnara thuhu y ya xa nehma̱ xa ñuhma̱, pe ja mi thocuabi te da zi. Y núꞌa̱ ra oraꞌa̱ bi hyanda ꞌnara ntꞌudi ngu dega tꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ne bi hyandi bi xogui mahetsꞌi ne bá ja̱ꞌma pa ja ra hai ꞌñena ꞌnara da̱nga dutu mi thuꞌtsa gatho goho yá ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Y ja núꞌa̱ ra dutuꞌa̱ mbra cʉni gatho ya mboꞌoni ne gatho ya zuꞌue núꞌʉ ja goho yá ua, ne ya quꞌeña̱ ne ya tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nepʉ bi ꞌyøde ꞌnara noya bi ꞌñena: ―Pedro, jʉ nuyʉ ya mboꞌoni ne ya zuꞌue ne hyo pa gui tsi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nuꞌbʉ́ nura cu Pedro bi da̱di ne bi ꞌñena: ―Hina, zi Hmu, ngueꞌa̱ hinhyaꞌmʉ stá tsi núꞌa̱ xá ntsꞌo ne hingui tꞌaxi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ne núꞌa̱ ra noyaꞌa̱ bi ꞌñemba maꞌnaꞌqui: ―Oguí embi xá ntsꞌo núꞌa̱ xa xʉca Ajua̱ ne xá ntꞌaxi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bi njabʉ hñuꞌqui, nepʉ bi bøxa maꞌnaꞌqui pa mahetsꞌi núꞌa̱ ra dutu. ");
INSERT INTO oteNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ha nura cu Pedro mi ꞌbʉhni mi ꞌyo rá mfeni ne mi ne da ba̱di te mri bønga núꞌa̱ ngu ra tꞌi xqui hyandi. Nura oraꞌa̱ bi zøhø yá ꞌmɛhni ra Neyo ja ra gosthi, xqui ꞌño xqui ꞌñani habʉ mi ja rá ngu ra Simu dɛxifri. ");
INSERT INTO oteNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ha nu mi zøni ja núꞌa̱ ra nguꞌa̱ bi ꞌñani ua ja mi ꞌbʉhni ra Simu núꞌa̱ xqui thuꞌmbabi nehe ra Pedro. ");
INSERT INTO oteNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pe nura cu Pedro tobya mi oda rá mfeni núꞌa̱ ngu ra tꞌi xqui hyandi, ne ra Ma̱ca Nda̱hi bi ꞌñembi: ―Bi zø hñu ya ꞌñøhø hoñꞌaꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ꞌBai ca̱i rí mɛuiꞌʉ. Ne ote xqui ma gui tsu, ngueꞌa̱ go stá pɛncaꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nepʉ ra cu Pedro bi ga̱i habʉ mi ꞌba núꞌʉ yá ꞌmɛhni ra Neyo, ne bi ꞌñembi: ―Nuga go gueque guí honjʉ. ¿Te xqui ꞌbɛñꞌahʉ? ");
INSERT INTO oteNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Xpá mɛncahe ma nda̱ gá soldadohe ra Neyo, ꞌnara hoga ꞌñøhø xi tsu Ajua̱, ne gatho ya xodyo ña̱mahño de gueꞌa̱. Y ꞌnará ɛnxɛ Ajua̱ bi xipi gue mahyoni da mɛhni toꞌo da e da zixꞌaꞌi pa gui ma ja rá nguꞌa̱, pa da ꞌyøde núꞌa̱ ma gui xipabi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nepʉ ra cu Pedro bi umba ntsayaꞌʉ habʉ mi ꞌbʉiꞌa̱, ne ja bi ꞌñoxiniꞌʉ con gueꞌa̱ núꞌa̱ ra xuuiꞌa̱. Ha nurá hyaxꞌa̱ ra cu Pedro bi ma con gueꞌʉ ne bi mɛ maꞌra ya cu núꞌʉ mi ꞌbʉhni Jope. ");
INSERT INTO oteNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Y rá hyaxꞌa̱ bi zøñꞌʉ nuni Cesarea habʉ mi ꞌbʉ ra Neyo mi tøꞌmi, ne xqui zohna gatho núꞌʉ ja te myá njaui, ne núꞌʉ xi myá hma̱diꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","De mi zønga ra cu Pedro ja rá ngu ra Neyo, nuꞌá̱ bi bøni pa da da̱di, ne bi ndandiña̱hmu ja yá uaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pe nura cu Pedro bi ꞌbaꞌmi ne bi ꞌñembabi: ―ꞌBai, ngueꞌa̱ nequi ꞌnadrá ꞌñøhø nehe nguꞌatho. ");
INSERT INTO oteNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Y de mi ña̱ꞌʉ bi yʉtꞌa ri yoho mbo ra ngu, ne mi ꞌbʉhni ndunthi ya ja̱ꞌi xqui muntsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nepʉ ra cu Pedro bi ꞌñembabiꞌʉ: ―Nuꞌahʉ guí pa̱hʉ gue núje dyá xodyohe hingui tsa ga ntha̱ntshe co núꞌahʉ hingyá xodyohʉ, y nixi tsa ga cʉthe ja ri nguhʉ, ngueꞌa̱ ꞌramaꞌnaꞌño ma jamfrihʉ. Pe Ajua̱ xa xicagui gue hinga embabi xá ntsꞌo o hingui tꞌaxi ni ꞌnara ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hangue ngu mi xicagui ya ꞌmɛhni gue ga eheua, ꞌbestho duá ehe nsinque te dá ma̱. Ne dí ne ga pa̱di pa te uá tsigaguihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nuꞌbʉ́ ra Neyo bi da̱tuabi ne bi ꞌñembi: ―Øtꞌa goho ma pa ngu ra zi orabya ndí ꞌbʉcua ja ma ngu stí ayuna ne ndí apabi Ajua̱ ngu ma nza̱i dega nde, ndá tha̱mfri dá handa ꞌnara ꞌñøhø mi he ꞌraya dutu asta mi huɛxqui. ");
INSERT INTO oteNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ne bi ꞌñengagui: “Neyo, Ajua̱ xa ꞌyøꞌtꞌaꞌi ri tꞌadi ne xa hyanda núꞌa̱ xcá ꞌyøꞌtua ya hyoya xcá fatsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pɛhna pa ja ra hnini Jope toꞌo ma dua tsi ra Simu núꞌa̱ xa thuꞌmbabi nehe ra Pedro. Nuꞌá̱ bí ꞌbʉ ja rá ngu maꞌna ra Simu ra dɛxifri núꞌa̱ bí ꞌbʉ guetbʉ ja rá hyo ra ndehe. Y nu sta zøꞌa̱ ma gui ña̱ui pa da zoꞌaꞌi,” njabʉ bi ꞌñengagui. ");
INSERT INTO oteNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hangue ꞌbestho dá pɛmpʉ toꞌo bá hoñꞌaꞌi, ne xá hñoꞌa̱ xcá ehe. Y nubyá dí ꞌbʉheua gatho ja rá thandi Ajua̱, ne dí ne ga øhe gatho núꞌa̱ xa xiꞌaꞌi pa gui xicje. ");
INSERT INTO oteNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Hangue nura cu Pedro bi mʉdi bi ña̱ ne bi ꞌñena: ―Nubyá ha̱, stá pa̱di gue xi majua̱ni Ajua̱ hingui huahna ya ja̱ꞌi ꞌra co maꞌra. ");
INSERT INTO oteNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ngueꞌa̱ nuꞌá̱ ri ma̱di gatho núꞌʉ toꞌo ꞌyo ja rá ntsuꞌa̱ ne øtꞌa núꞌa̱ xá hño, masque habʉraza dya mengu. ");
INSERT INTO oteNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ajua̱ bi zocje núje dyá me Israelhe pa dá má̱dihe con gueꞌa̱ po ra Zidada Jesucristo núꞌa̱ toꞌo ma Hmuhʉ drí gathohʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ngu guí pa̱sɛhʉ núꞌa̱ bi nja nuni ja ma haihe núje dyá xodyohe, ra Xuua bi ꞌyøtꞌa ra sistehe, ꞌmɛfa ma zi Hmuhʉ ra Jesu bi fʉta rá ꞌbɛfi nuni Galilea ne bi ꞌño gatho ja ra hai Judea. ");
INSERT INTO oteNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ne guí pa̱sɛhʉ gue Ajua̱ bi umba ra Ma̱ca Nda̱hi ra Jesu núꞌa̱ mrá me Nasare pa bi umba ra tsꞌɛdi. Núꞌá̱ bi ꞌño bi ꞌyøtꞌa ra hño, ne bi ꞌyøthe gatho núꞌʉ mi hñeni ne mi pɛꞌtsa ya tsꞌonda̱hi. Ra Zidada Jesu mi øtꞌa njabʉ ngueꞌa̱ Ajua̱ mi ꞌbʉi con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Y nuje go drí damajua̱nihe gatho núꞌa̱ bi ꞌyøtꞌa ra Zidada Jesu nuni ja ya tꞌʉca hnini Judea ne ja ra da̱nga hnini Jerusale. Y ꞌmɛfa nuꞌá̱ bi tsꞌʉta ja ꞌnara pontꞌi asta himbi tho. ");
INSERT INTO oteNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pe Ajua̱ bi ꞌyøtꞌe pa rá hñupa bi yopa nte, ne bi ꞌyøtꞌe pa bi hnecanja̱ꞌi pa dá hanthe maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pe hingo gatho ya ja̱ꞌi bi yopa hyantꞌa̱, hønsɛguihe dá hanthe, ngueꞌa̱ Ajua̱ xqui huancahe desde rá mʉdi pa ga dahe majua̱ni de gueꞌa̱ gue nuꞌá̱ bi yopa nte maꞌnaꞌqui de ja ra du. Y nu de ya xqui yopa nte de ja ra du, dá yopa ñuñhe ne dá ntsithehe con gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nepʉ nuꞌá̱ bi ꞌbɛpcahe ga zofohe ya ja̱ꞌi ne ga dahe majua̱ni gue Ajua̱ go xa hñutsꞌiꞌa̱ pa da hña̱ꞌmba nguɛnda núꞌʉ te, ne núꞌʉ xa du. ");
INSERT INTO oteNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nehe gatho yá ꞌmɛhni Ajua̱ mi ꞌbʉi desde rá mʉdi bi damajua̱ni de ra Zidada Jesu gue nuꞌa̱ tóꞌo da gamfribi rá thuhu dra pumbabi yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ha de mi ma̱nga ra cu Pedro nuya ya noyaya, bá ca̱i ra Ma̱ca Nda̱hi ne bi yʉtꞌa ja yá coraso gatho núꞌʉ toꞌo mi øde núꞌa̱ mi ma̱nga ra cu Pedro. ");
INSERT INTO oteNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ha núꞌʉ ya xodyo myá gamfri núꞌʉ bá ꞌñoui ra cu Pedro, xi bi ꞌyø ngueꞌa̱ xqui hña̱nga ra Ma̱ca Nda̱hi nehe núꞌʉ himyá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ngueꞌa̱ bi ꞌyøde mi ña̱ nehe de maꞌra ya hña̱qui núꞌʉ himi pa̱di, ne mri xøcambeniꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nepʉ nura cu Pedro bi ꞌñena: ―¿Toꞌo ja da hña̱cuabi da nxistehe núyʉ toꞌo xa hña̱nga ra Ma̱ca Nda̱hi ngu stá ha̱ñhʉ? ");
INSERT INTO oteNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nuꞌbʉ́ ra cu Pedro bi ꞌbɛpabiꞌʉ da nxistehe de rá thuhu ra Zidada Jesucristo. Nepʉ nuꞌʉ́ bi ba̱ntebi ra cu Pedro gue da gohi con gueꞌʉ maꞌra ya pa. ");
INSERT INTO oteNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bi ꞌyøde núꞌʉ ya apostol ne maꞌra ya gamfri mbi ꞌbʉ Judea gue ne núꞌʉ himyá xodyo ya xqui hña̱nga rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ne mi menga ra cu Pedro pa Jerusale, ja bá nuuini núꞌʉ yá mixodyoui ya myá gamfri pe mri dɛnbatho yá nza̱i ya xodyo. Núꞌʉ́ bi zʉi ra cu Pedro, ");
INSERT INTO oteNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ne bi ꞌñembabi: ―¿Hanja xcá cʉtꞌa ja yá ngu núꞌʉ ya ꞌñøhø hingyá xodyo ne xcá ñuni con gueꞌʉ? ");
INSERT INTO oteNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nuꞌbʉ́ ra cu Pedro bi metuabi gatho núꞌa̱ xqui nja desde ra mʉdi ne bi ꞌñembabiꞌʉ: ");
INSERT INTO oteNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Nuga ndí ꞌbʉhni ndí apabi Ajua̱ ja ra hnini Jope, ne dá handa ꞌnara ntꞌudi ngu dega tꞌi. Bá ja̱ꞌmi de mahetsꞌi ꞌñena ꞌnara da̱nga dutu mi thuꞌtsa gatho goho yá ña̱ni, ne bi zøhø habʉ ndí ꞌbʉi. ");
INSERT INTO oteNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ne dá handa xá hño te mi cʉni, dá handi mi cʉ gatho ya mboꞌoni ne gatho ya zuꞌue núꞌʉ ja goho yá ua, ne ya quꞌeña̱ ne ya tsꞌintsꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ne dá øde ꞌnara noya bi ꞌñengagui: “Pedro, jʉ nuyʉ ya mboꞌoni ne ya zuꞌue, ne hyo pa gui tsi.” ");
INSERT INTO oteNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ne dá embabi: “Hina, zi Hmu, ngueꞌa̱ hinhyaꞌmʉ stá tsi núꞌa̱ xá ntsꞌo ne hingui tꞌaxi.” ");
INSERT INTO oteNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nepʉ núꞌa̱ ra noya de mahetsꞌi bi yopa ña̱ ne bi ꞌñengagui: “Oguí embabi xá ntsꞌo núꞌa̱ xa xʉca Ajua̱ ne xá ntꞌaxi.” ");
INSERT INTO oteNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bi njabʉ hñuꞌqui, nepʉ bi njʉtsꞌi pa mahetsꞌi núꞌa̱ ra dutu. ");
INSERT INTO oteNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ha núꞌa̱ ra oraꞌa̱ bi zøhø ja ra ngu habʉ ndí ꞌbʉi hñu ya ꞌñøhø xqui ꞌbɛhni de Cesarea pa da zixcagui. ");
INSERT INTO oteNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Y nura Ma̱ca Nda̱hi bi ꞌñengagui ga mɛꞌbeꞌʉ, masque himyá xodyo. Nehe dá mɛꞌbe núꞌʉ má ꞌrato ya cu, ne dá tsøñhe dá cʉthe ja rá ngu núꞌa̱ toꞌo xqui mɛhna ya ꞌmɛhni da zixcagui. ");
INSERT INTO oteNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nura ꞌñøhøꞌa̱ bi xicje hanja xqui hyandua ꞌnará ɛnxɛ Ajua̱ de guehni ja rá ngu gue nuꞌá̱ bi ꞌñembabi ꞌna̱: “Pɛhna ꞌraya ꞌmɛhni pa ja ra hnini Jope pa dua tsi ra Simu núꞌa̱ xa thuꞌmbabi nehe ra Pedro. ");
INSERT INTO oteNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nuꞌá̱ go da xiꞌaꞌi hanja da za gui mpøhø ne gatho ya mengu ri ngu.” ");
INSERT INTO oteNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ha nu ndá fʉdi dá ña̱, bi hña̱niꞌʉ ra Ma̱ca Nda̱hi mahyɛgui ngu dá ha̱ñhe ra mʉdi nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ra oraꞌa̱ dá beni de núꞌa̱ xqui ma̱nga ma zi Hmuhʉ núꞌbʉ bi ꞌñena: “Ra Xuua mi xiꞌtsate co ra dehe, pe nuꞌahʉ́ ma gui nxistehehʉ co ra Ma̱ca Nda̱hi.” ");
INSERT INTO oteNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ꞌBʉ Ajua̱ njabʉ rá paha xa umbabiꞌʉ ra Ma̱ca Nda̱hi ngu bi ꞌracaguihʉ nújʉ dí camfrihʉ ma zi Hmuhʉ ra Jesucristo, toꞌoguiga pa go ga ha̱cua rá ꞌbɛfi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ha nu mi ꞌyøde njabʉ núꞌʉ ya cu mi ꞌbʉhni Jerusale, ya bi goꞌtatho yá ne, ne bi nsunda Ajua̱ bi ꞌñena: ―¡Njabʉ rá paha Ajua̱ gue da ñobri nehe núꞌʉ hingyá xodyo pa da mɛꞌtsa ra te pa nza̱ntho ngu núꞌa̱ dí pɛꞌtshʉ nehe! ");
INSERT INTO oteNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Desde bi tho ra cu Teba, bi mʉdi bi tꞌʉtsa núꞌʉ maꞌra ya gamfri. Hangue nu ꞌra de gueꞌʉ bi ꞌbatꞌi gá ma Fenicia, ha nu maꞌra Chipre, ha nu maꞌra Antioquía. Y nu habʉ gá maꞌʉ bá zo yá mixodyoui de rá noya Ajua̱, hinto maꞌra bá zofo. ");
INSERT INTO oteNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pe mi ꞌbʉ ꞌraya cu myá me Chipre ne nu maꞌra myá me Cirene, núꞌʉ́ bi zønga ja ra hnini Antioquía, y bi zofo nehe núꞌʉ ya ja̱ꞌi himyá xodyo de ra hoga ntꞌøde de ra Zidada Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ajua̱ bi umba ra tsꞌɛdiꞌʉ ne bi matsꞌi, ne ndunthi ya ja̱ꞌi bi hyɛpʉ yá nda̱xjua jamfri ne bi gamfri ra Zidada Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ne mi ba̱di ya gamfri núꞌʉ mi ꞌbʉhni Jerusale de núꞌa̱ mbi ja de guehni Antioquía, hangue nuꞌʉ́ bi mɛhna ra cu Berhna pa guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ne nu mi zøñꞌa̱ bi hyandua rá ꞌbɛfi Ajua̱, nuꞌbʉ́ nuꞌá̱ bi ba̱di gue Ajua̱ xqui ja̱piꞌʉ, ne nuꞌá̱ xi bi johya. Ne bi zofo gatho núꞌʉ xqui gamfri de guehni gue xá hño da sigui da gamfri Ajua̱ co yá mfeni strá ntꞌaxi ne da zɛdi yá jamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ngueꞌa̱ núꞌa̱ ra cu Berhna ꞌnamrá hoga cu mi ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi ne xi mi ja rá jamfri. Y ndunthi ya ja̱ꞌi bi gamfri ra Zidada por gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nepʉ ra cu Berhna bi ma pa Tarso pa da hyonga ra cu Saulo, ne de mi zʉdi bi zitsꞌi bi mɛui pa Antioquía. ");
INSERT INTO oteNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ne ja bi ꞌmʉhniꞌʉ maxøgue ꞌna njɛya, ne mri muntsꞌiꞌʉ co ya gamfri, ne bi ꞌñutuabi ndunthi ya ja̱ꞌi de rá noya Ajua̱. Y nuni Antioquía ja guehni bi mʉdi bi thuꞌmba ya gamfri gue dya cristiano ngueꞌa̱ bi gamfri ma zi Hmuhʉ ra Jesucristo. ");
INSERT INTO oteNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","De nuya paꞌʉ bi bønga ꞌrayá ꞌmɛhni Ajua̱ de guehni Jerusale pa bi ma Antioquía. ");
INSERT INTO oteNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ne ꞌna de gueꞌʉ mrá thuhu ra Agabo bi ꞌmai madetho de habʉ xqui muntsꞌa ya cu ne bi ma̱ gue xqui xipa ra Ma̱ca Nda̱hi gue mi ma da nja ꞌnara da̱nga thuhu maxøgue rá ngʉni ra ximhai. Y ha̱ bi njabʉ núꞌʉ ya pa mrá nda̱ ra Claudio. ");
INSERT INTO oteNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nepʉ nuya gamfri de Antioquía bi beni gue da mɛmpa ꞌnara mfatsꞌi núꞌʉ maꞌra ya gamfri mi ꞌbʉ nuni Judea, bi uni cada ꞌna de gueꞌʉ ngu núꞌa̱ mi tsʉpa yá tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Y núꞌa̱ ra mfatsꞌi bi uñꞌʉ bi ꞌbɛmpa nuya nda̱ de ra nija̱ Judea, y go bi hña̱xa ra cu Berhna co ra cu Saulo pa guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nuya paꞌʉ ra nda̱ Erode bi mʉdi bi ꞌyøꞌtua ra ntsꞌoꞌmʉi ya gamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Núꞌá̱ bi manda da thɛcua rá ꞌyʉga ra apostol Cobo rá cu ra apostol Xuua. ");
INSERT INTO oteNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ha nu mi hyandiꞌa̱ gue ya xodyo mri ho njabʉ, nuꞌbʉ́ bi manda dra jʉ ra apostol Pedro nehe. Ne bri jʉ ja ꞌnará ngo ya xodyo de rá pa ra thuhme nsinque rá nzoi. ");
INSERT INTO oteNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ha nu mri jʉꞌa̱ bi jotꞌa fadi ne bi tꞌɛntꞌua ja yá ꞌyɛ goho ya hmuntsꞌa soldado pa da suꞌa̱, cada ꞌnara hmuntsꞌi mi goho ya soldado. Ngueꞌa̱ ra Erode mi beni gue de xa ua ra ngo de ra pascua xa pønga de ra fadi pa xa thohma̱ ja yá thandi ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pe nu de mi ofadi ra cu Pedro ne mri su xá hño, nuya gamfri himi tsaya mi apabi Ajua̱ por gueꞌa̱ con gatho yá jamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Y núꞌa̱ ra xuuiꞌa̱ ante da manda ra Erode dua tsꞌi de ja ra fadi, ra cu Pedro mi a̱ha̱ de guehni, y mi tha̱tꞌi co ꞌnara soldado ja rá ꞌñɛi ne maꞌna ja rá nga̱ha̱, gatho ri hñu mi tha̱tꞌi co ya cadena, y nu maꞌra ya soldado mi ꞌbai ja ra gosthi fadi mri su ra cu Pedro pa hinda bøni. ");
INSERT INTO oteNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Y masɛctho bi zøhø ꞌnará ɛnxɛ Ajua̱ ne asta mri yotꞌa mbo ra fadi, y nura ɛnxɛ bi dʉni ra cu Pedro pa bi ꞌya, ne bi ꞌñembabi: ―Nxøni da̱ma nangui. Y nura oraꞌa̱ ꞌbestho bi xotꞌa ya cadena de ja yá ꞌyɛ ra cu Pedro. ");
INSERT INTO oteNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ha nura ɛnxɛ bi ꞌñembabi: ―Dʉꞌta ri ngʉtꞌi ne tiꞌta ri thiza. Y nuꞌá̱ ꞌbestho bi ꞌyøtꞌa njabʉ. Nepʉ ra ɛnxɛ bi ꞌñembabi: ―Patꞌa ri patꞌi ne maha. ");
INSERT INTO oteNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nuꞌbʉ́ ra cu Pedro bi bøni bi dɛna ra ɛnxɛ, nixi mi pa̱di gue xi majua̱ni xqui ꞌyøtꞌa njabʉ ra ɛnxɛ ngueꞌa̱ mi hu rá mʉiꞌa̱ gue mi ꞌuiꞌtha̱. ");
INSERT INTO oteNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ne bi thoguiꞌʉ habʉ mi ꞌba ya mʉdi soldado, nepʉ bi thogui habʉ mi ꞌba rá ñoho ra hmuntsꞌa soldado, ne ꞌbestho bi zønga ja ra da̱nga gosthi dega bøja̱ núꞌa̱ mi ja de thi ja ra ꞌñu. Y núꞌa̱ ra gosthiꞌa̱ bi xoguisɛ. Nepʉ bi bøniꞌʉ pa ja ra ꞌñu. Y de guehni bi ꞌño ꞌna tʉiꞌʉ, nepʉ ꞌbestho ra oraꞌa̱ ra ɛnxɛ bi ꞌuegue de ra cu Pedro. ");
INSERT INTO oteNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nuꞌbʉ́ ra cu Pedro ya bi gʉ rá mfeni, ne bi ꞌñensɛ: ―Nubyá ha̱ dí pa̱di gue xi majua̱ni Ajua̱ xpá mɛhni rá ɛnxɛ pa bi ña̱ngagui de yá ꞌyɛ ra Erode ne de gatho núꞌʉ mi ne xa ꞌyøtcagui ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","De mi beni njabʉ ra cu Pedro bi gʉ ra ꞌñu bi ma pa ja rá ngu ra nju Maria núꞌa̱ rá na̱na̱ ra cu Xuua, núꞌa̱ xqui thuꞌmbabi ra Marco nehe. Ne ja mi ꞌbʉhni ndunthi ya gamfri mi apabi Ajua̱ por gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nepʉ nuꞌá̱ bi gantꞌa ra gosthi, ne ꞌnara nxutsi mrá thuhu ra Rode bi ma ja ra gosthi pa da nu toꞌo mri gantꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Y núꞌa̱ ra nxutsi ꞌbestho bi ba̱tua rá noya gue go mi gueꞌa̱ ra cu Pedro. Pe co ra johya mi pɛꞌtsi himbi xocua ra gosthi. Bi nestꞌihi bá xipabi núꞌʉ maꞌra ya gamfri gue ya mi ꞌbahni ra cu Pedro ja ra gosthi. ");
INSERT INTO oteNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nepʉ nuꞌʉ́ bi ꞌñembabi: ―¡Xcá ꞌbɛ ri mfeni! Pe nuꞌá̱ xi mi zɛdi gue go mi gueꞌa̱ ra cu Pedro. Hangue nuꞌʉ́ bi ꞌñembabi: ―Hingo gueꞌa̱, za̱i go di gueꞌa̱ rá ɛnxɛ Ajua̱ núꞌa̱ suꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pe nura cu Pedro himi tsaya mi gantꞌa ra gosthi. Ne de mi xoca ra gosthiꞌʉ bi hyandi gue go mi gueꞌa̱ ra cu Pedro. Nepʉ nuꞌʉ́ xi bi ntsu. ");
INSERT INTO oteNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pe ra cu Pedro mi utua ra seña co rá ꞌyɛ gue da goꞌta yá ne, ne bi metuabi gue Ajua̱ xqui pønga ja ra fadi. Nepʉ nuꞌá̱ bi ꞌñembabiꞌʉ: ―Xiphʉ ra cu Cobo ne gatho maꞌra ya cu hanja bi za duá pønga ja ra fadi. Y nuꞌá̱ ꞌbestho bi ma de guehni pa ja maꞌna ra hnini. ");
INSERT INTO oteNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Y nurá hyaxꞌa̱ xi mi tu yá mʉi ya soldado y himi pa̱ te da beni, ngueꞌa̱ himi pa̱di te xqui nja co ra cu Pedro. ");
INSERT INTO oteNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nepʉ ra nda̱ Erode bi manda da yopa thoniꞌa̱, pe himbi za bi tsꞌʉdi. Hangue nura nda̱ Erode bi xʉcua ra uɛnda núꞌʉ ya nsufadi, nepʉ bi manda da thoꞌʉ. Nepʉ nuꞌá̱ bi bønga de guehni Judea, bi ma bá ꞌbʉ ja ra hnini Cesarea. ");
INSERT INTO oteNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ra nda̱ Erode xi mri ʉtsa ya me Tiro ne ya me Sidó. Pe nuya mengu de guehni bi go ꞌnara cohi pa da ma da cꞌa̱ꞌtsa ra Erode, pe ꞌmɛtꞌo bi guꞌtuabi ra Blasto núꞌa̱ mi supa rá hudi, pa núꞌá̱ da zofo ra Erode pa da za da ña̱uiꞌʉ, pa njabʉ da ba̱ntebi gue ya hinda ntuhniꞌa̱ con gueꞌʉ. Bi ꞌyøtꞌe njabʉ ngueꞌa̱ ra Erode mi ja rá nsu pa da umba nsɛqui ya me Sidó ne ya me Tiro da tsꞌocui te da ziꞌʉ ja yá hai. ");
INSERT INTO oteNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hangue ꞌnara pa ra Erode bi zohna ya me Tiro ne Sidó, y núꞌa̱ ra paꞌa̱ xqui nhye dega nda̱, bi hñudi ja ra hudi habʉ mi ja ra tsꞌʉtbi ne bi mʉdi bi zofoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nepʉ núꞌʉ ya ja̱ꞌi xqui muntsꞌni xi mi thø ya hmafi mi ena: ―¡Núni dí øhʉ ña̱, go ꞌnara zidada, hingrá ja̱ꞌi! ");
INSERT INTO oteNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nura oraꞌa̱ ꞌnará ɛnxɛ Ajua̱ bi japi bi hñenga ra Erode ngueꞌa̱ hinxqui umba rá nsu Ajua̱ pa da ña̱ njabʉ, ngueꞌa̱ nuꞌá̱ xqui gʉsɛ ra tsꞌɛdi. Hangue ra Erode bi zʉ ꞌnara tsꞌohñeni núꞌa̱ bi yʉ ꞌraya zuꞌue mbo rá mʉi, ne ꞌbestho bi du. ");
INSERT INTO oteNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ha nuya paꞌʉ bi ꞌño bi ntʉnga rá noya Ajua̱ habʉraza ya hnini. ");
INSERT INTO oteNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","De mi ua yá ꞌbɛfi ra cu Berhna co ra cu Saulo nuni Jerusale bi bøni pa bi menga Antioquía, ne bá ꞌñoui ra cu Xuua núꞌa̱ xqui thuꞌmbabi nehe ra Marco. ");
INSERT INTO oteNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mbi ꞌbʉ ja ra nija̱ nuni Antioquía ꞌrayá ꞌmɛhni Ajua̱ ne ꞌraya xahnate, ra cu Berhna ne ra cu Simu núꞌa̱ xqui thuꞌmbabi nehe ra Negro, ne ra cu Lucio núꞌa̱ mrá me Cirene, ne ra cu Saulo, ne ra cu Manaén núꞌa̱ bi teui mahyɛgui ra nda̱ Erode. ");
INSERT INTO oteNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ꞌNara pa xqui muntsꞌi mi xøcambeni Ajua̱ ne xqui ayuna. Nepʉ ra Ma̱ca Nda̱hi bi ꞌñembabiꞌʉ: ―ꞌUegaguihʉ ra Berhna ne ra Saulo pa da mɛ núꞌa̱ ra ꞌbɛfi stá umbi. ");
INSERT INTO oteNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nuꞌbʉ́ ya cu bi ayuna ne bi ꞌyapa Ajua̱ po ra cu Berhna ne ra cu Saulo, ne bi hñuꞌtsua yá ꞌyɛꞌʉ, nepʉ bi ꞌñehuiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nuꞌbʉ́ ra cu Berhna ne ra cu Saulo xqui mɛhna ra Ma̱ca Nda̱hi da mɛ rá ꞌbɛfi Ajua̱ ne bi zitsꞌi pa bi ma ja ra hnini Seleucia, ne de guehni bi ma co ra motsa bi ꞌraxa ja ra ndehe pa bi ma ja ꞌnara zi hai rá thuhu Chipre bí o madetho de ja ra ndehe. ");
INSERT INTO oteNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nu mi zønga de guehni ja ra hnini Salamina ja rá hyo ra ndehe bi mʉdi bi ma̱mba rá noya Ajua̱ mbo ja yá nija̱ yá mixodyoui. Ne mi ꞌñouiꞌʉ ra cu Xuua mi faste nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Y de ya xqui ꞌranga gatho maxøgue ra hai de Chipre bi zʉ maꞌna ra zi tꞌʉca hnini mrá thuhu Pafos ja rá hyo ra ndehe. Ne de guehni bi nthɛui ꞌnara xodyo mrá thuhu ra Barjesu mrá ꞌñete ne mi ꞌñetꞌa ba̱di de Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Núꞌá̱ nza̱ntho mri ꞌñoui ra nda̱ Sergio Paulo núꞌa̱ xi mrá nimfeni. Nepʉ núꞌa̱ ra nda̱ bi zohna ra cu Berhna ne ra cu Saulo ngueꞌa̱ mi ne da ꞌyøtua rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ne núꞌa̱ ra ꞌñeteꞌa̱ mi tꞌembi nehe ra Elima rí bøni da ꞌñena ꞌñete, núꞌá̱ bi nøꞌtua ra cu Berhna ne ra cu Saulo, ne mi ne da hña̱cuahma̱ ra nda̱ pa hinda gamfribi núꞌa̱ mi udiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nuꞌbʉ́ ra cu Saulo núꞌa̱ xa thuꞌmbi nehe ra Paulo, mi ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi ne xi bi nʉꞌta núꞌa̱ ra ꞌñete, ");
INSERT INTO oteNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ne bi ꞌñembabi: ―¡Nuꞌi ꞌnagrá ꞌyʉꞌtate ne ꞌnagrá cꞌuamba, rá tꞌʉꞌi ra tsꞌonda̱hi grí ʉtsa gatho núꞌa̱ xá hño! ¿Hanja xi guí tsꞌocua yá mfeni núꞌʉ ne da gamfri Ajua̱? ");
INSERT INTO oteNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nubyá Ajua̱ ma da castigaꞌi. Ma gui ngoda pa ndunthi ya pa, nixi da za gui hyanda ra hyadi. ꞌBestho ra oraꞌa̱ bi goꞌmba yá da ꞌnara ꞌbɛxuui, himbi za bi hyandi. Nepʉ mi honi toꞌo da gʉhni ngueꞌa̱ ya himi tsa da hyandi. ");
INSERT INTO oteNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nuꞌbʉ́ núꞌa̱ ra nda̱ nu mi hyanda núꞌa̱ bi nja, bi gamfri Ajua̱ ngueꞌa̱ xi bi ho núꞌa̱ bi ꞌyøde de ra Zidada. ");
INSERT INTO oteNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ra cu Pablo co núꞌʉ maꞌra mi ꞌñoui bi gʉ ra motsa de guehni Pafos pa bi ꞌraxa ja ra ndehe pa bi ma ja ra hnini Perge de ja ra hai Panfilia. Pe nura cu Xuua bi ꞌuegue de gueꞌʉ, bi menga pa Jerusale. ");
INSERT INTO oteNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nepʉ de guehni Perge bi gʉ yá ꞌñu bi maꞌʉ pa ja ra hnini Antioquía núꞌa̱ bí ja ja ra hai Pisidia, ne bi ꞌmʉhni ꞌraya pa. Ne núꞌa̱ ra pa dega tsaya bi yʉtꞌa ja yá nija̱ yá mixodyoui ne bi hñudiniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nepʉ de mi uadi bi theꞌta ra Ma̱ca Tꞌofo núꞌa̱ xa ꞌyofo ra Moise ne núꞌʉ xa ꞌyofo maꞌra yá ꞌmɛhni Ajua̱, nuꞌbʉ́ ya nda̱ de ra nija̱ bi zohna ra cu Pablo ne ra cu Berhna, ne bi ꞌñembabi: ―Zi cuhʉ, ꞌbʉ guí ne te gui xiphʉ ya ja̱ꞌi pa gui zofohʉ, da za gui xiphʉbya. ");
INSERT INTO oteNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nuꞌbʉ́ ra cu Pablo bi ꞌmai ne bi ꞌñu ra seña co rá ꞌyɛ pa hinto da ña̱ ne bi ꞌñembabi: ―Núꞌahʉ gyá me Israelhʉ, ne gathoꞌihʉ guí tsuhʉ Ajua̱, ꞌyøhʉ núna ma ga xiꞌahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nu Ajua̱ núꞌa̱ ri xøcambeni ma ja̱ꞌihʉ ya me Israel bi huahna núꞌʉ ndu ma dadahʉ pa bi ja̱piꞌʉ, ne bá nxa̱ndi nuni Egipto de mi ꞌbʉhni ngu myá nzøhøꞌʉ. Nepʉ Ajua̱ co rá da̱nga tsꞌɛdi bá pøniꞌʉ de núꞌa̱ ra haiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne bi zɛtua yá ntsꞌoꞌmʉi de guehni ja ra mbonthi ngu ñote njɛya. ");
INSERT INTO oteNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nepʉ Ajua̱ bi huata yoto ya hnini de nuni ja ra hai Canaán, pa go bi tꞌumba núꞌʉ ndu ma dadahʉ pa ja bi ꞌmʉhniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","De guehni Ajua̱ bi hñuxa ya nzaya pa bi mandaꞌʉ ngu goho nthebe made ya jɛya, asta bi ꞌmʉi ra ba̱di Samue pa bi sigui bi manda neheꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nepʉ nuꞌʉ́ bi ꞌyadi ꞌnayá nda̱ pa da nda̱ de gueꞌʉ. Y Ajua̱ bi umba ra Sau pa bi nda̱ ñote njɛya, núꞌa̱ mrá tꞌʉ ra Cis, mi gueꞌa̱ ꞌnara ꞌñøhø desde yá tꞌʉ ra Benjami. ");
INSERT INTO oteNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Y ꞌmɛfa Ajua̱ bi zica ra Sau dega nda̱, pa go bi hñuxa ra Davi. Ne bi ma̱ de gueꞌa̱ bi ꞌñena: “Nuni ra Davi rá tꞌʉ ra Isaí, guehni stá hopa rá ꞌmʉi, ne ma da ꞌyøtca gatho núꞌa̱ ma pahaga.” ");
INSERT INTO oteNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Y de ja yá tꞌʉ ra Davi bá ehe ra Jesu. Y núꞌa̱ ra Jesu go gueꞌa̱ xqui hñuxa Ajua̱ pa da pøhø ya ja̱ꞌi de Israel ngueꞌa̱ njabʉ xqui ña̱gui. ");
INSERT INTO oteNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ne ante da mʉta rá ꞌbɛfi ra Jesu, nura Xuua mi zofo gatho ya ja̱ꞌi de Israel gue da ñobri ne da nxistehe. ");
INSERT INTO oteNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ne de ya mi ma da ua rá ꞌbɛfi ra Xuua bi ꞌñena: “Nuga hingo gueque ngu guí beñhʉ gue go gueque núꞌa̱ xi guí tøꞌmhʉ. Pe ꞌmɛfa de gueque xa ꞌñepʉ maꞌna núꞌa̱ toꞌo maꞌna ja ndunthi rá nsu de gueque, núꞌa̱ hindí ꞌñepcagui nixi ga xoꞌtua yá thiza.” ");
INSERT INTO oteNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Zi cuhʉ, núꞌahʉ yá ja̱ꞌiꞌihʉ ra Abrá, ne núꞌahʉ guí tsuhʉ Ajua̱, pa gueꞌahʉ xpá ꞌbɛhni nuna ra noya pa gui mpøhøhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nuya me Jerusale ne yá nda̱ꞌʉ himi pa̱diꞌʉ toꞌo gueꞌa̱ ra Jesu, y nixi mi tso yá mfeniꞌʉ te ꞌbɛꞌa̱ mi ne da ma̱ núꞌʉ ya noya bi ꞌyofo mayaꞌbʉ yá ꞌmɛhni Ajua̱, masque mi heꞌtiꞌʉ núꞌa̱ ra pa dega tsaya. Hangue nuꞌʉ́ bi ꞌyɛꞌmbi pa da hyo pa bi njabʉ ngu núꞌa̱ xqui ma̱nga mayaꞌbʉ yá ꞌmɛhni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ne masque hinhyaꞌmʉ bi zʉtua ꞌnara tsꞌoqui xqui ꞌyøtꞌeꞌa̱ pa xa za xa hyohma̱, pe nuꞌʉ́ bi ꞌyapa ra Pilato pa da mandaꞌa̱ da tho. ");
INSERT INTO oteNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ne bi uadi bi ꞌyøꞌtuabiꞌʉ gatho ngu núꞌa̱ xqui ꞌyofo yá ꞌmɛhni Ajua̱ ja ra Ma̱ca Tꞌofo, nepʉ bi ja̱ꞌma de ja ra pontꞌi pa bá tꞌagui. ");
INSERT INTO oteNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pe nu Ajua̱ bi japi bi yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne núꞌʉ toꞌo xqui ꞌñoui de Galilea pa Jerusale, go gueꞌʉ bi hyandi ndunthi ya pa ꞌmɛfa de xqui yopa nte. Ne nubya go gueꞌʉ ri damajua̱ni de gueꞌa̱ ja ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Hangue nuje dí xiꞌahe ra hoga noya gue Ajua̱ ya bi ꞌyøtꞌe núꞌa̱ xqui ña̱ꞌtua ndu ma dadahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Y núꞌa̱ xqui ña̱ꞌtuabiꞌʉ go bi ꞌracjʉ nújʉ dyá ba̱tsihʉ de ndu ma dadahʉ, ngueꞌa̱ bi japi da yopa nte ra Zidada Jesu de ja ra du, ngu xa ntꞌofo ja rá ñoho ra Salmo ne ena njaua: “Nuꞌi go gueꞌe ma Tꞌʉꞌi, ne nubya ri hnequi ja yá thandi ya ja̱ꞌi gue go ri dadagui.” ");
INSERT INTO oteNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ajua̱ xqui ma̱ gue mi ma da japi da yopa nte de ra du, ne nurá ndoꞌyoꞌa̱ hinda ꞌya ja ra hai. Hangue bi ma̱nga njaua ja ra Ma̱ca Tꞌofo: “Ga ꞌraꞌahʉ gatho núꞌʉ ya ja̱pi stí ña̱ꞌtua ra Davi.” ");
INSERT INTO oteNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nehe ja maꞌna ra Salmo bi ꞌñenga njaua ra Davi: “Stá pa̱di gue nuꞌi hingui ma gui hopi da ꞌya ma ndoꞌyo ja ra hai, ngueꞌa̱ go ri hma̱ca ꞌbɛgogui.” ");
INSERT INTO oteNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Xi majua̱ni ra Davi bi ꞌyøꞌtua rá paha Ajua̱ de núꞌʉ ya pa bi nteꞌa̱ ne mi pɛpabi nuyá ja̱ꞌiꞌa̱. Nepʉ bi du ne bi tꞌagui, ha nurá ndoꞌyo bi ꞌya ja ra hai ngu gatho núꞌʉ maꞌra ndu ma dadahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pe nura Zidada Jesu himbi ꞌya rá ndoꞌyo ja ra hai, ngueꞌa̱ Ajua̱ bi japi bi yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Hangue zi cuhʉ, dá zo ri mfenihʉ núna dí xiꞌaꞌihʉ, gue por gueꞌa̱ da za gui tsʉhʉ ra pumbate de ri tsꞌoquihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nurá ley ra Moise himi tsa ja da tsꞌʉhni ra pumbate, pe nubyá gatho núꞌʉ toꞌo camfri ra Zidada Jesu, ya xra pumbabi yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hangue nubyá jamasuhʉ pa hinda zʉꞌahʉ núꞌa̱ xa ma̱nga yá ꞌmɛhni Ajua̱ ne bi ꞌñena njaua: ");
INSERT INTO oteNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Núꞌahʉ guí øtbuhlathohʉ, ꞌyøhʉ. Ma gui ꞌyøhʉ núꞌa̱ ma ga øtꞌe co ma tsꞌɛdi, pe ma gui ꞌmɛdihʉ. Ngueꞌa̱ núga drá Ajua̱ ma ga øtꞌa ꞌnara da̱nga tꞌøtꞌe de núꞌʉ ya pa gri ꞌbʉhʉ, pe nu sta siꞌahʉ, hingui ma gui camfrihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Y nu mi uadi bi ma̱nga njabʉ ra cu Pablo, bi bønga de ja yá nija̱ ya xodyo mahyɛgui co núꞌʉ mri ꞌñoui. Y mi ꞌbʉhni ꞌra himyá xodyo, ne bi ba̱ntebi ra cu Pablo da gohi pa maꞌna ra pa dega tsaya pa da yopa zofoꞌʉ maꞌnaꞌqui. ");
INSERT INTO oteNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ne mi ua ra hmuntsꞌi ja ra nija̱, ndunthi ya xodyo ne ndunthi maꞌra ya ja̱ꞌi núꞌʉ xqui dɛmba yá jamfri ya xodyo, bi gamfri núꞌa̱ bi xipabi ra cu Pablo ne ra cu Berhna, ne bi mɛui. Ne nuꞌʉ́ bi xipi gue mahyoni da zɛdi yá jamfri ne da sigui da ꞌmʉ ja rá hñoja̱ꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Y rá hña̱toꞌa̱ ra pa dega tsaya bi muntsꞌa maxøgue núꞌa̱ ra hniniꞌa̱ pa da ꞌyøtua rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pe nu mi hyanda ya xodyo gue xi mi ndunthi ya ja̱ꞌi, xi bi bø yá cuɛ ngueꞌa̱ mi ne da nsɛhɛꞌʉ, ne bi mʉdi bi ma̱ gue núꞌa̱ mi ma̱nga ra cu Pablo hinga majua̱ni, ne bi ña̱maꞌñʉꞌʉ de gueꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hangue nura cu Pablo ne ra cu Berhna mi ña̱ con gatho ra tsꞌɛdi ne bi ꞌñembi: ―Rá mʉdi dá xiꞌahe rá noya Ajua̱ núꞌahʉ gyá xodyohʉ ngueꞌa̱ mahyoni njabʉ. Pe hingá ne gá camfrihʉ, ne guí ma̱nsɛhʉ gue hindí ꞌñepꞌahʉ ra te pa nza̱ntho. Hangue nubyá ma ga zofohe núꞌʉ hingyá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ngueꞌa̱ njabʉ bi ꞌbɛpcahe Ajua̱ bi ꞌñenje: Stá huxꞌaꞌihʉ ngu ꞌnara ñotꞌi pa gui yoꞌtuahʉ yá mfeni gatho ya ja̱ꞌi, ne pa gui ma̱ñhʉ ra noya dega pøhøte habʉraza maxøgue de ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nu mi ꞌyøde njabʉ núꞌʉ himyá xodyo xi bi johya ne bi mʉdi bi ma̱ñꞌʉ gue rá noya Ajua̱ xá hño, ne bi gamfri gatho núꞌʉ xqui thahni pa da mɛꞌtsa ra te pa nza̱ntho. ");
INSERT INTO oteNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ne bi mʉdi bi hma̱mba rá noya Ajua̱ maxøgue ja núꞌa̱ ra haiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pe nuya xodyo bi ꞌñʉꞌtiui ya nda̱ de ra hnini co ya ꞌbɛhña̱ núꞌʉ xi ya ꞌyonija̱, pa da tꞌʉtsa ra cu Pablo ne ra cu Berhna, ne da juui de núꞌa̱ ra hniniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nuꞌbʉ́ ra cu Pablo ne ra cu Berhna bi hua̱tꞌa ra hai núꞌa̱ mi tu ja yá thiza, gueꞌa̱ ꞌnara seña gue ya hinda ma da ña̱ui ya ja̱ꞌi de guehni ne hinda ma da da̱di de gueꞌʉ ngueꞌa̱ nuꞌʉ́ himbi ne bi gamfri Ajua̱. Nepʉ nuꞌʉ́ bi ma pa ja ra hnini Iconio. ");
INSERT INTO oteNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pe nuya gamfri xqui gohini xi mi johyaꞌʉ ne mi ha̱mpa rá tsꞌɛdi ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ra cu Pablo ne ra cu Berhna bi zønga ja ra hnini Iconio, nepʉ bi yʉtꞌa ja yá nija̱ yá mixodyoui pa bi zofo ya ja̱ꞌi de rá noya Ajua̱ co ndunthi ra tsꞌɛdi. Ne ndunthi de gueꞌʉ bi gamfri, ngu ya xodyo ngu núꞌʉ himyá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pe núꞌʉ ya xodyo himbi ne bi gamfri bi ꞌyʉꞌta núꞌʉ himyá xodyo pa da benga ya tsꞌomfeni de núꞌʉ ya cu. ");
INSERT INTO oteNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Hangue ra cu Pablo co ra cu Berhna bi gohni ndunthi ya pa, ne himi tsu da ma̱mba rá noya Ajua̱ ngueꞌa̱ mi camfri gue Ajua̱ mi fatsꞌiꞌʉ. Ne nu Ajua̱ mi umbabiꞌʉ ra tsꞌɛdi pa da ꞌyøtꞌa ya ntꞌudi ne ya da̱nga tꞌøtꞌe de ja yá thandi ya ja̱ꞌi pa da gamfriꞌʉ gue núꞌa̱ mi ma̱ñꞌʉ go gueꞌa̱ majua̱ni. ");
INSERT INTO oteNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pe nuya mengu de guehni xqui hyegue, ꞌra mri dɛna ya xodyo ha nu maꞌra mri dɛna ya apostol. ");
INSERT INTO oteNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nepʉ ꞌraya xodyo ne ꞌra de núꞌʉ himyá xodyo bi ꞌñʉꞌtiꞌʉ co ya nda̱ de ra hnini pa da ꞌyøꞌtua ra ntsꞌoꞌmʉi ya apostol ne da cꞌahni co ya do. ");
INSERT INTO oteNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pe nura cu Pablo ne ra cu Berhna bi ꞌyøde de núꞌa̱ mi ma da tꞌøꞌtuaꞌʉ, hangue bi ꞌbatꞌi ne bi ma pa ja ra hnini Listra ne Derbe, ya hnini de ja ra hai Licaonia. Ne bi thexa ja gatho núꞌa̱ ra haiꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ne ja mi ma̱mbani rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nuni ja ra hnini Listra mi ꞌbʉ ꞌnara ꞌñøhø himi tsa da ꞌño ngueꞌa̱ desde mi ꞌmʉi ya mi njabʉ, ne hinhyaꞌmʉ xqui ꞌño, ha mi huhnitho. ");
INSERT INTO oteNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nura ꞌñøhøꞌa̱ bi ꞌyøde núꞌa̱ mi ma̱nga ra cu Pablo. Nepʉ ra cu Pablo bi nʉꞌti ne bi ba̱di gue mi ja rá jamfri pa da ña̱ni. ");
INSERT INTO oteNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Hangue nura cu Pablo bi ꞌñembabi ntsꞌɛdi: ―ꞌBai manjua̱ntho. Y nura ꞌñøhøꞌa̱ ꞌbestho ra oraꞌa̱ bi ꞌyɛnga ra sagui bi ꞌmai ne bi ꞌño. ");
INSERT INTO oteNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nepʉ ndunthi ya ja̱ꞌi de guehni bi hyanda núꞌa̱ xqui ꞌyøtꞌa ra cu Pablo, ne bi ma̱nga ntsꞌɛdi de yá hña̱qui de Licaonia bi ꞌñena: ―¡Ma ajua̱hʉ xa mpʉnga ja̱ꞌi ne xuá ꞌñehe pa ja ra ximhai, xiyʉ ꞌbahni! ");
INSERT INTO oteNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Hangue ra cu Berhna bi tꞌembabi gue go mi gueꞌa̱ ra zidada Jupite, ha nura cu Pablo ra zidada Mercurio ngueꞌa̱ núꞌá̱ go gueꞌa̱ mi ña̱ꞌa̱. Ngueꞌa̱ mi gueꞌʉ yá thuhu yá ajua̱ ya me Licaonia. ");
INSERT INTO oteNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nepʉ nura macja̱ bá tsi ya nda̱mfri ne bá ha̱ ya thødri pa ja rá nija̱ ra Jupite núꞌa̱ mi ja ja ra gosthi hnini, ne ja bi muntsꞌini co ndunthi ya ja̱ꞌi pa da nsundaꞌʉ ya apostol, ne mi ne da hyopa ya nda̱mfri dega hña̱ꞌti. ");
INSERT INTO oteNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pe nu mi ba̱di njabʉ ya apostol bi dʉnga yá dutu co ra dumʉi ngueꞌa̱ hingo rí ꞌñepi da tꞌøꞌtuabiꞌʉ njabʉ. Ne bi yʉtꞌa ja ra hmuntsja̱ꞌi ne bi ꞌñena njaua: ");
INSERT INTO oteNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¿Hanja guí øthʉ njabʉ? Nuje dyá ja̱ꞌihe nguꞌahʉ. Nuje stá ehehe pa ga xiꞌahe gue nuya cꞌoi grí nsundahʉ hinte ri muui, hangue mahyoni gui ꞌueguehʉ de gueꞌʉ pa gui pɛphʉ Ajua̱ núꞌa̱ te, núꞌa̱ bi hyoca mahetsꞌi ne ra ximhai ne gatho núꞌa̱ te ja. ");
INSERT INTO oteNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mayaꞌbʉ nuꞌá̱ mi hopta ya ja̱ꞌi da ꞌyøtꞌa gatho núꞌa̱ go mi beniꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pe nza̱ntho xa ꞌñutuabiꞌʉ tengu rá ꞌmʉiꞌa̱ ngueꞌa̱ xa ꞌyøꞌtuabi ya hño, ngueꞌa̱ go gueꞌa̱ pɛhna ra ꞌye ne ya hoga sofo, ne ꞌracjʉ te ga tsihʉ, ne hubga ma mʉihʉ pa ga johyahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pe masque ra cu Pablo ne ra cu Berhna bi xipa ya ja̱ꞌi njabʉ pa hinda hyopa ya nda̱mfri núꞌa̱ ma xa tꞌumbiꞌʉ dega hña̱ꞌti, pe xmá hñei pa da hña̱cuabiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ra oraꞌa̱ bi zøhø ꞌraya xodyo xqui ꞌñehe de ra hnini Antioquía ne Iconio. Núꞌʉ́ bi ꞌyʉꞌta ya ja̱ꞌi pa bi cꞌahna ra cu Pablo co ya do. Nepʉ bi gʉtꞌiꞌʉ bi pønga de ja ra hnini pa bá føte ngueꞌa̱ mi hu yá mʉiꞌʉ gue ya xqui du. ");
INSERT INTO oteNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Y nu de ya xqui muntsꞌa ya gamfri habʉ mi ꞌbɛnga ra cu Pablo, núꞌa̱ ra oraꞌa̱ bi ꞌmai ne bi yopa yʉtꞌa ja ra hnini. Nepʉ rá hyaxꞌa̱ bi mɛui ra cu Berhna pa ja ra hnini Derbe. ");
INSERT INTO oteNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ne ja bá ma̱mbaniꞌʉ rá noya Ajua̱ nehe, ne ndunthi ya mengu de guehni bi gamfri. Nepʉ bi mengui pa bi ma Listra, ne bi ꞌranga Iconio, nepʉ bi ma Antioquía. ");
INSERT INTO oteNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","De núꞌʉ ya hniniꞌʉ bi japi da zɛdi yá jamfri núꞌʉ ya gamfri mi ꞌbʉhni, bi xipi gue hinda ꞌuegue de yá jamfri, ne bi xipi gue mahyoni da zɛta ya ntꞌʉtsate ne ya tsꞌothogui pa da hyandua rá nsunda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ne bi thahna ꞌraya cu pa da nda̱ cada ꞌnara nija̱ de nuya ya hnini habʉ xqui ꞌrani. Nepʉ bi ꞌyapabi Ajua̱ ne bi ayuna, ne núꞌʉ toꞌo xqui thahni pa da nda̱ bi ꞌyɛntꞌua ja yá ꞌyɛ Ajua̱ núꞌa̱ toꞌo xqui gamfriꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nepʉ bi thogui bi ma ja ra hai Pisidia ne bi zøñꞌʉ ja ra hai Pamfilia. ");
INSERT INTO oteNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nepʉ nuꞌʉ́ bi ma̱mba rá noya Ajua̱ ja ra hnini Perge, nepʉ de guehni bi maꞌʉ ja ra hnini Atalia. ");
INSERT INTO oteNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ne de guehni bi gʉꞌʉ ra motsa pa bi ꞌraxa ja ra ndehe pa bi menga Antioquía nuni habʉ xqui tꞌɛntꞌua yá ꞌyɛ Ajua̱ pa bi mɛ núꞌa̱ ra ꞌbɛfi xqui tꞌumbiꞌʉ ne ya bi uadi. ");
INSERT INTO oteNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ne nu mi zøni bi muntsꞌa mahyɛgui con gatho ya gamfri ne bi xipabiꞌʉ gatho núꞌa̱ xqui ꞌyøtꞌe co rá tsꞌɛdi Ajua̱. Ne bi xipi gue Ajua̱ bi matsꞌi pa bi zofo nehe núꞌʉ himyá xodyo, ne bi xocua yá mfeniꞌʉ pa bi za bi gamfriꞌʉ ra Zidada Jesu nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nepʉ ra cu Pablo ne ra cu Berhna bi ꞌmʉhni ndunthi ya pa co ya gamfri de guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","De núꞌʉ ya paꞌʉ ꞌraya cu xqui ꞌñehe de ra hai Judea pa ja ra hnini Antioquía bi mʉdi bi xipa gatho ya cu gue pa da mpøhøꞌʉ mahyoni da thuꞌtsua núꞌa̱ ra seña xqui ma̱nga ra Moise da thuꞌtsua gatho ya xodyo núꞌʉ dya ꞌñøhø. ");
INSERT INTO oteNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nuꞌbʉ́ ra cu Pablo ne ra cu Berhna bi ntsanoyauiꞌʉ ndunthi. Hangue bi thahna ra cu Pablo ne ra cu Berhna ne maꞌra ya cu pa da ma pa Jerusale da cꞌa̱ꞌtsa ya apostol ne ya nda̱ de ra nija̱ de guehni, pa da ña̱uiꞌʉ de núꞌa̱ ra señaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nepʉ ya gamfri de ra nija̱ Antioquía bi ꞌñehui núꞌʉ ya cu. Ne dega ꞌñu bi ꞌranga ja ra hai Fenicia ne Nsamaria, ne bi xipa ya cu gue núꞌʉ himyá xodyo ya xqui hyɛpʉ yá nda̱xjua jamfri ne ya xqui gamfribi rá noya Ajua̱ nehe. Nuꞌbʉ́ gatho ya cu xi mri johya ndunthi. ");
INSERT INTO oteNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ne nu mi zønga Jerusale, nuya apostol de guehni ne ya nda̱ de ra nija̱ co maꞌra ya cu mi ꞌbʉhni bi umbaꞌʉ ꞌnara hoga ꞌñehe. Ne ra apostol Pablo ne núꞌʉ toꞌo mi ꞌñoui bi xipabiꞌʉ gatho núꞌa̱ xqui ꞌyøtꞌe co rá mfatsꞌi Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pe ꞌraya fariseo mi ꞌbʉhni núꞌʉ ya xqui gamfri, bi ꞌmai ne bi ꞌñena: ―Mahyoni da thuꞌtsua núꞌa̱ ra seña gatho ya gamfri masque hingyá xodyo, ne dra ꞌbɛpabi da ꞌyøtꞌa gatho núꞌa̱ ma̱nga rá ley ra Moise. ");
INSERT INTO oteNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nepʉ ya apostol ne ya nda̱ de ra nija̱ bi muntsꞌiꞌʉ pa da ña̱ꞌʉ de rá ley ra Moise ne de núꞌa̱ ra seña, ua mahyoni da tꞌøtꞌe pa da mpøhø ꞌna. ");
INSERT INTO oteNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nepʉ de ya xqui ña̱ꞌʉ ndunthi, ra apostol Pedro bi ꞌmai ne bi ꞌñena: ―Zi cuhʉ, ngu guí pa̱sɛhʉ ya øtꞌa ndunthi ya pa Ajua̱ bi huancagui pa dá umba ra hoga ntꞌøde de ra mpøhø núꞌʉ hingyá xodyo pa bi gamfriꞌʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ne Ajua̱ núꞌa̱ toꞌo pa̱tca gatho ma mfenihʉ bi ꞌñudi gue mi ja yá jamfriꞌʉ, ngueꞌa̱ bi umba ra Ma̱ca Nda̱hiꞌʉ njabʉ ngu bi ꞌracjʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Njabʉ stá pa̱hʉ gue Ajua̱ handgaguihʉ gue dí mahyɛguihʉ con gueꞌʉ, ngueꞌa̱ nuꞌá̱ bi xʉcua yá mfeni ngueꞌa̱ bi gamfribi rá noyaꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nuꞌbʉ́ ¿hanja hinguí ne gui camfrihʉ núꞌa̱ xa ꞌyøtꞌa Ajua̱? ¿Hanja guí japhʉ ya cu da ꞌyøtꞌa núna himbi za dá øthʉ, ne nixi ndu ma dadahʉ himbi za bi ꞌyøtꞌe? ");
INSERT INTO oteNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Hingui tsa ga øthʉ njabʉ. Nujʉ́ dí camfrihʉ gue stá mpøhøhʉ po rá hñoja̱ꞌi ra Zidada Jesucristo, y njabʉ xa mpøhøꞌʉ nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nepʉ mi uadi bi ma̱nga ra cu Pedro njabʉ, bi goꞌta yá ne gatho pa da ꞌyøde núꞌa̱ mi ma̱ ra cu Berhna ne ra cu Pablo. Nuꞌʉ́ bi ma̱ de gatho ya ntꞌudi ne ya da̱nga tꞌøtꞌe xqui ꞌyøꞌtuabi Ajua̱ núꞌʉ himyá xodyo por gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Y de mi uadi bi ña̱ꞌʉ bi ꞌñenga ra cu Cobo: ―Zi cuhʉ, ꞌyøhʉ núꞌa̱ ma ga ma̱ngá. ");
INSERT INTO oteNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ra cu Pedro ya bi xicjʉ hanja Ajua̱ xqui mʉdi xqui ja̱pa núꞌʉ hingyá xodyo ne go xqui huahna ꞌra de gueꞌʉ pa neheꞌʉ drá hniniꞌa̱. ");
INSERT INTO oteNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Hangue bi njabʉ ngu núꞌa̱ xqui ꞌyofo ꞌnará ꞌmɛhni Ajua̱ ne bi ꞌñena: ");
INSERT INTO oteNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ꞌMɛfa de guehna ma ga japi da yopa nja rá hmanda ra nda̱ Davi masque ya xa du, ne masque ya xa nhuati ma da yopa nja ngu rá mʉdi. ");
INSERT INTO oteNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Pa njabʉ gatho maꞌra ya hnini da hyongagui, ne gathoꞌʉ da xøcambenigui ma thuhu. ");
INSERT INTO oteNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Njabʉ bi ꞌñena Ajua̱ núꞌa̱ toꞌo xa ꞌyøtꞌa nuya ya tꞌøtꞌe núꞌʉ bi ꞌñudi mayaꞌbʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Hangue ringueꞌa̱ nuga dí beni gue hindí ꞌñepi ga xaxhʉ núꞌʉ hingyá xodyo núꞌʉ xa hyɛpʉ yá nda̱xjua jamfri ne xa gamfri Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Hønsɛ mahyoni ga opabihʉ pa ga ha̱cuahʉ hinda zipa yá ngø ya mboꞌoni núꞌʉ xa hña̱ꞌtua ya cꞌoi. Nehe ga ophʉ gue hinda hñuxui ꞌnara ꞌbɛhña̱ núꞌa̱ hingue xi rá ꞌbɛhña̱, ne hinda zipa yá ngø núꞌʉ ya mboꞌoni hinxra ꞌbømba yá ji. Nehe ga xiphʉ gue hingui ho da zipa yá ji ya mboꞌoni. ");
INSERT INTO oteNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nuga dí beni ga xiphʉ njabʉ ngueꞌa̱ desde yaꞌbʉ ꞌbʉi toꞌo heꞌtuabi rá ley ra Moise tatꞌa pa dega tsaya ja gatho ya hnini. ");
INSERT INTO oteNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hangue nuya apostol ne núꞌʉ ya nda̱ de ra nija̱ ne gatho ya gamfri bi beñꞌʉ gue xá hño da huahna ꞌraya cu pa da mɛhna Antioquía co ra cu Pablo ne ra cu Berhna. Ne bri thahna yoho ya da̱nga cu, ra cu Juda núꞌa̱ xqui thuꞌmbabi nehe ra Barsabá, ne ra cu Sila. ");
INSERT INTO oteNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ne bi umbabiꞌʉ ꞌnara hɛꞌmi pa da hña̱ꞌtsua ya cu nuni Antioquía habʉ mi ena: “Núje dyá apostolhe ne núje dyá nda̱he de ra nija̱, ne gatho ya cu de guecua Jerusale, dí pɛnꞌahebʉ ra nzɛngua núꞌahʉ ma cuꞌihe hingyá xodyohʉ guí ꞌbʉhʉbʉ Antioquía, ne núꞌahʉ guí ꞌbʉhʉbʉ ja ra hai Siria ne Cilicia. ");
INSERT INTO oteNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Stá pa̱he gue ꞌraya cu de guecua xa ma xqui mabʉ nsinque ma nsɛquihe, ne xpá xaxꞌahʉ, y co núꞌʉ yá noya xa xiꞌahʉꞌʉ xa tsꞌocꞌa ri mfenihʉ. Xa xiꞌahʉ gue mahyoni gui ꞌyøthʉ núꞌa̱ ra seña xqui ma̱nga ra Moise, ne mahyoni gui ꞌyøthʉ gatho núꞌa̱ bi ma̱ñꞌa̱ ja ra ley. ");
INSERT INTO oteNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hangue nuje dá beñhe xá hño ga huañhe ꞌraya cu de guecje pa ga pɛñhebʉ da ma da cꞌa̱ꞌtsꞌahʉ pa da mɛui mahyɛgui ma zi cuhʉ ra Berhna ne ra Pablo. ");
INSERT INTO oteNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nuyʉ ri yoho xa hñuxa yá te pa da ma̱mba rá noya ma zi Hmuhʉ ra Jesucristo. ");
INSERT INTO oteNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Hangue stá pɛnꞌahebʉ ra cu Juda ne ra cu Sila, y núꞌʉ́ go ma da xiꞌasɛhʉ nehe núna dí xiꞌahe. ");
INSERT INTO oteNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ra Ma̱ca Nda̱hi, necaguihe stá beñhe gue xá hño hinga ꞌbɛpꞌahe ndunthi ya hmanda, hønsɛ ga ꞌbɛpꞌahe gui ꞌyøthʉ núꞌa̱ xi mahyoni. ");
INSERT INTO oteNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Hangue oxqui ma gui tsiphʉ yá ngø ya mboꞌoni núꞌʉ xa hña̱ꞌtua ya cꞌoi, ne oxqui ma gui tsiphʉ yá ji ya mboꞌoni, ne oxqui ma gui tsiphʉ yá ngø ya mboꞌoni núꞌʉ hinxra ꞌbømba yá ji, nixi gui hñuxhʉ ꞌnara ꞌbɛhña̱ núꞌa̱ hingue xi ri ꞌbɛhña̱hʉ. ꞌBʉ gui jamasuhʉ hingui øthʉ nuya tꞌøtꞌe dí xiꞌahʉ, nuꞌbʉ́ gui ꞌbʉhʉ xá hño. Nsøctꞌa̱ ndí ne ga xiꞌahe. Nubyá Ajua̱ da maxꞌahʉ.” ");
INSERT INTO oteNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nepʉ núꞌʉ toꞌo xqui ꞌbɛhni bi ma pa Antioquía. Ne mi zøñꞌʉ bi muntsꞌa gatho ya gamfri ne nuꞌʉ́ bri dapabi ra hɛꞌmi. ");
INSERT INTO oteNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Y nu mi uadi bi hñeꞌtiꞌʉ, xi bi johya co núꞌa̱ ra da̱nga humʉi xqui ꞌbɛmpabi. ");
INSERT INTO oteNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ra cu Juda ne ra cu Sila myá ꞌmɛhni Ajua̱ nehe, ne mi ña̱ꞌʉ co rá tsꞌɛdiꞌa̱, hangue bi zofo ya cu ne bi nupa yá mfeniꞌʉ pa da zɛ yá jamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ne bi gohni ndunthi ya pa con gueꞌʉ. Nepʉ ꞌmɛfa ya cu me Antioquía bi ꞌñedi co ꞌnara hma̱te pa da menjhma̱ pa Jerusale habʉ xqui ꞌbɛhni. ");
INSERT INTO oteNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pe nura cu Sila bi beni gue ja da gohniꞌa̱ nuni Antioquía. ");
INSERT INTO oteNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nehe ra cu Pablo ne ra cu Berhna ja bi gohni neheꞌʉ, ne mi udi ra hoga ntꞌøde de rá noya Ajua̱ co maꞌra ya cu de guehni mi mfaxꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nepʉ xqui tho ꞌraya pa, ra cu Pablo bi ꞌñembabi ra cu Berhna: ―Maha maꞌnaꞌqui, ma ga cꞌa̱ꞌtshʉ ya cu gatho núꞌʉ ya hnini habʉ dá ma̱mfʉ rá noya Ajua̱ pa ga nuhʉ te gra maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ra cu Berhna mi nehma̱ xa zixa ra cu Xuua núꞌa̱ xqui thuꞌmbabi ra Marco nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pe ra cu Pablo bi ꞌñena gue hinxá hño da zitsꞌiꞌa̱ ngueꞌa̱ ꞌnara pa mri ꞌñoui bi ꞌueguesɛ de guehni Panfilia, ne ya himbi ne bi mɛuiꞌʉ da ma̱mba rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Y por gueꞌa̱ ra cu Pablo ne ra cu Berhna bi ntsanoyaꞌʉ, nepʉ bi beni gue maꞌna xá hño da ma ꞌra ꞌnambʉ. Hangue nura cu Berhna bi zixa ra cu Marco, ne bi mɛui ja ra motsa bi ꞌraxa ja ra ndehe pa bi ma Chipre. ");
INSERT INTO oteNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ha nura cu Pablo bi huahna ra cu Sila pa da mɛui. Ne nuya cu de guehni Antioquía bi ꞌyɛntꞌuabiꞌʉ ja yá ꞌyɛ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nepʉ bi gʉ yá ꞌñu bi maꞌʉ pa ja ra hai Siria ne bi ꞌranga Cilicia, ne mi nupa yá mfeni ya cu mbi ꞌbʉi de guehni pa da zɛdi yá jamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","De mi zønga ra cu Pablo co ra cu Sila ja ra hnini Derbe, de guehni bi thogui pa rí ma Listra, y ja bi nthɛuini ꞌnara gamfri rá thuhu ra Timoteo, nurá na̱na̱ mrá xodyo ne mrá gamfriꞌa̱, y nurá dada mrá me Grecia. ");
INSERT INTO oteNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ha nuya cu mbi ꞌbʉ Listra ne Iconio mi ña̱ xá hño de ra cu Timoteo. ");
INSERT INTO oteNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ha nura cu Pablo mi ne da zitsꞌi pa da mɛuiꞌa̱. Pe ꞌmɛtꞌo bi japi da thuꞌtsua núꞌa̱ ra seña ma̱nga rá ley ra Moise, pa hinda bø yá cuɛ núꞌʉ ya xodyo mi ꞌbʉhni, ngueꞌa̱ gathoꞌʉ mi pa̱di gue mrá me Grecia rá dada. ");
INSERT INTO oteNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nepʉ nuꞌʉ́ bi ma de guehni bi thogui pa ja maꞌra ya hnini, ne mi xipa ya cu núꞌʉ ya noya xqui mɛhna ya apostol ne ya nda̱ de ra nija̱ nuni Jerusale pa da ꞌyøtꞌeꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ne njabʉ maꞌna bi te yá jamfri gatho núꞌʉ ya gamfri de núꞌʉ ya hnini habʉ xqui ꞌrañꞌʉ. Ne hyastho mi ꞌyo mi camfri maꞌra ya ja̱ꞌi de rá noya Ajua̱, ne mi muntsꞌini maꞌra ya cu. ");
INSERT INTO oteNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","De guehni bi thoguiꞌʉ pa bi ma ja ra hai Frigia ne Galacia, ngueꞌa̱ ra Ma̱ca Nda̱hi himbi hopabi da thogui ja ra hai Asia pa da ma̱mba rá noya Ajua̱ de guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ne bi thoguiꞌʉ pa bi ma ja ra hai Misia, ne mi ne xa mahma̱ꞌʉ pa ja ra hai Bitinia, pe rá Ma̱ca Nda̱hi ra Jesu himbi hopi da maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hangue bi thoguitho de guehni Misia pa bi ma ja ra hnini Ntroa. ");
INSERT INTO oteNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ne mi nxuui ra cu Pablo bi hyanda ꞌnara ntꞌudi ngu dega tꞌi. Bi hyanda ꞌnara ꞌñøhø mrá me Macedonia, mi ꞌbahni ne bi ꞌñembabi: “Thogui pa Macedonia pa grí faxcaheni.” ");
INSERT INTO oteNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ne nu mi hyanda njabʉ ra cu Pablo núꞌa̱ ra ntꞌudiꞌa̱ ngu dega tꞌi, ꞌbestho dá hñocje pa dá mahe ja ra hai Macedonia, núga drá Luca ne ra cu Pablo ne núꞌʉ maꞌra ya cu. Dá pa̱he gue Ajua̱ mi pɛncahe pa ma grá ma̱ñheni ra hoga ntꞌøde de ra mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hangue dá pøñhe de guehni Ntroa dá jʉhe ra motsa pa dá ꞌraxhe ja ra ndehe. Ne dá mahe manjua̱ntho ja ra zi tꞌʉca hai rá thuhu Samotracia o madetho ra ndehe. Nepʉ rá hyaxꞌa̱ dá tsøñhe ja ra hnini Neapoli de ra hai Macedonia. ");
INSERT INTO oteNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De guehni dá mahe pa Filipo gueꞌa̱ ꞌnará hnini ya me Nroma, ne gueꞌa̱ ꞌnara da̱nga hnini de ra hai Macedonia. Y ja dá ꞌbʉheni ꞌraya pa. ");
INSERT INTO oteNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ha ra pa dega tsaya dá pøñhe de ra hnini ne dá mahe ja ra da̱the habʉ xqui nza̱i ya ja̱ꞌi da ma dua apabi Ajua̱. Ne ja dá huheni habʉ xqui muntsꞌa ꞌraya ꞌbɛhña̱, ne dá fʉhe dá xiphe de rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ne ꞌna de gueꞌʉ mrá thuhu ra Lidia mrá me Tiatira, mi pa ya hoga dutu xqui ja̱tꞌi dega murado, ne mi xøcambeni Ajua̱. Bi ꞌyøde núꞌa̱ mi ma̱nga ra cu Pablo, y Ajua̱ bi xocua rá mfeni pa bi gamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ne bi nxisteheꞌa̱ con gatho ya mengu rá ngu. Nepʉ bi ba̱nteguihe bi ꞌñenje: ―ꞌBʉ nuꞌahʉ guí hanthʉ gue xi majua̱ni drá gamfri de ra Zidada Jesu, maha pa ja ra ngu ga ꞌbʉhʉni. Ne bi jacje dá ꞌbʉheni ꞌraya pa. ");
INSERT INTO oteNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ne ꞌnara pa ndrá mahe habʉ nza̱ntho mi tꞌapabi Ajua̱, de má ꞌñu dá nthɛhe ꞌnara nxutsi mrá ꞌbɛgo ne mi pɛꞌtsa ꞌnara tsꞌonda̱hi núꞌa̱ mi japi da xipabi te ma suerte mi pɛꞌtsa cada ꞌnara ja̱ꞌi, y nuyá hmuꞌa̱ mi ta̱ha̱ ndunthi ra boja̱ po núꞌa̱ ra ꞌbɛfi mi pɛfiꞌa̱ ngueꞌa̱ nura nxutsiꞌa̱ mrá ba̱di. ");
INSERT INTO oteNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nepʉ nuꞌá̱ bi dɛngahe ne bi ña̱ ntsꞌɛdi bi ꞌñena: ―Nuyʉ ya da̱meyʉ go guehyʉ yá ꞌbɛgo Ajua̱ de mahetsꞌi, ne utua ya ja̱ꞌi hanja da za da mpøhø. ");
INSERT INTO oteNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ndunthi ya pa bi dɛngahe ne nza̱ntho mi ma̱nga njabʉ. Pe ra cu Pablo ya himi ne da ꞌyøde da ma̱nga njabʉ. Hangue bi mpʉntsꞌi ne bi zofo núꞌa̱ ra tsꞌonda̱hi mi pɛꞌtsa núꞌa̱ ra nxutsi ne bi ꞌñembi: ―De rá thuhu ra Zidada Jesucristo dí ꞌbɛpꞌaꞌi gui pøni de gue nuna nxutsina̱. Y nura oraꞌa̱ ꞌbestho bi bønga ra tsꞌonda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ha nu mi hyanda yá hmu gue ya himi tsa da da̱ha̱ ra boja̱ co rá ꞌbɛfi núꞌa̱ ra nxutsi, bi bø yá cuɛ ne bi gʉ ra cu Pablo ne ra cu Sila pa bi ziꞌtsua ya nda̱ ja ra tai. ");
INSERT INTO oteNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ne bi ziꞌtsua ya nzaya ne bi ꞌñembabi: ―Nuya ya ꞌñøhø go ya xodyo, ne hønsɛ rí ꞌñehe pa da japi da nxaxni ma hninihʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ne udi yá nza̱i núꞌʉ hindí ꞌñepi ga øthʉ ngueꞌa̱ dyá me Nromahʉ y dí ohʉ ja yá ꞌyɛ ma nda̱hʉ me Nroma. ");
INSERT INTO oteNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nuꞌbʉ́ núꞌʉ ya ja̱ꞌi xqui muntsꞌini bi bø yá cuɛ con gueꞌʉ, nepʉ ya nda̱ bi manda da ꞌbøcua yá dutu ne dra fɛtꞌi co ya tsꞌʉtꞌo. ");
INSERT INTO oteNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Y mi uadi bi hnaꞌmbabi ntsꞌɛdi, bi jotꞌa fadi ne bi sipa ra nsufadi gue da su xá hño. ");
INSERT INTO oteNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Y mi ꞌyøde njabʉ ra nsufadi, bi cʉꞌta asta xi ra tsꞌa̱tꞌa fadi, ne bi zɛꞌmba yá ua ja ꞌnara da̱nga za habʉ hingui tsa da xocsɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pe ngu made ra xuui ra cu Pablo ne ra cu Sila mi apabi Ajua̱ ne mi tutuabi ya ja̱hña̱ Ajua̱, ne gatho maꞌra ya ꞌyofadi mi ødeꞌʉ, ");
INSERT INTO oteNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","mi da̱mfri bi nja ꞌnara da̱nga mbimhai, asta mi ꞌña̱nga yá ua ya ja̱do de ra fadi, ne asta bi xogui gatho ya gosthi fadi, ne bi xotꞌa gatho ya cadena núꞌʉ mi tha̱tꞌa ya ꞌyofadi. ");
INSERT INTO oteNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ha nura nsufadi bi nuhu bi hyanda ya gosthi fadi gatho mi xogui, hangue bi gʉca rá mahuai pa xa hñosɛhma̱ꞌa̱, ngueꞌa̱ mi hu rá mʉi gue ya xqui ꞌbatꞌa gatho ya ꞌyofadi. ");
INSERT INTO oteNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pe nura cu Pablo bi maꞌti ne bi ꞌñembi: ―Oxqui ma gui hñosɛ. Nuje dí ꞌbʉheua gatho. ");
INSERT INTO oteNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nepʉ nura nsufadi bi ꞌyadi ꞌnara ñotꞌi, ne bi yʉtꞌi hnestꞌihi asta mri hua̱tꞌi co ra ntsu, ne bá ndandiña̱hmu ja yá ua ra cu Pablo ne ra cu Sila. ");
INSERT INTO oteNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nepʉ ꞌbestho bi pøni pa thi ne bi ꞌyambabiꞌʉ bi ꞌñembi: ―ꞌÑøhøhʉ, ¿te rá ꞌbɛ ga øtꞌe pa ga mpøhø? ");
INSERT INTO oteNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nuꞌbʉ́ nuꞌʉ́ bi ꞌñembi: ―Camfri ra Zidada Jesucristo pa njabʉ gui mpøhø nuꞌi ne gatho ya mengu ri ngu. ");
INSERT INTO oteNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nepʉ ra cu Pablo ne ra cu Sila bi xipa rá noya Ajua̱ núꞌa̱ ra nsufadi ne gatho ya mengu rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Y mi nxuuitho ra nsufadi bi xʉcuabiꞌʉ habʉ xqui tꞌumba ya mfɛi. Nepʉ nuꞌá̱ bi nxistehe ꞌbestho ne gatho ya mengu rá ngu. ");
INSERT INTO oteNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ne bi zixa pa ja rá ngu ne bá umbi te bi ziꞌʉ. Y núꞌa̱ ra nsufadi ne núꞌʉ ya mengu rá ngu xi mri johya ngueꞌa̱ xqui gamfriꞌʉ Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nurá hyaxꞌa̱ ya nda̱ bi mɛhna ya polecia da xipa ra nsufadi gue da hyɛgui ra cu Sila ne ra cu Pablo. ");
INSERT INTO oteNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Hangue ra nsufadi bi ꞌñembabi ra cu Pablo: ―Xuá mɛnca ra noya ya nda̱ ga hɛcꞌahʉ. Hangue da za gui pøñhʉ ne gui maha te rá entho. ");
INSERT INTO oteNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pe ra cu Pablo bi zofo núꞌʉ to bá ha̱ ra noya pa da thɛguiꞌʉ, ne bi ꞌñembi: ―Hina, ngueꞌa̱ nuje dyá me Nromahe nehe y dí ohe ja yá ꞌyɛ ma da̱nga nda̱hʉ me Nroma, ne bri fɛtcꞌahe ja yá thandi ya ja̱ꞌi nsinque bi tꞌangahe ꞌnara ntꞌani, ne bi jotcaguihe ja ra fadi. Ha nubyá go ne da hyɛgaguihe nsinque to da ba̱di. Hinda za. Duá esɛꞌʉ pa da pøngaguihe de guecua. ");
INSERT INTO oteNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nuꞌbʉ́ ya polecia bi ma bá xipa njabʉ ya nda̱. Nuꞌbʉ́ nuꞌʉ́ bi ntsu nu mi ba̱di gue myá me Nroma ne mi o ja yá ꞌyɛ ra da̱nga nda̱ Nroma. ");
INSERT INTO oteNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Hangue nuꞌʉ́ bi ma bá apa ra pumbate ra cu Pablo ne ra cu Sila, bi pøni de ra fadi ne bi ba̱ntebi da bøniꞌʉ de ja ra hnini. ");
INSERT INTO oteNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ha nu mi bønga fadiꞌʉ bi ma ja rá ngu ra nju Lidia. Ne bá huꞌmba yá mʉi ya cu. Nepʉ bi maꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ra cu Pablo ne ra cu Sila bi ma bi ꞌranga ja ra hnini Anfipoli ne ja ra hnini Apolonia, ne de guehni bi zønga asta ja ra hnini Tesalonica. Ne ja mi jani ꞌnará nija̱ ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Y nuni ra nija̱ꞌa̱ núꞌa̱ ra pa dega tsaya ra cu Pablo ngu xi mrá nza̱i bi ma bi yʉtꞌini hñu semana dega tatꞌa hña̱to pa mi ntsanoyaui ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mi heꞌta ra Ma̱ca Tꞌofo ne mi xipabiꞌʉ hanja mi pɛꞌtsi da sufri ra Cristo núꞌa̱ rá ꞌmɛhni Ajua̱, ne da du ne da yopa nte. Ne mi embabi: ―Nuna ra Jesu dí xiꞌahʉ go guehna ra Cristo bá pɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ne ꞌra de ya xodyo bi gamfri ne bi muntsꞌui ra cu Pablo ne ra cu Sila. Nehe bi gamfri ndunthi ya me Grecia núꞌʉ mri xøcambeni Ajua̱, ne ndunthi ya ꞌbɛhña̱ núꞌʉ xi myá fa̱di de ra hnini. ");
INSERT INTO oteNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Hangue xi bi bø yá cuɛ ya xodyo núꞌʉ himyá gamfri, ne bá muntsꞌa ꞌraya tsꞌoja̱ꞌi mbi ꞌyo dega da̱hñei ja ra hnini pa bi ꞌyʉꞌti ne bi japi da ñʉntsꞌi maxøgue ra hnini. Nepʉ bi maꞌʉ ja rá ngu ra cu Jasón pa xa gʉcjhma̱ha̱ ra cu Pablo ne ra cu Sila pa xa ꞌyɛntꞌua ja yá ꞌyɛ ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pe nuꞌʉ́ mi joꞌoni, hangue go bri jʉca ra cu Jasón co maꞌra ya cu, bi tsꞌixa ja ya nda̱ de ra hnini, ne mi mafi ntsꞌɛdi ya ja̱ꞌi mi ena: ―Núꞌʉ ya ꞌñøhø toꞌo xa tsꞌoca gatho ra ximhai co yá tsꞌontꞌudi ya xa zøcjʉua nehe. ");
INSERT INTO oteNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Nuna Jasón go guehni xa umba nsɛqui ja rá ngu. Gathoyʉ hingui øta ma nda̱hʉ Nroma ngueꞌa̱ nuyʉ́ ma̱ gue ꞌbʉ maꞌna ra nda̱, ne núꞌa̱ ra nda̱ꞌa̱ rá thuhu ra Jesu, ꞌna̱. ");
INSERT INTO oteNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Y nu mi ꞌyø njabʉ ya ja̱ꞌi ne ya nda̱ de ra hnini, xi bi bø yá cuɛ gatho ne mri ña̱hnithoꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pe ra cu Jasón ne núꞌʉ toꞌo mri ꞌñoui bi ꞌyadiꞌʉ ꞌnara fiansa pa bi thɛgui. ");
INSERT INTO oteNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ne ngu bi nxuui ya cu bi mɛhna ra cu Pablo ne ra cu Sila pa bi ma ja ra hnini Berea. Ne nu mi zøni de guehni bi yʉtꞌa ja yá nija̱ ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Y nuya xodyo de guehni Berea xi myá hoja̱ꞌiꞌʉ, hingue ngu ya me Tesalonica. Co ndunthi ra paha bi gamfriꞌʉ rá noya Ajua̱, ne hyastho mi honga ja ra Ma̱ca Tꞌofo pa da ba̱di ua gue xi majua̱ni núꞌa̱ mi ma̱ñꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hangue ringueꞌa̱ ndunthi de gueꞌʉ bi gamfri, ne ꞌraya me Grecia bi gamfri nehe, nehe ndunthi núꞌʉ toꞌo xi myá fa̱di ngu ya ꞌbɛhña̱ ngu ya ꞌñøhø, gatho bi gamfriꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pe nu mi ꞌyøde ya xodyo me Tesalonica gue ra cu Pablo mi ma̱nga rá noya Ajua̱ de guehni Berea, bi ma de guehniꞌʉ pa bá ʉꞌta ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pe nuya cu de guehni Berea bi da̱ma zixa ra cu Pablo pa bi ma ja ra ndehe. Pe ra cu Sila ne ra cu Timoteo ja bi gohnithoꞌʉ Berea. ");
INSERT INTO oteNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ha núꞌʉ toꞌo bi zixa ra cu Pablo bi mɛui asta ja ra hnini Atena. Nepʉ nuꞌʉ́ bá pengui bá ha̱ ra noya núꞌa̱ bá xipa ra cu Pablo gue da xipa ra cu Sila ne ra cu Timoteo da ma ꞌbestho pa ja dí nthɛuini. ");
INSERT INTO oteNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ha nu de mi ꞌbʉhni Atena ra cu Pablo mi tøꞌma ra cu Sila ne ra cu Timoteo, xi mi tu rá mʉi ngueꞌa̱ bi hyandi xi mi ja ndunthi ya cꞌoi núꞌʉ mi nsunda ya ja̱ꞌi de guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hangue bi zofo ya xodyo ja yá nija̱, ne núꞌʉ maꞌra mi xøcambeni Ajua̱ de guehni. Ne hyastho mi ꞌyoni ja ra tai mi zofo ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ne bi ntsanoyaui ꞌraya ꞌñøhø de guehni mri nxadi núꞌa̱ mi utuabi ya ja̱ꞌi núꞌʉ mi tꞌembi ya epicureo, ne maꞌra mri nxadi de ya estoico. Ne ꞌra de gueꞌʉ mi ena: ―¿Te xicjʉ ꞌbʉ nuna ꞌñøhø xi ña̱ ndunthi? Ha nu maꞌra mi ena: ―ꞌMatho ma̱mba rá noya maꞌra ya zidada. Nuꞌʉ́ bi ma̱nga njabʉ ngueꞌa̱ ra cu Pablo xqui xipabiꞌʉ de ra Zidada Jesu, ne xqui xipabi gue xqui yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nepʉ de guehni bi zixa ra cu Pablo ja ꞌnara zi loma rá thuhu Areópago, ngueꞌa̱ mri nza̱i ja da muntsꞌini gatho ya ja̱ꞌi pa da nxahniꞌʉ ꞌna ngu maꞌna, ne bi tꞌambabi: ―¿Ha da za gui ꞌñutcaguihe nuna ra ꞌraꞌyo ntꞌutuate guí udi? ");
INSERT INTO oteNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ngueꞌa̱ guí xicaguihe ya ꞌraꞌyo noya hinstá øhe, hangue dí ne ga pa̱he te rí bønga nuya noya guí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bi ma̱nga njabʉꞌʉ ngueꞌa̱ gatho ya me Atena ne ya nzøhø gá ja̱ꞌi mi ꞌbʉi de guehni mri nza̱i mri muntsꞌi hønsɛ pa da ꞌyøde ne da ma̱ de núꞌʉ ya ꞌraꞌyo noya xqui ꞌyøde. ");
INSERT INTO oteNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Hangue ra cu Pablo bi ꞌmai madetho de gueꞌʉ nuni ja ra Areópago ne bi ꞌñena: ―Núꞌahʉ gyá me Atenahʉ, dí handi gue nuꞌahʉ́ xi grí xøcambenihʉ gatho núꞌʉ ri zidadahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ngueꞌa̱ de dá thogui de guehni ja ri nija̱hʉ habʉ guí xøcambeni ri zidadahʉ, dá handa ꞌnara ata habʉ ntꞌofo ne ena: “Nuna ata ja guecua di xøcambeni núꞌa̱ ra ajua̱ hinhyaꞌmʉ xa fa̱di”, njabʉ ena. Y núꞌa̱ Ajua̱ hinhyaꞌmʉ xcá pa̱hʉ, go gueꞌa̱ dí xiꞌahʉbya. ");
INSERT INTO oteNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Núꞌa̱ Ajua̱ toꞌo bi hyoca ra ximhai ne gatho núꞌa̱ jaua, go gueꞌa̱ ra Nda̱ de mahetsꞌi ne de ra ximhai. Nuꞌá̱ hingui ꞌbʉ ja ya nija̱ núꞌʉ xa hyoca ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ne nixi hingui øꞌtua ra ꞌbɛdi núꞌa̱ øtꞌa ya ja̱ꞌi pa gueꞌa̱, ngueꞌa̱ go guesɛꞌa̱ ri ꞌracjʉ ra te ne ra nda̱hi pa ga jʉnshʉ, ne gatho ya tꞌøtꞌe núꞌʉ dí hoñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ne ꞌnadra ji bi hyoca gatho ya ja̱ꞌi núꞌʉ ꞌbʉi habʉraza nuua ja ra ximhai. Ne nuꞌá̱ go bi ma̱ hangu ya jɛya da nteꞌʉ ne habʉ da ꞌmʉꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ajua̱ njabʉ bi hyogaguihʉ pa ga hoñhʉꞌa̱ pa xahma̱ ga tsʉdihʉ, masque nuꞌá̱ hingui ꞌbʉi yabʉ de guecjʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngueꞌa̱ por gueꞌa̱ dí ꞌbʉhʉ ne dí ꞌña̱nihʉ, nja ngu ꞌrari ꞌyofohʉ bi ꞌyofo njaua bi ꞌñena: “Xi majua̱ni nujʉ́ go yá ba̱tsiguihʉ Ajua̱”, njabʉ bi ꞌñena. ");
INSERT INTO oteNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Hangue nuꞌbʉ yá ba̱tsiguihʉ Ajua̱, hinda za ga eñhʉ gue Ajua̱ ꞌnara cꞌoi dega oro o dega tꞌaxi o dega do núꞌa̱ xa hyoca ya ja̱ꞌi ngu núꞌa̱ beni hanja da hyocsɛꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ajua̱ mi hopi da thoguitho núꞌa̱ xqui ꞌyøtꞌa ya ja̱ꞌi mayaꞌbʉ ngueꞌa̱ hinte myá fa̱di, pe nubyá ri manda gue da ñobri gatho ya ja̱ꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ngueꞌa̱ Ajua̱ xa hñuxa ꞌnara pa, ne núꞌa̱ ra paꞌa̱ ma da hña̱ꞌmba nguɛnda gatho ya ja̱ꞌi de ra ximhai co ꞌnara hoga tsꞌʉtbi. Y núꞌa̱ toꞌo bi hñutsꞌi pa da hña̱nga nguɛnda go gueꞌa̱ ra Zidada Jesucristo. Ne ngu ꞌnara ntꞌudi de gueꞌa̱, Ajua̱ bi japi bi yopa nte de ra du. ");
INSERT INTO oteNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Y nu mi ꞌyødeꞌʉ gue ra Zidada Jesu xqui yopa nte de ra du, ꞌra mi ꞌña̱ntꞌʉtho, ha nu maꞌra mi ena: ―Maꞌna xá hño maꞌna ra pa gui xicje núꞌa̱ guí ma̱. ");
INSERT INTO oteNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nepʉ ra cu Pablo bi ꞌuegue de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pe ꞌra de gueꞌʉ bi gamfri ne bi dɛniꞌa̱. Ne ꞌna de gueꞌʉ mrá thuhu ra Nisio, mi gueꞌa̱ ꞌna de nuya nda̱ mri muntsꞌini ja ra Areópago. Nehe ꞌnara ꞌbɛhña̱ mrá thuhu ra Damari bi gamfri rá noya Ajua̱, co maꞌra ya mengu de guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nepʉ de gueꞌa̱ ra cu Pablo bi bøni de guehni Atena pa bi ma ja ra hnini Corinto. ");
INSERT INTO oteNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ne ja bi nthɛuini ꞌnara cu mrá xodyo mrá thuhu ra Aquila, mrá me Ponto ne ja xqui ꞌñehe de ra hai Italia, ne mri ꞌñoui rá ꞌbɛhña̱ mrá thuhu ra Priscila. Núꞌʉ́ xqui bøni de ra hnini Nroma ngueꞌa̱ ra nda̱ Claudio bi manda da juui de guehni gatho ya xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ra cu Pablo bi ma bá ꞌbʉhui ra cu Aquila co rá ꞌbɛhña̱ ngueꞌa̱ mi ꞌnada yá ꞌbɛfiꞌʉ, mi hoca ya carpa dega dutu. ");
INSERT INTO oteNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ne cada ra pa dega tsaya ra cu Pablo mi pa ja yá nija̱ ya xodyo pa mi ña̱uiꞌʉ, nehe mi ña̱ui núꞌʉ himyá xodyo, y mi zofoꞌʉ de rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ne nu mi zøhø ra cu Sila ne ra cu Timoteo xqui ꞌñeheꞌʉ de ra hai Macedonia, bi zʉhniꞌʉ ra cu Pablo mi ja ndunthi ra ꞌbɛfi ngueꞌa̱ hyastho mi zofo ya xodyo mi xipabi gue ra Jesu go gueꞌa̱ ra Cristo núꞌa̱ xqui mɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pe nuya xodyo bi nøꞌtuabi ne bi zani. Nuꞌbʉ́ ra cu Pablo bi hña̱ca rá patꞌi ne bi hua̱tꞌi, gueꞌa̱ ꞌnara seña gue mi ma da ꞌuegue de gueꞌʉ ne hinda ma da da̱di de yá tsꞌoqui, ne bi ꞌñembabi: ―Nuꞌahʉ go ma gui tha̱disɛhʉ de ri duhʉ, ngueꞌa̱ nuga ya hinte dí tha̱di de gueꞌahʉ. Desde nubya ma ga zofo núꞌʉ hingyá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","De guehni ra cu Pablo bi ꞌuegue de gueꞌʉ ne bi ma ja rá ngu ꞌnara ꞌñøhø mrá thuhu ra Justo mi ꞌbʉ gueta yá nija̱ ya xodyo, ne nuꞌá̱ mi xøcambeni Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nepʉ ꞌnara ꞌñøhø mrá thuhu ra Crispo mrá nda̱ de yá nija̱ ya xodyo bi gamfri ra Zidada Jesu con gatho ya mengu rá ngu. Ne ndunthi ya me Corinto bi ꞌyøtua rá noya Ajua̱ mi ma̱nga ra cu Pablo, bi gamfriꞌʉ ne bi nxistehe. ");
INSERT INTO oteNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nepʉ ꞌnara xuui ra Zidada Jesu bi zofo ra cu Pablo ngu dega tꞌi ne bi ꞌñembabi: ―Oguí tsu, sigui gui ma̱nga ra ma̱ca noya, oguí tsaya gui ña̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ngueꞌa̱ nuga dí ꞌbʉi con gueꞌe, y hinda za to da ꞌyøꞌtꞌa ra ntsꞌoꞌmʉi. Ngueꞌa̱ ja nuna hninina̱ ꞌbʉi ndunthi ya ja̱ꞌi go ma mɛti, y núꞌʉ́ ma da gamfrigui. ");
INSERT INTO oteNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Hangue ra cu Pablo bi gohni ꞌna njɛya made nuni ja ra hnini Corinto. Ne nza̱ntho mi zofo ya ja̱ꞌi de rá noya Ajua̱ de guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pe de núꞌʉ ya pa mrá nda̱ ra Galio nuni ja ra hai Acaya, ya xodyo bi ꞌñʉꞌti pa da gʉ ra cu Pablo, ne bi zixꞌʉ ja ra tsꞌʉtbi. ");
INSERT INTO oteNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ne bi ꞌñembabi ra nda̱: ―Nuna ꞌñøhøna̱ ʉꞌta ya ja̱ꞌi pa hinda nsunda Ajua̱ ngu ma̱nga rá ley ra Moise. ");
INSERT INTO oteNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ra cu Pablo mi ma da da̱hma̱ha̱, pe ra nda̱ Galio bi ꞌñemba ya xodyo: ―ꞌBʉ di jahma̱ te xa ꞌyøꞌtꞌahʉ nuna ra ꞌñøhø, o xa ꞌyøtꞌa ꞌnara tsꞌocate nuua ja ra hnini, nuꞌbʉ́ ha̱, da za ga øtꞌa núꞌa̱ guí ma̱ñhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pe núꞌa̱ guí ma̱ñhʉ hønsɛ dega noya ne de ri leyhʉ, go da nuhʉ te gui ꞌyøthʉ. Nuga hinte dí ꞌñɛntꞌi con guehna. ");
INSERT INTO oteNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nepʉ bi japi da bøñꞌʉ de guehni ja ra tsꞌʉtbi. ");
INSERT INTO oteNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nuꞌbʉ́ gatho núꞌʉ himyá xodyo mi ꞌbʉhni bi mihi ra Soste núꞌa̱ mrá nda̱ de yá nija̱ ya xodyo de nura hniniꞌa̱, ne ja bi hnaꞌmbabini ntsꞌɛdi ja rá thandi ra nda̱ Galio, pe nuꞌá̱ nixi bi ꞌyøtꞌa ncaso, y nixi hinte bi ma̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ha nura cu Pablo bi gohi ndunthi ya pa de guehni. Nepʉ de gueꞌa̱ bi ꞌñedi gatho ya cu, ne bi mɛui ra cu Aquila co ra nju Priscila pa bi ma ja ra hai Siria. Ne de má ꞌñu bi ꞌranga ja ꞌnara zi tꞌʉca hnini rá thuhu Cencrea. Ne ante da gʉ ra motsaꞌʉ pa da ꞌraxa ja ra ndehe, ꞌmɛtꞌo ra cu Pablo bi ꞌña̱xa gatho rá sta̱ pa bi ꞌyøtꞌa ra hña̱ꞌti ngu núꞌa̱ xqui ma̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Y nu mi zønga Efeso ra cu Pablo ja bi zoguini ra nju Priscila co ra cu Aquila, y nuꞌá̱ bi ma ja yá nija̱ yá mixodyoui pa bá ña̱uiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Y nuꞌʉ́ bi ba̱ntebi ra cu Pablo da gohi ꞌraya pa, pe nuꞌá̱ himbi ne. ");
INSERT INTO oteNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Hangue bi ꞌñehuiꞌʉ ne bi ꞌñembabi: ―Dí pɛꞌtsi te grá ꞌbʉ Jerusale pa ga øtꞌa ra ngo núꞌa̱ ya ma da datꞌi, pe ma ga penga maꞌnaꞌqui pa ga cꞌa̱ꞌtsꞌaꞌihʉ ꞌbʉ Ajua̱ go rá paha. Ne bi bøni de guehni Efeso, ne bi gʉ ra motsa pa bi ꞌraxa ja ra ndehe pa bi ma Cesarea. ");
INSERT INTO oteNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nu mi zøni de guehni bi thogui ꞌbestho pa bi ma Jerusale. Ne nu mi uadi bi zɛngua gatho ya cu de guehni, bi thogui pa bi ma Antioquía. ");
INSERT INTO oteNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nepʉ de ya xqui ꞌmʉhni ꞌraya pa, bi bøni maꞌnaꞌqui pa bi ma gatho ja ya hnini de ra hai Galacia ne de Frigia pa da nu te gra ma rá ꞌbɛfi Ajua̱, ne mi xipi da zɛdi yá jamfri gatho ya gamfri núꞌʉ mbi ꞌbʉhni. ");
INSERT INTO oteNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Núꞌʉ ya paꞌʉ bi zønga Efeso ꞌnara xodyo mrá thuhu ra Apolo mrá mengu ja ra hnini Alejandría. Xi mi pa̱di da ña̱ xá hño, ne mi pa̱di xá hño gatho núꞌa̱ ma̱nga ra Nda̱xjua Tꞌofo. ");
INSERT INTO oteNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nuꞌá̱ xqui tꞌutuabi rá noya ra Zidada Jesu desde bi gamfriꞌa̱, ne xi mrá ehya mi udi xá hño de núꞌa̱ mi pa̱di de ra Zidada Jesu, masque hønsɛ mi pa̱di de rá sistehe ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ne bi mʉdi bi zofo ya xodyo ja yá nija̱ꞌʉ, ne himi tsu. Nepʉ mi ꞌyøde ra nju Priscila ne ra cu Aquila, bi zixa ꞌnambʉ pa bi ꞌñutuabi maꞌna xá hño de rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nepʉ nuꞌá̱ ꞌmɛfa mi ne da ma Acaya, y ya cu de guehni Efeso bi xipabi gue xá hño da ma. Ne nuꞌʉ́ bi ꞌyopa ꞌnara hɛꞌmi pa bi mɛmpa ya cu Acaya pa da tꞌumba ra hoga ꞌñeheꞌa̱. Ne nu mi zønga Acaya, nuꞌá̱ bi matsꞌi de guehni núꞌʉ xqui gamfribi rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ne xi mi ntsanoyaui ya xodyo ja yá thandi gatho ya ja̱ꞌi. Nuꞌá̱ mi xipi ngu núꞌa̱ ma̱nga ja ra Nda̱xjua Tꞌofo gue ra Jesu go gueꞌa̱ ra Cristo núꞌa̱ toꞌo bá pɛhna Ajua̱ pa da nda̱, ne go gueꞌa̱ núꞌa̱ mi tøꞌmiꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nura cu Apolo mi ꞌbʉhni Corinto, ha nura cu Pablo mbi ꞌyo ra ꞌñu pa mri ma Efeso, bi ꞌranga ja ꞌraya tꞌøhø xi myá mboza, ne de gueꞌa̱ bi zønga Efeso habʉ mi ꞌbʉi ꞌraya gamfri. ");
INSERT INTO oteNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Nepʉ nuꞌá̱ bi ꞌyambabiꞌʉ ne bi ꞌñembabi: ―¿Ha gue gá hña̱ñhʉ ra Ma̱ca Nda̱hi núbya gá camfrihʉ rá noya Ajua̱? Nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Hina, nixi stá øhe ua ꞌbʉ ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Hangue nura cu Pablo bi ꞌyambabi ne bi ꞌñembabi: ―¿Te ma sistehe xcá hña̱ñhʉ ꞌbʉ? Ne nuꞌʉ́ bi da̱di ne bi ꞌñena: ―Rá sistehe ra Xuua. ");
INSERT INTO oteNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ra cu Pablo bi ꞌñembabiꞌʉ: ―Nura Xuua mi xiꞌtsa ya ja̱ꞌi ngueꞌa̱ gueꞌa̱ ngu ꞌnara seña gue nuya ja̱ꞌiꞌʉ ya xqui ñobri de yá tsꞌoqui. Pe bi xipabiꞌʉ nehe gue mahyoni da gamfri núꞌa̱ mi ma da zøhø ꞌmɛfa de gueꞌa̱, go gueꞌa̱ ra Jesu núꞌa̱ toꞌo ra Cristo núꞌa̱ bá pɛhna Ajua̱ pa da nda̱. ");
INSERT INTO oteNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ha nu mi ꞌyøde njabʉ bi nxisteheꞌʉ de rá thuhu ra Zidada Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nepʉ ra cu Pablo bi hñuxa yá ꞌyɛ ja gatho ya gamfri pa bi hña̱nga ra Ma̱ca Nda̱hi. Y nura oraꞌa̱ bi ña̱ꞌʉ ꞌramaꞌnaꞌño ya hña̱qui ne bi ma̱ñꞌʉ ngu núꞌa̱ xqui xipabi Ajua̱ da ma̱. ");
INSERT INTO oteNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ngu mi ꞌrɛtꞌamayoho por gatho núꞌʉ xqui hña̱nga ra Ma̱ca Nda̱hi. ");
INSERT INTO oteNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ngu hñu nza̱na̱ ra cu Pablo bi ma ja yá nija̱ ya xodyo habʉ mbi ma̱mba rá noya Ajua̱ co ndunthi ra tsꞌɛdi. Nuꞌá̱ mi ntsanoyaui ya ja̱ꞌi ne mi øtꞌa ꞌnara tsꞌɛdi pa da gamfriꞌʉ núꞌa̱ mi xipabi hanja go ri manda Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pe ꞌra de gueꞌʉ xi xmá me yá coraso hangue himbi ne bi gamfri, hønsɛ mi tsanba rá noya Ajua̱ ja yá thandi ya ja̱ꞌi. Hangue nura cu Pablo bi ꞌuegue de gueꞌʉ, ne bi zixa núꞌʉ xqui gamfri ja ꞌnara scuela, ne nura xahnate mi ꞌbʉhni rá thuhu ra Tiranno. Y ja guehni ra cu Pablo mbi ma̱mba rá noya Ajua̱ hyastho. ");
INSERT INTO oteNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Njabʉ bi ꞌyøtꞌa yo njɛya pa bi ꞌyødebi rá noya ra Zidada Jesu gatho núꞌʉ mi ꞌbʉ ja ra hai Asia, ya xodyo ne núꞌʉ himyá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Y Ajua̱ bi umba ra tsꞌɛdi ra cu Pablo pa bi ꞌyøtꞌa ya da̱nga ntꞌudi, ");
INSERT INTO oteNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","asta mi tha̱ꞌtsua yá nthuꞌtaña̱xu ne maꞌra yá dutu nuya daꞌthi pa mi thaniꞌa̱ ne mi yopa tha̱ꞌtsuabi ya daꞌthi y nuꞌʉ́ mi ña̱ni, y nuꞌʉ tóꞌo mi pɛꞌtsa ya tsꞌonda̱hi nuꞌʉ́ mi pøni de gueꞌʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pe nu ꞌraya xodyo myá ꞌñete mi ꞌyoꞌʉ mi japa ya tsꞌonda̱hi da bøni de ja ya ja̱ꞌi, nepʉ nuꞌʉ́ bi beni gue da zapi da ꞌyɛnga ya tsꞌonda̱hi de rá thuhu ra Zidada Jesu nehe ngu mi øtꞌa ra cu Pablo. Ne mi embabi ya tsꞌonda̱hi: ―Dí xiꞌaꞌihe gui pøni de rá thuhu ra Jesu núꞌa̱ ma̱nga ra Pablo. ");
INSERT INTO oteNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Guehna bi ꞌyøtꞌa núꞌʉ yoto yá tꞌʉ ra Seva núꞌa̱ ꞌnamrá nda̱ gá macja̱ gá xodyo. ");
INSERT INTO oteNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pe nu mi ꞌyøꞌtua njaua ꞌnara tsꞌonda̱hi, nuꞌá̱ bi da̱di ne bi ꞌñemba núꞌʉ ya ꞌñøhø: ―Nuga dí pa̱ca toꞌo ra Jesu, ne dí pa̱ca toꞌo ra Pablo, xi nuꞌahʉ, ¿toꞌoꞌihʉ? ");
INSERT INTO oteNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ha núꞌa̱ ra ꞌñøhø toꞌo mi pɛꞌtsa ra tsꞌonda̱hi bi ma bá jʉ núꞌʉ ya ꞌñete co rá tsꞌɛdi ra tsꞌonda̱hi ne xi bi naꞌmbi ntsꞌɛdi. Ha nuꞌʉ́ bi nestꞌihi bi bøni de guehni myá thɛlo ngueꞌa̱ bi thʉmba gatho yá dutu, ne bi hña̱xa ndunthi ya ntsꞌɛni. ");
INSERT INTO oteNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Y gatho ya xodyo mi ꞌbʉhni Efeso ne núꞌʉ himyá xodyo bi ꞌyødeꞌʉ núꞌa̱ xqui nja, nuꞌbʉ́ nuꞌʉ́ xi bi ntsu. Ne maꞌna xi mri tꞌeꞌtsua rá nsu rá thuhu ra Zidada Jesu. ");
INSERT INTO oteNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ne ndunthi de núꞌʉ xqui gamfri mi pa mri njua̱ni de yá tsꞌoqui. ");
INSERT INTO oteNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Y ndunthi ya ꞌñete bi hña̱xa yá tꞌofo pa bi tsa̱tꞌa ja yá thandi ya ja̱ꞌi, ha nuya libroꞌʉ nu mi tꞌøtꞌa ra uɛnda, mri muui ngu made nthebe ꞌmo ya tꞌaxaboja̱. ");
INSERT INTO oteNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Njabʉ maꞌna mri ntʉnga rá noya Ajua̱ co ndunthi ra tsꞌɛdi. ");
INSERT INTO oteNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nepʉ de gueꞌa̱ ra cu Pablo bi hñutsꞌi gue da ma da cꞌa̱ꞌtsa ya cu asta ja ra hai Macedonia ne Acaya, nepʉ rí ꞌñehe Jerusale, nepʉ de guehni mahyoni rí ma Nroma. ");
INSERT INTO oteNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Hangue bi mɛhna yoho yá mfatsꞌi da ꞌmɛtꞌo pa rí ma Macedonia, bi mɛhna ra cu Timoteo ne ra cu Erasto. Ha nura cu Pablo bi gohnitho maꞌra ya pa de guehni ja ra hai Asia. ");
INSERT INTO oteNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Núꞌʉ ya paꞌʉ bi ñʉntsꞌa gatho ya me Efeso ngueꞌa̱ bi zønini rá noya Ajua̱. ");
INSERT INTO oteNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mi ꞌbʉhni ꞌnara ꞌñøhø mrá thuhu ra Demetrio. Nura ꞌbɛfi mi pa̱diꞌa̱ mi pøe ya boja̱ dega tꞌaxi. Ne mi ꞌbʉ yá mfatsꞌi mi hoca ya cꞌoi de ꞌnara zina̱na̱ rá thuhu Diana pa mi papa ya ja̱ꞌi. Y xi mi ta̱ha̱ ndunthi ra boja̱. ");
INSERT INTO oteNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nepʉ ꞌnara pa ra Demetrio bi muntsꞌa gatho núꞌʉ yá mfatsꞌi ne maꞌra núꞌʉ toꞌo mi hoca ya cꞌoi nehe, ne bi ꞌñembabi: ―Nuꞌahʉ́ guí pa̱dihʉ gue co nuna ꞌbɛfina̱ stá ta̱hʉ ndunthi ra boja̱, ne hinte stá ꞌbɛhʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pe ngu xcá ꞌyøhʉ ne xcá hyanthʉ gue nura Pablo ri ꞌyo ne ma̱ gue núꞌʉ ya zidada nthoqui, hingyá zidada. Y njabʉ xa hña̱cua ndunthi ya ja̱ꞌi gue hinda nsunda ya zidada, hingue hønsɛua Efeso, nehe maxøgue gatho ma haihʉ Asia. ");
INSERT INTO oteNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nuna guehna maꞌna xá ntsꞌobyana̱, ha go guehna ma ꞌbɛfihʉ dí hanthma̱hʉna̱. Nubyá da ne ma ga ꞌbɛdihʉ za̱i, asta ne ra nija̱ de ma zina̱na̱hʉ Diana núꞌa̱ xi rá nsunda, ma da ꞌmɛdi núꞌa̱ ra nsu pɛꞌtsi. Ha ne gue numa zina̱na̱hʉ Diana ri nsunda gatho ya ja̱ꞌi de guecua ja ma haihʉ Asia ne gatho maxøgue ra ximhai. ");
INSERT INTO oteNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nu mi ꞌyøde njabʉ gatho nuyá mfatsꞌi ne gatho núꞌʉ maꞌra toꞌo mi hoca ya cꞌoi xi bi bø yá cuɛꞌʉ, ne mi mafi mi ena: ―¡Xi rá nsunda ma zina̱na̱hʉ Diana! ");
INSERT INTO oteNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ne bi nja ngu ra mpumfri gatho ja ra hnini, ne bri mihi ra cu Gayo ne ra cu Aristarco myá me Macedonia núꞌʉ xqui ꞌñoui ra cu Pablo. Ne bri jʉtꞌi ne bri tsꞌitsꞌi asta habʉ mi øtꞌa yá hmuntsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ha nura cu Pablo mi ne xa yʉtꞌini pa xa zofo ya ja̱ꞌi, pe nuya gamfri himbi hyopi bi yʉtꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nehe ꞌraya nda̱ de Asia núꞌʉ mi ntsixui ra cu Pablo, bi mɛmpa ra noya gue hinda yʉtꞌa de guehni. ");
INSERT INTO oteNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nura oraꞌa̱ xi mbi ja ꞌnara hmahni ja yá hmuntsꞌiꞌʉ, ꞌramaꞌnaꞌño mi ma̱ñꞌʉ, ngueꞌa̱ gatho xi xqui mpumfri, ne xi ndunthi de gueꞌʉ nixi mi pa̱di hanja xqui muntsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pe nu ꞌra de gueꞌʉ bi xipabi ra Jandro hanja xqui muntsꞌi. Nuya xodyo xqui umba ya ntꞌentꞌi ra Jandro pa da ꞌmai da ña̱ ja yá thandi ya ja̱ꞌi. Nepʉ nuꞌá̱ bi ꞌñutua ra seña ya ja̱ꞌi co rá ꞌyɛ pa da goꞌta yá ne. Nuꞌá̱ mi ne da ña̱nga yá mixodyoui núꞌʉ xcrí jʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pe nu mi ba̱di ya ja̱ꞌi gue mrá xodyoꞌa̱, nuꞌʉ́ bi mafi ntsꞌɛdi ngu yo ora, ne mi ena: ―¡Xi rá nsunda ma zina̱na̱hʉ Diana! ");
INSERT INTO oteNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nepʉ ꞌnara nda̱ de ra hnini bi goꞌtua yá ne ya ja̱ꞌi ne bi ꞌñembi: ―Núꞌahʉ gyá menguhʉua Efeso, habʉraza xa fa̱di gue nuua ja ma hninihʉ xi drí suphʉ rá nija̱ ma zina̱na̱hʉ Diana núꞌa̱ xá nsunda, y drí suphʉ rá cꞌoi núꞌa̱ bá ca̱i de mahetsꞌi bá pɛhna ma zidadahʉ ra Jupite. ");
INSERT INTO oteNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Guí pa̱hʉ gue xa fa̱di habʉraza, oguí tu ri mʉihʉ, ne ote guí øthʉ ꞌbʉ hinxcá beñhʉ xá hño ꞌmɛtꞌo núꞌa̱ guí ne gui øthʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nuyʉ ya ꞌñøhø xcuá tsihʉ hinte xa ꞌyøꞌtꞌahʉ, ha nixi xa ña̱maꞌñʉ de ma zina̱na̱hʉ drí nsundahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Y nura Demetrio ne núꞌʉ maꞌra to hoca ya cꞌoi, ꞌbʉ ja te da ña̱pabi, dá ña̱pabi ja ra tsꞌʉtbi, ne dá nhyanthya̱ui ja ra nzaya. ");
INSERT INTO oteNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nuꞌbʉ ja maꞌna te gui ma̱ñhʉ, da za gui maha ja ra tsꞌʉtbi gui ma̱ñhʉ ja ma hmuntsꞌihʉ ngu ma̱nga ra ley. ");
INSERT INTO oteNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ngueꞌa̱ pa guecjʉ xá ntsꞌuni. Da za da hña̱pcahʉ da tꞌena gue xi dyá necatuhnihʉ por nuna ra ñʉntsꞌi stá øthʉbya, ne hindí pa̱hʉ te ga tha̱dihʉ nu sta tꞌangahʉ. ");
INSERT INTO oteNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nepʉ mi ma̱nga njaua ra nda̱, bi ꞌñehui ya ja̱ꞌi ne bi ua ra hmuntsꞌi. ");
INSERT INTO oteNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ha nu mi uadi núꞌa̱ ra da̱nga ñʉntsꞌi xqui nja, ra cu Pablo bi zohna gatho ya cu pa bi umba ꞌnara tsꞌofo. Nepʉ bi ꞌñehui gatho co ꞌnara nthʉfi ne bi bøni de guehni bi gʉ ra ꞌñu bi ma pa ja ra hai Macedonia. ");
INSERT INTO oteNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ne bi yopa zøni habʉ gatho mi ꞌbʉ ya cu pa bi nupa yá mfeni, nepʉ bi ma pa Grecia. ");
INSERT INTO oteNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Y nuni ja bi ꞌmʉhni hñu nza̱na̱. Ne ꞌmɛfa ya mi ma da gʉ ra motsa pa da ꞌraxa ja ra ndehe pa dí ma Siria, pe bi ꞌyøde 