﻿USE sofia;
DROP TABLE IF EXISTS sofia.ory_vpl;
CREATE TABLE ory_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ory_vpl WRITE;
INSERT INTO ory_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ଆଦ୍ୟରେ ପରମେଶ୍ୱର ସ୍ୱର୍ଗସମୂହ ଓ ପୃଥିବୀକୁ ସୃଷ୍ଟି କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ପୃଥିବୀ ନିର୍ଜନ ଓ ଶୂନ୍ୟ ଥିଲା, ଆଉ ଗଭୀର ଜଳ ଉପରେ ଅନ୍ଧକାର ଥିଲା; ପୁଣି, ପରମେଶ୍ୱରଙ୍କ ଆତ୍ମା ଜଳ ଉପରେ ବ୍ୟାପ୍ତ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର କହିଲେ, “ଦୀପ୍ତି ହେଉ,” ତହିଁରେ ଦୀପ୍ତି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ଆଉ ପରମେଶ୍ୱର ଦୀପ୍ତିକୁ ଦେଖିଲେ ଯେ ତାହା ଉତ୍ତମ; ତହୁଁ ପରମେଶ୍ୱର ଅନ୍ଧକାରରୁ ଦୀପ୍ତିକୁ ଭିନ୍ନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ପୁଣି, ପରମେଶ୍ୱର ଦୀପ୍ତିର ନାମ “ଦିବସ,” ଓ ଅନ୍ଧକାରର ନାମ “ରାତ୍ରି” ଦେଲେ। ତହୁଁ ସନ୍ଧ୍ୟା ଓ ପ୍ରାତଃକାଳ ହୋଇ ପ୍ରଥମ ଦିବସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର କହିଲେ, “ଜଳ ମଧ୍ୟରେ ଶୂନ୍ୟ ଜାତ ହୋଇ ଜଳକୁ ଦୁଇ ଭାଗରେ ଭିନ୍ନ କରୁ।” ");
INSERT INTO ory_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ଏହିରୂପେ ପରମେଶ୍ୱର ଶୂନ୍ୟ ନିର୍ମାଣ କରି ଶୂନ୍ୟର ଊର୍ଦ୍ଧ୍ୱସ୍ଥ ଜଳରୁ ଶୂନ୍ୟର ଅଧଃସ୍ଥ ଜଳକୁ ଭିନ୍ନ କଲେ; ତହିଁରେ ସେହିରୂପ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ଆଉ ପରମେଶ୍ୱର ସେହି ଶୂନ୍ୟର ନାମ “ଆକାଶମଣ୍ଡଳ” ଦେଲେ। ପୁଣି, ସନ୍ଧ୍ୟା ଓ ପ୍ରାତଃକାଳ ହୋଇ ଦ୍ୱିତୀୟ ଦିବସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର କହିଲେ, “ଆକାଶମଣ୍ଡଳର ଅଧଃସ୍ଥ ସମଗ୍ର ଜଳ ଏକ ସ୍ଥାନରେ ସଂଗୃହୀତ ହେଉ ଓ ସ୍ଥଳ ପ୍ରକାଶ ହେଉ,” ତହିଁରେ ସେହିରୂପ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ପୁଣି, ପରମେଶ୍ୱର ସ୍ଥଳର ନାମ “ପୃଥିବୀ,” ଓ ଜଳରାଶିର ନାମ “ସମୁଦ୍ର” ଦେଲେ; ଆଉ ପରମେଶ୍ୱର ତାହା ଉତ୍ତମ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ଏଉତ୍ତାରୁ ପରମେଶ୍ୱର କହିଲେ, “ପୃଥିବୀ ତୃଣ ଓ ସବୀଜ ଶାକ ଓ ବୀଜ ସମ୍ବଳିତ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁଯାୟୀ ଫଳୋତ୍ପାଦକ ଫଳବୃକ୍ଷ ଭୂମି ଉପରେ ଉତ୍ପନ୍ନ କରୁ,” ତହିଁରେ ସେପରି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ଅର୍ଥାତ୍‍, ପୃଥିବୀ ତୃଣ ଓ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁସାରେ ବୀଜଉତ୍ପାଦକ ଶାକ ଓ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁସାରେ ସବୀଜ ଫଳୋତ୍ପାଦକ ବୃକ୍ଷ ଉତ୍ପନ୍ନ କଲା; ପୁଣି, ପରମେଶ୍ୱର ତାହା ଉତ୍ତମ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ତହିଁରେ ସନ୍ଧ୍ୟା ଓ ପ୍ରାତଃକାଳ ହୋଇ ତୃତୀୟ ଦିବସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର କହିଲେ, “ରାତ୍ରିରୁ ଦିବସକୁ ପୃଥକ କରିବା ପାଇଁ ଆକାଶମଣ୍ଡଳରେ ଜ୍ୟୋତିର୍ଗଣ ଉତ୍ପନ୍ନ ହେଉନ୍ତୁ; ପୁଣି, ସେ ସବୁ ଚିହ୍ନ ଓ ଋତୁ ଓ ଦିବସ ଆଉ ବର୍ଷର କାରଣ ହେଉନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ଆଉ ପୃଥିବୀରେ ଆଲୁଅ ଦେବା ପାଇଁ ଆକାଶମଣ୍ଡଳରେ ସେହି ଜ୍ୟୋତିର୍ଗଣ ଥାଉନ୍ତୁ,” ତହିଁରେ ସେପରି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ଏହି ପ୍ରକାରେ ପରମେଶ୍ୱର ଦିବସରେ କର୍ତ୍ତୃତ୍ଵ କରିବାକୁ ଏକ ମହାଜ୍ୟୋତି ଓ ରାତ୍ରିରେ କର୍ତ୍ତୃତ୍ଵ କରିବାକୁ ତାହାଠାରୁ ସାନ ଏକ ଜ୍ୟୋତିଃ, ଏହି ଦୁଇ ମହାଜ୍ୟୋତି, ଆଉ ମଧ୍ୟ ତାରାଗଣ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ତହୁଁ ପୃଥିବୀରେ ଦୀପ୍ତି ଦେବା ପାଇଁ ଓ ଦିବା ଓ ରାତ୍ରି ଉପରେ କର୍ତ୍ତୃତ୍ୱ କରିବା ପାଇଁ, ");
INSERT INTO ory_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ଆଉ ଦୀପ୍ତିକୁ ଅନ୍ଧକାରରୁ ପୃଥକ କରିବା ପାଇଁ, ପରମେଶ୍ୱର ଆକାଶମଣ୍ଡଳରେ ସେହି ଜ୍ୟୋତିର୍ଗଣ ସ୍ଥାପନ କଲେ; ଆଉ ପରମେଶ୍ୱର ଏହି ସମସ୍ତ ଉତ୍ତମ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ତହିଁରେ ସନ୍ଧ୍ୟା ଓ ପ୍ରାତଃକାଳ ହୋଇ ଚତୁର୍ଥ ଦିବସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର କହିଲେ, “ଜଳ ବହୁଳ ରୂପେ ଜଙ୍ଗମ ପ୍ରାଣୀବର୍ଗରେ ପ୍ରାଣୀମୟ ହେଉ ଓ ପୃଥିବୀର ଉପରିସ୍ଥ ଆକାଶମଣ୍ଡଳରେ ପକ୍ଷୀଗଣ ଉଡ଼ନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ଆଉ ପରମେଶ୍ୱର ବୃହତ ତିମିଙ୍ଗିଳ ପ୍ରଭୃତି ଓ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁସାରେ ବହୁଳ ରୂପେ ଜଳଜ ଜଙ୍ଗମ ପ୍ରାଣୀବର୍ଗ ଓ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁସାରେ ପକ୍ଷୀଗଣର ସୃଷ୍ଟି କଲେ। ପରମେଶ୍ୱର ଏହି ସମସ୍ତ ଉତ୍ତମ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ପୁଣି, ପରମେଶ୍ୱର ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରି କହିଲେ, “ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ ହୋଇ ସମୁଦ୍ରର ଜଳ ପରିପୂର୍ଣ୍ଣ କର, ଆଉ ପୃଥିବୀରେ ପକ୍ଷୀଗଣ ବହୁସଂଖ୍ୟକ ହେଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ତହିଁରେ ସନ୍ଧ୍ୟା ଓ ପ୍ରାତଃକାଳ ହୋଇ ପଞ୍ଚମ ଦିବସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର କହିଲେ, “ପୃଥିବୀରେ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁସାରେ ପ୍ରାଣୀବର୍ଗ, (ଅର୍ଥାତ୍‍), ଗ୍ରାମ୍ୟ ପଶୁ ଓ ଉରୋଗାମୀ ଜନ୍ତୁ ଓ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁସାରେ ପୃଥିବୀର ବନ୍ୟ ପଶୁଗଣ ଉତ୍ପନ୍ନ ହେଉନ୍ତୁ,” ତହିଁରେ ସେପରି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ଏହିରୂପେ ପରମେଶ୍ୱର ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁଯାୟୀ ବନ୍ୟ ପଶୁଗଣ ଓ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁଯାୟୀ ଗ୍ରାମ୍ୟପଶୁଗଣ ଓ ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁଯାୟୀ ପ୍ରତ୍ୟେକ ଭୂଚର ଉରୋଗାମୀ ଜନ୍ତୁ ନିର୍ମାଣ କଲେ; ଆଉ ପରମେଶ୍ୱର ସେସମସ୍ତ ଉତ୍ତମ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର କହିଲେ, “ଆମ୍ଭେମାନେ ଆପଣା ପ୍ରତିମୂର୍ତ୍ତିରେ ଓ ଆପଣା ସାଦୃଶ୍ୟରେ ମନୁଷ୍ୟକୁ ନିର୍ମାଣ କରୁ। ସେମାନେ ଜଳଚର ମତ୍ସ୍ୟଗଣ ଓ ଖେଚର ପକ୍ଷୀଗଣ ଓ ପଶୁଗଣ ଓ ସମସ୍ତ ପୃଥିବୀ ଓ ଭୂମିରେ ଗମନଶୀଳ ସବୁ ଉରୋଗାମୀ ଜନ୍ତୁ ଉପରେ କର୍ତ୍ତୃତ୍ୱ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ଆପଣା ପ୍ରତିମୂର୍ତ୍ତିରେ ମନୁଷ୍ୟକୁ ସୃଷ୍ଟି କଲେ; ପରମେଶ୍ୱରଙ୍କ ପ୍ରତିମୂର୍ତ୍ତିରେ ସେ ତାହାକୁ ସୃଷ୍ଟି କଲେ; ପୁରୁଷ ଓ ସ୍ତ୍ରୀ କରି ସେ ସେମାନଙ୍କୁ ସୃଷ୍ଟି କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ଆଉ ପରମେଶ୍ୱର ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ; ପୁଣି, ପରମେଶ୍ୱର ସେମାନଙ୍କୁ କହିଲେ, “ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ ହୁଅ, ପୁଣି, ପୃଥିବୀକୁ ପରିପୂର୍ଣ୍ଣ କରି ବଶୀଭୂତ କର, ଆଉ ଜଳଚର ମତ୍ସ୍ୟଗଣ ଓ ଖେଚର ପକ୍ଷୀଗଣ ଓ ଭୂଚର ଉରୋଗାମୀ ଜନ୍ତୁଗଣ ଉପରେ କର୍ତ୍ତୃତ୍ଵ କର।” ");
INSERT INTO ory_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ପରମେଶ୍ୱର ଆହୁରି କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ଭୂମିସ୍ଥ ସବୁ ସବୀଜ ଶାକ ଓ ସବୁ ସବୀଜ ଫଳଦାୟକ ବୃକ୍ଷ ତୁମ୍ଭମାନଙ୍କୁ ଦେଲୁ, ତାହା ତୁମ୍ଭମାନଙ୍କର ଖାଦ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ପୁଣି, ପୃଥିବୀସ୍ଥ ସମସ୍ତ ପଶୁ ଓ ଖେଚର ପକ୍ଷୀ ଓ ଭୂଚର ଉରୋଗାମୀ ଜନ୍ତୁ, ଏହି ସମସ୍ତ ପ୍ରାଣୀଙ୍କ ଭକ୍ଷ୍ୟ ନିମନ୍ତେ ଆମ୍ଭେ ସବୁ ହରିତ୍‍ ଶାକ ଦେଲୁ,” ତହିଁରେ ସେହିପରି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ପରମେଶ୍ୱର ଆପଣା ନିର୍ମିତ ପ୍ରତ୍ୟେକ ବସ୍ତୁ ପ୍ରତି ଦୃଷ୍ଟି କଲେ, ଆଉ ଦେଖ, ସମସ୍ତ ଅତ୍ୟୁତ୍ତମ ହେଲା। ତହିଁରେ ସନ୍ଧ୍ୟା ଓ ପ୍ରାତଃକାଳ ହୋଇ ଷଷ୍ଠ ଦିବସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ଏହିରୂପେ ଆକାଶମଣ୍ଡଳ ଓ ପୃଥିବୀର, ପୁଣି, ସେହି ଦୁଇସ୍ଥିତ ସମସ୍ତ ବସ୍ତୁର ସୃଷ୍ଟି ସମାପ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ପରମେଶ୍ୱର ସପ୍ତମ ଦିନରେ ଆପଣାର କାର୍ଯ୍ୟ ସମାପ୍ତ କରି ସେହି ସପ୍ତମ ଦିନରେ ଆପଣାର କୃତ ସମସ୍ତ କାର୍ଯ୍ୟରୁ ବିଶ୍ରାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ପୁଣି, ପରମେଶ୍ୱର ସପ୍ତମ ଦିନକୁ ଆଶୀର୍ବାଦ କରି ପବିତ୍ର କଲେ। ଯେହେତୁ ସେହି ଦିନରେ ପରମେଶ୍ୱର ସୃଷ୍ଟିକରଣରୂପ ଆପଣାର କୃତ ସମସ୍ତ କାର୍ଯ୍ୟରୁ ବିଶ୍ରାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ସୃଷ୍ଟିକାଳରେ ଆକାଶମଣ୍ଡଳ ଓ ପୃଥିବୀର ବିବରଣ ଏହି। ଯେଉଁ ସମୟରେ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଆକାଶମଣ୍ଡଳ ଓ ପୃଥିବୀ ନିର୍ମାଣ କଲେ, ");
INSERT INTO ory_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ସେହି ସମୟରେ କ୍ଷେତ୍ରରେ କୌଣସି ତୃଣ ନ ଥିଲା ଓ ଭୂମିରେ କୌଣସି ଶାକ ନ ଥିଲା; ଯେହେତୁ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ପୃଥିବୀରେ ବୃଷ୍ଟି କରାଇ ନ ଥିଲେ, ଆଉ କୃଷିକର୍ମ କରିବାକୁ ମନୁଷ୍ୟ ହିଁ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ପୁଣି, ପୃଥିବୀରୁ ଏକ କୁହୁଡ଼ି ଉଠି ସମସ୍ତ ଭୂମିରେ ଜଳ ସିଞ୍ଚିଲା। ");
INSERT INTO ory_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଭୂମିର ଧୂଳି ଦ୍ୱାରା ମନୁଷ୍ୟକୁ ନିର୍ମାଣ କରି ତାହାର ନାସିକାରନ୍ଧ୍ରରେ ଫୁଙ୍କ ଦେଇ ପ୍ରାଣବାୟୁ ପ୍ରବେଶ କରାଇଲେ; ତହିଁରେ ମନୁଷ୍ୟ ଜୀବିତ ପ୍ରାଣୀ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ଆଉ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ପୂର୍ବଦିଗସ୍ଥ ଏଦନ ନାମକ ସ୍ଥାନରେ ଏକ ଉଦ୍ୟାନ ପ୍ରସ୍ତୁତ କରି ସେଠାରେ ସ୍ୱନିର୍ମିତ ମନୁଷ୍ୟକୁ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ସେହି ଭୂମିରୁ ନାନାଜାତୀୟ ସୁଦୃଶ୍ୟ ଓ ସୁଖାଦ୍ୟ ବୃକ୍ଷ, ପୁଣି, ସେହି ଉଦ୍ୟାନର ମଧ୍ୟସ୍ଥାନରେ ଅମୃତ ବୃକ୍ଷ ଓ ସଦସତ୍‍ ଜ୍ଞାନଦାୟକ ବୃକ୍ଷ ଉତ୍ପନ୍ନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ଉଦ୍ୟାନରେ ଜଳସେଚନାର୍ଥେ ଏଦନରୁ ଗୋଟିଏ ନଦୀ ନିର୍ଗତ ହୋଇ ସେହି ସ୍ଥାନରୁ ଭିନ୍ନ ଭିନ୍ନ ଚାରିଧାର ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ପ୍ରଥମ ନଦୀର ନାମ ପିଶୋନ; ତାହା ସ୍ୱର୍ଣ୍ଣୋତ୍ପାଦକ ହବୀଲା ଦେଶସମୂହକୁ ବେଷ୍ଟନ କରେ। ");
INSERT INTO ory_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ସେହି ଦେଶର ସୁବର୍ଣ୍ଣ ଉତ୍ତମ, ପୁଣି, ସେଠାରେ ମୁକ୍ତା ଓ ଗୋମେଦକ ମଣି ଜନ୍ମଇ। ");
INSERT INTO ory_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ଦ୍ୱିତୀୟ ନଦୀର ନାମ ଗୀହୋନ; ଏହା ସମସ୍ତ କୂଶ ଦେଶ ବେଷ୍ଟନ କରେ। ");
INSERT INTO ory_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ତୃତୀୟ ନଦୀର ନାମ ହିଦ୍ଦେକଲ, ଏହା ପୂର୍ବ ଅଶୂରୀୟ ଦେଶର ସମ୍ମୁଖ ଦେଇ ଗମନ କରେ। ଚତୁର୍ଥ ନଦୀର ନାମ ଫରାତ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ପୁଣି, ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ସେହି ମନୁଷ୍ୟକୁ ନେଇ ଏଦନ ଉଦ୍ୟାନକୁ ସୁସଜ୍ଜିତ ଓ ରକ୍ଷା କରିବା ପାଇଁ ନିଯୁକ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ସେହି ମନୁଷ୍ୟକୁ ଆଜ୍ଞା ଦେଇ କହିଲେ, “ତୁମ୍ଭେ ଉଦ୍ୟାନର ସମସ୍ତ ବୃକ୍ଷର ଫଳ ସ୍ୱଚ୍ଛନ୍ଦରେ ଭୋଜନ କରିପାର, ");
INSERT INTO ory_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ମାତ୍ର, ସଦସତ୍‍ ଜ୍ଞାନଦାୟକ ବୃକ୍ଷର ଫଳ ଭୋଜନ କରିବ ନାହିଁ, ଯେହେତୁ ଯେଉଁ ଦିନ ତାହା ଖାଇବ, ସେହି ଦିନ ନିତାନ୍ତ ମରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର କହିଲେ, “ମନୁଷ୍ୟ ଏକାକୀ ଥିବା ଭଲ ନୁହେଁ, ଆମ୍ଭେ ତାହା ନିମନ୍ତେ ତାହାର ଅନୁରୂପ ସହକାରିଣୀ ନିର୍ମାଣ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ଆଉ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଭୂମିରୁ ବିଲର ପଶୁଗଣ ଓ ଖେଚର ପକ୍ଷୀଗଣ ନିର୍ମାଣ କରି ଆଦମ ସେମାନଙ୍କୁ କି ନାମ ଦେବେ, ଏହା ଜାଣିବା ପାଇଁ ସମସ୍ତଙ୍କୁ ତାଙ୍କ ନିକଟକୁ ଆଣିଲେ। ତହିଁରେ ଆଦମ ସେହି ପ୍ରାଣୀବର୍ଗ ମଧ୍ୟରୁ ଯାହାକୁ ଯେଉଁ ନାମ ଦେଲେ, ତାହାର ସେହି ନାମ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ଏହିରୂପେ ଆଦମ ପଶୁ, ଖେଚର ପକ୍ଷୀ ଓ ବିଲର ପ୍ରତ୍ୟେକ ଜନ୍ତୁର ନାମ ଦେଲେ; ମାତ୍ର, ମନୁଷ୍ୟ ନିମନ୍ତେ ତାଙ୍କର ଅନୁରୂପ ସହକାରିଣୀ ଦେଖାଗଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଆଦମଙ୍କୁ ଘୋର ନିଦ୍ରାଗ୍ରସ୍ତ କରାଇ ସେହି ନିଦ୍ରା ସମୟରେ ତାଙ୍କର ଖଣ୍ଡେ ପଞ୍ଜରା ନେଇ ମାଂସ ଦ୍ୱାରା ସେହି ସ୍ଥାନ ପୂର୍ଣ୍ଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ଆଉ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଆଦମଙ୍କଠାରୁ ଯେଉଁ ପଞ୍ଜରା ଖଣ୍ଡିକ ନେଲେ, ତଦ୍ଦ୍ୱାରା ଏକ ସ୍ତ୍ରୀ ନିର୍ମାଣ କରି ଆଦମଙ୍କ ନିକଟକୁ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ତହୁଁ ଆଦମ କହିଲେ, “ଏଥର ହେଲା; ଏ ମୋହର ଅସ୍ଥିର ଅସ୍ଥି ଓ ମାଂସର ମାଂସ; ଏହାର ନାମ ନାରୀ, ଯେହେତୁ ଏ ନରଠାରୁ ନୀତା ହୋଇଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ଏନିମନ୍ତେ ମନୁଷ୍ୟ ଆପଣା ପିତାମାତାଙ୍କୁ ଛାଡ଼ି ଆପଣା ଭାର୍ଯ୍ୟାଠାରେ ଆସକ୍ତ ହେବ, ଆଉ ସେମାନେ ଏକାଙ୍ଗ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ଆଦମ ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟା, ଦୁହେଁ ଉଲଙ୍ଗ ଥିଲେ ହେଁ ସେମାନଙ୍କର ଲଜ୍ଜାବୋଧ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ନିର୍ମିତ ଭୂଚର ପଶୁମାନଙ୍କ ମଧ୍ୟରେ ସର୍ପ ସର୍ବାପେକ୍ଷା ଖଳ ଥିଲା। ସେ ନାରୀଙ୍କୁ କହିଲା, “ଆଗୋ, ଏ କି ସତ୍ୟ, ‘ଉଦ୍ୟାନର କୌଣସି ବୃକ୍ଷର ଫଳ ଖାଇବାକୁ ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କୁ ନିଷେଧ କରିଅଛନ୍ତି?’” ");
INSERT INTO ory_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ନାରୀ ସର୍ପକୁ କହିଲେ, “ଆମ୍ଭେମାନେ ଉଦ୍ୟାନର ସମସ୍ତ ବୃକ୍ଷର ଫଳ ଖାଇପାରୁ; ");
INSERT INTO ory_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","କେବଳ ଉଦ୍ୟାନର ମଧ୍ୟସ୍ଥିତ ବୃକ୍ଷର ଫଳ ବିଷୟରେ ପରମେଶ୍ୱର କହିଅଛନ୍ତି, ‘ତୁମ୍ଭେମାନେ ତାହା ଖାଇବ ନାହିଁ ଓ ଛୁଇଁବ ନାହିଁ, ତାହା କଲେ ମରିବ।’” ");
INSERT INTO ory_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ସର୍ପ ନାରୀଙ୍କୁ କହିଲା, “ତୁମ୍ଭେମାନେ କୌଣସି ରୂପେ ମରିବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ବରଞ୍ଚ ପରମେଶ୍ୱର ଜାଣନ୍ତି, ତୁମ୍ଭେମାନେ ଯେଉଁ ଦିନ ତାହା ଖାଇବ, ସେହି ଦିନ ତୁମ୍ଭମାନଙ୍କ ଚକ୍ଷୁ ପ୍ରସନ୍ନ ହେବ, ତହିଁରେ ତୁମ୍ଭେମାନେ ପରମେଶ୍ୱରଙ୍କ ପରି ଭଲ ଓ ମନ୍ଦର ଜ୍ଞାନ ପାଇବ।” ");
INSERT INTO ory_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ଏଥିରେ ନାରୀ ସେହି ବୃକ୍ଷକୁ ସୁଖାଦ୍ୟର ଉତ୍ପାଦକ ଓ ନୟନର ଲୋଭଜନକ ଓ ଜ୍ଞାନ ଦେବା ନିମିତ୍ତ ବାଞ୍ଛନୀୟ ଦେଖି ତହିଁରୁ ଫଳ ତୋଳି ଖାଇଲେ, ପୁଣି, ଆପଣା ସଙ୍ଗସ୍ଥ ସ୍ୱାମୀଙ୍କୁ ଦିଅନ୍ତେ, ସେ ମଧ୍ୟ ଖାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ତହିଁରେ ସେମାନଙ୍କ ଚକ୍ଷୁ ପ୍ରସନ୍ନ ହୁଅନ୍ତେ, ସେମାନେ ନିଜ ଉଲଙ୍ଗତାର ବୋଧ ପାଇ ଡିମ୍ବିରି ବୃକ୍ଷର ପତ୍ର ସିଁଇ ଘାଗରା ବନାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ତହୁଁ ଦିନାବସାନ ସମୟରେ ଉଦ୍ୟାନ ମଧ୍ୟରେ ଗମନାଗମନକାରୀ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ରବ ଶୁଣି ଆଦମ ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଛାମୁରୁ ଉଦ୍ୟାନସ୍ଥ ବୃକ୍ଷଗଣ ମଧ୍ୟରେ ଲୁଚିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ତହିଁରେ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଆଦମଙ୍କୁ ଡାକି କହିଲେ, “ତୁମ୍ଭେ କେଉଁଠାରେ?” ");
INSERT INTO ory_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ସେ ଉତ୍ତର କଲେ, “ମୁଁ ଉଦ୍ୟାନ ମଧ୍ୟରେ ତୁମ୍ଭ ରବ ଶୁଣି ଆପଣା ଉଲଙ୍ଗତା ସକାଶେ ଭୀତ ହୋଇ ଲୁଚିଲି।” ");
INSERT INTO ory_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ପରମେଶ୍ୱର କହିଲେ, “ତୁମ୍ଭେ ଉଲଙ୍ଗ ଅଛ, ଏହା କିଏ ତୁମ୍ଭକୁ ଜଣାଇଲା? ଆମ୍ଭେ ଯେଉଁ ବୃକ୍ଷର ଫଳ ଖାଇବାକୁ ନିଷେଧ କରିଥିଲୁ, ତାହା କି ତୁମ୍ଭେ ଖାଇଅଛ?” ");
INSERT INTO ory_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ଆଦମ କହିଲେ, “ତୁମ୍ଭେ ଯେଉଁ ସ୍ତ୍ରୀଙ୍କୁ ମୋହର ସଙ୍ଗିନୀ ହେବାକୁ ଦେଇଅଛ, ସେ ମୋତେ ସେହି ବୃକ୍ଷର ଫଳ ଦେଲେ, ତହିଁରେ ମୁଁ ଖାଇଲି।” ");
INSERT INTO ory_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ସେତେବେଳେ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ନାରୀଙ୍କୁ କହିଲେ, “ଏ କି କଲ?” ନାରୀ କହିଲେ, “ସର୍ପ ମୋତେ ଭୁଲାଇଲା, ତହିଁରେ ମୁଁ ଖାଇଲି।” ");
INSERT INTO ory_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ତହୁଁ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ସର୍ପକୁ କହିଲେ, “ଏହି କାର୍ଯ୍ୟ କରିବା ହେତୁ ତୁମ୍ଭେ ସମସ୍ତ ଗ୍ରାମ୍ୟ ଓ ବନ୍ୟପଶୁଠାରୁ ଅଧିକ ଶାପଗ୍ରସ୍ତ ହେଲ, ତୁମ୍ଭେ ଆପଣା ପେଟ ଦେଇ ଗମନ କରିବ ଓ ଯାବଜ୍ଜୀବନ ଧୂଳି ଖାଇବ। ");
INSERT INTO ory_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ଆଉ ଆମ୍ଭେ ତୁମ୍ଭର ଓ ନାରୀର ମଧ୍ୟରେ, ପୁଣି, ତୁମ୍ଭ ବଂଶ ଓ ତାଙ୍କ ବଂଶ ମଧ୍ୟରେ ଶତ୍ରୁତା ଜନ୍ମାଇବା; ସେ ତୁମ୍ଭର ମସ୍ତକକୁ ଆଘାତ କରିବେ ଓ ତୁମ୍ଭେ ତାହାଙ୍କ ଗୋଇଠିକୁ ଆଘାତ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ତହୁଁ ସେ ନାରୀଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭର ଗର୍ଭବେଦନା ଅତିଶୟ ବଢ଼ାଇବା, ତୁମ୍ଭେ ବ୍ୟଥାରେ ସନ୍ତାନ ପ୍ରସବ କରିବ; ପୁଣି, ସ୍ୱାମୀ ପ୍ରତି ତୁମ୍ଭର ବାସନା ରହିବ, ସେ ତୁମ୍ଭ ଉପରେ କର୍ତ୍ତୃତ୍ୱ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ଆଉ ସେ ଆଦମଙ୍କୁ କହିଲେ, “ଯେଉଁ ବୃକ୍ଷର ଫଳ ଖାଇବା ବିଷୟରେ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଆଜ୍ଞା ଦେଇ କହିଥିଲୁ, ତାହା ଖାଇବ ନାହିଁ, ତୁମ୍ଭେ ଆପଣା ଭାର୍ଯ୍ୟାର କଥା ଶୁଣି ତାହା ଖାଇଅଛ; ଏଣୁ ତୁମ୍ଭ ସକାଶୁ ଭୂମି ଶାପଗ୍ରସ୍ତ ହେଲା; ତୁମ୍ଭେ ଯାବଜ୍ଜୀବନ କ୍ଳେଶରେ ତହିଁରୁ ଭକ୍ଷ୍ୟ ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ତହିଁରେ କଣ୍ଟା ଓ ଗୋଖରା ଗଛ ଜାତ ହେବ, ପୁଣି, ତୁମ୍ଭେ କ୍ଷେତ୍ରର ଶାକ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ତୁମ୍ଭେ ଯେଉଁ ମୃତ୍ତିକାରୁ ଗୃହୀତ ହେଲ, ତହିଁରେ ନ ମିଶିବା ପର୍ଯ୍ୟନ୍ତ ମୁଖର ଝାଳରେ ଆହାର କରିବ; ଯେହେତୁ ତୁମ୍ଭେ ଧୂଳି ଓ ଧୂଳିରେ ପୁନର୍ବାର ମିଶିଯିବ।” ");
INSERT INTO ory_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ଏଥିଉତ୍ତାରେ ଆଦମ ଆପଣା ଭାର୍ଯ୍ୟାର ନାମ ହବା ଦେଲେ, ଯେହେତୁ ସେ ଜୀବିତ ଲୋକମାନଙ୍କର ମାତା ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ଆଉ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଚର୍ମର ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କରି ଆଦମ ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟାଙ୍କୁ ପିନ୍ଧାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର କହିଲେ, “ଦେଖ, ମନୁଷ୍ୟ ଭଲ ଓ ମନ୍ଦର ବୋଧ ପ୍ରାପ୍ତ ହୋଇ ଆମ୍ଭମାନଙ୍କ ପରି ଜଣେ ହୋଇଅଛି, ଆଉ ଏବେ ସେ ଯେପରି ହାତ ବଢ଼ାଇ ଅମୃତ ବୃକ୍ଷର ଫଳ ମଧ୍ୟ ତୋଳି ଖାଇ ଅନନ୍ତଜୀବୀ ନ ହୁଅଇ,” ");
INSERT INTO ory_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ଏଥିପାଇଁ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଏଦନ ଉଦ୍ୟାନରୁ ତାଙ୍କୁ ବାହାର କରିଦେଲେ ଓ ସେ ଯେଉଁ ମୃତ୍ତିକାରୁ ନୀତ ହୋଇଥିଲେ, ତହିଁରେ କୃଷିକର୍ମ କରିବାକୁ ତାଙ୍କୁ ନିଯୁକ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ଏହିରୂପେ ସେ ଆଦମଙ୍କୁ ତଡ଼ିଦେଲେ; ପୁଣି, ଅମୃତ ବୃକ୍ଷର ପଥ ରକ୍ଷା କରିବା ନିମିତ୍ତ ଏଦନ ଉଦ୍ୟାନର ପୂର୍ବ ଦିଗରେ କିରୂବଗଣ ଓ ଚତୁର୍ଦ୍ଦିଗରେ ଘୂର୍ଣ୍ଣାୟମାନ ତେଜୋମୟ ଖଡ୍ଗ ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ଏଥିଉତ୍ତାରେ ଆଦମ ଆପଣା ଭାର୍ଯ୍ୟା ହବାଙ୍କର ସହବାସ କରନ୍ତେ, ସେ ଗର୍ଭବତୀ ହୋଇ କୟିନ (ଅର୍ଥାତ୍‍ ଲାଭ) ନାମକ ଗୋଟିଏ ପୁତ୍ର ପ୍ରସବ କରି କହିଲେ, “ସଦାପ୍ରଭୁଙ୍କ ସାହାଯ୍ୟରେ ମୋହର ଏକ ନର ଲାଭ ହୋଇଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ଏଥିଉତ୍ତାରେ ସେ ହେବଲ (ଅର୍ଥାତ୍‍ ଅସ୍ଥାୟୀ) ନାମକ ତାହାର ସହୋଦରକୁ ପ୍ରସବ କଲେ। ଏଥର ହେବଲ ମେଷପାଳକ ଓ କୟିନ କୃଷକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ସମୟାନୁକ୍ରମେ କୟିନ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଭୂମିରୁ ଉତ୍ପନ୍ନ ଫଳ ଆଣି ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ଆଉ ହେବଲ ମଧ୍ୟ ନିଜ ପଲର ପ୍ରଥମଜାତ କେତେକ ପଶୁ ଓ ସେମାନଙ୍କ ମେଦ ଉତ୍ସର୍ଗ କଲେ। ସଦାପ୍ରଭୁ ହେବଲଙ୍କୁ ଓ ତାଙ୍କର ନୈବେଦ୍ୟକୁ ଗ୍ରାହ୍ୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ମାତ୍ର କୟିନଙ୍କୁ ଓ ତାଙ୍କର ନୈବେଦ୍ୟକୁ ସେ ଅଗ୍ରାହ୍ୟ କଲେ। ଏହେତୁ କୟିନ ଅତି କ୍ରୋଧ କରି ଦୁଃଖିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ତହିଁରେ ସଦାପ୍ରଭୁ କୟିନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ କାହିଁକି କ୍ରୋଧ କରୁଅଛ? ଆଉ କାହିଁକି ଦୁଃଖିତ ହେଉଅଛ? ");
INSERT INTO ory_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ସତ୍କର୍ମ କଲେ, କି ତୁମ୍ଭେ ଊର୍ଦ୍ଧ୍ୱମୁଖ ହେବ ନାହିଁ? ସତ୍କର୍ମ ନ କଲେ, ପାପ ଦ୍ୱାରରେ ଛକିଥାଏ; ତୁମ୍ଭ ପ୍ରତି ତାହାର ବାସନା ରହିବ, ମାତ୍ର ତୁମ୍ଭେ ତାହା ଉପରେ କର୍ତ୍ତୃତ୍ୱ କରିବା ଉଚିତ।” ");
INSERT INTO ory_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ଏଥିଉତ୍ତାରେ କୟିନ ଆପଣା ଭାଇ ହେବଲ ସହିତ କଥାବାର୍ତ୍ତା କଲେ। ତହୁଁ ସେମାନେ କ୍ଷେତରେ ଥିବା ବେଳେ କୟିନ ଆପଣା ଭାଇ ହେବଲଙ୍କୁ ଆକ୍ରମଣ କରି ବଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ କୟିନଙ୍କୁ ପଚାରିଲେ, “ତୁମ୍ଭ ଭାଇ ହେବଲ କେଉଁଠାରେ?” ସେ କହିଲେ, “ମୁଁ ଜାଣେ ନାହିଁ, ମୁଁ କʼଣ ମୋʼ ଭାଇର ରକ୍ଷକ?” ");
INSERT INTO ory_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ସେ କହିଲେ, “ତୁମ୍ଭେ କଅଣ କରିଅଛ? ତୁମ୍ଭ ଭାଇର ରକ୍ତ ଭୂମିରୁ ଆମ୍ଭ ପ୍ରତି ଡାକ ପକାଉଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ଏଥିନିମନ୍ତେ ଯେଉଁ ଭୂମି ତୁମ୍ଭ ହସ୍ତରୁ ତୁମ୍ଭ ଭାଇର ରକ୍ତ ଗ୍ରହଣାର୍ଥେ ଆପଣା ମୁଖ ମୁକ୍ତ କରିଅଛି, ସେହି ଭୂମିରେ ଏବେ ତୁମ୍ଭେ ଶାପଗ୍ରସ୍ତ ହେଲ; ");
INSERT INTO ory_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ଭୂମିରେ କୃଷିକର୍ମ କଲେ ହେଁ ତାହା ଆପଣା ଶକ୍ତି ଦେଇ ଆଉ ତୁମ୍ଭର ସେବା କରିବ ନାହିଁ; ତୁମ୍ଭେ ପୃଥିବୀରେ ପଳାତକ ଓ ଭ୍ରମଣକାରୀ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","କୟିନ ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, “ମୋହର ଦଣ୍ଡ ଅସହ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ଦେଖ, ତୁମ୍ଭେ ଆଜି ମୋତେ ଏ ସ୍ଥାନରୁ ତଡ଼ି ଦେଲ, ତହିଁରେ ତୁମ୍ଭ ସମ୍ମୁଖରୁ ମୁଁ ଗୁପ୍ତ ହେବି; ଏହିରୂପେ ପୃଥିବୀରେ ପଳାତକ ଓ ଭ୍ରମଣକାରୀ ହେଲେ ଏପରି ହେବ ଯେ, କୌଣସି ଲୋକ ମୋତେ ପାଇଲେ ବଧ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ଆଉ ସଦାପ୍ରଭୁ ତାଙ୍କୁ କହିଲେ, “ଏହେତୁ କେହି କୟିନଙ୍କୁ ବଧ କଲେ, ତାହାର ସାତ ଗୁଣ ଦଣ୍ଡ ହେବ।” ପୁଣି, କେହି ତାଙ୍କୁ ଦେଖି ଯେପରି ବଧ ନ କରଇ, ଏଥିପାଇଁ ସଦାପ୍ରଭୁ କୟିନଙ୍କ ନିମନ୍ତେ ଏକ ଚିହ୍ନ ନିରୂପଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ଏଥିଉତ୍ତାରେ କୟିନ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରୁ ପ୍ରସ୍ଥାନ କରି ଏଦନର ପୂର୍ବଦିଗସ୍ଥ ନୋଦ ନାମକ ସ୍ଥାନରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ଆଉ କୟିନ ଆପଣା ଭାର୍ଯ୍ୟାର ସହବାସ କରନ୍ତେ, ସେ ଗର୍ଭବତୀ ହୋଇ ହନୋକକୁ ପ୍ରସବ କଲେ; ପୁଣି, ସେ ଏକ ନଗର ନିର୍ମାଣ କରି ଆପଣା ପୁତ୍ରର ନାମାନୁସାରେ ତହିଁର ନାମ ହନୋକ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ସେହି ହନୋକର ପୁତ୍ର ଈରଦ ଓ ଈରଦର ପୁତ୍ର ମହୁୟାୟେଲ ଓ ମହୁୟାୟେଲର ପୁତ୍ର ମଥୁଶାୟେଲ ଓ ମଥୁଶାୟେଲର ପୁତ୍ର ଲେମକ। ");
INSERT INTO ory_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ଏହି ଲେମକ ଦୁଇଟି ସ୍ତ୍ରୀ ବିବାହ କଲେ, ଏକର ନାମ ଆଦା ଓ ଅନ୍ୟର ନାମ ସିଲ୍ଲା ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ଆଦାର ଗର୍ଭରେ ଜାବଳ ଜନ୍ମିଲା, ସେ ତମ୍ବୁନିବାସୀ ପଶୁପାଳକମାନଙ୍କର ଆଦିପୁରୁଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ତାହାର ଭାଇର ନାମ ଯୁବଳ, ସେ ବୀଣା ଓ ବଂଶୀବାଦକମାନଙ୍କର ଆଦିପୁରୁଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ସିଲ୍ଲାର ଗର୍ଭରେ ତୁବଲ୍‍-କୟିନ ଜନ୍ମିଲା, ସେ ପିତ୍ତଳ ଓ ଲୌହର ନାନା ପ୍ରକାର ଅସ୍ତ୍ର ନିର୍ମାଣକାରୀ ଥିଲା; ତୁବଲ୍‍-କୟିନର ନୟମା ନାମ୍ନୀ ଏକ ଭଗ୍ନୀ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ଏଥିଉତ୍ତାରେ ଲେମକ ଆପଣା ଭାର୍ଯ୍ୟାମାନଙ୍କୁ କହିଲେ, “ଆଗୋ ଆଦା ଓ ସିଲ୍ଲା, ମୋʼ କଥା ଶୁଣ; ଆଗୋ ଲେମକର ଭାର୍ଯ୍ୟାଗଣ, ତୁମ୍ଭେମାନେ ମୋʼ ବାକ୍ୟରେ କର୍ଣ୍ଣପାତ କର; ମୁଁ ଆଘାତର ପରିଶୋଧରେ ଜଣେ ମନୁଷ୍ୟକୁ ଓ ପ୍ରହାରର ପରିଶୋଧରେ ଜଣେ ଯୁବାକୁ ବଧ କରିଅଛି; ");
INSERT INTO ory_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ଯଦି କୟିନର ବଧର ପ୍ରତିଫଳ ସାତ ଗୁଣ ହୁଏ, ତେବେ ଲେମକର ପ୍ରତିଫଳ ସତସ୍ତରି ଗୁଣ ନିଶ୍ଚୟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ଏଥିଉତ୍ତାରେ ଆଦମ ପୁନଶ୍ଚ ଆପଣା ଭାର୍ଯ୍ୟାଙ୍କର ସହବାସ କରନ୍ତେ, ସେ ଏକ ପୁତ୍ର ପ୍ରସବ କରି ତାହାର ନାମ ଶେଥ (ଅର୍ଥାତ୍‍ ପ୍ରତିନିଧି) ଦେଲେ; ଯେହେତୁ ସେ କହିଲେ, “ପରମେଶ୍ୱର ହେବଲର ପ୍ରତିନିଧି ରୂପେ ଆଉ ଗୋଟିଏ ପୁତ୍ର ମୋତେ ଦେଇଅଛନ୍ତି, କାରଣ କୟିନ ତାକୁ ବଧ କରିଥିଲା।” ");
INSERT INTO ory_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ତହୁଁ ଶେଥର ମଧ୍ୟ ଏକ ପୁତ୍ର ଜନ୍ମିଲା; ଆଉ ସେ ତାହାର ନାମ ଈନୋଶ ଦେଲା। ଏହି ସମୟରେ ମନୁଷ୍ୟମାନେ ସଦାପ୍ରଭୁଙ୍କ ନାମରେ ପ୍ରାର୍ଥନା କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ଆଦମଙ୍କର ବଂଶାବଳୀର ବୃତ୍ତାନ୍ତ ଏହି। ଯେଉଁ ଦିନ ପରମେଶ୍ୱର ମନୁଷ୍ୟକୁ ସୃଷ୍ଟି କଲେ, ସେହି ଦିନ ପରମେଶ୍ୱରଙ୍କ ସାଦୃଶ୍ୟରେ ସେ ତାଙ୍କୁ ନିର୍ମାଣ କଲେ; ");
INSERT INTO ory_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ପୁରୁଷ ଓ ସ୍ତ୍ରୀ କରି ସେ ସେମାନଙ୍କୁ ସୃଷ୍ଟି କଲେ; ଆଉ ସେମାନେ ସୃଷ୍ଟ ହେବା ଦିନ ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରି ଆଦମ (ମନୁଷ୍ୟ) ନାମ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ଆଦମ ଶହେ ତିରିଶ ବର୍ଷ ବୟସରେ ଆପଣା ସାଦୃଶ୍ୟ ଓ ପ୍ରତିମୂର୍ତ୍ତିରେ ଏକ ପୁତ୍ର ଜାତ କରି ତାହାର ନାମ ଶେଥ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ଶେଥର ଜନ୍ମ ଉତ୍ତାରେ ଆଦମ ଆଠ ଶହ ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ଆଦମଙ୍କର ବୟସ ସର୍ବସୁଦ୍ଧା ନଅ ଶହ ତିରିଶ ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ଶେଥ ଶହେ ପାଞ୍ଚ ବର୍ଷ ବୟସରେ ଈନୋଶକୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ଈନୋଶର ଜନ୍ମ ଉତ୍ତାରେ ଶେଥ ଆଠ ଶହ ସାତ ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ଶେଥର ବୟସ ସର୍ବସୁଦ୍ଧା ନଅ ଶହ ବାର ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ଈନୋଶ ନବେ ବର୍ଷ ବୟସରେ କୟିନାନକୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ପୁଣି, କୟିନାନର ଜନ୍ମ ଉତ୍ତାରେ ସେ ଆଠ ଶହ ପନ୍ଦର ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ଈନୋଶର ବୟସ ସର୍ବସୁଦ୍ଧା ନଅ ଶହ ପାଞ୍ଚ ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","କୟିନାନ ସତୁରି ବର୍ଷ ବୟସରେ ମହଲଲେଲକୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ମହଲଲେଲ ଜନ୍ମିଲା ଉତ୍ତାରେ ସେ ଆଠ ଶହ ଚାଳିଶ ବର୍ଷ ବଞ୍ଚି ଆଉ ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ଆଉ କୟିନାନର ବୟସ ସର୍ବସୁଦ୍ଧା ନଅ ଶହ ଦଶ ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ମହଲଲେଲ ପଞ୍ଚଷଠି ବର୍ଷ ବୟସରେ ଯେରଦକୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ଯେରଦ ଜନ୍ମିଲା ଉତ୍ତାରେ ସେ ଆଠ ଶହ ତିରିଶ ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ମହଲଲେଲର ବୟସ ସର୍ବସୁଦ୍ଧା ଆଠ ଶହ ପଞ୍ଚାନବେ ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ଯେରଦ ଶହେ ବାଷଠି ବର୍ଷ ବୟସରେ ହନୋକଙ୍କୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ହନୋକଙ୍କର ଜନ୍ମ ଉତ୍ତାରେ ସେ ଆଠ ଶହ ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ଯେରଦର ବୟସ ସର୍ବସୁଦ୍ଧା ନଅ ଶହ ବାଷଠି ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ହନୋକ ପଞ୍ଚଷଠି ବର୍ଷ ବୟସରେ ମଥୂଶେଲହକୁ ଜାତ କଲେ; ");
INSERT INTO ory_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ମଥୂଶେଲହର ଜନ୍ମ ଉତ୍ତାରେ ହନୋକ ତିନି ଶହ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ପରମେଶ୍ୱରଙ୍କ ସହିତ ଗମନାଗମନ କଲେ, ପୁଣି, ସେ ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲେ; ");
INSERT INTO ory_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ହନୋକଙ୍କର ବୟସ ସର୍ବସୁଦ୍ଧା ତିନି ଶହ ପଞ୍ଚଷଠି ବର୍ଷ ଥିଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ହନୋକ ପରମେଶ୍ୱରଙ୍କ ସହିତ ଗମନାଗମନ କଲେ; ଆଉ ସେ ଅନ୍ତର୍ହିତ ହେଲେ; ଯେହେତୁ ପରମେଶ୍ୱର ତାଙ୍କୁ ଗ୍ରହଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ମଥୂଶେଲହ ଶହେ ଶତାଅଶୀ ବର୍ଷ ବୟସରେ ଲେମକକୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ଲେମକର ଜନ୍ମ ଉତ୍ତାରେ ମଥୂଶେଲହ ସାତ ଶହ ବୟାଅଶୀ ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ମଥୂଶେଲହର ବୟସ ସର୍ବସୁଦ୍ଧା ନଅ ଶହ ଊଣସ୍ତରି ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ଲେମକ ଶହେ ବୟାଅଶୀ ବର୍ଷ ବୟସରେ ଏକ ପୁତ୍ର ଜାତ କରି ତାହାର ନାମ ନୋହ (ସାନ୍ତ୍ୱନା) ଦେଲେ, ");
INSERT INTO ory_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ଯେହେତୁ ସେ କହିଲେ, “ସଦାପ୍ରଭୁଙ୍କ ଦ୍ୱାରା ଅଭିଶପ୍ତ ଭୂମିରେ ଆମ୍ଭମାନଙ୍କର ଶ୍ରମ ଓ ହସ୍ତର କ୍ଳେଶ ବିଷୟରେ ଏ ଆମ୍ଭମାନଙ୍କର ସାନ୍ତ୍ୱନା ଜନ୍ମାଇବ।” ");
INSERT INTO ory_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ନୋହଙ୍କର ଜନ୍ମ ଉତ୍ତାରେ ଲେମକ ପାଞ୍ଚ ଶହ ପଞ୍ଚାନବେ ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଜାତ କଲେ; ");
INSERT INTO ory_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ତାଙ୍କର ବୟସ ସର୍ବସୁଦ୍ଧା ସାତ ଶହ ସତସ୍ତରି ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ଆଉ ନୋହଙ୍କୁ ପାଞ୍ଚ ଶହ ବର୍ଷ ବୟସ ହେଲା; ଆଉ ନୋହ, ଶେମ ଓ ହାମ ଓ ଯେଫତ୍‍କୁ ଜାତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ଏହିରୂପେ ଯେତେବେଳେ ପୃଥିବୀରେ ମନୁଷ୍ୟମାନଙ୍କ ସଂଖ୍ୟା ବଢ଼ିବାକୁ ଲାଗିଲା ଓ ସେମାନଙ୍କର ଅନେକ କନ୍ୟା ଜାତ ହେଲେ; ");
INSERT INTO ory_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ସେତେବେଳେ ପରମେଶ୍ୱରଙ୍କ ପୁତ୍ରଗଣ ମନୁଷ୍ୟମାନଙ୍କ କନ୍ୟାଗଣକୁ ରୂପବତୀ ଦେଖି, ସେମାନେ ଯେଉଁମାନଙ୍କୁ ପସନ୍ଦ କଲେ, ସେ ସମସ୍ତଙ୍କ ମଧ୍ୟରୁ ବିବାହ କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ତହିଁରେ ସଦାପ୍ରଭୁ କହିଲେ, “ଆମ୍ଭର ଆତ୍ମା ମନୁଷ୍ୟ ଉପରେ ସର୍ବଦା ଅଧିଷ୍ଠାନ କରିବ ନାହିଁ, ଯେହେତୁ ସେମାନଙ୍କ ବିପଥଗମନରେ ସେମାନେ ମାଂସ ମାତ୍ର; ଏଥିନିମନ୍ତେ ସେମାନଙ୍କ ସମୟ ଶହେ କୋଡ଼ିଏ ବର୍ଷ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ସେହି ସମୟରେ ପୃଥିବୀରେ ମହାବୀରଗଣ ଥିଲେ; ପୁଣି, ତହିଁ ଉତ୍ତାରେ ପରମେଶ୍ୱରଙ୍କ ପୁତ୍ରଗଣ ମନୁଷ୍ୟମାନଙ୍କ କନ୍ୟାଗଣର ସହବାସ କରନ୍ତେ, ସେମାନଙ୍କଠାରୁ ସନ୍ତାନଗଣ ଜାତ ହେଲେ; ସେମାନେ ମଧ୍ୟ ପୂର୍ବକାଳର ପ୍ରସିଦ୍ଧ ବୀର ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଦେଖିଲେ ଯେ, ପୃଥିବୀରେ ମନୁଷ୍ୟର ଦୁଷ୍ଟତା ଅତି ବଡ଼, ଆଉ ତାହାର ଅନ୍ତଃକରଣର ଭାବନାର ପ୍ରତ୍ୟେକ କଳ୍ପନା ଅବିରତ ମନ୍ଦ ମାତ୍ର। ");
INSERT INTO ory_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ଏନିମନ୍ତେ ସଦାପ୍ରଭୁ ପୃଥିବୀରେ ମନୁଷ୍ୟକୁ ନିର୍ମାଣ କରିବା ସକାଶୁ ଅନୁତାପ କରି ମନରେ ଶୋକ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ତହିଁରେ ସଦାପ୍ରଭୁ କହିଲେ, “ଆମ୍ଭେ ଭୂମଣ୍ଡଳରୁ ଆପଣାର ସୃଷ୍ଟ ମନୁଷ୍ୟକୁ, ଆଉ ମନୁଷ୍ୟ ସହିତ ପଶୁ ଓ ଉରୋଗାମୀ ଜନ୍ତୁ ଓ ଖେଚର ପକ୍ଷୀଗଣକୁ ଲୁପ୍ତ କରିବା; କାରଣ ଆମ୍ଭେ ସେମାନଙ୍କୁ ନିର୍ମାଣ କରିବାରୁ ଆମ୍ଭର ଅନୁତାପ ହେଉଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ମାତ୍ର, ନୋହ ସଦାପ୍ରଭୁଙ୍କ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହପ୍ରାପ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ନୋହଙ୍କର ବଂଶାବଳୀ ଏହି। ନୋହ ଆପଣା ସେହି ସମୟର ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଧାର୍ମିକ ଓ ସାଧୁ ଲୋକ ଥିଲେ; ନୋହ ପରମେଶ୍ୱରଙ୍କ ସହିତ ଗମନାଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ନୋହ, ଶେମ ଓ ହାମ ଓ ଯେଫତ୍‍, ଏହି ତିନି ପୁତ୍ରଙ୍କୁ ଜାତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ସେହି ସମୟରେ ପୃଥିବୀ ପରମେଶ୍ୱରଙ୍କ ସାକ୍ଷାତରେ ଭ୍ରଷ୍ଟ ଥିଲା ଓ ପୃଥିବୀ ଦୌରାତ୍ମ୍ୟରେ ପରିପୂର୍ଣ୍ଣ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ପୁଣି, ପରମେଶ୍ୱର ପୃଥିବୀରେ ଦୃଷ୍ଟିପାତ କରି ଦେଖିଲେ ଯେ, ତାହା ଭ୍ରଷ୍ଟ ହୋଇଅଛି; ଯେହେତୁ ପୃଥିବୀସ୍ଥ ସମସ୍ତ ପ୍ରାଣୀ ଭ୍ରଷ୍ଟାଚାରୀ ହୋଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ତହୁଁ ପରମେଶ୍ୱର ନୋହଙ୍କୁ କହିଲେ, “ଆମ୍ଭ ଗୋଚରରେ ସମୁଦାୟ ପ୍ରାଣୀର ଅନ୍ତିମକାଳ ଉପସ୍ଥିତ ହେଲା; ଯେହେତୁ ସେମାନଙ୍କ ଦ୍ୱାରା ପୃଥିବୀ ଦୌରାତ୍ମ୍ୟରେ ପରିପୂର୍ଣ୍ଣ ହୋଇଅଛି; ପୁଣି, ଦେଖ, ଆମ୍ଭେ ପୃଥିବୀ ସହିତ ସେମାନଙ୍କୁ ବିନଷ୍ଟ କରିବା। ");
INSERT INTO ory_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ତୁମ୍ଭେ ଆପଣା ନିମନ୍ତେ ଦେବଦାରୁ ଜାତୀୟ ବୃକ୍ଷର କାଷ୍ଠରେ ଗୋଟିଏ ଜାହାଜ ନିର୍ମାଣ କର; ତହିଁ ମଧ୍ୟରେ ନାନା କୋଠରି ବନାଇ ତହିଁର ଭିତର ଓ ବାହାର ଝୁଣା ଦ୍ୱାରା ଲେପନ କର। ");
INSERT INTO ory_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ତାହା ଏହି ପ୍ରକାରେ ନିର୍ମାଣ କରିବ; ଦୀର୍ଘରେ ତିନି ଶହ ହାତ, ପ୍ରସ୍ଥରେ ପଚାଶ ହାତ, ଉଚ୍ଚରେ ତିରିଶ ହାତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ଉପରରୁ ଏକ ହାତ ଛାଡ଼ି ଝରକା କରିବ, ଆଉ ତହିଁର ପାର୍ଶ୍ୱରେ ଦ୍ୱାର ରଖିବ; ଆଉ ତହିଁର ପ୍ରଥମ, ଦ୍ୱିତୀୟ ଓ ତୃତୀୟ ତଳ ବନାଇବ। ");
INSERT INTO ory_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ପୁଣି, ଆକାଶ ତଳେ ପ୍ରାଣବାୟୁ ବିଶିଷ୍ଟ ଯେତେ ଜୀବଜନ୍ତୁ ଅଛନ୍ତି, ସେହି ସବୁ ବିନଷ୍ଟ କରିବା ନିମନ୍ତେ, ଆମ୍ଭେ, ଦେଖ, ଆମ୍ଭେ ପୃଥିବୀ ଉପରେ ଜଳପ୍ଳାବନ କରିବା, ତହିଁରେ ପୃଥିବୀର ସମସ୍ତ ପ୍ରାଣୀ ପ୍ରାଣତ୍ୟାଗ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ମାତ୍ର ଆମ୍ଭେ ତୁମ୍ଭ ସହିତ ଆପଣା ନିୟମ ସ୍ଥିର କରିବା; ତହିଁରେ ତୁମ୍ଭେ ଆପଣା ପୁତ୍ରମାନଙ୍କୁ ଓ ଭାର୍ଯ୍ୟା ଓ ପୁତ୍ରବଧୂମାନଙ୍କୁ ସଙ୍ଗରେ ଘେନି ଜାହାଜରେ ପ୍ରବେଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ପୁଣି, ପ୍ରାଣରକ୍ଷାର୍ଥେ ସର୍ବପ୍ରକାର ଜୀବଜନ୍ତୁର ଏକ ଏକ ଦମ୍ପତି ଆପଣା ସଙ୍ଗରେ ଘେନି ଜାହାଜରେ ପ୍ରବେଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ସର୍ବପ୍ରକାର ପକ୍ଷୀ ଓ ସର୍ବପ୍ରକାର ପଶୁ ଓ ସର୍ବପ୍ରକାର ଉରୋଗାମୀ ଜନ୍ତୁ ପ୍ରତ୍ୟେକ ଜାତି ଅନୁସାରେ ଏକ ଏକ ଦମ୍ପତି ଜୀବନରକ୍ଷାର୍ଥେ ତୁମ୍ଭ ନିକଟକୁ ଆସିବେ। ");
INSERT INTO ory_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ଆଉ ତୁମ୍ଭେ ଆପଣାର ଓ ସେମାନଙ୍କର ଆହାର ନିମନ୍ତେ ସର୍ବପ୍ରକାର ଖାଦ୍ୟସାମଗ୍ରୀ ଆଣି ଆପଣା ନିକଟରେ ସଞ୍ଚୟ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ତହିଁରେ ନୋହ ସେରୂପ କଲେ; ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେ ସମସ୍ତ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ନୋହଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ସପରିବାରରେ ଜାହାଜରେ ପ୍ରବେଶ କର; କାରଣ ଏହି କାଳର ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଆମ୍ଭେ ଆପଣା ସାକ୍ଷାତରେ ତୁମ୍ଭକୁ ଧାର୍ମିକ ଦେଖିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ଆଉ ପୃଥିବୀରେ ବଂଶ ରକ୍ଷା କରିବା ପାଇଁ ପ୍ରତ୍ୟେକ ଶୁଚି ପଶୁଜାତିର ସାତ ସାତ ଦମ୍ପତି ଓ ପ୍ରତ୍ୟେକ ଅଶୁଚି ପଶୁଜାତିର ଏକ ଏକ ଦମ୍ପତି; ");
INSERT INTO ory_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ପ୍ରତ୍ୟେକ ଖେଚର ପକ୍ଷୀଜାତିର ସାତ ସାତ ଦମ୍ପତି ଆପଣା ସଙ୍ଗରେ ନିଅ। ");
INSERT INTO ory_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ଯେହେତୁ ସାତ ଦିନ ଉତ୍ତାରେ ଆମ୍ଭେ ଚାଳିଶ ଦିବାରାତ୍ର ପୃଥିବୀରେ ବୃଷ୍ଟି କରାଇ ପୃଥିବୀସ୍ଥିତ ଆମ୍ଭର ନିର୍ମିତ ସମସ୍ତ ପ୍ରାଣୀକୁ ଲୁପ୍ତ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ନୋହ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସବୁ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ନୋହଙ୍କର ଛଅ ଶହ ବର୍ଷ ବୟସରେ ପୃଥିବୀ ଉପରେ ଜଳପ୍ଳାବନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ତହୁଁ ଜଳପ୍ଳାବନରୁ ରକ୍ଷା ପାଇବା ନିମନ୍ତେ ନୋହ ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟା ଆଉ ପୁତ୍ରଗଣ ଓ ପୁତ୍ରବଧୂଗଣ ଜାହାଜରେ ପ୍ରବେଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ପୁଣି, ନୋହଙ୍କ ପ୍ରତି ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାନୁସାରେ ଶୁଚି ଓ ଅଶୁଚି ପଶୁପକ୍ଷୀବର୍ଗ ଓ ଭୂଚର ଉରୋଗାମୀ ଜନ୍ତୁବର୍ଗ ଯୋଡ଼ା ଯୋଡ଼ା ହୋଇ ");
INSERT INTO ory_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ନୋହଙ୍କ ନିକଟକୁ ଯାଇ ଜାହାଜରେ ପ୍ରବେଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ଆଉ ସେହି ସାତ ଦିନ ଉତ୍ତାରେ ପୃଥିବୀରେ ଜଳପ୍ଳାବନର ଆରମ୍ଭ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ନୋହଙ୍କର ବୟସର ଛଅ ଶହ ବର୍ଷ ଦ୍ୱିତୀୟ ମାସର ସପ୍ତଦଶ ଦିନରେ ମହାସମୁଦ୍ରର ସମସ୍ତ ଜଳାକର ଭାଙ୍ଗିଗଲା, ପୁଣି, ଆକାଶସ୍ଥ ଦ୍ୱାରସବୁ ମୁକ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ତହିଁରେ ଚାଳିଶ ଦିବାରାତ୍ର ପୃଥିବୀରେ ବୃଷ୍ଟି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ସେହି ଦିନରେ ନୋହ, ପୁଣି, ଶେମ ଓ ହାମ ଓ ଯେଫତ୍‍ ନାମକ ନୋହଙ୍କର ପୁତ୍ରମାନେ, ଆଉ ସେମାନଙ୍କ ସହିତ ନୋହଙ୍କର ଭାର୍ଯ୍ୟା ଓ ତିନି ପୁତ୍ରବଧୂ ଜାହାଜରେ ପ୍ରବେଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ପୁଣି, ସବୁ ଜାତୀୟ ଗ୍ରାମ୍ୟ ଓ ବନ୍ୟ ପଶୁ ଓ ସବୁ ଜାତୀୟ ଉରୋଗାମୀ ଓ ସବୁ ଜାତୀୟ ଭୂଚର ଓ ଖେଚର ପକ୍ଷୀ; ");
INSERT INTO ory_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ଅର୍ଥାତ୍‍, ପ୍ରାଣବାୟୁ ବିଶିଷ୍ଟ ସର୍ବପ୍ରକାର ଜୀବଜନ୍ତୁ ଯୋଡ଼ା ଯୋଡ଼ା ହୋଇ ନୋହଙ୍କ ନିକଟକୁ ଯାଇ ଜାହାଜରେ ପ୍ରବେଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାନୁସାରେ ସର୍ବପ୍ରକାର ପ୍ରାଣୀ ଦମ୍ପତିକ୍ରମେ ପ୍ରବେଶ କଲେ; ତହୁଁ ସଦାପ୍ରଭୁ ତାହାର ପାର୍ଶ୍ୱ-ଦ୍ୱାର ବନ୍ଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ଏଥିଉତ୍ତାରେ ଚାଳିଶ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପୃଥିବୀରେ ଜଳପ୍ଳାବନ ହେଲା; ପୁଣି, ଜଳ ବଢ଼ୁ ବଢ଼ୁ ଜାହାଜ ଭୂମିକୁ ଛାଡ଼ି ଭାସି ଉଠିଲା। ");
INSERT INTO ory_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ଆଉ ପୃଥିବୀରେ କ୍ରମଶଃ ଜଳ ପ୍ରବଳ ହୋଇ ଅତିଶୟ ବଢ଼ୁ ବଢ଼ୁ ଜାହାଜ ଜଳ ଉପରେ ଭାସିଲା। ");
INSERT INTO ory_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ପୃଥିବୀ ଉପରେ ଜଳ ଅତିଶୟ ବଢ଼ି ଆକାଶ ତଳସ୍ଥ ସବୁ ଉଚ୍ଚ ପର୍ବତ ମଗ୍ନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ତହିଁ ଉପରେ ପନ୍ଦର ହାତ ପର୍ଯ୍ୟନ୍ତ ଜଳ ଉଠିଲା; ତହୁଁ ପର୍ବତମାନ ମଗ୍ନ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ତେଣୁ ସମଗ୍ର ଭୂଚର ପ୍ରାଣୀ ପ୍ରାଣତ୍ୟାଗ କଲେ, ଅର୍ଥାତ୍‍, ପକ୍ଷୀ, ଗ୍ରାମ୍ୟ ଓ ବନ୍ୟ ପଶୁ ଓ ପୃଥିବୀରେ ଗମନଶୀଳ ଉରୋଗାମୀ ଜନ୍ତୁ ଓ ପ୍ରତ୍ୟେକ ମନୁଷ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ଆଉ ଶୁଷ୍କଭୂମିସ୍ଥ ଯେତେ ପ୍ରାଣୀର ନାସିକାରେ ପ୍ରାଣବାୟୁ ଥିଲା, ସମସ୍ତେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ଏହିରୂପେ ପୃଥିବୀର ଉପରିସ୍ଥ ସମୁଦାୟ ପ୍ରାଣୀ ଲୁପ୍ତ ହେଲେ, ଅର୍ଥାତ୍‍, ମନୁଷ୍ୟ, ପଶୁ, ଉରୋଗାମୀ ଜନ୍ତୁ, ଖେଚର ପକ୍ଷୀ, ସମସ୍ତେ ପୃଥିବୀରୁ ଲୁପ୍ତ ହେଲେ; କେବଳ ନୋହ ଓ ଜାହାଜସ୍ଥ ତାଙ୍କର ସଙ୍ଗୀ ସମସ୍ତେ ବଞ୍ଚିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ଏହିରୂପେ ପୃଥିବୀ ଏକ ଶହ ପଚାଶ ଦିନ ପର୍ଯ୍ୟନ୍ତ ଜଳରେ ବୁଡ଼ି ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ନୋହଙ୍କୁ ଓ ତାଙ୍କ ସହିତ ଜାହାଜସ୍ଥ ପଶ୍ୱାଦି ସମସ୍ତ ପ୍ରାଣୀଙ୍କୁ ସ୍ମରଣ କରି ପୃଥିବୀରେ ବାୟୁ ବୁହାଇଲେ, ତହୁଁ ଜଳ ଥମିଲା; ");
INSERT INTO ory_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ମହାସମୁଦ୍ରର ଜଳାକାର ଓ ଆକାଶସ୍ଥ ଦ୍ୱାରସକଳ ରୁଦ୍ଧ ହେଲା, ପୁଣି, ଆକାଶରୁ ବୃଷ୍ଟି ନିବୃତ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ତହିଁରେ ପୃଥିବୀରୁ ଜଳ ବହିଯାଇ ଏକ ଶହ ପଚାଶ ଦିନର ଶେଷରେ ହ୍ରାସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ଏଥିଉତ୍ତାରେ ସପ୍ତମ ମାସର ସପ୍ତଦଶ ଦିନରେ ଆରାରାଟ୍‍ ପର୍ବତ ଉପରେ ଜାହାଜ ଲାଗି ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ଏହିରୂପେ ଦଶମ ମାସ ପର୍ଯ୍ୟନ୍ତ ଜଳ କ୍ରମଶଃ ଊଣା ପଡ଼ିଲା; ସେହି ଦଶମ ମାସର ପ୍ରଥମ ଦିନରେ ପର୍ବତଗଣର ଶୃଙ୍ଗ ଦେଖାଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ଏଥିଉତ୍ତାରେ ଆଉ ଚାଳିଶ ଦିନ ଉତ୍ତାରେ ନୋହ ସ୍ୱନିର୍ମିତ ଜାହାଜର ଝରକା ଫିଟାଇ ଗୋଟିଏ ଡାମରା କାଉକୁ ଉଡ଼ାଇ ଦେଲେ; ");
INSERT INTO ory_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ତହିଁରେ ପୃଥିବୀର ଜଳ ଶୁଷ୍କ ହେବା ପର୍ଯ୍ୟନ୍ତ ସେ ଏଣେତେଣେ ଗତାୟାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ପୁନଶ୍ଚ, ନୋହ ଭୂମିରେ ଜଳର ହ୍ରାସ ବୁଝିବା ପାଇଁ ଗୋଟିଏ କାପ୍ତା ଉଡ଼ାଇ ଦେଲେ; ");
INSERT INTO ory_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ସେତେବେଳେ ପୃଥିବୀ ଜଳାଚ୍ଛାଦିତ ଥିବାରୁ କାପ୍ତା ଆପଣା ପାଦ ରଖିବାର ସ୍ଥାନ ନ ପାଇ ଜାହାଜରେ ତାଙ୍କ ନିକଟକୁ ନେଉଟି ଆସିଲା; ତହୁଁ ସେ ହାତ ବଢ଼ାଇ ତାକୁ ଧରି ଜାହାଜ ଭିତରେ ଆପଣା ନିକଟକୁ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ଆଉ ସାତ ଦିନ ବିଳମ୍ବ କଲା ଉତ୍ତାରେ ସେ ସେହି କାପ୍ତାକୁ ପୁନର୍ବାର ଜାହାଜରୁ ଉଡ଼ାଇ ଦେଲେ; ");
INSERT INTO ory_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ତହିଁରେ କାପ୍ତା ସନ୍ଧ୍ୟା ବେଳେ ତାଙ୍କ ନିକଟକୁ ଫେରି ଆସିଲା; ଆଉ ଦେଖ, ତାହାର ଚଞ୍ଚୁରେ ଜୀତବୃକ୍ଷର ନବୀନ ପଲ୍ଲବ ଥିଲା; ଏଣୁ ପୃଥିବୀର ଜଳ ହ୍ରାସ ହୋଇଅଛି, ଏହା ନୋହ ଜାଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ଆଉ ସାତ ଦିନ ବିଳମ୍ବ କରି ସେ ସେହି କାପ୍ତାକୁ ପୁନର୍ବାର ଉଡ଼ାଇ ଦେଲେ, ମାତ୍ର ସେ ଆଉ ଥରେ ତାଙ୍କ ନିକଟକୁ ନେଉଟି ଆସିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","(ନୋହଙ୍କ ବୟସର) ଛଅ ଶହ ଏକ ବର୍ଷ ପ୍ରଥମ ମାସର ପ୍ରଥମ ଦିନରେ ପୃଥିବୀ ଉପରୁ ଜଳ ଶୁଷ୍କ ହେଲା; ସେତେବେଳେ ନୋହ ଜାହାଜର ଛାତ ଉଠାଇ ଅନାନ୍ତେ, ଭୂମିକୁ ଶୁଷ୍କ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ଏହିରୂପେ ଦ୍ୱିତୀୟ ମାସର ସତାଇଶ ଦିନରେ ପୃଥିବୀ ଶୁଷ୍କ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ନୋହଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ତୁମ୍ଭେ ଆପଣା ଭାର୍ଯ୍ୟା ଓ ପୁତ୍ରଗଣ ଓ ପୁତ୍ରବଧୂଗଣଙ୍କୁ ସଙ୍ଗେ ଘେନି ଜାହାଜରୁ ବାହାର ହୋଇଯାଅ। ");
INSERT INTO ory_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ପୁଣି, ଆପଣା ସଙ୍ଗେ ଥିବା ପଶୁ, ପକ୍ଷୀ ଓ ଭୂଚର, ଉରୋଗାମୀ ଆଦି ସବୁ ଜୀବଜନ୍ତୁ ବାହାରକୁ ଘେନିଯାଅ; ସେମାନେ ପୃଥିବୀକୁ ପରିପୂର୍ଣ୍ଣ କରନ୍ତୁ, ପୁଣି, ପୃଥିବୀରେ ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ ହେଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ତହୁଁ ନୋହ ଆପଣା ଭାର୍ଯ୍ୟା, ପୁତ୍ର ଓ ପୁତ୍ରବଧୂମାନଙ୍କୁ ସଙ୍ଗରେ ଘେନି ବାହାରକୁ ଆସିଲେ; ");
INSERT INTO ory_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ପୁଣି, ସ୍ୱ ସ୍ୱ ଜାତି ଅନୁସାରେ ପ୍ରତ୍ୟେକ ପଶୁ, ପ୍ରତ୍ୟେକ ଉରୋଗାମୀ ଜନ୍ତୁ ଓ ପ୍ରତ୍ୟେକ ପକ୍ଷୀ ପ୍ରଭୃତି ସମସ୍ତ ଭୂଚର ପ୍ରାଣୀ ଜାହାଜରୁ ବାହାରି ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ଏଥିଉତ୍ତାରେ ନୋହ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କଲେ, ପୁଣି, ସର୍ବପ୍ରକାର ଶୁଚି ପଶୁ ଓ ଶୁଚି ପକ୍ଷୀଗଣ ମଧ୍ୟରୁ କେତେକ ନେଇ ବେଦି ଉପରେ ହୋମବଳି ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ତହିଁରେ ସଦାପ୍ରଭୁ ତହିଁର ସୁଗନ୍ଧ ଆଘ୍ରାଣ କରି ମନେ ମନେ କହିଲେ, “ଆମ୍ଭେ ମନୁଷ୍ୟ ସକାଶୁ ଆଉ ପୃଥିବୀକୁ ଅଭିଶାପ ଦେବା ନାହିଁ; ଯଦ୍ୟପି ବାଲ୍ୟକାଳଠାରୁ ମନୁଷ୍ୟ ମନର କଳ୍ପନା ମନ୍ଦ, ତଥାପି ଆମ୍ଭେ ଯେପରି କରିଅଛୁ, ସେହିପରି ଆଉ ଥରେ କେବେ ହେଁ ସବୁ ପ୍ରାଣୀଙ୍କୁ ବିନଷ୍ଟ କରିବା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ପୁଣି, ଯେପର୍ଯ୍ୟନ୍ତ ପୃଥିବୀ ଥିବ, ସେପର୍ଯ୍ୟନ୍ତ ବୁଣାକଟାର ସମୟ, ଶୀତ ଓ ଗ୍ରୀଷ୍ମ, ପୁଣି, ଗ୍ରୀଷ୍ମ ଓ ଶୀତକାଳ, ଆଉ ଦିବସ ଓ ରାତ୍ରି, ଏହିସବୁର ନିବୃତ୍ତି ହେବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ନୋହ ଓ ତାଙ୍କ ପୁତ୍ରମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରି କହିଲେ, “ତୁମ୍ଭେମାନେ ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ ହୋଇ ପୃଥିବୀକୁ ପରିପୂର୍ଣ୍ଣ କର। ");
INSERT INTO ory_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ପୃଥିବୀସ୍ଥ ସମସ୍ତ ପଶୁ ଓ ଖେଚର ପକ୍ଷୀ ଓ ଭୂଚର ଓ ଉରୋଗାମୀ ଜନ୍ତୁ ଓ ସମୁଦ୍ରର ମତ୍ସ୍ୟ, ସମସ୍ତେ ତୁମ୍ଭମାନଙ୍କଠାରୁ ଭୀତ ଓ ଶଙ୍କାଯୁକ୍ତ ହେବେ; ସେହି ସମସ୍ତ ତୁମ୍ଭମାନଙ୍କ ହସ୍ତରେ ସମର୍ପିତ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ପ୍ରତ୍ୟେକ ଗମନଶୀଳ ପ୍ରାଣୀ ତୁମ୍ଭମାନଙ୍କର ଖାଦ୍ୟ ହେବ, ଆମ୍ଭେ ହରିତ୍‍ ଶାକ ପରି ଏହି ସମସ୍ତ ତୁମ୍ଭମାନଙ୍କୁ ଦେଲୁ। ");
INSERT INTO ory_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ମାତ୍ର ତୁମ୍ଭେମାନେ ସପ୍ରାଣ (ଅର୍ଥାତ୍‍) ସରକ୍ତ ମାଂସ ଖାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଜୀବନରୂପ ରକ୍ତପାତର ପରିଶୋଧ ନିତାନ୍ତ ନେବା; ପ୍ରତ୍ୟେକ ପଶୁଠାରୁ ହେଉ କି ମନୁଷ୍ୟଠାରୁ ହେଉ, ତାହାରି ପରିଶୋଧ ନେବା; ଆମ୍ଭେ ପ୍ରତ୍ୟେକ ମନୁଷ୍ୟର ଭ୍ରାତାଠାରୁ ମନୁଷ୍ୟର ପ୍ରାଣର ପରିଶୋଧ ନେବା। ");
INSERT INTO ory_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ଯେକେହି ମନୁଷ୍ୟର ରକ୍ତପାତ କରିବ, ମନୁଷ୍ୟ ଦ୍ୱାରା ତାହାର ରକ୍ତପାତ କରାଯିବ; ଯେହେତୁ ପରମେଶ୍ୱର ଆପଣା ପ୍ରତିମୂର୍ତ୍ତିରେ ମନୁଷ୍ୟକୁ ନିର୍ମାଣ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ତୁମ୍ଭେମାନେ ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ ହୁଅ, ଆଉ ପୃଥିବୀକୁ ପରିପୂର୍ଣ୍ଣ କରି ବର୍ଦ୍ଧିଷ୍ଣୁ ହୁଅ।” ");
INSERT INTO ory_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ନୋହଙ୍କୁ ଓ ତାଙ୍କର ସଙ୍ଗୀ ପୁତ୍ରମାନଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ଦେଖ, ତୁମ୍ଭମାନଙ୍କ ସହିତ ଓ ତୁମ୍ଭମାନଙ୍କ ଭବିଷ୍ୟତ ବଂଶ ସହିତ ଓ ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗୀ ସମସ୍ତ ଜୀବଜନ୍ତୁ ସହିତ, ");
INSERT INTO ory_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ଅର୍ଥାତ୍‍, ଜାହାଜରୁ ବହିର୍ଗତ ଗ୍ରାମ୍ୟ ଓ ବନ୍ୟ ପଶୁ ଓ ପକ୍ଷୀ ପ୍ରଭୃତି ପୃଥିବୀସ୍ଥ ସମସ୍ତ ପ୍ରାଣୀ ସହିତ ଆମ୍ଭେ ଆପଣା ନିୟମ ସ୍ଥିର କରୁଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ସହିତ ଏହି ନିୟମ ସ୍ଥିର କରିବୁ, ସମସ୍ତ ପ୍ରାଣୀ ଜଳପ୍ଳାବନ ଦ୍ୱାରା ଆଉ ଉଚ୍ଛିନ୍ନ ହେବେ ନାହିଁ; ପୁଣି, ପୃଥିବୀକୁ ବିନାଶ କରିବା ପାଇଁ ଆଉ ଜଳପ୍ଳାବନ ହେବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ପୁନଶ୍ଚ, ପରମେଶ୍ୱର କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ସହିତ ଓ ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗୀ ସମସ୍ତ ପ୍ରାଣୀବର୍ଗ ସହିତ ପୁରୁଷାନୁକ୍ରମେ ଅନନ୍ତକାଳ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁ ନିୟମ ସ୍ଥିର କଲୁ, ତହିଁର ଚିହ୍ନ ଏହି; ");
INSERT INTO ory_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ଆମ୍ଭେ ମେଘରେ ଆପଣା ଧନୁ ସ୍ଥାପନ କରୁଅଛୁ, ତାହା ପୃଥିବୀ ସହିତ ଆମ୍ଭ ନିୟମର ଚିହ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ଯେତେବେଳେ ଆମ୍ଭେ ପୃଥିବୀ ଉପରେ ମେଘ ସଞ୍ଚାର କରିବା, ସେତେବେଳେ ସେହି ଧନୁ ମେଘରେ ଦେଖାଯିବ; ");
INSERT INTO ory_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ତହିଁରେ ତୁମ୍ଭମାନଙ୍କ ସହିତ ଓ ମାଂସବିଶିଷ୍ଟ ସମୁଦାୟ ପ୍ରାଣୀ ସହିତ ଆମ୍ଭର ଯେଉଁ ନିୟମ ଅଛି, ତାହା ଆମ୍ଭର ସ୍ମରଣ ହେବ, ତହିଁରେ ସବୁ ପ୍ରାଣୀର ବିନାଶାର୍ଥେ ଜଳପ୍ଳାବନ ଆଉ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ପୁଣି, ମେଘଧନୁ ହେଲେ, ଆମ୍ଭେ ତାହା ପ୍ରତି ଦୃଷ୍ଟିପାତ କରିବା, ତହିଁରେ ପୃଥିବୀସ୍ଥ ମାଂସବିଶିଷ୍ଟ ସମସ୍ତ ପ୍ରାଣୀ ସହିତ ପରମେଶ୍ୱରଙ୍କର ଯେଉଁ ଅନନ୍ତକାଳସ୍ଥାୟୀ ନିୟମ ଅଛି, ତାହା ଆମ୍ଭେ ସ୍ମରଣ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ପରମେଶ୍ୱର ନୋହଙ୍କୁ କହିଲେ, “ପୃଥିବୀସ୍ଥ ମାଂସବିଶିଷ୍ଟ ସମସ୍ତ ପ୍ରାଣୀ ସହିତ ଆମ୍ଭେ ଯେଉଁ ନିୟମ ସ୍ଥିର କରିଅଛୁ, ତହିଁର ଏହି ଚିହ୍ନ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ନୋହଙ୍କର ଯେଉଁ ପୁତ୍ରମାନେ ଜାହାଜରୁ ବହିର୍ଗତ ହେଲେ, ସେମାନଙ୍କ ନାମ ଶେମ ଓ ହାମ ଓ ଯେଫତ୍‍; ହାମ କିଣାନର ପିତା। ");
INSERT INTO ory_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ଏହି ତିନି ଜଣ ନୋହଙ୍କର ପୁତ୍ର; ଏମାନଙ୍କ ବଂଶସବୁ ପୃଥିବୀରେ ବ୍ୟାପ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ଏଥିଉତ୍ତାରେ ନୋହ କୃଷି କର୍ମରେ ପ୍ରବୃତ୍ତ ହୋଇ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ର କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ତହିଁରେ ସେ ଦ୍ରାକ୍ଷାରସ ପାନ କରି ମତ୍ତ ହୋଇ ତମ୍ବୁ ମଧ୍ୟରେ ବିବସ୍ତ୍ର ହୋଇ ପଡ଼ିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ଏପରି ସମୟରେ କିଣାନର ପିତା ହାମ ଆପଣା ପିତାଙ୍କର ଉଲଙ୍ଗତା ଦେଖି ବାହାରେ ଆପଣା ଦୁଇ ଭାଇଙ୍କୁ ସମାଚାର ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ସେତେବେଳେ ଶେମ ଓ ଯେଫତ୍‍ ସ୍କନ୍ଧରେ ବସ୍ତ୍ର ଘେନି ପଶ୍ଚାଦ୍‍ଗତି କରି ଆପଣାମାନଙ୍କ ପିତାଙ୍କର ଉଲଙ୍ଗତା ଆଚ୍ଛାଦନ କଲେ; ସେମାନେ ପଛଆଡ଼କୁ ମୁଖ ରଖି ଯିବାରୁ ପିତାଙ୍କର ଉଲଙ୍ଗତା ଦେଖିଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ଏଉତ୍ତାରୁ ନୋହ ଦ୍ରାକ୍ଷାରସର ନିଦ୍ରାରୁ ଜାଗ୍ରତ ହୋଇ ଆପଣା ପ୍ରତି କନିଷ୍ଠ ପୁତ୍ରର ଆଚରଣ ଜ୍ଞାତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ପୁଣି, ସେ କହିଲେ, “କିଣାନ ଶାପଗ୍ରସ୍ତ ହେଉ; ସେ ଆପଣା ଭ୍ରାତୃଗଣର ଦାସାନୁଦାସ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ଆଉ ସେ କହିଲେ, “ଶେମର ପରମେଶ୍ୱର ସଦାପ୍ରଭୁ ଧନ୍ୟ ହେଉନ୍ତୁ; କିଣାନ ଶେମର ଦାସ ହେଉ। ");
INSERT INTO ory_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ପରମେଶ୍ୱର ଯେଫତ୍‍କୁ ବର୍ଦ୍ଧିଷ୍ଣୁ କରନ୍ତୁ; ପୁଣି, ସେ ଶେମର ତମ୍ବୁରେ ବାସ କରୁ; ଆଉ କିଣାନ ତାହାର ଦାସ ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ଜଳପ୍ଳାବନ ଉତ୍ତାରେ ନୋହ ଆଉ ତିନି ଶହ ପଚାଶ ବର୍ଷ ବଞ୍ଚିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ପୁଣି, ନୋହଙ୍କର ବୟସ ସର୍ବସୁଦ୍ଧା ନଅ ଶହ ପଚାଶ ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ଶେମ, ହାମ, ଯେଫତ୍‍ ନାମକ ନୋହଙ୍କର ପୁତ୍ରମାନଙ୍କ ବଂଶାବଳୀ ଏହି। ଜଳପ୍ଳାବନ ପରେ ସେମାନଙ୍କର ଏହି ସମସ୍ତ ସନ୍ତାନ ଜନ୍ମିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ଗୋମର, ମାଗୋଗ୍‍, ମାଦୟ, ଯବନ, ତୁବଲ୍‍, ମେଶକ୍‍ ଓ ତୀରସ୍‍, ଏମାନେ ଯେଫତ୍‍ର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ଅସ୍କିନସ୍‍ ଓ ରୀଫତ୍‍ ଓ ତୋଗର୍ମା, ଏମାନେ ଗୋମରର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ପୁଣି, ଇଲୀଶା ଓ ତର୍ଶୀଶ ଓ କିତ୍ତୀମ ଓ ଦୋଦାନୀମ, ଏମାନେ ଯବନର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ଏମାନଙ୍କଠାରୁ ଅନ୍ୟଦେଶୀୟମାନଙ୍କର ଦ୍ୱୀପନିବାସୀଗଣ ଆପଣାମାନଙ୍କ ଦେଶବିଦେଶରେ ସ୍ୱ ସ୍ୱ ଭାଷାନୁସାରେ ବ୍ୟାପ୍ତ ହୋଇ ଆପଣା ଆପଣା ବଂଶ ଓ ଗୋଷ୍ଠୀ ଅନୁସାରେ ବିଭକ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","କୂଶ, ମିସର, ପୂଟ୍‍ ଓ କିଣାନ, ଏମାନେ ହାମର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ସବା, ହବୀଲା, ସପ୍ତା, ରୟମା ଓ ସପ୍ତକା, ଏମାନେ କୂଶର ସନ୍ତାନ। ଶିବା ଓ ଦଦାନ, ଏମାନେ ରୟମାର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ନିମ୍ରୋଦ୍‍ କୂଶର ପୁତ୍ର; ସେ ପୃଥିବୀ ମଧ୍ୟରେ ପରାକ୍ରମୀ ହେବାକୁ ଲାଗିଲା। ");
INSERT INTO ory_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ସେ ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ପରାକ୍ରାନ୍ତ ବ୍ୟାଧ ହେଲା; ଏଣୁ ଲୋକମାନେ ଏପର୍ଯ୍ୟନ୍ତ ଏହି ଦୃଷ୍ଟାନ୍ତ କହନ୍ତି, “ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ପରାକ୍ରାନ୍ତ ବ୍ୟାଧ ନିମ୍ରୋଦ୍‍ ତୁଲ୍ୟ।” ");
INSERT INTO ory_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ପୁଣି, ଶିନୀୟର ଦେଶରେ ବାବିଲ ଓ ଏରକ ଓ ଅକ୍କଦ୍‍ ଓ କଲନେ, ଏହିସବୁ ନଗର ତାହାର ପ୍ରଥମ ରାଜ୍ୟ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ସେହି ଦେଶରୁ ଅଶୂର ନିର୍ଗତ ହୋଇ ନୀନିବୀ ଓ ରହୋବୋତ୍‍-ପୁରୀ ଓ କେଲହ, ");
INSERT INTO ory_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ପୁଣି, ନୀନିବୀ ଓ କେଲହର ମଧ୍ୟସ୍ଥିତ ରେଷନ୍‍ ନଗର ସ୍ଥାପନ କଲା; ଏହି ରେଷନ୍‍ ମହାନଗର। ");
INSERT INTO ory_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ପୁଣି, ଲୁଦୀୟ ଓ ଅନାମୀୟ ଓ ଲହାବୀୟ ଓ ନପ୍ତୂହୀୟ ");
INSERT INTO ory_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ଓ ପଥ୍ରୋଷୀୟ ଓ ପଲେଷ୍ଟୀୟମାନଙ୍କ ଆଦିପୁରୁଷ କସ୍ଲୁହୀୟ ଓ କପ୍ତୋରୀୟ, ଏମାନେ ମିସରର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ପୁଣି, କିଣାନର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ସୀଦୋନ, ତାହା ଉତ୍ତାରେ ହେତ୍ ");
INSERT INTO ory_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ଓ ଯିବୂଷୀୟ ଓ ଇମୋରୀୟ ଓ ଗିର୍ଗାଶୀୟ ");
INSERT INTO ory_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ଓ ହିବ୍ବୀୟ ଓ ଅର୍କୀୟ ଓ ସିନୀୟ ");
INSERT INTO ory_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ଓ ଅର୍ବଦୀୟ ଓ ସମାରୀୟ ଓ ହମାତୀୟ; ଏଥିଉତ୍ତାରେ କିଣାନୀୟମାନଙ୍କ ବଂଶ ବ୍ୟାପିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ତହିଁରେ ସୀଦୋନଠାରୁ ଗରାର ଦିଗକୁ ଘସା ପର୍ଯ୍ୟନ୍ତ, ପୁଣି, ସଦୋମ ଓ ହମୋରା ଓ ଅଦ୍ମା ଓ ସବୋୟୀମ ଦିଗରେ ଲେଶା ପର୍ଯ୍ୟନ୍ତ କିଣାନୀୟମାନଙ୍କ (ବସତିର) ସୀମା ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ଆପଣା ଆପଣା ଦେଶ ଓ ଗୋଷ୍ଠୀରେ ସେମାନଙ୍କ ବଂଶ ଓ ଭାଷାନୁସାରେ ଏସମସ୍ତେ ହାମର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ଯେଫତ୍‍ର ଜ୍ୟେଷ୍ଠ ଭ୍ରାତା ଶେମର ମଧ୍ୟ ସନ୍ତାନସନ୍ତତି ଥିଲେ, ଅର୍ଥାତ୍‍, ସେ ଏବରର ସନ୍ତାନମାନଙ୍କ ଆଦିପୁରୁଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ଶେମର ଏହିସବୁ ସନ୍ତାନ, ଏଲମ୍‍ ଓ ଅଶୂର ଓ ଅର୍ଫକ୍ଷଦ ଓ ଲୁଦ୍‍ ଓ ଅରାମ। ");
INSERT INTO ory_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ଏହି ଅରାମର ସନ୍ତାନ ଊଷ୍‍ ଓ ହୂଲ ଓ ଗେଥର ଓ ମଶ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ପୁଣି, ଅର୍ଫକ୍ଷଦର ସନ୍ତାନ ଶେଲହ ଓ ଶେଲହର ସନ୍ତାନ ଏବର। ");
INSERT INTO ory_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ଏହି ଏବରର ଦୁଇ ପୁତ୍ର; ଏକର ନାମ ପେଲଗ୍‍ (ବିଭାଗ), କାରଣ ସେହି ସମୟରେ ପୃଥିବୀ ବିଭକ୍ତ ହେଲା; ତାହାର ଭ୍ରାତାର ନାମ ଯକ୍ତନ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ପୁଣି, ଯକ୍ତନ୍‍ର ପୁତ୍ର ଅଲ୍‍ମୋଦଦ ଓ ଶେଲଫ୍‍ ଓ ହତ୍‍ସର୍ମାବତ୍‍ ଓ ଯେରହ ");
INSERT INTO ory_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ଓ ହଦୋରାମ ଓ ଊଷଲ ଓ ଦିକ୍ଲା ");
INSERT INTO ory_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ଓ ଓବଲ ଓ ଅବୀମାୟେଲ୍ ଓ ଶିବା ");
INSERT INTO ory_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ଓ ଓଫୀର ଓ ହବୀଲା ଓ ଯୋବବ୍‍, ଏହି ସମସ୍ତ ଯକ୍ତନ୍‍ର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ମେଷା ଅବଧି ପୂର୍ବ ଦିଗର ସଫାର ପର୍ବତ ପର୍ଯ୍ୟନ୍ତ ସେମାନଙ୍କର ବସତି ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ଆପଣା ଆପଣା ଦେଶରେ ସେମାନଙ୍କର ବଂଶ ଓ ଭାଷା ଓ ଗୋଷ୍ଠୀ ଅନୁସାରେ ଏସମସ୍ତେ ଶେମର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ଆପଣା ଆପଣା ଗୋଷ୍ଠୀରେ ସେମାନଙ୍କ ବଂଶାବଳୀ ଅନୁସାରେ ଏମାନେ ନୋହଙ୍କର ସନ୍ତାନଗଣର ବଂଶ ଥିଲେ; ପୁଣି, ଜଳପ୍ଳାବନ ଉତ୍ତାରେ ଏମାନଙ୍କଠାରୁ ଉତ୍ପନ୍ନ ନାନା ଗୋଷ୍ଠୀ ପୃଥିବୀରେ ବିଭକ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ପୂର୍ବେ ସମୁଦାୟ ପୃଥିବୀରେ ଏକ ଭାଷା ଓ ଏକରୂପ ଉଚ୍ଚାରଣ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ଆଉ ଘଟଣାକ୍ରମେ ଲୋକମାନେ ପୂର୍ବ ଦିଗରେ ଭ୍ରମଣ କରୁ କରୁ ଶିନୀୟର ଦେଶରେ ଏକ ପ୍ରାନ୍ତର ପାଇ ସେଠାରେ ବସତି କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ଏଥିଉତ୍ତାରେ ସେମାନେ ପରସ୍ପର କହିଲେ, “ଆସ, ଆମ୍ଭେମାନେ ଇଟା ବନାଇ ଉତ୍ତମ ରୂପେ ପୋଡ଼ି ଦେଉ।” ତହିଁରେ ଇଟା ସେମାନଙ୍କର ପ୍ରସ୍ତର ସ୍ୱରୂପ ଓ ମାଟିଆ ତେଲ ସେମାନଙ୍କର ଚୂନ ସ୍ୱରୂପ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ପୁଣି, ସେମାନେ କହିଲେ, “ଆସ, ଆମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ପାଇଁ ଗୋଟିଏ ନଗର ଓ ଗଗନସ୍ପର୍ଶୀ ଏକ ଉଚ୍ଚ ଗଡ଼ ନିର୍ମାଣ କରୁ; ତହିଁରେ ଆମ୍ଭମାନଙ୍କର ନାମ ବିଖ୍ୟାତ ହେବ, ପୁଣି, ଆମ୍ଭେମାନେ ସମୁଦାୟ ପୃଥିବୀରେ ଛିନ୍ନଭିନ୍ନ ହେବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ଏଥିଉତ୍ତାରେ ମନୁଷ୍ୟ-ସନ୍ତାନମାନେ ଯେଉଁ ନଗର ଓ ଗଡ଼ ନିର୍ମାଣ କରୁଥିଲେ, ତାହା ଦେଖିବାକୁ ସଦାପ୍ରଭୁ ଓହ୍ଲାଇ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ପୁଣି, ସଦାପ୍ରଭୁ କହିଲେ, “ଦେଖ, ଏହି ଲୋକ ସମସ୍ତେ ଏକ ଓ ଏମାନଙ୍କର ଭାଷା ହିଁ ଏକ, ଆଉ ଏବେ ଏମାନେ ଏହି କାର୍ଯ୍ୟରେ ପ୍ରବୃତ୍ତ ହେଉଅଛନ୍ତି; ଏଥିଉତ୍ତାରେ ଯାହା ଯାହା କରିବାକୁ ମନସ୍ଥ କରନ୍ତି, ତହିଁରୁ ନିବାରିତ ହେବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ଏଥିପାଇଁ ସେମାନେ ଯେପରି ପରସ୍ପର ଭାଷା ବୁଝି ନ ପାରନ୍ତି, ଏଥିପାଇଁ ଆସ, ଆମ୍ଭେମାନେ ଓହ୍ଲାଇ ଯାଇ ସେହି ସ୍ଥାନରେ ସେମାନଙ୍କ ଭାଷାର ଭେଦ ଜନ୍ମାଉ।” ");
INSERT INTO ory_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ଏହିରୂପେ ସଦାପ୍ରଭୁ ସେହି ସ୍ଥାନରୁ ସେମାନଙ୍କୁ ପୃଥିବୀର ସବୁଆଡ଼େ ଛିନ୍ନଭିନ୍ନ କଲେ; ଏଣୁ ସେମାନେ ନଗର ନିର୍ମାଣ କରିବାରୁ ନିବୃତ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ସେଥିପାଇଁ ସେହି ନଗରର ନାମ ବାବିଲ (ଭେଦ) ହେଲା; ଯେହେତୁ ସଦାପ୍ରଭୁ ସେହି ସ୍ଥାନରେ ସମସ୍ତ ପୃଥିବୀର ଭାଷାଭେଦ ଜନ୍ମାଇଲେ, ପୁଣି, ସେହି ସ୍ଥାନରୁ ସେମାନଙ୍କୁ ସମୁଦାୟ ପୃଥିବୀରେ ଛିନ୍ନଭିନ୍ନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ଶେମର ବଂଶାବଳୀ ଏହି। ଜଳପ୍ଳାବନର ଦୁଇ ବର୍ଷ ଉତ୍ତାରେ ଶେମ ଶହେ ବର୍ଷ ବୟସରେ ଅର୍ଫକ୍ଷଦକୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ଅର୍ଫକ୍ଷଦ ଜନ୍ମିଲା ଉତ୍ତାରେ ଶେମ ପାଞ୍ଚ ଶହ ବର୍ଷ ବଞ୍ଚି ଆଉ ସନ୍ତାନସନ୍ତତି ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ପୁଣି, ଅର୍ଫକ୍ଷଦ ପଞ୍ଚତିରିଶ ବର୍ଷ ବୟସରେ ଶେଲହକୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ଶେଲହର ଜନ୍ମ ଉତ୍ତାରେ ଅର୍ଫକ୍ଷଦ ଚାରି ଶହ ତିନି ବର୍ଷ ଜୀବିତ ରହି ଆଉ ପୁତ୍ରକନ୍ୟା ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ପୁଣି, ଶେଲହ ତିରିଶ ବର୍ଷ ବୟସରେ ଏବରକୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ଏବରର ଜନ୍ମ ଉତ୍ତାରେ ଶେଲହ ଚାରି ଶହ ତିନି ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟା ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ପୁଣି, ଏବର ଚୌତ୍ରିଶ ବର୍ଷ ବୟସରେ ପେଲଗ୍‌କୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ପେଲଗ୍‌ର ଜନ୍ମ ଉତ୍ତାରେ ଏବର ଚାରି ଶହ ତିରିଶ ବର୍ଷ ବଞ୍ଚି ଆହୁରି ପୁତ୍ରକନ୍ୟା ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ପେଲଗ୍‍ ତିରିଶ ବର୍ଷ ବୟସରେ ରୀୟୂକୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ରୀୟୂର ଜନ୍ମ ଉତ୍ତାରେ ପେଲଗ୍‍ ଦୁଇ ଶହ ନଅ ବର୍ଷ ବଞ୍ଚି ଆଉ ପୁତ୍ରକନ୍ୟା ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ରୀୟୂ ବତିଶ ବର୍ଷ ବୟସରେ ସରୁଗକୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ସରୁଗର ଜନ୍ମ ଉତ୍ତାରେ ରୀୟୂ ଦୁଇ ଶହ ସାତ ବର୍ଷ ବଞ୍ଚି ଆଉ ପୁତ୍ରକନ୍ୟା ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ପୁଣି, ସରୁଗ ତିରିଶ ବର୍ଷ ବୟସରେ ନାହୋରକୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ନାହୋରର ଜନ୍ମ ଉତ୍ତାରେ ସରୁଗ ଦୁଇ ଶହ ବର୍ଷ ବଞ୍ଚି ଆଉ ପୁତ୍ରକନ୍ୟା ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ପୁଣି, ନାହୋର ଅଣତିରିଶ ବର୍ଷ ବୟସରେ ତେରହକୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ତେରହର ଜନ୍ମ ଉତ୍ତାରେ ନାହୋର ଶହେ ଊଣେଇଶ ବର୍ଷ ବଞ୍ଚି ଆଉ ପୁତ୍ରକନ୍ୟା ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ପୁଣି, ତେରହକୁ ସତୁରି ବର୍ଷ ବୟସ ହେଲା। ସେ ଅବ୍ରାମ ଓ ନାହୋର ଓ ହାରଣ, ଏମାନଙ୍କୁ ଜାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ତେରହର ବଂଶାବଳୀ। ତେରହ ଅବ୍ରାମ ଓ ନାହୋର ଓ ହାରଣକୁ ଜାତ କଲା। ପୁଣି, ସେହି ହାରଣ ଲୋଟକୁ ଜାତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ମାତ୍ର ହାରଣ ଆପଣା ପିତା ତେରହର ସାକ୍ଷାତରେ କଲ୍‍ଦୀୟମାନଙ୍କ ଊର ନାମକ ଆପଣା ଜନ୍ମ ଦେଶରେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ଏଥିଉତ୍ତାରେ ଅବ୍ରାମ ଓ ନାହୋର ବିବାହ କଲେ; ଅବ୍ରାମଙ୍କ ଭାର୍ଯ୍ୟାଙ୍କର ନାମ ସାରୀ ଓ ନାହୋରର ଭାର୍ଯ୍ୟାର ନାମ ମିଲ୍କା, ସେ ହାରଣର କନ୍ୟା ଥିଲା; ସେହି ହାରଣ ମିଲ୍କା ଓ ଯିସ୍କାର ପିତା। ");
INSERT INTO ory_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ସେହି ସାରୀ ବନ୍ଧ୍ୟା ଥିଲେ, ତାଙ୍କର କୌଣସି ସନ୍ତାନ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ଏଥିଉତ୍ତାରେ ତେରହ ଆପଣା ପୁତ୍ର ଅବ୍ରାମଙ୍କୁ ଓ ହାରଣର ପୁତ୍ର ଲୋଟ ନାମକ ପୌତ୍ରକୁ, ପୁଣି, ଅବ୍ରାମଙ୍କ ଭାର୍ଯ୍ୟା ସାରୀ ନାମ୍ନୀ ପୁତ୍ରବଧୂଙ୍କୁ ସଙ୍ଗରେ ନେଲେ; ଆଉ ସେମାନେ ସମସ୍ତେ କଲ୍‍ଦୀୟମାନଙ୍କ ଊରଠାରୁ କିଣାନ ଦେଶ ଉଦ୍ଦେଶ୍ୟରେ ଯାତ୍ରା କରି ହାରଣ ନଗରରେ ଉତ୍ତରି ବସତି କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ପୁଣି, ତେରହ ହାରଣ ନଗରରେ ଥାଇ ଦୁଇ ଶହ ପାଞ୍ଚ ବର୍ଷ ବୟସରେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଅବ୍ରାମଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ଦେଶ ଓ ଜ୍ଞାତି କୁଟୁମ୍ବ ଓ ପୈତୃକ ଗୃହ ପରିତ୍ୟାଗ କରି, ଆମ୍ଭେ ଯେଉଁ ଦେଶ ତୁମ୍ଭକୁ ଦେଖାଇବା, ସେହି ଦେଶକୁ ଯାଅ। ");
INSERT INTO ory_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ଆମ୍ଭେ ତୁମ୍ଭଠାରୁ ଏକ ମହାଗୋଷ୍ଠୀ ଉତ୍ପନ୍ନ କରିବା, ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରି ତୁମ୍ଭର ନାମ ମହତ୍ କରିବା; ତୁମ୍ଭେ ଆଶୀର୍ବାଦର ଆକର ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ଯେଉଁମାନେ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରନ୍ତି, ଆମ୍ଭେ ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରିବା; ପୁଣି, ଯେକେହି ତୁମ୍ଭକୁ ଅଭିଶାପ ଦିଏ, ଆମ୍ଭେ ତାହାକୁ ଅଭିଶାପ ଦେବା; ଆଉ ତୁମ୍ଭଠାରୁ ପୃଥିବୀର ସବୁ ବଂଶ ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ଏଥିଉତ୍ତାରେ ଅବ୍ରାମ ସଦାପ୍ରଭୁଙ୍କ ଏହି ବାକ୍ୟାନୁସାରେ ପ୍ରସ୍ଥାନ କଲେ, ପୁଣି, ଲୋଟ ତାଙ୍କ ସଙ୍ଗରେ ଗଲେ; ହାରଣଠାରୁ ପ୍ରସ୍ଥାନ କରିବା ସମୟରେ ଅବ୍ରାମଙ୍କର ବୟସ ପଞ୍ଚସ୍ତରି ବର୍ଷ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ଏହିରୂପେ ଅବ୍ରାମ ଆପଣା ଭାର୍ଯ୍ୟା ସାରୀଙ୍କୁ ଓ ଭ୍ରାତୃପୁତ୍ର ଲୋଟକୁ ଓ ହାରଣଠାରେ ଆପଣାମାନଙ୍କ ସଞ୍ଚିତ ଧନ ଓ ପ୍ରାପ୍ତ ପ୍ରାଣୀମାନଙ୍କୁ ଘେନି କିଣାନ ଦେଶ ଉଦ୍ଦେଶ୍ୟରେ ଯାତ୍ରା କରି କିଣାନରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ଅବ୍ରାମ ସେହି ଦେଶ ଦେଇ ଭ୍ରମଣ କରୁ କରୁ ଶିଖିମ ନିକଟସ୍ଥ ମୋରିର ଅଲୋନ ବୃକ୍ଷ ମୂଳରେ ପହଞ୍ଚିଲେ। ସେହି ସମୟରେ କିଣାନୀୟମାନେ ସେହି ଦେଶରେ ବାସ କରୁଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଅବ୍ରାମଙ୍କୁ ଦର୍ଶନ ଦେଇ କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭ ବଂଶକୁ ଏହି ଦେଶ ଦେବା;” ଏଥିନିମନ୍ତେ ଅବ୍ରାମ ଆପଣା ନିକଟରେ ଦର୍ଶନଦାତା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସେହି ସ୍ଥାନରେ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ଏଥିଉତ୍ତାରେ ସେ ସେହି ସ୍ଥାନ ଛାଡ଼ି ବେଥେଲ୍‍ର ପୂର୍ବଆଡ଼ ପର୍ବତକୁ ଯାଇ ଆପଣା ତମ୍ବୁ ଠିଆ କଲେ; ତହିଁର ପଶ୍ଚିମରେ ବେଥେଲ୍‍ ଓ ପୂର୍ବ ଦିଗରେ ଅୟ ନଗର ଥିଲା; ପୁଣି, ସେହିଠାରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଏକ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କରି ସଦାପ୍ରଭୁଙ୍କ ନାମରେ ପ୍ରାର୍ଥନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ତହିଁ ଉତ୍ତାରେ ଅବ୍ରାମ ଭ୍ରମଣ କରୁ କରୁ ଆହୁରି ଦକ୍ଷିଣ ଦିଗକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ସେହି ସମୟରେ ସେହି ଦେଶରେ ଦୁର୍ଭିକ୍ଷ ହେବାରୁ ଅବ୍ରାମ ମିସର ଦେଶରେ ପ୍ରବାସ କରିବାକୁ ଯାତ୍ରା କଲେ; ଯେହେତୁ ଦେଶରେ ଅତିଶୟ ଦୁର୍ଭିକ୍ଷ ପଡ଼ିଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ଏଥିଉତ୍ତାରେ ମିସର ଦେଶରେ ପ୍ରବେଶ କରିବାକୁ ଉଦ୍ୟତ ହୁଅନ୍ତେ, ଅବ୍ରାମ ଆପଣା ଭାର୍ଯ୍ୟା ସାରୀଙ୍କୁ କହିଲେ, “ଶୁଣ, ତୁମ୍ଭେ ଦେଖିବାକୁ ସୁନ୍ଦରୀ, ତାହା ମୁଁ ଜାଣେ। ");
INSERT INTO ory_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ଏଥିପାଇଁ ମିସର ଦେଶୀୟ ଲୋକମାନେ ତୁମ୍ଭକୁ ଦେଖି ମୋହର ଭାର୍ଯ୍ୟା ବୋଲି ଜାଣିଲେ, ମୋତେ ବଧ କରି ତୁମ୍ଭକୁ ଜୀବିତା ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ଏହେତୁ ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ମୋହର ଭଉଣୀ, ଏହା କହିବ; ତହିଁରେ ତୁମ୍ଭ ସକାଶେ ମୋହର ମଙ୍ଗଳ ହେବ ଓ ତୁମ୍ଭ ସକାଶୁ ମୋʼ ପ୍ରାଣ ରକ୍ଷା ପାଇବ।” ");
INSERT INTO ory_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ଏଥିଉତ୍ତାରେ ଅବ୍ରାମ ମିସର ଦେଶରେ ପ୍ରବେଶ କରନ୍ତେ, ମିସରୀୟ ଲୋକମାନେ ସେହି ସ୍ତ୍ରୀଙ୍କୁ ପରମସୁନ୍ଦରୀ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ପୁଣି, ଫାରୋଙ୍କର ଅଧିପତିମାନେ ତାଙ୍କୁ ଦେଖି ଫାରୋଙ୍କ ଛାମୁରେ ତାଙ୍କର ପ୍ରଶଂସା କରନ୍ତେ, ସେହି ସ୍ତ୍ରୀ ଫାରୋଙ୍କର ଗୃହକୁ ଅଣାଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ଫାରୋ ତାଙ୍କ ଲାଗି ଅବ୍ରାମଙ୍କୁ ସମାଦର କରି ତାଙ୍କୁ ମେଷ, ଗୋରୁ, ଗର୍ଦ୍ଦଭ ଓ ଦାସଦାସୀ ଓ ଗର୍ଦ୍ଦଭୀ ଓ ଓଟ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ମାତ୍ର ଅବ୍ରାମଙ୍କର ଭାର୍ଯ୍ୟା ସାରୀଙ୍କ ସକାଶୁ ସଦାପ୍ରଭୁ ଫାରୋ ଓ ତାଙ୍କର ପରିବାର ଉପରେ ମହାମାରୀ ଘଟାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ଏହେତୁ ଫାରୋ ଅବ୍ରାମଙ୍କୁ ଡାକି କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭ ସହିତ ଏ କି ବ୍ୟବହାର କଲ? ");
INSERT INTO ory_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ସେହି ସ୍ତ୍ରୀ ତୁମ୍ଭର ଭାର୍ଯ୍ୟା, ଏ କଥା ଆମ୍ଭକୁ କାହିଁକି କହିଲ ନାହିଁ? ତାଙ୍କୁ କାହିଁକି ଆପଣାର ଭଗିନୀ ବୋଲି କହିଲ? ତହିଁରେ ଆମ୍ଭେ ତାଙ୍କୁ ବିବାହ କରିବାକୁ ନେଲୁ; ଏବେ ତୁମ୍ଭ ଭାର୍ଯ୍ୟାଙ୍କୁ ଦେଖ, ତାଙ୍କୁ ଘେନି ଚାଲିଯାଅ।” ");
INSERT INTO ory_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ତହୁଁ ଫାରୋ ଲୋକମାନଙ୍କୁ ତାଙ୍କ ବିଷୟରେ ଆଜ୍ଞା ଦେଲେ, ଆଉ ସେମାନେ ସର୍ବସ୍ୱ ସହିତ ତାଙ୍କୁ ଓ ତାଙ୍କ ଭାର୍ଯ୍ୟାଙ୍କୁ ବିଦାୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ଏଥିଉତ୍ତାରେ ଅବ୍ରାମ ଆପଣାର ଭାର୍ଯ୍ୟା ଓ ସବୁ ସମ୍ପତ୍ତି ଘେନି ଲୋଟ ସହିତ ମିସର ଦେଶରୁ ବାହାରି ଦକ୍ଷିଣାଞ୍ଚଳକୁ ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ଅବ୍ରାମ ପଶୁ ଓ ସୁନା ରୂପାରେ ଅତିଶୟ ଧନବାନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ପୁଣି, ସେ ପୂର୍ବଯାତ୍ରାନୁସାରେ ଦକ୍ଷିଣରୁ ବେଥେଲ୍‍ ଆଡ଼କୁ ଯାଉ ଯାଉ ବେଥେଲ୍‍ ଓ ଅୟର ମଧ୍ୟବର୍ତ୍ତୀ ଯେଉଁ ସ୍ଥାନରେ ପୂର୍ବେ ତାଙ୍କର ତମ୍ବୁ ସ୍ଥାପିତ ହୋଇଥିଲା, ");
INSERT INTO ory_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ସେହି ସ୍ଥାନରେ ଉପସ୍ଥିତ ହୋଇ ଆପଣା ପୂର୍ବନିର୍ମିତ ଯଜ୍ଞବେଦି ନିକଟରେ ସଦାପ୍ରଭୁଙ୍କ ନାମରେ ପ୍ରାର୍ଥନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ପୁଣି, ଅବ୍ରାମଙ୍କର ସଙ୍ଗୀ ଲୋଟଙ୍କର ମଧ୍ୟ ଅନେକ ଅନେକ ମେଷ, ଗୋରୁ ଓ ତମ୍ବୁ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ଏଥିନିମନ୍ତେ ସେହି ଦେଶ ସେମାନଙ୍କର ଏକତ୍ର ବାସ ପାଇଁ ଉପଯୋଗୀ ହେଲା ନାହିଁ, କାରଣ ସେମାନଙ୍କର ବହୁତ ସମ୍ପତ୍ତି ଥିବାରୁ ସେମାନେ ଏକତ୍ର ବାସ କରି ପାରିଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ପୁଣି, ଅବ୍ରାମଙ୍କର ପଶୁପାଳକ ଓ ଲୋଟଙ୍କର ପଶୁପାଳକମାନଙ୍କର ପରସ୍ପର ବିରୋଧ ହେଲା। ସେହି ସମୟରେ ସେହି ଦେଶରେ କିଣାନୀୟ ଓ ପରିଷୀୟ ଲୋକମାନେ ବାସ କରୁଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ଏଣୁ ଅବ୍ରାମ ଲୋଟଙ୍କୁ କହିଲେ, “ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭ ଆମ୍ଭ ମଧ୍ୟରେ, ପୁଣି, ତୁମ୍ଭର ପଶୁପାଳକ ଓ ମୋହର ପଶୁପାଳକମାନଙ୍କ ମଧ୍ୟରେ ବିବାଦ ନ ହେଉ, କାରଣ ଆମ୍ଭେମାନେ ଭାଇ। ");
INSERT INTO ory_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ତୁମ୍ଭ ସମ୍ମୁଖରେ କି ଏହି ସମସ୍ତ ଦେଶ ନାହିଁ? ଏହେତୁ ତୁମ୍ଭକୁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ମୋʼ ଠାରୁ ପୃଥକ ହୁଅ; ହୁଏତ, ତୁମ୍ଭେ ବାମକୁ ଯାଅ, ମୁଁ ଡାହାଣକୁ ଯାଏ; ନୋହିଲେ ତୁମ୍ଭେ ଡାହାଣକୁ ଯାଅ, ମୁଁ ବାମକୁ ଯିବି।” ");
INSERT INTO ory_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ସେତେବେଳେ ଲୋଟ ଅନାଇ ଦେଖିଲେ, ସୋୟର ପର୍ଯ୍ୟନ୍ତ ଯର୍ଦ୍ଦନର ସମସ୍ତ ପ୍ରାନ୍ତର ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ୟାନ ପରି ସର୍ବତ୍ର ସଜଳ ଓ ମିସର ଦେଶ ତୁଲ୍ୟ ଅଟଇ; କାରଣ ସେହି ସମୟରେ ସଦୋମ ଓ ହମୋରା ସଦାପ୍ରଭୁଙ୍କ ଦ୍ୱାରା ବିନଷ୍ଟ ହୋଇ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ଏଥିପାଇଁ ଲୋଟ ଆପଣା ନିମନ୍ତେ ଯର୍ଦ୍ଦନର ସମସ୍ତ ପ୍ରାନ୍ତର ମନୋନୀତ କରି ପୂର୍ବ ଦିଗକୁ ପ୍ରସ୍ଥାନ କଲେ; ଏହିରୂପେ ସେମାନେ ଏକଆରେକଠାରୁ ପୃଥକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ତହିଁରେ ଅବ୍ରାମ କିଣାନ ଦେଶରେ ବସତି କଲେ, ପୁଣି, ଲୋଟ ସେହି ପ୍ରାନ୍ତରସ୍ଥିତ ସମସ୍ତ ନଗର ମଧ୍ୟରେ ବାସ କରି ସଦୋମ ପର୍ଯ୍ୟନ୍ତ ତମ୍ବୁ ସ୍ଥାପନ କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ସେହି ସଦୋମର ଲୋକମାନେ ମହା ଦୁଷ୍ଟ ଓ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଅତି ପାପିଷ୍ଠ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ଏଥିଉତ୍ତାରେ ଅବ୍ରାମଙ୍କଠାରୁ ଲୋଟ ପୃଥକ ହେଲା ଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଅବ୍ରାମଙ୍କୁ କହିଲେ, “ଏବେ ତୁମ୍ଭେ ଯେଉଁଠାରେ ଅଛ; ସେହିଠାରୁ ଅନାଇ ଉତ୍ତର, ଦକ୍ଷିଣ, ପୂର୍ବ ଓ ପଶ୍ଚିମ ଦିଗକୁ ଦୃଷ୍ଟିପାତ କର; ");
INSERT INTO ory_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","କାରଣ, ଏହି ଯେଉଁ ସକଳ ଦେଶ ତୁମ୍ଭେ ଦେଖୁଅଛ, ତାହା ଆମ୍ଭେ ତୁମ୍ଭକୁ ଓ ଯୁଗାନୁକ୍ରମେ ତୁମ୍ଭର ବଂଶକୁ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ପୁଣି, ପୃଥିବୀର ଧୂଳି ପରି ଆମ୍ଭେ ତୁମ୍ଭର ବଂଶ ବୃଦ୍ଧି କରିବା; କେହି ଯଦି ପୃଥିବୀସ୍ଥ ଧୂଳି ଗଣି ପାରଇ, ତେବେ ତୁମ୍ଭର ବଂଶ ଗଣ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ଉଠ, ଏହି ଦେଶର ଦୀର୍ଘ ପ୍ରସ୍ଥରେ ଭ୍ରମଣ କର; ଯେଣୁ ଆମ୍ଭେ ତୁମ୍ଭକୁ ତାହା ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ସେତେବେଳେ ଅବ୍ରାମ ତମ୍ବୁ ତୋଳି ହିବ୍ରୋଣ ନିକଟସ୍ଥ ମମ୍ରିର ଅଲୋନ ବୃକ୍ଷ ମୂଳେ ଯାଇ ବାସ କଲେ, ପୁଣି, ସେଠାରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଗୋଟିଏ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ଏଥିଉତ୍ତାରେ ଶିନୀୟରର ଅମ୍ରାଫଲ୍‍ ରାଜା ଓ ଇଲ୍ଲାସରର ଅରୀୟୋକ୍‍ ରାଜା ଓ ଏଲମ୍‍ର କଦର୍ଲାୟୋମର ରାଜା ଓ ଗୋୟିମର ତିଦୀୟଲ୍ ରାଜାଙ୍କର ଅଧିକାର ସମୟରେ, ");
INSERT INTO ory_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ଏମାନେ ସଦୋମର ରାଜା ବିରା ଓ ହମୋରାର ରାଜା ବିର୍ଶା ଓ ଅଦ୍ମାର ରାଜା ଶିନାବ୍‍ ଓ ସବୋୟୀମର ରାଜା ଶିମେବର ଓ ବିଲାର, ଅର୍ଥାତ୍‍, ସୋୟରର ରାଜା ସହିତ ଯୁଦ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ଏସମସ୍ତେ ସୀଦ୍ଦୀମ ପଦାରେ, ଅର୍ଥାତ୍‍, ଲବଣ ସମୁଦ୍ର ନିକଟରେ ଏକତ୍ର ହୋଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ଯେହେତୁ ସେମାନେ ବାର ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ କଦର୍ଲାୟୋମର ରାଜାଙ୍କର ବଶୀଭୂତ ରହି ତ୍ରୟୋଦଶ ବର୍ଷରେ ତାଙ୍କର ବିଦ୍ରୋହୀ ହୋଇଥିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ଏହେତୁ ଚତୁର୍ଦ୍ଦଶ ବର୍ଷରେ କଦର୍ଲାୟୋମର ରାଜା ଓ ତାଙ୍କର ସହାୟ ରାଜାଗଣ ଆସି ଅସ୍ତରୋତ୍‍ କର୍ଣ୍ଣୟିମରେ ରଫାୟୀୟ ଲୋକମାନଙ୍କୁ ଓ ହମରେ ସୁଷୀୟ ଲୋକମାନଙ୍କୁ ଓ ଶାବୀ କିରୀୟାଥୟିମ୍‍ରେ ଏମୀୟ ଲୋକମାନଙ୍କୁ, ");
INSERT INTO ory_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ଓ ପ୍ରାନ୍ତର ନିକଟସ୍ଥ ଏଲ-ପାରଣ ପର୍ଯ୍ୟନ୍ତ ସେୟୀର ପର୍ବତ ନିବାସୀ ହୋରୀୟ ଲୋକମାନଙ୍କୁ ଜୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ପୁଣି, ସେମାନେ ସେହି ସ୍ଥାନରୁ ବାହୁଡ଼ି ଐଣ୍‍ମିସ୍‍ପଟ୍‍, ଅର୍ଥାତ୍‍, କାଦେଶକୁ ଯାଇ ଅମାଲେକୀୟ ଲୋକମାନଙ୍କର ସମସ୍ତ ଦେଶ ଓ ହତ୍‍-ସସୋନ୍‍-ତାମର ନିବାସୀ ଇମୋରୀୟ ଲୋକମାନଙ୍କୁ ପରାସ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ଏହେତୁ ସଦୋମର ରାଜା ଓ ହମୋରାର ରାଜା ଓ ଅଦ୍ମାର ରାଜା ଓ ସବୋୟୀମର ରାଜା ଓ ବିଲାର, ଅର୍ଥାତ୍‍, ସୋୟରର ରାଜା, ଏହି ପାଞ୍ଚ ରାଜା ମିଳିତ ହୋଇ, ");
INSERT INTO ory_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ଏଲମ୍‍ର କଦର୍ଲାୟୋମର ରାଜା ଓ ଗୋୟିମର ତିଦୀୟଲ୍ ରାଜା ଓ ଶିନୀୟରର ଅମ୍ରାଫଲ୍‍ ରାଜା ଓ ଇଲ୍ଲାସରର ଅରୀୟୋକ୍‍ ରାଜା, ଏହି ଚାରି ରାଜାଙ୍କ ସହିତ ସୀଦ୍ଦୀମ ପଦାରେ ଯୁଦ୍ଧ କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ସେହି ସୀଦ୍ଦୀମ ପଦାରେ ମାଟିଆ ତୈଳର ଅନେକ ଖାତ ଥିଲା; ସଦୋମ ଓ ହମୋରାର ରାଜାଗଣ ପଳାଇ ଯାଉ ଯାଉ ତହିଁ ମଧ୍ୟରେ ପଡ଼ିଲେ, ପୁଣି, ଯେଉଁମାନେ ଅବଶିଷ୍ଟ ରହିଲେ, ସେମାନେ ପର୍ବତକୁ ପଳାଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ଏଥିନିମନ୍ତେ ସେମାନେ ସଦୋମ ଓ ହମୋରାର ସମସ୍ତ ସମ୍ପତ୍ତି ଓ ଭକ୍ଷ୍ୟଦ୍ରବ୍ୟ ଲୁଟି ନେଇ ପ୍ରସ୍ଥାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ପୁଣି, ଅବ୍ରାମଙ୍କର ପୁତୁରା ସଦୋମନିବାସୀ ଲୋଟଙ୍କୁ ଓ ତାଙ୍କର ସମସ୍ତ ସମ୍ପତ୍ତି ନେଇ ଚାଲିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ସେତେବେଳେ ଜଣେ ପଳାତକ ଏବ୍ରୀୟ ଅବ୍ରାମଙ୍କୁ ସମାଚାର ଦେଲା; ସେହି ସମୟରେ ଅବ୍ରାମ ଇଷ୍କୋଲର ଓ ଆନେର୍‍ର ଭ୍ରାତା ଇମୋରୀୟ ମମ୍ରିର ଅଲୋନ ବୃକ୍ଷ ମୂଳେ ବାସ କରୁଥିଲେ, ପୁଣି, ସେମାନେ ଅବ୍ରାମଙ୍କର ସହାୟ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ସେତେବେଳେ ଅବ୍ରାମ ଆପଣା ଜ୍ଞାତି ଧରା ହୋଇ ଯିବାର ସମାଚାର ଶୁଣିବା ମାତ୍ରକେ (ଯୁଦ୍ଧ ବିଦ୍ୟାରେ) ଶିକ୍ଷିତ ଆପଣା ଗୃହଜାତ ତିନି ଶହ ଅଠର ଜଣ ଲୋକଙ୍କୁ ସଙ୍ଗରେ ଘେନି ଶତ୍ରୁଗଣର ପଛେ ପଛେ ଦୌଡ଼ି ଦାନ୍ ନଗର ପର୍ଯ୍ୟନ୍ତ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ଏଥିଉତ୍ତାରେ ସେ ଆପଣା ଦାସମାନଙ୍କୁ ଦୁଇ ଦଳ କରି ରାତ୍ରିକାଳରେ ଶତ୍ରୁମାନଙ୍କୁ ଆକ୍ରମଣ କଲେ, ପୁଣି, ଦମ୍ମେଶକର ଉତ୍ତରସ୍ଥିତ ହୋବା ପର୍ଯ୍ୟନ୍ତ ସେମାନଙ୍କର ପଛେ ପଛେ ଗୋଡ଼ାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ଆଉ, ସବୁ ସମ୍ପତ୍ତି ଓ ଆପଣାର ଜ୍ଞାତି ଲୋଟ ଓ ତାଙ୍କର ସମ୍ପତ୍ତି, ପୁଣି, ସ୍ତ୍ରୀଗଣ ଓ ଲୋକସମୂହକୁ ବାହୁଡ଼ାଇ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ଏହିରୂପେ ଅବ୍ରାମ କଦର୍ଲାୟୋମରକୁ ଓ ତାଙ୍କର ସହାୟ ରାଜାଗଣକୁ ଜୟ କରି ବାହୁଡ଼ିଲା ଉତ୍ତାରେ, ସଦୋମର ରାଜା ତାଙ୍କ ସହିତ ସାକ୍ଷାତ କରିବାକୁ ଶାବୀ ପଦା, ଅର୍ଥାତ୍‍, ରାଜାର ପଦାକୁ ଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ପୁଣି, ଶାଲେମ୍‍ର ରାଜା ମଲ୍‍କୀଷେଦକ ରୁଟି ଓ ଦ୍ରାକ୍ଷାରସ ଘେନି ଆସିଲେ; ସେ ସର୍ବୋପରିସ୍ଥ ପରମେଶ୍ୱରଙ୍କର ଯାଜକ; ");
INSERT INTO ory_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ସେ ଅବ୍ରାମଙ୍କୁ ଆଶୀର୍ବାଦ କରି କହିଲେ, “ଅବ୍ରାମ ସ୍ୱର୍ଗ ଓ ପୃଥିବୀର ଅଧିକାରୀ ସର୍ବୋପରିସ୍ଥ ପରମେଶ୍ୱରଙ୍କର ଆଶୀର୍ବାଦ-ପାତ୍ର ହେଉନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ସର୍ବୋପରିସ୍ଥ ପରମେଶ୍ୱର ଧନ୍ୟ ହେଉନ୍ତୁ, ସେ ତୁମ୍ଭର ଶତ୍ରୁଗଣଙ୍କୁ ତୁମ୍ଭ ହସ୍ତରେ ସମର୍ପଣ କଲେ।” ସେତେବେଳେ (ଅବ୍ରାମ) ସବୁ ଦ୍ରବ୍ୟର ଦଶମାଂଶ ତାଙ୍କୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ଏଥିଉତ୍ତାରେ ସଦୋମର ରାଜା ଅବ୍ରାମଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ସମସ୍ତ ସମ୍ପତ୍ତି ନିଅ, ମାତ୍ର ମନୁଷ୍ୟ ସକଳ ଆମ୍ଭଙ୍କୁ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ତହିଁରେ ଅବ୍ରାମ ସଦୋମର ରାଜାକୁ ଉତ୍ତର କଲେ, “ମୁଁ ସ୍ୱର୍ଗ ଓ ପୃଥିବୀର ଅଧିକାରୀ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହସ୍ତ ଉଠାଇ କହିଅଛି ଯେ, ");
INSERT INTO ory_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ମୁଁ ତୁମ୍ଭର କିଛି ନେବି ନାହିଁ, ଖଣ୍ଡିଏ ସୂତା କି ଜୋତାର ବନ୍ଧନୀ ହିଁ ନେବି ନାହିଁ; ପଛେ ଅବା ତୁମ୍ଭେ କହିବ, ‘ଆମ୍ଭେ ଅବ୍ରାମଙ୍କୁ ଧନବାନ କରିଅଛୁ।’ ");
INSERT INTO ory_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","କେବଳ ମୋହର ଯୁବା ଲୋକମାନେ ଯାହା ଭୋଜନ କରିଅଛନ୍ତି, ତାହା ନେବି, ପୁଣି, ମୋହର ଯେଉଁ ସହାୟଗଣ ସଙ୍ଗରେ ଯାଇଥିଲେ, ସେମାନେ, ଅର୍ଥାତ୍‍, ଆନେର୍‍ ଓ ଇଷ୍କୋଲ ଓ ମମ୍ରି ଆପଣା ଆପଣା ପ୍ରାପ୍ତବ୍ୟ ଭାଗ ଗ୍ରହଣ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ସେହି ଘଟଣା ଉତ୍ତାରେ ଦର୍ଶନ ଦ୍ୱାରା ସଦାପ୍ରଭୁଙ୍କର ବାକ୍ୟ ଅବ୍ରାମଙ୍କ ନିକଟରେ ଉପସ୍ଥିତ ହେଲା, “ହେ ଅବ୍ରାମ, ଭୟ କର ନାହିଁ, ଆମ୍ଭେ ତୁମ୍ଭର ଢାଲ ଓ ମହାପୁରସ୍କାର ସ୍ୱରୂପ।” ");
INSERT INTO ory_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ତହିଁରେ ଅବ୍ରାମ ଉତ୍ତର କଲେ, “ହେ ପ୍ରଭୋ ସଦାପ୍ରଭୋ, ତୁମ୍ଭେ ମୋତେ କʼଣ ଦେବ? ମୁଁ ତ ନିଃସନ୍ତାନ ହୋଇ ପ୍ରସ୍ଥାନ କରୁଅଛି, ପୁଣି, ଦମ୍ମେଶକୀୟ ଇଲୀୟେଜର ମୋʼ ଗୃହର ଧନାଧିକାରୀ ଅଟେ।” ");
INSERT INTO ory_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ପୁଣି, ଅବ୍ରାମ କହିଲେ, “ଦେଖ, ତୁମ୍ଭେ ମୋତେ ସନ୍ତାନ ଦେଲ ନାହିଁ, ଏଣୁ ମୋʼ ଗୃହଜାତ କୌଣସି ଲୋକ ମୋହର ଉତ୍ତରାଧିକାରୀ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ସେତେବେଳେ ତାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର ଏହି ବାକ୍ୟ ଉପସ୍ଥିତ ହେଲା, “ଦେଖ, ସେହି ବ୍ୟକ୍ତି ତୁମ୍ଭର ଉତ୍ତରାଧିକାରୀ ହେବ ନାହିଁ; ମାତ୍ର ଯେ ତୁମ୍ଭ ଔରସରେ ଜାତ ହେବ, ସେହି ତୁମ୍ଭର ଉତ୍ତରାଧିକାରୀ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ ବାହାରକୁ ଆଣି କହିଲେ, “ତୁମ୍ଭେ ଆକାଶକୁ ଦୃଷ୍ଟି କରି ଯଦି ତାରାସମୂହ ଗଣିପାର, ତେବେ ଗଣି କୁହ।” ସେ ଆହୁରି କହିଲେ, “ଏହି ପ୍ରକାର ତୁମ୍ଭର ବଂଶ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ସେତେବେଳେ ଅବ୍ରାମ ସଦାପ୍ରଭୁଙ୍କଠାରେ ବିଶ୍ୱାସ କରନ୍ତେ, ସେ ତାଙ୍କ ପକ୍ଷରେ ତାକୁ ଧାର୍ମିକତା ବୋଲି ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ କହିଲେ, “ଯେ ତୁମ୍ଭର ଅଧିକାର ନିମନ୍ତେ ଏହି ଦେଶ ଦେବା ପାଇଁ କଲ୍‍ଦୀୟମାନଙ୍କ ଊରଠାରୁ ଆଣିଲେ, ସେହି ସଦାପ୍ରଭୁ ଆମ୍ଭେ।” ");
INSERT INTO ory_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ତହୁଁ ଅବ୍ରାମ କହିଲେ, “ହେ ପ୍ରଭୋ ସଦାପ୍ରଭୋ, ମୁଁ ଯେ ଏ ଦେଶର ଅଧିକାରୀ ହେବି, ତାହା ମୁଁ କିପରି ଜାଣିବି?” ");
INSERT INTO ory_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ସଦାପ୍ରଭୁ କହିଲେ, “ତୁମ୍ଭେ ତିନି ବର୍ଷର ଗୋଟିଏ ଗାଭୀ ଓ ତିନି ବର୍ଷର ଗୋଟିଏ ଛାଗୀ ଓ ତିନି ବର୍ଷର ଗୋଟିଏ ମେଷ ଓ ଗୋଟିଏ ଘୁଘୁ ଓ ଗୋଟିଏ କପୋତ ଛୁଆ ଆମ୍ଭ ନିକଟକୁ ଆଣ।” ");
INSERT INTO ory_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ତହିଁରେ ଅବ୍ରାମ ସେହି ସବୁ ତାହାଙ୍କ ନିକଟକୁ ଆଣି ଦୁଇ ଖଣ୍ଡ କରି ଖଣ୍ଡକ ଆଗରେ ଅନ୍ୟ ଖଣ୍ଡ ରଖିଲେ; ମାତ୍ର ପକ୍ଷୀମାନଙ୍କୁ ଦୁଇ ଖଣ୍ଡ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ଏଥିଉତ୍ତାରେ ହିଂସ୍ରକ ପକ୍ଷୀଗଣ ସେହି ମୃତ ଶବମାନଙ୍କ ଉପରେ ପଡ଼ନ୍ତେ, ଅବ୍ରାମ ସେମାନଙ୍କୁ ଅଡ଼ାଇ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ପୁଣି, ସୂର୍ଯ୍ୟାସ୍ତ ସମୟରେ ଅବ୍ରାମ ଅତି ନିଦ୍ରିତ ହୋଇ ଘୋର ଅନ୍ଧକାରରେ ଭୟଗ୍ରସ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ସେତେବେଳେ ସଦାପ୍ରଭୁ ଅବ୍ରାମଙ୍କୁ କହିଲେ, “ତୁମ୍ଭର ସନ୍ତାନଗଣ ଚାରି ଶହ ବର୍ଷ ଅନ୍ୟ ଦେଶରେ ପ୍ରବାସୀ ହୋଇ ଦାସ୍ୟକର୍ମ କରି କ୍ଳେଶ ଭୋଗ କରିବେ; ଏହା ନିଶ୍ଚିତ ଜାଣିବ; ");
INSERT INTO ory_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ମାତ୍ର ସେମାନେ ଯେଉଁ ଦେଶୀୟ ଲୋକମାନଙ୍କର ଦାସ୍ୟକର୍ମ କରିବେ, ଆମ୍ଭେ ସେମାନଙ୍କର ବିଚାର କରିବା; ତହିଁ ଉତ୍ତାରେ ସେମାନେ ବହୁତ ଧନ ଘେନି ସେହି ଦେଶରୁ ବାହାର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ମାତ୍ର ତୁମ୍ଭେ କୁଶଳରେ ଆପଣା ପୂର୍ବପୁରୁଷମାନଙ୍କ ନିକଟକୁ ଯିବ ଓ ଉତ୍ତମ ବୃଦ୍ଧାବସ୍ଥାରେ କବରପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ପୁଣି, ତୁମ୍ଭ ବଂଶର ଚତୁର୍ଥ ପୁରୁଷ ଏହି ଦେଶକୁ ବାହୁଡ଼ି ଆସିବେ; ଯେହେତୁ ଇମୋରୀୟ ଲୋକମାନଙ୍କର ପାପ ଏପର୍ଯ୍ୟନ୍ତ ସମ୍ପୂର୍ଣ୍ଣ ହୋଇ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ଆଉ ଯେବେ ସୂର୍ଯ୍ୟ ଅସ୍ତଗତ ଓ ଅନ୍ଧକାର ହେଲା, ଦେଖ, ସଧୂମ ଚୁଲି ଓ ପ୍ରଜ୍ୱଳିତ ଦିହୁଡ଼ି ସେହି ଦୁଇ ଖଣ୍ଡ ଶ୍ରେଣୀର ମଧ୍ୟଦେଇ ଚାଲିଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ପୁଣି, ସେହି ଦିନ ସଦାପ୍ରଭୁ ଅବ୍ରାମଙ୍କ ସହିତ ନିୟମ ସ୍ଥିର କରି କହିଲେ, “ଆମ୍ଭେ ଏହି ମିସରୀୟ ନଦୀଠାରୁ ଫରାତ୍‍ ନାମକ ମହାନଦୀ ପର୍ଯ୍ୟନ୍ତ ଏହି ଦେଶ ତୁମ୍ଭ ବଂଶକୁ ଦେଲୁ, ");
INSERT INTO ory_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ଅର୍ଥାତ୍‍, କେନୀୟ, କନଜୀୟ, କଦ୍‍ମୋନୀୟ, ");
INSERT INTO ory_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ହିତ୍ତୀୟ, ପରିଷୀୟ, ରଫାୟୀୟ, ");
INSERT INTO ory_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ଇମୋରୀୟ, କିଣାନୀୟ, ଗିର୍ଗାଶୀୟ ଓ ଯିବୂଷୀୟମାନଙ୍କର ଦେଶ ଦେଲୁ।” ");
INSERT INTO ory_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ଅବ୍ରାମଙ୍କର ଭାର୍ଯ୍ୟା ସାରୀ ନିଃସନ୍ତାନା ଥିଲେ, ପୁଣି, ହାଗାର ନାମ୍ନୀ ତାଙ୍କର ଏକ ମିସରୀୟା ଦାସୀ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ତହିଁରେ ସାରୀ ଅବ୍ରାମଙ୍କୁ କହିଲେ, “ଦେଖ, ସଦାପ୍ରଭୁ ମୋତେ ବନ୍ଧ୍ୟା କରିଅଛନ୍ତି; ଏଣୁ ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ମୋହର ଏହି ଦାସୀର ସହବାସ କର; କେଜାଣି ମୁଁ ଏହା ଯୋଗୁଁ ପୁତ୍ର ପାଇ ପାରିବି।” ତେବେ ଅବ୍ରାମ ସାରୀଙ୍କର ବାକ୍ୟରେ ସମ୍ମତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ଅବ୍ରାମ କିଣାନ ଦେଶରେ ଦଶ ବର୍ଷ ବାସ କଲା ଉତ୍ତାରେ ତାଙ୍କର ଭାର୍ଯ୍ୟା ସାରୀ ଆପଣା ମିସରୀୟା ଦାସୀ ହାଗାରକୁ ନେଇ ଆପଣା ସ୍ୱାମୀ ଅବ୍ରାମ ସହିତ ବିବାହ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ଏଥିଉତ୍ତାରେ ଅବ୍ରାମ ହାଗାରର ସହବାସ କରନ୍ତେ, ସେ ଗର୍ଭବତୀ ହେଲା; ପୁଣି, ଆପଣାର ଗର୍ଭ ହୋଇଅଛି, ଏହା ଜାଣି ସେ ନିଜ ସାଆନ୍ତାଣୀଙ୍କୁ ତୁଚ୍ଛଜ୍ଞାନ କରିବାକୁ ଲାଗିଲା। ");
INSERT INTO ory_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ତହିଁରେ ସାରୀ ଅବ୍ରାମଙ୍କୁ କହିଲେ, “ମୋʼ ପ୍ରତି ଏହି ଅନ୍ୟାୟର ଫଳ ତୁମ୍ଭର ହେଉ; ମୁଁ ଆପଣାର ଯେଉଁ ଦାସୀକୁ ତୁମ୍ଭ କ୍ରୋଡ଼ରେ ଦେଇଅଛି, ସେ ଏବେ ଆପଣାର ଗର୍ଭ ଜାଣି ମୋତେ ତୁଚ୍ଛଜ୍ଞାନ କରୁଅଛି; ସଦାପ୍ରଭୁ ତୁମ୍ଭର ଓ ମୋହର ବିଚାର କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ତହିଁରେ ଅବ୍ରାମ ସାରୀଙ୍କୁ କହିଲେ, “ଦେଖ, ତୁମ୍ଭର ଦାସୀ ତୁମ୍ଭ ହାତରେ ଅଛି; ତୁମ୍ଭକୁ ଯାହା ଭଲ ଦିଶେ, ତାହା ତାʼ ପ୍ରତି କର।” ତହିଁରେ ସାରୀ ହାଗାର ପ୍ରତି କଠିନ ବ୍ୟବହାର କରନ୍ତେ, ସେ ତାଙ୍କ ପାଖରୁ ପଳାଇଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ପ୍ରାନ୍ତର ମଧ୍ୟରେ ଗୋଟିଏ ନିର୍ଝର ନିକଟରେ, ଅର୍ଥାତ୍‍, ଶୂରର ପଥରେ ଯେଉଁ ନିର୍ଝର ଅଛି, ତହିଁ ନିକଟରେ ତାହାକୁ ଦେଖି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“ଆଗୋ ସାରୀର ଦାସୀ ହାଗାର, ତୁମ୍ଭେ କେଉଁଠାରୁ ଆସିଲ? ପୁଣି, କେଉଁଠାକୁ ଯିବ?” ତହିଁରେ ସେ କହିଲା, “ମୁଁ ଆପଣା ସାଆନ୍ତାଣୀ ସାରୀ ନିକଟରୁ ପଳାଉଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ସେତେବେଳେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ତାହାକୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ସାଆନ୍ତାଣୀ ନିକଟକୁ ଫେରିଯାଇ ନମ୍ର ଭାବରେ ତାଙ୍କର ହସ୍ତର ବଶୀଭୂତା ହୁଅ।” ");
INSERT INTO ory_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ଆହୁରି କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭ ବଂଶ ଏପରି ବୃଦ୍ଧି କରିବା, ଯେ ବାହୁଲ୍ୟ ସକାଶୁ ତାହା ଅଗଣ୍ୟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ଆହୁରି କହିଲେ, “ଦେଖ, ତୁମ୍ଭର ଗର୍ଭ ହୋଇଅଛି, ତୁମ୍ଭେ ପୁତ୍ର ପ୍ରସବ କରିବ, ତାହାର ନାମ ଇଶ୍ମାୟେଲ ଦେବ, ଯେହେତୁ ସଦାପ୍ରଭୁ ତୁମ୍ଭ ଦୁଃଖ ଶୁଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ପୁଣି, ସେ ମନୁଷ୍ୟମାନଙ୍କ ମଧ୍ୟରେ ବନ ଗର୍ଦ୍ଦଭ ସ୍ୱରୂପ ହେବ, ତାହାର ହସ୍ତ ସମସ୍ତଙ୍କ ବିରୁଦ୍ଧରେ ଓ ସମସ୍ତଙ୍କ ହସ୍ତ ତାହାର ବିରୁଦ୍ଧରେ ଥିବ, ପୁଣି, ସେ ଆପଣା ଭାଇମାନଙ୍କ ସମ୍ମୁଖରେ ବାସ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ଆଉ ହାଗାର ଆପଣା ସହିତ କଥାବାର୍ତ୍ତାକାରୀ ସଦାପ୍ରଭୁଙ୍କର ଏହି ନାମ ରଖିଲା, ଯଥା, “ମଦ୍ଦର୍ଶକ ପରମେଶ୍ୱର” (ହେ ପରମେଶ୍ୱର, ତୁମ୍ଭେ ମୋତେ ଦେଖୁଅଛ); ଯେହେତୁ ସେ କହିଲା, “ଯେ ମୋତେ ଦେଖନ୍ତି, ତାଙ୍କ ଦର୍ଶନ ଉତ୍ତାରେ ମୁଁ କି ଏଠାରେ ଆହୁରି ବଞ୍ଚିଛି!” ");
INSERT INTO ory_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ଏଣୁ ସେହି କୂପର ନାମ ବେର-ଲହୟ-ରୋୟୀ ରଖାଗଲା। ସେହି କୂପ କାଦେଶ ଓ ବେରଦ ମଧ୍ୟରେ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ଏଥିଉତ୍ତାରେ ହାଗାର ଅବ୍ରାମଙ୍କ ନିମନ୍ତେ ପୁତ୍ର ପ୍ରସବ କରନ୍ତେ, ଅବ୍ରାମ ହାଗାରଠାରୁ ଜାତ ଆପଣାର ସେହି ପୁତ୍ରର ନାମ ଇଶ୍ମାୟେଲ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ଅବ୍ରାମଙ୍କର ଛୟାଅଶୀ ବର୍ଷ ବୟସରେ ହାଗାର ଅବ୍ରାମଙ୍କ ନିମନ୍ତେ ଇଶ୍ମାୟେଲକୁ ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ଅବ୍ରାମଙ୍କର ଅନେଶ୍ୱତ ବର୍ଷ ବୟସରେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ ଦର୍ଶନ ଦେଇ କହିଲେ, “ଆମ୍ଭେ ସର୍ବଶକ୍ତିମାନ ପରମେଶ୍ୱର; ଆମ୍ଭ ଛାମୁରେ ଧର୍ମାଚରଣ କରି ତୁମ୍ଭେ ସିଦ୍ଧ ହୁଅ। ");
INSERT INTO ory_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ଆମ୍ଭେ ତୁମ୍ଭ ସହିତ ଆପଣା ନିୟମ ସ୍ଥିର କରି ତୁମ୍ଭକୁ ଅତିଶୟ ବୃଦ୍ଧି କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ତହିଁରେ ଅବ୍ରାମ ମୁହଁ ମାଡ଼ି ପଡ଼ନ୍ତେ, ପରମେଶ୍ୱର ତାଙ୍କ ସହିତ ଆଳାପ କରି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭ ସହିତ ଆପଣା ନିୟମ ସ୍ଥିର କରୁଅଛୁ, ତୁମ୍ଭେ ଅନେକ ଗୋଷ୍ଠୀର ଆଦିପୁରୁଷ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ପୁଣି, ତୁମ୍ଭ ନାମ ଅବ୍ରାମ ଆଉ ରହିବ ନାହିଁ, ମାତ୍ର ଅବ୍ରହାମ ହେବ। ଯେହେତୁ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଅନେକ ଗୋଷ୍ଠୀର ଆଦିପିତା କଲୁ। ");
INSERT INTO ory_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ଆମ୍ଭେ ତୁମ୍ଭକୁ ଅତିଶୟ ବୃଦ୍ଧି କରିବା, ତୁମ୍ଭଠାରୁ ଅନେକ ଗୋଷ୍ଠୀଜାତ କରାଇବା ଓ ରାଜାମାନେ ତୁମ୍ଭଠାରୁ ଉତ୍ପନ୍ନ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ଆମ୍ଭେ ତୁମ୍ଭ ସହିତ ଓ ତୁମ୍ଭ ଭବିଷ୍ୟତ ବଂଶ-ପରମ୍ପରା ସହିତ ଯେଉଁ ନିୟମ ସ୍ଥିର କଲୁ, ତାହା ଅନନ୍ତକାଳସ୍ଥାୟୀ ହେବ। ତହିଁରେ ଆମ୍ଭେ ତୁମ୍ଭର ଓ ତୁମ୍ଭ ଭବିଷ୍ୟତ ବଂଶର ପରମେଶ୍ୱର ହେବା। ");
INSERT INTO ory_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ପୁଣି, ତୁମ୍ଭେ ଏବେ ଏହି ଯେଉଁ କିଣାନ ଦେଶରେ ପ୍ରବାସ କରୁଅଛ, ତହିଁର ସମୁଦାୟ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭର ଭବିଷ୍ୟତ ବଂଶକୁ ଅନନ୍ତକାଳୀନ ଅଧିକାର ନିମନ୍ତେ ଦେବା ଓ ଆମ୍ଭେ ସେମାନଙ୍କର ପରମେଶ୍ୱର ହେବା।” ");
INSERT INTO ory_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ପରମେଶ୍ୱର ଅବ୍ରହାମଙ୍କୁ ଆହୁରି କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭର ନିୟମ ପାଳନ କରିବ; ତୁମ୍ଭେ ଓ ତୁମ୍ଭର ଭବିଷ୍ୟତ ବଂଶ ପୁରୁଷାନୁକ୍ରମେ ତାହା ପାଳନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ତୁମ୍ଭର ଓ ତୁମ୍ଭ ଭବିଷ୍ୟତ ବଂଶର ସହିତ କୃତ ଆମ୍ଭର ଯେଉଁ ନିୟମ ତୁମ୍ଭେମାନେ ପାଳନ କରିବ ତାହା ଏହି, ତୁମ୍ଭମାନଙ୍କର ପ୍ରତ୍ୟେକ ପୁରୁଷ ସୁନ୍ନତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣାର ଲିଙ୍ଗାଗ୍ର ଚର୍ମ ଛେଦନ କରିବ; ଆଉ ତାହା ତୁମ୍ଭମାନଙ୍କ ସହିତ ଆମ୍ଭ ନିୟମର ଚିହ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ପୁରୁଷାନୁକ୍ରମେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତ୍ୟେକ ପୁତ୍ର ସନ୍ତାନର ଆଠ ଦିନ ବୟସରେ ସୁନ୍ନତ ହେବ। ପୁଣି, ଯେଉଁମାନେ ତୁମ୍ଭର ବଂଶ ନୁହନ୍ତି, ଏପରି ବିଦେଶୀୟ ଯେଉଁ ଲୋକ ତୁମ୍ଭ ଗୃହରେ ଜାତ ଅଥବା ମୂଲ୍ୟରେ କ୍ରୀତ ହୁଏ, ତାହାର ମଧ୍ୟ ସୁନ୍ନତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ପୁଣି, ତୁମ୍ଭର ଗୃହଜାତ ଅଥବା ମୂଲ୍ୟକ୍ରୀତ ଲୋକର ସୁନ୍ନତ ଅବଶ୍ୟ କର୍ତ୍ତବ୍ୟ; ତହିଁରେ ଅନନ୍ତକାଳ ନିମିତ୍ତ ତୁମ୍ଭମାନଙ୍କ ମାଂସରେ ଆମ୍ଭ ନିୟମର ଚିହ୍ନ ଥିବ। ");
INSERT INTO ory_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ମାତ୍ର ଯାହାର ଲିଙ୍ଗାଗ୍ର ଚର୍ମର ଛେଦନ ହେବ ନାହିଁ, ଏପରି ଯେ ଅସୁନ୍ନତ ପୁରୁଷ, ସେ ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ; ସେ ଆମ୍ଭର ନିୟମ ଲଙ୍ଘନ କଲା।” ");
INSERT INTO ory_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ତହିଁ ଉତ୍ତାରେ ପରମେଶ୍ୱର ଅବ୍ରହାମଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ଭାର୍ଯ୍ୟା ସାରୀକୁ ଆଉ ସାରୀ ବୋଲି ଡାକ ନାହିଁ; ତାହାର ନାମ ସାରା ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ଆମ୍ଭେ ତାହାକୁ ଆଶୀର୍ବାଦ କରିବା ଓ ତାହାଠାରୁ ତୁମ୍ଭକୁ ଗୋଟିଏ ପୁତ୍ର ଦେବା; ଆମ୍ଭେ ତାହାକୁ ଆଶୀର୍ବାଦ କରିବା, ସେ ନାନା ଗୋଷ୍ଠୀର ଆଦିମାତା ହେବ, ତାହାଠାରୁ ନାନା ଦେଶୀୟ ରାଜାଗଣ ଉତ୍ପନ୍ନ ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ସେତେବେଳେ ଅବ୍ରହାମ ମୁହଁ ମାଡ଼ି ପଡ଼ି ହସିଲେ, ପୁଣି, ମନେ ମନେ କହିଲେ, “ପୁରୁଷର ଶହେ ବର୍ଷ ବୟସରେ କି ସନ୍ତାନ ଜାତ ହେବ? ନବେ ବର୍ଷ ବୟସ୍କା ସାରା କି ପ୍ରସବ କରିବ?” ");
INSERT INTO ory_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ତହିଁରେ ଅବ୍ରହାମ ପରମେଶ୍ୱରଙ୍କୁ କହିଲେ, “ଇଶ୍ମାୟେଲ ତୁମ୍ଭ ଛାମୁରେ ବଞ୍ଚି ଥାଉ।” ");
INSERT INTO ory_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ସେତେବେଳେ ପରମେଶ୍ୱର କହିଲେ, “ତୁମ୍ଭର ଭାର୍ଯ୍ୟା ସାରା ତୁମ୍ଭ ନିମନ୍ତେ ନିଶ୍ଚୟ ପୁତ୍ର ପ୍ରସବ କରିବ, ପୁଣି, ତୁମ୍ଭେ ତାହାର ନାମ ଇସ୍‌ହାକ ରଖିବ, ପୁଣି, ଆମ୍ଭେ ତାହା ସହିତ ଆପଣା ନିୟମ ସ୍ଥିର କରିବା; ତାହା ତାହାର ଭବିଷ୍ୟତ ବଂଶ ପକ୍ଷରେ ଚିରସ୍ଥାୟୀ ନିୟମ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ପୁଣି, ଇଶ୍ମାୟେଲ ବିଷୟରେ ତୁମ୍ଭର ପ୍ରାର୍ଥନା ଶୁଣିଲୁ; ଦେଖ, ଆମ୍ଭେ ତାହାକୁ ଆଶୀର୍ବାଦ କରିବା, ପୁଣି, ବହୁ ପ୍ରଜାବନ୍ତ କରି; ତାହାର ବଂଶ ଅତିଶୟ ବୃଦ୍ଧି କରିବା। ତାହାଠାରୁ ଦ୍ୱାଦଶ ରାଜା ଜାତ ହେବେ ଓ ଆମ୍ଭେ ତାହାକୁ ବଡ଼ ଗୋଷ୍ଠୀ କରିବା। ");
INSERT INTO ory_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ମାତ୍ର ଆଗାମୀ ବର୍ଷର ଏହି ସମୟରେ ସାରାର ଗର୍ଭରୁ ଯେଉଁ ଇସ୍‌ହାକ ଜନ୍ମିବ, ତାହା ସହିତ ଆମ୍ଭେ ଆପଣା ନିୟମ ସ୍ଥିର କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ଏହି ପ୍ରକାରେ କଥାବାର୍ତ୍ତା ଶେଷ କରି ପରମେଶ୍ୱର ଅବ୍ରହାମଙ୍କ ନିକଟରୁ ଊର୍ଦ୍ଧ୍ୱଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ଆପଣା ପୁତ୍ର ଇଶ୍ମାୟେଲକୁ ଓ ଆପଣା ଗୃହଜାତ ଓ ମୂଲ୍ୟକ୍ରୀତ ସମସ୍ତ ଲୋକଙ୍କୁ, ଅର୍ଥାତ୍‍ ଅବ୍ରହାମଙ୍କର ଗୃହସ୍ଥିତ ପ୍ରତ୍ୟେକ ପୁରୁଷକୁ ଘେନି ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେହି ଦିନ ସମସ୍ତଙ୍କ ଲିଙ୍ଗାଗ୍ର ଚର୍ମ ଛେଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ଅବ୍ରହାମଙ୍କର ଅନେଶ୍ୱତ ବର୍ଷ ବୟସରେ ତାଙ୍କର ଲିଙ୍ଗାଗ୍ର ଚର୍ମ ଛେଦନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ପୁଣି, ତାଙ୍କର ପୁତ୍ର ଇଶ୍ମାୟେଲର ତେର ବର୍ଷ ବୟସରେ ଲିଙ୍ଗାଗ୍ର ଚର୍ମ ଛେଦନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ଏହିରୂପେ ଏକ ଦିନରେ ଅବ୍ରହାମଙ୍କର ଓ ତାଙ୍କ ପୁତ୍ର ଇଶ୍ମାୟେଲର ସୁନ୍ନତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ପୁଣି, ତାଙ୍କ ଗୃହଜାତ ଓ ବିଦେଶୀୟମାନଙ୍କ ନିକଟରୁ ମୂଲ୍ୟକ୍ରୀତ ତାଙ୍କ ଗୃହସ୍ଥ ସମସ୍ତ ପୁରୁଷର ସୁନ୍ନତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ଏଥିଉତ୍ତାରେ ଦିନକର ଖରା ବେଳେ ଅବ୍ରହାମ ମମ୍ରିର ଅଲୋନ ବୃକ୍ଷ ମୂଳେ ଆପଣା ତମ୍ବୁ ଦ୍ୱାରରେ ବସିଥିଲେ; ଏହି ସମୟରେ ସଦାପ୍ରଭୁ ସେହି ସ୍ଥାନରେ ତାଙ୍କୁ ଦର୍ଶନ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ତହିଁରେ ସେ ଅନାଇ ଦେଖିଲେ, ତିନୋଟି ପୁରୁଷ ତାଙ୍କ ସମ୍ମୁଖରେ ଦଣ୍ଡାୟମାନ; ପୁଣି, ଦେଖିବାମାତ୍ର ସାକ୍ଷାତ କରିବାକୁ ତମ୍ବୁଦ୍ୱାରରୁ ବେଗେ ଯାଇ ଭୂମିଷ୍ଠ ହୋଇ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“ହେ ପ୍ରଭୋ, ନିବେଦନ କରୁଅଛି, ମହାଶୟଗଣ, ଯଦି ତୁମ୍ଭେମାନେ ମୋ ଉପରେ ସନ୍ତୁଷ୍ଟ ଅଛନ୍ତି, ତେବେ ଏହି ଦାସର ସ୍ଥାନରେ (ଏଠାରେ) କିଛି ସମୟ ରୁହନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ବିନୟ କରୁଅଛି, ମୋତେ ଅଳ୍ପ ଜଳ ଆଣିବାକୁ ଦିଅନ୍ତୁ ପୁଣି, ଆପଣମାନେ ପାଦ ପ୍ରକ୍ଷାଳନ କରି ଏହି ବୃକ୍ଷ ତଳେ ବିଶ୍ରାମ କରନ୍ତୁ ");
INSERT INTO ory_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ଯେହେତୁ ଆପଣମାନେ ଆପଣଙ୍କ ଦାସଙ୍କ ନିକଟକୁ ଆସିଅଛନ୍ତି, ଏଥିପାଇଁ ମୋତେ କିଛି ଖାଦ୍ୟଦ୍ରବ୍ୟ ଆଣିବାକୁ ଦିଅନ୍ତୁ, ପୁଣି ଭୋଜନ କଲା ପରେ ଆପଣମାନେ ଗମନ କରିବେ।” ସେତେବେଳେ ସେମାନେ କହିଲେ, “ଯାହା କହୁଅଛ, ତାହା କର।” ");
INSERT INTO ory_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ତହିଁରେ ଅବ୍ରହାମ ଶୀଘ୍ର ତମ୍ବୁଗୃହକୁ ସାରା ନିକଟକୁ ଯାଇ କହିଲେ, “ତିନି ସେର ଉତ୍ତମ ମଇଦା ନେଇ ଛାଣି ଶୀଘ୍ର ରୁଟି ପ୍ରସ୍ତୁତ କର।” ");
INSERT INTO ory_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ଗୋଠକୁ ଶୀଘ୍ର ଯାଇ ଉତ୍ତମ କୋମଳ ଗୋବତ୍ସ ଆଣି ଦାସକୁ ଦିଅନ୍ତେ, ସେ ତାହା ଶୀଘ୍ର ରାନ୍ଧିଲା। ");
INSERT INTO ory_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ସେତେବେଳେ ସେ ଦହି, ଦୁଗ୍ଧ ଓ ପକ୍ୱ ଗୋବତ୍ସ ଆଣି ସେମାନଙ୍କ ନିକଟରେ ରଖିଲେ, ପୁଣି, ସେମାନଙ୍କ ଭୋଜନ ସମୟରେ ବୃକ୍ଷ ମୂଳେ ସେମାନଙ୍କ ନିକଟରେ ଛିଡ଼ା ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ତହିଁ ଉତ୍ତାରେ ସେମାନେ ତାଙ୍କୁ ପଚାରିଲେ, “ତୁମ୍ଭର ଭାର୍ଯ୍ୟା ସାରା କେଉଁଠାରେ?” ସେ କହିଲେ, “ଦେଖନ୍ତୁ, ସେ ତମ୍ବୁରେ ଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ତହୁଁ ସେ କହିଲେ, “ଏହି ଋତୁ ପୁନର୍ବାର ଉପସ୍ଥିତ ହେବା ସମୟରେ ଆମ୍ଭେ ଅବଶ୍ୟ ଫେରି ଆସିବା; ଦେଖ, ସେହି ସମୟରେ ତୁମ୍ଭ ଭାର୍ଯ୍ୟା ସାରାର (କୋଳରେ) ଗୋଟିଏ ପୁତ୍ର ଥିବ।” ଏହି କଥା ସାରା ତମ୍ବୁ ଦ୍ୱାରରେ ତାଙ୍କ ପଛେ ଥାଇ ଶୁଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ସେହି ସମୟରେ ଅବ୍ରହାମ ଓ ସାରା ବୃଦ୍ଧ ଓ ଗତବୟସ୍କ ଥିଲେ, ପୁଣି, ସାରାଙ୍କର ସ୍ତ୍ରୀଧର୍ମ ନିବୃତ୍ତ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ଏନିମନ୍ତେ ସାରା ହସି ମନେ ମନେ କହିଲେ, “ମୋହର ଏହି ଶୀର୍ଣ୍ଣାବସ୍ଥାରେ କି ଏରୂପ ଆନନ୍ଦ ହେବ? ବିଶେଷତଃ ମୋହର ପ୍ରଭୁ ମଧ୍ୟ ବୃଦ୍ଧ।” ");
INSERT INTO ory_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ସେତେବେଳେ ସଦାପ୍ରଭୁ ଅବ୍ରହାମଙ୍କୁ କହିଲେ, “‘ଆପଣାର ବୃଦ୍ଧାବସ୍ଥାରେ କି ନିଶ୍ଚୟ ସନ୍ତାନ ଜନ୍ମିବ,’ ଏହା ଭାବି ସାରା କାହିଁକି ହସିଲା? ");
INSERT INTO ory_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ସଦାପ୍ରଭୁଙ୍କ ନିମନ୍ତେ କୌଣସି କର୍ମ କଠିନ ଅଟେ କି? ଏହି ଋତୁ ପୁନର୍ବାର ଉପସ୍ଥିତ ହେଲେ, ନିରୂପିତ ସମୟରେ ଆମ୍ଭେ ଫେରି ଆସିବା, ସେହି ସମୟରେ ସାରାର (କୋଳରେ) ପୁତ୍ର ଥିବ।” ");
INSERT INTO ory_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ତହିଁରେ ସାରା ଅସ୍ୱୀକାର କରି କହିଲେ, “ମୁଁ ହସି ନାହିଁ,” ଯେହେତୁ ସେ ଭୟ କଲେ। ମାତ୍ର ସଦାପ୍ରଭୁ କହିଲେ, “ତୁମ୍ଭେ ଅବଶ୍ୟ ହସିଲ।” ");
INSERT INTO ory_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ଏଥିଉତ୍ତାରେ ସେହି ଲୋକମାନେ ସେଠାରୁ ଉଠି ସଦୋମ ଆଡ଼କୁ ପ୍ରସ୍ଥାନ କରନ୍ତେ, ଅବ୍ରହାମ ବାଟ ଦେଖାଇବାକୁ ସେମାନଙ୍କ ସଙ୍ଗେ ସଙ୍ଗେ ଚାଲିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ତହୁଁ ସଦାପ୍ରଭୁ କହିଲେ, “ଆମ୍ଭେ ଯାହା କରିବାକୁ ଉଦ୍ୟତ ଅଟୁ, ତାହା କି ଅବ୍ରହାମଠାରୁ ଲୁଚାଇବା? ");
INSERT INTO ory_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ଅବ୍ରହାମଠାରୁ ଏକ ମହତୀ ଓ ବଳବତୀ ଗୋଷ୍ଠୀ ଉତ୍ପନ୍ନ ହେବ ଓ ପୃଥିବୀର ଯାବତୀୟ ଗୋଷ୍ଠୀ ତାହାଠାରୁ ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ଯେହେତୁ ତାହାର ଭବିଷ୍ୟତ ସନ୍ତାନଗଣ ଓ ପରିବାରବର୍ଗ ଯେପରି ନ୍ୟାୟ ଓ ଧର୍ମାଚରଣ କରିବାକୁ ସଦାପ୍ରଭୁଙ୍କ ପଥରେ ଚାଲିବେ, ଏଥିପାଇଁ ସେମାନଙ୍କୁ ସେ ଯେପରି ଆଜ୍ଞା ଦେବ, ଏହି ଅଭିପ୍ରାୟରେ ଆମ୍ଭେ ତାହାକୁ ନିର୍ଦ୍ଧାରଣ କରିଅଛୁ; ତହିଁରେ ସଦାପ୍ରଭୁ ଅବ୍ରହାମଙ୍କ ବିଷୟରେ ଆପଣା କଥିତ ବାକ୍ୟ ସିଦ୍ଧ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ସଦାପ୍ରଭୁ ଆହୁରି କହିଲେ, “ସଦୋମ ଓ ହମୋରାର ବିରୁଦ୍ଧରେ ମହାଧ୍ୱନି ଉଠୁଅଛି, ସେମାନଙ୍କର ପାପ ଅତିଶୟ ଗୁରୁତର; ");
INSERT INTO ory_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ଏଣୁ ଆମ୍ଭେ ତଳକୁ ଦେଖିବାକୁ ଯାଇ ଆମ୍ଭ ନିକଟକୁ ଆଗତ କ୍ରନ୍ଦନ ଅନୁସାରେ ସେମାନେ ସର୍ବତୋଭାବେ କରିଅଛନ୍ତି କି ନାହିଁ, ତାହା ଜାଣିବା।” ");
INSERT INTO ory_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ଏଥିଉତ୍ତାରେ ସେହି ବ୍ୟକ୍ତିମାନେ ସେହିଠାରୁ ବାହୁଡ଼ି ସଦୋମ ଆଡ଼କୁ ଗମନ କଲେ; ମାତ୍ର ଅବ୍ରହାମ ସେ ପର୍ଯ୍ୟନ୍ତ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଛିଡ଼ା ହୋଇ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ନିକଟକୁ ଯାଇ କହିଲେ, “ଆପଣ କି ଦୁଷ୍ଟ ସହିତ ଧାର୍ମିକକୁ ସଂହାର କରିବେ? ");
INSERT INTO ory_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ହୋଇପାରେ, ନଗର ମଧ୍ୟରେ ପଚାଶ ଜଣ ଧାର୍ମିକ ଥିବେ; ତହିଁ ମଧ୍ୟବର୍ତ୍ତୀ ପଚାଶ ଜଣ ଧାର୍ମିକଙ୍କ ସକାଶେ କି ସେହି ସ୍ଥାନ ରକ୍ଷା ନ କରି ସଂହାର କରିବେ? ");
INSERT INTO ory_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ଦୁଷ୍ଟ ସହିତ ଧାର୍ମିକକୁ ବିନାଶ କରିବାର କର୍ମ ଆପଣଙ୍କଠାରୁ ଦୂରେ ଥାଉ ଓ ଧାର୍ମିକକୁ ଦୁଷ୍ଟର ସମାନ କରିବା ଆପଣଙ୍କଠାରୁ ଦୂରେ ଥାଉ। ସମସ୍ତ ପୃଥିବୀର ବିଚାରକର୍ତ୍ତା କି ନ୍ୟାୟବିଚାର କରିବେ ନାହିଁ?” ");
INSERT INTO ory_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ତହିଁରେ ସଦାପ୍ରଭୁ କହିଲେ, “ଆମ୍ଭେ ଯଦି ସଦୋମ ନଗରରେ ପଚାଶ ଜଣ ଧାର୍ମିକ ଦେଖିବା, ତେବେ ସେମାନଙ୍କ ସକାଶେ ସମସ୍ତ ସ୍ଥାନ ରକ୍ଷା କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ତହିଁରେ ଅବ୍ରହାମ ପ୍ରତ୍ୟୁତ୍ତର କଲେ, “ଦେଖନ୍ତୁ, ମୁଁ ଧୂଳି ଓ ଭସ୍ମମାତ୍ର ହେଲେ ହେଁ ମୋ ପ୍ରଭୁଙ୍କ ଛାମୁରେ କଥା କହିବାକୁ ପ୍ରବୃତ୍ତ ହୋଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ହୋଇପାରେ, ପଚାଶ ଜଣ ଧାର୍ମିକ ମଧ୍ୟରୁ ପାଞ୍ଚ ଜଣ ଊଣା ଥିବେ; ସେହି ପାଞ୍ଚ ଜଣ ଊଣା ହେବା ସକାଶୁ କି ଆପଣ ସମସ୍ତ ନଗର ବିନଷ୍ଟ କରିବେ?” ସଦାପ୍ରଭୁ କହିଲେ, “ଆମ୍ଭେ ପଞ୍ଚଚାଳିଶ ଜଣ ପାଇଲେ, ତାହା ବିନଷ୍ଟ କରିବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ଅବ୍ରହାମ ତାହାଙ୍କୁ ପୁନର୍ବାର କହିଲେ, “ହୋଇପାରେ, ସେଠାରେ ଚାଳିଶ ଜଣ ମିଳିବେ।” ସଦାପ୍ରଭୁ କହିଲେ, “ସେହି ଚାଳିଶ ଜଣ ସକାଶୁ ତାହା କରିବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ପୁନର୍ବାର ଅବ୍ରହାମ କହିଲେ, “ପ୍ରଭୁ ବିରକ୍ତ ନୋହିଲେ ଆହୁରି କଥାଟିଏ କହିବି; ହୋଇପାରେ, ସେଠାରେ ତିରିଶ ଜଣ ମିଳିବେ।” ସଦାପ୍ରଭୁ କହିଲେ, “ତିରିଶ ଜଣ ପାଇଲେ, ତାହା କରିବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ଅବ୍ରହାମ କହିଲେ, “ଦେଖନ୍ତୁ, ପ୍ରଭୁଙ୍କ ଛାମୁରେ ମୁଁ ପୁନର୍ବାର କଥା କହିବାକୁ ପ୍ରବୃତ୍ତ ହୋଇଅଛି; ହୋଇପାରେ, ସେଠାରେ କୋଡ଼ିଏ ଜଣ ମିଳିବେ।” ସଦାପ୍ରଭୁ କହିଲେ, “ସେହି କୋଡ଼ିଏ ଜଣ ସକାଶୁ ଆମ୍ଭେ ତାହା ବିନଷ୍ଟ କରିବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ଅବ୍ରହାମ କହିଲେ, “ପ୍ରଭୁ ବିରକ୍ତ ନୋହିଲେ ଆଉ ଥରେ ମାତ୍ର କହିବି; ହୋଇପାରେ, ସେଠାରେ ଦଶ ଜଣ ମିଳିବେ।” ସଦାପ୍ରଭୁ କହିଲେ, “ସେହି ଦଶ ଜଣ ସକାଶୁ ଆମ୍ଭେ ତାହା ବିନଷ୍ଟ କରିବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ସେତେବେଳେ ସଦାପ୍ରଭୁ ଅବ୍ରହାମଙ୍କ ସହିତ ଏପ୍ରକାର କଥୋପକଥନ ସମାପନ କରି ପ୍ରସ୍ଥାନ କଲେ, ପୁଣି, ଅବ୍ରହାମ ମଧ୍ୟ ସ୍ୱ ସ୍ଥାନକୁ ଫେରିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ଏଥିଉତ୍ତାରେ ସନ୍ଧ୍ୟା ବେଳେ ସେହି ଦୁଇ ସ୍ୱର୍ଗଦୂତ ସଦୋମରେ ଉପସ୍ଥିତ ହେଲେ; ସେତେବେଳେ ଲୋଟ ସଦୋମ ନଗରର ଦ୍ୱାରରେ ଉପବିଷ୍ଟ ଥିବାରୁ ସେମାନଙ୍କୁ ଦେଖି ସେମାନଙ୍କ ସହିତ ସାକ୍ଷାତ କରିବାକୁ ଉଠିଲା, ପୁଣି, ଭୂମିଷ୍ଠ ପ୍ରଣାମ କରି କହିଲା ");
INSERT INTO ory_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ହେ ମୋହର ପ୍ରଭୁମାନେ, ମୁଁ ବିନୟ କରୁଅଛି, ଆଜି ରାତ୍ର ଆପଣମାନଙ୍କ ଏହି ଦାସର ଗୃହରେ ପଦାର୍ପଣ କରି ବାସ କରନ୍ତୁ ଓ ପାଦ ପ୍ରକ୍ଷାଳନ କରନ୍ତୁ; ତହୁଁ ସକାଳୁ ଉଠି ଯାତ୍ରା କରିବେ।” ତହିଁରେ ସେମାନେ କହିଲେ, “ନା; ଆମ୍ଭେମାନେ ଦାଣ୍ଡରେ ସମସ୍ତ ରାତ୍ରି କ୍ଷେପଣ କରିବୁ।” ");
INSERT INTO ory_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ମାତ୍ର ଲୋଟ ଅତିଶୟ ବଳାଇବାରୁ ସେମାନେ ତାହା ସହିତ ଯାଇ ତାହାର ଘରେ ପ୍ରବେଶ କଲେ; ତହୁଁ ସେ ସେମାନଙ୍କର ପାଇଁ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଆଦି ଖାଦ୍ୟଦ୍ରବ୍ୟ ପ୍ରସ୍ତୁତ କରନ୍ତେ, ସେମାନେ ଭୋଜନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ମାତ୍ର ସେମାନେ ଶୟନ କରିବା ପୂର୍ବେ ସେହି ନଗରର ଲୋକମାନେ, ଅର୍ଥାତ୍‍, ସଦୋମର ଯୁବାବୃଦ୍ଧାଦି ସମସ୍ତ ଲୋକ ଚାରିଆଡ଼ୁ ଆସି ତାହାର ଘର ଘେରିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ପୁଣି, ଲୋଟକୁ ଡାକି କହିଲେ, “ଆଜି ରାତ୍ରିରେ ଯେଉଁ ମନୁଷ୍ୟମାନେ ତୁମ୍ଭ ଘରକୁ ଆସିଲେ, ସେମାନେ କାହାନ୍ତି? ସେମାନଙ୍କୁ ବାହାର କରି ଆମ୍ଭମାନଙ୍କ ପାଖକୁ ଆଣ। ଆମ୍ଭେମାନେ ସେମାନଙ୍କଠାରେ ଉପଗତ ହେବା।” ");
INSERT INTO ory_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ତହିଁରେ ଲୋଟ ବାହାରକୁ ଆସି ଦ୍ୱାର ବନ୍ଦ କରି କହିଲା, ");
INSERT INTO ory_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“ହେ ଭାଇମାନେ, ମୁଁ ବିନୟ କରୁଅଛି, ଏପରି କୁବ୍ୟବହାର କର ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ଦେଖ, ପୁରୁଷ-ଅସ୍ପୃଷ୍ଟା ମୋହର ଦୁଇଟି କନ୍ୟା ଅଛନ୍ତି, ସେମାନଙ୍କୁ ତୁମ୍ଭମାନଙ୍କ ନିକଟକୁ ଆଣୁଅଛି, ତୁମ୍ଭମାନଙ୍କ ଦୃଷ୍ଟିରେ ଯାହା ଭଲ, ତାହା ସେମାନଙ୍କ ପ୍ରତି କର, ମାତ୍ର ସେହି ମନୁଷ୍ୟମାନଙ୍କ ପ୍ରତି କିଛି କର ନାହିଁ, କାରଣ ଏଥିନିମନ୍ତେ ସେମାନେ ମୋʼ ଛାତ ତଳେ ଆଶ୍ରୟ ନେଇଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ସେତେବେଳେ ସେମାନେ କହିଲେ, “ଘୁଞ୍ଚି ଯା।” ପୁଣି କହିଲେ, “ଏ ଲୋକଟା ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସ କରିବାକୁ ଆସି ଆମ୍ଭମାନଙ୍କର ବିଚାରକର୍ତ୍ତା ହେବାକୁ ଚାହେଁ; ଏବେ ସେମାନଙ୍କଠାରୁ ତୋʼ ପ୍ରତି ଆହୁରି କୁବ୍ୟବହାର କରିବା।” ତହୁଁ ସେମାନେ ସେହି ମନୁଷ୍ୟ, ଅର୍ଥାତ୍‍, ଲୋଟ ପ୍ରତି ବଳ ପ୍ରୟୋଗ କରି କବାଟ ଭାଙ୍ଗିବାକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ମାତ୍ର ସେହି ଦୁଇ ଜଣ ହସ୍ତ ବଢ଼ାଇ ଲୋଟକୁ ଗୃହ ମଧ୍ୟରେ ଆପଣାମାନଙ୍କ ନିକଟକୁ ଟାଣି ନେଇ ଦ୍ୱାର ବନ୍ଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ପୁଣି, ଦ୍ୱାର ନିକଟବର୍ତ୍ତୀ ସାନ ଓ ବଡ଼ ସମସ୍ତଙ୍କୁ ଅନ୍ଧ କରାଇଲେ; ତହିଁରେ ସେମାନେ ଦ୍ୱାର ଖୋଜୁ ଖୋଜୁ ପରିଶ୍ରାନ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ଏଥିଉତ୍ତାରେ ସେହି ବ୍ୟକ୍ତିମାନେ ଲୋଟକୁ କହିଲେ, “ଏହି ସ୍ଥାନରେ ତୁମ୍ଭର ଆଉ କିଏ କିଏ ଅଛନ୍ତି? ଜୁଆଁଇ ଓ ତୁମ୍ଭର ପୁତ୍ରକନ୍ୟାଦି ଯେତେ ଲୋକ ଏହି ନଗରରେ ଅଛନ୍ତି, ସେ ସମସ୍ତଙ୍କୁ ଏହି ସ୍ଥାନରୁ ନେଇଯାଅ; ");
INSERT INTO ory_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ଯେହେତୁ ଆମ୍ଭେମାନେ ଏହି ସ୍ଥାନ ଉଚ୍ଛିନ୍ନ କରିବା। ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଏହି ନଗର ବିରୁଦ୍ଧରେ ମହାକ୍ରନ୍ଦନ ଉଠିଅଛି, ଏଣୁ ସଦାପ୍ରଭୁ ଏହି ନଗର ଉଚ୍ଛିନ୍ନ କରିବା ପାଇଁ ଆମ୍ଭମାନଙ୍କୁ ପଠାଇଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ତହୁଁ ଲୋଟ ବାହାରକୁ ଯାଇ ଆପଣା କନ୍ୟାମାନଙ୍କ ସହିତ ବିବାହ କରିବାକୁ ଉଦ୍ୟତ ଜୁଆଁଇମାନଙ୍କୁ କହିଲା, “ଉଠ, ଏଠାରୁ ବାହାର ହୁଅ, ସଦାପ୍ରଭୁ ଏହି ନଗର ଉଚ୍ଛିନ୍ନ କରିବେ,” ମାତ୍ର ଜୁଆଁଇମାନେ ତାହାକୁ ପରିହାସକ ପରି ମଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ଆରଦିନ ପ୍ରଭାତ ହୁଅନ୍ତେ, ଦୂତମାନେ ଲୋଟକୁ ଚଞ୍ଚଳ କରାଇ କହିଲେ, “ଉଠ, ଆପଣାର ଭାର୍ଯ୍ୟା ଓ ଏହି ଯେଉଁ ଦୁଇ କନ୍ୟା ଏଠାରେ ଅଛନ୍ତି, ସେମାନଙ୍କୁ ଘେନିଯାଅ; ନୋହିଲେ ନଗରର ଦଣ୍ଡରେ ବିନଷ୍ଟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ତଥାପି ସେ ବିଳମ୍ବ କଲା; ତହିଁରେ ତାହା ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର ଦୟା ସକାଶୁ ସେମାନେ ତାହାର ଓ ତାହା ଭାର୍ଯ୍ୟାର ଓ ଦୁଇ କନ୍ୟାଙ୍କର ହସ୍ତ ଧରି ସେମାନଙ୍କୁ ନଗରର ବାହାରେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ଏହିରୂପେ ସେମାନଙ୍କୁ ବାହାର କରି ଆଣିଲା ଉତ୍ତାରେ ସେମାନଙ୍କ ମଧ୍ୟରୁ ଜଣେ ଲୋଟକୁ କହିଲା, “ପ୍ରାଣରକ୍ଷା ନିମନ୍ତେ ପଳାଅ; ପଛଆଡ଼କୁ ଦୃଷ୍ଟି କର ନାହିଁ ଓ ଏହି ସମସ୍ତ ପ୍ରାନ୍ତର ମଧ୍ୟରେ ହେଁ ରୁହ ନାହିଁ; ପର୍ବତକୁ ପଳାଇ ଯାଅ; ନୋହିଲେ ବିନଷ୍ଟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ତହିଁରେ ଲୋଟ ଉତ୍ତର କଲା, “ହେ ମୋହର ପ୍ରଭୋ, ଏପରି ନ ହେଉ; ");
INSERT INTO ory_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ଏବେ ଏହି ଦାସ ପ୍ରତି ଅନୁଗ୍ରହ ଓ ମହାଦୟା କରି ପ୍ରାଣରକ୍ଷା କଲେ; ମୁଁ ପର୍ବତକୁ ପଳାଇ ଯାଇ ନ ପାରେ; କେଜାଣି ବିପଦ ଘଟିଲେ ମରିଯିବି। ");
INSERT INTO ory_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ଦେଖନ୍ତୁ, ପଳାଇ ଯିବାକୁ ସେହି ନଗର ନିକଟବର୍ତ୍ତୀ, ତାହା କ୍ଷୁଦ୍ର; ସେହି ସ୍ଥାନକୁ ପଳାଇବାକୁ ଆଜ୍ଞା କରନ୍ତୁ, ତହିଁରେ ମୋହର ପ୍ରାଣ ବଞ୍ଚିବ; ତାହା କି କ୍ଷୁଦ୍ର ନୁହେଁ?” ");
INSERT INTO ory_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ତହୁଁ ସେ କହିଲେ, “ଭଲ, ଆମ୍ଭେ ଏ ବିଷୟରେ ତୁମ୍ଭ ପ୍ରତି ଅନୁଗ୍ରହ କରି, ସେହି ଯେଉଁ ନଗରର କଥା ତୁମ୍ଭେ କହିଲ, ତାହା ଉତ୍ପାଟନ କରିବା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ତୁମ୍ଭେ ଶୀଘ୍ର ସେହି ସ୍ଥାନକୁ ପଳାଅ, ଯେହେତୁ ତୁମ୍ଭେ ସେଠାରେ ଉପସ୍ଥିତ ନ ହେଲେ, ଆମ୍ଭେ କିଛି କରି ନ ପାରୁ।” ଏଣୁ ସେହି ସ୍ଥାନର ନାମ ସୋୟର ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ଏଥିଉତ୍ତାରେ ଦେଶରେ ସୂର୍ଯ୍ୟୋଦୟ ହୁଅନ୍ତେ, ଲୋଟ ସୋୟରରେ ପ୍ରବେଶ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ତେବେ ସଦାପ୍ରଭୁ ଆକାଶରୁ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରୁ ସଦୋମ ଓ ହମୋରା ଉପରେ ଗନ୍ଧକ ଓ ଅଗ୍ନି ବୃଷ୍ଟି କରି ");
INSERT INTO ory_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ସେହି ସମୁଦାୟ ନଗର ଓ ପ୍ରାନ୍ତର ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ଲୋକ ଓ ସେହି ଭୂମିରେ ଜାତ ସକଳ ପଦାର୍ଥ ଉତ୍ପାଟନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ସେହି ସମୟରେ ଲୋଟର ଭାର୍ଯ୍ୟା ପଛଆଡ଼କୁ ଅନାଇବାରୁ ସେ ଲବଣ ସ୍ତମ୍ଭ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ଆଉ ଅବ୍ରହାମ ପ୍ରଭାତରୁ ଉଠି ପୂର୍ବେ ଯେଉଁ ସ୍ଥାନରେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଠିଆ ହୋଇଥିଲେ, ସେହି ସ୍ଥାନରେ ଉପସ୍ଥିତ ହୋଇ ");
INSERT INTO ory_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ସଦୋମ ଓ ହମୋରା ଓ ପ୍ରାନ୍ତରସ୍ଥ ସମସ୍ତ ଅଞ୍ଚଳ ପ୍ରତି ଅନାନ୍ତେ, ସେହି ଦେଶରୁ ଭାଟିର ଧୂମ ତୁଲ୍ୟ ଧୂମ ଉଠିବାର ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ଏହିରୂପେ ସେହି ପ୍ରାନ୍ତରସ୍ଥିତ ସମସ୍ତ ନଗରର ବିନାଶ ସମୟରେ ପରମେଶ୍ୱର ଅବ୍ରହାମଙ୍କୁ ସ୍ମରଣ କଲେ, ପୁଣି, ଲୋଟ ଯେଉଁ ଯେଉଁ ନଗରରେ ବାସ କରିଥିଲା, ସେହି ସେହି ନଗରର ଉତ୍ପାଟନ ସମୟରେ ଉତ୍ପାଟନ ମଧ୍ୟରୁ ଲୋଟକୁ ବାହାର କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ଏଥିଉତ୍ତାରେ ଲୋଟ ସୋୟରରେ ବାସ କରିବାକୁ ଭୟ କରି ସେଠାରୁ ବାହାରି ଆପଣାର ଦୁଇ କନ୍ୟାଙ୍କୁ ଘେନି ପର୍ବତରେ ବାସ କଲା; ତହିଁରେ ସେ ଓ ତାହାର ଦୁଇ କନ୍ୟା ଗିରି କନ୍ଦରରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ଏଥିଉତ୍ତାରେ ତାହାର ଜ୍ୟେଷ୍ଠା କନ୍ୟା କନିଷ୍ଠାକୁ କହିଲା, “ଆମ୍ଭମାନଙ୍କର ପିତା ବୃଦ୍ଧ, ପୁଣି, ସଂସାରର ବ୍ୟବହାରାନୁସାରେ ଆମ୍ଭମାନଙ୍କର ସହବାସ କରିବାକୁ ଏ ଦେଶରେ ତ କୌଣସି ପୁରୁଷ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ଆସ, ଆମ୍ଭେମାନେ ପିତାଙ୍କୁ ଦ୍ରାକ୍ଷାରସ ପାନ କରାଇ ପିତାଙ୍କ ବଂଶ ରକ୍ଷା ନିମିତ୍ତ ତାଙ୍କ ସଙ୍ଗେ ଶୟନ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ତହୁଁ ସେହି ରାତ୍ରରେ ସେମାନେ ଆପଣା ପିତାଙ୍କୁ ଦ୍ରାକ୍ଷାରସ ପାନ କରାନ୍ତେ, ଜ୍ୟେଷ୍ଠା କନ୍ୟା ଉଠିଯାଇ ପିତା ସଙ୍ଗେ ଶୟନ କଲା; ମାତ୍ର ତାହାର ଶୟନ କରିବାର ଓ ଉଠିଯିବାର ଲୋଟ ଜାଣି ପାରିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ଆରଦିନ ସେହି ଜ୍ୟେଷ୍ଠା କନ୍ୟା କନିଷ୍ଠାକୁ କହିଲା, “ଦେଖ, ମୁଁ ଗତ ରାତ୍ର ପିତାଙ୍କ ସଙ୍ଗରେ ଶୟନ କଲି, ଆସ, ଆଜି ରାତ୍ର ମଧ୍ୟ ପିତାଙ୍କୁ ଦ୍ରାକ୍ଷାରସ ପାନ କରାଉ; ତହୁଁ ତୁମ୍ଭେ ଯାଇ ପିତାଙ୍କ ବଂଶ ରକ୍ଷାର୍ଥେ ତାଙ୍କ ସଙ୍ଗେ ଶୟନ କର।” ");
INSERT INTO ory_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ତହିଁରେ ସେମାନେ ସେହି ରାତ୍ରିରେ ମଧ୍ୟ ପିତାଙ୍କୁ ଦ୍ରାକ୍ଷାରସ ପାନ କରାନ୍ତେ, କନିଷ୍ଠା କନ୍ୟା ଉଠି ତାହା ସଙ୍ଗେ ଶୟନ କଲା; ମାତ୍ର ତାହାର ଶୟନ କରିବାର ଓ ଉଠିଯିବାର ଲୋଟ ଜାଣି ପାରିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ଏହିରୂପେ ଲୋଟର ଦୁଇ କନ୍ୟା ଆପଣା ପିତା ଦ୍ୱାରା ଗର୍ଭବତୀ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ଏଥିଉତ୍ତାରେ ଜ୍ୟେଷ୍ଠା କନ୍ୟା ପୁତ୍ର ପ୍ରସବ କରି ତାହାର ନାମ ମୋୟାବ ଦେଲା; ସେ ବର୍ତ୍ତମାନ କାଳର ମୋୟାବୀୟ ଲୋକମାନଙ୍କର ଆଦିପିତା। ");
INSERT INTO ory_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ପୁଣି, କନିଷ୍ଠା କନ୍ୟା ପୁତ୍ର ପ୍ରସବ କରି ତାହାର ନାମ ବିନ-ଅମ୍ମି ଦେଲା; ସେ ବର୍ତ୍ତମାନ କାଳର ଅମ୍ମୋନୀୟ ଲୋକମାନଙ୍କର ଆଦିପିତା। ");
INSERT INTO ory_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ସେଠାରୁ ଦକ୍ଷିଣ ଦେଶକୁ ଯାତ୍ରା କରି କାଦେଶ ଓ ଶୂରର ମଧ୍ୟସ୍ଥାନରେ ଥାଇ ଗରାରରେ ପ୍ରବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ପୁଣି, ଅବ୍ରହାମ ଆପଣା ଭାର୍ଯ୍ୟା ସାରା ବିଷୟରେ କହିଲେ, “ସେ ମୋହର ଭଗିନୀ;” ଏହେତୁ ଗରାରର ରାଜା ଅବିମେଲକ ଲୋକ ପଠାଇ ସାରାକୁ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ତହୁଁ ରାତ୍ରିକାଳରେ ପରମେଶ୍ୱର ସ୍ୱପ୍ନ ଯୋଗେ ଅବିମେଲକଙ୍କ ନିକଟକୁ ଆସି କହିଲେ, “ଦେଖ; ତୁମ୍ଭେ ମୃତକଳ୍ପ, କାରଣ ସେହି ଯେଉଁ ସ୍ତ୍ରୀକୁ ତୁମ୍ଭେ ନେଇଅଛ, ତାହାର ସ୍ୱାମୀ ଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ମାତ୍ର ଅବିମେଲକ ତାହାର ସହବାସ କରି ନ ଥିବାରୁ କହିଲେ, “ହେ ପ୍ରଭୁ, ଯେଉଁ ଦେଶୀୟ ଲୋକେ ନିର୍ଦ୍ଦୋଷ, ସେମାନଙ୍କୁ ହିଁ କି ଆପଣ ବଧ କରିବେ? ");
INSERT INTO ory_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ସେହି ବ୍ୟକ୍ତି କି ନିଜେ ମୋତେ କହି ନ ଥିଲା ଯେ, ସେ ମୋହର ଭଗିନୀ? ପୁଣି, ସେହି ସ୍ତ୍ରୀ ନିଜେ କହିଲା କି ସେ ମୋହର ଭ୍ରାତା; ଏଣୁ ମନର ସରଳତା ଓ ହସ୍ତର ନିର୍ଦ୍ଦୋଷତାରେ ମୁଁ ଏହି କାର୍ଯ୍ୟ କରିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ତେବେ ପରମେଶ୍ୱର ସ୍ୱପ୍ନ ଯୋଗେ ତାହାକୁ କହିଲେ, “ତୁମ୍ଭେ ମନର ସରଳତାରେ ଏହି କର୍ମ କରିଅଛ; ଏହା ଆମ୍ଭେ ଜାଣୁ; ପୁଣି, ଆମ୍ଭେ ମଧ୍ୟ ଆମ୍ଭ ବିରୁଦ୍ଧରେ ପାପ କରିବାକୁ ତୁମ୍ଭକୁ ବାରଣ କଲୁ; ଏନିମନ୍ତେ ତାଙ୍କୁ ସ୍ପର୍ଶ କରିବାକୁ ତୁମ୍ଭଙ୍କୁ ଦେଲୁ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ଏହେତୁ ଏବେ ସେହି ମନୁଷ୍ୟର ଭାର୍ଯ୍ୟାକୁ ଫେରାଇ ଦିଅ; ଯେହେତୁ ସେ ଭବିଷ୍ୟଦ୍‍ବକ୍ତା, ସେ ତୁମ୍ଭ ଲାଗି ପ୍ରାର୍ଥନା କରିବ, ତହିଁରେ ତୁମ୍ଭେ ବଞ୍ଚିବ; ମାତ୍ର ଯଦି ତାଙ୍କୁ ଫେରାଇ ନ ଦେବ, ତେବେ ଅବଶ୍ୟ ତୁମ୍ଭେ ସପରିବାରରେ ମରିବ, ଏହା ଜାଣିଥାଅ।” ");
INSERT INTO ory_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ଏଥିଉତ୍ତାରେ ଅବିମେଲକ ପ୍ରଭାତରେ ଉଠି ଦାସମାନଙ୍କୁ ଡାକି ଏସବୁ ବୃତ୍ତାନ୍ତ ସେମାନଙ୍କ କର୍ଣ୍ଣଗୋଚର କରନ୍ତେ, ସେମାନେ ଅତି ଭୟାକୁଳ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ତହିଁରେ ଅବିମେଲକ ଅବ୍ରହାମଙ୍କୁ ଡାକି କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ପ୍ରତି ଏ କି ବ୍ୟବହାର କଲ? ତୁମ୍ଭେ ଯେ ଆମ୍ଭକୁ ଓ ଆମ୍ଭର ରାଜ୍ୟକୁ ମହା ପାପଗ୍ରସ୍ତ କଲ, ଆମ୍ଭେ ତୁମ୍ଭ ବିରୁଦ୍ଧରେ ଏପରି କି ଦୋଷ କରିଅଛୁ? ତୁମ୍ଭେ ଆମ୍ଭ ପ୍ରତି ଅକର୍ତ୍ତବ୍ୟ କର୍ମ କଲ।” ");
INSERT INTO ory_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ଅବିମେଲକ ଅବ୍ରହାମଙ୍କୁ ଆହୁରି କହିଲେ, “ତୁମ୍ଭେ କʼଣ ଦେଖି ଏରୂପ କର୍ମ କଲ?” ");
INSERT INTO ory_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ସେତେବେଳେ ଅବ୍ରହାମ କହିଲେ, “ଏ ଦେଶରେ ପରମେଶ୍ୱରଙ୍କ ପ୍ରତି କିଛି ଭୟ ନାହିଁ; ଏନିମନ୍ତେ ମୁଁ ଭାବିଲି, ଏମାନେ ଅବା ମୋହର ଭାର୍ଯ୍ୟା ଲୋଭରେ ମୋତେ ବଧ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ସେ ମୋହର ଭଗିନୀ, ଏହା ସତ୍ୟ, ଯେହେତୁ ସେ ମୋହର ପିତୃକନ୍ୟା, ମାତୃକନ୍ୟା ନୁହେଁ, ପୁଣି, ମୋହର ଭାର୍ଯ୍ୟା ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ଯେତେବେଳେ ପରମେଶ୍ୱର ମୋତେ ପୈତୃକ ଗୃହରୁ ଭ୍ରମଣ କରାଇଲେ, ସେତେବେଳେ ମୁଁ ତାହାକୁ କହିଲି, ‘ତୁମ୍ଭେ ମୋʼ ପ୍ରତି ଏହି ଅନୁଗ୍ରହ କରିବ, ଆମ୍ଭେମାନେ ଯେଉଁ ଯେଉଁ ସ୍ଥାନକୁ ଯିବୁ, ସେହି ସେହି ସ୍ଥାନରେ ତୁମ୍ଭେ ମୋତେ ଭାଇ ବୋଲି ପରିଚୟ ଦେବ।’” ");
INSERT INTO ory_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ସେତେବେଳେ ଅବିମେଲକ ମେଷ ଓ ଗୋରୁ ଓ ଦାସଦାସୀ ଅଣାଇ ଅବ୍ରହାମଙ୍କୁ ଦେଲେ ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟା ସାରାକୁ ମଧ୍ୟ ଫେରାଇ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ଏଥିଉତ୍ତାରେ ଅବିମେଲକ କହିଲେ, “ଦେଖ, ଆମ୍ଭର ଏହି ସମସ୍ତ ଦେଶ ତୁମ୍ଭ ସମ୍ମୁଖରେ ଅଛି, ତୁମ୍ଭର ଯେଉଁଠାରେ ଇଚ୍ଛା, ସେହିଠାରେ ବାସ କର।” ");
INSERT INTO ory_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ପୁଣି, ସେ ସାରାକୁ କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭ ଭ୍ରାତାକୁ ସହସ୍ର ଖଣ୍ଡ ରୂପା ଦେଲୁ; ଦେଖ, ତାହା ତୁମ୍ଭ ପ୍ରତି ଘଟିଥିବା ସକଳ ବିଷୟ ନିମନ୍ତେ ସମସ୍ତଙ୍କ ସାକ୍ଷାତରେ ଚକ୍ଷୁର ଆବରଣ ସ୍ୱରୂପ; ଆଉ ସମସ୍ତ ବିଷୟରେ ତୁମ୍ଭ ପ୍ରତି ନ୍ୟାୟବିଚାର କରାଗଲା।” ");
INSERT INTO ory_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ପରମେଶ୍ୱରଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କରନ୍ତେ, ପରମେଶ୍ୱର ଅବିମେଲକଙ୍କୁ ଓ ତାଙ୍କ ଭାର୍ଯ୍ୟାକୁ ଓ ତାହାର ଦାସୀଗଣକୁ ସୁସ୍ଥ କଲେ; ତହିଁରେ ସେମାନଙ୍କର ସନ୍ତାନସନ୍ତତି ଜାତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ଯେହେତୁ ଅବ୍ରହାମଙ୍କର ଭାର୍ଯ୍ୟା ସାରା ସକାଶେ ସଦାପ୍ରଭୁ ଅବିମେଲକଙ୍କ ଗୃହସ୍ଥିତ ଲୋକମାନଙ୍କର ଗର୍ଭରୋଧ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଆପଣା ବାକ୍ୟାନୁସାରେ ସାରାର ତତ୍ତ୍ୱାବଧାନ କଲେ; ପୁଣି, ସଦାପ୍ରଭୁ ଯାହା କହିଥିଲେ, ସାରା ପ୍ରତି ତାହା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ତହିଁରେ ସାରା ଅବ୍ରହାମଙ୍କର ବୃଦ୍ଧାବସ୍ଥାରେ ଗର୍ଭବତୀ ହୋଇ ପରମେଶ୍ୱରଙ୍କ ଦ୍ୱାରା ନିରୂପିତ ସମୟରେ ପୁତ୍ର ପ୍ରସବ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ସେତେବେଳେ ଅବ୍ରହାମ ସାରାର ଗର୍ଭଜାତ ନିଜ ପୁତ୍ରର ନାମ ଇସ୍‌ହାକ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ପୁଣି, ଅବ୍ରହାମ ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାନୁସାରେ ଆପଣା ପୁତ୍ର ଇସ୍‌ହାକକୁ ଅଷ୍ଟମ ଦିନରେ ସୁନ୍ନତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ଅବ୍ରହାମଙ୍କର ଶହେ ବର୍ଷ ବୟସରେ ତାଙ୍କର ପୁତ୍ର ଇସ୍‌ହାକ ଜାତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ଆଉ ସାରା କହିଲେ, “ପରମେଶ୍ୱର ମୋତେ ହସାଇଲେ, ଏହା ଶୁଣି ସମସ୍ତେ ମୋʼ ସହିତ ହସିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ସେ ଆହୁରି କହିଲେ, “ସାରା ସନ୍ତାନମାନଙ୍କୁ ସ୍ତନପାନ କରାଇବ, ଏ କଥା ଅବ୍ରହାମଙ୍କୁ କିଏ କହିପାରନ୍ତା? ଯେହେତୁ ମୁଁ ଏବେ ତାଙ୍କର ବୃଦ୍ଧାବସ୍ଥାରେ ପୁତ୍ର ପ୍ରସବ କଲି।” ");
INSERT INTO ory_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ଆଉ ବାଳକ ବଡ଼ ହୁଅନ୍ତେ, ସେମାନେ ତାକୁ ସ୍ତନପାନ ତ୍ୟାଗ କରାଇଲେ; ପୁଣି, ଯେଉଁ ଦିନ ଇସ୍‌ହାକକୁ ସ୍ତନପାନ ତ୍ୟାଗ କରାଇଲେ, ସେହି ଦିନ ଅବ୍ରହାମ ମହାଭୋଜ ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ଏଥିଉତ୍ତାରେ ମିସରୀୟା ହାଗାର ଅବ୍ରହାମଙ୍କ ନିମନ୍ତେ ଯେଉଁ ପୁତ୍ର ଜନ୍ମ କରିଥିଲା, ସାରା ଦେଖିଲା, ସେ ପରିହାସ କରୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ଏହେତୁ ସେ ଅବ୍ରହାମଙ୍କୁ କହିଲା, “ତୁମ୍ଭେ ଏହି ଦାସୀକୁ ଓ ଏହାର ପୁତ୍ରକୁ ଦୂର କରିଦିଅ; କାରଣ ଏହି ଦାସୀର ପୁତ୍ର ମୋହର ପୁତ୍ର ଇସ୍‌ହାକ ସହିତ ଉତ୍ତରାଧିକାରୀ ହେବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ଏହି କଥା ଶୁଣି ଅବ୍ରହାମ ଆପଣା ପୁତ୍ର ସକାଶୁ ଅତି ଦୁଃଖିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ସେତେବେଳେ ପରମେଶ୍ୱର ଅବ୍ରହାମଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଏହି ବାଳକ ଓ ତୁମ୍ଭ ଦାସୀ ନିମନ୍ତେ ଦୁଃଖିତ ହୁଅ ନାହିଁ; ସାରା ତୁମ୍ଭକୁ ଯାହା କହୁଅଛି, ତାହାର ସେହି କଥାରେ ମନୋଯୋଗ କର; ଯେହେତୁ ଇସ୍‌ହାକଠାରୁ ତୁମ୍ଭର ବଂଶ ବିଖ୍ୟାତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ଆଉ ଏହି ଦାସୀର ପୁତ୍ର ତୁମ୍ଭର ବଂଶ, ଏଣୁ ଆମ୍ଭେ ତାହାଠାରୁ ଏକ ଗୋଷ୍ଠୀ ଉତ୍ପନ୍ନ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ପ୍ରଭାତରେ ଉଠି ରୁଟି ଓ ଜଳପୂର୍ଣ୍ଣ କୁମ୍ପା ଘେନି ହାଗାରର ସ୍କନ୍ଧରେ ଦେଇ ବାଳକଙ୍କୁ ସମର୍ପଣ କରି ତାହାଙ୍କୁ ବିଦାୟ କଲେ; ତହିଁରେ ସେ ପ୍ରସ୍ଥାନ କରି ବେର୍‍ଶେବା ନାମକ ପ୍ରାନ୍ତରରେ ପଥ ହରାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ପୁଣି, କୁମ୍ପାର ଜଳ ଶେଷ ହୁଅନ୍ତେ, ହାଗାର ଗୋଟିଏ ବୁଦାର ମୂଳରେ ବାଳକଙ୍କୁ ଛାଡ଼ିଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ପୁଣି, ସେ ତାହା ଆଗରୁ ଦୂରକୁ ତୀରେକ ପରିମାଣ ଯାଇ ବସିଲା; କାରଣ ସେ କହିଲା, “ବାଳକର ମରଣ ମୁଁ ଦେଖିବି ନାହିଁ।” ପୁଣି, ସେ ତାହା ଆଗରେ ବସି ଉଚ୍ଚସ୍ୱରରେ ରୋଦନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ସେତେବେଳେ ପରମେଶ୍ୱର ବାଳକର ରବ ଶୁଣିଲେ; ପୁଣି, ପରମେଶ୍ୱରଙ୍କ ଦୂତ ଆକାଶରୁ ଡାକି ହାଗାରଙ୍କୁ କହିଲେ, “ଆଗୋ ହାଗାର, ତୁମ୍ଭର କଅଣ ହେଲା? ଭୟ କର ନାହିଁ; କାରଣ, ଯେଉଁ ସ୍ଥାନରେ ବାଳକ ଅଛି, ସେହି ସ୍ଥାନରେ ପରମେଶ୍ୱର ତାହାର ରବ ଶୁଣିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ତୁମ୍ଭେ ଠିଆ ହୋଇ ବାଳକଙ୍କୁ ଉଠାଇ ହସ୍ତରେ ଧର; ଆମ୍ଭେ ତାହାଠାରୁ ଏକ ମହାଗୋଷ୍ଠୀ ଉତ୍ପନ୍ନ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ସେତେବେଳେ ପରମେଶ୍ୱର ତାହାର ଚକ୍ଷୁ ପ୍ରସନ୍ନ କରନ୍ତେ, ସେ ସଜଳ କୂପ ଦେଖିବାକୁ ପାଇ ସେଠାକୁ ଯାଇ କୁମ୍ପାରେ ଜଳ ପୂରାଇ ବାଳକକୁ ପାନ କରାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ବାଳକର ସହାୟ ହୁଅନ୍ତେ, ସେ ବଡ଼ ହେଲା, ପୁଣି, ପ୍ରାନ୍ତରରେ ଥାଇ ଧନୁର୍ଦ୍ଧର ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ସେ ପାରଣ ନାମକ ପ୍ରାନ୍ତରରେ ବସତି କଲା; ତହିଁ ଉତ୍ତାରେ ତାହାର ମାତା ଏକ ମିସର ଦେଶୀୟା କନ୍ୟା ସଙ୍ଗେ ତାହାର ବିବାହ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ଏହି ସମୟରେ ଅବିମେଲକ ଓ ଫୀଖୋଲ ନାମକ ତାଙ୍କର ସେନାପତି ଅବ୍ରହାମଙ୍କୁ କହିଲେ, “ପରମେଶ୍ୱର ତୁମ୍ଭର ସବୁ କାର୍ଯ୍ୟରେ ସହାୟ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ଏଥିପାଇଁ ତୁମ୍ଭେ ଆମ୍ଭ ପ୍ରତି ଓ ଆମ୍ଭର ପୁତ୍ରପୌତ୍ର ପ୍ରତି ବିଶ୍ୱାସଘାତକତା କରିବ ନାହିଁ; ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭ ପ୍ରତି ଯେପରି ଅନୁଗ୍ରହ କରିଅଛୁ, ତଦନୁସାରେ ତୁମ୍ଭେ ଆମ୍ଭ ପ୍ରତି ଓ ତୁମ୍ଭର ପ୍ରବାସ ସ୍ଥାନ ଏହି ଦେଶ ପ୍ରତି ଅନୁଗ୍ରହ କରିବ, ଆମ୍ଭ ଆଗରେ ପରମେଶ୍ୱରଙ୍କ ଶପଥ କରି ଏହି କଥା କୁହ।” ");
INSERT INTO ory_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ତହିଁରେ ଅବ୍ରହାମ କହିଲେ, “ମୁଁ ଶପଥ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ଆଉ ଅବିମେଲକଙ୍କ ଦାସଗଣ ଅବ୍ରହାମଙ୍କର ଏକ ସଜଳ କୂପ ବଳରେ ଅଧିକାର କରିଥିଲେ, ତେଣୁକରି ଅବ୍ରହାମ ଅବିମେଲକଙ୍କୁ ଅନୁଯୋଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ତହିଁରେ ଅବିମେଲକ କହିଲେ, “ଏ କର୍ମ କିଏ କଲା, ତାହା ଆମ୍ଭେ ଜାଣି ନାହୁଁ; ପୁଣି, ତୁମ୍ଭେ ହିଁ ଆମ୍ଭକୁ ଜଣାଇ ନାହଁ; ଆମ୍ଭେ କେବଳ ଆଜି ଏ କଥା ଶୁଣିଲୁ।” ");
INSERT INTO ory_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ମେଷ ଓ ଗୋରୁ ଘେନି ଅବିମେଲକଙ୍କୁ ଦେଲେ, ପୁଣି, ଦୁହେଁ ଗୋଟିଏ ନିୟମ ସ୍ଥିର କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ଆଉ ଅବ୍ରହାମ ପଲରୁ ସାତଗୋଟି ମେଷବତ୍ସା ପୃଥକ କରି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ତହିଁରେ ଅବିମେଲକ ଅବ୍ରହାମଙ୍କୁ ପଚାରିଲେ, “ତୁମ୍ଭେ କି ଅଭିପ୍ରାୟରେ ଏହି ସାତଗୋଟି ମେଷବତ୍ସା ପୃଥକ କରି ରଖିଲ?” ");
INSERT INTO ory_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ଅବ୍ରହାମ କହିଲେ, “ମୁଁ ଯେ ଏହି କୂପ ଖୋଳିଅଛି, ତହିଁର ପ୍ରମାଣ ନିମନ୍ତେ ମୋʼ ଠାରୁ ଏହି ସାତଗୋଟି ମେଷବତ୍ସା ନେବାକୁ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ଏଣୁ ସେହି ସ୍ଥାନର ନାମ ବେର୍‍ଶେବା (ଶପଥ-କୂପ) ହେଲା, ଯେହେତୁ ସେହିଠାରେ ସେ ଦୁହେଁ ଶପଥ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ଏହିରୂପେ ସେମାନେ ବେର୍‍ଶେବା ନିକଟରେ ନିୟମ ସ୍ଥିର କରନ୍ତେ, ଅବିମେଲକ ଓ ଫୀଖୋଲ ନାମକ ତାଙ୍କର ସେନାପତି ଉଠି ପଲେଷ୍ଟୀୟମାନଙ୍କ ଦେଶକୁ ଫେରିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ସେହି ବେର୍‍ଶେବା ନିକଟରେ ଏକ ଝାଉଁ ବୃକ୍ଷ ରୋପଣ କରି ସେହି ସ୍ଥାନରେ ଅନାଦି ଅନନ୍ତ ପରମେଶ୍ୱର ସଦାପ୍ରଭୁଙ୍କ ନାମରେ ପ୍ରାର୍ଥନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ପୁଣି, ଅବ୍ରହାମ ପଲେଷ୍ଟୀୟମାନଙ୍କ ଦେଶରେ ବହୁ ଦିନ ପ୍ରବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ଏହି ସମସ୍ତ ଘଟଣା ଉତ୍ତାରେ ପରମେଶ୍ୱର ଅବ୍ରହାମଙ୍କର ପରୀକ୍ଷା ନିମନ୍ତେ କହିଲେ, “ହେ ଅବ୍ରହାମ।” ତହିଁରେ ସେ ଉତ୍ତର କଲେ, “ଦେଖନ୍ତୁ, ମୁଁ ଏଠାରେ ଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ସେତେବେଳେ ସେ କହିଲେ, “ତୁମ୍ଭେ ଏବେ ଆପଣା ପୁତ୍ରକୁ, ତୁମ୍ଭର ଅଦ୍ୱିତୀୟ ପୁତ୍ରକୁ, ଅର୍ଥାତ୍‍, ତୁମ୍ଭେ ଯାହାକୁ ସ୍ନେହ କର, ସେହି ଇସ୍‌ହାକକୁ ଘେନି ମୋରୀୟା ଦେଶକୁ ଯାଅ; ପୁଣି, ଆମ୍ଭେ ସେହି ଦେଶରେ ଯେଉଁ ପର୍ବତ କହିବା, ସେହି ପର୍ବତ ଉପରେ ତାହାକୁ ହୋମାର୍ଥେ ବଳିଦାନ କର।” ");
INSERT INTO ory_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ତହିଁରେ ଅବ୍ରହାମ ପ୍ରଭାତରେ ଉଠି ଗଧ ସଜାଇ ଦୁଇ ଜଣ ଦାସ ଓ ଆପଣା ପୁତ୍ର ଇସ୍‌ହାକକୁ ସଙ୍ଗରେ ନେଲେ, ଆଉ ହୋମ ନିମନ୍ତେ କାଠ କାଟି ପରମେଶ୍ୱରଙ୍କ ନିର୍ଦ୍ଦିଷ୍ଟ ସ୍ଥାନକୁ ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ଏଥିଉତ୍ତାରେ ତୃତୀୟ ଦିନରେ ଅବ୍ରହାମ ଅନାଇ ଦୂରରୁ ସେହି ସ୍ଥାନ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ସେତେବେଳେ ଅବ୍ରହାମ ସେହି ଦାସମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଏହି ସ୍ଥାନରେ ଗଧ ସହିତ ଥାଅ, ମୁଁ ଓ ବାଳକ ଦୁହେଁ ସେ ସ୍ଥାନକୁ ଯାଇ ଆରାଧନା କରି ପଛେ ତୁମ୍ଭମାନଙ୍କ ନିକଟକୁ ଫେରି ଆସିବା।” ");
INSERT INTO ory_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ତହୁଁ ଅବ୍ରହାମ ଯଜ୍ଞକାଷ୍ଠ ଘେନି ଆପଣା ପୁତ୍ର ଇସ୍‌ହାକର ସ୍କନ୍ଧରେ ଦେଇ ନିଜ ହସ୍ତରେ ଅଗ୍ନି ଓ ଛୁରିକା ଘେନିଲେ, ପୁଣି, ଦୁହେଁ ଏକତ୍ର ଚାଲିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ଆଉ ଇସ୍‌ହାକ ଆପଣା ପିତା ଅବ୍ରହାମଙ୍କୁ ଡାକି କହିଲା, “ହେ ମୋହର ପିତଃ।” ତହିଁରେ ସେ ଉତ୍ତର କଲେ, “ପୁତ୍ର, ଦେଖ, ମୁଁ ଏଠାରେ।” ସେତେବେଳେ ସେ ପଚାରିଲା, “ଏହି ଦେଖ, ଅଗ୍ନି ଓ କାଷ୍ଠ, ମାତ୍ର ହୋମ ନିମନ୍ତେ ମେଣ୍ଢାଛୁଆ କାହିଁ?” ");
INSERT INTO ory_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ତହିଁରେ ଅବ୍ରହାମ କହିଲେ, “ପୁତ୍ର, ପରମେଶ୍ୱର ଆପେ ହୋମ ପାଇଁ ମେଣ୍ଢାଛୁଆ ଯୋଗାଇବେ।” ତହୁଁ ଦୁହେଁ ଏକତ୍ର ଚାଲିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ଆଉ ପରମେଶ୍ୱରଙ୍କ ନିରୂପିତ ସ୍ଥାନରେ ଉପସ୍ଥିତ ହୁଅନ୍ତେ, ଅବ୍ରହାମ ସେଠାରେ ଏକ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କରି ତହିଁ ଉପରେ କାଠ ସଜାଡ଼ି ଆପଣା ପୁତ୍ର ଇସ୍‌ହାକକୁ ବାନ୍ଧି ବେଦିର କାଠ ଉପରେ ଶୁଆଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ହସ୍ତ ବିସ୍ତାରି ପୁତ୍ରକୁ ବଧ କରିବା ନିମନ୍ତେ ଛୁରିକା ଧରିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ଏପରି ସମୟରେ ଆକାଶରୁ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ତାଙ୍କୁ ଡାକି କହିଲେ, “ହେ ଅବ୍ରହାମ, ହେ ଅବ୍ରହାମ!” ତହିଁରେ ସେ କହିଲେ, “ଦେଖନ୍ତୁ, ମୁଁ ଏଠାରେ।” ");
INSERT INTO ory_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ତହିଁରେ ସେ କହିଲେ, “ତୁମ୍ଭେ ସେହି ବାଳକର ପ୍ରତିକୂଳରେ ହସ୍ତ ବିସ୍ତାର କର ନାହିଁ ଓ ତାହା ପ୍ରତି କିଛି କର ନାହିଁ; କାରଣ ପରମେଶ୍ୱରଙ୍କ ପ୍ରତି ତୁମ୍ଭର ଭୟ ଅଛି, ଏହା ଏବେ ଆମ୍ଭେ ବୁଝିଲୁ; ଯେହେତୁ ତୁମ୍ଭେ ଆମ୍ଭଙ୍କୁ ଆପଣାର ପୁତ୍ର, ଆପଣାର ଏକମାତ୍ର ପୁତ୍ର ଦେବାକୁ ହିଁ ଅସମ୍ମତ ନୋହିଲ।” ");
INSERT INTO ory_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ସେତେବେଳେ ଅବ୍ରହାମ ଅନାଇ ଆପଣା ପଛଆଡ଼ ବୁଦାର ଲତାରେ ବଦ୍ଧଶୃଙ୍ଗ ଗୋଟିଏ ମେଷ ଦେଖିଲେ; ତହିଁରେ ଅବ୍ରହାମ ଯାଇ ସେହି ମେଷକୁ ଆଣି ଆପଣା ପୁତ୍ର ବଦଳେ ତାକୁ ହୋମ ନିମନ୍ତେ ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ପୁଣି, ଅବ୍ରହାମ ସେହି ସ୍ଥାନର ନାମ “ଯିହୋବାଃ-ଯିରି” ରଖିଲେ। ଏଥିପାଇଁ ଆଜି ପର୍ଯ୍ୟନ୍ତ ଲୋକେ କହନ୍ତି, “ପର୍ବତରେ ସଦାପ୍ରଭୁ ଯୋଗାଇବେ।” ");
INSERT INTO ory_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ଆଉ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ଦ୍ୱିତୀୟ ଥର ଆକାଶରୁ ଅବ୍ରହାମଙ୍କୁ ଡାକି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ସଦାପ୍ରଭୁ କହୁଅଛନ୍ତି, ତୁମ୍ଭେ ଆମ୍ଭଙ୍କୁ ଆପଣାର ପୁତ୍ର, ଆପଣାର ଏକମାତ୍ର ପୁତ୍ର ଦେବାକୁ ଅସମ୍ମତ ନୋହିଲ; ");
INSERT INTO ory_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ତୁମ୍ଭର ଏହି କର୍ମ ସକାଶୁ ଆମ୍ଭେ ଆପଣା ନାମରେ ଶପଥ କରି କହୁଅଛୁ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଅବଶ୍ୟ ଆଶୀର୍ବାଦ କରି ଆକାଶସ୍ଥ ତାରାଗଣ ଓ ସମୁଦ୍ରର ବାଲି ପରି ତୁମ୍ଭର ବଂଶ ଅତିଶୟ ବୃଦ୍ଧି କରିବା; ତୁମ୍ଭର ବଂଶ ଶତ୍ରୁଗଣର ନଗର-ଦ୍ୱାର ଅଧିକାର କରିବେ। ");
INSERT INTO ory_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ପୁଣି, ପୃଥିବୀସ୍ଥ ସମସ୍ତ ଜାତି ତୁମ୍ଭର ବଂଶ ଦ୍ୱାରା ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ହେବେ; ଯେହେତୁ ତୁମ୍ଭେ ଆମ୍ଭର ବାକ୍ୟ ପାଳନ କରିଅଛ।” ");
INSERT INTO ory_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ସେହି ଦାସମାନଙ୍କ ନିକଟକୁ ଫେରିଗଲେ; ଆଉ ସେମାନେ ଉଠି ଏକତ୍ର ବେର୍‍ଶେବାକୁ ଗଲେ ଓ ଅବ୍ରହାମ ବେର୍‍ଶେବାରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ସେହି ଘଟଣା ଉତ୍ତାରେ ଅବ୍ରହାମଙ୍କୁ ଏହି ସମ୍ବାଦ ଦିଆଗଲା, “ଶୁଣ, ମିଲ୍କା ମଧ୍ୟ ତୁମ୍ଭ ଭ୍ରାତା ନାହୋର ନିମନ୍ତେ ସନ୍ତାନସନ୍ତତି ପ୍ରସବ କରିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ତାହାର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଊଷ୍‍ ଓ ତାହାର ଭ୍ରାତା ବୂଷ୍‍ ଓ ଅରାମର ପିତା କମୂୟେଲ, ");
INSERT INTO ory_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ପୁଣି, କେଷଦ୍‍ ଓ ହସୋ ଓ ପିଲଦଶ୍‍ ଓ ଯିଦ୍‍ଲଫ୍‍ ଓ ବଥୂୟେଲ। ");
INSERT INTO ory_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ସେହି ବଥୂୟେଲର କନ୍ୟା ରିବିକା। ମିଲ୍କା ଏହି ଆଠ ଜଣଙ୍କୁ ଅବ୍ରହାମଙ୍କର ଭ୍ରାତା ନାହୋର ନିମନ୍ତେ ଜନ୍ମ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ପୁଣି, ନାହୋରର ରୂମା ନାମ୍ନୀ ଉପପତ୍ନୀଠାରୁ ଟେବହ, ଗହମ୍‍, ତହଶ୍‍ ଓ ମାଖା, ଏମାନେ ଜାତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ସାରାର ଆୟୁର ପରିମାଣ ଶହେ ସତାଇଶ ବର୍ଷ ଥିଲା; ସାରାର ଆୟୁ ଏତେ ବର୍ଷ ପରିମିତ। ");
INSERT INTO ory_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ଏଥିଉତ୍ତାରେ ସାରା କିଣାନ ଦେଶସ୍ଥ କିରୀୟଥ୍‍-ଅର୍ବରେ, ଅର୍ଥାତ୍‍, ହିବ୍ରୋଣରେ ମଲା। ଏଣୁ ଅବ୍ରହାମ ସାରା ନିମନ୍ତେ ଶୋକ ଓ କ୍ରନ୍ଦନ କରିବାକୁ ଭିତରକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ଆପଣା ମୃତା (ଭାର୍ଯ୍ୟା) ନିକଟରୁ ଉଠିଯାଇ ହେତ୍‌ର ସନ୍ତାନମାନଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ମୁଁ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ବିଦେଶୀ ଓ ପ୍ରବାସୀ ଅଟେ; ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ମୋତେ କବର ସ୍ଥାନର ଅଧିକାର ଦିଅ, ତହିଁରେ ମୁଁ ମୋʼ ଦୃଷ୍ଟିର ଅଗୋଚରରେ ମୋʼ ମୃତକୁ କବର ଦେବି।” ");
INSERT INTO ory_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ତହୁଁ ହେତ୍‌ର ସନ୍ତାନମାନେ ଅବ୍ରହାମଙ୍କୁ ଉତ୍ତର ଦେଲେ, “ହେ ପ୍ରଭୁ, ଆମ୍ଭମାନଙ୍କ କଥା ଶୁଣନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","ଆପଣ ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପରାକ୍ରାନ୍ତ ରାଜା ଅଟନ୍ତି; ଏବେ ଆମ୍ଭମାନଙ୍କ ଉତ୍ତମ କବର ସ୍ଥାନ ମଧ୍ୟରେ ଆପଣା ମୃତା ଭାର୍ଯ୍ୟାକୁ କବର ଦେଉନ୍ତୁ; ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟରୁ କେହି ନିଜ କବରରେ ଆପଣଙ୍କ ମୃତା ଭାର୍ଯ୍ୟାକୁ ରଖିବା ପାଇଁ ନିଷେଧ କରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ସେତେବେଳେ ଅବ୍ରହାମ ଉଠି ତଦ୍ଦେଶୀୟ ଲୋକମାନଙ୍କୁ, ଅର୍ଥାତ୍‍, ହେତ୍‌ର ସନ୍ତାନମାନଙ୍କୁ ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ପୁଣି, କଥୋପକଥନ କରି କହିଲେ, “ମୋʼ ଦୃଷ୍ଟିର ବାହାରେ ମୋʼ ମୃତା ଭାର୍ଯ୍ୟାକୁ କବରରେ ରଖିବାକୁ ଯଦି ଆପଣମାନଙ୍କର ସମ୍ମତି ହୁଏ, ତେବେ ମୋʼ କଥା ଶୁଣନ୍ତୁ; ଆପଣମାନେ ମୋʼ ନିମନ୍ତେ ସୋହରର ପୁତ୍ର ଇଫ୍ରୋଣ ନିକଟରେ ନିବେଦନ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ସେ ଆପଣମାନଙ୍କ ମଧ୍ୟରେ ମୋହର କବର ସ୍ଥାନ ଅଧିକାର ନିମନ୍ତେ ମକ୍‍ପେଲାରେ ତାଙ୍କ କ୍ଷେତ୍ର ପ୍ରାନ୍ତରେ ଥିବା ଗୁହା ମୋତେ ଦିଅନ୍ତୁ; ତହିଁରେ ଯେତେ ମୂଲ୍ୟ ହୁଏ, ତାହା ନେଇ ଦିଅନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ସେତେବେଳେ ଇଫ୍ରୋଣ ହେତ୍‌ର ସନ୍ତାନମାନଙ୍କ ମଧ୍ୟରେ ବସିଥିଲା; ତେଣୁ, ହିତ୍ତୀୟ ଇଫ୍ରୋଣ ଆପଣା ନଗର-ଦ୍ୱାରରେ ପ୍ରବେଶକାରୀ ହେତ୍‌ର ସନ୍ତାନ ସମସ୍ତଙ୍କ ସାକ୍ଷାତରେ ଅବ୍ରହାମଙ୍କୁ ଉତ୍ତର ଦେଲା, ");
INSERT INTO ory_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ପ୍ରଭୋ, ସେପରି ନ ହେଉ, ମୋʼ କଥା ଶୁଣନ୍ତୁ; ମୁଁ ଆପଣଙ୍କୁ ସେହି ସ୍ଥାନ ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ଗୁହା ଦେଲି; ମୁଁ ସ୍ୱବଂଶୀୟ ସନ୍ତାନମାନଙ୍କ ସାକ୍ଷାତରେ ତାହା ଆପଣଙ୍କୁ ଦେଲି, ଆପଣ ନିଜ ଭାର୍ଯ୍ୟାର ମୃତ ଦେହକୁ କବର ଦେଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ତହିଁରେ ଅବ୍ରହାମ ସେହି ଦେଶୀୟ ଲୋକମାନଙ୍କ ଅଗ୍ରତେ ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ପୁଣି, ସେହି ଦେଶୀୟ ଲୋକମାନଙ୍କ କର୍ଣ୍ଣଗୋଚରରେ ଇଫ୍ରୋଣକୁ କହିଲେ, “ଆପଣ ଯଦି ମୋତେ ତାହା ଦେବେ, ତେବେ ନିବେଦନ କରୁଅଛି, ମୋʼ କଥା ଶୁଣନ୍ତୁ; ମୁଁ ସେହି କ୍ଷେତ୍ରର ମୂଲ୍ୟ ଦେଉଅଛି, ଆପଣ ତାହା ଗ୍ରହଣ କରନ୍ତୁ; ତହିଁ ଉତ୍ତାରେ ମୁଁ ସେହି ସ୍ଥାନରେ ମୋର ଭାର୍ଯ୍ୟାର ମୃତ ଦେହକୁ କବର ଦେବି।” ");
INSERT INTO ory_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ତହିଁରେ ଇଫ୍ରୋଣ ଅବ୍ରହାମଙ୍କୁ ଉତ୍ତର ଦେଇ କହିଲା, ");
INSERT INTO ory_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ପ୍ରଭୋ, ମୋʼ କଥା ଶୁଣନ୍ତୁ; ଭୂମି ଖଣ୍ଡକର ମୂଲ୍ୟ ତ ଚାରି ଶହ ଶେକଲ ରୂପା, ଆପଣଙ୍କ ଓ ଆମ୍ଭ ମଧ୍ୟରେ ତାହା କେତେ ମାତ୍ର? ଏଥିପାଇଁ ଆପଣ ନିଜ ଭାର୍ଯ୍ୟାର ମୃତ ଦେହକୁ କବର ଦେଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ଇଫ୍ରୋଣର ଏହି କଥା ଶୁଣି ଅବ୍ରହାମ ହିତ୍ତୀୟ ସନ୍ତାନମାନଙ୍କ କର୍ଣ୍ଣଗୋଚରରେ ଇଫ୍ରୋଣ ଦ୍ୱାରା ଉକ୍ତ ସଂଖ୍ୟାନୁସାରେ ତତ୍କାଳୀନ ବଣିକମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରଚଳିତ ଚାରି ଶହ ଶେକଲ ରୂପା ତୌଲି ଇଫ୍ରୋଣକୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ଏହେତୁ ମମ୍ରିର ପୂର୍ବବର୍ତ୍ତୀ ମକ୍‍ପେଲାରେ ଇଫ୍ରୋଣର ଯେଉଁ କ୍ଷେତ୍ର ଥିଲା, ସେହି କ୍ଷେତ୍ର ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ଗୁହା ଓ ତହିଁର ଚତୁଃସୀମାନ୍ତର୍ଗତ ବୃକ୍ଷସମୂହ, ");
INSERT INTO ory_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ଏହିସବୁରେ ହେତ୍‌ର ସନ୍ତାନମାନଙ୍କ ସାକ୍ଷାତରେ, ଅର୍ଥାତ୍‍, ତାହାର ନଗର-ଦ୍ୱାରରେ ପ୍ରବେଶକାରୀ ସମସ୍ତଙ୍କ ସାକ୍ଷାତରେ ଅବ୍ରହାମଙ୍କର ସ୍ୱତ୍ୱାଧିକାର ସ୍ଥିର କରାଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ମମ୍ରିର ପୂର୍ବବର୍ତ୍ତୀ ମକ୍‍ପେଲା କ୍ଷେତ୍ରସ୍ଥିତ ଗୁହାରେ ଆପଣା ଭାର୍ଯ୍ୟା ସାରାକୁ କବର ଦେଲେ। ସେହି ସ୍ଥାନ କିଣାନ ଦେଶସ୍ଥ ହିବ୍ରୋଣ। ");
INSERT INTO ory_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ଏହିରୂପେ କବର ସ୍ଥାନର ଅଧିକାର ନିମନ୍ତେ ସେହି କ୍ଷେତ୍ର ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ଗୁହାରେ ଅବ୍ରହାମଙ୍କର ଅଧିକାର ହେତ୍‌ର ସନ୍ତାନମାନଙ୍କ ଦ୍ୱାରା ସ୍ଥିରୀକୃତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ସେହି ସମୟରେ ଅବ୍ରହାମ ବୃଦ୍ଧ ଓ ଗତବୟସ୍କ ଥିଲେ, ପୁଣି, ସଦାପ୍ରଭୁ ଅବ୍ରହାମଙ୍କୁ ସବୁ ବିଷୟରେ ଆଶୀର୍ବାଦ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ଏଣୁ ସେ ଆପଣା ଗୃହର ସର୍ବକାର୍ଯ୍ୟାଧ୍ୟକ୍ଷ ବୃଦ୍ଧ ଦାସକୁ କହିଲେ, “ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ମୋʼ ଜଙ୍ଘରେ ହସ୍ତ ଦିଅ; ");
INSERT INTO ory_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ମୁଁ ସ୍ୱର୍ଗ ମର୍ତ୍ତ୍ୟର ସୃଷ୍ଟିକର୍ତ୍ତା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ନାମରେ ତୁମ୍ଭକୁ ଶପଥ କରାଇବି ଯେ, ଯେଉଁ କିଣାନୀୟ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ମୁଁ ବାସ କରୁଅଛି, ତୁମ୍ଭେ ସେମାନଙ୍କ ମଧ୍ୟରୁ ମୋʼ ପୁତ୍ରର ବିବାହାର୍ଥେ କୌଣସି କନ୍ୟା ଗ୍ରହଣ କରିବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ମାତ୍ର, ତୁମ୍ଭେ ଆମ୍ଭ ଦେଶୀୟ ଜ୍ଞାତିମାନଙ୍କ ନିକଟକୁ ଯାଇ ମୋʼ ପୁତ୍ର ଇସ୍‌ହାକ ନିମନ୍ତେ କନ୍ୟା ଆଣିବ।” ");
INSERT INTO ory_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ସେତେବେଳେ ସେହି ଦାସ ତାଙ୍କୁ କହିଲା, “ଯଦି କୌଣସି କନ୍ୟା ମୋʼ ସହିତ ଏ ଦେଶକୁ ଆସିବା ପାଇଁ ସମ୍ମତ ନୋହିବ, ତେବେ ଯେଉଁ ଦେଶରୁ ତୁମ୍ଭେ ଆସିଅଛ, ସେହି ଦେଶକୁ କି ତୁମ୍ଭ ପୁତ୍ରଙ୍କୁ ନେଇଯିବି?” ");
INSERT INTO ory_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ତହିଁରେ ଅବ୍ରହାମ କହିଲେ, “ସାବଧାନ; ମୋʼ ପୁତ୍ରକୁ କେବେ ସେଠାକୁ ନେଇଯିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“ଯେହେତୁ ଯେଉଁ ସ୍ୱର୍ଗର ସୃଷ୍ଟିକର୍ତ୍ତା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ମୋତେ ପୈତୃକ ଗୃହ ଓ ଜନ୍ମ ଦେଶ ମଧ୍ୟରୁ ଆଣିଅଛନ୍ତି ଓ ମୋʼ ସଙ୍ଗେ ଆଳାପ କରିଅଛନ୍ତି, ‘ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭ ବଂଶକୁ ଏହି ଦେଶ ଦେବା ବୋଲି ଶପଥ କରିଅଛନ୍ତି,’ ସେ ତୁମ୍ଭ ଅଗ୍ରତେ ଆପଣା ଦୂତ ପଠାଇବେ; ତହିଁରେ ତୁମ୍ଭେ ମୋʼ ପୁତ୍ରର ବିବାହ ନିମନ୍ତେ ସେହିଠାରୁ ଗୋଟିଏ କନ୍ୟା ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ଯଦି ସେହି ଦେଶରୁ କୌଣସି କନ୍ୟା ଆସିବାକୁ ସମ୍ମତ ହେବେ ନାହିଁ, ତେବେ ତୁମ୍ଭେ ମୋହର ଏହି ଶପଥରୁ ମୁକ୍ତ ହେବ; ମାତ୍ର ତୁମ୍ଭେ ମୋʼ ପୁତ୍ରକୁ ସେହି ଦେଶକୁ ନେଇଯିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ତହିଁରେ ସେହି ଦାସ ଆପଣା ପ୍ରଭୁ ଅବ୍ରହାମଙ୍କର ଜଙ୍ଘରେ ହସ୍ତ ଦେଇ ସେହି ବିଷୟରେ ଶପଥ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ଏଥିଉତ୍ତାରେ ସେହି ଦାସ ଆପଣା ପ୍ରଭୁର ଓଟମାନଙ୍କ ମଧ୍ୟରୁ ଦଶଟା ଓଟ ଓ ଆପଣା ପ୍ରଭୁର ସର୍ବପ୍ରକାର ଉତ୍ତମ ଦ୍ରବ୍ୟ ହସ୍ତରେ ଘେନି ପ୍ରସ୍ଥାନ କରି ଅରାମନହରୟିମ୍‍ ଦେଶର ନାହୋର ନଗରକୁ ଯାତ୍ରା କଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ଏଥିଉତ୍ତାରେ ସନ୍ଧ୍ୟା ବେଳେ, ଯେଉଁ ସମୟରେ କନ୍ୟାଗଣ ଜଳ କାଢ଼ିବାକୁ ଆସନ୍ତି, ସେହି ସମୟରେ ସେ ନଗରର ବାହାରେ କୂପ ନିକଟରେ ଓଟମାନଙ୍କୁ ଆଣ୍ଠୋଇ ବସାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ପୁଣି, ଏହି ପ୍ରାର୍ଥନା କଲା, “ହେ ମୋହର କର୍ତ୍ତା ଅବ୍ରହାମଙ୍କର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର, ବିନୟ କରୁଅଛି, ଆଜି ମୋʼ ସମ୍ମୁଖରେ ଶୁଭଫଳ ଉପସ୍ଥିତ କର, ଆଉ ମୋʼ ପ୍ରଭୁ ଅବ୍ରହାମଙ୍କ ପ୍ରତି ଦୟା କର। ");
INSERT INTO ory_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ଦେଖ, ମୁଁ ଏହି କୂପ ନିକଟରେ ଛିଡ଼ା ହେଉଅଛି, ଆଉ ଏ ନଗରବାସୀମାନଙ୍କ କନ୍ୟାଗଣ ଜଳ ନେବା ପାଇଁ ଆସୁଅଛନ୍ତି; ");
INSERT INTO ory_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ସେମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି କନ୍ୟାକୁ, ‘ତୁମ୍ଭେ ଆପଣା କଳସ ନୁଆଁଇ ମୋତେ ଜଳ ପାନ କରାଅ,’ ଏହି କଥା କହିଲେ ସେହି କନ୍ୟା ଯଦି କହିବ, ‘ପାନ କର, ମୁଁ ତୁମ୍ଭର ଓଟମାନଙ୍କୁ ହିଁ ପାନ କରାଇବି,’ ତେବେ ସେ ତୁମ୍ଭ ଦାସ ଇସ୍‌ହାକ ନିମନ୍ତେ ତୁମ୍ଭର ନିରୂପିତା କନ୍ୟା ହେଉ; ତହିଁରେ ତୁମ୍ଭେ ମୋʼ ପ୍ରଭୁଙ୍କ ପ୍ରତି ଅନୁଗ୍ରହ କରିଅଛ, ଏହା ମୁଁ ଜାଣିବି।” ");
INSERT INTO ory_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ଏହି କଥା କହୁ କହୁ ଅବ୍ରହାମଙ୍କର ନାହୋର ନାମକ ଭ୍ରାତାର ଭାର୍ଯ୍ୟା ମିଲ୍କାର ପୁତ୍ର ଯେ ବଥୂୟେଲ, ତାହାର କନ୍ୟା ରିବିକା ସ୍କନ୍ଧରେ କଳସ ଘେନି ବାହାରି ଆସିଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ସେହି କନ୍ୟା ପରମସୁନ୍ଦରୀ ଓ ଅବିବାହିତା, ଆଉ କୌଣସି ପୁରୁଷର ଉପଭୁକ୍ତା ନ ଥିଲା। ସେ କୂପ ଭିତରକୁ ଯାଇ କଳସ ପୂର୍ଣ୍ଣ କରି ଉଠି ଆସୁଅଛି, ");
INSERT INTO ory_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ଏପରି ସମୟରେ ସେହି ଦାସ ଦୌଡ଼ିଯାଇ ତାହା ସଙ୍ଗେ ଦେଖା କରି କହିଲା, “ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭ କଳସରୁ ମୋତେ କିଛି ଜଳ ପାନ କରିବାକୁ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ତହିଁରେ ସେ କହିଲା, “ମହାଶୟ, ପାନ କରନ୍ତୁ,” ଏହା କହି ସେ ଶୀଘ୍ର କଳସ ହାତକୁ ଓହ୍ଲାଇ ତାହାକୁ ପାନ କରିବାକୁ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ପୁଣି, ତାହାକୁ ପାନ କରାଇଲା ଉତ୍ତାରେ କହିଲା, “ମଧ୍ୟ ତୁମ୍ଭର ଓଟ ସବୁ ପାଣି ପିଇ ସାରିବା ଯାଏ ମୁଁ ପାଣି କାଢ଼ିବି।” ");
INSERT INTO ory_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ତହିଁରେ ସେ ଶୀଘ୍ର କୁଣ୍ଡରେ କଳସରୁ ପାଣି ଢାଳି ପୁନଶ୍ଚ ପାଣି କାଢ଼ିବା ପାଇଁ କୂପ ନିକଟକୁ ଧାଇଁଯାଇ ସମସ୍ତ ଓଟ ନିମନ୍ତେ ଜଳ କାଢ଼ିଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ତହିଁରେ ସେହି ପୁରୁଷ ତାହା ପ୍ରତି ସ୍ଥିର ଦୃଷ୍ଟି କରି ଅନାଇ ରହିଲା; ପୁଣି, ସଦାପ୍ରଭୁ ତାହାର ଯାତ୍ରା ସଫଳ କରିବେ କି ନାହିଁ, ତାହା ଜାଣିବା ନିମନ୍ତେ ନିରବ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ପୁଣି, ଓଟମାନେ ଜଳ ପାନ କଲା ଉତ୍ତାରେ ସେହି ପୁରୁଷ ତାହା ନିମନ୍ତେ ଅଧଭରି ପରିମିତ ସୁବର୍ଣ୍ଣ ନଥ ଓ ତାହାର ହସ୍ତ ନିମନ୍ତେ ଦଶଭରି ପରିମିତ ଦୁଇ ସୁବର୍ଣ୍ଣ ବଳା ନେଇ କହିଲା, ");
INSERT INTO ory_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“ନିବେଦନ କରୁଅଛି, ତୁମ୍ଭେ କାହାର କନ୍ୟା, ମୋତେ କୁହ। ତୁମ୍ଭ ପିତାଙ୍କ ଗୃହରେ ଆମ୍ଭମାନଙ୍କର ରାତ୍ରି କ୍ଷେପଣ କରିବାକୁ କି ସ୍ଥାନ ଅଛି?” ");
INSERT INTO ory_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ତହିଁରେ ସେ ଉତ୍ତର କଲା, “ନାହୋରର ଔରସରେ ମିଲ୍କାଠାରୁ ଜାତ ପୁତ୍ର ଯେ ବଥୂୟେଲ, ମୁଁ ତାଙ୍କର କନ୍ୟା।” ");
INSERT INTO ory_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ସେ ଆହୁରି କହିଲା, “ଆମ୍ଭମାନଙ୍କର ପାଳକୁଟା ଓ ଦାନା ଯଥେଷ୍ଟ ଅଛି, ମଧ୍ୟରାତ୍ର କ୍ଷେପଣ କରିବାକୁ ସ୍ଥାନ ଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ସେତେବେଳେ ସେହି ମନୁଷ୍ୟ ମସ୍ତକ ନୁଆଁଇ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପ୍ରଣାମ କରି କହିଲା, ");
INSERT INTO ory_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“ମୋହର କର୍ତ୍ତା ଅବ୍ରହାମଙ୍କର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଧନ୍ୟ ହେଉନ୍ତୁ, ଯେହେତୁ ସେ ମୋʼ କର୍ତ୍ତା ପ୍ରତି ଅନୁଗ୍ରହ ଓ ସତ୍ୟାଚରଣ କରିବାରୁ ନିବୃତ୍ତ ହୋଇ ନାହାନ୍ତି; ପୁଣି, ସଦାପ୍ରଭୁ ମୋତେ ମୋʼ କର୍ତ୍ତାର ଜ୍ଞାତିମାନଙ୍କ ଗୃହ ପଥରେ କଢ଼ାଇ ଆଣିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ଆଉ ସେହି କନ୍ୟା ଦୌଡ଼ିଯାଇ ଆପଣା ମାତାର ଗୃହସ୍ଥିତ ଲୋକମାନଙ୍କୁ ଏହି କଥା ଜଣାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ଆଉ ରିବିକାର ଏକ ଭ୍ରାତା ଥିଲା, ତାହାର ନାମ ଲାବନ; ସେହି ଲାବନ ସେହି ମନୁଷ୍ୟ ଉଦ୍ଦେଶ୍ୟରେ କୂପ ନିକଟକୁ ଦୌଡ଼ିଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ପୁଣି, ସେହି ମନୁଷ୍ୟ ମୋତେ ଏହି ଏହି କଥା କହିଲା, ଆପଣା ଭଗିନୀ ରିବିକା ମୁଖରୁ ଏହା ଶୁଣି ଆଉ ଭଗିନୀର ନଥ ଓ ହସ୍ତରେ ବଳା ଦେଖି ସେହି ପୁରୁଷ ନିକଟକୁ ଗଲା, ପୁଣି, ତାହାକୁ କୂପ ପାଖରେ ଓଟମାନଙ୍କ ସହିତ ଛିଡ଼ା ହୋଇଥିବାର ଦେଖି କହିଲା, ");
INSERT INTO ory_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“ହେ ସଦାପ୍ରଭୁଙ୍କ ଆଶୀର୍ବାଦ-ପାତ୍ର, ଭିତରକୁ ଆସ, ତୁମ୍ଭେ କାହିଁକି ବାହାରେ ଛିଡ଼ା ହେଉଅଛ? ମୁଁ ତ ଘର ଓ ଓଟମାନଙ୍କ ପାଇଁ ସ୍ଥାନ ପ୍ରସ୍ତୁତ କରିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ତହିଁରେ ସେହି ମନୁଷ୍ୟ ଗୃହରେ ପ୍ରବେଶ କରି ଓଟମାନଙ୍କର ସାଜ ଫିଟାନ୍ତେ, ସେ ସେମାନଙ୍କୁ ପାଳକୁଟା ଓ ଦାନା ଦେଲା, ପୁଣି, ତାହାର ଓ ତାହାର ସଙ୍ଗୀମାନଙ୍କର ପାଦ ପ୍ରକ୍ଷାଳନ ନିମନ୍ତେ ପାଣି ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ଏଥିଉତ୍ତାରେ ତାହା ସମ୍ମୁଖରେ ଭୋଜନ ସାମଗ୍ରୀ ରଖାଗଲା; ମାତ୍ର ସେ କହିଲା, “ବକ୍ତବ୍ୟ କଥା ନ କହି ମୁଁ ଭୋଜନ କରିବି ନାହିଁ।” ତହିଁରେ ଲାବନ କହିଲା, “କୁହ।” ");
INSERT INTO ory_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ତେବେ ସେ କହିଲା, “ମୁଁ ଅବ୍ରହାମଙ୍କର ଦାସ। ");
INSERT INTO ory_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ସଦାପ୍ରଭୁ ମୋʼ କର୍ତ୍ତାଙ୍କୁ ଅତିଶୟ ଆଶୀର୍ବାଦ କରିଅଛନ୍ତି, ତେଣୁ ସେ ଅତି ଧନବାନ ହୋଇଅଛନ୍ତି; ଆଉ ସଦାପ୍ରଭୁ ତାଙ୍କୁ ପଲ ପଲ ଗୋମେଷାଦି ଓ ରୂପା ସୁନା ଓ ଦାସଦାସୀ, ପୁଣି, ଓଟ ଗଧ ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ପୁଣି, ମୋʼ ପ୍ରଭୁଙ୍କ ଭାର୍ଯ୍ୟା ସାରା ବୃଦ୍ଧାବସ୍ଥାରେ ତାଙ୍କ ପାଇଁ ଏକ ପୁତ୍ର ପ୍ରସବ କରିଅଛନ୍ତି ଓ ସେ ତାଙ୍କୁ ଆପଣା ସର୍ବସ୍ୱ ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ପୁଣି, ମୋହର ପ୍ରଭୁ ମୋତେ ଶପଥ କରାଇ କହିଲେ, ‘ଆମ୍ଭେ ଯେଉଁମାନଙ୍କ ମଧ୍ୟରେ ବାସ କରୁଅଛୁ, ତୁମ୍ଭେ ଆମ୍ଭ ପୁତ୍ରର ବିବାହ ନିମନ୍ତେ ସେହି କିଣାନ ଦେଶୀୟ ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି କନ୍ୟା ଗ୍ରହଣ କରିବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ମାତ୍ର ଆମ୍ଭ ପୈତୃକ ବଂଶୀୟ ଲୋକମାନଙ୍କ ନିକଟକୁ ଯାଇ ଆମ୍ଭ ପୁତ୍ର ନିମନ୍ତେ କନ୍ୟା ଆଣିବ।’ ");
INSERT INTO ory_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ସେତେବେଳେ ମୁଁ ପ୍ରଭୁଙ୍କୁ କହିଲି, ‘କେଜାଣି କୌଣସି କନ୍ୟା ମୋʼ ସଙ୍ଗରେ ନ ଆସିବ।’ ");
INSERT INTO ory_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ତହିଁରେ ସେ କହିଲେ, ‘ଆମ୍ଭେ ଯେଉଁ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଗମନାଗମନ କରୁ, ସେ ତୁମ୍ଭ ସଙ୍ଗରେ ଆପଣା ଦୂତ ପଠାଇ ତୁମ୍ଭ ଯାତ୍ରା ସଫଳ କରିବେ; ତହିଁରେ ତୁମ୍ଭେ ଆମ୍ଭ ପୈତୃକ ବଂଶରୁ ଆମ୍ଭ ପୁତ୍ର ନିମନ୍ତେ କନ୍ୟା ଆଣିବ; ");
INSERT INTO ory_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ଆଉ ତୁମ୍ଭେ ଆମ୍ଭ ବଂଶୀୟ ଲୋକମାନଙ୍କ ନିକଟକୁ ଗଲେ ଏହି ଶପଥରୁ ମୁକ୍ତ ହେବ; ଯଦ୍ୟପି ସେମାନେ କନ୍ୟା ନ ଦେବେ, ତଥାପି ଶପଥରୁ ମୁକ୍ତ ହେବ।’ ");
INSERT INTO ory_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ଏହେତୁ ଆଜି ମୁଁ ଏହି କୂପ ନିକଟରେ ଉପସ୍ଥିତ ହୋଇ ଏହି ପ୍ରାର୍ଥନା କଲି, ‘ହେ ମୋହର କର୍ତ୍ତା ଅବ୍ରହାମଙ୍କର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର, ତୁମ୍ଭେ ଯଦି ମୋହର କୃତ ଯାତ୍ରା ସଫଳ କର, ");
INSERT INTO ory_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ତେବେ ଦେଖ, ମୁଁ ଏବେ ଏହି ସଜଳ କୂପ ନିକଟରେ ଛିଡ଼ା ହୋଇଅଛି। ତହିଁରେ ଜଳ କାଢ଼ିବାକୁ ଆଗତା କୌଣସି କନ୍ୟାକୁ ଯଦି ମୁଁ କହେ, ତୁମ୍ଭ କଳସରୁ ମୋତେ କିଛି ଜଳ ପାନ କରିବାକୁ ଦିଅ; ");
INSERT INTO ory_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ପୁଣି, ସେ କନ୍ୟା ଯଦି କହେ, ତୁମ୍ଭେ ପାନ କର ଓ ତୁମ୍ଭ ଓଟମାନଙ୍କ ନିମନ୍ତେ ହେଁ ପାଣି କାଢ଼ି ଦେବି; ତେବେ ସେ ମୋʼ କର୍ତ୍ତାଙ୍କ ପୁତ୍ର ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଦ୍ୱାରା ନିରୂପିତା କନ୍ୟା ହେଉ।’ ");
INSERT INTO ory_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ଏହି କଥା ମୁଁ ମନେ ମନେ କହୁଥିଲି, ଏଥିମଧ୍ୟରେ ରିବିକା ସ୍କନ୍ଧରେ କଳସ ଘେନି ବାହାରକୁ ଆସିଲା। ପୁଣି, ସେ କୂପ ଭିତରକୁ ଯାଇ ଜଳ କାଢ଼ନ୍ତେ ମୁଁ କହିଲି, ‘ବିନୟ କରୁଅଛି, ମୋତେ ଜଳ ପାନ କରାଅ।’ ");
INSERT INTO ory_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ତହିଁରେ ସେ ଶୀଘ୍ର ସ୍କନ୍ଧରୁ କଳସ ନୁଆଁଇ କହିଲା, ‘ପାନ କର, ପୁଣି, ମୁଁ ତୁମ୍ଭ ଓଟମାନଙ୍କୁ ହିଁ ପାନ କରାଇବି;’ ତହୁଁ ମୁଁ ପାନ କଲି, ପୁଣି, ସେ ଓଟମାନଙ୍କୁ ପାନ କରାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ଏଥିଉତ୍ତାରେ ମୁଁ ତାହାକୁ ପଚାରିଲି, ‘ତୁମ୍ଭେ କାହାର କନ୍ୟା?’ ତହିଁରେ ସେ କହିଲା, ‘ନାହୋରର ଔରସରେ ମିଲ୍କାର ପୁତ୍ର ଯେ ବଥୂୟେଲ, ମୁଁ ତାଙ୍କର କନ୍ୟା।’ ତହୁଁ ମୁଁ ତାହାର ନାସିକାରେ ନଥ ଓ ହସ୍ତରେ ବଳା ପିନ୍ଧାଇଲି। ");
INSERT INTO ory_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ଆଉ ମୁଁ ମସ୍ତକ ନୁଆଁଇ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପ୍ରଣାମ କଲି, ପୁଣି, ଯେ ମୋʼ କର୍ତ୍ତାଙ୍କ ପୁତ୍ର ନିମନ୍ତେ ତାଙ୍କ ଭ୍ରାତୃକନ୍ୟା ଗ୍ରହଣ କରିବାକୁ ମୋତେ ପ୍ରକୃତ ପଥରେ କଢ଼ାଇ ଆଣିଲେ, ମୋʼ କର୍ତ୍ତା ଅବ୍ରହାମଙ୍କର ସେହି ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କର ଧନ୍ୟବାଦ କଲି। ");
INSERT INTO ory_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ଏହେତୁ ତୁମ୍ଭେମାନେ ଯଦି ମୋʼ ପ୍ରଭୁଙ୍କ ସହିତ ଦୟା ଓ ସତ୍ୟ ବ୍ୟବହାର କରିବାକୁ ସମ୍ମତ ହୁଅ, ତେବେ ତାହା କୁହ; ଆଉ ଯଦି ନ ହୁଅ, ତାହା ମଧ୍ୟ କୁହ; ତହିଁରେ ମୁଁ ଡାହାଣ ଅଥବା ବାମରେ ଫେରିଯିବି। ");
INSERT INTO ory_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ସେତେବେଳେ ଲାବନ ଓ ବଥୂୟେଲ ଉତ୍ତର କଲେ, ସଦାପ୍ରଭୁଙ୍କଠାରୁ ଏହି ଘଟଣା ହୋଇଅଛି, ଏଥିରେ ଆମ୍ଭେମାନେ ଭଲ ଓ ମନ୍ଦ କିଛି କହି ନ ପାରୁ। ");
INSERT INTO ory_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ଦେଖ, ରିବିକା ତୁମ୍ଭ ସମ୍ମୁଖରେ ଅଛି, ତାହାକୁ ଘେନି ପ୍ରସ୍ଥାନ କର, ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ସେ ତୁମ୍ଭ କର୍ତ୍ତାଙ୍କ ପୁତ୍ରର ଭାର୍ଯ୍ୟା ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ସେତେବେଳେ ଅବ୍ରହାମଙ୍କର ଦାସ ସେମାନଙ୍କଠାରୁ ଏହି କଥା ଶୁଣିବାମାତ୍ରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଭୂମିଷ୍ଠ ପ୍ରଣାମ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ଏଥିଉତ୍ତାରେ ସେହି ଦାସ ରୂପା ଓ ସୁନାର ଆଭରଣ ଓ ବସ୍ତ୍ର ବାହାର କରି ରିବିକାକୁ ଦେଲା; ପୁଣି, ତାହାର ଭ୍ରାତା ଓ ମାତାକୁ ମଧ୍ୟ ବହୁମୂଲ୍ୟ ଦ୍ରବ୍ୟ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ତହିଁରେ ସେ ଓ ତାହାର ସଙ୍ଗୀଗଣ ଭୋଜନପାନ କରି ସେହିଠାରେ ରାତ୍ରି କ୍ଷେପଣ କଲେ; ଏଥିଉତ୍ତାରେ ସେମାନେ ପ୍ରଭାତରେ ଉଠନ୍ତେ, ସେହି ଦାସ କହିଲା, “ମୋʼ ପ୍ରଭୁଙ୍କ ନିକଟକୁ ଯିବାକୁ ମୋତେ ବିଦାୟ କର।” ");
INSERT INTO ory_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ତହିଁରେ ରିବିକାର ଭ୍ରାତା ଓ ମାତା କହିଲେ, “ଏହି କନ୍ୟା ଆମ୍ଭମାନଙ୍କ ନିକଟରେ କିଛି ଦିନ, ହୋଇ ପାରିଲେ ଦଶ ଦିନ ଥାଉ, ତହିଁ ଉତ୍ତାରେ ସେ ଯିବ।” ");
INSERT INTO ory_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ମାତ୍ର ସେ ସେମାନଙ୍କୁ କହିଲା, “ମୋତେ ବିଳମ୍ବ କରାଅ ନାହିଁ, ଯେହେତୁ ସଦାପ୍ରଭୁ ମୋହର ଯାତ୍ରା ସଫଳ କଲେ; ଏବେ ନିଜ କର୍ତ୍ତାଙ୍କ ନିକଟକୁ ଯିବା ପାଇଁ ମୋତେ ବିଦାୟ କର।” ");
INSERT INTO ory_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ତହିଁରେ ସେମାନେ କହିଲେ, “ଆମ୍ଭେମାନେ କନ୍ୟାକୁ ଡାକି ତାହାକୁ ସାକ୍ଷାତରେ ପଚାରୁ।” ");
INSERT INTO ory_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ଏଥିଉତ୍ତାରେ ସେମାନେ ରିବିକାକୁ ଡାକି କହିଲେ, “ତୁମ୍ଭେ କି ଏହି ମନୁଷ୍ୟ ସଙ୍ଗରେ ଯିବ?” ତହୁଁ ସେ କହିଲା, “ଯିବି।” ");
INSERT INTO ory_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ସେତେବେଳେ ସେମାନେ ଆପଣା ଭଗିନୀ ରିବିକାକୁ ଓ ତାହାର ଧାତ୍ରୀକୁ, ପୁଣି, ଅବ୍ରହାମଙ୍କର ଦାସ ଓ ତାହାର ଲୋକମାନଙ୍କୁ ବିଦାୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ପୁଣି, ରିବିକାକୁ ଆଶୀର୍ବାଦ କରି କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କର ଭଗିନୀ, ସହସ୍ର ସହସ୍ର ଲୋକର ମାତା ହୁଅ; ତୁମ୍ଭର ବଂଶ ଆପଣା ଶତ୍ରୁଗଣର ନଗର ଅଧିକାର କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ଏଥିଉତ୍ତାରେ ରିବିକା ଓ ତାହାର ଦାସୀମାନେ ଉଠି ଓଟ ଉପରେ ଚଢ଼ି ସେହି ମନୁଷ୍ୟର ପଛେ ପଛେ ଯାତ୍ରା କଲେ। ଏହିରୂପେ ସେହି ଦାସ ରିବିକାକୁ ଘେନି ପ୍ରସ୍ଥାନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ସେହି ସମୟରେ ଇସ୍‌ହାକ ଦକ୍ଷିଣ ଦେଶରେ ବାସ କରିବାରୁ ବେର-ଲହୟ-ରୋୟୀ ନାମକ ସ୍ଥାନକୁ ଯାଇ ଫେରି ଆସିଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ପୁଣି, ସନ୍ଧ୍ୟା ବେଳେ ଧ୍ୟାନ କରିବା ପାଇଁ କ୍ଷେତ୍ରକୁ ଯାଇଥିଲା; ଏଥିମଧ୍ୟରେ ଅନାଇ ଓଟଗଣକୁ ଆସିବାର ଦେଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ସେତେବେଳେ ରିବିକା ଅନାଇ ଇସ୍‌ହାକକୁ ଦେଖି ଓଟ ଉପରୁ ଓହ୍ଲାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ପୁଣି, ସେ ସେହି ଦାସକୁ ପଚାରିଲା, “ଆମ୍ଭମାନଙ୍କ ସହିତ ସାକ୍ଷାତ କରିବାକୁ ଯେ କ୍ଷେତ୍ର ମଧ୍ୟରେ ଆସୁଅଛି, ସେହି ପୁରୁଷ କିଏ?” ତହିଁରେ ଦାସ ଉତ୍ତର କଲା, “ସେ ମୋହର ପ୍ରଭୁ,” ଏଣୁ ରିବିକା ଘୋଡ଼ଣୀ ନେଇ ଆପଣାକୁ ଆଚ୍ଛାଦନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ଏଥିଉତ୍ତାରେ ସେହି ଦାସ ଇସ୍‌ହାକକୁ ଆପଣା କୃତ କର୍ମର ସମସ୍ତ ବିବରଣ କହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ସେତେବେଳେ ଇସ୍‌ହାକ ରିବିକାକୁ ଗ୍ରହଣ କରି ଆପଣା ମାତା ସାରାର ତମ୍ବୁକୁ ଘେନିଯାଇ ତାହାକୁ ବିବାହ କଲା; ପୁଣି, ସେ ତାହାକୁ ପ୍ରେମ କଲା। ତହିଁରେ ଇସ୍‌ହାକ ମାତୃମରଣ ଶୋକରୁ ସାନ୍ତ୍ୱନା ପାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ଅବ୍ରହାମ କଟୂରା ନାମ୍ନୀ ଆଉ ଗୋଟିଏ ସ୍ତ୍ରୀ ବିବାହ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ସେ ତାଙ୍କ ନିମନ୍ତେ ସିମ୍ରନ୍‍, ଯକ୍‍ଷନ୍‍, ମଦାନ୍‍, ମିଦୀୟନ, ଯିଶ୍‍ବକ ଓ ଶୂହ, ଏମାନଙ୍କୁ ଜନ୍ମ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ସେହି ଯକ୍‍ଷନ୍‍ ଶିବା ଓ ଦଦାନକୁ ଜାତ କଲା। ଦଦାନ ଅଶୂରୀୟ ଓ ଲଟୂଶୀୟ ଓ ଲୀୟମ୍ମୀୟ ଲୋକମାନଙ୍କର ଆଦିପୁରୁଷ। ");
INSERT INTO ory_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ମିଦୀୟନର ସନ୍ତାନ ଐଫା ଓ ଏଫର ଓ ହନୋକ ଓ ଅବୀଦ ଓ ଇଲଦାୟା; ଏସମସ୍ତେ କଟୂରାର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ଇସ୍‌ହାକକୁ ଆପଣାର ସର୍ବସ୍ୱ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ମାତ୍ର ଅବ୍ରହାମ ଉପପତ୍ନୀମାନଙ୍କ ସନ୍ତାନଗଣକୁ କିଛି କିଛି ଦେଇ ଆପଣା ଜୀବଦ୍ଦଶାରେ ଇସ୍‌ହାକ ନିକଟରୁ ସେମାନଙ୍କୁ ପୂର୍ବଦିଗସ୍ଥ ଦେଶରେ ରହିବାକୁ ବିଦାୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ଅବ୍ରହାମଙ୍କର ଆୟୁର ପରିମାଣ ଶହେ ପଞ୍ଚସ୍ତରି ବର୍ଷ; ସେ ଏତେ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ଜୀବିତ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ଏଥିଉତ୍ତାରେ ଅବ୍ରହାମ ଉତ୍ତମ ବୃଦ୍ଧାବସ୍ଥାରେ ବୃଦ୍ଧ ଓ ପୂର୍ଣ୍ଣାୟୁ ହୋଇ ପ୍ରାଣତ୍ୟାଗ କଲେ; ଆଉ, ପୂର୍ବରୁ ମୃତ୍ୟୁବରଣ କରିଥିବା ଆପଣା ପୂର୍ବପୁରୁଷଗଣ ସହିତ ଜଡିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ଆଉ ତାଙ୍କର ପୁତ୍ର ଇସ୍‌ହାକ ଓ ଇଶ୍ମାୟେଲ ମମ୍ରିର ସମ୍ମୁଖରେ ହିତ୍ତୀୟ ସୋହରର ପୁତ୍ର ଇଫ୍ରୋଣର କ୍ଷେତ୍ରସ୍ଥିତ ମକ୍‍ପେଲା ନାମକ ଗୁହାରେ ତାଙ୍କୁ କବର ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ଯେହେତୁ ଅବ୍ରହାମ ହିତ୍ତୀୟ ସନ୍ତାନମାନଙ୍କ ନିକଟରୁ ସେହି କ୍ଷେତ୍ର କ୍ରୟ କରିଥିଲେ। ସେହି ସ୍ଥାନରେ ଅବ୍ରହାମଙ୍କର ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟା ସାରାର କବର ଦିଆଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ଅବ୍ରହାମଙ୍କ ମୃତ୍ୟୁୁ ଉତ୍ତାରେ ପରମେଶ୍ୱର ତାଙ୍କର ପୁତ୍ର ଇସ୍‌ହାକଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ; ପୁଣି, ଇସ୍‌ହାକ ବେର-ଲହୟ-ରୋୟୀ ନାମକ ସ୍ଥାନରେ ବସତି କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ସାରାର ଦାସୀ ମିସରୀୟା ହାଗାର ଅବ୍ରହାମଙ୍କ ନିମନ୍ତେ ଯାହାକୁ ପ୍ରସବ କରିଥିଲା, ଅବ୍ରହାମଙ୍କର ସେହି ପୁତ୍ର ଇଶ୍ମାୟେଲର ବଂଶାବଳୀ। ");
INSERT INTO ory_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ନାମ ଓ ଗୋଷ୍ଠୀ ଅନୁସାରେ ଇଶ୍ମାୟେଲର ସନ୍ତାନମାନଙ୍କ ନାମ ଏହି। ଇଶ୍ମାୟେଲର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ନବାୟୋତ୍‍; ତାହା ଉତ୍ତାରେ କେଦାର ଓ ଅଦ୍‍ବେଲ ଓ ମିବ୍‍ସମ୍‍, ");
INSERT INTO ory_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ମିଶ୍ମା ଓ ଦୂମା ଓ ମସା, ");
INSERT INTO ory_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ଓ ହଦଦ୍‍ ଓ ତେମା ଓ ଯିଟୁର ଓ ନାଫୀଶ୍‍ ଓ କେଦମା। ");
INSERT INTO ory_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ଏହି ସମସ୍ତେ ଇଶ୍ମାୟେଲର ସନ୍ତାନ, ପୁଣି, ସେମାନଙ୍କ ନାମାନୁସାରେ ସେମାନଙ୍କର ଗ୍ରାମ ଓ ଛାଉଣି-ସ୍ଥାନ ଥିଲା; ଆଉ ସେମାନେ ଆପଣା ଆପଣା ଗୋତ୍ରାନୁସାରେ ଦ୍ୱାଦଶ ଅଧିପତି ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ଇଶ୍ମାୟେଲର ଆୟୁର ପରିମାଣ ଶହେ ସଇଁତିରିଶ ବର୍ଷ ଥିଲା; ତହୁଁ ସେ ପ୍ରାଣତ୍ୟାଗ କଲା; ଆଉ ସେ ଆପଣା ଲୋକମାନଙ୍କ ନିକଟରେ ସଂଗୃହୀତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ଏଥିଉତ୍ତାରେ ତାହାର ସନ୍ତାନମାନେ ହବୀଲା ଓ ମିସରର ପୂର୍ବସ୍ଥିତ ଶୂରଠାରୁ ଅଶୂରୀୟା ଦିଗରେ ବସତି କଲେ। ଏହିରୂପେ ସେ ଆପଣା ସମସ୍ତ ଭ୍ରାତୃଗଣର ସମ୍ମୁଖସ୍ଥ ବସତି ସ୍ଥାନ ପାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ଅବ୍ରହାମଙ୍କର ପୁତ୍ର ଇସ୍‌ହାକଙ୍କର ବଂଶାବଳୀ। ଅବ୍ରହାମ ଇସ୍‌ହାକଙ୍କୁ ଜାତ କଲେ; ");
INSERT INTO ory_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ସେହି ଇସ୍‌ହାକ ଚାଳିଶ ବର୍ଷ ବୟସରେ ପଦ୍ଦନ୍‍ ଅରାମୀୟ ବଥୂୟେଲର କନ୍ୟା, ଅର୍ଥାତ୍‍, ଅରାମୀୟ ଲାବନର ଭଗିନୀ ରିବିକାକୁ ବିବାହ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ଇସ୍‌ହାକଙ୍କର ସେହି ଭାର୍ଯ୍ୟା ବନ୍ଧ୍ୟା ହେବାରୁ ସେ ତାହା ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କଲେ; ତହିଁରେ ସଦାପ୍ରଭୁ ତାଙ୍କର ପ୍ରାର୍ଥନା ଶୁଣନ୍ତେ, ତାହାର ଭାର୍ଯ୍ୟା ରିବିକା ଗର୍ଭବତୀ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ଏଥିଉତ୍ତାରେ ତାହାର ଗର୍ଭ ମଧ୍ୟରେ ଶିଶୁମାନେ ଛନ୍ଦାଛନ୍ଦି ହେବାରୁ, “ମୋହର ଏପରି କାହିଁକି ହେଲା? ଏପରି କି ହୋଇଥାଏ?” ଏହା ଭାବି ସେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟକୁ ପଚାରିବା ପାଇଁ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ତହିଁରେ ସଦାପ୍ରଭୁ ତାହାକୁ କହିଲେ, “ତୁମ୍ଭ ଗର୍ଭରେ ଦୁଇ ଗୋଷ୍ଠୀ ଅଛନ୍ତି ଓ ଦୁଇ ଗୋତ୍ର ତୁମ୍ଭ ଉଦରରୁ ବିଭିନ୍ନ ହେବେ; ଏକ ଗୋତ୍ର ଅନ୍ୟ ଗୋତ୍ରଠାରୁ ବଳବାନ ହେବ, ପୁଣି, ଜ୍ୟେଷ୍ଠ କନିଷ୍ଠର ସେବା କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ଏଥିଉତ୍ତାରେ ପ୍ରସବକାଳ ସମ୍ପୂର୍ଣ୍ଣ ହୁଅନ୍ତେ, ତାହାର ଗର୍ଭରୁ ଯାଆଁଳା ପୁତ୍ର ଜନ୍ମିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ତାହାର ଜ୍ୟେଷ୍ଠ ରକ୍ତବର୍ଣ୍ଣ ଓ ସର୍ବାଙ୍ଗ ଲୋମଶ ବସ୍ତ୍ର ପରି ଥିଲା; ଏହେତୁ ତାହାର ନାମ ଏଷୌ ଦିଆଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ତହିଁ ଉତ୍ତାରେ ଏଷୌର ପାଦମୂଳ ଧରି ତାହାର ଭ୍ରାତା ଭୂମିଷ୍ଠ ହେଲା; ଏଥିପାଇଁ ତାହାର ନାମ ଯାକୁବ ଦିଆଗଲା। ଇସ୍‌ହାକଙ୍କର ଷାଠିଏ ବର୍ଷ ବୟସରେ ଏହି ଯାଆଁଳା ପୁତ୍ର ଜାତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ଏଥିଉତ୍ତାରେ ବାଳକମାନେ ବଢ଼ିଲା ଉତ୍ତାରେ ଏଷୌ ମୃଗୟାନିପୁଣ ଓ ବନବିହାରୀ ହେଲା; ପୁଣି, ଯାକୁବ ମୃଦୁ ମନୁଷ୍ୟ ଓ ତମ୍ବୁବାସୀ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ଇସ୍‌ହାକ ମୃଗୟା ମାଂସ ଅତି ସୁସ୍ୱାଦୁ ବୋଧ କରିବାରୁ ଏଷୌକୁ ଭଲ ପାଇଲେ। ମାତ୍ର ରିବିକା ଯାକୁବକୁ ଭଲ ପାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ଏକ ଦିନ ଯାକୁବ ଡାଲି ରାନ୍ଧୁଥିଲା, ସେହି ସମୟରେ ଏଷୌ କ୍ଳାନ୍ତ ହୋଇ କ୍ଷେତ୍ରରୁ ଆସିଲା; ");
INSERT INTO ory_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ତହୁଁ ସେ ଯାକୁବକୁ କହିଲା, “ମୁଁ କ୍ଳାନ୍ତ ହୋଇଅଛି, ବିନୟ କରେ, ସେହି ରଙ୍ଗା ଡାଲି ଦେଇ ଭୋଜନ କରାଅ,” ଏହି ନିମନ୍ତେ ତାହାର ନାମ ଇଦୋମ୍‍ (ରଙ୍ଗା) ଖ୍ୟାତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ସେତେବେଳେ ଯାକୁବ କହିଲା, “ଆଜି ତୁମ୍ଭେ ମୋତେ ଆପଣା ଜ୍ୟେଷ୍ଠାଧିକାର ବିକ୍ରୟ କର।” ");
INSERT INTO ory_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ଏଷୌ ଉତ୍ତର କଲା, “ଦେଖ, ମୁଁ ମଲା ପରି, ଜ୍ୟେଷ୍ଠାଧିକାରରେ ମୋର କି ଲାଭ?” ");
INSERT INTO ory_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ଯାକୁବ କହିଲା, “ତୁମ୍ଭେ ଆଜି ମୋʼ ନିକଟରେ ଶପଥ କର,” ତହିଁରେ ସେ ତାହା ନିକଟରେ ଶପଥ କଲା। ଏହିରୂପେ ସେ ଆପଣା ଜ୍ୟେଷ୍ଠାଧିକାର ଯାକୁବକୁ ବିକ୍ରୟ କରିଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ତହୁଁ ଯାକୁବ ଏଷୌକୁ ରୁଟି ଓ ରନ୍ଧା ମସୁର ଡାଲି ଦିଅନ୍ତେ, ସେ ଭୋଜନପାନ କରି ଉଠିଗଲା। ଏହିରୂପେ ଏଷୌ ଆପଣା ଜ୍ୟେଷ୍ଠାଧିକାର ତୁଚ୍ଛଜ୍ଞାନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ପୂର୍ବେ ଅବ୍ରହାମଙ୍କର, ବର୍ତ୍ତମାନ ସମୟରେ ଯେରୂପ ଦୁର୍ଭିକ୍ଷ ହୋଇଥିଲା, ସେହି ଦେଶରେ ଆଉ ଥରେ ସେରୂପ ଦୁର୍ଭିକ୍ଷ ଉପସ୍ଥିତ ହୁଅନ୍ତେ, ଇସ୍‌ହାକ ଗରାରରେ ପଲେଷ୍ଟୀୟମାନଙ୍କ ରାଜା ଅବିମେଲକ ନିକଟକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ସେତେବେଳେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ ଦର୍ଶନ ଦେଇ କହିଲେ, “ତୁମ୍ଭେ ମିସର ଦେଶକୁ ଯାଅ ନାହିଁ; ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯେଉଁ ଦେଶ କହିବା, ସେଠାରେ ବାସ କର। ");
INSERT INTO ory_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ତୁମ୍ଭେ ଏହି ଦେଶରେ ପ୍ରବାସ କର, ତହିଁରେ ଆମ୍ଭେ ତୁମ୍ଭର ସହାୟ ହୋଇ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରିବା, ପୁଣି, ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭ ବଂଶକୁ ଏହି ସମସ୍ତ ଦେଶ ଦେବା ଓ ତୁମ୍ଭ ପିତା ଅବ୍ରହାମ ନିକଟରେ ଆପଣା କୃତ ଶପଥର ନିୟମ ସଫଳ କରିବା। ");
INSERT INTO ory_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ଆମ୍ଭେ ଆକାଶର ତାରାଗଣ ପରି ତୁମ୍ଭର ବଂଶ ବୃଦ୍ଧି କରି ସେମାନଙ୍କୁ ଏହିସବୁ ଦେଶ ଦେବା ଓ ତୁମ୍ଭର ବଂଶ ଦ୍ୱାରା ପୃଥିବୀସ୍ଥ ଯାବତୀୟ ଜାତି ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ଯେହେତୁ ଅବ୍ରହାମ ଆମ୍ଭର ବାକ୍ୟ ମାନି ଆମ୍ଭର ରକ୍ଷଣୀୟ ବିଷୟ ଆମ୍ଭର ଆଜ୍ଞା ଓ ବିଧି ଓ ବ୍ୟବସ୍ଥା ପାଳନ କରିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ତହିଁରେ ଇସ୍‌ହାକ ଗରାରଠାରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ତହିଁରେ ସେହି ସ୍ଥାନର ଲୋକମାନେ ତାଙ୍କର ଭାର୍ଯ୍ୟା ବିଷୟରେ ପଚାରନ୍ତେ, ସେ କହିଲେ, “ସେ ମୋହର ଭଗିନୀ,” ଯେହେତୁ ସେହି ସ୍ଥାନର ଲୋକମାନେ ରିବିକା ଲାଗି ମୋତେ ଅବା ବଧ କରିବେ, ଏହା ଭାବି ସେ ତାହାକୁ ଆପଣାର ଭାର୍ଯ୍ୟା ବୋଲି କହିବାକୁ ଭୟ କଲେ; ଯେହେତୁ ସେ ପରମସୁନ୍ଦରୀ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ପୁଣି, ସେହି ସ୍ଥାନରେ ବହୁ କାଳ ବାସ କଲା ଉତ୍ତାରେ ଏକ ସମୟରେ ପଲେଷ୍ଟୀୟ ରାଜା ଅବିମେଲକ ଝରକା ବାଟେ ନିରୀକ୍ଷଣ କରି ଇସ୍‌ହାକଙ୍କୁ ଆପଣା ଭାର୍ଯ୍ୟା ରିବିକା ସହିତ କୌତୁକ କରୁଥିବାର ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ତେଣୁ ଅବିମେଲକ ଇସ୍‌ହାକଙ୍କୁ ଡକାଇ କହିଲେ, “ସେ ସ୍ତ୍ରୀ ଅବଶ୍ୟ ତୁମ୍ଭର ଭାର୍ଯ୍ୟା; ତେବେ ‘ତୁମ୍ଭେ ତାହାକୁ ଆପଣା ଭଗିନୀ’ ବୋଲି କିପରି କହିଲ?” ସେତେବେଳେ ଇସ୍‌ହାକ ଉତ୍ତର କଲେ, “ମୁଁ ଭାବିଲି, କେଜାଣି ତାହା ଲାଗି ମୋହର ମୃତ୍ୟୁୁ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ତହିଁରେ ଅବିମେଲକ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ସହିତ ଏ କି ବ୍ୟବହାର କଲ? କୌଣସି ଲୋକ ତୁମ୍ଭ ଭାର୍ଯ୍ୟା ସଙ୍ଗେ ଅନାୟାସରେ ଶୟନ କରି ପାରନ୍ତା, ତାହାହେଲେ ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କୁ ଦୋଷଗ୍ରସ୍ତ କରନ୍ତ।” ");
INSERT INTO ory_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ଏଥିଉତ୍ତାରେ ଅବିମେଲକ ସବୁ ଲୋକଙ୍କୁ ଏହି ଆଜ୍ଞା ଦେଲେ, “ଯେକେହି ସେହି ମନୁଷ୍ୟକୁ କିଅବା ତାହାର ଭାର୍ଯ୍ୟାକୁ ସ୍ପର୍ଶ କରିବ, ତାହାର ପ୍ରାଣଦଣ୍ଡ ଅବଶ୍ୟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ଏଥିଉତ୍ତାରେ ଇସ୍‌ହାକ ସେହି ଦେଶରେ କୃଷିକର୍ମ କରି ସେହି ବର୍ଷ ଶହେ ଗୁଣ ଲାଭ କଲେ; ପୁଣି, ସଦାପ୍ରଭୁ ତାଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ଏନିମନ୍ତେ ସେ ବର୍ଦ୍ଧିଷ୍ଣୁ ହେଲେ, ପୁଣି, ସେ ଆହୁରି ଆହୁରି ବୃଦ୍ଧି ପାଇ ଅତି ମହାନ ହେଲେ ");
INSERT INTO ory_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ଏବଂ ତାଙ୍କର ମେଷଧନ ଓ ଗୋଧନ, ପୁଣି, ଅନେକ ଦାସଦାସୀ ହେଲେ; ତେଣୁ ପଲେଷ୍ଟୀୟ ଲୋକମାନେ ତାଙ୍କ ପ୍ରତି ଈର୍ଷା କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ଏଣୁ ତାଙ୍କର ପିତା ଅବ୍ରହାମଙ୍କ ସମୟରେ ତାଙ୍କ ପିତାଙ୍କ ଦାସମାନେ ଯେଉଁ ଯେଉଁ କୂପ ଖୋଳିଥିଲେ, ପଲେଷ୍ଟୀୟ ଲୋକମାନେ ମୃତ୍ତିକା ଦ୍ୱାରା ସେହି ସବୁ ପୋତି ପକାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ଏଥିଉତ୍ତାରେ ଅବିମେଲକ ଇସ୍‌ହାକଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ନିକଟରୁ ପ୍ରସ୍ଥାନ କର, ଯେହେତୁ ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କଠାରୁ ଅଧିକ ବଳବାନ ହୋଇଅଛ।” ");
INSERT INTO ory_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ତହିଁରେ ଇସ୍‌ହାକ ସେହି ସ୍ଥାନରୁ ଯାତ୍ରା କରି ଗରାର ଉପତ୍ୟକାରେ ତମ୍ବୁ ସ୍ଥାପନ କରି ସେହିଠାରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ପୁଣି, ଆପଣା ପିତା ଅବ୍ରହାମଙ୍କର ବର୍ତ୍ତମାନ ସମୟରେ ଖୋଦିତ ଯେଉଁ ଯେଉଁ ସଜଳ କୂପ ଅବ୍ରହାମଙ୍କ ମୃତ୍ୟୁୁ ଉତ୍ତାରେ ପଲେଷ୍ଟୀୟମାନେ ପୋତି ପକାଇଥିଲେ, ସେହି ସମସ୍ତ ଇସ୍‌ହାକ ପୁନର୍ବାର ଖୋଳି ଆପଣା ପିତୃଦତ୍ତ ନାମ ପୁନରପି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ଆଉ ଇସ୍‌ହାକଙ୍କର ଦାସମାନେ ସେହି ଉପତ୍ୟକା ଖୋଳି ସ୍ରୋତବାହୀ କୂପ ପ୍ରାପ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ତହିଁରେ ଗରାରଦେଶୀୟ ପଶୁପାଳକମାନେ ଇସ୍‌ହାକଙ୍କର ପଶୁପାଳକମାନଙ୍କ ସହିତ ବିବାଦ କରି କହିଲେ, “ଏହି ଜଳ ଆମ୍ଭମାନଙ୍କର,” ଏଣୁ ସେ ସେହି କୂପର ନାମ “ଏଷକ” (ବିବାଦ) ରଖିଲେ, ଯେହେତୁ ସେମାନେ ତାଙ୍କ ସହିତ ବିବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ଏଥିଉତ୍ତାରେ ତାଙ୍କର ଦାସମାନେ ଆଉ ଏକ କୂପ ଖୋଳନ୍ତେ, ସେମାନେ ତହିଁ ପାଇଁ ମଧ୍ୟ ବିବାଦ କଲେ; ତହୁଁ ଇସ୍‌ହାକ ତହିଁର ନାମ “ସିଟ୍ନା” (ଶତ୍ରୁତା) ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ପୁଣି, ସେ ସେଠାରୁ ପ୍ରସ୍ଥାନ କରି ଅନ୍ୟ ଏକ କୂପ ଖୋଳିଲେ। ତହିଁ ନିମିତ୍ତ ସେମାନେ ବିବାଦ ନ କରିବାରୁ ତହିଁର ନାମ ରହୋବୋତ୍‍ (ପ୍ରଶସ୍ତ ସ୍ଥାନ) ରଖିଲେ; କାରଣ ସେ କହିଲେ, “ଏବେ ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କୁ ସ୍ଥାନ ଦେଲେ, ଆମ୍ଭେମାନେ ଦେଶରେ ବର୍ଦ୍ଧିଷ୍ଣୁ ହେବା।” ");
INSERT INTO ory_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ଏଥିଉତ୍ତାରେ ସେ ସେହି ସ୍ଥାନରୁ ବେର୍‍ଶେବାକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ସେହି ରାତ୍ରରେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ ଦର୍ଶନ ଦେଇ କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭ ପିତା ଅବ୍ରହାମର ପରମେଶ୍ୱର ଅଟୁ; ଭୟ କର ନାହିଁ, କାରଣ ଆମ୍ଭେ ଆପଣା ଦାସ ଅବ୍ରହାମ ସକାଶୁ ତୁମ୍ଭର ସହାୟ ଅଟୁ ଓ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରି ତୁମ୍ଭର ବଂଶ ବୃଦ୍ଧି କରିବା।” ");
INSERT INTO ory_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ଏଥିଉତ୍ତାରେ ଇସ୍‌ହାକ ସେହି ସ୍ଥାନରେ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କରି ସଦାପ୍ରଭୁଙ୍କ ନାମରେ ପ୍ରାର୍ଥନା କଲେ। ଏଥିଉତ୍ତାରେ ସେ ସେହି ସ୍ଥାନରେ ତମ୍ବୁ ସ୍ଥାପନ କରନ୍ତେ, ତାଙ୍କର ଦାସମାନେ ଗୋଟିଏ କୂପ ଖୋଳିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ଏଥିଉତ୍ତାରେ ଅବିମେଲକ ଅହୁଷତ୍‍ ନାମକ ଆପଣା ମିତ୍ରକୁ ଓ ଫୀଖୋଲ ନାମକ ସେନାପତିକୁ ସଙ୍ଗରେ ଘେନି ଗରାରଠାରୁ ଇସ୍‌ହାକଙ୍କ ନିକଟକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ତହିଁରେ ଇସ୍‌ହାକ ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ତ ମୋତେ ଘୃଣା କରୁଅଛ, ପୁଣି, ଆପଣାମାନଙ୍କ ମଧ୍ୟରୁ ମୋତେ ଦୂର କରି ଦେଇଥିଲ, ଏବେ ମୋʼ ନିକଟକୁ କାହିଁକି ଆସିଅଛ?” ");
INSERT INTO ory_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ତହିଁରେ ସେମାନେ ଉତ୍ତର କଲେ, “ସଦାପ୍ରଭୁ ତୁମ୍ଭର ସହାୟ ଅଟନ୍ତି, ଏହା ଆମ୍ଭେମାନେ ସ୍ପଷ୍ଟ ଦେଖିଲୁ; ଏହେତୁ କହିଲୁ, ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଗୋଟିଏ ରାଣ ଥାଉ ଓ ଆମ୍ଭମାନଙ୍କ ସହିତ ତୁମ୍ଭର ଏହି ଏକ ନିୟମ ହେଉ; ");
INSERT INTO ory_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ଆମ୍ଭେମାନେ ଯେପରି ତୁମ୍ଭକୁ ସ୍ପର୍ଶ କରି ନାହୁଁ ଓ ତୁମ୍ଭର ମଙ୍ଗଳ ବିନୁ ଆଉ କିଛି କରି ନାହୁଁ, ବରଞ୍ଚ ତୁମ୍ଭକୁ ଶାନ୍ତିରେ ବିଦାୟ କରିଅଛୁ, ସେପରି ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କୁ ହିଂସା କରିବ ନାହିଁ; ତୁମ୍ଭେ ତ ସଦାପ୍ରଭୁଙ୍କର ଆଶୀର୍ବାଦ-ପାତ୍ର।” ");
INSERT INTO ory_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ସେତେବେଳେ ଇସ୍‌ହାକ ସେମାନଙ୍କ ପାଇଁ ଭୋଜ ପ୍ରସ୍ତୁତ କରନ୍ତେ, ସେମାନେ ଭୋଜନପାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ଏଥିଉତ୍ତାରେ ସେମାନେ ଶୀଘ୍ର ପ୍ରଭାତରେ ଉଠି ପରସ୍ପର ଶପଥ କଲେ। ପୁଣି, ଇସ୍‌ହାକ ସେମାନଙ୍କୁ ବିଦାୟ କରନ୍ତେ, ସେମାନେ କୁଶଳରେ ତାଙ୍କ ନିକଟରୁ ପ୍ରସ୍ଥାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ସେହି ଦିନ ଇସ୍‌ହାକଙ୍କର ଦାସମାନେ ଆସି ଆପଣାମାନଙ୍କ ଖୋଦିତ କୂପ ବିଷୟରେ ସମ୍ବାଦ ଦେଇ ତାଙ୍କୁ କହିଲେ, “ଆମ୍ଭେମାନେ ଜଳ ପାଇଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ଏହେତୁ ସେ ସେହି କୂପର ନାମ ଶୀବା ରଖିଲେ, ପୁଣି, ଆଜି ପର୍ଯ୍ୟନ୍ତ ସେହି ସ୍ଥାନର ନଗର ବେର୍‍ଶେବା ନାମରେ ଖ୍ୟାତ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ଏଥିଉତ୍ତାରେ ଏଷୌ ଚାଳିଶ ବର୍ଷ ବୟସରେ ହିତ୍ତୀୟ ବେରିର ଯିହୁଦୀତ୍‍ ନାମ୍ନୀ କନ୍ୟାକୁ ଓ ହିତ୍ତୀୟ ଏଲୋନ୍‍ର ବାସମତ୍‍ ନାମ୍ନୀ କନ୍ୟାକୁ ବିବାହ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ମାତ୍ର ସେମାନେ ଇସ୍‌ହାକ ଓ ରିବିକାଙ୍କ ମନର ଦୁଃଖଦାୟିନୀ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍‌ହାକ ବୃଦ୍ଧ ହୁଅନ୍ତେ, ଚକ୍ଷୁ ନିସ୍ତେଜ ହେବାରୁ ଆଉ ଦେଖି ପାରିଲେ ନାହିଁ; ସେତେବେଳେ ସେ ଆପଣା ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଏଷୌକୁ ଡାକି କହିଲେ, “ପୁଅରେ,” ତହିଁରେ ସେ ଉତ୍ତର କଲା, “ଦେଖନ୍ତୁ, ମୁଁ ଏଠାରେ।” ");
INSERT INTO ory_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ତହୁଁ ସେ ତାହାଙ୍କୁ କହିଲେ, “ଦେଖ, ମୁଁ ବୃଦ୍ଧ ହୋଇଅଛି, କେଉଁ ଦିନ ମୋହର ମୃତ୍ୟୁୁ ହେବ, ତାହା ମୁଁ ଜାଣେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ଏବେ ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ଏତେବେଳେ ତୂଣ ଓ ଧନୁକାଦି ଶସ୍ତ୍ର ଘେନି ପ୍ରାନ୍ତରକୁ ଯାଇ ମୋʼ ନିମନ୍ତେ ମୃଗ ଆଣ। ");
INSERT INTO ory_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ପୁଣି, ମୁଁ ଯେରୂପ ଖାଦ୍ୟ ଭଲ ପାଏ, ସେହିପରି ସୁସ୍ୱାଦୁ ଖାଦ୍ୟ ପ୍ରସ୍ତୁତ କରି ଭୋଜନ ନିମନ୍ତେ ମୋʼ ନିକଟକୁ ଆଣ; ତହିଁରେ ମୋହର ପ୍ରାଣ ମୃତ୍ୟୁୁ ପୂର୍ବରେ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ଇସ୍‌ହାକ ଆପଣା ପୁତ୍ର ଏଷୌକୁ ଏହି କଥା କହିବା ସମୟରେ ରିବିକା ଶୁଣିଲା। ଏହେତୁ ଏଷୌ ମୃଗୟା ମାଂସ ଆଣିବା ନିମନ୍ତେ କ୍ଷେତ୍ରକୁ ଗଲା ଉତ୍ତାରେ, ");
INSERT INTO ory_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ରିବିକା ଆପଣା ପୁତ୍ର ଯାକୁବଙ୍କୁ କହିଲା, “ଦେଖ, ତୁମ୍ଭର ଭ୍ରାତା ଏଷୌ ସହିତ ତୁମ୍ଭ ପିତାଙ୍କର କଥୋପକଥନ ମୁଁ ଶୁଣିଲି, ");
INSERT INTO ory_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ସେ ତାହାକୁ କହିଲେ, ‘ତୁମ୍ଭେ ମୃଗୟା ମାଂସ ଆଣି ଆମ୍ଭ ନିମନ୍ତେ ସୁସ୍ୱାଦୁ ଖାଦ୍ୟ ପ୍ରସ୍ତୁତ କର, ତହିଁରେ ଆମ୍ଭେ ଭୋଜନ କରି ମୃତ୍ୟୁୁ ପୂର୍ବରେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରିବା।’ ");
INSERT INTO ory_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ଏନିମନ୍ତେ, ପୁଅ, ଏବେ ମୁଁ ତୁମ୍ଭକୁ ଯେଉଁ ଆଜ୍ଞା ଦେଉଅଛି, ମୋହର ସେହି କଥା ଶୁଣ। ");
INSERT INTO ory_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ତୁମ୍ଭେ ଏବେ ଗୋଠକୁ ଯାଇ ସେଠାରୁ ଦୁଇଗୋଟି ଉତ୍ତମ ଛେଳିଛୁଆ ଆଣ; ତହିଁରେ ତୁମ୍ଭର ପିତା ଯେପରି ଭଲ ପାʼନ୍ତି, ସେହିପରି ସୁସ୍ୱାଦୁ ଖାଦ୍ୟ ମୁଁ ରାନ୍ଧିଦେବି। ");
INSERT INTO ory_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ତୁମ୍ଭେ ତାହା ଘେନି ପିତାଙ୍କ ନିକଟକୁ ଯାଅ; ତହିଁରେ ସେ ତାହା ଭୋଜନ କରି ମୃତ୍ୟୁୁ ପୂର୍ବରୁ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ସେତେବେଳେ ଯାକୁବ ଆପଣା ମାତା ରିବିକାକୁ କହିଲା, “ଦେଖ, ମୋହର ଭ୍ରାତା ଏଷୌ ଲୋମଶ, ମାତ୍ର ମୁଁ ନିର୍ଲୋମ। ");
INSERT INTO ory_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ଏଣୁ ଯଦି ପିତା ମୋତେ ସ୍ପର୍ଶ କରିବେ, ତେବେ ମୁଁ ତାଙ୍କ ଦୃଷ୍ଟିରେ ପ୍ରବଞ୍ଚକ ଦେଖାଯିବି; ତାହାହେଲେ ମୁଁ ଆପଣା ଉପରକୁ ଆଶୀର୍ବାଦ ନ ଆଣି ଅଭିଶାପ ଆଣିବି।” ");
INSERT INTO ory_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ମାତ୍ର ତାହାର ମାତା କହିଲା, “ପୁଅ, ସେହି ଅଭିଶାପ ମୋତେ ଘଟୁ, କେବଳ ତୁମ୍ଭେ ମୋʼ କଥା ମାନ ଓ ଯାଇ ଛେଳିଛୁଆ ଆଣ।” ");
INSERT INTO ory_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ତହୁଁ ଯାକୁବ ଯାଇ ତାହା ଘେନି ମାତା ନିକଟକୁ ଆଣନ୍ତେ, ମାତା ତାହାର ପିତାଙ୍କର ରୁଚି ଅନୁସାରେ ସୁସ୍ୱାଦୁ ଖାଦ୍ୟ ରନ୍ଧନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ତହିଁରେ ରିବିକା ଘରେ ଆପଣା ନିକଟରେ ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଏଷୌର ଥିବା ଉତ୍ତମ ବସ୍ତ୍ର ଆଣି କନିଷ୍ଠ ପୁତ୍ର ଯାକୁବକୁ ପିନ୍ଧାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ପୁଣି, ଛେଳିଛୁଆର ଛାଲ ଘେନି ତାହା ହସ୍ତରେ ଓ ଗଳଦେଶର ନିର୍ଲୋମ ସ୍ଥାନରେ ଗୁଡ଼ାଇ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ଆଉ ସେହି ରନ୍ଧା ସୁସ୍ୱାଦୁ ଖାଦ୍ୟ ଓ ରୁଟି ଯାକୁବର ହସ୍ତରେ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ତହୁଁ ଯାକୁବ ଆପଣା ପିତା ନିକଟକୁ ଯାଇ କହିଲା, “ପିତଃ,” ସେ ଉତ୍ତର କଲେ, “ଦେଖ, ମୁଁ ଏଠାରେ ପୁତ୍ର, ତୁମ୍ଭେ କିଏ?” ");
INSERT INTO ory_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ଯାକୁବ ଆପଣା ପିତାଙ୍କୁ କହିଲା, “ମୁଁ ଆପଣଙ୍କ ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଏଷୌ; ଆପଣ ଯାହା ଆଜ୍ଞା କରିଥିଲେ, ମୁଁ ତାହା କରିଅଛି, ଏବେ ନିବେଦନ କରୁଅଛି, ଆପଣ ଉଠନ୍ତୁ, ପୁଣି, ବସି ମୋହର ମୃଗୟା ମାଂସ ଭୋଜନ କରନ୍ତୁ, ତହିଁ ଉତ୍ତାରେ ଆପଣ ମୋତେ ଆଶୀର୍ବାଦ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ତହିଁରେ ଇସ୍‌ହାକ ଆପଣା ପୁତ୍ରକୁ କହିଲେ, “ପୁତ୍ର, ତୁମ୍ଭେ ଏତେ ଶୀଘ୍ର ତାହା କିପରି ପାଇଲ?” ସେ କହିଲା, “ଆପଣଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ମୋତେ ତାହା ଭେଟାଇ ଦେଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ଇସ୍‌ହାକ ଯାକୁବଙ୍କୁ ଆହୁରି କହିଲେ, “ପୁତ୍ର, ମୋʼ ପାଖକୁ ଆସ, ତୁମ୍ଭେ ପ୍ରକୃତରେ ମୋହର ପୁତ୍ର ଏଷୌ କି ନାହିଁ, ତୁମ୍ଭକୁ ସ୍ପର୍ଶ କରି ଜାଣିବି।” ");
INSERT INTO ory_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ତହୁଁ ଯାକୁବ ଆପଣା ପିତା ଇସ୍‌ହାକଙ୍କ ନିକଟକୁ ଯାʼନ୍ତେ, ସେ ତାହା ସ୍ପର୍ଶ କରି କହିଲେ, “ଏହି ସ୍ୱର ଯାକୁବର ସ୍ୱର, ମାତ୍ର ଏହି ହସ୍ତ ଏଷୌର ହସ୍ତ ଅଟଇ।” ");
INSERT INTO ory_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ଏହିରୂପେ ସେ ତାହାକୁ ଚିହ୍ନି ପାରିଲେ ନାହିଁ, ଯେହେତୁ ସେ ଆପଣା ଭ୍ରାତା ଏଷୌର ହସ୍ତ ନ୍ୟାୟ ଆପଣା ହସ୍ତ ଲୋମଯୁକ୍ତ କରିଥିଲା; ଏଣୁ ସେ ତାହାକୁ ଆଶୀର୍ବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ଏଥିଉତ୍ତାରେ ସେ କହିଲେ, “ତୁମ୍ଭେ କି ନିତାନ୍ତ ମୋହର ପୁତ୍ର ଏଷୌ?” ସେ କହିଲା, “ହଁ, ମୁଁ ସେହି।” ");
INSERT INTO ory_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ସେତେବେଳେ ଇସ୍‌ହାକ କହିଲେ, “ତାହା ମୋʼ ପାଖକୁ ଆଣ; ମୁଁ ଆପଣା ପୁତ୍ରର ଆନୀତ ମୃଗୟା ମାଂସ ଭୋଜନ କରିବି, ତହୁଁ ମୁଁ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରିବି।” ତହିଁରେ ସେ ନିକଟକୁ ଆଣି ଦିଅନ୍ତେ, ଇସ୍‌ହାକ ତାହା ଭୋଜନ କଲେ; ପୁଣି, ଦ୍ରାକ୍ଷାରସ ଆଣି ଦିଅନ୍ତେ, ତାହା ପାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ଏଥିଉତ୍ତାରେ ତାହାର ପିତା ଇସ୍‌ହାକ କହିଲେ, “ପୁତ୍ର, ଏବେ ମୋʼ ନିକଟକୁ ଆସି ମୋତେ ଚୁମ୍ବନ କର।” ");
INSERT INTO ory_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ସେତେବେଳେ ସେ ନିକଟକୁ ଯାଇ ଚୁମ୍ବନ କରନ୍ତେ, ଇସ୍‌ହାକ ତାହାର ବସ୍ତ୍ରର ଗନ୍ଧ ପାଇ ତାଙ୍କୁ ଆଶୀର୍ବାଦ କରି କହିଲେ, “ଦେଖ, ସଦାପ୍ରଭୁଙ୍କ ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ କ୍ଷେତ୍ରର ସୁଗନ୍ଧି ତୁଲ୍ୟ ମୋʼ ପୁତ୍ରର ସୁଗନ୍ଧି; ");
INSERT INTO ory_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ପରମେଶ୍ୱର ଆକାଶର କାକରରୁ ଓ ପୃଥିବୀର ଉର୍ବରତାରୁ ଉତ୍ପନ୍ନ (ଫଳ) ଓ ପ୍ରଚୁର ଶସ୍ୟ ଓ ଦ୍ରାକ୍ଷାରସ ତୁମ୍ଭକୁ ଦିଅନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ଲୋକସମୂହ ତୁମ୍ଭର ସେବା କରନ୍ତୁ ଓ ନାନା ବଂଶ ତୁମ୍ଭକୁ ପ୍ରଣାମ କରନ୍ତୁ; ତୁମ୍ଭେ ଆପଣା ଜ୍ଞାତିମାନଙ୍କର କର୍ତ୍ତା ହୁଅ, ପୁଣି, ତୁମ୍ଭର ମାତୃପୁତ୍ରମାନେ ତୁମ୍ଭକୁ ପ୍ରଣାମ କରନ୍ତୁ; ଯେ ତୁମ୍ଭକୁ ଅଭିଶାପ ଦିଏ, ସେ ଅଭିଶପ୍ତ ହେଉ, ପୁଣି, ଯେ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରେ, ସେ ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ଏହି ପ୍ରକାରେ ଇସ୍‌ହାକ ଯାକୁବଙ୍କୁ ଆଶୀର୍ବାଦ କଲା ଉତ୍ତାରେ ଯାକୁବ ଆପଣା ପିତା ଇସ୍‌ହାକଙ୍କ ନିକଟରୁ ବାହାର ହେବା ମାତ୍ରେ ତାହାର ଭ୍ରାତା ଏଷୌ ଶିକାରରୁ ଆସିଲା। ");
INSERT INTO ory_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ପୁଣି, ସେ ମଧ୍ୟ ସୁସ୍ୱାଦୁ ଖାଦ୍ୟ ପ୍ରସ୍ତୁତ କରି ପିତା ନିକଟକୁ ଆଣି କହିଲା, “ପିତଃ, ଆପଣ ଉଠି ପୁତ୍ରର ଆନୀତ ମୃଗୟା ମାଂସ ଭୋଜନ କରନ୍ତୁ, ତହିଁ ଉତ୍ତାରେ ଆପଣ ମୋତେ ଆଶୀର୍ବାଦ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ତହିଁରେ ତାହାର ପିତା ଇସ୍‌ହାକ କହିଲେ, “ତୁମ୍ଭେ କିଏ?” ସେ କହିଲା, “ମୁଁ ଆପଣଙ୍କ ପୁତ୍ର, ଆପଣଙ୍କ ପ୍ରଥମଜାତ ଏଷୌ।” ");
INSERT INTO ory_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ସେତେବେଳେ ଇସ୍‌ହାକ ଅତିଶୟ କମ୍ପିତ ହୋଇ କହିଲେ, “ତେବେ ଯେ ମୋʼ ନିକଟକୁ ମୃଗୟା ମାଂସ ଆଣିଥିଲା, ସେ କିଏ? ତୁମ୍ଭ ଆସିବା ପୂର୍ବେ ମୁଁ ତାହା ଭୋଜନ କରି ତାକୁ ଆଶୀର୍ବାଦ କଲି, ଆହୁରି ସେ ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ଏଷୌ ପିତାଙ୍କର ଏହି କଥା ଶୁଣିବାମାତ୍ରେ ଅତ୍ୟନ୍ତ ବ୍ୟାକୁଳ ଚିତ୍ତରେ ମହାଚିତ୍କାର କଲା, ପୁଣି, ଆପଣା ପିତାଙ୍କୁ କହିଲା, “ପିତଃ, ମୋତେ, ମୋତେ ମଧ୍ୟ ଆଶୀର୍ବାଦ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ତହିଁରେ ଇସ୍‌ହାକ କହିଲେ, “ତୁମ୍ଭର ଭ୍ରାତା ଆସି ପ୍ରବଞ୍ଚନା କରି ତୁମ୍ଭର (ପ୍ରାପ୍ତବ୍ୟ) ଆଶୀର୍ବାଦ ହରଣ କରିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ତହିଁରେ ଏଷୌ କହିଲା, “ତାହାର ଯଥାର୍ଥ ନାମ କି ଯାକୁବ ନୁହେଁ? ଯେହେତୁ ସେ ଦୁଇ ଥର ମୋତେ ପ୍ରବଞ୍ଚନା କରିଅଛି, ସେ ପୂର୍ବରେ ମୋର ଜ୍ୟେଷ୍ଠାଧିକାର ହରଣ କରିଥିଲା, ପୁଣି, ଦେଖ, ଏବେ ମୋର (ପ୍ରାପ୍ତବ୍ୟ) ଆଶୀର୍ବାଦ ମଧ୍ୟ ହରଣ କରିଅଛି।” ସେ ପୁନର୍ବାର କହିଲା, “ଆପଣ କି ମୋʼ ନିମନ୍ତେ ଗୋଟିଏ ଆଶୀର୍ବାଦ ରଖି ନାହାନ୍ତି?” ");
INSERT INTO ory_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ତହୁଁ ଇସ୍‌ହାକ ଏଷୌକୁ କହିଲେ, “ଦେଖ, ମୁଁ ତାହାକୁ ତୁମ୍ଭର କର୍ତ୍ତା କଲି, ପୁଣି, ତାହାର ଜ୍ଞାତି ସମସ୍ତଙ୍କୁ ତାହାର ଅଧୀନ କଲି, ଆଉ ଶସ୍ୟ ଓ ଦ୍ରାକ୍ଷାରସ ଦ୍ୱାରା ତାହାକୁ ସବଳ କଲି; ଏହେତୁ ପୁତ୍ର, ଏବେ ତୁମ୍ଭ ନିମନ୍ତେ ଆଉ କଅଣ କରିପାରେ?” ");
INSERT INTO ory_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ତହିଁରେ ଏଷୌ ପୁନର୍ବାର ଆପଣା ପିତାଙ୍କୁ କହିଲା, “ପିତଃ, ଆପଣଙ୍କର କି କେବଳ ଗୋଟିଏ ଆଶୀର୍ବାଦ ଥିଲା? ହେ ପିତଃ, ମୋତେ, ମୋତେ ମଧ୍ୟ ଆଶୀର୍ବାଦ କରନ୍ତୁ।” ଏହା କହି ଏଷୌ ଉଚ୍ଚସ୍ୱରରେ କାନ୍ଦିବାକୁ ଲାଗିଲା। ");
INSERT INTO ory_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ତହୁଁ ତାହାର ପିତା ଇସ୍‌ହାକ ଉତ୍ତର ଦେଇ କହିଲେ, “ଦେଖ, ତୁମ୍ଭର ବସତି ପୃଥିବୀର ଉର୍ବରତାବିହୀନ ଓ ଉପରିସ୍ଥ ଆକାଶର କାକର-ବିହୀନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ତୁମ୍ଭେ ଖଡ୍ଗଜୀବୀ ଓ ଆପଣା ଭ୍ରାତାର ଦାସ ହେବ, ମାତ୍ର ଯେତେବେଳେ ତୁମ୍ଭେ ବନ୍ଧନ ଛିଣ୍ଡାଇବ, ସେତେବେଳେ ଆପଣା କାନ୍ଧରୁ ତାହାର ଯୁଆଳି ପକାଇ ଦେବ।” ");
INSERT INTO ory_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ଏହି ପ୍ରକାରେ ଯାକୁବ ଆପଣା ପିତାଠାରୁ ଆଶୀର୍ବାଦ ପାଇବା ସକାଶୁ ଏଷୌ ତାହା ପ୍ରତି ଈର୍ଷାଭାବ ବହି ମନେ ମନେ ଭାଳିଲା, “ମୋହର ପିତାଙ୍କ ଶୋକକାଳ ପ୍ରାୟ ଉପସ୍ଥିତ, ତହିଁ ଉତ୍ତାରେ ମୁଁ ଆପଣା ଭ୍ରାତା ଯାକୁବକୁ ବଧ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ମାତ୍ର, ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଏଷୌର ଏରୂପ କଥା ରିବିକାର କର୍ଣ୍ଣଗୋଚର ହେଲା; ତହୁଁ ସେ ଲୋକ ପଠାଇ କନିଷ୍ଠ ପୁତ୍ର ଯାକୁବଙ୍କୁ ଡକାଇ କହିଲା, “ଦେଖ, ତୁମ୍ଭର ଭ୍ରାତା ଏଷୌ ତୁମ୍ଭକୁ ବଧ କରିବା ମାନସରେ ଆପଣାକୁ ପ୍ରବୋଧିତ କରୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ଏଥିପାଇଁ, ପୁତ୍ର, ମୋହର କଥା ଶୁଣ; ତୁମ୍ଭେ ହାରଣ ନଗରକୁ ପଳାଇ ମୋହର ଭ୍ରାତା ଲାବନ ନିକଟକୁ ଯାଅ। ");
INSERT INTO ory_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ପୁଣି, ଯେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭ ଭ୍ରାତାର ପ୍ରଚଣ୍ଡ କ୍ରୋଧ ନିବୃତ୍ତ ନ ହୁଏ, ସେପର୍ଯ୍ୟନ୍ତ କିଛି ଦିନ ସେଠାରେ ଥାଅ; ");
INSERT INTO ory_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭ ପ୍ରତି ତୁମ୍ଭ ଭ୍ରାତାର କ୍ରୋଧ ନିବୃତ୍ତ ହେଲେ ଓ ତୁମ୍ଭେ ତାହା ପ୍ରତି ଯାହା କରିଅଛ, ତାହା ସେ ପାସୋରିଗଲେ, ମୁଁ ଲୋକ ପଠାଇ ସେଠାରୁ ତୁମ୍ଭକୁ ଅଣାଇବି; ଗୋଟିଏ ଦିନରେ ତୁମ୍ଭ ଦୁଇ ଜଣଙ୍କୁ କାହିଁକି ହରାଇବି?” ");
INSERT INTO ory_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ଏଥିଉତ୍ତାରେ ରିବିକା ଇସ୍‌ହାକଙ୍କୁ କହିଲା, “ଏହି ହିତ୍ତୀୟ କନ୍ୟାମାନଙ୍କ ସକାଶୁ ମୁଁ ଆପଣା ପ୍ରାଣରେ ବିରକ୍ତ ହେଉଅଛି; ଯଦି ଯାକୁବ ଏମାନଙ୍କ ତୁଲ୍ୟ କୌଣସି ହିତ୍ତୀୟ କନ୍ୟାକୁ, ଅର୍ଥାତ୍‍, ଏହି ଦେଶର କନ୍ୟାମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି କନ୍ୟାକୁ ବିବାହ କରେ, ତେବେ ମୋହର ପ୍ରାଣଧାରଣରେ କି ସୁଖ?” ");
INSERT INTO ory_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍‌ହାକ ଯାକୁବଙ୍କୁ ଡକାଇ ଆଶୀର୍ବାଦ କଲେ ଏବଂ ଏହି ଆଜ୍ଞା ଦେଇ ତାହାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ କିଣାନ ଦେଶର କୌଣସି କନ୍ୟାକୁ ବିବାହ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ଉଠ, ପଦ୍ଦନ୍‍ ଅରାମରେ ଆପଣା ମାତାର ପିତା ବଥୂୟେଲର ଗୃହକୁ ଯାଇ ସେଠାରେ ଆପଣା ମାମୁଁ ଲାବନର କୌଣସି କନ୍ୟାକୁ ବିବାହ କର। ");
INSERT INTO ory_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ସର୍ବଶକ୍ତିମାନ ପରମେଶ୍ୱର ଆଶୀର୍ବାଦ କରି ତୁମ୍ଭକୁ ନାନା ଜନସମାଜ କରିବା ପାଇଁ ଫଳବନ୍ତ ଓ ବହୁ ପ୍ରଜାବନ୍ତ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ଆଉ ଅବ୍ରହାମଙ୍କ ପ୍ରତି ଦତ୍ତ ଆଶୀର୍ବାଦ ତୁମ୍ଭଠାରେ ଓ ତୁମ୍ଭ ବଂଶରେ ସଫଳ କରନ୍ତୁ; ତହିଁରେ ପରମେଶ୍ୱର ତୁମ୍ଭର ପ୍ରବାସ ସ୍ଥାନ ଏହି ଯେଉଁ ଦେଶ ଅବ୍ରହାମଙ୍କୁ ଦେଇଅଛନ୍ତି, ସେହି ଦେଶରେ ତୁମ୍ଭର ଅଧିକାର ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ଏଥିଉତ୍ତାରେ ଇସ୍‌ହାକ ଯାକୁବଙ୍କୁ ବିଦାୟ କରନ୍ତେ, ସେ ପଦ୍ଦନ୍‍ ଅରାମରେ ଅରାମୀୟ ବଥୂୟେଲର ପୁତ୍ର ଲାବନର, ଅର୍ଥାତ୍‍, ଯାକୁବ ଓ ଏଷୌର ମାତା ରିବିକାର ଭ୍ରାତା ନିକଟକୁ ଯାତ୍ରା କଲା। ");
INSERT INTO ory_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ଏଥିଉତ୍ତାରେ ଇସ୍‌ହାକ ଯାକୁବଙ୍କୁ ଆଶୀର୍ବାଦ କରି ବିବାହ ନିମନ୍ତେ ପଦ୍ଦନ୍‍ ଅରାମକୁ ବିଦାୟ କଲେ, ପୁଣି, ଯାକୁବଙ୍କୁ ଆଶୀର୍ବାଦ କରିବା ସମୟରେ ତାହାଙ୍କୁ ଆଜ୍ଞା ଦେଇ କହିଲେ, “ତୁମ୍ଭେ କିଣାନ ଦେଶର କୌଣସି କନ୍ୟା ବିବାହ କର ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ଆଉ ଯାକୁବ ଆପଣା ପିତାମାତାଙ୍କର ଆଜ୍ଞା ମାନି ପଦ୍ଦନ୍‍ ଅରାମକୁ ପ୍ରସ୍ଥାନ କରିଅଛି, ");
INSERT INTO ory_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ଏହା ଦେଖି ଏଷୌ ଆପଣା ପିତା ଇସ୍‌ହାକଙ୍କର କିଣାନ ଦେଶୀୟ କନ୍ୟାମାନଙ୍କ ପ୍ରତି ଅସନ୍ତୋଷ ଥିବାର ଜାଣି ");
INSERT INTO ory_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ଆପଣାର ଭାର୍ଯ୍ୟାଗଣ ଥିଲେ ହେଁ ଇଶ୍ମାୟେଲ ନିକଟକୁ ଯାଇ ଅବ୍ରହାମଙ୍କର ପୌତ୍ରୀ ଇଶ୍ମାୟେଲର ପୁତ୍ରୀ ନବାୟୋତ୍‍ର ଭଗିନୀ ମହଲତ୍‍ ନାମ୍ନୀ କନ୍ୟାକୁ ବିବାହ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ଏଥିଉତ୍ତାରେ ଯାକୁବ ବେର୍‍ଶେବାରୁ ବାହାରି ହାରଣ ଆଡ଼କୁ ଯାତ୍ରା କଲା। ");
INSERT INTO ory_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ପୁଣି, ସୂର୍ଯ୍ୟାସ୍ତ ହେବାରୁ ସେ କୌଣସି ଏକ ସ୍ଥାନରେ ରାତ୍ରି କ୍ଷେପଣ କଲା; ପୁଣି, ସେ ସେହି ସ୍ଥାନର ଖଣ୍ଡିଏ ପ୍ରସ୍ତର ନେଇ ମସ୍ତକ ତଳେ ଦେଇ ନିଦ୍ରା ଯିବା ନିମନ୍ତେ ସେହି ସ୍ଥାନରେ ଶୟନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ତହିଁରେ ସେ ସ୍ୱପ୍ନରେ ପୃଥିବୀରେ ସ୍ଥାପିତ ଗୋଟିଏ ସୋପାନ ଦେଖିଲା, ତହିଁର ମସ୍ତକ ଗଗନସ୍ପର୍ଶୀ; ପୁଣି, ଦେଖ, ତାହା ଦେଇ ପରମେଶ୍ୱରଙ୍କ ଦୂତଗଣ ଆରୋହଣ ଓ ଅବରୋହଣ କରୁଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ଆଉ ଦେଖ, ସଦାପ୍ରଭୁ ତହିଁ ଉପରେ ଠିଆ ହୋଇ କହିଲେ, “ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭ ପୂର୍ବପୁରୁଷ ଅବ୍ରହାମର ପରମେଶ୍ୱର ଓ ଇସ୍‌ହାକର ପରମେଶ୍ୱର ଅଟୁ; ତୁମ୍ଭେ ଏହି ଯେଉଁ ଦେଶରେ ଶୟନ କରୁଅଛ, ତାହା ଆମ୍ଭେ ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭ ବଂଶକୁ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ତୁମ୍ଭର ବଂଶ ପୃଥିବୀର ଧୂଳି ପରି (ଅସଂଖ୍ୟ) ହେବେ, ପୁଣି, ତୁମ୍ଭେ ପୂର୍ବ ଓ ପଶ୍ଚିମ ଓ ଉତ୍ତର ଓ ଦକ୍ଷିଣ, ଚାରିଆଡ଼େ ବୃଦ୍ଧି ପାଇବ; ପୁଣି, ତୁମ୍ଭଠାରୁ ଓ ତୁମ୍ଭ ବଂଶଠାରୁ ପୃଥିବୀସ୍ଥ ଯାବତୀୟ ବଂଶ ଆଶୀର୍ବାଦ ପାଇବେ। ");
INSERT INTO ory_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ପୁଣି, ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭର ସହାୟ ଅଟୁ, ଆଉ ତୁମ୍ଭେ ଯେଉଁ ଯେଉଁ ସ୍ଥାନକୁ ଯିବ, ସେହି ସେହି ସ୍ଥାନରେ ଆମ୍ଭେ ତୁମ୍ଭକୁ ରକ୍ଷା କରିବା ଓ ପୁନର୍ବାର ତୁମ୍ଭକୁ ଏ ଦେଶକୁ ଆଣିବା; କାରଣ ଆମ୍ଭେ ଯାହା ତୁମ୍ଭକୁ କହିଅଛୁ, ତାହା ସଫଳ ନ କରିବା ପର୍ଯ୍ୟନ୍ତ ଆମ୍ଭେ ତୁମ୍ଭକୁ ପରିତ୍ୟାଗ କରିବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ଏଥିଉତ୍ତାରେ ନିଦ୍ରା ଭଙ୍ଗ ହୁଅନ୍ତେ, ଯାକୁବ ଜାଗ୍ରତ ହୋଇ କହିଲା, “ଅବଶ୍ୟ ଏହି ସ୍ଥାନରେ ସଦାପ୍ରଭୁ ଅଛନ୍ତି; ମାତ୍ର ମୁଁ ତାହା ଜାଣିଲି ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ପୁଣି, ସେ ଭୀତ ହୋଇ ଆହୁରି କହିଲା, “ଏ କିପରି ଭୟାନକ ସ୍ଥାନ! ଏ ତ ନିତାନ୍ତ ପରମେଶ୍ୱରଙ୍କର ଗୃହ, ଏହି ତ ସ୍ୱର୍ଗର ଦ୍ୱାର।” ");
INSERT INTO ory_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ଏଥିଉତ୍ତାରେ ଯାକୁବ ପ୍ରଭାତରେ ଉଠି ଯେଉଁ ପ୍ରସ୍ତର ମସ୍ତକ ତଳେ ଦେଇଥିଲା, ତାହା ନେଇ ସ୍ତମ୍ଭ ରୂପେ ସ୍ଥାପନ କରି ତହିଁ ଉପରେ ତୈଳ ଢାଳିଲା। ");
INSERT INTO ory_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ପୁଣି, ସେହି ସ୍ଥାନର ନାମ ବେଥେଲ୍‍ ରଖିଲା; ମାତ୍ର ପୂର୍ବେ ସେହି ନଗରର ନାମ ଲୂସ୍‍ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ଆଉ ଯାକୁବ ମାନତ କରି କହିଲା, “ଯଦି ପରମେଶ୍ୱର ମୋହର ସହାୟ ହେବେ ଓ ମୋହର ଏହି ଯିବା ପଥରେ ମୋତେ ରକ୍ଷା କରିବେ, ପୁଣି, ଆହାର ନିମନ୍ତେ ଅନ୍ନ ଓ ପରିଧାନ ନିମନ୍ତେ ବସ୍ତ୍ର ଦେବେ, ");
INSERT INTO ory_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ଆଉ ଯଦି ମୁଁ କୁଶଳରେ ପିତୃଗୃହକୁ ପୁନର୍ବାର ଆସିବି, ତେବେ ସଦାପ୍ରଭୁ ମୋହର ପରମେଶ୍ୱର ହେବେ, ");
INSERT INTO ory_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ପୁଣି, ମୁଁ ଏହି ଯେଉଁ ପ୍ରସ୍ତର ସ୍ତମ୍ଭ ରୂପେ ସ୍ଥାପନ କରିଅଛି, ତାହା ପରମେଶ୍ୱରଙ୍କ ଗୃହ ହେବ, ଆଉ ତୁମ୍ଭେ ମୋତେ ଯାହାସବୁ ଦେବ, ତହିଁର ଦଶମାଂଶ ମୁଁ ତୁମ୍ଭଙ୍କୁ ଅବଶ୍ୟ ଦେବି।” ");
INSERT INTO ory_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଯାତ୍ରାରେ ଅଗ୍ରସର ହୋଇ ପୂର୍ବଦିଗସ୍ଥ ଲୋକମାନଙ୍କ ଦେଶରେ ଉପସ୍ଥିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ତହୁଁ ସେ ଅନାଇଲା, ଆଉ ଦେଖ, କ୍ଷେତ୍ର ମଧ୍ୟରେ ଗୋଟିଏ କୂପ, ପୁଣି, ଦେଖ, ତହିଁ ନିକଟରେ ତିନି ପଲ ମେଷ ଶୋଇଛନ୍ତି; କାରଣ ଲୋକମାନେ ମେଷପଲକୁ ସେହି କୂପରୁ ଜଳ ପାନ କରାନ୍ତି; ସେହି କୂପ ମୁଖରେ ଖଣ୍ଡିଏ ବଡ଼ ପଥର ଘୋଡ଼ା ହୋଇଥାଏ। ");
INSERT INTO ory_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ସେହି କୂପ ନିକଟରେ ସବୁ ପଲ ଏକତ୍ର ହୁଅନ୍ତି; ଆଉ, ଲୋକମାନେ ତାʼ ମୁଖରୁ ପଥର ଘୁଞ୍ଚାଇ ମେଷଗଣକୁ ଜଳ ପାନ କରାନ୍ତି, ପୁନର୍ବାର କୂପ ମୁଖରେ ଯଥାସ୍ଥାନରେ ପଥରଟା ଢାଙ୍କି ଦିଅନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ଯାକୁବ ସେମାନଙ୍କୁ ପଚାରିଲା, “ହେ ଭାଇମାନେ, ତୁମ୍ଭେମାନେ କେଉଁ ସ୍ଥାନର ଲୋକ?” ସେମାନେ କହିଲେ, “ଆମ୍ଭେମାନେ ହାରଣ ନଗରର ଲୋକ।” ");
INSERT INTO ory_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ତେବେ ଯାକୁବ ପଚାରିଲା, “ତୁମ୍ଭେମାନେ ନାହୋରର ପୌତ୍ର ଲାବନଙ୍କୁ ଚିହ୍ନ କି?” ସେମାନେ କହିଲେ, “ଆମ୍ଭେମାନେ ତାକୁ ଚିହ୍ନୁ।” ");
INSERT INTO ory_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ଯାକୁବ ପଚାରିଲା, “ସେ କୁଶଳରେ ଅଛନ୍ତି ତ?” ସେମାନେ କହିଲେ, “କୁଶଳରେ ଅଛି; ଏହି ଦେଖ, ତାହାର କନ୍ୟା ରାହେଲ ମେଷପଲ ଘେନି ଆସୁଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ସେତେବେଳେ ଯାକୁବ କହିଲା, “ଦେଖ, ଏବେ ବହୁତ ବେଳ ଅଛି; ମେଷପଲ ଏକତ୍ର କରିବାର ସମୟ ହୋଇ ନାହିଁ; ତୁମ୍ଭେମାନେ ମେଷଗଣକୁ ଜଳ ପାନ କରାଇ ପୁନର୍ବାର ଚରାଇବାକୁ ଘେନିଯାଅ।” ");
INSERT INTO ory_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ମାତ୍ର ସେମାନେ କହିଲେ, “ତାହା ଆମ୍ଭେମାନେ କରି ନ ପାରୁ; ସମସ୍ତ ପଲ ଏକତ୍ର ହେବାର ଅପେକ୍ଷା କରିବାକୁ ହୁଏ; ତହିଁ ଉତ୍ତାରେ କୂପ ମୁଖରୁ ପ୍ରସ୍ତର ଘୁଞ୍ଚାଯାଏ, ତାହାହେଲେ, ଆମ୍ଭେମାନେ ମେଷଗଣକୁ ଜଳ ପାନ କରାଉ।” ");
INSERT INTO ory_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ଯାକୁବ ସେମାନଙ୍କ ସହିତ ଏପ୍ରକାର କଥାବାର୍ତ୍ତା କରୁଅଛି, ଏଥିମଧ୍ୟରେ ରାହେଲ ଆପଣା ପିତାଙ୍କର ମେଷପଲ ଘେନି ଉପସ୍ଥିତ ହେଲା, କାରଣ ସେ ମେଷପାଳିକା ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ସେତେବେଳେ ଯାକୁବ ଆପଣା ମାମୁଁ ଲାବନର କନ୍ୟା ରାହେଲକୁ ଓ ମାମୁଁର ମେଷପଲକୁ ଦେଖି ନିକଟକୁ ଯାଇ କୂପ ମୁଖରୁ ପ୍ରସ୍ତର ଘୁଞ୍ଚାଇ ମାମୁଁ ଲାବନର ପଲକୁ ଜଳ ପାନ କରାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ଏଥିଉତ୍ତାରେ ଯାକୁବ ରାହେଲକୁ ଚୁମ୍ବନ କରି ଉଚ୍ଚସ୍ୱରରେ କ୍ରନ୍ଦନ କରିବାକୁ ଲାଗିଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ପୁଣି, ଆପେ ଯେ ତାହାର ପିତାଙ୍କର କୁଟୁମ୍ବ ଓ ରିବିକାର ପୁତ୍ର, ଏହି ପରିଚୟ ଦେଲା; ତହୁଁ ରାହେଲ ଦୌଡ଼ିଯାଇ ଆପଣା ପିତାକୁ ସମାଚାର ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ତହିଁରେ ଲାବନ ଆପଣା ଭଣଜା ଯାକୁବର ସମାଚାର ପାଇ ତାହା ସଙ୍ଗେ ସାକ୍ଷାତ କରିବାକୁ ଦୌଡ଼ିଗଲା, ପୁଣି, ତାହାକୁ ଆଲିଙ୍ଗନ ଓ ଚୁମ୍ବନ କରି ଆପଣା ଗୃହକୁ ନେଇଗଲା; ତହୁଁ ସେ ସମସ୍ତ ବିବରଣ ଲାବନକୁ ଜଣାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ତହିଁରେ ଲାବନ କହିଲା, “ତୁମ୍ଭେ ନିତାନ୍ତ ଆମ୍ଭର ଅସ୍ଥି ଓ ମାଂସ ସ୍ୱରୂପ।” ତେଣୁ ଯାକୁବ ତାହାର ଗୃହରେ ମାସେ କାଳ ବାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ଏଥିଉତ୍ତାରେ ଲାବନ ଯାକୁବଙ୍କୁ କହିଲା, “ତୁମ୍ଭେ ମୋହର କୁଟୁମ୍ବ ବୋଲି କି ବିନା ବେତନରେ ମୋହର ଦାସ୍ୟକର୍ମ କରିବ? ଏଣୁ କି ବେତନ ନେବ? ତାହା କୁହ।” ");
INSERT INTO ory_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ସେହି ଲାବନର ଦୁଇ କନ୍ୟା ଥିଲେ; ଜ୍ୟେଷ୍ଠାର ନାମ ଲେୟା, କନିଷ୍ଠାର ନାମ ରାହେଲ। ");
INSERT INTO ory_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ଲେୟା କ୍ଷୀଣାକ୍ଷୀ, ମାତ୍ର ରାହେଲ ସୁନ୍ଦରୀ ଓ ରୂପବତୀ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ଆଉ ଯାକୁବ ରାହେଲକୁ ପ୍ରେମ କଲା; ଏଥିନିମିତ୍ତ ସେ ଉତ୍ତର କଲା, “ତୁମ୍ଭର କନିଷ୍ଠା କନ୍ୟା ରାହେଲ ନିମନ୍ତେ ମୁଁ ସାତ ବର୍ଷ ତୁମ୍ଭର ଦାସ୍ୟକର୍ମ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ତହିଁରେ ଲାବନ କହିଲା, “ଅନ୍ୟ ପୁରୁଷକୁ ଦାନ କରିବା ଅପେକ୍ଷା ତୁମ୍ଭକୁ ଦାନ କରିବା ଅଧିକ ଉତ୍ତମ; ମୋʼ ନିକଟରେ ଥାଅ।” ");
INSERT INTO ory_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ଏହିରୂପେ ଯାକୁବ ରାହେଲ ନିମନ୍ତେ ସାତ ବର୍ଷ ଦାସ୍ୟକର୍ମ କଲା; ପୁଣି, ରାହେଲ ପ୍ରତି ତାହାର ଏରୂପ ପ୍ରେମ ଥିଲା, ଯେ ସେହି ସାତ ବର୍ଷ ତାହା ପ୍ରତି କେବଳ ଅଳ୍ପ ଦିନ ପରି ବୋଧ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଲାବନକୁ କହିଲା, “ମୋହର ନିୟମିତ କାଳ ସମ୍ପୂର୍ଣ୍ଣ ହେଲା, ଏବେ ମୋʼ ଭାର୍ଯ୍ୟା ମୋତେ ଦିଅ, ମୁଁ ତାହାର ସହବାସ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ତହିଁରେ ଲାବନ ସେହି ସ୍ଥାନର ସମସ୍ତ ଲୋକଙ୍କୁ ଏକତ୍ର କରି ଭୋଜ ପ୍ରସ୍ତୁତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ସନ୍ଧ୍ୟାକାଳରେ ସେ ଆପଣା କନ୍ୟା ଲେୟାକୁ ଘେନି ଯାକୁବ ନିକଟକୁ ଆଣିଲା; ପୁଣି, ସେ ତାହାର ସହବାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ଆଉ ଲାବନ ଆପଣା କନ୍ୟା ଲେୟାର ଦାସୀ ହେବା ନିମନ୍ତେ ସିଳ୍ପା ନାମ୍ନୀ ଆପଣା ଦାସୀକୁ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ମାତ୍ର ପ୍ରଭାତ ହୁଅନ୍ତେ, ଦେଖ, ସେ ତ ଲେୟା! ତହୁଁ ଯାକୁବ ଲାବନଙ୍କୁ କହିଲା, “ତୁମ୍ଭେ ମୋʼ ସହିତ ଏ କି ବ୍ୟବହାର କରିଅଛ? ମୁଁ କʼଣ ରାହେଲ ନିମନ୍ତେ ତୁମ୍ଭର ଦାସ୍ୟକର୍ମ କରି ନାହିଁ; ତେବେ କାହିଁକି ମୋତେ ପ୍ରବଞ୍ଚନା କରିଅଛ?” ");
INSERT INTO ory_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ତହିଁରେ ଲାବନ କହିଲା, “ଜ୍ୟେଷ୍ଠା ଥାଉ ଥାଉ କନିଷ୍ଠାକୁ ଦାନ କରିବା ଆମ୍ଭମାନଙ୍କ ଦେଶାଚାର ନୁହେଁ। ");
INSERT INTO ory_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ଏହାର ସପ୍ତାହ ପୂର୍ଣ୍ଣ କର, ତହିଁ ଉତ୍ତାରେ ଯଦି ଆଉ ସାତ ବର୍ଷ ମୋହର ଦାସ୍ୟକର୍ମ କରିବ, ତେବେ ଅନ୍ୟ କନ୍ୟାକୁ ହିଁ ତୁମ୍ଭକୁ ଦାନ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ତହିଁରେ ଯାକୁବ ସେହି ପ୍ରକାରେ ତାହାର ସପ୍ତାହ ପୂର୍ଣ୍ଣ କଲା; ତହୁଁ ଲାବନ ତାହା ସହିତ ଆପଣା କନ୍ୟା ରାହେଲକୁ ବିବାହ କରିଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ପୁଣି, ରାହେଲର ଦାସୀ ହେବା ନିମନ୍ତେ ସେ ଆପଣାର ବିଲ୍‌ହା ନାମ୍ନୀ ଦାସୀକୁ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ତହୁଁ ସେ ରାହେଲର ମଧ୍ୟ ସହବାସ କଲା ଓ ଲେୟାଠାରୁ ରାହେଲକୁ ଅଧିକ ପ୍ରେମ କଲା; ପୁଣି, ଆଉ ସାତ ବର୍ଷ ଲାବନର ଦାସ୍ୟକର୍ମ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଲେୟାକୁ ଅପମାନିତା ଦେଖି ତାହାକୁ ଗର୍ଭଧାରଣର ଶକ୍ତି ଦେଲେ; ମାତ୍ର ରାହେଲ ବନ୍ଧ୍ୟା ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ଏଥିପାଇଁ ଲେୟା ଗର୍ଭବତୀ ହୋଇ ପୁତ୍ର ପ୍ରସବ କରନ୍ତେ, ତାହାର ନାମ ରୁବେନ୍‍ (ପୁତ୍ରକୁ ଦେଖ) ଦେଲା; ଯେହେତୁ ସେ କହିଲା, “ସଦାପ୍ରଭୁ ମୋହର ଦୁଃଖ ଦେଖିଅଛନ୍ତି; ଏବେ ମୋʼ ସ୍ୱାମୀ ମୋତେ ଭଲ ପାଇବେ।” ");
INSERT INTO ory_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ଆଉ, ସେ ପୁନର୍ବାର ଗର୍ଭବତୀ ହୋଇ ପୁତ୍ର ପ୍ରସବ କରି କହିଲା, “ମୁଁ ଅପମାନିତା ଅଟେ, ଏହା ସଦାପ୍ରଭୁ ଶ୍ରବଣ କରି ମୋତେ ଏହି ପୁତ୍ର ଦେଲେ,” ଏଣୁ ସେ ତାହାର ନାମ ଶିମୀୟୋନ (ଶ୍ରବଣ) ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ପୁନର୍ବାର ସେ ଗର୍ଭବତୀ ହୋଇ ପୁତ୍ର ପ୍ରସବ କରି କହିଲା, “ଏଥର ସ୍ୱାମୀ ମୋʼ ଠାରେ ଆସକ୍ତ ହେବେ, ଯେହେତୁ ମୁଁ ତାଙ୍କର ତିନି ପୁତ୍ର ପ୍ରସବ କରିଅଛି,” ଏହେତୁ ତାହାର ନାମ ଲେବୀ (ଆସକ୍ତ) ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ଏଥିଉତ୍ତାରେ ପୁନର୍ବାର ତାହାର ଗର୍ଭ ହୁଅନ୍ତେ, ସେ ପୁତ୍ର ପ୍ରସବ କରି କହିଲା, “ଏବେ ମୁଁ ସଦାପ୍ରଭୁଙ୍କ ସ୍ତବଗାନ କରିବି,” ତେଣୁ ସେ ତାହାର ନାମ ଯିହୁଦା (ସଦାପ୍ରଭୁଙ୍କ ସ୍ତବ) ଦେଲା। ଏଥିଉତ୍ତାରେ ତାହାର ଗର୍ଭନିବୃତ୍ତି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ଏଥିଉତ୍ତାରେ ଆପଣାଠାରୁ ଯାକୁବର ପୁତ୍ର ଜନ୍ମ ହେଲା ନାହିଁ, ଏହା ଦେଖି ରାହେଲ ଆପଣା ଭଗିନୀ ପ୍ରତି ଈର୍ଷା କରି ଯାକୁବକୁ କହିଲା, “ମୋତେ ସନ୍ତାନ ଦିଅ, ନୋହିଲେ ମୁଁ ମରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ତହିଁରେ ରାହେଲ ପ୍ରତି ଯାକୁବର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା; ପୁଣି, ସେ କହିଲା, “ମୁଁ କʼଣ ପରମେଶ୍ୱରଙ୍କର ପ୍ରତିନିଧି? ସେ ସିନା ତୁମ୍ଭକୁ ଗର୍ଭଫଳ ଦେଇ ନାହାନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ସେତେବେଳେ ରାହେଲ କହିଲା, “ଏହି ଦେଖ, ମୋହର ଦାସୀ ବିଲ୍‌ହା ଅଛି, ତାହାର ସହବାସ କର; ସେ ପୁତ୍ର ପ୍ରସବ କରି ମୋʼ କୋଳରେ ଦେଲେ ତାହା ଯୋଗୁଁ ମୁଁ ମଧ୍ୟ ପୁତ୍ରବତୀ ହେବି।” ");
INSERT INTO ory_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ପୁଣି, ସେ ଆପଣା ଦାସୀ ବିଲ୍‌ହାକୁ ତାହା ସହିତ ବିବାହ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ତହୁଁ ଯାକୁବ ତାହାର ସହବାସ କରନ୍ତେ, ବିଲ୍‌ହା ଗର୍ଭବତୀ ହୋଇ ଯାକୁବର ଗୋଟିଏ ପୁତ୍ର ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ସେତେବେଳେ ରାହେଲ କହିଲା, “ପରମେଶ୍ୱର ମୋହର ବିଚାର କଲେ, ମଧ୍ୟ ମୋହର କାକୂକ୍ତି ଶୁଣି ମୋତେ ପୁତ୍ର ଦେଲେ,” ଏଥିପାଇଁ ସେ ତାହାର ନାମ ଦାନ୍ (ବିଚାର) ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ଏଥିଉତ୍ତାରେ ରାହେଲର ଦାସୀ ବିଲ୍‌ହା ପୁନର୍ବାର ଗର୍ଭଧାରଣ କରି ଯାକୁବ ପାଇଁ ଦ୍ୱିତୀୟ ପୁତ୍ର ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ସେତେବେଳେ ରାହେଲ କହିଲା, “ମୁଁ ଭଗିନୀ ସହିତ ପରମେଶ୍ୱର ସମ୍ବନ୍ଧୀୟ ମଲ୍ଲଯୁଦ୍ଧ କରି ଜୟ କଲି,” ଏଥିପାଇଁ ସେ ତାହାର ନାମ ନପ୍ତାଲି (ମଲ୍ଲଯୁଦ୍ଧ) ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ଏଥିଉତ୍ତାରେ ଲେୟା ଆପଣାର ଗର୍ଭନିବୃତ୍ତି ବୁଝି ଆପଣାର ସିଳ୍ପା ନାମ୍ନୀ ଦାସୀକୁ ଘେନି ଯାକୁବ ସହିତ ବିବାହ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ତହିଁରେ ଲେୟାର ଦାସୀ ସିଳ୍ପାଠାରୁ ଯାକୁବର ଗୋଟିଏ ପୁତ୍ର ଜାତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ତହୁଁ ଲେୟା କହିଲା, “ଏ କି ସୌଭାଗ୍ୟ!” ଏଥିପାଇଁ ତାହାର ନାମ ଗାଦ୍‍ (ସୌଭାଗ୍ୟ) ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ଏଥିଉତ୍ତାରେ ଲେୟାର ଦାସୀ ସିଳ୍ପା ଯାକୁବ ପାଇଁ ଦ୍ୱିତୀୟ ପୁତ୍ର ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ତହିଁରେ ଲେୟା କହିଲା, “ମୋହର କି ଆନନ୍ଦ! ଯୁବତୀଗଣ ମୋତେ ଆନନ୍ଦିନୀ ବୋଲିବେ,” ଏଥିପାଇଁ ସେ ତାହାର ନାମ ଆଶେର (ଆନନ୍ଦ) ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ଏଥିଉତ୍ତାରେ ଗହମ କଟା ସମୟରେ ରୁବେନ୍‍ ବାହାରେ ଯାଇ କ୍ଷେତରୁ ଦୂଦାଫଳ ପାଇ ଆଣି ଆପଣା ମାତା ଲେୟାକୁ ଦେଲା। ତହୁଁ ରାହେଲ ଲେୟାକୁ କହିଲା, “ତୁମ୍ଭ ପୁତ୍ର ଆଣିଥିବା ଦୂଦାଫଳ କିଛି ମୋତେ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ତହିଁରେ ସେ କହିଲା, “ତୁମ୍ଭେ ମୋʼ ସ୍ୱାମୀକୁ ହରଣ କରିଅଛ, ଏ କି ଅଳ୍ପ ବିଷୟ? ତୁମ୍ଭେ ମୋʼ ପୁତ୍ରର ଦୂଦାଫଳ ମଧ୍ୟ କି ହରଣ କରିବ?” ତେବେ ରାହେଲ କହିଲା, “ତୁମ୍ଭର ପୁତ୍ରର ଦୂଦାଫଳ ପରିବର୍ତ୍ତରେ ସେ ଆଜି ରାତ୍ର ତୁମ୍ଭ ସଙ୍ଗେ ଶୟନ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ଏଥିଉତ୍ତାରେ ସନ୍ଧ୍ୟା ବେଳେ କ୍ଷେତ୍ରରୁ ଯାକୁବର ଆଗମନ ସମୟରେ ଲେୟା ତାହା ସହିତ ସାକ୍ଷାତ କରିବା ନିମିତ୍ତ ବାହାରକୁ ଯାଇ କହିଲା, “ତୁମ୍ଭକୁ ମୋʼ କତିକି ଆସିବାକୁ ହେବ; କାରଣ ମୁଁ ଆପଣା ପୁତ୍ରର ଦୂଦାଫଳ ଦେଇ ତୁମ୍ଭକୁ ଭଡ଼ା ନେଲି।” ଏଣୁ ସେ ସେହି ରାତ୍ରି ତାହା ସହିତ କ୍ଷେପଣ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ତହିଁରେ ପରମେଶ୍ୱର ଲେୟାର ପ୍ରାର୍ଥନା ଶୁଣନ୍ତେ, ସେ ଗର୍ଭବତୀ ହୋଇ ଯାକୁବର ପଞ୍ଚମ ପୁତ୍ର ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ତେବେ ଲେୟା କହିଲା, “ମୁଁ ସ୍ୱାମୀକୁ ଆପଣା ଦାସୀ ଦେଇଥିଲି, ପରମେଶ୍ୱର ତାହାର ବେତନ ମୋତେ ଦେଇଅଛନ୍ତି,” ଏହେତୁ ସେ ତାହାର ନାମ ଇଷାଖର ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ଏଥିଉତ୍ତାରେ ଲେୟା ପୁନର୍ବାର ଗର୍ଭଧାରଣ କରି ଯାକୁବର ଷଷ୍ଠ ପୁତ୍ର ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ତହୁଁ ଲେୟା କହିଲା, “ପରମେଶ୍ୱର ମୋତେ ଉତ୍ତମ ଯୌତୁକ ଦେଲେ; ଏବେ ମୋʼ ସ୍ୱାମୀ ମୋʼ ସଙ୍ଗେ ବାସ କରିବେ, ଯେହେତୁ ମୁଁ ତାଙ୍କର ଛଅ ପୁତ୍ର ଜନ୍ମ କରିଅଛି,” ଏହେତୁ ସେ ତାହାର ନାମ ସବୂଲୂନ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ଏଉତ୍ତାରେ ସେ ଏକ କନ୍ୟା ପ୍ରସବ କରନ୍ତେ, ତାହାର ନାମ ଦୀଣା ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ରାହେଲକୁ ସ୍ମରଣ କଲେ ଓ ପରମେଶ୍ୱର ତାହାର ପ୍ରାର୍ଥନା ଶୁଣି ତାହାକୁ ଗର୍ଭଧାରଣର ଶକ୍ତି ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ତହୁଁ ସେ ଗର୍ଭବତୀ ହୋଇ ପୁତ୍ର ପ୍ରସବ କରି କହିଲା, “ପରମେଶ୍ୱର ଏବେ ମୋହର ଅପମାନ ଦୂର କଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ଏଣୁ ସେ ତାହାର ନାମ ଯୋଷେଫ ଦେଇ, କହିଲା, “ସଦାପ୍ରଭୁ ମୋତେ ଆଉ ଏକ ପୁତ୍ର ଦିଅନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ଆଉ ରାହେଲଠାରୁ ଯୋଷେଫ ଜନ୍ମ ହେଲା ଉତ୍ତାରେ ଯାକୁବ ଲାବନକୁ କହିଲା, “ମୋତେ ବିଦାୟ କର, ମୁଁ ସ୍ୱ ସ୍ଥାନକୁ ଓ ନିଜ ଦେଶକୁ ଯିବି। ");
INSERT INTO ory_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ମୁଁ ଯେଉଁମାନଙ୍କ ନିମନ୍ତେ ତୁମ୍ଭର ଦାସ୍ୟକର୍ମ କରିଅଛି, ମୋହର ସେହି ଭାର୍ଯ୍ୟାମାନଙ୍କୁ ଓ ପୁତ୍ରଗଣକୁ ନେଇ ଯିବାକୁ ଦିଅ; ଯେହେତୁ ଯେଉଁ ପ୍ରକାରେ ତୁମ୍ଭର ଦାସ୍ୟକର୍ମ କରିଅଛି, ତାହା ତୁମ୍ଭେ ଜ୍ଞାତ ଅଟ।” ");
INSERT INTO ory_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ସେତେବେଳେ ଲାବନ ତାହାକୁ କହିଲା, “ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ମୋʼ ପ୍ରତି ଅନୁଗ୍ରହ କର, କାରଣ ତୁମ୍ଭ ସକାଶୁ ସଦାପ୍ରଭୁ ମୋତେ ଆଶୀର୍ବାଦ କରିଅଛନ୍ତି, ଏହା ମୁଁ ଗଣକତା ଦ୍ୱାରା ଜାଣିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ଏହେତୁ “ତୁମ୍ଭେ ଆପେ ନିଜ ବେତନ ସ୍ଥିର କର, ମୁଁ ତାହା ତୁମ୍ଭକୁ ଦେବି।” ");
INSERT INTO ory_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ତହୁଁ ଯାକୁବ ତାହାଙ୍କୁ କହିଲା, “ମୁଁ ତୁମ୍ଭର ଯେଉଁ ପ୍ରକାର ଦାସ୍ୟକର୍ମ କରିଅଛି ଓ ମୋʼ ନିକଟରେ ତୁମ୍ଭର ପଶୁଗଣ ଯେପରି ଅଛନ୍ତି, ତାହା ତୁମ୍ଭକୁ ଜଣାଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","କାରଣ, ମୋହର ଆସିବା ପୂର୍ବରେ ତୁମ୍ଭର ଅଳ୍ପ ସମ୍ପତ୍ତି ଥିଲା, ମାତ୍ର ଏବେ ବୃଦ୍ଧି ପାଇ ପ୍ରଚୁର ହୋଇଅଛି; ପୁଣି, ମୁଁ ଯେକୌଣସି ଜାଗାକୁ ତୁମ୍ଭର ମେଷପଲକୁ ଚରାଇବାକୁ ନେଲି ସଦାପ୍ରଭୁ ତୁମ୍ଭର ମଙ୍ଗଳ କରିଅଛନ୍ତି; ମାତ୍ର ମୁଁ ଆପଣା ପରିବାର ନିମନ୍ତେ କେବେ ସଞ୍ଚୟ କରିବି?” ");
INSERT INTO ory_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ତହିଁରେ ଲାବନ କହିଲା, “ମୁଁ ତୁମ୍ଭକୁ କଅଣ ଦେବି?” ଯାକୁବ କହିଲା, “ତୁମ୍ଭକୁ କିଛି ଦେବାକୁ ପଡ଼ିବ ନାହିଁ; ଯଦି ତୁମ୍ଭେ ମୋʼ ପାଇଁ ଗୋଟିଏ କର୍ମ କରିବ, ତେବେ ମୁଁ ତୁମ୍ଭର ପଶୁମାନଙ୍କୁ ପୁନର୍ବାର ଚରାଇ ପ୍ରତିପାଳନ କରିବି। ");
INSERT INTO ory_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ଆଜି ମୁଁ ତୁମ୍ଭର ସକଳ ପଲ ମଧ୍ୟଦେଇ ଯାଇ ମେଷଗଣ ମଧ୍ୟରୁ ଚିତ୍ରବିଚିତ୍ର ଓ ବିନ୍ଦୁଚିହ୍ନିତ ଓ କଳାବର୍ଣ୍ଣର ମେଷମାନଙ୍କୁ, ପୁଣି, ଛାଗଳଗଣ ମଧ୍ୟରୁ ବିନ୍ଦୁଚିହ୍ନିତ ଓ ଚିତ୍ରବିଚିତ୍ର ଛାଗଳମାନଙ୍କୁ ପୃଥକ କରିବି; ସେହି ସବୁ ମୋହର ବେତନ ସ୍ୱରୂପ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ଏଥିଉତ୍ତାରେ ଯେତେବେଳେ ତୁମ୍ଭ ସାକ୍ଷାତରେ ମୋହର ବେତନ ବିଷୟ ଉପସ୍ଥିତ ହେବ, ସେତେବେଳେ ମୋହର ଧାର୍ମିକତା ମୋʼ ବିଷୟରେ ସାକ୍ଷ୍ୟ ଦେବ, ଅର୍ଥାତ୍‍, ଛାଗଳମାନଙ୍କ ମଧ୍ୟରେ ଚିତ୍ରବିଚିତ୍ର ଓ ବିନ୍ଦୁଚିହ୍ନିତ ଛାଗଳ ଭିନ୍ନ ଓ ମେଷଗଣ ମଧ୍ୟରେ କଳାବର୍ଣ୍ଣର ମେଷ ଭିନ୍ନ ଯେତେ ଥିବେ, ତାହା ମୋହର ଚୋରି ରୂପେ ଗଣ୍ୟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ତହୁଁ ଲାବନ କହିଲା, “ଭଲ, ତୁମ୍ଭ କଥାନୁସାରେ ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ଏଥିଉତ୍ତାରେ ସେ ସେହି ଦିନ ରେଖାଙ୍କିତ ଓ ବିନ୍ଦୁଚିହ୍ନିତ ଛାଗସକଳ ଓ ଚିତ୍ରବିଚିତ୍ର ଓ ବିନ୍ଦୁଚିହ୍ନିତ ମଧ୍ୟ କିଞ୍ଚିତ ଶୁକ୍ଳବର୍ଣ୍ଣ ଛାଗୀସକଳ, ପୁଣି, କଳାବର୍ଣ୍ଣର ମେଷସକଳ ପୃଥକ ପୃଥକ କରି ଆପଣା ପୁତ୍ରମାନଙ୍କ ହସ୍ତରେ ସମର୍ପଣ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ଆଉ ସେ ଆପଣାର ଓ ଯାକୁବର ମଧ୍ୟରେ ତିନି ଦିନର ପଥରୁ ଦୂରରେ ରଖିଲା; ପୁଣି, ଯାକୁବ ଲାବନର ଅବଶିଷ୍ଟ ପଶୁପଲ ଚରାଇବାକୁ ଲାଗିଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ଆଉ ଯାକୁବ ଲିବ୍‍ନୀ ଓ ଲୂସ୍‍ ଓ ଅର୍ମୋନ୍‍ ବୃକ୍ଷର ନୂତନ ଶାଖା କାଟି ତହିଁରୁ ବଳ୍‍କଳ କାଢ଼ି କାଷ୍ଠର ଶୁକ୍ଳରେଖା ବାହାର କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ଏଥିଉତ୍ତାରେ ଯେଉଁ ସ୍ଥାନକୁ ପଶୁଗଣ ଜଳ ପାନ କରିବା ନିମନ୍ତେ ଆସନ୍ତି, ସେହି ସ୍ଥାନରେ ସେମାନଙ୍କ ସମ୍ମୁଖସ୍ଥ ଜଳକୁଣ୍ଡ ମଧ୍ୟରେ ସେହି ବଳ୍‍କଳଶୂନ୍ୟ ଶାଖାସବୁ ଉଚ୍ଚ କରି ରଖିଲା; ତହୁଁ ଜଳ ପାନ କରିବା ସମୟରେ ସେମାନେ ଫଳବତୀ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ପୁଣି, ସେହି ଶାଖା ନିକଟରେ ସେମାନଙ୍କର ସଙ୍ଗମ ହେବାରୁ ପଶୁମାନେ ରେଖାଙ୍କିତ ଓ ଚିତ୍ରବିଚିତ୍ର ଓ ବିନ୍ଦୁଚିହ୍ନିତ ଛୁଆ ପ୍ରସବ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ତହିଁରେ ଯାକୁବ ସେହି ଛୁଆମାନଙ୍କୁ ଭିନ୍ନ ଭିନ୍ନ କଲା, ପୁଣି, ଲାବନର ରେଖାଙ୍କିତ ଓ କଳାବର୍ଣ୍ଣର ସବୁ ମେଷ ପ୍ରତି ମେଷୀମାନଙ୍କର ଦୃଷ୍ଟି ରଖାଇଲା; ଏହି ପ୍ରକାରେ ସେ ଲାବନର ପଲ ସହିତ ଆପଣା ପଲ ନ ରଖି ପୃଥକ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ପୁଣି, ବଳିଷ୍ଠ ପଶୁଗଣ ଯେପରି ଶାଖା ନିକଟରେ ଗର୍ଭଧାରଣ କରନ୍ତି, ଏଥିପାଇଁ ଜଳକୁଣ୍ଡ ମଧ୍ୟରେ ପଶୁମାନଙ୍କ ସମ୍ମୁଖରେ ସେହି ଶାଖା ରଖିଲା; ମାତ୍ର ଦୁର୍ବଳ ପଶୁମାନଙ୍କ ସମ୍ମୁଖରେ ରଖିଲା ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ତହିଁରେ ଦୁର୍ବଳ ପଶୁଗଣ ଲାବନର ଓ ବଳିଷ୍ଠ ପଶୁଗଣ ଯାକୁବର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ଏହେତୁ ଯାକୁବ ଅତିଶୟ ବର୍ଦ୍ଧିଷ୍ଣୁ ହେଲା, ପୁଣି, ତାହାର ପଶୁ, ଦାସଦାସୀ, ଓଟ ଓ ଗର୍ଦ୍ଦଭ ଯଥେଷ୍ଟ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ପୁଣି, “ଯାକୁବ ଆମ୍ଭମାନଙ୍କ ପିତାଙ୍କର ସର୍ବସ୍ୱ ହରଣ କରିଅଛି ଓ ଆମ୍ଭମାନଙ୍କ ପିତାଙ୍କର ଧନରୁ ତାହାର ଏହି ସମସ୍ତ ଐଶ୍ୱର୍ଯ୍ୟ ହୋଇଅଛି,” ଲାବନର ପୁତ୍ରମାନଙ୍କର ଏହି କଥା ଯାକୁବ ଶୁଣିଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ପୁଣି, ଲାବନ ତାହା ପ୍ରତି ପୂର୍ବ ପରି ନୁହେଁ, ଏହା ଯାକୁବ ତାହାର ମୁଖ ଦେଖି ବୁଝିଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଯାକୁବକୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ପୈତୃକ ଦେଶରେ ଜ୍ଞାତିମାନଙ୍କ ନିକଟକୁ ଫେରିଯାଅ, ଆମ୍ଭେ ତୁମ୍ଭର ସହବର୍ତ୍ତୀ ହେବା।” ");
INSERT INTO ory_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ଏଣୁ ଯାକୁବ କ୍ଷେତ୍ରରେ ପଶୁପଲ ନିକଟକୁ ରାହେଲ ଓ ଲେୟାକୁ ଡକାଇ କହିଲା, ");
INSERT INTO ory_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“ମୁଁ ଦେଖୁଅଛି, ତୁମ୍ଭମାନଙ୍କ ପିତାଙ୍କର ମୁଖ ମୋʼ ପ୍ରତି ପୂର୍ବ ପରି ନୁହେଁ; ମାତ୍ର ମୋହର ପୈତୃକ ପରମେଶ୍ୱର ମୋହର ସହାୟ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ମୁଁ ଆପଣାର ସବୁ ବଳ ଦେଇ ତୁମ୍ଭମାନଙ୍କ ପିତାଙ୍କର ଦାସ୍ୟକର୍ମ କରିଅଛି, ଏହା ତୁମ୍ଭେମାନେ ଜାଣ। ");
INSERT INTO ory_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ତଥାପି ତୁମ୍ଭମାନଙ୍କ ପିତା ମୋତେ ପ୍ରବଞ୍ଚନା କରି ଦଶ ଥର ମୋହର ବେତନ ପରିବର୍ତ୍ତନ କରିଅଛନ୍ତି; ମାତ୍ର ପରମେଶ୍ୱର ତାଙ୍କୁ ମୋହର କ୍ଷତି କରିବାକୁ ଦେଇ ନାହାନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ଯେହେତୁ ‘ଚିତ୍ରବିଚିତ୍ର ପଶୁଗଣ ତୁମ୍ଭର ବେତନ ସ୍ୱରୂପ ହେବେ,’ ସେ ଆପେ ଯେତେବେଳେ ଏହି କଥା କହିଲେ, ସେତେବେଳେ ସମସ୍ତ ପଶୁ ଚିତ୍ରବିଚିତ୍ର ଛୁଆ ପ୍ରସବ କଲେ; ପୁଣି, ‘ରେଖାଙ୍କିତ ପଶୁଗଣ ତୁମ୍ଭର ବେତନ ସ୍ୱରୂପ ହେବେ,’ ସେ ଯେତେବେଳେ ଏହା କହିଲେ, ସେତେବେଳେ ସମସ୍ତ ପଶୁ ରେଖାଙ୍କିତ ଛୁଆ ପ୍ରସବ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ଏହିରୂପେ ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କ ପିତାଙ୍କର ପଶୁଧନ ନେଇ ମୋତେ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","କାରଣ ପଶୁମାନଙ୍କ ଗର୍ଭଧାରଣ ସମୟରେ ମୁଁ ସ୍ୱପ୍ନରେ ଅନାଇ ଦେଖିଲି, ଦେଖ, ପଲ ସଙ୍ଗମକାରୀ ସମସ୍ତ ଛାଗଳ ରେଖାଙ୍କିତ ଓ ଚିତ୍ରବିଚିତ୍ର ଓ ବିନ୍ଦୁଚିହ୍ନିତ। ");
INSERT INTO ory_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ସେତେବେଳେ ପରମେଶ୍ୱରଙ୍କ ଦୂତ ସ୍ୱପ୍ନରେ ମୋତେ ‘ଯାକୁବ’ ବୋଲି ଡାକନ୍ତେ, ମୁଁ କହିଲି, ‘ଦେଖନ୍ତୁ, ମୁଁ ଏଠାରେ।’ ");
INSERT INTO ory_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ତହିଁରେ ସେ କହିଲେ, ‘ଏବେ ଅନାଇ ଦେଖ, ପଲ ସଙ୍ଗମକାରୀ ସମସ୍ତ ଛାଗଳ ରେଖାଙ୍କିତ, ଚିତ୍ରବିଚିତ୍ର ଓ ବିନ୍ଦୁଚିହ୍ନିତ; ଯେହେତୁ ତୁମ୍ଭ ପ୍ରତି ଲାବନ ଯେରୂପ ବ୍ୟବହାର କରଇ, ତାହା ଆମ୍ଭେ ଦେଖିଲୁ। ");
INSERT INTO ory_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ଯେଉଁଠାରେ ତୁମ୍ଭେ ଗୋଟିଏ ସ୍ତମ୍ଭ ଅଭିଷେକ କରିଅଛ ଓ ଆମ୍ଭ ନିକଟରେ ମାନତ କରିଅଛ, ସେହି ବେଥେଲ୍‍ର ପରମେଶ୍ୱର ଆମ୍ଭେ; ଏବେ ଉଠି ଏହି ଦେଶ ପରିତ୍ୟାଗ କରି ଆପଣା ଜ୍ଞାତିମାନଙ୍କ ଦେଶକୁ ଫେରିଯାଅ!’” ");
INSERT INTO ory_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ତହିଁରେ ରାହେଲ ଓ ଲେୟା ଉତ୍ତର କଲେ, “ପିତାଙ୍କ ଗୃହରେ ଆମ୍ଭମାନଙ୍କର କି ଆଉ କିଛି ବାଣ୍ଟ ଓ ଅଧିକାର ଅଛି? ");
INSERT INTO ory_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ଆମ୍ଭେମାନେ କି ତାଙ୍କ ନିକଟରେ ବିଦେଶିନୀ ରୂପେ ଗଣ୍ୟ ନୋହୁଁ? ଯେହେତୁ ସେ ଆମ୍ଭମାନଙ୍କୁ ବିକ୍ରି କରି ଆମ୍ଭମାନଙ୍କର ମୂଲ୍ୟ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଭୋଗ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ଏହେତୁ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କ ପିତାଙ୍କଠାରୁ ଯେଉଁସବୁ ଧନ ନେଇଅଛନ୍ତି, ସେହି ସବୁ ଆମ୍ଭମାନଙ୍କର ଓ ଆମ୍ଭମାନଙ୍କ ସନ୍ତାନଗଣର। ଏଣୁ ପରମେଶ୍ୱର ତୁମ୍ଭକୁ ଯାହା କହିଲେ, ତୁମ୍ଭେ ତାହା କର।” ");
INSERT INTO ory_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ତହୁଁ ଯାକୁବ ଉଠି ଆପଣା ସନ୍ତାନଗଣ ଓ ଭାର୍ଯ୍ୟାମାନଙ୍କୁ ଓଟ ଉପରେ ବସାଇଲା; ");
INSERT INTO ory_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ପୁଣି, ଆପଣା ଉପାର୍ଜ୍ଜିତ ପଶ୍ୱାଦି ସକଳ ଧନ, ଅର୍ଥାତ୍‍, ପଦ୍ଦନ୍‍ ଅରାମରେ ଯେଉଁ ପଶୁ ଓ ଯେଉଁ ସମ୍ପତ୍ତି ଉପାର୍ଜ୍ଜନ କରିଥିଲା, ତାହା ଘେନି କିଣାନ ଦେଶରେ ଆପଣା ପିତା ଇସ୍‌ହାକ ନିକଟକୁ ପ୍ରସ୍ଥାନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ସେହି ସମୟରେ ଲାବନ ମେଷର ଲୋମ ଛେଦନ କରିବାକୁ ଯାଇଥିଲା; ପୁଣି, ରାହେଲ ଆପଣା ପିତାଙ୍କର ଠାକୁରମାନଙ୍କୁ ହରଣ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ଆଉ ଯାକୁବ ଆପଣା ପଳାୟନର କୌଣସି ସମ୍ବାଦ ନ ଦେଇ ଅରାମୀୟ ଲାବନକୁ ପ୍ରବଞ୍ଚନା କଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ଏହି ପ୍ରକାରେ ସେ ଆପଣା ସର୍ବସ୍ୱ ଘେନି ପଳାୟନ କଲା, ପୁଣି, ଉଠି (ଫରାତ୍‍) ନଦୀ ପାର ହୋଇ ଗିଲୀୟଦ ପର୍ବତ ଆଡ଼େ ଦୃଷ୍ଟି କରି ଚାଲିଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ଏଥିଉତ୍ତାରେ ତୃତୀୟ ଦିବସରେ ଲାବନକୁ ଯାକୁବର ପଳାୟନ ସମ୍ବାଦ ଦିଆଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ତହିଁରେ ସେ ଆପଣା କୁଟୁମ୍ବମାନଙ୍କୁ ସଙ୍ଗେ ଘେନି ତାହାର ପଛେ ପଛେ ସାତ ଦିନର ବାଟ ଦୌଡ଼ିଯାଇ ଗିଲୀୟଦ ପର୍ବତ ନିକଟରେ ତାହାର ସଙ୍ଗ ଧରିଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ମାତ୍ର ପରମେଶ୍ୱର ରାତ୍ରିକାଳେ ସ୍ୱପ୍ନରେ ଅରାମୀୟ ଲାବନ ନିକଟରେ ଉପସ୍ଥିତ ହୋଇ ତାହାକୁ କହିଲେ, “ସାବଧାନ, ଯାକୁବକୁ ଭଲ ମନ୍ଦ କିଛି କୁହ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ଏଥିଉତ୍ତାରେ ଲାବନ ଯାକୁବର ସଙ୍ଗ ଧରିଲା ସମୟରେ ଯାକୁବର ତମ୍ବୁ ପର୍ବତ ଉପରେ ସ୍ଥାପିତ ଥିଲା; ତହିଁରେ ଲାବନ ହିଁ କୁଟୁମ୍ବମାନଙ୍କ ସହିତ ଗିଲୀୟଦ ପର୍ବତରେ ତମ୍ବୁ ସ୍ଥାପନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ପୁଣି, ଲାବନ ଯାକୁବକୁ କହିଲା, “ତୁମ୍ଭେ କାହିଁକି ଏହିପରି କର୍ମ କଲ? ମୋତେ ପ୍ରବଞ୍ଚନା କଲ, ପୁଣି, ମୋʼ କନ୍ୟାମାନଙ୍କୁ ଖଡ୍ଗଧୃତ ବନ୍ଦୀଲୋକଙ୍କ ପରି ଘେନି ଆସିଲ। ");
INSERT INTO ory_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ତୁମ୍ଭେ ମୋତେ ପ୍ରବଞ୍ଚନା କରି କାହିଁକି ଗୋପନରେ ପଳାଇ ଆସିଲ? କାହିଁକି ମୋତେ ସମ୍ବାଦ ଦେଲ ନାହିଁ? ଦେଇଥିଲେ, ମୁଁ ତୁମ୍ଭକୁ ଆହ୍ଲାଦ ଓ ଗାୟନ, ପୁଣି, ତବଲା ଓ ବୀଣାବାଦ୍ୟ ସହିତ ବିଦାୟ କରିଥାʼନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ତୁମ୍ଭେ ମୋହର ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ ଚୁମ୍ବନ କରିବାକୁ ମଧ୍ୟ ମୋତେ ସୁଯୋଗ ଦେଲ ନାହିଁ, ଏ ଅତି ଅଜ୍ଞାତର କର୍ମ। ");
INSERT INTO ory_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ତୁମ୍ଭକୁ ହିଂସା କରିବାକୁ ମୋହର ହସ୍ତ ସମର୍ଥ ପ୍ରମାଣ, ମାତ୍ର ଗତରାତ୍ରି ତୁମ୍ଭର ପୈତୃକ ପରମେଶ୍ୱର ମୋତେ କହିଲେ, ସାବଧାନ, ଯାକୁବକୁ ଭଲ ମନ୍ଦ କିଛି କୁହ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ଆଉ ପିତୃଗୃହକୁ ଝୁରିବାରୁ ଯଦି ତୁମ୍ଭର ଯିବାର ଆବଶ୍ୟକ ହେଲା, ତେବେ ମୋହର ଦେବତାମାନଙ୍କୁ କାହିଁକି ଚୋରି କଲ?” ");
INSERT INTO ory_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ତହିଁରେ ଯାକୁବ ଲାବନକୁ ଉତ୍ତର କଲା, “ମୋହର ଭୟ ହେଲା; କାରଣ କେଜାଣି ତୁମ୍ଭେ ମୋʼ ଠାରୁ ଆପଣା କନ୍ୟାଗଣଙ୍କୁ ବଳପୂର୍ବକ ଛଡ଼ାଇ ନେବ, ଏପରି ବିଚାର କଲି। ");
INSERT INTO ory_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ମାତ୍ର ତୁମ୍ଭେ ଯାହା ନିକଟରୁ ତୁମ୍ଭର ଦେବତାମାନଙ୍କୁ ପାଇବ, ସେ ବଞ୍ଚିବ ନାହିଁ; ମୋʼ ଠାରେ ତୁମ୍ଭର ଯାହା ଅଛି, ତାହା ଆମ୍ଭମାନଙ୍କ କୁଟୁମ୍ବଗଣର ସାକ୍ଷାତରେ ଚିହ୍ନି କରି ନିଅ,” ଯେହେତୁ ଯାକୁବ ରାହେଲର ସେହି ଚୋରି କରିବା ବିଷୟ ଜାଣି ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ତହୁଁ ଲାବନ ଯାକୁବର ତମ୍ବୁଗୃହ ଓ ଲେୟାର ତମ୍ବୁଗୃହ ଓ ଦୁଇ ଦାସୀର ତମ୍ବୁଗୃହକୁ ଯାଇ ଅନ୍ୱେଷଣ କଲା; ମାତ୍ର ପାଇଲା ନାହିଁ। ଏଣୁ ସେ ଲେୟାର ତମ୍ବୁଗୃହ ଛାଡ଼ି ରାହେଲର ତମ୍ବୁଗୃହରେ ପ୍ରବେଶ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ମାତ୍ର ରାହେଲ ସେହି ଠାକୁରମାନଙ୍କୁ ନେଇ ଓଟର ହାଉଦା ଭିତରେ ରଖି ତହିଁ ଉପରେ ବସିଥିଲା। ତହିଁରେ ଲାବନ ତାହାର ତମ୍ବୁଗୃହର ସବୁ ସ୍ଥାନ ଖୋଜିଲେ ହେଁ ତାହା ପାଇଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ସେତେବେଳେ ରାହେଲ ପିତାକୁ କହିଲା, “ମୁଁ ଆପଣଙ୍କ ଛାମୁରେ ଉଠି ପାରିଲି ନାହିଁ ବୋଲି ମୋହର ପ୍ରଭୁ କ୍ରୋଧ ନ କରନ୍ତୁ, କାରଣ ମୁଁ ସ୍ତ୍ରୀଧର୍ମିଣୀ ହୋଇଅଛି।” ଏହିରୂପେ ସେ ଅନ୍ୱେଷଣ କଲେ ହେଁ ଠାକୁରମାନଙ୍କୁ ପାଇଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ତହୁଁ ଯାକୁବ କ୍ରୋଧ ହୋଇ ଲାବନକୁ ଭର୍ତ୍ସନା କଲା; ପୁଣି, ଯାକୁବ ଲାବନକୁ ଉତ୍ତର କରି କହିଲା, “ମୋହର କି ଦୋଷ ଓ କି ପାପ ହେଲା ଯେ, ତୁମ୍ଭେ ପ୍ରଜ୍ୱଳିତ ହୋଇ ମୋʼ ପଛେ ପଛେ ଦୌଡ଼ି ଆସିଲ? ");
INSERT INTO ory_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ତୁମ୍ଭେ ତ ମୋର ସବୁ ଦ୍ରବ୍ୟ ଖୋଜିଲ, ଆଉ ତୁମ୍ଭ ଗୃହର କୌଣସି ଦ୍ରବ୍ୟ ପାଇଲ କି? ତାହା ମୋହର ଓ ତୁମ୍ଭର ଏହି କୁଟୁମ୍ବମାନଙ୍କ ସାକ୍ଷାତରେ ରଖିଦିଅ, ଏମାନେ ଆମ୍ଭ ଦୁହିଁଙ୍କର ବିଚାର କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ଏହି କୋଡ଼ିଏ ବର୍ଷ ହେଲା ତୁମ୍ଭ ସଙ୍ଗରେ ରହିଲି। ତୁମ୍ଭର ମେଷୀ ଓ ଛାଗୀମାନଙ୍କର ଗର୍ଭପାତ ହୋଇ ନାହିଁ, କିଅବା ମୁଁ ତୁମ୍ଭ ପଲର ମେଣ୍ଢାମାନଙ୍କୁ ଖାଇ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ବରଞ୍ଚ ହିଂସ୍ରକ ଜନ୍ତୁ ଯାହାକୁ ଖଣ୍ଡିଆ କଲା, ତାହା ସୁଦ୍ଧା ତୁମ୍ଭ କତିକି ଆଣିଲି ନାହିଁ; ସେ କ୍ଷତି ଆପେ ସହିଲି; ଦିନରେ ଚୋରି ଯାଉ କି ରାତିରେ ଚୋରି ଯାଉ, ତାହା ତୁମ୍ଭେ ମୋʼ ହାତରୁ ନେଲ। ");
INSERT INTO ory_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ଦିନରେ ଖରା, ରାତିରେ କାକର, ମୋତେ ଗ୍ରାସ କଲା; ମୋʼ ଆଖିରୁ ନିଦ ପଳାଇଗଲା; ଏହିପରି ମୁଁ ଥିଲି; ");
INSERT INTO ory_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ମୁଁ କୋଡ଼ିଏ ବର୍ଷ କାଳ ତୁମ୍ଭ ଘରେ ରହିଲି; ତୁମ୍ଭର ଦୁଇ ଝିଅ ନିମନ୍ତେ ଚଉଦ ବର୍ଷ ଓ ପଶୁମାନଙ୍କ ନିମନ୍ତେ ଛଅ ବର୍ଷ ଦାସ୍ୟକର୍ମ କଲି; ଏଥିମଧ୍ୟରେ ତୁମ୍ଭେ ଦଶ ଥର ମୋହର ବେତନ ପରିବର୍ତ୍ତନ କରିଅଛ। ");
INSERT INTO ory_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ମୋର ପୈତୃକ ପରମେଶ୍ୱର, ଅବ୍ରହାମର ପରମେଶ୍ୱର ଓ ଇସ୍‌ହାକର ଭୟସ୍ଥାନ ଯଦି ମୋହର ସହାୟ ହୋଇ ନ ଥାʼନ୍ତେ, ତେବେ ଅବଶ୍ୟ ଏବେ ତୁମ୍ଭେ ମୋତେ ଖାଲି ହାତରେ ବିଦାୟ କରିଥାʼନ୍ତ। ପରମେଶ୍ୱର ମୋହର ଦୁଃଖ ଓ ହସ୍ତର ପରିଶ୍ରମ ଦେଖିଅଛନ୍ତି; ଏଣୁ ଗତ ରାତ୍ରିରେ ତୁମ୍ଭକୁ ଧମକାଇଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ତହିଁରେ ଲାବନ ଯାକୁବକୁ ଉତ୍ତର କଲା, “ଏହି କନ୍ୟାମାନେ ମୋହର କନ୍ୟା ଓ ଏହି ବାଳକମାନେ ମୋହର ବାଳକ ଓ ଏହି ପଶୁପଲ ମୋହର ପଶୁପଲ, ପୁଣି, ଯାହା ଯାହା ଦେଖୁଅଛ, ସେହି ସବୁ ମୋହର; ଏହେତୁ ମୋହର ଏହି କନ୍ୟାମାନଙ୍କୁ ଓ ଏମାନଙ୍କ ପ୍ରସୂତ ସନ୍ତାନମାନଙ୍କୁ ମୁଁ କଅଣ କରିବି? ");
INSERT INTO ory_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ଆସ, ଆମ୍ଭେ ଦୁହେଁ ନିୟମ ସ୍ଥିର କରୁ, ତାହା ଆମ୍ଭମାନଙ୍କର ସାକ୍ଷୀ ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ସେତେବେଳେ ଯାକୁବ ଖଣ୍ଡିଏ ପ୍ରସ୍ତର ଘେନି ସ୍ତମ୍ଭ ରୂପେ ସ୍ଥାପନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ପୁଣି, ଯାକୁବ ଆପଣା କୁଟୁମ୍ବମାନଙ୍କୁ କହିଲା, “ତୁମ୍ଭେମାନେ ପ୍ରସ୍ତର ସଂଗ୍ରହ କର;” ତହିଁରେ ସେମାନେ ପ୍ରସ୍ତର ଆଣି ଗୋଟିଏ ରାଶି କରନ୍ତେ, ସମସ୍ତେ ସେହି ସ୍ଥାନରେ ସେହି ରାଶି ଉପରେ ଭୋଜନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ଏଥିଉତ୍ତାରେ ଲାବନ ତାହାର ନାମ ଯିଗର-ସାହଦୂଥା ରଖିଲା, ମାତ୍ର ଯାକୁବ ତାହାର ନାମ ଗଲୟଦ୍‍ (ସାକ୍ଷୀ ରାଶୀ) ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ସେତେବେଳେ ଲାବନ କହିଲା, “ଏହି ରାଶି ଆଜି ତୁମ୍ଭ ଆମ୍ଭର ସାକ୍ଷୀ ହୋଇ ରହିଲା;” ଏଥିପାଇଁ ତାହାର ନାମ ଗଲୟଦ୍‍ ଓ ମିସ୍ପା (ପ୍ରହରୀ-ସ୍ଥାନ) ରଖିଲା, ");
INSERT INTO ory_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ଯେହେତୁ ସେ କହିଲା, “ଆମ୍ଭେମାନେ ପରସ୍ପର ଅଦୃଶ୍ୟ ହେଲେ, ସଦାପ୍ରଭୁ ମୋହର ଓ ତୁମ୍ଭର ପ୍ରହରୀ ଥିବେ। ");
INSERT INTO ory_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ତୁମ୍ଭେ ଯଦି ମୋʼ କନ୍ୟାମାନଙ୍କୁ ଦୁଃଖ ଦେବ, ଅଥବା ମୋହର କନ୍ୟାମାନେ ଥାଉ ଥାଉ ଅନ୍ୟ ସ୍ତ୍ରୀମାନଙ୍କୁ ବିବାହ କରିବ, ତେବେ ସେହି ସମୟରେ କୌଣସି ମନୁଷ୍ୟ ଆମ୍ଭମାନଙ୍କ ନିକଟରେ ନ ଥିବ, ମାତ୍ର ଦେଖ, ପରମେଶ୍ୱର ଆମ୍ଭ ଓ ତୁମ୍ଭ ମଧ୍ୟରେ ସାକ୍ଷୀ ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ଆହୁରି ଲାବନ ଯାକୁବକୁ କହିଲା, “ଏହି ରାଶି ଦେଖ, ପୁଣି, ଆମ୍ଭ ଦୁହିଁଙ୍କର ମଧ୍ୟବର୍ତ୍ତୀ ମୋହର ସ୍ଥାପିତ ଏହି ସ୍ତମ୍ଭ ଦେଖ। ");
INSERT INTO ory_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ମୁଁ ଅହିତ କରିବା ପାଇଁ ଏହି ରାଶି ପାର ହୋଇ ତୁମ୍ଭ ନିକଟକୁ ଯିବି ନାହିଁ, ମଧ୍ୟ ତୁମ୍ଭେ ଏହି ରାଶି ଓ ଏହି ସ୍ତମ୍ଭ ପାର ହୋଇ ମୋʼ ନିକଟକୁ ଆସିବ ନାହିଁ; ଏଥିର ସାକ୍ଷୀ ଏହି ରାଶି ଓ ଏଥିର ସାକ୍ଷୀ ଏହି ସ୍ତମ୍ଭ। ");
INSERT INTO ory_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ଏହି ବିଷୟରେ ଅବ୍ରହାମଙ୍କର ପରମେଶ୍ୱର, ନାହୋରର ପରମେଶ୍ୱର ଓ ସେମାନଙ୍କ ପୈତୃକ ପରମେଶ୍ୱର ଆମ୍ଭ ଓ ତୁମ୍ଭ ମଧ୍ୟରେ ବିଚାର କରିବେ,” ସେତେବେଳେ ଯାକୁବ ଆପଣା ପିତା ଇସ୍‌ହାକର ଭୟସ୍ଥାନର ଶପଥ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ଏଥିଉତ୍ତାରେ ସେ ସେହି ପର୍ବତରେ ବଳିଦାନ କରି ଆହାର କରିବା ନିମନ୍ତେ ଆପଣା କୁଟୁମ୍ବମାନଙ୍କୁ ଡାକିଲା, ତହିଁରେ ସେମାନେ ଭୋଜନ କରି ପର୍ବତରେ ସାରାରାତ୍ରି ଯାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ଏଥିଉତ୍ତାରେ ଲାବନ ପ୍ରଭାତରେ ଉଠି ଆପଣା କନ୍ୟାମାନଙ୍କୁ ଓ ବାଳକମାନଙ୍କୁ ଚୁମ୍ବନ କରି ଆଶୀର୍ବାଦ କଲା; ଏହିରୂପେ ଲାବନ ସ୍ୱ ସ୍ଥାନକୁ ଫେରିଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ତହିଁ ଉତ୍ତାରେ ଯାକୁବ ଯାତ୍ରା କରନ୍ତେ, ପରମେଶ୍ୱରଙ୍କ ଦୂତଗଣ ତାହା ସଙ୍ଗେ ଭେଟିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ସେଥିପାଇଁ ଯାକୁବ ସେମାନଙ୍କୁ ଦେଖି କହିଲା, “ଏମାନେ ପରମେଶ୍ୱରଙ୍କ ଦଳ;” ଏଥିପାଇଁ ସେହି ସ୍ଥାନର ନାମ ମହନୟିମ (ଦୁଇ ଦଳ) ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ତହିଁ ଉତ୍ତାରେ ଯାକୁବ ଆପଣା ଆଗେ ସେୟୀର ଦେଶସ୍ଥ ଇଦୋମ ଅଞ୍ଚଳରେ ଭ୍ରାତା ଏଷୌ ନିକଟକୁ ଦୂତମାନଙ୍କୁ ପ୍ରେରଣ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ପୁଣି, ସେ ସେମାନଙ୍କୁ ଏହି ଆଜ୍ଞା ଦେଲା, “ତୁମ୍ଭେମାନେ ଆମ୍ଭର ପ୍ରଭୁ ଏଷୌଙ୍କୁ କହିବ, ଆପଣଙ୍କ ଦାସ ଯାକୁବ ଆପଣଙ୍କୁ ଜଣାଇଲା, ‘ମୁଁ ଲାବନ ପାଖରେ ପ୍ରବାସ କରୁଥିଲି, ଆଜି ପର୍ଯ୍ୟନ୍ତ ମୋହର ବିଳମ୍ବ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ମୋହର ଗୋରୁ, ଗଧ, ମେଷପଲ ଓ ଦାସଦାସୀ ଅଛନ୍ତି, ପୁଣି, ମୁଁ ଆପଣା ପ୍ରଭୁଙ୍କ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇବା ନିମନ୍ତେ ଆପଣଙ୍କ ନିକଟକୁ ସମ୍ବାଦ ପଠାଇଲି।’” ");
INSERT INTO ory_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ଏଥିଉତ୍ତାରେ ଦୂତମାନେ ଫେରିଆସି ଯାକୁବକୁ କହିଲେ, “ଆମ୍ଭେମାନେ ଆପଣଙ୍କ ଭ୍ରାତା ଏଷୌ ନିକଟକୁ ଯାଇଥିଲୁ, ସେ ଚାରି ଶହ ଲୋକ ସଙ୍ଗରେ ଘେନି ଆପଣଙ୍କ ସହିତ ଦେଖା କରିବାକୁ ଆସୁଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ତହିଁରେ ଯାକୁବ ଅତିଶୟ ଭୀତ ଓ ଉଦ୍‍ବିଗ୍ନ ହେଲା, ପୁଣି, ସଙ୍ଗୀ ଲୋକମାନଙ୍କୁ ଓ ଗୋମେଷାଦି ସମସ୍ତ ପଲ ଓ ଓଟମାନଙ୍କୁ ଭିନ୍ନ ଭିନ୍ନ ଦୁଇ ଦଳ କରି କହିଲା, ");
INSERT INTO ory_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ଏଷୌ ଆସି ଯଦି ଏକ ଦଳକୁ ପ୍ରହାର କରିବ, ତଥାପି ଅନ୍ୟ ଦଳ ବଞ୍ଚି ପଳାଇଯିବେ,” ");
INSERT INTO ory_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ସେତେବେଳେ ଯାକୁବ କହିଲା, “ହେ ମୋହର ପିତା ଅବ୍ରହାମଙ୍କର ପରମେଶ୍ୱର, ହେ ମୋହର ପିତା ଇସ୍‌ହାକଙ୍କର ପରମେଶ୍ୱର, ହେ ସଦାପ୍ରଭୋ, ତୁମ୍ଭେ ମୋତେ କହିଥିଲ, ‘ତୁମ୍ଭେ ଆପଣା ଦେଶ ଓ ଜ୍ଞାତିମାନଙ୍କ ନିକଟକୁ ଫେରିଯାଅ, ତହିଁରେ ଆମ୍ଭେ ତୁମ୍ଭର ମଙ୍ଗଳ କରିବା।’ ");
INSERT INTO ory_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ତୁମ୍ଭେ ଏହି ଦାସ ପ୍ରତି ଯେଉଁ ସମସ୍ତ ଦୟା ଓ ଯେଉଁ ସମସ୍ତ ବିଶ୍ୱସ୍ତତା ପ୍ରକାଶ କରିଅଛ, ମୁଁ ତହିଁର ଅଳ୍ପ ମଧ୍ୟ ପାଇବାର ଯୋଗ୍ୟ ନୁହେଁ; ଯେହେତୁ ମୁଁ ନିଜର ଯଷ୍ଟି ମାତ୍ର ଘେନି ଏହି ଯର୍ଦ୍ଦନ ପାର ହୋଇଥିଲି, ମାତ୍ର ଏବେ ମୁଁ ଦୁଇ ଦଳ ହୋଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ବିନୟ କରୁଅଛି, ମୋʼ ଭ୍ରାତାର ହସ୍ତରୁ, ଏଷୌର ହସ୍ତରୁ ମୋତେ ରକ୍ଷା କର; କାରଣ ମୁଁ ତାହାକୁ ଭୟ କରୁଅଛି, କେଜାଣି ସେ ଆସି ମୋତେ ଓ ମାତା ଓ ବାଳକମାନଙ୍କୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ତୁମ୍ଭେ ତ କହିଅଛ, ‘ଆମ୍ଭେ ଅବଶ୍ୟ ତୁମ୍ଭର ମଙ୍ଗଳ କରିବା, ପୁଣି, ସମୁଦ୍ରତୀରସ୍ଥ ଯେଉଁ ବାଲି ବାହୁଲ୍ୟ ହେତୁ ଗଣାଯାଇ ନ ପାରେ, ତାହା ତୁଲ୍ୟ ତୁମ୍ଭର ବଂଶ ବୃଦ୍ଧି କରିବା।’” ");
INSERT INTO ory_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ଆଉ ଯାକୁବ ସେହି ସ୍ଥାନରେ ସେହି ରାତ୍ରି କ୍ଷେପଣ କଲା; ଆଉ ତାହା ନିକଟରେ ଯାହା ଥିଲା, ତହିଁରୁ ଆପଣା ଭ୍ରାତା ଏଷୌ ନିମନ୍ତେ ଭେଟି ପ୍ରସ୍ତୁତ କଲା; ");
INSERT INTO ory_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ଅର୍ଥାତ୍‍, ଦୁଇ ଶହ ଛାଗୀ ଓ କୋଡ଼ିଏ ଛାଗ, ଦୁଇ ଶହ ମେଷୀ ଓ କୋଡ଼ିଏ ମେଷ, ");
INSERT INTO ory_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ପୁଣି, ସବତ୍ସା ଦୁଗ୍ଧବତୀ ତିରିଶ ଉଷ୍ଟ୍ରୀ ଓ ଚାଳିଶ ଗାଭୀ ଓ ଦଶ ବୃଷ, ପୁଣି, କୋଡ଼ିଏ ଗର୍ଦ୍ଦଭୀ ଓ ଦଶଟି ବାଛୁରି ପ୍ରସ୍ତୁତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ଏଥିଉତ୍ତାରେ ପଲସବୁ ପୃଥକ ପୃଥକ କରି ଆପଣା ଦାସମାନଙ୍କ ହସ୍ତରେ ଏକ ପଲ ସମର୍ପଣ କରି ସେମାନଙ୍କୁ ଆଜ୍ଞା ଦେଲା, “ତୁମ୍ଭେମାନେ ମୋʼ ଆଗେ ଆଗେ ଯାଅ, ପୁଣି, ମଧ୍ୟେ ମଧ୍ୟେ ସ୍ଥାନ ରଖି ପ୍ରତ୍ୟେକ ପଲକୁ ପୃଥକ କର।” ");
INSERT INTO ory_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ପୁଣି, ସେ ସର୍ବାଗ୍ରଗାମୀ ଦାସକୁ ଏହି ଆଜ୍ଞା ଦେଲା, “ମୋହର ଭ୍ରାତା ଏଷୌ ସହିତ ସାକ୍ଷାତ ହେଲେ, ସେ ଯଦି ପଚାରିବେ, ‘ତୁମ୍ଭେ କାହାର ଦାସ? କେଉଁଠାକୁ ଯାଉଅଛ? ପୁଣି, ତୁମ୍ଭର ଅଗ୍ରସ୍ଥିତ ଏହି ସମସ୍ତ କାହାର?’ ");
INSERT INTO ory_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ତେବେ ତୁମ୍ଭେ ଉତ୍ତର ଦେବ, ‘ଏହି ସମସ୍ତ ଆପଣଙ୍କ ଦାସ ଯାକୁବଙ୍କର, ଏହିସବୁ ଭେଟି ଆମ୍ଭ ପ୍ରଭୁ ଏଷୌଙ୍କ ନିମନ୍ତେ ପ୍ରେରିତ; ଦେଖନ୍ତୁ, ସେ ମଧ୍ୟ ପଛେ ପଛେ ଆସୁଅଛନ୍ତି।’” ");
INSERT INTO ory_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ଏହି ପ୍ରକାରେ ସେ ଦ୍ୱିତୀୟ ଓ ତୃତୀୟ ପଲର ପଶ୍ଚାଦ୍‍ଗାମୀ ସବୁ ଦାସମାନଙ୍କୁ ଆଜ୍ଞା ଦେଇ କହିଲା, “ଏଷୌ ସଙ୍ଗରେ ସାକ୍ଷାତ ହେଲେ, ତୁମ୍ଭେମାନେ ଏହି ପ୍ରକାର କଥା କହିବ। ");
INSERT INTO ory_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ଆହୁରି କହିବ, ‘ଦେଖନ୍ତୁ, ଆପଣଙ୍କ ଦାସ ଯାକୁବ ଆମ୍ଭମାନଙ୍କ ପଛେ ଆସୁଅଛନ୍ତି;’” କାରଣ ସେ ମନେ କଲେ, “ଆଗେ ଭେଟି ପଠାଇ ତାଙ୍କୁ ଶାନ୍ତ କରି ପଛେ ତାଙ୍କ ସଙ୍ଗରେ ସାକ୍ଷାତ କରିବା, ତହିଁରେ ସେ ଆମ୍ଭ ପ୍ରତି ଅନୁଗ୍ରହ କଲେ କରିପାରନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ଏହିରୂପେ ତାହା ଆଗରେ ଭେଟି ଦ୍ରବ୍ୟ ଗଲା; ମାତ୍ର ସେ ଆପେ ସେହି ରାତ୍ରି ନିଜ ଦଳ ମଧ୍ୟରେ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ଏଥିଉତ୍ତାରେ ସେ ରାତ୍ରିରେ ଉଠି ଆପଣାର ଦୁଇ ଭାର୍ଯ୍ୟା ଓ ଦୁଇ ଦାସୀ ଓ ଏକାଦଶ ସନ୍ତାନଙ୍କୁ ଯବ୍ବୋକ୍‍ ଘାଟରେ ପାର କରାଇବା ପାଇଁ ସଙ୍ଗରେ ନେଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ପୁଣି, ସେମାନଙ୍କୁ ନଦୀ ପାର କରାଇ ଆପଣାର ସମସ୍ତ ଦ୍ରବ୍ୟ ସେପାରିକୁ ପଠାଇଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ସେତେବେଳେ ଯାକୁବ ସେଠାରେ ଏକାକୀ ରହିଲା; ତହୁଁ ଜଣେ ପୁରୁଷ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ତାହା ସହିତ ମଲ୍ଲଯୁଦ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ମାତ୍ର ତାହାକୁ ଜୟ କରି ପାରିଲେ ନାହିଁ ଦେଖି ସେ ଯାକୁବର ଊରୁଦେଶର ସନ୍ଧି ସ୍ଥାନରେ ଆଘାତ କଲେ; ତାହାଙ୍କ ସହିତ ଏପ୍ରକାର ମଲ୍ଲଯୁଦ୍ଧ କରିବାରୁ ଯାକୁବର ଊରୁସନ୍ଧି ଖସିଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ଏଥିଉତ୍ତାରେ ସେହି ପୁରୁଷ କହିଲେ, “ଆମ୍ଭକୁ ଛାଡ଼, କାରଣ ପ୍ରଭାତ ହେଲା।” ତହୁଁ ଯାକୁବ କହିଲା, “ତୁମ୍ଭେ ମୋତେ ଆଶୀର୍ବାଦ ନ କଲେ, ମୁଁ ତୁମ୍ଭଙ୍କୁ ଛାଡ଼ିବି ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ପୁନର୍ବାର ସେହି ମନୁଷ୍ୟ କହିଲେ, “ତୁମ୍ଭର ନାମ କଅଣ?” ସେ କହିଲା, “ଯାକୁବ।” ");
INSERT INTO ory_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ସେ କହିଲେ, “ତୁମ୍ଭେ ଯାକୁବ ନାମରେ ଆଉ ବିଖ୍ୟାତ ହେବ ନାହିଁ, ମାତ୍ର ଇସ୍ରାଏଲ ନାମରେ ବିଖ୍ୟାତ ହେବ; କାରଣ, ତୁମ୍ଭେ ପରମେଶ୍ୱର ଓ ମନୁଷ୍ୟ ସହିତ ଯୁଦ୍ଧ କରି ଜୟୀ ହୋଇଅଛ।” ");
INSERT INTO ory_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ସେତେବେଳେ ଯାକୁବ ପଚାରି କହିଲା, “ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭର ନାମ କୁହ।” ସେ କହିଲେ, “ତୁମ୍ଭେ କାହିଁକି ଆମ୍ଭର ନାମ ପଚାରୁଅଛ?” ତହୁଁ ସେ ସେଠାରେ ଯାକୁବକୁ ଆଶୀର୍ବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ସେତେବେଳେ ସେହି ସ୍ଥାନର ନାମ ପନୂୟେଲ ରଖିଲା; ଯେହେତୁ ଯାକୁବ କହିଲା, “ମୁଁ ପରମେଶ୍ୱରଙ୍କୁ ମୁଖାମୁଖି ଦେଖିଲେ ହେଁ ମୋହର ପ୍ରାଣ ବଞ୍ଚିଲା।” ");
INSERT INTO ory_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ଏଥିଉତ୍ତାରେ ଯାକୁବ ପନୂୟେଲ ପାର ହୁଅନ୍ତେ, ସୂର୍ଯ୍ୟୋଦୟ ହେଲା; ମାତ୍ର ସେ ଊରୁସନ୍ଧି ସକାଶୁ ଛୋଟାଇ ଚାଲିଲା। ");
INSERT INTO ory_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ଏହେତୁ ଇସ୍ରାଏଲର ସନ୍ତାନମାନେ ଆଜି ପର୍ଯ୍ୟନ୍ତ (କୌଣସି) ଊରୁଦେଶର ଉପରିସ୍ଥ ସନ୍ଧିଶିରା ଭୋଜନ କରନ୍ତି ନାହିଁ, କାରଣ ସେ ଯାକୁବର ଊରୁଦେଶର ସନ୍ଧିଶିରା ସ୍ପର୍ଶ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଅନାଇ ଦେଖିଲା, ଆଉ ଦେଖ, ଏଷୌ ଉପସ୍ଥିତ, ପୁଣି, ତାହା ସଙ୍ଗେ ଚାରି ଶହ ପୁରୁଷ। ତହିଁରେ ସେ ଆପଣା ସନ୍ତାନମାନଙ୍କୁ ବିଭାଗ କରି ଲେୟା ଓ ରାହେଲ ଓ ଦୁଇ ଦାସୀଙ୍କ ନିକଟରେ ସମର୍ପଣ କଲା, ");
INSERT INTO ory_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ଅର୍ଥାତ୍‍, ଆଗେ ଦୁଇ ଦାସୀ ଓ ସେମାନଙ୍କ ସନ୍ତାନଗଣକୁ, ତାହା ପଛେ ଲେୟା ଓ ତାହାର ସନ୍ତାନଗଣକୁ, ସର୍ବଶେଷରେ ରାହେଲ ଓ ଯୋଷେଫକୁ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ପୁଣି, ଆପେ ସମସ୍ତଙ୍କ ଆଗେ ଯାଇ ସାତ ଥର ଭୂମିଷ୍ଠ ପ୍ରଣାମ କରୁ କରୁ ଆପଣା ଭ୍ରାତା ନିକଟରେ ଉପସ୍ଥିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ସେତେବେଳେ ଏଷୌ ତାହାକୁ ଭେଟିବାକୁ ଧାଇଁ ଆସି ତାହାର ଗଳା ଧରି ଆଲିଙ୍ଗନ ଓ ଚୁମ୍ବନ କଲା, ପୁଣି, ଦୁହେଁ ରୋଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ଏଉତ୍ତାରେ ସେ ଅନାଇ ସ୍ତ୍ରୀଗଣକୁ ଓ ବାଳକଗଣକୁ ଦେଖି ପଚାରିଲା, “ତୁମ୍ଭ ସଙ୍ଗେ ଏମାନେ କିଏ?” ତହିଁରେ ସେ କହିଲା, “ପରମେଶ୍ୱର କୃପା କରି ଆପଣଙ୍କ ଦାସକୁ ଏହି ସମସ୍ତ ସନ୍ତାନ ଦେଇଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ତହୁଁ ଦାସୀଗଣ ଓ ସେମାନଙ୍କ ସନ୍ତାନମାନେ ନିକଟକୁ ଆସି ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ତହିଁ ପଛେ ଲେୟା ଓ ତାହାର ସନ୍ତାନମାନେ ଆସି ପ୍ରଣାମ କଲେ; ସର୍ବଶେଷରେ ଯୋଷେଫ ଓ ରାହେଲ ନିକଟକୁ ଆସି ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ତହିଁରେ ଏଷୌ ପଚାରିଲା, “ମୁଁ ଆଗେ ଯେଉଁସବୁ (ପଶ୍ୱାଦି) ଦଳ ସହିତ ଭେଟିଲି; ତାହା କି ନିମନ୍ତେ?” ଯାକୁବ କହିଲା, “ମୋʼ ପ୍ରଭୁଙ୍କ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇବା ନିମନ୍ତେ।” ");
INSERT INTO ory_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ତହୁଁ ଏଷୌ କହିଲା, “ମୋହର ଯଥେଷ୍ଟ ଅଛି; ଭାଇ, ତୁମ୍ଭର ଯାହା ଅଛି, ତାହା ତୁମ୍ଭର ଥାଉ।” ");
INSERT INTO ory_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ଯାକୁବ କହିଲା, “ନା, ବିନୟ କରୁଅଛି, ମୁଁ ଆପଣଙ୍କ ଦୃଷ୍ଟିରେ ଯଦି ଅନୁଗ୍ରହ ପାଇଲି, ତେବେ ମୋʼ ହସ୍ତରୁ ସେହି ଭେଟି ଗ୍ରହଣ କରନ୍ତୁ; କାରଣ ପରମେଶ୍ୱରଙ୍କ ମୁଖ ଦର୍ଶନ କଲା ପରି ମୁଁ ଆପଣଙ୍କ ମୁଖ ଦର୍ଶନ କରିଅଛି; ମଧ୍ୟ ଆପଣ ମୋʼ ପ୍ରତି ପ୍ରସନ୍ନ ହୋଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ଏଣୁ ନିବେଦନ କରୁଅଛି, ଆପଣଙ୍କ ନିକଟକୁ ଆନୀତ ଏହି ଆଶୀର୍ବାଦ ଗ୍ରହଣ କରନ୍ତୁ; କାରଣ ପରମେଶ୍ୱର ମୋତେ ଅନୁଗ୍ରହ କରିଅଛନ୍ତି, ପୁଣି, ମୋହର ସବୁ ଅଛି।” ଏହିରୂପେ ଅତ୍ୟନ୍ତ ଆଗ୍ରହ ସହିତ ପ୍ରାର୍ଥନା କରନ୍ତେ, ଏଷୌ ତାହା ଗ୍ରହଣ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ଏଥିଉତ୍ତାରେ ଏଷୌ କହିଲା, “ଆସ, ଆମ୍ଭେମାନେ ଯିବା, ମୁଁ ତୁମ୍ଭମାନଙ୍କ ଆଗେ ଆଗେ ଯାଉଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ତହିଁରେ ଯାକୁବ କହିଲା, “ମୋହର ପ୍ରଭୁ ଜାଣନ୍ତି, ଏହି ବାଳକମାନେ କୋମଳ, ଆଉ ଦୁଗ୍ଧବତୀ ମେଷୀ ଓ ଗାଭୀ ମୋʼ ସଙ୍ଗରେ ଅଛନ୍ତି; ଦିନେ ଅଧିକ ଚଳାଇଲେ ସବୁ ପଲ ମରିଯିବେ। ");
INSERT INTO ory_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ଏଣୁ ନିବେଦନ କରୁଅଛି, ମୋହର ପ୍ରଭୁ ଆପଣା ଦାସର ଆଗେ ଆଗେ ଗମନ କରନ୍ତୁ; ସେୟୀର ପ୍ରଦେଶରେ ମୋʼ ପ୍ରଭୁଙ୍କ ନିକଟରେ ଉପସ୍ଥିତ ହେବା ପର୍ଯ୍ୟନ୍ତ ମୁଁ ପଶୁଗଣର ଗମନ ଶକ୍ତି ଅନୁସାରେ ଓ ବାଳକଗଣର ଗମନ ଶକ୍ତି ଅନୁସାରେ ଧୀରେ ଧୀରେ ଚଳାଇ ନେବି।” ");
INSERT INTO ory_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ଏଷୌ କହିଲା, “ତେବେ ମୋʼ ସଙ୍ଗୀ କେତେକ ଲୋକଙ୍କୁ ତୁମ୍ଭ ନିକଟରେ ରଖି ଯାଉଅଛି।” ଯାକୁବ କହିଲା, “କି ପ୍ରୟୋଜନ? ମୋʼ ପ୍ରତି କେବଳ ପ୍ରଭୁଙ୍କର ଅନୁଗ୍ରହ ଦୃଷ୍ଟି ଥାଉ।” ");
INSERT INTO ory_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ତହଁରେ ଏଷୌ ସେହି ଦିନ ସେୟୀର ପଥ ଦେଇ ବାହୁଡ଼ି ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ମାତ୍ର ଯାକୁବ ସୁକ୍କୋତକୁ ଗମନ କରି ଆପଣା ପାଇଁ ଗୃହ ଓ ପଶୁମାନଙ୍କ ନିମନ୍ତେ କୁଡ଼ିଆ ନିର୍ମାଣ କଲା; ଏଥିପାଇଁ ଏହି ସ୍ଥାନ ସୁକ୍କୋତ ନାମରେ ବିଖ୍ୟାତ ହୋଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ଏହି ପ୍ରକାରେ ଯାକୁବ ପଦ୍ଦନ୍‍ ଅରାମଠାରୁ ବାହାରି କୁଶଳରେ କିଣାନ ଦେଶସ୍ଥ ଶିଖିମର ଏକ ନଗରରେ ଉପସ୍ଥିତ ହୋଇ ନଗରର ବାହାରେ ତମ୍ବୁ ସ୍ଥାପନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ଏଥିଉତ୍ତାରେ ଶିଖିମର ପିତା ହମୋରର ସନ୍ତାନମାନଙ୍କୁ ଏକ ଶହ କସୀତା ରୌପ୍ୟ ମୁଦ୍ରା ଦେଇ ସେହି ତମ୍ବୁ ସ୍ଥାପନର ଭୂମିଖଣ୍ଡ କିଣିଲା। ");
INSERT INTO ory_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ପୁଣି, ସେଠାରେ ଏକ ବେଦି ନିର୍ମାଣ କରି ତାହାର ନାମ ଏଲ-ଇଲୋହେ-ଇସ୍ରାଏଲ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ଏଥିଉତ୍ତାରେ ଲେୟାଠାରୁ ଜାତ ଦୀଣା ନାମ୍ନୀ ଯାକୁବର କନ୍ୟା ସେହି ଦେଶର କନ୍ୟାମାନଙ୍କ ସଙ୍ଗେ ଦେଖା କରିବାକୁ ବାହାରକୁ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ତହିଁରେ ହିବ୍ବୀୟ ହମୋର ନାମକ ଦେଶାଧିପତିର ପୁତ୍ର ଶିଖିମ ତାହାକୁ ଦେଖିଲା; ପୁଣି, ତାହାକୁ ନେଇ ତାହା ସହିତ ଶୟନ କରି ତାହାକୁ ଭ୍ରଷ୍ଟା କଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ଆଉ ଯାକୁବର ସେହି କନ୍ୟା ଦୀଣାଠାରେ ତାହାର ମନ ଅନୁରକ୍ତ ହେବାରୁ ସେ ସେହି ଯୁବତୀକି ପ୍ରେମ କରି ତାକୁ ପ୍ରୀତିଜନକ ବାକ୍ୟ କହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ଏଥିଉତ୍ତାରେ ଶିଖିମ ଆପଣା ପିତା ହମୋରକୁ କହିଲା, “ତୁମ୍ଭେ ଏହି ଯୁବତୀ ସଙ୍ଗେ ମୋତେ ବିବାହ କରିଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଆପଣାର କନ୍ୟା ଦୀଣାକୁ ଶିଖିମ ଭ୍ରଷ୍ଟା କରିଥିବାର କଥା ଶୁଣିଲା; ସେହି ସମୟରେ ତାହାର ପୁତ୍ରମାନେ କ୍ଷେତ୍ରରେ ପଶୁପଲ ସଙ୍ଗରେ ଥିବାରୁ ଯାକୁବ ସେମାନଙ୍କ ଆସିବା ପର୍ଯ୍ୟନ୍ତ ତୁନି ହୋଇ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ଏଥିମଧ୍ୟରେ ଶିଖିମର ପିତା ହମୋର ଯାକୁବ ସହିତ କଥାବାର୍ତ୍ତା କରିବାକୁ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ଆଉ ଯାକୁବର ପୁତ୍ରମାନେ ସେହି ସମ୍ବାଦ ପାଇ କ୍ଷେତ୍ରରୁ ଆସିଥିଲେ; ପୁଣି, ଶିଖିମ ଯାକୁବର କନ୍ୟା ସହିତ ଶୟନ କରି ଇସ୍ରାଏଲ ବିରୁଦ୍ଧରେ ଯେଉଁ ଅକର୍ତ୍ତବ୍ୟ ମୂଢ଼ କର୍ମ କରିଥିଲା, ତହିଁ ସକାଶେ ସେମାନେ ମନସ୍ତାପିତ ଓ ଅତି କ୍ରୋଧାନ୍ୱିତ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ସେତେବେଳେ ହମୋର ସେମାନଙ୍କ ସଙ୍ଗେ କଥାବାର୍ତ୍ତା କରି କହିଲା, “ତୁମ୍ଭମାନଙ୍କର ଏହି କନ୍ୟାଠାରେ ମୋʼ ପୁତ୍ର ଶିଖିମର ମନ ଆସକ୍ତ ହୋଇଅଛି; ମୁଁ ନିବେଦନ କରୁଅଛି, ମୋʼ ପୁତ୍ର ସଙ୍ଗେ ତାହାକୁ ବିବାହ କରିଦିଅ। ");
INSERT INTO ory_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ପୁଣି, ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗେ ବିବାହ-ସମ୍ବନ୍ଧ ରଖ, ତୁମ୍ଭମାନଙ୍କ କନ୍ୟା ଆମ୍ଭମାନଙ୍କୁ ଦିଅ, ଆମ୍ଭମାନଙ୍କ କନ୍ୟା ତୁମ୍ଭେମାନେ ନିଅ। ");
INSERT INTO ory_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ତାହାହେଲେ, ତୁମ୍ଭେମାନେ ଆମ୍ଭମାନଙ୍କ ସହିତ ବାସ କରିବ; ସାରା ଦେଶ ତୁମ୍ଭମାନଙ୍କର ଆଗରେ ପଡ଼ିଛି, ତହିଁରେ ବାସ କର ଓ ବାଣିଜ୍ୟ କର ଓ ଅଧିକାର କର।” ");
INSERT INTO ory_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ପୁଣି, ଶିଖିମ ଦୀଣାର ପିତାକୁ ଓ ଭ୍ରାତୃଗଣକୁ କହିଲା, “ମୋʼ ପ୍ରତି ତୁମ୍ଭମାନଙ୍କର ଅନୁଗ୍ରହ ଦୃଷ୍ଟି ହେଉ, ତହିଁରେ ଯାହା କହିବ, ତାହା ମୁଁ ଦେବି। ");
INSERT INTO ory_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ଯୌତୁକ ଓ ଦାନ ଯେତେ ଅଧିକ ମାଗିବ, ତୁମ୍ଭମାନଙ୍କ କଥାନୁସାରେ ତାହା ଦେବି; ମାତ୍ର କୌଣସିମତେ ମୋʼ ସଙ୍ଗେ ଏହି କନ୍ୟାକୁ ବିବାହ କରିଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ତେବେ ଶିଖିମ ଯାକୁବର ପୁତ୍ରମାନଙ୍କ ଭଉଣୀ ଦୀଣାକୁ ଭ୍ରଷ୍ଟା କରିଥିବାରୁ ସେମାନେ ଶିଖିମ ଓ ତାହାର ପିତା ହମୋର ସଙ୍ଗେ ଛଳ ଭାବରେ କଥାବାର୍ତ୍ତା କରି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“ଆମ୍ଭେମାନେ ଅସୁନ୍ନତ ଲୋକକୁ ଆପଣା ଭଉଣୀକୁ ଦେବାର କର୍ମ କରି ନ ପାରୁ, ତାହା କଲେ, ଆମ୍ଭମାନଙ୍କର ଅପଖ୍ୟାତି ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ଯଦି କେବଳ ଗୋଟିଏ କର୍ମ କରିବ, ଆମ୍ଭମାନଙ୍କ ପରି ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ପୁରୁଷ ସୁନ୍ନତ ହେବ, ତେବେ ଆମ୍ଭେମାନେ ତୁମ୍ଭମାନଙ୍କ କଥାରେ ସମ୍ମତ ହେବା। ");
INSERT INTO ory_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ଆମ୍ଭେମାନେ ତୁମ୍ଭମାନଙ୍କୁ କନ୍ୟା ଦାନ କରିବା ଓ ତୁମ୍ଭମାନଙ୍କ କନ୍ୟା ଗ୍ରହଣ କରିବା, ପୁଣି, ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ବାସ କରି ଏକ-ଲୋକ ହେବା। ");
INSERT INTO ory_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ମାତ୍ର ତୁମ୍ଭେମାନେ ଯଦି ସୁନ୍ନତ ବିଷୟରେ ଆମ୍ଭମାନଙ୍କ କଥା ନ ଶୁଣ, ତେବେ ଆମ୍ଭେମାନେ ସେହି କନ୍ୟାକୁ ଘେନି ଚାଲିଯିବା।” ");
INSERT INTO ory_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ସେତେବେଳେ ସେମାନଙ୍କର ଏହି କଥାରେ ହମୋର ଓ ତାହାର ପୁତ୍ର ଶିଖିମ ସନ୍ତୁଷ୍ଟ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ପୁଣି, ସେହି ଯୁବା ଅତି ଶୀଘ୍ର ସେ କର୍ମ କଲା, କାରଣ ସେ ଯାକୁବର କନ୍ୟାଠାରେ ଅତିଶୟ ଆସକ୍ତ ଥିଲା। ସେହି ଶିଖିମ ଆପଣା ପିତୃପରିବାର ସମସ୍ତଙ୍କଠାରୁ ଅଧିକ ସମ୍ଭ୍ରାନ୍ତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ଏଥିଉତ୍ତାରେ ହମୋର ଓ ତାହାର ପୁତ୍ର ଶିଖିମ ଆପଣା ନଗର-ଦ୍ୱାରକୁ ଆସି ନଗର ନିବାସୀମାନଙ୍କ ସହିତ କଥାବାର୍ତ୍ତା କରି କହିଲେ; ");
INSERT INTO ory_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ଏହି ଲୋକମାନେ ଆମ୍ଭମାନଙ୍କ ସହିତ ନିର୍ବିରୋଧୀ; ଏଥିପାଇଁ ଏମାନଙ୍କୁ ଏହି ଦେଶରେ ବାସ ଓ ବାଣିଜ୍ୟ କରିବାକୁ ଦିଆଯାଉ; କାରଣ ଦେଖ, ଏ ଦେଶ ସେମାନଙ୍କ ନିମନ୍ତେ ଯଥେଷ୍ଟ ଅଟଇ; ପୁଣି, ଆମ୍ଭେମାନେ ସେମାନଙ୍କ କନ୍ୟା ଗ୍ରହଣ କରିବା ଓ ଆମ୍ଭମାନଙ୍କ କନ୍ୟା ସେମାନଙ୍କୁ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ମାତ୍ର ସେମାନଙ୍କର ଏହି ଏକ ପଣ ଅଛି, କି ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରତ୍ୟେକ ପୁରୁଷ ଯଦି ସେମାନଙ୍କ ପରି ସୁନ୍ନତ ହେବ, ତେବେ ସେମାନେ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ବାସ କରି ଏକ-ଲୋକ ହେବାକୁ ସମ୍ମତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ସେମାନଙ୍କ ଧନ, ସମ୍ପତ୍ତି ଓ ପଶୁଗଣ କି ଆମ୍ଭମାନଙ୍କର ହେବ ନାହିଁ? କେବଳ ଆମ୍ଭେମାନେ ସେମାନଙ୍କ କଥା ଅଙ୍ଗୀକାର କରୁ, ତାହା କଲେ, ସେମାନେ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗେ ବାସ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ସେତେବେଳେ ହମୋର ଓ ତାହାର ପୁତ୍ର ଶିଖିମର ଏହି କଥାରେ ତାହାର ନଗର-ଦ୍ୱାର ଦେଇ ବହିର୍ଗମନକାରୀ ସମସ୍ତ ଲୋକ ସମ୍ମତ ହେଲେ; ତହିଁରେ ତାହାର ନଗର-ଦ୍ୱାର ଦେଇ ବହିର୍ଗମନକାରୀ ପ୍ରତ୍ୟେକ ପୁରୁଷର ସୁନ୍ନତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ଆଉ ତୃତୀୟ ଦିନରେ ସେମାନେ ପୀଡ଼ିତ ହୁଅନ୍ତେ, ଦୀଣାର ଭ୍ରାତା ଶିମୀୟୋନ ଓ ଲେବୀ, ଯାକୁବର ଏହି ଦୁଇ ପୁତ୍ର ଆପଣା ଖଡ୍ଗ ଘେନି ନିର୍ଭୟରେ ନଗର ଆକ୍ରମଣ କରି ସବୁ ପୁରୁଷମାନଙ୍କୁ ବଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ପୁଣି, ହମୋରକୁ ଓ ତାହାର ପୁତ୍ର ଶିଖିମକୁ ଖଡ୍ଗାଘାତରେ ବଧ କରି ଶିଖିମର ଗୃହରୁ ଦୀଣାକୁ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ଯାକୁବର ପୁତ୍ରମାନେ ହତ ଲୋକମାନଙ୍କ ନିକଟକୁ ଆସି ନଗର ଲୁଟ କଲେ, କାରଣ ସେମାନଙ୍କ ଭଉଣୀକୁ ସେହି ଲୋକମାନେ ଭ୍ରଷ୍ଟା କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ପୁଣି, ସେମାନଙ୍କ ମେଷ ଓ ଗୋରୁ ଓ ଗଧସବୁ, ଆଉ ନଗରସ୍ଥ ଓ କ୍ଷେତ୍ରସ୍ଥ ସମସ୍ତ ଦ୍ରବ୍ୟ ହରଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ଆଉ ସେମାନଙ୍କ ଶିଶୁ ଓ ଭାର୍ଯ୍ୟାମାନଙ୍କୁ ବନ୍ଦୀ କରି ସମସ୍ତ ଧନ ଓ ଗୃହର ସର୍ବସ୍ୱ ଲୁଟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ତହୁଁ ଯାକୁବ ଶିମୀୟୋନ ଓ ଲେବୀକୁ କହିଲା, “ତୁମ୍ଭେମାନେ ଏ ଦେଶରେ, ଅର୍ଥାତ୍‍, କିଣାନୀୟ ଓ ପରିଷୀୟ ଲୋକମାନଙ୍କ ନିକଟରେ ମୋତେ ଦୁର୍ଗନ୍ଧ ସ୍ୱରୂପ କରି ବ୍ୟାକୁଳ କଲ; ମୋହର ଲୋକ ଅଳ୍ପ, ଏଥିପାଇଁ ସେମାନେ ମୋʼ ବିରୁଦ୍ଧରେ ଏକତ୍ର ହୋଇ ମୋତେ ବଧ କରିବେ; ତହିଁରେ ସପରିବାରରେ ବିନଷ୍ଟ ହେବି।” ");
INSERT INTO ory_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ସେମାନେ ଉତ୍ତର କଲେ, “ବେଶ୍ୟା ପରି ଆମ୍ଭମାନଙ୍କ ଭଉଣୀ ସଙ୍ଗେ ବ୍ୟବହାର କରିବା କି ତାହାର କର୍ତ୍ତବ୍ୟ?” ");
INSERT INTO ory_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ଯାକୁବଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଉଠି ବେଥେଲ୍‍କୁ ଯାଇ ସେଠାରେ ବାସ କର; ପୁଣି, ତୁମ୍ଭ ଭ୍ରାତା ଏଷୌ ସମ୍ମୁଖରୁ ପଳାଇବା ସମୟରେ ଯେଉଁ ପରମେଶ୍ୱର ଦର୍ଶନ ଦେଇଥିଲେ, ତାହାଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କର।” ");
INSERT INTO ory_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ତହିଁରେ ଯାକୁବ ଆପଣା ପରିଜନ ଓ ସଙ୍ଗୀ ଲୋକମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭମାନଙ୍କ ନିକଟରେ ଯେଉଁସବୁ ବିଦେଶୀୟ ଦେବତା ଅଛନ୍ତି, ସେମାନଙ୍କୁ ଦୂର କର, ଆପଣାମାନଙ୍କୁ ଶୁଚି କର, ପୁଣି, ଆପଣାମାନଙ୍କ ବସ୍ତ୍ର ପରିବର୍ତ୍ତନ କର। ");
INSERT INTO ory_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ପୁଣି, ଆସ, ଆମ୍ଭେମାନେ ଉଠି ବେଥେଲ୍‍କୁ ଯାଉ; ଯେଉଁ ପରମେଶ୍ୱର ମୋର ଦୁଃଖର ଦିନରେ ମୋʼ ପ୍ରାର୍ଥନାର ଉତ୍ତର ଦେଲେ, ଓ ମୋର ଗମନର ପଥରେ ମୋର ସହାୟ ହୋଇଥିଲେ, ତାହାଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମୁଁ ସେହି ସ୍ଥାନରେ ଗୋଟିଏ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ତହିଁରେ ସେମାନେ ଆପଣାମାନଙ୍କ ନିକଟସ୍ଥ ବିଦେଶୀୟ ଦେବତା ଓ କର୍ଣ୍ଣକୁଣ୍ଡଳ ସକଳ ଘେନି ଯାକୁବଙ୍କୁ ଦେଲେ, ପୁଣି, ସେ ତାହାସବୁ ନେଇ ଶିଖିମ ନିକଟବର୍ତ୍ତୀ ଅଲୋନ ବୃକ୍ଷ ମୂଳେ ଲୁଚାଇ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ଏଉତ୍ତାରେ ସେମାନେ ଯାତ୍ରା କଲେ; ସେତେବେଳେ ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ନଗରରେ ପରମେଶ୍ୱରଙ୍କଠାରୁ ଭୟ ଉପସ୍ଥିତ ହେବାରୁ ସେମାନେ ଯାକୁବଙ୍କର ପୁତ୍ରମାନଙ୍କୁ ଗୋଡ଼ାଇଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଓ ତାଙ୍କର ସଙ୍ଗୀସମୂହ କିଣାନ ଦେଶସ୍ଥ ଲୂସ୍‌ରେ, ଅର୍ଥାତ୍‍, ବେଥେଲ୍‍ରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ସେଠାରେ ସେ ଏକ ଯଜ୍ଞବେଦି ନିର୍ମାଣ କରି ସେହି ସ୍ଥାନର ନାମ ଏଲ-ବେଥେଲ୍‍ ରଖିଲେ; କାରଣ ଯାକୁବ ଭ୍ରାତୃଭୟରେ ପଳାଇବା ବେଳେ ପରମେଶ୍ୱର ସେହି ସ୍ଥାନରେ ତାଙ୍କୁ ଦର୍ଶନ ଦେଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ଆଉ ସେହି ସ୍ଥାନରେ ରିବିକାର ଦବୋରା ନାମ୍ନୀ ଧାତ୍ରୀର ମୃତ୍ୟୁୁ ହୁଅନ୍ତେ, ବେଥେଲ୍‍ର ଅଧଃସ୍ଥିତ ଅଲୋନ ବୃକ୍ଷ ମୂଳେ ତାହାର କବର ହେଲା, ପୁଣି, ସେହି ସ୍ଥାନର ନାମ ଅଲୋନ-ବାଖୁତ୍‍ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ଏଥିଉତ୍ତାରେ ଯାକୁବ ପଦ୍ଦନ୍‍ ଅରାମଠାରୁ ବାହୁଡ଼ି ଆସନ୍ତେ, ପରମେଶ୍ୱର ପୁନର୍ବାର ଦର୍ଶନ ଦେଇ ତାଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ପୁଣି, ପରମେଶ୍ୱର ତାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭର ନାମ ଯାକୁବ; ମାତ୍ର ତୁମ୍ଭର ନାମ ଆଉ ଯାକୁବ ହେବ ନାହିଁ, ତୁମ୍ଭର ନାମ ଇସ୍ରାଏଲ ହେବ;” ଆଉ ସେ ତାଙ୍କର ନାମ ଇସ୍ରାଏଲ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ପରମେଶ୍ୱର ତାଙ୍କୁ ଆହୁରି କହିଲେ, “ଆମ୍ଭେ ସର୍ବଶକ୍ତିମାନ ପରମେଶ୍ୱର; ତୁମ୍ଭେ ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ ହୁଅ; ତୁମ୍ଭଠାରୁ ଏକ ଗୋଷ୍ଠୀ, ବରଂ ଗୋଷ୍ଠୀ ସମାଜ ଉତ୍ପନ୍ନ ହେବ, ପୁଣି, ତୁମ୍ଭ କଟିଦେଶରୁ ରାଜାଗଣ ଜାତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ପୁଣି, ଆମ୍ଭେ ଅବ୍ରହାମ ଓ ଇସ୍‌ହାକକୁ ଯେଉଁ ଦେଶ ଦାନ କରିଅଛୁ, ସେହି ଦେଶ ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭ ଭବିଷ୍ୟତ ବଂଶକୁ ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ସେହି ସ୍ଥାନରେ ତାଙ୍କ ସହିତ ଏହିପରି କଥାବାର୍ତ୍ତା କରି ପରମେଶ୍ୱର ତାଙ୍କ ନିକଟରୁ ଊର୍ଦ୍ଧ୍ୱଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ତହିଁରେ ଯାକୁବ ସେହି କଥୋପକଥନର ସ୍ଥାନରେ ଏକ ସ୍ତମ୍ଭ, ଅର୍ଥାତ୍‍, ପ୍ରସ୍ତର ସ୍ତମ୍ଭ ସ୍ଥାପନ କରି ତହିଁ ଉପରେ ପାନୀୟ ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କଲେ ଓ ତୈଳ ଢାଳିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ପୁଣି, ଯାକୁବ ପରମେଶ୍ୱରଙ୍କ ସହିତ କଥୋପକଥନ ସ୍ଥାନର ନାମ ବେଥେଲ୍‍ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ଏଥିଉତ୍ତାରେ ସେମାନେ ବେଥେଲ୍‍ଠାରୁ ପ୍ରସ୍ଥାନ କଲେ, ମାତ୍ର ଇଫ୍ରାଥାରେ ଉପସ୍ଥିତ ହେବା ପାଇଁ ଅଳ୍ପ ପଥ ଥାଉ ଥାଉ ରାହେଲର ପ୍ରସବବେଦନା ହେଲା; ପୁଣି, ତାହାର ପ୍ରସବ କରିବାରେ ଅତିଶୟ କଷ୍ଟ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ଆଉ ପ୍ରସବ ବ୍ୟଥା ଅତିଶୟ ହୁଅନ୍ତେ, ଧାତ୍ରୀ ତାହାକୁ କହିଲା, “ଭୟ କର ନାହିଁ, ତୁମ୍ଭେ ଏହିଥର ମଧ୍ୟ ପୁତ୍ର ପ୍ରସବ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ତଥାପି ସେ ମଲା, ପୁଣି, ପ୍ରାଣତ୍ୟାଗ ସମୟରେ ପୁତ୍ରର ନାମ ବିନୋନୀ ରଖିଲା; ମାତ୍ର ତାହାର ପିତା ତାହାର ନାମ ବିନ୍ୟାମୀନ୍ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ଏହି ପ୍ରକାରେ ରାହେଲର ମୃତ୍ୟୁୁ ହୁଅନ୍ତେ, ଇଫ୍ରାଥା, ଅର୍ଥାତ୍‍, ବେଥଲିହିମକୁ ଯିବା ପଥ ନିକଟରେ ତାହାର କବର ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ଏଥିଉତ୍ତାରେ ଯାକୁବ ସେହି କବର ଉପରେ ଏକ ସ୍ତମ୍ଭ ସ୍ଥାପନ କଲେ; ରାହେଲ-କବରସ୍ଥ ସେହି ସ୍ତମ୍ଭ ଆଜି ପର୍ଯ୍ୟନ୍ତ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ ସେଠାରୁ ପ୍ରସ୍ଥାନ କରି ଏଦର ଗଡ଼ ପାର ହୋଇ ତହିଁ ନିକଟରେ ତମ୍ବୁ ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ସେହି ଦେଶରେ ଇସ୍ରାଏଲ ବାସ କରିବା ବେଳେ ରୁବେନ୍‍ ଯାଇ ଆପଣା ପିତାଙ୍କର ବିଲ୍‌ହା ନାମ୍ନୀ ଉପପତ୍ନୀ ସଙ୍ଗରେ ଶୟନ କଲା, ପୁଣି, ଇସ୍ରାଏଲ ତାହା ଶୁଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ଯାକୁବଙ୍କର ଦ୍ୱାଦଶ ପୁତ୍ର ଥିଲେ; ସେମାନଙ୍କ ମଧ୍ୟରେ ରୁବେନ୍‍ ଯାକୁବଙ୍କର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର, ସେ, ପୁଣି, ଶିମୀୟୋନ ଓ ଲେବୀ ଓ ଯିହୁଦା ଓ ଇଷାଖର ଓ ସବୂଲୂନ, ଏମାନେ ଲେୟାର ସନ୍ତାନ; ");
INSERT INTO ory_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ପୁଣି, ଯୋଷେଫ ଓ ବିନ୍ୟାମୀନ୍ ରାହେଲର ସନ୍ତାନ; ");
INSERT INTO ory_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ପୁଣି, ଦାନ୍ ଓ ନପ୍ତାଲି ରାହେଲର ଦାସୀ ବିଲ୍‌ହାର ସନ୍ତାନ; ");
INSERT INTO ory_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ଆଉ ଗାଦ୍‍ ଓ ଆଶେର ଲେୟାର ଦାସୀ ସିଳ୍ପାର ସନ୍ତାନ। ଯାକୁବଙ୍କର ଏହି ସମସ୍ତ ପୁତ୍ର ପଦ୍ଦନ୍‍ ଅରାମଠାରେ ଜନ୍ମିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ଏଥିଉତ୍ତାରେ କିରୀୟଥ୍‍-ଅର୍ବ, ଅର୍ଥାତ୍‍, ହିବ୍ରୋଣ ନଗରର ନିକଟବର୍ତ୍ତୀ ମମ୍ରି ନାମକ ଯେଉଁ ସ୍ଥାନରେ ଅବ୍ରହାମ ଓ ଇସ୍‌ହାକ ପ୍ରବାସ କରିଥିଲେ, ସେହି ସ୍ଥାନରେ ଯାକୁବ ଆପଣା ପିତା ଇସ୍‌ହାକ ନିକଟରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ଇସ୍‌ହାକଙ୍କର ଆୟୁର ପରିମାଣ ଏକ ଶହ ଅଶୀ ବର୍ଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ଏଥିଉତ୍ତାରେ ଇସ୍‌ହାକ ବୃଦ୍ଧ ଓ ପୂର୍ଣ୍ଣାୟୁ ହୋଇ ପ୍ରାଣତ୍ୟାଗ କରନ୍ତେ, ଆପଣା ଲୋକମାନଙ୍କ ନିକଟରେ ସଂଗୃହୀତ ହେଲେ; ପୁଣି, ତାଙ୍କର ପୁତ୍ର ଏଷୌ ଓ ଯାକୁବ ତାଙ୍କୁ କବର ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ଏଷୌର ବଂଶାବଳୀ। ତାହାର ଅନ୍ୟତମ ନାମ ଇଦୋମ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ଏଷୌ କିଣାନୀୟମାନଙ୍କର ଦୁଇ କନ୍ୟାକୁ, ଅର୍ଥାତ୍‍, ହିତ୍ତୀୟ ଏଲୋନ୍‍ର କନ୍ୟା ଆଦାକୁ ଓ ଅନାର କନ୍ୟା ହିବ୍ବୀୟ ସିବୀୟୋନ୍‍ର ପୌତ୍ରୀ ଅହଲୀବାମାକୁ, ");
INSERT INTO ory_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ତଦ୍‍ଭିନ୍ନ ନବାୟୋତ୍‍ର ଭଗିନୀକୁ, ଅର୍ଥାତ୍‍, ଇଶ୍ମାୟେଲର କନ୍ୟା ବାସମତ୍‍କୁ ବିବାହ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ଏଥିଉତ୍ତାରେ ଏଷୌର ଔରସରେ ଆଦା ଇଲୀଫସ୍‍କୁ ଓ ବାସମତ୍‍ ରୁୟେଲକୁ ପ୍ରସବ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ଆଉ ଅହଲୀବାମା, ଯିୟୂଶ୍‍, ଯାଲମ୍‍ ଓ କୋରହକୁ ପ୍ରସବ କଲା; ଏଷୌର ଏହି ସମସ୍ତ ସନ୍ତାନ କିଣାନ ଦେଶରେ ଜନ୍ମିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ଏଥିଉତ୍ତାରେ ଏଷୌ ଆପଣା ଭାର୍ଯ୍ୟାଗଣ ଓ ପୁତ୍ରକନ୍ୟାଗଣ ଓ ଗୃହସ୍ଥିତ ଅନ୍ୟାନ୍ୟ ସମସ୍ତ ଲୋକଙ୍କୁ, ପୁଣି, ଆପଣାର ସମସ୍ତ ପଶ୍ୱାଦି ଓ କିଣାନ ଦେଶରେ ଉପାର୍ଜ୍ଜିତ ସମସ୍ତ ସମ୍ପତ୍ତି ଘେନି ଆପଣା ଭ୍ରାତା ଯାକୁବ ନିକଟରୁ ଅନ୍ୟ ଦେଶକୁ ପ୍ରସ୍ଥାନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ଯେହେତୁ ସେମାନଙ୍କର ସମ୍ପତ୍ତି ପ୍ରଚୁର ଥିବାରୁ ସେମାନେ ଏକତ୍ର ବାସ କରି ପାରିଲେ ନାହିଁ, ପୁଣି, ସେମାନଙ୍କର ପଶ୍ୱାଦି ସକାଶୁ ସେହି ପ୍ରବାସ ସ୍ଥାନରେ ନିର୍ବାହ ଚଳିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ଏହିରୂପେ ଏଷୌ ସେୟୀର ପର୍ବତରେ ବାସ କଲା; ସେହି ଏଷୌର ଅନ୍ୟତମ ନାମ ଇଦୋମ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ଆଉ ସେୟୀର ପର୍ବତସ୍ଥ ଇଦୋମୀୟମାନଙ୍କର ପୂର୍ବପୁରୁଷ ଏଷୌର ବଂଶାବଳୀ। ");
INSERT INTO ory_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ଏଷୌର ସନ୍ତାନମାନଙ୍କର ନାମ ଏହି। ଏଷୌର ଆଦା ନାମ୍ନୀ ଭାର୍ଯ୍ୟାର ପୁତ୍ର ଇଲୀଫସ୍‍ ଓ ବାସମତ୍‍ ନାମ୍ନୀ ଭାର୍ଯ୍ୟାର ପୁତ୍ର ରୁୟେଲ। ");
INSERT INTO ory_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ପୁଣି, ଇଲୀଫସ୍‍ର ପୁତ୍ର ତୈମନ୍‍ ଓ ଓମାର୍ ଓ ସଫୋ ଓ ଗୟିତମ୍‍ ଓ କନସ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ପୁଣି, ଏଷୌର ପୁତ୍ର ଇଲୀଫସ୍‍ର ତିମ୍ନା ନାମ୍ନୀ ଏକ ଉପପତ୍ନୀ ଥିଲା, ସେ ଇଲୀଫସ୍‍ ଦ୍ଵାରା ଅମାଲେକକୁ ପ୍ରସବ କଲା; ଏମାନେ ଏଷୌର ପତ୍ନୀ ଆଦାର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ରୁୟେଲର ପୁତ୍ର ନହତ୍‍ ଓ ସେରହ ଓ ଶମ୍ମ ଓ ମିସା, ଏମାନେ ଏଷୌର ଭାର୍ଯ୍ୟା ବାସମତ୍‍ର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ପୁଣି, ସିବୀୟୋନ୍‍ର ପୌତ୍ରୀ ଅନାର କନ୍ୟା ଯେ ଅହଲୀବାମା, ଏଷୌର ଭାର୍ଯ୍ୟା ଥିଲା, ତାହାର ସନ୍ତାନ ଯିୟୂଶ୍‍ ଓ ଯାଲମ୍‍ ଓ କୋରହ। ");
INSERT INTO ory_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ଏଷୌର ସନ୍ତାନମାନଙ୍କ ରାଜାବଳୀ। ଏଷୌର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଯେ ଇଲୀଫସ୍‍, ତାହାର ପୁତ୍ର ରାଜା ତୈମନ୍‍ ଓ ରାଜା ଓମାର୍ ଓ ରାଜା ସଫୋ ଓ ରାଜା କନସ୍‍ ");
INSERT INTO ory_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ଓ ରାଜା କୋରହ ଓ ରାଜା ଗୟିତମ୍‍ ଓ ରାଜା ଅମାଲେକ୍‍; ଇଦୋମ ଦେଶରେ ଇଲୀଫସ୍‍ ବଂଶୀୟ ଏହି ରାଜଗଣ ଆଦାର ସନ୍ତାନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ଏଷୌର ପୁତ୍ର ରୁୟେଲର ସନ୍ତାନ ରାଜା ନହତ୍‍ ଓ ରାଜା ସେରହ ଓ ରାଜା ଶମ୍ମ ଓ ରାଜା ମିସା; ଇଦୋମ ଦେଶରେ ରୁୟେଲ ବଂଶୀୟ ଏହି ରାଜାମାନେ ଏଷୌର ଭାର୍ଯ୍ୟା ବାସମତ୍‍ର ସନ୍ତାନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ପୁଣି, ଏଷୌର ଭାର୍ଯ୍ୟା ଅହଲୀବାମାର ସନ୍ତାନ ରାଜା ଯିୟୂଶ୍‍ ଓ ରାଜା ଯାଲମ୍‍ ଓ ରାଜା କୋରହ; ଅନାର କନ୍ୟା ଯେ ଅହଲୀବାମା, ଏଷୌର ଭାର୍ଯ୍ୟା ଥିଲା, ଏମାନେ ତାହାର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ଏମାନେ ଏଷୌର, ଅର୍ଥାତ୍‍, ଇଦୋମର ସନ୍ତାନ ଓ ଏମାନେ ସେମାନଙ୍କର ରାଜା। ");
INSERT INTO ory_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","(ପୂର୍ବକାଳର) ସେହି ଦେଶ ନିବାସୀ ହୋରୀୟ ସେୟୀରର ସନ୍ତାନ ଲୋଟନ୍‍ ଓ ଶୋବଲ୍‍ ଓ ସିବୀୟୋନ୍‍ ଓ ଅନା ");
INSERT INTO ory_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ଓ ଦିଶୋନ୍‍ ଓ ଏତ୍ସର ଓ ଦୀଶନ୍‍; ସେୟୀରର ଏହି ପୁତ୍ରଗଣ ଇଦୋମ ଦେଶର ହୋରୀୟ ବଂଶଜ ରାଜା ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ଲୋଟନ୍‍ର ପୁତ୍ର ହୋରି ଓ ହେମମ୍‍, ପୁଣି, ଲୋଟନ୍‍ର ତିମ୍ନା ନାମ୍ନୀ ଭଗିନୀ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ପୁଣି, ଶୋବଲ୍‍ର ପୁତ୍ରଗଣ ଅବଲନ୍‍ ଓ ମାନହତ୍‍ ଓ ଏବଲ୍‍ ଓ ଶଫୋ ଓ ଓନମ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ପୁଣି, ସିବୀୟୋନ୍‍ର ପୁତ୍ର ଅୟା ଓ ଅନା; ଏହି ଅନା ଆପଣା ପିତା ସିବୀୟୋନ୍‍ର ଗଧ ଚରାଇବା ସମୟରେ ପ୍ରାନ୍ତରରେ ଉଷ୍ଣ ଜଳର ଝର ଆବିଷ୍କାର କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ସେହି ଅନାର ପୁତ୍ର ଦିଶୋନ୍‍ ଓ କନ୍ୟା ଅହଲୀବାମା। ");
INSERT INTO ory_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ପୁଣି, ଦିଶୋନ୍‍ର ପୁତ୍ର ହିମ୍‍ଦନ୍‍ ଓ ଇଶବନ୍‍ ଓ ଯିତ୍ରନ୍‍ ଓ କରାନ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ଏତ୍ସରର ପୁତ୍ର ବିଲ୍‍ହନ୍‍ ଓ ସାବନ୍‍ ଓ ଆକନ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ପୁଣି, ଦୀଶନ୍‍ର ପୁତ୍ର ଊଷ୍‍ ଓ ଅରାନ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ହୋରୀୟ ବଂଶଜ ରାଜା ଏହି; ରାଜା ଲୋଟନ୍‍ ଓ ରାଜା ଶୋବଲ୍‍ ଓ ରାଜା ସିବୀୟୋନ୍‍ ଓ ରାଜା ଅନା ");
INSERT INTO ory_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ଓ ରାଜା ଦିଶୋନ୍‍ ଓ ରାଜା ଏତ୍ସର ଓ ରାଜା ଦୀଶନ୍‍। ଏମାନେ ସେୟୀର ଦେଶର ହୋରୀୟ ବଂଶଜ ରାଜା ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ଆଉ, ଇସ୍ରାଏଲୀୟ ସନ୍ତାନମାନଙ୍କ ଉପରେ କୌଣସି ରାଜା ରାଜତ୍ୱ କରିବା ପୂର୍ବେ ଏହି ରାଜାମାନେ ଇଦୋମ ଦେଶରେ ରାଜ୍ୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ବିୟୋରର ବେଲା ନାମକ ପୁତ୍ର ଇଦୋମ୍‍ ଦେଶରେ ରାଜତ୍ୱ କଲା, ତାହାର ରାଜଧାନୀର ନାମ ଦିନ୍‍ହାବା। ");
INSERT INTO ory_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ବେଲାର ମରଣ ଉତ୍ତାରେ, ତାହା ପଦରେ ବସ୍ରା ନିବାସୀ ସେରହର ପୁତ୍ର ଯୋବବ୍‍ ରାଜତ୍ୱ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ପୁଣି, ଯୋବବ୍‍ର ମରଣ ଉତ୍ତାରେ ତୈମନ୍‍ ଦେଶୀୟ ହୂଶମ୍‍ ତାହା ପଦରେ ରାଜତ୍ୱ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ହୂଶମ୍‌ର ମରଣ ଉତ୍ତାରେ, ବଦଦର ପୁତ୍ର ଯେ ହଦଦ୍‍ ମୋୟାବ କ୍ଷେତ୍ରରେ ମିଦୀୟନକୁ ଜୟ କଲା, ସେ ତାହା ପଦରେ ରାଜତ୍ୱ କଲା; ତାହାର ରାଜଧାନୀର ନାମ ଅବୀତ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ହଦଦ୍‍ର ମରଣ ଉତ୍ତାରେ ମସ୍ରେକା ନିବାସୀ ସମ୍ଳ ତାହା ପଦରେ ରାଜତ୍ୱ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ପୁଣି, ସମ୍ଳର ମରଣ ଉତ୍ତାରେ (ଫରାତ୍‍) ନଦୀର ନିକଟସ୍ଥ ରହୋବୋତ୍‍ ନିବାସୀ ଶୌଲ ତାହା ପଦରେ ରାଜତ୍ୱ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ଶୌଲର ମରଣ ଉତ୍ତାରେ, ଅକ୍‍ବୋରର ପୁତ୍ର ବାଲ୍‍ହାନନ୍‍ ତାହା ପଦରେ ରାଜତ୍ୱ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ପୁଣି, ଅକ୍‍ବୋରର ପୁତ୍ର ବାଲ୍‍ହାନନ୍‍ର ମରଣ ଉତ୍ତାରେ, ହଦର ତାହା ପଦରେ ରାଜତ୍ୱ କଲା; ତାହାର ରାଜଧାନୀର ନାମ ପାଉ ଓ ତାହାର ଭାର୍ଯ୍ୟାର ନାମ ମହେଟବେଲ ଥିଲା; ସେ ମଟ୍ରେଦର ପୁତ୍ରୀ ଓ ମେଷାହବର ପୌତ୍ରୀ। ");
INSERT INTO ory_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ଏଷୌଠାରୁ ଉତ୍ପନ୍ନ, ପୁଣି, ଗୋଷ୍ଠୀ ଓ ସ୍ଥାନ ଓ ନାମ ଭେଦାନୁସାରେ ଯେଉଁ ଯେଉଁ ରାଜା ଥିଲେ, ସେମାନଙ୍କ ନାମାବଳୀ; ଯଥା, ରାଜା ତିମ୍ନା ଓ ରାଜା ଅଳ୍‍ବା ଓ ରାଜା ଯିଥେତ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ଓ ରାଜା ଅହଲୀବାମା ଓ ରାଜା ଏଲା ଓ ରାଜା ପୀନୋନ୍‍ ");
INSERT INTO ory_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ଓ ରାଜା କନସ୍‍ ଓ ରାଜା ତୈମନ୍‍ ଓ ରାଜା ମିବ୍‍ସର୍‍ ");
INSERT INTO ory_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ଓ ରାଜା ମଗ୍‍ଦୀୟେଲ ଓ ରାଜା ଈରମ୍‍; ଏମାନେ ଆପଣା ଆପଣା ଅଧିକୃତ ଦେଶରେ ବସତି ସ୍ଥାନାନୁସାରେ ଇଦୋମର ରାଜଗଣ ଥିଲେ। ଇଦୋମୀୟମାନଙ୍କ ଆଦିପୁରୁଷ ଏଷୌର ବୃତ୍ତାନ୍ତ ସମାପ୍ତ। ");
INSERT INTO ory_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ସେହି ସମୟରେ ଯାକୁବ ଆପଣା ପିତାଙ୍କର ପ୍ରବାସ ସ୍ଥାନ କିଣାନ ଦେଶରେ ବାସ କରୁଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ଯାକୁବଙ୍କର ବୃତ୍ତାନ୍ତ ଏହି। ଯୋଷେଫ, ସତର ବର୍ଷ ବୟସ ସମୟରେ, ଆପଣା ଭାଇମାନଙ୍କ ସହିତ ପଶୁପଲ ଚରାଉଥିଲେ; ସେ ଆପଣା ପିତୃଭାର୍ଯ୍ୟା ବିଲ୍‌ହା ଓ ସିଳ୍ପାର ପୁତ୍ରମାନଙ୍କର ସଙ୍ଗୀ ବାଳକ ଥିଲା; ପୁଣି, ଯୋଷେଫ ସେହି ଭାଇମାନଙ୍କ କୁବ୍ୟବହାରର ବାର୍ତ୍ତା ପିତା ନିକଟକୁ ଆଣୁଥାଏ। ");
INSERT INTO ory_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ସେହି ଯୋଷେଫ ଇସ୍ରାଏଲର ବୃଦ୍ଧାବସ୍ଥାର ସନ୍ତାନ ହେବା ସକାଶୁ ଇସ୍ରାଏଲ ସମସ୍ତ ପୁତ୍ରଠାରୁ ତାକୁ ଅଧିକ ସ୍ନେହ କଲେ, ଆଉ ତାକୁ ନାନା ବର୍ଣ୍ଣର ଏକ ଅଙ୍ଗରଖା ପ୍ରସ୍ତୁତ କରି ଦେଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ମାତ୍ର ପିତା ସମସ୍ତ ପୁତ୍ର ଅପେକ୍ଷା ଯୋଷେଫକୁ ଅଧିକ ସ୍ନେହ କରିବାର ଦେଖି ତାହାର ଭାଇମାନେ ତାକୁ ଘୃଣା କଲେ ଓ ତାହା ପ୍ରତି ପ୍ରେମର କଥା କହି ପାରିଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଗୋଟିଏ ସ୍ୱପ୍ନ ଦେଖି ଆପଣା ଭାଇମାନଙ୍କୁ କହିଲା; ଏଥିରେ ସେମାନେ ତାକୁ ଆହୁରି ଅଧିକ ଘୃଣା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","କାରଣ ସେ ସେମାନଙ୍କୁ କହିଲା, “ମୁଁ ଯେଉଁ ସ୍ୱପ୍ନ ଦେଖିଅଛି, ନିବେଦନ କରୁଅଛି, ତାହା ଶୁଣ। ");
INSERT INTO ory_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ଦେଖ, ଆମ୍ଭେମାନେ କ୍ଷେତରେ ବିଡ଼ା ବାନ୍ଧୁଥିଲୁ, ତହିଁରେ ଦେଖ, ମୋହର ବିଡ଼ା ଉଠି ଛିଡ଼ା ହେଲା; ପୁଣି, ଦେଖ, ତୁମ୍ଭମାନଙ୍କ ବିଡ଼ାସବୁ ମୋʼ ବିଡ଼ାକୁ ଚାରିଆଡ଼େ ଘେରି ପ୍ରଣାମ କଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ଏଥିରେ ତାହାର ଭାଇମାନେ ତାକୁ କହିଲେ, “ତୁ କି ସତେ ଆମ୍ଭମାନଙ୍କର ରାଜା ହେବୁ? ତୁ କି ସତେ ଆମ୍ଭମାନଙ୍କ ଉପରେ କର୍ତ୍ତୃତ୍ୱ କରିବୁ?” ତହୁଁ ସେମାନେ ତାହାର ସବୁ ସ୍ୱପ୍ନ ଓ କଥା ସକାଶୁ ତାକୁ ଆହୁରି ଅଧିକ ଘୃଣା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଆଉ ଗୋଟିଏ ସ୍ୱପ୍ନ ଦେଖି ଭାଇମାନଙ୍କୁ ଜଣାଇ କହିଲା, “ଦେଖ, ମୁଁ ଆଉ ଏକ ସ୍ୱପ୍ନ ଦେଖିଅଛି, ଦେଖ, ସୂର୍ଯ୍ୟ ଓ ଚନ୍ଦ୍ର ଓ ଏକାଦଶ ନକ୍ଷତ୍ର ମୋତେ ପ୍ରଣାମ କଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ମାତ୍ର ସେ ଆପଣା ପିତା ଓ ଭାଇମାନଙ୍କ ସାକ୍ଷାତରେ ତାହା କହନ୍ତେ, ତାହାର ପିତା ତାହାକୁ ଧମକାଇ କହିଲେ, “ତୁ ଏ କି ପ୍ରକାର ସ୍ୱପ୍ନ ଦେଖିଲୁ? ମୁଁ ଓ ତୋʼ ମାତା ଓ ତୋʼ ଭ୍ରାତୃଗଣ, ଆମ୍ଭେମାନେ କି ଭୂମିଷ୍ଠ ହୋଇ ତୋତେ ପ୍ରଣାମ କରିବାକୁ ଆସିବୁ?” ");
INSERT INTO ory_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ତହିଁରେ ତାହାର ଭାଇମାନେ ତାକୁ ଈର୍ଷା କଲେ, ମାତ୍ର ତାହାର ପିତା ସେହି କଥା ମନେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ତଦନନ୍ତର ତାହାର ଭ୍ରାତୃଗଣ ପିତାଙ୍କର ପଶୁପଲ ଚରାଇବା ପାଇଁ ଶିଖିମକୁ ଗଲା ଉତ୍ତାରେ ");
INSERT INTO ory_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ଇସ୍ରାଏଲ ଯୋଷେଫକୁ କହିଲେ, “ତୁମ୍ଭର ଭ୍ରାତୃଗଣ କି ଶିଖିମରେ ପଶୁପଲ ଚରାଉ ନାହାନ୍ତି? ଆସ, ମୁଁ ତୁମ୍ଭକୁ ସେମାନଙ୍କ ନିକଟକୁ ପଠାଇବି;” ତହିଁରେ ସେ କହିଲା, “ଦେଖନ୍ତୁ, ମୁଁ ଉପସ୍ଥିତ ଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ସେତେବେଳେ ଇସ୍ରାଏଲ ତାହାକୁ କହିଲେ, “ତୁମ୍ଭେ ଯାଇ ତୁମ୍ଭର ଭ୍ରାତୃଗଣ ଓ ପଶୁପଲ ଭଲ ଅଛନ୍ତି କି ନାହିଁ, ତାହା ଦେଖି ମୋʼ ନିକଟକୁ ସମ୍ବାଦ ଆଣ।” ଏହିରୂପେ ସେ ହିବ୍ରୋଣର ତଳ ଭୂମିରୁ ଯୋଷେଫକୁ ପଠାନ୍ତେ, ସେ ଶିଖିମରେ ଉପସ୍ଥିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ସେତେବେଳେ ଜଣେ ମନୁଷ୍ୟ ଯୋଷେଫକୁ କ୍ଷେତରେ ଏଣେତେଣେ ଭ୍ରମଣ କରିବାର ଦେଖି ପଚାରିଲା, “ତୁମ୍ଭେ କଅଣ ଖୋଜୁଅଛ?” ");
INSERT INTO ory_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ସେ କହିଲା, “ମୋʼ ଭାଇମାନଙ୍କୁ ଖୋଜୁଅଛି, ସେମାନେ କେଉଁଠାରେ ପଶୁପଲ ଚରାଉଛନ୍ତି, ଅନୁଗ୍ରହ କରି ମୋତେ କୁହ।” ");
INSERT INTO ory_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ସେ ମନୁଷ୍ୟ କହିଲା, “ସେମାନେ ଏଠାରୁ ଯାଇଅଛନ୍ତି; କାରଣ ମୁଁ ଶୁଣିଥିଲି, ‘ସେମାନେ ଦୋଥନକୁ ଯିବେ ବୋଲି କହୁଥିଲେ।’” ଏଣୁ ଯୋଷେଫ ଆପଣା ଭାଇମାନଙ୍କ ପଛେ ପଛେ ଯାଇ ଦୋଥନରେ ସେମାନଙ୍କର ଦେଖା ପାଇଲା। ");
INSERT INTO ory_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ସେମାନେ ତାହାକୁ ଦୂରରୁ ଦେଖିଲେ, ପୁଣି, ସେ ସେମାନଙ୍କ ନିକଟରେ ପହଞ୍ଚିବା ପୂର୍ବେ ସେମାନେ ତାକୁ ବଧ କରିବା ପାଇଁ ମନ୍ତ୍ରଣା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ଆଉ, ସେମାନେ ଏକ ଆରେକକୁ କହିଲେ, “ଏହି ଦେଖ, ସ୍ୱପ୍ନଦର୍ଶକ ମହାଶୟ ଆସୁଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ଆସ, ଆମ୍ଭେମାନେ ତାକୁ ବଧ କରି କୌଣସି ଏକ ଗାତରେ ପକାଇ ଦେଉ; ପୁଣି, ‘କୌଣସି ହିଂସ୍ରକ ଜନ୍ତୁ ତାକୁ ଖାଇପକାଇଲା ବୋଲି କହିବା;’ ଆଚ୍ଛା ଦେଖିବା, ତାହାର ସ୍ୱପ୍ନ ସବୁର କଅଣ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ଏ କଥା ଶୁଣି ରୁବେନ୍‍ ସେମାନଙ୍କ ହସ୍ତରୁ ତାକୁ ରକ୍ଷା କରି କହିଲା, “ନା, ଆମ୍ଭେମାନେ ତାକୁ ପ୍ରାଣରେ ମାରି ପକାଇବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ଆଉ ରୁବେନ୍‍ ସେମାନଙ୍କ ହସ୍ତରୁ ତାକୁ ରକ୍ଷା କରି ପିତା ନିକଟକୁ ଫେରି ପଠାଇବା ମାନସରେ ସେମାନଙ୍କୁ କହିଲା, “ତୁମ୍ଭେମାନେ ରକ୍ତପାତ କର ନାହିଁ, ପ୍ରାନ୍ତରର ଏହି ଗର୍ତ୍ତ ମଧ୍ୟରେ ତାକୁ ପକାଇଦିଅ, ମାତ୍ର ତାହା ପ୍ରତି ହାତ ଉଠାଅ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଭାଇମାନଙ୍କ ନିକଟକୁ ଆସନ୍ତେ, ସେମାନେ ତାହାର ଅଙ୍ଗରଖା, ସେହି ନାନା ବର୍ଣ୍ଣର ଅଙ୍ଗରଖା, ତାହା ଦେହରୁ କାଢ଼ିନେଇ; ");
INSERT INTO ory_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ତାକୁ ଧରି ଗର୍ତ୍ତ ମଧ୍ୟରେ ପକାଇଦେଲେ, ସେହି ଗର୍ତ୍ତ ଶୂନ୍ୟ, ତହିଁରେ ଜଳ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ତହୁଁ ସେମାନେ ଭୋଜନ କରିବାକୁ ବସିଲେ; ସେମାନେ ଅନାଇ ଦେଖିଲେ, ଯେ ଗିଲୀୟଦରୁ ଏକ ଦଳ ଇଶ୍ମାୟେଲୀୟ ପଥିକ ଓଟ ଉପରେ ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ ଓ ଗୁଗ୍ଗୁଳ ଓ ଗନ୍ଧରସ ଘେନି ମିସର ଦେଶକୁ ଯାଉଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ସେତେବେଳେ ଯିହୁଦା ଭାଇମାନଙ୍କୁ କହିଲା, “ଆମ୍ଭମାନଙ୍କ ଭାଇକୁ ବଧ କରି ତାହାର ରକ୍ତ ଗୋପନ କଲେ, ଆମ୍ଭମାନଙ୍କର ଲାଭ କଅଣ? ");
INSERT INTO ory_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ଆସ, ଆମ୍ଭେମାନେ ତାକୁ ଏହି ଇଶ୍ମାୟେଲୀୟ ଲୋକମାନଙ୍କୁ ବିକ୍ରୟ କରିଦେଉ, ଆମ୍ଭମାନଙ୍କ ହସ୍ତ ତାହା ପ୍ରତିକୂଳରେ ନ ଉଠୁ; କାରଣ ସେ ଆମ୍ଭମାନଙ୍କ ଭ୍ରାତା ଓ ଆମ୍ଭମାନଙ୍କ ମାଂସ ସ୍ୱରୂପ।” ତହିଁରେ ତାହାର ଭାଇମାନେ ସମ୍ମତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ସେତେବେଳେ ସେହି ମିଦୀୟନୀୟ ବଣିକମାନେ ନିକଟକୁ ଆସନ୍ତେ, ସେମାନେ ଯୋଷେଫକୁ ଗର୍ତ୍ତ ମଧ୍ୟରୁ ଉପରକୁ ଟାଣି ଆଣିଲେ; ପୁଣି, ଇଶ୍ମାୟେଲୀୟମାନଙ୍କଠାରୁ କୋଡ଼ିଏ ଶେକେଲ ରୌପ୍ୟ ମୁଦ୍ରା ନେଇ ଯୋଷେଫକୁ ବିକ୍ରୟ କରିଦେଲେ; ତହିଁରେ ସେମାନେ ଯୋଷେଫକୁ ମିସର ଦେଶକୁ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ଏଥିଉତ୍ତାରେ ରୁବେନ୍‍ ଗର୍ତ୍ତ ନିକଟକୁ ଫେରିଯାଇ ଯୋଷେଫ ଗର୍ତ୍ତ ଭିତରେ ନାହିଁ, ଏହା ଦେଖି ଆପଣା ବସ୍ତ୍ର ଚିରିଲା। ");
INSERT INTO ory_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ପୁଣି, ଭାଇମାନଙ୍କ ନିକଟକୁ ଫେରିଆସି କହିଲା, “ବାଳକଟି ନାହିଁ; ଆଉ ମୁଁ କେଉଁଠାକୁ ଯିବି?” ");
INSERT INTO ory_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ଏଥିଉତ୍ତାରେ ସେମାନେ ଯୋଷେଫର ଅଙ୍ଗରଖା ଘେନି ଗୋଟିଏ ଛାଗ ମାରି ତାହାର ରକ୍ତରେ ତାହା ଡୁବାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ଆଉ, ସେମାନେ ଆପଣା ପିତା ନିକଟକୁ ସେହି ନାନା ବର୍ଣ୍ଣର ଅଙ୍ଗରଖା ପଠାଇଦେଇ କହିଲେ, “ଆମ୍ଭେମାନେ ଏତିକି ମାତ୍ର ପାଇଲୁ, ଏହା ତୁମ୍ଭ ପୁତ୍ରର ଅଙ୍ଗରଖା କି ନାହିଁ, ଚିହ୍ନ।” ");
INSERT INTO ory_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ତହିଁରେ ସେ ତାହା ଚିହ୍ନି କହିଲେ, “ଏହି ଅଙ୍ଗରଖା ତ ମୋʼ ପୁତ୍ରର; କୌଣସି ହିଂସ୍ରକ ଜନ୍ତୁ ତାହାକୁ ଖାଇ ପକାଇଅଛି, ଯୋଷେଫ ନିଶ୍ଚୟ ଖଣ୍ଡ ଖଣ୍ଡ ହୋଇ ବିଦୀର୍ଣ୍ଣ ହୋଇଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ତହୁଁ ଯାକୁବ ଆପଣା ବସ୍ତ୍ର ଚିରି କଟିଦେଶରେ ଅଖା ପିନ୍ଧି ପୁତ୍ର ନିମନ୍ତେ ଅନେକ ଦିନ ପର୍ଯ୍ୟନ୍ତ ଶୋକ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ଏଥିଉତ୍ତାରେ ତାଙ୍କର ସମସ୍ତ ପୁତ୍ର ଓ ସମସ୍ତ କନ୍ୟା ଉଠି ତାଙ୍କୁ ସାନ୍ତ୍ୱନା କରିବାକୁ ଯତ୍ନ କଲେ; ମାତ୍ର ସେ ମାନିଲେ ନାହିଁ; ପୁଣି, ସେ କହିଲେ, “ମୁଁ ଶୋକ କରୁ କରୁ ପୁତ୍ର ନିକଟକୁ କବରକୁ ଅଧୋଗମନ କରିବି।” ଏହି ପ୍ରକାରେ ତାହାର ପିତା ତାହା ନିମନ୍ତେ ରୋଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ଏଥିମଧ୍ୟରେ ସେହି ମିଦୀୟନୀୟମାନେ ମିସର ଦେଶରେ ପୋଟୀଫର ନାମକ ଫାରୋର ଭୃତ୍ୟ, ଅର୍ଥାତ୍‍, ରକ୍ଷକ ସେନାପତିକୁ ଯୋଷେଫକୁ ବିକ୍ରୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ସେହି ସମୟରେ ଯିହୁଦା ଆପଣା ଭ୍ରାତୃଗଣ ନିକଟରୁ ଅଦୁଲ୍ଲମୀୟ ହୀରା ନାମକ ଜଣେ ଲୋକ ନିକଟକୁ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ସେଠାରେ ଶୂୟ ନାମରେ କୌଣସି କିଣାନୀୟ ଲୋକର ଗୋଟିଏ କନ୍ୟାକୁ ଦେଖି ତାକୁ ବିବାହ କରି ତାହାର ସହବାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ଏଣୁ ସେ ଗର୍ଭବତୀ ହୋଇ ପୁତ୍ର ପ୍ରସବ କରନ୍ତେ, ସେ ତାହାର ନାମ ଏର ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ଏଥିଉତ୍ତାରେ ପୁନର୍ବାର ତାହାର ଗର୍ଭ ହୁଅନ୍ତେ, ସେ ପୁତ୍ର ପ୍ରସବ କରି ତାହାର ନାମ ଓନନ୍‍ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ପୁନର୍ବାର ତାହାର ଗର୍ଭ ହୁଅନ୍ତେ, ସେ ପୁତ୍ର ପ୍ରସବ କରି ତାହାର ନାମ ଶେଲା ଦେଲା। ଏହାର ଜନ୍ମ ସମୟରେ ଯିହୁଦା କଷୀବରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ଏଥିଉତ୍ତାରେ ଯିହୁଦା ତାମର ନାମ୍ନୀ ଏକ କନ୍ୟା ଆଣି ଆପଣା ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଏର ସହିତ ତାହାକୁ ବିବାହ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ମାତ୍ର ଯିହୁଦାର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଏର ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ଦୁଷ୍ଟ ଥିଲା; ଏଣୁ ସଦାପ୍ରଭୁ ତାହାକୁ ବିନାଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ତହିଁରେ ଯିହୁଦା ଓନନ୍‍କୁ କହିଲା, “ତୁମ୍ଭେ ଆପଣା ଭ୍ରାତୃଭାର୍ଯ୍ୟାର ସହବାସ କର ଓ ତାହା ପ୍ରତି ଦେବରର କର୍ତ୍ତବ୍ୟ କର୍ମ କରି ଭ୍ରାତୃବଂଶ ଉତ୍ପନ୍ନ କର।” ");
INSERT INTO ory_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ମାତ୍ର ସେହି ବଂଶ ଆପଣାର ହେବ ନାହିଁ, ଏହା ବୁଝି ଓନନ୍‍ ଭ୍ରାତୃଭାର୍ଯ୍ୟାର ସଙ୍ଗମ କାଳେ ଭ୍ରାତୃବଂଶ ଉତ୍ପନ୍ନ କରିବା ଅନିଚ୍ଛାରେ ଭୂମିରେ ରେତଃପାତ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ତାହାର ଏରୂପ କର୍ମ ସଦାପ୍ରଭୁଙ୍କ ଦୃଷ୍ଟିରେ ମନ୍ଦ ଥିଲା; ଏଣୁ ସେ ତାକୁ ମଧ୍ୟ ନାଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ସେତେବେଳେ ଯିହୁଦା ଆପଣା ପୁତ୍ରବଧୂ ତାମରକୁ କହିଲା, “ମୋହର ପୁତ୍ର ଶେଲା ବଡ଼ ନ ହେବା ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେ ବିଧବା ହୋଇ ଆପଣା ପିତୃଗୃହରେ ଯାଇ ରୁହ,” ଯେହେତୁ ସେ ଭାବିଲା, “କେଜାଣି ଭାଇମାନଙ୍କ ପରି ଶେଲା ମଧ୍ୟ ମରିଯିବ।” ଏଥିପାଇଁ ତାମର ପିତୃଗୃହରେ ଯାଇ ବାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ଆଉ ଅନେକ ଦିନ ଗତ ହୁଅନ୍ତେ, ଶୂୟର କନ୍ୟା ଯିହୁଦାର ଭାର୍ଯ୍ୟା ମଲା; ତହିଁ ଉତ୍ତାରେ ଯିହୁଦା ସାନ୍ତ୍ୱନାଯୁକ୍ତ ହୋଇ ଅଦୁଲ୍ଲମୀୟ ହୀରା ନାମକ ବନ୍ଧୁ ସହିତ ତିମ୍ନାରେ ଆପଣା ମେଷର ଲୋମଚ୍ଛେଦକମାନଙ୍କ ନିକଟକୁ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ସେତେବେଳେ କେହି ଜଣେ ତାମରକୁ ସମ୍ବାଦ ଦେଇ କହିଲା, “ଦେଖ, ତୁମ୍ଭ ଶ୍ୱଶୁର ଆପଣା ମେଷର ଲୋମ ଚ୍ଛେଦନ କରିବା ପାଇଁ ତିମ୍ନାକୁ ଯାଉଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ତହିଁରେ ତାମର ବିଧବା ବସ୍ତ୍ର ପରିତ୍ୟାଗ କରି ଆବରକ ବସ୍ତ୍ର ପିନ୍ଧି ଆପଣାକୁ ଆଚ୍ଛାଦନ କରି ତିମ୍ନାର ପଥପାର୍ଶ୍ଵସ୍ଥିତ ଐନମର ପ୍ରବେଶ ସ୍ଥାନରେ ବସି ରହିଲା; କାରଣ ସେ ଦେଖିଲା, ଶେଲା ବଡ଼ ହେଲେ ହେଁ ତାହା ସହିତ ଆପଣାର ବିବାହ ହେଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ସେତେବେଳେ ଯିହୁଦା ତାକୁ ଦେଖି ବେଶ୍ୟା ଜ୍ଞାନ କଲା, କାରଣ ସେ ମୁଖ ଆଚ୍ଛାଦନ କରିଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ଏନିମନ୍ତେ ସେ ପଥପାର୍ଶ୍ଵରେ ତାହା ନିକଟକୁ ଯାଇ ପୁତ୍ରବଧୂକୁ ଚିହ୍ନି ନ ପାରି କହିଲା, “ନିବେଦନ କରୁଅଛି, ତୁମ୍ଭ କତିକି ମୋତେ ଯିବାକୁ ଦିଅ।” ତହୁଁ ତାମର କହିଲା, “ତୁମ୍ଭେ ମୋʼ କତିକି ଆସିବା ପାଇଁ କଅଣ ଦେବ?” ");
INSERT INTO ory_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ସେ କହିଲା, “ପଲରୁ ଗୋଟିଏ ଛେଳିଛୁଆ ପଠାଇଦେବି।” ତାମର କହିଲା, “ତାହା ପଠାଇବା ଯାଏ ମୋତେ କି କୌଣସି ବନ୍ଧକ ଦେବ?” ");
INSERT INTO ory_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ଯିହୁଦା କହିଲା, “କଅଣ ବନ୍ଧକ ଦେବା?” ତାମର କହିଲା, “ତୁମ୍ଭର ଏହି ମୋହର ଓ ସୂତ୍ର, ଆଉ ହସ୍ତଯଷ୍ଟି।” ତହୁଁ ଯିହୁଦା ତାକୁ ସେହି ସବୁ ଦେଇ ତାହା କତିକି ଗମନ କଲା, ତହିଁରେ ସେ ତାହା ଦ୍ୱାରା ଗର୍ଭବତୀ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ଏଥିଉତ୍ତାରେ ତାମର ଉଠି ପ୍ରସ୍ଥାନ କଲା, ପୁଣି, ଆବରକ ବସ୍ତ୍ର ପାଲଟି ବିଧବା ବସ୍ତ୍ର ପିନ୍ଧିଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ଏଉତ୍ତାରେ ଯିହୁଦା ସେହି ସ୍ତ୍ରୀଠାରୁ ବନ୍ଧକ ଦ୍ରବ୍ୟ ନେବା ନିମନ୍ତେ ଆପଣା ଅଦୁଲ୍ଲମୀୟ ବନ୍ଧୁ ଦ୍ୱାରା ଛେଳିଛୁଆ ପଠାଇଦେଲା, ମାତ୍ର ସେ ତାହାର ଦେଖା ପାଇଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ଏଣୁ ସେ ସେଠାର ଲୋକମାନଙ୍କୁ ପଚାରିଲା, “ଐନମ ପଥ ପାର୍ଶ୍ୱରେ ଯେଉଁ ମାହାରୀ ଥିଲା, ସେ କାହିଁ?” ସେମାନେ କହିଲେ, “ଏଠାରେ କୌଣସି ମାହାରୀ ରହେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ଏଥିଉତ୍ତାରେ ଯିହୁଦା ନିକଟକୁ ଫେରିଯାଇ କହିଲା, “ମୁଁ ତାହାର ଦେଖା ପାଇଲି ନାହିଁ, ଆଉ ସେଠାର ଲୋକମାନେ ମଧ୍ୟ କହିଲେ, ‘ଏହି ସ୍ଥାନରେ କୌଣସି ମାହାରୀ ରହେ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ତେବେ ଯିହୁଦା କହିଲା, “ତାହାଠାରେ ଯାହା ଅଛି, ସେ ତାହା ରଖୁ, ଆମ୍ଭେମାନେ କାହିଁକି ଲଜ୍ଜାସ୍ପଦ ହେବା? ଦେଖ, ମୁଁ ଏହି ଛେଳିଛୁଆ ପଠାଇଲି, ମାତ୍ର ତୁମ୍ଭେ ତାʼର ଦେଖା ପାଇଲ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ଆଉ ପ୍ରାୟ ତିନି ମାସ ଉତ୍ତାରେ କେହି ଯିହୁଦାକୁ କହିଲା, “ତୁମ୍ଭର ପୁତ୍ରବଧୂ ତାମର ବ୍ୟଭିଚାରିଣୀ ହୋଇଅଛି; ଆଉ ବ୍ୟଭିଚାର କ୍ରମେ ତାହାର ଗର୍ଭ ହୋଇଅଛି।” ତହିଁରେ ଯିହୁଦା କହିଲା, “ତାକୁ ବାହାରକୁ ଆଣି ଅଗ୍ନିରେ ଦଗ୍ଧ କର।” ");
INSERT INTO ory_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ଏଥିଉତ୍ତାରେ ସେ ବାହାରକୁ ଅଣାଯାʼନ୍ତେ, ଆପଣା ଶ୍ୱଶୁର ନିକଟକୁ କହି ପଠାଇଲା, “ଏହି ସମସ୍ତ ବସ୍ତୁ ଯାହାର, ସେହି ପୁରୁଷ ଦ୍ୱାରା ଆମ୍ଭର ଗର୍ଭ ହୋଇଅଛି।” ଆହୁରି କହିଲା, “ଏହି ମୋହର ଓ ସୂତ୍ର ଆଉ ଯଷ୍ଟି କାହାର? ତାହା ଚିହ୍ନି ଦେଖ।” ");
INSERT INTO ory_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ତହୁଁ ଯିହୁଦା ସେହି ସକଳ ପଦାର୍ଥ ଆପଣାର ବୋଲି ସ୍ୱୀକାର କରି କହିଲା, “ସେ ମୋʼ ଠାରୁ ଅଧିକ ଧର୍ମିଷ୍ଠା, କାରଣ ମୁଁ ତାକୁ ମୋର ପୁତ୍ର ଶେଲାକୁ ଦେଲି ନାହିଁ।” ମାତ୍ର ଯିହୁଦା ଆଉ ତାହା କତିକି ଗଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ପୁଣି, ତାମରର ପ୍ରସବକାଳ ଉପସ୍ଥିତ ହୁଅନ୍ତେ, ତାହାର ଉଦରରେ ଯାଆଁଳା ସନ୍ତାନ ଥିବାର ଦେଖାଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ଆଉ ତାହାର ପ୍ରସବକାଳରେ ଏକ ବାଳକର ହସ୍ତ ବାହାର ହେଲା; ତହିଁରେ ଧାତ୍ରୀ ତାହାର ସେହି ହସ୍ତରେ ସିନ୍ଦୂର ବର୍ଣ୍ଣ ସୂତ୍ର ବାନ୍ଧି କହିଲା, “ଏ ଜ୍ୟେଷ୍ଠ।” ");
INSERT INTO ory_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ମାତ୍ର ସେ ଆପଣା ହସ୍ତ ଟାଣି ନିଅନ୍ତେ, ଦେଖ, ତାହାର ଭ୍ରାତା ଭୂମିଷ୍ଠ ହେଲା; ତହିଁରେ ଧାତ୍ରୀ କହିଲା, “ତୁମ୍ଭେ କିପ୍ରକାରେ ଆପଣା ନିମନ୍ତେ ଭେଦ କରି ଆସିଲ!” ତୁମ୍ଭଠାରେ ଏହି ଭେଦ ହେଉ। ତେଣୁ ତାହାର ନାମ ପେରସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ଏଥିଉତ୍ତାରେ ହସ୍ତରେ ସିନ୍ଦୂରବର୍ଣ୍ଣ-ସୂତ୍ରବଦ୍ଧ ତାହାର ଭ୍ରାତା ଭୂମିଷ୍ଠ ହୁଅନ୍ତେ, ତାହାର ନାମ ସେରହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ଯୋଷେଫ ମିସର ଦେଶକୁ ଅଣାଯାʼନ୍ତେ, ଫାରୋଙ୍କର ଜଣେ ଭୃତ୍ୟ ଅର୍ଥାତ୍‍, ମିସରୀୟ ପୋଟୀଫର ନାମକ ରକ୍ଷକ ସେନାପତି, ତାଙ୍କର ଆନୟନକାରୀ ଇଶ୍ମାୟେଲୀୟମାନଙ୍କଠାରୁ ଯୋଷେଫଙ୍କୁ କିଣି ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ମାତ୍ର ସଦାପ୍ରଭୁ ଯୋଷେଫଙ୍କର ସହବର୍ତ୍ତୀ ଥିଲେ, ଏଣୁ ସେ ସମୃଦ୍ଧ ହେଲେ; ଆଉ ସେ ଆପଣା ମିସରୀୟ କର୍ତ୍ତାର ଗୃହରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ଏଥିରେ ସଦାପ୍ରଭୁ ତାଙ୍କର ସହବର୍ତ୍ତୀ ଅଛନ୍ତି ଓ ସେ ଯେଉଁ ଯେଉଁ କାର୍ଯ୍ୟ କଲେ, ସଦାପ୍ରଭୁ ତାଙ୍କ ହାତରେ ସେହି ସମସ୍ତ ସିଦ୍ଧ କରୁଅଛନ୍ତି, ଏହା ତାଙ୍କର କର୍ତ୍ତା ଦେଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ଏଣୁ ଯୋଷେଫ ତାହାର ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇ ତାହାର ସେବାରେ ନିଯୁକ୍ତ ହେଲେ, ପୁଣି, ସେ ଯୋଷେଫଙ୍କୁ ଆପଣାର ଗୃହାଧ୍ୟକ୍ଷ କରି ତାଙ୍କର ହସ୍ତରେ ସର୍ବସ୍ୱ ସମର୍ପଣ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ଏହି ପ୍ରକାରେ ସେ ଯୋଷେଫଙ୍କୁ ଆପଣା ଗୃହ ଓ ସର୍ବସ୍ୱର ଅଧ୍ୟକ୍ଷ କରିବା ଦିନଠାରୁ ସଦାପ୍ରଭୁ ଯୋଷେଫଙ୍କ ଲାଗି ସେହି ମିସରୀୟ ଲୋକର ଗୃହ ଉପରେ ଆଶୀର୍ବାଦ କଲେ; ପୁଣି, ଗୃହ ଓ କ୍ଷେତ୍ରସ୍ଥିତ ସମସ୍ତ ସମ୍ପଦ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର ଆଶୀର୍ବାଦ ବର୍ତ୍ତିଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ଏହେତୁ ସେ ଯୋଷେଫଙ୍କ ହସ୍ତରେ ଆପଣା ସର୍ବସ୍ୱର ଏରୂପ ଭାର ଦେଲା, ଯେ ଆପଣା ଭୋଜନ ବିନୁ ଆଉ କୌଣସି ବିଷୟର ତତ୍ତ୍ୱ ନେଲା ନାହିଁ। ଯୋଷେଫ ରୂପରେ ଓ ସୌନ୍ଦର୍ଯ୍ୟରେ ମନୋହର ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ଆଉ ଉକ୍ତ ଘଟଣା ଉତ୍ତାରେ ତାଙ୍କର ପ୍ରଭୁର ଭାର୍ଯ୍ୟା ଯୋଷେଫଙ୍କ ଉପରେ ଦୃଷ୍ଟି ପକାଇବାକୁ ଲାଗିଲା; ତହୁଁ ତାଙ୍କୁ କହିଲା, “ତୁମ୍ଭେ ମୋʼ ସଙ୍ଗେ ଶୟନ କର।” ");
INSERT INTO ory_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ମାତ୍ର ଯୋଷେଫ ଅସ୍ୱୀକାର କରି ଆପଣା ପ୍ରଭୁର ଭାର୍ଯ୍ୟାକୁ କହିଲେ, “ଦେଖ, ଏ ଗୃହରେ ଯାହା ଅଛି ମୋʼ ପ୍ରଭୁ ତହିଁର ତତ୍ତ୍ୱ ନିଅନ୍ତି ନାହିଁ, ସେ ମୋʼ ହସ୍ତରେ ଆପଣାର ସର୍ବସ୍ୱ ସମର୍ପଣ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ଏହି ଗୃହରେ ମୋʼ ଠାରୁ ବଡ଼ କେହି ନାହିଁ; ତୁମ୍ଭେ ତାଙ୍କର ଭାର୍ଯ୍ୟା, ଏନିମନ୍ତେ କେବଳ ତୁମ୍ଭ ଛଡ଼ା ମୋʼ ପ୍ରତି ଆଉ କିଛି ମନା ନାହିଁ। ଏହେତୁ ମୁଁ କିପରି ଏଡ଼େ ବଡ଼ ଦୁଷ୍ଟତା ଓ ପରମେଶ୍ୱରଙ୍କ ବିରୁଦ୍ଧରେ ପାପ କରିପାରେ?” ");
INSERT INTO ory_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ତଥାପି ସେ ସ୍ତ୍ରୀ ଦିନକୁ ଦିନ ଯୋଷେଫଙ୍କୁ ଏପରି କହେ; ମାତ୍ର ଯୋଷେଫ ତାହା ସଙ୍ଗେ ଶୟନ କରିବାକୁ କିମ୍ବା ତାହା ନିକଟରେ ରହିବାକୁ ସମ୍ମତ ହୁଅନ୍ତି ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ଏଥିଉତ୍ତାରେ ଦିନକରେ ଯୋଷେଫ ନିଜ କାର୍ଯ୍ୟ ନିମନ୍ତେ ଗୃହ ଭିତରକୁ ଗଲେ, ପୁଣି, ଗୃହର ଦାସ ମଧ୍ୟରୁ କେହି ସେଠାରେ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ତେଣୁ ସେ ଯୋଷେଫଙ୍କର ବସ୍ତ୍ର ଧରି “ମୋʼ ସଙ୍ଗେ ଶୟନ କର ବୋଲି ଟଣାଟଣି କଲା;” ମାତ୍ର ଯୋଷେଫ ତାହା ହସ୍ତରେ ଆପଣା ବସ୍ତ୍ର ଛାଡ଼ି ବାହାରକୁ ପଳାଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ଯେତେବେଳେ ସେ ସ୍ତ୍ରୀ ଯୋଷେଫଙ୍କୁ ତାହା ହସ୍ତରେ ଆପଣା ବସ୍ତ୍ର ଛାଡ଼ି ବାହାରକୁ ପଳାଇ ଯିବାର ଦେଖିଲା, ");
INSERT INTO ory_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ସେତେବେଳେ ସେ ନିଜ ଗୃହର ଲୋକମାନଙ୍କୁ ଡାକି କହିଲା, “ଦେଖ, ସେ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ପରିହାସ କରିବା ନିମନ୍ତେ ଜଣେ ଏବ୍ରୀୟକୁ ଆଣିଅଛନ୍ତି; ସେ ମୋʼ ସଙ୍ଗେ ଶୟନ କରିବା ପାଇଁ ଭିତରକୁ ମୋʼ କତିକି ଆସିଥିଲା; ତହିଁରେ ମୁଁ ବଡ଼ ପାଟି କରି ଡାକ ପକାଇଲି; ");
INSERT INTO ory_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ମୋହର ବଡ଼ ପାଟି କରି ଡାକିବାର ଶୁଣି ସେ ଆପଣା ବସ୍ତ୍ର ମୋʼ ନିକଟରେ ପକାଇଦେଇ ବାହାରକୁ ପଳାଇଗଲା।” ");
INSERT INTO ory_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ପୁଣି, ସେହି ସ୍ତ୍ରୀ ତାହାର କର୍ତ୍ତାର ଗୃହାଗମନ ପର୍ଯ୍ୟନ୍ତ ସେହି ବସ୍ତ୍ର ଆପଣା ନିକଟରେ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ଏଥିଉତ୍ତାରେ ସେ ଆପଣା ସ୍ୱାମୀକୁ ସେହି କଥାନୁସାରେ କହିଲା, “ତୁମ୍ଭେ ଯେଉଁ ଏବ୍ରୀୟ ଦାସକୁ ଆମ୍ଭମାନଙ୍କ ପାଖକୁ ଆଣିଅଛ, ସେ ମୋʼ ସଙ୍ଗେ ପରିହାସ କରିବା ନିମନ୍ତେ ମୋʼ କତିକି ଆସିଥିଲା, ");
INSERT INTO ory_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ପୁଣି, ମୁଁ ବଡ଼ ପାଟି କରି ଡାକ ପକାଇବାରୁ ସେ ମୋʼ ନିକଟରେ ଏହି ବସ୍ତ୍ର ପକାଇଦେଇ ବାହାରକୁ ପଳାଇଗଲା।” ");
INSERT INTO ory_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ସେତେବେଳେ “ତୁମ୍ଭର ଦାସ ମୋʼ ପ୍ରତି ଏପ୍ରକାର ବ୍ୟବହାର କରିଅଛି,” ଆପଣା ଭାର୍ଯ୍ୟାର ମୁଖରୁ ଏ କଥା ଶୁଣି ଯୋଷେଫଙ୍କର ପ୍ରଭୁ କ୍ରୋଧରେ ପ୍ରଜ୍ୱଳିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ଆଉ ଯୋଷେଫଙ୍କର ପ୍ରଭୁ ତାଙ୍କୁ ନେଇ ରାଜବନ୍ଦୀମାନଙ୍କ ବାସସ୍ଥାନ କାରାଗାରରେ ରଖିଲା; ତହୁଁ ଯୋଷେଫ ସେହି କାରାଗାରରେ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ମାତ୍ର ସଦାପ୍ରଭୁ ଯୋଷେଫଙ୍କର ସହବର୍ତ୍ତୀ ଥିଲେ, ପୁଣି, ତାଙ୍କ ପ୍ରତି କୃପା ପ୍ରକାଶ କରି କାରାରକ୍ଷକର ଦୃଷ୍ଟିରେ ତାଙ୍କୁ ଅନୁଗ୍ରହପାତ୍ର କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ତହିଁରେ ସେହି କାରାରକ୍ଷକ ବନ୍ଦୀଶାଳାସ୍ଥିତ ସମସ୍ତ ବନ୍ଦୀଲୋକଙ୍କ ଭାର ଯୋଷେଫଙ୍କ ହସ୍ତରେ ସମର୍ପଣ କଲା; ପୁଣି, ସେମାନେ ଯାହା କଲେ, ସେହି ସକଳର କର୍ତ୍ତା ସେ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","କାରାରକ୍ଷକ ଯୋଷେଫଙ୍କର ହସ୍ତଗତ କୌଣସି ବିଷୟରେ ଦୃଷ୍ଟିପାତ କଲା ନାହିଁ, କାରଣ ସଦାପ୍ରଭୁ ତାଙ୍କର ସହବର୍ତ୍ତୀ ଥିଲେ; ପୁଣି, ସେ ଯାହା କଲେ, ସଦାପ୍ରଭୁ ତାହା ସିଦ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ଏହିସବୁ ଘଟଣା ଉତ୍ତାରେ ମିସରୀୟ ରାଜାଙ୍କର ପାନପାତ୍ରବାହକ ଓ ସୂପକାର ଆପଣାମାନଙ୍କର ପ୍ରଭୁ ମିସରୀୟ ରାଜାଙ୍କର ପ୍ରତିକୂଳରେ ଅପରାଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ତହିଁରେ ଫାରୋ ଆପଣାର ପ୍ରଧାନ ପାନପାତ୍ରବାହକ ଓ ପ୍ରଧାନ ସୂପକାର ଏହି ଦୁଇ ଭୃତ୍ୟ ପ୍ରତି କ୍ରୁଦ୍ଧ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ଆଉ ରକ୍ଷକ ସୈନ୍ୟାଧିପତିର ଯେଉଁ ବନ୍ଦୀଗୃହରେ ଯୋଷେଫ ବନ୍ଦୀ ଥିଲେ, ସେଠାରେ ସେମାନଙ୍କୁ ବନ୍ଦୀ କରି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ତହିଁରେ ରକ୍ଷକ ସୈନ୍ୟାଧିପତି ଯୋଷେଫଙ୍କର ହସ୍ତରେ ସେମାନଙ୍କୁ ସମର୍ପଣ କରନ୍ତେ, ଯୋଷେଫ ସେମାନଙ୍କର ତତ୍ତ୍ୱାବଧାରଣ କରିବାକୁ ଲାଗିଲେ। ଏହି ପ୍ରକାରେ ସେମାନେ କିଛି ଦିନ କାରାଗାରରେ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ଏଥିଉତ୍ତାରେ ମିସରୀୟ ରାଜାଙ୍କର ସେହି କାରାବଦ୍ଧ ପାନପାତ୍ରବାହକ ଓ ସୂପକାର ଦୁଇ ଜଣ ଏକ ରାତ୍ରିରେ ଦୁଇ ପ୍ରକାର ଅର୍ଥବିଶିଷ୍ଟ ଦୁଇ ସ୍ୱପ୍ନ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ତହିଁରେ ଯୋଷେଫ ପ୍ରଭାତରେ ସେମାନଙ୍କ ନିକଟକୁ ଆସିବା ବେଳେ ସେମାନଙ୍କୁ ବିଷଣ୍ଣ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ତହୁଁ ଫାରୋଙ୍କର ଯେଉଁ ଭୃତ୍ୟମାନେ ତାଙ୍କ ସହିତ ତାଙ୍କ ପ୍ରଭୁର କାରାଗାରରେ ବନ୍ଦ ଥିଲେ, ସେମାନଙ୍କୁ ସେ ପଚାରିଲେ, “ଆଜି ତୁମ୍ଭମାନଙ୍କ ମୁଖ ବିଷଣ୍ଣ କାହିଁକି?” ");
INSERT INTO ory_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ସେମାନେ କହିଲେ, “ଆମ୍ଭେମାନେ ସ୍ୱପ୍ନ ଦେଖିଅଛୁ, ମାତ୍ର ତହିଁର ଅର୍ଥ କରିବାକୁ କେହି ନାହିଁ।” ତେବେ ଯୋଷେଫ ସେମାନଙ୍କୁ କହିଲେ, “ଅର୍ଥର ଜ୍ଞାନ କି ପରମେଶ୍ୱରଙ୍କର ଅଧୀନ ନୁହେଁ? ବିନୟ କରୁଅଛି, ତୁମ୍ଭମାନଙ୍କ ସ୍ୱପ୍ନ ମୋତେ କୁହ।” ");
INSERT INTO ory_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ତହୁଁ ପ୍ରଧାନ ପାନପାତ୍ରବାହକ ଯୋଷେଫଙ୍କୁ ଆପଣା ସ୍ୱପ୍ନ କଥା ପ୍ରକାଶ କରି କହିଲା, “ଦେଖ, ଗୋଟିଏ ଦ୍ରାକ୍ଷାଲତା ମୋʼ ସମ୍ମୁଖରେ ଥିଲା, ");
INSERT INTO ory_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ସେହି ଦ୍ରାକ୍ଷାଲତାରେ ତିନି ଶାଖା ଥିଲା, ପୁଣି, ତାହା ପଲ୍ଲବିତ ହୁଅନ୍ତେ, ତହିଁରେ ଫୁଲ ଫୁଟିଲା, ଆଉ ସକଳ ପେଣ୍ଡାରେ ପେନ୍ଥା ପେନ୍ଥା ଅଙ୍ଗୁର ପାଚିଲା। ");
INSERT INTO ory_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ସେତେବେଳେ ମୋʼ ହସ୍ତରେ ଫାରୋଙ୍କର ପାନପାତ୍ର ଥିବାରୁ ସେହି ପାତ୍ରରେ ମୁଁ ସେହି ଦ୍ରାକ୍ଷାଫଳ ଘେନି ଚିପୁଡ଼ି ଫାରୋଙ୍କର ହସ୍ତରେ ସେହି ପାତ୍ର ଦେଲି।” ");
INSERT INTO ory_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ତହିଁରେ ଯୋଷେଫ ତାହାକୁ କହିଲେ, “ଏଥିର ଅର୍ଥ ଏହି; ସେହି ତିନି ଶାଖାରେ ତିନି ଦିନ ବୁଝାଏ। ");
INSERT INTO ory_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ତିନି ଦିନ ମଧ୍ୟରେ ଫାରୋ ତୁମ୍ଭର ମସ୍ତକ ଉଠାଇ ତୁମ୍ଭକୁ ନିଜ ପଦରେ ପୁନର୍ବାର ନିଯୁକ୍ତ କରିବେ; ତହିଁରେ ତୁମ୍ଭେ ପୂର୍ବ ପରି ପାନପାତ୍ରବାହକ ହୋଇ ପୁନର୍ବାର ଫାରୋଙ୍କର ହସ୍ତରେ ପାନପାତ୍ର ଦେବ। ");
INSERT INTO ory_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ମାତ୍ର ତୁମ୍ଭର ମଙ୍ଗଳ ହେଲେ, ମୋତେ ସ୍ମରଣ କରିବ, ପୁଣି, ମୋʼ ପ୍ରତି ଦୟା କରି ଫାରୋଙ୍କ ଛାମୁରେ ମୋʼ ବିଷୟ କହି ମୋତେ ଏହି କାରାଗାରରୁ ମୁକ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","କାରଣ ଏବ୍ରୀୟମାନଙ୍କ ଦେଶରୁ ଲୋକମାନେ ମୋତେ ନିତାନ୍ତ ଚୋରି କରି ଆଣିଅଛନ୍ତି; ପୁଣି, ଏହି ସ୍ଥାନରେ ମଧ୍ୟ ମୁଁ କିଛି କରି ନାହିଁ, ତଥାପି ସେମାନେ ମୋତେ ଏହି କାରାକୂପରେ ବନ୍ଦ କରିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ତହିଁରେ ସେ ଉତ୍ତମ ଅର୍ଥ କଲେ, ପ୍ରଧାନ ସୂପକାର ଏହା ଦେଖି ଯୋଷେଫଙ୍କୁ କହିଲା, “ମୁଁ ମଧ୍ୟ ସ୍ୱପ୍ନ ଦେଖିଅଛି; ଦେଖ, ମୋʼ ମସ୍ତକ ଉପରେ ଶୁକ୍ଳ ପିଷ୍ଟକର ତିନୋଟି ଡାଲା। ");
INSERT INTO ory_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ସର୍ବଉପର ଡାଲାରେ ଫାରୋଙ୍କର ଭୋଜନ ନିମନ୍ତେ ନାନା ପ୍ରକାର ପକ୍ୱାନ୍ନ ଥିଲା; ଆଉ ପକ୍ଷୀଗଣ ଆସି ମୋର ମସ୍ତକରେ ଥିବା ଡାଲାରୁ ତାହା ଘେନି ଖାଇଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ସେତେବେଳେ ଯୋଷେଫ ଉତ୍ତର କଲେ, “ଏଥିର ଅର୍ଥ ଏହି, ସେହି ତିନି ଡାଲାରେ ତିନି ଦିନ ବୁଝାଏ। ");
INSERT INTO ory_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ତିନି ଦିନ ମଧ୍ୟରେ ଫାରୋ ତୁମ୍ଭ ଶରୀରରୁ ତୁମ୍ଭ ମସ୍ତକ ଉଠାଇ ତୁମ୍ଭକୁ ବୃକ୍ଷ ଉପରେ ଟଙ୍ଗାଇବେ, ପୁଣି, ପକ୍ଷୀଗଣ ଆସି ତୁମ୍ଭ ଗାତ୍ରରୁ ତୁମ୍ଭ ମାଂସ ଖାଇବେ।” ");
INSERT INTO ory_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ଏଥିଉତ୍ତାରେ ତୃତୀୟ ଦିନରେ ଫାରୋଙ୍କର ଜନ୍ମ ଦିନ ଉପସ୍ଥିତ ହେବାରୁ ସେ ଆପଣା ସମସ୍ତ ଦାସଙ୍କ ନିମନ୍ତେ ଭୋଜ ପ୍ରସ୍ତୁତ କଲେ। ତହିଁରେ ସେ ଆପଣା ସମସ୍ତ ଦାସଙ୍କ ସାକ୍ଷାତରେ ପ୍ରଧାନ ପାନପାତ୍ର ବାହକର ଓ ପ୍ରଧାନ ସୂପକାରର ମସ୍ତକ ଉଠାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ପୁଣି, ଯୋଷେଫଙ୍କର କଥିତ ଅର୍ଥାନୁସାରେ ଫାରୋ ପ୍ରଧାନ ପାନପାତ୍ର ବାହାକକୁ ତାହାର ନିଜ ପଦରେ ପୁନର୍ବାର ନିଯୁକ୍ତ କଲେ; ତହିଁରେ ସେ ଫାରୋଙ୍କର ହସ୍ତରେ ପାନପାତ୍ର ଦେବାକୁ ଲାଗିଲା। ");
INSERT INTO ory_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ମାତ୍ର ସେ ପ୍ରଧାନ ସୂପକାରକୁ ବୃକ୍ଷରେ ଟଙ୍ଗାଇଲେ; ");
INSERT INTO ory_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ତଥାପି, ପ୍ରଧାନ ପାନପାତ୍ରବାହକ ଯୋଷେଫଙ୍କୁ ସ୍ମରଣ କଲା ନାହିଁ, ମାତ୍ର ତାଙ୍କୁ ପାସୋରି ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ଏଥିଉତ୍ତାରେ ସମ୍ପୂର୍ଣ୍ଣ ଦୁଇ ବର୍ଷ ଶେଷରେ ଫାରୋ ଏହି ସ୍ୱପ୍ନ ଦେଖିଲେ; ଦେଖ, ସେ ନୀଳ ନଦୀ କୂଳରେ ଠିଆ ହୋଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ଆଉ ଦେଖ, ନଦୀ ଭିତରୁ ସାତୋଟି ହୃଷ୍ଟପୁଷ୍ଟ ସୁନ୍ଦର ଗୋରୁ ଉଠି ନଳ-ତୃଣ ମଧ୍ୟରେ ଚରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ସେମାନଙ୍କ ଉତ୍ତାରେ ଦେଖ, ଅନ୍ୟ ସାତୋଟି କୃଶ ଓ କୁତ୍ସିତ ଗୋରୁ ନଦୀରୁ ଉଠି ନଦୀ ତଟରେ ସେହି ଗୋରୁମାନଙ୍କ ପାଖରେ ଠିଆ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ତହିଁରେ ସେହି ଦୁର୍ବଳ ଓ କୁତ୍ସିତ ଗୋରୁ ସେହି ସାତୋଟି ହୃଷ୍ଟପୁଷ୍ଟ ସୁନ୍ଦର ଗୋରୁଙ୍କୁ ଖାଇ ପକାଇଲେ। ଏପରି ସମୟରେ ଫାରୋଙ୍କର ନିଦ୍ରା ଭଙ୍ଗ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ତହିଁ ଉତ୍ତାରେ ସେ ନିଦ୍ରିତ ହୋଇ ଦ୍ୱିତୀୟ ଥର ସ୍ୱପ୍ନ ଦେଖିଲେ; ଗୋଟିଏ ଡେମ୍ଫରେ ସାତୋଟି ପରିପୁଷ୍ଟ ଓ ଉତ୍ତମ ଶିଷା ବାହାରିଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ସେମାନଙ୍କ ଉତ୍ତାରେ ପୂର୍ବୀୟ ବାୟୁରେ ଶୁଷ୍କ ଆଉ ସାତୁଟା କ୍ଷୀଣ ଶିଷା ଉତ୍ପନ୍ନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ପୁଣି, ସେହି ସାତୁଟା କ୍ଷୀଣ ଶିଷା ଏହି ସାତୋଟି ପରିପୁଷ୍ଟ ଓ ପୂର୍ଣ୍ଣ ଶିଷାକୁ ଗ୍ରାସ କଲା। ଏପରି ସମୟରେ ଫାରୋଙ୍କର ନିଦ୍ରା ଭଙ୍ଗ ହୁଅନ୍ତେ, ସ୍ୱପ୍ନ-ମାତ୍ର ଜ୍ଞାତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ପୁଣି, ପ୍ରଭାତରେ ତାଙ୍କର ମନ ଉଦ୍‍ବିଗ୍ନ ହେଲା, ତହୁଁ ସେ ଲୋକ ପଠାଇ ମିସର ଦେଶୀୟ ମନ୍ତ୍ରଜ୍ଞ ଓ ପଣ୍ଡିତ ସମସ୍ତଙ୍କୁ ଡକାଇଲେ; ମାତ୍ର ଫାରୋ ସେମାନଙ୍କ ନିକଟରେ ଆପଣା ସ୍ୱପ୍ନର କଥା କହନ୍ତେ, ସେମାନଙ୍କ ମଧ୍ୟରୁ କେହି ଫାରୋଙ୍କୁ ତହିଁର ଅର୍ଥ କହି ପାରିଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ସେତେବେଳେ ପ୍ରଧାନ ପାନପାତ୍ରବାହକ ଫାରୋଙ୍କ ଛାମୁରେ ନିବେଦନ କଲା, “ଆଜି ମୁଁ ନିଜ ଅପରାଧ ସ୍ମରଣ କରୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ଫାରୋ ଆପଣା ଦାସ ମୋʼ ପ୍ରତି ଓ ପ୍ରଧାନ ସୂପକାର ପ୍ରତି କ୍ରୋଧାନ୍ୱିତ ହୋଇ ଆମ୍ଭମାନଙ୍କୁ ରକ୍ଷକ ସୈନ୍ୟାଧିପତିର କାରାଗାରରେ ବନ୍ଦ କରି ରଖିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ତହିଁରେ ଆମ୍ଭେ ଦୁହେଁ ଏକ ରାତ୍ରିରେ ସ୍ୱପ୍ନ ଦେଖିଲୁ; ପୁଣି, ଦୁହିଁଙ୍କ ସ୍ୱପ୍ନର ଦୁଇ ପ୍ରକାର ଅର୍ଥ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ସେଠାରେ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ରକ୍ଷକ ସୈନ୍ୟାଧିପତିର ଦାସ ଜଣେ ଏବ୍ରୀୟ ଯୁବା ଥିଲା; ଆମ୍ଭେମାନେ ତାକୁ ସ୍ୱପ୍ନର କଥା କହନ୍ତେ, ସେ ଆମ୍ଭମାନଙ୍କୁ ତହିଁର ଅର୍ଥ କହିଲା, ପ୍ରତ୍ୟେକ ଜଣର ସ୍ୱପ୍ନାନୁସାରେ ଅର୍ଥ କହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ତହିଁରେ ସେ ଆମ୍ଭ ଦୁହିଁଙ୍କୁ ଯେରୂପ ଅର୍ଥ କହିଥିଲା, ତଦ୍ରୂପ ଘଟିଲା; ମୁଁ ପୂର୍ବ ପଦରେ ନିଯୁକ୍ତ ହେଲି ଓ ସେ ଫାଶୀ ପାଇଲା।” ");
INSERT INTO ory_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ସେତେବେଳେ ଫାରୋ ଯୋଷେଫଙ୍କୁ ଡକାଇ ପଠାନ୍ତେ, ଲୋକମାନେ କାରାଗାରରୁ ତାଙ୍କୁ ଶୀଘ୍ର ଆଣିଲେ; ସେ କ୍ଷୌରକର୍ମ କରି ଓ ଉତ୍ତମ ବସ୍ତ୍ର ପିନ୍ଧି ଫାରୋଙ୍କ ଛାମୁରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ତହୁଁ ଫାରୋ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ଗୋଟିଏ ସ୍ୱପ୍ନ ଦେଖିଅଛୁ, କେହି ତହିଁର ଅର୍ଥ କରି ପାରୁ ନାହାନ୍ତି; ମାତ୍ର ଆମ୍ଭେ ତୁମ୍ଭ ବିଷୟରେ ଶୁଣିଅଛୁ, ଯେ ତୁମ୍ଭେ ସ୍ୱପ୍ନ ଶୁଣିଲେ, ତହିଁର ଅର୍ଥ କରିପାର।” ");
INSERT INTO ory_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ତହିଁରେ ଯୋଷେଫ କହିଲେ, “ତାହା ମୋହର ଆୟତ୍ତ ନୁହେଁ, ମାତ୍ର ପରମେଶ୍ୱର ଫାରୋଙ୍କୁ ମାଙ୍ଗଳିକ ଉତ୍ତର ଦେବେ।” ");
INSERT INTO ory_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ତହୁଁ ଫାରୋ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ଆମ୍ଭ ସ୍ୱପ୍ନରେ, ଦେଖ, ଆମ୍ଭେ ନଦୀ ତଟରେ ଠିଆ ହୋଇଥିଲୁ। ");
INSERT INTO ory_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ତହିଁରେ ନଦୀ ଭିତରୁ ସାତୋଟି ହୃଷ୍ଟପୁଷ୍ଟ ସୁନ୍ଦର ଗୋରୁ ଉଠି ନଳ-ତୃଣ ମଧ୍ୟରେ ଚରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ଏଥିଉତ୍ତାରେ ସେମାନଙ୍କ ଉତ୍ତାରେ ଆଉ ସାତୋଟି ଦୁର୍ବଳ ଅତି କୁତ୍ସିତ ଓ କୃଶାଙ୍ଗ ଗୋରୁ ଉଠି ଆସିଲେ; ଆମ୍ଭେ ସେମାନଙ୍କ ପରି କୁତ୍ସିତ ଗୋରୁ ସମୁଦାୟ ମିସର ଦେଶରେ କଦାପି ଦେଖି ନାହୁଁ। ");
INSERT INTO ory_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ପୁଣି, ସେହି କ୍ଷୀଣ କୁତ୍ସିତ ଗୋରୁ ପୂର୍ବର ହୃଷ୍ଟପୁଷ୍ଟ ସେହି ସାତୋଟି ଗୋରୁଙ୍କୁ ଖାଇ ପକାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ମାତ୍ର ଖାଇଲା ଉତ୍ତାରେ ସେମାନଙ୍କ ପେଟ ଖାଇଲା ପରି ଜଣାଗଲା ନାହିଁ; ସେମାନେ ପୂର୍ବ ପରି କୁତ୍ସିତ ରହିଲେ। ଏପରି ସମୟରେ ଆମ୍ଭର ନିଦ୍ରା ଭଙ୍ଗ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ଏଥିଉତ୍ତାରେ ଆମ୍ଭେ ସ୍ୱପ୍ନରେ ଦେଖିଲୁ ଯେ, ଦେଖ, ଗୋଟିଏ ଶଣ୍ଢାରେ ସାତୋଟି ପୂର୍ଣ୍ଣ ଓ ଉତ୍ତମ ଶିଷା ବାହାରିଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ତହିଁ ଉତ୍ତାରେ ପୂର୍ବୀୟ ବାୟୁରେ ଶୁଷ୍କ, କ୍ଷୀଣ ଓ ମ୍ଳାନ ସାତୋଟି ଶିଷା ଉତ୍ପନ୍ନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ପୁଣି, ସେହି କ୍ଷୀଣ ଶିଷା, ସେହି ଉତ୍ତମ ସାତ ଶିଷାକୁ ଗ୍ରାସ କଲା। ଏହି ସ୍ୱପ୍ନ ଆମ୍ଭେ ମନ୍ତ୍ରଜ୍ଞମାନଙ୍କୁ କହିଲୁ, ମାତ୍ର କେହି ଏଥିର ଅର୍ଥ ଆମ୍ଭକୁ କହି ପାରିଲେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ତେବେ ଯୋଷେଫ ଫାରୋଙ୍କୁ କହିଲେ, “ଫାରୋଙ୍କର ସ୍ୱପ୍ନ ଏକ; ପରମେଶ୍ୱର ଯାହା କରିବାକୁ ଉଦ୍ୟତ, ତାହା ଫାରୋଙ୍କ ପ୍ରତି ପ୍ରକାଶ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ସେହି ସାତୋଟି ଉତ୍ତମ ଗୋରୁ ସାତ ବର୍ଷ ସ୍ୱରୂପ, ପୁଣି, ସେହି ସାତୋଟି ଉତ୍ତମ ଶିଷା ମଧ୍ୟ ସାତ ବର୍ଷ ସ୍ୱରୂପ, ସ୍ୱପ୍ନ ଏକମାତ୍ର। ");
INSERT INTO ory_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ତହିଁ ପଶ୍ଚାତ୍‍ ଉତ୍ଥିତ ସେହି ସାତୋଟି କ୍ଷୀଣ କୁତ୍ସିତ ଗୋରୁ ସାତ ବର୍ଷ ସ୍ୱରୂପ; ଆଉ ପୂର୍ବୀୟ ବାୟୁରେ ଶୁଷ୍କ ସାତୋଟି ଶିଷା ମଧ୍ୟ ଦୁର୍ଭିକ୍ଷର ସାତ ବର୍ଷ ସ୍ୱରୂପ। ");
INSERT INTO ory_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ମୁଁ ଫାରୋଙ୍କୁ କହିଅଛି: ପରମେଶ୍ୱର ଯାହା କରିବାକୁ ଉଦ୍ୟତ, ତାହା ଫାରୋଙ୍କୁ ଦେଖାଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ଦେଖନ୍ତୁ, ସମସ୍ତ ମିସର ଦେଶରେ ସାତ ବର୍ଷ ମହା ସୁଭିକ୍ଷ ଆସୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ତହିଁ ପଛେ ସାତ ବର୍ଷ ଦୁର୍ଭିକ୍ଷ ପଡ଼ିବ; ସମସ୍ତ ସୁଭିକ୍ଷ ମିସର ଦେଶରୁ ବିସ୍ମୃତ ହେବ; ଦୁର୍ଭିକ୍ଷ ଦେଶକୁ ଧ୍ୱଂସ କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ପୁଣି, ପଶ୍ଚାଦ୍‍ବର୍ତ୍ତୀ ଦୁର୍ଭିକ୍ଷ ସକାଶୁ ଦେଶରେ ସୁଭିକ୍ଷ ଜଣା ପଡ଼ିବ ନାହିଁ; କାରଣ ତାହା ଅତି ଭାରୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ଫାରୋ ଦୁଇ ଥର ସ୍ୱପ୍ନ ଦେଖିବାର ଭାବ ଏହି ଯେ, ପରମେଶ୍ୱରଙ୍କ ଦ୍ୱାରା ତାହା ନିଶ୍ଚିତ ହୋଇଅଛି, ପୁଣି, ପରମେଶ୍ୱର ତାହା ଶୀଘ୍ର ଘଟାଇବେ। ");
INSERT INTO ory_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ଏଥିପାଇଁ ଏବେ ଫାରୋ ଜଣେ ବୁଦ୍ଧିମାନ ଜ୍ଞାନୀ ପୁରୁଷ ଦେଖି ମିସର ଦେଶ ଉପରେ ନିଯୁକ୍ତ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ଫାରୋ ଏହା କରନ୍ତୁ, ଆଉ ଦେଶରେ ଅଧ୍ୟକ୍ଷଗଣ ନିଯୁକ୍ତ କରି ସାତ ବର୍ଷ ସୁଭିକ୍ଷ ସମୟରେ ମିସର ଦେଶରୁ ଶସ୍ୟର ପଞ୍ଚମାଂଶ ଗ୍ରହଣ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ଅର୍ଥାତ୍‍, ସେମାନେ ସେହି ଆଗାମୀ ଉତ୍ତମ ବର୍ଷର ସବୁ ଭକ୍ଷ୍ୟ ସଂଗ୍ରହ କରନ୍ତୁ, ପୁଣି, ପ୍ରତି ନଗରରେ ଖାଦ୍ୟ ନିମନ୍ତେ ଫାରୋଙ୍କ ହସ୍ତାଧୀନରେ ଶସ୍ୟ ସଞ୍ଚୟ କରି ରକ୍ଷା କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ଏହିରୂପେ ମିସର ଦେଶରେ ଭବିଷ୍ୟତ ଦୁର୍ଭିକ୍ଷର ସାତ ବର୍ଷ ନିମନ୍ତେ ଦେଶର ନିର୍ବାହାର୍ଥେ ସେହି ଭକ୍ଷ୍ୟ ସଞ୍ଚିତ ଥିଲେ, ଦୁର୍ଭିକ୍ଷ ଦ୍ୱାରା ଦେଶ ଉଚ୍ଛିନ୍ନ ହେବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ସେତେବେଳେ ଫାରୋଙ୍କର ଓ ତାଙ୍କର ଦାସମାନଙ୍କ ଦୃଷ୍ଟିରେ ଏହି କଥା ଉତ୍ତମ ବୋଧ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ତହିଁରେ ଫାରୋ ଆପଣା ଦାସମାନଙ୍କୁ କହିଲେ, “ଆମ୍ଭେମାନେ କି ଏହାଙ୍କ ପରି ପୁରୁଷ ଆଉ ପାଇ ପାରିବା? ଏହାଙ୍କଠାରେ ପରମେଶ୍ୱରଙ୍କ ଆତ୍ମା ଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ତହୁଁ ଫାରୋ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ପରମେଶ୍ୱର ତୁମ୍ଭକୁ ଏସମସ୍ତ ଜଣାଇଛନ୍ତି, ଏଣୁ ତୁମ୍ଭ ପରି ବୁଦ୍ଧିମାନ ଓ ଜ୍ଞାନୀ କେହି ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ତୁମ୍ଭେ ଆମ୍ଭର ଗୃହାଧ୍ୟକ୍ଷ ହୁଅ; ଆମ୍ଭର ସମସ୍ତ ପ୍ରଜା ତୁମ୍ଭର ବାକ୍ୟ ଶିରୋଧାର୍ଯ୍ୟ କରିବେ, କେବଳ ସିଂହାସନରେ ଆମ୍ଭେ ତୁମ୍ଭଠାରୁ ବଡ଼ ଥିବା।” ");
INSERT INTO ory_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ଫାରୋ ଯୋଷେଫଙ୍କୁ ଆହୁରି କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ସମୁଦାୟ ମିସର ଦେଶ ଉପରେ ନିଯୁକ୍ତ କଲୁ।” ");
INSERT INTO ory_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ଏଥିଉତ୍ତାରେ ଫାରୋ ଆପଣା ହସ୍ତରୁ ନିଜ ସନ୍ତକ-ଅଙ୍ଗୁରୀୟ କାଢ଼ି ଯୋଷେଫଙ୍କ ହସ୍ତରେ ଦେଇ ତାଙ୍କୁ ସୂକ୍ଷ୍ମବସ୍ତ୍ର ପିନ୍ଧାଇ ତାଙ୍କ ଗଳାରେ ସୁବର୍ଣ୍ଣ ହାର ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ପୁଣି, ତାଙ୍କୁ ଆପଣା ଦ୍ୱିତୀୟ ରଥରେ ଆରୋହଣ କରାଇଲେ; ଆଉ ଲୋକମାନେ ତାଙ୍କର ଆଗେ ଆଗେ “ଆଣ୍ଠୁ ପାତ ଆଣ୍ଠୁ ପାତ” ବୋଲି ଘୋଷଣା କଲେ। ଏହି ପ୍ରକାରେ ସେ ତାଙ୍କୁ ସମସ୍ତ ମିସର ଦେଶ ଉପରେ ନିଯୁକ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ଏଥିଉତ୍ତାରେ ଫାରୋ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ଫାରୋ ଅଟୁ, ଏହେତୁ ତୁମ୍ଭ ଆଜ୍ଞା ବିନୁ ସମସ୍ତ ମିସର ଦେଶରେ କୌଣସି ଲୋକ ହାତ ଗୋଡ଼ ଉଠାଇ ପାରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ପୁଣି, ଫାରୋ ଯୋଷେଫଙ୍କର ନାମ “ସାଫନତ୍‍-ପାନେହ ରଖିଲେ;” ପୁଣି, ଓନ୍‍ ନଗର ନିବାସୀ ପୋଟୀଫେର ନାମକ ଯାଜକର ଆସନତ୍‍ ନାମ୍ନୀ କନ୍ୟା ସହିତ ତାଙ୍କର ବିବାହ ଦେଲେ। ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ସମୁଦାୟ ମିସର ଦେଶରେ ଗମନାଗମନ କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ଯୋଷେଫ ତିରିଶ ବର୍ଷ ବୟସ ସମୟରେ ମିସରୀୟ ରାଜା ଫାରୋଙ୍କ ଛାମୁରେ ଠିଆ ହୋଇଥିଲେ; ତାହା ପରେ ଯୋଷେଫ ଫାରୋଙ୍କ ନିକଟରୁ ପ୍ରସ୍ଥାନ କରି ମିସର ଦେଶର ସର୍ବତ୍ର ଭ୍ରମଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ଏଥିଉତ୍ତାରେ ସେହି ସୁଭିକ୍ଷର ସାତ ବର୍ଷ ଭୂମିରେ ଅପାର ଅପାର ଶସ୍ୟ ଉତ୍ପନ୍ନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ଯୋଷେଫ ସେହି ସାତ ବର୍ଷରେ ମିସର ଦେଶରେ ଉତ୍ପନ୍ନ ସକଳ ଶସ୍ୟ ସଂଗ୍ରହ କରି ପ୍ରତି ନଗରରେ ସଞ୍ଚୟ କଲେ; ପୁଣି, ଯେଉଁ ଯେଉଁ ନଗରର ଚାରିଆଡ଼ ଭୂମିରେ ଯେତେ ଶସ୍ୟ ଉତ୍ପନ୍ନ ହେଲା, ତାହାସବୁ ସେହି ସେହି ନଗରରେ ସଞ୍ଚୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ଏହି ପ୍ରକାରେ ଯୋଷେଫ ସମୁଦ୍ରର ବାଲି ପରି ଏତେ ବହୁଳ ଶସ୍ୟ ସଂଗ୍ରହ କଲେ ଯେ, ତାହା ଆଉ ମାପିଲେ ନାହିଁ; କାରଣ ତାହା ଅପରିମେୟ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ଆଉ ଦୁର୍ଭିକ୍ଷ ବର୍ଷ ପୂର୍ବରେ ଯୋଷେଫଙ୍କର ଦୁଇ ପୁତ୍ର ଜାତ ହୋଇଥିଲେ, ଓନ୍‍ ନଗର ନିବାସୀ ପୋଟୀଫେର ଯାଜକର ଆସନତ୍‍ ନାମ୍ନୀ କନ୍ୟା ସେମାନଙ୍କୁ ଜନ୍ମ କରିଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ତହିଁରେ ଯୋଷେଫ ଜ୍ୟେଷ୍ଠର ନାମ ମନଃଶି ରଖିଲେ, କାରଣ ସେ କହିଲେ, “ପରମେଶ୍ୱର ମୋହର ସମସ୍ତ କ୍ଳେଶର ଓ ନିଜ ପିତୃଗୃହର ବିସ୍ମୃତି ଜନ୍ମାଇ ଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ପୁଣି, ଦ୍ୱିତୀୟ ପୁତ୍ରର ନାମ ଇଫ୍ରୟିମ ରଖିଲେ, କାରଣ ସେ କହିଲେ, “ମୋହର ଦୁଃଖଭୋଗର ଦେଶରେ ପରମେଶ୍ୱର ମୋତେ ଫଳବାନ କରିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ଏଥିଉତ୍ତାରେ ମିସର ଦେଶରେ ଘଟିତ ସୁଭିକ୍ଷର ସାତ ବର୍ଷ ଶେଷ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ପୁଣି, ଯୋଷେଫଙ୍କ ବାକ୍ୟାନୁସାରେ ଦୁର୍ଭିକ୍ଷର ସାତ ବର୍ଷର ଆରମ୍ଭ ହେଲା; ତହିଁରେ ଅନ୍ୟ ସମସ୍ତ ଦେଶରେ ଦୁର୍ଭିକ୍ଷ ପଡ଼ିଲା, ମାତ୍ର ସମୁଦାୟ ମିସର ଦେଶରେ ଆହାର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ପୁଣି, ସମୁଦାୟ ମିସର ଦେଶରେ ଦୁର୍ଭିକ୍ଷ ପଡ଼ନ୍ତେ, ପ୍ରଜାମାନେ ଆହାର ନିମନ୍ତେ ଫାରୋଙ୍କ ନିକଟରେ ଡକା ପକାଇଲେ; ତହିଁରେ ଫାରୋ ସମସ୍ତ ମିସରୀୟ ଲୋକଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଯୋଷେଫ ନିକଟକୁ ଯାଅ; ସେ ଯାହା କହନ୍ତି, ତାହା କର।” ");
INSERT INTO ory_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ସେତେବେଳେ ସର୍ବଦେଶରେ ଦୁର୍ଭିକ୍ଷ ହୁଅନ୍ତେ, ଯୋଷେଫ ସବୁ ସ୍ଥାନର ଗୋଲା ଫିଟାଇ ମିସରୀୟମାନଙ୍କୁ ଶସ୍ୟ ବିକ୍ରୟ କରିବାକୁ ଲାଗିଲେ; ତଥାପି ମିସର ଦେଶରେ ଦୁର୍ଭିକ୍ଷ ପ୍ରବଳ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ପୁଣି, ସର୍ବଦେଶୀୟ ଲୋକମାନେ ମିସର ଦେଶରେ ଶସ୍ୟ କିଣିବା ପାଇଁ ଯୋଷେଫଙ୍କ ନିକଟକୁ ଆସିଲେ। ଯେହେତୁ ସବୁ ଦେଶରେ ଦୁର୍ଭିକ୍ଷ ପ୍ରବଳ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ଆଉ ମିସର ଦେଶରେ ଶସ୍ୟ ଅଛି, ଏହି କଥା ଶୁଣି ଯାକୁବ ଆପଣା ପୁତ୍ରମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ କାହିଁକି ପରସ୍ପର ପ୍ରତି ଅନାଇ ରହୁଅଛ?” ");
INSERT INTO ory_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ସେ ଆହୁରି କହିଲେ, “ଦେଖ, ମୁଁ ଶୁଣିଲି, ମିସର ଦେଶରେ ଶସ୍ୟ ଅଛି; ଏଣୁ ତୁମ୍ଭେମାନେ ସେଠାକୁ ଯାଇ ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଶସ୍ୟ କିଣି ଆଣ; ତହିଁରେ ଆମ୍ଭେମାନେ ନ ମରି ବଞ୍ଚିବା।” ");
INSERT INTO ory_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ଏଥିଉତ୍ତାରେ ଯୋଷେଫଙ୍କର ଦଶ ଭ୍ରାତା ଶସ୍ୟ କିଣିବା ନିମନ୍ତେ ମିସର ଦେଶକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ମାତ୍ର ଯାକୁବ ଯୋଷେଫଙ୍କର ସହୋଦର ବିନ୍ୟାମୀନ୍‍କୁ ଭାଇମାନଙ୍କ ସଙ୍ଗରେ ପଠାଇଲେ ନାହିଁ; କାରଣ ସେ କହିଲେ, “କେଜାଣି ଅବା ଏହାକୁ ବିପତ୍ତି ଘଟେ।” ");
INSERT INTO ory_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ସେତେବେଳେ ସେଠାକୁ ଯିବା ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଇସ୍ରାଏଲଙ୍କର ପୁତ୍ରମାନେ ଶସ୍ୟ କିଣିବା ନିମନ୍ତେ ଗଲେ; ଯେହେତୁ କିଣାନ ଦେଶରେ ମଧ୍ୟ ଦୁର୍ଭିକ୍ଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ସେହି ସମୟରେ ଯୋଷେଫ ସେହି ଦେଶର ଅଧ୍ୟକ୍ଷ ହେବାରୁ ଦେଶୀୟ ଲୋକ ସମସ୍ତଙ୍କୁ ଶସ୍ୟ ବିକ୍ରୟ କରୁଥିଲେ; ତହିଁରେ ଯୋଷେଫଙ୍କର ଭ୍ରାତୃଗଣ ଆସି ତାଙ୍କୁ ଭୂମିଷ୍ଠ ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ସେତେବେଳେ ଯୋଷେଫ ଆପଣା ଭାଇମାନଙ୍କୁ ଦେଖି ଚିହ୍ନିଲେ, ମାତ୍ର ସେମାନଙ୍କ ଆଗରେ ଅପରିଚିତ ଲୋକ ପରି ବ୍ୟବହାର କରି କଟୁ କଥାରେ କହିଲେ, “ତୁମ୍ଭେମାନେ କେଉଁଠାରୁ ଆସିଅଛ?” ସେମାନେ କହିଲେ, “କିଣାନ ଦେଶରୁ ଖାଦ୍ୟଦ୍ରବ୍ୟ କିଣିବାକୁ ଆସିଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ମାତ୍ର ଯୋଷେଫ ଆପଣା ଭାଇମାନଙ୍କୁ ଚିହ୍ନିଲେ ହେଁ ସେମାନେ ତାଙ୍କୁ ଚିହ୍ନି ପାରିଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ତହୁଁ ଯୋଷେଫ ସେମାନଙ୍କ ବିଷୟରେ ଯେସବୁ ସ୍ୱପ୍ନ ଦେଖିଥିଲେ, ତାହା ସ୍ମରଣ କରି ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଚୋର ଲୋକ; ଦେଶର ଛିଦ୍ର ଅନୁସନ୍ଧାନ କରିବାକୁ ତୁମ୍ଭେମାନେ ଆସିଅଛ।” ");
INSERT INTO ory_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ସେମାନେ କହିଲେ, “ନା ପ୍ରଭୋ, ତାହା ନୁହେଁ, ଆପଣଙ୍କର ଏହି ଦାସମାନେ ଖାଦ୍ୟଦ୍ରବ୍ୟ କିଣିବାକୁ ଆସିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ଆମ୍ଭେମାନେ ସମସ୍ତେ ଏକ ବ୍ୟକ୍ତିର ପୁତ୍ର, ଆମ୍ଭେମାନେ ସଚ୍ଚୋଟ ଲୋକ, ଆପଣଙ୍କ ଏହି ଦାସମାନେ ଚୋର ନୁହନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ତେବେ ସେ ସେମାନଙ୍କୁ କହିଲେ, “ନା, ନା, ତୁମ୍ଭେମାନେ ଦେଶର ଛିଦ୍ର ଅନୁସନ୍ଧାନ କରିବାକୁ ଆସିଅଛ।” ");
INSERT INTO ory_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ସେମାନେ କହିଲେ, “ଆପଣଙ୍କର ଏହି ଦାସମାନେ ଦ୍ୱାଦଶ ଭ୍ରାତା, କିଣାନ ଦେଶ ନିବାସୀ ଜଣକର ପୁତ୍ର; ଆଉ ଦେଖନ୍ତୁ, ଆମ୍ଭମାନଙ୍କର କନିଷ୍ଠ ଭ୍ରାତା ପିତା ନିକଟରେ ଅଛି, ପୁଣି, ଜଣେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ତହୁଁ ଯୋଷେଫ ସେମାନଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଚୋର ବୋଲି ଯାହା କହିଲୁ, ତୁମ୍ଭେମାନେ ତାହା ହିଁ ପ୍ରମାଣ। ");
INSERT INTO ory_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ଏହା ଦ୍ୱାରା ତୁମ୍ଭମାନଙ୍କୁ ପରୀକ୍ଷା କରାଯିବ; ଆମ୍ଭେ ଫାରୋର ଆୟୁର ଶପଥ କରି କହୁଅଛୁ, ତୁମ୍ଭମାନଙ୍କର କନିଷ୍ଠ ଭ୍ରାତା ଏଠାକୁ ନ ଆସିଲେ, ତୁମ୍ଭେମାନେ ଏଠାରୁ ଯାଇ ପାରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରୁ ଜଣକୁ ପଠାଅ, ସେ ତୁମ୍ଭ ଭାଇକୁ ଆଣୁ, ତୁମ୍ଭେମାନେ ବନ୍ଦୀ ଥାଅ; ତୁମ୍ଭମାନଙ୍କ କଥା ସତ୍ୟ କି ନାହିଁ, ପରୀକ୍ଷା ହେଲେ ଜଣାଯିବ; ନୋହିଲେ ଆମ୍ଭେ ଫାରୋର ଆୟୁର ଶପଥ କରି କହୁଅଛୁ, ତୁମ୍ଭେମାନେ ଅବଶ୍ୟ ଚୋର ଅଟ।” ");
INSERT INTO ory_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ତହୁଁ ଯୋଷେଫ ସେମାନଙ୍କୁ ତିନି ଦିନ କାରାଗାରରେ ବନ୍ଦ କରି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ପୁଣି, ତୃତୀୟ ଦିନରେ ଯୋଷେଫ ସେମାନଙ୍କୁ କହିଲେ, “ପରମେଶ୍ୱରଙ୍କ ପ୍ରତି ଆମ୍ଭର ଭୟ ଅଛି; ଏଣୁ ଏହି କର୍ମ କର, ତହିଁରେ ବଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ତୁମ୍ଭେମାନେ ଯଦି ସଚ୍ଚୋଟ ଲୋକ, ତେବେ ଆପଣା ମଧ୍ୟରୁ ଏକ ଭାଇକୁ ଏହି କାରାଗାରରେ ବନ୍ଦ ରଖି ଦୁର୍ଭିକ୍ଷ ହେତୁ ଗୃହକୁ ଶସ୍ୟ ଘେନିଯାଅ। ");
INSERT INTO ory_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ମାତ୍ର ତୁମ୍ଭେମାନେ ଆପଣା ସାନ ଭାଇଙ୍କୁ ଆମ୍ଭ ନିକଟକୁ ଆଣ, ତହିଁରେ ତୁମ୍ଭମାନଙ୍କ କଥା ସପ୍ରମାଣ ହେଲେ, ତୁମ୍ଭେମାନେ ମରିବ ନାହିଁ।” ତହୁଁ ସେମାନେ ସେହି ପ୍ରକାର କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ଏଥିଉତ୍ତାରେ ସେମାନେ ପରସ୍ପର କୁହାକୁହି ହେଲେ, “ଆମ୍ଭେମାନେ ଆପଣା ଭାଇ ବିଷୟରେ ନିଶ୍ଚୟ ଅପରାଧୀ ଅଟୁ; ସେ ଆମ୍ଭମାନଙ୍କୁ ବିନତି କରିବା ବେଳେ ଆମ୍ଭେମାନେ ତାହା ପ୍ରାଣର ବ୍ୟାକୁଳତା ଦେଖିଲେ ହେଁ ତାହା ଶୁଣିଲୁ ନାହିଁ, ତେଣୁକରି ଆମ୍ଭମାନଙ୍କୁ ଏହି ବିପତ୍ତି ଘଟିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ସେତେବେଳେ ରୁବେନ୍‍ ସେମାନଙ୍କୁ କହିଲା, “ତୁମ୍ଭେମାନେ ‘ସେହି ବାଳକ ବିଷୟରେ ପାପ କର ନାହିଁ,’ ଏହି କଥା କି ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ କହି ନାହିଁ? ତଥାପି ତୁମ୍ଭେମାନେ ଶୁଣିଲ ନାହିଁ; ଏନିମନ୍ତେ ଦେଖ, ଏବେ ତାହାର ରକ୍ତର ପରିଶୋଧ ନିଆଯାଉଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ମାତ୍ର ଯୋଷେଫ ଯେ ସେମାନଙ୍କ କଥାବାର୍ତ୍ତା ବୁଝିଲେ, ଏହା ସେମାନେ ଜାଣି ପାରିଲେ ନାହିଁ; କାରଣ ସେ ଦ୍ୱିଭାଷୀ ଦ୍ୱାରା ସେମାନଙ୍କ ସହିତ କଥା କହୁଥିଲେ; ");
INSERT INTO ory_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ସେମାନଙ୍କ ନିକଟରୁ ଯାଇ କ୍ରନ୍ଦନ କଲେ; ପୁନର୍ବାର ଆସି ସେମାନଙ୍କ ସହିତ କଥାବାର୍ତ୍ତା କରି ସେମାନଙ୍କ ମଧ୍ୟରୁ ଶିମୀୟୋନକୁ ଧରି ସେମାନଙ୍କ ସାକ୍ଷାତରେ ବାନ୍ଧିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ତହୁଁ ଯୋଷେଫ ସେମାନଙ୍କ ପାତ୍ରରେ ଶସ୍ୟପୂର୍ଣ୍ଣ କରି ପ୍ରତ୍ୟେକ ଜଣର ପଟରେ ଟଙ୍କା ଫେରାଇ ଦେବାକୁ ଓ ସେମାନଙ୍କୁ ପାଥେୟ ଦ୍ରବ୍ୟ ଦେବାକୁ ଆଜ୍ଞା ଦେଲେ; ତହିଁରେ ତଦ୍ରୂପ କରାଗଲା, ");
INSERT INTO ory_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ତହୁଁ ସେମାନେ ଆପଣା ଆପଣା ଗଧ ଉପରେ ଶସ୍ୟ ଲଦି ସେଠାରୁ ପ୍ରସ୍ଥାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ମାତ୍ର ଉତ୍ତରିବା ସ୍ଥାନରେ ଜଣେ ଗଧକୁ ଆହାର ଦେବା ନିମନ୍ତେ ପଟ ଫିଟାନ୍ତେ, ଆପଣା ଟଙ୍କା ଦେଖିଲା; କାରଣ ପଟ ମୁହଁରେ ଟଙ୍କା ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ତହିଁରେ ସେ ଭାଇମାନଙ୍କୁ କହିଲା, “ମୋହର ଟଙ୍କା ଫେରି ଆସିଅଛି; ଏହି ଦେଖ, ତାହା ମୋʼ ପଟରେ ଅଛି।” ଏଣୁ ସେମାନଙ୍କର ହଂସା ଉଡ଼ିଗଲା, ଆଉ ସେମାନେ କମ୍ପିତ ହୋଇ ପରସ୍ପର ପ୍ରତି ଅନାଇ କହିଲେ, “ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କର ପ୍ରତି ଏ କି କର୍ମ କରିଅଛନ୍ତି?” ");
INSERT INTO ory_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ଏଥିଉତ୍ତାରେ ସେମାନେ କିଣାନ ଦେଶରେ ଆପଣା ପିତା ଯାକୁବଙ୍କ ନିକଟରେ ଉପସ୍ଥିତ ହୋଇ ଆପଣାମାନଙ୍କ ପ୍ରତି ଯାହା ଯାହା ଘଟିଥିଲା, ତାହାସବୁ ତାଙ୍କୁ ଜଣାଇ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ଯେଉଁ ବ୍ୟକ୍ତି ସେହି ଦେଶର କର୍ତ୍ତା, ସେ ଆମ୍ଭମାନଙ୍କୁ ଦେଶର ଚୋର ଜ୍ଞାନ କରି କଟୁ କଥା କହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ତହିଁରେ ଆମ୍ଭେମାନେ ତାକୁ କହିଲୁ, ‘ଆମ୍ଭେମାନେ ସଚ୍ଚୋଟ ଲୋକ, ଚୋର ନୋହୁଁ, ");
INSERT INTO ory_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ଆମ୍ଭେମାନେ ବାର ଭାଇ, ସମସ୍ତେ ଏକ ପିତାଙ୍କର ସନ୍ତାନ; ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଜଣେ ନାହିଁ, ପୁଣି, କିଣାନ ଦେଶରେ ପିତାଙ୍କ ନିକଟରେ ଆଉ ଏକ ସାନ ଭାଇ ଅଛି।’ ");
INSERT INTO ory_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ସେତେବେଳେ ଦେଶର କର୍ତ୍ତା ସେହି ବ୍ୟକ୍ତି ଆମ୍ଭମାନଙ୍କୁ କହିଲା, ‘ଏହା କଲେ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ବିଶ୍ୱାସ୍ୟ ଲୋକ ବୋଲି ବୁଝି ପାରିବା; ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଏକ ଭାଇକୁ ଆମ୍ଭ ନିକଟରେ ରଖି ଆପଣାମାନଙ୍କ ଗୃହର ଦୁର୍ଭିକ୍ଷ ହେତୁ ଶସ୍ୟ ଘେନିଯାଅ। ");
INSERT INTO ory_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ପୁଣି, ଆପଣାମାନଙ୍କ ସାନ ଭାଇଙ୍କୁ ଆମ୍ଭ ନିକଟକୁ ଆଣ, ତେବେ ତୁମ୍ଭେମାନେ ଯେ ସଚ୍ଚୋଟ ଲୋକ, ଚୋର ନୁହଁ, ଏହା ବୁଝିବା; ତହିଁରେ ତୁମ୍ଭମାନଙ୍କ ଭାଇଙ୍କୁ ତୁମ୍ଭମାନଙ୍କୁ ସମର୍ପଣ କରିଦେବା, ପୁଣି, ତୁମ୍ଭେମାନେ ଏ ଦେଶରେ ବାଣିଜ୍ୟ କରି ପାରିବ।’” ");
INSERT INTO ory_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ଏଥିଉତ୍ତାରେ ସେମାନେ ପଟ ଖାଲି କରନ୍ତେ, ପ୍ରତି ଜଣ ଆପଣା ଆପଣା ପଟ ଭିତରୁ ଟଙ୍କାପୁଡ଼ିଆ ପାଇଲେ। ତେବେ ସେହି ସବୁ ଟଙ୍କାର ମୁଣା ଦେଖି, ସେମାନେ ଓ ସେମାନଙ୍କ ପିତା ଭୀତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ତହିଁରେ ସେମାନଙ୍କ ପିତା ଯାକୁବ କହିଲେ, “ତୁମ୍ଭେମାନେ ମୋତେ ପୁତ୍ରହୀନ କରୁଅଛ; ଯୋଷେଫ ନାହିଁ, ଶିମୀୟୋନ ନାହିଁ, ପୁଣି, ବିନ୍ୟାମୀନ୍‍କୁ ମଧ୍ୟ ଘେନିଯିବାକୁ ପାଞ୍ଚୁଅଛ, ଏହିସବୁ ସିନା ମୋହର ପ୍ରତିକୂଳ ହେଉଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ତହିଁରେ ରୁବେନ୍‍ ପିତାଙ୍କୁ କହିଲା, “ମୁଁ ଯଦି ତୁମ୍ଭ ପାଖକୁ ତାକୁ ନ ଆଣେ, ତେବେ ତୁମ୍ଭେ ମୋର ଦୁଇ ପୁଅଙ୍କୁ ବଧ କରିବ; ମୋʼ ହସ୍ତରେ ତାକୁ ସମର୍ପଣ କର; ମୁଁ ତାକୁ ପୁନର୍ବାର ତୁମ୍ଭ ପାଖକୁ ଆଣି ଦେବି।” ");
INSERT INTO ory_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ତେବେ ସେ କହିଲେ, “ମୋʼ ପୁଅ ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଯିବ ନାହିଁ, ତାହାର ସହୋଦର ମରିଅଛି, ସେ ହିଁ କେବଳ ଅଛି; ତୁମ୍ଭେମାନେ ଯେଉଁ ପଥରେ ଯାଉଅଛ, ତହିଁରେ ଏହାକୁ ଯଦି କୌଣସି ବିପଦ ଘଟିବ, ତେବେ ତୁମ୍ଭେମାନେ ମୋତେ ଶୋକରେ ଏହି ପକ୍ୱ କେଶରେ କବରକୁ ପଠାଇବ।” ");
INSERT INTO ory_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ଏହି ସମୟରେ ମଧ୍ୟଦେଶରେ ଅତିଶୟ ଦୁର୍ଭିକ୍ଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ଏଥିନିମନ୍ତେ ସେମାନେ ମିସର ଦେଶରୁ ଯେଉଁ ଶସ୍ୟ ଆଣିଥିଲେ, ସେହି ସବୁ ସମାପ୍ତ ହେବାରୁ ସେମାନଙ୍କ ପିତା ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ପୁନର୍ବାର ଯାଇ ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ କିଛି ଶସ୍ୟ କିଣି ଆଣ।” ");
INSERT INTO ory_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ତହିଁରେ ଯିହୁଦା ତାଙ୍କୁ କହିଲା, “ସେ ବ୍ୟକ୍ତି ଦୃଢ଼ ପ୍ରତିଜ୍ଞା କରି କହିଅଛି, ‘ତୁମ୍ଭମାନଙ୍କ ଭାଇ ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ନ ଥିଲେ, ତୁମ୍ଭେମାନେ ଆମ୍ଭର ମୁଖ ଦେଖି ପାରିବ ନାହିଁ।’ ");
INSERT INTO ory_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ଏଣୁ ଯଦି ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ଭାଇକୁ ସଙ୍ଗରେ ପଠାଇବ, ତେବେ ଆମ୍ଭେମାନେ ତୁମ୍ଭ ପାଇଁ ଶସ୍ୟ କିଣିବାକୁ ଯିବୁ। ");
INSERT INTO ory_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ମାତ୍ର ଯଦି ନ ପଠାଇବ, ତେବେ ଆମ୍ଭେମାନେ ଯିବୁ ନାହିଁ; କାରଣ ସେ ବ୍ୟକ୍ତି କହିଅଛି, ‘ତୁମ୍ଭମାନଙ୍କ ଭାଇ ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ନ ଥିଲେ, ତୁମ୍ଭେମାନେ ଆମ୍ଭର ମୁଖ ଦେଖି ପାରିବ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ତହିଁରେ ଇସ୍ରାଏଲ କହିଲେ, “ତୁମ୍ଭମାନଙ୍କର ଆଉ ଏକ ଭାଇ ଅଛି, ଏହା ସେହି ମନୁଷ୍ୟକୁ କହି ମୋʼ ପ୍ରତି ଏପରି କୁବ୍ୟବହାର କାହିଁକି କଲ?” ");
INSERT INTO ory_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ସେମାନେ କହିଲେ, “ସେ ଆମ୍ଭମାନଙ୍କ ଓ ଆମ୍ଭମାନଙ୍କ ଜ୍ଞାତିମାନଙ୍କ ବିଷୟ ସୂକ୍ଷ୍ମ ରୂପେ ପଚାରି କହିଲା, ‘ତୁମ୍ଭମାନଙ୍କ ପିତା କି ଆଜି ପର୍ଯ୍ୟନ୍ତ ବଞ୍ଚିଅଛନ୍ତି? ତୁମ୍ଭମାନଙ୍କର କି ଆଉ ଭାଇ ଅଛି?’ ଏଣୁ ଆମ୍ଭେମାନେ ସେହି କଥା ପ୍ରମାଣେ ଉତ୍ତର ଦେଇଥିଲୁ; ସେ ଯେ ‘ତୁମ୍ଭମାନଙ୍କ ଭାଇଙ୍କୁ ଏଠାକୁ ଆଣ ବୋଲି କହିବ, ଏହା ଆମ୍ଭେମାନେ କିପ୍ରକାରେ ଜାଣି ପାରନ୍ତୁ?’” ");
INSERT INTO ory_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ଯିହୁଦା ଆପଣା ପିତା ଇସ୍ରାଏଲଙ୍କୁ ଆହୁରି କହିଲା, “ତୁମ୍ଭେ ସେହି ଯୁବାକୁ ମୋʼ ସଙ୍ଗରେ ପଠାଇଦିଅ; ଆମ୍ଭେମାନେ ଉଠି ପ୍ରସ୍ଥାନ କରୁ, ତହିଁରେ ଆମ୍ଭେମାନେ ଓ ତୁମ୍ଭେ ଓ ବାଳକମାନେ, ସମସ୍ତେ ବଞ୍ଚିବା, ମରିବା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ମୁଁ ତାହାର ଲଗା ହେଲି, ମୋʼ ହସ୍ତରୁ ତାକୁ ବୁଝି ନେବ; ମୁଁ ଯଦି ତାକୁ ଆଣି ତୁମ୍ଭ ସମ୍ମୁଖରେ ନ ରଖେ, ତେବେ ସେହି ଦୋଷ ସର୍ବଦା ମୋʼ ଉପରେ ବର୍ତ୍ତିବ। ");
INSERT INTO ory_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ଯଦି ଆମ୍ଭମାନଙ୍କର ଏତେ ବିଳମ୍ବ ହୋଇ ନ ଥାʼନ୍ତା, ତେବେ ଆମ୍ଭେମାନେ ଦ୍ୱିତୀୟ ଥର ବାହୁଡ଼ି ଆସନ୍ତୁଣି।” ");
INSERT INTO ory_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ତହୁଁ ସେମାନଙ୍କ ପିତା ଇସ୍ରାଏଲ ସେମାନଙ୍କୁ କହିଲେ, “ଯଦି ଏପରି ହୁଏ, ତେବେ ଗୋଟିଏ କର୍ମ କର; ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ପାତ୍ରରେ ଏହି ଦେଶର ଉତ୍ତମ ଦ୍ରବ୍ୟ, ଅର୍ଥାତ୍‍, ଗୁଗ୍ଗୁଳ, ମଧୁ, ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ, ଗନ୍ଧରସ, ପେସ୍ତା ଓ ବାଦାମ କିଛି କିଛି ଘେନି ସେହି ବ୍ୟକ୍ତିଙ୍କୁ ଭେଟି ଦିଅ। ");
INSERT INTO ory_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ପୁଣି, ଆପଣା ଆପଣା ହସ୍ତରେ ଦ୍ୱିଗୁଣ ଟଙ୍କା ନିଅ ଓ ତୁମ୍ଭମାନଙ୍କ ପଟ-ମୁଖରେ ଯେଉଁ ଟଙ୍କା ଫେରି ଆସିଅଛି, ତାହା ମଧ୍ୟ ହସ୍ତରେ ନେଇଯାଅ; କେଜାଣି ତାହା ଭୁଲ୍ ହୋଇଥିବ। ");
INSERT INTO ory_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ପୁଣି, ଆପଣାମାନଙ୍କ ଭାଇଙ୍କୁ ଘେନି ଉଠି ପୁନର୍ବାର ସେହି ବ୍ୟକ୍ତି ନିକଟକୁ ଯାଅ। ");
INSERT INTO ory_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ସର୍ବଶକ୍ତିମାନ ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କୁ ସେହି ବ୍ୟକ୍ତି ନିକଟରେ ଏପରି ଅନୁଗ୍ରହପାତ୍ର କରନ୍ତୁ, ଯେପରି ସେ ତୁମ୍ଭମାନଙ୍କ ଅନ୍ୟ ଭାଇଙ୍କୁ ଓ ବିନ୍ୟାମୀନ୍‍କୁ ଛାଡ଼ିଦେବ। ମାତ୍ର ଯଦି ମୋତେ ପୁତ୍ରହୀନ ହେବାକୁ ହୁଏ, ତେବେ ପୁତ୍ରହୀନ ହେବି।” ");
INSERT INTO ory_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ତହୁଁ ସେମାନେ ସେହି ଭେଟି ଦ୍ରବ୍ୟ ଓ ଦ୍ୱିଗୁଣ ଟଙ୍କା ଓ ବିନ୍ୟାମୀନ୍‍କୁ ସଙ୍ଗରେ ଘେନି ଯାତ୍ରା କରି ମିସର ଦେଶରେ ଯୋଷେଫଙ୍କ ସମ୍ମୁଖରେ ଠିଆ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ସେତେବେଳେ ଯୋଷେଫ ସେମାନଙ୍କ ସଙ୍ଗରେ ବିନ୍ୟାମୀନ୍‍କୁ ଦେଖି ଆପଣା ଗୃହାଧ୍ୟକ୍ଷକୁ କହିଲେ, “ଏହି ଲୋକମାନଙ୍କୁ ଆମ୍ଭ ଗୃହକୁ ନେଇଯାଅ ଓ ପଶୁ ମାରି ଖାଦ୍ୟଦ୍ରବ୍ୟ ପ୍ରସ୍ତୁତ କର; ଏମାନେ ମଧ୍ୟାହ୍ନ ସମୟରେ ଆମ୍ଭ ସଙ୍ଗରେ ଭୋଜନ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ଏଥିରେ ସେହି ମନୁଷ୍ୟ ଯୋଷେଫଙ୍କର ଆଜ୍ଞାନୁସାରେ କର୍ମ କରି ସେମାନଙ୍କୁ ଯୋଷେଫଙ୍କ ଗୃହକୁ ନେଇଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ପୁଣି, ଯୋଷେଫଙ୍କ ଗୃହକୁ ନୀତ ହେବାରୁ ସେମାନେ ଭୀତ ହୋଇ ପରସ୍ପର କହିଲେ, “ପୂର୍ବେ ଆମ୍ଭମାନଙ୍କ ପଟରେ ଯେଉଁ ଟଙ୍କା ଫେରି ଯାଇଥିଲା, ତହିଁ ନିମନ୍ତେ ଆମ୍ଭମାନଙ୍କୁ ଏଠାକୁ ଆଣିଅଛନ୍ତି; ଏବେ ସେ ଆମ୍ଭମାନଙ୍କ ଉପରେ ପଡ଼ି ଆକ୍ରମଣ କରି ଆମ୍ଭମାନଙ୍କ ଗର୍ଦ୍ଦଭ ସବୁ ନେଇ ଆମ୍ଭମାନଙ୍କୁ ଦାସ ପରି ରଖିବ।” ");
INSERT INTO ory_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ତେଣୁ ସେମାନେ ଯୋଷେଫଙ୍କ ଗୃହାଧ୍ୟକ୍ଷ ନିକଟକୁ ଯାଇ ଗୃହର ପ୍ରବେଶ ସ୍ଥାନରେ ତାହା ସହିତ କଥାବାର୍ତ୍ତା କରି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ପ୍ରଭୋ, ଆମ୍ଭେମାନେ ପୂର୍ବେ ଶସ୍ୟ କିଣିବାକୁ ଆସିଥିଲୁ; ");
INSERT INTO ory_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ପୁଣି, ଉତ୍ତରିବା ସ୍ଥାନରେ ଆପଣା ଆପଣା ପଟ ଫିଟାଇ ଦେଖିଲୁ ଯେ, ପ୍ରତି ଜଣର ପଟ-ମୁଖରେ ତାହାର ଟଙ୍କା, ଅର୍ଥାତ୍‍, ପୂର୍ଣ୍ଣ ତୌଲ ଅନୁସାରେ ଆମ୍ଭମାନଙ୍କର ଟଙ୍କା ଅଛି; ତାହା ଆମ୍ଭେମାନେ ହସ୍ତରେ ପୁନର୍ବାର ଆଣିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ପୁଣି, ଶସ୍ୟ କିଣିବା ନିମନ୍ତେ ଆମ୍ଭେମାନେ ଆଉ ଟଙ୍କା ଆଣିଅଛୁ; ମାତ୍ର ସେହି ଟଙ୍କା ଆମ୍ଭମାନଙ୍କ ପଟରେ କିଏ ରଖିଥିଲା, ଆମ୍ଭେମାନେ ତାହା ଜାଣି ନାହୁଁ।” ");
INSERT INTO ory_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ତହିଁରେ ସେ ଗୃହାଧ୍ୟକ୍ଷ କହିଲା, “ତୁମ୍ଭମାନଙ୍କର ମଙ୍ଗଳ ହେଉ, ଭୟ କର ନାହିଁ; ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଓ ତୁମ୍ଭମାନଙ୍କ ପୈତୃକ ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କ ପଟରେ ତୁମ୍ଭମାନଙ୍କୁ ଗୁପ୍ତ ଧନ ଦେଇଅଛନ୍ତି; ତୁମ୍ଭମାନଙ୍କ ଟଙ୍କା ମୋʼ ପାଖରେ ଥିଲା।” ତହୁଁ ସେ ଶିମୀୟୋନକୁ ବାହାର କରି ସେମାନଙ୍କ ନିକଟକୁ ଆଣିଲା। ");
INSERT INTO ory_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ଏଥିଉତ୍ତାରେ ସେ ସେମାନଙ୍କୁ ଯୋଷେଫଙ୍କ ଗୃହ ଭିତରକୁ ନେଇ ଜଳ ଦିଅନ୍ତେ, ସେମାନେ ପାଦ ପ୍ରକ୍ଷାଳନ କଲେ; ପୁଣି, ସେ ସେମାନଙ୍କ ଗର୍ଦ୍ଦଭମାନଙ୍କୁ ଆହାର ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ଆଉ ମଧ୍ୟାହ୍ନ ସମୟରେ ଯୋଷେଫ ଆସିବେ ବୋଲି ସେମାନେ ଭେଟି ଦ୍ରବ୍ୟ ସଜାଇଲେ; କାରଣ ସେମାନେ ସେଠାରେ ଭୋଜନ କରିବେ ବୋଲି ଶୁଣିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଗୃହକୁ ଆସନ୍ତେ, ସେମାନେ ହସ୍ତସ୍ଥିତ ଭେଟି ଦ୍ରବ୍ୟ ତାଙ୍କ ନିକଟକୁ ଗୃହ ମଧ୍ୟରେ ଆଣି ତାଙ୍କୁ ଭୂମିଷ୍ଠ ପ୍ରମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ତହୁଁ ଯୋଷେଫ ସେମାନଙ୍କର ମଙ୍ଗଳ ବାର୍ତ୍ତା ପଚାରି କହିଲେ, “ତୁମ୍ଭମାନଙ୍କର ପିତା କି କୁଶଳରେ ଅଛନ୍ତି? ତୁମ୍ଭେମାନେ ଯେଉଁ ବୃଦ୍ଧ ଲୋକଙ୍କର କଥା କହୁଥିଲ, ସେ କି ଆଜି ପର୍ଯ୍ୟନ୍ତ ବଞ୍ଚିଅଛନ୍ତି?” ");
INSERT INTO ory_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ସେମାନେ କହିଲେ, “ଆପଣଙ୍କ ଦାସ ଆମ୍ଭମାନଙ୍କ ପିତା କୁଶଳରେ ଅଛନ୍ତି, ସେ ଆଜି ପର୍ଯ୍ୟନ୍ତ ବଞ୍ଚିଅଛନ୍ତି।” ତହୁଁ ସେମାନେ ମସ୍ତକ ନତ କରି ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ସେତେବେଳେ ଯୋଷେଫ ଅନାଇ ଆପଣା ସହୋଦର ବିନ୍ୟାମୀନ୍‍କୁ ଦେଖି କହିଲେ, “ତୁମ୍ଭେମାନେ ଯେଉଁ ସାନ ଭାଇର କଥା କହିଥିଲ, ସେ କି ଏହି?” ଆଉ ସେ କହିଲେ, “ହେ ଆମ୍ଭର ପୁତ୍ର, ପରମେଶ୍ୱର ତୁମ୍ଭଙ୍କୁ ଅନୁଗ୍ରହ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ତହୁଁ ଭାଇ ପ୍ରତି ଯୋଷେଫଙ୍କର ଅନ୍ତଃକରଣ ସ୍ନେହରେ ଉତ୍ତପ୍ତ ହେବାରୁ ସେ ଶୀଘ୍ର ରୋଦନ କରିବାକୁ ସ୍ଥାନ ଖୋଜିଲେ; ପୁଣି, ସେ ଆପଣା କୋଠରିରେ ପ୍ରବେଶ କରି ସେଠାରେ ରୋଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ଏଥିଉତ୍ତାରେ ସେ ମୁଖ ପ୍ରକ୍ଷାଳନ କରି ବାହାରକୁ ଆସିଲେ, ପୁଣି, ଆପଣାକୁ ସମ୍ଭାଳି “ଭକ୍ଷ୍ୟଦ୍ରବ୍ୟ ପରିବେଷଣ କରିବା ନିମନ୍ତେ” ଆଜ୍ଞା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ତହିଁରେ ଭୃତ୍ୟମାନେ ଯୋଷେଫଙ୍କ ନିମନ୍ତେ ଓ ତାଙ୍କ ଭାଇମାନଙ୍କ ନିମନ୍ତେ, ପୁଣି, ତାଙ୍କ ସଙ୍ଗେ ଭୋଜନକାରୀ ମିସରୀୟ ଲୋକମାନଙ୍କ ନିମନ୍ତେ ପୃଥକ ପୃଥକ ପରିବେଷଣ କଲେ, କାରଣ ଏବ୍ରୀୟମାନଙ୍କ ସହିତ ଭୋଜନ କରିବାର ମିସରୀୟମାନଙ୍କର ବ୍ୟବହାର ନ ଥିଲା; ତାହା ମିସରୀୟମାନଙ୍କର ଘୃଣିତ କର୍ମ। ");
INSERT INTO ory_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ଏଥିଉତ୍ତାରେ ଯୋଷେଫଙ୍କ ସମ୍ମୁଖରେ ସେମାନଙ୍କର ଜ୍ୟେଷ୍ଠ ଜ୍ୟେଷ୍ଠ ସ୍ଥାନରେ ଓ କନିଷ୍ଠ କନିଷ୍ଠ ସ୍ଥାନରେ ବସିଲେ; ତହିଁରେ ସେମାନେ ପରସ୍ପର ଆଶ୍ଚର୍ଯ୍ୟ ବୋଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ପୁଣି, ସେ ଆପଣା ସମ୍ମୁଖରୁ ଭକ୍ଷ୍ୟଦ୍ରବ୍ୟ ଉଠାଇ ସେମାନଙ୍କୁ ପରିବେଷଣ କରାଇଲେ; ମାତ୍ର ସମସ୍ତଙ୍କ ଭାଗରୁ ବିନ୍ୟାମୀନ୍‍ର ଭାଗ ପାଞ୍ଚଗୁଣ ଅଧିକ ଥିଲା। ଏଥିରେ ସେମାନେ ପାନ କରି ତାଙ୍କ ସହିତ ଆନନ୍ଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଆପଣା ଗୃହାଧ୍ୟକ୍ଷକୁ ଆଜ୍ଞା ଦେଲେ, “ଏହି ଲୋକମାନଙ୍କ ପଟରେ ଯେତେ ଶସ୍ୟ ଧରଇ, ସେତେ ପରିପୂର୍ଣ୍ଣ କରିଦିଅ, ପୁଣି, ପ୍ରତ୍ୟେକର ଟଙ୍କା ପ୍ରତ୍ୟେକର ପଟ-ମୁଖରେ ରଖ। ");
INSERT INTO ory_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ଆଉ କନିଷ୍ଠ ପଟରେ ତାହାର ଶସ୍ୟ କିଣିବା ଟଙ୍କା ସଙ୍ଗେ ଆମ୍ଭ ତାଟିଆ, ସେ ରୂପା ତାଟିଆ ରଖ।” ତହିଁରେ ସେ ଯୋଷେଫଙ୍କ କଥାନୁସାରେ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ଆଉ ପ୍ରଭାତ ହେବା ମାତ୍ରେ, ସେମାନେ ଗର୍ଦ୍ଦଭ ସହିତ ବିଦାୟ ପାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ପୁଣି, ନଗରରୁ ବାହାରି ବହୁତ ଦୂର ନ ଯାଉଣୁ, ଯୋଷେଫ ଆପଣା ଗୃହାଧ୍ୟକ୍ଷକୁ କହିଲେ, “ତୁମ୍ଭେ ଉଠି ସେହି ମନୁଷ୍ୟମାନଙ୍କ ପଛେ ପଛେ ଦୌଡ଼ିଯାଇ ସେମାନଙ୍କ ସଙ୍ଗ ଧରି କୁହ, ‘ତୁମ୍ଭେମାନେ ଉପକାର ବଦଳେ କାହିଁକି ଅପକାର କଲ? ");
INSERT INTO ory_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ଆମ୍ଭ ପ୍ରଭୁ ଯହିଁରେ ପାନ କରନ୍ତି ଓ ଯଦ୍ଦ୍ୱାରା ଗଣକତା କରନ୍ତି, ସେହି ତାଟିଆ କି ଏ ନୁହେଁ? ଏପରି କର୍ମ ଦ୍ୱାରା ତୁମ୍ଭେମାନେ ଦୋଷ କରିଅଛ।’” ");
INSERT INTO ory_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ଏଥିଉତ୍ତାରେ ସେ ସେମାନଙ୍କ ସଙ୍ଗ ଧରି ଏହିସବୁ କଥା କହିଲା। ");
INSERT INTO ory_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ତହିଁରେ ସେମାନେ କହିଲେ, “ଆମ୍ଭର ପ୍ରଭୁ କାହିଁକି ଏପରି କଥା କହନ୍ତି? ଆପଣଙ୍କ ଦାସମାନଙ୍କର ଏପରି କର୍ମ କରିବା ଦୂରେ ଥାଉ। ");
INSERT INTO ory_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ଦେଖନ୍ତୁ, ଆପଣା ଆପଣା ପଟ ମୁଖରୁ ଆର ଥର ଯେଉଁ ଟଙ୍କା ପାଇଥିଲୁ; ତାହା ଆମ୍ଭେମାନେ କିଣାନ ଦେଶରୁ ପୁନର୍ବାର ଆପଣଙ୍କ ନିକଟକୁ ଆଣିଲୁ; ତେବେ କିପରି ଆପଣଙ୍କ ପ୍ରଭୁଙ୍କ ଗୃହରୁ ରୂପା କି ସୁନା ଚୋରି କରିବୁ? ");
INSERT INTO ory_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ଆପଣଙ୍କ ଦାସମାନଙ୍କ ମଧ୍ୟରେ ଯାହାଠାରୁ ତାହା ମିଳେ, ସେ ମରୁ, ପୁଣି, ଆମ୍ଭେମାନେ ମଧ୍ୟ ପ୍ରଭୁଙ୍କର ଦାସ ହେବୁ।” ");
INSERT INTO ory_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ତହିଁରେ ସେ କହିଲା, “ଭଲ, ତୁମ୍ଭମାନଙ୍କ କଥାନୁସାରେ ହେଉ; ଯାହା ପାଖରୁ ତାହା ମିଳିବ, ସେ ଆମ୍ଭର ଦାସ ହେବ, ମାତ୍ର ଅନ୍ୟମାନେ ନିର୍ଦ୍ଦୋଷ ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ତହୁଁ ସେମାନେ ସେହିକ୍ଷଣି ଭୂମିରେ ଆପଣା ଆପଣା ପଟ ଉତ୍ତାରି ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ପଟ ଫିଟାଇବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ସେ ଗୃହାଧ୍ୟକ୍ଷ ଜ୍ୟେଷ୍ଠଠାରୁ ଆରମ୍ଭ କରି କନିଷ୍ଠ ପର୍ଯ୍ୟନ୍ତ ଖୋଜି ଗଲା; ଆଉ ବିନ୍ୟାମୀନ୍‍ର ପଟରୁ ସେହି ତାଟିଆ ମିଳିଲା। ");
INSERT INTO ory_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ସେତେବେଳେ ସେମାନେ ଆପଣା ଆପଣା ବସ୍ତ୍ର ଚିରିଲେ, ଆଉ ପ୍ରତ୍ୟେକେ ଗଧ ବୋଝାଇ କରି ନଗରକୁ ଫେରିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ଆଉ ଯିହୁଦା ଓ ତାହାର ଭ୍ରାତୃଗଣ ଯୋଷେଫଙ୍କ ଗୃହରେ ପ୍ରବେଶ କଲେ; ଯୋଷେଫ ସେହି ସମୟ ପର୍ଯ୍ୟନ୍ତ ସେଠାରେ ଥିଲେ; ଏଣୁ ସେମାନେ ତାଙ୍କ ସାକ୍ଷାତରେ ଭୂମିରେ ପଡ଼ିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ତେବେ ଯୋଷେଫ ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଏ କିପରି କାର୍ଯ୍ୟ କଲ? ଆମ୍ଭ ପରି ଲୋକ ଯେ ଅବଶ୍ୟ ଗଣକତା କରି ପାରିବ, ଏହା କି ତୁମ୍ଭେମାନେ ଜାଣ ନାହିଁ?” ");
INSERT INTO ory_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ତହିଁରେ ଯିହୁଦା କହିଲା, “ଆମ୍ଭେମାନେ ପ୍ରଭୁଙ୍କ ଛାମୁରେ ଆଉ କି ଉତ୍ତର ଦେବୁ? ଆଉ କି କଥା କହିବୁ? ଅବା କିପରି ଆପଣାମାନଙ୍କୁ ନିର୍ଦ୍ଦୋଷ କରିବୁ? ପରମେଶ୍ୱର ଆପଣଙ୍କ ଦାସମାନଙ୍କର ଅପରାଧ ପ୍ରକାଶ କରିଅଛନ୍ତି; ଦେଖନ୍ତୁ, ଆମ୍ଭେମାନେ ଓ ଯାହାଠାରୁ ତାଟିଆ ମିଳିଅଛି ସେ, ପୁଣି ଆମ୍ଭେ ସମସ୍ତେ ଆପଣଙ୍କ (ପ୍ରଭୁଙ୍କର) ଦାସ ହେବୁ।” ");
INSERT INTO ory_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ତହିଁରେ ଯୋଷେଫ କହିଲେ, “ଏପରି କର୍ମ ଆମ୍ଭଠାରୁ ଦୂର ହେଉ; ଯାହାଠାରୁ ତାଟିଆ ମିଳିଅଛି, ସେ ଆମ୍ଭର ଦାସ ହେବ; ମାତ୍ର ତୁମ୍ଭେମାନେ କୁଶଳରେ ପିତାଙ୍କ ନିକଟକୁ ଚାଲିଯାଅ।” ");
INSERT INTO ory_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ତହିଁରେ ଯିହୁଦା ନିକଟକୁ ଯାଇ କହିଲା, “ପ୍ରଭୋ, ଆପଣଙ୍କ ଏହି ଦାସକୁ ପ୍ରଭୁଙ୍କ କର୍ଣ୍ଣଗୋଚରରେ ପଦେ ନିବେଦନ କରିବାକୁ ଅନୁମତି ଦେଉନ୍ତୁ ଓ ଆପଣା ଦାସ ପ୍ରତି ଆପଣଙ୍କ କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ନ ହେଉ; କାରଣ ଆପଣ ଫାରୋଙ୍କ ତୁଲ୍ୟ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ପ୍ରଭୁ ଆପଣା ଦାସମାନଙ୍କୁ ପଚାରିଥିଲେ, ‘ତୁମ୍ଭମାନଙ୍କର ପିତା କିଅବା ଭାଇ ଅଛନ୍ତି କି?’ ");
INSERT INTO ory_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ତହିଁରେ ଆମ୍ଭେମାନେ ପ୍ରଭୁଙ୍କୁ ଉତ୍ତର ଦେଇଥିଲୁ, ‘ଆମ୍ଭମାନଙ୍କ ପିତା ଅଛନ୍ତି, ସେ ବୃଦ୍ଧ ଲୋକ; ପୁଣି, ତାଙ୍କ ବୃଦ୍ଧାବସ୍ଥାର ଗୋଟିଏ ପୁତ୍ର ଅଛି, ସେହି ଜଣକ କନିଷ୍ଠ; ମାତ୍ର ତାହାର ସହୋଦର ମରିଅଛି, ସେହି କେବଳ ତାହାର ମାତାର ଅବଶିଷ୍ଟ ପୁତ୍ର; ଏଣୁ ତାହାର ପିତା ତାହାକୁ ସ୍ନେହ କରନ୍ତି।’ ");
INSERT INTO ory_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ଏଥିରେ ଆପଣ ଏହି ଦାସମାନଙ୍କୁ କହିଥିଲେ, ‘ତୁମ୍ଭେମାନେ ତାକୁ ଆମ୍ଭ କତିକି ଆଣ, ଆମ୍ଭେ ତାକୁ ସ୍ୱଚକ୍ଷୁରେ ଦେଖିବା।’ ");
INSERT INTO ory_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ତେବେ ଆମ୍ଭେମାନେ ପ୍ରଭୁଙ୍କୁ କହିଥିଲୁ, ‘ସେ ଯୁବା ପିତାଙ୍କୁ ଛାଡ଼ି ପାରିବ ନାହିଁ; ସେ ତାହାର ପିତାଙ୍କୁ ଛାଡ଼ି ଆସିଲେ, ପିତା ମରିଯିବେ।’ ");
INSERT INTO ory_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ତହିଁରେ ଆପଣ ଏହି ଦାସମାନଙ୍କୁ କହିଲେ, ‘ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ କନିଷ୍ଠ ଭାଇ ନ ଆସିଲେ, ତୁମ୍ଭେମାନେ ଆଉ ଆମ୍ଭ ମୁଖ ଦେଖି ପାରିବ ନାହିଁ।’ ");
INSERT INTO ory_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ଏଥିଉତ୍ତାରେ ଆମ୍ଭେମାନେ ଆପଣଙ୍କ ଦାସ ଯେ ମୋʼ ପିତା, ତାଙ୍କ ନିକଟରେ ଉପସ୍ଥିତ ହୋଇ ତାଙ୍କୁ ପ୍ରଭୁଙ୍କର ଏହିସବୁ କଥା କହିଲୁ। ");
INSERT INTO ory_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ଏଥିଉତ୍ତାରେ ଆମ୍ଭମାନଙ୍କ ପିତା କହିଲେ, ‘ତୁମ୍ଭେମାନେ ପୁନର୍ବାର ଯାଇ ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ କିଛି ଭକ୍ଷ୍ୟ କିଣି ଆଣ।’ ");
INSERT INTO ory_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ତହିଁରେ ଆମ୍ଭେମାନେ କହିଲୁ, ‘ଯାଇ ପାରିବୁ ନାହିଁ; ଯଦି ସାନ ଭାଇ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଥିବ, ତେବେ ଯାଇ ପାରିବୁ; କାରଣ ସାନ ଭାଇ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ନ ଥିଲେ, ଆମ୍ଭେମାନେ ସେହି ବ୍ୟକ୍ତିଙ୍କର ମୁଖ ଦେଖି ପାରିବୁ ନାହିଁ।’ ");
INSERT INTO ory_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ତହିଁରେ ଆପଣଙ୍କ ଦାସ ଯେ ମୋହର ପିତା, ସେ ଆମ୍ଭମାନଙ୍କୁ କହିଲେ, ‘ତୁମ୍ଭେମାନେ ଜାଣ, ଆମ୍ଭର ସେହି ଭାର୍ଯ୍ୟାଠାରୁ ଦୁଇଟି ପୁତ୍ର ହୋଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ସେମାନଙ୍କ ମଧ୍ୟରୁ ଗୋଟିଏ ଆମ୍ଭ ନିକଟରୁ ଚାଲିଗଲା, ତହୁଁ ଆମ୍ଭେ କହିଲୁ, ସେ ନିଶ୍ଚୟ ଖଣ୍ଡ ଖଣ୍ଡ ହୋଇ ବିଦୀର୍ଣ୍ଣ ହୋଇଅଛି; ପୁଣି, ସେହି ଦିନଠାରୁ ଆମ୍ଭେ ଆଉ ତାକୁ ଦେଖି ନାହୁଁ। ");
INSERT INTO ory_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ଏବେ ଆମ୍ଭ ପାଖରୁ ଏହାକୁ ନେଇଗଲେ ଯଦି ଏହାକୁ କୌଣସି ବିପତ୍ତି ଘଟେ, ତେବେ ତୁମ୍ଭେମାନେ ଆମ୍ଭକୁ ଶୋକରେ ଏହି ପକ୍ୱ କେଶରେ ପାତାଳକୁ ପଠାଇବ।’ ");
INSERT INTO ory_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ଏହେତୁ ଆପଣଙ୍କ ଦାସ ଯେ ମୋʼ ପିତା, ତାଙ୍କ ନିକଟରେ ମୁଁ ଉପସ୍ଥିତ ହେଲେ, ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଯଦି ଏହି ଯୁବା ନ ଥିବ, ତେବେ ଏହି ଯୁବା ନ ଥିବାର ଦେଖି ସେ ତତ୍‌କ୍ଷଣାତ୍ ମରିଯିବେ। ");
INSERT INTO ory_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","କାରଣ ତାଙ୍କ ପ୍ରାଣ ଏହି ଯୁବାର ପ୍ରାଣରେ ବନ୍ଧା ଅଟେ। ତହିଁରେ ଆପଣଙ୍କର ଏହି ଦାସମାନେ ଶୋକରେ ପକ୍ୱ କେଶରେ ଆପଣଙ୍କ ଦାସ ଆମ୍ଭମାନଙ୍କ ପିତାଙ୍କୁ କବରକୁ ପଠାଇବେ। ");
INSERT INTO ory_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ଆହୁରି, ଆପଣଙ୍କ ଦାସ ମୁଁ, ଆପଣା ପିତାଙ୍କ ନିକଟରେ ଏହି ଯୁବାର ଲଗା ହୋଇ କହିଅଛି, ‘ମୁଁ ଯଦି ତାକୁ ତୁମ୍ଭ ପାଖକୁ ନ ଆଣେ, ତେବେ ମୁଁ ଯାବଜ୍ଜୀବନ ପିତାଙ୍କ ନିକଟରେ ଅପରାଧୀ ହେବି।’ ");
INSERT INTO ory_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ଏଣୁ ନିବେଦନ କରୁଅଛି, ପ୍ରଭୁଙ୍କ ନିକଟରେ ଏହି ଯୁବାର ପରିବର୍ତ୍ତେ ଆପଣଙ୍କ ଦାସ ମୁଁ ଆପଣଙ୍କ ଦାସ ହୋଇଥାଏ, ମାତ୍ର ଏହି ଯୁବାକୁ ଭାଇମାନଙ୍କ ସଙ୍ଗରେ ବିଦାୟ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","କାରଣ ଏହି ଯୁବା ମୋʼ ସଙ୍ଗରେ ନ ଥିଲେ, ମୁଁ କିପରି ପିତାଙ୍କ ନିକଟକୁ ଯାଇ ପାରିବି? ପୁଣି, ପିତାଙ୍କୁ ଯେଉଁ ବିପଦ ଘଟିବ, ତାହା କିପରି ଅବା ଦେଖି ପାରିବି?” ");
INSERT INTO ory_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ଏଥିରେ ଯୋଷେଫ ଆପଣା ନିକଟରେ ଠିଆ ହୋଇଥିବା ଲୋକମାନଙ୍କ ସାକ୍ଷାତରେ ଆପଣାକୁ ସମ୍ଭାଳି ନ ପାରି ଉଚ୍ଚସ୍ୱରରେ କହିଲେ, “ଆମ୍ଭ ସମ୍ମୁଖରୁ ସବୁ ଲୋକଙ୍କୁ ବାହାର କର।” ତହୁଁ କେହି ତାଙ୍କ ନିକଟରେ ନ ରହନ୍ତେ, ଯୋଷେଫ ଭାଇମାନଙ୍କ ସାକ୍ଷାତରେ ଆପଣାର ପରିଚୟ ଦେବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ସେ ଉଚ୍ଚସ୍ୱରରେ ଏପରି ରୋଦନ କଲେ ଯେ, ମିସରୀୟମାନେ ଓ ଫାରୋଙ୍କ ଗୃହସ୍ଥିତ ଲୋକମାନେ ତାହା ଶୁଣି ପାରିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ଯୋଷେଫ ଆପଣା ଭାଇମାନଙ୍କୁ କହିଲେ, “ମୁଁ ଯୋଷେଫ; ମୋʼ ପିତା କି ଆଜି ପର୍ଯ୍ୟନ୍ତ ବଞ୍ଚିଅଛନ୍ତି?” ଏଥିରେ ତାଙ୍କର ଭାଇମାନେ ତାଙ୍କ ସାକ୍ଷାତରେ ଭୟଭୀତ ହେବାରୁ କିଛି ଉତ୍ତର ଦେଇ ପାରିଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଆପଣା ଭାଇମାନଙ୍କୁ କହିଲେ, “ବିନୟ କରୁଅଛି, ମୋʼ ପାଖକୁ ଆସ,” ତହିଁରେ ସେମାନେ ପାଖକୁ ଯାଆନ୍ତେ, ସେ କହିଲେ, “ମୁଁ ତୁମ୍ଭମାନଙ୍କର ଭାଇ ଯୋଷେଫ, ଯାହାକୁ ତୁମ୍ଭେମାନେ ମିସରଗାମୀ ଲୋକମାନଙ୍କୁ ବିକ୍ରୟ କରିଥିଲ। ");
INSERT INTO ory_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ମାତ୍ର, ତୁମ୍ଭେମାନେ ମୋତେ ଏଠାକୁ ଆସିବା ପାଇଁ ବିକ୍ରୟ କଲ ବୋଲି ଏବେ ଦୁଃଖିତ ଓ ଆପଣା ଆପଣା ପ୍ରତି ବିରକ୍ତ ହୁଅ ନାହିଁ; କାରଣ ପରମେଶ୍ୱର ପ୍ରାଣ ବଞ୍ଚାଇବା ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କ ଆଗେ ମୋତେ ପଠାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ଦେଖ, କେବଳ ଦୁଇ ବର୍ଷ ହେଲା ଦେଶରେ ଦୁର୍ଭିକ୍ଷ ହୋଇଅଛି; ଆହୁରି ପାଞ୍ଚ ବର୍ଷ ବାକି ଅଛି, ତହିଁ ମଧ୍ୟରେ ଚାଷ କି ଶସ୍ୟର ଚ୍ଛେଦନ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ଏଥିପାଇଁ ପରମେଶ୍ୱର ପୃଥିବୀରେ ତୁମ୍ଭମାନଙ୍କୁ ଅବଶିଷ୍ଟାଂଶ ରୂପେ ରକ୍ଷା କରିବାକୁ ଓ ମହା ଉଦ୍ଧାର ଉପଲକ୍ଷ୍ୟରେ ତୁମ୍ଭମାନଙ୍କୁ ପ୍ରାଣରେ ବଞ୍ଚାଇବାକୁ ତୁମ୍ଭମାନଙ୍କ ଆଗେ ମୋତେ ପଠାଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ଏନିମନ୍ତେ ତୁମ୍ଭେମାନେ ଯେ ମୋତେ ଏ ସ୍ଥାନକୁ ପଠାଇଅଛ, ତାହା ନୁହେଁ, ପରମେଶ୍ୱର ପଠାଇଅଛନ୍ତି; ପୁଣି, ସେ ମୋତେ ଫାରୋଙ୍କର ପିତା ଓ ତାଙ୍କ ଗୃହର ପ୍ରଭୁ ଓ ସମସ୍ତ ମିସର ଦେଶର କର୍ତ୍ତା କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ଏଣୁ ତୁମ୍ଭେମାନେ ଶୀଘ୍ର ମୋʼ ପିତାଙ୍କ ନିକଟକୁ ଯାଇ ତାଙ୍କୁ କୁହ, ‘ତୁମ୍ଭର ପୁତ୍ର ଯୋଷେଫ ଏହିପରି କହିଅଛି, ପରମେଶ୍ୱର ମୋତେ ସମସ୍ତ ମିସର ଦେଶର ବିଶିଷ୍ଟ ବ୍ୟକ୍ତି କରିଅଛନ୍ତି; ତୁମ୍ଭେ ମୋʼ ନିକଟକୁ ଆସ, ବିଳମ୍ବ କର ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ତୁମ୍ଭେ ପୁତ୍ର, ପୌତ୍ର ଓ ଗୋମେଷାଦି ସର୍ବସ୍ୱ ସହିତ ଗୋଶନ ପ୍ରଦେଶରେ ବାସ କରି ମୋହର ନିକଟବର୍ତ୍ତୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ସେହି ସ୍ଥାନରେ, ମୁଁ ତୁମ୍ଭଙ୍କୁ ପ୍ରତିପାଳନ କରିବି; କାରଣ ଆଉ ପାଞ୍ଚ ବର୍ଷ ଦୁର୍ଭିକ୍ଷ ରହିବ; ନୋହିଲେ ତୁମ୍ଭର ଓ ତୁମ୍ଭ ପରିବାରାଦି ସମସ୍ତଙ୍କର ଦରିଦ୍ର ଦଶା ଘଟିବ।’” ");
INSERT INTO ory_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“ଦେଖ, ମୋହର ମୁଖ ତୁମ୍ଭମାନଙ୍କୁ ଏ କଥା କହୁଅଛି, ଏହା ତୁମ୍ଭମାନଙ୍କ ଚକ୍ଷୁ ଓ ମୋʼ ସହୋଦର ବିନ୍ୟାମୀନ୍‍ର ଚକ୍ଷୁ ଦେଖୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ଏଣୁ ତୁମ୍ଭେମାନେ ଏହି ମିସର ଦେଶରେ ମୋହର ଐଶ୍ୱର୍ଯ୍ୟାଦି ଯାହା ଯାହା ଦେଖୁଅଛ, ସେ ସମସ୍ତ ମୋʼ ପିତାଙ୍କୁ ଜଣାଇ ତାଙ୍କୁ ଶୀଘ୍ର ଏଠାକୁ ଆଣିବ।” ");
INSERT INTO ory_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ଏଥିଉତ୍ତାରେ ସେ ଆପଣା ସହୋଦର ବିନ୍ୟାମୀନ୍‍ର ଗଳା ଧରି ରୋଦନ କଲେ, ପୁଣି, ବିନ୍ୟାମୀନ୍ ତାଙ୍କର ଗଳା ଧରି ରୋଦନ କଲା। ");
INSERT INTO ory_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ପୁଣି, ଯୋଷେଫ ଅନ୍ୟ ଭାଇମାନଙ୍କୁ ଚୁମ୍ବନ କଲେ ଓ ସେମାନଙ୍କୁ ଧରି ରୋଦନ କଲେ। ଏଥିଉତ୍ତାରେ ତାଙ୍କର ଭାଇମାନେ ତାଙ୍କ ସଙ୍ଗରେ ଆଳାପ କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ଆଉ “ଯୋଷେଫଙ୍କର ଭାଇମାନେ ଆସିଅଛନ୍ତି,” ଜନରବ ଫାରୋଙ୍କର ଗୃହରେ ଶୁଣାଯାଆନ୍ତେ, ଫାରୋ ଓ ତାଙ୍କର ଦାସ ସମସ୍ତେ ସନ୍ତୁଷ୍ଟ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ପୁଣି, ଫାରୋ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ଭାଇମାନଙ୍କୁ କୁହ, ‘ତୁମ୍ଭେମାନେ ଏହି କର୍ମ କର; ଆପଣା ଆପଣା ପଶୁମାନଙ୍କୁ ବୋଝାଇ କରି କିଣାନ ଦେଶକୁ ଯାଅ, ");
INSERT INTO ory_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ପୁଣି, ପିତାଙ୍କୁ ଓ ଆପଣା ଆପଣା ସମସ୍ତ ପରିବାରକୁ ଘେନି ଆମ୍ଭ ନିକଟକୁ ଆସ; ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ମିସର ଦେଶର ଉତ୍ତମ ଦ୍ରବ୍ୟ ଦେବା, ପୁଣି, ତୁମ୍ଭେମାନେ ଦେଶର ସର୍ବୋତ୍ତମ ବିଷୟ ଭୋଗ କରିବ।’ ");
INSERT INTO ory_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ଏବେ ଆମ୍ଭର ଆଜ୍ଞାନୁସାରେ ‘ଏହି କର୍ମ କର, ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ବାଳକମାନଙ୍କ ଓ ଭାର୍ଯ୍ୟାମାନଙ୍କ ପାଇଁ ମିସର ଦେଶରୁ ଶଗଡ଼ ନେଇଯାଅ, ପୁଣି, ଆପଣାମାନଙ୍କ ପିତାଙ୍କୁ ନେଇଆସ। ");
INSERT INTO ory_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ଆଉ ଆପଣାମାନଙ୍କ ଦ୍ରବ୍ୟାଦି ବିଷୟରେ ଭାବନା କର ନାହିଁ; ସମସ୍ତ ମିସର ଦେଶର ଉତ୍ତମ ଦ୍ରବ୍ୟ ତୁମ୍ଭମାନଙ୍କର ଅଟେ।’” ");
INSERT INTO ory_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ତହିଁରେ ଇସ୍ରାଏଲଙ୍କର ପୁତ୍ରମାନେ ସେହିପରି କଲେ; ପୁଣି, ଯୋଷେଫ ଫାରୋଙ୍କର ଆଜ୍ଞାନୁସାରେ ସେମାନଙ୍କୁ ଶଗଡ଼ ଓ ପାଥେୟ ଦ୍ରବ୍ୟ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ପୁଣି, ପ୍ରତ୍ୟେକ ଜଣକୁ ଏକ ଏକ ଯୋଡ଼ା ବସ୍ତ୍ର ଦେଲେ, ମାତ୍ର ବିନ୍ୟାମୀନ୍‍କୁ ତିନି ଶହ ଶେକେଲ ରୌପ୍ୟ ମୁଦ୍ରା ଓ ପାଞ୍ଚ ଯୋଡ଼ା ବସ୍ତ୍ର ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ପୁଣି, ପିତାଙ୍କ ନିମନ୍ତେ ମିସର ଦେଶର ଉତ୍ତମ ଉତ୍ତମ ଦ୍ରବ୍ୟରେ ନଦା ଦଶ ଗଧ ଓ ପିତାଙ୍କ ପାଥେୟ ନିମନ୍ତେ ଶସ୍ୟ ଓ ରୁଟି ଆଦି ଭକ୍ଷ୍ୟ ଦ୍ରବ୍ୟରେ ନଦା ଦଶ ଗର୍ଦ୍ଦଭୀ ପଠାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ଏହିରୂପେ ଯୋଷେଫ ଆପଣା ଭାଇମାନଙ୍କୁ ବିଦାୟ କରନ୍ତେ, ସେମାନେ ପ୍ରସ୍ଥାନ କଲେ; ପୁଣି, ସେ ସେମାନଙ୍କୁ କହିଲେ, “ସାବଧାନ, ବାଟରେ କଳି କରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ଏଥିଉତ୍ତାରେ ସେମାନେ ମିସର ଦେଶରୁ ପ୍ରସ୍ଥାନ କରି କିଣାନ ଦେଶରେ ଆପଣା ପିତା ଯାକୁବଙ୍କ ନିକଟରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ପୁଣି, ସେମାନେ ତାଙ୍କୁ କହିଲେ, “ଯୋଷେଫ ଆଜି ପର୍ଯ୍ୟନ୍ତ ଜୀବିତ ଅଛି, ଆଉ ସେ ସମସ୍ତ ମିସର ଦେଶର କର୍ତ୍ତା ହୋଇଅଛି।” ଏଥିରେ ଯାକୁବଙ୍କର ହୃଦୟ ଜଡ଼ୀଭୂତ ହେଲା, କାରଣ ସେ ସେମାନଙ୍କୁ ବିଶ୍ୱାସ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ପୁଣି, ଯୋଷେଫ ଯେତେ କଥା ସେମାନଙ୍କୁ କହିଥିଲେ, ସେହି ସବୁ କଥା ସେମାନେ ତାଙ୍କୁ କହିଲେ। ମାତ୍ର ସେ ଯେତେବେଳେ ତାଙ୍କୁ ନେବା ପାଇଁ ଯୋଷେଫଙ୍କ ପ୍ରେରିତ ଶଗଡ଼ସବୁ ଦେଖିଲେ, ସେତେବେଳେ ସେମାନଙ୍କ ପିତା ଯାକୁବଙ୍କ ଆତ୍ମା ପୁନର୍ଜୀବିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ତହିଁରେ ଇସ୍ରାଏଲ କହିଲେ, “ଯଥେଷ୍ଟ; ମୋହର ପୁତ୍ର ଯୋଷେଫ ଆଜି ପର୍ଯ୍ୟନ୍ତ ବଞ୍ଚିଅଛି; ମୁଁ ଯିବି, ମରଣ ପୂର୍ବେ ତାକୁ ଦେଖିବି।” ");
INSERT INTO ory_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ ଆପଣା ସର୍ବସ୍ୱ ଘେନି ଯାତ୍ରା କଲେ, ପୁଣି, ବେର୍‍ଶେବାରେ ଓହ୍ଲାଇ ସେଠାରେ ଆପଣା ପିତା ଇସ୍‌ହାକଙ୍କର ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ତହିଁରେ ପରମେଶ୍ୱର ଇସ୍ରାଏଲଙ୍କୁ ରାତିରେ ଦର୍ଶନ ଦେଇ କହିଲେ, “ହେ ଯାକୁବ, ହେ ଯାକୁବ।” ତହିଁରେ ସେ ଉତ୍ତର କଲେ, “ଦେଖନ୍ତୁ, ମୁଁ ଉପସ୍ଥିତ ଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ସେତେବେଳେ ସେ କହିଲେ, “ଆମ୍ଭେ ପରମେଶ୍ୱର, ତୁମ୍ଭ ପିତାଙ୍କର ପରମେଶ୍ୱର; ତୁମ୍ଭେ ମିସରକୁ ଯିବା ପାଇଁ ଭୟ କର ନାହିଁ; ଯେହେତୁ ଆମ୍ଭେ ସେଠାରେ ତୁମ୍ଭକୁ ଏକ ବୃହତ ଗୋଷ୍ଠୀ କରିବା। ");
INSERT INTO ory_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ଆମ୍ଭେ ତୁମ୍ଭ ସଙ୍ଗରେ ମିସର ଦେଶକୁ ଯିବା; ପୁଣି, ଆମ୍ଭେ ମଧ୍ୟ ସେଠାରୁ ତୁମ୍ଭକୁ ନିଶ୍ଚୟ ବାହୁଡ଼ାଇ ଆଣିବା, ପୁଣି, ଯୋଷେଫ ନିଜ ହସ୍ତରେ ତୁମ୍ଭର ଚକ୍ଷୁ ମୁଦ୍ରିତ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ଏଥିଉତ୍ତାରେ ଯାକୁବ ବେର୍‍ଶେବାଠାରୁ ଯାତ୍ରା କଲେ; ପୁଣି, ତାଙ୍କୁ ନେବା ନିମନ୍ତେ ଫାରୋ ଯେଉଁ ଶଗଡ଼ ପଠାଇଥିଲେ, ତହିଁରେ ଇସ୍ରାଏଲର ପୁତ୍ରଗଣ ଆପଣାମାନଙ୍କ ପିତା ଯାକୁବଙ୍କୁ ଓ ବାଳକମାନଙ୍କୁ ଓ ଭାର୍ଯ୍ୟାମାନଙ୍କୁ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ଏଉତ୍ତାରେ ସେମାନେ, ଅର୍ଥାତ୍‍, ଯାକୁବ ଓ ତାଙ୍କ ସମସ୍ତ ବଂଶ, ଆପଣାମାନଙ୍କ ପଶୁଗଣ ଓ କିଣାନ ଦେଶରେ ଉପାର୍ଜ୍ଜିତ ସମସ୍ତ ସମ୍ପତ୍ତି ଘେନି ମିସର ଦେଶରେ ପହଞ୍ଚିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ଏହି ପ୍ରକାରେ ଯାକୁବ ଆପଣା ପୁତ୍ରପୌତ୍ର, ପୁତ୍ରୀ ଓ ପୌତ୍ରୀ ସମସ୍ତ ପରିବାର ନେଇ ମିସର ଦେଶକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ମିସର ଦେଶକୁ ଆଗତ ଇସ୍ରାଏଲ ବଂଶ, ଅର୍ଥାତ୍‍, ଯାକୁବ ଓ ତାଙ୍କର ସନ୍ତାନମାନଙ୍କର ନାମ। ଯାକୁବଙ୍କର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ରୁବେନ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ରୁବେନ୍‍ର ପୁତ୍ର ହନୋକ, ପଲ୍ଲୁ, ହିଷ୍ରୋଣ ଓ କର୍ମି। ");
INSERT INTO ory_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ଶିମୀୟୋନର ପୁତ୍ର ଯିମୂୟେଲ, ଯାମୀନ୍‍, ଓହଦ୍‍, ଯାଖୀନ୍‍ ଓ ସୋହର ଓ ତାହାର କିଣାନୀୟା ସ୍ତ୍ରୀଠାରୁ ଜାତ ପୁତ୍ର ଶୌଲ। ");
INSERT INTO ory_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ଲେବୀର ପୁତ୍ର ଗେର୍ଶୋନ‍, କହାତ ଓ ମରାରି। ");
INSERT INTO ory_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ଯିହୁଦାର ପୁତ୍ର ଏର, ଓନନ୍‍, ଶେଲା, ପେରସ ଓ ସେରହ; ମାତ୍ର ଏର ଓ ଓନନ୍‍ କିଣାନ ଦେଶରେ ମରିଥିଲେ। ପେରସର ପୁତ୍ର ହିଷ୍ରୋଣ ଓ ହାମୂଲ। ");
INSERT INTO ory_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ଇଷାଖରର ସନ୍ତାନ ତୋଲୟ, ପୂୟ, ଯୋବ ଓ ଶିମ୍ରୋଣ। ");
INSERT INTO ory_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ସବୂଲୂନର ପୁତ୍ର ସେରଦ, ଏଲୋନ୍‍ ଓ ଯହଲେଲ। ");
INSERT INTO ory_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ଏମାନେ ଓ କନ୍ୟା ଦୀଣା ପଦ୍ଦନ୍‍ ଅରାମରେ ଯାକୁବଙ୍କଠାରୁ ଜାତ ଲେୟାର ସନ୍ତାନ। ଏମାନେ ପୁତ୍ର କନ୍ୟାରେ ତେତିଶ ପ୍ରାଣୀ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ଗାଦ୍‍ର ପୁତ୍ର ସିଫୋନ୍‍, ହଗି, ଶୂନୀ, ଇଷବୋନ୍‍, ଏରି, ଅରୋଦି ଓ ଅରେଲୀ। ");
INSERT INTO ory_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ଆଶେରର ପୁତ୍ର ଯିମ୍ନା, ଯିଶ୍‍ବା, ଯିଶ୍‍ବି, ବରୀୟ ଓ ସେମାନଙ୍କ ଭଗିନୀ ସେରହ। ପୁଣି, ବରୀୟର ପୁତ୍ର ହେବର ଓ ମଲ୍‍କୀୟେଲ। ");
INSERT INTO ory_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ଲାବନ ଆପଣା କନ୍ୟା ଲେୟାକୁ ସିଳ୍ପା ନାମ୍ନୀ ଯେଉଁ ଦାସୀ ଦେଇଥିଲା, ସେ ଯାକୁବଙ୍କର ଏହି ସନ୍ତାନମାନଙ୍କୁ ପ୍ରସବ କରିଥିଲା। ଏମାନେ ଷୋହଳ ଜଣ। ");
INSERT INTO ory_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ପୁଣି, ଯାକୁବଙ୍କ ଭାର୍ଯ୍ୟା ରାହେଲର ପୁତ୍ର ଯୋଷେଫ ଓ ବିନ୍ୟାମୀନ୍। ");
INSERT INTO ory_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ଯୋଷେଫଙ୍କର ପୁତ୍ର ମନଃଶି ଓ ଇଫ୍ରୟିମ ମିସର ଦେଶରେ ଜନ୍ମିଥିଲେ; ଓନ୍‍ ନଗରସ୍ଥ ପୋଟୀଫେର ଯାଜକର ଆସନତ୍‍ ନାମ୍ନୀ କନ୍ୟା ସେମାନଙ୍କୁ ପ୍ରସବ କରିଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ପୁଣି, ବିନ୍ୟାମୀନ୍‍ର ସନ୍ତାନ ବେଲା, ବେଖର, ଅସ୍‍ବେଲ, ଗେରା, ନାମାନ୍‍, ଏହୀ, ରୋଶ, ମୁପ୍ପୀମ, ହୁପ୍ପୀମ୍‍ ଓ ଅର୍ଦ। ");
INSERT INTO ory_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ଏହି ଚଉଦ ଜଣ ଯାକୁବଙ୍କଠାରୁ ଜାତ ରାହେଲର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ଆଉ ଦାନ୍‍ର ପୁତ୍ର ହୂଶୀମ୍‍। ");
INSERT INTO ory_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ନପ୍ତାଲିର ପୁତ୍ର ଯହସୀୟେଲ, ଗୂନି, ଯେତ୍ସର ଓ ଶିଲ୍ଲେମ। ");
INSERT INTO ory_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ଲାବନ ଆପଣା କନ୍ୟା ରାହେଲକୁ ବିଲ୍‌ହା ନାମ୍ନୀ ଯେଉଁ ଦାସୀ ଦେଇଥିଲା, ସେ ଯାକୁବଙ୍କର ଏହି ସନ୍ତାନମାନଙ୍କୁ ପ୍ରସବ କରିଥିଲା; ଏମାନେ ସର୍ବସୁଦ୍ଧା ସାତ ଜଣ। ");
INSERT INTO ory_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ଯାକୁବଙ୍କ କଟିରୁ ଉତ୍ପନ୍ନ ଯେଉଁ ପ୍ରାଣୀଗଣ ତାଙ୍କ ସଙ୍ଗରେ ମିସରରେ ଉପସ୍ଥିତ ହେଲେ, ଯାକୁବଙ୍କ ପୁତ୍ରବଧୂମାନଙ୍କ ଛଡ଼ା ସେମାନେ ସର୍ବସୁଦ୍ଧା ଛଅଷଠି ପ୍ରାଣୀ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ମିସରରେ ଯୋଷେଫଙ୍କର ଯେଉଁ ପୁତ୍ର ଜାତ ହୋଇଥିଲେ, ସେମାନେ ଦୁଇ ପ୍ରାଣୀ। ମିସରକୁ ଆଗତ ଯାକୁବଙ୍କର ପରିଜନ ସର୍ବସୁଦ୍ଧା ସତୁରି ଜଣ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଗୋଶନ ପ୍ରଦେଶକୁ ଯିବାର ପଥ ଯେପରି ଦେଖାଇବେ, ଏଥିପାଇଁ ଯାକୁବ ଆପଣା ଆଗେ ଯିହୁଦାକୁ ତାଙ୍କ ନିକଟକୁ ପଠାଇଲେ; ଏଉତ୍ତାରେ ସେମାନେ ଗୋଶନ ପ୍ରଦେଶରେ ଉତ୍ତରିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ତହୁଁ ଯୋଷେଫ ଆପଣା ପିତା ଇସ୍ରାଏଲଙ୍କ ସଙ୍ଗେ ସାକ୍ଷାତ କରିବା ପାଇଁ ରଥ ସଜାଇ ଗୋଶନ ପ୍ରଦେଶକୁ ଗମନ କଲେ; ପୁଣି, ତାଙ୍କୁ ଦେଖା ଦେଇ ତାଙ୍କ ଗଳା ଧରି ବହୁତ ସମୟ ପର୍ଯ୍ୟନ୍ତ ରୋଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ସେତେବେଳେ ଇସ୍ରାଏଲ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ଏବେ ମୋହର ମରଣ ହେଉ, ମୁଁ ତୁମ୍ଭ ମୁଖ ଦେଖିଲି, ତୁମ୍ଭେ ତ ଆଜି ପର୍ଯ୍ୟନ୍ତ ବଞ୍ଚିଅଛ।” ");
INSERT INTO ory_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଆପଣା ଭାଇମାନଙ୍କୁ ଓ ପିତୃପରିବାରକୁ କହିଲେ, “ମୁଁ ଯାଇ ଫାରୋଙ୍କୁ ସମ୍ବାଦ ଦେଇ କହିବି, ‘କିଣାନ ଦେଶରୁ ମୋହର ଭ୍ରାତୃଗଣ ଓ ପିତୃପରିବାର ମୋʼ ନିକଟକୁ ଆସିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ସେମାନେ ପଶୁପାଳକ ଓ ପଶୁ ବ୍ୟବସାୟୀ, ଏଣୁ ସେମାନେ ଆପଣାମାନଙ୍କ ଗୋମେଷାଦି ପଲ ପ୍ରଭୃତି ସର୍ବସ୍ୱ ଆଣିଅଛନ୍ତି।’ ");
INSERT INTO ory_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ତହିଁରେ ଫାରୋ ତୁମ୍ଭମାନଙ୍କୁ ଡକାଇ ‘ତୁମ୍ଭମାନଙ୍କର କେଉଁ ବ୍ୟବସାୟ?’ ଏ କଥା ଯେତେବେଳେ ପଚାରିବେ, ");
INSERT INTO ory_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ସେତେବେଳେ ତୁମ୍ଭେମାନେ କହିବ, ‘ଆପଣଙ୍କର ଏହି ଦାସମାନେ ବାଲ୍ୟାବଧି ଏପର୍ଯ୍ୟନ୍ତ ପୂର୍ବପୁରୁଷାନୁକ୍ରମେ ପଶୁ ବ୍ୟବସାୟୀ;’ ତହିଁରେ ତୁମ୍ଭେମାନେ ଗୋଶନ ପ୍ରଦେଶରେ ବାସ କରି ପାରିବ; କାରଣ ପଶୁପାଳକମାନେ ମିସରୀୟମାନଙ୍କ ନିକଟରେ ଘୃଣାଯୋଗ୍ୟ ଅଟନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଯାଇ ଫାରୋଙ୍କୁ ସମ୍ବାଦ ଦେଇ କହିଲେ, “ମୋʼ ପିତା ଓ ଭାଇମାନେ କିଣାନ ଦେଶରୁ ଆପଣା ଗୋମେଷାଦି ପଲ ପ୍ରଭୃତି ସର୍ବସ୍ୱ ନେଇ ଆସିଅଛନ୍ତି; ଦେଖନ୍ତୁ, ସେମାନେ ଗୋଶନ ପ୍ରଦେଶରେ ଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ପୁଣି, ଯୋଷେଫ ଆପଣା ଭ୍ରାତୃଗଣ ମଧ୍ୟରୁ ପାଞ୍ଚ ଜଣଙ୍କୁ ନେଇ ଫାରୋଙ୍କ ସହିତ ସାକ୍ଷାତ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ତହିଁରେ ଫାରୋ ଯୋଷେଫଙ୍କ ଭାଇମାନଙ୍କୁ ପଚାରିଲେ, “ତୁମ୍ଭମାନଙ୍କର କେଉଁ ବ୍ୟବସାୟ?” ସେମାନେ ଫାରୋଙ୍କୁ କହିଲେ, “ଆପଣଙ୍କର ଏହି ଦାସମାନେ ପୂର୍ବପୁରୁଷାନୁକ୍ରମେ ପଶୁପାଳକ।” ");
INSERT INTO ory_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ସେମାନେ ଫାରୋଙ୍କୁ ଆହୁରି କହିଲେ, “ଆମ୍ଭେମାନେ ଏ ଦେଶରେ ପ୍ରବାସ କରିବାକୁ ଆସିଅଛୁ; ଯେଣୁ ଆପଣଙ୍କ ଏହି ଦାସମାନଙ୍କ ପଶୁପଲ ପାଇଁ କିଛି ଚରା ନାହିଁ; କିଣାନ ଦେଶରେ ଅତି ଭାରୀ ଦୁର୍ଭିକ୍ଷ ପଡ଼ିଅଛି; ଏହେତୁ ବିନତି କରୁଅଛୁ, ଆପଣ ଏହି ଦାସମାନଙ୍କୁ ଗୋଶନ ପ୍ରଦେଶରେ ବାସ କରିବାକୁ ଦେଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ତହିଁରେ ଫାରୋ ଯୋଷେଫଙ୍କୁ ଆଜ୍ଞା ଦେଲେ, “ତୁମ୍ଭର ପିତା ଓ ଭ୍ରାତୃଗଣ ତୁମ୍ଭ ନିକଟକୁ ଆସିଅଛନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ମିସର ଦେଶ ତୁମ୍ଭ ସମ୍ମୁଖରେ ଅଛି; ଦେଶର ସର୍ବୋତ୍ତମ ସ୍ଥାନରେ ଆପଣା ପିତା ଓ ଭାଇମାନଙ୍କୁ ବାସ କରାଅ; ଗୋଶନ ପ୍ରଦେଶରେ ସେମାନେ ବାସ କରନ୍ତୁ; ପୁଣି, ସେମାନଙ୍କ ମଧ୍ୟରୁ ଯାହାକୁ ଯାହାକୁ ପାରଙ୍ଗମ ଲୋକ ବୋଲି ଜାଣୁଅଛ, ସେମାନଙ୍କୁ ଆମ୍ଭ ପଶୁପଲର ଅଧ୍ୟକ୍ଷ ପଦରେ ନିଯୁକ୍ତ କର।” ");
INSERT INTO ory_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଆପଣା ପିତା ଯାକୁବଙ୍କୁ ଆଣି ଫାରୋଙ୍କ ସାକ୍ଷାତରେ ଉପସ୍ଥିତ କରାଇଲେ; ତହିଁରେ ଯାକୁବ ଫାରୋଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ସେତେବେଳେ ଫାରୋ ଯାକୁବଙ୍କୁ ପଚାରିଲେ, “ଆପଣଙ୍କ ପରମାୟୁର ଦିନ କେତେ?” ");
INSERT INTO ory_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ଯାକୁବ ଫାରୋଙ୍କୁ କହିଲେ, “ମୋହର ପ୍ରବାସ କାଳର ଦିନ ଶହେ ତିରିଶ ବର୍ଷ; ମୋʼ ପରମାୟୁର ଦିନ ଅଳ୍ପ ଓ ଆପଦଜନକ; ପୁଣି, ମୋହର ପୂର୍ବପୁରୁଷମାନଙ୍କ ପ୍ରବାସକାଳୀନ ଆୟୁର ଦିନ ତୁଲ୍ୟ ନୁହେଁ।” ");
INSERT INTO ory_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଫାରୋଙ୍କୁ ଆଶୀର୍ବାଦ କରି ତାଙ୍କ ଛାମୁରୁ ବିଦାୟ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ତହୁଁ ଯୋଷେଫ ଫାରୋଙ୍କର ଆଜ୍ଞାନୁସାରେ ମିସର ଦେଶର ସର୍ବୋତ୍ତମ ଅଞ୍ଚଳରେ, ଅର୍ଥାତ୍‍, ରାମିଷେଷ୍‍ ପ୍ରଦେଶରେ ଅଧିକାର ଦେଇ ଆପଣା ପିତା ଓ ଭାଇମାନଙ୍କର ଅବସ୍ଥିତି କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ପୁଣି, ଯୋଷେଫ ଆପଣା ପିତା ଓ ଭାଇମାନଙ୍କୁ ଓ ସମସ୍ତ ପିତୃପରିବାରକୁ ପ୍ରତ୍ୟେକର ପରିବାରାନୁସାରେ ଭକ୍ଷ୍ୟଦ୍ରବ୍ୟ ଦେଇ ପ୍ରତିପାଳନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ସେହି ସମୟରେ ଅତିଶୟ ଦୁର୍ଭିକ୍ଷ ହେବାରୁ ସର୍ବଦେଶରେ ଖାଦ୍ୟଦ୍ରବ୍ୟର ଅଭାବ ହେଲା; ତହିଁରେ ମିସର ଦେଶୀୟ ଓ କିଣାନ ଦେଶୀୟ ଲୋକମାନେ ଦୁର୍ଭିକ୍ଷ ହେତୁ ପ୍ରାୟ ମୂର୍ଚ୍ଛାଗତ ହେବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ଆଉ ମିସର ଦେଶରେ ଓ କିଣାନ ଦେଶରେ ଯେତେ ରୂପା ଥିଲା, ଲୋକମାନେ ତାହା ଦେଇ ଶସ୍ୟ କିଣିବାରୁ ଯୋଷେଫ ସେସବୁ ରୂପା ସଂଗ୍ରହ କରି ଫାରୋଙ୍କର ଗୃହକୁ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ଏଥିଉତ୍ତାରେ ମିସର ଦେଶରେ ଓ କିଣାନ ଦେଶରେ ରୂପାର ଅଭାବ ହୁଅନ୍ତେ, ମିସରୀୟ ଲୋକ ସମସ୍ତେ ଯୋଷେଫଙ୍କ ନିକଟକୁ ଆସି କହିଲେ, “ଆମ୍ଭମାନଙ୍କୁ ଖାଦ୍ୟସାମଗ୍ରୀ ଦେଉନ୍ତୁ, ଆମ୍ଭମାନଙ୍କର ରୂପା ଶେଷ ହେଉଅଛି ବୋଲି କାହିଁକି ଆମ୍ଭେମାନେ ଆପଣଙ୍କ ସମ୍ମୁଖରେ ମରିବୁ?” ");
INSERT INTO ory_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ତହିଁରେ ଯୋଷେଫ କହିଲେ, “ତୁମ୍ଭମାନଙ୍କର ପଶୁ ଦିଅ; ଯଦି ରୂପା ଶେଷ ହୋଇଥାଏ, ତେବେ ପଶୁ ବଦଳେ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଶସ୍ୟ ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ତହୁଁ ସେମାନେ ଯୋଷେଫଙ୍କ ନିକଟକୁ ଆପଣା ଆପଣା ପଶୁ ଆଣିଲେ; ତହିଁରେ ଯୋଷେଫ ଅଶ୍ୱ ଓ ମେଷ ଓ ଗୋରୁପଲ ଓ ଗର୍ଦ୍ଦଭ ଆଦି ବଦଳ ନେଇ ସେମାନଙ୍କୁ ଭକ୍ଷ୍ୟ ଦେବାକୁ ଲାଗିଲେ; ଏହି ପ୍ରକାରେ ଯୋଷେଫ ପଶୁ ବଦଳେ ସେମାନଙ୍କୁ ଭକ୍ଷ୍ୟ ଦେଇ ସେହି ବର୍ଷ ଚଳାଇ ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ପୁଣି, ସେ ବର୍ଷ ସମ୍ପୂର୍ଣ୍ଣ ହୁଅନ୍ତେ, ଦ୍ୱିତୀୟ ବର୍ଷରେ ସେମାନେ ଯୋଷେଫଙ୍କ ନିକଟକୁ ଆସି କହିଲେ, “ଆମ୍ଭମାନଙ୍କର ସମସ୍ତ ରୂପା ଶେଷ ହୋଇଅଛି; ତାହା ପ୍ରଭୁଙ୍କଠାରୁ ଲୁଚାଇବା ନାହିଁ; ପୁଣି, ଆମ୍ଭମାନଙ୍କର ସମସ୍ତ ପଶୁଧନ ମଧ୍ୟ ପ୍ରଭୁଙ୍କର ହୋଇଅଛି; ଏବେ ପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ଆମ୍ଭମାନଙ୍କର ଦେହ ଓ ଭୂମି ବିନା ଆଉ କିଛି ଅବଶିଷ୍ଟ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ଏଥିପାଇଁ ଆମ୍ଭେମାନେ ଓ ଆମ୍ଭମାନଙ୍କର ଭୂମି ଦୁହେଁ କାହିଁକି ଆପଣଙ୍କ ଦୃଷ୍ଟିଗୋଚରରେ ମରିବୁ? ଆପଣ ଭକ୍ଷ୍ୟ ଦେଇ ଆମ୍ଭମାନଙ୍କୁ ଓ ଆମ୍ଭମାନଙ୍କ ଭୂମି କିଣି ନେଉନ୍ତୁ, ତହିଁରେ ଆମ୍ଭେମାନେ ଓ ଆମ୍ଭମାନଙ୍କ ଭୂମି ଫାରୋଙ୍କର ଦାସ ହେବୁ; ତାʼପରେ ଆମ୍ଭମାନଙ୍କୁ ବିହନ ଦେଉନ୍ତୁ, ତହିଁରେ ବଞ୍ଚିବୁ; ନୋହିଲେ ଆମ୍ଭେମାନେ ମରିଯିବୁ, ପୁଣି, ଭୂମି ମଧ୍ୟ ବିନଷ୍ଟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ଏହିରୂପେ ଦୁର୍ଭିକ୍ଷ ସେମାନଙ୍କ ପ୍ରତି ଅତି ଅସହ୍ୟ ହୁଅନ୍ତେ, ମିସରୀୟମାନେ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ଭୂମି ବିକ୍ରୟ କଲେ; ତହିଁରେ ଯୋଷେଫ ଫାରୋଙ୍କ ନିମନ୍ତେ ମିସର ଦେଶର ସମସ୍ତ ଭୂମି କ୍ରୟ କଲେ; ତେଣୁ ସମସ୍ତ ଭୂମି ଫାରୋଙ୍କର ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ତହିଁରେ ସେ ମିସରର ଏକ ସୀମାଠାରୁ ଅନ୍ୟ ସୀମା ପର୍ଯ୍ୟନ୍ତ ନଗରେ ନଗରେ ପ୍ରଜାମାନଙ୍କୁ ପ୍ରବାସ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ସେ କେବଳ ଯାଜକମାନଙ୍କର ଭୂମି କ୍ରୟ କଲେ ନାହିଁ; କାରଣ ଯାଜକମାନେ ଫାରୋଙ୍କଠାରୁ ବୃତ୍ତି ପାଇଲେ; ଏଣୁ ଫାରୋଙ୍କର ଦତ୍ତ ବୃତ୍ତି ଦ୍ୱାରା ସେମାନଙ୍କର ନିର୍ବାହ ହେବାରୁ ସେମାନେ ଆପଣା ଆପଣା ଭୂମି ବିକ୍ରୟ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ପ୍ରଜାମାନଙ୍କୁ କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ଫାରୋଙ୍କ ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କୁ ଓ ତୁମ୍ଭମାନଙ୍କ ଭୂମି ସବୁ କିଣିଲୁ; ଏବେ ଏହି ବିହନ ନେଇ ଭୂମିରେ ବୁଣ। ");
INSERT INTO ory_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ତହିଁରୁ ଯାହା ଉତ୍ପନ୍ନ ହେବ, ତାହାର ପଞ୍ଚମାଂଶ ଫାରୋଙ୍କୁ ଦେବ, ପୁଣି, ଅନ୍ୟ ଚାରି ଅଂଶ ଭୂମିର ବିହନ ପାଇଁ ଓ ଆପଣା ଆପଣା ପରିଜନ ଓ ବାଳକମାନଙ୍କ ନିମନ୍ତେ ରଖିବ।” ");
INSERT INTO ory_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ତହିଁରେ ସେମାନେ କହିଲେ, “ଆପଣ ଆମ୍ଭମାନଙ୍କ ପ୍ରାଣ ରକ୍ଷା କଲେ; ଆପଣଙ୍କ କୃପାଦୃଷ୍ଟି ହେଲେ, ଆମ୍ଭେମାନେ ଫାରୋଙ୍କର ଦାସ ହେବୁ।” ");
INSERT INTO ory_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ପଞ୍ଚମାଂଶ ଫାରୋ ପାଇବେ, ମିସରର ସମସ୍ତ ଭୂମି ବିଷୟରେ ଯୋଷେଫଙ୍କର ସ୍ଥାପିତ ଏହି ନିୟମ ଆଜି ପର୍ଯ୍ୟନ୍ତ ଚଳୁଅଛି; କେବଳ ଯାଜକମାନଙ୍କର ଭୂମି ଫାରୋଙ୍କର ହେଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ସେସମୟରେ ଇସ୍ରାଏଲ ମିସରର ଗୋଶନ ପ୍ରଦେଶରେ ବାସ କଲେ, ପୁଣି, ସେଠାରେ ସେମାନେ ଅଧିକାର ପାଇ ପ୍ରଜାବନ୍ତ ଓ ଅତିଶୟ ବହୁବଂଶ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ଯାକୁବ ମିସର ଦେଶରେ ସତର ବର୍ଷ କାଳ କ୍ଷେପଣ କଲେ, ତାଙ୍କର ପରମାୟୁର ଦିବସ ଶହେ ସତଚାଳିଶ ବର୍ଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ଇସ୍ରାଏଲଙ୍କର ମରଣ ଦିନ ସନ୍ନିକଟ ହେବାରୁ ସେ ଆପଣା ପୁତ୍ର ଯୋଷେଫଙ୍କୁ ଡକାଇ କହିଲେ, “ମୁଁ ଯଦି ତୁମ୍ଭ ସାକ୍ଷାତରେ ଅନୁଗ୍ରହ ପାଇଲି, ତେବେ ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ମୋʼ ଜଙ୍ଘରେ ହସ୍ତ ଦିଅ; ପୁଣି, ମୋʼ ପ୍ରତି ଦୟା ଓ ସତ୍ୟ ବ୍ୟବହାର କରି ଏହି ମିସର ଦେଶରେ ମୋତେ କବର ଦିଅ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ମାତ୍ର ମୁଁ ଆପଣା ପୂର୍ବପୁରୁଷମାନଙ୍କ ସହିତ ଶୟନ କଲେ, ତୁମ୍ଭେ ମୋତେ ଏହି ମିସର ଦେଶରୁ ଘେନିଯାଇ ସେମାନଙ୍କ କବର ସ୍ଥାନରେ କବରଶାୟୀ କରାଅ।” ତହିଁରେ ଯୋଷେଫ କହିଲେ, “ତୁମ୍ଭ ଆଜ୍ଞା ପ୍ରମାଣେ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ତହୁଁ ଯାକୁବ ଯୋଷେଫଙ୍କୁ ଶପଥ କରିବାକୁ କହନ୍ତେ, “ସେ ତାଙ୍କ ନିକଟରେ ଶପଥ କଲେ।” ସେତେବେଳେ ଇସ୍ରାଏଲ ଶଯ୍ୟାର ମୁଣ୍ଡଆଡ଼େ ପ୍ରଣାମ କରି ପରମେଶ୍ୱରଙ୍କ ଆରାଧନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ସେହି ସବୁ ଘଟଣା ଉତ୍ତାରେ କେହି ଯୋଷେଫଙ୍କୁ ସମ୍ବାଦ ଦେଇ କହିଲା; “ଦେଖ, ତୁମ୍ଭ ପିତା ପୀଡ଼ିତ ଅଛନ୍ତି,” ତହିଁରେ ସେ ଆପଣାର ଦୁଇ ପୁତ୍ର ମନଃଶି ଓ ଇଫ୍ରୟିମଙ୍କୁ ସଙ୍ଗରେ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ସେତେବେଳେ କେହି ଯାକୁବଙ୍କୁ କହିଲା, “ଦେଖ, ତୁମ୍ଭ ପୁତ୍ର ଯୋଷେଫ ତୁମ୍ଭ ନିକଟକୁ ଆସିଅଛି,” ତହିଁରେ ଇସ୍ରାଏଲ ଆପଣାକୁ ସବଳ କରି ଶଯ୍ୟାରେ ଉଠି ବସିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଯୋଷେଫଙ୍କୁ କହିଲେ, “କିଣାନ ଦେଶରେ ଲୂସ୍‍ ନାମକ ସ୍ଥାନରେ ସର୍ବଶକ୍ତିମାନ ପରମେଶ୍ୱର ମୋତେ ଦର୍ଶନ ଦେଇ ଆଶୀର୍ବାଦ କରି ଏହା କହିଥିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ କରିବା ଓ ତୁମ୍ଭଠାରୁ ନାନା ଜନସମାଜ ଉତ୍ପନ୍ନ କରିବା, ପୁଣି, ତୁମ୍ଭ ଭବିଷ୍ୟଦ୍‍ବଂଶକୁ ଅନନ୍ତକାଳୀନ ଅଧିକାର ନିମନ୍ତେ ଏହି ଦେଶ ଦେବା।’ ");
INSERT INTO ory_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ଏହେତୁ ମିସର ଦେଶରେ ତୁମ୍ଭ ନିକଟକୁ ମୋହର ଆସିବା ପୂର୍ବେ ତୁମ୍ଭର ଯେଉଁ ଦୁଇ ପୁତ୍ର ମିସର ଦେଶରେ ଜନ୍ମିଥିଲେ, ସେମାନେ ମୋହର ହେବେ; ରୁବେନ୍‍ ଓ ଶିମୀୟୋନ ତୁଲ୍ୟ ଇଫ୍ରୟିମ ଓ ମନଃଶି ମୋହର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ପୁଣି, ଏମାନଙ୍କ ଉତ୍ତାରେ ତୁମ୍ଭର ଯେଉଁ ସନ୍ତାନ ଜାତ ହେବେ, ସେମାନେ ତୁମ୍ଭର ହେବେ ଓ ଜ୍ୟେଷ୍ଠ ଭାଇମାନଙ୍କ ନାମରେ ଆପଣା ଆପଣା ଅଧିକାରରେ ବିଖ୍ୟାତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ପଦ୍ଦନ୍‍ ଅରାମଠାରୁ କିଣାନ ଦେଶକୁ ମୋହର ଆଗମନ କାଳରେ ଇଫ୍ରାଥାରେ ପହଞ୍ଚିବା ନିମିତ୍ତ କିଛି ଦୂର ଥାଉ ଥାଉ ରାହେଲ ପଥ ମଧ୍ୟରେ ମୋʼ ନିକଟରେ ମଲା; ତହିଁରେ ମୁଁ ସେଠାରେ ଇଫ୍ରାଥାରେ, ଅର୍ଥାତ୍‍, ବେଥଲିହିମର ପଥ ପାର୍ଶ୍ୱରେ ତାକୁ କବର ଦେଲି।” ");
INSERT INTO ory_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ ଯୋଷେଫଙ୍କର ପୁତ୍ରମାନଙ୍କୁ ଦେଖି ପଚାରିଲେ, “ଏମାନେ କିଏ?” ");
INSERT INTO ory_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ତହିଁରେ ଯୋଷେଫ ପିତାଙ୍କୁ କହିଲେ, “ଏମାନେ ମୋହର ପୁତ୍ର, ପରମେଶ୍ୱର ଏମାନଙ୍କୁ ଏହି ଦେଶରେ ମୋତେ ଦେଇଅଛନ୍ତି।” ତେବେ ଇସ୍ରାଏଲ କହିଲେ, “ବିନୟ କରୁଅଛି, ଏମାନଙ୍କୁ ମୋʼ ନିକଟକୁ ଆଣ, ମୁଁ ଏମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ସେହି ସମୟରେ ଇସ୍ରାଏଲ ବୃଦ୍ଧାବସ୍ଥା ହେତୁ କ୍ଷୀଣଦୃଷ୍ଟି ହେବାରୁ ସ୍ପଷ୍ଟରୂପେ ଦେଖି ପାରିଲେ ନାହିଁ। ଏଣୁ ଯୋଷେଫ ତାଙ୍କ କତିକି ସେମାନଙ୍କୁ ଆଣି ଦିଅନ୍ତେ, ସେ ସେମାନଙ୍କୁ ଚୁମ୍ବନ ଓ ଆଲିଙ୍ଗନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ପୁଣି, ଇସ୍ରାଏଲ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ମୁଁ ଭାବିଥିଲି, ତୁମ୍ଭ ମୁଖ ଆଉ ଦେଖି ପାରିବି ନାହିଁ; ମାତ୍ର ଦେଖ, ପରମେଶ୍ୱର ତୁମ୍ଭର ବଂଶ ମଧ୍ୟ ମୋତେ ଦେଖାଇଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ତହୁଁ ଯୋଷେଫ ପିତାଙ୍କର ଦୁଇ ଜଙ୍ଘ ମଧ୍ୟରୁ ସେମାନଙ୍କୁ ନେଇ ଆପେ ଭୂମିଷ୍ଠ ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ସେ ଦୁହିଁଙ୍କୁ ନେଇ ଆପଣା ଦକ୍ଷିଣ ହସ୍ତରେ ଇଫ୍ରୟିମକୁ ଧରି ଇସ୍ରାଏଲଙ୍କ ବାମ ପାର୍ଶ୍ୱରେ ଓ ବାମ ହସ୍ତରେ ମନଃଶିକୁ ଧରି ଇସ୍ରାଏଲଙ୍କ ଡାହାଣ ପାର୍ଶ୍ୱରେ ଉପସ୍ଥିତ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ତହିଁରେ ଇସ୍ରାଏଲ ଆପଣା ଡାହାଣ ହସ୍ତ ବଢ଼ାଇ କନିଷ୍ଠ ଇଫ୍ରୟିମର ମସ୍ତକ ଉପରେ ରଖିଲେ, ପୁଣି, ମନଃଶିର ମସ୍ତକ ଉପରେ ବାମ ହସ୍ତ ରଖିଲେ, ସେ ବିବେଚନାପୂର୍ବକ ଆପଣା ହସ୍ତ ଏରୂପ ଚଳାଇଲେ; କାରଣ ମନଃଶି ପ୍ରଥମଜାତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ଏଥିଉତ୍ତାରେ ସେ ଯୋଷେଫଙ୍କୁ ଆଶୀର୍ବାଦ କରି କହିଲେ, “ଯେଉଁ ପରମେଶ୍ୱରଙ୍କ ସାକ୍ଷାତରେ ମୋହର ପୂର୍ବପୁରୁଷ ଅବ୍ରହାମ ଓ ଇସ୍‌ହାକ ଗମନାଗମନ କରିଥିଲେ, ଯେଉଁ ପରମେଶ୍ୱର ଜନ୍ମ ଦିନଠାରୁ ଆଜି ପର୍ଯ୍ୟନ୍ତ ମୋତେ ପ୍ରତିପାଳନ କରିଅଛନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ଯେଉଁ ଦୂତ ସମସ୍ତ ଆପଦରୁ ମୋତେ ମୁକ୍ତ କରିଅଛନ୍ତି, ସେ ଏହି ବାଳକମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରନ୍ତୁ; ଏମାନେ ମୋʼ ନାମରେ ଓ ମୋହର ପୂର୍ବପୁରୁଷ ଅବ୍ରହାମ ଓ ଇସ୍‌ହାକଙ୍କ ନାମରେ ବିଖ୍ୟାତ ହେଉନ୍ତୁ, ପୁଣି, ଏମାନେ ଦେଶ ମଧ୍ୟରେ ବୃଦ୍ଧି ପାଇ ଲୋକସମୂହ ହେଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ସେତେବେଳେ ଇଫ୍ରୟିମର ମସ୍ତକରେ ପିତାଙ୍କର ଦକ୍ଷିଣ ହସ୍ତ ଦେଖି ଯୋଷେଫ ଅସନ୍ତୁଷ୍ଟ ହେଲେ; ଏହେତୁ ଇଫ୍ରୟିମର ମସ୍ତକରୁ ମନଃଶିର ମସ୍ତକରେ ତାହା ସ୍ଥାପନ କରିବାକୁ ପିତାଙ୍କର ହସ୍ତ ଉଠାଇ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“ପିତଃ, ଏପରି ନୁହେଁ, ଏହି ଜଣ ଜ୍ୟେଷ୍ଠ, ଏହାର ମସ୍ତକରେ ଦକ୍ଷିଣ ହସ୍ତ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ମାତ୍ର ତାଙ୍କର ପିତା ଅସମ୍ମତ ହୋଇ କହିଲେ, “ହେ ପୁତ୍ର; ତାହା ମୁଁ ଜାଣେ, ମୁଁ ଜାଣେ; ସେ ମଧ୍ୟ ଏକ ଗୋଷ୍ଠୀ ହେବ ଓ ସେ ମଧ୍ୟ ମହାନ ହେବ; ମାତ୍ର ତାହାର କନିଷ୍ଠ ଭ୍ରାତା ତାହାଠାରୁ ଅଧିକ ମହାନ ହେବ ଓ ତାହାର ବଂଶ ବହୁଗୋଷ୍ଠୀକ ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ସେହି ଦିନ ସେ ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରି କହିଲେ, “ଇସ୍ରାଏଲ ବଂଶ ଆଶୀର୍ବାଦ କରିବା ସମୟରେ ତୁମ୍ଭମାନଙ୍କ ନାମ ଧରି କହିବେ, ‘ପରମେଶ୍ୱର ତୁମ୍ଭକୁ ଇଫ୍ରୟିମ ଓ ମନଃଶି ତୁଲ୍ୟ କରନ୍ତୁ।’” ଏହି ପ୍ରକାରେ ସେ ମନଃଶିଠାରୁ ଇଫ୍ରୟିମକୁ ଅଗ୍ରଗଣ୍ୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ଆଉ ଇସ୍ରାଏଲ ଯୋଷେଫଙ୍କୁ କହିଲେ, “ଦେଖ, ମୁଁ ମରୁଅଛି; ମାତ୍ର ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଥିବେ ଓ ତୁମ୍ଭମାନଙ୍କୁ ପୁନର୍ବାର ପୈତୃକ ଦେଶକୁ ନେଇଯିବେ। ");
INSERT INTO ory_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ମୁଁ ଆପଣା ଖଡ୍ଗ ଓ ଧନୁ ଦ୍ୱାରା ଇମୋରୀୟମାନଙ୍କ ହସ୍ତରୁ ଯେଉଁ ଅଂଶ ପାଇଅଛି, ତୁମ୍ଭ ଭ୍ରାତୃଗଣ ଅପେକ୍ଷା ସେହି ଅଧିକ ଅଂଶ ତୁମ୍ଭକୁ ଦେଲି।” ");
INSERT INTO ory_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଆପଣା ପୁତ୍ରମାନଙ୍କୁ ଡାକି କହିଲେ, “ତୁମ୍ଭେମାନେ ଏକତ୍ର ହୁଅ; ଶେଷ କାଳରେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଯାହା ଘଟିବ, ତାହା ତୁମ୍ଭମାନଙ୍କୁ କହୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ହେ ଯାକୁବର ପୁତ୍ରଗଣ, ଏକତ୍ର ହୋଇ ଶୁଣ ଓ ତୁମ୍ଭମାନଙ୍କ ପିତା ଇସ୍ରାଏଲର ବାକ୍ୟ ଶୁଣ। ");
INSERT INTO ory_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ହେ ରୁବେନ୍‍, ତୁମ୍ଭେ ମୋହର ପ୍ରଥମଜାତ (ପୁତ୍ର), ମୋହର ବଳ ଓ ମୋʼ ଶକ୍ତିର ପ୍ରଥମ ଫଳ; ପୁଣି, ମହିମାରେ ପ୍ରଧାନ ଓ ପରାକ୍ରମରେ ପ୍ରଧାନ। ");
INSERT INTO ory_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ତୁମ୍ଭେ ଉଚ୍ଛଳିତ ଜଳ ତୁଲ୍ୟ, ତୁମ୍ଭର ପ୍ରଧାନତା ରହିବ ନାହିଁ; କାରଣ ତୁମ୍ଭେ ଆପଣା ପିତୃଶଯ୍ୟାକୁ ଗମନ କଲ; ତେବେ ତାହା ଅଶୁଚି କଲ; ସେ ମୋହର ଶଯ୍ୟାକୁ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ଶିମୀୟୋନ ଓ ଲେବୀ ଦୁଇ ସହୋଦର; ସେମାନଙ୍କ ଖଡ୍ଗ ଦୌରାତ୍ମ୍ୟର ଅସ୍ତ୍ର। ");
INSERT INTO ory_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ହେ ମୋହର ପ୍ରାଣ, ସେମାନଙ୍କ ଗୁପ୍ତ ମନ୍ତ୍ରଣାରେ ପ୍ରବେଶ କର ନାହିଁ; ହେ ମୋହର ଗୌରବ, ତୁମ୍ଭେ ସେମାନଙ୍କ ସଭାରେ ମିଳିତ ହୁଅ ନାହିଁ; କାରଣ ସେମାନେ କ୍ରୋଧରେ ନରହତ୍ୟା କଲେ ଓ ସ୍ୱେଚ୍ଛାଚାରିତାରେ ବଳଦଗୁଡ଼ିକର ଲାଙ୍ଗୁଡ଼ କାଟିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ସେମାନଙ୍କ କ୍ରୋଧ ଅଭିଶପ୍ତ ହେଉ, କାରଣ ତାହା ପ୍ରଚଣ୍ଡ ଥିଲା; ସେମାନଙ୍କ କୋପ ଅଭିଶପ୍ତ ହେଉ, କାରଣ ତାହା ନିଷ୍ଠୁର ଥିଲା; ମୁଁ ଯାକୁବ ମଧ୍ୟରେ ସେମାନଙ୍କୁ ବିଭାଗ କରିବି ଓ ଇସ୍ରାଏଲ ମଧ୍ୟରେ ଛିନ୍ନଭିନ୍ନ କରିବି। ");
INSERT INTO ory_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ହେ ଯିହୁଦା, ତୁମ୍ଭର ଭାଇମାନେ ତୁମ୍ଭକୁ ପ୍ରଶଂସା କରିବେ; ତୁମ୍ଭର ହସ୍ତ ତୁମ୍ଭ ଶତ୍ରୁଗଣର ଗଳା ଉପରେ ରହିବ; ତୁମ୍ଭର ପିତୃସନ୍ତାନମାନେ ତୁମ୍ଭକୁ ପ୍ରଣାମ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ଯିହୁଦା ସିଂହଶାବକ; ହେ ପୁତ୍ର, ତୁମ୍ଭେ ମୃଗ ବିଦାରଣରୁ ଉଠି ଆସିଲ; ସେ ନଇଁ ପଡ଼ିଲା, ସେ ସିଂହ ଓ ସିଂହୀର ନ୍ୟାୟ ଶୟନ କଲା, କିଏ ତାହାକୁ ଉଠାଇବ? ");
INSERT INTO ory_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ଶୀଲୋର ଆଗମନ ପର୍ଯ୍ୟନ୍ତ ଯିହୁଦାଠାରୁ ରାଜଦଣ୍ଡ ଓ ତାହାର ଚରଣଦ୍ୱୟ ମଧ୍ୟରୁ ବିଚାରକର୍ତ୍ତାର ଯଷ୍ଟି ଯିବ ନାହିଁ; ତାହାଙ୍କ ନିକଟରେ ଲୋକମାନେ ଅଧୀନତା ସ୍ୱୀକାର କରିବେ। ");
INSERT INTO ory_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ସେ ଦ୍ରାକ୍ଷାଲତା ନିକଟରେ ଆପଣା ବାଛରାକୁ ଓ ଉତ୍ତମ ଦ୍ରାକ୍ଷାଲତା ନିକଟରେ ଆପଣା ଗର୍ଦ୍ଦଭ ଶାବକକୁ ବାନ୍ଧିବ; ସେ ଦ୍ରାକ୍ଷାରସରେ ଆପଣା ଉତ୍ତରୀୟ ବସ୍ତ୍ର ଓ ଦ୍ରାକ୍ଷାରସରେ ଆପଣା ପରିଧେୟ ବସ୍ତ୍ର ଧୋଇବ। ");
INSERT INTO ory_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ତାହାର ଚକ୍ଷୁ ଦ୍ରାକ୍ଷାରସରେ ରକ୍ତବର୍ଣ୍ଣ ହେବ, ଦୁଗ୍ଧରେ ତାହାର ଦନ୍ତ ଶ୍ୱେତବର୍ଣ୍ଣ ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ସବୂଲୂନ ସମୁଦ୍ର ବନ୍ଦରରେ ବାସ କରିବ ଓ ସେ ଜାହାଜର ଆଶ୍ରିତ ବନ୍ଦର ହେବ; ପୁଣି, ସୀଦୋନ ପର୍ଯ୍ୟନ୍ତ ତାହାର ଅଧିକାରର ସୀମା ହେବ। ");
INSERT INTO ory_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ଇଷାଖର ବଳବାନ ଗର୍ଦ୍ଦଭ ସଦୃଶ, ସେ ମେଷ ଖୁଆଡ଼ ମଧ୍ୟରେ ଶୟନ କରେ; ");
INSERT INTO ory_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ସେ ବିଶ୍ରାମ-ସ୍ଥାନକୁ ଉତ୍ତମ ଓ ଦେଶକୁ ସୁରମ୍ୟ ଦେଖିଲା; ଏଣୁ ସେ ଭାର ବହିବା ପାଇଁ ସ୍କନ୍ଧ ନତ କଲା, ବେଠିକର୍ମ କରିବାକୁ ଦାସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ଦାନ୍ ଇସ୍ରାଏଲର ଅନ୍ୟାନ୍ୟ ବଂଶ ତୁଲ୍ୟ ହୋଇ ଆପଣା ଲୋକମାନଙ୍କର ବିଚାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ଦାନ୍ ପଥସ୍ଥିତ ସର୍ପ ତୁଲ୍ୟ ଓ ମାର୍ଗସ୍ଥିତ ଫଣି ତୁଲ୍ୟ; ଯେ ଘୋଟକର ପାଦ ଦଂଶନ କଲେ ତଦାରୂଢ଼ ବ୍ୟକ୍ତି ପଶ୍ଚାତ୍‍ ପଡ଼ିଯାଏ। ");
INSERT INTO ory_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ହେ ସଦାପ୍ରଭୋ, ମୁଁ ତୁମ୍ଭ ପରିତ୍ରାଣର ଅପେକ୍ଷାରେ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ସୈନ୍ୟଦଳ ଗାଦ୍‍କୁ ଆକ୍ରମଣ କରିବେ; ମାତ୍ର ସେ ପଶ୍ଚାତ୍‍ ସେମାନଙ୍କୁ ଆକ୍ରମଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ଆଶେରଠାରୁ ଅତ୍ୟୁତ୍ତମ ଖାଦ୍ୟ ଉତ୍ପନ୍ନ ହେବ; ସେ ରାଜକୀୟ ଭକ୍ଷ୍ୟ ଯୋଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","ନପ୍ତାଲି ଦୀର୍ଘାଙ୍ଗୀ ହରିଣୀ ସ୍ୱରୂପ, ସେ ମନୋହର ବାକ୍ୟ କହିବ। ");
INSERT INTO ory_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ଯୋଷେଫ ଫଳଦାୟୀ ବୃକ୍ଷର ପଲ୍ଲବ, ସେ ନିର୍ଝର ନିକଟସ୍ଥ ଫଳଦାୟୀ ବୃକ୍ଷର ପଲ୍ଲବ ସ୍ୱରୂପ; ତାହାର ଶାଖା ସକଳ ପ୍ରାଚୀର ଅତିକ୍ରମ କରେ। ");
INSERT INTO ory_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ଧନୁର୍ଦ୍ଧରମାନେ ତାହାକୁ ଅତିଶୟ କ୍ଳେଶ ଦେଇଅଛନ୍ତି, ପୁଣି, ତାକୁ ତୀର ବିନ୍ଧି ତାଡ଼ନା କରିଅଛନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ମାତ୍ର ତାହାର ଧନୁ ଦୃଢ଼ ହୋଇ ରହିଲା, ପୁଣି, ଯେ ଯାକୁବର ବଳଦାତା (ତହିଁ ସକାଶୁ ଇସ୍ରାଏଲର ପାଳକ ଓ ଶୈଳ ବୋଲି ବିଖ୍ୟାତ), ");
INSERT INTO ory_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ଅର୍ଥାତ୍‍, ପୈତୃକ ପରମେଶ୍ୱର, ଯେ ତୁମ୍ଭର ଉପକାର କରିବେ ଓ ସର୍ବଶକ୍ତିମାନ, ଯେ ଉପରିସ୍ଥ ଆକାଶରୁ ମଙ୍ଗଳ, ଅଧଃସ୍ଥାନରେ ବିସ୍ତୀର୍ଣ୍ଣ ବାରିଧିରୁ ମଙ୍ଗଳ, ସ୍ତନ ଓ ଗର୍ଭରୁ ମଙ୍ଗଳ ଦେଇ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରିବେ, ତାହାଙ୍କ ଦ୍ୱାରା ତାହାର ହସ୍ତର ବାହୁ ବଳବାନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ମୋହର ପୂର୍ବପୁରୁଷମାନଙ୍କ ଆଶୀର୍ବାଦଠାରୁ ତୁମ୍ଭ ପିତାଙ୍କର ଆଶୀର୍ବାଦ ଅଧିକ; ତାହା ଚିରସ୍ଥାୟୀ ପର୍ବତର ସୀମା ପର୍ଯ୍ୟନ୍ତ ବ୍ୟାପ୍ତ ହେବ; ତାହା ଯୋଷେଫର ମସ୍ତକରେ, ଅର୍ଥାତ୍‍, ଆପଣା ଭ୍ରାତୃଗଣଠାରୁ ପୃଥକ କୃତ ବ୍ୟକ୍ତିର ମସ୍ତକାଗ୍ରରେ ବର୍ତ୍ତିବ। ");
INSERT INTO ory_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ବିନ୍ୟାମୀନ୍ ବିଦାରକ କେନ୍ଦୁଆ ତୁଲ୍ୟ; ପ୍ରାତଃକାଳରେ ସେ ମୃଗ ଭକ୍ଷଣ ଓ ସନ୍ଧ୍ୟାକାଳରେ ଶିକାର ବଣ୍ଟନ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ଏମାନେ ଇସ୍ରାଏଲଙ୍କର ଦ୍ୱାଦଶ ବଂଶ; ଏମାନଙ୍କ ପିତା ଆଶୀର୍ବାଦ କରିବା ବେଳେ ଏହି କଥା କହି ଏମାନଙ୍କର ପ୍ରତି ଜଣକୁ ବିଶେଷ ବିଶେଷ ଆଶୀର୍ବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ଏଥିଉତ୍ତାରେ ଯାକୁବ ସେମାନଙ୍କୁ ଆଦେଶ ଦେଇ କହିଲେ, “ମୁଁ ଆପଣା ଲୋକଙ୍କ ସଙ୍ଗେ ସଂଗୃହୀତ ହେବାକୁ ଉଦ୍ୟତ। ");
INSERT INTO ory_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ଏହେତୁ ଅବ୍ରହାମ କବର ସ୍ଥାନର ଅଧିକାର ନିମନ୍ତେ କିଣାନ ଦେଶରେ ମମ୍ରିର ସମ୍ମୁଖସ୍ଥ ଯେଉଁ ମକ୍‍ପେଲାର କ୍ଷେତ୍ର ହିତ୍ତୀୟ ଇଫ୍ରୋଣଠାରୁ କିଣିଥିଲେ, ସେହି ହିତ୍ତୀୟ ଇଫ୍ରୋଣର କ୍ଷେତ୍ରସ୍ଥିତ ଗୁହାରେ ମୋହର ପୂର୍ବପୁରୁଷମାନଙ୍କ ନିକଟରେ ମୋତେ କବର ଦେବ। ");
INSERT INTO ory_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ସେହି ସ୍ଥାନରେ ଅବ୍ରହାମଙ୍କର ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟା ସାରାର କବର ହୋଇଅଛି, ପୁଣି, ସେହି ସ୍ଥାନରେ ଇସ୍‌ହାକଙ୍କର ଓ ତାଙ୍କର ଭାର୍ଯ୍ୟା ରିବିକାର କବର ହୋଇଅଛି, ପୁଣି, ସେହି ସ୍ଥାନରେ ମୁଁ ମଧ୍ୟ ଲେୟାକୁ କବର ଦେଇଅଛି; ");
INSERT INTO ory_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ସେହି କ୍ଷେତ୍ର ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ଗୁହା ହିତ୍ତୀୟ ସନ୍ତାନମାନଙ୍କଠାରୁ କିଣା ହୋଇଅଛି।” ");
INSERT INTO ory_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ଏହିରୂପେ ଯାକୁବ ଆପଣା ପୁତ୍ରମାନଙ୍କୁ ଆଜ୍ଞା ଦେବାର ସମାପ୍ତ କଲା ଉତ୍ତାରେ ଶଯ୍ୟାରେ ଦୁଇ ପାଦ ଏକତ୍ର କରି ପ୍ରାଣତ୍ୟାଗ କଲେ ଓ ଆପଣା ଲୋକମାନଙ୍କ ନିକଟରେ ସଂଗୃହୀତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ସେତେବେଳେ ଯୋଷେଫ ଆପଣା ପିତାଙ୍କର ମୁଖରେ ମୁଖ ଦେଇ ରୋଦନ କରି ଚୁମ୍ବନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ପୁଣି, ଯୋଷେଫ ଆପଣା ପିତାଙ୍କର ଶବ ପୂତିଘ୍ନ ଦ୍ରବ୍ୟାକ୍ତ କରିବା ପାଇଁ ଆପଣା ଦାସ ବୈଦ୍ୟମାନଙ୍କୁ ଆଜ୍ଞା ଦେଲେ; ତହିଁରେ ବୈଦ୍ୟମାନେ ଇସ୍ରାଏଲଙ୍କର ଶବକୁ ପୂତିଘ୍ନ ଦ୍ରବ୍ୟ ଯୁକ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ତାହା ପାଇଁ ଚାଳିଶ ଦିନ ଲାଗିଲା; ଯେହେତୁ ପୂତିଘ୍ନ ଦ୍ରବ୍ୟାକ୍ତ କରିବାକୁ ଚାଳିଶ ଦିନ ଲାଗେ; ପୁଣି, ମିସରୀୟ ଲୋକମାନେ ତାଙ୍କ ନିମନ୍ତେ ସତୁରି ଦିନ ଯାଏ ଶୋକ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ସେହି ଶୋକ ଦିନ ଗତ ହୁଅନ୍ତେ, ଯୋଷେଫ ଫାରୋଙ୍କର ପରିଜନଙ୍କୁ କହିଲେ, “ଯଦି ମୁଁ ତୁମ୍ଭମାନଙ୍କ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇଥାଏ, ତେବେ ବିନୟ କରୁଅଛି, ଫାରୋଙ୍କ କର୍ଣ୍ଣଗୋଚରେ ଏହି କଥା କୁହ, ");
INSERT INTO ory_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ମୋʼ ପିତା ମୋତେ ଶପଥ କରାଇ କହିଅଛନ୍ତି, ‘ଦେଖ, ଆମ୍ଭେ ମଲେ, କିଣାନ ଦେଶରେ ଆପଣା ନିମନ୍ତେ ଯେଉଁ କବର ଖନନ କରିଅଛୁ, ତହିଁରେ ଆମ୍ଭକୁ କବର ଦେବ।’ ଏଣୁ ଏବେ ମୋତେ ଯିବାକୁ ଦିଅନ୍ତୁ, ମୁଁ ପିତାଙ୍କୁ କବର ଦେଇ ପୁନର୍ବାର ଆସିବି।” ");
INSERT INTO ory_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ତହିଁରେ ଫାରୋ କହିଲେ, “ଯାଅ, ତୁମ୍ଭ ପିତା ତୁମ୍ଭକୁ ଯେଉଁ ଶପଥ କରାଇଅଛନ୍ତି, ତୁମ୍ଭେ ତଦନୁସାରେ ତାଙ୍କୁ କବର ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ତହୁଁ ଯୋଷେଫ ଆପଣା ପିତାଙ୍କୁ କବର ଦେବାକୁ ଯାତ୍ରା କଲେ; ତହିଁରେ ଫାରୋଙ୍କର ଦାସମାନେ ଓ ତାଙ୍କ ଗୃହର ପ୍ରଧାନ ଲୋକମାନେ ଓ ମିସର ଦେଶର ପ୍ରଧାନ ଲୋକମାନେ, ");
INSERT INTO ory_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ପୁଣି, ଯୋଷେଫଙ୍କର ସମସ୍ତ ପରିବାର ଓ ତାଙ୍କର ଭ୍ରାତୃଗଣ ଓ ତାଙ୍କର ପିତୃପରିବାର ତାଙ୍କ ସଙ୍ଗେ ଗମନ କଲେ; ଗୋଶନ ପ୍ରଦେଶରେ ସେମାନେ କେବଳ ଆପଣାମାନଙ୍କ ବାଳକଗଣ ଓ ମେଷପଲ ଓ ଗୋପଲ ଛାଡ଼ିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ତାଙ୍କ ସଙ୍ଗରେ ରଥ ଓ ଅଶ୍ୱାରୋହୀଗଣ ଗମନ ଗଲେ; ତହିଁରେ ଅତିଶୟ ସମାରୋହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ଏଥିଉତ୍ତାରେ ସେମାନେ ଯର୍ଦ୍ଦନ ପାରସ୍ଥ ଆଟଦର ଖଳାରେ ଉପସ୍ଥିତ ହୁଅନ୍ତେ, ସେଠାରେ ମହା ବିଳାପ କରି ରୋଦନ କଲେ; ଯୋଷେଫ ସେଠାରେ ଆପଣା ପିତାଙ୍କ ଲାଗି ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ଶୋକ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ପୁଣି, ସେହି ଦେଶ ନିବାସୀ କିଣାନୀୟ ଲୋକମାନେ ଆଟଦର ଖଳାରେ ସେମାନଙ୍କର ଏରୂପ ଶୋକ ଦେଖି କହିଲେ, “ମିସରୀୟମାନଙ୍କର ଏ ଅତି ଦାରୁଣ ଶୋକ,” ତେଣୁକରି ଯର୍ଦ୍ଦନ ପାରସ୍ଥ ସେହି ସ୍ଥାନ ଆବେଲ୍‍ ମିସର ନାମରେ ବିଖ୍ୟାତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ଏଥିଉତ୍ତାରେ ଯାକୁବ ଆପଣା ପୁତ୍ରମାନଙ୍କୁ ଯେପରି ଆଜ୍ଞା ଦେଇଥିଲେ, ସେମାନେ ତାଙ୍କ ପ୍ରତି ତଦନୁସାରେ କଲେ; ");
INSERT INTO ory_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ଅର୍ଥାତ୍‍, ତାଙ୍କର ପୁତ୍ରମାନେ ତାଙ୍କୁ କିଣାନ ଦେଶକୁ ନେଇ ମକ୍‍ପେଲା କ୍ଷେତ୍ରରେ ମଧ୍ୟବର୍ତ୍ତୀ ଗୁହାରେ କବର ଦେଲେ; ସେହି ଗୁହା ମମ୍ରିର ସମ୍ମୁଖସ୍ଥ କ୍ଷେତ୍ର ସହିତ କବର ସ୍ଥାନାଧିକାର ନିମିତ୍ତ ହିତ୍ତୀୟ ଇଫ୍ରୋଣଠାରୁ ଅବ୍ରହାମଙ୍କ ଦ୍ୱାରା କ୍ରୀତ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ଯୋଷେଫ ଆପଣା ପିତାଙ୍କୁ କବର ଦେଲା ଉତ୍ତାରେ ସେ ଓ ତାଙ୍କର ଭ୍ରାତୃଗଣ ପ୍ରଭୃତି ଯେତେ ଲୋକ ତାଙ୍କ ପିତାଙ୍କର କବର ଦେବାକୁ ତାଙ୍କ ସଙ୍ଗେ ଯାଇଥିଲେ, ସମସ୍ତେ ମିସରକୁ ପ୍ରତ୍ୟାଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ଆଉ ଆପଣାମାନଙ୍କର ପିତା ମରିଅଛନ୍ତି, ଏହା ଦେଖି ଯୋଷେଫଙ୍କର ଭାଇମାନେ କହିଲେ, “କେଜାଣି ଯୋଷେଫ ଆମ୍ଭମାନଙ୍କୁ ଘୃଣା କରିବ, ପୁଣି, ଆମ୍ଭେମାନେ ତାହାର ଯେସକଳ ମନ୍ଦ କରିଅଛୁ, ତହିଁର ସମ୍ପୂର୍ଣ୍ଣ ପ୍ରତିଫଳ ଆମ୍ଭମାନଙ୍କୁ ଦେବ।” ");
INSERT INTO ory_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ଏହେତୁ ସେମାନେ ଯୋଷେଫଙ୍କ ନିକଟକୁ ଏହି କଥା କହି ପଠାଇଲେ, “ତୁମ୍ଭ ପିତା ମୃତ୍ୟୁୁ ପୂର୍ବରେ ଆମ୍ଭମାନଙ୍କୁ ଏହା କହିଥିଲେ, ତୁମ୍ଭେମାନେ ‘ଯୋଷେଫକୁ ଏହି କଥା କହିବ, ");
INSERT INTO ory_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ତୁମ୍ଭ ଭାଇମାନେ ତୁମ୍ଭର ମନ୍ଦ କରିଅଛନ୍ତି; ମାତ୍ର ତୁମ୍ଭେ ଅନୁଗ୍ରହ କରି ସେମାନଙ୍କର ସେହି ଅଧର୍ମ ଓ ପାପ ମାର୍ଜନା କରିବ;’ ଏଥିପାଇଁ ଆମ୍ଭେମାନେ ବିନୟ କରୁଅଛୁ, ତୁମ୍ଭ ପୈତୃକ ପରମେଶ୍ୱରଙ୍କ ଦାସଗଣର ଅଧର୍ମ ମାର୍ଜନା କର।” ସେମାନେ ଏହି କଥା କହିବା ବେଳେ ଯୋଷେଫ କାନ୍ଦିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ଏଥିଉତ୍ତାରେ ତାଙ୍କର ଭାଇମାନେ ତାଙ୍କ ଆଗକୁ ଯାଇ ପ୍ରଣାମ କରି କହିଲେ, “ଦେଖ, ଆମ୍ଭେମାନେ ତୁମ୍ଭର ଦାସ।” ");
INSERT INTO ory_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ତହିଁରେ ଯୋଷେଫ ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ କିଛି ଭୟ କର ନାହିଁ, ମୁଁ କʼଣ ପରମେଶ୍ୱରଙ୍କର ପ୍ରତିନିଧି? ");
INSERT INTO ory_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ତୁମ୍ଭେମାନେ ମୋʼ ବିରୁଦ୍ଧରେ ମନ୍ଦ କଳ୍ପନା କରିଥିଲ ପ୍ରମାଣ, ମାତ୍ର ପରମେଶ୍ୱର ତାହା ମଙ୍ଗଳର କଳ୍ପନା କଲେ; ଏବେ ଯେପରି ଦେଖୁଅଛ, ସେପରି ଅନେକ ଲୋକଙ୍କର ପ୍ରାଣରକ୍ଷା କରିବାକୁ ତାହାଙ୍କର ଅଭିପ୍ରାୟ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ଏଥିପାଇଁ ତୁମ୍ଭେମାନେ ଏବେ ଭୀତ ହୁଅ ନାହିଁ, ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ ଓ ତୁମ୍ଭମାନଙ୍କ ବାଳକଗଣକୁ ପ୍ରତିପାଳନ କରିବି।” ଏହି ପ୍ରକାରେ ଚିତ୍ତ ପ୍ରବୋଧକ କଥା କହି ସେ ସେମାନଙ୍କୁ ସାନ୍ତ୍ୱନା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଓ ତାଙ୍କର ପିତୃପରିବାର ମିସରରେ ବାସ କରି ରହିଲେ; ଯୋଷେଫ ଶହେ ଦଶ ବର୍ଷ ଜୀବିତ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ଯୋଷେଫ ଇଫ୍ରୟିମର ତୃତୀୟ ପୁରୁଷ ପର୍ଯ୍ୟନ୍ତ ସନ୍ତାନସନ୍ତତି ଦେଖିଲେ; ପୁଣି, ଯୋଷେଫ ମନଃଶିର ମାଖୀର ନାମକ ପୁତ୍ରର ଶିଶୁସନ୍ତାନମାନଙ୍କୁ “କୋଳ କଲେ।” ");
INSERT INTO ory_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ ଭାଇମାନଙ୍କୁ କହିଲେ, “ମୁଁ ମରୁଅଛି, ମାତ୍ର ପରମେଶ୍ୱର ଅବଶ୍ୟ ତୁମ୍ଭମାନଙ୍କର ତତ୍ତ୍ୱାବଧାନ କରିବେ, ପୁଣି, ଏହି ଦେଶରୁ ତୁମ୍ଭମାନଙ୍କୁ ବାହାର କରି ଯେଉଁ ଦେଶ ଦେବା ପାଇଁ ଅବ୍ରହାମ, ଇସ୍‌ହାକ ଓ ଯାକୁବଙ୍କ ନିକଟରେ ଶପଥ କରିଅଛନ୍ତି, ସେହି ଦେଶକୁ ତୁମ୍ଭମାନଙ୍କୁ ନେଇଯିବେ।” ");
INSERT INTO ory_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ଆହୁରି ଯୋଷେଫ ଇସ୍ରାଏଲଙ୍କର ସନ୍ତାନମାନଙ୍କୁ ଏହି ଶପଥ କରାଇ କହିଲେ, “ପରମେଶ୍ୱର ଅବଶ୍ୟ ତୁମ୍ଭମାନଙ୍କର ତତ୍ତ୍ୱାବଧାନ କରିବେ, ସେହି ସମୟରେ ତୁମ୍ଭେମାନେ ଏ ସ୍ଥାନରୁ ମୋହର ଅସ୍ଥି ନେଇଯିବ।” ");
INSERT INTO ory_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ଏହି ପ୍ରକାରେ ଯୋଷେଫ ଶହେ ଦଶ ବର୍ଷ ବୟସରେ ମଲେ; ତହିଁରେ ସେମାନେ ତାଙ୍କର ଶବକୁ ପୂତିଘ୍ନ ଦ୍ରବ୍ୟ ଯୁକ୍ତ କରି ମିସର ଦେଶରେ ଏକ ସିନ୍ଦୁକ ମଧ୍ୟରେ ରଖିଲେ।");
INSERT INTO ory_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ଇସ୍ରାଏଲଙ୍କର ଯେଉଁ ପୁତ୍ରଗଣ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ପରିଜନ ଘେନି ଯାକୁବଙ୍କ ସହିତ ମିସର ଦେଶକୁ ଆସିଲେ, ସେମାନଙ୍କ ନାମ; ");
INSERT INTO ory_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ରୁବେନ୍‍, ଶିମୀୟୋନ, ଲେବୀ ଓ ଯିହୁଦା; ");
INSERT INTO ory_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ଇଷାଖର, ସବୂଲୂନ ଓ ବିନ୍ୟାମୀନ୍; ");
INSERT INTO ory_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ଦାନ୍ ଓ ନପ୍ତାଲି; ଗାଦ୍‍ ଓ ଆଶେର। ");
INSERT INTO ory_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ସର୍ବସୁଦ୍ଧା ଯାକୁବଙ୍କଠାରୁ ଉତ୍ପନ୍ନ ବଂଶ ସତୁରି ପ୍ରାଣୀ ଥିଲେ; ମାତ୍ର ଯୋଷେଫ ପୂର୍ବେ ମିସରରେ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ, ତାଙ୍କର ଭ୍ରାତୃଗଣ ଓ ତତ୍କାଳୀନ ସମସ୍ତ ଲୋକ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ତଥାପି ଇସ୍ରାଏଲ ବଂଶ ବହୁପ୍ରଜ, ବର୍ଦ୍ଧିଷ୍ଣୁ ଓ ବହୁଗୋଷ୍ଠୀକ ହୋଇ ଅତିଶୟ ପ୍ରବଳ ହେଲେ, ପୁଣି, ସେମାନଙ୍କ ଦ୍ୱାରା ଦେଶ ପରିପୂର୍ଣ୍ଣ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ଏଥିଉତ୍ତାରେ ଯେ ଯୋଷେଫଙ୍କୁ ଜାଣି ନ ଥିଲେ, ଏପରି ଏକ ନୂତନ ରାଜା ମିସର ଦେଶରେ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ସେ ଆପଣା ଲୋକମାନଙ୍କୁ କହିଲେ, “ଦେଖ, ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ବଂଶ, ବଳରେ ଓ ସଂଖ୍ୟାରେ ଆମ୍ଭମାନଙ୍କଠାରୁ ଅଧିକ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ସେମାନେ ଯେପରି ବର୍ଦ୍ଧିତ ନ ହୁଅନ୍ତି, ପୁଣି, ଯୁଦ୍ଧ ଘଟିଲେ, ଆମ୍ଭମାନଙ୍କର ଶତ୍ରୁପକ୍ଷ ହୋଇ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗେ ଯୁଦ୍ଧ ନ କରନ୍ତି ଓ ଏ ଦେଶରୁ ପ୍ରସ୍ଥାନ ନ କରନ୍ତି, ଏଥିପାଇଁ ଆସ, ଆମ୍ଭେମାନେ ସେମାନଙ୍କ ସଙ୍ଗେ ସାବଧାନ ହୋଇ ବ୍ୟବହାର କରୁ।” ");
INSERT INTO ory_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ଏଥିଉତ୍ତାରେ ସେମାନେ ଭାର ବହନ ଦ୍ୱାରା ସେମାନଙ୍କୁ କ୍ଳେଶ ଦେବା ପାଇଁ ସେମାନଙ୍କ ଉପରେ କାର୍ଯ୍ୟଶାସକମାନଙ୍କୁ ନିଯୁକ୍ତ କଲେ, ପୁଣି, ସେମାନଙ୍କ ଦ୍ୱାରା ଫାରୋଙ୍କ ନିମନ୍ତେ ଭଣ୍ଡାରର ନଗର, ଅର୍ଥାତ୍‍, ପିଥୋମ୍‍ ଓ ରାମିଷେଷ୍‍ ନିର୍ମାଣ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ମାତ୍ର ସେମାନେ ସେମାନଙ୍କୁ ଯେତେ ଅଧିକ କ୍ଳେଶ ଦେଲେ, ସେମାନେ ସେତେ ଅଧିକ ବୃଦ୍ଧି ପାଇଲେ, ପୁଣି, ସେତେ ଅଧିକ ବ୍ୟାପିଗଲେ। ଏହେତୁ ଇସ୍ରାଏଲର ସନ୍ତାନମାନଙ୍କ ନିମନ୍ତେ ସେମାନେ ଅତିଶୟ ଉଦ୍‍ବିଗ୍ନ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ତହିଁରେ ମିସରୀୟ ଲୋକମାନେ ନିର୍ଦ୍ଦୟ ଭାବରେ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କୁ ଦାସ୍ୟକର୍ମ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ପୁଣି, କାଦୁଅ, ଇଟା ଓ ବିଲର ସବୁ କର୍ମାଦି କଠିନ ଦାସ୍ୟକର୍ମ ଦ୍ୱାରା ସେମାନଙ୍କ ପ୍ରାଣକୁ ବିରକ୍ତ କରିବାକୁ ଲାଗିଲେ। ସେମାନେ ଯେଉଁ ସମସ୍ତ ଦାସ୍ୟକର୍ମ କରାଇଲେ; ସେହି ସମସ୍ତ ନିର୍ଦ୍ଦୟ ଭାବରେ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ଏଥିଉତ୍ତାରେ ମିସରୀୟ ରାଜା, ଶିଫ୍ରା ଓ ପୂୟା ନାମ୍ନୀ ଦୁଇ ଏବ୍ରୀୟା ଧାତ୍ରୀଙ୍କୁ ଏହି କଥା କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“ଯେଉଁ ସମୟରେ ତୁମ୍ଭେମାନେ ଏବ୍ରୀୟା ସ୍ତ୍ରୀମାନଙ୍କର ଧାତ୍ରୀ କାର୍ଯ୍ୟ କରିବ ଓ ସେମାନଙ୍କୁ ଜନ୍ମାସନରେ ଦେଖିବ; ସେସମୟରେ ଯଦି ପୁତ୍ରସନ୍ତାନ ହେବ, ତେବେ ତାକୁ ବଧ କରିବ; ଆଉ ଯଦି କନ୍ୟା ହେବ, ତେବେ ତାକୁ ଜୀବିତ ରଖିବ।” ");
INSERT INTO ory_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ମାତ୍ର ସେହି ଧାତ୍ରୀମାନେ ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କରିବାରୁ ମିସରୀୟ ରାଜାଙ୍କର ଆଜ୍ଞା ଅନୁସାରେ ନ କରି ପୁତ୍ରସନ୍ତାନମାନଙ୍କୁ ଜୀବିତ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ତେଣୁ ମିସରର ରାଜା ଧାତ୍ରୀମାନଙ୍କୁ ଡକାଇ କହିଲେ, “ତୁମ୍ଭେମାନେ ଏପରି କାର୍ଯ୍ୟ କାହିଁକି କରୁଅଛ? ପୁତ୍ରସନ୍ତାନମାନଙ୍କୁ କାହିଁକି ଜୀବିତ ରଖୁଅଛ?” ");
INSERT INTO ory_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ତହିଁରେ ଧାତ୍ରୀମାନେ ଫାରୋଙ୍କୁ କହିଲେ, “ଏବ୍ରୀୟା ସ୍ତ୍ରୀଗଣ ମିସରୀୟା ସ୍ତ୍ରୀଗଣ ପରି ନୁହନ୍ତି; ସେମାନେ ବଳବତୀ, ସେମାନଙ୍କ ନିକଟକୁ ଧାତ୍ରୀ ଆସିବା ପୂର୍ବରୁ ସେମାନେ ପ୍ରସବ କରନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ପୁଣି, ପରମେଶ୍ୱର ସେହି ଧାତ୍ରୀମାନଙ୍କର ମଙ୍ଗଳ କଲେ, ତହିଁରେ ଲୋକମାନେ ଅତ୍ୟନ୍ତ ବୃଦ୍ଧି ପାଇ ଅତିଶୟ ବଳବାନ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ସେହି ଧାତ୍ରୀମାନେ ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କରିବାରୁ ସେ ସେମାନଙ୍କ ବଂଶ ବୃଦ୍ଧି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ଏଥିଉତ୍ତାରେ ଫାରୋ ଆପଣା ସମସ୍ତ ପ୍ରଜାଙ୍କୁ ଏହି ଆଜ୍ଞା ଦେଲେ, “ତୁମ୍ଭେମାନେ ନବଜାତ ପ୍ରତ୍ୟେକ ପୁତ୍ରସନ୍ତାନକୁ ନୀଳ ନଦୀରେ ନିକ୍ଷେପ କର, ମାତ୍ର ପ୍ରତ୍ୟେକ କନ୍ୟାକୁ ଜୀବିତ ରଖ।” ");
INSERT INTO ory_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ଏଥିଉତ୍ତାରେ ଲେବୀ ବଂଶଜାତ ଜଣେ ମନୁଷ୍ୟ ଯାଇ ଲେବୀ ବଂଶରୁ ଜାତ ଏକ କନ୍ୟାକୁ ବିବାହ କଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ତହୁଁ ସେ ସ୍ତ୍ରୀ ଗର୍ଭଧାରଣ କରି ଗୋଟିଏ ପୁତ୍ର ପ୍ରସବ କଲା; ପୁଣି, ବାଳକକୁ ଅତି ସୁନ୍ଦର ଦେଖି ସେ ତାକୁ ତିନି ମାସ ଯାଏ ଗୋପନରେ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ତହିଁ ଉତ୍ତାରେ ଆଉ ଗୋପନ କରି ନ ପାରି ସେ ଗୋଟିଏ ନଳନିର୍ମିତ ପେଡ଼ି ଘେନି ମାଟିଆ ତେଲ ଓ ଝୁଣା ଲେପନ କରି ତହିଁ ମଧ୍ୟରେ ସେହି ବାଳକକୁ ଥୋଇ ନୀଳ ନଦୀତୀରସ୍ଥ ନଳବନରେ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ପୁଣି, ତାହାର କି ଦଶା ହେବ, ତାହା ଦେଖିବା ନିମନ୍ତେ ତାହାର ଭଗିନୀ ଦୂରରେ ଠିଆ ହୋଇ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ଏଥିଉତ୍ତାରେ ଫାରୋଙ୍କ କନ୍ୟା ସ୍ନାନ ନିମନ୍ତେ ନଦୀକୁ ଆସନ୍ତେ, ତାହାର ସହଚରୀଗଣ ନଦୀ ତୀରରେ ଭ୍ରମଣ କରୁଥିଲେ। ଏଥିମଧ୍ୟରେ ସେ ନଳବନରେ ଗୋଟିଏ ପେଡ଼ି ଦେଖି ତାହା ଆଣିବାକୁ ଆପଣା ଦାସୀକୁ ପଠାଇଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ସେ ପେଡ଼ି ଫିଟାଇ ସେହି ବାଳକକୁ ଦେଖିଲା; ଆଉ ଦେଖ, ସେହି ବାଳକଟି କାନ୍ଦୁଅଛି; ତହିଁରେ ସେ ଦୟା ବହି କହିଲା, “ଏଇଟି ଜଣେ ଏବ୍ରୀୟ ବାଳକ।” ");
INSERT INTO ory_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ସେତେବେଳେ ତାହାର ଭଗିନୀ ଫାରୋଙ୍କର କନ୍ୟାକୁ କହିଲା, “ମୁଁ ଯାଇ ଆପଣଙ୍କ ନିମନ୍ତେ ଏହି ବାଳକକୁ ସ୍ତନ୍ୟପାନ କରାଇବା ପାଇଁ କି ଏବ୍ରୀୟା ସ୍ତ୍ରୀଗଣ ମଧ୍ୟରୁ ଜଣେ ଧାତ୍ରୀକୁ ଡାକି ଆଣିବି?” ");
INSERT INTO ory_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ତହିଁରେ ଫାରୋଙ୍କର କନ୍ୟା କହିଲା, “ଯାଅ,” ତହୁଁ ସେ ବାଳିକା ଯାଇ ସେହି ବାଳକର ମାତାକୁ ଡାକି ଆଣିଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ତେବେ ଫାରୋଙ୍କର କନ୍ୟା ତାହାଙ୍କୁ କହିଲା, “ତୁମ୍ଭେ ଏ ବାଳକକୁ ନେଇ ମୋʼ ନିମନ୍ତେ ସ୍ତନ୍ୟପାନ କରାଅ; ମୁଁ ତୁମ୍ଭକୁ ବେତନ ଦେବି,” ତହିଁରେ ସେହି ସ୍ତ୍ରୀ ବାଳକକୁ ନେଇ ସ୍ତନ୍ୟପାନ କରାଇଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ଏଥିଉତ୍ତାରେ ବାଳକ ବଢ଼ନ୍ତେ, ସେ ତାକୁ ନେଇ ଫାରୋଙ୍କର କନ୍ୟାକୁ ଦେଲା। ତହିଁରେ ବାଳକ ତାହାର ପୁତ୍ର ହେଲା। ତେଣୁ ସେ ତାହାର ନାମ ମୋଶା ଦେଲା; “କାରଣ ସେ କହିଲା, ମୁଁ ଜଳରୁ ଏହାକୁ ଆକର୍ଷଣ କଲି।” ");
INSERT INTO ory_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","କାଳକ୍ରମେ ମୋଶା ବଡ଼ ହେଲା ଉତ୍ତାରେ ଦିନକରେ ସେ ଆପଣା ଭ୍ରାତୃଗଣ ନିକଟକୁ ଯାଇ ସେମାନଙ୍କୁ ଭାର ବହିବାର ଦେଖିଲେ; ପୁଣି, ଜଣେ ମିସରୀୟ ତାହାର ଭ୍ରାତୃଗଣ ମଧ୍ୟରୁ ଜଣେ ଏବ୍ରୀଙ୍କୁ ପ୍ରହାର କରୁଥିବାର ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ଏହେତୁ ସେ ଏଣେତେଣେ ଅନାଇ କାହାକୁ ନ ଦେଖି ସେହି ମିସରୀୟକୁ ବଧ କରି ବାଲିରେ ପୋତି ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ଆଉ ଦ୍ୱିତୀୟ ଦିନ ସେ ବାହାରକୁ ଯାଇ ଦୁଇ ଜଣ ଏବ୍ରୀଙ୍କୁ ବିବାଦ କରୁଥିବାର ଦେଖି ଦୋଷୀ ଲୋକଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ଭାଇଙ୍କୁ କାହିଁକି ପ୍ରହାର କରୁଅଛ?” ");
INSERT INTO ory_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ତହିଁରେ ସେ କହିଲା, “କିଏ ତୁମ୍ଭକୁ ଆମ୍ଭମାନଙ୍କ ଉପରେ ରାଜା ଓ ବିଚାରକର୍ତ୍ତା କରି ନିଯୁକ୍ତ କରିଅଛି? ତୁମ୍ଭେ ଯେପରି ସେହି ମିସରୀୟ ଲୋକକୁ ବଧ କଲ, ସେହିପରି କି ମୋତେ ବଧ କରିବାକୁ ଚାହୁଁଅଛ?” ତହିଁରେ ମୋଶା ଭୟଭୀତ ହୋଇ କହିଲେ, “ଏ କଥା ଅବଶ୍ୟ ପ୍ରକାଶିତ ହୋଇଅଛି।” ");
INSERT INTO ory_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ଏଥିଉତ୍ତାରେ ଫାରୋ ଏ କଥା ଶୁଣି ମୋଶାଙ୍କୁ ବଧ କରିବା ପାଇଁ ଚେଷ୍ଟା କଲେ। ମାତ୍ର ମୋଶା ଫାରୋଙ୍କ ସମ୍ମୁଖରୁ ପଳାଇ ମିଦୀୟନ ଦେଶରେ ବାସ କରିବାକୁ ଯାଇ ଗୋଟିଏ କୂପ ନିକଟରେ ବସିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ମିଦୀୟନୀୟ ଯାଜକଙ୍କର ସାତୋଟି କନ୍ୟା ଥିଲେ; ସେମାନେ ସେହି ସ୍ଥାନକୁ ଆସି ପିତାଙ୍କ ମେଷପଲକୁ ଜଳ ପାନ କରାଇବା ପାଇଁ ଜଳ କାଢ଼ି କୁଣ୍ଡ ପରିପୂର୍ଣ୍ଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ଏଥିମଧ୍ୟରେ ମେଷପାଳକମାନେ ଆସି ସେମାନଙ୍କୁ ତଡ଼ି ଦେବାକୁ ଲାଗିଲେ, ମାତ୍ର ମୋଶା ଉଠି ସେମାନଙ୍କର ସାହାଯ୍ୟ କରି ସେମାନଙ୍କ ମେଷପଲକୁ ଜଳ ପାନ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ଏଥିଉତ୍ତାରେ ସେମାନେ ଆପଣା ପିତା ରୁୟେଲ ନିକଟକୁ ଯାଆନ୍ତେ, ସେ ସେମାନଙ୍କୁ ପଚାରିଲା, “ଆଜି ତୁମ୍ଭେମାନେ ଏତେ ଶୀଘ୍ର କିପରି ଆସିଲ?” ");
INSERT INTO ory_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ତହିଁରେ ସେମାନେ କହିଲେ, “ଜଣେ ମିସରୀୟ ଲୋକ ମେଷପାଳକମାନଙ୍କ ହସ୍ତରୁ ଆମ୍ଭମାନଙ୍କୁ ଉଦ୍ଧାର କଲା, ପୁଣି, ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଜଳ କାଢ଼ି ମେଷପଲକୁ ଜଳ ପାନ କରାଇଲା।” ");
INSERT INTO ory_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ତେବେ ସେ ଆପଣା କନ୍ୟାମାନଙ୍କୁ କହିଲା, “ସେ କେଉଁଠାରେ? ତୁମ୍ଭେମାନେ ତାକୁ କାହିଁକି ଛାଡ଼ି ଆସିଲ? ତାକୁ ଡାକ; ସେ ଆମ୍ଭମାନଙ୍କ ସହିତ ଭୋଜନ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ଏଥିଉତ୍ତାରେ ମୋଶା ସେହି ମନୁଷ୍ୟ ସହିତ ବାସ କରିବାକୁ ସମ୍ମତ ହେଲେ; ପୁଣି, ସେ ମୋଶାଙ୍କ ସହିତ ଆପଣା କନ୍ୟା ସିପ୍ପୋରାର ବିବାହ ଦେଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ଏଥିଉତ୍ତାରେ ସେହି ସ୍ତ୍ରୀ ପୁତ୍ର ପ୍ରସବ କରନ୍ତେ, ମୋଶା ତାହାର ନାମ ଗେର୍ଶୋମ ଦେଲେ; କାରଣ ସେ କହିଲେ, “ମୁଁ ବିଦେଶରେ ପ୍ରବାସୀ ହୋଇଅଛି।” ");
INSERT INTO ory_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ବହୁ କାଳ ଉତ୍ତାରେ ମିସରୀୟ ରାଜାଙ୍କର ମୃତ୍ୟୁୁ ହେଲା, ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଦାସ୍ୟକର୍ମ ସକାଶୁ ହାହାକାର ଓ କ୍ରନ୍ଦନ କଲେ ଓ ଦାସ୍ୟକର୍ମ ସକାଶୁ ସେମାନଙ୍କ ଆର୍ତ୍ତନାଦ ପରମେଶ୍ୱରଙ୍କ ଛାମୁରେ ଉପସ୍ଥିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ତହିଁରେ ପରମେଶ୍ୱର ସେମାନଙ୍କ ଆର୍ତ୍ତସ୍ୱର ଶୁଣିଲେ, ଆଉ ଅବ୍ରହାମ ଓ ଇସ୍‌ହାକ ଓ ଯାକୁବଙ୍କ ସହିତ କୃତ ଆପଣା ନିୟମ ସ୍ମରଣ କରି, ");
INSERT INTO ory_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପ୍ରତି ଦୃଷ୍ଟିପାତ କଲେ ଓ ସେମାନଙ୍କ ଅବସ୍ଥା ଜାଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ସେହି ସମୟରେ ମୋଶା ଆପଣା ଶ୍ୱଶୁର ଯିଥ୍ରୋ ନାମକ ମିଦୀୟନୀୟ ଯାଜକଙ୍କର ମେଷପଲ ଚରାଉଥିଲେ; ଦିନକରେ ସେ ପ୍ରାନ୍ତରର ପଶ୍ଚାଦ୍‍ ଭାଗରେ ମେଷପଲ ଘେନି ହୋରେବ ନାମକ ପରମେଶ୍ୱରଙ୍କ ପର୍ବତରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ଏଥିରେ ଗୋଟିଏ ବୁଦା ମଧ୍ୟରୁ ଅଗ୍ନିଶିଖାରେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ତାଙ୍କୁ ଦର୍ଶନ ଦେଲେ; ତହୁଁ ସେ ଅନାଇଲେ, ଆଉ ଦେଖ, ବୁଦା ଅଗ୍ନିରେ ପ୍ରଜ୍ୱଳିତ ହେଉଅଛି, ତଥାପି ବୁଦା ନଷ୍ଟ ହେଉ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ତେଣୁ ମୋଶା କହିଲେ, “ମୁଁ ଏକ ପାଖକୁ ଯାଇ ଏହି ମହାଶ୍ଚର୍ଯ୍ୟ ବିଷୟ ଦେଖିବି, ବୁଦାଟା କାହିଁକି ଦଗ୍ଧ ହେଉ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ମାତ୍ର ସଦାପ୍ରଭୁ ଯେତେବେଳେ ଦେଖିଲେ, ଯେ ସେ ଦେଖିବା ନିମନ୍ତେ ଏକ ପାଖକୁ ଯାଉଅଛନ୍ତି, ସେତେବେଳେ ପରମେଶ୍ୱର ବୁଦା ମଧ୍ୟରୁ ତାଙ୍କୁ ଡାକି କହିଲେ, “ହେ ମୋଶା, ହେ ମୋଶା।” ତହିଁରେ ସେ କହିଲେ, “ଏହି ଦେଖନ୍ତୁ, ମୁଁ ଉପସ୍ଥିତ ଅଛି।” ");
INSERT INTO ory_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ତହୁଁ ସେ କହିଲେ, “ତୁମ୍ଭେ ଏ ସ୍ଥାନର ନିକଟବର୍ତ୍ତୀ ହୁଅ ନାହିଁ, ତୁମ୍ଭ ପାଦରୁ ପାଦୁକା କାଢ଼; କାରଣ ତୁମ୍ଭେ ଯେଉଁ ସ୍ଥାନରେ ଛିଡ଼ା ହେଉଅଛ, ତାହା ପବିତ୍ର ଭୂମି।” ");
INSERT INTO ory_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ସେ ଆହୁରି କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭର ପୈତୃକ ପରମେଶ୍ୱର, ଅର୍ଥାତ୍‍, ଅବ୍ରହାମର ପରମେଶ୍ୱର ଓ ଇସ୍‌ହାକର ପରମେଶ୍ୱର ଓ ଯାକୁବର ପରମେଶ୍ୱର।” ତହିଁରେ ମୋଶା ଆପଣା ମୁଖ ଆଚ୍ଛାଦନ କଲେ, କାରଣ ସେ ପରମେଶ୍ୱରଙ୍କ ପ୍ରତି ଦୃଷ୍ଟି କରିବାକୁ ଭୀତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ କହିଲେ, “ଆମ୍ଭେ ମିସର ଦେଶସ୍ଥିତ ଆପଣା ଲୋକମାନଙ୍କର କ୍ଳେଶ ନିତାନ୍ତ ଦେଖିଅଛୁ ଓ କାର୍ଯ୍ୟଶାସକମାନଙ୍କ କାରଣରୁ ହେଉଥିବା ସେମାନଙ୍କ ରୋଦନ ଶୁଣିଅଛୁ; ଆମ୍ଭେ ସେମାନଙ୍କର ଯନ୍ତ୍ରଣା ଜାଣିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ଏହେତୁ ମିସରୀୟ ଲୋକମାନଙ୍କ ହସ୍ତରୁ ସେମାନଙ୍କୁ ଉଦ୍ଧାର କରିବାକୁ, ପୁଣି, ସେହି ଦେଶରୁ ଉତ୍ତମ ଓ ପ୍ରଶସ୍ତ ଏକ ଦେଶକୁ; ଅର୍ଥାତ୍‍, କିଣାନୀୟ, ହିତ୍ତୀୟ, ଇମୋରୀୟ, ପରିଷୀୟ, ହିବ୍ବୀୟ ଓ ଯିବୂଷୀୟମାନେ ଯେଉଁ ସ୍ଥାନରେ ଥାʼନ୍ତି, ସେହି ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଦେଶକୁ ସେମାନଙ୍କୁ ନେଇଯିବାକୁ ଓହ୍ଲାଇ ଆସିଲୁ। ");
INSERT INTO ory_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ଯେହେତୁ ଦେଖ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର କ୍ରନ୍ଦନ ଆମ୍ଭର କର୍ଣ୍ଣଗୋଚର ହୋଇଅଛି; ଆହୁରି ମିସରୀୟ ଲୋକମାନେ ସେମାନଙ୍କ ପ୍ରତି ଯେଉଁ ଅତ୍ୟାଚାର ବ୍ୟବହାର କରନ୍ତି, ତାହା ଆମ୍ଭେ ଦେଖିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ଏଣୁ ଏବେ ଆସ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଫାରୋ ନିକଟକୁ ପ୍ରେରଣ କରିବା, ତୁମ୍ଭେ ମିସରଠାରୁ ଆମ୍ଭର ଲୋକ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ବାହାର କରି ଆଣିବ।” ");
INSERT INTO ory_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ତହିଁରେ ମୋଶା ପରମେଶ୍ୱରଙ୍କୁ କହିଲେ, “ମୁଁ କିଏ ଯେ, ଫାରୋଙ୍କ ନିକଟକୁ ଯାଇ ମିସର ଦେଶରୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ବାହାର କରି ଆଣିବି?” ");
INSERT INTO ory_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ତହୁଁ ସେ କହିଲେ, “ଆମ୍ଭେ ଅବଶ୍ୟ ତୁମ୍ଭର ସହବର୍ତ୍ତୀ ହେବା; ପୁଣି, ଆମ୍ଭେ ଯେ ତୁମ୍ଭକୁ ପ୍ରେରଣ କଲୁ, ତହିଁର ଏକ ଚିହ୍ନ ଜାଣିବ, ତୁମ୍ଭେ ମିସରରୁ ଲୋକସମୂହ ବାହାର କରି ଆଣିଲା ଉତ୍ତାରେ ତୁମ୍ଭେମାନେ ଏହି ପର୍ବତରେ ପରମେଶ୍ୱରଙ୍କର ସେବା କରିବ।” ");
INSERT INTO ory_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ଏଥିଉତ୍ତାରେ ମୋଶା ପରମେଶ୍ୱରଙ୍କୁ କହିଲେ, “ଦେଖ, ମୁଁ ଯେତେବେଳେ ଇସ୍ରାଏଲର ସନ୍ତାନମାନଙ୍କ ନିକଟକୁ ଯାଇ ସେମାନଙ୍କୁ କହିବି, ‘କି ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବପୁରୁଷମାନଙ୍କ ପରମେଶ୍ୱର ମୋତେ ତୁମ୍ଭମାନଙ୍କ ନିକଟକୁ ପଠାଇଅଛନ୍ତି;’ ପୁଣି, ସେମାନେ ପଚାରିବେ, ‘ତାହାଙ୍କର ନାମ କଅଣ?’ ସେତେବେଳେ ମୁଁ କି ଉତ୍ତର ଦେବି?” ");
INSERT INTO ory_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ତହିଁରେ ପରମେଶ୍ୱର ମୋଶାଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ଯେ ଅଛୁ, ସେ ଅଛୁ,” ପୁଣି, ସେ କହିଲେ, “ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହିବ, ‘ସ୍ୱୟମ୍ଭୂ (ଆମ୍ଭେ ଅଛୁ) ତୁମ୍ଭମାନଙ୍କ ନିକଟକୁ ମୋତେ ପଠାଇଅଛନ୍ତି।’” ");
INSERT INTO ory_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ପରମେଶ୍ୱର ମୋଶାଙ୍କୁ ଆହୁରି କହିଲେ, “ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଏହି କଥା କହିବ, ‘ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବପୁରୁଷଗଣର ପରମେଶ୍ୱର, ଅର୍ଥାତ୍‍, ଅବ୍ରହାମର ପରମେଶ୍ୱର, ଇସ୍‌ହାକର ପରମେଶ୍ୱର ଓ ଯାକୁବର ପରମେଶ୍ୱର ଯେ ସଦାପ୍ରଭୁ (ସ୍ୱୟମ୍ଭୂ), ସେ ତୁମ୍ଭମାନଙ୍କ ନିକଟକୁ ମୋତେ ପଠାଇଅଛନ୍ତି; ଆମ୍ଭର ଏହି ନାମ ଅନନ୍ତକାଳସ୍ଥାୟୀ, ପୁଣି, ପୁରୁଷାନୁକ୍ରମେ ସ୍ମରଣୀୟ ଅଟେ।’ ");
INSERT INTO ory_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ତୁମ୍ଭେ ଯାଇ ଇସ୍ରାଏଲ ବଂଶର ପ୍ରାଚୀନଗଣକୁ ଏକତ୍ର କରି ଏହି କଥା କୁହ, ‘ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବପୁରୁଷଗଣର ପରମେଶ୍ୱର, ଅର୍ଥାତ୍‍, ଅବ୍ରହାମ, ଇସ୍‌ହାକ ଓ ଯାକୁବର ପରମେଶ୍ୱର ସଦାପ୍ରଭୁ ମୋତେ ଦର୍ଶନ ଦେଇ କହିଅଛନ୍ତି, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ଓ ମିସରରେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଯାହା ଯାହା କରାଯାଉଅଛି, ସେସମସ୍ତ ବିଷୟର ଧ୍ୟାନ ଦେଇଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ମିସରର କ୍ଳେଶରୁ ଉଦ୍ଧାର କରି କିଣାନୀୟମାନଙ୍କ, ହିତ୍ତୀୟମାନଙ୍କ, ଇମୋରୀୟମାନଙ୍କ, ପରିଷୀୟମାନଙ୍କ, ହିବ୍ବୀୟମାନଙ୍କ ଓ ଯିବୂଷୀୟମାନଙ୍କର ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଦେଶକୁ ନେଇଯିବୁ ବୋଲି କହିଅଛୁ।’ ");
INSERT INTO ory_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ଏଥିରେ ସେମାନେ ତୁମ୍ଭ ରବରେ ଅବଧାନ କରିବେ; ତହୁଁ ତୁମ୍ଭେ ଓ ଇସ୍ରାଏଲ ବଂଶର ପ୍ରାଚୀନବର୍ଗ ମିସରର ରାଜା ନିକଟକୁ ଯାଇ ଏହି କଥା କହିବ, ‘ଏବ୍ରୀୟ ଲୋକମାନଙ୍କ ପରମେଶ୍ୱର ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ସହିତ ସାକ୍ଷାତ କରିଅଛନ୍ତି; ଏହେତୁ ବିନୟ କରୁଅଛୁ, ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରିବା ନିମିତ୍ତ ଏବେ ଆମ୍ଭମାନଙ୍କୁ ତିନି ଦିନର ପଥ ପ୍ରାନ୍ତରକୁ ଯିବା ପାଇଁ ଅନୁମତି ଦେଉନ୍ତୁ।’ ");
INSERT INTO ory_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ମାତ୍ର ଆମ୍ଭେ ଜାଣୁ, ମିସରର ରାଜା ତୁମ୍ଭମାନଙ୍କୁ ଯିବା ପାଇଁ ଅନୁମତି ଦେବ ନାହିଁ, ପରାକ୍ରାନ୍ତ ହସ୍ତ ପ୍ରକାଶିତ ହେଲେ ସୁଦ୍ଧା ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ତହିଁରେ ଆମ୍ଭେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କରି ଦେଶ ମଧ୍ୟରେ ଯେସକଳ ଆଶ୍ଚର୍ଯ୍ୟକର୍ମ କରିବା; ତଦ୍ଦ୍ୱାରା ମିସରକୁ ଆଘାତ କଲା ଉତ୍ତାରେ ସେ ତୁମ୍ଭମାନଙ୍କୁ ଯିବାକୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ଆଉ ଆମ୍ଭେ ମିସରୀୟ ଲୋକମାନଙ୍କ ସାକ୍ଷାତରେ ଏହି ଲୋକମାନଙ୍କୁ ଅନୁଗ୍ରହପାତ୍ର କରିବା, ତହିଁରେ ତୁମ୍ଭେମାନେ ଯାତ୍ରା ସମୟରେ ଶୂନ୍ୟ ହସ୍ତରେ ଯିବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ମାତ୍ର ପ୍ରତ୍ୟେକ ସ୍ତ୍ରୀ ଆପଣା ପ୍ରତିବାସିନୀ ଓ ଆପଣା ଗୃହପ୍ରବାସିନୀ ସ୍ତ୍ରୀ ନିକଟରୁ ରୌପ୍ୟ-ଅଳଙ୍କାର ଓ ସ୍ୱର୍ଣ୍ଣ-ଅଳଙ୍କାର ଓ ବସ୍ତ୍ର ମାଗି ନେଇଯିବେ; ପୁଣି, ତାହା ତୁମ୍ଭେମାନେ ଆପଣା ପୁତ୍ରକନ୍ୟାଙ୍କୁ ପିନ୍ଧାଇବ। ଏହିରୂପେ ତୁମ୍ଭେମାନେ ମିସରୀୟ ଲୋକମାନଙ୍କ ଦ୍ରବ୍ୟ ହରଣ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ଏଥିରେ ମୋଶା ଉତ୍ତର କଲେ, “ଦେଖନ୍ତୁ, ସେମାନେ ମୋତେ ବିଶ୍ୱାସ କରିବେ ନାହିଁ ଓ ମୋʼ ରବରେ ମନୋଯୋଗ କରିବେ ନାହିଁ; ମାତ୍ର ସେମାନେ କହିବେ, ‘ସଦାପ୍ରଭୁ ତୁମ୍ଭକୁ ଦର୍ଶନ ଦେଇ ନାହାନ୍ତି?’” ");
INSERT INTO ory_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ତେବେ ସଦାପ୍ରଭୁ ତାହାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭ ହସ୍ତରେ କʼଣ ଅଛି?” ସେ କହିଲେ, “ଯଷ୍ଟି।” ");
INSERT INTO ory_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ତହୁଁ ସଦାପ୍ରଭୁ କହିଲେ, “ତାକୁ ଭୂମିରେ ପକାଅ।” ତେଣୁ ସେ ତାକୁ ଭୂମିରେ ପକାନ୍ତେ, ତାହା ସର୍ପ ହେଲା; ତହିଁରେ ମୋଶା ତାହା ଆଗରୁ ପଳାଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ସେତେବେଳେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ସେମାନଙ୍କ ପୂର୍ବପୁରୁଷଗଣର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର, ଅର୍ଥାତ୍‍, ଅବ୍ରହାମର ପରମେଶ୍ୱର, ଇସ୍‌ହାକର ପରମେଶ୍ୱର ଓ ଯାକୁବର ପରମେଶ୍ୱର ଯେ ତୁମ୍ଭକୁ ଦର୍ଶନ ଦେଇଅଛନ୍ତି,” ଏହା ଯେପରି ସେମାନେ ବିଶ୍ୱାସ କରିବେ, ");
INSERT INTO ory_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“ଏଥିପାଇଁ ତୁମ୍ଭେ ଆପଣା ହସ୍ତ ବଢ଼ାଇ ତାହାର ଲାଞ୍ଜ ଧର,” ତହିଁରେ ସେ ହସ୍ତ ବଢ଼ାଇ ତାକୁ ଧରନ୍ତେ, ତାଙ୍କ ହସ୍ତରେ ସେ ଯଷ୍ଟି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ ଆହୁରି କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ହସ୍ତ ବକ୍ଷସ୍ଥଳରେ ଦିଅ।” ତହିଁରେ ସେ ଆପଣା ହସ୍ତ ବକ୍ଷସ୍ଥଳରେ ଦେଇ ପୁନର୍ବାର ହସ୍ତ ବାହାର କଲେ, ଦେଖ, ତାଙ୍କର ହସ୍ତ ହିମବର୍ଣ୍ଣ ତୁଲ୍ୟ କୁଷ୍ଠଯୁକ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ଏଥିରେ ସେ କହିଲେ, “ତୁମ୍ଭେ ପୁନର୍ବାର ଆପଣା ହସ୍ତ ବକ୍ଷସ୍ଥଳରେ ଦିଅ;” ସେମାନେ ଯଦି ତୁମ୍ଭକୁ ବିଶ୍ୱାସ ନ କରିବେ ");
INSERT INTO ory_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ଓ ତୁମ୍ଭର ସେହି ପ୍ରଥମ ଚିହ୍ନରେ ମନୋଯୋଗ ନ କରିବେ, ତେବେ ଦ୍ୱିତୀୟ ଚିହ୍ନରେ ବିଶ୍ୱାସ କରିବେ। ତହିଁରେ ସେ ପୁନର୍ବାର ଆପଣା ହସ୍ତ ବକ୍ଷସ୍ଥଳରେ ଦେଇ ବାହାର କଲେ, ଦେଖ, ତାହା ପ୍ରକୃତ ମାଂସ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ଏହି ଦୁଇ ଚିହ୍ନରେ ଯଦି ସେମାନେ ବିଶ୍ୱାସ ନ କରିବେ ଓ ତୁମ୍ଭ ରବରେ ମନୋଯୋଗ ନ କରିବେ, ତେବେ ତୁମ୍ଭେ ନୀଳ ନଦୀରୁ ଜଳ କିଛି ନେଇ ଶୁଷ୍କ ଭୂମିରେ ଢାଳ; ତହିଁରେ ତୁମ୍ଭେ ନଦୀରୁ ଯେଉଁ ଜଳ ଆଣିବ, ତାହା ଶୁଷ୍କ ଭୂମିରେ ରକ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ଏଥିଉତ୍ତାରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, “ହେ ପ୍ରଭୋ, ଏ ସମୟ ପୂର୍ବରେ, ଅବା ଆପଣ ନିଜ ଦାସ ସହିତ ଆଳାପ କଲା ଉତ୍ତାରେ ହେଁ ମୁଁ ବାକ୍ୟପତି ନୁହେଁ। ମୁଁ ବାକ୍ୟରେ ଧୀର ଓ ଜଡ଼ଜିହ୍ୱ ଅଟେ।” ");
INSERT INTO ory_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ତହିଁରେ ସଦାପ୍ରଭୁ ତାହାଙ୍କୁ କହିଲେ, “ମନୁଷ୍ୟର ମୁଖ କିଏ ନିର୍ମାଣ କରିଅଛନ୍ତି? ପୁଣି, ମନୁଷ୍ୟକୁ ମୂକ ବା ବଧିର ଅବା ଦୃଷ୍ଟିବିଶିଷ୍ଟ କିଅବା ଦୃଷ୍ଟିହୀନ କିଏ କରନ୍ତି? ଆମ୍ଭେ ସଦାପ୍ରଭୁ କି ତାହା ନ କରୁ? ");
INSERT INTO ory_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ଏଣୁ ଏବେ ଯାଅ, ଆମ୍ଭେ ତୁମ୍ଭ ମୁଖର ସହବର୍ତ୍ତୀ ହୋଇ ବକ୍ତବ୍ୟ କଥା ତୁମ୍ଭକୁ ଶିଖାଇବା।” ");
INSERT INTO ory_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ତହିଁରେ ସେ କହିଲେ, “ହେ ପ୍ରଭୋ, ମୁଁ ବିନୟ କରୁଅଛି, ଯାହା ଦ୍ୱାରା ପଠାଇବାର ହୁଏ, ତାହା ଦ୍ୱାରା ପଠାନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ତହିଁରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା; ତେଣୁ ସେ କହିଲେ, “ଲେବୀୟ ହାରୋଣ କି ତୁମ୍ଭର ଭାଇ ନୁହେଁ? ଆମ୍ଭେ ଜାଣୁ, ସେ ସୁବକ୍ତା। ଆଉ ଦେଖ, ସେ ତୁମ୍ଭ ସଙ୍ଗରେ ସାକ୍ଷାତ କରିବାକୁ ଆସୁଅଛି; ପୁଣି, ତୁମ୍ଭକୁ ଦେଖି ହୃଷ୍ଟଚିତ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ତୁମ୍ଭେ ତାହାକୁ କହିବ ଓ ତାହାର ମୁଖରେ ବାକ୍ୟ ଦେବ; ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭ ମୁଖର ଓ ତାହା ମୁଖର ସହବର୍ତ୍ତୀ ହୋଇ ତୁମ୍ଭମାନଙ୍କୁ କର୍ତ୍ତବ୍ୟ କର୍ମର ଶିକ୍ଷା ଦେବା। ");
INSERT INTO ory_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ସେ ଲୋକମାନଙ୍କ ନିକଟରେ ତୁମ୍ଭର ପ୍ରତିନିଧି-ବକ୍ତା ହେବ; ସେ ତୁମ୍ଭର ମୁଖ ସ୍ୱରୂପ ହେବ ଓ ତୁମ୍ଭେ ତାହାର ପରମେଶ୍ୱର ତୁଲ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ଆଉ ତୁମ୍ଭେ ଆପଣା ହସ୍ତରେ ଏହି ଯଷ୍ଟି ଘେନ, ଯେଣୁ ଏହା ଦ୍ୱାରା ତୁମ୍ଭେ ଏହି ସମସ୍ତ ଚିହ୍ନ ଦେଖାଇବ।” ");
INSERT INTO ory_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ଏଥିଉତ୍ତାରେ ମୋଶା ଆପଣା ଶ୍ୱଶୁର ଯିଥ୍ରୋ ନିକଟକୁ ବାହୁଡ଼ି ଯାଇ କହିଲେ, “ମୁଁ ବିନୟ କରୁଅଛି, ମିସରସ୍ଥିତ ମୋହର ଭ୍ରାତୃଗଣ ନିକଟକୁ ଏବେ ଫେରିଯିବା ପାଇଁ ଓ ସେମାନେ ଆଜିଯାଏ ବଞ୍ଚିଅଛନ୍ତି କି ନାହିଁ, ତାହା ଦେଖିବା ପାଇଁ ମୋତେ ଯିବାକୁ ଦିଅ।” ତହିଁରେ ଯିଥ୍ରୋ ମୋଶାଙ୍କୁ କହିଲେ, “କୁଶଳରେ ଯାଅ।” ");
INSERT INTO ory_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ଆଉ ସଦାପ୍ରଭୁ ମିଦୀୟନରେ ମୋଶାଙ୍କୁ କହିଥିଲେ, “ତୁମ୍ଭେ ମିସରକୁ ଫେରିଯାଅ; ଯେହେତୁ ଯେଉଁ ଲୋକମାନେ ତୁମ୍ଭ ପ୍ରାଣ ଅନ୍ୱେଷଣ କରୁଥିଲେ, ସେମାନେ ସମସ୍ତେ ମରିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ତହୁଁ ମୋଶା ଆପଣା ଭାର୍ଯ୍ୟା ଓ ପୁତ୍ରଗଣକୁ ଗଧ ଉପରେ ଚଢ଼ାଇ ମିସର ଦେଶକୁ ଫେରିଗଲେ; ପୁଣି, ସେ ଆପଣା ହସ୍ତରେ ପରମେଶ୍ୱରଙ୍କର ସେହି ଯଷ୍ଟି ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ସାବଧାନ, ତୁମ୍ଭେ ମିସରକୁ ଫେରିଗଲେ, ଆମ୍ଭେ ତୁମ୍ଭ ହସ୍ତରେ ଯେସବୁ ଆଶ୍ଚର୍ଯ୍ୟକର୍ମ କରିବାକୁ ଦେଇଅଛୁ, ତାହା ଫାରୋ ସାକ୍ଷାତରେ କରିବ; ମାତ୍ର ଆମ୍ଭେ ତାହାର ମନ କଠିନ କରିବା; ତହିଁରେ ସେ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ପୁଣି, ତୁମ୍ଭେ ଫାରୋକୁ କହିବ, ସଦାପ୍ରଭୁ କହନ୍ତି, “ଇସ୍ରାଏଲ ଆମ୍ଭର ପୁତ୍ର; ଆମ୍ଭର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର; ");
INSERT INTO ory_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ଆମ୍ଭେ ତୁମ୍ଭକୁ କହିଅଛୁ, ‘ଆମ୍ଭର ସେବା କରିବା ପାଇଁ ତୁମ୍ଭେ ଆମ୍ଭ ପୁତ୍ରକୁ ଛାଡ଼ିଦିଅ; ମାତ୍ର ତୁମ୍ଭେ ତାହାକୁ ଛାଡ଼ିବାକୁ ନାସ୍ତି କରିଅଛ; ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭ ପୁତ୍ରକୁ, ତୁମ୍ଭ ଜ୍ୟେଷ୍ଠ ପୁତ୍ରକୁ ବଧ କରିବା।’” ");
INSERT INTO ory_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ଏଥିଉତ୍ତାରେ ପଥ ମଧ୍ୟରେ ଉତ୍ତରଣୀୟ ଗୃହରେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ ପାଇ ବଧ କରିବାକୁ ଚେଷ୍ଟା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ସେତେବେଳେ ସିପ୍ପୋରା ଏକ ତୀକ୍ଷ୍ଣ ଅସ୍ତ୍ର ଘେନି ଆପଣା ପୁତ୍ରକୁ ସୁନ୍ନତ କରି ତାହା ତାଙ୍କ ଚରଣ ତଳେ ପକାଇ କହିଲା, “ତୁମ୍ଭେ ନିତାନ୍ତ ମୋହର ରକ୍ତପ୍ରିୟ ବର।” ");
INSERT INTO ory_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ଏହିରୂପେ ପରମେଶ୍ୱର ତାଙ୍କୁ ଛାଡ଼ିଦେଲେ। ତହିଁରେ ସେ ସ୍ତ୍ରୀ କହିଲା, “ସୁନ୍ନତପ୍ରଯୁକ୍ତ ତୁମ୍ଭେ ରକ୍ତପ୍ରିୟ ବର ଅଟ।” ");
INSERT INTO ory_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ମୋଶା ସହିତ ସାକ୍ଷାତ କରିବା ନିମନ୍ତେ ପ୍ରାନ୍ତରକୁ ଯାଅ।” ତହୁଁ ସେ ଯାଇ ପରମେଶ୍ୱରଙ୍କ ପର୍ବତରେ ତାଙ୍କ ସହିତ ସାକ୍ଷାତ କରି ତାଙ୍କୁ ଚୁମ୍ବନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ସେତେବେଳେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ପ୍ରେରିତ ସମସ୍ତ ବାକ୍ୟ ଓ ତାହାଙ୍କ ଆଜ୍ଞାର୍ପିତ ସମସ୍ତ ଚିହ୍ନ ହାରୋଣଙ୍କୁ ଜଣାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ଏଥିଉତ୍ତାରେ ମୋଶା ଓ ହାରୋଣ ଯାଇ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କର ପ୍ରାଚୀନବର୍ଗକୁ ଏକତ୍ର କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ପୁଣି, ହାରୋଣ ସେମାନଙ୍କୁ ମୋଶାଙ୍କ ପ୍ରତି କଥିତ ସଦାପ୍ରଭୁଙ୍କ ସମସ୍ତ ବାକ୍ୟ କହିଲେ, ପୁଣି, ଲୋକମାନଙ୍କ ଦୃଷ୍ଟିରେ ସେହି ସମସ୍ତ ଚିହ୍ନ ପ୍ରକାଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ତହିଁରେ ଲୋକମାନେ ବିଶ୍ୱାସ କଲେ, ପୁଣି, ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ତତ୍ତ୍ୱାବଧାନ କରି ସେମାନଙ୍କ ଦୁଃଖ ଦେଖିଅଛନ୍ତି, ଏହା ଶୁଣି ସେମାନେ ତାହାଙ୍କୁ ମସ୍ତକ ନତ କରି ଉପାସନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ଏଥିଉତ୍ତାରେ ମୋଶା ଓ ହାରୋଣ ପ୍ରବେଶ କରି ଫାରୋଙ୍କୁ କହିଲେ, “ଇସ୍ରାଏଲର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର କହନ୍ତି, ‘ପ୍ରାନ୍ତରରେ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସବ କରିବାକୁ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦିଅ।’” ");
INSERT INTO ory_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ତହିଁରେ ଫାରୋ କହିଲେ, “ସଦାପ୍ରଭୁ କିଏ, ଯେ ଆମ୍ଭେ ତାହାର କଥା ମାନି ଇସ୍ରାଏଲକୁ ଯିବାକୁ ଦେବୁ? ଆମ୍ଭେ ସଦାପ୍ରଭୁଙ୍କୁ ଚିହ୍ନି ନାହୁଁ ଓ ଇସ୍ରାଏଲକୁ ଯିବାକୁ ଦେବୁ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ସେମାନେ କହିଲେ, “ଏବ୍ରୀୟମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କୁ ଦର୍ଶନ ଦେଇଅଛନ୍ତି; ଏଣୁ ଆମ୍ଭେମାନେ ବିନୟ କରୁଅଛୁ, ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରିବା ନିମନ୍ତେ ଆମ୍ଭମାନଙ୍କୁ ପ୍ରାନ୍ତରରେ ତିନି ଦିନର ପଥ ଯିବାକୁ ଦେଉନ୍ତୁ; ନୋହିଲେ ସେ ଆମ୍ଭମାନଙ୍କୁ ମହାମାରୀରେ କିମ୍ବା ଖଡ୍ଗ ଦ୍ୱାରା ଆକ୍ରମଣ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ତହୁଁ ମିସରର ରାଜା ସେମାନଙ୍କୁ କହିଲେ, “ହେ ମୋଶା ଓ ହାରୋଣ, ତୁମ୍ଭେମାନେ ଲୋକମାନଙ୍କୁ କାହିଁକି କାର୍ଯ୍ୟରୁ ନିବୃତ୍ତ କରୁଅଛ? ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ଭାର ବହନ କର୍ମରେ ଯାଅ।” ");
INSERT INTO ory_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ଫାରୋ ଆହୁରି କହିଲେ, “ଦେଖ, ଏବେ ଏ ଦେଶରେ ଏହି ଲୋକ ଅନେକ, ପୁଣି, ତୁମ୍ଭେମାନେ ସେମାନଙ୍କୁ ଭାର ବହିବାରୁ ନିବୃତ୍ତ କରୁଅଛ।” ");
INSERT INTO ory_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ଆଉ ଫାରୋ ସେହି ଦିନ ଲୋକମାନଙ୍କ କାର୍ଯ୍ୟଶାସକ ଓ ଅଧ୍ୟକ୍ଷମାନଙ୍କୁ ଏହି ଆଜ୍ଞା ଦେଲେ, ");
INSERT INTO ory_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ତୁମ୍ଭେମାନେ ଇଟା ନିର୍ମାଣ ନିମିତ୍ତ ପୂର୍ବ ପରି ଏହି ଲୋକମାନଙ୍କୁ ଆଉ ପାଳ ଦିଅ ନାହିଁ; ସେମାନେ ଯାଇ ଆପଣା ନିମନ୍ତେ ପାଳ ସଂଗ୍ରହ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ପୁଣି, ପୂର୍ବରେ ସେମାନଙ୍କ ଉପରେ ଯେତେ ଇଟା ନିର୍ମାଣର ଭାର ଥିଲା, ଏବେ ସେହି ଭାର ଦିଅ; ତହିଁରୁ କିଛିମାତ୍ର ଊଣା କର ନାହିଁ; ଯେହେତୁ ସେମାନେ ଅଳସୁଆ ଅଟନ୍ତି; ‘ଏଣୁ ଆମ୍ଭମାନଙ୍କୁ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରିବାକୁ ଯିବାକୁ ଦିଅ ବୋଲି ଡାକ ପକାଉଅଛନ୍ତି;’ ");
INSERT INTO ory_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ଏହେତୁ ଏମାନେ କାର୍ଯ୍ୟ ଭାରରେ ଭାରାକ୍ରାନ୍ତ ହୋଇ ତହିଁରେ ବ୍ୟସ୍ତ ଥାʼନ୍ତୁ; ମିଥ୍ୟା କଥାରେ ଅବଧାନ ନ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ତହିଁ ଉତ୍ତାରେ ଲୋକମାନଙ୍କ କାର୍ଯ୍ୟଶାସକ ଓ ଅଧ୍ୟକ୍ଷଗଣ ବାହାରେ ଯାଇ ସେମାନଙ୍କୁ କହିଲେ, “ଫାରୋ ଏହି କଥା କହନ୍ତି, ‘ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଆଉ ପାଳ ଦେବୁ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ଯାଅ, ଯେଉଁଠାରେ ପାଳ ପାଇ ପାରିବ ସେହିଠାରୁ ଆପଣା ଆପଣା ନିମନ୍ତେ ତାହା ସଂଗ୍ରହ କର; ମାତ୍ର ତୁମ୍ଭମାନଙ୍କର କାର୍ଯ୍ୟ କିଛି ଊଣା ହେବ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ତହିଁରେ ଲୋକମାନେ ପାଳ ବଦଳେ କୁଟା ସଂଗ୍ରହ କରିବାକୁ ସମସ୍ତ ମିସର ଦେଶରେ ଛିନ୍ନଭିନ୍ନ ହୋଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ତଥାପି କାର୍ଯ୍ୟଶାସକମାନେ ଚଞ୍ଚଳ କରାଇ କହିଲେ, “ପାଳ ପାଇବା ବେଳେ ଯେପରି ତୁମ୍ଭେମାନେ କର୍ମ କରୁଥିଲ, ସେପରି ଏବେ ମଧ୍ୟ ନିରୂପିତ ଦୈନିକ କର୍ମ ପ୍ରତିଦିନ ସମ୍ପୂର୍ଣ୍ଣ କର।” ");
INSERT INTO ory_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ଫାରୋଙ୍କର କାର୍ଯ୍ୟଶାସକମାନେ ଇସ୍ରାଏଲ ବଂଶୀୟ ଯେଉଁ କାର୍ଯ୍ୟାଧ୍ୟକ୍ଷମାନଙ୍କୁ ରଖିଥିଲେ; ସେମାନଙ୍କୁ ପ୍ରହାର କରି କହିଲେ, “ତୁମ୍ଭେମାନେ ପୂର୍ବ ପରି ଇଟା ବନାଇବାର ନିରୂପିତ କର୍ମ କାହିଁକି ଆଜିକାଲି ସମ୍ପୂର୍ଣ୍ଣ କରୁ ନାହଁ?” ");
INSERT INTO ory_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ତହିଁରେ ଇସ୍ରାଏଲ ବଂଶୀୟ କାର୍ଯ୍ୟାଧ୍ୟକ୍ଷମାନେ ଆସି ଫାରୋଙ୍କ ନିକଟରେ କ୍ରନ୍ଦନ କରି କହିଲେ, “ଆପଣ କାହିଁକି ଆପଣା ଦାସମାନଙ୍କ ସହିତ ଏପରି ବ୍ୟବହାର କରୁଅଛନ୍ତି? ");
INSERT INTO ory_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ଆପଣଙ୍କ ଦାସମାନଙ୍କୁ ପାଳ ଦିଆଯାଏ ନାହିଁ, ତଥାପି ସେମାନେ କହନ୍ତି, ‘ଇଟା ବନାଅ;’ ଆଉ ଦେଖନ୍ତୁ, ଆପଣଙ୍କ ଦାସମାନେ ପ୍ରହାରିତ ହୁଅନ୍ତି, ମାତ୍ର ଦୋଷ ଆପଣଙ୍କ ନିଜ ଲୋକଙ୍କର।” ");
INSERT INTO ory_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ତହୁଁ ସେ କହିଲେ, “ତୁମ୍ଭେମାନେ ବହୁତ ଅଳସୁଆ, ଏଥିପାଇଁ କହୁଅଛ, ‘ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରିବାକୁ ଆମ୍ଭମାନଙ୍କୁ ଯିବାକୁ ଦିଅ।’ ");
INSERT INTO ory_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ଏବେ ଯାଅ, କର୍ମ କର, ତୁମ୍ଭମାନଙ୍କୁ ପାଳ ଦିଆଯିବ ନାହିଁ, ତଥାପି ତୁମ୍ଭମାନଙ୍କୁ ଇଟାର ସମ୍ପୂର୍ଣ୍ଣ ସଂଖ୍ୟା ଦେବାକୁ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“ତହିଁରେ ତୁମ୍ଭମାନଙ୍କ ଦୈନିକ ନିରୂପିତ ଇଟାରୁ କିଛି ଊଣା ହେବ ନାହିଁ;” ଏହି କଥାରେ ଇସ୍ରାଏଲ ବଂଶୀୟ କାର୍ଯ୍ୟାଧ୍ୟକ୍ଷମାନେ ଦେଖିଲେ ଯେ, ସେମାନଙ୍କ ଦଶା ଅମଙ୍ଗଳସୂଚକ। ");
INSERT INTO ory_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ଏଥିଉତ୍ତାରେ ସେମାନେ ଫାରୋଙ୍କ ନିକଟରୁ ଫେରିବା ସମୟରେ ସେମାନେ ମୋଶା ଓ ହାରୋଣଙ୍କୁ ସାକ୍ଷାତ କଲେ, ଯେପରି ସେମାନେ ସେମାନଙ୍କର ଅପେକ୍ଷାରେ ଥିଲେ; ");
INSERT INTO ory_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ଏଣୁ ସେମାନଙ୍କୁ କହିଲେ, “ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଦୃଷ୍ଟି କରି ବିଚାର କରନ୍ତୁ; ଯେହେତୁ ତୁମ୍ଭେମାନେ ଫାରୋ ଓ ତାଙ୍କର ଦାସମାନଙ୍କ ସାକ୍ଷାତରେ ଆମ୍ଭମାନଙ୍କୁ ଘୃଣାଯୋଗ୍ୟ କରି ଆମ୍ଭମାନଙ୍କ ହତ୍ୟା ନିମିତ୍ତ ସେମାନଙ୍କ ହସ୍ତରେ ଖଡ୍ଗ ଦେଲ।” ");
INSERT INTO ory_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ଏଥିଉତ୍ତାରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ନିକଟକୁ ଫେରିଯାଇ କହିଲେ, “ହେ ପ୍ରଭୋ, ତୁମ୍ଭେ କାହିଁକି ଏହି ଲୋକମାନଙ୍କର ଅମଙ୍ଗଳ କରିଅଛ? ତୁମ୍ଭେ କାହିଁକି ମୋତେ ପଠାଇଲ? ");
INSERT INTO ory_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","କାରଣ ଯେଉଁ ଦିନାବଧି ମୁଁ ତୁମ୍ଭ ନାମରେ କଥା କହିବା ପାଇଁ ଫାରୋଙ୍କ ନିକଟକୁ ଆସିଲି, ସେହି ଦିନାବଧି ସେ ଏହି ଲୋକମାନଙ୍କର ଅମଙ୍ଗଳ କରିଅଛନ୍ତି, ପୁଣି, ତୁମ୍ଭେ ଆପଣା ଲୋକମାନଙ୍କର କିଛିମାତ୍ର ଉଦ୍ଧାର କରି ନାହଁ।” ");
INSERT INTO ory_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ସେତେବେଳେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ଫାରୋ ପ୍ରତି ଯାହା କରିବା, ତାହା ତୁମ୍ଭେ ଏବେ ଦେଖିବ; କାରଣ ବାହୁ ବଳ ପ୍ରକାଶିତ ହେଲେ, ସେ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେବ ଓ ବାହୁ ବଳ ପ୍ରକାଶିତ ହେଲେ, ଆପଣା ଦେଶରୁ ସେମାନଙ୍କୁ ତଡ଼ି ଦେବ।” ");
INSERT INTO ory_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ପରମେଶ୍ୱର ମୋଶାଙ୍କ ସହିତ ଆଳାପ କରି ଆହୁରି କହିଲେ, “ଆମ୍ଭେ ଯିହୋବାଃ (ସଦାପ୍ରଭୁ); ");
INSERT INTO ory_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ଆମ୍ଭେ ଅବ୍ରହାମ, ଇସ୍‌ହାକ ଓ ଯାକୁବଙ୍କୁ ସର୍ବଶକ୍ତିମାନ ପରମେଶ୍ୱର ବୋଲି ଦର୍ଶନ ଦେଇଥିଲୁ, ମାତ୍ର ଆମ୍ଭେ ଆପଣା ଯିହୋବାଃ ନାମରେ ସେମାନଙ୍କୁ ପରିଚୟ ଦେଇ ନ ଥିଲୁ। ");
INSERT INTO ory_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ପୁଣି, କିଣାନ ଦେଶ, ଅର୍ଥାତ୍‍, ଯହିଁରେ ସେମାନେ ପ୍ରବାସ କଲେ, ସେହି ପ୍ରବାସ-ଦେଶ ମଧ୍ୟ ସେମାନଙ୍କୁ ଦେବା ବୋଲି ସେମାନଙ୍କ ସହିତ ନିୟମ ସ୍ଥିର କରିଥିଲୁ। ");
INSERT INTO ory_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ଏବେ ମିସରୀୟମାନେ ଯେଉଁମାନଙ୍କୁ ଦାସତ୍ୱରେ ରଖିଅଛନ୍ତି, ସେହି ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଆର୍ତ୍ତନାଦ ଶୁଣି ଆମ୍ଭେ ଆପଣାର ସେହି ନିୟମ ସ୍ମରଣ କରିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ଏନିମନ୍ତେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ‘ଆମ୍ଭେ ସଦାପ୍ରଭୁ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ମିସରୀୟମାନଙ୍କ ଭାରବହନରୁ ନିସ୍ତାର କରିବା ଓ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ସେମାନଙ୍କ ଦାସତ୍ୱରୁ ମୁକ୍ତ କରିବା, ପୁଣି, ଆମ୍ଭେ ବିସ୍ତୀର୍ଣ୍ଣ ବାହୁ ଓ ମହା ମହା ଦଣ୍ଡ ଦ୍ୱାରା ତୁମ୍ଭମାନଙ୍କୁ ଉଦ୍ଧାର କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଆପଣା ଲୋକ ରୂପେ ଗ୍ରହଣ କରିବା ଓ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ହେବା; ତହିଁରେ ମିସରୀୟମାନଙ୍କ ଭାରବହନରୁ ତୁମ୍ଭମାନଙ୍କର ନିସ୍ତାରକାରୀ ଆମ୍ଭେ ଯେ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ସଦାପ୍ରଭୁ ଅଟୁ, ତାହା ତୁମ୍ଭେମାନେ ଜାଣିବ। ");
INSERT INTO ory_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ଆମ୍ଭେ ଅବ୍ରହାମ, ଇସ୍‌ହାକ ଓ ଯାକୁବଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବା ନିମନ୍ତେ ଆପଣା ହସ୍ତ ଉଠାଇଅଛୁ, ସେହି ଦେଶକୁ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଘେନିଯିବା; ପୁଣି, ଆମ୍ଭେ ଅଧିକାରାର୍ଥେ ତାହା ତୁମ୍ଭମାନଙ୍କୁ ଦେବା; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ।’” ");
INSERT INTO ory_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ଏଥିଉତ୍ତାରେ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ତଦନୁସାରେ କହିଲେ, ମାତ୍ର ସେମାନେ ମନୋଦୁଃଖ ଓ କଠିନ ଦାସତ୍ୱ ସକାଶୁ ମୋଶାଙ୍କର ବାକ୍ୟରେ ମନୋଯୋଗ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ତୁମ୍ଭେ ଯାଇ ମିସରର ରାଜା ଫାରୋକୁ କୁହ, ତୁମ୍ଭ ଦେଶରୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଯିବାକୁ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ କହିଲେ, “ଦେଖନ୍ତୁ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମୋʼ କଥାରେ ମନୋଯୋଗ କରି ନାହାନ୍ତି; ତେବେ ଉତ୍ତମ ବକ୍ତା ଯେ ମୁଁ ନୁହେଁ, ମୋʼ କଥା ଫାରୋ କିପରି ଶୁଣିବେ?” ");
INSERT INTO ory_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ଏହିରୂପେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କ ସହିତ ଆଳାପ କଲେ, ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିବା ନିମନ୍ତେ ମିସର ରାଜା ଫାରୋଙ୍କ ନିକଟରେ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ନିକଟରେ ବକ୍ତବ୍ୟ କଥା ସେମାନଙ୍କୁ ଆଜ୍ଞା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ଏହି ସମସ୍ତ ଲୋକ ଆପଣା ଆପଣା ପିତୃବଂଶ ମଧ୍ୟରେ ପ୍ରଧାନ ଥିଲେ। ଇସ୍ରାଏଲଙ୍କର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ରୁବେନ୍‍ର ସନ୍ତାନ ହନୋକ, ପଲ୍ଲୁ, ହିଷ୍ରୋଣ ଓ କର୍ମି; ଏମାନେ ରୁବେନ୍‍ର ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ପୁଣି, ଶିମୀୟୋନର ପୁତ୍ର ଯିମୂୟେଲ, ଯାମୀନ୍‍, ଓହଦ୍‍, ଯାଖୀନ୍‍, ସୋହର ଓ କିଣାନୀୟା ସ୍ତ୍ରୀର ପୁତ୍ର ଶୌଲ; ଏମାନେ ଶିମୀୟୋନର ବଂଶ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ବଂଶାବଳୀ ଅନୁସାରେ ଲେବୀର ପୁତ୍ରମାନଙ୍କ ନାମ ଗେର୍ଶୋନ‍, କହାତ ଓ ମରାରି; ଲେବୀର ବୟସ ଶହେ ସଇଁତିରିଶ ବର୍ଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ପୁଣି, ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଗେର୍ଶୋନର ସନ୍ତାନ ଲିବ୍‍ନି ଓ ଶିମୀୟି। ");
INSERT INTO ory_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ପୁଣି, କହାତର ସନ୍ତାନ ଅମ୍ରାମ୍‍, ଯିଷ୍‍ହର, ହିବ୍ରୋଣ ଓ ଉଷୀୟେଲ; ସେହି କହାତର ଶହେ ତେତିଶ ବର୍ଷ ବୟସ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ମରାରିର ସନ୍ତାନ ମହଲି ଓ ମୂଶି; ଏମାନେ ବଂଶାବଳୀ ଅନୁସାରେ ଲେବୀର ବଂଶ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ପୁଣି, ଅମ୍ରାମ୍‍ ଆପଣା ପିଉସୀ ଯୋକେବଦକୁ ବିବାହ କରନ୍ତେ, ସେ ତାହାର ଔରସରେ ହାରୋଣଙ୍କୁ ଓ ମୋଶାଙ୍କୁ ପ୍ରସବ କଲା; ସେହି ଅମ୍ରାମ୍‍ର ଆୟୁ ଶହେ ସଇଁତିରିଶ ବର୍ଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ଯିଷ୍‍ହରର ସନ୍ତାନ କୋରହ, ନେଫଗ୍‍ ଓ ସିଖ୍ରି। ");
INSERT INTO ory_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ପୁଣି, ଉଷୀୟେଲର ସନ୍ତାନ ମୀଶାୟେଲ ଓ ଇଲୀଷାଫନ୍‍ ଓ ସିଥ୍ରି। ");
INSERT INTO ory_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ପୁଣି, ହାରୋଣ ଅମ୍ମୀନାଦବର କନ୍ୟା ନହଶୋନର ଭଗିନୀ ଇଲୀଶେବାକୁ ବିବାହ କଲେ; ତହିଁରେ ସେ ତାଙ୍କର ଔରସରେ ନାଦବ୍‍, ଅବୀହୂ, ଇଲୀୟାସର ଓ ଈଥାମରକୁ ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ପୁଣି, କୋରହର ସନ୍ତାନ ଅସୀର ଓ ଇଲ୍‍କାନା ଓ ଅବୀୟାସଫ; ଏମାନେ କୋରହର ବଂଶ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ପୁଣି, ହାରୋଣଙ୍କର ପୁତ୍ର ଇଲୀୟାସର ଫୂଟୀୟେଲର ଏକ କନ୍ୟାକୁ ବିବାହ କରନ୍ତେ, ସେ ତାଙ୍କର ଔରସରେ ପୀନହସ୍‍କୁ ପ୍ରସବ କଲା, ଏମାନେ ଲେବୀୟମାନଙ୍କ ବଂଶଭେଦାନୁସାରେ ସେମାନଙ୍କ ପିତୃବଂଶ ମଧ୍ୟରେ ପ୍ରଧାନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ଏହି ଯେ ହାରୋଣ ଓ ମୋଶା, ଏମାନଙ୍କୁ ସଦାପ୍ରଭୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ସୈନ୍ୟଶ୍ରେଣୀବଦ୍ଧ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣ।” ");
INSERT INTO ory_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ଏମାନେ ମିସରରୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ବାହାର କରି ଆଣିବା ପାଇଁ ମିସରର ରାଜା ଫାରୋଙ୍କ ସହିତ କଥାବାର୍ତ୍ତା କରିଥିଲେ। ଏମାନେ ସେହି ମୋଶା ଓ ହାରୋଣ। ");
INSERT INTO ory_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ଯେଉଁ ଦିନ ସଦାପ୍ରଭୁ ମିସର ଦେଶରେ ମୋଶାଙ୍କ ସହିତ ଆଳାପ କଲେ, ");
INSERT INTO ory_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ସେହି ଦିନ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଏହି କଥା କହିଲେ, “ଆମ୍ଭେ ସଦାପ୍ରଭୁ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯାହା ଯାହା କହୁ; ତାହାସବୁ ମିସରୀୟ ରାଜା ଫାରୋକୁ କୁହ।” ");
INSERT INTO ory_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ କହିଥିଲେ, “ମନ୍ଦ ବକ୍ତା ଯେ ମୁଁ, ମୋʼ କଥା ଫାରୋ କିପ୍ରକାରେ ଶୁଣିବେ?” ");
INSERT INTO ory_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଫାରୋ ନିକଟରେ ପରମେଶ୍ୱର ତୁଲ୍ୟ କରି ନିଯୁକ୍ତ କଲୁ ଓ ତୁମ୍ଭ ଭ୍ରାତା ହାରୋଣ ତୁମ୍ଭର ଭବିଷ୍ୟଦ୍‍ବକ୍ତା ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯାହା ଯାହା ଆଜ୍ଞା କରିବା, ତାହାସବୁ ତୁମ୍ଭେ କହିବ; ପୁଣି, ତୁମ୍ଭ ଭ୍ରାତା ହାରୋଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଆପଣା ଦେଶରୁ ଛାଡ଼ି ଯିବାକୁ ଫାରୋଙ୍କୁ କହିବ। ");
INSERT INTO ory_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ଆଉ, ଆମ୍ଭେ ଫାରୋର ହୃଦୟ କଠିନ କରିବା, ପୁଣି, ମିସର ଦେଶରେ ଆମ୍ଭର ଚିହ୍ନ ଓ ଆଶ୍ଚର୍ଯ୍ୟକର୍ମ ବହୁସଂଖ୍ୟକ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ତଥାପି ଫାରୋ ତୁମ୍ଭମାନଙ୍କ କଥାରେ ମନୋଯୋଗ କରିବ ନାହିଁ; ଏହେତୁ ଆମ୍ଭେ ମିସର ଦେଶ ଉପରେ ଆପଣା ହସ୍ତ ଥୋଇ ମହାଦଣ୍ଡ ଦ୍ୱାରା ମିସରଠାରୁ ଆପଣା ସୈନ୍ୟସାମନ୍ତ, ଆମ୍ଭର ଲୋକ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ବାହାର କରି ଆଣିବା। ");
INSERT INTO ory_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ପୁଣି, ଆମ୍ଭେ ମିସର ବିରୁଦ୍ଧରେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କରି ସେମାନଙ୍କ ମଧ୍ୟରୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ବାହାର କରି ଆଣିବା ବେଳେ ଆମ୍ଭେ ଯେ ସଦାପ୍ରଭୁ, ତାହା ସେମାନେ ଜାଣିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ଏଥିଉତ୍ତାରେ ମୋଶା ଓ ହାରୋଣ ସେହିରୂପ କଲେ; ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେମାନେ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ଫାରୋଙ୍କ ସଙ୍ଗରେ କଥୋପକଥନ କରିବା ବେଳେ ମୋଶାଙ୍କୁ ଅଶୀ ଓ ହାରୋଣଙ୍କୁ ତେୟାଅଶୀ ବର୍ଷ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ଆଉ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ପାଇଁ ‘କୌଣସି ଚିହ୍ନ ଦେଖାଅ’ ବୋଲି ଯଦି ଫାରୋ ତୁମ୍ଭମାନଙ୍କୁ କହିବ, ତେବେ ତୁମ୍ଭେ ହାରୋଣକୁ କହିବ, ‘ତୁମ୍ଭର ଯଷ୍ଟି ନେଇ ଫାରୋ ଅଗ୍ରତେ ତଳେ ପକାଅ; ତହିଁରେ ସେହି ଯଷ୍ଟି ସର୍ପ ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ତହୁଁ ମୋଶା ଓ ହାରୋଣ ଫାରୋଙ୍କ ନିକଟକୁ ଯାଇ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞା ପ୍ରମାଣେ କର୍ମ କଲେ; ପୁଣି, ହାରୋଣ, ଫାରୋ ଓ ତାଙ୍କର ଦାସମାନଙ୍କ ସମ୍ମୁଖରେ ଆପଣା ଯଷ୍ଟି ତଳେ ପକାନ୍ତେ, ତାହା ସର୍ପ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ତେବେ ଫାରୋ ଆପଣା ପଣ୍ଡିତ ଓ ଗୁଣିଆମାନଙ୍କୁ ଡାକିଲେ; ତହିଁରେ ମିସରୀୟ ମନ୍ତ୍ରଜ୍ଞମାନେ ମଧ୍ୟ ଆପଣାମାନଙ୍କ ମାୟାରେ ସେହିପରି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ଅର୍ଥାତ୍‍, ସେମାନେ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ଯଷ୍ଟି ପକାନ୍ତେ, ସେଗୁଡ଼ିକ ସର୍ପ ହେଲା; ମାତ୍ର ହାରୋଣଙ୍କ ଯଷ୍ଟି ସେମାନଙ୍କର ସମସ୍ତ ଯଷ୍ଟିକୁ ଗ୍ରାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ତହିଁରେ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ ହେଲା ଓ ସେ ସେମାନଙ୍କ କଥାରେ ମନୋଯୋଗ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଫାରୋର ହୃଦୟ କଠିନ ହୋଇଅଛି, ସେ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେବା ପାଇଁ ମନା କରୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ଏହେତୁ ତୁମ୍ଭେ ପ୍ରଭାତରେ ଫାରୋ ନିକଟକୁ ଯାଅ; ଦେଖ, ସେ ଜଳ ଆଡ଼େ ଗଲେ, ତୁମ୍ଭେ ତାହା ସହିତ ସାକ୍ଷାତ କରିବାକୁ ନୀଳ ନଦୀ ତୀରରେ ଠିଆ ହୁଅ; ଯେଉଁ ଯଷ୍ଟି ସର୍ପ ହୋଇଥିଲା, ତାହା ମଧ୍ୟ ହସ୍ତରେ ନିଅ। ");
INSERT INTO ory_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ପୁଣି, ଫାରୋକୁ କୁହ, ‘ଏବ୍ରୀୟମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ମୋତେ ତୁମ୍ଭ ନିକଟକୁ ପଠାଇ କହିଲେ, ତୁମ୍ଭେ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ପ୍ରାନ୍ତରରେ ସେବା କରିବାକୁ ଛାଡ଼ିଦିଅ; ମାତ୍ର ଦେଖ, ତୁମ୍ଭେ ଏପର୍ଯ୍ୟନ୍ତ ଏହି କଥାରେ ମନୋଯୋଗ କରି ନାହଁ। ");
INSERT INTO ory_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ସଦାପ୍ରଭୁ ଏହି ପ୍ରକାରେ କହୁଅଛନ୍ତି, ଆମ୍ଭେ ଯେ ସଦାପ୍ରଭୁ, ତାହା ତୁମ୍ଭେ ଏତଦ୍ଦ୍ୱାରା ଜ୍ଞାତ ହେବ; ଦେଖ, ଆମ୍ଭେ ଆପଣା ହସ୍ତସ୍ଥିତ ଏହି ଯଷ୍ଟି ଦ୍ୱାରା ନଦୀର ଜଳ ଉପରେ ପ୍ରହାର କରିବା, ତହିଁରେ ତାହା ରକ୍ତ ହୋଇଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ପୁଣି, ନଦୀରେ ଥିବା ମତ୍ସ୍ୟସକଳ ମରିଯିବେ ଓ ନଦୀ ଦୁର୍ଗନ୍ଧ ହେବ; ତହିଁରେ ମିସରୀୟ ଲୋକମାନେ ନଦୀର ଜଳ ପାନ କରିବାକୁ ଘୃଣା କରିବେ।’” ");
INSERT INTO ory_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ହାରୋଣକୁ ଏହି କଥା କୁହ, ‘ତୁମ୍ଭେ ଆପଣା ଯଷ୍ଟି ଘେନି ମିସର ଦେଶୀୟ ଜଳ ଉପରେ, ଅର୍ଥାତ୍‍, ତହିଁର ନଦୀ, ନାଳ, ପୁଷ୍କରିଣୀ ଓ ଜଳାଶୟ, ଏସମସ୍ତ ଉପରେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କର, ତହିଁରେ ସମସ୍ତ ଜଳ ରକ୍ତ ହେବ; ପୁଣି, ମିସର ଦେଶର ସର୍ବତ୍ର କାଷ୍ଠ ପାତ୍ର ଓ ପ୍ରସ୍ତର ପାତ୍ରରେ ହେଁ ରକ୍ତ ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ତହୁଁ ମୋଶା ଓ ହାରୋଣ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେହି ପ୍ରକାର କଲେ; ସେ ଯଷ୍ଟି ଘେନି ଫାରୋ ଓ ତାଙ୍କର ଦାସମାନଙ୍କ ସମ୍ମୁଖରେ ନଦୀର ଜଳ ଉପରେ ପ୍ରହାର କଲେ; ତହିଁରେ ସମୁଦାୟ ନଦୀର ଜଳ ରକ୍ତ ହୋଇଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ପୁଣି, ନଦୀର ସମସ୍ତ ମତ୍ସ୍ୟ ମଲେ ଓ ନଦୀ ଦୁର୍ଗନ୍ଧ ହେଲା, ତହିଁରେ ମିସରୀୟମାନେ ନଦୀର ଜଳ ପାନ କରି ପାରିଲେ ନାହିଁ; ମିସର ଦେଶର ସର୍ବତ୍ର ରକ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ସେତେବେଳେ ମିସରୀୟ ମନ୍ତ୍ରଜ୍ଞମାନେ ହେଁ ଆପଣାମାନଙ୍କ ମାୟାରେ ସେହିପରି କଲେ; ତହିଁରେ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ ହେଲା ଓ ସେ ସେମାନଙ୍କ କଥାରେ ମନୋଯୋଗ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ଏଥିଉତ୍ତାରେ ଫାରୋ ମୁଖ ଫେରାଇ ଆପଣା ଗୃହକୁ ଗଲେ, ଏଥିରେ ଆପଣା ମନ ଦେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ପୁଣି, ସମସ୍ତ ମିସରୀୟ ଲୋକେ ନଦୀର ଜଳ ପାନ କରି ନ ପାରିବାରୁ ପିଇବା ଜଳ ନିମନ୍ତେ ନଦୀର ଚାରିଆଡ଼େ ଖୋଳିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ସଦାପ୍ରଭୁ ନଦୀକୁ ଆଘାତ କଲା ଉତ୍ତାରେ ସାତ ଦିନ ସମ୍ପୂର୍ଣ୍ଣ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଫାରୋ ନିକଟକୁ ଯାଇ ତାହାଙ୍କୁ କୁହ, ‘ସଦାପ୍ରଭୁ ଏହି କଥା କହନ୍ତି, ଆମ୍ଭର ସେବା କରିବା ନିମନ୍ତେ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦିଅ। ");
INSERT INTO ory_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","କିନ୍ତୁ ଯଦି ତୁମ୍ଭେ ସେମାନଙ୍କୁ ଯିବାକୁ ଦେବା ପାଇଁ ମନା କରିବ, ତେବେ ଦେଖ, ଆମ୍ଭେ ବେଙ୍ଗ ଦ୍ୱାରା ତୁମ୍ଭର ସମସ୍ତ ଦେଶକୁ ଦଣ୍ଡ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ନୀଳ ନଦୀ ବେଙ୍ଗରେ ପରିପୂର୍ଣ୍ଣ ହେବ, ତହିଁରେ ସେସମସ୍ତ ବେଙ୍ଗ ଉଠି ତୁମ୍ଭ ଗୃହରେ, ଶୟନାଗାରରେ, ଶଯ୍ୟାରେ, ତୁମ୍ଭ ଦାସମାନଙ୍କ ଗୃହରେ, ତୁମ୍ଭ ଲୋକମାନଙ୍କ ଉପରେ, ତୁମ୍ଭ ଚୁଲ୍ଲୀରେ ଓ ତୁମ୍ଭ ଅଟା ଦଳିବା ପାତ୍ରରେ ପ୍ରବେଶ କରିବେ; ");
INSERT INTO ory_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ପୁଣି, ତୁମ୍ଭର ଓ ତୁମ୍ଭ ଲୋକମାନଙ୍କର ଓ ଦାସମାନଙ୍କ ଉପରକୁ ଉଠିବେ।’” ");
INSERT INTO ory_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ହାରୋଣକୁ କୁହ, ‘ତୁମ୍ଭେ ନଦୀ, ନାଳ ଓ ପୁଷ୍କରିଣୀ ଉପରେ ଆପଣାର ସଯଷ୍ଟି ହସ୍ତ ବିସ୍ତାର କରି ମିସର ଦେଶ ଉପରେ ବେଙ୍ଗ ଅଣାଅ।’” ");
INSERT INTO ory_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ତହିଁରେ ହାରୋଣ ମିସରର ସମସ୍ତ ଜଳ ଉପରେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କରନ୍ତେ, ବେଙ୍ଗସମୂହ ଉଠି ମିସର ଦେଶରେ ବ୍ୟାପିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ସେତେବେଳେ ମନ୍ତ୍ରଜ୍ଞମାନେ ଆପଣାମାନଙ୍କ ମାୟାରେ ସେପ୍ରକାର କରି ମିସର ଦେଶ ଉପରେ ବେଙ୍ଗ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ତହୁଁ ଫାରୋ ମୋଶା ଓ ହାରୋଣଙ୍କୁ ଡକାଇ କହିଲେ, “ଆମ୍ଭଠାରୁ ଓ ଆମ୍ଭ ଲୋକଙ୍କଠାରୁ ଏହିସବୁ ବେଙ୍ଗ ଦୂର କରିବା ପାଇଁ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କର; ତହିଁରେ ଆମ୍ଭେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରିବା ନିମନ୍ତେ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ତେବେ ମୋଶା ଫାରୋଙ୍କୁ କହିଲେ, “ମୋʼ ଉପରେ ଦର୍ପ କର; ବେଙ୍ଗ ସବୁ ଯେପରି ଆପଣଙ୍କଠାରୁ ଓ ଆପଣଙ୍କ ଗୃହରୁ ଉଚ୍ଛିନ୍ନ ହୋଇ କେବଳ ନଦୀରେ ରହନ୍ତି, ଆପଣଙ୍କ ଓ ଆପଣଙ୍କ ଦାସମାନଙ୍କ ଓ ଲୋକସମସ୍ତଙ୍କ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ କେବେ ଏହି ପ୍ରାର୍ଥନା କରିବି?” ");
INSERT INTO ory_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ସେ କହିଲେ, “ଆସନ୍ତାକାଲି କର।” ସେତେବେଳେ ମୋଶା କହିଲେ, “ଆମ୍ଭମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ତୁଲ୍ୟ କେହି ନାହାନ୍ତି, ଏହା ଯେପରି ଆପଣ ଜ୍ଞାତ ହୁଅନ୍ତି, ଏଥିପାଇଁ ଆପଣଙ୍କ ବାକ୍ୟାନୁସାରେ ହେଉ। ");
INSERT INTO ory_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ବେଙ୍ଗମାନେ ଆପଣଙ୍କଠାରୁ ଓ ଆପଣଙ୍କ ଗୃହ, ଦାସ ଓ ସମସ୍ତ ଲୋକଙ୍କଠାରୁ ଦୂର ହୋଇ କେବଳ ନଦୀରେ ରହିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ଏଥିଉତ୍ତାରେ ମୋଶା ଓ ହାରୋଣ ଫାରୋଙ୍କ ନିକଟରୁ ବାହାରକୁ ଗଲେ; ପୁଣି, ମୋଶା ଫାରୋଙ୍କ ବିରୁଦ୍ଧରେ ଆନୀତ ବେଙ୍ଗ ବିଷୟରେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ବାକ୍ୟାନୁସାରେ କରନ୍ତେ, ଗୃହରେ, ପ୍ରାଙ୍ଗଣରେ ଓ କ୍ଷେତ୍ରରେ ସମସ୍ତ ବେଙ୍ଗ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ତହୁଁ ଲୋକମାନେ ସେସବୁକୁ ଏକତ୍ର କରି ଗଦା କରନ୍ତେ, ଦେଶ ଦୁର୍ଗନ୍ଧମୟ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ମାତ୍ର ଫାରୋ ବିପଦର ନିବୃତ୍ତି ଦେଖି ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟ ପ୍ରମାଣେ ଆପଣା ହୃଦୟ କଠିନ କଲେ ଓ ସେମାନଙ୍କ ବାକ୍ୟରେ ମନୋଯୋଗ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ହାରୋଣକୁ କୁହ, ସମସ୍ତ ମିସର ଦେଶରେ ଯେପରି ଉକୁଣିଆ ପୋକ ହୁଅଇ, ଏଥିପାଇଁ ‘ତୁମ୍ଭେ ଆପଣା ଯଷ୍ଟି ଉଠାଇ ଭୂମିର ଧୂଳିରେ ପ୍ରହାର କର।’” ");
INSERT INTO ory_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ତହିଁରେ ସେମାନେ ସେପ୍ରକାର କଲେ; ହାରୋଣ ସଯଷ୍ଟି ହସ୍ତ ବିସ୍ତାର କରି ଭୂମିର ଧୂଳିରେ ପ୍ରହାର କରନ୍ତେ, ମନୁଷ୍ୟ ଓ ପଶୁମାନଙ୍କଠାରେ ଉକୁଣିଆ ପୋକ ହେଲା; ପୁଣି, ମିସର ଦେଶର ଭୂମିସ୍ଥ ସମସ୍ତ ଧୂଳି ଉକୁଣିଆ ପୋକ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ସେତେବେଳେ ମନ୍ତ୍ରଜ୍ଞମାନେ ଆପଣା ଆପଣା ମାୟାରେ ସେପ୍ରକାର ଉକୁଣିଆ ପୋକ ଉତ୍ପନ୍ନ କରିବାକୁ ଚେଷ୍ଟା କଲେ, ମାତ୍ର ପାରିଲେ ନାହିଁ; ତହିଁରେ ମନୁଷ୍ୟ ଓ ପଶୁମାନଙ୍କ ଉପରେ ଉକୁଣିଆ ପୋକ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ତେବେ ମନ୍ତ୍ରଜ୍ଞମାନେ ଫାରୋଙ୍କୁ କହିଲେ, “ଏ ତ ପରମେଶ୍ୱରଙ୍କ ଅଙ୍ଗୁଳିକୃତ କର୍ମ,” ତଥାପି ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ ହେଲା, ପୁଣି, ସେ ସେମାନଙ୍କ ବାକ୍ୟରେ ମନୋଯୋଗ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ପ୍ରଭାତରେ ଉଠି ଫାରୋ ସମ୍ମୁଖରେ ଠିଆ ହୁଅ; ଦେଖ, ସେ ଜଳ ନିକଟକୁ ଆସିଲେ, ତୁମ୍ଭେ ତାହାଙ୍କୁ ଏହି କଥା କହିବ, ‘ସଦାପ୍ରଭୁ କହନ୍ତି, ଆମ୍ଭର ସେବା କରିବାକୁ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦିଅ। ");
INSERT INTO ory_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ପୁଣି, ଯଦି ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ନ ଦେବ, ତେବେ ଆମ୍ଭେ ତୁମ୍ଭ ଉପରେ ଓ ତୁମ୍ଭ ଦାସମାନଙ୍କ ଉପରେ ଓ ତୁମ୍ଭ ଲୋକମାନଙ୍କ ଉପରେ ଓ ତୁମ୍ଭ ଗୃହ ଭିତରେ ଏପରି ଦଂଶକାଦିର ଝିଙ୍କ ପଠାଇବା ଯେ, ତଦ୍ଦ୍ୱାରା ମିସରୀୟମାନଙ୍କ ଗୃହ ଓ ବାସଭୂମି ପରିପୂର୍ଣ୍ଣ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ପୁଣି, ପୃଥିବୀ ମଧ୍ୟରେ କେବଳ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ, ଏହା ତୁମ୍ଭକୁ ଜଣାଇବା ନିମନ୍ତେ ସେହି ଦିନ ଆମ୍ଭ ଲୋକମାନଙ୍କ ନିବାସ ସ୍ଥାନ ଗୋଶନ ପ୍ରଦେଶ ଭିନ୍ନ କରିବା; ସେଠାରେ ଦଂଶକାଦିର ଝିଙ୍କ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ଆମ୍ଭେ ଆପଣା ଲୋକମାନଙ୍କ ଓ ତୁମ୍ଭ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରଭେଦ କରିବା; ଆସନ୍ତାକାଲି ଏହି ଚିହ୍ନ ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ସେହି ପ୍ରକାର କଲେ; ତହିଁରେ ଫାରୋଙ୍କର ଓ ତାଙ୍କ ଦାସମାନଙ୍କ ଗୃହରେ ଦଂଶକାଦିର ବୃହତ ଝିଙ୍କ ଉପସ୍ଥିତ ହେଲା; ପୁଣି, ସମୁଦାୟ ମିସର ଦେଶ ଦଂଶକାଦି ସକାଶୁ ନଷ୍ଟ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ସେତେବେଳେ ଫାରୋ ମୋଶା ଓ ହାରୋଣଙ୍କୁ ଡକାଇ କହିଲେ, “ତୁମ୍ଭେମାନେ ଯାଇ ଦେଶ ମଧ୍ୟରେ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କର।” ");
INSERT INTO ory_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ତହିଁରେ ମୋଶା କହିଲେ, “ତାହା କରିବା ଉପଯୁକ୍ତ ନୁହେଁ; କାରଣ ତାହା କଲେ, ଆମ୍ଭମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମିସରୀୟମାନଙ୍କର ଘୃଣାଜନକ ବଳିଦାନ କରିବାକୁ ହେବ; ଦେଖ, ମିସରୀୟମାନଙ୍କ ଚକ୍ଷୁଗୋଚରରେ ସେମାନଙ୍କର ଘୃଣାଜନକ ବଳିଦାନ କଲେ, ସେମାନେ କି ଆମ୍ଭମାନଙ୍କୁ ପଥର ପକାଇ ମାରିବେ ନାହିଁ? ");
INSERT INTO ory_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ଏଣୁକରି ଆମ୍ଭେମାନେ ତିନି ଦିନର ବାଟ ପ୍ରାନ୍ତରକୁ ଯାଇ ଆମ୍ଭମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଯେଉଁ ଆଜ୍ଞା ଦେବେ, ତଦନୁସାରେ ତାହାଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ତହୁଁ ଫାରୋ କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯିବାକୁ ଦେବା, ତୁମ୍ଭେମାନେ ପ୍ରାନ୍ତରକୁ ଯାଇ ଆପଣା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କର; ମାତ୍ର ବହୁ ଦୂରକୁ ଯାଅ ନାହିଁ, ପୁଣି, ଆମ୍ଭ ନିମନ୍ତେ ପ୍ରାର୍ଥନା କର।” ");
INSERT INTO ory_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ଏଥିଉତ୍ତାରେ ମୋଶା କହିଲେ, “ଦେଖ, ମୁଁ ଆପଣଙ୍କ ନିକଟରୁ ଯାଇ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ପ୍ରାର୍ଥନା କରିବି, ତହିଁରେ ଆପଣଙ୍କର, ଆପଣଙ୍କ ଦାସମାନଙ୍କ ଓ ଆପଣଙ୍କ ଲୋକମାନଙ୍କ ନିକଟରୁ ଆସନ୍ତାକାଲି ସମସ୍ତ ଦଂଶକ ଝିଙ୍କ ଦୂର ହୋଇଯିବେ; ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରିବା ପାଇଁ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେବା ବିଷୟରେ ଫାରୋ ପୁନର୍ବାର ପ୍ରବଞ୍ଚନା କରିବେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ତହୁଁ ମୋଶା ଫାରୋଙ୍କ ନିକଟରୁ ବାହାରକୁ ଯାଇ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ପ୍ରାର୍ଥନାନୁସାରେ ଫାରୋଙ୍କଠାରୁ, ତାଙ୍କ ଦାସଗଣ ଓ ଲୋକ ସମସ୍ତଙ୍କଠାରୁ ସମସ୍ତ ଦଂଶକାଦି ଝିଙ୍କ ଦୂର କଲେ; ଗୋଟିଏ ଅବଶିଷ୍ଟ ରହିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ଏଥର ମଧ୍ୟ ଫାରୋ ଆପଣା ହୃଦୟ କଠିନ କଲେ ଓ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଫାରୋ ନିକଟକୁ ଯାଇ ତାହାଙ୍କୁ କୁହ, ‘ଏବ୍ରୀୟମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଏହି କଥା କହନ୍ତି, ଆମ୍ଭର ସେବା କରିବା ପାଇଁ ତୁମ୍ଭେ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦିଅ। ");
INSERT INTO ory_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ମାତ୍ର ଯଦି ସେମାନଙ୍କୁ ଯିବା ପାଇଁ ନାସ୍ତି କରି ଏବେ ମଧ୍ୟ ବାଧା ଦେବ, ");
INSERT INTO ory_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ତେବେ ଦେଖ, ତୁମ୍ଭ କ୍ଷେତ୍ରସ୍ଥିତ ଘୋଡା, ଗର୍ଦ୍ଦଭ, ଓଟ, ଗୋରୁ ଓ ମେଷାଦି ପଶୁଗଣ ଉପରେ ସଦାପ୍ରଭୁଙ୍କ ହସ୍ତ ଅଛି; ଏଣୁ ଅତିଶୟ ମହାମାରୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ମାତ୍ର ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲୀୟମାନଙ୍କ ଓ ମିସରୀୟମାନଙ୍କ ପଶୁଗଣ ମଧ୍ୟରେ ପ୍ରଭେଦ କରିବେ; ତହିଁରେ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କର କୌଣସି ପଶୁ ମରିବ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ସଦାପ୍ରଭୁ ସମୟ ନିରୂପଣ କରି କହନ୍ତି, “ଆସନ୍ତାକାଲି ସଦାପ୍ରଭୁ ଏ ଦେଶରେ ଏହି କର୍ମ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ଆରଦିନ ସଦାପ୍ରଭୁ ସେହି କର୍ମ କଲେ, ତହିଁରେ ମିସରୀୟମାନଙ୍କ ସମସ୍ତ ପଶୁ ମଲେ; ମାତ୍ର ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ପଶୁଗଣ ମଧ୍ୟରୁ ଗୋଟିଏ ହେଁ ମଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ତହୁଁ ଫାରୋ ଲୋକ ପଠାଇ ଇସ୍ରାଏଲୀୟମାନଙ୍କର ଗୋଟିଏ ମାତ୍ର ପଶୁ ମରି ନ ଥିବାର ଦେଖିଲେ। ତଥାପି ଫାରୋଙ୍କ ହୃଦୟ କଠିନ ହେଲା ଓ ସେ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ଆଉ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ମୁଷ୍ଟି ପୂର୍ଣ୍ଣ କରି ଭାଟିର ଭସ୍ମ ନିଅ, ପୁଣି, ମୋଶା ଫାରୋଙ୍କ ସାକ୍ଷାତରେ ତାହା ଆକାଶ ଆଡ଼କୁ ବିଞ୍ଚି ଦେଉ। ");
INSERT INTO ory_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ତହିଁରେ ତାହା ସମୁଦାୟ ମିସର ଦେଶ ଉପରେ ସୂକ୍ଷ୍ମ ଧୂଳି ହୋଇ ମିସରୀୟ ସମସ୍ତ ମନୁଷ୍ୟ ଓ ପଶୁମାନଙ୍କ ଶରୀରରେ ଦାହଯୁକ୍ତ ବଥ ଜନ୍ମାଇବ।” ");
INSERT INTO ory_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ତହୁଁ ସେମାନେ ଭାଟିର ଭସ୍ମ ନେଇ ଫାରୋ ଆଗରେ ଠିଆ ହେଲେ; ପୁଣି, ମୋଶା ଆକାଶ ଆଡ଼େ ତାହା ବିଞ୍ଚି ଦିଅନ୍ତେ, ସମସ୍ତ ମନୁଷ୍ୟ ଓ ପଶୁମାନଙ୍କ ଶରୀରରେ ଦାହଯୁକ୍ତ ବଥ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ସେହି ବଥ ସକାଶୁ ମନ୍ତ୍ରଜ୍ଞମାନେ ମୋଶାଙ୍କ ସାକ୍ଷାତରେ ଠିଆ ହୋଇ ପାରିଲେ ନାହିଁ; କାରଣ ମନ୍ତ୍ରଜ୍ଞମାନଙ୍କ ଓ ସମସ୍ତ ମିସରୀୟମାନଙ୍କ ଶରୀରରେ ବଥ ଜାତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ କଲେ, ତହିଁରେ ସେ ମୋଶାଙ୍କ ପ୍ରତି ଉକ୍ତ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟ ପ୍ରମାଣେ ସେମାନଙ୍କ କଥାରେ ମନୋଯୋଗ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ପ୍ରଭାତରେ ଉଠି ଫାରୋ ସମ୍ମୁଖରେ ଠିଆ ହୋଇ ତାହାଙ୍କୁ ଏହି କଥା କୁହ, ‘ଏବ୍ରୀୟମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର କହନ୍ତି, ଆମ୍ଭର ସେବା କରିବାକୁ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦିଅ; ");
INSERT INTO ory_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ନୋହିଲେ ଏହିଥର ଆମ୍ଭେ ତୁମ୍ଭ ହୃଦୟ ବିରୁଦ୍ଧରେ, ପୁଣି, ତୁମ୍ଭ ଦାସଗଣ ଓ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଆମ୍ଭର ସର୍ବପ୍ରକାର ମହାମାରୀ ପଠାଇବା; ତହିଁରେ ସମୁଦାୟ ପୃଥିବୀରେ ଆମ୍ଭ ତୁଲ୍ୟ କେହି ନାହାନ୍ତି, ଏହା ତୁମ୍ଭେ ଜ୍ଞାତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","କାରଣ ବର୍ତ୍ତମାନ ସୁଦ୍ଧା ଆମ୍ଭେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କରି ମହାମାରୀ ଦ୍ୱାରା ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭ ଲୋକମାନଙ୍କୁ ସଂହାର କରନ୍ତୁଣି, ପୁଣି, ତୁମ୍ଭେ ପୃଥିବୀରୁ ଉଚ୍ଛିନ୍ନ ହୋଇ ସାରନ୍ତଣି; ");
INSERT INTO ory_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ମାତ୍ର ତୁମ୍ଭକୁ ଆପଣା ପରାକ୍ରମ ଦେଖାଇବାକୁ ଓ ସମୁଦାୟ ପୃଥିବୀରେ ଯେପରି ଆମ୍ଭର ନାମ କୀର୍ତ୍ତିତ ହେବ, ପ୍ରକୃତରେ ଏଥିପାଇଁ ଆମ୍ଭେ ତୁମ୍ଭକୁ ସ୍ଥାପନ କରି ରଖିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ତଥାପି ତୁମ୍ଭେ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ନ ଦେଇ ସେମାନଙ୍କ ଉପରେ ଦର୍ପ କରୁଅଛ? ");
INSERT INTO ory_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ଦେଖ, ଆମ୍ଭେ ଆସନ୍ତାକାଲି ଏପରି ସମୟରେ ମିସର ଦେଶରେ ଏପରି ଭାରୀ ଶିଳାବୃଷ୍ଟି କରିବା ଯେ, ମିସରର ପତ୍ତନାବଧି ଆଜିଯାଏ ସେପରି କେବେ ହୋଇ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ଏନିମନ୍ତେ ଏବେ ଲୋକ ପଠାଇ କ୍ଷେତ୍ରରେ ତୁମ୍ଭର ପଶ୍ୱାଦି ଯାହା ଯାହା ଅଛି, ତାହାସବୁ ଶୀଘ୍ର ଅଣାଅ, କାରଣ ଯେଉଁ ମନୁଷ୍ୟ କି ପଶୁ କ୍ଷେତ୍ରରେ ରହିବେ, ଗୃହକୁ ଅଣା ନ ଯିବେ, ସେମାନଙ୍କ ଉପରେ ଶିଳାବୃଷ୍ଟି ହେଲେ ସେମାନେ ମରିବେ।’” ");
INSERT INTO ory_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ସେତେବେଳେ ଫାରୋଙ୍କର ଦାସମାନଙ୍କ ମଧ୍ୟରୁ ଯେଉଁ ବ୍ୟକ୍ତି ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟରେ ଭୀତ ହେଲା, ସେ ଶୀଘ୍ର ଆପଣା ଦାସ ଓ ପଶୁମାନଙ୍କୁ ଗୃହକୁ ଆଣିଲା। ");
INSERT INTO ory_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ମାତ୍ର ଯେ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟରେ ମନୋଯୋଗ ନ କଲା, ସେ ଆପଣା ଦାସ ଓ ପଶୁମାନଙ୍କୁ କ୍ଷେତ୍ରରେ ତ୍ୟାଗ କଲା। ");
INSERT INTO ory_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆକାଶ ଆଡ଼େ ଆପଣା ହସ୍ତ ବିସ୍ତାର କର, ତହିଁରେ ମିସରୀୟ ସମସ୍ତ ମନୁଷ୍ୟ, ପଶୁ ଓ କ୍ଷେତ୍ରସ୍ଥ ତୃଣାଦି ସମସ୍ତ ଉପରେ ଶିଳାବୃଷ୍ଟି ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ତହୁଁ ମୋଶା ଆପଣା ଯଷ୍ଟି ଆକାଶ ଆଡ଼େ ବିସ୍ତାର କରନ୍ତେ, ସଦାପ୍ରଭୁ ମେଘ ଗର୍ଜ୍ଜନ ଓ ଶିଳାବୃଷ୍ଟି କଲେ; ପୁଣି, ବିଜୁଳି ଭୂମି ଆଡ଼େ ବେଗେ ଗମନ କଲା; ଏହିରୂପେ ସଦାପ୍ରଭୁ ମିସର ଦେଶରେ ଶିଳାବୃଷ୍ଟି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ତହିଁରେ ଶିଳାବୃଷ୍ଟି ହେଲା ଓ ଶିଳା ସଙ୍ଗେ ସଙ୍ଗେ ବିଜୁଳି ଚମକିଲା; ଏପ୍ରକାର ଅତି ଦୁଃସହ ଶିଳାବୃଷ୍ଟି ମିସର ଦେଶରେ ରାଜ୍ୟସ୍ଥାପନାବଧି କେବେ ହୋଇ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ତହିଁରେ ସମୁଦାୟ ମିସର ଦେଶର କ୍ଷେତ୍ରସ୍ଥ ମନୁଷ୍ୟ ଓ ପଶୁ ସମସ୍ତେ ଶିଳା ଦ୍ୱାରା ହତ ହେଲେ ଓ କ୍ଷେତ୍ରସ୍ଥ ସକଳ ତୃଣ ଶିଳାବୃଷ୍ଟିରେ ନଷ୍ଟ ହେଲା, କ୍ଷେତ୍ରସ୍ଥ ସବୁ ବୃକ୍ଷ ଭାଙ୍ଗିଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","କେବଳ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ବାସସ୍ଥାନ ଗୋଶନ ପ୍ରଦେଶରେ ଶିଳାବୃଷ୍ଟି ହେଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ଏଥିଉତ୍ତାରେ ଫାରୋ ଲୋକ ପଠାଇ ମୋଶା ଓ ହାରୋଣଙ୍କୁ ଡକାଇ କହିଲେ, “ଏହିଥର ମୁଁ ପାପ କରିଅଛି; ସଦାପ୍ରଭୁ ଧାର୍ମିକ, ମାତ୍ର ଆମ୍ଭେ ଓ ଆମ୍ଭ ଲୋକମାନେ ଦୋଷୀ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କର; କାରଣ ପରମେଶ୍ୱରକୃତ ଗର୍ଜ୍ଜନ ଓ ଶିଳାବୃଷ୍ଟି ଯଥେଷ୍ଟ ହୋଇଅଛି; ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯିବାକୁ ଦେବା, ତୁମ୍ଭମାନଙ୍କର ଆଉ ବିଳମ୍ବ ହେବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ସେତେବେଳେ ମୋଶା ତାଙ୍କୁ କହିଲେ, “ମୁଁ ନଗରରୁ ବାହାର ହୋଇଗଲା କ୍ଷଣେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ଆପଣ ହସ୍ତ ବିସ୍ତାର କରିବି, ତହିଁରେ ମେଘ ଗର୍ଜ୍ଜନ ନିବୃତ୍ତ ହେବ ଓ ଶିଳାବୃଷ୍ଟି ଆଉ ହେବ ନାହିଁ; ପୁଣି, ଏହି ପୃଥିବୀ ଯେ ସଦାପ୍ରଭୁଙ୍କର, ତାହା ଆପଣ ଜାଣି ପାରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ମାତ୍ର ମୁଁ ଜାଣେ, ଆପଣ ଓ ଆପଣଙ୍କ ଦାସଗଣ ଆଜି ପର୍ଯ୍ୟନ୍ତ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କରୁ ନାହାନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ସେସମୟରେ ଫେସି ଓ ଯବ ସବୁ ନଷ୍ଟ ହେଲା, କାରଣ ଯବ ଶିଷାଯୁକ୍ତ ଓ ଫେସି ପୁଷ୍ପିତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ମାତ୍ର ଗହମ ଓ ଜହ୍ନା ବଡ଼ ହୋଇ ନ ଥିବାରୁ ନଷ୍ଟ ହେଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ଏଥିଉତ୍ତାରେ ମୋଶା ଫାରୋଙ୍କ ନିକଟରୁ ନଗରର ବାହାରକୁ ଯାଇ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କରନ୍ତେ, ମେଘ ଗର୍ଜ୍ଜନ ଓ ଶିଳାବୃଷ୍ଟି ନିବୃତ୍ତ ହେଲା, ଭୂମିରେ ଆଉ ଜଳ ବୃଷ୍ଟି ହେଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ସେତେବେଳେ ବୃଷ୍ଟି ଓ ଶିଳାପାତ ଓ ମେଘ ଗର୍ଜ୍ଜନ ନିବୃତ୍ତ ହେବାର ଦେଖି ଫାରୋ ଆହୁରି ପାପ କଲେ, ପୁଣି, ସେ ଓ ତାଙ୍କ ଦାସମାନେ ଆପଣା ଆପଣା ମନ କଠିନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ତହିଁରେ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ ହେଲା; ଏଣୁ ମୋଶାଙ୍କ ଦ୍ୱାରା କଥିତ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ସେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଯିବାକୁ ଦେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଫାରୋ ନିକଟକୁ ଯାଅ; କାରଣ ଆମ୍ଭେ ଯେପରି ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଏହି ସକଳ ଚିହ୍ନ ଦର୍ଶାଇବା, ");
INSERT INTO ory_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ପୁଣି, ଆମ୍ଭେ ମିସରୀୟମାନଙ୍କ ପ୍ରତି ଯାହା ଯାହା କରିଅଛୁ ଓ ସେମାନଙ୍କ ମଧ୍ୟରେ ଆପଣାର ଚିହ୍ନ ସ୍ୱରୂପେ ଯେଉଁ ଯେଉଁ କର୍ମ କରିଅଛୁ, ସେସବୁର ବୃତ୍ତାନ୍ତ ତୁମ୍ଭେ ଯେପରି ଆପଣା ପୁତ୍ର ଓ ପୌତ୍ରର କର୍ଣ୍ଣଗୋଚରରେ କହିବ, ପୁଣି, ଆମ୍ଭେ ଯେ ସଦାପ୍ରଭୁ ଏହା ଜ୍ଞାତ ହେବ, ଏନିମନ୍ତେ ଆମ୍ଭେ ଫାରୋ ଓ ତାହାର ଦାସଗଣର ହୃଦୟ କଠିନ କଲୁ।” ");
INSERT INTO ory_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ସେତେବେଳେ ମୋଶା ଓ ହାରୋଣ ଫାରୋଙ୍କ ନିକଟକୁ ଯାଇ କହିଲେ, “ଏବ୍ରୀୟମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର କହନ୍ତି, ‘ତୁମ୍ଭେ ଆମ୍ଭ ସାକ୍ଷାତରେ ନମ୍ର ହେବାକୁ କେତେ କାଳ ନାସ୍ତି କରିବ? ଆମ୍ଭର ସେବା କରିବା ନିମନ୍ତେ ଆମ୍ଭ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦିଅ। ");
INSERT INTO ory_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ମାତ୍ର ଯଦି ମୋହର ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦେବା ପାଇଁ ମନା କର, ତେବେ ଦେଖ, ଆମ୍ଭେ ଆସନ୍ତାକାଲି ତୁମ୍ଭ ଅଞ୍ଚଳକୁ ପଙ୍ଗପାଳ ଆଣିବା। ");
INSERT INTO ory_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ସେମାନେ ଭୂମିର ମୁଖ ଏପରି ଆଚ୍ଛନ୍ନ କରିବେ ଯେ, କେହି ତାହା ଦେଖି ପାରିବ ନାହିଁ; ପୁଣି, ଶିଳା ବୃଷ୍ଟିରୁ ରକ୍ଷିତ ଓ ଅବଶିଷ୍ଟ ଯାହା କିଛି ତୁମ୍ଭମାନଙ୍କର ଅଛି, ତାହା ସେମାନେ ଖାଇବେ, ପୁଣି, ତୁମ୍ଭମାନଙ୍କର କ୍ଷେତ୍ରୋତ୍ପନ୍ନ ସମସ୍ତ ବୃକ୍ଷ ଖାଇବେ। ");
INSERT INTO ory_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ପୁଣି, ସେମାନଙ୍କ ଦ୍ୱାରା ତୁମ୍ଭର ଗୃହ, ତୁମ୍ଭ ଦାସଗଣର ଗୃହ ଓ ସକଳ ମିସରୀୟ ଲୋକଙ୍କ ଗୃହ ପରିପୂର୍ଣ୍ଣ ହେବ; ଏ ଦେଶରେ ତୁମ୍ଭ ପୂର୍ବପୁରୁଷମାନଙ୍କ ଓ ସେମାନଙ୍କ ପୂର୍ବପୁରୁଷମାନଙ୍କ ଜନ୍ମାବଧି ଆଜି ପର୍ଯ୍ୟନ୍ତ କେବେ ଏପରି ଦେଖାଯାଇ ନାହିଁ।’” ତହୁଁ ମୋଶା ମୁଖ ଫେରାଇ ଫାରୋଙ୍କ ନିକଟରୁ ବାହାରିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ଏଥିଉତ୍ତାରେ ଫାରୋଙ୍କର ଦାସଗଣ ତାଙ୍କୁ କହିଲେ, “ଏ ମନୁଷ୍ୟ କେତେ କାଳ ଆମ୍ଭମାନଙ୍କର ଫାନ୍ଦ ସ୍ୱରୂପ ହୋଇଥିବ? ଏହି ଲୋକମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ସେବା କରିବା ପାଇଁ ଏମାନଙ୍କୁ ଯିବାକୁ ଦେଉନ୍ତୁ; ମିସର ଦେଶ ଯେ ନଷ୍ଟ ହେଲାଣି, ଏହା କି ଆପଣ ଏବେ ହେଁ ବୁଝନ୍ତି ନାହିଁ?” ");
INSERT INTO ory_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ତେବେ ମୋଶା ଓ ହାରୋଣ ପୁନର୍ବାର ଫାରୋଙ୍କ ନିକଟକୁ ଅଣା ଯାଆନ୍ତେ, ସେ ସେମାନଙ୍କୁ କହିଲେ, “ଯାଅ, ତୁମ୍ଭମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କର ସେବା କର; ମାତ୍ର କିଏ କିଏ ଯିବ?” ");
INSERT INTO ory_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ତହିଁରେ ମୋଶା କହିଲେ, “ଆମ୍ଭେମାନେ ଆପଣା ଆପଣା ବାଳକ ଓ ବୃଦ୍ଧ ସମସ୍ତଙ୍କୁ ସଙ୍ଗେ ଘେନି ଯିବୁ ଓ ଆପଣା ଆପଣା ପୁତ୍ରକନ୍ୟାମାନଙ୍କୁ, ପୁଣି, ଗୋମେଷାଦି ପଲ ମଧ୍ୟ ସଙ୍ଗରେ ଘେନି ଯିବୁ, ଯେହେତୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆମ୍ଭମାନଙ୍କର ଉତ୍ସବ କରିବାକୁ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ତେବେ ଫାରୋ ସେମାନଙ୍କୁ କହିଲେ, “ହେଉ, ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ସହବର୍ତ୍ତୀ ହୁଅନ୍ତୁ, ଆମ୍ଭେ ତ ତୁମ୍ଭମାନଙ୍କୁ ଓ ତୁମ୍ଭମାନଙ୍କ ବାଳକମାନଙ୍କୁ ଯିବାକୁ ଦେବୁ; ସାବଧାନ, ଅମଙ୍ଗଳ ତୁମ୍ଭମାନଙ୍କ ସମ୍ମୁଖରେ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ଏପରି ହେବ ନାହିଁ, ତୁମ୍ଭେମାନେ ଯେତେ ପୁରୁଷ ଅଛ, ଯାଅ, ସଦାପ୍ରଭୁଙ୍କର ସେବା କର; କାରଣ ଏହା ହିଁ ତୁମ୍ଭେମାନେ ଚାହଁ।” ଏଉତ୍ତାରେ ସେମାନେ ଫାରୋଙ୍କ ସାକ୍ଷାତରୁ ତାଡ଼ିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ପଙ୍ଗପାଳ ନିମନ୍ତେ ମିସର ଦେଶ ଉପରେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କର, ତହିଁରେ ସେମାନେ ମିସର ଦେଶକୁ ଆସି ଶିଳାବୃଷ୍ଟିର ଅବଶିଷ୍ଟାଂଶ ଭୂମିର ତୃଣାଦି ସମସ୍ତ ଗ୍ରାସ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ତହୁଁ ମୋଶା ମିସର ଦେଶ ଉପରେ ଆପଣା ଯଷ୍ଟି ବିସ୍ତାର କରନ୍ତେ, ସଦାପ୍ରଭୁ ସେହି ସାରା ଦିବାରାତ୍ରି ଦେଶରେ ପୂର୍ବୀୟ ବାୟୁ ବୁହାଇଲେ; ପ୍ରଭାତ ହୁଅନ୍ତେ, ପୂର୍ବୀୟ ବାୟୁ ଦ୍ୱାରା ପଙ୍ଗପାଳ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ତହିଁରେ ସମୁଦାୟ ମିସର ଦେଶରେ ପଙ୍ଗପାଳ ବ୍ୟାପିଗଲେ, ମିସରର ସମସ୍ତ ଅଞ୍ଚଳରେ ପଙ୍ଗପାଳ ପଡ଼ିଲେ; ସେମାନେ ଅତ୍ୟନ୍ତ ଭୟାନକ ଥିଲେ; ସେପରି ପଙ୍ଗପାଳ ପୂର୍ବରେ କଦାପି ହୋଇ ନ ଥିଲା, କି ଆଉ କେବେ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ସେମାନେ ସମୁଦାୟ ଭୂମି ଆଚ୍ଛନ୍ନ କଲେ ଓ ସେମାନଙ୍କ ଦ୍ୱାରା ଦେଶ ଅନ୍ଧକାରାବୃତ ହେଲା, ଭୂମିର ଯେ ତୃଣ ଓ ବୃକ୍ଷାଦିର ଯେ ଫଳ ଶିଳା ବୃଷ୍ଟିରୁ ରକ୍ଷା ପାଇଥିଲା, ତାହା ସେମାନେ ଖାଇ ପକାଇଲେ; ତହିଁରେ ସମୁଦାୟ ମିସର ଦେଶରେ କୌଣସି ବୃକ୍ଷ କି କ୍ଷେତ୍ରର ତୃଣାଦି ହରିତ୍‍ବର୍ଣ୍ଣ କିଛିମାତ୍ର ରହିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ତହୁଁ ଫାରୋ ଶୀଘ୍ର ମୋଶା ଓ ହାରୋଣଙ୍କୁ ଡକାଇ କହିଲେ, “ମୁଁ ତୁମ୍ଭମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଓ ତୁମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ପାପ କରିଅଛି। ");
INSERT INTO ory_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ବିନୟ କରୁଅଛୁ, କେବଳ ଏହି ଥରକ ଆମ୍ଭର ପାପ କ୍ଷମା କରି ଆମ୍ଭ ନିକଟରୁ ଏହି କାଳ ସ୍ୱରୂପକୁ ଦୂର କରିବା ପାଇଁ ଆପଣାମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ତହିଁରେ ସେ ଫାରୋଙ୍କ ନିକଟରୁ ଯାଇ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କରନ୍ତେ, ");
INSERT INTO ory_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ସଦାପ୍ରଭୁ ପ୍ରବଳ ପଶ୍ଚିମ ବାୟୁ ଫେରାଇ ଦେଶରୁ ପଙ୍ଗପାଳମାନଙ୍କୁ ଉଠାଇ ନେଇ ସୂଫ ସାଗରରେ ନିକ୍ଷେପ କଲେ; ତହିଁରେ ମିସରର କୌଣସି ଅଞ୍ଚଳରେ ଗୋଟିଏ ପଙ୍ଗପାଳ ରହିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ମାତ୍ର ସଦାପ୍ରଭୁ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ କଲେ, ପୁଣି, ସେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଯିବାକୁ ଦେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ଆଉ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆକାଶ ଆଡ଼େ ହସ୍ତ ବିସ୍ତାର କର; ତହିଁରେ ମିସର ଦେଶରେ ଅନ୍ଧକାର ହେବ ଓ ଅନ୍ଧକାର ସକାଶୁ ଲୋକମାନେ ଦରାଣ୍ଡି ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ଏଥିଉତ୍ତାରେ ମୋଶା ଆକାଶ ଆଡ଼େ ହସ୍ତ ବିସ୍ତାର କରନ୍ତେ, ତିନି ଦିନ ପର୍ଯ୍ୟନ୍ତ ମିସର ଦେଶର ସର୍ବତ୍ର ଏପରି ଗାଢ଼ ଅନ୍ଧକାର ହେଲା ଯେ, କେହି ପରସ୍ପରକୁ ଦେଖି ପାରିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ଓ ତିନି ଦିନ ପର୍ଯ୍ୟନ୍ତ କେହି ଆପଣା ସ୍ଥାନରୁ ଉଠି ପାରିଲେ ନାହିଁ; ମାତ୍ର ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ବାସ ସ୍ଥାନରେ ଆଲୁଅ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ତହୁଁ ଫାରୋ ମୋଶାଙ୍କୁ ଡକାଇ କହିଲେ, “ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ସେବା କରିବାକୁ ଯାଅ; କେବଳ ତୁମ୍ଭମାନଙ୍କର ଗୋମେଷାଦି ପଲ ଥାଉନ୍ତୁ; ତୁମ୍ଭମାନଙ୍କ ବାଳକମାନେ ମଧ୍ୟ ତୁମ୍ଭମାନଙ୍କ ସଙ୍ଗେ ଯାଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ତହିଁରେ ମୋଶା କହିଲେ, “ଆମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯେଉଁ ବଳି ଓ ହୋମଦ୍ରବ୍ୟ ଉତ୍ସର୍ଗ କରିବା, ତାହା ମଧ୍ୟ ଆମ୍ଭମାନଙ୍କ ହସ୍ତରେ ଆପଣଙ୍କୁ ଦେବାକୁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ଆମ୍ଭମାନଙ୍କ ପଶୁଗଣ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଯିବେ, ଗୋଟିଏ ଖୁରା ହିଁ ଅବଶିଷ୍ଟ ରହିବ ନାହିଁ; କାରଣ ଆମ୍ଭମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ସେବା ନିମନ୍ତେ ସେମାନଙ୍କ ମଧ୍ୟରୁ ବଳି ନେବାକୁ ହେବ; ପୁଣି, କି ଦେଇ ସଦାପ୍ରଭୁଙ୍କର ସେବା କରିବାକୁ ହେବ, ତାହା ସେଠାରେ ଉପସ୍ଥିତ ନ ହେଲେ, ଆମ୍ଭେମାନେ ଜାଣି ପାରିବୁ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ମାତ୍ର ସଦାପ୍ରଭୁ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ କଲେ, ପୁଣି, ସେ ସେମାନଙ୍କୁ ଯିବାକୁ ଦେବା ପାଇଁ ସମ୍ମତ ହେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ଏଣୁ ଫାରୋ ତାଙ୍କୁ କହିଲେ, “ଆମ୍ଭ ନିକଟରୁ ଦୂର ହୁଅ, ଆପଣା ବିଷୟରେ ସାବଧାନ ହୁଅ, ଆମ୍ଭର ମୁଖ ଆଉ କେବେ ଦେଖ ନାହିଁ; ଯେଉଁ ଦିନ ଆମ୍ଭର ମୁଖ ଦେଖିବ, ସେହି ଦିନ ମରିବ।” ");
INSERT INTO ory_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ତହିଁରେ ମୋଶା କହିଲେ, “ଆପଣ ଭଲ କହିଲେ, ମୁଁ ଆଉ କେବେ ଆପଣଙ୍କ ମୁଖ ଦେଖିବି ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ଫାରୋ ଓ ମିସର ଉପରେ ଆଉ ଏକ ଉତ୍ପାତ ଆଣିବା; ତହିଁ ଉତ୍ତାରେ ସେ ତୁମ୍ଭମାନଙ୍କୁ ଏ ସ୍ଥାନରୁ ଯିବାକୁ ଦେବ; ପୁଣି, ଯିବାକୁ ଦେବା ସମୟରେ ସେ ତୁମ୍ଭମାନଙ୍କୁ ନିତାନ୍ତ ତଡ଼ି ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ଏହେତୁ ଏବେ ଲୋକମାନଙ୍କ କର୍ଣ୍ଣଗୋଚରରେ କୁହ, ପ୍ରତ୍ୟେକ ପୁରୁଷ ଆପଣା ଆପଣା ପ୍ରତିବାସୀଠାରୁ ଓ ପ୍ରତ୍ୟେକ ସ୍ତ୍ରୀ ଆପଣା ଆପଣା ପ୍ରତିବାସିନୀଠାରୁ ରୌପ୍ୟ-ଅଳଙ୍କାର ଓ ସ୍ୱର୍ଣ୍ଣ-ଅଳଙ୍କାର ମାଗି ନିଅନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ଆଉ ସଦାପ୍ରଭୁ ମିସରୀୟମାନଙ୍କ ଦୃଷ୍ଟିରେ ଲୋକମାନଙ୍କୁ ଅନୁଗ୍ରହପ୍ରାପ୍ତ କଲେ। ପୁଣି, ମିସର ଦେଶରେ ଫାରୋଙ୍କର ଦାସମାନଙ୍କ ଓ ଲୋକମାନଙ୍କ ଦୃଷ୍ଟିରେ ମୋଶା ଅତି ସମ୍ଭ୍ରାନ୍ତ ପୁରୁଷ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ଏଥିଉତ୍ତାରେ ମୋଶା କହିଲେ, “ସଦାପ୍ରଭୁ ଏହି କଥା କହନ୍ତି, ‘ଆମ୍ଭେ ଦୁଇପ୍ରହର ରାତ୍ରିରେ ମିସରର ମଧ୍ୟଦେଇ ଗମନ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ତହିଁରେ ସିଂହାସନୋପବିଷ୍ଟ ଫାରୋଙ୍କର ପ୍ରଥମଜାତଠାରୁ ଚକି ପେଷଣକାରିଣୀ ଦାସୀର ପ୍ରଥମଜାତ ପର୍ଯ୍ୟନ୍ତ ମିସର ଦେଶସ୍ଥିତ ସମସ୍ତ ପ୍ରଥମଜାତ ଓ ପଶୁମାନଙ୍କର ପ୍ରଥମଜାତ ମରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ଏଣୁ ସମୁଦାୟ ମିସର ଦେଶରେ, ଯେପରି କେବେ ହୋଇ ନାହିଁ ଓ ହେବ ନାହିଁ, ଏପରି ମହାରୋଦନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ମାତ୍ର ସଦାପ୍ରଭୁ ମିସରୀୟ ଲୋକଙ୍କଠାରୁ ଇସ୍ରାଏଲୀୟ ଲୋକଙ୍କୁ ପ୍ରଭେଦ କରନ୍ତି, ଏହା ଯେପରି ତୁମ୍ଭେମାନେ ଜ୍ଞାତ ହେବ, ଏଥିପାଇଁ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ମଧ୍ୟରେ ମନୁଷ୍ୟ କି ପଶୁ ପ୍ରତି ଗୋଟିଏ କୁକ୍କୁର ସୁଦ୍ଧା ଜିହ୍ୱା ପଜାଇବ ନାହିଁ।’ ");
INSERT INTO ory_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ତହିଁରେ ତୁମ୍ଭର ଏହି ସମସ୍ତ ଦାସମାନେ ମୋʼ ନିକଟକୁ ନତ ହୋଇ ଆସିବେ ଓ ମୋତେ ପ୍ରଣାମ କରି କହିବେ, ‘ତୁମ୍ଭେ ଓ ତୁମ୍ଭର ଅନୁଗତ ସମସ୍ତ ଲୋକ ବାହାରି ଯାଅ;’ ତହିଁ ଉତ୍ତାରେ ମୁଁ ବାହାରି ଯିବି।” ଏଥିଉତ୍ତାରେ ସେ ପ୍ରଚଣ୍ଡ କ୍ରୋଧରେ ଫାରୋଙ୍କ ନିକଟରୁ ବାହାରିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଥିଲେ, “ଆମ୍ଭେ ଯେପରି ମିସର ଦେଶରେ ଆପଣା ଆଶ୍ଚର୍ଯ୍ୟକ୍ରିୟା ବହୁସଂଖ୍ୟକ କରିବା, ଏଥିପାଇଁ ଫାରୋ ତୁମ୍ଭମାନଙ୍କ କଥାରେ ମନୋଯୋଗ କରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ପୁଣି, ମୋଶା ଓ ହାରୋଣ ଫାରୋଙ୍କ ସମ୍ମୁଖରେ ଏହି ସମସ୍ତ ଆଶ୍ଚର୍ଯ୍ୟକର୍ମ କରିଥିଲେ; ମାତ୍ର ସଦାପ୍ରଭୁ ଫାରୋଙ୍କର ହୃଦୟ କଠିନ କରନ୍ତେ, ସେ ଆପଣା ଦେଶରୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଯିବାକୁ ଦେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ଏଥିଉତ୍ତାରେ ମିସର ଦେଶରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ଏହି ମାସ ତୁମ୍ଭମାନଙ୍କର ପ୍ରଧାନ ମାସ ଓ ବର୍ଷର ପ୍ରଥମ ମାସ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲୀୟ ସମଗ୍ର ମଣ୍ଡଳୀକୁ ଏହି କଥା କୁହ, ଏହି ମାସର ଦଶମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ପ୍ରତ୍ୟେକ ମନୁଷ୍ୟ ପିତୃଗୃହାନୁସାରେ ପ୍ରତ୍ୟେକ ପରିବାର ନିମନ୍ତେ ଏକ ଏକ ମେଷଶାବକ ନେବ। ");
INSERT INTO ory_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ଆଉ, ଗୋଟିଏ ମେଷଶାବକ ନେବା ନିମନ୍ତେ ଯଦି କୌଣସି ପରିଜନ ଅଳ୍ପ ହେବ, ତେବେ ସେ ଓ ତାହାର ଗୃହ ନିକଟବର୍ତ୍ତୀ ପ୍ରତିବାସୀ, ପ୍ରାଣୀଗଣର ସଂଖ୍ୟାନୁସାରେ ଏକ ମେଷଶାବକ ନେବେ; ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ଜଣର ଭୋଜନ ଶକ୍ତି ଅନୁସାରେ ମେଷଶାବକର ଅଟକଳ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ତୁମ୍ଭେମାନେ ମେଷପଲ ବା ଛାଗପଲ ମଧ୍ୟରୁ ଶାବକ ନେବ; ତାହା ନିର୍ଦ୍ଦୋଷ, ଏକ ବର୍ଷୀୟ ଓ ପୁଂଶାବକ ହେବ; ");
INSERT INTO ory_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ସେହି ମାସର ଚତୁର୍ଦ୍ଦଶ ଦିନ ଯାଏ ତାକୁ ବନ୍ଦ କରି ରଖିବ; ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ମଣ୍ଡଳୀର ସମସ୍ତ ସମାଜ ସନ୍ଧ୍ୟାକାଳରେ ସେହି ଶାବକକୁ ବଧ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ପୁଣି, ଲୋକମାନେ ତାହାର କିଛି ରକ୍ତ ନେଇ ଯେଉଁ ଯେଉଁ ଗୃହ ମଧ୍ୟରେ ମେଷ ଭୋଜନ କରିବେ, ସେହି ସେହି ଗୃହ ଦ୍ୱାରର ଦୁଇ ବାଜୁବନ୍ଧ ଓ କପାଳୀ ଉପରେ ତାହା ଲଗାଇବେ। ");
INSERT INTO ory_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ଆଉ ସେହି ରାତ୍ରିରେ ତାହାର ମାଂସ ଭୋଜନ କରିବେ; ଅଗ୍ନିରେ ଦଗ୍ଧ କରି ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଓ ପିତା ଶାକ ସହିତ ତାହା ଭୋଜନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ତୁମ୍ଭେମାନେ ସେହି ମାଂସ ଅପକ୍ୱ କିମ୍ବା ଜଳରେ ସିଦ୍ଧ କରି ଭୋଜନ କରିବ ନାହିଁ, ମାତ୍ର ଅଗ୍ନିରେ ତାହାର ମୁଣ୍ଡ ଓ ଜଙ୍ଘ ଶରୀର ସମେତ ଦଗ୍ଧ କରି ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ପୁଣି, ପ୍ରଭାତ ଯାଏ ତହିଁର କିଛି ରଖିବ ନାହିଁ; ଯଦି ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ କିଛି ଅବଶିଷ୍ଟ ରହିବ, ତାହା ଅଗ୍ନିରେ ଭସ୍ମସାତ୍‍ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ଏହି ପ୍ରକାରେ ତୁମ୍ଭେମାନେ ତାହା ଚଞ୍ଚଳ ଭୋଜନ କରିବ, କାରଣ ତୁମ୍ଭେମାନେ କଟିବନ୍ଧନ କରି ପାଦରେ ପାଦୁକା ଦେଇ ହସ୍ତରେ ଯଷ୍ଟି ଘେନି ଯାତ୍ରା କରିବା ନିମନ୍ତେ ପ୍ରସ୍ତୁତ ହେବ; ଏହା ସଦାପ୍ରଭୁଙ୍କର ନିସ୍ତାର ପର୍ବ। ");
INSERT INTO ory_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","ଯେହେତୁ ଆମ୍ଭେ ଆଜି ରାତ୍ରି ମିସର ଦେଶର ମଧ୍ୟଦେଇ ଯାଇ ମିସର ଦେଶସ୍ଥ ମନୁଷ୍ୟ ଓ ପଶୁର ସମସ୍ତ ପ୍ରଥମଜାତକୁ ସଂହାର କରିବା; ପୁଣି, ମିସରୀୟ ସମସ୍ତ ଦେବତାର ବିଚାର କରି ଦଣ୍ଡ ଦେବା; ଆମ୍ଭେ ସଦାପ୍ରଭୁ। ");
INSERT INTO ory_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ଏଣୁକରି ତୁମ୍ଭେମାନେ ଯେଉଁ ଯେଉଁ ଗୃହରେ ଥାଅ, ସେହି ସେହି ଗୃହରେ ସେହି ରକ୍ତ ଚିହ୍ନ ସ୍ୱରୂପେ ରହିବ; ଆଉ ଆମ୍ଭେ ମିସର ଦେଶକୁ ଦଣ୍ଡ ଦେବା ସମୟରେ ସେହି ରକ୍ତ ଦେଖିଲେ, ତୁମ୍ଭମାନଙ୍କୁ ଛାଡ଼ି ଆଗକୁ ଯିବା, ପୁଣି, ସଂହାରକ ଆଘାତ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଘଟିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ଆଉ ସେହି ଦିନ ତୁମ୍ଭମାନଙ୍କର ସ୍ମରଣୀୟ ହେବ, ପୁଣି, ତୁମ୍ଭେମାନେ ସେହି ଦିନକୁ ସଦାପ୍ରଭୁଙ୍କ ପର୍ବ ରୂପେ ପାଳନ କରିବ; ପୁରୁଷାନୁକ୍ରମେ ଅନନ୍ତକାଳୀନ ବିଧିମତେ ଏହି ପର୍ବ ପାଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ତୁମ୍ଭେମାନେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଖାଇବ; ବିଶେଷତଃ ପ୍ରଥମ ଦିନ ଆପଣା ଆପଣା ଗୃହରୁ ତାଡ଼ି ଦୂର କରିବ, କାରଣ ଯେଉଁ ଜନ ପ୍ରଥମ ଦିନଠାରୁ ସପ୍ତମ ଦିନ ପର୍ଯ୍ୟନ୍ତ ତାଡ଼ି ମିଶ୍ରିତ ରୁଟି ଖାଇବ, ସେ ପ୍ରାଣୀ ଇସ୍ରାଏଲ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ଆଉ ପ୍ରଥମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ, ପୁଣି, ସପ୍ତମ ଦିନରେ ମଧ୍ୟ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ; ଆଉ ସେହି ଦୁଇ ଦିନରେ ପ୍ରତ୍ୟେକ ପ୍ରାଣୀର ଖାଦ୍ୟର ଆୟୋଜନ ବିନୁ ଆଉ କୌଣସି କର୍ମ କରାଯିବ ନାହିଁ, କେବଳ ସେହି କର୍ମ ତୁମ୍ଭେମାନେ କରି ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ଏହି ପ୍ରକାରେ ତୁମ୍ଭେମାନେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ପର୍ବ ପାଳନ କରିବ, କାରଣ ସେହି ଦିନରେ ହିଁ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ସୈନ୍ୟମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିବା; ଏଣୁ ତୁମ୍ଭେମାନେ ପୁରୁଷାନୁକ୍ରମେ ଅନନ୍ତକାଳୀନ ବିଧିମତେ ଏହି ଦିନ ପାଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ତୁମ୍ଭେମାନେ ପ୍ରଥମ ମାସର ଚଉଦ ଦିନର ସନ୍ଧ୍ୟା ସମୟରୁ ଏକୋଇଶ ଦିନର ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ସପ୍ତାହ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭମାନଙ୍କ ଗୃହରେ ଲେଶମାତ୍ର ତାଡ଼ି ନ ରହୁ, କାରଣ ବିଦେଶୀ ଅବା ସ୍ୱଦେଶୀ ଯେଉଁ ଜନ ଏଥିମଧ୍ୟରେ ତାଡ଼ି ମିଶ୍ରିତ ଦ୍ରବ୍ୟ ଖାଇବ, ସେ ପ୍ରାଣୀ ଇସ୍ରାଏଲ-ମଣ୍ଡଳୀରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ତୁମ୍ଭେମାନେ ତାଡ଼ି ମିଶ୍ରିତ କୌଣସି ଦ୍ରବ୍ୟ ଖାଇବ ନାହିଁ, ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ସମସ୍ତ ବାସ ସ୍ଥାନରେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଖାଇବ।” ");
INSERT INTO ory_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ସେତେବେଳେ ମୋଶା ଇସ୍ରାଏଲର ସମସ୍ତ ପ୍ରାଚୀନ ଲୋକଙ୍କୁ ଡକାଇ କହିଲେ, “ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଆପଣା ଆପଣା ପରିଜନାନୁସାରେ ଏକ ଏକ ମେଷଶାବକ ବାହାର କରି ନେଇ ନିସ୍ତାରପର୍ବୀୟ ବଳି ବଧ କର। ");
INSERT INTO ory_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ପୁଣି, ବିଡ଼ାଏ ଏସୋବ ଘେନି ପାତ୍ରସ୍ଥିତ ରକ୍ତରେ ବୁଡ଼ାଇ ଦ୍ୱାରର କପାଳୀ ଓ ଦୁଇ ବାଜୁବନ୍ଧ ଉପରେ ପାତ୍ରସ୍ଥିତ ରକ୍ତ ଲଗାଅ; ପୁଣି, ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭମାନଙ୍କର କେହି ଗୃହ ଦ୍ୱାରରେ ବାହାରକୁ ନ ଯାଉ। ");
INSERT INTO ory_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ଯେହେତୁ ସଦାପ୍ରଭୁ ମିସରୀୟମାନଙ୍କୁ ଆଘାତ କରିବାକୁ ସେମାନଙ୍କ ମଧ୍ୟଦେଇ ଯିବେ; ତହିଁରେ ଦ୍ୱାରର କପାଳୀ ଓ ଦୁଇ ବାଜୁବନ୍ଧ ଉପରେ ସେହି ରକ୍ତ ଦେଖିଲେ, ସଦାପ୍ରଭୁ ସେହି ଦ୍ୱାର ଛାଡ଼ି ଆଗକୁ ଯିବେ, ତୁମ୍ଭମାନଙ୍କ ଗୃହରେ ସଂହାରକକୁ ପ୍ରବେଶ କରି ଆଘାତ କରିବାକୁ ଦେବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ପୁଣି, ତୁମ୍ଭେମାନେ ଓ ଯୁଗାନୁକ୍ରମେ ତୁମ୍ଭମାନଙ୍କ ସନ୍ତାନମାନେ ବିଧିମତେ ଏହି ରୀତି ପାଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ଆଉ ସଦାପ୍ରଭୁ ଆପଣା ପ୍ରତିଜ୍ଞାନୁସାରେ; ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବେ, ସେଠାରେ ପ୍ରବେଶ କଲେ, ଏହି ସେବା ସାଧନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ପୁଣି, ତୁମ୍ଭମାନଙ୍କ ‘ଏହି ସେବାର ଅଭିପ୍ରାୟ କଅଣ?’ ");
INSERT INTO ory_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ଏହା ତୁମ୍ଭମାନଙ୍କ ସନ୍ତାନମାନେ ପଚାରିଲେ, ‘ତୁମ୍ଭେମାନେ କହିବ, ଏହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ନିସ୍ତାରପର୍ବୀୟ ବଳିଦାନ; କାରଣ ମିସରୀୟମାନଙ୍କୁ ଆଘାତ କରିବା ବେଳେ ସେ ମିସରରେ ପ୍ରବାସୀ ଇସ୍ରାଏଲୀୟ ସନ୍ତାନଗଣର ଗୃହସବୁ ଛାଡ଼ି ଆଗକୁ ଯାଇ ଆମ୍ଭମାନଙ୍କ ଗୃହ ରକ୍ଷା କରିଥିଲେ।’” ସେତେବେଳେ ଲୋକମାନେ ମସ୍ତକ ନତ କରି ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ତହୁଁ ଇସ୍ରାଏଲୀୟ ସନ୍ତାନମାନେ ଯାଇ ସେପରି କଲେ; ଆଉ ସେମାନେ ମୋଶା ଓ ହାରୋଣଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ଏଥିଉତ୍ତାରେ ଅର୍ଦ୍ଧ ରାତ୍ର ସମୟରେ ସଦାପ୍ରଭୁ ସିଂହାସନୋପବିଷ୍ଟ ଫାରୋଙ୍କର ପ୍ରଥମଜାତ ସନ୍ତାନଠାରୁ କାରାକୂପସ୍ଥ ବନ୍ଦୀର ପ୍ରଥମଜାତ ସନ୍ତାନ ପର୍ଯ୍ୟନ୍ତ ମିସର ଦେଶସ୍ଥିତ ସମସ୍ତ ପ୍ରଥମଜାତ ସନ୍ତାନମାନଙ୍କୁ ଓ ପଶୁମାନଙ୍କ ପ୍ରଥମଜାତ ଶାବକଗଣକୁ ଆଘାତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ତହିଁରେ ଫାରୋ ଓ ତାଙ୍କର ଦାସଗଣ ଓ ମିସରୀୟ ଲୋକ ସମସ୍ତେ ରାତ୍ରିରେ ଉଠିଲେ; ପୁଣି, ମିସର ଦେଶରେ ମହାରୋଦନ ହେଲା; କାରଣ ଏପରି ଗୃହ ନ ଥିଲା ଯେଉଁ ଗୃହରେ କେହି ମରି ନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ତହୁଁ ରାତ୍ରିକାଳରେ ଫାରୋ, ମୋଶା ଓ ହାରୋଣଙ୍କୁ ଡକାଇ କହିଲେ, “ତୁମ୍ଭେମାନେ ଓ ଇସ୍ରାଏଲ ବଂଶ ଉଠି ଆମ୍ଭ ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ବାହାର ହୁଅ, ତୁମ୍ଭମାନଙ୍କ ବାକ୍ୟାନୁସାରେ ସଦାପ୍ରଭୁଙ୍କର ସେବା କରିବା ପାଇଁ ଯାତ୍ରା କର। ");
INSERT INTO ory_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ତୁମ୍ଭମାନଙ୍କ ବାକ୍ୟାନୁସାରେ ଗୋମେଷାଦି ପଲ ସମସ୍ତଙ୍କୁ ନେଇ ଚାଲିଯାଅ ଓ ଆମ୍ଭକୁ ମଧ୍ୟ ଆଶୀର୍ବାଦ କର।” ");
INSERT INTO ory_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ସେତେବେଳେ ମିସରୀୟମାନେ ଲୋକମାନଙ୍କୁ ଶୀଘ୍ର ଦେଶରୁ ପଠାଇଦେବା ନିମନ୍ତେ ବ୍ୟଗ୍ର ହେଲେ; କାରଣ ସେମାନେ କହିଲେ, “ଆମ୍ଭେ ସମସ୍ତେ ମୃତକଳ୍ପ।” ");
INSERT INTO ory_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ତହିଁରେ ଚକଟା ମଇଦା ତାଡ଼ି ମିଶ୍ରିତ ହେବା ପୂର୍ବେ, ଲୋକମାନେ ତାହା ନେଇ ମଇଦା ଦଳିବା ପାତ୍ରସବୁ ଆପଣା ଆପଣା ବସ୍ତ୍ରରେ ବାନ୍ଧି ସ୍କନ୍ଧରେ ଘେନିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମୋଶାଙ୍କର ବାକ୍ୟାନୁସାରେ ମିସରୀୟମାନଙ୍କୁ ରୌପ୍ୟ-ଅଳଙ୍କାର, ସୁବର୍ଣ୍ଣ-ଅଳଙ୍କାର ଓ ବସ୍ତ୍ର ମାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ତହିଁରେ ସଦାପ୍ରଭୁ ମିସରୀୟମାନଙ୍କ ଦୃଷ୍ଟିରେ ଲୋକମାନଙ୍କୁ ଅନୁଗ୍ରହପାତ୍ର କରିବାରୁ ସେମାନେ ସେମାନଙ୍କୁ ଯାହା ମାଗିଲେ, ସେମାନେ ତାହା ଦେଲେ। ଏହି ପ୍ରକାରେ, ସେମାନେ ମିସରୀୟମାନଙ୍କ ଧନ ହରଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ ସନ୍ତାନମାନେ ବାଳକ ବ୍ୟତୀତ ପ୍ରାୟ ଛଅ ଲକ୍ଷ ପୁରୁଷ ପାଦଗତିରେ ରାମିଷେଷ୍‍ଠାରୁ ସୁକ୍କୋତକୁ ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ପୁଣି, ମିଶ୍ରିତ ଲୋକମାନଙ୍କର ଏକ ମହାଜନତା ଓ ଗୋମେଷାଦି ଅନେକ ଅନେକ ପଶୁ ସେମାନଙ୍କ ସହିତ ପ୍ରସ୍ଥାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ଏଥିଉତ୍ତାରେ ସେମାନେ ମିସରଠାରୁ ଆନୀତ ଚକଟା ମଇଦାରେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ପ୍ରସ୍ତୁତ କଲେ; କାରଣ ତାହା ତାଡ଼ି ମିଶ୍ରିତ ହୋଇ ନ ଥିଲା; ଯେହେତୁ ସେମାନେ ମିସରରୁ ତାଡ଼ିତ ହୋଇଥିଲେ, ଏଥିପାଇଁ ବିଳମ୍ବ କରି ନ ପାରିବାରୁ ଆପଣା ଆପଣା ନିମନ୍ତେ କିଛି ଖାଦ୍ୟ ପ୍ରସ୍ତୁତ କରିପାରି ନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ଇସ୍ରାଏଲ ବଂଶ ଚାରି ଶହ ତିରିଶ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ମିସର ଦେଶରେ ପ୍ରବାସ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ସେହି ଚାରି ଶହ ତିରିଶ ବର୍ଷ ଶେଷରେ, ସେହି ଦିନରେ ସଦାପ୍ରଭୁଙ୍କ ସୈନ୍ୟସମୂହ ମିସରରୁ ବାହାର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ମିସର ଦେଶରୁ ସେମାନେ ବାହାର ହେବା ସକାଶୁ ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅତ୍ୟନ୍ତ ପାଳନୀୟ ରାତ୍ରି; ତାହା ସଦାପ୍ରଭୁଙ୍କ ରାତ୍ରି ବୋଲି ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ବିଶେଷ ପାଳନୀୟ ଅଟଇ। ");
INSERT INTO ory_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ଆଉ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, “ନିସ୍ତାର ପର୍ବର ଏହି ବିଧି; କୌଣସି ବିଦେଶୀୟ ଲୋକ ତାହା ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ମାତ୍ର ରୌପ୍ୟ ଦ୍ୱାରା କ୍ରୀତ ପ୍ରତ୍ୟେକ ଲୋକର ଦାସ ସୁନ୍ନତ ହେଲେ ଖାଇ ପାରିବ; ");
INSERT INTO ory_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","କୌଣସି ପ୍ରବାସୀ ବା ବେତନଜୀବୀ ଦାସ ତାହା ଖାଇ ପାରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ଏକ ଗୃହ ମଧ୍ୟରେ ତାହା ଭୋଜନ କରାଯିବ; ତୁମ୍ଭେ ସେହି ମାଂସର କିଛିମାତ୍ର ଗୃହ ବାହାରକୁ ନେଇଯିବ ନାହିଁ; କିଅବା ତାହାର ଗୋଟିଏ ଅସ୍ଥି ହିଁ ଭାଙ୍ଗିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ଇସ୍ରାଏଲର ସମଗ୍ର ମଣ୍ଡଳୀ ତାହା ପାଳନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ପୁଣି, ତୁମ୍ଭ ସଙ୍ଗରେ ପ୍ରବାସୀ କୌଣସି ବିଦେଶୀ ଲୋକ ଯଦି ସଦାପ୍ରଭୁଙ୍କର ନିସ୍ତାର ପର୍ବ ପାଳନ କରିବାକୁ ଚାହେଁ, ତେବେ ତାହାର ପରିବାରର ସମସ୍ତ ପୁରୁଷ ସୁନ୍ନତ ହେଉନ୍ତୁ, ତହିଁ ଉତ୍ତାରେ ସେ ନିକଟକୁ ଆସି ପର୍ବ ପାଳନ କରୁ; ତହିଁରେ ସେ ଦେଶଜାତ ଲୋକ ତୁଲ୍ୟ ହେବ; ମାତ୍ର କୌଣସି ଅସୁନ୍ନତ ଲୋକ ତାହା ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ଆଉ ଦେଶଜାତ ଲୋକ ଓ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ ବିଦେଶୀୟ ଲୋକ ପ୍ରତି ଗୋଟିଏ ବିଧି ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ତହିଁରେ ଇସ୍ରାଏଲର ସମସ୍ତ ସନ୍ତାନ ଏହି ପ୍ରକାର କଲେ; ମୋଶା ଓ ହାରୋଣଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞା ଯେପରି ଥିଲା, ସେହିପରି ସେମାନେ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ଏହି ପ୍ରକାରେ ସଦାପ୍ରଭୁ ସେହି ଦିନ ସୈନ୍ୟଶ୍ରେଣୀବଦ୍ଧ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ମଧ୍ୟରେ ମନୁଷ୍ୟ ହେଉ କି ପଶୁ ହେଉ, ଯେକେହି ପ୍ରଥମେ ଜାତ ହୁଏ, ସେହି ପ୍ରଥମଜାତ ସମସ୍ତଙ୍କୁ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ପ୍ରତିଷ୍ଠା କର; ତାହା ଆମ୍ଭର ଅଟେ।” ");
INSERT INTO ory_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ଏଥିଉତ୍ତାରେ ମୋଶା ଲୋକମାନଙ୍କୁ କହିଲେ, “ଏହି ଦିନ ସ୍ମରଣରେ ରଖ, ଯେହେତୁ ଏହି ଦିନରେ ତୁମ୍ଭେମାନେ ଦାସଗୃହ ସ୍ୱରୂପ ମିସରରୁ ବାହାର ହେଲ, ଆଉ ସଦାପ୍ରଭୁ ବାହୁ ବଳ ଦ୍ୱାରା ସେଠାରୁ ତୁମ୍ଭମାନଙ୍କୁ ବାହାର କରି ଆଣିଲେ; ଏଥିରେ ତାଡ଼ି ମିଶ୍ରିତ ରୁଟି ଭୋଜନ କରାଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ତୁମ୍ଭେମାନେ ଆବୀବ୍‍ ମାସର ଏହି ଦିନରେ ବାହାର ହେଲ। ");
INSERT INTO ory_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ଆଉ କିଣାନୀୟ, ହିତ୍ତୀୟ, ଇମୋରୀୟ, ହିବ୍ବୀୟ ଓ ଯିବୂଷୀୟ ଲୋକମାନଙ୍କର ଯେଉଁ ଦେଶ ତୁମ୍ଭଙ୍କୁ ଦେବାକୁ ସଦାପ୍ରଭୁ ତୁମ୍ଭ ପୂର୍ବପୁରୁଷମାନଙ୍କ ନିକଟରେ ଶପଥ କରିଥିଲେ, ସେହି ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଦେଶକୁ ଯେତେବେଳେ ସେ ତୁମ୍ଭଙ୍କୁ ଆଣିବେ, ସେହି ସମୟରେ ତୁମ୍ଭେ ଏହି ମାସରେ ଏହି ସେବାର କାର୍ଯ୍ୟ ସାଧନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ସପ୍ତାହ ପର୍ଯ୍ୟନ୍ତ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଖାଇବ ଓ ସପ୍ତମ ଦିନରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସବ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ପୁଣି, ସେହି ସପ୍ତାହ ପର୍ଯ୍ୟନ୍ତ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଭୋଜନ କରାଯିବ ଓ ତୁମ୍ଭ ନିକଟରେ ତାଡ଼ି ମିଶ୍ରିତ ରୁଟି ଦେଖାଯିବ ନାହିଁ, ଆଉ ତୁମ୍ଭର ସମୁଦାୟ ଦେଶ ମଧ୍ୟରେ ତାଡ଼ି ଦୃଷ୍ଟ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ପୁଣି, ସେହି ଦିନ ତୁମ୍ଭେ ଆପଣା ପୁତ୍ରକୁ କହିବ, ‘ମିସରଠାରୁ ଆମ୍ଭେ ବାହାର ହେବା ବେଳେ ସଦାପ୍ରଭୁ ଆମ୍ଭ ପ୍ରତି ଯେଉଁ ଯେଉଁ କର୍ମ କରିଥିଲେ, ସେହିସବୁର ସ୍ମରଣ ନିମନ୍ତେ ଏହା ହୁଏ।’ ");
INSERT INTO ory_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ବ୍ୟବସ୍ଥା ଯେପରି ତୁମ୍ଭ ମୁଖରେ ରହିବ, ଏଥିପାଇଁ ଏହା ଚିହ୍ନ ସ୍ୱରୂପେ ତୁମ୍ଭ ହସ୍ତରେ ଓ ସ୍ମରଣର ଉପାୟ ସ୍ୱରୂପ ତୁମ୍ଭ ଚକ୍ଷୁ ଦ୍ୱୟର ମଧ୍ୟସ୍ଥାନରେ ରହିବ; ଯେହେତୁ ସଦାପ୍ରଭୁ ପରାକ୍ରାନ୍ତ ହସ୍ତ ଦ୍ୱାରା ମିସରଠାରୁ ତୁମ୍ଭଙ୍କୁ ବାହାର କରି ଆଣିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ଏହେତୁ ସମୟାନୁସାରେ ତୁମ୍ଭେ ପ୍ରତି ବର୍ଷ ଏହି ବିଧି ପାଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","ସଦାପ୍ରଭୁ ତୁମ୍ଭ ଓ ତୁମ୍ଭ ପୂର୍ବପୁରୁଷମାନଙ୍କ ନିକଟରେ ଯେଉଁ ଶପଥ କରିଅଛନ୍ତି, ତଦନୁସାରେ ସେ ଯେତେବେଳେ କିଣାନୀୟ ଲୋକମାନଙ୍କର ଦେଶରେ ପ୍ରବେଶ କରାଇ ତୁମ୍ଭଙ୍କୁ ତାହା ଦେବେ; ");
INSERT INTO ory_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ସେତେବେଳେ ତୁମ୍ଭେ ପ୍ରଥମଜାତ ସମସ୍ତ ଗର୍ଭଫଳ ଓ ତୁମ୍ଭ ପଶୁଠାରୁ ଜାତ ପ୍ରତ୍ୟେକ ପ୍ରଥମ ଗର୍ଭଫଳ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପୃଥକ କରିବ; ପୁଂସନ୍ତାନ ସକଳ ସଦାପ୍ରଭୁଙ୍କର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ପୁଣି, ତୁମ୍ଭେ ମେଷଶାବକ ଦେଇ ପ୍ରତ୍ୟେକ ପ୍ରଥମଜାତ ଗର୍ଦ୍ଦଭକୁ ମୁକ୍ତ କରିବ; ଯଦି ମୁକ୍ତ ନ କରିବ, ତେବେ ତାʼର ବେକ ଭାଙ୍ଗିବ; ମାତ୍ର ତୁମ୍ଭ ପୁତ୍ରମାନଙ୍କ ମଧ୍ୟରୁ ମନୁଷ୍ୟର ପ୍ରଥମଜାତ ସମସ୍ତଙ୍କୁ ମୁକ୍ତ କରିବାକୁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ଆଉ ଭବିଷ୍ୟତ କାଳରେ ତୁମ୍ଭର ପୁତ୍ର ଯଦି ପଚାରିବ, ‘ଏହା କଅଣ?’ ତେବେ ତୁମ୍ଭେ କହିବ, ‘ସଦାପ୍ରଭୁ ଯେତେବେଳେ ଆମ୍ଭମାନଙ୍କୁ ଆପଣା ବାହୁ ବଳ ଦ୍ୱାରା ଦାସଗୃହ ସ୍ୱରୂପ ମିସରଠାରୁ ବାହାର କଲେ, ");
INSERT INTO ory_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ସେତେବେଳେ ଫାରୋ ଆମ୍ଭମାନଙ୍କୁ ଯିବାକୁ ଦେବା ପାଇଁ କଠିନ ହୁଅନ୍ତେ, ସଦାପ୍ରଭୁ ମିସର ଦେଶସ୍ଥିତ ମନୁଷ୍ୟ ଓ ପଶ୍ୱାଦିର ସମସ୍ତ ପ୍ରଥମଜାତ ସନ୍ତାନମାନଙ୍କୁ ବଧ କରିଥିଲେ; ଏହେତୁ ଆମ୍ଭେ ପ୍ରଥମଜାତ ପୁତ୍ରସନ୍ତାନମାନଙ୍କୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳିଦାନ କରୁ; ମାତ୍ର ଆମ୍ଭର ପ୍ରଥମଜାତ ପୁତ୍ର ସମସ୍ତଙ୍କୁ ମୁକ୍ତ କରୁ।’ ");
INSERT INTO ory_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ଏହା ଚିହ୍ନ ସ୍ୱରୂପେ ତୁମ୍ଭ ହସ୍ତରେ ଓ ଭୂଷଣ ସ୍ୱରୂପେ ତୁମ୍ଭ ଚକ୍ଷୁ ଦ୍ୱୟର ମଧ୍ୟସ୍ଥାନରେ ରହିବ; ଯେହେତୁ ସଦାପ୍ରଭୁ ବାହୁ ବଳରେ ଆମ୍ଭମାନଙ୍କୁ ମିସରରୁ ବାହାର କରି ଆଣିଲେ।” ");
INSERT INTO ory_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ଏଥିଉତ୍ତାରେ ଫାରୋ ଲୋକମାନଙ୍କୁ ଯିବାକୁ ଦିଅନ୍ତେ, ପଲେଷ୍ଟୀୟ ଲୋକମାନଙ୍କର ଦେଶକୁ ଯିବାର ପଥ ନିକଟ ହେଲେ ହେଁ ପରମେଶ୍ୱର ସେହି ପଥରେ ସେମାନଙ୍କୁ ଗମନ କରାଇଲେ ନାହିଁ; ଯେହେତୁ ପରମେଶ୍ୱର କହିଲେ, “ଯେବେ ଲୋକମାନେ ଯୁଦ୍ଧ ଦେଖନ୍ତି ସେମାନେ ଆପଣା ଆପଣାର ମନକୁ ବଦଳାଇ ମିସରକୁ ଫେରିଯାଇ ପାରନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ଏହେତୁ ପରମେଶ୍ୱର ସେମାନଙ୍କୁ ସୂଫ ସାଗରର ପ୍ରାନ୍ତରଗାମୀ ବକ୍ର ପଥରେ ଗମନ କରାଇଲେ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସସଜ୍ଜ ହୋଇ ମିସରଠାରୁ ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ପୁଣି, ମୋଶା ଯୋଷେଫଙ୍କର ଅସ୍ଥି ଆପଣା ସଙ୍ଗେ ନେଲେ; କାରଣ ସେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଦୃଢ଼ ଶପଥ କରାଇ କହିଥିଲେ, “ପରମେଶ୍ୱର ଅବଶ୍ୟ ତୁମ୍ଭମାନଙ୍କର ତତ୍ତ୍ୱାବଧାନ କରିବେ; ସେସମୟରେ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ସହିତ ଆମ୍ଭର ଅସ୍ଥି ଏହି ସ୍ଥାନରୁ ନେଇଯିବ।” ");
INSERT INTO ory_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ଏଥିଉତ୍ତାରେ ସେମାନେ ସୁକ୍କୋତଠାରୁ ଯାତ୍ରା କରି ପ୍ରାନ୍ତର-ଧାରସ୍ଥିତ ଏଥମରେ ଛାଉଣି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ସେମାନେ ଯେପରି ଦିବସରେ ଓ ରାତ୍ରିରେ ଯାତ୍ରା କରି ପାରିବେ, ଏଥିପାଇଁ ସଦାପ୍ରଭୁ ଦିବସରେ ପଥ କଢ଼ାଇବା ନିମନ୍ତେ ମେଘ ସ୍ତମ୍ଭରେ ଓ ରାତ୍ରିରେ ଦୀପ୍ତି ଦେବା ନିମନ୍ତେ ଅଗ୍ନିସ୍ତମ୍ଭରେ ଥାଇ ସେମାନଙ୍କ ଆଗେ ଆଗେ ଯାତ୍ରା କଲେ; ");
INSERT INTO ory_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ସେ ଲୋକମାନଙ୍କ ସମ୍ମୁଖରୁ ଦିବସରେ ମେଘସ୍ତମ୍ଭ ଓ ରାତ୍ରିରେ ଅଗ୍ନିସ୍ତମ୍ଭ ସ୍ଥାନାନ୍ତର କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ତୁମ୍ଭେମାନେ ଫେରି ପୀହହୀରୋତର ପୂର୍ବ ଦିଗରେ ମିଗ୍‍ଦୋଲ ଓ ସମୁଦ୍ର ମଧ୍ୟରେ ଛାଉଣି ସ୍ଥାପନ କର; ତୁମ୍ଭେମାନେ ବାଲ-ସଫୋନ ଆଗରେ, ଅର୍ଥାତ୍‍, ତାହାର ସମ୍ମୁଖରେ ସମୁଦ୍ର ନିକଟରେ ଛାଉଣି ସ୍ଥାପନ କର। ");
INSERT INTO ory_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ତହିଁରେ ଫାରୋ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ବିଷୟରେ କହିବ, ‘ସେମାନେ ଦେଶ ମଧ୍ୟରେ ଧନ୍ଦଳା ହୋଇ ରହିଅଛନ୍ତି ଓ ପ୍ରାନ୍ତର ସେମାନଙ୍କ ପଥ ରୁଦ୍ଧ କରିଅଛି।’ ");
INSERT INTO ory_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ଆଉ, ଆମ୍ଭେ ଫାରୋର ହୃଦୟ କଠିନ କରିବା, ତହିଁରେ ସେ ସେମାନଙ୍କ ପଛେ ପଛେ ଦୌଡ଼ିବ; ପୁଣି, ଆମ୍ଭେ ଫାରୋ ଓ ତାହାର ସକଳ ସୈନ୍ୟ ଦ୍ୱାରା ସମ୍ଭ୍ରମ ପାଇବା; ତହିଁରେ ଆମ୍ଭେ ଯେ ସଦାପ୍ରଭୁ, ଏହା ମିସରୀୟ ଲୋକମାନେ ଜାଣିବେ।” ତହୁଁ ସେମାନେ ସେହିପରି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ଏଥିଉତ୍ତାରେ ଲୋକମାନେ ପଳାଇଅଛନ୍ତି, ଏହି ସମ୍ବାଦ ମିସରୀୟ ରାଜାଙ୍କୁ ଜଣାଯାଆନ୍ତେ, ଲୋକମାନଙ୍କ ବିଷୟରେ ଫାରୋଙ୍କର ଓ ତାଙ୍କର ଦାସମାନଙ୍କ ଅନ୍ତଃକରଣ ପରିବର୍ତ୍ତିତ ହେଲା; ତହୁଁ ସେମାନେ କହିଲେ, “ଆମ୍ଭେମାନେ ଏ କି କର୍ମ କରିଅଛୁ? କାହିଁକି ଇସ୍ରାଏଲକୁ ଆପଣାମାନଙ୍କ ଦାସତ୍ୱରୁ ଛାଡ଼ି ଦେଇଅଛୁ?” ");
INSERT INTO ory_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ତହୁଁ ରାଜା ଆପଣା ରଥ ପ୍ରସ୍ତୁତ କରାଇଲେ ଓ ଆପଣା ଲୋକମାନଙ୍କୁ ସଙ୍ଗରେ ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ପୁଣି, ଛଅ ଶହ ବଛା ରଥ ଓ ମିସରୀୟମାନଙ୍କର ସମସ୍ତ ରଥ ଓ ପ୍ରତ୍ୟେକ ରଥରେ ଯୋଦ୍ଧାମାନଙ୍କୁ ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ଆଉ ସଦାପ୍ରଭୁ ମିସରୀୟ ରାଜା ଫାରୋଙ୍କର ହୃଦୟ କଠିନ କରନ୍ତେ, ସେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ପଛେ ପଛେ ଗୋଡ଼ାଇଲେ; ସେତେବେଳେ ଇସ୍ରାଏଲ ସନ୍ତାନମାନେ ଊର୍ଦ୍ଧ୍ୱ ହସ୍ତରେ ଯାତ୍ରା କରୁଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ତହୁଁ ମିସରୀୟମାନେ, ଅର୍ଥାତ୍‍, ଫାରୋଙ୍କର ସମସ୍ତ ଅଶ୍ୱ, ରଥ ଓ ଅଶ୍ୱାରୂଢ଼ ସୈନ୍ୟଗଣ ସେମାନଙ୍କ ପଛେ ପଛେ ଦୌଡ଼ି ବାଲ-ସଫୋନ ଅଗ୍ରତେ ପୀହହୀରୋତ ନିକଟରେ ସମୁଦ୍ର ତୀରରେ ସେମାନେ ଛାଉଣି କରିବା ସମୟରେ ସେମାନଙ୍କ ନିକଟରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ଆଉ ଫାରୋ ନିକଟବର୍ତ୍ତୀ ହୁଅନ୍ତେ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଅନାଇ ଆପଣାମାନଙ୍କ ପଶ୍ଚାତ୍‍ ପଶ୍ଚାତ୍‍ ଆଗମନକାରୀ ମିସରୀୟମାନଙ୍କୁ ଦେଖି ଅତିଶୟ ଭୀତ ହେଲେ, ପୁଣି, ଇସ୍ରାଏଲ ସନ୍ତାନମାନେ ସଦାପ୍ରଭୁଙ୍କୁ ଡାକ ପକାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ପୁଣି, ମୋଶାଙ୍କୁ କହିଲେ, “ମିସରରେ କବର ନ ଥିଲା ବୋଲି କି ପ୍ରାନ୍ତରରେ ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କୁ ମାରିବାକୁ ଆଣିଲ? ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଏରୂପ ବ୍ୟବହାର କରି ଆମ୍ଭମାନଙ୍କୁ ମିସରରୁ କାହିଁକି ବାହାର କରି ଆଣିଲ? ");
INSERT INTO ory_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ଆମ୍ଭମାନଙ୍କୁ ରହିବାକୁ ଦିଅ, ‘ଆମ୍ଭେମାନେ ମିସରୀୟମାନଙ୍କର ଦାସ୍ୟକର୍ମ କରିବା, କାରଣ ପ୍ରାନ୍ତରରେ ମରିବା ଅପେକ୍ଷା ମିସରୀୟମାନଙ୍କର ସେବା କରିବା ଆମ୍ଭମାନଙ୍କର ମଙ୍ଗଳ, ଆମ୍ଭେମାନେ କି ମିସରରେ ତୁମ୍ଭଙ୍କୁ ଏହି କଥା କହି ନ ଥିଲୁ?’” ");
INSERT INTO ory_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ତହୁଁ ମୋଶା ଲୋକମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଭୟ କର ନାହିଁ, ସୁସ୍ଥିର ହୁଅ; ସଦାପ୍ରଭୁ ଆଜି କିପରି ତୁମ୍ଭମାନଙ୍କୁ ଉଦ୍ଧାର କରିବେ, ତାହା ଦେଖ; ତୁମ୍ଭେମାନେ ଆଜି ଯେପରି ମିସରୀୟମାନଙ୍କୁ ଦେଖୁଅଛ, ସେପରି ଅନନ୍ତକାଳ ପର୍ଯ୍ୟନ୍ତ ଆଉ କେବେ ଦେଖିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଯୁଦ୍ଧ କରିବେ, ତୁମ୍ଭେମାନେ ନୀରବ ରହିବ।” ");
INSERT INTO ory_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭଙ୍କୁ କାହିଁକି ଡାକୁଅଛ? ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ସେମାନେ ଅଗ୍ରସର ହେଉନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ପୁଣି, ତୁମ୍ଭେ ଆପଣା ଯଷ୍ଟି ଉଠାଅ ଓ ସମୁଦ୍ର ଉପରେ ହସ୍ତ ବିସ୍ତାର କରି ତାହା ଦୁଇ ଭାଗ କର; ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଶୁଷ୍କ ପଥ ଦେଇ ସମୁଦ୍ର ମଧ୍ୟରେ ପ୍ରବେଶ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ପୁଣି, ଆମ୍ଭେ, ଦେଖ, ଆମ୍ଭେ ମିସରୀୟମାନଙ୍କ ହୃଦୟ କଠିନ କରନ୍ତେ, ସେମାନେ ସେମାନଙ୍କ ପଛେ ପଛେ ଯିବେ, ତହିଁରେ ଆମ୍ଭେ ଫାରୋ ଓ ତାହାର ସମସ୍ତ ସୈନ୍ୟ, ରଥ ଓ ଅଶ୍ୱାରୂଢ଼ ଲୋକମାନଙ୍କ ଦ୍ୱାରା ସମ୍ଭ୍ରମ ପ୍ରାପ୍ତ ହେବା। ");
INSERT INTO ory_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ଆଉ ଫାରୋ, ତାହାର ରଥ ଓ ତାହାର ଅଶ୍ୱାରୂଢ଼ ଲୋକମାନଙ୍କ ଦ୍ୱାରା ସମ୍ଭ୍ରମ ପ୍ରାପ୍ତ ହେଲା ଉତ୍ତାରେ ଆମ୍ଭେ ଯେ ସଦାପ୍ରଭୁ, ଏହା ମିସରୀୟ ଲୋକମାନେ ଜାଣିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ସେତେବେଳେ ଇସ୍ରାଏଲୀୟ ଦଳର ଅଗ୍ରଗାମୀ ପରମେଶ୍ୱରଙ୍କ ଦୂତ ସ୍ଥାନାନ୍ତର ହୋଇ ସେମାନଙ୍କର ପଶ୍ଚାଦ୍‍ଗାମୀ ହେଲେ, ପୁଣି, ମେଘସ୍ତମ୍ଭ ସେମାନଙ୍କ ସମ୍ମୁଖରୁ ସ୍ଥାନାନ୍ତର ହୋଇ ସେମାନଙ୍କ ପଛେ ଛିଡ଼ା ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ସେହି ମେଘସ୍ତମ୍ଭ ମିସରୀୟ ଦଳ ଓ ଇସ୍ରାଏଲୀୟ ଦଳ ମଧ୍ୟକୁ ଆସିଲା, ପୁଣି, ମେଘ ଓ ଅନ୍ଧକାର ହେଲେ ହେଁ ତାହା ରାତ୍ରିକୁ ଆଲୋକମୟ କଲା; ଏଥିପାଇଁ ସମସ୍ତ ରାତ୍ରି ଏକ ଦଳ ଅନ୍ୟ ଦଳ ନିକଟକୁ ଆସି ପାରିଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ଏଥିଉତ୍ତାରେ ମୋଶା ସମୁଦ୍ର ଉପରେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କରନ୍ତେ, ସଦାପ୍ରଭୁ ସେହି ସମସ୍ତ ରାତ୍ରି ପ୍ରବଳ ପୂର୍ବୀୟ ବାୟୁ ଦ୍ୱାରା ସମୁଦ୍ରକୁ ପଶ୍ଚାତ୍‍ ହଟାଇ ଶୁଷ୍କ କଲେ ଓ ଜଳ ଦୁଇ ଭାଗ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଶୁଷ୍କ ପଥ ଦେଇ ସମୁଦ୍ର ମଧ୍ୟରେ ଗମନ କଲେ, ପୁଣି, ସେମାନଙ୍କ ଦକ୍ଷିଣରେ ଓ ବାମରେ ଜଳ ପ୍ରାଚୀର ତୁଲ୍ୟ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ଏଥିଉତ୍ତାରେ ମିସରୀୟମାନେ, ଅର୍ଥାତ୍‍, ଫାରୋଙ୍କର ସମସ୍ତ ଅଶ୍ୱ, ରଥ, ଓ ଅଶ୍ୱାରୂଢ଼ ଲୋକ ସମସ୍ତେ ଦୌଡ଼ି ସେମାନଙ୍କ ପଛେ ପଛେ ସମୁଦ୍ରରେ ପ୍ରବେଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ମାତ୍ର ରାତ୍ରିର ଶେଷ ପ୍ରହରରେ ସଦାପ୍ରଭୁ ଅଗ୍ନି ଓ ମେଘସ୍ତମ୍ଭ ଦେଇ ମିସରୀୟମାନଙ୍କ ସୈନ୍ୟକୁ ଅନାଇଲେ ଓ ମିସରୀୟମାନଙ୍କ ସୈନ୍ୟକୁ ଅସ୍ତବ୍ୟସ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ସେ ସେମାନଙ୍କ ରଥର ଚକ୍ର ବାହାର କରି ପକାନ୍ତେ, ସେମାନେ ଅତି କଷ୍ଟରେ ରଥ ଚଳାଇଲେ; ତହିଁରେ ମିସରୀୟ ଲୋକମାନେ କହିଲେ, “ଆସ, ଆମ୍ଭେମାନେ ଇସ୍ରାଏଲ ସମ୍ମୁଖରୁ ପଳାଇ ଯାଉ; କାରଣ ସଦାପ୍ରଭୁ ସେମାନଙ୍କର ସପକ୍ଷ ହୋଇ ମିସରୀୟମାନଙ୍କ ବିରୁଦ୍ଧରେ ଯୁଦ୍ଧ କରୁଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ସମୁଦ୍ର ଉପରେ ଆପଣା ହସ୍ତ ବିସ୍ତାର କର; ତହିଁରେ ମିସରୀୟମାନଙ୍କ, ସେମାନଙ୍କ ରଥ ଓ ଅଶ୍ୱାରୂଢ଼ ଲୋକମାନଙ୍କ ଉପରେ ପୁନର୍ବାର ଜଳ ଆସିବ।” ");
INSERT INTO ory_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ତହୁଁ ମୋଶା ସମୁଦ୍ର ଉପରେ ହସ୍ତ ବିସ୍ତାର କଲେ, ଆଉ ପ୍ରଭାତ ସମୟକୁ ସମୁଦ୍ର ପୁନର୍ବାର ସମାନ ହେବାକୁ ଲାଗିଲା; ତହୁଁ ମିସରୀୟମାନେ ଉଜାଣି ପଳାୟନ କରନ୍ତେ, ସଦାପ୍ରଭୁ ସମୁଦ୍ର ମଧ୍ୟରେ ସେମାନଙ୍କୁ ନିକ୍ଷେପ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ପୁଣି, ଜଳ ପୁନର୍ବାର ଆସି ସେମାନଙ୍କ ରଥ ଓ ଅଶ୍ୱାରୂଢ଼ ଲୋକମାନଙ୍କୁ ଆଚ୍ଛାଦନ କଲା; ତହିଁରେ ଫାରୋଙ୍କର ଯେଉଁସବୁ ସୈନ୍ୟ ସେମାନଙ୍କ ପଛେ ପଛେ ସମୁଦ୍ର ମଧ୍ୟରେ ପ୍ରବେଶ କରିଥିଲେ, ସେମାନଙ୍କ ମଧ୍ୟରୁ ଜଣେ ମଧ୍ୟ ଅବଶିଷ୍ଟ ରହିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ମାତ୍ର ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଶୁଷ୍କ ପଥରେ ସମୁଦ୍ର ମଧ୍ୟଦେଇ ଗମନ କଲେ; ପୁଣି, ଜଳ ସେମାନଙ୍କ ବାମ ଓ ଦକ୍ଷିଣରେ ପ୍ରାଚୀର ତୁଲ୍ୟ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ଏହି ପ୍ରକାରେ ସେହି ଦିନ ସଦାପ୍ରଭୁ ମିସରୀୟମାନଙ୍କ ହସ୍ତରୁ ଇସ୍ରାଏଲଙ୍କୁ ରକ୍ଷା କଲେ ଓ ଇସ୍ରାଏଲ ମିସରୀୟମାନଙ୍କୁ ସମୁଦ୍ର ତୀରରେ ମୃତ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ସଦାପ୍ରଭୁ ମିସରୀୟମାନଙ୍କ ବିରୁଦ୍ଧରେ ଏହି ଯେଉଁ ମହତ୍ କର୍ମ କଲେ, ତାହା ଇସ୍ରାଏଲ ଦେଖିଲେ; ତହିଁରେ ଲୋକମାନେ ସଦାପ୍ରଭୁଙ୍କୁ ଭୟ କରି ସଦାପ୍ରଭୁଙ୍କଠାରେ ଓ ତାହାଙ୍କ ଦାସ ମୋଶାଙ୍କଠାରେ ବିଶ୍ୱାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ସେତେବେଳେ ମୋଶା ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଏହି ଗୀତ ଗାନ କଲେ, ଯଥା, “ଆମ୍ଭେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଗାନ କରିବା, କାରଣ ସେ ଅତିଶୟ ଉନ୍ନତ ହୋଇଅଛନ୍ତି; ସେ ଅଶ୍ୱ ଓ ଅଶ୍ୱାରୋହୀଙ୍କୁ ସମୁଦ୍ରରେ ନିକ୍ଷେପ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ସଦାପ୍ରଭୁ ଆମ୍ଭର ବଳ ଓ ଗାନ, ପୁଣି, ସେ ଆମ୍ଭର ପରିତ୍ରାଣ ହୋଇଅଛନ୍ତି; ସେ ଆମ୍ଭର ପରମେଶ୍ୱର, ଆମ୍ଭେ ତାହାଙ୍କର ପ୍ରଶଂସା କରିବା; ସେ ଆମ୍ଭର ପୈତୃକ ପରମେଶ୍ୱର, ଆମ୍ଭେ ତାହାଙ୍କର ଗୁଣାନୁବାଦ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ସଦାପ୍ରଭୁ ଯୁଦ୍ଧବୀର; ସଦାପ୍ରଭୁ ତାହାଙ୍କର ନାମ। ");
INSERT INTO ory_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ସେ ଫାରୋଙ୍କର ରଥ ଓ ସୈନ୍ୟଗଣକୁ ସମୁଦ୍ରରେ ନିକ୍ଷେପ କରିଅଛନ୍ତି; ପୁଣି, ତାଙ୍କର ବଛା ବୀରମାନେ ସୂଫ ସାଗରରେ ନିମଗ୍ନ ହୋଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ଗଭୀର ଜଳ ସେମାନଙ୍କୁ ଆଚ୍ଛାଦନ କରିଅଛି, ସେମାନେ ପ୍ରସ୍ତର ତୁଲ୍ୟ ଅଗାଧ ଜଳରେ ବୁଡ଼ିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ହେ ସଦାପ୍ରଭୁ, ତୁମ୍ଭର ଦକ୍ଷିଣ ହସ୍ତ ବଳରେ ଗୌରବାନ୍ୱିତ; ହେ ସଦାପ୍ରଭୁ, ତୁମ୍ଭର ଦକ୍ଷିଣ ହସ୍ତ ଶତ୍ରୁକୁ ଚୂର୍ଣ୍ଣ କରେ, ");
INSERT INTO ory_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ତୁମ୍ଭେ ଆପଣା ଉତ୍କୃଷ୍ଟ ମହିମାରେ ଆପଣା ପ୍ରତିକୂଳାଚାରୀମାନଙ୍କୁ ନିପାତ କରିଥାଅ; ତୁମ୍ଭେ ଆପଣା କ୍ରୋଧାଗ୍ନି ପଠାଅ, ତାହା ସେମାନଙ୍କୁ ନଡ଼ା ପରି ଗ୍ରାସ କରେ। ");
INSERT INTO ory_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ତୁମ୍ଭ ନାସିକାର ନିଃଶ୍ୱାସ ଦ୍ୱାରା ଜଳ ରାଶୀକୃତ ହେଲା; ସ୍ରୋତସକଳ ସେତୁ ପରି ଛିଡ଼ା ହୋଇ ରହିଲା; ସମୁଦ୍ର ମଧ୍ୟସ୍ଥଳରେ ଗଭୀର ଜଳ ଜମାଟ ହୋଇଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ଶତ୍ରୁ କହିଲା: ‘ଆମ୍ଭେ ପଛେ ପଛେ ଗୋଡ଼ାଇବା, ଆମ୍ଭେ ସେମାନଙ୍କୁ ଧରିବା, ଆମ୍ଭେ ଲୁଟିତ ଦ୍ରବ୍ୟ ବିଭାଗ କରି ନେବା; ସେମାନଙ୍କ ଉପରେ ଆମ୍ଭର ଅଭିଳାଷ ପୂର୍ଣ୍ଣ ହେବ; ଆମ୍ଭେ ଆପଣା ଖଡ୍ଗ ନିଷ୍କୋଷ କରିବା, ଆମ୍ଭର ହସ୍ତ ସେମାନଙ୍କୁ ବିନାଶ କରିବ।’ ");
INSERT INTO ory_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ମାତ୍ର ତୁମ୍ଭେ ଆପଣା ନିଃଶ୍ୱାସ ଦ୍ୱାରା ଫୁଙ୍କି ଦେଲ, ସମୁଦ୍ର ସେମାନଙ୍କୁ ଆଚ୍ଛାଦନ କଲା, ସେମାନେ ସୀସା ପରି ଗଭୀର ଜଳରେ ବୁଡ଼ିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ହେ ସଦାପ୍ରଭୁ, ଦେବଗଣ ମଧ୍ୟରେ ତୁମ୍ଭ ତୁଲ୍ୟ କିଏ? ତୁମ୍ଭ ସମାନ ପବିତ୍ରତାରେ ଆଦରଣୀୟ, ପ୍ରଶଂସାରେ ଭୟାନକ ଓ ଆଶ୍ଚର୍ଯ୍ୟକ୍ରିୟାକାରୀ କିଏ? ");
INSERT INTO ory_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ତୁମ୍ଭେ ଆପଣା ଦକ୍ଷିଣ ହସ୍ତ ବିସ୍ତାର କଲ, ପୃଥିବୀ ସେମାନଙ୍କୁ ଗ୍ରାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ତୁମ୍ଭେ ଆପଣା ଦୟାରେ ନିଜ ମୁକ୍ତ ଲୋକମାନଙ୍କୁ ଗମନ କରାଉଅଛ, ତୁମ୍ଭେ ଆପଣା ପରାକ୍ରମରେ ସେମାନଙ୍କୁ ପଥ କଢ଼ାଇ ତୁମ୍ଭ ପବିତ୍ର ନିବାସ ସ୍ଥାନକୁ ନେଇ ଯାଉଅଛ। ");
INSERT INTO ory_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ଲୋକମାନେ ଏହା ଶୁଣିଅଛନ୍ତି, ସେମାନେ କମ୍ପୁଅଛନ୍ତି; ବେଦନା ପଲେଷ୍ଟୀୟ ନିବାସୀମାନଙ୍କୁ ଆକ୍ରାନ୍ତ କରିଅଛି। ");
INSERT INTO ory_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ସେତେବେଳେ ଇଦୋମର ରାଜଗଣ ବିହ୍ୱଳ ହେଲେ; କମ୍ପ ମୋୟାବର ବଳବାନ ଲୋକଙ୍କୁ ଆକ୍ରମଣ କରୁଅଛି; କିଣାନ ନିବାସୀ ସମସ୍ତେ ତରଳି ଯାଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ତ୍ରାସ ଓ ଆଶଙ୍କା ସେମାନଙ୍କ ଉପରେ ପଡ଼ୁଅଛି; ହେ ସଦାପ୍ରଭୁ, ଯେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭ ଲୋକମାନେ ଚାଲିଯାଇ ନାହାନ୍ତି, ଯେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭ କ୍ରୀତ ଲୋକମାନେ ଚାଲିଯାଇ ନାହାନ୍ତି, ସେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭ ବାହୁ ବଳ ଦ୍ୱାରା ସେମାନେ ପ୍ରସ୍ତର ନ୍ୟାୟ ସ୍ତବ୍ଧ ହୋଇ ରହିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ହେ ସଦାପ୍ରଭୁ, ତୁମ୍ଭେ ଆପଣା ନିବାସ ନିମନ୍ତେ ଯେଉଁ ସ୍ଥାନ ପ୍ରସ୍ତୁତ କରିଅଛ, ପ୍ରଭୁ, ତୁମ୍ଭର ହସ୍ତ ଯେଉଁ ଧର୍ମଧାମ ସ୍ଥାପନ କରିଅଛି, ତୁମ୍ଭେ ସେମାନଙ୍କୁ ଆଣି ଆପଣାର ସେହି ଅଧିକାର-ପର୍ବତରେ ରୋପଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ସଦାପ୍ରଭୁ ଯୁଗାନୁକ୍ରମେ ଅନନ୍ତକାଳ ରାଜତ୍ୱ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","କାରଣ ଫାରୋଙ୍କର ଅଶ୍ୱ, ରଥ ଓ ଅଶ୍ୱାରୂଢ଼ ଲୋକମାନେ ସମୁଦ୍ର ମଧ୍ୟରେ ପ୍ରବେଶ କରନ୍ତେ, ସଦାପ୍ରଭୁ ସେମାନଙ୍କ ଉପରେ ପୁନର୍ବାର ସମୁଦ୍ର ଜଳ ଆଣିଲେ; ମାତ୍ର ଇସ୍ରାଏଲ ସନ୍ତାନମାନେ ଶୁଷ୍କ ପଥ ଦେଇ ସମୁଦ୍ର ମଧ୍ୟରେ ଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ଏଥିଉତ୍ତାରେ ହାରୋଣଙ୍କର ଭଗିନୀ ଭବିଷ୍ୟଦ୍‍ବକ୍ତ୍ରୀ ମରୀୟମ ହସ୍ତରେ ଦାରା ନେଲେ ଓ ତାଙ୍କର ପଛେ ପଛେ ଅନ୍ୟ ସ୍ତ୍ରୀସକଳ ଦାରା ନେଇ ନୃତ୍ୟ କରୁ କରୁ ବାହାର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ସେତେବେଳେ ମରୀୟମ ଲୋକମାନଙ୍କୁ ଉତ୍ତର କଲେ, “ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଗାୟନ କର; କାରଣ ସେ ଅତିଶୟ ଉନ୍ନତ ହୋଇଅଛନ୍ତି; ସେ ଅଶ୍ୱ ଓ ଅଶ୍ୱାରୂଢ଼ ଲୋକମାନଙ୍କୁ ସମୁଦ୍ରରେ ନିକ୍ଷେପ କରିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ଏଥିଉତ୍ତାରେ ମୋଶା ଇସ୍ରାଏଲଙ୍କୁ ସୂଫ ସାଗରଠାରୁ ଯାତ୍ରା କରାଇଲେ, ପୁଣି, ସେମାନେ ଶୂର-ପ୍ରାନ୍ତର ଆଡ଼କୁ ଯାତ୍ରା କଲେ, ସେମାନେ ପ୍ରାନ୍ତରରେ ତିନି ଦିନ ଯାତ୍ରା କରି ଜଳ ପାଇଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ତହୁଁ ସେମାନେ ମାରାଠାରେ ଉପସ୍ଥିତ ହୁଅନ୍ତେ, ତିକ୍ତତା ହେତୁରୁ ମାରାର ଜଳ ପାନ କରି ପାରିଲେ ନାହିଁ; ଏଣୁ ତାହାର ନାମ ମାରା ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ସେତେବେଳେ ଲୋକମାନେ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ ବଚସା କରି କହିଲେ, “ଆମ୍ଭେମାନେ କଅଣ ପିଇବା?” ");
INSERT INTO ory_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ତହିଁରେ ସେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କରନ୍ତେ, ସଦାପ୍ରଭୁ ତାଙ୍କୁ ଏକ-ପ୍ରକାର କାଷ୍ଠ ଦେଖାଇଲେ, ସେ ତାହା ନେଇ ଜଳରେ ପକାନ୍ତେ, ଜଳ ମିଷ୍ଟ ହେଲା। ସେହି ସ୍ଥାନରେ ସଦାପ୍ରଭୁ ସେମାନଙ୍କ ନିମନ୍ତେ ବିଧି ଓ ଆଦେଶ ନିରୂପଣ କଲେ, ପୁଣି, ସେମାନଙ୍କର ପରୀକ୍ଷା ନେଇ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“ତୁମ୍ଭେ ଯଦି ଆପଣା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ବାକ୍ୟରେ ମନୋଯୋଗ କର, ତାହାଙ୍କ ଦୃଷ୍ଟିରେ ଯାହା ଉଚିତ ତାହା କର, ତାହାଙ୍କ ଆଜ୍ଞାରେ କର୍ଣ୍ଣ ଦିଅ ଓ ତାହାଙ୍କ ବିଧି ସମସ୍ତ ପାଳନ କର, ତେବେ ଆମ୍ଭେ ମିସରୀୟ ଲୋକମାନଙ୍କୁ ଯେସବୁ ରୋଗ ଭୋଗ କରାଇଲୁ, ତାହାସବୁ ତୁମ୍ଭମାନଙ୍କୁ ଭୋଗ କରିବାକୁ ଦେବା ନାହିଁ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭର ଆରୋଗ୍ୟକାରୀ।” ");
INSERT INTO ory_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ଏଥିଉତ୍ତାରେ ସେମାନେ ଏଲୀମଠାରେ ଉପସ୍ଥିତ ହେଲେ; ସେଠାରେ ଜଳର ବାର ନିର୍ଝର ଓ ସତୁରି ଖର୍ଜ୍ଜୁର ବୃକ୍ଷ ଥିଲା; ତହିଁରେ ସେମାନେ ସେହି ଜଳ ନିକଟରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ଏଥିଉତ୍ତାରେ ସେମାନେ ଏଲୀମଠାରୁ ଯାତ୍ରା କଲେ, ଆଉ ମିସର ଦେଶରୁ ପ୍ରସ୍ଥାନ କଲା ଉତ୍ତାରେ ଦ୍ୱିତୀୟ ମାସର ପଞ୍ଚଦଶ ଦିନରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀ ଏଲୀମ ଓ ସୀନୟର ମଧ୍ୟବର୍ତ୍ତୀ ସୀନ୍‍ ପ୍ରାନ୍ତରରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ସେତେବେଳେ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ସମସ୍ତ ମଣ୍ଡଳୀ ମୋଶା ଓ ହାରୋଣଙ୍କ ବିରୁଦ୍ଧରେ ପ୍ରାନ୍ତରରେ ବଚସା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସେମାନଙ୍କୁ କହିଲେ, “ହାୟ, ହାୟ, ଆମ୍ଭେମାନେ ଯେତେବେଳେ ମାଂସ ହାଣ୍ଡି ପାଖରେ ବସି ତୃପ୍ତି ପର୍ଯ୍ୟନ୍ତ ଅନ୍ନ ଭୋଜନ କରୁଥିଲୁ, ସେତେବେଳେ ଯଦି ଆମ୍ଭେମାନେ ମିସର ଦେଶରେ ସଦାପ୍ରଭୁଙ୍କ ହସ୍ତରେ ମରିଥାʼନ୍ତୁ। ତୁମ୍ଭେମାନେ ଏହି ସମସ୍ତ ମଣ୍ଡଳୀକୁ କ୍ଷୁଧାରେ ମାରିବା ପାଇଁ ଆମ୍ଭମାନଙ୍କୁ ବାହାର କରି ଏହି ପ୍ରାନ୍ତରକୁ ଆଣିଅଛ।” ");
INSERT INTO ory_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଆକାଶରୁ ଖାଦ୍ୟଦ୍ରବ୍ୟ ବୃଷ୍ଟି କରିବା; ପୁଣି, ଲୋକମାନେ ବାହାରକୁ ଯାଇ ପ୍ରତିଦିନ ଦିନର ନିରୂପିତ ପରିମାଣାନୁସାରେ ଖାଦ୍ୟ ସଂଗ୍ରହ କରିବେ; ତହିଁରେ ସେମାନେ ଆମ୍ଭର ବ୍ୟବସ୍ଥାନୁସାରେ ଚାଲିବେ କି ନାହିଁ, ଆମ୍ଭେ ସେମାନଙ୍କର ଏହି ପରୀକ୍ଷା ନେବା। ");
INSERT INTO ory_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ଷଷ୍ଠ ଦିନରେ ସେମାନେ ଯାହା ଆଣିବେ, ତାହା ରାନ୍ଧିଲେ ଦିନକୁ ଦିନ ଯାହା ସଂଗ୍ରହ କରନ୍ତି, ତାହା ଦୁଇଗୁଣ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ଏଥିଉତ୍ତାରେ ମୋଶା ଓ ହାରୋଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହିଲେ, “ସଦାପ୍ରଭୁ ଯେ ତୁମ୍ଭମାନଙ୍କୁ ମିସରଠାରୁ ବାହାର କରି ଆଣିଅଛନ୍ତି, ଏହା ତୁମ୍ଭେମାନେ ସନ୍ଧ୍ୟାକାଳରେ ଜାଣିବ। ");
INSERT INTO ory_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ପୁଣି, ପ୍ରାତଃକାଳରେ ସଦାପ୍ରଭୁଙ୍କର ମହିମା ଦେଖିବ; ଯେହେତୁ ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ତୁମ୍ଭମାନଙ୍କ ବଚସା ସେ ଶୁଣନ୍ତି; ଆମ୍ଭେମାନେ କିଏ ଯେ, ତୁମ୍ଭେମାନେ ଆମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ବଚସା କର?” ");
INSERT INTO ory_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ଆହୁରି ମୋଶା କହିଲେ, “ସଦାପ୍ରଭୁ ସନ୍ଧ୍ୟାକାଳରେ ଭୋଜନ ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କୁ ମାଂସ ଦେବେ ଓ ପ୍ରାତଃକାଳରେ ତୃପ୍ତି ପର୍ଯ୍ୟନ୍ତ ଅନ୍ନ ଦେବେ; କାରଣ ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ କରିଥିବା ତୁମ୍ଭମାନଙ୍କର ବଚସା ସେ ଶୁଣନ୍ତି। ଆମ୍ଭେମାନେ କିଏ? ତୁମ୍ଭମାନଙ୍କର ବଚସା ଆମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ନୁହେଁ ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ହୁଏ।” ");
INSERT INTO ory_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ଆଉ ମୋଶା ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀକୁ କୁହ, ‘ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ଆସ, ସେ ତୁମ୍ଭମାନଙ୍କର ବଚସା ଶୁଣିଅଛନ୍ତି।’” ");
INSERT INTO ory_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ତହିଁରେ ହାରୋଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀକୁ ଏହା କହିବା ସମୟରେ ସେମାନେ ପ୍ରାନ୍ତର ଆଡ଼େ ଅନାନ୍ତେ, ଦେଖ, ମେଘସ୍ତମ୍ଭ ମଧ୍ୟରେ ସଦାପ୍ରଭୁଙ୍କର ପ୍ରତାପ ଦେଖାଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ପୁଣି, ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ବଚସା ଶୁଣିଅଛୁ; ତୁମ୍ଭେ ସେମାନଙ୍କୁ କୁହ, ‘ତୁମ୍ଭେମାନେ ସନ୍ଧ୍ୟା ସମୟରେ ମାଂସ ଭୋଜନ କରିବ ଓ ପ୍ରଭାତରେ ଅନ୍ନରେ ପରିତୃପ୍ତ ହେବ; ତହିଁରେ ଆମ୍ଭେ ଯେ ତୁମ୍ଭମାନଙ୍କର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଅଟୁ, ତାହା ତୁମ୍ଭେମାନେ ଜାଣିବ।’” ");
INSERT INTO ory_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ଏଥିଉତ୍ତାରେ ସନ୍ଧ୍ୟା ସମୟରେ ଭାଟୋଇ ପକ୍ଷୀଗଣ ଆସି ଛାଉଣି-ସ୍ଥାନ ଆଚ୍ଛାଦନ କଲେ, ପୁଣି, ପ୍ରାତଃକାଳରେ ଛାଉଣି ସ୍ଥାନର ଚାରିଆଡ଼େ କାକର ପଡ଼ିଲା। ");
INSERT INTO ory_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ଏଉତ୍ତାରେ ପତିତ କାକର ଊର୍ଦ୍ଧ୍ୱଗତ ହେଲାରୁ ଭୂମିସ୍ଥିତ କାକର ପରି ଗୋଲାକାର କ୍ଷୁଦ୍ର ଦ୍ରବ୍ୟ ପ୍ରାନ୍ତର ଉପରେ ପଡ଼ି ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ଆଉ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ତାହା ଦେଖି ପରସ୍ପରକୁ କହିଲେ, “ଏହା କʼଣ ଅଟେ?” ଯେହେତୁ ତାହା କʼଣ ଥିଲା, ସେମାନେ ଜାଣିଲେ ନାହିଁ। ତହିଁରେ ମୋଶା କହିଲେ, “ଏହା ତୁମ୍ଭମାନଙ୍କ ଭୋଜନ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଦତ୍ତ ଅନ୍ନ। ");
INSERT INTO ory_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ଏ ବିଷୟରେ ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ‘ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ଜଣ ଆପଣା ଆପଣା ଭୋଜନ ଶକ୍ତି ବୁଝି ତାହା ସଂଗ୍ରହ କର; ତୁମ୍ଭମାନଙ୍କ ପ୍ରତ୍ୟେକ ଜଣ ଆପଣା ଆପଣା ତମ୍ବୁସ୍ଥିତ ପ୍ରାଣୀମାନଙ୍କ ସଂଖ୍ୟାନୁସାରେ ଏକ ଏକ ଜଣ ପାଇଁ ଏକ ଏକ ଓମର ପରିମାଣରେ ତାହା ସଂଗ୍ରହ କର।’” ");
INSERT INTO ory_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ତହିଁରେ ଇସ୍ରାଏଲ ସନ୍ତାନମାନେ ସେହି ପ୍ରକାର କଲେ; କେହି ଅଧିକ ଓ କେହି ଅଳ୍ପ ସଞ୍ଚୟ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ଏଥିଉତ୍ତାରେ ସେମାନେ ଓମରରେ ତାହା ପରିମାଣ କରନ୍ତେ; ଯେ ଅଧିକ ସଂଗ୍ରହ କରିଥିଲା, ତାହାର ବଳକା ହେଲା ନାହିଁ, ପୁଣି, ଯେ ଅଳ୍ପ ସଂଗ୍ରହ କରିଥିଲା, ତାହାର ଅଭାବ ହେଲା ନାହିଁ; ଏହି ପ୍ରକାରେ ସେମାନେ ଭୋଜନ ଶକ୍ତି ଅନୁସାରେ ସଂଗ୍ରହ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ଏଥିଉତ୍ତାରେ ମୋଶା ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ କେହି ପ୍ରାତଃକାଳ ପର୍ଯ୍ୟନ୍ତ କିଛି ରଖ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ତଥାପି ସେମାନେ ମୋଶାଙ୍କର କଥା ନ ମାନି କେହି କେହି ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ କିଛି କିଛି ରଖିଲେ; ମାତ୍ର ତହିଁରେ ପୋକ ଜନ୍ମିଲା ଓ ଦୁର୍ଗନ୍ଧ ହେଲା। ଏଣୁ ମୋଶା ସେମାନଙ୍କ ଉପରେ କ୍ରୋଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ଏହିରୂପେ ପ୍ରତିଦିନ ପ୍ରାତଃକାଳରେ ସେମାନେ ଆପଣା ଆପଣା ଭୋଜନ ଶକ୍ତି ଅନୁସାରେ ତାହା ସଂଗ୍ରହ କଲେ; ମାତ୍ର ପ୍ରଚଣ୍ଡ ଖରା ହୁଅନ୍ତେ, ତାହା ତରଳି ଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ଏଥିଉତ୍ତାରେ ଷଷ୍ଠ ଦିନରେ ସେମାନେ ଦୁଇଗୁଣ, ଅର୍ଥାତ୍‍, ପ୍ରତି ଜଣ ଦୁଇ ଦୁଇ ଓମର ଅନ୍ନ ସଂଗ୍ରହ କଲେ, ତହିଁରେ ମଣ୍ଡଳୀର ଅଧ୍ୟକ୍ଷ ସମସ୍ତେ ଆସି ମୋଶାଙ୍କୁ ଜଣାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ସେତେବେଳେ ମୋଶା ସେମାନଙ୍କୁ କହିଲେ, “ସଦାପ୍ରଭୁ ତାହା କହିଅଛନ୍ତି, ଯଥା, ‘କାଲି ମହା ବିଶ୍ରାମ ଦିନ, ଅର୍ଥାତ୍‍, ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ବିଶ୍ରାମ ହେବ; ଏହେତୁ ତୁମ୍ଭମାନଙ୍କର ଯାହା ଭାଜିବାର, ତାହା ଭାଜ; ଯାହା ପାକ କରିବାର, ତାହା ପାକ କର; ପୁଣି, ଯାହା କିଛି ଅବଶିଷ୍ଟ ରହେ, ତାହା ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ସଞ୍ଚୟ କରି ରଖ।’” ");
INSERT INTO ory_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ତହିଁରେ ସେମାନେ ମୋଶାଙ୍କର ଆଜ୍ଞାନୁସାରେ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ତାହା ରଖିଲେ, ଆଉ ତାହା ଦୁର୍ଗନ୍ଧ ହେଲା ନାହିଁ, କି ତହିଁରେ କୌଣସି ପୋକ ଜନ୍ମିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ଏଥିଉତ୍ତାରେ ମୋଶା କହିଲେ, “ଆଜି ତୁମ୍ଭେମାନେ ତାହା ଭୋଜନ କର, ଯେହେତୁ ଆଜି ସଦାପ୍ରଭୁଙ୍କର ବିଶ୍ରାମବାର; ଆଜି କ୍ଷେତରେ ତାହା ପାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ତୁମ୍ଭେମାନେ ଛଅ ଦିନ ତାହା ସଂଗ୍ରହ କରିବ, ମାତ୍ର ସପ୍ତମ ଦିନ ବିଶ୍ରାମବାର ଅଟେ, ତହିଁରେ କିଛି ମିଳିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ତଥାପି ସପ୍ତମ ଦିନରେ ମଧ୍ୟ କେହି କେହି ତାହା ସଂଗ୍ରହ କରିବାକୁ ଗଲେ, ମାତ୍ର କିଛି ପାଇଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଆମ୍ଭର ଆଜ୍ଞା ଓ ବ୍ୟବସ୍ଥା ପାଳନ କରିବାକୁ କେତେ କାଳ ଅସମ୍ମତ ଥିବ? ");
INSERT INTO ory_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ଦେଖ, ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କୁ ବିଶ୍ରାମ ଦିନ ଦେବା ସକାଶୁ ସେ (ସଦାପ୍ରଭୁ) ତୁମ୍ଭମାନଙ୍କୁ ଷଷ୍ଠ ଦିନରେ ଦୁଇ ଦିନର ଖାଦ୍ୟ ଦିଅନ୍ତି; ତୁମ୍ଭେମାନେ ପ୍ରତି ଜଣ ସପ୍ତମ ଦିନରେ ଆପଣା ଆପଣା ସ୍ଥାନରୁ ବାହାରକୁ ନ ଯାଇ ସ୍ୱ ସ୍ୱ ସ୍ଥାନରେ ଥାଅ।” ");
INSERT INTO ory_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ତେବେ ଲୋକମାନେ ସପ୍ତମ ଦିନରେ ବିଶ୍ରାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ପୁଣି, ଇସ୍ରାଏଲ ବଂଶ ସେହି ଖାଦ୍ୟର ନାମ “ମାନ୍ନା” ଦେଲେ; ତାହା ଧନିଆ ପରି ଶୁକ୍ଳବର୍ଣ୍ଣ ଓ ତାହାର ଆସ୍ୱାଦ ମଧୁ ମିଶ୍ରିତ ରୁଟି ତୁଲ୍ୟ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ଏଥିଉତ୍ତାରେ ମୋଶା କହିଲେ, “ସଦାପ୍ରଭୁ ଏହି ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ‘ସେ ତୁମ୍ଭମାନଙ୍କୁ ମିସର ଦେଶଠାରୁ ଆଣିବା ସମୟରେ ପ୍ରାନ୍ତର ମଧ୍ୟରେ ଯେଉଁ ଅନ୍ନ ଭୋଜନ କରାଇଲେ, ତାହା ଯେପରି ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷ-ପରମ୍ପରା ଦେଖନ୍ତି, ଏହେତୁ ସେମାନଙ୍କ ନିମନ୍ତେ ଏକ ଓମର ପରିମାଣ ମାନ୍ନା ରଖ।’” ");
INSERT INTO ory_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ସେତେବେଳେ ମୋଶା ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଗୋଟିଏ ପାତ୍ର ନେଇ ଏକ ଓମର ପରିମାଣ ମାନ୍ନା ପୂର୍ଣ୍ଣ କରି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ରଖ; ତାହା ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷ-ପରମ୍ପରା ନିମନ୍ତେ ରଖାଯିବ।” ");
INSERT INTO ory_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ତହୁଁ ହାରୋଣ ମୋଶାଙ୍କ ପ୍ରତି ଉକ୍ତ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ନିକଟରେ ରଖାଯିବା ନିମିତ୍ତ ତାହା ସଞ୍ଚୟ କରି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ଇସ୍ରାଏଲ ସନ୍ତାନମାନେ ବସତି ଦେଶରେ ଉପସ୍ଥିତ ନ ହେବା ଯାଏ ଚାଳିଶ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ସେହି ମାନ୍ନା ଭୋଜନ କଲେ ଓ କିଣାନ ଦେଶର ସୀମାରେ ଉପସ୍ଥିତ ନ ହେବା ଯାଏ ସେମାନେ ତାହା ଖାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ଏକ ଓମର ଐଫାର ଦଶମାଂଶ। ");
INSERT INTO ory_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀ ସୀନ୍‍ ପ୍ରାନ୍ତରରୁ ଯାତ୍ରା କରି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ନିରୂପିତ ସକଳ ଉତ୍ତରଣ-ସ୍ଥାନ ଦେଇ ରଫୀଦୀମରେ ଛାଉଣି ସ୍ଥାପନ କଲେ; ମାତ୍ର ସେ ସ୍ଥାନରେ ଲୋକମାନଙ୍କର ପାନ କରିବାକୁ ଜଳ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ଏଥିପାଇଁ ଲୋକମାନେ ମୋଶାଙ୍କ ସଙ୍ଗରେ ବିବାଦ କରି କହିଲେ, “ଆମ୍ଭମାନଙ୍କୁ ଜଳ ଦିଅ, ଆମ୍ଭେମାନେ ପାନ କରିବୁ।” ତହିଁରେ ମୋଶା କହିଲେ, “ତୁମ୍ଭେମାନେ ମୋʼ ସଙ୍ଗରେ କାହିଁକି ବିବାଦ କର? କାହିଁକି ସଦାପ୍ରଭୁଙ୍କୁ ପରୀକ୍ଷା କର?” ");
INSERT INTO ory_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ସେତେବେଳେ ଲୋକମାନେ ସେହି ସ୍ଥାନରେ ଜଳାଭାବ ହେତୁ ତୃଷାକୂଳ ହୋଇ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ ବଚସା କରି କହିଲେ, “କାହିଁକି ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କୁ, ଆମ୍ଭମାନଙ୍କ ସନ୍ତାନମାନଙ୍କୁ ଓ ପଶୁଗଣକୁ ପିପାସାରେ ମାରିବା ନିମନ୍ତେ ମିସରଠାରୁ ଆଣିଅଛ?” ");
INSERT INTO ory_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କରି କହିଲେ, “ମୁଁ ଏହି ଲୋକମାନଙ୍କ ନିମନ୍ତେ କʼଣ କରିବି? ସେମାନେ ମୋତେ ପଥର ପକାଇ ମାରିବାକୁ ପ୍ରାୟ ଉଦ୍ୟତ।” ");
INSERT INTO ory_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଯଦ୍ଦ୍ୱାରା ନୀଳ ନଦୀକୁ ଆଘାତ କରିଥିଲ, ସେହି ଯଷ୍ଟି ହସ୍ତରେ ଘେନି ଇସ୍ରାଏଲର କେତେକ ପ୍ରାଚୀନଙ୍କ ସଙ୍ଗେ ଇସ୍ରାଏଲ ଲୋକମାନଙ୍କ ଆଗେ ଆଗେ ଯାଅ। ");
INSERT INTO ory_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ଦେଖ, ଆମ୍ଭେ ହୋରେବରେ ସେହି ଶୈଳ ଉପରେ ତୁମ୍ଭ ସମ୍ମୁଖରେ ଠିଆ ହେବା; ତୁମ୍ଭେ ସେହି ଶୈଳକୁ ଆଘାତ କଲେ, ତହିଁରୁ ଜଳ ନିର୍ଗତ ହେବ, ଆଉ ଲୋକମାନେ ତାହା ପାନ କରିବେ;” ତେବେ ମୋଶା ଇସ୍ରାଏଲର ପ୍ରାଚୀନବର୍ଗଙ୍କ ଦୃଷ୍ଟିରେ ସେହିରୂପ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ପୁଣି, ସେହି ସ୍ଥାନରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ବିବାଦ ସକାଶୁ ଓ ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଅଛନ୍ତି କି ନାହିଁ, ଏହା କହି ସଦାପ୍ରଭୁଙ୍କୁ ପରୀକ୍ଷା କରିବା ସକାଶୁ ସେ ସେହି ସ୍ଥାନର ନାମ “ମଃସା ଓ ମିରୀବାଃ ରଖିଲେ।” ");
INSERT INTO ory_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ସେହି ସମୟରେ ଅମାଲେକ ଆସି ରଫୀଦୀମରେ ଇସ୍ରାଏଲ ସହିତ ଯୁଦ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ତହିଁରେ ମୋଶା ଯିହୋଶୂୟଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଲୋକ ମନୋନୀତ କରି ଅମାଲେକ ସହିତ ଯୁଦ୍ଧ କରିବାକୁ ଯାଅ; ଆସନ୍ତାକାଲି ମୁଁ ଆପଣା ହସ୍ତରେ ପରମେଶ୍ୱରଙ୍କ ଯଷ୍ଟି ଘେନି ପର୍ବତ ଶୃଙ୍ଗରେ ଠିଆ ହେବି।” ");
INSERT INTO ory_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ତହୁଁ ମୋଶାଙ୍କ ଆଜ୍ଞାନୁସାରେ ଯିହୋଶୂୟ ଅମାଲେକ ସହିତ ଯୁଦ୍ଧ କଲେ, ପୁଣି, ମୋଶା ଓ ହାରୋଣ, ହୂର ପର୍ବତ ଶୃଙ୍ଗରେ ଆରୋହଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ପୁଣି, ମୋଶା ଆପଣା ହସ୍ତ ଊର୍ଦ୍ଧ୍ୱକୁ ଟେକିଥିବା ସମୟରେ ଇସ୍ରାଏଲ ଜୟୀ ହେଲେ ଓ ସେ ଆପଣା ହସ୍ତ ନୁଆଁଇଥିବା ସମୟରେ ଅମାଲେକ ଜୟୀ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ମାତ୍ର ମୋଶାଙ୍କର ହସ୍ତ ଭାରୀ ହେଲା; ଏହେତୁ ସେମାନେ ଖଣ୍ଡିଏ ପ୍ରସ୍ତର ଆଣି ତାହା ତଳେ ରଖନ୍ତେ, ମୋଶା ତହିଁ ଉପରେ ବସିଲେ, ପୁଣି, ହାରୋଣ ଓ ହୂର ଜଣେ ଏପାଖେ ଆଉ ଜଣେ ସେପାଖେ ତାଙ୍କର ହାତ ଟେକି ଧରିଲେ; ତହିଁରେ ସୂର୍ଯ୍ୟାସ୍ତ ପର୍ଯ୍ୟନ୍ତ ତାଙ୍କର ହସ୍ତ ସ୍ଥିର ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ଏଣୁ ଯିହୋଶୂୟ ଅମାଲେକକୁ ଓ ତାହାର ଲୋକମାନଙ୍କୁ ଖଡ୍ଗଧାରରେ ପରାସ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଏହି କଥା ସ୍ମରଣାର୍ଥେ ପୁସ୍ତକରେ ଲେଖି ରଖ, ପୁଣି, ଯିହୋଶୂୟର କର୍ଣ୍ଣଗୋଚରରେ ତାହା ପାଠ କର; ଯଥା, ଆମ୍ଭେ ଆକାଶ ତଳରୁ ଅମାଲେକର ସ୍ମରଣ ଲୋପ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ତହିଁରେ ମୋଶା ଗୋଟିଏ ବେଦି ନିର୍ମାଣ କରି ତହିଁର ନାମ “ଯିହୋବାଃ-ନିଃଷି” ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ପୁଣି, ସେ ସଦାପ୍ରଭୁଙ୍କ ଧ୍ୱଜାରେ ହସ୍ତ ଦେଇ କହିଲେ, “ପୁରୁଷାନୁକ୍ରମେ ଅମାଲେକ ସହିତ ସଦାପ୍ରଭୁଙ୍କର ଯୁଦ୍ଧ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ମୋଶାଙ୍କ ନିମନ୍ତେ ଓ ଆପଣା ଲୋକ ଇସ୍ରାଏଲ ନିମନ୍ତେ ଯେଉଁ ଯେଉଁ କର୍ମ କରିଅଛନ୍ତି, ବିଶେଷରେ ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲ ବଂଶକୁ ମିସରଠାରୁ କିପରି ବାହାର କରି ଆଣିଅଛନ୍ତି, ଏହିସବୁ କଥା ମୋଶାଙ୍କର ଶ୍ୱଶୁର ମିଦୀୟନୀୟ ଯାଜକ ଯିଥ୍ରୋ ଶୁଣିବାକୁ ପାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ତହିଁରେ ମୋଶାଙ୍କର ଶ୍ୱଶୁର ସେହି ଯିଥ୍ରୋ ଆପଣା ଗୃହକୁ ପ୍ରେରିତା ମୋଶାଙ୍କର ଭାର୍ଯ୍ୟା ସିପ୍ପୋରାକୁ ଓ ତାହାର ଦୁଇ ପୁତ୍ରଙ୍କୁ ସଙ୍ଗରେ ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ସେହି ଦୁଇ ପୁତ୍ର ମଧ୍ୟରେ ଜଣକର ନାମ ଗେର୍ଶୋମ, କାରଣ ସେ କହିଥିଲେ, “ମୁଁ ପରଦେଶରେ ପ୍ରବାସୀ ହେଲି।” ");
INSERT INTO ory_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ପୁଣି, ଅନ୍ୟର ନାମ ଇଲୀୟେଜର, କାରଣ ସେ କହିଥିଲେ, “ମୋʼ ପିତାଙ୍କ ପରମେଶ୍ୱର ମୋହର ଉପକାରୀ ହୋଇ ଫାରୋଙ୍କର ଖଡ୍ଗରୁ ମୋତେ ଉଦ୍ଧାର କଲେ।” ");
INSERT INTO ory_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କର ଶ୍ୱଶୁର ଯିଥ୍ରୋ, ମୋଶାଙ୍କର ସେହି ଦୁଇ ପୁତ୍ର ଓ ଭାର୍ଯ୍ୟାକୁ ସଙ୍ଗରେ ଘେନି ପ୍ରାନ୍ତରରେ ମୋଶାଙ୍କ ନିକଟକୁ, ଅର୍ଥାତ୍‍, ପରମେଶ୍ୱରଙ୍କ ପର୍ବତର ଯେଉଁ ସ୍ଥାନରେ ସେ ଛାଉଣି ସ୍ଥାପନ କରିଥିଲେ, ସେହି ସ୍ଥାନକୁ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ପୁଣି, ସେ ମୋଶାଙ୍କୁ ଜଣାଇଲେ, “ତୁମ୍ଭର ଶ୍ୱଶୁର ଯିଥ୍ରୋ, ମୁଁ ଓ ତୁମ୍ଭର ଭାର୍ଯ୍ୟା, ତାହା ସହିତ ତୁମ୍ଭର ଦୁଇ ପୁତ୍ର, ଆମ୍ଭେ ସମସ୍ତେ ତୁମ୍ଭ ନିକଟକୁ ଆସିଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ସେତେବେଳେ ମୋଶା ଆପଣା ଶ୍ୱଶୁର ସହିତ ସାକ୍ଷାତ କରିବାକୁ ବାହାରକୁ ଯାଇ ତାଙ୍କୁ ପ୍ରଣାମ ଓ ଚୁମ୍ବନ କଲେ; ପୁଣି, ପରସ୍ପର ମଙ୍ଗଳ ବାର୍ତ୍ତା ପଚାରିଲା ଉତ୍ତାରେ ସେମାନେ ତମ୍ବୁରେ ପ୍ରବେଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲ ନିମନ୍ତେ ଫାରୋଙ୍କ ପ୍ରତି ଓ ମିସରୀୟମାନଙ୍କ ପ୍ରତି ଯାହା ଯାହା କରିଅଛନ୍ତି, ପଥରେ ସେମାନଙ୍କ ପ୍ରତି ଯେସବୁ କ୍ଳେଶ ଘଟିଅଛି ଓ ସଦାପ୍ରଭୁ ଯେପ୍ରକାରେ ସେମାନଙ୍କୁ ଉଦ୍ଧାର କରିଅଛନ୍ତି, ଏହିସବୁ ବୃତ୍ତାନ୍ତ ମୋଶା ଆପଣା ଶ୍ୱଶୁରଙ୍କୁ ଜଣାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ତହିଁରେ ସଦାପ୍ରଭୁ ମିସରୀୟମାନଙ୍କ ହସ୍ତରୁ ଇସ୍ରାଏଲକୁ ଉଦ୍ଧାର କରି ଯେସବୁ ମଙ୍ଗଳ ପ୍ରଦାନ କରିଅଛନ୍ତି, ତହିଁ ନିମନ୍ତେ ଯିଥ୍ରୋ ଅତି ଆହ୍ଲାଦିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ପୁଣି, ଯିଥ୍ରୋ କହିଲେ, “ଯେଉଁ ସଦାପ୍ରଭୁ ମିସରୀୟମାନଙ୍କର ଓ ଫାରୋଙ୍କର ହସ୍ତରୁ ତୁମ୍ଭମାନଙ୍କୁ ଉଦ୍ଧାର କରିଅଛନ୍ତି, ଆଉ ମିସରୀୟମାନଙ୍କ ଅଧୀନତାରୁ ଲୋକମାନଙ୍କୁ ଉଦ୍ଧାର କରିଅଛନ୍ତି, ସେ ଧନ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ସଦାପ୍ରଭୁ ସମସ୍ତ ଦେବଗଣଠାରୁ ଅଧିକ ମହାନ, ଏହା ମୁଁ ଏବେ ଜାଣିଲି। ହଁ, ସେମାନେ ଯେଉଁ ବିଷୟରେ ସେମାନଙ୍କ ବିରୁଦ୍ଧରେ ଗର୍ବ କରିଥିଲେ, (ସେହି ବିଷୟରେ ସେ ମହାନ।”) ");
INSERT INTO ory_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କ ଶ୍ୱଶୁର ଯିଥ୍ରୋ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମ ଓ ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କଲେ; ପୁଣି, ହାରୋଣ ଓ ଇସ୍ରାଏଲର ସମସ୍ତ ପ୍ରାଚୀନବର୍ଗ ଆସି ପରମେଶ୍ୱରଙ୍କ ସମ୍ମୁଖରେ ମୋଶାଙ୍କ ଶ୍ୱଶୁର ସଙ୍ଗରେ ଭୋଜନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ତହିଁ ଆରଦିନ ମୋଶା ଲୋକମାନଙ୍କର ବିଚାର କରିବାକୁ ବସନ୍ତେ, ଲୋକମାନେ ପ୍ରଭାତଠାରୁ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ତାଙ୍କ ସମ୍ମୁଖରେ ଠିଆ ହୋଇ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ସେତେବେଳେ ମୋଶା ଲୋକମାନଙ୍କ ବିଷୟରେ ଯାହା ଯାହା କଲେ, ତାଙ୍କର ଶ୍ୱଶୁର ତାହା ଦେଖି କହିଲେ, “ତୁମ୍ଭେ ଲୋକମାନଙ୍କ ପ୍ରତି ଏ କିରୂପ ବ୍ୟବହାର କରୁଅଛ? ତୁମ୍ଭେ କାହିଁକି ଏକାକୀ ବସ ଓ ସମସ୍ତ ଲୋକ ପ୍ରଭାତଠାରୁ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭ ଚାରିଆଡ଼େ କାହିଁକି ଠିଆ ହୋଇ ରହନ୍ତି?” ");
INSERT INTO ory_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ତହିଁରେ ମୋଶା ଆପଣା ଶ୍ୱଶୁରଙ୍କୁ କହିଲେ, “ଲୋକମାନେ ପରମେଶ୍ୱରଙ୍କ ବିଚାର ବୁଝିବା ପାଇଁ ମୋʼ ପାଖକୁ ଆସନ୍ତି ");
INSERT INTO ory_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ଓ ସେମାନଙ୍କର କୌଣସି ବିବାଦ ହେଲେ, ମୋʼ ପାଖକୁ ଆସନ୍ତି; ତହିଁରେ ମୁଁ ବାଦୀ ଓ ପ୍ରତିବାଦୀ ମଧ୍ୟରେ ବିଚାର କରେ, ପୁଣି, ପରମେଶ୍ୱରଙ୍କ ବିଧି ଓ ବ୍ୟବସ୍ଥାସବୁ ସେମାନଙ୍କୁ ଜ୍ଞାତ କରାଏ।” ");
INSERT INTO ory_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କର ଶ୍ୱଶୁର କହିଲେ, “ତୁମ୍ଭର ଏହି କର୍ମ ଭଲ ନୁହେଁ। ");
INSERT INTO ory_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ତୁମ୍ଭେ ଓ ତୁମ୍ଭ ସଙ୍ଗୀ ଏହି ଲୋକମାନେ ଦୁହେଁ ନିଶ୍ଚୟ କ୍ଷୀଣ ହୋଇଯିବ; କାରଣ ଏ କାର୍ଯ୍ୟ ତୁମ୍ଭ ନିମନ୍ତେ ଅତି ଭାରୀ; ତୁମ୍ଭେ ଏକାକୀ ଏହା ସାଧନ କରି ନ ପାର। ");
INSERT INTO ory_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ଏହେତୁ ମୋʼ କଥାରେ ମନୋଯୋଗ କର, ମୁଁ ତୁମ୍ଭଙ୍କୁ ପରାମର୍ଶ ଦେବି, ପୁଣି, ପରମେଶ୍ୱର ତୁମ୍ଭର ସହବର୍ତ୍ତୀ ହେଉନ୍ତୁ; ପରମେଶ୍ୱରଙ୍କ ଛାମୁରେ ତୁମ୍ଭେ ଲୋକମାନଙ୍କ ପକ୍ଷ ହୋଇ ସେମାନଙ୍କ କଥା ପରମେଶ୍ୱରଙ୍କ ନିକଟରେ ଜଣାଅ। ");
INSERT INTO ory_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ପୁଣି, ତୁମ୍ଭେ ସେମାନଙ୍କୁ ବିଧି ଓ ବ୍ୟବସ୍ଥାର ଉପଦେଶ ଦିଅ ଓ ସେମାନଙ୍କର ଗନ୍ତବ୍ୟ ପଥ ଓ କର୍ତ୍ତବ୍ୟ କର୍ମ ଦେଖାଅ। ");
INSERT INTO ory_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ଆହୁରି, ତୁମ୍ଭେ ଏହି ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ କର୍ମକ୍ଷମ, ଅର୍ଥାତ୍‍, ପରମେଶ୍ୱରଙ୍କ ପ୍ରତି ଭୟକାରୀ, ସତ୍ୟବାଦୀ ଓ ଅନ୍ୟାୟ ଲାଭ ଘୃଣାକାରୀ ଲୋକଙ୍କୁ ମନୋନୀତ କର; ପୁଣି, ସେମାନଙ୍କୁ ଲୋକମାନଙ୍କ ଉପରେ ସହସ୍ରପତି, ଶତପତି, ପଚାଶପତି ଓ ଦଶପତି ରୂପେ ନିଯୁକ୍ତ କର। ");
INSERT INTO ory_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ସେମାନେ ସର୍ବଦା ଲୋକମାନଙ୍କର ବିଚାର କରନ୍ତୁ, ପୁଣି, କୌଣସି ବଡ଼ କଥା ହେଲେ ତୁମ୍ଭ ନିକଟକୁ ଆଣିବେ, ମାତ୍ର କ୍ଷୁଦ୍ର କଥାସବୁ ସେମାନେ ଆପେ ବିଚାର କରିବେ, ତାହାହେଲେ ତୁମ୍ଭ ନିଜ କର୍ମ ଉଶ୍ୱାସ ହେବ, ପୁଣି, ସେମାନେ ତୁମ୍ଭ ସହିତ ଭାର ବହିବେ। ");
INSERT INTO ory_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ଯଦି ତୁମ୍ଭେ ଏହିପରି କରିବ, ପୁଣି, ପରମେଶ୍ୱର ଏପରି କରିବା ପାଇଁ ଆଜ୍ଞା ଦେବେ, ତେବେ ତୁମ୍ଭେ ସହ୍ୟ କରି ପାରିବ? ଆଉ ଏହିସବୁ ଲୋକମାନେ କୁଶଳରେ ସ୍ୱ ସ୍ଥାନକୁ ଯିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ଏଥିଉତ୍ତାରେ ମୋଶା ଆପଣା ଶ୍ୱଶୁରଙ୍କ କଥାରେ ମନୋଯୋଗ କରି ତାଙ୍କର ବାକ୍ୟାନୁସାରେ ସବୁ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ପୁଣି, ମୋଶା ସମଗ୍ର ଇସ୍ରାଏଲ ମଧ୍ୟରୁ କର୍ମକ୍ଷମ ଲୋକ ମନୋନୀତ କରି ଲୋକମାନଙ୍କ ଉପରେ ପ୍ରଧାନ, ଅର୍ଥାତ୍‍, ସହସ୍ରପତି, ଶତପତି, ପଚାଶପତି ଓ ଦଶପତି ରୂପେ ନିଯୁକ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ତହୁଁ ସେମାନେ ସବୁ ସମୟରେ ଲୋକମାନଙ୍କର ବିଚାର କଲେ; କଠିନ ବିଚାରସବୁ ମୋଶାଙ୍କ ପାଖକୁ ଆଣିଲେ; ମାତ୍ର କ୍ଷୁଦ୍ର କ୍ଷୁଦ୍ର କଥାସବୁ ଆପେ ଆପେ ବିଚାର କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ଏଥିଉତ୍ତାରେ ମୋଶା ଆପଣା ଶ୍ୱଶୁରଙ୍କୁ ବିଦାୟ କରନ୍ତେ, ସେ ସ୍ୱଦେଶକୁ ପ୍ରସ୍ଥାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ମିସର ଦେଶରୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ବାହାର ହେବାର ତୃତୀୟ ମାସର ପ୍ରଥମ ଦିନରେ, ସେମାନେ ସୀନୟ ପ୍ରାନ୍ତରରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ସେମାନେ ରଫୀଦୀମଠାରୁ ଯାତ୍ରା କରି ସୀନୟ ପ୍ରାନ୍ତରରେ ଉପସ୍ଥିତ ହୁଅନ୍ତେ, ସେହି ପ୍ରାନ୍ତରରେ ଛାଉଣି ସ୍ଥାପନ କଲେ; ଇସ୍ରାଏଲ ସେହି ସ୍ଥାନରେ ପର୍ବତ ସମ୍ମୁଖରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ଏଥିଉତ୍ତାରେ ମୋଶା ପରମେଶ୍ୱରଙ୍କ ନିକଟକୁ ଆରୋହଣ କରନ୍ତେ, ସଦାପ୍ରଭୁ ପର୍ବତରୁ ତାଙ୍କୁ ଡାକି କହିଲେ, “ତୁମ୍ଭେ ଯାକୁବ ବଂଶକୁ ଏହି କଥା କୁହ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଏହା ଜଣାଅ। ");
INSERT INTO ory_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","ଆମ୍ଭେ ମିସରୀୟମାନଙ୍କ ପ୍ରତି ଯାହା କଲୁ ଓ ତୁମ୍ଭମାନଙ୍କୁ କିପରି ଉତ୍କ୍ରୋଶ ପକ୍ଷୀର ପକ୍ଷରେ ବହି ଆପଣା ନିକଟକୁ ଆଣିଲୁ, ତାହା ତୁମ୍ଭେମାନେ ଦେଖିଅଛ। ");
INSERT INTO ory_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ଏବେ ତୁମ୍ଭେମାନେ ଯଦି ଆମ୍ଭ ରବରେ ମନୋଯୋଗ କରିବ ଓ ଆମ୍ଭ ନିୟମ ପାଳନ କରିବ, ତେବେ ତୁମ୍ଭେମାନେ ସମସ୍ତ ଲୋକଙ୍କ ଅପେକ୍ଷା ଆମ୍ଭ ନିଜର ସଞ୍ଚିତ ଧନ ହେବ; କାରଣ ସମସ୍ତ ପୃଥିବୀ ଆମ୍ଭର। ");
INSERT INTO ory_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ପୁଣି, ତୁମ୍ଭେମାନେ ଆମ୍ଭ ନିମନ୍ତେ ଯାଜକମାନଙ୍କର ଏକ ରାଜବଂଶ ଓ ଏକ ପବିତ୍ର ଗୋଷ୍ଠୀ ହେବ; ଏହିସବୁ କଥା ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ।” ");
INSERT INTO ory_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ତହୁଁ ମୋଶା ଆସି ଲୋକମାନଙ୍କର ପ୍ରାଚୀନବର୍ଗଙ୍କୁ ଡକାଇ ସଦାପ୍ରଭୁଙ୍କ ଦ୍ୱାରା ଆଦେଶପ୍ରାପ୍ତ ଏହିସବୁ କଥା ସେମାନଙ୍କ ଅଗ୍ରତେ ପ୍ରସ୍ତାବ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ତହିଁରେ ସମସ୍ତ ଲୋକ ଏକସଙ୍ଗରେ ଅଙ୍ଗୀକାର କରି କହିଲେ, “ସଦାପ୍ରଭୁ ଯେଉଁ କଥା କହିଅଛନ୍ତି, ତାହାସବୁ ଆମ୍ଭେମାନେ କରିବା।” ସେତେବେଳେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ଲୋକମାନଙ୍କ କଥା ଜଣାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭ ସହିତ କଥା କହିବା ସମୟରେ ଲୋକମାନେ ଯେପରି ତାହା ଶୁଣି ପାରିବେ, ମଧ୍ୟ ତୁମ୍ଭଠାରେ ସର୍ବଦା ବିଶ୍ୱାସ କରିବେ, ଏଥିପାଇଁ ଆମ୍ଭେ ନିବିଡ଼ ମେଘରେ ତୁମ୍ଭ ନିକଟକୁ ଆସୁଅଛୁ।” ଏଥିଉତ୍ତାରେ ମୋଶା ଲୋକମାନଙ୍କ କଥା ସଦାପ୍ରଭୁଙ୍କୁ ଜଣାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଲୋକମାନଙ୍କ ନିକଟକୁ ଯାଇ ଆଜି ଓ କାଲି ସେମାନଙ୍କୁ ପବିତ୍ର କର, ପୁଣି, ସେମାନେ ଆପଣା ଆପଣା ବସ୍ତ୍ର ଧୌତ କରନ୍ତୁ ");
INSERT INTO ory_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ଓ ତୃତୀୟ ଦିନ ନିମନ୍ତେ ସମସ୍ତେ ପ୍ରସ୍ତୁତ ହେଉନ୍ତୁ; କାରଣ ତୃତୀୟ ଦିନରେ ସଦାପ୍ରଭୁ ସମସ୍ତ ଲୋକଙ୍କ ସାକ୍ଷାତରେ ସୀନୟ ପର୍ବତ ଉପରକୁ ଓହ୍ଲାଇ ଆସିବେ। ");
INSERT INTO ory_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ଏହେତୁ ତୁମ୍ଭେ ଲୋକମାନଙ୍କ ଚତୁର୍ଦ୍ଦିଗରେ ସୀମା ନିରୂପଣ କରି ଏହି କଥା କୁହ, ‘ତୁମ୍ଭେମାନେ ପର୍ବତାରୋହଣ ଓ ତହିଁର ସୀମା ସ୍ପର୍ଶ କରିବାକୁ ସାବଧାନ ହୁଅ; ଯେକେହି ପର୍ବତ ସ୍ପର୍ଶ କରିବ, ସେ ଅବଶ୍ୟ ହତ ହେବ।’ ");
INSERT INTO ory_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","କାହାର ହାତ ତାହାକୁ ସ୍ପର୍ଶ କରିବ ନାହିଁ, ମାତ୍ର ସେ ଅବଶ୍ୟ ପ୍ରସ୍ତରାଘାତରେ ହତ ହେବ, କିମ୍ବା ବାଣ ଦ୍ୱାରା ବିଦ୍ଧ ହେବ; ପଶୁ ହେଉ କି ମନୁଷ୍ୟ ହେଉ, କଦାପି ବଞ୍ଚିବ ନାହିଁ; ତୂରୀର ଦୀର୍ଘଧ୍ୱନି ହେଲେ ସେମାନେ ପର୍ବତ ପର୍ଯ୍ୟନ୍ତ ଉଠି ଆସିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ଏଥିଉତ୍ତାରେ ମୋଶା ପର୍ବତରୁ ଓହ୍ଲାଇ ଲୋକମାନଙ୍କ ନିକଟକୁ ଆସି ସେମାନଙ୍କୁ ପବିତ୍ର କଲେ, ପୁଣି, ସେମାନେ ଆପଣା ଆପଣା ବସ୍ତ୍ରସବୁ ଧୌତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ତହୁଁ ସେ ଲୋକମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ତୃତୀୟ ଦିନ ନିମନ୍ତେ ପ୍ରସ୍ତୁତ ହୁଅ; ପୁଣି ଆପଣା ଆପଣା ଭାର୍ଯ୍ୟା ସହ ଶୟନ କର ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ଏଥିଉତ୍ତାରେ ତୃତୀୟ ଦିନର ପ୍ରଭାତ ହୁଅନ୍ତେ, ମେଘ ଗର୍ଜ୍ଜନ ଓ ବିଜୁଳି ଓ ପର୍ବତ ଉପରେ ନିବିଡ଼ ମେଘ ଓ ଅତିଶୟ ଉଚ୍ଚସ୍ୱରରେ ତୂରୀଧ୍ୱନି ହେବାକୁ ଲାଗିଲା; ତହିଁରେ ଛାଉଣିସ୍ଥିତ ସମସ୍ତ ଲୋକ କମ୍ପାନ୍ୱିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ତହୁଁ ପରମେଶ୍ୱରଙ୍କ ସହିତ ସାକ୍ଷାତ କରିବା ନିମନ୍ତେ ମୋଶା ଲୋକମାନଙ୍କୁ ଛାଉଣିରୁ ବାହାର କରି ଆଣିଲେ, ତହିଁରେ ସେମାନେ ପର୍ବତର ତଳେ ଠିଆ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ସେତେବେଳେ ସୀନୟ ପର୍ବତ ଧୂମମୟ ଥିଲା, କାରଣ ସଦାପ୍ରଭୁ ଅଗ୍ନି ବାହନରେ ତହିଁ ଉପରେ ଅବରୋହଣ କଲେ; ତହିଁରେ ଭାଟିର ଧୂମ ପରି ତହିଁରୁ ଧୂମ ଉଠିଲା, ପୁଣି, ସମୁଦାୟ ପର୍ବତ ଅତିଶୟ କମ୍ପିଲା। ");
INSERT INTO ory_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ପୁଣି, ତୂରୀ ଶବ୍ଦ କ୍ରମଶଃ ଅତିଶୟ ଉଚ୍ଚ ହୁଅନ୍ତେ, ମୋଶା କଥା କହିଲେ, ତହିଁରେ ପରମେଶ୍ୱର ଏକ ରବ ଦ୍ୱାରା ତାଙ୍କୁ ଉତ୍ତର ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ସୀନୟ ପର୍ବତ ଉପରେ, ଅର୍ଥାତ୍‍, ପର୍ବତ ଶୃଙ୍ଗରେ ଅବରୋହଣ କଲା ଉତ୍ତାରେ ମୋଶାଙ୍କୁ ସେହି ପର୍ବତ ଶୃଙ୍ଗକୁ ଡ଼ାକିଲେ; ତହିଁରେ ମୋଶା ଆରୋହଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ସେତେବେଳେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଓହ୍ଲାଇ ଯାଇ ଲୋକମାନଙ୍କୁ ଦୃଢ଼ ଆଦେଶ କର, ନୋହିଲେ ସଦାପ୍ରଭୁଙ୍କୁ ଦେଖିବା ପାଇଁ ସୀମା ଲଙ୍ଘନ କଲେ, ସେମାନଙ୍କ ମଧ୍ୟରୁ ଅନେକେ ବିନଷ୍ଟ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ଆଉ ଯେଉଁ ଯାଜକମାନେ ସଦାପ୍ରଭୁଙ୍କର ନିକଟବର୍ତ୍ତୀ ହୋଇଥାʼନ୍ତି, ସେମାନେ ମଧ୍ୟ ଆପଣାମାନଙ୍କୁ ପବିତ୍ର କରନ୍ତୁ, ନୋହିଲେ ସେ ସେମାନଙ୍କୁ ଆକ୍ରମଣ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, “ଲୋକମାନେ ସୀନୟ ପର୍ବତରେ ଆରୋହଣ କରିପାରନ୍ତି ନାହିଁ; କାରଣ ତୁମ୍ଭେ ଦୃଢ଼ ଆଜ୍ଞା ଦେଇ ଆମ୍ଭମାନଙ୍କୁ କହିଅଛ, ‘ପର୍ବତର ସୀମା ନିରୂପଣ କର ଓ ତାହା ପବିତ୍ର କର।’” ");
INSERT INTO ory_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ତେବେ ସଦାପ୍ରଭୁ ତାଙ୍କୁ କହିଲେ, “ଯାଅ, ଓହ୍ଲାଅ; ପୁଣି, ତୁମ୍ଭେ ହାରୋଣଙ୍କୁ ସଙ୍ଗରେ ନେଇ ଆରୋହଣ କରିବ; ମାତ୍ର ଯାଜକଗଣ ଓ ଲୋକମାନଙ୍କ ଉପରେ ସଦାପ୍ରଭୁ ଯେପରି ଆକ୍ରମଣ ନ କରନ୍ତି, ଏଥିପାଇଁ ସେମାନେ ତାହାଙ୍କ ଛାମୁକୁ ଆସିବା ପାଇଁ ସୀମା ଅତିକ୍ରମ ନ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ତହୁଁ ମୋଶା ଲୋକମାନଙ୍କ ନିକଟକୁ ଓହ୍ଲାଇ ଯାଇ ସେମାନଙ୍କୁ ସେହି ପ୍ରକାର ଆଜ୍ଞା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ଏଥିଉତ୍ତାରେ ପରମେଶ୍ୱର ଏହିସବୁ କଥା କହିଲେ, ଯଥା, ");
INSERT INTO ory_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ଯେ ତୁମ୍ଭକୁ ଦାସଗୃହ ସ୍ୱରୂପ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଅଛନ୍ତି, ତୁମ୍ଭର ସେହି ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଆମ୍ଭେ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ଆମ୍ଭ ସାକ୍ଷାତରେ ତୁମ୍ଭର ଆଉ କୌଣସି ଦେବତା ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","ତୁମ୍ଭେ ଆପଣା ନିମନ୍ତେ କୌଣସି ଖୋଦିତ ପ୍ରତିମା ନିର୍ମାଣ କରିବ ନାହିଁ; କି ଉପରିସ୍ଥ ସ୍ୱର୍ଗରେ, କି ନୀଚସ୍ଥ ପୃଥିବୀରେ, କି ପୃଥିବୀର ନୀଚସ୍ଥ ଜଳରେ ଥିବା କୌଣସି ବସ୍ତୁର ପ୍ରତିମୂର୍ତ୍ତି ନିର୍ମାଣ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ତୁମ୍ଭେ ସେମାନଙ୍କୁ ପ୍ରଣାମ କରିବ ନାହିଁ, କି ସେମାନଙ୍କର ସେବା କରିବ ନାହିଁ; ଯେହେତୁ ଆମ୍ଭେ ତୁମ୍ଭର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ସ୍ୱଗୌରବ ରକ୍ଷଣରେ ଉଦ୍‍ଯୋଗୀ ପରମେଶ୍ୱର ଅଟୁ, ପୁଣି, ଯେଉଁମାନେ ଆମ୍ଭଙ୍କୁ ଘୃଣା କରନ୍ତି, ଆମ୍ଭେ ସେମାନଙ୍କ ତୃତୀୟ ଓ ଚତୁର୍ଥ ପୁରୁଷ ପର୍ଯ୍ୟନ୍ତ ସନ୍ତାନମାନଙ୍କ ଉପରେ ପୈତୃକ ଅପରାଧର ପ୍ରତିଫଳଦାତା; ");
INSERT INTO ory_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ମାତ୍ର ଯେଉଁମାନେ ଆମ୍ଭଙ୍କୁ ପ୍ରେମ କରନ୍ତି ଓ ଆମ୍ଭର ଆଜ୍ଞା ପାଳନ କରନ୍ତି, ଆମ୍ଭେ ସେମାନଙ୍କର ସହସ୍ର ପୁରୁଷ ପର୍ଯ୍ୟନ୍ତ ଦୟାକାରୀ। ");
INSERT INTO ory_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ତୁମ୍ଭେ ଆପଣା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ନାମ ମିଥ୍ୟାରେ ନେବ ନାହିଁ; ଯେହେତୁ ଯେକେହି ତାହାଙ୍କର ନାମ ମିଥ୍ୟାରେ ନିଏ, ସଦାପ୍ରଭୁ ତାହାକୁ ନିରପରାଧ ଗଣନା କରିବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ବିଶ୍ରାମ ଦିନ ପବିତ୍ର ରୂପେ ପାଳିବାକୁ ସ୍ମରଣ କର। ");
INSERT INTO ory_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ଛଅ ଦିନ ପରିଶ୍ରମ ଓ ଆପଣାର ସବୁ କର୍ମ କରିବ; ");
INSERT INTO ory_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ମାତ୍ର ସପ୍ତମ ଦିନ ତୁମ୍ଭ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କର ବିଶ୍ରାମ ଦିନ ଅଟେ; ତହିଁରେ ତୁମ୍ଭେ, କି ତୁମ୍ଭର ପୁତ୍ର, କି ତୁମ୍ଭର କନ୍ୟା, ତୁମ୍ଭର ଦାସ, କି ଦାସୀ, ତୁମ୍ଭର ପଶୁ, କି ତୁମ୍ଭର ନଗରଦ୍ୱାରବର୍ତ୍ତୀ ବିଦେଶୀ, କେହି କୌଣସି କାର୍ଯ୍ୟ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ଯେହେତୁ ସଦାପ୍ରଭୁ ଆକାଶମଣ୍ଡଳ ଓ ପୃଥିବୀ ଓ ସମୁଦ୍ର ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ସମସ୍ତ ବସ୍ତୁ ଛଅ ଦିନରେ ନିର୍ମାଣ କରି ସପ୍ତମ ଦିନରେ ବିଶ୍ରାମ କଲେ; ଏହେତୁ ସଦାପ୍ରଭୁ ବିଶ୍ରାମ ଦିନକୁ ଆଶୀର୍ବାଦ କରି ପବିତ୍ର କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ତୁମ୍ଭେ ଆପଣା ପିତା ଓ ଆପଣା ମାତାଙ୍କୁ ସମ୍ଭ୍ରମ କର; ତହିଁରେ ତୁମ୍ଭର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ତୁମ୍ଭକୁ ଯେଉଁ ଦେଶ ଦେବେ, ସେହି ଦେଶରେ ତୁମ୍ଭର ଦୀର୍ଘ ପରମାୟୁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ତୁମ୍ଭେ ନରହତ୍ୟା କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ତୁମ୍ଭେ ବ୍ୟଭିଚାର କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","ତୁମ୍ଭେ ଚୋରି କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","ତୁମ୍ଭେ ଆପଣା ପ୍ରତିବାସୀ ବିରୁଦ୍ଧରେ ମିଥ୍ୟା ସାକ୍ଷ୍ୟ ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","ତୁମ୍ଭେ ଆପଣା ପ୍ରତିବାସୀର ଗୃହକୁ ଲୋଭ କରିବ ନାହିଁ, ତୁମ୍ଭେ ଆପଣା ପ୍ରତିବାସୀର ଭାର୍ଯ୍ୟା, କି ଦାସ, କି ଦାସୀ, କି ତାହାର ଗୋରୁ, କି ଗଧ, କି ତୁମ୍ଭ ପ୍ରତିବାସୀର କୌଣସି ବସ୍ତୁକୁ ଲୋଭ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ସେତେବେଳେ ସମସ୍ତ ଲୋକ ମେଘ ଗର୍ଜ୍ଜନ ଓ ବିଜୁଳି ଓ ତୂରୀଧ୍ୱନି ଓ ଧୂମଯୁକ୍ତ ପର୍ବତ ଦେଖିଲେ; ପୁଣି, ତାହା ଦେଖି ସେମାନେ କମ୍ପିତ ହୋଇ ଦୂରରେ ଠିଆ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ଆଉ ସେମାନେ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗେ କଥା କୁହ, ଆମ୍ଭେମାନେ ଶୁଣିବୁ; ମାତ୍ର ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗେ କଥା ନ କହନ୍ତୁ, ନୋହିଲେ ଆମ୍ଭେମାନେ ମରିଯିବୁ।” ");
INSERT INTO ory_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ତହିଁରେ ମୋଶା ଲୋକମାନଙ୍କୁ କହିଲେ, “ଭୟ କର ନାହିଁ; କାରଣ ତୁମ୍ଭମାନଙ୍କୁ ପରୀକ୍ଷା କରିବାକୁ ଓ ତୁମ୍ଭେମାନେ ଯେପରି ପାପ ନ କରିବ, ଏଥିପାଇଁ ଆପଣାର ଭୟାନକତା ତୁମ୍ଭମାନଙ୍କ ଚକ୍ଷୁଗୋଚର କରିବାକୁ ପରମେଶ୍ୱର ଆସିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ତେଣୁ ଲୋକମାନେ ଦୂରରେ ଠିଆ ହୋଇ ରହିଲେ; ମାତ୍ର ଯେଉଁଠାରେ ପରମେଶ୍ୱର ଥିଲେ, ମୋଶା ସେହି ଘୋର ଅନ୍ଧକାର ନିକଟକୁ ଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଏହି କଥା କୁହ, ‘ଆମ୍ଭେ ଆକାଶରେ ଥାଇ ତୁମ୍ଭମାନଙ୍କ ସହିତ କଥା କହିଲୁ, ଏହା ତୁମ୍ଭେମାନେ ନିଜେ ଦେଖିଅଛ। ");
INSERT INTO ory_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ଏହେତୁ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ପ୍ରତିଯୋଗୀ, ଅନ୍ୟ ଦେବତାଗଣ ନିର୍ମାଣ କରିବ ନାହିଁ; ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ରୌପ୍ୟମୟ ଦେବତା ଓ ସ୍ୱର୍ଣ୍ଣମୟ ଦେବତା ନିର୍ମାଣ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ତୁମ୍ଭେ ଆମ୍ଭ ନିମନ୍ତେ ଏକ ମୃତ୍ତିକାର ବେଦି ନିର୍ମାଣ କରିବ, ପୁଣି, ତହିଁ ଉପରେ ତୁମ୍ଭର ଗୋମେଷାଦି ହୋମବଳି ଓ ମଙ୍ଗଳାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରିବ; ଆମ୍ଭେ ଯେଉଁ ପ୍ରତ୍ୟେକ ସ୍ଥାନରେ ଆପଣା ନାମ ସ୍ମରଣ କରାଇବା, ସେହି ପ୍ରତ୍ୟେକ ସ୍ଥାନରେ ଆମ୍ଭେ ତୁମ୍ଭ ନିକଟକୁ ଆସି ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ଯଦି ତୁମ୍ଭେ ଆମ୍ଭ ନିମନ୍ତେ ପ୍ରସ୍ତର ବେଦି ନିର୍ମାଣ କରିବ, ତେବେ ଖୋଦିତ ପ୍ରସ୍ତରରେ ତାହା ନିର୍ମାଣ କରିବ ନାହିଁ; କାରଣ ତହିଁ ଉପରେ ତୁମ୍ଭେ ଆପଣା ଅସ୍ତ୍ର ଉଞ୍ଚାଇଲେ, ତାହା ଅପବିତ୍ର କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ଆଉ ତୁମ୍ଭର ଉଲଙ୍ଗତା ଆମ୍ଭ ବେଦି ଉପରେ ଯେପରି ଅନାବୃତ ନ ହୁଏ, ଏଥିପାଇଁ ତୁମ୍ଭେ ପାହାଚ ଦେଇ ଆମ୍ଭ ବେଦି ଉପରକୁ ଯିବ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ଆଉ ତୁମ୍ଭେ ଏହିସବୁ ନିୟମ ସେମାନଙ୍କୁ ଜ୍ଞାତ କରାଇବ। ଯଥା, ");
INSERT INTO ory_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ତୁମ୍ଭେ ଏବ୍ରୀୟ ଦାସ କ୍ରୟ କଲେ, ସେ ଛଅ ବର୍ଷ ସେବା କରିବ; ପୁଣି, ସପ୍ତମ ବର୍ଷରେ ସେ ବିନାମୂଲ୍ୟରେ ମୁକ୍ତ ହୋଇଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ଯଦି ସେ ଏକାକୀ ଆସିଥାଏ, ତେବେ ସେ ଏକାକୀ ଯିବ; ଆଉ ଯଦି ସେ ବିବାହିତ ହୋଇ ଆସିଥାଏ, ତେବେ ତାହାର ଭାର୍ଯ୍ୟା ତାହା ସଙ୍ଗେ ବାହାରି ଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ପୁଣି, ଯଦି ତାହାର ପ୍ରଭୁ ତାହାକୁ ବିବାହ କରି ଦେଇଥାଏ ଓ ସେହି ସ୍ତ୍ରୀଠାରୁ ପୁତ୍ରକନ୍ୟାର ଜନ୍ମ ହୋଇଥାଏ, ତେବେ ସେହି ସ୍ତ୍ରୀ ଓ ତାହାର ସନ୍ତାନମାନଙ୍କ ଉପରେ ତାହାର ପ୍ରଭୁର ଅଧିକାର ହେବ ଓ ସେ ଏକାକୀ ବାହାରି ଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ମାତ୍ର “ମୁଁ ଆପଣା ପ୍ରଭୁଙ୍କୁ, ପୁଣି, ଆପଣା ଭାର୍ଯ୍ୟା ଓ ସନ୍ତାନଗଣଙ୍କୁ ପ୍ରେମ କରେ, ଏଣୁ ମୁଁ ମୁକ୍ତ ହୋଇଯିବି ନାହିଁ,” ଏପରି କଥା ଯଦି ସେହି ଦାସ ଦୃଢ଼ ରୂପେ କହିବ, ");
INSERT INTO ory_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ତେବେ ତାହାର ପ୍ରଭୁ ତାହାକୁ ପରମେଶ୍ୱରଙ୍କ ନିକଟକୁ ନେଇଯିବ, ପୁଣି, ତାହାକୁ କବାଟ ବା ବାଜୁବନ୍ଧ ନିକଟକୁ ଆଣି ତାହାର ପ୍ରଭୁ ବିନ୍ଧଣୀରେ ତାହାର କର୍ଣ୍ଣ ବିନ୍ଧିବ; ତହିଁରେ ସେ ସଦାକାଳ ତାହାର ସେବା କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ଆଉ କେହି ଯଦି ଆପଣା କନ୍ୟାକୁ ଦାସୀ ରୂପେ ବିକ୍ରୟ କରେ, ତେବେ ସେ ଦାସମାନଙ୍କ ପରି ମୁକ୍ତ ହୋଇଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ତାହାର ପ୍ରଭୁ ତାହାକୁ ଆପଣା ପାଇଁ ନିରୂପଣ କଲେ ହେଁ, ଯଦି ତାହା ପ୍ରତି ଅସନ୍ତୁଷ୍ଟ ହୁଏ, ତେବେ ସେ ତାହାକୁ ମୁକ୍ତ ହେବାକୁ ଦେବ; ତାହା ପ୍ରତି ପ୍ରବଞ୍ଚନା କରିଥିବାରୁ ଅନ୍ୟ ଦେଶୀୟମାନଙ୍କ ନିକଟରେ ତାହାକୁ ବିକ୍ରୟ କରିବାର ଅଧିକାର ପାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","କିଅବା ଯଦି ସେହି ପ୍ରଭୁ ଆପଣା ପୁତ୍ର ନିମନ୍ତେ ତାହାକୁ ନିରୂପଣ କରିଥାଏ, ତେବେ ସେ ତାହା ପ୍ରତି କନ୍ୟା ବିଷୟକ ରୀତି ଅନୁସାରେ ବ୍ୟବହାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ଯଦି ସେ ଅନ୍ୟ ସ୍ତ୍ରୀ ସହିତ ବିବାହ କରେ, ତେବେ ହେଁ ତାହାର ଅନ୍ନ ବସ୍ତ୍ର ଓ ବିବାହୋଚିତ କର୍ତ୍ତବ୍ୟରୁ ବଞ୍ଚିତ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ଯଦି ସେ ଏହି ତିନିର ତ୍ରୁଟି କରେ, ତେବେ ସେ ସ୍ତ୍ରୀ ବିନାମୂଲ୍ୟରେ ମୁକ୍ତ ହୋଇଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","କେହି ଯଦି କୌଣସି ମନୁଷ୍ୟକୁ ଏପରି ପ୍ରହାର କରେ ଯେ ସେ ମରିଯାଏ, ତେବେ ଅବଶ୍ୟ ତାହାର ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ଯଦି କୌଣସି ମନୁଷ୍ୟ କାହାକୁ ମାରିବାକୁ ଚେଷ୍ଟା କରେ ନାହିଁ, ମାତ୍ର ପରମେଶ୍ୱରଙ୍କ ଇଚ୍ଛାରେ ତାହାର ହସ୍ତ ଦ୍ୱାରା ତାହାର ମୃତ୍ୟୁୁ ହୁଏ, ତେବେ ଯେଉଁ ସ୍ଥାନକୁ ସେ ପଳାଇ ପାରେ, ଏପରି ସ୍ଥାନ ଆମ୍ଭେ ତୁମ୍ଭ ପାଇଁ ନିରୂପଣ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ମାତ୍ର ଯଦି କେହି ଛଳନା ପୂର୍ବକ ଆପଣା ପ୍ରତିବାସୀକୁ ବଧ କରିବାକୁ ଦୁଃସାହସ କରେ, ତେବେ ତୁମ୍ଭେ ତାହାର ପ୍ରାଣଦଣ୍ଡ କରିବା ନିମନ୍ତେ ଆମ୍ଭ ବେଦି ନିକଟରୁ ତାହାକୁ ନେଇଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ପୁଣି, ଯେକେହି ଆପଣା ପିତା କିମ୍ବା ମାତାକୁ ପ୍ରହାର କରେ, ତାହାର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ଆଉ ଯେକେହି ମନୁଷ୍ୟକୁ ଚୋରି କରି ଯଦି ବିକ୍ରୟ କରେ, ଅବା ସେ ଯଦି ତାହାର ଅଧିକାରରେ ପ୍ରାପ୍ତ ହୁଏ, ତେବେ ତାହାର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ଯେକେହି ଆପଣା ପିତା କିମ୍ବା ମାତାକୁ ଅଭିଶାପ ଦିଏ, ତାହାର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ଆଉ ଯଦି ଲୋକମାନେ ଏକଆରେକ ସହିତ ବିବାଦ କରୁ କରୁ ଏକ ଜଣ ଅନ୍ୟ ଜଣକୁ ପ୍ରସ୍ତରରେ ବା ମୁଷ୍ଟିରେ ଆଘାତ କଲେ, ସେ ଯଦି ନ ମରି ଶଯ୍ୟାଗତ ହୁଏ ");
INSERT INTO ory_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ଓ ପଶ୍ଚାତ୍‍ ଉଠି ଯଷ୍ଟି ଧରି ବାହାରେ ବୁଲେ, ତେବେ ସେହି ପ୍ରହାରକ ନିର୍ଦ୍ଦୋଷ ହେବ; କେବଳ ତାହାକୁ ତାହାର କର୍ମ-କ୍ଷତିର ଓ ଚିକିତ୍ସାର ବ୍ୟୟ ଦେବାକୁ ପଡ଼ିବ। ");
INSERT INTO ory_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ଆଉ ଯଦି କେହି ଆପଣା ଦାସ ବା ଦାସୀକୁ ଯଷ୍ଟି ଦ୍ୱାରା ପ୍ରହାର କଲେ, ସେ ଯଦି ତାହା ହସ୍ତରେ ମରେ, ତେବେ ସେ ଅବଶ୍ୟ ଦଣ୍ଡନୀୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ମାତ୍ର ସେ ଯଦି ଏକ ବା ଦୁଇ ଦିନ ବଞ୍ଚେ, ତେବେ ସେ ଦଣ୍ଡନୀୟ ହେବ ନାହିଁ; କାରଣ ସେ ତାହାର ଧନ ସ୍ୱରୂପ। ");
INSERT INTO ory_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ଆଉ ଯଦି ପୁରୁଷମାନେ ପରସ୍ପର ବିବାଦ କରୁ କରୁ କୌଣସି ଗର୍ଭବତୀ ସ୍ତ୍ରୀକୁ ପ୍ରହାର କରନ୍ତି ଯଦି ତାହାର ଗର୍ଭପାତ ହୁଏ, ମାତ୍ର ପଶ୍ଚାତ୍‍ ଆଉ କୌଣସି ଆପଦ ନ ଘଟେ, ତେବେ ସେହି ସ୍ତ୍ରୀର ସ୍ୱାମୀ ଯେରୂପ ଦାବି କରିବ, ତଦନୁସାରେ ତାହାର ଅବଶ୍ୟ ଅର୍ଥଦଣ୍ଡ ହେବ, ପୁଣି, ସେ ବିଚାରକର୍ତ୍ତାମାନଙ୍କ ନିର୍ଦ୍ଧାରଣାନୁସାରେ ତାହା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ମାତ୍ର ଯଦି କୌଣସି ଆପଦ ଘଟେ, ତେବେ ତାହାର ପ୍ରାଣ ପରିଶୋଧରେ ପ୍ରାଣ, ");
INSERT INTO ory_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ଚକ୍ଷୁ ପରିଶୋଧରେ ଚକ୍ଷୁ, ଦନ୍ତ ପରିଶୋଧରେ ଦନ୍ତ, ହସ୍ତ ପରିଶୋଧରେ ହସ୍ତ, ଚରଣ ପରିଶୋଧରେ ଚରଣ, ");
INSERT INTO ory_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ଦାହ ପରିଶୋଧରେ ଦାହ, କ୍ଷତ ପରିଶୋଧରେ କ୍ଷତ, ନୋଳା ପରିଶୋଧରେ ନୋଳା, ଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ଆଉ ଯଦି କେହି ଆପଣା ଦାସ କି ଦାସୀର ଚକ୍ଷୁରେ ଆଘାତ କଲେ ଯଦି ତାହା ନଷ୍ଟ ହୁଏ, ତେବେ ସେ ତାହାର ଚକ୍ଷୁ ସକାଶେ ତାହାକୁ ମୁକ୍ତ କରିଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ପୁଣି, ଆଘାତ ଦ୍ୱାରା ଆପଣା ଦାସ କି ଦାସୀର ଦନ୍ତ ଭଗ୍ନ କଲେ, ସେ ସେହି ଦନ୍ତ ସକାଶେ ତାହାକୁ ମୁକ୍ତ କରିଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ଆଉ, ଗୋରୁ କୌଣସି ପୁରୁଷ କିମ୍ବା ସ୍ତ୍ରୀକୁ ବିନ୍ଧିଲେ ଯଦି ସେ ମରେ, ତେବେ ସେହି ଗୋରୁ ପ୍ରସ୍ତର ଦ୍ୱାରା ହତ ହେବ, ପୁଣି, ତାହାର ମାଂସ ଅଖାଦ୍ୟ ହେବ; ମାତ୍ର ଗୋରୁର ସ୍ୱାମୀ ଦଣ୍ଡଯୋଗ୍ୟ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ମାତ୍ର ସେହି ଗୋରୁ ପୂର୍ବେ ବିନ୍ଧୁଥାଏ, ଏଥିର ପ୍ରମାଣ ତାହାର ସ୍ୱାମୀକୁ ଦିଆଗଲେ ହେଁ ତାକୁ ନ ବାନ୍ଧିବା ସକାଶୁ ତାହା ଯଦି କୌଣସି ପୁରୁଷ କିମ୍ବା ସ୍ତ୍ରୀକୁ ବଧ କରେ, ତେବେ ସେହି ଗୋରୁ ପ୍ରସ୍ତର ଦ୍ୱାରା ହତ ହେବ; ପୁଣି, ତାହାର ସ୍ୱାମୀର ମଧ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ଯଦ୍ୟପି ତାହାର (ପ୍ରାଣ) ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ ନିରୂପିତ ହୁଏ, ତେବେ ସେ ପ୍ରାଣମୁକ୍ତି ନିମନ୍ତେ ସମୁଦାୟ ନିରୂପିତ ମୂଲ୍ୟ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ଗୋରୁ ପୁତ୍ରକୁ କି କନ୍ୟାକୁ ବିନ୍ଧିଲେ, ଏହି ଶାସନାନୁସାରେ ଦଣ୍ଡିତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","କାହାର ଗୋରୁ ଯଦି କାହାର ଦାସ କିମ୍ବା ଦାସୀକୁ ବିନ୍ଧେ, ତେବେ ସେ ତାହାର ପ୍ରଭୁଙ୍କୁ ତିରିଶ ଶେକଲ ରୂପା ଦେବ; ଆଉ ଗୋରୁ ପ୍ରସ୍ତର ଦ୍ୱାରା ହତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ଆଉ କେହି ଯଦି କୌଣସି କୂପ ଅନାବୃତ କରେ, କିଅବା କୂପ ଖୋଳି ତାହା ଆବୃତ ନ କରେ, ତେବେ ତହିଁ ଭିତରେ କୌଣସି ଗୋରୁ କି ଗଧ ପଡ଼ିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ସେହି କୂପର କର୍ତ୍ତା ତହିଁର ପରିଶୋଧ କରିବ; ସେ ସେମାନଙ୍କ ସ୍ୱାମୀକୁ ରୂପା ମୂଲ୍ୟ ଦେବ, ମାତ୍ର ମୃତ ପଶୁ ତାହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ଆଉ ଏକ ଜଣର ଗୋରୁ ଅନ୍ୟ ଜଣର ଗୋରୁକୁ ବିନ୍ଧିଲେ ସେହି ଗୋରୁ ଯଦି ମରିଯାଏ, ତେବେ ସେମାନେ ଜୀବିତ ଗୋରୁକୁ ବିକ୍ରୟ କରି ତହିଁର ମୂଲ୍ୟ ଦୁଇ ଭାଗ କରିବେ; ପୁଣି, ମୃତ ଗୋରୁକୁ ମଧ୍ୟ ଦୁଇ ଭାଗ କରି ନେବେ। ");
INSERT INTO ory_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ମାତ୍ର ଗୋରୁ ପୂର୍ବେ ବିନ୍ଧୁଥିବାର ଜାଣି ଯଦି ତାʼର ସ୍ୱାମୀ ତାକୁ ସାବଧାନରେ ରଖି ନ ଥାଏ, ତେବେ ସେ ଗୋରୁ ପରିଶୋଧରେ ଗୋରୁ ଅବଶ୍ୟ ଦେବ, ମାତ୍ର ମୃତ ଗୋରୁ ତାହାର ନିଜର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ଯଦି କେହି ଗୋରୁ କି ମେଷ ଚୋରି କରି ବଧ କରେ ଅବା ବିକ୍ରୟ କରେ, ତେବେ ସେ ଏକ ଗୋରୁ ପରିଶୋଧରେ ପାଞ୍ଚ ଗୋରୁ ଓ ଏକ ମେଷ ପରିଶୋଧରେ ଚାରି ମେଷ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ଆଉ ଚୋର ସିନ୍ଧି କାଟିଧରା ପଡ଼ିଲେ, ଯଦି କେହି ତାହାକୁ ମାରୁ ମାରୁ ମାରି ପକାଏ, ତେବେ ସେ ରକ୍ତପାତର ଦୋଷୀ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ମାତ୍ର ଯଦି ସୂର୍ଯ୍ୟୋଦୟ ଉତ୍ତାରେ ତାହାକୁ ବଧ କରେ, ତେବେ ସେ ରକ୍ତପାତର ଦୋଷୀ ହେବ; ଆଉ ଚୋରା ଦ୍ରବ୍ୟ ପରିଶୋଧ କରିବା ଚୋରର କର୍ତ୍ତବ୍ୟ; ଯଦି ତାହାର କିଛି ନ ଥାଏ, ତେବେ ଚୋରି ସକାଶୁ ସେ ବିକ୍ରି ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ଗୋରୁ ଅବା ଗର୍ଦ୍ଦଭ କି ମେଷାଦି ଚୋରା ଦ୍ରବ୍ୟ ଯଦି ଚୋର ହସ୍ତରେ ଜୀବିତ ମିଳେ, ତେବେ ସେ ତହିଁର ଦୁଇଗୁଣ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ଆଉ କେହି ଯଦି ଅନ୍ୟର କ୍ଷେତ୍ରରେ କି ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରରେ ଗୋରୁ ଚରାଏ, କିଅବା ଆପଣା ପଶୁକୁ ଛାଡ଼ିଦେଲେ ଯଦି ସେ ଅନ୍ୟର କ୍ଷେତ୍ରରେ ଚରେ, ତେବେ ସେ ଲୋକ ତହିଁର ପରିବର୍ତ୍ତେ ତାହାକୁ ଆପଣା କ୍ଷେତ୍ରର ଉତ୍ତମ ଶସ୍ୟ ଅବା ଆପଣା ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରର ଉତ୍ତମ ଫଳ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ଆଉ ଅଗ୍ନି ଜ୍ୱଳି କଣ୍ଟକ ବନରେ ଲାଗିଲେ ଯଦି କାହାର କଳେଇ ଗଦା ଅବା ବଢ଼ନ୍ତା ଶସ୍ୟ କି କ୍ଷେତ ପୋଡ଼ିଯାଏ, ତେବେ ସେହି ଅଗ୍ନି ଲଗାଇବା ଲୋକ ଅବଶ୍ୟ ତହିଁର ମୂଲ୍ୟ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ଆଉ, କେହି ଯଦି ଆପଣା ପ୍ରତିବାସୀ ନିକଟରେ ମୁଦ୍ରା ଅବା ଆଉ କୌଣସି ଦ୍ରବ୍ୟ ରଖିବା ପାଇଁ ସମର୍ପଣ କରେ, ତାହା ଯଦି କେହି ସେହି ମନୁଷ୍ୟର ଗୃହରୁ ଚୋରି କରେ ଓ ସେହି ଚୋର ଧରା ପଡ଼େ, ତେବେ ସେ ତହିଁର ଦୁଇଗୁଣ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ଯଦି ଚୋର ଧରା ନ ପଡ଼େ, ତେବେ ଗୃହର ସ୍ୱାମୀ ପ୍ରତିବାସୀର ଦ୍ରବ୍ୟରେ ହସ୍ତ ଦେଇଅଛି କି ନାହିଁ, ଏହା ଜଣା ଯିବା ନିମନ୍ତେ ସେ ପରମେଶ୍ୱରଙ୍କ ସାକ୍ଷାତରେ ଉପସ୍ଥିତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ପୁଣି, ସର୍ବପ୍ରକାର ଅଧର୍ମ ବିଷୟରେ, ଅର୍ଥାତ୍‍, ଗୋରୁ, ଗର୍ଦ୍ଦଭ, ମେଷ କିଅବା ବସ୍ତ୍ରାଦି, ଯେକୌଣସି ହଜିଲା ଦ୍ରବ୍ୟ ବିଷୟରେ ଯଦି କେହି କହେ, “ଏହା ସେହି ଦ୍ରବ୍ୟ,” ତେବେ ଉଭୟ ପକ୍ଷର କଥା ପରମେଶ୍ୱରଙ୍କ ସାକ୍ଷାତରେ ଉପସ୍ଥିତ ହେବ; ତହିଁରେ ପରମେଶ୍ୱର ଯାହାକୁ ଦୋଷୀ କରିବେ, ସେ ଆପଣା ପ୍ରତିବାସୀକୁ ଦୁଇଗୁଣ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ଆଉ ଯଦି କେହି ପ୍ରତିବାସୀ ନିକଟରେ ଆପଣା ଗଧ, ଗୋରୁ, ମେଷ, କିଅବା କୌଣସି ପଶୁ ପ୍ରତିପାଳନାର୍ଥେ ରଖନ୍ତି ପୁଣି, ଯଦି କାହାରି ନ ଦେଖିବାରେ ସେହି ପଶୁ ମରେ, ଅବା ଭଗ୍ନାଙ୍ଗ ହୁଏ କିଅବା ଅଡ଼ାଇ ନିଆଯାଏ, ");
INSERT INTO ory_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ତେବେ ସେ ପ୍ରତିବାସୀର ଦ୍ରବ୍ୟରେ ହସ୍ତ ଦେଇଅଛି କି ନାହିଁ, ଏ ବିଷୟରେ ଉଭୟଙ୍କ ମଧ୍ୟରେ ସଦାପ୍ରଭୁଙ୍କର ଶପଥ ହେବ; ପଶୁର ମାଲିକ ସେହି ଶପଥ ଗ୍ରହଣ କରିବ, ପୁଣି, ସେ ପରିଶୋଧ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ମାତ୍ର ଯଦି ତାହା ନିକଟରୁ ଚୋରି ହୋଇଅଛି, ତେବେ ସେ ତାହାର ମାଲିକକୁ ତାହାର ମୂଲ୍ୟ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ଯଦି ସେହି ପଶୁ ବିଦୀର୍ଣ୍ଣ ହୁଏ, ତେବେ ସେ ପ୍ରମାଣ ନିମନ୍ତେ ତାହା ଆଣୁ; ସେ ସେହି ବିଦୀର୍ଣ୍ଣ ପଶୁର ମୂଲ୍ୟ ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ଆଉ, କେହି ଯଦି ଆପଣା ପ୍ରତିବାସୀର ପଶୁ ମାଗି ନିଏ ଓ ତାହାର ମାଲିକ ତାହା ସହିତ ନ ଥାଇ ସେ ଭଗ୍ନାଙ୍ଗ ହୁଏ କି ମରେ, ତେବେ ସେ ନିତାନ୍ତ ତାହାର ମୂଲ୍ୟ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ମାତ୍ର ଯଦି ତାହାର ମାଲିକ ତାହା ନିକଟରେ ଥାଏ, ତେବେ ତାହାର ମୂଲ୍ୟ ଦେବ ନାହିଁ; ଯଦି ସେ ଭଡ଼ାଟିଆ ପଶୁ ହୁଏ, ତେବେ ତାହା ଭଡ଼ା ମଧ୍ୟରେ ଆସିବ। ");
INSERT INTO ory_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ଆଉ, କେହି ଯଦି ଅବାଗ୍‍ଦତ୍ତା କନ୍ୟାକୁ ପ୍ରଲୋଭିତ କରି ତାହା ସହିତ ଶୟନ କରେ, ତେବେ ସେ ତାହାକୁ କନ୍ୟା ମୂଲ୍ୟ ଦେଇ ଅବଶ୍ୟ ବିବାହ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ଯଦି ପିତା ତାହା ସହିତ ଆପଣା କନ୍ୟାର ବିବାହ ଦେବାକୁ ନିତାନ୍ତ ଅସମ୍ମତ ହୁଏ, ତେବେ ସେ କନ୍ୟା ମୂଲ୍ୟର ବ୍ୟବସ୍ଥାନୁସାରେ ରୂପା ତୌଲି ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","ତୁମ୍ଭେ ମାୟାବିନୀକୁ ଜୀବିତା ରଖିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","ଯେକେହି ପଶୁ ସହିତ ଯୌନ ସମ୍ପର୍କ ରଖେ, ତାହାର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","ଯେଉଁ ଲୋକ କେବଳ ସଦାପ୍ରଭୁଙ୍କ ବିନା କୌଣସି ଦେବତା ନିକଟରେ ବଳିଦାନ କରେ, ସେ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ବିନଷ୍ଟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","ତୁମ୍ଭେ ବିଦେଶୀ ପ୍ରତି ଅନ୍ୟାୟ ଓ ତାହା ପ୍ରତି ଉପଦ୍ରବ କରିବ ନାହିଁ, ଯେହେତୁ ତୁମ୍ଭେମାନେ ମିସର ଦେଶରେ ବିଦେଶୀ ଥିଲ। ");
INSERT INTO ory_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ତୁମ୍ଭେମାନେ କୌଣସି ବିଧବା କି ପିତୃହୀନ ସନ୍ତାନକୁ କ୍ଲେଶ ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ତୁମ୍ଭେ ସେମାନଙ୍କୁ କୌଣସି ପ୍ରକାରେ କ୍ଲେଶ ଦେଲେ, ସେମାନେ ଯଦି ଆମ୍ଭ ନିକଟରେ ଖାଲି ଡାକ ପକାଇବେ, ତେବେ ଆମ୍ଭେ ଅବଶ୍ୟ ସେମାନଙ୍କର ଡାକ ଶୁଣିବା। ");
INSERT INTO ory_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ପୁଣି, ଆମ୍ଭର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲେ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଖଡ୍ଗ ଦ୍ୱାରା ମାରିବା; ତହିଁରେ ତୁମ୍ଭମାନଙ୍କର ଭାର୍ଯ୍ୟାମାନେ ବିଧବା ହେବେ ଓ ସନ୍ତାନଗଣ ପିତୃହୀନ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ତୁମ୍ଭେ ଯଦି ଆମ୍ଭ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ତୁମ୍ଭର ପ୍ରତିବାସୀ କୌଣସି ଦରିଦ୍ର ଲୋକଙ୍କୁ ଋଣ ଦିଅ, ତେବେ ତାହା ପ୍ରତି ମହାଜନ ତୁଲ୍ୟ ହେବ ନାହିଁ ଓ ତାହାଠାରୁ ସୁଧ ନେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ଯଦି ତୁମ୍ଭେ ଆପଣା ପ୍ରତିବାସୀର ବସ୍ତ୍ର ବନ୍ଧକ ରଖିବ, ତେବେ ତୁମ୍ଭେ ସୂର୍ଯ୍ୟାସ୍ତ ପୂର୍ବେ ତାହା ତାହାକୁ ଫେରାଇ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","କାରଣ ତାହା ତାହାର ଏକମାତ୍ର ଆଚ୍ଛାଦନ ଓ ଚର୍ମ ଆଚ୍ଛାଦକ ବସ୍ତ୍ର; ସେ କାହିଁରେ ଶୟନ କରିବ? ପୁଣି, ସେ ଯଦି ଆମ୍ଭ ନିକଟରେ ଡାକ ପକାଇବ, ତେବେ ଆମ୍ଭେ ତାହା ଶୁଣିବା, କାରଣ ଆମ୍ଭେ କୃପାବାନ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","ତୁମ୍ଭେ ଆପଣା ପରମେଶ୍ୱରଙ୍କୁ ଅବଜ୍ଞା କରିବ ନାହିଁ, ପୁଣି, ଆପଣା ଲୋକମାନଙ୍କର ଅଧ୍ୟକ୍ଷଙ୍କୁ ଅଭିଶାପ ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","ତୁମ୍ଭେ ଆପଣା ଶସ୍ୟର ପୂର୍ଣ୍ଣତାରୁ ଓ (ଫଳାଦିର) ରସରୁ ଉତ୍ସର୍ଗ କରିବାକୁ ବିଳମ୍ବ କରିବ ନାହିଁ। ତୁମ୍ଭେ ଆପଣା ପ୍ରଥମଜାତ ପୁତ୍ରମାନଙ୍କୁ ଆମ୍ଭଙ୍କୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ପୁଣି, ଆପଣା ଗୋରୁ ଓ ମେଷାଦି ପ୍ରତି ତଦ୍ରୂପ କରିବ; ସେ ସାତ ଦିନ ଆପଣା ମାତା ସହିତ ରହିବ, ଅଷ୍ଟମ ଦିନରେ ତୁମ୍ଭେ ତାହା ଆମ୍ଭଙ୍କୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","ପୁଣି, ତୁମ୍ଭେମାନେ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ଲୋକ ହେବ; ଏନିମନ୍ତେ ପଶୁ ଦ୍ୱାରା କ୍ଷେତ୍ରରେ ବିଦୀର୍ଣ୍ଣ ମାଂସ ଖାଇବ ନାହିଁ; ତୁମ୍ଭେମାନେ ତାହା କୁକ୍କୁରମାନଙ୍କ ଆଗରେ ପକାଇ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","ତୁମ୍ଭେ ମିଥ୍ୟାପବାଦ ଉତ୍ଥାପନ କରିବ ନାହିଁ; ଅନ୍ୟାୟ ସାକ୍ଷୀ ହୋଇ ଦୁଷ୍ଟର ସାହାଯ୍ୟ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ତୁମ୍ଭେ ଦୁଷ୍କର୍ମ କରିବାକୁ ବହୁ ଲୋକର ପଶ୍ଚାଦ୍‍ବର୍ତ୍ତୀ ହେବ ନାହିଁ, ପୁଣି, ନ୍ୟାୟବିଚାର ଅନ୍ୟଥା କରିବା ପାଇଁ ବହୁ ଲୋକର ପକ୍ଷ ହୋଇ ପ୍ରତିବାଦ କରିବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","କିଅବା ବିଚାରରେ ଦରିଦ୍ରର ପକ୍ଷପାତ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","ତୁମ୍ଭେ ଆପଣା ଶତ୍ରୁର ଗୋରୁ କି ଗଧକୁ ପଥ ହୁଡ଼ି ଯିବାର ଦେଖିଲେ, ଅବଶ୍ୟ ତାହା ନିକଟକୁ ତାକୁ ଘେନିଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ଯଦି ତୁମ୍ଭେ ଆପଣା ଶତ୍ରୁର ଗର୍ଦ୍ଦଭକୁ ଭାର ତଳେ ପଡ଼ିଥିବାର ଦେଖ, ତାକୁ ଛାଡ଼ି ଯିବାରୁ ନିବୃତ୍ତ ହୁଅ, ତୁମ୍ଭେ ଅବଶ୍ୟ ତାହା ସଙ୍ଗରେ ତାକୁ ମୁକ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","ଦରିଦ୍ରର ବିଚାରରେ ତୁମ୍ଭେ ତାହା ପ୍ରତି ଅନ୍ୟାୟ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ମିଥ୍ୟା ବିଷୟରୁ ଆପଣାକୁ ଦୂରରେ ରଖ; ପୁଣି, ନିର୍ଦ୍ଦୋଷକୁ ଓ ଧାର୍ମିକକୁ ନଷ୍ଟ କର ନାହିଁ; ଯେହେତୁ ଆମ୍ଭେ ଦୁଷ୍ଟକୁ ନିର୍ଦ୍ଦୋଷ କରିବା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ତୁମ୍ଭେ ଲାଞ୍ଚ ନେବ ନାହିଁ, କାରଣ ଲାଞ୍ଚ ଦୃଷ୍ଟି ଥିବା ଲୋକମାନଙ୍କୁ ଅନ୍ଧ କରିଦିଏ ଓ ଧାର୍ମିକମାନଙ୍କର ବାକ୍ୟ ଅନ୍ୟଥା କରେ। ");
INSERT INTO ory_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","ତୁମ୍ଭେ ବିଦେଶୀ ପ୍ରତି ଅତ୍ୟାଚାର କରିବ ନାହିଁ, କାରଣ ତୁମ୍ଭେ ବିଦେଶୀର ମନ ଜାଣୁଅଛ, ଯେହେତୁ ତୁମ୍ଭେମାନେ ମିସର ଦେଶରେ ବିଦେଶୀ ଥିଲ। ");
INSERT INTO ory_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ଆଉ ତୁମ୍ଭେ ଆପଣା ଭୂମିରେ ଛଅ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ବୀଜ ବପନ କରିବ ଓ ତହିଁରୁ ଉତ୍ପନ୍ନ ଶସ୍ୟାଦି ସଂଗ୍ରହ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ମାତ୍ର ସପ୍ତମ ବର୍ଷରେ ତାକୁ ବିଶ୍ରାମ ଦେବ ଓ ପଡ଼ିଆ ରଖିବ; ତହିଁରେ ତୁମ୍ଭର ଦରିଦ୍ରମାନେ ଖାଇବାକୁ ପାଇବେ; ସେମାନେ ଯାହା ଅବଶିଷ୍ଟ ରଖିବେ, ତାହା ବନ ପଶୁମାନେ ଖାଇବେ। ପୁଣି, ତୁମ୍ଭ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ର ଓ ଜୀତବୃକ୍ଷ ପ୍ରତି ମଧ୍ୟ ସେହିରୂପ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ତୁମ୍ଭେ ଛଅ ଦିନ ଆପଣା କର୍ମ କରି ସପ୍ତମ ଦିନରେ ବିଶ୍ରାମ କରିବ, ତହିଁରେ ତୁମ୍ଭର ଗୋରୁ ଓ ଗର୍ଦ୍ଦଭ ବିଶ୍ରାମ ପାଇବେ, ପୁଣି, ତୁମ୍ଭ ଦାସୀପୁତ୍ର ଓ ବିଦେଶୀ ଲୋକ ଆଶ୍ୱାସ ପାଇବେ। ");
INSERT INTO ory_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯାହା ଯାହା କହିଅଛୁ, ସେସମସ୍ତ ବିଷୟରେ ସାବଧାନ ହୁଅ; ଅନ୍ୟ ଦେବଗଣର ନାମ ସ୍ମରଣ କରାଅ ନାହିଁ, କିଅବା ତୁମ୍ଭମାନଙ୍କ ମୁଖରୁ ତାହା ଶୁଣା ନ ଯାଉ। ");
INSERT INTO ory_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ତୁମ୍ଭେ ବର୍ଷ ମଧ୍ୟରେ ତିନି ଥର ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସବ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ଉତ୍ସବ ପାଳନ କରିବ; ଆମ୍ଭ ଆଜ୍ଞାନୁସାରେ ଆବୀବ୍‍ ମାସର ନିରୂପିତ ସମୟରେ ସାତ ଦିନ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଭୋଜନ କରିବ, ଯେହେତୁ ତୁମ୍ଭେ ସେହି ସମୟରେ ମିସର ଦେଶରୁ ମୁକ୍ତି ପାଇଅଛ; ପୁଣି, କେହି ରିକ୍ତ ହସ୍ତରେ ଆମ୍ଭ ନିକଟରେ ଉପସ୍ଥିତ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","ଆଉ, ତୁମ୍ଭେ ଶସ୍ୟଚ୍ଛେଦନ ଉତ୍ସବ, ଅର୍ଥାତ୍‍, କ୍ଷେତରେ ଯାହା ବୁଣ, ତହିଁର ପ୍ରଥମ ସଂଗୃହୀତ ଫଳର ଉତ୍ସବ ପାଳନ କର; ପୁଣି, ବର୍ଷ ଶେଷରେ କ୍ଷେତରୁ ଫଳ ସଂଗ୍ରହ କରିବା ସମୟରେ ଫଳ ସଞ୍ଚୟର ଉତ୍ସବ ପାଳନ କର। ");
INSERT INTO ory_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ବର୍ଷ ମଧ୍ୟରେ ତିନି ଥର ତୁମ୍ଭର ସମସ୍ତ ପୁଂଜାତି, ପ୍ରଭୁ ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ଉପସ୍ଥିତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","ତୁମ୍ଭେ ତାଡ଼ିଯୁକ୍ତ ଦ୍ରବ୍ୟ ସହିତ ଆମ୍ଭ ବଳିର ରକ୍ତ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ; ପୁଣି, ଆମ୍ଭ ଉତ୍ସବ-ସମ୍ପର୍କୀୟ ମେଦ ରାତ୍ରିଯାକ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ରଖିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ତୁମ୍ଭ ଭୂମିର ପ୍ରଥମଜାତ ଫଳ ତୁମ୍ଭ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଗୃହକୁ ଆଣିବ। ତୁମ୍ଭେ ଛାଗବତ୍ସକୁ ତାହାର ମାତୃ ଦୁଗ୍ଧରେ ପାକ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ପଥରେ ରକ୍ଷା କରିବା ପାଇଁ ଓ ତୁମ୍ଭକୁ ଆମ୍ଭର ପ୍ରସ୍ତୁତ ସ୍ଥାନକୁ ଆଣିବା ପାଇଁ ତୁମ୍ଭ ଆଗେ ଆଗେ ଏକ ଦୂତ ପ୍ରେରଣ କରୁଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ତାହାଙ୍କ ବିଷୟରେ ସାବଧାନ ହୁଅ ଓ ତାହାଙ୍କ ରବରେ ଅବଧାନ କର; ତାହାଙ୍କର ଅସନ୍ତୋଷ ଜନ୍ମାଅ ନାହିଁ; କାରଣ ସେ ତୁମ୍ଭମାନଙ୍କ ଅଧର୍ମ କ୍ଷମା କରିବେ ନାହିଁ; ଯେହେତୁ ତାହାଙ୍କଠାରେ ଆମ୍ଭର ନାମ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ମାତ୍ର ତୁମ୍ଭେ ଯଦି ନିତାନ୍ତ ତାହାଙ୍କ ରବରେ ମନୋଯୋଗ କରିବ, ପୁଣି, ଆମ୍ଭେ ଯାହାସବୁ କହୁ, ତାହା କରିବ; ତେବେ ଆମ୍ଭେ ତୁମ୍ଭ ଶତ୍ରୁମାନଙ୍କର ଶତ୍ରୁ ଓ ତୁମ୍ଭ ବୈରୀମାନଙ୍କର ବୈରୀ ହେବା। ");
INSERT INTO ory_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","କାରଣ ଆମ୍ଭର ଦୂତ ତୁମ୍ଭ ଆଗେ ଆଗେ ଯାଇ ତୁମ୍ଭକୁ ଇମୋରୀୟ, ହିତ୍ତୀୟ, ପରିଷୀୟ, କିଣାନୀୟ, ହିବ୍ବୀୟ ଓ ଯିବୂଷୀୟମାନଙ୍କ ଦେଶକୁ ଆଣିବେ, ପୁଣି, ଆମ୍ଭେ ସେମାନଙ୍କୁ ଉଚ୍ଛିନ୍ନ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ତୁମ୍ଭେ ସେମାନଙ୍କ ଦେବଗଣକୁ ପ୍ରଣାମ କରିବ ନାହିଁ ଓ ସେମାନଙ୍କର ସେବା କରିବ ନାହିଁ, ପୁଣି, ସେମାନଙ୍କ କ୍ରିୟାନୁସାରେ କ୍ରିୟା କରିବ ନାହିଁ; ମାତ୍ର ସେମାନଙ୍କୁ ସମୂଳେ ଉତ୍ପାଟନ କରିବ ଓ ସେମାନଙ୍କ ସ୍ତମ୍ଭସବୁ ଭାଙ୍ଗି ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କର ସେବା କରିବ; ତହିଁରେ ସେ ତୁମ୍ଭମାନଙ୍କ ଅନ୍ନ ଓ ଜଳରେ ଆଶୀର୍ବାଦ କରିବେ, ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭ ମଧ୍ୟରୁ ରୋଗ ଦୂର କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ତୁମ୍ଭ ଦେଶରେ କାହାରି ଗର୍ଭପାତ ହେବ ନାହିଁ, ପୁଣି, କେହି ବନ୍ଧ୍ୟା ହେବ ନାହିଁ; ଆମ୍ଭେ ତୁମ୍ଭ ଆୟୁର ପରିମାଣ ପୂର୍ଣ୍ଣ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ଆମ୍ଭେ ତୁମ୍ଭ ଆଗେ ଆଗେ ଆମ୍ଭ ବିଷୟକ ଭୟ ପ୍ରେରଣ କରିବା; ପୁଣି, ତୁମ୍ଭେ ଯେଉଁସବୁ ଲୋକଙ୍କ ନିକଟରେ ଉପସ୍ଥିତ ହେବ, ସେମାନଙ୍କୁ ବ୍ୟାକୁଳ କରିବା ଓ ଆମ୍ଭେ ତୁମ୍ଭର ଶତ୍ରୁଗଣକୁ ବିମୁଖ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ଆମ୍ଭେ ତୁମ୍ଭ ଆଗେ ଆଗେ ବିରୁଡ଼ିମାନଙ୍କୁ ପଠାଇବା; ସେମାନେ ହିବ୍ବୀୟ, କିଣାନୀୟ ଓ ହିତ୍ତୀୟମାନଙ୍କୁ ତୁମ୍ଭ ସମ୍ମୁଖରୁ ଘଉଡ଼ାଇ ଦେବେ। ");
INSERT INTO ory_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ମାତ୍ର ଏକ ବର୍ଷରେ ତୁମ୍ଭ ସମ୍ମୁଖରୁ ସେମାନଙ୍କୁ ଘଉଡ଼ାଇ ଦେବା ନାହିଁ, ତାହାହେଲେ ଦେଶ ଶୂନ୍ୟ ହୋଇଯିବ ଓ ତୁମ୍ଭ ପ୍ରତିକୂଳରେ ବନ୍ୟ ପଶୁମାନଙ୍କ ସଂଖ୍ୟା ବୃଦ୍ଧି ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ତୁମ୍ଭେ ଯେପର୍ଯ୍ୟନ୍ତ ବର୍ଦ୍ଧିତ ହୋଇ ନାହଁ ଓ ଦେଶ ଅଧିକାର କରି ନାହଁ, ସେପର୍ଯ୍ୟନ୍ତ ଆମ୍ଭେ ତୁମ୍ଭ ସମ୍ମୁଖରୁ ସେମାନଙ୍କୁ କ୍ରମେ କ୍ରମେ ଘଉଡ଼ାଇ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ପୁଣି, ଆମ୍ଭେ ସୂଫ ସାଗରଠାରୁ ପଲେଷ୍ଟୀୟମାନଙ୍କର ସମୁଦ୍ର ପର୍ଯ୍ୟନ୍ତ ଓ ପ୍ରାନ୍ତରଠାରୁ ଫରାତ୍‍ ନଦୀ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭର ସୀମା ନିରୂପଣ କରିବା; କାରଣ ଆମ୍ଭେ ସେହି ଦେଶ ନିବାସୀମାନଙ୍କୁ ତୁମ୍ଭ ହସ୍ତରେ ସମର୍ପଣ କରିବା; ତହିଁରେ ତୁମ୍ଭେ ଆପଣା ସମ୍ମୁଖରୁ ସେମାନଙ୍କୁ ଘଉଡ଼ାଇ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ତୁମ୍ଭେ ସେମାନଙ୍କ ସହିତ କିମ୍ବା ସେମାନଙ୍କ ଦେବଗଣ ସହିତ କୌଣସି ନିୟମ ସ୍ଥିର କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ସେମାନେ ତୁମ୍ଭ ଦେଶରେ ବାସ କରିବେ ନାହିଁ, କଲେ ସେମାନେ ଆମ୍ଭ ବିରୁଦ୍ଧରେ ତୁମ୍ଭକୁ ପାପ କରାଇବେ; ଯେହେତୁ ତୁମ୍ଭେ ଯଦି ସେମାନଙ୍କ ଦେବଗଣର ସେବା କର, ତେବେ ତାହା ଅବଶ୍ୟ ତୁମ୍ଭର ଫାନ୍ଦ ସ୍ୱରୂପ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ଏଥିଉତ୍ତାରେ ସେ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ, ହାରୋଣ, ନାଦବ୍‍, ଅବୀହୂ ଓ ଇସ୍ରାଏଲର ପ୍ରାଚୀନବର୍ଗର ସତୁରି ଜଣ, ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟକୁ ଆରୋହଣ କରି ଆସି ଦୂରରେ ରହି ତାହାଙ୍କର ଭଜନା କର। ");
INSERT INTO ory_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","କେବଳ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ନିକଟକୁ ଆସିବ, ମାତ୍ର ସେମାନେ ନିକଟକୁ ଆସିବେ ନାହିଁ, କିଅବା ଲୋକମାନେ ତାହା ସଙ୍ଗେ ଆରୋହଣ କରିବେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ତେବେ ମୋଶା ଆସି ସଦାପ୍ରଭୁଙ୍କର ସେହି ସବୁ ବାକ୍ୟ ଓ ନିୟମ ବିଷୟ ଲୋକମାନଙ୍କୁ କହନ୍ତେ, ସମସ୍ତେ ଏକସ୍ୱରରେ ଉତ୍ତର କଲେ, “ସଦାପ୍ରଭୁ ଯେଉଁସବୁ କଥା କହିଅଛନ୍ତି, ତାହାସବୁ ଆମ୍ଭେମାନେ ପାଳନ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ଏଥିଉତ୍ତାରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କର ସମସ୍ତ ବାକ୍ୟ ଲେଖିଲେ, ପୁଣି, ପ୍ରଭାତରେ ଉଠି ପର୍ବତ ତଳେ ଗୋଟିଏ ଯଜ୍ଞବେଦି ଓ ଇସ୍ରାଏଲର ଦ୍ୱାଦଶ ବଂଶାନୁସାରେ ଦ୍ୱାଦଶ ସ୍ତମ୍ଭ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ଆଉ, ସେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଯୁବାମାନଙ୍କୁ ପଠାନ୍ତେ, ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମାର୍ଥେ ଓ ମଙ୍ଗଳାର୍ଥେ ବୃଷମାନଙ୍କୁ ବଳିଦାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ତହୁଁ ମୋଶା ରକ୍ତ ଘେନି ତହିଁର ଅର୍ଦ୍ଧେକ ପାତ୍ରରେ ରଖିଲେ, ଆଉ ଅର୍ଦ୍ଧେକ ରକ୍ତ ବେଦି ଉପରେ ସେଚନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ପୁଣି, ନିୟମ-ପୁସ୍ତକ ନେଇ ଲୋକମାନଙ୍କ କର୍ଣ୍ଣଗୋଚରରେ ପାଠ କଲେ; ତହିଁରେ ସେମାନେ କହିଲେ, “ସଦାପ୍ରଭୁ ଯାହା ଯାହା କହିଅଛନ୍ତି, ତାହାସବୁ ଆମ୍ଭେମାନେ ପାଳନ କରିବା ଓ ଆଜ୍ଞାବହ ହେବା।” ");
INSERT INTO ory_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ତହୁଁ ମୋଶା ସେହି ରକ୍ତ ଘେନି ଲୋକମାନଙ୍କ ଉପରେ ସେଚନ କରି କହିଲେ, “ଦେଖ, ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ସହିତ ଏହି ସମସ୍ତ ବାକ୍ୟ ସମ୍ବନ୍ଧୀୟ ଯେଉଁ ନିୟମ କରିଅଛନ୍ତି, ସେହି ନିୟମର ରକ୍ତ ଏହି।” ");
INSERT INTO ory_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ତେବେ ମୋଶା, ହାରୋଣ, ନାଦବ୍‍, ଅବୀହୂ ଓ ଇସ୍ରାଏଲର ପ୍ରାଚୀନବର୍ଗର ସତୁରି ଜଣ ଆରୋହଣ କଲେ; ଆଉ ସେମାନେ ଇସ୍ରାଏଲର ପରମେଶ୍ୱରଙ୍କୁ ଦର୍ଶନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ପୁଣି, ତାହାଙ୍କ ଚରଣତଳ ସ୍ଥାନ ଉଜ୍ଜ୍ୱଳ ନୀଳକାନ୍ତମଣି ନିର୍ମିତ କାର୍ଯ୍ୟ ତୁଲ୍ୟ ଓ ନିର୍ମଳତାରେ ଠିକ୍ ଆକାଶ ପରି ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ଆଉ ସେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଅଧ୍ୟକ୍ଷମାନଙ୍କ ବିରୁଦ୍ଧରେ ହସ୍ତ ବିସ୍ତାର କଲେ ନାହିଁ; ମାତ୍ର ସେମାନେ ପରମେଶ୍ୱରଙ୍କୁ ଦର୍ଶନ କଲେ, ପୁଣି, ଭୋଜନ ଓ ପାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ପର୍ବତ ଆରୋହଣ କରି ଆମ୍ଭ ନିକଟକୁ ଆସି ଏହି ସ୍ଥାନରେ ଥାଅ; ତହିଁରେ ଆମ୍ଭେ ଲୋକମାନଙ୍କ ଶିକ୍ଷା ନିମନ୍ତେ ଯାହା ଲେଖିଅଛୁ, ତାହା, ଅର୍ଥାତ୍‍, ବ୍ୟବସ୍ଥା ଓ ଆଜ୍ଞା ସମ୍ବନ୍ଧୀୟ ଦୁଇ ଖଣ୍ଡ ପ୍ରସ୍ତର ଫଳକ ତୁମ୍ଭକୁ ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ତହିଁରେ ମୋଶା ଓ ତାଙ୍କର ପରିଚାରକ ଯିହୋଶୂୟ ଉଠିଲେ; ପୁଣି, ମୋଶା ପରମେଶ୍ୱରଙ୍କ ପର୍ବତରେ ଆରୋହଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ଆଉ ସେ ପ୍ରାଚୀନବର୍ଗଙ୍କୁ କହିଲେ, “ଆମ୍ଭେମାନେ ଯେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭ ନିକଟକୁ ବାହୁଡ଼ି ନ ଆସୁ, ସେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେମାନେ ଆମ୍ଭମାନଙ୍କ ଅପେକ୍ଷାରେ ଏହିଠାରେ ଥାଅ; ଦେଖ, ହାରୋଣ ଓ ହୂର ତୁମ୍ଭମାନଙ୍କ ନିକଟରେ ଅଛନ୍ତି, କାହାରି କୌଣସି ବିବାଦର କଥା ଉପସ୍ଥିତ ହେଲେ, ସେ ସେମାନଙ୍କ ନିକଟକୁ ଯାଉ।” ");
INSERT INTO ory_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ଏଉତ୍ତାରେ ମୋଶା ପର୍ବତରେ ଚଢ଼ିଲେ, ପୁଣି, ମେଘ ପର୍ବତକୁ ଆଚ୍ଛାଦନ କଲା। ");
INSERT INTO ory_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ତହିଁରେ ସୀନୟ ପର୍ବତ ଉପରେ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତାପ ଅବସ୍ଥିତି କଲା; ଆଉ ତାହା ଛଅ ଦିନ ମେଘାଚ୍ଛନ୍ନ ହୋଇ ରହିଲା; ତହିଁ ଉତ୍ତାରେ ସେ ସପ୍ତମ ଦିନ ମେଘ ମଧ୍ୟରୁ ମୋଶାଙ୍କୁ ଡାକିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଦୃଷ୍ଟିରେ ପର୍ବତ ଶୃଙ୍ଗରେ ଗ୍ରାସକାରୀ ଅଗ୍ନି ତୁଲ୍ୟ ସଦାପ୍ରଭୁଙ୍କର ପ୍ରତାପ ପ୍ରକାଶିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ପୁଣି, ମୋଶା ମେଘ ମଧ୍ୟରେ ପ୍ରବେଶ କରି ପର୍ବତ ଉପରେ ଉଠି ଚାଳିଶ ଦିବାରାତ୍ର ସେହି ପର୍ବତ ଉପରେ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଆମ୍ଭ ନିମନ୍ତେ ଉପହାର ସଂଗ୍ରହ କରିବାକୁ କୁହ; ଯାହାର ହୃଦୟ ଯାହାକୁ ଇଚ୍ଛୁକ କରାଏ, ତାହାଠାରୁ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ସେହି ଉପହାର ଗ୍ରହଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ଅର୍ଥାତ୍‍, ସ୍ୱର୍ଣ୍ଣ, ରୌପ୍ୟ ଓ ପିତ୍ତଳ; ");
INSERT INTO ory_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ପୁଣି, ନୀଳବର୍ଣ୍ଣ, ଧୂମ୍ରବର୍ଣ୍ଣ, ସିନ୍ଦୂର ବର୍ଣ୍ଣ, ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର, ଛାଗର ଲୋମ, ");
INSERT INTO ory_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ରକ୍ତୀକୃତ ମେଷର ଚର୍ମ ଓ ଶିଶୁକ ଚର୍ମ, ଶିଟୀମ୍‍ କାଷ୍ଠ, ");
INSERT INTO ory_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ଦୀପ ନିମନ୍ତେ ତୈଳ ପୁଣି, ଅଭିଷେକାର୍ଥ ତୈଳ ଓ ସୁଗନ୍ଧି ଧୂପ ନିମନ୍ତେ ଗନ୍ଧଦ୍ରବ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ପୁଣି, ଏଫୋଦ ଓ ବୁକୁପଟା ନିମନ୍ତେ ଗୋମେଦକ ମଣି ପ୍ରଭୃତି ଖଚନୀୟ ପ୍ରସ୍ତର; ଏହି ସମସ୍ତ ଉପହାର ସେମାନଙ୍କଠାରୁ ଗ୍ରହଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ସେମାନେ ଆମ୍ଭ ନିମନ୍ତେ ଗୋଟିଏ ପବିତ୍ର ସ୍ଥାନ ନିର୍ମାଣ କରନ୍ତୁ; ତହିଁରେ ଆମ୍ଭେ ସେମାନଙ୍କ ମଧ୍ୟରେ ବାସ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ଆବାସର ଆକାର ଓ ତହିଁର ସମସ୍ତ ପାତ୍ରର ଆକାରାଦିର ଯେଉଁ ଆଦର୍ଶ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଦେଖାଇବା, ତଦନୁସାରେ ତୁମ୍ଭେମାନେ ସମସ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ଆଉ, ସେମାନେ ଅଢ଼ାଇ ହସ୍ତ ଦୀର୍ଘ, ଦେଢ଼ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ଦେଢ଼ ହସ୍ତ ଉଚ୍ଚ ଶିଟୀମ୍‍ କାଷ୍ଠର ଏକ ସିନ୍ଦୁକ ନିର୍ମାଣ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ତହୁଁ ତୁମ୍ଭେ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ତାହା ମଡ଼ାଇବ; ପୁଣି, ତହିଁର ଭିତର ଓ ବାହାର ହିଁ ମଡ଼ାଇବ, ପୁଣି, ତହିଁ ଉପର ଚତୁର୍ଦ୍ଦିଗରେ ସ୍ୱର୍ଣ୍ଣର କାନ୍ଥି କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ପୁଣି, ତହିଁ ନିମନ୍ତେ ସ୍ୱର୍ଣ୍ଣର ଚାରି କଡ଼ା ଛାଞ୍ଚରେ ଢାଳି ତହିଁର ଚାରି କୋଣରେ ଦେବ; ତହିଁର ଏକ ପାର୍ଶ୍ୱରେ ଦୁଇ କଡ଼ା ଓ ଅନ୍ୟ ପାର୍ଶ୍ୱରେ ଦୁଇ କଡ଼ା ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ଆଉ ତୁମ୍ଭେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ଦୁଇ ସାଙ୍ଗୀ କରି ସ୍ୱର୍ଣ୍ଣରେ ମଡ଼ାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ପୁଣି, ସିନ୍ଦୁକ ବହିବା ନିମନ୍ତେ ସିନ୍ଦୁକର ଦୁଇ ପାର୍ଶ୍ୱସ୍ଥ କଡ଼ାରେ ସେହି ସାଙ୍ଗୀ ପ୍ରବେଶ କରାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ସେହି ସାଙ୍ଗୀ ସିନ୍ଦୁକର କଡ଼ାରେ ଥିବ, ତହିଁରୁ ବାହାର କରାଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯେଉଁ ସାକ୍ଷ୍ୟପତ୍ର ଦେବା, ତାହା ସେହି ସିନ୍ଦୁକରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ଏଉତ୍ତାରେ ତୁମ୍ଭେ ଶୁଦ୍ଧ ସୁବର୍ଣ୍ଣରେ ଅଢ଼ାଇ ହସ୍ତ ଦୀର୍ଘ ଓ ଦେଢ଼ ହସ୍ତ ପ୍ରସ୍ଥ ଏକ ପାପାଚ୍ଛାଦନ ନିର୍ମାଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ତୁମ୍ଭେ ସୁବର୍ଣ୍ଣର ଦୁଇ କିରୂବ ପ୍ରସ୍ତୁତ କରିବ; ପିଟାକର୍ମରେ ତାହା ପ୍ରସ୍ତୁତ କରି ସେହି ପାପାଚ୍ଛାଦନର ଦୁଇ ମୁଣ୍ଡରେ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ଏକ କିରୂବ ଏକ ମୁଣ୍ଡରେ ଓ ଅନ୍ୟ କିରୂବ ଅନ୍ୟ ମୁଣ୍ଡରେ ସ୍ଥାପନ କରିବ; ଦୁଇ କିରୂବକୁ ପାପାଚ୍ଛାଦନ ସହିତ ସଂଲଗ୍ନ ଓ ତହିଁର ଦୁଇ ପ୍ରାନ୍ତରେ ଉଭା କରି ସ୍ଥାପନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ପୁଣି, କିରୂବମାନେ ପରସ୍ପର ସମ୍ମୁଖୀନ ହୋଇ ପକ୍ଷ ଊର୍ଦ୍ଧ୍ୱକୁ ବିସ୍ତାର କରି ପାପାଚ୍ଛାଦନ ଆବରଣ କରିବେ; ପାପାଚ୍ଛାଦନ ପ୍ରତି କିରୂବମାନଙ୍କର ମୁଖ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ତୁମ୍ଭେ ସେହି ପାପାଚ୍ଛାଦନ ସେହି ସିନ୍ଦୁକ ଉପରେ ରଖିବ, ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯେଉଁ ସାକ୍ଷ୍ୟପତ୍ର ଦେବା, ତାହା ସେହି ସିନ୍ଦୁକ ଭିତରେ ଥୋଇବ। ");
INSERT INTO ory_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ଆଉ ଆମ୍ଭେ ସେହି ସ୍ଥାନରେ ତୁମ୍ଭ ସହିତ ସାକ୍ଷାତ କରିବା ଓ ପାପାଚ୍ଛାଦନର ଉପରି ଭାଗରୁ, ଅର୍ଥାତ୍‍, ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକର ଉପରିସ୍ଥ କିରୂବ ଦ୍ୱୟ ମଧ୍ୟରୁ ତୁମ୍ଭ ସଙ୍ଗେ ଆଳାପ କରି ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ବିଷୟକ ଆମ୍ଭର ସମସ୍ତ ଆଜ୍ଞା ତୁମ୍ଭକୁ ଜଣାଇବା। ");
INSERT INTO ory_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ତହିଁ ଉତ୍ତାରେ ତୁମ୍ଭେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ଦୁଇ ହସ୍ତ ଦୀର୍ଘ ଓ ଏକ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ଦେଢ଼ ହସ୍ତ ଉଚ୍ଚ ଗୋଟିଏ ମେଜ ନିର୍ମାଣ କରି ");
INSERT INTO ory_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ନିର୍ମଳ ସ୍ୱର୍ଣ୍ଣରେ ତାହା ମଡ଼ାଇବ, ପୁଣି, ତହିଁର ଚତୁର୍ଦ୍ଦିଗରେ ସ୍ୱର୍ଣ୍ଣର କାନ୍ଥି କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ପୁଣି, ତହିଁର ଚତୁର୍ଦ୍ଦିଗରେ ଚତୁରଙ୍ଗୁଳି ପରିମିତ ଏକ ବେଷ୍ଟନ କରିବ ଓ ସେହି ବେଷ୍ଟନର ଚତୁର୍ଦ୍ଦିଗରେ ସୁବର୍ଣ୍ଣ କାନ୍ଥି କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ଆଉ ସୁବର୍ଣ୍ଣ ନିର୍ମିତ ଚାରି କଡ଼ା କରି ତହିଁର ଚାରି ପାହ୍ୟାର ଚାରି କୋଣରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ମେଜ ବହନାର୍ଥେ ସାଙ୍ଗୀର ଘରା ନିମନ୍ତେ ସେହି କଡ଼ା ବେଷ୍ଟନ-ପାର୍ଶ୍ୱରେ ଥିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ପୁଣି, ସେହି ମେଜ ବହନାର୍ଥେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ସାଙ୍ଗୀ ପ୍ରସ୍ତୁତ କରି ସ୍ୱର୍ଣ୍ଣରେ ମଡ଼ାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ପୁଣି, ଥାଳୀ, ଚାମଚ, ଗଡ଼ୁ ଓ ଢାଳିବା ନିମନ୍ତେ ପାତ୍ର ନିର୍ମାଣ କରିବ, ଏହି ସମସ୍ତ ଶୁଦ୍ଧ ସୁବର୍ଣ୍ଣରେ ନିର୍ମାଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ତୁମ୍ଭେ ସେହି ମେଜ ଉପରେ ଆମ୍ଭ ସମ୍ମୁଖରେ ସର୍ବଦା ଦର୍ଶନୀୟ ରୁଟି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ଆହୁରି, ତୁମ୍ଭେ ନିର୍ମଳ ସୁବର୍ଣ୍ଣର ଏକ ଦୀପବୃକ୍ଷ ନିର୍ମାଣ କରିବ; ପିଟାକର୍ମରେ ଦୀପବୃକ୍ଷ, ତହିଁର ଗଣ୍ଡି ଓ ଶାଖା ନିର୍ମିତ ହେବ; ଆଉ ଗୋଲାଧାର, କଳିକା ଓ ପୁଷ୍ପ ତହିଁରେ ସଂଲଗ୍ନ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ଅର୍ଥାତ୍‍, ତହିଁର ଏକ ପାର୍ଶ୍ୱରୁ ତିନି ଦୀପଶାଖା ଓ ଅନ୍ୟ ପାର୍ଶ୍ୱରୁ ତିନି ଦୀପଶାଖା, ଏହିରୂପେ ଦୁଇ ପାର୍ଶ୍ୱରୁ ଛଅ ଶାଖା ନିର୍ଗତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ତହିଁର ଏକ ଶାଖାରେ ବାଦାମପୁଷ୍ପାକୃତି ତିନି ଗୋଲାଧାର, କଳିକା ଓ ପୁଷ୍ପ ରହିବ, ପୁଣି, ଅନ୍ୟ ଶାଖାରେ ବାଦାମପୁଷ୍ପାକୃତି ତିନି ଗୋଲାଧାର, କଳିକା ଓ ପୁଷ୍ପ ରହିବ; ସେହି ଦୀପବୃକ୍ଷରୁ ନିର୍ଗତ ଛଅ ଶାଖାରେ ଏହିରୂପେ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ମାତ୍ର ଦୀପବୃକ୍ଷରେ ବାଦାମପୁଷ୍ପାକୃତି ଚାରି ଗୋଲାଧାର, କଳିକା ଓ ପୁଷ୍ପ ରହିବ; ");
INSERT INTO ory_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ପୁଣି, ସେହି ଦୀପବୃକ୍ଷରୁ ଯେଉଁ ଛଅ ଶାଖା ନିର୍ଗତ ହୁଏ, ସେମାନଙ୍କ ଏକ ଶାଖାଦ୍ୱୟର ତଳେ ଏକ କଳିକା ଓ ଦ୍ୱିତୀୟ ଶାଖାଦ୍ୱୟର ତଳେ ଏକ କଳିକା ଓ ତୃତୀୟ ଶାଖାଦ୍ୱୟର ତଳେ ଏକ କଳିକା ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ଆଉ, କଳିକା, ଶାଖା ତହିଁର ଅଂଶ ହେବ ଓ ସମସ୍ତ ନିର୍ମଳ ସ୍ୱର୍ଣ୍ଣରେ ନିର୍ମିତ ଏକ ପିଟାକର୍ମ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ଆଉ, ତୁମ୍ଭେ ତହିଁ ପାଇଁ ସପ୍ତ ପ୍ରଦୀପ ନିର୍ମାଣ କରିବ; ତହିଁରେ ଲୋକମାନେ ସେହି ପ୍ରଦୀପ ଜ୍ୱଳାଇଲେ, ତହିଁର ସମ୍ମୁଖରେ ଆଲୁଅ ହେବ ");
INSERT INTO ory_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ଏବଂ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ତହିଁର ଚିମୁଟା ଓ ଅଙ୍ଗାରଦାନି ନିର୍ମାଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ଏହି ଦୀପବୃକ୍ଷ ଓ ତହିଁର ସାମଗ୍ରୀ ସର୍ବସୁଦ୍ଧା ଏକ ତାଳନ୍ତ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ନିର୍ମିତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ସାବଧାନ, ପର୍ବତରେ ତୁମ୍ଭକୁ ତହିଁର ଯେଉଁ ଯେଉଁ ଆଦର୍ଶ ପ୍ରଦର୍ଶିତ ହୋଇଅଛି, ସେହିରୂପେ ସମସ୍ତ କର। ");
INSERT INTO ory_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ଆହୁରି ତୁମ୍ଭେ ଦଶ ଯବନିକା ଦ୍ୱାରା ଆବାସ ପ୍ରସ୍ତୁତ କରିବ; ସେହି ସବୁ ଯବନିକା ଶୁଭ୍ର କ୍ଷୋମ, ନୀଳ, ଧୂମ୍ର ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣ ସୂତ୍ରରେ ନିର୍ମିତ ହେବ, ତହିଁରେ ଶିଳ୍ପିତ କିରୂବମାନଙ୍କର ଆକୃତି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ସେହି ପ୍ରତ୍ୟେକ ଯବନିକା ଅଠାଇଶ ହସ୍ତ ଦୀର୍ଘ ଓ ଚାରି ହସ୍ତ ପ୍ରସ୍ଥ, ସମସ୍ତ ଯବନିକାର ଏକ ପରିମାଣ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ପୁଣି, ଏକତ୍ର ପାଞ୍ଚ ଯବନିକାର ପରସ୍ପର ଯୋଗ ରହିବ, ଆଉ ଅବଶିଷ୍ଟ ପାଞ୍ଚ ଯବନିକାର ପରସ୍ପର ଯୋଗ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ଆଉ ଯୋଡ଼ ସ୍ଥାନରେ ପ୍ରଥମ ଶେଷ ଯବନିକାର ଧଡ଼ିରେ ନୀଳ ସୂତ୍ରର ଫାଶ କରିବ ଓ ଯୋଡ଼ ସ୍ଥାନରେ ଦ୍ୱିତୀୟ ଅନ୍ତ୍ୟ ଯବନିକାର ଧଡ଼ିରେ ତଦ୍ରୂପ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ଅର୍ଥାତ୍‍, ପ୍ରଥମ ଯବନିକାର ଧଡ଼ିରେ ପଚାଶ ଫାଶ କରିବ ଓ ଯୋଡ଼ସ୍ଥାନର ଦ୍ୱିତୀୟ ଯବନିକାର ଧଡ଼ିରେ ପଚାଶ ଫାଶ କରିବ; ସେହି ଦୁଇ ଫାଶ-ଶ୍ରେଣୀ ପରସ୍ପର ସମ୍ମୁଖୀନ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ପୁଣି, ପଚାଶ ସ୍ୱର୍ଣ୍ଣ ଆଙ୍କୁଡ଼ା କରି ଆଙ୍କୁଡ଼ାରେ ଯବନିକାସକଳ ପରସ୍ପର ଯୋଡ଼ିବ; ତହିଁରେ ଏକ ଆବାସ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","ଆଉ ସେହି ଆବାସ ଉପରେ ଆଚ୍ଛାଦନାର୍ଥକ ତମ୍ବୁ ନିମନ୍ତେ ଛାଗ ଲୋମର ଏକାଦଶ ଯବନିକା ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ସେହି ପ୍ରତ୍ୟେକ ଯବନିକାର ଦୈର୍ଘ୍ୟ ତିରିଶ ହସ୍ତ ଓ ପ୍ରସ୍ଥ ଚାରି ହସ୍ତ; ଏହି ଏକାଦଶ ଯବନିକାର ଏକ ପରିମାଣ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ଏଉତ୍ତାରେ ପାଞ୍ଚ ଯବନିକା ପରସ୍ପର ଯୋଡ଼ି ପୃଥକ ରଖିବ ଓ ଅନ୍ୟ ଛଅ ଯବନିକା ପୃଥକ ରଖିବ, ପୁଣି, ଏମାନଙ୍କ ମଧ୍ୟରୁ ଷଷ୍ଠ ଯବନିକା ଦୋହରା କରି ତମ୍ବୁ ସମ୍ମୁଖରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ଆଉ ଯୋଡ଼ ସ୍ଥାନରେ ପ୍ରଥମ ଶେଷ ଯବନିକାର ଧଡ଼ିରେ ପଚାଶ ଫାଶ କରିବ ଓ ଦ୍ୱିତୀୟ ଯବନିକାର ଯୋଡ଼ସ୍ଥାନ ଧଡ଼ିରେ ପଚାଶ ଫାଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ଆଉ ପିତ୍ତଳର ପଚାଶ ଆଙ୍କୁଡ଼ା କରି ସେହି ଫାଶରେ ପ୍ରବେଶ କରାଇ ତମ୍ବୁ ଯୋଡ଼ିବ; ତହିଁରେ ତାହା ଏକ ତମ୍ବୁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ସେହି ତମ୍ବୁ ଯବନିକାର ଅତିରିକ୍ତ ଅଂଶ, ଅର୍ଥାତ୍‍, ଯେଉଁ ଅର୍ଦ୍ଧ ଯବନିକା ଅତିରିକ୍ତ ଥିବ, ତାହା ଆବାସର ପଶ୍ଚାତ୍‍ ପାର୍ଶ୍ୱରେ ଓହଳି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ଆଉ ତମ୍ବୁ ଯବନିକାର ଅବଶିଷ୍ଟ ଯେଉଁ ଦୀର୍ଘ ଅଂଶ ଏ ପାର୍ଶ୍ୱରେ ଏକ ହସ୍ତ ଓ ସେ ପାର୍ଶ୍ୱରେ ଏକ ହସ୍ତ ଅତିରିକ୍ତ ରହିବ, ତାହା ଆବାସର ଏ ପାର୍ଶ୍ୱ ସେ ପାର୍ଶ୍ୱରେ ଆଚ୍ଛାଦନାର୍ଥେ ଝୁଲିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ଏଉତ୍ତାରେ ତୁମ୍ଭେ ରକ୍ତୀକୃତ ମେଷର ଚର୍ମରେ ତମ୍ବୁର ଏକ ଛାତ କରିବ, ଆଉ ତହିଁ ଉପରେ ଶିଶୁକ ଚର୍ମରେ ଏକ ଛାତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ଆବାସ ନିମନ୍ତେ ଶିଟୀମ୍‍ କାଷ୍ଠର ଠିଆପଟା ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ଏକ ଏକ ପଟା ଦଶ ହସ୍ତ ଦୀର୍ଘ ଓ ଦେଢ଼ ହସ୍ତ ପ୍ରସ୍ଥ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ତହିଁର ପରସ୍ପର ଅନୁରୂପ ଦୁଇ ପାଦ କରିବ; ଏହିରୂପେ ଆବାସର ସମସ୍ତ ପଟା ନିମନ୍ତେ ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ଆଉ ଆବାସ ନିମନ୍ତେ ଯେଉଁସବୁ ପଟା କରିବ, ସେ ସବୁ ମଧ୍ୟରୁ ଦକ୍ଷିଣ ଦିଗରେ ଦକ୍ଷିଣ ପାର୍ଶ୍ୱ ନିମନ୍ତେ କୋଡ଼ିଏ ପଟା। ");
INSERT INTO ory_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ପୁଣି, ସେହି କୋଡ଼ିଏ ପଟା ତଳେ ଚାଳିଶ ରୂପାର ଚୁଙ୍ଗୀ କରିବ; ଏକ ପଟା ତଳେ ତହିଁର ଦୁଇ ପଦ ନିମନ୍ତେ ଦୁଇ ଚୁଙ୍ଗୀ ଓ ଅନ୍ୟାନ୍ୟ ପଟା ତଳେ ମଧ୍ୟ ସେମାନଙ୍କ ଦୁଇ ଦୁଇ ପଦ ନିମନ୍ତେ ଦୁଇ ଚୁଙ୍ଗୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ପୁଣି, ଆବାସର ଅନ୍ୟ ପାର୍ଶ୍ୱ ନିମନ୍ତେ ଉତ୍ତର ଦିଗରେ କୋଡ଼ିଏ ପଟା ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ଏକ ପଟା ତଳେ ଦୁଇ ଚୁଙ୍ଗୀ ଓ ଅନ୍ୟାନ୍ୟ ପଟା ତଳେ ଦୁଇ ଦୁଇ ଚୁଙ୍ଗୀ; ଏରୂପେ ରୂପାର ଚାଳିଶ ଚୁଙ୍ଗୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ଆବାସର ପଶ୍ଚିମ ଦିଗସ୍ଥ ପଶ୍ଚାତ୍‍ ପାର୍ଶ୍ୱ ନିମନ୍ତେ ଛଅ ଖଣ୍ଡ ପଟା ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ପୁଣି, ଆବାସର ସେହି ପଶ୍ଚାଦ୍‍ ଭାଗର ଦୁଇ କୋଣରେ ଦୁଇ ଖଣ୍ଡ ପଟା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ଏହି କୋଣରେ ଥିବା ପଟାଗୁଡ଼ିକ ଯୋଡ଼ା ହୋଇ ଉପର ମୁଣ୍ଡ ପର୍ଯ୍ୟନ୍ତ ସଂଯୁକ୍ତ ହେବ, ଦୁଇ କୋଣରେ ଥିବା ଦୁଇଟି ପଟା ଏହିପରି ତିଆରି ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ତହିଁରେ ତହିଁର ପଟା ଆଠ ଖଣ୍ଡ ହେବ ଓ ତହିଁର ଷୋଳ ରୂପାଚୁଙ୍ଗୀ ହେବ; ଏକ ପଟା ତଳେ ଦୁଇ ଚୁଙ୍ଗୀ ଓ ଅନ୍ୟାନ୍ୟ ପଟା ତଳେ ଦୁଇ ଚୁଙ୍ଗୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","ଆଉ ତୁମ୍ଭେ ଶିଟୀମ୍‍ କାଷ୍ଠର ଅର୍ଗଳ ପ୍ରସ୍ତୁତ କରିବ; ଆବାସର ଏକ ପାର୍ଶ୍ୱସ୍ଥ ପଟାରେ ପାଞ୍ଚ ଅର୍ଗଳ ଓ ଅନ୍ୟ ପାର୍ଶ୍ୱସ୍ଥ ପଟାରେ ପାଞ୍ଚ ଅର୍ଗଳ ");
INSERT INTO ory_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ଓ ଆବାସର ପଶ୍ଚିମ ଦିଗସ୍ଥ ପଶ୍ଚାତ୍‍ ପାର୍ଶ୍ୱର ପଟାରେ ପାଞ୍ଚ ଅର୍ଗଳ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ପୁଣି, ମଧ୍ୟସ୍ଥିତ ଅର୍ଗଳ ପଟାର ମଧ୍ୟଦେଶରେ ଏ ମୁଣ୍ଡରୁ ସେମୁଣ୍ଡ ଯାଏ ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ଆଉ ସେହି ସବୁ ପଟା ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇବ ଓ ଅର୍ଗଳର ଘରା ନିମନ୍ତେ ସୁବର୍ଣ୍ଣ କଡ଼ା କରିବ, ପୁଣି, ଅର୍ଗଳସକଳ ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ଏହି ପ୍ରକାରେ ଆବାସର ଯେଉଁ ଆଦର୍ଶ ପର୍ବତରେ ତୁମ୍ଭକୁ ପ୍ରଦର୍ଶିତ ହୋଇଅଛି; ତଦନୁସାରେ ତାହା ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ଆଉ ତୁମ୍ଭେ ନୀଳବର୍ଣ୍ଣ, ଧୂମ୍ରବର୍ଣ୍ଣ, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ଏକ ବିଚ୍ଛେଦ ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କରିବ; ତାହା ନିପୁଣ ଶିଳ୍ପାକାରର କର୍ମରେ କିରୂବଗଣର ଆକୃତିବିଶିଷ୍ଟ କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ତୁମ୍ଭେ ତାହା ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇ ଶିଟୀମ୍‍ କାଷ୍ଠର ଚାରି ସ୍ତମ୍ଭ ଉପରେ ଟଙ୍ଗାଇବ; ପୁଣି, ରୂପାର ଚାରି ଚୁଙ୍ଗୀ ଉପରେ ସେମାନଙ୍କ ସ୍ୱର୍ଣ୍ଣର ଆଙ୍କୁଡ଼ାସବୁ ବସାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ପୁଣି, ଆଙ୍କୁଡ଼ା ସବୁର ତଳେ ବିଚ୍ଛେଦ ବସ୍ତ୍ର ଟଙ୍ଗାଇ ସେହି ବିଚ୍ଛେଦ ବସ୍ତ୍ର ମଧ୍ୟକୁ ସାକ୍ଷ୍ୟରୂପ ସିନ୍ଦୁକ ଆଣିବ; ତହିଁରେ ସେହି ବିଚ୍ଛେଦ ବସ୍ତ୍ର ପବିତ୍ର ସ୍ଥାନ ଓ ମହାପବିତ୍ର ସ୍ଥାନ ମଧ୍ୟରେ ଭେଦକ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ଆଉ ତୁମ୍ଭେ ମହାପବିତ୍ର ସ୍ଥାନରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ଉପରେ ପାପାଚ୍ଛାଦନ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ବାହାରେ ମେଜ ରଖିବ ଓ ମେଜ ସମ୍ମୁଖରେ ଆବାସର ଦକ୍ଷିଣ ଦିଗରେ ଦୀପବୃକ୍ଷ ରଖିବ ଓ ଉତ୍ତର ଦିଗରେ ମେଜ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ପୁଣି, ଆବାସର ଦ୍ୱାର ନିମନ୍ତେ ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନିର୍ମିତ ଚିତ୍ରବିଚିତ୍ର ଏକ ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ସେହି ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ନିମନ୍ତେ ପାଞ୍ଚଗୋଟି ଶିଟୀମ୍‍ କାଷ୍ଠର ସ୍ତମ୍ଭ ନିର୍ମାଣ କରି ସ୍ୱର୍ଣ୍ଣ ମଡ଼ାଇବ, ପୁଣି, ସ୍ୱର୍ଣ୍ଣରେ ତହିଁର ଆଙ୍କୁଡ଼ା କରିବ ଓ ତହିଁ ନିମନ୍ତେ ପିତ୍ତଳର ପାଞ୍ଚ ଚୁଙ୍ଗୀ ଢାଳିବ। ");
INSERT INTO ory_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ଆଉ ତୁମ୍ଭେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ପାଞ୍ଚ ହସ୍ତ ଦୀର୍ଘ ଓ ପାଞ୍ଚ ହସ୍ତ ପ୍ରସ୍ଥର ବେଦି ନିର୍ମାଣ କରିବ, ସେହି ବେଦି ଚତୁଷ୍କୋଣ ହେବ; ତହିଁର ଉଚ୍ଚତା ତିନି ହସ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ପୁଣି, ତହିଁର ଚାରି କୋଣ ଉପରେ ଶୃଙ୍ଗ କରିବ, ଆଉ ସେହି ଶୃଙ୍ଗ ବେଦିର ଏକାଂଶ ହେବ ଓ ତାହା ପିତ୍ତଳରେ ମଡ଼ାଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ଆଉ ତହିଁରୁ ଭସ୍ମ କାଢ଼ି ନେବା ପାଇଁ ଭସ୍ମଧାନୀ କରିବ, ତହିଁର କରଚୁଲି, କୁଣ୍ଡ, ତ୍ରିଶୂଳ ଓ ଅଙ୍ଗାରଧାନୀ କରିବ; ତହିଁର ସମସ୍ତ ପାତ୍ର ପିତ୍ତଳରେ ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ପୁଣି, ପିତ୍ତଳରେ ଏକ ଜାଲି ଝାଞ୍ଜିରୀ କରିବ ଓ ତହିଁ ଉପରେ ଚାରି କୋଣରେ ପିତ୍ତଳର ଚାରି କଡ଼ା ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ଏହି ଝାଞ୍ଜିରୀ ବେଦି-ବେଢ଼ ତଳେ ନିମ୍ନ ଭାଗରେ ରଖିବ ଓ ଝାଞ୍ଜିରୀ ବେଦିର ମଧ୍ୟ ପର୍ଯ୍ୟନ୍ତ ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ଆଉ ବେଦି ନିମନ୍ତେ ଶିଟୀମ୍‍ କାଷ୍ଠର ସାଙ୍ଗୀ କରିବ ଓ ତାହା ପିତ୍ତଳରେ ମଡ଼ାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ପୁଣି, ବେଦି ବହିବା ବେଳେ ତହିଁର ଦୁଇ ପାର୍ଶ୍ୱ ଉପରେ କଡ଼ା ମଧ୍ୟରେ ସେହି ସାଙ୍ଗୀ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ତୁମ୍ଭେ ଫମ୍ପା ରଖି ପଟାରେ ତାହା କରିବ, ପର୍ବତରେ ତୁମ୍ଭକୁ ଯେରୂପ ପ୍ରଦର୍ଶିତ ହୋଇଥିଲା, ସେରୂପେ ଲୋକମାନେ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ଆବାସର ପ୍ରାଙ୍ଗଣ କରିବ; ସେହି ପ୍ରାଙ୍ଗଣର ଦକ୍ଷିଣ ଦିଗରେ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନିର୍ମିତ ପରଦା କରିବ; ତହିଁର ଏକ ପାର୍ଶ୍ୱର ଦୈର୍ଘ୍ୟ ଏକ ଶହ ହସ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ତହିଁର କୋଡ଼ିଏ ସ୍ତମ୍ଭ ଓ କୋଡ଼ିଏ ଚୁଙ୍ଗୀ ପିତ୍ତଳର ହେବ, ପୁଣି, ସ୍ତମ୍ଭର ଆଙ୍କୁଡ଼ା ଓ ବନ୍ଧନୀ ରୂପାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ତଦ୍ରୂପ ଉତ୍ତର ପାର୍ଶ୍ୱରେ ଏକ ଶହ ହସ୍ତ ଦୀର୍ଘ ପରଦା ହେବ, ତହିଁର କୋଡ଼ିଏ ସ୍ତମ୍ଭ ଓ କୋଡ଼ିଏ ଚୁଙ୍ଗୀ ପିତ୍ତଳର ହେବ; ପୁଣି, ସ୍ତମ୍ଭର ଆଙ୍କୁଡ଼ା ଓ ବନ୍ଧନୀ ରୂପାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ଆଉ ପଶ୍ଚିମ ଦିଗରେ ପ୍ରାଙ୍ଗଣର ପ୍ରସ୍ଥ ନିମନ୍ତେ ପଚାଶ ହସ୍ତ ପରଦା, ତହିଁର ଦଶ ସ୍ତମ୍ଭ ଓ ଦଶ ଚୁଙ୍ଗୀ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ପୁଣି, ପୂର୍ବ ଦିଗରେ ପ୍ରାଙ୍ଗଣର ପ୍ରସ୍ଥ ପଚାଶ ହସ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","(ଦ୍ୱାରର) ଏକ ପାର୍ଶ୍ୱରେ ପନ୍ଦର ହସ୍ତ ପରଦା ଓ ତିନି ସ୍ତମ୍ଭ ଓ ତିନି ଚୁଙ୍ଗୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ଆଉ ଅନ୍ୟ ପାର୍ଶ୍ୱରେ ପନ୍ଦର ହସ୍ତ ପରଦା ଓ ତିନି ସ୍ତମ୍ଭ ଓ ତିନି ଚୁଙ୍ଗୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ପୁଣି, ପ୍ରାଙ୍ଗଣର ଦ୍ୱାର ନିମନ୍ତେ ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୋମସୂତ୍ରରେ ଶିଳ୍ପକର୍ମବିଶିଷ୍ଟ କୋଡ଼ିଏ ହସ୍ତ ଏକ ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ଓ ତହିଁର ଚାରି ସ୍ତମ୍ଭ ଓ ଚାରି ଚୁଙ୍ଗୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ପୁଣି, ପ୍ରାଙ୍ଗଣର ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ସ୍ତମ୍ଭସକଳ ରୂପା-ବନ୍ଧନୀରେ ବନ୍ଦ ହେବ ଓ ତହିଁର ଆଙ୍କୁଡ଼ା ରୂପାର ଓ ଚୁଙ୍ଗୀ ପିତ୍ତଳର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ପ୍ରାଙ୍ଗଣ ଏକ ଶହ ହସ୍ତ ଦୀର୍ଘ ଓ ସର୍ବତ୍ର ପଚାଶ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ପାଞ୍ଚ ହସ୍ତ ଉଚ୍ଚ, ପୁଣି, ସବୁ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ପ୍ରସ୍ତୁତ ଓ ତହିଁର ପିତ୍ତଳର ଚୁଙ୍ଗୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ଆଉ ଆବାସର ସମୁଦାୟ କାର୍ଯ୍ୟ ସମ୍ବନ୍ଧୀୟ ପାତ୍ର, କଣ୍ଟା ଓ ପ୍ରାଙ୍ଗଣର ସମସ୍ତ କଣ୍ଟା ପିତ୍ତଳର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ଆଉ ନିତ୍ୟ ପ୍ରଦୀପ ଜାଳି ଆଲୁଅ କରିବା ନିମନ୍ତେ ନିର୍ମଳ ପେଷା ଜୀତ ତୈଳ ତୁମ୍ଭ ନିକଟକୁ ଆଣିବା ପାଇଁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଆଜ୍ଞା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ଆଉ ସମାଗମ-ତମ୍ବୁରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ସମ୍ମୁଖସ୍ଥ ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ବାହାରେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସନ୍ଧ୍ୟା ସମୟରୁ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ତାହା ସଜାଇ ରଖିବେ; ଏହା ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ଆଉ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଯାଜକ କର୍ମ କରିବା ନିମନ୍ତେ ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ଆପଣା ଭ୍ରାତା ହାରୋଣକୁ ଓ ତାହା ସଙ୍ଗେ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ, ଅର୍ଥାତ୍‍, ହାରୋଣ, ନାଦବ୍‍ ଓ ଅବୀହୂ, ଇଲୀୟାସର ଓ ଈଥାମରକୁ ଆପଣା ନିକଟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ତୁମ୍ଭର ଭ୍ରାତା ହାରୋଣର ଶ୍ରୀ ଓ ଶୋଭା ନିମନ୍ତେ ପବିତ୍ର ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ଆଉ ଆମ୍ଭେ ଯେଉଁମାନଙ୍କୁ ଜ୍ଞାନଦାୟକ ଆତ୍ମାରେ ପୂର୍ଣ୍ଣ କରିଅଛୁ, ସେହି ସମସ୍ତ ବିଜ୍ଞମନା ଲୋକଙ୍କୁ ଆଦେଶ କର; ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଯାଜକ କର୍ମ କରିବା ନିମନ୍ତେ ହାରୋଣକୁ ପବିତ୍ର କରିବା ପାଇଁ ସେମାନେ ତାହାର ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ଅର୍ଥାତ୍‍, ବୁକୁପଟା, ଏଫୋଦ, ଚୋଗା, ବୁଟାଦାର ଜାମା, ପାଗ ଓ କଟିବନ୍ଧନ, ଏହି ସକଳ ବସ୍ତ୍ର ସେମାନେ ପ୍ରସ୍ତୁତ କରିବେ; ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଯାଜକ କର୍ମ କରିବା ନିମନ୍ତେ ତୁମ୍ଭ ଭ୍ରାତା ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ପାଇଁ ସେମାନେ ପବିତ୍ର ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ସେମାନେ ସୁବର୍ଣ୍ଣ, ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନେବେ। ");
INSERT INTO ory_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ପୁଣି, ସେମାନେ ସେହି ସ୍ୱର୍ଣ୍ଣ, ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ନିପୁଣ ଶିଳ୍ପକାରର କର୍ମ ଦ୍ୱାରା ଏଫୋଦ-ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ତହିଁର ଦୁଇ ମୁଣ୍ଡରେ ପରସ୍ପର ସଂଯୁକ୍ତ ଦୁଇ ସ୍କନ୍ଧପଟି ରହିବ; ଏହିରୂପେ ତାହା ଯୁକ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ପୁଣି, ଏଫୋଦର ଯେଉଁ ଚିତ୍ରିତ ପଟୁକା ତହିଁ ଉପରେ ରହିବ, ତହିଁର ଚିତ୍ରିତ କର୍ମ ସେହି ବସ୍ତ୍ରାନୁସାରେ ହେବ; ଅର୍ଥାତ୍‍, ସ୍ୱର୍ଣ୍ଣରେ, ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ଦୁଇ ଗୋମେଦକ ମଣି ଘେନି ତହିଁ ଉପରେ ଇସ୍ରାଏଲର ପୁତ୍ରମାନଙ୍କ ନାମ ଖୋଦିତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ଅର୍ଥାତ୍‍, ସେମାନଙ୍କ ବଂଶାବଳୀ ଅନୁସାରେ ଛଅ ନାମ ଏକ ମଣି ଉପରେ ଓ ଅବଶିଷ୍ଟ ଛଅ ନାମ ଅନ୍ୟ ମଣି ଉପରେ ଖୋଦିତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ଶିଳ୍ପକର୍ମରେ ମୁଦ୍ରା ଖୋଦିତ କରିବା ନ୍ୟାୟ ସେହି ଦୁଇ ମଣି ଉପରେ ଇସ୍ରାଏଲର ପୁତ୍ରଗଣର ନାମ ଖୋଦିତ କରିବ, ପୁଣି, ତାହା ଦୁଇ ସ୍ୱର୍ଣ୍ଣାଧାରରେ ବନ୍ଦ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ପୁଣି, ଇସ୍ରାଏଲର ସନ୍ତାନଗଣଙ୍କୁ ସ୍ମରଣ କରିବା ନିମନ୍ତେ ତୁମ୍ଭେ ସେହି ଦୁଇ ମଣି ଏଫୋଦର ଦୁଇ ସ୍କନ୍ଧପଟିରେ ଦେବ; ତହିଁରେ ହାରୋଣ ସ୍ମରଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଆପଣା ଦୁଇ ସ୍କନ୍ଧରେ ସେମାନଙ୍କ ନାମ ବହିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ଆଉ ତୁମ୍ଭେ ଦୁଇ ସ୍ୱର୍ଣ୍ଣାଧାର କରିବ ");
INSERT INTO ory_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ଓ ନିର୍ମଳ ସୁବର୍ଣ୍ଣ ଦ୍ୱାରା ଦୁଇ ମୋଡ଼ା ଜଞ୍ଜିର କରି ସେହି ମୋଡ଼ା ଜଞ୍ଜିର ସେହି ଦୁଇ ଆଧାରରେ ଲଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ପୁଣି, ଶିଳ୍ପକର୍ମରେ ବିଚାରାର୍ଥକ ବୁକୁପଟା କରିବ, ଅର୍ଥାତ୍‍, ଏଫୋଦର କର୍ମାନୁସାରେ ସ୍ୱର୍ଣ୍ଣରେ ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ନିପୁଣ ଶିଳ୍ପକାରର କର୍ମ ଦ୍ୱାରା ତାହା ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ତାହା ଚତୁଷ୍କୋଣ ଓ ଦୋହରା ହେବ; ତହିଁର ଦୈର୍ଘ୍ୟ ଏକ ଚାଖଣ୍ଡ ଓ ପ୍ରସ୍ଥ ଏକ ଚାଖଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ପୁଣି, ତାହାକୁ ଚାରି ଧାଡ଼ି ମଣିରେ ଖଚିତ କରିବ, ତହିଁର ପ୍ରଥମ ଧାଡିରେ ଚୂଣୀ, ପୀତମଣି ଓ ମରକତ; ");
INSERT INTO ory_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ଦ୍ୱିତୀୟ ଧାଡ଼ିରେ ପଦ୍ମରାଗ, ନୀଳକାନ୍ତ ଓ ହୀରକ ");
INSERT INTO ory_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ତୃତୀୟ ଧାଡ଼ିରେ ପେରୋଜ, ଯିସ୍ମ ଓ କଟାହେଳା ");
INSERT INTO ory_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ପୁଣି, ଚତୁର୍ଥ ଧାଡ଼ିରେ ବୈଦୁର୍ଯ୍ୟ, ଗୋମେଦକ ଓ ସୂର୍ଯ୍ୟକାନ୍ତ; ଏହି ସମସ୍ତ ସ୍ୱର୍ଣ୍ଣରେ ସ୍ୱ ସ୍ୱ ଧାଡ଼ିରେ ବସାଯିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ଏହି ମଣି ଇସ୍ରାଏଲର ପୁତ୍ରମାନଙ୍କ ନାମ ନିମନ୍ତେ ସେମାନଙ୍କ ନାମ ଅନୁସାରେ ଦ୍ୱାଦଶ ହେବେ; ମୁଦ୍ରାନ୍ୟାୟ ଖୋଦିତ ପ୍ରତ୍ୟେକ ମଣିରେ ସେହି ଦ୍ୱାଦଶ ବଂଶ ନିମନ୍ତେ ପ୍ରତ୍ୟେକ ପୁତ୍ରର ନାମ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ତୁମ୍ଭେ ନିର୍ମଳ ସ୍ୱର୍ଣ୍ଣ ଦ୍ୱାରା ବୁକୁପଟା ନିମନ୍ତେ ମାଳା ତୁଲ୍ୟ ମୋଡ଼ା ଦୁଇ ଜଞ୍ଜିର ନିର୍ମାଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ପୁଣି, ବୁକୁପଟା ଉପରେ ସ୍ୱର୍ଣ୍ଣର ଦୁଇ କଡ଼ା କରିବ ଓ ବୁକୁପଟାର ଦୁଇ ପ୍ରାନ୍ତରେ ସେହି ଦୁଇ କଡ଼ା ଲଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ଆଉ ବୁକୁପଟାର ଦୁଇ ପ୍ରାନ୍ତସ୍ଥିତ ଦୁଇ କଡ଼ା ମଧ୍ୟରେ ସେହି ଦୁଇ ମୋଡ଼ା ସ୍ୱର୍ଣ୍ଣ ଜଞ୍ଜିର ଲଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ପୁଣି, ମୋଡ଼ା ଜଞ୍ଜିରର ଦୁଇ ମୁଣ୍ଡ ଦୁଇ ଆଧାରରେ ବନ୍ଦ କରି ଏଫୋଦ ବସ୍ତ୍ରର ସମ୍ମୁଖସ୍ଥ ଦୁଇ ସ୍କନ୍ଧପଟି ଉପରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ତୁମ୍ଭେ ସ୍ୱର୍ଣ୍ଣର ଦୁଇ କଡ଼ା ନିର୍ମାଣ କରି ବୁକୁପଟାର ଦୁଇ ପ୍ରାନ୍ତରେ ଏଫୋଦ ବସ୍ତ୍ରର ସମ୍ମୁଖସ୍ଥ ଭିତର ଭାଗରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ଆହୁରି ଦୁଇ ସ୍ୱର୍ଣ୍ଣର କଡ଼ା କରି ଏଫୋଦ ବସ୍ତ୍ରର ଦୁଇ ସ୍କନ୍ଧପଟି ତଳେ ତହିଁର ସମ୍ମୁଖ ଭାଗର ଯୋଡ଼ା ସ୍ଥାନର ଏଫୋଦର ଚିତ୍ରିତ ପଟୁକା ଉପରେ ତାହା ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ତହିଁରେ ବୁକୁପଟା ଯେପରି ଏଫୋଦର ଚିତ୍ରିତ ପଟୁକା ଉପରେ ଥାଇ ଏଫୋଦରୁ ଖସି ନ ପଡ଼େ, ଏଥିପାଇଁ ସେମାନେ ବୁକୁପଟାକୁ ନିଜ କଡ଼ାରେ ନୀଳ ସୂତ୍ର ଦ୍ୱାରା ଏଫୋଦର କଡ଼ା ସହିତ ବନ୍ଧନ କରି ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","ଯେଉଁ ସମୟରେ ହାରୋଣ ପବିତ୍ର ସ୍ଥାନରେ ପ୍ରବେଶ କରିବ, ସେହି ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ନିତ୍ୟ ସ୍ମରଣାର୍ଥେ ସେ ବିଚାରାର୍ଥକ ବୁକୁପଟାରେ ଇସ୍ରାଏଲ-ପୁତ୍ରଗଣର ନାମସକଳ ଆପଣା ହୃଦୟ ଉପରେ ବହନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ସେହି ବିଚାରାର୍ଥକ ବୁକୁପଟାରେ ତୁମ୍ଭେ ଉରୀମ୍‍ ଓ ତୁମ୍ମୀମ୍‍ (ଦୀପ୍ତି ଓ ସିଦ୍ଧି) ରଖିବ; ତହିଁରେ ହାରୋଣ ଯେଉଁ ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ପ୍ରବେଶ କରିବ, ସେହି ସମୟରେ ହାରୋଣର ହୃଦୟ ଉପରେ ତାହା ରହିବ, ପୁଣି, ହାରୋଣ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ନିତ୍ୟ ନିତ୍ୟ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ବିଚାର ଆପଣା ହୃଦୟ ଉପରେ ବହିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ତୁମ୍ଭେ ଏଫୋଦର ଚୋଗା ସମ୍ପୂର୍ଣ୍ଣ ନୀଳବର୍ଣ୍ଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ତହିଁ ମଧ୍ୟସ୍ଥଳରେ ମସ୍ତକ ପ୍ରବେଶ ନିମନ୍ତେ ଏକ ଛିଦ୍ର ରହିବ; ସାଞ୍ଜୁଆର ଗଳଦେଶ ନ୍ୟାୟ ସେହି ଛିଦ୍ରର ଚତୁର୍ଦ୍ଦିଗରେ ବୁଣାକର୍ମ ହେବ, ତହିଁରେ ତାହା ଛିଣ୍ଡିଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ପୁଣି, ତୁମ୍ଭେ ତହିଁର ଅଞ୍ଚଳର ଚତୁର୍ଦ୍ଦିଗରେ ନୀଳ, ଧୂମ୍ର ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣର ଡାଳିମ୍ବ କରିବ; ଆଉ ତହିଁ ଚତୁର୍ଦ୍ଦିଗର ମଧ୍ୟେ ମଧ୍ୟେ ସ୍ୱର୍ଣ୍ଣ ଘଣ୍ଟି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ସେହି ଚୋଗାର ଧଡ଼ିର ଚତୁର୍ଦ୍ଦିଗରେ ଗୋଟିଏ ସ୍ୱର୍ଣ୍ଣ ଘଣ୍ଟି ଓ ଗୋଟିଏ ଡାଳିମ୍ବ, ପୁଣି, ଗୋଟିଏ ସ୍ୱର୍ଣ୍ଣ ଘଣ୍ଟି ଓ ଗୋଟିଏ ଡାଳିମ୍ବ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ଆଉ ହାରୋଣ ସେବା କରିବା ସମୟରେ ତାହା ପିନ୍ଧିବ; ତହିଁରେ ସେ ଯେତେବେଳେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ପବିତ୍ର ସ୍ଥାନରେ ପ୍ରବେଶ କରିବ ଓ ଯେତେବେଳେ ସେ ସେଠାରୁ ବାହାର ହେବ, ସେତେବେଳେ ତହିଁର ଶବ୍ଦ ଶୁଣାଯିବ; ତାହାହେଲେ ସେ ମରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ଆଉ ତୁମ୍ଭେ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ଏକ ପତ୍ର ପ୍ରସ୍ତୁତ କରି ମୋହର ନ୍ୟାୟ ତହିଁ ଉପରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ଖୋଦନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ପୁଣି, ପଗଡ଼ି ଉପରେ ରହିବା ପାଇଁ ତାହା ନୀଳ ସୂତ୍ରରେ ବାନ୍ଧି ପଗଡ଼ିର ସମ୍ମୁଖରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ତାହା ହାରୋଣର କପାଳ ଉପରେ ରହିବ, ତହିଁରେ ପବିତ୍ର ଦ୍ରବ୍ୟ-ଘଟିତ ଅପରାଧ, ଅର୍ଥାତ୍‍, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଆପଣାମାନଙ୍କର ପବିତ୍ରୀକୃତ ପବିତ୍ର ଦାନାଦି ସକଳ ଦ୍ରବ୍ୟ ସମ୍ବନ୍ଧରେ ଯେଉଁ ଅପରାଧ କରିବେ, ତାହା ହାରୋଣ ବୋହିବ ଓ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ସେମାନେ ଯେପରି ଗ୍ରାହ୍ୟ ହୁଅନ୍ତି, ଏଥିପାଇଁ ତାହା ନିତ୍ୟ ନିତ୍ୟ ତାହାର କପାଳରେ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ତୁମ୍ଭେ ଜାମାକୁ ବୁଟାଦାର ଶୁଭ୍ର କ୍ଷୌମବସ୍ତ୍ରରେ ଓ ପଗଡି଼କୁ ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ପ୍ରସ୍ତୁତ କରିବ; ପୁଣି, କଟିବନ୍ଧନ ସୂଚି କର୍ମ ଦ୍ୱାରା ଚିତ୍ରବିଚିତ୍ର କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ଆଉ ହାରୋଣର ପୁତ୍ରଗଣ ନିମନ୍ତେ ଜାମା ଓ କଟିବନ୍ଧନ ପ୍ରସ୍ତୁତ କରିବ, ଆଉ ସେମାନଙ୍କର ଶ୍ରୀ ଓ ସୌନ୍ଦର୍ଯ୍ୟ ନିମନ୍ତେ ଶିରୋଭୂଷଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ପୁଣି, ତୁମ୍ଭ ଭ୍ରାତା ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ତାହାସବୁ ପରିଧାନ କରାଇବ; ପୁଣି, ସେମାନଙ୍କୁ ଅଭିଷେକ କରି ପଦରେ ନିଯୁକ୍ତ ଓ ପବିତ୍ର କରିବ, ତହିଁରେ ସେମାନେ ଆମ୍ଭର ଯାଜକ କର୍ମ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ତୁମ୍ଭେ ସେମାନଙ୍କ ଶରୀରର ଉଲଙ୍ଗତା ଆଚ୍ଛାଦନ ନିମନ୍ତେ କଟିଠାରୁ ଜଙ୍ଘ ପର୍ଯ୍ୟନ୍ତ ଶୁକ୍ଳ ଜଙ୍ଘିଆ ପିନ୍ଧାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ପୁଣି, ଯେତେବେଳେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କରିବେ, କିଅବା ପବିତ୍ର ସ୍ଥାନରେ ସେବା କରିବା ନିମନ୍ତେ ବେଦିର ନିକଟବର୍ତ୍ତୀ ହେବେ, ସେତେବେଳେ ସେମାନେ ଯେପରି ଅପରାଧ କରି ନ ମରନ୍ତି, ଏନିମନ୍ତେ ସେମାନେ ଏହି ବସ୍ତ୍ର ପରିଧାନ କରିବେ; ଏହା ହାରୋଣର ଓ ତାହାର ଭବିଷ୍ୟତ ବଂଶର ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ଆଉ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଯାଜକ କର୍ମ କରିବା ନିମନ୍ତେ ସେମାନଙ୍କୁ ପ୍ରତିଷ୍ଠା କରିବା ପାଇଁ ତୁମ୍ଭେ ସେମାନଙ୍କ ପ୍ରତି ଏହି ସମସ୍ତ କର୍ମ କରିବ; ନିଖୁନ୍ତ ଏକ ଗୋବତ୍ସ ଓ ଦୁଇ ମେଷ ନେବ, ");
INSERT INTO ory_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ପୁଣି, ତାଡ଼ିଶୂନ୍ୟ ରୁଟି, ତୈଳ ମିଶ୍ରିତ ତାଡ଼ିଶୂନ୍ୟ ପିଠା ଓ ତୈଳଯୁକ୍ତ ତାଡ଼ିଶୂନ୍ୟ ସରୁ ଚକୁଳି ଗହମ ମଇଦାରେ ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ପୁଣି, ଗୋଟିଏ ଡାଲାରେ ତାହା ରଖିବ, ସେହି ଗୋବତ୍ସ ଓ ଦୁଇ ମେଷ ସଙ୍ଗରେ ଘେନି ସେହି ଡାଲା ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ଆଉ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାର ନିକଟକୁ ଆଣି ଜଳରେ ସେମାନଙ୍କୁ ସ୍ନାନ କରାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ତାʼପରେ ସେହି ସମସ୍ତ ବସ୍ତ୍ର ନେଇ ହାରୋଣକୁ ଜାମା, ଏଫୋଦର ଚୋଗା, ଏଫୋଦ ଓ ବୁକୁପଟା ପରିଧାନ କରାଇବ, ଆଉ ଏଫୋଦର ଚିତ୍ରିତ ପଟୁକାରେ ତାହାର କଟି ବାନ୍ଧିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ତାହାର ମସ୍ତକରେ ପଗଡ଼ି ବାନ୍ଧି ତହିଁ ଉପରେ ପବିତ୍ର ମୁକୁଟ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ଏଉତ୍ତାରେ ଅଭିଷେକାର୍ଥକ ତୈଳ ଘେନି ତାହାର ମସ୍ତକ ଉପରେ ଢ଼ାଳି ତାହାକୁ ଅଭିଷେକ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ତହୁଁ ତୁମ୍ଭେ ହାରୋଣର ପୁତ୍ରଗଣକୁ ଆଣି ଜାମା ପରିଧାନ କରାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ପୁଣି, ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ କଟିବନ୍ଧନ ପରିଧାନ କରାଇବ ଓ ସେମାନଙ୍କ ମସ୍ତକରେ ଶିରୋଭୂଷଣ ବାନ୍ଧିବ; ତହିଁରେ ସେମାନେ ଅନନ୍ତକାଳୀନ ବିଧି ଦ୍ୱାରା ଯାଜକତ୍ୱ ପଦ ପ୍ରାପ୍ତ ହେବେ। ଏହିରୂପେ ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ନିଯୁକ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ସମାଗମ-ତମ୍ବୁ ସମ୍ମୁଖକୁ ସେହି ଗୋବତ୍ସ ଅଣାଇବ, ପୁଣି, ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସେହି ଗୋବତ୍ସର ମସ୍ତକରେ ଆପଣା ଆପଣା ହସ୍ତ ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ତହୁଁ ତୁମ୍ଭେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ସମୀପରେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ସେହି ଗୋବତ୍ସକୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ଏଥିଉତ୍ତାରେ ଗୋବତ୍ସର ରକ୍ତରୁ କିଛି ନେଇ ଅଙ୍ଗୁଳି ଦ୍ୱାରା ବେଦିର ଶୃଙ୍ଗ ଉପରେ ଦେବ, ପୁଣି, ବେଦି ମୂଳରେ ଆଉ ସବୁ ରକ୍ତ ଢାଳି ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ଆଉ ତାହାର ଅନ୍ତ୍ରୋପରିସ୍ଥିତ ମେଦ ଓ ଯକୃତ ଉପରିସ୍ଥ ଅନ୍ତ୍ରାପ୍ଳାବକ ଓ ଦୁଇ ବୃକକ୍ ଓ ତହିଁ ଉପରିସ୍ଥ ମେଦ ଘେନି ବେଦିରେ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ମାତ୍ର ଗୋବତ୍ସର ମାଂସ, ଚର୍ମ ଓ ଗୋମୟ ଛାଉଣିର ବାହାରେ ଅଗ୍ନିରେ ଦଗ୍ଧ କରିବ; ଏହା ପାପାର୍ଥକ ବଳି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ପ୍ରଥମ ମେଷ ନେବ; ପୁଣି, ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସେହି ମେଷର ମସ୍ତକରେ ଆପଣା ଆପଣା ହସ୍ତ ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ତହୁଁ ତୁମ୍ଭେ ସେହି ମେଷକୁ ବଧ କରି ତାହାର ରକ୍ତ ନେଇ ବେଦି ଉପରେ ଚାରିଆଡ଼େ ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ତହିଁ ଉତ୍ତାରେ ମେଷକୁ ଖଣ୍ଡ ଖଣ୍ଡ କରି ତାହାର ଅନ୍ତ୍ର ଓ ଗୋଡ଼ ଧୌତ କରି ତାହାସବୁ ସେହି ଖଣ୍ଡସକଳ ଓ ମସ୍ତକ ସହ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ପୁଣି, ତୁମ୍ଭେ ସମ୍ପୂର୍ଣ୍ଣ ମେଷକୁ ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ; ତାହା ସଦାପ୍ରଭୁଙ୍କର ହୋମବଳି ଓ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ଦ୍ୱିତୀୟ ମେଷକୁ ନେବ, ପୁଣି, ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସେହି ମେଷର ମସ୍ତକରେ ଆପଣା ଆପଣା ହସ୍ତ ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ତହୁଁ ତୁମ୍ଭେ ସେହି ମେଷକୁ ବଧ କରି ତାହାର କିଛି ରକ୍ତ ଘେନି ହାରୋଣର ଦକ୍ଷିଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ ଓ ତାହାର ପୁତ୍ରଗଣର ଦକ୍ଷିଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ, ସେମାନଙ୍କ ଦକ୍ଷିଣ ହସ୍ତର ବୃଦ୍ଧାଙ୍ଗୁଷ୍ଠି ଉପରେ ଓ ଦକ୍ଷିଣ ପାଦର ବୃଦ୍ଧାଙ୍ଗୁଷ୍ଠି ଉପରେ ଲଗାଇବ, ପୁଣି, ବେଦି ଉପରେ ଚାରିଆଡ଼େ ରକ୍ତ ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ଏଥିଉତ୍ତାରେ ବେଦିର ଉପରିସ୍ଥିତ ରକ୍ତରୁ ଓ ଅଭିଷେକାର୍ଥକ ତୈଳରୁ କିଛି ନେଇ ହାରୋଣ ଉପରେ ଓ ତାହାର ବସ୍ତ୍ର ଉପରେ, ପୁଣି, ତାହା ସହିତ ତାହାର ପୁତ୍ରଗଣ ଉପରେ ଓ ସେମାନଙ୍କ ବସ୍ତ୍ର ଉପରେ ଛିଞ୍ଚିବ; ତହିଁରେ ସେ ଓ ତାହା ସହିତ ତାହାର ବସ୍ତ୍ର, ପୁଣି, ତାହାର ପୁତ୍ରଗଣ ଓ ସେମାନଙ୍କ ବସ୍ତ୍ର ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ଆହୁରି, ତୁମ୍ଭେ ସେହି ମେଷର ମେଦ, ମେଦମୟ ଲାଙ୍ଗୁଳ, ଅନ୍ତ୍ର ଉପରିସ୍ଥ ମେଦ, ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତ୍ରାପ୍ଳାବକ, ଦୁଇ ଗୁର୍ଦା, ତହିଁ ଉପରିସ୍ଥ ମେଦ ଓ ଡାହାଣ ଚଟୁଆ ନେବ, ଯେହେତୁ ତାହା ଉତ୍ସର୍ଗୀକୃତ ମେଷ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ଛାମୁସ୍ଥିତ ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ଡାଲାରୁ ଏକ ରୁଟି, ତୈଳ ମିଶ୍ରିତ ଏକ ପିଠା ଓ ଏକ ସରୁ ଚକୁଳି ନେଇ ");
INSERT INTO ory_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ତାହାସବୁ ହାରୋଣର ହସ୍ତରେ ଓ ତାହାର ପୁତ୍ରଗଣ ହସ୍ତରେ ଦେଇ ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ତାହା ଦୋଳାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ସେମାନଙ୍କ ହସ୍ତରୁ ତାହାସବୁ ନେଇ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ବେଦିରେ ହୋମାର୍ଥକ ବଳି ଉପରେ ଦଗ୍ଧ କରିବ। ଏହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ହାରୋଣର ଉତ୍ସର୍ଗୀକୃତ ମେଷର ବକ୍ଷ ଘେନି ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଦୋଳାଇବ; ସେହି ଖଣ୍ଡ ତୁମ୍ଭର ଅଂଶ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ଆଉ ହାରୋଣର ଓ ତାହାର ପୁତ୍ରଗଣର ପଦନିଯୋଗାର୍ଥକ ମେଷର ଯେଉଁ ବୁକୁ ରୂପ ଦୋଳନୀୟ ନୈବେଦ୍ୟ ଦୋଳାୟିତ ଓ ଯେଉଁ ଚଟୁଆ ରୂପ ଉତ୍ତୋଳନୀୟ ଉପହାର ଉତ୍ତୋଳିତ ହେଲା, ତାହା ତୁମ୍ଭେ ପବିତ୍ର କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ତହିଁରେ ଅନନ୍ତକାଳୀନ ବିଧି ଦ୍ୱାରା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ତାହା ହାରୋଣର ଓ ତାହାର ପୁତ୍ରଗଣର ଅଧିକାର ହେବ, ଯେହେତୁ ତାହା ଉତ୍ତୋଳନୀୟ ଉପହାର ଅଟେ; ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଏହି ଉତ୍ତୋଳନୀୟ ଉପହାର ସେମାନଙ୍କ ମଙ୍ଗଳାର୍ଥକ ବଳିରୁ ଦେୟ ହେବ; ଏହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସେମାନଙ୍କର ଉତ୍ତୋଳନୀୟ ଉପହାର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ପୁଣି, ହାରୋଣର (ମୃତ୍ୟୁ) ଉତ୍ତାରେ ତାହାର ପବିତ୍ର ବସ୍ତ୍ରସକଳ ତାହାର ପୁତ୍ରଗଣର ହେବ; ଅଭିଷେକ ଓ ପଦ ନିଯୁକ୍ତି ସମୟରେ ସେମାନେ ତାହା ପରିଧାନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ତାହାର ପୁତ୍ରମାନଙ୍କ ମଧ୍ୟରୁ ଯେଉଁ ଲୋକ ତାହା ପଦରେ ଯାଜକ ହୋଇ ପବିତ୍ର ସ୍ଥାନରେ ସେବା କରିବା ନିମନ୍ତେ ସମାଗମ-ତମ୍ବୁକୁ ଆସିବ, ସେ ସେହି ବସ୍ତ୍ର ସାତ ଦିନ ପରିଧାନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","ଏଥିଉତ୍ତାରେ ତୁମ୍ଭେ ସେହି ଉତ୍ସର୍ଗୀକୃତ ମେଷର ମାଂସ ଘେନି ଗୋଟିଏ ପବିତ୍ର ସ୍ଥାନରେ ପାକ କରିବ, ");
INSERT INTO ory_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ପୁଣି, ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସେହି ମେଷ ମାଂସ ଓ ଡାଲାସ୍ଥିତ ସେହି ରୁଟି ଭୋଜନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ପୁଣି, ସେମାନଙ୍କୁ ପଦରେ ନିଯୁକ୍ତ ଓ ପ୍ରତିଷ୍ଠା କରିବା ନିମନ୍ତେ ଯାହା ଦ୍ୱାରା ପ୍ରାୟଶ୍ଚିତ୍ତ ହେଲା, ତାହା ସେମାନେ ଭୋଜନ କରିବେ; ମାତ୍ର କୌଣସି ଅନ୍ୟ ବଂଶୀୟ ଲୋକ ତାହା ଭୋଜନ କରିବ ନାହିଁ, କାରଣ ତାହାସବୁ ପବିତ୍ର ବସ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ଆଉ ସେହି ପଦନିଯୋଗାର୍ଥକ ମାଂସ ଓ ରୁଟିରୁ ଯଦି ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ କିଛି ଅବଶିଷ୍ଟ ରହିବ, ତେବେ ସେହି ଅବଶିଷ୍ଟାଂଶ ଅଗ୍ନିରେ ଭସ୍ମସାତ୍‍ କରିବ, କେହି ତାହା ଖାଇବ ନାହିଁ; କାରଣ ତାହା ପବିତ୍ର ବସ୍ତୁ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯେପରି ଆଜ୍ଞା ଦେଇଅଛୁ, ତଦନୁସାରେ ତୁମ୍ଭେ ହାରୋଣ ପ୍ରତି ଓ ତାହାର ପୁତ୍ରଗଣ ପ୍ରତି କରିବ; ସେମାନଙ୍କ ଉତ୍ସର୍ଗୀକୃତରେ ସାତ ଦିନ ଲାଗିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ଆଉ ତୁମ୍ଭେ ପ୍ରାୟଶ୍ଚିତ୍ତ ନିମନ୍ତେ ପ୍ରତିଦିନ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ପୁଂଗୋବତ୍ସ ଉତ୍ସର୍ଗ କରିବ, ପୁଣି, ବେଦି ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରି ତାହା ପାପମୁକ୍ତ କରିବ ଓ ତାହା ପବିତ୍ର କରିବା ପାଇଁ ଅଭିଷେକ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ତୁମ୍ଭେ ବେଦି ନିମନ୍ତେ ସାତ ଦିନ ପ୍ରାୟଶ୍ଚିତ୍ତ କରି ତାହା ପବିତ୍ର କରିବ; ତହିଁରେ ବେଦି ମହାପବିତ୍ର ହେବ, ପୁଣି, ଯାହା କିଛି ବେଦି ସ୍ପର୍ଶ କରେ, ସେସବୁ ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","ସେହି ବେଦି ଉପରେ ତୁମ୍ଭେ ଏହି ବଳି ଉତ୍ସର୍ଗ କରିବ; ତୁମ୍ଭେ ନିୟମିତ ଭାବରେ ପ୍ରତିଦିନ ଏକ ବର୍ଷୀୟ ଦୁଇ ମେଷଶାବକ, ");
INSERT INTO ory_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ଅର୍ଥାତ୍‍, ତାହାର ପ୍ରଥମ ମେଷଶାବକକୁ ପ୍ରଭାତରେ ଉତ୍ସର୍ଗ କରିବ ଓ ଦ୍ୱିତୀୟ ମେଷଶାବକକୁ ସନ୍ଧ୍ୟା ବେଳେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ପୁଣି, ପ୍ରଥମ ମେଷଶାବକ ସହିତ ହିନ୍‍ପାତ୍ରର ଚତୁର୍ଥାଂଶ ନିର୍ମଳ ପେଷା ତୈଳରେ ମିଶ୍ରିତ ଏକ ଐଫାର ଦଶମାଂଶ ମଇଦା ଓ ପେୟ-ନୈବେଦ୍ୟ ନିମନ୍ତେ ହିନ୍‍ର ଚତୁର୍ଥାଂଶ ଦ୍ରାକ୍ଷାରସ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ଆଉ ସନ୍ଧ୍ୟା ସମୟରେ ଦ୍ୱିତୀୟ ମେଷଶାବକ ଉତ୍ସର୍ଗ କରିବ, ପୁଣି, ପ୍ରଭାତର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ପ୍ରମାଣେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ସ୍ୱରୂପେ ତାହା ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ଏହା ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତୁମ୍ଭମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ନିତ୍ୟ (କର୍ତ୍ତବ୍ୟ) ହୋମ ହେବ; ସେହି ସ୍ଥାନରେ ଆମ୍ଭେ ତୁମ୍ଭ ସହିତ ଆଳାପ କରିବା ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କ ସହିତ ସାକ୍ଷାତ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ଆଉ ସେହି ସ୍ଥାନରେ ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସହିତ ସାକ୍ଷାତ କରିବା; ପୁଣି, ଆମ୍ଭ ପ୍ରତାପରେ (ତମ୍ବୁ) ପବିତ୍ରୀକୃତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ଆଉ, ଆମ୍ଭେ ସମାଗମ-ତମ୍ବୁ ଓ ବେଦିକୁ ପବିତ୍ର କରିବା, ପୁଣି, ଆମ୍ଭର ଯାଜକ କର୍ମ କରଣାର୍ଥେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ପବିତ୍ର କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ବାସ କରି ସେମାନଙ୍କର ପରମେଶ୍ୱର ହେବା। ");
INSERT INTO ory_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ତହିଁରେ ଆମ୍ଭେ ଯେ ସେମାନଙ୍କର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର, ସେମାନଙ୍କ ମଧ୍ୟରେ ବାସ କରିବା ନିମନ୍ତେ ମିସର ଦେଶରୁ ସେମାନଙ୍କୁ ବାହାର କରି ଆଣିଅଛୁ, ତାହା ସେମାନେ ଜାଣିବେ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ସେମାନଙ୍କର ପରମେଶ୍ୱର। ");
INSERT INTO ory_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ଆଉ ତୁମ୍ଭେ ଧୂପ ଜଳାଇବା ପାଇଁ ଶିଟୀମ୍‍ କାଷ୍ଠର ଏକ ବେଦି ନିର୍ମାଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ତାହା ଏକ ହସ୍ତ ଦୀର୍ଘ ଓ ଏକ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ଚତୁଷ୍କୋଣ ହେବ, ପୁଣି, ଦୁଇ ହସ୍ତ ଉଚ୍ଚ ହେବ; ତହିଁର ଶୃଙ୍ଗସକଳ ତହିଁର ଅଂଶ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ତହିଁର ପୃଷ୍ଠ ଓ ଚାରି ପାର୍ଶ୍ୱ ଓ ଶୃଙ୍ଗ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇବ ଓ ତହିଁର ଚାରିଆଡ଼େ ସ୍ୱର୍ଣ୍ଣର କାନ୍ଥି କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ପୁଣି, ତହିଁର କାନ୍ଥି ତଳେ ଦୁଇ ପାର୍ଶ୍ୱର ଦୁଇ କୋଣ ନିକଟରେ ସ୍ୱର୍ଣ୍ଣର ଦୁଇ ଦୁଇ କଡ଼ା କରିବ; ଆଉ ତାହା ବହନାର୍ଥକ ସାଙ୍ଗୀର ଘରା ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ସେହି ସାଙ୍ଗୀ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ନିର୍ମାଣ କରି ସ୍ୱର୍ଣ୍ଣରେ ମଡ଼ାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ପୁଣି, ଆମ୍ଭେ ଯେଉଁ ସ୍ଥାନରେ ତୁମ୍ଭ ସହିତ ସାକ୍ଷାତ କରିବା, ସେହି ସ୍ଥାନରେ, ଅର୍ଥାତ୍‍, ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକର ଉପରିସ୍ଥ ପାପାଚ୍ଛାଦନ ସମ୍ମୁଖରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକର ଅଗ୍ରସ୍ଥିତ ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ଆଗରେ ତାହା ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","ହାରୋଣ ତହିଁ ଉପରେ ସୁଗନ୍ଧି ଧୂପ ଜ୍ୱଳାଇବ, ସେ ପ୍ରତି ପ୍ରଭାତରେ ପ୍ରଦୀପ ପରିଷ୍କାର କରିବା ସମୟରେ ସେହି ଧୂପ ଜ୍ୱଳାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ପୁଣି, ସନ୍ଧ୍ୟାକାଳେ ହାରୋଣ ପ୍ରଦୀପ ଜ୍ୱଳାଇବା ସମୟରେ ଧୂପ ଜ୍ୱଳାଇବ, ତହିଁରେ ତୁମ୍ଭମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ନିତ୍ୟ ନିତ୍ୟ ଧୂପଦାହ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ତୁମ୍ଭେମାନେ ତହିଁ ଉପରେ ଅନ୍ୟ କୌଣସି ଧୂପ ଅବା ହୋମବଳି କିଅବା ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ ଓ ତହିଁ ଉପରେ ପେୟ-ନୈବେଦ୍ୟ ଢାଳିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ପୁଣି, ହାରୋଣ ବର୍ଷ ମଧ୍ୟରେ ଥରେ ତହିଁର ଶୃଙ୍ଗ ଉପରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ସେ ପ୍ରାୟଶ୍ଚିତ୍ତାର୍ଥକ ପାପବଳିର ରକ୍ତ ଦ୍ୱାରା ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ବର୍ଷକେ ଥରେ ତହିଁ ଉପରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ଏହି ବେଦି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମହାପବିତ୍ର ଅଟେ।” ");
INSERT INTO ory_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ଆଉ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଏହି କଥା କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ଯେତେବେଳେ ତୁମ୍ଭେ ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟାନୁସାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଗଣନା କରିବ, ସେତେବେଳେ ସେମାନଙ୍କର ପ୍ରତ୍ୟେକ ଲୋକ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ଆପଣା ଆପଣା ପ୍ରାଣାର୍ଥେ ଗଣନା ସମୟରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବେ, ତହିଁରେ ସେମାନଙ୍କ ମଧ୍ୟରେ ଗଣନା ସମୟରେ କୌଣସି ମହାମାରୀ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ଯେକେହି ଗଣିତ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଅନ୍ତର୍ଭୁକ୍ତ, ସେ ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଅର୍ଦ୍ଧ ଶେକଲ ଦେବ; (କୋଡ଼ିଏ ଗେରାରେ ଏକ ଶେକଲ); ସେହି ଅର୍ଦ୍ଧ ଶେକଲ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରାପ୍ୟ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","କୋଡ଼ିଏ ବର୍ଷ କିଅବା ତହିଁରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ଯେକେହି ଗଣିତ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଅନ୍ତର୍ଭୁକ୍ତ, ସେ ସଦାପ୍ରଭୁଙ୍କୁ ଏହି ଉପହାର ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ପ୍ରାଣ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କୁ ସେହି ଉପହାର ଦେବା ସମୟରେ ଧନବାନ ଅର୍ଦ୍ଧ ଶେକଲରୁ ଅଧିକ ଦେବ ନାହିଁ, ପୁଣି, ଦରିଦ୍ର ତହିଁରୁ ଊଣା ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ତହୁଁ ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ସେହି ପ୍ରାୟଶ୍ଚିତ୍ତ-ରୂପା ନେଇ ସମାଗମ-ତମ୍ବୁର କାର୍ଯ୍ୟାର୍ଥେ ନିରୂପଣ କରିବ; ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରାଣର ପ୍ରାୟଶ୍ଚିତ୍ତ ନିମନ୍ତେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସ୍ମରଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ରହିବ।” ");
INSERT INTO ory_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ତୁମ୍ଭେ ପ୍ରକ୍ଷାଳନ ନିମନ୍ତେ ପିତ୍ତଳର କୁଣ୍ଡ ଓ ତହିଁର ପିତ୍ତଳର ବୈଠିକି ପ୍ରସ୍ତୁତ କରିବ; ପୁଣି, ସମାଗମ-ତମ୍ବୁ ଓ ବେଦି ମଧ୍ୟସ୍ଥାନରେ ରଖି ତହିଁ ମଧ୍ୟରେ ଜଳ ପୂରାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ଆଉ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ତହିଁରେ ଆପଣା ଆପଣା ହସ୍ତ ଓ ପଦ ପ୍ରକ୍ଷାଳନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ସେମାନେ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କରିବା ସମୟରେ ଯେପରି ନ ମରନ୍ତି, ଏଥିପାଇଁ ଜଳରେ ଆପଣାମାନଙ୍କୁ ଧୌତ କରିବେ; କିଅବା ସଦାପ୍ରଭୁଙ୍କର ସେବା ନିମନ୍ତେ, ଅର୍ଥାତ୍‍, ଅଗ୍ନିକୃତ ଉପହାର ଧୂପନ୍ୟାୟ ଦଗ୍ଧ କରିବା ନିମନ୍ତେ ବେଦି ନିକଟକୁ ଆସିବା ସମୟରେ ଯେପରି ନ ମରନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ଏଥିପାଇଁ ସେମାନେ ଆପଣା ଆପଣା ହସ୍ତ ଓ ପଦ ଧୌତ କରିବେ; ଏହା ତାହାର ଓ ତାହା ବଂଶର ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ତୁମ୍ଭେ ଆପଣା ନିକଟରେ ଏହିସବୁ ଅତ୍ୟୁତ୍ତମ ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ, ଅର୍ଥାତ୍‍, ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ପାଞ୍ଚ ଶହ ଶେକଲ ନିର୍ମଳ ଗନ୍ଧରସ ଓ ତହିଁର ଅର୍ଦ୍ଧ, ଅର୍ଥାତ୍‍, ଅଢ଼ାଇଶତ ଶେକଲ ସୁଗନ୍ଧି ଦାରୁଚିନି, ଅଢ଼ାଇଶତ ଶେକଲ ସୁଗନ୍ଧି, ");
INSERT INTO ory_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ପାଞ୍ଚ ଶହ ଶେକଲ ଗୁଡ଼ତ୍ୱକ୍‍ ଓ ଏକ ହିନ୍‍ ଜୀତ ତୈଳ ସଂଗ୍ରହ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ଏହିସବୁ ଦ୍ୱାରା ତୁମ୍ଭେ ଅଭିଷେକାର୍ଥକ ପବିତ୍ର ତୈଳ, ଅର୍ଥାତ୍‍, ଗନ୍ଧବଣିକର କ୍ରିୟାନୁସାରେ ତୈଳ ପ୍ରସ୍ତୁତ କରିବ, ତାହା ଅଭିଷେକାର୍ଥକ ପବିତ୍ର ତୈଳ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ତାହା ତୁମ୍ଭେ ନେଇ ସମାଗମ-ତମ୍ବୁ ଓ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ, ");
INSERT INTO ory_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ପୁଣି, ମେଜ, ତହିଁର ସକଳ ପାତ୍ର, ଦୀପବୃକ୍ଷ ଓ ତହିଁର ସକଳ ପାତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ଆଉ ଧୂପବେଦି, ତହିଁର ସକଳ ପାତ୍ର, ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ଓ ତହିଁର ବୈଠିକି ଅଭିଷେକ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ପୁଣି, ଏହିସବୁ ବସ୍ତୁକୁ ପବିତ୍ର କରିବ, ତହିଁରେ ତାହା ମହାପବିତ୍ର ହେବ, ଯାହା କିଛି ତାହା ସ୍ପର୍ଶ କରେ, ସେସବୁ ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ପୁଣି, ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ଆମ୍ଭର ଯାଜକ କର୍ମ କରଣାର୍ଥେ ଅଭିଷେକ କରି ପବିତ୍ର କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ଆଉ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହିବ, ‘ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ଆମ୍ଭ ନିମନ୍ତେ ତାହା ଅଭିଷେକାର୍ଥକ ପବିତ୍ର ତୈଳ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ମନୁଷ୍ୟର ଶରୀରରେ ତାହା ଢ଼ଳାଯିବ ନାହିଁ; ଅଥବା ତୁମ୍ଭେମାନେ ତହିଁର ମିଶ୍ରିତ ଦ୍ରବ୍ୟର ପରିମାଣାନୁସାରେ ଆଉ କୌଣସି ତୈଳ କରିବ ନାହିଁ; ତାହା ପବିତ୍ର ଅଟେ, ଆଉ ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ଯେକେହି ତହିଁ ତୁଲ୍ୟ କିଛି ପ୍ରସ୍ତୁତ କରିବ, ଅବା ଯେକେହି ଅପରିଚିତ ଲୋକର ଶରୀରରେ ତହିଁରୁ କିଛି ଲଗାଇବ, ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ନିକଟରେ ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ, ଅର୍ଥାତ୍‍, ଗୁଗ୍ଗୁଳ, ନଖୀ, କୁନ୍ଦୁରୁ ଓ ନିର୍ମଳ ଲୋବାନ୍‍, ଏହି ପ୍ରତ୍ୟେକ ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ ସମଭାଗରେ ସଂଗ୍ରହ କର। ");
INSERT INTO ory_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ପୁଣି, ତଦ୍ଦ୍ୱାରା ଗନ୍ଧବଣିକର କ୍ରିୟାରେ ପ୍ରସ୍ତୁତ ଓ ଲବଣାକ୍ତ ଏକ ନିର୍ମଳ ପବିତ୍ର ସୁଗନ୍ଧି ଧୂପ ପ୍ରସ୍ତୁତ କର। ");
INSERT INTO ory_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ତହିଁରୁ କିଛି ଚୂର୍ଣ୍ଣ କରି ଯେଉଁ ସମାଗମ-ତମ୍ବୁରେ ଆମ୍ଭେ ତୁମ୍ଭ ସହିତ ସାକ୍ଷାତ କରିବା, ତହିଁ ମଧ୍ୟରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ସମ୍ମୁଖରେ ରଖିବ; ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ମହାପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ପୁଣି, ତୁମ୍ଭେ ଯେଉଁ ସୁଗନ୍ଧି ଧୂପ କରିବ, ତହିଁର ମିଶ୍ରିତ ଦ୍ରବ୍ୟର ପରିମାଣାନୁସାରେ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ କର ନାହିଁ, ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ଯେକେହି ଆପଣା ଆଘ୍ରାଣାର୍ଥେ ତତ୍ତୁଲ୍ୟ ସୁଗନ୍ଧି ଧୂପ ପ୍ରସ୍ତୁତ କରିବ, ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଏହି କଥା କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ଦେଖ, ଆମ୍ଭେ ଯିହୁଦା ବଂଶୀୟ ହୂରର ପୌତ୍ର ଊରିର ପୁତ୍ର ବତ୍ସଲେଲକୁ ନାମ ଧରି ଆହ୍ୱାନ କରିଅଛୁ ");
INSERT INTO ory_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ପୁଣି, ଶିଳ୍ପକର୍ମ, ଅର୍ଥାତ୍‍, ସ୍ୱର୍ଣ୍ଣ, ରୌପ୍ୟ ଓ ପିତ୍ତଳରେ ଖୋଦନ ଓ ଖଚନାର୍ଥକ ମଣି-କର୍ତ୍ତନ ଓ କାଷ୍ଠ ଖୋଦନ ପ୍ରଭୃତି ");
INSERT INTO ory_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ସର୍ବପ୍ରକାର ଶିଳ୍ପକର୍ମ କରଣାର୍ଥେ ");
INSERT INTO ory_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ତାହାକୁ ଜ୍ଞାନ, ବୃଦ୍ଧି, ବିଦ୍ୟା ଓ କର୍ମନୈପୁଣ୍ୟ-ଦାୟକ ପରମେଶ୍ୱରଙ୍କ ଆତ୍ମାରେ ପରିପୂର୍ଣ୍ଣ କରିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ଆଉ ଦେଖ, ଆମ୍ଭେ ଦାନ୍ ବଂଶଜାତ ଅହୀଷାମକର ପୁତ୍ର ଅହଲୀୟାବକୁ ତାହାର ସହକାରୀ ହେବା ପାଇଁ ନିଯୁକ୍ତ କରିଅଛୁ; ପୁଣି, ସମସ୍ତ ବିଜ୍ଞମନା ଲୋକମାନଙ୍କ ହୃଦୟରେ ଜ୍ଞାନ ଦେଇଅଛୁ; ଏଣୁ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯେସମସ୍ତ ଆଜ୍ଞା ଦେଇଅଛୁ, ତାହାସବୁ ସେମାନେ ନିର୍ମାଣ କରି ପାରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ଅର୍ଥାତ୍‍, ସମାଗମ-ତମ୍ବୁ ଓ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ଓ ତହିଁର ଉପରିସ୍ଥ ପାପାଚ୍ଛାଦନ ଓ ତମ୍ବୁର ସମସ୍ତ ପାତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ଆଉ ମେଜ, ତହିଁର ପାତ୍ରାଦି, ନିର୍ମଳ ସ୍ୱର୍ଣ୍ଣ ଦୀପବୃକ୍ଷ, ତହିଁର ସମସ୍ତ ପାତ୍ର, ଧୂପବେଦି, ");
INSERT INTO ory_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ହୋମବେଦି, ତହିଁର ସମସ୍ତ ପାତ୍ର, ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ଓ ତହିଁର ବୈଠିକି, ");
INSERT INTO ory_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ପୁଣି, ସୁଶୋଭିତ ବସ୍ତ୍ର, ଯାଜକ କର୍ମ କରଣାର୍ଥେ ହାରୋଣ ଯାଜକର ପବିତ୍ର ବସ୍ତ୍ର ଓ ତାହାର ପୁତ୍ରଗଣର ବସ୍ତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ପୁଣି, ଅଭିଷେକାର୍ଥକ ତୈଳ ଓ ପବିତ୍ର ସ୍ଥାନ ନିମନ୍ତେ ସୁଗନ୍ଧି ଧୂପ, ଏହି ଯେଉଁ ସମସ୍ତ ଆଜ୍ଞା ଆମ୍ଭେ ତୁମ୍ଭକୁ ଦେଇଅଛୁ, ତଦନୁସାରେ ସେମାନେ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ତୁମ୍ଭେ ଆହୁରି ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଏହି କଥା କୁହ, ‘ନିଶ୍ଚୟ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଶ୍ରାମବାର ପାଳନ କରିବ; ଯେହେତୁ ଆମ୍ଭେ ଯେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ରକାରୀ ସଦାପ୍ରଭୁ, ଏହା ଯେପରି ତୁମ୍ଭେମାନେ ଜାଣିବ, ଏଥିପାଇଁ ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ଆମ୍ଭ ଓ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ତାହା ଏକ ଚିହ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ଏଣୁ ତୁମ୍ଭେମାନେ ବିଶ୍ରାମବାର ପାଳନ କରିବ; କାରଣ ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ପବିତ୍ର ଅଟେ; ଯେକେହି ତାହା ଅପବିତ୍ର କରେ, ନିଶ୍ଚୟ ତାହାର ପ୍ରାଣଦଣ୍ଡ ହେବ; ପୁଣି, ଯେକୌଣସି ବ୍ୟକ୍ତି ସେହି ଦିନରେ କାର୍ଯ୍ୟ କରିବ, ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ଛଅ ଦିନ ପର୍ଯ୍ୟନ୍ତ କାର୍ଯ୍ୟ କରାଯିବ, ମାତ୍ର ସପ୍ତମ ଦିନ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ମହା ବିଶ୍ରାମବାର ଅଟେ; ସେହି ବିଶ୍ରାମବାରରେ ଯେକେହି କାର୍ଯ୍ୟ କରେ, ନିଶ୍ଚୟ ତାହାର ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ଏହେତୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଅନନ୍ତକାଳୀନ ନିୟମ ରୂପେ ପୁରୁଷାନୁକ୍ରମେ ମାନ୍ୟ କରିବା ପାଇଁ ବିଶ୍ରାମବାର ପାଳନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ତାହା ଆମ୍ଭ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଗୋଟିଏ ଅନନ୍ତକାଳୀନ ଚିହ୍ନ ହେବ, କାରଣ ସଦାପ୍ରଭୁ ଛଅ ଦିନରେ ଆକାଶମଣ୍ଡଳ ଓ ପୃଥିବୀ ନିର୍ମାଣ କରି ସପ୍ତମ ଦିନରେ ବିଶ୍ରାମ କରି ଆଶ୍ୱାସିତ ହୋଇଥିଲେ।’” ");
INSERT INTO ory_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ତହୁଁ ସେ ସୀନୟ ପର୍ବତରେ ମୋଶାଙ୍କ ସହିତ କଥା ସମାପ୍ତ କରି ସାକ୍ଷ୍ୟ ସ୍ୱରୂପ ଦୁଇ ପଟା, ଅର୍ଥାତ୍‍, ପରମେଶ୍ୱରଙ୍କ ଅଙ୍ଗୁଳି ଲିଖିତ ଦୁଇ ପ୍ରସ୍ତର ପଟା ତାଙ୍କୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କର ପର୍ବତରୁ ଓହ୍ଲାଇବାର ବିଳମ୍ବ ଦେଖି ଲୋକମାନେ ହାରୋଣଙ୍କ ନିକଟରେ ଏକତ୍ର ହୋଇ ତାଙ୍କୁ କହିଲେ, “ଉଠ, ଆମ୍ଭମାନଙ୍କର ଅଗ୍ରଗାମୀ ହେବା ପାଇଁ ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଦେବତା ନିର୍ମାଣ କର, ଯେହେତୁ ଯେଉଁ ବ୍ୟକ୍ତି ମିସର ଦେଶରୁ ଆମ୍ଭମାନଙ୍କୁ ବାହାର କରି ଆଣିଲେ, ସେହି ମୋଶାଙ୍କ ପ୍ରତି କଅଣ ଘଟିଅଛି, ତାହା ଆମ୍ଭେମାନେ ଜାଣୁ ନାହୁଁ।” ");
INSERT INTO ory_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ତହୁଁ ହାରୋଣ ସେମାନଙ୍କୁ କହିଲେ, “ତେବେ ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ଭାର୍ଯ୍ୟା ଓ ପୁତ୍ରକନ୍ୟାଗଣର କର୍ଣ୍ଣରୁ ସ୍ୱର୍ଣ୍ଣକୁଣ୍ଡଳ କାଢ଼ି ମୋʼ ପାଖକୁ ଆଣ।” ");
INSERT INTO ory_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ତହିଁରେ ସମସ୍ତ ଲୋକ ଆପଣା ଆପଣା କର୍ଣ୍ଣରୁ ସ୍ୱର୍ଣ୍ଣକୁଣ୍ଡଳସବୁ କାଢ଼ି ହାରୋଣଙ୍କ ନିକଟକୁ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ସେ ସେମାନଙ୍କ ହସ୍ତରୁ ତାହା ନେଇ ଶିଳ୍ପାସ୍ତ୍ରରେ ଛାଞ୍ଚ ପ୍ରସ୍ତୁତ କରି ଏକ ଢଳା ବାଛୁରି ନିର୍ମାଣ କଲେ; ତହୁଁ ଲୋକମାନେ କହିଲେ, “ହେ ଇସ୍ରାଏଲ, ଯେଉଁ ଦେବତା ତୁମ୍ଭଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲେ, ସେ ଏହି।” ");
INSERT INTO ory_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ତହିଁରେ ହାରୋଣ ତାହା ଦେଖି ତାହାର ସମ୍ମୁଖରେ ଗୋଟିଏ ବେଦି ନିର୍ମାଣ କଲେ, “ପୁଣି, ଆସନ୍ତାକାଲି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସବ ହେବ,” ଏହା ଘୋଷଣା କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ଏଥିରେ ଲୋକମାନେ ପରଦିନ ପ୍ରଭାତରେ ଉଠି ହୋମବଳି ଉତ୍ସର୍ଗ କଲେ ଓ ମଙ୍ଗଳାର୍ଥକ ନୈବେଦ୍ୟ ଆଣିଲେ; ତହୁଁ ଲୋକମାନେ ଭୋଜନ ଓ ପାନ କରିବାକୁ ବସିଲେ; ଏଉତ୍ତାରେ ଲୀଳା କରିବାକୁ ଉଠିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ତେବେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଓହ୍ଲାଇ ଯାଅ, କାରଣ ତୁମ୍ଭର ଯେଉଁ ଲୋକମାନଙ୍କୁ ତୁମ୍ଭେ ମିସରରୁ ବାହାର କରି ଆଣିଲ, ସେମାନେ ଆପଣାମାନଙ୍କୁ ଭ୍ରଷ୍ଟ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ଆମ୍ଭେ ସେମାନଙ୍କୁ ଯେଉଁ ପଥ ବିଷୟରେ ଆଜ୍ଞା ଦେଲୁ, ସେମାନେ ଶୀଘ୍ର ତହିଁରୁ ବିମୁଖ ହେଲେ; ସେମାନେ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଏକ ଛାଞ୍ଚରେ ଢଳା ବାଛୁରି ନିର୍ମାଣ କରି ତାକୁ ପୂଜା କଲେ, ପୁଣି, ତାହା ନିକଟରେ ବଳିଦାନ କରି କହିଲେ, ‘ହେ ଇସ୍ରାଏଲ, ଯେଉଁ ଦେବତା ତୁମ୍ଭଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲେ, ସେ ଏହି।’” ");
INSERT INTO ory_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଆହୁରି କହିଲେ, “ଆମ୍ଭେ ଏହି ଲୋକମାନଙ୍କୁ ଦେଖିଅଛୁ; ଦେଖ, ସେମାନେ ଅତିଶୟ ଶକ୍ତଗ୍ରୀବ ଲୋକ। ");
INSERT INTO ory_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ଏଣୁ ତୁମ୍ଭେ ଏବେ ଆମ୍ଭଙ୍କୁ ଛାଡ଼ିଦିଅ, ମୋହର କ୍ରୋଧ ସେମାନଙ୍କ ପ୍ରତିକୂଳରେ ପ୍ରଜ୍ୱଳିତ ହେଉ, ତହିଁରେ ଆମ୍ଭେ ସେମାନଙ୍କୁ ସଂହାର କରିବା; ମାତ୍ର ଆମ୍ଭେ ତୁମ୍ଭକୁ ମହାଗୋଷ୍ଠୀ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ତହିଁରେ ମୋଶା ଆପଣା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କୁ ନିବେଦନ କରି କହିଲେ, “ହେ ସଦାପ୍ରଭୋ, ତୁମ୍ଭେ ଆପଣାର ଯେଉଁ ଲୋକମାନଙ୍କୁ ଆପଣା ମହାପରାକ୍ରମ ଓ ବାହୁ ବଳରେ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଅଛ, ସେମାନଙ୍କ ପ୍ରତିକୂଳରେ ତୁମ୍ଭର କ୍ରୋଧ କାହିଁକି ପ୍ରଜ୍ୱଳିତ ହେବ? ");
INSERT INTO ory_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","‘ସେ ପର୍ବତମୟ ଅଞ୍ଚଳରେ ସେମାନଙ୍କୁ ନଷ୍ଟ କରି ପୃଥିବୀରୁ ଲୋପ କରିବା ପାଇଁ, ଅନିଷ୍ଟ ନିମନ୍ତେ ବାହାର କରି ଆଣିଲେ,’ ଏପରି କଥା ମିସରୀୟମାନେ କାହିଁକି ଗଳ୍ପ କରିବେ? ତୁମ୍ଭେ ଆପଣା ପ୍ରଚଣ୍ଡ କ୍ରୋଧରୁ ଫେର ଓ ଆପଣା ଲୋକମାନଙ୍କ ପ୍ରତିକୂଳରେ ଏପରି ଅନିଷ୍ଟ ବିଷୟରୁ ନିବୃତ୍ତ ହୁଅ। ");
INSERT INTO ory_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ଆପଣା ଦାସ ଅବ୍ରହାମ ଓ ଇସ୍‌ହାକ ଓ ଇସ୍ରାଏଲଙ୍କୁ ସ୍ମରଣ କର, ତୁମ୍ଭେ ଆପଣା ନିଜ ନାମରେ ଶପଥ କରି ସେମାନଙ୍କୁ କହିଅଛ, ‘ଆମ୍ଭେ ଆକାଶର ତାରାଗଣ ନ୍ୟାୟ ତୁମ୍ଭମାନଙ୍କ ବଂଶ ବୃଦ୍ଧି କରିବା ଓ ଏହି ଯେଉଁସବୁ ଦେଶର କଥା କହିଲୁ, ତାହା ତୁମ୍ଭମାନଙ୍କ ବଂଶକୁ ଦେବା, ସେମାନେ ଅନନ୍ତକାଳ ପର୍ଯ୍ୟନ୍ତ ତାହା ଅଧିକାର କରିବେ।’” ");
INSERT INTO ory_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ତେବେ ସଦାପ୍ରଭୁ ଆପଣା ଲୋକମାନଙ୍କ ପ୍ରତି ଯେଉଁ ଅନିଷ୍ଟ କରିବାର କଥା କହିଥିଲେ, ତହିଁରୁ ନିବୃତ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ଏଥିଉତ୍ତାରେ ମୋଶା ମୁଖ ଫେରାଇ ସାକ୍ଷ୍ୟ ସ୍ୱରୂପ ଦୁଇ ପ୍ରସ୍ତର ପଟା ହସ୍ତରେ ଘେନି ପର୍ବତରୁ ଓହ୍ଲାଇଲେ; ସେହି ପ୍ରସ୍ତର ପଟାର ଉଭୟ ପାର୍ଶ୍ୱରେ ଲେଖାଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ସେହି ପ୍ରସ୍ତର ପଟା ପରମେଶ୍ୱରଙ୍କ ନିର୍ମିତ; ପୁଣି, ତହିଁରେ ଖୋଦିତ ଲିଖନ ହିଁ ପରମେଶ୍ୱରଙ୍କ ଲିଖନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ଏଥିଉତ୍ତାରେ ଲୋକମାନେ ଉଚ୍ଚ ରବ କରନ୍ତେ, ଯିହୋଶୂୟ ଲୋକମାନଙ୍କର କୋଳାହଳ ଶୁଣି ମୋଶାଙ୍କୁ କହିଲେ, “ଛାଉଣିରେ ଯୁଦ୍ଧ ଶବ୍ଦ ହେଉଅଛି।” ");
INSERT INTO ory_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ତହିଁରେ ସେ କହିଲେ, “ଏହା ଜୟଧ୍ୱନିର ଶବ୍ଦ ନୁହେଁ, କିଅବା ପରାଜୟ ସ୍ୱରର ଶବ୍ଦ ନୁହେଁ, ମାତ୍ର ମୁଁ ଗାୟନର ଶବ୍ଦ ଶୁଣୁଅଛି।” ");
INSERT INTO ory_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ଏଥିରେ ସେ ଛାଉଣିର ନିକଟବର୍ତ୍ତୀ ହେବା ମାତ୍ରେ ସେହି ବାଛୁରି ଓ ନୃତ୍ୟ ଦେଖିଲେ; ତହିଁରେ ମୋଶାଙ୍କର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା; ଏଣୁ ସେ ଆପଣା ହସ୍ତରୁ ସେହି ଦୁଇ ପ୍ରସ୍ତର ପଟା ଫୋପାଡ଼ି ଦେଇ ପର୍ବତ ତଳେ ତାହା ଭାଙ୍ଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ପୁଣି, ସେମାନଙ୍କ ନିର୍ମିତ ବାଛୁରି ଘେନି ଅଗ୍ନିରେ ପୋଡ଼ିଲେ ଓ ତାହା ପେଷି ଧୂଳି କଲେ, ଆଉ ଜଳ ଉପରେ ବିଞ୍ଚି ଦେଇ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ପିଆଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ତହୁଁ ମୋଶା ହାରୋଣଙ୍କୁ କହିଲେ, “ଏହି ଲୋକମାନେ ତୁମ୍ଭ ପ୍ରତି କʼଣ କଲେ ଯେ, ତୁମ୍ଭେ ସେମାନଙ୍କ ଉପରେ ଏପରି ମହାପାପ ବର୍ତ୍ତାଇଅଛ?” ");
INSERT INTO ory_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ତହିଁରେ ହାରୋଣ କହିଲେ, “ଆମ୍ଭ ପ୍ରଭୁଙ୍କର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ନ ହେଉ; ଆପଣ ଜାଣନ୍ତି ଯେ, ଏହି ଲୋକମାନେ ଦୁଷ୍ଟତାରେ ଆସକ୍ତ। ");
INSERT INTO ory_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ଏମାନେ ମୋତେ କହିଲେ, ‘ଆମ୍ଭମାନଙ୍କର ଅଗ୍ରଗାମୀ ହେବା ପାଇଁ ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଦେବତା ନିର୍ମାଣ କର; କାରଣ ଯେଉଁ ବ୍ୟକ୍ତି ଆମ୍ଭମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲେ, ସେହି ମୋଶାଙ୍କର କଅଣ ହୋଇଅଛି, ତାହା ଆମ୍ଭେମାନେ ଜାଣୁ ନାହୁଁ।’ ");
INSERT INTO ory_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ତେବେ ମୁଁ କହିଲି, ‘ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଯାହାର ଯେକୌଣସି ସୁନା ଅଛି, ତାହା ସେମାନେ କାଢ଼ି ଦିଅନ୍ତୁ; ତହିଁରେ ସେମାନେ ମୋତେ ତାହା ଦେଲେ; ମୁଁ ତାହା ନେଇ ଅଗ୍ନିରେ ପକାଇଲି, ତହୁଁ ଏହି ବାଛୁରି ବାହାରି ଆସିଲା।’” ");
INSERT INTO ory_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ଆଉ ମୋଶା ଲୋକମାନଙ୍କୁ ସ୍ୱେଚ୍ଛାଚାରୀ ଦେଖିଲେ, କାରଣ ହାରୋଣ ସେମାନଙ୍କୁ ଶତ୍ରୁଗଣ ମଧ୍ୟରେ ହାସ୍ୟାସ୍ପଦ ହେବା ଭଳି ସ୍ୱେଚ୍ଛାଚାରୀ କରି ଛାଡ଼ିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ଏଥିରେ ମୋଶା ଛାଉଣି ଦ୍ୱାରରେ ଠିଆ ହୋଇ କହିଲେ, “ସଦାପ୍ରଭୁଙ୍କ ପକ୍ଷରେ କିଏ ଅଛି? ସେ ମୋʼ ନିକଟକୁ ଆସୁ,” ତହିଁରେ ଲେବୀର ସନ୍ତାନଗଣ ତାଙ୍କ ନିକଟରେ ଏକତ୍ର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ତହୁଁ ସେ ସେମାନଙ୍କୁ କହିଲେ, “ଇସ୍ରାଏଲର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଏହି କଥା କହନ୍ତି, ‘ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ଜଣ ଆପଣା ଆପଣା ଜଙ୍ଘରେ ଖଡ୍ଗ ବାନ୍ଧି ଛାଉଣିର ମଧ୍ୟଦେଇ ଏକ ଦ୍ୱାରରୁ ଅନ୍ୟ ଦ୍ୱାର ପର୍ଯ୍ୟନ୍ତ ଗତାୟାତ କର, ପ୍ରତି ଜଣ ଆପଣା ଆପଣା ଭାଇ, ମିତ୍ର ଓ ପ୍ରତିବାସୀକୁ ବଧ କର।’” ");
INSERT INTO ory_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ତହିଁରେ ଲେବୀର ସନ୍ତାନମାନେ ମୋଶାଙ୍କର ବାକ୍ୟାନୁସାରେ ତଦ୍ରୂପ କରନ୍ତେ, ସେହି ଦିନ ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଊଣାଧିକ ତିନି ହଜାର ଲୋକ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ଆଉ ମୋଶା କହିଥିଲେ, “ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ଜଣ ଆପଣା ଆପଣା ପୁତ୍ର ଓ ଭାଇମାନଙ୍କର ବିପକ୍ଷ ହୋଇ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆପଣାମାନଙ୍କୁ ନିଯୁକ୍ତ କର, ତହିଁରେ ସେ ଏହି ଦିନରେ ତୁମ୍ଭମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ତହିଁ ପରଦିନ ମୋଶା ଲୋକମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ମହାପାପ କରିଅଛ, ଏବେ ମୁଁ ସଦାପ୍ରଭୁଙ୍କ ନିକଟକୁ ଆରୋହଣ କରୁଅଛି; ଯଦି ହୋଇପାରେ, ତେବେ ମୁଁ ତୁମ୍ଭମାନଙ୍କ ପାପର ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ଏଥିଉତ୍ତାରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ନିକଟକୁ ଫେରିଯାଇ କହିଲେ, “ହାୟ, ହାୟ, ଏହି ଲୋକମାନେ ମହାପାପ କରି ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ସ୍ୱର୍ଣ୍ଣ ଦେବତା ନିର୍ମାଣ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ତଥାପି ଏବେ, ତୁମ୍ଭେ ଯଦି ସେମାନଙ୍କର ପାପ କ୍ଷମା କରିବ; କିନ୍ତୁ ଯଦି ନ କରିବ, ତେବେ ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭର ଲିଖିତ ପୁସ୍ତକରୁ ମୋହର ନାମ କାଟି ପକାଅ।” ");
INSERT INTO ory_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଯେଉଁ ଲୋକ ଆମ୍ଭ ବିରୁଦ୍ଧରେ ପାପ କରିଅଛି, ଆମ୍ଭେ ଆପଣା ପୁସ୍ତକରୁ ତାହାର ନାମ କାଟି ପକାଇବା। ");
INSERT INTO ory_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ଏବେ ଯାଅ, ଆମ୍ଭେ ଯେଉଁ ଦେଶ ବିଷୟରେ ତୁମ୍ଭକୁ କହିଅଛୁ, ସେହି ଦେଶକୁ ଲୋକମାନଙ୍କୁ ନେଇଯାଅ; ଦେଖ, ଆମ୍ଭ ଦୂତ ତୁମ୍ଭ ଆଗେ ଆଗେ ଗମନ କରିବେ; ମାତ୍ର ଆମ୍ଭେ ପ୍ରତିଫଳ ଦେବା ଦିନରେ ସେମାନଙ୍କ ପାପର ପ୍ରତିଫଳ ସେମାନଙ୍କୁ ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ପୁଣି, ସଦାପ୍ରଭୁ ଲୋକମାନଙ୍କୁ ଆଘାତ କଲେ, ଯେହେତୁ ହାରୋଣ-ନିର୍ମିତ ବାଛୁରି ସେମାନେ ନିର୍ମାଣ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ଏହାପରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଆମ୍ଭେ ଅବ୍ରହାମ ଓ ଇସ୍‌ହାକ ଓ ଯାକୁବ ନିକଟରେ ଶପଥ କରି ଯେଉଁ ଦେଶ ବିଷୟରେ କହିଥିଲୁ, ତୁମ୍ଭ ବଂଶକୁ ଏହି ଦେଶ ଦେବା, ସେହି ଦେଶକୁ ଯିବା ପାଇଁ ତୁମ୍ଭେ ଓ ମିସରରୁ ଆନୀତ ଲୋକମାନେ ଏହି ସ୍ଥାନରୁ ପ୍ରସ୍ଥାନ କର; ");
INSERT INTO ory_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ଆମ୍ଭେ ତୁମ୍ଭ ଆଗେ ଆଗେ ଏକ ଦୂତ ପଠାଇବା; ପୁଣି, ଆମ୍ଭେ କିଣାନୀୟ, ଇମୋରୀୟ, ହିତ୍ତୀୟ, ପରିଷୀୟ, ହିବ୍ବୀୟ ଓ ଯିବୂଷୀୟ ଲୋକମାନଙ୍କୁ ତଡ଼ିଦେବା। ");
INSERT INTO ory_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ଏନିମନ୍ତେ ସେହି ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଦେଶକୁ ଯାଅ; ମାତ୍ର ଆମ୍ଭେ ତୁମ୍ଭର ମଧ୍ୟବର୍ତ୍ତୀ ହୋଇ ଯିବା ନାହିଁ; ଗଲେ ଆମ୍ଭେ ପଥ ମଧ୍ୟରେ ତୁମ୍ଭଙ୍କୁ ସଂହାର କରିବା, କାରଣ ତୁମ୍ଭେ ଶକ୍ତଗ୍ରୀବ ଲୋକ।” ");
INSERT INTO ory_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ଲୋକମାନେ ଏହି ଅଶୁଭ ସମ୍ବାଦ ଶୁଣି ଶୋକ କଲେ; କେହି ଆପଣା ଶରୀରରେ ଆଭରଣ ପରିଧାନ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","କାରଣ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଥିଲେ, “ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଏହି କଥା କୁହ, ତୁମ୍ଭେମାନେ ଶକ୍ତଗ୍ରୀବ ଲୋକ; ଯଦି ଆମ୍ଭେ ଏକ ନିମିଷ ତୁମ୍ଭ ମଧ୍ୟକୁ ଯିବା, ତେବେ ତୁମ୍ଭଙ୍କୁ ସଂହାର କରିବା; ତୁମ୍ଭେ ଏବେ ଆପଣା ଶରୀରରୁ ଆଭରଣ ଦୂର କର, ତହିଁରେ ତୁମ୍ଭ ପ୍ରତି କି କର୍ତ୍ତବ୍ୟ ତାହା ଜାଣିବା।” ");
INSERT INTO ory_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ଏଥିରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ହୋରେବ ପର୍ବତ ନିକଟରୁ ଅଗ୍ରସର ହୋଇଯାଉ ଯାଉ ଆପଣା ଆପଣା ସମସ୍ତ ଆଭରଣ ଦୂର କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ଏସମୟରେ ଏପରି ଥିଲା ଯେ, ମୋଶା ଆପଣା ତମ୍ବୁ ନେଇ ଛାଉଣିର ବାହାରେ ଓ ଛାଉଣିଠାରୁ ଦୂରରେ ସ୍ଥାପନ କଲେ ଓ ତାହାର ନାମ ସମାଗମ-ତମ୍ବୁ ଦେଲେ। ସଦାପ୍ରଭୁଙ୍କ ଅନ୍ୱେଷଣକାରୀ ପ୍ରତ୍ୟେକ ଲୋକ ଛାଉଣିର ବାହାରସ୍ଥିତ ସେହି ସମାଗମ-ତମ୍ବୁ ନିକଟକୁ ଯାʼନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ପୁଣି, ଏପରି ଘଟିଲା ଯେ, ମୋଶା ବାହାର ହୋଇ ସେହି ତମ୍ବୁ ନିକଟକୁ ଯିବା ସମୟରେ ସମସ୍ତ ଲୋକ ଉଠି ଆପଣା ଆପଣା ତମ୍ବୁ ଦ୍ୱାରରେ ଠିଆ ହେଲେ, ଆଉ ଯେପର୍ଯ୍ୟନ୍ତ ମୋଶା ସେହି ତମ୍ବୁରେ ପ୍ରବେଶ କଲେ ନାହିଁ, ସେପର୍ଯ୍ୟନ୍ତ ସେମାନେ ତାଙ୍କର ପଶ୍ଚାତ୍‍ ଅନାଇ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ଏଉତ୍ତାରେ ମୋଶା ତମ୍ବୁରେ ପ୍ରବେଶ କରନ୍ତେ, ମେଘସ୍ତମ୍ଭ ଓହ୍ଲାଇ ତମ୍ବୁ ଦ୍ୱାରରେ ଅବସ୍ଥିତ ହେଲା; ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ସହିତ ଆଳାପ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ତମ୍ବୁ ଦ୍ୱାରରେ ଅବସ୍ଥିତ ମେଘସ୍ତମ୍ଭ ଦେଖନ୍ତେ, ସମସ୍ତ ଲୋକ ଉଠି ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ତମ୍ବୁ ଦ୍ୱାରରେ ଥାଇ ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ମନୁଷ୍ୟ ଯେପରି ମିତ୍ର ସହିତ ଆଳାପ କରେ, ସେପରି ସଦାପ୍ରଭୁ ମୁଖାମୁଖି ହୋଇ ମୋଶାଙ୍କ ସହିତ ଆଳାପ କଲେ; ଏଉତ୍ତାରେ ମୋଶା ଛାଉଣିକୁ ବାହୁଡ଼ି ଆସିଲେ, ମାତ୍ର ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ ନାମକ ତାଙ୍କର ଯୁବା ପରିଚାରକ ତମ୍ବୁ ମଧ୍ୟରୁ ପ୍ରସ୍ଥାନ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ଏଥିଉତ୍ତାରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, “ଦେଖ, ତୁମ୍ଭେ ଏହି ଲୋକମାନଙ୍କୁ ଘେନିଯିବା ନିମନ୍ତେ ମୋତେ କହୁଅଛ; ମାତ୍ର ତୁମ୍ଭେ ମୋʼ ସଙ୍ଗରେ କାହାକୁ ପଠାଇବ, ଏହା ତୁମ୍ଭେ ମୋତେ ଜଣାଇ ନାହଁ। ତଥାପି ତୁମ୍ଭେ କହିଅଛ, ଆମ୍ଭେ ନାମ ଦ୍ୱାରା ତୁମ୍ଭକୁ ଜାଣୁ ଓ ତୁମ୍ଭେ ଆମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହପାତ୍ର ହୋଇଅଛ। ");
INSERT INTO ory_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ଉତ୍ତମ, ମୁଁ ଯଦି ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହପାତ୍ର ହୋଇଅଛି, ତେବେ ବିନୟ କରୁଅଛି, ମୁଁ ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇବା ପାଇଁ ଯେପରି ତୁମ୍ଭଙ୍କୁ ଜାଣି ପାରିବି, ଏଥିପାଇଁ ଏବେ ତୁମ୍ଭେ ମୋତେ ଆପଣା ମାର୍ଗ ଜଣାଅ; ପୁଣି, ଏହି ଗୋଷ୍ଠୀ ଯେ ତୁମ୍ଭର ଲୋକ, ଏହା ବିବେଚନା କର।” ");
INSERT INTO ory_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ସେତେବେଳେ ସେ କହିଲେ, “ମୋହର ଉପସ୍ଥିତି ତୁମ୍ଭ ସହିତ ଗମନ କରିବ, ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭକୁ ବିଶ୍ରାମ ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ତହିଁରେ ସେ ତାହାଙ୍କୁ କହିଲେ, “ଯଦି ତୁମ୍ଭର ଉପସ୍ଥିତି ଆମ୍ଭମାନଙ୍କ ସହିତ ଗମନ ନ କରନ୍ତି, ତେବେ ଏହି ସ୍ଥାନରୁ ଆମ୍ଭମାନଙ୍କୁ ନେଇଯାଅ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","କାରଣ ମୁଁ ଓ ତୁମ୍ଭର ଏହି ଲୋକମାନେ ଯେ ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇଅଛୁ, ଏହା ଏବେ କିପରି ଜଣାଯିବ? ଯେପରି ମୁଁ ଓ ତୁମ୍ଭର ଲୋକମାନେ ପୃଥିବୀସ୍ଥ ସମସ୍ତ ଲୋକଠାରୁ ବିଶେଷ ଲୋକ ହେବା, ଆମ୍ଭମାନଙ୍କ ସହିତ ତୁମ୍ଭର ଗମନ ଦ୍ୱାରା କି ଏହା ଜଣାଯାଏ ନାହିଁ? ");
INSERT INTO ory_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଏହି ଯେଉଁ କଥା ତୁମ୍ଭେ କହିଅଛ, ତାହା ହିଁ ଆମ୍ଭେ କରିବା, କାରଣ ତୁମ୍ଭେ ମୋʼ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇଅଛ, ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭକୁ ନାମ ଦ୍ୱାରା ଜାଣିଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ପୁଣି, ସେ କହିଲେ, “ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ମୋତେ ଆପଣା ମହିମା ଦେଖାଅ।” ");
INSERT INTO ory_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ସେ ଉତ୍ତର କଲେ, “ଆମ୍ଭେ ତୁମ୍ଭ ସମ୍ମୁଖ ଦେଇ ଆପଣାର ସମସ୍ତ ଉତ୍ତମତା ଗମନ କରାଇବା, ତୁମ୍ଭ ସମ୍ମୁଖରେ ସଦାପ୍ରଭୁଙ୍କର ନାମ ଘୋଷଣା କରିବା; ଆମ୍ଭେ ଯାହାକୁ ଅନୁଗ୍ରହ କରୁ, ତାହାକୁ ଅନୁଗ୍ରହ କରିବା ଓ ଯାହାକୁ ଦୟା କରୁ, ତାହାକୁ ଦୟା କରିବା।” ");
INSERT INTO ory_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ସେ ଆହୁରି କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭର ମୁଖ ଦେଖି ପାରିବ ନାହିଁ; କାରଣ ମନୁଷ୍ୟ ଆମ୍ଭଙ୍କୁ ଦେଖି ବଞ୍ଚିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ସଦାପ୍ରଭୁ କହିଲେ, “ଦେଖ, ଆମ୍ଭ ନିକଟରେ ଏକ ସ୍ଥାନ ଅଛି, ତୁମ୍ଭେ ସେହି ଶୈଳ ଉପରେ ଠିଆ ହେବ; ");
INSERT INTO ory_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ତହିଁରେ ତୁମ୍ଭ ନିକଟ ଦେଇ ଆମ୍ଭ ମହିମାର ଗମନ ସମୟରେ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଶୈଳର ସେହି ଛିଦ୍ରରେ ରଖିବା ଓ ଆମ୍ଭ ଗମନର ଶେଷ ପର୍ଯ୍ୟନ୍ତ ଆପଣା ହସ୍ତରେ ତୁମ୍ଭକୁ ଆଚ୍ଛନ୍ନ କରିବା। ");
INSERT INTO ory_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ଏଥିଉତ୍ତାରେ ଆମ୍ଭେ ଆପଣା ହସ୍ତ କାଢ଼ି ନେଲେ ତୁମ୍ଭେ ଆମ୍ଭର ପୃଷ୍ଠ ଦେଖିବ, ମାତ୍ର ଆମ୍ଭର ମୁଖ ଦେଖାଯିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ପୂର୍ବ ପରି ଦୁଇ ପ୍ରସ୍ତର ପଟା ଖୋଳ। ତୁମ୍ଭେ ଯେଉଁ ପ୍ରସ୍ତର ପଟା ଭାଙ୍ଗିଅଛ, ତହିଁ ଉପରେ ଯାହା ଯାହା ଲେଖାଥିଲା, ସେହି ସବୁ କଥା ଆମ୍ଭେ ଏହି ଦୁଇ ପ୍ରସ୍ତରରେ ଲେଖିବା। ");
INSERT INTO ory_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ଆଉ ତୁମ୍ଭେ ପ୍ରାତଃକାଳରେ ପ୍ରସ୍ତୁତ ହୁଅ ଓ ପ୍ରାତଃକାଳରେ ସୀନୟ ପର୍ବତ ଆରୋହଣ କରି ସେଠାରେ ପର୍ବତ ଶୃଙ୍ଗରେ ଆମ୍ଭ ନିକଟରେ ଉପସ୍ଥିତ ହୁଅ। ");
INSERT INTO ory_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ମାତ୍ର ତୁମ୍ଭ ସଙ୍ଗେ ଆଉ କେହି ଉପରକୁ ଆସିବେ ନାହିଁ, ପୁଣି, ଏହି ସମୁଦାୟ ପର୍ବତରେ କେହି ଦେଖା ନ ଯିବେ ଓ ଗୋମେଷାଦି ପଲ ମଧ୍ୟ ଏହି ପର୍ବତ ସମ୍ମୁଖରେ ଚରିବେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ତହୁଁ ମୋଶା ପ୍ରଥମ ପ୍ରସ୍ତର ପରି ଦୁଇ ପ୍ରସ୍ତର ପଟା ଖୋଳିଲେ; ପୁଣି, ସେ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ପ୍ରଭାତରେ ଉଠି ସୀନୟ ପର୍ବତ ଉପରକୁ ଗଲେ ଓ ସେହି ଦୁଇ ପ୍ରସ୍ତର ପଟା ହସ୍ତରେ ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ତେବେ ସଦାପ୍ରଭୁ ମେଘରେ ଅବରୋହଣ କରି ସେ ସ୍ଥାନରେ ତାଙ୍କ ସହିତ ଠିଆ ହୋଇ “ସଦାପ୍ରଭୁଙ୍କ” ନାମ ଘୋଷଣା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ଆଉ ସଦାପ୍ରଭୁ ତାଙ୍କ ସମ୍ମୁଖ ଦେଇ ଗମନ କରି ଏହା ଘୋଷଣା କଲେ, “ସଦାପ୍ରଭୁ, ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ସ୍ନେହଶୀଳ ଓ କୃପାମୟ, କ୍ରୋଧରେ ଧୀର, ଦୟା ଓ ସତ୍ୟତାରେ ପରିପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ସହସ୍ର ସହସ୍ର ପୁରୁଷ ପର୍ଯ୍ୟନ୍ତ ଦୟାରକ୍ଷାକାରୀ, ଅପରାଧ ଓ ଆଜ୍ଞାଲଙ୍ଘନ ଓ ପାପ କ୍ଷମାକାରୀ, ତଥାପି ନିତାନ୍ତ ତହିଁର ଦଣ୍ଡଦାତା, ତୃତୀୟ ଓ ଚତୁର୍ଥ ପୁରୁଷ ପର୍ଯ୍ୟନ୍ତ ପୁତ୍ରପୌତ୍ରାଦି ଉପରେ ପିତୃଗଣର ଅପରାଧର ପ୍ରତିଫଳଦାତା।” ");
INSERT INTO ory_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ତହୁଁ ମୋଶା ଶୀଘ୍ର ଭୂମିରେ ନତ ମସ୍ତକ ହୋଇ ପ୍ରଣାମ କରି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ପ୍ରଭୋ, ମୁଁ ଯଦି ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇଅଛି, ତେବେ ବିନୟ କରୁଅଛି, ପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ମଧ୍ୟବର୍ତ୍ତୀ ହୋଇ ଗମନ କରନ୍ତୁ; କାରଣ ଏମାନେ ଶକ୍ତଗ୍ରୀବ ଲୋକ, ଆଉ ଆମ୍ଭମାନଙ୍କ ଅପରାଧ ଓ ପାପ ମୋଚନ କରି ଆପଣା ଅଧିକାରାର୍ଥେ ଆମ୍ଭମାନଙ୍କୁ ଗ୍ରହଣ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ତେବେ ସେ କହିଲେ, “ଦେଖ, ମୁଁ ଗୋଟିଏ ନିୟମ କରିବି; ସମସ୍ତ ପୃଥିବୀରେ ଅବା କୌଣସି ଗୋଷ୍ଠୀ ମଧ୍ୟରେ ଯାହା କେବେ କରାଯାଇ ନାହିଁ, ଏପରି ଆଶ୍ଚର୍ଯ୍ୟକର୍ମ ଆମ୍ଭେ ତୁମ୍ଭର ସମସ୍ତ ଲୋକଙ୍କ ସାକ୍ଷାତରେ କରିବା; ତହିଁରେ ଯେଉଁସବୁ ଲୋକଙ୍କ ମଧ୍ୟରେ ତୁମ୍ଭେ ଅଛ, ସେମାନେ ସଦାପ୍ରଭୁଙ୍କର ସେହି କର୍ମ ଦେଖିବେ, କାରଣ ଆମ୍ଭେ ତୁମ୍ଭ ନିକଟରେ ଯାହା କରିବା, ତାହା ଭୟଙ୍କର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ଆଜି ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯାହା ଆଜ୍ଞା କରୁ, ତହିଁରେ ମନୋଯୋଗ କର; ଦେଖ, ଆମ୍ଭେ ଇମୋରୀୟ, କିଣାନୀୟ, ହିତ୍ତୀୟ, ପରିଷୀୟ, ହିବ୍ବୀୟ ଓ ଯିବୂଷୀୟ ଲୋକମାନଙ୍କୁ ତୁମ୍ଭ ଆଗରୁ ତଡ଼ିଦେବା। ");
INSERT INTO ory_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ତୁମ୍ଭେ ଆପଣା ବିଷୟରେ ସାବଧାନ ହୁଅ, ଯେଉଁ ଦେଶକୁ ତୁମ୍ଭେ ଯାଉଅଛ, ସେହି ଦେଶର ନିବାସୀମାନଙ୍କ ସହିତ ନିୟମ କର ନାହିଁ; କାଳେ ତାହା ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଗୋଟିଏ ଫାନ୍ଦ ସ୍ୱରୂପ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ମାତ୍ର ତୁମ୍ଭେମାନେ ସେମାନଙ୍କ ବେଦିସବୁ ଭଗ୍ନ କରିବ ଓ ସେମାନଙ୍କ ସ୍ତମ୍ଭସବୁ ଭାଙ୍ଗି ପକାଇବ ଓ ଆଶେରାର ମୂର୍ତ୍ତି କାଟି ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ଯେହେତୁ ତୁମ୍ଭେ ଅନ୍ୟ କୌଣସି ଦେବତାକୁ ପ୍ରଣାମ କରିବ ନାହିଁ, କାରଣ ସଦାପ୍ରଭୁଙ୍କ ନାମ (ସ୍ୱଗୌରବ ରକ୍ଷଣରେ) ଉଦ୍‍ଯୋଗୀ, ସେ (ସ୍ୱଗୌରବ ରକ୍ଷଣରେ) ଉଦ୍‍ଯୋଗୀ ପରମେଶ୍ୱର ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","କେଜାଣି ଅବା ତୁମ୍ଭେ ସେହି ଦେଶ ନିବାସୀ ଲୋକମାନଙ୍କ ସହିତ ନିୟମ କରିବ; କଲେ ଯେଉଁ ସମୟରେ ସେମାନେ ନିଜେ ଦେବଗଣର ଅନୁଗାମୀ ହୋଇ ବ୍ୟଭିଚାର କରନ୍ତି ଓ ନିଜ ଦେବଗଣ ନିକଟରେ ବଳିଦାନ କରନ୍ତି, ସେସମୟରେ କେହି ତୁମ୍ଭକୁ ଡାକିଲେ, ତୁମ୍ଭେ ତାହାର ବଳିଦ୍ରବ୍ୟ ଖାଇବ; ");
INSERT INTO ory_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","କିଅବା ତୁମ୍ଭେ ଆପଣା ପୁତ୍ରମାନଙ୍କ ନିମନ୍ତେ ସେମାନଙ୍କ କନ୍ୟାଗଣକୁ ଗ୍ରହଣ କଲେ, ସେମାନଙ୍କ କନ୍ୟାଗଣ ନିଜ ଦେବଗଣର ଅନୁଗାମିନୀ ହୋଇ ତୁମ୍ଭ ପୁତ୍ରଗଣକୁ ଆପଣାମାନଙ୍କ ଦେବଗଣର ଅନୁଗାମୀ କରି ବ୍ୟଭିଚାର କରାଇବେ। ");
INSERT INTO ory_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","ତୁମ୍ଭେ ଆପଣା ନିମନ୍ତେ ଛାଞ୍ଚରେ ଢଳା କୌଣସି ଦେବତା କର ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","ତୁମ୍ଭେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ଉତ୍ସବ ପାଳନ କରିବ, ପୁଣି, ଆବୀବ୍‍ ମାସର ଯେଉଁ ସମୟରେ ଯେରୂପ କରିବାକୁ ତୁମ୍ଭକୁ ଆଜ୍ଞା ଦେଇଅଛୁ, ସେହିରୂପେ ତୁମ୍ଭେ ସାତ ଦିନ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଖାଇବ; କାରଣ ସେହି ଆବୀବ୍‍ ମାସରେ ତୁମ୍ଭେ ମିସର ଦେଶରୁ ବାହାର ହୋଇ ଆସିଥିଲ। ");
INSERT INTO ory_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","ଆଉ ସମସ୍ତ ପ୍ରଥମଜାତ ଗର୍ଭଫଳ ଓ ଗୋମେଷାଦି ପଲ ମଧ୍ୟରୁ ପ୍ରଥମଜାତ ପୁଂପଶୁ ସକଳ ଆମ୍ଭର। ");
INSERT INTO ory_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ମାତ୍ର ପ୍ରଥମଜାତ ଗର୍ଦ୍ଦଭ ପରିବର୍ତ୍ତରେ ତୁମ୍ଭେ ମେଷଶାବକ ଦେଇ ତାକୁ ମୁକ୍ତ କରିବ; ଯଦି ମୁକ୍ତ ନ କରିବ, ତେବେ ତାʼର ବେକ ଭାଙ୍ଗିବ। ତୁମ୍ଭର ପ୍ରଥମଜାତ ପୁତ୍ର ସକଳକୁ ତୁମ୍ଭେ ମୁକ୍ତ କରିବ। ଆଉ, କେହି ଶୂନ୍ୟ ହସ୍ତରେ ଆମ୍ଭ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ତୁମ୍ଭେ ଛଅ ଦିନ କର୍ମ କରିବ, ମାତ୍ର ସପ୍ତମ ଦିନରେ ବିଶ୍ରାମ କରିବ; କୃଷି ଓ ଶସ୍ୟଚ୍ଛେଦନ ସମୟରେ ମଧ୍ୟ ବିଶ୍ରାମ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","ତୁମ୍ଭେ ସପ୍ତାହର ଉତ୍ସବ, ଅର୍ଥାତ୍‍, କଟା ଗହମର ପ୍ରଥମ ଫଳର ଉତ୍ସବ ଓ ବର୍ଷର ଶେଷ ଭାଗରେ ଫଳ ସଂଗ୍ରହର ଉତ୍ସବ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ତୁମ୍ଭମାନଙ୍କର ସମସ୍ତ ପୁରୁଷ ବର୍ଷ ମଧ୍ୟରେ ତିନି ଥର ଇସ୍ରାଏଲର ପ୍ରଭୁ ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଛାମୁରେ ଉପସ୍ଥିତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","କାରଣ ଆମ୍ଭେ ତୁମ୍ଭ ସମ୍ମୁଖରୁ ଅନ୍ୟ ଦେଶୀୟ ଲୋକମାନଙ୍କୁ ଦୂର କରିବା ଓ ତୁମ୍ଭର ସୀମା ବିସ୍ତାର କରିବା, ପୁଣି, ତୁମ୍ଭେ ବର୍ଷ ମଧ୍ୟରେ ତିନି ଥର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଛାମୁରେ ଉପସ୍ଥିତ ହେବା ନିମନ୍ତେ ଗମନ କଲେ, ତୁମ୍ଭ ଭୂମି ପ୍ରତି କେହି ଲୋଭ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","ତୁମ୍ଭେ ଆମ୍ଭ ବଳିର ରକ୍ତ ତାଡ଼ିଯୁକ୍ତ ଦ୍ରବ୍ୟ ସହିତ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ ଓ ନିସ୍ତାରପର୍ବୀୟ ଉତ୍ସବର ବଳିଦ୍ରବ୍ୟ ପ୍ରାତଃକାଳ ପର୍ଯ୍ୟନ୍ତ ରଖିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","ତୁମ୍ଭେ ଆପଣା ଭୂମିର ପ୍ରଥମଜାତ ଫଳର ଅଗ୍ରିମାଂଶ ଆପଣା ସଦାପ୍ରଭୁ ପରମେଶ୍ୱରଙ୍କ ଗୃହକୁ ଆଣିବ। ପୁଣି, ତୁମ୍ଭେ ଛାଗର ଶାବକକୁ ତାହାର ମାତାର ଦୁଗ୍ଧରେ ପାକ କରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ଆଉ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଏହିସବୁ ବାକ୍ୟ ଲେଖ, କାରଣ ଆମ୍ଭେ ଏହି ବାକ୍ୟାନୁସାରେ ତୁମ୍ଭ ସହିତ ଓ ଇସ୍ରାଏଲ ସହିତ ନିୟମ ସ୍ଥିର କରିଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ସେହି ସମୟରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ସହିତ ସେହି ସ୍ଥାନରେ ଚାଳିଶ ଦିବାରାତ୍ର ଅବସ୍ଥାନ କଲେ; ସେ ଅନ୍ନ ଭୋଜନ କି ଜଳ ପାନ କଲେ ନାହିଁ। ସେ ସେହି ଦୁଇ ପ୍ରସ୍ତରରେ ନିୟମ-ବାକ୍ୟ, ଅର୍ଥାତ୍‍, ଦଶ ଆଜ୍ଞା ଲେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ଏଥିଉତ୍ତାରେ ମୋଶା ସୀନୟ ପର୍ବତରୁ ଓହ୍ଲାଇବା ସମୟରେ ସାକ୍ଷ୍ୟରୂପ ଦୁଇ ଖଣ୍ଡ ପ୍ରସ୍ତର ହସ୍ତରେ ଘେନି ପର୍ବତରୁ ଓହ୍ଲାଇଲେ, ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ସହିତ ଆଳାପ କରିବା ସକାଶୁ ଆପଣା ମୁଖର ଚର୍ମ ଯେ ଉଜ୍ଜ୍ୱଳ ହୋଇଥିଲା, ତାହା ମୋଶା ଜାଣି ନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ପୁଣି, ଯେତେବେଳେ ହାରୋଣ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମୋଶାଙ୍କୁ ଦେଖିଲେ, ସେତେବେଳେ ତାଙ୍କର ମୁଖର ଚର୍ମ ଉଜ୍ଜ୍ୱଳ ଥିଲା; ଏଣୁ ସେମାନେ ତାଙ୍କ ନିକଟକୁ ଯିବା ପାଇଁ ଭୀତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ମାତ୍ର ମୋଶା ସେମାନଙ୍କୁ ଡାକନ୍ତେ, ହାରୋଣ ଓ ମଣ୍ଡଳୀର ଅଧ୍ୟକ୍ଷଗଣ ତାଙ୍କ ନିକଟକୁ ଫେରିଗଲେ; ତହିଁରେ ମୋଶା ସେମାନଙ୍କ ସହିତ ଆଳାପ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ତହିଁ ଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ତାଙ୍କ ନିକଟକୁ ଗଲେ; ତହିଁରେ ସଦାପ୍ରଭୁ ସୀନୟ ପର୍ବତରେ ତାଙ୍କୁ ଯେଉଁ ଯେଉଁ କଥା କହିଥିଲେ, ତାହାସବୁ ସେ ଆଜ୍ଞା ରୂପେ ସେମାନଙ୍କୁ ଜଣାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ଆଉ, ମୋଶା ସେମାନଙ୍କ ସହିତ କଥୋପକଥନ ସମାପନ କଲା ଉତ୍ତାରେ ଆପଣା ମୁଖରେ ଘୁମୁଟା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ମାତ୍ର ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ସହିତ କଥା କହିବା ପାଇଁ ଭିତରେ ତାହାଙ୍କ ସାକ୍ଷାତକୁ ଯାଇ ବାହାରକୁ ନ ଆସିବା ପର୍ଯ୍ୟନ୍ତ ସେହି ଘୁମୁଟା କାଢ଼ି ରଖିଲେ; ଆଉ ଯେଉଁ ଆଜ୍ଞା ପାଇଲେ, ବାହାରେ ଆସି ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ତାହା କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ତହିଁରେ ମୋଶାଙ୍କର ମୁଖର ଚର୍ମ ଉଜ୍ଜ୍ୱଳ ଅଟେ, ଏହା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ତାଙ୍କର ମୁଖ ପ୍ରତି ଅନାଇ ଦେଖିଲେ; ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ସହିତ କଥା କହିବାକୁ ଯେପର୍ଯ୍ୟନ୍ତ ଭିତରକୁ ନ ଗଲେ; ସେପର୍ଯ୍ୟନ୍ତ ଆପଣା ମୁଖରେ ଘୁମୁଟା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ତହିଁ ଉତ୍ତାରେ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀକୁ ଏକତ୍ର କରି କହିଲେ, “ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କୁ ଏହି ସମସ୍ତ ବାକ୍ୟ ପାଳନ କରିବାକୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ଛଅ ଦିନ କର୍ମ କରାଯିବ, ମାତ୍ର ସପ୍ତମ ଦିନ ତୁମ୍ଭମାନଙ୍କ ନିକଟରେ ପବିତ୍ର ଦିନ ହେବ; ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମହା ବିଶ୍ରାମବାର ହେବ, ଯେକେହି ସେହି ଦିନ କର୍ମ କରିବ, ତାହାର ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ତୁମ୍ଭେମାନେ ବିଶ୍ରାମବାରରେ ଆପଣାମାନଙ୍କ କୌଣସି ବାସ ସ୍ଥାନରେ ଅଗ୍ନି ଜାଳିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ଆଉ, ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀକୁ ଆହୁରି କହିଲେ, “ସଦାପ୍ରଭୁ ଏହି ଆଜ୍ଞା ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ନିମନ୍ତେ ଆପଣାମାନଙ୍କ ମଧ୍ୟରୁ ଉପହାର ସଂଗ୍ରହ କର; ଯେକେହି ସ୍ୱଚ୍ଛନ୍ଦମନା, ସେ ସଦାପ୍ରଭୁଙ୍କ ନିମନ୍ତେ ସ୍ୱର୍ଣ୍ଣ, ରୌପ୍ୟ ଓ ପିତ୍ତଳ, ");
INSERT INTO ory_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ପୁଣି, ନୀଳବର୍ଣ୍ଣ, ଧୂମ୍ରବର୍ଣ୍ଣ, ସିନ୍ଦୂର ବର୍ଣ୍ଣ, ଶୁଭ୍ର, କ୍ଷୌମସୂତ୍ର ଓ ଛାଗର ଲୋମ, ");
INSERT INTO ory_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ପୁଣି, ରକ୍ତୀକୃତ ମେଷ ଚର୍ମ, ଶିଶୁକ ଚର୍ମ ଓ ଶିଟୀମ୍‍ କାଷ୍ଠ, ");
INSERT INTO ory_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ପୁଣି, ଦୀପାର୍ଥକ ତୈଳ, ଅଭିଷେକାର୍ଥକ ତୈଳ ଓ ସୁଗନ୍ଧି ଧୂପାର୍ଥକ ଗନ୍ଧଦ୍ରବ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ପୁଣି, ଏଫୋଦ ଓ ବୁକୁପଟା ନିମନ୍ତେ ଗୋମେଦକ ମଣି ପ୍ରଭୃତି ଖଚନୀୟ ପ୍ରସ୍ତର, ଏହି ସମସ୍ତ ସଦାପ୍ରଭୁଙ୍କର ଉପହାର ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","ଆଉ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରୁ ପ୍ରତ୍ୟେକ ବିଜ୍ଞମନା ଲୋକ ଆସି ସଦାପ୍ରଭୁଙ୍କର ଆଦିଷ୍ଟ ସକଳ ବସ୍ତୁ ନିର୍ମାଣ କରନ୍ତୁ, ");
INSERT INTO ory_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ଅର୍ଥାତ୍‍, ଆବାସ, ତହିଁର ତମ୍ବୁ, ଛାତ, ଆଙ୍କୁଡ଼ା, ପଟା, ଅର୍ଗଳ, ସ୍ତମ୍ଭ ଓ ଚୁଙ୍ଗୀ, ");
INSERT INTO ory_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ପୁଣି, ସିନ୍ଦୁକ, ତହିଁର ସାଙ୍ଗୀ, ପାପାଚ୍ଛାଦନ ଓ ଆଚ୍ଛାଦନର ବିଚ୍ଛେଦ ବସ୍ତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ପୁଣି, ମେଜ, ତହିଁର ସାଙ୍ଗୀ, ପାତ୍ରସକଳ ଓ ଦର୍ଶନୀୟ ରୁଟି, ");
INSERT INTO ory_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ପୁଣି, ଦୀପ୍ତି ନିମନ୍ତେ ଦୀପବୃକ୍ଷ, ତହିଁର ପାତ୍ର, ପ୍ରଦୀପ ଓ ଦୀପାର୍ଥକ ତୈଳ, ");
INSERT INTO ory_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ପୁଣି, ଧୂପବେଦି, ତହିଁର ସାଙ୍ଗୀ, ଅଭିଷେକାର୍ଥକ ତୈଳ, ସୁଗନ୍ଧି ଧୂପ ଓ ଆବାସ ପ୍ରବେଶ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ପୁଣି, ହୋମବେଦି, ତହିଁର ପିତ୍ତଳ-ଝାଞ୍ଜିରୀ, ସାଙ୍ଗୀ, ପାତ୍ରସକଳ, ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ଓ ତହିଁର ବୈଠିକି, ");
INSERT INTO ory_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ପୁଣି, ପ୍ରାଙ୍ଗଣର ପରଦା, ତହିଁର ସ୍ତମ୍ଭ, ଚୁଙ୍ଗୀ ଓ ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ପୁଣି, ଆବାସର କଣ୍ଟା, ପ୍ରାଙ୍ଗଣର କଣ୍ଟା ଓ ଉଭୟର ରଜ୍ଜୁ, ");
INSERT INTO ory_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ପୁଣି, ପବିତ୍ର ସ୍ଥାନରେ ସେବା କରିବା ନିମନ୍ତେ ସୁଶୋଭିତ ବସ୍ତ୍ର, ଅର୍ଥାତ୍‍, ହାରୋଣ ଯାଜକଙ୍କ ନିମନ୍ତେ ପବିତ୍ର ବସ୍ତ୍ର ଓ ଯାଜକ କର୍ମ ନିମନ୍ତେ ତାଙ୍କର ପୁତ୍ରମାନଙ୍କର ବସ୍ତ୍ର, ଏହି ସମସ୍ତ ପ୍ରସ୍ତୁତ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀ ମୋଶାଙ୍କ ସମ୍ମୁଖରୁ ପ୍ରସ୍ଥାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ପୁଣି, ଯାହାର ମନ ଯାହାକୁ ପ୍ରବର୍ତ୍ତାଇଲା ଓ ଯାହାର ଆତ୍ମା ଯାହାକୁ ଇଚ୍ଛୁକ କଲା, ସେମାନେ ସମାଗମ-ତମ୍ବୁ ନିର୍ମାଣ ନିମନ୍ତେ ଓ ତତ୍‍ସମ୍ବନ୍ଧୀୟ ସମସ୍ତ କାର୍ଯ୍ୟ ଓ ପବିତ୍ର ବସ୍ତ୍ର ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କର ଉପହାର ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ପୁଣି, ପୁରୁଷ ଓ ସ୍ତ୍ରୀ ଯେତେ ଲୋକ ସ୍ୱଚ୍ଛନ୍ଦମନା ଥିଲେ, ସେସମସ୍ତେ ଆସି ଉରୋମଣି, କୁଣ୍ଡଳ, ଅଙ୍ଗୁରୀୟ ଓ ହାର ପ୍ରଭୃତି ସ୍ୱର୍ଣ୍ଣ ଅଳଙ୍କାରସବୁ ଆଣିଲେ; ପ୍ରତ୍ୟେକ ଜଣ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସ୍ୱର୍ଣ୍ଣର ଉପହାର ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ପୁଣି, ଯେଉଁମାନଙ୍କ ନିକଟରେ ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ, ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର, ଛାଗର ଲୋମ, ରକ୍ତୀକୃତ ମେଷ ଚର୍ମ ଓ ଶିଶୁକ ଚର୍ମ ଥିଲା, ସେମାନେ ପ୍ରତ୍ୟେକେ ତାହା ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ପୁଣି, ଯେ ରୂପାର କି ପିତ୍ତଳର ଉପହାର ଉତ୍ସର୍ଗ କଲା, ସେ ସଦାପ୍ରଭୁଙ୍କର ଉପହାର ଆଣିଲା; ଆଉ ଯାହା ନିକଟରେ ସେବାର କୌଣସି କର୍ମ ନିମନ୍ତେ ଶିଟୀମ୍‍ କାଷ୍ଠ ଥିଲା, ସେ ତାହା ଆଣିଲା। ");
INSERT INTO ory_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ବୁଦ୍ଧିମତୀ ସ୍ତ୍ରୀମାନେ ଆପଣା ଆପଣା ହସ୍ତରେ ସୂତା କାଟି ନୀଳ ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ପୁଣି, ଯେଉଁ ସ୍ତ୍ରୀମାନଙ୍କର ମନ ଜ୍ଞାନରେ ପ୍ରବୃତ୍ତ ହେଲା, ସେସମସ୍ତେ ଛାଗ ଲୋମର ସୂତା କାଟିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ପୁଣି, ଅଧ୍ୟକ୍ଷଗଣ ଏଫୋଦ ଓ ବୁକୁପଟା ନିମନ୍ତେ ଗୋମେଦକାଦି ଖଚନାର୍ଥକ ମଣି, ");
INSERT INTO ory_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ଆଉ ଦୀପ ଓ ଅଭିଷେକାର୍ଥକ ତୈଳ ଓ ସୁଗନ୍ଧି ଧୂପ ନିମନ୍ତେ ଗନ୍ଧଦ୍ରବ୍ୟ ଓ ତୈଳ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସ୍ୱେଚ୍ଛାରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉପହାର ଆଣିଲେ; ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ଦ୍ୱାରା ଯାହା ଯାହା କରିବାକୁ ଆଜ୍ଞା ଦେଇଥିଲେ, ତହିଁର କୌଣସି ପ୍ରକାର କର୍ମ କରିବା ପାଇଁ ଯେଉଁ ଯେଉଁ ପୁରୁଷ ଓ ସ୍ତ୍ରୀମାନଙ୍କର ମନ ସେମାନଙ୍କୁ ଇଚ୍ଛୁକ କଲା, ସେମାନେ ପ୍ରତ୍ୟେକେ ଉପହାର ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ଏଥିଉତ୍ତାରେ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଆହୁରି କହିଲେ, “ଦେଖ, ସଦାପ୍ରଭୁ ଯିହୁଦା ବଂଶୀୟ ହୂରର ପୌତ୍ର ଊରିର ପୁତ୍ର ବତ୍ସଲେଲକୁ ନାମ ଧରି ଡାକିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ପୁଣି, ତାହାକୁ ଜ୍ଞାନ, ବୁଦ୍ଧି, ବିଦ୍ୟା ଓ କର୍ମନୈପୁଣ୍ୟ-ଦାୟକ ପରମେଶ୍ୱରଙ୍କ ଆତ୍ମାରେ ପରିପୂର୍ଣ୍ଣ କରି ");
INSERT INTO ory_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ଚିତ୍ର କର୍ମ ଓ ସ୍ୱର୍ଣ୍ଣ, ରୌପ୍ୟ ଓ ପିତ୍ତଳ ଖୋଦନ ");
INSERT INTO ory_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ଓ ଖଚନାର୍ଥକ ମଣିର କର୍ତ୍ତନ ଓ ନାନା ଶିଳ୍ପକର୍ମ ନିମନ୍ତେ କାଷ୍ଠ ଖୋଦନ, ଏହିସବୁ ଶିଳ୍ପକର୍ମ କରିବା ପାଇଁ ତାହାକୁ ନିପୁଣ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ପୁଣି, ଶିକ୍ଷା ଦେବା ପାଇଁ ତାହାର ଓ ଦାନ୍ ବଂଶୀୟ ଅହୀଷାମକର ପୁତ୍ର ଅହଲୀୟାବର ମନରେ ପ୍ରବୃତ୍ତି ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ଆଉ ଖୋଦନ ଓ ଶିଳ୍ପକର୍ମ କରିବା ନିମନ୍ତେ, ପୁଣି, ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ସୂଚି କର୍ମ ଓ ତନ୍ତୀ କର୍ମ କରିବା ନିମନ୍ତେ, ଅର୍ଥାତ୍‍, ଯାବତୀୟ ଶିଳ୍ପକର୍ମ ଓ ଚିତ୍ର କର୍ମ କରିବା ପାଇଁ ସେମାନଙ୍କ ମନକୁ ଜ୍ଞାନରେ ପରିପୂର୍ଣ୍ଣ କରିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“ଏନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କର ସମସ୍ତ ଆଜ୍ଞାନୁସାରେ ପବିତ୍ର ସ୍ଥାନର କାର୍ଯ୍ୟସକଳ ନିର୍ମାଣ କରିବାକୁ ସଦାପ୍ରଭୁ ବତ୍ସଲେଲ ଓ ଅହଲୀୟାବ ପ୍ରଭୃତି ଯେଉଁମାନଙ୍କୁ ଜ୍ଞାନ ଓ ବୁଦ୍ଧି ଦେଇଅଛନ୍ତି, ସେହି ସବୁ ବିଜ୍ଞମନା ଲୋକେ କର୍ମ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ଏଥିଉତ୍ତାରେ ମୋଶା ସେହି ବତ୍ସଲେଲ, ଅହଲୀୟାବକୁ, ସଦାପ୍ରଭୁଙ୍କଠାରୁ ମନରେ ଜ୍ଞାନପ୍ରାପ୍ତ ଅନ୍ୟସବୁ ବିଜ୍ଞମନା ଲୋକଙ୍କୁ ଓ ସେହି କର୍ମ କରିବା ପାଇଁ ମନରେ ପ୍ରବୃତ୍ତିପ୍ରାପ୍ତ ଲୋକମାନଙ୍କୁ ଡାକିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ତହିଁରେ ସେମାନେ ପବିତ୍ର ସ୍ଥାନର କାର୍ଯ୍ୟ ନିର୍ମାଣ କରିବା ନିମନ୍ତେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଆନୀତ ଉପହାର ସବୁ ମୋଶାଙ୍କଠାରୁ ଗ୍ରହଣ କଲେ; ତଥାପି ଲୋକମାନେ ପ୍ରତି ପ୍ରଭାତରେ ତାଙ୍କ ନିକଟକୁ ସ୍ୱେଚ୍ଛାରେ ଆହୁରି ଉପହାର ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ତହୁଁ ପବିତ୍ର ସ୍ଥାନର ସମସ୍ତ କର୍ମକାରୀ ବିଜ୍ଞମନା ଲୋକମାନେ ଆପଣା ଆପଣା କର୍ମରୁ ଆସି ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“ସଦାପ୍ରଭୁ ଯାହା ଯାହା ନିର୍ମାଣ କରିବାକୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ଲୋକମାନେ ସେହି କାର୍ଯ୍ୟ ନିମନ୍ତେ ପ୍ରୟୋଜନୀୟ ଦ୍ରବ୍ୟରୁ ଅତି ଅଧିକ ଆଣୁଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ତହିଁରେ ମୋଶା ଆଜ୍ଞା ଦେଇ ଛାଉଣିର ସର୍ବତ୍ର ଏହା ଘୋଷଣା କରାଇଲେ, ପୁରୁଷ କି ସ୍ତ୍ରୀ ପବିତ୍ର ସ୍ଥାନ ନିମନ୍ତେ ଆଉ ଉପହାର ପ୍ରସ୍ତୁତ ନ କରନ୍ତୁ; ଏଣୁ ଲୋକମାନେ ଆଣିବାରୁ ନିବୃତ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","କାରଣ ସମସ୍ତ କର୍ମ କରିବାକୁ ସେମାନଙ୍କର ଦ୍ରବ୍ୟ ପ୍ରଚୁର ଓ ତତୋଧିକ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ଏଥିଉତ୍ତାରେ କର୍ମକାରୀମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରତ୍ୟେକ ବିଜ୍ଞମନା ଲୋକ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର, ନୀଳ, ଧୂମ୍ର ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣ ସୂତ୍ର ଦ୍ୱାରା ଆବାସର ଦଶ ଯବନିକା ପ୍ରସ୍ତୁତ କଲେ; ପୁଣି, ତହିଁ ମଧ୍ୟରେ ଶିଳ୍ପକର୍ମରେ କିରୂବର ଆକୃତି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ପ୍ରତ୍ୟେକ ଯବନିକା ଅଠାଇଶ ହସ୍ତ ଦୀର୍ଘ, ପ୍ରତ୍ୟେକ ଯବନିକା ଚାରି ହସ୍ତ ପ୍ରସ୍ଥ ଓ ସମସ୍ତ ଯବନିକାର ସମାନ ପରିମାଣ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ପୁଣି, ସେ ପାଞ୍ଚ ଯବନିକା ଏକତ୍ର ଯୋଗ କଲେ; ଅନ୍ୟ ପାଞ୍ଚ ଯବନିକା ଏକତ୍ର ଯୋଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ଆଉ, ସେ ଯୋଡ଼ ସ୍ଥାନରେ ପ୍ରଥମ ଅନ୍ତ୍ୟ ଯବନିକାର ଧଡ଼ିରେ ନୀଳ ସୂତ୍ରର ଫାଶ କଲେ; ଯୋଡ଼ସ୍ଥାନର ଦ୍ୱିତୀୟ ଅନ୍ତ୍ୟ ଯବନିକାର ଧଡ଼ିରେ ତଦ୍ରୂପ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ସେ ପ୍ରଥମ ଯବନିକାର ଧଡ଼ିରେ ପଚାଶ ଫାଶ ଓ ଯୋଡ଼ସ୍ଥାନର ଦ୍ୱିତୀୟ ଯବନିକାର ଧଡ଼ିରେ ପଚାଶ ଫାଶ କଲେ; ସେହି ଫାଶସବୁ ପରସ୍ପର ସମ୍ମୁଖୀନ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ଆଉ ସେ ପଚାଶ ସ୍ୱର୍ଣ୍ଣ ଆଙ୍କୁଡ଼ା କରି ଆଙ୍କୁଡ଼ାରେ ଯବନିକାସକଳ ପରସ୍ପର ଯୋଡ଼ିଲେ; ତହିଁରେ ଆବାସ ଏକ ହିଁ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ଏଉତ୍ତାରେ ସେ ଆବାସର ଆଚ୍ଛାଦନାର୍ଥକ ତମ୍ବୁ ନିମନ୍ତେ ଛାଗ ଲୋମର ଏକାଦଶ ଯବନିକା ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ପ୍ରତ୍ୟେକ ଯବନିକାର ଦୈର୍ଘ୍ୟ ତିରିଶ ହସ୍ତ ଓ ପ୍ରସ୍ଥ ଚାରି ହସ୍ତ, ସେହି ଏକାଦଶ ଯବନିକାର ସମାନ ପରିମାଣ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ପୁଣି, ସେ ପାଞ୍ଚ ଯବନିକା ପରସ୍ପର ଯୋଡ଼ି ପୃଥକ ରଖିଲେ ଓ ଅନ୍ୟ ଛଅ ଯବନିକା ଯୋଡ଼ି ପୃଥକ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ଯୋଡ଼ସ୍ଥାନର ପ୍ରଥମ ଅନ୍ତ୍ୟ ଯବନିକାର ଧଡ଼ିରେ ପଚାଶ ଫାଶ କଲେ ଓ ଦ୍ୱିତୀୟ ଯବନିକାର ଯୋଡ଼ସ୍ଥାନ ଧଡ଼ିରେ ପଚାଶ ଫାଶ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ଆଉ ସେ ଯୋଡି଼ ଦେଇ ଏକ ତମ୍ବୁ କରିବା ପାଇଁ ପିତ୍ତଳର ପଚାଶ ଆଙ୍କୁଡ଼ା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ପୁଣି, ସେ ରକ୍ତୀକୃତ ମେଷ ଚର୍ମରେ ତମ୍ବୁର ଏକ ଛାତ ଓ ତହିଁ ଉପରେ ଶିଶୁକ ଚର୍ମର ଏକ ଛାତ ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ଏଥିଉତ୍ତାରେ ସେ ଆବାସ ନିମିତ୍ତ ଶିଟୀମ୍‍ କାଷ୍ଠର ଠିଆପଟା ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ଏକ ଏକ ପଟା ଦଶ ହସ୍ତ ଦୀର୍ଘ ଓ ଦେଢ଼ ହସ୍ତ ପ୍ରସ୍ଥ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ପ୍ରତ୍ୟେକ ପଟାର ପରସ୍ପର ଅନୁରୂପ ଦୁଇ ଦୁଇ ପଦ ଥିଲା; ଏହିରୂପେ ସେ ଆବାସର ସମସ୍ତ ପଟା ନିମନ୍ତେ ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ଆଉ ସେ ଆବାସର ଦକ୍ଷିଣ ଦିଗସ୍ଥ ଦକ୍ଷିଣ ପାର୍ଶ୍ୱ ନିମନ୍ତେ କୋଡ଼ିଏ ପଟା ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ପୁଣି, ସେ ସେହି କୋଡ଼ିଏ ପଟା ତଳେ ଚାଳିଶଟି ରୂପାର ଚୁଙ୍ଗୀ କଲେ; ଏକ ପଟା ତଳେ ତହିଁର ଦୁଇ ପଦ ନିମନ୍ତେ ଦୁଇ ଚୁଙ୍ଗୀ ଓ ଅନ୍ୟାନ୍ୟ ପଟା ତଳେ ସେମାନଙ୍କ ଦୁଇ ଦୁଇ ପଦ ନିମନ୍ତେ ଦୁଇ ଦୁଇ ଚୁଙ୍ଗୀ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ପୁଣି, ଆବାସର ଅନ୍ୟ ପାର୍ଶ୍ୱ ନିମନ୍ତେ ଉତ୍ତର ଦିଗରେ କୋଡ଼ିଏ ପଟା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ଏକ ପଟା ତଳେ ଦୁଇ ଚୁଙ୍ଗୀ ଓ ଅନ୍ୟାନ୍ୟ ପଟା ତଳେ ଦୁଇ ଦୁଇ ଚୁଙ୍ଗୀ, ଏରୂପେ ରୂପାର ଚାଳିଶ ଚୁଙ୍ଗୀ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ସେ ଆବାସର ପଶ୍ଚିମ ଦିଗସ୍ଥ ପଶ୍ଚାତ୍‍ ପାର୍ଶ୍ୱ ନିମନ୍ତେ ଛଅ ଖଣ୍ଡ ପଟା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ପୁଣି, ଆବାସର ସେହି ପଶ୍ଚାଦ୍‍ ଭାଗର ଦୁଇ କୋଣ ନିମନ୍ତେ ଦୁଇ ଖଣ୍ଡ ପଟା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ପୁଣି, ତହିଁ ତଳେ ଯୋଡ଼ା ରହିଲା ଓ ସେହିରୂପ ତହିଁର ମୁଣ୍ଡରେ ପ୍ରଥମ କଡ଼ା ପାଖରେ ଯୋଡ଼ ରହିଲା; ଏହି ପ୍ରକାରେ ସେ ଦୁଇ କୋଣର ପଟା ଯୋଡ଼ିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ତହିଁରେ ଆଠ ପଟା, ପୁଣି, ଏକ ଏକ ପଟା ତଳେ ଦୁଇ ଦୁଇ ଚୁଙ୍ଗୀ, ଏରୂପେ ଷୋଳ ରୂପାଚୁଙ୍ଗୀ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ଆଉ ସେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ଅର୍ଗଳ ପ୍ରସ୍ତୁତ କରି ଆବାସର ଏକ ପାର୍ଶ୍ୱସ୍ଥ ପଟାରେ ପାଞ୍ଚ ଅର୍ଗଳ ");
INSERT INTO ory_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ଓ ଅନ୍ୟ ପାର୍ଶ୍ୱସ୍ଥ ପଟାରେ ପାଞ୍ଚ ଅର୍ଗଳ, ପୁଣି, ଆବାସର ପଶ୍ଚିମ ଦିଗସ୍ଥ ପଶ୍ଚାତ୍‍ ପାର୍ଶ୍ୱର ପଟାରେ ପାଞ୍ଚ ଅର୍ଗଳ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ପୁଣି, ମଧ୍ୟସ୍ଥିତ ଅର୍ଗଳ, ପଟାର ମଧ୍ୟଦେଶରେ ଏ ମୁଣ୍ଡରୁ ସେମୁଣ୍ଡ ଯାଏ ପାଇଲା। ");
INSERT INTO ory_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ଆଉ, ସେ ସେହି ସବୁ ପଟା ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ ଓ ଅର୍ଗଳର ଘରା ନିମନ୍ତେ ସୁବର୍ଣ୍ଣର କଡ଼ା କଲେ, ଅର୍ଗଳସକଳ ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ଏଥିଉତ୍ତାରେ ସେ ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ, ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନିର୍ମିତ ଓ କିରୂବାକୃତିରେ ଚିତ୍ରିତ ଏକ ବିଚ୍ଛେଦ ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ପୁଣି, ସେ ତହିଁ ନିମନ୍ତେ ଶିଟୀମ୍‍ କାଷ୍ଠର ଚାରି ସ୍ତମ୍ଭ କରି ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ ଓ ସେସବୁର ଆଙ୍କୁଡ଼ା ସୁବର୍ଣ୍ଣରେ କଲେ ଓ ତହିଁ ନିମନ୍ତେ ରୂପାର ଚାରି ଚୁଙ୍ଗୀ ଢାଳିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ଆଉ, ସେ ତମ୍ବୁଦ୍ୱାର ନିମନ୍ତେ ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନିର୍ମିତ ଚିତ୍ରବିଚିତ୍ର ଏକ ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ତହିଁର ପାଞ୍ଚ ସ୍ତମ୍ଭ ଓ ସେସବୁର ଆଙ୍କୁଡ଼ା କଲେ; ପୁଣି, ସେହିସବୁର ମୁଣ୍ଡାଳି ଓ ବନ୍ଧନୀ ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ, ମାତ୍ର ସେମାନଙ୍କର ପାଞ୍ଚ ଚୁଙ୍ଗୀ ପିତ୍ତଳର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ଏଥିଉତ୍ତାରେ ବତ୍ସଲେଲ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ଅଢ଼ାଇ ହସ୍ତ ଦୀର୍ଘ ଓ ଦେଢ଼ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ଦେଢ଼ ହସ୍ତ ଉଚ୍ଚ, ଏକ ସିନ୍ଦୁକ ନିର୍ମାଣ କଲେ ");
INSERT INTO ory_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ଓ ତହିଁର ଭିତର ଓ ବାହାର ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇ ତହିଁର ଚତୁର୍ଦ୍ଦିଗରେ ସୁବର୍ଣ୍ଣର କାନ୍ଥି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ପୁଣି, ତହିଁର ଚାରି କୋଣ ନିମନ୍ତେ ଚାରି ସ୍ୱର୍ଣ୍ଣକଡ଼ା ଢାଳିଲେ; ତହିଁର ଏକ ପାର୍ଶ୍ୱରେ ଦୁଇ କଡ଼ା ଓ ଅନ୍ୟ ପାର୍ଶ୍ୱରେ ଦୁଇ କଡ଼ା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ଆଉ ସେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ସାଙ୍ଗୀ କରି ସୁବର୍ଣ୍ଣ ମଡ଼ାଇଲେ ");
INSERT INTO ory_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ଓ ସିନ୍ଦୁକ ବହିବା ନିମନ୍ତେ ସିନ୍ଦୁକର ପାର୍ଶ୍ୱସ୍ଥ କଡ଼ାରେ ସେହି ସାଙ୍ଗୀ ପ୍ରବେଶ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ଏଉତ୍ତାରେ ସେ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ଅଢ଼ାଇ ହସ୍ତ ଦୀର୍ଘ ଓ ଦେଢ଼ ହସ୍ତ ପ୍ରସ୍ଥ ଏକ ପାପାଚ୍ଛାଦନ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ପୁଣି, ପିଟା ସୁବର୍ଣ୍ଣରେ ଦୁଇ କିରୂବ ନିର୍ମାଣ କରି ପାପାଚ୍ଛାଦନର ଦୁଇ ମୁଣ୍ଡରେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ତହିଁର ଏକ ମୁଣ୍ଡରେ ଏକ କିରୂବ ଓ ଅନ୍ୟ ମୁଣ୍ଡରେ ଅନ୍ୟ କିରୂବ ସ୍ଥାପନ କଲେ; ପାପାଚ୍ଛାଦନର ଦୁଇ ମୁଣ୍ଡରେ ଦୁଇ କିରୂବକୁ ତହିଁର ଅଂଶ କରି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ପୁଣି, କିରୂବମାନଙ୍କର ପକ୍ଷ ଉର୍ଦ୍ଧ୍ବକୁ ବିସ୍ତାରିତ ହୋଇ ପାପାଚ୍ଛାଦନକୁ ଆବରଣ କଲା ଓ ସେମାନଙ୍କର ମୁଖ ପରସ୍ପର ସମ୍ମୁଖୀନ ହେଲା; ମାତ୍ର ପାପାଚ୍ଛାଦନ ପ୍ରତି କିରୂବମାନଙ୍କର ମୁଖ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ତହିଁ ଉତ୍ତାରେ ସେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ଦୁଇ ହସ୍ତ ଦୀର୍ଘ ଓ ଏକ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ଦେଢ଼ ହସ୍ତ ଉଚ୍ଚ ଗୋଟିଏ ମେଜ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ପୁଣି, ତାହା ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ ଓ ତହିଁର ଚତୁର୍ଦ୍ଦିଗରେ ସୁବର୍ଣ୍ଣର କାନ୍ଥି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ପୁଣି, ସେ ତହିଁର ଚତୁର୍ଦ୍ଦିଗରେ ଚତୁରଙ୍ଗୁଳି ପରିମିତ ଏକ ବେଷ୍ଟନ କଲେ ଓ ସେହି ବେଷ୍ଟନର ଚତୁର୍ଦ୍ଦିଗରେ ସୁବର୍ଣ୍ଣର କାନ୍ଥି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ଆଉ ସୁବର୍ଣ୍ଣରେ ଚାରି କଡ଼ା ଢାଳି ତହିଁର ଚାରି ପାହ୍ୟାର ଚାରି କୋଣରେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ସେହି କଡ଼ା ପାର୍ଶ୍ୱ-କାଷ୍ଠର ସନ୍ନିକଟ ଓ ମେଜ ବହିବା ନିମନ୍ତେ ସାଙ୍ଗୀର ଘରା ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ପୁଣି, ସେ ସେହି ମେଜ ବହନାର୍ଥେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ସାଙ୍ଗୀ ନିର୍ମାଣ କରି ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ଆହୁରି, ସେ ମେଜର ଉପରିସ୍ଥିତ ପାତ୍ରସକଳ, ଅର୍ଥାତ୍‍, ତହିଁର ଥାଳୀ ଓ ଚାମଚ ଓ ପାତ୍ର, ଢାଳିବା ନିମନ୍ତେ ଗଡ଼ୁସକଳ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ଆହୁରି, ସେ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ଏକ ଦୀପବୃକ୍ଷ ନିର୍ମାଣ କଲେ, ସେ ପିଟାକର୍ମରେ ଦୀପବୃକ୍ଷ, ତହିଁର ଗଣ୍ଡି ଓ ଶାଖା ନିର୍ମାଣ କଲେ, ଆଉ ତହିଁର ଗୋଲାଧାର, କଳିକା ଓ ପୁଷ୍ପ ତହିଁରେ ସଂଲଗ୍ନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ସେହି ଦୀପବୃକ୍ଷର ଏକ ପାର୍ଶ୍ୱରୁ ତିନି ଶାଖା ଓ ଦୀପବୃକ୍ଷର ଅନ୍ୟ ପାର୍ଶ୍ୱରୁ ତିନି ଶାଖା, ଏହି ଛଅ ଶାଖା ତହିଁର ପାର୍ଶ୍ୱରୁ ନିର୍ଗତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ପୁଣି, ଏକ ଶାଖାରେ ବାଦାମପୁଷ୍ପାକୃତି ତିନି ଗୋଲାଧାର, କଳିକା ଓ ପୁଷ୍ପ, ପୁଣି, ଅନ୍ୟ ଶାଖାରେ ବାଦାମପୁଷ୍ପାକୃତି ତିନି ଗୋଲାଧାର, କଳିକା ଓ ପୁଷ୍ପ, ଏହିରୂପେ ଦୀପବୃକ୍ଷରୁ ନିର୍ଗତ ଛଅ ଶାଖାରେ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ମାତ୍ର ଦୀପବୃକ୍ଷରେ ବାଦାମପୁଷ୍ପାକୃତି ଚାରି ଗୋଲାଧାର ଓ ତହିଁର କଳିକା ଓ ପୁଷ୍ପ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ଆଉ, ତହିଁରୁ ଯେଉଁ ଛଅ ଶାଖା ନିର୍ଗତ ହେଲା, ତଦନୁସାରେ ଏକ ଶାଖାଦ୍ୱୟର ତଳେ ଏକ କଳିକା ଓ ଅନ୍ୟ ଶାଖାଦ୍ୱୟର ତଳେ ଏକ କଳିକା ଓ ଅନ୍ୟତର ଶାଖାଦ୍ୱୟର ତଳେ ଏକ କଳିକା ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ଏହି କଳିକା ଓ ଶାଖା ତହିଁର ଅଂଶ ହେଲା ଓ ସମସ୍ତ ନିର୍ମଳ ସୁବର୍ଣ୍ଣ ନିର୍ମିତ ଏକ ପିଟାକର୍ମ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ଆଉ, ସେ ତହିଁ ପାଇଁ ସପ୍ତ ପ୍ରଦୀପ, ଚିମୁଟା ଓ ଅଙ୍ଗାରଧାନୀ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ସେ ଏକ ତାଳନ୍ତ ପରିମିତ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ତାହା ଓ ତହିଁର ସମସ୍ତ ପାତ୍ର ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ଏଥିଉତ୍ତାରେ ସେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ଏକ ହସ୍ତ ଦୀର୍ଘ, ଏକ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ଦୁଇ ହସ୍ତ ଉଚ୍ଚ ଚତୁଷ୍କୋଣ ଧୂପବେଦି ନିର୍ମାଣ କଲେ, ତହିଁର ଶୃଙ୍ଗସକଳ ତହିଁର ଅଂଶ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ଆଉ, ତାହା, ତହିଁର ପୃଷ୍ଠ, ତହିଁର ଚାରି ପାର୍ଶ୍ୱ ଓ ତହିଁର ଶୃଙ୍ଗସକଳ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ; ପୁଣି, ସେ ତହିଁର ଚାରିଆଡ଼େ ସୁବର୍ଣ୍ଣର କାନ୍ଥି କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ପୁଣି, ତହିଁର ବହନାର୍ଥକ ସାଙ୍ଗୀର ଘରା ନିମନ୍ତେ ତହିଁର କାନ୍ଥି ତଳେ ଦୁଇ ପାର୍ଶ୍ୱର ଦୁଇ କୋଣରେ ସୁବର୍ଣ୍ଣର ଦୁଇ ଦୁଇ କଡ଼ା ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ଆଉ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ସାଙ୍ଗୀ କଲେ ଓ ତାହା ସୁବର୍ଣ୍ଣରେ ମଡ଼ାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ଏଉତ୍ତାରେ ସେ ଅଭିଷେକାର୍ଥକ ପବିତ୍ର ତୈଳ ଓ ଧୂପ ନିମନ୍ତେ ଗନ୍ଧବଣିକର କ୍ରିୟାନୁଯାୟୀ ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ଏଥିଉତ୍ତାରେ ସେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ପାଞ୍ଚ ହସ୍ତ ଦୀର୍ଘ ଓ ପାଞ୍ଚ ହସ୍ତ ପ୍ରସ୍ଥ ଓ ତିନି ହସ୍ତ ଉଚ୍ଚ ଏକ ଚତୁଷ୍କୋଣ ହୋମବେଦି ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ପୁଣି, ତହିଁର ଚାରି କୋଣ ଉପରେ ଶୃଙ୍ଗ ନିର୍ମାଣ କରି ପିତ୍ତଳ ମଡ଼ାଇଲେ; ସେହି ଶୃଙ୍ଗସବୁ ତହିଁର ଅଂଶ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ଆଉ ସେ ବେଦିର ସମସ୍ତ ପାତ୍ର, ଅର୍ଥାତ୍‍, ଭସ୍ମଧାନୀ, କରଚୁଲି, କୁଣ୍ଡ, ତ୍ରିଶୂଳ ଓ ଅଙ୍ଗାରଧାନୀ, ଏହି ସମସ୍ତ ପାତ୍ର ପିତ୍ତଳରେ ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ଏହି ବେଦିର ବେଢ଼ ତଳେ ନିମ୍ନରୁ ମଧ୍ୟ ପର୍ଯ୍ୟନ୍ତ ପିତ୍ତଳ ନିର୍ମିତ ଜାଲି ଝାଞ୍ଜିରୀ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ପୁଣି, ସାଙ୍ଗୀର ଘରା ନିମନ୍ତେ ସେହି ପିତ୍ତଳ ଝାଞ୍ଜିରୀର ଚାରି କୋଣରେ ଚାରି କଡ଼ା ଢାଳିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ଆଉ, ସେ ଶିଟୀମ୍‍ କାଷ୍ଠରେ ସେହି ସାଙ୍ଗୀ ନିର୍ମାଣ କରି ପିତ୍ତଳରେ ମଡ଼ାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ବେଦି ବହନାର୍ଥେ ତହିଁର ପାର୍ଶ୍ୱ ଉପରେ ସେହି ସାଙ୍ଗୀ କଡ଼ାରେ ପ୍ରବେଶ କରାଇଲେ; ପୁଣି, ଫମ୍ପା ରଖି ପଟାରେ ବେଦି ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ଆଉ, ଯେଉଁ ସ୍ତ୍ରୀଗଣ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ସମୀପରେ ସେବା କଲେ, ସେହି ସେବାକାରିଣୀ ସ୍ତ୍ରୀଗଣର ପିତ୍ତଳ ନିର୍ମିତ ଦର୍ପଣ ଦ୍ୱାରା ସେ ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ଓ ତହିଁର ବୈଠିକି ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ଏଥିଉତ୍ତାରେ ସେ ପ୍ରାଙ୍ଗଣ ପ୍ରସ୍ତୁତ କଲେ; ଦକ୍ଷିଣ ଦିଗରେ ପ୍ରାଙ୍ଗଣର ଦକ୍ଷିଣ ପାର୍ଶ୍ୱରେ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ଏକ ଶହ ହସ୍ତ ପରିମିତ ପରଦା କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ତହିଁର କୋଡ଼ିଏ ସ୍ତମ୍ଭ ଓ କୋଡ଼ିଏ ଚୁଙ୍ଗୀ ପିତ୍ତଳର, ପୁଣି, ସେହି ସ୍ତମ୍ଭର ଆଙ୍କୁଡ଼ା ଓ ବନ୍ଧନୀ ରୂପାର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ଉତ୍ତର ଦିଗର ପରଦା ଏକ ଶହ ହସ୍ତ, ପୁଣି, ତହିଁର କୋଡ଼ିଏ ସ୍ତମ୍ଭ, କୋଡ଼ିଏ ଚୁଙ୍ଗୀ ପିତ୍ତଳର ଓ ସ୍ତମ୍ଭର ଆଙ୍କୁଡ଼ା ବନ୍ଧନୀ ରୂପାର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ପଶ୍ଚିମ ପାର୍ଶ୍ୱର ପରଦା ପଚାଶ ହସ୍ତ ଥିଲା, ତହିଁର ଦଶ ସ୍ତମ୍ଭ ଓ ଦଶ ଚୁଙ୍ଗୀ, ପୁଣି, ସ୍ତମ୍ଭର ଆଙ୍କୁଡ଼ା ଓ ବନ୍ଧନୀ ରୂପାର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ପୂର୍ବ ଦିଗରେ ପୂର୍ବ ପାର୍ଶ୍ୱ ନିମନ୍ତେ ପଚାଶ ହସ୍ତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ଦ୍ୱାରର ଏକ ପାର୍ଶ୍ୱ ନିମନ୍ତେ ପନ୍ଦର ହସ୍ତ ପରଦା ଓ ତହିଁର ତିନି ସ୍ତମ୍ଭ ଓ ତିନି ଚୁଙ୍ଗୀ ଥିଲା; ");
INSERT INTO ory_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ତଦ୍ରୂପେ ଅନ୍ୟ ପାର୍ଶ୍ୱ ନିମନ୍ତେ ଥିଲା। ପ୍ରାଙ୍ଗଣ-ଦ୍ୱାର ସନ୍ନିକଟ ଏ ପାର୍ଶ୍ୱରେ ଓ ସେ ପାର୍ଶ୍ୱରେ ପନ୍ଦର ହସ୍ତ ପରଦା ଓ ତହିଁର ତିନି ସ୍ତମ୍ଭ ଓ ତିନି ଚୁଙ୍ଗୀ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ପ୍ରାଙ୍ଗଣର ଚତୁର୍ଦ୍ଦିଗର ସକଳ ପରଦା ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ନିର୍ମିତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ପୁଣି, ସ୍ତମ୍ଭର ଚୁଙ୍ଗୀସବୁ ପିତ୍ତଳର ଥିଲା; ସ୍ତମ୍ଭର ଆଙ୍କୁଡ଼ା ଓ ବନ୍ଧନୀ ରୂପାର; ତହିଁର ମୁଣ୍ଡାଳି ରୌପ୍ୟ-ମଣ୍ଡିତ; ପୁଣି, ରୂପା-ବନ୍ଧନୀରେ ପ୍ରାଙ୍ଗଣର ସକଳ ସ୍ତମ୍ଭ ସଂଯୁକ୍ତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ଆଉ, ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ଶିଳ୍ପକର୍ମବିଶିଷ୍ଟ ଓ ପ୍ରାଙ୍ଗଣର ପରଦା ତୁଲ୍ୟ ତାହା ଦୀର୍ଘରେ କୋଡ଼ିଏ ହସ୍ତ ଓ ପ୍ରସ୍ଥରେ ପାଞ୍ଚ ହସ୍ତ ଉଚ୍ଚ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ପୁଣି, ତହିଁର ପିତ୍ତଳର ଚାରି ସ୍ତମ୍ଭ, ଚାରି ଚୁଙ୍ଗୀ, ରୂପାର ଆଙ୍କୁଡ଼ା ଓ ତହିଁର ମୁଣ୍ଡାଳି ରୌପ୍ୟ-ମଣ୍ଡିତ ଓ ବନ୍ଧନୀ ରୂପାର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ପୁଣି, ଆବାସର ଓ ପ୍ରାଙ୍ଗଣର ଚତୁର୍ଦ୍ଦିଗର କଣ୍ଟାସବୁ ପିତ୍ତଳର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ଲେବୀୟ ଲୋକମାନଙ୍କର କାର୍ଯ୍ୟ ନିମନ୍ତେ ହାରୋଣ ଯାଜକଙ୍କର ପୁତ୍ର ଈଥାମରଙ୍କ ଦ୍ୱାରା ମୋଶାଙ୍କର ଆଜ୍ଞାନୁସାରେ ଆବାସର, ଅର୍ଥାତ୍‍, ସାକ୍ଷ୍ୟରୂପେ ଆବାସର ଗଣନୀୟ ବସ୍ତୁ ସମୂହର ଏହି ଗଣନା କରାଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ଦ୍ୱାରା ଯେଉଁ ଆଜ୍ଞା ଦେଇଥିଲେ, ତଦନୁସାରେ ଯିହୁଦା ବଂଶଜାତ ହୂରର ପୌତ୍ର ଊରିର ପୁତ୍ର ବତ୍ସଲେଲ ସେସବୁ ନିର୍ମାଣ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ଆଉ ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ, ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ରରେ ଶିଳ୍ପକାରୀ, ଖୋଦକ ଓ ବିଜ୍ଞ ତନ୍ତୁବାୟ ଦାନ୍ ବଂଶଜାତ ଅହୀଷାମକଙ୍କ ପୁତ୍ର ଅହଲୀୟାବ ସହକାରୀ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ପବିତ୍ର ସ୍ଥାନ ନିର୍ମାଣର ସମସ୍ତ କାର୍ଯ୍ୟରେ ଏହିସବୁ ସୁବର୍ଣ୍ଣ ଲାଗିଲା, ଅର୍ଥାତ୍‍, ନୈବେଦ୍ୟର; ସମସ୍ତ ସ୍ୱର୍ଣ୍ଣ ପବିତ୍ର ସ୍ଥାନର ଶେକଲାନୁସାରେ ଅଣତିରିଶ ତାଳନ୍ତ ସାତ ଶହ ତିରିଶ ଶେକଲ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ପୁଣି, ମଣ୍ଡଳୀର ଗଣିତ ଲୋକଙ୍କର ରୂପା ପବିତ୍ର ସ୍ଥାନର ଶେକଲାନୁସାରେ ଏକ ଶହ ତାଳନ୍ତ ଏକ ସହସ୍ର ସାତ ଶହ ପଞ୍ଚସ୍ତରି ଶେକଲ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ପ୍ରତ୍ୟେକ ଗଣିତ ଲୋକଙ୍କ ନିମନ୍ତେ, ଅର୍ଥାତ୍‍, ଯେଉଁମାନେ ବିଂଶତି ବର୍ଷ ବୟସ୍କ ଅବା ତହିଁରୁ ଅଧିକ ବୟସ୍କ ଥିଲେ, ସେହି ଛଅ ଲକ୍ଷ ତିନି ସହସ୍ର ପାଞ୍ଚ ଶହ ପଚାଶ ଲୋକଙ୍କ ମଧ୍ୟରୁ ପ୍ରତ୍ୟେକ ଜଣ ନିମନ୍ତେ ଏକ ଏକ ବେକା, ଅର୍ଥାତ୍‍, ପବିତ୍ର ସ୍ଥାନର ଶେକଲାନୁସାରେ ଅର୍ଦ୍ଧ ଅର୍ଦ୍ଧ ଶେକଲ ଦେବାକୁ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ଏଣୁ ସେହି ଏକ ଶହ ତାଳନ୍ତ ରୂପାରେ ପବିତ୍ର ସ୍ଥାନର ଓ ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ଚୁଙ୍ଗୀ ଢଳାଗଲା; ଏକ ଶହ ଚୁଙ୍ଗୀ ନିମନ୍ତେ ଏକ ଶହ ତାଳନ୍ତ, ଅର୍ଥାତ୍‍, ଏକ ଏକ ଚୁଙ୍ଗୀ ନିମନ୍ତେ ଏକ ଏକ ତାଳନ୍ତ ବ୍ୟୟ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ପୁଣି, ସେହି ଏକ ସହସ୍ର ସାତ ଶହ ପଞ୍ଚସ୍ତରି ଶେକଲ ରୂପାରେ ସେ ସ୍ତମ୍ଭ ନିମନ୍ତେ ଆଙ୍କୁଡ଼ା ନିର୍ମାଣ କଲେ ଓ ତହିଁର ମୁଣ୍ଡାଳି ମଣ୍ଡିତ ଓ ବନ୍ଧନୀରେ ସଂଯୁକ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ପୁଣି, ନୈବେଦ୍ୟର ପିତ୍ତଳ ସତୁରି ତାଳନ୍ତ ଦୁଇ ସହସ୍ର ଚାରି ଶହ ଶେକଲ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ଏଣୁ ସେ ତାହା ଦ୍ୱାରା ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରର ଚୁଙ୍ଗୀ, ପିତ୍ତଳର ବେଦି, ତହିଁର ପିତ୍ତଳର ଝାଞ୍ଜିରୀ ଓ ବେଦିର ସମସ୍ତ ପାତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ପୁଣି, ପ୍ରାଙ୍ଗଣର ଚତୁର୍ଦ୍ଦିଗର ଚୁଙ୍ଗୀ, ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରର ଚୁଙ୍ଗୀ, ଆବାସର ସମସ୍ତ ମେଖ ଓ ପ୍ରାଙ୍ଗଣର ଚତୁର୍ଦ୍ଦିଗର ମେଖସକଳ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ଏଥିଉତ୍ତାରେ ଲୋକମାନେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ନୀଳ, ଧୂମ୍ର ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣ ସୂତ୍ର ଦ୍ୱାରା ପବିତ୍ର ସ୍ଥାନରେ ସେବା କରିବା ନିମନ୍ତେ ସୁଶୋଭିତ ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କଲେ, ଆଉ ହାରୋଣଙ୍କ ନିମନ୍ତେ ପବିତ୍ର ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ପୁଣି, ସେ ସୁବର୍ଣ୍ଣ ଦ୍ୱାରା, ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ଦ୍ୱାରା ଏଫୋଦ-ବସ୍ତ୍ର ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ଅର୍ଥାତ୍‍, ସେମାନେ ସ୍ୱର୍ଣ୍ଣ ପିଟାଇ ପାତଳ ପତ୍ର କରି ଶିଳ୍ପକର୍ମ ଦ୍ୱାରା ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ମଧ୍ୟରେ ବୁଣିବା ପାଇଁ ତାହା କାଟି ଜରୀ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ସେମାନେ ପରସ୍ପର ସଂଯୁକ୍ତ ଦୁଇ ସ୍କନ୍ଧପଟି କଲେ; ତହିଁର ଦୁଇ ମୁଣ୍ଡରେ ପରସ୍ପର ଯୋଡ଼ ଦିଆଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଏଫୋଦର ଉପରିସ୍ଥ ଯେଉଁ ଚିତ୍ରିତ ପଟୁକା ତହିଁର ଅଂଶ ଥିଲା, ତାହା ମଧ୍ୟ ସେହି କର୍ମାନୁସାରେ ସୁବର୍ଣ୍ଣ ଦ୍ୱାରା, ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ଦ୍ୱାରା ନିର୍ମିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ଆହୁରି ସେମାନେ ଇସ୍ରାଏଲ-ପୁତ୍ରଗଣର ନାମାନୁସାରେ ଖୋଦିତ ମୁଦ୍ରାନ୍ୟାୟ ଖୋଦିତ ଓ ସ୍ୱର୍ଣ୍ଣାଧାରରେ ଖଚିତ ଦୁଇ ଗୋମେଦକ ମଣି ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ପୁଣି, ସେ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଏଫୋଦର ଦୁଇ ସ୍କନ୍ଧପଟି ଉପରେ ଇସ୍ରାଏଲ-ପୁତ୍ରମାନଙ୍କ ସ୍ମରଣାର୍ଥକ ମଣି ରୂପେ ତାହା ବସାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ଏଥିଉତ୍ତାରେ ସେ ଏଫୋଦର କର୍ମନ୍ୟାୟ ସୁବର୍ଣ୍ଣ ଦ୍ୱାରା, ନୀଳ, ଧୂମ୍ର, ସିନ୍ଦୂର ବର୍ଣ୍ଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ଦ୍ୱାରା ନିପୁଣ ଶିଳ୍ପକାରର କର୍ମରେ ବୁକୁପଟା ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ତାହା ଚତୁଷ୍କୋଣ ଥିଲା, ଅର୍ଥାତ୍‍, ସେମାନେ ସେହି ବୁକୁପଟା ଦୋହରା କରି ଏକ ଚାଖଣ୍ଡ ଦୀର୍ଘ ଓ ଏକ ଚାଖଣ୍ଡ ପ୍ରସ୍ଥ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ପୁଣି, ତାହା ଚାରି ଧାଡ଼ି ମଣିରେ ଖଚିତ କଲେ; ତହିଁର ପ୍ରଥମ ଧାଡ଼ିରେ ଚୁଣି, ପୀତମଣି ଓ ମରକତ, ");
INSERT INTO ory_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ଦ୍ୱିତୀୟ ଧାଡ଼ିରେ ପଦ୍ମରାଗ, ନୀଳକାନ୍ତ ଓ ହୀରକ, ");
INSERT INTO ory_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ତୃତୀୟ ଧାଡ଼ିରେ ପେରୋଜ, ଯିସ୍ମ ଓ କଟାହେଳା, ");
INSERT INTO ory_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ପୁଣି, ଚତୁର୍ଥ ଧାଡ଼ିରେ ବୈଦୁର୍ଯ୍ୟ, ଗୋମେଦକ ଓ ସୂର୍ଯ୍ୟକାନ୍ତ ମଣି ଥିଲା; ଏହିସବୁ ମଣି ସ୍ୱର୍ଣ୍ଣାଧାରରେ ବସାଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ପୁଣି, ଇସ୍ରାଏଲ-ପୁତ୍ରମାନଙ୍କ ନାମାଙ୍କିତ ଏହିସବୁ ମଣି ସେମାନଙ୍କ ନାମାନୁସାରେ ଦ୍ୱାଦଶ ହେଲା ଓ ମୁଦ୍ରାନ୍ୟାୟ ଏକ ଏକ ମଣିରେ ଦ୍ୱାଦଶ ବଂଶର ଏକ ଏକ ନାମ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ଏଉତ୍ତାରେ ସେମାନେ ବୁକୁପଟାରେ ନିର୍ମଳ ସୁବର୍ଣ୍ଣ ଦ୍ୱାରା ମାଳା ତୁଲ୍ୟ ମୋଡ଼ା ଜଞ୍ଜିର ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ଦୁଇ ସ୍ୱର୍ଣ୍ଣାଧାରା ଓ ଦୁଇ ସ୍ୱର୍ଣ୍ଣକଡ଼ା ନିର୍ମାଣ କରି ବୁକୁପଟାର ଦୁଇ ପ୍ରାନ୍ତରେ ସେହି ଦୁଇ କଡ଼ା ଲଗାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ଆଉ ବୁକୁପଟାର ପ୍ରାନ୍ତସ୍ଥିତ ଦୁଇ କଡ଼ା ମଧ୍ୟରେ ସେହି ଦୁଇ ମୋଡ଼ା ସ୍ୱର୍ଣ୍ଣ ଜଞ୍ଜିର ଲଗାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ପୁଣି, ମୋଡ଼ା ଜଞ୍ଜିରର ଦୁଇ ମୁଣ୍ଡ ଦୁଇ ଆଧାରରେ ବନ୍ଦ କରି ଏଫୋଦ-ବସ୍ତ୍ର ସମ୍ମୁଖସ୍ଥ ଦୁଇ ସ୍କନ୍ଧପଟି ଉପରେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ପୁଣି, ସେମାନେ ଦୁଇ ସ୍ୱର୍ଣ୍ଣକଡ଼ା ନିର୍ମାଣ କରି ବୁକୁପଟାର ଦୁଇ ପ୍ରାନ୍ତରେ ଏଫୋଦର ସମ୍ମୁଖସ୍ଥ ଭିତର ଭାଗରେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ସେମାନେ ଆଉ ଦୁଇ ସ୍ୱର୍ଣ୍ଣକଡ଼ା କରି ଏଫୋଦର ଦୁଇ ସ୍କନ୍ଧପଟି ତଳେ ତହିଁ ସମ୍ମୁଖ ଭାଗର ଯୋଡ଼ ସ୍ଥାନରେ ଏଫୋଦର ଚିତ୍ରିତ ପଟୁକା ଉପରେ ତାହା ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ଆଉ ବୁକୁପଟା ଯେପରି ଏଫୋଦର ଚିତ୍ରିତ ପଟୁକା ଉପରେ ଥାଇ ଏଫୋଦରୁ ଖସି ନ ପଡ଼େ, ଏଥିପାଇଁ ସେମାନେ ବୁକୁପଟାକୁ ନିଜ କଡ଼ାରେ ନୀଳ ସୂତ୍ର ଦ୍ୱାରା ଏଫୋଦର କଡ଼ା ସହିତ ବନ୍ଦ କରି ରଖିଲେ; ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଏହା କରାଗଲା। ");
INSERT INTO ory_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେ ବୁଣା କର୍ମରେ ଏଫୋଦର ଚୋଗା ସମ୍ପୂର୍ଣ୍ଣ ନୀଳବର୍ଣ୍ଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ସେହି ଚୋଗାର ମଧ୍ୟସ୍ଥଳରେ ସାଞ୍ଜୁଆର ଗଳଦେଶ ନ୍ୟାୟ ଛିଦ୍ର ଥିଲା; ତାହା ଯେପରି ଛିଣ୍ଡି ନ ଯାଏ, ଏଥିପାଇଁ ସେହି ଗଳାର ଚାରିପାଖରେ ବୁଣାକର୍ମ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ପୁଣି, ସେମାନେ ଚୋଗାର ଅଞ୍ଚଳର ଚତୁର୍ଦ୍ଦିଗରେ ନୀଳ, ଧୂମ୍ର ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣ ବଳା ସୂତ୍ରରେ ଡାଳିମ୍ବ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ଆଉ ସେମାନେ ଡାଳିମ୍ବ ମଧ୍ୟରେ ନିର୍ମଳ ସ୍ୱର୍ଣ୍ଣ ଦ୍ୱାରା ଘଣ୍ଟି କରି ଚୋଗା ଅଞ୍ଚଳର ଚାରିଆଡ଼ରେ ଡାଳିମ୍ବର ମଧ୍ୟେ ମଧ୍ୟେ ରଖିଲେ; ");
INSERT INTO ory_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ଅର୍ଥାତ୍‍, ସେବାକରଣାର୍ଥକ ଚୋଗା ଅଞ୍ଚଳର ଚାରିଆଡ଼ରେ ଏକ ଘଣ୍ଟି ଉତ୍ତାରେ ଏକ ଡାଳିମ୍ବ ଓ ଏକ ଘଣ୍ଟି ଉତ୍ତାରେ ଏକ ଡାଳିମ୍ବ, ଏହିରୂପେ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେମାନେ ହାରୋଣ ଓ ତାଙ୍କର ପୁତ୍ରଗଣ ନିମନ୍ତେ ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ଦ୍ୱାରା ତନ୍ତୁବାୟ ନିର୍ମିତ ଜାମା ");
INSERT INTO ory_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ଓ ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନିର୍ମିତ ପଗଡ଼ି, ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନିର୍ମିତ ଶିରୋଭୂଷଣ ଓ ବଳା ଶୁଭ୍ର କ୍ଷୌମସୂତ୍ର ନିର୍ମିତ ଶୁକ୍ଳ ଜଙ୍ଘିଆ ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ଆଉ ବଳା ଶୁଭ୍ର କ୍ଷୋମ, ନୀଳ, ଧୂମ୍ର ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣ ସୂତ୍ରରେ ସୂଚି କର୍ମ ବିଶିଷ୍ଟ ଏକ କଟିବନ୍ଧନ ପ୍ରସ୍ତୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେମାନେ ନିର୍ମଳ ସୁବର୍ଣ୍ଣରେ ପବିତ୍ର ମୁକୁଟର ପତ୍ର ପ୍ରସ୍ତୁତ କରି ଖୋଦିତ ମୁଦ୍ରାନ୍ୟାୟ ତହିଁ ଉପରେ “ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର” ଏହା ଲେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ପୁଣି, ଊର୍ଦ୍ଧ୍ୱରେ ପାଗ ଉପରେ ରଖିବା ନିମନ୍ତେ ତାହା ନୀଳ ସୂତ୍ରରେ ବାନ୍ଧିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ଏହି ପ୍ରକାରେ ସମାଗମ-ତମ୍ବୁରୂପ ଆବାସର ସମସ୍ତ କାର୍ଯ୍ୟ ସମାପ୍ତ ହେଲା; ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ତାହା କଲେ, ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେମାନେ ସମସ୍ତ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ଏଥିଉତ୍ତାରେ ସେମାନେ ମୋଶାଙ୍କ ନିକଟକୁ ସେହି ଆବାସ ଆଣିଲେ, ଅର୍ଥାତ୍‍, ତମ୍ବୁ ଓ ତହିଁର ସକଳ ପାତ୍ର, ଆଙ୍କୁଡ଼ା, ପଟା, ଅର୍ଗଳ, ଆଉ ସ୍ତମ୍ଭ ଓ ଚୁଙ୍ଗୀ; ");
INSERT INTO ory_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ପୁଣି, ରକ୍ତୀକୃତ ମେଷ ଚର୍ମ ନିର୍ମିତ ଛାତ ଓ ଶିଶୁକ ଚର୍ମ ନିର୍ମିତ ଛାତ ଓ ଆଚ୍ଛାଦନର ବିଚ୍ଛେଦ ବସ୍ତ୍ର; ");
INSERT INTO ory_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ, ତହିଁର ସାଙ୍ଗୀ ଓ ପାପାଚ୍ଛାଦନ ମେଜ, ");
INSERT INTO ory_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ତହିଁର ସକଳ ପାତ୍ର ଓ ଦର୍ଶନୀୟ ରୁଟି, ");
INSERT INTO ory_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ନିର୍ମଳ ଦୀପବୃକ୍ଷ, ତହିଁର ପ୍ରଦୀପ, ଅର୍ଥାତ୍‍, ପ୍ରଦୀପାବଳୀ ଓ ତହିଁର ସକଳ ପାତ୍ର ଓ ଦୀପାର୍ଥକ ତୈଳ; ");
INSERT INTO ory_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ଆଉ ସ୍ୱର୍ଣ୍ଣମୟ ବେଦି, ଅଭିଷେକାର୍ଥକ ତୈଳ, ଧୂପାର୍ଥକ ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ ଓ ତମ୍ବୁଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର; ");
INSERT INTO ory_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ପିତ୍ତଳର ବେଦି ଓ ତହିଁର ପିତ୍ତଳ-ଝାଞ୍ଜିରୀ, ତହିଁର ସାଙ୍ଗୀ ଓ ସକଳ ପାତ୍ର, ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ଓ ତହିଁର ବୈଠିକି; ");
INSERT INTO ory_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ପ୍ରାଙ୍ଗଣର ପରଦା, ତହିଁର ସ୍ତମ୍ଭ ଓ ଚୁଙ୍ଗୀ ଓ ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର, ତହିଁର ରଜ୍ଜୁ ଓ ମେଖ ଓ ସମାଗମ-ତମ୍ବୁ ନିମନ୍ତେ ଆବାସର କାର୍ଯ୍ୟ ସମ୍ବନ୍ଧୀୟ ସକଳ ପାତ୍ର; ");
INSERT INTO ory_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ପବିତ୍ର ସ୍ଥାନରେ ସେବାକରଣାର୍ଥକ ସୁଶୋଭିତ ବସ୍ତ୍ର, ଅର୍ଥାତ୍‍, ହାରୋଣ ଯାଜକର ପବିତ୍ର ବସ୍ତ୍ର ଓ ତାହାର ପୁତ୍ରମାନଙ୍କର ଯାଜକ କର୍ମ ସମ୍ବନ୍ଧୀୟ ବସ୍ତ୍ର, ");
INSERT INTO ory_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ଇତ୍ୟାଦି ଯେଉଁ ଯେଉଁ କାର୍ଯ୍ୟ କରିବାକୁ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେଇଥିଲେ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ତାହାସବୁ ସମ୍ପନ୍ନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ଏଥିରେ ମୋଶା ସେହି ସମସ୍ତ କାର୍ଯ୍ୟ ପ୍ରତି ଦୃଷ୍ଟି କଲେ, ଆଉ ଦେଖ, ସେମାନେ ସବୁ କରିଅଛନ୍ତି; ସଦାପ୍ରଭୁ ଯେପରି ଆଜ୍ଞା ଦେଇଥିଲେ, ସେମାନେ ସେହିପରି ସବୁ କରିଥିଲେ; ତହିଁରେ ମୋଶା ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ତୁମ୍ଭେ ପ୍ରଥମ ମାସରେ ପ୍ରଥମ ଦିନରେ ସମାଗମ-ତମ୍ବୁର ଆବାସ ସ୍ଥାପନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ପୁଣି, ତହିଁ ମଧ୍ୟରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ରଖି ବିଚ୍ଛେଦ ବସ୍ତ୍ର ଟଙ୍ଗାଇ ସେହି ସିନ୍ଦୁକ ଆଚ୍ଛାଦନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ଏଉତ୍ତାରେ ମେଜ ଭିତରକୁ ଆଣି ତହିଁ ଉପରିସ୍ଥିତ ଦ୍ରବ୍ୟମାନ ଧାରାନୁସାରେ ରଖିବ; ଆଉ ଦୀପବୃକ୍ଷ ଭିତରକୁ ଆଣି ତହିଁର ପ୍ରଦୀପସକଳ ଜାଳିବ। ");
INSERT INTO ory_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ସମ୍ମୁଖରେ ସ୍ୱର୍ଣ୍ଣର ଧୂପବେଦି ରଖିବ, ପୁଣି, ଆବାସ-ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ଟଙ୍ଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ଆଉ ସମାଗମ-ତମ୍ବୁର ଆବାସ ଦ୍ୱାର ସମ୍ମୁଖରେ ହୋମବେଦି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ସମାଗମ-ତମ୍ବୁ ଓ ବେଦି ମଧ୍ୟରେ ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ରଖି ତହିଁରେ ଜଳ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ପୁଣି, ଚତୁର୍ଦ୍ଦିଗରେ ପ୍ରାଙ୍ଗଣ ପ୍ରସ୍ତୁତ କରିବ ଓ ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରରେ ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ଟଙ୍ଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","ଏଉତ୍ତାରେ ଅଭିଷେକାର୍ଥକ ତୈଳ ନେଇ ଆବାସ ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ସମସ୍ତ ବସ୍ତୁ ଅଭିଷେକ କରି ତାହା ଓ ତହିଁର ସକଳ ପାତ୍ର ପବିତ୍ର କରିବ; ତହିଁରେ ତାହା ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ଆଉ, ତୁମ୍ଭେ ହୋମବେଦି ଓ ତହିଁର ସକଳ ପାତ୍ର ଅଭିଷେକ କରି ପବିତ୍ର କରିବ; ତହିଁରେ ସେହି ବେଦି ମହାପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ଆଉ ତୁମ୍ଭେ ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ଓ ତହିଁର ବୈଠିକି ଅଭିଷେକ କରି ପବିତ୍ର କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","ଏଉତ୍ତାରେ ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟକୁ ଆଣି ଜଳରେ ସ୍ନାନ କରାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ପୁଣି, ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଯାଜକ କର୍ମ କରିବା ନିମନ୍ତେ ହାରୋଣକୁ ପବିତ୍ର ବସ୍ତ୍ର ପରିଧାନ କରାଇ ଅଭିଷେକ କରି ପ୍ରତିଷ୍ଠା କରିବ। ");
INSERT INTO ory_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ଆଉ ତାହାର ପୁତ୍ରଗଣକୁ ଆଣି ଜାମା ପିନ୍ଧାଇବ। ");
INSERT INTO ory_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ପୁଣି, ସେମାନଙ୍କ ପିତାକୁ ଯେରୂପ ଅଭିଷେକ କଲ, ସେହିରୂପ ସେମାନଙ୍କୁ ଅଭିଷେକ କରିବ, ତହିଁରେ ସେମାନେ ଆମ୍ଭର ଯାଜକ କର୍ମ କରିବେ; ସେହି ଅଭିଷେକ ସେମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ଅନନ୍ତକାଳୀନ ଯାଜକତ୍ୱର ମୂଳ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ମୋଶା ଏହିରୂପ କଲେ; ସେ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସମସ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଦ୍ୱିତୀୟ ବର୍ଷର ପ୍ରଥମ ମାସର ପ୍ରଥମ ଦିନରେ ଆବାସ ସ୍ଥାପିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ପୁଣି, ମୋଶା ଆବାସ ସ୍ଥାପନ କରି ତହିଁର ଚୁଙ୍ଗୀ ଦେଇ ପଟା ବସାଇ ଅର୍ଗଳ ପ୍ରବେଶ କରାଇ ତହିଁର ସ୍ତମ୍ଭ ଠିଆ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ତହୁଁ ସେ ଆବାସ ଉପରେ ତମ୍ବୁ ବିସ୍ତାର କଲେ ଓ ତମ୍ବୁ ଉପରେ ଛାତ ଦେଲେ; ");
INSERT INTO ory_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେ ସାକ୍ଷ୍ୟପତ୍ର ଘେନି ସିନ୍ଦୁକ ଭିତରେ ରଖିଲେ ଓ ସିନ୍ଦୁକରେ ସାଙ୍ଗୀ ଲଗାଇ ସିନ୍ଦୁକ ଉପରେ ପାପାଚ୍ଛାଦନ ରଖିଲେ; ");
INSERT INTO ory_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ପୁଣି, ଆବାସ ଭିତରକୁ ସିନ୍ଦୁକ ଆଣିଲେ ଓ ଆଚ୍ଛାଦନର ବିଚ୍ଛେଦ ବସ୍ତ୍ର ଟଙ୍ଗାଇ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ଆଚ୍ଛାଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ଏଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେ ଆବାସର ଉତ୍ତର ପାର୍ଶ୍ୱରେ ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ବାହାରେ ସମାଗମ-ତମ୍ବୁରେ ମେଜ ରଖିଲେ; ");
INSERT INTO ory_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ପୁଣି, ସେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଧାରାନୁସାରେ ତହିଁ ଉପରେ ରୁଟି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ଏଥିଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମେଜ ସମ୍ମୁଖରେ ଆବାସର ଦକ୍ଷିଣ ପାର୍ଶ୍ୱରେ ସମାଗମ-ତମ୍ବୁରେ ଦୀପବୃକ୍ଷ ରଖିଲେ ");
INSERT INTO ory_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ଓ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପ୍ରଦୀପ ଜାଳିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ଆଉ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେ ସମାଗମ-ତମ୍ବୁରେ ବିଚ୍ଛେଦ ବସ୍ତ୍ର ସମ୍ମୁଖରେ ସ୍ୱର୍ଣ୍ଣ-ବେଦି ରଖିଲେ ");
INSERT INTO ory_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ଓ ତହିଁ ଉପରେ ସୁଗନ୍ଧି ଧୂପ ଜାଳିଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ପୁଣି, ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେ ଆବାସ-ଦ୍ୱାରରେ ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ଟଙ୍ଗାଇଲେ ");
INSERT INTO ory_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ଓ ସମାଗମ-ତମ୍ବୁର ଆବାସ ଦ୍ୱାର ନିକଟରେ ହୋମବେଦି ରଖି ତହିଁ ଉପରେ ହୋମବଳି ଓ ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ଏଉତ୍ତାରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେ ସମାଗମ-ତମ୍ବୁ ଓ ବେଦି ମଧ୍ୟସ୍ଥାନରେ ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ରଖି ତହିଁ ମଧ୍ୟରେ ପ୍ରକ୍ଷାଳନ ନିମନ୍ତେ ଜଳ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ତହିଁରେ ମୋଶା, ହାରୋଣ ଓ ତାଙ୍କର ପୁତ୍ରଗଣ ଆପଣା ଆପଣା ହସ୍ତ ପଦ ପ୍ରକ୍ଷାଳନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ଯେକୌଣସି ସମୟରେ ସେମାନେ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କଲେ ବା ବେଦିର ନିକଟବର୍ତ୍ତୀ ହେଲେ, ସେହି ସମୟରେ ସେମାନେ ପ୍ରକ୍ଷାଳନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ଏଉତ୍ତାରେ ସେ ଆବାସର ଓ ବେଦିର ଚତୁର୍ଦ୍ଦିଗରେ ପ୍ରାଙ୍ଗଣ ପ୍ରସ୍ତୁତ କଲେ ଓ ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରରେ ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ଟଙ୍ଗାଇଲେ, ଏହିରୂପେ ମୋଶା ସେହି କାର୍ଯ୍ୟ ସମାପ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ଏଥିଉତ୍ତାରେ ମେଘ ସେହି ସମାଗମ-ତମ୍ବୁକୁ ଆଚ୍ଛାଦନ କଲା ଓ ସଦାପ୍ରଭୁଙ୍କର ପ୍ରତାପ ଆବାସକୁ ପରିପୂର୍ଣ୍ଣ କଲା। ");
INSERT INTO ory_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ତହିଁରେ ମୋଶା ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କରି ପାରିଲେ ନାହିଁ, କାରଣ ମେଘ ତହିଁ ଉପରେ ଅବସ୍ଥିତି କରିଥିଲା ଓ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତାପ ଆବାସକୁ ପରିପୂର୍ଣ୍ଣ କରିଥିଲା। ");
INSERT INTO ory_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ପୁଣି, ଆବାସ ଉପରୁ ଯେତେବେଳେ ମେଘ ନିଆଗଲା, ସେତେବେଳେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଆପଣାମାନଙ୍କ ଯାତ୍ରାରେ ଅଗ୍ରସର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ମାତ୍ର ମେଘ ଯେତେବେଳେ ଊର୍ଦ୍ଧ୍ୱକୁ ନିତ ହେଲା ନାହିଁ, ସେତେବେଳେ ଊର୍ଦ୍ଧ୍ୱକୁ ନିତ ନ ହେବା ଦିନ ପର୍ଯ୍ୟନ୍ତ ସେମାନେ ଯାତ୍ରା କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","କାରଣ, ସମସ୍ତ ଇସ୍ରାଏଲ ବଂଶର ଦୃଷ୍ଟିଗୋଚରରେ ସେମାନଙ୍କ ସମସ୍ତ ଯାତ୍ରାରେ ଦିନ ବେଳେ ସଦାପ୍ରଭୁଙ୍କର ମେଘ ଓ ରାତ୍ରିରେ ଅଗ୍ନି ଆବାସ ଉପରେ ଅବସ୍ଥିତି କଲା।");
INSERT INTO ory_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ସମାଗମ-ତମ୍ବୁରୁ ମୋଶାଙ୍କୁ ଡାକି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରୁ କେହି ଯଦି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବଳି ଉତ୍ସର୍ଗ କରେ, ତେବେ ସେ ଗୋରୁ ଅବା ମେଷପଲରୁ ଆପଣା ବଳି ଆଣି ଉତ୍ସର୍ଗ କରୁ। ");
INSERT INTO ory_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ସେ ଯଦି ଗୋଠରୁ (ଗାଈଗୋରୁ ପଲରୁ) ହୋମାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରେ, ତେବେ ନିଖୁନ୍ତ ପୁଂପଶୁ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟକୁ ଆଣିବ; ଯେପରି ତାହା ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଗ୍ରାହ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ପୁଣି, ସେ ହୋମବଳିର ମସ୍ତକରେ ଆପଣା ହସ୍ତ ରଖିବ; ତହିଁରେ ସେହି ବଳି ତାହାର ପ୍ରାୟଶ୍ଚିତ୍ତ ରୂପେ ଗ୍ରାହ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ତହୁଁ ସେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସେହି ଗୋବତ୍ସକୁ ବଧ କରିବ; ଆଉ, ହାରୋଣର ପୁତ୍ର ଯାଜକଗଣ ତାହାର ରକ୍ତ ନେଇ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ସମୀପସ୍ଥ ବେଦି ଉପର ଚାରିଆଡ଼େ ଛିଞ୍ଚିବେ। ");
INSERT INTO ory_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ପୁଣି ସେ ସେହି ହୋମବଳିର ଚର୍ମ କାଢ଼ି ତାହା ଖଣ୍ଡ ଖଣ୍ଡ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ଏଥିଉତ୍ତାରେ ହାରୋଣ ଯାଜକର ପୁତ୍ରଗଣ ସେହି ବେଦି ଉପରେ ଅଗ୍ନି ରଖିବେ ଓ ଅଗ୍ନି ଉପରେ କାଷ୍ଠ ସଜାଇବେ। ");
INSERT INTO ory_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ପୁଣି ହାରୋଣର ପୁତ୍ର ଯାଜକମାନେ ବେଦି ଉପରିସ୍ଥ ଅଗ୍ନି ଓ କାଷ୍ଠ ଉପରେ ସେହି ପଶୁର ଖଣ୍ଡସକଳ, ମସ୍ତକ ଓ ମେଦ ସଜାଇ ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ମାତ୍ର ସେ ତାହାର ଅନ୍ତ ଓ ପାଦ ଜଳରେ ଧୌତ କରିବ; ତହୁଁ ଯାଜକ ବେଦି ଉପରେ ତାହାସବୁ ଦଗ୍ଧ କରିବ, ତାହା ହୋମବଳି, ଅର୍ଥାତ୍‍, ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ଆଉ ଯଦି ସେ ମେଷ କି ଛାଗପଲରୁ ହୋମବଳି ଉତ୍ସର୍ଗ କରେ, ");
INSERT INTO ory_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ତେବେ ସେ ନିଖୁନ୍ତ ପୁଂପଶୁ ଘେନି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଯଜ୍ଞବେଦିର ଉତ୍ତର ଦିଗରେ ବଧ କରିବ; ପୁଣି ହାରୋଣର ପୁତ୍ର ଯାଜକଗଣ ବେଦିର ଉପର ଚତୁର୍ଦ୍ଦିଗରେ ତାହାର ରକ୍ତ ଛିଞ୍ଚିବେ। ");
INSERT INTO ory_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ଆଉ ସେ ତାହାର ମସ୍ତକ ଓ ମେଦ ସହିତ ତାକୁ ଖଣ୍ଡ ଖଣ୍ଡ କରିବ; ତହିଁରେ ଯାଜକ ବେଦି ଉପରିସ୍ଥ ଅଗ୍ନି ଓ କାଷ୍ଠ ଉପରେ ତାହା ସଜାଇ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ମାତ୍ର ସେ ତାହାର ଅନ୍ତ ଓ ପାଦ ଜଳରେ ଧୌତ କରିବ; ତହୁଁ ଯାଜକ ସେହି ସମସ୍ତ ଉତ୍ସର୍ଗ କରି ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ, ତାହା ହୋମବଳି, ଅର୍ଥାତ୍‍, ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ଆଉ ଯଦି ସେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପକ୍ଷୀମାନଙ୍କ ମଧ୍ୟରୁ ହୋମବଳି ଉତ୍ସର୍ଗ କରେ, ତେବେ କପୋତ ଅବା ପାରାଛୁଆ ମଧ୍ୟରୁ ତାହା ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ତହୁଁ ଯାଜକ ତାହା ବେଦି ନିକଟକୁ ଆଣି ତାହାର ମସ୍ତକ ମୋଡ଼ି ତାକୁ ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ; ଆଉ ତାହାର ରକ୍ତ ବେଦି ପାର୍ଶ୍ୱରେ ନିଗାଡ଼ିବ। ");
INSERT INTO ory_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ଏଥିଉତ୍ତାରେ ସେ ତାହାର ମଳ ସହିତ ଗଳା ଥଳୀ ଘେନି ବେଦିର ପୂର୍ବପାର୍ଶ୍ଵସ୍ଥ ଭସ୍ମ ସ୍ଥାନରେ ନିକ୍ଷେପ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ଆଉ, ପକ୍ଷମୂଳ ଚିରିବ, ମାତ୍ର ଦ୍ୱିଖଣ୍ଡ କରିବ ନାହିଁ; ପୁଣି ଯାଜକ ବେଦି ଉପରିସ୍ଥ ଅଗ୍ନି ଓ କାଷ୍ଠ ଉପରେ ଦଗ୍ଧ କରିବ, ତହିଁରେ ତାହା ହୋମବଳି, ଅର୍ଥାତ୍‍, ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ଆଉ, କେହି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଆଣିଲେ, ସରୁ ମଇଦା ତାହାର ନୈବେଦ୍ୟ ହେବ; ପୁଣି ସେ ତହିଁ ଉପରେ ତୈଳ ଢାଳି କୁନ୍ଦୁରୁ ଦେବ; ");
INSERT INTO ory_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ପୁଣି ତାହା ହାରୋଣର ପୁତ୍ର ଯାଜକମାନଙ୍କ ନିକଟକୁ ଆଣିବ; ତହିଁରେ ଯାଜକ ତହିଁରୁ ମୁଠାଏ ସରୁ ମଇଦା ଓ କିଛି ତୈଳ ଓ ସମସ୍ତ କୁନ୍ଦୁରୁ ନେବ; ପୁଣି ଯାଜକ ସ୍ମରଣାର୍ଥକ ଅଂଶ ରୂପେ ତାହା ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ; ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ଏହି ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟର ଅବଶିଷ୍ଟ ଅଂଶ ହାରୋଣର ଓ ତାହାର ପୁତ୍ରମାନଙ୍କର ହେବ; ସଦାପ୍ରଭୁଙ୍କର ଅଗ୍ନିକୃତ ଉପହାର ମଧ୍ୟରେ ତାହା ମହାପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","ଆଉ ଯଦି ତୁମ୍ଭେ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ରୂପେ ତନ୍ଦୁରରେ ରନ୍ଧନ ହୋଇଥିବା ଦ୍ରବ୍ୟ ଦିଅ, ତେବେ ତାହା ତୈଳ ମିଶ୍ରିତ ଓ ତାଡ଼ିଶୂନ୍ୟ ସରୁ ମଇଦାର ପିଠା ଅବା ତୈଳାକ୍ତ ସରୁ ଚକୁଳି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ଆଉ ଯଦି ପଲମରେ ଭଜା ଦ୍ରବ୍ୟ ତୁମ୍ଭର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ହୁଏ, ତେବେ ତାହା ତୈଳ ମିଶ୍ରିତ ଓ ତାଡ଼ିଶୂନ୍ୟ ସରୁ ମଇଦାର ପିଠା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ତୁମ୍ଭେ ତାହା ଖଣ୍ଡ ଖଣ୍ଡ କରି ତହିଁ ଉପରେ ତୈଳ ଢାଳିବ; ତାହା ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ଆଉ ଯଦି କରେଇରେ ରନ୍ଧନ ହୋଇଥିବା ଦ୍ରବ୍ୟ ତୁମ୍ଭର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ହୁଏ, ତେବେ ତାହା ତୈଳରେ ରନ୍ଧନ ହୋଇଥିବା ସରୁ ମଇଦାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ତୁମ୍ଭେ ଏହିସବୁ ଦ୍ରବ୍ୟରେ ପ୍ରସ୍ତୁତ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ଆଣିବ; ଆଉ ତାହା ଯାଜକକୁ ଦେବ, ତହୁଁ ସେ ବେଦି ନିକଟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ପୁଣି, ଯାଜକ ସେହି ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟରୁ ସ୍ମରଣାର୍ଥକ ଅଂଶ ନେଇ ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ; ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ପୁଣି ସେହି ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟର ଅବଶିଷ୍ଟ ଅଂଶ ହାରୋଣର ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କର ହେବ; ସଦାପ୍ରଭୁଙ୍କର ଅଗ୍ନିକୃତ ଉପହାର ମଧ୍ୟରେ ତାହା ମହାପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯେକୌଣସି ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କରିବ, ତାହା ତାଡ଼ିଯୁକ୍ତ ହେବ ନାହିଁ, ଯେହେତୁ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପେ ତାଡ଼ି କି ମଧୁ ଦଗ୍ଧ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ତୁମ୍ଭେମାନେ ପ୍ରଥମଜାତ ଫଳର ନୈବେଦ୍ୟ ରୂପେ ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ, ମାତ୍ର ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ତାହା ବେଦି ଉପରକୁ ଆସିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ଆଉ ତୁମ୍ଭେ ଆପଣା ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟର ପ୍ରତ୍ୟେକ ଦ୍ରବ୍ୟ ଲବଣାକ୍ତ କରିବ; କଦାପି ତୁମ୍ଭେ ଆପଣା ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟକୁ ତୁମ୍ଭ ପରମେଶ୍ୱରଙ୍କ ନିୟମସୂଚକ ଲବଣରହିତ ହେବାକୁ ଦେବ ନାହିଁ; ତୁମ୍ଭର ସମସ୍ତ ନୈବେଦ୍ୟ ସହିତ ଲବଣ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ପୁଣି ଯଦି ତୁମ୍ଭେ ଆପଣା ପ୍ରଥମ ଫଳର ନୈବେଦ୍ୟ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କର, ତେବେ ତୁମ୍ଭ ପ୍ରଥମଜାତ ଫଳର ନୈବେଦ୍ୟ ରୂପେ ଅଗ୍ନିରେ ଭଜା ଶିଷା, ଅର୍ଥାତ୍‍, ମର୍ଦ୍ଦିତ କୋମଳ ଶିଷା ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ପୁଣି ତହିଁ ଉପରେ ତୈଳ ଦେବ ଓ କୁନ୍ଦୁରୁ ରଖିବ; ତାହା ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ତହୁଁ ଯାଜକ ତହିଁର ସ୍ମରଣାର୍ଥକ ଅଂଶ ରୂପେ କିଛି ମର୍ଦ୍ଦିତ ଶସ୍ୟ, କିଛି ତୈଳ ଓ ସମସ୍ତ କୁନ୍ଦୁରୁ ଦଗ୍ଧ କରିବ; ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","ଆଉ, କୌଣସି ବ୍ୟକ୍ତିର ଉପହାର ଯଦି ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ହୁଏ; ଯଦି ସେ ପଲରୁ ଅଣ୍ଡିରା କି ମାଈ ଗୋରୁ ଦିଏ, ତେବେ ସେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ନିଖୁନ୍ତ ପଶୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ପୁଣି, ସେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ଆପଣା ବଳିର ମସ୍ତକରେ ହସ୍ତ ରଖି ତାକୁ ବଧ କରିବ; ତହୁଁ ହାରୋଣର ପୁତ୍ର ଯାଜକଗଣ ତାହାର ରକ୍ତ ବେଦି ଉପରେ ଚତୁର୍ଦ୍ଦିଗରେ ଛିଞ୍ଚିବେ। ");
INSERT INTO ory_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ଏଥିଉତ୍ତାରେ ସେ ସେହି ମଙ୍ଗଳାର୍ଥକ ବଳିରୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ, ଅର୍ଥାତ୍‍, ଅନ୍ତ ଆଚ୍ଛାଦକ ମେଦ, ଅନ୍ତ ଉପରିସ୍ଥ ମେଦ, ");
INSERT INTO ory_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ଦୁଇ ଗୁର୍ଦା, ତହିଁ ଉପରିସ୍ଥ ପାର୍ଶ୍ୱବର୍ତ୍ତୀ ମେଦ, ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ, ଗୁର୍ଦା ସହିତ ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ତହୁଁ ହାରୋଣର ପୁତ୍ରଗଣ ବେଦି ଉପରିସ୍ଥ ଅଗ୍ନି, କାଷ୍ଠ ଓ ହୋମଦ୍ରବ୍ୟ ଉପରେ ତାହା ଦଗ୍ଧ କରିବେ; ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ଆଉ, ଯଦି କେହି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମେଷାଦିପଲରୁ ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ କରେ, ତେବେ ସେ ନିଖୁନ୍ତ ଅଣ୍ଡିରା କି ମାଈ ପଶୁ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ଯଦି ସେ ଉପହାର ନିମନ୍ତେ ମେଷବତ୍ସ ବଳିଦାନ କରେ, ତେବେ ସେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ତାହା ଆଣିବ; ");
INSERT INTO ory_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ପୁଣି ଆପଣା ବଳିର ମସ୍ତକରେ ହସ୍ତ ରଖି ସମାଗମ-ତମ୍ବୁ ନିକଟରେ ତାକୁ ବଧ କରିବ। ତହୁଁ ହାରୋଣର ପୁତ୍ରଗଣ ବେଦି ଉପରେ ଚାରିଆଡ଼େ ତାହାର ରକ୍ତ ଛିଞ୍ଚିବେ। ");
INSERT INTO ory_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ଏଥିଉତ୍ତାରେ ସେ ସେହି ମଙ୍ଗଳାର୍ଥକ ବଳିରୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ; ଅର୍ଥାତ୍‍, ତହିଁର ମେଦ, ସମସ୍ତ ମେଦମୟ ଲାଙ୍ଗୁଳ ମେରୁଦଣ୍ଡ ନିକଟରୁ ନେବ, ଅନ୍ତ ଆଚ୍ଛାଦକ ମେଦ, ଅନ୍ତ ଉପରିସ୍ଥ ସମସ୍ତ ମେଦ, ");
INSERT INTO ory_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ଦୁଇ ଗୁର୍ଦା, ତହିଁ ଉପରିସ୍ଥ ପାର୍ଶ୍ୱବର୍ତ୍ତୀ ମେଦ ଓ ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ, ଗୁର୍ଦା ସହିତ ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ତହୁଁ ଯାଜକ ତାହା ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ; ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପ ଭୋଜନ। ");
INSERT INTO ory_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ଆଉ, କେହି ଯଦି ଛାଗଳ ବଳିଦାନ କରେ, ତେବେ ସେ ତାହା ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ଆଣିବ, ");
INSERT INTO ory_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ପୁଣି, ଆପଣା ବଳିର ମସ୍ତକରେ ହସ୍ତ ରଖି ସମାଗମ-ତମ୍ବୁ ନିକଟରେ ତାକୁ ବଧ କରିବ; ତହୁଁ ହାରୋଣର ପୁତ୍ରଗଣ ବେଦି ଉପରେ ଚାରିଆଡ଼େ ତାହାର ରକ୍ତ ଛିଞ୍ଚିବେ। ");
INSERT INTO ory_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ଆଉ, ସେ ତହିଁରୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ, ଅର୍ଥାତ୍‍, ଅନ୍ତ ଆଚ୍ଛାଦକ ମେଦ, ଅନ୍ତ ଉପରିସ୍ଥ ସମସ୍ତ ମେଦ, ");
INSERT INTO ory_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ଦୁଇ ଗୁର୍ଦା, ତାହାର ଉପରିସ୍ଥ ପାର୍ଶ୍ୱବର୍ତ୍ତୀ ମେଦ ଓ ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ, ଗୁର୍ଦା ସହିତ ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ତହୁଁ ଯାଜକ ବେଦି ଉପରେ ତାହା ଦଗ୍ଧ କରିବ; ତାହା ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପ ଭୋଜନ; ସମସ୍ତ ମେଦ ସଦାପ୍ରଭୁଙ୍କର। ");
INSERT INTO ory_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ତାହା ତୁମ୍ଭମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ସମସ୍ତ ଗୃହରେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି; ତୁମ୍ଭେମାନେ ମେଦ ଓ ରକ୍ତ, କିଛି ଭୋଜନ କରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଯାହା ନ କରିବାକୁ ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ଯଦି କୌଣସି ବ୍ୟକ୍ତି ତହିଁ ମଧ୍ୟରୁ କୌଣସି କର୍ମ କରି ଭୁଲବଶତଃ ପାପ କରେ; ");
INSERT INTO ory_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ବିଶେଷତଃ ଅଭିଷିକ୍ତ ଯାଜକ ଯଦି ଲୋକମାନଙ୍କର ଦୋଷଜନକ ପାପ କରେ; ତେବେ ସେ ଆପଣା କୃତ ପାପ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ନିଖୁନ୍ତ ଏକ ଗୋବତ୍ସ ପାପାର୍ଥକ ବଳି ରୂପେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ପୁଣି ସେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ସେହି ଗୋବତ୍ସ ଆଣି ତାହା ମସ୍ତକରେ ହସ୍ତ ରଖି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାକୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ଆଉ, ଅଭିଷିକ୍ତ ଯାଜକ ସେହି ଗୋବତ୍ସର ରକ୍ତରୁ କିଛି ନେଇ ସମାଗମ-ତମ୍ବୁ ମଧ୍ୟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ପୁଣି, ଯାଜକ ସେହି ରକ୍ତରେ ଆପଣା ଅଙ୍ଗୁଳି ଡୁବାଇ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ପବିତ୍ର ସ୍ଥାନର ବିଚ୍ଛେଦ ବସ୍ତ୍ର ଆଗରେ ସାତ ଥର ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ଆଉ, ଯାଜକ ସେହି ରକ୍ତରୁ କିଛି ନେଇ ସମାଗମ-ତମ୍ବୁର ମଧ୍ୟସ୍ଥିତ ସୁଗନ୍ଧି ଧୂପବେଦିର ଶୃଙ୍ଗରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦେବ; ତହୁଁ ଗୋବତ୍ସର ସମସ୍ତ ରକ୍ତ ନେଇ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାରସ୍ଥିତ ହୋମବେଦି ମୂଳରେ ଢାଳିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ଆଉ, ପାପାର୍ଥକ ବଳିରୂପ ଗୋବତ୍ସର ସମସ୍ତ ମେଦ, ଅର୍ଥାତ୍‍, ଅନ୍ତ ଆଚ୍ଛାଦକ ମେଦ, ଅନ୍ତ ଉପରିସ୍ଥ ମେଦ, ");
INSERT INTO ory_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ଦୁଇ ଗୁର୍ଦା, ତହିଁ ଉପରିସ୍ଥ ପାର୍ଶ୍ୱବର୍ତ୍ତୀ ମେଦ ଓ ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ, ଗୁର୍ଦା ସହିତ ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ମଙ୍ଗଳାର୍ଥକ ବଳିର ଗୋରୁ ହେଲେ ଯେରୂପ କରିବାକୁ ହୁଏ, ସେରୂପ କରିବ; ପୁଣି ଯାଜକ ହୋମବେଦି ଉପରେ ତାହା ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ଆଉ, ସେହି ଗୋବତ୍ସର ଚର୍ମ, ସମସ୍ତ ମାଂସ, ମସ୍ତକ, ପାଦ, ଅନ୍ତ ଓ ଗୋମୟ, ");
INSERT INTO ory_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ସର୍ବସମେତ ଗୋବତ୍ସକୁ ନେଇ ଛାଉଣି ବାହାରେ ଶୁଚି ସ୍ଥାନରେ, ଅର୍ଥାତ୍‍, ଭସ୍ମ ନିକ୍ଷେପ ସ୍ଥାନକୁ ଆଣି କାଷ୍ଠ ଉପରେ ଅଗ୍ନିରେ ଦଗ୍ଧ କରିବ; ଭସ୍ମ ନିକ୍ଷେପ ସ୍ଥାନରେ ତାହା ଦଗ୍ଧ କରିବାକୁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ଆଉ, ଇସ୍ରାଏଲର ସମଗ୍ର ମଣ୍ଡଳୀ ଯଦି ଭୁଲବଶତଃ ପାପ କରନ୍ତି ଓ ତାହା ସମାଜର ଦୃଷ୍ଟିରେ ଅଗୋଚର ହୁଏ, ଆଉ ଯାହା ନ କରିବାକୁ ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ତହିଁ ମଧ୍ୟରୁ ସେମାନେ ଯଦି କୌଣସି କର୍ମ କରି ଦୋଷୀ ହୁଅନ୍ତି; ");
INSERT INTO ory_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ତେବେ ସେମାନଙ୍କ କୃତ ସେହି ପାପ ଜଣାପଡ଼ିଲେ, ସମାଜ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଗୋବତ୍ସ ଉତ୍ସର୍ଗ କରିବେ, ପୁଣି ସମାଗମ-ତମ୍ବୁ ନିକଟକୁ ତାହା ଆଣିବେ। ");
INSERT INTO ory_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ଏଥିଉତ୍ତାରେ ମଣ୍ଡଳୀର ପ୍ରାଚୀନବର୍ଗ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସେହି ଗୋବତ୍ସ ମସ୍ତକରେ ହସ୍ତ ରଖିବେ; ଆଉ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସେହି ଗୋବତ୍ସ ବଧ କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ଆଉ, ଅଭିଷିକ୍ତ ଯାଜକ ସେହି ଗୋବତ୍ସର ରକ୍ତରୁ କିଛି ନେଇ ସମାଗମ-ତମ୍ବୁ ମଧ୍ୟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ପୁଣି, ଯାଜକ ସେହି ରକ୍ତରେ ଆପଣା ଅଙ୍ଗୁଳି ଡୁବାଇ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ବିଚ୍ଛେଦ ବସ୍ତ୍ର ଆଗରେ ସାତ ଥର ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ପୁଣି ସେହି ରକ୍ତରୁ କିଛି ନେଇ ସମାଗମ-ତମ୍ବୁ ମଧ୍ୟରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖସ୍ଥ ବେଦିର ଶୃଙ୍ଗ ଉପରେ ଦେବ, ଆଉ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ସମୀପସ୍ଥ ହୋମବେଦି ମୂଳରେ ତାହାର ସମସ୍ତ ରକ୍ତ ଢାଳିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ପୁଣି, ବଳିରୁ ସମସ୍ତ ମେଦ ନେଇ ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ପୁଣି, ସେ ସେହି ପାପାର୍ଥକ ବଳିର ଗୋବତ୍ସକୁ ଯେରୂପ କଲା, ଏହାକୁ ହିଁ ସେରୂପ କରିବ; ଏହିରୂପେ ଯାଜକ ସେମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେମାନେ କ୍ଷମାପ୍ରାପ୍ତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ଏଥିଉତ୍ତାରେ ସେ ଗୋବତ୍ସକୁ ଛାଉଣିର ବାହାରେ ନେଇ ପ୍ରଥମ ଗୋବତ୍ସ ତୁଲ୍ୟ ତାକୁ ଦଗ୍ଧ କରିବ; ତାହା ସମାଜର ପାପାର୍ଥକ ବଳିଦାନ। ");
INSERT INTO ory_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ଆଉ, ଯଦି କୌଣସି ଅଧ୍ୟକ୍ଷ ପାପ କରେ ଓ ଯାହା ନ କରିବାକୁ ତାହାର ସଦାପ୍ରଭୁ ପରମେଶ୍ୱର ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ସେସମସ୍ତ ମଧ୍ୟରୁ କୌଣସି ଏକ କର୍ମ ଭୁଲବଶତଃ କରି ଦୋଷୀ ହୁଏ; ");
INSERT INTO ory_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ତେବେ ସେ ଯେଉଁ ବିଷୟରେ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ ତାହାକୁ ଜ୍ଞାତ କରାଗଲେ, ସେ ଏକ ନିଖୁନ୍ତ ପୁଂ ଛାଗ ଉପହାର ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ପୁଣି, ସେ ସେହି ଛାଗର ମସ୍ତକରେ ହସ୍ତ ରଖି ହୋମବଳି ବଧ କରିବା ସ୍ଥାନରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାକୁ ବଧ କରିବ; ତାହା ପାପାର୍ଥକ ବଳିଦାନ। ");
INSERT INTO ory_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ତହୁଁ ଯାଜକ ଆପଣା ଅଙ୍ଗୁଳିରେ ସେହି ପାପାର୍ଥକ ବଳିର ରକ୍ତରୁ କିଛି ନେଇ ହୋମବେଦିର ଶୃଙ୍ଗ ଉପରେ ଦେବ ଓ ତାହାର ସମସ୍ତ ରକ୍ତ ହୋମବେଦି ମୂଳରେ ଢାଳିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ପୁଣି ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନର ମେଦ ତୁଲ୍ୟ ତାହାର ସକଳ ମେଦ ନେଇ ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ; ଏହିରୂପେ ଯାଜକ ତାହାର ପାପମୋଚନାର୍ଥକ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ଆଉ, ସଦାପ୍ରଭୁ ଯାହା ନ କରିବାକୁ ଆଜ୍ଞା କରିଅଛନ୍ତି, ତହିଁରୁ କୌଣସି କର୍ମ କରିବାରେ ଯଦି ସାଧାରଣ ଲୋକଙ୍କ ମଧ୍ୟରୁ କୌଣସି ପ୍ରାଣୀ ଭୁଲବଶତଃ ପାପ କରି ଦୋଷୀ ହୁଏ ");
INSERT INTO ory_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ଓ ସେ ଯେଉଁ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ ଯଦି ତାହାକୁ ଜ୍ଞାତ କରାଯାଏ, ତେବେ ସେ ଯେଉଁ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ ନିମନ୍ତେ ଏକ ନିଖୁନ୍ତ ଛାଗୀ ଉପହାର ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ପୁଣି ସେ ସେହି ପାପାର୍ଥକ ବଳିର ମସ୍ତକରେ ହସ୍ତ ରଖି ହୋମବଳି ବଧ କରିବା ସ୍ଥାନରେ ସେହି ପାପାର୍ଥକ ବଳି ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ତହୁଁ ଯାଜକ ଅଙ୍ଗୁଳିରେ ତାହାର ରକ୍ତରୁ କିଛି ନେଇ ହୋମବେଦିର ଶୃଙ୍ଗ ଉପରେ ଦେବ, ଆଉ ତାହାର ସମସ୍ତ ରକ୍ତ ହୋମବେଦି ମୂଳରେ ଢାଳିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ପୁଣି, ମଙ୍ଗଳାର୍ଥକ ବଳିରୁ ନିଆଯାଇଥିବା ମେଦ ତୁଲ୍ୟ ଏହାର ସକଳ ମେଦ ନେବ; ତହୁଁ ଯାଜକ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବେଦି ଉପରେ ତାହା ଦଗ୍ଧ କରିବ; ଏହିରୂପେ ଯାଜକ ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ମାତ୍ର ଯଦି ସେ ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ମେଷବତ୍ସା ଆଣେ, ତେବେ ନିଖୁନ୍ତ ମେଷବତ୍ସା ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ପୁଣି ସେହି ପାପାର୍ଥକ ବଳିର ମସ୍ତକରେ ହସ୍ତ ରଖି ହୋମବଳି ବଧ କରିବା ସ୍ଥାନରେ ପାପାର୍ଥକ ବଳିକୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ତହୁଁ ଯାଜକ ଅଙ୍ଗୁଳିରେ ସେହି ପାପାର୍ଥକ ବଳିର ରକ୍ତରୁ କିଛି ନେଇ ହୋମବେଦିର ଶୃଙ୍ଗ ଉପରେ ଦେବ ଓ ତାହାର ସମସ୍ତ ରକ୍ତ ହୋମବେଦି ମୂଳରେ ଢାଳିବ। ");
INSERT INTO ory_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ଆଉ, ମଙ୍ଗଳାର୍ଥକ ବଳିର ମେଷବତ୍ସଠାରୁ ନିଆଯାଇଥିବା ମେଦ ତୁଲ୍ୟ ଏହାର ସକଳ ମେଦ ନେବ, ପୁଣି ଯାଜକ ବେଦିରେ ସଦାପ୍ରଭୁଙ୍କ ଅଗ୍ନିକୃତ ଉପହାର ଉପରେ ତାହା ଦଗ୍ଧ କରିବ; ଏହିରୂପେ ସେ ଯେଉଁ ପାପ କରିଅଛି, ସେହି ପାପ ସକାଶୁ ଯାଜକ ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ଆଉ, ଯଦି କୌଣସି ବ୍ୟକ୍ତି ସାକ୍ଷୀ ହୋଇ ଶପଥ କରାଇବାର କଥା ଶୁଣିଲେ ହେଁ, ଯାହା ସେ ଦେଖିଅଛି ବା ଜାଣିଅଛି, ତାହା ପ୍ରକାଶ ନ କରି ପାପ କରେ, ତେବେ ସେ ଆପଣା ଅପରାଧ ବୋହିବ। ");
INSERT INTO ory_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ଅବା ଯଦି କେହି କୌଣସି ଅଶୁଚି ଦ୍ରବ୍ୟ, ଅର୍ଥାତ୍‍, ଅଶୁଚି ପଶୁର ଶବ, କି ଅଶୁଚି ଗୋମେଷାଦିର ଶବ, କି ଅଶୁଚି ଉରୋଗାମୀ ପ୍ରାଣୀର ଶବ ସ୍ପର୍ଶ କରେ, ପୁଣି ତାହା ତାହାଠାରୁ ଗୁପ୍ତ ଥାଏ ଓ ସେ ଅଶୁଚି ହୁଏ, ତେବେ ସେ ଦୋଷୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","କିଅବା ଯଦି ସେ ମନୁଷ୍ୟର ଅଶୁଚିକାରୀ କୌଣସି ଦ୍ରବ୍ୟ, ଅର୍ଥାତ୍‍, ଯଦ୍ଦ୍ୱାରା ମନୁଷ୍ୟ ଅଶୁଚି ହୁଏ, ଏପରି କିଛି ଦ୍ରବ୍ୟ ସ୍ପର୍ଶ କରେ, ପୁଣି ତାହା ତାହାଠାରୁ ଗୁପ୍ତ ଥାଏ, ତେବେ ସେ ତାହା ଜ୍ଞାତ ହେଲେ ଦୋଷୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ଅଥବା କେହି ଯଦି ମନ୍ଦ କରିବାକୁ କି ଭଲ କରିବାକୁ ବିଚାରହୀନତା ପୂର୍ବକ ଶପଥ କରେ, ମନୁଷ୍ୟ ଯେକୌଣସି ବିଷୟରେ ଶପଥପୂର୍ବକ ବିଚାରହୀନତା କରେ, ପୁଣି ତାହା ତାହାଠାରୁ ଗୁପ୍ତ ଥାଏ; ତେବେ ସେ ତାହା ଜ୍ଞାତ ହେଲେ, ଉକ୍ତ କୌଣସି ଏକ ବିଷୟରେ ଦୋଷୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ପୁଣି ଉକ୍ତ କୌଣସି ଏକ ବିଷୟରେ ସେ ଦୋଷୀ ହେଲେ, ଆପଣାର ସେହି କୃତ ପାପ ସ୍ୱୀକାର କରିବା ତାହାର କର୍ତ୍ତବ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ତହୁଁ ସେ ଯେଉଁ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ ନିମନ୍ତେ ପାପାର୍ଥକ ବଳିଦାନ ରୂପେ ପଲରୁ ମେଷବତ୍ସା କି ଛାଗବତ୍ସା ନେଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖକୁ ଦୋଷାର୍ଥକ ବଳି ଆଣିବ; ପୁଣି ଯାଜକ ତାହାର ପାପ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ଆଉ, ଯଦି ସେ ମେଷବତ୍ସା ଆଣିବାକୁ ଅସମର୍ଥ ହୁଏ, ତେବେ ସେ ଆପଣା କୃତ ପାପ ନିମନ୍ତେ ଦୋଷାର୍ଥକ ବଳି ରୂପେ ଦୁଇ କପୋତ ବା ଦୁଇ ପାରାଛୁଆ ଆଣି ତହିଁରୁ ଗୋଟିଏକୁ ପାପ ନିମନ୍ତେ ଓ ଅନ୍ୟଟିକୁ ହୋମ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ପୁଣି ସେ ଯାଜକ ନିକଟକୁ ସେମାନଙ୍କୁ ଆଣିବ, ତହୁଁ ଯାଜକ ପ୍ରଥମେ ପାପାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରି ତାହାର ବେକରୁ ମୁଣ୍ଡ ମୋଡ଼ିବ, ମାତ୍ର ଦୁଇ ଖଣ୍ଡ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ତହୁଁ ସେ ପାପାର୍ଥକ ବଳିର ରକ୍ତରୁ କିଛି ନେଇ ବେଦି ପାର୍ଶ୍ୱରେ ଛିଞ୍ଚିବ, ପୁଣି ଅବଶିଷ୍ଟ ତାହାର ସମସ୍ତ ରକ୍ତ ହୋମବେଦି ମୂଳରେ ଢାଳିବ; ତାହା ପାପାର୍ଥକ ବଳିଦାନ। ");
INSERT INTO ory_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ତହିଁ ଉତ୍ତାରେ ସେ ବିଧି ଅନୁସାରେ ଅନ୍ୟଟିକୁ ହୋମାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରିବ; ଏହିରୂପେ ସେ ଯେଉଁ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ ନିମନ୍ତେ ଯାଜକ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ମାତ୍ର ସେ ଯଦି ଦୁଇ କପୋତ ଅବା ଦୁଇ ପାରାଛୁଆ ଆଣିବାକୁ ଅସମର୍ଥ ହୁଏ, ତେବେ ସେ ଆପଣା କୃତ ପାପ ନିମନ୍ତେ ଆପଣାର ଉପହାର ରୂପେ ପାପାର୍ଥକ ନୈବେଦ୍ୟ ପାଇଁ ଐଫାର ଦଶମାଂଶ ସରୁ ମଇଦା ଆଣିବ; ସେ ତହିଁ ଉପରେ ତୈଳ ଦେବ ନାହିଁ, କି କୁନ୍ଦୁରୁ ରଖିବ ନାହିଁ; କାରଣ ତାହା ପାପାର୍ଥକ ନୈବେଦ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ତହୁଁ ସେ ତାହା ଯାଜକ ନିକଟକୁ ଆଣିଲେ, ଯାଜକ ତହିଁର ସ୍ମରଣାର୍ଥକ ଅଂଶ ରୂପେ ତହିଁରୁ ଏକ ମୁଷ୍ଟି ନେଇ ବେଦିରେ ସଦାପ୍ରଭୁଙ୍କ ଅଗ୍ନିକୃତ ଉପହାର ଉପରେ ତାହା ଦଗ୍ଧ କରିବ; ଏହା ପାପାର୍ଥକ ନୈବେଦ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ଏହିରୂପେ ଉକ୍ତ କୌଣସି ବିଷୟରେ ସେ ଯେଉଁ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ ସକାଶୁ ତାହା ନିମନ୍ତେ ଯାଜକ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ; ଆଉ, ଅବଶିଷ୍ଟ ଦ୍ରବ୍ୟ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ତୁଲ୍ୟ ଯାଜକର ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“କେହି ଯଦି ସତ୍ୟ-ଲଙ୍ଘନ କରି ସଦାପ୍ରଭୁଙ୍କ ପବିତ୍ର ବସ୍ତୁ ବିଷୟରେ ଭୁଲବଶତଃ ପାପ କରେ, ତେବେ ସେ ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ତୁମ୍ଭର ନିରୂପିତ ପରିମାଣର ରୂପା ଦେଇ ପଲରୁ ଏକ ନିଖୁନ୍ତ ମେଷ ଆଣି ଦୋଷାର୍ଥକ ବଳି ରୂପେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ପୁଣି ପବିତ୍ର ବସ୍ତୁ ବିଷୟରେ ସେ ଯେଉଁ ତ୍ରୁଟି କରିଅଛି, ତହିଁର ପରିଶୋଧ କରିବ, ତାହା ବ୍ୟତୀତ ପଞ୍ଚମାଂଶର ଏକାଂଶ ମଧ୍ୟ ଯାଜକକୁ ଦେବ, ତହୁଁ ଯାଜକ ଦୋଷାର୍ଥକ ମେଷବଳି ଦ୍ୱାରା ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ଆଉ, ଯାହା ନ କରିବାକୁ ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ଯଦି କୌଣସି ବ୍ୟକ୍ତି ତହିଁ ମଧ୍ୟରୁ କୌଣସି କର୍ମ କରି ପାପ କରେ; ଯଦ୍ୟପି ସେ ତାହା ଜାଣି ନ ଥାଏ, ତଥାପି ସେ ଦୋଷୀ ଅଟେ, ପୁଣି ଆପଣାର ଅପରାଧ ବୋହିବ। ");
INSERT INTO ory_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ସେ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଅନୁସାରେ ପଲରୁ ଏକ ନିଖୁନ୍ତ ମେଷ ଦୋଷାର୍ଥକ ବଳି ରୂପେ ଯାଜକ ନିକଟକୁ ଆଣିବ; ପୁଣି ଯେଉଁ ବିଷୟରେ ସେ ଭୁଲବଶତଃ ପାପ କଲା ଓ ତାହା ଜାଣିଲା ନାହିଁ, ଯାଜକ ତହିଁ ସକାଶୁ ତାହା ପାଇଁ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ତାହା ଦୋଷାର୍ଥକ ବଳି, ସେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ନିତାନ୍ତ ଦୋଷୀ।” ");
INSERT INTO ory_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“କେହି ଯଦି ପାପ କରି ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ସତ୍ୟ-ଲଙ୍ଘନ କରେ, ଅର୍ଥାତ୍‍, ଗଚ୍ଛିତ ବା ହସ୍ତରେ ସମର୍ପିତ କିଅବା ଅପହୃତ ଦ୍ରବ୍ୟ ବିଷୟରେ ଆପଣା ପ୍ରତିବାସୀ ସହିତ ଅସତ୍ୟ ବ୍ୟବହାର କରେ, ଅଥବା ଆପଣା ପ୍ରତିବାସୀ ପ୍ରତି ଅନ୍ୟାୟ କରେ; ");
INSERT INTO ory_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","କିଅବା ହଜାଦ୍ରବ୍ୟ ପାଇ ତଦ୍‍ବିଷୟରେ ଅସତ୍ୟ ବ୍ୟବହାର କରେ ଓ ମିଥ୍ୟା କହି ଶପଥ କରେ; ଏହି ପ୍ରକାର ଯେକୌଣସି କର୍ମରେ ମନୁଷ୍ୟ ପାପ କରେ; ");
INSERT INTO ory_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ତେବେ ସେ ପାପ କରି ଦୋଷୀ ହେଲେ, ଯାହା ସେ ଅପହରଣ ଦ୍ୱାରା ନେଇଅଛି, ଅବା ଅନ୍ୟାୟରେ ପ୍ରାପ୍ତ ହୋଇଅଛି, ଅବା ଯେଉଁ ଗଚ୍ଛିତ ଦ୍ରବ୍ୟ ତାହା ନିକଟରେ ସମର୍ପିତ ହୋଇଅଛି, ଅବା ଯେଉଁ ହଜାଦ୍ରବ୍ୟ ପାଇଅଛି, ");
INSERT INTO ory_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ଅବା ଯେକୌଣସି ବିଷୟରେ ମିଥ୍ୟା ଶପଥ କରିଅଛି, ସେହି ସବୁ ଦ୍ରବ୍ୟ ଫେରାଇ ଦେବ; ମଧ୍ୟ ସେ ତାହା ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଓ ତହିଁ ସଙ୍ଗେ ତହିଁର ପଞ୍ଚମାଂଶ ଅଧିକ ଫେରାଇ ଦେବ; ସେ ଦୋଷୀ ବୋଲି ନିଶ୍ଚିତ ହେବା ଦିନରେ ସେହି ଦ୍ରବ୍ୟର ମାଲିକକୁ ତାହା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ପୁଣି ସେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆପଣାର ଦୋଷାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରିବ; ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଅନୁସାରେ ପଲରୁ ଏକ ନିଖୁନ୍ତ ମେଷ ଦୋଷାର୍ଥକ ବଳି ନିମନ୍ତେ ଯାଜକ ନିକଟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ତହୁଁ ଯାଜକ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ ଯେକୌଣସି କର୍ମ ଦ୍ୱାରା ଦୋଷୀ ହୋଇଥାଏ, ତହିଁରୁ କ୍ଷମାପ୍ରାପ୍ତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ ଏହି ଆଜ୍ଞା ଦିଅ, ହୋମବଳିର ବ୍ୟବସ୍ଥା ଏହି; ହୋମଦ୍ରବ୍ୟ ସମସ୍ତ ରାତ୍ରି, ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ବେଦିର ଅଗ୍ନିସ୍ଥାନ ଉପରେ ରହିବ, ପୁଣି ବେଦିର ଅଗ୍ନି ପ୍ରଜ୍ୱଳିତ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ପୁଣି ଯାଜକ ଆପଣା ଶୁକ୍ଳବସ୍ତ୍ର ଓ ଶରୀରରେ ଶୁକ୍ଳ ଜଙ୍ଘିଆ ପିନ୍ଧିବ; ଆଉ ସେ ବେଦି ଉପରେ ଅଗ୍ନିଦଗ୍ଧ ହୋମବଳିର ଭସ୍ମ ଉଠାଇ ବେଦି ପାର୍ଶ୍ୱରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ଏଥିଉତ୍ତାରେ ସେ ଆପଣାର ସେହି ବସ୍ତ୍ର ତ୍ୟାଗ କରି ଅନ୍ୟ ବସ୍ତ୍ର ପିନ୍ଧି ଛାଉଣିର ବାହାରେ କୌଣସି ଶୁଚି ସ୍ଥାନକୁ ସେହି ଭସ୍ମ ନେଇଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ମାତ୍ର ବେଦିର ଉପରିସ୍ଥ ଅଗ୍ନି ସର୍ବଦା ପ୍ରଜ୍ୱଳିତ ରହିବ, ତାହା ଲିଭିବ ନାହିଁ; ଯାଜକ ପ୍ରତ୍ୟେକ ପ୍ରଭାତରେ ତହିଁ ଉପରେ କାଷ୍ଠ ଜାଳିବ; ପୁଣି ସେ ତହିଁ ଉପରେ ହୋମବଳି ସଜାଇ ରଖିବ ଓ ମଙ୍ଗଳାର୍ଥକ ବଳିର ମେଦ ତହିଁ ଉପରେ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ବେଦି ଉପରେ ଅଗ୍ନି ସର୍ବଦା ପ୍ରଜ୍ୱଳିତ ରହିବ, ତାହା କଦାପି ଲିଭିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ଆଉ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟର ବ୍ୟବସ୍ଥା ଏହି; ହାରୋଣର ପୁତ୍ରଗଣ ବେଦି ସମ୍ମୁଖରେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ତାହା ଆଣିବେ। ");
INSERT INTO ory_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ତହୁଁ ଯାଜକ ଆପଣା ମୁଷ୍ଟି ପୂର୍ଣ୍ଣ କରି ସେହି ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟରୁ କିଛି ସରୁ ମଇଦା ଓ କିଛି ତୈଳ ଓ ନୈବେଦ୍ୟ ଉପରିସ୍ଥ ସମସ୍ତ କୁନ୍ଦୁରୁ ନେଇ ତହିଁର ସ୍ମରଣାର୍ଥକ ଅଂଶ ରୂପେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ବେଦିରେ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ପୁଣି, ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ତହିଁର ଅବଶିଷ୍ଟାଂଶ ଭୋଜନ କରିବେ; କୌଣସି ପବିତ୍ର ସ୍ଥାନରେ ତାଡ଼ି ବିନା ତାହା ଭୋଜନ କରାଯିବ; ସେମାନେ ସମାଗମ-ତମ୍ବୁର ପ୍ରାଙ୍ଗଣରେ ତାହା ଭୋଜନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ତାଡ଼ି ସହିତ ତାହା ରନ୍ଧନ ହେବ ନାହିଁ। ଆମ୍ଭେ ଆପଣା ଅଗ୍ନିକୃତ ଉପହାରରୁ ସେମାନଙ୍କ ଅଂଶ ନିମନ୍ତେ ତାହା ଦେଲୁ; ପାପାର୍ଥକ ବଳି ଓ ଦୋଷାର୍ଥକ ବଳି ତୁଲ୍ୟ ତାହା ମହାପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ହାରୋଣର ସନ୍ତାନଗଣ ମଧ୍ୟରେ ପ୍ରତ୍ୟେକ ପୁରୁଷ ତାହା ଭୋଜନ କରିବେ; ସଦାପ୍ରଭୁଙ୍କ ଅଗ୍ନିକୃତ ଉପହାରରୁ ଏହା ଗ୍ରହଣ କରିବା ହେଉଛି ପୁରୁଷାନୁକ୍ରମରେ ତୁମ୍ଭମାନଙ୍କର ଅନନ୍ତକାଳୀନ ଅଧିକାର। ଯେକେହି ତାହା ସ୍ପର୍ଶ କରେ, ସେ ପବିତ୍ର ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ଅଭିଷେକ ଦିନରେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯେଉଁ ଉପହାର ଉତ୍ସର୍ଗ କରିବେ, ତାହା ଏହି; ସେମାନେ ନିତ୍ୟ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ଐଫାର ଦଶମାଂଶ ସରୁ ମଇଦା ନେଇ ଅର୍ଦ୍ଧେକ ପ୍ରଭାତରେ ଓ ଅର୍ଦ୍ଧେକ ସନ୍ଧ୍ୟାକାଳରେ ଉତ୍ସର୍ଗ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ପଲମରେ ଯାହା ତୈଳ ସହିତ ପ୍ରସ୍ତୁତ କରାଯିବ, ଓଦା ହେଲେ ତୁମ୍ଭେ ତାହା ଭିତରକୁ ଆଣିବ; ପୁଣି ସେହି ରନ୍ଧନ କରାଯାଇଥିବା ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟର ଖଣ୍ଡ ଖଣ୍ଡ ଖାଦ୍ୟ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ଏଥିଉତ୍ତାରେ ହାରୋଣର ପୁତ୍ରଗଣ ମଧ୍ୟରୁ ଯେ ତାହାର ପଦରେ ଅଭିଷିକ୍ତ ଯାଜକ ହେବ, ସେ ତାହା ଉତ୍ସର୍ଗ କରିବ; ଏହା ଅନନ୍ତକାଳୀନ ବିଧିରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସମ୍ପୂର୍ଣ୍ଣ ଦଗ୍ଧ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ଅର୍ଥାତ୍‍, ଯାଜକର ପ୍ରତ୍ୟେକ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଦଗ୍ଧ ହେବ; ତାହା ଭୋଜନ କରାଯିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ କୁହ, ପାପାର୍ଥକ ବଳିଦାନର ବ୍ୟବସ୍ଥା ଏହି; ଯେଉଁ ସ୍ଥାନରେ ହୋମବଳି ବଧ କରାଯାଏ, ସେହି ସ୍ଥାନରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପାପାର୍ଥକ ବଳି ବଧ କରାଯିବ; ତାହା ମହାପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ଯେଉଁ ଯାଜକ ପାପାର୍ଥେ ତାହା ଉତ୍ସର୍ଗ କରେ, ସେ ତାହା ଭୋଜନ କରିବ; ସମାଗମ-ତମ୍ବୁ ପ୍ରାଙ୍ଗଣର କୌଣସି ପବିତ୍ର ସ୍ଥାନରେ ତାହା ଭୋଜନ କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ଯେକେହି ତହିଁର ମାଂସ ସ୍ପର୍ଶ କରେ, ତାହା ପବିତ୍ର ହେବ; ପୁଣି ଯଦି କୌଣସି ବସ୍ତ୍ରରେ ତହିଁର ରକ୍ତର ଛିଟା ପଡ଼େ; ତେବେ ତୁମ୍ଭେ ସେହି ରକ୍ତ ସେଚିତ ବସ୍ତ୍ର ପବିତ୍ର ସ୍ଥାନରେ ଧୌତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ମାତ୍ର ଯେଉଁ ମୃତ୍ତିକାର ପାତ୍ରରେ ତାହା ପାକ ହୁଏ, ତାହା ଭଙ୍ଗାଯିବ; ଯଦି ପିତ୍ତଳ ପାତ୍ରରେ ତାହା ପାକ ହୁଏ, ତେବେ ତାହା ମଜାଯିବ ଓ ଜଳରେ ପରିଷ୍କୃତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ଯାଜକଗଣ ମଧ୍ୟରେ ସମସ୍ତ ପୁରୁଷ ତାହା ଭୋଜନ କରିବେ; ତାହା ମହାପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ମାତ୍ର ପବିତ୍ର ସ୍ଥାନରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ନିମନ୍ତେ ଯେକୌଣସି ପାପାର୍ଥକ ବଳିର ରକ୍ତ ସମାଗମ-ତମ୍ବୁ ଭିତରକୁ ଅଣାଯାଏ, ତାହା ଭୋଜନ କରାଯିବ ନାହିଁ, ତାହା ଅଗ୍ନିରେ ଦଗ୍ଧ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ଆଉ, ଦୋଷାର୍ଥକ ବଳିର ବ୍ୟବସ୍ଥା ଏହି; ତାହା ମହାପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ଯେଉଁ ସ୍ଥାନରେ ଲୋକମାନେ ହୋମବଳି ବଧ କରନ୍ତି, ସେହି ସ୍ଥାନରେ ସେମାନେ ଦୋଷାର୍ଥକ ବଳି ବଧ କରିବେ; ପୁଣି, ଯାଜକ ବେଦି ଉପରେ ଚାରିଆଡ଼େ ତାହାର ରକ୍ତ ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ଆଉ, ସେ ତାହାର ସବୁ ମେଦ, ଅର୍ଥାତ୍‍, ମେଦମୟ ଲାଙ୍ଗୁଳ, ଅନ୍ତ ଆଚ୍ଛାଦକ ମେଦ, ଦୁଇ ଗୁର୍ଦା ");
INSERT INTO ory_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ଓ ତହିଁ ଉପରିସ୍ଥ ପାର୍ଶ୍ୱବର୍ତ୍ତୀ ମେଦ ଓ ଦୁଇ ଗୁର୍ଦା ସହିତ ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ ନେଇ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ପୁଣି, ଯାଜକ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାରାର୍ଥେ ବେଦି ଉପରେ ତାହାସବୁ ଦଗ୍ଧ କରିବ; ଏହା ଦୋଷାର୍ଥକ ବଳି। ");
INSERT INTO ory_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ଯାଜକଗଣ ମଧ୍ୟରେ ପ୍ରତ୍ୟେକ ପୁରୁଷ ତାହା ଭୋଜନ କରିବେ; କୌଣସି ପବିତ୍ର ସ୍ଥାନରେ ତାହା ଭୋଜନ କରାଯିବ; ତାହା ମହାପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ଯେପରି ପାପାର୍ଥକ ବଳି, ସେପରି ଦୋଷାର୍ଥକ ବଳି; ଯେଉଁ ଯାଜକ ତଦ୍ଦ୍ୱାରା ପ୍ରାୟଶ୍ଚିତ୍ତ କରେ, ତାହା ତାହାରି ହେବ; ଦୁଇଟିର ବ୍ୟବସ୍ଥା ଏକ। ");
INSERT INTO ory_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ପୁଣି ଯାଜକ ଯେଉଁ ଲୋକର ହୋମବଳି ଉତ୍ସର୍ଗ କରେ, ତାହାର ସେହି ଉତ୍ସର୍ଗିତ ହୋମବଳି ପଶୁର ଚର୍ମ ସେହି ଯାଜକର ନିଜ ପାଇଁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ପୁଣି, ତନ୍ଦୁରରେ ବା କରେଇରେ ଅବା ପଲମରେ ରନ୍ଧନ ହୋଇଥିବା ଯେତେ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ତାହାସବୁ ଉତ୍ସର୍ଗକାରୀ ଯାଜକର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ମାତ୍ର ତୈଳ ମିଶ୍ରିତ ବା ଶୁଷ୍କ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟସବୁ ହାରୋଣଙ୍କର ପୁତ୍ରଗଣ ମଧ୍ୟରେ ପ୍ରତ୍ୟେକଙ୍କର ସମାନ ଅଂଶ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ଆଉ, ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗିତ ମଙ୍ଗଳାର୍ଥକ ଉପହାର ବଳିର ବ୍ୟବସ୍ଥା ଏହି। ");
INSERT INTO ory_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","କେହି ଯଦି ପ୍ରଶଂସାର୍ଥକ ବଳି ଆଣେ, ତେବେ ସେ ପ୍ରଶଂସାର୍ଥକ ବଳି ସହିତ ତୈଳ ମିଶ୍ରିତ ତାଡ଼ିଶୂନ୍ୟ ପିଠା, ତୈଳଲେପିତ ତାଡ଼ିଶୂନ୍ୟ ଚକୁଳି ଓ ସରୁ ମଇଦାର ତୈଳ ମିଶ୍ରିତ ରନ୍ଧନ ହୋଇଥିବା ପିଠା ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ଆଉ, ସେ ମଙ୍ଗଳାର୍ଥକ ପ୍ରଶଂସା ବଳି ସହିତ ତାଡ଼ିଯୁକ୍ତ ରୁଟିର ପିଠା ଦେଇ ଆପଣା ଉପହାର ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ତହୁଁ ସେ ପ୍ରତ୍ୟେକ ଉପହାରରୁ ଏକ ଏକ ପିଠା ନେଇ ଉତ୍ତୋଳନୀୟ ନୈବେଦ୍ୟ ରୂପେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ; ଯେଉଁ ଯାଜକ ମଙ୍ଗଳାର୍ଥକ ବଳିର ରକ୍ତ ଛିଞ୍ଚିବ, ତାହା ତାହାରି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ପୁଣି, ମଙ୍ଗଳାର୍ଥକ ପ୍ରଶଂସା ବଳିର ମାଂସ ତାହାର ଉତ୍ସର୍ଗ ଦିନରେ ଭୋଜନ କରାଯିବ; ସେ ପ୍ରାତଃକାଳ ପର୍ଯ୍ୟନ୍ତ ତହିଁରୁ କିଛି ରଖିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ମାତ୍ର ଯଦି ସେହି ଉପହାର ବଳି ତାହାର ମାନତ ବା ସ୍ୱେଚ୍ଛାଦତ୍ତ ନୈବେଦ୍ୟ ହୁଏ, ତେବେ ତାହାର ସେହି ବଳି ଉତ୍ସର୍ଗ କରିବା ଦିନରେ ତାହା ଭୋଜନ କରାଯିବ; ପୁଣି ତହିଁରୁ ଯାହା ଅବଶିଷ୍ଟ ରହିବ, ତାହା ଆରଦିନ ପ୍ରାତଃକାଳରେ ଭୋଜନ କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ମାତ୍ର ତୃତୀୟ ଦିନରେ ବଳିର ଅବଶିଷ୍ଟ ମାଂସ ଅଗ୍ନିରେ ଦଗ୍ଧ କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ଯଦି ତୃତୀୟ ଦିନରେ ତାହାର ସେହି ମଙ୍ଗଳାର୍ଥକ ଉପହାର ବଳିରୁ କିଛିମାତ୍ର ଭୋଜନ କରାଯାଏ, ତେବେ ତାହା ଗ୍ରାହ୍ୟ ହେବ ନାହିଁ, କିଅବା ତହିଁର ଉତ୍ସର୍ଗକାରୀ ପକ୍ଷରେ ତାହା ଗଣାଯିବ ନାହିଁ; ତାହା ଘୃଣାଯୋଗ୍ୟ ହେବ, ପୁଣି ଯେଉଁ ପ୍ରାଣୀ ତାହା ଭୋଜନ କରେ, ସେ ଆପଣା ଅପରାଧ ବୋହିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ଆଉ, ସେହି ମାଂସ କୌଣସି ଅଶୁଚି ବସ୍ତୁରେ ଲାଗିଲେ, ତାହା ଭୋଜନ କରାଯିବ ନାହିଁ; ତାହା ଅଗ୍ନିରେ ଦଗ୍ଧ ହେବ। ଆଉ, ସେହି ଶୁଚି ମାଂସ ପ୍ରତ୍ୟେକ ଶୁଚି ଲୋକ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ମାତ୍ର ଯେଉଁ ପ୍ରାଣୀ ଆପଣା ଶରୀରରେ ଅଶୁଚିତା ଥାଉ ଥାଉ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ବନ୍ଧୀୟ ମଙ୍ଗଳାର୍ଥକ ବଳିର ମାଂସ ଭୋଜନ କରେ, ସେହି ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ଯେବେ କେହି କୌଣସି ବସ୍ତୁ, ଅର୍ଥାତ୍‍, ମନୁଷ୍ୟର ଅଶୁଚିତା, କି ଅଶୁଚି ପଶୁ, କିଅବା କୌଣସି ଘୃଣାଯୋଗ୍ୟ ଅଶୁଚି ବସ୍ତୁ ସ୍ପର୍ଶ କରି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ବନ୍ଧୀୟ ମଙ୍ଗଳାର୍ଥକ ବଳିର ମାଂସ ଭୋଜନ କରେ, ତେବେ ସେହି ଭୋଜନକାରୀ ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ଆହୁରି, ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ ");
INSERT INTO ory_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ‘ତୁମ୍ଭେମାନେ ଗୋରୁର, କି ମେଷର କି ଛେଳିର ମେଦ ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ପୁଣି ସ୍ୱୟଂମୃତ ବା ପଶୁ ଦ୍ୱାରା ବିଦୀର୍ଣ୍ଣ ପଶୁର ମେଦ ଅନ୍ୟ କୌଣସି କାର୍ଯ୍ୟରେ ବ୍ୟବହାର କରାଯାଇପାରେ; ମାତ୍ର ତୁମ୍ଭେମାନେ କୌଣସିମତେ ତାହା ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","କାରଣ ମନୁଷ୍ୟମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପେ ଯେଉଁ ପଶୁ ଉତ୍ସର୍ଗ କରନ୍ତି, ତାହାର ମେଦ ଯେବେ କେହି ଭୋଜନ କରେ; ତେବେ ତାହା ଭୋଜନକାରୀ ସେହି ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ପୁଣି, ତୁମ୍ଭମାନଙ୍କର କୌଣସି ବାସ ସ୍ଥାନରେ ତୁମ୍ଭେମାନେ କୌଣସି ପକ୍ଷୀର କି ପଶୁର ରକ୍ତ ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ଯେକୌଣସି ରକ୍ତ ଯିଏ ଭୋଜନ କରେ, ସେ ଯିଏ ହେଉ, ସେହି ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ଆଉ, ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ");
INSERT INTO ory_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ଯେକେହି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମଙ୍ଗଳାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରେ, ସେ ଆପଣା ମଙ୍ଗଳାର୍ଥକ ବଳିରୁ ସଦାପ୍ରଭୁଙ୍କ ନିକଟକୁ ଆପଣା ନୈବେଦ୍ୟ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ତାହାର ନିଜ ହସ୍ତ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଆଣିବ; ସେ ବକ୍ଷ ସହିତ ମେଦ ଆଣିବ, ତହିଁରେ ସେହି ବକ୍ଷ ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ଦୋଳାୟିତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ପୁଣି ଯାଜକ ବେଦି ଉପରେ ସେହି ମେଦ ଦଗ୍ଧ କରିବ, ମାତ୍ର ବକ୍ଷ ହାରୋଣର ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ପୁଣି, ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ମଙ୍ଗଳାର୍ଥକ ବଳିରୁ ଡାହାଣ ଜଙ୍ଘ ଉତ୍ତୋଳନୀୟ ଉପହାର ରୂପେ ଯାଜକକୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ହାରୋଣର ପୁତ୍ରଗଣଙ୍କ ମଧ୍ୟରେ ଯେକେହି ମଙ୍ଗଳାର୍ଥକ ବଳିର ରକ୍ତ ଓ ମେଦ ଉତ୍ସର୍ଗ କରେ, ସେ ଆପଣା ଅଂଶ ରୂପେ ମଙ୍ଗଳାର୍ଥକ ବଳିର ଡାହାଣ ଜଙ୍ଘ ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ଯେହେତୁ ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ମଙ୍ଗଳାର୍ଥକ ବଳିରୁ ଦୋଳନୀୟ ନୈବେଦ୍ୟର ବକ୍ଷ ଓ ଉତ୍ତୋଳନୀୟ ଉପହାରର ଜଙ୍ଘ ନେଇ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଅନନ୍ତକାଳୀନ ଦେୟ ରୂପେ ହାରୋଣ ଯାଜକକୁ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ ଦେଇଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ଯେଉଁ ଦିନ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଯାଜକ କର୍ମ କରିବା ନିମନ୍ତେ ହାରୋଣଙ୍କୁ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ ଉପସ୍ଥିତ କରାଇଲେ, ସେହି ଦିନଠାରୁ ସଦାପ୍ରଭୁଙ୍କ ଅଗ୍ନିକୃତ ଉପହାର ମଧ୍ୟରୁ ଏହା ହିଁ ସେମାନଙ୍କର ଅଭିଷେକ ଅଂଶ; ");
INSERT INTO ory_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ସେ ସେମାନଙ୍କୁ ଅଭିଷେକ କରିବା ଦିନ ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ତାହା ଦତ୍ତ ହେବା ନିମନ୍ତେ ଆଜ୍ଞା ଦେଲେ। ତାହା ସେମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ଅନନ୍ତକାଳୀନ ଦେୟ।” ");
INSERT INTO ory_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ହୋମବଳି, ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ପାପାର୍ଥକ ବଳି, ଦୋଷାର୍ଥକ ବଳି ଓ ପଦନିଯୋଗାର୍ଥକ; ପୁଣି ମଙ୍ଗଳାର୍ଥକ ବଳିର ଏହି ବ୍ୟବସ୍ଥା। ");
INSERT INTO ory_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ସଦାପ୍ରଭୁ ଯେଉଁ ଦିନ ସୀନୟ ପ୍ରାନ୍ତରସ୍ଥିତ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆପଣା ଆପଣା ଉପହାର ଦେବାକୁ ଆଜ୍ଞା ଦେଲେ, ସେହି ଦିନ ସୀନୟ ପର୍ବତରେ ମୋଶାଙ୍କୁ ଆଜ୍ଞା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହା ସହିତ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ, ଆଉ ବସ୍ତ୍ରସକଳ, ଅଭିଷେକାର୍ଥକ ତୈଳ, ପାପାର୍ଥକ ବଳିର ଗୋବତ୍ସ, ଦୁଇ ମେଷ ଓ ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ଟୋକେଇ ଆପଣା ସଙ୍ଗେ ନିଅ। ");
INSERT INTO ory_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ପୁଣି ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସମଗ୍ର ମଣ୍ଡଳୀକୁ ଏକତ୍ର କର।” ");
INSERT INTO ory_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ଆଉ, ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା କଲେ; ତହିଁରେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସମଗ୍ର ମଣ୍ଡଳୀ ଏକତ୍ର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ପୁଣି ମୋଶା ମଣ୍ଡଳୀକୁ କହିଲେ, “ଯାହା କରିବା ପାଇଁ ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ସେହି କଥା ଏହି।” ");
INSERT INTO ory_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ତହୁଁ ମୋଶା ହାରୋଣଙ୍କୁ ଓ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ ଆଣି ଜଳରେ ସ୍ନାନ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ପୁଣି ହାରୋଣଙ୍କୁ ପୋଷାକ ପିନ୍ଧାଇଲେ ଓ କଟିବନ୍ଧନୀରେ ତାଙ୍କର କଟି ବାନ୍ଧିଲେ ଓ ତାଙ୍କୁ ଚୋଗା ପିନ୍ଧାଇଲେ ଓ ତହିଁ ଉପରେ ଏଫୋଦ ଦେଲେ, ପୁଣି ଏଫୋଦର ଚିତ୍ରିତ ପଟୁକା ବାନ୍ଧି ତହିଁ ସଙ୍ଗେ ଏଫୋଦକୁ ବାନ୍ଧିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ଆଉ, ସେ ତାହା ଉପରେ ବୁକୁପଟା ଦେଲେ ଆଉ, ବୁକୁପଟାରେ ଊରୀମ୍‍ ଓ ତୁମ୍ମୀମ୍‍ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ପୁଣି, ତାଙ୍କର ମସ୍ତକରେ ପଗଡ଼ି ରଖିଲେ; ପଗଡ଼ି ସମ୍ମୁଖରେ ସ୍ୱର୍ଣ୍ଣପତ୍ରର ପବିତ୍ର ମୁକୁଟ ଦେଲେ; ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଏହା କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ଏଥିଉତ୍ତାରେ ମୋଶା ଅଭିଷେକାର୍ଥକ ତୈଳ ନେଇ ଆବାସ ଓ ତହିଁ ମଧ୍ୟସ୍ଥିତ ସମସ୍ତ ବସ୍ତୁ ଅଭିଷେକ କରି ପବିତ୍ର କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ପୁଣି, ସେ ତହିଁରୁ କିଛି ନେଇ ବେଦି ଉପରେ ସାତ ଥର ସେଚନ କଲେ; ଆଉ, ବେଦି ଓ ତହିଁର ସମସ୍ତ ପାତ୍ର ଓ ପ୍ରକ୍ଷାଳନ-ପାତ୍ର ଓ ତହିଁର ବୈଠିକି ପବିତ୍ର କରିବାକୁ ଅଭିଷେକ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ଏଥିଉତ୍ତାରେ ମୋଶା ହାରୋଣଙ୍କୁ ପବିତ୍ର କରିବା ପାଇଁ ତାଙ୍କର ମସ୍ତକରେ କିଛି ଅଭିଷେକାର୍ଥକ ତୈଳ ଢାଳି ତାଙ୍କୁ ଅଭିଷେକ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ଏଥିଉତ୍ତାରେ ମୋଶା ହାରୋଣଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ ଆଣି ସେମାନଙ୍କୁ ପୋଷାକ ପିନ୍ଧାଇଲେ ଓ କଟିବନ୍ଧନୀରେ ସେମାନଙ୍କର କଟି ବାନ୍ଧିଲେ ଓ ସେମାନଙ୍କୁ ଶିରୋଭୂଷଣରେ ଭୂଷିତ କଲେ; ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ଏହା କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ଆଉ, ସେ ପାପାର୍ଥକ ବଳିର ଗୋବତ୍ସ ଆଣିଲେ; ପୁଣି ହାରୋଣ ଓ ତାଙ୍କର ପୁତ୍ରଗଣ ସେହି ପାପାର୍ଥକ ବଳିର ଗୋବତ୍ସ ମସ୍ତକରେ ହସ୍ତ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ତହୁଁ ସେ ତାକୁ ବଧ କଲେ; ପୁଣି ମୋଶା ରକ୍ତ ନେଇ ଅଙ୍ଗୁଳି ଦ୍ୱାରା ବେଦିର ଚାରିଆଡ଼େ ଶୃଙ୍ଗ ଉପରେ ଦେଇ ବେଦିକୁ ପବିତ୍ର କଲେ; ଆଉ, ବେଦି ମୂଳରେ ସେହି ରକ୍ତ ଢାଳିଦେଲେ ଓ ତହିଁ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ପାଇଁ ପବିତ୍ର କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ଏଥିଉତ୍ତାରେ ମୋଶା ଅନ୍ତ ଉପରିସ୍ଥ ସମସ୍ତ ମେଦ, ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ, ଦୁଇ ଗୁର୍ଦା ଓ ତହିଁର ମେଦ ନେଇ ବେଦି ଉପରେ ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ମାତ୍ର ସେହି ଗୋବତ୍ସର ଚର୍ମ, ମାଂସ ଓ ଗୋମୟ ନେଇ ଛାଉଣିର ବାହାରେ ଦଗ୍ଧ କଲେ; ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ଏହା କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ଏଥିଉତ୍ତାରେ ସେ ହୋମାର୍ଥକ ମେଷ ଆଣିଲେ; ତହିଁରେ ହାରୋଣ ଓ ତାଙ୍କର ପୁତ୍ରଗଣ ମେଷର ମସ୍ତକରେ ହସ୍ତ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ତହୁଁ ସେ ତାକୁ ବଧ କଲେ, ପୁଣି ମୋଶା ବେଦି ଉପରେ ଚାରିଆଡ଼େ ରକ୍ତ ସେଚନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ଆଉ, ସେ ମେଷକୁ ଖଣ୍ଡ ଖଣ୍ଡ କରି କାଟିଲେ; ପୁଣି, ମୋଶା ତାହାର ମସ୍ତକ, ମାଂସଖଣ୍ଡସକଳ ଓ ମେଦ ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ଆଉ, ସେ ତାହାର ଅନ୍ତ ଓ ପାଦ ଜଳରେ ଧୌତ କଲେ। ପୁଣି, ମୋଶା ବେଦି ଉପରେ ମେଷ ସମେତ ଦଗ୍ଧ କଲେ, ଏହା ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥକ ହୋମବଳି; ଏହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର। ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ଏହା କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ଏଥିଉତ୍ତାରେ ସେ ଅନ୍ୟ ମେଷ, ଅର୍ଥାତ୍‍, ପଦନିଯୋଗାର୍ଥକ ମେଷ ଆଣିଲେ, ତହିଁରେ ହାରୋଣ ଓ ତାଙ୍କର ପୁତ୍ରଗଣ ମେଷର ମସ୍ତକ ଉପରେ ହସ୍ତ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ଆଉ, ସେ ତାକୁ ବଧ କଲେ; ତହୁଁ ମୋଶା ତାହାର କିଛି ରକ୍ତ ନେଇ ହାରୋଣଙ୍କର ଡାହାଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ ଓ ତାଙ୍କର ଡାହାଣ ହସ୍ତର ବୃଦ୍ଧାଙ୍ଗୁଳି ଉପରେ ଓ ଡାହାଣ ପାଦର ବୃଦ୍ଧାଙ୍ଗୁଳି ଉପରେ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ଏଥିଉତ୍ତାରେ ସେ ହାରୋଣଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ ଆଣିଲେ, ତହୁଁ ମୋଶା ସେହି ରକ୍ତରୁ କିଛି ନେଇ ସେମାନଙ୍କ ଡାହାଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ ଓ ସେମାନଙ୍କ ଡାହାଣ ହସ୍ତର ବୃଦ୍ଧାଙ୍ଗୁଳି ଉପରେ ଓ ସେମାନଙ୍କ ଡାହାଣ ପାଦର ବୃଦ୍ଧାଙ୍ଗୁଳି ଉପରେ ଦେଲେ; ଆଉ ମୋଶା ବେଦି ଉପରେ ଚାରିଆଡ଼େ ରକ୍ତ ସେଚନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ପୁଣି, ସେ ମେଦ, ମେଦମୟ ଲାଙ୍ଗୁଳ, ଅନ୍ତ ଉପରିସ୍ଥ ସକଳ ମେଦ, ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ, ଦୁଇ ଗୁର୍ଦା, ତହିଁର ମେଦ ଓ ଡାହାଣ ଜଙ୍ଘ ନେଲେ; ");
INSERT INTO ory_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ଆଉ, ସେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖସ୍ଥ ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ଟୋକେଇରୁ ଗୋଟିଏ ତାଡ଼ିଶୂନ୍ୟ ପିଠା ଓ ତୈଳଲେପିତ ରନ୍ଧନ ହୋଇଥିବା ରୁଟିର ଗୋଟିଏ ପିଠା ଓ ଗୋଟିଏ ସରୁ ଚକୁଳି ନେଇ ମେଦ ଓ ଡାହାଣ ଜଙ୍ଘ ଉପରେ ରଖିଲେ; ");
INSERT INTO ory_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ତହୁଁ ସେ ହାରୋଣଙ୍କର ଓ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କର ହସ୍ତରେ ସେହି ସବୁ ଦେଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ଦୋଳାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ଏଥିଉତ୍ତାରେ ମୋଶା ସେମାନଙ୍କ ହସ୍ତରୁ ସେହି ସବୁ ନେଇ ବେଦିସ୍ଥିତ ହୋମବଳି ଉପରେ ଦଗ୍ଧ କଲେ; ଏହିସବୁ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ପଦନିଯୋଗାର୍ଥକ ନୈବେଦ୍ୟ; ଏହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ଆଉ, ମୋଶା ବକ୍ଷ ନେଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ଦୋଳାଇଲେ; ପଦନିଯୋଗାର୍ଥକ ମେଷର ଏହି ଅଂଶ ମୋଶାଙ୍କର ହେଲା; ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ଏହା କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ଏଥିଉତ୍ତାରେ ମୋଶା ଅଭିଷେକାର୍ଥକ ତୈଳରୁ ଓ ବେଦି ଉପରିସ୍ଥ ରକ୍ତରୁ କିଛି ନେଇ ହାରୋଣଙ୍କ ଉପରେ ଓ ତାଙ୍କର ବସ୍ତ୍ର ଉପରେ, ପୁଣି ତାଙ୍କ ସଙ୍ଗେ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କ ଉପରେ ଓ ସେମାନଙ୍କ ବସ୍ତ୍ର ଉପରେ ତାହା ସେଚନ କଲେ; ଆଉ ହାରୋଣଙ୍କୁ ଓ ତାଙ୍କର ବସ୍ତ୍ରସକଳକୁ ଓ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ ଓ ସେମାନଙ୍କ ବସ୍ତ୍ରସକଳକୁ ପବିତ୍ର କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ତହୁଁ ମୋଶା ହାରୋଣଙ୍କୁ ଓ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ କହିଲେ, “ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ମାଂସ ରନ୍ଧନ କର; ଆଉ ‘ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ତାହା ଭୋଜନ କରିବେ,’ ଆମ୍ଭର ଏହି ଆଜ୍ଞାନୁସାରେ ସେହି ସ୍ଥାନରେ ତାହା ଓ ପଦନିଯୋଗାର୍ଥକ ଟୋକେଇରେ ଥିବା ରୁଟି ଭୋଜନ କର। ");
INSERT INTO ory_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ପୁଣି, ମାଂସ ଓ ରୁଟିରୁ ଯାହା ଅବଶିଷ୍ଟ ରହିବ, ତାହା ତୁମ୍ଭେମାନେ ଅଗ୍ନିରେ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ଆଉ, ତୁମ୍ଭେମାନେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ, ଅର୍ଥାତ୍‍, ତୁମ୍ଭମାନଙ୍କ ପଦନିଯୋଗ ଦିନର ସମାପ୍ତି ପର୍ଯ୍ୟନ୍ତ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାରରୁ ବାହାରକୁ ଯିବ ନାହିଁ; କାରଣ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କୁ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପଦରେ ନିଯୁକ୍ତ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ଯେପରି ଆଜି କରାଯାଇଅଛି, ସେପରି ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବାକୁ ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ପୁଣି, ତୁମ୍ଭେମାନେ ଯେପରି ନ ମର, ଏଥିପାଇଁ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାରରେ ଦିବାରାତ୍ର ରହିବ ଓ ସଦାପ୍ରଭୁଙ୍କର ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବ। କାରଣ ଏହିପରି ଆମ୍ଭେ ଆଜ୍ଞା ପାଇଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ଦ୍ୱାରା ଯାହା ଆଜ୍ଞା କରିଥିଲେ, ହାରୋଣ ଓ ତାଙ୍କର ପୁତ୍ରଗଣ ସେହି ସବୁ କଥା ପାଳନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ଏଥିଉତ୍ତାରେ ଅଷ୍ଟମ ଦିନରେ ମୋଶା ହାରୋଣଙ୍କୁ ଓ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ ଓ ଇସ୍ରାଏଲର ପ୍ରାଚୀନବର୍ଗଙ୍କୁ ଡାକିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ପୁଣି ସେ ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ନିଖୁନ୍ତ ଏକ ବୃଷର ବତ୍ସ ଓ ହୋମବଳି ନିମନ୍ତେ ନିଖୁନ୍ତ ଏକ ମେଷ ନେଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଉତ୍ସର୍ଗ କର। ");
INSERT INTO ory_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହିବ, ‘ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ବଳିଦାନାର୍ଥେ ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ଏକ ଛାଗ ଓ ହୋମବଳି ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ ଓ ଏକ ମେଷବତ୍ସ ନେବ, ଦୁହେଁ ଏକ ବର୍ଷୀୟ ଓ ନିଖୁନ୍ତ ଥିବେ, ");
INSERT INTO ory_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ପୁଣି ମଙ୍ଗଳାର୍ଥକ ବଳି ନିମନ୍ତେ ଏକ ଗୋରୁ ଓ ଏକ ମେଷ, ପୁଣି ତୈଳ ମିଶ୍ରିତ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନେବ; ଯେହେତୁ ଆଜି ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କୁ ଦର୍ଶନ ଦେଉଅଛନ୍ତି।’” ");
INSERT INTO ory_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ତହୁଁ ମୋଶା ଯାହା ଆଜ୍ଞା କଲେ, ତାହା ସେମାନେ ସମାଗମ-ତମ୍ବୁ ନିକଟକୁ ଆଣିଲେ, ପୁଣି ସମସ୍ତ ମଣ୍ଡଳୀ ନିକଟବର୍ତ୍ତୀ ହୋଇ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଠିଆ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ଆଉ ମୋଶା କହିଲେ, “ଏହି କଥା କରିବାକୁ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କୁ ଆଜ୍ଞା ଦେଲେ; ଏହା କଲେ, ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର ପ୍ରତାପ ପ୍ରକାଶ ପାଇବ।” ");
INSERT INTO ory_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ତହୁଁ ମୋଶା ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ବେଦି ନିକଟକୁ ଯାଇ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଆପଣାର ପାପାର୍ଥକ ବଳି ଓ ଆପଣା ହୋମବଳି ଉତ୍ସର୍ଗ କର, ପୁଣି ଆପଣା ନିମନ୍ତେ ଓ ଲୋକମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କର; ତହିଁ ଉତ୍ତାରେ ଲୋକମାନଙ୍କର ଉପହାର ଉତ୍ସର୍ଗ କରି ସେମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କର।” ");
INSERT INTO ory_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ତହିଁରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ହାରୋଣ ବେଦି ନିକଟକୁ ଯାଇ ଆପଣା ପାପାର୍ଥକ ବଳିର ଗୋବତ୍ସ ବଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ତହୁଁ ହାରୋଣଙ୍କର ପୁତ୍ରଗଣ ତାଙ୍କ ନିକଟକୁ ରକ୍ତ ଆଣିଲେ; ତହିଁରେ ସେ ଆପଣା ଅଙ୍ଗୁଳି ରକ୍ତରେ ଡୁବାଇ ବେଦିର ଶୃଙ୍ଗ ଉପରେ ଦେଲେ ଓ ଅବଶିଷ୍ଟ ରକ୍ତ ବେଦି ମୂଳରେ ଢାଳିଲେ; ");
INSERT INTO ory_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ମାତ୍ର ପାପାର୍ଥକ ବଳିର ମେଦ, ଗୁର୍ଦା ଓ ଯକୃତର ଅନ୍ତପ୍ଲାବକ ବେଦି ଉପରେ ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ପୁଣି, ମାଂସ ଓ ଚର୍ମ ଛାଉଣିର ବାହାରେ ଅଗ୍ନିରେ ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ଏଥିଉତ୍ତାରେ ହାରୋଣ ହୋମାର୍ଥକ ବଳି ବଧ କଲେ; ପୁଣି ତାହାଙ୍କର ପୁତ୍ରଗଣ ତାଙ୍କ ନିକଟକୁ ରକ୍ତ ଆଣନ୍ତେ, ସେ ବେଦି ଉପରେ ଚାରିଆଡ଼େ ତାହା ସେଚନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ଏଥିଉତ୍ତାରେ ସେମାନେ ତାଙ୍କ ନିକଟରେ ହୋମବଳିର ଖଣ୍ଡକୁ ଖଣ୍ଡ ମାଂସ ସହିତ ମସ୍ତକ ସମର୍ପଣ କଲେ; ତହିଁରେ ସେହି ସମସ୍ତ ସେ ବେଦି ଉପରେ ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ପୁଣି, ସେ ଅନ୍ତ ଓ ପାଦ ଧୌତ କରି ହୋମଦ୍ରବ୍ୟ ସହିତ ବେଦି ଉପରେ ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ଏଥିଉତ୍ତାରେ ସେ ଲୋକମାନଙ୍କର ଉପହାର ନିକଟକୁ ଆଣିଲେ, ପୁଣି ଲୋକମାନଙ୍କ ପାପାର୍ଥକ ଛାଗ ନେଇ ପ୍ରଥମଟିର ତୁଲ୍ୟ ବଧ କରି ପାପାର୍ଥେ ତାହା ଉତ୍ସର୍ଗ କଲେ; ");
INSERT INTO ory_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ଏଥିଉତ୍ତାରେ ସେ ହୋମବଳି ଆଣି ବିଧି ଅନୁସାରେ ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ଆଉ, ସେ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଆଣି ତହିଁରୁ ମୁଠାଏ ନେଇ ପ୍ରଭାତର ହୋମବଳି ସହିତ ବେଦି ଉପରେ ତାହା ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ମଧ୍ୟ ସେ ଲୋକମାନଙ୍କର ମଙ୍ଗଳାର୍ଥକ ବଳିର ଗୋରୁ ଓ ମେଷ ବଧ କଲେ; ପୁଣି, ହାରୋଣଙ୍କର ପୁତ୍ରଗଣ ତାଙ୍କ ନିକଟରେ ରକ୍ତ ସମର୍ପଣ କରନ୍ତେ, ସେ ବେଦି ଉପରେ ଚାରିଆଡ଼େ ତାହା ସେଚନ କଲେ; ");
INSERT INTO ory_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ପୁଣି ଗୋରୁର ମେଦ, ମେଷର ମେଦମୟ ଲାଙ୍ଗୁଳ, ଆଉ ଅନ୍ତ, ଗୁର୍ଦାର ଉପରିସ୍ଥ ମେଦ ଓ ଯକୃତର ଉପରିସ୍ଥ ଅନ୍ତପ୍ଲାବକ, ");
INSERT INTO ory_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ଏହି ସମସ୍ତ ମେଦ ସେମାନେ ବକ୍ଷ ଉପରେ ରଖିଲେ, ପୁଣି, ସେ ବେଦି ଉପରେ ମେଦ ଦଗ୍ଧ କଲେ; ");
INSERT INTO ory_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ପୁଣି, ମୋଶାଙ୍କର ଆଜ୍ଞାନୁସାରେ ହାରୋଣ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ବକ୍ଷ ଓ ଡାହାଣ ଜଙ୍ଘ ଦୋଳନୀୟ ନୈବେଦ୍ୟ ରୂପେ ଦୋଳାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ତହୁଁ ହାରୋଣ ଲୋକମାନଙ୍କ ପ୍ରତି ଆପଣା ହସ୍ତ ବିସ୍ତାର କରି ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ; ଏହିରୂପେ ପାପାର୍ଥକ ବଳି ଓ ହୋମବଳି ଓ ମଙ୍ଗଳାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରି ଓହ୍ଲାଇ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ଏଥିଉତ୍ତାରେ ମୋଶା ଓ ହାରୋଣ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କଲେ; ପୁଣି, ବାହାରେ ଆସି ଲୋକମାନଙ୍କୁ ଆଶୀର୍ବାଦ କଲେ; ସେତେବେଳେ ସମସ୍ତ ଲୋକଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର ପ୍ରତାପ ପ୍ରକାଶ ପାଇଲା। ");
INSERT INTO ory_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରୁ ଅଗ୍ନି ନିର୍ଗତ ହୋଇ ବେଦି ଉପରିସ୍ଥ ହୋମବଳି ଓ ମେଦ ଭସ୍ମ କଲା, ପୁଣି, ସମସ୍ତ ଲୋକେ ତାହା ଦେଖି ଉଚ୍ଚଧ୍ୱନି କରି ମୁହଁ ମାଡ଼ି ହୋଇ ପଡ଼ିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ଏଥିଉତ୍ତାରେ ହାରୋଣଙ୍କର ପୁତ୍ର ନାଦବ୍‍ ଓ ଅବୀହୂ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ଅଙ୍ଗାରଧାନୀ ନେଇ ତହିଁରେ ଅଗ୍ନି ଦେଇ ତହିଁ ଉପରେ ଧୂପ ରଖିଲେ; ପୁଣି ସଦାପ୍ରଭୁ ଯାହା ଆଜ୍ଞା କରି ନ ଥିଲେ, ଏପରି ଭିନ୍ନ ଇତର ଅଗ୍ନି ତାହାଙ୍କ ଛାମୁରେ ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ତହିଁରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରୁ ଅଗ୍ନି ନିର୍ଗତ ହୋଇ ସେମାନଙ୍କୁ ଗ୍ରାସ କଲା ଓ ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ତହୁଁ ମୋଶା ହାରୋଣଙ୍କୁ କହିଲେ, “ସଦାପ୍ରଭୁ ଏହି କଥା କହିଲେ, ‘ଯେଉଁମାନେ ଆମ୍ଭ ନିକଟକୁ ଆସନ୍ତି, ସେମାନଙ୍କ ମଧ୍ୟରେ ଆମ୍ଭେ ପବିତ୍ର ରୂପେ ମାନ୍ୟ ହେବା; ଓ ସମସ୍ତ ଲୋକଙ୍କ ସମ୍ମୁଖରେ ଆମ୍ଭେ ଗୌରବାନ୍ୱିତ ହେବା।’” ତହିଁରେ ହାରୋଣ ମୌନ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ଏଥିଉତ୍ତାରେ ମୋଶା ହାରୋଣଙ୍କର କକା ଉଷୀୟେଲର ପୁତ୍ର ମୀଶାୟେଲକୁ ଓ ଇଲୀଷାଫନ୍‍କୁ ଡାକି କହିଲେ, “ନିକଟକୁ ଆସି ଆପଣା ଭାଇମାନଙ୍କୁ ପବିତ୍ର ସ୍ଥାନର ସମ୍ମୁଖରୁ ଛାଉଣିର ବାହାରକୁ ନେଇଯାଅ।” ");
INSERT INTO ory_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ତହିଁରେ ସେମାନେ ମୋଶାଙ୍କର ବାକ୍ୟାନୁସାରେ ନିକଟକୁ ଯାଇ ସେମାନଙ୍କୁ ପୋଷାକ ସମେତ ଛାଉଣିର ବାହାରକୁ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ପୁଣି, ମୋଶା ହାରୋଣଙ୍କୁ, ତାଙ୍କର ପୁତ୍ର ଇଲୀୟାସର ଓ ଈଥାମରକୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଯେପରି ନ ମର ଓ ସମସ୍ତ ମଣ୍ଡଳୀ ପ୍ରତି ସଦାପ୍ରଭୁ ଯେପରି କ୍ରୋଧ ନ କରନ୍ତି, ଏଥିପାଇଁ ତୁମ୍ଭମାନଙ୍କ ମସ୍ତକର କେଶ ମୁକୁଳା ନ ହେଉ, କିଅବା ଆପଣା ଆପଣା ବସ୍ତ୍ର ଚିର ନାହିଁ; ମାତ୍ର ସଦାପ୍ରଭୁ ଯେଉଁ ଅଗ୍ନିଦାହ ପ୍ରଜ୍ୱଳିତ କରିଅଛନ୍ତି, ତହିଁ ସକାଶୁ ତୁମ୍ଭମାନଙ୍କର ଭ୍ରାତୃବର୍ଗ ସମୁଦାୟ ଇସ୍ରାଏଲ ବଂଶ ରୋଦନ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ଆଉ ତୁମ୍ଭେମାନେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାରରୁ ବାହାରକୁ ଯିବ ନାହିଁ, ଗଲେ ମରିବ। କାରଣ ତୁମ୍ଭମାନଙ୍କ ଦେହରେ ସଦାପ୍ରଭୁଙ୍କର ଅଭିଷେକ ତୈଳ ଅଛି।” ତହିଁରେ ସେମାନେ ମୋଶାଙ୍କର ବାକ୍ୟାନୁସାରେ ସେହିପରି କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ତୁମ୍ଭମାନଙ୍କର ମୃତ୍ୟୁୁ ଯେପରି ନ ହୁଏ, ଏଥିପାଇଁ ଯେଉଁ ସମୟରେ ତୁମ୍ଭେମାନେ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କରିବ, ସେହି ସମୟରେ ତୁମ୍ଭେ କି ତୁମ୍ଭ ସଙ୍ଗୀ ତୁମ୍ଭର ପୁତ୍ରଗଣ ଦ୍ରାକ୍ଷାରସ ଓ ମଦ୍ୟ ପାନ କରିବ ନାହିଁ; ଏହା ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ; ");
INSERT INTO ory_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ତହିଁରେ ତୁମ୍ଭେମାନେ ପବିତ୍ର ଓ ସାମାନ୍ୟ, ପୁଣି ଶୁଚି ଓ ଅଶୁଚି ମଧ୍ୟରେ ଭିନ୍ନତା ଜାଣି ପାରିବ; ");
INSERT INTO ory_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ପୁଣି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ଦ୍ୱାରା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଯେଉଁ ସକଳ ବିଧି ଦେଇଅଛନ୍ତି, ତାହା ସେମାନଙ୍କୁ ଶିକ୍ଷା ଦେଇ ପାରିବ।” ");
INSERT INTO ory_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ଏଥିଉତ୍ତାରେ ମୋଶା ହାରୋଣଙ୍କୁ, ତାଙ୍କର ଅବଶିଷ୍ଟ ପୁତ୍ର ଇଲୀୟାସର ଓ ଈଥାମରଙ୍କୁ କହିଲେ, “ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାରର ଅବଶିଷ୍ଟ ଯେଉଁ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ତାହା ତୁମ୍ଭେମାନେ ନେଇ ବେଦି ନିକଟରେ ତାଡ଼ି ବିନା ଭୋଜନ କର, ଯେହେତୁ ତାହା ମହାପବିତ୍ର; ");
INSERT INTO ory_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ଏଣୁ ତୁମ୍ଭେମାନେ କୌଣସି ପବିତ୍ର ସ୍ଥାନରେ ତାହା ଭୋଜନ କର; କାରଣ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ମଧ୍ୟରୁ ତାହା ହିଁ ତୁମ୍ଭର ଓ ତୁମ୍ଭ ପୁତ୍ରଗଣଙ୍କର ପ୍ରାପ୍ତବ୍ୟ ଅଂଶ; ଯେହେତୁ ଆମ୍ଭେ ଏହି ଆଜ୍ଞା ପାଇଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ପୁଣି ତୁମ୍ଭେ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭ ପୁତ୍ରଗଣ ଓ ତୁମ୍ଭ କନ୍ୟାଗଣ ଦୋଳନୀୟ ନୈବେଦ୍ୟର ବକ୍ଷ ଓ ଉତ୍ତୋଳନୀୟ ଉପହାରର ଜଙ୍ଘ କୌଣସି ଶୁଚି ସ୍ଥାନରେ ଭୋଜନ କରିବ, ଯେହେତୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ମଙ୍ଗଳାର୍ଥକ ବଳି ମଧ୍ୟରୁ ତାହା ତୁମ୍ଭର ଓ ତୁମ୍ଭ ସନ୍ତାନଗଣର ପ୍ରାପ୍ତବ୍ୟ ଅଂଶ। ");
INSERT INTO ory_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ସେମାନେ ମେଦମୟ ଅଗ୍ନିକୃତ ଉପହାର ସହିତ ଉତ୍ତୋଳନୀୟ ଉପହାରର ଜଙ୍ଘ ଓ ଦୋଳନୀୟ ନୈବେଦ୍ୟର ବକ୍ଷ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳାଇବା ନିମନ୍ତେ ଆଣିବେ; ପୁଣି ତାହା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ତୁମ୍ଭର ଓ ତୁମ୍ଭ ସନ୍ତାନଗଣଙ୍କର ଅନନ୍ତକାଳୀନ ଅଧିକାର ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ଆଉ, ମୋଶା ପାପାର୍ଥକ ଛାଗର ବହୁତ ଅନ୍ୱେଷଣ କଲେ, ମାତ୍ର ଦେଖ, ତାହା ଦଗ୍ଧ ହୋଇଥିଲା; ଏଣୁ ସେ ହାରୋଣଙ୍କର ଅବଶିଷ୍ଟ ଦୁଇ ପୁତ୍ର ଇଲୀୟାସର ଓ ଈଥାମରଙ୍କ ପ୍ରତି କ୍ରୋଧ କରି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ତୁମ୍ଭେମାନେ କାହିଁକି ପବିତ୍ର ସ୍ଥାନରେ ସେହି ପାପାର୍ଥକ ବଳି ଭୋଜନ କଲ ନାହିଁ? ତାହା ତ ମହାପବିତ୍ର, ପୁଣି ମଣ୍ଡଳୀର ଅପରାଧ ବୋହି ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ନିମନ୍ତେ ସେ ତାହା ତୁମ୍ଭମାନଙ୍କୁ ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ଦେଖ, ପବିତ୍ର ସ୍ଥାନ ଭିତରକୁ ତାହାର ରକ୍ତ ଅଣାଗଲା ନାହିଁ; ଯେପରି ଆମ୍ଭେ ଆଜ୍ଞା ଦେଇଥିଲୁ, ସେପରି ତୁମ୍ଭେମାନେ ପବିତ୍ର ସ୍ଥାନରେ ତାହା ତ ଭୋଜନ କରିଥାʼନ୍ତ।” ");
INSERT INTO ory_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ତେବେ ହାରୋଣ ମୋଶାଙ୍କୁ କହିଲେ, “ଦେଖ, ସେମାନେ ଆଜି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆପଣାମାନଙ୍କର ପାପାର୍ଥକ ବଳି ଓ ଆପଣାମାନଙ୍କର ହୋମାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କଲେ, ତଥାପି ମୋʼ ପ୍ରତି ଏପରି ଘଟିଲା; ଯେବେ ମୁଁ ଆଜି ପାପାର୍ଥକ ବଳି ଭୋଜନ କରିଥାʼନ୍ତି, ତେବେ ତାହା କି ସଦାପ୍ରଭୁଙ୍କ ଦୃଷ୍ଟିରେ ଭଲ ହୋଇଥାʼନ୍ତା?” ");
INSERT INTO ory_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ତହୁଁ ମୋଶା ତାହା ଶୁଣନ୍ତେ, ତାହା ତାଙ୍କ ଦୃଷ୍ଟିରେ ଭଲ ଦେଖାଗଲା। ");
INSERT INTO ory_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ତାʼପରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ତୁମ୍ଭେମାନେ ପୃଥିବୀସ୍ଥିତ ପଶୁମାନଙ୍କ ମଧ୍ୟରେ ଏହି ସମସ୍ତ ଜୀବ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ପଶୁମାନଙ୍କ ମଧ୍ୟରେ ଯାହାର ଖୁରା ବିଭକ୍ତ ଓ ପାଦ ଚିରା ଓ ଯେ ପାକୁଳି କରେ, ତାହାକୁ ତୁମ୍ଭେମାନେ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ତଥାପି ଯେଉଁମାନେ ପାକୁଳି କରନ୍ତି, ଅଥବା ବିଭକ୍ତ ଖୁରାବିଶିଷ୍ଟ ଅଟନ୍ତି, ସେମାନଙ୍କ ମଧ୍ୟରୁ ଏହି ଏହି ପଶୁ ଭୋଜନ କରିବ ନାହିଁ, ଯଥା, ଓଟ, ଯେହେତୁ ସେ ପାକୁଳି କରେ, ମାତ୍ର ବିଭକ୍ତ ଖୁରାବିଶିଷ୍ଟ ନୁହେଁ, ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ପୁଣି ଶାଫନ୍‍ (ଓଧ) ପଶୁ, ଯେହେତୁ ସେ ପାକୁଳି କରେ, ମାତ୍ର ବିଭକ୍ତ ଖୁରାବିଶିଷ୍ଟ ନୁହେଁ, ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ଆଉ, ଠେକୁଆ, ଯେହେତୁ ସେ ପାକୁଳି କରେ, ମାତ୍ର ବିଭକ୍ତ ଖୁରାବିଶିଷ୍ଟ ନୁହେଁ, ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ପୁଣି, ଶୂକର, ଯେହେତୁ ସେ ବିଭକ୍ତ-ଖୁରା ଓ ଚିରାପାଦବିଶିଷ୍ଟ, ମାତ୍ର ପାକୁଳି କରେ ନାହିଁ, ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ତୁମ୍ଭେମାନେ ସେମାନଙ୍କର ମାଂସ ଭୋଜନ କରିବ ନାହିଁ ଓ ସେମାନଙ୍କର ଶବ ସ୍ପର୍ଶ କରିବ ନାହିଁ, ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","ଜଳଜନ୍ତୁ ମଧ୍ୟରୁ ଏହିସବୁ ତୁମ୍ଭେମାନେ ଭୋଜନ କରିବ; ଜଳରେ, ସମୁଦ୍ରରେ ଓ ନଦୀରେ ସ୍ଥିତ ଜନ୍ତୁ ମଧ୍ୟରେ ଯାହାର ଡେଣା ଓ କାତି ଅଛି, ତାହା ତୁମ୍ଭେମାନେ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ମାତ୍ର ସମୁଦ୍ରରେ ଓ ନଦୀରେ ସ୍ଥିତ ସମସ୍ତ ଜଳଚର, ଅବା ଜଳସ୍ଥିତ ପ୍ରାଣୀମାନଙ୍କ ମଧ୍ୟରେ ଯେଉଁମାନଙ୍କର ଡେଣା ଓ କାତି ନାହିଁ, ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଘୃଣାଯୋଗ୍ୟ ଅଟନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ଆଉ, ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଘୃଣାଯୋଗ୍ୟ ହେବେ; ତୁମ୍ଭେମାନେ ସେମାନଙ୍କର ମାଂସ ଭୋଜନ କରିବ ନାହିଁ, ପୁଣି ସେମାନଙ୍କ ଶବକୁ ଘୃଣା କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ଜଳଜନ୍ତୁ ମଧ୍ୟରେ ଯେଉଁମାନଙ୍କର ଡେଣା ଓ କାତି ନାହିଁ, ସେହି ସମସ୍ତ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଘୃଣାଯୋଗ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","ଆଉ, ପକ୍ଷୀମାନଙ୍କ ମଧ୍ୟରୁ ଏହିସବୁ ତୁମ୍ଭମାନଙ୍କର ଘୃଣାଯୋଗ୍ୟ ହେବେ; ସେମାନେ ଖାଦ୍ୟ ନୁହନ୍ତି; ଉତ୍କ୍ରୋଶ ଓ ହାଡ଼ଭଙ୍ଗା ଓ ବହୀରି, ");
INSERT INTO ory_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ପୁଣି, ଚିଲ ଓ ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ବାଜ, ");
INSERT INTO ory_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ପୁଣି, ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ସମସ୍ତ ଡାମରା କାଉ, ");
INSERT INTO ory_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ଓଟପକ୍ଷୀ, ତାମସ ପକ୍ଷୀ, ସମୁଦ୍ର ଚିଲ, ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ଛଞ୍ଚାଣ, ");
INSERT INTO ory_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ପୁଣି, କୋଷପକ୍ଷୀ, ପାଣିକୁଆ, ବଗ, ");
INSERT INTO ory_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ଦୀର୍ଘ-ଗଳ ହଂସ, ପାଣିଭେଳା, ଶାଗୁଣା; ");
INSERT INTO ory_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ପୁଣି ବଗ, ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ କଙ୍କ, ଟିଟ୍ଟିଭ ଓ ଚାମଚିକା। ");
INSERT INTO ory_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","ପୁଣି, ଚାରି ପାଦରେ ଗମନକାରୀ ପକ୍ଷବିଶିଷ୍ଟ ଜନ୍ତୁସକଳ ତୁମ୍ଭମାନଙ୍କର ଘୃଣାଯୋଗ୍ୟ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ତଥାପି ଚାରି ପାଦରେ ଗମନକାରୀ ପକ୍ଷବିଶିଷ୍ଟ ଜନ୍ତୁ ମଧ୍ୟରେ ଭୂମିରେ ଡେଇଁବା ପାଇଁ ଯେଉଁମାନଙ୍କର ଗୋଡ଼ନଳୀ ଦୀର୍ଘ, ସେମାନେ ତୁମ୍ଭମାନଙ୍କର ଖାଦ୍ୟ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ଅର୍ଥାତ୍‍, ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ପଙ୍ଗପାଳ, ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ବାଘୁଆଫଡ଼ିଙ୍ଗ, ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ଝିଙ୍କାରୀ ଓ ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ଝିଣ୍ଟିକା, ଏହି ସକଳ ତୁମ୍ଭମାନଙ୍କର ଖାଦ୍ୟ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ମାତ୍ର ଏହାଛଡ଼ା ଚାରିଗୋଡ଼ିଆ ଉଡ଼ନ୍ତା ସମସ୍ତ ପତଙ୍ଗ ତୁମ୍ଭମାନଙ୍କର ଘୃଣାଯୋଗ୍ୟ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","ଆଉ, ଏମାନଙ୍କ ଦ୍ୱାରା ତୁମ୍ଭେମାନେ ଅଶୁଚି ହେବ; ଯେକେହି ସେମାନଙ୍କର ଶବ ଛୁଇଁବ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ପୁଣି, ଯେକେହି ସେମାନଙ୍କ ଶବର କୌଣସି ଅଂଶ ବହିବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ଯେଉଁସବୁ ପଶୁର ଖୁରା ବିଭକ୍ତ, ମାତ୍ର ପାଦ ଚିରା ନୁହେଁ, କିଅବା ଯେଉଁମାନେ ପାକୁଳି କରନ୍ତି ନାହିଁ, ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ନିକଟରେ ଅଶୁଚି; ଯେକେହି ସେମାନଙ୍କୁ ଛୁଇଁବ, ସେ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ପୁଣି ଚାରିଗୋଡ଼ିଆ ବନ୍ୟଜନ୍ତୁମାନଙ୍କ ମଧ୍ୟରେ ଯେଉଁମାନେ ତଳିପାରେ ଚାଲନ୍ତି, ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି; ଯେକେହି ସେମାନଙ୍କର ଶବ ଛୁଇଁବ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ପୁଣି, ଯେକେହି ସେମାନଙ୍କର ଶବ ବହିବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ; ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","ଆଉ, ଭୂଚର ଉରୋଗାମୀ ଜନ୍ତୁମାନଙ୍କ ମଧ୍ୟରେ ଏହିସବୁ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି ହେବେ; ଖୋଲେଦ (ଗୋଧି) ଓ ମୂଷା; ପୁଣି, ଆପଣା ଆପଣା ଜାତି ଅନୁସାରେ ବଡ଼ ଏଣ୍ଡୁଅ; ");
INSERT INTO ory_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ଆଉ, ଏଣ୍ଡୁଅ ଓ ସ୍ଥଳ କୁମ୍ଭୀର, ଝିଟିପିଟି, ବାଲିଏଣ୍ଡୁଅ ଓ ବହୁରୂପୀ (ପୋହଳା ଏଣ୍ଡୁଅ)। ");
INSERT INTO ory_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ଉରୋଗାମୀ ଜନ୍ତୁମାନଙ୍କ ମଧ୍ୟରେ ଏହି ସମସ୍ତ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି ହେବେ; ସେମାନେ ମଲେ ଯେକେହି ସେମାନଙ୍କୁ ଛୁଇଁବ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ସେମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି ଶବ କୌଣସି ଦ୍ରବ୍ୟ ଉପରେ ପଡ଼ିଲେ, ତାହା ଅଶୁଚି ହେବ; କାଠ ପାତ୍ର, ବସ୍ତ୍ର, ଚର୍ମ କି ଅଖା, ଯେକୌଣସି କର୍ମଯୋଗ୍ୟ ପାତ୍ର ଉପରେ ପଡ଼ିଲେ, ତାହା ଜଳରେ ଡୁବାଯିବ, ଆଉ ତାହା ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ; ତହିଁ ଉତ୍ତାରେ ତାହା ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ପୁଣି, କୌଣସି ମାଟି ପାତ୍ର ମଧ୍ୟରେ ସେମାନଙ୍କର ଶବ ପଡ଼ିଲେ, ତହିଁ ମଧ୍ୟସ୍ଥିତ ସମସ୍ତ ଦ୍ରବ୍ୟ ଅଶୁଚି ହେବ ଓ ତୁମ୍ଭେମାନେ ତାହା ଭାଙ୍ଗି ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ପୁଣି, ଯେଉଁସବୁ ଖାଦ୍ୟଦ୍ରବ୍ୟ ଉପରେ ଜଳ ଥାଏ, ତାହା ଅଶୁଚି ହେବ; ପୁଣି, ସର୍ବପ୍ରକାର ପାତ୍ରରେ ସର୍ବପ୍ରକାର ପେୟଦ୍ରବ୍ୟ ଅଶୁଚି ହେବ; ");
INSERT INTO ory_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ପୁଣି, ଯେକୌଣସି ଦ୍ରବ୍ୟ ଉପରେ ସେମାନଙ୍କ ଶବର କିଛି ପଡ଼େ, ତାହା ଅଶୁଚି ହେବ; ତନ୍ଦୁର ହେଉ କି ଚୁଲି ହେଉ, ତାହା ଭଙ୍ଗାଯିବ; ତାହା ଅଶୁଚି ଅଟେ ଓ ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ତଥାପି ନିର୍ଝର କିଅବା ଯେଉଁ କୂପରେ ଅନେକ ଜଳ ଥାଏ, ତାହା ଶୁଚି ହେବ; ମାତ୍ର ଯେ ସେମାନଙ୍କର ଶବ ଛୁଇଁବ, ସେ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ପୁଣି, ଯେଉଁ ବିହନ ବୁଣା ଯିବାକୁ ଅଛି, ତହିଁ ଉପରେ ଯେବେ ସେମାନଙ୍କ ଶବର କିଛି ପଡ଼େ, ତେବେ ତାହା ଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ମାତ୍ର ବିହନ ଉପରେ ଜଳ ଥିଲେ, ଯେବେ ସେମାନଙ୍କ ଶବର କିଛି ତହିଁ ଉପରେ ପଡ଼େ, ତେବେ ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ଆଉ, ତୁମ୍ଭମାନଙ୍କର ଖାଦ୍ୟ ଯୋଗ୍ୟ କୌଣସି ପଶୁ ମଲେ, ଯେକେହି ତାହାର ଶବ ଛୁଇଁବ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ପୁଣି, ଯେକେହି ତାହାର ଶବ ଖାଏ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ, ପୁଣି ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ; ଆଉ, ଯେକେହି ତାହା ବହେ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","ଆଉ, ଭୂଚର ପ୍ରତ୍ୟେକ ଉରୋଗାମୀ ଜନ୍ତୁ ଘୃଣାଯୋଗ୍ୟ ଅଟେ; ତାହା ଖାଦ୍ୟ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ଯେଉଁମାନେ ପେଟ ଦେଇ ଗମନ କରନ୍ତି ଓ ଯେଉଁମାନେ ଚାରି ପାଦରେ ଗମନ କରନ୍ତି, ଅବା ଯେଉଁମାନଙ୍କର ଅନେକ ପାଦ ଅଛି, ଏପରି ସମସ୍ତ ଭୂଚର ଉରୋଗାମୀ ଜନ୍ତୁକୁ ତୁମ୍ଭେମାନେ ଖାଇବ ନାହିଁ; କାରଣ ସେମାନେ ଘୃଣାଯୋଗ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ତୁମ୍ଭେମାନେ ଏହିସବୁ ଭୂଚର ଉରୋଗାମୀ ଜନ୍ତୁ ଦ୍ୱାରା ଆପଣାମାନଙ୍କୁ ଘୃଣାଯୋଗ୍ୟ କରିବ ନାହିଁ, କିଅବା ତୁମ୍ଭେମାନେ ଅଶୁଚି ହେବା ନିମନ୍ତେ ସେମାନଙ୍କ ଦ୍ୱାରା ଆପଣାମାନଙ୍କୁ ଅଶୁଚି କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","କାରଣ ମୁଁ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟେ; ଏହେତୁ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କୁ ପବିତ୍ର କର ଓ ତୁମ୍ଭେମାନେ ପବିତ୍ର ହୁଅ; ଯେହେତୁ ମୁଁ ପବିତ୍ର; ତୁମ୍ଭେମାନେ ଭୂମିରେ ଗମନକାରୀ କୌଣସି ଉରୋଗାମୀ ଜୀବ ଦ୍ୱାରା ଆପଣାମାନଙ୍କୁ ଅଶୁଚି କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","କାରଣ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ହେବା ନିମନ୍ତେ ମୁଁ ସଦାପ୍ରଭୁ ମିସର ଦେଶରୁ ତୁମ୍ଭମାନଙ୍କୁ ବାହାର କରି ଆଣିଅଛି; ଏନିମନ୍ତେ ତୁମ୍ଭେମାନେ ପବିତ୍ର ହେବ, କାରଣ ମୁଁ ପବିତ୍ର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ଶୁଚି ଓ ଅଶୁଚି ଏବଂ ଖାଦ୍ୟ ଓ ଅଖାଦ୍ୟ ପଶୁମାନଙ୍କ ପ୍ରଭେଦ ଜଣାଇବା ପାଇଁ, ");
INSERT INTO ory_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ପଶୁ, ପକ୍ଷୀ, ଜଳଚର ପ୍ରାଣୀ ଓ ଉରୋଗାମୀ ଭୂଚର ପ୍ରାଣୀମାନଙ୍କ ବିଷୟରେ ଏହି ବ୍ୟବସ୍ଥା।” ");
INSERT INTO ory_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଯଦି କୌଣସି ସ୍ତ୍ରୀ ଗର୍ଭଧାରଣ କରି ପୁତ୍ର ପ୍ରସବ କରେ, ତେବେ ସ୍ତ୍ରୀର ରଜଧର୍ମର ଅଶୁଚିତା ସମୟ ପରି ସେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ତହୁଁ ଅଷ୍ଟମ ଦିନରେ ବାଳକର ପୁରୁଷାଙ୍ଗଚର୍ମର ଛେଦନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ପୁଣି ସେହି ସ୍ତ୍ରୀ ତେତିଶ ଦିନ ପର୍ଯ୍ୟନ୍ତ ଆପଣାର ଶୁଚି ନିମନ୍ତେ ରକ୍ତସ୍ରାବ ଅବସ୍ଥାରେ ରହିବ; ଆଉ ଯେପର୍ଯ୍ୟନ୍ତ ଶୁଚିର ଦିନ ପୂର୍ଣ୍ଣ ନ ହୁଏ, ସେପର୍ଯ୍ୟନ୍ତ ସେହି କୌଣସି ପବିତ୍ର ବସ୍ତୁ ଛୁଇଁବ ନାହିଁ; କିଅବା ପବିତ୍ର ସ୍ଥାନରେ ପ୍ରବେଶ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ମାତ୍ର ଯଦି ସେ କନ୍ୟା ପ୍ରସବ କରେ, ତେବେ ସ୍ତ୍ରୀର ରଜଧର୍ମର ଅଶୁଚିତା ସମୟ ପରି ସେ ଦୁଇ ସପ୍ତାହ ଅଶୁଚି ରହିବ; ପୁଣି ସେ ଛଷଠି ଦିନ ଆପଣା ଶୁଚି ନିମନ୍ତେ ରକ୍ତସ୍ରାବ ଅବସ୍ଥାରେ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","ତହିଁ ଉତ୍ତାରେ ପୁତ୍ର ବା କନ୍ୟା ପ୍ରସବର ଅଶୁଚି ଦିନ ପୂର୍ଣ୍ଣ ହେଲେ, ସେ ହୋମବଳି ନିମନ୍ତେ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ ଓ ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ଏକ ପାରାଛୁଆ ବା ଏକ କପୋତ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାରର ଯାଜକ ନିକଟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ତହୁଁ ସେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାହା ଉତ୍ସର୍ଗ କରି ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ ଆପଣା ରକ୍ତସ୍ରାବରୁ ଶୁଚି ହେବ; ପୁତ୍ର ବା କନ୍ୟା ପ୍ରସବକାରିଣୀ ନିମନ୍ତେ ଏହି ବ୍ୟବସ୍ଥା। ");
INSERT INTO ory_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ମାତ୍ର ଯଦି ସେ ମେଷବତ୍ସ ଆଣିବାକୁ ଅସମର୍ଥ ହୁଏ, ତେବେ ସେ ଦୁଇ କପୋତ ଅବା ଦୁଇ ପାରାଛୁଆ ନେଇ, ତହିଁରୁ ଗୋଟିଏକୁ ହୋମାର୍ଥକ ବଳି ରୂପେ ଓ ଅନ୍ୟଟିକୁ ପାପାର୍ଥକ ବଳି ରୂପେ ଉତ୍ସର୍ଗ କରିବ; ପୁଣି ଯାଜକ ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ, ତହିଁରେ ସେ ଶୁଚି ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ତାʼପରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ଯଦି କୌଣସି ମନୁଷ୍ୟର ଶରୀରର ଚର୍ମରେ ଫୁଲା କି କାଛୁକୁଣ୍ଡିଆ କି ଚିକ୍କଣ ଚିହ୍ନ ହୁଏ ଓ ତାହା ଶରୀରର ଚର୍ମରେ କୁଷ୍ଠରୋଗର ଘାʼ ହୁଏ, ତେବେ ସେ ହାରୋଣ ଯାଜକ ନିକଟକୁ କିଅବା ତାହାର ପୁତ୍ରଗଣଙ୍କ ମଧ୍ୟରେ କୌଣସି ଯାଜକ ନିକଟକୁ ଅଣାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ତହୁଁ ଯାଜକ ତାହା ଶରୀରର ଚର୍ମସ୍ଥିତ ଘାʼ ଦେଖିବ; ଆଉ ଯଦି ଘାʼର ଲୋମ ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇଥାଏ, ପୁଣି ଘାʼ ଯଦି ତାହା ଶରୀରର ଚର୍ମଠାରୁ ନୀଚ ଦେଖାଯାଏ, ତେବେ ତାହା କୁଷ୍ଠରୋଗର ଘାʼ ଅଟେ; ଆଉ ଯାଜକ ତାହାକୁ ଦେଖିବ ଓ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ପୁଣି, ଚିକ୍କଣ ଚିହ୍ନ ଯଦି ତାହା ଶରୀରର ଚର୍ମରେ ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇଥାଏ ଓ ତାହା ଚର୍ମଠାରୁ ନୀଚ ନ ଥାଏ ଓ ତାହାର ଲୋମ ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇ ନ ଥାଏ, ତେବେ ଯାହାର ଘାʼ ହୋଇଅଛି, ଯାଜକ ତାହାକୁ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପୃଥକ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ତହୁଁ ସପ୍ତମ ଦିନରେ ଯାଜକ ତାହାକୁ ଦେଖିବ; ପୁଣି, ଯଦି ତାହାର ଦୃଷ୍ଟିରେ ସେହି ଘାʼ ସେହି ପ୍ରକାର ଥାଏ ଓ ଚର୍ମରେ ବ୍ୟାପି ନ ଥାଏ, ତେବେ ଯାଜକ ତାହାକୁ ଆହୁରି ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ବନ୍ଦ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ପୁଣି, ସପ୍ତମ ଦିନରେ ଯାଜକ ତାହାକୁ ପୁନର୍ବାର ଦେଖିବ; ଆଉ, ଯଦି ଘାʼ ମଳିନ ହୋଇଥାଏ ଓ ଘାʼ ଚର୍ମରେ ବ୍ୟାପି ନ ଥାଏ, ତେବେ ଯାଜକ ତାହାକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ତାହା କାଛୁକୁଣ୍ଡିଆ ଅଟେ; ତହୁଁ ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇ ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ମାତ୍ର ସେ ଶୁଚି ହେବା ନିମନ୍ତେ ଆପଣାକୁ ଯାଜକକୁ ଦେଖାଇଲା ଉତ୍ତାରେ ଯଦି ତାହାର କାଛୁକୁଣ୍ଡିଆ ଚର୍ମରେ ବ୍ୟାପେ, ତେବେ ସେ ଆପଣାକୁ ପୁନର୍ବାର ଯାଜକକୁ ଦେଖାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ତହିଁରେ କାଛୁକୁଣ୍ଡିଆ ତାହାର ଚର୍ମରେ ବ୍ୟାପିଲା, ଏପରି ଯଦି ଯାଜକ ଦେଖେ, ତେବେ ସେ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ, କାରଣ ତାହା କୁଷ୍ଠରୋଗ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","କୌଣସି ମନୁଷ୍ୟଠାରେ କୁଷ୍ଠରୋଗର ଘାʼ ହେଲେ, ସେ ଯାଜକ ନିକଟକୁ ଅଣାଯିବ; ");
INSERT INTO ory_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ତହୁଁ ଯାଜକ ତାହାକୁ ଦେଖିବ; ଆଉ, ଯଦି ତାହାର ଚର୍ମରେ ଶ୍ଵେତବର୍ଣ୍ଣ ଫୁଲା ଥାଏ ଓ ତହିଁର ଲୋମ ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇଥାଏ ଓ ସେହି ଫୁଲାରେ କଞ୍ଚା ମାଂସ ବୃଦ୍ଧି ପାଉଥାଏ, ");
INSERT INTO ory_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ତେବେ ତାହାର ଶରୀରର ଚର୍ମରେ ତାହା ପୁରାତନ କୁଷ୍ଠରୋଗ ଅଟେ, ପୁଣି ଯାଜକ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ସେ ତାହାକୁ ରୁଦ୍ଧ କରିବ ନାହିଁ, କାରଣ ସେ ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ଆଉ, ଯଦି କୁଷ୍ଠରୋଗ ଚର୍ମରେ ଫୁଟି ବାହାରେ ଓ ଯେତେ ଦୂର ଯାଜକକୁ ଦେଖାଯାଏ, ତଦନୁସାରେ ଘାʼଯୁକ୍ତ ଲୋକର ମସ୍ତକ ଠାରୁ ପାଦ ପର୍ଯ୍ୟନ୍ତ ଚର୍ମ କୁଷ୍ଠରୋଗରେ ଆଚ୍ଛନ୍ନ ହୋଇଥାଏ, ");
INSERT INTO ory_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ତେବେ ଯାଜକ ଦେଖିବ; ପୁଣି, ଯଦି କୁଷ୍ଠରୋଗ ତାହାର ସର୍ବାଙ୍ଗ ଆଚ୍ଛନ୍ନ କରିଥାଏ, ତେବେ ସେ ରୋଗୀକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ସର୍ବାଙ୍ଗ ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇଅଛି; ସେ ଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ମାତ୍ର ଯେତେବେଳେ କଞ୍ଚା ମାଂସ ତାହା ଦେହରେ ପ୍ରକାଶ ପାଏ, ସେତେବେଳେ ସେ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ଆଉ, ଯାଜକ ସେହି କଞ୍ଚା ମାଂସ ଦେଖି ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ସେହି କଞ୍ଚା ମାଂସ ଅଶୁଚି; ତାହା କୁଷ୍ଠରୋଗ। ");
INSERT INTO ory_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ଅଥବା ଯଦି ସେହି କଞ୍ଚା ମାଂସ ପୁନର୍ବାର ପାଲଟି ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇଯାଏ, ତେବେ ସେ ଯାଜକ ନିକଟକୁ ଯିବ, ");
INSERT INTO ory_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ଆଉ, ଯାଜକ ତାହାକୁ ଦେଖିବ; ପୁଣି ଦେଖ, ଯଦି ସେହି ଘାʼ ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇଥାଏ, ତେବେ ଯାଜକ ସେ ଘାʼଯୁକ୍ତ ଲୋକକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ସେ ଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ଆଉ ଶରୀରର ଚର୍ମରେ ବଥ ହୋଇ ଭଲ ହେଲା ଉତ୍ତାରେ, ");
INSERT INTO ory_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ଯଦି ସେହି ବଥ ସ୍ଥାନରେ ଶ୍ଵେତବର୍ଣ୍ଣ ଫୁଲା ଅବା ରକ୍ତ ଶ୍ଵେତବର୍ଣ୍ଣ ଚିକ୍କଣ ଚିହ୍ନ ହୁଏ, ତେବେ ତାହା ଯାଜକକୁ ଦେଖାଇବ; ");
INSERT INTO ory_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ତହିଁରେ ଯାଜକ ତାହା ଦେଖିବ, ଆଉ, ଯଦି ତାହା ଚର୍ମର ନୀଚସ୍ଥ ଦେଖାଯାଏ ଓ ତହିଁର ଲୋମ ଶ୍ଵେତବର୍ଣ୍ଣ ହୋଇଥାଏ, ତେବେ ଯାଜକ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ତାହା ବଥରୁ ଉତ୍ପନ୍ନ କୁଷ୍ଠରୋଗର ଘାʼ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ମାତ୍ର ଯାଜକ ତାହା ଦେଖନ୍ତେ, ଯଦି, ତହିଁରେ ଶ୍ଵେତବର୍ଣ୍ଣ ଲୋମ ନ ଥାଏ ଓ ତାହା ଚର୍ମର ନୀଚସ୍ଥ ନ ହୋଇ ମଳିନ ହୋଇଥାଏ, ତେବେ ଯାଜକ ତାହାକୁ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପୃଥକ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ଆଉ, ଯଦି ତାହା ଚର୍ମରେ ବ୍ୟାପେ, ତେବେ ଯାଜକ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; କାରଣ ତାହା କୁଷ୍ଠରୋଗର ଘାʼ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ମାତ୍ର ଯଦି ସେହି ଚିକ୍କଣ ଚିହ୍ନ ସ୍ୱ ସ୍ଥାନରେ ଥାଇ ନ ବଢ଼େ, ତେବେ ତାହା ବଥର ଚିହ୍ନ ଅଟେ; ପୁଣି ଯାଜକ ତାହାକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","କିଅବା ଯଦି ମାଂସର ଚର୍ମରେ ଅଗ୍ନିଦାହ ହୁଏ ଓ ସେହି ଦାହର ବଢ଼ିଲା ମାଂସରେ ରକ୍ତ ଶ୍ଵେତବର୍ଣ୍ଣ ଅବା ଶ୍ଵେତବର୍ଣ୍ଣ ଚିକ୍କଣ ଚିହ୍ନ ହୁଏ; ");
INSERT INTO ory_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ତେବେ ଯାଜକ ତାହା ଦେଖିବ; ଆଉ, ଯଦି ଚିକ୍କଣ ଚିହ୍ନରେ ଥିବା ଲୋମ ଶ୍ଵେତବର୍ଣ୍ଣ ହୁଏ ଓ ଚର୍ମର ନୀଚସ୍ଥ ଦେଖାଯାଏ, ତେବେ ତାହା କୁଷ୍ଠରୋଗ, ତାହା ଅଗ୍ନିଦାହରୁ ଉତ୍ପନ୍ନ ହୋଇଅଛି; ପୁଣି ଯାଜକ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ତାହା କୁଷ୍ଠରୋଗର ଘାʼ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ମାତ୍ର ଯାଜକ ତାହା ଦେଖନ୍ତେ, ଯଦି ସେହି ଚିକ୍କଣ ଚିହ୍ନରେ ଶ୍ଵେତବର୍ଣ୍ଣ ଲୋମ ନ ଥାଏ ଓ ତାହା ଚର୍ମର ନୀଚସ୍ଥ ନ ହୋଇ ମଳିନ ହୋଇଥାଏ, ତେବେ ଯାଜକ ତାହାକୁ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପୃଥକ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ତହୁଁ ସପ୍ତମ ଦିନରେ ଯାଜକ ତାହାକୁ ଦେଖିବ; ଯଦି ତାହା ଚର୍ମରେ ବ୍ୟାପିଥାଏ, ତେବେ ଯାଜକ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ତାହା କୁଷ୍ଠରୋଗର ଘାʼ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ଆଉ, ଯଦି ଚିକ୍କଣ ଚିହ୍ନ ସ୍ୱ ସ୍ଥାନରେ ଥାଏ ଓ ଚର୍ମରେ ବୃଦ୍ଧି ନ ପାଇ ମଳିନ ହୋଇଥାଏ; ତେବେ ତାହା ଦାହର ଫୁଲା, ଆଉ ଯାଜକ ତାହାକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ଯେହେତୁ ତାହା ଅଗ୍ନିକୃତ କ୍ଷତର ଚିହ୍ନ। ");
INSERT INTO ory_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ଆଉ, ପୁରୁଷ ଅବା ସ୍ତ୍ରୀର ମସ୍ତକରେ ଅବା ଦାଢ଼ିରେ ଘାʼ ହେଲେ ଯାଜକ ସେହି ଘାʼ ଦେଖିବ; ");
INSERT INTO ory_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ଆଉ ଦେଖ, ଯଦି ତାହା ଚର୍ମର ନୀଚସ୍ଥ ଦେଖାଯାଏ ଓ ତହିଁରେ ହଳଦି ବର୍ଣ୍ଣ ସରୁ ଲୋମ ଥାଏ, ତେବେ ଯାଜକ ତାହାକୁ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ତାହା ଛଉ ଅଟେ, ତାହା ମସ୍ତକ ଅବା ଦାଢ଼ିର କୁଷ୍ଠରୋଗ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ଆଉ, ଯାଜକ ଛଉର ଘାʼ ଦେଖନ୍ତେ, ଯଦି ତାହା ଚର୍ମର ନୀଚସ୍ଥ ନ ଥାଏ ଓ ତହିଁରେ କୃଷ୍ଣବର୍ଣ୍ଣ ଲୋମ ନ ଥାଏ, ତେବେ ଯାଜକ ସେହି ଛଉ ଘାʼଯୁକ୍ତ ଲୋକକୁ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପୃଥକ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ତହୁଁ ସପ୍ତମ ଦିନରେ ଯାଜକ ତାହା ଦେଖିବ; ପୁଣି, ଯଦି ସେହି ଛଉ ବଢ଼ି ନ ଥାଏ ଓ ତହିଁରେ ହଳଦି ବର୍ଣ୍ଣ ଲୋମ ହୋଇ ନ ଥାଏ; ଆଉ, ତାହା ଚର୍ମର ନୀଚସ୍ଥ ଦେଖା ନ ଯାଏ, ");
INSERT INTO ory_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ତେବେ ସେ ଲଣ୍ଡା ହେବ, ମାତ୍ର ଛଉ ସ୍ଥାନ ଲଣ୍ଡା କରିବ ନାହିଁ; ପୁଣି ଯାଜକ ସେହି ଛଉଯୁକ୍ତ ଲୋକକୁ ଆଉ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପୃଥକ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ପୁଣି, ସପ୍ତମ ଦିନରେ ଯାଜକ ସେହି ଛଉ ଦେଖିବ; ଆଉ, ଯଦି ସେହି ଛଉ ଚର୍ମରେ ବଢ଼ି ନ ଥାଏ ଓ ତାହା ଚର୍ମର ନୀଚସ୍ଥ ଦେଖା ନ ଯାଏ, ତେବେ ଯାଜକ ତାହାକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ପୁଣି ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇ ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ମାତ୍ର ତାହାର ଶୁଚି ହେଲା ଉତ୍ତାରେ ଯଦି ଚର୍ମରେ ସେହି ଛଉ ବ୍ୟାପିଯାଏ, ");
INSERT INTO ory_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ତେବେ ଯାଜକ ତାହାକୁ ଦେଖିବ; ପୁଣି, ଯଦି ଛଉ ଚର୍ମରେ ବୃଦ୍ଧି ପାଇଥାଏ, ତେବେ ଯାଜକ ହଳଦି ବର୍ଣ୍ଣ ଲୋମର ଅନ୍ୱେଷଣ କରିବ ନାହିଁ; କାରଣ ସେ ଅଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ମାତ୍ର ତାହାର ଦୃଷ୍ଟିରେ ଯଦି ସେହି ଛଉ ବଢ଼ି ନ ଥାଏ ଓ ତହିଁରେ କୃଷ୍ଣବର୍ଣ୍ଣ ଲୋମ ଉଠିଥାଏ, ତେବେ ସେହି ଛଉର ଆରୋଗ୍ୟ ହୋଇଅଛି; ସେ ଶୁଚି ହୋଇଅଛି; ଆଉ, ଯାଜକ ତାହାକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","ପୁଣି, ଯଦି କୌଣସି ପୁରୁଷ କି ସ୍ତ୍ରୀର ଶରୀରର ଚର୍ମରେ ଚିକ୍କଣ ଚିହ୍ନଗୁଡ଼ିକ, ଅର୍ଥାତ୍‍, ଶ୍ଵେତବର୍ଣ୍ଣ ଚିକ୍କଣ ଚିହ୍ନଗୁଡ଼ିକ ହୁଏ; ");
INSERT INTO ory_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ତେବେ ଯାଜକ ତାହା ଦେଖିବ; ପୁଣି ପ୍ରକୃତରେ, ଯଦି ସେମାନଙ୍କ ଶରୀରର ଚର୍ମରେ ସେହି ଚିକ୍କଣ ଚିହ୍ନ ଅଳ୍ପ ମଳିନ ଶ୍ଵେତବର୍ଣ୍ଣ ହୁଏ, ତେବେ ତାହା ଚର୍ମରୁ ଉତ୍ପନ୍ନ ଜାଦୁରୋଗ; ସେ ଲୋକ ଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ଆଉ, ଯଦି କୌଣସି ମନୁଷ୍ୟର ମସ୍ତକରୁ କେଶ ଉପୁଡ଼ିଯାଏ, ତେବେ ସେ ଚନ୍ଦା; ତଥାପି ସେ ଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ଆଉ, ଯଦି ତାହାର କେଶ ମସ୍ତକର ସମ୍ମୁଖ ଭାଗରୁ ଉପୁଡ଼ିଯାଏ, ତେବେ ସେ ଚନ୍ଦା କପାଳ; ତଥାପି ସେ ଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ମାତ୍ର ଯଦି ଚନ୍ଦା ମସ୍ତକରେ କି ଚନ୍ଦା କପାଳରେ ରକ୍ତ ଶ୍ଵେତବର୍ଣ୍ଣ ଘାʼ ହୁଏ; ତେବେ ତାହା ତାହାର ଚନ୍ଦା ମସ୍ତକରେ କି ଚନ୍ଦା କପାଳରେ ଉତ୍ପନ୍ନ କୁଷ୍ଠରୋଗ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ତହୁଁ ଯାଜକ ତାହା ଦେଖିବ; ପୁଣି, ଯଦି ଶରୀରର ଚର୍ମସ୍ଥିତ କୁଷ୍ଠରୋଗ ପରି ଚନ୍ଦା ମସ୍ତକ କି ଚନ୍ଦା କପାଳରେ ରକ୍ତ ଶ୍ଵେତବର୍ଣ୍ଣ ଘାʼର ଫୁଲା ଦେଖାଯାଏ; ");
INSERT INTO ory_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ତେବେ ସେ କୁଷ୍ଠୀ, ସେ ଅଶୁଚି ଅଟେ; ଯାଜକ ତାହାକୁ ଅବଶ୍ୟ ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ; ତାହାର ମସ୍ତକରେ ଘାʼ ହୋଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","ଆଉ, ଯେଉଁ କୁଷ୍ଠୀର ଘାʼ ହୋଇଅଛି, ତାହାର ବସ୍ତ୍ର ଚିରାଯିବ ଓ ତାହାର ମସ୍ତକର କେଶ ମୁକୁଳା ରହିବ ଓ ସେ ଆପଣାର ଉପର ଓଷ୍ଠ ବସ୍ତ୍ରରେ ଢାଙ୍କିବ, ପୁଣି ‘ଅଶୁଚି ଅଶୁଚି’ ବୋଲି ଡାକ ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ତାହାଠାରେ ଯେତେ ଦିନ ଘାʼ ଥିବ, ସେତେ ଦିନ ସେ ଅଶୁଚି ରହିବ; କାରଣ ସେ ଅଶୁଚି ଅଟେ; ସେ ଏକାକୀ ବାସ କରିବ; ଛାଉଣିର ବାହାରେ ତାହାର ବାସସ୍ଥାନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","ମଧ୍ୟ ଯେଉଁ ବସ୍ତ୍ରରେ କୁଷ୍ଠରୋଗର ଦାଗ ହୁଏ, ତାହା ଲୋମ ବସ୍ତ୍ର ହେଉ କି ମସିନା ବସ୍ତ୍ର ହେଉ, ");
INSERT INTO ory_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ଅବା ତାହା ଲୋମ କି ମସିନାର ଟାଣୀରେ କି ପଡୀୟାଣରେ ହେଉ; କିଅବା ଚର୍ମରେ କି ଚର୍ମ ନିର୍ମିତ କୌଣସି ଦ୍ରବ୍ୟରେ ହେଉ; ");
INSERT INTO ory_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ଯଦି ସେହି ଦାଗ ବସ୍ତ୍ରରେ କି ଚର୍ମରେ, ଟାଣୀରେ କି ପଡୀୟାଣରେ କିମ୍ବା ଚର୍ମ ନିର୍ମିତ କୌଣସି ଦ୍ରବ୍ୟରେ ଶାଗୁଆ ବର୍ଣ୍ଣ କି ରକ୍ତବର୍ଣ୍ଣ ହୁଏ, ତେବେ ତାହା କୁଷ୍ଠରୋଗର ଦାଗ; ପୁଣି, ତାହା ଯାଜକକୁ ଦେଖାଇ ଦିଆଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ତହିଁରେ ଯାଜକ ସେହି ଦାଗ ଦେଖିବ, ପୁଣି ଯେଉଁଥିରେ ସେହି ଦାଗ ଥାଏ, ତାହା ସାତ ଦିନ ବନ୍ଦ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ତହୁଁ ସେ ସପ୍ତମ ଦିନରେ ସେହି ଦାଗ ଦେଖିବ; ଯଦି ବସ୍ତ୍ରରେ କି ଟାଣୀରେ କି ପଡୀୟାଣରେ କିଅବା ଚର୍ମରେ, ଯେକୌଣସି ଚର୍ମ ନିର୍ମିତ ବସ୍ତୁରେ ଯଦି ସେହି ଦାଗ ବଢ଼ିଥାଏ, ତେବେ ତାହା କ୍ଷୟ କୁଷ୍ଠରୋଗ; ତାହା ଅଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ଏଣୁ ବସ୍ତ୍ରରେ ଅବା ଲୋମନିର୍ମିତ କି ମସିନା ନିର୍ମିତ ଟାଣୀରେ କି ପଡୀୟାଣରେ କି ଚର୍ମ ନିର୍ମିତ କୌଣସି ଦ୍ରବ୍ୟରେ ସେହି ଦାଗ ଥାଏ, ତାହା ସେ ଦଗ୍ଧ କରିବ; କାରଣ ତାହା କ୍ଷୟ କୁଷ୍ଠରୋଗ; ତାହା ଅଗ୍ନିରେ ଦଗ୍ଧ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","ମାତ୍ର ଯାଜକ ତାହା ଦେଖନ୍ତେ, ଯଦି, ସେହି ଦାଗ ବସ୍ତ୍ରରେ କି ଟାଣୀରେ କି ପଡୀୟାଣରେ କିଅବା ଚର୍ମ ନିର୍ମିତ କୌଣସି ଦ୍ରବ୍ୟରେ ବଢ଼ି ନ ଥାଏ; ");
INSERT INTO ory_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ତେବେ ଯାଜକ ସେହି ଦାଗଯୁକ୍ତ ଦ୍ରବ୍ୟ ଧୋଇବାକୁ ଆଜ୍ଞା ଦେବ, ପୁଣି ସେ ଆଉ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ତାହା ପୃଥକ କରି ରଖିବ; ");
INSERT INTO ory_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ଆଉ ସେହି ଦାଗ ଧୁଆଗଲା ଉତ୍ତାରେ ଯାଜକ ତାହା ଦେଖିବ; ପୁଣି, ଯଦି ସେହି ଦାଗର ବର୍ଣ୍ଣ ବଦଳି ନ ଥାଏ ଓ ସେହି ଦାଗ ବଢ଼ି ନ ଥାଏ, ତେବେ ତାହା ଅଶୁଚି ଅଟେ; ତୁମ୍ଭେ ତାହା ଅଗ୍ନିରେ ଦଗ୍ଧ କରିବ; କାରଣ ସେହି ଦାଗ ଭିତରେ ଥାଉ କି ବାହାରେ ଥାଉ, ତାହା କ୍ଷୟକାରକ। ");
INSERT INTO ory_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ମାତ୍ର ଧୁଆଗଲା ଉତ୍ତାରେ ଯାଜକ ଦେଖନ୍ତେ, ଯଦି, ସେହି ଦାଗ ମଳିନ ହୋଇଥାଏ, ତେବେ ସେ ସେହି ବସ୍ତ୍ରରୁ କି ଚର୍ମରୁ କିଅବା ଟାଣୀରୁ କି ପଡୀୟାଣରୁ ତାହା ଚିରି ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ତଥାପି ଯଦି ସେହି ବସ୍ତ୍ରରେ କି ଟାଣୀରେ କି ପଡୀୟାଣରେ କିଅବା ଚର୍ମ ନିର୍ମିତ କୌଣସି ଦ୍ରବ୍ୟରେ ତାହା ଦେଖାଯାଏ, ତେବେ ତାହା ବଢ଼ୁଅଛି; ଯହିଁରେ ସେହି ଦାଗ ଥାଏ, ତାହା ତୁମ୍ଭେ ଅଗ୍ନିରେ ପୋଡ଼ି ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ପୁଣି ଯେଉଁ ବସ୍ତ୍ର କି ଟାଣୀ କି ପଡୀୟାଣ କି ଚର୍ମ ନିର୍ମିତ କୌଣସି ଦ୍ରବ୍ୟ ଧୌତ କରିବ, ତହିଁରୁ ଯଦି ସେହି ଦାଗ ଯାଏ, ତେବେ ଦ୍ୱିତୀୟ ଥର ତାହା ଧୁଆଯିବ; ତହିଁରେ ତାହା ଶୁଚି ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ଲୋମ କି ମସିନା ନିର୍ମିତ ବସ୍ତ୍ରର କିଅବା ଟାଣୀର କି ପଡୀୟାଣର କିଅବା ଚର୍ମ ନିର୍ମିତ କୌଣସି ଦ୍ରବ୍ୟର କୁଷ୍ଠରୋଗର ଦାଗ ବିଷୟରେ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବା ବା ଅଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବାର ବ୍ୟବସ୍ଥା ଏହି। ");
INSERT INTO ory_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“କୁଷ୍ଠରୋଗୀର ଶୁଚି ହେବା ଦିନରେ ତାହାର ଏହି ବ୍ୟବସ୍ଥା; ସେ ଯାଜକ ନିକଟକୁ ଅଣାଯିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ତହୁଁ ଯାଜକ ଛାଉଣିର ବାହାରକୁ ଯିବ; ପୁଣି ଯାଜକ ଦେଖିବ, ଆଉ, ଯଦି କୁଷ୍ଠୀର କୁଷ୍ଠରୋଗର ଘାʼ ସୁସ୍ଥ ହୋଇଥାଏ, ");
INSERT INTO ory_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ତେବେ ଯେଉଁ ଲୋକ ଶୁଚି ହେବାକୁ ଅଛି, ଯାଜକ ସେହି ଲୋକ ନିମନ୍ତେ ଦୁଇ ଜୀଅନ୍ତା ଶୁଚି ପକ୍ଷୀ, ଏରସ କାଠ, ସିନ୍ଦୂର ବର୍ଣ୍ଣ (ଲୋମ) ଓ ଏସୋବ ନେବା ପାଇଁ ଆଜ୍ଞା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ପୁଣି ଯାଜକ ମୃତ୍ତିକା ପାତ୍ରସ୍ଥିତ ସ୍ରୋତଜଳ ଉପରେ ଏକ ପକ୍ଷୀକୁ ବଧ କରିବାକୁ ଆଜ୍ଞା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ତହିଁ ଉତ୍ତାରେ ସେ ସେହି ଜୀଅନ୍ତା ପକ୍ଷୀକୁ, ଏରସ କାଠ, ସିନ୍ଦୂର ବର୍ଣ୍ଣ (ଲୋମ) ଓ ଏସୋବ ନେଇ ସେହି ସ୍ରୋତଜଳ ଉପରେ ହତ ପକ୍ଷୀର ରକ୍ତରେ ଜୀଅନ୍ତା ପକ୍ଷୀକୁ ଓ ସେହି ସବୁ ଡୁବାଇବ; ");
INSERT INTO ory_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ପୁଣି ସେ କୁଷ୍ଠରୋଗରୁ ଶୁଚିଯୋଗ୍ୟ ଲୋକ ଉପରେ ସାତ ଥର ତାହା ଛିଞ୍ଚି; ସେ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ, ଆଉ ସେହି ଜୀଅନ୍ତା ପକ୍ଷୀକୁ କ୍ଷେତ୍ର ଆଡ଼େ ଛାଡ଼ିଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ତହୁଁ ସେହି ଶୁଚିଯୋଗ୍ୟ ଲୋକ ଆପଣା ବସ୍ତ୍ର ଧୋଇ ଓ ସମସ୍ତ କେଶ କ୍ଷୌର କରି ଜଳରେ ସ୍ନାନ କରିବ, ତହିଁରେ ସେ ଶୁଚି ହେବ; ତହିଁ ଉତ୍ତାରେ ସେ ଛାଉଣି ଭିତରକୁ ଆସିବ, ମାତ୍ର ସେ ସାତ ଦିନ ଆପଣା ତମ୍ବୁର ବାହାରେ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ଆଉ, ସପ୍ତମ ଦିନରେ ସେ ଆପଣାର ସମସ୍ତ କେଶ, ଅର୍ଥାତ୍‍, ମସ୍ତକ, ଦାଢ଼ି ଓ ଭ୍ରୂଲତାର ସମସ୍ତ କେଶ କ୍ଷୌର କରିବ, ପୁଣି ଆପଣା ବସ୍ତ୍ର ଧୋଇ ଆପେ ଜଳରେ ସ୍ନାନ କରି ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ପୁଣି, ଅଷ୍ଟମ ଦିନରେ ଦୁଇ ନିଖୁନ୍ତ ମେଷବତ୍ସ, ଏକବର୍ଷୀୟା ଏକ ନିଖୁନ୍ତ ମେଷବତ୍ସା ଓ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ଏକ ଐଫାର ତିନି ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦା ଓ ଏକ ଲୋଗ୍‍ ତୈଳ ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ତହୁଁ ଶୁଚିକାରୀ ଯାଜକ ସେହି ଶୁଚିଯୋଗ୍ୟ ଲୋକକୁ ଓ ସେହି ସବୁ ଦ୍ରବ୍ୟ ନେଇ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସ୍ଥାପନ କରିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ପୁଣି ଯାଜକ ସେହି ଦୁଇ ମେଷବତ୍ସ ମଧ୍ୟରୁ ଗୋଟିଏ ଓ ସେହି ଏକ ଲୋଗ୍‍ ତୈଳ ନେଇ ଦୋଷାର୍ଥକ ବଳି ରୂପେ ଉତ୍ସର୍ଗ କରିବ, ଆଉ ଦୋଳନୀୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ଆଉ, ଯେଉଁ ସ୍ଥାନରେ ପାପାର୍ଥକ ଓ ହୋମାର୍ଥକ ବଳି ବଧ କରାଯାଏ, ସେହି ପବିତ୍ର ସ୍ଥାନରେ ସେହି ମେଷବତ୍ସ ବଧ କରିବ; କାରଣ ଯେପରି ପାପାର୍ଥକ ବଳି, ସେପରି ଦୋଷାର୍ଥକ ବଳି ଯାଜକର ଅଟଇ; ତାହା ମହାପବିତ୍ର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ଏଥିଉତ୍ତାରେ ଯାଜକ ସେହି ଦୋଷାର୍ଥକ ବଳିର କିଛି ରକ୍ତ ନେବ; ପୁଣି, ଯାଜକ ସେହି ଶୁଚିଯୋଗ୍ୟ ଲୋକର ଡାହାଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ, ଡାହାଣ ହସ୍ତର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ଓ ଡାହାଣ ପାଦର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ତାହା ଲଗାଇବ; ");
INSERT INTO ory_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ଆଉ, ଯାଜକ ସେହି ଏକ ଲୋଗ୍‍ ତୈଳରୁ କିଛି ନେଇ ଆପଣା ବାମ ହସ୍ତର ପାପୁଲିରେ ଢାଳିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ତହୁଁ ଯାଜକ ସେହି ବାମ ହସ୍ତର ପାପୁଲିସ୍ଥିତ ତୈଳରେ ଆପଣା ଡାହାଣ ଅଙ୍ଗୁଳି ଡୁବାଇ ଅଙ୍ଗୁଳି ଦ୍ୱାରା ସେହି ତୈଳରୁ କିଛି ନେଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସାତ ଥର ଛିଞ୍ଚିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ପୁଣି, ଯାଜକ ଆପଣା ହସ୍ତସ୍ଥିତ ଅବଶିଷ୍ଟ ତୈଳ ନେଇ ସେହି ଶୁଚିଯୋଗ୍ୟ ଲୋକର ଡାହାଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ, ଡାହାଣ ହସ୍ତର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ଓ ଡାହାଣ ପାଦର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ଲାଗିଥିବା ଦୋଷାର୍ଥକ ବଳିର ରକ୍ତ ଉପରେ ଲଗାଇବ; ");
INSERT INTO ory_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ଏଥିଉତ୍ତାରେ ଯାଜକ ଆପଣା ହସ୍ତସ୍ଥିତ ଅବଶିଷ୍ଟ ତୈଳ ସେହି ଶୁଚିଯୋଗ୍ୟ ଲୋକର ମସ୍ତକରେ ଲଗାଇବ; ପୁଣି ଯାଜକ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାହା ପାଇଁ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ଆଉ ଯାଜକ ପାପାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରିବ ଓ ସେହି ଶୁଚିଯୋଗ୍ୟ ଲୋକର ଅଶୁଚିତା ହେତୁ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ଏଥିଉତ୍ତାରେ ସେ ହୋମାର୍ଥକ ବଳି ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ଆଉ, ଯାଜକ ହୋମବଳି ଓ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଆଣି ବେଦିରେ ଉତ୍ସର୍ଗ କରିବ, ତହୁଁ ଯାଜକ ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କଲେ ସେ ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","ଆଉ, ଯଦି ସେ ଦରିଦ୍ର ଓ ସେହି ସମସ୍ତ ବଳିଦାନ ଆଣି ନ ପାରେ, ତେବେ ସେ ଆପଣା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବାକୁ ଦୋଳନୀୟ ନୈବେଦ୍ୟ ରୂପେ ଦୋଷାର୍ଥକ ବଳି ପାଇଁ ଗୋଟିଏ ମେଷବତ୍ସ ଓ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ରୂପେ ଏକ ଐଫାର ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦା ଓ ଏକ ଲୋଗ୍‍ ତୈଳ; ");
INSERT INTO ory_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ପୁଣି, ତାହାର ପ୍ରାପ୍ତିର ସାଧ୍ୟାନୁସାରେ ଦୁଇ କପୋତ ଅବା ଦୁଇ ପାରାଛୁଆ ଆଣିବ; ଆଉ, ଏଥିରୁ ଗୋଟିଏ ପାପାର୍ଥକ ବଳି ଓ ଅନ୍ୟଟି ହୋମବଳି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ଆଉ, ଅଷ୍ଟମ ଦିନରେ ସେ ଆପଣାର ଶୁଚିକାର୍ଯ୍ୟ ନିମନ୍ତେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଯାଜକ ନିକଟକୁ ସେମାନଙ୍କୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ତହୁଁ ଯାଜକ ଦୋଷାର୍ଥକ ବଳିର ମେଷବତ୍ସ ଓ ସେହି ଏକ ଲୋଗ୍‍ ତୈଳ ନେବ; ପୁଣି, ଯାଜକ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ତାହା ଦୋଳାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ପୁଣି, ସେ ସେହି ଦୋଷାର୍ଥକ ବଳିର ମେଷବତ୍ସ ବଧ କରିବ; ଆଉ ଯାଜକ ସେହି ଦୋଷାର୍ଥକ ବଳିର କିଛି ରକ୍ତ ନେଇ ଶୁଚିଯୋଗ୍ୟ ଲୋକର ଡାହାଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ, ଡାହାଣ ହସ୍ତର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ଓ ଡାହାଣ ପାଦର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ଲଗାଇବ; ");
INSERT INTO ory_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ତହିଁ ଉତ୍ତାରେ ଯାଜକ ସେହି ତୈଳରୁ କିଛି ନେଇ ଆପଣା ବାମ ହସ୍ତ ପାପୁଲିରେ ଢାଳିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ଆଉ, ଯାଜକ ଆପଣା ଡାହାଣ ଅଙ୍ଗୁଳି ଦ୍ୱାରା ସେହି ବାମ ହସ୍ତସ୍ଥିତ ତୈଳରୁ କିଛି କିଛି ନେଇ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ସାତ ଥର ଛିଞ୍ଚିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ତହୁଁ ଯାଜକ ଆପଣା ହସ୍ତସ୍ଥିତ ତୈଳ ନେଇ ସେହି ଶୁଚିଯୋଗ୍ୟ ଲୋକର ଡାହାଣ କର୍ଣ୍ଣପ୍ରାନ୍ତରେ, ତାହାର ଡାହାଣ ହସ୍ତର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ଓ ଡାହାଣ ପାଦର ବୃଦ୍ଧାଙ୍ଗୁଳିରେ ଲାଗିଥିବା ଦୋଷାର୍ଥକ ବଳିର ରକ୍ତ ସ୍ଥାନରେ ଲଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ପୁଣି ଯାଜକ ଶୁଚିଯୋଗ୍ୟ ଲୋକ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ପାଇଁ ଆପଣା ହସ୍ତସ୍ଥିତ ଅବଶିଷ୍ଟ ତୈଳ ତାହାର ମସ୍ତକରେ ଲଗାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ପୁଣି, ସେ ତାହାର ପ୍ରାପ୍ତିର ସାଧ୍ୟାନୁସାରେ ସେହି ଦୁଇ କପୋତ ଅବା ଦୁଇ ପାରାଛୁଆ ମଧ୍ୟରୁ ଗୋଟିଏ ଉତ୍ସର୍ଗ କରିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ଅର୍ଥାତ୍‍, ତାହାର ପ୍ରାପ୍ତିର ସାଧ୍ୟାନୁସାରେ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ସହିତ ଗୋଟିଏକୁ ପାପାର୍ଥକ ବଳି ରୂପେ ଓ ଅନ୍ୟଟିକୁ ହୋମବଳି ରୂପେ ଉତ୍ସର୍ଗ କରିବ; ପୁଣି, ଯାଜକ ଶୁଚିଯୋଗ୍ୟ ଲୋକ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ଯେଉଁ କୁଷ୍ଠରୋଗର ଘାʼଯୁକ୍ତ ଲୋକ ଆପଣାର ଶୁଚିକାର୍ଯ୍ୟ ସମ୍ବନ୍ଧୀୟ ଦ୍ରବ୍ୟ ପାଇବାକୁ ଅସମର୍ଥ, ତାହା ପାଇଁ ଏହି ବ୍ୟବସ୍ଥା।” ");
INSERT INTO ory_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ଆମ୍ଭେ ଯେଉଁ ଦେଶ ତୁମ୍ଭମାନଙ୍କ ଅଧିକାର ନିମନ୍ତେ ଦେବା, ସେହି କିଣାନ ଦେଶରେ ତୁମ୍ଭେମାନେ ପ୍ରବେଶ କଲେ, ଯେବେ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଅଧିକୃତ ଦେଶର କୌଣସି ଗୃହରେ କୁଷ୍ଠରୋଗର ଦାଗ ଉତ୍ପନ୍ନ କରୁ; ");
INSERT INTO ory_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ତେବେ ସେହି ଗୃହସ୍ୱାମୀ ଯାଜକ ନିକଟକୁ ଆସି କହିବ, ଯଥା, ‘ମୋʼ ଗୃହରେ ଦାଗ ଥିଲା ପରି ମୋତେ ଦେଖାଯାଉଅଛି;’ ");
INSERT INTO ory_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ତହୁଁ ଗୃହର ସମସ୍ତ ଦ୍ରବ୍ୟ ଯେପରି ଅଶୁଚି ନ ହୁଏ, ଏଥିପାଇଁ ଯାଜକ ଦାଗ ଦେଖିବାକୁ ପ୍ରବେଶ କରିବା ପୂର୍ବେ ଗୃହ ଶୂନ୍ୟ କରିବାକୁ ଯାଜକ ଆଜ୍ଞା ଦେବ; ତହିଁ ଉତ୍ତାରେ ଯାଜକ ଗୃହ ଦେଖିବାକୁ ପ୍ରବେଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ପୁଣି, ସେ ସେହି ଦାଗ ଦେଖିବ, ପୁଣି ପ୍ରକୃତରେ, ଯଦି ସେହି ଦାଗ ଗୃହର କାନ୍ଥରେ ଟୋଲାପୋଲା ହୋଇ ବସିଯାଇ ଅଳ୍ପ ଶାଗୁଆ ବର୍ଣ୍ଣ ବା ରକ୍ତବର୍ଣ୍ଣ ହୋଇଥାଏ, ପୁଣି ତାହା କାନ୍ଥର ନୀଚସ୍ଥ ଦେଖାଯାଏ, ");
INSERT INTO ory_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ତେବେ ଯାଜକ ଗୃହରୁ ବାହାର ହୋଇ ଦ୍ୱାର ନିକଟକୁ ଯିବ ଓ ସେହି ଗୃହକୁ ସାତ ଦିନ ବନ୍ଦ କରି ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ପୁଣି, ଯାଜକ ସପ୍ତମ ଦିନରେ ପୁନର୍ବାର ଆସି ଦେଖିବ; ପୁଣି ପ୍ରକୃତରେ, ଯଦି ଗୃହର କାନ୍ଥରେ ସେହି ଦାଗ ବଢ଼ିଥାଏ, ");
INSERT INTO ory_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ତେବେ ଯାଜକ ଦାଗଯୁକ୍ତ ପ୍ରସ୍ତରସବୁ ବାହାର କରି ନଗରର ବାହାରେ ଅଶୁଚି ସ୍ଥାନରେ ପକାଇ ଦେବାକୁ ଲୋକମାନଙ୍କୁ ଆଜ୍ଞା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ପୁଣି, ସେ ସେହି ଗୃହର ଭିତର ଚାରିଆଡ଼େ ଚଞ୍ଛାଇବ ଓ ସେହି ଚଞ୍ଛା ଧୂଳି ନଗରର ବାହାରେ ଅଶୁଚି ସ୍ଥାନରେ ପକାଇ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ଆଉ, ସେମାନେ ଅନ୍ୟ ପ୍ରସ୍ତର ନେଇ ସେହି ପ୍ରସ୍ତର ସ୍ଥାନରେ ବସାଇବେ ଓ ଅନ୍ୟ ଲେପ ନେଇ ଗୃହ ଲେପନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ଆଉ, ସେହି ପ୍ରସ୍ତର ବଦଳ କଲା ଉତ୍ତାରେ ଓ ଗୃହ ଚାଞ୍ଛିଲା ଉତ୍ତାରେ ଓ ଲେପନ କଲା ଉତ୍ତାରେ ଯେବେ ସେହି ଦାଗ ପୁନର୍ବାର ଗୃହରେ ଫୁଟି ବାହାରେ, ");
INSERT INTO ory_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ତେବେ ଯାଜକ ଆସି ଦେଖିବ, ପୁଣି ପ୍ରକୃତରେ, ଯଦି ସେହି ଦାଗ ଗୃହରେ ବୃଦ୍ଧି ପାଇଥାଏ, ତେବେ ସେହି ଗୃହରେ କ୍ଷୟ କୁଷ୍ଠରୋଗ ଅଛି; ତାହା ଅଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ତହିଁରେ ସେ ସେହି ଗୃହ ଭାଙ୍ଗି ପକାଇବ, ତହିଁର ପ୍ରସ୍ତର ଓ କାଷ୍ଠ ଓ ଧୂଳିସବୁ ନଗରର ବାହାରେ ଅଶୁଚି ସ୍ଥାନକୁ ବୋହି ନେଇଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ଆହୁରି, ସେହି ଗୃହ ବନ୍ଦ ହୋଇଥିବା ସମୟରେ ଯେକେହି ତହିଁ ଭିତରକୁ ଯାଏ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ହୋଇ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ପୁଣି, ଯେ ସେହି ଗୃହରେ ଶୟନ କରେ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ସେହି ଘରେ ଯେ ଭୋଜନ କରେ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ। ");
INSERT INTO ory_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ଆଉ, ଯାଜକ ଆସି ଦେଖନ୍ତେ, ଯଦି, ସେହି ଗୃହ ଲେପନ କଲା ଉତ୍ତାରେ ଦାଗ ସେହି ଗୃହରେ ବଢ଼ି ନାହିଁ, ତେବେ ଯାଜକ ସେହି ଗୃହକୁ ଶୁଚି ବୋଲି ପ୍ରକାଶ କରିବ, କାରଣ ଦାଗ ଅଦୃଶ୍ୟ ହୋଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ତହୁଁ ସେ ସେହି ଗୃହକୁ ଶୁଚି କରିବା ପାଇଁ ଦୁଇ ପକ୍ଷୀ, ଏରସ କାଠ, ସିନ୍ଦୂର ବର୍ଣ୍ଣ (ଲୋମ) ଓ ଏସୋବ ନେବ; ");
INSERT INTO ory_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ପୁଣି, ମୃତ୍ତିକା ପାତ୍ରସ୍ଥିତ ସ୍ରୋତଜଳ ଉପରେ ଏକ ପକ୍ଷୀକୁ ବଧ କରିବ; ");
INSERT INTO ory_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ତହୁଁ ସେ ସେହି ଏରସ କାଠ, ଏସୋବ, ସିନ୍ଦୂର ବର୍ଣ୍ଣ (ଲୋମ) ଓ ଜୀଅନ୍ତା ପକ୍ଷୀକୁ ନେଇ ହତ ପକ୍ଷୀର ରକ୍ତରେ ଓ ସେହି ସ୍ରୋତଜଳରେ ଡୁବାଇବ ଓ ସେହି ଗୃହରେ ସାତ ଥର ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ଏହି ପ୍ରକାରେ ପକ୍ଷୀର ରକ୍ତ ଦ୍ୱାରା, ସ୍ରୋତଜଳ ଦ୍ୱାରା, ଜୀଅନ୍ତା ପକ୍ଷୀ ଦ୍ୱାରା, ଏରସ କାଠ ଦ୍ୱାରା, ଏସୋବ ଦ୍ୱାରା ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣ (ଲୋମ) ଦ୍ୱାରା ସେହି ଗୃହକୁ ଶୁଚି କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ମାତ୍ର ସେ ଜୀଅନ୍ତା ପକ୍ଷୀକୁ ନଗରର ବାହାରସ୍ଥ କ୍ଷେତ୍ର ଆଡ଼େ ଛାଡ଼ିଦେବ; ଏହିରୂପେ ସେ ଗୃହ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ତହିଁରେ ତାହା ଶୁଚି ହେବ।” ");
INSERT INTO ory_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","କୁଷ୍ଠରୋଗର ସର୍ବପ୍ରକାର ଘାଆ ଓ ଛଉର ଏହି ବ୍ୟବସ୍ଥା; ");
INSERT INTO ory_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ପୁଣି, ବସ୍ତ୍ରସ୍ଥିତ ଓ ଗୃହସ୍ଥିତ କୁଷ୍ଠରୋଗ; ");
INSERT INTO ory_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ଆଉ, ଫୁଲା ଓ ପାମା ଓ ଚିକ୍କଣ ଚିହ୍ନ, ");
INSERT INTO ory_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ଏହିସବୁ କେଉଁ ସମୟରେ ଶୁଚି ଓ କେଉଁ ସମୟରେ ଅଶୁଚି, ଏହା ଜଣାଇବା ନିମନ୍ତେ କୁଷ୍ଠରୋଗର ଏହି ବ୍ୟବସ୍ଥା। ");
INSERT INTO ory_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ଯଦି ପୁରୁଷର ଶରୀରରେ ପ୍ରମେହ ରୋଗ ହୁଏ, ସେ ଆପଣାର ସେହି ପ୍ରମେହ ସକାଶୁ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ପୁଣି ପ୍ରମେହ ସକାଶୁ ତାହାର ଅଶୁଚିତାର ବିଧି ଏହି; ତାହାର ଶରୀରରୁ ପ୍ରମେହ ଝରୁ ଥାଉ ଅବା ଶରୀରରେ ବନ୍ଦ ଥାଉ, ତାହା ତାହାର ଅଶୁଚିତା ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ପ୍ରମେହୀ ଲୋକ ଯେଉଁ ପ୍ରତ୍ୟେକ ଶଯ୍ୟାରେ ଶୟନ କରେ, ତାହା ଅଶୁଚି ହେବ ଓ ଯେଉଁ ପ୍ରତ୍ୟେକ ପଦାର୍ଥ ଉପରେ ସେ ବସେ, ତାହା ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ପୁଣି, ଯେକେହି ତାହାର ଶଯ୍ୟା ଛୁଇଁବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ଆଉ, ଯେକୌଣସି ପଦାର୍ଥ ଉପରେ ପ୍ରମେହୀ ବସେ, ତହିଁ ଉପରେ ଯଦି କେହି ବସେ, ତେବେ ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ପୁଣି, ଯେକେହି ପ୍ରମେହୀର ଶରୀର ଛୁଇଁବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ଆଉ, ପ୍ରମେହୀ ଯଦି ଶୁଚି ଲୋକର ଦେହରେ ଛେପ ପକାଏ, ତେବେ ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ପୁଣି, ପ୍ରମେହୀ ଯେଉଁ ବାହନ ଉପରେ ଚଢ଼େ, ତାହା ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ଆଉ, ଯେକେହି ତାହାର ତଳସ୍ଥ କୌଣସି ବସ୍ତୁ ଛୁଇଁବ, ତେବେ ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ; ପୁଣି ଯେକେହି ତାହା ବୋହିବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଆପେ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ପୁଣି, ପ୍ରମେହୀ ଆପଣା ହସ୍ତ ଜଳରେ ନ ଧୋଇ ଯାହାକୁ ଛୁଇଁବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ପୁଣି, ପ୍ରମେହୀ ଯେଉଁ ମୃତ୍ତିକା ପାତ୍ର ଛୁଇଁବ, ତାହା ଭଙ୍ଗାଯିବ ଓ ସମସ୍ତ କାଷ୍ଠ ପାତ୍ର ଜଳରେ ଧୁଆଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","ଆଉ, ପ୍ରମେହୀ ଯେତେବେଳେ ଆପଣା ପ୍ରମେହରୁ ଶୁଚି ହୁଏ, ସେତେବେଳେ ସେ ଆପଣାର ଶୁଚିକାର୍ଯ୍ୟ ନିମନ୍ତେ ସାତ ଦିନ ଗଣନା କରିବ ଓ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ସ୍ରୋତଜଳରେ ସ୍ନାନ କରିବ; ତହୁଁ ସେ ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ପୁଣି, ଅଷ୍ଟମ ଦିନରେ ସେ ଆପଣାର ଶୁଚିକାର୍ଯ୍ୟ ନିମନ୍ତେ ଦୁଇ କପୋତ ଅବା ଦୁଇ ପାରାଛୁଆ ନେଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟକୁ ଆସି ଯାଜକର ହସ୍ତରେ ସେମାନଙ୍କୁ ସମର୍ପଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ତହିଁରେ ଯାଜକ ସେଥିରୁ ଗୋଟିଏକୁ ପାପାର୍ଥକ ବଳି ଓ ଅନ୍ୟଟିକୁ ହୋମବଳି ରୂପେ ଉତ୍ସର୍ଗ କରିବ; ପୁଣି, ଯାଜକ ତାହାର ପ୍ରମେହ ହେତୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ଆଉ, ଯଦି କୌଣସି ପୁରୁଷର ବୀର୍ଯ୍ୟପାତ ହୁଏ, ତେବେ ସେ ଆପଣା ସମସ୍ତ ଶରୀର ଜଳରେ ଧୌତ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ଆଉ, ଯେଉଁ ପ୍ରତ୍ୟେକ ବସ୍ତ୍ରରେ କି ଚର୍ମରେ ବୀର୍ଯ୍ୟପାତ ହୁଏ, ତାହା ଜଳରେ ଧୋଇବ ଓ ତାହା ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ମଧ୍ୟ ସେ ସ୍ତ୍ରୀ, ଯାହା ସଙ୍ଗେ ସ୍ଖଳିତ ବୀର୍ଯ୍ୟ ପୁରୁଷ ଶୟନ କରିବ, ସେ ଦୁହେଁ ଜଳରେ ସ୍ନାନ କରିବେ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବେ। ");
INSERT INTO ory_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","ଆଉ, ଯଦି ସ୍ତ୍ରୀ ରଜସ୍ୱଳା ହୁଏ ଓ ତାହାର ଦେହରୁ ରକ୍ତ ଝରେ, ତେବେ ସେ ସାତ ଦିନ ଆପଣା ଅଶୁଚିତାରେ ରହିବ; ପୁଣି, ଯେକେହି ତାହାକୁ ଛୁଇଁବ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ଆଉ ସେ ଆପଣା ସ୍ତ୍ରୀଧର୍ମ ସମୟରେ ଯେକୌଣସି ଶଯ୍ୟାରେ ଶୟନ କରିବ, ତାହା ଅଶୁଚି ହେବ ଓ ଯହିଁ ଉପରେ ସେ ବସିବ, ତାହା ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ପୁଣି, ଯେକେହି ତାହାର ଶଯ୍ୟା ଛୁଇଁବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଆପେ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ପୁଣି, ଯେକେହି ତାହାର ବସିବାର କୌଣସି ଆସନ ଉପରେ ବସେ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଆପେ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ଆଉ, ତାହାର ଶଯ୍ୟା କି ଆସନ ଉପରେ କିଛି ଥିଲେ, ଯେକେହି ତାହା ଛୁଇଁବ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ଆଉ, ଯେଉଁ ପୁରୁଷ ତାହା ସଙ୍ଗେ ଶୟନ କରେ ଓ ତାହାର ରଜ ତାହାଠାରେ ଲାଗେ, ସେ ସାତ ଦିନ ଅଶୁଚି ରହିବ; ପୁଣି ସେ ଯେକୌଣସି ଶଯ୍ୟାରେ ଶୟନ କରେ, ତାହା ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ଆଉ, ସ୍ତ୍ରୀର ରଜଧର୍ମ ସମୟ ଛଡ଼ା ଯେବେ କୌଣସି ସ୍ତ୍ରୀର ବହୁ ଦିନ ପର୍ଯ୍ୟନ୍ତ ରକ୍ତସ୍ରାବ ହୁଏ, କିଅବା ସ୍ତ୍ରୀର ରଜଧର୍ମ ସମୟ ଉତ୍ତାରେ ଯେବେ ରକ୍ତସ୍ରାବ ହୁଏ; ତେବେ ଯେପରି ସ୍ତ୍ରୀର ରଜଧର୍ମ ସମୟରେ, ସେପରି ଅଶୁଚି ରକ୍ତସ୍ରାବର ସକଳ ଦିନ ହେବ, ସେ ଅଶୁଚି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ସେହି ରକ୍ତସ୍ରାବର ସକଳ ଦିନ ଯେକୌଣସି ଶଯ୍ୟାରେ ସେ ଶୟନ କରେ, ତାହା ସ୍ତ୍ରୀଧର୍ମ ସମୟର ଶଯ୍ୟା ସଦୃଶ ଅଶୁଚି ହେବ, ଆଉ ସେ ଯେକୌଣସି ଆସନରେ ବସେ, ତାହା ସ୍ତ୍ରୀର ରଜଧର୍ମ ସମୟର ଅଶୁଚିତା ସଦୃଶ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ପୁଣି, ଯେକେହି ସେହି ସମସ୍ତ ଛୁଇଁବ, ସେ ଅଶୁଚି ହେବ ଓ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଆପେ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ମାତ୍ର ସେହି ସ୍ତ୍ରୀର ରକ୍ତସ୍ରାବ ବନ୍ଦ ହେଲେ, ସେ ଆପଣା ନିମନ୍ତେ ସାତ ଦିନ ଗଣନା କରିବ, ତହିଁ ଉତ୍ତାରେ ସେ ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ପୁଣି, ଅଷ୍ଟମ ଦିନରେ ସେ ଆପଣା ନିମନ୍ତେ ଦୁଇ କପୋତ ଅବା ଦୁଇ ପାରାଛୁଆ ନେଇ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାରରେ ଯାଜକ ନିକଟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ତହିଁରେ ଯାଜକ ସେଥିରୁ ଗୋଟିଏକୁ ପାପାର୍ଥକ ବଳି ଓ ଅନ୍ୟଟିକୁ ହୋମବଳି ରୂପେ ଉତ୍ସର୍ଗ କରିବ; ଆଉ, ଯାଜକ ତାହାର ରକ୍ତସ୍ରାବର ଅଶୁଚିତା ହେତୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","ଏହିରୂପେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସେମାନଙ୍କର ମଧ୍ୟବର୍ତ୍ତୀ ଆମ୍ଭର ଆବାସ ଅଶୁଚି କଲେ, ଯେପରି ସେମାନେ ଆପଣାମାନଙ୍କ ଅଶୁଚିତାରେ ନ ମରନ୍ତି, ଏଥିପାଇଁ ତୁମ୍ଭେମାନେ ସେମାନଙ୍କୁ ସେମାନଙ୍କ ଅଶୁଚିତାରୁ ପୃଥକ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ପ୍ରମେହ ରୋଗୀର ଓ ବୀର୍ଯ୍ୟପାତରେ ଅଶୁଚି ଲୋକର, ");
INSERT INTO ory_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ପୁଣି ରଜସ୍ୱଳା ସ୍ତ୍ରୀର ଓ ପ୍ରମେହୀ ପୁରୁଷ ଓ ସ୍ତ୍ରୀର, ଆଉ, ସ୍ତ୍ରୀର ଅଶୁଚିତା ସମୟରେ ତାହା ସହିତ ଶୟନକାରୀ ପୁରୁଷର, ଏହି ବ୍ୟବସ୍ଥା। ");
INSERT INTO ory_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ଆଉ, ହାରୋଣଙ୍କର ଦୁଇ ପୁତ୍ର ସଦାପ୍ରଭୁଙ୍କ ନିକଟବର୍ତ୍ତୀ ହୋଇ ମଲା ଉତ୍ତାରେ, ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ; ");
INSERT INTO ory_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ଭ୍ରାତା ହାରୋଣକୁ କୁହ, ଯେପରି ତାହାର ମୃତ୍ୟୁୁ ନ ହୁଏ, ଏଥିପାଇଁ ବିଚ୍ଛେଦ ବସ୍ତ୍ର ଭିତରେ ସିନ୍ଦୁକର ଉପରିସ୍ଥ ପାପାଚ୍ଛାଦନ ସମ୍ମୁଖସ୍ଥ ପବିତ୍ର ସ୍ଥାନରେ ସର୍ବଦା ପ୍ରବେଶ କରିବ ନାହିଁ; କାରଣ ଆମ୍ଭେ ପାପାଚ୍ଛାଦନ ଉପରେ ମେଘରେ ଦର୍ଶନ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ହାରୋଣ ପାପାର୍ଥେ ଏକ ଗୋବତ୍ସ ଓ ହୋମାର୍ଥେ ଏକ ମେଷ ସଙ୍ଗେ ନେଇ ଏହିରୂପେ ପବିତ୍ର ସ୍ଥାନରେ ପ୍ରବେଶ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ସେ ପବିତ୍ର ଶୁଭ୍ର ପୋଷାକ ପିନ୍ଧିବ, ଦେହରେ ଶୁଭ୍ର ଜଙ୍ଘିଆ ପିନ୍ଧିବ, ଶୁଭ୍ର କଟିବନ୍ଧନୀରେ କଟି ବାନ୍ଧିବ ଓ ଶୁଭ୍ର ପଗଡ଼ିରେ ଭୂଷିତ ହେବ; ଏହିସବୁ ପବିତ୍ର ବସ୍ତ୍ର; ଏଥିପାଇଁ ସେ ଜଳରେ ଆପଣା ଶରୀର ଧୌତ କରି ତାହାସବୁ ପିନ୍ଧିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ପୁଣି, ସେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ମଣ୍ଡଳୀରୁ ପାପାର୍ଥେ ଦୁଇ ଛାଗ ଓ ହୋମାର୍ଥେ ଏକ ମେଷ ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ଆଉ, ହାରୋଣ ଆପଣା ନିମନ୍ତେ ପାପାର୍ଥକ ବଳିର ଯେଉଁ ଗୋବତ୍ସ, ତାକୁ ଆଣି ଆପଣା ନିମନ୍ତେ ଓ ଆପଣା ପରିବାର ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ତହୁଁ ସେହି ଦୁଇ ଛାଗ ନେଇ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଠିଆ କରାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ପୁଣି, ହାରୋଣ ସେହି ଦୁଇ ଛାଗ ମଧ୍ୟରେ ଗୁଲିବାଣ୍ଟ କରିବ; ତହିଁରୁ ଗୋଟିଏ ସଦାପ୍ରଭୁଙ୍କ ନିମନ୍ତେ ଓ ଅନ୍ୟଟି ତ୍ୟାଗ ନିମନ୍ତେ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ପୁଣି, ଯେଉଁ ଛାଗ ଗୁଲିବାଣ୍ଟ ଦ୍ୱାରା ସଦାପ୍ରଭୁଙ୍କ ନିମନ୍ତେ ହେବ, ହାରୋଣ ତାକୁ ନେଇ ପାପାର୍ଥେ ବଳିଦାନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ମାତ୍ର ଯେଉଁ ଛାଗ ଗୁଲିବାଣ୍ଟ ଦ୍ୱାରା ତ୍ୟାଗ ନିମନ୍ତେ ହେବ, ସେ ଯେପରି ତ୍ୟାଗ ନିମନ୍ତେ ପ୍ରାନ୍ତରକୁ ପଠାଯାଇ ପାରିବ, ଏଥିପାଇଁ ତାହା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବାକୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାକୁ ଜୀଅନ୍ତା ଠିଆ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","ଏଥିଉତ୍ତାରେ ହାରୋଣ ଆପଣା ନିମନ୍ତେ ପାପାର୍ଥକ ବଳିର ଯେଉଁ ଗୋବତ୍ସ, ତାକୁ ଆଣି ଆପଣା ନିମନ୍ତେ ଓ ଆପଣା ପରିବାର ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ପୁଣି, ଆପଣା ପାପାର୍ଥକ ବଳିର ସେହି ଗୋବତ୍ସକୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ଆଉ, ସେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖସ୍ଥ ବେଦିରୁ ପ୍ରଜ୍ୱଳିତ ଅଙ୍ଗାର ଧୂପଧାନୀରେ ପୂର୍ଣ୍ଣ କରି ଓ ମୁଠିଏ ଚୂର୍ଣ୍ଣ ସୁଗନ୍ଧି ଧୂପ ନେଇ ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ଭିତରକୁ ଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଅଗ୍ନି ଉପରେ ସେହି ସୁଗନ୍ଧି ଧୂପ ଦେବ, ତହିଁରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକର ଉପରିସ୍ଥ ପାପାଚ୍ଛାଦନ ଧୂପର ଧୂମ ମେଘରେ ଆଚ୍ଛନ୍ନ ହେଲେ ସେ ମରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ତହୁଁ ସେ ସେହି ଗୋବତ୍ସର କିଛି ରକ୍ତ ନେଇ ପାପାଚ୍ଛାଦନର ପୂର୍ବ ଆଡ଼େ ଅଙ୍ଗୁଳି ଦ୍ୱାରା ଛିଞ୍ଚିବ; ପୁଣି, ପାପାଚ୍ଛାଦନ ସମ୍ମୁଖରେ ଅଙ୍ଗୁଳି ଦ୍ୱାରା ସାତ ଥର ସେହି ରକ୍ତ ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ଏଥିଉତ୍ତାରେ ସେ ଲୋକମାନଙ୍କର ପାପାର୍ଥକ ବଳିର ଛାଗ ନେଇ ବଧ କରିବ ଓ ତାହାର ରକ୍ତ ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ଭିତରକୁ ଆଣି, ଯେପରି ଗୋବତ୍ସର ରକ୍ତ ନେଇ କରିଥିଲା, ସେପରି ତାହାର ରକ୍ତ ନେଇ କରିବ, ଅର୍ଥାତ୍‍, ପାପାଚ୍ଛାଦନ ଉପରେ ଓ ପାପାଚ୍ଛାଦନ ସମ୍ମୁଖରେ ତାହା ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଅଶୁଚିତା ଓ ସେମାନଙ୍କ ଅଧର୍ମ, ଅର୍ଥାତ୍‍, ସେମାନଙ୍କର ସମସ୍ତ ପାପ ସକାଶୁ ସେ ପବିତ୍ର ସ୍ଥାନ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ପୁଣି, ସେମାନଙ୍କ ଅଶୁଚିତା ମଧ୍ୟରେ ସେମାନଙ୍କ ସହିତ ବାସ କରେ ଯେଉଁ ସମାଗମ-ତମ୍ବୁ, ତାହା ନିମନ୍ତେ ସେହି ପ୍ରକାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ଆଉ, ସେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ନିମନ୍ତେ ପବିତ୍ର ସ୍ଥାନରେ ପ୍ରବେଶ କରିବା ସମୟଠାରୁ ଯେପର୍ଯ୍ୟନ୍ତ ବାହାର ହୋଇ ନାହିଁ; ପୁଣି, ଆପଣା ନିମନ୍ତେ ଓ ଆପଣା ଘର ନିମନ୍ତେ ଓ ଇସ୍ରାଏଲର ସମସ୍ତ ସମାଜ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରି ନାହିଁ, ସେପର୍ଯ୍ୟନ୍ତ ସମାଗମ-ତମ୍ବୁରେ କୌଣସି ମନୁଷ୍ୟ ରହିବ ନାହିଁ, ");
INSERT INTO ory_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ଆଉ, ସେ ବାହାର ହୋଇ ସମ୍ମୁଖସ୍ଥ ବେଦି ପାଖକୁ ଯାଇ ତହିଁ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ପୁଣି ସେହି ଗୋବତ୍ସର କିଛି ରକ୍ତ ଓ ଛାଗର କିଛି ରକ୍ତ ନେଇ ବେଦିର ଶୃଙ୍ଗ ଉପରେ ଚାରିଆଡ଼େ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ପୁଣି, ସେ ରକ୍ତରୁ କିଛି ନେଇ ଅଙ୍ଗୁଳି ଦ୍ୱାରା ସାତ ଥର ଛିଞ୍ଚି ତାହା ଶୁଚି କରିବ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଅଶୁଚିତାରୁ ତାହା ଶୁଚି କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","ଏହି ପ୍ରକାରେ ସେ ପବିତ୍ର ସ୍ଥାନ, ସମାଗମ-ତମ୍ବୁ ଓ ବେଦି ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରି ସାରିଲା ଉତ୍ତାରେ ସେହି ଜୀଅନ୍ତା ଛାଗକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ପୁଣି, ହାରୋଣ ସେହି ଜୀଅନ୍ତା ଛାଗର ମସ୍ତକରେ ଆପଣା ଦୁଇ ହସ୍ତର ନିର୍ଭର ଦେଇ ତାହା ଉପରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ଅପରାଧ, ସମସ୍ତ ଅଧର୍ମ ଓ ସମସ୍ତ ପାପ ସ୍ୱୀକାର କରିବ; ଆଉ, ତାହାସବୁ ସେହି ଛାଗର ମସ୍ତକରେ ଅର୍ପଣ କରି ପ୍ରସ୍ତୁତ ଥିବା ମନୁଷ୍ୟ ହସ୍ତରେ ତାହାକୁ ପ୍ରାନ୍ତରକୁ ପଠାଇଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ତହିଁରେ ସେହି ଛାଗ ଆପଣା ଉପରେ ସେମାନଙ୍କର ସମସ୍ତ ଅପରାଧ ବୋହି ନରଶୂନ୍ୟ ଦେଶକୁ ନେବ; ଆଉ ସେ ସେହି ସ୍ଥାନରେ ସେହି ଛାଗକୁ ଛାଡ଼ିଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ତହୁଁ ହାରୋଣ ସମାଗମ-ତମ୍ବୁକୁ ଆସି ପବିତ୍ର ସ୍ଥାନରେ ପ୍ରବେଶ କରିବା ସମୟରେ ଯେଉଁ ଶୁଭ୍ର ବସ୍ତ୍ର ପିନ୍ଧିଥିଲା, ତାହା ପାଲଟି ସେହି ସ୍ଥାନରେ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ତହିଁ ଉତ୍ତାରେ ସେ କୌଣସି ପବିତ୍ର ସ୍ଥାନରେ ଆପଣା ଶରୀର ଜଳରେ ଧୌତ କରି ନିଜ ବସ୍ତ୍ର ପିନ୍ଧି ବାହାରକୁ ଆସିବ; ପୁଣି, ଆପଣାର ହୋମବଳି ଓ ଲୋକମାନଙ୍କର ହୋମବଳି ଉତ୍ସର୍ଗ କରି ଆପଣା ନିମନ୍ତେ ଓ ଲୋକମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ଆଉ, ସେ ପାପାର୍ଥକ ବଳିର ମେଦ ବେଦିରେ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ପୁଣି, ଯେଉଁ ଲୋକ ତ୍ୟାଗର ଛାଗକୁ ଛାଡ଼ିଦିଏ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇ ଜଳରେ ସ୍ନାନ କରିବ, ତହିଁ ଉତ୍ତାରେ ଛାଉଣିକୁ ଆସିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ପୁଣି, ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ଯେଉଁ ଗୋବତ୍ସର ଓ ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ଯେଉଁ ଛାଗର ରକ୍ତ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ନିମନ୍ତେ ପବିତ୍ର ସ୍ଥାନକୁ ଅଣାଯାଇ ଥିଲା, ଲୋକମାନେ ସେଗୁଡ଼ିକୁ ଛାଉଣି ବାହାରକୁ ନେଇଯାଇ ସେଗୁଡ଼ିକର ଚର୍ମ, ମାଂସ ଓ ମଳ ଅଗ୍ନିରେ ଦଗ୍ଧ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ପୁଣି ଯେଉଁ ଲୋକ ତାହା ଦଗ୍ଧ କରିବ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଜଳରେ ସ୍ନାନ କରିବ, ତହିଁ ଉତ୍ତାରେ ସେ ଛାଉଣି ଭିତରକୁ ଆସିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଏହା ଅନନ୍ତକାଳୀନ ବିଧି ହେବ; ସପ୍ତମ ମାସରେ ଓ ସେହି ମାସର ଦଶମ ଦିନରେ ସ୍ୱଦେଶୀୟ ବା ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସୀ ବିଦେଶୀୟ ଲୋକ ହେଉ, ତୁମ୍ଭେମାନେ କୌଣସି ପ୍ରକାର ଖାଦ୍ୟ ଖାଇବ ନାହିଁ ଓ କୌଣସି ପ୍ରକାର କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","କାରଣ ସେହି ଦିନରେ ତୁମ୍ଭମାନଙ୍କୁ ଶୁଚି କରିବା ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କ ପାଇଁ ପ୍ରାୟଶ୍ଚିତ୍ତ କରାଯିବ; ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଆପଣା ଆପଣାର ସକଳ ପାପରୁ ପରିଷ୍କୃତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ମହା ବିଶ୍ରାମ ଦିନ, ତୁମ୍ଭେମାନେ କୌଣସି ପ୍ରକାର ଖାଦ୍ୟ ଖାଇବ ନାହିଁ; ଏହା ଅନନ୍ତକାଳୀନ ବିଧି। ");
INSERT INTO ory_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ପୁଣି, ପିତାର ବଦଳେ ଯାଜକତ୍ୱ ପଦରେ ଯେ ଅଭିଷିକ୍ତ ଓ ନିଯୁକ୍ତ ହେବ, ସେହି ଯାଜକ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ ଓ ଶୁଭ୍ର ବସ୍ତ୍ର, ଅର୍ଥାତ୍‍, ପବିତ୍ର ବସ୍ତ୍ରସବୁ ପିନ୍ଧିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ଆଉ, ସେ ପବିତ୍ର ସ୍ଥାନ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ସମାଗମ-ତମ୍ବୁ ଓ ବେଦି ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ଆଉ, ସେ ଯାଜକଗଣ ନିମନ୍ତେ ଓ ସମାଜର ସମସ୍ତ ଲୋକ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ନିମନ୍ତେ ସେମାନଙ୍କର ସମସ୍ତ ପାପ ସକାଶୁ ବର୍ଷ ମଧ୍ୟରେ ଏକ ଥର ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବାର ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅନନ୍ତକାଳୀନ ବିଧି ହେବ।” ତହୁଁ ହାରୋଣ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“ତୁମ୍ଭେ ହାରୋଣକୁ, ତାହାର ପୁତ୍ରଗଣଙ୍କୁ ଓ ଇସ୍ରାଏଲର ସମସ୍ତ ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ସଦାପ୍ରଭୁ ଏହି ଆଜ୍ଞା ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ଇସ୍ରାଏଲ ବଂଶରୁ ଜାତ ଯେକେହି ଗୋରୁ, କି ମେଷ, କି ଛାଗ ଛାଉଣି ମଧ୍ୟରେ କିମ୍ବା ଛାଉଣି ବାହାରେ ବଧ କରେ, ");
INSERT INTO ory_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ଆବାସ ସମ୍ମୁଖରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉପହାର ଉତ୍ସର୍ଗ କରିବା ପାଇଁ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟକୁ ତାହା ନ ଆଣେ, ତାହା ପ୍ରତି ରକ୍ତପାତର ଅପରାଧ ଗଣିତ ହେବ; ସେ ରକ୍ତପାତ କରିଅଛି; ସେହି ମନୁଷ୍ୟ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ଏହେତୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଆପଣାମାନଙ୍କର ଯେଉଁ ଯେଉଁ ବଳି କ୍ଷେତ୍ରକୁ ନିଅନ୍ତି, ସେହି ସମସ୍ତ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାରରେ ଯାଜକ ନିକଟକୁ ଆଣି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଉତ୍ସର୍ଗ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ପୁଣି, ଯାଜକ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟରେ ସଦାପ୍ରଭୁଙ୍କ ବେଦି ଉପରେ ସେହି ରକ୍ତ ଛିଞ୍ଚିବ, ଆଉ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମେଦ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ତହିଁରେ ସେମାନେ ଯେଉଁ ଛାଗ ଦେବତାମାନଙ୍କ ସହିତ ବ୍ୟଭିଚାର କରୁଅଛନ୍ତି, ସେମାନଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆଉ ବଳିଦାନ କରିବେ ନାହିଁ। ଏହା ସେମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","ଆଉ, ତୁମ୍ଭେ ସେମାନଙ୍କୁ କହିବ, ଇସ୍ରାଏଲ ବଂଶରୁ ଜାତ କୌଣସି ଲୋକ ଅବା ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସୀ କୌଣସି ବିଦେଶୀ ଲୋକ ଯଦି ହୋମ କି ବଳିଦାନ କରେ, ");
INSERT INTO ory_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବା ପାଇଁ ତାହା ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟକୁ ନ ଆଣେ, ତେବେ ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ଆଉ, ଇସ୍ରାଏଲ ବଂଶଜାତ କୌଣସି ଲୋକ, ଅବା ସେମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସୀ କୌଣସି ବିଦେଶୀ ଲୋକ, ଯଦି କୌଣସି ପ୍ରକାର ରକ୍ତ ଭୋଜନ କରେ, ତେବେ ଆମ୍ଭେ ସେହି ରକ୍ତ ଭୋଜନକାରୀ ବ୍ୟକ୍ତି ବିରୁଦ୍ଧରେ ଆପଣା ମୁଖ ରଖିବା ଓ ତାହାର ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ତାହାକୁ ଉଚ୍ଛିନ୍ନ କରିବା; ");
INSERT INTO ory_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","କାରଣ ରକ୍ତରେ ପ୍ରାଣୀର ପ୍ରାଣ ଥାଏ; ପୁଣି, ତୁମ୍ଭମାନଙ୍କ ପ୍ରାଣ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବାକୁ ଆମ୍ଭେ ତାହା ବେଦି ଉପରେ ତୁମ୍ଭମାନଙ୍କୁ ଦେଇଅଛୁ, ଯେହେତୁ ପ୍ରାଣର ଗୁଣରେ ରକ୍ତ ହିଁ ପ୍ରାୟଶ୍ଚିତ୍ତ କରେ। ");
INSERT INTO ory_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ଏହେତୁ ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହିଲୁ, ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି ବ୍ୟକ୍ତି ରକ୍ତ ଭୋଜନ କରିବ ନାହିଁ ଓ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସୀ କୌଣସି ବିଦେଶୀ ଲୋକ ରକ୍ତ ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ଆଉ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ କୌଣସି ଲୋକ ଅବା ସେମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସୀ କୌଣସି ବିଦେଶୀ ଲୋକ ଯଦି ଶିକାରରେ କୌଣସି ଖାଦ୍ୟ ଯୋଗ୍ୟ ପଶୁକୁ ବା ପକ୍ଷୀକୁ ବଧ କରେ, ତେବେ ସେ ତାହାର ରକ୍ତ ଢାଳି ଧୂଳିରେ ଢାଙ୍କିବ। ");
INSERT INTO ory_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","କାରଣ ସବୁ ପ୍ରାଣୀର ପ୍ରାଣ ସମ୍ବନ୍ଧରେ ରକ୍ତ ହିଁ ତାହାର ପ୍ରାଣ ଅଟେ; ଏହେତୁ ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହିଲୁ, ତୁମ୍ଭେମାନେ କୌଣସି ପ୍ରକାର ପ୍ରାଣୀର ରକ୍ତ ଭୋଜନ କରିବ ନାହିଁ, ଯେହେତୁ ସକଳ ପ୍ରାଣୀର ରକ୍ତ ହିଁ ତାହାର ପ୍ରାଣ; ଯେକେହି ତାହା ଭୋଜନ କରିବ, ସେ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","ଆଉ, ସ୍ୱଦେଶୀ କି ବିଦେଶୀ ମଧ୍ୟରୁ ଯେକେହି ସ୍ୱୟଂମୃତ କିଅବା ବିଦୀର୍ଣ୍ଣ ପଶୁ ଭୋଜନ କରେ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୌତ କରି ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ; ତହିଁ ଉତ୍ତାରେ ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ମାତ୍ର ଯଦି ସେ (ବସ୍ତ୍ର) ଧୌତ ନ କରେ କି ସ୍ନାନ ନ କରେ, ତେବେ ସେ ଆପଣା ଅପରାଧ ବୋହିବ।” ");
INSERT INTO ory_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ତୁମ୍ଭେମାନେ ଯେଉଁ ମିସର ଦେଶରେ ବାସ କଲ, ସେହି ଦେଶର ଆଚରଣ ଅନୁସାରେ ଆଚରଣ କରିବ ନାହିଁ; ପୁଣି, ଯେଉଁ କିଣାନ ଦେଶକୁ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ନେଇ ଯାଉଅଛୁ, ସେହି ଦେଶର ଆଚରଣ ଅନୁସାରେ ଆଚରଣ କରିବ ନାହିଁ ଓ ସେମାନଙ୍କ ବିଧି ଅନୁସାରେ ଚ଼ାଲିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ତୁମ୍ଭେମାନେ ଆମ୍ଭର ଶାସନ ମାନ୍ୟ କରିବ ଓ ଆମ୍ଭର ବିଧି ପାଳନ କରିବ ଓ ତଦନୁସାରେ ଆଚରଣ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ଏଥିନିମନ୍ତେ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଧି ଓ ଆମ୍ଭର ଶାସନ ପାଳନ କରିବ; ମନୁଷ୍ୟ ତାହା କଲେ, ତହିଁରେ ହିଁ ସେ ବଞ୍ଚିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","ତୁମ୍ଭମାନଙ୍କର କେହି ଆପଣା ନିକଟ-କୁଟୁମ୍ବ ମଧ୍ୟରୁ କାହାରି ଆବରଣୀୟ ଅନାବୃତ କରିବାକୁ ଯିବ ନାହିଁ, ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ତୁମ୍ଭେ ଆପଣା ପିତାର ଆବରଣୀୟ ଅବା ଆପଣା ମାତାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; ସେ ତୁମ୍ଭର ମାତା; ତୁମ୍ଭେ ତାହାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ତୁମ୍ଭେ ଆପଣା ପିତୃଭାର୍ଯ୍ୟାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; ତାହା ତୁମ୍ଭ ପିତାର ଆବରଣୀୟ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ତୁମ୍ଭେ ଆପଣା ଭଗିନୀ, ଅର୍ଥାତ୍‍, ତୁମ୍ଭ ପିତୃକନ୍ୟା କି ମାତୃକନ୍ୟା, ସେ ଗୃହରେ ଜନ୍ମ ହେଉ କି ଅନ୍ୟତ୍ର ଜନ୍ମ ହେଉ, ତାହାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ତୁମ୍ଭେ ଆପଣା ପୌତ୍ରୀର କି ଦୌହିତ୍ରୀର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; କାରଣ ତାହା ତୁମ୍ଭ ନିଜର ଆବରଣୀୟ। ");
INSERT INTO ory_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ତୁମ୍ଭେ ଆପଣା ସାବତ ଭଉଣୀର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; କାରଣ ସେ ତୁମ୍ଭ ପିତାଠାରୁ ଜନ୍ମିଅଛି, ସେ ତୁମ୍ଭର ଭଗିନୀ, ତୁମ୍ଭେ ତାହାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ତୁମ୍ଭେ ଆପଣା ପିତୃଭଗିନୀର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ, ସେ ତୁମ୍ଭର ପିତୃଗୋତ୍ରରେ ଜନ୍ମ ହୋଇଛି। ");
INSERT INTO ory_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ତୁମ୍ଭେ ଆପଣା ମାତୃଭଗିନୀର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ, କାରଣ ସେ ତୁମ୍ଭର ମାତୃଗୋତ୍ରରେ ଜନ୍ମ ହୋଇଛି। ");
INSERT INTO ory_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ତୁମ୍ଭେ ଆପଣା ପିତୃଭ୍ରାତାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ, ତୁମ୍ଭେ ତାହାର ଭାର୍ଯ୍ୟା ନିକଟକୁ ଯିବ ନାହିଁ, କାରଣ ସେ ତୁମ୍ଭର ପିତୃବ୍ୟପତ୍ନୀ। ");
INSERT INTO ory_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ତୁମ୍ଭେ ଆପଣା ପୁତ୍ରବଧୂର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; ସେ ତୁମ୍ଭର ପୁତ୍ରବଧୂ; ତୁମ୍ଭେ ତାହାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ତୁମ୍ଭେ ଆପଣା ଭ୍ରାତୃଭାର୍ଯ୍ୟାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; ତାହା ତୁମ୍ଭ ଭ୍ରାତାର ଆବରଣୀୟ। ");
INSERT INTO ory_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ତୁମ୍ଭେ କୌଣସି ସ୍ତ୍ରୀର ଓ ତାହାର କନ୍ୟାର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; ତୁମ୍ଭେ ତାହାର ପୌତ୍ରୀର କି ଦୌହିତ୍ରୀର ଆବରଣୀୟ ଅନାବୃତ କରିବା ପାଇଁ ତାହାକୁ ଗ୍ରହଣ କରିବ ନାହିଁ; ସେମାନେ ଗୋତ୍ରରେ ଜନ୍ମ ହୋଇଛନ୍ତି; ଏହା ଦୁଷ୍ଟତା ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ଆଉ ଭଗିନୀ ଜୀବିତା ଥାଉ ଥାଉ ତୁମ୍ଭେ ତାହା ପାର୍ଶ୍ୱରେ ତାହାର ସପତ୍ନୀ ରୂପେ ଆବରଣୀୟ ଅନାବୃତ କରିବା ପାଇଁ ତାʼର ଭଗିନୀକୁ ଗ୍ରହଣ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ପୁଣି, କୌଣସି ସ୍ତ୍ରୀ ତାହାର ରଜଧର୍ମ ହେତୁ ଅଶୁଚି ଥିବା ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେ ତାହାର ଆବରଣୀୟ ଅନାବୃତ କରିବା ନିମନ୍ତେ ତାହା ନିକଟକୁ ଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ଆଉ, ତୁମ୍ଭେ ଆପଣାକୁ ଅଶୁଚି କରିବା ନିମନ୍ତେ ପ୍ରତିବାସୀର ଭାର୍ଯ୍ୟା ନିକଟକୁ ଗମନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","ତୁମ୍ଭେ ଆପଣା ବଂଶଜାତ କାହାକୁ ହିଁ, ମୋଲକ୍‍ ଦେବତାର ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନି ମଧ୍ୟଦେଇ ଗମନ କରାଇବାକୁ ଦେବ ନାହିଁ, କିଅବା ତୁମ୍ଭେ ଆପଣା ପରମେଶ୍ୱରଙ୍କ ନାମ ଅପବିତ୍ର କରିବ ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","ତୁମ୍ଭେ ସ୍ତ୍ରୀର ନ୍ୟାୟ ପୁରୁଷ ସହିତ ସଂସର୍ଗ କରିବ ନାହିଁ, ତାହା ଘୃଣାଯୋଗ୍ୟ କର୍ମ। ");
INSERT INTO ory_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ତୁମ୍ଭେ ଆପଣାକୁ ଅଶୁଚି କରିବା ନିମନ୍ତେ କୌଣସି ପଶୁଠାରେ ଗମନ କରିବ ନାହିଁ; କିଅବା କୌଣସି ସ୍ତ୍ରୀ ଆପଣା ସହିତ ସଂସର୍ଗ କରାଇବାକୁ କୌଣସି ପଶୁର ସମ୍ମୁଖରେ ଠିଆ ହେବ ନାହିଁ; ଏହା ତ ପାଷାଣ୍ଡତା। ");
INSERT INTO ory_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ତୁମ୍ଭେମାନେ ଏହିସବୁ ମଧ୍ୟରୁ କୌଣସି କ୍ରିୟା ଦ୍ୱାରା ଆପଣାମାନଙ୍କୁ ଅଶୁଚି କର ନାହିଁ; କାରଣ ଆମ୍ଭେ ଯେଉଁ ଦେଶୀୟ ଲୋକମାନଙ୍କୁ ତୁମ୍ଭ ସମ୍ମୁଖରୁ ଦୂର କରୁଅଛୁ, ସେମାନେ ଏହିସବୁ କ୍ରିୟା ଦ୍ୱାରା ଅଶୁଚି ହୋଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ପୁଣି, ଦେଶ ହିଁ ଅଶୁଚି ହୋଇଅଛି; ଏହେତୁ ଆମ୍ଭେ ତାହାର ଅପରାଧ ତାହାକୁ ଭୋଗ କରାଉଅଛୁ ଓ ସେହି ଦେଶ ତାହାର ନିବାସୀମାନଙ୍କୁ ଉଦ୍ଗାର କରୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ଏନିମନ୍ତେ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଧି ଓ ବ୍ୟବସ୍ଥା ପାଳନ କରିବ, ସ୍ୱଦେଶୀୟ ବା ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ ବିଦେଶୀୟ ହେଉ, ତୁମ୍ଭେମାନେ ଏହି ସକଳ ଘୃଣାଯୋଗ୍ୟ କର୍ମ ମଧ୍ୟରୁ କୌଣସି କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","କାରଣ ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବବର୍ତ୍ତୀ ଦେଶ ନିବାସୀମାନେ ଏହିସବୁ ଘୃଣାଯୋଗ୍ୟ କର୍ମ କରିଅଛନ୍ତି ଓ ଦେଶ ଅଶୁଚି ହୋଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ତୁମ୍ଭେମାନେ ତାହା ଅଶୁଚି କଲେ, ସେହି ଦେଶ ଯେପରି ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବବର୍ତ୍ତୀ ନିବାସୀ ଲୋକମାନଙ୍କୁ ଉଦ୍ଗାର କଲା, ସେହିପରି ତୁମ୍ଭମାନଙ୍କୁ ମଧ୍ୟ ଉଦ୍ଗାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ତେଣୁ ଯେଉଁମାନେ ଏହିସବୁ ଘୃଣାଯୋଗ୍ୟ କର୍ମ ମଧ୍ୟରୁ କୌଣସି କର୍ମ କରିବେ, ସେହି କର୍ମକାରୀ ପ୍ରାଣୀମାନେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ଏଣୁକରି ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବରେ ଯେଉଁସବୁ ଘୃଣାଯୋଗ୍ୟ କର୍ମ କରାଯାଇଅଛି, ସେହି ସବୁ ମଧ୍ୟରୁ କୌଣସି କର୍ମ କରି ତଦ୍ଦ୍ୱାରା ଆପଣାମାନଙ୍କୁ ଅଶୁଚି କରିବ ନାହିଁ ଓ ଆମ୍ଭର ବିଧି ମାନ୍ୟ କରି ପାଳନ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀକୁ କୁହ, ତୁମ୍ଭେମାନେ ପବିତ୍ର ହେବ, କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ପବିତ୍ର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ମାତାକୁ ଓ ଆପଣା ଆପଣା ପିତାକୁ ଭୟ କରିବ; ପୁଣି, ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଶ୍ରାମ ଦିନ ପାଳନ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","ଆଉ, ତୁମ୍ଭେମାନେ ପ୍ରତିମାଗଣର ପଶ୍ଚାଦ୍‍ଗାମୀ ହୁଅ ନାହିଁ ଓ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଛାଞ୍ଚରେ ଢଳା ଦେବତା ନିର୍ମାଣ କର ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","ପୁଣି, ଯଦି ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ କର, ତେବେ ଗ୍ରାହ୍ୟ ହେବା ନିମନ୍ତେ ତାହା ବଳିଦାନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ବଳିଦାନ ଦିନ ଓ ତହିଁ ଆରଦିନ ତାହା ଭୋଜନ କରାଯିବ; ପୁଣି, ତୃତୀୟ ଦିନ ପର୍ଯ୍ୟନ୍ତ ତହିଁରୁ କିଛି ଅବଶିଷ୍ଟ ରହିଲେ, ତାହା ଦଗ୍ଧ କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ଯଦି ତୃତୀୟ ଦିନ ତହିଁରୁ କିଛି ଭୋଜନ କରାଯିବ, ତେବେ ତାହା ଘୃଣାଯୋଗ୍ୟ ଓ ଅଗ୍ରାହ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ଆଉ, ତହିଁର ଭୋଜନକାରୀ ନିଜ ଅପରାଧ ବୋହିବ; କାରଣ ସେ ସଦାପ୍ରଭୁଙ୍କ ପବିତ୍ର ବସ୍ତୁ ଅପବିତ୍ର କରିଅଛି; ଏଣୁକରି ସେହି ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","ଆଉ, ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ଭୂମିର ଶସ୍ୟ କାଟିବା ବେଳେ ତୁମ୍ଭେ ନିଜ କ୍ଷେତ୍ରର କୋଣ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ କାଟିବ ନାହିଁ, କିଅବା ତୁମ୍ଭେ ଆପଣା କ୍ଷେତ୍ରରେ ଛାଡ଼ିଥିବା ଶସ୍ୟ ସାଉଣ୍ଟିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ପୁଣି, ତୁମ୍ଭେ ଆପଣା ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ର ସମ୍ପୂର୍ଣ୍ଣ ଖୁଣ୍ଟି ତୋଳିବ ନାହିଁ, କିଅବା ତୁମ୍ଭେ ଆପଣା ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରର ପଡ଼ିଲା ଫଳ ସାଉଣ୍ଟିବ ନାହିଁ; ତୁମ୍ଭେ ତାହା ଦରିଦ୍ର ଓ ବିଦେଶୀମାନଙ୍କ ନିମନ୍ତେ ଛାଡ଼ିଦେବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","ତୁମ୍ଭେମାନେ ଚୋରି କରିବ ନାହିଁ, କିଅବା ପ୍ରବଞ୍ଚନା କରିବ ନାହିଁ, କି ପରସ୍ପର ମିଥ୍ୟା କହିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ଆଉ, ତୁମ୍ଭେମାନେ ଆମ୍ଭ ନାମ ନେଇ ମିଥ୍ୟା ଶପଥ କରିବ ନାହିଁ, ତାହା କଲେ, ତୁମ୍ଭେ ଆପଣା ପରମେଶ୍ୱରଙ୍କ ନାମ ଅପବିତ୍ର କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","ତୁମ୍ଭେ ଆପଣା ପ୍ରତିବାସୀ ପ୍ରତି ଅନ୍ୟାୟ କରିବ ନାହିଁ ଓ ଅପହରଣ କରିବ ନାହିଁ; ପୁଣି, ବେତନଜୀବୀର ବେତନ ରାତ୍ରିଠାରୁ ସକାଳ ଯାଏ ତୁମ୍ଭ ପାଖରେ ରହିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ତୁମ୍ଭେ ବଧିରକୁ ଅଭିଶାପ ଦେବ ନାହିଁ ଓ ଅନ୍ଧ ଆଗରେ ଝୁଣ୍ଟିବାର ଦ୍ରବ୍ୟ ରଖିବ ନାହିଁ, ମାତ୍ର ତୁମ୍ଭେ ଆପଣା ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","ତୁମ୍ଭେମାନେ ବିଚାରରେ ଅଧର୍ମ କରିବ ନାହିଁ; ତୁମ୍ଭେ ଦରିଦ୍ରର ମୁଖାପେକ୍ଷା କରିବ ନାହିଁ, କିଅବା ଧନୀର ସମ୍ଭ୍ରମ କରିବ ନାହିଁ, ମାତ୍ର ତୁମ୍ଭେ ଧର୍ମରେ ଆପଣା ପ୍ରତିବାସୀର ବିଚାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ତୁମ୍ଭେ ଖଚୁଆ ହୋଇ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଏଣେତେଣେ ବୁଲିବ ନାହିଁ; କିଅବା ତୁମ୍ଭ ପ୍ରତିବାସୀର ରକ୍ତ ବିରୁଦ୍ଧରେ ଠିଆ ହେବ ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","ତୁମ୍ଭେ ମନେ ମନେ ଆପଣା ଭାଇକୁ ଘୃଣା କରିବ ନାହିଁ; ତୁମ୍ଭେ ନିତାନ୍ତ ଆପଣା ପ୍ରତିବାସୀକୁ ଅନୁଯୋଗ କରିବ, ତହିଁରେ ତୁମ୍ଭେ ତାହାର ଅପରାଧ ବୋହିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ତୁମ୍ଭେ ଆପଣା ଲୋକମାନଙ୍କ ସନ୍ତାନଗଣକୁ ପ୍ରତିହିଂସା କି ଦ୍ୱେଷ କରିବ ନାହିଁ, ବରଞ୍ଚ ତୁମ୍ଭେ ଆପଣା ପ୍ରତିବାସୀକୁ ଆତ୍ମତୁଲ୍ୟ ପ୍ରେମ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","ତୁମ୍ଭେମାନେ ଆମ୍ଭର ସକଳ ବିଧି ପାଳନ କରିବ; ତୁମ୍ଭେ ଭିନ୍ନଜାତୀୟ ପଶୁ ସହିତ ଆପଣା ପଶୁମାନଙ୍କୁ ସଙ୍ଗମ କରିବାକୁ ଦେବ ନାହିଁ; ତୁମ୍ଭେ ଆପଣା କ୍ଷେତ୍ରରେ ମିଶ୍ରିତ ବୀଜ ବୁଣିବ ନାହିଁ; କିଅବା ଦୁଇ ପ୍ରକାର ସୂତ୍ରମିଶ୍ରିତ ବସ୍ତ୍ର ଦେହରେ ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ପୁଣି, ମୂଲ୍ୟ ଦ୍ୱାରା ଅବା ଅନ୍ୟ ରୂପେ ମୁକ୍ତ ନୁହେଁ, ଏପରି ଯେ ସ୍ୱାମୀ ପ୍ରତି ବାଗ୍‍ଦତ୍ତା ଦାସୀ, ତାହା ସହିତ ଯଦି କେହି ଶୟନ କରେ, ତେବେ ସେମାନେ ଦଣ୍ଡନୀୟ ହେବେ; ସେମାନଙ୍କର ପ୍ରାଣଦଣ୍ଡ ହେବ ନାହିଁ, କାରଣ ସେ ମୁକ୍ତ ନୁହେଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ପୁଣି, ସେ ପୁରୁଷ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସମାଗମ-ତମ୍ବୁର ଦ୍ୱାର ନିକଟକୁ ଆପଣାର ଦୋଷାର୍ଥକ ବଳି, ଅର୍ଥାତ୍‍, ଦୋଷାର୍ଥକ ମେଷ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ଆଉ, ଯାଜକ ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ସେହି ଦୋଷାର୍ଥକ ମେଷ ଦ୍ୱାରା, ସେ ଯେଉଁ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ ସକାଶେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ତହିଁରେ ସେ ଯେଉଁ ପାପ କରିଅଛି, ତାହାର ସେହି ପାପ କ୍ଷମା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","ଆଉ, ତୁମ୍ଭେମାନେ ଦେଶରେ ପ୍ରବେଶ କରି ଭୋଜନାର୍ଥେ ନାନା ପ୍ରକାର ବୃକ୍ଷ ରୋପଣ କଲେ, ତହିଁର ଫଳକୁ ଅସୁନ୍ନତ ବୋଲି ଜ୍ଞାନ କରିବ, ତାହାସବୁ ତିନି ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅସୁନ୍ନତ ସ୍ୱରୂପ ହେବ; ତାହା ଭୋଜନ କରାଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ମାତ୍ର ଚତୁର୍ଥ ବର୍ଷରେ ତହିଁର ସମସ୍ତ ଫଳ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରଶଂସାର୍ଥକ ଉପହାର ରୂପେ ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ପୁଣି, ପଞ୍ଚମ ବର୍ଷରେ ତୁମ୍ଭେମାନେ ତହିଁର ଫଳ ଭୋଜନ କରିବ, ତହିଁରେ ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ପ୍ରଚୁର ଫଳ ଫଳିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","ତୁମ୍ଭେମାନେ ରକ୍ତ ସହିତ କୌଣସି ଦ୍ରବ୍ୟ ଭୋଜନ କରିବ ନାହିଁ; ତୁମ୍ଭେମାନେ ଗଣକତା ବା ଶୁଭାଶୁଭ କହିବାର ବିଦ୍ୟା ବ୍ୟବହାର କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ମସ୍ତକର କୋଣସବୁ ଗୋଲାକାର କରିବ ନାହିଁ, କିଅବା ଆପଣା ଆପଣା ଦାଢ଼ିର କୋଣ ମୁଣ୍ଡନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ପୁଣି, ତୁମ୍ଭେମାନେ ମୃତ ଲୋକ ନିମନ୍ତେ ଆପଣା ଆପଣା ଶରୀରରେ ଅସ୍ତ୍ରାଘାତ କରିବ ନାହିଁ, ଅବା ଦେହରେ ଚିତା କୁଟାଇବ ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","ତୁମ୍ଭେ ଆପଣା କନ୍ୟାକୁ ବେଶ୍ୟା କରି ଅପବିତ୍ର କର ନାହିଁ; କଲେ, ଦେଶ ବେଶ୍ୟାବୃତ୍ତିରେ ପତିତ ହେବ ଓ ଦେଶ ଦୁଷ୍ଟତାରେ ପରିପୂର୍ଣ୍ଣ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଶ୍ରାମ ଦିନ ପାଳନ କରିବ ଓ ଆମ୍ଭର ପବିତ୍ର ସ୍ଥାନକୁ ସମାଦର କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ତୁମ୍ଭେମାନେ ଭୂତୁଡ଼ିଆ କି ଗୁଣିଆମାନଙ୍କର ଅନୁସରଣ କର ନାହିଁ; ସେମାନଙ୍କ ଦ୍ୱାରା ଅପବିତ୍ର ହେବା ନିମନ୍ତେ ସେମାନଙ୍କର ଅନ୍ୱେଷଣ କର ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","ତୁମ୍ଭେ ପକ୍ୱକେଶ ପ୍ରାଚୀନଙ୍କ ସମ୍ମୁଖରେ ଉଠି ଠିଆ ହେବ ଓ ବୃଦ୍ଧ ଲୋକକୁ ସମାଦର କରିବ; ପୁଣି, ଆପଣା ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","ଆଉ, ଯଦି କୌଣସି ବିଦେଶୀ ତୁମ୍ଭମାନଙ୍କ ଦେଶରେ ତୁମ୍ଭ ସହିତ ବାସ କରେ, ତେବେ ତୁମ୍ଭେମାନେ ତାହା ପ୍ରତି ଉପଦ୍ରବ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ଯେପରି ତୁମ୍ଭମାନଙ୍କର ସ୍ୱଦେଶୀୟ ଲୋକ ସେପରି ତୁମ୍ଭମାନଙ୍କ ସହବାସୀ ବିଦେଶୀୟ ଲୋକ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ହେବ, ପୁଣି ତୁମ୍ଭେ ତାହାକୁ ଆତ୍ମତୁଲ୍ୟ ପ୍ରେମ କରିବ; କାରଣ ମିସର ଦେଶରେ ତୁମ୍ଭେମାନେ ବିଦେଶୀ ଥିଲ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","ତୁମ୍ଭେମାନେ ବିଚାର ଅବା ମାପ ଅବା ତୌଲ କିଅବା ପରିମାଣ ବିଷୟରେ ଅଧର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ଯଥାର୍ଥ ଦଣ୍ଡି, ଯଥାର୍ଥ ବଟଖରା, ଯଥାର୍ଥ ଐଫା ଓ ଯଥାର୍ଥ ହିନ୍‍, ତୁମ୍ଭମାନଙ୍କର ହେବ; ଯେ ମିସର ଦେଶରୁ ତୁମ୍ଭମାନଙ୍କୁ ବାହାର କରି ଆଣିଲେ, ଆମ୍ଭେ ସେହି ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ଏହେତୁ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ସମସ୍ତ ବିଧି ଓ ଆମ୍ଭର ସମସ୍ତ ଶାସନ ମାନ୍ୟ କରି ପାଳନ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଆହୁରି କହିବ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଅବା ଇସ୍ରାଏଲ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ ବିଦେଶୀମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି ଲୋକ ଯଦି ଆପଣା ବଂଶର କାହାକୁ ମୋଲକ୍‍ ଦେବତାର ଉଦ୍ଦେଶ୍ୟରେ ପ୍ରଦାନ କରେ, ତେବେ ତାହାର ନିଶ୍ଚୟ ପ୍ରାଣଦଣ୍ଡ ହେବ ଓ ଦେଶୀୟ ଲୋକମାନେ ତାହାକୁ ପଥର ମାରି ବଧ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ପୁଣି, ଆମ୍ଭେ ମଧ୍ୟ ସେହି ମନୁଷ୍ୟ ବିରୁଦ୍ଧରେ ଆପଣା ମୁଖ ରଖିବା ଓ ତାହାର ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ତାହାକୁ ଉଚ୍ଛିନ୍ନ କରିବା; କାରଣ ସେ ଆମ୍ଭର ପବିତ୍ର ସ୍ଥାନ ଅପବିତ୍ର କରିବାକୁ ଓ ଆମ୍ଭର ପବିତ୍ର ନାମ ଅପବିତ୍ର କରିବାକୁ ମୋଲକ୍‍ ଦେବତା ଉଦ୍ଦେଶ୍ୟରେ ଆପଣା ସନ୍ତାନକୁ ଦେଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ଆଉ, ଯେଉଁ ସମୟରେ ସେହି ଲୋକ ଆପଣା ସନ୍ତାନକୁ ମୋଲକ୍‍ ଦେବତା ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରେ, ସେହି ସମୟରେ ଯଦି ଦେଶୀୟ ଲୋକମାନେ କୌଣସି ରୂପେ ତାହା ପ୍ରତି ଚକ୍ଷୁ ବନ୍ଦ କରନ୍ତି ଓ ତାହାକୁ ବଧ ନ କରନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ତେବେ ଆମ୍ଭେ ସେହି ଲୋକ ଓ ତାହାର ପରିବାରକୁ ଦଣ୍ଡ ଦେବା; ପୁଣି, ତାହାକୁ ଓ ମୋଲକ୍‍ ଦେବତା ସହିତ ବ୍ୟଭିଚାର କରିବା ନିମନ୍ତେ ତାହାର ପଶ୍ଚାଦ୍‍ଗାମୀ ବ୍ୟଭିଚାରୀ ସମସ୍ତଙ୍କୁ ସେମାନଙ୍କ ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ କରିବା। ");
INSERT INTO ory_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","ଆଉ, ଯେଉଁ ପ୍ରାଣୀ ବ୍ୟଭିଚାର କରିବାକୁ ଭୂତୁଡ଼ିଆ ଓ ଗୁଣିଆ ଲୋକର ପଶ୍ଚାଦ୍‍ଗାମୀ ହୁଏ, ଆମ୍ଭେ ସେହି ପ୍ରାଣୀ ବିରୁଦ୍ଧରେ ଆପଣା ମୁଖ ରଖିବା ଓ ତାହାର ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ତାହାକୁ ଉଚ୍ଛିନ୍ନ କରିବା। ");
INSERT INTO ory_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","ଏହେତୁ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କୁ ପବିତ୍ର କର ଓ ପବିତ୍ର ହୁଅ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ଆହୁରି ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଧି ମାନ୍ୟ କରି ପାଳନ କରିବ; ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ରକାରୀ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","ଯେକେହି ଆପଣା ପିତା କି ଆପଣା ମାତାକୁ ଅଭିଶାପ ଦିଏ, ସେ ନିତାନ୍ତ ହତ ହେବ; ସେ ତାହାର ପିତାକୁ କି ତାହାର ମାତାକୁ ଅଭିଶାପ ଦେଇଅଛି; ତାହା ଉପରେ ତାହାର ରକ୍ତ ବର୍ତ୍ତିବ। ");
INSERT INTO ory_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ଆଉ, ଯେକେହି ପରର ଭାର୍ଯ୍ୟା ସହିତ ବ୍ୟଭିଚାର କରେ, ଯେ ଆପଣା ପ୍ରତିବାସୀର ଭାର୍ଯ୍ୟା ସହିତ ବ୍ୟଭିଚାର କରେ, ସେହି ବ୍ୟଭିଚାରୀ ଓ ବ୍ୟଭିଚାରିଣୀ ଦୁହେଁ ନିତାନ୍ତ ହତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ପୁଣି, ଯେଉଁ ଲୋକ ଆପଣା ପିତୃର ଭାର୍ଯ୍ୟା ସହିତ ଶାରୀରିକ ସମ୍ପର୍କ ରଖେ, ସେ ଆପଣା ପିତାର ଆବରଣୀୟ ଅନାବୃତ କରିଅଛି; ସେ ଦୁହେଁ ନିତାନ୍ତ ହତ ହେବେ; ସେମାନଙ୍କ ରକ୍ତ ସେମାନଙ୍କ ଉପରେ ବର୍ତ୍ତିବ। ");
INSERT INTO ory_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ପୁଣି, ଯଦି କେହି ଆପଣା ପୁତ୍ରବଧୂ ସହିତ ଶୟନ କରେ, ତେବେ ସେ ଦୁହେଁ ନିତାନ୍ତ ହତ ହେବେ; ସେମାନେ ପାଷାଣ୍ଡ କର୍ମ କରିଅଛନ୍ତି; ସେମାନଙ୍କର ରକ୍ତ ସେମାନଙ୍କ ଉପରେ ବର୍ତ୍ତିବ। ");
INSERT INTO ory_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ପୁଣି, ପୁରୁଷ ଯଦି ପୁରୁଷ ସହିତ ସ୍ତ୍ରୀ ତୁଲ୍ୟ ଯୌନ ସମ୍ପର୍କ ରଖେ, ତେବେ ସେ ଦୁହେଁ ଘୃଣାଯୋଗ୍ୟ କର୍ମ କରିଅଛନ୍ତି; ସେମାନେ ନିତାନ୍ତ ହତ ହେବେ; ସେମାନଙ୍କ ରକ୍ତ ସେମାନଙ୍କ ଉପରେ ବର୍ତ୍ତିବ। ");
INSERT INTO ory_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ଆଉ, କେହି ଯଦି କୌଣସି ସ୍ତ୍ରୀକୁ ଓ ତାହାର ମାତାକୁ ଗ୍ରହଣ କରେ, ତେବେ ତାହା ଦୁଷ୍ଟତା ଅଟେ; ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଯେପରି ଏପରି ଦୁଷ୍ଟତା ନ ହୁଏ, ଏଥିପାଇଁ ସେ ଓ ସେମାନେ ଉଭୟ ଅଗ୍ନିରେ ଦଗ୍ଧ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ପୁଣି, ଯଦି କେହି ପଶୁ ସହିତ ସହବାସ କରେ, ତେବେ ସେ ନିତାନ୍ତ ହତ ହେବ; ପୁଣି ତୁମ୍ଭେମାନେ ସେହି ପଶୁକୁ ମଧ୍ୟ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ପୁଣି, କୌଣସି ସ୍ତ୍ରୀ ଯଦି କୌଣସି ପଶୁ ସହିତ ସହବାସ କରିବାକୁ ତାହା ନିକଟକୁ ଯାଇ ତାହା ଆଗରେ ଶୟନ କରେ, ତେବେ ତୁମ୍ଭେ ସେହି ସ୍ତ୍ରୀକୁ ଓ ପଶୁକୁ ବଧ କରିବ; ସେମାନେ ନିତାନ୍ତ ହତ ହେବେ; ସେମାନଙ୍କ ରକ୍ତ ସେମାନଙ୍କ ଉପରେ ବର୍ତ୍ତିବ। ");
INSERT INTO ory_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ଆଉ, ଯଦି କେହି ଆପଣା ଭଗିନୀକୁ, ଅର୍ଥାତ୍‍, ଆପଣା ପିତୃକନ୍ୟା କି ମାତୃକନ୍ୟାକୁ ଗ୍ରହଣ କରେ ଓ ଦୁହେଁ ପରସ୍ପରର ଉଲଙ୍ଗତା ଦେଖନ୍ତି, ତେବେ ତାହା ଲଜ୍ଜାର ବିଷୟ; ସେମାନେ ଆପଣା ଲୋକମାନଙ୍କ ସନ୍ତାନଗଣର ସାକ୍ଷାତରେ ଉଚ୍ଛିନ୍ନ ହେବେ; ସେ ଆପଣା ଭଗିନୀର ଆବରଣୀୟ ଅନାବୃତ କରିଅଛି; ସେ ଆପଣା ଅପରାଧ ବୋହିବ। ");
INSERT INTO ory_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ପୁଣି, ଯଦି କେହି ରଜସ୍ୱଳା ସ୍ତ୍ରୀ ସହିତ ଶୟନ କରେ ଓ ତାହାର ଆବରଣୀୟ ଅନାବୃତ କରେ, ତେବେ ସେହି ପୁରୁଷ ତାହାର ରକ୍ତର କ୍ଷରଣ ପ୍ରକାଶ କରିବାରୁ ଓ ସେହି ସ୍ତ୍ରୀ ଆପଣା ରକ୍ତର କ୍ଷରଣ ଅନାବୃତ କରିବାରୁ, ସେ ଦୁହେଁ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","ଆଉ, ତୁମ୍ଭେ ଆପଣା ମାଉସୀର ବା ପିଉସୀର ଆବରଣୀୟ ଅନାବୃତ କରିବ ନାହିଁ; ତାହା କଲେ, ଆପଣା ନିକଟବର୍ତ୍ତୀ କୁଟୁମ୍ବର ଆବରଣୀୟ ଅନାବୃତ କରାଯାଏ। ସେମାନେ ଆପଣା ଆପଣା ଅପରାଧ ବୋହିବେ। ");
INSERT INTO ory_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ଆଉ, ଯଦି କେହି ଆପଣା ପିତୃବ୍ୟପତ୍ନୀ ସହିତ ଶୟନ କରେ, ତେବେ ସେ ଆପଣା ପିତୃବ୍ୟର ଆବରଣୀୟ ଅନାବୃତ କରିଅଛି; ସେମାନେ ଆପଣା ଆପଣା ଅପରାଧ ବୋହିବେ; ସେମାନେ ନିଃସନ୍ତାନ ହୋଇ ମରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ପୁଣି, ଯଦି କେହି ଆପଣା ଭ୍ରାତୃଭାର୍ଯ୍ୟାକୁ ଗ୍ରହଣ କରେ, ତେବେ ତାହା ଅଶୁଚି କର୍ମ; ସେ ଆପଣା ଭ୍ରାତାର ଆବରଣୀୟ ଅନାବୃତ କରିଅଛି; ସେମାନେ ନିଃସନ୍ତାନ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","ଏଥିନିମନ୍ତେ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ସମସ୍ତ ବିଧି ଓ ଆମ୍ଭର ସମସ୍ତ ଆଜ୍ଞା ମାନ୍ୟ କରି ପାଳନ କରିବ; ତହିଁରେ ଆମ୍ଭେ ଯେଉଁ ଦେଶରେ ବାସ କରିବା ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କୁ ନେଇ ଯାଉଅଛୁ, ସେହି ଦେଶ ତୁମ୍ଭମାନଙ୍କୁ ଉଦ୍ଗାର କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ପୁଣି, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ସମ୍ମୁଖରୁ ଯେଉଁ ଦେଶୀୟ ଲୋକମାନଙ୍କୁ ଦୂର କରୁଅଛୁ, ସେମାନଙ୍କ ଆଚରଣ ଅନୁସାରେ ତୁମ୍ଭେମାନେ ଚ଼ାଲିବ ନାହିଁ; କାରଣ ସେମାନେ ସେହି ସବୁ ଦୁଷ୍କର୍ମ କଲେ, ଏଥିପାଇଁ ଆମ୍ଭେ ସେମାନଙ୍କୁ ଘୃଣା କଲୁ। ");
INSERT INTO ory_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ମାତ୍ର ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ କହିଅଛୁ, ତୁମ୍ଭେମାନେ ସେମାନଙ୍କ ଦେଶ ଅଧିକାର କରିବ; ଆଉ, ଆମ୍ଭେ ଅଧିକାର ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କୁ ସେହି ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଦେଶ ଦେବା; ଯେ ଅନ୍ୟ ଲୋକଙ୍କଠାରୁ ତୁମ୍ଭମାନଙ୍କୁ ପୃଥକ କରିଅଛନ୍ତି, ଆମ୍ଭେ ସେହି ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ଏହେତୁ ତୁମ୍ଭେମାନେ ଶୁଚି ଓ ଅଶୁଚି ପଶୁ ପୁଣି ଶୁଚି ଓ ଅଶୁଚି ପକ୍ଷୀ ମଧ୍ୟରେ ପୃଥକ କରିବ; ଆମ୍ଭେ ଯେଉଁ ଯେଉଁ ପଶୁ, ପକ୍ଷୀ ଓ ଭୂଚର ଜନ୍ତୁକୁ ଅଶୁଚି ବୋଲି ତୁମ୍ଭମାନଙ୍କଠାରୁ ପୃଥକ କରିଅଛୁ, ତଦ୍ଦ୍ୱାରା ଆପଣା ଆପଣା ପ୍ରାଣକୁ ଘୃଣାଯୋଗ୍ୟ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ପୁଣି, ତୁମ୍ଭେମାନେ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ପବିତ୍ର ଅଟୁ। ଆଉ, ତୁମ୍ଭେମାନେ ଯେପରି ଆମ୍ଭର ହେବ, ଏଥିପାଇଁ ଆମ୍ଭେ ଅନ୍ୟ ଲୋକଙ୍କଠାରୁ ତୁମ୍ଭମାନଙ୍କୁ ପୃଥକ କରିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ଆଉ, ପୁରୁଷ ଅବା ସ୍ତ୍ରୀ ଯେକେହି ଭୂତୁଡ଼ିଆ ଅବା ଗୁଣିଆ ହୁଏ, ସେ ନିତାନ୍ତ ହତ ହେବ; ଲୋକମାନେ ସେମାନଙ୍କୁ ପଥର ମାରି ବଧ କରିବେ; ସେମାନଙ୍କ ରକ୍ତ ସେମାନଙ୍କ ଉପରେ ବର୍ତ୍ତିବ।” ");
INSERT INTO ory_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ହାରୋଣର ପୁତ୍ର ଯାଜକଗଣଙ୍କୁ କୁହ, ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ମୃତ କୌଣସି ଲୋକ ସକାଶୁ ସେମାନଙ୍କର କେହି ଆପଣାକୁ ଅଶୁଚି କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","କେବଳ ଆପଣାର ନିକଟ ଜ୍ଞାତି, ଅର୍ଥାତ୍‍, ଆପଣା ମାତା, ଆପଣା ପିତା, ଆପଣା ପୁତ୍ର, ଆପଣା କନ୍ୟା ଓ ଆପଣା ଭ୍ରାତା ନିମନ୍ତେ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ପୁଣି, ଯେଉଁ ନିକଟସ୍ଥ ଭଗିନୀର ସ୍ୱାମୀ ହୋଇ ନାହିଁ, ଏପରି ଅବିବାହିତା ଭଗିନୀ ସକାଶୁ ସେ ଆପଣାକୁ ଅଶୁଚି କରି ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ସ୍ୱାମୀ ହେବାରୁ ଆପଣାକୁ ଅପବିତ୍ର କରିବା ପାଇଁ ଅଶୁଚି ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","ସେମାନେ ଆପଣା ଆପଣା ମସ୍ତକ ମୁଣ୍ଡନ କରିବେ ନାହିଁ ଓ ଆପଣା ଆପଣା ଦାଢ଼ିର କୋଣ କ୍ଷୌର କରିବେ ନାହିଁ, କିଅବା ଆପଣା ଆପଣା ଶରୀରରେ ଅସ୍ତ୍ରାଘାତ କରିବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ସେମାନେ ଆପଣାମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବେ ଓ ଆପଣାମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ନାମ ଅପବିତ୍ର କରିବେ ନାହିଁ; କାରଣ ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଅଗ୍ନିକୃତ ଉପହାର, ଅର୍ଥାତ୍‍, ଆପଣାମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ଭକ୍ଷ୍ୟ ଉତ୍ସର୍ଗ କରନ୍ତି; ଏହେତୁ ସେମାନେ ପବିତ୍ର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ସେମାନେ ବେଶ୍ୟାକୁ ଅବା କଳଙ୍କିନୀକୁ ବିବାହ କରିବେ ନାହିଁ ଓ ସ୍ୱାମୀତ୍ୟକ୍ତା ସ୍ତ୍ରୀକୁ ବିବାହ କରିବେ ନାହିଁ, କାରଣ ସେ ଆପଣା ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ଏହେତୁ ତୁମ୍ଭେ ତାହାକୁ ପବିତ୍ର କରିବ; କାରଣ ସେ ତୁମ୍ଭ ପରମେଶ୍ୱରଙ୍କ ଭକ୍ଷ୍ୟ ଉତ୍ସର୍ଗ କରେ; ସେ ତୁମ୍ଭ ନିକଟରେ ପବିତ୍ର ହେବ; କାରଣ ତୁମ୍ଭମାନଙ୍କୁ ପବିତ୍ର କରୁ ଯେ ସଦାପ୍ରଭୁ ଆମ୍ଭେ, ଆମ୍ଭେ ପବିତ୍ର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ଆଉ, କୌଣସି ଯାଜକର କନ୍ୟା ଯଦି ବ୍ୟଭିଚାର କ୍ରିୟା ଦ୍ୱାରା ଆପଣାକୁ ଅପବିତ୍ର କରେ, ତେବେ ସେ ଆପଣା ପିତାକୁ ଅପବିତ୍ର କରେ; ସେ ଅଗ୍ନିରେ ପୋଡ଼ାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","ଆଉ, ଆପଣା ଭ୍ରାତାମାନଙ୍କ ମଧ୍ୟରୁ ଯେଉଁ ଜନ ପ୍ରଧାନ ଯାଜକ ହୋଇଅଛି, ଯାହାର ମସ୍ତକରେ ଅଭିଷେକାର୍ଥକ ତୈଳ ଢଳା ଯାଇଅଛି ଓ ଯେ ପବିତ୍ର ବସ୍ତ୍ର ପରିଧାନ କରିବା ପାଇଁ ପଦରେ ନିଯୁକ୍ତ ହୋଇଅଛି, ସେ ଆପଣା ମସ୍ତକର କେଶ ମୁକୁଳା କରିବ ନାହିଁ ଓ ଆପଣା ବସ୍ତ୍ର ଚିରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","କିଅବା ସେ ଗୃହ ଭିତରେ ଶବ ନିକଟକୁ ଯିବ ନାହିଁ, ଅବା ଆପଣା ପିତା ବା ଆପଣା ମାତା ସକାଶୁ ଆପଣାକୁ ଅଶୁଚି କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ଅଥବା ପବିତ୍ର ସ୍ଥାନରୁ ବାହାରିବ ନାହିଁ, ଅବା ଆପଣା ପରମେଶ୍ୱରଙ୍କ ପବିତ୍ର ସ୍ଥାନକୁ ଅପବିତ୍ର କରିବ ନାହିଁ; କାରଣ ତାହାର ପରମେଶ୍ୱରଙ୍କ ଅଭିଷେକାର୍ଥକ ତୈଳରୂପ ମୁକୁଟ ତାହା ଉପରେ ଅଛି; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ପୁଣି, ସେ କେବଳ ଅନୂଢ଼ାକୁ ବିବାହ କରିବ; ");
INSERT INTO ory_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ବିଧବା, ତ୍ୟକ୍ତା, କଳଙ୍କିନୀ କିଅବା ବେଶ୍ୟାକୁ ବିବାହ କରିବ ନାହିଁ; ମାତ୍ର ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି ଏକ କନ୍ୟାକୁ ବିବାହ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ଆଉ, ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଆପଣା ବଂଶ ଅପବିତ୍ର କରିବ ନାହିଁ, କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତାହାକୁ ପବିତ୍ର କରୁ।” ");
INSERT INTO ory_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ତୁମ୍ଭେ ହାରୋଣକୁ କୁହ, ପୁରୁଷାନୁକ୍ରମେ ତୁମ୍ଭ ବଂଶ ମଧ୍ୟରେ ଯାହାର ଶରୀରରେ ଖୁଣ ଥାଏ, ସେ ଆପଣା ପରମେଶ୍ୱରଙ୍କ ‘ଭକ୍ଷ୍ୟଦ୍ରବ୍ୟ’ ଉତ୍ସର୍ଗ କରିବା ପାଇଁ ନିକଟକୁ ଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ଯେକୌଣସି ଲୋକର ଖୁଣ ଅଛି, ସେ ନିକଟବର୍ତ୍ତୀ ହେବ ନାହିଁ; ବିଶେଷରେ ଅନ୍ଧ ଲୋକ, ଛୋଟା, ଯାହାର ନାକ ବିକୃତ, ଅଧିକ ଅଙ୍ଗ, ");
INSERT INTO ory_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ଭଗ୍ନପାଦ, ଭଗ୍ନହସ୍ତ, ");
INSERT INTO ory_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","କୁଜା, ବାମନ, ଅବା ଯାହାର ଚକ୍ଷୁରେ ଖୁଣ ଅଛି, ଜାଦୁ ରୋଗୀ, କାଛୁ ରୋଗୀ, ଭଗ୍ନକୋଷ; ");
INSERT INTO ory_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ଏପରି ଖୁଣବିଶିଷ୍ଟ ଯେଉଁ ପୁରୁଷ ହାରୋଣ ଯାଜକଙ୍କର ବଂଶ ମଧ୍ୟରେ ଥାଏ, ସେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବା ପାଇଁ ନିକଟକୁ ଯିବ ନାହିଁ; ତାହାର ଖୁଣ ଅଛି; ସେ ଆପଣା ପରମେଶ୍ୱରଙ୍କ ‘ଭକ୍ଷ୍ୟ’ ଉତ୍ସର୍ଗ କରିବା ପାଇଁ ନିକଟକୁ ଆସିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ସେ ଆପଣା ପରମେଶ୍ୱରଙ୍କର ମହାପବିତ୍ର ବା ପବିତ୍ର ‘ଭକ୍ଷ୍ୟ’ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ମାତ୍ର ବିଚ୍ଛେଦ ବସ୍ତ୍ରର ଭିତରକୁ ଯିବ ନାହିଁ, କିଅବା ବେଦି ନିକଟକୁ ଆସିବ ନାହିଁ, କାରଣ ତାହାର ଖୁଣ ଅଛି; ସେ ଆମ୍ଭର ପବିତ୍ର ସ୍ଥାନସକଳ ଅପବିତ୍ର କରିବ ନାହିଁ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ସେହି ସମସ୍ତ ପବିତ୍ର କରୁ।” ");
INSERT INTO ory_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ଏହି ପ୍ରକାରେ ମୋଶା ହାରୋଣଙ୍କୁ ଓ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ ଓ ସମସ୍ତ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଏହି କଥା କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ କୁହ, ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ପବିତ୍ରୀକୃତ ଦ୍ରବ୍ୟ ବିଷୟରେ ସାବଧାନ ହୁଅ, ସେମାନେ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଯାହା ପବିତ୍ର କରନ୍ତି, ତଦ୍ଦ୍ୱାରା ଆମ୍ଭର ପବିତ୍ର ନାମକୁ ଅପବିତ୍ର କରିବେ ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ତୁମ୍ଭେ ସେମାନଙ୍କୁ କୁହ, ପୁରୁଷାନୁକ୍ରମେ ତୁମ୍ଭମାନଙ୍କ ବଂଶ ମଧ୍ୟରେ ଯେକେହି ଅଶୁଚି ହୋଇ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଦ୍ୱାରା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ରୀକୃତ ଦ୍ରବ୍ୟ ନିକଟକୁ ଯିବ, ସେ ପ୍ରାଣୀ ଆମ୍ଭ ସମ୍ମୁଖରୁ ଉଚ୍ଛିନ୍ନ ହେବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ପୁଣି, ହାରୋଣ-ବଂଶର ଯେକେହି କୁଷ୍ଠୀ ଅବା ପ୍ରମେହୀ ହୁଏ, ସେ ଶୁଚି ନ ହେବା ପର୍ଯ୍ୟନ୍ତ ପବିତ୍ର ଦ୍ରବ୍ୟ ଭୋଜନ କରିବ ନାହିଁ। ଯେକେହି ଶବ ଦ୍ୱାରା ଅଶୁଚି ହୋଇଥିବା କୌଣସି ଦ୍ରବ୍ୟକୁ, ଅବା ଯାହାର ବୀର୍ଯ୍ୟପାତ ହେଉଥାଏ, ଏପରି କୌଣସି ମନୁଷ୍ୟକୁ ଛୁଇଁବ; ");
INSERT INTO ory_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ଅଥବା ଯାହା ଦ୍ୱାରା ସେ ଅଶୁଚି ହୋଇପାରେ, ଏପରି କୌଣସି ଉରୋଗାମୀ ଜନ୍ତୁକୁ, କି କୌଣସି ପ୍ରକାର ଅଶୁଚି ମନୁଷ୍ୟକୁ ଛୁଇଁବ, ");
INSERT INTO ory_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ସେହି ସ୍ପର୍ଶକାରୀ ବ୍ୟକ୍ତି ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ; ଆଉ, ସେ ଜଳରେ ଆପଣା ଶରୀର ନ ଧୋଇଲେ ପବିତ୍ର ଦ୍ରବ୍ୟ ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ତହିଁ ଉତ୍ତାରେ ସୂର୍ଯ୍ୟ ଅସ୍ତ ହେଲେ, ସେ ଶୁଚି ହୋଇ ପବିତ୍ର ଦ୍ରବ୍ୟ ଭୋଜନ କରିବ, କାରଣ ତାହା ତାହାର ଖାଦ୍ୟ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ସେ ଆପଣାକୁ ଅଶୁଚି କରିବା ନିମନ୍ତେ ସ୍ୱୟଂମୃତ ବା ପଶୁ ଦ୍ୱାରା ବିଦୀର୍ଣ୍ଣ ଜନ୍ତୁର ମାଂସ ଭୋଜନ କରିବ ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ଏହେତୁ ସେମାନେ ଆମ୍ଭର ବିଧି ମାନ୍ୟ କରି ପାଳନ କରିବେ; ନୋହିଲେ, ଯେବେ ସେମାନେ ତାହା ଅପବିତ୍ର କରନ୍ତି, ତେବେ ତହିଁ ସକାଶୁ ଆପଣା ଆପଣା ଅପରାଧ ବୋହିବ ଓ ତହିଁରେ ମରିବେ; ଯେ ସେମାନଙ୍କୁ ପବିତ୍ର କରନ୍ତି, ସେହି ସଦାପ୍ରଭୁ ଆମ୍ଭେ। ");
INSERT INTO ory_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","ଆଉ, ଭିନ୍ନ ବଂଶୀୟ କୌଣସି ଲୋକ ପବିତ୍ର ଦ୍ରବ୍ୟ ଭୋଜନ କରିବ ନାହିଁ; ଯାଜକର ଗୃହରେ ପ୍ରବାସୀ ଅବା ବେତନଜୀବୀ ଦାସ ପବିତ୍ର ଦ୍ରବ୍ୟ ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ମାତ୍ର ଯାଜକ ଯଦି କୌଣସି ପ୍ରାଣୀକୁ କ୍ରୟ କରେ, ତେବେ ତାହାର ରୂପାରେ କ୍ରୟ କରାଯାଇଥିବା ସେହି ଲୋକ ତାହା ଭୋଜନ କରିବ; ପୁଣି, ତାହାର ଗୃହରେ ଜନ୍ମ ହୋଇଥିବା ଲୋକମାନେ ତାହାର ଅନ୍ନ ଭୋଜନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ଆଉ ଯାଜକର କନ୍ୟା ଯଦି କୌଣସି ଭିନ୍ନ ବଂଶୀୟ ଲୋକ ସହିତ ବିବାହିତା ହୁଏ, ତେବେ ସେ ପବିତ୍ର ଦ୍ରବ୍ୟାଦି ମଧ୍ୟରୁ ଉତ୍ତୋଳନୀୟ ନୈବେଦ୍ୟ ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ମାତ୍ର ଯାଜକର କନ୍ୟା ଯଦି ବିଧବା କି ତ୍ୟକ୍ତା ହୋଇ ନିଃସନ୍ତାନ ହୋଇଥାଏ ଓ ପୁନର୍ବାର ଆସି ବାଲ୍ୟାବସ୍ଥା ତୁଲ୍ୟ ପିତୃଗୃହରେ ବାସ କରେ, ତେବେ ସେ ଆପଣା ପିତାର ଅନ୍ନ ଭୋଜନ କରିବ; ମାତ୍ର ଭିନ୍ନ ବଂଶୀୟ ଲୋକ ତାହା ଭୋଜନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ଆଉ, ଯଦି କେହି ଅଜ୍ଞାତସାରରେ ପବିତ୍ର ଦ୍ରବ୍ୟ ଭୋଜନ କରେ, ତେବେ ସେ ତହିଁର ପଞ୍ଚମାଂଶ ଅଧିକା କରି ଯାଜକକୁ ପବିତ୍ର ଦ୍ରବ୍ୟ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ଏହିରୂପେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯେଉଁ ଯେଉଁ ପବିତ୍ର ଦ୍ରବ୍ୟ ଉତ୍ସର୍ଗ କରନ୍ତି, ସେମାନେ ତାହାସବୁ ଅପବିତ୍ର କରିବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ପୁଣି, ସେମାନେ ଆପଣାମାନଙ୍କର ପବିତ୍ର ଦ୍ରବ୍ୟ ଭୋଜନ କରି ଦୋଷଜନକ ଅପରାଧ ବହନ କରିବେ ନାହିଁ; କାରଣ ଯେ ସେମାନଙ୍କୁ ପବିତ୍ର କରନ୍ତି, ସେହି ସଦାପ୍ରଭୁ ଆମ୍ଭେ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ ଓ ଇସ୍ରାଏଲର ସମସ୍ତ ସନ୍ତାନଗଣକୁ କୁହ, ‘ଇସ୍ରାଏଲ ବଂଶ କିଅବା ଇସ୍ରାଏଲ ମଧ୍ୟରେ ବିଦେଶୀମାନଙ୍କ ମଧ୍ୟରୁ ଯେଉଁମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମବଳି ନିମନ୍ତେ ମାନତପୂର୍ବକ ବା ସ୍ଵେଚ୍ଛାପୂର୍ବକ କୌଣସି ଉପହାର ଆଣନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ସେମାନେ ଗ୍ରାହ୍ୟ ହେବା ନିମନ୍ତେ ଗୋରୁ କି ମେଷ କି ଛାଗ ମଧ୍ୟରୁ ନିଖୁନ୍ତ ପୁଂପଶୁ ଉତ୍ସର୍ଗ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ମାତ୍ର ଯାହାର ଖୁଣ ଥାଏ, ତାକୁ ତୁମ୍ଭେମାନେ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ; କାରଣ ତାହା ତୁମ୍ଭମାନଙ୍କ ପକ୍ଷରେ ଗ୍ରାହ୍ୟ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ଆଉ, କୌଣସି ଲୋକ ଯଦି ମାନତ ସିଦ୍ଧି ନିମନ୍ତେ ଅବା ସ୍ଵେଚ୍ଛାଦତ୍ତ ଉପହାର ନିମନ୍ତେ ଗୋଠରୁ (ଗାଈଗୋରୁ ପଲ) ଅବା ପଲରୁ (ମେଷ, ଛାଗପଲ) ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମଙ୍ଗଳାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରେ, ତେବେ ତାହା ଗ୍ରାହ୍ୟ ହେବା ନିମନ୍ତେ ନିଖୁନ୍ତ ହେବ; ତାହାଠାରେ କୌଣସି ଖୁଣ ନ ଥିବ। ");
INSERT INTO ory_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ଅନ୍ଧ, ଭଗ୍ନ, ଛୋଟା, ଆବୁଆ, ଜାଦୁଆ କି ଖାରସ୍ତିଆ, ଏମାନଙ୍କୁ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ, କିଅବା ସେମାନଙ୍କୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପେ ବେଦି ଉପରେ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ତୁମ୍ଭେ ଅଧିକ ଅଙ୍ଗ କି ହୀନାଙ୍ଗ ଗୋରୁ କି ମେଷ ସ୍ଵେଚ୍ଛାଦତ୍ତ ଉପହାର ରୂପେ ଉତ୍ସର୍ଗ କରିପାର; ମାତ୍ର ମାନତ ନିମନ୍ତେ ତାହା ଗ୍ରାହ୍ୟ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ଆଉ, ଯାହାର କୋଷ ମଳା, ଛେଚା, ଭଙ୍ଗା, କଟା, ଏପରି (ପଶୁ) ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ; କିଅବା ତୁମ୍ଭେମାନେ ଆପଣା ଦେଶରେ ଏପରି ବଳି ଉତ୍ସର୍ଗ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","କିଅବା ବିଦେଶୀର ହସ୍ତରୁ ଏହିସବୁରୁ କିଛି ଆପଣାମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କର ଭକ୍ଷ୍ୟ ରୂପେ ଉତ୍ସର୍ଗ କରିବ ନାହିଁ; କାରଣ ସେମାନଙ୍କର ନଷ୍ଟତା ସେମାନଙ୍କଠାରେ ଅଛି, ସେମାନଙ୍କଠାରେ ଖୁଣ ଅଛି; ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ପକ୍ଷରେ ଗ୍ରାହ୍ୟ ହେବେ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ଆଉ, ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ଗୋରୁ କି ମେଷ କି ଛାଗ ଜନ୍ମିଲା ଉତ୍ତାରେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ମାତା ସହିତ ରହିବ; ପୁଣି, ଅଷ୍ଟମ ଦିନଠାରୁ ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ନିମନ୍ତେ ଗ୍ରାହ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ଆଉ, ଗୋରୁ କି ମେଷୀ ହେଉ, ତାହାକୁ ଓ ତାହାର ଛୁଆକୁ ଏକାଦିନେ ଦୁହିଁଙ୍କୁ ବଧ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","ତୁମ୍ଭେମାନେ ଯେଉଁ ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପ୍ରଶଂସାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରିବ, ସେହି ସମୟରେ ତୁମ୍ଭେମାନେ ଗ୍ରାହ୍ୟ ହେବା ନିମନ୍ତେ ତାହା କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ସେହି ଦିନ ତାହା ଭୋଜନ କରାଯିବ; ତୁମ୍ଭେମାନେ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ତହିଁରୁ କିଛି ଅବଶିଷ୍ଟ ରଖିବ ନାହିଁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","ଏଥିନିମନ୍ତେ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ଆଜ୍ଞା ମାନ୍ୟ କରି ପାଳନ କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ଆଉ, ତୁମ୍ଭେମାନେ ଆମ୍ଭର ପବିତ୍ର ନାମ ଅପବିତ୍ର କରିବ ନାହିଁ; ମାତ୍ର ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ପବିତ୍ର ରୂପେ ମାନ୍ୟ ହେବା। ");
INSERT INTO ory_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ଯେ ତୁମ୍ଭମାନଙ୍କୁ ପବିତ୍ର କରନ୍ତି, ଯେ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ହେବା ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲେ, ସେହି ସଦାପ୍ରଭୁ ଆମ୍ଭେ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କର ଯେଉଁ ସକଳ ନିରୂପିତ ପର୍ବ ପବିତ୍ର ସଭା ବୋଲି ଘୋଷଣା କରିବ, ଆମ୍ଭର ସେହି ସକଳ ପର୍ବ ଏହି। ");
INSERT INTO ory_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ଛଅ ଦିନ କର୍ମ କରାଯିବ; ମାତ୍ର ସପ୍ତମ ଦିନ ମହା ବିଶ୍ରାମ, ଅର୍ଥାତ୍‍, ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ପ୍ରକାର କର୍ମ କରିବ ନାହିଁ; ତାହା ତୁମ୍ଭମାନଙ୍କର ସମସ୍ତ ନିବାସ ସ୍ଥାନରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବିଶ୍ରାମ ଦିନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","ତୁମ୍ଭେମାନେ ନିରୂପିତ ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ସ୍ଥାପିତ ପର୍ବ, ଅର୍ଥାତ୍‍, ପବିତ୍ର ସଭା ବୋଲି ଯାହା ଘୋଷଣା କରିବ, ତାହା ଏହି। ");
INSERT INTO ory_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ପ୍ରଥମ ମାସରେ, ମାସର ଚତୁର୍ଦ୍ଦଶ ଦିନର ସନ୍ଧ୍ୟା ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ନିସ୍ତାର ପର୍ବ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ପୁଣି, ସେହି ମାସର ପଞ୍ଚଦଶ ଦିନରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ପର୍ବ ହେବ; ସାତ ଦିନ ଯାଏ ତୁମ୍ଭେମାନେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ପ୍ରଥମ ଦିନ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ମାତ୍ର ତୁମ୍ଭେମାନେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ; ସପ୍ତମ ଦିନରେ ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବା, ସେହି ଦେଶରେ ପ୍ରବେଶ କରି ଯେତେବେଳେ ତୁମ୍ଭେମାନେ ଶସ୍ୟ କାଟିବ, ସେତେବେଳେ ତୁମ୍ଭମାନଙ୍କର ପ୍ରଥମ କଟା ଶସ୍ୟର ଏକ ବିଡ଼ା ଯାଜକ ନିକଟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ତହିଁରେ ତୁମ୍ଭମାନଙ୍କ ପକ୍ଷରେ ଗ୍ରାହ୍ୟ ହେବା ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସେହି ବିଡ଼ା ଦୋଳାଇବ; ବିଶ୍ରାମବାରର ପରଦିନ ଯାଜକ ତାହା ଦୋଳାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ପୁଣି, ଯେଉଁ ଦିନ ତୁମ୍ଭେମାନେ ସେହି ବିଡ଼ା ଦୋଳାଇବ, ସେହି ଦିନ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମ ନିମନ୍ତେ ପ୍ରଥମବର୍ଷୀୟ ନିଖୁନ୍ତ ଏକ ମେଷବତ୍ସ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ପୁଣି, ଐଫାର ଦୁଇ ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦା ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ହେବ, ତାହା ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ; ଆଉ, ଏକ ହିନ୍‍ ଦ୍ରାକ୍ଷାରସର ଚତୁର୍ଥାଂଶ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ପୁଣି, ତୁମ୍ଭେମାନେ ଯେଉଁ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଏହି ଉପହାର ଆଣି ନାହଁ, ସେହି ଦିନ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେମାନେ ରୁଟି କି ଭଜା ଶସ୍ୟ କି ଛିଣ୍ଡା ଶିଷା ଖାଇବ ନାହିଁ; ତୁମ୍ଭମାନଙ୍କର ସମୁଦାୟ ନିବାସ ସ୍ଥାନରେ ଏହା ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","ଆହୁରି ସେହି ବିଶ୍ରାମବାରର ପରଦିନଠାରୁ ଯେଉଁ ଦିନ ଦୋଳନୀୟ ନୈବେଦ୍ୟରୂପ ବିଡ଼ା ଆଣିଲ, ସେହି ଦିନଠାରୁ ପୂର୍ଣ୍ଣ ସାତ ସପ୍ତାହ ଗଣନା କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ଏହିରୂପେ ସପ୍ତମ ବିଶ୍ରାମବାରର ପରଦିନ ପର୍ଯ୍ୟନ୍ତ ପଚାଶ ଦିନ ଗଣନା କରିବ; ଆଉ, ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ନୂତନ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ନିବାସରୁ ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ଏକ ଐଫାର ଦୁଇ ଦଶମାଂଶର ଦୁଇ ରୁଟି ଆଣିବ; ତାହା ସରୁ ମଇଦାରେ ପ୍ରସ୍ତୁତ ହେବ ଓ ତାଡ଼ିରେ ରନ୍ଧନ କରାଯିବ, ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପ୍ରଥମ ଫଳ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ପୁଣି, ତୁମ୍ଭେମାନେ ସେହି ରୁଟି ସହିତ ପ୍ରଥମବର୍ଷୀୟ ନିଖୁନ୍ତ ସାତ ମେଷବତ୍ସ ଓ ଗୋଟିଏ ଯୁବା ବୃଷ ଓ ଦୁଇ ମେଷ ବଳିଦାନ କରିବ; ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମବଳି ହେବ; ପୁଣି, ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ସହିତ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ତହିଁ ଉତ୍ତାରେ ତୁମ୍ଭେମାନେ ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ଏକ ଛାଗ ଓ ମଙ୍ଗଳାର୍ଥକ ବଳି ନିମନ୍ତେ ଏକ ବର୍ଷୀୟ ଦୁଇ ମେଷବତ୍ସ ବଳିଦାନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ପୁଣି, ଯାଜକ ପ୍ରଥମ ଫଳର ରୁଟି ସହିତ ଓ ଦୁଇ ମେଷବତ୍ସ ମଧ୍ୟ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳନୀୟ ନୈବେଦ୍ୟ ରୂପେ ଦୋଳାଇବ; ତାହାସବୁ ଯାଜକ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ଆଉ, ତୁମ୍ଭେମାନେ ସେହି ଦିନ (ସଭାର) ଘୋଷଣା କରିବ; ତହିଁରେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ; ଏହା ତୁମ୍ଭମାନଙ୍କର ସମୁଦାୟ ନିବାସ ସ୍ଥାନରେ ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି। ");
INSERT INTO ory_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ଆଉ, ତୁମ୍ଭମାନଙ୍କ ଭୂମିର ଶସ୍ୟ ତୁମ୍ଭେମାନେ କାଟିବା ବେଳେ, ତୁମ୍ଭେ ଆପଣା କ୍ଷେତ୍ରର କୋଣ ନିଃଶେଷ ରୂପେ କାଟିବ ନାହିଁ, କିଅବା ତୁମ୍ଭେ ଆପଣା କ୍ଷେତ୍ରରେ ଛାଡ଼ିଥିବା ଶସ୍ୟ ସଂଗ୍ରହ କରିବ ନାହିଁ; ତୁମ୍ଭେ ତାହା ଦୁଃଖୀ ଓ ବିଦେଶୀ ପାଇଁ ଛାଡ଼ିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ‘ସପ୍ତମ ମାସରେ, ମାସର ପ୍ରଥମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ମହା ବିଶ୍ରାମ, ଅର୍ଥାତ୍‍, ତୂରୀଧ୍ୱନି ଦ୍ୱାରା ସ୍ମରଣାର୍ଥକ ପବିତ୍ର ସଭା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ; ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ।’” ");
INSERT INTO ory_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ଆହୁରି, ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ସେହି ସପ୍ତମ ମାସର ଦଶମ ଦିନ ଅବଶ୍ୟ ପ୍ରାୟଶ୍ଚିତ୍ତର ଦିନ ହେବ; ସେହି ଦିନ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ, ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ପ୍ରାଣକୁ କ୍ଲେଶ ଦେବ; ପୁଣି ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ସେହି ଦିନ ତୁମ୍ଭେମାନେ କୌଣସି ପ୍ରକାର କାର୍ଯ୍ୟ କରିବ ନାହିଁ; କାରଣ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ପାଇଁ ତାହା ପ୍ରାୟଶ୍ଚିତ୍ତର ଦିନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ସେହି ଦିନରେ ଯେକେହି ଆପଣା ପ୍ରାଣକୁ କ୍ଲେଶ ଦେବ ନାହିଁ, ସେ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ପୁଣି ସେହି ଦିନ ଯେକୌଣସି ପ୍ରାଣୀ କୌଣସି ପ୍ରକାର କାର୍ଯ୍ୟ କରେ, ସେହି ପ୍ରାଣୀକୁ ତାହାର ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଆମ୍ଭେ ଉଚ୍ଛିନ୍ନ କରିବା। ");
INSERT INTO ory_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ତୁମ୍ଭେମାନେ କୌଣସି ପ୍ରକାର କାର୍ଯ୍ୟ କରିବ ନାହିଁ; ଏହା ତୁମ୍ଭମାନଙ୍କର ସମୁଦାୟ ନିବାସ ସ୍ଥାନରେ ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି। ");
INSERT INTO ory_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ସେହି ଦିନ ତୁମ୍ଭମାନଙ୍କର ମହା ବିଶ୍ରାମ ଦିନ ହେବ, ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ପ୍ରାଣକୁ କ୍ଲେଶ ଦେବ; ମାସର ନବମ ଦିନର ସନ୍ଧ୍ୟାକାଳରେ, ଏକ ସନ୍ଧ୍ୟାଠାରୁ ଆର ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ, ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କର ବିଶ୍ରାମ ଦିନ ପାଳନ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ଆହୁରି ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଏହି ସପ୍ତମ ମାସର ପଞ୍ଚଦଶ ଦିନଠାରୁ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପତ୍ରକୁଟୀର ପର୍ବ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ପ୍ରଥମ ଦିନରେ ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ; ଅଷ୍ଟମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ; ପୁଣି, ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ; ତାହା ମହାସଭା ଅଟେ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହଁ। ");
INSERT INTO ory_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","ଏହିସବୁ ସଦାପ୍ରଭୁଙ୍କର ସ୍ଥାପିତ ପର୍ବ; ପୁଣି, ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ପର୍ବର ନିରୂପିତ ଦିନରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର, ହୋମବଳି, ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ବଳି ଓ ପେୟ-ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କରିବାକୁ ପବିତ୍ର ସଭାର ଘୋଷଣା କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ନିୟମିତ ଭାବରେ ସାପ୍ତାହିକ ବିଶ୍ରାମବାର ପାଳନ କରିବା ବ୍ୟତୀତ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଦେଉଥିବା ତୁମ୍ଭମାନଙ୍କର ସକଳ ଦାନ, ସକଳ ମାନତ ଓ ସ୍ୱେଚ୍ଛାଦତ୍ତ ନୈବେଦ୍ୟ ସକଳ ବ୍ୟତୀତ ନିରୂପିତ ପର୍ବମାନଙ୍କରେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","ଆହୁରି, ଭୂମିରୁ ଉତ୍ପନ୍ନ ଫଳ ସଂଗ୍ରହ କଲା ଉତ୍ତାରେ ସପ୍ତମ ମାସର ପଞ୍ଚଦଶ ଦିନରେ ତୁମ୍ଭେମାନେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅବଶ୍ୟ ପର୍ବ ପାଳନ କରିବ; ପ୍ରଥମ ଦିନ ମହା ବିଶ୍ରାମ ହେବ ଓ ଅଷ୍ଟମ ଦିନ ମହା ବିଶ୍ରାମ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ଆଉ, ତୁମ୍ଭେମାନେ ପ୍ରଥମ ଦିନରେ ଉତ୍ତମ ବୃକ୍ଷର ଫଳ, ଖର୍ଜ୍ଜୁର ବାହୁଙ୍ଗା, ଗହଳିଆ ବୃକ୍ଷର ଶାଖା ଓ ନଦୀତୀରସ୍ଥ ବାଇଶୀ ବୃକ୍ଷ ଘେନି ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସାତ ଦିନ ଆନନ୍ଦ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ପୁଣି, ତୁମ୍ଭେମାନେ ବର୍ଷ ମଧ୍ୟରେ ସାତ ଦିନ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସେହି ପର୍ବ ପାଳନ କରିବ; ଏହା ତୁମ୍ଭମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି; ତୁମ୍ଭେମାନେ ସପ୍ତମ ମାସରେ ତାହା ପାଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ତୁମ୍ଭେମାନେ ସାତ ଦିନ ପତ୍ରକୁଟୀରରେ ବାସ କରିବ; ଇସ୍ରାଏଲ ବଂଶଜାତ ସମସ୍ତେ ପତ୍ରକୁଟୀରରେ ବାସ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ତହିଁରେ ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିବା ବେଳେ ସେମାନଙ୍କୁ ପତ୍ରକୁଟୀରରେ ବାସ କରାଇଥିଲୁ, ଏହା ତୁମ୍ଭମାନଙ୍କର ଭବିଷ୍ୟତ ପୁରୁଷମାନେ ଜାଣି ପାରିବେ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ତହୁଁ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ସଦାପ୍ରଭୁଙ୍କର ସମସ୍ତ ସ୍ଥାପିତ ପର୍ବର କଥା କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଏହି ଆଜ୍ଞା ଦିଅ, ନିତ୍ୟ ନିତ୍ୟ ପ୍ରଦୀପ ଜ୍ୱଳାଇବା ନିମନ୍ତେ ସେମାନେ ତୁମ୍ଭ ନିକଟକୁ ନିର୍ମଳ ପେଷା ଜୀତ ତୈଳ ଆଣିବେ। ");
INSERT INTO ory_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ହାରୋଣ ସମାଗମ-ତମ୍ବୁ ମଧ୍ୟରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକର ବିଚ୍ଛେଦ ବସ୍ତ୍ର ବାହାରେ ସନ୍ଧ୍ୟାଠାରୁ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ନିତ୍ୟ ନିତ୍ୟ ତାହା ସ୍ଥାପନ କରିବ; ଏହା ତୁମ୍ଭମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି। ");
INSERT INTO ory_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ସେ ନିର୍ମଳ ଦୀପବୃକ୍ଷ ଉପରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ନିତ୍ୟ ନିତ୍ୟ ସେହି ପ୍ରଦୀପସକଳ ସ୍ଥାପନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","ଆଉ, ତୁମ୍ଭେ ସରୁ ମଇଦା ନେଇ ତହିଁରେ ବାରଗୋଟି ପିଠା ପ୍ରସ୍ତୁତ କରିବ; ପ୍ରତ୍ୟେକ ପିଠା ଏକ ଐଫାର ଦୁଇ ଦଶମାଂଶ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ପୁଣି, ତୁମ୍ଭେ ଏକ ଏକ ଧାଡ଼ିରେ ଛଅ ଛଅ, ଏପରି ଦୁଇ ଧାଡ଼ି କରି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ନିର୍ମଳ ମେଜ ଉପରେ ତାହାସବୁ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ଆଉ, ପ୍ରତ୍ୟେକ ଧାଡ଼ି ଉପରେ ନିର୍ମଳ କୁନ୍ଦୁରୁ ଦେବ, ତାହା ସେହି ରୁଟିର ସ୍ମରଣାର୍ଥକ ଅଂଶ ରୂପେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ପୁଣି, ଯାଜକ ପ୍ରତ୍ୟେକ ବିଶ୍ରାମବାର ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାହା ନିତ୍ୟ ନିତ୍ୟ ସ୍ଥାପନ କରିବ; ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପକ୍ଷରେ ଏହା ଅନନ୍ତକାଳୀନ ନିୟମ। ");
INSERT INTO ory_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ପୁଣି, ତାହା ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କର ହେବ; ଆଉ, ସେମାନେ କୌଣସି ଏକ ପବିତ୍ର ସ୍ଥାନରେ ତାହା ଭୋଜନ କରିବେ, କାରଣ ତାହା ସଦାପ୍ରଭୁଙ୍କ ଅଗ୍ନିକୃତ ଉପହାର ମଧ୍ୟରେ ତାହା ପ୍ରତି ମହାପବିତ୍ର ଅଟେ; ଏହା ଅନନ୍ତକାଳୀନ ବିଧି।” ");
INSERT INTO ory_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ଏଥିଉତ୍ତାରେ ମିସରୀୟ ପୁରୁଷର ଔରସରେ ଇସ୍ରାଏଲ ବଂଶୀୟା ସ୍ତ୍ରୀଠାରୁ ଜାତ ଏକ ପୁତ୍ର ବାହାର ହୋଇ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଗଲା; ପୁଣି ଛାଉଣି ମଧ୍ୟରେ ସେହି ଇସ୍ରାଏଲୀୟା ସ୍ତ୍ରୀର ପୁତ୍ର ଓ ଇସ୍ରାଏଲୀୟ କୌଣସି ପୁରୁଷ ମଧ୍ୟରେ ବିବାଦ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ତହିଁରେ ସେହି ଇସ୍ରାଏଲୀୟା ସ୍ତ୍ରୀର ପୁତ୍ର (ସଦାପ୍ରଭୁଙ୍କ) ନାମକୁ ନିନ୍ଦା କରି ଅଭିଶାପ ଦେଲା; ତହୁଁ ଲୋକମାନେ ତାହାକୁ ମୋଶାଙ୍କ ନିକଟକୁ ଆଣିଲେ; ତାହାର ମାତାର ନାମ ଶଲୋମୀତ୍‍, ସେ ଦାନ୍ ବଂଶୀୟ ଦିବ୍ରିର କନ୍ୟା ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ପୁଣି ଲୋକମାନେ ସଦାପ୍ରଭୁଙ୍କ ମୁଖରୁ ଆଦେଶ ପାଇବା ଅପେକ୍ଷାରେ ତାହାକୁ ରୁଦ୍ଧ କରି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ଯେଉଁ ଲୋକ ଅଭିଶାପ ଦେଇଅଛି, ତାହାକୁ ଛାଉଣି ବାହାରକୁ ଆଣ; ପୁଣି ଯେଉଁମାନେ ତାହାର କଥା ଶୁଣିଅଛନ୍ତି, ସେମାନେ ସମସ୍ତେ ତାହାର ମସ୍ତକରେ ହସ୍ତ ଦିଅନ୍ତୁ, ପୁଣି ସମୁଦାୟ ମଣ୍ଡଳୀ ପଥର ମାରି ତାହାକୁ ବଧ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ଆଉ, ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଯେକେହି ଆପଣା ପରମେଶ୍ୱରଙ୍କୁ ଅଭିଶାପ ଦିଏ, ସେ ଆପଣା ଅପରାଧ ବୋହିବ। ");
INSERT INTO ory_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ପୁଣି, ଯେକେହି ଆପଣା ସଦାପ୍ରଭୁଙ୍କ ନାମର ନିନ୍ଦା କରେ, ସେ ଅବଶ୍ୟ ହତ ହେବ; ସମସ୍ତ ମଣ୍ଡଳୀ ତାହାକୁ ନିଶ୍ଚୟ ପଥର ମାରି ବଧ କରିବେ; ବିଦେଶୀ ହେଉ ବା ସ୍ୱଦେଶୀ ହେଉ, ସଦାପ୍ରଭୁଙ୍କ ନାମର ନିନ୍ଦା କଲେ ହତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","ଆଉ, ଯେକେହି କୌଣସି ମନୁଷ୍ୟକୁ ପ୍ରାଣାନ୍ତକ ଆଘାତ କରେ, ସେ ନିଶ୍ଚୟ ହତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ପୁଣି, ଯେକେହି କୌଣସି ପଶୁକୁ ପ୍ରାଣାନ୍ତକ ଆଘାତ କରେ, ସେ ତହିଁର ପରିଶୋଧ ଦେବ; ପ୍ରାଣ ପରିଶୋଧରେ ପ୍ରାଣ। ");
INSERT INTO ory_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ଆଉ, କୌଣସି ମନୁଷ୍ୟ ଯଦି ଆପଣା ପ୍ରତିବାସୀର ଶରୀରରେ ଖୁଣ କରେ, ତେବେ ସେ ଯେପରି କରିଅଛି, ସେହିପରି ତାହା ପ୍ରତି କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","କ୍ଷତ ପରିଶୋଧରେ କ୍ଷତ, ଚକ୍ଷୁ ପରିଶୋଧରେ ଚକ୍ଷୁ, ଦନ୍ତ ପରିଶୋଧରେ ଦନ୍ତ; ମନୁଷ୍ୟର ଦେହରେ ଯେ ଯେପରି ଖୁଣ କରିଅଛି, ତାହା ପ୍ରତି ସେହି ପ୍ରକାର କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ଯେଉଁ ଜନ ପଶୁ ବଧ କରେ, ସେ ତହିଁର ପରିଶୋଧ ଦେବ; ପୁଣି ଯେଉଁ ଜନ ନରହତ୍ୟା କରେ, ସେ ହତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ବିଦେଶୀ ହେଉ କି ସ୍ୱଦେଶୀ ହେଉ, ସେମାନଙ୍କ ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କର ଏକ-ପ୍ରକାର ବ୍ୟବସ୍ଥା ହେବ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ତହୁଁ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହନ୍ତେ, ଯେଉଁ ଲୋକ ଅଭିଶାପ ଦେଇଥିଲା, ତାହାକୁ ସେମାନେ ଛାଉଣିର ବାହାରକୁ ଆଣି ପଥର ମାରି ବଧ କଲେ; ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ସୀନୟ ପର୍ବତରେ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବା, ତୁମ୍ଭେମାନେ ସେହି ଦେଶରେ ପ୍ରବେଶ କଲେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଭୂମି ବିଶ୍ରାମ ଭୋଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ଛଅ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେ ଆପଣା କ୍ଷେତ୍ରରେ ବୀଜ ବୁଣିବ ଓ ଛଅ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେ ଆପଣା ଦ୍ରାକ୍ଷାଲତା ଝାଡ଼ିବ ଓ ତହିଁର ଫଳ ସଂଗ୍ରହ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ମାତ୍ର ସପ୍ତମ ବର୍ଷରେ ଭୂମିର ମହା ବିଶ୍ରାମ, ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ବିଶ୍ରାମ ହେବ; ତୁମ୍ଭେ ଆପଣା କ୍ଷେତ୍ରରେ ବୁଣିବ ନାହିଁ, କି ଆପଣା ଦ୍ରାକ୍ଷାଲତା ଝାଡ଼ିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ଯେଉଁ ଶସ୍ୟ ତୁମ୍ଭ କ୍ଷେତ୍ରରେ ଆପେ ବଢ଼େ, ତାହା ତୁମ୍ଭେ କାଟିବ ନାହିଁ ଓ ତୁମ୍ଭେ ଆପଣା ଅଝଡ଼ା ଦ୍ରାକ୍ଷାଲତାର ଫଳ ସଂଗ୍ରହ କରିବ ନାହିଁ; ତାହା ଭୂମିର ମହା ବିଶ୍ରାମ ବର୍ଷ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ଆଉ, ଭୂମିର ବିଶ୍ରାମ ତୁମ୍ଭମାନଙ୍କର ଭକ୍ଷ୍ୟ ସ୍ୱରୂପ ହେବ; ତୁମ୍ଭର କ୍ଷେତ୍ରୋତ୍ପନ୍ନ ସମସ୍ତ ଦ୍ରବ୍ୟ ତୁମ୍ଭର, ତୁମ୍ଭ ଦାସର, ତୁମ୍ଭ ଦାସୀର, ତୁମ୍ଭ ବେତନଜୀବୀର ଓ ତୁମ୍ଭ ସହବାସୀ ବିଦେଶୀର; ");
INSERT INTO ory_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ପୁଣି, ତୁମ୍ଭ ପଶୁର ଓ ତୁମ୍ଭ ଦେଶୀୟ ବନ୍ୟପଶୁର ଆହାର ନିମନ୍ତେ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","ଆଉ, ତୁମ୍ଭେ ଆପଣା ନିମନ୍ତେ ସାତ ବିଶ୍ରାମ ବର୍ଷ, ଅର୍ଥାତ୍‍, ସାତ ଗୁଣ ସାତ ବର୍ଷ ଗଣନା କରିବ; ତହିଁରେ ସେହି ସାତ ଗୁଣ ସାତ ବର୍ଷର ଦିନ ତୁମ୍ଭ ପ୍ରତି ଅଣଞ୍ଚାଶ ବର୍ଷ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ତହୁଁ ସପ୍ତମ ମାସର ଦଶମ ଦିନରେ ତୁମ୍ଭେ ମହାଶବ୍ଦକାରୀ ତୂରୀ ବଜାଇବ; ପ୍ରାୟଶ୍ଚିତ୍ତ ଦିନରେ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ସମସ୍ତ ଦେଶରେ ତୂରୀ ବଜାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ପୁଣି, ତୁମ୍ଭେମାନେ ପଚାଶତମ ବର୍ଷକୁ ପବିତ୍ର ରୂପେ ମାନ୍ୟ କରିବ, ଆଉ ସମୁଦାୟ ଦେଶରେ ତହିଁର ସମସ୍ତ ନିବାସୀମାନଙ୍କ ପ୍ରତି ମୁକ୍ତି ଘୋଷଣା କରିବ; ତାହା ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଯୋବେଲ (ମହା ଉଲ୍ଲାସ ଉତ୍ସବ) ହେବ ଓ ତୁମ୍ଭେମାନେ ପ୍ରତି ଜଣ ଆପଣା ଆପଣା ଅଧିକାରକୁ ଫେରିଯିବ ଓ ପ୍ରତି ଜଣ ଆପଣା ଆପଣା ବଂଶ ନିକଟକୁ ଫେରିଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ସେହି ପଚାଶତମ ବର୍ଷ ବ୍ୟାପି ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଯୋବେଲ ହେବ; ତୁମ୍ଭେମାନେ ବୁଣିବ ନାହିଁ କିଅବା ଯେଉଁ ଶସ୍ୟ ଆପେ ବଢ଼େ, ତାହା କାଟିବ ନାହିଁ ଓ ଅଝଡ଼ା ଦ୍ରାକ୍ଷାଲତାର ଫଳ ସଂଗ୍ରହ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","କାରଣ ତାହା ଯୋବେଲ ବର୍ଷ ଅଟେ; ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ପବିତ୍ର ହେବ; ତଥାପି ତୁମ୍ଭେମାନେ କ୍ଷେତ୍ରୋତ୍ପନ୍ନ ଶସ୍ୟାଦି ଖାଇ ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ସେହି ଯୋବେଲ ବର୍ଷରେ ପ୍ରତି ଜଣ ଆପଣା ଆପଣା ଅଧିକାରକୁ ଫେରିଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ଯଦି ତୁମ୍ଭେ ଆପଣା ପ୍ରତିବାସୀକୁ କୌଣସି ଭୂମ୍ୟାଦି ବିକ୍ରୟ କର, ଅବା ଆପଣା ପ୍ରତିବାସୀ ହସ୍ତରୁ କ୍ରୟ କର, ତେବେ ତୁମ୍ଭେମାନେ ପରସ୍ପର ପ୍ରତି ଅନ୍ୟାୟ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ତୁମ୍ଭେ ଯୋବେଲ ପରବର୍ଷର ସଂଖ୍ୟାନୁସାରେ ଆପଣା ପ୍ରତିବାସୀଠାରୁ କ୍ରୟ କରିବ ଓ ଫଳ ଉତ୍ପତ୍ତି ବର୍ଷର ସଂଖ୍ୟାନୁସାରେ ସେ ତୁମ୍ଭକୁ ବିକ୍ରୟ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ତୁମ୍ଭେ ବର୍ଷର ଆଧିକ୍ୟ ଅନୁସାରେ ତହିଁର ମୂଲ୍ୟ ବୃଦ୍ଧି କରିବ ଓ ବର୍ଷର ନ୍ୟୂନତାନୁସାରେ ମୂଲ୍ୟ ଊଣା କରିବ; କାରଣ ସେ ତୁମ୍ଭକୁ ଫଳ ଉତ୍ପତ୍ତି ବର୍ଷର ସଂଖ୍ୟାନୁସାରେ ଭୂମି ବିକ୍ରୟ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ତୁମ୍ଭେମାନେ ପରସ୍ପରର ଅନ୍ୟାୟ କରିବ ନାହିଁ, ମାତ୍ର ତୁମ୍ଭେ ଆପଣା ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କରିବ, କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","ଏଥିନିମନ୍ତେ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଧି ଅନୁସାରେ ଆଚରଣ କରିବ ଓ ଆମ୍ଭର ଶାସନସକଳ ମାନିବ ଓ ପାଳନ କରିବ; ତହିଁରେ ତୁମ୍ଭେମାନେ ଦେଶରେ ନିର୍ଭୟରେ ବାସ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ପୁଣି, ଭୂମି ନିଜ ଫଳ ଉତ୍ପନ୍ନ କରିବ, ତହିଁରେ ତୁମ୍ଭେମାନେ ତୃପ୍ତି ପର୍ଯ୍ୟନ୍ତ ଭୋଜନ କରିବ ଓ ଦେଶରେ ନିର୍ଭୟରେ ବାସ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ଆଉ ତୁମ୍ଭେମାନେ ଯଦି କହିବ, ଦେଖ, ଆମ୍ଭେମାନେ ତ ବୁଣିବୁ ନାହିଁ, କି ଉତ୍ପନ୍ନ ଫଳ ସଂଗ୍ରହ କରିବୁ ନାହିଁ, ତେବେ ଆମ୍ଭେମାନେ ସପ୍ତମ ବର୍ଷରେ କଅଣ ଖାଇବୁ? ");
INSERT INTO ory_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ଆମ୍ଭେ ଷଷ୍ଠ ବର୍ଷରେ ତୁମ୍ଭମାନଙ୍କ ଉପରେ ଆଶୀର୍ବାଦ ଆଜ୍ଞା କରିବା, ତହିଁରେ ତାହା ତିନି ବର୍ଷର ଫଳ ଉତ୍ପନ୍ନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ପୁଣି, ଅଷ୍ଟମ ବର୍ଷରେ ତୁମ୍ଭେମାନେ ବୁଣିବ ଓ ପୁରାତନ ଶସ୍ୟ ଖାଇବ; ନବମ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ଫଳ ଉତ୍ପନ୍ନ ହେବା ପର୍ଯ୍ୟନ୍ତ, ତୁମ୍ଭେମାନେ ପୁରାତନ ଶସ୍ୟ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","ଆଉ, ଭୂମି ସଦାକାଳ ନିମନ୍ତେ ବିକ୍ରୟ କରାଯିବ ନାହିଁ; କାରଣ ଭୂମି ଆମ୍ଭର; ତୁମ୍ଭେମାନେ ଆମ୍ଭ ସହିତ ବିଦେଶୀ ଓ ପ୍ରବାସୀ ଅଟ। ");
INSERT INTO ory_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ଆଉ, ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଅଧିକୃତ ଦେଶର ସମସ୍ତ ଭୂମି ମୁକ୍ତ କରିବାକୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ଯଦି ତୁମ୍ଭର ଭ୍ରାତା ଦରିଦ୍ର ହୋଇ ଆପଣା ଅଧିକାରରୁ କିଛି ବିକ୍ରୟ କରେ, ତେବେ ତାହାର ମୁକ୍ତିକର୍ତ୍ତା ନିକଟସ୍ଥ ଜ୍ଞାତି ଆସି ଆପଣା ଭ୍ରାତାର ବିକ୍ରୀତ ଭୂମି ମୁକ୍ତ କରି ନେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ପୁଣି, ଯଦି ତାହା ମୁକ୍ତ କରିବାକୁ ତାହାର କେହି ନ ଥାଏ ଓ ସେ ବର୍ଦ୍ଧିଷ୍ଣୁ ହୋଇ ତାହା ମୁକ୍ତ କରିବାକୁ ଯଥେଷ୍ଟ ଧନ ପାଏ, ");
INSERT INTO ory_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ତେବେ ସେ ତହିଁର ବିକ୍ରୟ ବର୍ଷ ଗଣନା କରୁ ଓ ତଦନୁସାରେ ଅତିରିକ୍ତ ମୂଲ୍ୟ କ୍ରୟକର୍ତ୍ତାକୁ ଫେରାଇ ଦେଉ; ତହିଁରେ ସେ ପୁନର୍ବାର ଆପଣା ଅଧିକାରକୁ ଫେରିଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ମାତ୍ର ଯଦି ସେ ତାହା ଫେରାଇ ନେବାକୁ ଅସମର୍ଥ ହୁଏ, ତେବେ ସେ ଯାହା ବିକ୍ରୟ କରିଅଛି, ତାହା ଯୋବେଲ ପର୍ଯ୍ୟନ୍ତ କ୍ରୟକର୍ତ୍ତାର ହସ୍ତରେ ରହିବ; ପୁଣି, ତାହା ଯୋବେଲ ସମୟରେ ମୁକ୍ତ ହେବ ଓ ସେ ପୁନର୍ବାର ଆପଣା ଅଧିକାରକୁ ଫେରିଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ଆଉ, ଯଦି କେହି ପ୍ରାଚୀର-ବେଷ୍ଟିତ ନଗରର ମଧ୍ୟବର୍ତ୍ତୀ ବାସଗୃହ ବିକ୍ରୟ କରେ, ତେବେ ସେ ବିକ୍ରୟ ବର୍ଷର ଶେଷ ପର୍ଯ୍ୟନ୍ତ ତାହା ମୁକ୍ତ କରି ପାରିବ; ପୂର୍ଣ୍ଣ ଏକ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ସେ ତାହା ମୁକ୍ତ କରିବାର ଅଧିକାର ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ମାତ୍ର ଯଦି ପୂର୍ଣ୍ଣ ଏକ ବର୍ଷ ମଧ୍ୟରେ ତାହା ମୁକ୍ତ କରା ନ ଯାଏ, ତେବେ ପ୍ରାଚୀର-ବେଷ୍ଟିତ ନଗର ମଧ୍ୟବର୍ତ୍ତୀ ସେହି ଗୃହ ପୁରୁଷ-ପରମ୍ପରାରେ କ୍ରୟକର୍ତ୍ତାର ନିତ୍ୟ ଅଧିକାର ହେବ; ଯୋବେଲ ସମୟରେ ତାହା ମୁକ୍ତ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ମାତ୍ର ପ୍ରାଚୀରହୀନ ଗ୍ରାମର ମଧ୍ୟବର୍ତ୍ତୀ ଗୃହଗୁଡ଼ିକ ଦେଶର କ୍ଷେତ୍ର ମଧ୍ୟରେ ଗଣାଯିବ ତାହା ମୁକ୍ତ ହୋଇପାରେ, ପୁଣି ଯୋବେଲ ସମୟରେ ତାହା ମୁକ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ମାତ୍ର ଲେବୀୟମାନଙ୍କର ନଗରସକଳ, ସେମାନଙ୍କ ଅଧିକୃତ ନଗରର ଗୃହସକଳ ମୁକ୍ତ କରିବାର ଅଧିକାର ଲେବୀୟମାନଙ୍କ ପକ୍ଷରେ ଅନନ୍ତକାଳସ୍ଥାୟୀ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ପୁଣି, ଯଦି କେହି ଲେବୀୟମାନଙ୍କଠାରୁ ତାହା ମୁକ୍ତ କରେ, ତେବେ ସେହି ବିକ୍ରୀତ ଗୃହ ଓ ତାହାର ଅଧିକୃତ ନଗର ଯୋବେଲ ସମୟରେ ମୁକ୍ତ ହେବ; କାରଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଲେବୀୟମାନଙ୍କ ଗୃହସକଳ ସେମାନଙ୍କର ଅଧିକାର। ");
INSERT INTO ory_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ମାତ୍ର ସେମାନଙ୍କ ନଗରର ପ୍ରାନ୍ତର ଭୂମି ବିକ୍ରୟ କରାଯିବ ନାହିଁ; କାରଣ ତାହା ସେମାନଙ୍କର ଅନନ୍ତକାଳୀନ ଅଧିକାର। ");
INSERT INTO ory_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","ଆଉ ଯଦି ତୁମ୍ଭର ଭାଇ ଦରିଦ୍ର ହୋଇଯାଏ ଓ ତୁମ୍ଭ ନିକଟରେ ତାହାର ହାତ ପଡ଼ିଯାଏ, ତେବେ ତୁମ୍ଭେ ତାହାକୁ ଧରି ରଖିବ; ସେ ବିଦେଶୀ ଓ ପ୍ରବାସୀ ପରି ତୁମ୍ଭ ସହିତ ଜୀବନ ଯାପନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ତୁମ୍ଭେ ତାହାଠାରୁ ସୁଧ କି ଦେଢ଼ି (ଦେଢ଼ଗୁଣ ସୁଧହାର) ନିଅ ନାହିଁ; ମାତ୍ର ଆପଣା ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କର; ତହିଁରେ ତୁମ୍ଭର ଭାଇ ତୁମ୍ଭ ସହିତ ଜୀବନ ଯାପନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ତୁମ୍ଭେ ସୁଧରେ ତାହାକୁ ଟଙ୍କା ଦେବ ନାହିଁ, କିଅବା ଦେଢ଼ି (ଦେଢ଼ଗୁଣ ସୁଧହାର) ପାଇଁ ତାହାକୁ ଆପଣା ଅନ୍ନ ଦେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ଯେ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ହେବା ପାଇଁ ତୁମ୍ଭମାନଙ୍କୁ କିଣାନ ଦେଶ ଦେବା ନିମନ୍ତେ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲେ, ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ସେହି ସଦାପ୍ରଭୁ ଆମ୍ଭେ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","ଆଉ ଯଦି ତୁମ୍ଭ ଭାଇ ଦରିଦ୍ର ହୋଇଯାଏ ଓ ତୁମ୍ଭ ନିକଟରେ ଆପଣାକୁ ବିକ୍ରୟ କରେ, ତେବେ ତୁମ୍ଭେ ତାହାକୁ ବନ୍ଧାଦାସ ପରି ପରିଶ୍ରମ କରାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ସେ ବେତନଜୀବୀ ଓ ପ୍ରବାସୀ ନ୍ୟାୟ ତୁମ୍ଭ ସହିତ ବାସ କରିବ; ସେ ଯୋବେଲ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭର ଦାସ୍ୟକର୍ମ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ତହୁଁ ସେ ଆପଣା ସନ୍ତାନଗଣ ସହିତ ତୁମ୍ଭଠାରୁ ମୁକ୍ତ ହୋଇ ଆପଣା ବଂଶ ନିକଟକୁ ଓ ତାହାର ପୈତୃକ ଅଧିକାରକୁ ଫେରିଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","କାରଣ ସେମାନେ ଆମ୍ଭର ଦାସ, ଆମ୍ଭେ ସେମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଅଛୁ; ସେମାନେ ବନ୍ଧାଦାସ ତୁଲ୍ୟ ବିକ୍ରୀତ ହେବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ତୁମ୍ଭେ ତାହା ଉପରେ କଠିନ କର୍ତ୍ତୃତ୍ୱ କରିବ ନାହିଁ; ମାତ୍ର ଆପଣା ପରମେଶ୍ୱରଙ୍କୁ ଭୟ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ତୁମ୍ଭର ବନ୍ଧାଦାସ ଓ ବନ୍ଧାଦାସୀ ରଖିବାର ହେଲେ, ତୁମ୍ଭେମାନେ ଆପଣା ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ଅନ୍ୟ ଦେଶୀୟମାନଙ୍କଠାରୁ ବନ୍ଧାଦାସ ଓ ବନ୍ଧାଦାସୀ କ୍ରୟ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ଆହୁରି ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସୀ ବିଦେଶୀୟ ସନ୍ତାନଗଣଠାରୁ ଓ ତୁମ୍ଭମାନଙ୍କ ଦେଶରେ ସେମାନଙ୍କଠାରୁ ଉତ୍ପନ୍ନ ଯେଉଁ ଯେଉଁ ବଂଶ ତୁମ୍ଭମାନଙ୍କର ସହବର୍ତ୍ତୀ ଥାʼନ୍ତି, ସେମାନଙ୍କଠାରୁ କ୍ରୟ କରିବ, ପୁଣି, ସେମାନେ ତୁମ୍ଭମାନଙ୍କର ଅଧିକାର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ପୁଣି, ତୁମ୍ଭେମାନେ ଆପଣା ଉତ୍ତାରେ ଆପଣା ଭବିଷ୍ୟତ ସନ୍ତାନଗଣର ଅଧିକାର ନିମନ୍ତେ ପୈତୃକ ସମ୍ପତ୍ତି ରୂପେ ସେମାନଙ୍କୁ ଦେଇ ପାରିବ; ତୁମ୍ଭେମାନେ ସେମାନଙ୍କୁ ନିତ୍ୟ ଆପଣାମାନଙ୍କର ଦାସ୍ୟକର୍ମ କରାଇ ପାରିବ; ମାତ୍ର ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଭ୍ରାତା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଉପରେ ପରସ୍ପର କଠିନ କର୍ତ୍ତୃତ୍ୱ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","ଆଉ ଯଦି ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ କୌଣସି ବିଦେଶୀ କି ପ୍ରବାସୀ ଲୋକର ହସ୍ତ ଧନରେ ବଢ଼େ, ପୁଣି, ତାହାର ନିକଟବର୍ତ୍ତୀ ତୁମ୍ଭର ଭ୍ରାତା ଦରିଦ୍ର ହୋଇଯାଏ ଓ ସେହି ବିଦେଶୀ କି ପ୍ରବାସୀ କିଅବା ସେହି ବିଦେଶୀ ବଂଶରୁ ଉତ୍ପନ୍ନ କାହାରି ନିକଟରେ ଆପଣାକୁ ବିକ୍ରୟ କରେ; ");
INSERT INTO ory_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ତେବେ ସେହି ବିକ୍ରୟ ଉତ୍ତାରେ ତାହାର ମୁକ୍ତି ହୋଇ ପାରିବ; ତାହାର ଜ୍ଞାତି ମଧ୍ୟରୁ କେହି ତାହାକୁ ମୁକ୍ତ କରି ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","କିଅବା ତାହାର ପିତୃବ୍ୟ କି ପିତୃବ୍ୟପୁତ୍ର ତାହାକୁ ମୁକ୍ତ କରି ପାରିବ, ଅବା ତାହାର ବଂଶଜାତ ନିକଟବର୍ତ୍ତୀ କୌଣସି ଜ୍ଞାତି ତାହାକୁ ମୁକ୍ତ କରି ପାରିବ; ଅବା ଯଦି ତାହାର ହସ୍ତ ଧନରେ ବୃଦ୍ଧି ପାଏ, ତେବେ ସେ ଆପଣାକୁ ମୁକ୍ତ କରି ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ତହିଁରେ ତାହାର ବିକ୍ରୟ ବର୍ଷଠାରୁ ଯୋବେଲ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ସେ କ୍ରୟକର୍ତ୍ତା ସହିତ ଗଣନା କରିବ, ପୁଣି ବିକ୍ରୟ ବର୍ଷର ସଂଖ୍ୟାନୁସାରେ ତାହାର ମୂଲ୍ୟ ହେବ; ବେତନଜୀବୀର ଦିନ ତୁଲ୍ୟ ତାହାର ଦାସତ୍ୱ କାଳ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ଯଦି ଅନେକ ବର୍ଷ ବାକି ଥାଏ, ତେବେ ତଦନୁସାରେ ସେ କ୍ରୟମୂଲ୍ୟରୁ ଆପଣା ମୁକ୍ତିର ମୂଲ୍ୟ ଫେରାଇ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ଆଉ ଯଦି ଯୋବେଲ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ଅଳ୍ପ ବର୍ଷ ବାକି ଥାଏ, ତେବେ ସେ ତାହା ସହିତ ଗଣନା କରିବ; ସେହି ସେହି ବର୍ଷାନୁସାରେ ସେ ଆପଣା ମୁକ୍ତିର ମୂଲ୍ୟ ଫେରାଇ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ବର୍ଷକୁ ବର୍ଷ ନିଯୁକ୍ତ ଦାସ ତୁଲ୍ୟ ସେ ତାହା ସହିତ ରହିବ; ତୁମ୍ଭ ସାକ୍ଷାତରେ ତାହା ଉପରେ କେହି କଠିନ କର୍ତ୍ତୃତ୍ୱ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ଆଉ ଯଦି ସେ ଏହିରୂପେ ମୁକ୍ତ ନ ହୁଏ, ତେବେ ସେ ଯୋବେଲ ବର୍ଷରେ ଆପଣା ସନ୍ତାନଗଣ ସହିତ ମୁକ୍ତ ହୋଇ ବାହାରି ଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","କାରଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ କେବଳ ଆମ୍ଭର ଦାସ, ସେମାନେ ଆମ୍ଭର ଦାସ, ଆମ୍ଭେ ସେମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଅଛୁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଦେବମୂର୍ତ୍ତି ନିର୍ମାଣ କରିବ ନାହିଁ, କିଅବା ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଖୋଦିତ ପ୍ରତିମା କି ସ୍ତମ୍ଭ ସ୍ଥାପନ କରିବ ନାହିଁ ଓ ତାହା ନିକଟରେ ପ୍ରଣାମ କରିବା ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କ ଦେଶରେ କୌଣସି ଖୋଦିତ ପ୍ରସ୍ତର ରଖିବ ନାହିଁ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ତୁମ୍ଭେମାନେ ଆମ୍ଭର ସକଳ ବିଶ୍ରାମ ଦିବସ ପାଳନ କରିବ ଓ ଆମ୍ଭର ପବିତ୍ର ସ୍ଥାନକୁ ସମାଦର କରିବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","ଯଦି ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିଧି ଅନୁସାରେ ଚ଼ାଲିବ ଓ ଆମ୍ଭର ଆଜ୍ଞା ମାନ୍ୟ କରି ପାଳନ କରିବ; ");
INSERT INTO ory_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ତେବେ ଆମ୍ଭେ ଉପଯୁକ୍ତ ସମୟରେ ତୁମ୍ଭମାନଙ୍କୁ ବୃଷ୍ଟିଦାନ କରିବା, ତହିଁରେ ଭୂମି ନିଜ ଶସ୍ୟର ପୂର୍ଣ୍ଣତା ଉତ୍ପନ୍ନ କରିବ ଓ କ୍ଷେତ୍ରର ବୃକ୍ଷସକଳ ଆପଣା ଆପଣା ଫଳ ଉତ୍ପନ୍ନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ଆଉ ତୁମ୍ଭମାନଙ୍କର ଶସ୍ୟମର୍ଦ୍ଦନର ସମୟ ଦ୍ରାକ୍ଷା ସଂଗ୍ରହର ସମୟ ପର୍ଯ୍ୟନ୍ତ ଲାଗିବ ଓ ଦ୍ରାକ୍ଷା ସଂଗ୍ରହର ସମୟ ବୀଜ ବୁଣିବାର ସମୟ ପର୍ଯ୍ୟନ୍ତ ଲାଗିବ; ପୁଣି ତୁମ୍ଭେମାନେ ତୃପ୍ତି ପର୍ଯ୍ୟନ୍ତ ଅନ୍ନ ଭୋଜନ କରିବ ଓ ଆପଣା ଦେଶରେ ନିର୍ଭୟରେ ବାସ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ଆଉ, ଆମ୍ଭେ ଦେଶରେ ଶାନ୍ତି ପ୍ରଦାନ କରିବା, ତହିଁରେ ତୁମ୍ଭେମାନେ ଶୟନ କଲେ, କେହି ତୁମ୍ଭମାନଙ୍କୁ ଭୟ ଦେଖାଇବ ନାହିଁ; ପୁଣି ଆମ୍ଭେ ହିଂସ୍ରକ ଜନ୍ତୁମାନଙ୍କୁ ଦେଶରୁ ଦୂର କରିବା ଓ ତୁମ୍ଭମାନଙ୍କ ଦେଶରେ ଖଡ୍ଗ ଭ୍ରମଣ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ଆଉ ତୁମ୍ଭେମାନେ ଆପଣା ଶତ୍ରୁମାନଙ୍କୁ ଘଉଡ଼ାଇ ଦେବ ଓ ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ଆଗେ ଖଡ୍ଗରେ ପଡ଼ିବେ। ");
INSERT INTO ory_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ପୁଣି ତୁମ୍ଭମାନଙ୍କର ପାଞ୍ଚ ଜଣ ଶହେ ଜଣଙ୍କୁ ଘଉଡ଼ାଇ ଦେବ ଓ ତୁମ୍ଭମାନଙ୍କର ଶହେ ଜଣ ଦଶ ସହସ୍ର ଜଣଙ୍କୁ ଘଉଡ଼ାଇ ଦେବ; ଆଉ ତୁମ୍ଭମାନଙ୍କର ଶତ୍ରୁଗଣ ତୁମ୍ଭମାନଙ୍କ ଆଗେ ଖଡ୍ଗରେ ପଡ଼ିବେ। ");
INSERT INTO ory_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ଆଉ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ପ୍ରସନ୍ନମୁଖ ହେବା ଓ ତୁମ୍ଭମାନଙ୍କୁ ପ୍ରଜାବନ୍ତ ଓ ବହୁବଂଶ କରିବା ଓ ତୁମ୍ଭମାନଙ୍କ ସହିତ ଆପଣା ନିୟମ ସ୍ଥିର କରିବା। ");
INSERT INTO ory_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ପୁଣି ତୁମ୍ଭେମାନେ ବହୁସମୟର ସଞ୍ଚିତ ପୁରାତନ ଶସ୍ୟ ଭୋଜନ କରିବ ଓ ତୁମ୍ଭେମାନେ ନୂତନ ଶସ୍ୟ ହେତୁ ପୁରାତନ ଶସ୍ୟ ବାହାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ଆଉ ଆମ୍ଭେ ଆପଣା ଆବାସ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ସ୍ଥାପନ କରିବା ଓ ଆମ୍ଭର ପ୍ରାଣ ତୁମ୍ଭମାନଙ୍କୁ ଘୃଣା କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ପୁଣି ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଗମନାଗମନ କରିବା ଓ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ହେବା ଓ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ଲୋକ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ତୁମ୍ଭେମାନେ ଯେପରି ସେମାନଙ୍କର ଦାସ ନ ହେବ, ଏଥିପାଇଁ ଯେ ତୁମ୍ଭମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲେ, ସେହି ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭେ ଅଟୁ; ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଯୁଆଳିର ଯୋତ ଭାଙ୍ଗିଅଛୁ ଓ ତୁମ୍ଭମାନଙ୍କୁ ସିଧା ଚାଲିବାକୁ ଦେଇଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","ମାତ୍ର, ଯଦି ତୁମ୍ଭେମାନେ ଆମ୍ଭ ବାକ୍ୟରେ ମନୋଯୋଗ ନ କରିବ ଓ ସେହି ସକଳ ଆଜ୍ଞା ପାଳନ ନ କରିବ; ");
INSERT INTO ory_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ପୁଣି, ଯଦି ତୁମ୍ଭେମାନେ ଆମ୍ଭ ବିଧି ଅବଜ୍ଞା କରିବ ଓ ତୁମ୍ଭମାନଙ୍କ ପ୍ରାଣ ଆମ୍ଭର ସକଳ ଶାସନ ଘୃଣା କରିବାରୁ ତୁମ୍ଭେମାନେ ଆମ୍ଭର ଆଜ୍ଞାସକଳ ପାଳନ ନ କରିବ, ମାତ୍ର ଆମ୍ଭର ନିୟମ ଲଙ୍ଘନ କରିବ, ");
INSERT INTO ory_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ତେବେ ଆମ୍ଭେ ମଧ୍ୟ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଏହିରୂପେ ବ୍ୟବହାର କରିବା; ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଉପରେ ବ୍ୟାକୁଳତା ନିରୂପଣ କରିବା; ଅର୍ଥାତ୍‍, ଯକ୍ଷ୍ମା ଓ ଜ୍ୱର, ତାହା ତୁମ୍ଭମାନଙ୍କ ଚକ୍ଷୁ କ୍ଷୀଣ କରିବ ଓ ପ୍ରାଣ କ୍ଷୟ କରିବ; ଆଉ ତୁମ୍ଭେମାନେ ବୃଥାରେ ଆପଣାମାନଙ୍କ ବୀଜ ବୁଣିବ, କାରଣ ତୁମ୍ଭମାନଙ୍କ ଶତ୍ରୁମାନେ ତାହା ଖାଇବେ। ");
INSERT INTO ory_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ପୁଣି ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ଆପଣା ମୁଖ ରଖିବା, ତହିଁରେ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଶତ୍ରୁଗଣଠାରୁ ପରାସ୍ତ ହେବ; ଯେଉଁମାନେ ତୁମ୍ଭମାନଙ୍କୁ ଘୃଣା କରନ୍ତି, ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ଉପରେ କର୍ତ୍ତୃତ୍ୱ କରିବେ ଓ କେହି ତୁମ୍ଭମାନଙ୍କ ପଛେ ନ ଗୋଡ଼ାଇଲେ ହେଁ ତୁମ୍ଭେମାନେ ପଳାଇଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","ଆଉ ଏହା ହେଲେ ମଧ୍ୟ ଯଦି ତୁମ୍ଭେମାନେ ଆମ୍ଭ ବାକ୍ୟରେ ମନୋଯୋଗ ନ କରିବ, ତେବେ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ପାପ ସକାଶୁ ତୁମ୍ଭମାନଙ୍କୁ ସାତ ଗୁଣ ଅଧିକ ଦଣ୍ଡ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ପୁଣି ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ବଳର ଗର୍ବ ଖର୍ବ କରିବା ଓ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଆକାଶ ଲୌହ ତୁଲ୍ୟ ଓ ଭୂମି ପିତ୍ତଳ ତୁଲ୍ୟ କରିବା। ");
INSERT INTO ory_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ତହିଁରେ ତୁମ୍ଭେମାନେ ବୃଥାରେ ବଳ ବ୍ୟୟ କରିବ, କାରଣ ତୁମ୍ଭମାନଙ୍କ ଭୂମି ଶସ୍ୟ ଉତ୍ପନ୍ନ କରିବ ନାହିଁ ଓ କ୍ଷେତ୍ରର ବୃକ୍ଷସକଳ ଫଳ ଉତ୍ପନ୍ନ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","ଆଉ, ଯଦି ତୁମ୍ଭେମାନେ ଆମ୍ଭର ବିରୁଦ୍ଧାଚରଣ କରି ଆମ୍ଭ ବାକ୍ୟ ଶୁଣିବାକୁ ଅସମ୍ମତ ହେବ; ତେବେ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ପାପ ଅନୁସାରେ ତୁମ୍ଭମାନଙ୍କୁ ସାତ ଗୁଣ କ୍ଲେଶ ଦେବା। ");
INSERT INTO ory_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ପୁଣି ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ବନ୍ୟ ପଶୁମାନଙ୍କୁ ପଠାଇବା, ତହିଁରେ ସେମାନେ ତୁମ୍ଭମାନଙ୍କୁ ସନ୍ତାନହୀନ କରିବେ ଓ ତୁମ୍ଭମାନଙ୍କ ପଶୁମାନଙ୍କୁ ବିନଷ୍ଟ କରିବେ, ପୁଣି ତୁମ୍ଭମାନଙ୍କୁ ଅଳ୍ପସଂଖ୍ୟକ କରିବେ; ଆଉ ତୁମ୍ଭମାନଙ୍କ ରାଜପଥସକଳ ଜନମାନବ ଶୂନ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ଏହା ହେଲେ ମଧ୍ୟ ଯଦି ତୁମ୍ଭେମାନେ ଆମ୍ଭ ପ୍ରତି ସୁଧୁରିବ ନାହିଁ, ମାତ୍ର ଆମ୍ଭର ବିରୁଦ୍ଧାଚରଣ କରିବ, ");
INSERT INTO ory_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ତେବେ ଆମ୍ଭେ ମଧ୍ୟ ତୁମ୍ଭମାନଙ୍କର ବିରୁଦ୍ଧାଚରଣ କରିବା ଓ ତୁମ୍ଭମାନଙ୍କୁ ପ୍ରହାର କରିବା, ଆମ୍ଭେ ନିଜେ ତୁମ୍ଭମାନଙ୍କ ପାପ ସକାଶୁ ତୁମ୍ଭମାନଙ୍କୁ ସାତ ଗୁଣ ପ୍ରହାର କରିବା। ");
INSERT INTO ory_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ପୁଣି ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଉପରକୁ ଖଡ୍ଗ ଆଣିବା, ତାହା ନିୟମ ଲଙ୍ଘନର ପ୍ରତିଫଳ ଦେବ ଓ ତୁମ୍ଭେମାନେ ନଗର ମଧ୍ୟରେ ଏକତ୍ର ହେଲେ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟକୁ ମହାମାରୀ ପଠାଇବା; ତହିଁରେ ତୁମ୍ଭେମାନେ ଶତ୍ରୁ ହସ୍ତରେ ସମର୍ପିତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ଅନ୍ନରୂପ ଯଷ୍ଟି ଭାଙ୍ଗିଲେ ଦଶ ଜଣ ସ୍ତ୍ରୀ ଗୋଟିଏ ଚୁଲ୍ଲୀରେ ତୁମ୍ଭମାନଙ୍କର ରୁଟି ରନ୍ଧନ କରିବେ ଓ ପୁନର୍ବାର ତୌଲି ତୁମ୍ଭମାନଙ୍କୁ ରୁଟି ଦେବେ, ଆଉ ତୁମ୍ଭେମାନେ ତାହା ଭୋଜନ କରିବ, ମାତ୍ର ତୃପ୍ତ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ଏହା ହେଲେ ହେଁ ଯଦି ତୁମ୍ଭେମାନେ ଆମ୍ଭ କଥା ଶୁଣିବ ନାହିଁ, ମାତ୍ର ଆମ୍ଭର ବିରୁଦ୍ଧାଚରଣ କରିବ; ");
INSERT INTO ory_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ତେବେ ଆମ୍ଭେ କ୍ରୋଧରେ ତୁମ୍ଭମାନଙ୍କର ବିରୁଦ୍ଧାଚରଣ କରିବା ଓ ଆମ୍ଭେ ମଧ୍ୟ ତୁମ୍ଭମାନଙ୍କ ପାପ ସକାଶୁ ତୁମ୍ଭମାନଙ୍କୁ ସାତ ଗୁଣ ଶାସ୍ତି ଦେବା। ");
INSERT INTO ory_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ତହିଁରେ ତୁମ୍ଭେମାନେ ଆପଣା ପୁତ୍ରଗଣର ଓ କନ୍ୟାଗଣର ମାଂସ ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ପୁଣି ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ଉଚ୍ଚ ସ୍ଥଳସକଳ ଭାଙ୍ଗିବା ଓ ତୁମ୍ଭମାନଙ୍କ ସୂର୍ଯ୍ୟ ପ୍ରତିମାସକଳ କାଟି ପକାଇବା ଓ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତିମାଗଣର ଦେହ ଉପରେ ତୁମ୍ଭମାନଙ୍କ ମୃତ ଦେହ ପକାଇବା ଓ ଆମ୍ଭର ପ୍ରାଣ ତୁମ୍ଭମାନଙ୍କୁ ଘୃଣା କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ନଗରସକଳ ମରୁଭୂମି କରିବା ଓ ତୁମ୍ଭମାନଙ୍କ ପବିତ୍ର ସ୍ଥାନସକଳ ଶୂନ୍ୟ କରିବା ଓ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର (ଦତ୍ତ) ତୁଷ୍ଟିଜନକ ସୁଗନ୍ଧି ଆଘ୍ରାଣ କରିବା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ପୁଣି ଆମ୍ଭେ ଦେଶକୁ ଶୂନ୍ୟସ୍ଥାନ କରିବା ଓ ତନ୍ନିବାସୀ ତୁମ୍ଭମାନଙ୍କ ଶତ୍ରୁଗଣ ତହିଁରେ ଆଶ୍ଚର୍ଯ୍ୟ ଜ୍ଞାନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ଆଉ ଆମ୍ଭେ ନାନା ଦେଶୀୟ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ତୁମ୍ଭମାନଙ୍କୁ ଛିନ୍ନଭିନ୍ନ କରିବା ଓ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ପଶ୍ଚାତ୍‍ ଖଡ୍ଗ ନିଷ୍କୋଷ କରିବା; ତହିଁରେ ତୁମ୍ଭମାନଙ୍କ ଦେଶ ଶୂନ୍ୟସ୍ଥାନ ହେବ ଓ ତୁମ୍ଭମାନଙ୍କ ନଗରସକଳ ମରୁଭୂମି ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ତେବେ ଯେପର୍ଯ୍ୟନ୍ତ ଦେଶ ଶୂନ୍ୟସ୍ଥାନ ହୋଇଥିବ ଓ ତୁମ୍ଭେମାନେ ଆପଣା ଶତ୍ରୁଗଣର ଦେଶରେ ରହିବ, ସେପର୍ଯ୍ୟନ୍ତ ଭୂମି ଆପଣା ବିଶ୍ରାମ ଗ୍ରହଣ କରିବ; ଅର୍ଥାତ୍‍, ସେହି ସମୟରେ ଭୂମି ବିଶ୍ରାମ କରି ଆପଣା ବିଶ୍ରାମ ଗ୍ରହଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ଯେତେକାଳ ତାହା ଶୂନ୍ୟସ୍ଥାନ ହୋଇ ରହିବ, ସେତେକାଳ ତାହା ବିଶ୍ରାମ ପାଇବ; ଅର୍ଥାତ୍‍, ତୁମ୍ଭେମାନେ ତହିଁ ମଧ୍ୟରେ ବାସ କରିବା ସମୟରେ ତୁମ୍ଭମାନଙ୍କ ବିଶ୍ରାମ କାଳରେ ତାହା ଯେଉଁ ବିଶ୍ରାମ ପାଇ ନ ଥିଲା, ତାହା ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ପୁଣି ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଯେତେ ଅବଶିଷ୍ଟ ରହିବେ, ଆମ୍ଭେ ଶତ୍ରୁଗଣର ଦେଶରେ ସେମାନଙ୍କ ହୃଦୟରେ ଭୀରୁତା ପଠାଇବା ଯଦ୍ଦ୍ୱାରା (ବାୟୁରେ) ଚାଳିତ ପତ୍ରର ଶବ୍ଦ ମଧ୍ୟ ସେମାନଙ୍କୁ ଘଉଡ଼ାଇ ଦେବ; ପୁଣି ଖଡ୍ଗଧାରରୁ ପଳାଇଲା ଲୋକ ପରି ସେମାନେ ପଳାଇବେ ଓ କେହି ସେମାନଙ୍କୁ ନ ଗୋଡ଼ାଇଲେ ହେଁ ସେମାନେ ପତିତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ପୁଣି କେହି ନ ଗୋଡ଼ାଇଲେ ହେଁ ଯେପରି ଖଡ୍ଗ ସମ୍ମୁଖରେ, ସେପରି ସେମାନେ ପରସ୍ପର ଉପରେ ଝୁଣ୍ଟି ପଡ଼ିବେ ଓ ଶତ୍ରୁଗଣ ସମ୍ମୁଖରେ ଠିଆ ହେବା ପାଇଁ ସେମାନଙ୍କର ବଳ ପାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ଆଉ ତୁମ୍ଭେମାନେ ଅନ୍ୟ ଦେଶୀୟ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ବିନଷ୍ଟ ହେବ ଓ ତୁମ୍ଭମାନଙ୍କ ଶତ୍ରୁଗଣର ଦେଶ ତୁମ୍ଭମାନଙ୍କୁ ଗ୍ରାସ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ପୁଣି ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ଯେଉଁମାନେ ଅବଶିଷ୍ଟ ରହିବେ, ସେମାନେ ଆପଣା ଆପଣା ଅପରାଧ ସକାଶୁ ତୁମ୍ଭମାନଙ୍କ ଶତ୍ରୁଗଣର ଦେଶରେ କ୍ଷୟ ପାଇବେ ଓ ମଧ୍ୟ ସେମାନେ ଆପଣା ଆପଣା ପିତୃଗଣର ଅପରାଧ ସକାଶୁ ସେମାନଙ୍କ ସଙ୍ଗରେ କ୍ଷୟ ପାଇବେ। ");
INSERT INTO ory_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","ଆଉ ଆମ୍ଭ ବିରୁଦ୍ଧରେ ସତ୍ୟ-ଲଙ୍ଘନ କରି ସେମାନେ ଓ ସେମାନଙ୍କ ପିତୃଗଣ ଯେଉଁ ସତ୍ୟ-ଲଙ୍ଘନ ଅପରାଧ କଲେ, ଆପଣାମାନଙ୍କର ସେହି ଅପରାଧ; ");
INSERT INTO ory_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ଓ ମଧ୍ୟ ସେମାନେ ଆମ୍ଭର ବିରୁଦ୍ଧାଚରଣ କରିବା ହେତୁ ଆମ୍ଭେ ହିଁ ଯେ ସେମାନଙ୍କର ବିରୁଦ୍ଧାଚରଣ କରି ସେମାନଙ୍କୁ ସେମାନଙ୍କ ଶତ୍ରୁଗଣର ଦେଶକୁ ଆଣିଲୁ, ଏହା ସେମାନେ ସ୍ୱୀକାର କରିବେ; ତହିଁରେ ଯଦି ସେମାନଙ୍କ ଅସୁନ୍ନତ ହୃଦୟ ନମ୍ର ହେବ ଓ ସେମାନେ ଆପଣା ଆପଣା ଅପରାଧର ଦଣ୍ଡ ଗ୍ରହଣ କରିବେ; ");
INSERT INTO ory_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ତେବେ ଆମ୍ଭେ ଯାକୁବ ସହିତ ଆପଣା ନିୟମ ସ୍ମରଣ କରିବା ଓ ମଧ୍ୟ ଇସ୍‌ହାକ ସହିତ ଆପଣା ନିୟମ ଓ ମଧ୍ୟ ଅବ୍ରହାମ ସହିତ ଆପଣା ନିୟମ ସ୍ମରଣ କରିବା; ପୁଣି ଆମ୍ଭେ ଦେଶକୁ ସ୍ମରଣ କରିବା। ");
INSERT INTO ory_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ଦେଶ ମଧ୍ୟ ସେମାନଙ୍କ ଦ୍ୱାରା ତ୍ୟକ୍ତ ହୋଇ ରହିବ ଓ ସେମାନଙ୍କ ଅନୁପସ୍ଥିତିରେ ଶୂନ୍ୟସ୍ଥାନ ହୋଇ ପଡ଼ିଥିବା ସମୟରେ ଆପଣା ବିଶ୍ରାମ ଗ୍ରହଣ କରିବ; ପୁଣି ସେମାନେ ଆପଣା ଆପଣା ଅପରାଧର ଦଣ୍ଡ ଗ୍ରହଣ କରିବେ; ଏଥିର କାରଣ ଏହି ଯେ, ସେମାନେ ଆମ୍ଭର ଆଜ୍ଞା ଅଗ୍ରାହ୍ୟ କଲେ ଓ ସେମାନଙ୍କ ପ୍ରାଣ ଆମ୍ଭ ବିଧି ଘୃଣା କଲା। ");
INSERT INTO ory_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ତଥାପି ଏହିସବୁ କାରଣରୁ, ସେମାନେ ଆପଣାମାନଙ୍କ ଶତ୍ରୁଗଣର ଦେଶରେ ଥିବା ସମୟରେ ଆମ୍ଭେ ସେମାନଙ୍କୁ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ବିନାଶ କରିବା ନିମନ୍ତେ ଓ ସେମାନଙ୍କ ସହିତ ଆପଣା ନିୟମ ଭାଙ୍ଗିବା ନିମନ୍ତେ ସେମାନଙ୍କୁ ଅଗ୍ରାହ୍ୟ କରିବା ନାହିଁ, କିଅବା ସେମାନଙ୍କୁ ଘୃଣା କରିବା ନାହିଁ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ ସେମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ମାତ୍ର ଆମ୍ଭେ ସେମାନଙ୍କ ଲାଗି ସେମାନଙ୍କ ପୂର୍ବପୁରୁଷମାନଙ୍କ ସହିତ କରିଥିବା ଆପଣା ନିୟମ ସ୍ମରଣ କରିବା, ଆମ୍ଭେ ସେମାନଙ୍କର ପରମେଶ୍ୱର ହେବା ନିମନ୍ତେ ଅନ୍ୟ ଦେଶୀୟ ଲୋକମାନଙ୍କ ସାକ୍ଷାତରେ ସେମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଅଛୁ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ସଦାପ୍ରଭୁ ସୀନୟ ପର୍ବତରେ ମୋଶାଙ୍କ ଦ୍ୱାରା ଆପଣାର ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ମଧ୍ୟରେ ଏହି ସକଳ ବିଧି, ଶାସନ ଓ ବ୍ୟବସ୍ଥା ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, କୌଣସି ମନୁଷ୍ୟର ମାନତ ପୂର୍ଣ୍ଣ କରିବାକୁ ହେଲେ, ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଅନୁସାରେ ପ୍ରାଣୀସକଳ ସଦାପ୍ରଭୁଙ୍କର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ପୁରୁଷ ହେଲେ, କୋଡ଼ିଏ ବର୍ଷଠାରୁ ଷାଠିଏ ବର୍ଷ ବୟସ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ପଚାଶ ଶେକଲ ରୂପା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ପୁଣି ସ୍ତ୍ରୀ ହେଲେ, ତୁମ୍ଭ ନିରୂପିତ ମୂଲ୍ୟ ତିରିଶ ଶେକଲ ରୂପା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ଆଉ ପାଞ୍ଚ ବର୍ଷଠାରୁ କୋଡ଼ିଏ ବର୍ଷ ବୟସ ପର୍ଯ୍ୟନ୍ତ ହେଲେ, ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ପୁରୁଷ ନିମନ୍ତେ କୋଡ଼ିଏ ଶେକଲ ଓ ସ୍ତ୍ରୀ ନିମନ୍ତେ ଦଶ ଶେକଲ ରୂପା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ଆଉ ଏକ ମାସଠାରୁ ପାଞ୍ଚ ବର୍ଷ ବୟସ ହେଲେ, ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ପୁରୁଷ ନିମନ୍ତେ ପାଞ୍ଚ ଶେକଲ ରୂପା ହେବ ଓ ସ୍ତ୍ରୀ ନିମନ୍ତେ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ତିନି ଶେକଲ ରୂପା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ପୁଣି ଷାଠିଏ ବର୍ଷଠାରୁ ଅଧିକ ବର୍ଷ ବୟସ ହେଲେ, ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ପୁରୁଷ ନିମନ୍ତେ ପନ୍ଦର ଶେକଲ ଓ ସ୍ତ୍ରୀ ନିମନ୍ତେ ଦଶ ଶେକଲ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ମାତ୍ର ସେ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଅପେକ୍ଷା ଦରିଦ୍ର ହେଲେ, ଯାଜକ ସମ୍ମୁଖକୁ ଅଣାଯିବ, ତହୁଁ ଯାଜକ ତାହାର ମୂଲ୍ୟ ନିରୂପଣ କରିବ; ମାନତକାରୀର ଶକ୍ତି ଅନୁସାରେ ଯାଜକ ତାହାର ମୂଲ୍ୟ ନିରୂପଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","ଆଉ ଲୋକମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯେଉଁ ଉପହାର ଉତ୍ସର୍ଗ କରନ୍ତି, ତାହା ପଶୁ ହେଲେ, ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଦତ୍ତ ସେହି ସବୁ ପଶୁ ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ସେ ତାହା ଅନ୍ୟଥା କି ପରିବର୍ତ୍ତନ କରିବ ନାହିଁ; ମନ୍ଦ ପାଲଟେ ଭଲ, କି ଭଲ ପାଲଟେ ମନ୍ଦ ଦେବ ନାହିଁ; ଯଦି ସେ କୌଣସିମତେ ପଶୁର ପାଲଟେ ପଶୁ ଦେବ, ତେବେ ତାହା ଓ ତହିଁ ପାଇଁ ଯାହା ବଦଳ କରାଯାଏ, ଦୁହେଁ ପବିତ୍ର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ଆଉ ଯାହା ଦ୍ୱାରା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉପହାର ଉତ୍ସର୍ଗ କରାଯାଏ ନାହିଁ, ଏପରି କୌଣସି ଅଶୁଚି ପଶୁ ଯଦି ଦିଆଯାଏ, ତେବେ ସେ ସେହି ପଶୁକୁ ଯାଜକ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ପୁଣି ସେହି ପଶୁ ଭଲ କି ମନ୍ଦ ହେଉ, ଯାଜକ ତହିଁର ମୂଲ୍ୟ ନିରୂପଣ କରିବ; ତୁମ୍ଭର, ଅର୍ଥାତ୍‍, ଯାଜକର ନିରୂପଣ ଅନୁସାରେ ତହିଁର ମୂଲ୍ୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ମାତ୍ର, ଯଦି ସେ କୌଣସିମତେ ତାହା ମୁକ୍ତ କରିବାକୁ ଇଚ୍ଛା କରେ, ତେବେ ସେ ତୁମ୍ଭ ନିରୂପିତ ମୂଲ୍ୟର ପଞ୍ଚମାଂଶ ଅଧିକ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","ଆଉ, ଯଦି କୌଣସି ମନୁଷ୍ୟ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର କରିବା ପାଇଁ ଆପଣା ଗୃହ ପ୍ରତିଷ୍ଠା କରେ, ତେବେ ତାହା ଭଲ କି ମନ୍ଦ ହେଉ, ଯାଜକ ତହିଁର ମୂଲ୍ୟ ନିରୂପଣ କରିବ; ଯାଜକ ତହିଁର ଯେଉଁ ମୂଲ୍ୟ ନିରୂପଣ କରିବ, ତାହା ସ୍ଥିର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ଆଉ, ଯଦି ଗୃହ ପ୍ରତିଷ୍ଠାକାରୀ ଆପଣା ଗୃହ ମୁକ୍ତ କରିବାକୁ ଇଚ୍ଛା କରେ, ତେବେ ସେ ତୁମ୍ଭ ନିରୂପିତ ମୂଲ୍ୟର ପଞ୍ଚମାଂଶ ଅଧିକ ଦେବ, ତହିଁରେ ତାହା ତାହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ଆଉ, ଯଦି କୌଣସି ମନୁଷ୍ୟ ଆପଣା ଅଧିକୃତ କ୍ଷେତ୍ରର କୌଣସି ଅଂଶ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଶୁଚି କରେ, ତେବେ ତୁମ୍ଭର ମୂଲ୍ୟ ନିରୂପଣ ସେହି କ୍ଷେତ୍ରରେ ବୁଣିବା ନିମନ୍ତେ ଆବଶ୍ୟକୀୟ ପରିମାଣର ବିହନ ଅନୁସାରେ ହେବ; ଏକ ହୋମର ପରିମିତ ଯବ ବିହନର ମୂଲ୍ୟ ପଚାଶ ଶେକଲ ରୂପା ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ଯଦି ସେ ଯୋବେଲ ବର୍ଷଠାରୁ ଆପଣା କ୍ଷେତ୍ର ଶୁଚି କରେ, ତେବେ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଅନୁସାରେ ତାହା ସ୍ଥିର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ମାତ୍ର, ଯଦି ସେ ଯୋବେଲ ଉତ୍ତାରେ ଆପଣା କ୍ଷେତ୍ର ଶୁଚି କରେ, ତେବେ ଯାଜକ ଯୋବେଲ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ଅବଶିଷ୍ଟ ବର୍ଷର ସଂଖ୍ୟାନୁସାରେ ତାହା ସହିତ ମୂଲ୍ୟର ଗଣନା କରିବ, ପୁଣି ତଦନୁସାରେ ତୁମ୍ଭ ନିରୂପିତ ମୂଲ୍ୟରୁ ଊଣା କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ଆଉ ସେହି କ୍ଷେତ୍ର ଶୁଚିକାରୀ ଲୋକ ଯଦି କୌଣସିମତେ ତାହା ମୁକ୍ତ କରିବାକୁ ଇଚ୍ଛା କରେ, ତେବେ ସେ ତୁମ୍ଭ ନିରୂପିତ ରୂପାର ପଞ୍ଚମାଂଶ ଅଧିକ ଦେବ, ତହିଁରେ ତାହା ତାହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ମାତ୍ର ଯଦି ସେ ଆପଣା କ୍ଷେତ୍ର ମୁକ୍ତ ନ କରେ, କିଅବା ଯଦି ସେ ସେହି କ୍ଷେତ୍ର ଅନ୍ୟକୁ ବିକ୍ରୟ କରେ, ତେବେ ତାହା ଆଉ କେବେ ମୁକ୍ତ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ମାତ୍ର ସେହି କ୍ଷେତ୍ର ଯୋବେଲ ସମୟରେ ମୁକ୍ତ ହେଲେ, ତାହା ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଉତ୍ସର୍ଗିତ କ୍ଷେତ୍ର ତୁଲ୍ୟ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବ; ତହିଁରେ ସେହି କ୍ଷେତ୍ର ଯାଜକର ଅଧିକାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ଆଉ ଯେଉଁ କ୍ଷେତ୍ର ଆପଣାର ସମ୍ପତ୍ତି ନୁହେଁ, ତାହା କେହି ଯଦି କ୍ରୟ କରି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଶୁଚି କରେ; ");
INSERT INTO ory_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ତେବେ ଯାଜକ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଅନୁସାରେ ଯୋବେଲ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ତାହା ପାଇଁ ଗଣନା କରିବ; ପୁଣି ସେ ସେହି ଦିନ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଦେବ, ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ବସ୍ତୁ ତୁଲ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ଯାହାଠାରୁ ସେହି କ୍ଷେତ୍ର କ୍ରୟ କରାଗଲା, ଅର୍ଥାତ୍‍, ଭୂମି ଯାହାର ସମ୍ପତ୍ତି ଅଟେ, ତାହା ଯୋବେଲ ବର୍ଷରେ ତାହାକୁ ଫେରାଇ ଦିଆଯିବ। ");
INSERT INTO ory_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ପୁଣି ତୁମ୍ଭର ନିରୂପିତ ସମସ୍ତ ମୂଲ୍ୟ ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ହେବ; କୋଡ଼ିଏ ଗେରାରେ ଏକ ଶେକଲ ହୁଏ। ");
INSERT INTO ory_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","ପଶୁମାନଙ୍କ ମଧ୍ୟରେ କେବଳ ପ୍ରଥମଜାତ ପଶୁ, ଯାହା ସଦାପ୍ରଭୁଙ୍କର ପ୍ରଥମଜାତ ହୁଏ, ତାହା କୌଣସି ମନୁଷ୍ୟ ଶୁଚି କରିବ ନାହିଁ; ଗୋରୁ କି ମେଷ ହେଉ, ତାହା ସଦାପ୍ରଭୁଙ୍କର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ପୁଣି ଯଦି ତାହା ଅଶୁଚି ପଶୁ ହୁଏ, ତେବେ ସେ ତୁମ୍ଭ ନିରୂପିତ ମୂଲ୍ୟ ଅନୁସାରେ ତାହା ମୁକ୍ତ କରିବ, ପୁଣି ସେହି ମୂଲ୍ୟର ପଞ୍ଚମାଂଶ ଅଧିକ ଦେବ; ମୁକ୍ତ କରା ନ ଗଲେ ତୁମ୍ଭର ନିରୂପିତ ମୂଲ୍ୟ ଅନୁସାରେ ତାହା ବିକ୍ରୀତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","ଆଉ କୌଣସି ମନୁଷ୍ୟ ଆପଣା ସର୍ବସ୍ୱରୁ, ଅର୍ଥାତ୍‍, ମନୁଷ୍ୟ କି ପଶୁ କି ଅଧିକୃତ କ୍ଷେତ୍ରରୁ ଯାହା କିଛି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରେ, ଏପରି କୌଣସି ଉତ୍ସର୍ଗିତ ବସ୍ତୁ ବିକ୍ରୀତ ବା ମୁକ୍ତ ହେବ ନାହିଁ; ପ୍ରତ୍ୟେକ ଉତ୍ସର୍ଗିତ ବସ୍ତୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ମନୁଷ୍ୟମାନଙ୍କ ମଧ୍ୟରେ ଯେ ଦଣ୍ଡିତ ହେବା ନିମନ୍ତେ ଉତ୍ସର୍ଗିତ ହେବ, ଏପରି ଉତ୍ସର୍ଗିତ କେହି ମୁକ୍ତ କରାଯିବ ନାହିଁ; ସେ ନିତାନ୍ତ ହତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","ପୁଣି ଭୂମିର ଶସ୍ୟ କି ବୃକ୍ଷର ଫଳ ହେଉ, ଭୂମିରୁ ଉତ୍ପନ୍ନ ସମସ୍ତ ଦ୍ରବ୍ୟର ଦଶମାଂଶ ସଦାପ୍ରଭୁଙ୍କର ହେବ, ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ଆଉ, ଯଦି କେହି ଆପଣା ଦଶମାଂଶରୁ କିଛି ମୁକ୍ତ କରିବାକୁ ଇଚ୍ଛା କରେ, ତେବେ ସେ ତହିଁର ମୂଲ୍ୟର ପଞ୍ଚମାଂଶ ଅଧିକ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ପୁଣି ଗୋମେଷାଦି ପଲର ଦଶମାଂଶ, ଅର୍ଥାତ୍‍, ପାଞ୍ଚଣ ତଳ ଦେଇ ଗମନକାରୀ ସବୁ ପଶୁ ମଧ୍ୟରେ ପ୍ରତ୍ୟେକ ଦଶମ ପଶୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ତାହା ଭଲ କି ମନ୍ଦ, ଏଥିର ସେ ଅନୁସନ୍ଧାନ କରିବ ନାହିଁ, କିଅବା ତହିଁର ବଦଳ କରିବ ନାହିଁ; ପୁଣି ଯଦି ସେ କୌଣସିମତେ ବଦଳ କରେ, ତେବେ ତାହା ଓ ତାହା ପାଇଁ ଯାହା ବଦଳ କରାଯାଏ, ଦୁହେଁ ପବିତ୍ର ହେବେ, ତାହା ମୁକ୍ତ କରାଯିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ସଦାପ୍ରଭୁ ସୀନୟ ପର୍ବତରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ନିମନ୍ତେ ମୋଶାଙ୍କୁ ଯେଉଁ ଆଜ୍ଞା ଦେଇଥିଲେ, ସେହି ସକଳ ଆଜ୍ଞା ଏହି।");
INSERT INTO ory_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ଏଥିଉତ୍ତାରେ ଲୋକମାନେ ମିସର ଦେଶରୁ ବାହାର ହେବାର ଦ୍ୱିତୀୟ ବର୍ଷର ଦ୍ୱିତୀୟ ମାସର ପ୍ରଥମ ଦିନରେ ସଦାପ୍ରଭୁ ସୀନୟ ପ୍ରାନ୍ତରରେ ସମାଗମ-ତମ୍ବୁ ମଧ୍ୟରେ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀର ବଂଶ ଅନୁସାରେ ଓ ପିତୃଗୃହ ଅନୁସାରେ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ପ୍ରତ୍ୟେକ ପୁରୁଷର ମସ୍ତକ ଗଣନା କର। ");
INSERT INTO ory_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ଯେତେ ପୁରୁଷ ଇସ୍ରାଏଲ ମଧ୍ୟରୁ ଯୁଦ୍ଧକୁ ଯିବାର ଯୋଗ୍ୟ, ସେମାନଙ୍କ ସୈନ୍ୟାନୁସାରେ ତୁମ୍ଭେ ଓ ହାରୋଣ ସେମାନଙ୍କୁ ଗଣନା କର। ");
INSERT INTO ory_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ପୁଣି, ପ୍ରତ୍ୟେକ ବଂଶରୁ ଏକ ଏକ ଜଣ, ଅର୍ଥାତ୍‍, ଆପଣା ଆପଣା ପିତୃବଂଶର ପ୍ରଧାନ ଲୋକ ତୁମ୍ଭମାନଙ୍କର ସହକାରୀ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ଆଉ ଯେଉଁମାନେ ତୁମ୍ଭମାନଙ୍କର ସହକାରୀ ହେବେ, ସେମାନଙ୍କର ନାମ ଏହି: ଯଥା, ରୁବେନ୍‍ ବଂଶର ଶଦେୟରର ପୁତ୍ର ଇଲୀଷୂର। ");
INSERT INTO ory_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ଶିମୀୟୋନ ବଂଶର ସୂରୀଶଦ୍ଦୟର ପୁତ୍ର ଶଲୁମୀୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ଯିହୁଦା ବଂଶର; ଅମ୍ମୀନାଦବର ପୁତ୍ର ନହଶୋନ ");
INSERT INTO ory_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ଇଷାଖର ବଂଶର; ସୂୟାରର ପୁତ୍ର ନଥନେଲ। ");
INSERT INTO ory_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ସବୂଲୂନ ବଂଶର ହେଲୋନର ପୁତ୍ର ଇଲୀୟାବ୍‍ ");
INSERT INTO ory_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ଯୋଷେଫର ପୁତ୍ରଗଣ ମଧ୍ୟରୁ ଇଫ୍ରୟିମ ବଂଶର; ଅମ୍ମୀହୂଦର ପୁତ୍ର ଇଲୀଶାମା; ମନଃଶି ବଂଶର; ପଦାହସୂରର ପୁତ୍ର ଗମଲୀୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ବିନ୍ୟାମୀନ୍ ବଂଶର; ଗିଦୀୟୋନର ପୁତ୍ର ଅବୀଦାନ୍‍। ");
INSERT INTO ory_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ଦାନ୍ ବଂଶର; ଅମ୍ମୀଶଦ୍ଦୟର ପୁତ୍ର ଅହୀୟେଷର। ");
INSERT INTO ory_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ଆଶେର ବଂଶର; ଅକ୍ରଣର ପୁତ୍ର ପଗୀୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ଗାଦ୍‍ ବଂଶର; ଦ୍ୟୂୟେଲର ପୁତ୍ର ଇଲୀୟାସଫ୍‍। ");
INSERT INTO ory_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ନପ୍ତାଲି ବଂଶର; ଐନନର ପୁତ୍ର ଅହୀର।” ");
INSERT INTO ory_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ଏମାନେ ମଣ୍ଡଳୀର ଆହୂତ ଲୋକ, ଆପଣା ଆପଣା ପିତୃବଂଶର ଅଧିପତି, ଆଉ ଇସ୍ରାଏଲର ସହସ୍ରପତି ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ତେବେ ମୋଶା ଓ ହାରୋଣ ଏହିସବୁ ନାମବିଶିଷ୍ଟ ଲୋକମାନଙ୍କୁ ଗ୍ରହଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ପୁଣି, ଦ୍ୱିତୀୟ ମାସର ପ୍ରଥମ ଦିନରେ ସମଗ୍ର ମଣ୍ଡଳୀକୁ ଏକତ୍ର କରି ମସ୍ତକ-ସଂଖ୍ୟାରେ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ଲୋକମାନଙ୍କ ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ସେମାନଙ୍କର ବଂଶାବଳୀ ଲେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ଏହିରୂପେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସୀନୟ ପ୍ରାନ୍ତରରେ ସେମାନଙ୍କୁ ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ଇସ୍ରାଏଲଙ୍କର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର ଯେ ରୁବେନ୍‍, ତାହାର ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ, ନାମସଂଖ୍ୟା ଓ ମସ୍ତକ ଗଣନାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ରୁବେନ୍‍ ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ଛୟାଳିଶ ହଜାର ପାଞ୍ଚ ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ଶିମୀୟୋନ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ଯେଉଁ ପୁରୁଷମାନେ ନାମସଂଖ୍ୟା ଓ ମସ୍ତକ ଗଣନାନୁସାରେ ଗଣାଗଲେ, ସେମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ଶିମୀୟୋନ ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ଊଣଷଠି ହଜାର ତିନି ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ଗାଦ୍‍-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ଗାଦ୍‍ ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ପଞ୍ଚଚାଳିଶ ହଜାର ଛଅ ଶହ ପଚାଶ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ଯିହୁଦା-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ଯିହୁଦା ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ଚଉସ୍ତରି ହଜାର ଛଅ ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ଇଷାଖର-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ଇଷାଖର ବଂଶର ଗଣିତ ଲୋକ ସଂଖ୍ୟା ଚଉବନ ହଜାର ଚାରି ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ସବୂଲୂନ-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ସବୂଲୂନ ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ସତାବନ ହଜାର ଚାରି ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ଯୋଷେଫ-ସନ୍ତାନଗଣର, ଯଥା, ଇଫ୍ରୟିମ-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କ ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ଇଫ୍ରୟିମ ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ଚାଳିଶ ହଜାର ପାଞ୍ଚ ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ମନଃଶି-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ମନଃଶି ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ବତ୍ରିଶ ହଜାର ଦୁଇ ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ବିନ୍ୟାମୀନ୍-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କ ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ବିନ୍ୟାମୀନ୍ ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ପଞ୍ଚତିରିଶ ହଜାର ଚାରି ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ଦାନ୍-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ଦାନ୍ ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ବାଷଠି ହଜାର ସାତ ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ଆଶେର-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କର ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ଆଶେର ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କର ସଂଖ୍ୟା ଏକଚାଳିଶ ହଜାର ପାଞ୍ଚ ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ନପ୍ତାଲି-ସନ୍ତାନଗଣର ବଂଶ, ପିତୃଗୃହ ଓ ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ପୁରୁଷମାନଙ୍କ ବଂଶାବଳୀ; ");
INSERT INTO ory_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ନପ୍ତାଲି ବଂଶର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ତେପନ ହଜାର ଚାରି ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ଏହି ଲୋକମାନେ ଗଣିତ ହେଲେ; ମୋଶା, ହାରୋଣ ଓ ଇସ୍ରାଏଲର ବାର ଜଣ ଅଧିପତି, ଅର୍ଥାତ୍‍, ଏକ ଏକ ପିତୃଗୃହ ନିମନ୍ତେ ଏକ ଏକ ଅଧିପତି ସେମାନଙ୍କୁ ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ଏହିରୂପେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଆପଣା ଆପଣା ପିତୃଗୃହାନୁସାରେ ଇସ୍ରାଏଲ ମଧ୍ୟରୁ ଯୁଦ୍ଧକୁ ଯିବା ଯୋଗ୍ୟ କୋଡ଼ିଏ ବର୍ଷରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ଲୋକମାନେ ଗଣିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ଏହିସବୁ ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ଛଅ ଲକ୍ଷ ତିନି ହଜାର ପାଞ୍ଚ ଶହ ପଚାଶ ଜଣ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ମାତ୍ର ଲେବୀୟମାନେ ଆପଣା ପିତୃବଂଶାନୁସାରେ ସେମାନଙ୍କ ମଧ୍ୟରେ ଗଣାଗଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","କାରଣ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଥିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ତୁମ୍ଭେ କେବଳ ଲେବୀୟ ବଂଶର ଗଣନା କରିବ ନାହିଁ, କିଅବା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ସେମାନଙ୍କର ସଂଖ୍ୟା ନେବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ମାତ୍ର ତୁମ୍ଭେ ସାକ୍ଷ୍ୟର ଆବାସ, ତହିଁର ସକଳ ଦ୍ରବ୍ୟ ଓ ତତ୍‍ସମ୍ବନ୍ଧୀୟ ସମସ୍ତ ବିଷୟ ଉପରେ ଲେବୀୟମାନଙ୍କୁ ନିଯୁକ୍ତ କରିବ; ସେମାନେ ଆବାସ ଓ ତହିଁର ସମସ୍ତ ଦ୍ରବ୍ୟ ବହିବେ ଓ ସେମାନେ ତହିଁର ସେବା କରିବେ ଓ ଆବାସର ଚାରିଆଡ଼େ ଛାଉଣି କରି ରହିବେ। ");
INSERT INTO ory_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ପୁଣି, ଆବାସ ଆଗକୁ ଯିବା ସମୟରେ ଲେବୀୟମାନେ ତାହା ଭାଙ୍ଗିବେ ଓ ଆବାସ ସ୍ଥାପନ କରିବା ସମୟରେ ଲେବୀୟମାନେ ତାହା ସ୍ଥାପନ କରିବେ ଓ ଅନ୍ୟ ବଂଶୀୟ ଲୋକ ତାହା ନିକଟକୁ ଗଲେ, ତାହାର ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ଆପଣା ଆପଣା ଛାଉଣିରେ ଆପଣା ଆପଣା ଧ୍ୱଜା ନିକଟରେ ତମ୍ବୁ ସ୍ଥାପନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ମାତ୍ର ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ମଣ୍ଡଳୀ ପ୍ରତି ଯେପରି କ୍ରୋଧ ନ ଘଟେ, ଏଥିପାଇଁ ଲେବୀୟମାନେ ସାକ୍ଷ୍ୟ-ଆବାସର ଚାରିଆଡ଼େ ଛାଉଣି ସ୍ଥାପନ କରିବେ; ପୁଣି, ଲେବୀୟମାନେ ସାକ୍ଷ୍ୟ-ଆବାସ ରକ୍ଷା କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଏହିରୂପେ କଲେ; ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେଉଁ ସମସ୍ତ ଆଜ୍ଞା ଦେଇଥିଲେ, ତଦନୁସାରେ ସେମାନେ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ପିତୃଗୃହର ନିଶାଣ ସ୍ୱରୂପ ଧ୍ୱଜା ନିକଟରେ ଛାଉଣି ସ୍ଥାପନ କରିବେ; ସେମାନେ ସମାଗମ-ତମ୍ବୁ ଆଗରେ ଚାରିଆଡ଼େ ଛାଉଣି ସ୍ଥାପନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ଯେଉଁମାନେ ପୂର୍ବ ଦିଗରେ ସୂର୍ଯ୍ୟୋଦୟ ଆଡ଼େ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ଛାଉଣି ସ୍ଥାପନ କରିବେ, ସେମାନେ ଯିହୁଦା-ଧ୍ୱଜାର ପଶ୍ଚାଦ୍‍ଗାମୀ ଲୋକ; ପୁଣି, ଅମ୍ମୀନାଦବର ପୁତ୍ର ନହଶୋନ ଯିହୁଦା-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ପୁଣି, ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ଚଉସ୍ତରି ହଜାର ଛଅ ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ତାହା ପାଖରେ ଇଷାଖର ବଂଶ ଛାଉଣି ସ୍ଥାପନ କରିବେ, ସୂୟାରର ପୁତ୍ର ନଥନେଲ ଇଷାଖର-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ଚଉବନ ହଜାର ଚାରି ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ତହୁଁ ସବୂଲୂନ ବଂଶ; ହେଲୋନର ପୁତ୍ର ଇଲୀୟାବ୍‍ ସବୂଲୂନ-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ପୁଣି, ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ସତାବନ ହଜାର ଚାରି ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ଯିହୁଦା-ଛାଉଣିର ଗଣିତ ଲୋକମାନେ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ଏକ ଲକ୍ଷ ଛୟାଅଶୀ ହଜାର ଚାରି ଶହ। ସେମାନେ ପ୍ରଥମେ ଅଗ୍ରସର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ଦକ୍ଷିଣ ଦିଗରେ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ରୁବେନ୍‍-ଛାଉଣିର ଧ୍ୱଜା ରହିବ; ଶଦେୟରର ପୁତ୍ର ଇଲୀଷୂର ରୁବେନ୍‍-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ପୁଣି, ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ଛୟାଳିଶ ହଜାର ପାଞ୍ଚ ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ତାହା ପାଖରେ ଶିମୀୟୋନ ବଂଶ ଛାଉଣି ସ୍ଥାପନ କରିବେ ଓ ସୂରୀଶଦ୍ଦୟର ପୁତ୍ର ଶଲୁମୀୟେଲ ଶିମୀୟୋନ-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ଊଣଷଠି ହଜାର ତିନି ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ତହୁଁ ଗାଦ୍‍ର ବଂଶ; ରୁୟେଲର ପୁତ୍ର ଇଲୀୟାସଫ୍‍ ଗାଦ୍‍-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ପୁଣି, ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ପଞ୍ଚଚାଳିଶ ହଜାର ଛଅ ଶହ ପଚାଶ। ");
INSERT INTO ory_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ରୁବେନ୍‍-ଛାଉଣିର ଗଣିତ ଲୋକମାନେ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ଏକ ଲକ୍ଷ ଏକାବନ ହଜାର ଚାରି ଶହ ପଚାଶ। ସେମାନେ ଦ୍ୱିତୀୟରେ ଅଗ୍ରସର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ଏଉତ୍ତାରେ ସମାଗମ-ତମ୍ବୁ ଲେବୀୟମାନଙ୍କ ଛାଉଣି ସହିତ ଛାଉଣିମାନଙ୍କ ମଧ୍ୟବର୍ତ୍ତୀ ହୋଇ ଅଗ୍ରସର ହେବ; ଯେପରି ସେମାନେ ଛାଉଣି ସ୍ଥାପନ କରିବେ, ସେପରି ପ୍ରତ୍ୟେକେ ସ୍ୱ ସ୍ୱ ସ୍ଥାନରେ ଧ୍ୱଜାର ନିକଟବର୍ତ୍ତୀ ହୋଇ ଅଗ୍ରସର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ପଶ୍ଚିମ ଦିଗରେ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ଇଫ୍ରୟିମ-ଛାଉଣିର ଧ୍ୱଜା ରହିବ; ପୁଣି, ଅମ୍ମୀହୂଦର ପୁତ୍ର ଇଲୀଶାମା ଇଫ୍ରୟିମ-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ଆଉ ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ଚାଳିଶ ହଜାର ପାଞ୍ଚ ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ତାହା ପାଖରେ ମନଃଶି ବଂଶ ରହିବେ, ପୁଣି, ପଦାହସୂରର ପୁତ୍ର ଗମଲୀୟେଲ ମନଃଶି-ସନ୍ତାନମାନଙ୍କର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ବତିଶ ହଜାର ଦୁଇ ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ତହୁଁ ବିନ୍ୟାମୀନ୍ ବଂଶ; ପୁଣି, ଗିଦିୟୋନିର ପୁତ୍ର ଅବୀଦାନ୍‍ ବିନ୍ୟାମୀନ୍-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ପଞ୍ଚତିରିଶ ହଜାର ଚାରି ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ଇଫ୍ରୟିମ-ଛାଉଣିର ଗଣିତ ଲୋକମାନେ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ଏକ ଲକ୍ଷ ଆଠ ହଜାର ଏକ ଶହ। ସେମାନେ ତୃତୀୟରେ ଅଗ୍ରସର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ଉତ୍ତର ଦିଗରେ ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ଦାନ୍-ଛାଉଣିର ଧ୍ୱଜା ରହିବ; ପୁଣି, ଅମ୍ମୀଶଦ୍ଦୟର ପୁତ୍ର ଅହୀୟେଷର ଦାନ୍-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ବାଷଠି ହଜାର ସାତ ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ତାହା ପାଖରେ ଆଶେର ବଂଶର ଛାଉଣି ରହିବ; ଅକ୍ରଣର ପୁତ୍ର ପଗୀୟେଲ ଆଶେର-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ଏକଚାଳିଶ ହଜାର ପାଞ୍ଚ ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ତହୁଁ ନପ୍ତାଲି ବଂଶ; ଐନନର ପୁତ୍ର ଅହୀର ନପ୍ତାଲି-ସନ୍ତାନଗଣର ଅଧିପତି ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ତାହାର ଗଣିତ ସୈନ୍ୟ ସଂଖ୍ୟା ତେପନ ହଜାର ଚାରି ଶହ। ");
INSERT INTO ory_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ଦାନ୍-ଛାଉଣିର ଗଣିତ ଲୋକମାନଙ୍କ ସଂଖ୍ୟା ଏକ ଲକ୍ଷ ସତାବନ ହଜାର ଛଅ ଶହ। ସେମାନେ ଆପଣାମାନଙ୍କ ଧ୍ୱଜା ନେଇ ସମସ୍ତଙ୍କ ପଛେ ଅଗ୍ରସର ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ଏମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଆପଣା ଆପଣା ପିତୃଗୃହାନୁସାରେ ଗଣିତ ହେଲେ; ଆପଣା ଆପଣା ସୈନ୍ୟାନୁସାରେ ସମସ୍ତ ଛାଉଣିର ଗଣିତ ଲୋକ ସଂଖ୍ୟା ଛଅ ଲକ୍ଷ ତିନି ହଜାର ପାଞ୍ଚ ଶହ ପଚାଶ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ମାତ୍ର ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଲେବୀୟମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଗଣିତ ହେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ଏହିରୂପେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ କଲେ; ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେପରି ଆଜ୍ଞାସବୁ ଦେଇଥିଲେ, ସେପରି ସେମାନେ ଆପଣା ଆପଣା ବଂଶ ନିକଟରେ ଆପଣା ଆପଣା ପିତୃଗୃହାନୁସାରେ ଆପଣା ଆପଣା ଧ୍ୱଜା ନିକଟରେ ଛାଉଣି ସ୍ଥାପନ କଲେ ଓ ସେହିପରି ସେମାନେ ଅଗ୍ରସର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ଯେଉଁ ଦିନ ସଦାପ୍ରଭୁ ସୀନୟ ପର୍ବତରେ ମୋଶାଙ୍କ ସଙ୍ଗେ କଥା କହିଲେ, ସେହି ଦିନ ହାରୋଣ ଓ ମୋଶାଙ୍କର ବଂଶାବଳୀ ଏହି। ");
INSERT INTO ory_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ହାରୋଣଙ୍କର ପୁତ୍ରଗଣର ନାମ ଏହି; ପ୍ରଥମଜାତ ନାଦବ୍‍, ତହୁଁ ଅବୀହୂ ଓ ଇଲୀୟାସର ଓ ଈଥାମର। ");
INSERT INTO ory_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ହାରୋଣଙ୍କର ଯେଉଁ ପୁତ୍ରମାନେ ଯାଜକ ରୂପେ ଅଭିଷିକ୍ତ ହୋଇଥିଲେ ଓ ଯେଉଁମାନଙ୍କୁ ସେ ଯାଜକର କର୍ମ କରିବା ପାଇଁ ନିଯୁକ୍ତ କରିଥିଲେ, ସେମାନଙ୍କର ନାମ ଏହି। ");
INSERT INTO ory_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ମାତ୍ର ନାଦବ୍‍ ଓ ଅବୀହୂ ସୀନୟ ପ୍ରାନ୍ତରରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଇତର ଅଗ୍ନି ଉତ୍ସର୍ଗ କରି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପ୍ରାଣତ୍ୟାଗ କରିଥିଲେ, ସେମାନଙ୍କର ସନ୍ତାନ ନ ଥିଲା; ଏଥିସକାଶୁ ଇଲୀୟାସର ଓ ଈଥାମର ଆପଣା ପିତା ହାରୋଣଙ୍କ ସାକ୍ଷାତରେ ଯାଜକ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ତୁମ୍ଭେ ଲେବୀୟ ବଂଶକୁ ଆଣି ହାରୋଣ ଯାଜକଙ୍କ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରାଅ, ସେମାନେ ତାହାର ସେବା କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ଆଉ ସେମାନେ ଆବାସର ସେବାକର୍ମ କରିବା ନିମନ୍ତେ ସମାଗମ-ତମ୍ବୁ ସମ୍ମୁଖରେ ତାହାର ଓ ସମସ୍ତ ମଣ୍ଡଳୀର ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ପୁଣି, ସେମାନେ ଆବାସର ସେବାକର୍ମ କରିବା ନିମନ୍ତେ ସମାଗମ-ତମ୍ବୁର ସମସ୍ତ ଦ୍ରବ୍ୟ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ଆଉ ତୁମ୍ଭେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣର ହସ୍ତରେ ଲେବୀୟମାନଙ୍କୁ ସମର୍ପଣ କରିବ; ସେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପକ୍ଷରେ ତାହା ପ୍ରତି ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଦତ୍ତ ଲୋକ, ");
INSERT INTO ory_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ପୁଣି, ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ନିଯୁକ୍ତ କରିବ, ତହିଁରେ ସେମାନେ ଆପଣାମାନଙ୍କ ଯାଜକତ୍ୱ ପଦ ରକ୍ଷା କରିବେ ଓ ଅନ୍ୟ ବଂଶୀୟ ଯେକେହି ନିକଟବର୍ତ୍ତୀ ହେବ, ତାହାର ପ୍ରାଣଦଣ୍ଡ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ଆମ୍ଭେ, ଦେଖ, ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ସମସ୍ତ ପ୍ରଥମଜାତ ଗର୍ଭଫଳ ପରିବର୍ତ୍ତରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ଲେବୀୟମାନଙ୍କୁ ଗ୍ରହଣ କଲୁ, ଏଣୁ ଲେବୀୟମାନେ ଆମ୍ଭର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","କାରଣ ପ୍ରଥମଜାତ ସମସ୍ତ ଆମ୍ଭର; ଯେଉଁ ଦିନ ଆମ୍ଭେ ମିସର ଦେଶରେ ପ୍ରଥମଜାତ ସକଳକୁ ଆଘାତ କଲୁ, ସେହି ଦିନ ଆମ୍ଭେ ଇସ୍ରାଏଲ ମଧ୍ୟରେ ମନୁଷ୍ୟ ଓ ପଶୁ ସମସ୍ତ ପ୍ରଥମଜାତକୁ ଆପଣା ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର କଲୁ; ସେମାନେ ଆମ୍ଭର; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ସୀନୟ ପ୍ରାନ୍ତରରେ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ଆପଣା ଆପଣା ପିତୃଗୃହ ଓ ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଲେବୀୟ ସନ୍ତାନଗଣକୁ ଗଣନା କର; ତୁମ୍ଭେ ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ସମସ୍ତ ପୁରୁଷଙ୍କୁ ଗଣନା କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ତହିଁରେ ମୋଶା ଆଜ୍ଞାନୁସାରେ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ସେମାନଙ୍କୁ ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ଆପଣା ଆପଣା ନାମାନୁସାରେ ଏମାନେ ଲେବୀର ପୁତ୍ରଗଣ; ଯଥା, ଗେର୍ଶୋନ‍, କହାତ ଓ ମରାରି। ");
INSERT INTO ory_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ପୁଣି, ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଗେର୍ଶୋନର ସନ୍ତାନମାନଙ୍କ ନାମ ଲିବ୍‍ନି ଓ ଶିମୀୟି। ");
INSERT INTO ory_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ପୁଣି, ଆପଣା ଆପଣା ବଂଶାନୁସାରେ କହାତର ସନ୍ତାନମାନଙ୍କ ନାମ ଅମ୍ରାମ୍‍, ଯିଷ୍‍ହର, ହିବ୍ରୋଣ ଓ ଉଷୀୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ପୁଣି, ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ମରାରିର ସନ୍ତାନମାନଙ୍କ ନାମ ମହଲି ଓ ମୂଶି; ଏମାନେ ଆପଣା ଆପଣା ପିତୃଗୃହାନୁସାରେ ଲେବୀୟମାନଙ୍କ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ଗେର୍ଶୋନଠାରୁ ଲିବ୍‍ନୀୟ ବଂଶ ଓ ଶିମୀୟିର ବଂଶ ଉତ୍ପନ୍ନ ହେଲେ; ଏମାନେ ଗେର୍ଶୋନୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ଏମାନଙ୍କ ମଧ୍ୟରେ ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ଯେଉଁ ସମସ୍ତ ପୁରୁଷ ଗଣିତ ହେଲେ, ସେମାନଙ୍କର ଗଣିତ ଲୋକ ସଂଖ୍ୟା ସାତ ହଜାର ପାଞ୍ଚ ଶହ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ଗେର୍ଶୋନୀୟ ବଂଶ ପଶ୍ଚିମ ଦିଗରେ ଆବାସର ପଶ୍ଚାଦ୍‍ ଭାଗରେ ଛାଉଣି ସ୍ଥାପନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ପୁଣି, ଲାୟେଲର ପୁତ୍ର ଇଲୀୟାସଫ୍‍ ଗେର୍ଶୋନୀୟମାନଙ୍କ ପିତୃଗୃହର ଅଧିପତି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ପୁଣି, ସମାଗମ-ତମ୍ବୁର ଏହି ସମସ୍ତ ଦ୍ରବ୍ୟ ଗେର୍ଶୋନୀୟ ସନ୍ତାନମାନଙ୍କର ରକ୍ଷଣୀୟ ହେବ, ଯଥା, ଆବାସ ଓ ତମ୍ବୁ, ତହିଁର ଛାତ ଓ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର, ");
INSERT INTO ory_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ପ୍ରାଙ୍ଗଣର ପରଦାସକଳ, ଆବାସ ଓ ବେଦିର ଚତୁର୍ଦ୍ଦିଗସ୍ଥିତ ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର ଓ ତହିଁର ସେବାକାର୍ଯ୍ୟ ନିମିତ୍ତ ସମସ୍ତ ରଜ୍ଜୁ। ");
INSERT INTO ory_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ଆଉ କହାତଠାରୁ ଅମ୍ରାମୀୟ ବଂଶ, ଯିଷ୍‍ହରୀୟ ବଂଶ, ହିବ୍ରୋଣୀୟ ବଂଶ ଓ ଉଷୀୟେଲୀୟ ବଂଶ ଉତ୍ପନ୍ନ ହେଲେ; ଏମାନେ କହାତୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ପୁରୁଷମାନଙ୍କ ଗଣନାନୁସାରେ ଆଠ ହଜାର ଛଅ ଶହ ଲୋକ ପବିତ୍ର ସ୍ଥାନର ରକ୍ଷକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","କହାତୀୟ ସନ୍ତାନମାନଙ୍କ ବଂଶ ଦକ୍ଷିଣ ଦିଗରେ ଆବାସ ନିକଟରେ ଛାଉଣି ସ୍ଥାପନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ଆଉ ଉଷୀୟେଲର ପୁତ୍ର ଇଲୀଶାଫନ୍‍ କହାତୀୟ ବଂଶର ଅଧିପତି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ପୁଣି, ସିନ୍ଦୁକ, ମେଜ, ଦୀପବୃକ୍ଷ, ଯଜ୍ଞବେଦି, ପବିତ୍ର ସ୍ଥାନର ସେବା ସମ୍ବନ୍ଧୀୟ ସକଳ ପାତ୍ର, ପରଦା ଓ ତତ୍‍ସମ୍ବନ୍ଧୀୟ ସମସ୍ତ ସେବାକାର୍ଯ୍ୟ ସେମାନଙ୍କର ରକ୍ଷଣୀୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ପୁଣି, ହାରୋଣ ଯାଜକଙ୍କର ପୁତ୍ର ଇଲୀୟାସର ଲେବୀୟ ଅଧିପତିମାନଙ୍କର ଅଧିପତି ହେବ ଓ ପବିତ୍ର ସ୍ଥାନର ରକ୍ଷକମାନଙ୍କ ଉପରେ ତତ୍ତ୍ୱାବଧାନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ଆଉ ମରାରିଠାରୁ ମହଲୀୟ ବଂଶ ଓ ମୂଶୀୟ ବଂଶ ଉତ୍ପନ୍ନ ହେଲେ; ଏମାନେ ମରାରୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ପୁଣି, ଏମାନଙ୍କ ମଧ୍ୟରେ ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ପୁରୁଷମାନଙ୍କ ଗଣନାନୁସାରେ ଛଅ ହଜାର ଦୁଇ ଶହ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ଆଉ ଅବୀହୟିଲର ପୁତ୍ର ସୂରୀୟେଲ ମରାରି ବଂଶର ପିତୃଗୃହର ଅଧିପତି ହେଲା; ସେମାନେ ଉତ୍ତର ଦିଗରେ ଆବାସ ନିକଟରେ ଛାଉଣି ସ୍ଥାପନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ଆଉ ଆବାସର ପଟା, ଅର୍ଗଳ, ସ୍ତମ୍ଭ, ଚୁଙ୍ଗୀ, ତହିଁର ସମସ୍ତ ଦ୍ରବ୍ୟ ଓ ତତ୍‍ସମ୍ବନ୍ଧୀୟ ସେବାକାର୍ଯ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ପ୍ରାଙ୍ଗଣର ଚତୁର୍ଦ୍ଦିଗସ୍ଥିତ ସ୍ତମ୍ଭ, ତହିଁର ସକଳ ଚୁଙ୍ଗୀ, ମେଖ ଓ ରଜ୍ଜୁ ମରାରି-ସନ୍ତାନଗଣର ନିରୂପିତ ରକ୍ଷଣୀୟ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ପୁଣି, ଯେଉଁମାନେ ଆବାସର ପୂର୍ବ ଦିଗରେ ସମାଗମ-ତମ୍ବୁ ସମ୍ମୁଖରେ ସୂର୍ଯ୍ୟୋଦୟ ଆଡ଼େ ଛାଉଣି ସ୍ଥାପନ କରିବେ, ସେମାନେ ମୋଶା, ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ; ଏମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ରକ୍ଷଣୀୟ ବୋଲି ପବିତ୍ର ସ୍ଥାନର ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବେ; ଆଉ ଅନ୍ୟ ବଂଶୀୟ କୌଣସି ଲୋକ ତହିଁର ନିକଟବର୍ତ୍ତୀ ହେଲେ ହତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ଲେବୀୟମାନଙ୍କ ମଧ୍ୟରୁ ଯେଉଁମାନେ ଗଣିତ ହେଲେ, ଯେଉଁମାନଙ୍କୁ ମୋଶା ଓ ହାରୋଣ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞା ପ୍ରମାଣେ ସେମାନଙ୍କ ବଂଶାନୁସାରେ ଗଣନା କଲେ, ସେମାନଙ୍କର ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ସମସ୍ତ ପୁରୁଷ ସଂଖ୍ୟାରେ ବାଇଶ ହଜାର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ସମସ୍ତ ପ୍ରଥମଜାତ ପୁରୁଷଙ୍କୁ ଗଣନା କର ଓ ସେମାନଙ୍କ ନାମସଂଖ୍ୟା କର। ");
INSERT INTO ory_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ଆମ୍ଭେ ସଦାପ୍ରଭୁ; ଆମ୍ଭ ନିମନ୍ତେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ପ୍ରଥମଜାତ ଲୋକ ବଦଳେ ଲେବୀୟମାନଙ୍କୁ ଗ୍ରହଣ କରିବ; ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ପ୍ରଥମଜାତ ପଶୁ ବଦଳେ ଲେବୀୟମାନଙ୍କର ପଶୁ ଗ୍ରହଣ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ସମସ୍ତ ପ୍ରଥମଜାତ ଲୋକର ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ପୁଣି, ସେମାନଙ୍କର ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ସମସ୍ତ ପ୍ରଥମଜାତ ପୁରୁଷର ନାମ-ସଂଖ୍ୟାନୁସାରେ ଯେଉଁମାନେ ଗଣିତ ହେଲେ, ସେମାନଙ୍କ ସଂଖ୍ୟା ବାଇଶ ହଜାର ଦୁଇ ଶହ ତେସ୍ତରି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ପ୍ରଥମଜାତ ଲୋକ ବଦଳେ ଲେବୀୟମାନଙ୍କୁ ଓ ସେମାନଙ୍କ ପଶୁ ବଦଳେ ଲେବୀୟମାନଙ୍କର ପଶୁମାନଙ୍କୁ ଗ୍ରହଣ କର; ଆଉ ଲେବୀୟମାନେ ଆମ୍ଭର ହେବେ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଅଟୁ। ");
INSERT INTO ory_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ପ୍ରଥମଜାତ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଲେବୀୟମାନଙ୍କ ସଂଖ୍ୟାରୁ ଅଧିକ ଦୁଇ ଶହ ତେସ୍ତରି ଲୋକର ମୁକ୍ତି ନିମନ୍ତେ, ");
INSERT INTO ory_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ତୁମ୍ଭେ ମୁଣ୍ଡ ପିଛା ପାଞ୍ଚ ଶେକଲ ଲେଖାଏଁ ନେବ; ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ତୁମ୍ଭେ ତାହା ନେବ, (କୋଡ଼ିଏ ଗେରାରେ ଏକ ଶେକଲ)। ");
INSERT INTO ory_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ଆଉ ତୁମ୍ଭେ ସେହି ବଳକା ଲୋକମାନଙ୍କ ମୁକ୍ତିର ମୂଲ୍ୟ ନେଇ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରମାନଙ୍କୁ ଦେବ।” ");
INSERT INTO ory_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ତହୁଁ ମୋଶା ଲେବୀୟମାନଙ୍କ ଦ୍ୱାରା ମୁକ୍ତ ଲୋକଙ୍କ ବ୍ୟତୀତ ଅବଶିଷ୍ଟ ଲୋକମାନଙ୍କ ମୁକ୍ତି-ମୂଲ୍ୟ ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ପ୍ରଥମଜାତ ଲୋକମାନଙ୍କଠାରୁ ସେ ସେହି ମୂଲ୍ୟ ନେଲେ; ସେ ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ହଜାର ତିନି ଶହ ପଞ୍ଚଷଠି ଶେକଲ ନେଲେ; ");
INSERT INTO ory_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ପୁଣି, ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟ ପ୍ରମାଣେ ସେହି ମୁକ୍ତି-ମୂଲ୍ୟ ହାରୋଣଙ୍କୁ ଓ ତାଙ୍କର ପୁତ୍ରଗଣଙ୍କୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ତୁମ୍ଭେମାନେ ଲେବୀର ସନ୍ତାନଗଣ ମଧ୍ୟରୁ କହାତ-ସନ୍ତାନମାନଙ୍କର ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ, ");
INSERT INTO ory_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ତିରିଶ ବର୍ଷ ବୟସ୍କଠାରୁ ପଚାଶ ବର୍ଷ ବୟସ୍କ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁମାନେ ସମାଗମ-ତମ୍ବୁରେ କାର୍ଯ୍ୟ କରିବାକୁ ସେବକ ଶ୍ରେଣୀଭୁକ୍ତ ହୁଅନ୍ତି, ସେମାନଙ୍କୁ ଗଣନା କର। ");
INSERT INTO ory_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ସମାଗମ-ତମ୍ବୁରେ ମହାପବିତ୍ର ଦ୍ରବ୍ୟାଦିର (ରକ୍ଷା) କହାତ-ସନ୍ତାନଗଣର ସେବା ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ଛାଉଣି ଅଗ୍ରସର ହେବା ସମୟରେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ଭିତରେ ଯାଇ ଆଚ୍ଛାଦନର ବିଚ୍ଛେଦ ବସ୍ତ୍ର ନେଇ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ଢାଙ୍କିବେ ");
INSERT INTO ory_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ଓ ତହିଁ ଉପରେ ଶିଶୁକ ଚର୍ମର ଆଚ୍ଛାଦନ ଦେବେ ଓ ତହିଁ ଉପରେ ସମ୍ପୂର୍ଣ୍ଣ ନୀଳବର୍ଣ୍ଣ ଏକ ବସ୍ତ୍ର ଦେବେ, ତହିଁ ଉତ୍ତାରେ ତହିଁର ସାଙ୍ଗୀ ଲଗାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ଏଥିଉତ୍ତାରେ ସେମାନେ ଦର୍ଶନୀୟ ରୁଟିର ମେଜ ଉପରେ ନୀଳବର୍ଣ୍ଣ ଏକ ବସ୍ତ୍ର ବିଛାଇବେ, ତହିଁ ଉପରେ ଥାଳୀ, ଚାମଚ, ଗଡ଼ୁ ଓ ଢାଳିବା ପାତ୍ରସକଳ ରଖିବେ ଓ ତହିଁ ଉପରେ ନିତ୍ୟ ରୁଟି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ସେହି ସମସ୍ତର ଉପରେ ସେମାନେ ଏକ ସିନ୍ଦୂର ବର୍ଣ୍ଣ ବସ୍ତ୍ର ବିଛାଇବେ ଓ ଶିଶୁକ ଚର୍ମର ଆଚ୍ଛାଦନ ଦେଇ ତାହା ଢାଙ୍କିବେ, ତହୁଁ ତହିଁର ସାଙ୍ଗୀ ଲଗାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ଏଉତ୍ତାରେ ସେମାନେ ଏକ ନୀଳବର୍ଣ୍ଣ ବସ୍ତ୍ର ନେଇ ଆଲୁଅର ଦୀପବୃକ୍ଷ, ତହିଁର ପ୍ରଦୀପ, ଚିମୁଟା, ଅଙ୍ଗାରଧାନୀ ଓ ତହିଁର ସେବାର୍ଥକ ସମସ୍ତ ତୈଳପାତ୍ର ଆଚ୍ଛାଦନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ପୁଣି, ସେମାନେ ତାହା ଓ ତହିଁର ସମସ୍ତ ପାତ୍ର ଶିଶୁକ ଚର୍ମର ଏକ ଆଚ୍ଛାଦନରେ ରଖି ଦୋଳା ଉପରେ ଥୋଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ପୁଣି, ସେମାନେ ସ୍ୱର୍ଣ୍ଣମୟ ବେଦି ଉପରେ ନୀଳବର୍ଣ୍ଣ ଏକ ବସ୍ତ୍ର ବିଛାଇ ତାହା ଶିଶୁକ ଚର୍ମରେ ଢ଼ାଙ୍କିବେ ଓ ତହିଁରେ ସାଙ୍ଗୀ ଲଗାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ଆଉ ସେମାନେ ପବିତ୍ର ସ୍ଥାନର ସେବାର୍ଥକ ସମସ୍ତ ପାତ୍ର ନେଇ ନୀଳବର୍ଣ୍ଣ ବସ୍ତ୍ର ମଧ୍ୟରେ ରଖିବେ ଓ ଶିଶୁକ ଚର୍ମର ଏକ ଆଚ୍ଛାଦନରେ ତାହା ଢାଙ୍କି ଦୋଳା ଉପରେ ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ପୁଣି, ସେମାନେ ବେଦିରୁ ଭସ୍ମ କାଢ଼ିନେଇ ତହିଁ ଉପରେ ବାଇଗଣିଆ ବର୍ଣ୍ଣ ବସ୍ତ୍ର ବିଛାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ଆଉ ତହିଁ ଉପରେ ସେମାନେ ଅଙ୍ଗାରଧାନୀ, ତ୍ରିଶୂଳ, କରଚୁଲି ଓ କୁଣ୍ଡ ପ୍ରଭୃତି ବେଦିର ସେବାର୍ଥକ ସମସ୍ତ ପାତ୍ର ରଖିବେ; ତହୁଁ ସେମାନେ ତହିଁ ଉପରେ ଶିଶୁକ ଚର୍ମର ଆଚ୍ଛାଦନ ଦେଇ ସାଙ୍ଗୀ ଲଗାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ଏହିରୂପେ ଛାଉଣି ଅଗ୍ରସର ହେବା ସମୟରେ ହାରୋଣ, ତାଙ୍କର ପୁତ୍ରଗଣ ପବିତ୍ର ସ୍ଥାନ ଓ ପବିତ୍ର ସ୍ଥାନର ସମସ୍ତ ଦ୍ରବ୍ୟ ଢାଙ୍କିବାର ଶେଷ କଲା ଉତ୍ତାରେ କହାତ-ସନ୍ତାନଗଣ ତାହା ବହିବା ପାଇଁ ଆସିବେ; ମାତ୍ର ସେମାନଙ୍କର ମୃତ୍ୟୁୁ ଯେପରି ନ ହୁଏ, ଏଥିପାଇଁ ସେମାନେ ପବିତ୍ର ସ୍ଥାନ ସ୍ପର୍ଶ କରିବେ ନାହିଁ। ଏହା ହିଁ ସମାଗମ-ତମ୍ବୁରେ କହାତ-ସନ୍ତାନଗଣର ଭାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ଆଉ ସମସ୍ତ ଆବାସର ଓ ତନ୍ମଧ୍ୟସ୍ଥିତ ସମସ୍ତ ଦ୍ରବ୍ୟର, ପବିତ୍ର ସ୍ଥାନର ଓ ତହିଁରେ ସ୍ଥିତ ସମସ୍ତ ଦ୍ରବ୍ୟର ତତ୍ତ୍ୱାବଧାନ, ଅର୍ଥାତ୍‍, ଦୀପାର୍ଥକ ତୈଳ, ଧୂପାର୍ଥକ ସୁଗନ୍ଧି ଦ୍ରବ୍ୟ, ନିତ୍ୟ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ଅଭିଷେକାର୍ଥକ ତୈଳ, ଏହିସବୁର ତତ୍ତ୍ୱାବଧାନ କାର୍ଯ୍ୟ ହାରୋଣଙ୍କ ପୁତ୍ର ଇଲୀୟାସର ଯାଜକର ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶା ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ତୁମ୍ଭେମାନେ ଲେବୀୟମାନଙ୍କ ମଧ୍ୟରୁ କହାତ ବଂଶୀୟ ଗୋଷ୍ଠୀକୁ ଉଚ୍ଛିନ୍ନ କର ନାହିଁ! ");
INSERT INTO ory_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ମାତ୍ର ସେମାନେ ମହାପବିତ୍ର ସ୍ଥାନର ନିକଟବର୍ତ୍ତୀ ହେଲା ସମୟରେ ଯେପରି ନ ମରି ବଞ୍ଚନ୍ତି, ଏଥିପାଇଁ ତୁମ୍ଭେମାନେ ସେମାନଙ୍କ ପ୍ରତି ଏରୂପ କରିବ; ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ଭିତରେ ଯାଇ ସେମାନଙ୍କର ପ୍ରତ୍ୟେକ ଜଣକୁ ଆପଣା ଆପଣା ସେବାରେ ଓ ଭାର ବହନରେ ନିଯୁକ୍ତ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ମାତ୍ର ସେମାନେ ଯେପରି ନ ମରନ୍ତି, ଏଥିପାଇଁ ସେମାନେ ପବିତ୍ର ସ୍ଥାନ ଦେଖିବା ନିମନ୍ତେ ଏକ ନିମିଷ ପର୍ଯ୍ୟନ୍ତ ଭିତରକୁ ଯିବେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ତୁମ୍ଭେ ଗେର୍ଶୋନ-ସନ୍ତାନଗଣର ପିତୃଗୃହ ଓ ବଂଶାନୁସାରେ ସେମାନଙ୍କର ସଂଖ୍ୟା ନିଅ; ");
INSERT INTO ory_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ତିରିଶ ବର୍ଷ ବୟସ୍କଠାରୁ ପଚାଶ ବର୍ଷ ବୟସ୍କ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁମାନେ ସମାଗମ-ତମ୍ବୁରେ କାର୍ଯ୍ୟ କରିବା ନିମନ୍ତେ ସେବକ ଶ୍ରେଣୀଭୁକ୍ତ ହୁଅନ୍ତି, ସେମାନଙ୍କୁ ଗଣନା କର। ");
INSERT INTO ory_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ସେବା କରିବା ଓ ଭାର ବହିବା କାର୍ଯ୍ୟ ମଧ୍ୟରେ ଗେର୍ଶୋନୀୟ ବଂଶର ସେବା ଏହି; ");
INSERT INTO ory_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ସେମାନେ ଆବାସର ଯବନିକାସକଳ ଓ ସମାଗମ-ତମ୍ବୁ, ତହିଁର ଆଚ୍ଛାଦନ ଓ ତହିଁର ଉପରିସ୍ଥିତ ଶିଶୁକର ଚର୍ମର ଛାତ ଓ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର; ");
INSERT INTO ory_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ଆଉ ପ୍ରାଙ୍ଗଣର ପରଦାସକଳ, ଆବାସର ଓ ବେଦିର ଚତୁର୍ଦ୍ଦିଗସ୍ଥିତ ପ୍ରାଙ୍ଗଣ ଦ୍ୱାରର ଆଚ୍ଛାଦନ ବସ୍ତ୍ର, ତହିଁର ରଜ୍ଜୁ ଓ ତହିଁର ସେବାର୍ଥକ ସମସ୍ତ ଦ୍ରବ୍ୟ ବହିବେ ଓ ସେହି ସବୁରେ ଯେଉଁ ଯେଉଁ କାର୍ଯ୍ୟ କରିବାକୁ ହୁଏ, ତାହାସବୁ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ହାରୋଣ ଓ ତାଙ୍କର ପୁତ୍ରଗଣର ଆଜ୍ଞାନୁସାରେ ଗେର୍ଶୋନର ସନ୍ତାନଗଣ ଆପଣା ଆପଣା ଭାର ଓ ସେବା ସମ୍ବନ୍ଧୀୟ ସମସ୍ତ କର୍ମ କରିବେ ଆଉ ତୁମ୍ଭେମାନେ ରକ୍ଷଣୀୟ ବୋଲି ସେମାନଙ୍କ ସମସ୍ତ ଭାରରେ ସେମାନଙ୍କୁ ନିଯୁକ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ସମାଗମ-ତମ୍ବୁରେ ଗେର୍ଶୋନୀୟ ସନ୍ତାନମାନଙ୍କ ବଂଶର ଏହି ସେବା; ପୁଣି, ସେମାନଙ୍କ ରକ୍ଷଣୀୟ ହାରୋଣ ଯାଜକର ପୁତ୍ର ଈଥାମରର ହସ୍ତଗତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","ଏଉତ୍ତାରେ ତୁମ୍ଭେ ମରାରି-ସନ୍ତାନଗଣର ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ସେମାନଙ୍କୁ ଗଣନା କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ତିରିଶ ବର୍ଷ ବୟସ୍କଠାରୁ ପଚାଶ ବର୍ଷ ବୟସ୍କ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁମାନେ ସମାଗମ-ତମ୍ବୁରେ କାର୍ଯ୍ୟ କରିବା ନିମନ୍ତେ ସେବକ ଶ୍ରେଣୀଭୁକ୍ତ ହୁଅନ୍ତି, ସେମାନଙ୍କୁ ଗଣନା କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ପୁଣି, ସମାଗମ-ତମ୍ବୁରେ ସେମାନଙ୍କର ସମସ୍ତ ସେବାକର୍ମ ସମ୍ବନ୍ଧୀୟ ଏହି ଏହି ଭାର ସେମାନଙ୍କର ରକ୍ଷଣୀୟ ହେବ; ଆବାସର ପଟା, ତହିଁର ଅର୍ଗଳ, ସ୍ତମ୍ଭ ଓ ଚୁଙ୍ଗୀସକଳ, ");
INSERT INTO ory_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ପ୍ରାଙ୍ଗଣର ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ସ୍ତମ୍ଭ, ତହିଁର ଚୁଙ୍ଗୀ, ମେଖ, ରଜ୍ଜୁ ଓ ତହିଁ ସମ୍ବନ୍ଧୀୟ ସମସ୍ତ ଦ୍ରବ୍ୟ ଓ କାର୍ଯ୍ୟ; ତୁମ୍ଭେମାନେ ସେମାନଙ୍କ ରକ୍ଷଣୀୟ-ଭାରର ଦ୍ରବ୍ୟାଦି ନାମ ଦ୍ୱାରା ନିରୂପଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ସମାଗମ-ତମ୍ବୁରେ ମରାରି-ସନ୍ତାନମାନଙ୍କ ବଂଶର ସମସ୍ତ ସେବା ସମ୍ବନ୍ଧୀୟ ଏହି କାର୍ଯ୍ୟ; ଏହା ହାରୋଣ ଯାଜକର ପୁତ୍ର ଈଥାମରର ହସ୍ତଗତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ଏଥିଉତ୍ତାରେ ମୋଶା ଓ ହାରୋଣ ଓ ମଣ୍ଡଳୀର ଅଧିପତିଗଣ କହାତୀୟ ସନ୍ତାନମାନଙ୍କର ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ସେମାନଙ୍କ ମଧ୍ୟରୁ ");
INSERT INTO ory_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ତିରିଶ ବର୍ଷ ବୟସ୍କଠାରୁ ପଚାଶ ବର୍ଷ ବୟସ୍କ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁମାନେ ସମାଗମ-ତମ୍ବୁରେ କର୍ମ କରିବା ନିମନ୍ତେ ସେବକ ଶ୍ରେଣୀଭୁକ୍ତ ହେଲେ, ସେମାନଙ୍କୁ ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ତହିଁରେ ସେମାନଙ୍କ ବଂଶାନୁସାରେ ଗଣିତ ଲୋକ ଦୁଇ ହଜାର ସାତ ଶହ ପଚାଶ ଜଣ ହେଲେ; ");
INSERT INTO ory_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ଏମାନେ କହାତୀୟ ବଂଶର ଗଣିତ ଓ ସମାଗମ-ତମ୍ବୁର ସେବାକର୍ମରେ ନିଯୁକ୍ତ ଲୋକ; ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ଓ ହାରୋଣ ଏମାନଙ୍କୁ ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ପୁଣି, ଗେର୍ଶୋନର ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଯେଉଁମାନେ ଆପଣା ଆପଣା ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ଗଣାଗଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ଅର୍ଥାତ୍‍, ତିରିଶ ବର୍ଷ ବୟସ୍କଠାରୁ ପଚାଶ ବର୍ଷ ବୟସ୍କ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁମାନେ ସମାଗମ-ତମ୍ବୁରେ କର୍ମ କରିବା ନିମନ୍ତେ ସେବକ ଶ୍ରେଣୀଭୁକ୍ତ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ସେମାନେ ଆପଣା ଆପଣା ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ଗଣାଯାʼନ୍ତେ, ଦୁଇ ହଜାର ଛଅ ଶହ ତିରିଶ ଜଣ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ଏମାନେ ଗେର୍ଶୋନ-ସନ୍ତାନଗଣର ବଂଶରେ ଗଣିତ ଓ ସମାଗମ-ତମ୍ବୁର ସେବାକର୍ମରେ ନିଯୁକ୍ତ ଲୋକ; ମୋଶା ଓ ହାରୋଣ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଏମାନଙ୍କୁ ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ଆଉ ମରାରି-ସନ୍ତାନଗଣର ବଂଶ ମଧ୍ୟରେ ଯେଉଁମାନେ ଆପଣା ଆପଣା ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ଗଣାଗଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ଅର୍ଥାତ୍‍, ତିରିଶ ବର୍ଷ ବୟସ୍କଠାରୁ ପଚାଶ ବର୍ଷ ବୟସ୍କ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁମାନେ ସମାଗମ-ତମ୍ବୁରେ କର୍ମ କରିବା ନିମନ୍ତେ ସେବକ ଶ୍ରେଣୀଭୁକ୍ତ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ସେମାନେ ଆପଣା ଆପଣା ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ଗଣାଯାʼନ୍ତେ, ତିନି ହଜାର ଦୁଇ ଶହ ଜଣ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ଏମାନେ ମରାରି-ସନ୍ତାନଗଣ ବଂଶର ଗଣିତ ଲୋକ; ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ଓ ହାରୋଣ ଏମାନଙ୍କୁ ଗଣନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ଏହିରୂପେ ମୋଶା, ହାରୋଣ ଓ ଇସ୍ରାଏଲର ଅଧିପତିଗଣ ଦ୍ୱାରା ଯେଉଁ ଲେବୀୟ ଲୋକମାନେ ଆପଣା ଆପଣା ବଂଶ ଓ ପିତୃଗୃହ ଅନୁସାରେ ଗଣିତ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ଅର୍ଥାତ୍‍, ତିରିଶ ବର୍ଷ ବୟସ୍କଠାରୁ ପଚାଶ ବର୍ଷ ବୟସ୍କ ପର୍ଯ୍ୟନ୍ତ ଯେଉଁମାନେ ସମାଗମ-ତମ୍ବୁରେ ସେବାକର୍ମରେ ଓ ଭାର ବହିବା କର୍ମରେ ନିଯୁକ୍ତ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ସେମାନେ ଗଣାଯାʼନ୍ତେ, ଆଠ ହଜାର ପାଞ୍ଚ ଶହ ଅଶୀ ଜଣ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେମାନେ ପ୍ରତ୍ୟେକେ ମୋଶାଙ୍କର ହସ୍ତ ଦ୍ୱାରା ଆପଣା ଆପଣା ସେବା ଓ ଭାର ବହିବା କର୍ମ ଅନୁସାରେ ଗଣିତ ହେଲେ; ଏହିରୂପେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ତାଙ୍କ ଦ୍ୱାରା ସେମାନେ ଗଣିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ପ୍ରତ୍ୟେକ କୁଷ୍ଠୀକୁ ଓ ପ୍ରତ୍ୟେକ ପ୍ରମେହୀକୁ ଓ ଶବ ଛୁଇଁ ଅଶୁଚି ହେବା ପ୍ରତ୍ୟେକ ପ୍ରାଣୀକୁ ଛାଉଣିରୁ ବାହାର କରିବା ପାଇଁ ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଆଜ୍ଞା ଦିଅ। ");
INSERT INTO ory_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ତୁମ୍ଭେମାନେ ପୁରୁଷ ଓ ସ୍ତ୍ରୀ ଦୁହିଁଙ୍କୁ ବାହାର କରିବ, ତୁମ୍ଭେମାନେ ଛାଉଣିର ବାହାରେ ସେମାନଙ୍କୁ ରଖିବ; ସେମାନଙ୍କର ଯେଉଁ ଛାଉଣି ମଧ୍ୟରେ ଆମ୍ଭେ ବାସ କରୁ, ତାହା ସେମାନେ ଅଶୁଚି ନ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସେହିରୂପ କଲେ, ପୁଣି, ଛାଉଣିର ବାହାରେ ସେମାନଙ୍କୁ ରଖିଲେ; ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେପରି କହିଲେ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସେପରି କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ଏଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, କୌଣସି ପୁରୁଷ କିମ୍ବା ସ୍ତ୍ରୀ ଯଦି ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ସତ୍ୟ-ଲଙ୍ଘନ କରି ମନୁଷ୍ୟମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରଚଳିତ କୌଣସି ପାପ କରେ ଓ ସେହି ପ୍ରାଣୀ ଦଣ୍ଡନୀୟ ହୁଏ, ");
INSERT INTO ory_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ତେବେ ସେ ଆପଣା କୃତ ପାପ ସ୍ୱୀକାର କରିବ ଓ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଆପଣା ଦୋଷ ସକାଶୁ କ୍ଷତିପୂରଣ ଦେବ ଓ ତହିଁର ପଞ୍ଚମାଂଶ ଅଧିକ ମିଶାଇ ଯାହା ବିରୁଦ୍ଧରେ ଦୋଷ କରିଅଛି, ତାହାକୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ମାତ୍ର ଯାହାକୁ ଦୋଷ ନିମନ୍ତେ କ୍ଷତିପୂରଣ ଦିଆଯାଇ ପାରେ, ଏପରି ମୁକ୍ତିକର୍ତ୍ତା ଜ୍ଞାତି ଯଦି ସେହି ଲୋକର ନ ଥାଏ, ତେବେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯେଉଁ ଦୋଷାର୍ଥକ କ୍ଷତିପୂରଣ ଦିଆଯାଏ, ତାହା ଯାଜକର ହେବ; ତାହା ବ୍ୟତୀତ ଯଦ୍ଦ୍ୱାରା ତାହା ପାଇଁ ପ୍ରାୟଶ୍ଚିତ୍ତ କରାଯିବ, ସେହି ପ୍ରାୟଶ୍ଚିତ୍ତାର୍ଥକ ମେଷବଳି ହିଁ ଦେବାକୁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଆପଣାମାନଙ୍କ ପବିତ୍ର ବସ୍ତୁ ମଧ୍ୟରୁ ଯେତେ ଉତ୍ତୋଳନୀୟ ଉପହାର ଯାଜକ ନିକଟକୁ ଆଣନ୍ତି, ତାହାସବୁ ତାହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ପ୍ରତ୍ୟେକ ମନୁଷ୍ୟର ଉତ୍ସର୍ଗିତ ପବିତ୍ର ବସ୍ତୁ ତାହାର ହେବ; ମନୁଷ୍ୟ ଯେକୌଣସି ବସ୍ତୁ ଯାଜକକୁ ଦିଏ, ତାହା ତାହାର ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, କୌଣସି ମନୁଷ୍ୟର ଭାର୍ଯ୍ୟା ଯଦି ବିପଥଗାମିନୀ ହୋଇ ତାହା ବିରୁଦ୍ଧରେ ସତ୍ୟ-ଲଙ୍ଘନ କରେ, ");
INSERT INTO ory_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ଅର୍ଥାତ୍‍, ଯଦି କୌଣସି ପୁରୁଷ ତାହା ସହିତ ସହବାସ କରେ ଓ ତାହା ତାହାର ସ୍ୱାମୀର ଦୃଷ୍ଟିରୁ ଅଗୋଚର ହୋଇ ଗୁପ୍ତ ହୁଏ ଓ ସେ ଅଶୁଚି ହୁଏ, ପୁଣି, ତାହା ବିରୁଦ୍ଧରେ କେହି ସାକ୍ଷୀ ନ ଥାଏ, କିଅବା ସେ କର୍ମ ସମୟରେ ଧରା ପଡ଼ି ନ ଥାଏ; ");
INSERT INTO ory_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ଆଉ ଯଦି ସ୍ୱାମୀ ଈର୍ଷାଜନକ ଆତ୍ମାରେ ଆବିଷ୍ଟ ହୁଏ ଓ ଭାର୍ଯ୍ୟା ଅଶୁଚି ହେବାରୁ ତାହା ପ୍ରତି ଈର୍ଷାରେ ଜ୍ୱଳେ; ଅବା ଭାର୍ଯ୍ୟା ଅଶୁଚି ନୋହିଲେ ହେଁ ଯଦି ସ୍ୱାମୀ ଈର୍ଷାଜନକ ଆତ୍ମାରେ ଆବିଷ୍ଟ ହୋଇ ତାହା ପ୍ରତି ଈର୍ଷାରେ ଜ୍ୱଳେ; ");
INSERT INTO ory_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ତେବେ ସେହି ପୁରୁଷ ଆପଣା ଭାର୍ଯ୍ୟାକୁ ଯାଜକ ନିକଟକୁ ଆଣିବ ଓ ତାହା ନିମନ୍ତେ ଐଫାର ଦଶମାଂଶ ଯବ ମଇଦା ଉପହାର ଆଣିବ; ସେ ତହିଁ ଉପରେ ତୈଳ ଢାଳିବ ନାହିଁ ଅବା କୁନ୍ଦୁରୁ ଦେବ ନାହିଁ, କାରଣ ତାହା ଈର୍ଷାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ଅର୍ଥାତ୍‍ ଅପରାଧ-ସ୍ମରଣକାରୀ ସ୍ମରଣାର୍ଥକ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ। ");
INSERT INTO ory_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","ଏଉତ୍ତାରେ ଯାଜକ ସେହି ସ୍ତ୍ରୀକୁ ନିକଟକୁ ଆଣି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ପୁଣି, ଯାଜକ ମୃତ୍ତିକା ପାତ୍ରରେ ପବିତ୍ର ଜଳ ନେବ ଓ ଯାଜକ ଆବାସର ଚଟାଣରୁ ଧୂଳି ନେଇ ସେହି ଜଳରେ ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ତହୁଁ ଯାଜକ ସେହି ସ୍ତ୍ରୀକୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରିବ ଓ ସେହି ସ୍ତ୍ରୀର ମସ୍ତକର କେଶ ମୁକୁଳା କରି ସେହି ସ୍ମରଣାର୍ଥକ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ଅର୍ଥାତ୍‍ ଈର୍ଷାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ତାହାର ହସ୍ତରେ ଦେବ; ପୁଣି, ଯାଜକ ଆପଣା ହସ୍ତରେ ଅଭିଶାପଜନକ ତିକ୍ତ ଜଳ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ଆଉ ଯାଜକ ସେହି ସ୍ତ୍ରୀକୁ ଶପଥ କରାଇ କହିବ, ଯଦି କୌଣସି ପୁରୁଷ ତୁମ୍ଭ ସହିତ ଶୟନ କରି ନ ଥାଏ ଓ ତୁମ୍ଭେ ଆପଣା ସ୍ୱାମୀର ଅଧୀନରେ ଥାଉ ଥାଉ ବିପଥଗାମିନୀ ହୋଇ ଅଶୁଚି କ୍ରିୟା କରି ନ ଥାଅ, ତେବେ ତୁମ୍ଭେ ଏହି ଅଭିଶାପଜନକ ତିକ୍ତ ଜଳରୁ ମୁକ୍ତ ହୁଅ। ");
INSERT INTO ory_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ମାତ୍ର ଯଦି ତୁମ୍ଭେ ଆପଣା ସ୍ୱାମୀର ଅଧୀନରେ ଥାଉ ଥାଉ ବିପଥଗାମିନୀ ହୋଇଥାଅ ଓ ତୁମ୍ଭେ ଅଶୁଚି ହୋଇଥାଅ, ପୁଣି, ତୁମ୍ଭ ସ୍ୱାମୀ ବ୍ୟତୀତ ଅନ୍ୟ କୌଣସି ପୁରୁଷ ତୁମ୍ଭ ସହିତ ଶୟନ କରିଥାଏ; ");
INSERT INTO ory_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ତେବେ ସଦାପ୍ରଭୁ ତୁମ୍ଭର ଊରୁ ଅବଶ କରାଇ ଓ ତୁମ୍ଭର ଉଦର ଫୁଲାଇ ତୁମ୍ଭ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ତୁମ୍ଭଙ୍କୁ ଶପଥ ଓ ରାଣର ଫଳ ଭୋଗ କରାଉନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ତହିଁରେ ଏହି ଅଭିଶାପଜନକ ଜଳ ତୁମ୍ଭ ଉଦର ଫୁଲାଇବାକୁ ଓ ଊରୁ ଅବଶ କରାଇବାକୁ ତୁମ୍ଭ ଉଦରରେ ପ୍ରବେଶ କରୁ; ଏହି ସକଳ କଥା କହି ଯାଜକ ରାଣଯୁକ୍ତ ଶପଥ ଦ୍ୱାରା ସେହି ସ୍ତ୍ରୀକୁ ଶପଥ କରାଇବ; ତହିଁରେ ସେହି ସ୍ତ୍ରୀ ଆମେନ୍‍ କହିବ। ");
INSERT INTO ory_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","ପୁଣି, ଯାଜକ ସେହି ଅଭିଶାପର କଥା ନଳାକାର ପୁସ୍ତକରେ ଲେଖିବ ଓ ତାହା ପୋଛି ତିକ୍ତ ଜଳରେ ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ତହୁଁ ସେ ସେହି ସ୍ତ୍ରୀକୁ ଅଭିଶାପଜନକ ତିକ୍ତ ଜଳ ପିଆଇବ; ତହିଁରେ ସେହି ଅଭିଶାପଜନକ ଜଳ ତାହା ଉଦରରେ ପ୍ରବେଶ କରି ତିକ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ଆଉ ଯାଜକ ସେହି ସ୍ତ୍ରୀର ହସ୍ତରୁ ସେହି ଈର୍ଷାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନେଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳାଇବ, ପୁଣି, ବେଦି ଉପରକୁ ଆଣିବ; ");
INSERT INTO ory_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ତହୁଁ ଯାଜକ ସେହି ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟରୁ ମୁଠିଏ ତହିଁର ସ୍ମରଣାର୍ଥକ ଅଂଶ ରୂପେ ନେଇ ବେଦି ଉପରେ ଦଗ୍ଧ କରିବ ଓ ତହିଁ ଉତ୍ତାରେ ସେହି ସ୍ତ୍ରୀକୁ ସେହି ଜଳ ପାନ କରାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ପୁଣି, ସେ ସେହି ସ୍ତ୍ରୀକୁ ଜଳ ପାନ କରାଇଲେ ଏପରି ହେବ, ଯଦି ସେହି ସ୍ତ୍ରୀ ଆପଣା ସ୍ୱାମୀ ବିରୁଦ୍ଧରେ ସତ୍ୟ-ଲଙ୍ଘନ କରି ଅଶୁଚି ହୋଇଥାଏ, ତେବେ ସେହି ଅଭିଶାପଜନକ ଜଳ ତାହା ମଧ୍ୟରେ ପ୍ରବେଶ କରି ତିକ୍ତ ହେବ ଓ ତାହାର ଉଦର ଫୁଲିବ ଓ ତାହାର ଊରୁ ଅବଶ ହେବ; ଆଉ ସେହି ସ୍ତ୍ରୀ ଆପଣା ଲୋକଙ୍କ ମଧ୍ୟରେ ଅଭିଶାପ ସ୍ୱରୂପ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ଆଉ ଯଦି ସେହି ସ୍ତ୍ରୀ ଅଶୁଚି ନ ହୋଇ ଶୁଚି ଥାଏ, ତେବେ ସେ ମୁକ୍ତ ହେବ ଓ ଗର୍ଭଧାରଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","ଏହା ଈର୍ଷା ବିଷୟକ ବ୍ୟବସ୍ଥା, ଯଥା, ଭାର୍ଯ୍ୟା ସ୍ୱାମୀର ଅଧୀନରେ ଥାଉ ଥାଉ ବିପଥଗାମିନୀ ହୋଇ ଅଶୁଚି ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ଅବା କୌଣସି ପୁରୁଷ ଈର୍ଷାଜନକ ଆତ୍ମାରେ ଆବିଷ୍ଟ ହୋଇ ଆପଣା ଭାର୍ଯ୍ୟା ପ୍ରତି ଈର୍ଷାରେ ଜ୍ୱଳିଲେ, ସେ ସେହି ସ୍ତ୍ରୀକୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରାଇବ, ପୁଣି, ଯାଜକ ସେହି ସ୍ତ୍ରୀ ପ୍ରତି ଏହି ସମସ୍ତ ବ୍ୟବସ୍ଥା ପାଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ତହିଁରେ ସେହି ପୁରୁଷ ଅପରାଧରୁ ମୁକ୍ତ ହେବ ଓ ସେହି ସ୍ତ୍ରୀ ଆପଣା ଆପଣା ଅପରାଧ ବୋହିବ।” ");
INSERT INTO ory_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, କୌଣସି ପୁରୁଷ କିମ୍ବା ସ୍ତ୍ରୀ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପୃଥକ ହେବା ନିମନ୍ତେ ଯଦି ନାସରୀୟ କୌଣସି ବିଶେଷ ବ୍ରତ କରେ, ");
INSERT INTO ory_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ତେବେ ସେ ଦ୍ରାକ୍ଷାରସ ଓ ସୁରାରୁ ଆପଣାକୁ ପୃଥକ କରିବ; ସେ ଦ୍ରାକ୍ଷାରସର ସିର୍କା ଓ ସୁରାର ସିର୍କା ପାନ କରିବ ନାହିଁ, କିଅବା ସେ ଦ୍ରାକ୍ଷାଫଳ ଜାତ କୌଣସି ପେୟ ପାନ କରିବ ନାହିଁ ଓ କଞ୍ଚା କିମ୍ବା ଶୁଖିଲା ଦ୍ରାକ୍ଷାଫଳ ଖାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ସେ ତାହାର ପୃଥକ ଥିବା ସମସ୍ତ ଦିନ ଦ୍ରାକ୍ଷାଫଳରେ ପ୍ରସ୍ତୁତ କୌଣସି ଦ୍ରବ୍ୟ କିମ୍ବା ତହିଁର ମଞ୍ଜିଠାରୁ ଚୋପା ପର୍ଯ୍ୟନ୍ତ କିଛି ଖାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ତାହାର ବ୍ରତ ହେତୁ ପୃଥକ ଥିବା ସମସ୍ତ ଦିନ ତାହାର ମସ୍ତକରେ କ୍ଷୁର ଲାଗିବ ନାହିଁ; ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପୃଥକ ଥିବା ଦିନ ସମାପ୍ତ ହେବା ପର୍ଯ୍ୟନ୍ତ ସେ ପବିତ୍ର ରହିବ, ସେ ଆପଣା ମସ୍ତକର କେଶ ବୃଦ୍ଧି ପାଇବାକୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ସେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପୃଥକ ଥିବା ସମସ୍ତ ଦିନ କୌଣସି ଶବ ନିକଟକୁ ଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ଆପଣା ପିତା କିମ୍ବା ମାତା କିମ୍ବା ଭ୍ରାତା କିମ୍ବା ଭଗିନୀ ମଲେ, ସେ ସେମାନଙ୍କ ସକାଶୁ ଆପଣାକୁ ଅଶୁଚି କରିବ ନାହିଁ; କାରଣ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପୃଥକ ହେବାର ଚିହ୍ନ ତାହାର ମସ୍ତକରେ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ତାହାର ପୃଥକ ଥିବା ସମସ୍ତ ଦିନ ସେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର। ");
INSERT INTO ory_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ଆଉ ଯଦି କୌଣସି ମନୁଷ୍ୟ ହଠାତ୍‍ ତାହା ନିକଟରେ ମରିବାରୁ ସେ ଆପଣା ପ୍ରତିଷ୍ଠିତ ମସ୍ତକ ଅଶୁଚି କରେ, ତେବେ ସେ ଶୌଚ-ଦିନରେ ଆପଣା ମସ୍ତକ ମୁଣ୍ଡନ କରିବ, ଅର୍ଥାତ୍‍, ସେ ସପ୍ତମ ଦିନରେ ତାହା ମୁଣ୍ଡନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ପୁଣି, ଅଷ୍ଟମ ଦିନରେ ସେ ଦୁଇ ଘୁଘୁ ଅବା ଦୁଇ କପୋତ ଛୁଆ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରରେ ଯାଜକ ନିକଟକୁ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ଆଉ ଯାଜକ ତହିଁରୁ ଗୋଟିକୁ ପାପାର୍ଥେ ଓ ଅନ୍ୟଟିକୁ ହୋମାର୍ଥେ ଉତ୍ସର୍ଗ କରିବ ଓ ସେ ଶବ-ଘଟିତ ଯେଉଁ ପାପ କଲା, ତହିଁ ଲାଗି ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ ଓ ସେ ସେହି ଦିନ ତାହାର ମସ୍ତକ ପବିତ୍ର କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ତହୁଁ ସେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପୃଥକ ହୋଇ ରହିବା ଦିନମାନ ପୃଥକ କରିବ, ପୁଣି, ଦୋଷାର୍ଥକ ବଳି ନିମନ୍ତେ ଏକ ବର୍ଷୀୟ ଗୋଟିଏ ମେଷବତ୍ସ ଆଣିବ; ମାତ୍ର ପୂର୍ବ ଦିନସବୁ ବୃଥା ହେବ, କାରଣ ତାହାର ପୃଥକ‍କରଣ ଅଶୁଚି ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","ଆଉ ପୃଥକ ରହିବା ଦିନ ସମ୍ପୂର୍ଣ୍ଣ ହେଲେ, ନାସରୀୟ ବ୍ରତର ଏହି ବ୍ୟବସ୍ଥା ବ୍ରତକାରୀ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାର ନିକଟକୁ ଅଣାଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ପୁଣି, ସେ ହୋମାର୍ଥେ ଏକ ବର୍ଷୀୟ ନିଖୁନ୍ତ ଏକ ମେଷବତ୍ସ ଓ ପାପାର୍ଥେ ଏକ ବର୍ଷୀୟ ନିଖୁନ୍ତ ଏକ ମେଷବତ୍ସା ଓ ମଙ୍ଗଳାର୍ଥେ ନିଖୁନ୍ତ ଏକ ମେଷ ");
INSERT INTO ory_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ଓ ଏକ ଡାଲା ତାଡ଼ିଶୂନ୍ୟ ରୁଟି, ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାର ପିଠା, ତାଡ଼ିଶୂନ୍ୟ ତୈଳାକ୍ତ ସରୁ ଚକୁଳି, ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","ତହୁଁ ଯାଜକ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଏହିସବୁ ଆଣି ତାହାର ପାପାର୍ଥକ ବଳି ଓ ହୋମାର୍ଥକ ବଳି ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ତହିଁ ଉତ୍ତାରେ ସେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟିର ଡାଲା ସହିତ ମଙ୍ଗଳାର୍ଥକ ମେଷବଳି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ; ମଧ୍ୟ ଯାଜକ ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ତେବେ ନାସରୀୟ ଲୋକ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରରେ ଆପଣା ପ୍ରତିଷ୍ଠିତ ମସ୍ତକ ମୁଣ୍ଡନ କରିବ ଓ ଆପଣା ପ୍ରତିଷ୍ଠିତ ମସ୍ତକର କେଶ ନେଇ ମଙ୍ଗଳାର୍ଥକ ବଳିର ଅଧଃସ୍ଥିତ ଅଗ୍ନିରେ ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ପୁଣି, ନାସରୀୟ ଲୋକ ଆପଣା ପ୍ରତିଷ୍ଠିତ ମସ୍ତକ ମୁଣ୍ଡନ କଲା ଉତ୍ତାରେ, ଯାଜକ ସେହି ମେଷର ଜଳସିଦ୍ଧ ସ୍କନ୍ଧ, ଡାଲାରୁ ଗୋଟିଏ ତାଡ଼ିଶୂନ୍ୟ ପିଠା ଓ ତାଡ଼ିଶୂନ୍ୟ ସରୁ ଚକୁଳି ନେଇ ତାହାର ହସ୍ତରେ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ଆଉ, ଯାଜକ ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥେ ତାହାସବୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳାଇବ; ତହିଁରେ ଦୋଳନୀୟ ବକ୍ଷ ଓ ଉତ୍ତୋଳନୀୟ ଚଟୁଆ ସହିତ ତାହା ଯାଜକର ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବ; ତହିଁ ଉତ୍ତାରେ ସେହି ନାସରୀୟ ଲୋକ ଦ୍ରାକ୍ଷାରସ ପାନ କରି ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","ନାସରୀୟ ବ୍ରତଧାରୀ ଲୋକ ଯାହା ଦେବାକୁ ସକ୍ଷମ, ତାହା ବ୍ୟତୀତ ଓ ତାହାର ପୃଥକ ରହିବା ସକାଶୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ନୈବେଦ୍ୟ-ଦାନର ବ୍ୟବସ୍ଥା ଏହି; ସେ ଯେରୂପ ବ୍ରତ କରେ, ପୃଥକ ରହିବା ବ୍ୟବସ୍ଥାନୁସାରେ ତାହା ତାହାକୁ କରିବାକୁ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ତୁମ୍ଭେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣକୁ କୁହ, ‘ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଏହିରୂପେ ଆଶୀର୍ବାଦ କରିବ; ତୁମ୍ଭେମାନେ ସେମାନଙ୍କୁ କହିବ, ");
INSERT INTO ory_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","ସଦାପ୍ରଭୁ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରନ୍ତୁ ଓ ତୁମ୍ଭକୁ ରକ୍ଷା କରନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ସଦାପ୍ରଭୁ ତୁମ୍ଭ ଉପରେ ଆପଣା ମୁଖର ତେଜ ପ୍ରକାଶ କରନ୍ତୁ ଓ ତୁମ୍ଭକୁ ଅନୁଗ୍ରହ କରନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ସଦାପ୍ରଭୁ ତୁମ୍ଭ ଉପରେ ଆପଣା ମୁଖ ଉଠାଉନ୍ତୁ ଓ ତୁମ୍ଭକୁ ଶାନ୍ତି ଦେଉନ୍ତୁ।’” ");
INSERT INTO ory_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ଏହିରୂପେ ସେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଉପରେ ଆମ୍ଭର ନାମ ରଖିବେ; ତହିଁରେ ଆମ୍ଭେ ସେମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରିବା। ");
INSERT INTO ory_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ଏଥିଉତ୍ତାରେ ଯେଉଁ ଦିନ ମୋଶା ଆବାସ ସ୍ଥାପନ ସମାପ୍ତ କରି ତାହା ଅଭିଷେକ ଓ ପବିତ୍ର କଲେ ଓ ତହିଁର ସକଳ ଦ୍ରବ୍ୟ ଓ ବେଦି ଓ ତହିଁର ସକଳ ପାତ୍ର ଅଭିଷେକ କରି ପବିତ୍ର କଲେ; ");
INSERT INTO ory_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ସେହି ଦିନ ଇସ୍ରାଏଲର ଅଧିପତିଗଣ, ସେମାନଙ୍କ ପିତୃଗୃହର ପ୍ରଧାନଗଣ ନୈବେଦ୍ୟ ଦାନ କଲେ; ଏମାନେ ବଂଶସମୂହର ଅଧିପତି ଥିଲେ ଓ ଗଣିତ ଲୋକମାନଙ୍କ ଉପରେ ନିଯୁକ୍ତ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ପୁଣି, ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ନୈବେଦ୍ୟ ନିମନ୍ତେ ଛଅଗୋଟି ଆଚ୍ଛାଦିତ ଶଗଡ଼ ଓ ବାରଟି ଗୋରୁ, ଅର୍ଥାତ୍‍, ଦୁଇ ଦୁଇ ଅଧିପତି ଏକ ଏକ ଶଗଡ଼ ଓ ଏକ ଏକ ଜଣ ଏକ ଏକ ଗୋରୁ ଆଣି ଆବାସ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ତୁମ୍ଭେ ସେମାନଙ୍କଠାରୁ ତାହା ଗ୍ରହଣ କର, ତାହାସବୁ ସମାଗମ-ତମ୍ବୁର ସେବା ନିମନ୍ତେ ହେବ; ଆଉ ତୁମ୍ଭେ ପ୍ରତ୍ୟେକ ଜଣ ଆପଣା ଆପଣା ସେବାନୁସାରେ ଲେବୀୟମାନଙ୍କୁ ତାହାସବୁ ଦେବ।” ");
INSERT INTO ory_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ତହୁଁ ମୋଶା ସେହି ଶଗଡ଼ ଓ ଗୋରୁ ନେଇ ଲେବୀୟମାନଙ୍କୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ଗେର୍ଶୋନୀୟ-ସନ୍ତାନଗଣକୁ ସେମାନଙ୍କ ସେବାନୁସାରେ ସେ ଦୁଇ ଶଗଡ଼ ଓ ଚାରି ଗୋରୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ହାରୋଣ ଯାଜକଙ୍କର ପୁତ୍ର ଈଥାମରର ହସ୍ତାଧୀନରେ ମରାରି-ସନ୍ତାନଗଣକୁ ସେମାନଙ୍କ ସେବାନୁସାରେ ସେ ଚାରି ଶଗଡ଼ ଓ ଆଠ ଗୋରୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ମାତ୍ର ସେ କହାତ-ସନ୍ତାନଗଣକୁ କିଛି ଦେଲେ ନାହିଁ, କାରଣ ପବିତ୍ର ସ୍ଥାନର ସେବାକର୍ମ ସେମାନଙ୍କର ଥିଲା; ସେମାନେ ସ୍କନ୍ଧରେ ତାହା ବୋହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ଆଉ ବେଦିର ଅଭିଷେକ ଦିନ ଅଧିପତିଗଣ ତହିଁର ପ୍ରତିଷ୍ଠା ନିମନ୍ତେ ଦାନ କଲେ, ଅର୍ଥାତ୍‍, ସେହି ଅଧିପତିଗଣ ବେଦି ସମ୍ମୁଖରେ ଆପଣା ଆପଣା ଉପହାର ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ପ୍ରତ୍ୟେକ ଅଧିପତି ଆପଣା ଆପଣା ଦିନରେ ବେଦିର ପ୍ରତିଷ୍ଠା ନିମନ୍ତେ ଉପହାର ଉତ୍ସର୍ଗ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ତହିଁରେ ପ୍ରଥମ ଦିନ ଯିହୁଦା ବଂଶଜାତ ଅମ୍ମୀନାଦବର ପୁତ୍ର ନହଶୋନ ଆପଣା ଉପହାର ଉତ୍ସର୍ଗ କଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଶହେ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ; ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ-ନୈବେଦ୍ୟାର୍ଥେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ ");
INSERT INTO ory_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ଓ ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ ଏହା ଅମ୍ମୀନାଦବର ପୁତ୍ର ନହଶୋନର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ଦ୍ୱିତୀୟ ଦିନ ଇଷାଖରର ଅଧିପତି ସୂୟାରର ପୁତ୍ର ନଥନେଲ ଆପଣା ଉପହାର ଉତ୍ସର୍ଗ କଲା, ");
INSERT INTO ory_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ସେ ଆପଣା ଉପହାର ନିମନ୍ତେ ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏହା ଦେଲା, ଅର୍ଥାତ୍‍, ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ; ଏହା ସୂୟାରର ପୁତ୍ର ନଥନେଲର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ତୃତୀୟ ଦିନ ସବୂଲୂନ-ସନ୍ତାନଗଣର ଅଧିପତି ହେଲୋନର ପୁତ୍ର ଇଲୀୟାବ୍‍ ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ; ଏହା ହେଲୋନର ପୁତ୍ର ଇଲୀୟାବ୍‍ର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ଚତୁର୍ଥ ଦିନ ରୁବେନ୍‍-ସନ୍ତାନଗଣର ଅଧିପତି ଶଦେୟରର ପୁତ୍ର ଇଲୀଷୂର ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ; ");
INSERT INTO ory_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ; ଏହା ଶଦେୟରର ପୁତ୍ର ଇଲୀଷୂରର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ପଞ୍ଚମ ଦିନ ଶିମୀୟୋନ-ସନ୍ତାନଗଣର ଅଧିପତି ସୂରୀଶଦ୍ଦୟର ପୁତ୍ର ଶଲୁମୀୟେଲ ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାରେ ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ; ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ ଏହା ସୂରୀଶଦ୍ଦୟର ପୁତ୍ର ଶଲୁମୀୟେଲର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ଷଷ୍ଠ ଦିନ ଗାଦ୍‍-ସନ୍ତାନଗଣର ଅଧିପତି ଦ୍ୟୂୟେଲର ପୁତ୍ର ଇଲୀୟାସଫ୍‍ ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ଆଉ ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ; ");
INSERT INTO ory_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ; ଏହା ଦ୍ୟୂୟେଲର ପୁତ୍ର ଇଲୀୟାସଫ୍‍ର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ସପ୍ତମ ଦିନ ଇଫ୍ରୟିମ-ସନ୍ତାନଗଣର ଅଧିପତି ଅମ୍ମୀହୂଦର ପୁତ୍ର ଇଲୀଶାମା ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ; ");
INSERT INTO ory_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ; ଏହା ଅମ୍ମୀହୂଦର ପୁତ୍ର ଇଲୀଶାମାର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ଅଷ୍ଟମ ଦିନ ମନଃଶି-ସନ୍ତାନଗଣର ଅଧିପତି ପଦାହସୂରର ପୁତ୍ର ଗମଲୀୟେଲ ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ; ଏହା ପଦାହସୂରର ପୁତ୍ର ଗମଲୀୟେଲର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ନବମ ଦିନ ବିନ୍ୟାମୀନ୍-ସନ୍ତାନଗଣର ଅଧିପତି ଗିଦିୟୋନିର ପୁତ୍ର ଅବୀଦାନ୍‍ ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ; ଏହା ଗିଦିୟୋନିର ପୁତ୍ର ଅବୀଦାନ୍‍ର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ଦଶମ ଦିନ ଦାନ୍-ସନ୍ତାନଗଣର ଅଧିପତି ଅମ୍ମୀଶଦ୍ଦୟର ପୁତ୍ର ଅହୀୟେଷର ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ ଏହା ଅମ୍ମୀଶଦ୍ଦୟର ପୁତ୍ର ଅହୀୟେଷରର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ଏକାଦଶ ଦିନ ଆଶେର-ସନ୍ତାନଗଣର ଅଧିପତି ଅକ୍ରଣର ପୁତ୍ର ପଗୀୟେଲ ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ ଏହା ଅକ୍ରଣର ପୁତ୍ର ପଗୀୟେଲର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ଦ୍ୱାଦଶ ଦିନ ନପ୍ତାଲି-ସନ୍ତାନଗଣର ଅଧିପତି ଐନନର ପୁତ୍ର ଅହୀର ଆଣିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ତାହାର ଉପହାର ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଏକ ଶହ ତିରିଶ ଶେକଲ ପରିମିତ ରୂପାର ଏକ ଥାଳୀ ଓ ସତୁରି ଶେକଲ ପରିମିତ ରୂପାର ଏକ କୁଣ୍ଡ, ଏହି ଦୁଇ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାରେ ପୂର୍ଣ୍ଣ; ");
INSERT INTO ory_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ଧୂପରେ ପରିପୂର୍ଣ୍ଣ ଦଶ ଶେକଲ ପରିମିତ ସ୍ୱର୍ଣ୍ଣର ଏକ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଏକ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦୁଇ ଗୋରୁ, ପାଞ୍ଚ ମେଷ, ପାଞ୍ଚ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ପାଞ୍ଚ ମେଷବତ୍ସ ଏହା ଐନନର ପୁତ୍ର ଅହୀରର ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ବେଦିର ଅଭିଷେକ ଦିନ, ତହିଁର ପ୍ରତିଷ୍ଠାର୍ଥକ ଏହି ଉପହାର ଇସ୍ରାଏଲର ଅଧିପତିଗଣ ଦ୍ୱାରା ଦତ୍ତ ହୋଇଥିଲା; ରୂପାର ଦ୍ୱାଦଶ ଥାଳୀ, ରୂପାର ଦ୍ୱାଦଶ କୁଣ୍ଡ ଓ ସ୍ୱର୍ଣ୍ଣର ଦ୍ୱାଦଶ ଚାମଚ; ");
INSERT INTO ory_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ତହିଁର ପ୍ରତ୍ୟେକ ରୂପାଥାଳୀ ଏକ ଶହ ତିରିଶ ଶେକଲ ଓ ପ୍ରତ୍ୟେକ କୁଣ୍ଡ ସତୁରି ଶେକଲ ପରିମିତ; ସମସ୍ତ ପାତ୍ରର ରୂପା ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଦୁଇ ହଜାର ଚାରି ଶହ ଶେକଲ ଥିଲା; ");
INSERT INTO ory_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ପୁଣି, ଧୂପପୂର୍ଣ୍ଣ ଦ୍ୱାଦଶ ସ୍ୱର୍ଣ୍ଣ ଚାମଚ, ପ୍ରତ୍ୟେକେ ପବିତ୍ର ସ୍ଥାନର ଶେକଲ ଅନୁସାରେ ଦଶ ଶେକଲ ପରିମିତ; ଚାମଚର ସମସ୍ତ ସ୍ୱର୍ଣ୍ଣ ଶହେ କୋଡ଼ିଏ ଶେକଲ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ହୋମ ନିମନ୍ତେ ସମୁଦାୟ ଦ୍ୱାଦଶ ଗୋରୁ, ଦ୍ୱାଦଶ ମେଷ, ଏକ ବର୍ଷୀୟ ଦ୍ୱାଦଶ ମେଷବତ୍ସ ଓ ସେସବୁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ; ଆଉ ପାପାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ଦ୍ୱାଦଶ ଛାଗ; ");
INSERT INTO ory_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ପୁଣି, ମଙ୍ଗଳାର୍ଥକ ବଳିଦାନ ନିମନ୍ତେ ସମୁଦାୟ ଚବିଶ ଗୋରୁ, ଷାଠିଏ ମେଷ, ଷାଠିଏ ଛାଗ ଓ ଏକ ବର୍ଷୀୟ ଷାଠିଏ ମେଷବତ୍ସ; ଏହା ବେଦିର ଅଭିଷେକ ଉତ୍ତାରେ ତହିଁର ପ୍ରତିଷ୍ଠା ନିମନ୍ତେ ଦତ୍ତ ଉପହାର। ");
INSERT INTO ory_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ଏଉତ୍ତାରେ ମୋଶା ତାହାଙ୍କ ସହିତ କଥା କହିବାକୁ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କରନ୍ତେ, ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକର ଉପରିସ୍ଥିତ ପାପାଚ୍ଛାଦନର ଉପରୁ, କିରୂବ ଦ୍ୱୟ ମଧ୍ୟରୁ ଆପଣା ପ୍ରତି ବାକ୍ୟବାଦୀ ରବ ଶୁଣିଲେ; ପୁଣି, ସେ ତାଙ୍କ ସହିତ କଥା କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ତୁମ୍ଭେ ହାରୋଣକୁ କୁହ, ‘ତୁମ୍ଭେ ପ୍ରଦୀପ ଜାଳିବା ସମୟରେ ସେହି ସପ୍ତ ପ୍ରଦୀପ ଦୀପବୃକ୍ଷର ସମ୍ମୁଖ ଭାଗରେ ଆଲୁଅ ଦେବ।’” ");
INSERT INTO ory_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ତହିଁରେ ହାରୋଣ ସେହିରୂପ କଲେ; ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ, ଯେପରି ଦୀପବୃକ୍ଷର ସମ୍ମୁଖ ଭାଗରେ ଆଲୁଅ ହେବ, ସେ ସେହିପରି ଦୀପମାନ ଜ୍ୱଳାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ସେହି ଦୀପବୃକ୍ଷର କର୍ମ ସ୍ୱର୍ଣ୍ଣର ପିଟାକର୍ମ ଥିଲା; ତହିଁର ଗଣ୍ଡି ଓ ପୁଷ୍ପ ପର୍ଯ୍ୟନ୍ତ ପିଟାକର୍ମ ଥିଲା; ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେଉଁ ଆଦର୍ଶ ଦେଖାଇଥିଲେ, ତଦନୁସାରେ ସେ ଦୀପବୃକ୍ଷ ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ଲେବୀୟମାନଙ୍କୁ ନେଇ ଶୁଚି କର। ");
INSERT INTO ory_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ତୁମ୍ଭେ ସେମାନଙ୍କୁ ଶୁଚି କରିବା ନିମନ୍ତେ ଏହିରୂପ କରିବ; ସେମାନଙ୍କ ଉପରେ ପବିତ୍ରୀକରଣ ଜଳ ପ୍ରକ୍ଷେପ କର ଓ ସେମାନେ ଆପଣା ଆପଣାର ସମସ୍ତ ଶରୀରରେ କ୍ଷୁର ଚଳାନ୍ତୁ ଓ ସେମାନେ ଆପଣା ଆପଣା ବସ୍ତ୍ର ଧୋଇ ଆପଣା ଆପଣାକୁ ଶୁଚି କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ତହିଁ ଉତ୍ତାରେ ସେମାନେ ଏକ ଗୋବତ୍ସ ଓ ତହିଁର ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଆଣନ୍ତୁ, ପୁଣି, ତୁମ୍ଭେ ଆଉ ଏକ ଗୋବତ୍ସ ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ନେବ। ");
INSERT INTO ory_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ତହୁଁ ତୁମ୍ଭେ ଲେବୀୟମାନଙ୍କୁ ସମାଗମ-ତମ୍ବୁ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରାଇବ; ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀକୁ ଏକତ୍ର କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ଆଉ ତୁମ୍ଭେ ଲେବୀୟମାନଙ୍କୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରାଇବ; ତହୁଁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଲେବୀୟମାନଙ୍କ ଉପରେ ଆପଣାମାନଙ୍କ ହସ୍ତ ରଖିବେ। ");
INSERT INTO ory_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ଆଉ ହାରୋଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପକ୍ଷରେ ଲେବୀୟମାନଙ୍କୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳନୀୟ ଉପହାର ରୂପେ ଉତ୍ସର୍ଗ କରିବ, ତହିଁରେ ସେମାନେ ସଦାପ୍ରଭୁଙ୍କର ସେବା କରି ପାରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ତହିଁ ଉତ୍ତାରେ ଲେବୀୟମାନେ ସେହି ଦୁଇ ଗୋବତ୍ସର ମସ୍ତକରେ ଆପଣାମାନଙ୍କ ହସ୍ତ ରଖିବେ; ତହୁଁ ତୁମ୍ଭେ ଲେବୀୟମାନଙ୍କ ପାଇଁ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଗୋଟିଏକୁ ପାପାର୍ଥକ ବଳି ରୂପେ ଓ ଅନ୍ୟଟିକୁ ହୋମାର୍ଥକ ବଳି ରୂପେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ପୁଣି, ତୁମ୍ଭେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣ ସମ୍ମୁଖରେ ଲେବୀୟମାନଙ୍କୁ ଉପସ୍ଥିତ କରାଇ ଦୋଳନୀୟ ନୈବେଦ୍ୟ ରୂପେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ଏହିରୂପେ ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ଲେବୀୟମାନଙ୍କୁ ପୃଥକ କରିବ; ତହିଁରେ ଲେବୀୟମାନେ ଆମ୍ଭର ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ତହିଁ ଉତ୍ତାରେ ଲେବୀୟମାନେ ସେବା କରିବା ନିମନ୍ତେ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କରିବେ; ପୁଣି, ତୁମ୍ଭେ ସେମାନଙ୍କୁ ଶୁଚି କରି ଦୋଳନୀୟ ନୈବେଦ୍ୟ ରୂପେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","କାରଣ ସେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଦତ୍ତ ଲୋକ; ଆମ୍ଭେ ଇସ୍ରାଏଲର ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ସମସ୍ତ ପ୍ରଥମଜାତ ଗର୍ଭଫଳ ବଦଳେ ସେମାନଙ୍କୁ ଆପଣା ନିମନ୍ତେ ଗ୍ରହଣ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ଯେହେତୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ମନୁଷ୍ୟ ଓ ପଶୁ, ଉଭୟର ସମସ୍ତ ପ୍ରଥମଜାତ ଆମ୍ଭର ମିସର ଦେଶର ସମସ୍ତ ପ୍ରଥମଜାତଙ୍କୁ ଆଘାତ କରିବା ଦିନ ଆମ୍ଭେ ସେମାନଙ୍କୁ ଆପଣା ନିମନ୍ତେ ପବିତ୍ର କଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ପ୍ରଥମଜାତ ବଦଳେ ଆମ୍ଭେ ଲେବୀୟମାନଙ୍କୁ ଗ୍ରହଣ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ଆଉ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପବିତ୍ର ସ୍ଥାନ ନିକଟକୁ ଆସିବା ସମୟରେ ଯେପରି ସେମାନଙ୍କ ମଧ୍ୟରେ ମହାମାରୀ ଉପସ୍ଥିତ ନ ହୁଏ, ଏଥିପାଇଁ ଆମ୍ଭେ ସମାଗମ-ତମ୍ବୁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ବଦଳେ ସେବା ଓ ସେମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ପାଇଁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ଲେବୀୟମାନଙ୍କୁ ଦାନ ରୂପେ ହାରୋଣ ଓ ତାହାର ପୁତ୍ରଗଣଙ୍କୁ ଦେଲୁ।” ");
INSERT INTO ory_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ଏହିରୂପେ ମୋଶା, ହାରୋଣ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ସମସ୍ତ ମଣ୍ଡଳୀ ଲେବୀୟମାନଙ୍କ ପ୍ରତି କଲେ; ସଦାପ୍ରଭୁ ଲେବୀୟମାନଙ୍କ ବିଷୟରେ ମୋଶାଙ୍କୁ ଯେଉଁ ସମସ୍ତ ଆଜ୍ଞା ଦେଇଥିଲେ, ତଦନୁସାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସେମାନଙ୍କ ପ୍ରତି କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ପୁଣି, ଲେବୀୟମାନେ ଆପଣା ଆପଣାକୁ ପାପରୁ ପରିଷ୍କାର କଲେ ଓ ଆପଣା ଆପଣା ବସ୍ତ୍ର ଧୌତ କଲେ; ତହୁଁ ହାରୋଣ ସେମାନଙ୍କୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଦୋଳନୀୟ ନୈବେଦ୍ୟ ରୂପେ ଉତ୍ସର୍ଗ କଲେ; ଆଉ ହାରୋଣ ସେମାନଙ୍କୁ ଶୁଚି କରିବା ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ତହିଁ ଉତ୍ତାରେ ଲେବୀୟମାନେ ହାରୋଣର ସମ୍ମୁଖରେ ଓ ତାହାର ପୁତ୍ରଗଣ ସମ୍ମୁଖରେ ଆପଣା ଆପଣା ସେବାକର୍ମ କରିବା ନିମନ୍ତେ ସମାଗମ-ତମ୍ବୁରେ ପ୍ରବେଶ କଲେ; ସଦାପ୍ରଭୁ ଲେବୀୟମାନଙ୍କ ବିଷୟରେ ମୋଶାଙ୍କୁ ଯେପରି ଆଜ୍ଞା ଦେଇଥିଲେ, ତଦନୁସାରେ ସେମାନଙ୍କ ପ୍ରତି କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ଲେବୀୟମାନଙ୍କ ବିଷୟରେ ଏହି ବ୍ୟବସ୍ଥା ପଚିଶ ବର୍ଷ ବୟସରୁ ଲେବୀୟମାନେ ସମାଗମ-ତମ୍ବୁରେ ସେବାକର୍ମ କରିବା ନିମନ୍ତେ ସେବକ ଶ୍ରେଣୀଭୁକ୍ତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ପୁଣି, ସେମାନେ ପଚାଶ ବର୍ଷ ବୟସ୍କ ହେଲେ, ସେବାକର୍ମରୁ ନିବୃତ୍ତ ହୋଇ ଆଉ ସେବା କରିବେ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ତଥାପି ସେମାନେ ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବାରେ ସମାଗମ-ତମ୍ବୁରେ ଆପଣା ଆପଣା ଭ୍ରାତା ସହିତ ସେବାକର୍ମ କରିବେ ଓ ଅନ୍ୟ ସେବା କରିବେ ନାହିଁ; ଲେବୀୟମାନଙ୍କ ରକ୍ଷଣୀୟ ବିଷୟରେ ତୁମ୍ଭେ ସେମାନଙ୍କ ପ୍ରତି ଏରୂପ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ଏଥିଉତ୍ତାରେ ଲୋକମାନେ ମିସର ଦେଶରୁ ବାହାର ହେଲା ଉତ୍ତାରେ ଦ୍ୱିତୀୟ ବର୍ଷର ପ୍ରଥମ ମାସରେ ସୀନୟ ପ୍ରାନ୍ତରରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ନିରୂପିତ ସମୟରେ ନିସ୍ତାର ପର୍ବ ପାଳନ କରନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ଏହି ମାସ ଚତୁର୍ଦ୍ଦଶ ଦିନର ସନ୍ଧ୍ୟାକାଳର ନିରୂପିତ ସମୟରେ ତୁମ୍ଭେମାନେ ତାହା ପାଳନ କରିବ; ତହିଁର ସମସ୍ତ ବିଧି ଓ ନିୟମ ଅନୁସାରେ ତାହା ପାଳନ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ତହୁଁ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ନିସ୍ତାର ପର୍ବ ପାଳନ କରିବା ପାଇଁ କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ତହିଁରେ ସେମାନେ ପ୍ରଥମ ମାସ ଚତୁର୍ଦ୍ଦଶ ଦିନର ସନ୍ଧ୍ୟା ସମୟରେ ସୀନୟ ପ୍ରାନ୍ତରରେ ନିସ୍ତାର ପର୍ବ ପାଳନ କଲେ; ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେପରି ଆଜ୍ଞା ଦେଇଥିଲେ, ତଦନୁସାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସବୁ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ମାତ୍ର କେତେକ ଲୋକ ମନୁଷ୍ୟର ଶବ ସ୍ପର୍ଶ କରି ଅଶୁଚି ହେବାରୁ ସେହି ଦିନ ସେମାନେ ନିସ୍ତାର ପର୍ବ ପାଳନ କରି ପାରିଲେ ନାହିଁ; ଏନିମନ୍ତେ ସେମାନେ ସେହି ଦିନ ମୋଶା ଓ ହାରୋଣଙ୍କ ନିକଟକୁ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ସେହି ଲୋକମାନେ ତାଙ୍କୁ କହିଲେ, “ଆମ୍ଭେମାନେ ମନୁଷ୍ୟର ଶବ ଦ୍ୱାରା ଅଶୁଚି ହୋଇଅଛୁ; ଏହେତୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ନିରୂପିତ ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉପହାର ଉତ୍ସର୍ଗ କରିବା ପାଇଁ କି କାରଣରୁ ଆମ୍ଭେମାନେ ନିବାରିତ ହେଉଅଛୁ?” ");
INSERT INTO ory_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ତେବେ ମୋଶା ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ରହିଥାଅ; ତୁମ୍ଭମାନଙ୍କ ବିଷୟରେ ସଦାପ୍ରଭୁ କି ଆଜ୍ଞା ଦେବେ, ତାହା ଶୁଣେ।” ");
INSERT INTO ory_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ‘ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ କିଅବା ତୁମ୍ଭମାନଙ୍କ ଭବିଷ୍ୟତ ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଯଦି କେହି ଶବ ଦ୍ୱାରା ଅଶୁଚି ହୁଏ, କିଅବା ଦୂର ସ୍ଥାନରେ ପଥିକ ହୁଏ, ତେବେ ହେଁ ସେ ସଦାପ୍ରଭୁଙ୍କ ନିସ୍ତାର ପର୍ବ ପାଳନ କରିବ;’ ");
INSERT INTO ory_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ଦ୍ୱିତୀୟ ମାସର ଚତୁର୍ଦ୍ଦଶ ଦିନ ସନ୍ଧ୍ୟା ସମୟରେ ସେମାନେ ତାହା ପାଳନ କରିବେ; ସେମାନେ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଓ ପିତା ଶାକ ସହିତ ତାହା ଭୋଜନ କରିବେ; ");
INSERT INTO ory_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ସେମାନେ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ତହିଁରୁ କିଛି ରଖିବେ ନାହିଁ କିଅବା ତହିଁର କୌଣସି ହାଡ଼ ଭାଙ୍ଗିବେ ନାହିଁ; ସେମାନେ ନିସ୍ତାର ପର୍ବର ସମସ୍ତ ବିଧି ଅନୁସାରେ ପାଳନ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ମାତ୍ର ଯେକେହି ଶୁଚି ଥାଇ ଓ ପଥିକ ନ ହୋଇ ନିସ୍ତାର ପର୍ବ ପାଳନ କରିବାରୁ କ୍ଷାନ୍ତ ହୁଏ, ସେହି ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ; ସେ ନିରୂପିତ ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉପହାର ଉତ୍ସର୍ଗ କଲା ନାହିଁ, ଏଥିପାଇଁ ସେହି ମନୁଷ୍ୟ ଆପଣା ପାପ ବୋହିବ; ");
INSERT INTO ory_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ଆଉ ଯଦି ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ କୌଣସି ବିଦେଶୀୟ ଲୋକ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ନିସ୍ତାର ପର୍ବ ପାଳନ କରିବାକୁ ଇଚ୍ଛା କରେ, ତେବେ ସେ ନିସ୍ତାର ପର୍ବର ବିଧି ଅନୁସାରେ ଓ ତହିଁର ନିୟମାନୁସାରେ ତାହା ପାଳନ କରିବ; ସ୍ୱଦେଶଜାତ କିମ୍ବା ବିଦେଶଜାତ, ଦୁହିଁଙ୍କ ପାଇଁ ତୁମ୍ଭମାନଙ୍କର ଏକ ବିଧି ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ଆଉ ଯେଉଁ ଦିନ ଆବାସ ସ୍ଥାପିତ ହେଲା, ସେହି ଦିନ ମେଘ ଆବାସକୁ, ଅର୍ଥାତ୍‍, ସାକ୍ଷ୍ୟ-ତମ୍ବୁକୁ ଆଚ୍ଛାଦନ କଲା; ପୁଣି, ତାହା ସନ୍ଧ୍ୟା ସମୟରୁ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ଆବାସ ଉପରେ ଅଗ୍ନି ତୁଲ୍ୟ ଦେଖାଗଲା ");
INSERT INTO ory_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ଏହିରୂପେ ସର୍ବଦା ହେଲା; ମେଘ ଆବାସକୁ ଆଚ୍ଛାଦନ କଲା, ପୁଣି, ରାତ୍ରିରେ ଅଗ୍ନି ତୁଲ୍ୟ ଦେଖାଗଲା। ");
INSERT INTO ory_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ଆଉ ଯେକୌଣସି ସମୟରେ ତମ୍ବୁ ଉପରୁ ସେହି ମେଘ ଉପରକୁ ନିଆଗଲା, ସେତେବେଳେ ଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯାତ୍ରା କଲେ; ପୁଣି, ସେହି ମେଘ ଯେଉଁଠାରେ ରହିଲା, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସେହିଠାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯାତ୍ରା କଲେ ଓ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ; ଯେପର୍ଯ୍ୟନ୍ତ ସେହି ମେଘ ଆବାସ ଉପରେ ରହିଲା, ସେପର୍ଯ୍ୟନ୍ତ ସେମାନେ ଛାଉଣି ସ୍ଥାପନ କରି ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ପୁଣି, ଯେତେବେଳେ ସେହି ମେଘ ଆବାସ ଉପରେ ବହୁ ଦିନ ବିଳମ୍ବ କରି ରହିଲା, ସେତେବେଳେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସଦାପ୍ରଭୁଙ୍କ ରକ୍ଷଣୀୟ ରକ୍ଷା କଲେ ଓ ଯାତ୍ରା କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ପୁଣି, କେବେ କେବେ ସେହି ମେଘ ଆବାସ ଉପରେ ଅଳ୍ପ ଦିନ ରହିଲା, ସେହି ସମୟରେ ମଧ୍ୟ ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଛାଉଣି କରି ରହିଲେ ଓ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ଆଉ କେବେ କେବେ ମେଘ ସନ୍ଧ୍ୟାଠାରୁ ପ୍ରଭାତ ପର୍ଯ୍ୟନ୍ତ ରହିଲା ଓ ପ୍ରଭାତରେ ମେଘ ଉପରକୁ ନିଆଯାʼନ୍ତେ, ସେମାନେ ଯାତ୍ରା କଲେ; ଅବା ଯଦି ତାହା ଦିବାରାତ୍ର ରହିଲା, ତେବେ ମେଘ ଉପରକୁ ନିଆଯାʼନ୍ତେ, ସେମାନେ ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ଦୁଇ ଦିନ କିମ୍ବା ଏକ ମାସ କିମ୍ବା ଏକ ବର୍ଷ ହେଉ, ଆବାସ ଉପରେ ମେଘ ଯେତେକାଳ ବିଳମ୍ବ କରି ଅବସ୍ଥିତି କଲା, ସେତେକାଳ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯାତ୍ରା ନ କରି ଛାଉଣିରେ ରହିଲେ; ମାତ୍ର ତାହା ନିଆଯାʼନ୍ତେ, ସେମାନେ ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ ଓ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାରେ ଯାତ୍ରା କଲେ; ସେମାନେ ମୋଶାଙ୍କ ଦ୍ୱାରା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସଦାପ୍ରଭୁଙ୍କ ରକ୍ଷଣୀୟ ରକ୍ଷା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ତୁମ୍ଭେ ରୂପାର ଦୁଇ ତୂରୀ ନିର୍ମାଣ କର; ତୁମ୍ଭେ ପିଟାକର୍ମରେ ତାହା ନିର୍ମାଣ କରିବ; ଆଉ ତୁମ୍ଭେ ମଣ୍ଡଳୀକୁ ଆହ୍ୱାନ କରିବା ସମୟରେ ଓ ଛାଉଣିସମୂହ ପ୍ରସ୍ଥାନ କରିବା ସମୟରେ ତାହା ବ୍ୟବହାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ପୁଣି, ସେମାନେ ସେହି ଦୁଇ ତୂରୀ ବଜାନ୍ତେ, ସମସ୍ତ ମଣ୍ଡଳୀ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରରେ ତୁମ୍ଭ ନିକଟରେ ଏକତ୍ରିତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ଆଉ ଯଦି ସେମାନେ ଏକ ତୂରୀ ବଜାଇବେ, ତେବେ ଅଧିପତିମାନେ, ଅର୍ଥାତ୍‍, ଇସ୍ରାଏଲର ସହସ୍ରପତିମାନେ, ତୁମ୍ଭ ନିକଟରେ ଏକତ୍ରିତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ପୁଣି, ତୁମ୍ଭେମାନେ ରଣତୂରୀ ବଜାନ୍ତେ, ପୂର୍ବଦିଗସ୍ଥିତ ଛାଉଣିର ଲୋକମାନେ ଯାତ୍ରା କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ପୁଣି, ତୁମ୍ଭେମାନେ ଦ୍ୱିତୀୟ ଥର ରଣତୂରୀ ବଜାନ୍ତେ, ଦକ୍ଷିଣ ଦିଗସ୍ଥିତ ଛାଉଣିର ଲୋକମାନେ ଯାତ୍ରା କରିବେ; ଏହି କ୍ରମରେ ସେମାନେ ଆପଣାମାନଙ୍କ ଯାତ୍ରା ନିମନ୍ତେ ରଣତୂରୀ ବଜାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ସମାଜକୁ ଏକତ୍ର କରିବା ସମୟରେ ତୁମ୍ଭେମାନେ ତୂରୀ ବଜାଇବ, ମାତ୍ର ରଣତୂରୀ ବଜାଇବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ଆଉ ହାରୋଣର ପୁତ୍ର ଯାଜକମାନେ ସେହି ଦୁଇ ତୂରୀ ବଜାଇବେ; ପୁଣି, ତାହା ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଅନନ୍ତକାଳୀନ ବିଧି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ଆଉ ଯେଉଁ ସମୟରେ ତୁମ୍ଭେମାନେ ଆପଣା ଦେଶରେ କ୍ଳେଶଦାୟୀ ବିପକ୍ଷଗଣର ବିରୁଦ୍ଧରେ ଯୁଦ୍ଧ କରିବାକୁ ଯିବ, ସେହି ସମୟରେ ତୁମ୍ଭେମାନେ ଏହି ତୂରୀରେ ରଣବାଦ୍ୟ ବଜାଇବ; ତହିଁରେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ସାକ୍ଷାତରେ ତୁମ୍ଭେମାନେ ସ୍ମରଣ କରାଯିବ ଓ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଶତ୍ରୁଗଣଠାରୁ ରକ୍ଷା ପାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ଆହୁରି ତୁମ୍ଭମାନଙ୍କ ଆନନ୍ଦ ଦିନରେ, ତୁମ୍ଭମାନଙ୍କ ନିରୂପିତ ପର୍ବରେ ଓ ତୁମ୍ଭମାନଙ୍କ ମାସର ଆରମ୍ଭରେ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ହୋମବଳି ଓ ମଙ୍ଗଳାର୍ଥକ ବଳି ଉପରେ ଏହି ତୂରୀ ବଜାଇବ; ତହିଁରେ ତାହା ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ସମ୍ମୁଖରେ ତୁମ୍ଭମାନଙ୍କର ସ୍ମରଣାର୍ଥେ ହେବ; ଆମ୍ଭେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ଆଉ ଦ୍ୱିତୀୟ ବର୍ଷର ଦ୍ୱିତୀୟ ମାସର କୋଡ଼ିଏ ଦିନରେ ସେହି ମେଘ ସାକ୍ଷ୍ୟରୂପ ଆବାସ ଉପରୁ ନିଆଗଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯାତ୍ରା କରିବାର ନିୟମାନୁସାରେ ସୀନୟ ପ୍ରାନ୍ତରରୁ ଅଗ୍ରସର ହେଲେ; ପୁଣି, ସେହି ମେଘ ପାରଣ ପ୍ରାନ୍ତରରେ ଅବସ୍ଥିତି କଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ଆଉ ମୋଶାଙ୍କ ଦ୍ୱାରା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସେମାନେ ପ୍ରଥମ ଥର ଯାତ୍ରା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ପ୍ରଥମରେ ଯିହୁଦା-ସନ୍ତାନଗଣର ଛାଉଣିର ଧ୍ୱଜା ସେମାନଙ୍କ ସୈନ୍ୟାନୁସାରେ ଚଳିଲା; ପୁଣି, ଅମ୍ମୀନାଦବର ପୁତ୍ର ନହଶୋନ ସେମାନଙ୍କ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ଆଉ ସୂୟାରର ପୁତ୍ର ନଥନେଲ, ଇଷାଖର-ସନ୍ତାନଗଣର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ଆଉ ହେଲୋନର ପୁତ୍ର ଇଲୀୟାବ୍‍, ସବୂଲୂନ-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ଏଉତ୍ତାରେ ଆବାସ ଭଙ୍ଗାଯାʼନ୍ତେ, ଗେର୍ଶୋନର ସନ୍ତାନଗଣ ଓ ମରାରିର ସନ୍ତାନଗଣ ସେହି ଆବାସ ବୋହି ଅଗ୍ରସର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ତହୁଁ ରୁବେନ୍‍-ଛାଉଣିର ଧ୍ୱଜା ସେମାନଙ୍କ ସୈନ୍ୟାନୁସାରେ ଚଳିଲା; ପୁଣି, ଶଦେୟରର ପୁତ୍ର ଇଲୀଷୂର ସେମାନଙ୍କ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ଆଉ ସୂରୀଶଦ୍ଦୟର ପୁତ୍ର ଶଲୁମୀୟେଲ ଶିମୀୟୋନ-ସନ୍ତାନଗଣର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ଆଉ ଦ୍ୟୂୟେଲର ପୁତ୍ର ଇଲୀୟାସଫ୍‍ ଗାଦ୍‍-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ତହିଁ ଉତ୍ତାରେ କହାତୀୟମାନେ ପବିତ୍ର ସ୍ଥାନର ଭାର ବୋହି ଅଗ୍ରସର ହେଲେ; ପୁଣି, ସେମାନେ ପହଞ୍ଚିବା ପୂର୍ବରୁ ଅନ୍ୟମାନେ ଆବାସ ସ୍ଥାପନ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ଆଉ ଇଫ୍ରୟିମ-ସନ୍ତାନଗଣର ଛାଉଣିର ଧ୍ୱଜା ସେମାନଙ୍କ ସୈନ୍ୟାନୁସାରେ ଚଳିଲା ଓ ଅମ୍ମୀହୂଦର ପୁତ୍ର ଇଲୀଶାମା ସେମାନଙ୍କ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ଆଉ ପଦାହସୂରର ପୁତ୍ର ଗମଲୀୟେଲ ମନଃଶି ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ପୁଣି, ଗିଦିୟୋନିର ପୁତ୍ର ଅବୀଦାନ୍‍ ବିନ୍ୟାମୀନ୍-ସନ୍ତାନଗଣର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ତହୁଁ ସମସ୍ତ ଛାଉଣିର ପଶ୍ଚାତ୍‍ ଦାନ୍-ସନ୍ତାନଗଣଙ୍କର ଛାଉଣିର ଧ୍ୱଜା ସେମାନଙ୍କ ସୈନ୍ୟାନୁସାରେ ଚଳିଲା ଓ ଅମ୍ମୀଶଦ୍ଦୟର ପୁତ୍ର ଅହୀୟେଷର ସେମାନଙ୍କ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ଆଉ ଅକ୍ରଣର ପୁତ୍ର ପଗୀୟେଲ ଆଶେର-ସନ୍ତାନଗଣର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ପୁଣି, ଐନନର ପୁତ୍ର ଅହୀର ନପ୍ତାଲି-ସନ୍ତାନଗଣର ବଂଶୀୟ ସୈନ୍ୟ ଉପରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ଏହିରୂପେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ଯାତ୍ରା ସେମାନଙ୍କ ସୈନ୍ୟାନୁସାରେ ହେଲା ଓ ସେମାନେ ଅଗ୍ରସର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ଏଥିଉତ୍ତାରେ ମୋଶା ଆପଣା ଶ୍ୱଶୁର ମିଦୀୟନୀୟ ରୁୟେଲର ପୁତ୍ର ହୋବବ୍‍କୁ କହିଲେ, “ସଦାପ୍ରଭୁ ଯେଉଁ ସ୍ଥାନ ବିଷୟରେ କହିଅଛନ୍ତି, ‘ଆମ୍ଭେ ତାହା ତୁମ୍ଭମାନଙ୍କୁ ଦେବା,’ ସେହି ସ୍ଥାନକୁ ଆମ୍ଭେମାନେ ଯାତ୍ରା କରୁଅଛୁ; ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଆସ, ତହିଁରେ ଆମ୍ଭେମାନେ ତୁମ୍ଭର ମଙ୍ଗଳ କରିବା; କାରଣ ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲ ବିଷୟରେ ମଙ୍ଗଳ କଥା କହିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ତହୁଁ ସେ କହିଲା, “ମୁଁ ଯିବି ନାହିଁ; ମାତ୍ର ମୁଁ ଆପଣା ନିଜ ଦେଶକୁ ଓ ଆପଣା ଜ୍ଞାତିମାନଙ୍କ ନିକଟକୁ ପ୍ରସ୍ଥାନ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ତେବେ ମୋଶା କହିଲେ, “ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ, ଆମ୍ଭମାନଙ୍କୁ ଛାଡ଼ି ଯାଅ ନାହିଁ; କାରଣ ପ୍ରାନ୍ତର ମଧ୍ୟରେ କିପ୍ରକାରେ ଆମ୍ଭମାନଙ୍କର ଛାଉଣି ସ୍ଥାପନ କରିବାକୁ ହେବ, ତାହା ତୁମ୍ଭେ ଜାଣ, ଏହେତୁ ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ଚକ୍ଷୁର ବଦଳେ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ଆଉ ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗେ ଗଲେ ଏହା ହେବ, ନିଶ୍ଚୟ ଏହା ହେବ ଯେ, ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପ୍ରତି ଯେକୌଣସି ମଙ୍ଗଳ କରିବେ, ତାହା ଆମ୍ଭେମାନେ ତୁମ୍ଭ ପ୍ରତି କରିବୁ।” ");
INSERT INTO ory_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ଏଉତ୍ତାରେ ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ପର୍ବତରୁ ତିନି ଦିନର ପଥ ଗଲେ, ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ନିୟମ-ସିନ୍ଦୁକ ସେମାନଙ୍କ ନିମନ୍ତେ ବିଶ୍ରାମ-ସ୍ଥାନ ଅନ୍ୱେଷଣ କରିବା ପାଇଁ ସେମାନଙ୍କ ଆଗରେ ତିନି ଦିନର ପଥ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ପୁଣି, ସେମାନେ ଛାଉଣିରୁ ଯାତ୍ରା କରିବା ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ମେଘ ଦିବସରେ ସେମାନଙ୍କ ଉପରେ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ପୁଣି, ସିନ୍ଦୁକ ଅଗ୍ରସର ହେବା ସମୟରେ ମୋଶା କହନ୍ତି, “ସଦାପ୍ରଭୋ, ଉଠ, ପୁଣି, ତୁମ୍ଭର ଶତ୍ରୁମାନେ ଛିନ୍ନଭିନ୍ନ ହେଉନ୍ତୁ ଓ ଯେଉଁମାନେ ତୁମ୍ଭକୁ ଘୃଣା କରନ୍ତି, ସେମାନେ ତୁମ୍ଭ ସମ୍ମୁଖରୁ ପଳାୟନ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ଆଉ ତାହା ବିଶ୍ରାମ କରିବା ସମୟରେ ସେ କହନ୍ତି, “ସଦାପ୍ରଭୋ, ତୁମ୍ଭେ ଇସ୍ରାଏଲର ଅୟୁତ ଅୟୁତ ସହସ୍ର ପ୍ରତି ଫେର।” ");
INSERT INTO ory_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ଏଥିଉତ୍ତାରେ ଲୋକମାନେ ସଦାପ୍ରଭୁଙ୍କ କର୍ଣ୍ଣଗୋଚରରେ ମନ୍ଦ କଥା କହି ବଚସାକାରୀ ଲୋକମାନଙ୍କ ତୁଲ୍ୟ ହେଲେ; ପୁଣି, ସଦାପ୍ରଭୁ ତାହା ଶୁଣନ୍ତେ, ତାହାଙ୍କର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା; ତହିଁରେ ସଦାପ୍ରଭୁଙ୍କର ଅଗ୍ନି ସେମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରଜ୍ୱଳିତ ହୋଇ ଛାଉଣିର ପ୍ରାନ୍ତଭାଗ ଗ୍ରାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ଏନିମନ୍ତେ ଲୋକମାନେ ମୋଶାଙ୍କ ନିକଟରେ କ୍ରନ୍ଦନ କଲେ; ତହୁଁ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କରନ୍ତେ, ସେହି ଅଗ୍ନି ଲିଭିଗଲା। ");
INSERT INTO ory_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ତେଣୁ ସେହି ସ୍ଥାନର ନାମ ତବୀୟେରା ହେଲା, କାରଣ ସଦାପ୍ରଭୁଙ୍କ ଅଗ୍ନି ସେମାନଙ୍କ ମଧ୍ୟରେ ଦହନ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ଏଥିଉତ୍ତାରେ ସେମାନଙ୍କ ମଧ୍ୟବର୍ତ୍ତୀ ମିଶ୍ରିତ ଲୋକମାନଙ୍କର ଜନତା ଲୋଭାକ୍ରାନ୍ତ ହେବାକୁ ଲାଗିଲେ; ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟ ପୁନର୍ବାର ରୋଦନ କରି କହିଲେ, “କିଏ ଆମ୍ଭମାନଙ୍କୁ ମାଂସ ଖାଇବାକୁ ଦେବ? ");
INSERT INTO ory_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ଆମ୍ଭେମାନେ ମିସର ଦେଶରେ ବିନାମୂଲ୍ୟରେ ଯେଉଁ ମାଛ ଖାଉଥିଲୁ, ତାହା ମନରେ ପଡ଼େ; ସେ କାକୁଡ଼ି, ସେ ଖରଭୁଜ, ସେ ପରୁ, ସେ ପିଆଜ ଓ ରସୁଣ (ମନରେ ପଡ଼େ); ");
INSERT INTO ory_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ମାତ୍ର ଏବେ ଆମ୍ଭମାନଙ୍କର ପ୍ରାଣ ଶୁଷ୍କ ହେଉଅଛି; ଏଠି କିଛି ନାହିଁ; ଏହି ମାନ୍ନା ବ୍ୟତୀତ ଆଉ ଦେଖିବାକୁ କିଛି ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ଆଉ ସେହି ମାନ୍ନା ଧନିଆ ପରି ଓ ତହିଁର ଦୃଶ୍ୟ ମୁକ୍ତା ସଦୃଶ। ");
INSERT INTO ory_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ଲୋକମାନେ ଏଣେତେଣେ ଭ୍ରମଣ କରି ତାହା ସାଉଣ୍ଟିଲେ ଓ ଚକିରେ ତାହା ପେଷିଲେ, ଅବା କୁଟଣୀରେ ତାହା ଚୂର୍ଣ୍ଣ କରି କହ୍ରାଇରେ ସିଝେଇ କରି ପିଠା ପ୍ରସ୍ତୁତ କଲେ; ଆଉ ତୈଳପକ୍ୱ ପିଠା ପରି ତହିଁର ସ୍ୱାଦ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ରାତ୍ରିରେ ଛାଉଣି ଉପରେ କାକର ପଡ଼ିଲା ସମୟରେ ସେହି ମାନ୍ନା ତହିଁ ସଙ୍ଗରେ ପଡ଼ିଲା। ");
INSERT INTO ory_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ଏଉତ୍ତାରେ ଲୋକମାନେ ସମୁଦାୟ ପରିବାର ସହିତ, ପ୍ରତ୍ୟେକ ଲୋକ ଆପଣା ତମ୍ବୁଦ୍ୱାର ନିକଟରେ ରୋଦନ କରିବାର ମୋଶା ଶୁଣିଲେ; ତହିଁରେ ସଦାପ୍ରଭୁଙ୍କର କ୍ରୋଧ ଅତିଶୟ ପ୍ରଜ୍ୱଳିତ ହେଲା; ପୁଣି, ମୋଶା ମଧ୍ୟ ଅସନ୍ତୁଷ୍ଟ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ତହୁଁ ମୋଶା ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ କାହିଁକି ଆପଣା ଦାସ ପ୍ରତି ଅନିଷ୍ଟ ବ୍ୟବହାର କରିଅଛ? ଓ କାହିଁକି ମୁଁ ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇ ନାହିଁ, ଯେ ତୁମ୍ଭେ ମୋʼ ଉପରେ ଏହି ସମସ୍ତ ଲୋକଙ୍କ ଭାର ଦେଉଅଛ? ");
INSERT INTO ory_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ମୁଁ କʼଣ ଏହି ସମସ୍ତ ଲୋକଙ୍କୁ ଗର୍ଭରେ ଧାରଣ କରିଅଛି? ମୁଁ କʼଣ ସେମାନଙ୍କୁ ଜନ୍ମ କରିଅଛି ଯେ, ତୁମ୍ଭେ ସେମାନଙ୍କ ପୂର୍ବପୁରୁଷମାନଙ୍କ ନିକଟରେ ଯେଉଁ ଦେଶ ବିଷୟରେ ଶପଥ କରିଥିଲ, ‘ସେହି ଦେଶ ପର୍ଯ୍ୟନ୍ତ ଦୁଗ୍ଧପୋଷ୍ୟ ଶିଶୁ-ପାଳନକାରୀ ପିତା ତୁଲ୍ୟ ସେମାନଙ୍କୁ କୋଳରେ ବହି ଘେନିଯିବା ପାଇଁ ମୋତେ କହୁଅଛ?’ ");
INSERT INTO ory_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ମୁଁ ଏହି ସମସ୍ତ ଲୋକଙ୍କୁ ଦେବା ପାଇଁ ମାଂସ କେଉଁଠାରୁ ପାଇବି? କାରଣ ସେମାନେ ମୋʼ ନିକଟରେ କାନ୍ଦି କହୁଅଛନ୍ତି, ‘ଆମ୍ଭମାନଙ୍କୁ ମାଂସ ଦିଅ,’ ଆମ୍ଭେମାନେ ଖାଇବା। ");
INSERT INTO ory_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ମୁଁ ଏକାକୀ ଏତେ ଲୋକଙ୍କର ଭାର ବହି ନ ପାରେ, କାରଣ ଏହା ମୋʼ ପାଇଁ ଅସହ୍ୟ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ଆଉ ଯଦି ତୁମ୍ଭେ ମୋʼ ପ୍ରତି ଏପରି ବ୍ୟବହାର କର, ତେବେ ବିନୟ କରୁଅଛି, ମୁଁ ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହପାତ୍ର ହୋଇଥିଲେ, ସେହିକ୍ଷଣି ମୋତେ ମାରି ପକାଅ; ପୁଣି, ମୋତେ ଆପଣା ଦୁର୍ଗତି ଦେଖିବାକୁ ଦିଅ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ସେତେବେଳେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଯେଉଁମାନଙ୍କୁ ଲୋକମାନଙ୍କର ପ୍ରାଚୀନ ଓ ଅଧିପତି ବୋଲି ଜାଣୁଅଛ, ଇସ୍ରାଏଲର ଏପରି ସତୁରି ଜଣ ପ୍ରାଚୀନ ଲୋକଙ୍କୁ ଆମ୍ଭ ନିକଟରେ ଏକତ୍ର କର; ପୁଣି, ସେମାନଙ୍କୁ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାର ନିକଟକୁ ଆଣ, ସେମାନେ ତୁମ୍ଭ ସଙ୍ଗେ ସେଠାରେ ଠିଆ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ତହିଁରେ ଆମ୍ଭେ ସେହି ସ୍ଥାନକୁ ଓହ୍ଲାଇ ଆସି ତୁମ୍ଭ ସଙ୍ଗେ କଥା କହିବା ଓ ତୁମ୍ଭଠାରେ ଯେଉଁ ଆତ୍ମା ଅଛି, ତହିଁରୁ ନେଇ ସେମାନଙ୍କୁ ଦେବା; ତହିଁରେ ତୁମ୍ଭେ ଯେପରି ଏକାକୀ ଲୋକମାନଙ୍କର ଭାର ନ ବହିବ, ଏଥିପାଇଁ ସେମାନେ ତୁମ୍ଭ ସହିତ ଲୋକମାନଙ୍କର ଭାର ବହିବେ। ");
INSERT INTO ory_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ପୁଣି, ତୁମ୍ଭେ ଲୋକମାନଙ୍କୁ କୁହ, ‘ତୁମ୍ଭେମାନେ କାଲି ପାଇଁ ଆପଣା ଆପଣାକୁ ପବିତ୍ର କର, ଆଉ ତୁମ୍ଭେମାନେ ମାଂସ ଖାଇବ; କାରଣ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ କର୍ଣ୍ଣଗୋଚରରେ କ୍ରନ୍ଦନ କରି କହିଅଛ, କିଏ ଆମ୍ଭମାନଙ୍କୁ ମାଂସ ଖାଇବାକୁ ଦେବ? ବରଞ୍ଚ ମିସର ଦେଶରେ ଆମ୍ଭମାନଙ୍କର ମଙ୍ଗଳ ଥିଲା; ଏନିମନ୍ତେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କୁ ମାଂସ ଦେବେ, ତୁମ୍ଭେମାନେ ତାହା ଖାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ତୁମ୍ଭେମାନେ ଦିନେ କିମ୍ବା ଦୁଇ ଦିନ କିମ୍ବା ପାଞ୍ଚ ଦିନ କିମ୍ବା ଦଶ ଦିନ କିମ୍ବା କୋଡ଼ିଏ ଦିନ ଖାଇବ, ତାହା ନୁହେଁ; ");
INSERT INTO ory_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ମାତ୍ର ସମ୍ପୂର୍ଣ୍ଣ ଏକ ମାସ, ଯେପର୍ଯ୍ୟନ୍ତ ତାହା ତୁମ୍ଭମାନଙ୍କ ନାସିକାରୁ ନିର୍ଗତ ଓ ତୁମ୍ଭମାନଙ୍କର ଘୃଣାଯୋଗ୍ୟ ନ ହୁଏ, ସେପର୍ଯ୍ୟନ୍ତ ଖାଇବ; କାରଣ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ମଧ୍ୟବର୍ତ୍ତୀ ସଦାପ୍ରଭୁଙ୍କୁ ଅଗ୍ରାହ୍ୟ କରି ତାହାଙ୍କ ସମ୍ମୁଖରେ କ୍ରନ୍ଦନ କରି କହିଅଛ, ଆମ୍ଭେମାନେ କାହିଁକି ମିସରରୁ ବାହାରି ଆସିଲୁ।’” ");
INSERT INTO ory_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ତେବେ ମୋଶା କହିଲେ, “ମୁଁ ଯେଉଁ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଅଛି, ସେମାନେ ଛଅ ଲକ୍ଷ ପଦାତିକ; ତଥାପି ତୁମ୍ଭେ କହୁଅଛ, ‘ଆମ୍ଭେ ସେମାନଙ୍କୁ ମାଂସ ଦେବା, ସେମାନେ ତାହା ସମ୍ପୂର୍ଣ୍ଣ ଏକ ମାସ ଖାଇବେ।’ ");
INSERT INTO ory_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ସେମାନଙ୍କୁ ଅଣ୍ଟିବା ଭଳି କʼଣ ପଲ ପଲ ଗୋମେଷ ବଧ କରାଯିବ? ଅବା ସେମାନଙ୍କୁ ଅଣ୍ଟିବା ଭଳି ସମୁଦ୍ରର ସବୁ ମାଛ କʼଣ ଏକତ୍ର କରାଯିବ?” ");
INSERT INTO ory_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ସଦାପ୍ରଭୁଙ୍କର ହସ୍ତ କି ସଙ୍କୁଚିତ ହୋଇଅଛି? ତୁମ୍ଭ ପ୍ରତି ଆମ୍ଭର ବାକ୍ୟ ସଫଳ ହେବ କି ନାହିଁ, ତୁମ୍ଭେ ଏବେ ତାହା ଦେଖିବ।” ");
INSERT INTO ory_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ଏଥିରେ ମୋଶା ବାହାରକୁ ଯାଇ ଲୋକମାନଙ୍କୁ ସଦାପ୍ରଭୁଙ୍କର କଥା କହିଲେ, ପୁଣି, ସେ ଲୋକମାନଙ୍କର ପ୍ରାଚୀନବର୍ଗ ମଧ୍ୟରୁ ସତୁରି ଜଣଙ୍କୁ ଏକତ୍ର କରି ତମ୍ବୁର ଚତୁର୍ଦ୍ଦିଗରେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ତହିଁରେ ସଦାପ୍ରଭୁ ମେଘରେ ଓହ୍ଲାଇ ତାଙ୍କ ସହିତ କଥା କହିଲେ, ଆଉ ଯେଉଁ ଆତ୍ମା ତାଙ୍କଠାରେ ଥିଲା, ତହିଁରୁ ନେଇ ସତୁରି ପ୍ରାଚୀନଙ୍କୁ ଦେଲେ; ପୁଣି, ସେହି ଆତ୍ମା ସେମାନଙ୍କ ଉପରେ ଅବସ୍ଥାନ କରନ୍ତେ, ସେମାନେ ଭବିଷ୍ୟତ କଥା ପ୍ରଚାର କଲେ, ମାତ୍ର ତହିଁ ଉତ୍ତାରେ ଆଉ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ମାତ୍ର ଛାଉଣି ମଧ୍ୟରେ ଦୁଇ ଜଣ ଅବଶିଷ୍ଟ ରହିଲେ, ଜଣକର ନାମ ଇଲଦଦ୍‍ ଓ ଅନ୍ୟର ନାମ ମେଦଦ୍‍; ସେମାନଙ୍କ ଉପରେ ସେହି ଆତ୍ମା ଅବସ୍ଥିତି କଲା; ସେମାନେ ସେହି ଲିଖିତ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଥିଲେ, ମାତ୍ର ବାହାର ହୋଇ ତମ୍ବୁ ନିକଟକୁ ଯାଇ ନ ଥିଲେ; ସେମାନେ ଛାଉଣି ମଧ୍ୟରେ ଥାଇ ଭବିଷ୍ୟତ କଥା ପ୍ରଚାର କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ତହୁଁ ଜଣେ ଯୁବା ଦୌଡ଼ିଯାଇ ମୋଶାଙ୍କୁ କହିଲା, “ଇଲଦଦ୍‍ ଓ ମେଦଦ୍‍ ଛାଉଣି ମଧ୍ୟରେ ଭବିଷ୍ୟତ କଥା ପ୍ରଚାର କରୁଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ତହିଁରେ (ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ ନାମକ) ମୋଶାଙ୍କର ଜଣେ ମନୋନୀତ ପରିଚାରକ ମୋଶାଙ୍କୁ କହିଲେ, “ହେ ମୋହର ପ୍ରଭୁ ମୋଶା, ସେମାନଙ୍କୁ ନିଷେଧ କରନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ତେବେ ମୋଶା କହିଲେ, “ତୁମ୍ଭେ ମୋʼ ସକାଶୁ କʼଣ ଈର୍ଷା କରୁଅଛ? ପରମେଶ୍ୱର କରନ୍ତୁ, ସଦାପ୍ରଭୁଙ୍କର ସମସ୍ତ ଲୋକ ଭବିଷ୍ୟଦ୍‍ବକ୍ତା ହୁଅନ୍ତୁ ଓ ସଦାପ୍ରଭୁ ସେମାନଙ୍କ ଉପରେ ଆପଣା ଆତ୍ମା ଦିଅନ୍ତୁ!” ");
INSERT INTO ory_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ଏଉତ୍ତାରେ ମୋଶା ଓ ଇସ୍ରାଏଲର ପ୍ରାଚୀନଗଣ ଛାଉଣିକୁ ଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରୁ ବାୟୁ ବହିଲା ଓ ତାହା ସମୁଦ୍ରରୁ ଭାଟୋଇ ପକ୍ଷୀ ଆଣିଲା, ପୁଣି, ଛାଉଣିର ଚତୁର୍ଦ୍ଦିଗରେ ଏପାଖେ ଦିନକର ପଥ ଓ ସେପାଖେ ଦିନକର ପଥ ପର୍ଯ୍ୟନ୍ତ ସେମାନଙ୍କୁ ଭୂମିଠାରୁ ପ୍ରାୟ ଦୁଇ ହସ୍ତ ଊର୍ଦ୍ଧ୍ୱରେ ପକାଇଲା। ");
INSERT INTO ory_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ତହିଁରେ ଲୋକମାନେ ଛିଡ଼ା ହୋଇ ସେହି ସମସ୍ତ ଦିବାରାତ୍ର ଓ ପରଦିନ ସମସ୍ତ ଦିବସ ସେହି ଭାଟୋଇ ପକ୍ଷୀ ସଂଗ୍ରହ କଲେ; କେହି ଦଶ ହୋମରରୁ ଊଣା ସଂଗ୍ରହ କଲା ନାହିଁ; ଆଉ ସେମାନେ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଛାଉଣିର ଚାରିଆଡ଼େ ତାହା ବିଛାଇ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ମାତ୍ର ସେମାନଙ୍କ ଦନ୍ତ ମଧ୍ୟରେ ମାଂସ ଥାଉ ଥାଉ, ଚୋବାଇଲା ପୂର୍ବେ, ଲୋକମାନଙ୍କ ବିରୁଦ୍ଧରେ ସଦାପ୍ରଭୁଙ୍କ କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା, ତହିଁରେ ସଦାପ୍ରଭୁ ଲୋକମାନଙ୍କୁ ଅତି ମହାମାରୀରେ ସଂହାର କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ତହିଁରେ ସେହି ସ୍ଥାନର ନାମ କିବ୍ରୋତ୍‍-ହତ୍ତାବା ହେଲା; ଯେହେତୁ ସେମାନେ ସେହି ସ୍ଥାନରେ ଲୋକମାନଙ୍କୁ କବର ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ଲୋକମାନେ କିବ୍ରୋତ୍‍-ହତ୍ତାବାଠାରୁ ହତ୍ସେରୋତକୁ ଯାତ୍ରା କରି ସେହିଠାରେ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ମୋଶା ଏକ କୂଶୀୟା ସ୍ତ୍ରୀକୁ ବିବାହ କରିଥିଲେ, ଏଣୁ ମରୀୟମ ଓ ହାରୋଣ ସେହି କୂଶୀୟା ସ୍ତ୍ରୀ ସକାଶୁ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ କଥା କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ସେମାନେ କହିଲେ, “ସଦାପ୍ରଭୁ କି କେବଳ ମୋଶାଙ୍କ ସହିତ କଥା କହିଅଛନ୍ତି? ସେ କି ଆମ୍ଭମାନଙ୍କ ସହିତ ମଧ୍ୟ କଥା କହି ନାହାନ୍ତି?” ମାତ୍ର ଏ କଥା ସଦାପ୍ରଭୁ ଶୁଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ମୋଶା ପୃଥିବୀସ୍ଥ ସମସ୍ତ ଲୋକଙ୍କଠାରୁ ଅତି ନମ୍ର ଲୋକ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଅକସ୍ମାତ୍‍ ମୋଶାଙ୍କୁ ଓ ହାରୋଣଙ୍କୁ ଓ ମରୀୟମକୁ କହିଲେ, “ତୁମ୍ଭେ ତିନି ଜଣ ବାହାର ହୋଇ ସମାଗମ-ତମ୍ବୁ ନିକଟକୁ ଆସ” ତହିଁରେ ସେ ତିନି ଜଣ ବାହାର ହୋଇ ଆସିଲେ; ");
INSERT INTO ory_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ସେତେବେଳେ ସଦାପ୍ରଭୁ ମେଘ ସ୍ତମ୍ଭରେ ଓହ୍ଲାଇ ତମ୍ବୁ ଦ୍ୱାରରେ ଛିଡ଼ା ହୋଇ ହାରୋଣ ଓ ମରୀୟମଙ୍କୁ ଡାକିଲେ; ତହୁଁ ସେମାନେ ଦୁହେଁ ବାହାର ହୋଇ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ତେବେ ସେ କହିଲେ, “ଆମ୍ଭର ବାକ୍ୟ ଶୁଣ; ଯଦି ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ କେହି ଭବିଷ୍ୟଦ୍‍ବକ୍ତା ଥାଏ, ତେବେ ଆମ୍ଭେ ସଦାପ୍ରଭୁ କୌଣସି ଦର୍ଶନ ଦ୍ୱାରା ତାହା ପ୍ରତି ଆପଣାକୁ ପ୍ରକାଶ କରିବା, ଆମ୍ଭେ ସ୍ୱପ୍ନ ଦ୍ୱାରା ତାହା ସହିତ କଥା କହିବା। ");
INSERT INTO ory_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ଆମ୍ଭର ସେବକ ମୋଶା ତଦ୍ରୂପ ନୁହେଁ; ସେ ଆମ୍ଭର ସମସ୍ତ ଗୃହ ମଧ୍ୟରେ ବିଶ୍ୱାସପାତ୍ର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ଆମ୍ଭେ ତାହା ସହିତ ଗୂଢ଼ ବାକ୍ୟରେ ନୁହେଁ, ମାତ୍ର ମୁଖାମୁଖୀ ହୋଇ ପ୍ରକାଶ୍ୟ ରୂପେ କଥା କହିବା ଓ ସେ ସଦାପ୍ରଭୁଙ୍କର ଆକାର ଦର୍ଶନ କରିବ; ଏହେତୁ ତୁମ୍ଭେମାନେ ଆମ୍ଭ ସେବକ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ କଥା କହିବାକୁ କାହିଁକି ଭୀତ ହେଲ ନାହିଁ?” ");
INSERT INTO ory_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ଏହିରୂପେ ସେମାନଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା; ତହୁଁ ସେ ପ୍ରସ୍ଥାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ପୁଣି, ତମ୍ବୁ ଉପରୁ ମେଘ ସ୍ଥାନାନ୍ତରିତ ହେଲା ଆଉ ଦେଖ, ମରୀୟମ କୁଷ୍ଠଗ୍ରସ୍ତା, ହିମ ତୁଲ୍ୟ ଶ୍ୱେତ; ପୁଣି, ହାରୋଣ ମରୀୟମଙ୍କୁ ଅନାନ୍ତେ, ଦେଖ, ସେ କୁଷ୍ଠଗ୍ରସ୍ତ। ");
INSERT INTO ory_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ତହିଁରେ ହାରୋଣ ମୋଶାଙ୍କୁ କହିଲେ, “ହେ ମୋହର ପ୍ରଭୁ, ଆମ୍ଭେମାନେ ମୂର୍ଖତାର କର୍ମ କରିଅଛୁ ଓ ଆମ୍ଭେମାନେ ପାପ କରିଅଛୁ, ଏହେତୁ ବିନୟ କରୁଅଛି, ଆମ୍ଭମାନଙ୍କ ଉପରେ ସେହି ପାପ ଥୁଅ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ମାତାର ଗର୍ଭରୁ ନିର୍ଗତ ହେଲା ସମୟରେ ଯାହାର ମାଂସ ଅର୍ଦ୍ଧନଷ୍ଟ, ଏପରି ମୃତ ଲୋକ ତୁଲ୍ୟ ସେ ନ ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କରି କହିଲେ, “ହେ ପରମେଶ୍ୱର, ବିନୟ କରୁଅଛି, ତାହାକୁ ସୁସ୍ଥ କର।” ");
INSERT INTO ory_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ଏଥିରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଯଦି ତାହାର ପିତା ତାହାର ମୁଖରେ କେବଳ ଛେପ ପକାଇଥାʼନ୍ତା, ତେବେ ସେ କି ସାତ ଦିନ ଲଜ୍ଜିତା ହୁଅନ୍ତା ନାହିଁ? ସେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ଛାଉଣି ବାହାରେ ରୁଦ୍ଧା ହୋଇ ରହୁ; ତହିଁ ଉତ୍ତାରେ ସେ ଭିତରକୁ ଅଣାଯିବ।” ");
INSERT INTO ory_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ତହୁଁ ମରୀୟମ ସାତ ଦିନ ଛାଉଣିର ବାହାରେ ରୁଦ୍ଧା ହେଲା, ଆଉ ମରୀୟମ ପୁନର୍ବାର ଭିତରକୁ ଅଣା ନ ଯିବାଯାଏ ଲୋକମାନେ ଯାତ୍ରା କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ତହିଁ ଉତ୍ତାରେ ଲୋକମାନେ ହତ୍ସେରୋତଠାରୁ ଯାତ୍ରା କରି ପାରଣ ପର୍ବତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଯେଉଁ କିଣାନ ଦେଶ ଦେବା, ତାହା ଅନୁସନ୍ଧାନ କରିବାକୁ ତୁମ୍ଭେ ଲୋକ ପଠାଅ, ସେମାନଙ୍କର ପ୍ରତ୍ୟେକ ପିତୃବଂଶ ମଧ୍ୟରେ ଯେଉଁମାନେ ଅଧିପତି, ସେମାନଙ୍କୁ ପଠାଅ।” ");
INSERT INTO ory_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ପାରଣ ପ୍ରାନ୍ତରରୁ ସେମାନଙ୍କୁ ପଠାଇଲେ; ସେହି ଲୋକ ସମସ୍ତେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ପ୍ରଧାନ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ସେମାନଙ୍କର ନାମ ଏହି: ରୁବେନ୍‍ ବଂଶ ମଧ୍ୟରୁ ସକ୍କୁରର ପୁତ୍ର ଶମ୍ମୂୟ; ");
INSERT INTO ory_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ଶିମୀୟୋନ ବଂଶ ମଧ୍ୟରୁ ହୋରିର ପୁତ୍ର ଶାଫଟ; ");
INSERT INTO ory_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ଯିହୁଦା ବଂଶ ମଧ୍ୟରୁ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ; ");
INSERT INTO ory_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ଇଷାଖର ବଂଶ ମଧ୍ୟରୁ ଯୋଷେଫର ପୁତ୍ର ଯିଗାଲ; ");
INSERT INTO ory_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ଇଫ୍ରୟିମ ବଂଶ ମଧ୍ୟରୁ ନୂନର ପୁତ୍ର ହୋଶେୟ; ");
INSERT INTO ory_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ବିନ୍ୟାମୀନ୍ ବଂଶ ମଧ୍ୟରୁ ରାଫୂର ପୁତ୍ର ପଲ୍ଟି; ");
INSERT INTO ory_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ସବୂଲୂନ ବଂଶ ମଧ୍ୟରୁ ସୋଦିର ପୁତ୍ର ଗଦ୍ଦୀୟେଲ; ");
INSERT INTO ory_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ଯୋଷେଫ-ବଂଶ ମଧ୍ୟରୁ, ଅର୍ଥାତ୍‍, ମନଃଶି ବଂଶ ମଧ୍ୟରୁ ସୂଷିର ପୁତ୍ର ଗଦ୍ଦି; ");
INSERT INTO ory_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ଦାନ୍ ବଂଶ ମଧ୍ୟରୁ ଗମଲ୍ଲୀର ପୁତ୍ର ଅମ୍ମୀୟେଲ; ");
INSERT INTO ory_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ଆଶେର ବଂଶ ମଧ୍ୟରୁ ମୀଖାୟେଲର ପୁତ୍ର ସଥୁର; ");
INSERT INTO ory_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ନପ୍ତାଲି ବଂଶ ମଧ୍ୟରୁ ବପ୍ସିର ପୁତ୍ର ନହବି; ");
INSERT INTO ory_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ଗାଦ୍‍ ବଂଶ ମଧ୍ୟରୁ ମାଖିର ପୁତ୍ର ଗୂୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ମୋଶା ଯେଉଁ ଲୋକମାନଙ୍କୁ ଦେଶ ଅନୁସନ୍ଧାନ କରିବାକୁ ପଠାଇଥିଲେ, ସେମାନଙ୍କର ନାମ ଏହି, ଆଉ ମୋଶା, ନୂନର ପୁତ୍ର ହୋଶେୟଙ୍କୁ ଯିହୋଶୂୟ ନାମ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ଆଉ ମୋଶା ଏମାନଙ୍କୁ କିଣାନ ଦେଶ ଅନୁସନ୍ଧାନ କରିବାକୁ ପଠାଇ କହିଲେ, “ତୁମ୍ଭେମାନେ ଏହି ଦକ୍ଷିଣ ଦିଗ ଦେଇ ପର୍ବତ ଆରୋହଣ କର; ");
INSERT INTO ory_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ପୁଣି, ସେହି ଦେଶ କିପରି ଓ ତହିଁରେ ବାସକାରୀ ଲୋକମାନେ ବଳବାନ କି ଦୁର୍ବଳ ଓ ଅଳ୍ପ କି ଅନେକ; ");
INSERT INTO ory_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ପୁଣି, ସେମାନେ ଯେଉଁ ଦେଶରେ ବାସ କରନ୍ତି, ତାହା ଭଲ କି ମନ୍ଦ ଓ ଯେଉଁ ଯେଉଁ ନଗରରେ ବାସ କରନ୍ତି, ତାହା କି ପ୍ରକାର; ସେମାନେ ତମ୍ବୁରେ କି ଗଡ଼ରେ, କାହିଁରେ ବାସ କରନ୍ତି; ");
INSERT INTO ory_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ପୁଣି, ସେହି ଭୂମି କି ପ୍ରକାର, ଉର୍ବର କି ଅନୁର୍ବର, ତହିଁ ମଧ୍ୟରେ ବୃକ୍ଷ ଅଛି କି ନାହିଁ, ତାହା ଦେଖ। ଆଉ ତୁମ୍ଭେମାନେ ସାହସୀ ହୋଇ ସେହି ଦେଶର ଫଳରୁ କିଛି ସଙ୍ଗରେ ଆଣ।” ସେହି ସମୟରେ ପ୍ରଥମ ପକ୍ୱ ଦ୍ରାକ୍ଷାଫଳର ସମୟ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ଏଣୁ ସେମାନେ ସୀନ୍‍ ପ୍ରାନ୍ତରରୁ ଯାତ୍ରା କରି ହମାତର ପ୍ରବେଶ ସ୍ଥାନସ୍ଥିତ ରହୋବ ପର୍ଯ୍ୟନ୍ତ ଦେଶ ଅନୁସନ୍ଧାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ଆଉ ସେମାନେ ଦକ୍ଷିଣ ଦିଗ ଦେଇ ଯାଇ ହିବ୍ରୋଣରେ ଉପସ୍ଥିତ ହେଲେ; ସେହି ସ୍ଥାନରେ ଅହୀମାନ୍‍, ଶେଶୟ ଓ ତଲ୍ମୟ, ଅନାକର ଏହି ସନ୍ତାନମାନେ ଥିଲେ। ମିସରସ୍ଥିତ ସୋୟନ-ପତ୍ତନର ସାତ ବର୍ଷ ପୂର୍ବେ ହିବ୍ରୋଣର ପତ୍ତନ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ଏଉତ୍ତାରେ ସେମାନେ ଇଷ୍କୋଲ-ଉପତ୍ୟକାରେ ଉପସ୍ଥିତ ହୋଇ ସେଠାରେ ଏକ ପେଣ୍ଡା ଫଳଯୁକ୍ତ ଦ୍ରାକ୍ଷାଲତାର ଏକ ଡାଳ କାଟି ତାହା ଦୁଇ ଜଣ ସାଙ୍ଗୀରେ ବହିଲେ; ସେମାନେ ଡାଳିମ୍ବ ଓ ଡିମ୍ବିରି ଫଳ ମଧ୍ୟ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯେଉଁ ଦ୍ରାକ୍ଷାପେଣ୍ଡା କାଟିଥିଲେ, ତହିଁ ସକାଶୁ ସେହି ସ୍ଥାନ ଇଷ୍କୋଲ (ପେଣ୍ଡା) ଉପତ୍ୟକା ନାମରେ ପ୍ରସିଦ୍ଧ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ଆଉ ଚାଳିଶ ଦିନ ଉତ୍ତାରେ ସେମାନେ ଦେଶ ଅନୁସନ୍ଧାନ କରି ଫେରି ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ଏଥିଉତ୍ତାରେ ସେମାନେ ଆସି ପାରଣ ପ୍ରାନ୍ତରସ୍ଥ କାଦେଶ ନାମକ ସ୍ଥାନରେ ମୋଶା, ହାରୋଣ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ସମସ୍ତ ମଣ୍ଡଳୀ ନିକଟରେ ଉପସ୍ଥିତ ହୋଇ ସେମାନଙ୍କୁ ଓ ସମସ୍ତ ମଣ୍ଡଳୀକୁ ସମାଚାର ଦେଲେ ଓ ସେମାନଙ୍କୁ ସେହି ଦେଶର ଫଳ ଦେଖାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ପୁଣି, ସେମାନେ ବର୍ଣ୍ଣନା କରି ତାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶକୁ ପଠାଇଥିଲ, ଆମ୍ଭେମାନେ ସେଠାକୁ ଯାଇଥିଲୁ; ଆଉ ତାହା ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଅଟେ ଓ ଏହା ତହିଁର ଫଳ। ");
INSERT INTO ory_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ତଥାପି ସେହି ଦେଶ ନିବାସୀମାନେ ବଳବାନ ଓ ନଗରସବୁ ପ୍ରାଚୀର-ବେଷ୍ଟିତ ଓ ଅତି ବଡ଼; ଆହୁରି ଆମ୍ଭେମାନେ ସେଠାରେ ଅନାକର ସନ୍ତାନଗଣକୁ ଦେଖିଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ଦକ୍ଷିଣ ଦେଶରେ ଅମାଲେକ ବାସ କରନ୍ତି; ପୁଣି, ପର୍ବତରେ ହିତ୍ତୀୟ, ଯିବୂଷୀୟ ଓ ଇମୋରୀୟ ଲୋକମାନେ ବାସ କରନ୍ତି; ଆଉ ସମୁଦ୍ର ନିକଟରେ ଓ ଯର୍ଦ୍ଦନ ତୀରରେ କିଣାନୀୟ ଲୋକମାନେ ବାସ କରନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ତହିଁରେ କାଲେବ ମୋଶାଙ୍କ ପକ୍ଷରୁ ଲୋକମାନଙ୍କୁ କ୍ଷାନ୍ତ କରି କହିଲେ, “ଆସ, ଆମ୍ଭେମାନେ ଏହିକ୍ଷଣି ଉଠିଯାଇ ତାହା ଅଧିକାର କରୁ; ତାହା ପରାସ୍ତ କରିବାକୁ ଆମ୍ଭେମାନେ ସକ୍ଷମ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ମାତ୍ର ଯେଉଁ ଲୋକମାନେ ତାଙ୍କ ସହିତ ଯାଇଥିଲେ, ସେମାନେ କହିଲେ, “ଆମ୍ଭେମାନେ ସେହି ଲୋକମାନଙ୍କ ବିରୁଦ୍ଧରେ ଯାଇ ନ ପାରୁ, କାରଣ ସେମାନେ ଆମ୍ଭମାନଙ୍କଠାରୁ ବଳବାନ।” ");
INSERT INTO ory_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ଏହିରୂପେ ସେମାନେ ଯେଉଁ ଦେଶ ଅନୁସନ୍ଧାନ କରିଥିଲେ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ନିକଟରେ ସେହି ଦେଶର ଅଖ୍ୟାତି କରି କହିଲେ, “ଆମ୍ଭେମାନେ ଯେଉଁ ଦେଶର ମଧ୍ୟଦେଇ ଅନୁସନ୍ଧାନ କରିବାକୁ ଯାଇଥିଲୁ, ସେହି ଦେଶ ସ୍ୱନିବାସୀମାନଙ୍କୁ ଗ୍ରାସ କରେ, ପୁଣି, ତହିଁ ମଧ୍ୟରେ ଆମ୍ଭେମାନେ ଯେତେ ଲୋକଙ୍କୁ ଦେଖିଲୁ, ସେମାନେ ବଡ଼ ଡେଙ୍ଗା। ");
INSERT INTO ory_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ଆଉ ସେ ସ୍ଥାନରେ ଆମ୍ଭେମାନେ ମହାବୀରଜାତ ଅନାକର ସନ୍ତାନ ମହାବୀରଗଣକୁ ଦେଖିଲୁ; ଆଉ ଆମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଦୃଷ୍ଟିରେ ଫଡ଼ିଙ୍ଗ ପରି ହେଲୁ ଓ ସେମାନଙ୍କ ଦୃଷ୍ଟିରେ ମଧ୍ୟ ସେରୂପ ଥିଲୁ।” ");
INSERT INTO ory_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ଏଥିରେ ସମସ୍ତ ମଣ୍ଡଳୀ ଉଚ୍ଚସ୍ୱରରେ କୋଳାହଳ କଲେ ଓ ଲୋକମାନେ ସେହି ରାତ୍ରି ରୋଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସମସ୍ତେ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ ଓ ହାରୋଣଙ୍କ ବିରୁଦ୍ଧରେ ବଚସା କଲେ ଓ ସମସ୍ତ ମଣ୍ଡଳୀ ସେମାନଙ୍କ ଆଗରେ କହିଲେ, “ଆହା, ଆମ୍ଭେମାନେ ମିସର ଦେଶରେ ନଚେତ୍ ଏହି ପ୍ରାନ୍ତରରେ ମରିଥାʼନ୍ତୁ! ଆହା, ଆମ୍ଭେମାନେ ଯଦି ଏହି ପ୍ରାନ୍ତରରେ ମରିଥାʼନ୍ତୁ! ");
INSERT INTO ory_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କୁ ଖଡ୍ଗରେ ନିପାତ କରିବା ପାଇଁ କାହିଁକି ଏ ଦେଶକୁ ଆଣିଅଛନ୍ତି? ଯଦ୍ଦ୍ୱାରା ଆମ୍ଭମାନଙ୍କର ଭାର୍ଯ୍ୟା ଓ ବାଳକମାନେ ଲୁଟିତ ହେବେ; ମିସରକୁ ଫେରିଗଲେ କି ଆମ୍ଭମାନଙ୍କ ପାଇଁ ଭଲ ହୁଅନ୍ତା ନାହିଁ?” ");
INSERT INTO ory_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ଏଥିରେ ସେମାନେ ପରସ୍ପରକୁ କହିଲେ, “ଆସ, ଆମ୍ଭେମାନେ ଜଣକୁ ପ୍ରଧାନ କରି ମିସରକୁ ଫେରିଯାଉ।” ");
INSERT INTO ory_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ତହିଁରେ ମୋଶା ଓ ହାରୋଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ସମାଜ ଆଗରେ ମୁହଁ ମାଡ଼ି ପଡ଼ିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ତହୁଁ ଦେଶ ଅନୁସନ୍ଧାନକାରୀ ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ ଓ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ ଆପଣା ଆପଣା ବସ୍ତ୍ର ଚିରିଲେ; ");
INSERT INTO ory_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ଆଉ ସେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ସମସ୍ତ ମଣ୍ଡଳୀକୁ କହିଲେ, “ଆମ୍ଭେମାନେ ଯେଉଁ ଦେଶ ଅନୁସନ୍ଧାନ କରିବାକୁ ଯାଇଥିଲୁ, ତାହା ଅତ୍ୟନ୍ତ ଉତ୍ତମ ଦେଶ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ଯଦି ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କଠାରେ ସନ୍ତୁଷ୍ଟ ହୁଅନ୍ତି, ତେବେ ସେ ଆମ୍ଭମାନଙ୍କୁ ସେହି ଦେଶକୁ ନେବେ ଓ ତାହା ଆମ୍ଭମାନଙ୍କୁ ଦେବେ; ସେହି ଦେଶ ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","କେବଳ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କର ବିଦ୍ରୋହୀ ହୁଅ ନାହିଁ, କିଅବା ସେହି ଦେଶର ଲୋକମାନଙ୍କୁ ଭୟ କର ନାହିଁ, କାରଣ ସେମାନେ ଆମ୍ଭମାନଙ୍କର ଭକ୍ଷ୍ୟ ସ୍ୱରୂପ; ସେମାନଙ୍କ ଆଶ୍ରୟ ସେମାନଙ୍କ ଉପରୁ ଘୁଞ୍ଚାଗଲାଣି, ପୁଣି, ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗରେ ଅଛନ୍ତି; ସେମାନଙ୍କୁ ଭୟ କର ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ମାତ୍ର ସମସ୍ତ ମଣ୍ଡଳୀ ସେମାନଙ୍କୁ ପଥରରେ ମାରିବାକୁ କହିଲେ। ସେତେବେଳେ ସଦାପ୍ରଭୁଙ୍କର ପ୍ରତାପ ସମାଗମ-ତମ୍ବୁରେ ଇସ୍ରାଏଲର ସମସ୍ତ ସନ୍ତାନ ପ୍ରତି ପ୍ରକାଶିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଏହି ଲୋକମାନେ କେତେ କାଳ ପର୍ଯ୍ୟନ୍ତ ଆମ୍ଭଙ୍କୁ ଅବଜ୍ଞା କରିବେ? ଆଉ ଆମ୍ଭେ ସେମାନଙ୍କ ମଧ୍ୟରେ ଚିହ୍ନ ସ୍ୱରୂପେ ଯେଉଁ ସମସ୍ତ କର୍ମ କରିଅଛୁ, ତାହା କଲେ ହେଁ ସେମାନେ କେତେ କାଳ ପର୍ଯ୍ୟନ୍ତ ଆମ୍ଭଠାରେ ବିଶ୍ୱାସ କରିବେ ନାହିଁ? ");
INSERT INTO ory_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ଆମ୍ଭେ ମହାମାରୀ ଦ୍ୱାରା ସେମାନଙ୍କୁ ସଂହାର କରିବା ଓ ସେମାନଙ୍କୁ ଅଧିକାରଚ୍ୟୁତ କରିବା, ପୁଣି, ସେମାନଙ୍କଠାରୁ ତୁମ୍ଭକୁ ବଡ଼ ଓ ବଳବାନ ଗୋଷ୍ଠୀ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ଏଥିରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, “ତେବେ ମିସରୀୟ ଲୋକମାନେ ତ ଏହା ଶୁଣିବେ; କାରଣ ତୁମ୍ଭେ ଆପଣା ପରାକ୍ରମ ଦ୍ୱାରା ସେମାନଙ୍କ ମଧ୍ୟରୁ ଏହି ଲୋକମାନଙ୍କୁ ଆଣିଅଛ। ");
INSERT INTO ory_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ପୁଣି, ସେମାନେ ଏ ଦେଶ ନିବାସୀମାନଙ୍କୁ ତାହା କହିବେ; ସେମାନେ ଶୁଣିଅଛନ୍ତି ଯେ, ତୁମ୍ଭେ ସଦାପ୍ରଭୁ ଏହି ଲୋକମାନଙ୍କ ମଧ୍ୟବର୍ତ୍ତୀ ଅଟ; କାରଣ ତୁମ୍ଭେ ସଦାପ୍ରଭୁ ପ୍ରତ୍ୟକ୍ଷ ଦର୍ଶନ ଦେଉଅଛ ଓ ତୁମ୍ଭ ମେଘ ସେମାନଙ୍କ ଉପରେ ସ୍ଥିତି କରୁଅଛି ଓ ତୁମ୍ଭେ ଦିନ ସମୟରେ ମେଘ ସ୍ତମ୍ଭରେ ଓ ରାତ୍ରି ସମୟରେ ଅଗ୍ନିସ୍ତମ୍ଭରେ ସେମାନଙ୍କ ଆଗେ ଆଗେ ଗମନ କରୁଅଛ। ");
INSERT INTO ory_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ବର୍ତ୍ତମାନ ଯଦି ତୁମ୍ଭେ ଏହି ଲୋକମାନଙ୍କୁ ଏକ ମନୁଷ୍ୟ ତୁଲ୍ୟ ବଧ କରିବ, ତେବେ ଯେଉଁ ଅନ୍ୟ ଦେଶୀୟ ଲୋକମାନେ ତୁମ୍ଭର କୀର୍ତ୍ତିର କଥା ଶୁଣିଅଛନ୍ତି, ସେମାନେ କହିବେ, ");
INSERT INTO ory_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘ସଦାପ୍ରଭୁ ଏହି ଲୋକମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବାକୁ ଶପଥ କରିଥିଲେ, ସେହି ଦେଶକୁ ସେମାନଙ୍କୁ ଆଣି ପାରିଲେ ନାହିଁ, ଏହେତୁ ସେ ସେମାନଙ୍କୁ ପ୍ରାନ୍ତରରେ ବଧ କରିଅଛନ୍ତି।’ ");
INSERT INTO ory_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ଏବେ ମୁଁ ବିନୟ କରୁଅଛି, ପ୍ରଭୁଙ୍କ ପରାକ୍ରମ ମହାନ ହେଉ, ଯେପରି ତୁମ୍ଭେ କହିଅଛ, ");
INSERT INTO ory_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘ସଦାପ୍ରଭୁ କ୍ରୋଧରେ ଧୀର, ଦୟାରେ ପରିପୂର୍ଣ୍ଣ, ଅପରାଧ ଓ ଆଜ୍ଞା-ଲଙ୍ଘନର କ୍ଷମାକାରୀ, ତଥାପି ନିତାନ୍ତ ତହିଁର ଦଣ୍ଡଦାତା; ପୁଣି, ତୃତୀୟ ଓ ଚତୁର୍ଥ ପୁରୁଷ ପର୍ଯ୍ୟନ୍ତ ସନ୍ତାନଗଣ ଉପରେ ପିତୃଗଣଙ୍କର ଅପରାଧର ପ୍ରତିଫଳଦାତା।’ ");
INSERT INTO ory_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ବିନୟ କରୁଅଛି, ତୁମ୍ଭେ ଆପଣା ଦୟାର ମହତ୍ତ୍ୱ ଅନୁସାରେ ଓ ତୁମ୍ଭେ ଏହି ଲୋକମାନଙ୍କୁ ମିସରଠାରୁ ଏପର୍ଯ୍ୟନ୍ତ ଯେପରି କ୍ଷମା କରିଅଛ, ତଦନୁସାରେ ଏହି ଲୋକମାନଙ୍କର ଅପରାଧ କ୍ଷମା କର।” ");
INSERT INTO ory_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ତହିଁରେ ସଦାପ୍ରଭୁ କହିଲେ, “ଆମ୍ଭେ ତୁମ୍ଭର ଅନୁରୋଧନୁସାରେ ସେମାନଙ୍କୁ କ୍ଷମା କଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ମାତ୍ର ଯଦି ଆମ୍ଭେ ଜୀବିତ ହେଉ, ଆଉ ଯଦି ଏହି ସମସ୍ତ ପୃଥିବୀ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତାପରେ ପରିପୂର୍ଣ୍ଣ ହେବ, ");
INSERT INTO ory_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ତେବେ ଏମାନଙ୍କ ମଧ୍ୟରୁ ଯେତେ ଲୋକ ଆମ୍ଭର ପ୍ରତାପ, ପୁଣି, ମିସରରେ ଓ ପ୍ରାନ୍ତରରେ କୃତ ଆମ୍ଭର ଚିହ୍ନସ୍ୱରୂପ କର୍ମ ଦେଖିଲେ ମଧ୍ୟ ଦଶ ଥର ଆମ୍ଭର ପରୀକ୍ଷା କରିଅଛନ୍ତି ଓ ଆମ୍ଭ ରବରେ ଅମନୋଯୋଗୀ ହୋଇଅଛନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ସେମାନଙ୍କ ପୂର୍ବପୁରୁଷମାନଙ୍କ ପ୍ରତି ଆମ୍ଭେ ଯେଉଁ ଦେଶ ବିଷୟରେ ଶପଥ କରିଅଛୁ, ନିଶ୍ଚୟ ଏମାନଙ୍କ ମଧ୍ୟରୁ କେହି ସେହି ଦେଶ ଦେଖି ପାରିବେ ନାହିଁ; କିଅବା ଯେଉଁମାନେ ଆମ୍ଭଙ୍କୁ ଅବଜ୍ଞା କରିଅଛନ୍ତି, ସେମାନଙ୍କ ମଧ୍ୟରୁ କେହି ତାହା ଦେଖିବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ମାତ୍ର ଆମ୍ଭର ସେବକ କାଲେବଠାରେ ଅନ୍ୟ ଆତ୍ମା ଅଛି ଓ ସେ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଆମ୍ଭର ଅନୁଗତ ହୋଇଅଛି, ଏଥିପାଇଁ ସେ ଯେଉଁ ଦେଶକୁ ଯାଇଥିଲା, ସେହି ଦେଶରେ ଆମ୍ଭେ ତାହାକୁ ପ୍ରବେଶ କରାଇବା ଓ ତାହାର ବଂଶ ତାହା ଅଧିକାର କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ବର୍ତ୍ତମାନ ଅମାଲେକୀୟ ଓ କିଣାନୀୟମାନେ ତଳଭୂମିରେ ବାସ କରନ୍ତି; କାଲି ତୁମ୍ଭେମାନେ ଫେରି ସୂଫ ସାଗରକୁ ଯିବା ପଥ ଦେଇ ପ୍ରାନ୍ତରକୁ ଗମନ କର।” ");
INSERT INTO ory_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ଏଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ଆମ୍ଭ ବିରୁଦ୍ଧରେ ବଚସା କରୁଅଛି, ଏହି ଯେଉଁ ଦୁଷ୍ଟ ମଣ୍ଡଳୀ, ତାହାକୁ ଆମ୍ଭେ କେତେ କାଳ ସହିବା? ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଆମ୍ଭ ପ୍ରତିକୂଳରେ ଯେଉଁ ବଚସା କରୁଅଛନ୍ତି, ତାହା ଆମ୍ଭେ ଶୁଣିଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ସେମାନଙ୍କୁ କୁହ, ସଦାପ୍ରଭୁ ଏହି କଥା କହନ୍ତି, ‘ଆମ୍ଭେ ଯଦି ଜୀବିତ ହେଉ, ତେବେ ତୁମ୍ଭେମାନେ ଆମ୍ଭ କର୍ଣ୍ଣଗୋଚରରେ ଯାହା କହିଅଛ, ତାହା ହିଁ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି କରିବା। ");
INSERT INTO ory_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ତୁମ୍ଭମାନଙ୍କର ଶବ ଏହି ପ୍ରାନ୍ତରରେ ପଡ଼ିବ; ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ କୋଡ଼ିଏ ବର୍ଷ ଓ ତହିଁରୁ ଅଧିକ ବର୍ଷ ବୟସ୍କ ଲୋକମାନଙ୍କର ସମ୍ପୂର୍ଣ୍ଣ ସଂଖ୍ୟାନୁସାରେ ଗଣିତ ଯେତେ ଲୋକ, ତୁମ୍ଭେମାନେ ଆମ୍ଭ ବିରୁଦ୍ଧରେ ବଚସା କରିଅଛ, ");
INSERT INTO ory_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶରେ ବାସ କରାଇବାକୁ ପ୍ରତିଜ୍ଞା କରିଅଛୁ, ନିଶ୍ଚୟ ସେହି ଦେଶରେ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ ଓ ନୂନର ପୁତ୍ର ଯିହୋଶୂୟଙ୍କ ବ୍ୟତୀତ ତୁମ୍ଭେମାନେ କେହି ପ୍ରବେଶ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ମାତ୍ର ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣାର ଯେଉଁ ବାଳକଗଣଙ୍କ ବିଷୟରେ ସେମାନେ ଲୁଟିତ ହେବେ ବୋଲି କହିଥିଲ, ସେମାନଙ୍କୁ ଆମ୍ଭେ ସେହି ସ୍ଥାନକୁ ଆଣିବା ଓ ତୁମ୍ଭେମାନେ ଯେଉଁ ଦେଶକୁ ତୁଚ୍ଛଜ୍ଞାନ କରିଅଛ, ସେମାନେ ତହିଁର ପରିଚୟ ପାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ମାତ୍ର ତୁମ୍ଭମାନଙ୍କର ଶବ ଏହି ପ୍ରାନ୍ତରରେ ପଡ଼ିବ। ");
INSERT INTO ory_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ପୁଣି, ତୁମ୍ଭମାନଙ୍କ ସନ୍ତାନଗଣଙ୍କ ଚାଳିଶ ବର୍ଷ ଏହି ପ୍ରାନ୍ତରରେ ଭ୍ରମଣକାରୀ ହେବେ ଓ ଏହି ପ୍ରାନ୍ତରରେ ତୁମ୍ଭମାନଙ୍କ ଶବ ନଷ୍ଟ ନ ହେବା ପର୍ଯ୍ୟନ୍ତ ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ବ୍ୟଭିଚାରର ଫଳ ଭୋଗ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ତୁମ୍ଭେମାନେ ଯେଉଁ ଚାଳିଶ ଦିନ ଦେଶ ଅନୁସନ୍ଧାନ କରିଅଛ, ସେହି ଦିନର ସଂଖ୍ୟାନୁସାରେ ଏକ ଏକ ଦିନ ପାଇଁ ଏକ ଏକ ବର୍ଷ, ଏରୂପେ ଚାଳିଶ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ଅପରାଧର ଦଣ୍ଡ ଭୋଗିବ ଓ ଆମ୍ଭର ବିପକ୍ଷତା କିପରି, ତାହା ଜ୍ଞାତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ଆମ୍ଭେ ସଦାପ୍ରଭୁ ଏହା କହିଅଛୁ, ଆମ୍ଭ ବିରୁଦ୍ଧରେ ଯେଉଁ ଦୁଷ୍ଟ ମଣ୍ଡଳୀ ଏକତ୍ରିତ ହୋଇଅଛି, ତାହା ପ୍ରତି ଆମ୍ଭେ ତାହା ନିଶ୍ଚୟ କରିବା, ପୁଣି, ସେମାନେ ଏହି ପ୍ରାନ୍ତରରେ ନଷ୍ଟ ହେବେ ଓ ଏହି ସ୍ଥାନରେ ସେମାନେ ମରିବେ।’” ");
INSERT INTO ory_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ଆଉ ଦେଶ ଅନୁସନ୍ଧାନ କରିବା ପାଇଁ ମୋଶାଙ୍କର ପ୍ରେରିତ ଯେଉଁ ଲୋକମାନେ ଫେରିଆସି ସେହି ଦେଶର ଅଖ୍ୟାତି ଆଣି ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ସମସ୍ତ ମଣ୍ଡଳୀକୁ ବଚସା କରାଇଥିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ଦେଶର ଅଖ୍ୟାତିକାରୀ ସେହି ଲୋକମାନେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ମହାମାରୀ ଦ୍ୱାରା ମଲେ। ");
INSERT INTO ory_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ମାତ୍ର ଯେଉଁ ମନୁଷ୍ୟମାନେ ଦେଶ ଅନୁସନ୍ଧାନ କରିବାକୁ ଯାଇଥିଲେ, ସେମାନଙ୍କ ମଧ୍ୟରୁ କେବଳ ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ ଓ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ ଜୀବିତ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ଆଉ ମୋଶା ଇସ୍ରାଏଲର ସମସ୍ତ ସନ୍ତାନଙ୍କୁ ଏହି କଥା କହିଲେ; ତହିଁରେ ଲୋକମାନେ ଅତିଶୟ ବିଳାପ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ପୁଣି, ସେମାନେ ଅତି ପ୍ରାତଃକାଳରେ ଉଠି ପର୍ବତ ଶୃଙ୍ଗ ଉପରକୁ ଯିବାକୁ ବାହାରି କହିଲେ, “ଦେଖ, ଆମ୍ଭେମାନେ ପାପ କରିଅଛୁ, ତଥାପି ସଦାପ୍ରଭୁ ଯେଉଁ ସ୍ଥାନ ବିଷୟରେ ପ୍ରତିଜ୍ଞା କରିଅଛନ୍ତି, ସେହି ସ୍ଥାନକୁ ଯିବା ନିମନ୍ତେ; ଆମ୍ଭେମାନେ ଏଠାରେ ଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ତହିଁରେ ମୋଶା କହିଲେ, “ଏବେ ତୁମ୍ଭେମାନେ କାହିଁକି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାଲଙ୍ଘନ କରୁଅଛ? ତୁମ୍ଭମାନଙ୍କର ଏହି କର୍ମ ସଫଳ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","କାରଣ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ନାହାନ୍ତି; ଯେପରି ତୁମ୍ଭେମାନେ ଶତ୍ରୁଗଣର ସମ୍ମୁଖରେ ପରାସ୍ତ ହେବ ନାହିଁ, ଏଥିପାଇଁ ଉପରକୁ ଯାଅ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ଯେହେତୁ ଅମାଲେକୀୟ ଓ କିଣାନୀୟ ଲୋକମାନେ ସେଠାରେ ତୁମ୍ଭମାନଙ୍କ ସମ୍ମୁଖରେ ଅଛନ୍ତି ଓ ତୁମ୍ଭେମାନେ ଖଡ୍ଗରେ ପତିତ ହେବ; ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କଠାରୁ ବିମୁଖ ହେବାରୁ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ସହବର୍ତ୍ତୀ ହେବେ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ତଥାପି ସେମାନେ ପର୍ବତ ଶୃଙ୍ଗ ଉପରକୁ ଯିବାକୁ ଦୁଃସାହସ କଲେ; ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ନିୟମ-ସିନ୍ଦୁକ ଓ ମୋଶା ଛାଉଣିରୁ ପ୍ରସ୍ଥାନ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ସେତେବେଳେ ସେହି ପର୍ବତବାସୀ ଅମାଲେକୀୟ ଓ କିଣାନୀୟ ଲୋକମାନେ ଓହ୍ଲାଇ ଆସି ସେମାନଙ୍କୁ ଆଘାତ କଲେ ଓ ସେମାନଙ୍କୁ ପରାସ୍ତ କରି ହର୍ମା ପର୍ଯ୍ୟନ୍ତ ତଡ଼ିଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କୁହ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବା, ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ସେହି ନିବାସ ଦେଶରେ ଯେତେବେଳେ ପ୍ରବେଶ କରିବ, ");
INSERT INTO ory_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ପୁଣି, ତୁମ୍ଭମାନଙ୍କର ମାନତ ପୂର୍ଣ୍ଣ କରିବା ନିମନ୍ତେ, କିଅବା ସ୍ୱେଚ୍ଛାଦତ୍ତ ଉପହାର ନିମନ୍ତେ, କିଅବା ତୁମ୍ଭମାନଙ୍କ ନିରୂପିତ ପର୍ବରେ ଗୋମେଷାଦି ପଲରୁ ସଦାପ୍ରଭୁଙ୍କ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପେ ହୋମ ବା ବଳି ଉତ୍ସର୍ଗ କରିବ; ");
INSERT INTO ory_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ସେତେବେଳେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉପହାର ଉତ୍ସର୍ଗକାରୀ ଲୋକ ହୋମାଦି ବଳିଦାନାର୍ଥକ ପ୍ରତ୍ୟେକ ମେଷବତ୍ସ ନିମନ୍ତେ ଏକ ହିନର ଚତୁର୍ଥାଂଶ ତୈଳରେ ମିଶ୍ରିତ ଏକ ଐଫାର ଦଶମାଂଶ ସରୁ ମଇଦାର ନୈବେଦ୍ୟ ଆଣିବ, ");
INSERT INTO ory_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ପୁଣି, ଏକ ହିନର ଚତୁର୍ଥାଂଶ ଦ୍ରାକ୍ଷାରସର ପେୟ-ନୈବେଦ୍ୟ ପ୍ରସ୍ତୁତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ଅଥବା ଏକ ମେଷ ନିମନ୍ତେ, ତୁମ୍ଭେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଏକ ହିନର ତୃତୀୟାଂଶ ତୈଳରେ ମିଶ୍ରିତ ଏକ ଐଫାର ଦୁଇ ଦଶମାଂଶ ସରୁ ମଇଦାର ନୈବେଦ୍ୟ ପ୍ରସ୍ତୁତ କରିବ, ");
INSERT INTO ory_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ପୁଣି, ତୁମ୍ଭେ ପେୟ-ନୈବେଦ୍ୟ ନିମନ୍ତେ ଏକ ହିନର ତୃତୀୟାଂଶ ଦ୍ରାକ୍ଷାରସ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","ଆଉ ତୁମ୍ଭେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମ ନିମନ୍ତେ, ଅବା ମାନତ-ପୂର୍ଣ୍ଣକରଣାର୍ଥକ ବଳି ନିମନ୍ତେ, କିଅବା ମଙ୍ଗଳାର୍ଥକ ଉପହାର ନିମନ୍ତେ, ଯଦି ଗୋବତ୍ସ ପ୍ରସ୍ତୁତ କରିବ, ");
INSERT INTO ory_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ତେବେ ସେହି ଗୋବତ୍ସ ସହିତ ଅର୍ଦ୍ଧହୀନ୍ ତୈଳ ମିଶ୍ରିତ ଏକ ଐଫାର ତିନି ଦଶମାଂଶ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ପୁଣି, ତୁମ୍ଭେ ସଦାପ୍ରଭୁଙ୍କ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥକ ଅଗ୍ନିକୃତ ଉପହାରର ପେୟ-ନୈବେଦ୍ୟ ନିମନ୍ତେ ଅର୍ଦ୍ଧହୀନ୍ ଦ୍ରାକ୍ଷାରସ ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ଏହିରୂପେ ପ୍ରତ୍ୟେକ ଗୋରୁ, ପ୍ରତ୍ୟେକ ମେଷ ଓ ପ୍ରତ୍ୟେକ ମେଷବତ୍ସ ଅବା ଛାଗବତ୍ସ ପ୍ରତି କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ତୁମ୍ଭେମାନେ ପ୍ରସ୍ତୁତ କରିବା ସଂଖ୍ୟାନୁସାରେ ପ୍ରତ୍ୟେକ ପଶୁ ପ୍ରତି ସେମାନଙ୍କ ସଂଖ୍ୟା ପ୍ରମାଣେ ସେରୂପ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ଗୃହଜାତ ସମସ୍ତ ଲୋକ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କଲେ, ଏହି ବ୍ୟବସ୍ଥାନୁସାରେ ଏହିସବୁ କାର୍ଯ୍ୟ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ଆଉ ଯଦି ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ କୌଣସି ବିଦେଶୀୟ ଲୋକ କିଅବା ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପୁରୁଷାନୁକ୍ରମେ ବାସକାରୀ କୌଣସି ଲୋକ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବାକୁ ଇଚ୍ଛା କରେ, ତେବେ ତୁମ୍ଭେମାନେ ଯେପ୍ରକାର କର, ସେ ସେହି ପ୍ରକାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ସମାଜ ନିମନ୍ତେ, (ଅର୍ଥାତ୍‍) ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଓ ପ୍ରବାସକାରୀ ବିଦେଶୀ ଲୋକ ନିମନ୍ତେ ଏକ ବ୍ୟବସ୍ଥା ହେବ, ଏହା ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ଅନନ୍ତକାଳୀନ ବିଧି; ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ଯେପରି ତୁମ୍ଭେମାନେ ଅଟ, ସେପରି ବିଦେଶୀ ଲୋକମାନେ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଓ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ ବିଦେଶୀ ନିମନ୍ତେ ଏକ ବ୍ୟବସ୍ଥା ଓ ଏକ ଆଦେଶ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ");
INSERT INTO ory_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶକୁ ନେଇ ଯାଉଅଛୁ, ସେହି ଦେଶରେ ଉପସ୍ଥିତ ହେଲେ ତୁମ୍ଭେମାନେ ଏରୂପ କରିବ, ");
INSERT INTO ory_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ତୁମ୍ଭେମାନେ ସେହି ଦେଶର ଅନ୍ନ ଭୋଜନ କରିବା ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ତୋଳନୀୟ ଉପହାର ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ପ୍ରଥମ ସୂଜିରୁ ଉତ୍ତୋଳନୀୟ ଉପହାର ନିମନ୍ତେ ଏକ ପିଠା ଉତ୍ସର୍ଗ କରିବ; ଯେପରି ଶସ୍ୟମର୍ଦ୍ଦନ ସ୍ଥାନର ଉତ୍ତୋଳନୀୟ ଉପହାର, ସେପରି ତାହା ଉତ୍ତୋଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ତୁମ୍ଭେମାନେ ପୁରୁଷାନୁକ୍ରମେ ଆପଣା ଆପଣା ପ୍ରଥମ ସୂଜିରୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଏକ ଉତ୍ତୋଳନୀୟ ଉପହାର ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","ଆଉ ଯଦି ତୁମ୍ଭେମାନେ ଭ୍ରାନ୍ତିରେ ତ୍ରୁଟି କର ଓ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯାହା କହିଅଛନ୍ତି, ସେହି ସବୁ ଆଜ୍ଞା, ");
INSERT INTO ory_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ଅର୍ଥାତ୍‍, ସଦାପ୍ରଭୁ ଆଜ୍ଞା ଦେବା ଦିନାବଧି ତୁମ୍ଭମାନଙ୍କ ପୁରୁଷାନୁକ୍ରମେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ଦ୍ୱାରା ଯେଉଁସବୁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ତାହାସବୁ ଯଦି ପାଳନ ନ କର; ");
INSERT INTO ory_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ଯଦି ତାହା ମଣ୍ଡଳୀର ଅଗୋଚରରେ ଭ୍ରାନ୍ତିରେ ହୋଇଥାଏ, ତେବେ ସମସ୍ତ ମଣ୍ଡଳୀ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମ ନିମନ୍ତେ ଏକ ଗୋବତ୍ସ ଓ ବିଧିମତେ ତାହା ସହିତ ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ ଓ ପାପାର୍ଥକ ବଳି ନିମନ୍ତେ ଏକ ଛାଗ ଉତ୍ସର୍ଗ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ଆଉ ଯାଜକ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ତହିଁରେ ସେମାନେ କ୍ଷମା ପାଇବେ, କାରଣ ତାହା ଭ୍ରାନ୍ତି ଓ ସେମାନେ ସେହି ଭ୍ରାନ୍ତି ସକାଶୁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆପଣାମାନଙ୍କ ଉପହାର, ଅର୍ଥାତ୍‍, ଅଗ୍ନିକୃତ ଉପହାର ଓ ପାପାର୍ଥକ ବଳି ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ଆଣିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀ ଓ ସେମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ ବିଦେଶୀ ଲୋକମାନେ କ୍ଷମା ପାଇବେ; କାରଣ ସମସ୍ତ ଲୋକଙ୍କ ସମ୍ବନ୍ଧରେ ଏହା ଭ୍ରାନ୍ତିରେ କରାଯାଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ଆଉ ଯଦି ଏକ ପ୍ରାଣୀ ଭ୍ରାନ୍ତିରେ ପାପ କରେ, ତେବେ ସେ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ବର୍ଷୀୟ ଏକ ଛାଗବତ୍ସା ଆଣିବ। ");
INSERT INTO ory_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ପୁଣି, ଯେଉଁ ଲୋକ ଭ୍ରାନ୍ତିରେ ପାପ କରେ, ଯାଜକ ତାହା ପାଇଁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରଣାର୍ଥେ ସେହି ଭ୍ରାନ୍ତ ପ୍ରାଣୀ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବ; ତହିଁରେ ସେ କ୍ଷମାପ୍ରାପ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଗୃହଜାତ ଓ ସେମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ ବିଦେଶୀୟ ଲୋକମାନଙ୍କ ନିମନ୍ତେ ଭ୍ରାନ୍ତିରେ କୌଣସି କର୍ମକାରୀର ଏକ ବ୍ୟବସ୍ଥା ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","ମାତ୍ର ଯେଉଁ ପ୍ରାଣୀ ଊର୍ଦ୍ଧ୍ୱ ହସ୍ତରେ କୌଣସି (ପାପ) କର୍ମ କରେ, ସେ ଗୃହଜାତ ହେଉ ବା ବିଦେଶୀ ହେଉ, ସଦାପ୍ରଭୁଙ୍କର ନିନ୍ଦା କରେ; ଏଣୁ ସେହି ପ୍ରାଣୀ ଆପଣା ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","କାରଣ ସେ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟ ଅବଜ୍ଞା କଲା ଓ ତାହାଙ୍କର ଆଜ୍ଞାଲଙ୍ଘନ କଲା; ସେହି ପ୍ରାଣୀ ନିତାନ୍ତ ଉଚ୍ଛିନ୍ନ ହେବ, ତାହାର ଅପରାଧ ତାହା ଉପରେ ବର୍ତ୍ତିବ।” ");
INSERT INTO ory_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପ୍ରାନ୍ତରରେ ଥିବା ସମୟରେ ଏକ ମନୁଷ୍ୟକୁ ବିଶ୍ରାମବାରରେ କାଠ ସାଉଣ୍ଟିବାର ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ପୁଣି, ଯେଉଁମାନେ ତାକୁ କାଠ ସାଉଣ୍ଟିବାର ଦେଖିଲେ, ସେମାନେ ମୋଶା, ହାରୋଣ ଓ ସମସ୍ତ ମଣ୍ଡଳୀ ସାକ୍ଷାତକୁ ତାହାକୁ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ଆଉ ସେମାନେ ତାହାକୁ ରୁଦ୍ଧ କରି ରଖିଲେ, କାରଣ ତାହା ପ୍ରତି କି କର୍ତ୍ତବ୍ୟ, ତାହା ପ୍ରକାଶ ହୋଇ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ଏଥିରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ସେ ମନୁଷ୍ୟ ଅବଶ୍ୟ ହତ ହେବ; ସମଗ୍ର ମଣ୍ଡଳୀ ତାହାକୁ ଛାଉଣିର ବାହାରେ ପଥର ପକାଇ ବଧ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ତହିଁରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସମଗ୍ର ମଣ୍ଡଳୀ ତାହାକୁ ଛାଉଣି ବାହାରକୁ ଆଣି ପଥର ପକାଇଲେ, ତହୁଁ ସେ ମଲା। ");
INSERT INTO ory_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ ଓ ସେମାନଙ୍କୁ ଏହି ଆଜ୍ଞା ଦିଅ, ସେମାନେ ପୁରୁଷାନୁକ୍ରମେ ଆପଣା ଆପଣା ବସ୍ତ୍ରର ଅଞ୍ଚଳରେ ଝାଲର ପ୍ରସ୍ତୁତ କରନ୍ତୁ ଓ ପ୍ରତ୍ୟେକ ଅଞ୍ଚଳର ଝାଲର ଉପରେ ନୀଳ ସୂତ୍ର ଦିଅନ୍ତୁ; ");
INSERT INTO ory_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ତୁମ୍ଭେମାନେ ଯେପରି ସେହି ଝାଲର ଦେଖି ସଦାପ୍ରଭୁଙ୍କର ସମସ୍ତ ଆଜ୍ଞା ସ୍ମରଣ କରି ପାଳନ କରିବ ଓ ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣାର ଯେଉଁ ମନ ଓ ଚକ୍ଷୁ ଅନୁସାରେ ବ୍ୟଭିଚାର କରିଥାଅ, ତଦନୁସାରେ ଯେପରି ଭ୍ରମଣ ନ କରିବ, ");
INSERT INTO ory_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ଆମ୍ଭର ସମସ୍ତ ଆଜ୍ଞା ସ୍ମରଣ କରି ପାଳନ କରିବ ଓ ଯେପରି ଆପଣାମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପବିତ୍ର ହେବ, ଏଥିପାଇଁ ସେହି ଝାଲର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ସଦାପ୍ରଭୁ, ଆମ୍ଭେ, ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ହେବା ନିମନ୍ତେ ମିସର ଦେଶରୁ ତୁମ୍ଭମାନଙ୍କୁ ବାହାର କରି ଆଣିଅଛୁ; ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ସଦାପ୍ରଭୁ ଅଟୁ।” ");
INSERT INTO ory_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ଏଥିଉତ୍ତାରେ ଲେବୀର ପ୍ରପୌତ୍ର, କହାତର ପୌତ୍ର, ଯିଷ୍‍ହରର ପୁତ୍ର କୋରହ, ପୁଣି, ରୁବେନ୍‍ର ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ଇଲୀୟାବ୍‍ର ପୁତ୍ର ଦାଥନ, ଅବୀରାମ ଓ ପେଲତ୍‍ର ପୁତ୍ର ଓନ୍‍, ଦଳ ବାନ୍ଧିଲେ; ");
INSERT INTO ory_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ପୁଣି, ସେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ସୁଖ୍ୟାତିମନ୍ତ ଓ ସମାଜକୁ ଆହୂତ ମଣ୍ଡଳୀର ଦୁଇ ଶହ ପଚାଶ ଅଧିପତିଙ୍କ ସହିତ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ ଉଠିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ଆଉ ସେମାନେ ମୋଶା ଓ ହାରୋଣଙ୍କ ବିରୁଦ୍ଧରେ ଏକତ୍ର ହୋଇ ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଉପରେ ବହୁତ ନେଲଣି, ସମସ୍ତ ମଣ୍ଡଳୀର ପ୍ରତ୍ୟେକ ଜଣ ତ ପବିତ୍ର, ପୁଣି, ସଦାପ୍ରଭୁ ସେମାନଙ୍କ ମଧ୍ୟରେ ଅଛନ୍ତି, ତେବେ କାହିଁକି ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ସମାଜ ଉପରେ ଆପଣାମାନଙ୍କୁ ଉନ୍ନତ କରୁଅଛ?” ");
INSERT INTO ory_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ତହୁଁ ମୋଶା ତାହା ଶୁଣି ମୁହଁ ମାଡ଼ି ପଡ଼ିଲେ; ");
INSERT INTO ory_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ପୁଣି, ସେ କୋରହକୁ ଓ ତାହାର ଦଳସ୍ଥ ସମସ୍ତଙ୍କୁ କହିଲେ, “କିଏ ତାହାଙ୍କର ଲୋକ ଓ କିଏ ପବିତ୍ର, ଏହା ସଦାପ୍ରଭୁ କାଲି ଦେଖାଇବେ, ପୁଣି, ସେ ତାହାକୁ ଆପଣା ନିକଟକୁ ଆଣିବେ; ସେ ଯାହାକୁ ମନୋନୀତ କରିବେ, ତାହାକୁ ଆପଣା ନିକଟକୁ ଆଣିବେ। ");
INSERT INTO ory_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ତେବେ ଏହା କର, ତୁମ୍ଭେମାନେ ଅଙ୍ଗାରଧାନୀ ନିଅ, କୋରହ ଓ ତାହାର ଦଳସ୍ଥ ସମସ୍ତେ; ");
INSERT INTO ory_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ପୁଣି, କାଲି ତହିଁରେ ଅଗ୍ନି ଦିଅ, ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତହିଁ ଉପରେ ଧୂପ ଥୁଅ; ତହିଁରେ ସଦାପ୍ରଭୁ ଯେଉଁ ବ୍ୟକ୍ତିକୁ ମନୋନୀତ କରିବେ, ସେ ହିଁ ପବିତ୍ର ହେବ; ହେ ଲେବୀର ପୁତ୍ରମାନେ, ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଉପରେ ବହୁତ ନେଲଣି।” ");
INSERT INTO ory_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ଆଉ ମୋଶା କୋରହକୁ କହିଲେ, “ହେ ଲେବୀର ସନ୍ତାନଗଣ, ତୁମ୍ଭେମାନେ ଟିକିଏ ଶୁଣ। ");
INSERT INTO ory_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ଇସ୍ରାଏଲଙ୍କର ପରମେଶ୍ୱର ଯେ ତୁମ୍ଭମାନଙ୍କୁ ଇସ୍ରାଏଲ-ମଣ୍ଡଳୀରୁ ପୃଥକ କରି ସଦାପ୍ରଭୁଙ୍କ ଆବାସର ସେବା କରିବା ନିମନ୍ତେ ଓ ମଣ୍ଡଳୀ ସମ୍ମୁଖରେ ଠିଆ ହୋଇ ସେବା କରିବା ନିମନ୍ତେ ଆପଣାର ନିକଟବର୍ତ୍ତୀ କରିଅଛନ୍ତି, ");
INSERT INTO ory_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ପୁଣି, ସେ ଯେ ତୁମ୍ଭଙ୍କୁ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭର ସମସ୍ତ ଭ୍ରାତା ଲେବୀର ସନ୍ତାନଗଣକୁ ଆପଣାର ନିକଟବର୍ତ୍ତୀ କରିଅଛନ୍ତି, ଏହା କି ତୁମ୍ଭମାନଙ୍କ ଦୃଷ୍ଟିରେ କ୍ଷୁଦ୍ର ବିଷୟ? ଆହୁରି କି ତୁମ୍ଭେମାନେ ଯାଜକତ୍ୱର ଚେଷ୍ଟା କରୁଅଛ? ");
INSERT INTO ory_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ଏଥିପାଇଁ ସିନା ତୁମ୍ଭେ ଓ ତୁମ୍ଭର ଦଳସ୍ଥ ସମସ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ଏକମେଳି ହୋଇଅଛ; ଯେହେତୁ ହାରୋଣ କିଏ ଯେ, ତୁମ୍ଭେମାନେ ତାଙ୍କର ବିରୁଦ୍ଧରେ ବଚସା କରୁଅଛ?” ");
INSERT INTO ory_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ତହିଁରେ ମୋଶା ଇଲୀୟାବ୍‍ର ପୁତ୍ର ଦାଥନକୁ ଓ ଅବୀରାମଙ୍କୁ ଡାକିବା ପାଇଁ ଲୋକ ପଠାଇଲେ; ମାତ୍ର ସେମାନେ କହିଲେ, “ଆମ୍ଭେମାନେ ଯିବା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ତୁମ୍ଭେ ଆମ୍ଭମାନଙ୍କୁ ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଦେଶରୁ ବାହାର କରି ଏହି ପ୍ରାନ୍ତରରେ ମାରିବାକୁ ଆଣିଅଛ, ଏହା କି କ୍ଷୁଦ୍ର ବିଷୟ? ଆହୁରି ତୁମ୍ଭେ ଆପଣାକୁ ଆମ୍ଭମାନଙ୍କ ଉପରେ ରାଜା କରୁଅଛ। ");
INSERT INTO ory_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ତାହା ବ୍ୟତୀତ ତୁମ୍ଭେ ଦୁଗ୍ଧ ଓ ମଧୁ ପ୍ରବାହୀ ଦେଶକୁ ଆମ୍ଭମାନଙ୍କୁ ଆଣି ନାହଁ, କିଅବା ଶସ୍ୟକ୍ଷେତ୍ର ଓ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରର ଅଧିକାର ଆମ୍ଭମାନଙ୍କୁ ଦେଇ ନାହିଁ; ତୁମ୍ଭେ କି ଏହି ସମସ୍ତ ଲୋକଙ୍କର ଆଖି ଉପାଡ଼ି ପକାଇବ? ଆମ୍ଭେମାନେ ଯିବା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ତହିଁରେ ମୋଶା ଅତିଶୟ କ୍ରୋଧାନ୍ୱିତ ହୋଇ ଉଠିଲେ, ପୁଣି, ସେ ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ସେମାନଙ୍କର ନୈବେଦ୍ୟ ଗ୍ରହଣ କର ନାହିଁ; ଆମ୍ଭେ ସେମାନଙ୍କଠାରୁ ଗୋଟିଏ ଗଧ ନେଇ ନାହୁଁ, ଅବା ସେମାନଙ୍କ ମଧ୍ୟରୁ କାହାକୁ ହିଁ ହିଂସା କରି ନାହୁଁ।” ");
INSERT INTO ory_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ତେବେ ମୋଶା କୋରହକୁ କହିଲେ, “କାଲି ତୁମ୍ଭେ ଓ ତୁମ୍ଭର ସମସ୍ତ ମଣ୍ଡଳୀ, ତୁମ୍ଭେ ଓ ସେମାନେ, ପୁଣି, ହାରୋଣ, ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ ହୁଅ; ");
INSERT INTO ory_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ଅଙ୍ଗାରଧାନୀ ନିଅ ଓ ତହିଁ ଉପରେ ଧୂପ ଥୁଅ, ପୁଣି, ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ଜଣ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖକୁ ଆପଣା ଆପଣା ଅଙ୍ଗାରଧାନୀ, ଦୁଇ ଶହ ପଚାଶ ଅଙ୍ଗାରଧାନୀ ଆଣ; ମଧ୍ୟ ତୁମ୍ଭେ ଓ ହାରୋଣ, ଦୁହେଁ ଆପଣା ଆପଣା ଅଙ୍ଗାରଧାନୀ ଆଣ।” ");
INSERT INTO ory_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ଏଥିରେ ସେମାନେ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ଅଙ୍ଗାରଧାନୀ ନେଇ ତହିଁରେ ଅଗ୍ନି ଦେଲେ, ପୁଣି, ତହିଁ ଉପରେ ଧୂପ ଥୋଇ ମୋଶା ଓ ହାରୋଣଙ୍କ ସହିତ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାର ନିକଟରେ ଠିଆ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ପୁଣି, କୋରହ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାର ନିକଟରେ ସେମାନଙ୍କ ପ୍ରତିକୂଳରେ ସମସ୍ତ ମଣ୍ଡଳୀକୁ ଏକତ୍ର କଲା; ସେତେବେଳେ ସମସ୍ତ ମଣ୍ଡଳୀ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତାପ ପ୍ରକାଶିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ତୁମ୍ଭେମାନେ ଏହି ମଣ୍ଡଳୀ ମଧ୍ୟରୁ ଆପଣାମାନଙ୍କୁ ପୃଥକ କର, ତହିଁରେ ଆମ୍ଭେ ଏକ ନିମିଷରେ ସେମାନଙ୍କୁ ସଂହାର କରିବା।” ");
INSERT INTO ory_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ତହିଁରେ ସେମାନେ ମୁହଁ ମାଡ଼ି ପଡ଼ି କହିଲେ, “ହେ ପରମେଶ୍ୱର, ହେ ସମସ୍ତ ଶରୀରସ୍ଥ ଆତ୍ମାର ପରମେଶ୍ୱର, ଏକ ଜଣ ପାପ କଲେ କି ତୁମ୍ଭେ ସମସ୍ତ ମଣ୍ଡଳୀ ଉପରେ କୋପାନ୍ୱିତ ହେବ?” ");
INSERT INTO ory_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ତୁମ୍ଭେ ମଣ୍ଡଳୀକୁ କୁହ, ‘ତୁମ୍ଭେମାନେ କୋରହର, ଦାଥନର ଓ ଅବୀରାମର ଆବାସ-ଚତୁର୍ଦ୍ଦିଗରୁ ଉଠିଯାଅ।’” ");
INSERT INTO ory_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ତହିଁରେ ମୋଶା ଉଠି ଦାଥନ ଓ ଅବୀରାମ ନିକଟକୁ ଗଲେ ଓ ଇସ୍ରାଏଲର ପ୍ରାଚୀନବର୍ଗ ତାଙ୍କର ପଶ୍ଚାଦ୍‍ଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ତହୁଁ ସେ ମଣ୍ଡଳୀକୁ କହିଲେ, “ବିନୟ କରୁଅଛି, ତୁମ୍ଭେମାନେ ଏହି ଦୁଷ୍ଟ ଲୋକମାନଙ୍କ ତମ୍ବୁରୁ ଉଠିଯାଅ ଓ ସେମାନଙ୍କର କିଛିମାତ୍ର ସ୍ପର୍ଶ କର ନାହିଁ, ନୋହିଲେ ତୁମ୍ଭେମାନେ ସେମାନଙ୍କ ପାପସମୂହରେ ବିନଷ୍ଟ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ଏଥିରେ ସେମାନେ କୋରହର, ଦାଥନର ଓ ଅବୀରାମର ଆବାସ-ଚତୁର୍ଦ୍ଦିଗରୁ ଉଠିଗଲେ ପୁଣି, ଦାଥନ ଓ ଅବୀରାମ ବାହାରକୁ ଆସି ଆପଣା ଆପଣା ଭାର୍ଯ୍ୟା ଓ ପୁତ୍ର ଓ ପିଲାମାନଙ୍କ ସହିତ ଆପଣା ଆପଣା ତମ୍ବୁ ଦ୍ୱାରରେ ଠିଆ ହୋଇ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ତହୁଁ ମୋଶା କହିଲେ, “ଏହି ସମସ୍ତ କାର୍ଯ୍ୟ କରିବା ପାଇଁ ସଦାପ୍ରଭୁ ମୋତେ ପଠାଇଅଛନ୍ତି; ମୁଁ ଆପଣା ନିଜ ମନରୁ ତାହାସବୁ କରି ନାହିଁ, ତାହା ଏଥିରେ ତୁମ୍ଭେମାନେ ଜାଣିବ। ");
INSERT INTO ory_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ଯଦି ଏହି ଲୋକମାନେ ସମସ୍ତ ଲୋକଙ୍କ ସାଧାରଣ ମରଣରେ ମରନ୍ତି, କିଅବା ଯଦି ସମସ୍ତ ଲୋକଙ୍କ ଦଣ୍ଡ ଅନୁସାରେ ସେମାନଙ୍କ ଉପରେ ଦଣ୍ଡ ଘଟେ; ତେବେ ସଦାପ୍ରଭୁ ମୋତେ ପଠାଇ ନାହାନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ମାତ୍ର ସଦାପ୍ରଭୁ ଯଦି କୌଣସି ନୂତନ କର୍ମ କରନ୍ତି ଓ ପୃଥିବୀ ଆପଣା ମୁଖ ବିସ୍ତାର କରି ସେମାନଙ୍କୁ ଓ ସେମାନଙ୍କ ସର୍ବସ୍ୱ ଗ୍ରାସ କରେ ଓ ସେମାନେ ଜୀଅନ୍ତା ହୋଇ ପାତାଳକୁ ଧସି ଯାଆନ୍ତି; ତେବେ ସେମାନେ ଯେ ସଦାପ୍ରଭୁଙ୍କୁ ଅବଜ୍ଞା କରିଅଛନ୍ତି, ତାହା ତୁମ୍ଭେମାନେ ବୁଝିବ।” ");
INSERT INTO ory_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ଏଥିଉତ୍ତାରେ ଏପରି ହେଲା ଯେ, ସେ ଏହି କଥା କହିବାର ସମାପ୍ତ କରନ୍ତେ, ସେମାନଙ୍କ ଅଧଃସ୍ଥ ଭୂମି ଫାଟିଗଲା; ");
INSERT INTO ory_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ପୁଣି, ପୃଥିବୀ ଆପଣା ମୁଖ ବିସ୍ତାର କରି ସେମାନଙ୍କୁ, ସେମାନଙ୍କ ପରିଜନଗଣକୁ, କୋରହର ସପକ୍ଷ ସମସ୍ତ ଲୋକଙ୍କୁ ଓ ସେମାନଙ୍କ ସକଳ ସମ୍ପତ୍ତି ଗ୍ରାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ଏହିରୂପେ ସେମାନେ ଓ ସେମାନଙ୍କର ସମସ୍ତ ପରିଜନ ଜୀଅନ୍ତା ଥାଉ ଥାଉ ପାତାଳକୁ ଧସି ଗଲେ ଓ ପୃଥିବୀ ସେମାନଙ୍କ ଉପରେ ଆଚ୍ଛାଦନ କଲା, ତହିଁରେ ସେମାନେ ସମାଜ ମଧ୍ୟରୁ ଲୁପ୍ତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ପୁଣି, ସେମାନଙ୍କ ରବରେ ସେମାନଙ୍କ ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ସମସ୍ତ ଇସ୍ରାଏଲ ପଳାୟନ କଲେ, ଯେହେତୁ ସେମାନେ କହିଲେ, “କେଜାଣି ପୃଥିବୀ ଆମ୍ଭମାନଙ୍କୁ ଗ୍ରାସ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ଏଉତ୍ତାରେ ସଦାପ୍ରଭୁଙ୍କଠାରୁ ଅଗ୍ନି ନିର୍ଗତ ହୋଇ ଧୂପ ଉତ୍ସର୍ଗକାରୀ ସେହି ଦୁଇ ଶହ ପଚାଶ ଲୋକଙ୍କୁ ଗ୍ରାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ତୁମ୍ଭେ ହାରୋଣ ଯାଜକର ପୁତ୍ର ଇଲୀୟାସରକୁ କୁହ, ସେ ଦାହ ମଧ୍ୟରୁ ସେହି ସବୁ ଅଙ୍ଗାରଧାନୀ ବାହାର କରିନେଉ, ପୁଣି, ତୁମ୍ଭେ ସେହି ଅଗ୍ନି ସେଠାରେ ବିଞ୍ଚି ଦିଅ; କାରଣ ସେହି ସବୁ ପବିତ୍ର; ");
INSERT INTO ory_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ଆପଣା ଆପଣା ପ୍ରାଣର ବିରୁଦ୍ଧରେ ଏହି ପାପକର୍ମକାରୀମାନଙ୍କର ଅଙ୍ଗାରଧାନୀ ହିଁ (ପବିତ୍ର); ଏଣୁ ତାହାସବୁ ଯଜ୍ଞବେଦିର ମଣ୍ଡଣି ନିମନ୍ତେ ପିଟାପାତ୍ର କରାଯାଉ; ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତାହାସବୁ ଉତ୍ସର୍ଗ କରିଥିଲେ, ଏହି କାରଣରୁ ତାହାସବୁ ପବିତ୍ର; ପୁଣି, ତାହାସବୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପ୍ରତି ଚିହ୍ନସ୍ୱରୂପ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ତହିଁରେ ସେହି ଦଗ୍ଧ ଲୋକମାନେ ଯେଉଁ ଯେଉଁ ପିତ୍ତଳ ଅଙ୍ଗାରଧାନୀ ଉତ୍ସର୍ଗ କରିଥିଲେ, ଇଲୀୟାସର ଯାଜକ ସେହି ସବୁ ନେଲା; ");
INSERT INTO ory_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ମୋଶାଙ୍କ ଦ୍ୱାରା ସଦାପ୍ରଭୁ ଯେରୂପ କହିଥିଲେ, ତଦନୁସାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସ୍ମରଣାର୍ଥେ, ଅର୍ଥାତ୍‍, ହାରୋଣ-ବଂଶ ଭିନ୍ନ ଅନ୍ୟ ବଂଶୀୟ କୌଣସି ମନୁଷ୍ୟ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଧୂପ ଜାଳିବା ପାଇଁ ଯେପରି ନିକଟକୁ ନ ଯାଏ; ପୁଣି, କୋରହ ଓ ତାହାର ଦଳସ୍ଥ ଲୋକମାନଙ୍କ ପରି ନ ହୁଏ; ଏଥିପାଇଁ ଲୋକେ ଯଜ୍ଞବେଦିର ମଣ୍ଡଣି ନିମନ୍ତେ ତାହାସବୁ ପିଟିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ତଥାପି ଆରଦିନ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ ଓ ହାରୋଣଙ୍କ ବିରୁଦ୍ଧରେ ବଚସା କରି କହିଲେ, “ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଲୋକମାନଙ୍କୁ ବଧ କଲ।” ");
INSERT INTO ory_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ତହୁଁ ସମସ୍ତ ମଣ୍ଡଳୀ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ ଓ ହାରୋଣଙ୍କ ବିରୁଦ୍ଧରେ ଏକତ୍ର ହେବା ସମୟରେ ସେମାନେ ସମାଗମ-ତମ୍ବୁ ଆଡ଼େ ଅନାଇଲେ; ଆଉ ଦେଖ, ମେଘ ତାହା ଆଚ୍ଛାଦନ କରିଅଛି ଓ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତାପ ପ୍ରତ୍ୟକ୍ଷ ହୋଇଅଛି। ");
INSERT INTO ory_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ସେତେବେଳେ ମୋଶା ଓ ହାରୋଣ ସମାଗମ-ତମ୍ବୁ ସମ୍ମୁଖକୁ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ତୁମ୍ଭେମାନେ ଏହି ମଣ୍ଡଳୀ ମଧ୍ୟରୁ ଉଠିଯାଅ, ଆମ୍ଭେ ଏକ ନିମିଷରେ ସେମାନଙ୍କୁ ସଂହାର କରିବା; ଏଥିରେ ସେମାନେ ମୁହଁ ମାଡ଼ି ପଡ଼ିଲେ।” ");
INSERT INTO ory_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ତହୁଁ ମୋଶା ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆପଣା ଅଙ୍ଗାରଧାନୀ ନେଇ ତହିଁ ମଧ୍ୟରେ ଯଜ୍ଞବେଦିରୁ ଅଗ୍ନି ଦିଅ, ପୁଣି, ତହିଁ ଉପରେ ଧୂପ ଥୋଇ ଶୀଘ୍ର ମଣ୍ଡଳୀ ନିକଟକୁ ଯାଇ ସେମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କର; କାରଣ ସଦାପ୍ରଭୁଙ୍କଠାରୁ କ୍ରୋଧ ନିର୍ଗତ ହୋଇଅଛି; ମହାମାରୀ ଆରମ୍ଭ ହେଲାଣି।” ");
INSERT INTO ory_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ତହିଁରେ ହାରୋଣ ମୋଶାଙ୍କର କଥା ଅନୁସାରେ ତାହା ନେଇ ସମାଜ ମଧ୍ୟକୁ ଦୌଡ଼ି ଗଲେ; ସେହି ସମୟରେ ଦେଖ, ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ମହାମାରୀ ଆରମ୍ଭ ହୋଇଥିଲା; ତହିଁରେ ସେ ଧୂପ ଦେଇ ଲୋକମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ପୁଣି, ସେ ମୃତ ଓ ଜୀବିତ ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ଠିଆ ହେଲେ ତହିଁରେ ମହାମାରୀ ନିବୃତ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ଯେଉଁମାନେ କୋରହର କଥା ସକାଶୁ ମରିଥିଲେ, ସେମାନଙ୍କ ବ୍ୟତୀତ ଚଉଦ ହଜାର ସାତ ଶହ ଲୋକ ଏହି ମହାମାରୀରେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ପୁଣି, ମହାମାରୀ ନିବୃତ୍ତ ହୁଅନ୍ତେ, ହାରୋଣ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରରେ ମୋଶାଙ୍କ ନିକଟକୁ ଫେରି ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କଥା କୁହ, ସେମାନଙ୍କ ପିତୃଗୃହର ଅଧ୍ୟକ୍ଷମାନଙ୍କଠାରୁ ପ୍ରତ୍ୟେକ ପିତୃଗୃହ ନିମନ୍ତେ ଏକ ଏକ ଯଷ୍ଟି, ଏହିରୂପେ ବାର ଯଷ୍ଟି ଗ୍ରହଣ କର; ତୁମ୍ଭେ ପ୍ରତ୍ୟେକର ଯଷ୍ଟିରେ ପ୍ରତ୍ୟେକ ଲୋକର ନାମ ଲେଖ। ");
INSERT INTO ory_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ପୁଣି, ତୁମ୍ଭେ ଲେବୀର ଯଷ୍ଟିରେ ହାରୋଣର ନାମ ଲେଖିବ; କାରଣ ସେମାନଙ୍କ ପ୍ରତ୍ୟେକ ପିତୃଗୃହର ଅଧ୍ୟକ୍ଷ ନିମନ୍ତେ ଏକ ଏକ ଯଷ୍ଟି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ଆଉ ସମାଗମ-ତମ୍ବୁର ଯେଉଁ ସ୍ଥାନରେ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ସହିତ ସାକ୍ଷାତ କରୁ, ସେହି ସ୍ଥାନରେ ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ସମ୍ମୁଖରେ ତୁମ୍ଭେ ସେହି ସବୁ ରଖିବ। ");
INSERT INTO ory_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ଏହା କଲା ଉତ୍ତାରେ, ଆମ୍ଭେ ଯେଉଁ ବ୍ୟକ୍ତିକୁ ମନୋନୀତ କରିବା, ତାହାର ଯଷ୍ଟି ପୁଷ୍ପିତ ହେବ; ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ତୁମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ଯେଉଁ ବଚସା କରନ୍ତି, ସେହି ବଚସା ଆମ୍ଭେ ଆପଣା ନିକଟରୁ ନିବୃତ୍ତ କରାଇବା।” ");
INSERT INTO ory_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ଏଥିରେ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହନ୍ତେ, ସେମାନଙ୍କର ଅଧ୍ୟକ୍ଷ ସମସ୍ତେ ଆପଣା ଆପଣା ପିତୃଗୃହ ଅନୁସାରେ ପ୍ରତ୍ୟେକ ଅଧ୍ୟକ୍ଷ ନିମନ୍ତେ ଏକ ଏକ ଯଷ୍ଟି, ଏହିରୂପେ ବାର ଯଷ୍ଟି ତାଙ୍କୁ ଦେଲେ; ପୁଣି, ହାରୋଣଙ୍କର ଯଷ୍ଟି ସେମାନଙ୍କ ଯଷ୍ଟିସକଳର ମଧ୍ୟରେ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ତହୁଁ ମୋଶା ସାକ୍ଷ୍ୟ-ତମ୍ବୁରେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସେହି ସମସ୍ତ ଯଷ୍ଟି ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ଏଥିଉତ୍ତାରେ ଆରଦିନ ମୋଶା ସାକ୍ଷ୍ୟ-ତମ୍ବୁରେ ପ୍ରବେଶ କଲେ; ଆଉ ଦେଖ, ଲେବୀ ଗୃହ ନିମନ୍ତେ ଥିବା ହାରୋଣଙ୍କର ଯଷ୍ଟି ଅଙ୍କୁରିତ ହୋଇଅଛି, ପୁଣି, ଅଙ୍କୁର ବାହାର ହେଲା, ପୁଷ୍ପ ଫୁଟିଲା ଓ ପକ୍ୱ ବାଦାମ ଫଳିଲା। ");
INSERT INTO ory_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ତେବେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରୁ ସେହି ସକଳ ଯଷ୍ଟି ବାହାର କରି ଇସ୍ରାଏଲର ସମସ୍ତ ସନ୍ତାନଗଣର ସାକ୍ଷାତକୁ ଆଣିଲେ; ପୁଣି, ସେମାନେ ତାହା ଦେଖି ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ଯଷ୍ଟି ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଆମ୍ଭ ବିରୁଦ୍ଧରେ ଏହି ବିଦ୍ରୋହୀ ସନ୍ତାନଗଣର ବଚସା ଯେପରି ନିବୃତ୍ତ ହୁଏ ଓ ସେମାନଙ୍କର ମୃତ୍ୟୁୁ ନ ହୁଏ, ଏଥିପାଇଁ ସେମାନଙ୍କ ବିରୁଦ୍ଧରେ ଚିହ୍ନ ସ୍ୱରୂପେ ରଖାଯିବା ନିମନ୍ତେ ତୁମ୍ଭେ ହାରୋଣଙ୍କ ଯଷ୍ଟି ସାକ୍ଷ୍ୟ-ସିନ୍ଦୁକ ସମ୍ମୁଖରେ ରଖ।” ");
INSERT INTO ory_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ମୋଶା ସେରୂପ କଲେ; ସଦାପ୍ରଭୁ ତାଙ୍କୁ ଯେପରି ଆଜ୍ଞା ଦେଲେ, ସେ ସେହିପରି କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମୋଶାଙ୍କୁ କହିଲେ, “ଦେଖ, ଆମ୍ଭମାନଙ୍କର ପ୍ରାଣ ଯାଉଛି, ଆମ୍ଭେମାନେ ଉଚ୍ଛିନ୍ନ ହେଉ, ଆମ୍ଭେ ସମସ୍ତେ ଉଚ୍ଛିନ୍ନ ହେଉ। ");
INSERT INTO ory_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ଯେକେହି ନିକଟକୁ ଆସୁଅଛି, ଅର୍ଥାତ୍‍, ସଦାପ୍ରଭୁଙ୍କ ଆବାସ ନିକଟକୁ ଆସୁଅଛି, ସେ ମରୁଅଛି; ଆମ୍ଭେ ସମସ୍ତେ କି ପ୍ରାଣ ଛାଡ଼ି ଉଚ୍ଛିନ୍ନ ହେବା?” ");
INSERT INTO ory_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭ ପୁତ୍ରଗଣ ଓ ତୁମ୍ଭର ପିତୃବଂଶ, ତୁମ୍ଭେମାନେ ପବିତ୍ର ସ୍ଥାନଘଟିତ ଅପରାଧ ବହିବ; ପୁଣି, ତୁମ୍ଭେ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭ ପୁତ୍ରଗଣ ଯାଜକତ୍ୱ-ପଦଘଟିତ ଅପରାଧ ବୋହିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ଆଉ ତୁମ୍ଭେ ଲେବୀ ବଂଶୀୟ ତୁମ୍ଭର ଭ୍ରାତୃଗଣକୁ, ଅର୍ଥାତ୍‍, ତୁମ୍ଭର ପିତୃବଂଶୀୟମାନଙ୍କୁ ଆପଣା ସଙ୍ଗେ ନିକଟକୁ ଆଣ, ସେମାନେ ତୁମ୍ଭ ସହିତ ଯୋଗ ଦେବେ ଓ ତୁମ୍ଭର ସେବା କରିବେ; ମାତ୍ର ତୁମ୍ଭେ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭ ପୁତ୍ରଗଣ ସାକ୍ଷ୍ୟ-ତମ୍ବୁ ସମ୍ମୁଖରେ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ପୁଣି, ସେମାନେ ତୁମ୍ଭର ରକ୍ଷଣୀୟ ଓ ସମୁଦାୟ ତମ୍ବୁର ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବେ; ଯେପରି ସେମାନେ, ଅବା ତୁମ୍ଭେମାନେ ନ ମର, ଏଥିପାଇଁ ସେମାନେ କେବଳ ପବିତ୍ର ସ୍ଥାନର ପାତ୍ର ନିକଟକୁ ଓ ବେଦି ନିକଟକୁ ଯିବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ସେମାନେ ତୁମ୍ଭ ସହିତ ଯୋଗ ଦେଇ ତମ୍ବୁର ସମସ୍ତ ସେବାକର୍ମ ଅନୁସାରେ ସମାଗମ-ତମ୍ବୁର ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବେ, ଆଉ କୌଣସି ଅନ୍ୟ ବଂଶୀୟ ଲୋକ ସେମାନଙ୍କ ନିକଟକୁ ଯିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପ୍ରତି ଯେପରି ଆଉ କ୍ରୋଧ ଉପସ୍ଥିତ ନ ହୁଏ, ଏଥିପାଇଁ ତୁମ୍ଭେମାନେ ପବିତ୍ର ସ୍ଥାନର ରକ୍ଷଣୀୟ ଓ ବେଦିର ରକ୍ଷଣୀୟ ରକ୍ଷା କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ଆଉ ଆମ୍ଭେ, ଦେଖ, ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ ତୁମ୍ଭମାନଙ୍କର ଭ୍ରାତୃଗଣ ଲେବୀୟମାନଙ୍କୁ ଗ୍ରହଣ କରିଅଛୁ, ସେମାନେ ସମାଗମ-ତମ୍ବୁର ସେବାକର୍ମ ନିମନ୍ତେ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଦତ୍ତ ଦାନ ଅଟନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ଏଣୁ ତୁମ୍ଭେ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭ ପୁତ୍ରଗଣ, ତୁମ୍ଭେମାନେ ବେଦି ସମ୍ବନ୍ଧୀୟ ସକଳ ବିଷୟରେ ଓ ବିଚ୍ଛେଦ ବସ୍ତ୍ର ଭିତରେ ଆପଣାର ଯାଜକତ୍ୱ ପାଳନ କରିବ ଓ ତୁମ୍ଭେମାନେ ସେବା କରିବ। ଆମ୍ଭେ (ଆପଣା) ଦାନଜନିତ ସେବା ରୂପେ ତୁମ୍ଭମାନଙ୍କୁ ଯାଜକତ୍ୱ ପଦ ଦେଲୁ; ମାତ୍ର ଯେଉଁ ଅନ୍ୟ ବଂଶୀୟ ଲୋକ ନିକଟକୁ ଆସେ, ତାହାର ପ୍ରାଣଦଣ୍ଡ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ହାରୋଣଙ୍କୁ କହିଲେ, “ଆହୁରି ଆମ୍ଭେ, ଦେଖ, ଆମ୍ଭେ ଆପଣା ଉତ୍ତୋଳନୀୟ ଉପହାର, ଅର୍ଥାତ୍‍, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ପବିତ୍ରୀକୃତ ଦ୍ରବ୍ୟର ଭାର ତୁମ୍ଭଙ୍କୁ ଦେଲୁ, ତୁମ୍ଭର ଅଭିଷେକ ସକାଶୁ ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭର ସନ୍ତାନଗଣକୁ ଅନନ୍ତକାଳୀନ ଅଧିକାର ନିମନ୍ତେ ତାହାସବୁ ଦେଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ଅଗ୍ନିକୃତ ମହାପବିତ୍ର ଉପହାର ମଧ୍ୟରୁ ରକ୍ଷିତ ଏହାସବୁ ତୁମ୍ଭର ହେବ; ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ସେମାନେ ଯାହା ଉତ୍ସର୍ଗ କରିବେ, ଏପରି ସେମାନଙ୍କର ପ୍ରତ୍ୟେକ ଉପହାର, ଅର୍ଥାତ୍‍, ସେମାନଙ୍କର ପ୍ରତ୍ୟେକ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ସେମାନଙ୍କର ପ୍ରତ୍ୟେକ ପାପାର୍ଥକ ବଳି ଓ ସେମାନଙ୍କର ପ୍ରତ୍ୟେକ ଦୋଷାର୍ଥକ ବଳି ତୁମ୍ଭ ଓ ତୁମ୍ଭ ପୁତ୍ରଗଣ ନିମନ୍ତେ ମହାପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ତୁମ୍ଭେ ତାହା ମହାପବିତ୍ର ଦ୍ରବ୍ୟ ଭାବି ତହିଁରୁ ଭୋଜନ କରିବ; ପ୍ରତ୍ୟେକ ପୁରୁଷ ତହିଁରୁ ଭୋଜନ କରିବ; ତାହା ତୁମ୍ଭ ପ୍ରତି ପବିତ୍ର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","ଆଉ ଏହା ତୁମ୍ଭର ଅଟେ; ଅର୍ଥାତ୍‍, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ସମସ୍ତ ଦୋଳନୀୟ ନୈବେଦ୍ୟର ଦାନ ମଧ୍ୟରୁ ଉତ୍ତୋଳନୀୟ ଉପହାର; ଆମ୍ଭେ ଅନନ୍ତକାଳୀନ ଅଧିକାରାର୍ଥେ ତାହାସବୁ ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭର ପୁତ୍ର ଓ କନ୍ୟାଗଣଙ୍କୁ ଦେଲୁ; ତୁମ୍ଭ ଗୃହସ୍ଥିତ ପ୍ରତ୍ୟେକ ଶୁଚି ଲୋକ ତାହା ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","ସେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଆପଣାମାନଙ୍କର ସମସ୍ତ ଉତ୍ତମ ତୈଳ ଓ ସମସ୍ତ ଉତ୍ତମ ଦ୍ରାକ୍ଷାଫଳ ଓ ଶସ୍ୟ, ଯେଉଁ ଯେଉଁ ପ୍ରଥମଜାତ ଫଳ ଉତ୍ସର୍ଗ କରିବେ, ତାହାସବୁ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଦେଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ସେମାନେ ଆପଣା ଆପଣା ଭୂମିରୁ ଉତ୍ପନ୍ନ ଯେଉଁସବୁ ପ୍ରଥମ ପକ୍ୱ ଫଳ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରନ୍ତି, ସେହି ସବୁ ତୁମ୍ଭର ହେବ; ତୁମ୍ଭ ଗୃହସ୍ଥିତ ପ୍ରତ୍ୟେକ ଶୁଚି ଲୋକ ତାହା ଭୋଜନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ଇସ୍ରାଏଲ ମଧ୍ୟରେ ସମସ୍ତ ଉତ୍ସର୍ଗୀକୃତ ବସ୍ତୁସବୁ ତୁମ୍ଭର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ସେମାନେ ମନୁଷ୍ୟ କିମ୍ବା ପଶୁମାନଙ୍କ ମଧ୍ୟରୁ ଯେଉଁ ସମସ୍ତ ପ୍ରଥମଜାତ ଗର୍ଭର ଫଳ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରନ୍ତି, ସେହି ସମସ୍ତ ତୁମ୍ଭର ହେବ; ତଥାପି ତୁମ୍ଭେ ମନୁଷ୍ୟର ପ୍ରଥମଜାତକୁ ଅବଶ୍ୟ ମୁକ୍ତ କରିବ, ପୁଣି, ତୁମ୍ଭେ ଅଶୁଚି ପଶୁର ପ୍ରଥମଜାତକୁ ମୁକ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ପୁଣି, ଯେଉଁମାନେ ଏକ ମାସ ବୟସ୍କ ଅବଧି ମୁକ୍ତ କରାଯିବେ, ସେହି ସମସ୍ତଙ୍କୁ ତୁମ୍ଭର ନିରୂପଣୀୟ ମୂଲ୍ୟରେ ପବିତ୍ର ସ୍ଥାନର କୋଡ଼ିଏ ଗେରା ପରିମିତ ଶେକଲ ଅନୁସାରେ ପାଞ୍ଚ ଶେକଲ ରୂପାରେ ମୁକ୍ତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ମାତ୍ର ତୁମ୍ଭେ ଗୋରୁର ପ୍ରଥମଜାତକୁ ଅବା ମେଷର ପ୍ରଥମଜାତକୁ ଅବା ଛାଗର ପ୍ରଥମଜାତକୁ ମୁକ୍ତ କରିବ ନାହିଁ, ସେମାନେ ପବିତ୍ର; ତୁମ୍ଭେ ବେଦି ଉପରେ ସେମାନଙ୍କର ରକ୍ତ ସେଚନ କରିବ, ପୁଣି, ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ନିମନ୍ତେ ସେମାନଙ୍କର ମେଦ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ଆଉ ସେମାନଙ୍କର ମାଂସ ତୁମ୍ଭର ହେବ, ଯେପରି ଦୋଳନୀୟ ନୈବେଦ୍ୟାର୍ଥକ ବକ୍ଷ ଓ ଦକ୍ଷିଣ ଚଟୁଆ, ସେପରି ତାହା ତୁମ୍ଭର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯେଉଁ ସମସ୍ତ ବସ୍ତୁ ପବିତ୍ର କରି ଉତ୍ତୋଳନୀୟ ଉପହାର ରୂପେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରନ୍ତି, ସେସକଳ ଆମ୍ଭେ ଅନନ୍ତକାଳୀନ ଅଧିକାରାର୍ଥେ ତୁମ୍ଭକୁ ଓ ତୁମ୍ଭ ସହିତ ତୁମ୍ଭ ପୁତ୍ର ଓ କନ୍ୟାଗଣଙ୍କୁ ଦେଲୁ; ତୁମ୍ଭ ଓ ତୁମ୍ଭ ସଙ୍ଗେ ତୁମ୍ଭ ବଂଶ ପକ୍ଷରେ ଏହା ସଦାପ୍ରଭୁଙ୍କ ସାକ୍ଷାତରେ ଅନନ୍ତକାଳୀନ ଲବଣର ନିୟମ।” ");
INSERT INTO ory_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ଆହୁରି ସଦାପ୍ରଭୁ ହାରୋଣଙ୍କୁ କହିଲେ, “ସେମାନଙ୍କ ଭୂମିରେ ତୁମ୍ଭର କୌଣସି ଅଧିକାର ରହିବ ନାହିଁ; ଓ ସେମାନଙ୍କ ମଧ୍ୟରେ ତୁମ୍ଭର କୌଣସି ବାଣ୍ଟ ରହିବ ନାହିଁ; ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ମଧ୍ୟରେ ଆମ୍ଭେ ହିଁ ତୁମ୍ଭର ବାଣ୍ଟ ଓ ତୁମ୍ଭର ଅଧିକାର। ");
INSERT INTO ory_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ଆଉ ଦେଖ, ଲେବୀ-ସନ୍ତାନଗଣ ଯେଉଁ ସେବାକାର୍ଯ୍ୟ କରନ୍ତି, ସମାଗମ-ତମ୍ବୁ ସମ୍ବନ୍ଧୀୟ ସେମାନଙ୍କ ସେହି ସେବାକାର୍ଯ୍ୟର ପରିଶୋଧରେ ଆମ୍ଭେ ସେମାନଙ୍କ ଅଧିକାରାର୍ଥେ ଇସ୍ରାଏଲ ମଧ୍ୟରେ ସମସ୍ତ ଦଶମାଂଶ ଦେଲୁ। ");
INSERT INTO ory_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ଆଉ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ପାପ ବୋହି ଯେପରି ନ ମରନ୍ତି, ଏଥିପାଇଁ, ଏହି ସମୟଠାରୁ ସେମାନେ ସମାଗମ-ତମ୍ବୁ ନିକଟକୁ ଆସିବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ମାତ୍ର ଲେବୀୟମାନେ ସମାଗମ-ତମ୍ବୁର ସେବାକାର୍ଯ୍ୟ କରିବେ ଓ ସେମାନେ ଆପଣା ଆପଣା ଅପରାଧ ବୋହିବେ; ଏହା ତୁମ୍ଭମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମସ୍ଥାୟୀ ଅନନ୍ତକାଳୀନ ବିଧି, ପୁଣି, ସେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ କୌଣସି ଅଧିକାର ପାଇବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","କାରଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ତୋଳନୀୟ ଉପହାର ରୂପେ ଯେଉଁ ଦଶମାଂଶ ଉତ୍ସର୍ଗ କରନ୍ତି, ତାହା ଆମ୍ଭେ ଲେବୀୟମାନଙ୍କୁ ଅଧିକାରାର୍ଥେ ଦେଲୁ; ଏହେତୁ ଆମ୍ଭେ ସେମାନଙ୍କ ବିଷୟରେ କହିଲୁ, ‘ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ସେମାନେ କୌଣସି ଅଧିକାର ପାଇବେ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ଆହୁରି ତୁମ୍ଭେ ଲେବୀୟମାନଙ୍କୁ କହିବ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଅଧିକାରାର୍ଥେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ଯେଉଁ ଦଶମାଂଶ ତୁମ୍ଭମାନଙ୍କୁ ଦେଲୁ, ‘ତାହା ଯେଉଁ ସମୟରେ ତୁମ୍ଭେ ସେମାନଙ୍କଠାରୁ ଗ୍ରହଣ କରିବ, ସେହି ସମୟରେ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ତୋଳନୀୟ ଉପହାର ରୂପେ ସେହି ଦଶମାଂଶର ଦଶମାଂଶ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ତୁମ୍ଭମାନଙ୍କ ଏହି ଉତ୍ତୋଳନୀୟ ଉପହାର ଖଳାର ଶସ୍ୟ ତୁଲ୍ୟ ଓ ଦ୍ରାକ୍ଷାଯନ୍ତ୍ରର ପୂର୍ଣ୍ଣତା ତୁଲ୍ୟ ତୁମ୍ଭମାନଙ୍କ ପକ୍ଷରେ ଗଣାଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ଏହିରୂପେ ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ଯେଉଁ ଦଶମାଂଶ ଗ୍ରହଣ କରିବ, ତହିଁରୁ ତୁମ୍ଭେମାନେ ହିଁ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ତୋଳନୀୟ ଉପହାର ଉତ୍ସର୍ଗ କରିବ; ପୁଣି, ତହିଁରୁ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉତ୍ତୋଳନୀୟ ଉପହାର ହାରୋଣ ଯାଜକକୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ତୁମ୍ଭମାନଙ୍କର ପ୍ରାପ୍ତ ସମସ୍ତ ଦାନ ମଧ୍ୟରୁ ସେ ସଦାପ୍ରଭୁଙ୍କ ଉତ୍ତୋଳନୀୟ ଉପହାର, ଅର୍ଥାତ୍‍, ତହିଁର ସମସ୍ତ ଉତ୍ତମ ଦ୍ରବ୍ୟରୁ ତହିଁର ପବିତ୍ର ଅଂଶ ଉତ୍ସର୍ଗ କରିବ।’ ");
INSERT INTO ory_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ଏହେତୁ ତୁମ୍ଭେ ସେମାନଙ୍କୁ କହିବ, ‘ତୁମ୍ଭେମାନେ ଯେଉଁ ସମୟରେ ତହିଁରୁ ଉତ୍ତମ ଦ୍ରବ୍ୟ ଉତ୍ତୋଳନୀୟ ଉପହାର ରୂପେ ଉତ୍ସର୍ଗ କରିବ, ସେହି ସମୟରେ ତାହା ଲେବୀୟମାନଙ୍କ ପକ୍ଷରେ ଖଳାରୁ ଉତ୍ପନ୍ନ ଦ୍ରବ୍ୟ ଓ ଦ୍ରାକ୍ଷାଯନ୍ତ୍ରରୁ ଉତ୍ପନ୍ନ ଦ୍ରବ୍ୟ ବୋଲି ଗଣାଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ପୁଣି, ତୁମ୍ଭେମାନେ ଓ ତୁମ୍ଭମାନଙ୍କ ପରିଜନଗଣ ସବୁ ସ୍ଥାନରେ ତାହା ଭୋଜନ କରିବ; କାରଣ ତାହା ସମାଗମ-ତମ୍ବୁରେ କୃତ ତୁମ୍ଭମାନଙ୍କ ସେବାକାର୍ଯ୍ୟ ପରିଶୋଧରେ ତୁମ୍ଭମାନଙ୍କର ପୁରସ୍କାର ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ଆଉ ତହିଁରୁ ସେହି ଉତ୍ତମ ଦ୍ରବ୍ୟ ଉପହାର ରୂପେ ଉତ୍ସର୍ଗ କଲେ, ତୁମ୍ଭେମାନେ ତଦ୍ଦ୍ୱାରା ଘଟିତ କୌଣସି ପାପ ବୋହିବ ନାହିଁ; ପୁଣି, ତୁମ୍ଭେମାନେ ଯେପରି ନ ମର, ଏଥିପାଇଁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ପବିତ୍ର ଦ୍ରବ୍ୟ ଅପବିତ୍ର କରିବ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ସଦାପ୍ରଭୁ ଏହି ଶାସ୍ତ୍ରୀୟ ବିଧି କହି ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ଯେଉଁଠାରେ କଳଙ୍କ ନାହିଁ ଓ ଯାହା ଉପରେ କେବେ ଯୁଆଳି ଦିଆଯାଇ ନାହିଁ, ଏପରି ଏକ ନିଖୁନ୍ତା ଲାଲି ଗାଭୀକୁ ସେମାନେ ତୁମ୍ଭ ନିକଟକୁ ଆଣନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ତହୁଁ ତୁମ୍ଭେମାନେ ସେହି ଗାଭୀକୁ ଇଲୀୟାସର ଯାଜକକୁ ଦେବ, ପୁଣି, ସେ ତାହାକୁ ଛାଉଣି ବାହାରକୁ ଆଣନ୍ତେ, ଜଣେ ତାହା ସମ୍ମୁଖରେ ତାକୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ତହିଁରେ ଇଲୀୟାସର ଯାଜକ ଆପଣା ଅଙ୍ଗୁଳି ଦ୍ୱାରା ତାହାର ରକ୍ତରୁ ନେଇ ସମାଗମ-ତମ୍ବୁ ସମ୍ମୁଖରେ ସାତ ଥର ତାହାର ରକ୍ତ ସେଚନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ଆଉ ଜଣେ ତାହାର ଦୃଷ୍ଟିଗୋଚରରେ ସେହି ଗାଭୀକୁ ଦଗ୍ଧ କରିବ; ସେ ତାହାର ଗୋମୟ ସହିତ ଚର୍ମ ଓ ମାଂସ ଓ ରକ୍ତ ଦଗ୍ଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ତହୁଁ ଯାଜକ ଏରସ କାଠ, ଏସୋବ ଓ ସିନ୍ଦୂର ବର୍ଣ୍ଣ (ଲୋମ) ନେଇ ସେହି ଗାଭୀଦାହର ଅଗ୍ନି ମଧ୍ୟରେ ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ତେବେ ଯାଜକ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ଶରୀରକୁ ଜଳରେ ସ୍ନାନ କରାଇବ; ତହିଁ ଉତ୍ତାରେ ସେ ଛାଉଣିକୁ ଆସିବ, ପୁଣି, ଯାଜକ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ଆଉ ଯେଉଁ ଲୋକ ସେହି ଗାଭୀକୁ ଦଗ୍ଧ କରିବ, ସେ ଜଳରେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ, ଆପଣା ଶରୀରକୁ ଜଳରେ ସ୍ନାନ କରାଇବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ଏଉତ୍ତାରେ କୌଣସି ଶୁଚି ଲୋକ ସେହି ଗାଭୀର ଭସ୍ମ ସଂଗ୍ରହ କରି ଛାଉଣିର ବାହାରେ କୌଣସି ଶୁଚି ସ୍ଥାନରେ ରହିବ; ପୁଣି, ତାହା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ମଣ୍ଡଳୀ ପାଇଁ ଅଶୌଚାର୍ଥକ ଜଳ ନିମନ୍ତେ ରଖାଯିବ; ତାହା ପାପାର୍ଥକ ବଳି ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ଆଉ ଯେଉଁ ଲୋକ ସେହି ଗାଭୀର ଭସ୍ମ ସଂଗ୍ରହ କରେ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ ଓ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ; ଏହା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଓ ସେମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରବାସକାରୀ ବିଦେଶୀର ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","ପୁଣି, ଯେକେହି କୌଣସି ମନୁଷ୍ୟର ଶବ ଛୁଏଁ, ସେ ସାତ ଦିନ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ସେ ତୃତୀୟ ଦିନରେ ତଦ୍ଦ୍ୱାରା ଆପଣାକୁ ପରିଷ୍କାର କରିବ, ସପ୍ତମ ଦିନରେ ସେ ଶୁଚି ହେବ; ମାତ୍ର ଯଦି ସେ ତୃତୀୟ ଦିନରେ ଆପଣାକୁ ପରିଷ୍କାର ନ କରେ, ତେବେ ସେ ସପ୍ତମ ଦିନରେ ଶୁଚି ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ଯଦି କେହି କୌଣସି ମୃତ ମନୁଷ୍ୟର ଶବ ଛୁଇଁ ଆପଣାକୁ ପରିଷ୍କାର ନ କରେ, ତେବେ ସେ ସଦାପ୍ରଭୁଙ୍କ ଆବାସ ଅଶୁଚି କରେ; ସେହି ପ୍ରାଣୀ ଇସ୍ରାଏଲ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ; ତାହା ଉପରେ ଅଶୌଚାର୍ଥକ ଜଳ ଛିଞ୍ଚା ଯାଇ ନ ଥିବାରୁ ସେ ଅଶୁଚି ହେବ; ତାହାର ଅଶୁଚିତା ତାହାଠାରେ ଥାଏ। ");
INSERT INTO ory_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","କୌଣସି ମନୁଷ୍ୟ ତମ୍ବୁ ଭିତରେ ମଲେ, ତହିଁର ବ୍ୟବସ୍ଥା ଏହି; ଯେକେହି ସେହି ତମ୍ବୁକୁ ଆସେ ଓ ସେହି ତମ୍ବୁରେ ଥାଏ, ସେ ସାତ ଦିନ ଅଶୁଚି ହୋଇ ରହିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ଆଉ ପ୍ରତ୍ୟେକ ମେଲା ପାତ୍ର, ଯହିଁରେ ଢାଙ୍କୁଣୀ ବନ୍ଧା ନ ଥାଏ, ତାହା ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ପୁଣି, ଯେକେହି ମେଲା କ୍ଷେତ୍ରରେ ଖଡ୍ଗହତ କିମ୍ବା ମୃତ ଦେହ କିମ୍ବା ମନୁଷ୍ୟର ଅସ୍ଥି କିମ୍ବା କବର ଛୁଏଁ, ସେ ସାତ ଦିନ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","ଆଉ ଲୋକମାନେ ସେହି ଅଶୁଚି ଲୋକ ନିମନ୍ତେ ପାପାର୍ଥରେ ଦଗ୍ଧ ବଳିର ଭସ୍ମ ନେବେ ଓ ଏକ ପାତ୍ରରେ ତାହା ରଖି ତହିଁ ଉପରେ ସ୍ରୋତଜଳ ଦିଆଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ଏଉତ୍ତାରେ କୌଣସି ଶୁଚି ମନୁଷ୍ୟ ଏସୋବ ଶାଖା ନେଇ ଏହି ଜଳରେ ଡୁବାଇ ସେହି ତମ୍ବୁ ଉପରେ ଓ ସମସ୍ତ ପାତ୍ର ଉପରେ ଓ ସେଠାରେ ଥିବା ସମସ୍ତ ଲୋକ ଉପରେ, ପୁଣି, ଅସ୍ଥି କିମ୍ବା ହତ କିମ୍ବା ମୃତ କିମ୍ବା କବର ଛୁଇଁବା ଲୋକ ଉପରେ ତାହା ଛିଞ୍ଚିବ। ");
INSERT INTO ory_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ପୁଣି, ସେହି ଶୁଚି ଲୋକ ତୃତୀୟ ଦିନରେ ଓ ସପ୍ତମ ଦିନରେ ଅଶୁଚି ଲୋକ ଉପରେ ତାହା ଛିଞ୍ଚିବ; ତହୁଁ ସେ ସପ୍ତମ ଦିନରେ ଆପଣାକୁ ପରିଷ୍କାର କରିବ ଓ ଆପଣା ବସ୍ତ୍ର ଧୋଇ ଆପେ ଜଳରେ ସ୍ନାନ କରିବ ଓ ସନ୍ଧ୍ୟା ସମୟରେ ଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ମାତ୍ର ଯେଉଁ ଲୋକ ଅଶୁଚି ହୋଇ ଆପଣାକୁ ପରିଷ୍କାର ନ କରିବ, ସେହି ପ୍ରାଣୀ ସମାଜ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେବ, କାରଣ ସେ ସଦାପ୍ରଭୁଙ୍କର ପବିତ୍ର ସ୍ଥାନ ଅଶୁଚି କଲା; ତାହା ଉପରେ ଅଶୌଚାର୍ଥକ ଜଳ ସେଚିତ ହେଲା ନାହିଁ; ସେ ଅଶୁଚି। ");
INSERT INTO ory_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ଏହା ସେମାନଙ୍କ ପାଳନୀୟ ଅନନ୍ତକାଳୀନ ବିଧି ହେବ; ଆଉ ଯେକେହି ସେହି ଅଶୌଚାର୍ଥକ ଜଳ ସେଚନ କରେ, ସେ ଆପଣା ବସ୍ତ୍ର ଧୋଇବ; ପୁଣି, ଯେକେହି ସେହି ଅଶୌଚାର୍ଥକ ଜଳ ଛୁଏଁ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ପୁଣି, ସେ ଅଶୁଚି ଲୋକ ଯାହା କିଛି ଛୁଏଁ, ତାହା ଅଶୁଚି ହେବ; ଆଉ ଯେଉଁ ପ୍ରାଣୀ ତାହା ଛୁଏଁ, ସେ ସନ୍ଧ୍ୟା ପର୍ଯ୍ୟନ୍ତ ଅଶୁଚି ରହିବ।” ");
INSERT INTO ory_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ସମସ୍ତ ମଣ୍ଡଳୀ ପ୍ରଥମ ମାସରେ ସୀନ୍‍ ପ୍ରାନ୍ତରରେ ଉପସ୍ଥିତ ହେଲେ ଓ ଲୋକମାନେ କାଦେଶରେ ବାସ କଲେ; ପୁଣି, ସେହି ସ୍ଥାନରେ ମରୀୟମ ମଲେ ଓ ସେଠାରେ ତାଙ୍କୁ କବର ଦିଆଗଲା। ");
INSERT INTO ory_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ଆଉ ସେହି ସ୍ଥାନରେ ମଣ୍ଡଳୀ ନିମନ୍ତେ ଜଳ ନ ଥିଲା; ତହିଁରେ ଲୋକମାନେ ମୋଶାଙ୍କ ଓ ହାରୋଣଙ୍କ ବିରୁଦ୍ଧରେ ଏକତ୍ର ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ପୁଣି, ଲୋକମାନେ ମୋଶାଙ୍କ ସହିତ ବିବାଦ କରି କହିଲେ, “ହାୟ, ଆମ୍ଭମାନଙ୍କ ଭାଇମାନେ ଯେତେବେଳେ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ମଲେ, ସେହି ସମୟରେ ଯଦି ଆମ୍ଭେମାନେ ମରିଥାʼନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ତୁମ୍ଭେମାନେ କାହିଁକି ସଦାପ୍ରଭୁଙ୍କ ସମାଜକୁ ବାହାର କରି ଏହି ପ୍ରାନ୍ତରକୁ ଆଣିଲ, ଯେପରିକି ଆମ୍ଭେମାନେ ଓ ଆମ୍ଭମାନଙ୍କର ପଶୁମାନେ ଏହିଠାରେ ମରିବୁ? ");
INSERT INTO ory_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ଆଉ ତୁମ୍ଭେମାନେ କାହିଁକି ଆମ୍ଭମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲ, କି ଏହି କଦର୍ଯ୍ୟ ସ୍ଥାନକୁ ଆଣିବାକୁ? ଏ ତ ଶସ୍ୟ କି ଡିମ୍ବିରି କି ଦ୍ରାକ୍ଷା କି ଡାଳିମ୍ବର ସ୍ଥାନ ନୁହେଁ; କିଅବା ଏଠାରେ ପିଇବାକୁ ଜଳ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ଏଥିରେ ମୋଶା ଓ ହାରୋଣ ସମାଜ ସାକ୍ଷାତରୁ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରକୁ ଯାଇ ମୁହଁ ମାଡ଼ି ପଡ଼ିଲେ; ତହୁଁ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତାପ ସେମାନଙ୍କ ପ୍ରତି ପ୍ରକାଶ ପାଇଲା। ");
INSERT INTO ory_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ତୁମ୍ଭେ ଯଷ୍ଟି ନିଅ, ପୁଣି, ତୁମ୍ଭେ ଓ ତୁମ୍ଭ ଭାଇ ହାରୋଣ ମଣ୍ଡଳୀକୁ ଏକତ୍ର କର, ଆଉ ତୁମ୍ଭେମାନେ ସେମାନଙ୍କ ଦୃଷ୍ଟିଗୋଚରରେ ସେହି ଶୈଳକୁ ଆପଣା ଜଳ ଦେବା ପାଇଁ ଆଜ୍ଞା ଦିଅ; ତହିଁରେ ତୁମ୍ଭେ ସେମାନଙ୍କ ନିମନ୍ତେ ଶୈଳରୁ ଜଳ ବାହାର କରି ମଣ୍ଡଳୀକୁ ଓ ସେମାନଙ୍କ ପଶୁଗଣକୁ ପାନ କରାଇବ।” ");
INSERT INTO ory_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ତହୁଁ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରୁ ତାହାଙ୍କ ଆଜ୍ଞା ପ୍ରମାଣେ ଯଷ୍ଟି ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ପୁଣି, ମୋଶା ଓ ହାରୋଣ ସେହି ଶୈଳ ସମ୍ମୁଖରେ ସମାଜକୁ ଏକତ୍ର କଲେ, ଆଉ ସେ ସେମାନଙ୍କୁ କହିଲେ, “ହେ ବିଦ୍ରୋହୀଗଣ, ଶୁଣ, ଆମ୍ଭେମାନେ କି ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଏହି ଶୈଳରୁ ଜଳ ବାହାର କରିବା?” ");
INSERT INTO ory_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ଏଉତ୍ତାରେ ମୋଶା ହସ୍ତ ଉଠାଇ ଆପଣା ଯଷ୍ଟିରେ ସେହି ଶୈଳକୁ ଦୁଇ ଥର ଆଘାତ କଲେ; ତହିଁରେ ପ୍ରଚୁର ଜଳ ବାହାରିଲା, ପୁଣି, ମଣ୍ଡଳୀ ଓ ସେମାନଙ୍କ ପଶୁଗଣ ପାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ଏଥିରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ସାକ୍ଷାତରେ ଆମ୍ଭକୁ ପବିତ୍ର ବୋଲି ମାନ୍ୟ କରିବାକୁ ଆମ୍ଭଠାରେ ବିଶ୍ୱାସ କଲ ନାହିଁ, ଏହେତୁ ଆମ୍ଭେ ଏହି ମଣ୍ଡଳୀକୁ ଯେଉଁ ଦେଶ ଦେଇଅଛୁ, ସେହି ଦେଶରେ ତୁମ୍ଭେମାନେ ସେମାନଙ୍କୁ ପ୍ରବେଶ କରାଇବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ଏହିସବୁ ମିରୀବାଃ ଜଳ, (ବିବାଦର ଜଳ); ଯେହେତୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସଦାପ୍ରଭୁଙ୍କ ସହିତ ବିବାଦ କଲେ ଓ ସେମାନଙ୍କ ମଧ୍ୟରେ ପବିତ୍ର ରୂପେ ମାନ୍ୟ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ଏଥିଉତ୍ତାରେ ମୋଶା କାଦେଶରୁ ଇଦୋମୀୟ ରାଜା ନିକଟକୁ ଦୂତମାନଙ୍କ ଦ୍ୱାରା କହି ପଠାଇଲେ, ତୁମ୍ଭର ଭ୍ରାତା ଇସ୍ରାଏଲ ଏରୂପ କହଇ, “ଆମ୍ଭମାନଙ୍କ ପ୍ରତି ଯେଉଁ ସମସ୍ତ କ୍ଳେଶ ଘଟିଅଛି, ");
INSERT INTO ory_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ଅର୍ଥାତ୍‍, କିପରି ଆମ୍ଭମାନଙ୍କର ପୂର୍ବପୁରୁଷମାନେ ମିସରକୁ ଗଲେ ଓ ମିସରରେ ଦୀର୍ଘ କାଳ ବାସ କଲେ ଆଉ ମିସରୀୟମାନେ ଆମ୍ଭମାନଙ୍କ ପ୍ରତି ଓ ଆମ୍ଭମାନଙ୍କ ପୂର୍ବପୁରୁଷମାନଙ୍କ ପ୍ରତି କୁବ୍ୟବହାର କଲେ, ତାହା ତୁମ୍ଭେ ଜାଣ। ");
INSERT INTO ory_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ସେହି ସମୟରେ ଆମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ କ୍ରନ୍ଦନ କରନ୍ତେ, ସେ ଆମ୍ଭମାନଙ୍କ ରବ ଶୁଣିଲେ, ପୁଣି, ଏକ ଦୂତ ପଠାଇ ଆମ୍ଭମାନଙ୍କୁ ମିସରରୁ ବାହାର କରି ଆଣିଲେ; ଆଉ ଦେଖ, ଏବେ ଆମ୍ଭେମାନେ ତୁମ୍ଭ ଦେଶର ପ୍ରାନ୍ତସ୍ଥିତ କାଦେଶ ନଗରରେ ଅଛୁ; ");
INSERT INTO ory_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ମୁଁ ବିନୟ କରୁଅଛି, ତୁମ୍ଭ ଦେଶ ଦେଇ ଆମ୍ଭମାନଙ୍କୁ ଯିବାକୁ ଦିଅ; ଆମ୍ଭେମାନେ ଶସ୍ୟକ୍ଷେତ୍ର କିମ୍ବା ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ର ମଧ୍ୟଦେଇ ଯିବୁ ନାହିଁ, କିଅବା କୂପ ଜଳ ପାନ କରିବୁ ନାହିଁ; ଆମ୍ଭେମାନେ ରାଜପଥ ଦେଇ ଗମନ କରିବୁ; ଆମ୍ଭେମାନେ ତୁମ୍ଭ ସୀମା ପାର ହେବା ପର୍ଯ୍ୟନ୍ତ ଦକ୍ଷିଣରେ କି ବାମରେ ଫେରିବୁ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ତହିଁରେ ଇଦୋମ ତାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭ (ଦେଶର) ମଧ୍ୟଦେଇ ଯିବ ନାହିଁ, ଗଲେ ଆମ୍ଭେ ଖଡ୍ଗ ନେଇ ତୁମ୍ଭ ବିରୁଦ୍ଧରେ ବାହାର ହେବା।” ");
INSERT INTO ory_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ସେତେବେଳେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ତାଙ୍କୁ କହିଲେ, “ଆମ୍ଭେମାନେ କେବଳ ସଡ଼କ ଦେଇ ଯିବୁ ଯଦି ଆମ୍ଭେମାନେ, ଆମ୍ଭେ କି ଆମ୍ଭ ପଶୁମାନେ ତୁମ୍ଭ ଜଳ ପାନ କରିବୁ, ତେବେ ଆମ୍ଭେ ତହିଁର ମୂଲ୍ୟ ଦେବୁ; ଆଉ କିଛି କଥା ନାହିଁ, କେବଳ ଆମ୍ଭକୁ ଆପଣା ପାଦରେ (ଦେଶ) ଦେଇ ଯିବାକୁ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ତହୁଁ ସେ କହିଲେ, “ତୁମ୍ଭେ (ଦେଶ) ଦେଇ ଯିବ ନାହିଁ। ଏଉତ୍ତାରେ ଇଦୋମ ଅନେକ ଲୋକ ସଙ୍ଗରେ ନେଇ ମହାବଳରେ ତାଙ୍କ ବିରୁଦ୍ଧରେ ବାହାର ହେଲେ।” ");
INSERT INTO ory_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ଏହିରୂପେ ଇଦୋମ ଇସ୍ରାଏଲକୁ ଆପଣା ସୀମା ଦେଇ ଯିବାର ଅନୁମତି ଦେବାକୁ ଅସ୍ୱୀକାର କଲେ; ଏଣୁ ଇସ୍ରାଏଲ ତାଙ୍କ ନିକଟରୁ ଫେରିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ଏଥିଉତ୍ତାରେ ସେମାନେ କାଦେଶରୁ ଯାତ୍ରା କଲେ ତହୁଁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ, ଅର୍ଥାତ୍‍, ସମସ୍ତ ମଣ୍ଡଳୀ ହୋର ପର୍ବତରେ ଉପସ୍ଥିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ସେତେବେଳେ ଇଦୋମ ଦେଶର ସୀମା ନିକଟସ୍ଥ ହୋର ପର୍ବତରେ ସଦାପ୍ରଭୁ ମୋଶା ଓ ହାରୋଣଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ଏହା ହାରୋଣର ମୃତ୍ୟୁର ସମୟ ଅଟେ; କାରଣ ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଯେଉଁ ଦେଶ ଦେଇଅଛୁ, ସେହି ଦେଶରେ ସେ ପ୍ରବେଶ କରିବ ନାହିଁ, ଯେହେତୁ ମିରୀବାଃ ଜଳ ନିକଟରେ ତୁମ୍ଭେମାନେ ଆମ୍ଭ ଆଜ୍ଞାର ବିରୁଦ୍ଧ କର୍ମ କରିଥିଲ। ");
INSERT INTO ory_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ତୁମ୍ଭେ ହାରୋଣକୁ ଓ ତାହାର ପୁତ୍ର ଇଲୀୟାସରକୁ ହୋର ପର୍ବତ ଉପରକୁ ନେଇଯାଅ। ");
INSERT INTO ory_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ପୁଣି, ହାରୋଣଠାରୁ ତାହାର ବସ୍ତ୍ର କାଢ଼ି ତାହାର ପୁତ୍ର ଇଲୀୟାସରକୁ ପିନ୍ଧାଅ; ଯେଣୁ ହାରୋଣ (ଆପଣା ଲୋକମାନଙ୍କ ନିକଟରେ) ସଂଗୃହୀତ ହେବ ଓ ସେ ସେହି ସ୍ଥାନରେ ମରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ତହୁଁ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ କର୍ମ କଲେ; ଆଉ ସେମାନେ ସମସ୍ତେ ମଣ୍ଡଳୀର ସାକ୍ଷାତରେ ହୋର ପର୍ବତକୁ ଉଠିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ତେବେ ମୋଶା ହାରୋଣଙ୍କର ବସ୍ତ୍ର କାଢ଼ି ତାଙ୍କର ପୁତ୍ର ଇଲୀୟାସରକୁ ପିନ୍ଧାଇଲେ, ପୁଣି, ହାରୋଣ ସେହି ସ୍ଥାନରେ ପର୍ବତ ଶୃଙ୍ଗରେ ମଲେ; ତହୁଁ ମୋଶା ଓ ଇଲୀୟାସର ପର୍ବତରୁ ଓହ୍ଲାଇ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ଏଉତ୍ତାରେ ହାରୋଣ ମରିଅଛନ୍ତି, ଏହା ସମସ୍ତ ମଣ୍ଡଳୀ ଦେଖନ୍ତେ, ସେମାନେ, ଅର୍ଥାତ୍‍, ଇସ୍ରାଏଲର ସମସ୍ତ ବଂଶ ହାରୋଣଙ୍କ ନିମନ୍ତେ ତିରିଶ ଦିନ ପର୍ଯ୍ୟନ୍ତ ରୋଦନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ ଅଥାରୀମର ପଥ ଦେଇ ଆସୁଅଛନ୍ତି, ଏହି କଥା ଶୁଣି ଦକ୍ଷିଣ ପ୍ରଦେଶ ନିବାସୀ କିଣାନ ବଂଶୀୟ ଅରାଦର ରାଜା ଇସ୍ରାଏଲର ପ୍ରତିକୂଳରେ ଯୁଦ୍ଧ କଲେ ଓ ସେମାନଙ୍କର କେତେକ ଲୋକଙ୍କୁ ଧରି ବନ୍ଦୀ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ତହିଁରେ ଇସ୍ରାଏଲ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମାନତ କରି କହିଲେ, “ଯଦି ତୁମ୍ଭେ ଏହି ଲୋକମାନଙ୍କୁ ଆମ୍ଭ ହସ୍ତରେ ସମର୍ପଣ କରିବ, ଯଦି ଆମ୍ଭେ ସେମାନଙ୍କ ନଗରସବୁ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ବିନାଶ କରିବା।” ");
INSERT INTO ory_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ଏଥିରେ ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲର ରବରେ କର୍ଣ୍ଣପାତ କରି ସେହି କିଣାନୀୟମାନଙ୍କୁ ସମର୍ପଣ କଲେ; ତହିଁରେ ସେମାନେ ସେମାନଙ୍କୁ ଓ ସେମାନଙ୍କ ସମସ୍ତ ନଗର ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ବିନାଶ କଲେ, ପୁଣି, ସେହି ସ୍ଥାନର ନାମ ହର୍ମା ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ଏଥିଉତ୍ତାରେ ସେମାନେ ଇଦୋମ ଦେଶ ପ୍ରଦକ୍ଷିଣ କରିବା ନିମନ୍ତେ ହୋର ପର୍ବତରୁ ସୂଫ ସାଗର ପଥ ଦେଇ ଯାତ୍ରା କଲେ; ପୁଣି, ପଥ ସକାଶୁ ଲୋକମାନଙ୍କର ପ୍ରାଣ ଅତି ସାହସହୀନ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ତହିଁରେ ଲୋକମାନେ ପରମେଶ୍ୱରଙ୍କ ବିରୁଦ୍ଧରେ ଓ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ କହିଲେ, “କାହିଁକି ତୁମ୍ଭେମାନେ ଆମ୍ଭମାନଙ୍କୁ ପ୍ରାନ୍ତରରେ ମାରିବାକୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଲ?” ଦେଖ, ଏଠାରେ ରୁଟି ନାହିଁ ଓ ଜଳ ନାହିଁ; ପୁଣି, ଆମ୍ଭମାନଙ୍କ ପ୍ରାଣ ଏହି ଲଘୁ ଅନ୍ନକୁ ଘୃଣା କରେ। ");
INSERT INTO ory_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ସେତେବେଳେ ସଦାପ୍ରଭୁ ଲୋକମାନଙ୍କ ମଧ୍ୟକୁ ବିଷାକ୍ତ ସର୍ପଗୁଡ଼ିକୁ ପ୍ରେରଣ କରନ୍ତେ, ସେମାନେ ଲୋକମାନଙ୍କୁ ଦଂଶନ କଲେ; ତହିଁରେ ଇସ୍ରାଏଲର ଅନେକ ଲୋକ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ଏନିମନ୍ତେ ଲୋକମାନେ ମୋଶାଙ୍କ ନିକଟକୁ ଆସି କହିଲେ, “ଆମ୍ଭେମାନେ ପାପ କରିଅଛୁ, କାରଣ ଆମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ଓ ତୁମ୍ଭ ବିରୁଦ୍ଧରେ କଥା କହିଅଛୁ; ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପ୍ରାର୍ଥନା କର ଯେପରି ସେ ଆମ୍ଭମାନଙ୍କ ନିକଟରୁ ଏହି ସର୍ପମାନଙ୍କୁ ଦୂର କରିବେ।” ତେଣୁ ମୋଶା ଲୋକମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାର୍ଥନା କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ତେବେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଗୋଟିଏ ବିଷାକ୍ତ ସର୍ପର ନମୁନା ନିର୍ମାଣ କରି ପତାକା-ଦଣ୍ଡ ଉପରେ ରଖ; ତହିଁରେ ସର୍ପଦ୍ରଂଷ୍ଟ ପ୍ରତ୍ୟେକ ଲୋକ ତାହା ପ୍ରତି ଅନାଇଲେ ବଞ୍ଚିବ।” ");
INSERT INTO ory_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ତହୁଁ ମୋଶା ପିତ୍ତଳର ଏକ ସର୍ପ ନିର୍ମାଣ କରି ପତାକା-ଦଣ୍ଡ ଉପରେ ରଖିଲେ; ତହିଁରେ ସର୍ପ କୌଣସି ମନୁଷ୍ୟକୁ ଦଂଶନ କଲେ, ସେ ସେହି ପିତ୍ତଳ ସର୍ପ ପ୍ରତି ଦୃଷ୍ଟିପାତ କରନ୍ତେ, ବଞ୍ଚିଲା। ");
INSERT INTO ory_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯାତ୍ରା କରି ଓବୋତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ତହିଁ ଉତ୍ତାରେ ଓବୋତରୁ ଯାତ୍ରା କରି ସୂର୍ଯ୍ୟୋଦୟ ଦିଗରେ ମୋୟାବର ସମ୍ମୁଖସ୍ଥିତ ପ୍ରାନ୍ତରରେ ଇୟୀ-ଅବାରୀମରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ସେମାନେ ସେଠାରୁ ଯାତ୍ରା କରି ସେରଦ୍‍ ଉପତ୍ୟକାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ସେଠାରୁ ସେମାନେ ଯାତ୍ରା କରି ଇମୋରୀୟମାନଙ୍କର ସୀମାରୁ ନିର୍ଗତ ଅର୍ଣ୍ଣୋନର ଅନ୍ୟ ପାରିସ୍ଥିତ ପ୍ରାନ୍ତରରେ ଛାଉଣି ସ୍ଥାପନ କଲେ; କାରଣ ମୋୟାବର ଓ ଇମୋରୀୟମାନଙ୍କର ମଧ୍ୟବର୍ତ୍ତୀ ଅର୍ଣ୍ଣୋନ ମୋୟାବର ସୀମା ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ଏନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ଯୁଦ୍ଧର ନଳାକାର ପୁସ୍ତକରେ କଥିତ ଅଛି, ଯଥା “ସୁଫଃରେ ବାହେବକୁ ଓ ଅର୍ଣ୍ଣୋନର ସକଳ ଉପତ୍ୟକା, ");
INSERT INTO ory_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ପୁଣି, ଆରର ବାସସ୍ଥାନଗାମୀ ଓ ମୋୟାବ-ସୀମାର ପାର୍ଶ୍ଵସ୍ଥିତ ଗଡ଼ନ୍ତି ଉପତ୍ୟକାସକଳକୁ (ସେ ଜୟ କଲେ।”) ");
INSERT INTO ory_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ସେଠାରୁ ସେମାନେ (ଯାତ୍ରା କରି) ବେର (କୂପ) ନାମକ ସ୍ଥାନକୁ ଆସିଲେ। ସେହି କୂପ ବିଷୟରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଏହି ସ୍ଥାନରେ ଲୋକମାନଙ୍କୁ ଏକତ୍ର କର, ଆମ୍ଭେ ସେମାନଙ୍କୁ ଜଳ ଦେବା।” ");
INSERT INTO ory_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ସେହି ସମୟରେ ଇସ୍ରାଏଲ ଏହି ଗୀତ ଗାନ କଲେ, “ହେ କୂପ, ଉଚ୍ଛୁଳି ଉଠ ତୁମ୍ଭେମାନେ ତହିଁ ଉଦ୍ଦେଶ୍ୟରେ ଗାନ କର; ");
INSERT INTO ory_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ଅଧିପତିମାନେ ସେହି କୂପ ଖୋଳିଛନ୍ତି, ଲୋକମାନଙ୍କର କୁଳୀନମାନେ ରାଜଦଣ୍ଡ ଓ ଆପଣା ଆପଣା ଯଷ୍ଟି ଘେନି ତାହା ଖୋଳିଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ଏଉତ୍ତାରେ ସେମାନେ ପ୍ରାନ୍ତରରୁ ମତ୍ତାନକୁ ଓ ମତ୍ତାନଠାରୁ ନହଲୀୟେଲକୁ ଓ ନହଲୀୟେଲଠାରୁ ବାମୋତକୁ ");
INSERT INTO ory_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ଓ ବାମୋତଠାରୁ ମୋୟାବ କ୍ଷେତ୍ରସ୍ଥିତ ଉପତ୍ୟକା ଦେଇ ପିସ୍ଗା ପର୍ବତର ଶୃଙ୍ଗକୁ ଯାତ୍ରା କଲେ, ତାହା ମରୁଭୂମି ଆଡ଼କୁ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ ଇମୋରୀୟମାନଙ୍କ ରାଜା ସୀହୋନ ନିକଟକୁ ଏହା କହି ଦୂତ ପଠାଇଲେ; ");
INSERT INTO ory_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ତୁମ୍ଭ ଦେଶ ଦେଇ ଆମ୍ଭକୁ ଯିବାକୁ ଦିଅ; ଆମ୍ଭେମାନେ ଶସ୍ୟକ୍ଷେତ୍ର କି ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ର ଆଡ଼େ ଫେରିବୁ ନାହିଁ; ଆମ୍ଭେମାନେ କୂପରୁ ଜଳ ପାନ କରିବୁ ନାହିଁ; ଆମ୍ଭେମାନେ ତୁମ୍ଭ ସୀମା ପାର ହେବା ପର୍ଯ୍ୟନ୍ତ ରାଜପଥ ଦେଇ ଗମନ କରିବୁ।” ");
INSERT INTO ory_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ଏଥିରେ ସୀହୋନ ଆପଣା ସୀମା ଦେଇ ଇସ୍ରାଏଲକୁ ଯିବା ପାଇଁ ଦେଲେ ନାହିଁ; ମାତ୍ର ସୀହୋନ ଆପଣାର ସମସ୍ତ ଲୋକଙ୍କୁ ଏକତ୍ର କରି ଇସ୍ରାଏଲର ପ୍ରତିକୂଳରେ ପ୍ରାନ୍ତରକୁ ବାହାର ହେଲେ, ପୁଣି, ଯହସରେ ଉପସ୍ଥିତ ହୋଇ ଇସ୍ରାଏଲ ବିରୁଦ୍ଧରେ ଯୁଦ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ତହିଁରେ ଇସ୍ରାଏଲ ଖଡ୍ଗଧାରରେ ତାଙ୍କୁ ଆଘାତ କରି ଅର୍ଣ୍ଣୋନଠାରୁ ଯବ୍ବୋକ୍‍ ପର୍ଯ୍ୟନ୍ତ, ଅର୍ଥାତ୍‍, ଅମ୍ମୋନ-ସନ୍ତାନଗଣଙ୍କର ସୀମା ପର୍ଯ୍ୟନ୍ତ, ତାହାର ଦେଶ ଅଧିକାର କଲେ; କାରଣ ଅମ୍ମୋନ-ସନ୍ତାନଗଣଙ୍କର ସୀମା ଦୃଢ଼ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ଏହିରୂପେ ଇସ୍ରାଏଲ ସେହି ସମସ୍ତ ନଗର ହସ୍ତଗତ କଲେ ଓ ଇସ୍ରାଏଲ ଇମୋରୀୟମାନଙ୍କର ସମସ୍ତ ନଗରରେ, ଅର୍ଥାତ୍‍ ହିଷ୍‍ବୋନରେ ଓ ତହିଁର ସମସ୍ତ ନଗରରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","କାରଣ ହିଷ୍‍ବୋନ ଇମୋରୀୟମାନଙ୍କ ରାଜା ସୀହୋନଙ୍କ ନଗର ଥିଲା, ସେ ମୋୟାବର ପୂର୍ବ ରାଜାର ପ୍ରତିକୂଳରେ ଯୁଦ୍ଧ କରି ତାହା ହସ୍ତରୁ ଅର୍ଣ୍ଣୋନ ପର୍ଯ୍ୟନ୍ତ ତାହାର ସମସ୍ତ ଦେଶ ନେଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ଏନିମନ୍ତେ କବିମାନେ କହନ୍ତି, “ତୁମ୍ଭେମାନେ ହିଷ୍‍ବୋନକୁ ଆସ, ସୀହୋନର ନଗର ନିର୍ମିତ ଓ ଦୃଢ଼ୀକୃତ ହେଉ; ");
INSERT INTO ory_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","କାରଣ ହିଷ୍‍ବୋନଠାରୁ ଅଗ୍ନି, ସୀହୋନ ନଗରଠାରୁ ଅଗ୍ନିଶିଖା ନିର୍ଗତ ହୋଇଅଛି; ତାହା ମୋୟାବର ଆର ନଗରକୁ, ଅର୍ଣ୍ଣୋନସ୍ଥ ଉଚ୍ଚସ୍ଥଳୀର ଦେବଗଣକୁ ଗ୍ରାସ କରିଅଛି। ");
INSERT INTO ory_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ହେ ମୋୟାବ, ତୁମ୍ଭର ସନ୍ତାପ ହେଲା! ହେ କମୋଶର ଲୋକଗଣ, ତୁମ୍ଭେମାନେ ଉଚ୍ଛିନ୍ନ ହେଲ; ସେ ତାହାର ପୁତ୍ରଗଣକୁ ପଳାତକ ରୂପେ ଓ ତାହାର କନ୍ୟାଗଣକୁ ବନ୍ଦୀ ରୂପେ ଇମୋରୀୟ ରାଜା ସୀହୋନର ହସ୍ତରେ ସମର୍ପଣ କରିଅଛି; ");
INSERT INTO ory_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ଆମ୍ଭେମାନେ ସେମାନଙ୍କୁ ବାଣ ମାରିଅଛୁ; ହିଷ୍‍ବୋନ ଦୀବୋନ୍ ପର୍ଯ୍ୟନ୍ତ ବିନଷ୍ଟ ହେଲା, ଆମ୍ଭେମାନେ ନୋଫହ ପର୍ଯ୍ୟନ୍ତ ଧ୍ୱଂସ କଲୁ, ତାହା ମେଦବା ପର୍ଯ୍ୟନ୍ତ ବ୍ୟାପଇ।” ");
INSERT INTO ory_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ଏହିରୂପେ ଇସ୍ରାଏଲ ଇମୋରୀୟମାନଙ୍କ ଦେଶରେ ବାସ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ଏଥିଉତ୍ତାରେ ମୋଶା ଯାସେର ଅନୁସନ୍ଧାନ କରିବା ପାଇଁ ଲୋକ ପଠାନ୍ତେ, ସେମାନେ ତହିଁର ସକଳ ନଗର ହସ୍ତଗତ କଲେ ଓ ସେଠାସ୍ଥିତ ଇମୋରୀୟମାନଙ୍କୁ ତଡ଼ିଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ତହୁଁ ସେମାନେ ଫେରି ବାଶନର ପଥ ଦେଇ ଉଠିଗଲେ; ତହିଁରେ ବାଶନର ରାଜା ଓଗ୍‍, ସେ ଓ ତାହାର ସମସ୍ତ ଲୋକ ସେମାନଙ୍କ ପ୍ରତିକୂଳରେ ବାହାର ହୋଇ ଇଦ୍ରିୟୀରେ ଯୁଦ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ସେହି ସମୟରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତାହାକୁ ଭୟ କର ନାହିଁ; କାରଣ ଆମ୍ଭେ ତାହାକୁ ଓ ତାହାର ସମସ୍ତ ଲୋକଙ୍କୁ ଓ ତାହାର ଦେଶକୁ ତୁମ୍ଭ ହସ୍ତରେ ସମର୍ପଣ କରିଅଛୁ; ତୁମ୍ଭେ ହିଷ୍‍ବୋନବାସୀ ଇମୋରୀୟ ରାଜା ସୀହୋନ ପ୍ରତି ଯେରୂପ କଲ, ତାହା ପ୍ରତି ସେରୂପ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ଏଣୁ ତାହାର କେହି ଅବଶିଷ୍ଟ ନ ରହିବା ପର୍ଯ୍ୟନ୍ତ ସେମାନେ ତାହାକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ଓ ତାହାର ସମସ୍ତ ଲୋକଙ୍କୁ ଆଘାତ କଲେ, ପୁଣି, ସେମାନେ ତାହାର ଦେଶ ଅଧିକାର କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ଯାତ୍ରା କରି ଯିରୀହୋ ନିକଟସ୍ଥ ଯର୍ଦ୍ଦନ ଆଗରେ ମୋୟାବ-ପଦାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ପୁଣି, ଇସ୍ରାଏଲ ଇମୋରୀୟମାନଙ୍କ ପ୍ରତି ଯାହା ଯାହା କରିଥିଲେ, ତାହା ସିପ୍ପୋରର ପୁତ୍ର ବାଲାକ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ଏଣୁ ମୋୟାବ ଲୋକମାନଙ୍କ ସକାଶୁ ଅତିଶୟ ଭୀତ ହେଲେ, କାରଣ ସେମାନେ ବହୁତ ଥିଲେ; ଆଉ ମୋୟାବ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ସକାଶୁ ଉଦ୍‍ବିଗ୍ନ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ଏଥିରେ ମୋୟାବ ମିଦୀୟନୀୟ ପ୍ରାଚୀନଗଣକୁ କହିଲେ, “ଗୋରୁ ଯେପରି ପଦାରୁ ଘାସ ଚାଟି ଖାଏ, ସେପରି ଏହି ଜନତା ଆମ୍ଭମାନଙ୍କ ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ସବୁ ଚାଟି ପକାଇବେ। ଏହି ସମୟରେ ସିପ୍ପୋରର ପୁତ୍ର ବାଲାକ ମୋୟାବର ରାଜା ଥିଲେ।” ");
INSERT INTO ory_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ଏନିମନ୍ତେ ସେ ବିୟୋରର ପୁତ୍ର ବିଲୀୟମ୍‍କୁ ଡାକିବା ପାଇଁ ଆପଣା ଲୋକମାନଙ୍କ ସନ୍ତାନଗଣର ଦେଶ-ନିକଟସ୍ଥ ନଦୀର ନିକଟବର୍ତ୍ତୀ ପଥୋର ନଗରକୁ ବାର୍ତ୍ତାବହ ପଠାଇ ଏହା କହିଲେ, “ଦେଖ, ମିସରରୁ ବାହାର ହୋଇ ଏକ ଜନତା ଆସିଅଛନ୍ତି; ଦେଖ, ସେମାନେ ପୃଥିବୀର ମୁଖ ଆଚ୍ଛନ୍ନ କରନ୍ତି; ପୁଣି, ଆମ୍ଭ ସମ୍ମୁଖରେ ବାସ କରନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ଏହେତୁ ଆମ୍ଭେ ନିବେଦନ କରୁଅଛୁ, ତୁମ୍ଭେ ଆସି ଆମ୍ଭ ନିମନ୍ତେ ଏହି ଲୋକମାନଙ୍କୁ ଅଭିଶାପ ଦିଅ; କାରଣ ସେମାନେ ଆମ୍ଭ ପ୍ରତି ଅତି ବଳବାନ; ହୋଇପାରେ, ଆମ୍ଭେ ସେମାନଙ୍କୁ ପରାଜୟ କରି ଦେଶରୁ ଦୂର କରି ପାରିବା; ଯେହେତୁ ଆମ୍ଭେ ଜାଣୁ, ତୁମ୍ଭେ ଯାହାକୁ ଆଶୀର୍ବାଦ କର, ସେ ଆଶୀର୍ବାଦ ପାଏ, ପୁଣି, ତୁମ୍ଭେ ଯାହାକୁ ଅଭିଶାପ ଦିଅ, ସେ ଅଭିଶପ୍ତ ହୁଏ।” ");
INSERT INTO ory_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ତହିଁରେ ମୋୟାବର ପ୍ରାଚୀନବର୍ଗ ଓ ମିଦୀୟନର ପ୍ରାଚୀନବର୍ଗ ମନ୍ତ୍ରର ପୁରସ୍କାର ହସ୍ତରେ ଘେନି ପ୍ରସ୍ଥାନ କଲେ; ପୁଣି, ସେମାନେ ବିଲୀୟମ୍‍ ନିକଟରେ ଉପସ୍ଥିତ ହୋଇ ବାଲାକଙ୍କ କଥା ତାହାକୁ କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ତହୁଁ ସେ ସେମାନଙ୍କୁ କହିଲା, “ତୁମ୍ଭେମାନେ ଆଜି ରାତ୍ରି ଏଠାରେ ରୁହ, ଆଉ ସଦାପ୍ରଭୁ ମୋତେ ଯାହା କହିବେ, ତାହା ମୁଁ ପୁନର୍ବାର ତୁମ୍ଭମାନଙ୍କୁ ଜଣାଇବି,” ତହିଁରେ ମୋୟାବର ଅଧିପତିମାନେ ବିଲୀୟମ୍‍ ସଙ୍ଗରେ ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ଏଉତ୍ତାରେ ପରମେଶ୍ୱର ବିଲୀୟମ୍‍ ନିକଟକୁ ଆସି ତାହାକୁ କହିଲେ, “ତୁମ୍ଭ ସଙ୍ଗରେ ଏହି ଲୋକମାନେ କିଏ?” ");
INSERT INTO ory_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ତହୁଁ ବିଲୀୟମ୍‍ ପରମେଶ୍ୱରଙ୍କୁ କହିଲା, “ମୋୟାବର ରାଜା ସିପ୍ପୋରର ପୁତ୍ର ବାଲାକ ମୋʼ ନିକଟକୁ ଏହା କହି ପଠାଇଅଛନ୍ତି; ");
INSERT INTO ory_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ଦେଖ, ଏହି ଯେଉଁ ଲୋକମାନେ ମିସରରୁ ବାହାରି ଆସିଅଛନ୍ତି, ସେମାନେ ସମଗ୍ର ଦେଶକୁ ଆଚ୍ଛନ୍ନ କରିଅଛନ୍ତି; ଏବେ ତୁମ୍ଭେ ଆସି ଆମ୍ଭ ନିମନ୍ତେ ସେମାନଙ୍କୁ ଅଭିଶାପ ଦିଅ, ହୋଇପାରେ, ଆମ୍ଭେ ସେମାନଙ୍କ ବିରୁଦ୍ଧରେ ଯୁଦ୍ଧ କରି ସେମାନଙ୍କୁ ତଡ଼ିଦେଇ ପାରିବା।’” ");
INSERT INTO ory_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ତହିଁରେ ପରମେଶ୍ୱର ବିଲୀୟମ୍‍କୁ କହିଲେ, “ତୁମ୍ଭେ ସେମାନଙ୍କ ସଙ୍ଗେ ଯିବ ନାହିଁ; ତୁମ୍ଭେ ସେହି ଲୋକମାନଙ୍କୁ ଅଭିଶାପ ଦେବ ନାହିଁ; କାରଣ ସେମାନେ ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ଅଟନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ଏଥିରେ ବିଲୀୟମ୍‍ ପ୍ରାତଃକାଳରେ ଉଠି ବାଲାକଙ୍କ ଅଧିପତିମାନଙ୍କୁ କହିଲା, “ତୁମ୍ଭେମାନେ ଆପଣା ଦେଶକୁ ଯାଅ, କାରଣ ସଦାପ୍ରଭୁ ମୋତେ ତୁମ୍ଭମାନଙ୍କ ସହିତ ଯିବା ପାଇଁ ଅନୁମତି ଦେବାକୁ ମନା କରିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ଏଣୁ ମୋୟାବର ଅଧିପତିମାନେ ଉଠି ବାଲାକଙ୍କ ନିକଟକୁ ଯାଇ କହିଲେ, “ବିଲୀୟମ୍‍ ଆମ୍ଭମାନଙ୍କ ସଙ୍ଗେ ଆସିବାକୁ ମନା କରୁଅଛି।” ");
INSERT INTO ory_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ଏଉତ୍ତାରେ ବାଲାକ ସେମାନଙ୍କଠାରୁ ଅଧିକ ସଂଖ୍ୟକ ଓ ଅଧିକ ସମ୍ଭ୍ରାନ୍ତ ଅଧିପତିମାନଙ୍କୁ ପୁନର୍ବାର ପଠାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ତହୁଁ ସେମାନେ ବିଲୀୟମ୍‍ ନିକଟକୁ ଆସି ତାହାକୁ କହିଲେ, “ସିପ୍ପୋରର ପୁତ୍ର ବାଲାକ ଏହି କଥା କହନ୍ତି, ‘ଆମ୍ଭେ ବିନୟ କରୁଅଛୁ, ଆମ୍ଭ କତିକି ଆସିବାକୁ ତୁମ୍ଭେ ନିବାରିତ ହୁଅ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","କାରଣ ଆମ୍ଭେ ତୁମ୍ଭକୁ ସମ୍ଭ୍ରମ ଦେଇ ମହାସମ୍ଭ୍ରାନ୍ତ କରିବା, ପୁଣି, ଯାହା ତୁମ୍ଭେ ଆମ୍ଭକୁ କହିବ, ଆମ୍ଭେ ତାହା କରିବା; ଏଣୁ ବିନୟ କରୁଅଛୁ, ଆସ, ଆମ୍ଭ ନିମନ୍ତେ ଏହି ଲୋକମାନଙ୍କୁ ଅଭିଶାପ ଦିଅ।’” ");
INSERT INTO ory_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ଏଥିରେ ବିଲୀୟମ୍‍ ଉତ୍ତର ଦେଇ ବାଲାକଙ୍କ ଦାସମାନଙ୍କୁ କହିଲା, “ଯଦ୍ୟପି ବାଲାକ ରୂପା ଓ ସୁନାରେ ପରିପୂର୍ଣ୍ଣ ଆପଣା ଗୃହ ମୋତେ ଦିଅନ୍ତି, ତଥାପି ଊଣା କି ଅଧିକ କରିବାକୁ ମୁଁ ଆପଣା ପରମେଶ୍ୱର ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟର ବାହାରେ ଯାଇପାରେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ଏନିମନ୍ତେ ବିନୟ କରୁଅଛି, ତୁମ୍ଭେମାନେ ହେଁ ଆଜି ରାତ୍ରି ଏଠାରେ ରୁହ, ସଦାପ୍ରଭୁ ମୋତେ ଆଉ ଯାହା କହିବେ, ତାହା ମୁଁ ଜାଣିବି।” ");
INSERT INTO ory_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ଏଥିରେ ପରମେଶ୍ୱର ରାତ୍ରିରେ ବିଲୀୟମ୍‍ ନିକଟକୁ ଆସି କହିଲେ, “ଯଦି ଏହି ଲୋକମାନେ ତୁମ୍ଭକୁ ଡାକିବାକୁ ଆସନ୍ତି, ତେବେ ଉଠ, ସେମାନଙ୍କ ସଙ୍ଗେ ଯାଅ; ମାତ୍ର ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯେଉଁ କଥା କହିବା; କେବଳ ତାହା ହିଁ ତୁମ୍ଭେ କହିବ।” ");
INSERT INTO ory_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ତହିଁରେ ବିଲୀୟମ୍‍ ପ୍ରାତଃକାଳରେ ଉଠି ଆପଣା ଗର୍ଦ୍ଦଭୀ ସଜାଇ ମୋୟାବର ଅଧିପତିମାନଙ୍କ ସହିତ ଗମନ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ଏଥିରେ ସେ ଯିବା ସକାଶୁ ପରମେଶ୍ୱରଙ୍କ କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା, ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ତାହାର ଶତ୍ରୁ ରୂପେ ପଥ ମଧ୍ୟରେ ଠିଆ ହୋଇ ରହିଲେ; ସେତେବେଳେ ସେ ଆପଣା ଗର୍ଦ୍ଦଭୀ ଉପରେ ଚଢ଼ି ଯାଉଥିଲା ଓ ତାହାର ଦୁଇ ଦାସ ତାହା ସଙ୍ଗରେ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ଏଥିରେ ସେହି ଗର୍ଦ୍ଦଭୀ ସଦାପ୍ରଭୁଙ୍କ ଦୂତଙ୍କୁ ପଥ ମଧ୍ୟରେ ନିଷ୍କୋଷ ଖଡ୍ଗ ହସ୍ତରେ ଧରି ଠିଆ ହୋଇଥିବାର ଦେଖିଲା; ତହୁଁ ଗର୍ଦ୍ଦଭୀ ବାଟ ଛାଡ଼ି ବିଲ ଆଡ଼କୁ ଗଲା ତହିଁରେ ବିଲୀୟମ୍‍ ଗର୍ଦ୍ଦଭୀକୁ ବାଟକୁ ଫେରାଇ ଆଣିବା ପାଇଁ ପ୍ରହାର କଲା; ");
INSERT INTO ory_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ତେବେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ଦୁଇ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରର ଏପାଖେ ପ୍ରାଚୀର ଓ ସେପାଖେ ପ୍ରାଚୀର ଥିବା ଗଳିପଥରେ ଠିଆ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ସେହି ସମୟରେ ଗର୍ଦ୍ଦଭୀ ସଦାପ୍ରଭୁଙ୍କ ଦୂତଙ୍କୁ ଦେଖି କାନ୍ଥ ଆଡ଼କୁ ଠେଲି ହୋଇ ଯିବାରୁ ବିଲୀୟମ୍‍ର ଗୋଡ଼ କାନ୍ଥରେ ଘଷି ହେଲା; ତହିଁରେ ସେ ପୁନର୍ବାର ତାହାକୁ ପ୍ରହାର କଲା। ");
INSERT INTO ory_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ଏଉତ୍ତାରେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ଆହୁରି ଆଗକୁ ଯାଇ ଏକ ସଂକୀର୍ଣ୍ଣ ସ୍ଥାନରେ ଠିଆ ହେଲେ, ସେଠାରେ ଡାହାଣରେ କିମ୍ବା ବାମରେ ଫେରିବାର ସ୍ଥାନ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ସେତେବେଳେ ଗର୍ଦ୍ଦଭୀ ସଦାପ୍ରଭୁଙ୍କ ଦୂତଙ୍କୁ ଦେଖି ବିଲୀୟମ୍‍ର ତଳେ ଶୋଇ ପଡ଼ିଲା; ତହିଁରେ ବିଲୀୟମ୍‍ର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହୁଅନ୍ତେ, ସେ ଗର୍ଦ୍ଦଭୀକୁ ଆପଣା ଯଷ୍ଟିରେ ପ୍ରହାର କଲା। ");
INSERT INTO ory_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ତହୁଁ ସଦାପ୍ରଭୁ ଗର୍ଦ୍ଦଭୀର ମୁଖ ଫିଟାଇଲେ, ତେଣୁ ସେ ବିଲୀୟମ୍‍କୁ କହିଲା, “ମୁଁ ତୁମ୍ଭର କଅଣ କଲି ଯେ, ତୁମ୍ଭେ ମୋତେ ଏହି ତିନି ଥର ପ୍ରହାର କଲ।” ");
INSERT INTO ory_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ତେବେ ବିଲୀୟମ୍‍ ଗର୍ଦ୍ଦଭୀକୁ କହିଲା, “କାରଣ ତୁ ମୋତେ ପରିହାସ କରୁଅଛୁ; ମୋʼ ହାତରେ ଖଣ୍ଡା ଥିଲେ ମୁଁ ଏବେ ତୋତେ ବଧ କରନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ପୁଣି, ଗର୍ଦ୍ଦଭୀ ବିଲୀୟମ୍‍କୁ କହିଲା, “ତୁମ୍ଭେ ଜନ୍ମାବଧି ଆଜି ପର୍ଯ୍ୟନ୍ତ ଯାହା ଉପରେ ଚଢ଼ି ଆସିଅଛ, ମୁଁ କି ତୁମ୍ଭର ସେହି ଗର୍ଦ୍ଦଭୀ ନୁହେଁ? ମୁଁ କି ପୂର୍ବେ କେବେ ତୁମ୍ଭ ପ୍ରତି ଏପରି କରିଥିଲି?” ତହୁଁ ସେ କହିଲା, “ନା।” ");
INSERT INTO ory_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ଏଥିରେ ସଦାପ୍ରଭୁ ବିଲୀୟମ୍‍ର ଚକ୍ଷୁ ପ୍ରସନ୍ନ କରନ୍ତେ, ସେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତଙ୍କୁ ପଥ ମଧ୍ୟରେ ନିଷ୍କୋଷ ଖଡ୍ଗ ହସ୍ତରେ ଧରି ଠିଆ ହୋଇଥିବାର ଦେଖିଲା; ତହିଁରେ ସେ ମସ୍ତକ ନୁଆଁଇ ମୁହଁ ମାଡ଼ି ପଡ଼ିଲା। ");
INSERT INTO ory_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ସେତେବେଳେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ତାହାକୁ କହିଲେ, “ତୁମ୍ଭେ ଏହି ତିନି ଥର ଆପଣା ଗର୍ଦ୍ଦଭୀକୁ କାହିଁକି ପ୍ରହାର କଲ? ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭର ଶତ୍ରୁ ରୂପେ ବାହାର ହୋଇଅଛୁ, ଯେହେତୁ ଆମ୍ଭ ସାକ୍ଷାତରେ ତୁମ୍ଭର ଗତି ବିପଥଗାମୀ ହୋଇଅଛି; ");
INSERT INTO ory_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ପୁଣି, ଗର୍ଦ୍ଦଭୀ ଆମ୍ଭକୁ ଦେଖି ଏହି ତିନି ଥର ଆମ୍ଭ ସମ୍ମୁଖରୁ ଫେରିଲା; ସେ ଯଦି ଆମ୍ଭ ସମ୍ମୁଖରୁ ଫେରି ନ ଥାʼନ୍ତା, ତେବେ ନିଶ୍ଚୟ ଆମ୍ଭେ ତୁମ୍ଭକୁ ବଧ କରିଥାʼନ୍ତୁ, ଆଉ ତାହାକୁ ଜୀଅନ୍ତା ରଖିଥାʼନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ତହିଁରେ ବିଲୀୟମ୍‍ ସଦାପ୍ରଭୁଙ୍କ ଦୂତଙ୍କୁ କହିଲା, “ମୁଁ ପାପ କରିଅଛି; କାରଣ ତୁମ୍ଭେ ଯେ ମୋʼ ବିପକ୍ଷରେ ପଥରେ ଠିଆ ହୋଇଅଛ; ତାହା ମୁଁ ଜାଣିଲି ନାହିଁ; ଏଣୁ ଏବେ, ଯଦି ତାହା ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ମନ୍ଦ ହୁଏ, ତେବେ ମୁଁ ଫେରିଯିବି।” ");
INSERT INTO ory_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ତହିଁରେ ସଦାପ୍ରଭୁଙ୍କ ଦୂତ ବିଲୀୟମ୍‍କୁ କହିଲେ, “ସେହି ଲୋକମାନଙ୍କ ସଙ୍ଗେ ଯାଅ; ମାତ୍ର ଆମ୍ଭେ ତୁମ୍ଭକୁ ଯେଉଁ କଥା କହିବା, କେବଳ ତାହା ତୁମ୍ଭେ କହିବ।” ତହିଁରେ ବିଲୀୟମ୍‍ ବାଲାକଙ୍କ ଅଧିପତିମାନଙ୍କ ସହିତ ଗମନ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ଏଥିଉତ୍ତାରେ ବିଲୀୟମ୍‍ର ଆଗମନ ସମ୍ବାଦ ଶୁଣି ବାଲାକ ତାହା ସଙ୍ଗେ ଭେଟିବା ପାଇଁ ଦେଶର ପ୍ରାନ୍ତସ୍ଥିତ ଅର୍ଣ୍ଣୋନର ସୀମାନ୍ତବର୍ତ୍ତୀ ମୋୟାବ ନଗରକୁ ଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ପୁଣି, ବାଲାକ ବିଲୀୟମ୍‍କୁ କହିଲେ, “ଆମ୍ଭେ କି ତୁମ୍ଭକୁ ଡାକିବା ପାଇଁ ଅତି ଯତ୍ନରେ ଲୋକ ପଠାଇଲୁ ନାହିଁ? ତୁମ୍ଭେ କାହିଁକି ଆମ୍ଭ ନିକଟକୁ ଆସିଲ ନାହିଁ? ଆମ୍ଭେ କି ତୁମ୍ଭକୁ ସମ୍ଭ୍ରମ ଦେଇ ସମ୍ଭ୍ରାନ୍ତ କରିବାକୁ ନିତାନ୍ତ ଅସମର୍ଥ?” ");
INSERT INTO ory_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ତହୁଁ ବିଲୀୟମ୍‍ ବାଲାକଙ୍କୁ କହିଲା, “ଏହି ଦେଖ, ମୁଁ ତୁମ୍ଭ ନିକଟକୁ ଆସିଅଛି; ମାତ୍ର ଏବେ କୌଣସି କଥା କହିବାକୁ କି ମୋହର କିଛି ସାମର୍ଥ୍ୟ ଅଛି? ପରମେଶ୍ୱର ମୋʼ ମୁଖରେ ଯେଉଁ ବାକ୍ୟ ଦେବେ ତାହା ହିଁ ମୁଁ କହିବି।” ");
INSERT INTO ory_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ଏଉତ୍ତାରେ ବିଲୀୟମ୍‍ ବାଲାକ ସହିତ ଗମନ କରି କିରୀୟଥ୍‍-ହୁଷୋତରେ ଉପସ୍ଥିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ତହୁଁ ବାଲାକ ଗୋରୁ ଓ ମେଷ ବଳିଦାନ କରି ବିଲୀୟମ୍‍ ଓ ତାହାର ସଙ୍ଗୀ ଅଧିପତିମାନଙ୍କ ନିକଟକୁ ପଠାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ପୁଣି, ପ୍ରଭାତରେ ବାଲାକ ବିଲୀୟମ୍‍କୁ ସଙ୍ଗେ ନେଇ ବାଲ୍‍ର ଉଚ୍ଚସ୍ଥଳୀରେ ଆରୋହଣ କରାଇଲେ; ଆଉ ସେହିଠାରୁ ସେ ଲୋକମାନଙ୍କର ଶେଷ ସୀମା ପର୍ଯ୍ୟନ୍ତ ଦେଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ଏଥିଉତ୍ତାରେ ବିଲୀୟମ୍‍ ବାଲାକଙ୍କୁ କହିଲା, “ଏହି ସ୍ଥାନରେ ମୋʼ ପାଇଁ ସାତଗୋଟି ଯଜ୍ଞବେଦି ନିର୍ମାଣ କର ଓ ଏହି ସ୍ଥାନରେ ମୋʼ ପାଇଁ ସାତ ଗୋବତ୍ସ ଓ ସାତ ମେଷ ଆୟୋଜନ କର।” ");
INSERT INTO ory_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ତହିଁରେ ବାଲାକ ବିଲୀୟମ୍‍ର କଥାନୁସାରେ କଲେ; ପୁଣି, ବାଲାକ ଓ ବିଲୀୟମ୍‍ ପ୍ରତ୍ୟେକ ଯଜ୍ଞବେଦିରେ ଏକ ଏକ ଗୋବତ୍ସ ଓ ଏକ ଏକ ମେଷ ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ତହୁଁ ବିଲୀୟମ୍‍ ବାଲାକଙ୍କୁ କହିଲା, “ତୁମ୍ଭେ ଆପଣା ହୋମବଳି ନିକଟରେ ଠିଆ ହୁଅ, ମୁଁ ଯିବି କେଜାଣି ସଦାପ୍ରଭୁ ମୋତେ ସାକ୍ଷାତ କରିବାକୁ ଆସିବେ; ଆଉ ସେ ଯାହା ମୋତେ ଦେଖାଇବେ, ତାହା ମୁଁ ତୁମ୍ଭକୁ କହିବି।” ପୁଣି, ସେ ଏକ ଉଚ୍ଚସ୍ଥାନକୁ ଗଲା। ");
INSERT INTO ory_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ସେତେବେଳେ ପରମେଶ୍ୱର ବିଲୀୟମ୍‍କୁ ସାକ୍ଷାତ କଲେ; ତହିଁରେ ସେ ତାହାଙ୍କୁ କହିଲା, “ମୁଁ ସାତ ଯଜ୍ଞବେଦି ପ୍ରସ୍ତୁତ କରିଅଛି ଓ ମୁଁ ପ୍ରତ୍ୟେକ ଯଜ୍ଞବେଦିରେ ଏକ ଗୋବତ୍ସ ଓ ଏକ ମେଷ ଉତ୍ସର୍ଗ କରିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ସେତେବେଳେ ସଦାପ୍ରଭୁ ବିଲୀୟମ୍‍ର ମୁଖରେ ଏକ ବାକ୍ୟ ଦେଇ ତାହାକୁ କହିଲେ, “ତୁମ୍ଭେ ବାଲାକ ନିକଟକୁ ଫେରିଯାଅ, ପୁଣି, ତାହାକୁ ଏହିପରି କୁହ।” ");
INSERT INTO ory_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ତହିଁରେ ସେ ତାଙ୍କ ନିକଟକୁ ଫେରିଗଲା, ସେହି ସମୟରେ ଦେଖ, ସେ ଆପଣା ହୋମବଳି ନିକଟରେ ଠିଆ ହୋଇଥିଲେ, ସେ ଓ ମୋୟାବର ଅଧିପତି ସମସ୍ତେ (ଠିଆ ହୋଇଥିଲେ)। ");
INSERT INTO ory_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ତହୁଁ ସେ ଆପଣା ପ୍ରସଙ୍ଗ ନେଇ କହିଲା, “ବାଲାକ ଅରାମଠାରୁ, ମୋୟାବର ରାଜା ପୂର୍ବଦିଗସ୍ଥିତ ପର୍ବତଶ୍ରେଣୀରୁ ମୋତେ ଆଣିଅଛି; ‘ଆସ, ଆମ୍ଭ ନିମନ୍ତେ ଯାକୁବକୁ ଅଭିଶାପ ଦିଅ;’ ପୁଣି, ‘ଆସ, ଇସ୍ରାଏଲକୁ ଅଭିଶପ୍ତ କର।’ ");
INSERT INTO ory_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ପରମେଶ୍ୱର ଯାହାକୁ ଅଭିଶାପ ଦେଇ ନାହାନ୍ତି, ମୁଁ କିପରି ତାହାକୁ ଅଭିଶାପ ଦେବି? ସଦାପ୍ରଭୁ ଯାହାକୁ ଅଭିଶପ୍ତ କରି ନାହାନ୍ତି, ମୁଁ କିପରି ତାହାକୁ ଅଭିଶପ୍ତ କରିବି? ");
INSERT INTO ory_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","କାରଣ ଶୈଳମାଳାର ଶିଖରରୁ ମୁଁ ତାହାକୁ ଦେଖୁଅଛି ଓ ଗିରିଶ୍ରେଣୀରୁ ମୁଁ ତାହାକୁ ଦର୍ଶନ କରୁଅଛି। ଦେଖ, ଏହି ଲୋକମାନେ ଅଲଗା ବାସ କରନ୍ତି, ସେମାନେ ଅନ୍ୟ ଦେଶୀୟମାନଙ୍କ ମଧ୍ୟରେ ଗଣିତ ହେବେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ଯାକୁବର ଧୂଳି କିଏ ଗଣିପାରେ ଅବା ଇସ୍ରାଏଲର ଚତୁର୍ଥାଂଶର ସଂଖ୍ୟା କିଏ କହିପାରେ; ଧାର୍ମିକର ମରଣ ମୁଁ ମରେ, ମୋହର ଶେଷାବସ୍ଥା ତାହାର ତୁଲ୍ୟ ହେଉ।” ");
INSERT INTO ory_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ଏଥିରେ ବାଲାକ ବିଲୀୟମ୍‍କୁ କହିଲେ, “ତୁମ୍ଭେ ଆମ୍ଭ ପ୍ରତି ଏ କି କଲ? ଆମ୍ଭର ଶତ୍ରୁମାନଙ୍କୁ ଅଭିଶାପ ଦେବା ପାଇଁ ଆମ୍ଭେ ତୁମ୍ଭକୁ ନେଇଗଲୁ, ଆଉ ଦେଖ, ତୁମ୍ଭେ ସେମାନଙ୍କୁ ସର୍ବୋତୋଭାବେ ଆଶୀର୍ବାଦ କଲ।” ");
INSERT INTO ory_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ତହିଁରେ ସେ ଉତ୍ତର ଦେଇ କହିଲା, “ସଦାପ୍ରଭୁ ମୋʼ ମୁଖରେ ଯେଉଁ କଥା ଦିଅନ୍ତି, ସାବଧାନ ହୋଇ ତାହା ହିଁ କହିବା କି ମୋହର ଉଚିତ ନୁହେଁ?” ");
INSERT INTO ory_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ଏଉତ୍ତାରେ ବାଲାକ କହିଲେ, “ଆମ୍ଭେ ନିବେଦନ କରୁଅଛୁ, ତୁମ୍ଭେ ଯେଉଁ ସ୍ଥାନରୁ ସେମାନଙ୍କୁ ଦେଖି ପାରିବ, ଏପରି ଅନ୍ୟ ଏକ ସ୍ଥାନକୁ ଆମ୍ଭ ସଙ୍ଗେ ଆସ; ତୁମ୍ଭେ କେବଳ ସେମାନଙ୍କର ଶେଷସୀମାସ୍ଥିତ ଲୋକମାନଙ୍କୁ ଦେଖିବ, ମାତ୍ର ସମସ୍ତଙ୍କୁ ଦେଖି ପାରିବ ନାହିଁ; ସେହିଠାରୁ ଆମ୍ଭ ନିମନ୍ତେ ସେମାନଙ୍କୁ ଅଭିଶାପ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ସେତେବେଳେ ବାଲାକ ତାହାକୁ ପିସ୍ଗାର ପୃଷ୍ଠସ୍ଥିତ ସୋଫୀମ୍‍ କ୍ଷେତ୍ରକୁ ନେଇଯାଇ ସେହି ସ୍ଥାନରେ ସାତ ବେଦି ନିର୍ମାଣ କଲେ, ପୁଣି, ପ୍ରତ୍ୟେକ ବେଦିରେ ଏକ ଏକ ଗୋବତ୍ସ ଓ ଏକ ଏକ ମେଷ ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ତହୁଁ ସେ ବାଲାକଙ୍କୁ କହିଲା, “ମୁଁ ଯେପର୍ଯ୍ୟନ୍ତ ସେହି ସ୍ଥାନରେ ପରମେଶ୍ୱରଙ୍କ ସହିତ ସାକ୍ଷାତ କରିବି, ସେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେ ଏହି ସ୍ଥାନରେ ଆପଣା ହୋମବଳି ନିକଟରେ ଠିଆ ହୋଇଥାଅ।” ");
INSERT INTO ory_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ଏଥିରେ ସଦାପ୍ରଭୁ ବିଲୀୟମ୍‍ ସହିତ ସାକ୍ଷାତ କଲେ, ପୁଣି, ତାହାର ମୁଖରେ ଗୋଟିଏ, ବାକ୍ୟ ଦେଇ ତାହାକୁ କହିଲେ, “ତୁମ୍ଭେ ବାଲାକ ନିକଟକୁ ଫେରିଯାଇ ତାହାକୁ ଏହି କଥା କହିବ।” ");
INSERT INTO ory_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ତହୁଁ ସେ ତାଙ୍କ ନିକଟକୁ ଆସିଲା, ଆଉ ଦେଖ, ସେ ଆପଣା ହୋମବଳି ନିକଟରେ ଠିଆ ହୋଇଥିଲେ, ଆଉ ମୋୟାବର ଅଧିପତିମାନେ ତାଙ୍କ ସଙ୍ଗରେ ଥିଲେ। ତେବେ ବାଲାକ ତାକୁ ପଚାରିଲେ, “ସଦାପ୍ରଭୁ କଅଣ କହିଅଛନ୍ତି?” ");
INSERT INTO ory_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ତହିଁରେ ସେ ଆପଣା ପ୍ରସଙ୍ଗ ନେଇ କହିଲା, “ହେ ବାଲାକ, ଉଠ, ଶ୍ରବଣ କର; ହେ ସିପ୍ପୋରର ପୁତ୍ର, ମୋʼ କଥାରେ କର୍ଣ୍ଣପାତ କର। ");
INSERT INTO ory_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ପରମେଶ୍ୱର ମନୁଷ୍ୟ ନୁହନ୍ତି ଯେ, ସେ ମିଥ୍ୟା କହିବେ; କିଅବା ସେ ମନୁଷ୍ୟର ସନ୍ତାନ ନୁହନ୍ତି ଯେ, ସେ ଅନୁତାପ କରିବେ; ସେ କହିଅଛନ୍ତି, ଆଉ ସେ କି ତାହା କରିବେ ନାହିଁ? ସେ କହିଅଛନ୍ତି, ଆଉ ତାହା କି ସେ ସିଦ୍ଧ କରିବେ ନାହିଁ? ");
INSERT INTO ory_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ଦେଖ, ମୁଁ ଆଶୀର୍ବାଦ କରିବାକୁ ଆଜ୍ଞା ପାଇଅଛି; ପୁଣି, ସେ ଆଶୀର୍ବାଦ କରିଅଛନ୍ତି, ଏଣୁ ମୁଁ ତାହା ଅନ୍ୟଥା କରି ନ ପାରେ। ");
INSERT INTO ory_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ସେ ଯାକୁବ ମଧ୍ୟରେ ଅଧର୍ମ ଦୃଷ୍ଟିଗୋଚର କରି ନାହାନ୍ତି, କିଅବା ସେ ଇସ୍ରାଏଲ ମଧ୍ୟରେ ଉପଦ୍ରବ ଦେଖି ନାହାନ୍ତି; ସେମାନଙ୍କର ପରମେଶ୍ୱର ସଦାପ୍ରଭୁ ସେମାନଙ୍କ ସଙ୍ଗରେ ଅଛନ୍ତି, ପୁଣି, ରାଜାର ଜୟଧ୍ୱନି ସେମାନଙ୍କ ମଧ୍ୟରେ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ପରମେଶ୍ୱର ସେମାନଙ୍କୁ ମିସରରୁ ବାହାର କରି ଆଣୁଅଛନ୍ତି; ଅରଣା ଷଣ୍ଢ ତୁଲ୍ୟ ସେମାନଙ୍କର ବଳ। ");
INSERT INTO ory_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ନିତାନ୍ତ ଯାକୁବ ପାଇଁ କୌଣସି ଗଣକତା ନାହିଁ, କିଅବା ଇସ୍ରାଏଲ ପାଇଁ କୌଣସି ମନ୍ତ୍ର ନାହିଁ; ଏହିକ୍ଷଣି ଯାକୁବ ଓ ଇସ୍ରାଏଲ ବିଷୟରେ କୁହାଯିବ, ‘ପରମେଶ୍ୱର କି କର୍ମ କରିଅଛନ୍ତି!’ ");
INSERT INTO ory_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ଦେଖ, ସେହି ଲୋକସମୂହ ସିଂହୀ ପରି ଉଠୁଅଛନ୍ତି; ପୁଣି, ସେ ସିଂହ ପରି ଆପଣାକୁ ଉଠାଉଅଛି; ଯେପର୍ଯ୍ୟନ୍ତ ସେ ଶିକାର ଭୋଜନ ନ କରେ ଓ ହତ ଲୋକମାନଙ୍କର ରକ୍ତ ପାନ ନ କରେ, ସେପର୍ଯ୍ୟନ୍ତ ଶୟନ କରିବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ଏଥିଉତ୍ତାରେ ବାଲାକ ବିଲୀୟମ୍‍କୁ କହିଲେ, “ତୁମ୍ଭେ ସେମାନଙ୍କୁ କିଛି ଅଭିଶାପ ଦିଅ ନାହିଁ, କିଅବା ସେମାନଙ୍କୁ କିଛି ଆଶୀର୍ବାଦ କର ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ତହିଁରେ ବିଲୀୟମ୍‍ ଉତ୍ତର ଦେଇ ବାଲାକଙ୍କୁ କହିଲା, “ସଦାପ୍ରଭୁ ମୋତେ ଯାହା କିଛି କହିବେ, ତାହା ହିଁ ମୁଁ କରିବି; ଏହା କି ମୁଁ ତୁମ୍ଭକୁ କହି ନାହିଁ?” ");
INSERT INTO ory_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ତହୁଁ ବାଲାକ ବିଲୀୟମ୍‍କୁ କହିଲେ, “ବିନୟ କରୁଅଛୁ, ଆସ, ଆମ୍ଭେ ତୁମ୍ଭକୁ ଅନ୍ୟ ଏକ ସ୍ଥାନକୁ ନେଇଯିବା; ହୋଇପାରେ, ସେହି ସ୍ଥାନରେ ଆମ୍ଭ ନିମନ୍ତେ ସେମାନଙ୍କୁ ଅଭିଶାପ ଦେବାର ପରମେଶ୍ୱରଙ୍କ ଦୃଷ୍ଟିରେ ଉପଯୁକ୍ତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ଏଣୁ ବାଲାକ ବିଲୀୟମ୍‍କୁ ମରୁଭୂମି ଅଭିମୁଖରେ ପିୟୋର ଶିଖରକୁ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ତହିଁରେ ବିଲୀୟମ୍‍ ବାଲାକଙ୍କୁ କହିଲା, “ଏହି ସ୍ଥାନରେ ମୋʼ ପାଇଁ ସାତଗୋଟି ବେଦି ନିର୍ମାଣ କର ଓ ଏହି ସ୍ଥାନରେ ମୋʼ ନିମନ୍ତେ ସାତ ଗୋବତ୍ସ ଓ ସାତ ମେଷ ଆୟୋଜନ କର।” ");
INSERT INTO ory_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ତହୁଁ ବାଲାକ ବିଲୀୟମ୍‍ର କଥାନୁସାରେ କଲେ ଓ ପ୍ରତ୍ୟେକ ବେଦିରେ ଏକ ଏକ ଗୋବତ୍ସ ଓ ଏକ ଏକ ମେଷ ଉତ୍ସର୍ଗ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲକୁ ଆଶୀର୍ବାଦ କରିବା ସଦାପ୍ରଭୁଙ୍କ ଦୃଷ୍ଟିରେ ଭଲ, ଏହା ଦେଖି ବିଲୀୟମ୍‍ ପୂର୍ବ ପରି ଗଣକତା ସାଧିବା ପାଇଁ ଗଲା ନାହିଁ, ମାତ୍ର ପ୍ରାନ୍ତର ଆଡ଼େ ଆପଣା ମୁଖ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ତହିଁରେ ବିଲୀୟମ୍‍ ଅନାଇ ଇସ୍ରାଏଲକୁ ଆପଣା ବଂଶାନୁସାରେ ବାସ କରିବାର ଦେଖିଲା; ପୁଣି, ପରମେଶ୍ୱରଙ୍କ ଆତ୍ମା ତାହା ଉପରେ ଅଧିଷ୍ଠାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ତେବେ ସେ ଆପଣା ପ୍ରସଙ୍ଗ ନେଇ କହିଲା, “ବିୟୋରର ପୁତ୍ର ବିଲୀୟମ୍‍ କହୁଅଛି ଓ ଯାହାର ଚକ୍ଷୁ ପ୍ରସନ୍ନ ହୋଇଅଛି, ସେହି ବ୍ୟକ୍ତି କହୁଅଛି, ");
INSERT INTO ory_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ଯେ ପରମେଶ୍ୱରଙ୍କ ବାକ୍ୟ ଶୁଣୁଅଛି, ଯେ ସର୍ବଶକ୍ତିମାନଙ୍କର ଦର୍ଶନ ପାଉଅଛି, ସେ ତଳେ ପଡ଼ି ଓ ପ୍ରସନ୍ନ ଚକ୍ଷୁ ହୋଇ କହୁଅଛି। ");
INSERT INTO ory_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ହେ ଯାକୁବ, ତୁମ୍ଭର ତମ୍ବୁସବୁ, ହେ ଇସ୍ରାଏଲ, ତୁମ୍ଭର ଆବାସ ସବୁ କିପରି ମନୋହର! ");
INSERT INTO ory_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ତାହାସବୁ ଉପତ୍ୟକା ତୁଲ୍ୟ ବିସ୍ତାରିତ, ନଦୀତୀରସ୍ଥ ଉଦ୍ୟାନ ତୁଲ୍ୟ, ସଦାପ୍ରଭୁଙ୍କ ରୋପିତ ଅଗୁରୁ ବୃକ୍ଷ ସଦୃଶ, ଜଳ ନିକଟସ୍ଥ ଏରସ ବୃକ୍ଷ ସଦୃଶ ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ତାହାର କଳସରୁ ଜଳ ଉଚ୍ଛୁଳିବ, ତାହାର ବୀଜ ଅନେକ ଜଳରେ ପଡ଼ିବ, ପୁଣି, ତାହାର ରାଜା ଆଗାଗଠାରୁ ଉଚ୍ଚୀକୃତ ହେବେ ଓ ତାହାର ରାଜ୍ୟ ଉନ୍ନତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ପରମେଶ୍ୱର ତାହାକୁ ମିସରରୁ ବାହାର କରି ଆଣୁଅଛନ୍ତି; ତାହାର ବଳ ଅରଣାର ଷଣ୍ଢ ତୁଲ୍ୟ; ସେ ଆପଣା ବିପକ୍ଷ ଦେଶୀୟମାନଙ୍କୁ ଗ୍ରାସ କରିବ ଓ ସେମାନଙ୍କର ଅସ୍ଥିସବୁ ଚୂର୍ଣ୍ଣ କରିବ ଓ ଆପଣା ବାଣ ଦ୍ୱାରା ସେମାନଙ୍କୁ ଭେଦ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ସେ ନଇଁ ପଡ଼ିଲା, ସେ ସିଂହ ତୁଲ୍ୟ ଓ ସିଂହୀ ତୁଲ୍ୟ ଶୟନ କଲା; କିଏ ତାହାକୁ ଉଠାଇବ? ଯେଉଁମାନେ ତୁମ୍ଭକୁ ଆଶୀର୍ବାଦ କରନ୍ତି, ସେମାନେ ପ୍ରତ୍ୟେକେ ଆଶୀର୍ବାଦ ପ୍ରାପ୍ତ ହେଉନ୍ତୁ, ଯେଉଁମାନେ ତୁମ୍ଭକୁ ଅଭିଶାପ ଦିଅନ୍ତି, ସେମାନେ ପ୍ରତ୍ୟେକେ ଅଭିଶପ୍ତ ହେଉନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ଏଥିରେ ବିଲୀୟମ୍‍ ବିରୁଦ୍ଧରେ ବାଲାକଙ୍କ କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା, ତହୁଁ ସେ ଆପଣା ହାତରେ ହାତ ମାରିଲେ; ପୁଣି, ବାଲାକ ବିଲୀୟମ୍‍କୁ କହିଲେ, “ଆମ୍ଭେ ଆପଣା ଶତ୍ରୁମାନଙ୍କୁ ଅଭିଶାପ ଦେବା ପାଇଁ ତୁମ୍ଭକୁ ଡାକିଲୁ, ମାତ୍ର ଦେଖ, ତୁମ୍ଭେ ଏହି ତିନି ଥର ସେମାନଙ୍କୁ ସର୍ବୋତଭାବେ ଆଶୀର୍ବାଦ କଲ। ");
INSERT INTO ory_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ଏନିମନ୍ତେ ତୁମ୍ଭେ ଏବେ ଆପଣା ସ୍ଥାନକୁ ପଳାଅ; ତୁମ୍ଭକୁ ଅତି ସମ୍ଭ୍ରାନ୍ତ କରିବାକୁ ଆମ୍ଭର ବିଚାର ଥିଲା; ମାତ୍ର ଦେଖ, ସଦାପ୍ରଭୁ ତୁମ୍ଭକୁ ସମ୍ଭ୍ରମ ପାଇବାରୁ ବାରଣ କରିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ତହିଁରେ ବିଲୀୟମ୍‍ ବାଲାକଙ୍କୁ କହିଲା, “ମୋʼ ନିକଟକୁ ତୁମ୍ଭେ ଯେଉଁ ଦୂତମାନଙ୍କୁ ପଠାଇଥିଲ, ସେମାନଙ୍କୁ ମୁଁ କʼଣ କହି ନାହିଁ? ");
INSERT INTO ory_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ଯଦିଓ ବାଲାକ ସୁନା ରୂପାରେ ପୂର୍ଣ୍ଣ ଆପଣା ଗୃହ ମୋତେ ଦେବ, ତେବେ ମୁଁ ଆପଣା ଇଚ୍ଛାରେ ଭଲ କି ମନ୍ଦ କରିବା ପାଇଁ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟର ବାହାରେ ଯାଇ ନ ପାରେ; ଯାହା ସଦାପ୍ରଭୁ କହନ୍ତି, ତାହା ହିଁ ମୁଁ କହିବି।’ ");
INSERT INTO ory_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ଏବେ ଦେଖ, ମୁଁ ଆପଣା ଲୋକମାନଙ୍କ ନିକଟକୁ ଯାଉଅଛି; ଆସ, ଏହି ଲୋକମାନେ ଭବିଷ୍ୟତରେ ତୁମ୍ଭ ଲୋକମାନଙ୍କ ପ୍ରତି ଯାହା କରିବେ, ତାହା ମୁଁ ତୁମ୍ଭକୁ ଜ୍ଞାତ କରାଇବି।” ");
INSERT INTO ory_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ଏଥିରେ ସେ ଆପଣା ପ୍ରସଙ୍ଗ ନେଇ କହିଲା, “ବିୟୋରର ପୁତ୍ର ବିଲୀୟମ୍‍ କହୁଅଛି, ଯାହାର ଚକ୍ଷୁ ପ୍ରସନ୍ନ ହୋଇଅଛି, ସେହି ବ୍ୟକ୍ତି କହୁଅଛି; ");
INSERT INTO ory_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ଯେ ପରମେଶ୍ୱରଙ୍କ ବାକ୍ୟ ଶୁଣୁଅଛି ଓ ସର୍ବୋପରିସ୍ଥଙ୍କର ତତ୍ତ୍ୱ ଜାଣୁଅଛି, ଯେ ସର୍ବଶକ୍ତିମାନଙ୍କର ଦର୍ଶନ ପାଉଅଛି, ସେ ତଳେ ପଡ଼ି ଓ ପ୍ରସନ୍ନ ଚକ୍ଷୁ ହୋଇ କହୁଅଛି; ");
INSERT INTO ory_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ମୁଁ ତାହାଙ୍କୁ ଦେଖୁଅଛି, ମାତ୍ର ସେ ବର୍ତ୍ତମାନ ନୁହନ୍ତି; ମୁଁ ତାହାଙ୍କର ଦର୍ଶନ ପାଉଅଛି, ମାତ୍ର ସେ ନିକଟବର୍ତ୍ତୀ ନୁହନ୍ତି; ଯାକୁବଠାରୁ ଏକ ତାରା ଉଦିତ ହେବ ଓ ଇସ୍ରାଏଲଠାରୁ ଏକ ରାଜଦଣ୍ଡ ଉତ୍ଥିତ ହେବ, ତାହା ମୋୟାବର ପାର୍ଶ୍ୱ ଭେଦ କରିବ ଓ ଶେଥର ସମସ୍ତ ସନ୍ତାନକୁ ଚୂର୍ଣ୍ଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ପୁଣି, ଇଦୋମ ଏକ ଅଧିକାର ହେବ, ଯେଉଁମାନେ ତାହାର ଶତ୍ରୁ ଥିଲେ, ଏପରି ସେୟୀର ମଧ୍ୟ ଏକ ଅଧିକାର ହେବ, ମାତ୍ର ଇସ୍ରାଏଲ ବୀରର କର୍ମ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ପୁଣି, ଯାକୁବଠାରୁ ଉତ୍ପନ୍ନ ଏକ ଜଣ କର୍ତ୍ତୃତ୍ୱ କରିବେ ଓ ଅବଶିଷ୍ଟ ଲୋକମାନଙ୍କୁ ନଗରରୁ ବିନଷ୍ଟ କରିବେ।” ");
INSERT INTO ory_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ଏଉତ୍ତାରେ ସେ ଅମାଲେକ ପ୍ରତି ଦୃଷ୍ଟି କରି ଆପଣା ପ୍ରସଙ୍ଗ ନେଇ କହିଲା, “ଅମାଲେକ ନାନା ଦେଶୀୟମାନଙ୍କ ମଧ୍ୟରେ ଅଗ୍ରଗଣ୍ୟ ଥିଲା; ମାତ୍ର ତାହାର ଶେଷାବସ୍ଥା ବିନାଶରେ ଉପସ୍ଥିତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ତହୁଁ ସେ କେନୀୟମାନଙ୍କ ପ୍ରତି ଦୃଷ୍ଟି କରି ଆପଣା ପ୍ରସଙ୍ଗ ନେଇ କହିଲା, “ତୁମ୍ଭର ନିବାସ ସ୍ଥାନ ଅତି ଦୃଢ଼ ଓ ତୁମ୍ଭର ବସା ଶୈଳ ଉପରେ ସ୍ଥାପିତ। ");
INSERT INTO ory_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ତଥାପି କେନୀୟ କ୍ଷୟପ୍ରାପ୍ତ ହେବ, ଶେଷରେ ଅଶୂର ତୁମ୍ଭକୁ ବନ୍ଦୀ କରି ନେଇଯିବ।” ");
INSERT INTO ory_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ଏଉତ୍ତାରେ ସେ ଆପଣା ପ୍ରସଙ୍ଗ ନେଇ କହିଲା, “ହାୟ ହାୟ, ଯେତେବେଳେ ପରମେଶ୍ୱର ଏହା କରିବେ, ସେତେବେଳେ କିଏ ବଞ୍ଚିବ? ");
INSERT INTO ory_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ମାତ୍ର କିତ୍ତୀମ-ତୀରରୁ ଜାହାଜମାନ ଆସିବ ଓ ସେମାନେ ଅଶୂରକୁ ଦୁଃଖ ଦେବେ, ଆଉ ଏବରକୁ ଦୁଃଖ ଦେବେ, ପୁଣି, ସେ ମଧ୍ୟ ବିନାଶରେ ଉପସ୍ଥିତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ଏଉତ୍ତାରେ ବିଲୀୟମ୍‍ ଉଠି ସ୍ୱ ସ୍ଥାନକୁ ପ୍ରସ୍ଥାନ କଲା ଓ ବାଲାକ ମଧ୍ୟ ଆପଣା ପଥରେ ଚାଲିଗଲେ। ");
INSERT INTO ory_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ଏଥିଉତ୍ତାରେ ଇସ୍ରାଏଲ ଶିଟୀମରେ ବାସ କଲେ, ପୁଣି, ଲୋକମାନେ ମୋୟାବର କନ୍ୟାଗଣ ସହିତ ବ୍ୟଭିଚାର କରିବାକୁ ଲାଗିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ପୁଣି, ସେହି କନ୍ୟାମାନେ ଲୋକମାନଙ୍କୁ ଆପଣାମାନଙ୍କ ଦେବଗଣର ବଳିଦାନ ଉପଲକ୍ଷ୍ୟରେ ନିମନ୍ତ୍ରଣ କଲେ; ପୁଣି, ଲୋକମାନେ ଭୋଜନ କଲେ ଓ ସେମାନଙ୍କ ଦେବଗଣକୁ ପ୍ରଣାମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ଆଉ ଇସ୍ରାଏଲ ଆପେ ବାଲ୍‍-ପିୟୋର ପ୍ରତି ଆସକ୍ତ ହେଲେ; ଏଣୁ ସଦାପ୍ରଭୁଙ୍କର କ୍ରୋଧ ଇସ୍ରାଏଲର ପ୍ରତିକୂଳରେ ପ୍ରଜ୍ୱଳିତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ଏଥିରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ଲୋକମାନଙ୍କର ସମସ୍ତ ପ୍ରଧାନବର୍ଗଙ୍କୁ ନେଇ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସୂର୍ଯ୍ୟ ସମ୍ମୁଖରେ ସେମାନଙ୍କୁ ଟଙ୍ଗାଅ, ତହିଁରେ ଇସ୍ରାଏଲଠାରୁ ସଦାପ୍ରଭୁଙ୍କର ପ୍ରଚଣ୍ଡ କ୍ରୋଧ ଫେରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ତହୁଁ ମୋଶା ଇସ୍ରାଏଲର ବିଚାରକର୍ତ୍ତୃଗଣକୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକେ ବାଲ୍‍-ପିୟୋର ପ୍ରତି ଆସକ୍ତ ଆପଣା ଆପଣା ଲୋକମାନଙ୍କୁ ବଧ କର।” ");
INSERT INTO ory_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ଏଥିରେ ଦେଖ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ମଧ୍ୟରୁ ଜଣେ ମୋଶାଙ୍କର ସାକ୍ଷାତରେ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ସମସ୍ତ ମଣ୍ଡଳୀ ସାକ୍ଷାତରେ ଆପଣା ଜ୍ଞାତିମାନଙ୍କ ନିକଟକୁ ଏକ ମିଦୀୟନୀୟା ସ୍ତ୍ରୀକୁ ଆଣିଲା, ସେତେବେଳେ ଲୋକମାନେ ସମାଗମ-ତମ୍ବୁ ନିକଟରେ ରୋଦନ କରୁଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ତେବେ ହାରୋଣ ଯାଜକର ପୌତ୍ର, ଇଲୀୟାସରର ପୁତ୍ର ପୀନହସ୍‍ ତାହା ଦେଖି ମଣ୍ଡଳୀ ମଧ୍ୟରୁ ଉଠି ହାତରେ ଏକ ବର୍ଚ୍ଛା ନେଲା; ");
INSERT INTO ory_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ପୁଣି, ସେ ଇସ୍ରାଏଲୀୟ ସେହି ପୁରୁଷର ପଛେ ପଛେ ତମ୍ବୁ ଭିତରେ ପ୍ରବେଶ କରି ସେହି ଦୁଇ ଜଣକୁ, ଅର୍ଥାତ୍‍, ସେହି ଇସ୍ରାଏଲୀୟ ପୁରୁଷକୁ ଓ ସେହି ସ୍ତ୍ରୀର ପେଟକୁ ବିନ୍ଧି ପକାଇଲା। ତହିଁରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ମାରୀ ନିବୃତ୍ତ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ତଥାପି ଚବିଶ ହଜାର ଲୋକ ଏହି ମାରୀରେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ହାରୋଣ ଯାଜକର ପୌତ୍ର, ଇଲୀୟାସରର ପୁତ୍ର ପୀନହସ୍‍ ଲୋକମାନଙ୍କ ପ୍ରତି ଆମ୍ଭ ଅନ୍ତର୍ଜ୍ୱାଳାରେ ଅନ୍ତର୍ଜ୍ୱାଳା ପ୍ରକାଶ କରି ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଠାରୁ ଆମ୍ଭର କ୍ରୋଧ ଫେରାଇଅଛି, ତହିଁରେ ଆମ୍ଭେ ଆପଣା ଅନ୍ତର୍ଜ୍ୱାଳାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ନିଃଶେଷ ରୂପେ ସଂହାର କଲୁ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ଏହେତୁ ତୁମ୍ଭେ କୁହ, “ଦେଖ, ଆମ୍ଭେ ତାହାକୁ ଆପଣା ଶାନ୍ତିକର ନିୟମ ଦେଲୁ; ");
INSERT INTO ory_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ତହିଁରେ ତାହା ପ୍ରତି ଓ ତାହା ଉତ୍ତାରେ ତାହାର ସନ୍ତାନଗଣଙ୍କ ପ୍ରତି ଅନନ୍ତକାଳୀନ ଯାଜକତ୍ୱର ନିୟମ ହେବ; କାରଣ ସେ ଆପଣା ପରମେଶ୍ୱରଙ୍କ ପକ୍ଷରେ ଅନ୍ତର୍ଜ୍ୱାଳା ପ୍ରକାଶ କଲା ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କଲା।” ");
INSERT INTO ory_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ଇସ୍ରାଏଲୀୟ ଯେଉଁ ହତ ପୁରୁଷ, ଯେ ସେହି ମିଦୀୟନୀୟା ସ୍ତ୍ରୀ ସହିତ ହତ ହୋଇଥିଲା, ତାହାର ନାମ ସିମ୍ରି, ସେ ଶିମୀୟୋନୀୟ ପିତୃଗୃହର ଅଧିପତି ସାଲୂର ପୁତ୍ର। ");
INSERT INTO ory_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ପୁଣି, ସେହି ହତ ମିଦୀୟନୀୟା ସ୍ତ୍ରୀର ନାମ କସ୍ୱୀ, ସେ ସୂରର କନ୍ୟା; ସେହି ସୂର୍‍ ମିଦୀୟନୀୟ ଏକ ପିତୃଗୃହର ଲୋକମାନଙ୍କ ମଧ୍ୟରେ ପ୍ରଧାନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ମିଦୀୟନୀୟ ଲୋକମାନଙ୍କୁ କ୍ଳେଶ ଦିଅ ଓ ସେମାନଙ୍କୁ ବଧ କର; ");
INSERT INTO ory_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","କାରଣ ପିୟୋର (ଦେବତା) ବିଷୟକ ଛଳରେ ଓ ସେହି ପିୟୋର ଲାଗି ମାରୀ ଦିନରେ ହତ ହେଲା ଯେ ସେମାନଙ୍କ ଆତ୍ମୀୟା କସ୍ୱୀ ନାମ୍ନୀ ମିଦୀୟନୀୟ ରାଜକୁମାରୀ, ତାହାରି ବିଷୟକ ଛଳରେ ସେମାନେ ତୁମ୍ଭମାନଙ୍କୁ ଛଳ କରି କ୍ଳେଶ ଦେଲେ।” ");
INSERT INTO ory_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ସେହି ମାରୀ ଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଓ ହାରୋଣଙ୍କ ପୁତ୍ର ଇଲୀୟାସର ଯାଜକକୁ, କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସମସ୍ତ ମଣ୍ଡଳୀ ମଧ୍ୟରୁ ଆପଣା ଆପଣା ପିତୃଗୃହାନୁସାରେ କୋଡ଼ିଏ ବର୍ଷ ବୟସ୍କ ଓ ତହିଁରୁ ଅଧିକ ବୟସ୍କ ଲୋକମାନଙ୍କର, ଅର୍ଥାତ୍‍, ଇସ୍ରାଏଲ ସୈନ୍ୟଶ୍ରେଣୀଭୁକ୍ତ ସମସ୍ତ ଲୋକଙ୍କର ଗଣନା କର।” ");
INSERT INTO ory_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ତହିଁରେ ମୋଶା ଓ ଇଲୀୟାସର ଯାଜକ ଯିରୀହୋର ନିକଟସ୍ଥିତ ଯର୍ଦ୍ଦନ ସମୀପରେ ମୋୟାବ-ପଦାରେ ଲୋକମାନଙ୍କ ସଙ୍ଗେ କଥା କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“ମୋଶା ପ୍ରତି ଓ ମିସର ଦେଶରୁ ବହିର୍ଗତ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ, କୋଡ଼ିଏ ବର୍ଷ ବୟସ୍କ ଅବଧି ସମସ୍ତ ଲୋକର ଗଣନା କର।” ");
INSERT INTO ory_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ରୁବେନ୍‍, ଇସ୍ରାଏଲର ଜ୍ୟେଷ୍ଠ ପୁତ୍ର; ରୁବେନ୍‍ର ସନ୍ତାନ ହନୋକଠାରୁ ହନୋକୀୟ ବଂଶ; ପଲ୍ଲୁଠାରୁ ପଲ୍ଲୁୟୀୟ ବଂଶ; ");
INSERT INTO ory_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ହିଷ୍ରୋଣଠାରୁ ହିଷ୍ରୋଣୀୟ ବଂଶ; କର୍ମ୍ମିଠାରୁ କର୍ମିୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ଏମାନେ ରୁବେନ୍‍ର ବଂଶ; ପୁଣି, ଏମାନେ ଗଣାଯାʼନ୍ତେ, ତେୟାଳିଶ ହଜାର ସାତ ଶହ ତିରିଶ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ପଲ୍ଲୁର ସନ୍ତାନ ଇଲୀୟାବ୍‍। ");
INSERT INTO ory_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ସେହି ଇଲୀୟାବ୍‍ର ସନ୍ତାନ ନମୂୟେଲ, ଦାଥନ ଓ ଅବୀରାମ; କୋରହର ଦଳୀୟ ଲୋକମାନେ ଯେତେବେଳେ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତିକୂଳରେ ବିବାଦ କଲେ, ସେତେବେଳେ ସେମାନଙ୍କ ମଧ୍ୟରୁ ମଣ୍ଡଳୀର ଆହୂତ ଲୋକ ଯେ ଦାଥନ ଓ ଅବୀରାମ ମୋଶାଙ୍କ ବିରୁଦ୍ଧରେ ଓ ହାରୋଣଙ୍କ ବିରୁଦ୍ଧରେ ବିବାଦ କରିଥିଲେ, ସେମାନେ ଏହି ଦୁଇ ଜଣ। ");
INSERT INTO ory_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ସେହି ସମୟରେ ପୃଥିବୀ ଆପଣା ମୁଖ ମେଲାଇ ସେମାନଙ୍କୁ ଓ କୋରହକୁ ଗ୍ରାସ କଲା, ତହିଁରେ ସେହି ଦଳ ନଷ୍ଟ ହେଲେ, ପୁଣି, ଅଗ୍ନି ଦୁଇ ଶହ ପଚାଶ ଜଣକୁ ଦଗ୍ଧ କଲା, ସେମାନେ ଚିହ୍ନସ୍ୱରୂପ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ତଥାପି କୋରହର ସନ୍ତାନମାନେ ମଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଶିମୀୟୋନର ସନ୍ତାନ; ନମୂୟେଲଠାରୁ ନମୂୟେଲୀୟ ବଂଶ; ଯାମୀନ୍‍ଠାରୁ ଯାମୀନୀୟ ବଂଶ; ଯାଖୀନ୍‍ଠାରୁ ଯାଖୀନୀୟ ବଂଶ; ");
INSERT INTO ory_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ସେରହଠାରୁ ସେରହୀୟ ବଂଶ; ଶୌଲଠାରୁ ଶୌଲୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ଶିମୀୟୋନୀୟ ଏହି ସକଳ ବଂଶ ବାଇଶ ହଜାର ଦୁଇ ଶହ ଲୋକ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଗାଦ୍‍ର ସନ୍ତାନ; ସିଫୋନଠାରୁ ସିଫୋନୀୟ ବଂଶ; ହଗିଠାରୁ ହଗୀୟ ବଂଶ; ଶୂନୀଠାରୁ ଶୂନୀୟ ବଂଶ; ");
INSERT INTO ory_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ଓଷ୍ଣିଠାରୁ ଓଷ୍ଣୀୟ ବଂଶ, ଏରିଠାରୁ ଏରୀୟ ବଂଶ; ");
INSERT INTO ory_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ଅରୋଦିଠାରୁ ଅରୋଦୀୟ ବଂଶ, ଅରେଲୀଠାରୁ ଅରେଲୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ଗାଦ୍‍ ସନ୍ତାନମାନଙ୍କର ଏହି ସକଳ ବଂଶ ଗଣାଯାʼନ୍ତେ, ଚାଳିଶ ହଜାର ପାଞ୍ଚ ଶହ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ଯିହୁଦାର ପୁତ୍ର ଏର ଓ ଓନନ୍‍; ସେହି ଏର ଓ ଓନନ୍‍ କିଣାନ ଦେଶରେ ମରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଯିହୁଦାର ସନ୍ତାନ; ଶେଲାଠାରୁ ଶେଲାୟୀୟ ବଂଶ; ପେରସଠାରୁ ପେରସୀୟ ବଂଶ; ସେରହଠାରୁ ସେରହୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ପୁଣି, ପେରସର ଏହି ସକଳ ସନ୍ତାନ ହିଷ୍ରୋଣଠାରୁ ହିଷ୍ରୋଣୀୟ ବଂଶ; ହାମୂଲଠାରୁ ହାମୂଲୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ଯିହୁଦାର ଏହିସବୁ ବଂଶ ଗଣାଯାʼନ୍ତେ, ଛସ୍ତରି ହଜାର ପାଞ୍ଚ ଶହ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଇଷାଖରର ସନ୍ତାନ; ତୋଲୟଠାରୁ ତୋଲୟୀୟ ବଂଶ; ପୂୟଠାରୁ ପୂୟୀୟ ବଂଶ; ");
INSERT INTO ory_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ଯାଶୂବଠାରୁ ଯାଶୂବୀୟ ବଂଶ; ଶିମ୍ରୋଣଠାରୁ ଶିମ୍ରୋଣୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ଇଷାଖରର ଏହି ସକଳ ବଂଶ ଗଣାଯାʼନ୍ତେ, ଚଉଷଠି ହଜାର ତିନି ଶହ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ସବୂଲୂନର ସନ୍ତାନ; ସେରଦଠାରୁ ସେରଦୀୟ ବଂଶ; ଏଲୋନ୍‍ଠାରୁ ଏଲୋନୀୟ ବଂଶ; ଯହଲେଲଠାରୁ ଯହଲେଲୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ସବୂଲୂନର ଏହି ସକଳ ବଂଶ ଗଣାଯାʼନ୍ତେ, ଷାଠିଏ ହଜାର ପାଞ୍ଚ ଶହ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଯୋଷେଫଙ୍କ ପୁତ୍ର ମନଃଶି ଓ ଇଫ୍ରୟିମ। ");
INSERT INTO ory_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ମନଃଶିର ସନ୍ତାନ; ମାଖୀରଠାରୁ ମାଖରୀୟ ବଂଶ; ସେହି ମାଖୀରର ପୁତ୍ର ଗିଲୀୟଦ; ସେହି ଗିଲୀୟଦଠାରୁ ଗିଲୀୟଦୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ଗିଲୀୟଦର ସନ୍ତାନ ଏମାନେ; ଈୟେଷରଠାରୁ ଈୟେଷ୍ରୀୟ ବଂଶ; ହେଲକଠାରୁ ହେଲକୀୟ ବଂଶ, ");
INSERT INTO ory_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ଅସ୍ରୀୟେଲଠାରୁ ଅସ୍ରୀୟେଲୀୟ ବଂଶ ଓ ଶେଖମଠାରୁ ଶେଖମୀୟ ବଂଶ, ");
INSERT INTO ory_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ଶମୀଦାଠାରୁ ଶମୀଦାୟୀୟ ବଂଶ ଓ ହେଫରଠାରୁ ହେଫରୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ସେହି ହେଫରର ପୁତ୍ର ଯେ ସଲଫାଦ, ତାହାର ପୁତ୍ର ନ ଥିଲା, କେବଳ କନ୍ୟା ଥିଲା; ସେହି ସଲଫାଦର କନ୍ୟାମାନଙ୍କ ନାମ ମହଲା, ନୋୟା, ହଗ୍ଲା, ମିଲ୍କା ଓ ତିର୍ସା। ");
INSERT INTO ory_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ଏମାନେ ମନଃଶିର ବଂଶ, ଏମାନଙ୍କର ଗଣିତ ଲୋକ ବାବନ ହଜାର ସାତ ଶହ ଜଣ। ");
INSERT INTO ory_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଇଫ୍ରୟିମର ସନ୍ତାନ; ଶୂଥେଲହଠାରୁ ଶୂଥଲହୀୟ ବଂଶ; ବେଖରଠାରୁ ବେଖ୍ରୀୟ ବଂଶ; ତହନଠାରୁ ତହନୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ପୁଣି, ଶୂଥେଲହର ସନ୍ତାନ ଏମାନେ; ଏରଣଠାରୁ ଏରଣୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ଇଫ୍ରୟିମର ସନ୍ତାନମାନଙ୍କ ଏହି ସକଳ ବଂଶ ଗଣାଯାʼନ୍ତେ, ବତିଶ ହଜାର ପାଞ୍ଚ ଶହ ଲୋକ ହେଲେ; ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଏମାନେ ଯୋଷେଫର ସନ୍ତାନ। ");
INSERT INTO ory_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ବିନ୍ୟାମୀନ୍‍ର ସନ୍ତାନ; ବେଲାଠାରୁ ବେଲାୟୀୟ ବଂଶ: ଅସ୍‍ବେଲଠାରୁ ଅସ୍‍ବେଲୀୟ ବଂଶ; ଅହୀରାମଠାରୁ ଅହୀରାମୀୟ ବଂଶ; ");
INSERT INTO ory_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ଶୂଫମଠାରୁ ଶୂଫମୀୟ ବଂଶ; ହୂଫମଠାରୁ ହୂଫମୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ପୁଣି, ବେଲାର ସନ୍ତାନ ଅର୍ଦ ଓ ନାମାନ୍‍; ଅର୍ଦଠାରୁ ଅର୍ଦୀୟ ବଂଶ; ନାମାନ୍‍ଠାରୁ ନାମାନୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଏମାନେ ବିନ୍ୟାମୀନ୍‍ର ସନ୍ତାନ। ଏମାନଙ୍କର ଗଣିତ ଲୋକ ପଞ୍ଚଚାଳିଶ ହଜାର ଛଅ ଶହ ଜଣ। ");
INSERT INTO ory_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଏମାନେ ଦାନର ସନ୍ତାନ; ଶୂହମଠାରୁ ଶୂହମୀୟ ବଂଶ। ଏମାନେ ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଦାନ୍‍ର ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ଶୂହମୀୟ ସମସ୍ତ ବଂଶ ଗଣାଯାʼନ୍ତେ, ଚଉଷଠି ହଜାର ଚାରି ଶହ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଆଶେରର ସନ୍ତାନ; ଯିମ୍ନାଠାରୁ ଯିମ୍ନୀୟ ବଂଶ; ଯିଶ୍‍ବିଠାରୁ ଯିଶ୍‍ବିୟ ବଂଶ; ବରୀୟଠାରୁ ବରୀୟୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ବରୀୟର ସନ୍ତାନ ଏମାନେ; ହେବରଠାରୁ ହେବରୀୟ ବଂଶ; ମଲ୍‍କୀୟେଲଠାରୁ ମଲ୍‍କୀୟେଲୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ଆଶେରର କନ୍ୟାର ନାମ ସେରହ। ");
INSERT INTO ory_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ଆଶେରର ସନ୍ତାନମାନଙ୍କ ଏହି ସକଳ ବଂଶ ଗଣାଯାʼନ୍ତେ; ତେପନ ହଜାର ଚାରି ଶହ ଲୋକ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ନପ୍ତାଲିର ସନ୍ତାନ; ଯହସୀୟେଲଠାରୁ ଯହସୀୟେଲୀୟ ବଂଶ; ଗୂନିଠାରୁ ଗୂନୀୟ ବଂଶ; ");
INSERT INTO ory_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ଯେତ୍ସରଠାରୁ ଯେତ୍ସରୀୟ ବଂଶ; ଶିଲ୍ଲେମଠାରୁ ଶିଲ୍ଲେମୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଏହି ସକଳ ନପ୍ତାଲିର ବଂଶ। ଏମାନଙ୍କର ଗଣିତ ଲୋକ ପଞ୍ଚଚାଳିଶ ହଜାର ଚାରି ଶହ ଜଣ। ");
INSERT INTO ory_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ମଧ୍ୟରେ ଗଣିତ ଲୋକମାନଙ୍କର ସଂଖ୍ୟା ଛଅ ଲକ୍ଷ ଏକ ହଜାର ସାତ ଶହ ତିରିଶ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ନାମ-ସଂଖ୍ୟାନୁସାରେ ଅଧିକାର ନିମନ୍ତେ ଏମାନଙ୍କ ମଧ୍ୟରେ ଦେଶ ବିଭକ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ଯାହାର ଲୋକ ବହୁତ, ତୁମ୍ଭେ ତାହାକୁ ବହୁତ ଅଧିକାର ଦେବ, ପୁଣି, ଯାହାର ଲୋକ ଅଳ୍ପ, ତୁମ୍ଭେ ତାହାକୁ ଅଳ୍ପ ଅଧିକାର ଦେବ, ଯାହାର ଯେତେ ଗଣିତ ଲୋକ, ତାହାକୁ ସେତେ ଅଧିକାର ଦିଆଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ତଥାପି ଗୁଲିବାଣ୍ଟ ଦ୍ୱାରା ଦେଶ ବିଭକ୍ତ ହେବ; ସେମାନେ ଆପଣା ଆପଣା ପିତୃବଂଶ ନାମାନୁସାରେ ଅଧିକାର ପାଇବେ। ");
INSERT INTO ory_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ବହୁତ ଓ ଅଳ୍ପ ଲୋକଙ୍କ ମଧ୍ୟରେ ଗୁଲିବାଣ୍ଟ ଅନୁସାରେ ସେମାନଙ୍କର ଅଧିକାର ବିଭକ୍ତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଏମାନେ ଲେବୀୟମାନଙ୍କ ମଧ୍ୟରୁ ଗଣିତ ହେଲେ; ଗେର୍ଶୋନଠାରୁ ଗେର୍ଶୋନୀୟ ବଂଶ; କହାତଠାରୁ କହାତୀୟ ବଂଶ; ମରାରିଠାରୁ ମରାରୀୟ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ଲେବୀୟ ବଂଶ ଏହି; ଲିବ୍‍ନୀୟ ବଂଶ, ହିବ୍ରୋଣୀୟ ବଂଶ, ମହଲୀୟ ବଂଶ, ମୂଶୀୟ ବଂଶ, କୋରହୀ ବଂଶ। ");
INSERT INTO ory_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ସେହି କହାତର ପୁତ୍ର ଅମ୍ରାମ୍‍; ସେହି ଅମ୍ରମର ଯୋକେବଦ ନାମ୍ନୀ ଭାର୍ଯ୍ୟା ମିସର ଦେଶରେ ଲେବୀର ଔରସଜାତା କନ୍ୟା ଥିଲା। ସେ ଅମ୍ରମର ଔରସରେ ହାରୋଣ, ମୋଶା ଓ ସେମାନଙ୍କ ଭଗିନୀ ମରୀୟମଙ୍କୁ ପ୍ରସବ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ହାରୋଣଠାରୁ ନାଦବ୍‍ ଓ ଅବୀହୂ, ପୁଣି, ଇଲୀୟାସର ଓ ଈଥାମର ଜନ୍ମିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ମାତ୍ର ନାଦବ୍‍ ଓ ଅବୀହୂ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଇତର ଅଗ୍ନି ଉତ୍ସର୍ଗ କରନ୍ତେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ଏମାନଙ୍କ ମଧ୍ୟରେ ଏକ ମାସରୁ ଅଧିକ ବୟସ୍କ ଲୋକ ଗଣାଯାʼନ୍ତେ, ତେଇଶ ହଜାର ଜଣ ହେଲେ; କାରଣ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ସେମାନଙ୍କୁ କୌଣସି ଅଧିକାର ଦତ୍ତ ନୋହିବାରୁ ସେମାନେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମଧ୍ୟରେ ଗଣିତ ହେଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ଯିରୀହୋ ନିକଟସ୍ଥ ଯର୍ଦ୍ଦନ ସମୀପରେ ମୋୟାବ-ପଦାରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ଗଣନାକାରୀ ମୋଶା ଓ ଇଲୀୟାସର ଯାଜକ ଦ୍ୱାରା ଏସମସ୍ତେ ଗଣାଗଲେ। ");
INSERT INTO ory_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ମାତ୍ର ସୀନୟ ପ୍ରାନ୍ତରରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ଗଣନାକାରୀ ମୋଶା ଓ ହାରୋଣ ଯାଜକ ଦ୍ୱାରା ଯେଉଁମାନେ ଗଣିତ ହୋଇଥିଲେ, ସେମାନଙ୍କ ମଧ୍ୟରୁ ଜଣେ ଏମାନଙ୍କ ମଧ୍ୟରେ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","କାରଣ ସଦାପ୍ରଭୁ ସେମାନଙ୍କ ବିଷୟରେ କହିଥିଲେ ଯେ, “ସେମାନେ ଅବଶ୍ୟ ଏହି ପ୍ରାନ୍ତରରେ ମରିବେ; ଏହେତୁ ସେମାନଙ୍କ ମଧ୍ୟରୁ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ ଓ ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ ବ୍ୟତୀତ ଏକ ଜଣ ହିଁ ଅବଶିଷ୍ଟ ରହିଲା ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ଏଥିଉତ୍ତାରେ ଯୋଷେଫଙ୍କ ପୁତ୍ର ମନଃଶି ବଂଶୀୟମାନଙ୍କ ମଧ୍ୟରୁ ମନଃଶିର ବୃଦ୍ଧ ପ୍ରପୌତ୍ର, ମାଖୀରର ପ୍ରପୌତ୍ର, ଗିଲୀୟଦର ପୌତ୍ର, ହେଫରର ପୁତ୍ର ଯେ ସଲଫାଦ; ତାହାର କନ୍ୟାଗଣ ନିକଟକୁ ଆସିଲେ; ତାହାର କନ୍ୟାମାନଙ୍କ ନାମ ଏହି, ମହଲା, ନୋୟା, ହଗ୍ଲା, ମିଲ୍କା ଓ ତିର୍ସା। ");
INSERT INTO ory_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ଏମାନେ ମୋଶାଙ୍କ ସମ୍ମୁଖରେ ଓ ଇଲୀୟାସର ଯାଜକ ସମ୍ମୁଖରେ, ପୁଣି, ଅଧିପତିଗଣ ଓ ସମସ୍ତ ମଣ୍ଡଳୀର ସମ୍ମୁଖରେ ସମାଗମ-ତମ୍ବୁ ଦ୍ୱାରରେ ଠିଆ ହୋଇ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ଆମ୍ଭମାନଙ୍କ ପିତା ପ୍ରାନ୍ତରରେ ମଲେ, ପୁଣି, ଯେଉଁ କୋରହର ଦଳ ସଦାପ୍ରଭୁଙ୍କ ପ୍ରତିକୂଳରେ ଆପଣାମାନଙ୍କୁ ଏକତ୍ର କରିଥିଲେ, ସେହି ଦଳ ମଧ୍ୟରେ ସେ ନ ଥିଲେ; ମାତ୍ର ସେ ଆପଣା ପାପରେ ମଲେ; ଆଉ ତାଙ୍କର ପୁତ୍ର ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ଆମ୍ଭମାନଙ୍କ ପିତାଙ୍କର ପୁତ୍ର ନ ଥିବା ସକାଶୁ କାହିଁକି ତାଙ୍କର ନାମ ତାଙ୍କ ବଂଶରୁ ଲୋପ ପାଇବ? ଆମ୍ଭମାନଙ୍କ ପିତୃବଂଶୀୟ ଭାଇମାନଙ୍କ ମଧ୍ୟରେ ଆମ୍ଭମାନଙ୍କୁ ଅଧିକାର ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ଏଥିରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ସେମାନଙ୍କର ବିଚାର ଉପସ୍ଥିତ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ସଲଫାଦର କନ୍ୟାଗଣ ଯଥାର୍ଥ କହୁଅଛନ୍ତି; ତୁମ୍ଭେ ସେମାନଙ୍କ ପିତୃବଂଶୀୟ ଭ୍ରାତୃଗଣ ମଧ୍ୟରେ ଅବଶ୍ୟ ସେମାନଙ୍କୁ ପୈତୃକ ଅଧିକାର ଦେବ; ପୁଣି, ତୁମ୍ଭେ ସେମାନଙ୍କୁ ସେମାନଙ୍କ ପୈତୃକ ଅଧିକାର ସମର୍ପଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ଆଉ ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ‘କୌଣସି ମନୁଷ୍ୟ ମଲେ ଯଦି ତାହାର ପୁତ୍ର ନ ଥାଏ, ତେବେ ତୁମ୍ଭେମାନେ ତାହାର ଅଧିକାର ତାହାର କନ୍ୟାକୁ ସମର୍ପଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ଯଦି ତାହାର କନ୍ୟା ନ ଥାଏ, ଯଦି ତାହାର ଅଧିକାର ତାହାର ଭାଇମାନଙ୍କୁ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ପୁଣି, ଯଦି ତାହାର ଭାଇ ନ ଥାଏ, ଯଦି ତାହାର ପିତୃବ୍ୟମାନଙ୍କୁ ତାହାର ଅଧିକାର ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ଆଉ ଯଦି ତାହାର ପିତୃବ୍ୟ ନ ଥାଏ, ତେବେ ତାହାର ବଂଶ ମଧ୍ୟରୁ ନିକଟସ୍ଥ ଜ୍ଞାତିକୁ ତାହା ଅଧିକାର ଦେବ ଓ ସେ ତାହା ଅଧିକାର କରିବ; ମୋଶା ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ଏହା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ବିଚାର-ବିଧି ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେ ଏହି ଅବାରୀମ୍ ପର୍ବତ ଆରୋହଣ କର, ପୁଣି, ଆମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଯେଉଁ ଦେଶ ଦେଇଅଛୁ, ତାହା ନିରୀକ୍ଷଣ କର। ");
INSERT INTO ory_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ତାହା ନିରୀକ୍ଷଣ କଲା ଉତ୍ତାରେ ତୁମ୍ଭ ଭ୍ରାତା ହାରୋଣ ତୁଲ୍ୟ ତୁମ୍ଭେ ମଧ୍ୟ ଆପଣା ପିତୃଗଣ ନିକଟରେ ସଂଗୃହୀତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ଯେହେତୁ ତୁମ୍ଭେମାନେ ସୀନ୍‍ ପ୍ରାନ୍ତରରେ ମଣ୍ଡଳୀର ବିବାଦରେ ଲୋକମାନଙ୍କ ଦୃଷ୍ଟିଗୋଚରରେ ଜଳ ନିକଟରେ ଆମ୍ଭକୁ ପବିତ୍ର ରୂପେ ମାନ୍ୟ କରିବା ବିଷୟକ ଆମ୍ଭ ଆଜ୍ଞାର ବିରୁଦ୍ଧାଚରଣ କଲ।” (ସେହି ଜଳ ସୀନ୍‍ ପ୍ରାନ୍ତରର କାଦେଶସ୍ଥ ମିରୀବାଃ ଜଳ।) ");
INSERT INTO ory_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ସଦାପ୍ରଭୁ ସର୍ବଶରୀରସ୍ଥ ଆତ୍ମାଗଣର ପରମେଶ୍ୱର ମଣ୍ଡଳୀ ଉପରେ ଏକ ଜଣ ନିଯୁକ୍ତ କରନ୍ତୁ, ");
INSERT INTO ory_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ଯେ ସେମାନଙ୍କ ଅଗ୍ରଗାମୀ ହୋଇ ବାହାରକୁ ଯାଇ ପାରିବ ଓ ସେମାନଙ୍କ ଅଗ୍ରଗାମୀ ହୋଇ ଭିତରକୁ ଆସିପାରିବ, ପୁଣି, ଯେ ସେମାନଙ୍କର ପଥପ୍ରଦର୍ଶକ ହୋଇ ସେମାନଙ୍କୁ ବାହାରକୁ ନେଇ ପାରିବ ଓ ଭିତରକୁ ଆଣି ପାରିବ; ତାହା କଲେ ସଦାପ୍ରଭୁଙ୍କର ମଣ୍ଡଳୀ ପାଳକବିହୀନ ମେଷପଲ ତୁଲ୍ୟ ହେବ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ତହୁଁ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, “ନୂନର ପୁତ୍ର ଯିହୋଶୂୟକୁ ନିଅ, ସେହି ଲୋକଠାରେ ଆତ୍ମା ଅଛନ୍ତି, ପୁଣି, ତୁମ୍ଭେ ତାହା ଉପରେ ହସ୍ତାର୍ପଣ କର; ");
INSERT INTO ory_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ଆଉ ଇଲୀୟାସର ଯାଜକ ସମ୍ମୁଖରେ ଓ ସମସ୍ତ ମଣ୍ଡଳୀ ସମ୍ମୁଖରେ ତାହାକୁ ଉପସ୍ଥିତ କରାଇ ସେମାନଙ୍କ ସାକ୍ଷାତରେ ଆଜ୍ଞା ଦିଅ। ");
INSERT INTO ory_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ଆହୁରି ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ସମସ୍ତ ମଣ୍ଡଳୀ ଯେପରି ତାହାର ଆଜ୍ଞାବହ ହେବେ, ଏଥିପାଇଁ ତୁମ୍ଭେ ଆପଣା ସମ୍ଭ୍ରମ ତାହା ଉପରେ ଅର୍ପଣ କର। ");
INSERT INTO ory_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ପୁଣି, ସେ ଇଲୀୟାସର ଯାଜକ ସମ୍ମୁଖରେ ଠିଆ ହେବ ଓ ଇଲୀୟାସର ତାହା ପାଇଁ ଊରୀମ୍‍‍ର ବିଚାର ଦ୍ୱାରା ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପଚାରିବ; ସେମାନେ, ଅର୍ଥାତ୍‍, ସେ ଓ ତାହା ସହିତ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମୁଦାୟ ମଣ୍ଡଳୀ, ଉଭୟ ତାହାର ଆଜ୍ଞାରେ ବାହାରକୁ ଯିବେ ଓ ତାହାର ଆଜ୍ଞାରେ ଭିତରକୁ ଆସିବେ।” ");
INSERT INTO ory_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ଏଥିରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ କର୍ମ କଲେ; ସେ ଯିହୋଶୂୟଙ୍କୁ ଇଲୀୟାସର ଯାଜକ ସମ୍ମୁଖରେ ଓ ସମୁଦାୟ ମଣ୍ଡଳୀ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ପୁଣି, ସେ ତାଙ୍କ ଉପରେ ହସ୍ତାର୍ପଣ କଲେ, ପୁଣି, ସଦାପ୍ରଭୁ ମୋଶାଙ୍କ ହାତରେ ଯେରୂପ କହିଥିଲେ, ସେରୂପ ସେ ତାଙ୍କୁ ଆଜ୍ଞା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଆଜ୍ଞା ଦିଅ ଓ ସେମାନଙ୍କୁ କୁହ, ‘ତୁମ୍ଭେମାନେ ଆମ୍ଭର ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଆମ୍ଭର ଉପହାର, ଅର୍ଥାତ୍‍, ଆମ୍ଭ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ନାନା ନୈବେଦ୍ୟାର୍ଥକ ଆମ୍ଭର ଯେଉଁ ଭକ୍ଷ୍ୟ, ତାହା ତହିଁର ନିରୂପିତ ସମୟରେ ଉତ୍ସର୍ଗ କରିବାକୁ ମନୋଯୋଗ କରିବ।’ ");
INSERT INTO ory_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ପୁଣି, ତୁମ୍ଭେ ସେମାନଙ୍କୁ କହିବ, ‘ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଯେଉଁ ଅଗ୍ନିକୃତ ଉପହାର ଉତ୍ସର୍ଗ କରିବ, ତାହା ଏହି; ପ୍ରତିଦିନ ନିତ୍ୟ ହୋମ ନିମନ୍ତେ ଏକ ବର୍ଷୀୟ ନିଖୁନ୍ତ ଦୁଇ ମେଷବତ୍ସ। ");
INSERT INTO ory_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ପ୍ରାତଃକାଳରେ ଏକ ମେଷବତ୍ସ ଉତ୍ସର୍ଗ କରିବ ଓ ସନ୍ଧ୍ୟାକାଳରେ ଏକ ମେଷବତ୍ସ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ପୁଣି, ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ନିମନ୍ତେ ଏକ ହିନର ଚତୁର୍ଥାଂଶ ପେଷା ତୈଳ ମିଶ୍ରିତ ଏକ ଐଫାର ଦଶମାଂଶ ସରୁ ମଇଦା ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ଏହା ନିତ୍ୟ ହୋମବଳି, ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପେ ଏହା ସୀନୟ ପର୍ବତରେ ନିରୂପିତ ହୋଇଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ପୁଣି, ତହିଁର ଏକ ମେଷବତ୍ସ ନିମନ୍ତେ ଏକ ହିନର ଚତୁର୍ଥାଂଶ ପେୟ-ନୈବେଦ୍ୟ ହେବ। ତୁମ୍ଭେ ପବିତ୍ର ସ୍ଥାନରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପେୟ-ନୈବେଦ୍ୟ ରୂପେ ମଦ୍ୟ ଢାଳିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ଆଉ ତୁମ୍ଭେ ଅନ୍ୟ ମେଷବତ୍ସକୁ ସନ୍ଧ୍ୟାକାଳରେ ଉତ୍ସର୍ଗ କରିବ; ଯେପରି ପ୍ରାତଃକାଳର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ, ସେପରି ତୁମ୍ଭେ ତାହା ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପେ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","ଆଉ ବିଶ୍ରାମବାରରେ ଏକ ବର୍ଷୀୟ ନିଖୁନ୍ତ ଦୁଇ ମେଷବତ୍ସ ଓ ତୈଳ ମିଶ୍ରିତ ଏକ ଐଫାର ଦୁଇ ଦଶମାଂଶ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ନିତ୍ୟ ହୋମ ଓ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ପ୍ରତି ବିଶ୍ରାମବାରର ଏହି ହୋମବଳି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","ଆଉ ପ୍ରତି ମାସର ଆରମ୍ଭରେ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମ ନିମନ୍ତେ ଦୁଇ ପୁଂଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ସାତ ନିଖୁନ୍ତ ମେଷବତ୍ସ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ପୁଣି, ଏକ ଗୋବତ୍ସ ନିମନ୍ତେ ଏକ ଐଫାର ତିନି ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଆଉ ଏକ ମେଷ ନିମନ୍ତେ ଦୁଇ ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ; ");
INSERT INTO ory_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ପୁଣି, ଏକ ଏକ ମେଷବତ୍ସ ନିମନ୍ତେ ଏକ ଏକ ଐଫାର ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ହେବ; ତହିଁରେ ସେହି ହୋମବଳି ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ଆଉ ଏକ ଗୋବତ୍ସ ନିମନ୍ତେ ଏକ ହିନର ଅର୍ଦ୍ଧେକ, ଏକ ମେଷ ନିମନ୍ତେ ଏକ ହିନର ତୃତୀୟାଂଶ ଓ ଏକ ମେଷବତ୍ସ ନିମନ୍ତେ ଏକ ହିନର ଚତୁର୍ଥାଂଶ ଦ୍ରାକ୍ଷାରସ ପେୟ-ନୈବେଦ୍ୟ ହେବ; ଏହିସବୁ ନୈବେଦ୍ୟ ବର୍ଷର ପ୍ରତି ମାସର ପ୍ରଥମ ଦିନରେ ଅଣାଯିବ ପୁଣି, ତାହସବୁ ସମ୍ପୂର୍ଣ୍ଣ ହୋମ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ ଉତ୍ସର୍ଗ କରାଯିବ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ତାହା ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","ଆହୁରି ପ୍ରଥମ ମାସର ଚତୁର୍ଦ୍ଦଶ ଦିନରେ ସଦାପ୍ରଭୁଙ୍କର ନିସ୍ତାର ପର୍ବ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ପୁଣି, ସେହି ମାସର ପଞ୍ଚଦଶ ଦିନରେ ଉତ୍ସବ ହେବ; ସାତ ଦିନ ତାଡ଼ିଶୂନ୍ୟ ରୁଟି ଭୋଜନ କରାଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ପ୍ରଥମ ଦିନରେ ପବିତ୍ର ସଭା ହେବ; ସେହି ଦିନରେ ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଉପହାର ରୂପେ ହୋମ ନିମନ୍ତେ ଦୁଇ ପୁଂଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ସାତ ମେଷବତ୍ସ, ଏହିସବୁ ନିଖୁନ୍ତ ପଶୁ; ");
INSERT INTO ory_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ପୁଣି, ଏକ ଗୋବତ୍ସ ନିମନ୍ତେ ତିନି ଦଶମାଂଶ ଓ ଏକ ମେଷ ନିମନ୍ତେ ଦୁଇ ଦଶମାଂଶ, ");
INSERT INTO ory_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ଆଉ ସାତ ମେଷବତ୍ସ ମଧ୍ୟରେ ଏକ ଏକ ବତ୍ସ ନିମନ୍ତେ ଏକ ଏକ ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ପୁଣି, ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ପାଇଁ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ");
INSERT INTO ory_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ଏହି ସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମର ପ୍ରାତଃକାଳୀନ ହୋମ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ତୁମ୍ଭେମାନେ ଏହି ବିଧି ଅନୁସାରେ ସାତ ଦିନ ପର୍ଯ୍ୟନ୍ତ ପ୍ରତିଦିନ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅଗ୍ନିକୃତ ଭକ୍ଷ୍ୟରୂପ ଉପହାର ଉତ୍ସର୍ଗ କରିବ; ନିତ୍ୟ ହୋମ ଓ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ତାହା ଉତ୍ସର୍ଗିତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ପୁଣି, ସପ୍ତମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ଆହୁରି ପ୍ରଥମ ପକ୍ୱ ଫଳର ଦିନରେ, ଅର୍ଥାତ୍‍, ଯେଉଁ ସମୟରେ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଉତ୍ସବ-ସପ୍ତାହମାନଙ୍କରେ ସଦାପ୍ରଭୁଙ୍କ ଛାମୁକୁ ନୂତନ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଆଣିବ, ସେତେବେଳେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ମାତ୍ର ତୁମ୍ଭେମାନେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମବଳି ରୂପେ ଦୁଇ ପୁଂଗୋବତ୍ସ, ଏକ ମେଷ, ଏକ ବର୍ଷୀୟ ସାତ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ପୁଣି, ଏକ ଗୋବତ୍ସ ନିମନ୍ତେ ତିନି ଦଶମାଂଶ, ଏକ ମେଷ ନିମନ୍ତେ ଦୁଇ ଦଶମାଂଶ ");
INSERT INTO ory_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ଓ ସାତ ମେଷବତ୍ସ ମଧ୍ୟରୁ ଏକ ଏକ ବତ୍ସ ନିମନ୍ତେ ଏକ ଏକ ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦାର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ; ");
INSERT INTO ory_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ଆଉ ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରଣାର୍ଥ ଏକ ଛାଗ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଏହି ସମସ୍ତ ଓ ତହିଁର ପେୟ-ନୈବେଦ୍ୟ ଉତ୍ସର୍ଗ କରିବ, ଏହିସବୁ ନିଖୁନ୍ତ ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ଆଉ ସପ୍ତମ ମାସର ପ୍ରଥମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ଗୋଟିଏ ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ; ସେହି ଦିନ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ତୂରୀଧ୍ୱନିର ଦିନ। ");
INSERT INTO ory_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ପୁଣି, ତୁମ୍ଭେମାନେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ହୋମବଳି ରୂପେ ନିଖୁନ୍ତ ଏକ ପୁଂଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ସାତ ମେଷବତ୍ସ; ");
INSERT INTO ory_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ଆଉ ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ରୂପେ ଏକ ଗୋବତ୍ସ ନିମନ୍ତେ ତିନି ଦଶମାଂଶ, ଏକ ମେଷ ନିମନ୍ତେ ଦୁଇ ଦଶମାଂଶ ");
INSERT INTO ory_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ଓ ସାତ ମେଷବତ୍ସର ଏକ ଏକ ବତ୍ସ ନିମନ୍ତେ ଏକ ଏକ ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦା ଉତ୍ସର୍ଗ କରିବ; ");
INSERT INTO ory_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ପୁଣି, ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବା ପାଇଁ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ଏହି ସମସ୍ତ, ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଅମାବାସ୍ୟାର ହୋମ ଓ ତହିଁର ଅଗ୍ନିକୃତ ଉପହାରର ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ଓ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ପୁଣି, ବିଧିମତେ ଉଭୟର ପେୟ-ନୈବେଦ୍ୟ, ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ଆହୁରି ସେହି ସପ୍ତମ ମାସର ଦଶମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ଏକ ପବିତ୍ର ସଭା ହେବ; ପୁଣି, ତୁମ୍ଭେମାନେ କୌଣସି ପ୍ରକାର ଖାଦ୍ୟ ଭୋଜନ କରିବ ନାହିଁ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ; ");
INSERT INTO ory_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ମାତ୍ର ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ହୋମବଳି ରୂପେ ଏକ ପୁଂଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ସାତ ମେଷବତ୍ସ, ତୁମ୍ଭ ପ୍ରତି ଏମାନେ ନିଖୁନ୍ତ ହେବେ; ");
INSERT INTO ory_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ପୁଣି, ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ ରୂପେ ଏକ ଗୋବତ୍ସ ନିମନ୍ତେ ତିନି ଦଶମାଂଶ, ଏକ ମେଷ ନିମନ୍ତେ ଦୁଇ ଦଶମାଂଶ ");
INSERT INTO ory_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ଓ ସାତ ମେଷବତ୍ସର ଏକ ଏକ ମେଷବତ୍ସ ନିମନ୍ତେ ଏକ ଏକ ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦା; ");
INSERT INTO ory_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ପୁଣି, ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ ଏହି ସମସ୍ତ ତୁମ୍ଭେମାନେ ପ୍ରାୟଶ୍ଚିତ୍ତାର୍ଥକ ପାପବଳି, ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ଆଉ ସପ୍ତମ ମାସର ପଞ୍ଚଦଶ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ପବିତ୍ର ସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ, ପୁଣି, ସାତ ଦିନ ଯାଏ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସବ ପାଳନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ଆଉ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ହୋମବଳି ରୂପେ ତେର ପୁଂଗୋବତ୍ସ, ଦୁଇ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଚଉଦ ମେଷବତ୍ସ ଉତ୍ସର୍ଗ କରିବ; ଏମାନେ ନିଖୁନ୍ତ ହେବେ। ");
INSERT INTO ory_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ପୁଣି, ତହିଁର ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ତେର ପୁଂଗୋବତ୍ସ ମଧ୍ୟରୁ ପ୍ରତ୍ୟେକ ବତ୍ସ ନିମନ୍ତେ ତିନି ତିନି ଦଶମାଂଶ, ଦୁଇ ମେଷ ମଧ୍ୟରୁ ପ୍ରତ୍ୟେକ ମେଷ ନିମନ୍ତେ ଦୁଇ ଦୁଇ ଦଶମାଂଶ ");
INSERT INTO ory_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ଓ ଚଉଦ ମେଷବତ୍ସ ମଧ୍ୟରୁ ପ୍ରତ୍ୟେକ ବତ୍ସ ନିମନ୍ତେ ଏକ ଏକ ଦଶମାଂଶ ତୈଳ ମିଶ୍ରିତ ସରୁ ମଇଦା; ");
INSERT INTO ory_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ଆଉ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏହି ସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ, ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","ଆଉ ଦ୍ୱିତୀୟ ଦିନରେ ନିଖୁନ୍ତ ବାର ପୁଂଗୋବତ୍ସ, ଦୁଇ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଚଉଦ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ପୁଣି, ଗୋବତ୍ସର, ମେଷର ଓ ମେଷବତ୍ସମାନଙ୍କ ସଂଖ୍ୟାନୁସାରେ ବିଧିମତେ ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ଆଉ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","ଆଉ ତୃତୀୟ ଦିନରେ ନିଖୁନ୍ତ ଏଗାର ଗୋବତ୍ସ, ଦୁଇ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଚଉଦ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ପୁଣି, ଗୋବତ୍ସର, ମେଷର ଓ ମେଷବତ୍ସମାନଙ୍କର ସଂଖ୍ୟାନୁସାରେ ବିଧିମତେ ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ଆଉ ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","ଆଉ ଚତୁର୍ଥ ଦିନରେ ନିଖୁନ୍ତ ଦଶ ଗୋବତ୍ସ, ଦୁଇ ମେଷ, ଏକ ବର୍ଷୀୟ ଚଉଦ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ଗୋବତ୍ସର, ମେଷର, ମେଷବତ୍ସମାନଙ୍କ ସଂଖ୍ୟାନୁସାରେ ବିଧିମତେ ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ପୁଣି, ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","ଆଉ ପଞ୍ଚମ ଦିନରେ ନିଖୁନ୍ତ ନଅ ଗୋବତ୍ସ, ଦୁଇ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଚଉଦ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ପୁଣି, ଗୋବତ୍ସର, ମେଷର ଓ ମେଷବତ୍ସମାନଙ୍କ ସଂଖ୍ୟାନୁସାରେ ବିଧିମତେ ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ପୁଣି, ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ଆଉ ଷଷ୍ଠ ଦିନରେ ନିଖୁନ୍ତ ଆଠ ଗୋବତ୍ସ, ଦୁଇ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଚଉଦ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ଆଉ ଗୋବତ୍ସର, ମେଷର ଓ ମେଷବତ୍ସମାନଙ୍କ ସଂଖ୍ୟାନୁସାରେ ବିଧିମତେ ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ପୁଣି, ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","ଆଉ ସପ୍ତମ ଦିନରେ ନିଖୁନ୍ତ ସାତ ଗୋବତ୍ସ, ଦୁଇ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ଚଉଦ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ଆଉ ଗୋବତ୍ସର, ମେଷର ଓ ମେଷବତ୍ସମାନଙ୍କର ସଂଖ୍ୟାନୁସାରେ ବିଧିମତେ ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ପୁଣି, ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ଆଉ ଅଷ୍ଟମ ଦିନରେ ତୁମ୍ଭମାନଙ୍କର ମହାସଭା ହେବ; ତୁମ୍ଭେମାନେ କୌଣସି ବ୍ୟବସାୟ କର୍ମ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ମାତ୍ର ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ତୁଷ୍ଟିଜନକ ଆଘ୍ରାଣାର୍ଥେ ଅଗ୍ନିକୃତ ହୋମବଳି ରୂପେ ନିଖୁନ୍ତ ଏକ ଗୋବତ୍ସ, ଏକ ମେଷ ଓ ଏକ ବର୍ଷୀୟ ସାତ ମେଷବତ୍ସ, ");
INSERT INTO ory_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ଆଉ ଗୋବତ୍ସର, ମେଷର ଓ ମେଷବତ୍ସମାନଙ୍କ ସଂଖ୍ୟାନୁସାରେ ବିଧିମତେ ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ, ");
INSERT INTO ory_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ପୁଣି, ପାପାର୍ଥକ ବଳି ରୂପେ ଏକ ଛାଗ, ଏସମସ୍ତ ତୁମ୍ଭେମାନେ ନିତ୍ୟ ହୋମ ଓ ତହିଁର ଭକ୍ଷ୍ୟ ଓ ପେୟ-ନୈବେଦ୍ୟ ବ୍ୟତୀତ ଉତ୍ସର୍ଗ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","ତୁମ୍ଭେମାନେ ଏହି ସମସ୍ତ, ଆପଣା ଆପଣା ମାନତ, ସ୍ୱେଚ୍ଛାଦତ୍ତ ଉପହାର ସମ୍ବନ୍ଧୀୟ ତୁମ୍ଭମାନଙ୍କ ହୋମବଳି, ତୁମ୍ଭମାନଙ୍କ ଭକ୍ଷ୍ୟ ନୈବେଦ୍ୟ, ତୁମ୍ଭମାନଙ୍କ ପେୟ-ନୈବେଦ୍ୟ ଓ ତୁମ୍ଭମାନଙ୍କ ମଙ୍ଗଳାର୍ଥକ ବଳି ବ୍ୟତୀତ ନିରୂପିତ ପର୍ବମାନଙ୍କରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ସର୍ଗ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେଉଁ ଯେଉଁ ଆଜ୍ଞା ଦେଲେ, ମୋଶା ସେହି ସମସ୍ତ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ଏଥିଉତ୍ତାରେ ମୋଶା ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ବଂଶର ପ୍ରଧାନବର୍ଗଙ୍କୁ କହିଲେ, “ସଦାପ୍ରଭୁ ଏହି ଆଜ୍ଞା ଦେଇଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","କୌଣସି ପୁରୁଷ ଯଦି ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମାନତ କରେ, କିଅବା ବ୍ରତ ଦ୍ୱାରା ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିବା ପାଇଁ ଶପଥ କରେ, ତେବେ ସେ ଆପଣା ବାକ୍ୟ ଲଙ୍ଘନ କରିବ ନାହିଁ; ସେ ଆପଣା ମୁଖରୁ ନିର୍ଗତ ସମସ୍ତ (ବାକ୍ୟ) ଅନୁସାରେ ସାଧନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","ମଧ୍ୟ କୌଣସି ସ୍ତ୍ରୀ ଯଦି ଯୌବନାବସ୍ଥାରେ ଆପଣା ପିତୃଗୃହରେ ଥିବା ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ମାନତ କରେ ଓ ବ୍ରତ ଦ୍ୱାରା ଆପଣାକୁ ଆବଦ୍ଧ କରେ, ");
INSERT INTO ory_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ପୁଣି, ତାହାର ପିତା ଯଦି ତାହାର ମାନତ ଓ ଯଦ୍ଦ୍ୱାରା ସେ ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିଅଛି, ତାହାର ସେହି ପ୍ରତିଜ୍ଞାର କଥା ଶୁଣି ତାହାକୁ କିଛି ନ କହେ, ଯଦି ତାହାର ସକଳ ମାନତ ସ୍ଥିର ହେବ; ପୁଣି, ଯଦ୍ଦ୍ୱାରା ସେ ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିଅଛି, ସେହି ବ୍ରତ ସ୍ଥିର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ମାତ୍ର ତାହାର ପିତା ଯଦି ଶୁଣିବା ଦିନ ତାହାକୁ ନିଷେଧ କରେ, ତେବେ ତାହାର ମାନତ ଓ ଯଦ୍ଦ୍ୱାରା ସେ ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିଅଛି, ତାହାର ସେହି ବ୍ରତ ସ୍ଥିର ହେବ ନାହିଁ; ପୁଣି, ତାହାର ପିତା ନିଷେଧ କରିବା ସକାଶୁ ସଦାପ୍ରଭୁ ତାହାକୁ କ୍ଷମା କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","ଆଉ ଯଦି ସେ ଆପଣା ମାନତର ଅବା ଯଦ୍ଦ୍ୱାରା ସେ ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କଲା, ତାହାର ମୁଖନିର୍ଗତ ସେହି ଚଞ୍ଚଳ ବାକ୍ୟର ଅଧୀନା ଥାଉ ଥାଉ କୌଣସି ସ୍ୱାମୀକୁ ବିବାହ କରେ; ");
INSERT INTO ory_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ପୁଣି, ତାହାର ସ୍ୱାମୀ ତାହା ଶୁଣେ ଓ ସେ ତାହା ଶୁଣିବା ଦିନ ତୁନି ହୋଇ ରହେ; ତେବେ ତାହାର ମାନତ ସ୍ଥିର ହେବ ଓ ଯଦ୍ଦ୍ୱାରା ସେ ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିଅଛି, ତାହାର ସେହି ବ୍ରତ ସ୍ଥିର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ମାତ୍ର ତାହାର ସ୍ୱାମୀ ତାହା ଶୁଣିବା ଦିନ ଯଦି ତାହାକୁ ନିଷେଧ କରେ, ତେବେ ସେ ତାହାର ମାନତ ଓ ଯଦ୍ଦ୍ୱାରା ସେ ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିଅଛି, ତାହାର ମୁଖନିର୍ଗତ ସେହି ଚଞ୍ଚଳ ବାକ୍ୟ ବ୍ୟର୍ଥ କରିବ। ତହିଁରେ ସଦାପ୍ରଭୁ ତାହାକୁ କ୍ଷମା କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","ମାତ୍ର ବିଧବା କିମ୍ବା ସ୍ୱାମୀତ୍ୟକ୍ତା ସ୍ତ୍ରୀର ମାନତ ଓ ଯେକୌଣସି ବିଷୟରେ ସେ ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିଅଛି; ସେହି ସବୁ ତାହା ନିମନ୍ତେ ସ୍ଥିର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","ଆଉ ସେ ଯଦି ସ୍ୱାମୀର ଗୃହରେ ମାନତ କରିଥାଏ, ଅବା ଶପଥପୂର୍ବକ ବ୍ରତ ଦ୍ୱାରା ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କରିଥାଏ, ");
INSERT INTO ory_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ପୁଣି, ତାହାର ସ୍ୱାମୀ ତାହା ଶୁଣି ତାହା ପ୍ରତି ତୁନି ହୋଇ ରହେ ଓ ତାହାକୁ ନିଷେଧ ନ କରେ, ତେବେ ତାହାର ସମସ୍ତ ମାନତ ସ୍ଥିର ହେବ; ପୁଣି, ସେ ଯେଉଁସବୁ ପ୍ରତିଜ୍ଞା ଦ୍ୱାରା ଆପଣା ପ୍ରାଣକୁ ଆବଦ୍ଧ କଲା, ତାହାସବୁ ସ୍ଥିର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ମାତ୍ର ତାହାର ସ୍ୱାମୀ ଯଦି ଶୁଣିବା ଦିନ ତାହାସବୁ ରହିତ ଓ ବ୍ୟର୍ଥ କରେ, ତେବେ ତାହାର ମାନତ ବିଷୟରେ ଓ ତାହାର ପ୍ରାଣର ବନ୍ଧନ ବିଷୟରେ ଯେସବୁ କଥା ତାହାର ମୁଖରୁ ନିର୍ଗତ ହୋଇଥିଲା, ସେସବୁ ସ୍ଥିର ହେବ ନାହିଁ; ତାହାର ସ୍ୱାମୀ ସେସବୁ ବ୍ୟର୍ଥ କଲା, ଏଣୁ ସଦାପ୍ରଭୁ ତାହାକୁ କ୍ଷମା କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ତାହାର ସ୍ୱାମୀ ତାହାର ପ୍ରତ୍ୟେକ ମାନତ ଓ ପ୍ରାଣକୁ କ୍ଳେଶ ଦେବାର ପ୍ରତିଜ୍ଞାଯୁକ୍ତ ପ୍ରତ୍ୟେକ ଶପଥ ସ୍ଥିର କରିପାରେ, ଅବା ତାହାର ସ୍ୱାମୀ ବ୍ୟର୍ଥ କରିପାରେ। ");
INSERT INTO ory_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ମାତ୍ର ତାହାର ସ୍ୱାମୀ ଯଦି ଦିନକୁ ଦିନ ତାହା ପ୍ରତି ସର୍ବତୋଭାବେ ତୁନି ହୋଇ ରହେ, ତେବେ ସେ ତାହାର ସମସ୍ତ ମାନତ ଅବା ତାହାର ସମସ୍ତ ପ୍ରତିଜ୍ଞା ସ୍ଥିର କରେ। ସେ ତାହା ଶୁଣିବା ଦିନ ତୁନି ହୋଇ ରହିବାରୁ ତାହା ସ୍ଥିର କଲା। ");
INSERT INTO ory_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ମାତ୍ର ତାହା ଶୁଣିଲା ଉତ୍ତାରେ ଯଦି ସେ ତାହା ରହିତ ଓ ବ୍ୟର୍ଥ କରେ, ତେବେ ସେ ସ୍ତ୍ରୀର ଅପରାଧ ବୋହିବ।” ");
INSERT INTO ory_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ପୁରୁଷ ଓ ତାହାର ଭାର୍ଯ୍ୟା ବିଷୟରେ, ପିତା ଓ ପିତୃଗୃହସ୍ଥିତା ଯୁବତୀ କନ୍ୟା ବିଷୟରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଏହି ସମସ୍ତ ଆଜ୍ଞା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ସକାଶେ ମିଦୀୟନୀୟମାନଙ୍କୁ ପ୍ରତିଫଳ ଦିଅ; ତହିଁ ଉତ୍ତାରେ ତୁମ୍ଭେ ଆପଣା ଲୋକଙ୍କ ନିକଟରେ ସଂଗୃହୀତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ତହିଁରେ ମୋଶା ଲୋକମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଯୁଦ୍ଧ ନିମନ୍ତେ ଆପଣାମାନଙ୍କ ମଧ୍ୟରୁ କେତେକ ଲୋକଙ୍କୁ ପ୍ରସ୍ତୁତ କର; ସେମାନେ ମିଦୀୟନୀୟମାନଙ୍କ ଉପରେ ସଦାପ୍ରଭୁଙ୍କ ଦଣ୍ଡାଜ୍ଞା ସଫଳ କରିବା ନିମନ୍ତେ ମିଦୀୟନୀୟମାନଙ୍କ ବିରୁଦ୍ଧରେ ଯିବେ। ");
INSERT INTO ory_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ ବଂଶର ପ୍ରତ୍ୟେକ ବଂଶରୁ ଏକ ଏକ ସହସ୍ର ଲୋକ ଯୁଦ୍ଧକୁ ପଠାଇବ।” ");
INSERT INTO ory_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ତହୁଁ ସହସ୍ର ସହସ୍ର ଇସ୍ରାଏଲ ମଧ୍ୟରେ ପ୍ରତ୍ୟେକ ବଂଶରୁ ଏକ ଏକ ସହସ୍ର ଲୋକ, ଏହିରୂପେ ବାର ସହସ୍ର ଲୋକ ଯୁଦ୍ଧ ପାଇଁ ସଜ୍ଜିତ ହେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ପୁଣି, ମୋଶା ଏକ ଏକ ବଂଶରୁ ଏକ ଏକ ସହସ୍ର ଲୋକଙ୍କୁ ଯୁଦ୍ଧକୁ ପଠାଇଲେ ଓ ଇଲୀୟାସର ଯାଜକର ପୁତ୍ର ପୀନହସ୍‍ର ହସ୍ତରେ ପବିତ୍ର ସ୍ଥାନର ପାତ୍ର ଓ ରଣତୂରୀ ଦେଇ ତାହାକୁ ସେମାନଙ୍କ ସଙ୍ଗେ ଯୁଦ୍ଧକୁ ପଠାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ତହୁଁ ସେମାନେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମିଦୀୟନୀୟମାନଙ୍କ ବିରୁଦ୍ଧରେ ଯୁଦ୍ଧ କଲେ; ପୁଣି, ସେମାନେ ପ୍ରତ୍ୟେକ ପୁରୁଷକୁ ବଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ଆଉ ଅନ୍ୟାନ୍ୟ ହତ ଲୋକଙ୍କ ସହିତ ସେମାନେ ମିଦୀୟନୀୟ ରାଜାମାନଙ୍କୁ, ଅର୍ଥାତ୍‍ ଇବି, ରେକମ୍‍, ସୂର୍‍, ହୂର ଓ ରେବା, ଏହି ମିଦୀୟନୀୟ ପାଞ୍ଚ ରାଜାଙ୍କୁ ବଧ କଲେ; ବିୟୋରର ପୁତ୍ର ବିଲୀୟମ୍‍କୁ ମଧ୍ୟ ସେମାନେ ଖଡ୍ଗରେ ବଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ଆଉ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମିଦୀୟନର ସ୍ତ୍ରୀଲୋକମାନଙ୍କୁ ଓ ସେମାନଙ୍କ ପିଲାମାନଙ୍କୁ ବନ୍ଦୀ କରି ନେଲେ; ଆଉ ସେମାନଙ୍କର ସମସ୍ତ ପଶୁ, ସମସ୍ତ ମେଷପଲ ଓ ସମସ୍ତ ସମ୍ପତ୍ତି ଲୁଟି କରି ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ଆଉ ସେମାନଙ୍କର ସକଳ ନିବାସ ନଗର ଓ ସକଳ ଛାଉଣି ଅଗ୍ନିରେ ଦଗ୍ଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ଆଉ ସେମାନେ ସମସ୍ତ ଲୁଟିତ ଦ୍ରବ୍ୟ, ପୁଣି, ସମସ୍ତ ଧୃତ ମନୁଷ୍ୟ ଓ ପଶୁ ନେଇଗଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ପୁଣି, ସେମାନେ ଯିରୀହୋ ନିକଟବର୍ତ୍ତୀ ଯର୍ଦ୍ଦନ ତୀରସ୍ଥ ମୋୟାବ-ପଦାରେ ସ୍ଥାପିତ ଛାଉଣିକୁ ମୋଶାଙ୍କର, ଇଲୀୟାସର ଯାଜକର, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସମସ୍ତ ମଣ୍ଡଳୀ ନିକଟକୁ ସେହି ବନ୍ଦୀମାନଙ୍କୁ, ଧୃତ ପ୍ରାଣୀମାନଙ୍କୁ ଓ ସକଳ ଲୁଟିତ ଦ୍ରବ୍ୟ ଆଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ତହିଁରେ ମୋଶା, ଇଲୀୟାସର ଯାଜକ ଓ ମଣ୍ଡଳୀର ଅଧ୍ୟକ୍ଷଗଣ ସେମାନଙ୍କୁ ଭେଟିବାକୁ ଛାଉଣିର ବାହାରକୁ ଗଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ସେତେବେଳେ ମୋଶା ଯୁଦ୍ଧକ୍ଷେତ୍ରରୁ ଆଗତ ସେନାପତିମାନଙ୍କ ପ୍ରତି, ଅର୍ଥାତ୍‍, ସହସ୍ରପତି ଓ ଶତପତିମାନଙ୍କ ପ୍ରତି କ୍ରୋଧ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ଆଉ ମୋଶା ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ କି ସମସ୍ତ ସ୍ତ୍ରୀଲୋକଙ୍କୁ ଜୀବିତ ରଖିଅଛ? ");
INSERT INTO ory_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ଦେଖ, ଏମାନେ ବିଲୀୟମ୍‍ର ପରାମର୍ଶରେ ପିୟୋର ଦେବତା ବିଷୟରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ସତ୍ୟ-ଲଙ୍ଘନ କରାଇଲେ, ତହିଁ ନିମନ୍ତେ ସଦାପ୍ରଭୁଙ୍କ ମଣ୍ଡଳୀ ମଧ୍ୟରେ ମହାମାରୀ ହେଲା। ");
INSERT INTO ory_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ଏଣୁ ତୁମ୍ଭେମାନେ ଏବେ ପିଲାମାନଙ୍କ ମଧ୍ୟରୁ ସମସ୍ତ ପୁରୁଷ ପିଲାମାନଙ୍କୁ ବଧ କର, ପୁଣି, ଯେଉଁ ସ୍ତ୍ରୀଲୋକମାନେ ପୁରୁଷର ସହବାସ ଜ୍ଞାତ ହୋଇଅଛନ୍ତି, ସେମାନଙ୍କୁ ବଧ କର। ");
INSERT INTO ory_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ମାତ୍ର ଯେଉଁ ସ୍ତ୍ରୀର ପିଲାମାନେ ପୁରୁଷର ସହବାସ ଜ୍ଞାତ ହୋଇ ନାହାନ୍ତି, ସେହି ସମସ୍ତଙ୍କୁ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଜୀବିତ ରଖ। ");
INSERT INTO ory_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ଆଉ ତୁମ୍ଭେମାନେ ସାତ ଦିନ ଛାଉଣିର ବାହାରେ ଛାଉଣି ସ୍ଥାପନ କରିବ; ତୁମ୍ଭେମାନେ ଯେତେ ଲୋକ ମନୁଷ୍ୟର ହତ୍ୟା କରିଅଛ ଓ ହତ ଲୋକଙ୍କୁ ସ୍ପର୍ଶ କରିଅଛ, ସମସ୍ତେ ତୃତୀୟ ଦିନରେ, ସପ୍ତମ ଦିନରେ ଆପଣାମାନଙ୍କୁ ଓ ଆପଣା ଆପଣା ବନ୍ଦୀମାନଙ୍କୁ ପାପରୁ ପରିଷ୍କାର କର। ");
INSERT INTO ory_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ପୁଣି, ଯାବତୀୟ ବସ୍ତ୍ର, ଚର୍ମ ନିର୍ମିତ ଯାବତୀୟ ବସ୍ତୁ, ଛାଗର ଲୋମରେ ନିର୍ମିତ ଯାବତୀୟ ବସ୍ତୁ ଓ କାଷ୍ଠନିର୍ମିତ ଯାବତୀୟ ବସ୍ତୁ ସମ୍ବନ୍ଧରେ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କୁ ପାପରୁ ପରିଷ୍କାର କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ତହୁଁ ଇଲୀୟାସର ଯାଜକ ଯୁଦ୍ଧକୁ ଯାଇଥିବା ଯୋଦ୍ଧାମାନଙ୍କୁ କହିଲା, “ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେଉଁ ବ୍ୟବସ୍ଥାର ଆଜ୍ଞା ଦେଇଥିଲେ, ତହିଁର ବିଧି ଏହି; ");
INSERT INTO ory_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ତଥାପି ସୁନା, ରୂପା, ପିତ୍ତଳ, ଲୁହା, ଦସ୍ତା ଓ ସୀସା, ");
INSERT INTO ory_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ଯେଉଁ ସମସ୍ତ ଦ୍ରବ୍ୟ ଅଗ୍ନି ସହିପାରେ, ସେସବୁକୁ ଅଗ୍ନିରେ ପକାଇବ, ତହିଁରେ ତାହା ଶୁଚି ହେବ; ତେବେ ହେଁ ତାହା ପାପାର୍ଥକ ଜଳରେ ପରିଷ୍କୃତ କରାଯିବ; ପୁଣି, ଯେଉଁସବୁ ଦ୍ରବ୍ୟ ଅଗ୍ନି ସହେ ନାହିଁ, ତାହା ତୁମ୍ଭେମାନେ ଜଳରେ ପକାଇବ। ");
INSERT INTO ory_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ପୁଣି, ତୁମ୍ଭେମାନେ ସପ୍ତମ ଦିନରେ ଆପଣା ଆପଣା ବସ୍ତ୍ର ଧୋଇବ, ତହିଁରେ ତୁମ୍ଭେମାନେ ଶୁଚି ହେବ; ତହିଁ ଉତ୍ତାରେ ତୁମ୍ଭେମାନେ ଛାଉଣିରେ ପ୍ରବେଶ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ତୁମ୍ଭେ, ଇଲୀୟାସର ଯାଜକ ଓ ମଣ୍ଡଳୀସ୍ଥ ପିତୃଗୃହର ପ୍ରଧାନମାନେ ଯୁଦ୍ଧରେ ଧୃତ ଜୀବଗଣର, ଅର୍ଥାତ୍‍, ବନ୍ଦୀ ମନୁଷ୍ୟର ଓ ପଶୁର ସଂଖ୍ୟା କର। ");
INSERT INTO ory_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ପୁଣି, ଯୁଦ୍ଧରେ ଧୃତ ସେହି ଜୀବମାନଙ୍କୁ ଯୁଦ୍ଧକୁ ଯାଇଥିବା ନିପୁଣ ଯୋଦ୍ଧାମାନଙ୍କର ଓ ସମସ୍ତ ମଣ୍ଡଳୀର ମଧ୍ୟରେ ବିଭାଗ କର। ");
INSERT INTO ory_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ପୁଣି, ଯୁଦ୍ଧକୁ ଯାଇଥିବା ଯୋଦ୍ଧାମାନଙ୍କଠାରୁ ସଦାପ୍ରଭୁଙ୍କ ନିମନ୍ତେ କର ଗ୍ରହଣ କର; ସେମାନଙ୍କର ଲଭ୍ୟ ଅର୍ଦ୍ଧାଂଶରୁ ମନୁଷ୍ୟ, ଗୋରୁ, ଗର୍ଦ୍ଦଭ ଓ ମେଷମାନଙ୍କର, ");
INSERT INTO ory_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ପ୍ରତି ପାଞ୍ଚଶହରୁ ଗୋଟିଏ ଲେଖାଏଁ ଜୀବ ନେଇ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ଉତ୍ତୋଳନୀୟ ଉପହାର ନିମନ୍ତେ ଇଲୀୟାସର ଯାଜକକୁ ଦିଅ; ");
INSERT INTO ory_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଲଭ୍ୟ ଅର୍ଦ୍ଧାଂଶରୁ ତୁମ୍ଭେ ମନୁଷ୍ୟ, ଗୋରୁ, ଗର୍ଦ୍ଦଭ ଓ ମେଷାଦି ସମସ୍ତ ପଶୁର ପ୍ରତ୍ୟେକ ପାଞ୍ଚଶହରୁ ଗୋଟିଏ ଲେଖାଏଁ ନେଇ ସଦାପ୍ରଭୁଙ୍କ ଆବାସ ରକ୍ଷଣୀୟ-ରକ୍ଷକ ଲେବୀୟମାନଙ୍କୁ ଦିଅ;” ");
INSERT INTO ory_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ତହିଁରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ଓ ଇଲୀୟାସର ଯାଜକ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ଯୋଦ୍ଧାମାନେ ଲୁଟିତ ସମ୍ପତ୍ତି ବ୍ୟତୀତ ଯେଉଁସବୁ ଜୀବ ଧରିଥିଲେ, ସେମାନଙ୍କ ସଂଖ୍ୟା, ");
INSERT INTO ory_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ଛଅ ଲକ୍ଷ ପଞ୍ଚସ୍ତରି ହଜାର ମେଷ ");
INSERT INTO ory_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ଓ ବାସ୍ତରି ହଜାର ଗୋରୁ, ଏକଷଠି ହଜାର ଗର୍ଦ୍ଦଭ; ");
INSERT INTO ory_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ଆଉ ପୁରୁଷ-ସହବାସ ଅଜ୍ଞାତା ସ୍ତ୍ରୀଲୋକ ସର୍ବସୁଦ୍ଧା ବତିଶ ହଜାର ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ତହିଁରେ ଯୁଦ୍ଧକୁ ଯାଇଥିବା ଲୋକମାନଙ୍କର ଲଭ୍ୟ ଅର୍ଦ୍ଧାଂଶର ସଂଖ୍ୟା ତିନି ଲକ୍ଷ ସଇଁତିରିଶ ହଜାର ପାଞ୍ଚ ଶହ ମେଷ। ");
INSERT INTO ory_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ପୁଣି, ସେହି ମେଷ ମଧ୍ୟରୁ ଛଅ ଶହ ପଞ୍ଚସ୍ତରି ମେଷ ସଦାପ୍ରଭୁଙ୍କର କର ସ୍ୱରୂପ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ଆଉ ଗୋରୁ ଛତିଶ ହଜାର, ସେମାନଙ୍କ ମଧ୍ୟରୁ ବାସ୍ତରି ଗୋରୁ ସଦାପ୍ରଭୁଙ୍କର କର ସ୍ୱରୂପ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ଆଉ ଗର୍ଦ୍ଦଭ ତିରିଶ ହଜାର ପାଞ୍ଚ ଶହ, ସେମାନଙ୍କ ମଧ୍ୟରୁ ଏକଷଠି ସଦାପ୍ରଭୁଙ୍କର କର ସ୍ୱରୂପ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ପୁଣି, ମନୁଷ୍ୟ ଷୋଳ ସହସ୍ର, ସେମାନଙ୍କ ମଧ୍ୟରୁ ବତିଶ ଜଣ ସଦାପ୍ରଭୁଙ୍କର କର ସ୍ୱରୂପ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ତହିଁରେ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କର ଉତ୍ତୋଳନୀୟ ଉପହାର ସ୍ୱରୂପେ ସେହି କର ଇଲୀୟାସର ଯାଜକକୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ପୁଣି, ଯୋଦ୍ଧାମାନଙ୍କ ଅଂଶ ଭିନ୍ନ ଯେଉଁ ଅର୍ଦ୍ଧାଂଶ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଦେଇଥିଲେ; ");
INSERT INTO ory_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ମଣ୍ଡଳୀର ଲଭ୍ୟ ସେହି ଅର୍ଦ୍ଧାଂଶ ସଂଖ୍ୟାରେ ତିନି ଲକ୍ଷ ସଇଁତିରିଶ ହଜାର ପାଞ୍ଚ ଶହ ମେଷ, ");
INSERT INTO ory_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ଛତିଶ ହଜାର ଗୋରୁ, ");
INSERT INTO ory_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ତିରିଶ ହଜାର ପାଞ୍ଚ ଶହ ଗର୍ଦ୍ଦଭ ");
INSERT INTO ory_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ଓ ଷୋଳ ସହସ୍ର ମନୁଷ୍ୟ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ତହିଁରେ ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ଲଭ୍ୟ ସେହି ଅର୍ଦ୍ଧାଂଶରୁ ମନୁଷ୍ୟ ଓ ପଶୁର ପ୍ରତ୍ୟେକ ପଚାଶ ମଧ୍ୟରୁ ଗୋଟିଏ ଲେଖାଏଁ ନେଇ ମୋଶାଙ୍କ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାନୁସାରେ ସଦାପ୍ରଭୁଙ୍କ ଆବାସର ରକ୍ଷଣୀୟ-ରକ୍ଷକ ଲେବୀୟମାନଙ୍କୁ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ଏଉତ୍ତାରେ ସହସ୍ର ସହସ୍ର ସୈନ୍ୟମାନଙ୍କ ଉପରେ କର୍ତ୍ତୃତ୍ୱକାରୀଗଣ, ଅର୍ଥାତ୍‍, ସହସ୍ରପତି ଓ ଶତପତିମାନେ ମୋଶାଙ୍କ ନିକଟକୁ ଆସିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ପୁଣି, ସେମାନେ ମୋଶାଙ୍କୁ କହିଲେ, “ତୁମ୍ଭର ଏହି ଦାସମାନେ ଆପଣାମାନଙ୍କ ହସ୍ତଗତ ଯୋଦ୍ଧାମାନଙ୍କର ସଂଖ୍ୟା ନେଇଅଛନ୍ତି, ସେମାନଙ୍କ ମଧ୍ୟରୁ ଜଣେ ହିଁ ଊଣା ହୋଇ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ଏହେତୁ ଆମ୍ଭେମାନେ ପ୍ରତି ଜଣ ସ୍ୱର୍ଣ୍ଣ-ଅଳଙ୍କାର, ନୂପୁର ଓ ବଳା, ଅଙ୍ଗୁରୀୟକ, କୁଣ୍ଡଳ ଓ ହାର, ଏହି ଯେସବୁ ପାଇଅଛୁ, ତହିଁରୁ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଆପଣା ଆପଣା ପ୍ରାଣ ନିମନ୍ତେ ପ୍ରାୟଶ୍ଚିତ୍ତ କରିବାକୁ ସଦାପ୍ରଭୁଙ୍କ ଉପହାର ଆଣିଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ତହୁଁ ମୋଶା ଓ ଇଲୀୟାସର ଯାଜକ ସେମାନଙ୍କଠାରୁ ସେହି ସ୍ୱର୍ଣ୍ଣ, ଅର୍ଥାତ୍‍, ଶିଳ୍ପିତ ଅଳଙ୍କାର ନେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ଆଉ ସଦାପ୍ରଭୁଙ୍କ ଉଦ୍ଦେଶ୍ୟରେ ସହସ୍ରପତି ଓ ଶତପତିମାନେ ଉତ୍ତୋଳନୀୟ ଉପହାର ରୂପେ ଯେଉଁ ସ୍ୱର୍ଣ୍ଣ ଉତ୍ସର୍ଗ କଲେ, ସେସମସ୍ତ ସ୍ୱର୍ଣ୍ଣ ଷୋହଳ ହଜାର ସାତ ଶହ ପଚାଶ ଶେକଲ ପରିମିତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","କାରଣ ଯୋଦ୍ଧାମାନେ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ନିମନ୍ତେ ଲୁଟିତ ଦ୍ରବ୍ୟ ନେଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ଏଉତ୍ତାରେ ମୋଶା, ଇଲୀୟାସର ଯାଜକ ସହସ୍ରପତି ଓ ଶତପତିମାନଙ୍କଠାରୁ ସେହି ସ୍ୱର୍ଣ୍ଣ ଗ୍ରହଣ କଲେ, ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ସ୍ମରଣାର୍ଥକ ଚିହ୍ନ ରୂପେ ତାହା ସମାଗମ-ତମ୍ବୁରେ ରଖିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ରୁବେନ୍‍-ସନ୍ତାନଗଣର ଓ ଗାଦ୍‍-ସନ୍ତାନଗଣର ଅନେକ ପଶୁପଲ ଥିଲା; ଏଣୁ ସେମାନେ ଯାସେର ଦେଶକୁ ଓ ଗିଲୀୟଦ ଦେଶକୁ ଦେଖିଲେ ଯେଉଁ ସ୍ଥାନ ପଶୁପଲ ନିମନ୍ତେ ଉପଯୁକ୍ତ ସ୍ଥାନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ଏଥିରେ ଗାଦ୍‍ର ସନ୍ତାନଗଣ, ରୁବେନ୍‍ର ସନ୍ତାନଗଣ ଆସି ମୋଶାଙ୍କୁ, ଇଲୀୟାସର ଯାଜକକୁ ଓ ମଣ୍ଡଳୀର ଅଧ୍ୟକ୍ଷଗଣକୁ କହିଲେ; ");
INSERT INTO ory_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“ଅଟାରୋତ୍‍, ଦୀବୋନ୍, ଯାସେର, ନିମ୍ରା, ହିଷ୍‍ବୋନ, ଇଲୀୟାଲୀ, ସିବମା, ନବୋ ଓ ବିୟୋନ, ");
INSERT INTO ory_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ଏହି ଯେଉଁସବୁ ଦେଶକୁ ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲ-ମଣ୍ଡଳୀ ସମ୍ମୁଖରେ ପରାସ୍ତ କରିଅଛନ୍ତି, ତାହା ପଶୁପଲ ନିମନ୍ତେ ଉପଯୁକ୍ତ ସ୍ଥାନ ଅଟେ। ପୁଣି, ତୁମ୍ଭର ଏହି ଦାସମାନଙ୍କର ପଶୁପଲ ଅଛି।” ");
INSERT INTO ory_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ସେମାନେ ଆହୁରି କହିଲେ, “ଆମ୍ଭେମାନେ ଯଦି ତୁମ୍ଭ ଦୃଷ୍ଟିରେ ଅନୁଗ୍ରହ ପାଇଅଛୁ, ତେବେ ତୁମ୍ଭର ଦାସଗଣକୁ ଅଧିକାରାର୍ଥେ ଏହି ଦେଶ ଦିଆଯାଉ; ଆମ୍ଭମାନଙ୍କୁ ଯର୍ଦ୍ଦନ ପାରିକୁ ନେଇଯାଅ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ଏଥିରେ ମୋଶା ଗାଦ୍‍ର ସନ୍ତାନଗଣକୁ ଓ ରୁବେନ୍‍ର ସନ୍ତାନଗଣକୁ କହିଲେ, “ତୁମ୍ଭମାନଙ୍କର ଭାଇମାନେ ଯୁଦ୍ଧ କରିବାକୁ ଯିବେ, ଆଉ ତୁମ୍ଭେମାନେ କି ଏଠାରେ ବସି ରହିବ? ");
INSERT INTO ory_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ସଦାପ୍ରଭୁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଯେଉଁ ଦେଶ ଦେଇଅଛନ୍ତି, ପାର ହୋଇ ସେହି ଦେଶକୁ ଯିବା ପାଇଁ କାହିଁକି ସେମାନଙ୍କ ମନକୁ ସାହସହୀନ କରୁଅଛ? ");
INSERT INTO ory_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ମୁଁ ତୁମ୍ଭର ପିତୃଲୋକମାନଙ୍କୁ କାଦେଶ-ବର୍ଣ୍ଣେୟଠାରୁ ସେହି ଦେଶ ଦେଖିବାକୁ ପଠାଇବା ସମୟରେ ସେମାନେ ଏହିରୂପେ କରିଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","କାରଣ ସେମାନେ ଇଷ୍କୋଲ-ଉପତ୍ୟକା ପର୍ଯ୍ୟନ୍ତ ଗମନ କରି ଦେଶ ଦେଖି ସଦାପ୍ରଭୁଙ୍କ ଦତ୍ତ ଦେଶକୁ ଯିବା ପାଇଁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ମନକୁ ସାହସହୀନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ଏନିମନ୍ତେ ସେହି ଦିନ ସଦାପ୍ରଭୁଙ୍କର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା, ପୁଣି, ସେ ଶପଥ କରି ଏହି କଥା କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘ଆମ୍ଭେ ଅବ୍ରହାମଙ୍କୁ, ଇସ୍‌ହାକକୁ ଓ ଯାକୁବକୁ ଯେଉଁ ଦେଶ ଦେବା ପାଇଁ ଶପଥ କରିଅଛୁ, ମିସରରୁ ଆଗତ ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ କୋଡ଼ିଏ ବର୍ଷ ଓ ତତୋଧିକ ବର୍ଷ ବୟସ୍କ କେହି ସେହି ଦେଶ ଦେଖି ପାରିବ ନାହିଁ, ଏହା ନିଶ୍ଚିତ; କାରଣ ସେମାନେ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ଆମ୍ଭର ଅନୁଗତ ହୋଇ ନାହାନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","କେବଳ କନିସୀୟ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ ଓ ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ ତାହା ଦେଖିବେ; କାରଣ ସେମାନେ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ସଦାପ୍ରଭୁଙ୍କର ଅନୁଗତ ହୋଇଅଛନ୍ତି।’ ");
INSERT INTO ory_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ଏହିରୂପେ ଇସ୍ରାଏଲ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର କ୍ରୋଧ ପ୍ରଜ୍ୱଳିତ ହେଲା, ପୁଣି, ସଦାପ୍ରଭୁଙ୍କ ଦୃଷ୍ଟିରେ କୁକର୍ମକାରୀ ସମସ୍ତ ବଂଶର ନିଃଶେଷ ନ ହେବା ପର୍ଯ୍ୟନ୍ତ ସେ ସେମାନଙ୍କୁ ଚାଳିଶ ବର୍ଷ ପର୍ଯ୍ୟନ୍ତ ଏ ପ୍ରାନ୍ତରରେ ଭ୍ରମଣ କରାଇଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ଏବେ ଦେଖ, ପାପିଷ୍ଠ ଲୋକମାନଙ୍କର ବଂଶ, ତୁମ୍ଭେମାନେ ଇସ୍ରାଏଲ ପ୍ରତି ସଦାପ୍ରଭୁଙ୍କର ପ୍ରଚଣ୍ଡ କ୍ରୋଧ ଆହୁରି ବଢ଼ାଇବାର ନିମନ୍ତେ ଆପଣା ଆପଣା ପିତୃଗଣର ସ୍ଥାନରେ ଉଠିଅଛ। ");
INSERT INTO ory_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","କାରଣ ଯଦି ତୁମ୍ଭେମାନେ ଏହିରୂପେ ତାହାଙ୍କ ପଶ୍ଚାଦ୍‍ଗମନରୁ ବିମୁଖ ହେବ, ତେବେ ସେ ପୁନର୍ବାର ଇସ୍ରାଏଲକୁ ପ୍ରାନ୍ତରରେ ପରିତ୍ୟାଗ କରିବେ, ତହିଁରେ ତୁମ୍ଭେମାନେ ଏହି ସକଳ ଲୋକଙ୍କୁ ବିନଷ୍ଟ କରାଇବ।” ");
INSERT INTO ory_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ଏଥିରେ ସେମାନେ ତାଙ୍କ ନିକଟକୁ ଆସି କହିଲେ, “ଆମ୍ଭେମାନେ ଏହି ସ୍ଥାନରେ ଆପଣା ଆପଣା ପଶୁମାନଙ୍କ ନିମନ୍ତେ ମେଷଶାଳା ଓ ଆପଣା ଆପଣା ବାଳକମାନଙ୍କ ନିମନ୍ତେ ନଗର ନିର୍ମାଣ କରିବା। ");
INSERT INTO ory_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ମାତ୍ର ଆମ୍ଭେମାନେ ନିଜେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ସେମାନଙ୍କ ସ୍ଥାନକୁ ନ ଆଣିବା ପର୍ଯ୍ୟନ୍ତ ସସଜ୍ଜ ହୋଇ ସେମାନଙ୍କ ଆଗେ ଆଗେ ଗମନ କରିବୁ; କେବଳ ଆମ୍ଭମାନଙ୍କର ବାଳକମାନେ ଦେଶନିବାସୀମାନଙ୍କ ସକାଶୁ ପ୍ରାଚୀର-ବେଷ୍ଟିତ ନଗରରେ ବାସ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ପ୍ରତ୍ୟେକ ଲୋକ ଆପଣା ଆପଣା ଅଧିକାର ନ ପାଇବା ପର୍ଯ୍ୟନ୍ତ ଆମ୍ଭେମାନେ ଆପଣା ଆପଣା ଗୃହକୁ ଫେରି ଆସିବୁ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ମାତ୍ର ଆମ୍ଭେମାନେ ଯର୍ଦ୍ଦନର ଆରପାରିରେ ଓ ତହିଁ ଆଗରେ ସେମାନଙ୍କ ସହିତ ଅଧିକାର ଗ୍ରହଣ କରିବୁ ନାହିଁ; କାରଣ ଯର୍ଦ୍ଦନର ଏହି ପାରିରେ ଆମ୍ଭମାନଙ୍କ ଅଧିକାର ପଡ଼ିଅଛି।” ");
INSERT INTO ory_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ଏଥିରେ ମୋଶା ସେମାନଙ୍କୁ କହିଲେ, “ତୁମ୍ଭେମାନେ ଯଦି ଏହି କର୍ମ କର, ଯଦି ସସଜ୍ଜ ହୋଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଯୁଦ୍ଧ କରିବାକୁ ଗମନ କର, ");
INSERT INTO ory_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ପୁଣି, ସଦାପ୍ରଭୁ ଯେପର୍ଯ୍ୟନ୍ତ ଆପଣା ଶତ୍ରୁଗଣକୁ ଆପଣା ଆଗରୁ ତଡ଼ି ନ ଦିଅନ୍ତି ");
INSERT INTO ory_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ଓ ଦେଶ ସଦାପ୍ରଭୁଙ୍କ ଆଗରେ ବଶୀଭୂତ ନ ହୁଏ, ସେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭମାନଙ୍କର ପ୍ରତ୍ୟେକ ସସଜ୍ଜ ଲୋକ ଯଦି ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଯର୍ଦ୍ଦନ ପାର ହୁଅ; ତେବେ ତହିଁ ଉତ୍ତାରେ ତୁମ୍ଭେମାନେ ଫେରି ଆସିଲେ, ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ଓ ଇସ୍ରାଏଲ ନିକଟରେ ନିର୍ଦ୍ଦୋଷ ହେବ; ଆଉ ସେହି ଦେଶ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ତୁମ୍ଭମାନଙ୍କର ଅଧିକାର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ମାତ୍ର ତୁମ୍ଭେମାନେ ଯଦି ସେହିପରି ନ କର, ତେବେ ଦେଖ, ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ନିକଟରେ ପାପୀ ହେବ; ପୁଣି, ତୁମ୍ଭମାନଙ୍କର ପାପ ଯେ ତୁମ୍ଭମାନଙ୍କୁ ଧରିବ, ଏହା ନିଶ୍ଚିତ ଜାଣ। ");
INSERT INTO ory_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ବାଳକମାନଙ୍କ ପାଇଁ ନଗର ଓ ମେଷମାନଙ୍କ ପାଇଁ ଶାଳା ନିର୍ମାଣ କର, ଆଉ ଆପଣାମାନଙ୍କ ମୁଖରୁ ନିର୍ଗତ ବାକ୍ୟ ପ୍ରମାଣେ କର୍ମ କର।” ");
INSERT INTO ory_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ତେବେ ଗାଦ୍‍-ସନ୍ତାନଗଣ ଓ ରୁବେନ୍‍-ସନ୍ତାନଗଣ ମୋଶାଙ୍କୁ କହିଲେ, “ଆମ୍ଭମାନଙ୍କର ପ୍ରଭୁ ଯାହା ଆଜ୍ଞା କଲେ, ତଦନୁସାରେ ତୁମ୍ଭର ଦାସମାନେ କର୍ମ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ଆମ୍ଭମାନଙ୍କର ବାଳକ, ସ୍ତ୍ରୀ, ପଲ ଓ ପଶୁସକଳ ଗିଲୀୟଦର ନଗରମାନଙ୍କରେ ରହିବେ। ");
INSERT INTO ory_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ମାତ୍ର ଆମ୍ଭମାନଙ୍କ ପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ତୁମ୍ଭର ଦାସମାନେ ପ୍ରତ୍ୟେକେ ସସଜ୍ଜ ହୋଇ ସଦାପ୍ରଭୁଙ୍କ ଆଗରେ ଯୁଦ୍ଧ କରିବାକୁ ପାର ହୋଇଯିବେ।” ");
INSERT INTO ory_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ତହୁଁ ମୋଶା ସେମାନଙ୍କ ବିଷୟରେ ଇଲୀୟାସର ଯାଜକକୁ, ନୂନର ପୁତ୍ର ଯିହୋଶୂୟଙ୍କୁ ଓ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ବଂଶୀୟ ପିତୃଗୃହର ପ୍ରଧାନମାନଙ୍କୁ ଆଜ୍ଞା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ପୁଣି, ମୋଶା ସେମାନଙ୍କୁ କହିଲେ, “ଗାଦ୍‍-ସନ୍ତାନଗଣର ଓ ରୁବେନ୍‍-ସନ୍ତାନଗଣର, ଯୁଦ୍ଧାର୍ଥେ ସସଜ୍ଜ ପ୍ରତ୍ୟେକ ଲୋକ ଯଦି ତୁମ୍ଭମାନଙ୍କ ସହିତ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ଯର୍ଦ୍ଦନ ପାର ହେବେ ଓ ତୁମ୍ଭମାନଙ୍କ ସମ୍ମୁଖରେ ଦେଶ ବଶୀଭୂତ ହେବ; ତେବେ ତୁମ୍ଭେମାନେ ଅଧିକାରାର୍ଥେ ସେମାନଙ୍କୁ ଗିଲୀୟଦ ଦେଶ ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ମାତ୍ର ଯଦି ସେମାନେ ସସଜ୍ଜ ହୋଇ ତୁମ୍ଭମାନଙ୍କ ସହିତ ପାର ନ ହେବେ, ତେବେ ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରେ କିଣାନ ଦେଶରେ ଅଧିକାର ପାଇବେ।” ");
INSERT INTO ory_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ତହିଁରେ ଗାଦ୍‍-ସନ୍ତାନଗଣ ଓ ରୁବେନ୍‍-ସନ୍ତାନଗଣ ଉତ୍ତର ଦେଇ କହିଲେ, “ସଦାପ୍ରଭୁ ଆପଣା ଦାସମାନଙ୍କୁ ଯାହା କହିଅଛନ୍ତି, ତଦନୁସାରେ ଆମ୍ଭେମାନେ କର୍ମ କରିବୁ। ");
INSERT INTO ory_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ଆମ୍ଭେମାନେ ସସଜ୍ଜ ହୋଇ ସଦାପ୍ରଭୁଙ୍କ ସମ୍ମୁଖରେ ପାର ହୋଇ କିଣାନ ଦେଶକୁ ଯିବୁ ମାତ୍ର ଯର୍ଦ୍ଦନର ପୂର୍ବ ଆଡ଼େ ଆମ୍ଭମାନଙ୍କ ଅଧିକାରରେ ଆମ୍ଭମାନଙ୍କ ସ୍ୱତ୍ୱ ରହିବ।” ");
INSERT INTO ory_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ଏଉତ୍ତାରେ ମୋଶା ସେମାନଙ୍କୁ, ଅର୍ଥାତ୍‍, ଗାଦ୍‍-ସନ୍ତାନଗଣକୁ, ରୁବେନ୍‍-ସନ୍ତାନଗଣକୁ ଓ ଯୋଷେଫର ପୁତ୍ର ମନଃଶି ବଂଶର ଅର୍ଦ୍ଧେକକୁ ଇମୋରୀୟମାନଙ୍କ ରାଜା ସୀହୋନର ରାଜ୍ୟ ଓ ବାଶନର ରାଜା ଓଗ୍‍ର ରାଜ୍ୟ, ଅର୍ଥାତ୍‍, ସ୍ୱ ସ୍ୱ ସୀମା ସହିତ ନାନା ନଗରବିଶିଷ୍ଟ ଦେଶ, ଏହିରୂପେ ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ଦେଶର ସମସ୍ତ ନଗର ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ତହିଁରେ ଗାଦ୍‍-ସନ୍ତାନଗଣ ଦୀବୋନ୍, ଅଟାରୋତ୍‍ ଓ ଅରୋୟେର; ");
INSERT INTO ory_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ଅଟ୍‍ରୋତ୍‍-ଶୋଫନ, ଯାସେର, ଯଗ୍‍ବିହ, ");
INSERT INTO ory_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ବେଥ୍-ନିମ୍ରା, ବେଥ୍-ହାରଣ ନାମକ ପ୍ରାଚୀର-ବେଷ୍ଟିତ ନଗର ଓ ମେଷଶାଳା ନିର୍ମାଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ପୁଣି, ରୁବେନ୍‍-ସନ୍ତାନଗଣ ହିଷ୍‍ବୋନ, ଇଲୀୟାଲୀ ଓ କିରୀୟାଥୟିମ୍‍; ");
INSERT INTO ory_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ପୁଣି, ନାମାନ୍ତରରେ ନବୋ, ବାଲ୍‍-ମୀୟୋନ୍‍ ଓ ସିବ୍‍ମା, ଏହି ସମସ୍ତ ନଗର ନିର୍ମାଣ କଲେ; ପୁଣି, ସେମାନେ ଯେଉଁ ଯେଉଁ ନଗର ନିର୍ମାଣ କଲେ, ସେହି ସମସ୍ତଙ୍କୁ ଅନ୍ୟ ନାମ ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ପୁଣି, ମନଃଶିର ପୁତ୍ର ମାଖୀରର ସନ୍ତାନଗଣ ଗିଲୀୟଦକୁ ଯାଇ ତାହା ଆକ୍ରମଣ କଲେ ଓ ତନ୍ନିବାସୀ ଇମୋରୀୟମାନଙ୍କୁ ଅଧିକାରଚ୍ୟୁତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ତହୁଁ ମୋଶା ମନଃଶିର ପୁତ୍ର ମାଖୀରକୁ ଗିଲୀୟଦ ଦେଲେ; ଆଉ ସେ ସେଠାରେ ବାସ କଲା। ");
INSERT INTO ory_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ପୁଣି, ମନଃଶିର ପୁତ୍ର ଯାୟୀର ଯାଇ ସେମାନଙ୍କ ଗ୍ରାମସବୁ ହସ୍ତଗତ କରି ସେମାନଙ୍କ ନାମ ହବୋତ୍‍-ଯାୟୀର ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ଆଉ ନୋବହ ଯାଇ କନାତ୍‍ ଓ ତାହାର ନଗର ହସ୍ତଗତ କରି ଆପଣା ନାମାନୁସାରେ ତାହାର ନାମ ନୋବହ ରଖିଲା। ");
INSERT INTO ory_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମୋଶା ଓ ହାରୋଣଙ୍କର ହସ୍ତାଧୀନ ହୋଇ ଆପଣା ଆପଣା ସୈନ୍ୟଶ୍ରେଣୀ କ୍ରମେ ମିସର ଦେଶରୁ ବାହାରି ଆସିବା ସମୟରେ ଯେଉଁ ଯାତ୍ରା କରିଥିଲେ, ତହିଁର ବିବରଣ ଏହି। ");
INSERT INTO ory_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାରେ ସେମାନଙ୍କ ଯାତ୍ରାନୁସାରେ ସେମାନଙ୍କ ଗମନର ବିବରଣ ଲେଖିଲେ; ସେମାନଙ୍କ ଗମନାନୁସାରେ ସେମାନଙ୍କ ଯାତ୍ରାର ବିବରଣ ଏହି। ");
INSERT INTO ory_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ପ୍ରଥମ ମାସର ପଞ୍ଚଦଶ ଦିନରେ ସେମାନେ ରାମିଷେଷ୍‍ଠାରୁ ଯାତ୍ରା କଲେ; ");
INSERT INTO ory_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ନିସ୍ତାର ପର୍ବର ପରଦିନ ପ୍ରାତଃକାଳରେ ମିସରୀୟମାନେ ସଦାପ୍ରଭୁଙ୍କ ଦ୍ୱାରା ସଂହାରିତ ପ୍ରଥମଜାତ ସମସ୍ତଙ୍କୁ କବର ଦେଉଥିବା ସମୟରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମିସରୀୟ ସମସ୍ତ ଲୋକଙ୍କ ସାକ୍ଷାତରେ ଊର୍ଦ୍ଧ୍ୱ ହସ୍ତରେ ବାହାରିଲେ; ସଦାପ୍ରଭୁ ସେମାନଙ୍କ ଦେବଗଣକୁ ମଧ୍ୟ ଦଣ୍ଡ ଦେଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ରାମିଷେଷ୍‍ଠାରୁ ଯାତ୍ରା କରି ସୁକ୍କୋତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ପୁଣି, ସେମାନେ ସୁକ୍କୋତରୁ ଯାତ୍ରା କରି ପ୍ରାନ୍ତରର ସୀମାସ୍ଥିତ ଏଥମରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ତହୁଁ ସେମାନେ ଏଥମରୁ ଯାତ୍ରା କରି ବାଲ-ସଫୋନର ସମ୍ମୁଖସ୍ଥିତ ପୀହହୀରୋତକୁ ଫେରି ଆସିଲେ ଓ ମିଗ୍‍ଦୋଲର ପୂର୍ବ ଦିଗରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ଏଉତ୍ତାରେ ସେମାନେ ପୀହହୀରୋତର ସମ୍ମୁଖରୁ ଯାତ୍ରା କରି ସମୁଦ୍ର ମଧ୍ୟଦେଇ ପ୍ରାନ୍ତରରେ ପ୍ରବେଶ କଲେ ଓ ଏଥମ ପ୍ରାନ୍ତରରେ ତିନି ଦିନର ପଥ ଯାଇ ମାରାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ପୁଣି, ମାରାରୁ ଯାତ୍ରା କରି ଏଲୀମରେ ଉପସ୍ଥିତ ହେଲେ; ସେହି ଏଲୀମରେ ଜଳର ବାର ନିର୍ଝର ଓ ସତୁରି ଖର୍ଜ୍ଜୁର ବୃକ୍ଷ ଥିଲା; ଏଣୁ ସେମାନେ ସେହି ସ୍ଥାନରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ତହୁଁ ସେମାନେ ଏଲୀମରୁ ଯାତ୍ରା କରି ସୂଫ ସାଗର ନିକଟରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ପୁଣି, ସେମାନେ ସୂଫ ସାଗର ନିକଟରୁ ଯାତ୍ରା କରି ସୀନ୍‍ ପ୍ରାନ୍ତରରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ପୁଣି, ସେମାନେ ସୀନ୍‍ ପ୍ରାନ୍ତରରୁ ଯାତ୍ରା କରି ଦପ୍କାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ସେମାନେ ଦପ୍କାରୁ ଯାତ୍ରା କରି ଆଲୁଶରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ପୁଣି, ସେମାନେ ଆଲୁଶରୁ ଯାତ୍ରା କରି ରଫୀଦୀମରେ ଛାଉଣି ସ୍ଥାପନ କଲେ; ସେହି ସ୍ଥାନରେ ଲୋକମାନଙ୍କର ପିଇବା ନିମନ୍ତେ ଜଳ ନ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ଏଉତ୍ତାରେ ସେମାନେ ରଫୀଦୀମରୁ ଯାତ୍ରା କରି ସୀନୟ ପ୍ରାନ୍ତରରେ ଛାଉଣି ସ୍ଥାପନ କଲେ ");
INSERT INTO ory_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ଓ ସେମାନେ ସୀନୟ ପ୍ରାନ୍ତରରୁ ଯାତ୍ରା କରି କିବ୍ରୋତ୍‍-ହତ୍ତାବାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ପୁଣି, ସେମାନେ କିବ୍ରୋତ୍‍-ହତ୍ତାବାରୁ ଯାତ୍ରା କରି ହତ୍ସେରୋତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ପୁଣି, ସେମାନେ ହତ୍ସେରୋତରୁ ଯାତ୍ରା କରି ରିତ୍ମାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ ");
INSERT INTO ory_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ଓ ସେମାନେ ରିତ୍ମାରୁ ଯାତ୍ରା କରି ରିମ୍ମୋନ୍‍-ପେରସରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ପୁଣି, ସେମାନେ ରିମ୍ମୋନ୍‍-ପେରସରୁ ଯାତ୍ରା କରି ଲିବ୍‍ନାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ପୁଣି, ସେମାନେ ଲିବ୍‍ନାରୁ ଯାତ୍ରା କରି ରିସ୍ସାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ପୁଣି, ସେମାନେ ରିସ୍ସାରୁ ଯାତ୍ରା କରି କହେଲାତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ଓ ସେମାନେ କହେଲାତରୁ ଯାତ୍ରା କରି ଶେଫର ପର୍ବତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ ");
INSERT INTO ory_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ତହୁଁ ସେମାନେ ଶେଫର ପର୍ବତରୁ ଯାତ୍ରା କରି ହରାଦାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ଓ ସେମାନେ ହରାଦାରୁ ଯାତ୍ରା କରି ମଖେଲୋତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ଓ ସେମାନେ ମଖେଲୋତରୁ ଯାତ୍ରା କରି ତହତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ସେମାନେ ତହତରୁ ଯାତ୍ରା କରି ତେରହରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ଓ ସେମାନେ ତେରହରୁ ଯାତ୍ରା କରି ମିତ୍‍କାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ ");
INSERT INTO ory_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ଓ ସେମାନେ ମିତ୍‍କାରୁ ଯାତ୍ରା କରି ହଶ୍‍ମୋନାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ଓ ସେମାନେ ହଶ୍‍ମୋନାରୁ ଯାତ୍ରା କରି ମୋଷେରୋତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ପୁଣି, ସେମାନେ ମୋଷେରୋତରୁ ଯାତ୍ରା କରି ବନେୟାକନରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ଓ ସେମାନେ ବନେୟାକନରୁ ଯାତ୍ରା କରି ହୋର୍ହଗିଦ୍‍ଗଦରେ ଛାଉଣି ସ୍ଥାପନ କଲେ ");
INSERT INTO ory_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ଓ ସେମାନେ ହୋର୍ହଗିଦ୍‍ଗଦରୁ ଯାତ୍ରା କରି ଯଟ୍‍ବାଥାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ଓ ସେମାନେ ଯଟ୍‍ବାଥାରୁ ଯାତ୍ରା କରି ଆବ୍ରୋଣାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ପୁଣି, ସେମାନେ ଆବ୍ରୋଣାରୁ ଯାତ୍ରା କରି ଇତ୍‍ସିୟୋନ-ଗେବରରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ପୁଣି, ସେମାନେ ଇତ୍‍ସିୟୋନ-ଗେବରରୁ ଯାତ୍ରା କରି ସୀନ୍‍ ପ୍ରାନ୍ତରରେ ଛାଉଣି ସ୍ଥାପନ କଲେ (ଏହାକୁ କାଦେଶ କହନ୍ତି), ");
INSERT INTO ory_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ଓ ସେମାନେ କାଦେଶରୁ ଯାତ୍ରା କରି ଇଦୋମ ଦେଶର ପ୍ରାନ୍ତରସ୍ଥିତ ହୋର ପର୍ବତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ଏଥିଉତ୍ତାରେ ହାରୋଣ ଯାଜକ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାରେ ହୋର ପର୍ବତରେ ଆରୋହଣ କଲେ, ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣ ମିସରରୁ ବାହାର ହୋଇ ଆସିବାର ଚାଳିଶତମ ବର୍ଷର ପଞ୍ଚମ ମାସର ପ୍ରଥମ ଦିନରେ ସେହି ସ୍ଥାନରେ ମଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ଆଉ ହୋର ପର୍ବତରେ ମରିବା ସମୟରେ ହାରୋଣଙ୍କର ବୟସ ଏକ ଶହ ତେଇଶ ବର୍ଷ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ଏଥିଉତ୍ତାରେ କିଣାନର ଦକ୍ଷିଣ ପ୍ରଦେଶ ନିବାସୀ କିଣାନୀୟ ଅରାଦର ରାଜା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣର ଆଗମନ ସମ୍ବାଦ ଶୁଣିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ଆଉ ସେମାନେ ହୋର ପର୍ବତରୁ ଯାତ୍ରା କରି ସଲ୍‍ମୋନାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ଓ ସେମାନେ ସଲ୍‍ମୋନାରୁ ଯାତ୍ରା କରି ପୂନୋନରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ଓ ସେମାନେ ପୂନୋନରୁ ଯାତ୍ରା କରି ଓବୋତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ତହୁଁ ସେମାନେ ଓବୋତରୁ ଯାତ୍ରା କରି ମୋୟାବ ପ୍ରାନ୍ତସ୍ଥିତ ଇୟୀ-ଅବାରୀମରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ଓ ସେମାନେ ଇୟୀ-ଅବାରୀମରୁ ଯାତ୍ରା କରି ଦୀବୋନ୍‍-ଗାଦ୍‍ରେ ଛାଉଣି ସ୍ଥାପନ କଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ଓ ସେମାନେ ଦୀବୋନ୍‍-ଗାଦ୍‍ରୁ ଯାତ୍ରା କରି ଅଲମୋନ-ଦିବ୍‍ଲାଥୟିମରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ତହୁଁ ସେମାନେ ଅଲମୋନ-ଦିବ୍‍ଲାଥୟିମରୁ ଯାତ୍ରା କରି ନବୋ-ସମ୍ମୁଖସ୍ଥିତ ଅବାରୀମ୍ ପର୍ବତରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ପୁଣି, ସେମାନେ ଅବାରୀମ୍ ପର୍ବତରୁ ଯାତ୍ରା କରି ଯିରୀହୋ ସମ୍ମୁଖସ୍ଥିତ ଯର୍ଦ୍ଦନ ନିକଟବର୍ତ୍ତୀ ମୋୟାବ-ପଦାରେ ଛାଉଣି ସ୍ଥାପନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ଆଉ ସେଠାରେ ଯର୍ଦ୍ଦନ ନିକଟସ୍ଥ ବେଥ୍-ଯିଶିମୋତଠାରୁ ଆବେଲ୍-ଶିଟୀମ ପର୍ଯ୍ୟନ୍ତ ମୋୟାବ-ପଦାରେ ଛାଉଣି ସ୍ଥାପନ କରି ରହିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ଏଥିଉତ୍ତାରେ ଯିରୀହୋସ୍ଥିତ ଯର୍ଦ୍ଦନ ନିକଟବର୍ତ୍ତୀ ମୋୟାବ-ପଦାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ତୁମ୍ଭେମାନେ ଯର୍ଦ୍ଦନ ପାର ହୋଇ କିଣାନ ଦେଶରେ ଉପସ୍ଥିତ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ସମ୍ମୁଖରୁ ସେହି ଦେଶ ନିବାସୀ ସମସ୍ତଙ୍କୁ ତଡ଼ି ବାହାର କରିଦେବ ଓ ସେମାନଙ୍କର ସମସ୍ତ ମୂର୍ତ୍ତିବିଶିଷ୍ଟ ପାଷାଣ ଭାଙ୍ଗି ପକାଇବ ଓ ସେମାନଙ୍କର ଛାଞ୍ଚ-ଢଳା ପ୍ରତିମାସବୁ ବିନଷ୍ଟ କରିବ ଓ ସେମାନଙ୍କର ଉଚ୍ଚସ୍ଥଳୀସବୁ ଉଚ୍ଛିନ୍ନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ପୁଣି, ତୁମ୍ଭେମାନେ ସେହି ଦେଶ ଅଧିକାର କରି ତହିଁ ମଧ୍ୟରେ ବାସ କରିବ; କାରଣ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ଅଧିକାରାର୍ଥେ ସେହି ଦେଶ ଦେଇଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ଆଉ ତୁମ୍ଭେମାନେ ଗୁଲିବାଣ୍ଟ ଦ୍ୱାରା ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଦେଶାଧିକାର ବିଭାଗ କରି ନେବ; ତୁମ୍ଭେମାନେ ଅଧିକ ଲୋକଙ୍କୁ ଅଧିକ ବାଣ୍ଟ ଓ ଅଳ୍ପ ଲୋକଙ୍କୁ ଅଳ୍ପ ବାଣ୍ଟ ଦେବ; ଯାହାର ବାଣ୍ଟ ଯେଉଁ ସ୍ଥାନରେ ପଡ଼ିବ, ତାହାର ବାଣ୍ଟ ସେହି ସ୍ଥାନରେ ହେବ; ଏହିରୂପେ ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ପିତୃବଂଶାନୁସାରେ ଅଧିକାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ମାତ୍ର ଯଦି ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ସମ୍ମୁଖରୁ ସେହି ଦେଶ ନିବାସୀମାନଙ୍କୁ ତଡ଼ି ବାହାର କରି ନ ଦେବ, ତେବେ ତୁମ୍ଭେମାନେ ସେମାନଙ୍କ ମଧ୍ୟରୁ ଯେଉଁମାନଙ୍କୁ ଅବଶିଷ୍ଟ ରଖିବ, ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ଚକ୍ଷୁରେ କଣ୍ଟା ସ୍ୱରୂପ ଓ ତୁମ୍ଭମାନଙ୍କ ପାର୍ଶ୍ଵରେ କଣ୍ଟକ ସ୍ୱରୂପ ହେବେ, ଆଉ ସେମାନେ ତୁମ୍ଭମାନଙ୍କ ସେହି ନିବାସ ଦେଶରେ ତୁମ୍ଭମାନଙ୍କୁ କ୍ଳେଶ ଦେବେ। ");
INSERT INTO ory_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ପୁଣି, ଆମ୍ଭେ ସେମାନଙ୍କ ପ୍ରତି ଯାହା କରିବାକୁ ମନସ୍ଥ କରିଥିଲୁ, ତାହା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି କରିବା।” ");
INSERT INTO ory_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଆଜ୍ଞା ଦିଅ ଓ ସେମାନଙ୍କୁ କୁହ, ‘ଯେଉଁ କିଣାନ ଦେଶ, ତହିଁର ଚତୁଃସୀମାନୁସାରେ ତୁମ୍ଭମାନଙ୍କ ଅଧିକାରରେ ପଡ଼ିବ, ତୁମ୍ଭେମାନେ ସେହି କିଣାନ ଦେଶରେ ଉପସ୍ଥିତ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ତୁମ୍ଭମାନଙ୍କ ଦକ୍ଷିଣ ଅଞ୍ଚଳ ଇଦୋମ ନିକଟସ୍ଥିତ ସୀନ୍‍ ପ୍ରାନ୍ତରଠାରୁ ହେବ ଓ ପୂର୍ବ ଦିଗରେ ଲବଣ ସମୁଦ୍ରର ପ୍ରାନ୍ତଠାରୁ ତୁମ୍ଭମାନଙ୍କର ଦକ୍ଷିଣ ସୀମା ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ପୁଣି, ତୁମ୍ଭମାନଙ୍କର ସୀମା ଦକ୍ଷିଣ ଦିଗରୁ ଫେରି ଅକ୍ରବ୍ବୀମ ଘାଟ ଦେଇ ସୀନ୍‍ ପର୍ଯ୍ୟନ୍ତ ଯିବ ଓ ସେଠାରୁ କାଦେଶ-ବର୍ଣ୍ଣେୟର ଦକ୍ଷିଣ ଦେଇ ହତ୍‍ସର-ଅଦରକୁ ଆସି ଅସ୍ମୋନ ପର୍ଯ୍ୟନ୍ତ ଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ଏଉତ୍ତାରେ ସେହି ସୀମା ଅସ୍ମୋନରୁ ମିସରର ନଦୀ ପର୍ଯ୍ୟନ୍ତ ବୁଲି ଆସିବ ଓ ସେହି ସୀମା ମହାସମୁଦ୍ର ନିକଟରେ ଶେଷ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ଆଉ ମହାସମୁଦ୍ର ଓ ତହିଁର ସୀମା ପଶ୍ଚିମ ସୀମା ହେବ; ଏହା ତୁମ୍ଭମାନଙ୍କର ପଶ୍ଚିମ ସୀମା ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","ଆଉ ତୁମ୍ଭମାନଙ୍କର ଉତ୍ତର ସୀମା ଏହି ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ମହାସମୁଦ୍ରଠାରୁ ହୋର ପର୍ବତ ପର୍ଯ୍ୟନ୍ତ ଚିହ୍ନିତ କରିବ; ");
INSERT INTO ory_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ହୋର ପର୍ବତଠାରୁ ତୁମ୍ଭେମାନେ ହମାତର ପ୍ରବେଶ ସ୍ଥାନ ପର୍ଯ୍ୟନ୍ତ ଚିହ୍ନିତ କରିବ; ପୁଣି, ସେଠାରୁ ସେହି ସୀମା ସଦାଦ୍‍ ନିକଟରେ ଶେଷ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ପୁଣି, ସେହି ସୀମା ସିଫ୍ରୋଣ ପର୍ଯ୍ୟନ୍ତ ଯିବ ଓ ହତ୍‍ସର-ଐନନ୍‍ରେ ତହିଁର ଶେଷ ହେବ; ଏହା ତୁମ୍ଭମାନଙ୍କର ଉତ୍ତର ସୀମା ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","ଆଉ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ପୂର୍ବ ସୀମା ହତ୍‍ସର-ଐନନ୍‍ଠାରୁ ଶଫାମ୍‍ ପର୍ଯ୍ୟନ୍ତ ଚିହ୍ନିତ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ତହୁଁ ସେହି ସୀମା ଶଫାମ୍‍ଠାରୁ ଐନ୍‍ର ପୂର୍ବଦିଗ ହୋଇ ରିବ୍ଲା ପର୍ଯ୍ୟନ୍ତ ତଳକୁ ଯିବ; ତହିଁ ଉତ୍ତାରେ ସେହି ସୀମା ଆହୁରି ତଳକୁ ଯାଇ କିନ୍ନେରତ୍‍ ହ୍ରଦର ପୂର୍ବ ପାର୍ଶ୍ୱ ଦେଇ ଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ପୁଣି, ସେହି ସୀମା ଯର୍ଦ୍ଦନ ଦେଇ ଯିବ ଓ ଲବଣ ସମୁଦ୍ର ନିକଟରେ ତହିଁର ଶେଷ ହେବ; ଏହି ଚତୁଃସୀମାନୁସାରେ ତୁମ୍ଭମାନଙ୍କର ଦେଶ ହେବ।’” ");
INSERT INTO ory_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ପୁନଶ୍ଚ, ମୋଶା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଆଜ୍ଞା ଦେଇ କହିଲେ, “ସଦାପ୍ରଭୁ ନଅ ବଂଶ ଓ ଅର୍ଦ୍ଧ ବଂଶକୁ ଯେଉଁ ଦେଶ ଦେବା ପାଇଁ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି ଓ ତୁମ୍ଭେମାନେ ଯାହା ଗୁଲିବାଣ୍ଟ ଦ୍ୱାରା ଅଧିକାର କରିବ, ସେହି ଦେଶ ଏହି। ");
INSERT INTO ory_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","କାରଣ ରୁବେନ୍‍-ସନ୍ତାନଗଣଙ୍କର ବଂଶ ଆପଣା ଆପଣା ପିତୃଗୃହ ଅନୁସାରେ ଓ ଗାଦ୍‍-ସନ୍ତାନଗଣଙ୍କର ବଂଶ ଆପଣା ଆପଣା ପିତୃଗୃହ ଅନୁସାରେ ଓ ମନଃଶିର ଅର୍ଦ୍ଧ ବଂଶ ଆପଣା ଆପଣା ଅଧିକାର ପାଇଅଛନ୍ତି; ");
INSERT INTO ory_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ଏହି ଦୁଇ ବଂଶ ଓ ଅର୍ଦ୍ଧ ବଂଶ ଯିରୀହୋ ନିକଟସ୍ଥ ଯର୍ଦ୍ଦନର ପୂର୍ବପାରିରେ ସୂର୍ଯ୍ୟୋଦୟ ଦିଗରେ ଆପଣା ଆପଣା ଅଧିକାର ପାଇଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ଯେଉଁମାନେ ଦେଶ ବିଭାଗ କରି ତୁମ୍ଭମାନଙ୍କୁ ଦେବେ, ସେମାନଙ୍କର ନାମ ଏହି; ଇଲୀୟାସର ଯାଜକ ଓ ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ। ");
INSERT INTO ory_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ପୁଣି, ତୁମ୍ଭେମାନେ ଦେଶ ବିଭାଗ କରିବା ନିମନ୍ତେ ପ୍ରତ୍ୟେକ ବଂଶରୁ ଏକ ଏକ ଅଧିପତି ଗ୍ରହଣ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ପୁଣି, ସେହି ଲୋକମାନଙ୍କର ନାମ ଏହି; ଯିହୁଦା ବଂଶୀୟ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ, ");
INSERT INTO ory_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ଓ ଶିମୀୟୋନର ସନ୍ତାନମାନଙ୍କ ବଂଶୀୟ ଅମ୍ମୀହୂଦର ପୁତ୍ର ଶେମୂୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ବିନ୍ୟାମୀନ୍ ବଂଶୀୟ କିଶଲୋନର ପୁତ୍ର ଇଲୀଦଦ୍‍। ");
INSERT INTO ory_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ଆଉ ଦାନ୍-ସନ୍ତାନଗଣର ବଂଶୀୟ ଜଣେ ଅଧିପତି, ଯଗ୍ଲିର ପୁତ୍ର ବୁକ୍କି। ");
INSERT INTO ory_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ଯୋଷେଫ-ସନ୍ତାନଗଣ ମଧ୍ୟରୁ; ମନଃଶି ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ଜଣେ ଅଧିପତି, ଏଫୋଦର ପୁତ୍ର ହନ୍ନୀୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ପୁଣି, ଇଫ୍ରୟିମ-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ଜଣେ ଅଧିପତି, ଶିପ୍ତନର ପୁତ୍ର କମୂୟେଲ। ");
INSERT INTO ory_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ଆଉ ସବୂଲୂନ-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ଜଣେ ଅଧିପତି, ପର୍ଣ୍ଣକର ପୁତ୍ର ଇଲୀଶାଫନ୍‍, ");
INSERT INTO ory_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ଓ ଇଷାଖର-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ଜଣେ ଅଧିପତି, ଅସ୍ସନର ପୁତ୍ର ପଲ୍ଟୀୟେଲ, ");
INSERT INTO ory_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ଓ ଆଶେର-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ଜଣେ ଅଧିପତି, ଶଲୋମିର ପୁତ୍ର ଅହୀହୂଦ୍‍। ");
INSERT INTO ory_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ନପ୍ତାଲି-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ଜଣେ ଅଧିପତି, ଅମ୍ମୀହୂଦର ପୁତ୍ର ପଦହେଲ୍।” ");
INSERT INTO ory_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","କିଣାନ ଦେଶରେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ନିମନ୍ତେ ଅଧିକାର ବିଭାଗ କରି ଦେବାକୁ ସଦାପ୍ରଭୁ ଏହି ସମସ୍ତ ଲୋକଙ୍କୁ ଆଜ୍ଞା ଦେଲେ। ");
INSERT INTO ory_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋୟାବ-ପଦାରେ ଯିରୀହୋ ନିକଟସ୍ଥ ଯର୍ଦ୍ଦନ ନଦୀ ସମୀପରେ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ତୁମ୍ଭେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ ଏହି ଆଜ୍ଞା ଦିଅ; ସେମାନେ ଆପଣା ଆପଣା ଅଧିକୃତ ବାଣ୍ଟରୁ କେତେକ ବସତି-ନଗର ଲେବୀୟମାନଙ୍କୁ ଦିଅନ୍ତୁ, ଆଉ ତୁମ୍ଭେମାନେ ଲେବୀୟମାନଙ୍କୁ ସେହି ନଗରମାନର ତଳିଭୂମି ନିମନ୍ତେ ସେସବୁର ଚତୁର୍ଦ୍ଦିଗସ୍ଥ ଭୂମି ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ତହିଁରେ ସେହି ସବୁ ନଗରରେ ସେମାନଙ୍କର ନିବାସ ହେବ; ପୁଣି, ତହିଁର ତଳିଭୂମିସବୁ ସେମାନଙ୍କ ପଶୁ, ସମ୍ପତ୍ତି ଓ ଜୀବମାନଙ୍କ ନିମନ୍ତେ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ଆଉ ତୁମ୍ଭେମାନେ ଲେବୀୟମାନଙ୍କୁ ଯେଉଁ ଯେଉଁ ନଗର ଦେବ, ସେହିସବୁର ତଳିଭୂମି ନଗର-ପ୍ରାଚୀରଠାରୁ ବାହାରେ ଚତୁର୍ଦ୍ଦିଗରେ ଏକ ସହସ୍ର ହସ୍ତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ପୁଣି, ତୁମ୍ଭେମାନେ ନଗରର ବାହାରେ ତହିଁର ପୂର୍ବ ସୀମା ଦୁଇ ସହସ୍ର ହସ୍ତ, ଦକ୍ଷିଣ ସୀମା ଦୁଇ ସହସ୍ର ହସ୍ତ, ପଶ୍ଚିମ ସୀମା ଦୁଇ ସହସ୍ର ହସ୍ତ ଓ ଉତ୍ତର ସୀମା ଦୁଇ ସହସ୍ର ହସ୍ତ ପରିମିତ କରିବ; ନଗର ତହିଁର ମଧ୍ୟସ୍ଥଳରେ ରହିବ। ଏହା ସେମାନଙ୍କ ନଗରର ତଳିଭୂମି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","ଆଉ ତୁମ୍ଭେମାନେ ଲେବୀୟମାନଙ୍କୁ ଯେଉଁ ଯେଉଁ ନଗର ଦେବ, ତହିଁରୁ ଛଅଗୋଟି ଆଶ୍ରୟ ନଗର ହେବ, ନରହତ୍ୟାକାରୀ ସେଠାକୁ ପଳାଇବା ନିମନ୍ତେ ତୁମ୍ଭେମାନେ ତାହା ଦେବ; ଆଉ ତାହା ବ୍ୟତୀତ ଆହୁରି ବୟାଳିଶ ନଗର ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ସର୍ବସୁଦ୍ଧା ତୁମ୍ଭେମାନେ ଲେବୀୟମାନଙ୍କୁ ଅଠଚାଳିଶ ନଗର ଦେବ; ତୁମ୍ଭେମାନେ ସେମାନଙ୍କୁ ନଗର ସଙ୍ଗେ ତହିଁର ତଳିଭୂମି ଦେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ଅଧିକାରରୁ ସେହି ସବୁ ନଗର ଦେବା ନିମନ୍ତେ ତୁମ୍ଭେମାନେ ଅଧିକ ଲୋକଙ୍କଠାରୁ ଅଧିକ ନେବ ଓ ଅଳ୍ପ ଲୋକଙ୍କଠାରୁ ଅଳ୍ପ ନେବ; ପ୍ରତ୍ୟେକ ବଂଶ ଆପଣାର ଅଧିକୃତ ଅଧିକାରାନୁସାରେ ଆପଣା ନଗରମାନଙ୍କରୁ ଲେବୀୟମାନଙ୍କୁ ଦେବେ।” ");
INSERT INTO ory_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ କୁହ, ‘ତୁମ୍ଭେମାନେ ଯର୍ଦ୍ଦନ ପାର ହୋଇ କିଣାନ ଦେଶରେ ଉପସ୍ଥିତ ହେଲେ, ");
INSERT INTO ory_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ଆପଣାମାନଙ୍କର ଆଶ୍ରୟ ନଗର ହେବା ନିମନ୍ତେ କେତେଗୁଡ଼ିଏ ନଗର ନିରୂପଣ କରିବ, ତହିଁରେ ଯେଉଁ ଜନ ଭ୍ରାନ୍ତିରେ କୌଣସି ମନୁଷ୍ୟକୁ ବଧ କରେ, ଏପରି ନରହତ୍ୟାକାରୀ ସେଠାକୁ ପଳାଇ ଯାଇ ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ପୁଣି, ନରହତ୍ୟାକାରୀ ବିଚାରାର୍ଥେ ମଣ୍ଡଳୀ ସମ୍ମୁଖରେ ଉପସ୍ଥିତ ହେବା ପର୍ଯ୍ୟନ୍ତ ଯେପରି ନ ମରେ, ଏଥିପାଇଁ ସେହି ନଗରମାନ ପ୍ରତିହନ୍ତାଠାରୁ ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି ଆଶ୍ରୟ ସ୍ଥାନ ହେବ; ");
INSERT INTO ory_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ଏହିରୂପେ ତୁମ୍ଭେମାନେ ଯେଉଁ ଯେଉଁ ନଗର ଦେବ, ତାହା ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଛଅ ଆଶ୍ରୟ ନଗର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ତୁମ୍ଭେମାନେ ଯର୍ଦ୍ଦନର ପୂର୍ବପାରିରେ ତିନି ନଗର ଦେବ ଓ କିଣାନ ଦେଶ ମଧ୍ୟରେ ତିନି ନଗର ଦେବ; ତାହାସବୁ ଆଶ୍ରୟ ନଗର ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ନିମନ୍ତେ ଓ ସେମାନଙ୍କ ମଧ୍ୟରେ ବିଦେଶୀ ଓ ପ୍ରବାସୀ ନିମନ୍ତେ ସେହି ଛଅ ନଗର ଆଶ୍ରୟ ସ୍ଥାନ ହେବ; ତହିଁରେ ଯେଉଁ ପ୍ରତ୍ୟେକ ଜନ ଭ୍ରାନ୍ତିରେ କୌଣସି ମନୁଷ୍ୟକୁ ବଧ କରେ, ସେ ସେହି ସ୍ଥାନକୁ ପଳାଇ ଯାଇପାରେ। ");
INSERT INTO ory_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","ମାତ୍ର ଯଦି କେହି ଲୌହ ଅସ୍ତ୍ର ଦ୍ୱାରା କାହାରିକୁ ଏପରି ଆଘାତ କରେ ଯେ, ତହିଁରେ ସେ ମରେ, ତେବେ ସେ ନରହତ୍ୟାକାରୀ; ସେହି ନରହତ୍ୟାକାରୀର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ଆଉ ଯାହା ଦ୍ୱାରା ମନୁଷ୍ୟ ମରିପାରେ, ଏପରି ପଥର ହସ୍ତରେ ନେଇ ଯଦି ସେ କାହାକୁ ଆଘାତ କରେ ଓ ତହିଁରେ ସେ ମରେ, ତେବେ ସେ ନରହତ୍ୟାକାରୀ; ସେହି ନରହତ୍ୟାକାରୀର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ଅବା ଯାହା ଦ୍ୱାରା ମନୁଷ୍ୟ ମରିପାରେ, ଏପରି କୌଣସି କାଷ୍ଠ-ଅସ୍ତ୍ର ହସ୍ତରେ ନେଇ ଯଦି ସେ କାହାକୁ ଆଘାତ କରେ ଓ ତହିଁରେ ସେ ମରେ, ତେବେ ସେ ନରହତ୍ୟାକାରୀ; ସେହି ନରହତ୍ୟାକାରୀର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ରକ୍ତର ପ୍ରତିହନ୍ତା ନିଜେ ସେହି ନରହତ୍ୟାକାରୀକୁ ବଧ କରିବ; ସେ ତାହାର ଦେଖା ପାଇଲେ ତାହାକୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ଆଉ ଯଦି ହିଂସା କରି କେହି କାହାକୁ ଧକ୍କା ମାରେ, ଅବା ଛକି ବସି ତାହା ଉପରେ କିଛି ପକାଏ ଓ ତହିଁରେ ସେ ମରେ; ");
INSERT INTO ory_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","କିଅବା ଶତ୍ରୁତା କରି ଯଦି ସେ କାହାକୁ ଆପଣା ହସ୍ତରେ ଆଘାତ କରେ ଓ ତହିଁରେ ସେ ମରେ, ତେବେ ଯେ ତାହାକୁ ଆଘାତ କଲା, ତାହାର ଅବଶ୍ୟ ପ୍ରାଣଦଣ୍ଡ ହେବ; ସେ ନରହତ୍ୟାକାରୀ ରକ୍ତର ପ୍ରତିହନ୍ତା ସେହି ନରହତ୍ୟାକାରୀର ଦେଖା ପାଇଲେ ତାହାକୁ ବଧ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","ମାତ୍ର ଯଦି କେହି ଶତ୍ରୁତା ବିନା ହଠାତ୍‍ କାହାକୁ ଆଘାତ କରେ, ଅବା ଛକି ନ ବସି କାହା ଉପରେ କୌଣସି ଅସ୍ତ୍ର ପକାଏ, ");
INSERT INTO ory_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","କିଅବା ଯାହା ଦ୍ୱାରା ମନୁଷ୍ୟ ମରିପାରେ, ଏପରି କୌଣସି ପଥର କାହାରି ଉପରେ ନ ଦେଖି ପକାଏ ଓ ତହିଁରେ ସେ ମରେ, ଅଥଚ ସେ ତାହାର ଶତ୍ରୁ କି ଅନିଷ୍ଟ ଚେଷ୍ଟାକାରୀ ହୋଇ ନ ଥାଏ, ");
INSERT INTO ory_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ତେବେ ମଣ୍ଡଳୀ ସେହି ବଧକାରୀର ଓ ରକ୍ତର ପ୍ରତିହନ୍ତାର ବିଷୟ ଏହି ଶାସନାନୁସାରେ ବିଚାର କରିବେ। ");
INSERT INTO ory_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ଆଉ ମଣ୍ଡଳୀ ରକ୍ତର ପ୍ରତିହନ୍ତାର ହସ୍ତରୁ ସେହି ନରହତ୍ୟାକାରୀକୁ ଉଦ୍ଧାର କରିବେ; ପୁଣି, ସେ ଯେଉଁ ସ୍ଥାନକୁ ପଳାଇ ଯାଇଥିଲା, ସେହି ଆଶ୍ରୟ ନଗରରେ ମଣ୍ଡଳୀ ପୁନର୍ବାର ତାହାକୁ ପହୁଞ୍ଚାଇ ଦେବେ ଓ ଯେପର୍ଯ୍ୟନ୍ତ ପବିତ୍ର ତୈଳରେ ଅଭିଷିକ୍ତ ମହାଯାଜକର ମୃତ୍ୟୁୁ ନ ହୁଏ, ସେ ପର୍ଯ୍ୟନ୍ତ ସେ ସେହି ସ୍ଥାନରେ ବାସ କରିବ। ");
INSERT INTO ory_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","ମାତ୍ର ସେହି ନରହତ୍ୟାକାରୀ ଯେଉଁ ଆଶ୍ରୟ ନଗରକୁ ପଳାଇଅଛି, ଯଦି କୌଣସି ସମୟରେ ସେ ତହିଁର ସୀମାର ବାହାରକୁ ଯାଏ ");
INSERT INTO ory_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ଓ ରକ୍ତର ପ୍ରତିହନ୍ତା ଆଶ୍ରୟ ନଗର-ସୀମାର ବାହାରେ ତାହାକୁ ପାଏ ଓ ତହିଁର ପ୍ରତିହନ୍ତା ତାହାକୁ ବଧ କରେ, ତେବେ ସେ ରକ୍ତପାତର ଅପରାଧୀ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","କାରଣ ମହାଯାଜକର ମୃତ୍ୟୁୁ ପର୍ଯ୍ୟନ୍ତ ଆପଣା ଆଶ୍ରୟ ନଗରରେ ତାହାର ଥିବା ଉଚିତ; ମାତ୍ର ମହାଯାଜକର ମୃତ୍ୟୁୁ ହେଲା ଉତ୍ତାରେ ସେହି ନରହତ୍ୟାକାରୀ ଆପଣା ଅଧିକାର ଗୃହକୁ ଫେରିଯାଇ ପାରିବ। ");
INSERT INTO ory_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","ଆଉ ତୁମ୍ଭମାନଙ୍କର ପୁରୁଷାନୁକ୍ରମେ ସକଳ ନିବାସ ସ୍ଥାନରେ ଏହିସବୁ ତୁମ୍ଭମାନଙ୍କ ବିଚାରର ବିଧି ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ଯେଉଁ ବ୍ୟକ୍ତି କୌଣସି ଲୋକକୁ ବଧ କରେ, ସେହି ନରହତ୍ୟାକାରୀ ସାକ୍ଷୀମାନଙ୍କ ସାକ୍ଷ୍ୟ ଦ୍ୱାରା ହତ ହେବ; ମାତ୍ର ଏକ ସାକ୍ଷୀର ସାକ୍ଷ୍ୟ କୌଣସି ଲୋକର ପ୍ରତିକୂଳରେ ପ୍ରାଣଦଣ୍ଡ ନିମନ୍ତେ ଗ୍ରାହ୍ୟ ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ଆହୁରି ପ୍ରାଣଦଣ୍ଡ ଯୋଗ୍ୟ ନରହତ୍ୟାକାରୀର ପ୍ରାଣ ନିମନ୍ତେ କୌଣସି ପ୍ରାୟଶ୍ଚିତ୍ତ ଗ୍ରହଣ କରିବ ନାହିଁ; ମାତ୍ର ସେ ଅବଶ୍ୟ ହତ ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ପୁଣି, କେହି ଯେପରି ଆପଣା ଆଶ୍ରୟ ନଗରକୁ ପଳାଇ ପୁନର୍ବାର ଆପଣା ଦେଶକୁ ଆସି ବାସ କରେ, ଏଥିପାଇଁ ତୁମ୍ଭେମାନେ ଯାଜକର ମରଣ ପର୍ଯ୍ୟନ୍ତ ତାହା ନିମନ୍ତେ କୌଣସି ପ୍ରାୟଶ୍ଚିତ୍ତ ଗ୍ରହଣ କରିବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ଏହିରୂପେ ତୁମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ନିବାସ ଦେଶ ଅପବିତ୍ର କରିବ ନାହିଁ; କାରଣ ରକ୍ତ ହିଁ ଦେଶକୁ ଅପବିତ୍ର କରେ; ଆଉ ଦେଶରେ ଯେଉଁ ରକ୍ତପାତ ହୁଏ, ରକ୍ତପାତୀର ରକ୍ତ ବିନା ତହିଁ ନିମନ୍ତେ କୌଣସି ପ୍ରାୟଶ୍ଚିତ୍ତ କରାଯାଇ ନ ପାରେ। ");
INSERT INTO ory_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ଏଣୁ ତୁମ୍ଭମାନଙ୍କର ଯେଉଁ ନିବାସ ଦେଶରେ ଆମ୍ଭେ ବାସ କରୁଅଛୁ, ତୁମ୍ଭେ ତାହା ଅଶୁଚି କରିବ ନାହିଁ; କାରଣ ଆମ୍ଭେ ସଦାପ୍ରଭୁ, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ମଧ୍ୟରେ ବାସ କରୁଅଛୁ।’” ");
INSERT INTO ory_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ଏଥିଉତ୍ତାରେ ଯୋଷେଫ-ସନ୍ତାନଗଣଙ୍କର ବଂଶୀୟ ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ମନଃଶିର ପୌତ୍ର ମାଖୀରର ପୁତ୍ର ଗିଲୀୟଦ ବଂଶୀୟ ପିତୃଗୃହର ପ୍ରଧାନମାନେ ନିକଟକୁ ଆସିଲେ, ପୁଣି, ମୋଶାଙ୍କର ସମ୍ମୁଖରେ ଓ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ପିତୃଗୃହର ପ୍ରଧାନ ସ୍ୱରୂପ ଅଧିପତିବର୍ଗଙ୍କ ସମ୍ମୁଖରେ ପ୍ରସ୍ତାବ କଲେ; ");
INSERT INTO ory_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ଆଉ ସେମାନେ କହିଲେ, “ସଦାପ୍ରଭୁ ଗୁଲିବାଣ୍ଟ ଦ୍ୱାରା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କୁ ଦେଶାଧିକାର ଦେବା ନିମନ୍ତେ ଆମ୍ଭ ପ୍ରଭୁଙ୍କୁ ଆଜ୍ଞା ଦେଲେ; ଆଉ ଆମ୍ଭ ପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ଭ୍ରାତା ସଲଫାଦର ଅଧିକାର ତାହାର କନ୍ୟାମାନଙ୍କୁ ଦେବା ପାଇଁ ସଦାପ୍ରଭୁଙ୍କଠାରୁ ଆଜ୍ଞା ପାଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ମାତ୍ର ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ବଂଶସମୂହର ସନ୍ତାନମାନଙ୍କ ମଧ୍ୟରୁ କାହାରି ସଙ୍ଗେ ଯଦି ସେମାନଙ୍କର ବିବାହ ହୁଏ, ତେବେ ଆମ୍ଭମାନଙ୍କ ପୈତୃକ ଅଧିକାରରୁ ସେମାନଙ୍କ ଅଧିକାର କଟାଯିବ; ପୁଣି, ସେମାନେ ଯେଉଁ ବଂଶରେ ଗୃହୀତ ହେବେ, ସେହି ବଂଶର ଅଧିକାରରେ ତାହା ଯୁକ୍ତ ହେବ; ଏହିରୂପେ ତାହା ଆମ୍ଭମାନଙ୍କ ଅଧିକାରର ଅଂଶରୁ କଟାଯିବ। ");
INSERT INTO ory_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ଆଉ ଯେତେବେଳେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ଯୋବେଲ ଉପସ୍ଥିତ ହେବ, ସେତେବେଳେ ସେମାନେ ଯେଉଁମାନଙ୍କ ମଧ୍ୟରେ ଗୃହୀତା, ସେହି ବଂଶର ଅଧିକାରରେ ସେମାନଙ୍କର ଅଧିକାରଯୁକ୍ତ ହେବ; ଏହିରୂପେ ଆମ୍ଭମାନଙ୍କ ପୈତୃକ ବଂଶରୁ ସେମାନଙ୍କ ଅଧିକାର କଟାଯିବ।” ");
INSERT INTO ory_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ତହିଁରେ ମୋଶା ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ଇସ୍ରାଏଲକୁ ଆଜ୍ଞା ଦେଇ କହିଲେ, “ଯୋଷେଫ-ସନ୍ତାନଗଣଙ୍କର ବଂଶ ଯଥାର୍ଥ କହୁଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ସଦାପ୍ରଭୁ ସଲଫାଦର କନ୍ୟାମାନଙ୍କ ବିଷୟରେ ଏହି ଆଜ୍ଞା ଦେଉଅଛନ୍ତି, ସେମାନେ ଯେଉଁମାନଙ୍କୁ ଅତି ଭଲ ବିଚାର କରନ୍ତି, ‘ସେମାନଙ୍କୁ ବିବାହ ହେଉନ୍ତୁ; କିନ୍ତୁ କେବଳ ସେମାନେ ଆପଣା ପିତୃବଂଶୀୟ କୌଣସି ବଂଶ ମଧ୍ୟରେ ବିବାହ କରିବେ।’ ");
INSERT INTO ory_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ତାହା କଲେ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ଅଧିକାର ଏକ ବଂଶରୁ ଅନ୍ୟ ବଂଶକୁ ଯିବ ନାହିଁ; ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ପୈତୃକ ବଂଶର ଅଧିକାର ମଧ୍ୟରେ ରହିବେ। ");
INSERT INTO ory_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ପୁଣି, ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ପ୍ରତ୍ୟେକେ ଯେପରି ଆପଣା ଆପଣା ପୈତୃକ ଅଧିକାର ଭୋଗ କରିବେ, ଏଥିପାଇଁ ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର କୌଣସି ବଂଶ ମଧ୍ୟରେ ଯେଉଁ କନ୍ୟାର ଅଧିକାର ଥାଏ, ସେ ଆପଣା ପିତୃବଂଶୀୟ ପରିବାର ମଧ୍ୟରେ ଜଣକର ଭାର୍ଯ୍ୟା ହେବ। ");
INSERT INTO ory_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ତହିଁରେ ଏକ ବଂଶରୁ ଅନ୍ୟ ବଂଶକୁ ଅଧିକାର ଯିବ ନାହିଁ; ମାତ୍ର ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କର ବଂଶସମୂହ ପ୍ରତ୍ୟେକେ ଆପଣା ଆପଣା ପୈତୃକ ଅଧିକାର ମଧ୍ୟରେ ରହିବେ।” ");
INSERT INTO ory_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ସଦାପ୍ରଭୁ ମୋଶାଙ୍କୁ ଯେପରି ଆଜ୍ଞା ଦେଲେ, ତଦନୁସାରେ ସଲଫାଦର କନ୍ୟାମାନେ କର୍ମ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ଅର୍ଥାତ୍‍, ମହଲା, ତିର୍ସା, ହଗ୍ଲା, ମିଲ୍କା ଓ ନୋୟା, ସଲଫାଦର ଏହି କନ୍ୟାଗଣ ଆପଣା ଆପଣା ପିତୃବ୍ୟ ପୁତ୍ରମାନଙ୍କ ସହିତ ବିବାହ କଲେ। ");
INSERT INTO ory_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ଯୋଷେଫଙ୍କର ପୁତ୍ର ମନଃଶି ସନ୍ତାନଗଣଙ୍କର ବଂଶ ମଧ୍ୟରେ ସେମାନଙ୍କର ବିବାହ ହେଲା, ତହିଁରେ ସେମାନଙ୍କର ଅଧିକାର ସେମାନଙ୍କ ପିତୃବଂଶୀୟ ବଂଶ ମଧ୍ୟରେ ରହିଲା। ");
INSERT INTO ory_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ସଦାପ୍ରଭୁ ଯିରୀହୋ ନିକଟସ୍ଥ ଯର୍ଦ୍ଦନ ସମୀପରେ ମୋୟାବ-ପଦାରେ ମୋଶାଙ୍କ ଦ୍ୱାରା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣଙ୍କ ପ୍ରତି ଏହି ସମସ୍ତ ଆଜ୍ଞା ଓ ଶାସନ ଆଦେଶ କରିଥିଲେ।");
INSERT INTO ory_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ପାରଣ ଓ ତୋଫଲ ଓ ଲାବନ ଓ ହତ୍ସେରୋତ ଓ ଦୀଷାହବର ମଧ୍ୟସ୍ଥାନରେ ସୂଫ ସମ୍ମୁଖସ୍ଥିତ ପଦାରେ, ଅର୍ଥାତ୍‍, ଯର୍ଦ୍ଦନର ପୂର୍ବପାରିସ୍ଥିତ ପ୍ରାନ୍ତରରେ ମୋଶା ସମୁଦାୟ ଇସ୍ରାଏଲଙ୍କୁ ଏହିସବୁ କଥା କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ସେୟୀର ପର୍ବତ ଦେଇ ହୋରେବଠାରୁ କାଦେଶ-ବର୍ଣ୍ଣେୟ ପର୍ଯ୍ୟନ୍ତ ଏଗାର ଦିନର ଯାତ୍ରା ଅଟେ। ");
INSERT INTO ory_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ସଦାପ୍ରଭୁ ଯେଉଁ ଯେଉଁ କଥା ଇସ୍ରାଏଲ-ସନ୍ତାନଗଣକୁ କହିବା ପାଇଁ ମୋଶାଙ୍କୁ ଆଜ୍ଞା ଦେଇଥିଲେ, ତଦନୁସାରେ ମୋଶା ଚାଳିଶତମ ବର୍ଷର ଏକାଦଶ ମାସର ପ୍ରଥମ ଦିନରେ ସେମାନଙ୍କୁ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","“ହିଷ୍‍ବୋନ ନିବାସୀ ଇମୋରୀୟମାନଙ୍କ ରାଜା ସୀହୋନକୁ ଓ ଅଷ୍ଟାରୋତ୍‍ ନିବାସୀ ବାଶନର ରାଜା ଓଗ୍‍କୁ ଇଦ୍ରିୟୀରେ ସଂହାର କଲା ଉତ୍ତାରେ ");
INSERT INTO ory_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ଯର୍ଦ୍ଦନର ପୂର୍ବପାରସ୍ଥିତ ମୋୟାବ ଦେଶରେ ମୋଶା ଏହି ବ୍ୟବସ୍ଥା ବ୍ୟାଖ୍ୟା କରିବାକୁ ଆରମ୍ଭ କଲେ। ");
INSERT INTO ory_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ହୋରେବରେ ଆମ୍ଭମାନଙ୍କୁ କହିଲେ, ‘ତୁମ୍ଭେମାନେ ଏହି ପର୍ବତରେ ଯଥେଷ୍ଟ କାଳ ବାସ କରିଅଛ; ");
INSERT INTO ory_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ଏବେ ଫେରି ଇମୋରୀୟମାନଙ୍କ ପର୍ବତମୟ ଦେଶ ଓ ତନ୍ନିକଟବର୍ତ୍ତୀ ପଦା ଓ ପର୍ବତ ଓ ତଳଭୂମି ଓ ଦକ୍ଷିଣ ପ୍ରଦେଶ ଓ ସମୁଦ୍ରତୀର ଇତ୍ୟାଦି କିଣାନୀୟମାନଙ୍କ ସମସ୍ତ ଦେଶ ଓ ଲିବାନୋନ ଦେଇ ମହାନଦୀ ଫରାତ୍‍ ପର୍ଯ୍ୟନ୍ତ ଯାତ୍ରା କର। ");
INSERT INTO ory_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ଦେଖ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ଆଗରେ ଏହି ଦେଶ ସମର୍ପଣ କରିଅଛୁ; ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପୂର୍ବପୁରୁଷ ଅବ୍ରହାମଙ୍କୁ ଓ ଇସ୍‌ହାକକୁ ଓ ଯାକୁବକୁ ଓ ସେମାନଙ୍କ ଉତ୍ତାରେ ସେମାନଙ୍କ ବଂଶକୁ ଯେଉଁ ଦେଶ ଦେବା ପାଇଁ ଶପଥ କରିଥିଲେ, ତୁମ୍ଭେମାନେ ସେହି ଦେଶକୁ ଯାଇ ତାହା ଅଧିକାର କର।’” ");
INSERT INTO ory_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ପୁଣି ସେସମୟରେ ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ କହିଲି, “ମୁଁ ଏକାକୀ ତୁମ୍ଭମାନଙ୍କ ଭାର ବହିବାକୁ ଅସମର୍ଥ; ");
INSERT INTO ory_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କର ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କୁ ବୃଦ୍ଧି କରିଅଛନ୍ତି, ଏଣୁ ଦେଖ, ତୁମ୍ଭେମାନେ ଆଜି ଆକାଶର ତାରାଗଣ ତୁଲ୍ୟ ବହୁସଂଖ୍ୟକ ହୋଇଅଛ। ");
INSERT INTO ory_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ତୁମ୍ଭେମାନେ ଏବେ ଯେତେ ଅଛ, ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପୈତୃକ ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କୁ ତହିଁର ସହସ୍ର ଗୁଣ କରନ୍ତୁ ଓ ସେ ଯେରୂପ ତୁମ୍ଭମାନଙ୍କୁ ପ୍ରତିଜ୍ଞା କରିଅଛନ୍ତି, ତଦ୍ରୂପ ତୁମ୍ଭମାନଙ୍କୁ ଆଶୀର୍ବାଦ କରନ୍ତୁ। ");
INSERT INTO ory_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ମୁଁ କିପରି ଏକାକୀ ତୁମ୍ଭମାନଙ୍କର ଏତେ ବୋଝ ଓ ଭାର ଓ ବିବାଦ ସହ୍ୟ କରି ପାରିବି? ");
INSERT INTO ory_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ବଂଶାନୁସାରେ ଜ୍ଞାନୀ ଓ ବୁଦ୍ଧିମାନ ଓ ବିଖ୍ୟାତ ଲୋକମାନଙ୍କୁ ମନୋନୀତ କର, ମୁଁ ସେମାନଙ୍କୁ ତୁମ୍ଭମାନଙ୍କ ଉପରେ ପ୍ରଧାନ ରୂପେ ନିଯୁକ୍ତ କରିବି।” ");
INSERT INTO ory_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ଏଥିରେ ତୁମ୍ଭେମାନେ ମୋତେ ଉତ୍ତର ଦେଇ କହିଲ, “ତୁମ୍ଭେ ଯାହା କହିଲ, ତାହା ଆମ୍ଭମାନଙ୍କର କରିବା ଭଲ।” ");
INSERT INTO ory_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ତହୁଁ ମୁଁ ତୁମ୍ଭମାନଙ୍କ ବଂଶ ଅନୁସାରେ ପ୍ରଧାନ, ଜ୍ଞାନୀ ଓ ବିଖ୍ୟାତ ଲୋକମାନଙ୍କୁ ନେଇ ତୁମ୍ଭମାନଙ୍କ ବଂଶାନୁସାରେ ତୁମ୍ଭମାନଙ୍କ ଉପରେ ପ୍ରଧାନ, ସହସ୍ରପତି, ଶତପତି, ପଚାଶପତି, ଦଶପତି ଓ ଅଧ୍ୟକ୍ଷମାନଙ୍କୁ ନିଯୁକ୍ତ କଲି। ");
INSERT INTO ory_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ପୁଣି ମୁଁ ସେସମୟରେ ତୁମ୍ଭମାନଙ୍କର ବିଚାରକର୍ତ୍ତୃଗଣକୁ ଆଜ୍ଞା ଦେଇ କହିଲି, “ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ଭାଇମାନଙ୍କ ମଧ୍ୟରେ ବିବାଦ ଶୁଣ, ପୁଣି ମନୁଷ୍ୟ ଓ ତାହାର ଭାଇ ଓ ତାହାର ସହବାସୀ ବିଦେଶୀ ମଧ୍ୟରେ ଯଥାର୍ଥ ବିଚାର କର। ");
INSERT INTO ory_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ତୁମ୍ଭେମାନେ ବିଚାରରେ କାହାରି ମୁଖାପେକ୍ଷା କରିବ ନାହିଁ; ତୁମ୍ଭେମାନେ ସାନ ଓ ବଡ଼ ଲୋକର କଥା ସମଭାବରେ ଶୁଣିବ; ତୁମ୍ଭେମାନେ ମନୁଷ୍ୟର ମୁଖକୁ ଭୟ କରିବ ନାହିଁ; କାରଣ ବିଚାର ପରମେଶ୍ୱରଙ୍କର ଅଟେ; ପୁଣି ଯେଉଁ କଥା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି କଠିନ ହୁଏ, ତାହା ତୁମ୍ଭେମାନେ ମୋʼ ନିକଟକୁ ଆଣିବ, ମୁଁ ତାହା ଶୁଣିବି।” ");
INSERT INTO ory_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ପୁଣି ମୁଁ ସେସମୟରେ ତୁମ୍ଭମାନଙ୍କର ସମସ୍ତ କର୍ତ୍ତବ୍ୟ କର୍ମ ବିଷୟ ଆଜ୍ଞା ଦେଇଥିଲି। ");
INSERT INTO ory_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ଏଥିଉତ୍ତାରେ ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାନୁସାରେ ଆମ୍ଭେମାନେ ହୋରେବଠାରୁ ଯାତ୍ରା କଲୁ, ପୁଣି ଇମୋରୀୟମାନଙ୍କ ପର୍ବତମୟ ଦେଶକୁ ଯିବା ପଥରେ ତୁମ୍ଭେମାନେ ଯେଉଁ ବିସ୍ତୀର୍ଣ୍ଣ ଓ ଭୟଙ୍କର ପ୍ରାନ୍ତର ଦେଖିଲ, ତହିଁର ମଧ୍ୟଦେଇ ଯାଇ କାଦେଶ-ବର୍ଣ୍ଣେୟରେ ପହଞ୍ଚିଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ଏଉତ୍ତାରେ ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ କହିଲି, “ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କୁ ଇମୋରୀୟମାନଙ୍କର ଯେଉଁ ପର୍ବତମୟ ଦେଶ ଦେବେ, ସେଠାରେ ତୁମ୍ଭେମାନେ ଉପସ୍ଥିତ ହୋଇଅଛ। ");
INSERT INTO ory_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ଦେଖ, ସଦାପ୍ରଭୁ ତୁମ୍ଭର ପରମେଶ୍ୱର ତୁମ୍ଭ ଆଗରେ ସେହି ଦେଶ ସମର୍ପଣ କରିଅଛନ୍ତି; ସଦାପ୍ରଭୁ ଆପଣା ପୈତୃକ ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାନୁସାରେ ତୁମ୍ଭେ ଯାଇ ତାହା ଅଧିକାର କର; ଭୟ କର ନାହିଁ, କିଅବା ନିରାଶ ହୁଅ ନାହିଁ।” ");
INSERT INTO ory_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ତହିଁରେ ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକେ ଆମ୍ଭ ନିକଟକୁ ଆସି କହିଲ, “ଆମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ଆଗେ ଲୋକ ପଠାଉ, ତହିଁରେ ସେମାନେ ଆମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଦେଶ ଅନୁସନ୍ଧାନ କରି ଆମ୍ଭମାନଙ୍କୁ କେଉଁ ପଥ ଦେଇ ଯିବାକୁ ହେବ ଓ କେଉଁ କେଉଁ ନଗରରେ ଉପସ୍ଥିତ ହେବାକୁ ହେବ, ତହିଁର ସମ୍ବାଦ ଆମ୍ଭମାନଙ୍କ ନିକଟକୁ ଆଣନ୍ତୁ।” ");
INSERT INTO ory_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ତେବେ ଆମ୍ଭେ ଏହି କଥାରେ ସନ୍ତୁଷ୍ଟ ହେଲୁ, ପୁଣି ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କର ପ୍ରତ୍ୟେକ ବଂଶ ନିମନ୍ତେ ଜଣେ ଲେଖାଏଁ ବାର ଜଣଙ୍କୁ ନେଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ତହୁଁ ସେମାନେ ଗମନ କରି ପର୍ବତ ପାର ହୋଇ ଇଷ୍କୋଲ-ଉପତ୍ୟକାରେ ପହଞ୍ଚି ଦେଶର ଅନୁସନ୍ଧାନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ଆଉ ସେମାନେ ହସ୍ତରେ ସେହି ଦେଶର କିଛି କିଛି ଫଳ ଘେନି ଆମ୍ଭମାନଙ୍କ ନିକଟକୁ ଆଣିଲେ ଓ ଆମ୍ଭମାନଙ୍କୁ ସମ୍ବାଦ ଦେଇ କହିଲେ, “ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବେ, ତାହା ଏକ ଉତ୍ତମ ଦେଶ।” ");
INSERT INTO ory_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ତଥାପି ତୁମ୍ଭେମାନେ ଯିବାକୁ ସମ୍ମତ ହେଲ ନାହିଁ, ମାତ୍ର ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କ ଆଜ୍ଞାର ବିଦ୍ରୋହାଚରଣ କଲ। ");
INSERT INTO ory_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ପୁଣି ତୁମ୍ଭେମାନେ ଆପଣା ଆପଣା ତମ୍ବୁରେ ବଚସା କରି କହିଲ, “ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କୁ ଘୃଣା କରିବା ସକାଶୁ ଇମୋରୀୟମାନଙ୍କ ହସ୍ତରେ ସମର୍ପଣ କରି ବିନାଶ କରିବା ନିମନ୍ତେ ଆମ୍ଭମାନଙ୍କୁ ମିସର ଦେଶରୁ ବାହାର କରି ଆଣିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ଆମ୍ଭେମାନେ କେଉଁଠାକୁ ଯିବା? ‘ସେହି ଲୋକମାନେ ଆମ୍ଭମାନଙ୍କ ଅପେକ୍ଷା ଅଧିକ ବଳବାନ ଓ ଉଚ୍ଚ; ନଗରମାନ ବୃହତ ଓ ଗଗନସ୍ପର୍ଶୀ ପ୍ରାଚୀର-ବେଷ୍ଟିତ ଆହୁରି ସେହି ସ୍ଥାନରେ ଆମ୍ଭେମାନେ ଅନାକୀୟମାନଙ୍କ ସନ୍ତାନଗଣକୁ ଦେଖିଅଛୁ, ଏହି କଥା କହି ଆମ୍ଭମାନଙ୍କ ଭ୍ରାତୃଗଣ ଆମ୍ଭମାନଙ୍କର ମନୋଭଙ୍ଗ କରିଅଛନ୍ତି।’” ");
INSERT INTO ory_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ତେବେ ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ କହିଲି, “ଭୟଯୁକ୍ତ ହୁଅ ନାହିଁ, କି ସେମାନଙ୍କ ସକାଶୁ ଭୟ କର ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର, ଯେ ତୁମ୍ଭମାନଙ୍କ ଆଗେ ଆଗେ ଗମନ କରୁଅଛନ୍ତି, ସେ ମିସରରେ ଓ ପ୍ରାନ୍ତରରେ ତୁମ୍ଭମାନଙ୍କ ଦୃଷ୍ଟିଗୋଚରରେ ତୁମ୍ଭମାନଙ୍କ ନିମନ୍ତେ ଯେସମସ୍ତ କାର୍ଯ୍ୟ କଲେ, ତଦନୁସାରେ ସେ ତୁମ୍ଭମାନଙ୍କ ପକ୍ଷରେ ଯୁଦ୍ଧ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ଯେହେତୁ ପ୍ରାନ୍ତରରେ ତୁମ୍ଭେ ଦେଖିଅଛ ଯେ, ମନୁଷ୍ୟ ଆପଣା ପୁତ୍ରକୁ ବହିବା ପରି ସଦାପ୍ରଭୁ ତୁମ୍ଭର ପରମେଶ୍ୱର ଏହି ସ୍ଥାନରେ ପହଞ୍ଚିବା ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭମାନଙ୍କ ଗମନର ସମସ୍ତ ପଥରେ ତୁମ୍ଭକୁ କିପରି ବହିଅଛନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ତଥାପି ଏହି ବିଷୟ ସକାଶେ ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କଠାରେ ବିଶ୍ୱାସ କଲ ନାହିଁ! ");
INSERT INTO ory_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ସେ ତୁମ୍ଭମାନଙ୍କ ଛାଉଣି ସ୍ଥାପନ କରିବାର ସ୍ଥାନ ଅନ୍ୱେଷଣ କରିବା ପାଇଁ ରାତ୍ରିରେ ଅଗ୍ନି ଦ୍ୱାରା ଓ ଦିବସରେ ମେଘ ଦ୍ୱାରା ତୁମ୍ଭମାନଙ୍କର ଗନ୍ତବ୍ୟ ପଥ ଦେଖାଇବାକୁ ପଥରେ ତୁମ୍ଭମାନଙ୍କ ଆଗେ ଆଗେ ଗମନ କଲେ। ");
INSERT INTO ory_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","ପୁଣି ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ବାକ୍ୟର ରବ ଶୁଣି ରାଗିଲେ ଓ ଶପଥ କରି କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବପୁରୁଷମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବାକୁ ଶପଥ କରିଅଛୁ, ନିଶ୍ଚୟ ଏହି ଦୁଷ୍ଟ ବଂଶୀୟ ମନୁଷ୍ୟମାନଙ୍କ ମଧ୍ୟରୁ କୌଣସି ଲୋକ ସେହି ଉତ୍ତମ ଦେଶ ଦେଖି ପାରିବ ନାହିଁ, ");
INSERT INTO ory_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","କେବଳ ଯିଫୁନ୍ନିର ପୁତ୍ର କାଲେବ ତାହା ଦେଖିବ ପୁଣି ସେ ଯେଉଁ ଭୂମିରେ ପଦାର୍ପଣ କରିଅଛି, ସେହି ଭୂମି ଆମ୍ଭେ ତାହାକୁ ଓ ତାହାର ସନ୍ତାନଗଣକୁ ଦେବା; କାରଣ ସେ ସଦାପ୍ରଭୁଙ୍କର ସମ୍ପୂର୍ଣ୍ଣ ଅନୁଗତ ଲୋକ।” ");
INSERT INTO ory_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ଆଉ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ସକାଶୁ ମୋʼ ପ୍ରତି କ୍ରୋଧ କରି କହିଲେ, “ତୁମ୍ଭେ ମଧ୍ୟ ସେହି ସ୍ଥାନରେ ପ୍ରବେଶ କରିବ ନାହିଁ, ");
INSERT INTO ory_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ତୁମ୍ଭର ପରିଚାରକ ନୂନର ପୁତ୍ର ଯିହୋଶୂୟ ସେହି ସ୍ଥାନରେ ପ୍ରବେଶ କରିବ ତୁମ୍ଭେ ତାହାକୁ ସାହସ ଦିଅ ଯେହେତୁ ସେ ଇସ୍ରାଏଲକୁ ତାହା ଅଧିକାର କରାଇବ। ");
INSERT INTO ory_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ଆହୁରି ତୁମ୍ଭମାନଙ୍କର ବାଳକମାନେ, ଯେଉଁମାନେ ଲୁଟିତ ହେବେ ବୋଲି ତୁମ୍ଭେମାନେ କହିଥିଲ ଓ ତୁମ୍ଭମାନଙ୍କର ସନ୍ତାନମାନେ, ଯେଉଁମାନେ ଆଜି ପର୍ଯ୍ୟନ୍ତ ଭଲ ମନ୍ଦର ଜ୍ଞାନ ପାଇ ନାହାନ୍ତି, ସେମାନେ ସେହି ସ୍ଥାନରେ ପ୍ରବେଶ କରିବେ; ପୁଣି ଆମ୍ଭେ ସେମାନଙ୍କୁ ସେହି ଦେଶ ଦେବା ଓ ସେମାନେ ତାହା ଅଧିକାର କରିବେ। ");
INSERT INTO ory_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ମାତ୍ର ତୁମ୍ଭେମାନେ ବାହୁଡ଼ି ସୂଫ ସାଗର ପଥ ଦେଇ ପ୍ରାନ୍ତରକୁ ଯାତ୍ରା କର।” ");
INSERT INTO ory_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ଏଥିରେ ତୁମ୍ଭେମାନେ ଉତ୍ତର କରି ମୋତେ କହିଲ, “ଆମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ବିରୁଦ୍ଧରେ ପାପ କରିଅଛୁ; ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କୁ ଯେଉଁ ସମସ୍ତ ଆଜ୍ଞା ଦେଇଅଛନ୍ତି, ଆମ୍ଭେମାନେ ତଦନୁସାରେ ଉଠିଯାଇ ଯୁଦ୍ଧ କରିବୁ।” ପୁଣି ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକ ଜଣ ଆପଣା ଆପଣା ଯୁଦ୍ଧାସ୍ତ୍ର ବାନ୍ଧି ପର୍ବତ ଆରୋହଣ କରିବାକୁ ବ୍ୟଗ୍ର ହେଲ। ");
INSERT INTO ory_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ସେତେବେଳେ ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, “ସେମାନଙ୍କୁ କୁହ, ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟବର୍ତ୍ତୀ ନାହୁଁ, ‘ଏଣୁ ତୁମ୍ଭେମାନେ ଆରୋହଣ କର ନାହିଁ, କିଅବା ଯୁଦ୍ଧ କର ନାହିଁ;’ କଲେ ଶତ୍ରୁମାନଙ୍କ ସମ୍ମୁଖରେ ଆହତ ହେବ।” ");
INSERT INTO ory_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ତହୁଁ ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ ସେହି କଥା କହିଲି, ପୁଣି ତୁମ୍ଭେମାନେ ଶୁଣିଲ ନାହିଁ; ମାତ୍ର ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁଙ୍କ ଆଜ୍ଞାର ବିଦ୍ରୋହାଚରଣ କଲ ଓ ଦୁଃସାହସୀ ହେଲ, ଆଉ ପର୍ବତ ଦେଶକୁ ଆକ୍ରମଣ କଲ। ");
INSERT INTO ory_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","କିନ୍ତୁ ସେହି ପର୍ବତବାସୀ ଇମୋରୀୟ ଲୋକମାନେ ତୁମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ବାହାର ହୋଇ ମହୁମାଛି ପରି ତୁମ୍ଭମାନଙ୍କୁ ତଡ଼ି ସେୟୀରରେ ହର୍ମା ପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭମାନଙ୍କୁ ପରାସ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ତେବେ ତୁମ୍ଭେମାନେ ଫେରିଆସି ସଦାପ୍ରଭୁଙ୍କ ଛାମୁରେ ରୋଦନ କଲ; ମାତ୍ର ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ରବରେ ମନୋଯୋଗ କଲେ ନାହିଁ, କିଅବା ତୁମ୍ଭମାନଙ୍କ ପ୍ରତି କର୍ଣ୍ଣପାତ କଲେ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ତହିଁରେ ତୁମ୍ଭେମାନେ କାଦେଶରେ ବାସ କରି ସେହି ସ୍ଥାନରେ ବହୁ ବର୍ଷ ରହିଲ। ");
INSERT INTO ory_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ଏଥିଉତ୍ତାରେ ମୋʼ ପ୍ରତି କଥିତ ସଦାପ୍ରଭୁଙ୍କ ବାକ୍ୟାନୁସାରେ ଆମ୍ଭେମାନେ ଫେରି ସୂଫ ସାଗର ପଥ ଦେଇ ପ୍ରାନ୍ତର ଆଡ଼େ ଯାତ୍ରା କଲୁ; ପୁଣି ସେୟୀର ପର୍ବତ ବୁଲି ଆସିବାକୁ ଆମ୍ଭମାନଙ୍କୁ ଅନେକ ଦିନ ଲାଗିଲା। ");
INSERT INTO ory_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ତହୁଁ ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“ତୁମ୍ଭେମାନେ ଯଥେଷ୍ଟ ସମୟ ଏହି ପର୍ବତ ବୁଲିଅଛ; ଏବେ ଉତ୍ତର ଦିଗକୁ ଫେର। ");
INSERT INTO ory_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ତୁମ୍ଭେ ଲୋକମାନଙ୍କୁ ଏହି ଆଜ୍ଞା ଦିଅ, ‘ସେୟୀର ନିବାସୀ ତୁମ୍ଭମାନଙ୍କ ଭ୍ରାତୃଗଣର, ଅର୍ଥାତ୍‍, ଏଷୌ ସନ୍ତାନଗଣର ସୀମା ଦେଇ ତୁମ୍ଭମାନଙ୍କୁ ଯିବାକୁ ହେବ; ତହିଁରେ ସେମାନେ ଭୀତ ହେବେ; ଏଣୁ ତୁମ୍ଭେମାନେ ଅତି ସାବଧାନ ହୁଅ। ");
INSERT INTO ory_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ସେମାନଙ୍କ ସହିତ ଯୁଦ୍ଧ କର ନାହିଁ; କାରଣ ଆମ୍ଭେ ତୁମ୍ଭମାନଙ୍କୁ ସେମାନଙ୍କ ଦେଶରୁ କିଛି ଦେବା ନାହିଁ। ଏକ ପାଦ ପରିମିତ ଭୂମି ହିଁ ଦେବା ନାହିଁ; ଯେହେତୁ ଆମ୍ଭେ ଏଷୌକୁ ଅଧିକାରାର୍ଥେ ସେୟୀର ପର୍ବତ ଦେଇଅଛୁ। ");
INSERT INTO ory_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ତୁମ୍ଭେମାନେ ରୂପା (ଟଙ୍କା) ଦେଇ ସେମାନଙ୍କଠାରୁ ଅନ୍ନ କିଣି ଭୋଜନ କରିବ ଓ ରୂପା ଦେଇ ଜଳ କିଣି ପାନ କରିବ। ");
INSERT INTO ory_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","କାରଣ ସଦାପ୍ରଭୁ ତୁମ୍ଭର ପରମେଶ୍ୱର ତୁମ୍ଭ ହସ୍ତର ସମସ୍ତ କର୍ମରେ ତୁମ୍ଭଙ୍କୁ ଆଶୀର୍ବାଦ କରିଅଛନ୍ତି; ସେ ଏହି ବିସ୍ତୀର୍ଣ୍ଣ ପ୍ରାନ୍ତରରେ ତୁମ୍ଭ ଯିବାର ଜାଣିଅଛନ୍ତି; ଏହି ଚାଳିଶ ବର୍ଷସାରା ସଦାପ୍ରଭୁ ତୁମ୍ଭର ପରମେଶ୍ୱର ତୁମ୍ଭର ସହବର୍ତ୍ତୀ ହୋଇଅଛନ୍ତି; ତୁମ୍ଭର କିଛି ଅଭାବ ହୋଇ ନାହିଁ।’” ");
INSERT INTO ory_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ଏଉତ୍ତାରେ ଆମ୍ଭେମାନେ ସେୟୀର ନିବାସୀ ଆପଣା ଭ୍ରାତୃଗଣ ଏଷୌ-ସନ୍ତାନମାନଙ୍କ ନିକଟ ଦେଇ ଏଲତ୍‍ ଓ ଇତ୍‍ସିୟୋନ-ଗେବର ପଦାଭୂମିର ପଥଠାରୁ ଯାତ୍ରା କଲୁ। ତହୁଁ ଆମ୍ଭେମାନେ ଫେରି ମୋୟାବ-ପ୍ରାନ୍ତର ପଥ ଦେଇ ଯାତ୍ରା କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ତହିଁରେ ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, “ମୋୟାବକୁ କ୍ଳେଶ ଦିଅ ନାହିଁ, ଅବା ସେମାନଙ୍କ ସହିତ ଯୁଦ୍ଧ କର ନାହିଁ; କାରଣ ଆମ୍ଭେ ତୁମ୍ଭକୁ ଅଧିକାରାର୍ଥେ ସେମାନଙ୍କ ଦେଶରୁ କିଛି ଦେବା ନାହିଁ; ଯେହେତୁ ଆମ୍ଭେ ଲୋଟର ସନ୍ତାନଗଣକୁ ଆର ନଗର ଅଧିକାରାର୍ଥେ ଦେଇଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(ପୂର୍ବେ ସେହି ସ୍ଥାନରେ ଏମୀୟ ଲୋକମାନେ ବାସ କରୁଥିଲେ, ସେମାନେ ବଳବାନ ଓ ଅନେକ ଓ ଅନାକୀୟମାନଙ୍କ ପରି ଉଚ୍ଚ ଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ଅନାକୀୟମାନଙ୍କ ତୁଲ୍ୟ ସେମାନେ ମଧ୍ୟ ରଫାୟୀୟମାନଙ୍କ ମଧ୍ୟରେ ଗଣିତ ଥିଲେ, ମାତ୍ର ମୋୟାବୀୟ ଲୋକମାନେ ସେମାନଙ୍କୁ ଏମୀୟ ବୋଲି କହିଲେ। ");
INSERT INTO ory_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ପୁଣି ପୂର୍ବେ ହୋରୀୟ ଲୋକମାନେ ସେୟୀରରେ ବାସ କଲେ, ମାତ୍ର ଏଷୌର ସନ୍ତାନଗଣ ସେମାନଙ୍କୁ ଅଧିକାରଚ୍ୟୁତ କଲେ ଓ ଆପଣାମାନଙ୍କ ସମ୍ମୁଖରୁ ସେମାନଙ୍କୁ ବିନଷ୍ଟ କରି ସେମାନଙ୍କ ସ୍ଥାନରେ ବାସ କଲେ; ଯେରୂପେ ଇସ୍ରାଏଲ ସଦାପ୍ରଭୁଙ୍କ ଦତ୍ତ ଆପଣା ଅଧିକାର-ଭୂମିରେ କଲେ)। ");
INSERT INTO ory_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“ଏବେ ତୁମ୍ଭେମାନେ ଉଠ ଓ ସେରଦ୍‍ ନଦୀ ପାର ହୁଅ।” ତହିଁରେ ଆମ୍ଭେମାନେ ସେରଦ୍‍ ନଦୀ ପାର ହେଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","କାଦେଶ-ବର୍ଣ୍ଣେୟଠାରୁ ସେରଦ୍‍ ନଦୀ ପାର ହେବା ପର୍ଯ୍ୟନ୍ତ ଆମ୍ଭମାନଙ୍କୁ ଅଠତିରିଶି ବର୍ଷ ଲାଗିଲା, ସେହି ସମୟରେ ସଦାପ୍ରଭୁଙ୍କ ଶପଥ ଅନୁସାରେ ଛାଉଣି ମଧ୍ୟରୁ ସେହି ପୁରୁଷର ସମସ୍ତ ଯୋଦ୍ଧା ଉଚ୍ଛିନ୍ନ ହୋଇଥିଲେ। ");
INSERT INTO ory_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","କାରଣ ଛାଉଣି ମଧ୍ୟରୁ ସେମାନଙ୍କୁ ସମ୍ପୂର୍ଣ୍ଣ ଲୋପ କରିବା ପାଇଁ ସେମାନଙ୍କ ପ୍ରତିକୂଳରେ ସଦାପ୍ରଭୁଙ୍କ ହସ୍ତ ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ଏହିରୂପେ ସେହି ସମସ୍ତ ଯୋଦ୍ଧା ମରି ଲୋକମାନଙ୍କ ମଧ୍ୟରୁ ଉଚ୍ଛିନ୍ନ ହେଲା ଉତ୍ତାରେ ");
INSERT INTO ory_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, ");
INSERT INTO ory_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“ଆଜି ତୁମ୍ଭକୁ ମୋୟାବର ସୀମା ଆର ଦେଇ ଯିବାକୁ ହେବ; ");
INSERT INTO ory_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ପୁଣି ତୁମ୍ଭେ ଅମ୍ମୋନ-ସନ୍ତାନଗଣର ସମ୍ମୁଖରେ ଉପସ୍ଥିତ ହେଲେ ସେମାନଙ୍କୁ କ୍ଳେଶ ଦିଅ ନାହିଁ, କି ସେମାନଙ୍କ ସଙ୍ଗେ ଯୁଦ୍ଧ କର ନାହିଁ, କାରଣ ଆମ୍ଭେ ଅଧିକାରାର୍ଥେ ତୁମ୍ଭକୁ ଅମ୍ମୋନ-ସନ୍ତାନଗଣର ଦେଶରୁ କିଛି ଦେବା ନାହିଁ; ଯେହେତୁ ଆମ୍ଭେ ଲୋଟର ସନ୍ତାନଗଣକୁ ତାହା ଅଧିକାର କରିବା ପାଇଁ ଦେଇଅଛୁ।” ");
INSERT INTO ory_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(ସେହି ଦେଶ ମଧ୍ୟ ରଫାୟୀୟମାନଙ୍କ ଦେଶ ବୋଲି ଗଣିତ; ପୂର୍ବେ ରଫାୟୀୟମାନେ ସେଠାରେ ବାସ କରୁଥିଲେ; ମାତ୍ର ଅମ୍ମୋନୀୟମାନେ ସେମାନଙ୍କୁ ସମ୍ସୁମ୍ମୀୟ ବୋଲି କହିଲେ; ");
INSERT INTO ory_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ସେମାନେ ବଳବାନ ଓ ଅନେକ ଓ ଅନାକୀୟମାନଙ୍କ ପରି ଉଚ୍ଚ ଲୋକ ଥିଲେ; ମାତ୍ର ସଦାପ୍ରଭୁ ଅମ୍ମୋନୀୟମାନଙ୍କ ସମ୍ମୁଖରୁ ସେମାନଙ୍କୁ ବିନଷ୍ଟ କଲେ; ପୁଣି ସେମାନେ ସେମାନଙ୍କୁ ଅଧିକାରଚ୍ୟୁତ କରି ସେମାନଙ୍କ ସ୍ଥାନରେ ବସତି କଲେ। ");
INSERT INTO ory_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ସେ ସେୟୀର ନିବାସୀ ଏଷୌ-ସନ୍ତାନଗଣ ନିମନ୍ତେ ସେହିରୂପ କର୍ମ କରିଥିଲେ, ଅର୍ଥାତ୍‍, ସେମାନଙ୍କ ସମ୍ମୁଖରୁ ହୋରୀୟମାନଙ୍କୁ ବିନଷ୍ଟ କଲେ, ତହିଁରେ ଏଷୌ-ସନ୍ତାନଗଣ ସେମାନଙ୍କୁ ଅଧିକାରଚ୍ୟୁତ କରି ଆଜି ପର୍ଯ୍ୟନ୍ତ ସେମାନଙ୍କ ସ୍ଥାନରେ ବାସ କରୁଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ପୁଣି କପ୍ତୋରରୁ ଆଗତ କପ୍ତୋରୀୟ ଲୋକମାନେ ଘସା ପର୍ଯ୍ୟନ୍ତ ଗ୍ରାମମାନଙ୍କରେ ବାସକାରୀ ଅବ୍ବୀୟମାନଙ୍କୁ ବିନଷ୍ଟ କରି ସେମାନଙ୍କ ସ୍ଥାନରେ ବାସ କଲେ)। ");
INSERT INTO ory_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“ତୁମ୍ଭେମାନେ ଉଠ ଓ ଯାତ୍ରା କରି ଅର୍ଣ୍ଣୋନ-ଉପତ୍ୟକା ପାର ହୁଅ; ଦେଖ, ଆମ୍ଭେ ହିଷ୍‍ବୋନର ରାଜା ଇମୋରୀୟ ସୀହୋନକୁ ଓ ତାହାର ଦେଶକୁ ତୁମ୍ଭ ହସ୍ତରେ ସମର୍ପଣ କରିଅଛୁ; ତାହା ଅଧିକାର କରିବାକୁ ଆରମ୍ଭ କର ଓ ତାହା ସଙ୍ଗେ ଯୁଦ୍ଧ କର। ");
INSERT INTO ory_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ଆଜି ଆମ୍ଭେ ସମସ୍ତ ଆକାଶମଣ୍ଡଳର ଅଧଃସ୍ଥିତ ଲୋକମାନଙ୍କ ମନରେ ତୁମ୍ଭ ବିଷୟକ ଆଶଙ୍କା ଓ ଭୟ ଜନ୍ମାଇବାକୁ ଆରମ୍ଭ କରିବା, ସେମାନେ ତୁମ୍ଭ ବିଷୟର ସମ୍ବାଦ ଶୁଣିଲେ ତୁମ୍ଭ ସକାଶୁ କମ୍ପିତ ଓ ବ୍ୟଥିତ ହେବେ।” ");
INSERT INTO ory_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ଆଉ ମୁଁ କଦେମୋତ୍‍ ପ୍ରାନ୍ତରରୁ ହିଷ୍‍ବୋନର ରାଜା ସୀହୋନ ନିକଟକୁ ବାର୍ତ୍ତାବହମାନଙ୍କ ଦ୍ୱାରା ଏହି ଶାନ୍ତି ସୂଚକ ବାକ୍ୟ କହି ପଠାଇଲି, ");
INSERT INTO ory_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“ତୁମ୍ଭ ଦେଶ ଦେଇ ମୋତେ ଯିବାକୁ ଦିଅ, ମୁଁ ବାଟେ ବାଟେ ଯିବି, ଦକ୍ଷିଣରେ କି ବାମରେ ଫେରିବି ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ସେୟୀର ନିବାସୀ ଏଷୌ-ସନ୍ତାନଗଣ ଓ ଆର ନିବାସୀ ମୋୟାବୀୟ ଲୋକମାନେ ମୋʼ ପ୍ରତି ଯେରୂପ କଲେ, ତଦ୍ରୂପ ତୁମ୍ଭେ କର; ");
INSERT INTO ory_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେଉଅଛନ୍ତି, ଆମ୍ଭେମାନେ ଯର୍ଦ୍ଦନ ପାର ହୋଇ ଯେପର୍ଯ୍ୟନ୍ତ ସେହି ଦେଶରେ ଉପସ୍ଥିତ ନ ହେଉ, ସେପର୍ଯ୍ୟନ୍ତ ତୁମ୍ଭେ ରୂପା ନେଇ ମୋତେ ଭୋଜନର ଅନ୍ନ ଦିଅ ଓ ରୂପା ନେଇ ପିଇବାର ଜଳ ଦିଅ ମୁଁ କେବଳ ଆପଣା ପାଦ ଦେଇ ପାର ହୋଇଯିବି।” ");
INSERT INTO ory_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ମାତ୍ର ହିଷ୍‍ବୋନର ରାଜା ସୀହୋନ ଆପଣା ଦେଶ ମଧ୍ୟଦେଇ ଯିବା ପାଇଁ ଆମ୍ଭମାନଙ୍କୁ ଅନୁମତି ଦେଲା ନାହିଁ, କାରଣ ସଦାପ୍ରଭୁ ତୁମ୍ଭର ପରମେଶ୍ୱର ତୁମ୍ଭ ହସ୍ତରେ ଆଜିର ନ୍ୟାୟ ତାହାକୁ ସମର୍ପଣ କରିବା ପାଇଁ ତାହାର ମନ କଠିନ କଲେ ଓ ତାହାର ହୃଦୟ ଶକ୍ତ କଲେ। ");
INSERT INTO ory_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ପୁଣି ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, “ଦେଖ, ଆମ୍ଭେ ସୀହୋନକୁ ଓ ତାହାର ଦେଶକୁ ତୁମ୍ଭ ଆଗରେ ସମର୍ପଣ କରିବାକୁ ପ୍ରବୃତ୍ତ ହେଲୁଣି ତୁମ୍ଭେ ତାହାର ଦେଶ ଅଧିକାର କରିବାକୁ ପ୍ରବୃତ୍ତ ହୁଅ।” ");
INSERT INTO ory_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ସେତେବେଳେ ସୀହୋନ, ସେ ଓ ତାହାର ସମସ୍ତ ପ୍ରଜା ଆମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ବାହାରି ଯହସରେ ଯୁଦ୍ଧ କରିବାକୁ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ତେବେ ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କ ଆଗରେ ତାହାକୁ ସମର୍ପଣ କଲେ; ତହିଁରେ ଆମ୍ଭେମାନେ ତାହାକୁ ଓ ତାହାର ପୁତ୍ରଗଣକୁ ଓ ତାହାର ସମସ୍ତ ପ୍ରଜାଙ୍କୁ ବଧ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ଆଉ ସେହି ସମୟରେ ଆମ୍ଭେମାନେ ତାହାର ସମସ୍ତ ନଗର ହସ୍ତଗତ କରି ସ୍ତ୍ରୀ ଓ ବାଳକ ସମେତ ପ୍ରତ୍ୟେକ ବସତି-ନଗର ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ବିନଷ୍ଟ କଲୁ; ଆମ୍ଭେମାନେ କାହାକୁ ହିଁ ବଞ୍ଚାଇ ରଖିଲୁ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","କେବଳ ପଶୁଗଣକୁ ଓ ଯେ ଯେ ନଗର ହସ୍ତଗତ କରିଥିଲୁ, ତହିଁର ଲୁଟିତ ଦ୍ରବ୍ୟସବୁକୁ ଆମ୍ଭେମାନେ ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଗ୍ରହଣ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ଅର୍ଣ୍ଣୋନ-ଉପତ୍ୟକା ନିକଟସ୍ଥ ଅରୋୟେରଠାରୁ ଓ ଉପତ୍ୟକାର ମଧ୍ୟବର୍ତ୍ତୀ ନଗରଠାରୁ ଗିଲୀୟଦ ପର୍ଯ୍ୟନ୍ତ ଏକ ନଗର ହିଁ ଆମ୍ଭମାନଙ୍କ ଶକ୍ତିର ଅତିରିକ୍ତ ନ ଥିଲା; ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଆମ୍ଭମାନଙ୍କ ଆଗରେ ସମଗ୍ର ସମର୍ପଣ କଲେ। ");
INSERT INTO ory_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","କେବଳ ଅମ୍ମୋନ-ସନ୍ତାନମାନଙ୍କ ଦେଶ, ଅର୍ଥାତ୍‍, ଯବ୍ବୋକ୍‍ ନଦୀର ପାର୍ଶ୍ୱସ୍ଥ ପ୍ରଦେଶ ଓ ପର୍ବତମୟ ସକଳ ନଗର ପ୍ରଭୃତି ଯେଉଁ ଦେଶ ବିଷୟରେ ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ନିଷେଧ କରିଥିଲେ; ତହିଁ ନିକଟରେ ତୁମ୍ଭେ ଉପସ୍ଥିତ ହେଲ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ଏଉତ୍ତାରେ ଆମ୍ଭେମାନେ ଫେରି ବାଶନର ପଥ ଦେଇ ଗମନ କଲୁ; ତହିଁରେ ବାଶନର ରାଜା ଓଗ୍‍ ଅାସି ଅାକ୍ରମଣ କଲେ, ପୁଣି ସେ ଓ ତାହାର ସମସ୍ତ ପ୍ରଜା ଆମ୍ଭମାନଙ୍କ ବିରୁଦ୍ଧରେ ଯୁଦ୍ଧ କରିବାକୁ ବାହାରି ଇଦ୍ରିୟୀକୁ ଆସିଲେ। ");
INSERT INTO ory_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ସେତେବେଳେ ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, “ତାହାକୁ ଭୟ କର ନାହିଁ; କାରଣ ଆମ୍ଭେ ତାହାକୁ ଓ ତାହାର ସମସ୍ତ ପ୍ରଜାଙ୍କୁ ଓ ତାହାର ଦେଶକୁ ତୁମ୍ଭ ହସ୍ତରେ ସମର୍ପଣ କରିଅଛୁ; ତୁମ୍ଭେ ଯେପରି ହିଷ୍‍ବୋନ ନିବାସୀ ଇମୋରୀୟମାନଙ୍କ ରାଜା ସୀହୋନ ପ୍ରତି କରିଅଛ, ସେପରି ତାହା ପ୍ରତି ମଧ୍ୟ କରିବ।” ");
INSERT INTO ory_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ଏହିରୂପେ ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ମଧ୍ୟ ବାଶନ-ରାଜା ଓଗ୍‍କୁ ଓ ତାହାର ସମସ୍ତ ପ୍ରଜାଙ୍କୁ ଆମ୍ଭମାନଙ୍କ ହସ୍ତରେ ସମର୍ପଣ କଲେ; ତହିଁରେ ଆମ୍ଭେମାନେ ତାହାକୁ ଏପରି ପରାଜୟ କଲୁ ଯେ, ତାହାର କେହି ଅବଶିଷ୍ଟ ରହିଲା ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ସେସମୟରେ ଆମ୍ଭେମାନେ ତାହାର ସମସ୍ତ ନଗର ହସ୍ତଗତ କଲୁ, ସେମାନଙ୍କଠାରୁ ଯାହା ହସ୍ତଗତ ନ କଲୁ, ଏପରି ଗୋଟିଏ ନଗର ରହିଲା ନାହିଁ; ଷାଠିଏ ନଗର, ଅର୍ଗୋବର ସମସ୍ତ ଅଞ୍ଚଳ, ଅର୍ଥାତ୍‍, ବାଶନସ୍ଥ ଓଗ୍‍ର ରାଜ୍ୟ (ହସ୍ତଗତ କଲୁ)। ");
INSERT INTO ory_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ସେହି ସବୁ ନଗର ଉଚ୍ଚ ପ୍ରାଚୀର ଓ ଦ୍ୱାର ଓ ଅର୍ଗଳରେ ସୁରକ୍ଷିତ ଥିଲା; ତାହା ଛଡ଼ା ଅନେକ ପ୍ରାଚୀରହୀନ ନଗର ଥିଲା। ");
INSERT INTO ory_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ଆମ୍ଭେମାନେ ହିଷ୍‍ବୋନ-ରାଜା ସୀହୋନ ପ୍ରତି ଯେରୂପ କରିଥିଲୁ, ସେରୂପ ସେମାନଙ୍କୁ ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ବିନଷ୍ଟ କଲୁ, ସ୍ତ୍ରୀ ଓ ବାଳକ ସମେତ ପ୍ରତ୍ୟେକ ବସତି-ନଗର ସମ୍ପୂର୍ଣ୍ଣ ରୂପେ ବିନଷ୍ଟ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ମାତ୍ର ଆମ୍ଭେମାନେ ସମସ୍ତ ପଶୁ ଓ ନଗରର ଲୁଟିତ ଦ୍ରବ୍ୟାଦି ଆପଣାମାନଙ୍କ ନିମନ୍ତେ ଲୁଟ ସ୍ୱରୂପେ ଗ୍ରହଣ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ସେହି ସମୟରେ ଆମ୍ଭେମାନେ ଯର୍ଦ୍ଦନର ପୂର୍ବପାରିସ୍ଥ ଇମୋରୀୟମାନଙ୍କ ଦୁଇ ରାଜାଙ୍କର ହସ୍ତରୁ ଅର୍ଣ୍ଣୋନ-ଉପତ୍ୟକାଠାରୁ ହର୍ମୋଣ ପର୍ବତ ପର୍ଯ୍ୟନ୍ତ ସମସ୍ତ ଦେଶ ହସ୍ତଗତ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(ସୀଦୋନୀୟମାନେ ସେହି ହର୍ମୋଣ ପର୍ବତକୁ ସିରିୟୋନ କହନ୍ତି ଓ ଇମୋରୀୟମାନେ ତାହାକୁ ସନୀର୍‍ କହନ୍ତି)। ");
INSERT INTO ory_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ଆମ୍ଭେମାନେ ସମଭୂମିର ସମସ୍ତ ନଗର ଓ ସଲଖା ଓ ଇଦ୍ରିୟୀ ପର୍ଯ୍ୟନ୍ତ ସମସ୍ତ ଗିଲୀୟଦ ଓ ସମସ୍ତ ବାଶନ, ଅର୍ଥାତ୍‍, ବାଶନସ୍ଥିତ ଓଗ୍‍ ରାଜ୍ୟର ସମସ୍ତ ନଗର ହସ୍ତଗତ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(ଅବଶିଷ୍ଟ ରଫାୟୀୟମାନଙ୍କ ମଧ୍ୟରୁ କେବଳ ବାଶନ-ରାଜା ଓଗ୍‍ ଅବଶିଷ୍ଟ ରହିଲା, ଦେଖ, ତାହାର ଖଟ ଲୌହମୟ ଖଟ; ତାହା କି ଅମ୍ମୋନ-ସନ୍ତାନଗଣର ରବ୍ବାରେ ନାହିଁ? ମନୁଷ୍ୟ ହସ୍ତର ପରିମାଣାନୁସାରେ ତାହା ଲମ୍ବାରେ ନଅ ହାତ ଓ ଓସାରରେ ଚାରି ହାତ)। ");
INSERT INTO ory_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ଏହି ସମୟରେ ଆମ୍ଭେମାନେ ଅର୍ଣ୍ଣୋନ-ଉପତ୍ୟକା ନିକଟସ୍ଥ ଅରୋୟେରଠାରୁ ସେହି ସମସ୍ତ ଦେଶ ଅଧିକାର କଲୁ; ତହିଁରେ ମୁଁ ଗିଲୀୟଦର ପର୍ବତମୟ ଦେଶର ଅର୍ଦ୍ଧେକ ଓ ତହିଁର ନଗରସବୁ ରୁବେନୀୟମାନଙ୍କୁ ଓ ଗାଦୀୟମାନଙ୍କୁ ଦେଲି। ");
INSERT INTO ory_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ପୁଣି ମୁଁ ଗିଲୀୟଦର ଅବଶିଷ୍ଟ ଅଂଶ ଓ ସମସ୍ତ ବାଶନ, ଅର୍ଥାତ୍‍, ଓଗ୍‍ର ରାଜ୍ୟ, ବିଶେଷରେ ସମୁଦାୟ ବାଶନ ସହିତ ଅର୍ଗୋବର ସମସ୍ତ ଅଞ୍ଚଳ ମନଃଶିର ଅର୍ଦ୍ଧ ବଂଶକୁ ଦେଲି (ତାହା ରଫାୟୀୟ ଦେଶ ବୋଲି ବିଖ୍ୟାତ। ");
INSERT INTO ory_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ମନଃଶିର ପୁତ୍ର ଯାୟୀର, ଗଶୂରୀୟ ଓ ମାଖାଥୀୟ ସୀମା ପର୍ଯ୍ୟନ୍ତ ଅର୍ଗୋବର ସମସ୍ତ ଅଞ୍ଚଳ ହସ୍ତଗତ କରି ଆପଣା ନାମାନୁସାରେ ଆଜି ପର୍ଯ୍ୟନ୍ତ ବାଶନ ଦେଶର ସେହି ସମସ୍ତ ସ୍ଥାନର ନାମ ହବୋତ୍‍-ଯାୟୀର ରଖିଲା)। ");
INSERT INTO ory_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ପୁଣି ମୁଁ ମାଖୀରକୁ ଗିଲୀୟଦ ଦେଲି। ");
INSERT INTO ory_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ଆଉ ଗିଲୀୟଦଠାରୁ ଅର୍ଣ୍ଣୋନ-ଉପତ୍ୟକା, ଅର୍ଥାତ୍‍, ଉପତ୍ୟକାର ମଧ୍ୟସ୍ଥାନ ଓ ତହିଁର ସୀମା ସମେତ, ପୁଣି ସେହିଠାରୁ ଅମ୍ମୋନ-ସନ୍ତାନଗଣର ସୀମା ଯବ୍ବୋକ୍‍ ନଦୀ ପର୍ଯ୍ୟନ୍ତ; ");
INSERT INTO ory_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ଆଉ କିନ୍ନେରତ୍‍ଠାରୁ ପାଦଭୂମିସ୍ଥ ସମୁଦ୍ର, ଅର୍ଥାତ୍‍, ପିସ୍ଗାର ଅଧଃସ୍ଥିତ ଲବଣ ସମୁଦ୍ର ପର୍ଯ୍ୟନ୍ତ ପୂର୍ବ ଦିଗବର୍ତ୍ତୀ ପଦାଭୂମି ଓ ଯର୍ଦ୍ଦନ ଓ ତହିଁର ଅଞ୍ଚଳ ରୁବେନୀୟ ଓ ଗାଦୀୟ ଲୋକମାନଙ୍କୁ ଦେଲି। ");
INSERT INTO ory_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ଏଥିଉତ୍ତାରେ ମୁଁ ସେହି ସମୟରେ ତୁମ୍ଭମାନଙ୍କୁ ଆଜ୍ଞା ଦେଇ କହିଲି, “ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଅଧିକାରାର୍ଥେ ତୁମ୍ଭମାନଙ୍କୁ ଏହି ଦେଶ ଦେଇଅଛନ୍ତି; ତୁମ୍ଭମାନଙ୍କ ମଧ୍ୟରୁ ସମସ୍ତ ବୀରପୁରୁଷ ସସଜ୍ଜ ହୋଇ ତୁମ୍ଭମାନଙ୍କ ଭ୍ରାତୃଗଣ ଇସ୍ରାଏଲ ସନ୍ତାନମାନଙ୍କ ସମ୍ମୁଖରେ ପାର ହୋଇଯିବେ। ");
INSERT INTO ory_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ମାତ୍ର ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଯେଉଁ ନଗର ଦେଇଅଛି, ସେହି ସବୁ ନଗରରେ ତୁମ୍ଭମାନଙ୍କ ଭାର୍ଯ୍ୟା ଓ ବାଳକଗଣ ଓ ପଶୁମାନେ ବାସ କରିବେ; କାରଣ ମୁଁ ଜାଣେ, ତୁମ୍ଭମାନଙ୍କର ଅନେକ ପଶୁ ଅଛି। ");
INSERT INTO ory_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ଏଉତ୍ତାରେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ଭ୍ରାତୃଗଣକୁ ତୁମ୍ଭମାନଙ୍କ ତୁଲ୍ୟ ବିଶ୍ରାମ ଦେଲେ ଓ ଯର୍ଦ୍ଦନର ସେପାରିରେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଯେଉଁ ଦେଶ ସେମାନଙ୍କୁ ଦେବେ, ସେମାନେ ମଧ୍ୟ ସେହି ଦେଶ ଅଧିକାର କଲେ ତୁମ୍ଭେମାନେ ପ୍ରତ୍ୟେକେ ମୋହର ଦତ୍ତ ଆପଣା ଆପଣା ଅଧିକାରକୁ ଫେରିଯିବ।” ");
INSERT INTO ory_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ଆଉ ମୁଁ ସେହି ସମୟରେ ଯିହୋଶୂୟଙ୍କୁ ଆଜ୍ଞା ଦେଇ କହିଲି, “ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଏହି ଦୁଇ ରାଜାଙ୍କ ପ୍ରତି ଯାହା କରିଅଛନ୍ତି, ତୁମ୍ଭେ ତାହା ସ୍ୱଚକ୍ଷୁରେ ଦେଖିଅଛ; ତୁମ୍ଭେ ପାର ହୋଇ ଯେଉଁ ଯେଉଁ ରାଜ୍ୟ ବିରୁଦ୍ଧରେ ଯାଉଅଛ, ସେସବୁ ରାଜ୍ୟ ପ୍ରତି ସଦାପ୍ରଭୁ ତଦ୍ରୂପ କରିବେ। ");
INSERT INTO ory_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ତୁମ୍ଭେମାନେ ସେମାନଙ୍କୁ ଭୟ କରିବ ନାହିଁ; କାରଣ ଯେ ତୁମ୍ଭମାନଙ୍କ ସପକ୍ଷରେ ଯୁଦ୍ଧ କରନ୍ତି, ସେହି ସଦାପ୍ରଭୁ ତ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଅଟନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ସେହି ସମୟରେ ମୁଁ ସଦାପ୍ରଭୁଙ୍କୁ ବିନତି କରି କହିଲି, ");
INSERT INTO ory_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“ହେ ପ୍ରଭୋ ସଦାପ୍ରଭୋ, ତୁମ୍ଭେ ଆପଣା ଦାସ ନିକଟରେ ଆପଣା ମହିମା ଓ ବଳବାନ ହସ୍ତ ପ୍ରକାଶ କରିବାକୁ ଆରମ୍ଭ କରିଅଛ; ତୁମ୍ଭର କ୍ରିୟା ତୁଲ୍ୟ ଓ ତୁମ୍ଭର ପରାକ୍ରାନ୍ତ କର୍ମ ତୁଲ୍ୟ ଯେ କରିପାରେ, ସ୍ୱର୍ଗରେ କି ମର୍ତ୍ତ୍ୟରେ ଏପରି ଆଉ କିଏ ଅଛି? ");
INSERT INTO ory_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ମୁଁ ବିନୟ କରୁଅଛି, ମୋତେ ସେପାରିକି ଯିବାକୁ ଓ ଯର୍ଦ୍ଦନର ସେପାରିସ୍ଥିତ ସେହି ଉତ୍ତମ ଦେଶ, ସେହି ରମଣୀୟ ପର୍ବତ ଓ ଲିବାନୋନ ଦେଖିବାକୁ ଦିଅ।” ");
INSERT INTO ory_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ମାତ୍ର ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ସକାଶୁ ମୋʼ ଉପରେ କ୍ରୋଧ କଲେ ଓ ମୋʼ କଥା ଶୁଣିଲେ ନାହିଁ; ଆଉ ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, “ତୁମ୍ଭର ଯଥେଷ୍ଟ ହେଲାଣି ଏ ବିଷୟରେ ଆମ୍ଭକୁ ଆଉ କୁହ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ପିସ୍ଗାର ଶୃଙ୍ଗକୁ ଚଢ଼ି ଯାଅ, ଆଉ ପଶ୍ଚିମ ଓ ଉତ୍ତର ଓ ଦକ୍ଷିଣ ଓ ପୂର୍ବ ଆଡ଼େ ଅନାଇ ଦେଖ ଓ ଆପଣା ଚକ୍ଷୁରେ ତାହା ନିରୀକ୍ଷଣ କର; କାରଣ ତୁମ୍ଭେ ଏହି ଯର୍ଦ୍ଦନ ପାର ହେବ ନାହିଁ। ");
INSERT INTO ory_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ମାତ୍ର ଯିହୋଶୂୟକୁ ଆଜ୍ଞା ଦିଅ ଓ ତାହାକୁ ସାହସ ଦିଅ ଓ ତାହାକୁ ବଳବାନ କରାଅ; କାରଣ ସେ ଏହି ଲୋକମାନଙ୍କର ଆଗେ ଆଗେ ପାର ହୋଇଯିବ; ପୁଣି ତୁମ୍ଭେ ଯେଉଁ ଦେଶ ଦେଖିବ, ତାହା ସେ ସେମାନଙ୍କୁ ଅଧିକାର କରାଇବ।” ");
INSERT INTO ory_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ଏହିରୂପେ ଆମ୍ଭେମାନେ ବେଥ୍-ପିୟୋର ସମ୍ମୁଖସ୍ଥିତ ଉପତ୍ୟକାରେ ବାସ କଲୁ। ");
INSERT INTO ory_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ଏବେ ହେ ଇସ୍ରାଏଲ, ମୁଁ ଯେଉଁ ଯେଉଁ ବିଧି ଓ ଶାସନ ପାଳନ କରିବା ପାଇଁ ତୁମ୍ଭମାନଙ୍କୁ ଶିକ୍ଷା ଦେଉଅଛି, ତହିଁରେ ମନୋଯୋଗ କର; ତାହା କଲେ ତୁମ୍ଭେମାନେ ବଞ୍ଚିବ ଆଉ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପୂର୍ବପୁରୁଷଗଣର ପରମେଶ୍ୱର ତୁମ୍ଭମାନଙ୍କୁ ଯେଉଁ ଦେଶ ଦେବେ, ତହିଁରେ ପ୍ରବେଶ କରି ତାହା ଅଧିକାର କରିବ। ");
INSERT INTO ory_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ ଯାହା ଆଜ୍ଞା କରୁଅଛି, ସେହି ବାକ୍ୟରେ ତୁମ୍ଭେମାନେ କିଛି ମିଶାଇବ ନାହିଁ, କିଅବା ତହିଁରୁ କିଛି ଊଣା କରିବ ନାହିଁ, ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ ଯାହା ଯାହା ଆଜ୍ଞା କରୁଅଛି, ତୁମ୍ଭେମାନେ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କର ସେହି ସବୁ ଆଜ୍ଞା ପାଳନ କର। ");
INSERT INTO ory_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","ବାଲ୍‍-ପିୟୋର ବିଷୟରେ ସଦାପ୍ରଭୁ ଯାହା କଲେ, ତାହା ତୁମ୍ଭମାନଙ୍କ ଚକ୍ଷୁ ଦେଖିଅଛି; କାରଣ ସଦାପ୍ରଭୁ ତୁମ୍ଭ ପରମେଶ୍ୱର ବାଲପିୟୋରର ପଶ୍ଚାଦ୍‍ଗାମୀ ସମସ୍ତ ଲୋକଙ୍କୁ ତୁମ୍ଭ ମଧ୍ୟରୁ ବିନଷ୍ଟ କରିଅଛନ୍ତି। ");
INSERT INTO ory_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ମାତ୍ର ତୁମ୍ଭେମାନେ ଯେତେ ଲୋକ ସଦାପ୍ରଭୁ ତୁମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱରଙ୍କଠାରେ ଆସକ୍ତ ହେଲ, ତୁମ୍ଭମାନଙ୍କର ସେହି ପ୍ରତ୍ୟେକ ଜଣ ଆଜି ପର୍ଯ୍ୟନ୍ତ ଜୀବିତ ଅଛ। ");
INSERT INTO ory_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","ଦେଖ, ସଦାପ୍ରଭୁ ମୋହର ପରମେଶ୍ୱର ମୋତେ ଯେପରି ଆଜ୍ଞା ଦେଲେ, ମୁଁ ତୁମ୍ଭମାନଙ୍କୁ ସେପରି ବିଧି ଓ ଶାସନ ଶିକ୍ଷା ଦେଇଅଛି; ତୁମ୍ଭେମାନେ ଯେଉଁ ଦେଶ ଅଧିକାର କରିବାକୁ ଯାଉଅଛ, ତହିଁ ମଧ୍ୟରେ ତୁମ୍ଭମାନଙ୍କୁ ସେହିପରି ବ୍ୟବହାର କରିବାକୁ ହେବ। ");
INSERT INTO ory_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ଏଣୁ ତୁମ୍ଭେମାନେ ତାହାସବୁ ପାଳନ କର; କାରଣ ନାନା ଦେଶୀୟ ଲୋକମାନଙ୍କ ସାକ୍ଷାତରେ ଏହା ହିଁ ତୁମ୍ଭମାନଙ୍କର ଜ୍ଞାନ ଓ ବୁଦ୍ଧି ସ୍ୱରୂପ ହେବ; ସେମାନେ ଏହିସବୁ ବିଧି ଶୁଣି କହିବେ, “ଏହି ମହାଗୋଷ୍ଠୀ ନିତାନ୍ତ ଜ୍ଞାନବାନ ଓ ବୁଦ୍ଧିମାନ ଲୋକ ଅଟନ୍ତି।” ");
INSERT INTO ory_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","ଯେହେତୁ ଆମ୍ଭେମାନେ ଯେକୌଣସି ସମୟରେ ପ୍ରାର୍ଥନା କରୁ, ସେସମୟରେ ସଦାପ୍ରଭୁ ଆମ୍ଭମାନଙ୍କ ପରମେଶ୍ୱର ଯେପରି ଆମ୍ଭମାନଙ୍କର ନିକଟବର୍ତ୍ତୀ ହୁଅନ୍ତି, ସେପରି ଆଉ କେଉଁ ମହାଗୋଷ୍ଠୀର ପରମେଶ୍ୱର ସେମାନଙ୍କର ନିକଟବର୍ତ୍ତୀ ହୁଅନ୍ତି? ");
INSERT INTO ory_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ପୁଣି ମୁଁ ଆଜି ତୁମ୍ଭମାନଙ୍କ ସାକ୍ଷାତରେ ଯେଉଁ ସମସ୍ତ ବ୍ୟବସ୍ଥା ଦେଉଅଛି, ତାହା ତୁଲ୍ୟ ଯଥାର୍ଥ ବିଧି ଓ ଶାସନ ଆଉ କେଉଁ ମହାଗୋଷ୍ଠୀର ଅଛି? ");
INSERT INTO ory_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","କେବଳ ନିଜ ବିଷୟରେ ସାବଧାନ ହୁଅ ଓ ନିଜ ପ୍ରାଣକୁ ଯତ୍ନପୂର୍ବକ ରକ୍ଷା କର, ନୋହିଲେ ଯାହା ତୁମ୍ଭର ଚକ୍ଷୁ ଦେଖିଅଛି, ତାହା ତୁମ୍ଭେ ପାସୋରି ଯିବ ଓ ତାହା ଜୀବନ ସାରା ତୁମ୍ଭ ହୃଦୟରୁ ଲୋପ ପାଇବ; ମାତ୍ର ତୁମ୍ଭେ ଆପଣା ପୁତ୍ରପୌତ୍ରମାନଙ୍କୁ ତାହା ଶିଖାଅ। ");
INSERT INTO ory_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ଯେଉଁ ଦିନ ତୁମ୍ଭେ ହୋରେବରେ ସଦାପ୍ରଭୁ ତୁମ୍ଭ ପରମେଶ୍ୱରଙ୍କ ଛାମୁରେ ଠିଆ ହୋଇଥିଲ, ସେତେବେଳେ ସଦାପ୍ରଭୁ ମୋତେ କହିଲେ, “ଲୋକମାନଙ୍କୁ ଆମ୍ଭ ନିକଟରେ ଏକତ୍